﻿USE sofia;
DROP TABLE IF EXISTS sofia.gqr_vpl;
CREATE TABLE gqr_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES gqr_vpl WRITE;
INSERT INTO gqr_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ginn kaw lə Jeju Kirisitɨ kɨ ngonnkaw *Dabidɨ, kɨ ngonnkaw *Abiraham ə to kin: ");
INSERT INTO gqr_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abiraham ojɨ *Isakɨ, Isakɨ ojɨ *Jakobɨ, Jakobɨ ojɨ Juda kɨ ngannkon’a’gɨ. ");
INSERT INTO gqr_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda in kɨ Tamar oji Peresɨ kɨ Jara, Peresɨ ojɨ Esirom, Esirom ojɨ Aram, ");
INSERT INTO gqr_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram ojɨ Aminadabɨ, Aminadabɨ ojɨ Nason, Nason ojɨ Salmon, ");
INSERT INTO gqr_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon in kɨ Rahabɨ oji Bowajɨ, Bowajɨ in kɨ Rutɨ oji Obedɨ, Obedɨ ojɨ Jese, ");
INSERT INTO gqr_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jese ojɨ ngar Dabidɨ. Dabidɨ taa ne Uri ojɨ’n Salomon, ");
INSERT INTO gqr_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","*Salomon ojɨ Robowam, Robowam ojɨ Abiya, Abiya ojɨ Asa, ");
INSERT INTO gqr_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa ojɨ Jojapa, Jojapa ojɨ Joram, Joram ojɨ Ojiyasɨ, ");
INSERT INTO gqr_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ojiyasɨ ojɨ Jowatam, Jowatam ojɨ Akajɨ, Akajɨ ojɨ Ejəkiyasɨ, ");
INSERT INTO gqr_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ejəkiyasɨ Ojɨ Manasa, Manasa ojɨ Amon, Amon ojɨ Jojiyasɨ, ");
INSERT INTO gqr_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Jojiyasɨ ojɨ Jekoniyasɨ kɨ ngannkon’a’gɨ. Dɔkagilo’ə’tɨ kin ə uwəi de’gɨ kɨ Jerujalem awi se’de ɓər Babilon’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Lokɨ awi se’de Babilon’tɨ, Jekoniyasɨ ojɨ Salatiyel, Salatiyel ojɨ Jorobabel, ");
INSERT INTO gqr_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Jorobabel ojɨ Abiyudɨ, Abiyudɨ ojɨ Eliyakim, Eliyakim ojɨ Ajɔr, ");
INSERT INTO gqr_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ajɔr ojɨ Sadokɨ, Sadokɨ ojɨ Akim, Akim ojɨ Eliyudɨ, ");
INSERT INTO gqr_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliyudɨ ojɨ Eliyajar, Eliyajar ojɨ Matan, Matan ojɨ Jakobɨ, ");
INSERT INTO gqr_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jakobɨ ojɨ Jisepɨ kɨ ngaw Mari. Ningə Mari ojɨ Jeju kɨ ɓari’ə Kirisitɨ, *De kɨ Luwə mbət’ə. ");
INSERT INTO gqr_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ulə ngirə dɔ Abiraham’tɨ bitɨ te’n dɔ Dabidɨ’tɨ, ginn kojɨ in dɔgɨ gidə in sɔ, ə in dɔ Dabidɨ’tɨ bitɨ kaw ɓər Babilon’tɨ, in ginn kojɨ dɔgɨ gidə sɔ, taa in dɔ kaw ɓər Babilon’tɨ bitɨ kojɨ Kirisitɨ’tɨ, in ginn kojɨ dɔgɨ gidə in sɔ tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Gorow kojɨ Jeju Kirisitɨ ə to kin. Kon’a Mari in njenduwə lə Jisepɨ kɨ uwə dɔ’a. Ningə, lokɨ ingəi nan dene kɨ dingəm el ɓay ə, Mari in səm kɨ tɔgɨ lə Ndil Luwə. ");
INSERT INTO gqr_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Lo kin’tɨ non be, Jisepɨ kɨ njenduwə lə Mari, in de kɨ dana, ndigɨ kadɨ n’elta kin kɨ taga n’ulə’n rɔsɔl dɔ Mari’tɨ el, adɨ ɔjɨ me’ne’tɨ kadɨ n’inyəi nan kɨ Mari gidɨ kuwə par. ");
INSERT INTO gqr_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Lokɨ ɔjɨ ta kin be me’ne’tɨ ningə, malayka lə Burəɓe te bus me nii’tɨ el’ə ene: «Jisepɨ, ngonnkaw Dabidɨ, ɓol el kadɨ taa Mari ne’i’tɨ, tadɔ ngonn kɨ to me’i’tɨ kin, in ngonn kɨ re kɨ gorow lə Ndil Luwə. ");
INSERT INTO gqr_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Mari a ojɨ ngonn kɨ dingəm, ningə a ində tɔ’a nan Jeju, tadɔ in ə in de kɨ a ajɨ de’gɨ lə’ne me majel’gɨ’tɨ lə’de.» ");
INSERT INTO gqr_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Nya’gɨ kin pətɨ a rai nya be kadɨ ta kɨ Burəɓe el kɨ ta njekeltakita’a’tɨ kete nu kin tɔlta’ne. ");
INSERT INTO gqr_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Burəɓe el ene: «Oyi ngonn kɨ mandɨ kɨ gər dingəm el ɓay a in səm, A ɔjɨ ngonn kɨ dingəm, Ningə a ɓari’ə Emanuwel, Kɨ kɔr ginn’ə nan: “Luwə in se’je”.» ");
INSERT INTO gqr_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Lokɨ Jisepɨ ndəl dɔ ɓi’tɨ, ra tokɨ malayka lə Burəɓe el’n’ə, adɨ taa Mari ne’ne’tɨ, re si’ə kəy. ");
INSERT INTO gqr_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Nan gər’ə kɨ dene kɨ dingəm’tɨ el, bitɨ kadɨ Mari ojɨ’n ngonn. Ojɨ ngonn kɨ dingəm, adɨ Jisepɨ ində tɔ’a nan Jeju. ");
INSERT INTO gqr_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Oji Jeju Betilehem, dɔnangɨ kɨ Jude’tɨ, dɔkagilo konɓe’tɨ lə ngar Erodɨ. Go koj’o’tɨ, nje nyagər’gɨ kɨ dɔ mee’gɨ’tɨ, in lo kuwə kadɨ’tɨ rei Jerujalem, ");
INSERT INTO gqr_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ningə dəji eyina: «Ngar lə *Juwipɨ’gɨ kɨ oji’ə kin in ra be ə? J’oo mee li’ə te lo kuwə kadɨ’tɨ ə jɨ re kadɨ j’ɔsi məkəsɨ’je nanga non’a’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Lokɨ Ngar *Erodɨ oo ta kin, me’ə gangɨ mann, nan’tɨ kɨ de’gɨ kɨ Jerujalem’tɨ ba pətɨ. ");
INSERT INTO gqr_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Be ə, ngar kaw kibo’gɨ lə njekujənyamosɨ kadikare’gɨ kɨ njendo ndukun’gɨ lə Luwə, dəjɨ’de ke lo kɨ ra be ə a oji Kirisitɨ’tɨ kɨ in De kɨ Luwə mbət’ə wa? ");
INSERT INTO gqr_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ə eli’ə eyina: «A oji’ə Betilehem’tɨ, dɔnangɨ kɨ Jude’tɨ, tadɔ ta kɨ njekeltakita Luwə’tɨ el ə to kin: ");
INSERT INTO gqr_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“In de’gɨ kɨ Betilehem kɨ dɔnangɨ’tɨ kɨ Juda, Kadɨ in gəri tokɨ rɔta’tɨ, Ɓe lə’se in kɨ nda’a goto el jagɨ dann ɓebo’gɨ’tɨ kɨ dɔnangɨ kɨ Jude’tɨ, kɨ nda’de to’tɨ, Tadɔ ngar kɨ njekɔrnon de’gɨ lə’m, Isirayel’gɨ a te dann’se’tɨ.”» ");
INSERT INTO gqr_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Lo kin’tɨ, Erodɨ ɓar nje nyagər’gɨ kɨ dɔ mee’gɨ’tɨ gidɨ kuwə, dəjɨ’de ke dɔkagilo kɨ ra inɓe bangɨ ə mee te’n wa? ");
INSERT INTO gqr_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ningə go’tɨ, ulə’de Betilehem’tɨ ene: «Ai dəji ta kɨ rɔta’tɨ dɔ ngonn’tɨ kin. Lokɨ ingəi’ə ningə, rei eli’m’in adɨ m’in kaa m’aw m’ɔsɨ məkəsɨ’m nanga non’a’tɨ tɔ.» ");
INSERT INTO gqr_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Go ta’tɨ lə ngar kin ningə, nje nyagər’gɨ osi dɔ row’tɨ isɨ awi. Ə lokɨ isɨ awi ningə nyɨ oyi mee kɨ oyi’ə lo kuwə kadɨ’tɨ kakin ə ra njiyə non’de’tɨ. Njiyə re te dɔ kəy’tɨ kɨ ngonn to’tɨ ningə, ra lokatɨ. ");
INSERT INTO gqr_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Lokɨ oyi mee kin, rɔ’de nəl’de ngayn. ");
INSERT INTO gqr_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ə uri me kəy’tɨ ningə, oyi ngonn in kɨ kon’a Mari, ningə ɔsi məkəsɨ’de nanga, piti’ə. Go’tɨ, tei ta ɓɔl’gɨ lə’de, adi’ə ɔr, kɨ ndujɨ kagɨ kɨ ətɨ majɨ, kɨ nom kagɨ. ");
INSERT INTO gqr_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Go nya’gɨ’tɨ kin, Luwə el’de me nii’tɨ kadɨ təli gogɨ kɨ row kɨ dɔ Erodɨ’tɨ el. Be ə, təli awi ɓe lə’de kɨ row kɨ rangɨ. ");
INSERT INTO gqr_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Lokɨ nje nyagər’gɨ awi ningə, malayka lə Burəɓe te me nii’tɨ el Jisepɨ ene: «Ində taa un ngonn in kɨ kon’a, ə anyi aw se’de Ejipitɨ. Aw sɨ’tɨ non bitɨ kadɨ m’in m’el’i ɓay taa in təl re se’de, tadɔ Erodɨ a sangɨ kadɨ n’tɔl ngonn kin.» ");
INSERT INTO gqr_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Jisepɨ ində taa kondɔ’tɨ non, un ngonn in kɨ kon’a, ningə anyi aw se’de Ejipitɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Sɨ’tɨ non bitɨ koy Erodɨ, adɨ ta kɨ Burəɓe el kɨ ndu njekeltakita’a’tɨ ene: «M’ɓar ngonn’m kadɨ te me ɓe’tɨ kɨ Ejipitɨ kɔ» kin tɔlta’ne. ");
INSERT INTO gqr_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Lokɨ Erodɨ oo kadɨ nje nyagər’gɨ ədi’ə, wongɨ ra’a ngayn. Wongɨ ra’a adɨ un ndu’ne kadɨ tɔli ngann’gɨ kɨ kasɨ kɨ in dɔ ɓal kɨ joo’tɨ təl kɨ nanga ne pətɨ me ɓe’tɨ kɨ Betilehem, kɨ ngann ɓe’gɨ kɨ gidɨ’tɨ. Ɓal kin in kigo dɔkagilo’tɨ kɨ nje nyagər’gɨ ɔji’ə’n’ə. ");
INSERT INTO gqr_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Be ə, ta lə njekeltakita Luwə’tɨ Jeremi, kɨ el tɔl’n ta’ne. Jeremi ene: ");
INSERT INTO gqr_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","«Ndu’de ɓar me ɓe’tɨ kɨ Rama, non’gɨ kɨ ndingərɔ’gɨ kɨ ətɨ ɓol ngayn. Rasel non ngann’ne’gɨ, Ndigɨ kadɨ de sɔl me’ne el, Tadɔ gotoi.» ");
INSERT INTO gqr_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Lokɨ Erodɨ oy nga ningə, go koy’o’tɨ, malayka lə Burəɓe te kɨ rɔ Jisepɨ’tɨ, Ejipitɨ’tɨ me nii’tɨ, el’ə ene: ");
INSERT INTO gqr_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","«Ində taa, un ngonn kɨ kon’a, ə təli awi dɔnangɨ Isirayel’tɨ gogɨ, tadɔ de’gɨ kɨ isɨ sangi kadɨ n’tɔli ngonn kaa oyi nga.» ");
INSERT INTO gqr_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Jisepɨ ində taa, un ngonn kɨ kon’a, ə təli awi dɔnangɨ Isirayel’tɨ gogɨ. ");
INSERT INTO gqr_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Nan lokɨ oo kadɨ Arkelosɨ onɓe dɔ Jude’tɨ tor baw’ne Erodɨ’tɨ, ɓol ra’a kadɨ aw Jude’tɨ. Be ə, Luwə el’ə me nii’tɨ ad’a aw Galile’tɨ yo. ");
INSERT INTO gqr_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Aw isɨ me ɓebo’tɨ kɨ ɓari’ə Najaretɨ. Be kadɨ ta kɨ de’gɨ kɨ njekeltakita Luwə’tɨ eli eyina: «A ɓari’ə de kɨ Najaretɨ’tɨ kin tɔl’n ta’ne.» ");
INSERT INTO gqr_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ɓal’gɨ dər go’tɨ, Jan Batisɨ te, iləmbər diləlo’tɨ kɨ Jude ene: ");
INSERT INTO gqr_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","«Inyəi gorow njiyə’se’gɨ kɨ majel kɔ, tadɔ Konɓe lə Luwə in ndəkba.» ");
INSERT INTO gqr_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jan Batisɨ ə, in de kɨ njekeltakita Luwə’tɨ Ejay elta dɔ’a’tɨ ene: «Ndu de madɨ ɓar diləlo’tɨ ene: “Rai gorow lə Burəɓe! Rai gorow li’ə adɨ ra njururu!”» ");
INSERT INTO gqr_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jan ulə ku kɨ in kɨ ra kɨ bin jambal rɔ’ne’tɨ, ningə dɔ me’ne kɨ ndar tɔ. Nyakusɔ’a in giwiri’gɨ kɨ təjɨ. ");
INSERT INTO gqr_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","De’gɨ kɨ ɓebo Jerujalem’tɨ, kɨ dɔnangɨ Jude’tɨ pətɨ, kɨ dɔnangɨ kɨ kadɨ ba Jurden’tɨ pətɨ, rei rɔ Jan’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Rei tɔri ndu’de dɔ majel’gɨ’tɨ lə’de, adɨ Jan ra’de batəm me ba Jurden’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Lokɨ Jan oo adɨ *Parisɨ’gɨ kɨ *Sadusi’gɨ ngayn rei kadɨ ra’de batəm ningə, el’de ene: «Ingɨ kɨ mann’se majel to mann lii pir’gɨ be kam, nan ɔjɨ’se row kadɨ anyinan wongɨ lə Luwə kɨ a re ə? ");
INSERT INTO gqr_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Majɨ kadɨ kulə ra’se tɔjɨ kadɨ in de’gɨ kɨ inyəi gorow njiyə’se kɨ majel kɔ. ");
INSERT INTO gqr_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ningə, kadɨ inyəi ta kɔjɨ me’se’tɨ kene: “J’in ngann kaw Abiraham.” Tadɔ, adɨ m’el’se, Luwə asɨ kadɨ a təl gajɨ mbal’gɨ kam ngann kaw Abiraham’tɨ kare. ");
INSERT INTO gqr_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Kɨ ngɔsine kin, kungə in ndəkba kadɨ tugə kagɨ’gɨ ngirə’de’tɨ gangɨ nga. Kagɨ kɨ ra kɨ andɨ majɨ el ə, a tugəi’ə kadɨ iləi’ə me por’tɨ kɔ. ");
INSERT INTO gqr_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","M’in, m’ra’se batəm me mann’tɨ, kadɨ tɔjɨ tokɨ inyəi gorow njiyə’se’gɨ kɨ majel kɔ, nan de kɨ a re go’m’tɨ, in nje tɔgɨ kɨ utə’m sanyi. M’asɨ kadɨ sa kɨ nja’a’tɨ kaa m’ɔr el. In a ra’se batəm me Ndil Luwə’tɨ, kɨ me por’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Uwə keh to nya ji’ne’tɨ kadɨ to’n kandɨ ko kɨ majɨ, ɔy me dam’tɨ, ningə ulə tisə por. In por kɨ a oy el ratata.» ");
INSERT INTO gqr_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Lo kin’tɨ non, Jeju in Galile’tɨ, re ta ba Jurden’tɨ rɔ Jan’tɨ, kadɨ ra’a batəm. ");
INSERT INTO gqr_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Nan Jan ge kɔdɨ el, adɨ el ene: «In m’in ə kadɨ in, ra’m batəm, ningə in yo ta in təl re rɔ’m’tɨ kadɨ m’ra’i batəm ɓay tɔ wa?» ");
INSERT INTO gqr_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Nan Jeju el’ə ene: «Kɨ ngɔsine kin, in ra be, tadɔ in kigo’ə kin ə j’a jɨ tɔl’n ta ndigɨ lə Luwə.» Be ə, Jan ndigɨ dɔ’tɨ, ra’a’n’ə batəm. ");
INSERT INTO gqr_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Lokɨ Jeju ra batəm taa par, ə te me mann’tɨ ningə, low’ə’tɨ non, dɔran te ta’ne, adɨ oo Ndil Luwə risɨ to dər dum be re isɨ dɔ’a’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ningə, ndu ta madɨ te dɔran’tɨ, ene: «In kam in Ngonn’m njendigɨ lə’m, kɨ rɔ’m nəl’m dɔ’a’tɨ ngayn.» ");
INSERT INTO gqr_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Go’tɨ, Ndil Luwə ɔrnon Jeju aw si’ə diləlo’tɨ, kadɨ Su nan’a. ");
INSERT INTO gqr_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Jeju ɔgɨ rɔ’ne nyakusɔ, kondɔ dɔsɔ kɨ kadɨ, dɔsɔ, ə go’tɨ ɓo ra’a. ");
INSERT INTO gqr_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Lo kin’tɨ, Su, njenan de’gɨ ɔtɨ re rɔ’a’tɨ, el’ə ene: «Re in Ngonn lə Luwə ə, adɨ mbal’gɨ kin təli mapa adɨ m’oo.» ");
INSERT INTO gqr_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ə Jeju ilə’tɨ ene: «Ndangi me makitu’tɨ lə Luwə eyina: De a isɨ kɨ dɔ’ne taa kɨ takul nyakusɔ par el, nan kɨ takul ta’gɨ pətɨ kɨ tei ta Luwə’tɨ tɔ.» ");
INSERT INTO gqr_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Go’tɨ, Su aw kɨ Jeju me ɓebo’tɨ kɨ Jerujalem, kɨ in ɓebo kɨ to ta dangɨ tadɔ Luwə, aw si’ə jam dɔ Kəy’tɨ lə Luwə taa, ");
INSERT INTO gqr_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ningə el’ə ene: «Re in Ngonn lə Luwə ə, inyə ji’i taa osɨ adɨ m’oo. Tadɔ ndangi me makitu’tɨ lə Luwə eyina: “Luwə a adɨ ndu’ne malayka’gɨ lə’ne kadɨ a lai’nu dala ji’de’tɨ, kadɨ nja’i tugə mbal el”.» ");
INSERT INTO gqr_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jeju təl el’ə ene: «Ndangi me makitu’tɨ lə Luwə tɔ eyina: A nan Burəɓe Luwə lə’i el.» ");
INSERT INTO gqr_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Su təl aw kɨ Jeju dɔ mbal’tɨ kɨ ngal taa ngayn ɓay, ɔj’ɔ konɓe’gɨ kɨ dɔnangɨ’tɨ ne pətɨ, kɨ nyakingə’gɨ kɨ me’tɨ, ");
INSERT INTO gqr_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","ningə el’ə ene: «M’a m’ad’i nya’gɨ kin pətɨ, lokɨ re ɔsi məkəs’i nanga non’m’tɨ ə ulə tɔjɨ dɔ’m’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jeju təl el’ə ene: «In *Satan, ɔtɨ kɔ sanyi. Tadɔ ndangi me makitu’tɨ lə Luwə eyina: “A ɔsikurə Burəɓe Luwə’tɨ lə’i, ningə in kɨ kar’ne ba par ə a re non’a’tɨ kadɨ in gos’o.”» ");
INSERT INTO gqr_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Be ə, Su inyə Jeju ə ɔtɨ aw. Ningə malayka’gɨ rei rɔ Jeju’tɨ, rai si’ə. ");
INSERT INTO gqr_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Dɔkagilo madɨ, uwəi Jan dangay’tɨ, ə Jeju oo ta’a ningə, təl ɔr rɔ’ne aw Galile’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nan kin ə, inyə ɓebo kɨ Najaretɨ, ə aw isɨ Kapernayim’tɨ yo. Kapernayim kɨ in ɓebo kɨ ra kadɨ ba’tɨ kɨ Galile, dɔnangɨ’tɨ lə Jabulon ge kɨ Nepitali ge. ");
INSERT INTO gqr_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Be kadɨ tɔlta ta kɨ njekeltakita Luwə’tɨ Ejay el ene: ");
INSERT INTO gqr_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«In de’gɨ kɨ Dɔnangɨ Jabulon’tɨ kɨ dɔnangɨ Nepitali’tɨ, Kɨ sii ndəkba kadɨ babo’tɨ, Gidɨ ba Jurden’tɨ, In de’gɨ kɨ dɔnangɨ Galile’tɨ, Kɨ in de’gɨ kɨ in Juwipɨ’gɨ el! Uri mbi’se oyi: ");
INSERT INTO gqr_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","De’gɨ kɨ kete sii lo kɨ ndul’tɨ, Oyi kunjɨ kibo, Ningə de’gɨ kɨ kete sii ɓe lə yo, Kɨ in lo kɨ ndul kururu, Lo kunjɨ te dɔ’de’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Dɔ gangɨ lowə’tɨ kin, Jeju ulə ngirə kiləmbər ene: «Inyəi gorow njiyə’se’gɨ kɨ majel kɔ, tadɔ Konɓe lə Luwə in ndəkba rɔ’se’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ndɔ kare, Jeju ra njiyə kadɨ babo’tɨ, kɨ Galile ningə oo ngannkon’a’gɨ joo: adɨ in Simon kɨ ɓari’ə Piyər ingɨ kɨ ngonnkon’ne Andire kɨ in njendon kanjɨ’gɨ, a iləi bandɨ me mann’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jeju el’de ene: «Rei go’m’tɨ adɨ m’ndo’se, kadɨ in təli nje sangi de’gɨ adɨ m’in kadɨ ingəi kajɨ.» ");
INSERT INTO gqr_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Kalangiba, inyəi bandɨ’gɨ lə’de, ə awi uni go Jeju. ");
INSERT INTO gqr_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Jeju ɔtɨ kɨ kete nden ningə, oo ngannkon’nan’gɨ kɨ rangɨ joo: Jakɨ in kɨ Jan kɨ in ngann lə Jebede, sii me to’tɨ kɨ baw’de, isɨ rai go bandɨ’gɨ lə’de, ə ɓar’de. ");
INSERT INTO gqr_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Lokɨ Jeju ɓar’de ningə, kalangɨ ba, inyəi baw’de Jebede kɨ to, ə awi uni go Jeju. ");
INSERT INTO gqr_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jeju njiyə dɔnangɨ Galile’tɨ ba pətɨ, ndo nya de’gɨ me kəykawnan’gɨ’tɨ lə Juwipɨ’gɨ, iləmbər Poyta kɨ majɨ kɨ ɔjidɔ Konɓe lə Luwə, taa ajɨ njemonyi’gɨ kɨ njerɔto’gɨ kɨ dann de’gɨ’tɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Tɔɓar li’ə sanan dɔnangɨ’tɨ kɨ Siri ba pətɨ, adɨ rei kɨ de’gɨ pətɨ kɨ rɔ’de ra’de, njerɔto’gɨ kɨ dangɨ dangɨ, nje kɨ ndil’gɨ kɨ majel rai’de ge, njedamsil’gɨ ge kɨ njerɔkoy njururu’gɨ ge, adɨ ajɨ’de. ");
INSERT INTO gqr_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Bulə de’gɨ ngayn rei go Jeju’tɨ. Nje kin dɔnangɨ Galile’tɨ ge, dɔnangɨ Ɓebo’gɨ’tɨ kɨ Dɔgɨ ge, ɓebo Jerujalem ge, kɨ dɔnangɨ Jude’tɨ ge, kɨ dɔnangɨ kɨ gidɨ ba Jurden’tɨ ge. ");
INSERT INTO gqr_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Lokɨ Jeju oo bulə de’gɨ kin ningə, ɔtɨ aw isɨ dɔ mbal’tɨ, adɨ njendo’gɨ li’ə rei rɔ’a’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Lo kin’tɨ, Jeju ilə rɔ’ne ndo nya de’gɨ ene: ");
INSERT INTO gqr_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«Majikur in lə nje kɨ oyi rɔ’de kadɨ n’asi el takum Luwə’tɨ, tadɔ Konɓe lə Luwə in yan’de. ");
INSERT INTO gqr_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Majikur in lə nje kɨ isɨ nonyi ɓone, tadɔ lo ti ə Luwə a sɔl me’de. ");
INSERT INTO gqr_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Majikur in lə nje kɨ sɔli lɔm lɔm, tadɔ Luwə a adɨ’de dɔnangɨ kadikare’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Majikur in lə nje kɨ ɓo kɨ kundə ra nya kigo ndu Luwə’tɨ in me de’tɨ, tadɔ lo ti ə a ndanni. ");
INSERT INTO gqr_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Majikur in lə nje kɨ isɨ oyi kumtondoo lə de’gɨ, tadɔ Luwə a ra se’de majɨ. ");
INSERT INTO gqr_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Majikur in lə nje kɨ me’de in kare dɔ Luwə’tɨ, tadɔ a oyi Luwə kɨ kum’de. ");
INSERT INTO gqr_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Majikur in lə nje kɨ isɨ sangi row lapiya, tadɔ a ɓari’de ngann’gɨ lə Luwə. ");
INSERT INTO gqr_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Majikur in lə nje kɨ de’gɨ isɨ adi’de kon tadɔ nyara kɨ dana, tadɔ Konɓe lə Luwə in yan’de. ");
INSERT INTO gqr_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Majikur in lə’se lokɨ de’gɨ isɨ taji’se ge, isɨ adi’se kon ge, isɨ tətita dɔ’se’tɨ ge tadɔ lə’m. ");
INSERT INTO gqr_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Rai rɔnel, tiləi kole, tadɔ nyakugə goji’se in ngayn dɔran’gɨ’tɨ. *Njekeltakita Luwə’tɨ, kɨ rai kulə kete non’se’tɨ, ingəi kon kin be tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","«Ingɨ ə in katɨ kɨ dɔnangɨ’tɨ. Ningə kin ə mbann katɨ goto ə, de a ra bann ə kadɨ katɨ təl mbann gogɨ ɓay wa? Maj’a goto nga; a ɓuki’ə kɔ gidɨ lo’tɨ kadɨ de’gɨ njiyəi dɔ’tɨ par nga. ");
INSERT INTO gqr_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","«Ingɨ ə in kunjɨ kɨ dɔnangɨ’tɨ. Ningə ɓebo kɨ indəi’ə dɔ mbal’tɨ taa, asɨ kadɨ a iyə rɔ’ne el. ");
INSERT INTO gqr_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","De a ində por lambɨ’tɨ re’n kəy ə dow ngo dɔ’tɨ el. A ində dɔ nya’tɨ taa kadɨ de’gɨ kɨ me kəy’tɨ pətɨ oyi lo. ");
INSERT INTO gqr_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Be tɔ ə, kadɨ de’gɨ pətɨ oyi kunjɨ lə’se me nyara kɨ majɨ’tɨ. Lokɨ oyi nya ra’se kɨ majɨ ningə, a uləi tɔjɨ dɔ Baw’se Luwə’tɨ kɨ isɨ dɔran’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","«Majɨ kadɨ in məri tokɨ m’re kadɨ m’bujɨ ndukun’gɨ lə *Mojɨ eke ta lə njekeltakita Luwə’tɨ el. M’re tadɔ bujɨ’de el, nan m’re tadɔ tɔl ta’de yo. ");
INSERT INTO gqr_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Tokɨ rɔta’tɨ, m’el’se, kete non kadɨ dɔran in kɨ dɔnangɨ kin a gotoi kɔ, ngonn kur ta kɨ nden be, eke ngonn ndaja madɨ kɨ me ndukun’tɨ lə Luwə kɨ ndangi kɨ a ɔr kɔ goto. A to be bitɨ kadɨ nya’gɨ pətɨ kɨ ndangi me’tɨ rai nya. ");
INSERT INTO gqr_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","De kɨ aldɔ ngonn mbərkikində kɨ nden be dann mad’a’gɨ’tɨ, ə ndo de’gɨ kadɨ rai tokɨ in ra’n be tɔ ningə, a in kɨ du ngayn me Konɓe’tɨ lə Luwə tɔ. Nan de kɨ təl rɔ’ne go’tɨ, ə ndo de’gɨ, a in kibo me Konɓe’tɨ lə Luwə. ");
INSERT INTO gqr_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Adɨ m’el’se: kin ə nyara kɨ dana lə’se utə nya njendo ndukun’gɨ lə Luwə kɨ Parisɨ’gɨ el ə, a uri me Konɓe’tɨ lə Luwə el. ");
INSERT INTO gqr_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","«Ingɨ, in gəri majɨ tokɨ ndu ta el kaw’je’gɨ ene: “A tɔl de el, de kɨ tɔl madɨ’ne ningə, majɨ kadɨ awi si’ə non njegangɨ ta’gɨ’tɨ.”» ");
INSERT INTO gqr_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Nan m’in m’el’se: «De kɨ ra wongɨ kɨ ngonnkon’ne, majɨ kadɨ awi si’ə non njegangɨ ta’gɨ’tɨ; de kɨ tajɨ ngonnkon’ne “mbo”, majɨ kadɨ awi si’ə non njegangɨ ta’gɨ’tɨ kibo lə Juwipɨ’gɨ; ə de kɨ ɓar ngonnkon’ne “man”, majɨ kadɨ iləi’ə me por’tɨ kɨ bitɨ kɨ non’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Kin ə aw kɨ kadikare lə’i ringiri lo kilə kadikare’tɨ kadɨ Luwə, ə me’i olo dɔ’tɨ kadɨ ngonnkon’i aw sə’i kɨ ta madɨ ningə, ");
INSERT INTO gqr_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","majɨ kadɨ inyə kadikare kin non ringiri’tɨ, ə in re aw ulə noji nan’tɨ si’ə ɓay taa in təl re un kadikare lə’i adɨ Luwə. ");
INSERT INTO gqr_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","«Kin ə isɨ awi lo gangita’tɨ kɨ nje ta lə’i ə, lokɨ in dɔ row’tɨ ɓay kin ə, in sangɨ row kadɨ ndu’se osɨ go nan’tɨ si’ə kalangɨ, nan to aw sə’i uləi ji njegangita’tɨ, adɨ njegangɨ ta uni uləi ji njerɔ’gɨ’tɨ, adɨ njerɔ’gɨ awi sə’i iləi’nu dangay’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Tokɨ rɔta’tɨ adɨ m’el’i, a te lo kin’tɨ el bitɨ kadɨ ugə dɔboy sisi ɓay taa a inyəi’nu taa. ");
INSERT INTO gqr_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","«In gəri ndu kɨ el ene: “A uwə marum el,” kin majɨ. ");
INSERT INTO gqr_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Nan m’in m’el’se: “De kɨ gon dene kɨ kumnda ə, uwə si’ə marum me’ne’tɨ nga.” ");
INSERT INTO gqr_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Kin ə kum’i kɨ dɔjikɔl’i’tɨ rai adɨ osɨ me majel’tɨ ə, ɔr’ɔ ilə kɔ sanyi. Tadɔ in sotɨ kadɨ ngonn rɔ’i kare goto, utə kadɨ iləi darɔ’i ba pətɨ me por’tɨ kɨ bitɨ kɨ non’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Kin ə ji kɔl’i rai adɨ osɨ me majel’tɨ ə, in gang’a ilə kɔ sanyi. Tadɔ, in sotɨ kadɨ ngonn darɔ’i kare goto, utə kadɨ iləi darɔ’i ba pətɨ me por’tɨ kɨ bitɨ kɨ non’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","«In gəri kadɨ ndukun el ɓay tɔ ene: “Re de tuwə ne’ne ningə, kadɨ ad’a makitu gangɨ nan.” ");
INSERT INTO gqr_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Nan m’in m’el’se tokɨ: “Re de tuwə ne’ne tadɔ nya kɨ rangɨ, um in ta lə kaya kɨ ra el ə, de’ə kin sur’ə ta kuwə marum’tɨ. A re de ta dene kɨ ngaw’a tuwə ningə, de’ə kin təl njekuwə marum tɔ.” ");
INSERT INTO gqr_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","«Ndu ta el kaw’je’gɨ kete ɓay tɔ ene: “Re iw rɔ’i dɔ nya madɨ’tɨ ə, ra dɔ’tɨ, kadɨ in ra nya kɨ iw rɔ’i dɔ’tɨ non Burəɓe’tɨ.” ");
INSERT INTO gqr_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Nan m’in m’el’se tokɨ a iw rɔ’i el to kiw el. A iw rɔ’i kɨ dɔran el, tadɔ in kumbər kisɨ Luwə; ");
INSERT INTO gqr_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","a iw rɔ’i kɨ dɔnangɨ el, tadɔ in kumbər kində nja’a; a iw rɔ’i kɨ Jerujalem el, tadɔ in ɓebo lə Ngar kibo; ");
INSERT INTO gqr_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","a iw rɔ’i kɨ jam dɔ’i el, tadɔ in asɨ kadɨ in təl bin dɔ’i kare be kaa kɨ nda’tɨ eke kɨ ndul’tɨ el. ");
INSERT INTO gqr_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Re ta lə’se in oyo ningə, rai dɔ oyo’tɨ, re ta lə’se in jagɨ ningə, rai dɔ jagɨ’tɨ par tɔ, ə ndəgɨ ta pətɨ kɨ a re go’tɨ kin in rɔ Su’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","«In gər kadɨ ndu ta el ene: “Re de tɔ kum madɨ’ne ningə, in kadɨ tokɨ tɔ kum’ə tɔ, a re de tətɨ ngangɨ madɨ’ne ningə, in kadɨ tokɨ tətɨ ngang’a tɔ.” ");
INSERT INTO gqr_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Nan m’in m’el’se kadɨ in tanyi rɔ nje mendul el. Re de ində dow kɔt’i kɨ kɔl ə, in yətɨ dowə kɨ gəl ad’a ində ɓay. ");
INSERT INTO gqr_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Re de aw sə’i non njegangita’tɨ kadɨ taa ku kɨ gɔjɨ lə’i ə, ad’a in kɨ ngal dɔ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Re de ində tɔgɨ dɔ’i’tɨ kadɨ njiyə nja’i dər ə, njiyə si’ə njay dər joo. ");
INSERT INTO gqr_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","De kɨ ra kɨ dəj’i nya ə ad’a, ningə re de tunəi nya ə ɔg’ɔ el tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","«In gəri tokɨ ndu ta el ene: “A in ndigɨ de mad’i, nan a ɔsɨ ta njeban lə’i.” ");
INSERT INTO gqr_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Nan, m’in m’el’se: In ndigɨ njeban’gɨ lə’se, elita kɨ Luwə tadɔ lə nje kɨ isɨ adi’se kon. ");
INSERT INTO gqr_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","In rai be kadɨ in ngann lə Baw’se Luwə kɨ nje kisi dɔran’tɨ. Tadɔ adɨ kadɨ ɔsi dɔ nje memajɨ’tɨ kɨ nje memajel. Adɨ ndi ədɨ dɔ njera nya’tɨ kɨ dana, kɨ njera nya’tɨ kɨ dana el. ");
INSERT INTO gqr_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Kin ə in ndigɨ nje kɨ ndigɨ’se tɔ par ə, nyakugə goji ri ə Luwə a adɨ’se wa? *Njetalambo’gɨ kaa rai be tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Kin ə rai lapiya ngannkon’se’gɨ par ə, ri ə to ta dangɨ ə rai wa? Tadɔ nje gər Luwə el kaa rai be tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ningə ingɨ, majɨ kadɨ in ndigɨ de’gɨ adɨ osɨ taga panyi tokɨ Baw’se Luwə kɨ dɔran’tɨ ndigɨ de’gɨ adɨ osɨ taga panyi kin be tɔ.» ");
INSERT INTO gqr_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","«Kadɨ oyi majɨ, kin ə re isɨ rai nya kɨ ndu Luwə ndigɨ kadɨ rai ningə, majɨ kadɨ rai takum de’gɨ’tɨ kɨ kadɨ oyi’se el. Re rai be ningə, Baw’se kɨ isɨ dɔran’tɨ, a adɨ’se nyakugə goji lə’se el. ");
INSERT INTO gqr_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Kin ə in ra kɨ njendoo ə, kadɨ tugə gəngɨ dɔ’tɨ kadɨ de’gɨ oyi el. In rai tokɨ njekədikum de’gɨ isɨ rai ginn kəykawnan’gɨ’tɨ lə Juwipɨ’gɨ kigo row’gɨ’tɨ kin el. Rai be kadɨ de’gɨ piti’de. Nan kɨ rɔta’tɨ, adɨ m’el’se, ingəi nyakugə goji lə’de nga. ");
INSERT INTO gqr_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Nan in, lokɨ in ra majɨ kɨ njendoo’gɨ, majɨ kadɨ ji gəl’i gər nya kɨ ji kɔl’i adɨ el. ");
INSERT INTO gqr_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Be ningə, nya lə’i kɨ adɨ kin to lo kiyə’tɨ, ningə Luwə kɨ oo nya’gɨ kɨ to lo kiyə’tɨ, a ugəi ɓang’a.» ");
INSERT INTO gqr_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","«Lokɨ sii elita kɨ Luwə ningə, ononyi’se kadɨ rai tokɨ njekədikum de’gɨ sii rai kin be el. Njekədikum de’gɨ kɨ ndigɨ ngayn kadɨ rai taa me kəykawnan’gɨ’tɨ lə Juwipɨ’gɨ kɨ ngangɨ row’gɨ taa elita kɨ Luwə. Ingɨ rai be kadɨ de’gɨ oyi’de. Nan kɨ rɔta’tɨ, adɨ m’el’se, ingəi nyakugə goji lə’de nga. ");
INSERT INTO gqr_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Nan in, lokɨ ge kelta kɨ Luwə ningə, majɨ kadɨ ur kəy to’i’tɨ, utɨ takəy dɔ’i’tɨ, elta kɨ Luwə lo kiyərɔ’tɨ kin, ningə Baw’i Luwə kɨ isɨ lo kiyərɔ’tɨ, a oo, ə a adi nya kɨ in dəj’ə. ");
INSERT INTO gqr_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","«Lokɨ isɨ elita kɨ Luwə ningə, elita kɨ dɔnan’tɨ, dɔnan’tɨ to de’gɨ kɨ nje gər Luwə el be el. Ingɨ oyi eyina, me ta’tɨ kɨ kel ngayn kin ə Luwə a oo’n dɔ ndu’de. ");
INSERT INTO gqr_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Majɨ kadɨ rai tokɨ ingɨ isɨ rai kin be el, tadɔ Baw’se Luwə gər nya’gɨ kɨ awi kɨ ndoo’ə, kete ɓay taa kadɨ eli si’ə ta dɔ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","«Ingɨ ə, kadɨ elita kɨ Luwə eli eyina: “Baw’je kɨ isɨ me dɔran’tɨ taa, Kadɨ de kɨ ra gər tɔ’i tokɨ in Luwə, ");
INSERT INTO gqr_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Kadɨ Konɓe lə’i re. Kadɨ de’gɨ rai ndigɨ lə’i dɔnangɨ’tɨ ne Tokɨ nje kɨ dɔran’tɨ isɨ rai kin be tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Adɨ’je nyakusɔ’je kɨ asɨ ta’je me ndɔ’tɨ kɨ ɓone. ");
INSERT INTO gqr_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Inyə go majel’gɨ lə’je kɔ, Tokɨ j’in kaa j’inyəi’n go majel’gɨ lə nje kɨ rai se’je majel kɔ kin be tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Inyə’je adɨ j’osɨ me nyanan’tɨ el, Nan kadɨ ɔr’je ji Su’tɨ kɔ. Tadɔ in ə, konɓe, kɨ tɔgɨ, kɨ tɔɓar in lə’i bitɨ kɨ non’tɨ.” ");
INSERT INTO gqr_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","«Kin ə inyəi go majel’gɨ lə de’gɨ kɔ ningə, Baw’se kɨ isɨ dɔran’tɨ a inyə go majel’gɨ lə’se kɔ tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","A kin ə re inyəi go majel’gɨ kɨ de’gɨ rai sese kɔ el ningə, Baw’se a inyə go majel’gɨ lə’se kɔ el tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","«Lokɨ ɔgi rɔ’se nyakusɔ ningə, majɨ kadɨ in sikiti kum’se sikiti sikiti to njekədikum de’gɨ kin be el. Ingɨ, sikiti kum’de kadɨ de’gɨ oyi’de tokɨ n’ɔgi rɔ’de nyakusɔ. Nan tokɨ rɔta’tɨ, adɨ m’el’se, ingəi nyakugə goji lə’de nga. ");
INSERT INTO gqr_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ningə in, lokɨ ɔgɨ rɔ’i nyakusɔ ningə, majɨ kadɨ togɨ takum’i sukɨ sukɨ, ə ndu dɔ’i bulu bulu. ");
INSERT INTO gqr_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Tadɔ kadɨ de’gɨ gəri, tokɨ ɔgɨ rɔ’i nyakusɔ, el. Ningə, Baw’i kɨ isɨ lo kiyərɔ’tɨ par ə oo, in kɨ gər nya kɨ to lo kiyərɔ’tɨ a adɨ’se nya kɨ in dəji’ə. ");
INSERT INTO gqr_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","«In mbonyi nyakingə’gɨ tadɔ lə’se dɔnan’tɨ dɔnan’tɨ dɔnangɨ’tɨ ne el. Dɔnangɨ kɨ in lokɨ nya kɨ səm’tɨ a ndusɨ ge, yon’gɨ a onyi ge, taa njeɓogɨ’gɨ a mbuti bolo bɔr kadɨ ɓogi ge. ");
INSERT INTO gqr_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Nan kadɨ in sangi kadɨ awi kɨ nyakingə’gɨ lə’se dɔran’tɨ taa kɨ in lo kɨ nya kɨ səm’tɨ a ndusɨ el num, yon’gɨ a onyi el num, taa njeɓogɨ’gɨ a mbuti bolo bɔr kadɨ ɓogi el num tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Tadɔ lo kɨ nyakingə lə’i in səm’tɨ, me’i a in səm’tɨ tɔ.» ");
INSERT INTO gqr_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","«Kum de ə in lambɨ lə darɔ’a. Kin ə re kum’i oo lo majɨ ningə, darɔ’i pətɨ in me kunjɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","A kin ə re kum’i oo lo majɨ el tɔ ningə, darɔ’i pətɨ in me lo kɨ diw’tɨ tɔ. A kin ə re kunjɨ kɨ to rɔ’i’tɨ kin təl diw ningə, a in diw kɨ dum kelta’a.» ");
INSERT INTO gqr_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","«De kɨ a ra kuləɓər lə ngar’gɨ joo goto: eke ɔsɨ ta kɨ kare ə, a ndigɨ kɨ nungɨ, eke kidɨ kɨ kare ə a uwə kɨ nje kɨ nungɨ tɔ. A asi kadɨ rai ɓər lə Luwə num, ɓər lə nar num el.» ");
INSERT INTO gqr_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","In tadɔ kin ə, m’el’se kadɨ adi me’se ra sururu dɔ nyakusɔ’se’tɨ kɨ mann kanyi’se’tɨ kɨ kadɨ sii kɨ dɔ’se taa el, taa dɔ ku kɔ’se’tɨ el num tɔ. Tadɔ kisikidɔtaa utə nyakusɔ, taa darɔ de utə ku kɨ kɔ tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Gonyi yəl’gɨ kɨ ra nali dann nəl’tɨ kin oyi, duwi ko el num, təti ko el num, taa kawi nya me dam’tɨ el num tɔ, nan Baw’se kɨ isɨ dɔran’tɨ taa, adɨ’de nya sɔi majɨ. Eke, ingɨ, utəi yəl’gɨ kin gidɨ banyi banyi el wa? ");
INSERT INTO gqr_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Nan dann’se’tɨ ə asɨ kadɨ a ilə ngonn kadɨ kɨ nden be dɔ ndɔ kisikidɔtaa’tɨ kɨ takul me kɨ ra sururu lə’ne wa? ");
INSERT INTO gqr_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Asi el, nga ra bann be ə me’se ra sururu dɔ ku kɔ’se’tɨ wa? Gonyi putɨ kam’gɨ kɨ rai me mu’tɨ kin oyi. Rai kulə madɨ el num, oji ku el num tɔ, nan ");
INSERT INTO gqr_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","ngar Salomon kɨ tɔ’a ɓar ngayn me nyakingə’tɨ kin kaa ɔɔ ku kɨ ndole asɨ nan kɨ kɨ kare dann’de’tɨ el. ");
INSERT INTO gqr_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ə kin ə Luwə ulə ku rɔ ngann mu’gɨ’tɨ kɨ j’oo’de ɓone, ə lo ti par ə a onyi por kin be ningə, ra bann ə in de’gɨ taa a ulə ku rɔ’se’tɨ el wa? In ton’gɨ me kunme’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Adɨ me’se ra sururu kadɨ eli eyina: «Ri ə j’a j’usɔi wa? Ri ə j’a j’anyi wa? J’a j’ingəi ku ra ə j’a j’ɔi wa?» el. ");
INSERT INTO gqr_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Nya’gɨ kin pətɨ, in de’gɨ kɨ gəri Luwə el, ə sii sangi kɨ non kum de’tɨ. Ningə Luwə kɨ Baw’se kɨ isɨ dɔran’tɨ gər majɨ kadɨ awi kɨ ndoo’ə tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Sangi Konɓe lə Luwə kɨ ra nya kɨ dana takum’ə’tɨ kete, ningə a adɨ’se ndəgɨ nya’gɨ kin pətɨ dɔ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Adɨ me’se ra sururu ɔjidɔ ndɔ kɨ lo ti’tɨ el. Tadɔ ndɔ kɨ lo ti’tɨ aw kɨ me kɨ ra sururu lə’ne. Ndɔ’gɨ pətɨ awi kɨ nya torɔ kɨ sɔw dɔ’de, um awi kɨ mad’a dɔ’tɨ el. ");
INSERT INTO gqr_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Gangita dɔ de’tɨ el, kadɨ Luwə gangɨ ta dɔ’se’tɨ el tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Tadɔ Luwə gangɨ ta dɔ’se tokɨ in gangi dɔ madɨ’se’gɨ’tɨ be tɔ. Ningə kadɨ gəri tokɨ nya kɨ mbɔji adi de’gɨ kin ə Luwə a mbɔjɨ’n adɨ’se tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ra bann be ə, oo bunə mu kɨ to kum ngonnkon’i’tɨ yo, ə oo kagɨ kɨ boi kɨ to yan’i’tɨ kin el wa? ");
INSERT INTO gqr_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Kagɨ kɨ boi ə to kum’i’tɨ ne tɔ kin, nga kɨ gorow kɨ bann ə a el ngonnkon’i ene: «Ngonnkon’m, adɨ m’un bunə mu kɨ to kum’i’tɨ kin» wa? ");
INSERT INTO gqr_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","In njekədikum de’gɨ, un kagɨ kɨ boi kɨ kum’i’tɨ kin ningə to, a oo lo ar njay kadɨ un’n bunə mu kɨ kum ngonnkon’i’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","«Ononyi’se kadɨ adi nya kɨ ar njay busɨ’gɨ, nan be el ə a təli kɨ dɔ’se’tɨ to tonyi’se. Be tɔ’a in ɓuki mədikɔsɨ’gɨ lə’se non kɔsongɨ’gɨ’tɨ el, nan be el ə a in njiyəi dɔ’tɨ, mbisəi kɨ nja’de.» ");
INSERT INTO gqr_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","«Dəji ə a adi’se, sangi ə a ingəi, indəi takəy ə a tei adi’se. ");
INSERT INTO gqr_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Tadɔ de kɨ dəjɨ ə a adi’ə, de kɨ sangɨ ə a ingə, de kɨ ində takəy ə a tei adi’ə tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Nan dann’se’tɨ ə ngonn’o dəj’ə mapa ningə un mbal taa ad’a wa? ");
INSERT INTO gqr_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Eke dəj’ə kanjɨ ningə un lii taa ad’a wa? ");
INSERT INTO gqr_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","A kin ə, ingɨ kɨ in de’gɨ kɨ majel kin mindɨ ə gəri row kadɨ nya kɨ majɨ ngann’se’gɨ ningə ra bann be ə, Baw’se kɨ isɨ me dɔran’tɨ taa kin taa a adɨ nya kɨ majɨ de’gɨ kɨ dəji’ə el wa? ");
INSERT INTO gqr_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","«Nya’gɨ pətɨ kɨ in ndigɨ kadɨ de’gɨ rai adi’se kin ə rai adi’de tɔ. Tadɔ inɓe kin ə in nyando kɨ to me ndukun’gɨ’tɨ lə Mojɨ num, me ta’gɨ’tɨ kɨ njekeltakita Luwə’tɨ ndangɨ num tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","«Uri kɨ tarow kɨ mbəngirə, tadɔ tarow kɨ tatɨ panyi te row’tɨ kɨ tatɨ panyi’tɨ kɨ kun’ə on el, kɨ nje kaw kɨ de’gɨ tujɨ’tɨ. Nga ningə, in row’ə kin ə de’gɨ ngayn uni. ");
INSERT INTO gqr_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ningə tarow kɨ nje kaw kɨ de’gɨ kajɨ’tɨ ta’a in mbəngirə ba, uwə de’gɨ. Ningə row’ə kin, njekun’ə’gɨ in ngayn el. ");
INSERT INTO gqr_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","«Indəi kumkədɨ dɔ rɔ’se’tɨ kɨ rɔ nje ɓar rɔ’de njekeltakita Luwə’tɨ nan ingɨ el. A rei rɔ’se’tɨ, a oyi gidɨ’de taga ne in batɨ’gɨ, nan me de’tɨ kəy, in jagum’gɨ kɨ njetɔko nyakul’gɨ. ");
INSERT INTO gqr_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","A in kigo kulə ra’de’tɨ nga ə a gəri’de. De a ujə kandɨ nju dɔ konn par’tɨ el, taa de a ujə kandɨ mbaykote dɔ konn ngan’tɨ el tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Kagɨ kɨ majɨ, ningə a andɨ kandɨ kɨ majɨ, ə kagɨ kɨ majel, a andɨ kandɨ kɨ majel tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Kagɨ kɨ majɨ kɨ kadɨ a andɨ kandɨ kɨ majel goto, taa kagɨ kɨ majel kɨ kadɨ a andɨ kandɨ kɨ majɨ kaa goto tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kagɨ kɨ ra kɨ andi kandɨ kɨ majel, a tugəi’ə kadɨ iləi’ə me por’tɨ kɔ. ");
INSERT INTO gqr_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Adɨ, a in kigo kuləra nje ngom’gɨ kɨ nje k’el k’ene n’in njekeltakita Luwə’tɨ ə a gəri’de.» ");
INSERT INTO gqr_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","«In nje kɨ sii ɓari m’in “Burəɓe, Burəɓe!” ta’de’tɨ ne par kin ə a uri pətɨ Konɓe’tɨ lə Luwə el, nan in nje kɨ sii rai go ndigɨ’tɨ lə Bai kɨ isɨ me dɔran’tɨ taa. ");
INSERT INTO gqr_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ndɔ gangita’tɨ ə, de’gɨ ngayn a eyina: “Burəɓe, Burəɓe! in me tɔ’i’tɨ el ə j’eli’n ta kɨ ta Luwə’tɨ wa? In me tɔ’i’tɨ el ə jɨ tuwə’n ndil’gɨ kɨ majel wa? In me tɔ’i’tɨ el ə jɨ ra’n nyakɔjɨ’gɨ ngayn kɨ ətɨ ɓol ɓol wa?” ");
INSERT INTO gqr_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ningə lo kin’tɨ, m’a m’el’de kɨ taga wangɨ m’ene: “Ɔri rɔ’se sanyi nu, m’gər’se nja kare el, in kɨ in njeramajel’gɨ!” ");
INSERT INTO gqr_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","«Be ə, de kɨ ra kɨ oo ta’gɨ kɨ m’el kin, ə təl rɔ’ne go’tɨ ningə, to to de kɨ njekumkar, kɨ ra kəy lə’ne dɔ gadi’tɨ be. ");
INSERT INTO gqr_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Adɨ lokɨ ndi ədɨ ningə, mann kon lo re un kəy kakin, taa nəl kaa ulə kɨ dɔ’tɨ tɔ, nan kəy budɨ nanga el, tadɔ ngirə in dɔ gadi’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Nan de kɨ ra kɨ oo ta’gɨ kɨ m’el kin, ə təl rɔ’ne go’tɨ el ningə, to to de kɨ mbo, kɨ ra kəy lə’ne dɔ nangira’tɨ be. ");
INSERT INTO gqr_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Adɨ lokɨ ndi ədɨ ningə, mann kon lo re un kəy kakin, num taa nəl kaa ulə kɨ dɔ’tɨ tɔ, ningə kəy budɨ nanga mur mur, adɨ tor’o to dilə yiw.» ");
INSERT INTO gqr_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Lokɨ Jeju tɔlta ta lə’ne, nyando li’ə ətɨ bulə de’gɨ ɓol kɨ dum. ");
INSERT INTO gqr_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Tadɔ ndo nya to de kɨ aw kɨ tɔgɨ kɨ in rɔ Luwə’tɨ, um ndo nya to njendo’de ndukun’gɨ lə Luwə el. ");
INSERT INTO gqr_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Lokɨ Jeju in kɨ dɔ mbal’tɨ isɨ ur kɨ nanga, bulə de’gɨ ngayn in go’ə’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Njebanjɨ kare te re rɔ Jeju’tɨ, ɔsi məkəsi’ne nanga non’a’tɨ, ningə el’ə ene: «Burəɓe, re in ndigɨ ə, a adɨ banjɨ lə’m ur kadɨ rɔ’m ar njay.» ");
INSERT INTO gqr_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jeju ulə ji’ne, ɔdɨ’n’ə, ningə el’ə ene: «M’ndigɨ, ə kadɨ banjɨ lə’i ur, adɨ rɔ’i ar njay.» Tanan’tɨ non, banjɨ li’ə ur, adɨ rɔ’a ar njay. ");
INSERT INTO gqr_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Go’tɨ Jeju el’ə ene: «Ononyi kadɨ el ta’a de madɨ, ə aw ɔjɨ rɔ’i njekujənyamosɨ kadikare ningə adɨ kadikare kujənyamosɨ kar rɔ tokɨ ndukun lə Mojɨ dəjɨ’n. Ra be kadɨ gəri tokɨ banjɨ lə’i ur adɨ ingə lapiya.» ");
INSERT INTO gqr_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jeju isɨ ur kɨ me ɓe’tɨ kɨ Kapernayim ningə, de kɨ Rɔm’tɨ kare kɨ in kibo lə kutɨ njerɔ’gɨ kɨ ɓu, re rɔ’a’tɨ, non kɨ dɔ’a’tɨ ene: ");
INSERT INTO gqr_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","«Burəɓe, njekulə lə’m kare to monyi ɓe non, nja’a oy njururu, adɨ ingə kon ngayn.» ");
INSERT INTO gqr_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ə Jeju el’ə ene: «M’a m’aw kadɨ m’aj’a.» ");
INSERT INTO gqr_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Nan kibo lə kutɨ njerɔ’gɨ kɨ ɓu təl el’ə ene: «Burəɓe, m’in m’asɨ kadɨ ində nja’i ta kəy’tɨ lə’m el, ə elta kare par ə ngonn njekulə lə’m a ingə lapiya. ");
INSERT INTO gqr_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","M’el be tadɔ, m’in kɨ dɔ’m m’in ginn tɔgɨ’tɨ lə nje kɨ dɔ’m’tɨ, ningə m’aw kɨ njerɔ’gɨ ginn tɔgɨ’tɨ lə’m tɔ. Adɨ re m’el njerɔ kare m’ene: “Aw!”, ningə aw; re m’el kɨ nungɨ m’ene: “Re!”, ningə re; kin ə m’el ngonn njekulə lə’m m’ene: “In ra nya kin be!”, ningə ra nya’a kakin tɔ.» ");
INSERT INTO gqr_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Lokɨ Jeju oo ta kin ta’a’tɨ, pit’ə, ə el nje kɨ ra njiyəi go’ə’tɨ ene: «Tokɨ rɔta’tɨ adɨ m’el’se, ko kunme kɨ be kin m’ingə rɔ de madɨ’tɨ dɔnangɨ kɨ Isirayel’tɨ el ɓay. ");
INSERT INTO gqr_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nga ningə, m’el’se ɓay tɔ, de’gɨ ngayn in Juwipɨ’gɨ el, a in kɨ lo kuwə kadɨ’tɨ, lo kurkadɨ’tɨ kadɨ rei sii ta nyakusɔ’tɨ kɨ Abiraham, Isakɨ kɨ Jakobɨ me Konɓe lə Luwə. ");
INSERT INTO gqr_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Nan nje’gɨ kɨ kete kɨ Konɓe kɨ dɔran’tɨ sɔw dɔ’de, a ɓuki’de kɔ taga, me lo kɨ diw’tɨ. Lo kɨ a nonyi’tɨ ge, a ngori ngangɨ’de’tɨ ge.» ");
INSERT INTO gqr_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ningə, Jeju təl el kibo lə kutɨ njerɔ’gɨ kɨ ɓu kakin ene: «Majɨ, aw! Ningə kadɨ ngonn njekulə lə’i ajɨ kigo kunme’tɨ lə’i kin.» Ningə dɔ kad’a’tɨ non, ngonn njekulə li’ə ingə lapiya tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Go’tɨ, Jeju aw me kəy’tɨ lə Piyər ningə, oo məm’ə kɨ dene to nanga, rɔ’a on por rigɨ rigɨ. ");
INSERT INTO gqr_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ə Jeju ɔdɨ ji’ə, ningə, rɔ’a kɨ kete tingə ngayn kakin, təl sɔl, adɨ ingə lapiya. Go’tɨ, ində taa ra nyakusɔ adɨ Jeju. ");
INSERT INTO gqr_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Lokɨ lo sɔl, de’gɨ rei kɨ njemonyi’gɨ ngayn kɨ ndil’gɨ kɨ majel rai’de, rɔ Jeju’tɨ. Adɨ Jeju tuwə ndil’gɨ kɨ majel kakin dɔ’de’tɨ kɔ kɨ ta kɨ ta’ne’tɨ, taa ajɨ njemonyi’gɨ pətɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Be kadɨ ta kɨ njekeltakita Luwə’tɨ Ejay el kakin tɔlta’ne. Ejay ene: «Ɔy tujɨ’gɨ, Kɨ monyi’gɨ lə’je kɨ dɔ’ne’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ndɔ kare, Jeju oo bulə de’gɨ ngayn iləi nan gugɨ gid’ə, ilə ndu’ne adɨ njendo’gɨ lə’ne kadɨ n’gangi ba, nanyi dowə’tɨ kɨ kare. ");
INSERT INTO gqr_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Lo kin’tɨ, njendo ndukun lə Luwə kare re rɔ Jeju’tɨ el’ə ene: «Njendo de’gɨ, m’a m’un go’i lo’gɨ pətɨ kɨ a aw’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ə, Jeju el’ə ene: «Njan’gɨ ai kɨ ɓe to’de, taa yəl’gɨ ai kɨ kəy lə’de tɔ, nan m’in *Ngonn de m’aw kɨ lo kɨ kadɨ m’ulə dɔ’m’tɨ el.» ");
INSERT INTO gqr_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","De kare dann njendo’gɨ’tɨ lə Jeju el’ə ene: «Burəɓe adɨ’m tarow adɨ m’aw m’duw bai ɓay taa.» ");
INSERT INTO gqr_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ningə Jeju el’ə ene: «Un go’m, ə inyə njekoy’gɨ adɨ duwi njekoy’gɨ lə’de.» ");
INSERT INTO gqr_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jeju ala me to’tɨ, ningə njendo’gɨ li’ə alai go’ə’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ningə nyɨ, nəl kibo ngayn uwə’de bus dɔ ba’tɨ, adɨ to aw to nduyi mann. Lo’tɨ kin, Jeju isɨ to ɓi. ");
INSERT INTO gqr_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Nga a, njendo’gɨ li’ə rei rɔ’a’tɨ, ndəli’ə kɨ non ta de’tɨ eyina: «Burəɓe, ajɨ’je, nan j’a j’oyi.» ");
INSERT INTO gqr_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ə Jeju el’de ene: «Ra bann ə ɓoli be wa? In de’gɨ kɨ kunme lə’se in nden ba.» Ningə Jeju ində taa, ndangɨ nəl ingɨ kɨ ba, adɨ lo təl to jijiji. ");
INSERT INTO gqr_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Nya kin ətɨ de’gɨ ɓol ngayn, adɨ eli eyina: «De’ə inɓe kam in de kɨ bann ə, nəl’gɨ kɨ ba’gɨ kaa təli rɔ’de go ta’tɨ li’ə be wa?» ");
INSERT INTO gqr_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Lokɨ Jeju re te gidɨ ba’tɨ, dɔnangɨ’tɨ lə de’gɨ kɨ Gadara, dingəm’gɨ joo, kɨ ndil’gɨ kɨ majel rai’de tei kɨ dɔɓadɨ’gɨ’tɨ rei ingəi’ə. De’gɨ kin rai nya majel ngayn, adɨ de kɨ kadɨ un row kin goto. ");
INSERT INTO gqr_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Lo kin’tɨ, iləi rɔ’de uri kɔl eyina: «Ngonn lə Luwə, in ri ə in ge rɔ’je’tɨ wa? In re ne kadɨ adi’je kon kete non dɔkagilo’ə’tɨ wa?» ");
INSERT INTO gqr_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Nga ningə, bulə kɔsongɨ’gɨ ngayn ra sɔi nya kadɨ lo’tɨ non sanyi nden. ");
INSERT INTO gqr_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ə ndil’gɨ kɨ majel nonyi dɔ Jeju’tɨ eli’ə eyina: «Re in tuwə’je ə, adɨ j’aw j’ur me kɔsongɨ’gɨ’tɨ kam.» ");
INSERT INTO gqr_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Nga anyi, Jeju el’de ene: «Awi!» Ningə tei, awi uri me kɔsongɨ’gɨ’tɨ, adɨ bulə kɔsongɨ’gɨ ɓingəi nan kadɨ mbal’tɨ taa, tosi me ba’tɨ, anyinan mann oyi. ");
INSERT INTO gqr_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Nje ngəm kɔsongɨ’gɨ anyinan awi me ɓebo’tɨ, ɔri poy nya kɨ ra nya, kɨ nya kɨ te dɔ dingəm’gɨ’tɨ kɨ joo kɨ ndil’gɨ kɨ majel rai’de kakin, pətɨ adi de’gɨ oyi. ");
INSERT INTO gqr_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","De’gɨ pətɨ kɨ me ɓebo’tɨ tei awi kadɨ ingəi Jeju, ə lokɨ oyi’ə ningə, dəji’ə kadɨ inyə dɔnangɨ lə’de ə aw. ");
INSERT INTO gqr_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jeju al me to’tɨ, ində ba gangɨ, aw me ɓebo’tɨ lə’ne. ");
INSERT INTO gqr_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","De’gɨ madɨ otɨ de kɨ rɔ’a oy njururu kɨ to me nya kotɨ njemonyi’gɨ’tɨ, rei si’ə rɔ Jeju’tɨ. Lokɨ Jeju oo kunme lə’de ningə, el de kɨ rɔ’a oy njururu kakin ene: «Ngonn’m, un me’i, majel’gɨ lə’i in kɨ kinyə go kɔ.» ");
INSERT INTO gqr_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Lo kin’tɨ, njendo ndukun’gɨ lə Luwə kɨ nungɨ elita me de’tɨ eyina: «De kam, elta kɨ mal dɔ Luwə’tɨ!» ");
INSERT INTO gqr_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Nan Jeju gər mərta lə’de, adɨ el’de ene: «Tadɔ ri ə isɨ məri ta’gɨ kɨ majel kɨ be me’se’tɨ wa? ");
INSERT INTO gqr_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Kel de kene: “Majel’gɨ lə’i in kɨ k’inyə go kɔ” ə ngan ngayn el, eke kel’ə kene: “Ində taa, ə njiyə” ə ngan ngayn el wa? ");
INSERT INTO gqr_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Re in be, m’a m’ɔjɨ’se kadɨ gəri tokɨ m’in Ngonn de, m’aw kɨ tɔgɨ dɔnangɨ’tɨ ne, kadɨ m’inyə’n go majel’gɨ lə de’gɨ kɔ.» Ningə, Jeju el njerɔkoy njururu ene: «Ində taa, un tuwə lə’i, ə aw ɓe.» ");
INSERT INTO gqr_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ningə dingəm ində taa, ə un row, aw ɓe. ");
INSERT INTO gqr_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Lokɨ kum bulə de’gɨ oo nya kin, ra’de ɓol kɨ dum, adɨ uləi tɔjɨ dɔ Luwə’tɨ, kɨ adɨ de’gɨ tɔgɨ kɨ ətɨ ɓol be kin. ");
INSERT INTO gqr_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Lokɨ Jeju ɔtɨ non isɨ aw ningə, lo dər’tɨ kɨ isɨ dər, oo dingəm kɨ ɓari’ə nan Matiye, isɨ me kəy taa lambo’tɨ. Ə Jeju el’ə ene: «Un go’m.» Ningə Matiye ində taa, un go Jeju. ");
INSERT INTO gqr_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Gotɨ, Jeju isɨ ta nyakusɔ’tɨ me kəy’tɨ lə Matiye. Nga ningə njetalambo’gɨ kɨ ndəgɨ njeramajel’gɨ, ngayn rei, sii nan’tɨ kɨ Jeju kɨ njendo’gɨ li’ə ta nyakusɔ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Lokɨ Parisɨ’gɨ oyi Jeju isɨ sɔ nya kɨ de’gɨ kin ningə, eli njendo’gɨ li’ə eyina: «Ra bann ə Njendo’se nya isɨ sɔ nya kɨ njetalambo’gɨ kɨ njeramajel’gɨ wa?» ");
INSERT INTO gqr_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ə Jeju oo ndu’de, adɨ el’de ene: «In de’gɨ kɨ njemonyi’gɨ ə a sangi de kɨ njera de monyi, um in nje rɔ ngan’gɨ ə a sangi de kɨ njera de monyi, el. ");
INSERT INTO gqr_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ai sangi kadɨ gəri me ta kin: Luwə el ene: “In koo kumtondoo ə m’ge, um in kujə mosɨ kadikare par el. Tadɔ, m’re tadɔ ɓar nje kɨ ra dana’gɨ el, nan m’re tadɔ njeramajel’gɨ yo”.» ");
INSERT INTO gqr_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","*Njendo’gɨ lə Jan Batisɨ rei ingəi Jeju eli’ə eyina: «Ra bann ə j’in kɨ Parisɨ’gɨ j’ɔgi rɔ’je nyakusɔ, ə njendo’gɨ lə’i ɔgɨ rɔ’de nyakusɔ el wa?» ");
INSERT INTO gqr_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ə Jeju ilə’de’tɨ ene: «Oyi kadɨ de’gɨ kɨ ɓari’de lo nyakusɔ taa nan’tɨ, a in kɨ rɔnel el, dɔkagilo’tɨ kɨ nje taa dene isɨ’n se’de nan’tɨ wa? Ndɔ a re non kadɨ a uni njetaa dene dann’de’tɨ ningə, dɔkagilo’tɨ kin ə a ɔgɨ rɔ’de nyakusɔ. ");
INSERT INTO gqr_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","De a un ta ku kɨ sigɨ kadɨ ilə’n kum ku kɨ kɔkɔ el. Re in be ə, ta ku kɨ sigɨ kakin a in kɨ kɨ kɔkɔ rakɨ rakɨ, kadɨ bolo a to wororo utə kɨ kete ɓay. ");
INSERT INTO gqr_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Taa, de a un yiwi kandɨ nju kɨ in el ɓay utɨ me mbu ndar’gɨ’tɨ kɨ kɔkɔ el tɔ. Re in be ningə, lokɨ yiwi kandɨ nju a in ningə, mbu ndar’gɨ a nduwi, kadɨ yiwi kandɨ nju a lo kɔ num, taa mbu ndar kaa təli nya kɨ tuji kɔ num tɔ. Be ə, re yiwi kandɨ nju in el ɓay ningə, majɨ kadɨ mbu ndar in kɨ sigɨ taa. Be ningə, mbu ndar a ndu el num, yiwi kandɨ nju kɨ me’tɨ kaa a lo kɔ el num tɔ.» ");
INSERT INTO gqr_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Lokɨ Jeju ra el’de ta kin ningə, kibo lə Juwipɨ’gɨ kare, re ɔsi məkəsi’ne nanga non’a’tɨ, el’ə ene: «Ngonn’m kɨ dene kɨ du oy tanan’tɨ ne ɓay. Nan re in re ində ji’i dɔ’a’tɨ ə, a təl tɔsɨ ndəl.» ");
INSERT INTO gqr_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jeju ində taa, un go’ə in kɨ njendo’gɨ lə’ne. ");
INSERT INTO gqr_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ningə, dene kare kɨ monyi mosɨ ad’a kon ɓal dɔgɨ gidə in joo, re ndəkba rɔ Jeju’tɨ, kɨ row kɨ gidə’tɨ, ɔdɨ ta ku li’ə. ");
INSERT INTO gqr_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Tadɔ el me’ne’tɨ ene: «Kin ə re ku li’ə inɓe par mindɨ ə m’ɔdɨ kaa, rɔ’m a ingə lapiya.» ");
INSERT INTO gqr_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jeju ilə rətɨ oo’ə, ningə el’ə ene: «Uwə tɔgi ba, ngonn’m, kunme lə’i aj’i.» Ningə dɔ kad’a’tɨ inɓe kin par ə dene ingə lapiya. ");
INSERT INTO gqr_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Lokɨ Jeju re te me kəy’tɨ lə kibo lə Juwipɨ’gɨ kakin ningə, oo nje kɔl nal’gɨ kɨ bulə de’gɨ singəi səkitə dɔnan’tɨ, ə el’de ene: ");
INSERT INTO gqr_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","«Ɔri rɔ’se gogɨ, ngonn dene oy el, nan to ɓi kare.» De’gɨ uwəi Jeju kogi. ");
INSERT INTO gqr_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Lokɨ adi bulə de’gɨ tei taga ningə, Jeju ur kəy, uwə ji ngonn, ningə ngonn dene ində taa. ");
INSERT INTO gqr_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Poy nya kin sanan kɨ dɔnangɨ kɨ non ba pətɨ. ");
INSERT INTO gqr_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Lokɨ Jeju isɨ aw, njekumtɔ’gɨ joo uni go’ə, elita kɨ ndu’de kɨ boi eyina: «Ngonnkaw Dabidɨ, oo kumtondoo lə’je.» ");
INSERT INTO gqr_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jeju re ɓe ningə, njekumtɔ’gɨ kɨ joo kakin rei rɔ’a’tɨ ndəkba, ə Jeju el’de ene: «Oyi kadɨ uwəi kul’m tokɨ m’asɨ ra nya kin inɓe kare wa?» Ə njekumtɔ’gɨ iləi’ə’tɨ eyina: «Oyo, j’oo kadɨ asɨ, Burəɓe.» ");
INSERT INTO gqr_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Lo kin’tɨ, Jeju ɔdɨ kum’de, ə el’de ene: «Majɨ, kadɨ nya’gɨ rai nya kigo kunme’tɨ lə’se!» ");
INSERT INTO gqr_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ningə, kum’de oo lo. Ningə, go’tɨ, Jeju ndəjɨ’de kɨ tɔgɨ’ne ene: «Oyi majɨ, kadɨ de madɨ gər nya kɨ ra nya kin el.» ");
INSERT INTO gqr_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Nan lokɨ tei kɨ taga be par ə, uləi ngirə kelta kɨ dɔ’a’tɨ kɨ go dɔnangɨ kɨ non pətɨ. ");
INSERT INTO gqr_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Lokɨ njekumtɔ’gɨ tei awi ningə, de’gɨ rei kɨ de kare kɨ ndil kɨ majel ra’a adɨ elta el. ");
INSERT INTO gqr_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jeju tuwə ndil kɨ majel ningə, dingəm kɨ kete elta el kakin təl elta. Ningə nya kin ra adɨ ndil bulə de’gɨ ngayn te saw, adɨ eli eyina: «J’oo nya kɨ be kin dɔnangɨ Isirayel’tɨ nja kare el ɓay!» ");
INSERT INTO gqr_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Nan Parisɨ’gɨ eli eyina: «In kɨ tɔgɨ lə ngar lə ndil’gɨ kɨ majel, ə isɨ tuwə’n ndil’gɨ kɨ majel.» ");
INSERT INTO gqr_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jeju aw kɨ ngann ɓe’gɨ kɨ ɓebo’gɨ, ndo nya me kəykawnan’gɨ’tɨ lə Juwipɨ’gɨ, iləmbər Poyta kɨ majɨ dɔ Konɓe’tɨ lə Luwə, taa ajɨ njemonyi’gɨ kɨ njerɔto’gɨ pətɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Lokɨ Jeju oo bulə de’gɨ, oo kumtondoo lə’de, tadɔ kɔr ra’de, tɔgɨ’de goto, rai to batɨ’gɨ kɨ njekul’de goto be. ");
INSERT INTO gqr_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Be ə, Jeju el njendo’gɨ lə’ne ene: «Ko kɨ asɨ kujə, dilə in ngayn, nan njekujə’gɨ in ngayn el. ");
INSERT INTO gqr_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ə elita kɨ Ɓe nje ko, adɨ ulə kɨ nje ra ko’gɨ me ndɔɔ’tɨ lə’ne.» ");
INSERT INTO gqr_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jeju ɓar njendo’gɨ lə’ne kɨ dɔgɨ gidə in joo, adɨ’de tɔgɨ kadɨ tuwəi ndil’gɨ kɨ majel’gɨ, aji njemonyi’gɨ kɨ nje rɔto’gɨ, pətɨ. ");
INSERT INTO gqr_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Tɔ njekawkulə’gɨ kɨ dɔgɨ gidə in joo ə to kin: In kɨ dɔkete in Simon, kɨ ɓari’ə nan Piyər in kɨ ngonnkon’ne Andire; Jakɨ in kɨ Jan kɨ ngann lə Jebede; ");
INSERT INTO gqr_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pilipɨ in kɨ Batilemi, Tomasɨ in kɨ Matiye, kɨ njetalambo; Jakɨ, kɨ ngonn lə Alpe in kɨ Tade; ");
INSERT INTO gqr_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simon, kɨ in mbunə nje rɔ tadɔ kingə dɔ lə ɓe lə’de in kɨ Judasɨ Isikariyotɨ, kɨ njekundɔ Jeju. ");
INSERT INTO gqr_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jeju ulə njekawkulə’gɨ lə’ne kɨ dɔgɨ gidə in joo kɨ ndu kin ene: «Ai rɔ de’gɨ’tɨ kɨ in Juwipɨ’gɨ el, el, taa ai me ɓebo’gɨ’tɨ lə de’gɨ kɨ *Samari el tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ai kɨ rɔ ginn kojɨ’tɨ kɨ *Isirayel, kɨ toi to batɨ’gɨ kɨ ndəmi be kin yo. ");
INSERT INTO gqr_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Dɔ row’tɨ, iləi mbər tokɨ Konɓe lə Luwə in ndəkba. ");
INSERT INTO gqr_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ə aj’i njemonyi’gɨ, adi njekoy’gɨ indəi taa lo koy’tɨ, adi banjɨ ur kɔ rɔ njebanjɨ’gɨ tɨ adɨ rɔ’de ar njay, ə tuwəi ndil’gɨ kɨ majel dɔ de’gɨ’tɨ tɔ. In nya kɨ ingəi kare, ə adi de’gɨ kare tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Uni ɔr, eke nar, eke silə, iləi dɔ ndar’tɨ kɨ ɓədɨ’se’tɨ el. ");
INSERT INTO gqr_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Taa, uni ɓɔl kaw mbah el num, ɔyi ku joo el num, ɔyi sa el num, uni kagɨ tɔsɨ el num tɔ. Tadɔ majɨ kadɨ nje ra kulə ingə nyakusɔ’ne ji de’gɨ’tɨ kɨ ra kulə dann’de’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Lokɨ uri me ngonn ɓe’tɨ, eke me ɓebo’tɨ ə, dəji ta, ə re ingəi de kɨ asɨ kadɨ uwə’se rɔ’ne’tɨ ningə, sii ɓe li’ə non bitɨ kadɨ awi. ");
INSERT INTO gqr_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Lokɨ uri me kəy’tɨ ningə, rai de’gɨ kɨ me’tɨ lapiya. ");
INSERT INTO gqr_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Kin ə re uwəi’se kɨ rɔ’de’tɨ ningə, kadɨ lapiya lə’se aw kɨ dɔ’de’tɨ, a kin ə re uwəi’se kɨ rɔ’de’tɨ el tɔ ningə, kadɨ təli tai lapiya lə’se gogɨ. ");
INSERT INTO gqr_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Lokɨ uwəi’se kɨ rɔ’de’tɨ el, mbeti koo ta lə’se, ə sii awi, ə inyəi me kəy kin, eke ɓebo kin ningə, kadɨ indəi bu kɨ nja’se’tɨ kɔ, kadɨ tɔji tokɨ nya kare kɨ dɔɔ’se nan’tɨ se’de goto. ");
INSERT INTO gqr_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","M’el’se tokɨ rɔta’tɨ, ndɔ gangɨ ta’tɨ ə, ta kɨ gangɨ kɨ dɔ ɓe’tɨ kin a utə yan ɓe kɨ Sɔdɔm kɨ Gɔmɔr ɓay. ");
INSERT INTO gqr_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","«Oyi, m’a m’ulə’se to batɨ’gɨ dann jagum’gɨ’tɨ. Majɨ kadɨ indəi kumkədɨ dɔ rɔ’se’tɨ to lii’gɨ be, ə sɔli lɔm lɔm to dər’gɨ be tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Adi kum’se ədɨ dɔ rɔ’se’tɨ kɨ rɔ de’gɨ’tɨ, tadɔ a awi sese lo gangɨ ta’gɨ’tɨ, a tindəi’se kɨ ndəy hawlay me kəykawnan’gɨ’tɨ lə Juwipɨ’gɨ. ");
INSERT INTO gqr_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","A awi sese non nje konɓe’gɨ’tɨ, kɨ ngar’gɨ kɨ boi tadɔ lə’m. Lokin’tɨ, ingɨ kɨ de’gɨ kɨ in Juwipɨ’gɨ el, a in tarow kɨ te kadɨ a ingəi mannajɨ kɨ dɔ’m’tɨ kɨ rɔ’se’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Lokɨ a uwəi’se kadɨ a awi sese lo gangita’tɨ, ononyi’se kadɨ me’se ɓol, kene ke ta ri ə a eli’de wa, eke a eli’de kɨ kujɨ kɨ bann wa? Ta kɨ kadɨ a eli’de ningə, Luwə a ində ta’se’tɨ low’ə’tɨ non. ");
INSERT INTO gqr_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Tadɔ in inɓe’gɨ ə a elita el, nan in Ndil Baw’se Luwə ə a un’se kadɨ el’n ta. ");
INSERT INTO gqr_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","«Ngannkon’a’gɨ a uni dɔ nan awi lo tɔl nan’tɨ, baw ngonn a aw kɨ ngonn kadɨ tɔli’ə kɔ, ningə ngann’gɨ a ɔsi ta njekojɨ de’gɨ, ə a uni dɔ’de awi kadɨ tɔli’de tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","De’gɨ pətɨ a ɔsi’se ta tadɔ lə’m, nan de kɨ uwə tɔgɨ’ne ba bitɨ dɔboy’tɨ, ə a ingə kajɨ. ");
INSERT INTO gqr_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Lokɨ a adi’se kon me ɓebo’tɨ kɨ kare ə, anyinan awi kɨ nungɨ’tɨ. Ningə tokɨ rɔta’tɨ, adɨ m’el’se, a anyinan uləi ta nja ɓebo’gɨ kɨ Isirayel’tɨ nan’tɨ el ɓay ə Ngonn de a re. ");
INSERT INTO gqr_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Njendo utə njendo’ə nya el, taa ɓər utə ɓe’ne el tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Njendo, re asɨ kɨ njendo’ə nya be ningə, in ngayn; ə ɓər, re asɨ kɨ ɓe’ne ningə in ngayn tɔ. Kin ə, ɓe nje kəy inɓe mindɨ ə, de’gɨ ɓari’ə Beljəbul kɨ in ngar lə ndil’gɨ kɨ majel ningə, nje kɨ me kəy’tɨ li’ə yan’de a to bann? ");
INSERT INTO gqr_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","«Ɓoli’de el, tadɔ nyara kɨ gidɨ kuwə kɨ ginn’ə a te el goto, taa nya kɨ to lo kiyə’tɨ, kɨ de a gər el kaa goto tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Nya kɨ m’el’se me lo kɨ diw’tɨ, eli taa kada wangɨ, ə nya kɨ de’gɨ eli kɔtirɔ mbi’se’tɨ nyəm nyəm, iləi mbər’ə jam dɔ kəy’tɨ taa tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ɓoli de’gɨ kɨ nje tɔl darɔ’se par, um asi tɔl ndil’se el kin, el. Nan kadɨ in ɓoli Luwə kɨ asɨ kadɨ tujɨ ndil’se in kɨ darɔ’se nan’tɨ me por’tɨ kɨ bitɨ kɨ non’tɨ kin. ");
INSERT INTO gqr_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ke de ndogɨ yəl’gɨ joo kɨ silə kare el wa? Nan in kɨ kare dann’tɨ kɨ kadɨ osɨ nanga kɨ kanjɨ kadɨ Baw’se Luwə ndigɨ goto. ");
INSERT INTO gqr_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Kɨ ɔjɨ dɔ’se, bin dɔ’se inɓe kin kaa in kɨ tudə kare kare gər kɔr’ɔ. ");
INSERT INTO gqr_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ə ingɨ ɓoli nya madɨ el: ingɨ, utəi ngann yəl’gɨ nja banyi banyi. ");
INSERT INTO gqr_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","«De kɨ ra ra kɨ un ndu’ne takum de’gɨ’tɨ wangɨ, tokɨ n’in de lə’m, m’in kaa m’a m’un ndu’m non Bai’tɨ, kɨ isɨ dɔran’tɨ, tokɨ in de lə’m tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Nan de kɨ ra ra kɨ manjɨ ta gərɨ’m non de’gɨ’tɨ, m’in kaa m’a manjɨ ta gər’ə non Bai’tɨ, kɨ isɨ dɔran’tɨ tɔ.» ");
INSERT INTO gqr_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","«Məri me’se’tɨ tokɨ m’re kɨ lapiya dɔnangɨ’tɨ el; m’re kɨ lapiya el, nan m’re kɨ rɔ dann de’gɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","M’re kɨ ganginan dann ngonn kɨ dingəm’tɨ kɨ baw’ne, ngonn kɨ dene’tɨ kɨ kon’ne, ngonn kɨ dene’tɨ kɨ məm’ne kɨ dene. ");
INSERT INTO gqr_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","De madɨ, de’gɨ kɨ me kəy’tɨ li’ə inɓe, a təli njeban’gɨ li’ə.» ");
INSERT INTO gqr_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","De kɨ ndigɨ baw’ne, eke kon’ne utə’m, de’ə kin asɨ kadɨ in de lə’m el. De kɨ ndigɨ ngonn’ne kɨ dingəm, eke kɨ dene utə’m, de’ə kin asɨ ta kadɨ in de lə’m el. ");
INSERT INTO gqr_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","De kɨ un kagidəsɨ lə’ne dɔ’ne’tɨ el, ə un go’m el tɔ, de’ə kin asɨ ta kadɨ in de lə’m el. ");
INSERT INTO gqr_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","De kɨ ge kajɨ rɔ’ne ə, a il’ə kɔ, nan de kɨ isɨ ilə rɔ’ne kɔ tadɔ lə’m ə, a ingə’ə. ");
INSERT INTO gqr_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","«De kɨ uwə’se kɨ rɔ’ne’tɨ, in m’in ə de’ə uwə’m kɨ rɔ’ne’tɨ. Ningə de kɨ uwə’m kɨ rɔ’ne’tɨ, in njekulə’m ə uwə’ə kɨ rɔ’ne’tɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","De kɨ uwə njekeltakita Luwə’tɨ kɨ rɔ’ne’tɨ, tadɔ kin kɨ in njekeltakita Luwə’tɨ ningə, a ingə nyakugə goji kɨ asɨ nan kɨ yan njekeltakita Luwə’tɨ inɓe kin be tɔ. De kɨ uwə de kɨ dana kɨ rɔ’ne’tɨ, tadɔ kin kɨ in de kɨ dana ningə, a ingə nyakugə goji kɨ asɨ nan kɨ yan de kɨ dana inɓe kin be tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","M’el’se tokɨ rɔta’tɨ, de kɨ adɨ mann kɨ sɔl me ngonn kala mann’tɨ, kɨ kare dann nje kɨ du’tɨ, kɨ dann njendo’gɨ’tɨ lə’m kin, tadɔ kin kɨ in njendo lə’m ningə, a ingə nyakugəgoji’ne um a to kare el.» ");
INSERT INTO gqr_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Lokɨ Jeju adɨ ndu kin njendo’gɨ lə’ne kɨ dɔgɨ gidə in joo, ginn’ə gangɨ ningə, ɔtɨ non, aw ndo nya’gɨ, iləmbər Poyta kɨ majɨ me ɓebo’gɨ’tɨ kɨ dɔnangɨ’tɨ kɨ non. ");
INSERT INTO gqr_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Lo kin’tɨ, Jan Batisɨ kɨ to kəy dangay’tɨ, oo poy nya’gɨ kɨ Kirisitɨ ra, adɨ ulə njendo’gɨ lə’ne, kadɨ dəji ta Jeju eyina: ");
INSERT INTO gqr_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","«In ə in de kɨ Luwə mbət’ə kɨ kadɨ re kakin eke, de kɨ rangɨ in non ɓay kadɨ jɨ nginə’ə wa?» ");
INSERT INTO gqr_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ə Jeju ilə’de’tɨ ene: «Ai eli Jan nya’gɨ kɨ oyi kɨ mbi’se ge kɨ kum’se ge kin: ");
INSERT INTO gqr_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Njekumtɔ’gɨ oyi lo, nje mote’gɨ njiyəi majɨ, njebanjɨ’gɨ rɔ’de ar njay, nje mbiboy’gɨ oyi ta, ə njekoy’gɨ indəi taa lo koy’tɨ tɔ, taa njendoo’gɨ kaa, in kɨ kilə’de mbər Poyta kɨ majɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Majikur in lə de kɨ m’təl ginn kosɨ li’ə el.» ");
INSERT INTO gqr_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Lokɨ ɔti awi, Jeju el bulə de’gɨ ta kɨ dɔ Jan’tɨ ene: «In ri ə ai isɨ oyi diləlo’tɨ wa? In gakira kɨ nəl isɨ aw si’ə kɨ yo ge kɨ ne ge kin wa? ");
INSERT INTO gqr_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Eke in ri inɓe par ə awi oyi wa? De kɨ ɔɔ ku kɨ ndole ngayn ə ai oyi’ə wa? Nga nje kɨ ɔyi ku kɨ ndole ngayn kaa, sii me kəy’tɨ lə ngar’gɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Eke in ri inɓe ə awi oyi wa? In njekeltakita Luwə’tɨ ə awi oyi’ə wa? Re in in ə, m’el’se m’ene oyo in njekeltakita Luwə’tɨ kɨ utə njekeltakita Luwə’tɨ ɓay. ");
INSERT INTO gqr_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","In ə makitu lə Luwə elta kɨ dɔ’a’tɨ kete ene: “M’a m’ulə kɨ njekawkita lə’m kete kadɨ ra gorow nonyi’tɨ.” ");
INSERT INTO gqr_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Tokɨ rɔta’tɨ, m’el’se, dann de’gɨ’tɨ pətɨ kɨ dene’gɨ oji’de kin, de kibo utə Jan Batisɨ goto. Nga ningə, de kɨ du ngayn me Konɓe lə Luwə bo utə. ");
INSERT INTO gqr_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Lo kulə ngirə dɔkagilo’tɨ lə Jan Batisɨ, bitɨ ɓone, Konɓe lə Luwə in ginn nyara kɨ kɨ tɔgɨ’tɨ, ningə nje tɔgɨ’gɨ sangi kadɨ n’taai’ə ginn tɔgɨ’de’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Makitu’gɨ lə njekeltakita Luwə’tɨ pətɨ, kɨ ndukun’gɨ lə Mojɨ, elita kɨ dɔ nya’gɨ’tɨ kɨ a rai nya bitɨ tei dɔ Jan Batisɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Re in ndigɨ kadɨ in gəri ginn’ə majɨ ningə, Jan in njekeltakita Luwə’tɨ, Eli kɨ kadɨ a təl re. ");
INSERT INTO gqr_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","De kɨ aw kɨ mbi’ne tadɔ koo’n dɔ ta ningə, kadɨ oo ta kin majɨ! ");
INSERT INTO gqr_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","«Nan ə m’a m’un’ə kadɨ m’ɔjɨ’n de’gɨ kɨ ngɔsine kin wa? De’gɨ kɨ ngɔsine kin, toi to ngann’gɨ kɨ du kɨ sii tambalo’tɨ, ɓari madɨ de’gɨ eyina: ");
INSERT INTO gqr_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Jɨ kɔl nal kadɨ ndami, ə mbəti ndam, j’osi pa yo kadɨ nonyi, ə mbəti non.” ");
INSERT INTO gqr_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","In be ə, Jan re, sɔ nya el num, anyi mann el num ningə, de’gɨ eli eyina: “Dɔ’a majel”. ");
INSERT INTO gqr_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Nga a, Ngonn de re, sɔ nya ge, anyi mann ge ningə, de’gɨ eli eyina: “In nje kusɔ nya kədɨ, in nje kanyi yiwi, in madɨ njetalambo’gɨ kɨ njeramajel’gɨ,” nan kum kar lə Luwə tɔjɨ rɔ’ne kadɨ in nya kɨ dana kɨ gorow kuləra’a.» ");
INSERT INTO gqr_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Lo kin’tɨ, Jeju ilə rɔ’ne, kɔl kɨ de’gɨ kɨ me ɓebo’gɨ’tɨ, kɨ in ə in de’gɨ kɨ, ra nyakɔjɨ’gɨ dann’de’tɨ ngayn utə ndəgɨ lo’gɨ, nan inyəi gorow njiyəi kɨ majel kɔ el, ene: ");
INSERT INTO gqr_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","«Kumtondoo in lə’se, in de’gɨ kɨ Korajen! Kumtondoo in lə’se de’gɨ kɨ Betisayda! Nyakɔjɨ’gɨ kɨ ətɨ ɓol, kɨ Luwə ɔjɨ dann’se’tɨ kin, re nya’gɨ kin rai nya me ɓebo Tir’tɨ kɨ ɓebo Sidon be ə, re de’gɨ kɨ me’tɨ a inyəi kuləra’de’gɨ kɨ majel mayinu. Re a inyəi row nyara’de’gɨ kɨ majel kɔ kɨ gorow kɔ sakɨ, kɨ kɔy bu por kɨ dɔ’tɨ, uwəi ndoo. ");
INSERT INTO gqr_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","In be ə, m’el’se kadɨ in gəri tokɨ, ndɔ gangɨ ta’tɨ ə, ta kɨ gangɨ kɨ dɔ Tir’tɨ kɨ Sidon a ngan to yan’se be el. ");
INSERT INTO gqr_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Nga ningə in de’gɨ kɨ Kapernayim’tɨ, oyi ene Luwə a un’se aw sese taa kadɨ dɔran’tɨ wa? Jagɨ, a təl sese kɨ nanga, lo kɨ koo’tɨ. Tadɔ nyakɔjɨ’gɨ kɨ rai nya dann’se’tɨ kin, re rai nya Sɔdɔm’tɨ be ə, re ɓone kin ɓebo kɨ Sɔdɔm’tɨ a ra kɨ dɔ’ ne taa ne ɓay. ");
INSERT INTO gqr_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","In be ə, m’el’se kadɨ in gəri tokɨ, ndɔ gangɨ ta’tɨ ə, ta kɨ gangɨ kɨ dɔ de’gɨ kɨ Sɔdɔm’tɨ a ngan ngayn to yan’se be el.» ");
INSERT INTO gqr_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Dɔ gangɨ low’ə’tɨ kin, Jeju un ta el ene: «Bai, kɨ in Ɓe nje dɔran kɨ dɔnangɨ, m’ulə tɔjɨ dɔ’i’tɨ, tokɨ iyə’n nya’gɨ kin njetər’gɨ kɨ nje nyagər’gɨ, ə in te kɨ dɔ’a adɨ de’gɨ kɨ de’gɨ gəri dɔ’de el. ");
INSERT INTO gqr_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Oyo, Bai, in ndigɨ lə’i kadɨ nya kin to be.» ");
INSERT INTO gqr_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Jeju el de’gɨ kɨ rai non ene: «Bai adɨ’m nya’gɨ pətɨ, ningə de kare kɨ gər Ngonn goto, in Baw kɨ kar’ne ba par, taa de kare kɨ gər Baw kaa goto tɔ, in Ngonn kɨ kar’ne ba par, ningə in de’gɨ kɨ Ngonn inɓe ə ndigɨ kadɨ n’adɨ gəri’ə par tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","«Rei kɨ rɔ’m’tɨ, in pətɨ kɨ ɔri rɔgɨ ginn nyakotɨ’tɨ kɨ ɔy, ə m’a m’adɨ’se ɔri kon. ");
INSERT INTO gqr_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Uni jugɨ lə’m, ə tai nyando lə’m, tadɔ m’in de kɨ sɔl lɔm lɔm, taa m’in njekulə dɔ’m nanga num tɔ. Re rai be ə, a ingəi lo kɔrkon lə ndil’se. ");
INSERT INTO gqr_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","M’in, jugɨ lə’m ɔy el, taa nya kɨ madɨ’se kadɨ oti kaa ɔlɔ kəl kəl tɔ.» ");
INSERT INTO gqr_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ndɔ kare, Jeju ində dər me ndɔɔ geme’gɨ’tɨ, ndɔ kɔrkon’tɨ lə Juwipɨ’gɨ. Njendo’gɨ li’ə kɨ in si’ə, ɓo ra’de adɨ gangi dɔ ko’gɨ dɔ njiyə’tɨ sɔi. ");
INSERT INTO gqr_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ə lokɨ Parisɨ’gɨ oyi’de ningə, eli Jeju eyina: «Oo njendo’gɨ lə’i rai nya kɨ gorow’ə’tɨ el ndɔ kɔrkon’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ə Jeju təl el’de ene: «In tudəi nya kɨ ngar Dabidɨ ra lokɨ ɓo ra’de kɨ de’gɨ kɨ go’ə’tɨ kin el bitɨ wa? ");
INSERT INTO gqr_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Dabidɨ ur me *Kəyku’tɨ lə Luwə, in kɨ de’gɨ kɨ go’ne’tɨ, sɔi mapa kɨ de’gɨ adi Luwə kadikare’tɨ. In mapa kɨ kusɔ’a in gorow’ə’tɨ el kɨ rɔ’a’tɨ num, kɨ rɔ nje kɨ go’ə’tɨ num, nan in njekujənyamosɨ kadikare par ə in gorow’ə’tɨ kadɨ sɔi. ");
INSERT INTO gqr_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Eke ta kɨ ndukun lə Mojɨ kɨ ndangɨ el ene: ndɔ kɔrkon’tɨ, njekujənyamosɨ kadikare’gɨ isɨ rai nya kɨ kadɨ de ra ndɔ kɔrkon’tɨ el, ginn Kəy’tɨ lə Luwə, nan de tudə dɔ’de’tɨ kadɨ in majel el kin, tudəi el wa? ");
INSERT INTO gqr_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Nga ningə kadɨ m’el’se, lokɨ jɨ ra’tɨ ne kin, nya kibo ngayn utə *Kəy lə Luwə to’tɨ ne. ");
INSERT INTO gqr_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ningə kin ə re in gəri me ta kɨ ene: “In koo kumtondoo ə m’ge, um in kujə mosɨ kadikare par el” kin ə, re a in gangi ta dɔ de’gɨ’tɨ kɨ ta lə’de goto kin el. ");
INSERT INTO gqr_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Tadɔ Ngonn de aw kɨ tɔgɨ dɔ ndɔ kɔrkon’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jeju in non, aw kəykawnan’tɨ lə Juwipɨ’gɨ. ");
INSERT INTO gqr_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ningə dingəm kare kɨ ji’ə oy njururu in me kəykawnan’tɨ lə Juwipɨ’gɨ non. Ningə, de’gɨ sangi row kadɨ n’indəi ta dɔ Jeju’tɨ, adɨ dəji’ə ta eyina: «*Ndukun lə Mojɨ adɨ tarow kadɨ de ajɨ madɨ’ne ndɔ kɔrkon’tɨ eke aj’a el wa?» ");
INSERT INTO gqr_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ə Jeju ilə’de’tɨ ene: «Nan dann’se’tɨ ə, aw kɨ batɨ kareba, ə batɨ kakin osɨ ɓe’tɨ ndɔ kɔrkon’tɨ, ə aw un’ə te si’ə taga el wa? ");
INSERT INTO gqr_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Nga ningə re in de ningə, utə batɨ nja banyi banyi! M’el’se tokɨ ndukun adɨ tarow kadɨ de ra majɨ ndɔ kɔrkon’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Lo kin’tɨ non, Jeju el dingəm kakin ene: «Surə ji’i». Ə dingəm surə ji’ne ningə, ji’ə təl to majɨ asɨ nan kɨ kɨ nungɨ. ");
INSERT INTO gqr_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ə lokɨ Parisɨ’gɨ tei taga ningə, ai elinan ta kɨ dɔ Jeju’tɨ, ke kadɨ n’rai bann ə n’a n’tɔli’ə wa? ");
INSERT INTO gqr_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Lokɨ Jeju oo poy nya kɨ gei ra si’ə, ɔtɨ lo kin’tɨ non kɔ. De’gɨ ngayn uni go’ə, ningə ajɨ njemonyi’gɨ pətɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ningə, ndəjɨ’de kɨ tɔgɨ’ne, kadɨ rai adɨ de gər’ne el. ");
INSERT INTO gqr_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Tadɔ kadɨ ta kɨ Luwə el kɨ ta njekeltakita Luwə’tɨ, Ejay tɔlta’ne. Luwə el ene: ");
INSERT INTO gqr_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","«Oyi njekulə lə’m kɨ m’mbət’ə, Njendigɨ lə’m, kɨ rɔ’m nəl’m ngayn kadɨ m’ulə ji’m dɔ’a’tɨ. M’a m’ində Ndil’m dɔ’a’tɨ, Kadɨ a iləmbər nyara kɨ dana rɔ ginn ɓe’gɨ’tɨ kɨ dangɨ dangɨ. ");
INSERT INTO gqr_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","A kɔli nan kɨ de el num, a ində ndu el, De a oo ndu’ə elta tambalo’tɨ el. ");
INSERT INTO gqr_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","A tətɨ gakira kɨ to se kɨ kɔtɨ’ne nanga el, Taa, a tɔl lambɨ kɨ isɨ oy el num tɔ. A ra be bitɨ kadɨ to nyara kɨ dana onɓe. ");
INSERT INTO gqr_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ginn ɓe’gɨ kɨ dangɨ dangɨ a indəi me’de dɔ’a’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","De’gɨ rei kɨ dingəm kare kɨ ndil kɨ majel ra’a adɨ kum’ə oo lo el num, elta el num ə, Jeju ad’a lapiya adɨ kum’ə oo lo ningə elta tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Nya kin ətɨ bulə de’gɨ ɓol ngayn, adɨ dəjinan ta eli eyina: «De kam in Ngonn kaw Dabidɨ el wa?» ");
INSERT INTO gqr_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Nan lokɨ Parisɨ’gɨ oyi ta kin ningə, eli eyina: «In kam isɨ tuwə ndil’gɨ kɨ majel kɨ tɔgɨ lə Beljəbul, kɨ in ngar lə ndil’gɨ kɨ majel.» ");
INSERT INTO gqr_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jeju gər mərta lə’de adɨ el’de ene: «Kin ə de’gɨ kɨ me konɓe’tɨ kɨ kareba, təli dɔnan’tɨ rɔi nan ningə, konɓe’ə kin a tujɨ. Taa, ɓebo eke me kəy kɨ de’gɨ kɨ me’tɨ təli dɔnan’tɨ, rɔi nan, kɨ kadɨ a ra taa kaa goto tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Kin ə re Satan inɓe tuwə de’gɨ lə Satan, inɓe adɨ de’gɨ li’ə təli dɔnan’tɨ rɔi nan ə, lo kadɨ konɓe li’ə a aw kɨ kete goto. ");
INSERT INTO gqr_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Re in kɨ tɔgɨ lə Beljəbul ə m’tuwə’n ndil’gɨ kɨ majel ə, de’gɨ kɨ go’se’tɨ tuwəi’de kɨ tɔgɨ lə nan wa? De’gɨ kɨ go’se’tɨ inɓe a tɔji kadɨ ta lə’se in ta kɨ gorow’ə’tɨ el. ");
INSERT INTO gqr_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","A re in kɨ tɔgɨ lə Ndil Luwə ə m’tuwə’n ndil’gɨ kɨ majel tɔ ningə, Konɓe lə Luwə re te rɔ’se’tɨ nga. ");
INSERT INTO gqr_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","«Ningə re de uwə de kɨ nje tɔgɨ dɔ’a kete el ə, a asɨ kur me kəy’tɨ li’ə, kadɨ kər nyakingə li’ə el. Lokɨ dɔ’a nga ningə, a kər nya kɨ me kəy’tɨ li’ə. ");
INSERT INTO gqr_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","De kɨ in sə’m el, in nje kɔsɨ’m ta, taa de kɨ kaw sə’m nya kɨ nan’tɨ el, in nje tində sanan tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Be ə, m’el’se tokɨ, majel’gɨ pətɨ kɨ de’gɨ a rai’de, eke kelta kɨ mal kɨ ra kɨ de’gɨ a eli dɔ Luwə’tɨ, Luwə a inyə go’ə kɔ adi’de, nan kelta kɨ mal dɔ Ndil Luwə’tɨ, Luwə a inyə go kɔ adɨ’de el ratata. ");
INSERT INTO gqr_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Kin ə re de elta kɨ majel ɔsɨ’n ta Ngonn de ə, Luwə a inyə go kɔ ad’a, nan re elta kɨ mal ɔsɨ’n ta Ndil Luwə ə, Luwə a inyə go kɔ ad’a kɨ ɓone’tɨ el num, kɨ lo ti’tɨ el num, ratata. ");
INSERT INTO gqr_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","«Kin ə re kagɨ majɨ ningə, kanda majɨ tɔ, a re kagɨ majel ningə, kanda majel tɔ. Tadɔ in kɨ kandɨ kagɨ ə de a gər’n kagɨ. ");
INSERT INTO gqr_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","In nje mann majel to lii’gɨ be kam, a rai bann be ə ta kɨ majɨ a te ta’se’tɨ, ingɨ kɨ in de’gɨ kɨ majel wa? Tadɔ in nya’gɨ kɨ rosi me’de kin ə sii tei ta’a’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","De kɨ majɨ, kuləra’a te me nya ra’tɨ kɨ majɨ kɨ uwə me’ə. Ningə de kɨ majel, kuləra’a kɨ majel te me nya ra’tɨ kɨ majel kɨ uwə me’ə tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","M’el’se, ngann ta’gɨ kɨ galala pətɨ kɨ isɨ te ta de’gɨ’tɨ kin, a ɔri ginn’ə ndɔ gangɨ ta’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Tadɔ in kɨ ta kɨ ta’i’tɨ kɨ dana ə a ɔri ta dɔ’i’tɨ, ə in kɨ ta kɨ ta’i’tɨ kɨ dana el tɔ ə ta a uwəi.» ");
INSERT INTO gqr_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Njendo ndukun’gɨ kɨ Parisɨ’gɨ madɨ’gɨ uni ta eli eyina: «Njendo de’gɨ, jɨ ndigɨ kadɨ in ra nyakɔjɨ madɨ kare adɨ j’oo.» ");
INSERT INTO gqr_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ə Jeju ilə’de’tɨ ene: «De’gɨ kɨ dɔkagilo’tɨ kɨ ɓone, in de’gɨ kɨ majel, kɨ njekuwə marum, ndigi kadɨ n’oyi nyakɔjɨ, nan nyakɔjɨ madɨ kɨ rangɨ kɨ kadɨ a oyi ore dɔ nyakɔjɨ lə njekeltakita Luwə’tɨ Jonasɨ, goto nga. ");
INSERT INTO gqr_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Tadɔ, to kɨ kaa kɨ Jonasɨ ra kadɨ mutə, kondɔ mutə me kanjɨ’tɨ kɨ boi kakin ə, Ngonn de a ra’n kondɔ mutə, kadɨ mutə ginn dɔnangɨ’tɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ndɔ gangɨ ta’tɨ ə, de’gɨ kɨ Ninibɨ’tɨ a indəi taa takum de’gɨ’tɨ kɨ dɔkagilo’tɨ kɨ ɓone kin kadɨ a iləi ta dɔ’de’tɨ. Tadɔ, lokɨ Jonasɨ iləmbər Poyta kɨ majɨ, de’gɨ kɨ Ninibɨ’tɨ inyəi gorow njiyə’de’gɨ kɨ majel kɔ. Nga ningə, kɨ ngɔsine kin, de kɨ utə Jonasɨ sanyi in ne. ");
INSERT INTO gqr_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ndɔ gangɨ ta’tɨ ə, ngar kɨ dene kɨ in holo, a ində taa takum de’gɨ’tɨ kɨ dɔkagilo’tɨ kɨ ɓone kin kadɨ a ilə ta dɔ’de’tɨ. Tadɔ, in dɔboy dɔnangɨ’tɨ nu ə ndɔkɨ re kadɨ oo gosita lə Salomon. Nga ningə, kɨ ngɔsine kin, de kɨ utə Salomon sanyi in ne. ");
INSERT INTO gqr_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","«Lokɨ ndil kɨ majel te me de’tɨ, aw ilə kɨ diləlo kɨ tutɨ kadɨ n’ingə lo kisi kɨ rangɨ kadɨ n’ɔr kon’tɨ, nan ingə el ningə, ");
INSERT INTO gqr_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","el ene: “M’a m’təl kadɨ m’aw lo kisɨ’m’tɨ kɨ kete m’njɨ’tɨ ə m’te kakin gogɨ.” Lokɨ təl aw gogɨ ningə, ingə me lo kakin to kare, utəi, rai adɨ majɨ. ");
INSERT INTO gqr_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Nga a, təl aw, ɔy ndil’gɨ kɨ majel utəi’ə inɓe ɓay siri, ningə rei uri me de’tɨ kakin sii’tɨ. Lo kin’tɨ, ji kisi de kin kɨ dɔ’a taa a majel ngayn utə in kɨ kete ɓay. Be ə, de’gɨ kɨ majel kɨ dɔkagilo’tɨ kɨ ɓone kaa a toi be tɔ.» ");
INSERT INTO gqr_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jeju isɨ elta bulə de’gɨ’ ba ɓay ningə, kon’a kɨ ngannkon’a’gɨ rei rai taga, sangi kadɨ n’eli’ə ta. ");
INSERT INTO gqr_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Nga a de madɨ el’ə ene: «Oo kon’i kɨ ngannkon’i’gɨ rai taga non, ra sangi kadɨ n’eli nu ta.» ");
INSERT INTO gqr_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ə Jeju təl el de kakin ene: «Nan’gɨ ə in kon’m kɨ ngannkon’m’gɨ wa?» ");
INSERT INTO gqr_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ningə un ji’ne tɔjɨ’n njendo’gɨ lə’ne, ə ene: «Oyi kon’m kɨ ngannkon’m’gɨ ə sii kin. ");
INSERT INTO gqr_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Tadɔ de kɨ njera ndigɨ lə Bai kɨ isɨ me dɔran’tɨ ə, in ngonnkon’m, in konnann’m, kɨ kon’m.» ");
INSERT INTO gqr_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ndɔ’a’tɨ kin, Jeju te me kəy’tɨ, aw isɨ kadɨ babo’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Bulə de’gɨ ngayn kawinan gugɨ dɔ’a, adɨ aw al isɨ me to’tɨ. Ningə bulə de’gɨ pətɨ, rai ngangɨ ba’tɨ ne. ");
INSERT INTO gqr_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Jeju el’de nya’gɨ ngayn me kujita’gɨ’tɨ ene: «Oyi, njendɔɔ kare aw kadɨ duw nya. ");
INSERT INTO gqr_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ningə, dɔkagilo’tɨ kɨ a ilə ko nya, kandɨ ko’gɨ madɨ tosi ngangɨ row’tɨ adɨ yəl’gɨ rei turi pətɨ. ");
INSERT INTO gqr_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Kandɨ ko madɨ’gɨ, tosi dɔnangɨ wor’tɨ, adɨ lo kadɨ ingəi dɔnangɨ asɨ ta’m uləi ngirə’de’tɨ goto. Nan kin ə, tɔgi kalangɨ ba, tadɔ ngirə’de to taa ne. ");
INSERT INTO gqr_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Lokɨ kadɨ ɔsɨ ningə, ngann ko’gɨ kakin ndolei mbaw. Ningə go’tɨ, tuti kurum, tadɔ ngirə’de aw nanga boi el. ");
INSERT INTO gqr_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Kandɨ ko’gɨ kɨ nungɨ, tosi dann konn’gɨ’tɨ, adɨ konn’gɨ tɔgi ndəmi’de mbɔl. ");
INSERT INTO gqr_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Nan kandɨ ko’gɨ madɨ, tosi dɔnangɨ’tɨ kɨ majɨ, adɨ andi. Kɨ nan’gɨ andi asɨ ɓu kare, nje kɨ nungɨ andi asɨ dɔ mehen, ə nje kɨ nungɨ ɓay andi asɨ dɔ mutə tɔ.» ");
INSERT INTO gqr_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Jeju ilə dɔ’tɨ ene: «Re de kɨ aw kɨ mbi’ne tadɔ koo’n dɔ ta ningə, kadɨ oo dɔ ta kin majɨ!» ");
INSERT INTO gqr_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Njendo’gɨ lə Jeju rei rɔ’a’tɨ dəji’ə eyina: «Tadɔ ri ə el’de ta kɨ kujita’gɨ wa?» ");
INSERT INTO gqr_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ə Jeju el’de ene: «M’el’se ta kɨ kujita tadɔ ingɨ, Luwə te kɨ dɔ nya kɨ to lo kiyə’tɨ kɨ ɔjidɔ Konɓe lə Luwə li’ə adɨ in gəri, nan ingɨ, Luwə te kɨ dɔ’a adɨ’de el. ");
INSERT INTO gqr_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Tadɔ de kɨ aw kɨ nya ji’ne’tɨ, a adi’ə dɔ’tɨ ɓay kadɨ to mbar mbar ji’ə’tɨ, nan de kɨ nya li’ə goto, in kɨ ndikiri inɓe kɨ awɨ’n ji’ne’tɨ kin kaa, a tai ji’ə’tɨ inɓe ɓay.» ");
INSERT INTO gqr_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","In tadɔ kin ə, m’el’n’de ta kɨ kujita, tadɔ gonyi lo majɨ kaa, oyi nya el num, oyi ta majɨ kaa, gəri me’ə el num. ");
INSERT INTO gqr_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","In be kadɨ ta kɨ Luwə el kɨ njekeltakita’a’tɨ Ejay kin tɔlta’ne. Ejay el ene: A oyi dɔ ta majɨ, nan a gəri me’ə el num, A gonyi lo majɨ, nan a oyi lo el num, ");
INSERT INTO gqr_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Tadɔ me de’gɨ kin təl ngan ngororo. Uti mbi’de, Ndəmi kum’de, Ndigi kadɨ kum’de oo lo el num, Kadɨ mbi’de oo ta el num, Taa kadɨ n’gəri nya madɨ kare el num tɔ, Nan be el ə təli rei rɔ’m’tɨ, Adɨ m’ajɨ’de. ");
INSERT INTO gqr_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","«Nan ingɨ, in nje majikur, tadɔ kum’se oo nya’gɨ majɨ num, mbi’se oo ta majɨ num. ");
INSERT INTO gqr_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Tokɨ rɔta’tɨ, m’el’se, de’gɨ kɨ njekeltakita Luwə’tɨ, ngayn, kɨ njera nya’gɨ kɨ dana ngayn, ndigɨ kadɨ kum’de oo nya kɨ ingɨ oyi, nan asi koo el, ndigɨ kadɨ mbi’de oo ta kɨ ingɨ oyi, nan asi koo el tɔ.» ");
INSERT INTO gqr_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","«Ingɨ, majɨ kadɨ gəri me kujita lə nje kilə ko kin majɨ. ");
INSERT INTO gqr_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ngangɨ row kɨ kandɨ ko’gɨ tosɨ’tɨ, in de kɨ oo ta kɨ dɔ Konɓe’tɨ lə Luwə, nan gər me’ə el, ə Su re ɔr ta kɨ duw me de’tɨ kakin kɔ. ");
INSERT INTO gqr_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Dɔnangɨ wor kɨ kandɨ ko’gɨ tosɨ’tɨ, in de kɨ oo ta lə Luwə ningə, taa kalangɨ ba kɨ rɔnel, ");
INSERT INTO gqr_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","nan ta kin, ulə ngirə’ne me’ə’tɨ el. In de kɨ njekuwə kɨ ta lə Luwə dɔkagilo kɨ nden be par. Dɔgagilo kɨ nya torɔ’gɨ eke kindəkumndoo tadɔ ta lə Luwə re ningə, inyəi kunme lə’de kɔ kalangɨ ba. ");
INSERT INTO gqr_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Kandɨ ko’gɨ kɨ tosi dann konn’tɨ, in de kɨ oo ta lə Luwə, nan me kɨ ra sururu dɔ nya’gɨ’tɨ kɨ dɔnangɨ’tɨ, kɨ ra ta nya majɨ’gɨ utɨ dɔ ta kɨ oyi, adɨ lo kadɨ andi goto. ");
INSERT INTO gqr_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ningə, dɔnangɨ kɨ majɨ kɨ kandɨ ko’gɨ tosi’tɨ, in de kɨ oo ta lə Luwə, gər me’ə adɨ andɨ majɨ. Dɔ’de kɨ madɨ’gɨ andɨ ɓu kare ge kɨ nungɨ andi dɔ mehen ge, dɔ mutə ge.» ");
INSERT INTO gqr_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jeju ində kujita kɨ rangɨ non’de’tɨ ɓay ene: «Konɓe lə Luwə, to to de kɨ duw kandɨ nya kɨ majɨ me ndɔɔ’tɨ lə’ne, ");
INSERT INTO gqr_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","ə kondɔ, lokɨ de’gɨ toi ɓi ningə, njeban li’ə re duw jene dɔ nya’tɨ kɨ majɨ kɨ duw kakin, ningə ɔtɨ aw. ");
INSERT INTO gqr_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Lokɨ kandɨ nya kɨ majɨ kakin uwə tɔgɨ, ə kanda’gɨ sii tei ningə, jene kaa kanda te tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Lo kin’tɨ, nje ra kulə’gɨ ai eli ɓe’de eyina: “Ɓe’je, in kandɨ nya kɨ majɨ ə jɨ duw me ndɔɔ’tɨ lə’i tɔ, nga jene’gɨ kin tei ra wa?” ");
INSERT INTO gqr_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ə ɓe’de el’de ene: “In njeban ə ra nya kin.” Nga a nje ra kulə’gɨ dəji’ə eyina: “In ndigɨ kadɨ jɨ tɔri’de kɔ wa?” ");
INSERT INTO gqr_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Nan ɓe nje ndɔɔ el’de ene: “Jagɨ, lo tɔr jene’gɨ’tɨ kin, a tɔri kɨ ko kɨ majɨ ba. ");
INSERT INTO gqr_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ə inyəi’de adɨ tɔgi nan’tɨ bitɨ kagilo kujə ko’tɨ, ningə ndɔ kuj’ə’tɨ ningə, m’a m’el nje kuj’ə’gɨ m’ene: Tɔri jene’gɨ kin dɔi kɨ dɔ’a dɔ’a kadɨ to uləi por ɓay taa, ujəi inɓe kɨ majɨ me dam’tɨ lə’m.”» ");
INSERT INTO gqr_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jeju ində kujita kɨ rangɨ non’de’tɨ ɓay ene: «Konɓe lə Luwə to to kandɨ kagɨ madɨ kɨ ɓari’ə nan mutardə kɨ de madɨ un duw me ndɔɔ’tɨ lə’ne kin be. ");
INSERT INTO gqr_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Kandɨ mutardə ə in kandɨ nya kɨ du utə ndəgɨ kandɨ nya’gɨ pətɨ, nan lokɨ tɔgɨ ningə, təl kagɨ tanyi kibo utə kam tanyi’gɨ pətɨ kɨ me ndɔɔ’tɨ. Təl kagɨ kibo, adɨ yəl’gɨ rei rai kəy to’de baji’ə’gɨ’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jeju el’de kujita kɨ rangɨ ɓay ene: «Konɓe lə Luwə to tanan kɨ hum kɨ dene madɨ un lɔy’n ndujɨ kɨ me keh mutə, adɨ ndujɨ kɨ lɔy ba pətɨ in kin be.» ");
INSERT INTO gqr_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ta’gɨ kin pətɨ, Jeju el bulə de’gɨ kɨ kujita. Ta kɨ kadɨ el’de kɨ kujita el goto. ");
INSERT INTO gqr_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","In be kadɨ ta’gɨ kɨ Luwə el kɨ ta njekeltakita’a’tɨ kin tɔlta’ne. Njekeltakita Luwə’tɨ el ene: «M’a m’te ta’m kadɨ m’el kujita’gɨ, m’a m’iləmbər nya’gɨ kɨ toi lo kiyə’tɨ lotum ginn dɔran’tɨ kɨ dɔnangɨ’tɨ nu kin.» ");
INSERT INTO gqr_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jeju inyə bulə de’gɨ adɨ’de awi ə aw ɓe. Lokɨ rei ɓe, njendo’gɨ li’ə rei rɔ’a’tɨ, dəji’ə eyina: «Ɔr’je ginn kujita kɨ dɔ jene’tɨ kɨ ra me ndɔɔ’tɨ kin adɨ j’oo.» ");
INSERT INTO gqr_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ə Jeju ilə’de’tɨ ene: «De kɨ njeduw ko nya kɨ majɨ kin, in Ngonn de, ");
INSERT INTO gqr_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ningə ndɔɔ, in dɔnangɨ; ə kandɨ ko kɨ majɨ, in nje’gɨ kɨ ndigɨ kadɨ Luwə onɓe dɔ’de’tɨ; jene, in nje’gɨ kɨ uni go Su; ");
INSERT INTO gqr_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","njeban kɨ njeduw’ə, in Su; kagilo kujə ko in dɔboy ndɔ; ningə nje kujə ko’gɨ in malayka’gɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","To kɨ kaa kɨ, in kɨ tɔri’n jene ɓuki por’o, dɔboy ndɔ a to be tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ngonn de a ulə kɨ malayka’gɨ lə’ne kadɨ ɔr de’gɨ pətɨ kɨ nje kɔsɨ madɨ de’gɨ kadɨ osi me majel’tɨ, kɨ de’gɨ kɨ njeramajel kɔ Konɓe’tɨ lə’ne. ");
INSERT INTO gqr_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","*Malayka’gɨ a ɓuki’de me por’tɨ kɨ dum kelta’a, kɨ in lo kɨ a nonyi ge a ngori ngangɨ’de ge səm’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Lo kin’tɨ, njera nya kɨ dana a unji to kadɨ be me Konɓe’tɨ lə Baw’de Luwə. De kɨ aw kɨ mbi’ne kadɨ oo’n dɔ ta ningə, kadɨ oo dɔ ta kin majɨ. ");
INSERT INTO gqr_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","«Konɓe lə Luwə to to nyakingə kɨ iyəi me ndɔɔ’tɨ, ə de madɨ aw te dɔ’tɨ kin be. De kakin təl iyə gogɨ, ningə rɔ’a nəl’ə ngayn, adɨ aw ra gatɨ kɨ nya majɨ’gɨ lə’ne pətɨ, ə inyə nar’a re ndogɨ’n ndɔɔ kakin. ");
INSERT INTO gqr_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Konɓe lə Luwə kɨ dɔran’tɨ to to njera gatɨ kɨ isɨ sangɨ mədikɔsɨ kɨ ndole be. ");
INSERT INTO gqr_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Lokɨ ingə in kɨ gat’a in ngayn, təl aw ra gatɨ kɨ nyakingə’gɨ lə’ne pətɨ, ə inyə nar’a re ndogɨ’n mədikɔsɨ kakin.» ");
INSERT INTO gqr_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","«Konɓe lə Luwə to to bandɨ kɨ de a ilə me ba’tɨ ə a ɔy dɔkɔr kanjɨ’gɨ kɨ dangɨ dangɨ kam be. ");
INSERT INTO gqr_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Lokɨ bandɨ kakin rosɨ ningə, njendon ndɔr re’n ngangɨ ba’tɨ, isɨ nanga, ningə tɔr nje kɨ majɨ majɨ me sukim’tɨ, ə inyə nje kɨ tei nya el ɓuki’de kɔ. ");
INSERT INTO gqr_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Kah’a’tɨ kakin ə, dɔboy ndɔ a in be tɔ. Malayka’gɨ a rei kadɨ ɔri kum de’gɨ kɨ njera nya’gɨ kɨ dana kɨ njera nya’gɨ kɨ dana el, nan’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","A ɓuki de’gɨ kɨ njera nya’gɨ kɨ majel me por’tɨ kɨ dum kelta’a, kɨ in lo kɨ a nonyi ge a ngori ngangɨ’de ge səm’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Lo kin’tɨ non, Jeju dəjɨ njendo’gɨ lə’ne ene: «In gəri me ta’gɨ kin pətɨ wa?» Ə iləi’ə’tɨ eyina: «Oyo, jɨ gər.» ");
INSERT INTO gqr_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ningə Jeju el’de ene: «In be ə, njendo de’gɨ ndukun kɨ təl nje taa nyando kɨ dɔ Konɓe’tɨ lə Luwə, to to ɓe nje kəy kɨ ingə nya’gɨ kɨ sigɨ kɨ me nya’gɨ’tɨ kɨ kɔkɔ lo ngəm nya’tɨ lə’ne kin be.» ");
INSERT INTO gqr_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Lokɨ Jeju el kujita’gɨ ginn’ə gangɨ ningə, ɔtɨ lo kɨ ra’tɨ kin kɔ. ");
INSERT INTO gqr_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ɔtɨ non, aw ɓe kɨ tɔgɨ səm’tɨ. Jeju ndo nya de’gɨ ginn kəykawnan’tɨ lə Juwipɨ’gɨ. Ndo’de nyando kɨ ətɨ’de ɓol, adɨ eli eyina: «Gosɨ ta’gɨ kɨ nyakɔjɨ’gɨ kin in’n ra wa? ");
INSERT INTO gqr_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Man! Ngonn lə njeragɨ kagɨ dɔ kəy’tɨ inɓe kaa am wa? Kon’a el ə in Mari wa? Ə Jakɨ ge kɨ Jisepɨ ge, kɨ Simon ge kɨ Judɨ ge tɔ el ə in ngannkon’a’gɨ wa? ");
INSERT INTO gqr_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Taa, konnann’a’gɨ kaa sii se’je ne tɔ el wa? Nga nya’gɨ kin pətɨ ingə ra dana?» ");
INSERT INTO gqr_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ta kɨ dəji kin ɔgɨ’de kadɨ uni me’de, təl nya tugə jigɨ’tɨ rɔ’de’tɨ. Ə Jeju el’de ene: «Njekeltakita Luwə’tɨ ningə, in me ɓe koj’o’tɨ, kɨ dann noj’o’gɨ’tɨ par ə de’gɨ a kidi’ə’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Lo kin’tɨ, Jeju ra nyakɔjɨ’gɨ ngayn kɨ dum kadɨ de ra el tadɔ mbeti kuni me’de kadi’ə. ");
INSERT INTO gqr_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Dɔkagilo’ə’tɨ kin Erodɨ kɨ nje konɓe dɔ dɔnangɨ’tɨ kɨ Galile oo ta tɔɓar lə Jeju. ");
INSERT INTO gqr_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ə el nje ra kulə’gɨ lə’ne ene: «De kin in Jan Batisɨ! In in ə ində taa dann njekoy’gɨ’tɨ. Ginn’ə kin ə, awɨ’n kɨ tɔgɨ tadɔ ra’n nyakɔjɨ’gɨ kɨ ətɨ ɓol.» ");
INSERT INTO gqr_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Erodɨ el be, tadɔ ndɔ kɨ inɓe adɨ uwəi Jan, dɔi’ə kɨ kulə gindɨ, iləi’ə dangay’tɨ, tadɔ lə Erodiyadɨ, kɨ ne ngonnkon’a Pilipɨ, ");
INSERT INTO gqr_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","kɨ Jan el’ə ta dɔ’tɨ ene: «In gorow’ə’tɨ el kadɨ in ta’a ne’i’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Me ta’tɨ kin, Erodɨ ndigɨ tɔl Jan, nan ɓol bulə de’gɨ, tadɔ bulə de’gɨ oyi Jan kadɨ in njekeltakita Luwə’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Nga a, ndɔ rɔnel kojɨ Erodɨ’tɨ, ngonn lə Erodiyadɨ kɨ dene, te la non de’gɨ’tɨ kɨ ɓari’de lo nyakusɔ’tɨ, ə nəl Erodɨ ngayn, ");
INSERT INTO gqr_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","adɨ Erodɨ un ndu’ne kɨ kiwrɔ kadɨ n’a n’ad’a nya’gɨ pətɨ kɨ dəjɨ’ne. ");
INSERT INTO gqr_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Lo kin’tɨ, kon’a sul’ə, adɨ el ene: «Adɨ’m, tokɨ jɨ ra’n ne inɓe kin, dɔ Jan Batisɨ me supira’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Me ngar tujɨ ɔjɨ’n dɔ nya kɨ ngonn kɨ dene dəj’ə kin, nan tadɔ kun mindɨ kɨ un kɨ kiwrɔ, taa tadɔ de’gɨ kɨ ɓar’de lo nyakusɔ’tɨ kin tɔ ningə, un ndu’ne kadɨ adi’ə dɔ Jan. ");
INSERT INTO gqr_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Be ə, adɨ de madɨ aw gangɨ dɔ Jan me kəy dangay’tɨ, ");
INSERT INTO gqr_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","re’n me supira’tɨ, adi ngonn kɨ dene kakin, adɨ awɨ’n adɨ kon’ne. ");
INSERT INTO gqr_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Njendo’gɨ lə Jan rei uni ninn’ə awi duwi, ningə awi ɔri poy’o Jeju ad’a oo. ");
INSERT INTO gqr_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Lokɨ Jeju oo ta kin ningə, un to ə aw ɔsi rɔ’ne ngərəngɨ kɨ kar’ne ba lokɨ de’gɨ gotoi’tɨ. Lokɨ bulə de’gɨ oyi ta’a ningə, in kɨ ɓebo’gɨ kɨ dangɨ dangɨ awi kɨ nja’de go’ə’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Lokɨ Jeju ur nanga me to’tɨ, oo bulə de’gɨ ngayn, lokɨ oo’de, oo kumtondoo lə’de, adɨ ajɨ njemonyi’gɨ lə’de. ");
INSERT INTO gqr_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Lokɨ kadɨ aw to ur ningə, njendo’gɨ ɔti kɨ rɔ Jeju’tɨ eli’ə eyina: «Lo kɨ ji rai’tɨ ne kin, in lo kɨ de’gɨ gotoi’tɨ, ningə kadɨ isɨ ur nga tɔ, ə inyə bulə de’gɨ kam adɨ awi kɨ ngannɓe’gɨ’tɨ, ndogi nyakusɔ sɔi.» ");
INSERT INTO gqr_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Nan Jeju el’de ene: «Awi kɨ ndo kadɨ ai lo el, inɓe’gɨ adi’de nya sɔi.» ");
INSERT INTO gqr_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ə eli Jeju eyina: «Kɨ jɨ ra’n ne kin, j’aw kɨ mapa mi ə kanjɨ joo tɔ par.» ");
INSERT INTO gqr_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ningə Jeju el’de ene: «Rei se’de ne adi’m’in m’oo.» ");
INSERT INTO gqr_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ningə go’tɨ, adɨ ndu’ne kadɨ bulə de’gɨ kakin sii nanga dɔ mu’gɨ’tɨ. Ningə ɔy mapa’gɨ kɨ mi kɨ kanjɨ’gɨ kɨ joo kakin, un kum’ne kɨ taa, elta kɨ Luwə kadɨ njangɨ’n dɔ nyakusɔ kin, ningə uwə gangɨ’de nan’tɨ, adɨ njendo’gɨ, kadɨ adi bulə de’gɨ. ");
INSERT INTO gqr_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","De’gɨ pətɨ sɔi nya ndanni majɨ. Ningə, ɔyi ndəgɨ mapa kɨ nanyi, kara dɔgɨ gidə in joo. ");
INSERT INTO gqr_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","De’gɨ kɨ sɔi nya kin asi dingəm’gɨ dər mi, de tudə dene’gɨ kɨ ngann’gɨ kɨ sɔi nya se’de səm’tɨ el. ");
INSERT INTO gqr_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Nden ba go’tɨ, Jeju ɔsɨ njendo’gɨ lə’ne adɨ ali me to’tɨ, kadɨ awi gidɨ ba’tɨ kete non’ne’tɨ, dɔkagilo’tɨ kɨ in a inyə’n bulə de’gɨ. ");
INSERT INTO gqr_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Lokɨ Jeju inyə’de adɨ awi ningə, ɔtɨ al aw dɔ mbal’tɨ, ɔsɨ rɔ’ne kɨ kar’ne ba tadɔ kelta kɨ Luwə. Lokɨ kadɨ ur, Jeju isɨ low’ə’tɨ non kɨ kar’ne ba. ");
INSERT INTO gqr_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Dɔ gangɨ low’ə’tɨ kin, to in dann batɨ, sanyi kɨ ngangɨ ba nga. Nəl ulə sur to kɨ gogɨ gogɨ, adɨ pungum babo ra’de majel. ");
INSERT INTO gqr_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Taginnlo’tɨ, Jeju in ra njiyə dɔ mann’tɨ, isɨ aw kɨ rɔ njendo’gɨ’tɨ lə’ne. ");
INSERT INTO gqr_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ə lokɨ njendo’gɨ oyi’ə ra njiyə dɔ mann’tɨ ningə, dɔ’de majel, adɨ eli eyina: «In muwə de,» ningə ɓol tɔl’de, adɨ uri kɔl. ");
INSERT INTO gqr_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Nan kalangɨ ba, Jeju el’de ene: «Adɨ me’se osɨ nanga nan in m’in, ə ɓoli el!» ");
INSERT INTO gqr_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Lo kin’tɨ, Piyər ilə Jeju’tɨ ene: «Burəɓe, re in in ə, adɨ’m ndu’i adɨ m’njiyə dɔ mann’tɨ m’aw rɔ’i’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ə Jeju el ene: «Re!» Ningə Piyər in me to’tɨ, ur dɔ mann’tɨ, njiyə dɔ’tɨ isɨ re kɨ rɔ Jeju’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Nan lokɨ Piyər oo nəl kɨ isɨ ulə ningə, ɓol ra’a adɨ ulə ngirə ndu’i mann, adɨ non ene: «Burəɓe, ajɨ’m!» ");
INSERT INTO gqr_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ə kalangɨ ba, Jeju ilə ji’ne uwə’n Piyər, ningə el’ə ene: «In de kɨ kunme lə’i in ndikiri ba, ra bann ə in tadɨ wa?» ");
INSERT INTO gqr_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ningə lokɨ ali taa me to’tɨ ə, ginn nəl gangɨ. ");
INSERT INTO gqr_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ə nje kɨ sii me to’tɨ ɔsi məkəsɨ’de nanga non’a’tɨ, ningə eli’ə eyina: «Tokɨ rɔta’tɨ, in Ngonn lə Luwə inɓe!» ");
INSERT INTO gqr_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Lokɨ Jeju in kɨ njendo’gɨ lə’ne indəi babo gangi ningə, tei dɔnangɨ Genejaretɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","De’gɨ kɨ low’ə’tɨ gəri Jeju, adɨ uləi kulə kɨ lo lo, dɔnangɨ kɨ Genejaretɨ’tɨ ba pətɨ, ə de’gɨ rei kɨ njemonyi’gɨ pətɨ rɔ’a’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","De’gɨ nonyi dɔ Jeju’tɨ kadɨ inyə njemonyi’gɨ adɨ ɔdi ta ku li’ə, ningə de’gɨ pətɨ kɨ ɔdi ta ku li’ə ingəi lapiya tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Parisɨ’gɨ kɨ njendo ndukun’gɨ lə Luwə kɨ madɨ’gɨ in Jerujalem’tɨ, rei ingəi Jeju dəji’ə eyina: ");
INSERT INTO gqr_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«Tadɔ ri ə njendo’gɨ lə’i təli rɔ’de go nyajibəlɓe’tɨ lə kaw’je’gɨ el wa? Jɨ dəjɨ be tadɔ togi ji’de kigo nyajibəlɓe’gɨ el par ə sɔi nya.» ");
INSERT INTO gqr_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ə Jeju ilə’de’tɨ ene: «Nga ingɨ, tadɔ ri ə in təli rɔ’se go mbərkikində’tɨ lə Luwə el tadɔ nyajibəlɓe lə’se wa? ");
INSERT INTO gqr_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Tokɨ rɔta’tɨ, Luwə el ene: “Ɔsɨ kurə baw’i kɨ kon’i.” Taa el ɓay ene: “De kɨ elta kɨ majel baw’ne eke kon’ne asɨ ta koy.” ");
INSERT INTO gqr_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Nan ingɨ, eli eyina: “De kɨ el baw’ne eke kon’ne ene: ‹Nya majɨ’gɨ kɨ re m’a m’ɔsɨ’n kɔyi in kadikare kɨ m’ində ta dangɨ tadɔ Luwə nga,› ningə, ");
INSERT INTO gqr_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","de’ə kin aw kɨ ndoo kadɨ ɔsikurə baw’ne el nga. Lo kin’tɨ, sii tuji kɨ ta lə Luwə tadɔ nyajibəlɓe lə’se.” ");
INSERT INTO gqr_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ingɨ in njekədikum de’gɨ, ta kɨ Luwə el kɨ ta njekeltakita’ne’tɨ Ejay dɔ’se’tɨ in ta kɨ rɔta’tɨ. Luwə el ene: ");
INSERT INTO gqr_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Ginn de’gɨ kin ɔsikurə’m kɨ ndar ta’de kare, Nan me’de in sanyi sə’m. ");
INSERT INTO gqr_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Tɔjɨ kɨ isɨ uləi dɔ’m’tɨ, nda’a goto, Tadɔ nyando’gɨ kɨ isɨ ndoi de’gɨ kaa, In mbərkikində’gɨ kɨ in rɔ de’gɨ’tɨ.”» ");
INSERT INTO gqr_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Go’tɨ ningə, Jeju ɓar bulə de’gɨ kɨ rɔ’ne’tɨ, ə el’de ene: «Uri mbi’se majɨ oyi ta lə’m, ə kadɨ in gəri me’ə tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Nya madɨ kɨ in taga aw ta de’tɨ kɨ a təl’ə nya kɨ to njen takum Luwə’tɨ goto. Nan nya kɨ te ta de’tɨ ə a təl de nya kɨ to njen’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Lo kin’tɨ, njendo’gɨ lə Jeju rei rɔ’a’tɨ eli’ə eyina: «Ta kɨ el kin to me Parisɨ’gɨ ngayn, kin in gər wa?» ");
INSERT INTO gqr_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ə Jeju ilə’de’tɨ ene: «Kagɨ kɨ ra kɨ Bai man el, a ɔri’ə kɔ. ");
INSERT INTO gqr_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Inyəi’de, in njekumtɔ’gɨ ə isɨ ndɔri njekumtɔ’gɨ. Nga ningə, re njekumtɔ ndɔr njekumtɔ ə, joo pətɨ a osi ɓe’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ə Piyər un ta el’ə ene: «Ɔr me kujita kin adɨ j’oo.» ");
INSERT INTO gqr_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ningə Jeju el ene: «Adɨ inɓe’gɨ kaa in gəri nya el tɔ wa? ");
INSERT INTO gqr_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Adɨ m’el’se, nya’gɨ pətɨ kɨ ɔdɨ ta de, a aw te kanda’a’tɨ, ningə go’tɨ ə, te kɔ, aw ɓe sin’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Nan nya kɨ te ta de’tɨ, in nya kɨ in ngarme de’tɨ, ningə in kin ə in nya kɨ nje təl de kɨ to njen’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ngarme’de ə in lo kɨ mərta’gɨ kɨ majel isɨ tei’tɨ, kɨ tɔl nan, kɨ kuwə marum, kɨ kaya kɨ ra, kɨ ɓogɨ, kɨ mannajɨ kɨ ngom, kɨ kelta kɨ majel dɔnan’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ingɨ kin ə in nya’gɨ kɨ isɨ təli de nya kɨ to njen’tɨ, nan kusɔ nya par, um togɨ ji el, a təl de nya kɨ to njen’tɨ el.» ");
INSERT INTO gqr_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jeju in low’ə’tɨ non, ɔr rɔ’ne aw dɔnangɨ’tɨ kɨ Tir’tɨ kɨ Sidon. ");
INSERT INTO gqr_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ningə nyɨ, dene kɨ Kana’tɨ kare te non re, ningə un ndu’ne kɨ taa el ene: «Burəɓe, Ngonnkaw Dabidɨ, oo kumtondoo lə’m! Tadɔ ndil kɨ majel adɨ kon ngonn’m kɨ dene ngayn.» ");
INSERT INTO gqr_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Nan Jeju ilə ta’tɨ el. Ningə njendo’gɨ li’ə rei rɔ’a’tɨ, eli’ə eyina: «In tuwə kɔ go’je’tɨ, tadɔ a ində ndu go’je’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ə Jeju ilə’de’tɨ ene: «In ngann Isirayel’gɨ kɨ toi to batɨ’gɨ kɨ nanyinan be kam par ə Luwə ulə’m kɨ rɔ’de’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Nan dene re ɔsi məkəsi’ne nanga non’a’tɨ ene: «Burəɓe, re ra sə’m!» ");
INSERT INTO gqr_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ə Jeju ilə’tɨ ene: «In gorow’ə’tɨ el kadɨ de un nyakusɔ lə ngann’gɨ, ilə adɨ ngann busɨ’gɨ.» ");
INSERT INTO gqr_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ningə dene el Jeju ene: «In rɔta’tɨ Burəɓe, nga k’in ə, ngann busɨ’gɨ kɨ ai ginn tabilə’tɨ a sɔi bunə nya’gɨ kɨ in dɔ tabilə’tɨ tosɨ nanga tɔ.» ");
INSERT INTO gqr_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Lo kin’tɨ, Jeju el’ə ene: «Dene, kunme lə’i bo ngayn! Ningə kadɨ ingə nya kɨ to rɔ’i kin, tokɨ dəjɨ’n.» Ningə ngonn’o kɨ dene kakin, ingə lapiya nga dɔ kad’a’tɨ inɓe kin non tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jeju ɔtɨ low’ə’tɨ non, aw ta ba’tɨ kɨ Galile. Al aw dɔ mbal’tɨ, isɨ nanga. ");
INSERT INTO gqr_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Bulə de’gɨ ngayn rei rɔ Jeju’tɨ kɨ nje mote’gɨ kɨ njekumtɔ’gɨ, kɨ nje kingə tujɨ’gɨ kɨ nje mbiboy’gɨ kɨ elita el, taa njemonyi’gɨ kɨ rangɨ ngayn non ɓay. Rei kɨ njemonyi’gɨ kin ɓuki’de non Jeju’tɨ, ningə Jeju ajɨ’de. ");
INSERT INTO gqr_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","In nya kɨ ətɨ bulə de’gɨ ɓol ngayn, kadɨ nje mbiboy’gɨ elita num, nje kingə tujɨ’gɨ ingəi lapiya nga num, nje mote’gɨ njiyəi num, taa njekumtɔ’gɨ kaa oyi lo num tɔ, adɨ uləi tɔjɨ dɔ Luwə’tɨ lə Isirayel’gɨ. ");
INSERT INTO gqr_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jeju ɓar njendo’gɨ lə’ne el’de ene: «M’oo kumtondoo lə bulə de’gɨ kin, tadɔ ndɔ mutə ɓone ə in sə’m nan’tɨ, ningə, nya kɨ kadɨ sɔi goto. Ningə m’ge kadɨ m’inyə’de kɨ me’de kɨ ɓo ba el, nan to ɓo ində taa tɔgɨ’de row’ə.» ");
INSERT INTO gqr_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ə njendo’gɨ li’ə dəji’ə eyina: «J’a j’in kɨ mapa ra diləlo’tɨ ne, ə bulə de’gɨ kɨ ətɨ ɓol be kin a sɔi asɨ’de wa?» ");
INSERT INTO gqr_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ningə Jeju dəjɨ’de ene: «Mapa kɨ ji’se’tɨ in bann wa?» Ə eli’ə eyina: «Mapa in siri kɨ ngann kanjɨ’gɨ nden dɔ’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ə Jeju ilə ndu’ne adɨ bulə de’gɨ kadɨ sii nanga. ");
INSERT INTO gqr_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ningə ɔy mapa kɨ siri kɨ ngann kanjɨ’gɨ kakin ji’ne’tɨ, ra oyo Luwə dɔ’tɨ, ningə gangɨ nan’tɨ, adɨ njendo’gɨ lə’ne, adɨ adi bulə de’gɨ sɔi. ");
INSERT INTO gqr_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","De’gɨ pətɨ sɔi nya ndanni, adɨ njendo’gɨ kawi gində’gɨ kɨ nanyi rosɨ kara siri. ");
INSERT INTO gqr_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","De’gɨ kɨ sɔi nya, asi dingəm’gɨ dər sɔ, de tudə dene’gɨ kɨ ngann’gɨ kɨ sɔi nya səm’tɨ el. ");
INSERT INTO gqr_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Go’tɨ, Jeju inyə bulə de’gɨ adɨ awi, ningə al me to’tɨ, aw dɔnangɨ Magadan’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Parisɨ’gɨ kɨ Sadusi’gɨ, rei rɔ Jeju’tɨ dəji’ə kadɨ ra nyakɔjɨ kɨ in dɔran’tɨ adɨ’de n’oyi. Dəji’ə be, to kuləkikiyə tadɔ kuwə’n’ə. ");
INSERT INTO gqr_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ə Jeju ilə’de’tɨ ene: «Lokɨ kadɨ aw to ur ningə eli eyina: “Lo a to majɨ, tadɔ dɔran kər njoo.” ");
INSERT INTO gqr_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Lokɨ lo ti kɨ sin ba ningə, eli eyina: “Ɓone ndi a ədɨ, tadɔ dɔran kər wuu.” In be ə, asi kadɨ gəri ɓal kum dɔran, nga ra bann be ə nyakɔjɨ’gɨ kɨ isɨ rai nya dɔkagilo’tɨ kɨ ɓone taa asi gər el wa! ");
INSERT INTO gqr_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","De’gɨ kɨ dɔkagilo’tɨ kɨ ɓone, in de’gɨ kɨ majel, kɨ njekuwə marum, ndigi kadɨ n’oyi nyakɔjɨ, nan nyakɔjɨ madɨ kɨ rangɨ kɨ kadɨ a oyi ore dɔ nyakɔjɨ lə Jonasɨ goto nga.» Ningə inyə’de, ə ɔtɨ aw. ");
INSERT INTO gqr_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Lokɨ isɨ awi dow ba’tɨ kɨ kare, me njendo’gɨ oy dɔ mapa’tɨ kɨ kadɨ ɔyi. ");
INSERT INTO gqr_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Nga ningə Jeju el’de ene: «Oyi majɨ! Indəi kumkədɨ dɔ rɔ’se’tɨ, ɔjɨ’n dɔ hum lə Parisɨ’gɨ, kɨ hum lə Sadusi’gɨ.» ");
INSERT INTO gqr_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Nan ingɨ isɨ mərita kin yo dɔ’de’tɨ eyina: «In tadɔ kɔy kɨ j’ɔyi mapa el!» ");
INSERT INTO gqr_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Nan Jeju gər mərta lə’de, adɨ el’de ene: «In de’gɨ kɨ kunme lə’se in ndikiri ba, tadɔ ri ə isɨ mərita kɨ dɔ mapa’tɨ kɨ ɔyi el wa? ");
INSERT INTO gqr_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","In gəri me nya’gɨ el kaa ɓay wa? Me’se olo dɔ mapa’tɨ kɨ mi kɨ dingəm’gɨ dər mi sɔi kin el wa? Ndɔkɨ ɔyi ndəgə kɨ nanyi kara bann ə in təli wa? ");
INSERT INTO gqr_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Taa mapa kɨ siri kɨ dingəm’gɨ dər sɔ sɔi kin kaa me’se olo dɔ’tɨ el num tɔ wa? Ndɔkɨ ɔyi ndəgə kɨ nanyi kara bann ə in təli wa? ");
INSERT INTO gqr_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ta kɨ m’el m’ene: Indəi kumkədɨ dɔ rɔ’se’tɨ, ɔjidɔ hum lə Parisɨ’gɨ, kɨ hum lə Sadusi’gɨ kin, in ta kɨ sɔw dɔ mapa el, kin ra bann be ə asi kadɨ gəri me’ə el wa?» ");
INSERT INTO gqr_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Lo kin’tɨ nga a gəri tokɨ el’de kadɨ n’indəi kumkədɨ dɔ rɔ’de’tɨ, ɔjidɔ hum ra mapa el, nan ɔjidɔ nyando lə Parisɨ’gɨ kɨ Sadusi’gɨ. ");
INSERT INTO gqr_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Lokɨ Jeju aw te dɔnangɨ Sejare’tɨ kɨ Pilipɨ, dəjɨ njendo’gɨ lə’ne ta ene: «De’gɨ isɨ elita kɨ dɔ’m’tɨ tokɨ, m’in Ngonn de m’in nan wa?» ");
INSERT INTO gqr_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ə Njendo’gɨ eli’ə eyina: «De’gɨ madɨ eli eyina in Jan Batisɨ; nje kɨ nungɨ eyina in njekeltakita Luwə’tɨ Eli, nje kɨ rangɨ ɓay eyina in njekelta kɨ ta Luwə’tɨ Jeremi eke kɨ kare dann de’gɨ’tɨ kɨ njekeltakita Luwə’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Lo kin’tɨ, Jeju el’de ene: «Nga inɓe’gɨ kɨ dɔ’se, eli eyina m’in nan wa?» ");
INSERT INTO gqr_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ə Simon Piyər ilə’tɨ ene: «In Kirisitɨ, De kɨ Luwə mbət’ə, Ngonn lə Luwə kɨ nje kisi kum ba!» ");
INSERT INTO gqr_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ningə Jeju el Simon ene: «In nje majikur, Simon kɨ ngonn Jonasɨ, tadɔ in de ə te kɨ dɔ nya kin adi in gər el, nan in Bai kɨ nje kisi me dɔran’tɨ taa ə te kɨ dɔ’a adi. ");
INSERT INTO gqr_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nga ningə m’a m’el’i m’ene in Piyər (kɨ kɔr me’ə nan Mbal), ningə dɔ mbal’tɨ kin ə m’a m’ində ngirə *Njekawnan’gɨ lə’m dɔ’tɨ. Tɔgɨ koy a ra si’ə nya madɨ el. ");
INSERT INTO gqr_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","M’a m’ad’i lakele Konɓe lə Luwə. Ningə nya’gɨ pətɨ kɨ a dɔ dɔnangɨ’tɨ ne, a dɔi dɔran’tɨ tɔ, ə nya’gɨ pətɨ kɨ a tutɨ dɔnangɨ’tɨ ne, a tuti dɔran’tɨ tɔ.» ");
INSERT INTO gqr_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ningə ndəjɨ njendo’gɨ kɨ tɔgɨ’ne tokɨ k’in ne Kirisitɨ, de kɨ Luwə mbət’ə kin, kadɨ eli taa de madɨ el. ");
INSERT INTO gqr_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","In dɔkagilo’ə’tɨ non, Jeju ulə ngirə tɔjɨ njendo’gɨ adɨ gəri tokɨ, majɨ kadɨ n’aw Jerujalem, n’ingə kon ngayn ji ngatɔgɨ’gɨ’tɨ lə Juwipɨ’gɨ, kɨ kibo’gɨ lə njekujənyamosɨ kadikare’gɨ, kɨ njendo ndukun’gɨ. A tɔli’ne, nan ndɔ kɨ kon mutə tum ginn’ə ndɔ koy’ne’tɨ, ə n’a n’te lo koy’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Nan dɔ ta’tɨ kin, Piyər ɔr Jeju aw si’ə gədikare, ningə ulə ngirə ndang’a ene: «Luwə a ngəmi, jagɨ Burəɓe, a adɨ nya kin te dɔ’i’tɨ el!» ");
INSERT INTO gqr_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Nan Jeju təl rɔ’ne, el Piyər ene: «Təl gogɨ Satan, ɔr rɔ’i kɔ sanyi rɔ’m’tɨ! In jigɨ kɨ nje tugə’m, tadɔ mərta lə’i in mərta kɨ in rɔ Luwə’tɨ el, nan in mərta lə de’gɨ.» ");
INSERT INTO gqr_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ningə go’tɨ, Jeju el njendo’gɨ lə’ne ene: «Re de madɨ ndigɨ njiyə go’m’tɨ ningə, kadɨ oo rɔ’ne to nya madɨ el, kadɨ in ɓe un kagidəsɨ koy lə’ne, ə re un go’m. ");
INSERT INTO gqr_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Be ə tokɨ rɔta’tɨ, de kɨ ge kajɨ rɔ’ne inɓe dɔnangɨ’tɨ ne a ilə rɔ’ne kɔ. Nan de kɨ ilə rɔ’ne kɔ tadɔ lə’m, a isɨ kɨ dɔ’ne taa gogɨ. ");
INSERT INTO gqr_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Kin ə re de ingə nyamajɨ’gɨ kɨ dɔnangɨ’tɨ ne pətɨ tigə, nan ndil’ə tujɨ ə, maj’a to ra be wa? Nya madɨ kɨ de a adɨ ɔr’n tor ndil’ne to non wa? ");
INSERT INTO gqr_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","M’in Ngonn de m’a m’re kɨ malayka’gɨ lə’m me tɔjɨ’tɨ lə Bai Luwə, ningə m’a m’ugə goji de kɨ ra kigo kulə ra’a’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Tokɨ rɔta’tɨ, adɨ m’el’se: de’gɨ madɨ dann’se’tɨ ne a oyi el ɓay ə a oyi m’in Ngonn de kɨ a re to Ngar kin taa.» ");
INSERT INTO gqr_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ndɔ mehen go’tɨ, ningə Jeju ɔr Piyər num, Jakɨ num, taa Jan kɨ ngonnkon Jakɨ num tɔ, ə aw se’de, dɔ mbal’tɨ kɨ ngal sanyi kɨ ndəgə’gɨ. ");
INSERT INTO gqr_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Low’ə’tɨ non, Jeju mbəl takum’ne. Ta kum’ə unjɨ to kadɨ be, taa ku kɨ rɔ’a’tɨ kaa unjɨ to kadɨ be tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ningə low’ə’tɨ non, Mojɨ ingɨ kɨ Eli tei kɨ rɔ’de’tɨ bus, ra elita kɨ Jeju. ");
INSERT INTO gqr_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ə Piyər un ta el Jeju ene: «Burəɓe, kin ə j’isi lo kin’tɨ ne be par ə majɨ ngayn. Re in ge ə, m’a m’ra *kəyku’gɨ lo mutə: kare in yan’i, kare in nya Mojɨ, ə kɨ kare in nya Eli tɔ.» ");
INSERT INTO gqr_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Lokɨ Piyər ra elta ta’ne’tɨ ba ɓay ningə nyɨ, kilndi kɨ kunj’ə to, in dow dɔ’de bigum. Ningə ndu ta madɨ te me kilndi’tɨ ene: «In kam in Ngonn’m, m’ndig’ə ngayn, in kɨ nəl’m ngayn kadɨ m’mbət’ə, ə oyi ta li’ə.» ");
INSERT INTO gqr_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Lokɨ njendo’gɨ oyi dɔ ta kin ningə, osi kɨ takum’de nanga, ɓol tɔl’de. ");
INSERT INTO gqr_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ə Jeju re rɔ’de’tɨ, ɔdɨ’de ə el’de ene: «Indəi taa, ə adi ɓol ra’se el.» ");
INSERT INTO gqr_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Nga ningə, lokɨ eyina n’uni kum’de kɨ taa ningə, oyi de madɨ kɨ rangɨ el, oyi Jeju kɨ kar’ne ba par. ");
INSERT INTO gqr_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Lokɨ in dɔ mbal’tɨ isɨ uri nanga ningə, Jeju ində ndu kin non’de’tɨ ene: «Eli nya kɨ ra nya adɨ oyi kin de madɨ el, bitɨ kadɨ m’in Ngonn de m’te dann njekoy’gɨ’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Go’tɨ, njendo’gɨ dəji’ə eyina: «Tadɔ ri inɓe ə, njendo ndukun’gɨ eyina majɨ kadɨ Eli re kete taa wa?» ");
INSERT INTO gqr_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ə ilə’de’tɨ ene: «In kɨ rɔta’tɨ kadɨ Eli a re kadɨ ra go nya’gɨ pətɨ adɨ asɨ nan gogɨ.» ");
INSERT INTO gqr_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ningə m’in, adɨ m’el’se madɨ oyi, Eli re ə binəm, ə de’gɨ gəri el, adɨ rai si’ə nya kɨ me’de ge. Be tɔ a, Ngonn de kaa a ingə’n kon ji’de’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Lo kin’tɨ, njendo’gɨ gəri kadɨ ta kɨ Jeju el’de kin sɔw dɔ Jan Batisɨ. ");
INSERT INTO gqr_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Lokɨ təli isɨ rei kɨ rɔ bulə de’gɨ’tɨ, dingəm madɨ kare re rɔ Jeju’tɨ, ɔsɨ məkəsi’ne nanga non’a’tɨ, el’ə ene: ");
INSERT INTO gqr_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","«Burəɓe, oo kumtondoo lə ngonn’m kɨ dingəm, kɨ damsil ra’a adɨ ingə kon ngayn kin. Dɔkagilo’gɨ madɨ, isɨ tosɨ kɨ por’o ge kɨ me mann’tɨ ge. ");
INSERT INTO gqr_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","M’re si’ə rɔ njendo’gɨ lə’i, nan asi kadɨ adi’ə ingə lapiya, el.» ");
INSERT INTO gqr_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Lo kin’tɨ Jeju un ta el ene: «In de’gɨ kɨ dɔkagilo’tɨ kɨ ɓone kɨ in nje me ngan, njera nya kɨ majel, kadɨ to m’njɨ sese bitɨ kagilo bann ɓay taa kadɨ uni me’se adi m’in wa? Ke kadɨ m’a m’ɔsɨ ginn’se bitɨ kagilo bann taa wa? Rei si’ə rɔ’m’tɨ ne.» ");
INSERT INTO gqr_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ningə Jeju ndangɨ ndil kɨ majel ad’a te rɔ ngonn’tɨ, par ə tanan’tɨ non, ngonn ingə lapiya nga. ");
INSERT INTO gqr_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Go’tɨ, njendo’gɨ rei rɔ Jeju’tɨ, lokɨ in si’ə kɨ kar’de ba, dəji’ə eyina: «Tadɔ ri ə kete j’in j’asɨ kadɨ jɨ tuwə ndil kin el wa?» ");
INSERT INTO gqr_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ə Jeju ilə’de’tɨ ene: «Asi el, tadɔ kunme lə’se in ndikiri ba. Ningə kadɨ m’el’se tokɨ rɔta’tɨ, re awi kɨ kunme kɨ in ndikiri ba to kandɨ kagɨ kɨ ɓari’ə mutardə kin be mindɨ kaa, a eli mbal kam eyina: “Ɔtɨ, aw ra nu be” ə, a ɔtɨ kadɨ aw ra. Nya kɨ a dum dɔ’se goto.»  ");
INSERT INTO gqr_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Taa, ko ndil’gɨ kɨ be kin, de a tuwə’de kɨ takul kelta kɨ Luwə kɨ kɔgɨ rɔ nyakusɔ ta. ");
INSERT INTO gqr_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ndɔ kare njendo’gɨ sii nan’tɨ pətɨ Galile’tɨ, ə Jeju el’de ene: «A uləi m’in Ngonn de ji de’gɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Kadɨ a tɔli m’in, nan ndɔ kɨ kon mutə go koy’m’tɨ, ə m’a te lo koy’tɨ.» Ta kin ɔr tɔgɨ njendo’gɨ ə təl ɔr ɓay. ");
INSERT INTO gqr_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Lokɨ Jeju in kɨ njendo’gɨ rei tei Kapernayim’tɨ, nje kɨ isɨ taai lambo me Kəy’tɨ lə Luwə rei rɔ Piyər’tɨ dəji’ə eyina: «Njendo’se nya ugə lambo kɨ me Kəy’tɨ lə Luwə el wa?» ");
INSERT INTO gqr_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ə Piyər ilə’de’tɨ ene: «Oyo, ugə lambo.» Ningə Piyər re te ɓe ningə, Jeju un ta kete el’ə ene: «Mərta lə’i in ri ə Simon? Nan’gɨ ə in njetalambo’gɨ kɨ nje taa nyagangɨ’gɨ dɔ de’gɨ’tɨ kɨ ngar’gɨ kɨ dɔnangɨ’tɨ ne gangi wa? In ngann nje ɓe’gɨ eke in mbah’gɨ wa?» ");
INSERT INTO gqr_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ə Piyər el’ə ene: «In mbah’gɨ.» Lokɨ ene: «Mbah’gɨ», Jeju ene: «Re in be ə, ngann nje ɓe’gɨ, rai kare ənn. ");
INSERT INTO gqr_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Nan re in be kaa, kadɨ j’in ə jɨ təl jigɨ tugə de’gɨ kam el, ə aw babo’tɨ, ilə kuy, uwə’n kanjɨ kɨ dɔkete kɨ a re un kuy, ningə te ta’a, ə a ingə silə kare ta’a’tɨ, kadɨ ugə’n lambo lə’i, lə’m tɔ.» ");
INSERT INTO gqr_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Dɔ kad’a’tɨ inɓe kin, njendo’gɨ rei dəji Jeju eyina: «Nan ə in kibo me Konɓe’tɨ lə Luwə wa?» ");
INSERT INTO gqr_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ə Jeju ɓar ngonn kɨ du ad’a re ra dann’de’tɨ, ");
INSERT INTO gqr_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ningə el’de ene: «Tokɨ rɔta’tɨ, adɨ m’el’se, re in mbəli təli toi to ngann’gɨ be el ə, a uri me Konɓe’tɨ lə Luwə el. ");
INSERT INTO gqr_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","De kɨ sɔl dɔ’ne lɔm lɔm to ngonn be ə, de’ə kin a in kibo ngayn me Konɓe’tɨ lə Luwə. ");
INSERT INTO gqr_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Re de uwə ngonn kɨ be kin rɔ’ne’tɨ, me tɔ’m’tɨ ə, in m’inɓe ə de’ə kin uwə’m rɔ’ne’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","«Kin ə tokɨ de madɨ ra adɨ kɨ kare dann nje kɨ du’tɨ kam kɨ uni me’de adɨ m’in, osɨ me majel’tɨ ə, in sotɨ ngayn ɓay tadɔ li’ə kadɨ dɔi mbal kibo ngayn mində’tɨ, ə ɔsi’ə iləi’ə ɓul ba’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Kumtondoo kɨ dɔ de’gɨ’tɨ kɨ dɔnangɨ’tɨ kɨ nje re kɨ nya’gɨ kɨ isɨ tugəi madɨ de’gɨ jigɨ’tɨ adɨ osi. Tokɨ rɔta’tɨ, majɨ kadɨ nya’gɨ kɨ nje tugə de’gɨ jigɨ’tɨ toi, nan kumtondoo in lə de kɨ njera kadɨ de osɨ. ");
INSERT INTO gqr_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Kin ə ji’i eke nja’i rai nu adɨ osɨ me majel’tɨ ə, gangɨ’de ilə’de kɔ sanyi. Tadɔ, in sotɨ kadɨ ingə kajɨ kɨ ji’i kɨ kare eke nja’i kare, utə kadɨ in ngəm ji’i’gɨ joo pətɨ, eke nja’i’gɨ joo pətɨ, ə iləi nu me por’tɨ kɨ bitɨ kɨ non’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Kin ə kum’i kare rai adɨ osɨ majel’tɨ ə, ɔr’ɔ ilə kɔ sanyi. Tadɔ, in sotɨ kadɨ ingə kajɨ kɨ kum’i kɨ kare, utə kadɨ in ngəm kum’i’gɨ joo pətɨ, ə iləi nu me dilə por’tɨ kɨ bitɨ kɨ non’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Oyi majɨ! Kadɨ kidi kɨ kare dann ngann’gɨ’tɨ kin el, tadɔ, tokɨ rɔta’tɨ, malayka’gɨ lə’de sii kɨ dɔkagilo’gɨ pətɨ, takum Bai’tɨ kɨ isɨ dɔran’tɨ taa.  ");
INSERT INTO gqr_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Tadɔ m’in Ngonn de m’re tadɔ kajɨ de’gɨ kɨ nanyinan. ");
INSERT INTO gqr_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","«De madɨ aw kɨ batɨ’gɨ ɓu, ə in kɨ kare nanyi, ningə, inyə ndəgə’gɨ kɨ dɔjikara gidə in jikara dɔ mbal’tɨ, ə aw sangɨ in kɨ nanyi kakin. Eke kigo ko’ə’tɨ lə’se, ta ri ə a eli dɔ lo kin’tɨ wa? ");
INSERT INTO gqr_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Tokɨ rɔta’tɨ, adɨ m’el’se, re ingə batɨ kɨ nanyi kin ə, rɔ’a a nəl’ə ngayn dɔ’a’tɨ utə nje kɨ dɔjikara gidə in jikara kɨ nanyinan el kin. ");
INSERT INTO gqr_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Be tɔ ə, Baw’se kɨ isɨ me dɔran’tɨ, ge kadɨ kɨ kare dann ngann’gɨ’tɨ kaa nanyi kɔ el.» ");
INSERT INTO gqr_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","«Lokɨ ngonnkon’i ra majel ə, aw ingə, in si’ə joo ba, ningə ulə ji’i dɔ majel’tɨ li’ə kɨ ra, ad’a gər. Re oo ta lə’i ningə, in ingə ngonnkon’i gogɨ. ");
INSERT INTO gqr_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","A re oo ta lə’i el ningə, aw un de kɨ rangɨ kare, eke de’gɨ joo sə’i, aw ingə’n’ə ɓay. In ra be kadɨ “nya’gɨ pətɨ in kɨ kun ndu dɔ’tɨ kigo ta’tɨ lə de’gɨ joo eke mutə kɨ kadɨ manyinaj’a”. ");
INSERT INTO gqr_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Kin ə re mbətɨ koo ta lə’de ə, el njekawnan’gɨ. Ə re mbətɨ koo ta lə Njekawnan’gɨ ɓay tɔ ningə, kadɨ oo’ə to de kɨ gər Luwə el, eke to njetalambo be. ");
INSERT INTO gqr_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Tokɨ rɔta’tɨ, adɨ m’el’se: nya’gɨ pətɨ kɨ a dɔi dɔnangɨ’tɨ ne, a dɔi dɔran’tɨ tɔ, ə nya’gɨ pətɨ kɨ a tutɨ dɔnangɨ’tɨ ne, a tuti dɔran’tɨ tɔ.» ");
INSERT INTO gqr_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","«Tokɨ rɔta’tɨ, m’el’se m’adɨ in gəri ɓay: re de’gɨ joo dann’se’tɨ, indəi ndu’de nan’tɨ dɔnangɨ’tɨ ne, kadɨ dəji nya ri kɨ uwə me’de ə, Bai kɨ isɨ me dɔran’tɨ a adɨ’de. ");
INSERT INTO gqr_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Tadɔ lokɨ de’gɨ joo eke mutə kawinan, me tɔ’m’tɨ ə, m’in dann’de’tɨ non.» ");
INSERT INTO gqr_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Lo kin’tɨ, Piyər ɔtɨ kɨ rɔ Jeju’tɨ dəj’ə ene: «Burəɓe, kin ə ngonnkon’m ra sə’m majel ə, kadɨ m’inyə go kɔ nja bann m’ad’a wa? Kadɨ m’inyə go kɔ bitɨ nja siri wa?» ");
INSERT INTO gqr_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ə Jeju el’ə ene: «M’el m’ene bitɨ nja siri el, nan bitɨ nja dɔsiri nja siri.» ");
INSERT INTO gqr_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","«In be ə, Konɓe lə Luwə to to ta kin be: Ndɔ kare ngar madɨ ge kadɨ nje ra kulə’gɨ lə’ne udəi kɔr nya’gɨ lə’ne non’ne’tɨ adɨ n’oo. ");
INSERT INTO gqr_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ə ulə ngirə, adɨ rei kɨ in kɨ kadɨ a ad’a nar kɨ dum kudə kɔr’ɔ. ");
INSERT INTO gqr_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Nan dingəm kakin aw kɨ nya kɨ kadɨ ugə’n ɓangɨ kin el, adɨ ɓe’ə un ndu’ne kadɨ ndogi’ə, ne’ə kɨ ngann’a’gɨ, kɨ nya majɨ’gɨ li’ə ba pətɨ tor ɓangɨ’tɨ kin. ");
INSERT INTO gqr_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ə nje ra kulə osɨ nanga non ɓe’ne’tɨ, non uwə nja’a ene: “Sɨ sə’m dɔ’tɨ, ə m’a m’ugə’i ɓangɨ kin pətɨ.” ");
INSERT INTO gqr_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Nga a, lo kin’tɨ, ɓe’ə oo kumtondoo li’ə, adɨ inyə ɓangɨ kɨ dɔ’a’tɨ kin kɔ, ə inyə’ə adɨ aw kare. ");
INSERT INTO gqr_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","«Lokɨ de kɨ ɓangɨ in dɔ’a’tɨ kakin ene n’te kɨ taga ningə, ingə madikulə li’ə kare kɨ in, aw kɨ ɓangɨ lə’ne kɨ nden be par dɔ’a’tɨ, ə osɨ si’ə uwə, səkirə mind’ə, ningə el’ə ene: “Ugə’m ɓangɨ kɨ dɔ’i’tɨ!” ");
INSERT INTO gqr_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ə mad’a osɨ nanga non’a’tɨ, non dɔ’a’tɨ ene: “Sɨ sə’m dɔ’tɨ, ə m’a m’ugə’i ɓangɨ kin.” ");
INSERT INTO gqr_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Nan mbətɨ, adɨ aw si’ə bitɨ ilə dangay’tɨ, nginə’n ta ɓangɨ kɨ kadɨ ugə’n’ə. ");
INSERT INTO gqr_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Lokɨ madikulə’gɨ oyi nya kɨ ra kin ningə, to rɔ’de ngayn adɨ ai ɔri poy nya’gɨ kin pətɨ ɓe’de adi’ə oo. ");
INSERT INTO gqr_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ə ngar ɓar’a ad’a re, ningə el’ə ene: “In nje ra kulə kɨ majel, m’inyə go ɓangɨ kɨ dɔ’i’tɨ pətɨ kɔ tadɔ non kɨ in non dɔ’m’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Nga in, ri ə ɔgi kadɨ oo kumtondoo lə mad’i tokɨ m’in m’oo’n kumtondoo lə’i kin be tɔ el wa? ");
INSERT INTO gqr_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Lo kin’tɨ, wongɨ ra ɓe’ə dɔ’a’tɨ ngayn, adɨ ilə dangay’tɨ, lo ra kulə’tɨ kɨ kon, bitɨ kadɨ ugə’n ɓangɨ kɨ dɔ’ne’tɨ pətɨ tigə. ");
INSERT INTO gqr_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ningə Jeju ilə dɔ’tɨ ene: In be tɔ ə, Bai kɨ isɨ dɔran’tɨ taa, a ra’n’se, lokɨ de madɨ dann’se’tɨ, inyə go majel kɔ k’inyə kɨ in ngarme’ə’tɨ adɨ ngonnkon’ne, el.”» ");
INSERT INTO gqr_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Lokɨ Jeju tɔlta ta’gɨ ningə, ɔtɨ Galile’tɨ, aw dɔnangɨ Jude’tɨ, gidɨ ba Jurden’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Bulə de’gɨ ngayn uni go’ə, adɨ ajɨ’de dɔ monyi’gɨ’tɨ lə’de. ");
INSERT INTO gqr_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Parisɨ’gɨ ɔti rei rɔ Jeju’tɨ, dəji’ə ta to kuləkikiyə tadɔ kuwə’n’ə eyina: «Ndukun lə’je adɨ tarow kadɨ dingəm tuwə ne’ne, ɔjidɔ nya kɨ ra kɨ ra adɨ nəl’ə el eke adɨ tarow el wa?» ");
INSERT INTO gqr_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ə Jeju ilə de’tɨ ene: «In tudəi Makitu lə Luwə kɨ ndangi kin el bitɨ wa? “Lo kulə ngirə kində nya’gɨ’tɨ Luwə ra dingəm kɨ dene’, ");
INSERT INTO gqr_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ningə el ene: in be ə, dingəm a inyə baw’ne kɨ kon’ne, ningə a tinyəi nan kɨ ne’ne kadɨ təli darɔ kɨ kare. ");
INSERT INTO gqr_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Lo kin’tɨ, a in joo el nga, nan in darɔ kɨ kareba. Ningə nya kɨ Luwə dɔɔ nan’tɨ, majɨ kadɨ de gangɨ nan’tɨ el.”» ");
INSERT INTO gqr_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ə eli Jeju eyina: «Nga ra bann be ə Mojɨ adɨ ndu ene re dingəm tuwə ne’ne ningə majɨ kadɨ ad’a makitu gangɨ nan ji’ə’tɨ wa?» ");
INSERT INTO gqr_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jeju təl el’de ene: «In tadɔ me ngan lə’se ə Mojɨ adɨ’n’se tarow kadɨ tuwəi ne’se’gɨ, nan lo kulə ngirə nya’gɨ’tɨ, in be el. ");
INSERT INTO gqr_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nga ningə, adɨ m’el’se, re de tuwə ne’ne, tadɔ nya kɨ rangɨ um in ta lə kaya kɨ ra el, ə taa dene kɨ rangɨ ə, de’ə kin təl njekuwə marum.» ");
INSERT INTO gqr_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Lo kin’tɨ, njendo’gɨ li’ə eli’ə eyina: «Re in kin ə in ndu kɨ to dɔ dingəm’tɨ kɨ rɔ dene’tɨ ə, taa dene el in sotɨ.» ");
INSERT INTO gqr_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ə Jeju el’de ene: «De’gɨ pətɨ gəri me ta kin el, nan nje kɨ Luwə adi’de ta row’ə par. ");
INSERT INTO gqr_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","De’gɨ madɨ in non, taai dene el, tadɔ tɔgɨ’de sangɨ dene goto, ningə in nya kɨ tei me kon’de’tɨ nu; nje kɨ madɨ’gɨ in tadɔ kɔr kɨ ɔri’de kujɨ, ə nje kɨ nungɨ, mbeti taa dene tadɔ Konɓe lə Luwə tɔ. De kɨ asɨ kadɨ gər me ta kin ningə kadɨ gər.» ");
INSERT INTO gqr_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","De’gɨ rei kɨ ngann’gɨ kɨ du rɔ Jeju’tɨ kadɨ njangɨ dɔ’de, ə elta kɨ Luwə tadɔ lə’de, nan njendo’gɨ ndangi’de. ");
INSERT INTO gqr_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ə Jeju el ene: «Inyəi ngann’gɨ kɨ du adɨ rei kɨ rɔ’m’tɨ, um ɔgi’de tarow el, tadɔ Konɓe lə Luwə in yan de’gɨ kɨ toi to ngann’gɨ kɨ du be.» ");
INSERT INTO gqr_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Go’tɨ, Jeju njangɨ dɔ’de, ə ɔtɨ ilə dɔ’ne aw lo kɨ rangɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ndɔ kare, dingəm kare re rɔ Jeju’tɨ, ningə dəj’ə ene: «Njendo de’gɨ, in ri kɨ majɨ, ə kadɨ m’ra, ə m’a m’ingə’n kajɨ kɨ to bitɨ kɨ non’tɨ wa?» ");
INSERT INTO gqr_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ə Jeju el’ə ene: «Tadɔ ri ə dəjɨ’m ta dɔ nya kɨ majɨ’tɨ wa? De kɨ majɨ in kareba. Re in ge kur me kumngayira’gɨ ningə, in təl rɔ’i go mbərkikində’gɨ’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ə dingəm kakin dəjɨ Jeju ene: «Mbərkikində’gɨ kɨ ra wa?» Ningə Jeju ilə’tɨ ene: «A tɔl de el, a uwə marum el, a ɓogɨ el, a mannajɨ kɨ ngom dɔ mad’i’tɨ el, ");
INSERT INTO gqr_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ɔsi kurə baw’i kɨ kon’i, taa a ndigɨ de mad’i to darɔ’i in ɓe be.» ");
INSERT INTO gqr_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ningə ngonn kɨ basa ene: «Nya’gɨ kin pətɨ, m’təl rɔ’m go’tɨ nga. Nga kɨ ne kin, in ri ɓay ə nanyi’m kadɨ m’ra wa?» ");
INSERT INTO gqr_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ə Jeju el’ə ene: «Re ge kadɨ asɨ nan tapɨ takum Luwə’tɨ ningə, aw, adɨ ndogi sə’i nya majɨ’gɨ lə’i pətɨ, lowə nar’a njendoo’gɨ, ningə a aw kɨ nyakingə ngayn dɔran’tɨ, ə un go’m.» ");
INSERT INTO gqr_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Nan lokɨ ngonn kɨ basa oo ta’gɨ kin ningə, ɔtɨ aw kɨ rɔnel el, tadɔ in de kɨ aw kɨ nyakingə’gɨ ngayn. ");
INSERT INTO gqr_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ə Jeju el njendo’gɨ lə’ne ene: «Tokɨ rɔta’tɨ, adɨ m’el’se, a ngan ngayn kɨ rɔ njenyakingə’tɨ kadɨ ur me Konɓe’tɨ lə Luwə, ");
INSERT INTO gqr_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","ningə m’təl m’el’se ɓay, in nya kɨ ngan ngayn kadɨ jambal ur bolo konn kur nya’tɨ, nan a ngan ngayn utə in kin ɓay kadɨ njenyakingə ur me Konɓe lə Luwə.» ");
INSERT INTO gqr_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ta kin ətɨ njendo’gɨ ɓol ngayn, adɨ eli eyina: «Nga kin ə in be ningə, nan ə asɨ kadɨ ingə kajɨ wa?» ");
INSERT INTO gqr_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ə Jeju ində manjɨ’de ba ningə el’de ene: «Kɨ rɔ de’gɨ’tɨ lowə goto, nan kɨ rɔ Luwə’tɨ lo ra nya’gɨ pətɨ to.» ");
INSERT INTO gqr_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ə Piyər un ta el’ə ene: «Nga oo, j’in kɨ j’inyə nya’gɨ lə’je pətɨ, ə j’un go’i kin, ri ə j’a j’ingə wa?» ");
INSERT INTO gqr_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ə Jeju ilə’tɨ ene: «Tokɨ rɔta’tɨ, adɨ m’el’se: ndɔ kɨ nya’gɨ pətɨ a indəi ngirə’de kində kɨ sigɨ, ə m’in Ngonn de m’a m’njɨ dɔ kumbər konɓe’tɨ lə’m, kɨ de’gɨ a tɔji’m’in kin ningə, ingɨ kɨ uni go’m kin, ingɨ kaa a isɨ dɔ kumbər konɓe’tɨ kɨ dɔgɨ gidə in joo kadɨ gangɨ ta dɔ ginn kaw Isirayel’tɨ kɨ dɔgɨ gidə in joo. ");
INSERT INTO gqr_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ningə re de madɨ, inyə kəy lə’ne, kɨ ngannkon’ne’gɨ, kɨ konnann’ne’gɨ, kɨ kon’ne, kɨ baw’ne, kɨ ngann’ne’gɨ eke dɔnangɨ lə’ne tadɔ lə’m ə, a ingə nya’gɨ kin dɔ’tɨ nja ɓu, taa a ingə kajɨ kɨ a to bitɨ kɨ non’tɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Nga ningə, de’gɨ ngayn kɨ kete, a təli nje kɨ gogɨ, ə de’gɨ ngayn kɨ gogɨ, a təli nje kɨ kete tɔ.» ");
INSERT INTO gqr_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","«Konɓe lə Luwə to to ɓe nje kəy, kɨ te kɨ sin ba kadɨ n’ɔy nje ra kulə’gɨ kadɨ rai kulə me ndɔɔ nju’tɨ lə’ne kin be. ");
INSERT INTO gqr_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ndu’de osɨ nan’tɨ kɨ nje ra kulə’gɨ, kadɨ adi’de nar kɨ lo ra kulə’tɨ kɨ ndɔ kare, ningə adɨ’de awi me ndɔɔ nju’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Lokɨ te kɨ kadɨ kɨ jikara kɨ sin ningə, oo nje ra kulə’gɨ kɨ rangɨ ɓay, kɨ rei rai tambalo’tɨ kɨ kanjɨ ra kulə, ");
INSERT INTO gqr_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","ə el’de ene: “Ingɨ kaa, ai me ndɔɔ nju’tɨ lə’m rai kulə, ə m’a m’adɨ’se nyakugə goji kɨ asɨ gorow’ə’tɨ.” ");
INSERT INTO gqr_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ningə ɔti awi. Lokɨ te taga kɨ kadɨ kɨ jam dɔ ɓe’tɨ num, kɨ kadɨ kɨ kɔtɨ ɓe’tɨ num ningə, ra kah’a’tɨ kakin ɓay. ");
INSERT INTO gqr_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Go’tɨ, te re kɨ kadɨ ra binyə bilə ningə, oo nje ra kulə’gɨ kɨ rangɨ ɓay, kɨ rei rai non, ə el’de ene: “Ra bann ə sii lo kin’tɨ lo sɔl, kɨ kanjɨ ra kulə wa?” ");
INSERT INTO gqr_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ə iləi’ə’tɨ eyina: “De kɨ unn’je kulə’tɨ goto.” Ə el’de ene: “Ingɨ kaa, awi me ndɔɔ nju’tɨ lə’m rai kulə tɔ.” ");
INSERT INTO gqr_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","«Lokɨ kadɨ ur ningə, njendɔɔ nju el njengəm nya li’ə ene: “In ɓar nje ra kulə’gɨ, ə adi’de nyakugə goji’de, ulə ngirə dɔ nje re gogɨ’tɨ, tɔl taa dɔ nje re kete’tɨ.” ");
INSERT INTO gqr_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Nje re kɨ kadɨ ra binyə bilə, nan nan kaa ingə nar kɨ lo kulə’tɨ kɨ ndɔ kare. ");
INSERT INTO gqr_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Lo kin’tɨ, nje re dɔ kete rei yan’de nga ningə, məri kadɨ n’a n’ingəi nar kɨ utə yan madɨ’de’gɨ, nan ingɨ kaa, ingəi nar kɨ lo kulə’tɨ kɨ ndɔ kare inɓe kakin tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Lokɨ isɨ taai nar kin, ɓarita kɨ njendɔɔ ");
INSERT INTO gqr_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","eli eyina: “Nje kɨ rei gogɨ ne kin, rai kulə kadɨ kareba par, ningə in adɨ’de nar kɨ asɨ nan kɨ yan’je, j’in kɨ jɨ ra kulə sin bitɨ kadɨ ur, adɨ kadɨ ndaw’je.” ");
INSERT INTO gqr_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Lo kin’tɨ, nje ndɔɔ elta kɨ kare dann’de’tɨ ene: “Madɨ’m, nya madɨ kare kɨ low’ə’tɨ el kɨ m’ra sə’i goto. Ndu’je sə’i osɨ nan’tɨ dɔ nar’tɨ kɨ lo kulə’tɨ kɨ ndɔ kare el wa? ");
INSERT INTO gqr_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Taa nya lə’i, ə aw. M’ge kadɨ m’adɨ in kɨ re gogɨ nya kin, tokɨ m’ad’i kin be tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","In gorow’ə’tɨ kadɨ nya kɨ me’m ndigɨ ə m’ra kɨ nyakingə lə’m el wa? Eke in ta lə’i kadɨ me’i tujɨ tadɔ majɨ kɨ m’ra wa?” ");
INSERT INTO gqr_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Nga ningə Jeju ilə’tɨ ene: In be ə, nje kɨ gogɨ a təli nje kɨ kete, ə nje kɨ kete a təli nje kɨ gogɨ tɔ.» ");
INSERT INTO gqr_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ta kaw kɨ Jerujalem’tɨ, lokɨ in dɔ row’tɨ, Jeju ujə rɔ’ne kɨ njendo’gɨ kɨ dɔgɨ gidə in joo gədɨ kare, ningə el’de ene: ");
INSERT INTO gqr_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«Oyi, j’isi j’awi kɨ Jerujalem’tɨ, ningə a uləi m’in Ngonn de jɨ kibo’gɨ’tɨ lə njekujənyamosɨ kadikare’gɨ kɨ njendo ndukun’gɨ lə Luwə. A gangi ta koy dɔ’m’tɨ, ");
INSERT INTO gqr_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ningə a uləi m’in jɨ de’gɨ’tɨ kɨ in Juwipɨ’gɨ el, kadɨ kogi dɔ’m’tɨ ge, tindəi m’in kɨ ndəy hawlay ge, ɓəri m’in kagidəsɨ’tɨ ge. Nan ndɔ mutə tum ginn’ə ndɔ koy’m’tɨ ə, m’a m’te lo koy’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Go’tɨ, kon ngann lə Jebede re kɨ ngann’ne’gɨ rɔ Jeju’tɨ, ningə kon ngann’gɨ ɔsɨ məkəsi’ne nanga non Jeju’tɨ tadɔ dəj’ə nya kare. ");
INSERT INTO gqr_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ə Jeju dəj’ə ene: «In ri ə in ge wa?» Ningə, el’ə ene: «Un ndu’i kadɨ ngann’m’gɨ kɨ joo kam, de kare isɨ dɔjikɔl’i’tɨ, ə in kɨ nungɨ isɨ dɔjigəl’i’tɨ tɔ, lokɨ a isɨ dɔ kumbər Konɓe’tɨ lə’i.» ");
INSERT INTO gqr_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Lo kin’tɨ non, Jeju ilə’tɨ ene: «In gəri me nya dəjɨ lə’se kin el. A asi kadɨ ingəi kɔpɨ kon kɨ m’aw to m’ingə kam kare mindɨ wa?» Ningə eli eyina: «Oyo, j’a j’asɨ kare.» ");
INSERT INTO gqr_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ə Jeju el’de ene: «Kon kɨ m’aw to m’ingə kam, ə rɔta a ingəi kare, nan ta kɨ ɔjidɔ kisɨ dɔjikɔl’m’tɨ eke dɔjigəl’m’tɨ; in ta lə’m kadɨ m’in ə m’adɨ’se el; lo’gɨ kin to tadɔ de’gɨ kɨ Bai Luwə ra go’ə kete nu tadɔ lə’de.» ");
INSERT INTO gqr_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ndəgɨ njendo’gɨ kɨ dɔgɨ, lokɨ oyi ta’gɨ kin, rɔ’de nəl’de kɨ ngann lə Jebede kɨ joo kin el. ");
INSERT INTO gqr_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Be ə, Jeju ɓar’de pətɨ kɨ rɔ’ne’tɨ, el’de ene: «In gəri kadɨ nje konɓe’gɨ dɔ ginn de’gɨ’tɨ kɨ dangɨ dangɨ kɨ dɔnangɨ’tɨ ne, sii uwəi’de ginn tɔgɨ’de’tɨ adi’de kon, taa de’gɨ kɨ njetɔɓar kaa, onyiɓe dɔ’de’tɨ ɓay tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Nan majɨ kadɨ to be dann’se’tɨ el. Re de madɨ dann’se’tɨ, ndigɨ kadɨ n’in kibo ningə, kadɨ təl nje ra kulə lə’se pətɨ. ");
INSERT INTO gqr_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Taa re de madɨ ndigɨ kadɨ n’in de kɨ dɔkete dann’se’tɨ ningə, kadɨ təl njekuləɓər lə’se tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","In be tɔ ə m’in Ngonn de kin m’re kadɨ de’gɨ taa rai kulə adi m’in el, nan kadɨ m’in ə m’ra kulə m’adɨ’de, taa m’adɨ rɔ’m kadɨ m’ugə’n dɔ bulə de’gɨ ngayn m’ilə’de taa tɔ.» ");
INSERT INTO gqr_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Lokɨ Jeju in kɨ njendo’gɨ lə’ne isɨ tei me ɓe’tɨ kɨ Jeriko kɨ taga, bulə de’gɨ ngayn njiyəi go’de’tɨ mukɨ mukɨ. ");
INSERT INTO gqr_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ningə njekumtɔ’gɨ joo sii ngangɨ row’tɨ. Lokɨ oyi kadɨ in Jeju ə isɨ ində dər ningə, uni ndu’ne kɨ taa eyina: «Burəɓe, Ngonnkaw Dabidɨ, oo kumtondoo lə’je!» ");
INSERT INTO gqr_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Bulə de’gɨ ndangi’de kadɨ utɨ ta’de, nan njekumtɔ’gɨ uni ndu’de kɨ taa inɓe ɓay eyina: «Burəɓe, Ngonnkaw Dabidɨ, oo kumtondoo lə’je!» ");
INSERT INTO gqr_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Lo kin’tɨ, Jeju ra lokatɨ, ɓar’de, ningə dəjɨ’de ene: «In ri ə, gei kadɨ m’ra madɨ’se wa?» ");
INSERT INTO gqr_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ə iləi’ə’tɨ eyina: «Burəɓe, jɨ ge kadɨ kum’je te adɨ j’oo’n lo!» ");
INSERT INTO gqr_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jeju oo kumtondoo lə’de, ə ɔdɨ kum’de, par ə tanan’tɨ non, kum’de oo lo, adɨ uni go’ə. ");
INSERT INTO gqr_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Lokɨ Jeju in kɨ njendo’gɨ lə’ne indəi dɔ ɓe kɨ Jerujalem ndəkba kɨ ɓe kɨ Betipaje, kɨ kadɨ mbal kagɨ buni’gɨ’tɨ, ulə njendo’gɨ joo, ");
INSERT INTO gqr_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","el’de ene: «Awi me ngonnɓe’tɨ kɨ ra non’se’tɨ kam. Lo kur inɓe kɨ a uri kɨ me ɓe’tɨ par ə, a ingəi kon koro kɨ dɔi’ə, ngonn koro ra gəd’ə’tɨ, ningə tuti’ə, ə rei se’de adi’m’in. ");
INSERT INTO gqr_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Re de madɨ el’se nya madɨ ə, iləi’ə’tɨ eyina: “Burəɓe ə ge’de,” ə a inyə’de kalangɨ ba kadɨ tuti’de.» ");
INSERT INTO gqr_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Nya kin a ra nya be kadɨ ta kɨ Luwə el kɨ njekeltakita Luwə’tɨ el kin tɔlta’ne: ");
INSERT INTO gqr_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«Eli de’gɨ kɨ Siyon’tɨ eli eyina: Oyi ngar lə’se a re dɔ’se’tɨ, In de kɨ sɔl lɔm lɔm, Isɨ dɔ kon koro’tɨ, in kɨ ngonn koro.» ");
INSERT INTO gqr_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Njendo’gɨ ai, rai tokɨ Jeju el’n’de. ");
INSERT INTO gqr_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Rei kɨ kon koro in kɨ ngonn koro kakin ningə, lɔwi ku’gɨ lə’de gidə’tɨ, ningə Jeju ala isɨ dɔ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Bulə de’gɨ ngayn lɔwi ku’gɨ lə’de go row’tɨ. Nje kɨ nan’gɨ təti mbi kam’gɨ, tiləi dɔ row’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Bulə de’gɨ nje njiyə non Jeju’tɨ kɨ nje njiyə go’ə’tɨ uni ndu’de kɨ taa eyina: «Ojana, Ngonnkaw Dabidɨ! Kadɨ Luwə njangɨ dɔ de kɨ re me tɔ Burəɓe! Ojana, tɔjɨ in kɨ dɔ Nje kisɨ dɔran’tɨ taa!» ");
INSERT INTO gqr_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Lokɨ Jeju ur Jerujalem’tɨ, lokɨ me ɓe’tɨ ba pətɨ ndigɨ ɓir ɓir. Adɨ de’gɨ dəji rɔ’de ta eyina: «In de kɨ bann wa?» ");
INSERT INTO gqr_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ə bulə de’gɨ iləi’de’tɨ eyina: «In Jeju, njekeltakita Luwə’tɨ, kɨ Najaretɨ, dɔnangɨ Galile’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Go’tɨ, Jeju aw ur natɨ Kəy’tɨ lə Luwə, ningə tuwə njelaw nya’gɨ kɨ njendo’gɨ nya’gɨ natɨ Kəy’tɨ lə Luwə kɔ. Jeju sur tabilə’gɨ lə njembəl nar kɨ ɓe’ne kɨ nje kɨ dɔɓe’gɨ’tɨ tilə, nan’tɨ kɨ nya kisɨ lə njelaw dər dum’gɨ. ");
INSERT INTO gqr_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ningə el’de ene: «Ndangi me makitu’tɨ lə Luwə eyina: Kəy lə’m a ɓari’ə kəy kelta kɨ Luwə, nan ingɨ, təli’ə lokiyərɔ lə njeɓogɨ’gɨ yo!» ");
INSERT INTO gqr_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Lo kin’tɨ non, njekumtɔ’gɨ kɨ mote’gɨ, rei rɔ’a’tɨ natɨ Kəy’tɨ lə Luwə, adɨ adɨ’de lapiya. ");
INSERT INTO gqr_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Lokɨ kibo’gɨ lə njekujənyamosɨ kadikare’gɨ kɨ njendo ndukun’gɨ oyi nya’gɨ kɨ ətɨ ɓol kɨ Jeju ra’de, kɨ ndu ngann’gɨ kɨ isɨ ɓar nan’tɨ Kəy lə Luwə ene: «Ojana Ngonnkaw Dabidɨ!» kin ningə, me’de on’de, ");
INSERT INTO gqr_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","adɨ eli Jeju eyina: «Oo ta kɨ ngann’gɨ ra eli kam wa?» Ə Jeju ilə’de’tɨ ene: «Oyo, m’oo, nan ke in tudəi ndu Luwə kɨ ndangi eyina: “Ra adɨ ngann’gɨ kɨ du, kɨ nje to ta mba’tɨ kaa, ta’de ulə tɔjɨ dɔ’i’tɨ” kin el wa?» ");
INSERT INTO gqr_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ningə lo kin’tɨ, Jeju inyə’de non, ə te me ɓebo’tɨ kɔ, aw Betani’tɨ, aw isɨ nu. ");
INSERT INTO gqr_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Lo ti go’tɨ kɨ sin, Jeju təl isɨ re me ɓebo’tɨ, ɓo ra’a. ");
INSERT INTO gqr_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ə oo kagɨ mbaykote kɨ ra kadɨ row’tɨ, tɔ kadɨ n’aw ginn’tɨ, nan lokɨ re ndəkba ningə, oo mbi’ə’gɨ par um oo kanda el. Ə Jeju el mbaykote kakin ene: «A andɨ gogɨ el bitɨ kɨ non’tɨ.» Ningə low’ə’tɨ non, mbaykote tutɨ. ");
INSERT INTO gqr_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Lokɨ njendo’gɨ oyi nya kin, ətɨ’de ɓol ngayn, adɨ dəji ta eyina: «Ra bann ə low’ə’tɨ ne par ə kagɨ tutɨ wa?» ");
INSERT INTO gqr_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ə Jeju ilə’de’tɨ ene: «Tokɨ rɔta’tɨ, adɨ m’el’se, re awi kɨ kunme, ə me’se tɔsɨ el ə, in nya kɨ m’ra kɨ mbaykote kin par ə a rai el, nan re eli mbal kam eyina: “Ɔtɨ lo kin’tɨ rangɨ, aw osɨ me ba’tɨ,” kaa nya kin a ra nya. ");
INSERT INTO gqr_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Nga ningə, nya’gɨ pətɨ kɨ a dəji kɨ kunme, me kelta’tɨ kɨ Luwə ə, a ingəi.» ");
INSERT INTO gqr_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jeju ur me Kəy’tɨ lə Luwə, isɨ ndo nya de’gɨ ningə, kibo’gɨ lə njekujənyamosɨ kadikare’gɨ kɨ ngatɔgɨ’gɨ lə Juwipɨ’gɨ, rei kɨ rɔ’a’tɨ, dəji’ə eyina: «Nan adi tarow kadɨ ra’n nya’gɨ kin be wa? Ə nan tɔ ə adi ndu’ne ə isɨ ra’n wa el’je adɨ j’oo?» ");
INSERT INTO gqr_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ə Jeju təl el’de ene: «M’in kaa m’a m’dəjɨ’se ta kareba be tɔ. Re iləi m’in’tɨ ningə, m’in kaa m’a m’el’se de kɨ adɨ’m tarow kadɨ m’ra’n nya’gɨ kin tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Nan ə ulə Jan kadɨ ra de’gɨ batəm wa? In Luwə eke in de’gɨ wa?» Nan təli ra elinan ta dann’de’tɨ eyina: «Re j’eli’ə j’ene: “In Luwə ə ulə’ə”, a dəjɨ’je ene ke ra bann ə j’uni me’je j’adɨ Jan el wa? ");
INSERT INTO gqr_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","A kin ə re j’eli j’ene: “In de’gɨ ə uləi Jan” ə a in ta kɨ rɔ bulə de’gɨ’tɨ tɔ, tadɔ de’gɨ pətɨ oyi Jan kadɨ in njekeltakita Luwə’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Be ə təli eli Jeju eyina: «Jɨ gər el.» Ə Jeju təl ilə’de’tɨ ene: «Re in be ə m’in kaa m’a m’el’se tɔgɨ kɨ m’njɨ m’ra’n nya’gɨ kin el tɔ.» ");
INSERT INTO gqr_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jeju elta kɨ rangɨ ɓay ene: «Eli’m’in ta lə’se dɔ ta’tɨ kin adi’m’in m’oo. Dingəm kare aw kɨ ngann dingəm’gɨ joo, ə un ta el kɨ dɔkete ene: “Ngonn’m, aw ra kulə me ndɔɔ nju’tɨ ɓone.” ");
INSERT INTO gqr_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ningə ngonn kakin ilə baw’ne’tɨ ene: “M’a m’aw el,” ə isɨ ba bitɨ ningə me’ə uwə kɨ ta, adɨ ində aw. ");
INSERT INTO gqr_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Dingəm re rɔ ngonn’tɨ kɨ nja joo, el’ə kaa ta kɨ el ngonnkon’a kakin, ningə in el ene: “Oyo, m’a m’aw ɓay,” ə aw el. ");
INSERT INTO gqr_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Eke dann ngann’gɨ’tɨ kɨ joo kin in kɨ ra ə ra go ndigɨ’tɨ lə baw’ne wa?» Ningə iləi Jeju’tɨ eyina: «In kɨ dɔkete.» Ə Jeju el’de ene: «Tokɨ rɔta’tɨ, adɨ m’el’se, njetalambo’gɨ kɨ dene’gɨ kɨ njera kaya a tei Konɓe’tɨ lə Luwə non’se’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Tadɔ Jan Batisɨ re rɔ’se’tɨ, tɔjɨ’se row kɨ dana, nan in taai me’ə el, nan njetalambo’gɨ kɨ dene’gɨ kɨ njera kaya’gɨ uni me’de. Ə ingɨ, oyi nya kin be kaa, me’se uwə’se kɨ ta go gogɨ ə adɨ inyəi gorow njiyə’gɨ kɨ majel kɔ, ə uni me’se el.» ");
INSERT INTO gqr_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Go’tɨ, Jeju el’de ene: «Uri mbi’se oyi kujita kɨ rangɨ ɓay. De kare kɨ njendɔɔ nju in non, ningə ində singə gugɨ’n gidə gugɨ. Ur ɓe kadɨ to mborei nju’tɨ, ningə ra ngonn kəy ngəmlo səm’tɨ. Ningə go’tɨ dɔi ta nan’tɨ kɨ de’gɨ kɨ nje ra kulə nju, kadɨ to rai kulə ningə a kanyinan nya’a, ningə ɔtɨ aw mbah. ");
INSERT INTO gqr_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Lokɨ kagilo kujə kandɨ nju asɨ ningə, ulə ɓər’gɨ lə’ne kadɨ awi taai kandɨ nya ndɔɔ kakin, kɨ in yan’ne ji nje ra kulə nju’tɨ adi’ne. ");
INSERT INTO gqr_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Nan lokɨ ɓər’gɨ rei tei ningə, nje ra kulə’gɨ uwəi’de tindəi kɨ kare ngayn, tɔli kɨ nungɨ, ningə kɨ kon mutə, tiləi’ə kɨ mbal tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Njendɔɔ təl ulə kɨ ɓər’gɨ kɨ rangɨ, ngayn utə in kɨ kete inɓe kin ɓay. Nan rai se’de ko nya inɓe kɨ rai kɨ nje kɨ kete kakin ɓay. ");
INSERT INTO gqr_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ta tɔl ta’a’tɨ, dingəm təl ulə ngonn ne inɓe rɔ’de’tɨ, ene: “A ɓoli gidɨ ngonn’m.” ");
INSERT INTO gqr_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Nan nje ra kulə nju, lokɨ oyi ngonn kakin ningə elinan dann’de’tɨ eyina: “Darɔ’a inɓe kam ə a in nje nya nduwə! Rei adɨ jɨ tɔli’ə, ningə nya nduwə li’ə, j’a təli’ə yan’je’tɨ.” ");
INSERT INTO gqr_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","In be ə, uwəi ngonn kakin ndɔri’ə, awi si’ə gidɨ lo ndɔɔ’tɨ taga, tɔli’ə. ");
INSERT INTO gqr_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Lo’tɨ kin Jeju dəjɨ’de ene: Ndɔ kɨ dingəm kɨ ɓe nje ndɔɔ kin a re ə, ri ə a ra kɨ nje ra kulə nju kin wa?» ");
INSERT INTO gqr_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ə eli’ə eyina: «A tɔko de’gɨ kɨ majel kin kɨ tɔko kɨ kɨ kon ngayn, ə a adɨ ndɔɔ lə’ne nje kɨ rangɨ, kɨ kadɨ a adi’ə kanda kɨ dɔkagilo’ə’tɨ kɨ ɔjɨ.» ");
INSERT INTO gqr_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ningə Jeju el’de ene: «In tudəi me makitu’tɨ lə Luwə oyi el wa? “Mbal kɨ njera kəy’gɨ mbəti’ə, In ə təl mbal kɨ in tɔgɨ kəy. In kin in kuləra Burəɓe. In nyakɔjɨ kɨ ətɨ ɓol ə to takum’je’tɨ kin.”» ");
INSERT INTO gqr_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ningə adɨ m’el’se ɓay tɔ: «A taai Konɓe lə Luwə ji’se’tɨ, kadɨ təli adi ginn de’gɨ kɨ rangɨ kɨ kadɨ a rai kulə kɨ majɨ. ");
INSERT INTO gqr_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Nga ningə, de kɨ osɨ dɔ mbal’tɨ kin ə, a tətɨ njekɨ njekɨ, a re in ə mbal kin osɨ dɔ’a’tɨ tɔ ningə, a rəkitə’ə rəkitə rəkitə.» ");
INSERT INTO gqr_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Lokɨ kibo’gɨ lə njekujənyamosɨ kadikare’gɨ kɨ Parisɨ’gɨ oyi kujita kin ningə, gəri me’ə kadɨ in ta kɨ dɔ’de’tɨ ə Jeju ra el. ");
INSERT INTO gqr_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ə sangi row kadɨ n’uwəi’ə, nan ɓoli bulə de’gɨ, tadɔ bulə de’gɨ oyi Jeju to njekeltakita Luwə’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jeju ilə rɔ’ne el’de ta kɨ kujita ɓay ene: ");
INSERT INTO gqr_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«Konɓe lə Luwə to to ngar kɨ ra nyakusɔ kibo tadɔ ngonn’o kɨ aw to taa dene kin be. ");
INSERT INTO gqr_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ngar ulə njekulə’gɨ lə’ne adɨ awi eli de’gɨ kɨ ɓari’de lo nyakusɔ’tɨ, kadɨ rei, nan de’gɨ kakin mbəti. ");
INSERT INTO gqr_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ngar təl ində taa ta njekulə’gɨ’tɨ kɨ rangɨ ɓay ene: “Kɨ ngɔsine kin, nyakusɔ oy nga, m’tɔl baw mangɨ’gɨ, kɨ binyə’gɨ kɨ batɨ’gɨ lə’m, kɨ boi mbul mbul majɨ, nya’gɨ pətɨ asinan, ə rei lo nyakusɔ taa nan’tɨ.” ");
INSERT INTO gqr_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Nan de’gɨ kɨ ɓari’de kakin, usɨ’de dɔ ta’tɨ li’ə kin el, kɨ kare aw lo ndɔɔ’tɨ lə’ne, kɨ nungɨ aw lo gatɨ’tɨ lə’ne ndəgə’gɨ, uwəi njekulə’gɨ adi’de kon ningə tɔli’de. ");
INSERT INTO gqr_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ə nje kɨ nungɨ ɓay, uwəi njekulə’gɨ adi’de kon ge, tɔli’de ge. ");
INSERT INTO gqr_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","«Lo kin’tɨ, wongɨ tɔl ngar, adɨ ulə kɨ njerɔ’gɨ lə’ne adɨ awi tɔi ko njetɔl nya’gɨ kakin num, tuləi ɓebo lə’de por num tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ningə go’tɨ, ngar el njekulə’gɨ lə’ne ene: “Nyakusɔ taa nan oy nga, nan de’gɨ kɨ in kɨ ɓari’de, in de’gɨ kɨ asi ta te low’ə’tɨ el. ");
INSERT INTO gqr_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Awi kɨ tatɔrow’gɨ, ɓari de’gɨ pətɨ kɨ ngəi’de, adi’de rei lo nyakusɔ taa nan’tɨ.” ");
INSERT INTO gqr_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Njekulə’gɨ awi kɨ gorow’gɨ, kawi de’gɨ pətɨ kɨ ngəi’de, kɨ majɨ ge, kɨ majel ge, adɨ de’gɨ rosi me kəy kadɨ de’gɨ sɔi nya taa nan’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Lokɨ ngar ene n’ur kəy kadɨ n’oo de’gɨ kɨ ɓari’de kakin ningə, oo dingəm madɨ kare kɨ isɨ kɨ ku kusɔ nya taa nan rɔ’ne’tɨ el. ");
INSERT INTO gqr_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ə ngar el’ə ene: “Madɨ’m, in ra bann ə ur kəy ne kɨ kanjɨ ku kusɔ nya taa nan rɔ’i’tɨ wa?” Ningə dingəm kakin ilə’tɨ el. ");
INSERT INTO gqr_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Nga a ngar el njekulə’gɨ lə’ne ene: “Dɔi ji’ə’gɨ kɨ nja’a’gɨ, ə iləi’ə taga lo kɨ diw’tɨ, kɨ in lo kɨ a non’tɨ ge, a ngor ngangɨ’ne’tɨ ge.” ");
INSERT INTO gqr_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Tokɨ rɔta’tɨ, Luwə ɓar de’gɨ ngayn, nan nje kɨ mbətɨ’gɨ in ngayn el.» ");
INSERT INTO gqr_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Parisɨ’gɨ ingəi nan, elinan ta, kadɨ n’iyəi kulə n’uwəi Jeju me ta’tɨ kɨ n’a dəji’ə ə a te ta’a’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Be ə, uləi njendo’gɨ lə’de in kɨ de’gɨ madɨ kɨ me kutɨ’tɨ lə Erodɨ, adɨ awi eli’ə eyina: «Njendo, jɨ gər kadɨ in nje kelta kɨ rɔta’tɨ, in njendo de’gɨ row kɨ rɔta’tɨ kɨ nəl Luwə num, in ɓol kum’de el num, tadɔ in ɓol k’in kibo eke kətɨ ɓol lə de’gɨ el. ");
INSERT INTO gqr_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ə el’je adɨ j’oo ta kɨ me’i’tɨ: In gorow’ə’tɨ eke in gorow’ə’tɨ el kadɨ de ugə lambo nje konɓe kibo Sejar wa?» ");
INSERT INTO gqr_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Nan Jeju gər me majel lə’de, adɨ el’de ene: «In njekədikum de’gɨ! Tadɔ ri ə iyəi kulə kadɨ uwəi m’in wa? ");
INSERT INTO gqr_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ɔji’m’in silə kɨ kadɨ de a ugə’n lambo adi’m’in m’oo.» Ningə ɔji’ə silə kare. ");
INSERT INTO gqr_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Nga ə dəjɨ’de ene: «Dɔ nan ə indəi, ə tɔ nan tɔ ə ndangi silə’tɨ kin wa?» ");
INSERT INTO gqr_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ə iləi’ə’tɨ eyina: «In Sejar.» Ə Jeju təl el’de ene: «Nya lə Sejar ə adi Sejar, nya lə Luwə ə adi Luwə tɔ.» ");
INSERT INTO gqr_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ta kɨ Jeju el’de kin dum dɔ’de, adɨ inyəi’ə ə ɔti awi. ");
INSERT INTO gqr_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ndɔ’a’tɨ non, Sadusi’gɨ kɨ in de’gɨ kɨ oyi kadɨ njekoy’gɨ a indəi taa lo koy’tɨ el, rei rɔ Jeju’tɨ dəji’ə eyina: ");
INSERT INTO gqr_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","«Njendo, Mojɨ el ene: “Re de madɨ oy, kɨ kanjɨ k’inyə ngann’gɨ tor’ne’tɨ, majɨ kadɨ ngonnkon’a taa dene nduwə kin, ojɨ’n ngann’gɨ, kadɨ tei tor ngonnkon’a’tɨ.” ");
INSERT INTO gqr_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Kɨ ɔjidɔ ta kin, tokɨ dann’je’tɨ, ngannkon nan’gɨ in siri ge be. Kɨ dɔkete taa dene, ningə ojɨ’n ngonn el ɓay ə oy, adɨ inyə dene nduwə adɨ ngonnkon’ne. ");
INSERT INTO gqr_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Nya kin ra nya be, in dɔ kɨ nja joo’tɨ, kɨ kɨ nja mutə’tɨ, bitɨ te’n dɔ kɨ nja siri’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Go’de’tɨ pətɨ, darɔ dene inɓe re oy tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Eke ndɔ kɨ njekoy’gɨ a indəi taa lo koy’tɨ ə, nan dann’de ə a in ngaw dene kin wa? Tadɔ in siri pətɨ taai’ə ne’de’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ə Jeju el’de ene: «In de’gɨ kɨ indəmi row, tadɔ in gəri Makitu lə Luwə el num, taa in gəri tɔgɨ lə Luwə el num tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ndɔ kɨ njekoy’gɨ a indəi taa lo koy’tɨ, dingəm’gɨ kɨ dene’gɨ a taai nan el nga. Pətɨ a toi to malayka’gɨ be me dɔran’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Kɨ ɔjidɔ kində taa lo koy’tɨ lə njekoy’gɨ, tudəi ta kɨ Luwə el’se kin el wa? ");
INSERT INTO gqr_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Luwə el ene: “M’in Luwə lə Abiraham, m’in Luwə lə Isakɨ, kɨ Luwə lə Jakobɨ.” Luwə in Luwə lə de’gɨ kɨ nje kisi kumngayira, um in Luwə lə njekoy’gɨ el.» ");
INSERT INTO gqr_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Bulə de’gɨ kɨ oyi ta lə Jeju, nyando li’ə ətɨ’de ɓol ngayn. ");
INSERT INTO gqr_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Lokɨ Parisɨ’gɨ oyi kadɨ Jeju dum dɔ Sadusi’gɨ ningə, ingɨ kawinan. ");
INSERT INTO gqr_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ə kɨ kare dann’de’tɨ, kɨ in njendo ndukun’gɨ, iyə kulə me ta’tɨ, dəjɨ Jeju ene: ");
INSERT INTO gqr_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«Njendo, dann mbərkikində’gɨ’tɨ lə Luwə pətɨ me ndukun’tɨ, in kɨ ra ə in dɔ madɨ’ne’gɨ’tɨ wa?» ");
INSERT INTO gqr_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ə Jeju ilə’tɨ ene: «A in ndigɨ Burəɓe Luwə lə’i kɨ ngarme’i ba pətɨ, kɨ ndil’i ba pətɨ, taa kɨ mərta lə’i ba pətɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","In kin ə in ndukun kɨ dɔkete kɨ utə mbərkikində’gɨ pətɨ. ");
INSERT INTO gqr_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ningə ndukun kɨ nja joo kɨ maj’a to’tɨ tɔ ə to kin: A ndigɨ de mad’i to darɔ’i inɓe be tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ndukun’gɨ lə Mojɨ ba pətɨ, kɨ ta’gɨ lə njekeltakita Luwə’tɨ, ngirə’de in dɔ mbərkikində’gɨ’tɨ kɨ joo kin.» ");
INSERT INTO gqr_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Lokɨ Parisɨ’gɨ kawinan kakin, Jeju dəjɨ’de ta ene: ");
INSERT INTO gqr_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","«Kɨ go mərta’tɨ lə’se dɔ Kirisitɨ’tɨ kɨ in De kɨ Luwə mbət’ə kin, oyi kadɨ in ginn kojɨ’tɨ lə nan wa?» Ə eli’ə eyina: «In ngonnkaw Dabidɨ.» ");
INSERT INTO gqr_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ə Jeju el’de ene: «Ra bann be ə Dabidɨ lokɨ Ndil Luwə ra kulə me’ə’tɨ ɓar’a “Ɓe’m” wa? ");
INSERT INTO gqr_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Tadɔ Dabidɨ el ene: “Burəɓe Luwə el Burəɓe lə’m ene: ‹In re isɨ dɔjikɔl’m’tɨ ne, bitɨ kadɨ m’təl njeban’gɨ lə’i nyakində nja’i’tɨ ginn tɔgɨ’tɨ›.” ");
INSERT INTO gqr_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","«Ə re Dabidɨ ɓar’a Burəɓe ə, ra bann taa Kirisitɨ, kɨ in de kɨ Luwə mbət’ə a in ngonnkaw Dabidɨ wa?» ");
INSERT INTO gqr_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Lo kin’tɨ, de kɨ asɨ kadɨ ilə ta’tɨ kare be goto. Ningə in dɔ ndɔ’a’tɨ kin nu, de kaa sangɨ kadɨ n’dəj’ə ta el nga. ");
INSERT INTO gqr_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Jeju el bulə de’gɨ kɨ njendo’gɨ lə’ne ene: ");
INSERT INTO gqr_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«Njendo ndukun’gɨ kɨ Parisɨ’gɨ, kulə lə’de in kɔr ginn ndukun lə Mojɨ. ");
INSERT INTO gqr_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Nga ningə ingɨ, majɨ kadɨ in təli rɔ’se go nya’gɨ’tɨ kɨ eli’se, nan ndaji kulə ra’de’gɨ el, tadɔ rai nya kɨ inɓe’gɨ sii eli kɨ ta’de kin, el. ");
INSERT INTO gqr_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Dɔi nya kɨ ɔy indəi dɔ de’gɨ’tɨ, nan inɓe’gɨ mbeti kun ngonn ji’de nden be kuwə’n se’de taa. ");
INSERT INTO gqr_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Kulə ra’de’gɨ pətɨ, rai kɨ kadɨ de’gɨ oyi gidɨ’de. Ngann ndukun’gɨ kɨ ndangi uləi me ngann buwatɨ’gɨ’tɨ, ə de’gɨ dɔi natɨ non’de’tɨ ə isɨ ji’de’tɨ inɓe kin, rai yan’de adɨ boi, taa kulə’gɨ kɨ de’gɨ ɔsi sil ku’gɨ’tɨ kin kaa, rai yan’de adɨ ngal tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","In de’gɨ kɨ gei lo kisi kɨ kete non de’gɨ’tɨ lo nyakusɔ’tɨ num kɨ nya kisɨ kɨ kete non de’gɨ’tɨ ginn kəykawnan’gɨ’tɨ lə Juwipɨ’gɨ num tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Taa gei kadɨ de’gɨ rai’de lapiya kɨ ɓuki nan’tɨ lo kingənan’gɨ’tɨ lə bulə de’gɨ’tɨ num, taa kadɨ de’gɨ ɓari’de “Njendo de’gɨ” num tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Nan ingɨ, adi de ɓar’se “Njendo”, el, tadɔ pətɨ, in ngannkon’nan’gɨ, ningə Njendo’se in kareba tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ɓari de madɨ dɔnangɨ’tɨ ne “Baw’se” el, tadɔ Baw’se in kareba, ə isɨ dɔran’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Taa adi de ɓarɨ’se “De’gɨ kibo”, el tɔ, tadɔ De kibo lə’se in kareba, ə in Kirisitɨ kɨ in de kɨ Luwə mbət’ə. ");
INSERT INTO gqr_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","De kibo dann’se’tɨ, a in nje ra kuləɓər lə’se. ");
INSERT INTO gqr_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","De kɨ un dɔ’ne kɨ taa, a uləi dɔ’a kɨ nanga, ə de kɨ ulə dɔ’ne kɨ nanga, a uni dɔ’a taa tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","«Kumtondoo in lə’se, in njendo ndukun’gɨ kɨ Parisɨ’gɨ, in njekədikum de’gɨ! Sii uti tarow kɨ kaw Konɓe’tɨ lə Luwə dɔ de’gɨ’tɨ. Inɓe’gɨ uri me’tɨ el, ningə de’gɨ kɨ gei kur me’tɨ kaa, ɔgi’de num tɔ.  ");
INSERT INTO gqr_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","«Kumtondoo in lə’se, in njendo ndukun’gɨ kɨ Parisɨ’gɨ. Tai nya majɨ’gɨ lə njengawkoy’gɨ pətɨ pətɨ ji’de’tɨ, ningə ədi kum de’gɨ kɨ kelta kɨ Luwə kɨ ginn’ə gangɨ el, kadɨ de’gɨ oyi’se, tokɨ in de’gɨ kɨ majɨ. Go kulə ra’gɨ’tɨ kɨ be kin, Luwə a gangi’n ta kɨ ngan ngayn dɔ’se’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","«Kumtondoo in lə’se, in njendo ndukun’gɨ kɨ Parisɨ’gɨ, in njekədikum de’gɨ! Awi mbah, anyinan ngodɨ dɔnangɨ ray’gɨ’tɨ kɨ lo lo, dɔ ba’gɨ’tɨ kadɨ ingəi de kare go’se’tɨ. Ə lokɨ ingəi’ə ningə, rai’ə adɨ təl asɨ ta kaw me por’tɨ kɨ bitɨ kɨ non’tɨ nja joo utə inɓe’gɨ ɓay tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","«Kumtondoo in lə’se, in nje kɔr de’gɨ tarow, kɨ kum’se tɔ! Sii eli eyina: “Re de iw rɔ’ne kɨ Kəy lə Luwə ningə, to kare, a re iw rɔ’ne kɨ lɔr kɨ Kəy lə Luwə ə, majɨ kadɨ ra nya kɨ iw’n rɔ’ne.” ");
INSERT INTO gqr_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","In mbo de’gɨ, njekumtɔ’gɨ! Lɔr in nya kɨ Kəy lə Luwə, adɨ in yan Luwə. Eke lɔr ə in kibo ngayn eke, Kəy lə Luwə kɨ təl lɔr nya kɨ kində ta dangɨ’tɨ kin wa? ");
INSERT INTO gqr_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Təli eli ɓay eyina: “Re de iw rɔ’ne kɨ ringiri lo kində kadikare ə, to kare, a re iw rɔ’ne kɨ kadikare ə, majɨ kadɨ ra nya kɨ iw’n rɔ’ne.” ");
INSERT INTO gqr_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","In njekumtɔ’gɨ! In ri ə in kibo ngayn wa? In kadikare eke in ringiri lo kində kadikare kɨ təl kadikare nya kɨ kində ta dangɨ’tɨ kin wa? ");
INSERT INTO gqr_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","De kɨ iw rɔ’ne kɨ lo kində kadikare ningə, iw rɔ’ne kɨ ringiri lo kində kadikare num, kɨ nya’gɨ pətɨ kɨ isɨ dɔ’tɨ num tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","De kɨ iw rɔ’ne kɨ Kəy lə Luwə ningə, iw rɔ’ne kɨ Kəy lə Luwə num, kɨ Luwə kɨ isɨ me’tɨ num. ");
INSERT INTO gqr_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","De kɨ iw rɔ’ne kɨ dɔran ə, iw rɔ’ne kɨ kumbər ngar lə Luwə num, kɨ Luwə kɨ isɨ dɔ’tɨ num. ");
INSERT INTO gqr_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","«Kumtondoo in lə’se in njendo ndukun’gɨ kɨ Parisɨ’gɨ, in njekədikum de’gɨ. Ɔri nya kare dann kɨ dɔgɨ’tɨ, me mbi kam’gɨ’tɨ kɨ ətɨ majɨ, kɨ me mbi kam ndir tanyi’gɨ’tɨ, kɨ me ngann nya ndir tanyi’gɨ’tɨ, adi Luwə, ningə indəi nja’se dɔ nya’gɨ’tɨ kɨ maji’de to me ndukun’tɨ lə Luwə, to nyara kɨ dana, kɨ koo kumtondoo, kɨ nyara kɨ low’ə’tɨ. Kɨ rɔta’tɨ in kin ə in nya’gɨ kɨ kadɨ re a indəi kum’se go’tɨ rai, ə inyəi ndəgə’gɨ kɨ kɔ non be el. ");
INSERT INTO gqr_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","In nje kɔr de’gɨ tarow, kɨ kum’se tɔ! Sii uləi nya ta ngoo mann’tɨ lai mann tadɔ ngann kur’gɨ kɨ du, ə isɨ turi jambal me’se’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","«Kumtondoo in lə’se, in njendo ndukun’gɨ kɨ Parisɨ’gɨ, in njekədikum de’gɨ! Togi gidɨ kala mann kɨ gidɨ kaa kusɔ nya adɨ ar, nan me kəy rosɨ kɨ nya ɓogɨ’gɨ kɨ nya kɨ ingəi kɨ gorow nyənn nyara kɨ majel. ");
INSERT INTO gqr_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","In Parisɨ kɨ njekumtɔ! Togi me kala mann, ningə gidə a ar njay tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","«Kumtondoo in lə’se, in njendo ndukun’gɨ kɨ Parisɨ’gɨ, in njekədikum de’gɨ! Toi to dɔɓadɨ’gɨ kɨ de’gɨ rai pon gidɨ’tɨ adɨ ndai kam be: re oo gidə taga ne ə, ndolo, nan me’ə kɨ kəy rosɨ kɨ singə de’gɨ, kɨ nya’gɨ kɨ ndum kɨ dangɨ dangɨ. ");
INSERT INTO gqr_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","In be tɔ ə, gidɨ’se’tɨ taga ne, tɔji adɨ de’gɨ oyi tokɨ in nje təl rɔ’se go ndu Luwə’tɨ, nan me’se’tɨ kəy ə, kədɨ kum de’gɨ kɨ majel kɨ ra, rosɨ. ");
INSERT INTO gqr_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","«Kumtondoo in lə’se, in njendo ndukun’gɨ kɨ Parisɨ’gɨ, in njekədikum de’gɨ! Indəi dɔɓadɨ de’gɨ kɨ njekeltakita Luwə’tɨ adɨ majɨ, rai dɔɓadɨ de’gɨ kɨ dana adɨ ndolo, ");
INSERT INTO gqr_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ningə eli eyina: “Re dɔkagilo’tɨ lə kaw’je’gɨ kin j’in non ə, re j’a j’ində rɔ’je nan’tɨ se’de kadɨ jɨ tɔl’n de’gɨ kɨ njekeltakita Luwə’tɨ, el.” ");
INSERT INTO gqr_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Lo kin’tɨ, inɓe’gɨ isɨ tɔji kadɨ in ngannkaw nje tɔl de’gɨ kɨ njekeltakita Luwə’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","In ene, rai kɨ non’se’tɨ, tɔli ta nya kɨ kaw’se’gɨ uləi ngirə! ");
INSERT INTO gqr_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","«In de’gɨ kɨ mann’se majel to lii pir’gɨ be, ra bann ə in məri kadɨ a anyinan, ta ta kɨ gangɨ’tɨ me por’tɨ kɨ bitɨ kɨ non’tɨ wa? ");
INSERT INTO gqr_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","In tadɔ kin ə, m’a m’ulə’n kɨ de’gɨ kɨ njekeltakita Luwə’tɨ, kɨ nje gosɨ’gɨ kɨ njendo de’gɨ ta lə Luwə, rɔ’se’tɨ. A tɔli’de ge, a ɓəri’de kagidəsɨ’gɨ’tɨ, a tindəi’de kɨ ndəy hawlay ginn kəykawnan’tɨ lə Juwipɨ’gɨ, taa a ngodɨ’de, in se’de ɓebo’tɨ kɨ kare ə a gangi se’de ɓebo’tɨ kɨ nungɨ kɨ kete kete. ");
INSERT INTO gqr_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Lo kin’tɨ, de’gɨ kɨ dana kɨ mosɨ’de in kɨ ɓukɨ kɔ, ulə ngirə dɔ Abel’tɨ, te’n dɔ Jakari’tɨ kɨ ngonn lə Barasi kin, ta mosɨ’de a in dɔ’se’tɨ. In Jakari kɨ ndɔ kɨ tɔli’ə ngawdann lo’tɨ kɨ in Kəy’tɨ lə Luwə re lo ringiri kadikare’tɨ kin. ");
INSERT INTO gqr_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Tokɨ rɔta’tɨ, adɨ m’el’se, ta nya tɔl’gɨ kin pətɨ a in dɔ de’gɨ’tɨ kɨ dɔkagilo’tɨ kɨ ɓone. ");
INSERT INTO gqr_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","«Wah! in de’gɨ kɨ Jerujalem’tɨ, in de’gɨ kɨ Jerujalem’tɨ, in kɨ nje tɔl njekeltakita Luwə’tɨ, in nje tilə de’gɨ kɨ Luwə ulə’de adɨ’se kɨ mbal tɔli’de. Nja bann ə, m’ge kaw’se tokɨ konkunjə a kaw’n ngann’ne’gɨ ginn bagɨ’ne’tɨ kin be, nan ɔdi el ə. ");
INSERT INTO gqr_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Be ə kɨ ne kin, m’in Luwə m’a m’inyə Kəykawnan lə Luwə lə’se kɔ. ");
INSERT INTO gqr_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Tadɔ adɨ m’el’se madɨ oyi, a oyi m’in gogɨ el nga, bitɨ ndɔ kɨ a eli eyina: “Njangɨ dɔ in dɔ de’tɨ kɨ re me tɔ Burəɓe’tɨ”.» ");
INSERT INTO gqr_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jeju te me Kəy’tɨ lə Luwə kɨ taga, isɨ aw ningə, njendo’gɨ li’ə, rei rɔ’a’tɨ, eli’ə kadɨ oo Kəy lə Luwə kɨ de’gɨ indəi adɨ ətɨ ɓol kin! ");
INSERT INTO gqr_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ə Jeju un ta el’de ene: «Nya’gɨ kin pətɨ, kum’se oo majɨ, nan tokɨ rɔta’tɨ, adɨ m’el’se m’adɨ oyi, mbal kare kɨ a nanyi kadɨ isɨ dɔ mad’a’tɨ ne goto, a budi’de mur mur nanga.» ");
INSERT INTO gqr_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Lokɨ Jeju aw isɨ dɔ mbal kagɨ buni’gɨ’tɨ, njendo’gɨ li’ə rei rɔ’a’tɨ, dəji’ə ta kɨ kar’de ba eyina: «El’je adɨ j’oo, dɔkagilo kɨ ra’tɨ ə nya’gɨ kin a rai nya wa? Ə nyakɔjɨ kɨ bann ə a tɔjɨ kadɨ jɨ gər tokɨ in dɔkagilo kɨ kadɨ to re’n num, in dɔboy ndɔ num tɔ wa?» ");
INSERT INTO gqr_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ə Jeju ilə’de’tɨ ene: «Indəi kumkədɨ dɔ rɔ’se’tɨ, adi de ədɨ’se el. ");
INSERT INTO gqr_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Tadɔ de’gɨ ngayn a rei kɨ tɔ’m, a eli eyina: “M’in ə m’in Kirisitɨ kɨ in De kɨ Luwə mbət’ə”, ningə a ɓuki de’gɨ ngayn mu tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","A oyi kaa rɔ’gɨ kɨ in sese ndəkba kɨ ngann ta’gɨ kɨ dɔ rɔ’gɨ kɨ in sanyi, nan oyi maji! Adi ɓol ra’se el. Kadɨ nya’gɨ kin a rei, nan in dɔboy ndɔ el ɓay. ");
INSERT INTO gqr_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ginn ɓe madɨ a aw rɔ dɔ ginn ɓe madɨ’ne’tɨ, konɓe madɨ a aw rɔ dɔ konɓe madɨ’ne’tɨ. Ɓo a on ge, dɔnangɨ a yəkɨ ge, kɨ lo’gɨ kɨ dangɨ dangɨ. ");
INSERT INTO gqr_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Nan nya’gɨ kin a toi to lo kulə ngirə to ndo kɨ a ra dene kin be ɓay. ");
INSERT INTO gqr_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","De’gɨ a uni dɔ’se, awi sese kadɨ ingəi kon ge, kadɨ tɔli’se ge. De’gɨ pətɨ kɨ in Juwipɨ’gɨ el a ɔsi’se ta tadɔ lə’m. ");
INSERT INTO gqr_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Lo kin’tɨ, de’gɨ ngayn a inyəi kunme’gɨ lə’de kɔ. A uni dɔ nan kɨ yo ge kɨ ne ge, a ɔsi nan ta. ");
INSERT INTO gqr_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Nje ɓar rɔ’de njekeltakita Luwə’tɨ nan ingɨ el, a tei, ədi de’gɨ ngayn ɓuki’de mu. ");
INSERT INTO gqr_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Majel a taa dɔnangɨ taa kadɨ, de’gɨ ngayn ndiginan lə’de a təl gogɨ. ");
INSERT INTO gqr_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Nan de kɨ uwə tɔgɨ’ne ba bitɨ dɔboy’tɨ, a ingə kajɨ. ");
INSERT INTO gqr_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Poyta kɨ majɨ kɨ dɔ Konɓe’tɨ lə Luwə kin, de’gɨ a iləi mbər’ə kɨ dɔnangɨ pətɨ, kadɨ de’gɨ pətɨ kɨ gəri Luwə el oyi mannajɨ kɨ dɔ’tɨ. Ningə go’tɨ, dɔboy ndɔ a re. ");
INSERT INTO gqr_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","«Ningə lokɨ a oyi de kɨ Njeranyakɔw Njetujɨ lo, kɨ njekeltakita Luwə’tɨ Daniyel elta li’ə kin, a uwə lo kisi lokɨ ar njay’tɨ ə, majɨ kadɨ de kɨ nje tudə nya’gɨ kin, gər ginn’ə majɨ. ");
INSERT INTO gqr_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ningə nje kɨ sii Jude’tɨ a anyinan kɨ dɔ mbal’gɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","De kɨ isɨ dɔ kəy’tɨ a ur nanga kadɨ aw me kəy’tɨ un nya madɨ te’n el. ");
INSERT INTO gqr_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","De kɨ a in me ndɔɔ’tɨ a asɨ kadɨ təl re ɓe un ku rɔ’ne el tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Kumtondoo kɨ gara goto a in lə dene’gɨ kɨ nje səm kɨ nje kadɨ mba ngann’gɨ ili ndɔ’a’tɨ non kin. ");
INSERT INTO gqr_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Elita kɨ Luwə kadɨ anyinan ngodɨ kin ɓar’a el, taa kadɨ in ndɔ kɔrkon’tɨ el tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Tadɔ dɔkagilo’ə’tɨ kin, kon kɨ de’gɨ a ingəi, in kon kɨ de oo nja kare el ɓay. Lo kulə ngirə dɔran kɨ dɔnangɨ’tɨ kɨ Luwə ində’n nya’gɨ kin, bitɨ ɓone, de oo ko kon kin nja kare el, taa de a oo ko kon kin gogɨ el ratata tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Re Burəɓe uwə ta ndɔ’gɨ kin gangɨ el ə, de kare kɨ a isɨ kɨ dɔ’ne ta goto. Nan tadɔ lə de’gɨ kɨ inɓe mbətɨ’de ə, a uwə’n ta ndɔ’gɨ kin gangɨ. ");
INSERT INTO gqr_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Nga ningə, re de el’se ene: “Oyi Kirisitɨ, De kɨ Luwə mbət’ə ə in yo am eke in ne am ɓo” ə, ononyi’se kunme’se kad’a rɔta. ");
INSERT INTO gqr_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Tadɔ de’gɨ kɨ ɓari rɔ’de tokɨ n’in kirisitɨ’gɨ be kɨ nje kɨ ɓari rɔ’de njekeltakita Luwə’tɨ nan ingɨ el, a rei non to rai nya’gɨ kɨ ətɨ ɓol ɓol, kɨ nyakɔjɨ’gɨ kɨ ra ɓol kadɨ n’ɓuki de’gɨ mu’tɨ. A sangi kadɨ to nje kɨ Luwə mbətɨ’de inɓe kin kaa, n’ɓuki’de mu ɓay, tokɨ ingəi tarow. ");
INSERT INTO gqr_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","In be ə, m’el’se nya’gɨ kin kete be kadɨ gəri. ");
INSERT INTO gqr_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","«Kin ə re de el’se ene: “De kɨ Luwə mbət’ə ə a diləlo’tɨ yo am” ə, ai el. Re el’se ene: “In ə iyə rɔ’ne mbunə lo’tɨ gogɨ nu am” ə uni me’se adi’ə rɔta el. ");
INSERT INTO gqr_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ningə, tokɨ ndi təl in’n lo kuwə kadɨ’tɨ, awɨ’n lo kurkadɨ’tɨ kakin ə, kɨ re’m m’in Ngonn de kaa in be tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Lokɨ ninn to’tɨ, mal’gɨ a kawinan səm’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Go nya kumtondoo’gɨ’tɨ kɨ dɔkagilo’ə’tɨ kin, kadɨ a te kum’ne el, nanyi a nda el, mee’gɨ a in kɨ dɔran’tɨ tosi kɨ nanga, ningə tɔgɨ’gɨ kɨ dɔran’tɨ a yəki. ");
INSERT INTO gqr_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Lo kin’tɨ, nyakɔjɨ kɨ dɔ’m’tɨ m’in Ngonn de a te dɔran’tɨ, ningə ginn kaw’gɨ pətɨ kɨ dɔnangɨ’tɨ ne a ndingəi rɔ’de. Lo kin’tɨ, a oyi m’in Ngonn de m’a m’re me kilndi kɨ dɔran’tɨ kɨ tɔgɨ, me kunjɨ’tɨ kɨ ətɨ ɓol. ");
INSERT INTO gqr_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","M’a m’ulə kɨ malayka’gɨ lə’m kɨ tow kɨ ɓar ɔr lo hɔm dɔ kum dɔnangɨ’tɨ kɨ sɔ kadɨ kawi nje kɨ Luwə mbətɨ’de kɨ nan’tɨ. A kawi’de k’in ngangɨ dɔnangɨ’tɨ kɨ kare tei in kɨ nungɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","«Majɨ kadɨ in gəri nyando kɨ dɔ kagɨ mbaykote’tɨ kin. Lokɨ baji’ə’gɨ indəi rungirungɨ, ə mbi’ə itɨ kin ningə, in gəri kadɨ nanyi ɓar in ndəkba nga. ");
INSERT INTO gqr_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Be tɔ ə, lokɨ oyi nya’gɨ kin pətɨ rai nya ningə, majɨ kadɨ in gəri tokɨ Ngonn de in takəy’tɨ ndəkba kadɨ re rɔ’se’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ningə tokɨ rɔta’tɨ, adɨ m’el’se, de’gɨ kɨ sii kɨ dɔ’de taa ne kin a oyi tigə el ɓay ə nya’gɨ kin pətɨ a rai nya. ");
INSERT INTO gqr_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Dɔran kɨ dɔnangɨ a gotoi ndɔ madɨ, nan ta’gɨ lə’m a toi lo to de’tɨ ba bitɨ kɨ non’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","«De kare kɨ gər ndɔ eke dɔ kadɨ kɨ nya’gɨ kin a rai nya’tɨ goto: Malayka’gɨ kɨ dɔran’tɨ el num, Ngonn lə Luwə inɓe el num, nan Luwə kɨ Baw kɨ kar’ne ba par ə gər. ");
INSERT INTO gqr_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ningə, nya kɨ ra nya dɔkagilo’tɨ lə Nuwe kin ə, nya’a a ra nya ndɔ re’m’tɨ m’in Ngonn de tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Tadɔ kete non kadɨ mann kon kibo kin re, de’gɨ sɔi nya ge, anyinan ge, taai nan ge, adi ngann de’gɨ taai nan ge, bitɨ ndɔ’tɨ kɨ Nuwe ur’n me tokibo’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Usɨ de’gɨ el, bitɨ kadɨ mann kon kibo re tujɨ’n’de. Ndɔ kɨ m’in ngonn de m’a te’n bus kaa be tɔ’a nya’gɨ a rai nya tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","In be ə, dingəm’gɨ joo a rai me ndɔɔ’tɨ ningə, a uni kare ə a inyəi kɨ nungɨ. ");
INSERT INTO gqr_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Dene’gɨ joo a uri nya nan’tɨ ə, a uni kɨ kare ə a inyəi kɨ nungɨ. ");
INSERT INTO gqr_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ə majɨ kadɨ isɨ dɔ nja’se’tɨ, tadɔ in gəri ndɔ kɨ Burəɓe lə’se a re’n’tɨ el. ");
INSERT INTO gqr_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","In gəri majɨ kadɨ re ɓe nje kəy gər dɔ kadɨ kɨ njeɓogɨ a re’n kondɔ’tɨ ə a isɨ dɔ nja’ne’tɨ ba, um a inyə adɨ mbutɨ bɔr kəy li’ə el. ");
INSERT INTO gqr_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","In tadɔ kin ə, ingɨ kaa, kadɨ sii dɔ nja’se’tɨ tɔ. Tadɔ m’in Ngonn de m’a m’re dɔ kadɨ’tɨ kɨ in gəri el. ");
INSERT INTO gqr_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","«Njekuleɓər kɨ nje ra nya kɨ low’ə’tɨ, kɨ kum’ə ədɨ, ə in de kɨ ɓe’ə a ində dɔ de’gɨ’tɨ kɨ me kəy’tɨ lə’ne kadɨ adɨ’de nyakusɔ kɨ dɔ kadɨ kɨ kadɨ adɨ’n’de. ");
INSERT INTO gqr_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Nje ra kulə kin a in nje majikur, lokɨ ɓe’ə təl ə ingə ta kulə’tɨ kin, ra ra. ");
INSERT INTO gqr_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Tokɨ rɔta’tɨ adɨ m’el’se, a ində dɔ nya majɨ’gɨ’tɨ lə’ne pətɨ. ");
INSERT INTO gqr_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","A kin ə re in nje ra kulə kɨ majel ə, a el me’ne’tɨ ene: “Ɓe’m a re kalangɨ el ɓay”, ");
INSERT INTO gqr_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ningə ra ta kində madikulə’nə’gɨ’tɨ, ra sɔ ge, ra anyi ge kɨ nje kɨ yiwi ra’de. ");
INSERT INTO gqr_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Lokin’tɨ, ɓe nje kəy a re kɨ ndɔ kɨ in ində me’ne dɔ’tɨ el, kɨ dɔ kadɨ kɨ gər el. ");
INSERT INTO gqr_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ɓe’ə a ɔj’ɔ kum’ə, kadɨ oo nya kon kɨ a ra de’gɨ kɨ njekədikum de’gɨ, lo non’tɨ kɨ lo ngor ngangɨ’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","«Konɓe lə Luwə a to to ta lə ngann mandɨ’gɨ kɨ dɔgɨ kɨ ɔyi lambɨ’gɨ lə’de ə awi kadɨ tiləi kum de kɨ aw to taa dene kin be. ");
INSERT INTO gqr_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Nje kɨ mi in mbo’gɨ ə nje kɨ mi in njekumkar’gɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Nje kɨ mbo’gɨ ɔyi lambɨ’gɨ lə’de nan uni hu’ə kɨ rangɨ dɔ mad’a’tɨ el, ");
INSERT INTO gqr_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","nan njekumkar’gɨ, ɔyi lambɨ’gɨ lə’de kɨ hu kɨ rangɨ dɔ mad’a’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Nga ningə, lokɨ de kɨ aw to taa dene kakin re kalangɨ el, ɓi ra’de adɨ toi ɓi. ");
INSERT INTO gqr_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ə dann lo’tɨ, ndu de ɓar ene: “Oyi nje taa dene kaa am, ə tei tiləi kum’ə.” ");
INSERT INTO gqr_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Lo kin’tɨ, ngann mandɨ’gɨ kakin pətɨ ndəli dɔ ɓi’tɨ, indəi dɔ lambɨ’gɨ lə’de dana. ");
INSERT INTO gqr_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ningə nje kɨ mbo’gɨ eli njekumkar’gɨ eyina: “Adi’je hu lambɨ lə’se nden, nan lambɨ’gɨ lə’je isɨ oyi.” ");
INSERT INTO gqr_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ə njekumkar’gɨ eli’de eyina: “Jagɨ, a asɨ kadɨ j’ingi sese dɔ’tɨ el, ə awi rɔ nje kində nya ndogi’tɨ ndogi yan’se.” ");
INSERT INTO gqr_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ə lokɨ mbo’gɨ awi lo ndogɨ hu lambɨ’tɨ nu ningə, nje taa dene re te. Nje kɨ sii dɔ nja’de’tɨ, uri si’ə kəy taa nan’tɨ, adɨ uti takəy dɔ’de’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Go’tɨ gogɨ ɓay taa nje kɨ nungɨ kakin in non rei yan’de, eli eyina: “Burəɓe, Burəɓe, in te takəy adi’je!” ");
INSERT INTO gqr_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Nan nje taa dene ilə’de’tɨ ene: “Tokɨ rɔta’tɨ, adɨ m’el’se, m’gər’se el.”» ");
INSERT INTO gqr_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Lo kin’tɨ, Jeju ilə dɔ’tɨ ene: «Be ə, majɨ kadɨ sii dɔ nja’se’tɨ, tadɔ in gəri dɔ ndɔ’a eke dɔ kad’a el. ");
INSERT INTO gqr_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","«Ta kɨ dɔ konɓe’tɨ lə Luwə to to ta lə dingəm kɨ isɨ aw mbah ə ɓar njekulə’gɨ lə’ne adɨ’de nyakingə lə’ne kadɨ oyi go’ə adi’ne kin be. ");
INSERT INTO gqr_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Adɨ de kare sakɨ nar mi, adɨ kɨ nungɨ sakɨ nar joo, ningə adɨ kɨ nungɨ ɓay sakɨ nar kare tɔ. Adɨ de kɨ ra kigo tɔg’ɔ’tɨ, ə ɔtɨ aw mbah. ");
INSERT INTO gqr_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Be ə, njekulə kɨ ingə sakɨ nar mi, aw ra’n gatɨ ə ingə sakɨ nar mi dɔ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Be tɔ ə, in kɨ ingə joo, ra, ingə joo dɔ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Nan in kɨ ingə sakɨ nar kare, aw ur ɓe, duw nar’tɨ kɨ ɓe’ə ad’a kakin. ");
INSERT INTO gqr_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","«Nga ningə, dɔkagilo ngayn go’tɨ ningə, ɓe nje ra kulə’gɨ kakin in non re. Lokɨ re ningə, dəjɨ’de kadɨ ɔji kandɨ kulə’gɨ lə’de kɨ rai non’ne’tɨ kadɨ n’oo. ");
INSERT INTO gqr_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Lo kin’tɨ, in kɨ ingə sakɨ nar mi kakin, re non ɓe’ne’tɨ kɨ sakɨ nar kɨ rangɨ mi dɔ’tɨ ningə el’ə ene: “Ɓe’m, sakɨ nar kɨ mi kɨ adɨ’m kaa, nyɨ m’ra be m’ingə mi dɔ’tɨ kin.” ");
INSERT INTO gqr_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ə ɓe’ə el’ə ene: “Majɨ ngayn, in njekulə kɨ majɨ kɨ nje ra nya kɨ low’ə’tɨ. Ningə tokɨ ra’n nya kɨ low’ə’tɨ me nya’tɨ kɨ nden be, m’a m’indəi dɔ nya’gɨ’tɨ kɨ ngayn. Re, ra sə’m rɔnel.” ");
INSERT INTO gqr_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","In kɨ ingə sakɨ nar joo kakin, re non ɓe’ne’tɨ kɨ sakɨ nar kɨ rangɨ joo dɔ’tɨ ningə el’ə ene: “Ɓe’m, sakɨ nar kɨ joo kɨ adɨ’m kaa, nyɨ m’ra be m’ingə joo dɔ’tɨ kin.” ");
INSERT INTO gqr_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ə Ɓe’ə el’ə ene: “Majɨ ngayn, in njekulə kɨ majɨ kɨ nje ra nya kɨ low’ə’tɨ. Ningə tokɨ ra’n nya kɨ low’ə’tɨ me nya’tɨ kɨ nden be, m’a m’indəi dɔ nya’gɨ’tɨ kɨ ngayn. Re, ra sə’m rɔnel.” ");
INSERT INTO gqr_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ta tɔlta’a’tɨ, in kɨ ingə sakɨ nar kare kakin, re non ɓe’ne’tɨ el’ə ene: “Ɓe’m, m’gər kadɨ in de kɨ ngan ngayn: lo kɨ duw nya’tɨ el kaa tətɨ num, lo kɨ najɨ nya’tɨ el kaa ɔy num. ");
INSERT INTO gqr_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Nya kin ə m’ɓol, adɨ m’aw m’iyə nar kɨ adɨ’m kakin nanga. Ningə kɨ ngɔsine, nya lə’i ə to kin.” ");
INSERT INTO gqr_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Lo kin’tɨ ɓe’ə el’ə ene: “In njekulə kɨ majel, in njedaw! In gər majɨ kadɨ lo kɨ m’duw nya’tɨ el kaa m’ujə num, lo kɨ m’najɨ nya’tɨ el kaa m’ɔy num. ");
INSERT INTO gqr_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Nga a re be kin ningə, re a ində nar lə’m lo ngəm nar’tɨ, ə tokɨ m’təl kin ningə, re m’a m’taa kɨ mann’a dɔ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Tai sakɨ nar kɨ kare kɨ ji’ə’tɨ kin adi in kɨ aw kɨ sakɨ nar dɔgɨ kin.” ");
INSERT INTO gqr_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Tadɔ de kɨ aw kɨ nya ji’ne’tɨ, a adi’ə dɔ’tɨ kadɨ to’ə mbar mbar, nan de kɨ awɨ’n el, in kɨ nden kɨ awɨ’n kaa a taai ji’ə’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ningə in kɨ in njekulə kɨ nda’a goto, iləi’ə taga lo kɨ diw’tɨ kɨ kadɨ a non’tɨ ge ngor ngangɨ’ne’tɨ ge.» ");
INSERT INTO gqr_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Jeju el ɓay ene: «Lokɨ m’in Ngonn de m’a m’re me tɔjɨ’tɨ kɨ ətɨ ɓol, kɨ malayka’gɨ pətɨ go’m’tɨ kin ningə, m’a m’njɨ dɔ kumbər ngar’tɨ lə’m me tɔɓar’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ningə ginn ɓe’gɨ kɨ dangɨ dangɨ a kawinan kɨ non’m’tɨ. M’a m’ɔr kum de’gɨ nan’tɨ tokɨ nje nyakul’gɨ a ɔr’n kum batɨ’gɨ kɨ binyə’gɨ nan’tɨ kin be. ");
INSERT INTO gqr_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","M’ində batɨ’gɨ dɔjikɔl’m’tɨ, ə binyə’gɨ dɔjigəl’m’tɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Lo kin’tɨ, ngar a el nje kɨ dɔ ji kɔl’ne’tɨ ene: “Rei, ingɨ kɨ Bai ində ji’ne dɔ’se’tɨ kin, ə tai Konɓe kɨ Luwə ində dɔ’a dana tadɔ lə’se lo kulə ngirə dɔran kɨ dɔnangɨ’tɨ nu kin. ");
INSERT INTO gqr_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Tadɔ ɓo ra’m ə adi’m’in nya m’njɔ; kundə ra’m ə adi’m’in mann m’anyi; m’in mbah ə uwəi’m’in kɨ rɔ’se’tɨ; ");
INSERT INTO gqr_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","m’ra kɨ rɔ’m kare ə adi’m’in ku m’ulə rɔ’m’tɨ; rɔ’m to’m ə rai sə’m; m’to dangay’tɨ ə rei oyi’m’in.” ");
INSERT INTO gqr_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Nga ə njera go ndu Luwə’tɨ a iləi’ə’tɨ eyina: “Burəɓe, kadɨ bann’tɨ ə j’oo’i ɓo rai ə j’ad’i nya sɔ wa? Kində rai ə j’ad’i mann anyi wa? ");
INSERT INTO gqr_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","In mbah ə j’uwəi kɨ rɔ’je’tɨ wa? Ra kɨ rɔ’i kare ə j’ad’i ku ulə rɔ’i’tɨ wa? ");
INSERT INTO gqr_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Rɔ’i to’i ə jɨ ra sə’i wa? To dangay’tɨ ə jɨ re j’oo’i wa?” ");
INSERT INTO gqr_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ə ngar el nje rago’tɨ’gɨ ene: “Tokɨ rɔta’tɨ, adɨ m’el’se, dɔkagilo’gɨ pətɨ kɨ rai nya’gɨ kin kɨ kɨ du ngayn dann ngannkon’m’gɨ’tɨ kɨ oyi’de kam ningə, in m’in ə rai sə’m.” ");
INSERT INTO gqr_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","«Ningə go’tɨ, ngar a el nje kɨ rai dɔ ji gəl’ne’tɨ ene: “Ɔti sanyi kɔ rɔ’m’tɨ, in de’gɨ kɨ ndɔl in dɔ’se’tɨ! Ai me por’tɨ kɨ bitɨ kɨ non’tɨ, kɨ Luwə ində dɔ’a dana tadɔ lə Su in kɨ malayka’gɨ li’ə kin. ");
INSERT INTO gqr_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Tadɔ ɓo ra’m, ə adi’m’in nya m’njɔ el; kundə ra’m, ə adi’m’in mann m’anyi el; ");
INSERT INTO gqr_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","m’in mbah ə uwəi’m’in kɨ rɔ’se’tɨ el; m’ra kɨ rɔ’m kare ə adi’m’in ku m’ulə rɔ’m’tɨ el; rɔ’m to’m ə rai sə’m el; m’to dangay’tɨ ə in rei oyi’m’in el.” ");
INSERT INTO gqr_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ningə ingɨ kaa a iləi’ə’tɨ eyina: “Nga Burəɓe, kadɨ bann’tɨ ə j’oo’i ɓo rai ə j’ad’i nya sɔ el, eke kində rai ə j’ad’i mann anyi el wa? In mbah, eke ra kɨ rɔ’i kare, eke rɔ’i to’i, eke to dangay’tɨ ə jɨ mbətɨ ra sə’i wa?” ");
INSERT INTO gqr_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ə ngar a ilə’de’tɨ ene: “Tokɨ rɔta’tɨ, adɨ m’el’se, dɔkagilo’gɨ pətɨ kɨ rai nya’gɨ kin kɨ kɨ du ngayn dann ngannkon’m’gɨ’tɨ kɨ oyi’de kam, el ə, m’in kaa rai sə’m el jagɨ tɔ.” ");
INSERT INTO gqr_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Lo kin’tɨ, njera go’tɨ el, a ai lo kon’tɨ kɨ ginn’ə a gangɨ el, ə njera go ndu Luwə’tɨ a awi lo kajɨ’tɨ kɨ bitɨ kɨ non’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Lokɨ Jeju tɔlta kelta dɔ nya’gɨ ningə, el njendo’gɨ lə’ne ene: ");
INSERT INTO gqr_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«In gəri kadɨ ndɔ joo par ə ndɔ ra nanyi Pakɨ a asɨ, kadɨ de’gɨ a uləi m’in Ngonn de ji de’gɨ’tɨ kadɨ a ɓəri m’in kagidəsɨ’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Lo kin’tɨ non, kibo’gɨ lə njekujənyamosɨ kadikare’gɨ, kɨ ngatɔgɨ’gɨ lə Juwipɨ’gɨ, kawinan natɨ lo’tɨ lə Kayipɨ kɨ in kibo lə njekujənyamosɨ kadikare’gɨ. ");
INSERT INTO gqr_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ningə indəi ndu’de nan’tɨ kadɨ n’uwəi Jeju gidɨ kuwə n’tɔli’ə. ");
INSERT INTO gqr_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ningə elinan eyina: «Adɨ j’uwəi’ə ndɔ ra nanyi’tɨ el, nan to de’gɨ a indəi kɨ wongɨ.» ");
INSERT INTO gqr_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jeju in Betani’tɨ, me kəy’tɨ lə Simon kɨ kete in njebanjɨ, ");
INSERT INTO gqr_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ningə dene madɨ re rɔ Jeju’tɨ kɨ ku mbal kɨ hu kɨ ətɨ majɨ rosɨ. In hu kɨ gat’a in ngayn. Ningə lokɨ Jeju isɨ sɔ nya ə, ur hu kakin dɔ Jeju’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ə lokɨ njendo’gɨ oyi nya kin be ningə, nəl’de el, adɨ eli eyina: «Ginn ra hu kin kɔ be in ri wa? ");
INSERT INTO gqr_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Asɨ kadɨ de taa’n nar kɨ ngayn ə ra’n kɨ njendoo’gɨ.» ");
INSERT INTO gqr_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jeju oo ta kɨ isɨ eli be, ningə el’de ene: «Tadɔ ri ə isɨ njuwəi dene kin be wa? Nya kɨ ra dɔ’m’tɨ kin in kulə kɨ majɨ.» ");
INSERT INTO gqr_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Njendoo’gɨ kam, sii sese ne kɨ ndɔ’gɨ pətɨ, nan m’in m’a m’njɨ sese kɨ non’tɨ el. ");
INSERT INTO gqr_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Hu kɨ ətɨ majɨ kɨ ur dɔ’m’tɨ kin, ur ra’n go darɔ’m kɨ a aw ɓadɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ningə tokɨ rɔta’tɨ adɨ m’el’se: lo’gɨ pətɨ dɔnangɨ’tɨ ne, kɨ de’gɨ a iləi mbər Poyta kɨ majɨ səm’tɨ, a ɔri poy nya kɨ dene ra kin kadɨ me’de olo’n dɔ’a’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","De kare kɨ mbunə njendo’gɨ’tɨ lə Jeju kɨ dɔgɨ gidə in joo, kɨ tɔ’a nan Judasɨ Isikariyotɨ aw ɓe lə kibo’gɨ lə njekujənyamosɨ kadikare’gɨ, ");
INSERT INTO gqr_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","el’de ene: «Kin ə m’ulə Jeju jɨ’se’tɨ ə a adi’m’in ri wa?» Ningə ingɨ tudəi nar silə dɔ mutə adi’ə. ");
INSERT INTO gqr_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ulə ngirə low’ə’tɨ kin non, Judasɨ isɨ sangɨ dɔkagilo kɨ to kadɨ ulə’n Jeju ji’de’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ndɔ kɨ dɔkete lə ra nanyi kusɔ mapa kɨ hum ɔd’ɔ el, njendo’gɨ lə Jeju rei dəji’ə eyina: «Lo kɨ ra be ə in ndigɨ kadɨ j’aw jɨ ra nyakusɔ Pakɨ səm’tɨ j’ad’i wa?» ");
INSERT INTO gqr_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ə Jeju el’de ene: «Ai me ɓebo’tɨ kam, kəy lə de kɨ be, ə eli’ə eyina: “Njendo de’gɨ ene: dɔkagilo lə’m in ndəkba, ningə in ɓe lə’i ə m’a m’ra Pakɨ’tɨ kɨ njendo’gɨ lə’m.”» ");
INSERT INTO gqr_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Njendo’gɨ awi rai tokɨ Jeju el’n’de, adɨ rai nyakusɔ Pakɨ. ");
INSERT INTO gqr_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Lokɨ kadɨ ur, Jeju isɨ ta nyakusɔ’tɨ kɨ njendo’gɨ lə’ne kɨ dɔgɨ gidə in joo. ");
INSERT INTO gqr_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Lokɨ isɨ sɔi nya, Jeju el’de ene: «Tokɨ rɔta’tɨ, adɨ m’el’se, de kare dann’se’tɨ a ulə’m ji de’gɨ’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Lo kin’tɨ, me njendo’gɨ tɔsɨ, adɨ dəji ta Jeju kare kare eyina: «In m’in ɓe, Burəɓe?» ");
INSERT INTO gqr_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ə Jeju təl el’de ene: «De kɨ ulə ji’ne sə’m nan’tɨ me ngo kusɔ nya’tɨ kin ə, de’ə a ulə’m ji de’gɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Tadɔ Ngonn de a oy tokɨ ndangi me makitu’tɨ lə Luwə ɔji dɔ’a, nan kumtondoo in lə de kɨ a ulə ji de’gɨ’tɨ. De’ə kin, re oji’ə el kaa in sotɨ.» ");
INSERT INTO gqr_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Judasɨ kɨ a ulə Jeju ji de’gɨ’tɨ kakin, dəjɨ Jeju ene: «Njendo, in m’in ɓe?» Ə Jeju ilə’tɨ ene: «Te ta’i’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Lokɨ sii ta nyakusɔ’tɨ, Jeju un mapa, njangɨ dɔ’a, uwə tətɨ nan’tɨ, adɨ njendo’gɨ, ningə el’de ene: «Tai sɔi, in kin in darɔ’m.» ");
INSERT INTO gqr_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Go mapa’tɨ, Jeju un kɔpɨ yiwi kandɨ nju, ra oyo Luwə dɔ’tɨ, ningə təl’n adɨ njendo’gɨ ene: «Tai, anyinan pətɨ. ");
INSERT INTO gqr_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","In kin in mosɨ’m, mosɨ Kunmindɨ kɨ sigɨ kɨ a anyi tadɔ bulə de’gɨ, tadɔ k’inyə’n go majel’gɨ lə’de kɔ. ");
INSERT INTO gqr_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ningə adɨ m’el’se, m’a m’anyi yiwi kandɨ nju gogɨ el, bitɨ kadɨ m’a m’anyi sese kɨ sigɨ me Konɓe’tɨ lə Bai.» ");
INSERT INTO gqr_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Osi pa kulə tɔjɨ dɔ Luwə’tɨ ningə tei awi dɔ mbal kagɨ Buni’gɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ningə Jeju el njendo’gɨ ene: «Kondɔ’tɨ ne inɓe kin, ingɨ a mbeti m’in pətɨ, tadɔ ndangi me makitu’tɨ lə Luwə eyina: “M’a m’tɔl njekul batɨ’gɨ, ningə bulə batɨ’gɨ a sananyinan kɨ lo lo.” ");
INSERT INTO gqr_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Nan lokɨ m’a m’ində lo koy’tɨ, m’a m’aw kete non’se’tɨ, to nginə’se Galile’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Lo kin’tɨ, Piyər un ta el Jeju ene: «Re de’gɨ pətɨ inyəi nu kɔ kaa, m’in m’a m’inyə’i kɔ el ratata.» ");
INSERT INTO gqr_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ə Jeju təl el’ə ene: «Tokɨ rɔta’tɨ adɨ m’el’i: me kondɔ’tɨ ne inɓe kin, kete ɓay taa kadɨ kunə kunjə non, a manjɨ ta nja mutə ene in gərɨ’m el.» ");
INSERT INTO gqr_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Nan Piyər el’ə ene: «Re in koy kaa m’a m’oy sə’i, um m’a manjɨ ta gəri el bitɨ.» Ningə ndəgɨ njendo’gɨ pətɨ eli ko ta inɓe kɨ Piyər el kakin tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Go’tɨ, Jeju in kɨ njendo’gɨ lə’ne ɔti rei lo’tɨ madɨ kɨ ɓari’ə Getisemane. Jeju el’de ene: «Sii lo kin’tɨ ne be in nginəi m’in, dɔkagilo’tɨ kɨ m’a m’aw nu kadɨ m’elta kɨ Luwə.» ");
INSERT INTO gqr_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Jeju adɨ Piyər in kɨ ngann lə Jebede kɨ joo awi si’ə. Lo kin’tɨ, mekon kɨ metujɨ kibo ulə ngirə ra Jeju, ");
INSERT INTO gqr_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","adɨ el’de ene: «Me’m rosɨ kɨ metujɨ kɨ asɨ koy, sii lo kin’tɨ ne be, sii kum ba um toi ɓi el nan’tɨ sə’m.» ");
INSERT INTO gqr_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Jeju ɔtɨ kɨ kete nden ningə, osɨ kɨ ta kum’ne nanga, elta kɨ Luwə ene: «Bai, re to bann ə, ɔsɨ kɔpɨ kon kin ngərəngɨ rɔ’m’tɨ! Nan k’in ə kadɨ in kigo ndigɨ’tɨ lə’m el, nan kigo ndigɨ’tɨ lə’i yo taa.» ");
INSERT INTO gqr_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Jeju təl re rɔ njendo’gɨ’tɨ ningə ingə’de, isɨ toi ɓi, adɨ el Piyər ene: «Kin kaa asi kadɨ sii sə’m kum dɔ kadɨ kɨ kare be el bitɨ ɓe? ");
INSERT INTO gqr_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Sii kumngayira ba, elita kɨ Luwə, kadɨ osi me nyanan’tɨ el. Ndil de kɨ me’ə’tɨ ge ra nya kɨ majɨ, nan darɔ in kɨ ton.» ");
INSERT INTO gqr_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Təl ɔr rɔ’ne sanyi se’de kɨ nja joo, ningə elta kɨ Luwə ene: «Bai, kin ə re kɔpɨ kon kin, majɨ kadɨ m’anyi um lo kɔs’ɔ ngərəngɨ rɔ’m’tɨ goto ə, kadɨ ra ndigɨ lə’i.» ");
INSERT INTO gqr_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Lokɨ təl re rɔ njendo’gɨ’tɨ ningə, ingə’de isɨ toi ɓi ɓay, kum’de ɔy diriri. ");
INSERT INTO gqr_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Jeju inyə’de ə təl ɔr ndan’ne ɓay, elta kɨ Luwə kɨ nja mutə, un go mindɨ’ne kɨ kete kakin ɓay. ");
INSERT INTO gqr_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Go’tɨ, təl re rɔ njendo’gɨ’tɨ el’de ene: «In toi ta ɓi’tɨ ne, isɨ ɔri kon ɓay wa? Asɨ be nga! Dɔ kadɨ kulə’m m’in Ngonn de ji njeramajel’gɨ’tɨ asɨ nga. ");
INSERT INTO gqr_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Indəi taa adɨ j’awi, njekulə’m ji’de’tɨ ə re am!» ");
INSERT INTO gqr_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Lokɨ ta nanyi ta Jeju’tɨ ba ɓay ningə, Judasɨ, kɨ in kɨ kare dann njendo’gɨ’tɨ kɨ dɔgɨ gidə in joo re. Re kɨ kutɨ de’gɨ ngayn go’ne’tɨ. De’gɨ kɨ njekuwə kiyərɔ’gɨ ge, njekuwə gɔl’gɨ ji’de’tɨ ge. Bulə de’gɨ kin, in kibo’gɨ lə njekujənyamosɨ kadikare’gɨ, kɨ ngatɔgɨ’gɨ lə Juwipɨ’gɨ ə uləi’de. ");
INSERT INTO gqr_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judasɨ kɨ njekundɔ Jeju, el’de nya kɨ n’a n’ra kadɨ to gəri Jeju ene: «De kɨ m’a m’ində kɔtɨ’m yan’tɨ kin ə, in darɔ’a inɓe, ənn ə, uwəi’ə səm.» ");
INSERT INTO gqr_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","In be ə, tanan’tɨ ne ɔtɨ re kɨ rɔ Jeju’tɨ el’ə ene: «M’uwə ji’i, Njendo de’gɨ!» Ningə, ində kɔtɨ’ne yan’a’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ə Jeju el’ə ene: «Madɨ’m, in ra nya kɨ in re kadɨ in ra.» Ningə low’ə’tɨ non, de’gɨ indəi ji’de dɔ Jeju’tɨ uwəi’ə. ");
INSERT INTO gqr_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ningə nyɨ, kɨ kare dann nje kɨ in nan’tɨ kɨ Jeju, ində ji’ne dɔ kiyərɔ lə’ne, tugə’n mbi paja lə kibo lə njekujənyamosɨ kadikare’gɨ batɨ gangɨ. ");
INSERT INTO gqr_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Nan Jeju el’ə ene: «Ulə kiyərɔ lə’i saw’a’tɨ gogɨ, tadɔ de’gɨ kɨ nje rɔi kɨ kiyərɔ a tuji’de kɨ kiyərɔ tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ke oo kadɨ m’asɨ kadɨ m’dəjɨ tɔgɨ Bai, ə tanan’tɨ ne a ulə kɨ bulə malayka’gɨ dər dɔgɨ banyi banyi kadɨ rei rɔ lə’m el wa? ");
INSERT INTO gqr_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Nan kin ə re in be ə, bann ə Makitu lə Luwə kɨ el ene nya’gɨ a rai nya be kin tɔlta’ne wa?» ");
INSERT INTO gqr_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Go’tɨ, Jeju el bulə de’gɨ ene: «Rei kɨ kiyərɔ’gɨ kɨ gɔl’gɨ taa kadɨ uwəi m’in to nya kɨ m’in njeɓogɨ be! Ndɔ’gɨ pətɨ, m’in sese nan’tɨ natɨ Kəy’tɨ lə Luwə, m’ndo de’gɨ nya, kaa, uwəi m’in el. ");
INSERT INTO gqr_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Nan nya’gɨ kin rai nya be kadɨ ta kɨ njekeltakita Luwə’tɨ ndangi, tɔlita’de.» Lo kin’tɨ, njendo’gɨ li’ə pətɨ anyinan ə inyəi’ə. ");
INSERT INTO gqr_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Nje kuwə Jeju, awi si’ə non kibo’tɨ lə njekujənyamosɨ kadikare’gɨ kɨ tɔ’a nan Kayipɨ. In lo kin’tɨ ə njendo ndukun’gɨ kɨ ngatɔgɨ’gɨ lə Juwipɨ’gɨ kawi nan’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Piyər ra njiyə’n go’de’tɨ sanyi nden nden, bitɨ re ur’n go’de’tɨ, natɨ lo’tɨ lə kibo lə njekujənyamosɨ kadikare’gɨ kakin. Re isɨ nan’tɨ kɨ paja’gɨ kadɨ n’oo ke nya kin a tɔlta’ne bann wa. ");
INSERT INTO gqr_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Kibo’gɨ lə njekujənyamosɨ kadikare’gɨ kɨ njegangita’gɨ lə Juwipɨ’gɨ ba pətɨ, sangi row kadɨ n’ingəi de’gɨ kɨ nje tətɨ ta kɨ ngom dɔ’a’tɨ, kadɨ n’gangi ta koy dɔ Jeju’tɨ, ");
INSERT INTO gqr_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","nan ingəi el. De’gɨ ngayn kɨ nje tətɨ ta rei elita kɨ ngom dɔ’a’tɨ, nan asɨ nan’tɨ el. Ta tɔlta’a, de’gɨ joo rei eli eyina: ");
INSERT INTO gqr_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","«Dingəm kin el ene: “M’asɨ kadɨ m’tujɨ Kəy lə Luwə kɔ, ə m’təl m’ində gogɨ me ndɔ’tɨ kɨ mutə.”» ");
INSERT INTO gqr_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ə kibo lə njekujənyamosɨ kadikare’gɨ indəi taa el Jeju ene: «A elta madɨ dɔ ta’tɨ kɨ de’gɨ a indəi dɔ’i’tɨ kin el wa?» ");
INSERT INTO gqr_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Nan Jeju ilə’de’tɨ el. Lo kin’tɨ, kibo lə njekujənyamosɨ kadikare’gɨ el Jeju ene: «Kɨ tɔ Luwə kɨ nje kisi kumngayira, m’dəj’i kadɨ el’je ke in, ə in Kirisitɨ kɨ in De kɨ Luwə mbət’ə, kɨ in Ngonn lə Luwə wa?» ");
INSERT INTO gqr_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ə Jeju el’ə ene: «Te ta’i’tɨ! Nga ningə m’el’se taga wangɨ, m’adɨ oyi tokɨ kaw kɨ kete non, a oyi m’in Ngonn de m’njɨ dɔjikɔl Luwə’tɨ kɨ nje tɔgɨ, m’a m’ində dɔran’tɨ m’re me kilndi’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ə kibo lə njekujənyamosɨ kadikare’gɨ til ku’gɨ kɨ rɔ’ne’tɨ, ə el ene: «Elta kɨ mal dɔ Luwə’tɨ. In kin, jɨ sangɨ kadɨ de madɨ kɨ rangɨ taa elta dɔ’a’tɨ el nga. Inɓe’gɨ oyi ndu’ə kɨ el’n ta kɨ mal dɔ Luwə’tɨ kɨ mbi’se ne. ");
INSERT INTO gqr_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ta lə’se kɨ dɔ’a’tɨ in ri wa?» Ningə de’gɨ iləi’ə’tɨ eyina: «In de kɨ sɔw dɔ koy.» ");
INSERT INTO gqr_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ningə tuwi mannta’de kum’ə’tɨ ge, ɓiri ji’de ɔsi’ə’n’ə ge. Taa nje kɨ nan’gɨ tindəi kɔt’ɔ tɔ, ");
INSERT INTO gqr_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ningə eli’ə eyina: «J’in ə jɨ dəji, in Kirisitɨ kɨ in De kɨ Luwə mbət’ə, el’je ke nan ə ndəi wa.» ");
INSERT INTO gqr_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Lokɨ Piyər isɨ nanga tambalo’tɨ, taga ne ningə, dene kare kɨ dann dene’gɨ’tɨ kɨ nje ra kulə me kəy’tɨ lə kibo lə njekujənyamosɨ kadikare’gɨ re rɔ Piyər’tɨ el’ə ene: «In kaa, in kɨ Jeju, dingəm kɨ Galile’tɨ kin tɔ» ");
INSERT INTO gqr_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Nan Piyər manjɨ takum de’gɨ pətɨ ene: «Jagɨ, m’gər me ta lə’i kɨ in ge kel kin el.» ");
INSERT INTO gqr_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Go’tɨ, Piyər ɔtɨ isɨ aw kɨ ta ndogɨ’tɨ be, ningə dene kɨ rangɨ kare, kɨ nje ra kulə me kəy’tɨ lə kibo lə njekujənyamosɨ kadikare’gɨ oo’ə, ningə el nje kɨ rai low’ə’tɨ non ene: «De kam in kɨ Jeju kɨ Najaretɨ’tɨ tɔ.» ");
INSERT INTO gqr_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ə nja kare ɓay Piyər manjɨ ene: «Jagɨ, tokɨ rɔta’tɨ, m’gər dingəm kin el!» ");
INSERT INTO gqr_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Njaba go’tɨ ningə, de’gɨ kɨ rai se’de non, ɔti kɨ rɔ Piyər’tɨ eli eyina: «Tokɨ rɔta’tɨ, in kaa, in kɨ kare dann de’gɨ’tɨ li’ə tɔ, taa ndu’i kɨ isɨ el’n ta inɓe kin kaa tɔjɨ kadɨ in de li’ə.» ");
INSERT INTO gqr_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ə Piyər ilə rɔ’ne el’de ene: «M’iw rɔ’m kadɨ Luwə ra sə’m nya kɨ ngan, re m’elta kɨ ngom. M’gər dingəm kin el.» Ningə tanan’tɨ non, kunə kunjə kare non. ");
INSERT INTO gqr_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Nga ningə me Piyər olo dɔ ta’tɨ kɨ Jeju el’ə ene: «Kete taa kadɨ kunə kunjə non, a manjɨ ta gərɨ’m nja mutə» kakin. Piyər te taga non kɨ mann kum’ne. ");
INSERT INTO gqr_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Kɨ sin ba, kibo’gɨ lə njekujənyamosɨ kadikare’gɨ pətɨ, kɨ ngatɔgɨ’gɨ lə Juwipɨ’gɨ, indəi ndu’de nan’tɨ kadɨ adɨ tɔli Jeju. ");
INSERT INTO gqr_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Be ə, dɔi Jeju, awi si’ə uləi’ə ji Pilatɨ’tɨ, de kɨ Rɔm’tɨ kɨ in nje konɓe dɔnangɨ Jude’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Lokɨ Judasɨ kɨ njekundɔ Jeju kadɨ’de oo kadɨ gangi ta koy dɔ Jeju’tɨ ningə, me’ə uwə kɨ ta adɨ təl kɨ nar kɨ silə dɔ mutə awɨ’n adɨ kibo’gɨ lə njekujənyamosɨ kadikare’gɨ kɨ ngatɔgɨ’gɨ lə Juwipɨ’gɨ, kakin, ");
INSERT INTO gqr_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ningə el’de ene: «M’ra majel, m’un dɔ de kɨ ra nya madɨ el.» Ə ingɨ eli’ə eyina: «Ta kare kɨ usɨ’je’tɨ non goto. In kin in ta lə’i in.» ");
INSERT INTO gqr_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Lo kin’tɨ non, Judasɨ ɔtɨ ilə nar kɨ adi’ə kakin me Kəy’tɨ lə Luwə, ə aw ilə kulə. ");
INSERT INTO gqr_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Kibo’gɨ lə njekujənyamosɨ kadikare’gɨ ɔyi nar kakin ningə eli eyina: «In gorow’ə’tɨ el kadɨ jɨ ɓuki nar kin dɔ mad’a’tɨ kɨ me Kəy’tɨ lə Luwə gogɨ, tadɔ in nar mosɨ.» ");
INSERT INTO gqr_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Be ə, go ndu’de’tɨ kɨ osɨ go nan’tɨ, uni nar kakin ndogi lo ndɔɔ lə njekuwə ngoo, rai to lo duw mbah’gɨ. ");
INSERT INTO gqr_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","In tadɔ kin ə, bitɨ ɓone kaa isɨ ɓari lo kakin «lo mosɨ». ");
INSERT INTO gqr_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Lo kin’tɨ, ta kɨ njekeltakita Luwə’tɨ Jeremi el tɔlta’ne. El ene: «Taai silə dɔ mutə ba par to nar kɨ ngann Isirayel’gɨ ɔji dɔ’a’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Adi nar kin ndogi lo lə njekuwə ngoo, tokɨ Burəɓe el’m.» ");
INSERT INTO gqr_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jeju ra non nje konɓe, Pilatɨ’tɨ, ə nje konɓe dəj’ə ene: «In ngar lə Juwipɨ’gɨ wa?» Ə Jeju el’ə ene: «In ta kɨ te ta’i’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Kibo’gɨ lə njekujənyamosɨ kadikare’gɨ kɨ ngatɔgɨ’gɨ təti ta dɔ Jeju’tɨ, nan Jeju ilə’de’tɨ el. ");
INSERT INTO gqr_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ə non be, *Pilatɨ el Jeju ene: «Oo ta’gɨ pətɨ kɨ de’gɨ a indəi dɔ’i’tɨ kam el wa?» ");
INSERT INTO gqr_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ka Jeju te ta’ne ilə’tɨ el, adɨ ndɔj’ɔ ngayn. ");
INSERT INTO gqr_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Dɔ ɓal’gɨ pətɨ, lo ra nanyi Pakɨ’tɨ, nje konɓe a ɔr dangay kare ilə taa, adɨ in de kɨ bulə de’gɨ dəji’ə kadɨ ɔr’ɔ dangay’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ningə dɔkagilo’ə’tɨ kin, dangay madɨ kare kɨ de’gɨ elita li’ə ngayn kɨ tɔ’a nan Barabasɨ in non. ");
INSERT INTO gqr_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Pilatɨ dəjɨ bulə de’gɨ kɨ kawinan non ene: «Nan ə in gei kadɨ m’inyə taa m’adɨ’se wa? Barabasɨ eke Jeju kɨ in De kɨ Luwə mbət’ə wa?» ");
INSERT INTO gqr_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilatɨ dəjɨ ta be tadɔ gər majɨ kadɨ in jangɨ ə ra’de dɔ Jeju’tɨ ə uləi’ə ji’ne’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Lokɨ Pilatɨ isɨ lo gangɨ ta’tɨ, ne’ə adɨ eli’ə ene: «Ində rɔ’i me ta’tɨ lə de kɨ dana kam el, tadɔ kondɔ ne m’ingə kon ngayn me nii’tɨ tadɔ li’ə.» ");
INSERT INTO gqr_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Kibo’gɨ lə njekujənyamosɨ kadikare’gɨ kɨ ngatɔgɨ’gɨ lə Juwipɨ’gɨ suləi bulə de’gɨ adɨ dəji Pilatɨ kadɨ ɔr Barabasɨ adɨ’de ə tɔl Jeju kɔ. ");
INSERT INTO gqr_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Nje konɓe təl un ta dəjɨ’de ene: «Nan dann de’gɨ’tɨ kɨ joo kin ə gei kadɨ m’ɔr’ɔ dangay’tɨ m’adɨ’se wa?» Ningə iləi’tɨ eyina: «Barabasɨ!» ");
INSERT INTO gqr_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ə Pilatɨ, dəjɨ’de ene: «Nga ri ə kadɨ m’ra kɨ Jeju kɨ ɓari’ə De kɨ Luwə mbət’ə wa?» Ningə pətɨ eli eyina: «Ɓər’ə kagidəsɨ’tɨ par!» ");
INSERT INTO gqr_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ə Pilatɨ təl dəjɨ’de ene: «In ri kɨ majel ə ra wa?» Nan uləi bilə ngayn ɓay eyina: «Sɔw dɔ ɓər’ə kagidəsɨ’tɨ!» ");
INSERT INTO gqr_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Lokɨ Pilatɨ oo kadɨ nya madɨ kɨ kadɨ n’a n’ra goto, taa de’gɨ isɨ rai adɨ ngan kɨ dɔ mad’a’tɨ ɓay, un mann togɨ’n ji’ne takum bulə de’gɨ’tɨ, ningə el’de ene: «Ta mosɨ de kɨ dana kam in dɔ’m’tɨ el. In ta lə’se.» ");
INSERT INTO gqr_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ningə de’gɨ pətɨ iləi’ə’tɨ eyina: «Kadɨ ta mos’o in dɔ’je’tɨ kɨ dɔ ngann’je’gɨ’tɨ!» ");
INSERT INTO gqr_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Be ə, Pilatɨ ɔr Barabasɨ adi’de, nga ningə Jeju taa adɨ indəi’ə kɨ ndəy hawlay, ə uləi’ə ji njerɔ’gɨ’tɨ kadɨ ɓəri’ə kagidəsɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Njerɔ’gɨ lə Pilatɨ ɔri Jeju awi si’ə me kəy’tɨ lə ngar Pilatɨ, natilo’tɨ kɨ ɓari’ə piretuwar, ningə in njerɔ’gɨ pətɨ ə kawinan kɨ dɔ’a’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Tadɔ kadɨ to uwəi’ə kogi, ɔri ku li’ə, ə uləi ku kɨ kər rɔ’a’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Oji jɔgɨ konn uləi dɔ’a’tɨ ə uləi gakira ji kɔl’ɔ’tɨ tɔ, ningə ɔsi məkəsɨ’de nanga non’a’tɨ ə mboi si’ə eyina: «Lapiya ngar lə Juwipɨ’gɨ!» ");
INSERT INTO gqr_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Tuwi mann ta’de dɔ’a’tɨ, taai gakira ji’ə’tɨ, indəi dɔ’a. ");
INSERT INTO gqr_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Lokɨ uwəi’ə kogi asɨ’de ningə, ɔri ku ngal kɨ kər kakin rɔ’a’tɨ kɔ, ə təli uləi ku’gɨ li’ə inɓe rɔ’a’tɨ gogɨ, ə awi si’ə kadɨ ɓəri’ə kagidəsɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Lokɨ njerɔ’gɨ isɨ tei me ɓebo’tɨ kɨ taga ningə, ingəi dingəm kare kɨ Sirenn’tɨ, kɨ tɔ’a nan Simon. Uwəi’ə, indəi tɔgɨ dɔ’a’tɨ adɨ oti kagidəsɨ lə Jeju. ");
INSERT INTO gqr_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Awi tei lo madɨ’tɨ kare to non, ɓari’ə nan Golgota, kɨ kɔr me’ə nan: «Lo kadɔ.» ");
INSERT INTO gqr_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Adi’ə yiwi kandɨ nju kɨ buri nan’tɨ kɨ nya kɨ atɨ kadɨ Jeju anyi, ə lokɨ ɔdi ta’a’tɨ ə, mbətɨ kanyi. ");
INSERT INTO gqr_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Njerɔ’gɨ kakin ɓəri Jeju kagidəsɨ’tɨ, ningə tugəi kiri mbara dɔ ku’gɨ’tɨ li’ə, lowəi nan. ");
INSERT INTO gqr_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Go’tɨ, təli sii non, isɨ ngəmi ta’a. ");
INSERT INTO gqr_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ndangi me bar’tɨ, nya kɨ ra ə n’ɓəri’ə’n’ə kagidəsɨ’tɨ, indəi dɔ’a’tɨ taa eyina: «De kam in Jeju, ngar lə Juwipɨ’gɨ.» ");
INSERT INTO gqr_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Low’ə’tɨ non, ɓəri njeɓogɨ’gɨ joo kagidəsɨ’tɨ. Kɨ kare dɔji kɔl’ɔ’tɨ ə kɨ nungɨ dɔji gəl’ə’tɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","De’gɨ kɨ nje dər row’ə, tugəi dɔ’de roke roke, ningə taji’ə, ");
INSERT INTO gqr_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","eyina: «In kɨ nje tujɨ Kəy lə Luwə, ə təl ra in kɨ rangɨ me ndɔ’tɨ kɨ mutə kakin, re in Ngonn lə Luwə ə, ajɨ rɔ’i inɓe, ə in dɔ kagidəsɨ’tɨ ur nanga adɨ j’oo!» ");
INSERT INTO gqr_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Be tɔ ə, kibo’gɨ lə njekujənyamosɨ kadikare’gɨ kɨ njendo ndukun, ngatɔgɨ’gɨ lə Juwipɨ’gɨ uwəi Jeju kogi eyina: ");
INSERT INTO gqr_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«Ajɨ de’gɨ kɨ rangɨ, nan inɓe asɨ kajɨ rɔ’ne el! Ngar lə Isirayel’gɨ kaa kam! Kɨ ra’je inɓe kɨ jɨ ra ne kin, kadɨ in dɔ kagidəsɨ’tɨ ur nanga adɨ j’oo, ningə j’a j’un me’je j’ad’i rɔta! ");
INSERT INTO gqr_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Uwə kul Luwə ənn ə, re Luwə ndig’ə ə, kadɨ taa’a ilə taa adɨ j’oo. Tadɔ el ene: “M’in Ngonn lə Luwə.”» ");
INSERT INTO gqr_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Taa baw kaya’gɨ kɨ ɓəri’de kagidəsɨ’tɨ kɨ kare dɔjikɔl’ɔ’tɨ kɨ nungɨ dɔjigəl’ə’tɨ kaa taji’ə kah’a’tɨ inɓe kin tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ulə ngirə kadɨ’tɨ kɨ ra jam dɔ ɓe’tɨ, lo diw ndul kururu dɔnangɨ’tɨ ba pətɨ, bitɨ kadɨ kɨ mutə kɨ losɔl’ɔ. ");
INSERT INTO gqr_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Dɔ kadɨ’tɨ kɨ mutə, Jeju non kɨ ndu’ne kibo ene: «Eli, Eli, lama sabakitani?» Kɔr me’ə nan: «Luwə lə’m, Luwə lə’m, tadɔ ri ə inyə’m kɔ wa?» ");
INSERT INTO gqr_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","De’gɨ madɨ dann nje’gɨ’tɨ kɨ rai non, oyi ndu’ə, ningə eli eyina: «Oyi de kaa nyɨ, ra ɓar Eli!» ");
INSERT INTO gqr_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ningə kalangɨ ba, de kare dann’de’tɨ anyi ngodɨ, un nya kɨ to hɔm hɔm, ulə me mann kandɨ nju’tɨ kɨ masɨ, ningə ulə ta gakira’tɨ adɨ Jeju kadɨ anyi. ");
INSERT INTO gqr_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Nan ndəgə’gɨ eli eyina: «In nginə adɨ j’oo ke Eli a re aj’a wa?» ");
INSERT INTO gqr_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Lo kin’tɨ non be, Jeju ur koo kɨ ndu’ne kibo ɓay, ningə kon’a te. ");
INSERT INTO gqr_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ningə go’tɨ, ku gangɨ lo kɨ ra me Kəy’tɨ lə Luwə, til dana joo, ində taa nu bitɨ re nanga. Dɔnangɨ yəkɨ, taa mbal’gɨ kaa tanyi dana tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ta dɔɓadɨ’gɨ tei, adɨ de’gɨ ngayn kɨ uni me’de adi Luwə indəi taa lo koy’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Go’tɨ gogɨ, lokɨ Jeju te lo koy’tɨ ə, ingɨ awi me ɓe’tɨ kɨ Jerujalem kɨ in ɓebo kɨ ar njay. De’gɨ ngayn oyi’de kɨ kum’de. ");
INSERT INTO gqr_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Lokɨ kibo kɨ dɔ kutɨ njerɔ’gɨ’tɨ kɨ ɓu in kɨ njerɔ’gɨ kɨ njengəm Jeju kɨ in si’ə oyi dɔnangɨ kɨ yəkɨ, kɨ nya kɨ ra nya kin ə, ɓol tɔl’de adɨ eli eyina: «Tokɨ rɔta’tɨ, de kin in Ngonn lə Luwə.» ");
INSERT INTO gqr_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Dene’gɨ ngayn in non, rai sanyi, indəi kum’de ra oyi nya’gɨ kɨ isɨ rai nya. In dene’gɨ kɨ uni go Jeju Galile’tɨ nu, kadɨ rai si’ə. ");
INSERT INTO gqr_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Dann de’tɨ, Mari kɨ Magidala num, Mari kɨ kon Jakɨ in Jisepɨ num, taa kon ngann lə Jebede num tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Lokɨ kadɨ aw to ur, dingəm kɨ njenyakingə kare kɨ Arimate’tɨ, kɨ tɔ’a nan Jisepɨ in non re. In kaa in de kɨ təl rɔ’ne njendo’tɨ lə Jeju tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Jisepɨ aw rɔ Pilatɨ’tɨ dəj’ə ninn Jeju, ə Pilatɨ adɨ ndu’ne kadɨ adi’ə. ");
INSERT INTO gqr_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Jisepɨ un ninn Jeju, dolo kɨ ta ku dolo ninn kɨ nda kɨ sigɨ ba, ");
INSERT INTO gqr_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ə ilə me ɓe ninn’tɨ kɨ adɨ uri kadɨ mbal’tɨ ngɔsine ɓay tadɔ lə’ne n’inɓe, ningə nduguru mbal kibo ilə ta’tɨ, ə ɔtɨ aw. ");
INSERT INTO gqr_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Low’ə’tɨ kin, Mari kɨ Magidala in kɨ Mari kɨ kare in non, sii nanga turi kum’de par kɨ dɔɓadɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Lo ti go’tɨ, kɨ in ndɔ kɨ re go ndɔ kində dɔ nya’gɨ dana tadɔ ndɔ kɔrkon ə, kibo’gɨ lə njekujənyamosɨ kadikare’gɨ kɨ Parisɨ’gɨ awi nan’tɨ ɓe lə Pilatɨ, ");
INSERT INTO gqr_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","eli’ə eyina: «De kibo lə’je, me’je olo dɔ’tɨ tokɨ ndɔ kɨ nje ngom de’ə kin el, dɔkagilo’tɨ kɨ ra’n kɨ dɔ’ne taa ɓay el ene: “Ndɔ kɨ kon mutə lə ndɔ koy’m ə, m’a m’ində taa lo koy’tɨ.” ");
INSERT INTO gqr_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ə ilə ndu’i adɨ de’gɨ ngəmi dɔɓadɨ bitɨ ndɔ kɨ kon mutə, nan to njendo’gɨ li’ə rei ɓogi ninn’ə, ə təli eli eyina: “Ində lo koy’tɨ.” Lo kin’tɨ, a rai kadɨ ta ngom kin a utə kɨ kete ɓay.» ");
INSERT INTO gqr_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ə Pilatɨ el’de ene: «Njerɔ’gɨ kɨ kadɨ ngəmi ta dɔɓadɨ ə rai am, ə awi se’de adɨ ngəmi ta’a tokɨ in gei.» ");
INSERT INTO gqr_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Lo kin’tɨ, awi dɔɓadɨ’tɨ, tinyəi ta’a, ningə indəi njerɔ’gɨ kadɨ ngəmi taa. ");
INSERT INTO gqr_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Go ndɔ kɔrkon’tɨ, adɨ in ndɔ Dɔmasɨ kɨ ginn lo, Mari kɨ Magidala in kɨ Mari kɨ nungɨ awi kadɨ n’oyi dɔɓadɨ. ");
INSERT INTO gqr_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Lo kin’tɨ non be, dɔnangɨ yəkɨ yəkɨ kɨ ətɨ ɓol ngayn, tadɔ malayka lə Burəɓe kare re nduguru mbal ta ɓadɨ’tɨ kɔ, ə təl isɨ dɔ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Rɔ’a unjɨ to kadɨ, taa ku kɨ rɔ’a’tɨ nda to buy be tɔ. ");
INSERT INTO gqr_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Lokɨ njerɔ’gɨ kɨ njengəm dɔɓadɨ oyi’ə, ɓol tɔl’de adɨ təli toi to ninn’gɨ be. ");
INSERT INTO gqr_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Nan malayka un ta el dene’gɨ ene: «Ɓoli el, tadɔ m’gər kadɨ isɨ sangi Jeju kɨ de’gɨ ɓəri’ə kagidəsɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Goto ne, ində taa lo koy’tɨ tokɨ inɓe el’n. Rei oyi lokɨ iləi’ə’tɨ ə to kare kin. ");
INSERT INTO gqr_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ningə kadɨ awi kalangɨ eli njendo’gɨ li’ə tokɨ “Ində taa dann njekoy’gɨ’tɨ, ə aw kadɨ nginə’se Galile’tɨ. Lo kin ə a oyi’ə’tɨ.” In kin ə in ta kɨ kadɨ m’el’se.» ");
INSERT INTO gqr_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Dene’gɨ ɔti ta ɓadɨ’tɨ kɨ ngodɨ nja’de’tɨ, ɓol ra’de, nan rɔ’de nəl’de ngayn. Awi ɔri poy nya kɨ ra nya kin adi njendo’gɨ li’ə oyi. ");
INSERT INTO gqr_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Nden ba go’tɨ, Jeju aw ingə’de, el’de ene: «M’uwə ji’se!» Ningə ingɨ ɔti kɨ rɔ Jeju’tɨ, uwəi nja’a, ɔsi məkəsɨ’de nanga non’a’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ə Jeju el’de ene: «In ɓoli el; ə ai eli ngannkon’m’gɨ kadɨ awi Galile’tɨ. Lo kin ə a oyi m’in’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Lokɨ dene’gɨ njiyəi dɔ row’tɨ isɨ ai, njerɔ’gɨ madɨ kɨ dann njengəm dɔɓadɨ’tɨ, awi me ɓebo’tɨ, eli kibo’gɨ lə njekujənyamosɨ kadikare’gɨ nya’gɨ pətɨ kɨ ra nya kin adɨ oyi. ");
INSERT INTO gqr_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Be ə, kibo’gɨ lə njekujənyamosɨ kadikare’gɨ kawinan kɨ ngatɔgɨ’gɨ lə Juwipɨ’gɨ, uni ndu’de. Ningə go kun ndu’tɨ, adi njerɔ’gɨ nar ngayn, ");
INSERT INTO gqr_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ə eli’de ene: «Ta kɨ kadɨ eli ə to kin, eli eyina: “Njendo’gɨ li’ə ə rei ɓogi ninn’ə kondɔ’tɨ ne, lokɨ j’isi jɨ to ɓi.” ");
INSERT INTO gqr_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ə re ta kin osɨ mbi nje konɓe kɨ ɓebo’tɨ ə, j’inɓe j’a gər lo ta kɨ kadɨ j’el’ə kadɨ j’ɔr’n ta dɔ’se’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Be ə, njerɔ’gɨ taai nar kakin, ə rai kigo ndu’tɨ kɨ adi’de. In be ə, ta kene njendo’gɨ ɓogi ninn Jeju kin, isɨ njiyə dann Juwipɨ’gɨ’tɨ bitɨ ɓone. ");
INSERT INTO gqr_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Njendo’gɨ kɨ dɔgɨ gidə in kare awi Galile, dɔ mbal’tɨ kɨ Jeju el’de kadɨ awi’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Lokɨ awi ə oyi’ə ningə, ɔsi məkəsɨ’de nanga non’a’tɨ, nan kɨ madɨ’gɨ tadi kadɨ in Jeju. ");
INSERT INTO gqr_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ə Jeju ɔtɨ ndəkba kɨ rɔ’de’tɨ, el’de ta’gɨ kin ene: «Luwə adɨ’m tɔgɨ’gɨ pətɨ me dɔran’tɨ, kɨ dɔ dɔnangɨ’tɨ ə binəm. ");
INSERT INTO gqr_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Awi kɨ rɔ ginn de’gɨ’tɨ kɨ dɔnangɨ’tɨ ne pətɨ, təli’de njendo’gɨ’tɨ lə’m, rai’de batəm me tɔ Baw’tɨ, kɨ Ngonn’tɨ, kɨ Ndil Luwə’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ningə ndoi’de kadɨ ngəmi go nya’gɨ pətɨ kɨ m’dəjɨ’se kadɨ rai. Nga ningə, m’in, m’a m’in sese nan’tɨ kɨ ndɔ’gɨ pətɨ, bitɨ dɔboy ndɔ’tɨ.»");
INSERT INTO gqr_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Poyta kɨ majɨ kɨ ɔjidɔ Jeju Kirisitɨ, kɨ Ngonn lə Luwə, ə kulə ngirə to kin. ");
INSERT INTO gqr_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ndangi me makitu’tɨ lə njekeltakita Luwə’tɨ, Ejay, eyina: «M’in Luwə m’a m’ulə kɨ njekawkita lə’m kete non’i’tɨ, Kadɨ ra gorow non’i’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ndu de madɨ ɓar diləlo’tɨ ene: Rai gorow lə Burəɓe! Rai gorow li’ə adɨ ra njururu.» ");
INSERT INTO gqr_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Jan Batisɨ te diləlo’tɨ, el de’gɨ ene: «Inyəi gorow njiyə’se’gɨ kɨ majel kɔ, adɨ rai’se batəm, kadɨ Luwə inyə’n go majel’gɨ lə’se kɔ.» ");
INSERT INTO gqr_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","De’gɨ pətɨ kɨ dɔnangɨ Jude’tɨ kɨ ɓebo Jerujalem’tɨ, rei rɔ Jan’tɨ, tɔrindu’de dɔ majel’gɨ’tɨ lə’de, adɨ Jan ra’de batəm me ba Jurden’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ku kɨ Jan ulə rɔ’ne’tɨ, in kɨ ra kɨ bin jambal, ningə dɔ me’ne kɨ ndar tɔ. Nyakusɔ’a in giwiri’gɨ kɨ təjɨ. ");
INSERT INTO gqr_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Jan el bulə de’gɨ ene: «De madɨ kɨ nje tɔgɨ kɨ ətɨ ɓol, kɨ utə’m sanyi, a re go’m’tɨ non. In de kɨ kulə sa li’ə kaa m’asɨ kulə dɔ’m bo m’tutɨ el. ");
INSERT INTO gqr_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","M’in, m’ra’se batəm me mann’tɨ, nan in a ra’se batəm, me Ndil Luwə’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Dɔkagilo’ə’tɨ kin, Jeju in Najaretɨ’tɨ, kɨ in ngonn ɓekon kɨ Galile’tɨ, re adɨ Jan ra’a batəm, me ba Jurden’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Lokɨ Jeju isɨ te me mann’tɨ, oo dɔran til, ningə oo Ndil Luwə, risɨ to dər dum be re isɨ dɔ’a’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ningə, ndu ta madɨ te dɔran’tɨ, ene: «In Ngonn’m, m’ndig’ə, kɨ in nya rɔnel lə’m kibo ngayn.» ");
INSERT INTO gqr_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Kalangɨ ba go’tɨ, Ndil Luwə ɔsɨ Jeju aw si’ə diləlo’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Jeju ra ndɔ dɔsɔ diləlo’tɨ. *Satan re rɔ’a’tɨ, nan’a. Jeju in nan’tɨ kɨ da’gɨ kɨ mu, malayka’gɨ rai si’ə. ");
INSERT INTO gqr_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Go kuwə’tɨ kɨ uwəi Jan dangay’tɨ, Jeju aw Galile’tɨ, iləmbər Poyta kɨ majɨ lə Luwə ene: ");
INSERT INTO gqr_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","«Dɔkagilo kɨ Luwə ɔjɨ kaa re nga, ningə Konɓe lə Luwə kaa, in ndəkba rɔ’se’tɨ tɔ. Inyəi gorow njiyə’se’gɨ kɨ majel kɔ, ə uni me’se adi Poyta kɨ majɨ.» ");
INSERT INTO gqr_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ndɔ kare, Jeju a dər kadɨ babo’tɨ kɨ Galile ningə, oo Simon in kɨ ngonnkon’ne Andire kɨ in njekuwə kanjɨ’gɨ, ra iləi bandɨ me mann’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jeju el’de ene: «Rei go’m’tɨ adɨ m’ndo’se, kadɨ in təli nje sangɨ de’gɨ adɨ m’in kadɨ ingəi kajɨ.» ");
INSERT INTO gqr_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Kalangɨ ba, inyəi bandɨ’gɨ lə’de, ə awi uni go’ə. ");
INSERT INTO gqr_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Jeju ɔtɨ nden kete ningə, oo Jakɨ in kɨ Jan kɨ in ngann lə Jebede, sii me to’tɨ, isɨ rai go bandɨ’gɨ lə’de. ");
INSERT INTO gqr_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Kalangɨ ba, Jeju ɓar’de, ningə inyəi baw’de Jebede kɨ nje ra si’ə kulə’gɨ, me to’tɨ, ə ai kɨ Jeju. ");
INSERT INTO gqr_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jeju in kɨ njendo’gɨ lə’ne awi Kapernayim’tɨ. Jeju ur kəykawnan’tɨ lə *Juwipɨ’gɨ kɨ ndɔ kɔrkon lə’de, ningə ulə ngirə ndo nya. ");
INSERT INTO gqr_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Nyando li’ə, ətɨ de’gɨ kɨ isɨ oyi dɔ’a ɓol kɨ dum, tadɔ ndo nya kɨ tɔgɨ kɨ ingə rɔ Luwə’tɨ, um ndo nya to njendo ndukun’gɨ lə Luwə el. ");
INSERT INTO gqr_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ningə, de madɨ kare kɨ ndil kɨ majel ra’a, isɨ me kəykawnan’tɨ lə Juwipɨ’gɨ non, non kɨ ndu’ne kibo ene: ");
INSERT INTO gqr_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","«Jeju kɨ Najaretɨ, ri ə, ge rɔ’je’tɨ wa? In re kadɨ tujɨ’je wa? M’gər’i majɨ: in kɨ Kar njay lə Luwə.» ");
INSERT INTO gqr_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jeju ndangɨ ndil kɨ majel kɨ tɔgɨ’ne ene: «Utɨ ta’i, ə in te kɔ rɔ dingəm’tɨ kam.» ");
INSERT INTO gqr_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Lo kin’tɨ, ndil kɨ majel, ndajɨ dingəm rururu, kɨ tɔgɨ’ne, ningə te rɔ’a’tɨ kɨ non ta’ne’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Nya kin ətɨ de’gɨ ɓol, adɨ dəji nan ta dann’de’tɨ eyina: «Ri ə ra nya be wa? Oyi nyando kɨ sigɨ, kɨ aw kɨ tɔgɨ’ne ngayn kin! Ningə, ndil’gɨ kɨ majel kaa, ulə’de ginn tɔgɨ’ne’tɨ, adɨ təli rɔ’de go ndu’ə’tɨ ɓay tɔ.» ");
INSERT INTO gqr_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","In be ə, de’gɨ sananyinan kɨ tɔɓar lə Jeju, dɔnangɨ kɨ Galile’tɨ kalangɨ ba. ");
INSERT INTO gqr_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Lokɨ tei kəykawnan’tɨ lə Juwipɨ’gɨ kakin ningə, Jeju in kɨ Jakɨ kɨ Jan num, awi me kəy’tɨ lə Simon in kɨ Andire. ");
INSERT INTO gqr_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Məm Simon kɨ dene, rɔ’a on por rigɨ rigɨ adɨ to nanga. Be ə, lokɨ Jeju ur me kəy’tɨ ningə, kalangɨ ba, eli’ə ta rɔto li’ə. ");
INSERT INTO gqr_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jeju re rɔ’a’tɨ, uwə ji’ə, un’ə kɨ taa, ningə, rɔ’a kɨ kete tingə ngayn kakin, təl sɔl, adɨ ingə lapiya nga. Go’tɨ, ra nyakusɔ adɨ’de. ");
INSERT INTO gqr_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Lokɨ lo sɔl, go kadɨ kur’tɨ, de’gɨ rei kɨ njemonyi’gɨ kɨ de’gɨ pətɨ kɨ ndil’gɨ kɨ majel, rai’de, rɔ Jeju’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","De’gɨ pətɨ kɨ me ɓebo’tɨ kawinan kɨ takəy’tɨ, takəy’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jeju adɨ lapiya de’gɨ ngayn kɨ monyi kɨ dangɨ dangɨ ra’de, ta tuwə ndil’gɨ kɨ majel ngayn dɔ’de’tɨ kɔ tɔ. Ningə, adɨ tarow, ndil’gɨ kɨ majel kadɨ eli ta’a el, tadɔ gəri’ə ɓətɨ. ");
INSERT INTO gqr_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Taginnlo’tɨ, lokɨ lo tujə el ɓay, Jeju ində taa, te me kəy’tɨ aw diləlo’tɨ, ningə low’ə’tɨ non, ulə ngirə kelta kɨ Baw’ne. ");
INSERT INTO gqr_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simon in kɨ ndəgɨ de’gɨ kɨ in si’ə, awi sangi Jeju. ");
INSERT INTO gqr_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Lokɨ ingəi’ə ningə, eli’ə eyina: «De’gɨ pətɨ ra sangi nu». ");
INSERT INTO gqr_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jeju el’de ene: «Adɨ j’awi ngann ɓe’gɨ’tɨ, kɨ kadɨ’tɨ kin nga, tadɔ, majɨ kadɨ m’iləmbər Poyta kɨ majɨ nu tɔ. Tadɔ, m’re kadɨ m’ra kulə kin.» ");
INSERT INTO gqr_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","In be ə, Jeju njiyə dɔnangɨ Galile’tɨ ba pətɨ, ndo ta me kəykawnan’gɨ’tɨ lə Juwipɨ’gɨ, ningə tuwə ndil’gɨ kɨ majel tɔ. ");
INSERT INTO gqr_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Njebanjɨ ɔtɨ re rɔ Jeju’tɨ, ɔsɨ məkəsi’ne nanga non’a’tɨ, ningə non dɔ’a’tɨ ene: «Re in ndigɨ ə, asɨ kadɨ banjɨ lə’m ur adɨ rɔ’m ar njay.» ");
INSERT INTO gqr_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jeju oo kumtondoo li’ə, adɨ ulə ji’ne ɔdɨ’n’ə, ningə, el’ə ene: «M’ndigɨ, ə kadɨ banjɨ lə’i ur adɨ rɔ’i ar njay.» ");
INSERT INTO gqr_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Tanan’tɨ non banjɨ li’ə ur, adɨ rɔ’a ar njay. ");
INSERT INTO gqr_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ningə kete ɓay ta kadɨ Jeju inyə’ə adɨ aw, ndəj’ə kɨ tɔgɨ’ne ngayn, ");
INSERT INTO gqr_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","ə el’ə ene: «Ononyi kadɨ el ta’a de madɨ, ə aw ɔjɨ rɔ’i njekujənyamosɨ kadikare, ningə adɨ nya kar rɔ njay tokɨ ndukun lə *Mojɨ dəjɨ’n. Ra be kadɨ gəri tokɨ banjɨ lə’i ur adɨ ingə lapiya.» ");
INSERT INTO gqr_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Nan lokɨ dingəm kakin ɔtɨ aw ningə, iləmbər dɔ nya’tɨ kɨ Jeju ra si’ə kin, adɨ de’gɨ pətɨ oyi. Nya kin ra adɨ Jeju asɨ kadɨ ur me ɓebo’tɨ kɨ rangɨ, takum de’gɨ’tɨ jaja el nga. Be ə, isɨ gidɨ ɓe’tɨ, diləlo’tɨ, ningə de’gɨ in kɨ lo’gɨ kɨ dangɨ dangɨ, rei rɔ’a’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ndɔ ngayn el go’tɨ, Jeju təl aw Kapernayim’tɨ. De’gɨ gəri kadɨ in me kəy’tɨ non. ");
INSERT INTO gqr_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","De’gɨ kawinan ngayn, adɨ lo uwə’de ndingɨ ndingɨ, lokɨ kadɨ de ulə nja’ne’tɨ kaa goto, bitɨ kɨ ta kəy’tɨ taga. Ə, Jeju ndo’de Poyta kɨ majɨ lə Luwə. ");
INSERT INTO gqr_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","De’gɨ madɨ rei kɨ de kɨ njerɔkoy njururu rɔ’a’tɨ. Dingəm’gɨ sɔ, ə oti’ə. ");
INSERT INTO gqr_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Lo kadɨ awi si’ə, iləi’ə non Jeju’tɨ goto, tadɔ, de’gɨ uwəi lo ndingɨ ndingɨ. In be ə, ali taa, ndu’i dow dɔ kəy, sɔw dɔ lo kɨ Jeju sɨ’tɨ, ningə kɨ bolo kakin ə, iləi nje monyi kɨ nya kotɨ njemonyi’gɨ kɨ dɔi kulə’tɨ, non Jeju’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Lokɨ Jeju oo kunme lə’de ningə, el de kɨ rɔ’a oy njururu kakin ene: «Ngonn’m, majel’gɨ lə’i in kɨ k’inyə go kɔ.» ");
INSERT INTO gqr_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Njendo ndukun’gɨ lə Luwə kɨ nan’gɨ sii me kəy’tɨ non, isɨ mərita eyina: ");
INSERT INTO gqr_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«Tadɔ ri ə de’ə kam, elta be wa? Elta kɨ mal dɔ Luwə’tɨ. Luwə kɨ kar’ne ba par ə asɨ k’inyə go majel’gɨ lə de’gɨ kɔ, de kɨ rangɨ goto.» ");
INSERT INTO gqr_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Tanan’tɨ non, Jeju gər mərta’gɨ lə’de kin, adɨ el’de ene: «Tadɔ ri ə isɨ mərita kɨ be kin me’se’tɨ wa? ");
INSERT INTO gqr_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Kel njerɔkoy njururu kene: “Majel’gɨ lə’i in kɨ k’inyə go kɔ” ə ngan ngayn el eke, kel’ə kene: “Ində taa un tuwə lə’i, ə njiyə”, ə ngan ngayn el wa? ");
INSERT INTO gqr_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Re in be ə, m’a m’ɔjɨ’se kadɨ in gəri tokɨ m’in Ngonn De, m’aw kɨ tɔgɨ dɔnangɨ’tɨ ne, kadɨ m’inyə’n go majel’gɨ lə de’gɨ kɔ.» Ningə, Jeju el njerɔkoy njururu ene: ");
INSERT INTO gqr_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","«Ində taa, un tuwə lə’i, ə aw ɓe.» ");
INSERT INTO gqr_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ningə, dingəm indəi taa tanan’tɨ non, un tuwə lə’ne, ə te takum de’gɨ’tɨ pətɨ aw. Ɓol ra de’gɨ pətɨ, adɨ uləi tɔjɨ dɔ Luwə’tɨ, eyina: «Jagɨ, j’oo nya kɨ be kin kete el!» ");
INSERT INTO gqr_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jeju təl aw kadɨ babo’tɨ gogɨ. De’gɨ pətɨ rei rɔ’a’tɨ, ningə ndo’de nya. ");
INSERT INTO gqr_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Lokɨ Jeju isɨ dər ningə, oo *Lebi kɨ ngonn lə Alpe, isɨ me kəy taa lambo’tɨ. Jeju el’ə ene: «Un go’m.» Ningə Lebi ində taa, un go Jeju. ");
INSERT INTO gqr_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Go’tɨ, Jeju isɨ ta nyakusɔ’tɨ me kəy’tɨ lə Lebi. *Njetalambo’gɨ kɨ njeramajel’gɨ ngayn, sii nan’tɨ kɨ Jeju kɨ njendo’gɨ li’ə, ta nyakusɔ’tɨ, tadɔ ko de’gɨ kɨ be kin ngayn ə njiyəi go’ə’tɨ, mukɨ mukɨ. ");
INSERT INTO gqr_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Lokɨ njendo ndukun’gɨ lə Luwə kɨ me kutɨ’tɨ lə *Parisɨ’gɨ oyi Jeju isɨ sɔ nya kɨ njetalambo’gɨ kɨ njeramajel’gɨ ningə, eli njendo’gɨ li’ə eyina: «To, Ɓe’se isɨ sɔ nya kɨ njetalambo’gɨ kɨ njeramajel’gɨ wa?» ");
INSERT INTO gqr_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jeju oo ndu’de, adɨ el’de ene: «In de’gɨ kɨ njemonyi’gɨ ə a sangi de kɨ njera de monyi, um in nje rɔ ngan’gɨ ə a sangi de kɨ njera de monyi el. Ningə, m’re tadɔ ɓar de’gɨ kɨ dana el, nan m’re tadɔ de’gɨ kɨ njeramajel’gɨ yo.» ");
INSERT INTO gqr_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ndɔ kare njendo’gɨ lə Jan Batisɨ in kɨ Parisɨ’gɨ ɔgi rɔ’de nyakusɔ. Dɔkagilo’tɨ kin ə de’gɨ rei rɔ Jeju’tɨ dəji’ə eyina: «Ra bann ə njendo’gɨ lə Jan in kɨ njendo’gɨ lə Parisɨ’gɨ isɨ ɔgɨ rɔ’de nyakusɔ, ə nje kɨ yan’i’gɨ ɔgi rɔ’de nyakusɔ el wa?» ");
INSERT INTO gqr_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jeju ilə’de’tɨ ene: «Ke de’gɨ kɨ ɓari’de lo nyakusɔ taa nan’tɨ, a ɔgɨ rɔ’de nyakusɔ kɨ mann kanyi wa? Dɔkagilo’tɨ kɨ nje taa dene isɨ’n se’de nan’tɨ kin asi kɔgi rɔ’de nyakusɔ el. ");
INSERT INTO gqr_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Nan ndɔ’gɨ a rei non kadɨ a uni’ə ta’de’tɨ ningə, dɔkagilo’ə’tɨ kin ə a ɔgɨ rɔ’de nyakusɔ.» ");
INSERT INTO gqr_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","De a un ta ku kɨ sigɨ kadɨ ilə’n kum ku kɨ kɔkɔ el. Re in be ə, ta ku kɨ sigɨ kakin a in kɨ kɨ kɔkɔ rakɨ rakɨ, kadɨ bolo a to wororo utə kɨ kete ɓay. ");
INSERT INTO gqr_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Taa, de a un yiwi kandɨ nju kɨ in el ɓay utɨ me mbu ndar’gɨ’tɨ kɨ kɔkɔ el tɔ. Re in be ningə, lokɨ yiwi a in ningə mbu ndar’gɨ a nduwi. Ningə mbu ndar’gɨ kɨ yiwi kandɨ nju’gɨ pətɨ a təli nya kɨ tujɨ kɔ. Be ə, re yiwi kandɨ nju in el ɓay ningə, majɨ kadɨ mbu ndar’gɨ in kɨ sigɨ taa. ");
INSERT INTO gqr_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Jeju ində dər me ndɔɔ geme’gɨ’tɨ, ndɔ kɔrkon’tɨ lə Juwipɨ’gɨ. *Njendo’gɨ li’ə kɨ in si’ə, gangi dɔ ko’gɨ dɔ njiyə’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Parisɨ’gɨ eli Jeju eyina: «Oo nya kɨ to kin: njendo’gɨ lə’i rai nya kɨ gorow’ə’tɨ el ndɔ kɔrkon’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jeju el’de ene: «In tudəi nya kɨ ngar *Dabidɨ ra lokɨ ɓo ra’a kɨ de’gɨ kɨ go’ə’tɨ kin el bitɨ wa? ");
INSERT INTO gqr_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Dabidɨ ur me *Kəyku’tɨ lə Luwə, dɔkagilo’tɨ kɨ Abiyatar ə in kibo lə njekujənyamosɨ kadikare’gɨ. Dabidɨ un mapa kɨ de’gɨ adi Luwə kadikare’gɨ’tɨ, kɨ njekujənyamosɨ kadikare’gɨ par ə in gorow’ə’tɨ kadɨ sɔi, sɔ ə adɨ de’gɨ kɨ go’ne’tɨ sɔi tɔ.» ");
INSERT INTO gqr_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jeju təl el’de ɓay ene: «Luwə ɔr ndɔ kɔrkon ində taa dangɨ tadɔ majɨ lə de, um ra de tadɔ ndɔ kɔrkon el. ");
INSERT INTO gqr_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","In be ə, *Ngonn de in ɓe nje ndɔ kɔrkon.» ");
INSERT INTO gqr_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jeju təl aw me kəykawnan’tɨ lə Juwipɨ’gɨ gogɨ ɓay. Ningə dingəm kare kɨ ji’ə oy njururu in me kəykawnan’tɨ non. ");
INSERT INTO gqr_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","De’gɨ sii keke isɨ indəi kum’de kadɨ n’oyi ke Jeju a adɨ dingəm kin lapiya ndɔ ta kon’tɨ lə Juwipɨ’gɨ aw? In ta bolo kɨ isɨ sangi kadɨ n’indəi ta dɔ’a’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jeju el dingəm kɨ ji’ə oy njururu kakin ene: «Ində taa re dana ne, takum de’gɨ’tɨ pətɨ.» ");
INSERT INTO gqr_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ningə Jeju təl dəjɨ ndəgɨ de’gɨ ene: «Ri ə in gorow’ə’tɨ kadɨ de ra ndɔ kɔrkon’tɨ wa? Ra majɨ eke ra majel? Kadɨ de nagɨ madɨ’ne ta yo’tɨ eke kadɨ inyə adɨ tujɨ kɔ wa?» Lo to jijiji, de kare kaa elta el. ");
INSERT INTO gqr_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jeju gon’de kɨ wongɨ, me’ə tingə dɔ’de’tɨ ngayn tadɔ me ngan lə’de. Ningə el dingəm kakin ene: «Surə ji’i». Dingəm surə ji’ne ningə, ji’ə təl to majɨ kare. ");
INSERT INTO gqr_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Lokɨ Parisɨ’gɨ tei kəykawnan’tɨ lə Juwipɨ’gɨ kakin ningə, awi kalangɨ ba ingəi nje kɨ kutɨ lə Erodɨ’tɨ tadɔ sangɨ row tɔl Jeju. ");
INSERT INTO gqr_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jeju ɔtɨ aw kɨ njendo’gɨ lə’ne ta babo Galile’tɨ. Ningə bulə de’gɨ ngayn rei go’ə’tɨ. Bulə de’gɨ kakin in dɔnangɨ Galile’tɨ ge, dɔnangɨ Jude’tɨ ge, ");
INSERT INTO gqr_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ɓebo Jerujalem’tɨ ge, dɔnangɨ Idume’tɨ ge, dɔnangɨ kɨ gidɨ ba Jurden’tɨ ge, ta de’gɨ kɨ sii gugi gidɨ ɓebo kɨ Tir kɨ Sidon ba pətɨ kaa rei rɔ’a’tɨ tɔ. Bulə de’gɨ kin rei rɔ Jeju’tɨ, tadɔ oy poy nya’gɨ kɨ ra’de. ");
INSERT INTO gqr_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Jeju el njendo’gɨ lə’ne kadɨ indəi dɔ to madɨ dana dangɨ adi’ne, kadɨ bulə de’gɨ mborei’ne el. ");
INSERT INTO gqr_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Tokɨ rɔta’tɨ, Jeju adɨ lapiya de’gɨ ngayn, adɨ de’gɨ pətɨ kɨ ai kɨ monyi rɔ’de’tɨ, nagi rɔ’de kadɨ n’ɔdi rɔ’a. ");
INSERT INTO gqr_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Lokɨ de’gɨ kɨ ndil’gɨ kɨ majel uwəi’de ginn tɔgɨ’de’tɨ oyi’ə ningə, ɔsi məkəsɨ’de nanga non’a’tɨ, uni ndu’de taa ə nonyi eyina: «In Ngonn lə Luwə!» ");
INSERT INTO gqr_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Nan, ndəji’de kɨ tɔgɨ’ne kadɨ rai adɨ de’gɨ gəri’ne el. ");
INSERT INTO gqr_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Go nya’gɨ’tɨ kin, Jeju aw dɔ mbal’tɨ, ɓar nje kɨ ge’de, ningə rei rɔ’a’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Mbunə de’gɨ’tɨ kɨ ɓar’de kin ə Jeju mbətɨ njendo’gɨ lə’ne kɨ dɔgɨ gidə in joo kɨ kadɨ in si’ə nan’tɨ kɨ dɔkagilo’gɨ pətɨ. In si’ə nan’tɨ, kadɨ ulə’de adɨ awi iləi mbər Poyta kɨ majɨ. ");
INSERT INTO gqr_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ta awi kɨ tɔgɨ kadɨ tuwəi ndil’gɨ kɨ majel tɔ. ");
INSERT INTO gqr_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Tɔ de’gɨ kɨ dɔgɨ gidə in joo kɨ Jeju mbətɨ’de ə to kin: Simon, kɨ Jeju ində tɔ’a nan Piyər, ");
INSERT INTO gqr_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jakɨ, kɨ ngonn lə Jebede in kɨ ngonnkon’ne Jan, kɨ Jeju ɓar’de joo pətɨ ene Bowanerjesɨ, kɨ kɔr me’ə nan «ngonn lə ndangindi», ");
INSERT INTO gqr_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andire, Pilipɨ, Batilemi, Matiye, Tomasɨ, Jakɨ, kɨ ngonn lə Alpe, Tade, Simon, kɨ in mbunə nje rɔ tadɔ kingə dɔ lə ɓe lə’de, ");
INSERT INTO gqr_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ningə Judasɨ Isikariyotɨ, kɨ njekundɔ Jeju. ");
INSERT INTO gqr_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Jeju aw ɓe ningə, bulə de’gɨ rei uti kum lo mbukɨ mbukɨ ɓay, adɨ lo kadɨ in kɨ njendo’gɨ lə’ne ingəi dɔkagilo kadɨ sɔi nya kaa goto. ");
INSERT INTO gqr_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Lokɨ noj’o’gɨ oyi poyta kin ningə, rei kadɨ n’ɔri’ə n’awi si’ə ɓe, tadɔ eli eyina: «Dɔ’a isɨ dana el.» ");
INSERT INTO gqr_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Njendo ndukun’gɨ lə Luwə kɨ in Jerujalem’tɨ eli eyina: «Beljəbul isɨ me’ə’tɨ. Ningə in kɨ tɔgɨ lə ngar lə ndil’gɨ kɨ majel ə isɨ tuwə’n ndil’gɨ kɨ majel.» ");
INSERT INTO gqr_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Be ə Jeju ɓar’de kɨ rɔ’ne’tɨ ningə, ɔr’de ginn nya’gɨ me kujita’gɨ’tɨ ene: «Oyi kadɨ Satan a tuwə de’gɨ lə Satan bann wa? ");
INSERT INTO gqr_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kin ə, de’gɨ kɨ me konɓe’tɨ kɨ kareba, təli dɔnan’tɨ rɔ’i nan ə, konɓe kin a ra taa el. ");
INSERT INTO gqr_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Lokɨ de’gɨ kɨ me kəy’tɨ kɨ kareba təli dɔnan’tɨ, rɔi nan, me kəy’ə kin a ra tɔgɨ kaw kete el. ");
INSERT INTO gqr_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Re Satan inɓe təl dɔ’ne’tɨ kɨ rɔ, adɨ re gangɨ rɔ’ne ə, tɔg’ɔ a aw kɨ kete el, ginn’ə a gangɨ. ");
INSERT INTO gqr_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Adɨ m’el’se, kin ə re de uwə de kɨ nje tɔgɨ dɔ’a kete el ə, a asɨ kur me kəy’tɨ li’ə, kadɨ kər nyakingə li’ə el. Lokɨ dɔ’a nga a, a kər nya kɨ me kəy’tɨ li’ə. ");
INSERT INTO gqr_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","M’el’se tokɨ rɔta’tɨ: Majel’gɨ pətɨ kɨ de’gɨ rai, kelta kɨ mal’gɨ pətɨ kɨ a te ta de’tɨ kɨ dɔ Luwə’tɨ, Luwə a inyə go’ə kɔ adi de. ");
INSERT INTO gqr_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Nan re de elta kɨ mal dɔ Ndil Luwə’tɨ ningə, Luwə a inyə go kɔ ad’a el ratata. De kin a otɨ kɔy majel lə’ne kin bitɨ kɨ non’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jeju el’de ta kin be tadɔ njendo ndukun’gɨ lə Luwə eli eyina: «Aw kɨ ndil kɨ majel rɔ’ne’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Kon Jeju kɨ ngannkon’a’gɨ rei rai taga, ningə adi de kare ɓar’a adɨ’de. ");
INSERT INTO gqr_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Bulə de’gɨ sii nanga gugi dɔ’a gugɨ. Lokɨ rei eli’ə eyina: «Oo kon’i kɨ ngannkon’i’gɨ rai taga non, ra sangi nu.» ");
INSERT INTO gqr_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ningə Jeju təl el’de ene: «Nan’gɨ ə in kon’m kɨ ngannkon’m’gɨ wa?» ");
INSERT INTO gqr_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ningə gon de’gɨ kɨ sii gugi dɔ’a gugɨ kakin, ningə el ene: «Oyi ingɨ kɨ sii kin ə in kon’m kɨ ngannkon’m’gɨ. ");
INSERT INTO gqr_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Tadɔ, de kɨ njera ndigɨ lə Luwə ə in ngonnkon’m, konnann’m kɨ kon’m.» ");
INSERT INTO gqr_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jeju ulə ngirə kadɨ ndo de’gɨ nya kadɨ babo’tɨ ɓay. Bulə de’gɨ ngayn kawinan gugi gidə, adɨ al aw isɨ me to’tɨ, bo dɔ ba’tɨ. Bulə de’gɨ rai ngangɨ ba’tɨ ne təli kum’de kɨ dɔ’a’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Jeju ndo’de nya’gɨ ngayn me kujita’gɨ’tɨ. Me nyando’tɨ li’ə, el’de ene: ");
INSERT INTO gqr_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«Oyi, njendɔɔ kare aw kadɨ duw nya. ");
INSERT INTO gqr_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ningə, dɔkagilo’tɨ kɨ a ilə ko, kandɨ ko’gɨ madɨ tosi ngangɨ row’tɨ adɨ yəl’gɨ rei onyi makɨ. ");
INSERT INTO gqr_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Kandɨ ko madɨ’gɨ tosi dɔnangɨ wor’tɨ, adɨ lo kadɨ ingəi dɔnangɨ asɨ tam uləi ngirə’de’tɨ goto. Nan k’in ə tɔgi kalangɨ ba, tadɔ ngirə’de to taa’ne. ");
INSERT INTO gqr_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Lokɨ kadɨ ɔsɨ ningə, ngann ko’gɨ kakin ndolei mbaw. Go’tɨ ningə tuti kurum, tadɔ ngirə’de aw nanga boi el. ");
INSERT INTO gqr_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Kandɨ ko’gɨ kɨ nungɨ tosi dann konn’gɨ’tɨ. Konn’gɨ kakin tɔgi ndəmi’de mbɔl adɨ lo kadɨ andi goto. ");
INSERT INTO gqr_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Nan kandɨ ko’gɨ madɨ tosi dɔnangɨ’tɨ kɨ majɨ. Be ə, tɔgi kalangɨ ba adɨ andi. Kɨ nan’gɨ andi asɨ dɔ mutə, nje kɨ nungɨ andi asɨ dɔ mehen, ta nje kɨ nungɨ ɓay andi asɨ ɓu tɔ.» ");
INSERT INTO gqr_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Go’tɨ ningə, Jeju el’de ene: «De kɨ aw kɨ mbi’ne tadɔ koo’n dɔ ta ningə kadɨ oo dɔ ta kin majɨ.» ");
INSERT INTO gqr_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Lokɨ bulə de’gɨ ai ningə, nje kɨ nje nanyi si’ə, kɨ njendo’gɨ li’ə kɨ dɔgɨ gidə in joo, dəji’ə kadɨ ɔr’de ginn kujita’gɨ kɨ ndo’n nya kadɨ n’gəri. ");
INSERT INTO gqr_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ə el’de ene: «Ingɨ, Luwə te kɨ dɔ nya kɨ to lo kiyə’tɨ kɨ ɔjidɔ Konɓe li’ə adɨ’se. Nan ndəgɨ de’gɨ kɨ rai taga, ingəi nyando’gɨ pətɨ kɨ kujita. ");
INSERT INTO gqr_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","In be kadɨ, “Re gonyi lo majɨ kaa oyi nya el num, Re oyi dɔ ta majɨ kaa gəri me’ə el num, Tadɔ re gəri me’ə ningə, A təli rɔ’de go Luwə’tɨ kadɨ Luwə inyə go majel’gɨ lə’de kɔ.”» ");
INSERT INTO gqr_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jeju el’de ene: «In gəri me kujita kin el wa? A re in gəri me kujita kin el ə a rai bann ə a gəri ndəgə’gɨ wa?» ");
INSERT INTO gqr_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Njekilə ko, nya kilə li’ə in Poyta kɨ majɨ lə Luwə. ");
INSERT INTO gqr_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Kandɨ ko kɨ tosɨ ngangɨ row’tɨ, ɔjidɔ de’gɨ madɨ kɨ oyi ta lə Luwə, ningə Satan re ɔr ta kɨ oyi kakin me’de’tɨ kalangɨ ba kɔ. ");
INSERT INTO gqr_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Nga ningə, ingɨ kɨ tosi dɔnangɨ wor’tɨ, in de’gɨ kɨ oyi ta lə Luwə ningə, taai kalangɨ ba kɨ rɔnel. ");
INSERT INTO gqr_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Nan ta kin ulə ngirə’ne me’de el. In de’gɨ kɨ njekuwə kɨ ta Luwə dɔkagilo kɨ nden be par. Dɔkagilo kɨ nya torɔ’gɨ eke kindəkumndoo tadɔ ta lə Luwə, re ningə, inyəi kunme lə’de kɔ kalangɨ ba. ");
INSERT INTO gqr_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Kandɨ ko kɨ tosi dann konn’gɨ’tɨ, in de’gɨ kɨ oyi ta lə Luwə, ");
INSERT INTO gqr_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","nan me kɨ ra sururu dɔ nya’gɨ’tɨ kɨ dɔnangɨ’tɨ, kɨ ra ta nya majɨ kɨ dɔnangɨ’tɨ, ta ɓo nya’gɨ kɨ rangɨ kɨ dangɨ dangɨ utɨ dɔ taa kɨ oyi, adɨ lo kadɨ andi goto. ");
INSERT INTO gqr_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ningə, ndəgɨ kandɨ ko’gɨ kɨ tosi dɔnangɨ’tɨ kɨ majɨ, ɔjidɔ de’gɨ kɨ oy Poyta kɨ majɨ, ningə tai me’de’tɨ, ə tei kɨ kandɨ’de tɔ. Kɨ madɨ’gɨ andi dɔ mutə ge, dɔ mehen ge, ɓu kare ge. ");
INSERT INTO gqr_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ningə Jeju təl el’de ɓay ene: «De a re kɨ lambɨ kəy ə dow ngo dɔ’tɨ, eke ində ginn tirə’tɨ wa? A ində dɔ nya’tɨ taa. ");
INSERT INTO gqr_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Nya ra kɨ gidɨ kuwə, kɨ ginn’ə a te el goto. Nya kira kɨ to lo kiyə’tɨ, ginn’ə a te taga wangɨ. ");
INSERT INTO gqr_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Re de aw kɨ mbi’ne tadɔ koo dɔ ta, ningə kadɨ oo’n majɨ.» ");
INSERT INTO gqr_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Jeju təl el’de ɓay ene: «Majɨ kadɨ uri mbi’se majɨ oyi dɔ ta, um oyi kɨ non be el. Ə kadɨ in gəri tokɨ nya kɨ mbɔji adi de’gɨ kin ə Luwə a mbɔjɨ’n adɨ’se tɔ taa a adi’se ngayn dɔ’tɨ ɓay. ");
INSERT INTO gqr_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Be ə de kɨ aw kɨ nya ji’ne’tɨ, a adi’ə dɔ’tɨ ɓay. Nan de kɨ nya li’ə goto kaa, in kɨ ndikiri inɓe kɨ awɨ’n ji’ne’tɨ kin kaa, a tai ji’ə’tɨ ɓay.» ");
INSERT INTO gqr_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jeju təl el’de ɓay ene: «Konɓe lə Luwə to to de kɨ aw duw nya me ndɔɔ’tɨ lə’ne be. ");
INSERT INTO gqr_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Go nya duw’tɨ kin, re nje ndɔɔ to ɓi eke, to ɓi el kaa, kondɔ kɨ kada, nya kɨ duw, uwə ə isɨ tɔgɨ tɔ, kɨ kanjɨ kadɨ njeduw’ə gərɨ’n row kɨ isɨ tɔgɨ’n. ");
INSERT INTO gqr_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Nan inɓe kɨ dɔrɔ’ne, ra adɨ ko uwə ə tɔgɨ, kand’a te, ningə go’tɨ gogɨ, ɔr dɔ’ne, ə andɨ. ");
INSERT INTO gqr_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ningə dɔkagilo kɨ dɔ ko gəsirə asɨ lo kujɨ’ə’tɨ, de re ujə ko tadɔ nanyi’a asɨ.» ");
INSERT INTO gqr_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jeju el’de ɓay ene: «Ri ə j’a j’uni kadɨ j’ɔji Konɓe lə Luwə wa? Eke kujita kɨ bann ə j’a j’uni kadɨ j’eli’n ta kɨ dɔ’tɨ wa? ");
INSERT INTO gqr_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Konɓe lə Luwə to to kandɨ nya kɨ ɓari’ə mutardə be. In kandɨ nya kɨ du utə kandɨ nya’gɨ pətɨ kɨ de isɨ duw dɔnangɨ’tɨ ne. ");
INSERT INTO gqr_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Lokɨ de duw’ə ningə, tɔgɨ ə təl kagɨ tanyi kibo, utə ndəgɨ kagɨ tanyi’gɨ pətɨ. Baji’ə’gɨ kɨ tɔi, boi ngayn, adɨ yəl’gɨ uwəi lo kisɨ kum ndil’ə’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Kɨ kujita’gɨ ngayn kɨ toi tanan be ə Jeju ndo’n de’gɨ ta, ra be kigo lə gər’ə’tɨ kɨ de’gɨ asi gəri me’ə. ");
INSERT INTO gqr_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ta kɨ kadɨ el’de kɨ kujita el goto. Nan dɔkagilo kɨ nanyi kɨ njendo’gɨ lə’ne inɓe’gɨ kɨ kar’de par ə, ɔr’de me’ə pətɨ. ");
INSERT INTO gqr_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Me ndɔ’a’tɨ non, dɔji losɔl’tɨ ningə, Jeju el njendo’gɨ lə’ne ene: «Adɨ jɨ gangi babo j’awi dowə’tɨ kɨ kare.» ");
INSERT INTO gqr_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Inyəi bulə de’gɨ, ningə njendo’gɨ awi kɨ Jeju me to’tɨ kɨ re in’tɨ kete. To’gɨ kɨ rangɨ dani’ə. ");
INSERT INTO gqr_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ningə, nəl kibo ngayn uwə’de bus dɔ ba’tɨ. Pungum mann’gɨ indəi kadɨ to mbingum mbingum adɨ mann isɨ rosɨ to. ");
INSERT INTO gqr_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jeju lə nya gətɨ’n dɔ’ne, ə to ɓongɨ to’tɨ, isɨ to ɓi. Njendo’gɨ li’ə ndəli’ə kɨ non ta de’tɨ eyina: «Njendo, j’isɨ j’oyi be kaa oo el wa?» ");
INSERT INTO gqr_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jeju ndəl dɔ ɓi’tɨ, ndangɨ nəl, ə el mann ba ene: «Ra lokatɨ! Adɨ lo to jijiji!» Low’ə’tɨ non nəl yogiro adɨ lo to jijiji. ");
INSERT INTO gqr_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ningə, Jeju el njendo’gɨ lə’ne ene: «Ra bann ə ɓoli be wa? Bitɨ ɓone kaa uni me’se el ɓay wa?» ");
INSERT INTO gqr_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ɓol ra’de ngayn, adɨ dəji nan ta dann’de’tɨ eyina: «De’ə inɓe kam in nan ə, nəl kɨ ba’gɨ kaa oyi ta li’ə be wa?» ");
INSERT INTO gqr_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jeju in kɨ njendo’gɨ lə’ne tei gidɨ ba’tɨ, dɔnangɨ’tɨ lə de’gɨ kɨ Gerasa’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Lokɨ Jeju in me to’tɨ ur nanga ningə, tanan’tɨ non, de madɨ kare kɨ aw kɨ ndil kɨ majel rɔ’ne’tɨ, te dɔɓadɨ’gɨ’tɨ re ingə’ə. ");
INSERT INTO gqr_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","De kakin ra ɓe dɔɓadɨ’gɨ’tɨ. Re in kɨ kulə gindɨ kaa, de kare kɨ asɨ dɔ’a lokatɨ goto. ");
INSERT INTO gqr_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Dɔi’ə kɨ kulə gindɨ nja banyi banyi, ta ləi kangila gindɨ nja’a’tɨ tɔ. Nan gangɨ kulə gindɨ riw riw ta, tətɨ gindɨ nɔsɨ nɔsɨ tɔ. De kɨ asɨ kuwə ginn tɔgɨ’ne’tɨ goto. ");
INSERT INTO gqr_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Dɔkagilo’gɨ pətɨ, kondɔ’tɨ kɨ kada, lo njiyə in dɔɓadɨ’gɨ’tɨ kɨ dann mbal’gɨ’tɨ kɨ wuyi kɨ kur ta’ne’tɨ. Ningə tujə rɔ’ne gangɨ batɨ batɨ kɨ gajɨ mbal’gɨ. ");
INSERT INTO gqr_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Lokɨ oo Jeju sanyi nu ɓay ningə, anyi kɨ ngodɨ re ɔsɨ məkəsi’ne nanga non’a’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ningə ur kɔl kɨ tɔgɨ’ne ngayn ene: «Jeju kɨ Ngonn lə Luwə kɨ Nje kisɨ dɔ nya’gɨ’tɨ pətɨ, ri ə ge rɔ’m wa? Nja’i ba! me tɔ Luwə’tɨ, adɨ’m kon el!» ");
INSERT INTO gqr_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","El ta kin be tadɔ ta kɨ Jeju el’ə ene: «In ndil kɨ majel, te kɔ rɔ dingəm’tɨ kin.» ");
INSERT INTO gqr_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jeju dəj’ə ene: «Tɔ’i nan nan?» In təl el’ə ene: «Tɔ’m nan “bulə njerɔ’gɨ”, tadɔ jɨ banyi ngayn.» ");
INSERT INTO gqr_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Non kɨ dɔ Jeju’tɨ kɨ nja nan’tɨ nan’tɨ kadɨ tuwə’de kɔ me ɓe’tɨ kin el. ");
INSERT INTO gqr_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Dɔkagilo’ə’tɨ kin, bulə kɔsongɨ’gɨ ngayn ra sɔi nya kadɨ mbal’tɨ non. ");
INSERT INTO gqr_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ndil’gɨ kɨ majel nonyi dɔ Jeju’tɨ eli’ə eyina: «Tuwə’je adɨ j’aw dann kɔsongɨ’gɨ’tɨ kam, j’ur me de’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jeju ndigɨ se’de dɔ’tɨ, adɨ tei me dingəm’tɨ kakin, ə awi uri me kɔsongɨ’gɨ’tɨ. Tanan’tɨ non, bulə kɔsongɨ’gɨ kɨ asi dər joo kare, ɓingəi nan kadɨ mbal’tɨ taa, tosi me ba’tɨ, adɨ anyinan mann oyi. ");
INSERT INTO gqr_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Njengəm kɔsongɨ’gɨ anyinan awi me ɓebo’tɨ, kɨ me ndɔɔ’gɨ, ɔri poy nya kɨ ra nya de’gɨ, adɨ de’gɨ awi kadɨ n’oyi nya kɨ ra nya kakin. ");
INSERT INTO gqr_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Lokɨ de’gɨ kakin rei tei rɔ Jeju’tɨ ningə, oy dingəm kɨ aw kɨ ndil’gɨ kɨ majel kakin isɨ rɔ’a’tɨ. Oyi’ə kadɨ isɨ kɨ hangal kɨ majɨ, taa isɨ kɨ ku rɔ’ne’tɨ tɔ. Nya’gɨ kin ra adɨ ɓol ra’de ngayn. ");
INSERT INTO gqr_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ningə de’gɨ kɨ awi lo nya’gɨ’tɨ kɨ Jeju ra, ɔri madɨ de’gɨ poy nya kɨ te dɔ dingəm’tɨ kɨ aw kɨ ndil’gɨ kɨ majel, kɨ nya kɨ te dɔ kɔsongɨ’gɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Be ə, uləi ngirə kadɨ nonyi dɔ Jeju eyina: «Nja’i ba, inyə dɔnangɨ lə’je, ə aw.» ");
INSERT INTO gqr_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Dɔkagilo’tɨ kɨ Jeju ra ala me to’tɨ gogɨ ningə, dingəm kɨ Jeju tuwə ndil’gɨ kɨ majel me’ə’tɨ kakin dəj’ə kadɨ n’aw si’ə. ");
INSERT INTO gqr_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Nan Jeju ɔdɨ el, ə el’ə ene: «Ɔtɨ aw ɓe dann noj’i’gɨ’tɨ, ɔr’de poy nya kɨ Burəɓe ra sə’i kɨ koo kumtondoo kɨ ətɨ ɓol kɨ ɔjɨ dɔ’i’tɨ kin.» ");
INSERT INTO gqr_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","In be ə, dingəm kakin ɔtɨ aw dɔnangɨ Ɓebo’gɨ’tɨ kɨ Dɔgɨ, ɔr poy nya’gɨ kɨ Jeju ra si’ə. De’gɨ pətɨ kɨ oyi ta kin, ətɨ’de ɓol. ");
INSERT INTO gqr_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Lokɨ Jeju təl aw gidə ba’tɨ kɨ to ningə, bulə de’gɨ ngayn kawinan rɔ’a’tɨ kadɨ ba’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ningə dingəm kare kɨ dann njekundɔ kəykawnan’tɨ lə Juwipɨ’gɨ kɨ, tɔ’a nan Jayrusɨ re. Lokɨ oo Jeju ningə, osɨ nanga nja’a’tɨ, ");
INSERT INTO gqr_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","non dɔ’a’tɨ kɨ tɔgɨ’ne ene: «Ngonn’m kɨ dene kɨ du isɨ oy. Nja’i ba kadɨ aw ində ji’i dɔ’a’tɨ adɨ ingə kajɨ, ə oy el.» ");
INSERT INTO gqr_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Jeju ɔtɨ aw si’ə, ningə bulə de’gɨ ngayn njiyəi go’ə’tɨ, mborei’ə kɨ yo ge kɨ ne ge. ");
INSERT INTO gqr_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Dene kare kɨ monyi mosɨ ad’a kon ɓal dɔgɨ gidə in joo in dann bulə de’gɨ’tɨ non. ");
INSERT INTO gqr_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Monyi kin ad’a kon ngayn, adɨ anyi ngodɨ ngayn tɔ go de’gɨ’tɨ kɨ njera de’gɨ monyi, nan tujɨ nyakingə lə’ne dɔ’tɨ kɔ kare, ningə ingə kon ji’de’tɨ to kingə yo. Monyi aw kɨ kete kete to kaw par, nya kɨ to sotɨ goto. ");
INSERT INTO gqr_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Dene kakin oo ta lə Jeju. Be ə, dann bulə de’gɨ’tɨ, re kɨ row kɨ gidɨ Jeju’tɨ, ɔdɨ ta ku li’ə. ");
INSERT INTO gqr_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Tadɔ el me’ne’tɨ ene: «Kin ə re ku li’ə par ə m’ɔdɨ ə rɔ’m a ingə lapiya.» ");
INSERT INTO gqr_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ningə tanan’tɨ non par ə ginn mosɨ li’ə gangɨ, adɨ gər me darɔ’ne’tɨ tokɨ darɔ’ne ingə lapiya nga. ");
INSERT INTO gqr_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Low’ə’tɨ non, Jeju gər me hangal’ne’tɨ tokɨ tɔgɨ te rɔ’ne’tɨ. Be ə, təl kum’ne gogɨ dann bulə de’gɨ’tɨ, dəjɨ’de ene: «Nan ə ɔdɨ ta ku lə’m wa?» ");
INSERT INTO gqr_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ə Njendo’gɨ li’ə eli’ə eyina: «Inɓe in gər majɨ kadɨ bulə de’gɨ mborei nu kɨ yo ge kɨ ne ge, ə in təl dəjɨ ene: “Nan ɔdɨ’m ɓay wa?”» ");
INSERT INTO gqr_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Nan Jeju nanyi kɨ lo gon lo’tɨ gugɨ gidɨ’ne kadɨ n’oo dene inɓe kɨ ra nya kin. ");
INSERT INTO gqr_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ɓol ra dene kakin ngayn, adɨ dadɨ par par, tadɔ gər nya kɨ ra’a me rɔ’a’tɨ. Be ə, re osɨ nanga nja Jeju’tɨ, el’ə ta’gɨ kɨ rɔta’tɨ pətɨ kɨ to me’ə’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Nan Jeju el’ə ene: «Ngonn’m, kunme lə’i aj’i. Aw kɨ lapiya, ə kadɨ ingə lapiya dɔ monyi’tɨ lə’i.» ");
INSERT INTO gqr_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Lokɨ Jeju ra elta ba ɓay ningə, de’gɨ madɨ in me kəy’tɨ lə Jayrusɨ, kɨ in kɨ njekundɔ kəykawnan lə Juwipɨ’gɨ, rei eli Jayrusɨ eyina: «Ngonn’i oy, in ndɔjɨ Njendo, el nga.» ");
INSERT INTO gqr_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Lokɨ Jeju oo ta kel’de be ningə, usə dɔ’tɨ el, ə elta kɨ njekundɔ kəykawnan lə Juwipɨ’gɨ ene: «Adɨ ɓol rai el, un me’i par!» ");
INSERT INTO gqr_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Jeju ɔgɨ kadɨ de’gɨ dani’ə, nan inyə Piyər num, Jakɨ num, Jan kɨ ngonnkon Jakɨ num par ə adɨ dani’ə. ");
INSERT INTO gqr_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Lokɨ rei tei ɓe lə njekundɔ kəykawnan lə Juwipɨ’gɨ ningə, Jeju oo de’gɨ kɨ isɨ singəi səkitə, isɨ nonyi ge uri wuyi ge. ");
INSERT INTO gqr_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Jeju ur me kəy’tɨ ningə, el’de ene: «Ra bann ə de’gɨ singəi dɔnan’tɨ səkitə kɨ non be wa? Ngonn oy el, nan to ɓi kare.» ");
INSERT INTO gqr_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","De’gɨ kogi dɔ Jeju’tɨ, soki’ə’n’ə. Be ə, Jeju adɨ de’gɨ pətɨ tei taga, ningə baw ngonn num, kon ngonn num, njendo’gɨ li’ə kɨ dani’ə num par ə ai si’ə me kəy’tɨ kɨ ngonn to’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Jeju uwə ji ngonn, el’ə ene: «Talita kumi!» Adɨ kɔr me’ə nan: «ngonn kɨ dene, m’el’i m’ene, ində taa!» ");
INSERT INTO gqr_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Tanan’tɨ non, ngonn kɨ dene ində taa, njiyə, tadɔ ɓal’a in dɔgɨ gidə in joo. Nya kɨ Jeju ra kin ətɨ de’gɨ ɓol kɨ dum. ");
INSERT INTO gqr_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Lo kin’tɨ, Jeju ndəjɨ’de kadɨ elita nya kɨ ra nya kin de madɨ el. Ningə, el’de kadɨ uni nyakusɔ adɨ ngonn kɨ dene kakin sɔ. ");
INSERT INTO gqr_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jeju in low’ə’tɨ non aw ɓe kɨ tɔgɨ’tɨ, nan’tɨ kɨ njendo’gɨ li’ə awi go’ə’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Lokɨ ndɔ kɔrkon lə Juwipɨ’gɨ asɨ ningə, Jeju ulə ngirə ndo de’gɨ nya me kəykawnan’tɨ lə Juwipɨ’gɨ. De’gɨ ngayn oyi dɔ ta li’ə, adɨ ətɨ’de ɓol, ningə eli eyina: «De kam, ingə nyando kin ra? Ə nan ə ad’a gosɨ kɨ ətɨ ɓol be kin wa? Tɔgɨ kɨ ra’n nyakɔjɨ’gɨ kɨ ətɨ ɓol be kin ingə ra wa? ");
INSERT INTO gqr_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Man! Njeragɨ kagɨ dɔ kəy’tɨ inɓe kɨ in ngonn lə Mari el wa? Jakɨ ge, kɨ Joje ge, kɨ Judɨ ge, kɨ Simon ge, in ngannkon’a’gɨ el wa? Taa, konnann’a’gɨ kaa sii se’je ne tɔ el wa?» Nya’gɨ kin ra nya adɨ Jeju təl jigɨ non’de’tɨ um lo kadɨ uni me’de adi’ə goto. ");
INSERT INTO gqr_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Be ə, Jeju el’de ene: «Lo kadɨ de’gɨ a ɔsikurə njekeltakita Luwə’tɨ, me ɓe koj’o’tɨ, dann noj’o’gɨ’tɨ, kɨ me kəy’tɨ li’ə goto.» ");
INSERT INTO gqr_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Lo kadɨ Jeju ra nyakɔjɨ kɨ ətɨ ɓol me ɓe’tɨ kɨ Najaretɨ’tɨ goto, nan ndə ji’ne dɔ njemonyi’gɨ’tɨ kɨ nan’gɨ gandɨ gandɨ par, adi’de ingəi lapiya. ");
INSERT INTO gqr_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ndɔjɨ Jeju ngayn tadɔ mbətɨ kɨ mbəti kun me’de kad’a. Jeju njiyə kɨ ngann ɓe’gɨ kɨ gugɨ dɔ Najaretɨ, ndo de’gɨ nya. ");
INSERT INTO gqr_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ningə, Jeju ɓar njendo’gɨ lə’ne kɨ dɔgɨ gidə in joo kɨ rɔ’ne’tɨ, ə ulə’de joo joo. Adɨ’de tɔgɨ dɔ ndil’gɨ’tɨ kɨ majel tɔ. ");
INSERT INTO gqr_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Jeju adɨ’de ndu kadɨ uni nya kare tadɔ dɔ row el, nan gɔl kareba par. El’de ene: «A uni nyakusɔ el num, ɓɔl el num, ta a ɓiri nar me kulə dɔ ɓədɨ’se’tɨ el num tɔ. ");
INSERT INTO gqr_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Uləi sa nja’se’tɨ, ə ai kɨ ku kareba.» ");
INSERT INTO gqr_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Jeju el’de ene: «Lo kɨ tei lo madɨ’tɨ me kəy kɨ uwə’se rɔ’ne’tɨ, ə si’tɨ bitɨ ndɔ kaw’se’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ə re me ɓebo’tɨ madɨ, ə de’gɨ mbeti kuwə’se rɔ’de’tɨ, eke mbeti koyi dɔ ta lə’se, lokɨ isɨ tei me ɓe’tɨ kin kɨ taga ningə, indəi bu sa’gɨ kɨ nja’se’tɨ, kadɨ to to nya ndəjɨ ndu’de.» ");
INSERT INTO gqr_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Njendo’gɨ ai iləi mbər Poyta kɨ majɨ kadɨ de’gɨ inyəi gorow njiyə’de kɨ majel kɔ. ");
INSERT INTO gqr_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Tuwəi ndil’gɨ kɨ majel ngayn ta uri hu dɔ njemonyi’gɨ’tɨ ngayn, adi’de lapiya tɔ. ");
INSERT INTO gqr_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ngar *Erodɨ oo ta lə Jeju, tadɔ tɔɓar li’ə asɨ lo’gɨ nakɨ nakɨ. De’gɨ kɨ nan’gɨ eyina: «In Jan Batisɨ ə ində taa dann njekoy’gɨ’tɨ. Ginn’ə kin ə, awɨ’n kɨ tɔgɨ tadɔ ra’n nya’gɨ kɨ ətɨ ɓol ɓol.» ");
INSERT INTO gqr_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Nje kɨ nungɨ eli eyina: «In Eli kɨ njekeltakita Luwə’tɨ.» Nje kɨ nan’gɨ ɓay eli eyina: «In njekelta kɨ ta Luwə’tɨ to nje kɨ rei kete kin be tɔ.» ");
INSERT INTO gqr_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Lokɨ Erodɨ oo ta kin ningə, el ene: «In Jan kɨ ndɔ kɨ madɨ gangi dɔ’a kaa ə ində lo koy’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Erodɨ el be, tadɔ ndɔkɨ inɓe adɨ uwəi Jan, dɔi’ə kɨ kulə gindɨ, iləi’ə dangay’tɨ, tadɔ Erodiyadɨ, kɨ ne ngonnkon’a Pilipɨ, kɨ ində taa’a ne’ne’tɨ, ");
INSERT INTO gqr_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","ə Jan el’ə ta dɔ’tɨ ene: «In go’tɨ el kadɨ ində taa ne ngonnkon’i ne’i’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Erodiyadɨ uwə Jan me’ne’tɨ ngayn, adɨ sangɨ row tɔl’ɔ, nan asɨ el. ");
INSERT INTO gqr_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Tadɔ Erodɨ ɓol Jan, gər kadɨ in de kɨ njera nya kɨ dana, taa in de kɨ ar njay tɔ. Be ə, Erodɨ ngəm’ə majɨ. Lokɨ Erodɨ oo ta kel Jan ningə, ta kin uwə kɨ ta, nan be kaa, Erodɨ ge koo ta kel Jan par par. ");
INSERT INTO gqr_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ndɔ kɨ majɨ kɨ Erodiyadɨ isɨ sangɨ kete kete kaa re nga. Adɨ in ndɔ rɔnel kojɨ Erodɨ, ə Erodɨ adɨ rai nyakusɔ. Ningə ndɔ’a’tɨ kin, Erodɨ ɓar kibo’gɨ lə’ne num, ɓar njekundɔ njerɔ’gɨ lə’ne num, taa ɓar njetɔɓar’gɨ kɨ dɔnangɨ Galile’tɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Dɔgagilo kusɔ nya’tɨ, ngonn lə Erodiyadɨ kɨ dene, ur kəy go’de’tɨ, te la. La lə ngonn kɨ dene kin nəl Erodɨ ngayn, taa nəl de’gɨ kɨ ɓar’de lo nyakusɔ’tɨ ngayn tɔ, adɨ ngar el ngonn kɨ dene kakin ene: «Dəjɨ’m nya kɨ me’i ge par ə m’a m’ad’i.» ");
INSERT INTO gqr_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Erodɨ aw bitɨ un ndu’ne kɨ kiwrɔ ad’a ene: «Nya’gɨ pətɨ kɨ dəjɨ’m, ə m’a m’ad’i. Re in dow konɓe lə’m kaa a ingə.» ");
INSERT INTO gqr_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ngonn kɨ dene te aw taga, aw dəjɨ kon’ne ene: «In ri ə kadɨ m’dəj’ə wa?» Ə kon’a el’ə ene: «Dəj’ə dɔ Jan Batisɨ.» ");
INSERT INTO gqr_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ngonn kɨ dene təl kalangɨ ba aw rɔ ngar’tɨ el’ə ene: «Tokɨ jɨ ra’n tanan’tɨ ne inɓe kin, kadɨ adɨ’m dɔ Jan Batisɨ me supira’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Me ngar tujɨ, ɔjidɔ nya’tɨ kɨ ngonn kɨ dene dəj’ə kin, nan lo kadɨ ɔg’ɔ goto tadɔ kun ndu kɨ un kɨ kiwrɔ, taa tadɔ de’gɨ kɨ ɓar’de lo nyakusɔ’tɨ tɔ kin. ");
INSERT INTO gqr_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Be ə tanan’tɨ non, ngar un ndu’ne adɨ njerɔ kare kɨ njengəm’ə kadɨ aw kəy dangay’tɨ gangɨ dɔ Jan re’n. ");
INSERT INTO gqr_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Njerɔ aw gangɨ dɔ Jan me supira’tɨ, re’n adɨ ngonn kɨ dene. Ningə ngonn kɨ dene kakin təl’n adɨ kon’ne. ");
INSERT INTO gqr_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Lokɨ njendo’gɨ lə Jan oyi poyta kin ningə, rei uni ninn’ə awi duwi. ");
INSERT INTO gqr_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Lokɨ njekawkulə’gɨ təli lo kulə’gɨ’tɨ lə’de ningə, kawinan rɔ Jeju’tɨ, ɔri’ə poy nya’gɨ kɨ rai kɨ nya’gɨ kɨ ndoi de’gɨ adi’ə oo. ");
INSERT INTO gqr_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Bulə de’gɨ ngayn awi num, təli num adɨ lo kadɨ njendo’gɨ ingəi ngonn dɔkagilo nden be kadɨ sɔi nya kaa goto. Be ə, Jeju el’de ene: «In rei adɨ j’awi lo kɨ de’gɨ gotoi’tɨ kin kadɨ ɔri kon nden.» ");
INSERT INTO gqr_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Be ə, ali me to’tɨ tadɔ kaw kɔsɨ rɔ’de ngərəngɨ, lo kɨ de’gɨ gotoi’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","De’gɨ ngayn oyi’de lo kaw de’tɨ, ə gəri’de ɓətɨ tɔ. De’gɨ in ɓebo’gɨ’tɨ kɨ dangɨ dangɨ, anyinan kɨ nja’de bur bur awi kete, lo kɨ Jeju kɨ njendo’gɨ isɨ awi’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Lokɨ Jeju ur nanga me to’tɨ ningə, oo bulə de’gɨ ngayn. Lokɨ oo’de, oo kumtondoo lə’de, tadɔ rai to batɨ’gɨ kɨ njekul’de goto be. In be ə, Jeju tumginn ndo’n’de nya’gɨ ngayn. ");
INSERT INTO gqr_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Lokɨ kadɨ yətɨ rɔ’ne ə binəm taa njendo’gɨ ɔti kɨ rɔ Jeju’tɨ eli’ə eyina: «Lo kɨ jɨ rai’tɨ ne kin, in lo kɨ de’gɨ gotoi’tɨ, ningə kadɨ isɨ ur tɔ. ");
INSERT INTO gqr_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Majɨ kadɨ inyə bulə de’gɨ kam adɨ awi kɨ lo ndɔɔ’gɨ’tɨ kɨ ngannɓe’gɨ’tɨ ndogi nyakusɔ sɔi.» ");
INSERT INTO gqr_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Nan Jeju təl el’de ene: «Inɓe’gɨ adi’de nya sɔi.» Ningə, njendo’gɨ dəji’ə eyina: «Kadɨ j’aw jɨ ndogɨ mapa asɨ silə ɓujo j’adɨ’de sɔi wa?» ");
INSERT INTO gqr_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jeju təl el’de ene: «Mapa kɨ ji’se’tɨ in bann wa? Ai dann de’gɨ’tɨ oyi.» Lokɨ ai dann de’gɨ’tɨ, dəji ningə, təli eli’ə eyina: «Mapa in mi, ə kanjɨ joo tɔ.» ");
INSERT INTO gqr_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Jeju un ndu’ne adɨ’de kadɨ adi de’gɨ sii nanga kɨ kut’ə kut’ə dɔ mu’tɨ kɨ mbol. ");
INSERT INTO gqr_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Be ə, de’gɨ uwəi nan ɓu ɓu ge, dɔmi dɔmi ge, ə sii nanga kɨ bara bara. ");
INSERT INTO gqr_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jeju un mapa kɨ mi kɨ kanjɨ kɨ joo kakin, un kum’ne kɨ taa, elta kɨ Luwə kadɨ njangɨ dɔ nyakusɔ kin. Go’tɨ, uwə mapa’gɨ kakin gangɨ’de nan’tɨ ə adɨ njendo’gɨ kadɨ lowəi bulə de’gɨ. Kanjɨ’gɨ kɨ joo kaa, lowə de’gɨ pətɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","De’gɨ pətɨ sɔi nya ndanni majɨ. ");
INSERT INTO gqr_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ningə, njendo’gɨ ɔyi ndəgɨ mapa kɨ kanjɨ kɨ nanyi, kara dɔgɨ gidə in joo. ");
INSERT INTO gqr_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","De’gɨ kɨ sɔi mapa kin asi dingəm’gɨ dər mi. ");
INSERT INTO gqr_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Nden ba go’tɨ, Jeju ɔsɨ njendo’gɨ lə’ne kadɨ ali me to’tɨ, ai gidɨ ba’tɨ kete non’ne’tɨ, kɨ kaw kɨ ɓebo Betisayda’tɨ nu. Ningə dɔkagilo’ə’tɨ kin inɓe inyə bulə de’gɨ kadɨ awi. ");
INSERT INTO gqr_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Lokɨ Jeju adɨ’de awi ningə, ɔtɨ aw dɔ mbal’tɨ tadɔ kelta kɨ Luwə. ");
INSERT INTO gqr_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Lokɨ lo ndul nga ningə, to in dann ba’tɨ, ə Jeju in kɨ kar’ne ba ə nanyi nanga gogɨ. ");
INSERT INTO gqr_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Jeju oo kadɨ njendo’gɨ lə’ne ingəi kon ngayn lo kɔsɨ to’tɨ, tadɔ nəl ulə, sur to kɨ gogɨ gogɨ. Taginnlo’tɨ ningə, Jeju in ra njiyə dɔ mann’tɨ, isɨ aw kɨ rɔ’de’tɨ, ningə ge kadɨ dər ta’de ɓay. ");
INSERT INTO gqr_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ə lokɨ oyi’ə ra njiyə dɔ mann’tɨ ningə, oyi kadɨ in muwə de yo, adɨ uri kɔl. ");
INSERT INTO gqr_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Inɓe’gɨ pətɨ oyi’ə, adɨ ɓol tɔl’de. Nan kalangɨ ba, Jeju el’de ene: «Adɨ me’se osɨ nanga nan in m’in! Ə ɓoli el!» ");
INSERT INTO gqr_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Jeju al go’de’tɨ me to’tɨ, ningə nəl yokiro. Lokɨ oyi nya’gɨ kin ningə ndil’de te saw. ");
INSERT INTO gqr_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Tadɔ kɨ rɔta’tɨ, njendo’gɨ gəri kum nya kɨ Jeju ra ɔjidɔ mapa kin el, tadɔ me ngan lə’de. ");
INSERT INTO gqr_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Lokɨ Jeju in kɨ njendo’gɨ lə’ne ali gidɨ babo ningə, tei dɔnangɨ Genejaretɨ’tɨ. Indəi to lə’de ngangɨ ba’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Lokɨ uri nanga taa par ə, de’gɨ gəri Jeju ə binəm. ");
INSERT INTO gqr_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Adɨ, anyinan ngodɨ asi ɓe’gɨ kɨ dɔnangɨ’tɨ kin non nakɨ, nakɨ. De’gɨ iləi rɔ’de, ɔyi njemonyi’gɨ lə’de me tuwə to de’tɨ, rei se’de rɔ’a’tɨ, lokɨ oyi kadɨ Jeju sɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Lo’gɨ pətɨ kɨ awi’tɨ, ngann ɓe’gɨ kɨ ɓebo’gɨ kɨ lo ndɔɔ’gɨ, de’gɨ rei kɨ njemonyi’gɨ ɓuki’de tambalo’tɨ, ə nonyi dɔ Jeju’tɨ kadɨ inyə njemonyi’gɨ adɨ ɔdi ta ku li’ə. Ningə, nje kɨ ɔdi ta ku li’ə ingəi lapiya tɔ. ");
INSERT INTO gqr_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Parisɨ’gɨ kɨ njendo ndukun’gɨ lə Luwə madɨ in Jerujalem’tɨ, kawinan dɔ Jeju’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Oyi kadɨ njendo’gɨ li’ə kɨ kɨ madɨ’gɨ sɔi nya ji’de yoro um togi ji’de kigo row ragotɨ el. ");
INSERT INTO gqr_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Tokɨ rɔta’tɨ, Parisɨ’gɨ kɨ Juwipɨ’gɨ ba pətɨ, togɨ ji’de ə binəm taa sɔi nya, um sɔi nya kɨ ji’de kɨ yoro el. Adɨ in kində kum go nyajibəlɓe’tɨ lə kaw’de’gɨ. ");
INSERT INTO gqr_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Be tɔ ə, re təli sukɨ’tɨ ningə, a ndogi mann rɔ’de sukɨ sukɨ ɓay ta a sɔi nya. Awi kɨ nyajibəlɓe’gɨ kɨ rangɨ ngayn kɨ isɨ təli rɔ’de go’tɨ ɓay to togɨ nya kaynmann’gɨ kɨ ngo’gɨ kɨ ngoo ningə kasɨ, kɨ gorow ra’a’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Parisɨ’gɨ kɨ njendo ndukun’gɨ lə Luwə dəji Jeju eyina: «Tadɔ ri ə njendo’gɨ lə’i təli rɔ’de go nya jibəlɓe’tɨ lə kaw’je’gɨ el wa? Ra bann ə togi ji’de el par ə sɔi nya kɨ ji’de kɨ yoro ba wa?» ");
INSERT INTO gqr_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jeju ilə’de’tɨ ene: «Ta kɨ Luwə el kɨ ta njekeltakita’ne’tɨ Ejay dɔ’se’tɨ in ta kɨ rɔta’tɨ. In njekədikum de’gɨ, tadɔ Luwə adɨ Ejay ndangɨ ene: “Ginn de’gɨ kin ɔsikurə’m kɨ ndar ta’de kare, Nan me’de in sanyi sə’m. ");
INSERT INTO gqr_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Tɔjɨ kɨ isɨ uləi dɔ’m’tɨ, nda’a goto, Tadɔ nyando’gɨ kɨ isɨ ndoi de’gɨ kaa, In mbərkikində’gɨ kɨ in rɔ de’gɨ’tɨ.”» ");
INSERT INTO gqr_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Jeju el’de ene: «Inyəi mbərkikində lə Luwə dow kare, ə in təli rɔ’se go nya jibəlɓe’tɨ lə de’gɨ yo.» ");
INSERT INTO gqr_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ningə, Jeju el ɓay ene: «To rɔ’se el kadɨ inyəi go mbərkikində lə Luwə kalangɨ ba kadɨ ngəmi go nyajibəlɓe lə’se! ");
INSERT INTO gqr_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Tadɔ, Mojɨ ene: “Ɔsɨ kurə baw’i kɨ kon’i.” Taa el ɓay ene: “De kɨ elta kɨ majel baw’ne eke kon’ne asɨ ta koy.” ");
INSERT INTO gqr_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Nan ingɨ, eli eyina: “Re de madɨ el baw’ne eke kon’ne ene: ‹Nya majɨ’gɨ kɨ re m’a m’ɔsɨ’n kɔyi ə in kɔrban› (kɔr me’ə nan kadikare lə Luwə).” ");
INSERT INTO gqr_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","In kin ɔjɨ kadɨ utɨ tarow kadɨ de madɨ ra nya ɔsɨ’n kɔy baw’ne eke kon’ne. ");
INSERT INTO gqr_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Gonyi row tujɨ kɨ isɨ tuji ta lə Luwə kɨ nyajibəlɓe lə’se kin oyi! Nya kɨ isɨ ndoi de’gɨ kɨ kete kete. Ta nya’gɨ kɨ rangɨ kɨ toi be ngayn kɨ isɨ rai in non ɓay.» ");
INSERT INTO gqr_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Go’tɨ ningə, Jeju ɓar bulə de’gɨ kɨ rɔ’ne’tɨ ɓay ə el’de ene: «Ingɨ pətɨ uri mbi’se majɨ kadɨ oyi dɔ ta lə’m, kadɨ gəri me’ə tɔ.» ");
INSERT INTO gqr_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Nya madɨ kɨ in taga aw me de’tɨ kɨ a təl’ə nya kɨ to njen’tɨ goto. Nan nya kɨ in me de’tɨ te taga ə a təl’ə nya kɨ to njen’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Re de madɨ aw kɨ mbi’ne kadɨ oo’n dɔ ta ningə, kadɨ oo. ");
INSERT INTO gqr_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Lokɨ Jeju inyə bulə de’gɨ, ə təl aw me kəy’tɨ ningə, njendo’gɨ li’ə dəji’ə kadɨ ɔr’de ginn kujita kakin. ");
INSERT INTO gqr_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jeju el’de ene: «Adɨ inɓe’gɨ kaa gəri nya el tɔ wa? In gəri me ta kɨ m’ge kel kin el wa? Nya pətɨ kɨ in taga kɨ aw me de’tɨ, nya kare kɨ a təl’ə kɨ njen’tɨ goto. ");
INSERT INTO gqr_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Tokɨ rɔta’tɨ, nya’gɨ kin pətɨ awi ngarme’ə’tɨ el, nan awi kanda’a’tɨ yo, ningə go’tɨ tei kɔ awi ɓe sin’tɨ. Ta lə Jeju kin tɔjɨ kadɨ nyakusɔ’gɨ pətɨ in kɨ kar njay.» ");
INSERT INTO gqr_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ningə Jeju el’de ɓay ene: «Nya kɨ te rɔ de’tɨ kɨ taga ə in nya kɨ nje təl de nya kɨ to njen’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","In me de’tɨ kəy, in ngarme de’tɨ ə, mərta’gɨ kɨ majel sii tei’tɨ, kɨ kaya kɨ ra, kɨ ɓogɨ, kɨ tɔl nan, ");
INSERT INTO gqr_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","kɨ kuwə marum, kɨ ra kumnda nya, kɨ mendul, kɨ kədinan, kɨ nyara kɨ gorow’ə’tɨ el, kɨ kɔjirɔ, taa kulə ra’gɨ kɨ to mbo tɔ. ");
INSERT INTO gqr_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Nya’gɨ kɨ majel kin pətɨ in me de’tɨ ə təli’ə nya kɨ to njen’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jeju in low’ə’tɨ non ningə aw dɔnangɨ’tɨ kɨ Tir. Aw ur me kəy’tɨ madɨ, ge kadɨ de’gɨ gəri go’ne el, nan lowə goto. ");
INSERT INTO gqr_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Re inɓe kɨ Jeju re te ɓay par ə, dene madɨ kɨ ndil kɨ majel isɨ adɨ kon ngonn’o kɨ dene oo ta li’ə, ə anyi re osɨ nanga nja’a’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","In dene kɨ in Juwipɨ el, ɓe koj’o in Penesi, dɔnangɨ Siri’tɨ. Non kɨ dɔ Jeju’tɨ kadɨ tuwə ndil kɨ majel kɨ isɨ adɨ kon ngonn’o kin kɔ. ");
INSERT INTO gqr_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Nan Jeju el’ə ene: «Inyə adɨ ngann’gɨ kɨ me kəy’tɨ sɔi asɨ’de ɓay ta. Tadɔ in go’tɨ el kadɨ de un nyakusɔ lə ngann’gɨ, ilə adɨ ngann busɨ’gɨ.» ");
INSERT INTO gqr_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ə dene kakin ilə’tɨ ene: «In rɔta’tɨ Burəɓe, nan k’in ə ngann busɨ’gɨ kɨ rai ginn tabilə’tɨ a sɔi bunə nya’gɨ kɨ tei ta ngann’gɨ’tɨ tosɨ nanga tɔ.» ");
INSERT INTO gqr_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ningə Jeju el’ə ene: «Takul ta kɨ te ta’i’tɨ kin, ɔtɨ aw ɓe lə’i, tadɔ ndil kɨ majel te me ngonn’i’tɨ kɨ dene kɔ nga.» ");
INSERT INTO gqr_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Dene kakin təl aw ɓe ningə, ingə ngonn’ne, to dɔ tirə’tɨ kare, tadɔ ndil kɨ majel kakin te rɔ’a’tɨ kɔ. ");
INSERT INTO gqr_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jeju in dɔnangɨ Tir, gangɨ Sidon, ningə ində dɔnangɨ Ɓebo’gɨ’tɨ kɨ Dɔgɨ gangɨ ɓay ta re te ta mann ba Galile’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","De’gɨ rei kɨ dingəm kare kɨ mbi’ə boy, kɨ lo kelta ngan si’ə, rɔ Jeju’tɨ, dəji’ə kadɨ ində ji’ne dɔ’a’tɨ, kadɨ ingə lapiya. ");
INSERT INTO gqr_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jeju ɔr’ɔ kɨ kar’a ba aw si’ə sanyi kɨ bulə de’gɨ. Lokɨ tulə ngann ji’ne’gɨ mbi njemonyi’tɨ ningə, tuw mann ta’ne ɔdɨ’n ndonn dingəm kakin. ");
INSERT INTO gqr_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Go’tɨ ningə, Jeju un kum’ne kɨ dɔran’tɨ, ilə kon puu, ə el ene: «Epata» (kɔr me ta kin nan: mbutɨ). ");
INSERT INTO gqr_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Tanan’tɨ non par ə mbi dingəm kakin mbutɨ, ə ndonn’o tutɨ adɨ elta ar njay njay. ");
INSERT INTO gqr_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jeju ndɔr mbi de’gɨ kɨ oyi nya kin kadɨ de el ta’a kete adɨ de kɨ rangɨ oo el. Lokɨ ndɔr mbi’de kɨ nja nan’tɨ nan’tɨ kadɨ de ɔr poy nya kin el ningə, kadibe ɓay ə de’gɨ ɔri poy nyara’a kɨ kete kete. ");
INSERT INTO gqr_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Nya ra Jeju ətɨ bulə de’gɨ ɓol ngayn adɨ eli eyina: «Nya ra’a’gɨ pətɨ majɨ: Ra nje’gɨ kɨ mbi’de boy adɨ oyi dɔ ta, ta ra mbiki’gɨ adɨ elita tɔ.» ");
INSERT INTO gqr_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Me ndɔ’gɨ’tɨ kin, bulə de’gɨ ngayn kawinan tokɨ rangɨ ɓay dɔ Jeju’tɨ. Ningə, nya kɨ kadɨ sɔi goto. Be ə Jeju ɓar njendo’gɨ lə’ne el’de ene: ");
INSERT INTO gqr_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«M’oo kumtondoo lə bulə de’gɨ kin, tadɔ ndɔ mutə ɓone ə in sə’m nan’tɨ, ningə, nya kɨ kadɨ sɔi goto. ");
INSERT INTO gqr_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Re m’inyə’de m’adɨ awi ɓe kɨ me’de ɓo ba a, ɓo a taa tɔgɨ’de row’ə, tadɔ nje kɨ madɨ dann’de’tɨ in sanyi ə rei.» ");
INSERT INTO gqr_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Njendo’gɨ li’ə təli eli’ə eyina: «J’a j’ingəi mapa ra diləlo’tɨ ne, ə a asɨ kadɨ’de sɔi wa?» ");
INSERT INTO gqr_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jeju dəjɨ’de ene: «Mapa kɨ ji’se’tɨ in bann wa?» Ə eli’ə eyina: «Mapa in siri.» ");
INSERT INTO gqr_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Go’tɨ ningə, Jeju ilə ndu’ne adɨ bulə de’gɨ kadɨ sii nanga. Ɔy mapa kɨ siri kakin ji’ne’tɨ, ra oyo Luwə dɔ’tɨ ningə, gangɨ’de nan’tɨ, ə adɨ njendo’gɨ lə’ne kadɨ adi bulə de’gɨ. Be ə, njendo’gɨ tai adi bulə de’gɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ai kɨ ngann kanjɨ’gɨ ji’de’tɨ tɔ. Jeju njangɨ dɔ’a ə adɨ njendo’gɨ lə’ne kadɨ lowəi de’gɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","De’gɨ sɔi nya ndanni, adɨ, njendo’gɨ kawi gində’gɨ kɨ nanyi kara siri. ");
INSERT INTO gqr_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","De’gɨ kɨ sɔi nya, asi dər sɔ. Go’tɨ ningə, Jeju inyə’de adɨ awi. ");
INSERT INTO gqr_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Kalangɨ ba go’tɨ, Jeju in kɨ njendo’gɨ lə’ne ali me to’tɨ, awi dɔnangɨ Dalmanuta’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Parisɨ’gɨ in non rei ningə, uləi ngirə manjinan ta’tɨ kɨ Jeju. Ə dəji’ə kadɨ ra nyakɔjɨ madɨ kɨ in dɔran’tɨ adɨ n’oyi. Dəji’ə be to kuləkikiyə tadɔ kuwə’n’ə. ");
INSERT INTO gqr_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jeju ilə me’ne hmm, ə el’de ene: «Tadɔ ri ə de’gɨ kɨ dɔkagilo’tɨ kɨ ɓone kin dəji kadɨ n’oyi nyakɔjɨ wa? Tokɨ rɔta’tɨ, adɨ m’el’se madɨ oyi! nyakɔjɨ madɨ kɨ kadɨ de a ra tadɔ lə’de goto.» ");
INSERT INTO gqr_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Be ə, Jeju inyə’de, ə al me to’tɨ tadɔ kaw dow ba’tɨ kɨ kare. ");
INSERT INTO gqr_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Me njendo’gɨ oy dɔ mapa’tɨ kɨ kadɨ ɔyi. In kɨ ji’de’tɨ kɨ sii me to’tɨ in kareba par. ");
INSERT INTO gqr_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jeju ndəjɨ’de, ə el’de ene: «Oyi majɨ! Oyi go rɔ’se majɨ dɔ hum’tɨ lə Parisɨ’gɨ, kɨ yan Erodɨ tɔ.» ");
INSERT INTO gqr_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Njendo’gɨ manjinan ta dann’de’tɨ eyina: «Jeju el be tadɔ j’aw kɨ mapa el!» ");
INSERT INTO gqr_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jeju gər ta kɨ me’de’tɨ, adɨ el’de ene: «Tadɔ ri ə isɨ manjinan ta dann’se’tɨ dɔ mapa’tɨ kɨ ɔyi el wa? In gəri me nya’gɨ el kaa ɓay wa? Ngarme’se ngan kaa ɓay wa? ");
INSERT INTO gqr_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Awi kɨ kum’se eke oyi lo el wa? Awi kɨ mbi’se ke oyi dɔ ta el wa? Me’se olo dɔ nya’gɨ’tɨ el wa? ");
INSERT INTO gqr_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ndɔkɨ m’lowə mapa mi, de’gɨ dər mi, eke ndəgɨ gindɨ mapa kɨ nanyi, ɔyi rosɨ kara bann wa?» Eli eyina: «J’ɔyi rosɨ kara dɔgɨ gidə in joo.» ");
INSERT INTO gqr_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","«Nga ndɔkɨ, m’lowə mapa siri dingəm’gɨ dər sɔ kin, gində’gɨ kɨ nanyi, ndɔkɨ ɔyi kara bann tɔ wa?» Ningə eli’ə eyina: «J’ɔyi kara siri.» ");
INSERT INTO gqr_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Lo kin’tɨ Jeju el’de ene: «In gəri el ɓay wa?» ");
INSERT INTO gqr_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Lokɨ Jeju in kɨ njendo’gɨ lə’ne rei tei me ɓe’tɨ kɨ Betisayda’tɨ ningə, de’gɨ rei kɨ njekumtɔ kare rɔ Jeju’tɨ. De’gɨ kakin nonyi dɔ Jeju’tɨ kadɨ ɔd’ɔ. ");
INSERT INTO gqr_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jeju uwə ji njekumtɔ kakin, ə aw si’ə gidɨ ɓe’tɨ. Lokɨ nyom kum’ə kɨ mann ta’ne ningə, ində ji’ne dɔ’a’tɨ ə dəj’ə ene: «Oo nya madɨ wa?» ");
INSERT INTO gqr_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Njekumtɔ gon lo ningə ene: «M’oo de’gɨ, nan to ə toi to kagɨ’gɨ ə ra njiyəi be.» ");
INSERT INTO gqr_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jeju təl ində ji’ne dɔ kum’ne’tɨ nja kare ɓay adɨ oo lo ar njay njay nga. Ingə lapiya, ta oo nya’gɨ pətɨ ar njay njay tɔ. ");
INSERT INTO gqr_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Go’tɨ ningə, Jeju inyə adɨ aw ɓe lə’ne, ə el’ə ene: «Ononyi təl kaw me ɓe’tɨ kin gogɨ.» ");
INSERT INTO gqr_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jeju ɔtɨ low’ə’tɨ non ningə, awi kɨ njendo’gɨ lə’ne ngann ɓe’gɨ’tɨ kɨ gidɨ Sejare’tɨ, kɨ Pilipɨ. Lokɨ in dɔ row’tɨ, Jeju dəjɨ’de ene: «De’gɨ isɨ elita dɔ’m’tɨ tokɨ m’in nan wa?» ");
INSERT INTO gqr_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ə njendo’gɨ eli’ə eyina: «De’gɨ madɨ eyina in Jan Batisɨ; nje kɨ nungɨ eyina in njekeltakita Luwə’tɨ Eli; nje kɨ rangɨ ɓay eyina in kɨ kare dann de’gɨ’tɨ kɨ njekeltakita Luwə’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ningə, Jeju təl re dəjɨ’de inɓe’gɨ ene: «Nga inɓe’gɨ kɨ dɔ’se, eli eyina m’in nan wa?» Ə Piyər ilə’tɨ ene: «In Kirisitɨ, *De kɨ Luwə mbət’ə!» ");
INSERT INTO gqr_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Jeju ndəjɨ’de kɨ tɔgɨ’ne kadɨ elita kete kadɨ de kɨ rangɨ oo el. ");
INSERT INTO gqr_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Go ta’gɨ’tɨ kin ningə, Jeju ulə ngirə kadɨ ndo’de tokɨ n’in Ngonn de n’a n’ingə kon ngayn. *Ngatɔgɨ’gɨ lə Juwipɨ’gɨ kɨ kibo’gɨ lə njekujənyamosɨ kadikare’gɨ, kɨ njendo ndukun’gɨ mbəti’ə. De’gɨ tɔli’ə, nan ndɔ kɨ kon mutə tum ginn’ə ndɔ koy’o, a te lo koy’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","El’de ta’gɨ kin pətɨ ar njay. Piyər ɔr Jeju aw si’ə gədikare, ningə ulə ngirə ndang’a. ");
INSERT INTO gqr_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Nan Jeju təl rɔ’ne, gon njendo’gɨ lə’ne ningə ndangɨ Piyər kɨ tɔgɨ’ne ngayn ene: «In təl gogɨ Satan! Ɔr rɔ’i kɔ sanyi rɔ’m’tɨ, tadɔ mərta lə’i in mərta kɨ in rɔ Luwə’tɨ el, nan in mərta lə de’gɨ.» ");
INSERT INTO gqr_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Go’tɨ ningə, Jeju ɓar bulə de’gɨ kɨ njendo’gɨ lə’ne, ningə el’de ene: «Re de madɨ ndigɨ njiyə go’m’tɨ ningə, kadɨ oo rɔ’ne to nya madɨ el, kadɨ inɓe un kagidəsɨ koy lə’ne, ə re un go’m. ");
INSERT INTO gqr_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Tokɨ rɔta’tɨ, de kɨ ge kajɨ rɔ’ne n’inɓe dɔnangɨ’tɨ ne a ilə rɔ’ne kɔ. Nan de kɨ ilə rɔ’ne kɔ tadɔ lə’m, eke tadɔ Poyta kɨ majɨ, a ajɨ rɔ’ne. ");
INSERT INTO gqr_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Kin ə re de ingə nyamajɨ’gɨ kɨ dɔnangɨ’tɨ ne pətɨ tigə, nan ndil’ə tujɨ, ə maj’a to ra be wa? ");
INSERT INTO gqr_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Nya madɨ kɨ de a adɨ ɔr’n tor ndil’ne to non wa? ");
INSERT INTO gqr_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Tokɨ rɔta’tɨ, re rɔ de madɨ sɔl’ɔ tadɔ lə’m, eke tadɔ ta lə’m takum de’gɨ’tɨ kɨ nje ra kaya kɨ njeramajel kɨ dɔkagilo’tɨ kin, m’in Ngonn de m’a m’ra rɔsɔl dɔ’a’tɨ tɔ, ndɔ’a’tɨ kɨ m’a m’re’n me tɔjɨ’tɨ lə Bai, nan’tɨ kɨ malayka’gɨ kɨ ari njay.» ");
INSERT INTO gqr_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jeju el’de ɓay ene: «Tokɨ rɔta’tɨ adɨ m’el’se: De’gɨ madɨ dann’se’tɨ ne, a oyi el ɓay ə, a oyi Konɓe lə Luwə kɨ a re kɨ tɔgɨ’ne kam taa.» ");
INSERT INTO gqr_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ndɔ mehen go’tɨ, ningə Jeju ɔr Piyər num, Jakɨ num, taa Jan num tɔ, ə al aw se’de dɔ mbal’tɨ kɨ ngal, kɨ kar’de ba, sanyi kɨ ndəgə’gɨ. Low’ə’tɨ kin non, Jeju mbəl takum’ne. ");
INSERT INTO gqr_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ku’gɨ li’ə ndoloi kənyi kənyi, taa ndai nda kɨ de kɨ dɔnangɨ’tɨ ne kɨ kadɨ a togɨ ku adɨ nda be goto. ");
INSERT INTO gqr_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ningə lo kin’tɨ non, Eli in kɨ Mojɨ tei kɨ rɔ’de’tɨ bus, isɨ elita kɨ Jeju. ");
INSERT INTO gqr_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ə Piyər un ta el Jeju ene: «Njendo de’gɨ, kin ə j’isi lo kin’tɨ ne be par ə majɨ ngayn. J’a ra *kəyku’gɨ lo mutə: kare in yan’i, kare in yan Mojɨ, ə kare in yan Eli tɔ.» ");
INSERT INTO gqr_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Tokɨ rɔta’tɨ, Piyər gər ta inɓe kɨ kadɨ el el, tadɔ, inɓe kɨ madɨ’ne’gɨ kɨ joo, ɓol ra’de ngayn. ");
INSERT INTO gqr_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ningə, tanan’tɨ non, kilndi re dow dɔ’de bigum. Ndu ta madɨ te me kilndi’tɨ ene: «In kam in Ngonn’m, m’ndig’ə ngayn, ə oyi ta li’ə.» ");
INSERT INTO gqr_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Kɨ kum kɨ kində jipɨ, njendo’gɨ gonyi lo gugɨ gidɨ’de, nan de kare kaa oyi’ə el. Jeju kɨ kar’ne ba par ə oyi’ə rɔ’de’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Lokɨ in dɔ mbal’tɨ isɨ uri nanga ningə, Jeju ndəjɨ’de kadɨ ɔri poy nya kɨ ra nya ə oyi kin de madɨ el, bitɨ kadɨ n’in Ngonn de n’te dann njekoy’gɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Njendo’gɨ təli rɔ’de go ta’tɨ kɨ Jeju el’de, nan k’in ə, gəri me ta kɨ nan: «Kində taa dann njekoy’gɨ’tɨ» kin el, adɨ manjɨ nan ta dɔ’tɨ dann’de’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Go’tɨ, njendo’gɨ dəji’ə eyina: «Tadɔ ri ə njendo ndukun’gɨ lə Luwə eyina majɨ kadɨ Eli re kete ta wa?» ");
INSERT INTO gqr_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jeju ilə’de’tɨ ene: «In rɔta’tɨ kadɨ Eli a re kete ɓay taa, kadɨ ra go nya’gɨ adɨ asɨ nan gogɨ. Nga ra bann ə, ndangi me makitu’tɨ lə Luwə, sɔw dɔ’m m’in “Ngonn de ɓay tokɨ m’a m’ingə kon ngayn, ta de’gɨ a kidi m’in tɔ” ə? ");
INSERT INTO gqr_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Tokɨ rɔta’tɨ adɨ m’el’se madɨ oyi, Eli re, ə de’gɨ rai si’ə nya kɨ me’de ge, tokɨ ndangi me makitu’tɨ sɔw’n dɔ’a.» ");
INSERT INTO gqr_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Lokɨ təli rei rɔ njendo’gɨ’tɨ ningə, oyi bulə de’gɨ iləi nan gugi dɔ’de gugɨ, ningə njendo ndukun’gɨ ə isɨ manjinan ta’tɨ se’de tɔ. ");
INSERT INTO gqr_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Lokɨ bulə de’gɨ oyi Jeju, ningə ndɔjɨ’de ngayn, adɨ anyinan bur bur kɨ rɔ’a’tɨ, uwəi ji’ə rai’ə lapiya. ");
INSERT INTO gqr_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jeju dəjɨ njendo’gɨ lə’ne ene: «Ta ri ə isɨ manjinan ta dɔ’tɨ se’de wa?» ");
INSERT INTO gqr_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","De madɨ kare dann bulə de’gɨ’tɨ el’ə ene: «Njendo de’gɨ, kete m’re kɨ ngonn’m rɔ’i’tɨ, tadɔ in ginn tɔgɨ’tɨ lə ndil kɨ ra’a adɨ elta el. ");
INSERT INTO gqr_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Lo’gɨ pətɨ kɨ ndil kin in si’ə’tɨ ningə, ugə ilə nanga, adɨ pulum taa uwə jugɨ jugɨ, ngor ngangɨ’ne guru guru, ningə ndaj’a ranyi, ad’a to to kagɨ be. Be ə, m’dəjɨ njendo’gɨ lə’i kadɨ tuwəi ndil kɨ majel kin dɔ’a’tɨ kɔ, nan ingəi tɔgɨ ra’a el.» ");
INSERT INTO gqr_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Lo kin’tɨ Jeju un ta el ene: «In de’gɨ kɨ dɔkagilo’tɨ kɨ ɓone in nje me ngan kadɨ to m’njɨ sese kagilo bann taa uni me’se adi m’in wa? Kadɨ m’a m’ɔsɨ ginn’se kagilo bann ɓay taa wa? In rei si’ə rɔ’m’tɨ ne.» ");
INSERT INTO gqr_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Lokɨ rei kɨ ngonn rɔ’a’tɨ ningə, tanan’tɨ non inɓe kɨ ndil kɨ majel oo Jeju par ə, dadɨ ngonn kakin nangɨ nangɨ, ə mann taa in pulum jugɨ jugɨ, ningə bi’ə ilə nanga, ad’a nduguru nanga. ");
INSERT INTO gqr_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jeju dəjɨ Baw’a ene: «Dɔkagilo kɨ ra’a’tɨ ə nya kin ulə si’ə ngirə wa?» Baw ngonn ilə’tɨ ene: «Ulə ngirə lokɨ ngonn to du ba ɓay. ");
INSERT INTO gqr_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ningə, kagilo’gɨ madɨ ndil kɨ majel kin, isɨ sur’ə tilə por’o ge kɨ me mann’tɨ ge kadɨ tɔl’ɔ, ə re asɨ ra nya madɨ ə, oo kumtondoo lə’je, in ra se’je.» ");
INSERT INTO gqr_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jeju təl el’ə ene: «Re asɨ! … kin tadɔ ri wa? De kɨ un me’ne, asɨ ra nya’gɨ pətɨ.» ");
INSERT INTO gqr_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Tanan’tɨ non, baw ngonn elta kɨ ndu’ne kibo ene: «M’un me’m, nan kunme lə’m ə in ngayn el, ə in ra sə’m!» ");
INSERT INTO gqr_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Lokɨ Jeju oo kadɨ bulə de’gɨ isɨ anyinan bur bur kɨ rɔ’a’tɨ ningə, ndangɨ ndil kɨ majel ene: «In ndil kɨ majel kɨ nje boy mbi de’gɨ kɨ nje kadɨ de’gɨ elita el, m’un ndu’m kadɨ in te rɔ ngonn’tɨ kin kɔ, ə re gogɨ el ratata!» ");
INSERT INTO gqr_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ndil kɨ majel kakin ur kɔl, ra ngonn adɨ dadɨ nangɨ! nangɨ! kɨ tɔgɨ’ne ngayn, ningə te rɔ’a’tɨ kɔ. Ngonn təl to tokɨ oy be, adɨ de’gɨ pətɨ kɨ oyi nya kɨ ra nya eli eyina: «Oy nga.» ");
INSERT INTO gqr_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Nan Jeju uwə ji ngonn un’ə ur’ə taa. ");
INSERT INTO gqr_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Lokɨ Jeju təl re ɓe ə, njendo’gɨ li’ə sii si’ə kɨ kar’de ba, dəji’ə eyina: «Tadɔ ri ə kete j’in j’asɨ kadɨ jɨ tuwə ndil kin el wa?» ");
INSERT INTO gqr_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jeju təl el’de ene: «Ko ndil’gɨ kɨ be kin, de a tuwə’de kɨ takul kelta kɨ Luwə ta.» ");
INSERT INTO gqr_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ɔti low’ə’tɨ non ningə, indəi dɔnangɨ Galile gangi. Jeju ge kadɨ de madɨ gər go’ne el. ");
INSERT INTO gqr_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Tadɔ un dɔkagilo kadɨ ndo’n nya njendo’gɨ lə’ne. Be ə el’de ene: «A uləi m’in m’in Ngonn de ji de’gɨ’tɨ kadɨ a tɔli m’in, ningə lokɨ tɔli m’in, ndɔ kɨ kon mutə tum ginn’ə ndɔ koy’m’tɨ ə, m’a te lo koy’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Njendo’gɨ gəri me ta li’ə kin el, ningə ɓoli kadɨ dəji’ə ta dɔ’tɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Lokɨ rei tei me ɓe’tɨ kɨ Kapernayim, ə uri me kəy’tɨ ningə, Jeju un ta dəjɨ’de ene: «Ta ri ə kete isɨ manjinan ta dɔ’tɨ dɔ row’tɨ wa?» ");
INSERT INTO gqr_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Nan təli sii keke, tadɔ, dɔ row’tɨ, manjinan ta, kadɨ n’gəri ke nan ə in kibo wa? ");
INSERT INTO gqr_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jeju isɨ nanga, ningə ɓar njendo’gɨ lə’ne kɨ dɔgɨ gidə in joo, el’de ene: «Re de madɨ ge kadɨ n’in de kɨ dɔkete ningə, majɨ kadɨ təl rɔ’ne dɔboy de’gɨ’tɨ num, nje ra kuləɓər kadɨ ndəgə’gɨ pətɨ num tɔ.» ");
INSERT INTO gqr_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Go’tɨ, Jeju un ngonn kɨ du, ur’ə dann’de’tɨ, ə lokɨ uwə rɔ’ne’tɨ ningə, el’de ene: ");
INSERT INTO gqr_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«Re de madɨ uwə ngonn kɨ be kin rɔ’ne’tɨ me tɔ’m’tɨ ningə, in m’inɓe ə de’ə kin uwə’m rɔ’ne’tɨ. Ningə, de kɨ uwə’m kɨ rɔ’ne’tɨ, in m’in ə uwə’m kɨ rɔ’ne’tɨ el, nan in njekulə’m ə uwə kɨ rɔ’ne’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jan el Jeju ene: «Njendo de’gɨ, j’oo de madɨ kɨ ra tuwə ndil’gɨ kɨ majel me tɔ’i’tɨ, ningə jɨ ndigɨ kadɨ j’ɔg’ɔ dɔ ra nya kin, tadɔ in njiyə se’je go’i’tɨ el.» ");
INSERT INTO gqr_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jeju ilə’de’tɨ ene: «Ononyi’se kadɨ ɔgi’ə dɔ, tadɔ de kare kɨ a ra nya kɨ ətɨ ɓol me tɔ’m’tɨ kɨ kadɨ a təl kalangɨ ba elta kɨ majel dɔ tɔ’m’tɨ goto. ");
INSERT INTO gqr_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Tokɨ rɔta’tɨ, de kɨ ɔsɨ’je ta el in de lə’je. ");
INSERT INTO gqr_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Taa re de madɨ adɨ mann kanyi me ngonn kala mann’tɨ par, tadɔ kin kɨ in de’gɨ lə Kirisitɨ kaa, tokɨ rɔta’tɨ, de’ə kin a nal nyakugə goji lə’ne el. ");
INSERT INTO gqr_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","«Kin ə tokɨ de madɨ ra adɨ kɨ kare dann nje kɨ du’tɨ kɨ uni me’de adɨ m’in, osɨ me majel’tɨ ə, in sotɨ ngayn ɓay tadɔ li’ə kadɨ dɔi mbal kibo ngayn mində’tɨ, ə iləi’ə me ba’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Kin ə ji’i rai adɨ osɨ me majel’tɨ ə, in gang’a ilə kɔ. Tadɔ, in sotɨ kadɨ ingə kajɨ kɨ ji’i kɨ kare, utə kadɨ in ngəm ji’i’gɨ joo pətɨ, ə iləi’nu me por’tɨ kɨ bitɨ kɨ non’tɨ, me por’tɨ kɨ a oy el ratata kin.  ");
INSERT INTO gqr_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Lo kɨ kur kɨ nje kində de’gɨ yəngɨ yəngɨ oy’tɨ el num taa por kaa oy’tɨ el num tɔ. ");
INSERT INTO gqr_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Kin ə nja’i kare rai adɨ osɨ majel’tɨ ə, in gang’a ilə kɔ. Tadɔ, in sotɨ kadɨ ingə kajɨ kɨ nja’i kɨ kare, utə kadɨ in ngəm nja’i’gɨ joo pətɨ, ə iləi’nu me dilə por’tɨ kɨ bitɨ kɨ non’tɨ.  ");
INSERT INTO gqr_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Lo kɨ kur kɨ nje kində de’gɨ yəngɨ yəngɨ oy’tɨ el num taa por kaa oy’tɨ el num tɔ. ");
INSERT INTO gqr_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Kin ə kum’i kare rai adɨ osɨ me majel’tɨ ə, ɔr’ɔ kɔ. Tadɔ, in sotɨ kadɨ ur Konɓe’tɨ lə Luwə kɨ kum’i kɨ kare, utə kadɨ in ngəm kum’i joo pətɨ, ə iləi’nu me por’tɨ kɨ bitɨ kɨ non’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Lo’tɨ kɨ kode’gɨ oyi el, ta por kɨ səm’tɨ kaa oy el ratata tɔ. ");
INSERT INTO gqr_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Tokɨ rɔta’tɨ, de kɨ ra kaa por kon’gɨ a ra’a adɨ ar njay, tokɨ katɨ a ra’n nyakusɔ adɨ nəl be. ");
INSERT INTO gqr_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Katɨ in nya kɨ majɨ, nan lokɨ nəl’ə goto ə, ri ə a rai kadɨ a təl nəl gogɨ wa? Nya kɨ kadɨ de a ra’n goto. Ningə majɨ kadɨ tɔji hal kɨ majɨ kɨ rɔ nan’tɨ, ə sii kɨ nan kɨ lapiya dann’se’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jeju in low’ə’tɨ non aw dɔnangɨ Jude’tɨ, gidɨ ba Jurden’tɨ. Bulə de’gɨ kawinan gugi gidə gugɨ ɓay. Kɨ go jibəl ra’a’tɨ lə Jeju, ulə ngirə ndo’de nya. ");
INSERT INTO gqr_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Parisɨ’gɨ madɨ ɔti rei rɔ Jeju’tɨ, ningə kadɨ to iyəi kulə uwəi’ə’n’ə me ta’tɨ, dəji’ə eyina: «Ndukun lə’je adɨ tarow kadɨ dingəm tuwə’n ne’ne eke adɨ tarow el wa?» ");
INSERT INTO gqr_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jeju dəjɨ’de ene: «Ndukun ri ə Mojɨ adɨ’se dɔ’tɨ wa?» ");
INSERT INTO gqr_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ingɨ təli eli’ə eyina: «Mojɨ ndɔkɨ adɨ tarow kadɨ dingəm tuwə ne’ne, nan k’in ə, kadɨ ad’a makitu gangɨ nan ji’ə’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jeju təl el’de ene: «In tadɔ me ngan lə’se ə Mojɨ ndangɨ’n mbərkikində kin adɨ’se. ");
INSERT INTO gqr_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Nan lo kulə ngirə kində nya’gɨ’tɨ, Luwə ra dingəm kɨ dene. ");
INSERT INTO gqr_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","In be ə, dingəm a inyə baw’ne kɨ kon’ne, ningə a tinyəi nan kɨ ne’ne, ");
INSERT INTO gqr_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","təli darɔ kɨ kare. Lo kin’tɨ a in joo el nga, nan a in darɔ kɨ kareba. ");
INSERT INTO gqr_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ningə nya kɨ Luwə dɔɔ nan’tɨ, majɨ kadɨ de gangɨ nan’tɨ el.» ");
INSERT INTO gqr_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Lokɨ təli rei ɓe, njendo’gɨ li’ə dəji’ə ta dɔ’tɨ ɓay. ");
INSERT INTO gqr_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ə Jeju el’de ene: «Re de tuwə ne’ne, ə ta in kɨ rangɨ, in njekuwə marum par kɨ rɔ ne’ne’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","A re in dene ə mbətɨ ngaw’ne ə ta dingəm kɨ rangɨ kaa, in njekuwə marum tɔ.» ");
INSERT INTO gqr_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","De’gɨ rei kɨ ngann’gɨ kɨ du rɔ Jeju’tɨ kadɨ njangɨ dɔ’de, nan njendo’gɨ ndangi’de. ");
INSERT INTO gqr_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Lokɨ Jeju oo kuləra njendo’gɨ lə’ne ningə, nəl’ə el adɨ el’de ene: «Inyəi ngann’gɨ kɨ du adɨ rei rɔ’m’tɨ, ononyi’se kadɨ ɔgi’de tarow, tadɔ Konɓe lə Luwə in yan de’gɨ kɨ toi to ngann’gɨ kɨ du be. ");
INSERT INTO gqr_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Tokɨ rɔta’tɨ, adɨ m’el’se, de kɨ ndigɨ kadɨ Luwə onɓe dɔ’a’tɨ to ngonn kɨ du be el ə, a ur konɓe’tɨ lə Luwə el ratata.» ");
INSERT INTO gqr_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Go’tɨ, Jeju ɔy ngann’gɨ kɨ du kadɨ’ne’tɨ, ində ji’ne dɔ’de’tɨ, ə njangɨ dɔ’de. ");
INSERT INTO gqr_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Lokɨ Jeju ɔtɨ osɨ dɔ row’tɨ ningə, dingəm madɨ kare anyi re osɨ nanga ɔsi məkəsi’ne non’a’tɨ, dəj’ə ene: «Njendo kɨ nje hal kɨ majɨ, in ri ə m’a m’ra ə m’a m’ingə’n kajɨ kɨ to bitɨ kɨ non’tɨ wa?» ");
INSERT INTO gqr_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jeju el’ə ene: «Tadɔ ri ə ɓarɨ’m de kɨ majɨ wa? De kare kɨ majɨ goto, nan Luwə kɨ kar’ne ba par ə in de kɨ majɨ. ");
INSERT INTO gqr_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","In gər mbərkikində’gɨ lə Luwə kɨ ene: “A tɔl de el, a uwə marum el, a ɓogɨ el, a mannajɨ kɨ ngom dɔ mad’i’tɨ el, a ra nya kɨ majel kɨ de madɨ el, ɔsɨ kurə baw’i kɨ kon’i.”» ");
INSERT INTO gqr_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Dingəm kakin el’ə ene: «Njendo, m’ra nya’gɨ kin pətɨ, m’təl rɔ’m go’tɨ lo kulə ngirə basa’m’tɨ nu.» ");
INSERT INTO gqr_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jeju gon dingəm kakin kɨ rɔnel, ningə el’ə ene: «Nya kare be ə nanyi kadɨ in ra. Aw, adɨ ndogi sə’i nya majɨ’gɨ lə’i pətɨ, lowə nar’a njendoo’gɨ, ningə a aw kɨ nyakingə ngayn me dɔran’tɨ, ə un go’m.» ");
INSERT INTO gqr_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Nan lokɨ dingəm kakin oo ta’gɨ kin ningə, kum’ə diw kururu, ə ɔtɨ aw kɨ rɔnel el, tadɔ in de kɨ aw kɨ nyakingə ngayn. ");
INSERT INTO gqr_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jeju gon lo gugɨ dɔ’ne ningə el njendo’gɨ lə’ne ene: «A in nya kɨ ngan ngayn rɔ nje nyakingə’tɨ kadɨ ur me Konɓe lə Luwə!» ");
INSERT INTO gqr_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ta lə Jeju kin ndɔjɨ’de, nan Jeju ra dɔ’tɨ gərərə ba ene: «Ngann’m’gɨ, in nya kɨ ngan ngayn kadɨ de ur Konɓe’tɨ lə Luwə. ");
INSERT INTO gqr_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","In nya kɨ ngan ngayn kadɨ jambal ur bolo konn kur nya’tɨ, nan a ngan ngayn utə in kin ɓay kadɨ njenyakingə ur me Konɓe’tɨ lə Luwə.» ");
INSERT INTO gqr_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ta kin, ətɨ’de ɓol dɔ mad’a’tɨ ɓay, adɨ dəji nan dann’de’tɨ eyina: «Nga kin ə in be ningə, nan ə asɨ kadɨ ingə kajɨ wa?» ");
INSERT INTO gqr_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jeju ində manjɨ’de ba ningə el’de ene: «Kɨ rɔ de’gɨ’tɨ lowə goto, nan kɨ rɔ Luwə’tɨ, lo ra’a to. Tadɔ kɨ rɔ Luwə’tɨ lo ra nya’gɨ pətɨ to.» ");
INSERT INTO gqr_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Piyər ilə rɔ’ne el’ə ene: «Nga oo, j’in kɨ j’inyəi nya’gɨ lə’je pətɨ kɔ, ə j’un go’i kin.» ");
INSERT INTO gqr_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jeju ilə’tɨ ene: «Tokɨ rɔta’tɨ adɨ, m’el’se, re de madɨ, inyə kəy lə’ne, konnann’gɨ kɨ ngannkon’ne’gɨ, kon’ne kɨ baw’ne, ngann’ne’gɨ eke dɔnangɨ lə’ne tadɔ lə’m, tadɔ Poyta kɨ majɨ ningə, ");
INSERT INTO gqr_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","de’ə kin, kagilo kɨ ɓone, a ingə kəy’gɨ, konnann’gɨ kɨ ngannkon’gɨ, kon’gɨ, ngann’gɨ, kɨ lo ndɔɔ nja ɓu dɔ’tɨ, nan’tɨ kɨ kindəkumndoo dɔkagilo’tɨ kɨ ɓone, ta dɔkagilo’tɨ kɨ a re, a ingə kajɨ kɨ to bitɨ kɨ non’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Nga ningə, de’gɨ ngayn kɨ kete, a təli kɨ gogɨ, ə de’gɨ ngayn kɨ gogɨ, a təli kɨ kete tɔ.» ");
INSERT INTO gqr_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jeju in kɨ njendo’gɨ lə’ne in dɔ row’tɨ isɨ awi kɨ Jerujalem’tɨ. Jeju njiyə non’de’tɨ non’de’tɨ. Lo kin’tɨ ɓol ra njendo’gɨ li’ə ngayn, taa nje njiyə go’de’tɨ kaa ɓol ra’de tɔ. Jeju təl ɓar njendo’gɨ kɨ dɔgɨ gidə in joo rɔ’ne’tɨ, ningə ulə ngirə kadɨ el’de nya’gɨ kɨ a ra’a Jerujalem’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","«Oyi, j’isi j’awi kɨ Jerujalem, ningə a uləi m’in m’in Ngonn de jɨ kibo’gɨ lə njekujənyamosɨ kadikare’gɨ kɨ njendo ndukun’gɨ. A gangɨ ta koy dɔ’m’tɨ ningə go’tɨ, a uləi m’in jɨ de’gɨ kɨ in Juwipɨ’gɨ el. ");
INSERT INTO gqr_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","A kogi dɔ’a’tɨ num, a tuwi mann ta’de kum’ə’tɨ num, a tindəi’ə num, ningə a tɔli’ə tɔ. Nan ndɔ mutə go’tɨ ə a ində taa lo koy’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Go ta’gɨ’tɨ kin ningə, ngann lə Jebede, Jakɨ in kɨ Jan rei rɔ Jeju’tɨ ndəkba, eli’ə eyina: «Njendo, jɨ ndigɨ kadɨ in ra nya kɨ j’aw to dəj’i kam adi’je.» ");
INSERT INTO gqr_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jeju dəjɨ’de ene: «Ri ə in gei kadɨ m’ra madɨ’se wa?» ");
INSERT INTO gqr_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ningə, təli eli’ə eyina: «Re in ndigɨ dɔ’tɨ se’je ə, adɨ de kare isɨ dɔjikɔl’i’tɨ, ə in kɨ nungɨ isɨ dɔjigəl’i’tɨ tɔ, lokɨ a isɨ dɔ konɓe’tɨ ə de’gɨ a uləi tɔjɨ dɔ’i’tɨ kin.» ");
INSERT INTO gqr_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jeju el’de ene: «In gəri me nya dəjɨ lə’se kin el. Adɨ a asi kadɨ ingəi batəm kon kɨ m’aw to m’ingə kam kare mindɨ wa? Taa, kɔpɨ kɨ to kon ngayn kɨ m’aw to m’ingə kam a ingəi kare tɔ wa?» ");
INSERT INTO gqr_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ningə eli eyina: «Oyo, j’a j’asɨ kare.» Ə Jeju el’de ene: «Tokɨ rɔta’tɨ, a ingəi kon kɨ m’aw to m’ingə kam kare, taa batəm kɨ to kon ngayn kɨ m’aw to m’ingə kam a ingəi kare tɔ. ");
INSERT INTO gqr_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Nan ta kɨ ɔjidɔ kisi dɔjikɔl’m’tɨ eke dɔjigəl’m’tɨ; in ta lə’m kadɨ m’in ə madɨ’se el; lo’gɨ kin to tadɔ de’gɨ kɨ rai go’ə kete nu tadɔ lə’de.» ");
INSERT INTO gqr_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Lokɨ ndəgɨ njendo’gɨ kɨ dɔgɨ oyi ta’gɨ kin ningə, rɔ’de nəl’de kɨ Jakɨ in kɨ Jan el. ");
INSERT INTO gqr_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Be ə, Jeju ɓar’de pətɨ kɨ rɔ’ne’tɨ, el’de ene: «In gəri kadɨ nje’gɨ kɨ indəi’de to nje konɓe’gɨ dɔ ginn de’gɨ’tɨ kɨ dangɨ dangɨ kɨ dɔnangɨ’tɨ ne, sii uwəi’de ginn tɔgɨ’de’tɨ adi’de kon, taa de’gɨ kɨ njetɔɓar kaa, onyiɓe dɔ’de’tɨ ɓay tɔ. ");
INSERT INTO gqr_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Nan majɨ kadɨ to be dann’se’tɨ el. Re de madɨ dann’se’tɨ, ndigɨ kadɨ n’in kibo ningə, kadɨ təl nje ra kulə lə’se pətɨ. ");
INSERT INTO gqr_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Taa re de madɨ ndigɨ kadɨ n’in de kɨ dɔkete dann’se’tɨ ningə, kadɨ təl njekuləɓər lə’se pətɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Tadɔ m’in Ngonn de kin, m’re kadɨ de’gɨ taa, rai kulə adi m’in el, nan kadɨ m’in ə m’ra kulə m’adɨ’de num taa m’adɨ rɔ’m kadɨ m’ugə’n dɔ bulə de’gɨ ngayn m’ilə’de taa num tɔ.» ");
INSERT INTO gqr_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jeju in kɨ njendo’gɨ lə’ne rei tei Jeriko’tɨ. Lokɨ isɨ tei me ɓebo’tɨ kɨ taga kɨ bulə de’gɨ ngayn go’de’tɨ. Njekumtɔ kare kɨ tɔ’a nan Bartime, in ngonn lə Time, isɨ ngangɨ row’tɨ non isɨ kɔy nya. ");
INSERT INTO gqr_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Lokɨ oo kadɨ in Jeju kɨ Najaretɨ’tɨ, ə isɨ ində dər ningə, un ndu’ne kɨ taa non ene: «Jeju kɨ Ngonnkaw Dabidɨ, oo kumtondoo lə’m.» ");
INSERT INTO gqr_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","De’gɨ ngayn ndangi’ə kadɨ utɨ ta’ne, nan njekumtɔ un ndu’ne kɨ taa inɓe ɓay ene: «Ngonnkaw Dabidɨ, oo kumtondoo lə’m!» ");
INSERT INTO gqr_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Lo kin’tɨ Jeju ra lokatɨ, ene: «Ɓari’ə adi’m’in.» Ningə ɓari njekumtɔ kakin, ə eli’ə eyina: «Uwə rɔ’i ba, ində taa, nan isɨ ɓar’i.» ");
INSERT INTO gqr_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Lokɨ oo dɔ ta’gɨ kin ningə, bi ku lə’ne ilə kɔ, ə ində ratɨ aw rɔ Jeju’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jeju dəj’ə ene: «Ri ə, ge kadɨ m’ra mad’i wa?» Njekumtɔ ilə’tɨ ene: «Njendo, m’ge kadɨ kum oo lo!» ");
INSERT INTO gqr_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ə Jeju el’ə ene: «Aw! tadɔ kunme lə’i aj’i nga». Par ə, tanan’tɨ non kum’ə oo lo, adɨ un go Jeju dɔ row njiyə’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jeju in kɨ njendo’gɨ lə’ne indəi dɔ ɓe kɨ Jerujalem ndəkba, gidɨ ngann ɓe’gɨ’tɨ kɨ Betipaje kɨ Betani, kɨ kaw kadɨ mbal kagɨ buni’gɨ’tɨ. Jeju ulə njendo’gɨ lə’ne joo. ");
INSERT INTO gqr_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Jeju el’de ene: «Awi me ngonn ɓe’tɨ kɨ ra non’se’tɨ kam. Lo kur inɓe kɨ a uri kɨ me ɓe’tɨ par ə, a ingəi ngonn koro kɨ dɔi’ə adɨ ra. In ngonn koro kɨ de ala gidə’tɨ nja kare el ɓay. Tuti’ə, in rei si’ə adi’m’in. ");
INSERT INTO gqr_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","A re de madɨ dəjɨ’se ene: “Tadɔ ri ə ra rai nya be wa?” Ə eli’ə eyina: “Burəɓe ə ge’ə, ə a təl ulə si’ə ne be kalangɨ ba.”» ");
INSERT INTO gqr_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Njendo’gɨ awi ningə nyɨ ingəi ngonn koro kɨ de dɔ’a taga takəy’tɨ, kadɨ row’tɨ. Adɨ tuti’ə. ");
INSERT INTO gqr_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","De’gɨ madɨ kɨ oyi’de lo tutɨ koro’tɨ dəji’de eyina: «In ri ə ra rai be wa? Tuti ngonn koro kin tadɔ ri wa?» ");
INSERT INTO gqr_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ningə njendo’gɨ iləi’de’tɨ tokɨ Jeju el’n’de, ə inyə’de adɨ rai. ");
INSERT INTO gqr_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Lokɨ rei kɨ ngonn koro kakin ningə, lɔwi ku’gɨ lə’de gidə’tɨ adɨ Jeju ala isɨ dɔ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","De’gɨ ngayn lɔwi ku’gɨ lə’de go row’tɨ. Nje kɨ nan’gɨ in mbikam’gɨ kɨ mu ə tətɨ tiləi. ");
INSERT INTO gqr_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Nje njiyə non Jeju’tɨ kɨ nje njiyə go’ə’tɨ uni ndu’de kɨ taa eyina: «Ojana! Ningə kadɨ Luwə njangɨ dɔ de kɨ re me tɔ Burəɓe’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Kadɨ Luwə njangɨ dɔ konɓe kɨ a re, adɨ in konɓe lə kaw’je Dabidɨ. Ojana, njangɨ dɔ in kɨ dɔ Nje kisɨ dɔran’tɨ taa.» ");
INSERT INTO gqr_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jeju ur Jerujalem’tɨ, aw me Kəy’tɨ lə Luwə. Lokɨ ində kum’ne oo nya’gɨ pətɨ kɨ gugɨ gidə ningə, in kɨ njendo’gɨ lə’ne kɨ dɔgɨ gidə in joo tei awi Betani’tɨ, tadɔ lo sɔl nga. ");
INSERT INTO gqr_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Lokɨ lo ti go’tɨ, te’de Betani’tɨ kɨ taga, ɓo ra Jeju. ");
INSERT INTO gqr_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ningə oo kagɨ mbaykote kɨ mbi’ə to dɔ’tɨ sanyi nu, ningə ɔtɨ aw ginn’tɨ kadɨ n’oo ke n’a ningə kanda dɔ’tɨ kadɨ n’usɔ wa? Nan lokɨ re ndəkba rɔ kagɨ’tɨ ningə, oo mbi’ə’gɨ par, um de oo kand’a el, tadɔ in nanyi kandɨ mbaykote el ɓay. ");
INSERT INTO gqr_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Be ə Jeju el kagɨ mbaykote ene: «Kadɨ de sɔ kand’i gogɨ el bitɨ kɨ non’tɨ.» Njendo’gɨ li’ə oyi ndu ta kɨ el. ");
INSERT INTO gqr_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Təli rei tei Jerujalem’tɨ, natɨ Kəy’tɨ lə Luwə, ningə ilə rɔ’ne tuwə njelaw nya’gɨ kɨ njendo’gɨ nya’gɨ natɨ Kəy’tɨ lə Luwə kɔ. Jeju sur tabilə’gɨ lə njembəl nar kɨ ɓe’ne kɨ nje kɨ dɔɓe’gɨ’tɨ tilə, nan’tɨ kɨ nya kisɨ lə njelaw dər dum’gɨ. ");
INSERT INTO gqr_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Inyə de madɨ adɨ un nya re’n me Kəy’tɨ lə Luwə el. ");
INSERT INTO gqr_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ningə ndo’de nya ene: «Ke ndangi me makitu’tɨ lə Luwə eyina: Kəy lə’m a ɓari’ə kəy kelta kɨ Luwə kɨ to tadɔ ginn de’gɨ pətɨ el wa? Nan ingɨ, təli’ə lokiyərɔ’tɨ lə njeɓogɨ’gɨ yo.» ");
INSERT INTO gqr_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Lokɨ kibo’gɨ lə njekujənyamosɨ kadikare’gɨ kɨ njendo ndukun’gɨ oyi ta’gɨ kin ningə, sangi row kadɨ n’tɔli Jeju, nan ɓoli tadɔ bulə de’gɨ ndigi nyando li’ə ngayn. ");
INSERT INTO gqr_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Lokɨ lo sɔl ningə, Jeju in kɨ njendo’gɨ tei me ɓebo’tɨ taga. ");
INSERT INTO gqr_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Lokɨ lo ti kɨ sin, Jeju in kɨ njendo’gɨ isɨ indəi dər ningə, njendo’gɨ oyi kagɨ mbaykote kɨ tutɨ dɔ’a’tɨ ratata kɨ ngirə’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Low’ə’tɨ non, me Piyər olo dɔ nya’tɨ kɨ ndɔ kɨ ra nya, adɨ el Jeju ene: «Njendo kibo, oo kagɨ kɨ ndɔkɨ in mann’a kaa tutɨ am.» ");
INSERT INTO gqr_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ningə Jeju təl el’de ene: «Majɨ kadɨ, uni me’se adi Luwə. ");
INSERT INTO gqr_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Tokɨ rɔta’tɨ, adɨ m’el’se, re de un me’ne adɨ Luwə um tadɨ el, re un me’ne tokɨ nya kɨ dəjɨ kin a ra nya, re el mbal kam ene: “Ɔtɨ lo kin’tɨ rangɨ, aw osɨ me babo’tɨ,” Luwə a ra ad’a ");
INSERT INTO gqr_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","In be ə, m’el’se kadɨ in gəri tokɨ nya’gɨ pətɨ kɨ dəjɨ Luwə me kel si’ə ta’tɨ, majɨ kadɨ uni me’se tokɨ ingəi ə binəm, ningə Luwə a ra adɨ’se. ");
INSERT INTO gqr_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Lokɨ sii elita kɨ Luwə, re ta to dann’se’tɨ kɨ de madɨ ə, majɨ kadɨ inyəi go’ə kɔ adi’ə, kadɨ Baw’se kɨ isɨ dɔran’tɨ, inyə’n go majel’gɨ lə’se kɔ adɨ’se tɔ.  ");
INSERT INTO gqr_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Tadɔ, re inyəi go majel’gɨ lə de’gɨ kɨ rangɨ kɔ el ningə, Baw’se kɨ isɨ me dɔran’tɨ, a inyə go majel’gɨ lə’se kɔ el tɔ.» ");
INSERT INTO gqr_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jeju in kɨ njendo’gɨ lə’ne təli rei Jerujalem’tɨ ɓay. Lokɨ Jeju isɨ njiyə natɨ Kəy’tɨ lə Luwə, kibo’gɨ lə njekujənyamosɨ kadikare’gɨ kɨ njendo ndukun’gɨ lə Luwə kɨ ngatɔgɨ’gɨ, rei rɔ’a’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Rei dəji’ə eyina: «Nan adi tarow kadɨ ra’n nya’gɨ kin be wa? Ə nan tɔ ə adi ndu’ne kadɨ in ra’n’de wa el’je adɨ j’oo?» ");
INSERT INTO gqr_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jeju təl el’de ene: «M’a m’dəjɨ’se ta kare be par. Re iləi m’in’tɨ ningə m’a m’el’se de kɨ adɨ’m tarow kadɨ m’ra’n nya’gɨ kin tɔ. ");
INSERT INTO gqr_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Nan ə ulə Jan kadɨ ra de’gɨ batəm wa? In Luwə eke in de’gɨ wa eli m’in adɨ m’oo.» ");
INSERT INTO gqr_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Nan təli elinan ta dann’de’tɨ eyina: «Re j’eli’ə j’ene: “In Luwə ə ulə” ə a dəjɨ’je ene ke ra bann ə j’uni me’je j’adɨ Jan el wa? ");
INSERT INTO gqr_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ke j’a j’eli j’ene: In de’gɨ ə uləi Jan el tɔ.» Tokɨ rɔta’tɨ, ɓoli bulə de’gɨ tɔ, tadɔ de’gɨ pətɨ gəri dɔ’de’tɨ kadɨ Jan in njekeltakita Luwə’tɨ kɨ rɔta’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Be ə təli eli Jeju eyina: «Jɨ gər el.» Ə Jeju təl ilə’de’tɨ ene: «Re in be ə, m’in kaa m’a m’el’se tɔgɨ kɨ m’njɨ m’ra’n nya’gɨ kin el tɔ.» ");
INSERT INTO gqr_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Go’tɨ Jeju ilə rɔ’ne el’de ta kɨ kujita ene: «Dingəm kare uwə ndɔɔ nju, ningə ində singə gugɨ’n gidə gugɨ. Ur ɓe kadɨ to mborei nju’tɨ, ningə ra ngonn kəy ngəmlo səm’tɨ. Ningə dɔ’i tanan’tɨ kɨ de’gɨ kɨ nje ra kulə nju, kadɨ to rai kulə adi’ə, ə kagilo’ə’tɨ ningə a kanyi nan nya’a, ningə ɔtɨ aw. ");
INSERT INTO gqr_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Lokɨ kagilo kujə kandɨ nju asɨ ningə, ulə ɓər lə’ne kare kadɨ aw taa kandɨ nya ndɔɔ nju kakin, kɨ in yan’ne ji nje ra kulə nju’tɨ adi’ne. ");
INSERT INTO gqr_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Nan lokɨ ɓər aw ningə, nje ra kulə’gɨ uwəi’ə tindəi’ə ngayn, ə tuwəi’ə adɨ təl kɨ ji’ne kare. ");
INSERT INTO gqr_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Njendɔɔ təl ulə ɓər kɨ rangɨ ɓay. In kaa, tindəi dɔ’a mbukɨ mbukɨ ge, taji’ə ge tɔ. ");
INSERT INTO gqr_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Be kaa dingəm kakin təl ulə ɓər kɨ rangɨ ɓay. Ɓər kin uwəi’ə tɔli’ə, ta nje kɨ go’ə’tɨ kaa, tindəi kɨ madɨ, ə tɔli nje kɨ nungɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Lo kin’tɨ, ngonn’o kɨ dingəm kɨ ndig’ə ngayn, in par ə nanyi kɨ kar’ne ba ji’ə’tɨ. Un’ə ulə to dɔboy de rɔ’de’tɨ, ningə mərta me’ne’tɨ ene: “In kin in ngonn’m, adɨ a ɓoli gidə.” ");
INSERT INTO gqr_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Nan nje ra kulə nju kakin elinan dann’de’tɨ eyina: “Darɔ’a inɓe kam ə a in nje nya nduwə, ə adɨ jɨ tɔli’ə, ningə ndɔɔ nju a təl nya lə’je.” ");
INSERT INTO gqr_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","In be ə, uwəi ngonn kakin tɔli’ə, iləi ninn’ə gidɨ ndɔɔ’tɨ taga. ");
INSERT INTO gqr_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Lo’tɨ kin Jeju dəjɨ’de ene: Dingəm kɨ in nje ndɔɔ nju kin a ra bann wa? A re kadɨ tɔko nje ra kulə kin kɔ ə a ində nje kɨ rangɨ ta ndɔɔ nju’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ndɔ kare in tudəi ta kin me makitu’tɨ lə Luwə oyi el wa? “Mbal kɨ njera kəy’gɨ mbəti’ə, In ə təl mbal kɨ in tɔgɨ kəy. ");
INSERT INTO gqr_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","In kin in kuləra Burəɓe. In nyakɔjɨ kɨ ətɨ ɓol ə to takum’je’tɨ kin.”» ");
INSERT INTO gqr_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Lo kin’tɨ kibo’gɨ kɨ dɔ Juwipɨ’gɨ’tɨ sangi row kadɨ n’uwəi Jeju, tadɔ gəri majɨ kadɨ kujita kɨ Jeju el kin ɔjɨ dɔ’de, nan ɓoli bulə de’gɨ, adɨ inyəi’ə ə ɔti awi lo lə’de. ");
INSERT INTO gqr_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Kibo kɨ dɔ Juwipɨ’gɨ’tɨ uləi Parisɨ’gɨ madɨ kɨ de’gɨ kɨ kutɨ’tɨ lə Erodɨ’tɨ rɔ Jeju’tɨ kadɨ to n’iyəi kulə n’uwəi’ə’n’ə kɨ ta kɨ ta’a’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Rei eli’ə eyina: «Njendo, jɨ gər kadɨ in nje kelta kɨ rɔta’tɨ, ta in ɓol kum’de el num, in ɓol k’in kibo eke kətɨ ɓol lə de’gɨ el, in njendo de’gɨ row lə Luwə kigo’ə kɨ rɔta’tɨ. Ə el’je adɨ j’oo: In gorow’ə’tɨ eke in gorow’ə’tɨ el kadɨ de ugə lambo nje konɓe kibo Sejar wa? Kadɨ j’ugəi lambo eke j’ugəi el wa?» ");
INSERT INTO gqr_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Nan Jeju gər kadɨ in de’gɨ kɨ nje kelta ndar ta’de’tɨ ne, kɨ me’de’tɨ in dangɨ, adɨ el’de ene: «Tadɔ ri ə iyəi kulə kadɨ uwəi’m’in wa? Rei kɨ silə kare adi’m’in m’oo.» ");
INSERT INTO gqr_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Rei kɨ silə kare adi’ə, ningə dəjɨ’de ene: «Dɔ nan ə indəi, ə tɔ nan tɔ ə ndangi silə’tɨ kin wa?» Eli eyina: «In ngar Sejar.» ");
INSERT INTO gqr_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Jeju təl el’de ene: «Nya lə Sejar ə adi Sejar, nya lə Luwə ə adi Luwə tɔ.» Ta kɨ Jeju el’de ətɨ’de ɓol kɨ dum. ");
INSERT INTO gqr_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","*Sadusi’gɨ kɨ oyi kadɨ njekoy’gɨ a indəi taa lo koy’tɨ el, kɨ mad’i’gɨ dann’de’tɨ rei rɔ Jeju’tɨ dəji’ə eyina: ");
INSERT INTO gqr_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«Njendo, Mojɨ ndangɨ ndu kin me makitu’tɨ adi’je ene: “Re de madɨ, ngonnkon’a taa dene, ə ngonnkon’a kakin ojɨ ngonn kɨ dene kakin el ɓay ə oy ningə, kadɨ taa dene nduwə kin ojɨ’n ngann’gɨ kadɨ tei tor ngonnkon’a’tɨ.” ");
INSERT INTO gqr_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Kɨ ɔjidɔ ta kin, ngannkon nan’gɨ in siri, kɨ dɔkete ta dene, ningə ojɨ’n ngonn el ɓay ə oy. ");
INSERT INTO gqr_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Kɨ nja joo re ta dene nduwə kakin, ningə ojɨ si’ə ngonn el ɓay ə re oy kaa ɓay. Kɨ nja mutə re ə kah’a’tɨ inɓe kakin ɓay. ");
INSERT INTO gqr_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Adɨ ngannkon’a’gɨ kɨ siri kin, taai dene kɨ kare kin pətɨ tigə, kaa de kare kɨ dann’de’tɨ kɨ ojɨ si’ə ngonn ɓay ta oy goto. Go’de’tɨ pətɨ, darɔ dene inɓe re oy tɔ. ");
INSERT INTO gqr_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Eke ndɔ kɨ njekoy’gɨ a indəi taa lo koy’tɨ, nan dann’de’tɨ ə a in ngaw dene kin wa? Tadɔ in siri pətɨ taai dene kin ne’de’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jeju el’de ene: «In de’gɨ kɨ indəmi row, tadɔ in gəri Makitu lə Luwə el taa in gəri tɔgɨ lə Luwə el tɔ. ");
INSERT INTO gqr_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ndɔ kɨ njekoy’gɨ a indəi taa lo koy’tɨ, dingəm’gɨ kɨ dene’gɨ a taai nan el nga. Pətɨ a toi to malayka’gɨ be me dɔran’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ta kɨ ɔjidɔ kində kɨ njekoy’gɨ a indəi taa lo koy’tɨ, ke in tudəi ta me makitu’tɨ lə Mojɨ kin el wa? Kɨ ɔjidɔ por kɨ on me ngan’tɨ, ə in kɨ kelta’a me makitu’tɨ lə Mojɨ kin el wa? Kagilo’ə’tɨ kin, Luwə el Mojɨ ene: “M’in Luwə lə *Abiraham, lə *Isakɨ, kɨ lə Jakobɨ.” ");
INSERT INTO gqr_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Luwə in Luwə lə de’gɨ kɨ nje kisi kumngayira, um in Luwə lə njekoy’gɨ el. Indəmi row ndəm kɨ uri mu sulə.» ");
INSERT INTO gqr_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Njendo ndukun kare kɨ oo ndu’de lo manjinan ta’tɨ, lokɨ oo adɨ Jeju ilə ta Sadusi’gɨ’tɨ majɨ ngayn, ɔtɨ aw rɔ Jeju’tɨ dəj’ə ene: «Dann mbərkikində’gɨ’tɨ pətɨ, in kɨ ra ə in dɔ madɨ’ne’gɨ’tɨ wa?» ");
INSERT INTO gqr_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jeju el’ə ene: «Ndukun kɨ dɔkete kɨ utə ndukun’gɨ pətɨ ə to kin: “Oo *Isirayel! Burəɓe Luwə lə’je in Burəɓe kɨ in kar’ne ba. ");
INSERT INTO gqr_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","A in ndigɨ Burəɓe Luwə lə’i kɨ ngarme’i ba pətɨ, kɨ ndil’i ba pətɨ, kɨ mərta lə’i ba pətɨ, taa kɨ tɔgi ba pətɨ tɔ.” ");
INSERT INTO gqr_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ningə mbərkikində kɨ nja joo ə to kin: “A ndigɨ de mad’i to darɔ’i inɓe be tɔ.” *Ndukun kɨ rangɨ kɨ utə mbərkikində’gɨ kɨ joo kin goto.» ");
INSERT INTO gqr_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Njendo ndukun’gɨ lə Luwə el Jeju ene: «Majɨ ngayn Njendo! ta kɨ el in ta kɨ rɔta’tɨ: Burəɓe Luwə lə’je in kar’ne ba par ə in Luwə, Luwə kɨ rangɨ goto. ");
INSERT INTO gqr_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ningə, kadɨ de ndig’ə kɨ ngarme’ne ba pətɨ, kɨ mərta lə’ne ba pətɨ, taa kɨ tɔgɨ’ne ba pətɨ, ə kadɨ de ndigɨ de madɨ’ne to darɔ’ne inɓe be tɔ. In kin in sotɨ ngayn utə kujənyamosɨ kadikare’gɨ kɨ on row rakɨ num kujənyamosɨ kadikare’gɨ pətɨ kɨ kadɨ Luwə.» ");
INSERT INTO gqr_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Lokɨ Jeju oo kadɨ njendangɨ makitu kin ilə ta’tɨ kɨ kumkədɨ, ningə el’ə ene: «in sanyi el kɨ Konɓe lə Luwə.» Go ta’gɨ’tɨ kin, de kɨ rangɨ kare kɨ ɔjɨ me’ne’tɨ kadɨ n’dəjɨ ta Jeju ɓay goto nga. ");
INSERT INTO gqr_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Lokɨ Jeju isɨ ndo de’gɨ nya me Kəy’tɨ lə Luwə, dəjɨ’de ta ene: «Ra bann be ə njendo ndukun’gɨ lə Luwə eli eyina Kirisitɨ, De kɨ Luwə mbət’ə in ngonnkaw Dabidɨ wa? ");
INSERT INTO gqr_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Dabidɨ inɓe kɨ dɔ’ne, lokɨ Ndil Luwə ra kulə me’ə’tɨ, el ene: “Burəɓe Luwə el Burəɓe lə’m ene: ‹In re isɨ dɔjikɔl’m’tɨ ne, Bitɨ kadɨ m’təl njeban’gɨ lə’i nyakində nja’i’tɨ› ginn tɔg’i’tɨ.” ");
INSERT INTO gqr_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","«Dabidɨ inɓe kɨ dɔ’ne ɓar’a Burəɓe, nga kɨ gorow kɨ bann taa Kirisitɨ De kɨ Luwə mbət’ə in ngonnkaw Dabidɨ wa?» Bulə de’gɨ ngayn oyi ta lə Jeju kɨ rɔnel. ");
INSERT INTO gqr_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Me nyando’tɨ lə Jeju kɨ isɨ ndo bulə de’gɨ, el’de ene: «Indəi kumkədɨ dɔ rɔ’se’tɨ kɨ rɔ njendo ndukun’gɨ’tɨ. In de’gɨ kɨ gei njiyə kɨ ku ngal, taa gei kadɨ de’gɨ rai’de lapiya kɨ ɓukɨ nan’tɨ lo kingənan’gɨ’tɨ lə bulə de’gɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Me kəykawnan’tɨ lə Juwipɨ’gɨ, eke lo nyakusɔ’tɨ, a gei lo kisɨ kibo, kete non de’gɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Taai nyamajɨ’gɨ lə njengawkoy’gɨ pətɨ pətɨ ji’de’tɨ, ningə ədi kum de’gɨ kɨ kelta kɨ Luwə kɨ ginn’ə gangɨ el, kadɨ de’gɨ oyi’de tokɨ n’in de’gɨ kɨ majɨ. Go kulə ra’de’gɨ’tɨ kɨ be kin, Luwə a gangi’n ta kɨ ngan ngayn dɔ’de’tɨ utə ndəgɨ de’gɨ.» ");
INSERT INTO gqr_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jeju isɨ sɔw non lo kilə kadikare, isɨ oo kilə kɨ de’gɨ isɨ iləi kadikare. Njenyakingə’gɨ ngayn adi nar ngayn ngayn. ");
INSERT INTO gqr_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ningə njengawkoy kɨ njendoo kare re kɨ ngann silə joo, to nya kɨ te nya el ilə tɔ. ");
INSERT INTO gqr_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Adɨ Jeju ɓar njendo’gɨ lə’ne el’de ene: «M’el’se tokɨ rɔta’tɨ, njengawkoy kɨ njendoo kam re ilə kadikare utə ndəgɨ de’gɨ pətɨ. ");
INSERT INTO gqr_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Tadɔ ndəgɨ de’gɨ pətɨ adi bunə nar’gɨ lə’de, nan njengawkoy kin me ndoo’tɨ li’ə adɨ nyakingə kɨ me kəy’tɨ lə’ne ba pətɨ. In ə, ɓay nya kɨ nanyi ji’ə’tɨ kadɨ ra’n kɨ rɔ’ne ə un pətɨ adɨ kin.» ");
INSERT INTO gqr_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Lokɨ Jeju isɨ te me Kəy’tɨ lə Luwə kɨ taga, njendo li’ə kare el’ə ene: «Njendo, oo mbal’gɨ kɨ rai kəy, kɨ kəy’gɨ kɨ boi boi kɨ əti ɓol kɨ dum kam!» ");
INSERT INTO gqr_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jeju təl el’ə ene: «Oo kəy’gɨ kɨ boi boi kam majɨ, mbal kare kɨ a nanyi kadɨ isɨ dɔ mad’a’tɨ goto; a budi’de mur mur nanga.» ");
INSERT INTO gqr_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Go’tɨ, lokɨ Jeju aw isɨ dɔ mbal kagɨ buni’gɨ’tɨ, sɔw dɔ *Kəy lə Luwə. Piyər num, Jakɨ num, Jan num, Andire num, dəji’ə ta lokɨ in si’ə kɨ kar’de eyina: ");
INSERT INTO gqr_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«El’je adɨ joo, dɔkagilo kɨ ra’tɨ ə nya’gɨ kin a rai nya wa? Ə nyakɔjɨ kɨ bann ə a tɔjɨ kadɨ jɨ gəri’n tokɨ nya’gɨ kin pətɨ a indəi ngangɨ’de wa?» ");
INSERT INTO gqr_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Lo kin’tɨ Jeju ilə rɔ’ne el’de ene: «Indəi kumkədɨ dɔ rɔ’se’tɨ, adi de ədɨ’se el. ");
INSERT INTO gqr_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","De’gɨ ngayn a rei kɨ tɔ’m, a eli eyina: “M’in ə m’in Kirisitɨ”, ningə a ɓuki de’gɨ ngayn mu tɔ. ");
INSERT INTO gqr_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Lokɨ a oyi kah rɔ’gɨ kɨ in sese ndəkba kɨ poy rɔ’gɨ kɨ in sanyi, adi ɓol ra’se el. Kadɨ nya’gɨ kin a rei, nan a in dɔboy ndɔ el ɓay. ");
INSERT INTO gqr_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ginn ɓe madɨ a aw rɔ dɔ ginn ɓe madɨ’ne’tɨ, konɓe madɨ a aw rɔ dɔ konɓe madɨ’ne’tɨ. Dɔnangɨ a yəkɨ kɨ lo lo, ta ɓo a on kɨ lo pətɨ tɔ, nan nya’gɨ kin a toi to lo kulə ngirə to ndo kɨ a ra dene be. ");
INSERT INTO gqr_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Ningə kɨ ɔjɨ dɔ’se inɓe’gɨ, majɨ kadɨ sii dɔ nja’se’tɨ majɨ, tadɔ de’gɨ a awi sese lo gangi ta’gɨ’tɨ, a tindəi’se ginn kəykawnan’tɨ lə Juwipɨ’gɨ. A awi sese kadɨ rai non nje konɓe’gɨ’tɨ, kɨ non ngar’gɨ’tɨ kɨ boi tadɔ lə’m. Lokin’tɨ a in tarow kɨ te kadɨ a ingəi mannajɨ kɨ dɔ’m’tɨ kɨ rɔ’se’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Nga ningə, nya kɨ dɔkete, majɨ kadɨ Poyta kɨ majɨ osɨ mbi de’gɨ’tɨ kɨ dɔnangɨ’tɨ ne pətɨ. ");
INSERT INTO gqr_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Lokɨ a uwəi’se kadɨ a awi sese lo gangɨ ta’tɨ, ononyi’se kadɨ me’se ɓol, kene ke ta ri ə a eli non njegangita’gɨ’tɨ wa? Ta inɓe kɨ Luwə a ində ta’se’tɨ low’ə’tɨ non kin ə eli’de par. Tadɔ ingɨ ə a elita el, nan in Ndil Luwə ə a ində ta’se’tɨ kadɨ eli. ");
INSERT INTO gqr_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ngannkon nan’gɨ a uni dɔ nan awi lo tɔl nan’tɨ, baw ngonn a aw kɨ ngonn kadɨ tɔli’ə kɔ, ningə ngann’gɨ a ɔsi ta nje kojɨ’de’gɨ, ə a uni dɔ’de awi se’de kadɨ tɔli’de tɔ. ");
INSERT INTO gqr_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","De’gɨ pətɨ a ɔsi’se ta tadɔ lə’m, nan de kɨ uwə tɔgɨ’ne ba bitɨ dɔboy’tɨ a ingə kajɨ. ");
INSERT INTO gqr_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","«A oyi de kɨ Njeranyakɔw Njetujɨ lo, kɨ a in lo’tɨ kɨ majɨ kadɨ in’tɨ el. Majɨ kadɨ de kɨ nje tudə nya’gɨ kin gər ginn’ə majɨ. Ningə nje kɨ sii Jude’tɨ a anyinan kɨ dɔ mbal’gɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ndɔ’a’tɨ kin de kɨ isɨ dɔ kəy’tɨ a ur nanga kadɨ aw me kəy’tɨ un nya madɨ te’n el. ");
INSERT INTO gqr_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","De kɨ a in me ndɔɔ’tɨ a asɨ kadɨ təl re ɓe un ku rɔ’ne el. ");
INSERT INTO gqr_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Kumtondoo kɨ gara goto a in lə dene’gɨ kɨ nje səm kɨ nje kadɨ mba ngann’gɨ ili ndɔ’a’tɨ non kin. ");
INSERT INTO gqr_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Elita kɨ Luwə kadɨ nya kin ra nya ɓar’a el. ");
INSERT INTO gqr_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Tadɔ dɔkagilo’ə’tɨ kin, kon kɨ de’gɨ a ingəi, in kon kɨ de oo nja kare el ɓay. Lo kulə ngirə dɔnangɨ’tɨ kɨ Luwə ində’n nya’gɨ kin, bitɨ ɓone de oo ko kon kin nja kare el. Taa de a oo ko kon kin gogɨ el ratata tɔ. ");
INSERT INTO gqr_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Re Burəɓe uwə ta ndɔ’gɨ kin gangɨ el ə, de kare kɨ a isɨ kɨ dɔ’ne ta goto. Nan ndigɨ be kadɨ n’uwə ta ndɔ’gɨ kin gangɨ tadɔ de’gɨ kɨ inɓe mbətɨ’de. ");
INSERT INTO gqr_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Nga ningə, re de el’se ene: “Oyi, Kirisitɨ De kɨ Luwə mbət’ə ə in yo am eke in ne am”, ə ononyi’se kun me’se kad’a rɔta. ");
INSERT INTO gqr_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Tadɔ de’gɨ kɨ ɓari rɔ’de tokɨ n’in kirisitɨ’gɨ be kɨ nje kɨ ɓari rɔ’de to njekeltakita Luwə’tɨ nan ingɨ el a rei non to rai nya’gɨ kɨ ətɨ ɓol ɓol, kɨ nyakɔjɨ’gɨ kɨ kadɨ n’ɓuki de’gɨ mu’tɨ. A sangi kadɨ to nje kɨ Luwə mbətɨ’de inɓe kin kaa n’ɓuki’de mu ɓay, re ingəi row ra’a. ");
INSERT INTO gqr_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","In be ə, kadɨ, in sii dɔ nja’se’tɨ. M’el’se nya’gɨ kin pətɨ kadɨ gəri kete taa. ");
INSERT INTO gqr_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","«Ningə, dɔkagilo’ə’tɨ kakin, go nya kumtondoo’gɨ’tɨ kin, kadɨ a te kum’ne el, nanyi a nda el. ");
INSERT INTO gqr_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Mee’gɨ a in dɔran’tɨ tosi kɨ nanga, ningə tɔgɨ’gɨ kɨ me dɔran’tɨ a yəki. ");
INSERT INTO gqr_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Lo kin’tɨ anyɨ de’gɨ a oyi m’in Ngonn de m’a m’re me kilndi’tɨ. M’a m’re kɨ tɔgɨ pətɨ, me kunjɨ’tɨ kɨ ətɨ ɓol. ");
INSERT INTO gqr_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","M’a m’ulə malayka’gɨ lə’m kadɨ to dɔ kum dɔnangɨ’tɨ kɨ sɔ, a kawi nje kɨ mbəti’de kɨ nan’tɨ. A kawi’de in ngangɨ dɔnangɨ’tɨ kɨ kare tei in kɨ nungɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","«Majɨ kadɨ in gəri nyando kɨ dɔ kagɨ mbaykote’tɨ kin. Lokɨ baji’ə’gɨ indəi rungirungɨ, ə mbi’ə itɨ kin ningə, in gəri kadɨ nanyi ɓar in ndəkba nga. ");
INSERT INTO gqr_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Be tɔ ə, lokɨ oyi nya’gɨ kin pətɨ rai nya ningə, majɨ kadɨ in gəri tokɨ Ngonn de in ta kəy’tɨ, ndəkba kadɨ re rɔ’se’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ningə tokɨ rɔta’tɨ, adɨ m’el’se, de’gɨ kɨ sii kɨ dɔ’de taa ne kin a oyi tigə el ɓay ə nya’gɨ kin pətɨ a rai nya. ");
INSERT INTO gqr_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Dɔran kɨ dɔnangɨ a gotoi ndɔ madɨ, nan ta’gɨ lə’m a toi lo to’de’tɨ ba bitɨ kɨ non’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","«De kare kɨ gər ndɔ eke dɔ kadɨ kɨ nya’gɨ kin a rai nya’tɨ goto: *Malayka’gɨ kɨ dɔran’tɨ el num, Ngonn lə Luwə inɓe el num, nan Luwə kɨ Baw kɨ kar’ne ba par ə gər. ");
INSERT INTO gqr_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Majɨ kadɨ oyi go rɔ’se, sii dɔ nja’se’tɨ, tadɔ in gəri dɔ kad’a kin el. ");
INSERT INTO gqr_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","A to to ta lə dingəm kare kɨ inyə me kəy lə’ne ə aw mbah kin be. Kete ɓay ta kadɨ aw, adɨ tɔgɨ kulə’gɨ kɨ me kəy’tɨ ji njekuləɓər’gɨ’tɨ lə’ne. Adɨ nan nan kulə kɨ sɔw dɔ’a kadɨ ra, ningə ndəjɨ njengəm takəy kadɨ isɨ dɔ nja’ne’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ə majɨ kadɨ sii dɔ nja’se’tɨ, tadɔ in gəri dɔ kadɨ kɨ ɓe nje kəy a təl’n el. A təl lo sɔl’ɔ, eke danlo’tɨ, eke ndu non kunjə’tɨ, eke kɨ sin kaa, in gəri el. ");
INSERT INTO gqr_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Re te patɨ ningə, kadɨ ingəi dɔ ɓi’tɨ el. ");
INSERT INTO gqr_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ta kɨ m’el’se kin, in de’gɨ pətɨ ə m’el’de: Sii dɔ nja’se’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Nanyi ndɔ joo kete kadɨ ndɔ ra nanyi Pakɨ kɨ nanyi mapa kɨ hum ɔd’ɔ el asɨ. Kibo’gɨ lə njekujənyamosɨ kadikare’gɨ, kɨ njendo ndukun’gɨ lə Luwə, sangi row kadɨ n’uwəi Jeju gidɨ kuwə n’tɔli’ə. ");
INSERT INTO gqr_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Be’ə, elinan eyina: «Adɨ j’uwəi’ə ndɔ ra nanyi’tɨ el nan de’gɨ a indəi kɨ wongɨ.» ");
INSERT INTO gqr_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jeju in me ɓe’tɨ kɨ Betani, me kəy’tɨ lə Simon kɨ njebanjɨ. Lokɨ Jeju isɨ sɔ nya, dene madɨ re kɨ ku mbal kɨ ɓari’ə albatir kɨ hu kɨ ətɨ majɨ in me’tɨ. Hu kin gat’a in ngayn, rai kɨ mann kagɨ kɨ ɓari’ə «nar» inɓe dɔrɔ’a. Dene tɔ ku hu, ningə tətɨ hu kakin dɔ Jeju’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","De’gɨ madɨ dann nje kɨ in low’ə’tɨ non, rɔ’de nəl’de el adɨ elinan dann’de’tɨ eyina: «Tujɨ hu kin kɔ be ginn’ə in ri wa? ");
INSERT INTO gqr_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Asɨ kadɨ de taa’n nar kɨ asɨ silə ɓu mutə, ə ra’n kɨ njendoo’gɨ!» To rɔ’de adɨ elita dene kakin ngayn. ");
INSERT INTO gqr_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Nan Jeju el’de ene: «Inyəi dene kin keke. Tadɔ ri ə isɨ njuwəi’ə wa? Nya kɨ ra dɔ’m’tɨ in kulə kɨ majɨ.» ");
INSERT INTO gqr_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Njendoo’gɨ a in sese kɨ ndɔ’gɨ pətɨ, adɨ ndɔ kɨ me’se ndigɨ par ə a rai se’de, nan m’in, m’a m’in sese kɨ ndɔ’gɨ pətɨ el. ");
INSERT INTO gqr_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Dene kin ra nya kɨ asɨ go tɔgɨ’ne: Ɔy hu rɔ’m’tɨ kete nginə’n ninn’m kɨ a aw ɓadɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ningə adɨ m’el’se ta kɨ rɔta’tɨ: lo’gɨ pətɨ dɔnangɨ’tɨ ne kɨ de’gɨ a iləi mbər Poyta kɨ majɨ səm’tɨ, a ɔri poy nya kɨ dene ra kin, kadɨ me’de olo’n dɔ’a’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Judasɨ Isikariyotɨ kɨ in kɨ kare mbunə njendo’gɨ’tɨ lə Jeju kɨ dɔgɨ gidə in joo, aw ində ta’ne nan’tɨ kɨ kibo’gɨ lə njekujənyamosɨ kadikare’gɨ kadɨ ulə’n Jeju ji’de’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Lokɨ kibo’gɨ oyi ta kɨ ta Judasɨ’tɨ, rɔ’de nəl’de ngayn adɨ uni ndu’de kadɨ n’adi’ə nar. Low’ə’tɨ non, Judasɨ sangɨ row kɨ kadɨ ulə’n Jeju ji’de’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ndɔ kɨ dɔkete lə ra nanyi kusɔ mapa kɨ hum ɔd’ɔ el, adɨ in ndɔ tɔl ngann batɨ’gɨ tadɔ nyakusɔ Pakɨ, njendo’gɨ lə Jeju dəji’ə eyina: «Lo kɨ ra be ə ndigɨ kadɨ j’aw jɨ ra nyakusɔ Pakɨ səm’tɨ kadɨ sɔ wa?» ");
INSERT INTO gqr_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ningə Jeju ulə njendo’gɨ lə’ne joo, el’de ene: «Ai me ɓebo’tɨ kam, a tɔri tanan’tɨ kɨ dingəm kare kɨ otɨ mann me mbu ndar’tɨ dɔ’ne’tɨ, ningə uni go’ə. ");
INSERT INTO gqr_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Me kəy kɨ ur’tɨ ə eli nje kəy kin eyina: “Njendo ene: Kəy kɨ ra ə kadɨ m’re m’njɔ nya Pakɨ’tɨ kɨ njendo’gɨ lə’m wa?” ");
INSERT INTO gqr_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","A ɔjɨ’se me kəy kɨ boi. Me kəy kin to taa, in kɨ ra go’ə ə binəm, kɨ nya’gɨ kɨ me’tɨ pətɨ. Lo kin ə a rai nyakusɔ Pakɨ səm’tɨ kadɨ j’usɔi. ");
INSERT INTO gqr_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Njendo’gɨ indəi, awi me ɓebo’tɨ kakin, ningə, ingəi nya’gɨ pətɨ asɨ nan tokɨ Jeju elɨ’n’de, adɨ rai nyakusɔ Pakɨ indəi dɔ’a dana.» ");
INSERT INTO gqr_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Lokɨ kadɨ ur, Jeju re kɨ njendo’gɨ lə’ne kɨ dɔgɨ gidə in joo. ");
INSERT INTO gqr_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Lokɨ sii ta nyakusɔ’tɨ, Jeju el’de ene: «M’el’se tokɨ rɔta’tɨ: de kare dann’se’tɨ kɨ isɨ sɔ sə’m nya, a ulə’m ji de’gɨ’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Me njendo’gɨ ulə ngirə tujɨ, adɨ dəji ta Jeju kare kare eyina: «In m’in ɓe?» ");
INSERT INTO gqr_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jeju el’de ene: «In de kare dann’se’tɨ in kɨ dɔgɨ gidə in joo inɓe kin. In kɨ ulə ji’ne sə’m nan’tɨ me ngo kusɔ nya’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Tadɔ Ngonn de a oy tokɨ ndangi me makitu’tɨ lə Luwə ɔji dɔ’a, nan kumtondoo in lə de kɨ a ulə Ngonn de ji de’gɨ’tɨ. De’ə kin, re oji’ə el kaa in sotɨ. ");
INSERT INTO gqr_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Lokɨ sii ta nyakusɔ’tɨ, Jeju un mapa, njangɨ dɔ’a, ningə uwə tətɨ nan’tɨ, adɨ njendo’gɨ, ningə el’de ene: «taai, in kin in darɔ’m.» ");
INSERT INTO gqr_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Go mapa’tɨ, Jeju un kɔpɨ yiwi kandɨ nju, ra oyo dɔ’tɨ, ningə təl’n adɨ njendo’gɨ anyinan pətɨ dann’de’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Jeju el’de ene: «In kin in mosɨ’m, mosɨ Kunmindɨ kɨ sigɨ kɨ a anyi tadɔ bulə de’gɨ. ");
INSERT INTO gqr_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ningə m’el’se tokɨ rɔta’tɨ, m’a m’anyi yiwi kandɨ nju kɨ rangɨ el, bitɨ kadɨ m’a m’anyi kɨ sigɨ me Konɓe lə Luwə.» ");
INSERT INTO gqr_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Osi pa kulə tɔjɨ dɔ Luwə’tɨ, ningə tei awi dɔ mbal kagɨ Buni’gɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jeju el njendo’gɨ lə’ne ene: «Ingɨ a mbətɨ m’in pətɨ, tadɔ ndangi me makitu’tɨ lə Luwə eyina: “M’a m’tɔl njekul batɨ’gɨ, ningə batɨ’gɨ a sananyinan kɨ lo lo.” ");
INSERT INTO gqr_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Nan lokɨ m’a m’ində lo koy’tɨ, m’a m’aw kete non’se’tɨ, to nginə’se Galile’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Piyər el Jeju ene: «Re de’gɨ pətɨ inyəi nu kɔ kaa, m’in m’a m’inyə’i kɔ el.» ");
INSERT INTO gqr_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jeju təl el’ə ene: «Tokɨ rɔta’tɨ, adɨ m’el’i, in, ɓone, me kondɔ’tɨ inɓe kin, kunə kunjə a non nja joo el ɓay ə a manjɨ ta nja mutə ene in gərɨ’m el.» ");
INSERT INTO gqr_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Nan Piyər ra dɔ ndu’ne’tɨ ene: «Re in koy kaa m’a m’oy sə’i, um m’a manjɨ ta gəri el bitɨ.» Ningə ndəgɨ njendo’gɨ pətɨ eli ko ta inɓe kɨ Piyər el kakin tɔ. ");
INSERT INTO gqr_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Go’tɨ, Jeju in kɨ njendo’gɨ lə’ne ɔti rei lo’tɨ madɨ kɨ tɔ’a nan Getisemane. Jeju el’de ene: «Sii lo kin’tɨ ne be in nginəi m’in, dɔkagilo’tɨ kɨ m’a m’elta kɨ Luwə.» ");
INSERT INTO gqr_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Jeju adɨ Piyər num, Jakɨ num, Jan num awi si’ə. Lo kin’tɨ, dadɨ kɨ ɓol kɨ metujɨ kibo ulə ngirə ra Jeju. ");
INSERT INTO gqr_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Adɨ Jeju el’de ene: «Me’m rosɨ kɨ metujɨ kɨ asɨ koy, sii ne be, sii kum ba um, in toi ɓi el.» ");
INSERT INTO gqr_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Jeju ɔtɨ kɨ kete nden, ningə osɨ kɨ takum’ne nanga, dəjɨ Luwə kadɨ re, to lo ra’tɨ ə, ɔsɨ dɔ kadɨ kon kin ngərəngɨ rɔ’ne’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Jeju ene: «Aba! Bai, nya kɨ dum tɔgi goto, ə ɔsɨ kɔpɨ kon kin ngərəngɨ kɔ rɔ’m’tɨ, nan k’in ə kadɨ in kigo ndigɨ’tɨ lə’m el, nan kigo ndigɨ’tɨ lə’i yo taa.» ");
INSERT INTO gqr_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Jeju təl re rɔ njendo’gɨ’tɨ kɨ mutə, ningə ingə’de, isɨ toi ɓi, adɨ el Piyər ene: «Simon, isɨ to ɓi inɓe bitɨ wa? Asɨ kadɨ isɨ kum dɔ kadɨ’tɨ kɨ kare be el bitɨ wa? ");
INSERT INTO gqr_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Sii dɔ nja’se’tɨ ba, elita kɨ Luwə, kadɨ osi me nyanan’tɨ el. Ndil de kɨ me’ə’tɨ ge ra nya kɨ majɨ, nan darɔ in kɨ ton.» ");
INSERT INTO gqr_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Təl ɔr rɔ’ne se’de kɨ rangɨ ɓay, elta kɨ Luwə, un go mindɨ’ne kɨ kete inɓe kakin ɓay. ");
INSERT INTO gqr_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Lokɨ təl re rɔ’de’tɨ ningə, ingə’de isɨ toi ɓi ɓay. Kum’de ɔy diriri, lo ta kɨ kadɨ eli’ə kaa gəri el. ");
INSERT INTO gqr_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Jeju təl aw, re kɨ nja mutə, el’de ene: «In toi ta ɓitɨ ne, isɨ ɔri kon ɓay wa? Asɨ be nga! Dɔkagilo re. Ngɔsine a uləi m’in Ngonn de ji njeramajel’gɨ’tɨ nga. ");
INSERT INTO gqr_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Indəi taa adɨ j’awi, njekulə’m ji’de’tɨ ə a re am!» ");
INSERT INTO gqr_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Lowə tɨ non lokɨ ta nanyi kɨ ta Jeju’tɨ ba ɓay ningə, Judasɨ, kɨ in kɨ kare dann njendo’gɨ’tɨ kɨ dɔgɨ gidə in joo ə isɨ re. Re kɨ kutɨ de’gɨ ngayn go’ne’tɨ. De’gɨ kɨ njekuwə kiyərɔ’gɨ ge, njekuwə gɔl’gɨ ji’de’tɨ ge. Bulə de’gɨ kin, in kibo’gɨ lə njekujənyamosɨ kadikare’gɨ, kɨ njendo ndukun’gɨ lə Luwə, kɨ ngatɔgɨ’gɨ, ə uləi’de. ");
INSERT INTO gqr_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judasɨ kɨ njekundɔ Jeju, elinan se’de nya kɨ n’a n’ra kadɨ to gəri Jeju ene: «De kɨ m’a m’ində ta’m kɔt’ɔ kin ə, in darɔ’a inɓe, ənn ə, uwəi’ə səm, indəi kum’se go’ə’tɨ majɨ ai si’ə!» ");
INSERT INTO gqr_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","In be ə, te inɓe kɨ Judasɨ te par ə, ɔtɨ re rɔ Jeju’tɨ el’ə ene: «Njendo de’gɨ!» Ningə, ində ta’ne kɔt’ɔ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Nje kɨ nungɨ indəi ji’de dɔ Jeju’tɨ uwəi’ə. ");
INSERT INTO gqr_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Lokɨ uwəi’ə, kɨ kare dann nje kɨ in si’ə nan’tɨ, ɔr kiyərɔ lə’ne tugə’n mbi paja lə kibo lə njekujənyamosɨ kadikare’gɨ, batɨ gangɨ. ");
INSERT INTO gqr_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jeju un ta el’de ene: «To to nya kɨ m’in kaya de ə, in rei kɨ kiyərɔ’gɨ kɨ gɔl’gɨ ta kadɨ uwəi m’in be? ");
INSERT INTO gqr_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ndɔ’gɨ pətɨ, m’in sese nan’tɨ natɨ Kəy’tɨ lə Luwə, m’ndo de’gɨ nya, kaa, uwəi m’in el, nan in kin to be ɓone kadɨ ta’gɨ kɨ ndangi me makitu’tɨ lə Luwə tɔli ta’de.» ");
INSERT INTO gqr_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Lo kin’tɨ, njendo’gɨ li’ə pətɨ anyinan ə inyəi’ə. ");
INSERT INTO gqr_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ngonn kɨ basa kare, kɨ dolo rɔ’ne kɨ ta ku inɓe par, un go Jeju. De’gɨ uwəi ngonn kɨ basa kakin, ");
INSERT INTO gqr_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","nan, inyə ta ku kɨ dolo’n rɔ’ne kakin ji’de’tɨ, ə anyi kɨ rɔ’ne kare aw. ");
INSERT INTO gqr_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Nje kuwə Jeju, awi si’ə non kibo’tɨ lə njekujənyamosɨ kadikare’gɨ. In lo kin ə kibo’gɨ lə njekujənyamosɨ kadikare’gɨ kɨ ngatɔgɨ’gɨ kɨ njendo ndukun’gɨ lə Luwə, pətɨ kawinan’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Piyər ra njiyə go’de’tɨ sanyi, nden nden, re ur go’de’tɨ, natɨ lo’tɨ lə kibo lə njekujənyamosɨ kadikare’gɨ kakin. Re isɨ nan’tɨ kɨ paja’gɨ ta por’tɨ, isɨ nduwi. ");
INSERT INTO gqr_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Kibo’gɨ lə njekujənyamosɨ kadikare’gɨ kɨ nje gangɨ ta’gɨ lə Juwipɨ’gɨ, ba pətɨ, sangi row təti ta madɨ kadɨ n’gangi ta koy dɔ Jeju’tɨ, nan ingəi el. ");
INSERT INTO gqr_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","De’gɨ ngayn təti ta kɨ ngom dɔ’a’tɨ, nan ta kɨ tətɨ’gɨ lə’de aw go nan’tɨ el. ");
INSERT INTO gqr_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Nje kɨ nagɨ indəi rai taa, taa təti ta kɨ ngom dɔ’a’tɨ eyina: ");
INSERT INTO gqr_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","«J’oo ta’a’tɨ ene: “M’a m’tujɨ Kəy lə Luwə kɨ de’gɨ rai kɨ ji’de kam kɔ, ningə me ndɔ’tɨ kɨ mutə, m’a m’ra in kɨ rangɨ kɨ de ra kɨ ji’ne el.”» ");
INSERT INTO gqr_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Dɔ ta’tɨ inɓe kin kaa, ndu nje tətɨ ta’gɨ osɨ go nan’tɨ el. ");
INSERT INTO gqr_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ə kibo lə njekujənyamosɨ kadikare’gɨ ində taa dann de’gɨ’tɨ kɨ kawinan, dəjɨ Jeju ene: «A elta madɨ dɔ ta’gɨ’tɨ kɨ de’gɨ ra eli dɔ’i’tɨ kam el wa?» ");
INSERT INTO gqr_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Nan Jeju ra ta’ne mbo, te ta’ne ilə’de’tɨ el. *Kibo lə njekujənyamosɨ kadikare’gɨ dəjɨ Jeju ta kɨ rangɨ ɓay ene: «In, ə in Kirisitɨ De kɨ Luwə mbət’ə, kɨ in Ngonn lə Luwə kɨ de’gɨ isɨ uləi tɔjɨ dɔ’a’tɨ kin wa?» ");
INSERT INTO gqr_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ə Jeju el’ə ene: «In m’inɓe, ningə a oyi m’in Ngonn de m’njɨ dɔjikɔl Luwə’tɨ kɨ nje tɔgɨ, a oyi m’in m’ində dɔran’tɨ m’re me kilndi’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Kibo lə njekujənyamosɨ kadikare’gɨ til ku’gɨ kɨ rɔ’ne’tɨ, ə el ene: «In kin, jɨ sangɨ kadɨ de madɨ kɨ rangɨ elta dɔ’a’tɨ ɓay wa? ");
INSERT INTO gqr_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Inɓe’gɨ oyi ndu’ə kɨ el’n ta kɨ mal dɔ Luwə kɨ mbi’se ne. Ta ri ə in məri dɔ’a’tɨ wa?» Ə de’gɨ pətɨ kɨ in low’ə’tɨ kin gangi ta dɔ Jeju’tɨ, kadɨ in de kɨ sɔw dɔ koy. ");
INSERT INTO gqr_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Nje kɨ nan’gɨ, uləi ginn tuw mannta’de dɔ’a’tɨ, ndəmi takum’ə, ningə ɓiri ji’de ɔsi’ə’n’ə, ə eli’ə eyina: «in ra rɔ’i to njekeltakita Luwə’tɨ be ə ɔjɨ’je de kɨ ɔsi adɨ j’oo!» Low’ə’tɨ non, paja’gɨ uwəi Jeju, agi kɨ rɔ’a’tɨ tindəi kɔt’ɔ. ");
INSERT INTO gqr_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Lokɨ Piyər in tambalo’tɨ, nanga ne ɓay, dene kare kɨ dann dene’gɨ’tɨ kɨ nje ra kulə’gɨ’tɨ me kəy’tɨ lə kibo lə njekujənyamosɨ kadikare’gɨ in non re. ");
INSERT INTO gqr_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Oo Piyər isɨ nduw por ningə, ində manj’a ba, ə el’ə ene: «In kaa, in kɨ Jeju kɨ Najaretɨ’tɨ tɔ el wa?» ");
INSERT INTO gqr_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Nan Piyər el’ə ene: «Jagɨ m’gər’ə el, ta m’gər me ta lə’i inɓe kɨ ra el kam el tɔ.» Go’tɨ Piyər ɔtɨ aw ra ta ndogɨ’tɨ, ningə kunə kunjə non. ");
INSERT INTO gqr_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Dene kakin ilə kum’ne oo’n Piyər, ningə təl re dɔ ta’tɨ kakin ɓay, el de’gɨ kɨ rai se’de non ene: «Dingəm kam in kɨ kare dann de’gɨ’tɨ li’ə tɔ.» ");
INSERT INTO gqr_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Piyər təl manjɨ nja kare ɓay, ene n’gər’ə el. Ningə njaba go’tɨ, ə de’gɨ kɨ rai se’de non, rei eli Piyər ɓay eyina: «Tokɨ rɔta’tɨ, in kaa, in kɨ kare dann de’gɨ’tɨ li’ə tɔ, tadɔ in de kɨ Galile’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ə lo kin’tɨ Piyər iw rɔ’ne kɨ ta kɨ ngan ngayn ene: «Kadɨ Luwə ra sə’m nya kɨ ngan, re m’elta kɨ ngom. M’gər dingəm kɨ a elita li’ə kam el.» ");
INSERT INTO gqr_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ningə tanan’tɨ non, kɨ nja joo, kunə kunjə non. Nga ningə, me Piyər olo dɔ ta’tɨ kɨ Jeju el’ə ene: «Kete taa kadɨ kunə kunjə non kɨ nja joo a manjɨ ta kɨ nja mutə ene gərɨ’m el,» adɨ Piyər non kɨ mann kum’ne. ");
INSERT INTO gqr_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Kɨ sin ba, kibo’gɨ lə njekujənyamosɨ kadikare’gɨ, ingəi nan kɨ ngatɔgɨ’gɨ kɨ njendo ndukun’gɨ, kɨ nje gangi ta’gɨ lə Juwipɨ’gɨ ba pətɨ, uni ndu’de ningə dɔi Jeju, awi si’ə uləi’ə ji Pilatɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ə *Pilatɨ dəjɨ Jeju ene: «in ngar lə Juwipɨ’gɨ wa?» Jeju el’ə ene: «In ta kɨ te ta’i’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Kibo’gɨ lə njekujənyamosɨ kadikare’gɨ təti ta’gɨ ngayn dɔ Jeju’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ə, Pilatɨ təl dəjɨ Jeju ta kɨ rangɨ ɓay ene: «A elta madɨ el wa? oo ta’gɨ pətɨ kɨ de’gɨ a indəi dɔ’i’tɨ kam!» ");
INSERT INTO gqr_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Nan Jeju te ta’ne ilə’tɨ el, adɨ ndɔjɨ Pilatɨ kɨ dum. ");
INSERT INTO gqr_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Dɔ ɓal’gɨ pətɨ, lo ra nanyi Pakɨ’tɨ, Pilatɨ ɔr dangay kare ilə taa, adɨ in de kɨ bulə de’gɨ dəji’ə kadɨ ɔr’ɔ dangay’tɨ adɨ’de. ");
INSERT INTO gqr_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Dingəm kare kɨ ɓari’ə nan Barabasɨ in dangay’tɨ. Uwəi’de dangay’tɨ in kɨ madɨ’ne’gɨ ɔjidɔ tɔl kɨ tɔli de, lo wongɨ’tɨ kɨ tɔji taga dɔ nje konɓe’gɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Bulə de’gɨ awi rɔ Pilatɨ’tɨ, ningə dəji’ə kadɨ ra nya kɨ isɨ ra kete kete kakin adɨ’de. ");
INSERT INTO gqr_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Nga a Pilatɨ dəjɨ’de ene: «Gəi kadɨ m’inyə ngar lə Juwipɨ’gɨ taa madɨ’se wa?» ");
INSERT INTO gqr_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilatɨ dəjɨ ta kin be, tadɔ gəri majɨ kadɨ in jangɨ ə ra kibo’gɨ lə njekujənyamosɨ kadikare’gɨ dɔ Jeju’tɨ ə uləi’ə ji’ne’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Nan kibo’gɨ lə njekujənyamosɨ kadikare’gɨ suləi bulə de’gɨ adɨ dəji Pilatɨ kadɨ ɔr Barabasɨ yo adɨ’de um Jeju el. ");
INSERT INTO gqr_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilatɨ dəjɨ’de ɓay ene: «In gei kadɨ m’ra ri kɨ in kɨ in ɓari’ə ngar lə Juwipɨ’gɨ wa?» ");
INSERT INTO gqr_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ningə təli uləi bilə eyina: «In ɓər’ə kagidəsɨ’tɨ!» ");
INSERT INTO gqr_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilatɨ dəjɨ’de ene: «In ri kɨ majel ə ra wa?» Ningə uləi bilə ngayn ɓay eyina: «In ɓər’ə kagidəsɨ’tɨ!» ");
INSERT INTO gqr_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","In be ə, kadɨ rɔ bulə de’gɨ nəl’n’de, Pilatɨ ɔr Barabasɨ adi’de. Ningə go’tɨ, adɨ indəi Jeju kɨ ndəy hawlay, ə uləi’ə ji njerɔ’gɨ’tɨ kadɨ ɓəri’ə kagidəsɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Njerɔ’gɨ ɔri Jeju awi si’ə me kəy’tɨ lə ngar Pilatɨ, natɨ lo’tɨ kɨ ɓari’ə nan piretuwar, me lo’tɨ lə Pilatɨ inɓe non, ə ɓari ndəgɨ njerɔ’gɨ pətɨ adi’de rei. ");
INSERT INTO gqr_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Low’ə’tɨ non, uləi ku kɨ kər njir njir rɔ Jeju’tɨ, ə oji jɔgɨ konn uləi dɔ’a’tɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ningə, iləi rɔ’de rai’ə lapiya eyina: «Lapiya ngar lə Juwipɨ’gɨ!» ");
INSERT INTO gqr_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Tindəi dɔ’a kɨ kagɨ gakira, tuwi mann ta’de dɔ’a’tɨ, ə ɔsi məkəsɨ’de nanga, eyina n’isi n’ɔsi dɔ’de nanga non’a’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Lokɨ uwəi’ə kogi asɨ’de ningə, ɔri ku kɨ kər njir njir kakin rɔ’a’tɨ kɔ, ə təli uləi ku’gɨ li’ə inɓe rɔ’a’tɨ gogɨ. Go’tɨ, tei awi si’ə taga kadɨ ɓəri’ə kagidəsɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Dingəm kare kɨ Sirenn’tɨ, tɔ’a nan Simon, in baw Alegijandir kɨ Rupusɨ, in mu, ningə njerɔ’gɨ uwəi’ə kɨ tɔgɨ adɨ otɨ kagidəsɨ lə Jeju. ");
INSERT INTO gqr_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Awi kɨ Jeju lo madɨ’tɨ kare to non, ɓari eyina Golgota, kɔr me’ə nan: «Lo kadɔ de.» ");
INSERT INTO gqr_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Adi’ə yiwi kandɨ nju kɨ buri nan’tɨ kɨ nya kɨ ɓari eyina mir, kadɨ Jeju anyi, nan mbətɨ kanyi. ");
INSERT INTO gqr_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Go’tɨ, njerɔ’gɨ ɓəri Jeju kagidəsɨ’tɨ. Tugəi kiri mbara dɔ ku’gɨ’tɨ li’ə, lowəi nan dann’de’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","In kɨ kadɨ kɨ jikara, ə ɓəri’ə’n’ə kagidəsɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ndangi me bar’tɨ, nya kɨ ra ə n’ɓəri’ə’n’ə kagidəsɨ’tɨ eyina: «Ngar lə Juwipɨ’gɨ.» ");
INSERT INTO gqr_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ɓəri njeɓogɨ’gɨ joo nan’tɨ si’ə kagidəsɨ’tɨ. Kɨ kare dɔjikɔl’ɔ’tɨ, kɨ nungɨ dɔjigəl’ə’tɨ.  ");
INSERT INTO gqr_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Be kadɨ ta kɨ ndangi me makitu’tɨ lə Luwə tɔl’n ta’ne: «Tudəi’ə dann njeramajel’gɨ’tɨ» kin tɔl’n ta’ne. ");
INSERT INTO gqr_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","De’gɨ kɨ nje dər row’ə, ra indəi dɔ’de roke roke, ningə taji’ə, ə eli eyina: «Man, in kɨ nje tujɨ Kəy lə Luwə, ə təl ra in kɨ rangɨ me ndɔ’tɨ kɨ mutə kam! ");
INSERT INTO gqr_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Ajɨ rɔ’i inɓe, ə in dɔ kagidəsɨ’tɨ ur nanga ɓe!» ");
INSERT INTO gqr_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Be tɔ ə nyɨ, kibo’gɨ lə njekujənyamosɨ kadikare’gɨ kɨ njendo ndukun’gɨ lə Luwə, uwəi Jeju kogi dann’de’tɨ eyina: «Ajɨ de’gɨ kɨ rangɨ, nan inɓe asɨ kajɨ rɔ’ne el! ");
INSERT INTO gqr_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Kirisitɨ, De kɨ Luwə mbət’ə, Ngar lə Isirayel’gɨ kaa kam, kɨ ra’je inɓe kɨ jɨ ra’n ne kin, kadɨ in dɔ kagidəsɨ’tɨ ur nanga adɨ j’oo, adɨ to j’un me’je j’ad’a rɔta!» Nje kɨ ɓəri’de kagidəsɨ’tɨ kɨ kare dɔjikɔl’ɔ’tɨ kɨ nungɨ dɔjigəl’ə’tɨ kaa taji’ə kah’a’tɨ inɓe tɔ. ");
INSERT INTO gqr_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Lokɨ kadɨ ra jam dɔ ɓe’tɨ, lo diw, ndul kururu dɔnangɨ’tɨ ba pətɨ, bitɨ kadɨ kɨ mutə kɨ losɔl’ɔ. ");
INSERT INTO gqr_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ningə kadɨ’tɨ kɨ mutə, Jeju non kɨ ndu’ne kibo ene: «Eloyi, Eloyi, lama sabakitani?» Kɔr me’ə nan: «Luwə lə’m, Luwə lə’m, tadɔ ri ə inyə’m kɔ wa?» ");
INSERT INTO gqr_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","De’gɨ madɨ dann nje’gɨ’tɨ kɨ rai non, oyi ndu’ə, ningə eli eyina: «Oyi de kaa nyɨ, ra ɓar Eli!» ");
INSERT INTO gqr_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","De kare dann’de anyi ngodɨ, un nya kɨ to hem hem, ulə me mann kandɨ nju’tɨ kɨ masɨ, ningə ulə ta gakira’tɨ adɨ Jeju kadɨ anyi, ə el ene: «In nginəi adɨ j’oyi ke Eli a re ris’ə nanga dɔ kagidəsɨ’tɨ wa?» ");
INSERT INTO gqr_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Lo kin’tɨ non be, Jeju ur koo kɨ ndu’ne kibo, ningə kon’a te. ");
INSERT INTO gqr_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Go’tɨ ku gangɨ lo kɨ ra me Kəy’tɨ lə Luwə, til dana joo, in ta nu bitɨ re nanga. ");
INSERT INTO gqr_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Kibo lə kutɨ njerɔ’gɨ kɨ ɓu, kɨ ra takum Jeju’tɨ, oo’ə lo koy’tɨ kɨ oy, el ene: «Kɨ rɔta’tɨ, dingəm kin in Ngonn lə Luwə.» ");
INSERT INTO gqr_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Dene’gɨ madɨ rai non tɔ, rai sanyi, indəi kum’de ra oyi nya’gɨ kɨ isɨ rai nya. Dann’de’tɨ, Mari kɨ Magidala num, Mari kɨ kon Jakɨ kɨ ɓari’ə ngonn kɨ in kon Joje num, ta Salome num, rai non tɔ. ");
INSERT INTO gqr_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","In ingɨ kin ə ndolei go Jeju, ta rai si’ə me nya’gɨ’tɨ li’ə lokɨ in Galile’tɨ. Ningə, dene’gɨ kɨ rangɨ ngayn kɨ rei si’ə Jerujalem’tɨ kaa in non ɓay tɔ. ");
INSERT INTO gqr_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ndɔ’a’tɨ kin, in ndɔ kɨ de’gɨ a ɔsi nja nya’gɨ nan’tɨ indəi, adɨ in ndɔ kɨ non ndɔ kɔrkon’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Lokɨ lo sɔl, Jisepɨ kɨ Arimate’tɨ, kɨ in kɨ kare dann njegangɨ ta’gɨ’tɨ lə Juwipɨ’gɨ, in de kɨ de’gɨ ɓuki’ə’tɨ ngayn, utɨ mosɨ’ne ku’tɨ in non re. In inɓe kaa isɨ nginə Konɓe lə Luwə kɨ kadɨ a re kin tɔ. Ɓol ra’a el, adɨ aw rɔ Pilatɨ’tɨ dəj’ə ninn Jeju. ");
INSERT INTO gqr_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Lokɨ Pilatɨ oo kadɨ Jeju oy ə, ət’ə ɓol, adɨ ulə go nje kisi dɔ kutɨ njerɔ’gɨ kɨ ɓu, ad’a re, ningə dəj’ə ene ke Jeju oy mayinu wa? ");
INSERT INTO gqr_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Lokɨ oo ta kɨ ta nje kisi dɔ njerɔ’gɨ’tɨ ningə, adɨ tarow Jisepɨ kadɨ un ninn Jeju. ");
INSERT INTO gqr_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Jisepɨ ndogɨ ta ku dolo ninn, risɨ ninn Jeju dɔ kagidəsɨ’tɨ re’n nanga, dolo kɨ ku dolo ninn, ilə me ɓe ninn’tɨ kɨ uri kadɨ mbal’tɨ, ningə nduguru mbal ilə ta’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mari kɨ Magidala in kɨ Mari kɨ kon Joje awi, ra oyi lokɨ iləi Jeju’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Lokɨ ndɔ kɔrkon dər, Mari kɨ Magidala num, kɨ Mari, kɨ kon Jakɨ num, Salome num ndogi hu kagɨ kɨ ətɨ mbin, tadɔ kaw kɔy rɔ ninn Jeju’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ndɔ Dɔmasɨ, kɨ sin ba, lokɨ kadɨ isɨ uwə, anyɨ awi dɔɓadɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Lokɨ isɨ awi ningə, elinan dann’de’tɨ eyina: «Nga kin, nan ə to nduguru mbal ta’a’tɨ rangɨ adi’je wa?» ");
INSERT INTO gqr_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Nan lokɨ uni kum’de ningə, oyi kadɨ kəkirə mbal kakin, de nduguru’ə rangɨ. ");
INSERT INTO gqr_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Dene’gɨ kin uri ɓe ninn’tɨ ningə, nyɨ, oyi ngonn kɨ basa madɨ kare, ulə ku ngal kɨ nda rɔ’ne’tɨ, si’n kɨ dɔjikɔl’tɨ. Lo kin’tɨ, ɓol ra dene’gɨ. ");
INSERT INTO gqr_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Nan, ngonn kɨ basa kakin el’de ene: «In ɓoli el, m’gər kadɨ isɨ sangi Jeju kɨ Najaretɨ’tɨ, kɨ de’gɨ ɓəri’ə kagidəsɨ’tɨ. Jeju ində taa lo koy’tɨ, goto ne. Oyi lokɨ iləi’ə’tɨ ə to kare kin. ");
INSERT INTO gqr_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ningə kɨ ngɔsine kin, awi eli Piyər kɨ ndəgɨ njendo’gɨ tokɨ a aw kadɨ nginə’se Galile’tɨ. Lo kin ə a oyi’ə’tɨ, tokɨ el’n’se kete.» ");
INSERT INTO gqr_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Dene’gɨ tei kɨ ngodɨ nja’de’tɨ ta ɓadɨ’tɨ, dadi par par kɨ ɓol, gəri row rɔ’de el. Ta kaa eli de el, tadɔ ɓol tɔl’de. ");
INSERT INTO gqr_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jeju ində taa lo koy’tɨ kɨ ndɔ Dɔmasɨ, sin ba. Lokɨ ində lo koy’tɨ, de kɨ dɔkete kɨ tɔji rɔ’ne rɔ’a’tɨ in Mari kɨ Magidala, kɨ ndɔkɨ tuwə ndil’gɨ kɨ majel siri dɔ’a’tɨ kɔ. ");
INSERT INTO gqr_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ningə, Mari ə in nje kaw kel njendo’gɨ li’ə kɨ sii ta kuwə ndoo’tɨ kɨ ta non’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Nan lokɨ Mari el’de tokɨ Jeju ində lo koy’tɨ, adɨ n’inɓe n’oo’ə kɨ kum’ne, njendo’gɨ tai me’ə el. ");
INSERT INTO gqr_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Go’tɨ, Jeju ɔjɨ rɔ’ne kɔjɨ kɨ to ta dangɨ njendo’gɨ joo kɨ in dɔ row’tɨ, isɨ awi kɨ ngannɓe’gɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Lokɨ Jeju ingə’de, təli awi ɔri poy’o ndəgə’gɨ, nan ndəgə’gɨ uni me’de, el tɔ. ");
INSERT INTO gqr_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ta tɔlta’a’tɨ, Jeju ɔjɨ rɔ’ne njendo’gɨ kɨ dɔgɨ gidə in kare lokɨ isɨ sɔi nya. Lo kin’tɨ, Jeju kɔl se’de dɔ kunme’tɨ el lə’de, kɨ kum kutɨ lə’de, tadɔ mbeti kun me’de nje kɨ oyi’ə tokɨ ində lo koy’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Go’tɨ, el’de ene: «Ai kɨ dɔ ɓe’gɨ kɨ dɔnangɨ’tɨ ne pətɨ, iləi mbər Poyta kɨ majɨ mbi de’gɨ’tɨ pətɨ. ");
INSERT INTO gqr_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","De kɨ un me’ne, ə rai’ə batəm, ningə a ingə kajɨ, nan de kɨ mbətɨ kunme’ne, ta kɨ gangɨ a in dɔ’a’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Nyakɔjɨ’gɨ kɨ nje kɨ uni me’de adi Luwə a ɔji ə to kin: me tɔ’m’tɨ, a tuwəi ndil’gɨ kɨ majel, a eli ndonnta’gɨ kɨ mbah. ");
INSERT INTO gqr_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","A uwəi lii’gɨ kɨ ji’de, ningə re anyinan nya kɨ nje tɔl de kaa, a ra se’de nya madɨ el. A indəi ji’de dɔ njemonyi’gɨ’tɨ, adɨ nje monyi’gɨ ingəi lapiya.» ");
INSERT INTO gqr_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Go ta’gɨ’tɨ kɨ Burəɓe Jeju el’de, uni’ə awi si’ə dɔran’tɨ, adɨ isɨ dɔjikɔl Luwə’tɨ. ");
INSERT INTO gqr_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Go kaw’a dɔran’tɨ, njendo’gɨ awi iləi mbər Poyta kɨ majɨ. Burəɓe in se’de nan’tɨ, adɨ’de tɔgɨ adɨ rai nya’gɨ kɨ ətɨ ɓol ɓol. Nyakɔjɨ’gɨ kin to be, tɔjɨ kadɨ ta lə njendo’gɨ in ta kɨ rɔta’tɨ.");
INSERT INTO gqr_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Tewopil, de’gɨ ngayn adi rɔ’de, ndangi nya’gɨ kɨ rai nya dann’je’tɨ ne kin kɨ go’ə go’ə. ");
INSERT INTO gqr_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ndangi tokɨ, nje kɨ oyi nya’gɨ kin kɨ kum’de eli’je. Oyi kɨ kum’de lo kulə ngirə’tɨ nu, ə təli nje kiləmbər Poyta kɨ majɨ lə Luwə. ");
INSERT INTO gqr_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Be ə, m’in kaa, m’sangɨ ginn nya’gɨ pətɨ kɨ rai nya kin, lo kulə ngirə’tɨ nu majɨ majɨ kadɨ m’oo. Ningə go sang’a’tɨ kɨ m’sangɨ, m’oo majɨ ngayn kadɨ, m’ndangɨ me makitu’tɨ kɨ go’ə go’ə mad’i in kibo Tewopil. ");
INSERT INTO gqr_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Lo kin’tɨ, a gər kadɨ nyando’gɨ kɨ ingə’de in nyando kɨ rɔta’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Dɔkagilo’tɨ kɨ *Erodɨ in ngar kɨ Jude’tɨ, dingəm kare isɨ non tɔ’a nan Jakari. Jakari in kɨ kare me kutɨ’tɨ lə njekujənyamosɨ kadikare’gɨ kɨ ɓari’ə Abiya. Tɔ ne’ə nan Elijabetɨ. In ngonn kɨ dene kɨ ginn kojɨ’tɨ lə *Aron. ");
INSERT INTO gqr_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Jakari ingɨ kɨ Elijabetɨ joo pətɨ in de’gɨ kɨ dana takum Luwə’tɨ. Təli rɔ’de majɨ ngayn go mbərkikində’gɨ’tɨ kɨ gorow’gɨ’tɨ lə Burəɓe pətɨ. ");
INSERT INTO gqr_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Nan ingəi ngonn el, tadɔ Elijabetɨ in kujɨ. Ningə in dɔkagilo kɨ, ingɨ joo pətɨ, ɓugəi nga. ");
INSERT INTO gqr_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ndɔ kare Jakari isɨ ra kulə kujənyamosɨ kadikare takum Luwə’tɨ, tadɔ in ndɔ ra kulə lə kutɨ li’ə. ");
INSERT INTO gqr_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ningə, kigo ra’a’tɨ lə njekujənyamosɨ kadikare’gɨ, kagilo osɨ dɔ Jakari’tɨ kadɨ ur me Kəy’tɨ lə Luwə. Ur kəy kadɨ ɓukɨ ndujɨ kagɨ kɨ ətɨ mbin por’o. ");
INSERT INTO gqr_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Lokɨ Jakari a ɓukɨ ndujɨ kagɨ kɨ ətɨ mbin por’o kin, bulə de’gɨ ngayn rai taga ne ra elita kɨ Luwə. ");
INSERT INTO gqr_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Low’ə’tɨ non, malayka lə Burəɓe te bus kɨ rɔ Jakari’tɨ, dɔjikɔl’tɨ lə lo ɓukɨ ndujɨ kagɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Lokɨ Jakari oo malayka kakin ningə, ndil’ə te anyi ur kakɨ, ɓol tɔl’ɔ. ");
INSERT INTO gqr_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Nan malayka el’ə ene: «Ɓol el Jakari, tadɔ Luwə oo dɔ ndu ta kɨ el si’ə, ne’i Elijabetɨ a ojɨ ngonn adi, a ində tɔ’a nan Jan. ");
INSERT INTO gqr_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","A in nya rɔnel lə’i kibo ngayn, taa de’gɨ ngayn a rai rɔnel dɔ koj’o’tɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Tadɔ a in de kibo takum Burəɓe’tɨ. A anyi yiwi kandɨ nju el num, a anyi ndəgɨ yiwi’gɨ kɨ hum ɔd’ɔ el num tɔ. Lokɨ to’n me kon’ne’tɨ ɓay, Ndil Luwə a ros’o. ");
INSERT INTO gqr_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","A təl kɨ ngann Isirayel’gɨ ngayn re se’de rɔ Burəɓe Luwə’tɨ lə’de. ");
INSERT INTO gqr_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","A njiyə takum Burəɓe’tɨ kɨ Ndil num, kɨ tɔgɨ lə njekeltakita Luwə’tɨ Eli num tɔ. A njiyə kɨ Ndil num kɨ tɔgɨ num kadɨ ulə ngann’gɨ kɨ baw’de’gɨ noji nan’tɨ. Taa kadɨ njedongan’gɨ təli nje kaw kɨ hal lə de’gɨ kɨ dana, kadɨ de’gɨ indəi dɔ rɔ’de dana tadɔ lə Burəɓe.» ");
INSERT INTO gqr_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Jakari dəjɨ malayka ene: «Kɨ gorow kɨ bann ə m’a m’gər’n kadɨ in ta kɨ rɔta’tɨ wa? Tadɔ m’in kɨ dɔ’m m’ɓugə, ta ne’m kaa ɓal’a al dɔ lo tɔ nga.» ");
INSERT INTO gqr_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Malayka təl el’ə ene: «M’in Gabiriyel, kɨ nje ra kulə takum Luwə’tɨ. Luwə ulə’m kadɨ m’el’i ta, m’ilə Poyta kɨ majɨ kin mbi’i’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Oo majɨ, a təl mbiki, adɨ a asɨ kelta madɨ el, bitɨ kadɨ ndɔ kɨ nya’gɨ kɨ m’el’i ta’a kin rai nya ɓay taa. A in be, tadɔ kunme lə’i goto dɔ ta’gɨ’tɨ kɨ m’el’i kin. Nya’gɨ kin a rai nya dɔkagilo’ə’tɨ kɨ Luwə ɔjɨ.» ");
INSERT INTO gqr_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Me lo kin’tɨ, bulə de’gɨ toi ta nginə Jakari’tɨ, ta ndɔjɨ’de, tadɔ Jakari un dɔkagilo ngayn me Kəy’tɨ lə Luwə. ");
INSERT INTO gqr_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Lokɨ ində lo te kɨ taga kɨ rɔ bulə de’gɨ’tɨ ningə, asɨ kadɨ el’de ta el. Lokɨ el’de ta el, gəri kadɨ oo nya me ndil’tɨ me Kəy’tɨ lə Luwə. Jakari el’de ta kɨ ji’ne par, ə isɨ to mbiki be par. ");
INSERT INTO gqr_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Lokɨ tɔlta kulə ningə, təl aw me kəy’tɨ lə’ne. ");
INSERT INTO gqr_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ningə ngayn el go’tɨ, ne’ə Elijabetɨ in səm. Elijabetɨ iyə rɔ’ne kəy, adɨ de oo’ə el, asɨ nanyi mi, ə el ene: ");
INSERT INTO gqr_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","«Oyi majɨ kɨ Burəɓe ra sə’m kin. Burəɓe ində kum’ne go’m’tɨ, ɔr rɔsɔl dɔ’m’tɨ dann de’gɨ’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Me nanyi’tɨ kɨ mehen, Luwə ulə malayka Gabiriyel me ɓebo’tɨ kɨ tɔ’a nan Najaretɨ, dɔnangɨ’tɨ kɨ Galile. ");
INSERT INTO gqr_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ulə rɔ ngonn mandɨ’tɨ madɨ kɨ gər ngaw el ɓay, kɨ dingəm kare kɨ tɔ’a nan Jisepɨ, kɨ ginn kojɨ’tɨ lə *Dabidɨ kɨ njenduwə li’ə. Tɔ ngonn mandɨ kakin nan Mari. ");
INSERT INTO gqr_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Malayka ur kəy go Mari’tɨ el’ə ene: «M’uwə ji’i Mari, in kɨ ingə memajɨ lə Luwə, Burəɓe in nan’tɨ sə’i.» ");
INSERT INTO gqr_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ta kin ətɨ Mari ɓol, adɨ dəjɨ rɔ’ne ta ene ke ginn kuwəji kin in ri wa? ");
INSERT INTO gqr_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Malayka el’ə ene: «Ɓol el Mari, tadɔ ingə majɨ takum Luwə’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","A in sə’m, a ojɨ ngonn kɨ dingəm, a ində tɔ’a nan Jeju. ");
INSERT INTO gqr_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","A in kibo, a ɓari’ə Ngonn lə Njekisɨ dɔ nya’gɨ’tɨ pətɨ. Ningə, Burəɓe Luwə a ad’a kumbər ngar lə kaw’a Dabidɨ. ");
INSERT INTO gqr_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","A onɓe dɔ ginn kojɨ’tɨ lə *Jakobɨ bitɨ kɨ non’tɨ. Ningə Konɓe li’ə a ində ngangɨ’ne el tɔ.» ");
INSERT INTO gqr_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mari el malayka ene: «Gorow kɨ bann ə nya’gɨ kin a rai nya wa? Tadɔ m’gər ngaw el ɓay.» ");
INSERT INTO gqr_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Malayka el’ə ene: «Ndil Luwə a re dɔ’i’tɨ, Njekisɨ dɔ nya’gɨ’tɨ pətɨ a ɓukɨ tɔgɨ’ne dɔ’i’tɨ. In tadɔ kin ə, ngonn kɨ a oj’o in rɔ Luwə’tɨ, a ɓari’ə Ngonn lə Luwə. ");
INSERT INTO gqr_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Oo noj’i Elijabetɨ kɨ ɓugə inɓe kin kaa in sə’m tɔ. In kɨ de’gɨ ɓari’ə kujɨ kaa nyɨ in sə’m ra nanyi mehen kin. ");
INSERT INTO gqr_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","In sə’m tadɔ nya kɨ dum Luwə goto.» ");
INSERT INTO gqr_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mari ene: «M’in ɓər lə Burəɓe, majɨ kadɨ Luwə ra sə’m tokɨ te’n ta’i’tɨ.» Low’ə’tɨ kin, malayka inyə Mari ə ɔtɨ aw. ");
INSERT INTO gqr_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Me ndɔ’gɨ’tɨ kɨ go’tɨ, Mari ində taa, aw kalangɨ kalangɨ kɨ dɔnangɨ kɨ mbal’gɨ in səm’tɨ, me ɓe’tɨ kɨ dɔnangɨ Juda. ");
INSERT INTO gqr_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Aw ur me kəy’tɨ lə Jakari, uwə ji Elijabetɨ. ");
INSERT INTO gqr_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Lokɨ Elijabetɨ oo ndu Mari ningə, Ngonn kɨ me’ə’tɨ ɔdɨ rɔ’ne ndur kutɨ kutɨ. Ningə Ndil Luwə ros’o tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Lo kin’tɨ, Elijabetɨ un ndu’ne kɨ taa, el Mari ene: «Luwə adɨ njangɨ dɔ in dɔ’i’tɨ dann dene’gɨ’tɨ pətɨ. Ningə Ngonn kɨ to me’i’tɨ kaa majɨ ur’ə tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ra bann ə m’in kin par, Luwə ɓukɨ’m’tɨ kədɨ be bitɨ, adɨ kon Ɓe’m re me kəy’tɨ lə’m? ");
INSERT INTO gqr_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Lokɨ m’oo ndu’i kɨ uwə’n ji’m, ngonn kɨ me’m’tɨ ɔdɨ rɔ’ne ndur kɨ rɔnel. ");
INSERT INTO gqr_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","In nje majikur, tadɔ kunme lə’i adɨ nya’gɨ kɨ Burəɓe el’i taa a tɔli ta’de.» ");
INSERT INTO gqr_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Be ə Mari ene: «Ngarme’m osɨ pa ulə tɔjɨ dɔ Burəɓe’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ndil’m ra rɔnel dɔ Luwə’tɨ kɨ Njekajɨ’m. ");
INSERT INTO gqr_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Tadɔ Luwə təl kum’ne oo’n ɓər lə’ne kɨ dene kɨ asɨ nya madɨ el. In be ə, kaw kɨ kete non, De’gɨ pətɨ a ɓari’m’in nje majikur kɨ dɔ lo’gɨ’tɨ kɨ dangɨ dangɨ. ");
INSERT INTO gqr_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Tadɔ Luwə kɨ nje tɔgɨ pətɨ, Ra nya’gɨ kɨ ətɨ ɓol ɓol tadɔ lə’m. Majɨ kadɨ tɔ’a in kɨ kar njay. ");
INSERT INTO gqr_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ningə, kadɨ memajɨ li’ə to kɨ dɔ ɓal’gɨ dɔ ɓal’gɨ dɔ de’gɨ’tɨ kɨ nje ɓol Ndil’ə. ");
INSERT INTO gqr_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Luwə ɔjɨ tɔgɨ’ne pətɨ kɨ taga, Nje kɨ ngarme’de rosɨ kɨ kɔjirɔ, Luwə tində’de sanan’de. ");
INSERT INTO gqr_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Sur njetɔgɨ’gɨ tilə’de dɔ kumbər ngar’gɨ’tɨ lə’de, Ningə nje sɔl dɔ’de, un dɔ’de kɨ taa tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Adɨ nyakingə rosɨ ji njendoo’gɨ, Ə tuwə njenyakingə’gɨ ji’de kare adɨ awi. ");
INSERT INTO gqr_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ɔsɨ kɔy *Isirayel kɨ njekulə li’ə, Adɨ me’ə olo dɔ memajɨ’tɨ tadɔ de’gɨ li’ə. ");
INSERT INTO gqr_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Me’ə olo dɔ’tɨ tokɨ un’n mindɨ’ne adɨ kaw’je’gɨ kete nu. Un adɨ Abiraham kɨ ginn kojɨ li’ə ba bitɨ kɨ non’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mari isɨ kɨ Elijabetɨ asɨ nanyi mutə, ningə təl aw ɓe. ");
INSERT INTO gqr_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Dɔkagilo kojɨ ngonn lə Elijabetɨ asɨ, ə ojɨ ngonn kɨ dingəm. ");
INSERT INTO gqr_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Nje gədɨ kəy’gɨ li’ə kɨ nojɨ’gɨ oyi poy majɨ kɨ Luwə ra si’ə adɨ rai si’ə rɔnel. ");
INSERT INTO gqr_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Lokɨ ndɔ kɨ jijoo go kojɨ ngonn’tɨ asɨ ningə, rei kadɨ ujəi mɔt’ɔ. De’gɨ ndigɨ kadɨ n’ɓari’ə kɨ tɔ baw’a kɨ Jakari. ");
INSERT INTO gqr_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Nan kon’a el’de ene: «Jagɨ, a ɓari’ə Jan.» ");
INSERT INTO gqr_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ə de’gɨ eli Elijabetɨ eyina: «De kɨ ginn kojɨ’tɨ lə’i kɨ tɔ’a to be goto.» ");
INSERT INTO gqr_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Lo kin’tɨ, dəji baw’a ta kɨ ji’de eyina ke ge kadɨ n’ɓari ngonn kakin nan nan wa? ");
INSERT INTO gqr_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Jakari dəjɨ adɨ rei kɨ bar ndangɨ nya adi’ə, ningə ndangɨ nya’tɨ: «Tɔ’a in Jan.» Lo kin’tɨ, ta ndɔjɨ de’gɨ pətɨ. ");
INSERT INTO gqr_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Low’ə’tɨ non, ta Jakari te, ndonn’o tutɨ adɨ elta ulə’n tɔjɨ dɔ Luwə’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Nya kin ra ɓol de’gɨ pətɨ kɨ me ɓe’gɨ’tɨ kɨ dɔ lo’tɨ kɨ non, taa go dɔnangɨ mbal’gɨ’tɨ kɨ Jude pətɨ, de’gɨ eli ta’a kɨ lo lo. ");
INSERT INTO gqr_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","De’gɨ kɨ oyi poyta kin ngəmi me’de’tɨ, ə eli eyina: «Ngonn kin a təl ri wa?» tokɨ rɔta’tɨ, ji Burəɓe in dɔ’a’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ndil Luwə rosɨ Jakari kɨ baw ngonn, adɨ eltakita Luwə’tɨ ene: ");
INSERT INTO gqr_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Tɔjɨ kɨ dɔ Burəɓe’tɨ, kɨ Luwə lə Isirayel, Tadɔ re oo de’gɨ lə’ne, taa’de ilə’de taa. ");
INSERT INTO gqr_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","In ə te kɨ Njekajɨ kɨ nje tɔgɨ ginn kojɨ’tɨ lə Dabidɨ kɨ njekulə li’ə adi’je. ");
INSERT INTO gqr_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Te si’ə tokɨ ilə’n mbər kɨ ta de’gɨ kɨ njekeltakita’a’tɨ ar njay, dɔkagilo’tɨ kɨ mayinu. ");
INSERT INTO gqr_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Njekajɨ kɨ a taa’je ji njeban’gɨ’tɨ lə’je pətɨ, kɨ ji njekɔsɨ’je ta’gɨ’tɨ pətɨ. ");
INSERT INTO gqr_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","In be ə, Luwə tɔjɨ’n memajɨ lə’ne kɨ rɔ kaw’je’gɨ’tɨ, Num taa, me’ə olo dɔ kunmindɨ’tɨ kɨ ar njay num tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Kunmindɨ kigo mində’tɨ kɨ un adɨ kaw’je *Abiraham. ");
INSERT INTO gqr_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Kunmindɨ kɨ a ra kadɨ jɨ ra kulə li’ə kɨ kanjɨ ɓol, Lokɨ a ta’je ji njeban’gɨ’tɨ lə’je. ");
INSERT INTO gqr_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Kadɨ jɨ njiyə takum’ə’tɨ, me kar njay’tɨ num, me kɨ ra dana’tɨ num, Dɔkagilo pətɨ kɨ j’isɨ’n kɨ dɔ’je taa. ");
INSERT INTO gqr_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","In ngonn’m, a ɓari’nu njekeltakita Luwə’tɨ kɨ in nje kisi dɔ nya’gɨ’tɨ pətɨ, Tadɔ a njiyə non Burəɓe’tɨ kadɨ in ra row li’ə. ");
INSERT INTO gqr_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Lo kin’tɨ, de’gɨ li’ə a gəri kajɨ kɨ ajɨ’de kɨ gorow k’inyə go majel’gɨ’tɨ lə’de kɔ. ");
INSERT INTO gqr_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Luwə in nje memajɨ. Kɨ takul memajɨ kɨ koo kumtondoo li’ə ə, Kunjɨ kɨ dɔran’tɨ unjɨ’n dɔ’je’tɨ to kadɨ be. ");
INSERT INTO gqr_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Kunjɨ kin unjɨ dɔ de’gɨ’tɨ kɨ sii me lo kɨ diw’tɨ num, Me ndil koy’tɨ num. Tadɔ kadɨ ndɔr’je tarow, aw se’je dɔ row kisimajɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ngonn kakin tɔgɨ, təl de kɨ gəsirə me ndil’tɨ. Ra ɓe dilə mbo’tɨ, bitɨ ndɔ kɨ te’n taga takum Isirayel’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Dɔkagilo’ə’tɨ kin, nje konɓe kibo Sejar Ogusitɨ un ndu’ne kadɨ ndangitɔ de’gɨ kɨ dɔnangɨ’tɨ pətɨ me makitu’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ndangitɔ kɨ dɔkete kin in dɔkagilo’tɨ kɨ Kiriniwusɨ in nje konɓe dɔnangɨ’tɨ kɨ Siri. ");
INSERT INTO gqr_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","De’gɨ pətɨ awi kadɨ ndangitɔ’de, Nan nan kaa aw ɓe kojɨ’ne’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","In be ə, Jisepɨ kaa in ɓebo Najaretɨ’tɨ, dɔnangɨ Galile’tɨ, isɨ aw ɓebo’tɨ lə Dabidɨ, kɨ ɓari’ə Betilehem, dɔnangɨ Jude’tɨ. Tadɔ Jisepɨ in de kɨ ginn kojɨ’tɨ lə Dabidɨ. ");
INSERT INTO gqr_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Awi kadɨ ndangitɔ’de nan’tɨ kɨ Mari kɨ njenduwə li’ə, kɨ ra kɨ sə’m. ");
INSERT INTO gqr_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Lokɨ in Betilehem’tɨ non ɓay ningə, ndɔ kojɨ ngonn lə Mari asɨ. ");
INSERT INTO gqr_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Mari ojɨ ngonn’ne kɨ dɔkete to ngonn kɨ dingəm. Ɓir ngonn kakin kɨ ku, ilə me nya ngəm nya kusɔ’tɨ lə da’gɨ, tadɔ lo kɨ kadɨ ingəi to’i’tɨ me kəy to mbah’gɨ’tɨ goto. ");
INSERT INTO gqr_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Njekul da’gɨ in me mu’tɨ dɔ lo’tɨ kin non, indəi ɓi taa isɨ ngəmi da’gɨ lə’de kondɔ. ");
INSERT INTO gqr_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ningə nyɨ oyi malayka lə Burəɓe te bus kɨ rɔ’de’tɨ. Tɔjɨ lə Burəɓe unjɨ gugɨ dɔ’de, adɨ ɓol tɔl’de. ");
INSERT INTO gqr_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Nan malayka el’de ene: «Ɓoli el, tadɔ m’re kɨ Poyta kɨ majɨ kadɨ madɨ’se. Poyta kɨ majɨ kin a in nya rɔnel kibo ngayn tadɔ lə de’gɨ pətɨ kɨ dɔnangɨ’tɨ ne. ");
INSERT INTO gqr_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","In ɓone ə oji nje kajɨ me ɓe’tɨ lə Dabidɨ adi’se. Njekajɨ kɨ in Kirisitɨ kɨ in *De kɨ Luwə mbət’ə, Burəɓe. ");
INSERT INTO gqr_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ningə nyakɔjɨ kɨ in a gəri’ə ə to kin: A ingəi ngonn kɨ kasɨ kɨ ɓiri’ə kɨ ku, ə iləi’ə me nya ngəm nya kusɔ’tɨ lə da’gɨ.» ");
INSERT INTO gqr_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Tanan’tɨ non, bulə de’gɨ njerɔ’gɨ kɨ dɔran’tɨ, tei, indəi rɔ’de nan’tɨ kɨ malayka kɨ kare kakin, ningə osi pa piti Luwə eyina: ");
INSERT INTO gqr_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Tɔjɨ in kɨ dɔ Luwə’tɨ kɨ nje kisɨ dɔran’tɨ taa nu. Taa, kisimajɨ kɨ dɔ dɔnangɨ’tɨ, kɨ rɔ de’gɨ’tɨ kɨ Luwə ndigɨ’de tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Lokɨ malayka’gɨ inyəi’de ə təli awi dɔran’tɨ gogɨ, njengəm da’gɨ elinan dann’de’tɨ eyina: «Adɨ j’awi bitɨ kɨ Betilehem’tɨ j’oyi nya kɨ ra nya ə Burəɓe te kɨ dɔ’a adɨ’je kin.» ");
INSERT INTO gqr_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Indəi kalangɨ awi ningə nyɨ, ingəi Mari ingɨ kɨ Jisepɨ, nan’tɨ kɨ ngonn kɨ kasɨ kɨ iləi’ə me nya ngəm nya kusɔ’tɨ lə da’gɨ. ");
INSERT INTO gqr_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Lokɨ oyi ngonn kɨ kasɨ kakin ningə, go’tɨ ɔri ginn nya’gɨ kɨ eli’de ɔjidɔ ngonn kɨ kasɨ kin. ");
INSERT INTO gqr_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","De’gɨ pətɨ kɨ oyi ta kɨ njengəm da’gɨ ɔri go’ə, ətɨ’de ɓol. ");
INSERT INTO gqr_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mari ngəm nya’gɨ kin pətɨ me’ne’tɨ, mərta dɔ’tɨ kigo’ə go’ə. ");
INSERT INTO gqr_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Nje ngəm da’gɨ təli gogɨ kɨ pa, kɨ kulə tɔjɨ dɔ Luwə’tɨ ta’de’tɨ. Tadɔ Luwə adɨ’de oyi nya’gɨ kɨ mbi’de ge, kɨ kum’de ge. Ningə nya’gɨ kakin rai nya kɨ gorow’ə inɓe kɨ malayka ilə’n’de mbər’ə kakin tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Lokɨ ndɔ kɨ nja jijoo go kojɨ ngonn’tɨ asɨ, ujəi mɔt’ɔ, ningə indəi tɔ’a nan Jeju. In tɔ kɨ malayka el’de, lokɨ kon’a ra kɨ səm’ə el ɓay, kadɨ to ɓari’ə’n’ə. ");
INSERT INTO gqr_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ningə, lokɨ ndɔ kɨ in ndɔ kar rɔ kigo ndukun’tɨ lə *Mojɨ asɨ, Jisepɨ ingɨ kɨ Mari ai kɨ ngonn kakin Jerujalem’tɨ kadɨ tɔji’ə Burəɓe, ");
INSERT INTO gqr_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","kigo ndang’a’tɨ kɨ ndangi me ndukun’tɨ lə Burəɓe eyina: «Ngann dər’gɨ kɨ dingəm pətɨ a in kɨ kində ji dɔ’de’tɨ tadɔ lə Burəɓe.» ");
INSERT INTO gqr_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Num taa, rei kadɨ adi’de kərmosɨ’gɨ joo eke ngann dər dum’gɨ joo kadikare’tɨ, kigo ndang’a’tɨ kɨ ndangi me ndukun’tɨ lə Burəɓe. ");
INSERT INTO gqr_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Dingəm kare in Jerujalem non tɔ’a nan Simeyon. In de kɨ dana taa in de kɨ njera go ndigɨ’tɨ lə Luwə tɔ. Isɨ nginə ta nje kajɨ Isirayel mayinu ba. Ningə Ndil Luwə in dɔ’a’tɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ndil Luwə el kete ad’a gər tokɨ a oy el bitɨ kadɨ oo Kirisitɨ De kɨ Burəɓe mbət’ə, kɨ kum’ne ɓay taa a oy. ");
INSERT INTO gqr_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ndil Luwə ɔs’ɔ kadɨ aw me Kəy’tɨ lə Luwə, ningə tokɨ nje kojɨ Jeju awi si’ə me kəy’tɨ kadɨ rai kigo ndukun’tɨ lə Burəɓe. ");
INSERT INTO gqr_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeyon taa Jeju ji’ne’tɨ, ningə ulə tɔjɨ dɔ Luwə ene: ");
INSERT INTO gqr_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«Ngɔsine, Burəɓe, inyə ɓər lə’i ad’a aw kɨ lapiya, kigo ta’tɨ lə’i nga, ");
INSERT INTO gqr_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Tadɔ kankum’m oo njekajɨ de’gɨ nga. ");
INSERT INTO gqr_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Kajɨ kɨ ində dɔ’a dana takum bulə de’gɨ’tɨ pətɨ. ");
INSERT INTO gqr_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","In kunjɨ kɨ kadɨ unjɨ dɔ ginn de’gɨ’tɨ pətɨ, taa a in tɔjɨ kɨ dɔ de’gɨ’tɨ lə’i, Isirayel tɔ.» ");
INSERT INTO gqr_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ta kɨ Simeyon el dɔ Jeju’tɨ ətɨ kon’a’gɨ kɨ baw’a’gɨ ɓol. ");
INSERT INTO gqr_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeyon njangɨ dɔ’de, ningə el Mari ene: «Majɨ kadɨ in gər majɨ, ngonn kɨ oj’o kin a in row kosɨ lə bulə de’gɨ num, row kində taa lə de’gɨ ngayn dɔnangɨ Isirayel’tɨ tɔ. Taa, re to nyakɔjɨ kɨ nje re kɨ takasinan el tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","A adɨ mərta kɨ ngarme de’gɨ’tɨ ngayn, ginn’ə a te taga. Ningə rɔ’i’tɨ inɓe, in kiyərɔ kɨ a gangɨ ndil’i dana.» ");
INSERT INTO gqr_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Dene kare kɨ njekeltakita Luwə’tɨ isɨ non, tɔ’a nan Ann. In ngonn lə Panuwel, ginn kojɨ’tɨ lə Aser. Lokɨ taa dingəm mandɨ’ne’tɨ, isɨ si’ə asɨ ɓal siri ba par ə ngaw’a oy. Ningə kɨ ngɔsine kin, Ann tɔgɨ ngayn nga. ");
INSERT INTO gqr_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ɓal’a in dɔjijoo gidə in sɔ. Njengawkoy kin in me Kəy’tɨ lə Luwə kɨ dɔkagilo’gɨ pətɨ gos’o. Kondɔ kɨ kada in me Kəy’tɨ lə Luwə, el si’ə ta, ɔgɨ rɔ’ne nyakusɔ. ");
INSERT INTO gqr_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","In be ə, dɔkagilo’ə’tɨ kin, in kaa te non re tɔ. Osɨ pa ulə’n tɔjɨ dɔ Luwə’tɨ, taa elta kɨ dɔ ngonn’tɨ kin de’gɨ pətɨ kɨ isɨ nginəi kadɨ Luwə taa Jerujalem ji njeban’gɨ’tɨ ilə taa tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Lokɨ nje kojɨ Jeju rai nya’gɨ pətɨ kigo ndukun’tɨ lə Burəɓe ningə, təli awi Galile me ɓebo’tɨ lə’de kɨ Najaretɨ’tɨ gogɨ. ");
INSERT INTO gqr_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ningə, ngonn kakin tɔgɨ, aw kɨ singə’ne. Rosɨ kɨ tər, taa memajɨ lə Luwə in si’ə nan’tɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Dɔ ɓal’gɨ pətɨ, njekojɨ Jeju awi Jerujalem’tɨ lo ra nanyi’tɨ kɨ ɓari’ə nanyi Pakɨ. ");
INSERT INTO gqr_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Lokɨ Jeju ra ɓal dɔgɨ gidə in joo ningə, aw kɨ nje kojɨ’ne’gɨ lo ra nanyi’tɨ tokɨ sii rai kete kete go kujɨ ra’a’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ningə, lokɨ ndɔ ra nanyi tigə ə, nje kojɨ’gɨ lə Jeju isɨ təli gogɨ, nan Jeju nanyi gogɨ Jerujalem tɨ. Nje koj’o’gɨ gəri tokɨ nanyi gogɨ el. ");
INSERT INTO gqr_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Njekojɨ’gɨ lə Jeju oyi eyina Jeju nanyi nja madɨ’de’gɨ’tɨ kɨ uni se’de row, adɨ njiyəi ndɔ kare ɓay taa uləi ngirə sang’a dann nojɨ’de’gɨ’tɨ kɨ madɨ’de’gɨ. ");
INSERT INTO gqr_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Sangi’ə, nan sangi’ə pi ingəi’ə el. Lokɨ ingəi’ə el, təli tuwi dɔ’de awi Jerujalem’tɨ gogɨ sang’a’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Sangi’ə bitɨ ndɔ kɨ kon mutə ningə nyɨ, ingəi’ə, isɨ me Kəy’tɨ lə Luwə dann njendo ndukun’gɨ lə Luwə. Sɨ dann’de’tɨ, sii ur mbi’ne oo’n ta’gɨ kɨ isɨ eli tɔ, dəjɨ’n’de ta tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","De’gɨ pətɨ kɨ oyi ta kel Jeju kin, nyagər li’ə, kɨ ta kɨ tur li’ə, ətɨ’de ɓol ngayn. ");
INSERT INTO gqr_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Lokɨ njekoj’o’gɨ oyi, ətɨ’de ɓol ngayn, adɨ kon’a el’ə ene: «Ngonn’m, ra bann be in ra se’je nya be wa? Oo, j’in kɨ baw’i, jɨ ra ta sangi’tɨ kɨ non kum’je’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ningə el’de ene: «Sangi m’in tadɔ ri wa? Majɨ kadɨ m’ra kulə me kəy’tɨ lə Bai kin, in gəri eke in gəri el wa?» ");
INSERT INTO gqr_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Nan njekoj’o’gɨ gəri me ta li’ə kin el. ");
INSERT INTO gqr_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ningə go’tɨ, Jeju təl aw se’de Najaretɨ’tɨ gogɨ. Jeju təl rɔ’ne go ta’tɨ lə nje kojɨ’ne’gɨ. Kon’a ngəm nya’gɨ pətɨ kɨ rai nya kin me’ne’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jeju tɔgɨ darɔ’ne’tɨ num, me gosɨ’tɨ num tɔ, adɨ ingə majɨ takum Luwə’tɨ num, takum de’gɨ’tɨ num pətɨ. ");
INSERT INTO gqr_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Dɔkagilo’ə’tɨ kin, nje konɓe kibo Sejar, kɨ ɓari’ə Tiber onɓe ɓal dɔgɨ gidə in mi. Ningə Ponsɨ *Pilatɨ ə in nje konɓe dɔnangɨ’tɨ kɨ Juda, Erodɨ in ngar dɔnangɨ’tɨ kɨ Galile, Pilipɨ kɨ ngonnkon Erodɨ in ngar dɔnangɨ’tɨ kɨ Iture kɨ dɔnangɨ kɨ Tirakonitidɨ, ningə Lisaniyasɨ in ngar dɔnangɨ’tɨ kɨ Abilen tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Hann ingɨ kɨ Kayipɨ ə in kibo’gɨ lə njekujənyamosɨ kadikare’gɨ kɨ rai kulə dɔkagilo’ə’tɨ non. Ningə, dɔkagilo’ə’tɨ non kin, Jan kɨ ngonn lə Jakari in diləlo’tɨ ə Luwə el’ə ta. ");
INSERT INTO gqr_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Jan aw dɔnangɨ Jurden’tɨ pətɨ, iləmbər ene: «Inyəi gorow njiyə’se’gɨ kɨ majel kɔ, adɨ rai’se batəm, kadɨ Luwə inyə’n go majel’gɨ lə’se kɔ.» ");
INSERT INTO gqr_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ra tokɨ ndangi me makitu’tɨ lə njekeltakita Luwə’tɨ, Ejay, eyina: «Ndu de madɨ ɓar diləlo’tɨ ene: Rai gorow lə Burəɓe! Rai gorow li’ə adɨ ra njururu. ");
INSERT INTO gqr_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Uti bolo ɓe’gɨ adɨ asɨ nan, Kusi dɔ mbal’gɨ kɨ dɔ gadi’gɨ adɨ asi ta nangɨ rerere; Rai row’gɨ kɨ rugɨ gondi gondi adɨ ra njururu; Rai row wor’gɨ adɨ osɨ nan’tɨ lay. ");
INSERT INTO gqr_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Lo kin’tɨ, de’gɨ pətɨ a gəri kajɨ kɨ Luwə ajɨ’je.» ");
INSERT INTO gqr_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Jan el bulə de’gɨ kɨ rei rɔ’a’tɨ kadɨ ra’de batəm ene: «In nje mann majel to lii pir be kam, nan ɔjɨ’se row kadɨ anyinan wongɨ lə Luwə kɨ a re wa? ");
INSERT INTO gqr_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Majɨ kadɨ kulə ra’se’gɨ tɔjɨ kadɨ in de’gɨ kɨ inyəi gorow njiyə’se’gɨ kɨ majel kɔ. Ningə, ononyi’se kadɨ eli me’se’tɨ eyina: “J’in ngann kaw Abiraham”. Tadɔ adɨ m’el’se, Luwə asɨ kadɨ a təl gajɨ mbal’gɨ kam ngann kaw Abiraham’tɨ kare. ");
INSERT INTO gqr_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Kɨ ngɔsine kin, kungə in ndəkba kadɨ tugə kagɨ’gɨ ngirə de’tɨ. Kagɨ kɨ ra kɨ andɨ majɨ el ə, a tugəi’ə kadɨ iləi’ə me por’tɨ kɔ.» ");
INSERT INTO gqr_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Bulə de’gɨ dəji Jan eyina: «In ri ə kadɨ jɨ ra wa?» ");
INSERT INTO gqr_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Jan el’de ene: «De kɨ aw kɨ ku joo ə, majɨ kadɨ adɨ kare de kɨ awɨ’n el, ningə de kɨ aw kɨ nyakusɔ ə, majɨ kadɨ ra’n kɨ in kɨ awɨ’n el tɔ.» ");
INSERT INTO gqr_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","*Njetalambo’gɨ kaa, rei kadɨ Jan ra’de batəm tɔ. Ningə dəji Jan eyina: «Njendo, in ri ə kadɨ jɨ ra wa?» ");
INSERT INTO gqr_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Jan el’de ene: «Tai nar aldɔ in kɨ dəji’se kadɨ tai kin el.» ");
INSERT INTO gqr_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Njerɔ’gɨ kaa dəji eyina: «Nga j’in, in ri ə kadɨ jɨ ra wa?» Jan el’de ene: «Indəi tɔgɨ dɔ de’tɨ tai nar li’ə el, ta, təti ta ngom indəi dɔ’a’tɨ el tɔ. Rai dɔ nar nanyi’tɨ lə’se inɓe kin par.» ");
INSERT INTO gqr_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Dɔkagilo’ə’tɨ kin, de’gɨ isɨ nginəi de kɨ a re, adɨ dəji rɔ’de ta ke Jan in Kirisitɨ kɨ in De kɨ Luwə mbət’ə el bitɨ wa? ");
INSERT INTO gqr_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ə Jan el de’gɨ pətɨ ene: «M’in, m’ra’se batəm me mann’tɨ, nan de madɨ a re go’m’tɨ non, a ra’se batəm me Ndil Luwə, kɨ me por’tɨ. In de kɨ Tɔg’ɔ utə’m sanyi kulə sa li’ə kaa, m’asɨ tutɨ el. ");
INSERT INTO gqr_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Uwə keh to nya ji’ne’tɨ kadɨ to’n kandɨ ko kɨ majɨ, ɔy me dam’tɨ, ningə ulə tisə por. In por kɨ a oy el ratata.» ");
INSERT INTO gqr_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jan adɨ de’gɨ ta kɔjɨ’gɨ kɨ rangɨ ngayn, iləmbər Poyta kɨ majɨ. ");
INSERT INTO gqr_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Nya kare ɓay, Jan kɔl kɨ Erodɨ kɨ in nje konɓe dɔnangɨ’tɨ kɨ Galile, tadɔ taa kɨ taa Erodiyadɨ kɨ ne ngonnkon’ne, taa ra nya’gɨ kɨ rangɨ kɨ majel ngayn num tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Nan, nya’gɨ kɨ go’tɨ el pətɨ kɨ Erodɨ ra kin kaa, təl uwə Jan dangay’tɨ dɔ’tɨ ɓay. ");
INSERT INTO gqr_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Lokɨ de’gɨ pətɨ rai batəm ningə, Jeju kaa ra batəm tɔ. Lokɨ isɨ elta kɨ Luwə ningə, dɔran til. ");
INSERT INTO gqr_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ndil Luwə, risɨ to dər dum be isɨ dɔ’a’tɨ. Ningə, ndu ta madɨ te dɔran’tɨ, ene: «In Ngonn’m kɨ njendigɨ lə’m, kɨ in nya rɔnel lə’m kibo ngayn.» ");
INSERT INTO gqr_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jeju ulə ngirə kulə lə’ne, lokɨ ɓal’a in dɔ mutə. Kɨ go gər’ə’tɨ kɨ de’gɨ gəri, Jeju in ngonn lə Jisepɨ, Jisepɨ kɨ ngonn lə Eli, ");
INSERT INTO gqr_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Ningə Eli in ngonn lə Mata, Mata in ngonn lə *Lebi, Lebi in ngonn lə Melsi, Melsi in ngonn lə Yanay, Yanay in ngonn lə Jisepɨ, ");
INSERT INTO gqr_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Jisepɨ in ngonn lə Matatiyasɨ, Matatiyasɨ in ngonn lə Amosɨ, Amosɨ in ngonn lə Nahum, Nahum in ngonn lə Esili, Esili in ngonn lə Nagay, ");
INSERT INTO gqr_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagay in ngonn lə Matɨ, Matɨ in ngonn lə Matatiyasɨ, Matatiyasɨ in ngonn lə Semeyinn, Semeyinn in ngonn lə Yosəkɨ, Yosəkɨ in ngonn lə Yoda, ");
INSERT INTO gqr_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda in ngonn lə Yowanan, Yowanan in ngonn lə Resa, Resa in ngonn lə Jorobabel, Jorobabel in ngonn lə Salatiyel, Salatiyel in ngonn lə Neri, ");
INSERT INTO gqr_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri in ngonn lə Melki, Melki in ngonn lə Adi, Adi in ngonn lə Kosam, Kosam in ngonn lə Elmadam, Elmadam in ngonn lə Er, ");
INSERT INTO gqr_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er in ngonn lə Jeju, Jeju in ngonn lə Eliyəjar, Eliyəjar in ngonn lə Yorim, Yorim in ngonn lə Mata, Mata in ngonn lə Lebi, ");
INSERT INTO gqr_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lebi in ngonn lə Simeyon, Simeyon in ngonn lə Juda, Juda in ngonn lə Jisepɨ, Jisepɨ in ngonn lə Yonam, Yonam in ngonn lə Eliyakim, ");
INSERT INTO gqr_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliyakim in ngonn lə Meleya, Meleya in ngonn lə Mena, Mena in ngonn lə Matata, Matata in ngonn lə Natan, Natan in ngonn lə Dabidɨ, ");
INSERT INTO gqr_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dabidɨ in ngonn lə Jese, Jese in ngonn lə Obedɨ, Obedɨ in ngonn lə Bowajɨ, Bowajɨ in ngonn lə Sala, Sala in ngonn lə Nason, ");
INSERT INTO gqr_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason in ngonn lə Aminadabɨ, Aminadabɨ in ngonn lə Adimin, Adimin in ngonn lə Arni, Arni in ngonn lə Esirom, Esirom in ngonn lə Peresɨ, Peresɨ in ngonn lə Juda, ");
INSERT INTO gqr_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda in ngonn lə Jakobɨ, Jakobɨ in ngonn lə *Isakɨ, Isakɨ in ngonn lə Abiraham, Abiraham in ngonn lə Tera, Tera in ngonn lə Nawor, ");
INSERT INTO gqr_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nawor in ngonn lə Serugɨ, Serugɨ in ngonn lə Rewu, Rewu in ngonn lə Pelegɨ, Pelegɨ in ngonn lə Eber, Eber in ngonn lə Sala, ");
INSERT INTO gqr_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala in ngonn lə Kaynam, Kaynam in ngonn lə Arpasadɨ, Arpasadɨ in ngonn lə Səm, Səm in ngonn lə Nuwe, Nuwe in ngonn lə Lemekɨ, ");
INSERT INTO gqr_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lemekɨ in ngonn lə Matusalem, Matusalem in ngonn lə Enɔkɨ, Enɔkɨ in ngonn lə Yərədɨ, Yərədɨ in ngonn lə Malelel, Malelel in ngonn lə Kaynam, ");
INSERT INTO gqr_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kaynam in ngonn lə Enosɨ, Enosɨ in ngonn lə Setɨ, Setɨ kɨ ngonn lə Adam, Adam kɨ ngonn lə Luwə. ");
INSERT INTO gqr_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Go Ndil Luwə’tɨ kɨ rosɨ Jeju, Jeju təl ta ba Jurden’tɨ re. Təl re ningə, Ndil Luwə ɔr’ɔ aw si’ə diləlo’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Su nan’a ndɔ dɔsɔ diləlo’tɨ. Ndɔ kɨ Jeju ra dɔsɔ kin, sɔ nya madɨ el, adɨ ɓo ra’a. ");
INSERT INTO gqr_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Non be, Su el’ə ene: «Re in Ngonn lə Luwə ə, adɨ mbal kin təl mapa adɨ m’oo.» ");
INSERT INTO gqr_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ə Jeju təl el’ə ene: «Ndangi me makitu’tɨ lə Luwə eyina: De a isɨ kɨ dɔ’ne taa kɨ takul nyakusɔ par el.» ");
INSERT INTO gqr_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Su aw kɨ Jeju dɔ lo’tɨ taa, ningə kɨ kum kɨ kində jipɨ, ɔj’ɔ konɓe’gɨ kɨ dɔnangɨ’tɨ ne pətɨ ad’a oo. ");
INSERT INTO gqr_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Lokɨ ɔj’ɔ ningə, təl el’ə ene: «M’a m’ad’i tɔgɨ dɔ konɓe’gɨ’tɨ kin kɨ nyakingə’gɨ kɨ me’tɨ pətɨ. Tadɔ in nya kɨ adi’m’in me ji’m’tɨ, ningə de kɨ me’m ndigɨ ə m’ad’a. ");
INSERT INTO gqr_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Re in, ɔsɨ məkəs’i nanga non’m’tɨ ə, m’a m’ad’i ba pətɨ to yan’i.» ");
INSERT INTO gqr_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jeju təl el’ə ene: «Ndangi me makitu’tɨ lə Luwə eyina: “A ɔsikurə Burəɓe Luwə’tɨ lə’i, ningə in kɨ kar’ne ba par ə a re non’a’tɨ kadɨ gos’o.”» ");
INSERT INTO gqr_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Go’tɨ gogɨ, Su aw kɨ Jeju Jerujalem’tɨ, aw si’ə jam dɔ Kəy’tɨ lə Luwə taa. Lokɨ aw si’ə taa, ningə el’ə ene: «Re in Ngonn lə Luwə ə, inyə ji’i taa osɨ adɨ m’oo, ");
INSERT INTO gqr_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","tadɔ ndangi me makitu’tɨ lə Luwə eyina: “Luwə a adɨ ndu’ne malayka’gɨ lə’ne kadɨ to indəi kum’de go’i’tɨ.” ");
INSERT INTO gqr_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ɓay taa, a lai’nu dala ji’de’tɨ, kadɨ nja’i tugə mbal el.» ");
INSERT INTO gqr_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jeju təl el’ə ene: «Ndangi me makitu’tɨ lə Luwə eyina: A mbɔjɨ Burəɓe Luwə lə’i oo el.» ");
INSERT INTO gqr_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Lokɨ Su tigə kɨ nyanan’gɨ kɨ kadɨ n’nan’n Jeju ningə, ɔr rɔ’ne gogɨ sanyi rɔ’a’tɨ. Ɔr rɔ’ne nginə’n dɔkagilo kɨ rangɨ. ");
INSERT INTO gqr_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Lo kin’tɨ, Jeju təl re Galile. Re kɨ tɔgɨ kɨ in rɔ Ndil Luwə’tɨ. Tɔ Jeju ɓar kɨ dɔ lo’gɨ kɨ non pətɨ. ");
INSERT INTO gqr_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ndo nya me kəykawnan’tɨ lə *Juwipɨ’gɨ. De’gɨ pətɨ uləi tɔjɨ dɔ’a’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jeju aw Najaretɨ’tɨ, kɨ in ɓe kɨ tɔgɨ’tɨ. Tokɨ isɨ ra’n kete kete, lokɨ ndɔ kɔrkon asɨ ningə, Jeju aw kəykawnan’tɨ lə Juwipɨ’gɨ. Jeju ində taa kadɨ n’tudə makitu. ");
INSERT INTO gqr_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Lokɨ ində taa, adi’ə makitu lə njekeltakita Luwə’tɨ Ejay kɨ koi. Jeju rirə makitu kakin ningə, ingə ta kɨ ndangi eyina: ");
INSERT INTO gqr_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«Ndil Burəɓe in dɔ’m’tɨ, Burəɓe mbətɨ’m kadɨ m’iləmbər Poyta kɨ majɨ njendo’gɨ. Burəɓe ulə’m kadɨ m’el dangay’gɨ ta te’de kəy dangay’tɨ, Kadɨ m’el njekumtɔ’gɨ tokɨ, kum’de a oo lo. Kadɨ m’taa nje kɨ de’gɨ isɨ indəi kum’de ndoo m’ilə’de taa. ");
INSERT INTO gqr_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Kadɨ m’iləmbər ɓal memajɨ lə Burəɓe kin.» ");
INSERT INTO gqr_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Go’tɨ, Jeju ko makitu kakin, ningə təl’n adɨ njekulə, ə isɨ nanga kadɨ elta. De’gɨ pətɨ kɨ me kəykawnan’tɨ lə Juwipɨ’gɨ ɓuki kum’de kɨ dɔ’a’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Lo kin’tɨ, Jeju el’de ene: «Ta kɨ oyi kin, tɔlta’ne dɔ’se’tɨ ɓone.» ");
INSERT INTO gqr_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","De’gɨ pətɨ manyinajɨ lə Jeju, taa mbər memajɨ kɨ te ta’a’tɨ ətɨ’de ɓol kɨ dum tɔ adɨ elinan eyina: «M’a in ngonn lə Jisepɨ rɔ’je’tɨ ne el wa?» ");
INSERT INTO gqr_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Be ə Jeju el’de ene: «M’gər kadɨ a eli’m’in kujita kɨ ene: “In njera de’gɨ monyi, ajɨ rɔ’i inɓe,” kin. A eli’m’in eyina: “J’oo poy nya’gɨ pətɨ kɨ in ra Kapernayim’tɨ kin, ə in ra ɓe kojɨ’tɨ ne be tɔ adɨ j’oo.”» ");
INSERT INTO gqr_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Jeju təl el’de ɓay ene: «Tokɨ rɔta’tɨ adɨ m’el’se, njekeltakita Luwə’tɨ, kɨ ɓekoj’o uwə rɔ’ne’tɨ majɨ goto. ");
INSERT INTO gqr_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Kɨ rɔta’tɨ, dɔkagilo’tɨ lə njekeltakita Luwə’tɨ Eli, njengawkoy’gɨ in ngayn Isirayel’tɨ. Nan lokɨ ndi ədɨ dɔnangɨ’tɨ el ɓal mutə kɨ nanyi mehen, ə ɓo on kɨ dɔnangɨ pətɨ, ");
INSERT INTO gqr_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","de kare dann’de’tɨ kɨ Luwə ulə Eli rɔ’a’tɨ goto. In njengawkoy kɨ Sarepta’tɨ, dɔnangɨ kɨ Sidon’tɨ yo ə Luwə ulə Eli kɨ rɔ’a’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Njebanjɨ’gɨ kaa in ngayn Isirayel’tɨ dɔkagilo’tɨ lə Elije tɔ, nan in kɨ kare kɨ kadɨ Luwə ɔr banjɨ rɔ’a’tɨ ar njay goto. In Naman kɨ Siri’tɨ yo ə Luwə ɔr banjɨ rɔ’a’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Lokɨ de’gɨ kɨ sii me kəykawnan’tɨ lə Juwipɨ’gɨ oyi ta kin, wongɨ tɔl’de pətɨ. ");
INSERT INTO gqr_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Lo kin’tɨ, indəi taa tuwəi Jeju me ɓebo’tɨ kɔ, ningə ai si’ə jam dɔ mbal’tɨ kɨ indəi ɓebo’tɨ. Rai’tɨ si’ə kadɨ n’suri’ə n’iləi’ə n’tɔli’ə kɔ. ");
INSERT INTO gqr_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Nan Jeju ur dann’de’tɨ aw. ");
INSERT INTO gqr_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jeju aw Kapernayim’tɨ, kɨ in ɓebo kɨ dɔnangɨ Galile’tɨ. Jeju ndo nya de’gɨ ndɔ kɔrkon’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Nyando li’ə ətɨ de’gɨ ɓol kɨ dum. Ətɨ’de ɓol kɨ dum tadɔ elta kɨ tɔgɨ kɨ in rɔ Luwə’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ningə, de madɨ kare kɨ ndil kɨ majel ra’a, isɨ me kəykawnan’tɨ lə Juwipɨ’gɨ non, non kɨ ndu’ne kibo ene: ");
INSERT INTO gqr_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«Jeju kɨ Najaretɨ, ri ə ge rɔ’je’tɨ wa? Re kadɨ tujɨ’je wa? M’gər’i majɨ: in kɨ Kar njay lə Luwə.» ");
INSERT INTO gqr_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jeju ndangɨ ndil kɨ majel kɨ tɔgɨ’ne ene: «Utɨ ta’i, ə te kɔ rɔ dingəm’tɨ kin.» Lo kin’tɨ, ndil kɨ majel bi dingəm ilə dann’de’tɨ, ningə te rɔ’a’tɨ um ad’a kon madɨ kare el. ");
INSERT INTO gqr_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Nya kin ətɨ de’gɨ pətɨ ɓol, adɨ dəji nan ta dann’de’tɨ eyina: «Ta kin in ta kɨ bann ə ətɨ ɓol be wa? De kam aw kɨ tɔgɨ konɓe dɔ ndil’gɨ’tɨ kɨ majel, ndangɨ’de kɨ tɔgɨ kɨ in rɔ Luwə’tɨ adɨ tei kɔ!» ");
INSERT INTO gqr_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","In be ə, tɔjɨ lə Jeju sanan kɨ dɔnangɨ kɨ non pətɨ. ");
INSERT INTO gqr_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Lokɨ Jeju in kəykawnan’tɨ lə Juwipɨ’gɨ, aw me kəy’tɨ lə Simon. Məm Simon kɨ dene, rɔ’a tingə ngayn. Be ə, dəji Jeju kadɨ ra nya madɨ tadɔ li’ə. ");
INSERT INTO gqr_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jeju rugɨ rɔ’ne dɔ’a’tɨ, ndangɨ rɔ kɨ tingə ngayn kakin adɨ yokiro. Kalangɨ ba go’tɨ, məm Simon ində taa ra nyakusɔ adɨ’de. ");
INSERT INTO gqr_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Lo sɔl’ɔ, go kurkadɨ’tɨ, de’gɨ pətɨ kɨ awi kɨ de’gɨ kɨ monyi’gɨ kɨ dangɨ dangɨ rai’de, rei se’de rɔ Jeju’tɨ. Jeju ində ji’ne dɔ’de’tɨ kare kare pətɨ adɨ ingəi lapiya. ");
INSERT INTO gqr_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ndil’gɨ kɨ majel kaa tei rɔ de’gɨ’tɨ ngayn kɨ non ta’de’tɨ eyina: «In Ngonn lə Luwə!» Nan Jeju ndangɨ’de kɨ tɔgɨ kɨ ngan ngayn, adɨ’de tarow kadɨ eli ta’a el, tadɔ gəri’ə ɓətɨ kadɨ in Kirisitɨ, De kɨ Luwə mbət’ə. ");
INSERT INTO gqr_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Lokɨ lo ti, Jeju te me ɓebo’tɨ aw diləlo’tɨ. Bulə de’gɨ ngayn sangi’ə, awi ingəi’ə. Lokɨ ingəi’ə, ndigɨ kadɨ n’uwəi’ə nanga rɔ’de’tɨ kadɨ to aw lo el. ");
INSERT INTO gqr_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Nan Jeju el’de ene: «Majɨ kadɨ m’iləmbər Poyta kɨ majɨ kɨ ɔjidɔ Konɓe lə Luwə ndəgɨ ɓebo’gɨ’tɨ tɔ, tadɔ in ta kin ə Luwə ulə’m.» ");
INSERT INTO gqr_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","In be ə, Jeju ndo ta me kəykawnan’gɨ’tɨ lə Juwipɨ’gɨ dɔnangɨ Galile’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ndɔ kare, lokɨ Jeju in sanyi el kɨ kadɨ babo’tɨ kɨ Genejaretɨ’tɨ. Bulə de’gɨ uwəi nan: a gugi gidə kadɨ n’oyi ta lə Luwə. ");
INSERT INTO gqr_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Lo kin’tɨ, Jeju oo to’gɨ joo kɨ sii ngangɨ ba’tɨ. In to’gɨ kɨ mbaw’gɨ kɨ me’tɨ indəi’de ə ai to togi bandɨ’gɨ lə’de. ");
INSERT INTO gqr_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jeju ala me to’tɨ kɨ kare kɨ in yan Simon, ningə el Simon ad’a inyə ngangɨ ba ə aw kɨ dana nden. Go’tɨ, Jeju isɨ nanga me to’tɨ ndo nya bulə de’gɨ. ");
INSERT INTO gqr_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Lokɨ elta tigə ningə, el Simon ene: «Aw kɨ dana lo’tɨ kɨ mann ur’tɨ, ə iləi bandɨ’gɨ lə’se uwəi kanjɨ’gɨ» ");
INSERT INTO gqr_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simon təl el’ə ene: «Burəɓe, j’ilə bandɨ kondɔ’tɨ bitɨ lo ti, nan kanjɨ kare kaa j’ingə el. Nan tokɨ in in ə dəjɨ’m, m’a m’ilə bandɨ tokɨ el’m.» ");
INSERT INTO gqr_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Lokɨ iləi bandɨ’gɨ lə’de, ɔyi kanjɨ kɔy kɨ ətɨ ɓol, adɨ bandɨ’gɨ lə’de kaa ge gangɨ. ");
INSERT INTO gqr_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Lo kin’tɨ, dəji madɨ’de’gɨ kɨ in me to’tɨ kɨ nungɨ kadɨ rei rai se’de. Madɨ’de’gɨ rei, adɨ ɔyi kanjɨ kakin rosɨ to’gɨ kɨ joo. Kanjɨ rosɨ to’gɨ adɨ to’gɨ ai to nduyi mann. ");
INSERT INTO gqr_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Lokɨ Simon Piyər oo nya kin, osɨ, ɔsɨ məkəsi’ne nanga non Jeju’tɨ el’ə ene: «Burəɓe, ɔsɨ rɔ’i ngərəngɨ rɔ’m’tɨ, tadɔ m’in njeramajel.» ");
INSERT INTO gqr_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simon kɨ mad’a’gɨ kɨ in si’ə, ɓol ra’de ɔjɨ go kanjɨ kɨ ɔyi me bandɨ’tɨ əti ɓol ngayn. ");
INSERT INTO gqr_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Jakɨ kɨ Jan kɨ ngann lə Jebede kɨ in madɨ nan kɨ Simon kaa ɓol ra’de tɔ. Jeju el Simon ene: «Adɨ ɓol rai el, kaw kɨ kete non, in de’gɨ nga ə a sangɨ’de.» ");
INSERT INTO gqr_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Lo kin’tɨ, təli rei kɨ to’gɨ ngangɨ ba’tɨ, ningə inyəi nya’gɨ pətɨ ə uni go Jeju. ");
INSERT INTO gqr_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ndɔ kɨ rangɨ, Jeju in me ɓebo’tɨ kare, ningə dingəm kare kɨ banjɨ rosɨ rɔ’a te non re. Lokɨ oo Jeju ningə, osɨ kɨ takum’ne nanga non’a’tɨ, non kɨ dɔ’a’tɨ ene: «Burəɓe re in ndigɨ ə a adɨ banjɨ lə’m ur, kadɨ rɔ’m ar njay.» ");
INSERT INTO gqr_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jeju ulə ji’ne ɔdɨ’n’ə ningə el’ə ene: «M’ndigɨ ə, kadɨ banjɨ lə’i ur adɨ rɔ’i ar njay.» Ningə tanan’tɨ non par ə banjɨ ur adɨ rɔ’a ar njay. ");
INSERT INTO gqr_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Go’tɨ, Jeju ad’a ndu’ne ene: «Ononyi kadɨ elta’a de madɨ ə aw ɔjɨ rɔ’i njekujənyamosɨ kadikare, ningə adɨ kadikare kujənyamosɨ kar rɔ tokɨ ndukun lə Mojɨ dəjɨ’n. Ra be kadɨ gəri tokɨ banjɨ lə’i ur adɨ ingə lapiya.» ");
INSERT INTO gqr_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Tɔɓar lə Jeju sanan kɨ lo lo adɨ de’gɨ rei kadɨ n’oyi ta li’ə ge kadɨ ajɨ’n’de dɔ monyi’gɨ’tɨ lə’de ge. ");
INSERT INTO gqr_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Nan Jeju ɔr rɔ’ne aw lo’gɨ’tɨ kɨ to dilə tadɔ kelta kɨ Luwə. ");
INSERT INTO gqr_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ndɔ kare Jeju isɨ ndo nya de’gɨ ningə, *Parisɨ’gɨ kɨ njendo ndukun’gɨ lə Luwə sii dann de’gɨ’tɨ non tɔ. De’gɨ in kɨ ngann ɓe’gɨ pətɨ kɨ dɔnangɨ Galile’tɨ, kɨ dɔnangɨ Jude, kɨ ɓebo Jerujalem. Burəɓe ɔjɨ tɔgɨ’ne me kajɨ nje monyi’gɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Lo kin’tɨ, de’gɨ madɨ oti de kare kɨ rɔ’a oy njururu me nya kotɨ njemonyi’gɨ’tɨ rei si’ə rɔ Jeju’tɨ. Sangi row kadɨ n’awi si’ə kəy n’iləi’ə non Jeju’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Nan gəri row kɨ kadɨ awi si’ə el, tadɔ de’gɨ in ngayn. Be ə, alai taa, rai bolo dɔ kəy’tɨ ningə, tuyi njemonyi kɨ nya kotɨ njemonyi’gɨ kɨ kulə, iləi’ə dann bulə de’gɨ’tɨ non Jeju’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Lokɨ Jeju oo kunme lə’de ningə, el dingəm ene: «Majel’gɨ lə’i in kɨ k’inyə go kɔ.» ");
INSERT INTO gqr_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Njendo ndukun’gɨ lə Luwə kɨ Parisɨ’gɨ iləi rɔ’de mərita ningə eli eyina: «De’ə kam in nan ə elta kɨ mal dɔ Luwə’tɨ be wa? Luwə kɨ kar’ne ba par ə asɨ k’inyə go majel’gɨ lə de’gɨ kɔ. De kɨ rangɨ goto.» ");
INSERT INTO gqr_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jeju gər mərta’gɨ lə’de kɨ me’de’tɨ adɨ el’de ene: «Tadɔ ri ə isɨ mərita kɨ be kin me’se’tɨ wa? ");
INSERT INTO gqr_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Nya kɨ ra ə ngan ngayn el wa? Kel de kin kene: “Majel’gɨ lə’i in kɨ k’inyə go kɔ” ə ngan ngayn el eke kel’ə kene “Ində taa ə njiyə ə ngan ngayn el wa?” ");
INSERT INTO gqr_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Re in be ə, m’a m’ɔjɨ’se kadɨ in gəri tokɨ m’in Ngonn De, m’aw kɨ tɔgɨ dɔnangɨ’tɨ ne, kadɨ m’inyə’n go majel’gɨ lə de’gɨ kɔ.» Ningə, Jeju el njerɔkoy njururu ene: «Ində taa, un tuwə lə’i, ə aw ɓe.» ");
INSERT INTO gqr_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Tanan’tɨ non, dingəm kakin ində taa takum de’gɨ’tɨ pətɨ, un tirə kɨ kete to’tɨ, ə te aw ɓe kɨ kulə tɔjɨ dɔ Luwə’tɨ ta’ne’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","De’gɨ pətɨ, nya kin ətɨ’de ɓol adɨ uləi tɔjɨ dɔ Luwə’tɨ. Ɓol rosɨ me’de adɨ eli eyina: «J’oo nya kɨ mbah ɓone.» ");
INSERT INTO gqr_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Go’tɨ Jeju te ningə nyɨ oo de kare kɨ njetalambo kadɨ nje konɓe’gɨ kɨ ɓari’ə Lebi isɨ me kəy taa lambo’tɨ. Lokɨ oo Lebi ningə el’ə ene: «Un go’m.» ");
INSERT INTO gqr_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ningə Lebi inyə nya’gɨ pətɨ ə ində taa un go Jeju. ");
INSERT INTO gqr_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Go’tɨ, Lebi ra nyakusɔ kibo ngayn me kəy’tɨ lə’ne ɓarɨ’n Jeju. Lo nyakusɔ’tɨ kin, njetalambo’gɨ kɨ ndəgɨ de’gɨ kɨ rangɨ in se’de nan’tɨ non. ");
INSERT INTO gqr_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Parisɨ’gɨ kɨ njendo ndukun’gɨ lə’de ɓarita, eli njendo’gɨ li’ə eyina: «Ra bann ə isɨ sɔi nya ge anyinan nya ge kɨ njetalambo’gɨ kɨ ndəgɨ njeramajel’gɨ wa?» ");
INSERT INTO gqr_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jeju un ta el’de ene: «In de’gɨ kɨ njemonyi’gɨ ə a sangi de kɨ njera de monyi, um in nje rɔ ngan’gɨ ə a sangi de kɨ njera de monyi el. ");
INSERT INTO gqr_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ningə, m’re tadɔ ɓar de’gɨ kɨ dana el, nan m’re tadɔ ɓar de’gɨ kɨ njeramajel’gɨ yo kadɨ inyəi gorow njiyə’de kɨ majel.» ");
INSERT INTO gqr_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Nje kɨ madɨ’gɨ eli Jeju eyina: «Taa taa, njendo’gɨ lə Jan Batisɨ in kɨ njendo’gɨ lə Parisɨ’gɨ isɨ ɔgɨ rɔ’de nyakusɔ taa isɨ elita kɨ Luwə tɔ, ə nje kɨ yan’i’gɨ isɨ sɔi nya ge, anyinan mann ge.» ");
INSERT INTO gqr_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ə Jeju el’de ene: «Ke de’gɨ kɨ ɓari’de lo nyakusɔ tanan’tɨ a ɔgɨ rɔ’de nyakusɔ kɨ mann kanyi wa? Dɔkagilo kɨ nje taa dene isɨ’n se’de nan’tɨ kin, asi kɔgɨ rɔ’de nyakusɔ el.» ");
INSERT INTO gqr_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ndɔ’gɨ a re non kadɨ a uni’ə ta’de’tɨ ningə to, a ɔgɨ rɔ’de nyakusɔ. ");
INSERT INTO gqr_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jeju el’de kujita kare ene: «De a gangɨ ta ku kɨ sigɨ kadɨ ilə’n kum in kɨ kɔkɔ el. Re in be ə, ku kɨ sigɨ in kɨ gangɨ kɔ, ningə ta ku kɨ sigɨ kakin uwəi nan kɨ kɨ kɔkɔ el ɓay tɔ, adɨ joo pətɨ təl nya kɨ tujɨ. ");
INSERT INTO gqr_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Taa de a un yiwi kandɨ nju kɨ in el ɓay utɨ me mbu ndar’gɨ’tɨ kɨ kɔkɔ el. Re in be ningə, lokɨ yiwi a in ningə mbu ndar’gɨ a nduwi, kadɨ yiwi lo kɔ. Ningə mbu ndar’gɨ təli nya kɨ tujɨ kɔ. ");
INSERT INTO gqr_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Be ə, re yiwi kandɨ nju in el ɓay ningə, majɨ kadɨ mbu ndar’gɨ in kɨ sigɨ taa. ");
INSERT INTO gqr_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Lokɨ de anyi yiwi kandɨ nju kɨ in mayinu ningə, a ge in kɨ in ngɔsine ɓay el nga. Tadɔ de’gɨ eli eyina: “Yiwi kɨ in mayinu ə majɨ”.» ");
INSERT INTO gqr_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ndɔ kare Jeju ra dər me ndɔɔ geme’gɨ’tɨ. In ndɔ kɔrkon lə Juwipɨ’gɨ. Ningə, njendo’gɨ li’ə kɨ in si’ə, gangi dɔ ko’gɨ ji’de’tɨ təmi sɔi. ");
INSERT INTO gqr_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Parisɨ’gɨ madɨ eli’de eyina: «Ra bann ə rai nya kɨ kadɨ de ra ndɔ kɔrkon’tɨ el be wa?» ");
INSERT INTO gqr_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jeju el’de ene: «Ingɨ tudəi nya kɨ ngar Dabidɨ ra lokɨ ɓo ra’a kɨ de’gɨ kɨ go’ə’tɨ kin adɨ gəri majɨ. ");
INSERT INTO gqr_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Dabidɨ ur me *Kəyku’tɨ lə Luwə, un mapa kɨ de’gɨ adi Luwə kadikare’tɨ sɔ, ningə təl’n adɨ de’gɨ kɨ go’ə’tɨ sɔi tɔ. Sɔi mapa kɨ in nya kɨ majɨ kadɨ njekujənyamosɨ kadikare’gɨ par ə sɔi.» ");
INSERT INTO gqr_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Jeju təl el’de ɓay ene: «Ngonn de in ɓe nje ndɔ kɔrkon.» ");
INSERT INTO gqr_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","*Ndɔ kɔrkon kɨ rangɨ, Jeju aw kəykawnan’tɨ lə Juwipɨ’gɨ, ndo nya de’gɨ. Ningə dingəm kare kɨ ji’ə oy njururu in me kəykawnan’tɨ non. ");
INSERT INTO gqr_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Njendo ndukun’gɨ kɨ Parisɨ’gɨ sii keke isɨ indəi kum’de kadɨ n’oyi ke Jeju a adɨ dingəm kin lapiya ndɔ kɔrkon’tɨ lə Juwipɨ’gɨ wa? In ta bolo kɨ isɨ sangi kadɨ lə’i ta dɔ’a’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Nan Jeju gər mərta’gɨ lə’de, adɨ el dingəm kɨ ji’ə oy njururu kakin ene: «Ində taa, ra dana ne be takum de’gɨ’tɨ pətɨ.» Dingəm ində ra taa. ");
INSERT INTO gqr_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ningə Jeju təl dəjɨ ndəgɨ de’gɨ ene: «Ri ə in gorow’ə’tɨ kadɨ de ra ndɔ kɔrkon’tɨ wa? Kadɨ de ra majɨ eke kadɨ ra majel? Kadɨ de nagɨ madɨ’ne ta yo’tɨ eke kadɨ inyə adɨ tujɨ kɔ wa?» ");
INSERT INTO gqr_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Jeju ində kum’ne gon’n’de ba pətɨ, ningə el dingəm kakin ene: «Surə ji’i». Dingəm surə ji’ne, ningə ji’ə təl to majɨ kare. ");
INSERT INTO gqr_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Wongɨ tɔl njendo ndukun’gɨ kɨ Parisɨ’gɨ, adɨ elinan ta dann’de’tɨ dɔ nya’tɨ kɨ kadɨ n’rai kɨ Jeju. ");
INSERT INTO gqr_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Me ndɔ’a’gɨ’tɨ kin, Jeju aw dɔ mbal’tɨ tadɔ kelta kɨ Luwə. Elta kɨ Luwə kondɔ’tɨ bitɨ lo ti. ");
INSERT INTO gqr_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Lokɨ lo ti, Jeju ɓar njendo’gɨ lə’ne. Ningə mbunə njendo’gɨ’tɨ kin ə, mbətɨ’de dɔgɨ gidə in joo, ɓar’de njekawkulə’gɨ. ");
INSERT INTO gqr_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Adɨ in Simon, kɨ ində tɔ’a nan Piyər, kɨ ngonnkon’a Andire, kɨ Jakɨ, kɨ Jan, kɨ Pilipɨ, kɨ Batilemi, ");
INSERT INTO gqr_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","kɨ Matiye, kɨ Tomasɨ, kɨ Jakɨ, kɨ ngonn lə Alpe, kɨ Simon kɨ ɓari’ə nje rɔ tadɔ kingə dɔ lə ɓe lə’ne, ");
INSERT INTO gqr_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","kɨ Judɨ kɨ ngonn lə Jakɨ, taa Judasɨ Isikariyotɨ, kɨ njekundɔ Jeju tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jeju in kɨ njendo’gɨ dɔ mbal’tɨ re te lo’tɨ kɨ gidə asɨ nan majɨ ningə, ingə bulə de’gɨ njendo’gɨ lə’ne, kɨ bulə de’gɨ ngayn kɨ in dɔnangɨ Jude’tɨ ge, nje k’in ɓebo Jerujalem’tɨ ge, nje k’in ɓebo’gɨ’tɨ kɨ kadɨ ba’tɨ kɨ Tir ge, kɨ Sidon ge. Rei tadɔ koo ta lə Jeju ge kadɨ ajɨ’de dɔ monyi’gɨ’tɨ lə’de ge. ");
INSERT INTO gqr_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Nje kɨ ndil’gɨ kɨ majel yəti hangal’de ingəi lapiya tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ningə bulə de’gɨ pətɨ sangi kadɨ n’ɔdi rɔ’a, tadɔ tɔgɨ madɨ isɨ te rɔ’a’tɨ adɨ’de lapiya. ");
INSERT INTO gqr_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jeju un kum’ne oo’n njendo’gɨ lə’ne ningə el’de ene: Majikur in lə njendo’gɨ, tadɔ Konɓe lə Luwə in yan’se. ");
INSERT INTO gqr_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ingɨ kɨ ɓo isɨ ra’se ɓone, in nje majikur, tadɔ lo ti ə a ndanni. Ingɨ kɨ sii nonyi ɓone, in nje majikur, tadɔ lo ti ə a kogi. ");
INSERT INTO gqr_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Majikur in lə’se lokɨ de’gɨ isɨ mbətɨ’se, de’gɨ isɨ tuwəi’se, de’gɨ isɨ taji’se, de’gɨ isɨ eli ta’gɨ kɨ majel dɔ’se’tɨ, tadɔ lə’m m’in *Ngonn de. ");
INSERT INTO gqr_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ndɔ kɨ nya’gɨ kin tei dɔ’se’tɨ ə, majɨ kadɨ rai rɔnel, turi jagira, tadɔ nyakugə goji’se in ngayn dɔran’tɨ. Tadɔ in be ə kaw’de’gɨ adi kon njekeltakita Luwə’tɨ kete. ");
INSERT INTO gqr_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Nan in njenyakingə, in nje kumtondoo. In nje kumtondoo tadɔ ingəi nya sɔlme lə’se nga. ");
INSERT INTO gqr_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ingɨ kɨ ɓone ndanni, in nje kumtondoo, tadɔ lo ti ə ɓo a ra’se. Ingɨ kɨ ɓone isɨ kogi, in nje kumtondoo, tadɔ lo ti ə a uwəi ndoo ge a nonyi ge. ");
INSERT INTO gqr_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ingɨ kɨ de’gɨ isɨ elita kɨ majɨ majɨ dɔ’se’tɨ, in nje kumtondoo, tadɔ in be ə kaw’de’gɨ rai kɨ nje ɓar rɔ’de njekeltakita Luwə’tɨ nan ingɨ el. ");
INSERT INTO gqr_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Ningə ingɨ kɨ isɨ oyi ta lə’m, nan m’in m’el’se kadɨ in ndigɨ njeban’gɨ lə’se, rai majɨ kɨ nje kɨ isɨ ɔsi’se ta. ");
INSERT INTO gqr_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Njangɨ dɔ nje kɨ isɨ manni’se, ə elita kɨ Luwə tadɔ nje kɨ isɨ eli ta’gɨ kɨ majel dɔ’se’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Re de ində dow kɔt’i kɨ kare ə, yətɨ dowə kɨ rangɨ ad’a ɓay. Re de taa ku kɨ ngal lə’i ə, ad’a in kɨ gɔjɨ dɔ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","De kɨ ra kɨ dəj’i nya ə ad’a, ningə de taa nya lə’i ə dəji go’ə el tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Nya’gɨ kɨ in ndigɨ kadɨ de’gɨ rai adi’se kin ə, rai kah’a’tɨ inɓe kin adi’de tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Kin ə in ndigi nje kɨ ndigi’se tɔ par ə, oyo ri ə kadɨ de ra’se wa? De a ra’se oyo el, tadɔ njeramajel’gɨ kaa ndigi nje kɨ ndigi’de tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Kin ə rai majɨ kɨ nje kɨ rai’se majɨ par ningə, oyo ri ə kadɨ to de ra’se wa? De a ra’se oyo el, tadɔ njeramajel’gɨ kaa rai tokɨ rai kin be tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Kin ə adi nje kɨ gəri majɨ kadɨ a ugəi’se ɓang’a par gogɨ ə tunəi’se nya ningə, oyo ri ə kadɨ de ra’se wa? De a ra’se oyo el, tadɔ njeramajel’gɨ kaa, adi nje kɨ gəri majɨ kadɨ a ugəi’de kɔr nya lə’de gogɨ par ə tunəi’de nya tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Nan ingɨ, majɨ kadɨ in ndigɨ njeban’gɨ lə’se, rai majɨ kɨ non par, ə adɨ de’gɨ tunəi’se nya nan kanjɨ kadɨ indəi me’se dɔ kingə’tɨ gogɨ el. In be ə a ingəi nyakugə goji kibo, taa a in ngann lə Njekisɨ dɔ nya’gɨ’tɨ pətɨ tɔ. Tadɔ in njera majɨ kɨ de’gɨ kɨ gəri ra oyo el kɨ de’gɨ kɨ nje me majel. ");
INSERT INTO gqr_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Majɨ kadɨ in njera majɨ kɨ ngayn tokɨ Baw’se Luwə in njera majɨ kɨ ngayn kin be tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Gangi ta dɔ de’tɨ el, ningə Luwə a gangɨ ta dɔ’se’tɨ el tɔ. Uwəi de kɨ ta el, ningə Luwə a uwə’se kɨ ta el tɔ. Inyəi go majel lə’de kɔ, ningə Luwə a inyə go majel lə’se kɔ tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Adi, ə Luwə a adɨ’se tɔ. Luwə a ɓukɨ ɓɔl ku’tɨ lə’se kadɨ rosɨ majɨ: a yəkɨ, mbisə jigɨ jigɨ, ɓuki kadɨ rosɨ re puu kɔ. Tadɔ nya kɨ mbɔjɨ’n adi de’gɨ kin ə Luwə a mbɔjɨ’n adɨ’se tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ningə Jeju təl el’de ta kare me kujita’tɨ ɓay ene: «Njekumtɔ a ndɔr njekumtɔ madɨ’ne bann wa? A ndɔr’ɔ el, tadɔ re ndɔr’ɔ ə a osi joo pətɨ me ɓe’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Njendo in dɔ ɓe’ne’tɨ el, re in njendo kɨ ɓe’ə ndo’ə nya berere berere majɨ ningə, a to to ɓe’ne be. ");
INSERT INTO gqr_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","«Ra bann be ə, oo bunə mu kɨ to kum ngonnkon’i’tɨ yo, ə oo kagɨ kɨ boi kɨ to yan’i’tɨ inɓe kin el wa? ");
INSERT INTO gqr_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Nan in, oo kagɨ kɨ boi kɨ to kum’i’tɨ kin el par ə, kɨ gorow kɨ bann ə a asɨ kadɨ el ngonnkon’i ene: “Ngonnkon’m, adɨ m’un bunə mu kɨ to kum’i’tɨ kin” wa? In njekədikum de’gɨ, un kagɨ kɨ boi kɨ kum’i’tɨ kin ningə to, a oo lo ar njay kadɨ un’n bunə mu kɨ kum ngonnkon’i’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","«Kagɨ kɨ majɨ kɨ kadɨ a andɨ kandɨ kɨ majel goto, taa kagɨ kɨ majel kɨ kadɨ a andɨ kandɨ kɨ majɨ kaa goto tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","In kɨ kandɨ kagɨ kɨ sɔw dɔ kaga kin ə a gəri’ə’n’ə. De a ujə kandɨ mbay dɔ konn par’tɨ el, taa de a ujə kandɨ kom kagɨ dɔ dole’tɨ el tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","De kɨ majɨ, ingə kulə ra’ne kɨ majɨ me nyara kɨ majɨ’tɨ kɨ to me’ə’tɨ. Ningə de kɨ majel, ingə kulə ra’ne kɨ majel me nyara kɨ majel’tɨ kɨ to me’ə’tɨ tɔ. Tadɔ ta’gɨ kɨ te ta de’tɨ in nya’gɨ kɨ rosi ngarme’ə. ");
INSERT INTO gqr_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","«Ra bann ə ɓari’m’in “Burəɓe, Burəɓe” ə rai nya kɨ m’el’se el wa? ");
INSERT INTO gqr_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","De kɨ ra kɨ re rɔ’m’tɨ, oo ta lə’m, ə təl rɔ’ne go’tɨ ningə, in de kɨ to to de kɨ m’a m’el’se ta li’ə kam be. ");
INSERT INTO gqr_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","To to de kɨ njera kəy, kɨ ur ɓe dɔ gadi’tɨ adɨ ow majɨ, ɓay taa, ində ginn kəy’tɨ kin be. Lokɨ mann in ningə, mann kon lo re un kəy kakin, nan asɨ kadɨ tɔ kəy kakin el, tadɔ ində adɨ ngan majɨ. ");
INSERT INTO gqr_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Nan de kɨ oo ta lə’m, ə təl rɔ’ne go’tɨ el, to to de kɨ ində kəy lə’ne dɔnangɨ’tɨ taa ne kare, kɨ kanjɨ kur ɓe kində ginn’ə’tɨ be. Lokɨ mann kon re un kəy kakin ningə, nden ba ɓay par ə kəy budɨ nanga mur mur kɔ.» ");
INSERT INTO gqr_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Lokɨ Jeju el ta’gɨ kin pətɨ bulə de’gɨ ningə, ɔtɨ aw Kapernayim’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Me ɓe’tɨ kin, kibo dɔ njerɔ’gɨ’tɨ kɨ ɓu aw kɨ njekulə lə’ne kare kɨ in monyi, to ta koy’tɨ. Ningə in ngonn njekulə kɨ ɓe’ə ge ta li’ə ngayn. ");
INSERT INTO gqr_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Be ə, lokɨ kibo lə njerɔ’gɨ kakin oo ta lə Jeju ningə, ulə ngatɔgɨ’gɨ madɨ, kɨ in ngatɔgɨ, lə Juwipɨ’gɨ, adi’de awi ingəi Jeju kadɨ dəji’ə adɨ re se’de ajɨ ngonn njekulə lə’ne kin. ");
INSERT INTO gqr_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Lokɨ rei ingəi Jeju ningə, nonyi dɔ’a’tɨ kɨ nja nan’tɨ nan’tɨ eyina: «Dingəm kin, in de kɨ asɨ kadɨ in ra si’ə me nya dəjɨ’tɨ li’ə kin, ");
INSERT INTO gqr_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","tadɔ ndigɨ’je j’in Juwipɨ’gɨ ngayn, taa in tɔ ə ra kəykawnan lə Juwipɨ’gɨ adɨ’je.» ");
INSERT INTO gqr_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ə Jeju ɔtɨ aw se’de. Awi, lokɨ indəi dɔ kəy ndəkba ningə, kibo lə njerɔ’gɨ kakin ulə madɨ’ne’gɨ madɨ adɨ awi eli Jeju eyina: «Burəɓe, in ndɔjɨ rɔ’i el. M’in m’asɨ kadɨ ur me kəy’tɨ lə’m el. ");
INSERT INTO gqr_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","In tadɔ kin ə, m’inɓe m’oo rɔ’m kadɨ m’asɨ kaw rɔ’i’tɨ el. Nga ningə, m’dəj’i kadɨ elta kare par ə ngonn njekulə lə’m a ingə lapiya. ");
INSERT INTO gqr_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","M’el be tadɔ, m’in kɨ dɔ’m m’in ginn tɔgɨ’tɨ lə nje kɨ dɔ’m’tɨ, ningə m’aw kɨ njerɔ’gɨ ginn tɔgɨ’tɨ lə’m tɔ. Adɨ re m’el kɨ kare m’ene: “Aw!” ningə aw; re m’el kɨ nungɨ m’ene: “Re!” ningə re; kin ə m’el ngonn njekulə lə’m m’ene: “In ra nya kin be!” ningə ra nya’a kakin tɔ.» ");
INSERT INTO gqr_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Lokɨ Jeju oo ta’gɨ kin ningə, pitɨ kibo lə njerɔ’gɨ kakin, ningə təl kum’ne kɨ dɔ bulə de’gɨ’tɨ kɨ a njiyəi go’ə’tɨ, el’de ene: «Adɨ m’el’se, ko kunme kɨ be kin, dɔnangɨ kɨ Isirayel’tɨ inɓe kaa, m’ingə el ɓay.» ");
INSERT INTO gqr_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Lokɨ njekawkulə’gɨ eyina n’təli ɓe ningə nyɨ ingəi ngonn njekulə kakin, ingə lapiya adɨ isɨ kare. ");
INSERT INTO gqr_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Jeju ɔtɨ non aw ɓebo’tɨ kɨ tɔ’a nan Nayim. *Njendo’gɨ li’ə kɨ bulə de’gɨ ngayn uni go’ə ai si’ə. ");
INSERT INTO gqr_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Lokɨ rei tei ndəkba kɨ tarow kɨ ur kɨ me ɓe’tɨ kakin ningə, de’gɨ isɨ ai kɨ de kɨ oy kadɨ duwi’ə. De kɨ oy kakin in ngonn lə dene kɨ njengawkoy kare be. In ngonn’o kɨ dingəm kɨ kareba be, adɨ bulə de’gɨ ngayn kɨ me ɓe’tɨ, isɨ dani dene kakin lo duw ngonn’o’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Lokɨ Jeju oo dene kakin ningə, to rɔ’a ngayn adɨ oo kumtondoo li’ə, adɨ el ene: «Non el.» ");
INSERT INTO gqr_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Jeju aw kadɨ kəsɨ ninn’tɨ, ulə ji’ne ɔdɨ’n. Njekotɨ ninn’gɨ rai nangɨ, ningə Jeju el ene: «Basa, m’el’i kadɨ ində taa!» ");
INSERT INTO gqr_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ningə njekoy in sii taa, ə ulə ngirə kelta. Jeju təl ulə ji kon’a’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","De’gɨ pətɨ, nya’gɨ kin ətɨ’de ɓol, adɨ uləi tɔjɨ dɔ Luwə’tɨ eyina: «Njekeltakita Luwə’tɨ kare kibo te dann’je’tɨ ne: Luwə re ra kɨ de’gɨ lə’ne.» ");
INSERT INTO gqr_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Nya kɨ ra nya kin, poy’o asɨ dɔnangɨ kɨ Jude pətɨ kɨ ngann ɓe’gɨ kɨ gugi dɔ’a. ");
INSERT INTO gqr_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Njendo’gɨ lə Jan ɔri’ə poy nya kɨ ra nya kin adi’ə oo, ə Jan ɓar njendo’gɨ lə’ne joo, ");
INSERT INTO gqr_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ulə’de rɔ Burəɓe’tɨ adɨ dəji’ə eyina: «In ə in Kirisitɨ De kɨ Luwə mbət’ə kɨ majɨ kadɨ a re kakin eke, in nanyi non ɓay kadɨ to jɨ nginə wa?» ");
INSERT INTO gqr_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Lokɨ rei tei rɔ Jeju’tɨ, eli’ə eyina «In Jan Batisɨ ə ulə’je kɨ rɔ’i’tɨ kadɨ jɨ dəji ke “in in ə in Kirisitɨ kɨ majɨ kadɨ a re kakin wa ke, in nanyi non ɓay kadɨ to jɨ nginə wa?”» ");
INSERT INTO gqr_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Dɔkagilo’ə’tɨ inɓe kɨ isɨ dəji’ə ta kin, Jeju isɨ ajɨ njemonyi’gɨ ngayn num, nje mote’gɨ num, isɨ tuwə ndil’gɨ kɨ majel dɔ de’gɨ’tɨ num, taa adɨ njekumtɔ’gɨ ngayn oyi lo num tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ningə ulə njekulə’gɨ lə Jan ene: «Ai eli Jan nya’gɨ kɨ kum’se kɨ mbi’se oo kin. Oyi ne kadɨ njekumtɔ’gɨ oyi lo, nje mote’gɨ njiyəi majɨ, njebanjɨ’gɨ ingəi rɔ kɨ ar njay, nje mbiboy’gɨ oyi ta, njekoy’gɨ indəi taa lo koy’tɨ, taa Poyta kɨ majɨ osɨ mbi njendoo’gɨ’tɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","De kɨ inyə ta kunme’ne el, in nje majikur.» ");
INSERT INTO gqr_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Lokɨ njekawkita’gɨ lə Jan təli awi, Jeju ulə ngirə kelta kɨ dɔ Jan’tɨ bulə de’gɨ. Jeju dəjɨ’de ene: «In ri ə awi gonyi diləlo’tɨ wa? In gakira kɨ nəl isɨ aw si’ə kɨ yo ge kɨ ne ge kin wa? ");
INSERT INTO gqr_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","A re in in el ə, in ri ə ai gonyi wa? In dingəm kɨ ɔɔ ku kɨ ndole majɨ kin wa? Nga nje kɨ ɔyi ku tɔɓar, ə sii lo’gɨ’tɨ kɨ sɔl lɔm, sii ginn kəy’tɨ lə ngar’gɨ. ");
INSERT INTO gqr_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Eke in ri ə ai gonyi wa? Re in njekeltakita Luwə’tɨ ə ai oyi’ə ə, m’ene oyo, in de kɨ utə njekeltakita Luwə’tɨ ɓay. ");
INSERT INTO gqr_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Tadɔ in ə in de kɨ njekawkita kɨ Makitu lə Luwə elta kɨ dɔ’a’tɨ ene: “M’a m’ulə kɨ njekawkita lə’m nonyi’tɨ. M’ulə kadɨ te tarow nonyi’tɨ.” ");
INSERT INTO gqr_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","M’el’se kadɨ in gəri tokɨ dann de’gɨ’tɨ pətɨ kɨ dene ojɨ’de kin, de kibo utə Jan goto. Nan kɨ ngɔsine kin, de kɨ in kɨ du ngayn me Konɓe lə Luwə bo utə Jan. ");
INSERT INTO gqr_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","De’gɨ pətɨ kɨ oyi ta li’ə, nan’tɨ kɨ njetalambo’gɨ gəri kadɨ Luwə ra nya kɨ dana, adɨ adi Jan ra’de batəm. ");
INSERT INTO gqr_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Nan Parisɨ’gɨ kɨ njendo ndukun’gɨ ɔsi nya kɨ Luwə ində dɔ’a dana tadɔ lə’de ngərəngɨ, adɨ mbeti kadɨ Jan ra’de batəm. ");
INSERT INTO gqr_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","M’oo de kɨ kadɨ m’un’ə m’ɔjɨ’n de’gɨ kɨ dɔkagilo’tɨ kɨ ɓone kin el, taainan kɨ nan wa kaa m’gər el. ");
INSERT INTO gqr_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","M’oo kadɨ taainan nan kɨ ngann’gɨ kɨ du kɨ sii tambalo’tɨ, ɓari nan kɨ yo ge kɨ ne ge eyina: “Jɨ kɔl nal kadɨ ndami ə mbəti ndam, j’osi pa yo kadɨ nonyi ə mbəti non.” ");
INSERT INTO gqr_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Jan Batisɨ re, ə sɔ mapa el num anyi yiwi kandɨ nju el num, ningə eli eyina: “Dɔ’a majel.” ");
INSERT INTO gqr_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ə Ngonn de re, sɔ nya num, anyi num, ningə təli eli eyina: “In kɨ nje kusɔ nya kədɨ kɨ nje nya kanyi, kɨ uwə madɨ kɨ njetalambo’gɨ kɨ njeramajel’gɨ,” ɓay tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Nan nje taa gosɨ lə Luwə, gəri kadɨ gosɨ lə Luwə in gosɨ kɨ dana.» ");
INSERT INTO gqr_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Parisɨ kare ɓar Jeju kadɨ aw sɔ sə’ne nya. Be ə, Jeju aw isɨ si’ə ta nya kusɔ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Lo kin’tɨ, dene kare kɨ me ɓebo’tɨ kin te non re. In dene kɨ njera kaya, ə gər kadɨ Jeju isɨ kəy lə Parisɨ kɨ ɓari’ə Simon kin non. Re kɨ ku mbal kɨ hu kɨ ətɨ majɨ rosɨ. ");
INSERT INTO gqr_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Dene isɨ go Jeju’tɨ, nja’a’tɨ, kɨ mann non kum’ne’tɨ. Yom nja Jeju kɨ mann kum’ne, ningə bɔr kɨ bisɨ dɔ’ne. Go’tɨ, təl njuw nja Jeju, ningə ɔy hu kɨ ətɨ majɨ kakin səm’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Lo kin’tɨ, Parisɨ kɨ ɓar Jeju ɓe lə’ne kakin el me’ne’tɨ ene: «Kin ə re dingəm kin in njekeltakita Luwə’tɨ tokɨ rɔta’tɨ ə, asɨ kadɨ a gər dene kɨ isɨ ɔd’ɔ kin, asɨ kadɨ a gər tokɨ in njera kaya.» ");
INSERT INTO gqr_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ə Jeju el’ə ene: «Simon, m’aw kɨ ta kare ne kadɨ m’el’i.» Nga a Simon ilə Jeju’tɨ ene: «Njendo de’gɨ, el’m.» ");
INSERT INTO gqr_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ningə Jeju el’ə ene: «Dingəm kare adɨ nar de’gɨ joo, ində kirə’tɨ. Kɨ kare kadɨ a ugə kirə kɨ lo kulə kɨ ndɔ ɓu mi, ə kɨ nungɨ kadɨ in kadɨ a ugə kirə kɨ lo kulə’tɨ kɨ ndɔ dɔ mi tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Nan lokɨ asi kadɨ ugəi kirə kakin dɔ’de’tɨ el, dingəm kɨ nje nar kakin inyə kɔ kigo memajɨ’tɨ adɨ’de joo pətɨ. Eke dann de’gɨ’tɨ kɨ joo kin, in kɨ ra a ndigɨ dingəm kɨ nje nar kin ngayn wa?» ");
INSERT INTO gqr_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ningə Simon ilə Jeju’tɨ ene: «Ta lə’i in rɔta. M’oo kadɨ in in kɨ nar kɨ dɔ’a’tɨ in ngayn ə ɓe’ə inyə kɔ kigo memajɨ’tɨ kin ə a ndigɨ nje nar kin ngayn.» Ə Jeju el’ə ene: «Ta lə’i in rɔta.» ");
INSERT INTO gqr_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ningə təl kum’ne kɨ dɔ dene’tɨ kakin, ningə el Simon ene: «Oo dene kin wa? M’re ɓe lə’i, ə mann kɨ kare kaa mbəl dɔ nja’m’tɨ el, nan in, nyom nja’m kɨ mann kum’ne, taa bɔr kɨ bisɨ dɔ’ne ɓay. ");
INSERT INTO gqr_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","In uwə’m kɨ rɔ’i’tɨ kɨ kində kɔtinan nan’tɨ el, nan in, lokɨ m’ur kəy nu, ra kulə kində kɔtɨ’ne yan’m’tɨ togɨ’n nja’m uwə’m kɨ rɔ’ne’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","In uri hu kɨ ətɨ majɨ dɔ’m’tɨ el, nan in mbəl hu kɨ ətɨ majɨ gidɨ njam’gɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Be ningə, m’a m’el’i tokɨ in kɨ gorow majel’gɨ li’ə kɨ ngayn kɨ k’inyə kin ə, ɔjɨ’n ndiginan kɨ ətɨ ɓol kin. Ningə de kɨ majel’gɨ li’ə in kɨ k’inyə go kɔ ngayn el, a tɔjɨ ndiginan kɨ ngayn el tɔ.» ");
INSERT INTO gqr_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ə Jeju el dene kakin ene: «Majel’gɨ lə’i in kɨ k’inyə go kɔ kad’i.» ");
INSERT INTO gqr_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Lo kin’tɨ, de’gɨ madɨ kɨ sii si’ə ta nyakusɔ’tɨ uləi ngirə kel me de’tɨ eyina: «De kin in nan ə aw bitɨ kadɨ inyə go majel lə de’gɨ kɔ wa?» ");
INSERT INTO gqr_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Nan Jeju el dene ene: «Kunme lə’i aj’i, aw kɨ lapiya.» ");
INSERT INTO gqr_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Go’tɨ, Jeju aw kɨ ɓebo’gɨ kɨ ɓebo’gɨ, kɨ ngann ɓe’gɨ kɨ ngann ɓe’gɨ, elta, iləmbər Poyta kɨ majɨ kɨ ɔjidɔ konɓe lə Luwə. Njendo’gɨ li’ə kɨ dɔgɨ gidə in joo in si’ə nan’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Taa, dene’gɨ madɨ kɨ ndɔkɨ Jeju tuwə ndil’gɨ kɨ majel dɔ’de’tɨ kɔ ge, in kɨ adɨ’de lapiya dɔ monyi’gɨ’tɨ lə’de ge kin kaa in non tɔ. Adɨ in Mari kɨ Magidala kɨ ndɔkɨ Jeju tuwə ndil’gɨ kɨ majel siri dɔ’a’tɨ kɔ kin num, ");
INSERT INTO gqr_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Jann kɨ ne Suja, kɨ in dingəm kɨ njengəm nya lə Erodɨ kin num, Sujann num, taa ndəgɨ dene’gɨ kɨ rangɨ ngayn ɓay tɔ. In kin ə in dene’gɨ kɨ njera kɨ Jeju kɨ nyakingə’gɨ lə’de. ");
INSERT INTO gqr_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Bulə de’gɨ kɨ in kɨ ɓebo’gɨ kɨ dangɨ dangɨ kawinan kɨ dɔ Jeju’tɨ, ə Jeju el’de kujita madɨ ene: ");
INSERT INTO gqr_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«Njendɔɔ kare aw kadɨ duw ko nya. Ningə dɔkagilo kɨ a ilə’n ko nya, kandɨ ko’gɨ madɨ tosi dɔ row’tɨ, adɨ de’gɨ njiyəi dɔ’tɨ, yəl’gɨ turi kakɨ. ");
INSERT INTO gqr_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Kandɨ ko’gɨ madɨ tosi dɔnangɨ wor’tɨ, adɨ lokɨ mbi’ə’gɨ ene n’tei ningə təli tuti kurum, tadɔ lokɨ sɔl kɨ kadɨ uləi ngirə’de’tɨ goto. ");
INSERT INTO gqr_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Kandɨ ko’gɨ kɨ nungɨ tosi dann konn’gɨ’tɨ, adɨ konn’gɨ tɔgi se’de nan’tɨ, təli ndəmi’de mbɔl. ");
INSERT INTO gqr_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Nan kandɨ ko’gɨ madɨ, tosi dɔnangɨ’tɨ kɨ majɨ, adɨ tɔgi, kandɨ’de tei. Dɔ’a kɨ kare andɨ asɨ ɓu ɓu.» Nga ningə Jeju tɔlta ta lə’ne kin ene: «De kɨ aw mbi’ne tadɔ koo’n dɔ ta ningə, kadɨ oo dɔ ta kin majɨ!» ");
INSERT INTO gqr_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Njendo’gɨ lə Jeju dəji’ə eyina ke kujita kin me’ə in ri wa? ");
INSERT INTO gqr_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ə Jeju ilə’de’tɨ ene: «Ingɨ, Luwə te kɨ dɔ nya kɨ to lo kiyə’tɨ kɨ ɔjidɔ Konɓe lə Luwə adɨ in gəri, nan ndəgə’gɨ, nya kin in kɨ kɔjɨ’de kɨ kujita, tadɔ kadɨ: “Re kum’de oo lo majɨ kaa oyi nya el, Mbi’de oo dɔ ta majɨ kaa gəri me’ə el.”» ");
INSERT INTO gqr_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Jeju el njendo’gɨ lə’ne ene: «Kujita kin, me’ə ə to kin: Kandɨ ko, in ta lə Luwə. ");
INSERT INTO gqr_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","In kɨ tosɨ dɔ row’tɨ, in de’gɨ madɨ kɨ oyi ta lə Luwə, ningə Su re ɔr ta kɨ oyi kakin me’de’tɨ kɔ, nan to panyata in uni me’de adɨ Jeju kadɨ ingəi kajɨ. ");
INSERT INTO gqr_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Kandɨ ko kɨ tosi dɔnangɨ wor’tɨ, in de’gɨ kɨ oyi ta lə Luwə ningə, taai kɨ rɔnel, nan lo kadɨ ta kin ulə ngirə’ne me’de ngan goto. Uni me’de ngonn kagilo kɨ nden be par, nan lokɨ kon’gɨ rei ningə, inyəi go kunme lə’de kɔ. ");
INSERT INTO gqr_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Kandɨ ko kɨ tosi dann konn’tɨ, in de’gɨ kɨ oyi ta, nan go’tɨ, me kɨ ra sururu, kɨ nya majɨ’gɨ, kɨ koo majɨ rɔ kɨ dɔnangɨ’tɨ ne ɔgɨ’de kadɨ tɔgi gangɨ me kunme’tɨ lə’de ə gəsirəi. ");
INSERT INTO gqr_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ningə kandɨ ko kɨ tosɨ dɔnangɨ’tɨ kɨ majɨ, in de’gɨ kɨ oyi ta lə Luwə kɨ ngar me’de kɨ majɨ, ngarme kɨ rɔta’tɨ, ningə ngəmi me’de’tɨ, uwəi tɔgɨ’de ba, adi kandɨ kulə lə’de te. ");
INSERT INTO gqr_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","«De a ində por lambɨ’tɨ kadɨ dow ngo dɔ’tɨ el, taa ində ginn tirə’tɨ el tɔ. A ində dɔ nya’tɨ taa, kadɨ de’gɨ uri kəy ningə, oyi lo kɨ kunj’ə. ");
INSERT INTO gqr_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Nya ra kɨ gidɨ kuwə, kɨ ginn’ə a te el goto. Tadɔ nya kɨ to lo kiyə’tɨ, kɨ ginn’ə a te el goto tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Majɨ kadɨ uri mbi’se majɨ oyi dɔ ta kɨ isɨ oyi, um kadɨ oyi kɨ non be el. Tadɔ de kɨ aw kɨ nya ji’ne’tɨ, a adi’ə dɔ’tɨ ɓay. Nan de kɨ nya li’ə goto kaa, in kɨ ndikiri inɓe kɨ ində me’ne dɔ’tɨ kin kaa, a tai ji’ə’tɨ inɓe ɓay.» ");
INSERT INTO gqr_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Kon Jeju kɨ ngannkon’a’gɨ rei kadɨ n’oyi’ə, nan lo kadɨ tei rɔ’a’tɨ goto tadɔ bulə de’gɨ kɨ in ngayn. ");
INSERT INTO gqr_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ə eli’ə taa eyina: «Kon’i kɨ ngannkon’i’gɨ rai taga non, gei koyi nu.» ");
INSERT INTO gqr_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ningə Jeju təl el’de ene: «Kon’m kɨ ngannkon’m’gɨ ə in de’gɨ kɨ oyi ta lə Luwə, ningə təli rɔ’de go’tɨ, ə rai kulə.» ");
INSERT INTO gqr_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ndɔ kare, Jeju ala me to’tɨ in kɨ njendo’gɨ lə’ne, ningə el’de ene: «Adɨ jɨ gangi babo j’awi dowə’tɨ kɨ kare.» Ningə awi. ");
INSERT INTO gqr_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Lokɨ isɨ ɔsi to isɨ gangi ba kin ningə, Jeju to ɓi kanum. Ə nəl kibo ngayn osɨ dɔ ba’tɨ, ra adɨ mann rɔsɨ to, in ta koy’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Lo kin’tɨ, njendo’gɨ rei kɨ rɔ Jeju’tɨ, ndəli’ə kɨ non ta’de’tɨ eyina: «Njendo de’gɨ, Njendo de’gɨ, j’isi j’oyi!» Lokɨ Jeju ndəl, ndangɨ nəl’gɨ kɨ pungum mann’gɨ adɨ təli toi keke, lo to jijiji. ");
INSERT INTO gqr_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ningə el njendo’gɨ ene: «Kunme lə’se to ra be tɔ ɓay ə?» Nga ningə ɓol ra’de, nya kin ətɨ’de ɓol ngayn adɨ dəji nan ta dann’de’tɨ eyina: «De inɓe kam in nan ə nəl kɨ mann kaa el’de ta par ə təli rɔ’de go’ə’tɨ be wa?» ");
INSERT INTO gqr_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Jeju ingɨ kɨ njendo’gɨ lə’ne rei tei dɔnangɨ’tɨ kɨ Gerasa, kɨ ra ta ɓe’tɨ kɨ Galile. ");
INSERT INTO gqr_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Lokɨ Jeju in me to’tɨ ur kɨ nanga ningə, dingəm kare kɨ me ɓe’tɨ kɨ Gerasa, in non re kɨ rɔ Jeju’tɨ. In dingəm kɨ ndil’gɨ kɨ majel rai’ə. Asɨ dɔkagilo ngayn, dingəm kin ulə ku rɔ’ne’tɨ el num, isɨ ɓe me kəy’tɨ el num. Lo kis’ə in dɔɓadɨ’gɨ’tɨ par. ");
INSERT INTO gqr_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Lokɨ oo Jeju ningə, osɨ nangɨ nja’a’tɨ, ningə elta kɨ ndu’ne kɨ boi ene: «Jeju, kɨ Ngonn lə Luwə kɨ njekisɨ dɔ nya’gɨ’tɨ pətɨ, in ri ə ge rɔ’m’tɨ wa? Nja’i ba, adɨ’m kon el.» ");
INSERT INTO gqr_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","El be tadɔ Jeju adɨ ndu’ne ndil kɨ majel kadɨ te rɔ dingəm’tɨ kin kɔ. Nja ngayn ndil kɨ majel kin in kɨ dingəm kakin ningə ra’a. De’gɨ dɔi’ə kɨ kulə gindɨ ge, uləi kangila gindɨ nja’a’tɨ ge, nan gangɨ kulə gindɨ’gɨ kin riw riw ə tətɨ kangila gindɨ’gɨ kin nɔsɨ nɔsɨ rɔ’ne’tɨ kɔ, ningə ndil’gɨ kɨ majel ɔsi’ə adɨ aw kɨ diləlo diləlo. ");
INSERT INTO gqr_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ə Jeju dəj’ə ene: «Tɔ’i nan nan?» Anyɨ ilə Jeju’tɨ ene: «Tɔ’m nan bulə njerɔ’gɨ.» Tadɔ ndil’gɨ kɨ majel ngayn uri me’ə’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Lo kin’tɨ, ndil’gɨ kɨ majel kakin nonyi dɔ Jeju’tɨ kadɨ adɨ’de n’awi boloɓe’tɨ kɨ dɔboy’o goto. ");
INSERT INTO gqr_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Bulə kɔsongɨ’gɨ rai lo’tɨ kin non ra sɔi nya dɔ mbal’tɨ, ə ndil’gɨ kɨ majel kakin nonyi dɔ Jeju’tɨ kadɨ adɨ’de n’awi me’de’tɨ. Anyɨ Jeju adɨ’de tarow kadɨ awi me’de’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ndil’gɨ kɨ majel tei me dingəm’tɨ, awi uri me kɔsongɨ’gɨ’tɨ kakin. Ningə nyɨ, kɔsongɨ’gɨ ɓingəi nan kadɨ mbal’tɨ taa, tosi me ba’tɨ, anyinan mann oyi. ");
INSERT INTO gqr_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Lokɨ de’gɨ kɨ njengəm kɔsongɨ’gɨ oyi nya kɨ ra nya kin ningə, anyinan awi me ɓebo’tɨ kɨ ngann ɓe’gɨ, ɔri poy nya kɨ ra nya kin de’gɨ. ");
INSERT INTO gqr_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","De’gɨ tei ai kadɨ n’oyi nya kɨ ra nya kin. Be ə, lokɨ rei tei rɔ Jeju’tɨ ningə, oyi dingəm kɨ ndil’gɨ kɨ majel tei me’ə’tɨ kakin, isɨ nja Jeju’tɨ. Oyi’ə kadɨ isɨ kɨ ku rɔ’ne’tɨ, kɨ hangal kɨ majɨ, adɨ ətɨ’de ɓol. ");
INSERT INTO gqr_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Nje kɨ rai lo nya’tɨ kɨ ra nya kin, ɔri madɨ’de’gɨ poy’o, tɔji row kɨ dingəm kɨ aw kɨ ndil’gɨ kɨ majel kin ingə’n lapiya. ");
INSERT INTO gqr_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Lo kin’tɨ non be, de’gɨ kɨ dɔnangɨ Gerasa’tɨ, ɓol tɔl’de, adɨ dəji Jeju kadɨ inyə dɔnangɨ lə’de ə aw. Ə Jeju al me to’tɨ, təl gogɨ. ");
INSERT INTO gqr_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Dingəm kɨ Jeju tuwə ndil’gɨ kɨ majel dɔ’a’tɨ kɔ kakin dəjɨ Jeju kadɨ n’aw si’ə, nan Jeju tuwə. ");
INSERT INTO gqr_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Ene: «In təl aw ɓe, ɔr poy nya’gɨ pətɨ kɨ Luwə ra sə’i kin adɨ de’gɨ oyi.» Be ə, dingəm aw iləmbər nya kɨ Jeju ra si’ə kin me ɓebo’tɨ ba pətɨ. ");
INSERT INTO gqr_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Lokɨ Jeju təl re, bulə de’gɨ uwəi’ə kɨ rɔ’de majɨ, tadɔ pətɨ isɨ nginəi’ə. ");
INSERT INTO gqr_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ningə nyɨ dingəm kare kɨ tɔ’a nan Jayrusɨ, kɨ in njekundɔ kəykawnan lə Juwipɨ’gɨ in non re. Re osɨ nja Jeju’tɨ, non dɔ’a’tɨ kadɨ re aw ɓe lə’ne. ");
INSERT INTO gqr_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Kadɨ aw ɓe lə’ne tadɔ ngonn’o kɨ dene kɨ in kareba, ɓal’a in dɔgɨ gidə in joo to ta koy’tɨ. Lokɨ Jeju isɨ aw, bulə de’gɨ mborei’ə kɨ yo ge kɨ ne ge, lo kɔrkon goto. ");
INSERT INTO gqr_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Dann bulə de’gɨ’tɨ kin, dene kare kɨ monyi mosɨ ad’a kon ɓal dɔgɨ gidə in joo in non. Dene kin tujɨ nyakingə lə’ne kɔ pətɨ ji njera de’gɨ monyi’tɨ, nan de kɨ kadɨ ad’a lapiya goto. ");
INSERT INTO gqr_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Dene re ndəkba rɔ Jeju’tɨ, kɨ row kɨ gidə’tɨ, ɔdɨ ta ku lə Jeju par ə, tanan’tɨ non, mosɨ gangɨ rɔ’a’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Low’ə’tɨ non Jeju dəjɨ ene: «Nan ə ɔdɨ’m wa?» Ningə de’gɨ pətɨ manji’ə’tɨ eyina n’ɔdi’ə el. Nga ə Piyər el’ə ene: «Burəɓe, in de’gɨ kɨ rosi gid’i, ə mborei nu kɨ yo ge kɨ ne ge kin ə ɔdi nu.» ");
INSERT INTO gqr_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Nan Jeju ene: «De madɨ ɔdɨ’m, m’gər kadɨ tɔgɨ te rɔ’m’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Lokɨ dene oo kadɨ nya kɨ n’ra kin Jeju gər ningə, dadɨ par par, osɨ nja Jeju’tɨ. Ningə takum de’gɨ’tɨ pətɨ, ɔr go nya kɨ ra adɨ n’ɔd’n Jeju kin. Taa, ɔr’de go kingə kɨ ingə lapiya tanan’tɨ non par kin tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ə Jeju el’ə ene: «Ngonn’m, kunme lə’i aj’i. Aw kɨ lapiya.» ");
INSERT INTO gqr_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Lokɨ Jeju ra elta ba ɓay ningə, de kare in ɓe lə njekundɔ kəykawnan lə Juwipɨ’gɨ re. Re el Jayrusɨ ene: «Ngonn’i oy, in ndɔjɨ Njendo de’gɨ el nga.» ");
INSERT INTO gqr_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Nan Jeju kɨ oo dɔ ta kin el Jayrusɨ ene: «Adɨ əti ɓol el, un me’i par, ə a ajɨ.» ");
INSERT INTO gqr_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Lokɨ rei tei me kəy’tɨ, Jeju inyə tarow adɨ de ur kəy go ngonn’tɨ el. Adɨ Piyər num, Jan num, Jakɨ num, baw ngonn ingɨ kɨ kon ngonn num tɔ par ə uri si’ə kəy go ngonn’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","De’gɨ pətɨ nonyi ge ndingəi rɔ’de ge tadɔ ngonn, nan Jeju el’de ene: «Nonyi el, ngonn oy el, to ɓi to to.» ");
INSERT INTO gqr_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Anyɨ uwəi Jeju kogi, tadɔ gəri kadɨ ngonn oy. ");
INSERT INTO gqr_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Nan Jeju uwə ji ngonn, ningə ɓar’a ene: «Ngonn’m kɨ dene, ində taa.» ");
INSERT INTO gqr_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Lo kin’tɨ, ngonn kɨ dene tɔsɨ ndəl, ndil’ə re rɔ’a’tɨ adɨ ində taa tanan’tɨ non. Anyɨ Jeju dəjɨ’de kadɨ adi’ə nya sɔ. ");
INSERT INTO gqr_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Nya kin ra ɓol njekoj’o’gɨ ngayn. Nan Jeju un ndu’ne kadɨ eli taa de madɨ el. ");
INSERT INTO gqr_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jeju ɓar njendo’gɨ kɨ dɔgɨ gidə in joo, adɨ’de tɔgɨ konɓe dɔ ndil’gɨ kɨ majel’tɨ pətɨ, taa kadɨ aji nje monyi’gɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Jeju ulə’de kadɨ iləi mbər Poyta kɨ majɨ kɨ ɔjidɔ konɓe lə Luwə, taa kadɨ adi lapiya de’gɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ningə el’de ene: «Uni nya madɨ tadɔ dɔ row el num, uni kagɨ tɔsɨ el num, uni ɓɔl el num, uni mapa el num, uni nar el num, taa kadɨ ai kɨ ku rɔ’se joo el num tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ə me kəy kɨ ra kɨ uri’tɨ ningə, a si səm’tɨ non bitɨ kadɨ awi. ");
INSERT INTO gqr_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","A re de’gɨ kɨ me ɓe’tɨ pətɨ uwəi’se kɨ rɔ’de’tɨ el ningə, lokɨ isɨ tei me ɓe’tɨ kin kɨ taga ningə, indəi bu sa’gɨ kɨ nja’se’tɨ, kadɨ to to nya ndəjɨ ndu’de.» ");
INSERT INTO gqr_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Njendo’gɨ iləi dɔ’de ai kɨ dɔɓe dɔɓe, iləi mbər Poyta kɨ majɨ taa aji njemonyi’gɨ kɨ lo lo tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Erodɨ kɨ in nje konɓe dɔnangɨ’tɨ kɨ Galile, oo poy nya’gɨ kɨ isɨ rai nya. Lokɨ oo ningə, ta ndɔj’ɔ dɔ Jeju’tɨ, tadɔ de’gɨ madɨ eli eyina: «In Jan Batisɨ ə ində taa dann njekoy’gɨ’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Nje kɨ nungɨ eli eyina: «In Eli kɨ njekelta kɨ ta Luwə’tɨ ə te.» Nje kɨ rangɨ ɓay eli eyina: «In de’gɨ kɨ njekeltakita Luwə’tɨ kɨ kete’gɨ kin ə kɨ kare ində taa dann njekoy’gɨ’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Lo kin’tɨ Erodɨ el ene: «Jan, in m’inɓe ə ndɔkɨ madɨ gangi dɔ’a, nga in nan ɓay ə m’njɨ m’oo ta’gɨ kɨ be kin dɔ’a’tɨ wa kaa m’gər el.» Anyɨ sangɨ kadɨ n’oo Jeju. ");
INSERT INTO gqr_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Lokɨ njekawkulə’gɨ təli non rei ningə, ɔri Jeju poy nya’gɨ kɨ rai adi’ə oo. Ə Jeju ɔr’de, aw se’de gədikare kadɨ ɓebo’tɨ kɨ ɓari’ə Betisayda. ");
INSERT INTO gqr_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Nan bulə de’gɨ gəri go’de, adɨ ai go’de’tɨ. Jeju uwə’de kɨ rɔ’ne’tɨ, el’de ta kɨ dɔ Konɓe’tɨ lə Luwə, taa ajɨ nje’gɨ kɨ sangi lapiya lə rɔ’de tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ningə lokɨ kadɨ aw to ur, njendo’gɨ kɨ dɔgɨ gidə in joo, rei rɔ Jeju’tɨ eli’ə eyina: «Inyə bulə de’gɨ kam adɨ awi kɨ ngannɓe’gɨ’tɨ kɨ lo ndɔɔ’gɨ’tɨ sangi lo to ge kɨ nyakusɔ ge, tadɔ lo kɨ ji rai’tɨ ne kin, in lo kɨ de’gɨ gotoi’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Nan Jeju el’de ene: «Inɓe’gɨ adi’de nya sɔi.» Ə njendo’gɨ eli eyina: «J’aw kɨ mapa mi ə kanjɨ joo inɓe be tɔ par, adɨ re in be el wa ningə kadɨ j’inɓe j’aw jɨ ndogɨ mapa tadɔ lə bulə de’gɨ kin pətɨ wa ta.» ");
INSERT INTO gqr_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Dingəm’gɨ asi dər mi low’ə’tɨ non. Nan Jeju el njendo’gɨ ene: «Adi’de sii nanga, uwəi nan asɨ dɔ mi dɔ mi be.» ");
INSERT INTO gqr_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Njendo’gɨ rai tokɨ Jeju el’n’de, adɨ adi’de sii nanga pətɨ. ");
INSERT INTO gqr_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ə Jeju un mapa kɨ mi kɨ kanjɨ kɨ joo kakin, ningə un kum’ne kɨ taa, elta kɨ Luwə kadɨ njangɨ dɔ nyakusɔ kin. Go’tɨ, Jeju uwə mapa’gɨ kakin gangɨ nan’tɨ, ə təl’n adɨ njendo’gɨ kadɨ lowəi bulə de’gɨ. ");
INSERT INTO gqr_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","De’gɨ pətɨ sɔi nya ndanni majɨ. Ningə, njendo’gɨ ɔyi ndəgɨ mapa kɨ kanjɨ kɨ nanyi, kara dɔgɨ gidə in joo ɓay. ");
INSERT INTO gqr_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ndɔ kare Jeju isɨ elta kɨ Luwə gədikare, njendo’gɨ li’ə in si’ə nan’tɨ, ə Jeju dəjɨ’de ene: «Bulə de’gɨ isɨ elita kɨ dɔ’m’tɨ tokɨ m’in nan wa?» ");
INSERT INTO gqr_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ə iləi’ə’tɨ eyina: «De’gɨ madɨ eli eyina in Jan Batisɨ, nje kɨ nungɨ eyina in njekeltakita Luwə’tɨ Eli, nje kɨ rangɨ ɓay eyina in njekeltakita Luwə’tɨ kɨ kete kin, ə in kɨ kare dann’de’tɨ ində taa dann njekoy’gɨ’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ningə Jeju el’de ene: «Nga inɓe’gɨ kɨ dɔ’se, eli eyina m’in nan wa?» Anyɨ Piyər ilə’tɨ ene: «In Kirisitɨ kɨ in De kɨ Luwə mbət’ə.» ");
INSERT INTO gqr_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Jeju ilə ndu’ne kɨ tɔgɨ’ne kadɨ elita kin de madɨ el. ");
INSERT INTO gqr_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Jeju ilə dɔ ta’tɨ kin ene: «Majɨ kadɨ Ngonn de ingə kon ngayn, ngatɔgɨ’gɨ lə Juwipɨ’gɨ, kɨ kibo’gɨ lə njekujənyamosɨ kadikare’gɨ, kɨ njendo ndukun’gɨ a mbəti’ə. De’gɨ a tɔli’ə, nan ndɔ kɨ kon mutə tum ginn’ə ndɔ koy’o ningə, a te lo koy’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Go’tɨ, Jeju el de’gɨ pətɨ ene: «Re de madɨ ndigɨ njiyə go’m’tɨ ningə, kadɨ oo rɔ’ne to nya madɨ el, kadɨ ndɔ’gɨ kare kare pətɨ inɓe un kagidəsɨ koy lə’ne, ə re un go’m. ");
INSERT INTO gqr_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Tokɨ rɔta’tɨ, de kɨ ge kajɨ rɔ’ne n’inɓe dɔnangɨ’tɨ ne a ilə rɔ’ne kɔ. Nan de kɨ ilə rɔ’ne kɔ tadɔ lə’m, a ajɨ rɔ’ne tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Kin ə re de ingə nyamajɨ’gɨ kɨ dɔnangɨ’tɨ ne pətɨ tigə, nan kadɨ inɓe ilə rɔ’ne kɔ eke tujɨ rɔ’ne ningə, maj’a to ra be wa? ");
INSERT INTO gqr_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Tokɨ rɔta’tɨ, re rɔ de madɨ sɔl’ɔ tadɔ lə’m, eke tadɔ ta lə’m ningə, m’in Ngonn de kaa, m’a m’ra rɔsɔl dɔ’a’tɨ tɔ, ndɔ’a’tɨ kɨ m’a m’re’n me tɔjɨ’tɨ lə’m, kɨ me tɔjɨ’tɨ lə Bai, kɨ me tɔjɨ’tɨ lə malayka’gɨ kɨ ari njay.» ");
INSERT INTO gqr_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Tokɨ rɔta’tɨ adɨ m’el’se, de’gɨ madɨ dann’se’tɨ ne a oyi el ɓay ə, a oyi Konɓe lə Luwə taa. ");
INSERT INTO gqr_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ndɔ jijoo go ta’gɨ’tɨ kin ningə, Jeju ɔr Piyər num, Jan num, taa Jakɨ num tɔ, ə al aw se’de dɔ mbal’tɨ kadɨ n’elita kɨ Luwə. ");
INSERT INTO gqr_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Lokɨ Jeju isɨ elta kɨ Luwə ningə, takum’ə mbəl, taa ku li’ə təl nda bal bal tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ningə low’ə’tɨ non, dingəm’gɨ joo a eli si’ə ta. Dingəm’gɨ kakin in Mojɨ in kɨ Eli. ");
INSERT INTO gqr_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Tei me tɔjɨ’tɨ, a eli si’ə ta ɔjidɔ kaw kɨ a aw Jerujalem’tɨ kadɨ oy, tɔl’n ta kulə lə’ne. ");
INSERT INTO gqr_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Piyər in kɨ madɨ’ne’gɨ, ɓi tɔl’de kanum. Ə lokɨ ene n’ndəli ningə, oyi tɔjɨ lə Jeju kɨ dingəm’gɨ kɨ joo kɨ rai si’ə. ");
INSERT INTO gqr_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Lokɨ dingəm’gɨ kakin inyəi Jeju ə isɨ awi ningə, Piyər el Jeju ene: «Njendo, kin ə j’isi lo kin’tɨ ne be par ə majɨ ngayn. J’a ra *kəyku’gɨ lo mutə: kare in yan’i, kare in yan Mojɨ, ə kɨ kare in yan Eli tɔ.» Piyər gər me ta kɨ isɨ el kin el. ");
INSERT INTO gqr_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ə lokɨ a elta to kel ba ɓay ningə, kilndi in re dow dɔ’de bigum. Lo kɨ kilndi isɨ dow dɔ’de kin, ɓol tɔl njendo’gɨ. ");
INSERT INTO gqr_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Lo kin’tɨ, ndu ta madɨ te me kilndi’tɨ ene: «In kam in Ngonn’m, in ə in de kɨ m’mbət’ə, ə oyi ta li’ə.» ");
INSERT INTO gqr_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Go ndu ta’tɨ kin, Jeju təl nanyi kɨ kar’ne ba, de oo de madɨ kɨ rangɨ kad’a’tɨ el. Njendo’gɨ ngəmi ta’de, taa de madɨ kare kɨ dann’de’tɨ non, kɨ ndɔ’a’tɨ kin elta dɔ nya’gɨ’tɨ kɨ oyi kin goto. ");
INSERT INTO gqr_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Lo ti go’tɨ, Jeju in kɨ njendo’gɨ lə’ne kɨ mutə in dɔ mbal’tɨ isɨ uri kɨ nanga ningə, bulə de’gɨ ngayn tiləi kum’ə. ");
INSERT INTO gqr_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ningə dann bulə de’gɨ’tɨ kakin, dingəm kare un ndu’ne kɨ taa ene: «Njendo de’gɨ, m’non kɨ dɔ’i’tɨ kadɨ gon ngonn’m kin adɨ’m, tadɔ in kɨ kar’ne ba ji’m’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Dɔkagilo’gɨ madɨ ningə, ndil kɨ majel a uwə, ra’a adɨ ur kɔl, ə yək’ə kɨ tɔgɨ’ne, adɨ pulum taa uwə jugɨ jugɨ. A ad’a kon ratata, to nya kɨ a inyə el be ɓay taa təl inyə. ");
INSERT INTO gqr_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Be ə, m’dəjɨ njendo’gɨ lə’i kadɨ tuwəi ndil kɨ majel kin dɔ’a’tɨ kɔ, nan asi el.» ");
INSERT INTO gqr_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Lo kin’tɨ Jeju un ta el ene: «In de’gɨ kɨ dɔkagilo’tɨ kɨ ɓone kɨ in nje me ngan, njera nya kɨ majel, ke kadɨ to m’njɨ sese bitɨ kagilo bann ɓay taa kadɨ uni me’se adi m’in wa? Ke kadɨ m’a m’ɔsɨ ginn’se bitɨ kagilo bann ɓay taa wa? Re kɨ ngonn’i rɔ’m’tɨ ne.» ");
INSERT INTO gqr_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Lokɨ ngonn isɨ re ndəkba kɨ rɔ Jeju’tɨ ningə, ndil kɨ majel kakin un’ə, ɔt’ɔ nanga, yək’ə kɨ tɔgɨ’ne, nan Jeju ndangɨ ndil kɨ majel kɨ tɔgɨ’ne ad’a te rɔ ngonn’tɨ, adɨ ngonn ingə lapiya, ningə təl si’ə adɨ baw’a. ");
INSERT INTO gqr_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Lo kin’tɨ, de’gɨ pətɨ, ndil’de te anyi ur kakɨ ɔjidɔ tɔgɨ Luwə kɨ ətɨ ɓol kin. Lokɨ de’gɨ pətɨ, nya’gɨ pətɨ kɨ Jeju ra, ətɨ’de ɓol, Jeju el njendo’gɨ lə’ne ene: ");
INSERT INTO gqr_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«Oyi ta kɨ m’aw to m’el’se kin majɨ: A uləi m’in Ngonn de ji de’gɨ’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Nan njendo’gɨ gəri me ta kin el. Ta kin to kɨ ndəmə ba kadɨ gəri me’ə el. Ningə ɓoli kadɨ dəji ta Jeju dɔ’tɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Njendo’gɨ uləi ngirə manjinan ta’tɨ kadɨ n’gəri ke nan dann’de’tɨ ə in kibo wa? ");
INSERT INTO gqr_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jeju gər ta kɨ me’de’tɨ, adɨ un ngonn kɨ du, ur’ə ad’a ra gədɨ’ne’tɨ, ");
INSERT INTO gqr_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ningə el’de ene: «Re de madɨ uwə ngonn kɨ be kin kɨ rɔ’ne’tɨ me tɔ’m’tɨ ningə, in m’inɓe ə de’ə kin uwə’m kɨ rɔ’ne’tɨ. Ningə, de kɨ uwə’m kɨ rɔ’ne’tɨ, in njekulə’m ə uwə kɨ rɔ’ne’tɨ.» Tokɨ rɔta’tɨ, de kɨ in ə in kɨ du ngayn dann’se’tɨ, in de’ə kin ə in kibo dann’se’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jan un ta el Jeju ene: «Njendo de’gɨ, j’oo de madɨ kɨ a tuwə ndil’gɨ kɨ majel me tɔ’i’tɨ, ningə jɨ ndigɨ kadɨ j’ɔg’ɔ dɔ ra nya kin, tadɔ in njiyə se’je go’i’tɨ el.» ");
INSERT INTO gqr_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Nan Jeju ilə’tɨ ene: «Ɔgi’ə dɔ el, tadɔ de kɨ ɔsɨ’se ta el in de lə’se.» ");
INSERT INTO gqr_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Lokɨ dɔkagilo nanyi ndəkba kadɨ a uni Jeju ai si’ə dɔran’tɨ, Jeju ilə ndu’ne kadɨ ri ri kaa n’aw Jerujalem’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Be ə, ulə njekawkulə’gɨ non’ne’tɨ kete. Njekawkita’gɨ awi, uri me ngonnɓe’tɨ kɨ *Samari kadɨ rai go re lə Jeju kete. ");
INSERT INTO gqr_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Nan de’gɨ kɨ ngonn ɓe’tɨ kakin mbeti kuwə Jeju kɨ rɔ’de’tɨ tadɔ isɨ aw kɨ Jerujalem. ");
INSERT INTO gqr_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Lokɨ njendo’gɨ li’ə, Jakɨ ingɨ kɨ Jan oyi ta kin ningə, eli Jeju eyina: «Burəɓe, in ndigɨ kadɨ jɨ dəjɨ por j’ad’a in dɔran’tɨ, osɨ dɔ’de’tɨ, row’de kɔ wa?» ");
INSERT INTO gqr_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ə Jeju təl kum’ne rɔ’de’tɨ, ndangɨ’de ene: Ndil kɨ ində ta me’se’tɨ kin ke in gəri in ndil kɨ to tanan bann wa? ");
INSERT INTO gqr_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Tadɔ Ngonn de re kadɨ to kajɨ de’gɨ um kadɨ tujɨ de’gɨ el. Ningə uni row, ai ngonn ɓe’tɨ kɨ rangɨ. ");
INSERT INTO gqr_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Lokɨ in dɔ row’tɨ, de madɨ el Jeju ene: «M’a m’un go’i lo’gɨ pətɨ kɨ a awɨ’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ə Jeju el’ə ene: «Njan’gɨ ai kɨ ɓe to’de, ə yəl’gɨ ai kɨ kəy lə’de tɔ, nan m’in Ngonn de m’aw kɨ lo kɨ kadɨ m’ulə dɔ’m’tɨ el.» ");
INSERT INTO gqr_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Go’tɨ, Jeju el de kɨ rangɨ ene: «Un go’m.» Ningə de kakin el ene: «Burəɓe, adɨ’m tarow adɨ m’aw m’duw bai ɓay taa.» ");
INSERT INTO gqr_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ə Jeju el’ə ene: «Inyə njekoy’gɨ adɨ duwi njekoy’gɨ lə’de, nan in aw iləmbər Konɓe lə Luwə.» ");
INSERT INTO gqr_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","In kɨ rangɨ ɓay el ene: «Burəɓe, m’a m’un go’i, nan m’dəj’i kadɨ adɨ’m tarow adɨ m’aw m’elta kɨ kadɨ j’inyəi’n nan kɨ nje kɨ me kəy’tɨ lə’m ɓay taa.» ");
INSERT INTO gqr_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ə Jeju el’ə ene: «De kɨ uwə dɔ kɔsɨ mangɨ, ə təl ilə rətɨ gogɨ ningə, de’ə kin Konɓe lə Luwə in kɨ ta tɔ’a el.» ");
INSERT INTO gqr_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Go nya’gɨ kin, Jeju mbətɨ njendo’gɨ kɨ rangɨ dɔ siri gidə in joo, ningə ulə’de joo joo kɨ ɓebo’gɨ kɨ lo’gɨ kɨ dangɨ dangɨ kɨ ɔjɨ kadɨ re inɓe a awɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ningə el’de ene: «Ko kɨ asɨ kujə, dilə in ngayn, nan Njekujə’gɨ in ngayn el. Ə dəji ɓe nje ko kadɨ ulə kɨ njekujə ko’gɨ me ndɔɔ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ningə kɨ ngɔsine kin, osi row’ə ai! M’ulə’se to ngann batɨ’gɨ be dann jagum’gɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Uni nar el num, uni ɓɔl el num, uni sa nja’se el num tɔ. Taa rai row’ə ta lapiya kɨ ra’tɨ el num tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Kin ə ai kadɨ uri me kəy’tɨ madɨ ningə, nya kɨ dɔkete, eli eyina: “Lapiya kɨ dɔ me kəy’tɨ kin.” ");
INSERT INTO gqr_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ningə kin ə re de kɨ nje ndigɨ lapiya isɨ me kəy’tɨ kin non ningə, lapiya lə’se a aw kɨ dɔ’a’tɨ. A re de goto ningə, lapiya lə’se a təl kɨ rɔ’se’tɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Sii me kəy’tɨ kɨ uwə’se kɨ rɔ’ne’tɨ kin non, nyakusɔ kɨ adi’se ə sɔi, mann kɨ adi’se ə anyinan. Tadɔ de kɨ ra kulə, majɨ kadɨ ingə nyakugəgoji lə’ne. Uri kəy joo el. ");
INSERT INTO gqr_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Kin ə re uri me ɓe’tɨ, ə ɓe uwə’se kɨ rɔ’ne’tɨ ɓe nje nya kɨ adi’se ə sɔi par. ");
INSERT INTO gqr_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Re de’gɨ kɨ monyi ra’de in me ɓe’tɨ kin non ə, aji’de. Ə eli de’gɨ kɨ me ɓe’tɨ eyina: “Konɓe lə Luwə in ndəkba kɨ rɔ’se’tɨ.” ");
INSERT INTO gqr_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","A re uri me ɓe’tɨ, ə de’gɨ kɨ me ɓe’tɨ kin uwəi’se kɨ rɔ’de’tɨ el ningə, tei kɨ taga tambalo’tɨ, ə eli eyina: ");
INSERT INTO gqr_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Bu kɨ me ɓe’tɨ lə’se kɨ nanyi ginn sa nja’je’tɨ kaa, j’ində kɔ gogɨ j’adɨ’se. Ningə kadɨ in gəri tokɨ Konɓe lə Luwə in ndəkba.” ");
INSERT INTO gqr_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ə kadɨ m’el’se tokɨ rɔta’tɨ m’adɨ in gəri tokɨ ndɔ gangɨ ta’tɨ ə, ta kɨ gangɨ kɨ dɔ ɓe’tɨ kin a utə yan Sɔdɔm sanyi. ");
INSERT INTO gqr_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","«Kumtondoo in lə’i in ɓebo kɨ Korajen! Kumtondoo in lə’i in ɓebo kɨ Betisayda! Nyakɔjɨ’gɨ kɨ rai nya ɓe lə’se kin, re in Tir’tɨ kɨ Sidon’tɨ ə nya’gɨ kin rai nya me’tɨ be ə, de’gɨ kɨ me’tɨ, a inyəi kuləra’de’gɨ kɨ majel kɔ mayinu. Re a uləi ku kuwə ndo rɔ’de’tɨ, sii bu’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","In tadɔ kin wa, ndɔ gangɨ ta’tɨ ə, ta kɨ gangɨ kɨ dɔ’se’tɨ a utə Tir kɨ Sidon. ");
INSERT INTO gqr_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Nga ningə in Kapernayim, oo kadɨ a un dɔ’i taa bitɨ kadɨ ɔdɨ dɔran, nan Luwə a təl sə’i bitɨ kaw’se’i koo.» ");
INSERT INTO gqr_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Jeju təl el njendo’gɨ lə’ne ɓay ene: «De oo ta lə’se, in m’in ə de’ə kin oo ta lə’m. Ə de kɨ ɔsɨ’se ngərəngɨ ningə, in m’in ə de’ə kin ɔsɨ’m ngərəngɨ tɔ. Ningə de kɨ ɔsɨ’m ngərəngɨ ə, in njekulə’m tɔ ə ɔs’ɔ ngərəngɨ.» ");
INSERT INTO gqr_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Njendo’gɨ kɨ dɔ siri gidə in joo kɨ Jeju ulə’de, təli lo kulə’tɨ kɨ rɔnel, ningə eli Jeju eyina: «Burəɓe, ndil’gɨ kɨ majel kaa, lokɨ jɨ ɓar tɔi ningə, uləi dɔ’de ginn tɔgɨ’je’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jeju el’de ene: «M’oo *Satan in dɔran’tɨ osɨ kɨ dɔnangɨ’tɨ to təl ndi be. ");
INSERT INTO gqr_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ningə m’adɨ’se tɔgɨ kadɨ njiyəi dɔ lii’gɨ’tɨ, dɔ nii’gɨ’tɨ, kɨ dɔ tɔgɨ’gɨ’tɨ pətɨ kɨ njeban awɨ’n. Nya madɨ kare kɨ kadɨ a tujɨ’se goto. ");
INSERT INTO gqr_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Nga ningə kadɨ rai rɔnel tadɔ kulə kɨ ndil’gɨ kɨ majel uləi dɔ’de ginn tɔgɨ’se’tɨ kin el, nan kadɨ rai rɔnel tadɔ tɔ’se kɨ in kɨ ndangɨ me dɔran’tɨ taa.» ");
INSERT INTO gqr_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Dɔkagilo’ə’tɨ non, Ndil Luwə ra adɨ rɔnel rɔsɨ me Jeju, adɨ el ene: «M’ulə tɔjɨ dɔ’i’tɨ, Bai, in Burəɓe kɨ nje dɔran kɨ dɔnangɨ. M’ulə tɔjɨ dɔ’i’tɨ tadɔ iyə kum nya kin njetər’gɨ kɨ nje nyagər’gɨ, ningə in te kum’ə adɨ nje kɨ de’gɨ gəri dɔ’de el. Bai, in inɓe ə in ndigɨ kadɨ to to be. ");
INSERT INTO gqr_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Nya’gɨ pətɨ, in Bai ə adɨ’m’de, ningə de kɨ kadɨ gər Ngonn goto, Baw’a kɨ kar’ne ba par ə gər’ə, taa de kɨ gər Baw kaa goto tɔ, Ngonn’o kɨ kar’ne ba par ə gər’ə, ə de kɨ Ngonn inɓe te kɨ dɔ Baw’ne ad’a tɔ par ə a gər’ə.» ");
INSERT INTO gqr_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Go’tɨ, Jeju təl kum’ne kɨ dɔ njendo’gɨ el’de kɨ kar’de ba ene: «In nje majikur tadɔ nya kɨ kum’se oo kin! ");
INSERT INTO gqr_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","De’gɨ kɨ njekeltakita Luwə’tɨ ngayn kɨ ngar’gɨ ngayn ndigɨ kadɨ n’oyi nya kɨ kum’se oo kin, nan lo kadɨ kum’de oo goto, ndigi kadɨ mbi’de oo dɔ ta kɨ mbi’se oo kin, nan lo kadɨ oyi dɔ’a goto.» ");
INSERT INTO gqr_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Njendo ndukun kare ində taa, ningə dəjɨ ta kare Jeju to ta kuwə nan kɨ ta ene: «Njendo de’gɨ, in ri ə majɨ kadɨ m’ra kadɨ to m’ingə’n kajɨ kɨ bitɨ kɨ non’tɨ wa?» ");
INSERT INTO gqr_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ə Jeju el’ə ene: «In ta ri ə ndangi me ndukun’tɨ wa? Ə go gər’ə lə’i in bann wa?» ");
INSERT INTO gqr_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ningə njendo ndukun kakin ilə Jeju’tɨ ene: «A in ndigɨ Burəɓe Luwə lə’i kɨ ngarme’i ba pətɨ, kɨ ndil’i ba pətɨ, kɨ tɔgi ba pətɨ, kɨ ta mər lə’i ba pətɨ. Ningə a ndigɨ de mad’i to darɔ’i inɓe be tɔ.» ");
INSERT INTO gqr_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ə Jeju el’ə ene: «Ta kɨ m’dəj’i, ilə’m’tɨ majɨ kɨ dum. Ə in ra be, ningə a ingə kajɨ.» ");
INSERT INTO gqr_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Njendo ndukun sangɨ kadɨ n’tɔjɨ tokɨ n’in de kɨ dana, adɨ təl dəjɨ Jeju ene: «Nan ə in de madɨ’m wa?» ");
INSERT INTO gqr_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ə Jeju el’ə ene: «Dingəm kare in Jerujalem isɨ aw Jeriko, ningə osɨ ji kaya’gɨ’tɨ kɨ nje gangɨ row, adɨ taai nya’gɨ li’ə pətɨ ji’ə’tɨ, tindəi’ə adɨ to ta koy’tɨ, ningə inyəi’ə ə ɔti awi. ");
INSERT INTO gqr_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Go’tɨ ningə, njekujənyamosɨ kadikare in non re te dɔ’a’tɨ, nan lokɨ oo’ə, gangɨ sanyi aw lo lə’ne. ");
INSERT INTO gqr_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Go’tɨ, de kɨ ginn kojɨ’tɨ lə Lebi kare in non re tɔ, nan lokɨ oo dingəm kakin ningə, gangɨ sanyi aw lo lə’ne. ");
INSERT INTO gqr_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Go’tɨ ningə, de kɨ Samari’tɨ kare kɨ isɨ aw mbah in non re te dɔ dingəm’tɨ kakin. Lokɨ oo’ə, oo kumtondoo li’ə kɨ rɔta’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Be ə, re rɔ’a’tɨ, ur hu kɨ yiwi kandɨ nju ta dɔ’tɨ, dɔ’n do li’ə, ningə un’ə ində dɔ koro’tɨ lə’ne, aw si’ə lo to mbah’gɨ’tɨ, ində kum’ne go’ə’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Lo ti go’tɨ, dingəm kɨ Samari’tɨ kakin ɔr nar kɨ asɨ ra kulə ndɔ joo adɨ nje kində kum’ne go kəy to mbah’gɨ’tɨ, ningə el’ə dɔ’tɨ ene: “Ində kum’i go’ə’tɨ majɨ, a re nya kɨ ində’n kum’i go’ə’tɨ, aldɔ in kɨ mad’i kin ningə, ndɔ təl’m ə, m’inɓe m’a m’ugə’i.”» ");
INSERT INTO gqr_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ningə Jeju dəj’ə ta dɔ’tɨ ene: «Dann de’gɨ’tɨ kɨ mutə kin, in kɨ ra ə in madɨ dingəm kɨ kaya’gɨ kɨ nje gangɨ row gangi’ə kin wa?» ");
INSERT INTO gqr_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ningə, njendo ndukun ene: «In in kɨ oo kumtondoo li’ə kin.» Nga ningə Jeju el’ə ene: «Re in be ningə, in kaa kadɨ aw, ə in ra be tɔ.» ");
INSERT INTO gqr_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jeju in kɨ njendo’gɨ lə’ne in dɔ row’tɨ rei tei ngonn ɓe’tɨ kare be ningə, dene madɨ kɨ tɔ’a nan Martɨ uwə Jeju rɔ’ne’tɨ me kəy’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Martɨ aw kɨ ngonnkon’ne kɨ dene kɨ tɔ’a nan Mari non. Ə ngonnkon’a kakin re isɨ nangɨ nja Burəɓe Jeju’tɨ, sii oo dɔ ta kɨ Jeju isɨ el. ");
INSERT INTO gqr_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Nan Martɨ ra ta ngann kulə’gɨ’tɨ, nja’a ɔdɨ nangɨ el, aw yo ge kɨ ne ge. Ningə te patɨ, re el Jeju ene: «Burəɓe, ra bann ə ngonnkon’m kɨ dene Mari inyə’m adɨ m’ra ta kulə’gɨ’tɨ kɨ kar’m ba be kaa usi el par wa? El’ə adɨ re ra sə’m kulə’gɨ.» ");
INSERT INTO gqr_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ə Burəɓe el Martɨ ene: «Martɨ, Martɨ, me’i osɨ nanga el, adɨ aw kɨ yo ge kɨ ne ge tadɔ nya’gɨ ngayn. ");
INSERT INTO gqr_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Nan nya kɨ sotɨ in kareba. Ningə Mari mbətɨ nya kɨ majɨ utə nya’gɨ pətɨ. In nya kɨ de a taa ji’ə’tɨ el.» ");
INSERT INTO gqr_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ndɔ kare Jeju isɨ elta kɨ Luwə lo madɨ’tɨ. Lokɨ elta kɨ Luwə ginn’ə gangɨ ningə, njendo li’ə kare el’ə ene: «Burəɓe, ndo’je kelta kɨ Luwə tokɨ Jan Batisɨ ndo’n njendo’gɨ lə’ne kin be tɔ.» ");
INSERT INTO gqr_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ə Jeju el’de ene: «Lokɨ sii elita kɨ Luwə ningə, kadɨ eli eyina: “Baw’je, Kadɨ de kɨ ra gər tɔ’i tokɨ in Luwə, Kadɨ Konɓe lə’i re. ");
INSERT INTO gqr_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Adi’je nyakusɔ’je kɨ asɨ ta’je kɨ ndɔ’gɨ ndɔ’gɨ. ");
INSERT INTO gqr_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Inyə go majel’gɨ lə’je kɔ, tadɔ j’inɓe kaa, J’inyə’n go majel lə de’gɨ pətɨ kɨ rai se’je majel kɔ tɔ. Inyə’je adɨ j’osi me nyanan’tɨ el.”» ");
INSERT INTO gqr_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Anyɨ Jeju təl el’de ɓay ene: «Kin ə, de kare dann’se’tɨ ge be, aw kɨ madɨ’ne non, ə in dann lo’tɨ aw ində takəy dɔ’a’tɨ ene: “Madɨ’m, tunə’m mapa mutə, ");
INSERT INTO gqr_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","tadɔ madɨ’m kare in mbah’tɨ re te dɔ’m’tɨ, nan nya kɨ kadɨ m’ra’n’ə mbah goto.” ");
INSERT INTO gqr_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ə re mad’a kakin to kɨ kəy non ene: “Ndɔjɨ’m el, takəy in kɨ kutɨ nga, ningə j’in kɨ ngann’m’gɨ jɨ to nanga tɔ, um lo kadɨ m’a m’ində taa m’ad’i mapa goto.” ");
INSERT INTO gqr_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","M’el’se kadɨ in gəri, kin ə re ində taa ad’a mapa kin tadɔ k’in madɨ nan lə’de el kaa, a ində taa kadɨ ad’a nya’gɨ pətɨ kɨ ge, tadɔ takəy kɨ a ində kɨ nja nan’tɨ nan’tɨ kin. ");
INSERT INTO gqr_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ningə m’in, m’el’se: Dəji ə a adi’se, sangi ə a ingəi, indəi takəy ə a tei adi’se. ");
INSERT INTO gqr_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Tadɔ de kɨ dəjɨ ə a adi’ə, de kɨ sangɨ ə a ingə, de kɨ ində takəy ə a tei adi’ə tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Baw ngonn kɨ ra dann’se’tɨ ə ngonn’o dəj’ə kanjɨ ningə a un lii yo taa ad’a wa? ");
INSERT INTO gqr_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Eke kadɨ ngonn’o dəj’ə kaw, ə a un nii yo ad’a kaa goto tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Kin ə ingɨ kɨ in de’gɨ kɨ kuləra’se majel kin mindɨ ə in gəri kadɨ nya kɨ majɨ ngann’se’gɨ ningə, ra bann be ə, Baw’je kɨ isɨ dɔran’tɨ taa kin taa, a adɨ Ndil Luwə de’gɨ kɨ dəji’ə el wa?» ");
INSERT INTO gqr_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ndɔ kare Jeju tuwə ndil kɨ majel kɨ in me dingəm’tɨ ningə ra’a adɨ elta el. Lokɨ ndil kɨ majel te ningə, dingəm kɨ kete elta el kakin təl elta, adɨ ətɨ bulə de’gɨ ɓol ngayn. ");
INSERT INTO gqr_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ningə de’gɨ madɨ eli eyina: «In kɨ tɔgɨ lə Beljəbul kɨ in ngar lə ndil’gɨ kɨ majel, ə isɨ tuwə’n ndil’gɨ kɨ majel.» ");
INSERT INTO gqr_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ə nje kɨ nungɨ, kadɨ nanyi’ə’n’ə ningə, dəji’ə kadɨ ra nyakɔjɨ madɨ kare kɨ in dɔran’tɨ adɨ’de n’oyi. ");
INSERT INTO gqr_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Nan Jeju gər mərta lə’de ɓətɨ, adɨ el’de ene: «Kin ə, de’gɨ kɨ me konɓe’tɨ kɨ kareba, təli dɔnan’tɨ rɔi nan ə, konɓe’ə kin a tujɨ, ningə kəy’gɨ a budi dɔnan’tɨ mur mur tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Kin ə re Satan inɓe adɨ de’gɨ li’ə təli dɔnan’tɨ rɔi nan ə, lo kadɨ konɓe li’ə a aw kɨ kete goto. M’el be tadɔ eli eyina in kɨ tɔgɨ lə Beljəbul kɨ in ngar lə ndil’gɨ kɨ majel ə m’njɨ m’tuwə’n ndil’gɨ kɨ majel. ");
INSERT INTO gqr_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Kin ə re m’in m’njɨ m’tuwə ndil’gɨ kɨ majel kɨ tɔgɨ lə Beljəbul ə, de’gɨ kɨ go’se’tɨ isɨ tuwəi’de kɨ tɔgɨ lə nan nga? Ingɨ ə a gangi ta lə’se kin. ");
INSERT INTO gqr_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Re in kɨ tɔgɨ lə Luwə ə m’njɨ m’tuwə’n ndil’gɨ kɨ majel ningə, tɔjɨ kadɨ konɓe lə Luwə re te rɔ’se’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Kin ə de kɨ tɔg’ɔ in ngayn, kɨ aw kɨ nya rɔ’gɨ, ngəm takəy lə’ne ə, nya kare kɨ a ɔdɨ kadɨ nyakingə li’ə goto. ");
INSERT INTO gqr_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","A re de madɨ kɨ tɔg’ɔ utə re ur go’ə’tɨ ə tət’ə rɔ ə, a ɔy nya rɔ’gɨ li’ə kɨ uwə kul’de kin pətɨ, taa a kanyi nyakingə’gɨ li’ə kɨ taa ji’ə’tɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","De kɨ in sə’m el ningə, in nje ta lə’m, taa de kɨ kaw sə’m nya kɨ nan’tɨ el, in nje sanan nya kɔ tɔ.» ");
INSERT INTO gqr_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","«Lokɨ ndil kɨ majel te me de’tɨ ningə, aw kɨ yo ge kɨ ne ge diləlo’tɨ tadɔ sangɨ lo kisi. Lokɨ ingə lo el ningə, təl el ene: “M’a m’təl kadɨ m’aw lo kisɨ’m’tɨ kɨ m’te’tɨ gogɨ.” ");
INSERT INTO gqr_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Lokɨ təl re ningə, ingə lo kɨ in kɨ ra majɨ, ndolo. ");
INSERT INTO gqr_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ə təl aw, ɔy ndil’gɨ kɨ majel utəi’ə inɓe ɓay siri, rei sii. Lo kin’tɨ, ji kisi lə de’ə kin a majel utə in kɨ kete inɓe ɓay.» ");
INSERT INTO gqr_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Lokɨ Jeju a elta kin ba ningə, dene kare ilə ndu’ne dann bulə de’gɨ’tɨ ene: «Majikur in dɔ dene’tɨ kɨ nje koj’i kɨ nje kad’i mba.» ");
INSERT INTO gqr_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Nan Jeju ilə’tɨ ene: «Majikur in dɔ de’gɨ’tɨ kɨ nje koo ndu Luwə kɨ nje təl rɔ’de go’tɨ yo taa.» ");
INSERT INTO gqr_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","De’gɨ uwəi nan mukɨ mukɨ gidɨ Jeju’tɨ, adɨ Jeju el’de ene: «De’gɨ kɨ dɔkagilo’tɨ kɨ ɓone kin in de’gɨ kɨ maji el. Dəji kadɨ to n’oyi nyakɔjɨ madɨ, nan nyakɔjɨ madɨ kɨ rangɨ kɨ de a ra ore’n dɔ nyakɔjɨ lə Jonasɨ, goto nga. ");
INSERT INTO gqr_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Tadɔ, tokɨ Jonasɨ in nyakɔjɨ tadɔ lə de’gɨ kɨ Ninibɨ’tɨ kakin ə, Ngonn de a in nyakɔjɨ tadɔ lə de’gɨ kɨ ɓone tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ndɔ gangɨ ta’tɨ ə, ngar kɨ dene kɨ holo a in kɨ de’gɨ kɨ dɔkagilo’tɨ kɨ ɓone kin kadɨ a gangɨ ta dɔ’de’tɨ. Tadɔ, in sanyi dɔnangɨ’tɨ nu ə re kadɨ oo gosita lə Salomon. Nga ningə, kɨ ngɔsine kin, de kɨ utə Salomon sanyi in ne ");
INSERT INTO gqr_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ndɔ gangita’tɨ ə, de’gɨ kɨ Ninibɨ’tɨ a indəi taa non de’gɨ’tɨ kɨ dɔkagilo’tɨ kɨ ɓone kin kadɨ a gangɨ ta dɔ’de’tɨ. Tadɔ, lokɨ Jonasɨ iləmbər Poyta kɨ majɨ, de’gɨ kɨ Ninibɨ’tɨ inyəi gorow njiyə’de’gɨ kɨ majel kɔ. Nga ningə, kɨ ngɔsine kin, de kɨ utə Jonasɨ sanyi in ne. ");
INSERT INTO gqr_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","«De a ində por lambɨ’tɨ kadɨ iyə eke dow ngo dɔ’tɨ el, nan a ində dɔ nya’tɨ taa, kadɨ de’gɨ uri kəy ningə, oyi lo kɨ kunj’ə. ");
INSERT INTO gqr_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Kum de ə in lambɨ lə darɔ’a, re kum’i oo lo majɨ ningə, darɔ’i ba pətɨ in me kunjɨ’tɨ. A kin ə re kum’i oo lo majɨ el ningə, darɔ’i in me lo kɨ diw’tɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ə ində manjɨ rɔ’i adɨ kunjɨ kɨ awɨ’n rɔ’i’tɨ təl diw el. ");
INSERT INTO gqr_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Kin ə re darɔ’i pətɨ in me kunjɨ’tɨ kɨ kanjɨ kadɨ ngonn lo kɨ diw ndətɨ kad’a ningə, darɔ’i a unjɨ njay njay tokɨ lambɨ a unjɨ’n dɔ’i’tɨ kin be tɔ.» ");
INSERT INTO gqr_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Lokɨ Jeju elta tigə ningə, Parisɨ kare ɓar’a kadɨ aw sɔ nya ɓe lə’ne. Be ə, Jeju aw isɨ si’ə ta nyakusɔ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Lo kin’tɨ, ta ndɔjɨ Parisɨ kakin ngayn kadɨ Jeju togɨ ji’ne kete non nyakusɔ’tɨ el. ");
INSERT INTO gqr_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Nan Jeju el’ə ene: «In Parisɨ’gɨ, kɨ ne kin isɨ togi gidɨ kala mann kɨ gidɨ supira kusɔ nya adi ar, nan nyənn ɓogɨ kɨ mendul rosɨ me’se. ");
INSERT INTO gqr_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","In de’gɨ kɨ mbo, Luwə ra gidɨ nya, ə ra me nya tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Majɨ kadɨ adi ngarme’se kɨ kəy kɔrɔkɨ kadikare’tɨ Luwə, ə nya’gɨ pətɨ a ari njay kɨ rɔ’se’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","«Kumtondoo in lə’se in Parisɨ’gɨ, tadɔ ɔri nya kare dann kɨ dɔgɨ’tɨ, me mbi kam’gɨ’tɨ kɨ ətɨ majɨ, kɨ me mbi kam’gɨ kɨ dangɨ dangɨ kadɨ ndiri tanyi, adi Luwə, ningə indəi nja’se dɔ nyara kɨ dana’tɨ kɨ dɔ ndigɨ’tɨ lə Luwə. Kɨ rɔta’tɨ, in kin ə in nya’gɨ kɨ majɨ kadɨ indəi kum’se go’tɨ rai, ə inyəi ndəgə’gɨ kɨ kɔ non be el. ");
INSERT INTO gqr_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Kumtondoo in lə’se, in Parisɨ’gɨ, tadɔ ndigi lo kisɨ kɨ kete non de’gɨ’tɨ me kəykawnan’gɨ’tɨ lə Juwipɨ’gɨ, taa gəi kadɨ de’gɨ rai’de lapiya lo kingənan’gɨ’tɨ lə bulə de’gɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Kumtondoo in lə’se ingɨ, tadɔ toi to dɔɓadɨ’gɨ kɨ nya kɨ tɔjɨ kadɨ de gər’n’de goto, adɨ de’gɨ njiyəi kɨ dɔ’de’tɨ non be par kin be.» ");
INSERT INTO gqr_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Lo kin’tɨ, njendo ndukun kare el Jeju ene: «Njendo de’gɨ, me ta’tɨ lə’i kɨ a el kin, in tɔ ə isɨ tajɨ’je.» ");
INSERT INTO gqr_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ə Jeju ilə’tɨ ene: «Kumtondoo in lə’se, in njendo ndukun’gɨ tɔ, tadɔ indəi nya kɨ ɔy ngayn dɔ de’gɨ’tɨ, nan ngonn ji’se kɨ nden be kaa uni taa uwəi se’de nya kɨ kɔy kin el. ");
INSERT INTO gqr_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Kumtondoo in lə’se ingɨ kɨ isɨ indəi ɓadɨ’gɨ lə de’gɨ kɨ njekeltakita Luwə’tɨ kɨ in baw’se’gɨ inɓe’gɨ ə tɔli’de. ");
INSERT INTO gqr_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Lo kin’tɨ, isɨ tɔji tokɨ in ndigi kɨ baw’se’gɨ dɔ kulə ra’de’tɨ kɨ rai, tadɔ ingɨ tɔli njekelta kɨ ta Luwə’tɨ, ningə ingɨ in nje kində dɔɓadɨ’de’gɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","In tadɔ kin ə, Luwə elta me tər’tɨ lə’ne ene: “M’a m’ulə kɨ njekeltakita’m’tɨ kɨ njekawkulə’gɨ m’adɨ’de, ningə a tɔli’de ge, a adi’de kon ge.” ");
INSERT INTO gqr_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","In be kadɨ dəji de’gɨ kɨ dɔkagilo’tɨ kɨ ɓone, mosɨ njekeltakita kɨ ta’m’tɨ kɨ ɓuki kɔ lo kulə ngirə dɔnangɨ’tɨ nu bitɨ ɓone. ");
INSERT INTO gqr_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Mosɨ kɨ ulə ngirə dɔ Abel’tɨ nu bitɨ te’n dɔ Jakari’tɨ, kɨ tɔli’ə ngawdann lo’tɨ kɨ in ringiri kadikare’tɨ re Kəy’tɨ lə Luwə. In kɨ rɔta’tɨ kadɨ de’gɨ kɨ dɔkagilo’tɨ kɨ ɓone a udəi kɔr nya’gɨ kɨ rai nya kin non Luwə’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Kumtondoo in lə’se, ingɨ njendo ndukun’gɨ kɨ, tarow nyagər in ji’se’tɨ, ə inɓe’gɨ uri me’tɨ el num, taa de’gɨ kɨ ndigɨ kur me lo’tɨ kɨ kadɨ gəri nya kaa, ɔgi’de num tɔ.» ");
INSERT INTO gqr_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Lokɨ Jeju te me kəy’tɨ kakin ningə, njendo ndukun’gɨ kɨ Parisɨ’gɨ uləi ngirə ra tɔgɨ dɔ Jeju’tɨ ge, dəji ta’gɨ kɨ dangɨ dangɨ ge. ");
INSERT INTO gqr_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Sangi row me ta’gɨ kadɨ to n’ingəi ta kɨ go’tɨ el ta’a’tɨ ningə n’uwəi’ə’n’ə. ");
INSERT INTO gqr_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Dɔkagilo’ə’tɨ kin, de’gɨ kɨ dər banyi banyi ə kawinan dɔ Jeju’tɨ, adɨ mbisəi nan kɨ yo ge kɨ ne ge. Lo kin’tɨ, Jeju el njendo’gɨ lə’ne ene: «Nya kɨ dɔkete, majɨ kadɨ indəi kumkədɨ dɔ rɔ’se’tɨ ɔjɨ’n dɔ hum lə Parisɨ’gɨ, adɨ in kədikumnan lə’de. ");
INSERT INTO gqr_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Tadɔ nyara kɨ gidɨ kuwə kɨ ginn’ə, a te el goto taa nya kɨ to lo kiyə’tɨ kɨ de a gər el goto tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","In tadɔ kin ə, ta’gɨ pətɨ kɨ a eli lo kɨ ndul’tɨ, de’gɨ oyi dɔ’a dann kadɨ nda’tɨ; ta’gɨ kɨ uwəi ta’se mbi nan’tɨ taa eli, de’gɨ a rai dɔ kəy’tɨ to iləi mbər’ə.» ");
INSERT INTO gqr_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ingɨ kɨ in madɨ’m’gɨ, m’el’se kadɨ in ɓoli de’gɨ kɨ a tɔli darɔ’se par, ə go’tɨ asi ra nya kɨ rangɨ el, kin el. ");
INSERT INTO gqr_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","M’a m’tɔjɨ’se de kɨ majɨ kadɨ in ɓoli’ə. De kɨ majɨ kadɨ in ɓoli’ə in de kɨ a tɔl darɔ’se, ningə təl aw kɨ tɔgɨ dɔ’tɨ non kadɨ ilə’se me por’tɨ kɨ bitɨ kɨ non’tɨ ɓay kin. Tokɨ rɔta’tɨ, in ə majɨ kadɨ in ɓoli’ə. ");
INSERT INTO gqr_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","De’gɨ isɨ gati kɨ yəl’gɨ mi ə silə joo adɨ oyi ne, nan kɨ kare dann’de’tɨ kɨ kadɨ me Luwə oy dɔ’a’tɨ goto. ");
INSERT INTO gqr_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Kɨ ətɨ ɓol ngayn inɓe ɓay kɨ kadɨ in gəri, bin dɔ’se inɓe kin kaa, Luwə tudə’de kare kare gər kɔr’de, um kadɨ in ɓoli nya madɨ el. Ingɨ kin, Luwə oo tor’se utə tor yəl’gɨ pətɨ. ");
INSERT INTO gqr_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","M’el’se ta kɨ rɔta’tɨ kadɨ in gəri tokɨ, de kɨ elta takum de’gɨ’tɨ wangɨ tokɨ n’in de lə’m, Ngonn de a elta wangɨ takum malayka’gɨ’tɨ lə Luwə tokɨ in de lə’ne. ");
INSERT INTO gqr_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Nan de kɨ manjɨ ta takum de’gɨ’tɨ tokɨ n’gər’m el, Ngonn de a manjɨ ta takum malayka’gɨ lə Luwə tokɨ n’gər’ə el tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","De kɨ elta kɨ majel ɔsɨ’n ta Ngonn de ə, Luwə a inyə go majel’gɨ li’ə kɔ, nan de kɨ elta kɨ mal ɔsɨ’n ta Ndil Luwə, Luwə a inyə go majel li’ə kɔ el ratata. ");
INSERT INTO gqr_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Lokɨ a uwəi’se kadɨ awi sese ta kəykawnan’gɨ’tɨ lə Juwipɨ’gɨ, non nje konɓe’gɨ’tɨ kɨ non njekɔrnon’gɨ’tɨ, ononyi’se kadɨ me’se ɓol ko kene ke a asi kadɨ manjɨ ta dɔ’se’tɨ wa, ke ta ri ə a eli wa. ");
INSERT INTO gqr_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Tadɔ, low’ə’tɨ inɓe non kin, Ndil Luwə a ndo’se ta kɨ kadɨ eli. ");
INSERT INTO gqr_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","De kare dann bulə de’gɨ’tɨ el Jeju ene: «Njendo de’gɨ, el ngonnkon’m adɨ, nya nduwə kɨ baw’je inyə adi’je kin, kadɨ kanyi yan’m adɨ’m.» ");
INSERT INTO gqr_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ə Jeju el’ə ene: «De kɨ ində’m kadɨ to m’in njegangɨ ta dann’se’tɨ eke kadɨ to m’in nje kanyi’se nya goto.» ");
INSERT INTO gqr_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ningə təl el de’gɨ pətɨ ene: «Majɨ kadɨ indəi kumkədɨ dɔ rɔ’se’tɨ ɔjɨ’n dɔ mal nyakingə kɨ dɔnangɨ’tɨ. Tadɔ re de ingə’n nya to ri, to ri kaa, nyakingə li’ə kin ə a ra adɨ si’n kɨ dɔ’ne taa el.» ");
INSERT INTO gqr_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ningə Jeju təl el’de kujita madɨ ene: «Dingəm madɨ kare kɨ njenyakingə isɨ non, lo ndɔɔ’gɨ li’ə, kandɨ nya te’tɨ majɨ ngayn. ");
INSERT INTO gqr_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ə dəjɨ rɔ’ne ta ene: “In ri ə kadɨ to m’ra dana? Lokɨ kadɨ to m’kaw nya ndɔɔ’tɨ lə’m goto.” ");
INSERT INTO gqr_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ningə təl el ene: “Majɨ, nya kɨ m’a m’ra ə to kin: m’a m’ndu dam’gɨ lə’m kɨ kete kin kɔ, ningə m’a m’ur dam’gɨ kɨ boi ngayn kadɨ to m’kaw nya ko’gɨ’tɨ lə’m pətɨ pətɨ, nan’tɨ kɨ ndəgɨ nya majɨ’gɨ lə’m. ");
INSERT INTO gqr_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ningə m’a m’el me’m’tɨ m’ene: ‹Ngɔsine m’aw kɨ nyakingə kɨ to mbar mbar kadɨ m’ra’n ɓal banyi banyi, ə kadɨ m’uwə kɔr rɔ’m, m’njɔ ge, m’anyi ge, m’oo’n majɨ rɔ’m.›” ");
INSERT INTO gqr_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Nan Luwə el’ə ene: “In mbo de kɨ isɨ elta kin, kondɔ’tɨ ne inɓe kin ndɔ’i a asɨ. Eke nya’gɨ kɨ isɨ kaw kɨ dɔnan’tɨ kin, a in yan nan wa?” ");
INSERT INTO gqr_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","In kin ə in nya kɨ a te dɔ de’tɨ kɨ nje kaw nyakingə’gɨ kɨ nan’tɨ tadɔ lə rɔ’ne inɓe, um tadɔ lə Luwə el.» ");
INSERT INTO gqr_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jeju el njendo’gɨ lə’ne ene: «In tadɔ kin ə, m’el’se kadɨ adi me’se ra sururu dɔ nyakusɔ’se’tɨ kɨ kadɨ isɨ kɨ dɔ’se taa el, taa dɔ ku kɔ’se’tɨ el num tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Tadɔ kisikidɔtaa utə nyakusɔ, taa darɔ de utə ku kɨ kɔ tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Gonyi kagan’gɨ oyi, duwi ko el num, təti el num, taa awi kɨ lo madɨ kɨ kadɨ ngəmi nya’tɨ tadɔ ndɔ kɨ lo ti’tɨ el num, dam lə’de kaa goto num tɔ, nan Luwə isɨ adɨ’de nya sɔi majɨ. Ningə ingɨ, oyi kadɨ Luwə oo nda’se utə yəl’gɨ el wa? ");
INSERT INTO gqr_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Nan dann’se’tɨ ə asɨ kadɨ a ilə ngonn kadɨ kɨ nden be dɔ ndɔ’ne’tɨ kɨ takul me kɨ ra sururu lə’ne wa? ");
INSERT INTO gqr_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Kin ə nya kɨ nden be kin kaa asi kadɨ rai dɔrɔ’se el ə, majɨ kadɨ adi me’se osɨ nanga dɔ ndəgɨ nya’gɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Gonyi putɨ kam’gɨ kɨ rai me mu’tɨ kin oyi, rai kulə madɨ el num, oji ku el tɔ, nan ngar *Salomon kɨ tɔ’a ɓar ngayn me nyakingə’tɨ kin kaa, ɔɔ ku kɨ ndolo asɨ nan se’de el. ");
INSERT INTO gqr_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ə kin ə, Luwə ulə ku rɔ ngann mu’gɨ’tɨ kɨ j’oo’de ɓone, ə lo ti par ə por a on’de kin be ningə, ra bann ə in de’gɨ taa a ulə ku rɔ’se’tɨ el wa? In ton’gɨ me kunme’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Adi mərta aldɔ’se ɔjidɔ nyakusɔ’se eke mann kanyi’se el. ");
INSERT INTO gqr_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Nya’gɨ kin pətɨ, in de’gɨ kɨ gəri Luwə el kɨ dɔnangɨ’tɨ ne kin ə isɨ sangi kɨ non kum’de’tɨ, nan ingɨ, Baw’se gər majɨ kadɨ awi kɨ ndoo’ə tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Nya kɨ kadɨ sangi, in Konɓe li’ə yo, ningə a adɨ’se ndəgɨ nya’gɨ kin dɔ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Adi ɓol ra’se el, ingɨ kɨ toi to ngann nyakul’gɨ kɨ isɨ uni go ɓe’de be kin. Tadɔ Baw’se oo majɨ ngayn kadɨ adɨ’se Konɓe. ");
INSERT INTO gqr_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","«Indəi nya majɨ’gɨ lə’se ndogɨ’tɨ, ə adi nar’a njendoo’gɨ. Rai ɓɔl nar kɨ a tujɨ el, indəi nyakingə’gɨ lə’se kɨ a tujɨ el dɔnan’tɨ dɔnan’tɨ dɔran’tɨ, kɨ in lo kɨ njeɓogɨ a te’tɨ el num, in lo kɨ yon kɨ njetujɨ nya kaa goto’tɨ num kin. ");
INSERT INTO gqr_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Tadɔ, lo kɨ nyakingə lə’se in səm’tɨ ə me’se a in səm’tɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","«Sii dɔ nja’se’tɨ kɨ ku ra kulə, adi por lambɨ’gɨ lə’se on majɨ. ");
INSERT INTO gqr_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ningə kadɨ toi to de’gɨ kɨ isɨ nginəi ta təl ɓe’de kɨ aw lo taa nan’tɨ be. Isɨ nginəi taa kadɨ re təl taa, ə ində takəy ningə tei adi’ə. ");
INSERT INTO gqr_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Majikur in dɔ njekuləɓər’gɨ’tɨ kɨ, ɓe’de təl ningə ingə’de sii dɔ nja’de’tɨ. Tokɨ rɔta’tɨ, adɨ m’el’se, ɓe’de a un ku kulə lə’ne ulə rɔ’ne’tɨ, ə a adi’de sii nangɨ kadɨ adi’de nya sɔi. ");
INSERT INTO gqr_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Kin ə re təl dann lo’tɨ, eke ta ginn lo’tɨ, ə ingə de sii dɔ nja’de’tɨ ə, majɨ a ur’de. ");
INSERT INTO gqr_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","«In gəri majɨ kadɨ re ɓe nje kəy gər dɔ kadɨ kɨ njeɓogɨ a re’n’tɨ ə, a inyə njeɓogɨ adɨ mbutɨ bɔr kəy li’ə el. ");
INSERT INTO gqr_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ə ingɨ kaa, sii dɔ nja’se’tɨ tɔ, tadɔ m’in Ngonn de m’a m’re dɔ kadɨ’tɨ kɨ in gəri el.» ");
INSERT INTO gqr_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Lo kin’tɨ, Piyər dəjɨ Jeju ene: «Burəɓe, kujita kɨ el kin sɔw dɔ’je eke sɔw dɔ de’gɨ pətɨ wa?» ");
INSERT INTO gqr_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ə Burəɓe el’ə ene: «Njengəm nya kɨ in de kɨ nje ra nya kɨ low’ə’tɨ, kɨ kum’ə ədɨ ə in de kɨ ɓe’ə a ində dɔ me kəy’tɨ kadɨ lowə nyakusɔ de’gɨ kɨ dɔ kadɨ kɨ kadɨ adɨ’n’de. ");
INSERT INTO gqr_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Njerakulə kin a in nje majikur, lokɨ ɓe’ə təl ə ingə ta kulə’tɨ kin, ra ra. ");
INSERT INTO gqr_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Tokɨ rɔta’tɨ adɨ m’el’se, a ində dɔ nya majɨ’gɨ’tɨ lə’ne pətɨ. ");
INSERT INTO gqr_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","A kin ə re nje ra kulə kin el me’ne’tɨ ene: “Ɓe’m a re kalangɨ el ɓay”, ə ra ta tində ndəgɨ nje ra kulə’gɨ’tɨ kɨ dene kɨ kɨ dingəm, ra ta kusɔ’tɨ kɨ ta kanyi’tɨ, adɨ yiwi ra’a ningə, ");
INSERT INTO gqr_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Lokin’tɨ ɓe nje kəy a re kɨ ndɔ kɨ in ində me’ne dɔ’tɨ el, kɨ dɔ kadɨ kɨ in gər el. Ɓe’ə a ɔj’ɔ kum’ə, kadɨ oo nya kon kɨ a ra de’gɨ kɨ njera nya kɨ dana el. ");
INSERT INTO gqr_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Njekuləɓər kɨ gər ndigira lə ɓe’ne majɨ, nan ində rɔ’ne ta ndigira’tɨ kin ra el, a ndəi’ə ngayn. ");
INSERT INTO gqr_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Nga ningə, njekuləɓər kɨ gər ndigira lə ɓe’ne el, ə ra nya kɨ asɨ ta kində wa, a ingə kində ngayn el. De kɨ adi’ə ngayn, a dəji’ə ngayn ngayn tɔ, de kɨ adi’ə me’de adɨ adi’ə nya ngayn, a gei nya ngayn ji’ə’tɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","«M’re kɨ por dɔnangɨ’tɨ; ningə k’in ə, m’ndigɨ kadɨ por kakin on nga! ");
INSERT INTO gqr_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","majɨ kadɨ m’a m’osɨ me kon’tɨ to de kɨ osɨ me mann batəm’tɨ be. Ningə in nya kɨ adɨ’m kon me ndil’m’tɨ, bitɨ kadɨ nya kin ra’n nya. ");
INSERT INTO gqr_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Kadɨ in məri me’se’tɨ tokɨ m’re kɨ lapiya dɔnangɨ’tɨ el. M’el’se, m’re kɨ lapiya el jagɨ, nan m’re kɨ gangɨ nan yo. ");
INSERT INTO gqr_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kɨ ngɔsine kin, de’gɨ mi kɨ sii me kəy’tɨ kɨ kare a gangi nan, de’gɨ kɨ mutə a ɔsi ta nje kɨ joo, ə de’gɨ kɨ joo a ɔsi ta nje kɨ mutə. ");
INSERT INTO gqr_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Baw ngonn a ɔsɨ ta ngonn’ne kɨ dingəm, ngonn’o kɨ dingəm a ɔsɨ ta baw’ne; kon ngonn a ɔsɨ ta ngonn’ne kɨ dene, ngonn kɨ dene a ɔsɨ ta kon’ne; kon ngonn kɨ dingəm a ɔsɨ ta məm’ne; ngonn kɨ dene a ɔsɨ ta məm’ne kɨ dene.» ");
INSERT INTO gqr_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jeju el bulə de’gɨ ene: «Lokɨ oyi ndi in lo kuwə kadɨ’tɨ ningə, tanan’tɨ non eli eyina: “ndi a ədɨ”, ningə ndi ədɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","A re oyi nəl kɨ in holo ə sii ulə ningə, eli eyina: “Lo a tingə”, ningə lo tingə kaa tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","In de’gɨ kɨ njekedikum de’gɨ, asi gəri kum nya’gɨ kɨ isɨ rai nya dɔnangɨ’tɨ ne, eke dɔran’tɨ, ningə ra bann be ə nyakɔjɨ’gɨ kɨ isɨ rai nya dɔkagilo’tɨ kɨ ɓone taa, asi kadɨ indəi manjɨ nya’gɨ kɨ isɨ rai nya səm’tɨ el wa! ");
INSERT INTO gqr_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","«Ra bann be ə inɓe’gɨ, nya kɨ to kadɨ gangɨ ta dana dɔ’tɨ ə, gangi el wa? ");
INSERT INTO gqr_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Kin ə isɨ awi lo gangɨ ta’tɨ kɨ nje ta lə’i ə, lokɨ in dɔ row’tɨ ɓay ə, in sangɨ row kadɨ ndu’se osɨ go nan’tɨ si’ə, nan to aw sə’i uləi ji njegangita’tɨ, adɨ njegangɨ ta uni uləi ji njerɔ’gɨ’tɨ, adɨ njerɔ’gɨ iləi’nu dangay’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ningə adɨ m’el’i, a in te lo kin’tɨ el bitɨ kadɨ ugə dɔboy sisi ɓay taa a inyəi’nu taa.» ");
INSERT INTO gqr_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Dɔkagilo’ə’tɨ non ə, de’gɨ madɨ rei eli Jeju eyina: Pilatɨ adɨ tɔli de’gɨ kɨ Galile’tɨ dɔkagilo’tɨ kɨ isɨ ujəi mosɨ kadikare adi Luwə. ");
INSERT INTO gqr_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jeju el’de ene: Məri kadɨ de’gɨ kɨ Galile’tɨ kɨ ingəi nya kɨ to kɨ ətɨ ɓol be kin in tadɔ k’in ə in njeramajel’gɨ kɨ ngayn utəi ndəgɨ de’gɨ kɨ Galile’tɨ wa? ");
INSERT INTO gqr_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Jagɨ nan inɓe’gɨ kaa adɨ m’el’se, re mbəli panjiyə’se el ə a oyi pətɨ tigə tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ke oyi kadɨ de’gɨ kɨ dɔgɨ gidə in jijoo kɨ ndogɨ bɔr kɨ Silowe osɨ dɔ’de’tɨ ə tɔl’de kin, majel lə’de utə ndəgɨ de’gɨ kɨ Jerujalem’tɨ pətɨ tigə wa? ");
INSERT INTO gqr_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Jagɨ! Inɓe’gɨ kaa adɨ m’el’se, re mbəli panjiyə’se el ə, a oyi pətɨ tigə tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Go ta’gɨ’tɨ kin, Jeju el kujita kin: «Dingəm kare aw kɨ kagɨ mbaykote kare kɨ man me ndɔɔ kagɨ nju’tɨ lə’ne. Ndɔ kare, re kadɨ ujə kanda ningə ingə el. ");
INSERT INTO gqr_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Be ə, el nje ra kulə me ndɔɔ nju’tɨ lə’ne ene: “Oo ɓal asɨ mutə nga ə m’sangɨ kadɨ m’ujə kandɨ mbay kam m’njɔ, nan m’ingə el. Majɨ kadɨ tugə kɔ, tadɔ ri ə a utɨ’n kum lo kare wa?” ");
INSERT INTO gqr_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Nje ra kulə me ndɔɔ nju’tɨ kakin el’ə ene: “Ɓe’m, majɨ kadɨ inyə adɨ ra ɓal kare ɓay. M’a m’ɔr ginn’ə ə m’ɓukɨ sin binyə nja’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Re ɓal kɨ a re kam ə andɨ ə, majɨ! A re andɨ el ə, a tugə kɔ mindɨ.”» ");
INSERT INTO gqr_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Jeju ndo nya de’gɨ ndɔ kɔrkon’tɨ, me kəykawnan’tɨ lə Juwipɨ’gɨ kare. ");
INSERT INTO gqr_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Dene kare kɨ ndil kɨ majel budɨ nja’a asɨ ɓal dɔgɨ gidə in jijoo isɨ səm’tɨ non. Ndil kakin dɔ’a ngonn adɨ lo kadɨ surə ta goto. ");
INSERT INTO gqr_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Lokɨ Jeju oo’ə ningə ɓar’a ə el’ə ene: «Dene in kɨ ta k’inyə ta dɔ rɔ koy njururu’tɨ lə’i.» ");
INSERT INTO gqr_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Jeju ində ji’ne dɔ’a’tɨ, ningə tanan’tɨ non par ə, dene ndajɨ ə in ra ta, ə ulə ngirə kadɨ ulə tɔjɨ dɔ Luwə’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ningə njekundɔ kəykawnan’tɨ lə Juwipɨ’gɨ kakin rɔ’a nəl’ə el tadɔ Jeju adɨ lapiya de ndɔ kɔrkon’tɨ, adɨ el bulə de’gɨ ene: Ndɔ ra kulə in mehen. Rei adɨ adi’se lapiya me ndɔ’gɨ’tɨ kin um ndɔ kɔrkon’tɨ el! ");
INSERT INTO gqr_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Burəɓe el’ə ene: In njekədikum de’gɨ! de kɨ ra dann’se’tɨ ə tutɨ mangɨ lə’ne eke koro lə’ne ndɔ kɔrkon’tɨ, lo kusɔ nya’tɨ aw si’ə lo kanyi mann’tɨ el wa? ");
INSERT INTO gqr_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Nga dene kam kɨ in ngonnkaw Abiraham, kɨ Satan uwə ginn tɔgɨ’tɨ lə’ne asɨ ɓal dɔgɨ gidə in jijoo be kin ə, kadɨ m’tut’ə m’ilə ta el tadɔ k’in kɨ in ndɔ kɔrkon wa? ");
INSERT INTO gqr_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Dɔkagilo’ə’tɨ kɨ Jeju isɨ elta kin ningə, rɔ njeban’gɨ li’ə sɔl’de ngayn. Nan rɔ bulə de’gɨ nəl’de ngayn tadɔ nya’gɨ kɨ majɨ majɨ kɨ Jeju isɨ ra. ");
INSERT INTO gqr_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Go’tɨ ningə Jeju ene: «Ri ə tanan kɨ Konɓe lə Luwə wa? Ri ə m’a m’un m’ɔjɨ’n wa? ");
INSERT INTO gqr_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","To tanan kɨ kandɨ kagɨ madɨ kɨ a ɓari’ə mutardə kɨ de madɨ un duw me ndɔɔ’tɨ lə’ne. Kandɨ kagɨ kakin uwə ə tɔgɨ ningə təl kagɨ, adɨ yəl’gɨ uwəi lo kisɨ baji’ə’gɨ’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jeju təl el ɓay ene: «Ri ə m’a m’un m’ɔjɨ’n Konɓe lə Luwə wa? ");
INSERT INTO gqr_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","To tanan kɨ hum kɨ dene madɨ un lɔy’n ndujɨ kɨ me keh mutə, kɨ ra adɨ ndujɨ kɨ lɔy ba pətɨ in kin be.» ");
INSERT INTO gqr_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Dɔ row kaw’a Jerujalem’tɨ, Jeju ndo nya de’gɨ ɓebo’gɨ’tɨ kɨ ngann ɓe’gɨ kɨ ində dana gangɨ səm’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","De madɨ dəj’ə ene: «Burəɓe, de’gɨ nden ba par ə a aji wa?» Jeju el’de ene: ");
INSERT INTO gqr_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«Uwəi tɔgɨ’se ba kadɨ uri kəy kɨ tarow kɨ mbəngirə, tadɔ adɨ m’el’se, de’gɨ ngayn a sangi kadɨ n’uri nan a asi el. ");
INSERT INTO gqr_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Lokɨ ɓe nje kəy a ində taa ə a utɨ takəy. Ningə ingɨ kɨ nanyi taga, a uləi ngirə kində takəy eyina: “Burəɓe te takəy adɨ’je!”, ningə a el’de ene: “Ingɨ m’gər lo kɨ in səm’tɨ el.” ");
INSERT INTO gqr_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ningə a eli’ə eyina: “J’usɔ nya sə’i num, j’anyi sə’i num, ta ndo nya de’gɨ tambalo’gɨ’tɨ me ɓebo’gɨ’tɨ lə’je tɔ.” ");
INSERT INTO gqr_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ningə, a el’se ene: “M’gər lo kɨ in səm’tɨ el, ɔri rɔ’se kɔ rɔ’m’tɨ. Ingɨ pətɨ in njeramajel’gɨ.” ");
INSERT INTO gqr_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Low’ə’tɨ kin, a nonyi ge, a ngori ngangɨ’se ge, lokɨ a oyi Abiraham ge, Isakɨ ge, Jakobɨ ge, kɨ njekeltakita Luwə’tɨ pətɨ me Konɓe’tɨ lə Luwə. Ningə ingɨ a ɓuki’se kɔ taga. ");
INSERT INTO gqr_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","De’gɨ a indəi lo kuwə kadɨ’tɨ ge, kɨ lo kurkadɨ’tɨ ge, manga ge, holo ge, kadɨ rei sii ta nyakusɔ’tɨ Konɓe’tɨ lə Luwə. ");
INSERT INTO gqr_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Nan, tokɨ rɔta’tɨ, nje kɨ madɨ kɨ in nje kɨ gogɨ a təli nje kɨ kete nje kɨ madɨ kɨ in nje kɨ kete a təli nje kɨ gogɨ.» ");
INSERT INTO gqr_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Dɔkagilo’ə’tɨ inɓe kin ə, Parisɨ’gɨ madɨ rei rɔ Jeju’tɨ eli’ə eyina: «Ɔtɨ kɔ rangɨ lo kin’tɨ, tadɔ Erodɨ ge tɔli.» ");
INSERT INTO gqr_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jeju el’de ene: «Ai eli tal busɨ kam, tokɨ ɓone kɨ lo ti, m’njɨ m’tuwə ndil’gɨ kɨ majel ə m’njɨ madɨ de’gɨ lapiya tɔ. Ningə ndɔ kɨ nja mutə ə m’a tɔlta kulə lə’m. ");
INSERT INTO gqr_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Nan in gorow’ə’tɨ kadɨ m’un tarow lə’m me ndɔ’tɨ kɨ ɓone, ndɔ kɨ lo ti’tɨ kɨ ndɔ kɨ nja mutə, tadɔ in nya kɨ gorow’ə’tɨ el kadɨ njekeltakita Luwə’tɨ, oyi Jerujalem’tɨ el. ");
INSERT INTO gqr_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","«In de’gɨ kɨ Jerujalem’tɨ, in de’gɨ Jerujalem’tɨ, in kɨ nje tɔl de’gɨ kɨ njekeltakita Luwə’tɨ, in nje tilə de’gɨ kɨ Luwə ulə’de adɨ’se kɨ mbal tɔli’de. Nja bann ə m’ge kaw’se tokɨ konkunjə a kaw’n ngann’ne’gɨ ginn bagɨ’ne’tɨ kin be nan ɔdi el. ");
INSERT INTO gqr_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ningə kɨ ne kin, m’in Luwə m’a m’inyə kəykawnan lə Luwə lə’se kɔ. Tadɔ adɨ m’el’se madɨ oyi, a oyi m’in el nga, bitɨ ndɔ kɨ a eli eyina: “Njangɨ dɔ in dɔ de’tɨ kɨ a re me tɔ Burəɓe’tɨ.”» ");
INSERT INTO gqr_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ndɔ kare, Jeju aw me kəy’tɨ lə njekundɔ Parisɨ’gɨ kare tadɔ kusɔ nya, ndɔ kɔrkon’tɨ. Parisɨ’gɨ isɨ ndəi manjɨ Jeju. ");
INSERT INTO gqr_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Dingəm kare kɨ nje monyi rɔ ti ə ra non’a’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jeju dəjɨ njendo ndukun’gɨ kɨ Parisɨ’gɨ ene: «Ta row to kadɨ de adɨ lapiya de ndɔ kɔrkon’tɨ eke goto?» ");
INSERT INTO gqr_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Nan təli rai keke, de elta el. Jeju təl rɔ’ne rɔ nje monyi rɔ ti’tɨ, ad’a lapiya ə el’ə ad’a aw. ");
INSERT INTO gqr_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ningə el’de ene: «Nan dann’se’tɨ anyɨ ngonn’o eke mangɨ li’ə osɨ bolo ɓe’tɨ ndɔ kɔrkon’tɨ ə un’ə tanan’tɨ non el wa?» ");
INSERT INTO gqr_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ningə lo kadɨ iləi’ə ta’tɨ kin goto. ");
INSERT INTO gqr_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Lokɨ Jeju oo kadɨ de’gɨ kɨ ɓari’de mbətɨ lo kisɨ kɨ kete ningə el’de kujita ene: ");
INSERT INTO gqr_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«Lokɨ de madɨ ɓar’i lo nyakusɔ tanan’tɨ, ononyi kadɨ sangɨ lo kɨ kete isɨ’tɨ, dɔmajɨ ə, ɓari de kɨ kɔsigon li’ə utə yan’i səm’tɨ tɔ! ");
INSERT INTO gqr_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ningə kadɨ nje ɓar’se joo pətɨ kakin re, el’i ene: “Ində taa ə inyə lo kisi kin adɨ mad’i.” Ningə kɨ rɔsɔl kɨ ngayn ə a aw kadɨ isɨ’n lo kɨ gogɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Nan lokɨ de madɨ ɓar’i, majɨ kadɨ aw isɨ lo kɨ gogɨ’tɨ, adɨ nje ɓar’i inɓe ə re el’i ene: “Madɨ’m ində taa re isɨ kete yo.” Be ə a in kɔsikurə lə’i takum mad’i’gɨ’tɨ pətɨ kɨ ɓari’de lo nyakusɔ’tɨ sə’i. ");
INSERT INTO gqr_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Tokɨ rɔta’tɨ, de kɨ un dɔ’ne ta, ə a uləi dɔ’a nanga. Ningə de kɨ nje sɔl dɔ’ne ə, a uni dɔ’a ta tɔ.» ");
INSERT INTO gqr_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Go’tɨ ningə Jeju el de kɨ nje ɓar’a ene: «Lokɨ ra nyakusɔ rɔnel kɨ ngayn be kin, kɨ kada eke kɨ losɔl’ɔ, ononyi kadɨ ɓar mad’i’gɨ kɨ ngannkon’i’gɨ kɨ noj’i’gɨ, eke nje gədɨ kəy ɓe lə’i kɨ njenyakingə’gɨ. Tadɔ ingɨ kaa a ɓari’nu ndɔ madɨ’tɨ ə a adi’nu nya kɨ ndɔ kɨ ra adi’de kin gogɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Nan lokɨ ra nyakusɔ rɔnel kɨ ngayn be kin, majɨ kadɨ ɓar njendoo’gɨ kɨ nje’gɨ kɨ ta rɔ’de asɨ nan el kɨ nje mote’gɨ, kɨ njekumtɔ’gɨ. ");
INSERT INTO gqr_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ningə rɔ’i a nəli tadɔ a ingəi nya kadɨ ugəi’nu gogɨ el. Tokɨ rɔta’tɨ, Luwə a ugəi ndɔ kɨ a te kɨ njera nya kɨ dana lo koy’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Lokɨ oyi ta kin ningə, kɨ kare dann de’gɨ’tɨ kɨ sii lo nyakusɔ’tɨ el Jeju ene: «Rɔnel a in kɨ de kɨ a sɔ nya me Konɓe’tɨ lə Luwə!» ");
INSERT INTO gqr_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jeju təl el’ə ene: «Ndɔ kare, dingəm madɨ ra nyakusɔ kibo ɓarɨ’n de’gɨ ngayn. ");
INSERT INTO gqr_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Dɔkagilo kusɔ nya’tɨ, ningə ulə njekulə lə’ne adɨ el de’gɨ kɨ ɓar’de kakin ene: “Rei! Nyakusɔ oy nga.” ");
INSERT INTO gqr_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Nan de’gɨ pətɨ kɨ ɓari’de kakin, kare kare, uləi ngirə kadɨ dəji mesɔl. In kɨ dɔkete el’ə ene: “M’ndogɨ lo ndɔɔ ngɔsine ɓay ə kadɨ m’aw m’oo. Nja’i ba adɨ me’i sɔl dɔ’m’tɨ.” ");
INSERT INTO gqr_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","In kɨ rangɨ ene: “M’ndogɨ mangɨ’gɨ dɔgɨ ngɔsine ɓay, m’a m’aw kadɨ m’nan’de m’oo. Nja’i ba, adɨ me’i sɔl dɔ’m’tɨ.” ");
INSERT INTO gqr_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","In kɨ rangɨ ene: “M’taa dene ngɔsine ɓay, lo kadɨ m’a m’aw goto.” ");
INSERT INTO gqr_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Njekulə təl aw rɔ ɓe’ne’tɨ, el’ə ta’gɨ pətɨ kɨ eli’ə kin ad’a oo. Lo kin’tɨ wongɨ tɔl ɓe nje kəy kakin adɨ el njekulə lə’ne ene: “Ində taa kalangɨ aw tambalo’gɨ’tɨ kɨ go row’gɨ ɓar njendoo’gɨ, kɨ de’gɨ kɨ ta rɔ’de asɨ nan el, kɨ njekumtɔ’gɨ, kɨ de’gɨ kɨ nje mote’gɨ, re se’de.” ");
INSERT INTO gqr_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Nden go’tɨ ningə njekawkulə re el ene: “Ɓe’m, jɨ ra nya’gɨ kɨ dəjɨ kakin pətɨ, nan lo kisɨ nanyi ɓay.” ");
INSERT INTO gqr_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Be’ə el’ə ene: “Ɔtɨ aw taga dɔ row’gɨ’tɨ kɨ lo ndɔɔ’gɨ’tɨ, ində tɔgɨ dɔ de’gɨ’tɨ adɨ’de rei kadɨ me kəy lə’m rosɨ.” ");
INSERT INTO gqr_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Tokɨ rɔta’tɨ adɨ m’el’se, de kare mbunə de’gɨ’tɨ kɨ m’ɓar’de kete kin kɨ, a ɔdɨ nyakusɔ lə’m kin ta’ne’tɨ goto.» ");
INSERT INTO gqr_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Bulə de’gɨ ngayn isɨ njiyə kɨ Jeju dɔ row’tɨ. Təl ilə rətɨ ningə el’de ene: ");
INSERT INTO gqr_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«Re de madɨ re rɔ’m’tɨ ə ge’m utə baw’ne kɨ kon’ne el, ne’ne kɨ ngann’a’gɨ el, ngannkon’ne’gɨ kɨ konnann’ne’gɨ eke darɔ’ne inɓe el, a asɨ k’in njendo lə’m el.» ");
INSERT INTO gqr_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Taa de kɨ un kagidəsɨ lə’ne ə njiyə go’m’tɨ el, a asɨ k’in njendo lə’m el tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Tokɨ rɔta’tɨ, nan dann’se’tɨ ə lokɨ aw to kində ndogɨ bɔr kɨ ngal ningə, isɨ nanga ulə kɔr nyara kulə’gɨ nan’tɨ, kadɨ n’oo ke n’a n’asi kadɨ n’tɔlta kulə kin kare inɓe el wa? ");
INSERT INTO gqr_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Nan re ində ginn kəy ə tɔlta’a el ə, de’gɨ pətɨ kɨ a oy ginn kəy kin, a kogi dɔ’a’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","A eli eyina: «Oyi, dingəm kɨ tumginn kadɨ ində kəy, nan tɔg’ɔ asɨ kadɨ tɔlta’a el kin!» ");
INSERT INTO gqr_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Eke ngar kɨ ra ə lokɨ isɨ aw kadɨ rɔ kɨ ngar madɨ’ne kɨ rangɨ ningə, isɨ nanga ə dəjɨ ta rɔ’ne oo ke kɨ njerɔ’gɨ lə’ne kɨ dər dɔgɨ kare kin n’a n’aw n’ilə’n rɔ madɨ’ne kɨ isɨ re kɨ njerɔ’gɨ lə’ne kɨ in dər dɔ joo kin kare inɓe el wa? ");
INSERT INTO gqr_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Re oo kadɨ tɔgɨ’ne a asɨ el ningə, a ulə dəjɨ ta ngar madɨ’ne, tadɔ sangɨ row lapiya, lokɨ ndan ngal ɓay. ");
INSERT INTO gqr_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ta lə’se kaa to be tɔ. De kɨ in ndəkba tadɔ k’inyə nyakingə’gɨ lə’ne el, a asɨ k’in njendo lə’m el. ");
INSERT INTO gqr_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","«In gəri kadɨ katɨ in nya kɨ majɨ, nan lokɨ nəl’ə goto, eke ri ə de a ra’n adɨ təl nəl gogɨ wa? ");
INSERT INTO gqr_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Nya kɨ kadɨ de a ra’n goto. A majɨ tadɔ dɔnangɨ el num, a majɨ tadɔ nya kɨ a adɨ tɔgɨ dɔnangɨ kin el num tɔ. A ɓuki’ə kɔ gidɨ lo’tɨ. De kɨ aw kɨ mbi’ne kadɨ oo’n ta, ningə kadɨ oo ta kin majɨ.» ");
INSERT INTO gqr_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Njetalambo’gɨ kɨ njeramajel’gɨ, ɔti kɨ rɔ Jeju’tɨ kadɨ n’oyi dɔ ta li’ə. ");
INSERT INTO gqr_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Parisɨ’gɨ kɨ njendo ndukun’gɨ ɓarita, eli eyina: «uwə njeramajel’gɨ rɔ’ne’tɨ num sɔ nya se’de num!» ");
INSERT INTO gqr_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ningə, Jeju el’de kujita kin: ");
INSERT INTO gqr_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Nan dann’se’tɨ ə re aw kɨ batɨ’gɨ ɓu ə kɨ kare nanyi ningə, a inyə ndəgə’gɨ kɨ dɔjikara gidə in jikara dɔ mu’tɨ, ə aw sangɨ in kɨ nanyi kin, bitɨ kadɨ ingə ɓay taa el wa? ");
INSERT INTO gqr_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Lokɨ təl ingə ningə, kɨ rɔnel un’ə ilə dam’ne’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ningə təl aw ɓe. Ɓar madɨ’ne’gɨ kɨ nje gədɨ kəy lə’ne, el’de ene: «Rei rai rɔnel sə’m tadɔ m’ingə batɨ lə’m kɨ nanyi!» ");
INSERT INTO gqr_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Be tɔ ə adɨ m’el’se, rɔnel a in ngayn me dɔran’tɨ tadɔ njeramajel kare kɨ inyə gorow njiyə’ne kɨ majel kɔ, utə nje’gɨ kɨ dana kɨ dɔjikara gidə in jikara kɨ awi kɨ ndoo mbəl panjiyə’de el kin. ");
INSERT INTO gqr_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ke, dene kɨ ra ə aw kɨ silə asɨ dɔgɨ, ə kɨ kare nanyi, ningə ində por ta ngəl’tɨ eke utə me kəy sangɨ’n silə lə’ne, bitɨ kadɨ ingə ta el wa? ");
INSERT INTO gqr_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Lokɨ ingə nga ningə, ɓar madɨ’ne’gɨ, kɨ nje gədɨ kəy ɓe lə’ne ə el’de ene: «Rai rɔnel sə’m tadɔ m’ingə silə lə’m kɨ nanyi!» ");
INSERT INTO gqr_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Be tɔ ə, adɨ m’el’se, rɔnel in ngayn mbunə malayka’gɨ’tɨ lə Luwə tadɔ njeramajel kare kɨ inyə gorow njiyə’ne kɨ majel kɔ. ");
INSERT INTO gqr_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jeju təl el ɓay ene: «Dingəm kare aw kɨ ngann’gɨ joo. ");
INSERT INTO gqr_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","In kɨ du el baw’ne ene: “Bai, adɨ’m nya nduwə lə’m.” Be ə baw’a lowə nyakingə lə’ne ngann’ne’gɨ kɨ joo. ");
INSERT INTO gqr_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ndɔ ngayn el go’tɨ ningə, in kɨ du adɨ ndogi si’ə nya’gɨ pətɨ kɨ ingə, ə aw mbah me ɓe’tɨ kɨ sanyi. Me ɓe’tɨ kakin ə tujɨ kɨ nar lə’ne kɔ me kaya’tɨ kɨ ra. ");
INSERT INTO gqr_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Lokɨ tujɨ kɨ nar lə’ne kakin pətɨ tigə ningə, ɓo bo osɨ me ɓe’tɨ kakin. Ningə ulə ngirə kadɨ nya’gɨ pətɨ toi rɔ’a nga. ");
INSERT INTO gqr_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Aw ra kulə ɓe lə de madɨ kare me ɓe’tɨ kin non. Dingəm kakin ad’a kulə ngəm kɔsongɨ’gɨ mu. ");
INSERT INTO gqr_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ɓo kusɔ nyakusɔ lə kɔsongɨ’gɨ to me’ə’tɨ, nan de kɨ ad’a goto. ");
INSERT INTO gqr_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Be ə ulə ngirə kadɨ mərta, ningə el rɔ’ne ene: “Nje ra kulə’gɨ in bann ɓe lə bai ə sɔi nya dum’de dum’de, ə m’in taa m’njɨ m’oy koy ɓo be wa! ");
INSERT INTO gqr_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","M’a m’ində taa ə m’aw rɔ bai’tɨ m’a m’el’ə m’ene: ‹M’ra majel m’ɔsɨ’n ta Luwə, ta m’ɔs’i ta tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Masɨ kadɨ ɓarɨ’m ngonn’i el. Ra’m tokɨ kare mbunə nje ra kulə’gɨ’tɨ lə’i be.›” ");
INSERT INTO gqr_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Be ə, ində taa osɨ row’ə təl kaw rɔ baw’ne’tɨ. Lokɨ n’anyi sanyi kɨ kəy ɓay ningə baw’a oo ə, oo kumtondoo li’ə, ə ta on me’ə ngayn tadɔ li’ə. Anyi kɨ ngodɨ tilə kum’ə, uwə rututu ə njuw ta’a. ");
INSERT INTO gqr_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ngonn el baw’ne ene: “Bai m’ra majel m’ɔsɨ’n ta Luwə num m’ɔs’i inɓe ta num tɔ, m’asɨ ta kadɨ ɓarɨ’m ngonn’i el.” ");
INSERT INTO gqr_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Nan baw’a el nje ra kulə’gɨ ene: “In rei kɨ ku kɨ majɨ utə ndəgə’gɨ kalangɨ uləi rɔ ngonn’m’tɨ. Uləi ningə ngonn ji’ə’tɨ ə uləi sa nja’a’tɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Rei kɨ ngonn mangɨ kibo mbul mbul tɔli’ə adɨ j’usɔi jɨ rai rɔnel. ");
INSERT INTO gqr_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Tadɔ ngonn’m kin oy ə təl isɨ kɨ dɔ’ne taa. Nanyi ə in kɨ kingə!” Ningə uləi ngirə kadɨ rai rɔnel. ");
INSERT INTO gqr_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Dɔkagilo’ə’tɨ kin, ngonnkon’a kɨ ngatɔgɨ in mu. Lokɨ isɨ təl mu ə in ndəkba kɨ kəy ningə oo ndu nyakində’gɨ kɨ ndam’gɨ. ");
INSERT INTO gqr_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ɓar nje ra kulə kare, ə dəj’ə ene ke ri ə ra nya wa. ");
INSERT INTO gqr_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Nje ra kulə kakin el’ə ene: “Ngonnkon’i ə re ə baw’i adɨ tɔli ngonn mangɨ kibo mbul mbul tadɔ təl kɨ lapiya.” ");
INSERT INTO gqr_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ngonn kɨ ngatɔgɨ ra wongɨ adɨ mbətɨ kaw kəy. Baw’a te taga kadɨ sɔl me’ə ad’a ur kəy. ");
INSERT INTO gqr_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Nan el baw’ne ene: “Oo ɓal ngayn ə m’njɨ m’ra kulə mad’i, ndɔ kare kɨ m’mbətɨ təl rɔ’m go ta’tɨ lə’i goto. Nan ndɔ kare kɨ adɨ’m ngonn binyə be kaa m’ra’n rɔnel kɨ madɨ’m’gɨ goto. ");
INSERT INTO gqr_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Nan lokɨ ngonn’i kɨ tujɨ nyakingə lə’i dɔ kaya dene’gɨ’tɨ kin re ningə, tɔl ngonn mangɨ kibo mbul mbul ad’a.” ");
INSERT INTO gqr_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ningə baw’a el’ə ene: “In, ngonn’m, in sə’m ne nan’tɨ, adɨ nya’gɨ pətɨ kɨ in yan’m in yan’i. ");
INSERT INTO gqr_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Nan in low’ə’tɨ kadɨ jɨ ra nyakusɔ jɨ ra’n rɔnel, tadɔ ngonnkon’i kam oy ə təl isɨ kɨ dɔ’ne taa, nanyi ə in kɨ kingə!”» ");
INSERT INTO gqr_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Go’tɨ ningə Jeju el njendo’gɨ lə’ne ene: «Dingəm kare kɨ njenyakingə aw kɨ njekində kum’ne go nya’gɨ’tɨ kɨ me kəy’tɨ lə’ne non. De’gɨ rei eli’ə eyina: “Njengəm nya’gɨ lə’i isɨ tujɨ kɨ nyakingə lə’i tigə.” ");
INSERT INTO gqr_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Nje kəy ɓar nje ra kulə lə’ne el’ə ene: “Ta ri ə m’njɨ m’oo dɔ’i’tɨ am wa? Ɔjɨ’m go nya’gɨ kɨ ɔjidɔ kulə lə’i kɨ me kəy’tɨ adɨ’m m’oo. Tadɔ lo kadɨ m’a mad’i ində kum’i go nya’gɨ’tɨ lə’m kɨ me kəy’tɨ goto nga!” ");
INSERT INTO gqr_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Njengəm nya el rɔ’ne ene: “Ɓe’m ge kadɨ m’ində kum go nyakingə’gɨ’tɨ kɨ me kəy’tɨ el nga kam, m’a m’ra ri nga am wa? Ndɔɔ dɔnangɨ ə, tɔgɨ’m asɨ el. Kaw kɔy nya ə rɔ’m a sɔl’m. ");
INSERT INTO gqr_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","M’gər nya kɨ m’a m’ra kadɨ de’gɨ a uwəi m’in kɨ rɔ’de’tɨ me kəy’tɨ lə’de lokɨ ɓe’m adɨ m’ində kum’m go nya’tɨ el.” ");
INSERT INTO gqr_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Be ə, ɓe nje ɓangɨ ulə ɓər’gɨ lə’ne kare kare. El nje ɓangɨ kɨ dɔkete ene: “Ɓangɨ lə ɓe’m in bann dɔ’i’tɨ wa?” ");
INSERT INTO gqr_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Nje ɓangɨ kɨ dɔkete kakin ene: “Ku hu ɓu kare.” Ningə el’ə ene: “Ta makitu ɓangɨ lə’i ə isɨ nanga kalangɨ, ndangɨ me’tɨ dɔ mi.” ");
INSERT INTO gqr_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Go’tɨ ningə el kɨ nungɨ ene: “In yan’i in bann wa?” Nje ɓangɨ kɨ nja joo el’ə ene: “Madɨ’m in sakɨ geme ɓu kare.” Ningə el’ə ene: “Un makitu ɓangɨ lə’i ə ndangɨ me’tɨ dɔjijoo.” ");
INSERT INTO gqr_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ɓe njengəm nya kɨ ngom ulə tɔjɨ dɔ’a’tɨ tadɔ ra nya kɨ kumkədɨ. De’gɨ kɨ gəri Luwə el rai nya kɨ kumkədɨ ngayn me kulə ra’de’tɨ dann’de’tɨ utə ngann’gɨ lə kunjɨ.» ");
INSERT INTO gqr_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ningə adɨ m’el’se: «Rai madɨ nan kɨ de’gɨ kɨ nyakingə kɨ ngom kin, kadɨ ndɔ kɨ goto ji’se’tɨ ningə, uwəi’se rɔ’de’tɨ lo kisɨ kɨ bitɨ kɨ non’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","De kɨ ra kɨ asɨ ta kadɨ de uwə kul’ə dɔ nya kɨ nden’tɨ, a asɨ kadɨ de uwə kul’ə dɔ nya kɨ boi’tɨ tɔ. De kɨ njera nya kɨ dana el me nya kɨ nden’tɨ, a ra nya kɨ dana el me nya kɨ boi’tɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","In be ə, re de asɨ ra nya kɨ low’ə’tɨ el tadɔ Mamon lə nyara kɨ dana el, eke nan a adi nyakingə kɨ rɔta’tɨ wa? ");
INSERT INTO gqr_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Re de ra nya kɨ low’ə’tɨ el dɔ nya’tɨ lə de kɨ rangɨ, eke nan a adi yan’i kɨ sɔw dɔ’i inɓe? ");
INSERT INTO gqr_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Nje ra kulə madɨ, kɨ a asɨ ra kuləɓər lə ngar’gɨ joo goto: re ɔsɨ ta kɨ kare ə, a ndigɨ kɨ nungɨ, re kidɨ kɨ kare ə, a uwə kɨ kɨ nungɨ tɔ. A asi kadɨ rai ɓər lə Luwə num ɓər lə nar num el. ");
INSERT INTO gqr_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Parisɨ’gɨ kɨ njendigɨ ta lə nar, uwəi Jeju kogi lokɨ oyi ta’gɨ kin pətɨ. ");
INSERT INTO gqr_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ningə Jeju el’de ene: «Rai rɔ’se to de’gɨ kɨ njera nya kɨ dana be takum de’gɨ’tɨ. Nan Luwə gər me’se. Tadɔ nya kɨ de’gɨ ɔsikurə ngayn takum’de’tɨ kin in nya kɔw takum Luwə’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","«Bitɨ dɔkagilo’tɨ lə Jan Batisɨ, in dɔkagilo lə ndukun lə Mojɨ kɨ de’gɨ kɨ njekeltakita Luwə’tɨ. De’gɨ iləi mbər Konɓe lə Luwə to Poyta kɨ majɨ. De kɨ ra’a, ra kɨ tɔgɨ’ne tadɔ kandɨ me’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","On el kadɨ dɔran in kɨ dɔnangɨ a dəri kɔ utə kadɨ de ɔr ngonn kur ta kɨ me ndukun’tɨ lə Luwə kɔ. ");
INSERT INTO gqr_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Dingəm kɨ ra kɨ tuwə ne’ne ə ta in kɨ rangɨ, in njekuwə marum. Taa de kɨ nje taa dene kɨ ngaw’a tuwə kaa in njekuwə marum tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","«Dingəm kare kɨ njenyakingə kɨ njekulə ku kɨ ndole kas yɔl kɨ gat’a in ngayn in non. Ndɔ’gɨ kare kare pətɨ, isɨ ra rɔnel tadɔ isɨ majɨ. ");
INSERT INTO gqr_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Njendoo kare kɨ tɔ’a nan Lajar kɨ dobay ta rɔ’a, re to ta kəy’tɨ li’ə. ");
INSERT INTO gqr_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ndigɨ kadɨ n’usɔ bunə nyakusɔ’gɨ kɨ tosi nanga ta tabilə’tɨ lə njemajɨ. Nan busɨ’gɨ kaa rei tonni ta dobay li’ə. ");
INSERT INTO gqr_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ndɔ kare njendoo kakin oy, adɨ malayka’gɨ rei uni’ə awi si’ə kadɨ Abiraham’tɨ. Njemajɨ kaa re oy tɔ, adɨ duwi’ə. ");
INSERT INTO gqr_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Njemajɨ ingə kon me lo kɨ koo’tɨ ngayn, un kum’ne taa ningə oo Abiraham sanyi nu kɨ Lajar kad’a’tɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Njemajɨ kakin un ndu’ne kɨ taa ningə non ene: “Bai Abiraham, oo kumtondoo lə’m! Ulə Lajar adɨ ulə ta ngonn ji’ne mann’tɨ, kadɨ re’n sɔlɨ’n ndonn’m tadɔ m’ingə kon ngayn me por’tɨ kin.” ");
INSERT INTO gqr_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Abiraham el’ə ene: “Ngonn’m, adɨ me’i olo dɔ’tɨ tokɨ ndɔkɨ ingə majɨ me dɔnangɨ’tɨ, ə Lajar ingə nya kɨ to to. Ngɔsine, bɔri mann non kum’ə’tɨ, nan in, in me nya kɨ to’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ningə kibo utə, ngɔsine bolo ɓe kibo to dann’je’tɨ sese, adɨ re jɨ ge kaa, lo kadɨ j’a dər səm’tɨ j’aw rɔ’se’tɨ goto. Taa, ingɨ kaa, a asi kadɨ dəri rei rɔ’je’tɨ el tɔ.” ");
INSERT INTO gqr_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Njemajɨ el ene: “Re in be ningə, nja’i ba, bai, ulə Lajar ad’a aw me kəy’tɨ lə bai. ");
INSERT INTO gqr_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Tadɔ ndəgɨ ngannkon’m’gɨ nanyi non in mi ɓay, ə kadɨ aw ndɔr mbi’de kadɨ rei, tei lo kon’tɨ kin el nga.” ");
INSERT INTO gqr_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abiraham el’ə ene: “Ngannkon’i’gɨ rai kɨ ndukun kɨ Mojɨ ndangɨ kɨ ta’gɨ kɨ njekeltakita Luwə’tɨ ndangi non. Majɨ kadɨ oyi dɔ ndu’de!” ");
INSERT INTO gqr_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Nje majɨ ene: “In kin asɨ el bai Abiraham. Nan re, de madɨ in dann nje koy’gɨ’tɨ ne ə aw ingə’de ə a inyəi gorow njiyə’de kɨ majel kɔ.” ");
INSERT INTO gqr_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Nan Abiraham təl el’ə ene: “Re oyi ta lə Mojɨ el num, ta lə njekeltakita Luwə’tɨ el num ə, kin ə de in dann njekoy’gɨ’tɨ ə aw rɔ’de’tɨ kaa, a oyi ta li’ə to ta kɨ rɔta’tɨ el ɓay!”» ");
INSERT INTO gqr_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jeju el njendo’gɨ lə’ne ene: «Lo kadɨ de’gɨ a osi me majel’tɨ el goto. Kumtondoo in dɔ de’tɨ kɨ majel re kɨ takul’ə. ");
INSERT INTO gqr_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","A in sotɨ ngayn ɓay tadɔ li’ə kadɨ dɔ’i mbal kusɨ ko mində’tɨ, ə iləi’ə me ba’tɨ, utə kadɨ ra adɨ kɨ kare dann ngann’gɨ’tɨ kɨ du kin osi.» ");
INSERT INTO gqr_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Indəi kumkədɨ dɔ rɔ’se’tɨ! Re ngonnkon’i ra majel ə, majɨ kadɨ ndang’a dɔ’tɨ, re inyə kuləra’ne ə, inyə go majel li’ə kɔ ad’a. ");
INSERT INTO gqr_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Re ra majel sə’i nja siri me ndɔ’tɨ kɨ kare kaa, re rɔ’i’tɨ nja siri dəji k’inyə go kɔ ə, inyə go kɔ ad’a. ");
INSERT INTO gqr_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","*Njekawkulə’gɨ eli Burəɓe eyina: «Ilə kunme dɔ mad’a’tɨ lə’je adi’je.» ");
INSERT INTO gqr_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ə Burəɓe el’de ene: «Tokɨ rɔta’tɨ, re awi kɨ kunme kɨ in ndikiri ba to kandɨ kagɨ, kɨ ɓari’ə mutardə kin be mindɨ kaa, asi kadɨ eli kagɨ mbaykote kam eyina: Ɔr kɨ ngirə’i ba ə aw man rɔ’i me ba’tɨ» ə a təl rɔ’ne go ta’tɨ lə’se. ");
INSERT INTO gqr_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","«Re de madɨ dann’se’tɨ aw kɨ nje ra kulə madɨ kɨ in nje ndɔɔ eke in njengəm batɨ’gɨ. Lokɨ təl mu re ningə, ke a el’ə ene: “Re kalangɨ isɨ nanga, sɔ nya wa?” ");
INSERT INTO gqr_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Jagɨ, a el’ə ene: “Ra go nyakusɔ lə’m kɨ kad’a. Ningə mbəl ku kɨ rɔ’i’tɨ, ə re adɨ’m nyakusɔ. Lokɨ m’njɔ nya num, manyi nya num ningə, sɔ yan’i num, anyi yan’i num tɔ.” ");
INSERT INTO gqr_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","A ra oyo njekulə lə’ne tadɔ təl rɔ’ne go ndu’gɨ’tɨ lə ɓe’ne? Jagɨ a in be el! ");
INSERT INTO gqr_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ta lə’se kaa to be tɔ. Lokɨ rai nya’gɨ pətɨ kɨ Luwə un ndu’ne kadɨ rai ningə majɨ kadɨ eli eyina: “J’in nje ra kulə’gɨ kɨ nda’je goto, jɨ ra kulə kɨ majɨ kadɨ jɨ ra.”» ");
INSERT INTO gqr_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Dɔ row kaw’a Jerujalem’tɨ, Jeju dər mbunə ɓebo Samari kɨ Galile’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Lokɨ isɨ ur me ngonn ɓe’tɨ to kur ɓay ə, njebanjɨ’gɨ dɔgɨ iləi ta’a. Adi ndan’de ngal si’ə jɔ, ə rai lokatɨ. ");
INSERT INTO gqr_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Uləi ngirə kadɨ nonyi dɔ’a’tɨ kɨ ndu’de kibo eyina: «Jeju, njendo, oo kumtondoo lə’je!» ");
INSERT INTO gqr_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Lokɨ oo’de ningə el’de ene: «Ai ɔji rɔ’se njekujənyamosɨ kadikare’gɨ!» Dɔ row kaw de’tɨ ne ɓay par ə, ingəi rɔ’de ar njay. ");
INSERT INTO gqr_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Kɨ kare dann’de’tɨ lokɨ oo kadɨ ingə lapiya nga ningə, təl dɔ nja’ne’tɨ, kɨ kulə tɔjɨ dɔ Luwə’tɨ, kɨ ndu’ne kibo. ");
INSERT INTO gqr_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Osɨ nja Jeju’tɨ, ɔsi natɨ non’ne nanga, ra’a oyo. Dingəm kakin in de kɨ Samari’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jeju el ene: «Njebanjɨ’gɨ kɨ dɔgɨ pətɨ kɨ rɔ’de ar njay, eke nje kɨ jikara awi ra wa?» ");
INSERT INTO gqr_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Mbunə’de’tɨ pətɨ, de kare kɨ təl re ulə tɔjɨ dɔ Luwə’tɨ goto, nan de kɨ in Juwipɨ el kin kɨ kar’ne ba par! ");
INSERT INTO gqr_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ningə Jeju el de kɨ Samari’tɨ kakin ene: «Ində taa aw, tadɔ kunme lə’i aj’i.» ");
INSERT INTO gqr_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ndɔ kare Parisɨ’gɨ dəji Jeju ta kɨ ɔjidɔ dɔkagilo re Konɓe lə Luwə. Jeju el’de ene: «Konɓe lə Luwə a re to nya kɨ de’gɨ a oyi’ə kɨ kum’de jaja el. ");
INSERT INTO gqr_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","A in kɨ k’el k’ene: “Oyi in yo ɓo”, eke: “In ne ɓo el.” Tokɨ rɔta’tɨ Konɓe lə Luwə in dann’se’tɨ nga.» ");
INSERT INTO gqr_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Go’tɨ ningə el njendo’gɨ ene: «Ndɔ madɨ a re non kɨ a ndingəi ngayn kadɨ oyi ndɔ kare me ndɔ’gɨ’tɨ lə Ngonn De, nan lo kadɨ a oyi goto. ");
INSERT INTO gqr_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ningə a eli’se eyina: “Kirisitɨ in ne”, eke “Kirisitɨ in nu!” kadɨ ai! Ononyi’se kadɨ anyinan ngodɨ kɨ low’ə’tɨ! ");
INSERT INTO gqr_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ningə, tokɨ ndi təl ə lo ar njay njay in dow dɔran’tɨ kɨ kare te’n dowə’tɨ kɨ nungɨ kakin ə, ndɔ re’m m’in Ngonn de kaa a to be tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Nan kete non təl’ə’tɨ, majɨ kadɨ Ngonn De ingə kon ngayn, kadɨ de’gɨ kɨ dɔkagilo’tɨ kɨ ɓone kin mbəti m’in ɓay taa. ");
INSERT INTO gqr_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ningə, ko nya’a kɨ ra nya dɔkagilo’tɨ lə Nuwe kin ə, be tɔ’a a ra’n nya ndɔ re’m’tɨ m’in Ngonn de tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","De’gɨ sɔi nya ge, anyinan nya ge, taai nan ge, adi ngann de’gɨ taai ngaw ge, bitɨ ndɔ’tɨ kɨ Nuwe ur’n me tokibo’tɨ. Go’tɨ ningə mann kon kibo re tujɨ de’gɨ pətɨ. ");
INSERT INTO gqr_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","A to to nya kɨ ra nya dɔkagilo’tɨ lə Lotɨ be tɔ: De’gɨ sɔi nya num, anyinan nya num, ndogi nya’gɨ num, lawi nya’gɨ num, manyi kagɨ’gɨ num ə rai kəy’gɨ num tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Nan ndɔ kɨ Lotɨ te’n me ɓebo’tɨ kɨ Sɔdɔm, Luwə adɨ ndi por kɨ babur kɨ in dɔran’tɨ on de’gɨ tɔl’de pətɨ. ");
INSERT INTO gqr_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ndɔ kɨ m’in Ngonn de m’a te’n bus kaa, be tɔ’a nya’gɨ a rai nya tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Me ndɔ’a’tɨ kin de kɨ in dɔ kəy’tɨ ə, a ur nanga tadɔ kɔy nya’gɨ lə’ne kɨ me kəy’tɨ te’n taga el. Be tɔ ə, de kɨ ra me ndɔɔ’tɨ kaa a təl re ɓe el tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Adɨ me’se olo dɔ nya’tɨ kɨ te dɔ ne Lotɨ’tɨ, kɨ ilə rətɨ ə ingə koy kin. ");
INSERT INTO gqr_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","De kɨ sangɨ kadɨ n’ajɨ rɔ’ne kɨ non’tɨ, a ilə rɔ’ne kɔ. Nan de kɨ ilə rɔ’ne kɔ tadɔ lə’m ə, a ngəm rɔ’ne kɨ non’tɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Adɨ m’el’se, me kondɔ’a’tɨ kin, de’gɨ joo toi dɔ tirə’tɨ kɨ kareba ningə, a uni kɨ kare, a inyəi kɨ nungɨ. ");
INSERT INTO gqr_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Dene’gɨ joo, a uri nya nan’tɨ, a uni kɨ kare ə, a inyəi kɨ nungɨ. ");
INSERT INTO gqr_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Dingəm’gɨ joo, a rai kulə me ndɔɔ’tɨ kɨ kare ə, a uni kɨ kare ə a inyəi kɨ nungɨ.» ");
INSERT INTO gqr_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ningə, njendo’gɨ dəji’ə eyina: «Burəɓe, lo kɨ ra’tɨ ə, nya’gɨ kin a rai nya’tɨ wa?» El’de ene: «Lo kɨ ninn to’tɨ ə, mal’gɨ a kawinan səm’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jeju el kujita njendo’gɨ lə’ne kadɨ ndo’n’de, kadɨ elita kɨ Luwə ta ta, um kadɨ wongɨ ra’de go’tɨ el. ");
INSERT INTO gqr_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","El ene: «Njegangɨ ta kare isɨ ɓebo’tɨ madɨ non. Njegangɨ ta kakin ɓol Luwə el num, ta ilə kojɨ dɔ de’tɨ el num tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Me ɓebo’tɨ kakin ə, dene kare kɨ njengawkoy sɨ’tɨ non tɔ. Dene kakin re kɨ dɔkagilo’gɨ pətɨ el’ə ene: “Gangɨ ta lə’m kɨ to mbunə’m’tɨ kɨ nje ta lə’m kin adɨ’m.” ");
INSERT INTO gqr_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Njegangɨ ta kakin mbətɨ Dɔkagilo ngayn. Nan təl elta rɔ’ne ene: “Re m’ɓol Luwə el num, ta m’ilə kojɨ dɔ’de madɨ’tɨ kare el kaa, ");
INSERT INTO gqr_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","dene kɨ njengawkoy kam njuwə’m ngayn. Majɨ kadɨ m’gangɨ ta li’ə mad’a, kadɨ təl re gogɨ ndɔ kɨ rangɨ’tɨ, to dɔ’m ɓay el nga.”» ");
INSERT INTO gqr_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Burəɓe el dɔ’tɨ ene: «Majɨ kadɨ oyi dɔ ta kɨ njegangɨ ta kɨ gorow’ə’tɨ el kin majɨ. ");
INSERT INTO gqr_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ke oyi kadɨ Luwə a gangɨ ta kɨ dana adɨ nje kɨ mbəti’de, kɨ sii nonyi dɔ’a’tɨ kada ge kondɔ ge kin el wa? A isɨ gərərə ba dɔ ra se’de’tɨ wa? ");
INSERT INTO gqr_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Adɨ m’el’se, a gangɨ ta lə’de kalangɨ ba. Nan ndɔ kɨ Ngonn De a re, ke a ingə kunme dɔnangɨ’tɨ ɓay wa?» ");
INSERT INTO gqr_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jeju el kujita kɨ dɔ nje’gɨ kɨ oyi rɔ’de to de’gɨ kɨ dana ə kidi ndəgɨ de’gɨ. ");
INSERT INTO gqr_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Ene: «Dingəm’gɨ joo, rai Kəy’tɨ lə Luwə tadɔ kelta kɨ Luwə; kɨ kare in Parisɨ, kɨ nungɨ in njetalambo tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Parisɨ in ra ta ə elta kɨ ɔjidɔ rɔ’ne me’ne’tɨ ene: “Luwə lə’m, m’ra’i oyo tadɔ m’in to to ndəgɨ de’gɨ kɨ nje ɓogɨ’gɨ eke njera nya’gɨ kɨ dana el, kɨ njekuwə marum, taa to njetalambo kam el. ");
INSERT INTO gqr_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Me ndɔ’tɨ kɨ siri, m’ɔgɨ rɔ’m nyakusɔ nja joo. Madɨ Luwə kɨ kare me kɨ dɔgɨ’tɨ, me nyakingə’gɨ’tɨ lə’m pətɨ tigə.” ");
INSERT INTO gqr_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Nan njetalambo ɔsɨ rɔ’ne ngərəngɨ nu, kun kaa ge kun kum’ne kɨ dɔran’tɨ el. Ningə ində kadɨ’ne ray ray ə, el ene: “Luwə lə’m oo kumtondoo lə’m tadɔ m’in njeramajel!” ");
INSERT INTO gqr_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Adɨ m’el’se, in njetalambo ə təl aw ɓe lə’ne ningə Luwə tudə de’tɨ kɨ dana, um Parisɨ el. Tadɔ de kɨ un dɔ’ne ta, ə a uləi dɔ’a nanga; nan de kɨ sɔl dɔ’ne ə, a uni dɔ’a ta tɔ.» ");
INSERT INTO gqr_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ngann’gɨ kɨ kasɨ inɓe kin kaa de’gɨ rei se’de rɔ Jeju’tɨ kadɨ njangidɔ’de. Nan lokɨ njendo’gɨ oyi nya kin ningə, ndangi’de. ");
INSERT INTO gqr_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Nan Jeju adɨ rei kɨ ngann’gɨ kɨ du rɔ’a’tɨ ningə el ene: «Inyəi ngann’gɨ kɨ du adɨ rei rɔ’m’tɨ, ononyi’se kadɨ ɔgi’de tarow, tadɔ Konɓe lə Luwə in nya de’gɨ kɨ toi to ngann’gɨ kɨ du be. ");
INSERT INTO gqr_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Tokɨ rɔta’tɨ adɨ m’el’se, de kɨ taa Konɓe lə Luwə to ngonn kɨ du be el ə, a ur me’tɨ el ratata.» ");
INSERT INTO gqr_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Kibo lə Juwipɨ’gɨ kare, dəjɨ Jeju ene: «Njendo kɨ nje hal kɨ majɨ, in ri ə m’a m’ra ə m’a m’ingə’n kajɨ kɨ to bitɨ kɨ non’tɨ wa?» ");
INSERT INTO gqr_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jeju el’ə ene: «Tadɔ ri ə ɓarɨ’m de kɨ majɨ wa? De kare kɨ majɨ goto, nan Luwə kɨ kar’ne ba par ə in de kɨ majɨ. ");
INSERT INTO gqr_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","In gər mbərkikində’gɨ lə Luwə kɨ ene: “A uwə marum el, a tɔl de el, a ɓogɨ el, a mannajɨ kɨ ngom dɔ mad’i’tɨ el, a ɔsikurə baw’i kɨ kon’i.”» ");
INSERT INTO gqr_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ningə dingəm təl el Jeju ene: «Nya’gɨ kin pətɨ m’təl rɔ’m go’tɨ dɔkagilo kulə ngirə basa’m’tɨ nu bitɨ ɓone.» ");
INSERT INTO gqr_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Go ta’gɨ’tɨ kin Jeju el’ə ene: «Nya kare be ə nanyi kadɨ in ra ɓay: Aw adɨ ndogi sə’i nyakingə’gɨ lə’i pətɨ tigə, ə lowə nar’a njendoo’gɨ, ə a aw kɨ nyakingə’gɨ ngayn me dɔran’tɨ, ə un go’m!» ");
INSERT INTO gqr_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Nan lokɨ dingəm oo ta kin, kum’ə diw kururu, tadɔ in de kɨ nyakingə li’ə in ngayn. ");
INSERT INTO gqr_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Lokɨ Jeju oo’ə, un kum’ne oo’n’ə ningə el ene: «In nya kɨ ngan ngayn kɨ rɔ njenyakingə’gɨ kadɨ uri me Konɓe lə Luwə. ");
INSERT INTO gqr_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","In nya kɨ ngan ngayn inɓe kadɨ jambal ur bolo konn kur nya’tɨ, nan a ngan ngayn utə in kin ɓay kadɨ njenyakingə ur Konɓe lə Luwə.» ");
INSERT INTO gqr_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Nje kɨ si oyi dɔ ta lə Jeju eli eyina: «Nga kin ə in be ningə, nan ə asɨ kadɨ ingə kajɨ wa?» ");
INSERT INTO gqr_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jeju ilə’de’tɨ ene: «Nya kɨ de asɨ ra el, Luwə asɨ kadɨ ra.» ");
INSERT INTO gqr_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Piyər el’ə ene: «Nga j’in, kɨ j’inyə nyakingə’gɨ lə’je pətɨ ə j’un go’i.» ");
INSERT INTO gqr_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jeju el’de ene: «Tokɨ rɔta’tɨ adɨ m’el’se, re tadɔ Konɓe lə Luwə, de madɨ, inyə kəy lə’ne, ne’ne, kɨ ngannkon’ne’gɨ, kɨ baw’ne kon’ne, kɨ ngann’ne’gɨ, ");
INSERT INTO gqr_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ə, a ingə dɔ’tɨ ngayn utə kɨ kete ɓay, dɔkagilo’tɨ kɨ ɓone, taa dɔkagilo’tɨ kɨ a re, a ingə kajɨ kɨ a to bitɨ kɨ non’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jeju ɓar njendo’gɨ lə’ne kɨ dɔgɨ gidə in joo kɨ rɔ’ne’tɨ, ningə el’de ene: «Oyi, j’isi j’awi kɨ Jerujalem’tɨ, nya’gɨ pətɨ kɨ de’gɨ kɨ njekeltakita Luwə’tɨ, ndangi ɔjidɔ’m m’in Ngonn de, a tɔlita’de. ");
INSERT INTO gqr_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Tadɔ, a uləi m’in ji de’gɨ’tɨ kɨ in Juwipɨ’gɨ el, kadɨ to kogi dɔ’m’tɨ ge, a taji m’in ge, taa a tuwi mann ta’de dɔ’m’tɨ num tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Go’tɨ, lokɨ indəi’ə kɨ ndəy ningə, a tɔli’ə. Ndɔ mutə tum ginn’ə ndɔ koy’o’tɨ a te lo koy’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Nan nya kare kɨ njendo’gɨ gəri me ta’tɨ kin goto. In ta kɨ to lo kiyərɔ’tɨ rɔ’de’tɨ. Gəri me ta kɨ Jeju ge kel’de el. ");
INSERT INTO gqr_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Lokɨ Jeju in ndəkba kɨ ɓebo Jeriko ningə, njekumtɔ madɨ isɨ ngangɨ row’tɨ non, isɨ kɔy nya. ");
INSERT INTO gqr_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Lokɨ njekumtɔ oo kah bulə de’gɨ kɨ isɨ indəi dəri bur bur ningə, dəjɨ ta ke ri ə ra nya wa. ");
INSERT INTO gqr_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Eli’ə eyina: «Jeju kɨ Najaretɨ ə isɨ ində dər.» ");
INSERT INTO gqr_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Njekumtɔ ulə ngirə kadɨ un ndu’ne kɨ ta, ə non kɨ tɔgɨ’ne, ene: «Jeju kɨ Ngonnkaw Dabidɨ, oo kumtondoo lə’m!» ");
INSERT INTO gqr_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","De’gɨ kɨ nje njiyə kete non de’gɨ’tɨ ndangi’ə kadɨ utɨ ta’ne, nan kadibe ɓay ə njekumtɔ un ndu’ne kɨ taa dɔ mad’a’tɨ ene: «Ngonnkaw Dabidɨ, oo kumtondoo lə’m!» ");
INSERT INTO gqr_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jeju ra lokatɨ ə un ndu’ne kadɨ rei si’ə rɔ’ne’tɨ. Lokɨ re rɔ’a’tɨ ndəkba ningə, Jeju dəj’ə ene: ");
INSERT INTO gqr_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«In ri ə ge kadɨ m’ra mad’i wa?» Njekumtɔ el’ə ene: «Burəɓe, m’ge kadɨ kum oo lo!» ");
INSERT INTO gqr_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jeju el’ə ene: «Oo lo! Kunme lə’i aj’i nga.» ");
INSERT INTO gqr_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Par ə, low’ə’tɨ non kum’ə oo lo adɨ un go Jeju kɨ kulə tɔjɨ dɔ Luwə’tɨ ta’ne’tɨ. Lokɨ bulə de’gɨ oyi nya kin ningə, uləi ngirə kɔsikurə Luwə. ");
INSERT INTO gqr_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Lokɨ Jeju ur me ɓe’tɨ kɨ Jeriko ə isɨ ində dər ningə, ");
INSERT INTO gqr_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","dingəm kɨ njenyakingə kare kɨ tɔ’a nan Jaka, kɨ in kɨ boi lə njetalambo’gɨ isɨ non. ");
INSERT INTO gqr_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Dingəm kin sangɨ kadɨ n’oo ke Jeju in nan dana wa, nan lo kadɨ oo Jeju goto, tadɔ bulə de’gɨ, taa in de kɨ gɔjɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Be ə, anyi ngodɨ kete, aw ala dɔ kagɨ mbaykote’tɨ, kadɨ n’oo Jeju kɨ a dər kɨ row kɨ low’ə’tɨ kin. ");
INSERT INTO gqr_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Lokɨ Jeju re te low’ə’tɨ kakin ningə, un kum’ne kɨ taa, el Jaka ene: «Jaka, ur nanga ne kalangɨ, tadɔ m’in m’a m’njɨ me kəy’tɨ lə’i ɓone.» ");
INSERT INTO gqr_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Lo kin’tɨ, Jaka ur nanga kalangɨ, uwə Jeju rɔ’ne’tɨ kɨ rɔnel. ");
INSERT INTO gqr_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","De’gɨ pətɨ kɨ oyi nya kin, ɓarita dɔ Jeju’tɨ eli eyina: «Aw isɨ ɓe lə njeramajel.» ");
INSERT INTO gqr_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Nan Jaka ra taa, el Burəɓe ene: «Burəɓe, m’a m’adɨ nusɨ nyakingə lə’m njendoo’gɨ. A kin ə re m’taa nya lə’de kɨ aldɔ majɨ ə, m’a m’təl m’ugə ɓang’a gogɨ nja sɔ.» ");
INSERT INTO gqr_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Lo kin’tɨ Jeju ene: «Ɓone Njekajɨ de’gɨ ur me kəy’tɨ lə’i, tadɔ in kaa in ngonn kaw Abiraham tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Tadɔ kɨ rɔta’tɨ, Ngonn de re kadɨ sangɨ de’gɨ kɨ nanyinan, ajɨ’de.» ");
INSERT INTO gqr_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Lokɨ de’gɨ uri mbi’de sii oyi ta kɨ Jeju isɨ el’de ba ɓay ningə, Jeju un kujita kare ta’ne’tɨ kadɨ el’de. Jeju in ndəkba kɨ Jerujalem adɨ de’gɨ oyi kadɨ konɓe lə Luwə a ɔdɨ rɔ’ne low’ə’tɨ non. ");
INSERT INTO gqr_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","El’de ene: «Dingəm kare kɨ oji’ə me majɨ’tɨ isɨ aw ɓe madɨ’tɨ kɨ sanyi kadɨ indəi jɔgɨ konɓe dɔ’a’tɨ ɓay taa to təl. ");
INSERT INTO gqr_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Be ə, kete ɓay taa kadɨ aw, ɓar njekulə’gɨ lə’ne dɔgɨ, adɨ de kɨ ra dann’de’tɨ mbal ɔr kare, ningə el’de ene: “Tai, təli ji’se bitɨ kadɨ m’təl m’re m’ingə’n’se.” ");
INSERT INTO gqr_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Nan de’gɨ kɨ me ɓe’tɨ li’ə mbəti go’ə’tɨ, in ginn’ə’tɨ kan, ə uləi de’gɨ go’ə’tɨ eli eyina: “Jɨ ndigɨ el kadɨ de kin re isɨ ngar dɔ’je’tɨ.” ");
INSERT INTO gqr_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Be kaa, indəi jɔgɨ ngar dɔ’a’tɨ. Be ə, lokɨ təl re ɓe ningə, ɓar nje ra kulə’gɨ lə’ne kɨ adɨ’de nar kakin kadɨ n’oo ke in ri ə rai wa. ");
INSERT INTO gqr_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","De kɨ dɔkete re, ningə el ene: “Ɓe’m, nar ɔr kɨ kare kɨ adɨ’m kaa, nyɨ m’ingə dɔgɨ dɔ’tɨ kin.” ");
INSERT INTO gqr_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ə ngar el ene: “Majɨ ngayn, in njekulə kɨ majɨ. Ningə tokɨ ra’n nya kɨ low’ə’tɨ me kində kum go nya’tɨ kɨ nden be, m’indəi nje konɓe dɔ ɓebo’gɨ’tɨ kɨ dɔgɨ.” ");
INSERT INTO gqr_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","De kɨ nja joo re, ningə el ene: “Ɓe’m, nar ɔr kɨ kare kɨ adɨ’m kaa, nyɨ m’ingə mi dɔ’tɨ kin.” ");
INSERT INTO gqr_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ə ngar el’ə ko ta inɓe kakin ene: “In isɨ to nje konɓe dɔ ɓebo’gɨ’tɨ mi.” ");
INSERT INTO gqr_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","In kɨ rangɨ re ningə el ene: “Ɓe’m, oo nar ɔr lə’i kɨ kare kɨ adɨ kaa nyɨ to kin, m’aw m’ngəm ta ku’tɨ dangɨ m’ad’a to. ");
INSERT INTO gqr_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Tadɔ m’ɓol’i, in de kɨ ngan ngayn: nya kɨ ində el kaa un num, nya kɨ duw el kaa ujə num.” ");
INSERT INTO gqr_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Lo kin’tɨ ngar el’ə ene: “In njekulə kɨ majel. Ningə m’a m’gangɨ ta dɔ’i’tɨ kɨ ta kɨ te ta’i’tɨ inɓe. In gər majɨ kadɨ m’in de kɨ ngan ngayn: nya kɨ m’ində el kaa m’un num, nya kɨ m’duw el kaa m’ujə num. ");
INSERT INTO gqr_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Nga ra bann be ə re a ində nar lə’m lo ngəm nar’tɨ el wa? Re ində lo ngəm nar’tɨ ə, m’təl m’re kin ə m’a m’ingə mann’a dɔ’tɨ.” ");
INSERT INTO gqr_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Go’tɨ ngar el de’gɨ kɨ rai low’ə’tɨ non ene: “Tai nar ɔr kɨ kare kɨ ji’ə’tɨ kin adi in kɨ awɨ’n dɔgɨ kin.” ");
INSERT INTO gqr_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ə de’gɨ eli ngar eyina: “In kam aw kɨ nar ɔr dɔgɨ nga.” ");
INSERT INTO gqr_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Nan ngar el’de ene: “M’el’se tokɨ, de kɨ aw kɨ nya, a adi’ə dɔ’tɨ, nan de kɨ awɨ’n el, in kɨ nden inɓe kɨ awɨ’n kin kaa a tai ji’ə’tɨ ɓay. ");
INSERT INTO gqr_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ningə njeban’gɨ lə’m, kɨ mbeti kadɨ m’in ngar dɔ’de’tɨ, rei se’de, tɔli’de takum’tɨ ne.”» ");
INSERT INTO gqr_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Go ta’gɨ’tɨ kin, Jeju gangɨ kete non bulə de’gɨ, un row kɨ kaw kɨ Jerujalem. ");
INSERT INTO gqr_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Lokɨ Jeju re te ndəkba kɨ ɓe kɨ Betipaje in kɨ ɓe kɨ Betani, kɨ kaw kɨ kadɨ mbal’gɨ’tɨ kɨ ɓari’de mbal kagɨ Buni’gɨ kin ningə, ulə njendo’gɨ joo. ");
INSERT INTO gqr_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","El’de ene: «Awi me ngonn ɓe’tɨ kɨ ra non’se’tɨ kam. Lokɨ a uri kɨ me ɓe’tɨ, a ingəi ngonn koro kɨ dɔ’i’ə adɨ ra. In ngonn koro kɨ de ala gidə’tɨ nja kare el ɓay. Tuti’ə, in rei si’ə adi’m’in. ");
INSERT INTO gqr_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ə re de madɨ dəjɨ’se ene: “Tadɔ ri ə isɨ tuti ngonn koro kin wa?” Ə a eli’ə eyina: Tadɔ “Burəɓe ə ge’ə.”» ");
INSERT INTO gqr_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Nje kɨ Jeju ulə’de kakin awi ningə nyɨ, ingəi nya’gɨ inɓe tokɨ Jeju el’n’de. ");
INSERT INTO gqr_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Be ə, tuti ngonn koro kakin ningə, ɓe nje koro’gɨ dəji’de eyina: «Tadɔ ri ə tuti ngonn koro kin wa?» ");
INSERT INTO gqr_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ningə njendo’gɨ iləi’de’tɨ eyina: «Burəɓe ə ge’de.» ");
INSERT INTO gqr_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Lokɨ rei kɨ ngonn koro kakin adi Jeju ningə, lɔwi ku’gɨ lə’de gidə’tɨ ə adi Jeju ala isɨ dɔ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Kɔtɨ inɓe kɨ isɨ ɔti aw kete kete kin ningə, de’gɨ mbalayi ku’gɨ lə’de dɔ row njiyə’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Lokɨ Jeju isɨ re ndəkba kɨ Jerujalem’tɨ kɨ row kɨ in kɨ dɔ mbal kagɨ Buni’gɨ’tɨ kin ningə, bulə njendo’gɨ li’ə pətɨ, rɔ’de nəl’de ngayn adɨ uni ndu’de kɨ taa, piti Luwə tadɔ nyakɔjɨ’gɨ pətɨ kɨ ra adɨ oyi kɨ kum’de. ");
INSERT INTO gqr_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Piti Luwə eyina: «Kadɨ Luwə njangɨ dɔ ngar kɨ re me tɔ Burəɓe’tɨ! Kadɨ lapiya re kɨ dɔ dɔran’tɨ, ə tɔjɨ in kɨ dɔ Luwə’tɨ kɨ nje kisɨ dɔran’tɨ tɔ.» ");
INSERT INTO gqr_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Parisɨ’gɨ madɨ kɨ in dann bulə de’gɨ’tɨ eli Jeju eyina: «Burəɓe, ndangɨ njendo’gɨ lə’i adɨ uti ta’de.» ");
INSERT INTO gqr_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ə Jeju el’de ene: «M’el’se m’adɨ oyi, re ingɨ uti ta’de kaa, gajɨ mbal’gɨ a singəi səkitə.» ");
INSERT INTO gqr_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Lokɨ Jeju ində dɔ ɓe kɨ Jerujalem ndəkba ə un kum’ne oo’n’ə ningə mann non re kum’ə’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Mann non re kum’ə’tɨ adɨ el ene: «Kin ə re dɔkagilo’gɨ kɨ, ɓone kin, in kaa in gər row lapiya kin ə re a in sotɨ sə’i, nan kum’i te dɔ’tɨ el. ");
INSERT INTO gqr_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ndɔ’gɨ kɨ ngan a rei non kadɨ njeban’gɨ lə’i a uləi nan gugi dɔ’i, a iləi nan kɨ ta tɔ row’gɨ pətɨ, a uti nu nguy lo kadɨ a te goto. ");
INSERT INTO gqr_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","A budi’nu nanga mur mur kɨ de’gɨ lə’i. Mbal madɨ kɨ kadɨ de a inyə adɨ isɨ dɔ mad’a’tɨ goto. Tadɔ kum’i te dɔ dɔkagilo’tɨ kɨ Luwə re’n kadɨ ra’n sə’i kin el.» ");
INSERT INTO gqr_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Go’tɨ, Jeju aw ur natɨ Kəy’tɨ lə Luwə, ilə rɔ’ne tuwə njelaw nya’gɨ səm’tɨ kɔ. ");
INSERT INTO gqr_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ningə el’de ene: «Ndangi me makitu’tɨ lə Luwə eyina: “Kəy lə’m a in kəy kelta kɨ Luwə, nan ingɨ, təli’ə lokiyərɔ’tɨ lə njeɓogɨ’gɨ yo.”» ");
INSERT INTO gqr_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ndɔ’gɨ pətɨ, Jeju ndo de’gɨ nya me Kəy’tɨ lə Luwə. Lo kin’tɨ, kibo’gɨ lə njekujənyamosɨ kadikare’gɨ kɨ njendo ndukun’gɨ, kɨ njekundɔ de’gɨ me ɓe, sangi row kadɨ n’tɔli Jeju, ");
INSERT INTO gqr_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","nan gəri row’ə el, tadɔ bulə de’gɨ indəi mbi’de majɨ ngayn go ta’tɨ li’ə. ");
INSERT INTO gqr_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ndɔ kare, Jeju sii ndo de’gɨ nya me Kəy’tɨ lə Luwə, ilə’n mbər Poyta kɨ majɨ ningə, kibo’gɨ lə njekujənyamosɨ kadikare’gɨ kɨ njendo ndukun’gɨ kɨ ngatɔgɨ’gɨ, tei non rei. ");
INSERT INTO gqr_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Lokɨ rei ningə dəji’ə eyina: «El’je adɨ j’oo, in kɨ tɔgɨ kɨ in ra ə isɨ ra’n nya’gɨ kin be wa? Ə nan tɔ a adi ndu’ne ə isɨ ra’n wa?» ");
INSERT INTO gqr_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ə Jeju təl el’de ene: «M’in kaa m’a m’dəjɨ’se ta kare kadɨ eli m’in. ");
INSERT INTO gqr_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","In nan ə ulə Jan kadɨ ra de’gɨ batəm wa? In Luwə eke in de’gɨ?» ");
INSERT INTO gqr_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Nan təli mərita dann’de’tɨ eyina: «Re j’eli’ə j’ene: “In Luwə ə ulə” a dəjɨ’je ene ke ra bann ə j’un me’je j’ad’a el wa? ");
INSERT INTO gqr_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","A kin ə re j’eli j’ene: “In de’gɨ ə uləi Jan” ə, bulə de’gɨ ba pətɨ a tiləi’je kɨ mbal tɔli’je, tadɔ gəri majɨ ngayn kadɨ Jan in njekeltakita Luwə’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Be ə təli eli Jeju tokɨ n’gəri de kɨ ulə el. ");
INSERT INTO gqr_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ə Jeju ilə de’tɨ ene: «Re in be ə, m’in kaa m’a m’el’se tɔgɨ kɨ m’njɨ m’ra’n nya’gɨ kin el tɔ.» ");
INSERT INTO gqr_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Go’tɨ, Jeju ilə rɔ’ne elta bulə de’gɨ me kujita’tɨ kin ene: «Dingəm kare uwə ndɔɔ nju ningə; dɔ’i tanan’tɨ kɨ de’gɨ kɨ nje ra kulə nju kadɨ to rai kulə adi’ə, ə kagilo’ə’tɨ ə kanyi nan nya’a ningə, ɔtɨ aw mbah kɨ go’ə ngal. ");
INSERT INTO gqr_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Lokɨ kagilo kujə kandɨ nju asɨ ningə, ulə ɓər lə’ne kare kadɨ aw taa kandɨ nya ndɔɔ nju kakin, kɨ in yan’ne ji njerakulə’tɨ adɨ ne. Nan lokɨ ɓər aw ningə, nje ra kulə’gɨ, tindəi’ə ngayn, ə tuwəi’ə adɨ təl kɨ ji’ne kare aw. ");
INSERT INTO gqr_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Njendɔɔ təl ulə ɓər kɨ rangɨ ɓay. Nan in kaa, tindəi’ə ge taji’ə ge, ə tuwəi’ə adɨ təl kɨ ji’ne kare aw. ");
INSERT INTO gqr_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Be kaa dingəm kakin təl ulə ɓər kɨ nja mutə ɓay. Ningə in kɨ nja mutə kin, in kaa nje ra kulə’gɨ kakin tindəi’ə, adi’ə do, ə tuwəi’ə adi’ə aw. ");
INSERT INTO gqr_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Lo kin’tɨ, ɓe njendɔɔ dəjɨ ta rɔ’ne ene: “In ri ə kadɨ m’ra wa. M’a m’ulə kɨ ngonn’m kɨ dingəm kɨ njendigɨ lə’m ngayn kin. Dɔmajɨ, a ɓoli gid’ə.” ");
INSERT INTO gqr_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Nan nje ra kulə nju lokɨ kum’de osɨ dɔ ngonn’on’tɨ ningə, elinan ta kin dann’de’tɨ eyina: “Darɔ’a inɓe kam ə a in nje nya nduwə. Jɨ tɔli’ə j’adɨ ndɔɔ nju kin təl nya lə’je!” ");
INSERT INTO gqr_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Be ə, ndɔri ngonn kakin uwəi’ə awi si’ə gidɨ ndɔɔ’tɨ taga, tɔli’ə. Lo kin’tɨ Jeju dəjɨ’de ene: Eke dingəm kɨ ɓe nje ndɔɔ kin a ra se’de bann wa? ");
INSERT INTO gqr_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","A re kadɨ tɔko nje ra kulə nju kin kɔ, ə ində nje kɨ rangɨ ta ndɔɔ nju’tɨ.» Lokɨ de’gɨ oyi ta kɨ Jeju el kin ningə, eli eyina: «Jagɨ, nya kin a ra nya be el.» ");
INSERT INTO gqr_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Nan Jeju gon’de ba ningə el’de ene: «Ta kɨ makitu lə Luwə el ene “Mbal kɨ njera kəy’gɨ mbəti’ə, In ə təl mbal kɨ in tɔgɨ kəy,” kin me’ə in ri ə? ");
INSERT INTO gqr_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","De kɨ ra kɨ osɨ dɔ mbal’tɨ kin ə, a tətɨ njəkɨ njəkɨ. A re mbal kin ə osɨ dɔ’a’tɨ ningə, de’ə kin a rəkitəi’ə rəkitə rəkitə». ");
INSERT INTO gqr_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Njendo ndukun’gɨ kɨ kibo’gɨ lə njekujənyamosɨ kadikare’gɨ sangi row kadɨ n’uwəi Jeju low’ə’tɨ ne, tadɔ gəri majɨ kadɨ kujita kɨ Jeju el kin ɔjɨ dɔ’de, nan ɓoli bulə de’gɨ. ");
INSERT INTO gqr_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Be ə, indəi kum’de go Jeju’tɨ, ningə uləi de’gɨ madɨ kɨ rai rɔ’de to de’gɨ kɨ dana be rɔ’a’tɨ. Uləi de rɔ’a’tɨ kadɨ to me ta’tɨ kɨ a te ta’a’tɨ kin ningə, n’uwəi’ə’n’ə n’uləi’ə ji nje konɓe’tɨ kɨ aw tɔgɨ dɔ’a’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ə de’gɨ kakin dəji Jeju eyina: «Njendo de’gɨ, jɨ gər kadɨ in njekelta kɨ rɔta’tɨ taa in njendo nya kɨ rɔta’tɨ tɔ. Kɔr kum’de dana goto rɔ’i’tɨ, isɨ ndo de’gɨ row kɨ rɔta’tɨ kɨ nəl Luwə. ");
INSERT INTO gqr_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ə el’je adɨ j’oo: In gorow’ə’tɨ eke in gorow’ə’tɨ el kadɨ j’ugə lambo nje konɓe kibo Sejar wa?» ");
INSERT INTO gqr_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Nan Jeju gər kadɨ ədi kum’ə kare, adɨ el’de ene: ");
INSERT INTO gqr_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«Tɔji m’in silə kare adi’m’in m’oo, ke dɔ nan ə sɨ’tɨ, ə tɔ nan tɔ ə ndangi’tɨ wa?» Ningə eli eyina: «In ngar Sejar.» ");
INSERT INTO gqr_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Nga a Jeju el’de ene: «Nya lə Sejar ə adi Sejar, nya lə Luwə ə adi Luwə tɔ.» ");
INSERT INTO gqr_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Lo kin’tɨ, lo kadɨ uwəi Jeju kɨ ta kɨ ta’a’tɨ non bulə de’gɨ’tɨ goto. Ta kɨ ilə’de’tɨ ətɨ’de ɓol to kətɨ yo, adɨ rai ta’de mbo. ");
INSERT INTO gqr_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","*Sadusi’gɨ kɨ madɨ rei rɔ Jeju’tɨ. Sadusi’gɨ in de’gɨ kɨ nje k’el k’ene njekoy’gɨ a indəi taa lo koy’tɨ el. Rei rɔ’a’tɨ dəji’ə eyina: ");
INSERT INTO gqr_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","«Njendo, Mojɨ ndangɨ ta kin me makitu’tɨ adi’je ene: “Re de madɨ, ngonnkon’a taa dene, ə ngonnkon’a kakin ojɨ ngonn kɨ dene kakin el ɓay ə oy ningə, kadɨ taa dene nduwə kin ojɨ’n ngann’gɨ kadɨ tei tor ngonnkon’a’tɨ.” ");
INSERT INTO gqr_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ningə kɨ ɔjidɔ ta kin, ngannkon nan’gɨ in siri. Kɨ dɔkete ta dene, ojɨ’n ngonn el ɓay ə oy. ");
INSERT INTO gqr_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Kɨ nja joo re ta dene nduwə kakin, ningə kah’a’tɨ inɓe kakin. ");
INSERT INTO gqr_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Kɨ nja mutə re in kah’a’tɨ inɓe kakin ɓay. Adɨ ngannkon nan’gɨ kɨ siri kin, taai dene kɨ kare kin pətɨ, ningə oyi adɨ lo kojɨ ngonn si’ə goto. ");
INSERT INTO gqr_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ta tɔlta’a’tɨ, darɔ dene inɓe re oy tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Nga ke ndɔ kɨ njekoy’gɨ a indəi taa lo koy’tɨ, nan dann’de’tɨ ə dene kakin a in ne’ə wa? Tadɔ in siri pətɨ taai’ə ne’de’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jeju el’de ene: «Dɔnangɨ’tɨ ne ə dingəm’gɨ kɨ dene’gɨ isɨ taai nan. ");
INSERT INTO gqr_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Nan de’gɨ kɨ Luwə oo’de kadɨ asi kadɨ a indəi taa lo koy’tɨ, kadɨ sii me ɓekon’tɨ kɨ sigɨ, a taai nan dene’tɨ kɨ dingəm el nga. ");
INSERT INTO gqr_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Taa a oyi el tɔ, tadɔ a toi to malayka’gɨ be. In ngann Luwə tadɔ Luwə adɨ’de indəi taa lo koy’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ningə ta k’el k’ene njekoy’gɨ a indəi taa lo koy’tɨ, Mojɨ inɓe elta ar njay dɔ’tɨ kadɨ njekoy’gɨ a indəi taa lo koy’tɨ. Lokɨ elta ɔjɨ’n dɔ por kɨ on me ngan’tɨ, Mojɨ ɓar Luwə ene: “Luwə lə Abiraham, Luwə lə Isakɨ, kɨ Luwə lə Jakobɨ.” ");
INSERT INTO gqr_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ningə Jeju ilə dɔ’tɨ tokɨ Luwə in Luwə lə de’gɨ kɨ nje kisi kumngayira, um in Luwə lə njekoy’gɨ el. Tadɔ takum Luwə’tɨ de’gɨ pətɨ sii kɨ dɔ’de taa.» ");
INSERT INTO gqr_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Lo kin’tɨ, njendo ndukun’gɨ kɨ nan’gɨ eli Jeju eyina: «Njendo de’gɨ, elta majɨ ngayn.» ");
INSERT INTO gqr_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Tadɔ sangi kadɨ n’dəji’ə ta kɨ rangɨ el nga. ");
INSERT INTO gqr_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jeju dəjɨ’de ta ene: «Ra bann be ə de’gɨ eli par eyina Kirisitɨ kɨ in De kɨ Luwə mbət’ə, in ngonnkaw Dabidɨ wa? ");
INSERT INTO gqr_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Tadɔ Dabidɨ inɓe kɨ dɔ’ne el me makitu Pa’gɨ’tɨ ene: “Burəɓe Luwə el Burəɓe lə’m ene: ‹Re isɨ dɔjikɔl’m’tɨ ne, ");
INSERT INTO gqr_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","bitɨ kadɨ m’təl njeban’gɨ lə’i nyakində nja’i’tɨ ginn tɔg’i’tɨ›.” ");
INSERT INTO gqr_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","«Ə re Dabidɨ ɓar Kirisitɨ De kɨ Luwə mbət’ə Burəɓe ə, ra bann taa Kirisitɨ kɨ in De kɨ Luwə mbət’ə a in ngonnkaw Dabidɨ ba par wa?» ");
INSERT INTO gqr_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Jeju el njendo’gɨ lə’ne takum bulə de’gɨ’tɨ kɨ isɨ oyi dɔ nyando li’ə ene: ");
INSERT INTO gqr_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«Indəi kumkədɨ dɔ rɔ’se’tɨ kɨ rɔ njendo ndukun’gɨ’tɨ. In de’gɨ kɨ ndigi njiyə kɨ ku ngal, taa ndigɨ kadɨ de’gɨ rai’de lapiya kɨ ɓukinan’tɨ lo kingənan’gɨ’tɨ lə bulə de’gɨ tɔ. Me kəykawnan’gɨ’tɨ lə Juwipɨ’gɨ, eke lo nyakusɔ’tɨ, a ndigi lo kisɨ kibo, kete non de’gɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Taai nyamajɨ’gɨ lə njengawkoy’gɨ pətɨ pətɨ ji’de’tɨ, ningə ədi kum de’gɨ kɨ kelta kɨ Luwə kɨ ginn’ə gangɨ el, kadɨ de’gɨ oyi’de tokɨ n’in de’gɨ kɨ majɨ. Go kulə ra’de’gɨ’tɨ kɨ be kin, Luwə a gangi’n ta kɨ ngan ngayn dɔ’de’tɨ utə ndəgɨ de’gɨ.» ");
INSERT INTO gqr_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jeju un kum’ne isɨ oo’n njenyakingə’gɨ kɨ isɨ iləi kadikare lə’de me nya kadikare’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ningə oo njengawkoy kɨ njendoo kare re kɨ ngann silə joo ilə tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ə Jeju el ene: «M’el’se tokɨ rɔta’tɨ, njengawkoy kɨ njendoo kam ilə kadikare utə ndəgɨ de’gɨ pətɨ. ");
INSERT INTO gqr_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Tadɔ ndəgɨ de’gɨ pətɨ kam, adi bunə nar’gɨ lə’de, nan njengawkoy kin, me ndoo’tɨ li’ə, nya kɨ nanyi ji’ə’tɨ kadɨ ra’n kɨ rɔ’ne ə un ba pətɨ adɨ.» ");
INSERT INTO gqr_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Go’tɨ, de’gɨ madɨ isɨ elita dɔ Kəy’tɨ lə Luwə eli eyina in nya kɨ ətɨ ɓol kɨ dum, tadɔ mbal’gɨ kɨ ndolo kɨ rai, kɨ nya’gɨ kɨ de’gɨ adi Luwə. Nan Jeju el ene: ");
INSERT INTO gqr_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","«Nya’gɨ pətɨ kɨ oyi’de kin, ndɔ madɨ a re non kɨ mbal kare kɨ a nanyi kadɨ isɨ dɔ mad’a’tɨ goto; a budi’de mur mur nanga.» ");
INSERT INTO gqr_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Lo kin’tɨ, de’gɨ kakin dəji Jeju eyina: «Njendo, dɔkagilo kɨ ra’tɨ ə nya kin a ra nya wa? Nyakɔjɨ kɨ bann ə a tɔjɨ kadɨ de’gɨ gəri dɔkagilo’ə kɨ a ra’n nya wa?» ");
INSERT INTO gqr_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jeju ilə’de’tɨ ene: «Indəi kumkədɨ dɔ rɔ’se’tɨ, adi de ədɨ’se el. Tadɔ de’gɨ ngayn a rei kɨ tɔ’m, a eli eyina: “M’in ə m’in Kirisitɨ”, ningə dɔkagilo’ə kaa re nga, nan majɨ kadɨ uni go’de el. ");
INSERT INTO gqr_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Lokɨ a oyi kah rɔ’gɨ, de’gɨ a in kɨ nan kɨ rɔ’gɨ kin, adi ɓol ra’se el. Tadɔ kadɨ nya’gɨ kin a rei kete ɓay taa, nan a in dɔboy ndɔ tanan’tɨ non el ɓay.» ");
INSERT INTO gqr_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ə Jeju el’de ɓay ene: «Ginn ɓe madɨ a aw rɔ dɔ ginn ɓe madɨ’ne’tɨ, konɓe madɨ a aw rɔ dɔ konɓe madɨ’ne’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Dɔnangɨ a yəkɨ, yəkɨ kɨ ətɨ ɓol, taa me lo’gɨ kɨ dangɨ dangɨ, monyi kosɨ’gɨ kɨ nje tɔko de’gɨ a osi ge, ɓo a on ge. Ningə nya’gɨ kɨ ətɨ ɓol ngayn a in kɨ dɔran’tɨ rei, kɨ nyakɔjɨ’gɨ kɨ əti ɓol. ");
INSERT INTO gqr_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","«Nan kete non nya’gɨ’tɨ kin pətɨ, de’gɨ a indəi ji’de dɔ’se’tɨ, a adi’se kon. A awi sese lo kəykawnan’gɨ’tɨ lə Juwipɨ’gɨ, ɓuki’se dangay’tɨ a awi sese non ngar’gɨ’tɨ kɨ boi, kɨ non nje konɓe’gɨ’tɨ tadɔ lə’m. ");
INSERT INTO gqr_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Lo kin’tɨ, in tarow kɨ te kadɨ ingəi ə manyinajɨ lə’m kɨ rɔ’de’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ningə nya kɨ kadɨ indəi dɔ’se’tɨ ə to kin. Ononyi’se kadɨ sangi ta madɨ indəi dɔ’se’tɨ kete kadɨ to eli’de manjɨ ta dɔ’se’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Tadɔ m’inɓe m’a m’adɨ’se ta kɨ gosɨ kɨ kadɨ eli’de. Ningə njekɔsɨ’se ta a asi kadɨ awi kɨ ta madɨ kɨ kadɨ ɔsi kum yan’se eke kadɨ manji el. ");
INSERT INTO gqr_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","A oyi kadɨ baw’se’gɨ kɨ kon’se’gɨ, kɨ ngannkon’se’gɨ, nojɨ’se’gɨ ba pətɨ, kɨ madɨ’se’gɨ a uni dɔ’se kadɨ adi de’gɨ. Ningə a gangi ta koy dɔ de’gɨ ngayn dann’se’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","De’gɨ pətɨ a ɔsi’se ta tadɔ lə’m. ");
INSERT INTO gqr_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Nan bisɨ dɔ’se kare kaa a osɨ kɔ el. ");
INSERT INTO gqr_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ningə in me kuwətɔgiba’tɨ anyɨ a ingəi kajɨ. ");
INSERT INTO gqr_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","«Lokɨ a oyi njerɔ’gɨ iləi nan gugi dɔ Jerujalem kin ningə, kadɨ in gəri tokɨ dɔkagilo tuj’ə in ndəkba. ");
INSERT INTO gqr_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Be ə, de’gɨ kɨ sii Jude’tɨ, kadɨ anyinan boi kɨ dɔ mbal’gɨ’tɨ, ə kadɨ nje kɨ sii me ɓebo’tɨ, tei kɨ taga rangɨ, ningə kadɨ de’gɨ kɨ isɨ mu, kadɨ uri me ɓebo’tɨ el. ");
INSERT INTO gqr_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Tadɔ a in ndɔ gangɨ ta kɨ kadɨ j’in pətɨ kɨ Makitu lə Luwə el ta’a a ra nya. ");
INSERT INTO gqr_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Kumtondoo kɨ gara goto a in lə dene’gɨ kɨ nje səm kɨ nje kadɨ mba ngann’gɨ ili ndɔ’a’tɨ non kin. Tadɔ kumtondoo kɨ ngayn a ra de’gɨ me ɓe’tɨ, kɨ wongɨ lə Luwə kɨ a re dɔ de’gɨ’tɨ kɨ me ɓe’tɨ kin tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","De’gɨ a tɔli’de kɨ kiyərɔ, a uwəi’de awi se’de ɓər’tɨ dɔ ɓe’gɨ’tɨ kɨ dangɨ dangɨ. De’gɨ kɨ gəri Luwə el a njiyəi dɔ Jerujalem mbisəi’ə mbarakɨ mbarakɨ, bitɨ kadɨ dɔkagilo lə’de kɨ Luwə ɔjɨ tɔlta’ne. ");
INSERT INTO gqr_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","«Dɔkagilo’ə’tɨ kin, nyakɔjɨ’gɨ a tei kum kadɨ’tɨ ge, kɨ nanyi ge, kɨ mee’gɨ ge. Dɔnangɨ’tɨ, mann ba a in, kah a ɓar kɨ taa, adɨ de’gɨ kɨ ginn ɓe’gɨ’tɨ kɨ dangɨ dangɨ, ɓol a tɔl’de. ");
INSERT INTO gqr_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ɓol a tɔl’de adɨ dadi par par, sii nginəi ta tujɨ’gɨ kɨ a tei dɔ’de’tɨ dɔnangɨ’tɨ. Tadɔ tɔgɨ’gɨ kɨ dɔran’tɨ a yəkɨ. ");
INSERT INTO gqr_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Lo kin’tɨ anyɨ de’gɨ a oyi m’in Ngonn de m’a m’re me kilndi’tɨ. M’a m’re kɨ tɔgɨ pətɨ, me kunjɨ’tɨ kɨ ətɨ ɓol. ");
INSERT INTO gqr_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Lokɨ nya’gɨ kin rai nya ningə, majɨ kadɨ rai rɔ’se, ɔri dɔ’se taa, tadɔ kagilo taa k’ilə taa lə’se in ndəkba.» ");
INSERT INTO gqr_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ningə Jeju un kujita ndo’n’de nya ene: «Gonyi kagɨ mbaykote kɨ ndəgɨ kagɨ’gɨ oyi. ");
INSERT INTO gqr_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Lokɨ mbi’ə ulə ngirə kitɨ kin ningə, gəri kadɨ nanyi ɓar in ndəkba nga. ");
INSERT INTO gqr_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Be tɔ ə, lokɨ oyi nya’gɨ kin rai nya ningə, majɨ kadɨ in gəri tokɨ Konɓe lə Luwə in ndəkba. ");
INSERT INTO gqr_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ningə tokɨ rɔta’tɨ, adɨ m’el’se, de’gɨ kɨ sii kɨ dɔ’de taa ne kin a oyi tigə el ɓay ə nya’gɨ kin pətɨ a rai nya. ");
INSERT INTO gqr_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Dɔran kɨ dɔnangɨ a gotoi ndɔ madɨ, nan ta’gɨ lə’m a toi lo to’de’tɨ ba bitɨ kɨ non’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","«Majɨ kadɨ sii dɔ nja’se’tɨ, um adi gon nyakusɔ kɨ gon nyakanyi, kɨ mərta kɨ dɔ nya kɨ dɔnangɨ’tɨ ne uwə me’se adɨ ndɔ kin uwə’se nanga bus el. ");
INSERT INTO gqr_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Kadɨ uwə’se nanga tokɨ bandɨ a osɨ’n dɔ kanjɨ’gɨ’tɨ kin be el. Tadɔ in nya kɨ a osɨ dɔ de’gɨ’tɨ pətɨ kɨ dɔnangɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ningə kadɨ toi ɓi el, elita kɨ Luwə kɨ dɔkagilo’gɨ pətɨ kadɨ to ingəi tɔgɨ dumi dɔ nya’gɨ pətɨ kɨ a rai nya kin, ə kadɨ tei rai kɨ takum Ngonn de’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Re kada kaa, Jeju ndo nya de’gɨ me Kəy’tɨ lə Luwə. A re kondɔ’tɨ tɔ ningə, te aw dɔ mbal’tɨ kɨ ɓari’ə dɔ mbal kagɨ Buni’gɨ. ");
INSERT INTO gqr_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Lokɨ lo tɨ njay tɔ ningə, bulə de’gɨ rei me Kəy’tɨ lə Luwə kadɨ oyi dɔ ta li’ə. ");
INSERT INTO gqr_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Nanyi mapa kɨ hum ɔd’ɔ el, kɨ ɓari’ə nanyi Pakɨ in ndəkba. ");
INSERT INTO gqr_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Kibo’gɨ lə njekujənyamosɨ kadikare’gɨ, kɨ njendo ndukun’gɨ lə Luwə, sangi row kadɨ n’uwəi Jeju n’tɔli’ə, nan ɓoli bulə de’gɨ. ");
INSERT INTO gqr_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ə Satan ur me Judasɨ’tɨ kɨ ɓari’ə Isikariyotɨ kɨ in kɨ kare mbunə njendo’gɨ’tɨ lə Jeju kɨ dɔgɨ gidə in joo. ");
INSERT INTO gqr_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ur me’ə’tɨ ad’a aw ində ta’ne nan’tɨ kɨ kibo’gɨ lə njekujənyamosɨ kadikare’gɨ kɨ njekundɔ njengəm ta *Kəy lə Luwə, dɔ row’tɨ kɨ kadɨ ulə’n Jeju ji’de’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Lo kin’tɨ, rɔ nje kɨ Judasɨ aw ingə’de kakin nəl’de ngayn adɨ uni mindɨ’de kadɨ n’adi’ə nar. ");
INSERT INTO gqr_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judasɨ ndigɨ dɔ’tɨ, nga ningə isɨ sangɨ row kɨ to kadɨ ulə’n Jeju ji’de’tɨ ə kadɨ bulə de’gɨ oyi lowə el. ");
INSERT INTO gqr_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ndɔ kusɔ mapa kɨ hum ɔd’ɔ el asɨ, adɨ in ndɔ tɔl ngann batɨ’gɨ tadɔ nyakusɔ Pakɨ. ");
INSERT INTO gqr_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ə Jeju ulə Piyər ingɨ kɨ Jan ene: «Ai rai go nyakusɔ Pakɨ kadɨ j’usɔi.» ");
INSERT INTO gqr_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ingɨ təli dəji’ə eyina: «Lokɨ ra be ə in ndigɨ kadɨ j’aw jɨ ra nyakusɔ səm’tɨ wa?» ");
INSERT INTO gqr_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ningə Jeju ilə’de’tɨ ene: «Ai, lokɨ isɨ uri kɨ me ɓebo’tɨ ningə, a tɔri tanan’tɨ kɨ dingəm kare kɨ otɨ mann me mbu ndar’tɨ dɔ’ne’tɨ ningə, uni go’ə, uri me kəy’tɨ kɨ ur’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Lokɨ uri go’ə’tɨ ningə, eli ɓe nje kəy kin eyina: “Njendo ene kadɨ jɨ dəji ke kəy kɨ ra ə kadɨ n’a n’usɔ nya Pakɨ’tɨ kɨ njendo’gɨ lə’ne wa?” ");
INSERT INTO gqr_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Lo kin’tɨ, de kakin a ɔjɨ’se me kəy kɨ boi. Me kəy kin to taa, kɨ nya’gɨ pətɨ me’tɨ. Lo kin ə a rai nyakusɔ’tɨ kadɨ j’usɔi. ");
INSERT INTO gqr_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Piyər in kɨ Jan awi ningə, ingəi nya’gɨ pətɨ asɨ nan tokɨ Jeju elɨ’n’de kakin, adɨ rai nyakusɔ Pakɨ indəi dɔ’a dana.» ");
INSERT INTO gqr_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Lokɨ dɔkadɨ asɨ, Jeju in kɨ njekawkulə’gɨ sii ta nyakusɔ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ə Jeju el’de ene: «M’ndigɨ ngayn kadɨ m’njɔ nya Pakɨ kin sese ɓay taa kadɨ m’ingə kon. ");
INSERT INTO gqr_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ningə m’el’se tokɨ rɔta’tɨ, m’a m’njɔ sese kɨ rangɨ gogɨ el, bitɨ dɔkagilo kusɔ’a’tɨ me Konɓe’tɨ lə Luwə.» ");
INSERT INTO gqr_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Go’tɨ, Jeju un kɔpɨ yiwi kandɨ nju, ra oyo Luwə dɔ’tɨ, ningə təl’n adɨ njekawkulə’gɨ ə el’de ene: «Tai anyinan dann’se’tɨ, ");
INSERT INTO gqr_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Tadɔ tokɨ rɔta’tɨ, m’a m’anyi yiwi kandɨ nju kɨ rangɨ el, bitɨ kadɨ Konɓe lə Luwə re’n.» ");
INSERT INTO gqr_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Go’tɨ, Jeju un mapa, ra oyo Luwə dɔ’tɨ, uwə tətɨ nan’tɨ, təl’n adɨ’de ene: «In kin in darɔ’m, kɨ in kɨ kun kadɨ’se. Tai sɔi kadɨ me’se olo’n dɔ’m’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Go nyakusɔ’tɨ, Jeju un kɔpɨ yiwi kandɨ nju, ra tokɨ yan nyakusɔ kakin be tɔ, ningə el’de ene: «Kɔpɨ kin in kunmindɨ kɨ sigɨ me mosɨ’m’tɨ kɨ a anyi tadɔ lə’se. ");
INSERT INTO gqr_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","«Ningə kadɨ oyi tokɨ de kɨ a ulə’m ji de’gɨ’tɨ, isɨ ulə ji’ne nan’tɨ sə’m me ngo kusɔ nya’tɨ ne. ");
INSERT INTO gqr_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Tadɔ Ngonn de a oy tokɨ Luwə ɔjɨ’n kete, nan kumtondoo in lə de kin kɨ ulə Ngonn de ji de’gɨ’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Lo kin’tɨ, njekawkulə’gɨ iləi rɔ’de isɨ dəjinan ta dann’de’tɨ ke nan dann’de’tɨ ə kadɨ a ra nya kɨ be kin wa? ");
INSERT INTO gqr_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Go’tɨ, njekawkulə’gɨ uləi ngirə manjinan ta’tɨ kɨ tɔgɨ’de eyina ke nan ə a in kibo dann’de’tɨ wa? ");
INSERT INTO gqr_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ə Jeju el’de ene: «Ngar’gɨ kɨ onyiɓe dɔ ginn de’gɨ’tɨ kɨ dangɨ dangɨ kɨ dɔnangɨ’tɨ ne, rai rɔ’de kadɨ n’in burəɓe’gɨ dɔ de’gɨ’tɨ, taa nje kɨ tɔgɨ konɓe in ji’de’tɨ, indəi tɔgɨ dɔ de’gɨ’tɨ kadɨ ɓari’de njeramajɨ’gɨ lə’de tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Nan ingɨ, majɨ kadɨ rai tokɨ ingɨ isɨ rai kin be el. De kɨ in kɨ tɔgɨ dann’se’tɨ, majɨ kadɨ təl rɔ’ne de kɨ dɔ du’tɨ, ningə kadɨ de kɨ njekundɔ’se, təl nje ra kulə lə’se tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Tadɔ de kɨ nje kisi ta nya kusɔ’tɨ num, de kɨ nje re kɨ nyakusɔ num, dann’de’tɨ kɨ joo kin, in kɨ nje kisi ta nyakusɔ’tɨ ə in kibo. Ningə m’in, m’njɨ dann’se’tɨ to nje re kɨ nyakusɔ kadɨ’se. ");
INSERT INTO gqr_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ingɨ ə in de’gɨ kɨ uwəi tɔgɨ’se ba sə’m me kon’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ningə tokɨ Luwə kɨ Bai adɨ’m Konɓe kakin ə, m’in m’adɨ’n’se tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","A sɔi ge, anyinan ge sə’m me Konɓe’tɨ lə’m. Ningə a sii dɔ kumbər gangɨ ta’gɨ’tɨ kadɨ gangɨ ta dɔ ginn kaw Isirayel’tɨ kɨ dɔgɨ gidə in joo.» ");
INSERT INTO gqr_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jeju el Simon ene: «Simon, Simon, Satan dəjɨ tarow kadɨ n’siyə’se tokɨ de a siyə’n ko me yatiya’tɨ be. ");
INSERT INTO gqr_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Nan m’in, m’elta kɨ Luwə tadɔ’i, kadɨ ilə kunme lə’i kɔ el. Ningə lokɨ a təl kɨ rɔ’m’tɨ, majɨ kadɨ ulə dingəm me ngannkon’i’gɨ’tɨ tɔ.» ");
INSERT INTO gqr_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ə Piyər el Jeju ene: «Burəɓe, m’njɨ dɔ nja’m’tɨ kadɨ re in dangay kaa m’a m’aw sə’i nan’tɨ. A re in koy kaa m’a m’oy sə’i.» ");
INSERT INTO gqr_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ə Jeju el’ə ene: «Piyər, adɨ m’el’i, ɓone inɓe kin, kunə kunjə non el ɓay ə, a manjɨ ta nja mutə tokɨ in gərɨ’m el.» ");
INSERT INTO gqr_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jeju el njendo’gɨ ene: «Lokɨ kete m’ulə’se kɨ kanjɨ kadɨ uni nar, eke ɓɔl, eke sa nja’se kin nya madɨ du’se wa?» Ə iləi Jeju’tɨ eyina: «Jagɨ, nya madɨ du’je el.» ");
INSERT INTO gqr_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Nga ə Jeju el’de ene: «Ningə kɨ ngɔsine kin, de kɨ aw kɨ nar ningə kadɨ un ji’ne’tɨ, in kɨ aw kɨ ɓɔl ə kadɨ un ji’ne’tɨ. A kin ə re de madɨ aw kɨ nya katɨ el ə kadɨ ɔr ku kɨ rɔ’ne’tɨ law kadɨ ndogɨ ə inyə nar’a ndogɨ’n nya katɨ kare uwə ji’ne’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Adɨ m’el’se, majɨ kadɨ nya kɨ makitu lə Luwə el ta’a ene: “Tudəi’ə dann njeramajel’gɨ’tɨ,” kin ra nya. Ningə nya kɨ kadɨ a re dɔ’m’tɨ, a ra nya.» ");
INSERT INTO gqr_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Njendo’gɨ eli’ə eyina: «Burəɓe, nya katɨ ə in joo kin.» Anyɨ el’de ene: «In ɓe kin asɨ.» ");
INSERT INTO gqr_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Go’tɨ Jeju te, ningə tokɨ isɨ ra’n kete kete, un tarow isɨ aw kɨ dɔ mbal kagɨ Buni’gɨ’tɨ. Njendo’gɨ li’ə uni go’ə. ");
INSERT INTO gqr_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Lokɨ rei tei dɔ mbal’tɨ, Jeju el njendo’gɨ ene: «Elita kɨ Luwə, kadɨ osi me nyanan’tɨ el.» ");
INSERT INTO gqr_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Anyɨ ɔr rɔ’ne sanyi nden, ningə ɔsɨ məkəsi’ne nanga, elta kɨ Luwə ene: ");
INSERT INTO gqr_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","«Bai, re in ndigɨ ə, ɔsɨ kɔpɨ kon kin ngərəngɨ kɔ rɔ’m’tɨ. Nan k’in ə kadɨ in kigo ndigɨ’tɨ lə’m el, nan kadɨ ndigɨ’tɨ lə’i taa.» ");
INSERT INTO gqr_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Lo kin’tɨ non be, malayka kare in dɔran’tɨ re ad’a tɔgɨ. ");
INSERT INTO gqr_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Metujɨ ra Jeju, il’ə nanga el, adɨ elta kɨ Luwə kɨ tɔgɨ’ne, tut’ə tosɨ nanga dogro dogro to kɔr mosɨ be. ");
INSERT INTO gqr_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Go kelta’tɨ kɨ Luwə, Jeju ində taa, təl re rɔ njendo’gɨ’tɨ ningə, ingə’de, isɨ toi ɓi kɨ me kon. ");
INSERT INTO gqr_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ə el’de ene: «In ri ə! isɨ to’i ɓi inɓe bitɨ wa? Indəi taa, ə elita kɨ Luwə, kadɨ osi me nyanan’tɨ el.» ");
INSERT INTO gqr_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Lokɨ Jeju a elta ba ɓay ningə, kutɨ de’gɨ tei non isɨ rei. Judasɨ, kɨ in kɨ kare dann njendo’gɨ lə Jeju kɨ dɔgɨ gidə in joo ə in non’de’tɨ. Re kɨ rɔ Jeju’tɨ kadɨ n’uwə kɨ rɔ’ne’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ə Jeju el’ə ene: «In Judasɨ kɨ kuwə kɨ a uwə Ngonn de kɨ rɔ’i’tɨ ə a ulə’n’n’ə ji de’gɨ’tɨ!» ");
INSERT INTO gqr_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Lokɨ nje njiyə kɨ Jeju oyi nya’gɨ kɨ ra ra nya be ningə, dəji Jeju eyina: «Burəɓe, majɨ kadɨ jɨ tugə’de kɨ nya katɨ eke kadɨ jɨ ra bann?» ");
INSERT INTO gqr_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ningə low’ə’tɨ non, kɨ kare dann’de’tɨ ɔr kiyə tugə’n mbi paja lə kibo lə njekujənyamosɨ kadikare’gɨ. Tugə mbi’ə kɨ dɔjikɔl’ɔ’tɨ batɨ gangɨ. ");
INSERT INTO gqr_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Nan Jeju el’de ene: «Asɨ be nga, inyəi’de adɨ rai.» Ningə ulə ji’ne ɔdɨ’n mbi paja kakin, adɨ mbi’ə təl to majɨ gogɨ. ");
INSERT INTO gqr_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Go’tɨ, Jeju un ta el kibo’gɨ lə njekujənyamosɨ kadikare’gɨ, kɨ njengəm ta Kəy lə Luwə, kɨ ngatɔgɨ’gɨ kɨ rei kɨ dɔ’a’tɨ ene: «To to nya kɨ m’in njeɓogɨ ə, rei kɨ kiyərɔ’gɨ kɨ gɔl’gɨ kadɨ uwəi m’in be? ");
INSERT INTO gqr_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ndɔ’gɨ pətɨ, m’in sese nan’tɨ natɨ Kəy’tɨ lə Luwə, nan uwəi m’in el, ningə in ndɔ lə’se ɓone, in ndɔ kɨ kadɨ tɔgɨ’gɨ kɨ majel ɔdi rɔ’de me lo kɨ diw’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Lo kin’tɨ, uwəi Jeju, awi si’ə, uri si’ə kəy lə kibo lə njekujənyamosɨ kadikare’gɨ. Piyər njiyə sanyi nden, ningə un go’de isɨ aw se’de. ");
INSERT INTO gqr_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","De’gɨ iləi por tambalo’tɨ, sii ta’tɨ, adɨ Piyər aw si ta’tɨ se’de. ");
INSERT INTO gqr_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ningə ngonn kɨ dene kare kɨ nje ra kulə me kəy’tɨ, oo Piyər isɨ kunjɨ por’tɨ, ə ində manj’a ba, ningə el ene: «In kɨ isɨ kin kaa, kete in si’ə tɔ.» ");
INSERT INTO gqr_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Nan Piyər manjɨ ene: «Dene, m’gər’ə el.» ");
INSERT INTO gqr_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ə nden go’tɨ ə de kɨ rangɨ oo Piyər, ningə təl el ɓay ene: «In kaa in dann de’gɨ’tɨ li’ə tɔ.» Nan Piyər ilə de’tɨ kakin ene: «Jagɨ, m’in se’de el.» ");
INSERT INTO gqr_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Bitɨ asɨ kadɨ kare go’tɨ, ningə de kɨ rangɨ təl re dɔ’tɨ ɓay ene: «Kɨ rɔta’tɨ, dingəm kin kete in si’ə tɔ, tadɔ in de kɨ Galile’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ə Piyər ilə’tɨ ene: «Dingəm, m’gər me ta lə’i kɨ ge kadɨ el kin el.» Anyɨ tanan’tɨ non inɓe kɨ Piyər isɨ elta ta’ne’tɨ ba ɓay ningə, kunə kunjə non. ");
INSERT INTO gqr_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Low’ə’tɨ non, Burəɓe ilə rətɨ gon Piyər, ningə me Piyər olo dɔ ta’tɨ kɨ ndɔkɨ Burəɓe el’ə ene: «Ɓone inɓe kin, kete ɓay taa kadɨ kunə kunjə non, a manjɨ ta nja mutə ene gərɨ’m el.» ");
INSERT INTO gqr_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Piyər ində lo te taga kɨ mann non kɨ tingə kum’ne’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","De’gɨ kɨ njengəm Jeju, mboi si’ə ge, tindəi’ə ge. ");
INSERT INTO gqr_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Anyɨ dɔi kum’ə ə eli eyina: «Nan ə Indəi wa, in elta kɨ ta Luwə’tɨ ə ndon ndil adɨ j’oo!» ");
INSERT INTO gqr_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Taa nyatajɨ’gɨ kɨ rangɨ ngayn tei ta’de’tɨ kɨ rɔ’a’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Lokɨ lo tɨ ningə, ngatɔgɨ’gɨ lə Juwipɨ’gɨ, kibo’gɨ lə njekujənyamosɨ kadikare’gɨ kɨ njendo ndukun’gɨ, ingəi nan, awi kɨ Jeju non njegangɨ ta’gɨ’tɨ lə’de in Juwipɨ’gɨ, ");
INSERT INTO gqr_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","ningə eli’ə eyina: «Re in ə in Kirisitɨ kɨ in De kɨ Luwə mbət’ə ə el’je adɨ j’oo.» Ə Jeju ilə’de’tɨ ene: «Re m’el’se kaa a uni me’se adi’m’in el. ");
INSERT INTO gqr_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Taa re m’dəjɨ’se ta kaa a iləi’m’in’tɨ el tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ningə kɨ jɨ ra’n tanan’tɨ ne kin, ulə ngirə ɓone kin, Ngonn de a isɨ dɔjikɔl Luwə’tɨ kɨ nje tɔgɨ nga.» ");
INSERT INTO gqr_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Anyɨ pətɨ dəji’ə eyina: «Adɨ in ngonn lə Luwə wa?» Ə Jeju el’de ene: «Inɓe’gɨ eli kɨ ta’se tokɨ, m’in Ngonn lə Luwə.» ");
INSERT INTO gqr_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Lo kin’tɨ, eli eyina: «In kin ji sangɨ kadɨ de madɨ kɨ rangɨ el taa dɔ’a’tɨ ɓay wa? J’inɓe’gɨ j’oyi ta kɨ ta’a’tɨ inɓe kɨ mbi’je ne nga kin.» ");
INSERT INTO gqr_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Go’tɨ, indəi taa pətɨ awi kɨ Jeju non Pilatɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ningə lo kin’tɨ, iləi rɔ’de isɨ indəi taa dɔ Jeju’tɨ eyina: «Dingəm kam j’ingə isɨ sulə de’gɨ kadɨ ɓukɨ’de mu. El’de kadɨ ugəi lambo ngar Sejar el. Taa ra dɔ’tɨ non el ɓay tokɨ n’in Kirisitɨ kɨ in De kɨ Luwə mbət’ə, n’in ngar.» ");
INSERT INTO gqr_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ə Pilatɨ dəjɨ Jeju ene: «In ngar lə Juwipɨ’gɨ wa?» Ningə Jeju ilə’tɨ ene: «In ta kɨ te ta’i’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Lo kin’tɨ, Pilatɨ el de’gɨ kibo’gɨ lə njekujənyamosɨ kadikare’gɨ kɨ bulə de’gɨ ene: «M’ingə nya madɨ kɨ asɨ kadɨ m’gangɨ’n ta dɔ dingəm’tɨ kin el.» ");
INSERT INTO gqr_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Nan uwəi ta’de ngan eyina: «In nje sulə de’gɨ kɨ nyando lə’ne kadɨ tanyi rɔ. Un dɔnangɨ kɨ Jude ba pətɨ, ulə ngirə Galile’tɨ bitɨ te’n rɔ’je’tɨ ne kin.» ");
INSERT INTO gqr_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Lokɨ Pilatɨ oo ta ningə dəjɨ ene ke dingəm kin in de kɨ Galile’tɨ wa? ");
INSERT INTO gqr_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ə lokɨ oo kadɨ Jeju in ginn konɓe’tɨ lə Erodɨ ningə, ulə si’ə adɨ Erodɨ kɨ dɔkagilo’ə’tɨ kin in Jerujalem’tɨ non tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Lokɨ Erodɨ oo Jeju ningə, rɔ’a nəl’ə ngayn tadɔ mayinu ə isɨ sangɨ kadɨ n’oo Jeju ɔjɨ’n dɔ ta li’ə kɨ de’gɨ isɨ eli. Erodɨ ində me’ne’tɨ kadɨ Jeju a ra nyakɔjɨ’gɨ ad’a oo. ");
INSERT INTO gqr_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ə dəj’ə ta’gɨ ngayn, nan Jeju il’ə’tɨ el. ");
INSERT INTO gqr_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Kibo’gɨ lə njekujənyamosɨ kadikare’gɨ kɨ de’gɨ kɨ njendo ndukun’gɨ in non, isɨ tiləi ta dɔ Jeju tɨ kɨ tɔgɨ’de. ");
INSERT INTO gqr_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Erodɨ in kɨ njerɔ’gɨ lə’ne kidɨ Jeju, mboi si’ə, ningə uləi ku kɨ majɨ ngayn rɔ’a’tɨ, nan təl ulə si’ə rɔ Pilatɨ’tɨ gogɨ. ");
INSERT INTO gqr_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ndɔ’a’tɨ non, Erodɨ in kɨ Pilatɨ kɨ kete in njeban’gɨ lə nan, təli madɨ nan’gɨ. ");
INSERT INTO gqr_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilatɨ ɓar kibo’gɨ lə njekujənyamosɨ kadikare’gɨ kɨ njekundɔ bulə de’gɨ, ");
INSERT INTO gqr_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","el’de ene: «In rei kɨ dingəm kin adi m’in eyina in nje sulə de’gɨ ɓukɨ’de mu, nan me ta’tɨ kɨ m’dəj’ə non’se’tɨ ne kin, m’ingə nya kɨ majel kɨ səki’ə’n’ə, kɨ asɨ kadɨ m’gangɨ’n ta dɔ’a’tɨ el. ");
INSERT INTO gqr_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Erodɨ kaa ingə nya madɨ el tɔ, tadɔ təl ulə si’ə rɔ’je’tɨ gogɨ. Nya kɨ asɨ kadɨ de tɔl’ə’n’ə goto. ");
INSERT INTO gqr_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Be ə, m’a m’adɨ indəi’ə par ə m’a m’inyə taa.»  ");
INSERT INTO gqr_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Tadɔ dɔ ɓal’gɨ pətɨ, lo ra nanyi Pakɨ’tɨ, majɨ kadɨ Pilatɨ ɔr de kare dangay’tɨ adɨ’de. ");
INSERT INTO gqr_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Nan de’gɨ pətɨ uni ndu’de kɨ taa eyina: «In tɔl’ɔ kɔ ə ɔr Barabasɨ adɨ’je.» ");
INSERT INTO gqr_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabasɨ in de kɨ uwəi’ə dangay’tɨ tadɔ wongɨ kɨ de’gɨ rai dɔ nje konɓe’tɨ, kɨ tadɔ tɔl kɨ tɔl de. ");
INSERT INTO gqr_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ningə tokɨ Pilatɨ ndigɨ’n kadɨ n’inyə’n Jeju taa, təl dəjɨ’de ta dɔ’tɨ ɓay. ");
INSERT INTO gqr_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Nan ingɨ, uni ndu’de kɨ taa eyina: «Ɓər’ə kagidəsɨ’tɨ, ɓər’ə kagidəsɨ’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilatɨ re se’de dɔ’tɨ ɓay kɨ nja mutə ene: «In ri kɨ majel ə dingəm kin ra wa? M’ingə nya madɨ rɔ’a’tɨ kɨ asɨ kadɨ de tɔl’n’ə el, adɨ m’a m’adɨ indəi’ə kɨ ndəy hawlay par ə m’a m’inyə taa.» ");
INSERT INTO gqr_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Nan ingɨ rai dɔ ndu’de’tɨ, uni ndu’de kɨ taa, elita kɨ tɔgɨ’de ngayn utə kɨ kete kadɨ ɓəri’ə kagidəsɨ’tɨ to ɓər inɓe. Ndu’de ɔr lo hɔm. ");
INSERT INTO gqr_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Be ə Pilatɨ un ndu’ne kadɨ ra nya kɨ bulə de’gɨ ndigi. ");
INSERT INTO gqr_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Adɨ ɔr Barabasɨ kɨ ndigi kadɨ ɔr’ɔ, adɨ’de. Barabasɨ in de kɨ uwəi’ə dangay’tɨ tadɔ wongɨ kɨ de’gɨ rai dɔ nje konɓe’tɨ, kɨ tadɔ tɔl kɨ tɔl’de. Nga ningə ulə Jeju ji njerɔ’gɨ’tɨ kadɨ rai si’ə nya kɨ me ndigɨ’tɨ lə bulə de’gɨ. ");
INSERT INTO gqr_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Lokɨ njerɔ’gɨ isɨ awi kɨ Jeju ningə, ingəi Simon, de kɨ Sirenn’tɨ, kɨ in mu, ningə indəi kagidəsɨ lə Jeju dɔ’a’tɨ, adɨ otɨ go’ə’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Bulə de’gɨ ngayn uni go Jeju. Dene’gɨ indəi kadɨ’de nonyi, ndingəi rɔ’de tadɔ li’ə. ");
INSERT INTO gqr_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Be ə, Jeju yətɨ kum’ne kɨ dɔ’de’tɨ, el’de ene: «Dene’gɨ kɨ Jerujalem, nonyi m’in el, nan kadɨ nonyi rɔ’se inɓe’gɨ, ə nonyi ngann’se’gɨ. ");
INSERT INTO gqr_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Tadɔ ndɔ a re non kadɨ de’gɨ a eli eyina: “Majikur in dɔ kujɨ dene’gɨ’tɨ, in dɔ nje’gɨ’tɨ kɨ oji ngonn ndɔ kare el, kɨ uləi mba ta ngonn’tɨ el.” ");
INSERT INTO gqr_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Lo kin’tɨ non be, de’gɨ a eli mbal’gɨ eyina: “Tosɨ dɔ’je’tɨ!” ə a eli dɔ gadi’gɨ eyina: “Iyə dɔ’je!” ");
INSERT INTO gqr_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Kin ə de ra kagɨ kɨ mbol be ningə, kagɨ kɨ tutɨ taa yan’a a to bann wa?» ");
INSERT INTO gqr_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Lo kin’tɨ, rei kɨ kaya’gɨ kɨ nje tɔl nya joo kadɨ tɔli’de nan’tɨ kɨ Jeju. ");
INSERT INTO gqr_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Lokɨ rei tei lo’tɨ kɨ ɓari’ə «Ka dɔ de» ningə, njerɔ’gɨ ɓəri Jeju kagidəsɨ’tɨ, low’ə’tɨ non. Taa ɓəri kaya’gɨ kɨ joo kakin nan’tɨ kɨ Jeju dɔ kagidəsɨ’tɨ tɔ: ɓəri kɨ kare dɔjikɔl’ɔ’tɨ, ə ɓəri kɨ nungɨ dɔjigəl’ə’tɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ningə Jeju el ene: «Bai, adɨ me’i sɔl dɔ’de’tɨ, tadɔ gəri nya kɨ ra rai kam el.» Non be, njerɔ’gɨ tugəi kiri mbara dɔ ku’tɨ li’ə lowəi nan. ");
INSERT INTO gqr_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Bulə de’gɨ rai ra gonyi’de, ningə njekundɔ Juwipɨ’gɨ uwəi Jeju kogi eyina: «Ajɨ ndəgɨ de’gɨ ənn ə, kadɨ ajɨ rɔ’ne inɓe adɨ j’oo tɔ, tokɨ re in Kirisitɨ kɨ in De kɨ Luwə mbət’ə.» ");
INSERT INTO gqr_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Njerɔ’gɨ kakin agi kɨ rɔ Jeju’tɨ, mboi si’ə, ningə adi’ə yiwi kandɨ nju kɨ masɨ kad’a anyi. ");
INSERT INTO gqr_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ningə eli’ə eyina: «Re in ngar lə Juwipɨ’gɨ ə, ajɨ rɔ’i inɓe adɨ j’oo.» ");
INSERT INTO gqr_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ningə ndangi ta me nya’tɨ, ɓəri taa dɔ Jeju’tɨ eyina: «In kam in ngar lə Juwipɨ’gɨ.» ");
INSERT INTO gqr_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ningə baw kaya kare kɨ ɓəri’ə dɔ kagidəsɨ’tɨ tajɨ Jeju ene: «In el ə ene in Kirisitɨ kɨ in De kɨ Luwə mbət’ə wa? Ajɨ rɔ’i inɓe, ə ajɨ’je sə’i tɔ.» ");
INSERT INTO gqr_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Nan in kɨ nungɨ ndangɨ madɨ’ne ene: «In kɨ ra ingə ko kon kɨ kare inɓe kin, in ɓol Luwə el wa? ");
INSERT INTO gqr_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Kɨ ɔjɨ dɔ’je, in low’ə’tɨ, tadɔ in nya kɨ j’inɓe jɨ duw ə jɨ tətɨ kanda, nan in, nya madɨ kare kɨ majel kɨ ra goto.» ");
INSERT INTO gqr_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ningə in kɨ nje kɔl kɨ madɨ’ne kakin təl el Jeju ene: «Jeju, ndɔ kɨ a re to ngar ə, adɨ me’i olo dɔ’m’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ə Jeju ilə’tɨ ene: «Tokɨ rɔta’tɨ, adɨ m’el’i, ɓone inɓe kin a in sə’m nan’tɨ me Paradisɨ’tɨ lə Luwə.» ");
INSERT INTO gqr_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Kadɨ kaw kɨ jam dɔ ɓe’tɨ be, ə lo diw ndul kururu dɔnangɨ’tɨ bitɨ kadɨ kɨ mutə kɨ losɔl’ɔ. ");
INSERT INTO gqr_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Kadɨ ur dana, de oo’ə el nga ningə ku kɨ gangi lo kɨ me Kəy’tɨ lə Luwə gangɨ dana joo. ");
INSERT INTO gqr_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ningə Jeju un ndu’ne kɨ taa ene: «Bai, m’inyə ndil’m me ji’i’tɨ.» Ningə go ta’tɨ kin par ə kon’a te. ");
INSERT INTO gqr_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Lokɨ kibo lə kutɨ njerɔ’gɨ kɨ ɓu oo nya’gɨ kɨ rai nya kin be ningə, ulə tɔjɨ dɔ Luwə’tɨ ə el ene: «Tokɨ rɔta’tɨ, de kin in de kɨ dana.» ");
INSERT INTO gqr_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Bulə de’gɨ kɨ in lo nya’tɨ kin, lokɨ oyi nya kɨ ra kin ningə, təli ɓe’gɨ lə’de kɨ kadɨ’de kɨ kində, ndingəi rɔ’de. ");
INSERT INTO gqr_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","De’gɨ pətɨ kɨ gəri Jeju kɨ dene’gɨ kɨ in si’ə Galile’tɨ, rai sanyi indəi kum’de ra oyi nya’gɨ kɨ isɨ rai nya. ");
INSERT INTO gqr_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Lo kin’tɨ non be ə, dingəm kare kɨ tɔ’a nan Jisepɨ in non re. Jisepɨ in kɨ kare dann njegangɨ ta’gɨ’tɨ lə Juwipɨ’gɨ, in de kɨ majɨ, in de kɨ dana, ");
INSERT INTO gqr_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","adɨ nya’gɨ kɨ kɨ madɨ’gɨ dɔ’i nan’tɨ ə rai kin, in ndigɨ se’de dɔ’tɨ el. Jisepɨ in de kɨ Arimate’tɨ, kɨ in ɓebo lə Juwipɨ’gɨ. In sii nginə ta Konɓe lə Luwə. ");
INSERT INTO gqr_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Jisepɨ aw rɔ Pilatɨ’tɨ, dəj’ə ninn Jeju. ");
INSERT INTO gqr_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Be ə, aw risɨ ninn Jeju dɔ kagidəsɨ’tɨ, re’n nanga, dolo kɨ ku dolo ninn, ningə aw ilə me ɓe ninn’tɨ kɨ rai kadɨ mbal’tɨ. In ɓe kɨ de ilə ninn’tɨ el ɓay. ");
INSERT INTO gqr_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ndɔ’a’tɨ kin, in ndɔ kɨ de’gɨ isɨ ɔsi nja nya’gɨ nan’tɨ, tadɔ lo ti par ə a in ndɔ kɔrkon. ");
INSERT INTO gqr_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Dene’gɨ kɨ in kɨ Jeju Galile’tɨ nu, rei si’ə, ndolei go Jisepɨ. Awi gonyi ɓe ninn kɨ kadɨ iləi Jeju’tɨ kakin, ə oyi ke tanan bann ə iləi ninn’ə’tɨ wa. ");
INSERT INTO gqr_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Go’tɨ, təli awi ɓe, indəi dɔ hu kagɨ kɨ ətɨ mbi, nan’tɨ, tadɔ kɔy rɔ ninn Jeju’tɨ. Ningə ndɔ kɔrkon, uwəi kɔr rɔ’de tokɨ mbərkikində el’n. ");
INSERT INTO gqr_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ndɔ Dɔmasɨ kɨ sin ba, dene’gɨ awi dɔɓadɨ’tɨ kɨ hu kagɨ kɨ ətɨ mbin kɨ indəi dɔ’a dana tadɔ kɔy rɔ ninn Jeju’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Lokɨ awi ningə, ingəi mbal kɨ uti ta ɓe ninn kakin, de nduguru’ə rangɨ. ");
INSERT INTO gqr_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Lokɨ uri me ɓe ninn’tɨ ningə, oyi ninn Burəɓe Jeju, el. ");
INSERT INTO gqr_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Low’ə’tɨ non, gəri nya kɨ kadɨ rai el, ningə nyɨ dingəm’gɨ joo kɨ uləi ku kɨ ndole rɔ’de’tɨ, tei bus kɨ rɔ’de’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ɓol tɔl dene’gɨ kin, adɨ uləi dɔ’de kɨ nanga, nan dingəm’gɨ kakin eli’de eyina: «Ra bann ə isɨ sangi de kɨ isɨ kumngayira dann njekoy’gɨ’tɨ wa? ");
INSERT INTO gqr_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Goto ne, ində taa lo koy’tɨ. Ningə majɨ kadɨ, adi me’se olo dɔ ta’tɨ kɨ el’se lokɨ in’n Galile’tɨ ɓay kin.» ");
INSERT INTO gqr_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","El ene: «Majɨ kadɨ de’gɨ a uləi Ngonn de ji njeramajel’gɨ’tɨ kadɨ ɓəri’ə kagidəsɨ’tɨ, ningə go’tɨ, a ində taa lo koy’tɨ kɨ ndɔ kɨ nja mutə tum ginn’ə ndɔ koy’o’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Lo kin’tɨ, me’de olo dɔ ta’tɨ kɨ Jeju el. ");
INSERT INTO gqr_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Be ə, lokɨ təli dɔɓadɨ’tɨ, rei ɔri poy nya’gɨ kin njendo’gɨ kɨ dɔgɨ gidə in kare kɨ ndəgə’gɨ pətɨ adi’de oyi. ");
INSERT INTO gqr_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Nje kɔr poy nya kin kadɨ njekawkulə’gɨ oyi in Mari kɨ Magidala num, Jann num, Mari kɨ kon Jakɨ num, kɨ ndəgɨ dene’gɨ kɨ in se’de. ");
INSERT INTO gqr_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Nan njekawkulə’gɨ oyi ta kin to ta nii adɨ tai ta lə dene’gɨ kakin el. ");
INSERT INTO gqr_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Lo kin’tɨ non Piyər ə ində kɨ ngodɨ, aw ilə kɔtɨ’ne ɓe ninn’tɨ ningə, oo ta ku’gɨ kɨ doloi ninn par ə rai nanga. Nya kin ndɔjɨ Piyər ngayn, lokɨ isɨ təl kɨ ɓe. ");
INSERT INTO gqr_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ndɔ’a’tɨ inɓe kakin, njendo’gɨ joo isɨ awi ngonn ɓe’tɨ kare kɨ ɓari’ə Emawusɨ, kɨ a asɨ kulə metər dɔgɨ gidə in kare kɨ ɓebo kɨ Jerujalem. ");
INSERT INTO gqr_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Njendo’gɨ kɨ joo kakin, ra elinan ta dɔ nya’gɨ’tɨ kɨ ra nya kakin. ");
INSERT INTO gqr_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ningə lokɨ ra elinan ta, ra manjinan’tɨ kakin ningə, Jeju te uwə se’de row. ");
INSERT INTO gqr_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Nan kum’de utɨ dɔ’a’tɨ adɨ gəri’ə el. ");
INSERT INTO gqr_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ə Jeju dəjɨ’de ene: «In ri ə ra manjinan ta dɔ row’tɨ be wa?» Ningə təli rai lokatɨ, kum’de diw kururu. ");
INSERT INTO gqr_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ningə kɨ kare dann’de’tɨ kɨ tɔ’a nan Kilewopasɨ el Jeju ene: «In kɨ kariba par ə in de kɨ isɨ Jerujalem’tɨ ne kɨ kanjɨ kadɨ oo poy nya’gɨ kɨ rai nya me ndɔ’gɨ kɨ ne kin.» ");
INSERT INTO gqr_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ə təl dəjɨ’de ene: «In ri ə ra nya wa?» Ə iləi’ə’tɨ eyina: «Nya kɨ ra nya ɔjɨ’n dɔ Jeju kɨ Najaretɨ’tɨ, kɨ in njekeltakita Luwə’tɨ kɨ aw kɨ tɔgɨ ngayn. Aw kɨ tɔgɨ me kuləra’ne’tɨ num, me ta kel’ne’tɨ num, non Luwə’tɨ kɨ non de’gɨ me ɓe’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Nan kibo’gɨ lə njekujənyamosɨ kadikare’gɨ, kɨ njekundɔ’gɨ lə’je, uwəi’ə, uləi’ə ji de’gɨ’tɨ kadɨ gangi ta koy dɔ’a’tɨ, ə ɓəri’ə dɔ kagidəsɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","J’in j’oo kadɨ in ə in de kɨ kadɨ a taa Isirayel’gɨ ilə’de taa. Ningə me nya’gɨ’tɨ kin pətɨ, ɓone ə in ndɔ kɨ nja mutə kɨ nya’gɨ kin rai nya. ");
INSERT INTO gqr_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Nan nya kare, dene’gɨ madɨ kɨ me kutɨ’tɨ lə’je re eli’je nya kɨ ndɔjɨ’je ngayn. Tei kɨ ginn lo ba awi dɔɓadɨ’tɨ, ");
INSERT INTO gqr_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","nan oyi ninn’ə el, ningə təli rei eli’je tokɨ malayka’gɨ tei rɔ’de’tɨ eli’de tokɨ ra kɨ dɔ’ne taa. ");
INSERT INTO gqr_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ə mad’i’je’gɨ madɨ awi dɔɓadɨ’tɨ ningə, oyi nya’gɨ tokɨ inɓe kɨ dene’gɨ eli. Ningə inɓe taa, de oo’ə el.» ");
INSERT INTO gqr_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Lo kin’tɨ, Jeju el’de ene: «In de’gɨ kɨ nyagər lə’se goto, ngan sese kadɨ uni me’se kalangɨ ba adi de’gɨ kɨ njekeltakita Luwə’tɨ! ");
INSERT INTO gqr_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Majɨ kadɨ Kirisitɨ De kɨ Luwə mbət’ə a ingə kon be ta kadɨ a ingə’n tɔɓar lə’ne.» ");
INSERT INTO gqr_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Be ə, ulə ngirə dɔ ndukun’tɨ lə Mojɨ kɨ dɔ de’gɨ’tɨ njekeltakita Luwə’tɨ pətɨ, ɔr’n’de ginn Makitu’gɨ lə Luwə pətɨ kɨ elta kɨ dɔ Jeju’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Lokɨ indəi dɔ ɓe kɨ isɨ awi’tɨ ndəkba ningə, Jeju ra dɔ kum’ne to nya kɨ a aw kɨ kete be. ");
INSERT INTO gqr_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ə gangi’ə eyina: «Kadɨ ur nga, adɨ lo diw, ənn ə isɨ nangɨ rɔ’je’tɨ.» Be ə, tɔ aw se’de lo kisɨ de’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Lokɨ isɨ ta nya kusɔ’tɨ se’de, un mapa, njangɨ dɔ’a, ningə uwə tətɨ nan’tɨ, ningə təl’n adɨ’de. ");
INSERT INTO gqr_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Lo kin’tɨ nga a, kum’de te adɨ gəri’ə tokɨ in Jeju, nan low’ə’tɨ non, Jeju tənn jipɨ adɨ oyi’ə el. ");
INSERT INTO gqr_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ə təli isɨ elinan eyina: «Lokɨ isɨ el’je ta dɔ row’tɨ, isɨ ɔr’je ginn nya’gɨ kɨ ndangi me Makitu’gɨ lə Luwə kin, to to nya kɨ in por ə isɨ on me’je’tɨ be el wa.» ");
INSERT INTO gqr_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ningə low’ə’tɨ non, indəi taa, təli iləi dɔ’de kaw Jerujalem gogɨ. Awi ingəi njendo’gɨ kɨ dɔgɨ gidə in kare kɨ ndəgə’gɨ kɨ go’de’tɨ kawinan sii. ");
INSERT INTO gqr_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ə pətɨ eli njendo’gɨ kɨ joo kakin eyina: «In ta kɨ rɔta’tɨ kadɨ Burəɓe ində lo koy’tɨ! Te ingə Simon, adɨ Simon oo’ə kɨ kum’ne!» ");
INSERT INTO gqr_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Lo kin’tɨ, njendo’gɨ kɨ joo, iləi rɔ’de ɔri’de ginn nya’gɨ kɨ ingə’n’de dɔ row’tɨ ə el’de, kɨ gər kɨ gəri Jeju lo tətɨ mapa’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Lokɨ si elinan ta ba ɓay ningə, Jeju inɓe te bus dann’de’tɨ, el’de ene: «Lapiya in sese.» ");
INSERT INTO gqr_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Lo kin’tɨ, ɓol tɔl’de, ndil’de te. Məri kadɨ in ndil ə n’oyi’ə wa ənn. ");
INSERT INTO gqr_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ə Jeju el’de ene: «Ra bann ə ndil’se goto ge, me’se tɔsɨ ge be wa? ");
INSERT INTO gqr_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Gonyi ji’m’gɨ, kɨ nja’m’gɨ kin oyi. Ndil aw kɨ da’ne ge, kɨ singə’ne ge tokɨ oyi m’in kin el.» ");
INSERT INTO gqr_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Lo kin’tɨ, tɔjɨ’de ji’ne ge, kɨ nja’ne ge adɨ’de oyi. ");
INSERT INTO gqr_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Rɔnel dum dɔ njendo’gɨ kɨ lo kadɨ uni me’de goto ɓay. In nya kɨ ətɨ’de ɓol kɨ dum. Ə Jeju dəjɨ’de ene: «Awi kɨ ngonn nyakusɔ ne wa?» ");
INSERT INTO gqr_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ningə adi’ə ngonn dow kanjɨ kɨ ndaw. ");
INSERT INTO gqr_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ə Jeju taa, sɔ takum’de’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ningə go’tɨ, el’de ene: «Ta’gɨ kɨ ndɔkɨ m’el’se lokɨ m’in sese ɓay ə to kin: Ndɔkɨ m’el’se tokɨ, nya’gɨ pətɨ kɨ ndangi me ndukun’tɨ lə Mojɨ ge, kɨ me ta’tɨ lə njekeltakita Luwə’tɨ, kɨ me pa kosɨ’tɨ kin, majɨ kadɨ a tɔlita’de be.» ");
INSERT INTO gqr_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Lo kin’tɨ nga ə, Jeju adi’de kur dɔ’de, adɨ gəri me Makitu lə Luwə. ");
INSERT INTO gqr_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ningə el’de ene: «In ta kɨ ndangi kete, tokɨ m’in Kirisitɨ De kɨ Luwə mbət’ə m’a m’ingə kon, de’gɨ a tɔli m’in, ningə go’tɨ, m’a m’ində taa dann njekoy’gɨ’tɨ kɨ ndɔ kɨ nja mutə tum ginn’ə ndɔ koy’m’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","De’gɨ a iləi mbər kɨ tɔ’m, ulə ngirə Jerujalem’tɨ, bitɨ kɨ rɔ ginn de’gɨ’tɨ pətɨ, kadɨ de’gɨ inyəi gorow njiyə’de’gɨ kɨ majel kɔ, kadɨ Luwə inyə’n go majel’gɨ lə’de kɔ tɔ. ");
INSERT INTO gqr_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ningə ingɨ in nje mannajɨ kin. ");
INSERT INTO gqr_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Kɨ ɔjidɔ’m, m’a m’ulə kɨ nya kɨ Bai un ndu’ne dɔ’tɨ kadɨ n’a n’adɨ’se kin. Ningə a sii ɓebo’tɨ ne bitɨ kadɨ tɔgɨ kɨ in dɔran’tɨ re dɔ’se’tɨ ɓay ta.» ");
INSERT INTO gqr_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Go’tɨ, Jeju aw kɨ njendo’gɨ lə’ne ndəkba kadɨ ɓe’tɨ kɨ Betani, ningə ɔy ji’ne kɨ taa, njangɨ dɔ’de. ");
INSERT INTO gqr_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Lokɨ njangɨ dɔ’de ningə, inyə’de ə ɔr rɔ’ne kɔ rɔ’de’tɨ, ningə uni’ə awi si’ə dɔran’tɨ. ");
INSERT INTO gqr_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Lo kin’tɨ non, njendo’gɨ ɔsi məkəsɨ’de nanga non’a’tɨ, ningə təli gogɨ Jerujalem kɨ rɔnel ngayn. ");
INSERT INTO gqr_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Dɔkagilo’gɨ pətɨ, in ginn Kəy’tɨ lə Luwə, uləi tɔjɨ dɔ Luwə’tɨ.");
INSERT INTO gqr_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Lotumginn nya’gɨ’tɨ pətɨ, de kɨ in ta in non nga, De kɨ in ta in nan’tɨ kɨ Luwə, De kɨ in ta in Luwə. ");
INSERT INTO gqr_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Lotumginn nya’tɨ, de kɨ in ta in nan’tɨ kɨ Luwə. ");
INSERT INTO gqr_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","In ə Luwə un’ə ra’n nya’gɨ pətɨ. Nya kɨ Luwə ra’a kɨ kanj’a in goto. ");
INSERT INTO gqr_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","De kɨ in ta kakin ə in nje kadɨ de’gɨ sii kɨ dɔ’de taa. Ningə kisikidɔtaa kɨ in rɔ’a’tɨ kin ə in kunjɨ dɔ de’gɨ’tɨ kɨ dɔnangɨ’tɨ ne. ");
INSERT INTO gqr_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Kunjɨ unjɨ dɔ lo kɨ diw’tɨ, nan lo kɨ diw uwə kunjɨ kakin kɨ rɔ’ne’tɨ el. ");
INSERT INTO gqr_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Luwə ulə de kare kɨ tɔ’a nan Jan ad’a re. ");
INSERT INTO gqr_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Re to nje mannajɨ kadɨ mannajɨ lə kunjɨ, Kadɨ de’gɨ pətɨ uni me’de adi kunjɨ kɨ takul’ə. ");
INSERT INTO gqr_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Jan in kunjɨ el, nan in nje mannajɨ lə kunjɨ. ");
INSERT INTO gqr_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","De kɨ in ta kin in ə in kunjɨ kɨ rɔta’tɨ. Kunjɨ kɨ rɔta’tɨ kɨ re dɔnangɨ’tɨ ne, unjɨ dɔ de’gɨ’tɨ pətɨ. ");
INSERT INTO gqr_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","De kɨ in ta in dɔnangɨ’tɨ ne. Ningə in ə Luwə un’ə ində’n de’gɨ kɨ dɔnangɨ’tɨ ne, nan de’gɨ kɨ dɔnangɨ’tɨ ne gəri’ə el. ");
INSERT INTO gqr_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","De kɨ in ta kin re dann de’gɨ’tɨ li’ə, nan de’gɨ li’ə uwəi’ə kɨ rɔ’de’tɨ el. ");
INSERT INTO gqr_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Nga ningə, nje kɨ uwəi’ə kɨ rɔ’de’tɨ, Adɨ in nje kɨ uni me’de adi’ə, adɨ’de tɔgɨ kadɨ təli ngann’gɨ lə Luwə. ");
INSERT INTO gqr_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Təli ngann’gɨ lə Luwə, kigo kojɨ’tɨ kɨ mosɨ tokɨ de’gɨ isɨ oji nan kin el num, Kigo ndigɨ’tɨ lə de el num, nan in Luwə inɓe ə ra adɨ təli ngann’a’gɨ. ");
INSERT INTO gqr_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","De kɨ in ta, təl darɔ de kɨ rɔta’tɨ, Uwə lo kisɨ dann’je’tɨ. Memajɨ, kɨ nya kɨ rɔta’tɨ rosi me’ə. J’in j’oo tɔjɨ li’ə. In tɔjɨ kɨ Ngonn kɨ kar’ne ba ingə kɨ rɔ Baw’ne’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jan un ndu’ne kɨ taa, mannajɨ li’ə ene: «In ə in de kɨ m’elta li’ə kete m’ene: “De kɨ a re go’m’tɨ, in kibo dɔ’m’tɨ, Tadɔ in isɨ kɨ dɔ’ne taa kete non’m’tɨ.” ");
INSERT INTO gqr_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","«J’ingɨ pətɨ, j’ingəi nya majɨ kɨ in rɔ’a’tɨ, kigo memajɨ’tɨ li’ə. Adɨ’je majikur kɨ ɔsɨ go nan go nan. ");
INSERT INTO gqr_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Luwə adɨ’je ndukun kɨ gorow lə Mojɨ, Nan memajɨ kɨ nya kɨ rɔta’tɨ rei kɨ gorow lə Jeju Kirisitɨ. ");
INSERT INTO gqr_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","De kɨ oo Luwə goto, nan Ngonn kɨ kar’ne ba, Kɨ in Luwə ə isɨ kadɨ Baw’ne’tɨ, ə ra adɨ jɨ gər’ə.» ");
INSERT INTO gqr_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Lokɨ *Juwipɨ’gɨ kɨ Jerujalem’tɨ uləi njekujənyamosɨ kadikare’gɨ kɨ nje’gɨ kɨ ginn kojɨ’tɨ lə *Lebi kɨ rɔ Jan’tɨ dəji’ə ene: «In nan wa?» ");
INSERT INTO gqr_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ningə, Jan el’de taga wangɨ, um yətɨ ta el ene: «M’in Kirisitɨ kɨ in *De kɨ Luwə mbət’ə el.» ");
INSERT INTO gqr_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Nje kɨ uləi’de kakin təli dəji’de eyina: «Nga in nan dana wa? In njekeltakita Luwə’tɨ Eli wa?» Ə Jan ilə’de’tɨ ene: «Jagɨ, m’in Eli el.» Təli dəji’ə ɓay eyina: «In *Njekeltakita Luwə’tɨ kɨ j’isɨ jɨ nginə wa?» Jan ene: «Jagɨ, m’in Njekeltakita Luwə’tɨ el.» ");
INSERT INTO gqr_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Lo kin’tɨ non, eli’ə eyina: «Nga in nan dana inɓe ə el’je adɨ j’oo, tadɔ majɨ kadɨ j’a jɨ təl kɨ ta madɨ kadɨ j’aw’n kɨ rɔ nje’gɨ’tɨ kɨ uləi’je. Ta ri ə el dɔ rɔ’i’tɨ inɓe wa?» ");
INSERT INTO gqr_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Non be nga a Jan ilə’de’tɨ ene: «M’in ə m’in de kɨ ndu’ə ɓar diləlo’tɨ ene: “Rai gorow lə Burəɓe adɨ ra njururu!” Tokɨ njekeltakita Luwə’tɨ Ejay el’n.» ");
INSERT INTO gqr_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Nje kɨ uləi’de kakin in *Parisɨ’gɨ. ");
INSERT INTO gqr_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ə təli dəji Jan Batisɨ ɓay eyina: «A kin ə re in Kirisitɨ kɨ in De kɨ Luwə mbət’ə el num, in Eli el num, taa in Njekeltakita Luwə’tɨ kɨ j’isɨ jɨ nginə kin el num tɔ ə, ra bann ə isɨ ra de’gɨ batəm wa?» ");
INSERT INTO gqr_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ə Jan el’de ene: «M’in m’ra de’gɨ batəm me mann’tɨ, nan de madɨ in mbunə’se’tɨ non kɨ in gəri’ə el. ");
INSERT INTO gqr_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","In a re go’m’tɨ, nan kulə sa kɨ nja’a’tɨ kaa m’asɨ kadɨ m’tutɨ el.» ");
INSERT INTO gqr_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Nya’gɨ kin pətɨ rai nya Betani’tɨ, dow ba Jurden’tɨ, kɨ Jan ra de’gɨ batəm’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Lo ti dɔ’tɨ, Jan oo Jeju kɨ isɨ re kɨ rɔ’a’tɨ ningə el ene: «Oyi *Ngonn batɨ lə Luwə kɨ nje kɔr majel lə de’gɨ kɨ dɔnangɨ’tɨ ne kɔ. ");
INSERT INTO gqr_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","In ə in de kɨ m’elta li’ə kete m’ene: “De kɨ re go’m’tɨ, in kibo dɔ’m’tɨ, tadɔ in isɨ kɨ dɔ’ne taa kete non’m’tɨ.” ");
INSERT INTO gqr_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","M’in kɨ dɔ’m m’gər’ə kete el, nan m’re m’ra de’gɨ batəm me mann’tɨ kadɨ m’adɨ Isirayel’gɨ gəri’ə’n’ə.» ");
INSERT INTO gqr_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Jan mannajɨ ene: «M’oo Ndil Luwə in taa, risɨ to dər dum be re isɨ dɔ’a’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","M’in m’gər’ə el, nan Luwə kɨ ulə’m adɨ m’re m’ra de’gɨ batəm me mann’tɨ ə el’m ene: “De kɨ a oyi Ndil in taa risɨ re isɨ dɔ’a’tɨ kin ə, a ra de’gɨ batəm me Ndil Luwə’tɨ.” ");
INSERT INTO gqr_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ningə m’in, m’oo nya kin kɨ kum, adɨ m’mannaj’a tokɨ de kin in Ngonn lə Luwə.» ");
INSERT INTO gqr_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Lo ti go’tɨ, Jan təl re low’ə’tɨ kakin ɓay, in kɨ njendo’gɨ lə’ne joo. ");
INSERT INTO gqr_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Be ə, lokɨ Jeju isɨ dər, adɨ kum’ə in kɨ dɔ’a’tɨ oo’ə’n’ə, ningə el ene: «Oyi Ngonn batɨ lə Luwə.» ");
INSERT INTO gqr_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Lokɨ njendo’gɨ lə Jan oyi dɔ ta kin ningə, uni go Jeju. ");
INSERT INTO gqr_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Lokɨ Jeju ilə rətɨ ningə, oo’de kadɨ isɨ uni go’ə, ə dəjɨ’de ene: «In ri ə isɨ sangi wa?» Ə ingɨ iləi’ə’tɨ eyina: «Rabi, lo kɨ sɨ’tɨ in ra be wa?» («Rabi» kɔr me’ə nan: Njendo de’gɨ) ");
INSERT INTO gqr_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jeju el’de ene: «Rei, ə oyi.» Be ə, awi, oyi lo kɨ Jeju sɨ’tɨ. Ningə sii, tɔli ta ndɔ lə’de rɔ’a’tɨ non. Dɔkadɨ, in kadɨ kɨ sɔ kɨ losɔl’ɔ. ");
INSERT INTO gqr_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andire kɨ ngonnkon Simon Piyər in de kare dann de’gɨ’tɨ kɨ joo kɨ oyi ta ta Jan’tɨ ə uni go Jeju. ");
INSERT INTO gqr_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","De kɨ dɔkete kɨ Andire ingə, in ngonnkon’a Simon. Ə el’ə ene: «J’ingə Mesi.» («Mesi» kɔr me’ə nan «Kirisitɨ, De kɨ Luwə mbət’ə.») ");
INSERT INTO gqr_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ningə, aw kɨ Simon rɔ Jeju’tɨ. Ə Jeju gon’a ba ningə el’ə ene: «In Simon, kɨ ngonn lə Jonasɨ. A ɓari’nu Sepasɨ», («Sepasɨ», kɔr me’ə nan «mbal».) ");
INSERT INTO gqr_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Lo ti go’tɨ, Jeju un ndu’ne kadɨ n’aw dɔnangɨ Galile’tɨ. Dɔ row’tɨ, ingə Pilipɨ, ningə el’ə ene: «Un go’m.» ");
INSERT INTO gqr_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pilipɨ in de kɨ Betisayda’tɨ, kɨ in ɓe lə Andire in kɨ Piyər. ");
INSERT INTO gqr_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Go’tɨ, Pilipɨ aw ingə Nataniyel, ningə el’ə ene: «J’ingə de kɨ *Mojɨ elta li’ə me ndukun’tɨ, taa de’gɨ kɨ njekeltakita Luwə’tɨ kaa elita li’ə tɔ kakin. In Jeju kɨ ngonn lə Jisepɨ kɨ Najaretɨ’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ə Nataniyel el’ə ene: «Ngonn ɓe kɨ Najaretɨ kam nya kɨ majɨ a te’tɨ tɔ wa?» Ə Pilipɨ el’ə ene: «Re oo.» ");
INSERT INTO gqr_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Lokɨ Jeju oo Nataniyel isɨ re kɨ rɔ’a’tɨ, elta dɔ’a’tɨ ene: «Oyi *Isirayel kɨ rɔta’tɨ, kɨ de asɨ kingə nya kɨ kədikumnan rɔ’a’tɨ el.» ");
INSERT INTO gqr_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Lo kin’tɨ non, Nataniyel dəjɨ Jeju ene: «In ra bann ə gərɨ’m wa?» Ə Jeju el’ə ene: «Kete taa kadɨ Pilipɨ ɓar’i, lokɨ isɨ ginn kagɨ mbaykote’tɨ kin m’oo’i.» ");
INSERT INTO gqr_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nga a Nataniyel el Jeju ene: «Njendo de’gɨ, in Ngonn lə Luwə, in ngar lə Isirayel’gɨ.» ");
INSERT INTO gqr_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jeju ilə’tɨ ene: «Tadɔ in kel kɨ m’el’i m’ene m’oo’i ginn kagɨ mbaykote’tɨ kin ə un’n me’i, a oo nya’gɨ kɨ utə in kin ɓay.» ");
INSERT INTO gqr_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Taa Jeju təl ilə dɔ ta’tɨ kin ɓay ene: «Tokɨ rɔta’tɨ, m’el’se, a oyi dɔran a til, ningə malayka’gɨ lə Luwə a ai kɨ taa ge, təli kɨ nanga ge dɔ’m’tɨ m’in *Ngonn de.» ");
INSERT INTO gqr_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ndɔ joo go’tɨ, taa nan to Kana’tɨ kɨ Galile. Kon Jeju in low’ə’tɨ non, ");
INSERT INTO gqr_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ningə ɓari Jeju in kɨ njendo’gɨ lə’ne low’ə’tɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Dɔ gangɨ lo madɨ ə, yiwi kandɨ nju goto. Ə kon Jeju el’ə ene: «De’gɨ anyinan yiwi tigə.» ");
INSERT INTO gqr_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Nan Jeju il’ə’tɨ ene: «In ri ə in ge rɔ’m’tɨ ə dene? Dɔ kadɨ lə’m asɨ el ɓay.» ");
INSERT INTO gqr_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ningə kon’a el nje lowə nya’gɨ ene: «Nya ri kɨ el’se ə rai.» ");
INSERT INTO gqr_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Nga ningə gum’gɨ mehen kɨ kuwə kɨ mbal sii non, to gum’gɨ kɨ Juwipɨ’gɨ isɨ ɔdi mann kɨ me’tɨ ari rɔ’de kigo kujɨ nyara’gɨ’tɨ lə’de kadɨ to awi kɨ ta dɔ’de el, takum Luwə’tɨ. Gum’gɨ kakin, kɨ kare me’ə a asɨ mbul joo ge mutə ge kare. ");
INSERT INTO gqr_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jeju el nje ra kulə’gɨ ene: «Mbəli mann me gum’tɨ kin adɨ rosɨ» ningə mbəli mann me’ə’tɨ adɨ rosɨ njir. ");
INSERT INTO gqr_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ningə Jeju el’de ene: «Ɔdi nga, ə awi adɨ njekində kum’ne go nyakusɔ’gɨ’tɨ,» ə ɔdi awi adi’ə. ");
INSERT INTO gqr_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Njekində kum’ne go nyakusɔ’tɨ ɔdɨ mann kɨ təl yiwi kandɨ nju kakin ta’ne’tɨ. Gər lo kɨ yiwi kandɨ nju kin te’tɨ el, nan nje ra kulə’gɨ kɨ ɔdi yiwi kandɨ nju kin gəri majɨ. Nje kində kum’ne go nyakusɔ’tɨ ɓar nje taa dene ");
INSERT INTO gqr_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","el’ə ene: «De’gɨ in nje kadɨ yiwi kandɨ nju kɨ nəl de’gɨ anyinan kete, adɨ lokɨ de’gɨ anyinan adɨ ra’de ɓay taa təli dɔ in kɨ nəl el’tɨ, nga in ra bann ə ingəm yiwi kandɨ nju kɨ nəl adɨ isɨ bitɨ dɔ kadɨ kɨ ne kin wa?» ");
INSERT INTO gqr_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","In kin ə in nyakɔjɨ lə Jeju kɨ dɔkete kɨ ra Kana’tɨ, dɔnangɨ Galile’tɨ. Nga a ra ɔjɨ’n tɔjɨ lə’ne, ningə njendo’gɨ li’ə uni me’de. ");
INSERT INTO gqr_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Go nya’gɨ’tɨ kin, Jeju aw Kapernayim’tɨ, in kɨ kon’ne kɨ ngannkon’ne’gɨ kɨ njendo’gɨ lə’ne; nan k’in ə isɨ Kapernayim’tɨ ndɔ ngayn el. ");
INSERT INTO gqr_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ndɔ ra nanyi Pakɨ lə Juwipɨ’gɨ in ndəkba ə Jeju aw Jerujalem’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Low’ə’tɨ kin non, ingə njelaw mangɨ’gɨ, batɨ’gɨ, kɨ dər dum’gɨ natɨ Kəy’tɨ lə Luwə, taa njembəl nar’gɨ kɨ ɓe’ne kɨ nje kɨ dɔɓe’gɨ’tɨ sii non tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Lo kin’tɨ, Jeju ra ndəy kulə, tuwə’n’de pətɨ natɨ Kəy’tɨ lə Luwə kɔ, nan’tɨ kɨ mangɨ’gɨ kɨ batɨ’gɨ, taa njembəl nar’gɨ kaa, sanan nar’gɨ lə’de kɔ, tində tabilə’gɨ lə’de tilə tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ningə el njelaw dər’gɨ ene: «Ɔyi nya’gɨ kin pətɨ kɔ lo kin’tɨ rangɨ, ningə kadɨ rai me Kəy lə Bai to lo ndogɨ nya kɨ lo law nya lə’se el.» ");
INSERT INTO gqr_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Lo kin’tɨ, me njendo’gɨ olo dɔ ta’tɨ kɨ ndangi me makitu’tɨ eyina: «Ta lə Kəy lə’i uwə me’m kuwə kɨ a tɔl’m.» ");
INSERT INTO gqr_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Nan Juwipɨ’gɨ uni ta eli’ə eyina: «Nyakɔjɨ ri ə a tɔjɨ kadɨ jɨ gəri’n tokɨ aw kɨ tɔgɨ kadɨ ra’n nya’gɨ kɨ ra kin wa?» ");
INSERT INTO gqr_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ə Jeju el’de ene: «Tɔi *Kəy lə Luwə kam, ə me ndɔ’tɨ kɨ mutə, m’a m’təl m’ində taa gogɨ.» ");
INSERT INTO gqr_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ə Juwipɨ’gɨ eli’ə eyina: «Jɨ ra ɓal dɔsɔ gidə in mehen ə jɨ ra Kəy lə Luwə kam oy, ningə in a təl ində rangɨ me ndɔ’tɨ kɨ mutə wa?» ");
INSERT INTO gqr_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Kəy kɨ Jeju elta’a kin in darɔ’a. ");
INSERT INTO gqr_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Nga ningə, ndɔkɨ Jeju ində taa dann njekoy’gɨ’tɨ kin, me njendo’gɨ olo dɔ’tɨ tokɨ ndɔkɨ elta kin, ə uni me’de adi ta lə Luwə kɨ ndangɨ num, uni me’de adi ta kɨ Jeju el kakin num tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Lokɨ Jeju in’n Jerujalem, dɔkagilo ra nanyi Pakɨ’tɨ, de’gɨ ngayn uni me’de, lokɨ oyi nyakɔjɨ’gɨ kɨ ra adɨ oyi kɨ kum’de. ");
INSERT INTO gqr_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Nan Jeju ə, ta me’de el, tadɔ gərɨ’de pətɨ majɨ ngayn, ");
INSERT INTO gqr_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","taa aw ndoo kadɨ de mannajɨ dɔ’de’tɨ ad’a el tɔ, tadɔ inɓe gər nya’gɨ pətɨ kɨ to me’de’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Me kutɨ’tɨ lə Parisɨ’gɨ, dingəm kare in non, tɔ’a nan Nikodem. In kɨ kare dann kɨ boi’gɨ’tɨ lə Juwipɨ’gɨ. ");
INSERT INTO gqr_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Dingəm kin re rɔ Jeju’tɨ kondɔ’tɨ el’ə ene: «Njendo de’gɨ, jɨ gər kadɨ Luwə uləi kadɨ in re ndo’je nya, tadɔ de kɨ asɨ kadɨ ra nya’gɨ kɨ ətɨ ɓol tokɨ ra’n kin be kɨ kanjɨ kadɨ Luwə in nan’tɨ si’ə el goto.» ");
INSERT INTO gqr_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jeju el’ə ene: «Tokɨ rɔta’tɨ, adɨ m’el’i, de kɨ asɨ kadɨ a oo Konɓe lə Luwə kɨ kanjɨ kadɨ oji’ə kojɨ kɨ sigɨ goto.» ");
INSERT INTO gqr_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Lo kin’tɨ, Nikodem dəjɨ Jeju ene: «De a ra bann be ə a təli oji’ə kojɨ kɨ sigɨ, lokɨ tɔgɨ gangɨ nga kin wa? A asɨ kadɨ təl aw me kon’ne’tɨ gogɨ ɓay kadɨ oji’ə kɨ nja joo wa?» ");
INSERT INTO gqr_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jeju ilə’tɨ ene: «Tokɨ rɔta’tɨ, adɨ m’el’i, de kɨ asɨ kadɨ a ur Konɓe’tɨ lə Luwə kɨ kanjɨ kadɨ oji’ə me mann’tɨ, kɨ me Ndil Luwə’tɨ goto. ");
INSERT INTO gqr_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Darɔ de kɨ koo kɨ kum, in kɨ kojɨ me mosɨ’tɨ, ningə darɔ kɨ ndil, in Ndil Luwə ə oj’o tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ta kɨ m’el’i m’ene: “Majɨ kadɨ oji’se kojɨ kɨ sigɨ” kin, adɨ əti ɓol el. ");
INSERT INTO gqr_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Tadɔ nəl ulə lo’tɨ kɨ me’ə ndigɨ, ningə in oo kah’a kɨ isɨ ɓar, nan in gər lo kɨ in’tɨ el num, in gər lo kɨ isɨ awɨ’tɨ el num tɔ. Be ə, de kɨ Ndil Luwə oj’o kaa in be tɔ.» ");
INSERT INTO gqr_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Lo kin’tɨ, Nikodem dəjɨ Jeju ene: «Nya kin a ra nya kɨ gorow kɨ bann wa?» ");
INSERT INTO gqr_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jeju el’ə ene: «In kɨ in njendo de’gɨ ndukun kɨ de’gɨ gəri dɔ’i Isirayel’tɨ kaa in gər nya’gɨ kin el ɓay wa? ");
INSERT INTO gqr_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Tokɨ rɔta’tɨ, adɨ m’el’i, j’elita dɔ nya’tɨ kɨ jɨ gər, taa jɨ mannajɨ dɔ nya’tɨ kɨ j’oo kɨ kum’je tɔ, nan in, in ndigɨ najɨ kɨ man lə’je el. ");
INSERT INTO gqr_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Lokɨ m’el’se ta dɔ nya’gɨ’tɨ kɨ dɔnangɨ’tɨ ne ə uni me’se adi’m’in el, ə ra bann be ə a uni me’se adi’m’in dɔ nya’gɨ’tɨ kɨ dɔran’tɨ kɨ m’a m’el’se ta’a wa? ");
INSERT INTO gqr_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","De kɨ aw dɔran’tɨ goto. Re in de ə, in m’in Ngonn De kɨ kar’m ba par ə m’ində dɔran’tɨ m’re dɔnangɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ningə tokɨ Mojɨ ulə’n lii kɨ rai’ə kɨ ningəkasɨ ta kagɨ’tɨ diləlo’tɨ kakin ə, majɨ kadɨ uləi m’in Ngonn De taa kagɨ’tɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Tadɔ kadɨ de kɨ un me’ne ə, de’ə kin isɨ kɨ dɔ’ne taa bitɨ kɨ non’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Tadɔ Luwə ndigɨ de’gɨ kɨ dɔnangɨ’tɨ ne ngayn, ə adɨ’de Ngonn’ne kɨ kojɨ kareba, kadɨ de kɨ ra kɨ un me’ne ə, kadɨ de’ə kin tujɨ kɔ el, nan kadɨ isɨ kɨ dɔ’ne taa bitɨ kɨ non’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Nya kɨ kadɨ de gər, Luwə ulə Ngonn’ne dɔnangɨ’tɨ kadɨ gangɨ’n ta dɔ de’gɨ’tɨ kɨ dɔnangɨ’tɨ el, nan ulə si’ə kadɨ ajɨ’de! ");
INSERT INTO gqr_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","De kɨ un me’ne adɨ Ngonn lə Luwə, Luwə a gangɨ ta dɔ’a’tɨ el, nan de kɨ un me’ne el, de’ə kin Luwə gangɨ ta dɔ’a’tɨ nga. Tadɔ un me’ne adɨ Ngonn Luwə kɨ kareba kin el. ");
INSERT INTO gqr_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Gorow kɨ takigangɨ re’n ə to kin: Kunjɨ re dɔnangɨ’tɨ, nan de’gɨ kɨ dɔnangɨ’tɨ ndigɨ lo kɨ diw yo ə mbeti kunjɨ, tadɔ kulə ra’de’gɨ in kɨ majel. ");
INSERT INTO gqr_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","De’gɨ pətɨ kɨ in njeramajel, mbeti kunjɨ, awi kɨ rɔ’a’tɨ el. Ningə kɨ rɔta’tɨ, ɓoli kaw rɔ kunjɨ, nan to kunjɨ tɔjɨ nyara’de’gɨ kɨ majel kɨ taga. ");
INSERT INTO gqr_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Nan de’gɨ kɨ nje təl rɔ’de go ndu Luwə’tɨ, rei kɨ rɔ kunjɨ’tɨ, kadɨ kunjɨ tɔjɨ kulə ra’de’gɨ kɨ taga wangɨ. In kulə’gɨ kɨ rai’de kigo ndu Luwə’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Go nya’gɨ’tɨ kin, Jeju ingɨ kɨ njendo’gɨ lə’ne ɔti awi dɔnangɨ Jude’tɨ. Si’tɨ se’de non ba, ra’n de’gɨ batəm. ");
INSERT INTO gqr_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Jan kaa ra ra de’gɨ batəm Enon’tɨ, kɨ in ndəkba kadɨ Salim’tɨ non tɔ. Tadɔ in lo kɨ mann in’tɨ ngayn. Ningə de’gɨ rei kɨ rɔ’a’tɨ adɨ ra’de batəm. ");
INSERT INTO gqr_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Dɔkagilo’ə’tɨ kin, uwəi Jan dangay’tɨ el ɓay. ");
INSERT INTO gqr_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Be ə, njendo’gɨ lə Jan kɨ nan’gɨ, manjinan ta’tɨ kɨ Juwipɨ kare be, dɔ kar rɔ’tɨ kadɨ Luwə ɔr’n ta dɔ’de’tɨ kɔ. ");
INSERT INTO gqr_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Go’tɨ, awi ingəi Jan eli’ə eyina: «Njendo’je, de kɨ ndɔkɨ awi si’ə dow ba Jurden’tɨ kɨ kare, kɨ ndɔkɨ man’n najɨ li’ə kakin, in kaa ra ra de’gɨ batəm tɔ, adɨ de’gɨ pətɨ awi kɨ rɔ’a’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ə Jan ilə’de’tɨ ene: «De kɨ asɨ kadɨ ingə nya madɨ kɨ rangɨ kɨ dɔ’ne dɔ in’tɨ kɨ Luwə inɓe ad’a kin goto. ");
INSERT INTO gqr_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Inɓe’gɨ kaa asi kadɨ manyinajɨ lə’m dɔ ta’tɨ kɨ m’el m’ene: “M’in, m’in Kirisitɨ kɨ in De kɨ Luwə mbət’ə el, nan m’in de kɨ uləi m’in kadɨ m’re kete non’a’tɨ.” ");
INSERT INTO gqr_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Kadɨ gəri tokɨ, de kɨ nje taa dene ə in ngaw dene, ningə kɨ ɔjidɔ basa madɨ ngaw dene, in, in kadɨ basa madɨ’ne’tɨ kadɨ oo ta li’ə, ə lokɨ basa mad’a elta ə osɨ mbi’ə’tɨ ə, rɔ’a nəl’ə ngayn dɔ’tɨ. Nga ningə, in kin ə in rɔnel lə’m, ningə in rɔnel kɨ ta’a asɨ nan berere. ");
INSERT INTO gqr_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Majɨ kadɨ tɔɓar li’ə aw kɨ dɔ mad’a’tɨ dɔ mad’a’tɨ, ə kadɨ m’in, m’təl kɨ gogɨ gogɨ. ");
INSERT INTO gqr_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","«De kɨ in dɔran’tɨ in dɔ nya’gɨ’tɨ pətɨ, ningə de kɨ dɔnangɨ’tɨ ne in nya kɨ dɔnangɨ’tɨ, adɨ elta dɔ nya’gɨ’tɨ kɨ dɔnangɨ’tɨ ne par. Nan de kɨ in dɔran’tɨ in dɔ nya’gɨ’tɨ pətɨ. ");
INSERT INTO gqr_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Mannajɨ dɔ nya’gɨ’tɨ kɨ oo kɨ kum’ne ge kɨ mbi’ne ge. Nan de kɨ ndigɨ mannajɨ li’ə goto. ");
INSERT INTO gqr_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","De kɨ ndigɨ najɨ kɨ man li’ə ə, de’ə tɔjɨ kadɨ Luwə elta kɨ rɔta’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Tokɨ rɔta’tɨ, de kɨ Luwə ulə, el ta’gɨ kɨ ta Luwə’tɨ, tadɔ Luwə ros’o kɨ Ndil’ne. ");
INSERT INTO gqr_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Baw Ngonn ndigɨ Ngonn, adɨ inyə nya’gɨ pətɨ me ji’ə’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","De kɨ un me’ne adɨ Ngonn, a isɨ kɨ dɔ’ne taa bitɨ kɨ non’tɨ, nan de kɨ təl rɔ’ne go ndu’tɨ lə Ngonn el, kisikidɔtaa li’ə goto, wongɨ lə Luwə in dɔ’a’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","De’gɨ eli adɨ Parisɨ’gɨ oyi tokɨ Jeju ɔyi njendo’gɨ go’ne’tɨ utə Jan, taa ra’de batəm utə tɔ, ");
INSERT INTO gqr_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","nga ningə tokɨ rɔta’tɨ ə, Jeju inɓe ra de’gɨ batəm el, nan in njendo’gɨ li’ə. ");
INSERT INTO gqr_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ə lokɨ Jeju oo kadɨ Parisɨ’gɨ oyi ta kin be ə, inyə dɔnangɨ Jude ə təl aw Galile’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Nga ningə kadɨ aw Galile’tɨ, majɨ kadɨ a ində dɔnangɨ kɨ Samari’tɨ gangɨ. ");
INSERT INTO gqr_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","In be ə aw te ɓebo’tɨ kɨ ɓari’ə Sikar dɔnangɨ Samari’tɨ kɨ in sanyi el kɨ lo ndɔɔ kɨ ndɔkɨ *Jakobɨ adɨ ngonn’ne Jisepɨ. ");
INSERT INTO gqr_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","In low’ə’tɨ inɓe kin ə bolo mann lə Jakobɨ to’tɨ. Ə Jeju njiyə ɔr ə, təl isɨ nanga ta mann’tɨ kakin. In dɔ kadɨ’tɨ kɨ kaw kɨ jam dɔ ɓe’tɨ be. ");
INSERT INTO gqr_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Lo kin’tɨ non, dene kɨ Samari’tɨ kare re kadɨ ɔdɨ mann ə Jeju el’ə ene: «Adɨ’m mann m’anyi.» ");
INSERT INTO gqr_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","*Njendo’gɨ li’ə ə awi me ɓe’tɨ kadɨ ndogi nyakusɔ. ");
INSERT INTO gqr_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Nan dene kɨ Samari’tɨ kakin el Jeju ene: «In ta kɨ bann wa? In Juwipɨ tɔ, ra bann be ə a dəjɨ’m m’in kɨ m’in dene kɨ Samari’tɨ mann kadɨ anyi wa?» Dene el be tadɔ Juwipɨ’gɨ gei kadɨ n’in kɨ Samari’gɨ n’indəi rɔ’de nan’tɨ dɔ nya madɨ’tɨ kare el. ");
INSERT INTO gqr_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jeju el’ə ene: «Kin ə re kete in gər kadikare lə Luwə num, de kɨ nje dəjɨ mann kanyi kin num ə, re in ə re a dəj’ə kadɨ a adi mann kajɨ kadɨ anyi.» ");
INSERT INTO gqr_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Dene el’ə ene: «Burəɓe! Aw kɨ nya kɔdɨ mann el tɔ, taa bolo mann ow tɔ, nga a ra bann be ə a ingə mann kajɨ kin wa? ");
INSERT INTO gqr_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","In oo rɔ’i kadɨ utə baw’je Jakobɨ kɨ adɨ’je mann kin num taa inɓe in kɨ ngann’ne’gɨ anyinan kɨ da’gɨ lə’ne num kin wa?» ");
INSERT INTO gqr_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jeju il’ə’tɨ ene: «De kɨ anyi mann kɨ jɨ ra’n ne kin, kundə a ra’a ɓay; ");
INSERT INTO gqr_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","nan de kɨ a anyi mann kɨ m’a m’ad’a kin, kundə a ra’a gogɨ el nga. Mann kɨ m’a m’ad’a kin yo ə a təl ta ɓe mann kɨ mann kajɨ kɨ bitɨ kɨ non’tɨ a te’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Dene el ene: «Burəɓe, adɨ’m mann kɨ a elta’a kin kadɨ kundə ra’m gogɨ el, taa kadɨ m’təl m’re’n ne be gogɨ m’ɔdɨ mann el nga tɔ.» ");
INSERT INTO gqr_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ə Jeju el’ə ene: «Aw, ɓar ngaw’i ə təl re ne.» ");
INSERT INTO gqr_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ningə dene el Jeju ene: «De oo ngaw’m el.» Ningə Jeju el’ə ene: «Ta lə’i in ta kɨ rɔta’tɨ kadɨ el ene de oo ngaw’i el, ");
INSERT INTO gqr_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","tadɔ taa dingəm’gɨ mi, nan in kɨ isɨ si’ə ngɔsine kin in ngaw’i el. Lo kin’tɨ in ta kɨ rɔta’tɨ ə el.» ");
INSERT INTO gqr_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Non be nga ə dene el ene: «Burəɓe, m’gər kadɨ in njekeltakita Luwə’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Baw’je’gɨ ɔsi məkəsɨ’de nanga non Luwə’tɨ dɔ mbal’tɨ kin, ningə ingɨ eli eyina lo kɔsɨ məkəsɨ nanga non Luwə’tɨ in Jerujalem.» ");
INSERT INTO gqr_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jeju el’ə ene: «Dene, un me’i adɨ’m. Dɔkagilo re kɨ kadɨ a ɔsi məkəsɨ’se nanga non Baw’je Luwə’tɨ dɔ mbal’tɨ kam el num, Jerujalem’tɨ el num. ");
INSERT INTO gqr_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","In de’gɨ kɨ Samari’tɨ, ɔsi məkəsɨ’se nanga non Luwə’tɨ kɨ in gəri’ə el, nan j’in, j’ɔsɨ məkəsɨ’je nanga non Luwə’tɨ kɨ jɨ gər’ə, tadɔ kajɨ in rɔ’je’tɨ j’in Juwipɨ’gɨ. ");
INSERT INTO gqr_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Nga ningə ndɔ re, in ndɔ kɨ kadɨ nje kɔsikurə kɨ rɔta’tɨ osi nanga non Luwə’tɨ, a ɔsikurə Baw’je Luwə me Ndil’tɨ kɨ me nya ra’tɨ kɨ rɔta’tɨ. Ingɨ kin ə in nje kɔsikurə kɨ rɔta’tɨ kɨ osi nanga non Luwə’tɨ kɨ Baw’je isɨ sangɨ’de. ");
INSERT INTO gqr_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Luwə in Ndil, ningə kadɨ nje kɔsikurə, ɔsikurə me Ndil’tɨ kɨ me nya ra’tɨ kɨ rɔta’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ə dene el’ə ene: «M’gər kadɨ “Mesi”, De kɨ Luwə mbət’ə, kɨ ɓari’ə Kirisitɨ kin a re. Ningə ndɔ kɨ a re ə, a ɔr’je me nya’gɨ pətɨ.» ");
INSERT INTO gqr_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ə Jeju el’ə ene: «In darɔ’m m’inɓe ə m’a m’el’i ta am.» ");
INSERT INTO gqr_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Lo kin’tɨ non be, njendo’gɨ lə Jeju tei non rei, ningə ndɔjɨ’de ngayn kadɨ oyi Jeju ra elta kɨ dene de, nan de kɨ kadɨ el’ə ene: «In ri ə ge ji’ə’tɨ wa?» eke «tadɔ ri ə el’ə ta wa?» goto. ");
INSERT INTO gqr_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Dene inyə gum mann lə’ne non be, ə anyi aw me ɓebo’tɨ el de’gɨ ene: ");
INSERT INTO gqr_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«Rei oyi de kɨ el’m nya’gɨ pətɨ kɨ m’ra kin. A in Kirisitɨ kɨ in De kɨ Luwə mbət’ə el bitɨ wa?» ");
INSERT INTO gqr_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ningə de’gɨ tei me ɓebo’tɨ kɨ taga awi kɨ rɔ Jeju’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Lokɨ dene ɔtɨ aw kin ə njendo’gɨ eli Jeju eyina: «Njendo de’gɨ, sɔ nya!» ");
INSERT INTO gqr_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Nan Jeju el’de ene: «M’in m’aw kɨ nyakusɔ kɨ kadɨ m’njɔ kɨ in nyakusɔ kɨ in gəri el.» ");
INSERT INTO gqr_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Dɔ ta’tɨ kin njendo’gɨ dəji nan ta dann’de’tɨ eyina: «De madɨ ad’a nya sɔ wa?» ");
INSERT INTO gqr_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ə Jeju el’de ene: «Nyakusɔ lə’m in ra go ndigɨ’tɨ lə Nje kulə’m, kɨ tɔlta kulə li’ə. ");
INSERT INTO gqr_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","In eli eyina, kɨ ne kin: “Nanyi sɔ ɓay ə koo a asɨ tətɨ,” nan m’in m’a m’el’se m’ene: uni kum’se kɨ taa gonyi ndɔɔ oyi; koo tutɨ asɨ kujə nga! ");
INSERT INTO gqr_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Kɨ ji ra ne kin, de kɨ nje tətɨ koo ingə nyakugə goji lə’ne ningə kaw kandɨ nya kɨ dɔnan’tɨ tadɔ kisikidɔtaa kɨ bitɨ kɨ non’tɨ kadɨ to de kɨ njeduw nya num nje tət’ə num rai rɔnel nan’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Tadɔ kujita kɨ ene: “De kare duw ə in kɨ nungɨ tətɨ” kin in ta kɨ rɔta’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","M’ulə’se m’adɨ awi təti koo me ndɔɔ’tɨ kɨ ingɨ rai kulə el. Nje kɨ rangɨ ingəi kon’a, ningə in rei təti kandɨ kulə lə’de.» ");
INSERT INTO gqr_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","De’gɨ kɨ dɔnangɨ Samari’tɨ pətɨ kɨ me ɓebo’tɨ kin uni me’de adi Jeju dɔ najɨ kɨ man’tɨ kɨ dene man dɔ’a’tɨ ene: «El’m nya’gɨ pətɨ kɨ m’ra.» ");
INSERT INTO gqr_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Nga ningə lokɨ rei tei rɔ’a’tɨ, de’gɨ kɨ Samari’tɨ dəji’ə kadɨ isɨ se’de, ə Jeju isɨ se’de ndɔ joo. ");
INSERT INTO gqr_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Kɨ takul ta kɨ ta’a’tɨ, de’gɨ kɨ uni me’de in ngayn inɓe ɓay; ");
INSERT INTO gqr_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","ningə eli dene eyina: «In kɨ tadɔ ta’gɨ kɨ el’je inɓe kin par ə j’uni’n me’je el, nan j’inɓe j’oo ta kɨ ta’a’tɨ kɨ mbi’je, ningə jɨ gər kadɨ in Njekajɨ de’gɨ tokɨ rɔta’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ndɔ joo go’tɨ, Jeju ɔtɨ non təl aw dɔnangɨ Galile’tɨ gogɨ. ");
INSERT INTO gqr_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ningə inɓe mannajɨ ene: «De kɨ njekeltakita Luwə’tɨ kɨ ingə kɔsikurə me ɓe kojɨ’ne’tɨ goto.» ");
INSERT INTO gqr_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Nan lokɨ re te Galile’tɨ, de’gɨ kɨ dɔnangɨ Galile’tɨ uwəi’ə kɨ rɔ’de’tɨ majɨ ngayn, tadɔ inɓe’gɨ kaa rai lo ra nanyi’tɨ kɨ Jerujalem tɔ adɨ oyi nya’gɨ pətɨ kɨ Jeju ra lo ra nanyi’tɨ kɨ kum’de. ");
INSERT INTO gqr_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Jeju təl re Kana kɨ Galile’tɨ kɨ lo kɨ ndɔkɨ ra mann adɨ təl yiwi kandɨ nju’tɨ. Ningə dingəm kare kɨ in de kibo kɨ isɨ ra kulə kɨ ngar, ə rɔ ngonn’o kɨ dingəm to’ə Kapernayim’tɨ non. ");
INSERT INTO gqr_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Lokɨ dingəm kakin oo kadɨ Jeju in Jude’tɨ re dɔnangɨ Galile’tɨ, re ingə, non kɨ dɔ’a’tɨ kadɨ aw Kapernayim’tɨ ajɨ ngonn’ne kɨ to ta koy’tɨ kin. ");
INSERT INTO gqr_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ə Jeju el’ə ene: «Kin ə re oyi nyakɔjɨ’gɨ kɨ nya’gɨ kɨ ətɨ ɓol kɨ kum’se el ə a asi kadɨ a uni me’se el ratata.» ");
INSERT INTO gqr_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","De kibo kɨ nje ra kulə kɨ ngar kakin el Jeju ene: «Burəɓe, tokɨ ngonn’m oy el ɓay kin in re ɓe lə’m.» ");
INSERT INTO gqr_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Nan Jeju el’ə ene: «Aw, ngonn’i ajɨ nga.» Ningə dingəm un me’ne adɨ taa kɨ Jeju el dɔ ta’tɨ kin el, adɨ osɨ dɔ row’tɨ aw. ");
INSERT INTO gqr_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ə lokɨ in dɔ row’tɨ isɨ təl, ɓər’gɨ li’ə ra tiləi kum’ə eli’ə eyina: «Ngonn’i ajɨ!» ");
INSERT INTO gqr_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ningə dəjɨ’de ke kadɨ kɨ bann ə rɔ ngonn to’n sotɨ wa? Ningə eli’ə eyina: «In tagine kɨ kadɨ kɨ dɔgɨ gidə in mutə ə rɔ’a kɨ tingə ngayn kete kakin təl sɔl.» ");
INSERT INTO gqr_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Lo kin’tɨ, baw ngonn oo kadɨ in dɔ kadɨ’tɨ inɓe kɨ Jeju el’ə’n’ə ene: «Ngonn’i ajɨ nga» kin. Low’ə’tɨ non, dingəm un me’ne adɨ Jeju, nan’tɨ kɨ de’gɨ kɨ me kəy’tɨ li’ə ba pətɨ. ");
INSERT INTO gqr_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","In kin ə in nyakɔjɨ kɨ nja joo kɨ Jeju ra lokɨ təl’n Jude’tɨ re Galile’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Go nya’gɨ’tɨ kin, Juwipɨ’gɨ rai nanyi lə’de adɨ Jeju aw Jerujalem’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Nga ningə Jerujalem’tɨ, lo ndogɨ mann kɨ ɓari’ə kɨ ta Ebirə nan Betisata to non, ndəkba kadɨ tarow ndogɨ bɔr’tɨ kɨ de’gɨ isɨ awi kɨ nyakul’gɨ me ɓebo’tɨ. Tabitɨ’gɨ in mi ta lo ndogɨ mann’tɨ kakin, ");
INSERT INTO gqr_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","ningə ginn tabɨtɨ’gɨ’tɨ kakin njemonyi’gɨ to’i’tɨ mbar mbar: njekumtɔ’gɨ, nje mote’gɨ kɨ njerɔkoy njururu’gɨ. Toi isɨ nginəi ta mann kɨ kadɨ ɔdɨ rɔ’ne; ");
INSERT INTO gqr_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","tadɔ malayka lə Burəɓe kare a ur me mann’tɨ kadɨ bur. Nje monyi kɨ dɔkete kɨ osɨ me mann’tɨ kɨ bur kakin ə, re monyi li’ə to’n bann bann kaa ingə lapiya. ");
INSERT INTO gqr_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Low’ə’tɨ kin, de kɨ monyi ra’a ɓal dɔ mutə gidə in jijoo in’tɨ non. ");
INSERT INTO gqr_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jeju oo’ə to nanga, ningə lokɨ eli’ə tokɨ to me kon’tɨ kin be ɓal ngayn, dəj’ə ene: «Ge kingə lapiya wa?» ");
INSERT INTO gqr_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ə nje monyi el’ə ene: «Burəɓe, de kɨ kadɨ un’m ilə’m me mann’tɨ lokɨ mann isɨ ɔdɨ rɔ’ne kin goto. Lokɨ m’ene m’aw ə, de kɨ rangɨ ur me’tɨ non’m’tɨ kete.» ");
INSERT INTO gqr_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ə Jeju el’ə ene: «Ində taa, un tuwə lə’i ə njiyə, aw.» ");
INSERT INTO gqr_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ningə tanan’tɨ non, dingəm ingə lapiya adɨ un tuwə lə’ne ə njiyə, aw. Nga ningə ndɔ’a’tɨ kin in ndɔ kɔrkon. ");
INSERT INTO gqr_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ə Juwipɨ’gɨ eli dingəm kɨ ingə lapiya kakin eyina: «Ɓone in ndɔ kɔrkon, in go’tɨ el kadɨ otɨ tuwə lə’i njiyə’n.» ");
INSERT INTO gqr_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Nan el’de ene: «In de inɓe kɨ adɨ’m lapiya kin ə el’m ene: “Un tuwə lə’i ə aw.”» ");
INSERT INTO gqr_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ə dəji’ə ta eyina: «De’ə inɓe kɨ el’i ene: “Un tuwə lə’i ə aw” kin in nan wa?» ");
INSERT INTO gqr_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Nan de kɨ ingə lapiya kaa gər’ə el, tadɔ Jeju ur kakɨ dann bulə de’gɨ’tɨ kɨ rai low’ə’tɨ non kin. ");
INSERT INTO gqr_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Kagilo nden go’tɨ, Jeju təl ingə natɨ Kəy’tɨ lə Luwə ə el’ə ene: «Oo, ngɔsine kin ingə lapiya nga. Ningə kadɨ ra majel el ratata nan to nya madɨ kɨ ngan ngayn te dɔ’i’tɨ ɓay.» ");
INSERT INTO gqr_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Lo kin’tɨ, dingəm aw el Juwipɨ’gɨ tokɨ in Jeju ə adɨ’ne lapiya. ");
INSERT INTO gqr_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","In be ə, Juwipɨ’gɨ awi kɨ ta kɨ Jeju kɨ ra nya kin ndɔ kɔrkon’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Nan Jeju el’de: «Bitɨ ɓone kaa Bai isɨ ta ra kɨ de’gɨ’tɨ, ningə m’in kaa majɨ kadɨ m’ra kɨ de’gɨ tɔ.» ");
INSERT INTO gqr_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Tadɔ ta kɨ Jeju el kin, njekundɔ Juwipɨ’gɨ sangi row kɨ rangɨ dɔ mad’a’tɨ kadɨ n’tɔli’ə; tadɔ eli eyina Jeju ra nya bujɨ’n ndɔ kɔrkon par el, nan el ɓay ene Luwə in Baw’ne kɨ ojɨ’ne, adɨ ra rɔ’ne kadɨ n’in de kɨ n’asɨ nan kɨ Luwə. ");
INSERT INTO gqr_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jeju təl un ta el’de ene: «Oyo, tokɨ rɔta’tɨ, adɨ m’el’se, m’in Ngonn lə Luwə m’ra kadɨ m’asɨ ra nya dɔ rɔ’m el. In nya kɨ m’oo Bai ra ə m’in m’ra. Nya kɨ Bai ra ə, m’in Ngonn’o m’ra kah’a’tɨ inɓe kin tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Tadɔ Bai ndigɨ’m m’in Ngonn’o adɨ tɔjɨ’m nya’gɨ pətɨ kɨ inɓe ra. A tɔjɨ’m kulə ra’gɨ kɨ ətɨ ɓol ngayn ɓay kɨ kadɨ a ra’se ɓol. ");
INSERT INTO gqr_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Tadɔ tokɨ kaa kɨ Bai isɨ un’n njekoy’gɨ lo koy’tɨ adɨ’de kumngayira kakin ə, m’in Ngonn’o, m’adɨ kumngayira de kɨ ra tokɨ m’ge tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Bai gangɨ ta dɔ de’tɨ el, nan adɨ’m tɔgɨ m’in Ngonn’o kadɨ m’gangɨ’n ta dɔ de’gɨ’tɨ, ");
INSERT INTO gqr_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","kadɨ de’gɨ pətɨ ɔsikurə’m tokɨ ɔsikurə Bai be tɔ. De kɨ ɔsikurə’m m’in Ngonn el, ɔsikurə Bai kɨ njekulə’m el jagɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Tokɨ rɔta’tɨ, adɨ m’el’se, de kɨ oo ta lə’m, taa un me’ne adɨ njekulə’m num tɔ ə, de’ə kin a ingə kajɨ kɨ bitɨ kɨ non’tɨ. Ta kɨ gangɨ a osɨ dɔ’a’tɨ el, nan dər dɔ koy nga adɨ in me kajɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Tokɨ rɔta’tɨ, adɨ m’el’se, ndɔ a re, ningə ndɔ’a re nga kɨ kadɨ njekoy’gɨ a oyi dɔ ndu’m m’in Ngonn lə Luwə. Nga ningə de’gɨ kɨ a oyi dɔ ndu’m a si kumngayira. ");
INSERT INTO gqr_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Tadɔ tokɨ kaa kɨ Bai ə in nje kadɨ de’gɨ kajɨ kakin ə, adɨ’m m’in Ngonn’o tɔgɨ kadɨ m’adɨ de’gɨ kajɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Adɨ’m m’in Ngonn’o tɔgɨ kadɨ m’gangɨ’n ta dɔ de’gɨ’tɨ, tadɔ m’in Ngonn de. ");
INSERT INTO gqr_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ningə kadɨ adi ətɨ’se ɓol el, tadɔ ndɔ re nga kɨ kadɨ de’gɨ pətɨ kɨ toi ɓe ninn’tɨ a oyi dɔ ndu’m. ");
INSERT INTO gqr_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Nje kɨ rai nya kɨ majɨ a tei lo koy’tɨ tadɔ kaw kɨ kajɨ’tɨ, ə njera nya kɨ majel a tei lo koy’tɨ tadɔ kaw kɨ lo gangɨ ta’tɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","M’in m’ra kadɨ m’ra nya madɨ dɔ rɔ’m el. M’in m’gangɨ ta kigo ndu’tɨ kɨ m’ingə rɔ Luwə’tɨ. Nga ningə, ta kɨ gangɨ lə’m in ta kɨ gangɨ kɨ dana tadɔ m’njɨ m’sangɨ ndigɨ lə’m el nan m’njɨ m’sangɨ ndigɨ lə njekulə’m.» ");
INSERT INTO gqr_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Jeju el ene: «Kin ə re in m’inɓe ə m’man najɨ dɔ rɔ’m’tɨ ə re de kɨ a ndigɨ sə’m dɔ najɨ kɨ man’tɨ lə’m goto. ");
INSERT INTO gqr_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Nan in de kɨ rangɨ ə mannajɨ dɔ’m’tɨ, ningə m’gər kadɨ mannajɨ kɨ dɔ’m’tɨ kin in ta kɨ rɔta’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","In uləi kɨ de’gɨ rɔ Jan Batisɨ’tɨ, ə Jan mannajɨ kɨ rɔta’tɨ dɔ’m’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","M’in m’aw ndoo kadɨ de mannajɨ dɔ’m’tɨ el, nan m’el be kadɨ ingəi kajɨ. ");
INSERT INTO gqr_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jan Batisɨ in lambɨ kɨ kində por’tɨ tadɔ koo’n lo, ningə ingɨ ndigɨ kadɨ rai rɔnel kunj’ə’tɨ ngonn kagilo kare. ");
INSERT INTO gqr_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Nan nya’gɨ kɨ rangɨ manyinajɨ dɔ’m’tɨ utə nya Jan sanyi: kulə’gɨ kɨ m’ra’de, adɨ in kulə’gɨ kɨ Bai adɨ’m kadɨ m’ra kin manyinajɨ dɔ’m’tɨ taa tɔjɨ kadɨ Bai ə ulə’m. ");
INSERT INTO gqr_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Bai inɓe kɨ ulə’m, mannajɨ dɔ’m’tɨ. Nan k’in ə in oyi ndu’ə ndɔ kare el num, oyi takum’ə el num. ");
INSERT INTO gqr_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ngəmi ta li’ə el, tadɔ m’in kɨ ulə’m kin uni me’se adi’m’in el. ");
INSERT INTO gqr_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Sii sangi ginn ta lə Luwə majɨ majɨ tadɔ oyi kadɨ a ingəi kajɨ kɨ bitɨ kɨ non’tɨ me’tɨ; nga ningə in ta lə Luwə inɓe kin ə in nje mannajɨ dɔ’m’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Nan in mbəti rei rɔ’m’tɨ kadɨ ingəi kajɨ kɨ bitɨ kɨ non’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","M’in m’sangɨ kadɨ de’gɨ piti m’in el. ");
INSERT INTO gqr_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ningə nya kare kɨ m’oo rɔ’se’tɨ, m’gər kadɨ in ndigi Luwə el. ");
INSERT INTO gqr_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","M’in m’re kɨ tɔ Bai, nan mbəti kadɨ uwəi m’in kɨ rɔ’se’tɨ. Ningə kin ə de kɨ rangɨ re kɨ tɔ’ne inɓe ə, a uwəi’ə kɨ rɔ’se’tɨ majɨ. ");
INSERT INTO gqr_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ingɨ kɨ isɨ sangi kadɨ ingəi tɔjɨ kɨ kadɨ inɓe’gɨ uləi dɔnan’tɨ kɨ yo ge kɨ ne ge yo, um sangi kadɨ ingəi tɔjɨ kɨ in rɔ Luwə’tɨ kɨ in kɨ kar’ne ba ə in Luwə kin el, ningə a rai bann be ə a uni me’se adi’m’in wa? ");
INSERT INTO gqr_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Kadɨ oyi tokɨ in m’in ə m’a m’un dɔ’se m’aw’n rɔ Bai’tɨ el, nan in Mojɨ kɨ indəi me’se dɔ’a’tɨ kin ə a ində taa dɔ’se’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ningə kin ə re uni me’se adi Mojɨ tokɨ rɔta’tɨ dɔ ta’tɨ kɨ ndangɨ ə re a uni me’se adi’m’in tɔ, tadɔ in ta kɨ dɔ’m’tɨ ə Mojɨ ndangɨ. ");
INSERT INTO gqr_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ə re oyi ta kɨ ndangɨ kin to ta kɨ rɔta’tɨ el ə ra bann be ə a uni me’se adi’m’in dɔ ta’tɨ kɨ m’el kin wa?» ");
INSERT INTO gqr_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Go nya’gɨ’tɨ kin, Jeju ɔtɨ non, aw gidɨ ba’tɨ kɨ Galile, kɨ ɓari’ə ba kɨ Tiberiyadɨ. ");
INSERT INTO gqr_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Bulə de’gɨ ngayn uni go’ə, tadɔ de’gɨ oyi nyakɔjɨ’gɨ kɨ ətɨ ɓol kɨ Jeju ra dɔ nje monyi’gɨ’tɨ ajɨ’n’de. ");
INSERT INTO gqr_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Tadɔ nya kin ə Jeju al dɔ mbal’tɨ taa, ningə isɨ dɔ’tɨ nan’tɨ kɨ njendo’gɨ lə’ne. ");
INSERT INTO gqr_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Dɔkagilo’ə’tɨ kin, nanyi lə Juwipɨ’gɨ kɨ ɓari’ə nanyi Pakɨ in ndəkba. ");
INSERT INTO gqr_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Lokɨ Jeju un kum’ne ningə, oo bulə de’gɨ kɨ isɨ rei kɨ rɔ’a’tɨ. Ə dəjɨ Pilipɨ ene: «J’a j’ingəi mapa ra ə j’a jɨ ndogi kadɨ bulə de’gɨ kin pətɨ sɔi wa?» ");
INSERT INTO gqr_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jeju dəjɨ ta kin be kadɨ oo’n ta kɨ me Pilipɨ’tɨ, tadɔ inɓe gər nya kɨ kadɨ a ra ɓətɨ. ");
INSERT INTO gqr_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ə Pilipɨ ilə’tɨ ene: «Kin ə re jɨ ndogɨ mapa kɨ nar kulə kɨ ndɔ ɓu joo mindɨ kaa asɨ kadɨ a ɔdɨ ta’de nden nden pətɨ el.» ");
INSERT INTO gqr_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Lo kin’tɨ, njendo lə Jeju kare kɨ tɔ’a nan Andire, kɨ in ngonnkon Simon Piyər, el Jeju ene: ");
INSERT INTO gqr_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«Ngonn kɨ dingəm kare, aw kɨ mapa mi, kɨ in mapa kɨ rai kɨ ko kɨ ɓari’ə ɔrjɨ, taa ngann kanjɨ’gɨ joo tɔ. Nan in kin in nya kɨ kadɨ de elta’a kadɨ de’gɨ’tɨ kɨ banyinan be kin el.» ");
INSERT INTO gqr_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ə Jeju ene: «Adi de’gɨ pətɨ sii nanga.» Low’ə’tɨ kin, mu in ngayn səm’tɨ, adɨ de’gɨ uwəi lo sii’tɨ nanga. De’gɨ kin asi dingəm’gɨ dər mi. ");
INSERT INTO gqr_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Be ə, Jeju un mapa, ra oyo Luwə dɔ’tɨ, ə lowə de’gɨ pətɨ kɨ rai low’ə’tɨ non kin. Un kanjɨ lowə’de kah’a’tɨ kakin tɔ. Adi’de kigo me ge’tɨ lə’de. ");
INSERT INTO gqr_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Lokɨ sɔi asɨ’de nga a, Jeju el njendo’gɨ lə’ne ene: «Kawi gində’gɨ kɨ nanyi kin, kadɨ de inyə nya madɨ kɔ el.» ");
INSERT INTO gqr_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Be ə, mapa kɨ mi kɨ de’gɨ sɔi, njendo’gɨ kawi gində’gɨ kɨ nanyi kara dɔgɨ gidə in joo. ");
INSERT INTO gqr_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Lokɨ de’gɨ oyi nyakɔjɨ kɨ ətɨ ɓol kɨ Jeju ra kin ningə eli eyina: «Kɨ rɔta’tɨ, de kin in Njekeltakita Luwə’tɨ kɨ majɨ kadɨ to re dɔnangɨ’tɨ kakin inɓe.» ");
INSERT INTO gqr_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Nga ningə, Jeju gər kadɨ a rei to uni’ə ai indəi’ə ngar, adɨ təl ɔr rɔ’ne aw gogɨ dɔ mbal’tɨ, kɨ kar’ne ba. ");
INSERT INTO gqr_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Lokɨ lo sɔl, njendo’gɨ lə Jeju awi kadɨ ba’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Awi ali me to’tɨ, uni ta’de kaw kɨ Kapernayim’tɨ, kɨ in dow ba’tɨ kɨ kare. Lo kin’tɨ, lo ndul dɔ’de’tɨ, taa Jeju kaa təl re rɔ’de’tɨ el ɓay tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Nəl ulə kɨ tɔgɨ’ne ngayn, adɨ mann babo in pu pu. ");
INSERT INTO gqr_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Njendo’gɨ ɔsi to asɨ kulə metər mi be ningə, oyi Jeju kaa ra njiyə dɔ mann’tɨ isɨ re kɨ rɔ to’tɨ. Lokɨ oyi Jeju ra njiyə dɔ mann’tɨ, ɓol ra’de ngayn. ");
INSERT INTO gqr_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Nan Jeju el’de ene: «In m’in, ɓoli el!» ");
INSERT INTO gqr_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Lo kin’tɨ, ndigɨ kadɨ n’uni Jeju me to’tɨ, nan tanan’tɨ non par ə, to ɔdɨ nangɨ lokɨ isɨ awi’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Lo ti go’tɨ, bulə de’gɨ kɨ nanyinan gidɨ ba’tɨ, oyi kadɨ tagine to in kareba par ə njendo’gɨ lə Jeju ali me’tɨ ai dɔ rɔ’de, um Jeju al me’tɨ se’de el. ");
INSERT INTO gqr_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Lo kin’tɨ non, to’gɨ kɨ rangɨ in Tiberiyadɨ’tɨ rei, rai lo katɨ, ndəkba kadɨ lo’tɨ kɨ ndɔkɨ Burəɓe elta ra’n oyo dɔ mapa’tɨ ə adɨ bulə de’gɨ sɔi kakin. ");
INSERT INTO gqr_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Lokɨ bulə de’gɨ oyi Jeju el num, njendo’gɨ li’ə el num ə, ali me to’gɨ’tɨ awi kɨ Kapernayim sangi Jeju’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Lokɨ ingəi Jeju dow ba’tɨ kɨ kare, dəji’ə eyina: «Njendo de’gɨ, in re te ne kadɨ bann’tɨ wa?» ");
INSERT INTO gqr_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ə Jeju təl el’de ene: «Rɔta, rɔta adɨ m’el’se, isɨ sangi m’in tadɔ mapa kɨ sɔi ndanni, um in tadɔ gər ə in gəri me nyakɔjɨ’gɨ kɨ m’ra kin el. ");
INSERT INTO gqr_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Majɨ kadɨ rai kulə tadɔ nyakusɔ kɨ a ndu’m kin el, nan tadɔ nyakusɔ kɨ a to bitɨ kɨ non’tɨ. In nyakusɔ kɨ m’in Ngonn de m’a m’adɨ’se, tadɔ Luwə kɨ Baw’je ra ndaja kare rɔ’m’tɨ tadɔ tɔjɨ’m tokɨ m’in de lə’ne.» ");
INSERT INTO gqr_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Lo kin’tɨ, bulə de’gɨ təli dəji’ə eyina: «In ri ə majɨ kadɨ jɨ ra taa kadɨ jɨ ra’n kulə kɨ Luwə ndigɨ wa?» ");
INSERT INTO gqr_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ə Jeju təl el’de ene: «Nya kɨ Luwə ge rɔ’se’tɨ, in kadɨ uni me’se adi de kɨ ulə.» ");
INSERT INTO gqr_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Be ə eli’ə eyina: «Nyakɔjɨ ri ə a ra taa kadɨ j’oo ə j’un me’je wa? Kulə ri ə a ra wa?» ");
INSERT INTO gqr_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Kaw’je’gɨ sɔi nyakusɔ kɨ in dɔran’tɨ kɨ ɓari’ə nan mann. Be ə ndangi me makitu’tɨ eli eyina: «Adi’de sɔi mapa kɨ in dɔran’tɨ taa.» ");
INSERT INTO gqr_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Lo kin’tɨ, Jeju təl el’de ene: «Tokɨ rɔta’tɨ, adɨ m’el’se, in Mojɨ ə adɨ’se mapa kɨ in dɔran’tɨ el, nan in Bai Luwə ə adɨ’se mapa kɨ rɔta’tɨ kɨ in dɔran’tɨ taa. ");
INSERT INTO gqr_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Tadɔ mapa lə Luwə kɨ adɨ de’gɨ, in mapa kɨ in dɔran’tɨ taa kɨ nje kadɨ de’gɨ kɨ dɔnangɨ’tɨ ne sii kɨ dɔ’de taa.» ");
INSERT INTO gqr_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Be ə, təli eli’ə eyina: «Burəɓe, adɨ’je mapa kin kɨ ndɔ’gɨ ndɔ’gɨ adɨ j’usɔ.» ");
INSERT INTO gqr_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jeju el’de ar njay ene: «M’in mapa kɨ nje kadɨ de kumngayira. De kɨ re rɔ’m’tɨ ɓo a ra’a el bitɨ kɨ non’tɨ, de kɨ un me’ne adɨ’m kaa, kundə a ra’a el bitɨ kɨ non’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ningə m’el’se tokɨ oyi m’in, nan uni me’se adi’m’in el. ");
INSERT INTO gqr_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Nje kɨ Bai adɨ’m’de a rei rɔ’m’tɨ. Ningə de kɨ re rɔ’m’tɨ, m’a m’tuwə el jagɨ. ");
INSERT INTO gqr_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Tadɔ m’ində dɔran’tɨ, m’re dɔnangɨ’tɨ tadɔ ra ndigɨ lə’m el, nan kadɨ m’ra ndigɨ lə njekulə’m. ");
INSERT INTO gqr_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ningə nya kɨ njekulə’m kɨ ulə’m ndigɨ kadɨ m’ra ə to kin: ndigɨ kadɨ to madɨ de kare dann de’gɨ’tɨ kɨ adɨ’m’de kin nanyi kɔ el, nan kadɨ m’te se’de ji koy’tɨ dɔboy ndɔ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","In kin ə in nya kɨ Bai ndigɨ: ndigɨ kadɨ de’gɨ pətɨ kɨ oyi m’in Ngonn lə Luwə ə uni me’de adɨ m’in, ingəi kajɨ kɨ to bitɨ kɨ non’tɨ, ə kadɨ m’te se’de ji koy’tɨ dɔboy ndɔ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Juwipɨ’gɨ ɓarita dɔ Jeju’tɨ tadɔ el ene: «M’in mapa kɨ in dɔran’tɨ taa.» ");
INSERT INTO gqr_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ɓarita dann’de’tɨ eli eyina: «Jeju kam, in ngonn lə Jisepɨ el wa? Jɨ gər kon’a’gɨ kɨ baw’a’gɨ majɨ tɔ, nga ra bann be ə el ene n’in dɔran’tɨ taa ə n’re wa?» ");
INSERT INTO gqr_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jeju təl el’de ene: «ɓarita ta dann’se’tɨ el. ");
INSERT INTO gqr_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","De kɨ asɨ kadɨ re rɔ’m’tɨ kɨ kanjɨ kadɨ Bai kɨ ulə’m, ɔr’ɔ tarow goto. Ningə re Bai te tarow ad’a ə, m’in m’a te si’ə ji koy’tɨ dɔboy ndɔ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ndangi me makitu’tɨ lə kɨ kare dann Njekeltakita Luwə’tɨ eyina: “Pətɨ, Luwə a ndo’de nya,” ningə de kɨ ra kɨ oo ndu Luwə kɨ Bai ə taa nyando li’ə, de’ə kin re rɔ’m’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","In kin ə tɔjɨ kadɨ de oo Bai Luwə el; in nje k’in rɔ Luwə’tɨ kɨ kar’ne ba ə oo Bai Luwə. ");
INSERT INTO gqr_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Rɔta, rɔta, adɨ m’el’se, de kɨ un me’ne taa, ingə kajɨ kɨ to bitɨ kɨ non’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","M’in mapa kɨ de sɔ ə a oy el. ");
INSERT INTO gqr_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Dilə mbo’tɨ, kaw’se’gɨ sɔi nyakusɔ kɨ in dɔran’tɨ kɨ ɓari’ə nan mann, kaa oyi. ");
INSERT INTO gqr_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Nan mapa kɨ in dɔran’tɨ kin, in mapa kɨ kadɨ de sɔ ə, de a oy el. ");
INSERT INTO gqr_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","M’in mapa kisikidɔtaa kɨ in dɔran’tɨ taa. Re de sɔ mapa kin ə, de’ə a oy el bitɨ kɨ non’tɨ. Mapa kɨ m’a m’adɨ, in darɔ’m kɨ kadɨ de’gɨ sii kumngayira.» ");
INSERT INTO gqr_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Lo kin’tɨ, Juwipɨ’gɨ manjinan ta ngayn dann’de’tɨ eyina: «De kin a ra bann ta kadɨ a adɨ’je darɔ’a kadɨ j’usɔ wa?» ");
INSERT INTO gqr_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ə Jeju el’de ene: «Rɔta, rɔta, adɨ m’el’se, re sɔi darɔ’m m’in Ngonn de el num, anyinan mosɨ’m el num ə, a ingəi kajɨ el. ");
INSERT INTO gqr_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","De kɨ sɔ darɔ’m ə anyi mosɨ’m tɔ ningə, de’ə kin a ingə kajɨ kɨ to bitɨ kɨ non’tɨ, ningə m’a m’te si’ə ji koy’tɨ dɔboy ndɔ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Tadɔ darɔ’m in nyakusɔ kɨ rɔta’tɨ, ə mosɨ’m in nyakanyi kɨ rɔta’tɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","De kɨ sɔ darɔ’m num, anyi mosɨ’m num tɔ ə, j’in si’ə j’in nan’tɨ kareba. ");
INSERT INTO gqr_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Bai kɨ ulə’m isɨ kumngayira adɨ m’in m’njɨ kumngayira kɨ ta kul’ə. Be ə, de kɨ sɔ darɔ’m a isɨ kumngayira kɨ takul’m tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","In kin ə in mapa kɨ in dɔran’tɨ taa. To to mapa kɨ kaw’se’gɨ sɔi ə oyi kin el, nan in mapa kɨ de sɔ ə, de’ə kin a oy el, a isɨ kɨ dɔ’ne taa kɨ ndɔ’gɨ ndɔ’gɨ.» ");
INSERT INTO gqr_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ta’gɨ kin tei ta Jeju’tɨ lokɨ isɨ ndo’n nya de’gɨ ginn kəykawnan’tɨ lə Juwipɨ’gɨ, me ɓe’tɨ kɨ Kapernayim. ");
INSERT INTO gqr_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","De’gɨ ngayn dann njendo’gɨ’tɨ lə Jeju, lokɨ oyi ta kin ta Jeju’tɨ ningə, eli eyina: «Ta kin in ta kɨ ngan ngayn, de kɨ asɨ kadɨ a ində mbi’ne go’tɨ goto.» ");
INSERT INTO gqr_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jeju gər me’ne’tɨ kadɨ njendo’gɨ li’ə isɨ ɓarita dɔ ta’tɨ li’ə. Be ə el’de ene: «Ta kin tugə’se jigɨ’tɨ wa? ");
INSERT INTO gqr_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","A kin ə re oyi m’in Ngonn de m’təl m’aw taa lo kis’i’tɨ kɨ m’njɨ’tɨ kete kin ə a rai bann wa? ");
INSERT INTO gqr_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","In Ndil ə in nje kadɨ de isɨ kɨ dɔ’ne taa. De dɔrɔ’ne in nya madɨ el. Ningə ta’gɨ kɨ m’el’se kete kin in Ndil num in kisikidɔtaa num. ");
INSERT INTO gqr_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Nan de’gɨ madɨ dann’se’tɨ uni me’de adi’m’in el.» Jeju el be, tadɔ lo kulə ngirə’tɨ ɓay, gər de’gɨ kɨ a adi’ə me’de el, taa gər de kɨ njekulə ji njeban’gɨ’tɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Jeju ilə dɔ’tɨ ɓay ene: «In tadɔ kin ə m’el’se m’ene: “De kɨ Bai ad’a tarow el, asɨ kadɨ a re rɔ’m’tɨ dɔrɔ’ne el.”» ");
INSERT INTO gqr_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","In dɔ ndɔ’a’tɨ non kin, ngayn’gɨ dann njendo’gɨ’tɨ li’ə təli go’ə’tɨ, mbeti njiyəi si’ə. ");
INSERT INTO gqr_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ə Jeju tu rɔ’ne kɨ rɔ nje kɨ dɔgɨ gidə in joo’tɨ el’de ene: «Nga ingɨ, a awi el yan’ne wa?» ");
INSERT INTO gqr_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Nan Piyər el Jeju ene: «Burəɓe, j’a j’aw rɔ nan’tɨ wa? In ə ta kajɨ in me ji’tɨ bitɨ kɨ non’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","J’in, j’un me’je pətɨ dɔ’i’tɨ. Ningə jɨ gər kadɨ in Kar njay kɨ Luwə ulə.» ");
INSERT INTO gqr_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jeju təl el’de ene: «In m’in ə m’mbətɨ’se in kɨ dɔgɨ gidə in joo kin, nan de kare dann’se’tɨ, ndil Su in me’ə’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Lo kin’tɨ, Jeju isɨ elta kɨ dɔ Judasɨ’tɨ kɨ ngonn lə Simon Isikariyotɨ’tɨ. Tadɔ in ə in kɨ kare dann njendo’gɨ’tɨ kɨ dɔgɨ gidə in joo kɨ a ulə Jeju ji njeban’gɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Go’tɨ, Jeju nanyi kɨ lo njiyə’tɨ dɔnangɨ Galile’tɨ, ge el kadɨ n’njiyə n’aw ə n’təl dɔnangɨ Jude’tɨ, tadɔ njekundɔ Juwipɨ’gɨ isɨ sangi kadɨ n’tɔli’ə. ");
INSERT INTO gqr_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Nga ningə dɔkagilo ra nanyi lə Juwipɨ’gɨ kɨ kadɨ sii ginn *Kəyku’tɨ in ndəkba, ");
INSERT INTO gqr_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ə ngannkon Jeju eli’ə eyina: «In ne ə aw dɔnangɨ Jude’tɨ adɨ njendo’gɨ lə’i kaa oyi nya’gɨ kɨ isɨ ra’de kin tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","De kɨ ndigɨ kadɨ de’gɨ oyi’ne kam a ra nya’gɨ kutɨ lo’tɨ el. Nga ningə, tokɨ isɨ ra nya’gɨ kɨ ətɨ ɓol kin, majɨ kadɨ ra adɨ de’gɨ pətɨ oyi’nu.» ");
INSERT INTO gqr_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Nan tokɨ rɔta’tɨ, ngannkon’a’gɨ inɓe uni me’de adi’ə el. ");
INSERT INTO gqr_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ə Jeju el’de ene: «Ndɔ lə’m re el ɓay; nan ingɨ, ndɔ’gɨ pətɨ to majɨ tadɔ lə’se. ");
INSERT INTO gqr_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","De’gɨ kɨ dɔnangɨ’tɨ ne kin a awi sese kɨ ta el, nan m’in ə, me’de majel sə’m tadɔ m’el kulə ra’de’gɨ kɨ majel kɨ taga. ");
INSERT INTO gqr_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ingɨ ə awi lo ra nanyi’tɨ kin. M’in ə, m’a m’aw el, tadɔ ndɔ lə’m nanyi ɓay.» ");
INSERT INTO gqr_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Go ta’gɨ’tɨ kɨ el kin, isɨ Galile’tɨ ba. ");
INSERT INTO gqr_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Nan lokɨ ngannkon’a’gɨ awi lo ra nanyi’tɨ, in kaa ɔtɨ osɨ dɔ row’tɨ tɔ kɨ kanjɨ kadɨ de oo’ə. Aw to lo kaw kɨ lo kiyə’tɨ be. ");
INSERT INTO gqr_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Dɔkagilo ra nanyi’tɨ, njekundɔ Juwipɨ’gɨ sangi Jeju ningə dəji eyina: «In lo’tɨ kɨ ra be wa?» ");
INSERT INTO gqr_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","De’gɨ manjinan ta’tɨ ngayn dɔ’a’tɨ dann bulə de’gɨ’tɨ; nje kɨ nan’gɨ eli eyina: «In de kɨ majɨ,» ə nje kɨ nungɨ eli eyina: «Jagɨ, isɨ ɓukɨ bulə de’gɨ mu’tɨ,» tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","In be kaa de kɨ kadɨ elta li’ə kɨ taga wangɨ goto, ɓoli njekundɔ Juwipɨ’gɨ. ");
INSERT INTO gqr_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ndɔ’gɨ kɨ kadɨ ra nanyi dər te dana nga ə Jeju aw ginn Kəy’tɨ lə Luwə, isɨ ndo nya de’gɨ. ");
INSERT INTO gqr_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","In nya kɨ ndɔjɨ Juwipɨ’gɨ ngayn adɨ dəji nan ta eyina: «In kam de ndo’ə nya el tɔ, nga ra bann ə gər nya ətɨ ɓol be wa?» ");
INSERT INTO gqr_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ə Jeju ilə’de’tɨ ene: «Nya kɨ m’njɨ m’ndo kin ngirə in rɔ’m’tɨ el, nan ngirə in rɔ Luwə’tɨ kɨ njekulə’m. ");
INSERT INTO gqr_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Kin ə re de ndigɨ kadɨ n’ra nya kɨ Luwə ndigɨ ə, lo kin’tɨ ə a gər ar njay tokɨ nya kɨ m’njɨ m’ndo kin ngirə in rɔ Luwə’tɨ eke in m’inɓe ə m’ində ngirə wa. ");
INSERT INTO gqr_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","De kɨ nje kelta kɨ tɔ’ne inɓe isɨ sangɨ tɔɓar lə’ne inɓe. Nan de kɨ sangɨ tɔɓar lə nje kulə’ne a elta kɨ rɔta’tɨ, ningə nya kɨ gorow’ə’tɨ el goto rɔ’a’tɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mojɨ adɨ’se ndukun adɨ tai majɨ, nan de kɨ təl rɔ’ne go’tɨ goto. Nga ra bann ə isɨ sangi kadɨ tɔli m’in wa?» ");
INSERT INTO gqr_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ə bulə de’gɨ eli’ə eyina: «In aw kɨ ndil kɨ majel me’i’tɨ! Nan ə isɨ sangɨ kadɨ n’tɔli wa?» ");
INSERT INTO gqr_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ə Jeju təl un ta ilə’de’tɨ ene: «M’ra nya kareba be, ə ingɨ pətɨ ətɨ’se ɓol! ");
INSERT INTO gqr_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mojɨ adɨ’se ndu kadɨ ujəi mɔtɨ ngann’gɨ ningə in ndu kɨ te rɔ Mojɨ’tɨ ne par el, nan in kaw’je’gɨ kɨ kete nu ə uni ndu kin ə ingɨ si ujəi mɔtɨ ngann’gɨ ndɔ kɔrkon’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Kin ə re ujəi mɔtɨ ngonn ndɔ kɔrkon’tɨ kadɨ to de kidɨ ndukun lə Mojɨ el ə, ra bann ə me’se to’se dɔ’m’tɨ m’in kɨ m’ajɨ darɔ de ba pətɨ ndɔ kɔrkon’tɨ wa? ");
INSERT INTO gqr_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Inyəi ta gangɨ ta kigo lo koo’tɨ lə’se, ə gangi ta kɨ dana.» ");
INSERT INTO gqr_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","De’gɨ kɨ Jerujalem’tɨ eli eyina: «De kam el ə de’gɨ isɨ sangi kadɨ n’tɔli’ə wa? ");
INSERT INTO gqr_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Nga nyɨ ra elta taga wangɨ am, ə de el’ə ta madɨ el! Kibo’gɨ lə’je gəri ɓətɨ kadɨ in Kirisitɨ, De kɨ Luwə mbət’ə inɓe wa ənn? ");
INSERT INTO gqr_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Kɨ ne kin, jɨ gər lo kɨ de kin in’tɨ majɨ, nan ndɔ kɨ Kirisitɨ De kɨ Luwə mbət’ə a te bus ə, de kare kaa a gər lo kɨ in’tɨ el.» ");
INSERT INTO gqr_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Lo kin’tɨ, Jeju kɨ isɨ ndo de’gɨ nya ginn Kəy’tɨ lə Luwə un ndu’ne kɨ taa ene: «In mərita kadɨ in gəri m’in majɨ, taa in gəri lo kɨ m’in’tɨ tɔ! Ta ri in m’inɓe ə m’ulə rɔ’m el, nan Luwə kɨ njekulə’m in de kɨ asɨ kadɨ de ində me’ne dɔ’a’tɨ. Ingɨ, in gəri’ə majɨ el. ");
INSERT INTO gqr_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","M’in m’gər’ə majɨ tadɔ m’ində rɔ’a’tɨ, taa in ə ulə’m tɔ.» ");
INSERT INTO gqr_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Lo kin’tɨ, de’gɨ isɨ sangi kadɨ n’uwəi Jeju, nan de kɨ kadɨ ində ji’ne dɔ’a’tɨ goto, tadɔ ndɔ li’ə asɨ el ɓay. ");
INSERT INTO gqr_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ningə dann bulə de’gɨ’tɨ, de’gɨ ngayn uni me’de adi’ə ə eli eyina: «Dɔkagilo kɨ Kirisitɨ De kɨ Luwə mbət’ə a re ə, a ra nyakɔjɨ’gɨ kɨ utə nya dingəm kin wa?» ");
INSERT INTO gqr_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ə ta kɨ bulə de’gɨ isɨ yəmi ginn mindɨ de’tɨ ɔjidɔ Jeju kin osɨ mbi Parisɨ’gɨ’tɨ, adɨ Parisɨ’gɨ kɨ kibo’gɨ lə njekujənyamosɨ kadikare’gɨ uləi njengəm dɔ lo’gɨ lə’de kadɨ awi uwəi Jeju. ");
INSERT INTO gqr_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ə Jeju el ene: «M’a m’in sese kagilo nden be ɓay, ə m’a m’aw kɨ rɔ nje kulə’m’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","A sangi m’in nan a ingəi m’in el, tadɔ lokɨ m’a m’in’tɨ kin a asi kadɨ a awi’tɨ el.» ");
INSERT INTO gqr_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ə dɔ ta’tɨ kin Juwipɨ’gɨ dəji nan ta eyina: «Lo kɨ ra be ə a awɨ’tɨ ə kadɨ j’a j’ingəi el wa? A aw go ngannkon’ne’gɨ’tɨ kɨ sananyinan dann Girekɨ’gɨ’tɨ kin kadɨ aw ndo nya Girekɨ’gɨ wa? ");
INSERT INTO gqr_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ta kɨ el ene: “A sangi m’in nan a ingəi m’in el, tadɔ lokɨ m’a m’in’tɨ kin a asi kadɨ a awi’tɨ el,” kin kɔr me’ə nan ri wa?» ");
INSERT INTO gqr_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Dɔboy ndɔ ra nanyi, kɨ in ndɔ kibo ngayn ə, Jeju ində ra taa un ndu’ne kɨ taa el ene: «Kin ə re de madɨ kundə ra’a ə, kadɨ re rɔ’m’tɨ anyi mann. ");
INSERT INTO gqr_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","De kɨ un me’ne adɨ’m ə, “mann ba’gɨ kɨ nje kadɨ de’gɨ si kɨ dɔ’de taa a uwəi bul bul ngar me’ə’tɨ,” tokɨ Makitu lə Luwə el’n.» ");
INSERT INTO gqr_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Lo kin’tɨ, Jeju isɨ elta lə Ndil Luwə kɨ kadɨ de’gɨ kɨ uni me’de adi’ə a ingəi, tadɔ dɔkagilo’ə’tɨ kin Ndil Luwə re dɔ de’gɨ’tɨ el ɓay, tadɔ Jeju ur me tɔjɨ’tɨ lə’ne el ɓay. ");
INSERT INTO gqr_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Dann bulə de’gɨ’tɨ, de’gɨ madɨ kɨ oyi ta kel Jeju eli eyina: «Tokɨ rɔta’tɨ, de kam in Njekeltakita Luwə’tɨ kɨ majɨ kadɨ a re kakin ə inɓe!» ");
INSERT INTO gqr_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Nje kɨ nan’gɨ eli eyina: «In Kirisitɨ kɨ in De kɨ Luwə mbət’ə.» Nan nje kɨ nungɨ ɓay manji eyina: «Kadɨ Kirisitɨ in de kɨ Galile’tɨ wa? ");
INSERT INTO gqr_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Makitu lə Luwə el tokɨ Kirisitɨ kɨ in De kɨ Luwə mbət’ə, a in de kɨ ginn kojɨ’tɨ lə *Dabidɨ, ningə a te kɨ tarow kɨ Betilehem’tɨ, kɨ in ngonn ɓe kojɨ Dabidɨ.» ");
INSERT INTO gqr_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","In be ə, bulə de’gɨ gangi nan tadɔ lə Jeju. ");
INSERT INTO gqr_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","De’gɨ madɨ dann’de’tɨ ndigɨ kuwə, nan de kɨ kadɨ ində ji’ne dɔ’a’tɨ goto. ");
INSERT INTO gqr_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Njengəm ta lo lə Juwipɨ’gɨ kɨ awi kadɨ uwəi Jeju kakin, təli rei rɔ njekundɔ njekujənyamosɨ kadikare’gɨ’tɨ in kɨ Parisɨ’gɨ, ə kibo’gɨ lə njekujənyamosɨ kadikare’gɨ kɨ Parisɨ’gɨ dəji’de eyina: «Nga ra bann ə rei si’ə el wa?» ");
INSERT INTO gqr_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ə njengəm lo’gɨ eli eyina: «Ndɔ kare j’oo de elta tokɨ dingəm kin isɨ el’n el.» ");
INSERT INTO gqr_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ə Parisɨ’gɨ dəji’de eyina: «Ingɨ kaa inyəi rɔ’se adɨ ədɨ’se tɔ wa? ");
INSERT INTO gqr_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Oyi’de kare be dann nje kɨ boi’tɨ eke dann Parisɨ’gɨ’tɨ un me’ne non wa? ");
INSERT INTO gqr_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Bulə de’gɨ kam in de’gɨ kɨ gəri ndukun lə Mojɨ el, in de’gɨ kɨ Luwə a tujɨ’de kɔ!» ");
INSERT INTO gqr_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodem kɨ in kɨ kare dann Parisɨ’gɨ’tɨ kɨ kete aw rɔ Jeju’tɨ un ta el’de ene: ");
INSERT INTO gqr_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","«Kin ə re de oo ta kɨ ta’de’tɨ el num, taa oo nya kɨ ra el num ə, ndukun lə’je a gangɨ ta dɔ’a’tɨ el.» ");
INSERT INTO gqr_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Nan iləi’ə’tɨ eyina: «In kaa in de kɨ Galile’tɨ tɔ wa? In sangɨ ginn’ə majɨ oo, njekeltakita Luwə’tɨ kɨ kadɨ in de kɨ Galile’tɨ goto.» ");
INSERT INTO gqr_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Go’tɨ, de kɨ ra kaa ɔtɨ aw ɓe lə’ne. ");
INSERT INTO gqr_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jeju ɔtɨ non aw dɔ mbal kagɨ Buni’gɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Nan lokɨ lo ti njay par ə təl re natɨ Kəy’tɨ lə Luwə. De’gɨ pətɨ rei kɨ rɔ’a’tɨ, ə isɨ nanga isɨ ndo’de nya. ");
INSERT INTO gqr_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Lo kin’tɨ, njendo ndukun’gɨ kɨ Parisɨ’gɨ rei kɨ dene kɨ indəi ji’de dɔ’a’tɨ lo kuwə marum’tɨ, adi’ə ra takum de’gɨ’tɨ, ");
INSERT INTO gqr_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","ningə eli Jeju eyina: «Njendo de’gɨ, dene kam j’ində ji’je dɔ’a’tɨ lo kuwə marum’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Nga ningə, Mojɨ el’je me ndukun’tɨ kadɨ koo dene’gɨ kɨ be kin jɨ tilə’de kɨ mbal jɨ tɔl’de kɔ, ə in, ta lə’i in ri wa?» ");
INSERT INTO gqr_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Elita kin be to kuləkikiyə kadɨ uwəi Jeju to indəi taa dɔ’a’tɨ. Nan Jeju ulə dɔ’ne nanga ə isɨ ndangɨ nya kɨ ngonn ji’ne nanga. ");
INSERT INTO gqr_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ə lokɨ nanyinan kɨ lo dəj’ə ta’tɨ, Jeju ɔr dɔ’ne taa el’de ene: «De kɨ dann’se’tɨ ne kɨ ra majel nja kare el ə, kadɨ ilə kɨ mbal dɔkete.» ");
INSERT INTO gqr_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Jeju elta be ə təl ulə dɔ’ne nanga gogɨ, isɨ ndangɨ nya nanga. ");
INSERT INTO gqr_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ə lokɨ oyi ta kin ə, ɔti kare kare, ulə ngirə dɔ nje kɨ tɔgɨ’tɨ, təl’n dɔ nje kɨ du’tɨ. Ta tɔlta’a’tɨ, Jeju nanyi kɨ kar’ne ba. Dene kakin ə ra ngawdann lo’tɨ; ");
INSERT INTO gqr_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","ə Jeju un dɔ’ne kɨ taa el’ə ene: «Dene, de’gɨ kaa rai ra? De kare kaa gangɨ ta dɔ’i’tɨ el wa?» ");
INSERT INTO gqr_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ningə dene el’ə ene: «Burəɓe, de kare kaa gangɨ ta dɔ’m’tɨ el,» ə Jeju el’ə ene: «M’in kaa m’gangɨ ta dɔ’i’tɨ el jagɨ tɔ, nga ningə aw, ə ra majel gogɨ el.» ");
INSERT INTO gqr_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jeju təl el’de ɓay ene: «M’in kunjɨ kɨ dɔnangɨ’tɨ, de kɨ un go’m, a njiyə me lo kɨ diw’tɨ el, kunjɨ kɨ nje kadɨ de’gɨ sii kɨ dɔ’de taa a unjɨ dɔ’a’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Lo kin’tɨ, Parisɨ’gɨ eli’ə eyina: «In inɓe ə isɨ mannajɨ kɨ dɔ’i’tɨ ə, mannajɨ lə’i in kɨ rɔta’tɨ el.» ");
INSERT INTO gqr_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ə Jeju ilə’de’tɨ ene: «Re m’inɓe m’man najɨ dɔ rɔ’m’tɨ kaa m’gər kadɨ mannajɨ lə’m in ta kɨ rɔta’tɨ, tadɔ m’in m’gər lo kɨ m’in’tɨ num, m’gər lo kɨ m’njɨ m’aw’tɨ num, nan ingɨ, gəri lo kɨ m’in’tɨ el num, in gəri lo kɨ m’njɨ m’aw’tɨ el num tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ingɨ isɨ gangi ta kigo lo koo’tɨ lə de, nan m’in m’gangɨ ta dɔ de’tɨ el. ");
INSERT INTO gqr_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","A kin ə re m’gangɨ ta non ə, in ta kɨ gangɨ kɨ gorow’ə’tɨ, tadɔ m’in kɨ kar’m ə m’gangɨ ta el, Bai kɨ njekulə’m in sə’m nan’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ningə me ndukun’tɨ lə’se inɓe kaa ndangi eyina: “Kin ə re de’gɨ joo manyinajɨ, ə mannajɨ lə’de aw go nan’tɨ ə, ta lə’de in ta kɨ rɔta’tɨ.” ");
INSERT INTO gqr_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","M’inɓe m’man najɨ dɔ rɔ’m’tɨ, ningə Bai kɨ ulə’m kaa mannajɨ lə’ne dɔ’m’tɨ tɔ.» ");
INSERT INTO gqr_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ningə dəji’ə eyina: «Baw’i in lo kɨ ra’tɨ dana wa?» Ə Jeju ilə’de’tɨ ene: «In gəri m’in el, taa in gəri Bai el tɔ. Kin ə re in gəri m’in ə re a in gəri Bai tɔ.» ");
INSERT INTO gqr_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ta’gɨ kin te ta Jeju’tɨ lokɨ isɨ ndo’n de’gɨ nya natɨ Kəy’tɨ lə Luwə. Isɨ lo’tɨ kɨ nya’gɨ kɨ de’gɨ isɨ iləi kadikare’tɨ adi Luwə’tɨ. Nga ningə de uwə el, tadɔ ndɔ li’ə asɨ el ɓay. ");
INSERT INTO gqr_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jeju el’de ta kɨ rangɨ ɓay ene: «M’a m’aw, ningə a sangi m’in, nan a oyi me majel’gɨ’tɨ lə’se. Lo kɨ m’a m’aw’tɨ kin a asi kadɨ a awi’tɨ el.» ");
INSERT INTO gqr_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Lo kin’tɨ, Juwipɨ’gɨ elinan eyina: «A tɔl rɔ’ne ə ra bann ə el ene: “Lo kɨ m’a m’aw’tɨ kin a asi kadɨ a awi’tɨ el wa?”» ");
INSERT INTO gqr_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ə Jeju el’de ene: «In, in de’gɨ kɨ dɔnangɨ’tɨ ne, ə m’in, m’in de kɨ dɔran’tɨ taa nu tɔ; in de’gɨ lə dɔnangɨ, nan m’in, m’in de lə dɔnangɨ el. ");
INSERT INTO gqr_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ningə in tadɔ kin ə m’el’n kete m’ene: “A oyi me majel’gɨ’tɨ lə’se.” Kin ə re uni me’se adi’m’in tokɨ in m’in “Nje kisi non” el ə, a oyi me majel’gɨ’tɨ lə’se.» ");
INSERT INTO gqr_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ə dəji’ə eyina: «In ɓe kam in nan wa?» Ningə Jeju ilə’de’tɨ ene: «M’in de kɨ m’el’se lo kulə ngirə’tɨ nu inɓe kin. ");
INSERT INTO gqr_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nga ningə, kɨ ɔjɨ dɔ’se, m’aw kɨ ta ngayn kadɨ m’el ge, m’gangɨ ge; nan ta kɨ m’ingə rɔ nje kulə’m’tɨ kin par ə m’a m’iləmbər’ə rɔ de’gɨ’tɨ kɨ dɔnangɨ’tɨ ne. Ningə ta li’ə in ta kɨ rɔta’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Jeju isɨ el’de ta kɨ dɔ Baw’ne Luwə’tɨ nan ingɨ gəri me ta kin el. ");
INSERT INTO gqr_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ə Jeju el’de ene: «Ndɔ kɨ a ɓəri m’in Ngonn de taa kagidəsɨ’tɨ kin ə, a gəri kadɨ m’in “Nje kisi non”; taa a gəri kadɨ m’ra nya madɨ dɔ rɔ’m el tɔ, nan in nya kɨ Bai ndo’m ə m’njɨ m’el. ");
INSERT INTO gqr_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Nje kulə’m in sə’m nan’tɨ; inyə’m kɨ kar’m el, tadɔ dɔkagilo’gɨ pətɨ m’ra nya kɨ nəl’ə.» ");
INSERT INTO gqr_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Lokɨ Jeju elta kin be, de’gɨ ngayn uni me’de adi’ə. ");
INSERT INTO gqr_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Jeju el Juwipɨ’gɨ kɨ uni me’de adi’ə ene: «Kin ə re rai dɔ nja’se’tɨ me ta’tɨ lə’m ə, in njendo’gɨ lə’m kɨ rɔta’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","A gəri nya kɨ rɔta’tɨ, ningə nya kɨ rɔta’tɨ kin a taa’se ji ɓər’tɨ ilə’se taa inɓe.» ");
INSERT INTO gqr_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ə ingɨ eli Jeju eyina: «J’in ngann kaw *Abiraham, ningə jɨ ra ɓər lə de ndɔ kare el tɔ, nga ra bann be ə in el ene nya kɨ rɔta’tɨ a taa’je ji ɓər’tɨ ilə’je taa wa?» ");
INSERT INTO gqr_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ə Jeju ilə’de’tɨ ene: «Tokɨ rɔta’tɨ, adɨ m’el’se: de kɨ ra kɨ ra majel, in ɓər lə majel. ");
INSERT INTO gqr_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ɓər a isɨ kɨ de’gɨ kɨ isɨ ra ɓər lə’de kin bitɨ kɨ non’tɨ el, nan ngonn kojɨ’de a isɨ se’de bitɨ kɨ non’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Adɨ re Ngonn lə Luwə taa’se ji ɓər’tɨ ilə’se taa ə, a in de’gɨ kɨ taa k’ilə taa kɨ rɔta’tɨ ji ɓər’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nga ningə, m’gər kadɨ in ngann kaw Abiraham; nan isɨ sangi kadɨ tɔli m’in tadɔ mbəti ta lə’m. ");
INSERT INTO gqr_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","M’in m’njɨ m’el nya kɨ m’oo rɔ Bai’tɨ, nan ingɨ ə, isɨ rai nya kɨ baw’se el’se tɔ.» ");
INSERT INTO gqr_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ningə iləi Jeju’tɨ eyina: «kaw’je in Abiraham.» Ə Jeju el’de ene: «Kin ə re in ngann kaw Abiraham tokɨ rɔta’tɨ ə re a rai kuləra Abiraham. ");
INSERT INTO gqr_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","M’in m’el’se nya kɨ rɔta’tɨ kɨ m’ingə rɔ Luwə’tɨ, ningə kɨ ngɔsine kin isɨ sangi kadɨ tɔli m’in. In kin in kulə kɨ Abiraham ra el jagɨ. ");
INSERT INTO gqr_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","In isɨ rai kuləra baw’se.» Ningə iləi Jeju’tɨ eyina: «J’in ngann’gɨ kɨ kojɨ ginn kaya’tɨ el; Baw’je in kareba ə in Luwə.» ");
INSERT INTO gqr_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ə Jeju el’de ene: «Kin ə re Luwə in Luwə lə’se ə re a in ndigɨ m’in, tadɔ m’te rɔ’a’tɨ ə m’re lo kin’tɨ. In m’inɓe ə m’re kɨ dɔ’m el, nan in in ə ulə’m. ");
INSERT INTO gqr_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Tadɔ ri ə in gəri me ta lə’m el wa? In gəri el tadɔ asi kadɨ uri mbi’se go ta’tɨ lə’m el. ");
INSERT INTO gqr_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Su ə in baw’se, ningə in ndigɨ kadɨ rai ndigɨ lə baw’se. In de kɨ in nje tɔl de’gɨ lo kulə ngirə kosɨ’tɨ li’ə nu. In ra me nya ra’tɨ kɨ rɔta’tɨ nja kare el, tadɔ nya kɨ rɔta’tɨ goto rɔ’a’tɨ. Kin ə re elta kɨ ngom ə, in kin ə in ta kɨ osɨ ɓo’ə’tɨ, tadɔ in nje ngom num, in baw nyara kɨ ngom num. ");
INSERT INTO gqr_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","M’in ə, m’in nje kelta kɨ rɔta’tɨ ə mbeti kun me’se kadɨ m’in. ");
INSERT INTO gqr_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Nan dann’se’tɨ ə asɨ kadɨ tɔjɨ tokɨ m’ra majel wa? A kin ə re m’elta kɨ rɔta’tɨ ə, ra bann ə kadɨ uni me’se adi’m’in el wa? ");
INSERT INTO gqr_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","De kɨ in yan Luwə, a oo ta lə Luwə, ningə ingɨ, oyi ta lə’m el, tadɔ in lə Luwə el.» ");
INSERT INTO gqr_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Lo kin’tɨ, Juwipɨ’gɨ eli Jeju eyina: «In gorow’ə’tɨ kadɨ j’eli j’ene: in de kɨ Samari’tɨ, taa ndil kɨ majel isɨ me’i’tɨ tɔ.» ");
INSERT INTO gqr_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ə Jeju el’de ene: «Jagɨ, ndil kɨ majel goto me’m’tɨ, nan nya kare kɨ m’oo ə, m’in m’ɔsɨ kurə Bai, ə in mbəti kɔsikurə’m tɔ par. ");
INSERT INTO gqr_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","M’in m’njɨ m’sangɨ kadɨ de’gɨ uləi tɔjɨ dɔ’m’tɨ el. De kɨ isɨ sangɨ kadɨ de’gɨ uləi tɔjɨ dɔ’m’tɨ in non, in ə a gangɨ ta kin taa. ");
INSERT INTO gqr_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ningə tokɨ rɔta’tɨ, adɨ m’el’se, de kɨ təl rɔ’ne go ta’tɨ lə’m ə, de’ə kin a oy el ratata.» ");
INSERT INTO gqr_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Lo kin’tɨ non, Juwipɨ’gɨ eli’ə eyina: «Kɨ ne kin, jɨ gər majɨ nga tokɨ ndil kɨ majel isɨ me’i’tɨ. Abiraham oy, taa de’gɨ kɨ njekeltakita Luwə’tɨ kaa oyi tɔ, ningə in el ene: “De kɨ təl rɔ’ne go ta’tɨ lə’i ə, de’ə kin a oy el ratata.” ");
INSERT INTO gqr_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","In utə kaw’je Abiraham kɨ oy kin wa? Taa njekeltakita Luwə’tɨ kaa oyi tɔ! In oo rɔ’i kadɨ in nan wa?» ");
INSERT INTO gqr_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ningə Jeju ilə’de’tɨ ene: «Kin ə re m’tɔjɨ rɔ’m m’inɓe ningə, in tɔjɨ kɨ nda’a goto. Nga ningə, de kɨ njekulə tɔjɨ dɔ’m’tɨ in Bai. In kɨ isɨ elita li’ə eyina in Luwə lə’se, ");
INSERT INTO gqr_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","nan gəri’ə el. M’in m’gər’ə. Kin ə re m’el m’ene m’gər’ə el ə, re m’a m’in nje ngom to ingɨ be tɔ. Nan m’in m’gər’ə, taa m’təl rɔ’m go ta’tɨ li’ə tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Kaw’se Abiraham ra rɔnel ngayn tadɔ ində me’ne’tɨ kadɨ n’a n’oo ndɔ kɨ m’a m’re’n. Nga ningə oo ndɔ re’m, adɨ rɔ’a nəl’ə ngayn.» ");
INSERT INTO gqr_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Lo kin’tɨ, Juwipɨ’gɨ dəji Jeju eyina: «In ra ɓal dɔ mi el ɓay ə kum’i oo Abiraham wa?» ");
INSERT INTO gqr_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ə Jeju ilə’de’tɨ ene: «Tokɨ rɔta’tɨ, adɨ m’el’se, kete non kojɨ Abiraham’tɨ, “M’in m’njɨ non”.» ");
INSERT INTO gqr_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Lo kin’tɨ non be, kəri mbal kadɨ n’tiləi Jeju, nan ur dann bulə de’gɨ, ə te ginn Kəy’tɨ lə Luwə kɔ, aw. ");
INSERT INTO gqr_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Lokɨ Jeju isɨ ində dər ningə, oo de kɨ kum’ə tɔ lo koj’o’tɨ nu isɨ. ");
INSERT INTO gqr_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Njendo’gɨ li’ə dəji’ə eyina: «Njendo de’gɨ, dingəm kɨ kum’ə tɔ lo koj’o’tɨ nu kin, kum’ə tɔ ɔjɨ’n dɔ majel li’ə inɓe eke, ɔjɨ’n dɔ majel lə njekoj’o’gɨ wa?» ");
INSERT INTO gqr_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ə Jeju el’de ene: «In ta lə majel li’ə el num, in ta lə majel lə njekoj’o’gɨ el num, nan kum’ə tɔ be kadɨ Luwə ɔjɨ’n tɔgɨ’ne taga kadɨ de’gɨ gəri. ");
INSERT INTO gqr_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Dɔkagilo kɨ kadɨ to ɓay, majɨ kadɨ jɨ rai kulə lə de kɨ njekulə’m, tadɔ lo a ndul ə, lo kadɨ de a ra kulə goto. ");
INSERT INTO gqr_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Tokɨ m’in’n dɔnangɨ’tɨ ne ɓay, m’in kunjɨ kɨ dɔnangɨ’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Lokɨ Jeju el ta’gɨ kin be ə, go’tɨ, tuw mann ta’ne nanga, lɔy’n nangɨ, ɔr gidɨ kum nje kumtɔ’tɨ kakin. ");
INSERT INTO gqr_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ningə, el njekumtɔ ene: «Aw togɨ kum’i lo ndogɨ mann’tɨ kɨ Silowe.» «Silowe» kɔr me’ə nan «njekawkulə». Be ə, njekumtɔ aw togɨ kum’ne low’ə’tɨ kakin, ə ta təl’ə, kum’ə oo lo majɨ. ");
INSERT INTO gqr_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Nje gədɨ kəy’gɨ li’ə, kɨ nje’gɨ kɨ kete isɨ oyi’ə lo kɔy nya’tɨ, eli eyina: «M’a, in kam in de kɨ nje kisi nanga, kɔy nya kakin el wa?» ");
INSERT INTO gqr_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ningə nje kɨ nan’gɨ eli eyina: «In darɔ’a inɓe.» Ə nje kɨ nungɨ eli eyina: «Jagɨ in in el, nan in de kɨ nje tanan si’ə.» Ningə inɓe kɨ dɔ’ne el ene: «In darɔ’m m’inɓe.» ");
INSERT INTO gqr_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Nga a dəji’ə ta eyina: «Re inɓe ə, ra bann be ə kum’i oo lo wa?» ");
INSERT INTO gqr_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ə el’de ene: «Dingəm kɨ tɔ’a nan Jeju ə lɔy nangɨ ɔr gidɨ kum’tɨ, ə el’m ene: “Aw Silowe’tɨ togɨ kum’i”, ə m’aw m’togɨ kum’m, par ə kum’m oo lo majɨ.» ");
INSERT INTO gqr_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ningə dəji’ə eyina: «Dingəm kin in ra be wa?» Ə el’de ene: «M’gər el.» ");
INSERT INTO gqr_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Lo kin’tɨ, ɔri dingəm kɨ kete kum’ə tɔ kakin awi si’ə rɔ Parisɨ’gɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ningə, ndɔ’a’tɨ kɨ Jeju lɔy’n nangɨ kɨ mann ta’ne ɔr gidɨ kum’ə’tɨ adɨ kum’ə oo lo kakin in ndɔ kɔrkon. ");
INSERT INTO gqr_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ə Parisɨ’gɨ dəji’ə ta kɨ yan’de dangɨ ɓay ke ra bann ə n’oo’n lo wa? Ə el’de ene: «Jeju ɔr nangɨ kɨ lɔy kum’m’tɨ, ə m’aw m’togɨ kum’m, ə ngɔsine kum’m oo lo.» ");
INSERT INTO gqr_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Lo kin’tɨ, Parisɨ’gɨ kɨ madɨ eli eyina: «De kɨ ra nya kin in de kɨ in rɔ Luwə’tɨ el, tadɔ ində kum’ne go ndɔ kɔrkon’tɨ el.» Nan nje kɨ nungɨ eli eyina: «Nga ra bann be ə, de kɨ njeramajel par a aw kɨ tɔgɨ kadɨ ra’n nyakɔjɨ’gɨ kɨ ətɨ ɓol be kin wa?» Be ə, ta kin re kɨ gangɨ nan dann’de’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ningə təli dəji njekumtɔ kakin ɓay eyina: «Nga inɓe kɨ dɔ’i, ta ri ə el dɔ de’tɨ kɨ te kum’i adɨ kum’i oo lo kin wa?» Ə njekumtɔ el ene: «In njekeltakita Luwə’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Juwipɨ’gɨ mbeti kun me’de kadɨ tokɨ in de kɨ kete kum’ə tɔ, ə ngɔsine de te kum’ə adɨ kum’ə oo lo. Rai bitɨ uni njekoj’o’gɨ rei. ");
INSERT INTO gqr_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ə dəji’de ta eyina: «De kam in ngonn’se inɓe tokɨ rɔta’tɨ wa? A re in ngonn’se inɓe ə, kum’ə tɔ lo koj’o’tɨ inɓe wa? A re kum’ə tɔ lo koj’o’tɨ ə, ra bann be ə ngɔsine kum’ə oo lo wa?» ");
INSERT INTO gqr_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ə njekoj’o’gɨ eli eyina: «Jɨ gər majɨ kadɨ in ngonn’je inɓe, taa kum’ə tɔ lo koj’o’tɨ nu tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Nan kɨ ɔjidɔ kum’ə kɨ ngɔsine oo lo, eke nan ə te kum’ə adɨ kum’ə oo lo inɓe kin ə, jɨ gər nya kare me’tɨ el. Ningə inɓe tɔgɨ gangɨ ənn ə dəji’ə, ə a elta kɨ dɔ rɔ’ne’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Nje koj’o’gɨ elita kin be tadɔ ɓol kɨ ɓoli Juwipɨ’gɨ. Tadɔ Juwipɨ’gɨ dɔ’i tanan’tɨ kadɨ to de kɨ re el ene Jeju in Kirisitɨ De kɨ Luwə mbət’ə ə, sɔw tuwə ginn kəykawnan’tɨ lə Juwipɨ’gɨ kɔ. ");
INSERT INTO gqr_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","In tadɔ kin ə, njekoj’o’gɨ eli eyina: «Inɓe tɔgɨ gangɨ ənn ə, dəji’ə.» ");
INSERT INTO gqr_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ə Parisɨ’gɨ ɓari de kɨ kete kum’ə tɔ kakin adi’ə re kɨ nja joo, ningə eli’ə eyina: «Elta kɨ rɔta’tɨ, ɔsɨ’n kurə Luwə. Jɨ gər kadɨ dingəm kin in njeramajel.» ");
INSERT INTO gqr_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Lo kin’tɨ, dingəm kɨ kete kum’ə tɔ kakin el’de ene: «In njeramajɨ, kin ə in njeramajel inɓe kaa m’gər nya kare me’tɨ el, nya kare kɨ m’gər majɨ ənn: kete kum’m tɔ, ningə ngɔsine kum’m oo lo.» ");
INSERT INTO gqr_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ningə təli eli’ə eyina: «In ri ə ra sə’i wa? Ə ra bann tɔ ə adɨ kum’i oo lo wa?» ");
INSERT INTO gqr_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Lo kin’tɨ el’de ene: «Ta kin m’el’se kete nga, ə in mbeti koo ta lə’m, ə ra bann ə in gei kadɨ m’təl m’el’se ɓay wa? In ndigɨ kadɨ təli njendo’gɨ li’ə tɔ wa?» ");
INSERT INTO gqr_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Lokɨ el Parisɨ’gɨ ta be ə, ingɨ taji’ə ə eli’ə eyina: «In ə in njendo li’ə, nan j’in, j’in njendo’gɨ lə Mojɨ. ");
INSERT INTO gqr_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Jɨ gər kadɨ Luwə elta kɨ Mojɨ, nan de lə’i kin, jɨ gər lo kɨ te’tɨ el.» ");
INSERT INTO gqr_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ə dingəm kakin el Parisɨ’gɨ ene: «In nya kɨ ətɨ ɓol ngayn kadɨ de kɨ rɔta’tɨ, ingɨ gəri lo kɨ te’tɨ el tɔ, ə de’ə kakin taa adɨ kum’m oo lo. ");
INSERT INTO gqr_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Jɨ gər majɨ kadɨ de’gɨ kɨ njeramajel, re elita kɨ Luwə ə, Luwə oo dɔ ta lə’de el, nan de kɨ nje ɓol Luwə, kɨ nje təl rɔ’ne go ndu’ə’tɨ, Luwə oo dɔ ta li’ə. ");
INSERT INTO gqr_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Kɨ mayinu inɓe kin, ndɔ kare kadɨ j’oo nan de madɨ ə adɨ kum’de kɨ tɔ lo koj’o’tɨ nu oo lo be kin, m’oo el ɓay. ");
INSERT INTO gqr_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Kin ə re dingəm kin in rɔ Luwə’tɨ el ə, nya madɨ kare kɨ asɨ kadɨ ra goto.» ");
INSERT INTO gqr_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Lo kin’tɨ, eli’ə eyina: «In de kɨ ra me majel’tɨ lo koj’o’tɨ nu kam ə, ge kadɨ in ə ndo’je nya!» Ningə tuwəi’ə adɨ te taga. ");
INSERT INTO gqr_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jeju oo kadɨ tuwəi’ə, ə lokɨ ingə, dəj’ə ene: «In un me’i adɨ Ngonn de wa?» ");
INSERT INTO gqr_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ə el Jeju ene: «Burəɓe, Ngonn de ə in nan wa el’m adɨ to m’un me’m m’ad’a wa?» ");
INSERT INTO gqr_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ningə Jeju el’ə ene: «In oo’ə kɨ kum’i, in darɔ’a inɓe ə isɨ elita kin.» ");
INSERT INTO gqr_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Be ə, dingəm kakin el Jeju ene: «Burəɓe, m’un me’m m’ad’i.» Ningə ɔsi məkəsi’ne nanga non’a’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jeju el’ə ene: «M’re dɔnangɨ’tɨ ne tadɔ gangɨ ta, m’re kadɨ de’gɨ kɨ kum’de tɔ, oyi lo, ə kadɨ nje kɨ kum’de oo lo, təli njekumtɔ’gɨ tɔ.» ");
INSERT INTO gqr_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Lokɨ Parisɨ’gɨ madɨ kɨ rai kɨ Jeju non, oyi dɔ ta kɨ Jeju el kin ningə, dəji’ə eyina: «J’in kaa j’in njekumtɔ’gɨ tɔ wa?» ");
INSERT INTO gqr_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ə Jeju ilə’de’tɨ ene: «Kin ə re in njekumtɔ’gɨ tokɨ rɔta’tɨ ə, re majel lə’se a goto, nan tokɨ j’isi’n, ə oyi rɔ’se kadɨ kum’se oo lo kin ə, majel lə’se to tor’ne’tɨ ba.» ");
INSERT INTO gqr_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jeju el ene: «Tokɨ rɔta’tɨ adɨ m’el’se. Kin ə re de madɨ ur go batɨ’gɨ’tɨ kɨ takəy el, nan in bal kɨ dɔ bɔr kɨ row kɨ rangɨ ə, de’ə kin in njeɓogɨ, in baw kaya. ");
INSERT INTO gqr_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Nan de kɨ ur kəy go batɨ’gɨ’tɨ kɨ takəy, in ə njekul batɨ’gɨ. ");
INSERT INTO gqr_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Nje ngəm takəy batɨ’gɨ te takəy ad’a, ə batɨ’gɨ oyi dɔ ndu’ə. Ningə ɓar batɨ’gɨ lə’ne kare kare kɨ tɔ’de, te se’de taga. ");
INSERT INTO gqr_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Lokɨ te kɨ batɨ’gɨ lə’ne pətɨ taga ningə, ɔtɨ njiyə non’de’tɨ, ə batɨ’gɨ uni go’ə, tadɔ gəri ndu’ə. ");
INSERT INTO gqr_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Batɨ’gɨ a uni go de kɨ rangɨ el. Re oyi de kɨ rangɨ ə, a anyinan sanyi kɔ kad’a’tɨ, tadɔ gəri ndu de’gɨ kɨ rangɨ el.» ");
INSERT INTO gqr_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jeju el’de kujita kin, nan gəri nya kɨ el’de ta dɔ’tɨ kin el. ");
INSERT INTO gqr_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ə Jeju təl el’de ɓay ene: «Tokɨ rɔta’tɨ, adɨ m’el’se, m’in takəy batɨ’gɨ. ");
INSERT INTO gqr_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","De’gɨ pətɨ kɨ rei rɔ’m’tɨ, in njeɓogɨ’gɨ, kɨ baw kaya’gɨ, adɨ batɨ’gɨ oyi ta lə’de el. ");
INSERT INTO gqr_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","M’in takəy, re de ur kəy kɨ row kɨ rɔ’m’tɨ ə, de’ə a ingə kajɨ. A ur kəy num, a te num, taa a ingə nyakusɔ’ne num tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Njeɓogɨ re ə, re tadɔ ɓogɨ, re tadɔ tɔl nya, ə re tadɔ tujɨ nya tɔ par. Nan m’in, m’re kadɨ de’gɨ ingəi kajɨ. Ningə kadɨ in kajɨ kɨ to mbar mbar. ");
INSERT INTO gqr_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","«M’in nje njekul batɨ’gɨ kɨ majɨ. De kɨ njekul batɨ’gɨ kɨ majɨ, adɨ rɔ’ne tadɔ batɨ’gɨ lə’ne. ");
INSERT INTO gqr_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Nan de kɨ in njekul batɨ’gɨ tadɔ kingə nar par um in ɓe’de el, lokɨ oo jagum isɨ re kɨ dɔ batɨ’gɨ’tɨ, inyə batɨ’gɨ ə anyi, adɨ jagum re uwə’de ge, sanan’de ge. ");
INSERT INTO gqr_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Njekul batɨ’gɨ tadɔ kingə’n nar kin anyi, tadɔ nya li’ə in nar par ə isɨ sangɨ, adɨ oo lo kadɨ ində rɔ’ne kon’tɨ tadɔ lə batɨ’gɨ el. ");
INSERT INTO gqr_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","M’in, m’in njekul batɨ’gɨ kɨ majɨ. M’gər batɨ’gɨ lə’m, ə batɨ’gɨ lə’m gəri m’in tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Gəri m’in tokɨ Bai gərɨ’m ə m’in m’gər’n Bai kin be tɔ. Be ə, m’adɨ rɔ’m tadɔ batɨ’gɨ lə’m. ");
INSERT INTO gqr_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","M’aw kɨ batɨ’gɨ kɨ rangɨ non ɓay kɨ in me kəy’tɨ ne el. Ingɨ kaa, majɨ kadɨ m’re se’de me kəy’tɨ. A oyi ndu’m ə, a təli nyakul’gɨ kɨ kareba ginn nje ngəm batɨ’gɨ’tɨ kɨ kareba. ");
INSERT INTO gqr_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Bai ndigɨ’m, tadɔ m’adɨ rɔ’m kɔ kadɨ to m’təl m’ingə kingə kɨ rangɨ. ");
INSERT INTO gqr_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","De kɨ a ində tɔgɨ dɔ’m’tɨ kadɨ m’ilə rɔ’m kɔ goto. In m’inɓe ə m’adɨ kɨ me ndigɨ lə’m. M’aw kɨ tɔgɨ kadɨ m’adɨ’n num, kadɨ m’taa’n num. In kin ə in ndu kɨ m’ingə kɨ rɔ Bai’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ta lə Jeju kin təl re kɨ gangɨ nan kɨ rangɨ dann Juwipɨ’gɨ’tɨ ɓay. ");
INSERT INTO gqr_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ngayn’gɨ dann’de’tɨ eli eyina: «Ndil kɨ majel isɨ me’ə’tɨ, dɔ’a ra dana el, ə ra bann ə isɨ oyi ta li’ə wa?» ");
INSERT INTO gqr_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ə nje kɨ nungɨ eli eyina: «De kɨ ndil kɨ majel isɨ me’ə’tɨ elta be el. De kɨ ndil kɨ majel isɨ me’ə’tɨ asɨ kadɨ a te kum njekumtɔ’gɨ el.» ");
INSERT INTO gqr_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Dɔkagilo’ə’tɨ kin, Juwipɨ’gɨ isɨ rai nanyi tɔr ndu dɔ Kəy’tɨ lə Luwə Jerujalem’tɨ. In dɔ kagilo kul’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jeju ulə lo aw ge təl ge ginn tabitɨ’tɨ lə *Salomon, natɨ Kəy’tɨ lə Luwə. ");
INSERT INTO gqr_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Juwipɨ’gɨ iləi nan gugɨ gidə, ningə eli’ə eyina: «Kadɨ bann’tɨ ə a el’je ta kɨ kadɨ me’je osɨ nanga wa? Kin ə re in Kirisitɨ De kɨ Luwə mbət’ə ə, el’je wangɨ adɨ j’oo.» ");
INSERT INTO gqr_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jeju el’de ene: «Ta kin m’el’se kete nga, nan uni me’se adi ta lə’m el. Nya’gɨ kɨ m’njɨ m’ra’de me tɔ Bai’tɨ kin manyinajɨ dɔ’m’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Nan ingɨ, mbəti kunme’se kadi m’in. Mbəti tadɔ in dann batɨ’gɨ’tɨ lə’m el. ");
INSERT INTO gqr_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Batɨ’gɨ lə’m oyi ndu’m, m’gər’de, ningə ingɨ uni go’m tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","M’adɨ’de kajɨ kɨ to bitɨ kɨ non’tɨ, um nanyi kɔ el. Taa de kɨ kadɨ ində tɔgɨ’ne taa’n’de ji’m’tɨ kaa goto tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Bai kɨ nje kadɨ’m’de aw kɨ tɔgɨ dɔ de’gɨ’tɨ pətɨ, adɨ de madɨ kɨ asɨ kadɨ ində tɔgɨ taa’n’de ji Bai’tɨ goto. ");
INSERT INTO gqr_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","J’in kɨ Bai j’in kare.» ");
INSERT INTO gqr_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Lo kin’tɨ, Juwipɨ’gɨ təli tiləi’ə kɨ mbal ɓay kadɨ n’tɔli’ə. ");
INSERT INTO gqr_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ə Jeju el’de ene: «M’ra nya’gɨ kɨ majɨ majɨ ngayn takum’se’tɨ kɨ tɔgɨ kɨ in rɔ Bai’tɨ, nga in kɨ ra ə in gəi kadɨ tiləi m’in kɨ mbal tɔli m’in tadɔ’a wa?» ");
INSERT INTO gqr_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ə Juwipɨ’gɨ eli’ə eyina: «In tadɔ nya majɨ kɨ ra ə jɨ ge kadɨ jɨ tiləi kɨ mbal jɨ tɔli el, nan in tadɔ kelta kɨ mal. Tadɔ in kɨ in de kare par ə el ene n’in Luwə.» ");
INSERT INTO gqr_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jeju el’de ene: «Ndangi me ndukun’tɨ lə’se inɓe’gɨ eyina: “M’in Burəɓe m’el’se m’ene in luwə’gɨ”. ");
INSERT INTO gqr_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","De’gɨ kɨ Luwə el’de ta lə’ne ə Luwə ɓar’de luwə’gɨ kin. Ningə gəri majɨ kadɨ de ra tɔgɨ bujɨ ta lə Luwə el. ");
INSERT INTO gqr_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","M’in, Bai Luwə ində’m ta dangɨ, ulə’m dɔnangɨ’tɨ, ə m’el’n m’ene m’in Ngonn lə Luwə, ningə ingɨ eli eyina ke m’in nan ə m’el m’ene m’in Ngonn lə Luwə wa ə, m’in nje kelta kɨ mal dɔ tɔ Luwə’tɨ, kin in tadɔ ri wa? ");
INSERT INTO gqr_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Kin ə re m’ra kulə lə Bai el ningə to uni me’se adi m’in el! ");
INSERT INTO gqr_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","A kin ə re m’njɨ m’ra kulə lə Bai ningə, re uni me’se adi m’in el kaa, uni me’se adi kulə’gɨ kɨ m’ra’de kakin nden taa. Uni me’se kadɨ gəri ə oyi tokɨ Bai isɨ me’m’tɨ, ə m’in m’njɨ me Bai’tɨ tɔ.» ");
INSERT INTO gqr_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Lo kin’tɨ, sangi row nja kare ɓay kadɨ n’uwəi Jeju, nan te mbunə’de’tɨ aw. ");
INSERT INTO gqr_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Jeju təl aw gidɨ ba Jurden’tɨ, lo’tɨ kɨ kete Jan ra de’gɨ batəm’tɨ. Jeju aw isɨ low’ə’tɨ kin non. ");
INSERT INTO gqr_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","De’gɨ ngayn rei rɔ’a’tɨ, ningə elinan eyina: «Jan ra nya madɨ kare kɨ ətɨ ɓol el, nan nya’gɨ pətɨ kɨ el ɔjɨ’n dɔ dingəm kin in nya’gɨ kɨ rɔta’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Lo kin’tɨ non be de’gɨ ngayn uni me’de adi Jeju. ");
INSERT INTO gqr_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Dingəm kare kɨ njemonyi in non, tɔ’a nan Lajar. Isɨ me ɓe’tɨ kɨ Betani kɨ in ngonnɓe lə Mari in kɨ ngonnkon’ne Martɨ. ");
INSERT INTO gqr_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","In darɔ Mari inɓe kin ə a ur hu kɨ ətɨ majɨ nja Burəɓe’tɨ num, bɔr nja’a kɨ bisɨ dɔ’ne num. Nga ningə in ngonnkon’a Lajar tɔ ə rɔ’a to’ə. ");
INSERT INTO gqr_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Konnann’a’gɨ kɨ joo kin uləi de madɨ ad’a aw el Jeju ene: «Burəɓe, njendigɨ lə’i basa mad’i in monyi.» ");
INSERT INTO gqr_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Lokɨ Jeju oo ta kin ningə el ene: «Monyi lə Lajar kin a tɔl’ɔ el, nan in monyi kɨ re kadɨ tɔjɨ tɔgɨ Luwə, taa kadɨ de’gɨ uləi tɔjɨ dɔ’m’tɨ m’in Ngonn lə Luwə tɔ.» ");
INSERT INTO gqr_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jeju ndigɨ Martɨ in kɨ ngonnkon’a kɨ dene Mari, taa ndigɨ Lajar tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Jeju oo majɨ kadɨ Lajar in monyi, be kaa isɨ lo’tɨ kɨ sɨ’tɨ kin ba ndɔ joo ɓay. ");
INSERT INTO gqr_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Go’tɨ, el njendo’gɨ lə’ne ene: «Adɨ jɨ təli j’awi Jude’tɨ gogɨ.» ");
INSERT INTO gqr_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ə Njendo’gɨ li’ə eli’ə eyina: «Njendo de’gɨ, ndɔ ngayn el ne ɓay ə Juwipɨ’gɨ sangi kadɨ n’tiləi’nu kɨ mbal n’tɔli’nu kakin ə, ge kadɨ təl aw Jude’tɨ ɓay wa?» ");
INSERT INTO gqr_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jeju ilə’de’tɨ ene: «Ngann kadɨ in dɔgɨ gidə in joo me ndɔ’tɨ kɨ kare el wa? Ningə kin ə re de njiyə kada ə a osɨ el, tadɔ oo lo majɨ. ");
INSERT INTO gqr_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","A re njiyə kondɔ ə a osɨ, tadɔ oo lo majɨ el.» ");
INSERT INTO gqr_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Go ta’tɨ kin, Jeju ilə ta kɨ rangɨ dɔ’tɨ ene: «Madɨ’je Lajar to ɓi, ningə m’a m’aw kadɨ m’ndəl’ə.» ");
INSERT INTO gqr_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ə njendo’gɨ eli’ə eyina: «Burəɓe, re in ɓi ə to ə a ndəl ɓay.» ");
INSERT INTO gqr_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jeju elta lə koy Lajar, nan njendo’gɨ oyi tokɨ in ta lə ɓi kɨ kare. ");
INSERT INTO gqr_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ə Jeju el’de ar njay ene: «Lajar oy. ");
INSERT INTO gqr_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Nga ningə kɨ ɔjɨ dɔ’se, rɔ’m nəl’m ngayn kadɨ m’goto low’ə’tɨ, kadɨ to ingɨ uni me’se adi’m’in. Ningə kɨ ne kin, adɨ j’awi dɔ’a’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ə Tomasɨ kɨ isɨ ɓari’ə «Ndungə» el ndəgɨ njendo’gɨ ene: «J’in kaa adɨ j’awi si’ə to j’oyi si’ə.» ");
INSERT INTO gqr_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Lokɨ Jeju re te Betani’tɨ, oo kadɨ duwi Lajar ra ndɔ sɔ nga. ");
INSERT INTO gqr_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani in ndəkba kɨ Jerujalem, asɨ kulə metər mutə be par, ");
INSERT INTO gqr_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","adɨ Juwipɨ’gɨ ngayn rei rɔ Martɨ’tɨ in kɨ Mari kadɨ sɔli me’de ɔjɨ’n dɔ koy lə ngonnkon’de. ");
INSERT INTO gqr_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Lokɨ Martɨ oo kadɨ Jeju a re non, in aw tilə kum’ə, ningə Mari taa isɨ yan’ne nanga me kəy’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Martɨ kɨ aw tilə kum Jeju, el Jeju ene: «Burəɓe, kin ə re in se’je ne ə re ngonnkon’m a oy el. ");
INSERT INTO gqr_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Nan kɨ ne inɓe kin kaa m’gər kadɨ nya’gɨ pətɨ kɨ dəjɨ Luwə ə a adi.» ");
INSERT INTO gqr_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ə Jeju el’ə ene: «Ngonnkon’i a ində lo koy’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ningə Martɨ il’ə’tɨ ene: «In kɨ rɔta’tɨ, m’gər kadɨ ndɔ kɨ njekoy’gɨ a indəi taa lo koy’tɨ dɔboy ndɔ’tɨ ə, Lajar a ində taa lo koy’tɨ tɔ.» ");
INSERT INTO gqr_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Lo kin’tɨ, Jeju el’ə ene: «M’in nje kadɨ de’gɨ indəi taa lo koy’tɨ, kɨ nje kadɨ de’gɨ sii kɨ dɔ’de taa. De kɨ un me’ne, re oy mindɨ kaa, a təl isɨ kɨ dɔ’ne taa. ");
INSERT INTO gqr_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Nga ningə, de kɨ isɨ kɨ dɔ’ne taa, ə un me’ne ə, de’ə kin a oy el ratata. M’dəj’i ke un me’i dɔ ta’tɨ kin wa?» ");
INSERT INTO gqr_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ningə Martɨ il’ə’tɨ ene: «Oyo, Burəɓe, m’un me’m m’ad’i tokɨ in ə in Kirisitɨ, De kɨ Luwə mbət’ə, in ə in Ngonn lə Luwə, in ə in de kɨ majɨ kadɨ a re dɔnangɨ’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Go ta’tɨ kɨ Martɨ el kin ə, ɔtɨ aw ɓar ngonnkon’ne kɨ dene Mari, el’ə ta nanga yɔgirɔ be ene: «Njendo de’gɨ ra non, ə isɨ dəj’i kadɨ aw.» ");
INSERT INTO gqr_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Lokɨ Mari oo ta kin taa par ə ində taa kalangɨ aw kɨ rɔ Jeju’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jeju ur me ɓe’tɨ el ɓay, in lo’tɨ inɓe kɨ Martɨ aw ingə’tɨ kete kakin ɓay. ");
INSERT INTO gqr_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Juwipɨ’gɨ kɨ sii me kəy’tɨ kɨ Mari, isɨ sɔli me’ə, lokɨ oyi’ə ində taa kalangɨ, te taga, oyi ene isɨ aw kɨ dɔɓadɨ’tɨ kadɨ non wa, adɨ indəi taa awi go’ə’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Lokɨ Mari aw te lo’tɨ kɨ Jeju ra’tɨ, ə oo Jeju ə, osɨ nanga nja’a’tɨ, ningə el’ə ene: «Burəɓe, kin ə re in se’je ne ə re ngonnkon’m a oy el.» ");
INSERT INTO gqr_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Lokɨ Jeju oo kadɨ Mari isɨ non, taa Juwipɨ’gɨ kɨ in go’ə’tɨ kaa isɨ nonyi tɔ ningə, me’ə ur mad’a, taa ndil’ə isɨ nanga el tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ə dəjɨ’de ene: «Iləi’ə ra be wa?» Ningə eli’ə eyina: «Burəɓe, re ə oo.» ");
INSERT INTO gqr_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Lo kin’tɨ, Jeju non. ");
INSERT INTO gqr_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ə Juwipɨ’gɨ eli eyina: «Oyi tɔjɨ kɨ tɔjɨ ndigɨ kɨ ndig’ə kin.» ");
INSERT INTO gqr_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Nan nje kɨ nungɨ eli eyina: «Te kum njekumtɔ, nga ra bann ə asɨ kadɨ ɔgɨ Lajar koy el tɔ wa?» ");
INSERT INTO gqr_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Lo kin’tɨ, me Jeju təl ur mad’a kur kɨ rangɨ ɓay, adɨ ɔtɨ aw kɨ dɔɓadɨ’tɨ. Ningə in bolo mbal ə indəi mbal mad’a uti ta’a. ");
INSERT INTO gqr_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jeju el’de ene: «Ɔri mbal kin kɔ», nan Martɨ kɨ konnann nje goto el Jeju ene: «Burəɓe, ra ndɔ sɔ nga, adɨ a ətɨ.» ");
INSERT INTO gqr_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ə Jeju el’ə ene: «M’el’i m’ene ri wa? M’el’i m’ene re un me’i ə a oo tɔjɨ lə Luwə.» ");
INSERT INTO gqr_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Lo kin’tɨ, ɔri mbal kɔ, ə Jeju un kum’ne kɨ taa ningə el ene: «Bai, m’ra’i oyo tokɨ oo dɔ ndu’m. ");
INSERT INTO gqr_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","M’gər kadɨ ta’gɨ kɨ m’njɨ m’el’i kin oo dɔ ndu’m dɔrɔ, nan m’elta kin be tadɔ bulə de’gɨ kɨ gugi gidɨ’m kin, kadɨ uni me’de adi m’in tokɨ in in ə ulə’m.» ");
INSERT INTO gqr_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Go ta’tɨ kin ə, Jeju un ndu’ne kɨ taa elta kɨ tɔgɨ’ne ene: «Lajar, te taga!» ");
INSERT INTO gqr_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ningə nje goto Lajar ində lo te taga. Ji’ə’gɨ kɨ nja’a’gɨ in kɨ ra’gɨ kɨ ta ku, taa takum’ə in kɨ dolo kɨ ku tɔ. Ə Jeju el’de ene: «Tuti’ə, ə inyəi’ə adɨ aw.» ");
INSERT INTO gqr_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Juwipɨ’gɨ ngayn kɨ rai rɔ Mari’tɨ, ə oyi nya kɨ Jeju ra, uni me’de adi Jeju. ");
INSERT INTO gqr_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Nan nje kɨ nan’gɨ awi ingəi Parisɨ’gɨ, eli’de nya kɨ Jeju ra. ");
INSERT INTO gqr_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Lo kin’tɨ, kibo’gɨ lə njekujənyamosɨ kadikare’gɨ kɨ Parisɨ’gɨ, ɔsi dɔ nje gangɨ ta’gɨ lə Juwipɨ’gɨ nan’tɨ, ningə dəji nan eyina: «In ri dana ə kadɨ jɨ rai wa? Dingəm kin ra nyakɔjɨ’gɨ ngayn! ");
INSERT INTO gqr_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Kin ə re j’inyəi’ə adɨ ra nya’gɨ lə’ne kin kɨ non’ne’tɨ ə, de’gɨ pətɨ a uni me’de adi’ə, ningə de’gɨ kɨ Rɔm’tɨ a rei kadɨ tuji Kəy lə Luwə, taa a tuji ginn ɓe lə’je tɔ!» ");
INSERT INTO gqr_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ə Kayipɨ kɨ in kɨ kare dann nje kundɔ Juwipɨ’gɨ’tɨ, kɨ ɓal’a’tɨ non in kibo lə njekujənyamosɨ kadikare’gɨ, un ta el’de ene: «In gəri nya kare me nya’tɨ kɨ isɨ ra nya kin el! ");
INSERT INTO gqr_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","In mərita majɨ oyi! In sotɨ ngayn tadɔ lə’se kadɨ ba kal de kare oy tadɔ lə ginn de’gɨ banyi banyi, ə ginn ɓe kɨ ta’a ba ingə tujɨ el.» ");
INSERT INTO gqr_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Nga ningə in ta kɨ Kayipɨ inɓe ə el kɨ dɔ’ne el, nan tokɨ ɓal’a’tɨ non in kibo lə njekujənyamosɨ kadikare’gɨ, Luwə ində taa ta’a’tɨ adɨ iləmbər’ə kete tokɨ majɨ kadɨ Jeju a oy tadɔ lə ginn ɓe lə Juwipɨ’gɨ. ");
INSERT INTO gqr_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ningə a oy tadɔ lə ginn ɓe lə Juwipɨ’gɨ par el, nan a oy kadɨ kaw’n ngann’gɨ lə Luwə kɨ sananyinan kɨ lo’gɨ dangɨ dangɨ kin kadɨ təli ginn de’gɨ kɨ kareba. ");
INSERT INTO gqr_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","In dɔ ndɔ’a’tɨ non kin, njekundɔ Juwipɨ’gɨ uni ndu’de kadɨ n’tɔli Jeju. ");
INSERT INTO gqr_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","In be ə, Jeju ində ngangɨ njiyə taga takum Juwipɨ’gɨ’tɨ. Ɔr rɔ’ne aw ndəkba kadɨ diləlo’tɨ, me ngonn ɓe’tɨ kɨ ɓari’ə Epirayim. Aw sɨ’tɨ non kɨ njendo’gɨ lə’ne. ");
INSERT INTO gqr_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Dɔkagilo ra nanyi lə Juwipɨ’gɨ kɨ ɓari’ə Pakɨ in ndəkba, adɨ de’gɨ ngayn awi Jerujalem’tɨ kete non’tɨ kadɨ to rai nya’gɨ kigo kujɨ’ə’tɨ lə’de in Juwipɨ’gɨ kadɨ ari rɔ’de non Luwə’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","De’gɨ kakin in ginn Kəy’tɨ lə Luwə, ningə isɨ sangi Jeju, ə dəji nan ta dann’de’tɨ eyina: «Mərta lə’se in ri wa? Kadɨ a re lo ra nanyi’tɨ el wa?» ");
INSERT INTO gqr_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Nya kare ə, kibo’gɨ lə njekujənyamosɨ kadikare’gɨ kɨ Parisɨ’gɨ uni ndu kadɨ re de madɨ oo lo kɨ Jeju in’tɨ ə, kadɨ el’de adɨ n’awi n’uwəi’ə. ");
INSERT INTO gqr_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ndɔ mehen kete non ra nanyi Pakɨ’tɨ, Jeju aw Betani’tɨ kɨ Lajar sɨ’tɨ. Lajar kɨ ndɔkɨ ad’a ində taa lo koy’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Lo kin’tɨ non, rai nyakusɔ kɨ tɔ Jeju. Martɨ ə in nje kadɨ’de nyakusɔ, ningə Lajar in kɨ kare dann nje kisi ta nyakusɔ kɨ Jeju. ");
INSERT INTO gqr_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mari un hu kɨ rai kɨ mann kagɨ kɨ ɓari’ə «nar», a rosɨ ngonn ku be, ur nja Jeju’tɨ, ningə go’tɨ, bɔr nja’a kɨ bisɨ dɔ’ne. In hu «nar» dɔrɔ’a kɨ gat’a in ngayn. Banyi’a taa me kəy. ");
INSERT INTO gqr_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Lo kin’tɨ, Judasɨ Isikariyotɨ kɨ in kɨ kare dann njendo’gɨ’tɨ lə Jeju, in kɨ a un dɔ Jeju, el ene: ");
INSERT INTO gqr_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","«Tadɔ ri ə in kɨ law hu kin ndogɨ, taa’n nar kɨ lo kulə’tɨ kɨ ndɔ ɓu mutə be kaa in kɨ ra’n kɨ njendoo’gɨ el wa?» ");
INSERT INTO gqr_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Judasɨ elta kin be tadɔ to ə ta lə njendoo’gɨ to rɔ’a el, nan tadɔ in njeɓogɨ. In ə ɓɔl nar in ji’ə’tɨ, adɨ isɨ ɓogɨ nar kɨ isɨ ɓuki me’tɨ nden nden. ");
INSERT INTO gqr_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Nan Jeju el ene: «Inyəi Mari keke! Nga ra nya kin be nginə’n ndɔkɨ kadɨ m’a m’aw’n ɓadɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Njendoo’gɨ a in sese kɨ ndɔ’gɨ, ndɔ’gɨ, nan m’in m’a m’in sese kɨ ndɔ’gɨ, ndɔ’gɨ el.» ");
INSERT INTO gqr_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Bulə de’gɨ kɨ Juwipɨ’gɨ ngayn oyi kadɨ Jeju in Betani’tɨ, adɨ rei. Ningə rei tadɔ lə Jeju par el, nan rei tadɔ koo Lajar tɔ kɨ Jeju ad’a ində taa lo koy’tɨ kakin tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","In be ə, kibo’gɨ lə njekujənyamosɨ kadikare’gɨ uni ndu’de kadɨ n’tɔli Lajar tɔ, ");
INSERT INTO gqr_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","tadɔ in ta li’ə ə ra adɨ Juwipɨ’gɨ ngayn inyəi’de ə uni me’de adi Jeju. ");
INSERT INTO gqr_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Lo ti go’tɨ, bulə de’gɨ kɨ ngayn kɨ rei lo ra nanyi’tɨ Jerujalem, oyi kadɨ Jeju isɨ re me ɓebo’tɨ kin, ");
INSERT INTO gqr_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ə ɔyi baji tann’gɨ, ə tei taga gidɨ ɓebo’tɨ, awi tiləi kum’ə. Ningə lo kin’tɨ, uni ndu’de kɨ taa eli eyina: «Ojana! Njangɨ dɔ in kɨ dɔ Luwə’tɨ! Ningə kadɨ Luwə njangɨ dɔ de kɨ re me tɔ Burəɓe’tɨ, kadɨ Luwə njangɨ dɔ ngar lə Isirayel’gɨ!» ");
INSERT INTO gqr_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jeju ingə ngonn koro, ningə ala isɨ dɔ’a’tɨ tokɨ ndangi me makitu’tɨ lə Luwə eyina: ");
INSERT INTO gqr_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","«In ɓol el, ɓebo *Siyon! gon lo oo, ngar lə’i isɨ re, isɨ dɔ ngonn koro’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Dɔkete ba, njendo’gɨ li’ə gəri me nya’gɨ kɨ isɨ rai nya kin el, nan lokɨ de’gɨ isɨ uləi tɔjɨ dɔ Jeju’tɨ nga a kadɨ me’de olo dɔ’tɨ tokɨ makitu lə Luwə elta li’ə kadɨ nya kin a ra nya dɔ’a’tɨ be. Ningə in nya’a kaa ə ra nya dɔ’a’tɨ kin. ");
INSERT INTO gqr_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","De’gɨ ngayn kɨ ndɔkɨ in si’ə nan’tɨ lokɨ ndəl Lajar ad’a te dɔɓadɨ’tɨ, dann njekoy’gɨ’tɨ, manyinajɨ li’ə. ");
INSERT INTO gqr_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ningə in najɨ kɨ man lə’de kin ə ra adɨ bulə de’gɨ awi tiləi kum’ə, tadɔ oyi kadɨ ra nyakɔjɨ kɨ ətɨ ɓol ngayn kin. ");
INSERT INTO gqr_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Lo kin’tɨ, Parisɨ’gɨ elinan dann’de’tɨ eyina: «Oyi tokɨ taga takum’se’tɨ ne kadɨ asi ra nya madɨ el; de’gɨ pətɨ ɓuki nan kɨ go’ə’tɨ!» ");
INSERT INTO gqr_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Girekɨ’gɨ madɨ in dann de’gɨ’tɨ kɨ rei Jerujalem lo ra nanyi’tɨ kadɨ ɔsi məkəsɨ’de nanga non Luwə’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Girekɨ’gɨ kakin rei ndəkba rɔ Pilipɨ’tɨ kɨ in de kɨ ngonn ɓe’tɨ kɨ Betisayda kɨ Galile’tɨ, dəji’ə eyina: «Jɨ ndigɨ kadɨ j’oo Jeju.» ");
INSERT INTO gqr_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ə Pilipɨ aw el Andire, nga a indəi rɔ’de nan’tɨ joo pətɨ ai eli Jeju. ");
INSERT INTO gqr_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jeju ilə’de’tɨ ene: «Kɨ ne kin ə, ndɔ asɨ kadɨ Luwə tɔjɨ tɔgɨ’m m’in Ngonn de kɨ taga nga. ");
INSERT INTO gqr_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ningə rɔta, rɔta, adɨ m’el’se, kandɨ koo kɨ kare kɨ osɨ nanga kin re oy el ə, a to kɨ kar’ne ba par, a re oy tɔ ə, a te kɨ kandɨ ko’gɨ kɨ rangɨ ngayn. ");
INSERT INTO gqr_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","De kɨ ndigɨ koo majɨ rɔ’ne, a il’ə kɔ, nan de kɨ inyə ta koo majɨ rɔ’ne dɔnangɨ’tɨ ne, a ngəm rɔ’ne tadɔ kajɨ kɨ bitɨ kɨ non’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Kin ə re de madɨ ge ra kuləɓər lə’m ə, majɨ kadɨ un go’m, nga ningə njekuləɓər lə’m kin a in sə’m lo’tɨ kɨ m’a m’in’tɨ. De kɨ nje ra kuləɓər lə’m, Bai Luwə a ɔsigonn’o.» ");
INSERT INTO gqr_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Jeju el ene: «Kɨ ne kin, ndil’m isɨ nanga el, eke ta ri ə kadɨ m’el wa? Kadɨ m’el m’ene: “Bai, ajɨ’m ta dɔ kadɨ’tɨ kɨ ngan kɨ a re dɔ’m’tɨ kin wa?” Nga in tadɔ dɔ kadɨ inɓe kin ə m’re’n bitɨ m’te’n ne kin. ");
INSERT INTO gqr_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Bai, tɔjɨ adɨ de’gɨ gəri tɔɓar lə’i.» Ningə ndu de ɓar in kɨ dɔran’tɨ ene: «M’adɨ de’gɨ gəri tɔɓar lə’m nga, nan m’a m’adɨ de gəri ɓay.» ");
INSERT INTO gqr_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Bulə de’gɨ kɨ rai low’ə’tɨ non ə oyi ndu ta kin kɨ mbi’de eli eyina: «In ndi ə ndangɨ nya.» Ningə nje kɨ nungɨ eli eyina: «Malayka kare ə el’ə ta.» ");
INSERT INTO gqr_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ə Jeju el’de ene: «Ndu ta kɨ oyi kin te tadɔ lə’m m’in el, nan te tadɔ lə’se ingɨ. ");
INSERT INTO gqr_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Kɨ ne kin, in dɔkagilo kɨ kadɨ Luwə a gangɨ’n ta dɔ de’gɨ’tɨ kɨ dɔnangɨ’tɨ ne nga, in dɔkagilo kɨ kadɨ Luwə a uwə’n ngar kɨ isɨ ində tɔgɨ’ne dɔ de’gɨ’tɨ kɨ dɔnangɨ’tɨ ne, il’ə gidɨ lo’tɨ kɔ nga. ");
INSERT INTO gqr_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Nga ningə m’in, ndɔ kɨ de’gɨ a uni m’in taa ngərəngɨ kɨ dɔnangɨ’tɨ kin ə, m’a m’ndɔr de’gɨ pətɨ kɨ rɔ’m’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Me ta’gɨ’tɨ kin, Jeju tɔjɨ kadɨ gəri ke gorow kɨ bann ə a oy wa? ");
INSERT INTO gqr_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ə bulə de’gɨ eli’ə eyina: «J’ingəi me makitu ndukun’gɨ’tɨ lə’je tokɨ Kirisitɨ kɨ in de kɨ Luwə mbət’ə, a isɨ bitɨ kɨ non’tɨ um a oy el, nga ra bann be ə in el ene: “Majɨ kadɨ a ɓəri Ngonn de taa dɔ kagidəsɨ’tɨ wa?” Ə Ngonn de’ə inɓe kin in nan dana wa?» ");
INSERT INTO gqr_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ningə Jeju el’de ene: «Kunjɨ in dann’se’tɨ ne dɔkagilo nden ɓay. Ningə kadɨ njiyəi kɨ non’se’tɨ lokɨ kunjɨ isɨ unjɨ dɔ’se’tɨ kin, kadɨ to lo kɨ diw ingə’se dɔ row’tɨ el. Tadɔ de kɨ njiyə me lo kɨ diw’tɨ, gər lokɨ isɨ awɨ’tɨ el. ");
INSERT INTO gqr_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Dɔkagilo kɨ kunjɨ in sese kin ə, uni me’se adi kunjɨ, kadɨ to təli de’gɨ kɨ me kunjɨ’tɨ.» Lokɨ Jeju el’de ta be ningə, ɔtɨ aw iyə rɔ’ne sanyi takum de’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Jeju ra nyakɔjɨ’gɨ kɨ ətɨ ɓol ɓol takum Juwipɨ’gɨ’tɨ kaa, uni me’de adi’ə el. ");
INSERT INTO gqr_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","In kin tɔlta ta kɨ njekeltakita Luwə’tɨ Ejay el ene: «Burəɓe, nan un me’ne dɔ ta’gɨ’tɨ kɨ osɨ mbi’de’tɨ kin wa? In nan’gɨ ə Burəɓe tɔjɨ’de tɔgɨ’ne wa?» ");
INSERT INTO gqr_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ningə darɔ Ejay inɓe təl ra non ɔr ginn nya kɨ asi kadɨ uni me’de el ene: ");
INSERT INTO gqr_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","«Luwə tɔ kum’de, Kadɨ to oyi lo el, Adɨ me’de ngan ngororo, Kadɨ to gəri nya madɨ kare el, Kadɨ to təli kum’de rɔ Luwə’tɨ el, Nan to Luwə ajɨ’de.» ");
INSERT INTO gqr_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ejay elta kin be tadɔ kunjɨ Jeju kɨ oo kete nu ə el’n ta dɔ’a’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Nya kare, dann njekundɔ Juwipɨ’gɨ’tɨ inɓe kin, ngayn’gɨ uni me’de adi Jeju, nan mbeti keli kɨ taga tadɔ lə Parisɨ’gɨ kɨ kadɨ a tuwəi’de kɔ ginn kəykawnan’tɨ lə Juwipɨ’gɨ. ");
INSERT INTO gqr_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Oyi majɨ ngayn kadɨ de’gɨ yo ə piti’de utə kadɨ Luwə ta’a piti’de. ");
INSERT INTO gqr_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jeju un ndu’ne kɨ taa ene: «De kɨ un me’ne ə, in m’in ə un me’ne adɨ’m el, nan in njekulə’m ə un me’ne ad’a, ");
INSERT INTO gqr_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","ningə de kɨ oo’m ə, oo njekulə’m tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","M’in, m’in kunjɨ, ə m’re dɔnangɨ’tɨ ne kadɨ de kɨ un me’ne adɨ’m ə, de’ə njiyə me lo kɨ diw’tɨ el. ");
INSERT INTO gqr_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Kin ə re ta lə’m osɨ mbi de’tɨ, ə de’ə ra’n kulə el ə, in m’in ə m’gangɨ ta dɔ’a’tɨ el, tadɔ m’re dɔnangɨ’tɨ ne kadɨ m’ajɨ de’gɨ um kadɨ m’gangɨ ta dɔ de’tɨ el. ");
INSERT INTO gqr_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","De kɨ mbətɨ’m num, taa ta lə’m el num ə, aw kɨ njegangita dɔ’ne’tɨ nga. Ningə in nya’gɨ kɨ m’ndo de’gɨ inɓe kin ə, a gangi ta dɔ’a’tɨ dɔboy ndɔ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Tokɨ rɔta’tɨ, m’elta kɨ dɔ rɔ’m el, nan in Bai kɨ njekulə’m ə adɨ’m ndu’gɨ kɨ kadɨ m’el num, m’ndo num. ");
INSERT INTO gqr_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Nga ningə, m’gər kadɨ mbərkikində kɨ Luwə adɨ kin ə, in nje re kɨ kajɨ kɨ bitɨ kɨ non’tɨ. Ta’gɨ kɨ m’el, m’el’de tokɨ Bai el’m.» ");
INSERT INTO gqr_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Kete non ra nanyi Pakɨ’tɨ, Jeju gər kadɨ ndɔ re nga kadɨ to inyə dɔnangɨ ə aw rɔ Baw’ne’tɨ. Jeju kɨ ndigɨ nje yan’ne’gɨ kɨ dɔnangɨ’tɨ mayinu, ndigɨ’de bitɨ kadɨ tɔlta’a. ");
INSERT INTO gqr_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Jeju in kɨ njendo’gɨ lə’ne ta nyakusɔ lo sɔl’ɔ. Ningə dɔkagilo’ə’tɨ kin, Su ində mərta kulə Jeju ji njeban’gɨ’tɨ me Judasɨ’tɨ kɨ ngonn lə Simon Isikariyotɨ nga. ");
INSERT INTO gqr_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jeju inɓe kɨ dɔ’ne gər kadɨ Baw’ne Luwə ulə nya’gɨ pətɨ ji’ne’tɨ, ningə gər tokɨ n’in rɔ’a’tɨ ə n’re, adɨ n’ra n’təl n’aw rɔ’a’tɨ gogɨ. ");
INSERT INTO gqr_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Jeju ində taa ta nya kusɔ’tɨ, ɔr ku lə’ne kɨ ulə dɔ mad’a’tɨ, ə un ta ku dɔɔ’n ɓədɨ’ne. ");
INSERT INTO gqr_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Go’tɨ, mbəl mann me nya’tɨ, ə ilə rɔ’ne togɨ nja njendo’gɨ lə’ne, ə bɔr nja’de kɨ ta ku kɨ kete dɔɔ’n ɓədɨ’ne kakin. ");
INSERT INTO gqr_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Lokɨ Jeju re te dɔ Simon Piyər’tɨ ə, Simon Piyər el’ə ene: «Burəɓe, in ə kadɨ togɨ nja’m wa?» ");
INSERT INTO gqr_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ə Jeju el’ə ene: «Nya kɨ m’njɨ m’ra kin, tanan’tɨ ne in gər el, nan a gər me’ə ɓay.» ");
INSERT INTO gqr_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Be kaa Piyər el Jeju ene: «Jagɨ, in a togɨ nja’m el.» Ə Jeju el’ə ene: «Kin ə re m’togɨ njay el ə, nya madɨ kɨ ore’je nan’tɨ sə’i goto.» ");
INSERT INTO gqr_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ningə Piyər el ene: «Burəɓe, re in be ə, togɨ nja’m par el, nan kadɨ togɨ ji’m’gɨ kɨ dɔ’m’gɨ tɔ.» ");
INSERT INTO gqr_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ə Jeju el’ə ene: «De kɨ ndogɨ mann, aw ndoo togɨ nja’ne par, um rɔ’a’gɨ pətɨ el, tadɔ ndəgɨ rɔ’a’gɨ ar njay. Nga ningə ingɨ, rɔ’se ar njay, nan in de’gɨ pətɨ ə rɔ’de ar, el ɓay tɔ.» ");
INSERT INTO gqr_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Lo kin’tɨ, Jeju gər de kɨ njekulə’ne ji njeban’gɨ’tɨ, ə el’n ene: «In ingɨ pətɨ ə rɔ’se ar njay el.» ");
INSERT INTO gqr_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Lokɨ Jeju togɨ nja’de ginn’ə gangɨ ningə, un ku lə’ne ulə rɔ’ne’tɨ, ə təl aw isɨ ta nyakusɔ’tɨ gogɨ, ə el’de ene: «In gəri me nya kɨ m’ra sese kin wa? ");
INSERT INTO gqr_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Sii ɓari m’in Njendo de’gɨ, Burəɓe ge, ningə in gorow’ə’tɨ, tadɔ in m’inɓe. ");
INSERT INTO gqr_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Nga ningə re m’in kɨ m’in Njendo de’gɨ, m’in Burəɓe ge’ə m’togɨ nja’se ningə, ingɨ kaa majɨ kadɨ togi nja nan kɨ yo ge kɨ ne ge tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","In nya ə m’ɔjɨ’se, kadɨ ingɨ kaa ndaji, rai tokɨ m’ra sese kin be tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Tokɨ rɔta’tɨ, adɨ m’el’se, ɓər utə ɓe’ne el, taa ngonn njekawkulə utə njekulə el tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Tokɨ in gəri nga kin ə, rai kul’ə ə, rɔ’se a nəl’se ngayn. ");
INSERT INTO gqr_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","In ingɨ pətɨ ə m’njɨ m’elta lə’se el; m’gər de’gɨ kɨ m’mbətɨ’de. Nga ningə, majɨ kadɨ ta kɨ makitu lə Luwə el kin ra nya. Makitu el ene: “De kɨ isɨ sɔ sə’m nya, tur gajɨ’ne ɔsɨ’m.” ");
INSERT INTO gqr_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","M’el’se ta kin ngɔsine, kadɨ to ndɔkɨ nya’a a ra nya ə, gəri tokɨ m’in “M’in Nje kisɨ non.” ");
INSERT INTO gqr_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Tokɨ rɔta’tɨ, adɨ m’el’se, de kɨ uwə de kɨ m’a m’ulə kɨ rɔ’ne’tɨ, in m’inɓe ə uwə’m kɨ rɔ’ne’tɨ, ə de kɨ uwə’m kɨ rɔ’ne’tɨ, uwə njekulə’m kɨ rɔ’ne’tɨ tɔ.» ");
INSERT INTO gqr_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Go ta’gɨ’tɨ kin, ndil Jeju isɨ nanga el, adɨ ta te ta’a’tɨ kɨ taga ene: «Tokɨ rɔta’tɨ, adɨ m’el’se, de kare dann’se’tɨ ne a ulə’m ji de’gɨ’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Lo kin’tɨ, njendo’gɨ li’ə gonyi kum nan, ningə dəji nan ke nan dana ə isɨ elta li’ə wa. ");
INSERT INTO gqr_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Kɨ kare dann njendo’gɨ’tɨ, kɨ in de kɨ Jeju ndig’ə, isɨ kadɨ Jeju’tɨ ndəkba. ");
INSERT INTO gqr_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ə Simon Piyər ra nyakɔjɨ el’n’ə kadɨ dəjɨ Jeju ke isɨ elta lə nan dana inɓe. ");
INSERT INTO gqr_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Njendo kakin ɔy kɨ dɔ Jeju’tɨ see, ningə dəj’ə ene: «Burəɓe, de’ə in nan wa?» ");
INSERT INTO gqr_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ə Jeju ilə’tɨ ene: «In de kɨ m’a m’ad’a mapa kɨ m’gangɨ, m’ulə me tanyi’tɨ kin.» Ningə Jeju gangɨ mapa ulə me tanyi’tɨ, adɨ Judasɨ ngonn lə Simon Isikariyotɨ. ");
INSERT INTO gqr_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Lokɨ Judasɨ taa mapa kakin taa par ə, *Satan ur me’ə’tɨ. Ə Jeju el’ə ene: «Nya kɨ to me’i’tɨ kadɨ ra kakin, ra kalangɨ!» ");
INSERT INTO gqr_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Dann de’gɨ’tɨ kɨ si si’ə ta nyakusɔ’tɨ kin, de kɨ kadɨ gər ke tadɔ ri ə el’ə ta kin be wa goto. ");
INSERT INTO gqr_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Tokɨ Judasɨ in’n nje kotɨ ɓɔl nar kakin, ngayn’gɨ oyi tokɨ Jeju dəj’ə kadɨ aw ndogɨ nya kɨ kadɨ n’rai nanyi Pakɨ, eke kadɨ aw adɨ nya madɨ njendoo’gɨ wa be. ");
INSERT INTO gqr_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judasɨ taa mapa kɨ Jeju ad’a kakin taa par ə te taga. Dɔ kad’a’tɨ kin, lo ndul nga. ");
INSERT INTO gqr_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Lokɨ Judasɨ te ə, Jeju el ene: «Kɨ ngɔsine kin, de’gɨ uləi tɔjɨ dɔ’m’tɨ m’in Ngonn de, ningə m’in Ngonn de m’a m’adɨ de’gɨ uləi tɔjɨ dɔ Luwə’tɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Kin ə re m’a m’adɨ de’gɨ uləi tɔjɨ dɔ Luwə’tɨ ə, Luwə inɓe kɨ dɔ’ne a adɨ de’gɨ uləi tɔjɨ dɔ’m’tɨ m’in Ngonn de tɔ. Nga ningə in nya kɨ a ra nya ngɔsine. ");
INSERT INTO gqr_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ngann’m’gɨ, m’in sese ne, nan’tɨ dɔkagilo kɨ nden be par. A sangi m’in, ningə tokɨ m’el’n Juwipɨ’gɨ, m’el’se ɓone tɔ tokɨ: “Lo kɨ m’a m’aw’tɨ, a asi kadɨ awi’tɨ el.” ");
INSERT INTO gqr_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","M’adɨ’se mbərkikində kɨ sigɨ kɨ in ta kadɨ in ndiginan dann’se’tɨ kɨ yo ge kɨ ne ge. Majɨ kadɨ in ndiginan dann’se’tɨ kɨ yo ge kɨ ne ge tokɨ m’in m’ndigɨ’n’se kin be tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Kin ə re in ndiginan dann’se’tɨ kɨ yo ge kɨ ne ge ə, de’gɨ pətɨ a gəri tokɨ in njendo’gɨ lə’m.» ");
INSERT INTO gqr_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simon Piyər dəjɨ Jeju ene: «Burəɓe, a aw ra wa?» Ə Jeju el’ə ene: «Lo kɨ m’a m’aw’tɨ, a asɨ kadɨ un go’m kɨ ngɔsine’tɨ kin el, nan a un go’m ɓay.» ");
INSERT INTO gqr_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ningə Piyər ilə Jeju’tɨ ene: «Burəɓe, tadɔ ri ə m’a m’asɨ kadɨ m’un go’i kɨ ngɔsine’tɨ kin el wa? M’njɨ dɔ nja’m’tɨ kadɨ m’adɨ rɔ’m kɔ tadɔ lə’i!» ");
INSERT INTO gqr_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Lo kin’tɨ, Jeju ilə Piyər’tɨ ene: «Adɨ in isɨ dɔ nja’i’tɨ kadɨ adɨ rɔ’i kɔ tadɔ lə’m inɓe ta? Tokɨ rɔta’tɨ, adɨ m’el’i, kunə kunjə non el ɓay ə, a manjɨ ta nja mutə ene in gərɨ’m el.» ");
INSERT INTO gqr_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jeju el njendo’gɨ lə’ne ene: «Majɨ kadɨ me’se ɓol el, uni me’se adi Luwə, ə uni me’se adi’m’in tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Me ɓe’tɨ lə Bai, kəy’gɨ in ngayn non. Kin ə re in nya kɨ rɔta’tɨ el ə, re m’a m’el’se, tadɔ m’njɨ m’aw kadɨ m’ra go lo tadɔ lə’se. ");
INSERT INTO gqr_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Lokɨ m’aw, ə m’ra go lo ginn’ə gangɨ ningə, m’a m’təl to m’re kadɨ m’ɔy’se, m’aw sese rɔ’m’tɨ, kadɨ to lo kɨ m’in’tɨ, ingɨ kaa in’tɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","In, gəri row kɨ kaw lo’tɨ kɨ m’njɨ m’aw’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Lo kin’tɨ, Tomasɨ el Jeju ene: «Burəɓe, jɨ gər lo kɨ isɨ awɨ’tɨ el tɔ, ə ra bann be ə j’a jɨ gər row kɨ kaw’tɨ wa?» ");
INSERT INTO gqr_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ə Jeju el’ə ene: «M’in row, m’in rɔta, m’in kisikidɔtaa. Row kɨ rangɨ kɨ kadɨ de asɨ kaw’n rɔ Bai Luwə’tɨ goto. ");
INSERT INTO gqr_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Re in gəri m’in ə, a in gəri Bai tɔ. Nga ningə, tokɨ jɨ ra’n ne inɓe kin, in gəri’ə num, oyi’ə num tɔ.» ");
INSERT INTO gqr_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ningə Pilipɨ el Jeju ene: «Burəɓe, tɔjɨ’je Baw’je Luwə adɨ j’oo’ə par ə, inɓe kin asɨ’je nakɨ.» ");
INSERT INTO gqr_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ə Jeju el’ə ene: «Pilipɨ, in mayinu ba ə m’in sese ne kin kaa in gəri’m’in el ɓay wa? De kɨ oo’m ə, oo Bai Luwə tɔ. Nga ra bann be ə el ene: “Tɔjɨ’je Baw’je Luwə adɨ j’oo’ə wa?” ");
INSERT INTO gqr_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Oo to ta kɨ rɔta’tɨ el kadɨ m’in m’njɨ me Bai’tɨ, ə Bai isɨ me’m’tɨ wa? Ta’gɨ kɨ m’njɨ m’el’se kin, in m’inɓe kɨ dɔ rɔ’m ə m’njɨ m’el el; in Bai kɨ isɨ me’m’tɨ ə isɨ ra kulə’gɨ lə’ne. ");
INSERT INTO gqr_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Uni me’se adi’m’in tokɨ m’in m’njɨ me Bai’tɨ, ə Bai isɨ me’m’tɨ tɔ kin. A re uni me’se adi’m’in dɔ ta’gɨ’tɨ kɨ m’njɨ m’el el ə, kulə ra’gɨ lə Luwə kɨ oyi kɨ kum’se kin yo ə, uni me’se nden. ");
INSERT INTO gqr_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Tokɨ rɔta’tɨ, adɨ m’el’se, de kɨ un me’ne ə, in kaa a ra nya’gɨ kɨ m’njɨ m’ra’de kin tɔ. A ra nya’gɨ kɨ ətɨ ɓol ngayn ɓay, tadɔ m’in m’njɨ m’aw rɔ Bai’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Nga ningə, nya’gɨ pətɨ kɨ dəji me tɔ’m’tɨ ə, m’a m’ra m’adɨ’se, kadɨ m’in Ngonn, m’ra m’adɨ de’gɨ uləi tɔjɨ dɔ Bai Luwə’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Kin ə re dəji nya madɨ me tɔ’m’tɨ ə, m’a m’ra m’adɨ’se.» ");
INSERT INTO gqr_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Jeju ilə ta kɨ rangɨ dɔ’tɨ ɓay ene: «Kin ə re in ndigɨ m’in ə, a təli rɔ’se go mbərkikində’gɨ’tɨ lə’m ə uwəi njarara. ");
INSERT INTO gqr_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ningə m’in, m’a m’dəjɨ Bai Luwə kadɨ ulə kɨ Njera sese kɨ rangɨ, kɨ a isɨ sese bitɨ kɨ non’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","In ə in Ndil kɨ njera nya kɨ rɔta’tɨ, kɨ de’gɨ kɨ dɔnangɨ’tɨ ne asi kadɨ taai’ə me de’tɨ el, tadɔ oyi’ə el, taa gəri’ə el tɔ, nan ingɨ, in gəri’ə, tadɔ isɨ kadɨ’se’tɨ ne, taa a isɨ me’se’tɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","M’a m’inyə’se kɨ kar’se to ngann hal’gɨ be el, nan m’a m’təl kadɨ m’re rɔ’se’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Nanyi ngayn el kadɨ de’gɨ kɨ dɔnangɨ’tɨ ne a oyi m’in el ratata, nan ingɨ, a oyi m’in, tadɔ m’njɨ kɨ dɔ’m taa, taa ingɨ kaa a sii kɨ dɔ’se taa tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ndɔ’a’tɨ kin ə, a oyi kadɨ m’in me Bai’tɨ, ningə ingɨ, in me’m’tɨ, ə m’in, m’in me’se’tɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","De kɨ njendigɨ’m, in de kɨ ngəm go mbərkikində’gɨ lə’m majɨ num, təl rɔ’ne go’tɨ num. Bai a ndigɨ de kɨ njendigɨ’m, ningə m’in kaa m’a m’ndig’ə tɔ, taa m’a m’tɔj’ɔ rɔ’m kɨ taga kadɨ gərɨ’m tɔ.» ");
INSERT INTO gqr_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Judɨ (kɨ Judasɨ Isikariyotɨ el) el Jeju ene: «Burəɓe, ra bann be j’in par ə a tɔjɨ’je rɔ’i kɨ taga kadɨ jɨ gəri, um a tɔjɨ rɔ’i kɨ taga kadɨ ndəgɨ de’gɨ kɨ dɔnangɨ’tɨ ne kin gəri nu el wa?» ");
INSERT INTO gqr_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jeju il’ə’tɨ ene: «De kɨ ndigɨ’m ə, a ngəm go ta’gɨ lə’m. Bai a ndig’ə, ningə j’in kɨ Bai Luwə joo pətɨ j’a jɨ re rɔ’a’tɨ, j’a j’ində ɓe nan’tɨ si’ə. ");
INSERT INTO gqr_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","De kɨ ndigɨ’m el, təl rɔ’ne go ta’gɨ’tɨ lə’m el. Ta’gɨ kɨ isɨ te ta’m’tɨ ə isɨ oyi kin, in ta’gɨ kɨ m’inɓe m’el kɨ dɔ’m el, nan in ta’gɨ kɨ in rɔ Bai’tɨ kɨ njekulə’m. ");
INSERT INTO gqr_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","M’el’se ta’gɨ kin dɔkagilo kɨ m’in sese nan’tɨ ne ɓay kin. ");
INSERT INTO gqr_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Njera sese, Ndil Luwə kɨ Bai a ulə’n adɨ’se me tɔ’m’tɨ kin, a ndo’se nya’gɨ pətɨ, taa a olo me’se dɔ nya’gɨ’tɨ pətɨ kɨ m’el’se tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","M’inyə lapiya m’adɨ’se, m’adɨ’se lapiya lə’m. Ningə m’in m’adɨ’se tokɨ de’gɨ kɨ dɔnangɨ’tɨ ne adi’se el. Adi me’se osɨ nanga, in ɓoli el. ");
INSERT INTO gqr_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Oyi te ta’m’tɨ m’el m’ene: “M’a m’aw, ə m’a m’təl m’re rɔ’se’tɨ”. Ningə kin ə re in ndigɨ m’in ə, a rai rɔnel dɔ kaw’tɨ kɨ m’njɨ m’aw rɔ Bai’tɨ, tadɔ in, in kibo utə’m. ");
INSERT INTO gqr_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","M’el’se ta kin ngɔsine, kete taa kadɨ nya’gɨ rai nya, kadɨ to lokɨ a rai nya ə, uni me’se adi’ə. ");
INSERT INTO gqr_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","M’a m’ingə kagilo kadɨ m’el’se ta kɨ ne’tɨ kin el nga, tadɔ, ngar kɨ isɨ ində tɔgɨ’ne dɔ de’gɨ’tɨ kɨ dɔnangɨ’tɨ ne, re. Ningə in aw kɨ tɔgɨ madɨ dɔ’m’tɨ el, ");
INSERT INTO gqr_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","nan a ingə tarow kadɨ ra adɨ de’gɨ gəri tokɨ m’ndigɨ Bai, ə m’ra nya’gɨ tokɨ Bai dəjɨ’m kadɨ m’ra. Indəi taa lo kin’tɨ adɨ j’awi.» ");
INSERT INTO gqr_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Jeju el ene: «M’in, m’in kagɨ nju kɨ rɔta’tɨ, ningə Bai in nje ra kulə me ndɔɔ nju’tɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Baji nju kɨ in rɔ’m’tɨ, ə andɨ el ə, Bai a tugə kɔ, nan in kɨ andɨ majɨ ə, a tugə ngann baji’ə’gɨ kɨ majel kɔ kadɨ andɨ kɨ kete dɔ mad’a’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ningə in nyando kɨ m’ndo’se, ra adɨ in de’gɨ kɨ ari njay nga. ");
INSERT INTO gqr_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ə re uwəi rɔ’se rɔ’m’tɨ ngan ə, m’in m’a m’uwə’se rɔ’m’tɨ ngan tɔ. Nga ningə, to kɨ kaa kɨ baji kagɨ a asɨ kadɨ andɨ kɨ kanjɨ kagɨ el kakin ə, ingɨ kaa a asi kadɨ rai nya madɨ kɨ kanjɨ kadɨ uwəi rɔ’se rɔ’m’tɨ, el tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","M’in kagɨ nju, ə in baji’m’gɨ tɔ. De kɨ uwə rɔ’ne rɔ’m’tɨ ngan, ə m’in m’uwə rɔ’m’tɨ tɔ ə, a ra nya’gɨ kɨ majɨ majɨ ngayn, tadɔ a asi kadɨ rai nya madɨ kɨ majɨ kɨ dɔrɔ’se el. ");
INSERT INTO gqr_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","De kɨ uwə rɔ’ne ngan rɔ’m’tɨ el, a iləi’ə kɔ gidɨ lo’tɨ to baji kagɨ be. Baji kagɨ’gɨ kɨ tuti, a kəri’de kadɨ ɓuki’de por’o kadɨ onyi por kɔ. ");
INSERT INTO gqr_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Kin ə re uwəi rɔ’se rɔ’m’tɨ ngan, ə ta lə’m isɨ me’se tɔ ə, dəji nya kɨ in ndigɨ ə a ingəi. ");
INSERT INTO gqr_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Nya kɨ a rai kadɨ de’gɨ uləi tɔjɨ dɔ Luwə’tɨ kɨ taga, in ta kadɨ rai kulə’gɨ kɨ majɨ, majɨ, kɨ dɔnan’tɨ, dɔnan’tɨ num, kadɨ tɔji tokɨ in njendo’gɨ lə’m kɨ rɔta’tɨ num tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Tokɨ Bai ndigɨ’m nga, m’in m’ndigɨ’se nga be tɔ. Nga ningə, majɨ kadɨ rai dɔ nja’se’tɨ, me ndigɨ’tɨ kɨ m’ndigɨ’se. ");
INSERT INTO gqr_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Kin ə re təli rɔ’se go mbərkikində’gɨ’tɨ lə’m ə, a rai dɔ nja’se’tɨ, me ndigɨ’tɨ kɨ m’ndigɨ’se, tokɨ m’təl’n rɔ’m go mbərkikində’gɨ’tɨ lə Bai Luwə, ə m’ra’n dɔ nja’m’tɨ, me ndigɨ’tɨ kɨ in ndigɨ’m kin be tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","«M’el’se ta’gɨ kin be kadɨ rɔnel kɨ me’m’tɨ in rɔnel lə’se tɔ, ningə kadɨ rɔnel lə’se in rɔnel kɨ asɨ nan rerere. ");
INSERT INTO gqr_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Mbərkikində lə’m ə to kin: In ndiginan kɨ yo ge kɨ ne ge dann’se’tɨ, tokɨ m’ndigɨ’n’se kin be tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Kin ə re de un rɔ’ne ilə kɔ tadɔ lə madɨ’ne’gɨ ə, nya madɨ kɨ rangɨ kɨ kadɨ a ra, tɔjɨ’n ndiginan kɨ utə in kin goto nga. ");
INSERT INTO gqr_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Kin ə re rai nya kɨ m’dəjɨ’se kadɨ rai ə, in madɨ’m’gɨ. ");
INSERT INTO gqr_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","M’ɓar’se njekuləɓər’gɨ el ratata, tadɔ njekuləɓər gər nya kɨ ɓe’ə isɨ ra el. Nga ningə m’in, m’ɓar’se madɨ’m’gɨ, tadɔ m’adɨ ingɨ gəri nya’gɨ pətɨ kɨ m’ingə rɔ Bai Luwə’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","In ingɨ ə mbəti m’in el, nan in m’in ə m’mbətɨ’se. Ningə, m’adɨ’se kulə kadɨ rai, rai kulə’gɨ kɨ majɨ majɨ, kɨ a to ratata. Ningə lo kin’tɨ, Bai a adɨ’se nya’gɨ pətɨ kɨ dəji’ə me tɔ’m’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Nya kare kɨ m’dəjɨ’se, in ta kadɨ in ndiginan kɨ yo ge kɨ ne ge dann’se’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Jeju el ɓay ene: «Kin ə re de’gɨ kɨ dɔnangɨ’tɨ ne ɔsi’se ta ə, kadɨ in gəri tokɨ in m’in ə ɔsi m’in ta kete non’se’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Nga ningə, kin re in uwəi kɨ de’gɨ kɨ dɔnangɨ’tɨ ne ə, re de’gɨ kɨ dɔnangɨ’tɨ ne a ndigɨ’se; nan kɨ ne kin, in uwəi se’de el, tadɔ m’mbətɨ’se, m’te sese kɔ dann’de’tɨ. Ningə in tadɔ kin ə, ɔsi’se ta. ");
INSERT INTO gqr_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ə adi me’se olo dɔ ta’tɨ kɨ m’el’se kete m’ene: “Ɓər utə ɓe’ne el” kin. Kin ə re adi m’in kon ə, a adi’se kon tɔ, a re təli rɔ’de go ta’tɨ lə’m ə, a təli rɔ’de go ta’tɨ lə’se tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Kɨ ne kin, a adɨ’se kon tadɔ lə’m, tadɔ gəri de kɨ njekulə’m el. ");
INSERT INTO gqr_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Kin ə re m’re el, re m’el’de ta el ə, re de a tudə majel’gɨ lə’de dɔ’de’tɨ el; nan kɨ ne kin, lo kadɨ a eli eyina: “Gər ə jɨ gər el,” kadɨ de inyə’n go majel’gɨ lə’de kɔ goto. ");
INSERT INTO gqr_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","De kɨ me’ə majel sə’m ə, me’ə majel kɨ Bai Luwə tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Kin ə re m’ra kulə madɨ kɨ de madɨ kɨ rangɨ ra nja kare el, dann’de’tɨ el ə, re de a tudə majel’gɨ lə’de dɔ’de’tɨ el; nan kɨ ne kin, oyi kulə ra’m’gɨ kɨ kum’de. Be kaa, me’de majel sə’m num, majel kɨ Bai num. ");
INSERT INTO gqr_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ningə, in nya kɨ ra nya be kadɨ ta kɨ ndangi me makitu Ndukun’tɨ lə Luwə ene: “Me’de majel sə’m kare be par”, kin ra nya. ");
INSERT INTO gqr_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","«Njera sese kɨ m’a m’ulə si’ə kɨ tɔ Bai Luwə, a re. Ningə in ə in Ndil kɨ nje kel nya’gɨ kɨ rɔta’tɨ dɔ Luwə’tɨ, kɨ a in rɔ Luwə’tɨ. In ə a mannajɨ dɔ’m’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Nga ningə, ingɨ kaa a manyinajɨ lə’m tɔ, tadɔ in sə’m nan’tɨ lo kulə ngirə nya’gɨ’tɨ nu.» ");
INSERT INTO gqr_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","«M’el’se ta’gɨ kin kete be pətɨ kadɨ to inyəi ta kunme lə’se el. ");
INSERT INTO gqr_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","De’gɨ a tuwəi’se kɔ ginn kəykawnan’gɨ’tɨ lə Juwipɨ’gɨ. Ningə ndɔ’gɨ a rei inɓe ɓay kɨ kadɨ nje kɨ a tɔli’se, a eli me’de’tɨ eyina in kulə lə Luwə ə nyɨ n’isi n’rai. ");
INSERT INTO gqr_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","A rai be, tadɔ gəri Bai el num, gəri m’in el num. ");
INSERT INTO gqr_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Nga ningə, m’el’se ta’gɨ kin be kete, kadɨ to ndɔ kɨ nya’gɨ a rai nya ə, me’se olo dɔ’tɨ tokɨ ndɔkɨ m’el’se. M’el’se ta’gɨ kin lo kulə ngirə’tɨ nu el, tadɔ m’in sese nan’tɨ ne. ");
INSERT INTO gqr_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","«Kɨ ngɔsine kin, m’njɨ m’aw kɨ rɔ nje kulə’m’tɨ, nan de kare dann’se’tɨ kɨ kadɨ dəjɨ’m ene: “Sɨ aw ra wa kaa,” goto. ");
INSERT INTO gqr_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Me’se ur mad’a tadɔ ta’gɨ kɨ m’el’se. ");
INSERT INTO gqr_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Nga ningə, in ta kɨ rɔta’tɨ ə m’el’se: majɨ ngayn tadɔ lə’se kadɨ m’aw, tadɔ re m’aw el ə, de kɨ Njera sese kɨ majɨ kadɨ a re kin, a re el. A re m’aw tɔ ə, m’a m’ulə si’ə m’adɨ’se. ");
INSERT INTO gqr_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ə lokɨ a re ə, a ra kadɨ de’gɨ kɨ dɔnangɨ’tɨ ne gəri tokɨ ndəmi ɔjidɔ nyara kɨ majel, kɨ nyara kɨ dana, kɨ takigangɨ. ");
INSERT INTO gqr_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Kadɨ gəri tokɨ ndəmi ɔjidɔ majel kɨ ra, tadɔ mbeti kun me’de kadi’m. ");
INSERT INTO gqr_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Kadɨ gəri tokɨ ndəmi ɔjidɔ nyara kɨ dana tadɔ m’njɨ m’aw rɔ Bai’tɨ, ningə ingɨ a oyi m’in gogɨ el ratata. ");
INSERT INTO gqr_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Kadɨ gəri tokɨ ndəmi ɔjidɔ takigangɨ, tadɔ gangi ta dɔ ngar’tɨ kɨ isɨ ində tɔgɨ’ne dɔ de’gɨ’tɨ kɨ dɔnangɨ’tɨ ne nga. ");
INSERT INTO gqr_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","«M’aw kɨ ta’gɨ ngayn ɓay kadɨ m’el’se, nan kɨ ngɔsine kin, a aldɔ’se. ");
INSERT INTO gqr_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Nga ningə, dɔkagilo kɨ Ndil kɨ nje kɔjɨ nya’gɨ kɨ rɔta’tɨ a re ə, a ra kadɨ in gəri nya’gɨ pətɨ kɨ rɔta’tɨ. A elta kɨ tɔ’ne inɓe el, nan a el nya’gɨ pətɨ kɨ ingə rɔ Luwə’tɨ, ningə a ilə’se mbər nya’gɨ kɨ a rai nya lo ti’tɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","In tɔjɨ tɔɓar lə’m kɨ taga, tadɔ in ta’gɨ lə’m, ə a ilə’se mbər’ə. ");
INSERT INTO gqr_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Nya’gɨ pətɨ kɨ in yan Bai, in yan’m tɔ. In tadɔ kin ə, m’el’n m’ene in ta’gɨ lə’m, ə Ndil a ilə’se mbər’ə.» ");
INSERT INTO gqr_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Jeju el ene: «Nanyi dɔkagilo nden ba kadɨ a oyi m’in el, ningə dɔkagilo nden go’tɨ ə, a təli oyi m’in gogɨ.» ");
INSERT INTO gqr_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ə njendo’gɨ madɨ elinan dann’de’tɨ eyina: «Ta kɨ el’je ene: “Nanyi dɔkagilo nden ba kadɨ a oyi m’in el, ningə dɔkagilo nden go’tɨ ə, a təli oyi m’in gogɨ,” kin me’ə nan ri wa? Taa elta kɨ kare ɓay ene: “Tadɔ m’njɨ m’aw rɔ Bai’tɨ.” ");
INSERT INTO gqr_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ə “dɔkagilo nden” kɨ elta’a kin me’ə nan ri tɔ wa? Jɨ gər me ta kɨ ge kel’je kin el!» ");
INSERT INTO gqr_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Lokɨ Jeju gər kadɨ njendo’gɨ li’ə isɨ sangi kadɨ dəji’ə ta ə, el’de ene: «Sii dəji nan ta dann’se’tɨ ɔjidɔ ta kɨ m’el’se m’ene: “Nanyi dɔkagilo nden ba kadɨ a oyi m’in el, ningə dɔkagilo nden go’tɨ ə, a təli oyi m’in gogɨ,” kin. ");
INSERT INTO gqr_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Nga ningə, tokɨ rɔta’tɨ, adɨ m’el’se: A nonyi ge, a ndingəi ndoo ge, nan de’gɨ kɨ dɔnangɨ’tɨ ne a rai rɔnel. Me kon a ra’se, nan me kon lə’se kin a təl rɔnel. ");
INSERT INTO gqr_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Lokɨ dene aw to ojɨ ngonn ə, in me kon’tɨ, tadɔ dɔkagilo kon li’ə re, nan lokɨ ngonn te rɔ’a’tɨ nga ningə, me’ə oy dɔ kon’tɨ, tadɔ rɔnel de kɨ oj’o il’ə dɔnangɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ningə, ingɨ kaa, kɨ ngɔsine kin, in me kon’tɨ, nan m’a m’təl m’oo’se, kadɨ rɔnel a rosɨ me’se, ningə in rɔnel kɨ de a ɔr me’se’tɨ gogɨ el. ");
INSERT INTO gqr_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ndɔ’a’tɨ kin, a dəji m’in ta dɔ nya madɨ’tɨ el nga. Ningə, tokɨ rɔta’tɨ, adɨ m’el’se, Bai a adɨ’se nya’gɨ pətɨ kɨ dəji’ə me tɔ’m’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Bitɨ ɓone kaa, dəji nya madɨ me tɔ’m’tɨ el ɓay. Dəji ə a ingəi, kadɨ rɔnel lə’se asɨ nan rerere. ");
INSERT INTO gqr_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","«M’el’se ta’gɨ kin me kujita’tɨ, nan ndɔ’gɨ a rei non kadɨ m’a m’el’se ta me kujita’tɨ el nga, nan m’a m’el’se ta kɨ dɔ Bai Luwə’tɨ taga wangɨ. ");
INSERT INTO gqr_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","In dɔ ndɔ’a’tɨ kin, a dəji nya Bai me tɔ’m’tɨ, ningə m’a m’el’se el, tokɨ m’njɨ m’elta kɨ Bai tadɔ lə’se, ");
INSERT INTO gqr_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","tadɔ Bai Luwə ə inɓe ndigɨ’se. Luwə ndigɨ’se, tadɔ in ndigi m’in, taa uni me’se adi tokɨ m’ində rɔ’a’tɨ ə m’re tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","M’ində rɔ Bai’tɨ ə m’re dɔnangɨ’tɨ ne, ningə kɨ ngɔsine kin, m’a m’inyə dɔnangɨ ə m’təl m’aw rɔ Bai’tɨ gogɨ.» ");
INSERT INTO gqr_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ə njendo’gɨ li’ə eli eyina: «Oo, kɨ ne kin, nyɨ in el’je ta taga wangɨ um me kujita’tɨ el nga kin. ");
INSERT INTO gqr_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ningə kɨ ngɔsine kin, jɨ gər kadɨ in gər nya’gɨ pətɨ, taa ta’gɨ kɨ to me de’tɨ ɓay, kadɨ to de dəji kaa in gər kete. Lo kin’tɨ, j’uni me’je tokɨ in rɔ Luwə’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ə Jeju ilə’de’tɨ ene: «Uni me’se adi’m’in nga wa? ");
INSERT INTO gqr_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Oyi, dɔ kadɨ isɨ re, ningə kɨ ne kin, re te ne nga kɨ kadɨ de’gɨ a sananyi’se kɨ lo kare kare. A inyəi m’in kɨ kar’m, nan m’in kɨ kar’m el, tadɔ Bai Luwə in sə’m nan’tɨ ne. ");
INSERT INTO gqr_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","M’el’se ta’gɨ kin pətɨ be, kadɨ lapiya in me’se’tɨ, me kində rɔ nan’tɨ sə’m. A ingəi kon dɔnangɨ’tɨ ne, nan kadɨ uwəi tɔgɨ’se ba, tadɔ m’tətɨ rɔ nje tɔgɨ’gɨ kɨ dɔnangɨ’tɨ ne nga.» ");
INSERT INTO gqr_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Go ta’tɨ kɨ Jeju el kin ə, un kum’ne kɨ taa dɔran’tɨ, ningə el ene: «Bai, dɔkad’a re nga. Tɔjɨ tɔɓar lə’m, m’in Ngonn’i kɨ taga adɨ de’gɨ gəri, kadɨ to m’in Ngonn’i, m’tɔjɨ tɔɓar lə’i kɨ taga madɨ de’gɨ gəri tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","In, adɨ’m tɔgɨ dɔ de’gɨ’tɨ pətɨ, kadɨ to m’adɨ nje kɨ inyə’de ji’m’tɨ, si kɨ dɔ’de taa bitɨ kɨ non’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Kisikidɔtaa bitɨ kɨ non’tɨ, in ta kadɨ de gəri, in kɨ in kɨ kar’i ba ə in Luwə kɨ rɔta’tɨ kin num, kadɨ gər Jeju Kirisitɨ kɨ in de kɨ ulə kin num. ");
INSERT INTO gqr_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","M’tɔjɨ tɔɓar lə’i m’adɨ de’gɨ kɨ dɔnangɨ’tɨ ne pətɨ gəri, ningə kulə kɨ adɨ’m kadɨ m’ra kaa m’tɔl ta’a majɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Kɨ ngɔsine kin, Bai, m’dəj’i kadɨ adɨ m’ingə kɔsikurə takum’i’tɨ tokɨ ndɔkɨ adɨ’m kete non kində dɔran’tɨ, kɨ dɔnangɨ’tɨ kin. ");
INSERT INTO gqr_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","«M’a m’adɨ de’gɨ kɨ ɔy’de dann madɨ’de’gɨ’tɨ kɨ dɔnangɨ’tɨ ne, adɨ’m kin gəri’nu. In de’gɨ lə’i, ə inyə’de me ji’m’tɨ, ningə təli rɔ’de majɨ go ta’tɨ lə’i. ");
INSERT INTO gqr_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Kɨ ngɔsine kin, gəri kadɨ nya’gɨ pətɨ kɨ adɨ’m, in rɔ’i’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Tadɔ m’adɨ’de ta’gɨ kɨ adɨ’m’de, ningə taai. Lokɨ taai ə, gəri kadɨ m’ində rɔ’i’tɨ, adɨ uni me’de tokɨ in in ə ulə’m. ");
INSERT INTO gqr_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ningə in tadɔ lə’de ə m’el sə’i ta. M’el sə’i ta tadɔ lə de’gɨ kɨ dɔnangɨ’tɨ ne el, nan tadɔ lə nje kɨ inyə’de me ji’m’tɨ, tadɔ nje kɨ inyə’de me ji’m’tɨ kin in de’gɨ lə’i. ");
INSERT INTO gqr_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ningə nya’gɨ pətɨ kɨ in yan’m, in yan’i, ə nya’gɨ pətɨ kɨ in yan’i, in yan’m tɔ. Nga ningə, ingɨ, tɔji tɔɓar lə’m kɨ taga adi de’gɨ oyi. ");
INSERT INTO gqr_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","M’in, m’a m’in dɔnangɨ’tɨ ne el nga, m’njɨ m’aw kɨ rɔ’i’tɨ, nan in kɨ dɔnangɨ’tɨ ne ɓay. Be ə, Bai Luwə kɨ nje kar njay, m’dəj’i kadɨ ində kum’i go’de’tɨ majɨ. Ində kum’i go’de’tɨ kɨ tɔgɨ lə’i, kɨ in tɔgɨ kɨ adɨ’m m’ra’n kulə kin, kadɨ to in kareba tokɨ j’in sə’i j’in kareba kin be tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Dɔkagilo kɨ m’in se’de, m’ində kum go’de’tɨ majɨ kɨ tɔgɨ lə’i kɨ adɨ’m. M’dow bagɨ’m dɔ’de’tɨ, adɨ de kare kaa nanyi kɔ el. De ə, in in kɨ majɨ kadɨ a tujɨ kadɨ to ta kɨ ndangi me makitu’tɨ lə Luwə tɔl’n ta’ne kakin par. ");
INSERT INTO gqr_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Nga ningə, kɨ ngɔsine kin, m’njɨ m’aw kɨ rɔ’i’tɨ, ə m’elta kin be tokɨ m’in’n se’de dɔnangɨ’tɨ ne ɓay kin, kadɨ to inɓe’gɨ ingəi rɔnel kɨ me’m’tɨ, kɨ in rɔnel kɨ asɨ nan rerere kin. ");
INSERT INTO gqr_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","M’adɨ’de ta lə’i ningə, de’gɨ kɨ dɔnangɨ’tɨ ne ɔsi’de ta tadɔ k’in kɨ in de’gɨ kɨ dɔnangɨ’tɨ ne el, tokɨ m’in m’in’n de kɨ dɔnangɨ’tɨ ne el kin be tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Nga ningə, m’dəj’i kadɨ ɔy’de kɔ dɔnangɨ’tɨ ne el, nan kadɨ ɔsi Su ngərəngɨ dɔ’de’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","In de’gɨ kɨ dɔnangɨ’tɨ ne el, tokɨ m’in m’in’n de kɨ dɔnangɨ’tɨ ne el kin be tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Majɨ kadɨ un’de kɨ ta kɨ rɔta’tɨ, ində taa dangɨ to de’gɨ lə’i. Ta lə’i in ta kɨ rɔta’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ningə, m’in kaa, m’ulə’de dɔnangɨ’tɨ, tokɨ ulə’m dɔnangɨ’tɨ kakin be tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","M’inɓe, m’un rɔ’m m’ində ta dangɨ to de lə’i tadɔ lə’de, kadɨ to ingɨ kaa, in kɨ kində ta dangɨ me ta kɨ rɔta’tɨ to de’gɨ lə’i tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","«M’el sə’i ta tadɔ lə nje kɨ m’ulə’de kin par el, nan tadɔ lə de’gɨ pətɨ kɨ a uni me’de adɨ’m’in, kɨ gorow lə ta kɨ a te ta nje’gɨ’tɨ kɨ m’ulə’de. ");
INSERT INTO gqr_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","M’dəj’i kadɨ pətɨ, təli de’gɨ kɨ kare, tokɨ in Bai, ində rɔ’i nan’tɨ sə’m, ə m’in m’ində rɔ’m nan’tɨ sə’i kin be. Kadɨ ingɨ kaa indəi rɔ’de nan’tɨ se’je tɔ, kadɨ to de’gɨ kɨ dɔnangɨ’tɨ ne uni me’de adi tokɨ in in ə ulə’m. ");
INSERT INTO gqr_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","M’in m’adɨ’de kɔsikurə kɨ taa, kadɨ to in de’gɨ kɨ kare, tokɨ j’in sə’i j’in’n de’gɨ kɨ kare kin be tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","M’in m’ində rɔ’m nan’tɨ se’de, ningə in, ində rɔ’i nan’tɨ sə’m tɔ; ə lo kin’tɨ, a asi kadɨ in de’gɨ kɨ kareba kɨ rɔta’tɨ, kadɨ de’gɨ kɨ dɔnangɨ’tɨ ne gəri tokɨ in in ə ulə’m num, in ndigɨ’de tokɨ in ndigɨ’m be num tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Oyo, Bai, nje kɨ adɨ’m’de kin, m’ndigɨ ngayn kadɨ in sə’m nan’tɨ, lo’tɨ kɨ m’a m’in’tɨ, kadɨ oyi kɔsikurə kɨ m’aw’n, kɔsikurə kɨ in taa. M’el m’ene taa kɔsikurə, tadɔ in ndigɨ’m kete non kində dɔran’tɨ kɨ dɔnangɨ. ");
INSERT INTO gqr_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Bai kɨ njera nya kɨ dana, de’gɨ kɨ dɔnangɨ’tɨ ne gəri nu el, nan m’in m’gər’i, taa nje kɨ adɨ’m’de kaa gəri tokɨ in in ə ulə’m tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","M’a m’adɨ gəri’nu, ningə m’a m’adɨ gəri’nu kɨ kete ɓay, kadɨ to ko ndigɨ kɨ in ndigɨ’m kin to me’de’tɨ num, kadɨ m’inɓe m’in nan’tɨ se’de num tɔ.» ");
INSERT INTO gqr_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Go ta’tɨ kɨ Jeju el kɨ Luwə kin ningə, ɔti kɨ njendo’gɨ lə’ne, ali dɔ lo, awi dow ngonn mann’tɨ madɨ kɨ ɓari’ə Sedron. Low’ə’tɨ kin, lo ndɔɔ kɨ de man kagɨ’gɨ’tɨ to non, ə uri me’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judasɨ kɨ njekundɔ Jeju, gər lo kin majɨ, tadɔ in lo kɨ Jeju in kɨ njendo’gɨ lə’ne isɨ rei’tɨ taa taa. ");
INSERT INTO gqr_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","In be ə, Judasɨ un dɔ kutɨ njerɔ’gɨ lə nje konɓe kɨ Rɔm, aw se’de low’ə’tɨ kakin. Taa kibo’gɨ lə njekujənyamosɨ kadikare’gɨ kɨ Parisɨ’gɨ, uləi njengəm takəy lə Luwə adɨ in se’de non tɔ. De’gɨ kigo Judasɨ’tɨ kin oti kiyərɔ’gɨ kɨ lambɨ’gɨ kɨ por ngəl’gɨ. ");
INSERT INTO gqr_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Lo kin’tɨ, Jeju kɨ gər nya pətɨ kɨ a re dɔ’a’tɨ, ɔtɨ kɨ rɔ’de’tɨ, dəjɨ’de ene: «Sii sangi nan wa?» ");
INSERT INTO gqr_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ningə ingɨ iləi’ə’tɨ eyina: «J’isi jɨ sangɨ Jeju kɨ Najaretɨ’tɨ.» Ə Jeju el’de ene: «In m’inɓe ə m’ra am.» Judasɨ inɓe kɨ njekulə Jeju kakin ji’de’tɨ kaa ra se’de non tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Lokɨ Jeju el’de ene: «In m’inɓe ə m’ra am» kin ə, gadi gogɨ, ningə tei tosi. ");
INSERT INTO gqr_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Jeju təl dəjɨ’de ɓay ene: «Sii sangi nan wa?» Ningə ingɨ iləi’ə’tɨ eyina: «J’isi jɨ sangɨ Jeju kɨ Najaretɨ’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ə Jeju el’de ene: «M’el’se m’ene, in m’inɓe ə m’ra am. Ə re in m’in ə isɨ sangi m’in ə, inyəi ndəgɨ de’gɨ kam adɨ awi.» ");
INSERT INTO gqr_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","To be kadɨ ta kɨ te ta Jeju’tɨ kɨ rɔ Baw’a Luwə’tɨ ene: «Nje kɨ adɨ’m’de, de kare kaa nanyi kɔ el» kin, tɔlta’ne. ");
INSERT INTO gqr_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simon Piyər ɔr kiyərɔ kɨ ulə saw’a’tɨ rɔ’ne’tɨ, tugə’n mbi paja lə kibo lə njekujənyamosɨ kadikare’gɨ. Tugə mbi’ə kɨ dɔjikɔl’ɔ’tɨ batɨ gangɨ. Tɔ paja kakin nan Malkusɨ. ");
INSERT INTO gqr_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ə Jeju el Piyər ene: «Ulə kiyə lə’i saw’a’tɨ gogɨ! Oo kadɨ m’a m’anyi kɔpɨ kon kɨ Bai adɨ’m kin el wa?» ");
INSERT INTO gqr_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Kutɨ njerɔ’gɨ lə nje konɓe kɨ Rɔm, nan’tɨ kɨ njekundɔ’de num, kɨ njengəm ta Kəy lə Luwə kɨ Juwipɨ’gɨ uləi’de kakin num, uwəi Jeju dɔi’ə. ");
INSERT INTO gqr_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Dɔ kete, awi si’ə ɓe lə Hann kɨ in məm Kayipɨ. Kayipɨ ə in kibo lə njekujənyamosɨ kadikare’gɨ ɓal’a’tɨ kin. ");
INSERT INTO gqr_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Nga ningə in darɔ Kayipɨ inɓe kin ə in nje kel Juwipɨ kene: «In sotɨ ngayn tadɔ lə’se kadɨ ba kal de kare oy tadɔ lə ginn bulə de’gɨ.» ");
INSERT INTO gqr_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simon Piyər in kɨ njendo kare kɨ dann njendo’gɨ’tɨ lə Jeju, uni go Jeju. Njendo kare kɨ in kɨ Piyər kakin gər kɨ kibo lə njekujənyamosɨ kadikare’gɨ, adɨ ur natɨ kəy’tɨ lə kibo lə njekujənyamosɨ kadikare’gɨ, nan’tɨ kɨ Jeju kɨ uri si’ə kəy. ");
INSERT INTO gqr_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Piyər ə isɨ yan’ne taga, ndəkba takəy’tɨ. Lo kin’tɨ, njendo kɨ kibo lə njekujənyamosɨ kadikare’gɨ gər’ə kakin, te taga, elta kɨ dene kɨ njengəm takəy, ə go’tɨ, dene inyə Piyər ad’a ur kəy. ");
INSERT INTO gqr_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Dene kɨ njengəm takəy kakin el Piyər ene: «In kaa in dann njendo’gɨ’tɨ lə dingəm kin tɔ el wa?» Ə Piyər ilə’tɨ ene: «Jagɨ, m’in se’de el.» ");
INSERT INTO gqr_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Kul on, adɨ nje ra kulə’gɨ kɨ njengəm ta lo’gɨ, iləi por ra nduwi. Piyər kaa ra se’de ta por’tɨ kakin non, a nduw se’de tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","*Kibo lə njekujənyamosɨ kadikare’gɨ dəjɨ ta Jeju dɔ njendo’gɨ’tɨ li’ə kɨ dɔ nyando’tɨ li’ə kɨ isɨ ndo de’gɨ. ");
INSERT INTO gqr_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ə Jeju ilə’tɨ ene: «M’elta de’gɨ taga wangɨ, taa kɨ ndɔ’gɨ, ndɔ’gɨ, m’njɨ m’ndo nya de’gɨ ginn kəykawnan’gɨ’tɨ lə Juwipɨ’gɨ num, ginn Kəy’tɨ lə Luwə num, kɨ in lo’gɨ kɨ dɔ Juwipɨ’gɨ pətɨ isɨ ɔsi nan’tɨ. Nya madɨ kɨ m’el lo kiyə’tɨ goto. ");
INSERT INTO gqr_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Nga ra bann ə dəjɨ’m ta ɓay wa? Dəji ta nje kɨ isɨ oyi m’in lo kelta’tɨ kin oyi, gəri ta kɨ m’njɨ m’el’de majɨ ngayn.» ");
INSERT INTO gqr_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Dɔ ta’tɨ kin, njengəm ta lo kare kɨ ra se’de non, ində kɔtɨ Jeju, ə el’ə ene: «Adɨ in be ə kadɨ tur’n ta adɨ kibo lə njekujənyamosɨ kadikare’gɨ’tɨ wa?» ");
INSERT INTO gqr_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ə Jeju ilə’tɨ ene: «Kin ə re ta kɨ m’el kin, majel ə, ɔjɨ maj’a el adɨ’m m’oo, a re m’el majɨ tɔ ə, ra bann be ə ində’m wa?» ");
INSERT INTO gqr_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Lo kin’tɨ, Hann adɨ awi kɨ Jeju kɨ dɔ kɨ dɔi’ə kin be ɓe lə Kayipɨ, kɨ in kibo lə njekujənyamosɨ kadikare’gɨ. ");
INSERT INTO gqr_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Piyər isɨ ta por’tɨ non, isɨ nduw por, ə eli’ə eyina: «Man, in kaa in dann njendo’gɨ’tɨ li’ə tɔ el wa?» Nan Piyər manjɨ ene: «Jagɨ, m’in se’de el.» ");
INSERT INTO gqr_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Kɨ kare dann njerakulə’gɨ’tɨ lə kibo lə njekujənyamosɨ kadikare’gɨ kɨ in noji dingəm kɨ Piyər tugə mbi’ə gangɨ, el Piyər ene: «De kɨ m’oo’ə si’ə, lo ndɔɔ’tɨ kɨ me kagɨ’gɨ’tɨ kin, in in el ə in nan?» ");
INSERT INTO gqr_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Nan Piyər manjɨ inɓe ɓay. Ningə tanan’tɨ non, kunə kunjə non. ");
INSERT INTO gqr_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Lokɨ in kɨ Jeju ɓe lə Kayipɨ ə, awi si’ə kəy’tɨ kɨ boi lə nje konɓe kɨ Rɔm’tɨ. In sin ba ɓay. Ningə njekundɔ Juwipɨ’gɨ mbeti kur me kəy kɨ boi’tɨ, kadɨ to n’təli kɨ njen, takum Luwə’tɨ, kadɨ to n’usɔi nya lo ra nanyi Pakɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","In tadɔ kin ə, *Pilatɨ te ingə’de taga, ningə dəjɨ’de ene: «In ri ə səki dingəm kam wa?» ");
INSERT INTO gqr_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ningə, ingɨ iləi’ə’tɨ eyina: «Kin ə re in de kɨ njera nya kɨ majel el ə, re j’a jɨ re si’ə, j’ulə ji’i’tɨ el.» ");
INSERT INTO gqr_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ə Pilatɨ el’de ene: «Inɓe’gɨ, taai’ə, awi gangi ta dɔ’a’tɨ kigo ndukun’gɨ’tɨ lə’se, in Juwipɨ’gɨ.» Nan eli Pilatɨ eyina: «J’in, de adɨ’je tarow kɨ kadɨ jɨ gangi’n ta koy dɔ de’tɨ el.» ");
INSERT INTO gqr_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","In be ə, ta kɨ Jeju inɓe el kadɨ tɔjɨ’n napar koy kɨ n’a n’oy kin tɔlta’ne. ");
INSERT INTO gqr_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilatɨ təl ur me kəy’tɨ kɨ boi, ɓar Jeju, ningə dəj’ə ene: «In ngar lə Juwipɨ’gɨ wa?» ");
INSERT INTO gqr_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ə Jeju ilə’tɨ ene: «Inɓe kɨ dɔi ə elta kin be eke de’gɨ kɨ rangɨ ə eli’nu ta kin ɔjidɔ’m wa?» ");
INSERT INTO gqr_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ningə Pilatɨ el Jeju ene: «M’in kɨ oo’m kin m’in Juwipɨ wa? In de’gɨ kɨ ginn ɓe’tɨ lə’i inɓe num, kibo’gɨ lə njekujənyamosɨ kadikare’gɨ num, ə rei uləi’nu ji’m’tɨ! Nga ningə m’dəj’i ke in ri inɓe ə in ra wa?» ");
INSERT INTO gqr_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ə Jeju el’ə ene: «M’in ngar kɨ dɔnangɨ’tɨ ne el, re m’in ngar kɨ dɔnangɨ’tɨ ne ə, re de’gɨ kɨ go’m’tɨ, a rɔ’i dɔ’m’tɨ kadɨ de ulə’m ji njekundɔ Juwipɨ’gɨ’tɨ el; nan k’in ə m’in ngar kɨ dɔnangɨ’tɨ ne el.» ");
INSERT INTO gqr_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ningə Pilatɨ dəj’ə ene: «Adɨ in ngar ta?» Ningə Jeju el’ə ene: «In ta kɨ in ə te tai ene m’in ngar. M’in, oji m’in, ningə m’re dɔnangɨ’tɨ ne kadɨ m’man najɨ dɔ nya kɨ rɔta’tɨ. Nga ningə, de kɨ in me nya kɨ rɔta’tɨ, təl rɔ’ne go ta’tɨ lə’m.» ");
INSERT INTO gqr_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Lo kin’tɨ, Pilatɨ dəj’ə ene: «In ri ə in nya kɨ rɔta’tɨ wa?» Go ta’tɨ kɨ Pilatɨ dəjɨ kin ə, təl te taga rɔ Juwipɨ’gɨ’tɨ el’de ene: «M’ingə ta madɨ kare kɨ kadɨ m’gangɨ’n ta dɔ de’tɨ kin el. ");
INSERT INTO gqr_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Nga ningə, kigo jibəl ra’a’tɨ kɨ isɨ rai kete, kete, ə dɔkagilo ra nanyi Pakɨ ə, m’inyə dangay kare taa m’adɨ’se kin, in ndigɨ dɔ’tɨ kadɨ m’inyə ngar lə Juwipɨ’gɨ taa madɨ’se wa?» ");
INSERT INTO gqr_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Nan ingɨ, uni ndu’de kɨ taa eli eyina: «Jagɨ, in el, in Barabasɨ ə jɨ ndigɨ kadɨ inyə taa.» Barabasɨ kɨ elita li’ə kin, in baw kaya. ");
INSERT INTO gqr_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Pilatɨ adɨ ndu’ne njerɔ’gɨ kadɨ awi kɨ Jeju, ningə kadɨ indəi’ə kɨ ndəy hawlay. ");
INSERT INTO gqr_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Njerɔ’gɨ oji jɔgɨ konn, uləi dɔ’a’tɨ, ningə uləi ku ngal kɨ kər njir njir rɔ’a’tɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ɔti rei rɔ’a’tɨ, ningə eli’ə eyina: «Lapiya, ngar lə Juwipɨ’gɨ!» Ningə ɓuki ji’de kɔt’ɔ’tɨ, indəi’ə. ");
INSERT INTO gqr_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Nja kare ɓay, Pilatɨ te rɔ bulə de’gɨ’tɨ el’de ene: «Majɨ, m’a m’re si’ə taga rɔ’se’tɨ ne, kadɨ in gəri tokɨ m’ingə ta madɨ kare kɨ kadɨ m’gangɨ’n ta dɔ’a’tɨ el.» ");
INSERT INTO gqr_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Lo kin’tɨ non be, Jeju te taga kɨ jɔgɨ kon dɔ’ne’tɨ num, kɨ ku ngal kɨ kər njir njir rɔ’ne’tɨ num. Ningə Pilatɨ el’de ene: «Dingəm kaa nyɨ ra am!» ");
INSERT INTO gqr_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Nan lokɨ, kibo’gɨ lə njekujənyamosɨ kadikare’gɨ kɨ njengəm ta lo’gɨ lə Juwipɨ’gɨ, oyi’ə ə, uləi bilə eli eyina: «In ɓər’ə kagidəsɨ’tɨ! in ɓər’ə kagidəsɨ’tɨ!» Ə Pilatɨ el’de ene: «Inɓe’gɨ, in taai’ə, awi in ɓəri’ə kagidəsɨ’tɨ, tadɔ m’in, m’ingə ta madɨ kɨ asɨ kadɨ m’gangɨ’n ta koy dɔ’a’tɨ el.» ");
INSERT INTO gqr_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ningə Juwipɨ’gɨ eli Pilatɨ eyina: «J’aw kɨ ndukun kare non, ə kigo ndukun’tɨ kakin, in de kɨ sɔw dɔ koy, tadɔ el ene n’in Ngonn lə Luwə.» ");
INSERT INTO gqr_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Lokɨ Pilatɨ oo ta kin ə, ad’a ɓol kɨ dɔ mad’a’tɨ ɓay, ");
INSERT INTO gqr_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","ə təl ur me kəy’tɨ kɨ boi, ningə dəjɨ Jeju ene: «In, in ra wa?» ");
INSERT INTO gqr_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Nan Jeju ilə ta’tɨ el. Ə Pilatɨ el Jeju ene: «M’in ə m’dəj’i ta ə ilə’m’tɨ el wa? In gər kadɨ m’aw kɨ tɔgɨ kadɨ m’ge ə m’inyə’i taa num, m’ge ə m’ɓər’i kagidəsɨ’tɨ num, eke in gər el wa?» ");
INSERT INTO gqr_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jeju ilə’tɨ ene: «Kin ə re in tɔgɨ kɨ Luwə inɓe ə adɨ dɔran’tɨ nu kin el ə, aw kɨ tɔgɨ madɨ kare dɔ’m’tɨ el. Ningə in tadɔ kin ə, de kɨ njekulə’m ji’i’tɨ, majel li’ə in ngayn utə yan’i.» ");
INSERT INTO gqr_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Dɔ ta’tɨ inɓe kin ə, Pilatɨ sangɨ kadɨ n’inyə Jeju, nan Juwipɨ’gɨ uri kɔl, ə eli’ə eyina: «Kin ə re inyə taa ə, in madɨ Sejar kɨ in ngar kibo kin el. De kɨ ene n’in ngar ə, de’ə kin in nje ta lə Sejar.» ");
INSERT INTO gqr_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Lokɨ Pilatɨ oo ta kin ə, adɨ awi kɨ Jeju taga, ningə inɓe isɨ dɔ kumbər ngar’tɨ, lo’tɨ kɨ ɓari’ə Gajɨ mbal’gɨ kɨ kində nanga, kɨ ta Ebirə ene «Gabata». ");
INSERT INTO gqr_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","In ndɔ kɨ kadɨ lo ti par ə in kulə ngirə ra nanyi Pakɨ, ningə in kadɨ kɨ jam dɔ ɓe’tɨ be. Ə Pilatɨ el Juwipɨ’gɨ ene: «Oyi ngar lə’se.» ");
INSERT INTO gqr_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Nan uni ndu’de kɨ taa eli eyina: «Kadɨ oy kɔ! Kadɨ oy kɔ! Ɓər’ə kagidəsɨ’tɨ!» Ə Pilatɨ el’de ene: «Kadɨ to m’ɓər ngar lə’se kagidəsɨ’tɨ wa?» Ningə kibo’gɨ lə njekujənyamosɨ kadikare’gɨ eli eyina: «De oo ngar lə’je kɨ rangɨ el, ngar lə’je in Sejar par.» ");
INSERT INTO gqr_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Lo kin’tɨ, Pilatɨ ulə Jeju ji’de’tɨ kadɨ ɓəri’ə kagidəsɨ’tɨ. Njerɔ’gɨ uwəi Jeju awi si’ə. Njerɔ’gɨ uwəi Jeju awi si’ə. ");
INSERT INTO gqr_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Inɓe otɨ kagidəsɨ lə’ne, te’n gidɨ ɓebo’tɨ kɨ taga, kadɨ awɨ’n lo’tɨ kɨ to to «Ka dɔ de», kɨ ta Ebirə ene «Golgota.» ");
INSERT INTO gqr_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","In low’ə’tɨ kin ə njerɔ’gɨ ɓəri Jeju’tɨ, kagidəsɨ’tɨ. Ɓəri de’gɨ joo kagidəsɨ’tɨ si’ə, kɨ kare dɔjikɔl’ɔ’tɨ, ə kɨ kare dɔjigəl’ə’tɨ tɔ, ningə inɓe ra dana. ");
INSERT INTO gqr_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilatɨ adɨ rai ngonn bar, ndangi nya me’tɨ, indəi taa dɔ kagidəsɨ kɨ Jeju ra’tɨ. Nya kɨ ndangi me’tɨ nan: «Jeju kɨ Najaretɨ’tɨ, ngar lə Juwipɨ’gɨ.» ");
INSERT INTO gqr_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Lokɨ ɓəri Jeju’tɨ, kagidəsɨ’tɨ kakin in ndəkba kɨ ɓebo, adɨ Juwipɨ’gɨ ngayn tudəi nya kɨ ndangi kin. Ndangi kɨ ta Ebirə num, kɨ ta Laten num, taa kɨ ta Girekɨ num tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ə kibo’gɨ lə njekujənyamosɨ kadikare’gɨ eli Pilatɨ eyina: «Nya kin, majɨ kadɨ re a ndangɨ “ngar lə Juwipɨ’gɨ” be el, nan re a ndangɨ “dingəm kam el ene n’in ngar lə Juwipɨ’gɨ” taa in gorow’ə’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Nan Pilatɨ el’de ene: «Nya kɨ m’ndangɨ ningə, ndang’a kaa m’ndangɨ kin.» ");
INSERT INTO gqr_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Lokɨ njerɔ’gɨ ɓəri Jeju kagidəsɨ’tɨ ginn’ə gangɨ ningə, ɔyi ku’gɨ li’ə, kanyi ginn sɔ, sɔw dɔ’de kare kare. Ningə nanyi ku ngal kɨ de ur el, nan oji tanan’tɨ be par, ində taa re nanga. ");
INSERT INTO gqr_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ə njerɔ’gɨ elinan eyina: «Adɨ jɨ tili ku ngal kin el, nan adɨ jɨ tugəi kiri mbara dɔ’tɨ j’oyi ke nan ə a in yan’a wa.» Ningə in nya kɨ a to be kadɨ ta kɨ ndangi me makitu’tɨ lə Luwə eyina: «Kanyinan ku’gɨ li’ə, Ningə tugəi kiri mbara dɔ ku ngal’tɨ li’ə tɔ» kin tɔlta’ne. Ningə in nya’a kaa nyɨ njerɔ’gɨ rai kin. ");
INSERT INTO gqr_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Kon Jeju in kɨ ngonnkon’ne kɨ dene num, Mari kɨ ne Kilewopasɨ num, taa Mari kɨ Magidala num rai non, ndəkba kadɨ kagidəsɨ’tɨ kɨ ɓəri Jeju’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Lokɨ Jeju oo kon’ne, ə oo njendo kɨ Jeju ndig’ə, ra gəd’ə’tɨ ə, el kon’ne ene: «Dene, oo ngonn’i ə ra am.» ");
INSERT INTO gqr_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ningə go’tɨ, el njendo kakin ene: «Oo kon’i ə ra am.» Ningə, ndɔ’a’tɨ non, njendo kakin aw kɨ kon Jeju rɔ’ne’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Go nya’gɨ’tɨ kin, Jeju gər kadɨ ginn nya’gɨ pətɨ gangɨ nga ə, elta kin kadɨ tɔlta ta kɨ ndangi me makitu’tɨ lə Luwə ene: «Kundə ra’m.» ");
INSERT INTO gqr_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ngoo kɨ yiwi kandɨ nju kɨ masɨ rosɨ isɨ non, ə njerɔ’gɨ nduyi nya kɨ to hem hem me yiwi nju’tɨ kɨ masɨ kakin, uləi ta kagɨ’tɨ kɨ ɓari’ə ijopɨ, ə uləi ta Jeju’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ə lokɨ Jeju njuw yiwi kandɨ nju kɨ masɨ kakin ningə, el ene: «Ginn nya’gɨ pətɨ gangɨ nga», ə ulə dɔ’ne nanga, ningə kon li’ə te. ");
INSERT INTO gqr_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","In ndɔ kɨ kadɨ lo ti dɔ’tɨ ə, in ndɔ kɔrkon. In ndɔ kɔrkon kɨ to ta dangɨ, ə, kadɨ to ninn’gɨ rai dɔ kagidəsɨ’tɨ ba ndɔ kɔrkon’tɨ el, Juwipɨ’gɨ awi dəji Pilatɨ kadɨ adɨ budi nja’de, ə ɔri’de kɔ dɔ kagidəsɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Lo kin’tɨ, njerɔ’gɨ awi budi nja de kɨ dɔkete num, in kɨ nja joo num, kɨ ɓəri’de dɔ kagidəsɨ’tɨ nan’tɨ kɨ Jeju. ");
INSERT INTO gqr_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Lokɨ rei tei dɔ Jeju’tɨ ə, oyi kadɨ in oy nga, adɨ budi nja’a el. ");
INSERT INTO gqr_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ningə njerɔ kare ə ɔsɨ kad’a kɨ ningə, ə tanan’tɨ non, mosɨ kɨ mann tei ta do ningə’tɨ kakin. ");
INSERT INTO gqr_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","De kɨ ɔr go nya’gɨ kin, oo kɨ kum’ne, ningə mannajɨ li’ə in kɨ rɔta’tɨ, taa inɓe gər kadɨ in ta kɨ rɔta’tɨ ə n’el tɔ, kadɨ to ingɨ kaa uni me’se tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Tokɨ rɔta’tɨ, nya’gɨ kin rai nya be kadɨ to ta kɨ ndangi me makitu’tɨ lə Luwə eyina: «Singə kare kaa de a tətɨ el», kin tɔlta’ne. ");
INSERT INTO gqr_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Taa ndangi ta kɨ rangɨ ɓay me makitu’tɨ lə Luwə eyina «A gonyi lo kɨ rɔ de’tɨ kɨ ɔsi kad’a kɨ ningə.» ");
INSERT INTO gqr_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Go nya’gɨ’tɨ kin, Jisepɨ kɨ in de kɨ Arimate’tɨ, aw dəjɨ tarow Pilatɨ kadɨ n’ɔr ninn Jeju. Jisepɨ in njendo lə Jeju kɨ ra rɔ’ne lo kiyə’tɨ, tadɔ ɓol Juwipɨ’gɨ. Pilatɨ ad’a tarow, adɨ Jisepɨ aw ɔr ninn Jeju. ");
INSERT INTO gqr_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodem kɨ ndɔkɨ aw ingə Jeju kondɔ kakin kaa, aw kɨ ndujɨ kagɨ’gɨ kɨ ətɨ majɨ joo tadɔ kɔy rɔ ninn’tɨ. Ndujɨ kagɨ’gɨ kɨ ɓari’de mir in kɨ alowəsɨ, poləi’de nan’tɨ asɨ kiləw dɔmutə be. ");
INSERT INTO gqr_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","De’gɨ kɨ joo kin, uni ninn Jeju, doloi kɨ ta ku len. Lo dole’tɨ, ɓuki ndujɨ kagɨ kɨ ətɨ majɨ səm’tɨ nden, nden, taa doloi, kigo kujɨ ra’a’tɨ lə Juwipɨ’gɨ kɨ isɨ rai kɨ ninn’gɨ lə’de ɓay taa uləi ɓe’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Lo kɨ ɓəri Jeju’tɨ, kagidəsɨ’tɨ kakin, lo to non me kagɨ’gɨ’tɨ, ningə me lo’tɨ kakin, ɓe kɨ to sigɨ, kɨ de ilə ninn’tɨ el ɓay to’tɨ non kadɨ mbal’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Nga ningə, tokɨ kaa kɨ lo ti ə a in ndɔ kɔrkon lə Juwipɨ’gɨ, uləi Jeju me ɓe’tɨ kakin, tadɔ in ndəkba kad’a’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ndɔ Dɔmasɨ kɨ ginn lo, lokɨ lo to pitɨ pitɨ ba ɓay, Mari kɨ Magidala isɨ aw dɔɓadɨ’tɨ ningə, oo mbal kɨ uti ta ɓe ninn kakin, de uwə ɔr. ");
INSERT INTO gqr_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ə Mari anyi ngodɨ, aw ingə Piyər in kɨ njendo kare kɨ Jeju ndig’ə, el’de ene: «Uwəi Burəɓe ɔri’ə ɓadɨ’tɨ, ningə jɨ gər lo kɨ iləi’ə’tɨ el.» ");
INSERT INTO gqr_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Piyər in kɨ njendo kɨ kare kakin tei, isɨ awi kɨ dɔɓadɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Anyinan ngodɨ joo pətɨ, nan njendo kɨ kare kakin anyi ngodɨ utə Piyər, adɨ aw te dɔɓadɨ’tɨ kete non’a’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Lokɨ aw te, ilə kɔtɨ’ne, gon lo ningə, oo ta ku’gɨ kɨ doloi ninn ə rai, nan ur me ɓe ninn’tɨ el. ");
INSERT INTO gqr_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Piyər kɨ in go’ə’tɨ, in yan’ne non re ə, ur me ɓe’tɨ, oo ta ku’gɨ kɨ doloi ninn ə rai, ");
INSERT INTO gqr_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","taa oo ta ku kɨ uləi jam dɔ Jeju’tɨ tɔ ə to. Ta ku’ə kin to nan’tɨ kɨ ingɨ kɨ doloi ninn kin el, nan de ɓir adɨ to yan’ne dangɨ. ");
INSERT INTO gqr_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Go’tɨ, njendo kɨ kare kɨ re kete kakin, ur me ɓe’tɨ tɔ, adɨ oo nya’gɨ kɨ kum’ne num, un me’ne kadɨ in nya kɨ rɔta’tɨ num tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Nga ningə, bitɨ te low’ə’tɨ kin kaa, tujə’de’tɨ kadɨ Jeju a ində taa dann nje koy’gɨ’tɨ el ɓay, tokɨ Makitu lə Luwə el’n ta’a kete kin. ");
INSERT INTO gqr_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","In be ə, njendo’gɨ kɨ joo, təli iləi dɔ’de awi ɓe. ");
INSERT INTO gqr_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Lokɨ njendo’gɨ awi, Mari ra taga, kadɨ ɓadɨ’tɨ ndəkba, ra non. Lokɨ ra non, ilə kɔtɨ’ne gon’n lo ɓe ninn’tɨ ə, ");
INSERT INTO gqr_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","oo malayka’gɨ joo kɨ ɔyi ku kɨ nda, ə kɨ lo’tɨ kɨ kete iləi ninn Jeju’tɨ. Kɨ kare isɨ tor’o’tɨ, kaw kɨ dɔ’a’tɨ, ə in kɨ nungɨ isɨ kaw kɨ nja’a’tɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","*Malayka’gɨ dəji’ə eyina: «Dene, ra bann ə ra non wa?» Ə Mari ilə’de’tɨ ene: «Ɔri Burəɓe lə’m, ningə m’gər lo kɨ iləi’ə’tɨ el.» ");
INSERT INTO gqr_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Lokɨ elta be ningə, ilə rətɨ ə, oo Jeju, nan gər kadɨ in Jeju el. ");
INSERT INTO gqr_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ə Jeju dəj’ə ene: «Dene, ra bann ə ra non wa? Sɨ sangɨ nan wa?» Ningə Mari oo ene in nje ra kulə me ndɔɔ’tɨ kɨ to non kakin wa, adɨ el’ə ene: «Ɓe’m, re in in ə ɔr’ɔ ə, ɔjɨ’m lo kɨ ilə’tɨ, adɨ m’aw m’un’ə.» ");
INSERT INTO gqr_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jeju ɓar’a: «Mari!» Ə Mari yətɨ rɔ’ne kɨ rɔ’a’tɨ, un ndu’ne kɨ taa, el’ə ene: «Rabuni!» kɨ ta Ebirə, kɨ kɔr me’ə nan «Njendo de’gɨ!» ");
INSERT INTO gqr_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Lo kin’tɨ, Jeju el’ə ene: «Ɔdɨ rɔ’m el, tadɔ m’aw dɔran’tɨ rɔ Bai’tɨ el ɓay. Nga ningə, kɨ ngɔsine kin ə, aw rɔ ngannkon’m’gɨ’tɨ, el’de tokɨ m’aw rɔ Bai’tɨ kɨ in Baw’se tɔ kin, m’aw rɔ Luwə’tɨ lə’m kɨ in Luwə lə’se tɔ kin.» ");
INSERT INTO gqr_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ə Mari kɨ Magidala aw ingə njendo’gɨ el’de ene: «M’oo Burəɓe kɨ kum’m!» Ningə el’de ta’gɨ kɨ Jeju el’ə kakin adi’de oyi. ");
INSERT INTO gqr_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ndɔ Dɔmasɨ’tɨ inɓe non losɔl’ɔ, njendo’gɨ kawinan me kəy’tɨ madɨ, ningə uti takəy mbukɨ dɔ’de’tɨ, tadɔ ɓoli njekundɔ Juwipɨ’gɨ. Ə Jeju re, ra taa dann’de’tɨ, el’de ene: «M’dəjɨ kadɨ lapiya in sese!» ");
INSERT INTO gqr_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ningə lo kin’tɨ, tɔjɨ’de tor do kɨ ji’ne’tɨ ge, kadɨ’ne’tɨ ge adi’de oyi. Rɔ njendo’gɨ nəl’de ngayn, lokɨ oyi Burəɓe. ");
INSERT INTO gqr_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jeju təl el’de ɓay ene: «M’dəjɨ kadɨ lapiya in sese! Nga ningə, tokɨ Bai ulə’m, m’in kaa m’ulə’se tɔ.» ");
INSERT INTO gqr_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ningə go ta’gɨ’tɨ kin, Jeju to kon lə’ne dɔ njendo’gɨ’tɨ, ə el’de ene: «Tai Ndil Luwə me’se’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","De’gɨ kɨ a inyəi go majel’gɨ lə’de kɔ, Luwə a inyə go majel’gɨ lə’de kɔ tɔ, ə nje kɨ a mbeti k’inyə go majel’gɨ lə’de kɔ, Luwə a tudə majel’gɨ lə’de dɔ’de’tɨ ba tɔ.» ");
INSERT INTO gqr_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Lokɨ Jeju re rɔ njendo’gɨ’tɨ kin, Tomasɨ kɨ ɓari’ə Ndungə, kɨ in kɨ kare dann njendo’gɨ’tɨ in se’de low’ə’tɨ el. ");
INSERT INTO gqr_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ə ndəgɨ njendo’gɨ eli’ə eyina: «J’oo Burəɓe kɨ kum’je.» Nan Tomasɨ el’de ene: «Kin ə m’oo tor do poyntɨ kɨ ɓəri ji’ə kin el num, m’ulə ngonn ji’m tor poyntɨ’tɨ kin el num, taa m’ulə ji’m m’ɔdɨ’n tor do ningə kɨ ɔsi kad’a kin el num ə, m’a m’un me’m el jagɨ.» ");
INSERT INTO gqr_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ndɔ jijoo go’tɨ, njendo’gɨ təli ingəi nan me kəy’tɨ ɓay, ningə in kin Tomasɨ in se’de nga. Uti takəy mbukɨ dɔ’de’tɨ, ə Jeju re, ra taa dann’de’tɨ, el’de ene: «M’dəjɨ kadɨ lapiya in sese!» ");
INSERT INTO gqr_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ningə el Tomasɨ ene: «Tomasɨ, ulə ngonn ji’i lo kin’tɨ, ə gon ji’m’gɨ kin oo, taa ulə ji’i ɔdɨ’n tor do ningə kɨ kadɨ’m’tɨ kin oo tɔ. Ononyi kadɨ tadɨ, majɨ kadɨ un me’i.» ");
INSERT INTO gqr_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Lo kin’tɨ non, Tomasɨ el Jeju ene: «Burəɓe lə’m! Luwə lə’m!» ");
INSERT INTO gqr_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ə Jeju el’ə ene: «In koo kɨ oo’m kɨ kum’i ne kin ə adɨ un me’i. Ningə adɨ m’el’i m’adɨ in gər tokɨ nje rɔnel’gɨ ə in de’gɨ kɨ uni me’de kɨ kanjɨ koo nya kɨ kum’de.» ");
INSERT INTO gqr_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jeju ra nyakɔjɨ’gɨ kɨ rangɨ ngayn inɓe ɓay takum njendo’gɨ’tɨ lə’ne, kɨ in kɨ ndangɨ me makitu’tɨ kin el. ");
INSERT INTO gqr_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Nan ingɨ kin, in kɨ ndangɨ’de be kadɨ uni me’se tokɨ Jeju in Kirisitɨ kɨ in De kɨ Luwə mbət’ə, in Ngonn lə Luwə. Ningə lokɨ uni me’se ə a ingəi kajɨ kɨ bitɨ kɨ non’tɨ kɨ ta kul’ə. ");
INSERT INTO gqr_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Go’tɨ gogɨ, Jeju təl te ingə njendo’gɨ ɓay ta ba’tɨ kɨ Tiberiyadɨ. Row kɨ te ngə’n’de ə to kin: ");
INSERT INTO gqr_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Ndɔ madɨ, Simon Piyər num, Tomasɨ kɨ ɓari’ə Ndungə num, Nataniyel num kɨ in de’gɨ kɨ Kana’tɨ kɨ Galile tɔ, ngann’gɨ lə Jebede kɨ joo tɔ, njendo’gɨ lə Jeju kɨ rangɨ in joo tɔ sii nan’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ə Simon Piyər el’de ene: «M’a m’aw ba kadɨ m’ndon kanjɨ’gɨ.» Ningə ndəgə’gɨ eli’ə eyina: «J’in kaa j’a j’aw sə’i tɔ.» Ningə tei, ali me to’tɨ awi, nan kondɔ’a’tɨ kin, ngonn kanjɨ kare kaa uwəi el. ");
INSERT INTO gqr_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Lokɨ lo ti, Jeju re ra ta ba’tɨ non, nan njendo’gɨ gəri tokɨ in Jeju el. ");
INSERT INTO gqr_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ə Jeju el’de ene: «Ngann’gɨ, uwəi kanjɨ nden el wa?» Ningə iləi’ə’tɨ eyina: «Jagɨ, ngonn kanjɨ kare kaa j’uwə el.» ");
INSERT INTO gqr_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ningə, Jeju el’de ene: «Iləi bandɨ dow tokibo’tɨ, kɨ dɔjikɔl’se’tɨ kin, ə a uwəi kanjɨ’gɨ.» Ə lokɨ iləi bandɨ ə, bandɨ ɔy kanjɨ kɔy kɨ asi kadɨ ndɔri tei taga el. ");
INSERT INTO gqr_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Lo kin’tɨ, njendo kɨ Jeju ndig’ə el Piyər ene: «In Burəɓe.» Ə lokɨ ta kɨ el ene: «In Burəɓe», kin osɨ mbi Piyər’tɨ taa par ə, Piyər ulə ku lə’ne rɔ’ne’tɨ, tadɔ kete ra kɨ rɔ’ne kare, ningə osɨ me mann’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Lo kɨ rai’tɨ kin, in sanyi el kɨ ngangɨ ba, awi asɨ kulə buy kare be par, adɨ ndəgɨ njendo’gɨ awi kɨ to nden nden kɨ ngangɨ ba’tɨ, ndɔri bandɨ kɨ kanjɨ rosɨ kakin go’de’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Lokɨ uri nanga ningə, oyi por kɨ de ulə kanjɨ’tɨ, taa mapa kaa to non tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jeju el’de ene: «Rei kɨ kanjɨ’gɨ kɨ uwəi’de kakin ne adɨ j’oo.» ");
INSERT INTO gqr_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ə Simon Piyər al me to’tɨ, ndɔr bandɨ kɨ kanjɨ rosɨ kakin nanga. In kanjɨ’gɨ kɨ boi boi inɓe ə in ɓu kɨ dɔ mi gidə in mutə (153). Kɔr’de inɓe kɨ ətɨ ɓol kin ə, bandɨ gangɨ el. ");
INSERT INTO gqr_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jeju el’de ene: «Rei sɔi nya.» Nga ningə, de kare dann njendo’gɨ’tɨ kɨ kadɨ dəjɨ Jeju ene: «In nan wa?» goto, tadɔ gəri majɨ kadɨ in Burəɓe. ");
INSERT INTO gqr_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jeju ɔtɨ rɔ’de’tɨ, un mapa adɨ’de, ningə adɨ’de kanjɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Lokɨ Jeju ində taa dann njekoy’gɨ’tɨ kin, in te kɨ nja mutə nga a te kɨ rɔ njendo’gɨ’tɨ lə’ne kin. ");
INSERT INTO gqr_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Go nya kusɔ’tɨ, Jeju dəjɨ Simon Piyər ene: «Simon kɨ ngonn Jonasɨ, in ndigɨ’m utə nje’gɨ sii kin wa?» Ə Simon ilə’tɨ ene: «Oyo, Burəɓe, in gər kadɨ m’ndigɨ.» Ningə Jeju el’ə ene: «Ul ngann batɨ’gɨ’tɨ lə’m.» ");
INSERT INTO gqr_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jeju təl dəjɨ Simon ɓay kɨ nja joo ene: «Simon kɨ ngonn Jonasɨ, in ndigɨ’m wa?» Ə Simon il’ə’tɨ ene: «Oyo, Burəɓe, in gər kadɨ m’ndig’i.» Ningə Jeju el’ə ene: «Ul batɨ’gɨ’tɨ lə’m.» ");
INSERT INTO gqr_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Jeju təl dəjɨ Simon ɓay kɨ nja mutə ene: «Simon kɨ ngonn Jonasɨ, in ndigɨ’m wa?» Ningə lo kin’tɨ, me Piyər tujɨ dɔ təl’tɨ kɨ Jeju təl dəj’ə ɓay kɨ nja mutə ene: «In ndigɨ’m wa?» kin, adɨ ilə’tɨ ene: «Burəɓe, in gər nya’gɨ pətɨ, in gər kadɨ m’ndig’i.» Ningə Jeju el’ə ene: «Ul batɨ’gɨ’tɨ lə’m. ");
INSERT INTO gqr_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Nga ningə, tokɨ rɔta’tɨ, adɨ m’el’i: dɔkagilo basa’i’tɨ, inɓe dɔɔ ndar ɓəd’i’tɨ, ə aw lokɨ me’i ndigɨ, nan dɔkagilo kɨ a ɓugə ə, a ɔy ji’i taa kadɨ de kɨ rangɨ ə a dɔɔ ndar ɓəd’i’tɨ, ə aw sə’i lo’tɨ kɨ me’i ndigɨ el.» ");
INSERT INTO gqr_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ta’gɨ kin Jeju el be kadɨ tɔjɨ’n gorow koy kɨ Piyər a oy kadɨ ulə’n tɔjɨ dɔ Luwə’tɨ. Go’tɨ, Jeju el’ə ene: «Un go’m.» ");
INSERT INTO gqr_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Piyər ilə rətɨ gogɨ ningə, oo njendo kɨ Jeju ndig’ə, in kɨ ndɔkɨ, lo nyakusɔ’tɨ, ndunə rɔ’ne kɨ dɔ Jeju’tɨ, dəj’ə ene: «Burəɓe, nan ə a uləi ji de’gɨ’tɨ wa?» kakin. ");
INSERT INTO gqr_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Lokɨ Piyər oo’ə ə, dəjɨ Jeju ene: «Burəɓe, ə in kam, in ri ə a ra’a wa?» ");
INSERT INTO gqr_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ə Jeju el Piyər ene: «Kin ə re m’ndig’i kadɨ isɨ kɨ dɔ’ne taa bitɨ kadɨ to m’təl m’re m’ingə’n’ə kaa, in kin ta lə’i goto’tɨ. In, ta lə’i in ta kadɨ un go’m par.» ");
INSERT INTO gqr_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ta kin sanan dann ngannkon’gɨ’tɨ tokɨ njendo kam a oy el. Nan kɨ rɔta’tɨ, kadɨ Jeju el Piyər ene: «A oy el» kin, el’ə be el. Ta kɨ el’ə ə, el’ə ene: «Kin ə re m’ndig’i kadɨ isɨ kɨ dɔ’ne taa bitɨ kadɨ to m’təl m’re m’ingə’n’ə kaa, in kin ta lə’i goto’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","In darɔ njendo’ə inɓe kin ə mannajɨ dɔ nya’gɨ’tɨ kin, ndangɨ’de me makitu’tɨ kin. Nga ningə jɨ gər kadɨ mannajɨ li’ə in ta kɨ rɔta’tɨ. ");
INSERT INTO gqr_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jeju ra nya’gɨ kɨ rangɨ ngayn inɓe ɓay. Re de ene n’ində ta’ne inɓe nəm n’ndangɨ’n’de pətɨ me makitu’gɨ’tɨ ə, m’mər kadɨ dɔnangɨ inɓe kin pətɨ kaa, makitu’gɨ kin a uwə.");
INSERT INTO gqr_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Tewopil, me makitu’tɨ lə’m kɨ dɔkete, m’ndangɨ ta’gɨ kɨ ɔjidɔ nya’gɨ kɨ Jeju ulə ngirə ra ge, ndo de’gɨ ge. ");
INSERT INTO gqr_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Nya’gɨ kɨ ra bitɨ te’n me ndɔ’tɨ kɨ Luwə un’ə’n’ə aw si’ə dɔran’tɨ. Ningə kete ɓay ta kadɨ aw dɔran’tɨ, Jeju mbətɨ njekawkulə’gɨ lə’ne, adɨ’de mbərkikində’gɨ lə’ne kɨ gorow lə Ndil Luwə. ");
INSERT INTO gqr_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Go koy’o’tɨ, Jeju ɔjɨ rɔ’ne njekawkulə’gɨ lə’ne. Ɔjɨ’de kɨ row’gɨ kɨ dangɨ dangɨ kadɨ gəri tokɨ n’ra kɨ dɔ’ne taa. Ndɔ dɔsɔ go’tɨ ningə, te bus kɨ rɔ’de’tɨ el’de ta dɔ Konɓe’tɨ lə Luwə. ");
INSERT INTO gqr_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ndɔ kare kɨ isɨ sɔ nya se’de, Jeju el’de kadɨ tei gidɨ ɓebo Jerujalem’tɨ el. Nan kadɨ nginəi bitɨ kadɨ Baw’ne adɨ’de kadikare kɨ un ndu’ne dɔ’tɨ kadɨ n’a n’adɨ kin ɓay taa. Ningə el’de ene: «In kadikare kɨ m’inɓe m’el’se ta’a kete nga. ");
INSERT INTO gqr_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Jan ra de’gɨ batəm me mann’tɨ, nan ingɨ, me ndɔ’gɨ’tɨ kɨ ngayn el ne ə, a rai’se batəm me Ndil Luwə’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","*Njekawkulə’gɨ lə Jeju kɨ kawinan rɔ’a’tɨ dəji’ə eyina: «Burəɓe, in dɔkagilo’tɨ kɨ ngɔsine inɓe kin ə a taa konɓe adɨ *Isirayel wa?» ");
INSERT INTO gqr_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ə el’de ene: «In ta lə’se kadɨ in gəri dɔ kad’a eke dɔ gangɨ lo’gɨ kɨ Bai ɔjɨ kigo lo tɔgɨ’tɨ lə’ne el.» ");
INSERT INTO gqr_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Nan a ingəi tɔgɨ lokɨ Ndil Luwə a re dɔ’se’tɨ. A təli nje mannajɨ lə’m me ɓebo Jerujalem’tɨ num, dɔnangɨ Jude’tɨ ba pətɨ num, Samari’tɨ num, ratata dɔboy dɔnangɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Lokɨ Jeju el’de ta’gɨ kin ginn’ə gangɨ ningə, oyi’ə isɨ aw kɨ taa me nəl’tɨ. Ningə kilndi re utɨ kum’de adɨ oyi’ə el. ");
INSERT INTO gqr_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Kum’de nanyi kɨ taa dɔran’tɨ, lo koo go Jeju lo kaw’a’tɨ, ningə, dingəm’gɨ joo kɨ uləi ku’gɨ kɨ nda bal bal tei bus kɨ rɔ’de’tɨ, ningə eli’de eyina: ");
INSERT INTO gqr_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","«De’gɨ kɨ Galile’tɨ, tadɔ ri ə rai ra gonyi lo kɨ taa dɔran’tɨ be wa? Darɔ Jeju inɓe kɨ uni’ə ta dann’se’tɨ awi si’ə dɔran’tɨ kin ə, a təl re tokɨ oyi go’ə lo kaw’a dɔran’tɨ kin be tɔ.» ");
INSERT INTO gqr_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Be ə njekawkulə’gɨ lə Jeju təli dɔ mbal kagɨ Buni’tɨ awi Jerujalem’tɨ gogɨ. Mbal kagɨ Buni kin in ndəkba kɨ ɓebo Jerujalem. ");
INSERT INTO gqr_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Lokɨ rei tei Jerujalem’tɨ ningə, ali awi me kəy’tɨ kare kɨ in dɔ mad’a’tɨ taa, lokɨ rai to lo kisɨ’de kete kete. Adɨ in Piyər num, Jan num, Jakɨ in kɨ Andire num, Pilipɨ in kɨ Tomasɨ num, Batilemi in kɨ Matiye num, Jakɨ kɨ ngonn lə Alpe num, Simon kɨ nje rɔ tadɔ ta kingədɔ lə ɓe lə’ne num taa Judɨ kɨ ngonn lə Jakɨ num tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ingɨ pətɨ, kɨ me’de kɨ kareba, kawinan nəm nəm kadɨ elita kɨ Luwə ta ta, nan’tɨ kɨ dene’gɨ madɨ. Mari kɨ kon Jeju in dann’de’tɨ num taa ngannkon Jeju num tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Me ndɔ’gɨ’tɨ kin, njekunme’gɨ kawinan asi ɓu kɨ dɔ joo. Ningə Piyər ində taa dann ngannkon’ne’gɨ’tɨ el ene: ");
INSERT INTO gqr_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","«Ngannkon’m’gɨ, majɨ kadɨ nya kɨ Ndil Luwə elta’a me Makitu’tɨ lə Luwə tɔlta’ne. Tadɔ Ndil Luwə, elta kete kɨ ta *Dabidɨ, ɔjɨ’n dɔ Judasɨ kɨ ɔr non de’gɨ kɨ rei uwəi Jeju. ");
INSERT INTO gqr_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judasɨ in kɨ kare dann’je’tɨ, ningə aw kɨ kulə lə’ne kɨ sɔw dɔ’ne kadɨ ra dann’je’tɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Kɨ nar kɨ adi’ə tadɔ kugə’n goji kulə kɨ majel kɨ ra kin ə, Judasɨ aw ndogɨ’n lo ndɔɔ. Me ndɔɔ’tɨ kɨ ndogɨ kakin ə, ində taa osɨ, dɔ’a sur kɨ nanga, me’ə ndu rusɨ adɨ ti’ə ala mban dɔnangɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","De’gɨ pətɨ kɨ dɔnangɨ Jerujalem’tɨ oyi ta kin. Be ə ɓari lo ndɔɔ kakin kɨ ta ɓe lə’de eyina: “Akeldama”, kɔr me ta kin nan: “Lo ndɔɔ mosɨ”. ");
INSERT INTO gqr_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Ndangi me makitu Pa’gɨ’tɨ eyina: “Kadɨ kəy li’ə in kɨ k’inyə kɔ num, Kadɨ de kare ka isɨ me’tɨ el num,” Taa ndangi ɓay eyina: “Kadɨ de kɨ rangɨ ɔr tor’o.” ");
INSERT INTO gqr_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","«Be ə, majɨ kadɨ jɨ mbəti de kare mbunə de’gɨ’tɨ inɓe kɨ njiyəi se’je nan’tɨ kɨ ndɔ’gɨ pətɨ kɨ Burəɓe Jeju awɨ’n se’je num təl’n se’je num inɓe kin. ");
INSERT INTO gqr_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Ulə ngirə dɔ batəm’tɨ lə Jan, ratata te’n dɔ ndɔ’tɨ kɨ Luwə un’n Jeju ta dann’je’tɨ awɨ’n si’ə dɔran’tɨ. Kadɨ de kare dann’de’tɨ, in nje mannajɨ, nan’tɨ se’je tokɨ Jeju ində lo koy’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Lo kin’tɨ, rei kɨ de’gɨ joo ɔji’de, kɨ dɔkete in Jisepɨ kɨ ɓari’ə nan Barsabasɨ, kɨ indəi tɔ’a kɨ rangɨ nan Jusitusɨ, ningə kɨ nja joo in Matiyasɨ. ");
INSERT INTO gqr_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ningə eli Burəɓe eyina: «Burəɓe, in gər ngarme de’gɨ pətɨ tigə, ə ɔjɨ’je ke mbunə de’gɨ’tɨ kɨ joo kin, in kɨ ra ə mbət’ə wa? ");
INSERT INTO gqr_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Mbət’ə kadɨ un ta kulə lə njekawkulə kɨ Judasɨ inyə ta’a ə aw lo’tɨ lə’ne kɨ sɔw dɔ’a kadɨ awɨ’tɨ kin.» ");
INSERT INTO gqr_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Rai ɓukɨ ɓukɨ, ningə ɓukɨ ɓukɨ osɨ dɔ Matiyasɨ’tɨ. Adɨ Matiyasɨ ore kadɨ njekawkulə’gɨ kɨ dɔgɨ gidə in kare. ");
INSERT INTO gqr_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Lokɨ ndɔ nanyi Pantəkotɨ asɨ ningə, njekunme’gɨ pətɨ kawinan lo kareba. ");
INSERT INTO gqr_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Tanan’tɨ non, kah nya madɨ in dɔran’tɨ, ə to to nəl bo kɨ ulə kɨ tɔgɨ’ne kin be. Kah nya kakin taa lo me kəy’tɨ kɨ sii’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Oyi nya’gɨ kɨ toi to por ə ndonn’o’gɨ tei bilim bilim be, tei, kanyinan dɔ’de’tɨ kare kare. ");
INSERT INTO gqr_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ndil Luwə rosɨ me’de pətɨ, adɨ uləi ngirə kel ndonnta’gɨ kɨ rangɨ, kigo kində’tɨ kɨ Ndil Luwə ndə’n ta de’tɨ kɨ ra kadɨ el. ");
INSERT INTO gqr_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ningə me ndɔ’a’gɨ’tɨ kin, *Juwipɨ’gɨ kɨ nje ɓol Luwə, in kɨ dɔ ɓe’gɨ kɨ dangɨ dangɨ kɨ dɔnangɨ’tɨ ne pətɨ, rei sii Jerujalem’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Lokɨ oyi kah nya kin ningə, anyinan ngodɨ rei mbonyinan banyinan banyinan, ndil’de te saw, tadɔ nan nan dann’de’tɨ, oo dɔ ndu njekunme’gɨ kɨ sii elita kɨ ndonnta ɓe lə’ne. ");
INSERT INTO gqr_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Nya kin ətɨ’de ɓol ngayn adɨ ndil’de anyi ur kakɨ, oyi kadɨ in nya kɨ rɔta’tɨ el, adɨ eli eyina: «De’gɨ kɨ isɨ elita kin pətɨ in de’gɨ kɨ in Galile’tɨ, ");
INSERT INTO gqr_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Nga bann be nan nan dann’je’tɨ, oo ta kɨ te ta’de’tɨ kɨ ndonnta ɓe lə’ne wa? ");
INSERT INTO gqr_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","J’in de’gɨ kɨ Partɨ’tɨ, kɨ Medɨ’tɨ, kɨ Elamitɨ’tɨ, kɨ nje k’in dɔnangɨ Mejopotami’tɨ num, kɨ Jude’tɨ num, Kapadosɨ’tɨ num, taa Pon’tɨ kɨ in ngonnɓe kɨ dɔnangɨ Aji’tɨ num, ");
INSERT INTO gqr_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Piriji’tɨ num, Pampili’tɨ num, Ejipitɨ, kɨ dɔnangɨ Libi’tɨ kɨ in ndəkba kɨ Sirenn, eke nje k’in dɔnangɨ Rɔm’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","J’in pətɨ j’in Juwipɨ kojɨ’gɨ ge kɨ Juwipɨ təl’gɨ ge. J’in Kiretɨ’tɨ kɨ Arabi’tɨ. Be ka, j’oo dɔ ndu’de kɨ elita kɨ ndonnta ɓe lə’je, ɔjidɔ nya’gɨ kɨ ətɨ ɓol kɨ Luwə ra.» ");
INSERT INTO gqr_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ingɨ pətɨ ndil’de anyi ur kakɨ adɨ gəri ta inɓe kɨ kadɨ eli el, ningə elinan mbunə’de’tɨ eyina: «Kɔr me nya kɨ ra nya kin nan ri ə?» ");
INSERT INTO gqr_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Nan nje kɨ nan’gɨ kogi dɔ nje kel ndonnta’gɨ’tɨ kɨ dangɨ dangɨ kɨ kɨ ra eli, eyina: «In yiwi kandɨ nju ə anyinan ngayn ə ra’de.» ");
INSERT INTO gqr_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Piyər indəi rai taa kɨ ndəgɨ njekawkulə’gɨ kɨ dɔgɨ gidə in kare, ningə un ndu’ne kɨ taa elta bulə de’gɨ ene: «Uri mbi’se majɨ oyi dɔ ta lə’m in Juwipɨ’gɨ kɨ de’gɨ pətɨ kɨ isɨ Jerujalem’tɨ ne. Majɨ kadɨ gəri nya kɨ isɨ ra nya kin tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","De’gɨ madɨ dann’se’tɨ oyi kadɨ in yiwi kandɨ nju ə ra de’gɨ kam. Nan jagɨ! Jɨ ra kɨ sin non kadɨ nda’tɨ ɓay! ");
INSERT INTO gqr_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Nan ngɔsine nya kɨ ndɔkɨ njekeltakita Luwə’tɨ Juwəl elta’a ka ə ra nya kin: ");
INSERT INTO gqr_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“Nya’gɨ kɨ Luwə elta’a kadɨ a rai nya me ndɔ’gɨ’tɨ kɨ dɔboy’tɨ kaa ə toi kin: M’a m’ulə kɨ Ndil’m dɔ de’gɨ’tɨ pətɨ. Ngann’se’gɨ kɨ dingəm kɨ nje kɨ dene a təli njekelta kɨ ta Luwə’tɨ, Basa’gɨ lə’se a oyi nya’gɨ me ndil’tɨ, Ɓugə’gɨ lə’se, a oyi nya’gɨ kɨ to lo kiyərɔ’tɨ me ni’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Oyo me ndɔ’gɨ’tɨ kin, M’a m’ulə kɨ Ndil’m dɔ ngann njekulə’gɨ’tɨ lə’m kɨ dingəm kɨ nje kɨ dene. A in nje kelta kɨ ta’m’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","M’a m’ra nya’gɨ kɨ de asɨ ra el me dɔran’tɨ taa nu, Ningə dɔnangɨ’tɨ ne, m’a m’ra nyakɔjɨ’gɨ kɨ ətɨ ɓol, Adɨ in: mosɨ num, por num, sa kɨ su luy luy num tɔ, ");
INSERT INTO gqr_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Kete ɓay ta kadɨ ndɔ kɨ bo ngayn, kɨ rosɨ kɨ pitɨ lə Burəɓe kin a re, Lokɨ kada a təl lo kɨ ndul, ningə nanyi a təl mosɨ. ");
INSERT INTO gqr_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ningə me ndɔ’tɨ kin, de’gɨ pətɨ kɨ ɓari tɔ Burəɓe a ingəi kajɨ.” ");
INSERT INTO gqr_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","«In Isirayel’gɨ, uri mbi’se majɨ oyi ta kɨ m’a m’el’se. In gəri pətɨ kadɨ Jeju kɨ Najaretɨ, dingəm kin kɨ Luwə ɔj’ɔ kɨ taga kadɨ n’ndig’ə, ə Luwə ra nya’gɨ kɨ de asɨ ra el kɨ nyakɔjɨ’gɨ kɨ ətɨ ɓol kɨ takul’ə dann’se’tɨ ne. ");
INSERT INTO gqr_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Dingəm kin, uləi’ə ji’se’tɨ kigo kun ndu’tɨ kɨ Luwə un, num kigo kɔjitara’tɨ li’ə kɨ to kete. Ningə ingɨ adi de’gɨ kɨ gəri Luwə kɨ rɔta’tɨ el, tɔli’ə kɨ row ɓər kɨ ɓəri’ə dɔ kagidəsɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Nan Luwə gangɨ kulə koy rɔ’a’tɨ kɔ ad’a ində taa lo koy’tɨ, tadɔ koy aw kɨ tɔgɨ kadɨ uwə ginn tɔgɨ’ne’tɨ ɓe ninn’tɨ el. ");
INSERT INTO gqr_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Dabidɨ elta ɔjɨ’n dɔ’a ene: “M’oo Burəɓe kɨ dɔkagilo’gɨ pətɨ non’m’tɨ, Tadɔ in dɔjikɔl’m’tɨ kadɨ m’te m’osɨ el. ");
INSERT INTO gqr_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","In tadɔ kin ə rɔnel rosɨ me’m adɨ m’osɨ’n pa tɔ. Be ə, ɓe ninn’tɨ kaa, darɔ’m a ɔrkon kɨ kindəmedɔtɨ, ");
INSERT INTO gqr_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","In Burəɓe, a tusɨ’m inyə’m kɔ koo el, A inyə njekuləɓər lə’i kɨ Ar njay ad’a ndum lo kɨ koo’tɨ el tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","In ə ɔjɨ’m row kadɨ m’təl m’njɨ’n kɨ dɔ’m taa, Ningə a adɨ’m rɔnel me k’in nan’tɨ sə’m.”» ");
INSERT INTO gqr_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Piyər təl el ɓay ene: «Ngannkon’m’gɨ, adɨ m’el’se ta kɨ rɔta’tɨ: kaw’je Dabidɨ oy tokɨ rɔta’tɨ adɨ duwi’ə. Dɔɓad’a to dann’je’tɨ ne bitɨ ɓone. ");
INSERT INTO gqr_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","In njekeltakita Luwə’tɨ, ə gər kadɨ Luwə un ndu’ne ad’a kɨ kiwrɔ kadɨ n’a n’adɨ de kare kɨ ginn kaw’tɨ li’ə a onɓe tor’o’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Dabidɨ gər nya kɨ a ra nya lo ti’tɨ, adɨ elta kin lo koy’tɨ lə Kirisitɨ kɨ in *De kɨ Luwə mbət’ə kin kete. In ta li’ə ə Dabidɨ ene Luwə a inyə lo kɨ koo’tɨ el, taa a inyə darɔ’a adɨ ndum ɓe ninn’tɨ el tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Jeju kɨ m’njɨ m’elta li’ə kin, Luwə ad’a ində taa dann njekoy’gɨ’tɨ, j’in pətɨ jɨ gəri majɨ. ");
INSERT INTO gqr_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Go’tɨ ningə, Luwə un’ə aw si’ə dɔran’tɨ adɨ isɨ dɔjikɔl’ɔ’tɨ. Ningə ngɔsine Luwə kɨ Baw ad’a Ndil’ne tokɨ un’n ndu’ne. Ndil kin ə, Jeju ɓukɨ dɔ’je’tɨ, tokɨ oyi ngɔsine kɨ kum’se ge, kɨ mbi’se ge kin. ");
INSERT INTO gqr_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Tokɨ rɔta’tɨ, Dabidɨ aw dɔran’tɨ el, nan el ene: “Burəɓe el Burəɓe lə’m ene: ‹Re isɨ dɔjikɔl’m’tɨ, ");
INSERT INTO gqr_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","bitɨ kadɨ m’təl njeban’gɨ lə’i nyakində nja’i’tɨ ginn tɔg’i’tɨ.›” ");
INSERT INTO gqr_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","In be ə, rɔ Jeju inɓe kɨ ɓəri’ə dɔ kagidəsɨ’tɨ kin ə, Luwə ad’a in Burəɓe num, Kirisitɨ kɨ in De kɨ Luwə mbət’ə num tɔ. In kin ə in nya kɨ majɨ kadɨ de’gɨ pətɨ kɨ Isirayel’tɨ gəri majɨ.» ");
INSERT INTO gqr_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Lokɨ de’gɨ oyi ta kin ningə, me’de olo wutɨ wutɨ adɨ dəji Piyər kɨ ndəgɨ njekawkulə’gɨ eyina: «Ngannkon’je’gɨ, in ri ə kadɨ jɨ ra wa?» ");
INSERT INTO gqr_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Piyər təl el’de ene: «Inyəi gorow njiyə’se kɨ majel kɔ, ningə kadɨ de kɨ ra dann’se’tɨ adɨ rai’ə batəm me tɔ Jeju Kirisitɨ’tɨ, kadɨ majel’gɨ lə’se in kɨ k’inyə go kɔ. Ningə a ingəi Ndil Luwə. ");
INSERT INTO gqr_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Tokɨ rɔta’tɨ, kunndu lə Luwə in tadɔ lə’se num, tadɔ lə ngann’se’gɨ num, tadɔ de’gɨ kɨ sii sanyi num. Sɔw dɔ de’gɨ pətɨ kɨ Burəɓe Luwə lə’je a ɓar’de.» ");
INSERT INTO gqr_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Piyər el’de ta’gɨ kɨ rangɨ ngayn go’tɨ ɓay kadɨ man’n najɨ, ningə ulə dingəm me’de’tɨ ə el’de ene: «Gangi nan kɨ ginn de’gɨ kɨ majel kɨ ɓone kin, kadɨ Luwə ajɨ’n’se.» ");
INSERT INTO gqr_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","De’gɨ pətɨ kɨ taai ta lə Piyər, rai’de batəm. Ndɔ’a’tɨ kakin, de’gɨ asi dər mutə rei orei kadɨ njekunme’gɨ kɨ kete. ");
INSERT INTO gqr_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ulə ngirə dɔkagilo’ə’tɨ kin, rei nəm nəm tadɔ k’oo dɔ nyando lə njekawkulə’gɨ num, lo ra madɨ nan’tɨ num, lo tətɨ mapa’tɨ num, taa lo kelta’tɨ kɨ Luwə num tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Njekawkulə’gɨ rai nya’gɨ kɨ de asɨ ra el kɨ nyakɔjɨ’gɨ kɨ ətɨ ɓol ngayn adɨ de’gɨ pətɨ sii kɨ ɓol me’de’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Nje kunme’gɨ indəi rɔ’de nan’tɨ kareba ə kawi nyakingə’gɨ lə’de dɔnan’tɨ kareba tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ndogi se’de nyakingə’gɨ kɨ nya majɨ’gɨ lə’de ə lowəi nan nar’a kigo ge’tɨ lə de kɨ ra. ");
INSERT INTO gqr_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ndɔ kare kare pətɨ, kɨ me kɨ kareba, ingəi nan Kəy’tɨ lə Luwə. Lowəi nan mapa me kəy’gɨ’tɨ lə’de, sɔi nya’gɨ lə’de kɨ rɔnel num, kɨ me kɨ sɔl lɔm lɔm num tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Osi pa’gɨ uləi tɔjɨ dɔ Luwə’tɨ, ningə de’gɨ pətɨ ndigi ta lə’de tɔ. Ndɔ kare kare pətɨ, Burəɓe adɨ kɔr de’gɨ kɨ ajɨ’de, re dɔ mad’a’tɨ par par. ");
INSERT INTO gqr_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ndɔ kare Piyər ingɨ kɨ Jan isɨ awi Kəy’tɨ lə Luwə tadɔ kelta kɨ Luwə dɔ kadɨ’tɨ kɨ mutə kɨ losɔl’ɔ. ");
INSERT INTO gqr_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Dɔkagilo’ə’tɨ kin ə de’gɨ ai kɨ de kɨ nja’a oy lo koj’o’tɨ nu, indəi’ə ta Kəy’tɨ lə Luwə. De kakin, ndɔ kare kare pətɨ, a indəi’ə ta Kəy’tɨ lə Luwə kɨ ɓari’ə nan: «Ta Kəy kɨ Ndolo». Indəi’ə kadɨ kɔy nya de’gɨ kɨ isɨ uri me natɨ Kəy’tɨ lə Luwə. ");
INSERT INTO gqr_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Lokɨ oo Piyər kɨ Jan kɨ isɨ uri kɨ me Kəy’tɨ ningə, kɔy’de nya. ");
INSERT INTO gqr_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Piyər kɨ Jan uri kum’de kɨ dɔ’a’tɨ, ningə Piyər el’ə ene: «Gon’je ne!» ");
INSERT INTO gqr_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Nje nja koy gon’de, ɔjɨ me’ne’tɨ kadɨ n’a ningə nya madɨ ji’de’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Nan Piyər el’ə ene: «M’aw kɨ nar el num, kɨ ɔr el num kadɨ m’ad’i. Nan nya kɨ m’aw’n ji’m’tɨ in tɔgɨ Jeju Kirisitɨ. Be ə kadɨ me tɔ Jeju Kirisitɨ kɨ Najaretɨ’tɨ, ində taa ə njiyə!» ");
INSERT INTO gqr_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Piyər uwə ji kɔl’ɔ, ə un’ə kɨ taa. Tanan’tɨ non par ə nja’a’gɨ kɨ gul nja’a’gɨ təli toi majɨ kare. ");
INSERT INTO gqr_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","In bal ra taa ə ulə ngirə njiyə. Aw se’de natɨ Kəy’tɨ lə Luwə. Tur jagira kɨ rɔnel num ulə tɔjɨ dɔ Luwə’tɨ num tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","De’gɨ pətɨ oyi’ə lo njiyə’tɨ num, lo kulə tɔjɨ dɔ Luwə’tɨ num tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","De’gɨ gəri’ə majɨ kadɨ in nje mote kɨ kete in nje kisɨ ta Kəy’tɨ lə Luwə kɨ ɓari’ə nan: «Ta Kəy kɨ Ndolo», isɨ kɔy nya inɓe ka am. Lokɨ de’gɨ oyi nya kɨ te dɔ’a’tɨ kin ningə, ndil’de anyi ur kakɨ adɨ ɓol ra’de ngayn. ");
INSERT INTO gqr_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Nje nja koy kakin inyə go Piyər kɨ Jan el. Nya kin ra adɨ ndil de’gɨ pətɨ anyi ur kakɨ. Be ə, de’gɨ pətɨ anyinan ngodɨ kawinan kɨ dɔ’de’tɨ dɔ’de’tɨ takəy’tɨ kɨ ɓari’ə nan: «Tabitɨ lə Salomon». ");
INSERT INTO gqr_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Lokɨ Piyər oo nya kin ningə, el bulə de’gɨ ene: «Ngann Isirayel’gɨ, bann ə nya kɨ ra nya kin ətɨ’se ɓol kədɨ be wa? Bann ə uri kum’se kɨ dɔ’je’tɨ to nya kɨ in j’inɓe kɨ tɔgɨ’je, eke in kɨ takul kaw kɨ j’aw kɨ ɓol Luwə me’je’tɨ ə j’adɨ’n dingəm kam njiyə’n be wa? ");
INSERT INTO gqr_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Jagɨ, in Luwə lə *Abiraham, lə *Isakɨ, lə *Jakobɨ, Luwə lə kaw’je’gɨ in ə ulə tɔjɨ dɔ ɓər’tɨ lə’ne Jeju, kɨ uləi’ə ji Pilatɨ’tɨ, *Pilatɨ un ndu’ne kadɨ n’ilə taa, nan ingɨ mbəti. ");
INSERT INTO gqr_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Oyo, ingɨ manji ta gər nje kar njay kɨ njera nya kɨ dana. Ningə dəji kadɨ ji ra majɨ sese ə j’ilə de kɨ nje tɔl de’gɨ taa tor’o’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","In be ə, adɨ tɔli in kɨ in nje kadɨ de’gɨ sii kɨ dɔ’de taa. Nan Luwə ad’a ində taa dann njekoy’gɨ’tɨ, j’in pətɨ jɨ gər majɨ. ");
INSERT INTO gqr_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","In tadɔ kun kɨ j’un me’je j’adɨ Jeju kin ə, tɔgɨ kɨ to me tɔ’a’tɨ, adɨ tɔgɨ dingəm kɨ oyi’ə, taa gəri’ə kin, kadɨ ində ra’n taa. Oyo, kunme kɨ tɔg’ɔ to kɨ takul Jeju, adɨ dingəm kin lapiya kɨ rɔta’tɨ, in nya kɨ ra nya takum’se’tɨ pətɨ adɨ oyi. ");
INSERT INTO gqr_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Ngɔsine ngannkon’m’gɨ, m’gər majɨ ngayn kadɨ nya kɨ rai kin, in kigo gər’ə’tɨ el, ingɨ kɨ njekɔrnon’se’gɨ pətɨ. ");
INSERT INTO gqr_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Nan, in kɨ row kin ə, Luwə tɔl’n ta nya kɨ iləmbər’ə kete kɨ takul njekeltakita’a’tɨ pətɨ ene: Kirisitɨ kɨ in De kɨ Luwə mbət’ə, kɨ n’un ndu’ne kadɨ n’a n’ulə, a ingə kon. ");
INSERT INTO gqr_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ngɔsine, inyəi gorow njiyə’se’gɨ kɨ majel kɔ, ə təli rei rɔ Luwə’tɨ kadɨ inyə’n go majel’gɨ lə’se kɔ. ");
INSERT INTO gqr_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ningə Burəɓe a adɨ’se dɔkagilo kɔrkon, a ulə kɨ in kɨ ində dɔ’a nan’tɨ kete to Kirisitɨ, kɨ in De kɨ Luwə mbət’ə, adɨ in Jeju, adɨ’se. ");
INSERT INTO gqr_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Nan ngɔsine kin, majɨ kadɨ Jeju isɨ dɔran’tɨ, bitɨ kadɨ Luwə təl nya’gɨ pətɨ kɨ dɔnangɨ’tɨ kɨ sigɨ gogɨ, tokɨ ilə’n mbər’ə me ɓal’gɨ’tɨ kɨ dər, kɨ takul de’gɨ kɨ njekeltakita’a’tɨ kɨ ari njay kɨ mayinu. ");
INSERT INTO gqr_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Be ə, *Mojɨ ene: “Burəɓe Luwə lə’se a adɨ njekeltakita’a’tɨ, kɨ to to m’in be, a in dann ngannkon’se’gɨ’tɨ, tadɔ lə’se, a oyi dɔ ta’gɨ pətɨ kɨ a el’se. ");
INSERT INTO gqr_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","De kɨ mbətɨ təl rɔ’ne go ta’tɨ kɨ njekeltakita Luwə’tɨ kin a el ningə, Luwə a tuj’ə kɔ dann de’gɨ’tɨ lə’ne kɨ koy.” ");
INSERT INTO gqr_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","De’gɨ kɨ njekeltakita Luwə’tɨ pətɨ, ulə ngirə dɔ Samiyel’tɨ nu kɨ nje re go’ə’tɨ, elita dɔ dɔkagilo’tɨ kɨ ji isɨ me’tɨ ɓone kin kete. ");
INSERT INTO gqr_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ingɨ, ə in de’gɨ kɨ ta kɨ Luwə el kɨ ta de’gɨ kɨ njekeltakita’a’tɨ kin sɔw dɔ’se, taa kunmindɨ kɨ Luwə un adɨ kaw’je’gɨ lokɨ un ndu’ne adɨ Abiraham kin sɔw dɔ’se tɔ. Luwə un mindɨ’ne ene: “Ginn kojɨ’gɨ kɨ dɔnangɨ’tɨ pətɨ a in kɨ njangɨ dɔ kɨ takul ginn kaw lə’i.” ");
INSERT INTO gqr_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","In kɨ tadɔ lə’se kete, ə Luwə te’n kɨ njekulə lə’ne, ulə adɨ’se kadɨ njangɨ dɔ’se, kɨ takul ra kɨ ra adɨ nan nan inyə gorow njiyə’gɨ lə’ne kɨ majel kɔ.» ");
INSERT INTO gqr_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Lokɨ Piyər ingɨ kɨ Jan isɨ elita bulə de’gɨ to kel ba ɓay ə, njekujənyamosɨ kadikare’gɨ kɨ madɨ num, kibo kɨ dɔ Kəy’tɨ lə Luwə num ta kɨ de’gɨ madɨ kɨ mbunə kutɨ’tɨ lə *Sadusi’gɨ, tei kɨ rɔ’de’tɨ bus. ");
INSERT INTO gqr_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Wongɨ ra njekɔrnon Juwipɨ’gɨ ngayn tadɔ oyi Piyər ingɨ kɨ Jan isɨ ndoi nya bulə de’gɨ, ningə eli’de eyina: «Tokɨ Jeju ində’n taa lo koy’tɨ inɓe kin ə, njekoy’gɨ kaa a indəi taa lo koy’tɨ tɔ.» ");
INSERT INTO gqr_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Uwəi’de iləi’de kəy dangay’tɨ ratata lo ti, tadɔ losɔl nga, adɨ lo kadɨ gangi ta dɔ’de’tɨ goto. ");
INSERT INTO gqr_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ningə mbunə nje’gɨ’tɨ kɨ oyi ta lə’de, ngayn’gɨ dann’de’tɨ uni me’de. Be ə, ra adɨ kɔr dingəm’gɨ re dɔ mad’a’tɨ adɨ asi dər mi kare. ");
INSERT INTO gqr_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Lo ti dɔ’tɨ ningə, njekɔrnon Juwipɨ’gɨ num, ngatɔgɨ’gɨ num ta njendo ndukun’gɨ num, kawinan me ɓebo’tɨ kɨ Jerujalem. ");
INSERT INTO gqr_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Lo kawnan’tɨ kin, Hann kɨ in kibo lə njekujənyamosɨ kadikare’gɨ in’tɨ non, taa Kayipɨ num, Jan num, Alegijandir kɨ ndəgɨ de’gɨ pətɨ kɨ me kəy’tɨ lə njekujənyamosɨ kadikare’tɨ kibo kakin num kaa in non tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Adi rei kɨ Piyər kɨ Jan non’de’tɨ kɨ non Njekawnan’gɨ’tɨ, ə dəji’de ta eyina: «Kɨ tɔgɨ kɨ in ra eke me tɔ nan’tɨ ə rai nya kin wa?» ");
INSERT INTO gqr_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ningə Piyər, Ndil Luwə rosɨ me’ə, adɨ el’de ene: «In njekɔrnon’gɨ kɨ ngatɔgɨ’gɨ, ");
INSERT INTO gqr_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","dəji’je ta ɓone ɔjidɔ nya kɨ majɨ kɨ jɨ ra kɨ de kɨ nja’a oy kɨ kujɨ nya kɨ jɨ ra ə ingə’n lapiya. ");
INSERT INTO gqr_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Majɨ kadɨ ingɨ pətɨ gəri ar njay taa de’gɨ pətɨ kɨ Isirayel’tɨ kaa, kadɨ gəri majɨ tɔ: In me tɔ Jeju Kirisitɨ kɨ Najaretɨ’tɨ ə jɨ ra’n nya kin. In kɨ takul Jeju inɓe kɨ ɓəri’ə dɔ kagidəsɨ’tɨ ə Luwə ad’a ində taa dann njekoy’gɨ’tɨ inɓe kin ə, dingəm kin ra’n ta non’se’tɨ, kɨ lapiya nga kin. ");
INSERT INTO gqr_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","In mbal kɨ njera kəy’gɨ mbəti’ə, nan in ə təl mbal kɨ maj’a utə mad’a’gɨ pətɨ, in mbal kɨ nje kadɨ tɔgɨ kəy. ");
INSERT INTO gqr_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Kajɨ in me tɔ’a’tɨ kɨ kar’ne ba. Tɔ kɨ rangɨ kɨ Luwə adɨ de dɔnangɨ’tɨ ne mbunə de’gɨ’tɨ kadɨ j’ingəi kajɨ goto.» ");
INSERT INTO gqr_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ndɔjɨ njegangɨ ta’gɨ kɨ kibo lə Juwipɨ’gɨ ngayn lokɨ oyi Piyər ingɨ kɨ Jan elita kɨ kanjɨ ɓol, tadɔ gəri’de kadɨ in de’gɨ kɨ kare kɨ kanjɨ nyando. Nan k’in ə gəri kadɨ in de’gɨ kɨ in nan’tɨ kɨ Jeju mayinu. ");
INSERT INTO gqr_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Nan lokɨ oyi dingəm kɨ adi’ə lapiya kakin ra taa gədɨ’de’tɨ ningə gəri lo ta kɨ kadɨ eli’de el. ");
INSERT INTO gqr_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Be ə uni ndu’de adi Piyər ingɨ kɨ Jan, taa dingəm kakin num kadɨ tei taga, ningə manjinan ta mbunə’de’tɨ eyina: ");
INSERT INTO gqr_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","«Ri ə j’a rai kɨ de’gɨ kam wa? Tadɔ rai nyakɔjɨ kɨ ətɨ ɓol kɨ to ndalo’tɨ ar njay adɨ de’gɨ kɨ Jerujalem oyi poy’o. Lo kadɨ jɨ manjɨ goto. ");
INSERT INTO gqr_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Nan k’in ə kadɨ poyta kin aw kɨ kete kete mbunə de’gɨ’tɨ el nga. Adɨ j’uləi ji’je kum’de’tɨ kadɨ kaw kɨ kete non kam, eli’de madɨ ta me tɔ Jeju’tɨ el nga.» ");
INSERT INTO gqr_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Go ta’gɨ’tɨ kin, ai kɨ Piyər ingɨ kɨ Jan kəy gogɨ ə ɔgi’de kɨ tɔgɨ’de kadɨ elita eke ndoi nya me tɔ Jeju’tɨ el nga. ");
INSERT INTO gqr_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Nan Piyər ingɨ kɨ Jan eli’de eyina: «Eli’je adɨ j’oo, ke in gorow’ə’tɨ, takum Luwə’tɨ, kadɨ jɨ təl rɔ’je go ta’tɨ lə’se yo ə j’inyə ta lə Luwə wa? ");
INSERT INTO gqr_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Kɨ ɔjidɔ’je, j’in j’asɨ manjɨ ta dɔ nya’tɨ kɨ j’oo kɨ kum’je num, kɨ mbi’je num kin el.» ");
INSERT INTO gqr_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Lokɨ uləi ji’de kum’de’tɨ kɨ nja joo ɓay ningə, inyəi’de adɨ ai. Tokɨ rɔta’tɨ, ingəi nya madɨ rɔ’de’tɨ kɨ asɨ kuwə’n’de dangay’tɨ el, tadɔ de’gɨ pətɨ piti Luwə tadɔ nya kɨ ra nya kin. ");
INSERT INTO gqr_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ɓal dingəm kɨ ingə lapiya kɨ takul nyakɔjɨ kɨ ətɨ ɓol kin, utə dɔsɔ. ");
INSERT INTO gqr_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Go k’inyə de’tɨ, Piyər ingɨ kɨ Jan ai ingəi madɨ’de’gɨ kɨ njekunme’gɨ, ɔri’de poy nya’gɨ pətɨ kɨ kibo’gɨ lə njekujənyamosɨ kadikare’gɨ kɨ ngatɔgɨ’gɨ eli’de. ");
INSERT INTO gqr_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Lokɨ madɨ’de’gɨ oyi ta lə’de ginn’ə gangɨ nga ningə, pətɨ kɨ me kɨ kare, elita kɨ Luwə eyina: «Burəɓe, in ə ra dɔran kɨ dɔnangɨ, taa ra babo kɨ nya’gɨ pətɨ kɨ me’tɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","In ə adɨ Ndil Luwə elta kɨ ta kaw’je Dabidɨ kɨ ɓər lə’i ene: Ginn ɓe’gɨ kɨ dangɨ dangɨ tonyi rɔ kɨ ndangɨ kare be. Taa kɔjitara’gɨ lə’de to rɔ’de’tɨ kare! ");
INSERT INTO gqr_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ngar’gɨ kɨ dɔnangɨ’tɨ ne indəi dɔ rɔ’de dana tadɔ kaw rɔ, nje konɓe’gɨ indəi rɔ’de nan’tɨ, ɔsi ta Kirisitɨ kɨ in De kɨ Luwə mbət’ə to Ngar. ");
INSERT INTO gqr_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Tokɨ rɔta’tɨ, in me ɓebo’tɨ kin ə, *Erodɨ ingɨ kɨ Ponsɨ Pilatɨ, nan’tɨ kɨ ginn de’gɨ kɨ dangɨ dangɨ kɨ ngann Isirayel’gɨ indəi rɔ’de nan’tɨ ɔsi ta njekulə lə’i kɨ ar njay, kɨ in Jeju kɨ mbət’ə to Kirisitɨ. ");
INSERT INTO gqr_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Nya’gɨ lə’de kɨ rai kin, in tɔl ə tɔlita kɔjitara’gɨ lə’i pətɨ kɨ ɔjɨ kete, kɨ tɔgi, me ndigɨ’tɨ lə’i. ");
INSERT INTO gqr_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ngɔsine Burəɓe, oo ji’de kɨ isɨ uləi kum’je’tɨ kadɨ indəi’je ɓol’tɨ kin! Adɨ ɓər’gɨ lə’i tɔgɨ kadɨ iləi mbər ta lə’i kɨ me kɨ tinyi katɨ. ");
INSERT INTO gqr_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ningə, kadɨ ɔjɨ tɔgi me tɔ njekulə’tɨ lə’i kɨ ar njay Jeju, kadɨ njemonyi’gɨ ingəi lapiya num, taa kadɨ nyakɔjɨ’gɨ kɨ nya’gɨ kɨ de asɨ ra el rai nya num tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Lokɨ tai kon ta kelta’tɨ kɨ Luwə ningə, dɔnangɨ yəkɨ yikiti yikiti ginn nja’de’tɨ, lo kɨ kɨ kawinan’tɨ. Ningə Ndil Luwə rosɨ me’de pətɨ adɨ iləi mbər ta lə Luwə kɨ rɔ kɨ tinyi katɨ.» ");
INSERT INTO gqr_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Nje kunme’gɨ pətɨ indəi rɔ’de nan’tɨ kɨ ngarme kɨ kare kɨ mərta kɨ kare. De kare kɨ ində gu’ne kɨ nyakingə lə’ne kɨ sɔw dɔ’ne goto, nya’gɨ pətɨ in dɔnan’tɨ kareba. ");
INSERT INTO gqr_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Kɨ tɔgɨ kɨ ətɨ ɓol ngayn ə njekawkulə’gɨ manyinajɨ kin lo koy’tɨ lə Burəɓe Jeju. Ningə, kare kare pətɨ, Luwə njangidɔ’de njangɨ dɔ kɨ ətɨ ɓol ngayn. ");
INSERT INTO gqr_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Be ə de kare dann’de’tɨ kɨ nya to rɔ’a goto. Tadɔ nje’gɨ kɨ awi kɨ lo ndɔɔ’gɨ kɨ kəy’gɨ, uni ndogi ə rei kɨ nar’a, ");
INSERT INTO gqr_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","adi njekawkulə’gɨ. Ningə njekawkulə’gɨ lowəi nar kakin dann’de’tɨ pətɨ, nan nan ingə kigo nya ge’gɨ’tɨ li’ə. ");
INSERT INTO gqr_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","De madɨ kare kɨ tɔ’a nan Jisepɨ, kɨ in ginn kojɨ’tɨ lə *Lebi, kɨ dɔnangɨ Sipir’tɨ, kɨ njekawkulə’gɨ indəi tɔ’a nan Barnabasɨ, kɔr me’ə nan: «De kɨ njekulə dingəm me de’gɨ’tɨ,» ");
INSERT INTO gqr_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","in kaa, aw kɨ lo ndɔɔ, ə un lo ndɔɔ lə’ne kakin ndogɨ, ə re kɨ nar’a adɨ njekawkulə’gɨ. ");
INSERT INTO gqr_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Dingəm madɨ kare kɨ tɔ’a nan Ananiyasɨ in kɨ dene lə’ne Sapira, ndogi lo lə’de tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ananiyasɨ ingɨ kɨ dene lə’ne Sapira indəi ndu’de nan’tɨ, iyəi nusɨ nar, ə awi kɨ ndəgə adi njekawkulə’gɨ. ");
INSERT INTO gqr_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Piyər el’ə ene: «Ananiyasɨ, ra bann ə inyə *Satan adɨ ur me’i’tɨ ətɨ ɓol be wa? Ɔr nusɨ nar lo ndɔɔ lə’i ngəm, ə elta kɨ ngom Ndil Luwə! ");
INSERT INTO gqr_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ri ə ɔgi kadɨ ngəm nyakingə lə’i wa? A re ndogɨ’n ə binəm kaa, ri ə ɔgi kadɨ nar kɨ ingə kin, ra’n nya kɨ me’i ge wa? Nya kɨ mər me’i’tɨ kin in nya kɨ majel. In de’gɨ ə el’de ta kɨ ngom el, nan in Luwə ə el’ə ta kɨ ngom.» ");
INSERT INTO gqr_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Lokɨ Ananiyasɨ oo ta kin par ə, osɨ nanga, oy. De’gɨ pətɨ kɨ oyi poyta kin, ɓol ra’de ngayn. ");
INSERT INTO gqr_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Basa’gɨ rei ragi ninn’ə, ə uni’ə, ai duwi’ə. ");
INSERT INTO gqr_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Asɨ ngirə kadɨ mutə go’tɨ, dene li’ə re ur kəy kɨ kanjɨ kadɨ gər nya kɨ ra nya. ");
INSERT INTO gqr_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Piyər dəj’ə ene: «El’m ta adɨ m’oo, ke kɔr nar kɨ ndogi sese lo ndɔɔ lə’se inɓe ənn ɓe?» Ə dene el’ə ene: «Oyo, kɔr nar kɨ j’ingə in be inɓə.» ");
INSERT INTO gqr_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Lo kin’tɨ, Piyər el’ə ene: «Nga ra bann ə indəi ndu’se nan’tɨ kadɨ soki Ndil Burəɓe wa?» Oo kah nja de’gɨ kɨ awi kɨ ngaw’i duwi’ə ə ɓar takəy’tɨ kin, in kaa a ai sə’i tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Tanan’tɨ non par ə Sapira osɨ nja Piyər’tɨ nanga, oy. Lokɨ basa’gɨ kɨ nje kaw duw ngaw’a uri kəy ningə, ingəi ninn’ə adɨ uni’ə awi si’ə duwi’ə kadɨ ngaw’a’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Nya kɨ ra nya kin, ra adɨ *Njekawnan’gɨ pətɨ, ɓol ra’de ngayn, taa de’gɨ pətɨ kɨ oyi poyta kin kaa, ɓol ra’de ngayn tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Njekawkulə’gɨ rai nya’gɨ kɨ ətɨ ɓol kɨ nya’gɨ kɨ de asɨ ra el ngayn dann de’gɨ’tɨ. Nje kunme’gɨ pətɨ, kawinan lo kareba, ginn tabitɨ’tɨ lə *Salomon, ta Kəy’tɨ lə Luwə. ");
INSERT INTO gqr_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","De’gɨ kɨ rangɨ kɨ uni me’de adi Luwə el ɓay ɓoli kadɨ rei rɔ’de’tɨ. Be kaa, piti njekunme’gɨ ngayn. ");
INSERT INTO gqr_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Dingəm’gɨ kɨ dene’gɨ ngayn ngayn uni me’de adi Burəɓe, adɨ kɔr’de ore dɔ njekunme’gɨ kɨ dɔ’tɨ dɔ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","De’gɨ ai bitɨ ɔyi njemonyi’gɨ kɨ taga kadɨ row’tɨ, tiləi’de dɔ tirə’gɨ’tɨ eke dɔ kagɨ’tɨ kɨ oti’de, kadɨ re Piyər dər ningə, ndil’ə ur dɔ in kɨ ra’tɨ wa kare dann’de’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","De’gɨ ngayn indəi ɓe’gɨ’tɨ kɨ gidɨ ɓebo Jerujalem’tɨ, rei bur bur kɨ njemonyi’gɨ kɨ de’gɨ kɨ ndil’gɨ kɨ majel yəti dɔ’de. Ningə pətɨ ingəi lapiya. ");
INSERT INTO gqr_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Go nya’gɨ’tɨ kin, kibo lə njekujənyamosɨ kadikare’gɨ kɨ de’gɨ kɨ go’ə’tɨ kɨ in me kutɨ’tɨ lə Sadusi’gɨ, jangɨ ra’de ngayn dɔ njekawkulə’gɨ’tɨ. Adɨ uni ndu’de kadɨ n’a rai nya madɨ. ");
INSERT INTO gqr_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Be ə, uwəi njekawkulə’gɨ iləi’de kəy dangay’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Nan dann lo’tɨ, malayka lə Burəɓe re te takəy dangay, lokɨ adɨ tei taga ningə, el’de ene: ");
INSERT INTO gqr_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","«Awi me Kəy’tɨ lə Luwə, iləi mbər ta kɨ nje kadɨ de təl isɨ kɨ dɔ’ne taa kin adi de’gɨ pətɨ oyi!» ");
INSERT INTO gqr_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Njekawkulə’gɨ təli rɔ’de go’tɨ, adɨ lo ti kɨ sin ba par ə, awi Kəy’tɨ lə Luwə, uləi ngirə kadɨ ndoi nya de’gɨ. Kibo lə njekujənyamosɨ kadikare’gɨ’tɨ kɨ de’gɨ kɨ go’ə’tɨ, ɓari ngatɔgɨ’gɨ kɨ njegangɨ ta, kɨ ngatɔgɨ’gɨ lə ngann Isirayel’gɨ pətɨ. Ningə uləi kəy dangay’tɨ kadɨ rei kɨ njekawkulə’gɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Nan lokɨ njekulə’gɨ awi ningə, ngəi’de kəy dangay’tɨ el, adɨ təli rei ɔri’de poy’o eyina: ");
INSERT INTO gqr_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","«J’ingə takəy dangay in kɨ kutɨ mbukɨ majɨ num, njengəm takəy’gɨ ka rai takəy’tɨ non num tɔ, nan lokɨ j’ur me kəy’tɨ ningə, j’ingə de madɨ el.» ");
INSERT INTO gqr_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Lokɨ kibo kɨ dɔ njengəm ta Kəy’tɨ lə Luwə ingɨ kɨ kibo’gɨ lə njekujənyamosɨ kadikare’gɨ oyi ta kin ningə, ndil’de anyi ur kakɨ, adɨ dəji nan ta dɔ nya’tɨ kɨ a ra nya go nya’tɨ kin. ");
INSERT INTO gqr_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ningə de madɨ re el’de ene: «Dingəm’gɨ kɨ adɨ uwəi’de dangay’tɨ kakin, nyɨ rai Kəy’tɨ lə Luwə non, ra ndoi nya de’gɨ.» ");
INSERT INTO gqr_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Kibo kɨ dɔ Kəy’tɨ lə Luwə aw kɨ de’gɨ lə’ne uwə’n njekawkulə’gɨ re se’de, nan k’in ə ində tɔgɨ dɔ’de’tɨ el tadɔ ɓoli kadɨ bulə de’gɨ kɨ kawinan dɔ nyando’tɨ lə njekawkulə’gɨ a tiləi’de kɨ mbal tɔli’de. ");
INSERT INTO gqr_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Lokɨ rei se’de ningə, awi se’de kəy gangita’tɨ kibo. Ə kibo lə njekujənyamosɨ kadikare’gɨ el’de ene: ");
INSERT INTO gqr_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","«J’ɔgi’se kɨ tɔgɨ’je kadɨ ndoi nya bulə de’gɨ kɨ tɔ dingəm kin. Ə in təli rɔ’se go ta’tɨ lə’je el, asi dɔnangɨ Jerujalem nakɨ kɨ nyando lə’se, ningə gəi kadɨ mos’o in dɔ’je’tɨ ɓay.» ");
INSERT INTO gqr_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Nan Piyər ingɨ kɨ ndəgɨ njekawkulə’gɨ eli’de eyina: «Təl rɔ go ta’tɨ lə Luwə in sotɨ utə təl rɔ go ta’tɨ lə de’gɨ. ");
INSERT INTO gqr_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Luwə lə kaw’je’gɨ adɨ Jeju kɨ tɔli’ə kɨ row ɓər’ə dɔ kagidəsɨ’tɨ kin, te lo koy’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","In ə Luwə un’ə, ində ad’a isɨ taa, dɔjikɔl’ne’tɨ to Ngar kɨ utə ngar’gɨ pətɨ taa to Njekajɨ de’gɨ tɔ. Luwə ində kadɨ kɨ, tarow li’ə, Isirayel’gɨ inyəi gorow njiyə’de’gɨ kɨ majel kɔ, adɨ n’inyə’n go majel’gɨ lə’de kɔ tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","J’in nje mannajɨ dɔ nya’gɨ’tɨ kɨ rai nya kin, nan’tɨ kɨ Ndil Luwə kɨ Luwə adɨ nje’gɨ kɨ təli rɔ’de go ta’tɨ li’ə.» ");
INSERT INTO gqr_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Lokɨ njegangɨ ta’gɨ oyi ta kin ningə, wongɨ ra’de ngayn dɔ njekawkulə’gɨ’tɨ, adɨ ndigɨ tɔli’de. ");
INSERT INTO gqr_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Nan in kɨ kare kɨ mbunə’de’tɨ kɨ tɔ’a nan Gamaliyel ɔsɨ nangɨ ində taa. In Parisɨ kɨ njendo de’gɨ ndukun, in de kɨ de’gɨ pətɨ gei ta li’ə ngayn. Lokɨ ində taa dann’de’tɨ ningə, dəjɨ kadɨ adi njekawkulə’gɨ ujəi rɔ’de dow kare jɔ. ");
INSERT INTO gqr_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ningə go’tɨ, el’de ene: «Isirayel’gɨ, indəi manjɨ nya kɨ gei kadɨ rai kɨ de’gɨ kam majɨ taa. ");
INSERT INTO gqr_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Dɔkagilo ngayn el ne ɓay ə, de madɨ kɨ tɔ’a nan Teda tɔjɨ rɔ’ne kadɨ n’in de kɨ tuwəl. Ɔr de’gɨ asɨ ɓu sɔ go’ne’tɨ. Nan de’gɨ rei tɔli’ə adɨ de’gɨ kɨ go’ə’tɨ kakin sananyinan. De oo ta li’ə el ɓone. ");
INSERT INTO gqr_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Go’ə’tɨ ningə, Judasɨ kɨ Galile’tɨ, te dɔkagilo ndangitɔ de’gɨ me makitu’tɨ, ɓukɨ de’gɨ ngayn go’ne’tɨ ra’n wongɨ. Nan inɓe kaa de’gɨ tɔli’ə tɔ, adɨ de’gɨ kɨ go’ə’tɨ sananyinan tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ngɔsine, ta lə’m ə to kin: Ononyi’se kadɨ rai nya madɨ kɨ de’gɨ kam, inyəi’de adɨ awi lo lə’de. Nya kɨ kadɨ in gəri ə to kin, re kɔjitara’gɨ lə’de kɨ kulə ra’de’gɨ in rɔ de’gɨ’tɨ ə, ginn nya’gɨ kin a gangɨ to yan ndəgə’gɨ be tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Nan re nya’gɨ kin in rɔ Luwə’tɨ ə, lo kadɨ ingɨ a ɔgi’de dɔ goto. Ononyi’se kadɨ ai rɔ dɔ Luwə.» Lo kin’tɨ, njegangɨ ta’gɨ ndigɨ go’ə’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Be ə, təli ɓari njekawkulə’gɨ kəy gogɨ, ə, adɨ tindəi’de, ə ɔgi’de kɨ tɔgɨ kadɨ elita me tɔ Jeju, ningə inyəi’de adɨ awi. ");
INSERT INTO gqr_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Njekawkulə’gɨ tei lo gangɨ ta’tɨ kɨ rɔnel tadɔ k’oo kɨ Luwə oo’de adɨ asi gakɨ kadɨ ingəi kon tadɔ lə Jeju. ");
INSERT INTO gqr_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ningə kɨ ndɔ kare kare pətɨ, me Kəy’tɨ lə Luwə eke me kəy’gɨ’tɨ madɨ, njekawkulə’gɨ nanyi kɨ lo ndo nya de’gɨ’tɨ num, kɨ lo kiləmbər Poyta’tɨ kɨ majɨ, tokɨ Jeju in Kirisitɨ kɨ in De kɨ Luwə mbət’ə. ");
INSERT INTO gqr_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Dɔkagilo’ə’tɨ kin, kɔr njendo’gɨ in kɨ dɔ mad’a’tɨ kɨ kete kete. Be ə Juwipɨ’gɨ kɨ nje kelta Girekɨ ɓarita dɔ Juwipɨ’gɨ’tɨ kɨ nje kelta Ebirə. Nje kel ta Girekɨ ɓarita tadɔ njengawkoy’gɨ lə’de ingəi nyakusɔ kɨ de’gɨ isɨ lowəi kɨ ndɔ kare kare pətɨ kin, to ndəgə’gɨ el. ");
INSERT INTO gqr_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Be ə, njekawkulə’gɨ kɨ dɔgɨ gidə in joo kawi njendo’gɨ kɨ nan’tɨ, eli’de eyina: «A in nya kɨ go’tɨ el kadɨ j’inyə ta kelta lə Luwə, ə jɨ təl jɨ nanyi ta nya lowə’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Tadɔ in kin ə, ngannkon’gɨ, majɨ kadɨ mbətɨ de’gɨ siri dann’se’tɨ, kɨ de’gɨ manyinajɨ lə’de majɨ num, Ndil Luwə rosɨ me’de num, taa ai kɨ kumkədɨ num tɔ, kadɨ j’uləi kulə kin ji’de’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Be kadɨ j’uni’n rɔ’je j’ində ta dangɨ tadɔ kelta kɨ Luwə kɨ ndo nya de’gɨ.» ");
INSERT INTO gqr_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ta kɔjɨ’gɨ kin nəl njendo’gɨ pətɨ. Be ə, mbəti Etiyenn kɨ in de kɨ rosɨ kɨ kunme num, kɨ Ndil Luwə num tɔ. Ta mbəti Pilipɨ num, Pirokɔr num, Nikanɔr num, Timon num, Parmenasɨ num, taa Nikola kɨ in de kɨ Antiyosɨ’tɨ, kɨ təl Juwipɨ num tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Rei se’de ɔji’de njekawkulə’gɨ, adɨ elita kɨ Luwə tadɔ lə’de num, indəi ji’de dɔ’de’tɨ, njangidɔ’de num tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ta lə Luwə aw kɨ kete par par. Kɔr njendo’gɨ in dɔ mad’a’tɨ ngayn me ɓebo’tɨ kɨ Jerujalem. Taa njekujənyamosɨ kadikare’gɨ inɓe ngayn kaa uni me’de adi Jeju tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Etiyenn in de kɨ rosɨ kɨ memajɨ num, kɨ tɔgɨ lə Luwə num, taa ra nya’gɨ kɨ dum ra kɨ nyakɔjɨ’gɨ kɨ ətɨ ɓol ɓol dann de’gɨ’tɨ num tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ningə de’gɨ madɨ uləi ngirə kadɨ manjinan ta’tɨ kɨ Etiyenn. De’gɨ kin in nje kɨ me kəykawnan’tɨ lə Juwipɨ’gɨ. In nje’gɨ kɨ ɓari rɔ’de: «De’gɨ kɨ taa k’inyə taa.» Adɨ in Juwipɨ’gɨ kɨ in Sirenn’tɨ num, Alegijandiri’tɨ num, kɨ nje kɨ in Silisi’tɨ num taa kɨ dɔnangɨ Aji’tɨ num tɔ, ");
INSERT INTO gqr_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","nan tɔgɨ ta kel’de osɨ go yan Etiyenn’tɨ el, tadɔ Etiyenn elta kɨ kumkədɨ kɨ Ndil Luwə ad’a. ");
INSERT INTO gqr_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Lo kin’tɨ, awi ndogi de’gɨ kɨ nar kɨ ji’de’tɨ kadɨ eli eyina: «J’inɓe j’oo kɨ mbi’je kadɨ Etiyenn elta kɨ mal dɔ ndukun’tɨ lə Mojɨ num, dɔ Luwə num tɔ.» ");
INSERT INTO gqr_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Be ə, suləi bulə de’gɨ num, ngatɔgɨ’gɨ num, taa njendo ndukun’gɨ num adɨ rei uwəi Etiyenn dɔ ji’ə’tɨ, awi si’ə lo gangɨ ta’tɨ kibo. ");
INSERT INTO gqr_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Indəi nje mannajɨ’gɨ kɨ ngom adɨ təti ta dɔ’a’tɨ, eli eyina: «Dingəm kam ta kon ta kelta kɨ mal dɔ Kəy’tɨ lə Luwə kɨ in lo kɨ ar njay kin el num, taa dɔ ndukun’tɨ lə Mojɨ el num tɔ.» ");
INSERT INTO gqr_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Tokɨ rɔta’tɨ, j’inɓe j’oo ndu’ə kɨ el’n kadɨ Jeju kɨ Najaretɨ’tɨ a tujɨ kəy kin, ə a yətɨ nya kagɨ ɓe’gɨ kɨ Mojɨ adɨ’je. ");
INSERT INTO gqr_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","De’gɨ pətɨ kɨ sii lo gangɨ ta’tɨ kibo, turi kum’de pətɨ kɨ dɔ Etiyenn’tɨ, ningə oyi kadɨ takum’ə to to yan malayka be. ");
INSERT INTO gqr_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","*Kibo lə njekujənyamosɨ kadikare’gɨ dəjɨ ta Etiyenn ene: «Ta’gɨ kɨ de’gɨ eli dɔ’i’tɨ kin, in kɨ rɔta’tɨ inɓe wa?» ");
INSERT INTO gqr_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Etiyenn ilə’tɨ ene: «In baw’m’gɨ kɨ ngannkon’m’gɨ, uri mbi’se oyi dɔ ta kɨ m’a m’el’se kam majɨ. Me ndɔ’gɨ’tɨ kɨ kete, Luwə kɨ nje pitɨ ɔjɨ rɔ’ne adɨ kaw’je Abiraham, dɔkagilo’tɨ kɨ si’n me ɓe’tɨ kɨ Mejopotami’tɨ ɓay, kete ɓay ta kadɨ aw uwə lo kisɨ dɔnangɨ Aram’tɨ, ");
INSERT INTO gqr_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Luwə el’ə ene: “Ində taa inyə ɓe lə’i kɨ nje koji’gɨ ə aw me ɓe’tɨ kɨ m’a m’ɔj’i.” ");
INSERT INTO gqr_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","In be ə, Abiraham inyə’n me ɓe kɨ Kalde ə re uwə lo kisɨ Aram’tɨ. Ningə go koy baw’a’tɨ, Luwə ad’a ində re me ɓe’tɨ kɨ isɨ’tɨ ngɔsine kin. ");
INSERT INTO gqr_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Nya nduwə kɨ Luwə adɨ Abiraham me ɓe’tɨ kin goto. Ngonn nusɨ lo kɨ ndikiri be kaa ad’a el. Nan un ndu’ne ad’a kadɨ n’a n’ad’a ɓe kam ba pətɨ. Taa n’a n’adɨ ngann kaw’a’gɨ tor’o’tɨ tɔ. Dɔkagilo’tɨ kɨ Luwə isɨ elta Abiraham kin, Abiraham ojɨ ngonn el ɓay. ");
INSERT INTO gqr_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ta kɨ Luwə el’ə ə to kin: “Ngannkawi’gɨ a sii to mbah’gɨ dɔnangɨ’tɨ kɨ rangɨ num, de’gɨ a rai’de ɓər’tɨ num, taa de’gɨ a adi’de kon asɨ ɓal ɓu sɔ num tɔ.” ");
INSERT INTO gqr_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Go ta’gɨ’tɨ kin Luwə el ene: “Ginn de’gɨ kɨ rai’de ɓər’tɨ kin, m’inɓe m’a m’gangɨ ta dɔ’de’tɨ. Go’tɨ ningə, a tei me ɓe mbah’tɨ kɨ ra’de ɓər’tɨ kin kɔ, ə a təli rei me ɓe’tɨ kɨ indəi’tɨ ə awi ɓər’tɨ kin kadɨ rei gosi m’in.” ");
INSERT INTO gqr_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ningə Luwə ad’a nya kunmindɨ kɨ in kujə mɔtɨ. Be ə, lokɨ Abiraham ojɨ Isakɨ ningə ndɔ jijoo go’tɨ, par ə ujə mɔt’ɔ. Isakɨ ra be tɔ tadɔ ngonn’o Jakobɨ. Jakobɨ kaa ra be tɔ tadɔ ngann’a’gɨ kɨ in ginn Isirayel’gɨ kɨ dɔgɨ gidə in joo. ");
INSERT INTO gqr_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","«Ningə ni kɨ me ngann’gɨ’tɨ lə Jakobɨ ra adɨ ndogi ngonnkon’de Jisepɨ adɨ awi si’ə to ɓər me ɓe’tɨ kɨ Ejipitɨ’tɨ. Nan Luwə in si’ə nan’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Be ə, ɔr’ɔ me kon’gɨ’tɨ pətɨ. Ningə memajɨ lə Luwə kɨ in si’ə, ad’a kumkədɨ takum Parawon’tɨ kɨ in ngar kɨ Ejipitɨ’tɨ. Adɨ Parawon un’ə ində to nje konɓe dɔnangɨ kɨ Ejipitɨ’tɨ, dɔ me kəy’tɨ lə’ne pətɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Dɔkagilo’ə’tɨ kin ə, ɓo kɨ bo osɨ dɔnangɨ Ejipitɨ’tɨ ba pətɨ, taa dɔnangɨ Kana’tɨ tɔ. In dɔkagilo kumtondoo kɨ ətɨ ɓol ngayn. Lo kadɨ baw’je’gɨ ingəi nya ndikiri sɔi goto. ");
INSERT INTO gqr_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Lokɨ Jakobɨ oo kadɨ nyakusɔ to me ɓe’tɨ kɨ Ejipitɨ’tɨ ningə, ulə ngann’ne’gɨ kɨ in kaw’je’gɨ adɨ awi kɨ dɔkete. ");
INSERT INTO gqr_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Lokɨ təl ulə’de kɨ nja joo ningə, Jisepɨ ra adɨ ngannkon’a’gɨ gəri’ə. Lo kin’tɨ, Parawon kaa, gər’n ginn kojɨ lə Jisepɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Go’tɨ ningə, Jisepɨ ulə go baw’ne Jakobɨ’tɨ ad’a re kɨ ginn kojɨ li’ə ba pətɨ, asi de’gɨ dɔsiri gidə in mi. ");
INSERT INTO gqr_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Jakobɨ aw Ejipitɨ’tɨ ningə oy kɨ kete non. Kaw’je’gɨ kaa oyi non num tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Təli kɨ singə’de rei dɔnangɨ Kana’tɨ, me ɓebo’tɨ kɨ tɔ’a nan Sisem. Duwi’de ɓe ninn’tɨ kɨ Abiraham ndogɨ kɨ nar ji ngann lə Hamɔr me ɓe’tɨ kɨ Sisem. ");
INSERT INTO gqr_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","«Dɔkagilo tɔl kon kunndu kɨ Luwə un adɨ Abiraham in ndəkba. Ningə kɔr ngann Isirayel’gɨ banyi kɨ dɔ mad’a’tɨ dɔ mad’a’tɨ dɔnangɨ Ejipitɨ’tɨ, ");
INSERT INTO gqr_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","bitɨ dɔkagilo’tɨ kɨ ngar kɨ rangɨ kɨ gər Jisepɨ el on’n ɓe dɔnangɨ Ejipitɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ngar kakin uwə de’gɨ lə’je ra’n kulə kɨ aldɔ majɨ num, adi’de kon num, ta indəi tɔgɨ dɔ’de’tɨ adɨ inyəi ngann’de’gɨ kɨ kasɨ kɔ, bitɨ kadɨ oyi. ");
INSERT INTO gqr_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Dɔkagilo’tɨ kin ə, oji Mojɨ kɨ memajɨ lə Luwə in dɔ’a’tɨ adɨ oti’ə me kəy’tɨ lə baw’a asɨ nanyi mutə. ");
INSERT INTO gqr_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ningə lokɨ dum dɔ’de adɨ iləi’ə kɔ, ngonn lə Parawon kɨ dene te dɔ’a’tɨ, ə un’ə ot’o to ngonn’ne inɓe be. ");
INSERT INTO gqr_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Be ə Mojɨ ingə’n nyando kɨ ɔjidɔ kumkədɨ pətɨ kɨ dɔnangɨ Ejipitɨ’tɨ. Adɨ aw kɨ tɔgɨ me ta kel’ne’tɨ num, me kulə ra’ne’tɨ num tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","«Lokɨ ɓal’a in dɔsɔ ningə, mərta re dɔ’a’tɨ kadɨ n’aw n’oo ngannkon’ne’gɨ kɨ in ngann Isirayel’gɨ. ");
INSERT INTO gqr_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Dɔkagilo’tɨ kɨ in’n kɨ ngannkon’ne’gɨ ə, oo de kare kɨ Ejipitɨ isɨ tində kɨ kare dann’de’tɨ. Be ə, re rɔ dɔ ngonnkon’ne’tɨ adɨ ində de kɨ Ejipitɨ’tɨ kakin tɔl’ɔ. ");
INSERT INTO gqr_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Mojɨ mər kadɨ ngannkon’a’gɨ a gəri tokɨ Luwə ə ulə’n’ə kadɨ n’ta dɔ’de. Nan ngannkon’a’gɨ gəri el. ");
INSERT INTO gqr_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ndɔ kɨ go’tɨ, oo ngannkon’nan’gɨ joo kɨ in Isirayel’gɨ ra rɔ’i nan. Re ra dann’de’tɨ kadɨ ulə’de nojɨ nan’tɨ. El’de ene: “In ngannkon nan’gɨ tɔ, ə bann ə ra tindəi nan be wa?” ");
INSERT INTO gqr_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ningə in kɨ nje tində ngonnkon’ne kakin ɔs’ɔ ngərəngɨ, ə el’ə ene: “Nan ə indəi dɔ’je’tɨ to kibo lə’je, eke njegangɨ ta dann’je’tɨ wa? ");
INSERT INTO gqr_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","In ge tɔl’m tokɨ tagine tɔl’n de kɨ Ejipitɨ’tɨ kakin be ɓay wa?” ");
INSERT INTO gqr_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Lokɨ Mojɨ oo dɔ ta kin ningə, ɓol ra’a, adɨ aw uwə lo kisɨ to mbah dɔnangɨ Madiyan’tɨ. Dɔnangɨ Madiyan’tɨ ə Mojɨ ta dene ojɨ’n ngann’gɨ joo. ");
INSERT INTO gqr_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","«Ɓal dɔsɔ go’tɨ ningə, malayka te bus rɔ’a’tɨ diləlo’tɨ, ndəkba kɨ dɔ mbal Sinay, dann ndonn por’tɨ me ngan’tɨ kɨ isɨ on por. ");
INSERT INTO gqr_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Lokɨ Mojɨ oo nya kin ningə, ndil’ə anyi ur kakɨ. Mojɨ ge kadɨ n’oo nya kin majɨ adɨ ɔtɨ re ndəkba si’ə. Low’ə’tɨ non ə oo’n dɔ ndu Burəɓe ene: ");
INSERT INTO gqr_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“M’in Luwə lə kawi’gɨ, Luwə lə Abiraham, Luwə lə Isakɨ, Luwə lə Jakobɨ.” Mojɨ ɓol dadɨ par par adɨ lo kadɨ un kum’ne kɨ taa goto. ");
INSERT INTO gqr_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ə Burəɓe el’ə ene: “Ɔr sa nja’i’tɨ tadɔ lo kɨ ra’tɨ kam in lo kɨ ar njay. ");
INSERT INTO gqr_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","M’oo kumtondoo lə de’gɨ lə’m me ɓe’tɨ kɨ Ejipitɨ’tɨ. M’oo dɔ tumə kɨ sii tuməi um um, ə m’ur nanga m’re kadɨ m’taa’de m’ilə’de taa. Ningə kɨ ngɔsine kin re adɨ m’uləi Ejipitɨ gogɨ.” ");
INSERT INTO gqr_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","«Oyi majɨ! In Mojɨ kɨ ngannkon’a’gɨ ɔsi’ə ngərəngɨ, ə eli’ə eyina: “Nan indəi dɔ’je’tɨ to kibo lə’je eke njegangɨ ta dann’je’tɨ wa”, inɓe kin ə, Luwə ulə to ngar num, taa nje taa’de ilə’de taa num, kɨ takul tɔgɨ lə malayka kɨ te si’ə bus me ngan’tɨ, kin num tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","In ə te se’de kɨ takul nyara’gɨ kɨ de asɨ ra el num, kɨ takul nyakɔjɨ’gɨ num, me ɓe’tɨ kɨ Ejipitɨ’tɨ. Taa dɔkagilo kɨ isɨ indəi babo kasɨ gangi num ta dɔkagilo’tɨ kɨ rai ɓal dɔsɔ diləlo’tɨ kin num tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Taa in darɔ Mojɨ kɨ kare inɓe kin ɓay ə, el ngann Isirayel’gɨ ene: “Luwə a te kɨ njekeltakita’ne’tɨ kare dann’se’tɨ inɓe’gɨ, kɨ a to to m’in be.” ");
INSERT INTO gqr_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Lokɨ ngann Isirayel’gɨ kawinan diləlo’tɨ kaa, in Mojɨ inɓe kin ə taa ta ta malayka’tɨ dɔ mbal Sinay’tɨ, el kaw’je’gɨ. In ə taa ta kajɨ kin rɔ Luwə’tɨ, kadɨ adɨ’je. ");
INSERT INTO gqr_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Nan kaw’je’gɨ mbeti kadɨ təli rɔ’de go ta’gɨ’tɨ li’ə. Ningə kɨ bo utə, ɔsi’ə ngərəngɨ. Me’de in dɔ təl kaw dɔnangɨ Ejipitɨ’tɨ gogɨ. ");
INSERT INTO gqr_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Dɔkagilo’tɨ kɨ Mojɨ nanyi dɔ mbal Sinay’tɨ ɓay, rei rɔ Aron’tɨ eli’ə eyina: “In ra kagɨ yo’gɨ kɨ kadɨ ɔri non’je, tadɔ jɨ gər nya kɨ ra Mojɨ kɨ nje te se’je me ɓe’tɨ kɨ Ejipitɨ’tɨ kin el.” ");
INSERT INTO gqr_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Be ə me ndɔ’gɨ’tɨ kin, rai ngonn yo madɨ kɨ to to ngonn baw mangɨ be, ə iləi kadikare adi’ə. Ningə rai rɔnel ngayn ɔsikurə nya kɨ inɓe’gɨ rai kɨ ji’de kin. ");
INSERT INTO gqr_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Nan Luwə təl gidɨ’ne adɨ’de, inyə’de kɔ adɨ sii ta ra yo’tɨ, kɨ kɔsikurə nya’gɨ kɨ dɔran’tɨ to nanyi’gɨ kɨ kadɨ’gɨ kɨ mee’gɨ to kagɨ yo’gɨ lə’de, tokɨ ndangi me makitu’tɨ lə njekeltakita Luwə’tɨ: “In de’gɨ kɨ Isirayel, ɓal dɔsɔ kɨ rai diləlo’tɨ kin ke da’gɨ kɨ tɔli’de kɨ ndəgɨ kadikare’gɨ adi, in m’in ə adi m’in wa? ");
INSERT INTO gqr_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Jagɨ, oti kəy yo lə kagɨ yo lə’se Molokɨ yo, kɨ mee kagɨ yo lə’se Repan, yo’gɨ kɨ inɓe’gɨ rai’de kɨ ji’se kadɨ ɔsi məkəsɨ’se non’de’tɨ. Tadɔ in nya ra’se’gɨ kin ə, m’a m’adɨ njeban’gɨ lə’se a uwəi’se, awi sese sanyi to mbah’gɨ gidɨ Babilon’tɨ ɓay.” ");
INSERT INTO gqr_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","«Me diləlo’tɨ, kaw’je’gɨ rai *kəyku kingə nan kɨ Luwə. Mojɨ ra kəyku kakin tokɨ Luwə un’n ndu’ne ad’a. In ra kigo kɔjɨ’tɨ kɨ ɔj’ɔ ad’a oo. ");
INSERT INTO gqr_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ingəi kəyku kakin uni ginn kojɨ’gɨ lə’de kɨ rangɨ, kɨ in kaw’je’gɨ kɨ rei go’de’tɨ. Kəyku kin in ji’de’tɨ, lokɨ Jojuwe ɔrnon’de adɨ rei tai dɔnangɨ lə ginn de’gɨ kɨ dangɨ dangɨ kɨ Luwə tuwə’de non’de’tɨ. Kəyku kakin, to bitɨ dɔkagilo’tɨ lə Dabidɨ. ");
INSERT INTO gqr_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Memajɨ lə Luwə ɔsɨ Dabidɨ adɨ dəjɨ tarow kadɨ n’ra Kəy n’adɨ Luwə lə Jakobɨ. ");
INSERT INTO gqr_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Nan in Salomon yo ə ra kəy adɨ Luwə. ");
INSERT INTO gqr_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","«Nan Luwə kɨ in nje kisɨ dɔ nya’gɨ’tɨ pətɨ, a isɨ me kəy’tɨ kɨ de ra kɨ ji’ne el. Tokɨ njekeltakita’a’tɨ ene: ");
INSERT INTO gqr_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“Dɔran in kumbər ngar lə’m, ningə dɔnangɨ in nyakində nja’m.” Burəɓe el ɓay ene: “Kəy kɨ bann ə, a rai adi m’in wa? Lo kɨ ra a in lo kuwə rɔ lə’m wa? ");
INSERT INTO gqr_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ke in m’in el ə, nan to ɓay ə, ra nya’gɨ kin pətɨ wa?” ");
INSERT INTO gqr_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","«In de’gɨ kɨ nje tanrɔ’gɨ, tei me’se el num, boyi mbi’se num dɔ ta’tɨ lə Luwə to de’gɨ kɨ nje gər Luwə el be. Toi to baw’se’gɨ inɓe be. Nya kin ə ra adɨ, sii ta rɔ kɨ Ndil Luwə’tɨ, kɨ dɔkagilo’gɨ pətɨ. ");
INSERT INTO gqr_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","*Njekeltakita Luwə’tɨ kɨ ra ə baw’se’gɨ adi’ə kon el wa? Ingɨ ə tɔli njekiləmbər kete, kɨ ɔjidɔ re lə in kɨ kareba, kɨ in kɨ dana. Ningə ngɔsine, lokɨ Kirisitɨ re, ingɨ uni dɔ’a, ə tɔli’ə tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Oyo, ingəi ndukun lə Luwə kɨ takul malayka’gɨ, nan lo kadɨ təli rɔ’se go’tɨ goto.» ");
INSERT INTO gqr_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Lokɨ njegangɨ ta’gɨ kibo lə Juwipɨ’gɨ oyi dɔ ta kɨ Etiyenn el ningə, wongɨ ra’de ngayn adɨ ngori ngangɨ’de mur mur dɔ’a’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Nan Etiyenn kɨ rosɨ kɨ Ndil Luwə, un kum’ne ta kɨ dɔran’tɨ ningə oo pitɨ lə Luwə num, taa oo Jeju kɨ ra taa dɔjikɔl Luwə’tɨ num tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","El ene: «Oyi, m’oo dɔran til, ningə m’oo Ngonn De ra taa dɔjikɔl Luwə’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Lokɨ oyi dɔ ta kin ningə, uri kɔl kɨ ndu’de kɨ bo ə uti mbi’de dɔ ta’tɨ li’ə, ə ɓuki nan dɔ’a’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ndɔri’ə ai si’ə taga gidɨ ɓebo’tɨ, tiləi’ə kɨ gajɨ mbal tɔli’ə. De’gɨ kakin inyəi ku’gɨ lə’de rɔ ngonn kɨ basa’tɨ kɨ tɔ’a nan Sol. ");
INSERT INTO gqr_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Dɔkagilo’tɨ kɨ isɨ tiləi’ə kɨ gajɨ mbal, Etiyenn elta kɨ Luwə ene: «Burəɓe Jeju, taa ndil’m kɨ rɔ’i’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Go’tɨ ningə ɔsɨ məkəsɨ’ne nanga, ə elta kɨ ndu’ne kibo ene: «Inyə go majel kin kɔ adɨ’de!» Go ta’gɨ’tɨ kin, ningə Etiyenn oy. ");
INSERT INTO gqr_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sol in mbunə de’gɨ’tɨ kɨ ndigɨ kadɨ tɔli Etiyenn. Me ndɔ’a’tɨ kin kindəkumndoo kibo ngayn te dɔ Njekawnan’gɨ’tɨ kɨ Jerujalem. Adɨ njekunme’gɨ pətɨ sananyinan kigo lo’gɨ. Awi kɨ Jude’gɨ’tɨ kɨ Samari’gɨ’tɨ. Njekawkulə’gɨ inɓe par ə nanyinan Jerujalem’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","De’gɨ kɨ nje ɓol Luwə duwi Etiyenn, nonyi’ə kɨ kuwəndoo kɨ ngayn. ");
INSERT INTO gqr_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Nan Sol, ɔr Njekawnan’gɨ njan. Aw kɨ takəy takəy uwə dingəm’gɨ kɨ dene’gɨ ɓukɨ’de dangay’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Nje kɨ sananyinan kakin awi kɨ lo lo iləi mbər Poyta kɨ majɨ. ");
INSERT INTO gqr_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","In be ə, Pilipɨ kɨ aw me ɓebo’tɨ kɨ *Samari, ilə de’gɨ mbər Poyta kɨ majɨ lə Kirisitɨ kɨ in De kɨ Luwə mbət’ə. ");
INSERT INTO gqr_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Bulə de’gɨ ba pətɨ, lokɨ oyi ta’gɨ kɨ Pilipɨ el ge kɨ nyakɔjɨ’gɨ kɨ ra adɨ oyi kɨ kum’de ningə, uri mbi’de kɨ dɔ ta’tɨ li’ə. ");
INSERT INTO gqr_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Tadɔ ndil’gɨ kɨ majel tei me njemonyi’gɨ’tɨ ngayn kɨ non kɨ boi ta’de’tɨ. Taa, de’gɨ kɨ rɔ’de oy kɨ nje mote’gɨ ngayn ingəi lapiya tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Rɔnel kɨ bo ngayn to me ɓebo’tɨ kin. ");
INSERT INTO gqr_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Kete taa kadɨ Pilipɨ re, dingəm madɨ kɨ tɔ’a nan Simon isɨ me ɓebo’tɨ kin non. In njera mboli, adɨ ɔr ndil de’gɨ kɨ me ɓe’tɨ kɨ Samari ngayn. Nga ra rɔ’ne kadɨ n’in de madɨ kɨ ətɨ ɓol ngayn. ");
INSERT INTO gqr_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Adɨ de’gɨ pətɨ: in dɔ ngann’gɨ’tɨ kɨ du, bitɨ kɨ dɔ de’gɨ’tɨ kɨ tɔgɨ’tɨ, hangal’de in kɨ dɔ’a’tɨ. Eli eyina dingəm kam aw kɨ tɔgɨ lə Luwə kɨ in tɔgɨ kɨ ətɨ ɓol ngayn. ");
INSERT INTO gqr_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Hangal de’gɨ in kɨ dɔ’a’tɨ, tadɔ in mayinu ə isɨ ɔr ndil’de kɨ mboli kɨ ra lə’ne. ");
INSERT INTO gqr_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Nan lokɨ de’gɨ uni me’de Pilipɨ kɨ ilə’de mbər Poyta kɨ majɨ kɨ ɔjidɔ Konɓe lə Luwə num, kɨ Jeju Kirisitɨ num tɔ ningə, dingəm’gɨ kɨ dene’gɨ adi Pilipɨ ra’de batəm. ");
INSERT INTO gqr_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simon inɓe kɨ dɔ’ne kaa un me’ne tɔ. Lokɨ Pilipɨ ra’a batəm ningə, inyə go Pilipɨ el. Lokɨ oo nyakɔjɨ’gɨ kɨ nya’gɨ kɨ ətɨ ɓol ngayn kakin ningə, inɓe təl re ət’ə ɓol ngayn ɓay. ");
INSERT INTO gqr_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Lokɨ njekawkulə’gɨ kɨ sii Jerujalem’tɨ oyi kadɨ de’gɨ kɨ Samari’tɨ taai ta lə Luwə ningə, uləi Piyər ingɨ kɨ Jan rɔ’de’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Lokɨ rei tei Samari’tɨ ningə, elita kɨ Luwə kadɨ njekunme’gɨ ingəi Ndil Luwə. ");
INSERT INTO gqr_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Tadɔ Ndil re dɔ de madɨ’tɨ kare dann’de’tɨ el ɓay. In batəm par ə rai’de me tɔ Burəɓe Jeju’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","In be ə, Piyər ingɨ kɨ Jan indəi ji’de dɔ’de’tɨ kadɨ ingəi Ndil Luwə. ");
INSERT INTO gqr_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Lokɨ Simon oo kadɨ in kɨ gorow lə ji kɨ kində dɔ’tɨ lə njekawkulə’gɨ ə Ndil Luwə re’n dɔ nje kunme’gɨ’tɨ ningə, adɨ Piyər ingɨ kɨ Jan nar, ");
INSERT INTO gqr_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ə el’de ene: «M’in kaa adi’m’in tɔgɨ kin tɔ kadɨ to de kɨ m’a m’ində ji’m dɔ’a’tɨ ə, ingə Ndil Luwə tɔ.» ");
INSERT INTO gqr_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ə Piyər el’ə ene: «Kadɨ nar lə’i kin tujɨ nan’tɨ kɨ darɔ’i. Tadɔ ində me’i’tɨ kadɨ a ndogi kadikare lə Luwə kɨ nar. ");
INSERT INTO gqr_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Nya kɨ ɓar tɔ’i, eke nya kɨ sɔw dɔ’i goto me nya’tɨ kɨ jɨ ra’n kam, tadɔ me’i in dana non Luwə’tɨ el. ");
INSERT INTO gqr_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Majɨ kadɨ tɔr ndu’i dɔ majel’tɨ lə’i, ə elta kɨ Burəɓe adɨ re to bann ə, inyə go kɔjitara’gɨ kɨ me’i’tɨ kin kɔ. ");
INSERT INTO gqr_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Tadɔ m’oo kadɨ me’i atɨ kangɨ, taa nya kɨ gorow’ə’tɨ el doloi dolo tɔ.» ");
INSERT INTO gqr_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Nga a, Simon el Piyər ingɨ kɨ Jan ene: «Kadɨ inɓe’gɨ elita kɨ Burəɓe tadɔ lə’m, kadɨ nya madɨ kare me nya’gɨ’tɨ kɨ elita’a kin te dɔ’m’tɨ el.» ");
INSERT INTO gqr_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Lokɨ Piyər ingɨ kɨ Jan manyinajɨ, ə ndoi ta lə Burəɓe tɔ ningə, təli kɨ Jerujalem’tɨ gogɨ. Iləi mbər Poyta kɨ majɨ me ngann ɓe’gɨ’tɨ kɨ Samari ngayn kɨ gorow gorow. ");
INSERT INTO gqr_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ndɔ kare malayka lə Burəɓe el Pilipɨ ene: «Ində taa aw kɨ holo be, dɔ row’tɨ kɨ in Jerujalem aw kɨ Gaja’tɨ, kɨ in row kɨ diləlo’tɨ kin.» ");
INSERT INTO gqr_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Pilipɨ ində taa kalangɨ aw ningə, ingə dingəm kare kɨ dɔnangɨ Etiyopi, kɨ in kɨ boi, kɨ njengəm nya majɨ’gɨ lə ngar kɨ dene kɨ Etiyopi’tɨ, kɨ tɔ’a nan Kandasɨ. Dingəm kin aw Jerujalem’tɨ ɔsɨ dɔ’ne nanga non Luwə’tɨ ə isɨ təl kɨ ɓe gogɨ. ");
INSERT INTO gqr_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Isɨ me pusɨ’tɨ lə’ne, isɨ tudə makitu lə njekeltakita Luwə’tɨ Ejay. ");
INSERT INTO gqr_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Lo kin’tɨ, Ndil Luwə el Pilipɨ ene: «Ɔtɨ aw ndəkba kɨ rɔ pusɨ’tɨ kin.» ");
INSERT INTO gqr_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Pilipɨ anyi ngodɨ aw ningə, oo ndu dingəm kɨ Etiyopi’tɨ kakin isɨ tudə makitu lə njekeltakita Luwə’tɨ Ejay. Pilipɨ dəj’ə ene: «In gər me ta kɨ isɨ tudə kin majɨ inɓe wa?» ");
INSERT INTO gqr_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Dingəm kakin el’ə ene: «Re nje kɔr me’ə kadɨ’m goto ə m’a m’gər me’ə bann wa?» Ningə dəjɨ Pilipɨ ad’a ala taa go’ə’tɨ, isɨ gəd’ə’tɨ me pusɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ta kɨ isɨ tudə ə to kin: «Ɔri’ə to batɨ kɨ de isɨ aw si’ə kadɨ tɔl’ɔ be; To ngonn batɨ kɨ ra ta’ne mbo non nje kujə bin’ne’tɨ be. In be ə, te’n ta’ne el. ");
INSERT INTO gqr_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Uləi rɔsɔl dɔ’a’tɨ, gangi ta li’ə kɨ gorow kɨ dana el. Nan a ɔr ginn kojɨ li’ə wa? Tadɔ indəi ngangɨ ndɔ kisikidɔtaa li’ə.» ");
INSERT INTO gqr_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ningə, kujɨ dingəm un ta el Pilipɨ ene: «M’dəj’i kadɨ el’m adɨ m’oo, nan ə njekeltakita Luwə’tɨ isɨ elta li’ə be wa? Sɨ elta kɨ dɔ rɔ’ne’tɨ inɓe eke isɨ elta dɔ de madɨ’tɨ kɨ rangɨ wa?» ");
INSERT INTO gqr_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Lo kin’tɨ nga a, Pilipɨ ingə row adɨ un ta ta’ne’tɨ, ningə kɨ row lə makitu lə njekeltakita Luwə’tɨ Ejay kin, ilə’n mbər Poyta kɨ majɨ lə Jeju. ");
INSERT INTO gqr_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Lokɨ njiyəi isɨ awi ningə, tei ta mann’tɨ, ə kujɨ dingəm kakin el ene: «Mann ə ra’m, nga ri ə ɔgɨ kadɨ m’ra batəm wa?» ");
INSERT INTO gqr_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Pilipɨ el’ə ene: «Re un me’i adɨ Luwə tokɨ rɔta’tɨ ə, nya kɨ ɔgi ra batəm goto.» Kujɨ dingəm ene: «M’un me’m tokɨ Jeju Kirisitɨ in Ngonn Luwə.» ");
INSERT INTO gqr_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Lo kin’tɨ, adɨ pusɨ ra lokatɨ, ningə ingɨ kɨ Pilipɨ joo pətɨ, uri me mann’tɨ adɨ Pilipɨ ra’a batəm. ");
INSERT INTO gqr_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Lokɨ tei me mann’tɨ kɨ taga ningə, Ndil Burəɓe un Pilipɨ aw si’ə adɨ kujɨ dingəm oo’ə el. Nan in ulə row lə’ne kɨ rɔnel aw. ");
INSERT INTO gqr_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Pilipɨ aw te me ɓe’tɨ kɨ Ajotɨ, iləmbər Poyta kɨ majɨ me ɓebo’gɨ’tɨ pətɨ kɨ te’tɨ, bitɨ te’n Sejare’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Dɔkagilo’ə’tɨ kin, mərta kɨ dɔ kadɨ kon njendo’gɨ’tɨ lə Burəɓe kɨ dɔ tɔl de’tɨ to dɔ Sol’tɨ ɓay. Be ə, aw rɔ kibo’tɨ lə njekujənyamosɨ kadikare’gɨ, ");
INSERT INTO gqr_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","dəj’ə makitu kadɨ n’aw’n kəykawnan’gɨ’tɨ lə Juwipɨ’gɨ kɨ me ɓe’tɨ kɨ Damasɨ, kadɨ re n’ingə dingəm’gɨ kɨ dene’gɨ kɨ nje ndolo go nyando kɨ sigɨ kin ə n’uwə’de n’re se’de Jerujalem’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Lokɨ Pol in dɔ row’tɨ, ində dɔ ɓe kɨ Damasɨ ndəkba ningə, kunjɨ madɨ te bus, in kɨ dɔran’tɨ, unjɨ gugɨ dɔ’a. ");
INSERT INTO gqr_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Te osɨ nanga ningə, oo dɔ ndu ta madɨ el’ə ene: «Sol, Sol, tadɔ ri ə isɨ adɨ’m kon be wa?» ");
INSERT INTO gqr_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sol dəj’ə ene: «In nan Burəɓe?» Ningə, Burəɓe el’ə ene: «In m’in Jeju kɨ isɨ adɨ’m kon.» ");
INSERT INTO gqr_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ində taa aw me ɓebo’tɨ ə, a eli’nu nya kɨ kadɨ a ra. ");
INSERT INTO gqr_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Nje kɨ isɨ ai kɨ Pol təli rai lokatɨ. Ɓol tɔl’de adɨ lo kadɨ elita goto. Oyi dɔ ndu ta, nan oyi de madɨ el. ");
INSERT INTO gqr_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sol ində taa, te kum’ne majɨ, nan oo lo el, adɨ mad’a’gɨ uwəi ji’ə, ndɔri’ə to ndɔr, ə awi si’ə Damasɨ. ");
INSERT INTO gqr_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Sɨ low’ə’tɨ non ndɔ mutə kɨ kanjɨ kadɨ oo lo. Sɔ nya el num, anyi mann el num tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ningə njendo lə Jeju kare isɨ Damasɨ’tɨ non, tɔ’a nan Ananiyasɨ. Burəɓe ɓar’a me nya koo me ndil’tɨ ene: «Ananiyasɨ», ningə Ananiyasɨ ndigɨ ene: «M’in ne Burəɓe.» ");
INSERT INTO gqr_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Burəɓe təl un taa el’ə ene: «Aw un row kɨ ɓari’ə row kɨ kɔl’tɨ, ə dəjɨ me kəy’tɨ lə Judasɨ, de kɨ tɔ’a nan Sol kɨ Tarsɨ’tɨ, isɨ non isɨ elta kɨ Luwə. ");
INSERT INTO gqr_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Oo de madɨ kɨ tɔ’a nan Ananiyasɨ me nya koo me ndil’tɨ, ur kəy go’ə’tɨ ningə, ində ji’ne dɔ’a’tɨ kad’a oo lo gogɨ.» ");
INSERT INTO gqr_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ə Ananiyasɨ el ene: «Burəɓe, m’oo ta lə de kin ta de’gɨ’tɨ ngayn, ɔjidɔ kon’gɨ pətɨ kɨ adɨ de’gɨ lə’i kɨ me ɓe’tɨ kɨ Jerujalem. ");
INSERT INTO gqr_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ningə, kɨ ne kin, re kɨ tɔgɨ kɨ ingə rɔ kibo’gɨ lə njekujənyamosɨ kadikare’gɨ, kadɨ uwə de’gɨ kɨ isɨ eli sə’i ta, dɔɔ’de.» ");
INSERT INTO gqr_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Nan Burəɓe el’ə ene: «Aw, tadɔ dingəm kin in nyara kulə kɨ m’mbət’ə kadɨ elta lə’m non ginn de’gɨ’tɨ kɨ dɔnangɨ’tɨ, kɨ non ngar’gɨ’tɨ, kɨ non Isirayel’gɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","M’inɓe m’a m’ɔj’ɔ kon’gɨ pətɨ kɨ a te dɔ’a’tɨ tadɔ lə’m.» ");
INSERT INTO gqr_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ananiyasɨ aw, ur kəy ində ji’ne dɔ’a’tɨ, ningə el’ə ene: «Ngonnkon’m Sol, in Burəɓe ə ulə’m, in Jeju ka kɨ te ingəi dɔ row’tɨ kɨ isɨ re’n kakin ə ulə’m kadɨ m’ad’i oo lo. Ningə kadɨ Ndil Luwə rosi tɔ.» ");
INSERT INTO gqr_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Tanan’tɨ non, nya’gɨ kɨ toi to ngɔy kanjɨ’gɨ be tei kum Sol’tɨ tosi, adɨ təl oo lo gogɨ, ningə ində taa adɨ rai’ə batəm. ");
INSERT INTO gqr_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Go’tɨ, sɔ nya ə, təl ingə tɔgɨ’ne gogɨ. Sol təl isɨ kɨ njendo’gɨ lə Jeju kɨ me ɓe’tɨ kɨ Damasɨ ndɔ’gɨ jɔ ɓay. ");
INSERT INTO gqr_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Tanan’tɨ non, Sol aw iləmbər me kəykawnan’gɨ’tɨ lə Juwipɨ’gɨ ene: «Jeju in Ngonn lə Luwə.» ");
INSERT INTO gqr_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","De’gɨ pətɨ kɨ oyi dɔ ta kin ta Sol’tɨ, ndɔjɨ’de ngayn adɨ eli eyina: «In kam el ə in nje kadɨ kon de’gɨ kɨ Jerujalem’tɨ kɨ nje ɓari tɔ kin wa? Re ra un girə kadɨ uwə’de, dɔɔ’de aw se’de rɔ kibo’gɨ lə njekujənyamosɨ kadikare’gɨ el bitɨ wa?» ");
INSERT INTO gqr_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Nan Sol uwə rɔ’ne ngan adɨ kum’ə in kete me kunme’tɨ li’ə. Juwipɨ’gɨ kɨ Damasɨ’tɨ gəri lo ta kɨ kadɨ eli’ə el, lokɨ tɔjɨ’de kadɨ Jeju in Kirisitɨ De kɨ Luwə mbət’ə. ");
INSERT INTO gqr_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Nga ndɔ’gɨ go’tɨ ngayn el ə, Juwipɨ’gɨ ɔjinan ta kadɨ n’tɔli’ə ");
INSERT INTO gqr_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Nan ta kɔjɨ lə’de te mbi Sol’tɨ. Ngəmi tarow kada ge kondɔ ge kadɨ n’tɔli’ə. ");
INSERT INTO gqr_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Be ə, me kondɔ’tɨ madɨ, njendo’gɨ lə Sol, uni’ə me kara’tɨ, tuyi’ə adɨ osɨ gidɨ ndogɨ bɔr’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Go’tɨ, Sol aw te me ɓe’tɨ kɨ Jerujalem ə, sangɨ kadɨ n’ində rɔ’ne nan’tɨ kɨ njendo’gɨ, nan pətɨ ɓoli’ə, tadɔ de kɨ un me’ne ad’a kadɨ in njendo kɨ rɔta’tɨ goto. ");
INSERT INTO gqr_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Be ə, Barnabasɨ un’ə me ji’ne’tɨ, aw si’ə rɔ njekawkulə’gɨ’tɨ, ɔr’de go kingə kɨ Jeju ingə Sol dɔ row’tɨ, kɨ k’oo kɨ oo Jeju el’ə ta, kɨ ta kɨ el kɨ taga wangɨ Damasɨ’tɨ me tɔ Jeju’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Dɔkagilo’ə’tɨ gangɨ low’ə’tɨ non, Sol aw se’de ge, təl se’de ge nan’tɨ me ɓe’tɨ kɨ Jerujalem. Elta kɨ kunme me tɔ Burəɓe’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Elta kɨ Juwipɨ’gɨ kɨ nje kelta Girekɨ, manjinan se’de ta’tɨ. Nan sangi row kadɨ n’tɔli’ə. ");
INSERT INTO gqr_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Lokɨ ngannkon’gɨ oyi ta’a ningə, ɔri’ə awi si’ə Sejare’tɨ. Ningə adi’ə aw me ɓe’tɨ kɨ Tarsɨ. ");
INSERT INTO gqr_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Njekawnan’gɨ pətɨ kɨ dɔnangɨ Jude’tɨ, kɨ dɔnangɨ Galile’tɨ, kɨ dɔnangɨ Samari’tɨ, sii kɨ lapiya. Ingəi tɔgɨ, njiyəi me ɓol Burəɓe’tɨ, taa kɔr’de in kɨ dɔ mad’a’tɨ dɔ mad’a’tɨ kɨ takul tɔgɨ lə Ndil Luwə tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Tokɨ Piyər a njiyə’n kɨ lo’gɨ pətɨ oo’n de’gɨ lə Luwə, ndɔ kare aw te rɔ nje’gɨ’tɨ kɨ me ɓe’tɨ kɨ Lida. ");
INSERT INTO gqr_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Lo kin’tɨ, ingə dingəm kare kɨ tɔ’a nan Ene, kɨ to dɔ tirə monyi’tɨ ra ɓal jijoo. Tadɔ rɔ’a oy. ");
INSERT INTO gqr_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Piyər el’ə ene: «Ene, Jeju Kirisitɨ adi lapiya, ində taa, kaw nya toi.» Ningə Ene ində taa tanan’tɨ non. ");
INSERT INTO gqr_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","De’gɨ pətɨ kɨ me ɓe’tɨ kɨ Lida kɨ Saron oyi’ə, ə uni me’de adi Burəɓe. ");
INSERT INTO gqr_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Dene madɨ in dann njendo’gɨ’tɨ kɨ me ɓebo’tɨ kɨ Jope non, tɔ’a nan Tabita. Tɔ kin kɨ ta Girekɨ nan Dorkasɨ. In dene kɨ nje ra kulə’gɨ kɨ majɨ majɨ ngayn, taa in njera kɨ njendoo’gɨ kɨ nya kɨ me ji’ne’tɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Monyi ra’a dɔkagilo’ə’tɨ kin adɨ oy. Lokɨ ndogi’ə mann ningə, ai iləi’ə me kəy’tɨ kɨ kare taa. ");
INSERT INTO gqr_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ɓe kɨ Lida in ndəkba kɨ Jope. Be ə, lokɨ njendo’gɨ oyi kadɨ Piyər in me ɓe’tɨ kɨ Lida non ningə, uləi dingəm’gɨ joo rɔ’a’tɨ kadɨ re kalangɨ ingə’de. ");
INSERT INTO gqr_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Piyər ində taa aw se’de. Lokɨ re te rɔ’de’tɨ ningə, ɔri’ə awi si’ə me kəy’tɨ kɨ taa. Njengawkoy’gɨ pətɨ iləi nan gugi dɔ’a kɨ non, ningə tɔji ku’gɨ kɨ dangɨ dangɨ kɨ kojɨ tanan’tɨ kɨ Dorkasɨ ojɨ dɔkagilo’tɨ kɨ si’n se’de kɨ dɔ’ne taa ɓay. ");
INSERT INTO gqr_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Piyər adɨ de’gɨ pətɨ tei taga, ə ɔsɨ məkəsi’ne nanga elta kɨ Luwə, ningə yətɨ rɔ’ne kɨ rɔ ninn’tɨ el ene: «Tabita ində taa.» Lokɨ te kum’ne oo Piyər ningə, ndu rɔ’ne, ində isɨ taa. ");
INSERT INTO gqr_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Piyər ulə ji’ne un’ə’n’ə kɨ taa, ə, ɓar de’gɨ lə Luwə kɨ njengawkoy’gɨ, ɔjɨ’de Tabita kɨ dɔ’a taa. ");
INSERT INTO gqr_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Poy nya kin sanan kɨ dɔnangɨ kɨ Jope ba pətɨ, adɨ de’gɨ ngayn uni me’de adi Burəɓe. ");
INSERT INTO gqr_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Piyər ra ndɔ asɨ tatɨ me ɓe’tɨ kɨ Jope, me kəy’tɨ lə nje kɔr gidɨ ngirə kɨ tɔ’a nan Simon. ");
INSERT INTO gqr_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Dingəm madɨ isɨ me ɓe’tɨ kɨ Sejare non, tɔ’a nan Kɔrney. In kɨ boi dɔ kutɨ njerɔ’gɨ’tɨ kɨ ɓu kare, kɨ ɓari’ə «kutɨ kɨ Itali’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","In de kɨ njera nya kigo ndu Luwə’tɨ, taa, nan’tɨ kɨ de’gɨ pətɨ kɨ me kəy’tɨ li’ə, in nje kɔsɨ məkəsɨ’de nanga non Luwə’tɨ tɔ. Nga ra majɨ kɨ njendoo’gɨ ngayn, taa elta kɨ Luwə taa taa tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ndɔ kare, kɨ kadɨ kɨ mutə kɨ losɔl’ɔ, oo malayka lə Luwə me nya koo me ndil’tɨ ur me kəy’tɨ li’ə, ningə ɓar’a ene: «Kɔrney.» ");
INSERT INTO gqr_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Kɔrney ur kɨ kum’ne dɔ’a’tɨ kɨ ɓol, ningə el’ə ene: «In ri ə Burəɓe?» Nga a malayka el’ə ene: «Kelta kɨ Luwə lə’i kɨ majɨ kɨ isɨ ra kɨ njendoo’gɨ kin te rɔ Luwə’tɨ, ə Luwə ra majɨ ɔjɨ’n dɔ’i. ");
INSERT INTO gqr_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Ningə kɨ ngɔsine kin, ulə dingəm’gɨ me ɓe’tɨ kɨ Jope adɨ ɓari Simon kɨ ɓari’ə nan Piyər ad’a re. ");
INSERT INTO gqr_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Isɨ me kəy’tɨ lə Simon kɨ nje kɔr gidɨ ngirə kɨ kəy li’ə in kadɨ batɨ. ");
INSERT INTO gqr_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Lokɨ malayka kɨ el’ə ta kin ɔtɨ ningə, Kɔrney ulə ngann nje kulə’gɨ lə’ne joo kɨ nje rɔ lə’ne kare kɨ nje ɓol Luwə mbunə nje kɨ in nan’tɨ si’ə kɨ dɔkagilo’gɨ pətɨ adɨ’de rei. ");
INSERT INTO gqr_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Rei adɨ ɔr’de go nya’gɨ pətɨ kɨ ra nya adɨ’de oyi ningə, ulə’de adɨ ai Jope’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Lo ti go’tɨ, lokɨ in dɔ row’tɨ isɨ awi, indəi dɔ ɓebo ndəkba ningə, Piyər ala dɔ kəy’tɨ kɨ taa kɨ kadɨ kɨ dann ɓe’tɨ tadɔ kelta kɨ Luwə. ");
INSERT INTO gqr_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ɓo ra’a adɨ ge kusɔ nya. Ningə lokɨ isɨ rai nyakusɔ kadɨ sɔ ə, oo nya me ndil’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Oo dɔran ra tagira, ningə oo nya madɨ kɨ to to ta ku kɨ tatɨ kɨ de uwə silə’gɨ kɨ sɔ be ə in kɨ taa isɨ re kɨ nanga. ");
INSERT INTO gqr_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Me nya’tɨ kin non, da’gɨ kɨ dangɨ dangɨ in səm’tɨ: da’gɨ kɨ nja’de in sɔ ge kɨ nje kagɨ nanga ge kɨ yəl’gɨ. ");
INSERT INTO gqr_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ningə, ndu ta madɨ te el’ə ene: «Piyər, ində taa tɔl sɔ.» ");
INSERT INTO gqr_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Nan Piyər ene: «Jagɨ Burəɓe, m’in m’njɔ nya kɨ majel ɔd’ɔ, eke nya kɨ to njen nja kare el.» ");
INSERT INTO gqr_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ndu ta təl re el Piyər kel kɨ nja joo ɓay ene: «Nya kɨ Luwə təl’ə kɨ kar njay’tɨ, kadɨ in oo’ə to in nya kɨ to njen el.» ");
INSERT INTO gqr_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Nya kin ra nya be nja mutə, ningə tanan’tɨ non təli ndɔri’ə kɨ dɔran’tɨ gogɨ. ");
INSERT INTO gqr_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Piyər gər me nya kɨ oo me ndil’tɨ kin el, adɨ isɨ dəjɨ rɔ’ne ta dɔ’tɨ, ningə nyɨ dingəm’gɨ kɨ Kɔrney ulə’de kɨ ra sangi kəy lə Simon rei rai ta kəy’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ningə dəji ta kɨ ndu’de kɨ boi eyina: «In me kəy kin ə Simon kɨ ɓari’ə nan Piyər isɨ səm’tɨ wa?» ");
INSERT INTO gqr_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Piyər isɨ mərta dɔ nya’tɨ kɨ oo me ndil’tɨ kin ba ɓay ningə, Ndil Luwə el’ə ene: «Oo dingəm’gɨ mutə ra sangi’nu. ");
INSERT INTO gqr_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Ində taa, ur nanga, ə aw se’de kɨ kanjɨ kadɨ me’i tɔsɨ, tadɔ in m’in ə m’ulə’de.» ");
INSERT INTO gqr_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Piyər re rɔ dingəm’gɨ’tɨ kakin el’de ene: «In m’in ə m’in de kɨ isɨ sangi’ə, eke in ri ə isɨ sangi m’in tɔ wa?» ");
INSERT INTO gqr_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Eli’ə eyina: «In Kɔrney kɨ in kɨ boi dɔ kutɨ njerɔ’gɨ’tɨ kɨ ɓu, kɨ in de kɨ dana, taa in nje ɓol Luwə tɔ kin ə ulə’je. In de kɨ Juwipɨ’gɨ pətɨ elita li’ə majɨ. Malayka kɨ ar njay re te kɨ dɔ ta rɔ’a’tɨ el’ə kadɨ ulə go’i’tɨ kadɨ re me kəy’tɨ li’ə kadɨ oo dɔ ta kɨ ta’i’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Piyər aw se’de ra’de mbah, adɨ’de lo toi’tɨ. Lokɨ lo ti go’tɨ ningə, ində taa aw se’de. Ngannkon’gɨ madɨ kɨ me ɓe’tɨ kɨ Jope dani’ə. ");
INSERT INTO gqr_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Lo ti kɨ rangɨ ningə tei Sejare’tɨ. Kɔrney ɓar nojɨ’ne’gɨ kɨ madɨ’ne’gɨ isɨ nginə’n’de kete. ");
INSERT INTO gqr_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Lokɨ Piyər ur me kəy’tɨ ningə, Kɔrney ində taa tilə kum’ə, ə osɨ nanga nja’a’tɨ, ulə dɔ’ne nanga. ");
INSERT INTO gqr_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Nan Piyər el’ə ene: «Ində taa, tadɔ m’in ka m’in de tɔ.» Ningə ɔsɨ kɔy’ɔ un’n’ə kɨ taa. ");
INSERT INTO gqr_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Wali nan taa uri kɨ kəy ningə, Piyər oo bulə de’gɨ ngayn kawinan sii. ");
INSERT INTO gqr_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Lo kin’tɨ Piyər el’de ene: «Ingɨ, in gəri majɨ tokɨ ndukun lə’je ɔgɨ kadɨ de kɨ in Juwipɨ ində rɔ’ne nan’tɨ kɨ de kɨ in Juwipɨ el, eke kadɨ ur me kəy’tɨ li’ə. Nan Luwə el’m kadɨ m’oo de madɨ to nya kɨ majel, eke nya kɨ to njen el. ");
INSERT INTO gqr_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Tadɔ kin ə, m’mbətɨ’n ɓar lə’se el, m’re kɨ kanjɨ kelta madɨ kɨ rangɨ. Ningə tokɨ ɓari’m’in, m’dəjɨ’se m’oo ke in ri ə uləi go’m’tɨ wa?» ");
INSERT INTO gqr_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kɔrney ene: «Asɨ ndɔ sɔ ɓone, kɨ dɔ kadɨ kɨ tokɨ mad’a inɓe kin be, adɨ in kadɨ kɨ mutə kɨ losɔl’ɔ, ə m’njɨ m’elta kɨ Luwə me kəy’tɨ lə’m, ningə dingəm madɨ kɨ ulə ku kɨ nda bal bal te ra non’m’tɨ, el’m ene: ");
INSERT INTO gqr_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","“Kɔrney, Luwə oo dɔ ta kɨ isɨ el si’ə, taa ɔjidɔ majɨ’tɨ kɨ isɨ ra kɨ njendoo’gɨ kin tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Ə kadɨ ulə de madɨ Jope’tɨ, ɓar Simon kɨ ɓari’ə nan Piyər adɨ re. Sɨ me kəy’tɨ lə Simon kɨ nje ra kulə ngirə, kɨ isɨ kadɨ ba’tɨ ndəkba.” ");
INSERT INTO gqr_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ɓe ə, tanan’tɨ non par, m’ulə de rɔ’i’tɨ, ə nyɨ ra majɨ adɨ in re tɔ kin. Ningə kɨ ngɔsine kin, j’in pətɨ j’isi non Luwə’tɨ ne kadɨ j’oo dɔ ta’gɨ pətɨ kɨ Burəɓe ində ta’i’tɨ kadɨ el’je.» ");
INSERT INTO gqr_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Lo kin’tɨ, Piyər un ta ta’ne’tɨ el ene: «To kɨ rɔta’tɨ, m’gər kadɨ kɔr kum’de dana goto rɔ Luwə’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","De kɨ ra ra, dann ginn de’gɨ’tɨ kɨ dangɨ dangɨ, kɨ in nje ɓol ndil’ə, kɨ njera nya kɨ dana ə, uwə kɨ rɔ’ne’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ulə kɨ ta lə’ne kɨ rɔ ngann Isirayel’gɨ’tɨ, ilə’n’de mbər Poyta kɨ majɨ kɨ ɔjidɔ lapiya kɨ takul Jeju Kirisitɨ kɨ in Burəɓe lə de’gɨ pətɨ. ");
INSERT INTO gqr_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Tokɨ in gəri, in nya kɨ ulə ngirə’ne Galile’tɨ, go batəm’tɨ kɨ Jan iləmbər’ə ə ra nya dɔnangɨ Jude’tɨ ba pətɨ. ");
INSERT INTO gqr_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","In gəri kadɨ Luwə adɨ Jeju kɨ Najaretɨ’tɨ Ndil Luwə kɨ tɔgɨ kin majɨ. Jeju aw kɨ lo lo, ra majɨ kɨ de’gɨ, taa ajɨ de’gɨ pətɨ kɨ sii ginn tɔgɨ’tɨ lə Su tɔ. Tadɔ Luwə in si’ə nan’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","J’in nje mannajɨ dɔ nya’gɨ’tɨ pətɨ kɨ ra dɔnangɨ’tɨ lə Juwipɨ’gɨ kɨ Jerujalem’tɨ. Ɓəri’ə dɔ kagidəsɨ’tɨ, tɔli’ə. ");
INSERT INTO gqr_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Nan Luwə ad’a ində taa lo koy’tɨ ndɔ kɨ nja mutə lə ndɔ koy’o. Ad’a tarow adɨ tɔjɨ rɔ’ne taga, ");
INSERT INTO gqr_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","kɨ rɔ de’gɨ pətɨ el, nan kɨ rɔ nje mannajɨ’gɨ’tɨ kɨ Luwə mbətɨ’de kete. Adɨ in j’in kɨ j’usɔi si’ə ge, j’anyi si’ə ge go te’ə dann njekoy’gɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Jeju un ndu’ne adɨ’je kadɨ j’ilə mbər kɨ rɔ ginn de’gɨ’tɨ, ə kadɨ jɨ tɔjɨ tokɨ in n’in anyɨ Luwə ində’ne to njegangɨ ta dɔ nje kisikidɔ’de ta’a’tɨ kɨ njekoy’gɨ. ");
INSERT INTO gqr_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","De’gɨ kɨ njekeltakita Luwə’tɨ pətɨ manyinajɨ dɔ’a’tɨ eli eyina: “De kɨ ra kɨ un me’ne ad’a ə, Luwə a inyə go majel’gɨ li’ə kɔ me tɔ’a’tɨ.”» ");
INSERT INTO gqr_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Lokɨ Piyər isɨ el ta’gɨ kin ba ɓay ningə, Ndil Luwə ur kɨ dɔ de’gɨ’tɨ kɨ isɨ oyi dɔ ta li’ə. ");
INSERT INTO gqr_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Nya kin ətɨ ɓol nje kunme’de kadɨ Luwə kɨ in Juwipɨ’gɨ kɨ dani Piyər, lokɨ oyi kadɨ Luwə ɓukɨ Ndil’ne dɔ ginn de’gɨ’tɨ kɨ in Juwipɨ’gɨ el tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Tadɔ oyi ndu’de isɨ elita kɨ ta ɓe’gɨ kɨ dangɨ dangɨ uləi tɔjɨ dɔ Luwə’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Ningə Piyər el ene: «Tokɨ ingəi Ndil Luwə to j’in be tɔ kin, nya kɨ ɔgɨ’de dɔ ra batəm goto.» ");
INSERT INTO gqr_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Be ə Piyər un ndu’ne adɨ rai’de batəm me tɔ Jeju Kirisitɨ’tɨ, ə go’tɨ, dəji Piyər kadɨ isɨ se’de nan’tɨ ndɔ’gɨ nden ɓay taa kadɨ to təl. ");
INSERT INTO gqr_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Njekawkulə’gɨ kɨ ngannkon’gɨ kɨ sii Jude’tɨ oyi kadɨ de’gɨ kɨ in Juwipɨ’gɨ el ka oyi ta lə Luwə tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Lokɨ Piyər aw Jerujalem’tɨ, njekunme’de kadɨ Luwə, kɨ in nje kujə mɔtɨ’de’gɨ gaki’ə ngayn, ");
INSERT INTO gqr_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","eyina: «Aw rɔ de’gɨ’tɨ kɨ ujəi mɔtɨ’de el, aw sɔ se’de nya!» ");
INSERT INTO gqr_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Lo kin’tɨ, Piyər ilə rɔ’ne ɔr’de go nya’gɨ kɨ rai nya kɨ go’ə go’ə adɨ’de oyi. ");
INSERT INTO gqr_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Piyər el ene: «M’in me ɓebo’tɨ kɨ Jope, ningə lokɨ m’njɨ m’elta kɨ Luwə, m’oo nya me ndil’tɨ. In nya madɨ kɨ to to ta ku kɨ tatɨ kɨ de uwə silə’gɨ kɨ sɔ be ə in dɔran’tɨ, risɨ bitɨ re non’m’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","M’ur kum kɨ dɔ ta ku’tɨ kakin m’njɨ m’gon, ningə m’oo da’gɨ kɨ nja’de in sɔ, kɨ nje kagɨ nanga, kɨ da’gɨ kɨ mu’tɨ kɨ yəl’gɨ kɨ nje nal kadɨ dɔran’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ningə m’oo ndu ta madɨ el’m ene: “Piyər, ində taa, tɔl ə sɔ.” ");
INSERT INTO gqr_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ə m’el m’ene: “Jagɨ Burəɓe, nya kɨ to njen ɔdɨ ta’m nja kare el.” ");
INSERT INTO gqr_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Nja joo, ndu ta təl te dɔran’tɨ ɓay ene: “Nya kɨ Luwə təl’ə kɨ kar njay’tɨ ə, kadɨ oo’ə to nya kɨ to njen el.” ");
INSERT INTO gqr_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Nya kin ra nya be asɨ nja mutə, ningə təli tuyi’ə dɔran’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Ningə tanan’tɨ non, dingəm’gɨ mutə kɨ uləi’de me ɓe’tɨ kɨ Sejare’tɨ, kɨ rɔ’m’tɨ rei rai takəy’tɨ kɨ m’njɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ndil Luwə el’m kadɨ m’aw se’de um m’mbətɨ el. In be ə ngannkon’m’gɨ kɨ mehen kam dani’m’in, ə j’urɨ’n me kəy’tɨ lə Kɔrney. ");
INSERT INTO gqr_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Kɔrney ɔjɨ’je gorow kɨ n’oo’n malayka kɨ te kɨ rɔ’ne’tɨ, me kəy’tɨ lə’ne, el ene: “Ulə de madɨ me ɓe’tɨ kɨ Jope kadɨ el Simon kɨ ɓari’ə Piyər kadɨ re. ");
INSERT INTO gqr_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","A eli nya’gɨ kɨ a rai sə’i kadɨ ingə’n kajɨ nan’tɨ kɨ nje kɨ me kəy’tɨ lə’i.” ");
INSERT INTO gqr_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Lokɨ m’a m’elta ba ɓay ningə, Ndil Luwə risɨ re dɔ’de’tɨ tokɨ ndɔkɨ re’n dɔ’je’tɨ lo kulə ngirə’tɨ kakin be. ");
INSERT INTO gqr_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Nga ra adɨ me’m olo dɔ ta’tɨ lə Burəɓe kɨ ene: “Jan ra batəm me mann’tɨ, nan ingɨ, a rai’se batəm me Ndil Luwə’tɨ.” ");
INSERT INTO gqr_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Eke, tokɨ Luwə adɨ’n’de kadikare kɨ kare inɓe tokɨ adɨ’n’je, j’in kɨ j’uni me’je j’adi Burəɓe Jeju Kirisitɨ kin, kadɨ m’in m’tanrɔ Luwə wa?» ");
INSERT INTO gqr_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Lokɨ oyi dɔ ta kin ningə, hangal’de osɨ nanga adɨ uləi tɔjɨ dɔ Luwə’tɨ eyina: «Ginn de’gɨ kɨ dɔnangɨ’tɨ kaa Luwə adi’de kajɨ kɨ gorow k’inyə go majel kɔ.» ");
INSERT INTO gqr_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Kindəkumndoo kɨ te dɔ Etiyenn’tɨ ra adɨ njendo’gɨ sananyinan, ai bitɨ tei me ɓe’tɨ kɨ Penesi, kɨ Sipir, kɨ Antiyosɨ. Lokɨ ai, elita lə Luwə Juwipɨ’gɨ par um de kɨ rangɨ el. ");
INSERT INTO gqr_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","De’gɨ madɨ’gɨ dann’de’tɨ non, kɨ in njekunme’gɨ kɨ in ginn kojɨ’tɨ kɨ Sipir, kɨ Sirenn kɨ awi Antiyosɨ’tɨ, eli Poyta kɨ majɨ lə Burəɓe Jeju ginn de’gɨ kɨ in Juwipɨ’gɨ el kɨ ɓari’de Girekɨ’gɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Tɔgɨ Burəɓe in se’de nan’tɨ adɨ de’gɨ ngayn təli kɨ rɔ Burəɓe’tɨ uni me’de adi’ə. ");
INSERT INTO gqr_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Poy nya’gɨ kɨ ra nya kin te rɔ Njekawnan’gɨ’tɨ kɨ sii Jerujalem, adɨ uləi Barnabasɨ adi’ə aw Antiyosɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Lokɨ aw te rɔ’de’tɨ, ə oo memajɨ lə Luwə kɨ ra kulə ningə, rɔ’a nəl’ə ngayn adɨ ulə dingəm me’de’tɨ pətɨ kadɨ rai dɔ nja’de me kində rɔ nan’tɨ kɨ Burəɓe. ");
INSERT INTO gqr_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnabasɨ in de kɨ dana, Ndil Luwə ros’o, taa aw kɨ kunme tɔ, adɨ bulə de’gɨ ngayn rei kɨ rɔ Burəɓe’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Barnabasɨ aw me ɓe’tɨ kɨ Tarsɨ kadɨ n’sangɨ Sol. ");
INSERT INTO gqr_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Lokɨ ingə ningə, aw si’ə Antiyosɨ’tɨ, rai ɓal kare səm’tɨ. Kawinan kɨ Njekawnan’gɨ, ndoi ta lə Luwə bulə de’gɨ ngayn. In me ɓe’tɨ kɨ Antiyosɨ’tɨ ə nyɨ de’gɨ uləi ngirə ɓar njendo’gɨ de’gɨ lə Kirisitɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Dɔkagilo’ə’tɨ non, de’gɨ kɨ njekeltakita Luwə’tɨ in Jerujalem’tɨ ai bitɨ kɨ Antiyosɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","In kɨ kare dann’de’tɨ, tɔ’a nan Agabusɨ, ində taa ningə elta kɨ takul Ndil Luwə tokɨ ɓo kɨ bo ngayn a on dɔnangɨ’tɨ kɨ ta’a ba. Ningə nya kakin ra nya dɔkagilo’tɨ lə nje konɓe kibo kɨ ɓari’ə nan Kilodɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","*Njendo’gɨ uni ndu’de kadɨ n’uləi kɨ nya kɨ ji’de’tɨ, nan nan kigo tɔg’ɔ’tɨ kadɨ n’ɔsi ginn ngannkon’de’gɨ kɨ sii Jude’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Adi nya majɨ’gɨ lə’de kakin Barnabasɨ in kɨ Sol adɨ awi adi ngatɔgɨ’gɨ. ");
INSERT INTO gqr_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Dɔkagilo’ə’tɨ inɓe kin ə ngar Erodɨ ulə ngirə kadɨ kon Njekawnan’gɨ kɨ nan’gɨ. ");
INSERT INTO gqr_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Tɔl Jakɨ kɨ ngonnkon Jan kɨ kiyərɔ. ");
INSERT INTO gqr_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Nan Lokɨ oo kadɨ nəl Juwipɨ’gɨ ngayn, ningə təl adɨ uwəi Piyər ɓay. In dɔkagilo ra nanyi mapa kɨ hum ɔd’ɔ el. ");
INSERT INTO gqr_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Lokɨ uwə ilə dangay’tɨ ningə, adɨ nje rɔ’gɨ sɔ sɔ nja sɔ ngəmi’ə. Nga ra be kadɨ to n’te si’ə taga non bulə de’gɨ’tɨ go pətɨ Pakɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Piyər to dangay’tɨ, nan Njekawnan’gɨ inyəi ta kelta kɨ Luwə el tadɔ li’ə. ");
INSERT INTO gqr_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Me kondɔ’a’tɨ kɨ kadɨ re lo ti ə, Erodɨ te si’ə non bulə de’gɨ’tɨ kakin ningə, Piyər to ɓi mbunə njerɔ’gɨ, dɔi’ə kɨ kulə gindɨ joo. Ningə njengəm lo’gɨ, rai ta kəy’tɨ, ra ngəmi takəy dangay tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Lo kin’tɨ, malayka lə Burəɓe kare te patɨ, adɨ kunjə taa lo me kəy dangay’tɨ, lo kɨ Piyər to’tɨ. Malayka ində Piyər kad’a’tɨ ndəl’n’ə ene: «Ində taa kalangɨ!» Ningə kulə gindɨ’gɨ kɨ ji’ə’tɨ tei tosi. ");
INSERT INTO gqr_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Malayka el’ə ene: «Dɔɔ ndar kɨ ɓəd’i’tɨ, ə tulə sa nja’i’tɨ.» Ningə Piyər ra tokɨ el’n’ə. Malayka el’ə ɓay ene: «Ulə ku lə’i rɔ’i’tɨ ə un go’m.» ");
INSERT INTO gqr_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Piyər te go’ə’tɨ, nan gər tokɨ in malayka ə re te si’ə tokɨ rɔta’tɨ, el. Oo tokɨ in nya kɨ oo me ndil’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Lokɨ indəi njengəm lo kɨ dɔkete, kɨ kɨ nja joo dəri ningə, rei tei ta tarow gindɨ’tɨ kɨ aw kɨ ɓebo’tɨ, tarow inɓe te dɔrɔ’ne par non’de’tɨ, adɨ tei taga awi dɔ row’tɨ. Lokɨ tei dɔ row’tɨ ningə, tanan’tɨ non, malayka inyə ə aw. ");
INSERT INTO gqr_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Lokɨ hangal’a re rɔ’a’tɨ ningə el ene: «M’oo tokɨ rɔta’tɨ kadɨ in Burəɓe ə ulə malayka lə’ne adɨ re te sə’m ji Erodɨ’tɨ, kɨ ta nya’gɨ’tɨ kɨ majel pətɨ kɨ bulə Juwipɨ’gɨ ɔji kadɨ rai sə’m.» ");
INSERT INTO gqr_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Lokɨ ɔjɨ ta be ningə, ilə dɔ’ne aw ɓe lə Mari kɨ kon Jan kɨ ɓari’ə nan Markɨ. De’gɨ ngayn kawinan me kəy’tɨ non isɨ elita kɨ Luwə. ");
INSERT INTO gqr_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Lokɨ ində takəy ningə, ngonn njekulə kɨ dene kɨ tɔ’a nan Rodɨ ɔtɨ re kadɨ n’oo. ");
INSERT INTO gqr_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Gər ndu Piyər adɨ tarow kaa te el bai par ə, rɔ’a nəl’ə ngayn adɨ təl kɨ ngodɨ aw el’de ene Piyər ra takəy’tɨ non. ");
INSERT INTO gqr_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Eli’ə eyina: «In nje woy.» Nan ra dɔ ndu’ne’tɨ tokɨ in ta kɨ rɔta’tɨ. Nga a təli eli eyina: «In malayka li’ə.» ");
INSERT INTO gqr_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Low’ə’tɨ kin, Piyər ra ta kində takəy’tɨ par par. Ə lokɨ rei tei takəy ningə, in Piyər inɓe, adɨ gəri lo ta kɨ kadɨ eli el. ");
INSERT INTO gqr_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","El’de ta kɨ ji’ne kadɨ elita el, ningə ɔr’de go te kɨ Burəɓe te sə’ne dangay’tɨ adɨ gəri. Go’tɨ, el’de ene: «Awi eli Jakɨ kɨ ndəgɨ ngannkon’je’gɨ adɨ oyi.» Ningə te aw lo kɨ rangɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Lokɨ lo ti ningə, dɔ njerɔ’gɨ isɨ dana el. Dəji nan ke ri dana ə Piyər təl wa? ");
INSERT INTO gqr_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Ngar Erodɨ sang’a ngayn nan ingə el. Go’tɨ, dəjɨ ta njerɔ’gɨ, ə un ndu’ne kadɨ tɔli’de kɔ. Piyər inyə dɔnangɨ Jude ə in aw Sejare’tɨ, aw isɨ səm’tɨ nu. ");
INSERT INTO gqr_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Erodɨ aw kɨ ta kɨ de’gɨ kɨ Tir’tɨ, kɨ Sidon. Ə de’gɨ kɨ Tir kɨ Sidon indəi ndu’de nan’tɨ rei ingəi’ə. Lokɨ ndogi me Bilasitusɨ kɨ nje k’oo go ta lə ngar Erodɨ taai ningə, dəji kadɨ lapiya to dann’de’tɨ. Kadɨ lapiya to tadɔ nya majɨ’gɨ kɨ dɔnangɨ’tɨ lə’de ngirə in me ɓe’tɨ lə ngar Erodɨ. ");
INSERT INTO gqr_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Lokɨ te me ndɔ’tɨ kɨ ɔjɨ ningə, Erodɨ ulə ku konɓe lə’ne rɔ’ne’tɨ, isɨ dɔ kumbər ngar’tɨ lə’ne, el bulə de’gɨ ta kongɨ kongɨ. ");
INSERT INTO gqr_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Bulə de’gɨ uləi tɔjɨ dɔ’a’tɨ eyina: «In ndu luwə madɨ um in ndu de el.» ");
INSERT INTO gqr_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Low’ə’tɨ non malayka lə Burəɓe ində ɔj’ɔ tadɔ adɨ kɔsikurə Luwə el. Go’tɨ kode’gɨ indəi’ə nyəngɨ nyəngɨ adɨ oy. ");
INSERT INTO gqr_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Nan ta lə Luwə taa lo aw kɨ kete kete, adɨ kɔr njendo’gɨ re kɨ dɔ mad’a’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Lokɨ Barnabasɨ in kɨ Sol tɔli konn kulə lə’de kɨ awi kadɨ rai ningə, inyəi ɓebo kɨ Jerujalem ə awi. Uni Jan kɨ ɓari’ə Markɨ nan’tɨ se’de ə təli awi me ɓe’tɨ kɨ Antiyosɨ gogɨ. ");
INSERT INTO gqr_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","De’gɨ kɨ njekeltakita Luwə’tɨ kɨ njendo de’gɨ nya lə Luwə sii dann Njekawnan’gɨ’tɨ kɨ Antiyosɨ’tɨ non. Adɨ in: Barnabasɨ kɨ Simeyon kɨ ɓari’ə Nijer, kɨ Lisiyusɨ kɨ ɓe li’ə in Sirenn’tɨ, kɨ Manaye kɨ oti’de nan’tɨ kɨ Erodɨ kɨ isɨ dɔ dɔnangɨ’tɨ kɨ Galile, kɨ Sol tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ndɔ kare be ɔsi məkəsɨ’de nanga non Luwə’tɨ ə elita si’ə kɨ kɔgɨ rɔ nyakusɔ tɔ. Ningə Ndil Luwə el’de ene: «Kadɨ ɔri Barnabasɨ ingɨ kɨ Sol indəi’de ta dangɨ tadɔ kulə kɨ m’ɓari’de kadɨ rai.» ");
INSERT INTO gqr_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Nga a, lokɨ ɔgi rɔ’de nyakusɔ ə elita kɨ Luwə ningə, indəi ji’de dɔ’de’tɨ ə inyəi’de adɨ awi, ");
INSERT INTO gqr_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","tokɨ Ndil Luwə el’n’de. In be ə, Barnabasɨ in kɨ Sol awi me ɓe’tɨ kɨ Seləsi. Ningə rai non gangi awi Sipir’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Lokɨ tei Salaminn’tɨ, elita lə Luwə me kəykawnan’gɨ’tɨ lə Juwipɨ’gɨ. Jan in kadɨ’de’tɨ to njera se’de tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Lokɨ indəi dɔ dor’gɨ kɨ ɓe’tɨ kɨ Sipir’tɨ gangi ningə, ai tei me ɓe’tɨ kɨ Paposɨ. Low’ə’tɨ non, ingəi Juwipɨ kare be kɨ tɔ’a nan Bar-Jeju kɨ in njera mboli, kɨ ɓar rɔ’ne njekeltakita Luwə’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Isɨ nan’tɨ kɨ de kɨ boi kɨ tɔ’a nan Serjiyusɨ Polusɨ kɨ in nje nyagər. Serjiyusɨ Polusɨ ə Barnabasɨ in kɨ Sol ɔjɨ’de adɨ gəri tokɨ n’aw kɨ ɓo k’oo ta lə Luwə ta’de’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Nan Elimasɨ kɨ kɔr ginn tɔ’a nan nje mboli tan’de rɔ. Ge kadɨ de kɨ boi kin un me’ne adɨ Kirisitɨ el. ");
INSERT INTO gqr_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Be ə, Sol kɨ ɓari’ə Pol, Ndil Luwə ros’o adɨ ur kum’ne kɨ dɔ’a’tɨ, ");
INSERT INTO gqr_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","el’ə ene: «In ngonn lə Su, to de kɨ nje bal de’gɨ, in rosɨ kɨ mendul. In nje kɔsɨ ta nya ra’gɨ kɨ dana pətɨ. A inyə taa mbir row’gɨ kɨ dana lə Burəɓe el wa?» ");
INSERT INTO gqr_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Kɨ ngɔsine kin, Burəɓe a indəi ɔji, kum’i a oo lo el, ningə a oo kum kadɨ el bitɨ dɔkagilo madɨ. Ningə tanan’tɨ non par ə kum’ə ndul kururu adɨ oo lo el, ra mam lo. Sangɨ de kɨ kadɨ ɔr’ɔ tarow. ");
INSERT INTO gqr_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Lokɨ de kɨ boi oo nya kɨ ra nya kin ningə, un me’ne ad’a, tadɔ nyando kɨ dɔ Burəɓe’tɨ kɨ adi’ə, ətɨ ɓol ngayn. ");
INSERT INTO gqr_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pol in kɨ madɨ’ne’gɨ ali me to’tɨ me ɓe’tɨ kɨ Paposɨ, awi me ɓe’tɨ kɨ Perjɨ kɨ Pampili’tɨ, ningə Jan Markɨ inyə’de ə təl aw Jerujalem’tɨ gogɨ. ");
INSERT INTO gqr_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Lokɨ ɔti me ɓe’tɨ kɨ Perjɨ ningə, awi tei me ɓe’tɨ kɨ Antiyosɨ kɨ Pisidi’tɨ, ai me kəykawnan’tɨ lə Juwipɨ’gɨ kɨ ndɔ kɔrkon, sii nanga. ");
INSERT INTO gqr_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Lokɨ nje tudə makitu’gɨ, tudəi makitu ndukun kɨ makitu lə njekeltakita Luwə’tɨ ningə, kɨ boi kɨ dɔ njengəm kəykawnan’tɨ lə Juwipɨ’gɨ uləi eli’de eyina: «Ngannkon’je’gɨ, kin ə awi kɨ ta kadɨ eli uləi dingəm me de’gɨ, ə kadɨ eli.» ");
INSERT INTO gqr_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Ə Pol ində taa, yəkɨ ji’ne ta’de’tɨ kadɨ sii keke, ningə el’de ene: «In Isirayel’gɨ kɨ de’gɨ kɨ nje ɓol Luwə, kadɨ oyi dɔ ta lə’m. ");
INSERT INTO gqr_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Luwə lə’je, j’in bulə Isirayel’gɨ, mbətɨ baw’je’gɨ, ningə ra se’de adɨ oji nan kɨ kete kete, lokɨ sii me ɓe’tɨ kɨ Ejipitɨ. Ɔr’de te se’de kɨ taga kɨ takul tɔg’ɔ kɨ ngayn. ");
INSERT INTO gqr_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Asɨ ɓal dɔsɔ kɨ adɨ’de nya sɔi diləlo’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Lokɨ tɔko ginn de’gɨ siri kɨ dɔnangɨ’tɨ kɨ Kana non’de’tɨ ningə, təl kɨ dɔnangɨ kakin adɨ’de to nya nduwə. ");
INSERT INTO gqr_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Nya’gɨ pətɨ kɨ rai nya kin, a ra ɓal asɨ ɓu sɔ kɨ dɔmi. Go’tɨ ningə, adi’de njegangɨ ta’gɨ bitɨ te’n dɔ njekeltakita Luwə’tɨ Samiyel. ");
INSERT INTO gqr_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ningə, dəji ngar adɨ Luwə adɨ’de Sol kɨ ngonn lə Kisɨ, kɨ in ginn kaw’tɨ lə Benjamen, adɨ onɓe dɔ’de’tɨ ɓal dɔsɔ. ");
INSERT INTO gqr_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Lokɨ ɔr’ɔ kɔ ningə, ində Dabidɨ ngar’tɨ tor’o’tɨ. Dabidɨ kɨ Luwə mannajɨ li’ə ene: “M’ingə Dabidɨ kɨ in ngonn lə Jese, kɨ in de kigo me ndigɨ’tɨ lə’m. A tɔl kon nya’gɨ pətɨ kɨ me’m ndigɨ.” ");
INSERT INTO gqr_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","In ginn kaw’tɨ li’ə ə, Luwə adɨ Jeju kɨ Njekajɨ Isirayel te’tɨ, kigo ndukun’tɨ li’ə. ");
INSERT INTO gqr_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Kete non re Jeju’tɨ, Jan iləmbər kadɨ de’gɨ tɔri ndu’de, ningə kadɨ rai batəm. Iləmbər kin kɨ rɔ bulə Isirayel’gɨ’tɨ ba pətɨ. ");
INSERT INTO gqr_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Lokɨ Jan aw kadɨ tɔlta kulə lə’ne ningə, el ene: “M’in de kɨ isɨ mərita dɔ’a’tɨ kin el. Nan in a re go’m’tɨ non kɨ kulə sa kɨ nja’a’tɨ ka m’in m’asɨ tutɨ el.” ");
INSERT INTO gqr_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","«Ngannkon’m’gɨ kɨ ginn kaw’tɨ lə Abiraham, kɨ nje ɓol Luwə kɨ dann’se’tɨ, in j’ingi ə Luwə ulə kɨ ta kajɨ kin rɔ’je’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","De’gɨ kɨ nje kisi Jerujalem’tɨ ingɨ kibo’gɨ lə’de gəri de kɨ in Jeju kin el, taa gəri me ta’gɨ lə de’gɨ kɨ njekeltakita kɨ ta Luwə’tɨ, kɨ isɨ tudəi kɨ ndɔ kɔrkon’gɨ pətɨ kin el tɔ. Be ə lokɨ gangi ta dɔ Jeju’tɨ, tɔlita ta’gɨ kɨ njekeltakita Luwə’tɨ ndangi. ");
INSERT INTO gqr_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ingəi nya madɨ kare kɨ asɨ kadɨ tɔli’ə el, nan dəji Pilatɨ kadɨ tɔl’ɔ par. ");
INSERT INTO gqr_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Lokɨ tɔli kon nya’gɨ pətɨ kɨ ndangi me makitu’tɨ ɔjidɔ’a ningə, adɨ risi’ə dɔ kagidəsɨ’tɨ nanga, il’ə me ɓe ninn’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Nan Luwə ad’a ində taa dann njekoy’gɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Asɨ ndɔ ngayn kɨ te kɨ rɔ de’gɨ’tɨ kɨ in si’ə dɔnangɨ Galile’tɨ nu, ə rei si’ə bitɨ Jerujalem’tɨ, ingɨ kin ə in nje mannajɨ li’ə kɨ non bulə de’gɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","J’in kaa j’isɨ j’ilə’se mbər Poyta kɨ majɨ kin tɔ. Poyta kɨ majɨ kɨ in ta kun mindɨ kɨ Luwə un ndu’ne dɔ’tɨ adɨ baw’je’gɨ. ");
INSERT INTO gqr_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Luwə tɔlta kun mindɨ kin kɨ rɔta’tɨ j’in ngann de’gɨ kɨ gorow te kɨ adɨ Jeju te lo koy’tɨ tokɨ ndangi me makitu Pa’gɨ’tɨ eyina: “In Ngonn’m, kɨ m’oj’i ɓone.” ");
INSERT INTO gqr_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","«Luwə ad’a ində taa lo koy’tɨ um ad’a ndum me ɓe ninn’tɨ el, tokɨ el’n ene: “M’a m’adɨ’se nya, Kɨ m’un mindɨ’m dɔ’tɨ m’adɨ Dabidɨ, Kɨ in nya kɨ asɨ kadɨ awi kɨ kunme dɔ’tɨ.” ");
INSERT INTO gqr_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","«In tadɔ kin ə, el’n me makitu’tɨ lo madɨ’tɨ ɓay ene: “A inyə njekulə lə’i kɨ ar njay kadɨ ndum ɓe ninn’tɨ el.” ");
INSERT INTO gqr_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Nan Dabidɨ, lokɨ ra kulə dɔkagilo’tɨ lə’ne kigo kɔjitara’tɨ lə Luwə ningə, oy adɨ duwi’ə gədɨ kaw’a’gɨ’tɨ, ningə ndum me ɓe ninn’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Nan in kɨ Luwə ad’a ində taa lo koy’tɨ ndum me ɓe ninn’tɨ el. ");
INSERT INTO gqr_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","«Kadɨ gəri majɨ ngannkon’m’gɨ, tokɨ in kɨ takul’ə ə isɨ iləi’se mbər kɨ ɔjidɔ k’inyə go majel kɔ, kɨ təl de kɨ dana takum Luwə’tɨ kɨ asi kadɨ ingəi me ndukun’tɨ lə Mojɨ el. ");
INSERT INTO gqr_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","In kɨ takul’ə tɔ ə, re de kɨ un me’ne ningə, Luwə təl’ə de kɨ dana takum’ne’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Tadɔ in kin ə, kadɨ oyi go rɔ’se majɨ nan to ta kɨ de’gɨ kɨ njekeltakita Luwə’tɨ eli kin ta’a tɔl dɔ’se’tɨ: ");
INSERT INTO gqr_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","De’gɨ kɨ njekeltakita Luwə’tɨ eli eyina: “In nje kɔjɨ rɔ’se, Kadɨ oyi go rɔ’se majɨ, A oyi nya kɨ a ətɨ’se ɓol bitɨ kadɨ a gotoi kɔ. Tadɔ dɔkagilo’tɨ lə’se, m’a m’ra nya madɨ. Nya kɨ re de ɔr’se poy’o ka, a uni me’se dɔ’tɨ el.”» ");
INSERT INTO gqr_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Lokɨ Pol in kɨ Barnabasɨ isɨ tei taga ningə, dəji’de kadɨ ndɔ kɔrkon kɨ gogɨ ə kadɨ təli rei ndoi’de ta kin ɓay. ");
INSERT INTO gqr_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Lokɨ bulə Njekawnan’gɨ sananyinan ningə, Juwipɨ’gɨ kɨ de’gɨ kɨ təli Juwipɨ’gɨ kɨ nje ɓol Luwə, dani Pol kɨ Barnabasɨ, a wali nan ta se’de. Ningə Pol kɨ Barnabasɨ uləi dingəm me’de’tɨ kadɨ uwəi rɔ’de ba me memajɨ’tɨ lə Luwə kin. ");
INSERT INTO gqr_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Ndɔ kɔrkon’tɨ kɨ gogɨ ningə, bulə de’gɨ ngayn kɨ me ɓebo’tɨ kawinan kɨ nan’tɨ kadɨ n’oyi dɔ ta lə Burəɓe. ");
INSERT INTO gqr_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Lokɨ Juwipɨ’gɨ oyi bulə de’gɨ ningə, ni ra’de adɨ taji Pol, ə eli ta’gɨ kɨ majel ndɔri ta li’ə. ");
INSERT INTO gqr_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Pol kɨ Barnabasɨ eli’de kɨ me kɨ tinyi katɨ eyina: «In ingɨ ə kadɨ j’ilə’se mbər ta lə Luwə kin kete, nan tokɨ mbəti ə oyi tokɨ ingɨ asi ta kajɨ kɨ bitɨ kɨ non’tɨ el, j’a jɨ təl jɨ yətɨ rɔ’je kɨ rɔ ginn de’gɨ’tɨ kɨ in Juwipɨ’gɨ el’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Tadɔ Burəɓe lə’je un ndu’ne adɨ’je ene: “M’indəi kadɨ in kunjɨ tadɔ ginn de’gɨ kɨ dɔnangɨ’tɨ, Kɨ kadɨ aw kɨ ta kajɨ bitɨ kɨ dɔboy dɔnangɨ’tɨ.”» ");
INSERT INTO gqr_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Lokɨ ginn de’gɨ kɨ in Juwipɨ’gɨ el oyi dɔ ta kin ningə, rai rɔnel ngayn dɔ’tɨ, adɨ uləi tɔjɨ dɔ ta’tɨ lə Burəɓe, adɨ de’gɨ pətɨ kɨ Luwə mbətɨ’de tadɔ kajɨ kɨ bitɨ kɨ non’tɨ, uni me’de. ");
INSERT INTO gqr_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ta lə Burəɓe sanan kɨ dɔnangɨ kɨ Antiyosɨ’tɨ kɨ ta’a ba. ");
INSERT INTO gqr_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Nan Juwipɨ’gɨ suləi dene’gɨ kɨ in dene’gɨ kɨ njetɔɓar kɨ me ɓe’tɨ, kɨ nje kɔsikurə Luwə, kɨ de’gɨ kɨ boi kɨ me ɓe’tɨ adɨ indəi kum Pol kɨ Barnabasɨ ndoo, ningə tuwəi’de me ɓe’tɨ lə’de kɔ. ");
INSERT INTO gqr_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Pol kɨ Barnabasɨ indəi bu kɨ nja’de’tɨ kɨ dɔ ɓe’tɨ lə’de ningə, ɔti ai me ɓe’tɨ kɨ Ikoniyom. ");
INSERT INTO gqr_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Kɨ rɔ njendo’gɨ’tɨ lə Jeju ə, rɔ’de nəl’de ngayn, taa Ndil Luwə kaa rosɨ me’de tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Lokɨ Pol kɨ Barnabasɨ awi Ikoniyom’tɨ, awi me kəykawnan’tɨ lə Juwipɨ’gɨ kɨ Ikoniyom’tɨ tɔ. Awi eli de’gɨ ta lə Luwə kɨ ra adɨ de’gɨ ngayn kɨ in Juwipɨ’gɨ kɨ nje kɨ in Girekɨ’gɨ uni me’de adi Luwə. ");
INSERT INTO gqr_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Nan Juwipɨ’gɨ madɨ kɨ nje me ngan, indəi taa kɨ majel me de’gɨ’tɨ kɨ in Juwipɨ’gɨ el, suləi’de dɔ ngannkon’gɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Be kaa, Pol kɨ Barnabasɨ sii Ikoniyom’tɨ ndɔ banyi banyi. Eli ta lə Luwə kɨ me kɨ tinyi katɨ, indəi tɔgɨ’de dɔ Burəɓe’tɨ kɨ mannajɨ dɔ memajɨ’tɨ li’ə kɨ isɨ iləi mbər’ə, adi’de tɔgɨ adɨ rai nyakɔjɨ’gɨ kɨ nya’gɨ kɨ ətɨ ɓol. ");
INSERT INTO gqr_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Lo kin’tɨ, de’gɨ kɨ me ɓebo’tɨ gangi nan lo joo, nje kɨ madɨ’gɨ in go Juwipɨ’gɨ’tɨ, nje kɨ nungɨ in go njekawkulə’gɨ’tɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Nje kɨ in Juwipɨ’gɨ el, kɨ nje kɨ in Juwipɨ’gɨ kɨ kibo’gɨ lə’de indəi dɔ rɔ’de dana kadɨ n’adi kon Pol in kɨ Barnabasɨ, kadɨ n’tiləi’de kɨ mbal n’tɔli’de. ");
INSERT INTO gqr_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Nan Pol kɨ Barnabasɨ oyi ta kin, adɨ anyinan awi iyəi rɔ’de ɓebo’gɨ’tɨ kɨ Likawoni, kɨ Lisitir, kɨ Dərbɨ, kɨ ngann lo’gɨ kɨ gidɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Lo’gɨ’tɨ kin kaa, iləi mbər Poyta kɨ majɨ səm’tɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Me ɓe’tɨ kɨ Lisitir, dingəm kare kɨ nja’a oy ta ginn’ə’tɨ isɨ non. Nja’a oy lo koj’o’tɨ nu, adɨ njiyə nja kare el. ");
INSERT INTO gqr_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ə ndɔ kare, ur mbi’ne isɨ oo’n ta kɨ Pol ra el. Ningə, Pol uwə kum’ne kɨ dɔ’a’tɨ oo’ə’n ba, ningə oo kadɨ aw kɨ kunme kɨ kadɨ ingə’n kajɨ. ");
INSERT INTO gqr_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Lo kin’tɨ, Pol el’ə ta kɨ tɔgɨ’ne ene: «In, ra taa dɔ nja’i’tɨ!» Ningə Dingəm uwə nangɨ ra ta, ra njiyə. ");
INSERT INTO gqr_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Lo kɨ bulə de’gɨ oyi nya kɨ Pol ra kin ningə, uni ndu’de kɨ taa, elita kɨ ta Likawoni eyina: «Oyi, luwə’gɨ təli rɔ’de de’gɨ’tɨ, rei uri nanga dann’je’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Be ə, ɓari Barnabasɨ «Jəsɨ», ə ɓari Pol «Ermesɨ» tɔ, tadɔ Pol ə in njekelta. ");
INSERT INTO gqr_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Njekujənyamosɨ kadikare lə Jəsɨ, kɨ isɨ ta lo’tɨ taga gidɨ ɓebo’tɨ, re kɨ baw mangɨ’gɨ kɨ dɔi nya’gɨ kɨ ndolo rɔ’de’tɨ. Re se’de, ningə, ndu’de in nan’tɨ kɨ bulə de’gɨ, kadɨ n’iləi mosɨ n’adi Pol kɨ Barnabasɨ. ");
INSERT INTO gqr_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Nan lokɨ, njekawkulə’gɨ, Pol in kɨ Barnabasɨ oyi poyta kin, gangi ku rɔ’de’tɨ, ə anyinan kɨ rɔ bulə de’gɨ’tɨ, uni ndu’de kɨ taa, eli’de eyina: ");
INSERT INTO gqr_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","«Madɨ’je’gɨ, ra bann ə ra rai nya be wa? J’in kaa j’in de’gɨ to ingɨ be tɔ, ningə, re j’ilə’se mbər Poyta kɨ majɨ ningə, in kadɨ inyəi kagɨ yo’gɨ kɨ nda’de goto kɨ isɨ rai’de, ə kadɨ təli rɔ’se go Luwə’tɨ kɨ nje kisɨ kumngayira, Luwə kɨ njera dɔran kɨ dɔnangɨ kɨ nya’gɨ pətɨ kɨ me’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Dɔkagilo’gɨ’tɨ kɨ dər kete, Luwə inyə de’gɨ pətɨ adɨ uni row kɨ me’de ndigɨ. ");
INSERT INTO gqr_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Be kin kaa inyə ta tɔjɨ memajɨ lə’ne el: Ulə kɨ mann ndi dɔran’tɨ adɨ’se ge, adɨ’se dɔkagilo kɨ majɨ adɨ ingəi kandɨ nya ge, adɨ’se nyakusɔ kɨ to mbar ge, adɨ rɔnel rosɨ me’se ge.» ");
INSERT INTO gqr_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ta’gɨ kɨ eli kin kaa, ngan se’de ngayn kadɨ ɔgi bulə de’gɨ kilə mosɨ nanga kadɨ’de. ");
INSERT INTO gqr_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Lo kin’tɨ, Juwipɨ’gɨ kɨ in Antiyosɨ kɨ Pisidi’tɨ, kɨ Ikoniyom, rei, suləi bulə de’gɨ kakin, ɓuki’de go’de’tɨ, adɨ tiləi Pol kɨ mbal kadɨ n’tɔli’ə, ə ndɔri’ə, awi si’ə, iləi’ə gidɨ ɓe’tɨ, oyi eyina oy. ");
INSERT INTO gqr_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Nan lokɨ njendo’gɨ kawinan kɨ dɔ’a’tɨ, ində taa, təl aw me ɓebo’tɨ gogɨ. Ningə lo ti go’tɨ, in kɨ Barnabasɨ awi kɨ Dərbɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Lokɨ Pol kɨ Barnabasɨ iləi mbər Poyta kɨ majɨ Dərbɨ’tɨ, de’gɨ ngayn təli njendo’gɨ lə Kirisitɨ. Ningə ingɨ, təli uni dɔ nja’de, tei Lisitir kɨ Ikoniyom, kɨ Antiyosɨ kɨ Pisidi’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Uləi dingəm me njendo’gɨ’tɨ, adi’de ta kɔjɨ kadɨ uwəi tɔgɨ’de ba me kunme’tɨ lə’de. Ningə, rai dɔ’tɨ non eli’de eyina: «In kɨ kon kɨ ngayn ə j’a j’oo’n Konɓe lə Luwə.» ");
INSERT INTO gqr_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Pol kɨ Barnabasɨ indəi ngatɔgɨ’gɨ dɔ Njekawnan’gɨ’tɨ pətɨ kɨ tei dann’de’tɨ. Ɔgi rɔ’de nyakusɔ, elita kɨ Luwə, ə go’tɨ, inyəi’de ji Burəɓe’tɨ kɨ uni me’de adi’ə. ");
INSERT INTO gqr_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","In non, indəi me ɓe kɨ Pisidi gangi, awi tei Pampili’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Iləi mbər poyta lə Luwə me ɓe’tɨ kɨ Perjɨ, ə awi tei ta ba’tɨ kɨ Atali. ");
INSERT INTO gqr_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Lo kin’tɨ non, uni tokibo kaw Antiyosɨ’tɨ. Antiyosɨ kɨ in ɓe kɨ ndɔkɨ njekɔrnon Njekawnan’gɨ kɨ me’tɨ, inyəi’de ji Luwə’tɨ. Inyəi’de ji Luwə’tɨ kadɨ memajɨ li’ə in dɔ’de’tɨ tadɔ kulə kɨ in lo ra’a’tɨ kin. ");
INSERT INTO gqr_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Lokɨ tei Antiyosɨ’tɨ, kawi Njekawnan’gɨ, eli’de nya’gɨ pətɨ kɨ Luwə un’de ra’n. Ɔji’de te kɨ Luwə te tarow kunme adɨ de’gɨ kɨ in Juwipɨ’gɨ el. ");
INSERT INTO gqr_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Sii kɨ njendo’gɨ dɔkagilo ngayn Antiyosɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","De’gɨ kɨ nan’gɨ in Jude’tɨ rei Antiyosɨ’tɨ ndoi ngannkon’je’gɨ nya eyina: «Kin ə re adɨ ujəi mɔtɨ kɨ kigo ndu’tɨ lə Mojɨ el ə, a ingəi kajɨ el.» ");
INSERT INTO gqr_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Nyando kin re kɨ ta kasɨ nan el, kɨ gakɨ nan kibo ngayn mbunə njendo’ə’tɨ kɨ Pol kɨ Barnabasɨ. Lo kin’tɨ non be, uni ta’de kadɨ Pol kɨ Barnabasɨ, nan’tɨ kɨ ngannkon’gɨ madɨ, awi Jerujalem’tɨ ingəi njekawkulə’gɨ kɨ ngatɔgɨ’gɨ lə Njekawnan’gɨ tadɔ ta kin. ");
INSERT INTO gqr_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Njekawnan’gɨ kɨ Antiyosɨ adi’de nya kɨ kadɨ ra se’de dɔ row’tɨ. Uni row, tei Penesi’tɨ in kɨ Samari, eli de’gɨ kigo’ə go’ə, gorow kɨ de’gɨ kɨ in Juwipɨ’gɨ el təli uni me’de adi Kirisitɨ. Ta kin adɨ rɔnel ngannkon’gɨ pətɨ. ");
INSERT INTO gqr_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Lokɨ rei tei Jerujalem’tɨ, Njekawnan’gɨ kɨ njekawkulə’gɨ, kɨ ngatɔgɨ’gɨ lə Njekawnan’gɨ uwəi’de kɨ rɔ’de’tɨ. Pol kɨ Barnabasɨ eli poy nya kɨ Luwə ra se’de adi’de oyi. ");
INSERT INTO gqr_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Nan de’gɨ kɨ nan’gɨ, kɨ uni me’de dann Parisɨ’gɨ’tɨ uni ta eli eyina: «Majɨ kadɨ de’gɨ kɨ in Juwipɨ’gɨ el, adi’de ujəi mɔtɨ’de ə ngəmi go ndukun’gɨ lə Mojɨ ɓay tɔ taa.» ");
INSERT INTO gqr_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Lo kin’tɨ, njekawkulə’gɨ kɨ ngatɔgɨ’gɨ lə Njekawnan’gɨ kawinan kadɨ indəi manjɨ ta kin. ");
INSERT INTO gqr_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Lokɨ manjinan ta adɨ ndan’de ngal, ə Piyər osɨ nangɨ ində taa el’de ene: «Ngannkon’m’gɨ, tokɨ in gəri, in mayinu ə Luwə mbətɨ’m dann’se’tɨ kadɨ m’ilə mbər Poyta’tɨ kɨ majɨ rɔ de’gɨ’tɨ kɨ in Juwipɨ’gɨ el, kadɨ oyi ə uni me’de. ");
INSERT INTO gqr_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Luwə kɨ gər me de’gɨ, mannajɨ lə’de majɨ kɨ gorow Ndil Luwə kɨ adɨ’de tokɨ adɨ’n’je be tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Ingɨ ə j’in tɔ, Luwə ɔr kum’de dana el, tadɔ in kɨ takul kunme lə de ə Luwə adɨ ngarme de ari’n njay. ");
INSERT INTO gqr_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ningə kɨ ngɔsine kin, tadɔ ri ə isɨ sangi ta Luwə kɨ jugɨ kɨ iləi mindɨ njekunme’gɨ’tɨ wa? Nya kɨ j’inɓe eke baw’je’gɨ ka j’awi kɨ tɔgɨ kadɨ j’oti el. ");
INSERT INTO gqr_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Nya kɨ j’uni me’je dɔ’tɨ ə to kin: In kɨ takul memajɨ lə Burəɓe Jeju ə nyɨ j’ingəi kajɨ, j’in kɨ j’in Juwipɨ’gɨ, kah’a’tɨ lə’de in Juwipɨ’gɨ el kakin tɔ.» ");
INSERT INTO gqr_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Ningə, de’gɨ pətɨ uti ta’de, uri mbi’de kadɨ oyi dɔ ta lə Barnabasɨ ingɨ kɨ Pol kɨ ra eli’de ɔjidɔ poy nyakɔjɨ’gɨ kɨ nya’gɨ kɨ ətɨ ɓol’gɨ kɨ Luwə ra’de kɨ takul Pol ingɨ kɨ Barnabasɨ dann de’gɨ’tɨ kɨ in Juwipɨ’gɨ el. ");
INSERT INTO gqr_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Lokɨ iləi ta nanga ningə, Jakɨ un ta el ene: «Ngannkon’m’gɨ, uri mbi’se oyi ta lə’m ngɔsine. ");
INSERT INTO gqr_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simon ində taa el’je ne, adɨ j’oyi row kɨ lo tumginn’ə’tɨ inɓe nu, Luwə ində’n kum’ne go’tɨ majɨ, kadɨ ɔr de’gɨ kɨ nan’gɨ dann de’gɨ’tɨ kɨ in Juwipɨ’gɨ el, ində’de dangɨ to de’gɨ lə’ne. ");
INSERT INTO gqr_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Ta’gɨ lə de’gɨ kɨ njekeltakita Luwə’tɨ osɨ go nan’tɨ lo kareba kɨ ta kin. Tadɔ ndangi me makitu’tɨ lə Luwə eyina: ");
INSERT INTO gqr_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","“Go nya’gɨ’tɨ kin, m’a m’re kadɨ m’ra kəy lə Dabidɨ kɨ budɨ kin rangɨ. M’a m’ra in kɨ sigɨ gogɨ, m’a m’ra tor’o’tɨ gogɨ tɔ, M’a m’ində taa gogɨ. ");
INSERT INTO gqr_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Tadɔ kadɨ ndəgɨ de’gɨ sangi Burəɓe, Adɨ in ginn de’gɨ pətɨ kɨ uni tɔ’m dɔ’de’tɨ. Burəɓe elta kin be. ");
INSERT INTO gqr_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Burəɓe kɨ nje te kɨ ginn nya kɨ ində dɔ’a nan’tɨ mayinu adɨ de’gɨ gəri.” ");
INSERT INTO gqr_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","«In tadɔ kin ə, m’in m’oo majɨ ngayn kadɨ j’iləi kagɨ non de’gɨ’tɨ kɨ in Juwipɨ’gɨ el el, kɨ uni me’de adi Luwə. ");
INSERT INTO gqr_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Adɨ jɨ ndangi makitu par j’adi’de kadɨ njenyi kɨ rɔ’de lo kusɔ da kɨ de ilə kadikare’tɨ adɨ yo’gɨ el, kadɨ sangi nan lo kaya’tɨ el, kadɨ sɔi da kɨ de mbir m’ində el, kadɨ sɔi mosɨ da el tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Nga ningə, ulə ngirə mayinu bitɨ ɓone, de’gɨ kɨ njendo madɨ’de’gɨ ndukun lə Mojɨ in me ɓebo’gɨ’tɨ kare kare, num ndɔ kare kare kɨ in ndɔ kɔrkon lə Juwipɨ’gɨ, de’gɨ a tudəi ndukun kin me kəykawnan’gɨ’tɨ lə Juwipɨ’gɨ tɔ.» ");
INSERT INTO gqr_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Be ə, ngatɔgɨ’gɨ lə Njekawnan’gɨ, kɨ njekawkulə’gɨ kɨ Njekawnan’gɨ, ndigɨ kadɨ n’mbəti de’gɨ kɨ nan’gɨ dann’de’tɨ kadɨ ɔri tor’de dani Pol ingɨ kɨ Barnabasɨ awi se’de Antiyosɨ’tɨ. Mbətɨ Judasɨ kɨ ɓari’ə nan Barsabasɨ in kɨ Silasɨ. In joo pətɨ, ngannkon’de’gɨ tai me’de majɨ. ");
INSERT INTO gqr_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ta kɨ ndangi Makitu’tɨ adi’de ə to kin: «J’in njekawkulə’gɨ kɨ ngatɔgɨ’gɨ lə Njekawnan’gɨ, jɨ ndangɨ makitu kin j’adɨ’se in ngannkon’je’gɨ kɨ sii ɓebo Antiyosɨ’tɨ kɨ dɔnangɨ’gɨ kɨ Siri’tɨ kɨ Silisi kɨ in ginn kojɨ lə Juwipɨ’gɨ el, jɨ ra’se lapiya. ");
INSERT INTO gqr_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","J’oo poy de’gɨ madɨ in dann’je’tɨ ne awi rɔ’se’tɨ tuji me’se, təli sese gogɨ kɨ ta’gɨ lə’de, ningə in ingɨ ə j’ulə’de el. ");
INSERT INTO gqr_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Be ə, j’oyi majɨ kadɨ j’ində ta’gɨ nan’tɨ kareba jɨ mbətɨ de’gɨ j’ulə’de kɨ rɔ’se’tɨ, nan’tɨ kɨ Barnabasɨ kɨ Pol kɨ in njendigɨ’gɨ lə’je. ");
INSERT INTO gqr_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","In kɨ iləi rɔ’de kɔ tadɔ tɔ Burəɓe lə’je Jeju Kirisitɨ. ");
INSERT INTO gqr_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","In kin ə, j’ulə’n Judasɨ kɨ Silasɨ. De’gɨ kɨ joo kin a eli’se nya’gɨ kin kɨ ta’de. ");
INSERT INTO gqr_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Tadɔ in Ndil Luwə num, j’inɓe num, j’uni ndu’je kadɨ de ində nya kɨ rangɨ gidɨ nya’tɨ kɨ in nya kɨ nda’a to’tɨ kin, dɔ’se’tɨ kɨ tɔgɨ el nga. ");
INSERT INTO gqr_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Ningə nya kɨ kadɨ rai ə to kin: kadɨ sɔi da kɨ de ilə kadikare’tɨ adɨ yo’gɨ el, sɔi mosɨ da el, sɔi da kɨ de mbir m’ində el, sangi nan lo kaya’tɨ el. Pətɨ toi be ningə, a rai nya kɨ majɨ. Tai lapiya lə’je j’in ngannkon’se’gɨ.» ");
INSERT INTO gqr_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Inyəi nje kɨ mbəti’de adi awi Antiyosɨ’tɨ. Lokɨ awi tei Antiyosɨ’tɨ, kawi njekunme’gɨ kɨ nan’tɨ, ə uləi makitu kakin ji’de’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Lokɨ tudəi makitu kakin ningə, rɔ’de nəl’de ngayn tadɔ ingəi ta’gɨ kɨ adi’de tɔgɨ me’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Tokɨ Judasɨ kɨ Silasɨ inɓe’gɨ in njekeltakita Luwə’tɨ, uni dɔkagilo ngayn uləi dingəm me ngannkon’gɨ’tɨ, mbisəi nja’de me kunme’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Sii se’de dɔkagilo nden ə, ngannkon’gɨ uwəi ji’de, indəi’de ta row’tɨ kadɨ awi kɨ lapiya, təli kɨ rɔ njekulə’de’gɨ’tɨ gogɨ. ");
INSERT INTO gqr_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Nan Silasɨ oo majɨ ngayn kadɨ n’isɨ Antiyosɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pol kɨ Barnabasɨ sii Antiyosɨ’tɨ, nan’tɨ kɨ ndəgɨ de’gɨ kɨ rangɨ, ndoi de’gɨ, iləi’de mbər Poyta kɨ majɨ lə Burəɓe. ");
INSERT INTO gqr_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Nden go’tɨ, Pol el Barnabasɨ ene: «Adɨ jɨ təli j’uni dɔ nja’je me ɓebo’gɨ’tɨ pətɨ kɨ j’elita lə Burəɓe səm’tɨ kin, ə jɨ gon ngannkon’je’gɨ j’oo ke təli toi bann wa?» ");
INSERT INTO gqr_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Lo kin’tɨ, Barnabasɨ ndigɨ kadɨ Jan Markɨ aw se’de. ");
INSERT INTO gqr_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Nan Pol oo kadɨ in low’ə’tɨ el kadɨ Jan Markɨ kɨ ndɔkɨ inyə’de Pampili’tɨ, um aw se’de lo kaw kulə’tɨ el kin, kadɨ aw se’de ɓone ɓay. ");
INSERT INTO gqr_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Mindɨ kasinan el kɨ bo ngayn to dann’de’tɨ adɨ inyəi nan non be. Barnabasɨ un Jan Markɨ, ə uni tokibo aw kɨ Sipir’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Nga Pol ə un Silasɨ ə awi. Ngannkon’je’gɨ inyəi’de ji Burəɓe’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Pol njiyəi dɔnangɨ Siri’tɨ kɨ dɔnangɨ Silisi’tɨ uləi dingəm me Njekawnan’gɨ’tɨ kɨ lo lo. ");
INSERT INTO gqr_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pol re te Dərbɨ’tɨ, go’tɨ aw Lisitir’tɨ. Lo kin’tɨ ə, ingə njendo kare kɨ tɔ’a nan Timote. Kon’a in njekunme kɨ in Juwipɨ, ə baw’a in Girekɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Ngannkon’je’gɨ kɨ Lisitir kɨ Ikoniyom elita li’ə majɨ ngayn. ");
INSERT INTO gqr_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Adɨ Pol ndigɨ kuwə ji’ne’tɨ kaw si’ə. Be ə, aw si’ə ujə mɔt’ɔ, tadɔ Juwipɨ’gɨ kɨ rai ɓe lo’gɨ’tɨ kin, gəri’ə ɓətɨ kadɨ baw’a in Girekɨ. ");
INSERT INTO gqr_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Ɓebo’gɨ pətɨ kɨ tei’tɨ, ɔji ngannkon’de’gɨ ndukun’gɨ kɨ njekawkulə’gɨ kɨ ngatɔgɨ’gɨ lə Njekawnan’gɨ kɨ Jerujalem’tɨ uni. Ningə eli’de kadɨ rai go ndu’gɨ’tɨ kakin. ");
INSERT INTO gqr_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Njekawnan’gɨ ingəi tɔgɨ me kunme’tɨ lə’de, ningə kɔr’de in dɔ mad’a’tɨ kɨ ndɔ’gɨ ndɔ’gɨ. ");
INSERT INTO gqr_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Ndil Luwə ɔgɨ’de kiləmbər Poyta kɨ majɨ ngann ɓe’gɨ’tɨ kɨ Aji. Adɨ ɔti non, indəi dɔnangɨ Piriji kɨ dɔnangɨ Galasi dəri. ");
INSERT INTO gqr_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Lokɨ rei tei ndəkba kɨ Misi, sangi row kadɨ n’awi Bitini’tɨ, nan Ndil Jeju ɔgɨ’de row. ");
INSERT INTO gqr_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Be ə, indəi dɔnangɨ kɨ Misi gangi, awi tei ta ba’tɨ kɨ Tirowasɨ. ");
INSERT INTO gqr_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Low’ə’tɨ kin ə, kondɔ ə, Pol oo de kare kɨ Maseduwann’tɨ me ndil’tɨ re ra dɔ’a’tɨ. De kakin el Pol ene: «Nja’i ba, re Maseduwann’tɨ ra se’je.» ");
INSERT INTO gqr_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Go nya k’oo me ndil’tɨ lə Pol, tanan’tɨ non, jɨ sangɨ row kadɨ j’aw Maseduwann’tɨ, tadɔ jɨ gər majɨ tokɨ Luwə inɓe ə ɓar’je kadɨ j’aw j’iləmbər Poyta kɨ majɨ səm’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","J’al to Tirowasɨ’tɨ non, ə j’ɔsɨ jɨ te dɔ dor Samotirasɨ’tɨ. Lo ti go’tɨ ningə, jɨ te Neyapolisɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","J’in low’ə’tɨ non, j’aw Pilipɨ’tɨ, kɨ in ɓebo kɨ dɔkete kɨ dɔnangɨ’tɨ kɨ Maseduwann, kɨ in ginn konɓe’tɨ kɨ Rɔm. J’isɨ non, jɨ ra ndɔ’gɨ asɨ tatɨ. ");
INSERT INTO gqr_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Ningə ndɔ kɔrkon’tɨ lə Juwipɨ’gɨ, jɨ te gidɨ ɓebo’tɨ taga, kadɨ j’aw kadɨ mbo’tɨ. J’aw’tɨ tadɔ jɨ mərta kadɨ j’a j’ingə lo kelta kɨ Luwə səm’tɨ. Lokɨ j’aw ningə, j’isɨ nanga rɔ dene’gɨ’tɨ kɨ kawinan low’ə’tɨ, j’el’de ta. ");
INSERT INTO gqr_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Dann dene’gɨ’tɨ kakin, in kɨ kare isɨ non, tɔ’a nan Lidi. In dene kɨ ɓebo’tɨ kɨ Tiyatir. In nje law ta ku kɨ kər njir njir. Ningə in de kɨ nje ɓol Luwə tɔ. Sɨ oo ta, ə Burəɓe te ngarme’ə, adɨ ində mbi’ne majɨ go ta’gɨ’tɨ kɨ Pol isɨ el. ");
INSERT INTO gqr_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Nga a adɨ ra’a batəm nan’tɨ kɨ nje kɨ me kəy’tɨ li’ə. Ningə ɓar’je kadɨ j’aw ɓe lə’ne ene: «Kin ə re oyi m’in kadɨ m’in njekunme kadɨ Burəɓe ə, rei sii ɓe lə’m.» Ra dɔ ta’tɨ kin ngan, kadɨ jɨ ndigɨ go’ne’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Ndɔ kare jɨ isɨ j’aw kɨ lo kelta’tɨ kɨ Luwə ə, dene kɨ nje ra kuləɓər me kəy’tɨ kare re ingə’je. Dene kin aw kɨ ndil ndonte, adɨ lokɨ ində gara ə, ingə’n nya ngayn adɨ ɓe’ne’gɨ. ");
INSERT INTO gqr_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Un go’je kɨ Pol ə, elta kɨ ndu’ne kɨ boi ene: «De’gɨ kɨ rai kam in njekuləɓər’gɨ lə Luwə kɨ nje kisɨ dɔ nya’gɨ’tɨ pətɨ. Rei ra iləi’se mbər row kajɨ.» ");
INSERT INTO gqr_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Dene ra nya kin be ndɔ’ne banyi banyi go’je’tɨ. Be ə, ta tɔlta’a’tɨ, wongɨ ra Pol dɔ’a’tɨ, adɨ təl ta’ne el ndil kɨ isɨ me dene’tɨ kakin ene: «Me tɔ Jeju Kirisitɨ’tɨ, m’un ndu’m kadɨ te kɔ me’ə’tɨ.» Ningə tanan’tɨ non, ndil te kɔ me dene’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Lokɨ ɓe’ə’gɨ oyi kadɨ nyakingə nya lə’de kɨ indəi me’de dɔ’tɨ, ka ginn’ə gangɨ ə, uwəi Pol kɨ Silasɨ awi se’de tambalo’tɨ, non nje konɓe’gɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Awi se’de non njegangɨ ta’gɨ’tɨ eli’de eyina: «De’gɨ kɨ oyi’de kam in Juwipɨ’gɨ, ə rei kɨ ndu kɨ majel me ɓebo’tɨ lə’je. ");
INSERT INTO gqr_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Rei kɨ nya jibəlɓe’gɨ kɨ j’in de’gɨ kɨ Rɔm’tɨ, sɔw dɔ’je el, kadɨ to jɨ taa, jɨ ra’n kulə.» ");
INSERT INTO gqr_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Bulə de’gɨ indəi, ɓuki nan dɔ Pol’tɨ kɨ Silasɨ. Ningə, njegangɨ ta’gɨ, adɨ nginyəi ku rɔ’de’tɨ, tindəi’de kɨ gɔl. ");
INSERT INTO gqr_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Lokɨ indəi’de majɨ ə, awi ɓuki’de dangay’tɨ, ningə adɨ ndu njengəm dangay’gɨ kadɨ ngəmi’de majɨ. ");
INSERT INTO gqr_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Lokɨ njengəm dangay’gɨ ingə ndu kin be ə, aw se’de kəy dangay’tɨ kɨ duni nu, taa ulə kangila nja’de’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Kondɔ dann lo’tɨ, Pol kɨ Silasɨ elita kɨ Luwə, osi pa uləi tɔjɨ dɔ Luwə’tɨ, ə ndəgɨ dangay’gɨ oyi ndu’de. ");
INSERT INTO gqr_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Ningə, kɨ kum kɨ kində jipɨ, dɔnangɨ yəkɨ kɨ tɔgɨ’ne ngayn. Yəkɨ yəkɨ kɨ ra adɨ ngirə kəy dangay kaa in ɓakɨ ɓakɨ. Ningə tanan’tɨ non, takəy’gɨ tei num, kulə gindɨ’gɨ kɨ dɔi dangay’gɨ pətɨ kaa tuti num tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Lo kin’tɨ non, njengəm dangay’gɨ ində dɔ ɓi’tɨ. Lokɨ ində taa dɔ ɓi’tɨ ə oo takəy’gɨ rai tagira, oo ene dangay’gɨ anyinan wa, adɨ ɔr kiyərɔ lə’ne kadɨ to n’tɔl’n rɔ’ne kɔ. ");
INSERT INTO gqr_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Ə Pol un ndu’ne kɨ taa ngayn el’ə ene: «Tujɨ rɔ’i el, nan j’isi ne pətɨ.» ");
INSERT INTO gqr_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Lo kin’tɨ, njengəm dangay’gɨ dəjɨ por, ə nagɨ rɔ’ne ur kəy, osɨ non Pol’tɨ kɨ Silasɨ kɨ rɔ dadɨ. ");
INSERT INTO gqr_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Go’tɨ, adɨ’de tei taga, ningə dəjɨ’de ene: «Ɓe’m’gɨ, in ri ə kadɨ m’ra ə m’a m’ingə’n kajɨ wa?» ");
INSERT INTO gqr_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ə eli’ə eyina: «Un me’i adɨ Burəɓe Jeju, ə a ingə kajɨ in kɨ nje kɨ me kəy’tɨ lə’i.» ");
INSERT INTO gqr_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Lo kin’tɨ, iləi’ə mbər ta lə Burəɓe, nan’tɨ kɨ nje kɨ me kəy’tɨ li’ə. ");
INSERT INTO gqr_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Dann kondɔ’tɨ inɓe kin non, njengəm dangay’gɨ aw kɨ Pol in kɨ Silasɨ, togɨ do’gɨ lə’de, ə kalangɨ ba go’tɨ, adɨ rai’ə batəm nan’tɨ kɨ de’gɨ kɨ me kəy’tɨ li’ə. ");
INSERT INTO gqr_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Go’tɨ, təl aw se’de me kəy’tɨ lə’ne, adɨ’de nyakusɔ sɔi, rai rɔnel me kəy’tɨ tadɔ kun kɨ uni me’de adi Luwə. ");
INSERT INTO gqr_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Lokɨ lo ti ningə, njegangɨ ta’gɨ uləi paja’gɨ lə’de kɨ rɔ njengəm dangay’gɨ’tɨ eyina: «Inyə de’gɨ kin adɨ awi.» ");
INSERT INTO gqr_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Ə njengəm dangay’gɨ re el Pol ta kin ene: «Njegangɨ ta’gɨ eyina kadɨ m’inyə’se madɨ awi, ene tei awi lo lə’se kɨ lapiya.» ");
INSERT INTO gqr_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Nan Pol el paja’gɨ ene: «J’in de’gɨ kɨ Rɔm’tɨ tɔ, ə adɨ de’gɨ indəi’je takum bulə de’gɨ’tɨ, kɨ kanjɨ gangɨ ta dɔ’je’tɨ. Ə go’tɨ, ɓuki’je dangay’tɨ be par tɔ. Ningə ngɔsine, inyəi’je taa kidɨ kuwə be par wa? A in be el! Adɨ inɓe’gɨ rei kɨ rɔ’de inyəi’je taa!» ");
INSERT INTO gqr_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Ə paja’gɨ təli kɨ ta kin awi rɔ njegangita’gɨ’tɨ, adɨ ɓol ra njegangɨ ta’gɨ ngayn. Ɓol ra’de, lokɨ oyi kadɨ Pol in de’gɨ kɨ Rɔm’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Be ə, indəi, rei rɔ’de’tɨ, dəji’de mesɔl, ə inyəi’de kadɨ awi, ə dəji’de kadɨ tei me ɓebo’tɨ kin kɔ nga. ");
INSERT INTO gqr_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Lokɨ Pol in kɨ Silasɨ tei dangay’tɨ ə, awi ɓe lə Lidi. Awi oyi ngannkon’gɨ kɨ njekunme’gɨ, uləi dingəm me’de’tɨ ə awi. ");
INSERT INTO gqr_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pol in kɨ Silasɨ indəi Ampipolisɨ kɨ Apoloni gangi, ə awi tei Tesalonikɨ’tɨ. Ningə Tesalonikɨ’tɨ, Juwipɨ’gɨ awi kɨ lo kəykawnan lə’de non. ");
INSERT INTO gqr_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Be ə, Pol awɨ’tɨ, tokɨ isɨ ra’n kɨ lo’gɨ pətɨ. Asɨ ndɔ kɔrkon mutə go nan’tɨ, Pol manjinan ta kɨ Juwipɨ’gɨ dɔ ta’gɨ’tɨ kɨ me Makitu’tɨ lə Luwə. ");
INSERT INTO gqr_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Ɔr’de ginn ta’gɨ, tɔjɨ’de adɨ gəri tokɨ, makitu lə Luwə el kadɨ Kirisitɨ kɨ in De kɨ Luwə mbət’ə a oy, ə go’tɨ, a ində taa dann njekoy’gɨ’tɨ. Ningə, Pol el’de tokɨ in darɔ Jeju inɓe kɨ n’isɨ n’el’de mbər ta li’ə kin ə in Kirisitɨ. ");
INSERT INTO gqr_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Juwipɨ’gɨ kɨ nan’gɨ, ta kin ra kulə rɔ’de’tɨ, adɨ indəi rɔ’de nan’tɨ kɨ Pol kɨ Silasɨ. Bulə Girekɨ’gɨ kɨ nje kɔsikurə Luwə kɨ dene’gɨ ngayn kɨ in dene kɨ nje tɔɓar’gɨ kaa indəi rɔ’de nan’tɨ se’de tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ə lo kin’tɨ, jangɨ ra Juwipɨ’gɨ, adɨ kawi de’gɨ kɨ ra uləi lo kɨ gorow kare, adɨ ɔsi dɔ de’gɨ nan’tɨ, rai ndu kɨ me ɓe. Awi tei me kəy’tɨ lə Jason, sangi Pol kɨ Silasɨ kadɨ n’uwəi’de, n’awi se’de taga, non bulə de’gɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Nan lokɨ ingəi’de el, uwəi Jason kɨ ngannkon’gɨ kɨ madɨ’gɨ, awi se’de non njegangɨ ta’gɨ’tɨ. Ningə elita kɨ ndu’de kɨ boi eyina: «De’gɨ kɨ tuji dɔnangɨ kɨ ta’a ba kaa, rei tei ne. ");
INSERT INTO gqr_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Rei ə, Jason uwə’de rɔ’ne’tɨ ɓe lə’ne. De’gɨ kin pətɨ, nya ra’de in nyara kɨ ɔsi ta ndukun’gɨ lə Nje konɓe kɨ bo Sejar. In eli tokɨ ngar madɨ kɨ rangɨ in non tɔ’a nan Jeju.» ");
INSERT INTO gqr_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Ta kin adɨ wongɨ bulə de’gɨ kɨ njegangɨ ta’gɨ, ");
INSERT INTO gqr_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","adɨ uwəi Jason kɨ ndəgɨ njekunme’gɨ adɨ ugəi nar ɓay taa inyəi’de taa. ");
INSERT INTO gqr_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Lokɨ lo ene n’gonyi par ə, ngannkon’gɨ adi Pol kɨ Silasɨ awi Bere’tɨ. Lo kɨ rei tei Bere’tɨ ə, awi kəykawnan’tɨ lə Juwipɨ’gɨ. ");
INSERT INTO gqr_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Juwipɨ’gɨ kɨ Bere’tɨ, awi kɨ mərta kɨ majɨ ngayn utə nje kɨ Tesalonikɨ’tɨ. Taai ta lə Luwə kɨ ndigɨ ra kɨ majɨ ngayn. Ndəri ginn ta lə Luwə kɨ ndɔ’gɨ pətɨ, kadɨ n’oyi ke ta’gɨ kɨ Pol eli’de kin in ta kɨ rɔta’tɨ inɓe. ");
INSERT INTO gqr_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Be ə, ngayn’gɨ dann’de’tɨ uni me’de, taa dann Girekɨ’gɨ’tɨ, dene’gɨ kɨ nje tɔɓar, kɨ dingəm’gɨ ngayn uni me’de tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Nan lokɨ Juwipɨ’gɨ kɨ Tesalonikɨ’tɨ, oyi kadɨ Pol isɨ iləmbər ta lə Luwə Bere’tɨ non ningə, təli awi go’de’tɨ ɓay, awi suləi bulə de’gɨ adɨ rai ndu. ");
INSERT INTO gqr_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Lo kin’tɨ ngannkon’gɨ, sangi row kalangɨ ba adi Pol aw kɨ kadɨ babo’tɨ. Nga ningə, Silasɨ kɨ Timote ə nanyinan Bere’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Nje kɨ dani Pol, dani’ə bitɨ, awi tei si’ə Atenn’tɨ. Nga a, lokɨ isɨ təli, Pol adɨ’de ndu’ne kadɨ Silasɨ kɨ Timote rei kalangɨ ingəi’ne. ");
INSERT INTO gqr_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Lokɨ Pol isɨ nginə Silasɨ kɨ Timote, Atenn’tɨ hangal’a tujɨ tadɔ yo’gɨ kɨ de’gɨ isɨ rai’de, rosɨ me ɓebo kin. ");
INSERT INTO gqr_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Pol manjinan ta’tɨ kɨ Juwipɨ’gɨ, kɨ de’gɨ kɨ nje kɔsikurə Luwə, me kəykawnan’tɨ lə Juwipɨ’gɨ, taa kɨ ndɔ’gɨ pətɨ, tambalo’tɨ, kɨ de’gɨ kɨ ingə’de. ");
INSERT INTO gqr_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Nje nyagər’gɨ kɨ ɓari’de Epikir’gɨ kɨ Sətoyisi’gɨ kaa manjinan ta’tɨ se’de tɔ. Ə nje kɨ madɨ’gɨ eli eyina: «Nje ta’gɨ kam ta ri ə ra eli indəi ndu be wa?» Ningə nje kɨ nungɨ eli eyina: «To to nya kɨ in nje kelta kɨ dɔ luwə’gɨ’tɨ kɨ mbah ə am.» Eli be tadɔ oyi kadɨ Pol isɨ iləmbər Poyta kɨ majɨ lə Jeju num, isɨ iləmbər kində taa lo koy’tɨ num. ");
INSERT INTO gqr_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Be ə, uwəi Pol, awi si’ə rɔ njegangɨ ta’gɨ’tɨ, ə eli’ə eyina: «To kadɨ el’je ta dɔ nyando’tɨ kɨ sigɨ kɨ isɨ ndo kin adɨ jɨ gər wa? ");
INSERT INTO gqr_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Tadɔ in isɨ el’je ta’gɨ kɨ mbi’je oo nja kare el, ə kadɨ ɔr ginn’ə majɨ adɨ j’oo.» ");
INSERT INTO gqr_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Ningə nya kare kɨ majɨ kadɨ in gər, de’gɨ kɨ Atenn’tɨ pətɨ, kɨ mbah’gɨ kɨ sii dann’de’tɨ, dɔkagilo lə’de kɨ ngayn in tadɔ k’el’n ta’gɨ kɨ sigɨ ə k’oo’n ta’gɨ kɨ mbah. ");
INSERT INTO gqr_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Lo kin’tɨ, Pol ində ra taa, dann njegangɨ ta’gɨ’tɨ, ə un ta el ene: «In de’gɨ kɨ Atenn’tɨ, m’oo kadɨ in de’gɨ kɨ, ɓar yo lə’se ətɨ ɓol kɨ dum. Ɓari yo me nya’gɨ’tɨ pətɨ. ");
INSERT INTO gqr_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Tadɔ, lokɨ m’njiyə me ɓe’tɨ, m’oo nya’gɨ kɨ isɨ ɔsi məkəsɨ’se nanga non’de’tɨ. M’oo lo ɓar yo madɨ inɓe ɓay kɨ indəi nya dɔ’tɨ eyina in lo lə “luwə kɨ in gəri’ə el,” ningə in kɨ isɨ ɔsi məkəsɨ’se nanga non’a’tɨ kɨ kanjɨ gər’ə kakin ə m’njɨ m’ilə’se mbər ta li’ə. ");
INSERT INTO gqr_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","In Luwə kɨ njera dɔran kɨ dɔnangɨ kɨ nya’gɨ pətɨ kɨ me’tɨ, in kɨ in Be nje dɔran kɨ dɔnangɨ. In nje kisɨ me kəy’tɨ kɨ de ra kɨ ji’ne el. ");
INSERT INTO gqr_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Taa aw kɨ ndoo kadɨ de ra kulə madɨ ad’a el tɔ, tadɔ in ə in nje kadɨ de isɨ kumngayira num, nje kadɨ de kon kɨ nya’gɨ pətɨ num tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Kɨ de kɨ kareba be ə ində’n de’gɨ pətɨ adɨ taai dɔnangɨ. Ində dɔkagilo adɨ’de num, ində gangɨ lo kisi’de num tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Luwə ində nya’gɨ kin be kadɨ de’gɨ sangi’ə’n’ə. Dɔ majɨ ə a ingəi’ə me mam lo’tɨ lə’de. Kɨ rɔta’tɨ, Luwə in sanyi el kɨ de kɨ ra dann’je’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Tadɔ kisikidɔtaa lə’je in me ji’ə’tɨ. In ə in nje kadɨ j’ɔdi rɔ’je, kɨ nje kadɨ jɨ isɨ kumngayira. In tadɔ kin ə njegosita’gɨ lə’se kɨ madɨ’gɨ eli eyina: “J’in kaa j’in ngann’a’gɨ tɔ.” ");
INSERT INTO gqr_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Ə re j’in ngann’gɨ lə Luwə ə, majɨ kadɨ j’oo Luwə kadɨ in de kɨ to to yo ɔr’gɨ, kɨ yo nar’gɨ kɨ de’gɨ lenyi’de, eke yo mbal’gɨ kɨ de’gɨ tɔli’de kɨ gosɨ kɨ dɔ’de’tɨ kin be el. ");
INSERT INTO gqr_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Luwə inyə go nya kɨ de’gɨ rai kete kɨ go lo gər’ə’tɨ el, dɔkagilo’tɨ kɨ gəri el ɓay kin kɔ, nan kɨ ngɔsine kin, Luwə iləmbər kadɨ de’gɨ pətɨ, kɨ lo’gɨ pətɨ, inyəi gorow njiyə’de kɨ majel kɔ. ");
INSERT INTO gqr_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Tadɔ ɔr ndɔ kare ində non kadɨ to a gangɨ’n ta dɔ de’gɨ kɨ dɔnangɨ’tɨ ne pətɨ kɨ row kɨ dana. A gangɨ ta kin kɨ row lə de kare kɨ mbət’ə tadɔ kulə kin, in tɔj’ɔ kɨ taga adɨ de’gɨ pətɨ gəri’ə kɨ row kində taa dann njekoy’gɨ’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Lokɨ Pol elta kində taa lo koy’tɨ, ə osɨ mbi’de’tɨ ningə, nje kɨ madɨ’gɨ uwəi’ə kogi, ə nje kɨ nungɨ eli eyina: «J’a j’oo ta lə’i kin ndɔ kɨ rangɨ’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","In be ə, Pol te’n dann’de’tɨ, aw. ");
INSERT INTO gqr_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Nan be kaa, kɨ madɨ’gɨ dann’de’tɨ nanyinan go Pol’tɨ, uni me’de adi Jeju Kirisitɨ. Dann’de’tɨ kin, Denisɨ kɨ in kɨ kare dann njegangita’gɨ’tɨ in se’de non, taa dene kɨ ɓari’ə nan Damarisɨ kɨ ndəgɨ de’gɨ kɨ rangɨ kaa in se’de non tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Lokɨ Pol in Atenn’tɨ ningə, aw Korentɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Lo kin’tɨ non, ingə Juwipɨ kare kɨ tɔ’a nan Akilasɨ, kɨ ginn’ə in Pon’tɨ, in Itali’tɨ kɨ ne’ne Pirisil rei ngɔsine ɓay. Rei tadɔ nje konɓe kibo kɨ Rɔm’tɨ kɨ tɔ’a nan Kilodɨ un ndu’ne kadɨ Juwipɨ’gɨ pətɨ tei Rɔm’tɨ kɔ. Pol aw ingə Akilasɨ’gɨ non, ");
INSERT INTO gqr_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","ningə tokɨ kulə kɨ kadɨ rai ingəi nya in kulə kɨ kareba, adɨ in kulə kojɨ ku ra kəy, Pol isɨ se’de, adɨ rai kulə kin nan’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Ndɔ kɔrkon’gɨ pətɨ, Pol un ta, el me kəykawnan’tɨ lə Juwipɨ’gɨ. El kɨ kujə kɨ sangɨ kadɨ Juwipɨ’gɨ kɨ Girekɨ taai to ta kɨ rɔta’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Nan lokɨ Silasɨ kɨ Timote in Maseduwann’tɨ rei ingəi’ə, Pol un dɔkagilo lə’ne pətɨ tadɔ k’elta lə Luwə. Tɔjɨ Juwipɨ’gɨ kadɨ gəri tokɨ Jeju in Kirisitɨ kɨ in De kɨ Luwə mbət’ə. ");
INSERT INTO gqr_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Nan Juwipɨ’gɨ tanyi’ə rɔ, taji’ə, adɨ Pol jəngɨ bu ku lə’ne ta de’tɨ, ə el’de ene: «Ta mosɨ’se in dɔ’se’tɨ! M’ar njay. Ningə kɨ ngɔsine kin, de’gɨ kɨ in Juwipɨ’gɨ el ə m’a m’aw kɨ rɔ’de’tɨ nga.» ");
INSERT INTO gqr_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Be ə, Pol in non, aw ɓe lə Titusɨ Jusitusɨ, kɨ in de kare kɨ nje kɔsikurə Luwə, kɨ kəy li’ə ndunə nan kɨ kəykawnan lə Juwipɨ’gɨ. ");
INSERT INTO gqr_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Kirisipusɨ, kɨ in njekundɔ kəykawnan lə Juwipɨ’gɨ in kɨ de’gɨ kɨ me kəy’tɨ lə’ne ba pətɨ, uni me’de adi Burəɓe. Taa de’gɨ kɨ Korentɨ ngayn, kɨ oyi ta lə Pol kaa uni me’de tɔ, adɨ rai’de batəm. ");
INSERT INTO gqr_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Ndɔ kare kondɔ, Burəɓe el Pol ta me nii’tɨ ene: «Ɓol el, elta kɨ nonyi’tɨ, um utɨ ta’i el. ");
INSERT INTO gqr_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Tadɔ m’in sə’i nan’tɨ, de madɨ kare kɨ a ulə ji’ne kadɨ ɔdi tokɨ majel goto. De’gɨ kɨ in de’gɨ lə’m in ngayn me ɓebo’tɨ kin ne.» ");
INSERT INTO gqr_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Be ə Pol isɨ’n Korentɨ’tɨ ɓal kare kɨ nanyi mehen, ndo’n de’gɨ ta lə Luwə. ");
INSERT INTO gqr_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Dɔkagilo’tɨ kɨ Galiyon in’n nje konɓe kɨ Akay’tɨ, Juwipɨ’gɨ dɔi ta nan’tɨ dɔ Pol’tɨ, adɨ awi si’ə non njegangɨ ta’gɨ’tɨ, ");
INSERT INTO gqr_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","eyina: «De kam isɨ aw kɨ de’gɨ kadɨ ɔsi dɔ’de nanga non Luwə’tɨ, kigo ndukun’tɨ el.» ");
INSERT INTO gqr_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pol ra kadɨ to n’el ta ningə, Galiyon un ta ta’ne’tɨ kete el Juwipɨ’gɨ ene: «Kin ə re in ta lə nya tɔl, eke ta lə majel madɨ kɨ ngan ngayn ə to be ə, re m’a m’oo ta lə’se, in Juwipɨ’gɨ. ");
INSERT INTO gqr_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Nan tokɨ in ta kɨ manjinan’tɨ kɨ ɔjidɔ ta’gɨ, kɨ tɔgɨ kɨ ndukun’gɨ lə’se kɨ sɔw dɔ’se kin ə, rai dann’se’tɨ non. M’in m’a m’gangɨ ta kɨ be kin el.» ");
INSERT INTO gqr_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Ningə tuwə’de lo gangɨ ta’tɨ kɔ. ");
INSERT INTO gqr_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Ə low’ə’tɨ non, de’gɨ pətɨ uwəi Sositenn kɨ in njekundɔ kəykawnan lə Juwipɨ’gɨ, tindəi’ə lo gangɨ ta’tɨ non, nan usɨ Galiyon nya kare dɔ’de’tɨ el. ");
INSERT INTO gqr_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pol təl isɨ Korentɨ’tɨ non dɔkagilo asɨ ta’tɨ ɓay. Ningə go’tɨ, inyə ngannkon’gɨ, ə un tokibo kaw kɨ Siri’tɨ, nan’tɨ kɨ Pirisil kɨ Akilasɨ. Pol adɨ ngisəi dɔ’a Sankire’tɨ, tadɔ un mindɨ’ne adɨ Luwə. ");
INSERT INTO gqr_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Awi tei Epejɨ, Pol inyə Pirisil kɨ Akilasɨ ə aw kəykawnan’tɨ lə Juwipɨ’gɨ, manjinan ta’tɨ se’de. ");
INSERT INTO gqr_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Juwipɨ’gɨ kin dəji Pol kadɨ isɨ se’de ndɔ’gɨ nden ɓay, nan Pol ndigɨ el. ");
INSERT INTO gqr_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Ningə lokɨ ɔtɨ isɨ aw el’de ene: «Ndɔ kɨ rangɨ, ə Luwə ndigɨ ə, m’a m’təl to m’re rɔ’se’tɨ ɓay,» ningə inyə’de Epejɨ’tɨ ə in me tokibo’tɨ ə aw. ");
INSERT INTO gqr_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Ningə un to Epejɨ’tɨ, aw Sejare’tɨ. Lo kɨ te Sejare’tɨ, aw uwə ji Njekawnan’gɨ, ə un row aw Antiyosɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Pol ra ndɔ’gɨ non nden, ə təl ilə dɔ’ne gogɨ. Aw te Galasi’tɨ kɨ Piriji’tɨ, adɨ tɔgɨ njendo’gɨ pətɨ. ");
INSERT INTO gqr_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Juwipɨ kare kɨ tɔ’a nan Apolosɨ, kɨ in de kɨ ginn’ə in Alegijandiri’tɨ re Epejɨ’tɨ. In de kɨ ɓal ta to ta’a’tɨ, taa gər ta lə Luwə majɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Ndoi’ə row ta lə Burəɓe, adɨ iləmbər ta lə Jeju kɨ rɔnel kɨ ngayn, ndo de’gɨ nya kɨ dɔ Jeju’tɨ kɨ gorow’ə’tɨ. Nan k’in ə, gər batəm lə Jan par. ");
INSERT INTO gqr_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Ilə rɔ’ne, elta lə Luwə kəykawnan’tɨ lə Juwipɨ’gɨ kɨ me kɨ tinyi katɨ. Nan lokɨ Pirisil kɨ Akilasɨ oyi’ə lo kelta’tɨ, ɓari’ə rɔ’de’tɨ, ɔji’ə gorow lə Luwə ar njay, adi’ə gər. ");
INSERT INTO gqr_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Go’tɨ, ndigɨ kaw Akay’tɨ, ə ngannkon’je’gɨ ndigɨ dɔ’tɨ si’ə, adɨ rai makitu adi njendo’gɨ kɨ Akay’tɨ kadɨ uwəi’ə rɔ’de majɨ. Lokɨ aw te Akay’tɨ, kigo memajɨ’tɨ lə Luwə, ra kɨ nje kɨ uni me’de adi Luwə ngayn. ");
INSERT INTO gqr_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Tadɔ dum dɔ Juwipɨ’gɨ kɨ tɔgɨ ta lə’ne, taga wangɨ takum de’gɨ’tɨ. Tɔjɨ, kɨ ta lə Luwə ji’ne’tɨ, tokɨ Jeju in Kirisitɨ kɨ in De kɨ Luwə mbət’ə. ");
INSERT INTO gqr_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Dɔkagilo’tɨ kɨ Apolosɨ in’n Korentɨ’tɨ, Pol ində dɔnangɨ kɨ mbal’gɨ in’tɨ kɨ dɔnangɨ Aji’tɨ gangɨ, ə re te Epejɨ’tɨ. Ingə njendo’gɨ lə Jeju kɨ nan’gɨ’tɨ non. Adɨ dəjɨ’de ene: ");
INSERT INTO gqr_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","«Lokɨ uni me’se adi Jeju kin, ingəi Ndil Luwə wa?» Ə təli iləi’ə’tɨ eyina: «Jagɨ, k’oo ka j’oo kete kadɨ Ndil Luwə in non el.» ");
INSERT INTO gqr_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Pol təl dəjɨ’de ɓay ene: «Batəm kɨ bann ə ingəi wa?» Eli eyina: «J’ingə batəm lə Jan Batisɨ.» ");
INSERT INTO gqr_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Be ə, Pol el’de ene: «Oyo, Jan ra batəm Isirayel’gɨ kadɨ tɔri ndu’de dɔ majel’gɨ’tɨ lə’de. Ə təl el’de ɓay kadɨ to uni me’de adi de kɨ a re go’ne’tɨ non, adɨ de’ə kin in Jeju.» ");
INSERT INTO gqr_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Lokɨ oyi ta’gɨ kin ningə, adɨ rai’de batəm me tɔ Burəɓe Jeju’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Be ə, Pol ində ji’ne dɔ’de’tɨ, ə Ndil Luwə risɨ dɔ’de’tɨ. Ningə tumginn kadɨ elita kɨ ndonnta’gɨ kɨ dangɨ dangɨ num, ta elita kɨ ta Luwə’tɨ num tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Dingəm’gɨ pətɨ kɨ rai lo nya’gɨ’tɨ kin asi dɔgɨ gidə in joo. ");
INSERT INTO gqr_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Go’tɨ, asɨ nanyi mutə go nan’tɨ, Pol te ə aw kəykawnan’tɨ lə Juwipɨ’gɨ, el’de ta kɨ me kɨ tinyi katɨ kibo. Iləmbər konɓe lə Luwə, sangɨ uwə’de kɨ ta, kadɨ oyi to ta kɨ rɔta’tɨ kadɨ tai ta kin tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Nan Juwipɨ’gɨ kɨ nan’gɨ dann’de’tɨ me’de ngan, adɨ mbeti kadɨ uni me’de. Elita kidi nyando lə Pol kɨ ɔjɨ gorow ta lə Burəɓe kin takum bulə de’gɨ’tɨ. Be ə, Pol inyə’de ə ɔtɨ aw kɨ njendo’gɨ me kəy ndo nya’tɨ lə de kɨ tɔ’a nan Tiranusɨ. Ningə kɨ ndɔ’gɨ kare kare pətɨ, ndo’de nya. ");
INSERT INTO gqr_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Nyando kin, Pol ra kul’ə asɨ ɓal joo. Be ə, ra adɨ Juwipɨ kɨ de’gɨ kɨ in Juwipɨ’gɨ el kɨ isɨ dɔnangɨ Aji’tɨ, oyi ta lə Burəɓe. ");
INSERT INTO gqr_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Luwə ra nyakɔjɨ’gɨ kɨ ətɨ ɓol kɨ takul Pol. ");
INSERT INTO gqr_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Adɨ, de’gɨ ɔyi ta ku’gɨ kɨ kare kɨ ta ku kɨ ji’ə ɔdɨ, awi ɔdi njemonyi’gɨ adɨ ingəi lapiya num, ndil’gɨ kɨ majel kaa anyinan kɔ num tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Juwipɨ’gɨ kɨ nan’gɨ kɨ nje njiyə kigo ɓe’gɨ, kadɨ n’tuwəi ndil’gɨ kɨ majel, ingɨ kaa gei kadɨ n’ɓari tɔ Burəɓe Jeju dɔ de’gɨ’tɨ kɨ in ginn tɔgɨ’tɨ lə ndil’gɨ kɨ majel tɔ. Adɨ eli eyina: «Me tɔ Jeju’tɨ kɨ Pol isɨ iləmbər ta li’ə, m’dəjɨ’se kadɨ tei kɔ.» ");
INSERT INTO gqr_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","De’gɨ kɨ njera nya be kakin, in siri. In ngann’gɨ lə Juwipɨ kare kɨ tɔ’a nan Seba kɨ in kibo lə njekujənyamosɨ kadikare’gɨ. ");
INSERT INTO gqr_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Ndil kɨ majel təl ilə’de’tɨ ene: «M’gər Jeju, taa m’gər de kɨ in Pol tɔ, nan ingɨ, in nan’gɨ wa?» ");
INSERT INTO gqr_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Lo kin’tɨ, de kɨ ndil kɨ majel sii me’ə’tɨ kakin ində ur dɔ’de’tɨ uwə’de tɔsɔsɔ. Ningə ində’de kində kɨ de oo go madɨ’ne el, adɨ tei me kəy’tɨ kɨ kanyi kɨ rɔ’de kare, kɨ ku kɨ gangɨ rɔ’de’tɨ batɨ batɨ kɨ mosɨ. ");
INSERT INTO gqr_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","De’gɨ pətɨ kɨ ɓebo Epejɨ’tɨ, kɨ Juwipɨ’gɨ nan’tɨ kɨ de’gɨ kɨ in Juwipɨ’gɨ el, gəri go nya kɨ ra nya kin majɨ. Ingɨ pətɨ ɓol ra’de, adɨ ɔsikurə Burəɓe Jeju. ");
INSERT INTO gqr_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","De’gɨ ngayn kɨ in njekunme’gɨ rei tɔrindu’de, ə eli kulə ra’de’gɨ kɨ majel kɨ taga non de’gɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Nje kɨ nan’gɨ ngayn dann njera mboli’gɨ’tɨ, rei kɨ makitu ra mboli’gɨ lə’de, kawi kɨ dɔnan’tɨ ə uləi por takum de’gɨ’tɨ. Ndogi se’de makitu’gɨ lə’de kin asɨ silə dər dɔ mi. ");
INSERT INTO gqr_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","In be ə, kɨ takul tɔgɨ lə Burəɓe, ta lə Luwə sanan kɨ lo’gɨ’tɨ kɨ kete kete kɨ tɔgɨ’ne tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Go nya’gɨ’tɨ kin, Ndil Luwə ɔsɨ Pol adɨ un ndu’ne kadɨ n’aw ɓebo Jerujalem’tɨ. Dɔ row kaw’a’tɨ, ində dɔnangɨ Maseduwann kɨ Akay gangɨ. Ningə Pol el ene: «Re m’aw m’te ɓebo Jerujalem’tɨ ə, majɨ kadɨ m’aw m’oo dɔnangɨ Rɔm tɔ.» ");
INSERT INTO gqr_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Pol ulə kɨ njera si’ə kulə’gɨ joo, Timote ingɨ kɨ Erasɨ adɨ’de awi dɔnangɨ Maseduwann’tɨ. Ningə inɓe, isɨ dɔnangɨ Aji’tɨ ba njaba ɓay. ");
INSERT INTO gqr_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Dɔkagilo’ə’tɨ kin, ta kasɨ nan el kibo ngayn in dɔ row ta’tɨ lə Burəɓe me ɓe’tɨ kɨ Epejɨ. ");
INSERT INTO gqr_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","De kare kɨ tɔ’a nan Demetriyusɨ, in kɔdɨ kɨ njera ningə kasɨ’gɨ. In njera ngann kəy yo kɨ dene kɨ a ɓari’ə nan Artemisɨ. Kulə kin ra adɨ in sotɨ kɨ njekulə’gɨ li’ə ngayn. ");
INSERT INTO gqr_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Be ə, Demetriyusɨ kaw kɔdɨ’gɨ kɨ de’gɨ pətɨ kɨ isɨ kɨ dɔ’de taa kɨ takul kulə kin nan’tɨ, ə el’de ene: «Madɨ’m’gɨ, in gəri kadɨ in kɨ takul kulə kin ə, j’isɨ j’ingəi nya majɨ. ");
INSERT INTO gqr_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Ingɨ oyi kɨ kum’se taa kɨ mbi’se tɔ, kadɨ in Epejɨ’tɨ ne par el, nan dɔnangɨ Aji’tɨ ba pətɨ, ə dingəm kɨ tɔ’a nan Pol kam təl dɔ bulə de’gɨ basi. In el’de ene: “Kagɨ yo’gɨ kɨ de’gɨ rai kɨ ji’de in Luwə el.” ");
INSERT INTO gqr_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","In kulə’gɨ kɨ j’isi rai kin par ə de’gɨ a oyi to nya kɨ kare el, nan kəy lə luwə kɨ dene kibo kɨ in Artemisɨ kin kaa, de’gɨ a oyi’ə nya madɨ’tɨ el tɔ. Lo kadɨ de’gɨ a eli eyina: “Artemisɨ in yo kɨ dene kɨ bo,” goto. Artemisɨ kɨ de’gɨ kɨ dɔnangɨ Aji’tɨ kɨ ndəgɨ dɔnangɨ ba pətɨ ɔsikurə kin.» ");
INSERT INTO gqr_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Lokɨ kɔdɨ’gɨ oyi ta’gɨ kin ningə, wongɨ ra’de ngayn, adɨ tumginn kadɨ elita kɨ ndu’de kɨ boi eyina: «Artemisɨ lə Epejɨ’tɨ, in kibo.» ");
INSERT INTO gqr_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Kalangɨ ba go’tɨ ningə, lo singə səkitə kɨ ta tat’a ba me ɓebo’tɨ. De’gɨ ndɔri Gayusɨ in kɨ Arisitarkɨ, de’gɨ kɨ Maseduwann’tɨ, kɨ in madɨ mbah lə Pol kum’de’tɨ, ə ngodɨ tɔl’de kɨ tambalo’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pol ndigɨ kadɨ n’tɔjɨ rɔ’ne bulə de’gɨ, nan njendo’gɨ ɔgi’ə. ");
INSERT INTO gqr_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Ningə basa madɨ Pol madɨ kɨ in de kibo kɨ dɔnangɨ Aji’tɨ, uləi kulə rɔ’a’tɨ, eli’ə kadɨ aw tambalo’tɨ el. ");
INSERT INTO gqr_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Tambalo’tɨ, nya kɨ to ar njay dɔ de’gɨ’tɨ goto: Ta’gɨ kɨ isɨ te ta de’gɨ’tɨ in ta’gɨ kɨ dangɨ dangɨ. Ningə de’gɨ ngayn dann madɨ’de’gɨ’tɨ gəri ginn nya kɨ kawinan el. ");
INSERT INTO gqr_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","De’gɨ kɨ nan’gɨ dann bulə de’gɨ’tɨ ɔri ginn nya kɨ ra nya kin adɨ Alegijandir kɨ Juwipɨ’gɨ indəi’ə to njekundɔ’de kin ad’a oo. Alegijandir ulə ji’ne taa, dəjɨ’n de’gɨ kadɨ rai keke, tadɔ ge k’elta, ɔrta dɔ’de’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Lokɨ gəri’ə kadɨ in Juwipɨ ningə, ingɨ pətɨ uləi bilə kɨ ndu’de kibo asɨ ngirə kadɨ joo ge be eyina: «Artemisɨ lə Epejɨ’tɨ, in kibo.» ");
INSERT INTO gqr_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Ta tɔlta’a’tɨ ningə, njendo ndukun kɨ me ɓebo’tɨ, re ra adɨ lo to jijiji, ɓay taa el’de ene: «In de’gɨ kɨ Epejɨ’tɨ, nan ə gər kadɨ ɓe kɨ Epejɨ’tɨ, in njengəm kəy lə Artemisɨ kɨ in yo kɨ dene kɨ in kibo kin el ə, eke nan ə gər kadɨ in nje ngəm mbal kɨ in banakum’ə kɨ in dɔran’tɨ osɨ el wa?» ");
INSERT INTO gqr_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","In kin in nya kɨ dum manjɨ. Majɨ kadɨ uwəi hangal’se indəi nanga, ə in mərita ta rai nya. ");
INSERT INTO gqr_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Ingɨ ə ɔri de’gɨ kam rei se’de ne, nga, nya madɨ kɨ majel kɨ rai ɔsi takəy kin goto, taa elita kɨ mal dɔ luwə’tɨ lə’je kɨ dene Artemisɨ el tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Re Demetriyusɨ in kɨ de’gɨ kɨ nje ra kulə’gɨ lə’ne, rai ta kɨ de madɨ ningə, ndɔ gangɨ ta’gɨ to’i non, ə majɨ kadɨ awi oyi njegangɨ ta’gɨ. ");
INSERT INTO gqr_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Re nya madɨ kɨ rangɨ to non kadɨ dəji ə, ndɔ kɨ kadɨ nje kində manjɨ ta’gɨ kin kɨ gorow’ə’tɨ to non. ");
INSERT INTO gqr_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Nya’gɨ kɨ rai nya ɓone kin, asɨ kadɨ de’gɨ iləi ta dɔ’je’tɨ to nje k’aldɔ ndu’gɨ, tadɔ ta madɨ kɨ j’a j’eli ə j’a j’ɔri ta dɔ’je’tɨ, kɨ ɔjɨ go kawnan lə de’gɨ kɨ ɓone kin goto. Be ə, go ta’gɨ’tɨ kɨ njendo ndukun el, tuwə de’gɨ adɨ sananyinan. ");
INSERT INTO gqr_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Lokɨ wongɨ lə de’gɨ yokiro ningə, Pol ulə ɓar njendo’gɨ, ulə dingəm me’de’tɨ ɓay ta ra’de lapiya ə ɔtɨ aw Maseduwann’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Pol ingə dɔkagilo’gɨ ngayn ulə’n dingəm me njekunme’gɨ’tɨ lokɨ isɨ ində dɔnangɨ kakin gangɨ. Ningə gangɨ kɨ kete non aw Giresɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Pol isɨ’tɨ non nanyi mutə. Dɔkagilo’tɨ kɨ kadɨ un tokibo kaw kɨ dɔnangɨ Siri’tɨ ningə, gər kadɨ Juwipɨ’gɨ uləi ta’de nanga kadɨ n’rai si’ə nya kɨ majel. Be ə, təl un row kɨ Maseduwann’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Mbunə de’gɨ’tɨ kɨ dani’ə a ingə Sopater kɨ ngonn lə Pirusɨ kɨ Bere’tɨ num, Arisitarkɨ in kɨ Segondusɨ kɨ in de’gɨ kɨ Tesalonikɨ’tɨ num, Gayusɨ kɨ Dərbɨ’tɨ num, Timote num, taa Tisikɨ num in kɨ Tiropim kɨ in de’gɨ kɨ dɔnangɨ Aji’tɨ num tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","De’gɨ kin ɔti kete non’je’tɨ, awi nginəi’je Tirowasɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","J’in ə, go ndɔ’gɨ’tɨ lə mapa kɨ ra kɨ hum ɔd’ɔ el, ə j’al me to’tɨ me ɓe’tɨ kɨ Pilipɨ j’isɨ j’aw. J’aw, jɨ ra ndɔ mi row’ə, ə j’aw j’ingə madɨ’je’gɨ Tirowasɨ’tɨ, jɨ ra ndɔ siri. ");
INSERT INTO gqr_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Ndɔ Dɔmasɨ, jɨ kawnan tadɔ kusɔ mapa, Pol a aw lo ti’tɨ, adɨ elta kɨ njendo’gɨ. Be ə, elta ratata dann lo dɔ’a’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Jɨ kawnan me kəy’tɨ kɨ in dɔ mad’a’tɨ taa. Ningə me kəy’tɨ kakin, lambɨ’gɨ ngayn in səm’tɨ non. ");
INSERT INTO gqr_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Lokɨ Pol isɨ elta adɨ ngal, Basa kare kɨ tɔ’a nan Etikusɨ isɨ penetir’tɨ, to ɓi kanum, adɨ ɓi un’ə, in kəy’tɨ kɨ nja mutə dɔ mad’a’tɨ, te osɨ. Lokɨ de’gɨ eyina n’uni’ə ə, basa oy. ");
INSERT INTO gqr_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Pol ur nanga, dow rɔ’ne dɔ’a’tɨ ə un’ə ji’ne’tɨ ə el’de ene: «Adi me’se gangɨ mann el nan to kum ɓay!» ");
INSERT INTO gqr_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Go’tɨ, Pol təl ala taa gogɨ, gangɨ mapa sɔ. Un ta kɨ ta’ne’tɨ gogɨ bitɨ taginnlo’tɨ, ə ɔtɨ aw. ");
INSERT INTO gqr_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Nga ningə, de’gɨ ɔri basa awi si’ə ɓe kumngayira, adɨ de’gɨ pətɨ me’de osɨ nanga. ");
INSERT INTO gqr_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","J’in j’aw kete kɨ to me ɓe’tɨ kɨ Asosɨ. Me ɓe’tɨ kin ə, j’a j’uni Pol nan’tɨ se’je. Tadɔ kigo kɔjitara’tɨ li’ə, ge kadɨ n’un row kɨ nja’ne. ");
INSERT INTO gqr_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Lokɨ re ingə’je Asosɨ’tɨ, j’uni’ə me tokibo’tɨ nan’tɨ se’je ə j’awi Mitilene’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Lo ti go’tɨ ningə, j’ɔti non me tokibo’tɨ ka ɓay, jɨ re jɨ te ta lo’tɨ kɨ Kiyo. Ndɔ kɨ go’tɨ ningə, jɨ te Samosɨ. Ndɔ kɨ nja sɔ ɓay ta jɨ te Mile’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pol ndigɨ kadɨ n’ra lo katɨ Epejɨ’tɨ el nan pa nya ta dɔkagilo dər dɔ’ne’tɨ dɔnangɨ Aji’tɨ. Ge kadɨ n’aw kalangɨ kadɨ re to’n bann inɓe kaa, ndɔ Pantəkotɨ osɨ dɔ’ne’tɨ Jerujalem. ");
INSERT INTO gqr_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Lokɨ Pol in me ɓe’tɨ kɨ Mile ə, ulə ɓar ngatɔgɨ’gɨ lə Njekawnan’gɨ kɨ Epejɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Lokɨ rei tei rɔ’a’tɨ ningə, el’de ene: «In gəri row panjiyə’m dɔkagilo’gɨ pətɨ kɨ m’in’n sese nan’tɨ, tumginn’ə dɔ ndɔ kɨ dɔkete’tɨ kɨ m’re’n dɔnangɨ Aji’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","M’ra kuləɓər lə Burəɓe kɨ dɔ kɨ sɔl lɔm lɔm, me mann non’tɨ kɨ me nya nan’gɨ’tɨ kɨ m’ingə kɨ row’gɨ kɨ dangɨ dangɨ kɨ gorow kulə ta nanga kɨ in rɔ Juwipɨ’gɨ’tɨ kɨ madɨ. ");
INSERT INTO gqr_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Gəri ɓətɨ, m’iyə’se dɔ nya madɨ kare el. M’ilə’se mbər Poyta kɨ majɨ ta m’ndo’se nya’gɨ pətɨ kɨ a ra sese majɨ tɔ, taga dann bulə de’gɨ’tɨ num, me kəy’gɨ’tɨ num tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","M’iləmbər m’ɓar’n Juwipɨ’gɨ num, Girekɨ’gɨ num kadɨ təli rɔ’de go Luwə’tɨ ə inyəi gorow njiyə’de’gɨ kɨ majel kin kɔ, taa kadɨ uni me’de adi Burəɓe lə’je Jeju Kirisitɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Kɨ ngɔsine kin, Ndil Luwə ində dɔ’m’tɨ, adɨ m’njɨ m’aw Jerujalem’tɨ kɨ kanjɨ kadɨ m’gər nya kɨ a ra’m nu. ");
INSERT INTO gqr_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Nya kɨ m’gər, me ɓebo’gɨ’tɨ kare kare kɨ m’te’tɨ Ndil Luwə el’m ta adɨ m’gər tokɨ dangay’gɨ kɨ kon’gɨ isɨ nginəi m’in non. ");
INSERT INTO gqr_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Kɨ ɔjidɔ’m, kisikidɔtaa lə’m in nya madɨ takum’tɨ el. Nya ge lə’m in kadɨ m’aw ratata m’tɔlta ngodɨ lə’m, ə kadɨ m’ra kuləɓər kɨ m’ingə ji Burəɓe Jeju’tɨ kin majɨ. Adɨ in kulə kiləmbər Poyta kɨ majɨ kɨ ɔjidɔ memajɨ lə Luwə. ");
INSERT INTO gqr_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Ningə ngɔsine, m’gər kadɨ ingɨ pətɨ kɨ m’njiyə dann’se’tɨ ə m’ilə’se mbər Poyta kɨ majɨ kɨ ɔjidɔ konɓe lə Luwə kin, de kare kaa a oo’m el ratata nga. ");
INSERT INTO gqr_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","In be ə, m’elta lə’m taga ar njay ɓone, ta mosɨ’se pətɨ goto dɔ’m’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Tadɔ kɔjitara’gɨ lə Luwə pətɨ, m’iləmbər dɔ’tɨ madɨ oyi. Nya kɨ m’iyə dɔ’a rɔ’se’tɨ goto. ");
INSERT INTO gqr_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Indəi kumkədɨ dɔ rɔ’se’tɨ inɓe’gɨ, taa dɔ nyakul’gɨ’tɨ kɨ in Njekawnan kɨ Ndil Luwə adɨ’se kadɨ ngəmi’de kin tɔ. Majɨ kadɨ indəi kum’se go Njekawnan’gɨ’tɨ lə Luwə kɨ ndogɨ’de kɨ mosɨ’ne, to njekul nyakul’gɨ kɨ majɨ. ");
INSERT INTO gqr_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","M’gər kadɨ lokɨ m’a m’goto dann’se’tɨ, de’gɨ madɨ kɨ a toi to jagum’gɨ kɨ nje mendul, a rei uri dann’se’tɨ ə a rai Njekawnan’gɨ majel. ");
INSERT INTO gqr_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Ningə mbunə’se’tɨ inɓe’gɨ kaa, de’gɨ madɨ a təli nje rugɨ ta kɨ rɔta’tɨ kadɨ təli nje kawnan madɨ’gɨ njendo’gɨ’tɨ lə’de. ");
INSERT INTO gqr_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Majɨ kadɨ sii dɔ nja’se’tɨ, adɨ me’se olo dɔ’tɨ, tokɨ me ɓal’tɨ kɨ mutə kɨ m’ra dann’se’tɨ, kondɔ’tɨ kɨ kada, kare kare pətɨ, m’inyə ta kulə dingəm me’se’tɨ el, kɨ mann non kɨ kum’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Ningə ngɔsine, m’ulə’se ji Luwə’tɨ, taa m’ndəjɨ’se kɨ ta li’ə kigo memajɨ’tɨ li’ə tɔ. Ta kin aw kɨ tɔgɨ kadɨ adɨ tɔgi me kunme’tɨ, taa Luwə a adɨ’se nya majɨ’gɨ pətɨ kɨ isɨ ngəm tadɔ lə de’gɨ pətɨ kɨ ində’de ta dangɨ. ");
INSERT INTO gqr_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Lo kɨ m’in dann’se’tɨ, m’ra kumnda nar, eke ɔr eke ku lə de madɨ dann’se’tɨ el. ");
INSERT INTO gqr_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Inɓe’gɨ gəri ɓətɨ, kadɨ kɨ ɔjidɔ kisikidɔtaa lə’m, eke yan madikulə’m’gɨ, m’ra kulə kɨ ji’m m’inɓe. ");
INSERT INTO gqr_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","M’ɔjɨ’se kɨ lo’gɨ pətɨ, eke kɨ dɔkagilo’gɨ pətɨ kadɨ rai kulə be kadɨ indəi kum’se go nje yai’gɨ’tɨ. Ningə majɨ kadɨ me’se olo dɔ ta’tɨ kɨ Burəɓe Jeju inɓe el kɨ ta’ne ene: “Majikur in ngayn dɔ de’tɨ kɨ adɨ utə de kɨ isɨ taa.”» ");
INSERT INTO gqr_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Go ta’gɨ’tɨ kɨ Pol el kin ningə, ɔsɨ məkəsi’ne nanga, ə elta kɨ Luwə nan’tɨ se’de pətɨ. ");
INSERT INTO gqr_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Ningə go’tɨ, ingɨ pətɨ, ɓuki nan kɨ non’tɨ, ə osɨ mindɨ Pol’tɨ uwəi’ə, ə orei’ə kɨ rɔ’de’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Ta li’ə kɨ el’de ene: «A oyi kum gogɨ el,» kin ɔr tɔgɨ’de ngayn. Ningə dani’ə bitɨ awi si’ə ta to’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Go k’inyə nan’tɨ kɨ ngatɔgɨ’gɨ lə Njekawnan’gɨ kɨ Epejɨ’tɨ, j’al me to’tɨ, ə j’aw njururu dɔ dor’tɨ kɨ tɔ’a nan Bulə de’gɨ. Lo ti go’tɨ ningə, jɨ te me ɓebo’tɨ kɨ Rodɨ. J’ɔti Rodɨ’tɨ ə j’aw ɓebo’tɨ kɨ Patara. ");
INSERT INTO gqr_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","J’ingə tokibo isɨ aw Penesi’tɨ adɨ j’al me’tɨ j’aw si’ə. ");
INSERT INTO gqr_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Lokɨ j’oo dɔ dor Sipir kɨ kum’je be ningə, j’inyə kɨ holo be ə j’ɔr taa kɨ dɔnangɨ Siri’tɨ. J’awi j’ur nanga Tir. Lo kin’tɨ non kɨ a ɔri nya’gɨ kɨ me to’tɨ nanga. ");
INSERT INTO gqr_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","J’ingə njendo’gɨ me ɓe’tɨ kakin non, adɨ j’isɨ se’de asɨ ndɔ siri. Njendo’gɨ kakin, Ndil Luwə ɔsɨ’de adɨ eli Pol kadɨ aw Jerujalem’tɨ el. ");
INSERT INTO gqr_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Nan lokɨ dɔkagilo lə’je asɨ ningə, j’ində taa, j’un tarow lə’je. Njendo’gɨ pətɨ, kɨ ne’de’gɨ kɨ ngann’de’gɨ dani’je bitɨ tei se’je gidɨ ɓebo’tɨ. Low’ə’tɨ non, j’ɔsi məkəsɨ’je nanga ta ba’tɨ, j’elta kɨ Luwə. ");
INSERT INTO gqr_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Go’tɨ, lokɨ j’el nan ta’gɨ kɨ dɔboy’tɨ kɨ kadɨ j’inyə’n nan, ə j’ala me to’tɨ ə ingɨ təli kɨ ɓe’gɨ lə’de tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","J’ində ngangɨ kaw mbah lə’je kɨ tokibo, lokɨ j’in Tir’tɨ jɨ re jɨ te Tolemayisɨ’tɨ. Me ɓebo’tɨ kin non, j’uwə ji ngannkon’je’gɨ, ə j’isɨ se’de ndɔ kare. ");
INSERT INTO gqr_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Lo ti dɔ’tɨ ningə, jɨ re jɨ te Sejare’tɨ. J’aw me kəy’tɨ lə Pilipɨ kɨ in nje kiləmbər Poyta kɨ majɨ, kɨ in mbunə de’gɨ’tɨ kɨ siri kɨ nje kində kum’de go nya majɨ’gɨ’tɨ lə Njekawnan’gɨ kɨ Jerujalem’tɨ. J’isɨ rɔ’a’tɨ non. ");
INSERT INTO gqr_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Me kəy’tɨ li’ə, ngann dene’gɨ sɔ kɨ gəri dingəm el ɓay, kɨ in njekelta kɨ ta Luwə’tɨ sii səm’tɨ non. ");
INSERT INTO gqr_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","J’isi me kəy’tɨ lə Pilipɨ kakin jɨ ra ndɔ ngayn nga a kadɨ njekeltakita Luwə’tɨ kɨ tɔ’a nan Agabusɨ in Jude’tɨ re ingə’je non. ");
INSERT INTO gqr_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Njekeltakita Luwə’tɨ kakin un ndar dɔ ɓədɨ lə Pol dɔ’n ji’ne’gɨ kɨ nja’ne’gɨ, ningə el ene: «Ndil Luwə ene, me ɓebo’tɨ kɨ Jerujalem, Juwipɨ’gɨ a dɔi’ə to ndar dɔ ɓədɨ kin be. Ningə a iləi’ə ji de’gɨ’tɨ kɨ in Juwipɨ’gɨ el.» ");
INSERT INTO gqr_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Lokɨ j’oo ta kin ningə j’in kɨ ngannkon’je’gɨ kɨ Sejare’tɨ j’uwə nja Pol, jɨ dəj’ə kadɨ aw Jerujalem’tɨ el. ");
INSERT INTO gqr_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Nan Pol ilə’je’tɨ ene: «Ononyi’se kadɨ nonyi adɨ me’m gangɨ mann. M’in Pol m’in ndəkba kadɨ de’gɨ dɔi m’in par el, nan re ɔjidɔ koy kaa, m’in ndəkba kadɨ m’oy tadɔ tɔ Burəɓe Jeju Jerujalem’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Lokɨ j’oo kadɨ Pol təl rɔ’ne go ta’gɨ’tɨ kɨ j’el’ə el, j’in kaa jɨ təl jɨ ta kon tɔ, ə jɨ təl jɨ dəjɨ kadɨ Luwə ra ndigɨ lə’ne par. ");
INSERT INTO gqr_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Go ndɔ’gɨ’tɨ kɨ jɨ ra dɔnangɨ Sejare’tɨ, jɨ ra go rɔ’je ə j’ɔtɨ j’aw Jerujalem’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Njendo’gɨ kɨ madɨ kɨ Sejare’tɨ awi se’je nan’tɨ Jerujalem’tɨ. Lokɨ jɨ te Jerujalem’tɨ ningə dani’je me kəy’tɨ kɨ de madɨ kɨ tɔ’a nan Minason, adɨ j’isɨ’tɨ. In de kɨ Sipir’tɨ. In kɨ kare mbunə njendo’gɨ’tɨ kɨ dɔkete. ");
INSERT INTO gqr_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Lokɨ jɨ re jɨ te Jerujalem’tɨ, ngannkon’gɨ uwəi’je rɔ’de’tɨ kɨ rɔnel kɨ ətɨ ɓol. ");
INSERT INTO gqr_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Lo ti dɔ’tɨ, Pol aw se’je me kəy’tɨ lə Jakɨ. Lo kin’tɨ ə, j’ingə ngatɔgɨ’gɨ lə njekawnan’gɨ pətɨ, səm’tɨ non. ");
INSERT INTO gqr_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Go kuwə ji’tɨ kɨ Pol uwə ji’de ningə, ɔr’de poy nya’gɨ kɨ Luwə ra tadɔ ginn de’gɨ kɨ in Juwipɨ’gɨ el, kɨ takul kulə li’ə kin, bere bere adɨ’de oyi. ");
INSERT INTO gqr_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Go nya’gɨ’tɨ kɨ Pol ɔr’de poy’o kin ningə, uləi tɔjɨ dɔ Luwə’tɨ, ə eli Pol eyina: «Ngonnkon’je, ində kum’i oo, Juwipɨ’gɨ dər banyi banyi ə uni me’de adi Jeju, nan pətɨ uwəi go ndukun lə Mojɨ ngan. ");
INSERT INTO gqr_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ningə kɨ ngɔsine kin oyi ta dɔ’i’tɨ tokɨ isɨ ndo Juwipɨ’gɨ pətɨ kɨ sii to mbah’gɨ dɔnangɨ’gɨ’tɨ kɨ rangɨ kadɨ inyəi go ndukun’gɨ lə Mojɨ kɔ num, el’de kadɨ ujəi mɔtɨ ngann de’gɨ el num, taa nya jibəlɓe’gɨ lə Juwipɨ’gɨ ka kadɨ uni go’ə el num tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Adɨ jɨ mər dɔ nya’tɨ kadɨ jɨ ra, tadɔ a oyi poy’i kadɨ in re ka par am! ");
INSERT INTO gqr_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Be ə, majɨ kadɨ ra nya’gɨ kɨ j’a j’eli kam. J’aw kɨ de’gɨ sɔ mbunə’je’tɨ ne kɨ uni mindɨ’de kadɨ n’indəi rɔ’de ta dangɨ tadɔ lə Luwə. ");
INSERT INTO gqr_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Majɨ kadɨ ɔr de’gɨ kin go’i’tɨ, ə ra se’de nyajibəlɓe kar rɔ dɔ majel’tɨ, ə ugə dɔ’de kadɨ ngisəi dɔ’de. Ningə de’gɨ pətɨ a gəri kadɨ poy ta’gɨ pətɨ kɨ oyi ɔjidɔ’i in ta’gɨ kɨ ngom. Tadɔ inɓe kɨ dɔ’i, təl rɔ’i go ndukun’gɨ’tɨ lə Mojɨ. ");
INSERT INTO gqr_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Kɨ ɔjidɔ de’gɨ kɨ in Juwipɨ’gɨ el kɨ uni me’de, ndukun’gɨ kɨ jɨ ndangɨ j’ulə’n j’adɨ’de, in kadɨ sɔi da kɨ iləi kadikare’tɨ ɓarɨ’n yo el num, kadɨ sɔi mosɨ el num, da kɨ de mbir m’ində el, ə kadɨ sangɨ nan kigo lo kaya’tɨ kaa, kadɨ goto dann’de’tɨ tɔ.» ");
INSERT INTO gqr_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","In be ə, lo ti go’tɨ ningə, Pol aw kɨ de’gɨ kɨ sɔ kakin, ar rɔ’ne se’de, ningə go’tɨ ur natɨ Kəy’tɨ lə Luwə, ɔjɨ ndɔ kɨ ginn kar rɔ lə’de a gangɨ’n, ə kadɨ de kɨ ra dann’je’tɨ a re’n kɨ kadikare, kadɨ adɨ Luwə. ");
INSERT INTO gqr_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Lokɨ nanyi ndəkba kadɨ ginn ndɔ kɨ siri gangɨ, Juwipɨ’gɨ madɨ kɨ in dɔnangɨ Aji’tɨ, oyi Pol Kəy’tɨ lə Luwə kakin. Suləi bulə de’gɨ dɔ’a’tɨ ə osi si’ə uwəi’ə, ");
INSERT INTO gqr_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","ningə elita kɨ ndu’de kɨ bo eyina: «In de’gɨ kɨ Isirayel, rei ɔsi ginn’je! De kam ə, in njendo de’gɨ kɨ lo’gɨ pətɨ kadɨ ɔsi ta de’gɨ lə’je num, ndukun’gɨ lə’je num taa kəykawnan kin num tɔ. Ningə kɨ rangɨ ɓay, re ur kɨ de’gɨ kɨ ujəi mɔtɨ’de el natɨ Kəy’tɨ lə Luwə kadɨ təl’n lo kɨ ar njay kin, lo kɨ to njen’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Elita kin be, tadɔ kete oyi Tiropim, de kɨ ɓebo Epejɨ’tɨ si’ə me ɓebo Jerujalem’tɨ, adɨ məri me’de’tɨ tokɨ Pol re ur si’ə Kəy’tɨ lə Luwə. ");
INSERT INTO gqr_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","De’gɨ rai njir dɔnan’tɨ me ɓebo’tɨ kɨ Jerujalem’tɨ ba pətɨ. Ningə de’gɨ tei kɨ lo njon njon isɨ rei bur bur. Rei uwəi Pol tei si’ə Kəy’tɨ lə Luwə kɨ taga. Ningə tanan’tɨ non uwəi takəy’gɨ uti. ");
INSERT INTO gqr_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","De’gɨ sangi kadɨ n’tɔli Pol. Ningə kete ɓay taa kadɨ tɔli’ə, poyta osɨ mbi kɨ boi’tɨ kɨ dɔ njerɔ’gɨ’tɨ kɨ Rɔm’tɨ kadɨ ɓebo Jerujalem ba pətɨ ra kɨ nja’ne taa. ");
INSERT INTO gqr_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Tanan’tɨ non par ə, indəi taa ɓuki njerɔ’gɨ kibo’gɨ kɨ dɔ kutɨ njerɔ’gɨ’tɨ kɨ ɓu, ə anyi ngodɨ kɨ rɔ bulə de’gɨ’tɨ. Lokɨ bulə de’gɨ kakin oyi kibo kɨ dɔ njerɔ’gɨ’tɨ kɨ njerɔ’gɨ ningə, tai kon ta kində Pol’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Lokɨ re te rɔ bulə de’gɨ’tɨ, kibo kɨ dɔ njerɔ’gɨ’tɨ kakin ɔtɨ ndəkba kɨ rɔ Pol’tɨ, un ndu’ne adɨ uwəi’ə, ə adɨ dɔi’ə kɨ kulə gindɨ joo. Ningə təl dəjɨ ta ene: «Nan in dingəm kam wa? Ə ri ə ra wa?» ");
INSERT INTO gqr_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Ningə ta kɨ yətɨ to dangɨ dangɨ dann bulə de’gɨ’tɨ, ta lə’de un go nan el. Adɨ lo kadɨ kibo kɨ dɔ njerɔ’gɨ’tɨ kakin oo ta kɨ rɔta’tɨ goto. Be ə un ndu’ne kadɨ ai kɨ Pol me ndogɨ bɔr’tɨ kɨ ngal, lo kisɨ njerɔ’gɨ’tɨ ");
INSERT INTO gqr_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Lokɨ Pol re te rigɨ lo njiyə’gɨ’tɨ kin ningə, lowə goto adɨ njerɔ’gɨ uni’ə, tadɔ bulə de’gɨ bətirəi’ə kɨ wongɨ ngayn. ");
INSERT INTO gqr_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Bulə de’gɨ kɨ sii njiyəi go’ə’tɨ mukɨ mukɨ eli kɨ ndu’de kɨ boi eyina: «Kadɨ tɔli’ə!» ");
INSERT INTO gqr_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Kete ɓay taa kadɨ njerɔ’gɨ awi si’ə me ndogɨ bɔr’tɨ kɨ ngal kɨ lo kisɨ’de’tɨ, Pol dəjɨ ta kibo kɨ dɔ njerɔ’gɨ’tɨ ene: «A adɨ’m tarow kadɨ m’a m’elta kare wa?» Kibo kɨ dɔ njerɔ’gɨ’tɨ kakin dəj’ə ene: «In gər kelta Girekɨ ɓətɨ wa? ");
INSERT INTO gqr_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","M’gər el adɨ m’ɔjɨ m’ene in de kɨ Ejipitɨ kɨ ndɔkɨ me ndɔ’gɨ’tɨ kɨ gogɨ ne kin, sulə de’gɨ adɨ rai wongɨ, ə ɔr’de asɨ de’gɨ dər sɔ kɨ nyakatɨ’gɨ ji’de’tɨ, ə ur’n mu kin.» ");
INSERT INTO gqr_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Ə Pol ene: «Jagɨ, m’in Juwipɨ kɨ ɓebo’tɨ kɨ Tarsɨ kɨ dɔnangɨ Silisi’tɨ, m’in de kɨ me ɓebo’tɨ kɨ tɔ’a ɓar, ə nja’i ba inyə’m taa adɨ m’el de’gɨ ta.» ");
INSERT INTO gqr_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Be ə, kibo kɨ dɔ njerɔ’gɨ’tɨ ad’a tarow. Pol ində ra taa dɔ rigɨ lo njiyə’tɨ, ɓukɨ ji’ne dəjɨ’n bulə de’gɨ kadɨ uri mbi’de. Lokɨ lo to jijiji ningə, el’de ta kɨ ta Ebirə. ");
INSERT INTO gqr_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Pol el ene: «Ngannkon’m’gɨ kɨ bai’gɨ, uri mbi’se majɨ kadɨ oyi ta kɨ m’aw to m’el’se ngɔsine kadɨ m’manjɨ’n ta dɔ rɔ’m’tɨ kin.» ");
INSERT INTO gqr_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Lokɨ oyi kadɨ Pol el’de ta kɨ ta Ebirə ningə, təli adi lo to jijiji inɓe ɓay kadɨ n’oyi ta li’ə. ");
INSERT INTO gqr_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","Be ə Pol el’de ene: «M’in Juwipɨ kɨ oji’m’in Tarsɨ’tɨ, kɨ dɔnangɨ Silisi’tɨ. Nan oti’m’in Jerujalem’tɨ ne. Gamaliyel ə in njendo’m ndukun lə kaw’je’gɨ kadɨ m’gər majɨ majɨ. Kete m’tingə bil tadɔ lə Luwə tokɨ rai ngɔsine kin be tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","M’adɨ kon de’gɨ kɨ nje kun go nyando kɨ m’njɨ m’ndo kin kadɨ kɨ asɨ ta koy’de. M’uwə’de: dene’gɨ kɨ dingəm’gɨ, m’tɔ’de m’tilə’de dangay’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Kibo lə njekujənyamosɨ kadikare’gɨ kɨ ngatɔgɨ’gɨ pətɨ asi kadɨ a manyinajɨ lə’m dɔ ta’tɨ kin. Inɓe’gɨ ə m’taa makitu ji’de’tɨ kadɨ m’aw m’uwə’n ngannkon’gɨ kɨ Damasɨ’tɨ kɨ nje kun go nyando kin. M’uwə’de kadɨ m’re se’de Jerujalem’tɨ ne m’ɓukɨ’de dangay’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Lokɨ m’in dɔ row’tɨ, m’re ndəkba kɨ Damasɨ’tɨ, ningə kɨ kadɨ kɨ in ndəkba kɨ jam dɔ ɓe ə, tanan’tɨ non par ə, kunjɨ kibo ngayn in dɔran’tɨ re unjɨ gugɨ dɔ’m. ");
INSERT INTO gqr_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","M’osɨ kɨ takum nanga, ningə m’oo ndu ta madɨ el’m ene: “Sol, Sol, tadɔ ri ə isɨ adɨ’m kon be wa?” ");
INSERT INTO gqr_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Ə m’ilə’tɨ m’ene: “In nan ə Burəɓe?” Ningə təl el’m ene: “In m’in Jeju kɨ Najaretɨ’tɨ kɨ isɨ ad’a kon.” ");
INSERT INTO gqr_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Nje kɨ in sə’m oyi kunjɨ kakin majɨ, nan oyi ndu’de kɨ isɨ el’m ta el. ");
INSERT INTO gqr_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Lo kin’tɨ, m’dəj’ə m’ene: “Burəɓe, in ri ə kadɨ m’ra wa?” Nga a Burəɓe el’m ene: “Ində taa aw Damasɨ’tɨ non, ə a eli’nu nya’gɨ pətɨ kɨ kadɨ ra.” ");
INSERT INTO gqr_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Kunjɨ kɨ ətɨ ɓol ngayn kakin ra adɨ kum oo lo el, adɨ de’gɨ kɨ in sə’m ndɔri m’in to ndɔr ə ai sə’m Damasɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Ningə Damasɨ’tɨ, dingəm kare kɨ ɓari’ə nan Ananiyasɨ isɨ non. In de kɨ njera go ndukun’tɨ, adɨ Juwipɨ’gɨ pətɨ kɨ Damasɨ’tɨ ndigɨ ta li’ə ngayn. ");
INSERT INTO gqr_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","In ə aw rɔ’m’tɨ el’m ene: “Ngonnkon’m Sol, kadɨ kum’i oo lo.” Ningə tanan’tɨ non par ə kum oo lo adɨ m’oo’ə. ");
INSERT INTO gqr_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Ningə el’m ene: “Luwə lə kaw’je’gɨ mbəti kete nu kadɨ in gər ndigɨ li’ə, ə kadɨ oo Nje kɨ ra dana, taa kadɨ oo ta kɨ ta’a’tɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Tadɔ a in nje mannajɨ li’ə dɔ nya’gɨ’tɨ kɨ oo kɨ kum’i num, oo kɨ mbi num, kɨ rɔ de’gɨ’tɨ pətɨ. ");
INSERT INTO gqr_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Ningə kɨ ngɔsine kin, nya kɨ nanyi kadɨ de ra goto nga. Ə ində taa, ɓar tɔ Luwə, ə ra’a batəm, adɨ majel’gɨ lə’i in kɨ togɨ kɔ.”» ");
INSERT INTO gqr_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","«Lokɨ m’təl m’re Jerujalem’tɨ, m’njɨ m’elta kɨ Luwə me Kəy’tɨ lə Luwə ningə, m’oo nya me ndil’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","M’oo Burəɓe el’m ene: “In taa kalangɨ kadɨ te kɔ Jerujalem’tɨ, tadɔ a taai najɨ lə’i kɨ a man dɔ’m’tɨ el.” ");
INSERT INTO gqr_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Lo kin’tɨ, m’el’ə m’ene: “Burəɓe, de’gɨ kin gəri majɨ kadɨ in m’in ə kete m’in nje kaw kɨ lo kəykawnan’tɨ lə Juwipɨ’gɨ, m’uwə nje kɨ uni me’de adi’nu, m’tində de’gɨ m’tilə’de dangay’gɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Taa lokɨ ndɔkɨ isɨ tɔli nje mannajɨ lə’i Etiyenn kin ka, m’in low’ə’tɨ non tɔ. Adɨ ndu’m in nan’tɨ kɨ nje tɔl’ɔ’gɨ, m’inɓe m’njɨ ta ku’gɨ’tɨ lə’de m’ngəm.” ");
INSERT INTO gqr_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Nan Burəɓe el’m ene: “Aw, tadɔ m’a m’uləi sanyi rɔ de’gɨ’tɨ kɨ in Juwipɨ’gɨ el.”» ");
INSERT INTO gqr_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Lokɨ uri mbi’de oyi ta lə Pol bitɨ tei dɔ ta’tɨ kin ə, uni ndu’de kɨ taa eli eyina: «De kɨ be kin in de kɨ kadɨ goto kɔ dɔnangɨ’tɨ. In de kɨ kadɨ isɨ kɨ dɔ’ne taa el.» ");
INSERT INTO gqr_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Uri kɔl ningə, tɔri ku’gɨ lə’de tiləi kɔ, ə kəri bu sananyi kɨ taa. ");
INSERT INTO gqr_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Lo kin’tɨ, njekundɔ njerɔ’gɨ un ndu’ne kadɨ awi kɨ Pol me ndogɨ bɔr’tɨ kɨ ngal kadɨ dəji’ə ta kɨ ndəy kadɨ el nya kɨ ra nya ə adɨ de’gɨ isɨ ungi bilə dɔ’a’tɨ kin. ");
INSERT INTO gqr_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Nan, lokɨ dɔi Pol kadɨ indəi’ə ə, Pol el kibo lə njerɔ’gɨ kare kɨ ra non ene: «Adɨ ai kɨ tɔgɨ kadɨ indəi de kɨ Rɔm’tɨ kɨ ta kaa de gangɨ dɔ’a’tɨ el wa?» ");
INSERT INTO gqr_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Lokɨ kibo lə njerɔ’gɨ oo ta kin ningə, aw el kibo kɨ dɔ’de’tɨ ene: «Ra nya kɨ aw to ra kin el, de kam in de kɨ Rɔm’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Lo kin’tɨ, kibo kɨ dɔ njerɔ’gɨ’tɨ re rɔ Pol’tɨ dəj’ə ene: «El’m adɨ m’oo, in de kɨ Rɔm’tɨ wa?» Ə Pol el’ə ene: «Oyo, m’in de kɨ Rɔm’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Ə kibo kɨ dɔ njerɔ’gɨ’tɨ el Pol ene: «M’in m’adɨ nar ngayn ɓay taa kadɨ m’təl’n de kɨ Rɔm’tɨ.» Nan Pol el’ə ene: «Yan’m m’in, oji m’in to kojɨ.» ");
INSERT INTO gqr_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Par ə, tanan’tɨ non, de’gɨ kɨ kete kadɨ indəi Pol, dəji’ə’n’ə ta kakin tɔri rɔ’de gogɨ. Kibo kɨ dɔ njerɔ’gɨ’tɨ inɓe kaa ɓol ra’a tɔ, lokɨ oo kadɨ Pol in de kɨ Rɔm’tɨ, ə n’adɨ dɔi’ə kɨ kulə gindɨ. ");
INSERT INTO gqr_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Kibo kɨ dɔ njerɔ’gɨ’tɨ sangɨ kadɨ n’gər nya inɓe kɨ Juwipɨ’gɨ səki Pol kin ar njay. Be ə, lo ti dɔ’tɨ ningə, adɨ tuti Pol, ə adɨ ndu’ne kadɨ kibo’gɨ lə njekujənyamosɨ kadikare’gɨ kɨ njegangɨ ta’gɨ lə Juwipɨ’gɨ kawinan, ə aw kɨ Pol non’de’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pol gon njegangɨ ta’gɨ lə Juwipɨ’gɨ ba, ə el’de ene: «Ngannkon’m’gɨ, me’m uwə’m kɨ ta nden el, dɔ kɨ ra’m’tɨ kɨ m’ra non Luwə’tɨ bitɨ ɓone.» ");
INSERT INTO gqr_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Ningə kibo lə njekujənyamosɨ kadikare’gɨ kɨ ɓari’ə nan Ananiyasɨ adɨ ndu’ne de’gɨ kɨ rai kadɨ Pol’tɨ kadɨ indəi ta’a. ");
INSERT INTO gqr_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Ə Pol el’ə ene: «In in ə Luwə a indəi, in bɔr kɨ kɔy pon gidɨ’tɨ kadɨ nda kare. Si ne kadɨ gangɨ ta dɔ’m’tɨ kigo ndukun’tɨ, ningə təl aldɔ ndukun, adɨ ndu’i kadɨ indəi m’in ɓay.» ");
INSERT INTO gqr_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Nje kɨ rai kadɨ Pol’tɨ ndəkba eli’ə eyina: «Tajɨ kibo lə njekujənyamosɨ kadikare’gɨ lə Luwə wa?» ");
INSERT INTO gqr_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pol el’de ene: «Ngannkon’m’gɨ, m’gər kadɨ in kibo lə njekujənyamosɨ kadikare’gɨ lə Luwə el. Tadɔ ndangi me makitu’tɨ lə Luwə eyina: “A elta kɨ majel dɔ ngar’tɨ lə de’gɨ lə’i el.”» ");
INSERT INTO gqr_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Lokɨ Pol gər kadɨ de’gɨ kɨ kawinan kin, nje kɨ nan’gɨ in Sadusi’gɨ, ə nje kɨ nungɨ in *Parisɨ’gɨ ningə, un ndu’ne kɨ taa dann njegangita’gɨ’tɨ ene: «Ngannkon’m’gɨ, m’in Parisɨ, nje kojɨ’m in Parisɨ. Ningə in tadɔ kində kɨ m’ində me’m dɔ kində taa lo koy’tɨ lə njekoy’gɨ kin ə rei sə’m lo gangɨ ta’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Lokɨ Pol elta kin ə, ta kɨ manjinan’tɨ in dann Parisɨ’gɨ’tɨ kɨ Sadusi’gɨ, adɨ de’gɨ gangi nan. ");
INSERT INTO gqr_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Tadɔ Sadusi’gɨ eli eyina de’gɨ a indəi taa lo koy’tɨ el, taa malayka’gɨ, kɨ ndil’gɨ kaa gotoi tɔ. Nan Parisɨ’gɨ eli tokɨ nya’gɨ kin toi non. ");
INSERT INTO gqr_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Lo singə səkitə, ə njendangɨ ndukun’gɨ kɨ me kutɨ’tɨ lə Parisɨ’gɨ indəi taa elita kɨ tɔgɨ’de eli eyina: «J’in j’oo nya madɨ kare kɨ majel rɔ dingəm’tɨ kin el. Dɔmajɨ ə in ndil eke malayka inɓe ə el’ə ta.» ");
INSERT INTO gqr_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Lokɨ takasinan el aw kɨ kete kete, kibo lə njerɔ’gɨ ɓol kadɨ de’gɨ kin in uwəi Pol. Be ə, un ndu’ne adɨ njerɔ’gɨ kadɨ rei ɔri Pol awi si’ə me ndogɨ bɔr’tɨ kɨ ngal gogɨ. ");
INSERT INTO gqr_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Kondɔ go’tɨ ə, Burəɓe te bus rɔ Pol’tɨ el’ə ene: «Uwə tɔgi ba. Tokɨ mannajɨ lə’m Jerujalem’tɨ, majɨ kadɨ mannajɨ kin Rɔm’tɨ tɔ.» ");
INSERT INTO gqr_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Lokɨ lo ti, Juwipɨ’gɨ uni mindɨ’de kadɨ n’usɔi nya el num, n’anyi nan mann el num, bitɨ kadɨ n’tɔli Pol binəm taa. ");
INSERT INTO gqr_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Nje kɨ dɔi ta nan’tɨ kin ali dɔ dɔsɔ kare. ");
INSERT INTO gqr_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Ningə ai eli kibo’gɨ lə njekujənyamosɨ kadikare’gɨ, kɨ ngatɔgɨ’gɨ eyina: «J’un mindɨ’je kɨ ngan ngayn kadɨ j’usɔ nya el num, j’anyi mann el num, bitɨ kadɨ jɨ tɔl Pol binəm taa.» ");
INSERT INTO gqr_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Ningə kɨ ngɔsine kin, ingɨ kadɨ ndu’se in nan’tɨ kɨ njegangɨ ta’gɨ, ə kadɨ awi ingəi kibo lə njerɔ’gɨ, eli’ə tokɨ gəi kadɨ re kɨ Pol non’se’tɨ kadɨ indəi manjɨ ta li’ə majɨ majɨ oyi. Nga a, lokɨ Pol a re ə, te rɔ’se’tɨ el ɓay ə j’in j’a jɨ tɔl’ɔ. ");
INSERT INTO gqr_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Ngonn lə konnann Pol kare oo ta kin, adɨ aw go Pol’tɨ me ndogɨ bɔr’tɨ kɨ ngal el’ə. ");
INSERT INTO gqr_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Be ə, Pol ɓar njekundɔ kutɨ njerɔ’gɨ kɨ ɓu kare el’ə ene: «Aw kɨ ngonn kin rɔ kibo’tɨ lə njerɔ’gɨ. Aw kɨ ta kare non kadɨ el’ə.» ");
INSERT INTO gqr_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Njekundɔ njerɔ’gɨ kɨ ɓu aw kɨ ngonn kakin rɔ kibo’tɨ ə el’ə ene: «Dangay kɨ ɓari’ə Pol ə ɓarɨ’m, ene m’re kɨ ngonn kin rɔ’i’tɨ, tokɨ aw kɨ ta kare non kadɨ el’i.» ");
INSERT INTO gqr_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Kibo lə njerɔ’gɨ, uwə ngonn kakin ji’ne’tɨ, ɔr’ɔ aw si’ə dow kare, ə dəj’ə ene: «Ta ri ə awɨ’n kadɨ el’m wa?» ");
INSERT INTO gqr_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Ngonn kakin el’ə ene: «Juwipɨ’gɨ dɔi ta nan’tɨ kadɨ n’dəji nu kadɨ in te kɨ Pol lo ti’tɨ, non njegangita’gɨ’tɨ lə’de, tokɨ gei kadɨ n’indəi manjɨ ta li’ə majɨ majɨ n’oyi. ");
INSERT INTO gqr_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Nan majɨ kadɨ oo ta lə’de el. Tadɔ de’gɨ kɨ tei dɔ sɔ kare a toi row’ə kadɨ uwəi’ə. Uni ndu’de kɨ ngan ngayn be kadɨ n’usɔi nya el num, n’anyi nan mann el num, bitɨ kadɨ n’tɔli’ə ə binəm taa. Kɨ ngɔsine kin, sii dɔ nja’de’tɨ, isɨ nginəi ndu par.» ");
INSERT INTO gqr_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Kibo lə njerɔ’gɨ, ilə ndu’ne adɨ ngonn kɨ basa kakin kadɨ elta kin kete adɨ de kɨ rangɨ oo el, ə inyə adɨ aw. ");
INSERT INTO gqr_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Go’tɨ, kibo lə njerɔ’gɨ, ɓar njekundɔ njerɔ’gɨ kɨ ɓu in joo el’de ene: «Ɔsi nja njerɔ’gɨ ɓu joo nan’tɨ, nje kal sində’gɨ dɔ siri, ə nje kɨ nungɨ’gɨ ɓu joo tɔ. Ningə sii dɔ nja’se’tɨ kadɨ kɨ dɔjoo gidə in kare ə, uni tarow kɨ kaw kɨ Sejare’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Indəi dɔ sində’gɨ nan’tɨ uni Pol tɔ. Ə kadɨ awi tei si’ə rɔ nje konɓe’tɨ Pelisɨ, kɨ kanjɨ kadɨ nya madɨ ra’a.» ");
INSERT INTO gqr_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Kibo lə njerɔ’gɨ ndangɨ makitu kin be adɨ nje konɓe ene: ");
INSERT INTO gqr_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","«M’in Kilodɨ Lisiyasɨ ə m’ndangɨ makitu kin m’ad’i kibo lə’m, nje konɓe Pelisɨ. Nya kɨ dɔkete, m’uwə ji’i! ");
INSERT INTO gqr_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Ningə dingəm kin, Juwipɨ’gɨ uwəi’ə kadɨ re a tɔli’ə, ə lokɨ m’oo kadɨ in de kɨ Rɔm’tɨ, m’aw kɨ njerɔ’gɨ m’taa’ə’n ji’de’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","M’sangɨ kadɨ m’gər nya inɓe kɨ ra ə Juwipɨ’gɨ səki’ə’n’ə, adɨ m’aw si’ə non njegangɨ ta’gɨ’tɨ lə’de in Juwipɨ’gɨ. ");
INSERT INTO gqr_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Lo kin’tɨ ə, m’oo kadɨ səki’ə ɔjidɔ ndukun’gɨ lə’de, nan nya madɨ kare kɨ majel kɨ ra kɨ asɨ kadɨ de tɔl’ɔ’n’ə eke uwə’n dangay’tɨ goto. ");
INSERT INTO gqr_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Eli m’in kadɨ Juwipɨ’gɨ isɨ sangi row kadɨ n’tɔli’ə, be ə, m’un’ə kalangɨ m’ulə si’ə m’ad’i. Ningə m’un ndu’m kadɨ awi səki’ə rɔ’i’tɨ nu.» ");
INSERT INTO gqr_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Njerɔ’gɨ rai tokɨ kibo lə’de ɔjɨ’n’de, adɨ awi kɨ Pol kondɔ’tɨ ratata tei si’ə Antipatirisɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Lo ti dɔ’tɨ, njerɔ’gɨ kɨ nje nja təli gogɨ lo kisɨ’de’tɨ, ə inyəi nje sində’gɨ adɨ awi kɨ Pol. ");
INSERT INTO gqr_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Lokɨ tei Sejare’tɨ, nje sində’gɨ uni makitu lə nje konɓe, ə ɔji’ə Pol tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Nje konɓe tudə makitu kakin, ə dəjɨ Pol ke in de kɨ dɔnangɨ’tɨ kɨ ra wa? Ningə oo kadɨ Pol in de kɨ Silisi’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Ə el Pol ene: «M’a m’oo ta kɨ ta’i’tɨ, ndɔ kɨ nje səki’gɨ inɓe a rei.» Ningə adɨ ndu’ne kadɨ ngəmi Pol me kəy ngar’tɨ lə Erodɨ. ");
INSERT INTO gqr_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Ndɔ mi go’tɨ, kibo lə njekujənyamosɨ kadikare’gɨ kɨ ɓari’ə nan Ananiyasɨ re Sejare’tɨ. De’gɨ kɨ dani’ə rei si’ə in ngatɔgɨ’gɨ taa njenajɨ dɔ de’gɨ’tɨ kɨ ɓari’ə nan Tertulusɨ tɔ. Ananiyasɨ kɨ de’gɨ kɨ go’ə’tɨ kin awi səki Pol rɔ nje konɓe’tɨ kɨ dɔnangɨ Sejare’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Lokɨ ɓari Pol ə, Tertulusɨ ulə ngirə kində ta dɔ’a’tɨ non nje konɓe’tɨ ene: ");
INSERT INTO gqr_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","«In kibo, Pelisɨ, kɨ takul’i, kɨ takul gosɨ konɓe lə’i, kɨ takul nya’gɨ kɨ tur ginn’de kɨ tadɔ majɨ lə de’gɨ me ɓe ə, j’isi’n kɨ lapiya. In kin in majɨ kɨ jɨ gər kɨ lo’gɨ pətɨ me nya’gɨ’tɨ pətɨ, ə j’isɨ rai oyo. ");
INSERT INTO gqr_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Ningə, kadɨ j’indəi kɔr’tɨ ngayn el, jɨ dəji kadɨ ur mbi, kigo me majɨ’tɨ lə’i kadɨ oo’n dɔ ta kɨ j’a j’eli ta’gɨ kare ke joo. ");
INSERT INTO gqr_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","J’oo kadɨ dingəm kam in nje tujɨ ɓe. Re kɨ ganginan dann Juwipɨ’gɨ’tɨ kɨ lo’gɨ pətɨ dɔnangɨ’tɨ ne. In njekundɔ kutɨ lə de’gɨ kɨ Najaretɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Aw bitɨ kadɨ n’təl kɨ *Kəy lə Luwə lo kɨ to njen’tɨ, ə j’uwə.  ");
INSERT INTO gqr_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Jɨ ndigɨ kadɨ jɨ gangɨ ta dɔ’a’tɨ kigo ndukun’tɨ lə’je, nan njekundɔ njerɔ’gɨ kɨ ɓari’ə nan Lisiyasɨ, re ində tɔgɨ ta’ə’n’ə ji’je’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Ningə un ndu’ne kadɨ nje kində ta dɔ’a’tɨ rei nonyi’tɨ. Kin ə el’je ta ə, inɓe a oo kadɨ ta’gɨ kɨ j’el dɔ’a’tɨ kin in ta kɨ rɔta’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Juwipɨ’gɨ indəi rɔ’de nan’tɨ kɨ Tertulusɨ eyina, ta’gɨ kɨ el dɔ Pol’tɨ in ta kɨ rɔta’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Nje konɓe ra nya madɨ adɨ’n tarow Pol kadɨ elta. Be ə, Pol un ta ta’ne’tɨ ene: «M’gər kadɨ asɨ ɓal ngayn ə isɨ gangɨ ta me ɓe’tɨ lə’je ne. Ningə, in kigo taa kɨ m’taa me’i ə m’a m’manjɨ’n ta dɔ’m’tɨ non’i’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Asɨ kadɨ inɓe in sangɨ ginn’ə ə a gər majɨ. Kaw kɨ m’aw Jerujalem’tɨ m’ɔsɨ dɔ’m nanga non Luwə’tɨ kin, m’aldɔ ndɔ kɨ dɔgɨ gidə in joo el ɓay. ");
INSERT INTO gqr_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Ningə, lokɨ m’aw kin, in me Kəy’tɨ lə Luwə, eke me kəykawnan’tɨ lə Juwipɨ’gɨ, eke lo madɨ’tɨ kɨ rangɨ me ɓebo’tɨ non, de kɨ oo’je, j’isɨ jɨ manjɨ nan ta kɨ de madɨ, eke oo’m m’njɨ m’sulə de’gɨ goto. ");
INSERT INTO gqr_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Taa de’gɨ inɓe kɨ rai ne kam, asɨ kadɨ ɔji nya madɨ kare dɔ ta’tɨ kɨ indəi dɔ’m’tɨ kin, kadɨ in ta kɨ rɔta’tɨ, el tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Ningə, m’gər non’i’tɨ ne tokɨ, m’njɨ m’ra kuləɓər lə Luwə lə bai’gɨ. M’ra kulə kin kɨ gorow kɨ ingɨ kɨ indəi taa dɔ’m’tɨ kin, oyi kadɨ in gorow kɨ low’ə’tɨ el. M’in m’oo kadɨ kunme dɔ nya’gɨ pətɨ kɨ ndukun lə Mojɨ elta’a, kɨ nya’gɨ pətɨ kɨ de’gɨ kɨ njekeltakita Luwə’tɨ elita’a in nya’gɨ kɨ rɔta’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","M’ində me’m dɔ nya’tɨ kin rɔ Luwə’tɨ. Ningə ingɨ kaa, indəi me’de dɔ’tɨ tɔ. Pətɨ, j’ində me’je’tɨ kadɨ de’gɨ kɨ njera nya kɨ dana kɨ njera nya kɨ dana el, a indəi taa lo koy’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","In tadɔ kin ə, m’ində tɔgɨ dɔ rɔ’m’tɨ kadɨ me’m uwə’m kɨ ta non Luwə’tɨ el num, non de’gɨ’tɨ el num tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Go ɓal’gɨ’tɨ kɨ banyi banyi kɨ m’goto, m’re kɨ nar kadɨ m’ra’n kɨ de’gɨ lə’m, taa kɨ kadikare kadɨ m’adɨ Luwə tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Lo kin’tɨ, in Juwipɨ’gɨ kɨ Aji’tɨ, ə ingəi m’in m’a m’ra kujɨ nya ra’gɨ kɨ tadɔ kar rɔ njay me Kəy’tɨ lə Luwə. Lo kɨ ingəi m’in kin, de’gɨ uwəi nan gidɨ’m’tɨ el num, taa de ra nya kɨ biriri el num tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Nga ningə, in Juwipɨ’gɨ kɨ Aji’tɨ kakin ə re a rei non’i’tɨ ne kadɨ to indəi taa dɔ’m’tɨ, lokɨ re ai sə’m kɨ ta madɨ. ");
INSERT INTO gqr_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","A re in be el tɔ ningə, nje kində ta dɔ’m’tɨ kɨ rai nya kakin, elita nya kɨ m’tɔl ə oyi ta’a, lokɨ m’ra’n non nje gangɨ ta’tɨ lə Juwipɨ’gɨ kakin adɨ j’oo. ");
INSERT INTO gqr_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Ta kare kɨ m’un ndu’m taa non’de’tɨ m’ene: “In kɨ kadɨ kɨ m’un me’m kadɨ njekoy’gɨ a indəi taa lo koy’tɨ ə m’ra’n non’se’tɨ lo gangɨ ta’tɨ ne”, kin inɓe ə in ta kɨ kareba kɨ kadɨ rai dɔ’tɨ inɓe taa.» ");
INSERT INTO gqr_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Pelisɨ kɨ gər row lə Kirisitɨ majɨ, ɔr ndɔ kete, ningə el’de ene: «Ndɔ kɨ Lisiyasɨ kɨ njekundɔ njerɔ’gɨ re ə to m’ində manjɨ ta lə’se kin ɓay». ");
INSERT INTO gqr_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Ningə adɨ ndu’ne adɨ kibo lə njerɔ’gɨ kɨ ɓu, kare kɨ njengəm Pol kadɨ ngəm’ə dangay’tɨ. Nan k’in ə kadɨ inyə Pol adɨ ilə rɔ’ne, taa kadɨ inyə tarow adɨ de li’ə kɨ ra kɨ ge kadɨ n’ra si’ə kaa, kadɨ ra si’ə tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Asɨ ndɔ’gɨ go’tɨ, Pelisɨ təl rei kɨ ne’ne Dirusil kɨ in Juwipɨ. Lokɨ rei, ulə adɨ rei kɨ Pol adɨ el’ə ta kɨ dɔ kunme’tɨ, me tɔ Jeju Kirisitɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Nan lokɨ Pol elta te’n dɔ nyara kɨ dana’tɨ, kɨ kuwə rɔ ginn tɔgɨ’tɨ, kɨ ta kɨ gangɨ kɨ a re ningə, ɓol ra Pelisɨ adɨ el Pol ene: «Asɨ nga, ə aw to ndɔ kɨ m’ingə dɔkagilo kɨ rangɨ ə m’a m’ɓar’i ɓay.» ");
INSERT INTO gqr_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Ningə ɔjɨ me’ne’tɨ tokɨ Pol a adɨ’ne nar wa be, adɨ taa taa, ɓar Pol adɨ re wal si’ə ta. ");
INSERT INTO gqr_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Ɓal joo dər dɔ Pol’tɨ, ningə Pɔrsiyusɨ Pəsitusɨ ɔr tor Pelisɨ. Pelisɨ ndigɨ kadɨ n’ra nya kɨ nəl Juwipɨ’gɨ adɨ inyə Pol dangay’tɨ ba. ");
INSERT INTO gqr_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Ndɔ mutə go k’un kulə konɓe dɔ dɔnangɨ’tɨ kɨ kadɨ a onɓe dɔ’tɨ, Pəsitusɨ in Sejare’tɨ aw Jerujalem. ");
INSERT INTO gqr_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Lo kin’tɨ, kibo’gɨ lə njekujənyamosɨ kadikare’gɨ kɨ kibo’gɨ lə Juwipɨ’gɨ, rei səki dɔ Pol rɔ’a’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Me səkɨ’tɨ, dəji Pəsitusɨ kɨ non kum’de’tɨ kadɨ ra se’de ə ulə kɨ Pol Jerujalem. Nan kɨ rɔta’tɨ ə, indəi dɔ ta nan’tɨ kadɨ to gangi Pol dɔ row’tɨ tɔli’ə. ");
INSERT INTO gqr_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Non be, Pəsitusɨ el’de ene: «Pol in dangay’tɨ Sejare, taa m’inɓe kɨ dɔ’m kaa ndɔ ngayn el ə m’a m’təl kadɨ m’aw Sejare’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Nan, re dingəm kin ra nya kɨ go’tɨ el non ə, majɨ kadɨ kibo’gɨ lə’se awi sə’m nan’tɨ səki’ə.» ");
INSERT INTO gqr_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Pəsitusɨ ra ndɔ kɨ asɨ jijoo, a re ngayn ə dɔgɨ be par, ə təl aw Sejare’tɨ gogɨ. Lokɨ təl re ə, lo ti kɨ rangɨ go’tɨ ningə, aw lo gangɨ ta’tɨ, un ndu’ne adɨ rei kɨ Pol non’a’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Lokɨ Pol re, Juwipɨ’gɨ kɨ in Jerujalem’tɨ iləi nan gugɨ dɔ’a, indəi ta’gɨ kɨ ngan ngan ngayn dɔ’a’tɨ. Nan asi kadɨ ɔji nya’gɨ kɨ rɔta’tɨ kɨ ar njay be dɔ’tɨ el. ");
INSERT INTO gqr_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Be ə, Pol manjɨ ta dɔ’ne’tɨ ene: «M’ra nya madɨ kɨ majel kɨ ndukun lə Juwipɨ’gɨ el num, kɨ Kəy lə Luwə el num, taa m’ɔsɨ’n ta Sejar el num tɔ.» ");
INSERT INTO gqr_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Pəsitusɨ kɨ ndigɨ ra nya kɨ nəl Juwipɨ’gɨ, el Pol ene: «In ndigɨ kadɨ aw Jerujalem’tɨ kadɨ gangɨ ta dɔ’i’tɨ dɔ ta’tɨ kin takum’tɨ wa?» ");
INSERT INTO gqr_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Ə Pol ene: «Jagɨ, in non lo gangɨ ta’tɨ lə nje konɓe kɨ bo Sejar ə m’ra’tɨ, ə in lo kɨ a gangi ta dɔ’m’tɨ səm’tɨ. Tokɨ inɓe gərɨ’n majɨ, nya madɨ kare kɨ low’ə’tɨ el kɨ m’ra kɨ Juwipɨ’gɨ goto. ");
INSERT INTO gqr_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Kin ə re m’ra nya kɨ dana el eke m’tɔl nya kɨ asɨ koy’m, ə m’a mbətɨ koy el. Nan re ta’gɨ kɨ indəi dɔ’m’tɨ in ta’gɨ kɨ rɔta’tɨ el ə, de kɨ a ingə tarow kadɨ ulə’m ji’de’tɨ goto. M’dəjɨ kadɨ m’oo Sejar.» ");
INSERT INTO gqr_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Lo kin’tɨ, Pəsitusɨ elinan ta kɨ njekɔjɨ ta’gɨ lə’ne, ə go’tɨ el Pol ene: «Dəjɨ kadɨ oo Sejar ə, a aw non Sejar’tɨ». ");
INSERT INTO gqr_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Asɨ ndɔ’gɨ go’tɨ, ngar Agiripa in kɨ konann’ne Berenisɨ rei Sejare’tɨ tadɔ kuwə ji Pəsitusɨ. ");
INSERT INTO gqr_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Rai ndɔ’gɨ asɨ ta’tɨ rɔ’a’tɨ non, adɨ Pəsitusɨ ində taa lə Pol non ngar Agiripa’tɨ el’ə ene: «Pelisɨ inyə dingəm madɨ dangay’tɨ non. ");
INSERT INTO gqr_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Adɨ lokɨ m’aw Jerujalem’tɨ, kibo’gɨ lə njekujənyamosɨ kadikare’gɨ, kɨ ngatɔgɨ’gɨ lə Juwipɨ’gɨ rei səki’ə rɔ’m’tɨ, ə dəji’m’in kadɨ m’gangɨ ta koy dɔ’a’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Ə m’el’de tokɨ row ra’a lə de’gɨ kɨ Rɔm’tɨ in be el. De kɨ Rɔm’tɨ a ulə’de ji nje sək’ə’gɨ’tɨ kɨ kanjɨ kadɨ de’ə ingə tarow manjɨ’n ta dɔ’ne’tɨ non nje sək’ə’gɨ’tɨ el. ");
INSERT INTO gqr_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Be ə, rei ne, ningə, m’ndigɨ kadɨ ndɔ’gɨ dər kare el, adɨ lo ti kɨ rangɨ go’tɨ par ə m’aw lo gangɨ ta’tɨ m’adɨ rei kɨ dingəm kakin. ");
INSERT INTO gqr_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","M’mər me’m’tɨ kadɨ nya madɨ kɨ ngan kɨ ra to non, nan lokɨ nje sək’ə’gɨ rei ningə, de oo lo nya madɨ kɨ ngan kɨ ra kadɨ indəi ta dɔ’a’tɨ be el. ");
INSERT INTO gqr_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","In ta kɨ manjɨ par ə manjɨ nan’tɨ se’de ɔjidɔ row ra Luwə lə’de ingɨ ɓe num, ɔjɨ dɔ de madɨ kɨ tɔ’a nan Jeju kɨ oy ə Pol ene isɨ kumngayira. ");
INSERT INTO gqr_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Ta lə’de kin, m’gər lo kujə kɨ kadɨ m’ra’tɨ el, adɨ m’dəjɨ Pol inɓe m’ene ke ndigɨ kadɨ aw Jerujalem’tɨ kadɨ in kɨ gangɨ ta kin dɔ’a’tɨ wa. ");
INSERT INTO gqr_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Nan Pol ndigɨ kadɨ nje konɓe kibo kɨ Rɔm’tɨ taa oo ta lə’ne. Be ə, m’un ndu’m kadɨ ngəmi’ə dangay’tɨ, bitɨ kadɨ to m’ulə si’ə madɨ nje konɓe kibo kɨ Rɔm’tɨ, Sejar.» ");
INSERT INTO gqr_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Agiripa el Pəsitusɨ ene: «M’ndigɨ ngayn kadɨ m’oo ta lə dingəm kin tɔ.» Ə Pesitusɨ el’ə ene: «Lo ti ə a oo ta kɨ ta’a’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Lo ti kɨ rangɨ, Agiripa in kɨ Berenisɨ rei kɨ de’gɨ ngayn go’de’tɨ, uri lo gangɨ ta’tɨ. Kibo lə njerɔ’gɨ kɨ kibo’gɨ kɨ me ɓebo’tɨ in se’de. Nga a, Pəsitusɨ un ndu’ne adɨ rei kɨ Pol. ");
INSERT INTO gqr_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Lokɨ Pol re, Pəsitusɨ un ta el ene: «In ngar Agiripa kɨ de’gɨ pətɨ kɨ sii ne, oyi de kin. In ə bulə Juwipɨ’gɨ ngayn rei səki’ə rɔ’m’tɨ, ne ge kɨ Jerujalem’tɨ ge. Lokɨ səki’ə, uni ndu’de kɨ taa eyina in de kɨ majɨ kadɨ ajɨ el. ");
INSERT INTO gqr_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Kɨ rɔ’m’tɨ, m’in m’oo nya madɨ kɨ ngan kɨ ra kɨ asɨ koy el. Ningə, tokɨ inɓe dəjɨ kadɨ n’oo nje konɓe kibo kɨ Rɔm’tɨ, m’un ndu’m kadɨ m’ad’a aw. ");
INSERT INTO gqr_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","M’gər ta inɓe kɨ kadɨ to m’ndangɨ me makitu’tɨ m’adɨ nje konɓe kibo kɨ Rɔm’tɨ ɔjidɔ ta li’ə kin el. In be ə, m’adɨ re non’se’tɨ ne, kibo utə, m’adɨ re non’i’tɨ in ngar Agiripa kadɨ to go ta’tɨ kɨ a el’je ə, m’ingə nya kɨ kadɨ to m’ndangɨ. ");
INSERT INTO gqr_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Tadɔ m’oo kadɨ in nya kɨ gorow’ə’tɨ el kadɨ m’ulə kɨ dangay Rɔm’tɨ, kanjɨ kelta kɨ de’gɨ indəi dɔ’a’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Agiripa el Pol ene: «Tarow in lə’i kadɨ manjɨ’n ta dɔ rɔ’i’tɨ.» Lo kin’tɨ, Pol un ji’ne kɨ taa, ningə ta kɨ el dɔ rɔ’ne’tɨ ə to kin: ");
INSERT INTO gqr_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","«Ngar Agiripa, rɔ’m nəl’m ngayn kadɨ m’ingə tarow ɓone, m’el’n ta dɔ rɔ’m’tɨ ɔjɨ’n dɔ ta’gɨ pətɨ kɨ Juwipɨ’gɨ indəi dɔ’m’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","M’el be tadɔ in gər nyajibəlɓe’gɨ lə Juwipɨ’gɨ kɨ ta kɨ manjɨ’gɨ lə’de pətɨ kin majɨ. Ningə, m’dəj’i kadɨ ilə me’i nanga pon, kadɨ oo’n ta kɨ m’a m’el’i kin majɨ. ");
INSERT INTO gqr_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Juwipɨ’gɨ pətɨ gəri nya ra’m’gɨ, tumginn’ə basa’m’tɨ nu. Gəri majɨ tadɔ m’tɔgɨ dann de’gɨ’tɨ lə’m, Jerujalem’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Gəri m’in mayinu. Ningə re ndigɨ ə, asi kadɨ a manyinaj’a. Manyinajɨ tokɨ m’təl rɔ’m gorow ra’a’tɨ lə Parisɨ’gɨ, kɨ in kutɨ kɨ ngan ngayn dann kutɨ’gɨ’tɨ kɨ njera ta lə Luwə lə’je. ");
INSERT INTO gqr_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Ningə kɨ ngɔsine kin, rei sə’m lo gangɨ ta’tɨ, tadɔ m’ində me’m majɨ dɔ nya’tɨ kɨ Luwə un ndu’ne adɨ kaw’je’gɨ kadɨ n’ra n’adɨ’de. ");
INSERT INTO gqr_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Ginn kojɨ lə’je kɨ dɔgɨ gidə in joo, indəi me’de’tɨ kadɨ kunndu kin a tɔlta’ne. Be ə, rai kulə lə Luwə kɨ tɔgɨ’de kondɔ’tɨ kɨ kada. Ningə in tadɔ kindəmedɔtɨ kin ə Juwipɨ’gɨ indəi taa dɔ’m’tɨ, ngar! ");
INSERT INTO gqr_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Ra bann be ə in Juwipɨ’gɨ oyi kadɨ in ta kɨ rɔta’tɨ el kadɨ Luwə a tɔsɨ njekoy’gɨ ndəl lo koy’tɨ wa? ");
INSERT INTO gqr_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","«M’inɓe kɨ dɔ’m, kete m’oo kadɨ in go’tɨ ngayn, kadɨ m’rɔ kɨ tɔgɨ’m, kɨ row kɨ dangɨ dangɨ kadɨ de ɓar tɔ Jeju kɨ Najaretɨ’tɨ kin el. ");
INSERT INTO gqr_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Ningə in kin ə in kuləra’m kɨ m’ra Jerujalem’tɨ. Be ə, kɨ tɔgɨ kɨ m’ingə kɨ rɔ kibo’gɨ lə njekujənyamosɨ kadikare’gɨ, m’ɓukɨ’n njekunme’gɨ ngayn dangay’tɨ. Nga ningə lokɨ gangɨ ta koy dɔ’de’tɨ ə, m’ndigɨ dɔ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Taa taa, m’aw kɨ lo kəykawnan’gɨ’tɨ lə Juwipɨ’gɨ pətɨ, m’adɨ’de kon. Ningə m’ində tɔgɨ dɔ’de’tɨ kadɨ manji ta gər Kirisitɨ. Me’m tingə’m ngayn dɔ’de’tɨ, adɨ m’aw bitɨ go’de’tɨ, kɨ dɔ ɓe’gɨ kɨ rangɨ, m’adɨ’de kon. ");
INSERT INTO gqr_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","In go’ə’tɨ kin ə, m’ində’n m’njɨ m’aw Damasɨ’tɨ kadɨ m’uwə’de. Kibo’gɨ lə njekujənyamosɨ kadikare’gɨ adi’m’in tɔgɨ’gɨ, adi’m’in ndu’de’gɨ, kadɨ m’ra’n kulə kin. ");
INSERT INTO gqr_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Ngar, lokɨ m’in dɔ row’tɨ, kɨ kadɨ kɨ jam dɔ ɓe’tɨ, m’oo kunjɨ madɨ kɨ unjɨ utə kadɨ in dɔran’tɨ re gugɨ dɔ’m kɨ nje kɨ go’m’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Jɨ te j’osɨ nanga, ningə, m’oo ndu’de madɨ el’m ta kɨ ndonn ta Ebirə ene: “Sol, Sol, tadɔ ri ə isɨ adɨ’m kon be wa?” Tadɔ ri ə uwə rɔ’i ngan to mangɨ kɨ uwə rɔ’ne ngan ta kində’tɨ lə ɓe’ne be wa? In nya kɨ pasira kare! ");
INSERT INTO gqr_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Lo kin’tɨ m’dəj’ə m’ene: “In nan Burəɓe?” Ningə, Burəɓe el’m ene: “In m’in Jeju kɨ isɨ adɨ’m kon.” ");
INSERT INTO gqr_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Ningə ində ra taa dɔ nja’i’tɨ. Nya kɨ m’te m’ingə’i ə to kin: M’mbəti kadɨ təl njekuləɓər lə’m, ningə kadɨ mannajɨ dɔ koo’tɨ kɨ oo’m kin ge, dɔ koo’tɨ kɨ a oo’m ɓay kin ge. ");
INSERT INTO gqr_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","M’a m’taa’i m’iləi taa ji Juwipɨ’gɨ’tɨ kɨ ji ndəgɨ de’gɨ’tɨ kɨ m’a m’uləi kɨ rɔ’de’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Tadɔ kadɨ te kum’de, ɔr’de lo kɨ ndul’tɨ, te se’de lo kunjɨ’tɨ. Kadɨ ɔr’de konɓe’tɨ lə Satan, re se’de Konɓe’tɨ lə Luwə, kadɨ Luwə inyə go majel’gɨ lə’de kɔ, kadɨ ingəi lo mbunə de’gɨ’tɨ kɨ Luwə ində taa dangɨ me kunme kadɨ Jeju’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Lo kin’tɨ, Ngar Agiripa, m’tanrɔ nya k’oo me ndil’tɨ kɨ in dɔran’tɨ kin el. ");
INSERT INTO gqr_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","M’iləmbər kunme kadɨ Kirisitɨ, kɨ mbər k’inyə go nya ra’gɨ kɨ majel kɔ. M’iləmbər kin kɨ rɔ de’gɨ’tɨ kɨ Damasɨ, kɨ rɔ de’gɨ’tɨ kɨ Jerujalem, kɨ rɔ de’gɨ’tɨ kɨ dɔnangɨ Jude’tɨ ba pətɨ, kɨ kɨ rɔ de’gɨ’tɨ kɨ in Juwipɨ’gɨ el. Ningə m’dəjɨ’de kadɨ kulə ra’de tɔjɨ tokɨ rɔta’tɨ, inyəi gorow njiyə’de kɨ majel kɔ ə təli kɨ rɔ Luwə’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","In tadɔ kin ə, Juwipɨ’gɨ uwəi m’in natɨ Kəy’tɨ lə Luwə kadɨ n’tɔli’m’in. ");
INSERT INTO gqr_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Nan Luwə dow bagɨ’ne dɔ’m’tɨ bitɨ ɓone, adɨ m’ra kɨ dɔ’m taa, m’njɨ mannajɨ kɨ dɔ’m’tɨ non de’gɨ’tɨ kɨ boi kɨ non de’gɨ’tɨ kɨ du. M’iləmbər nya kɨ rangɨ el, nan in mbər nya kɨ de’gɨ kɨ njekeltakita Luwə’tɨ kɨ Mojɨ ge elita’a. ");
INSERT INTO gqr_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Eli tokɨ Kirisitɨ kɨ in De kɨ Luwə mbət’ə a ingə kon, a in de kɨ dɔkete kɨ a ində taa dann njekoy’gɨ’tɨ tɔ. Ningə a ində taa kadɨ iləmbər kunjɨ kajɨ kɨ rɔ Juwipɨ’gɨ’tɨ kɨ kɨ rɔ de’gɨ’tɨ kɨ in Juwipɨ’gɨ el.» ");
INSERT INTO gqr_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Pol ra mannajɨ kɨ dɔ’ne’tɨ ba ɓay ningə, Pəsitusɨ un ndu’ne kɨ taa el’ə ene: «Pol, dɔ’i majel! Nyagər lə’i kɨ ngayn tujɨ dɔ’i wa.» ");
INSERT INTO gqr_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Nan Pol təl el’ə ene: «Kibo Pəsitusɨ, dɔ’m majel el, ta’gɨ kɨ m’el, in ta kɨ rɔta’tɨ, kɨ kum’ə to. ");
INSERT INTO gqr_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Ngar Agiripa gər ginn nya’gɨ kin majɨ, adɨ asɨ kadɨ m’tinyi rɔ’m katɨ m’el’ə ta. M’gər kadɨ nya kɨ dum’ə goto, tadɔ in nya’gɨ kɨ rai nya lo kiyə’tɨ el. ");
INSERT INTO gqr_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Ngar Agiripa, un me’i dɔ ta’gɨ’tɨ kɨ de’gɨ kɨ njekeltakita Luwə’tɨ elita’a kin eke un el wa? M’gər kadɨ m’un me’m m’adɨ dɔ ta’gɨ’tɨ kin.» ");
INSERT INTO gqr_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Ningə Ngar Agiripa el Pol ene: «Nanyi ngayn el par ə a yətɨ hangal’m kadɨ m’təl njekun go Kirisitɨ ə ra am!» ");
INSERT INTO gqr_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Pol ilə’tɨ ene: «Re in kɨ ngɔsine’tɨ, eke kɨ bitɨ ɓay ta kaa, m’dəjɨ Luwə kadɨ ra be. Ningə kadɨ in kɨ kar’i par el, nan kadɨ in kɨ de’gɨ pətɨ kɨ isɨ oyi ndu’m ne kin, təli toi to m’in be tɔ. K’in ə kadɨ rai me dangay’tɨ kin el.» ");
INSERT INTO gqr_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Lo kin’tɨ, Ngar Agiripa ge kɨ nje konɓe kɨ dɔnangɨ’tɨ kɨ non kin ge, Berenisɨ ge, kɨ ndəgɨ de’gɨ pətɨ kɨ in se’de, ɔri rɔ’de gogɨ. ");
INSERT INTO gqr_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Lokɨ isɨ ɔri rɔ’de gogɨ, eli nan dann’de’tɨ eyina: «Dingəm kin ra nya madɨ kare kɨ asɨ kadɨ de tɔl’ɔ’n’ə eke uwə’n’ə dangay’tɨ el.» ");
INSERT INTO gqr_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Ə ngar Agiripa el Pəsitusɨ ene: «Dingəm kin, in dəjɨ kɨ dəjɨ kadɨ n’aw non Sejar’tɨ kin el ə asɨ kadɨ inyə taa.» ");
INSERT INTO gqr_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Lokɨ uni ndu’de kadɨ j’aw kɨ tokibo Itali’tɨ, inyəi Pol kɨ ndəgɨ dangay’gɨ kɨ rangɨ ji njekundɔ kutɨ njerɔ’gɨ kɨ ɓu, me kutɨ’tɨ lə Ogusitɨ, kɨ ɓari’ə nan Juliyusɨ kadɨ ngəm’de. ");
INSERT INTO gqr_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","J’in me to’tɨ kɨ Adirami’tɨ, kɨ a un row kɨ aw ngangɨ lo kɨ Aji’tɨ kɨ du. Lokɨ j’ɔti j’isi j’aw, Arisitarkɨ kɨ Tesalonikɨ kɨ dɔnangɨ Maseduwann’tɨ in se’je nan’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Lo ti go’tɨ, jɨ re jɨ te Sidon. Lo kin’tɨ non, Juliyusɨ kɨ ində kum’ne go Pol’tɨ majɨ ngayn, inyə tarow ad’a kadɨ aw rɔ madɨ’ne’gɨ’tɨ kadɨ rai si’ə. ");
INSERT INTO gqr_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Go’tɨ, j’in j’ilə dɔ’je, j’un kadɨ dor kɨ ɓari’ə nan Sipir. Jɨ təl be, tadɔ nəl ɔsɨ’je kɨ gogɨ gogɨ. ");
INSERT INTO gqr_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","J’awi j’ində babo ndəkba kadɨ Silisi’tɨ in kɨ Pampili gangɨ. J’awi jɨ te Mira, dɔnangɨ’tɨ kɨ Lisi. ");
INSERT INTO gqr_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Lo kin’tɨ, njekundɔ kutɨ njerɔ’gɨ kɨ ɓu, ingə tokibo kɨ Alegijandiri’tɨ, kɨ isɨ aw Itali’tɨ, ə adɨ j’in me’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Jɨ ra ndɔ ngayn dɔ ba’tɨ. Tokibo anyi ngodɨ nden nden ba be, ningə j’ingə kon ngayn ɓay taa jɨ te ɓebo’tɨ kɨ Nidɨ. Nəl ɔgɨ’je kaw kɨ kete, adɨ jɨ te kɨ row kɨ ginn dor’tɨ kɨ Kiretɨ, kaw kɨ kadɨ Salmone’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Lo kɔtɨ kete in lo tɔl nan. J’ɔtɨ nden nden j’ində kadɨ lo bitɨ taa jɨ re jɨ te lo’tɨ madɨ kɨ ɓari’ə nan ta ba kɨ Majɨ, ndəkba kadɨ ɓebo’tɨ kɨ ɓari’ə nan Lase. ");
INSERT INTO gqr_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Kagilo dər ngayn dɔ’je’tɨ. Dɔkagilo kɔgɨ rɔ nyakusɔ kɨ nanyi kul’tɨ kaa dər tɔ, adɨ kaw kɨ kete lə tokibo kaa təl re ngan kɨ asɨ koy ɓay tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","In tadɔ kin ə, Pol ndəjɨ’de ene: «Kaman’gɨ, m’oo kadɨ kin ə re jɨ ndigɨ kadɨ j’uni ta mbah lə’je kɨ kete ə, in mbah kɨ nya’gɨ a tuji’tɨ. Ningə in to kɨ nya’gɨ kɨ me’tɨ par ə a tuji el, darɔ’je’gɨ inɓe ka a tujɨ tɔ.» ");
INSERT INTO gqr_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Nan kibo lə kutɨ njerɔ’gɨ kɨ ɓu oo ta lə Pol el, nan oo ta lə njekuwə ngandɨ to in kɨ ɓe nje to yo. ");
INSERT INTO gqr_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Ta ba kin majɨ kadɨ de isɨ səm’tɨ dɔkagilo kul’tɨ el, adɨ de’gɨ ngayn ndigɨ kadɨ n’awi to re to bann wa ningə n’tei Penisɨ, kɨ ra dɔ dor’tɨ kɨ Kiretɨ. Ta ba kin tu rɔ’ne kɨ lo kurkadɨ’tɨ, in holo bitɨ kɨ manga. In ə kadɨ n’isi’tɨ kadɨ to kagilo kul gangɨ dɔ’de’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Lo kin’tɨ, ngonn nəl madɨ ulə, in kɨ holo be re, adɨ oyi kadɨ ndigɨ ra lə’de a tɔlta’ne majɨ. Be ə, indəi taa tuti tokibo, ə iləi dɔ’de kɨ kadɨ dor’tɨ kɨ Kiretɨ ndəkba isɨ awi. ");
INSERT INTO gqr_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Nan nden ba go’tɨ par ə, nəl kibo madɨ kɨ ɓari’ə nan Erakilon in kɨ dɔ dor’tɨ, re osɨ dɔ’de’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Nəl un to dɔ’ne’tɨ. Lo kuwə tokibo nanga ta’a’tɨ goto, j’inyə rɔ’je kɨ ji’ə’tɨ adɨ aw se’je kɨ non par. ");
INSERT INTO gqr_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","J’awi jɨ te holo lə dor’tɨ, kɨ ɓari’ə nan Koda. Lo kakin taa nəl dɔ’je’tɨ, adɨ j’ingə tarow j’ində’n ji’je dɔ ngonn tokibo’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Lokɨ nje ra kulə me tokibo’tɨ uni’ə indəi’ə me tokibo’tɨ ə, doloi tokibo kakin kɨ kulə ɓindɨ ɓindɨ. Jɨ ɓol kadɨ j’aw j’ɔsɨ dɔ’je nangira’tɨ kɨ Sirtɨ, adɨ uni gindɨ ngɔ kɨ dɔi tokibo’tɨ iləi’ə dɔ mann’tɨ, go tokibo’tɨ. In be ə, nəl aw se’je kɨ non. ");
INSERT INTO gqr_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Nəl rɔ se’je kɨ tɔgɨ’ne ngayn, adɨ lo ti dɔ’tɨ, dum dɔ’de ə, ɓuki nya’gɨ madɨ kɨ me to’tɨ kɔ. ");
INSERT INTO gqr_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Ndɔ kɨ nja mutə go’tɨ, ɔyi nya kɨ rɔ to’tɨ kɨ ji’de ɓuki’de kɔ. ");
INSERT INTO gqr_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Ndɔ ngayn, j’asɨ kadɨ j’oo kadɨ el num, j’asi kadɨ j’oo mee’gɨ el num. Nəl nanyi kɨ lo kulə’tɨ kɨ tɔgɨ’ne, adɨ de kɨ ində me’ne dɔ te’tɨ goto. ");
INSERT INTO gqr_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","J’usɔ nya el kagilo ngayn, ə Pol in ra taa dann de’gɨ’tɨ, el’de ene: «Kaman’gɨ, kin ə re oyi ta lə’m ə j’isɨ Kiretɨ’tɨ ba ə, nya’gɨ a tujɨ ge, a nanyi kɔ ge be el. ");
INSERT INTO gqr_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Ningə kɨ ngɔsine kin, m’ulə dingəm me’se’tɨ kadɨ uwəi tɔgɨ’se ba, tadɔ de kɨ a tujɨ dann’se’tɨ goto. Nya kɨ a tujɨ, in tokibo kɨ ginn’je’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Luwə lə’m kɨ m’njɨ m’ra kulə li’ə kin, malayka li’ə kare te bus kɨ rɔ’m’tɨ kondɔ’tɨ ne el’m ene: ");
INSERT INTO gqr_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","“Pol, in ɓol nya madɨ el. In ɓol el tadɔ, majɨ kadɨ a ra non Sejar’tɨ. Ningə Luwə a ajɨ de’gɨ pətɨ kɨ in me tokibo’tɨ adi.” ");
INSERT INTO gqr_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","In be ə ngannkon’m’gɨ, m’dəjɨ’se kadɨ iləi me’se nanga. M’un me’m m’adɨ Luwə lə’m kadɨ a te se’je tokɨ el’n. ");
INSERT INTO gqr_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Nan j’a jɨ tɔli ta’je majel dɔ dor’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","J’in me kondɔ’tɨ kɨ nja dɔgɨ gidə in sɔ, nəl un’je aw se’je kɨ dɔ babo’tɨ kɨ ɓari’ə Adiriyatikɨ. Lokɨ jɨ te dann lo’tɨ, nje ra kulə me to’tɨ oyi kadɨ j’in ndəkba kɨ dɔnangɨ. ");
INSERT INTO gqr_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Lokɨ iləi nya kɨ kadɨ de gər’n kow mann ningə, ɔdi nangɨ asɨ tatɨ ji’de dɔ joo. Lokɨ awi kɨ kete sanyi nden ningə, iləi ɓay ə, ɔdi nangɨ asɨ lo tatɨ ji de dɔgɨ gidə in mi. ");
INSERT INTO gqr_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Ɓoli kadɨ j’aw j’ɔsɨ rɔ’je mbal madɨ’tɨ, adɨ ɓukɨ gindɨ kɨ dɔi tokibo sɔ kɔ, ə isɨ nginəi ɗele kadɨ lo ti kalangɨ. ");
INSERT INTO gqr_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Nje ra kulə me tokibo’gɨ’tɨ sangi row k’inyə tokibo kadɨ nanyinan, adɨ uni ngonn to indəi dɔ ba’tɨ ningə, uni girə eyina n’ra n’awi kadɨ n’dɔi go kulə gindɨ kɨ dɔi non to’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Nan Pol el njekundɔ kutɨ njerɔ’gɨ kɨ ɓu num, njerɔ’gɨ inɓe num ene: «Kin ə de’gɨ kin sii se’je me tokibo’tɨ ba el ə, de kare kaa a te dann’je’tɨ el.» ");
INSERT INTO gqr_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Be ə, njerɔ’gɨ gangi kulə ngonn to’tɨ kakin ə inyəi’ə adɨ aw. ");
INSERT INTO gqr_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Kete ɓay taa kadɨ lo ti, Pol ulə dingəm me de’gɨ’tɨ pətɨ ene: «Oyi, ndɔ dɔgɨ gidə in sɔ ɓone kɨ isɨ ngəmi, kɨ kanjɨ kadɨ sɔi nya. ");
INSERT INTO gqr_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Ningə kɨ ngɔsine kin, m’dəjɨ’se kadɨ uni nya sɔi, tadɔ in kin ə a ra sese kadɨ to tei kajɨ’tɨ. M’el’se tokɨ ngonn bisɨ dɔ’de kare dann’se’tɨ a osɨ kɔ el.» ");
INSERT INTO gqr_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Lokɨ Pol el’de ta ba ningə, un mapa ra oyo Luwə dɔ’tɨ takum de’gɨ’tɨ pətɨ ə sɔ. ");
INSERT INTO gqr_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Lo kin’tɨ non nga a, de’gɨ pətɨ uwəi rɔ’de ngan sɔi nya. ");
INSERT INTO gqr_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","De’gɨ pətɨ in ɓu joo kɨ dɔ siri gidə in mehen me tokibo’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Lokɨ sɔi nya ndanni majɨ ə, ɓuki ndəgɨ geme kɔ kadɨ to ɔlɔ kel. ");
INSERT INTO gqr_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Lokɨ lo ti, njekuwə ngandɨ to’gɨ gəri lo el. Nan nya kɨ oyi in ngangɨ ba kɨ aw tɔlta’ne dɔ nangira’tɨ par. Ə uni ndu’de kadɨ n’rai nden nden to re to bann ə n’awi kɨ to səm’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Ningə tuti gindɨ’gɨ kɨ dɔi tokibo’tɨ, ɓuki ba, ə rai dɔ’tɨ non tuti kulə kɨ dɔi nya ləl tokibo’gɨ tɔ. Go’tɨ, ɔyi ku kɨ nje kuwə nəl taa. Ɔyi taa kadɨ to nəl sur tokibo aw si’ə, kɨ dɔ’de nangira’tɨ kakin. ");
INSERT INTO gqr_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Lokɨ isɨ awi ə, ɔsi tokibo adɨ duw nangira’tɨ kɨ tɔgɨ mann kɨ in yo ge ne ge re ɔsi nan adɨ ra. Non tokibo duw nangira’tɨ tɔti tɔti adɨ lo kadɨ ɔtɨ kete goto. Ningə go’ə kɨ gogɨ, mann re kɨ tɔgɨ’ne ində tujɨ’n tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Njerɔ’gɨ uni ndu’de asɨ nan kadɨ to n’tɔli dangay’gɨ nan to kɨ madɨ’gɨ dann’de’tɨ indəi ur me mann’tɨ anyinan awi. ");
INSERT INTO gqr_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Nan njekundɔ kutɨ njerɔ’gɨ kɨ ɓu ndigɨ kajɨ Pol, adɨ ɔgɨ’de dɔ kadɨ rai kɔjitara lə’de. Adɨ ndu’ne kadɨ de’gɨ kɨ gəri kala mann tosi me mann’tɨ kete, awi kɨ dɔ nangira’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Ningə kadɨ ndəgə’gɨ sii dɔ kagɨ’gɨ’tɨ, dɔ nusɨ tokibo’gɨ’tɨ, uni go’de. In be ə, de’gɨ pətɨ awi tei dɔ nangira’tɨ kɨ kanjɨ kadɨ nya madɨ ra’de. ");
INSERT INTO gqr_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Go te kɨ jɨ te ta koy’tɨ nga a j’oo kadɨ tɔ dor kɨ j’in’tɨ kakin nan Maltɨ. ");
INSERT INTO gqr_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","De’gɨ kɨ sii dɔ dor’tɨ kakin uwəi’je kɨ rɔ’de’tɨ kɨ rɔnel kɨ de oo gara nja kare el. Rai por kɨ bo ngayn adɨ jɨ ra ta’tɨ pətɨ, tadɔ ndi ədɨ adɨ kul on ngayn. ");
INSERT INTO gqr_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Pol sangɨ ngəngirə kadɨ n’ɓukɨ por’o ə, por ra adɨ lii pir te’tɨ dolo ji’ə’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Lokɨ de’gɨ kɨ me ɓe’tɨ oy lii nan ji Pol’tɨ ningə, eli nan dann’de’tɨ eyina: «Kɨ rɔta’tɨ, dingəm kin in nje tɔl de’gɨ. Be ə, te ta mann’tɨ ajɨ kaa, ta kɨ gangɨ lə Luwə ndigɨ kadɨ ra kɨ dɔ’ne taa el.» ");
INSERT INTO gqr_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Nan Pol siyə lii ilə me por’tɨ, ə ngonn rɔ’a kɨ nden kaa to’ə el. ");
INSERT INTO gqr_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","De’gɨ pətɨ nginəi kadɨ rɔ Pol ti eke osɨ watɨ oy wa be. Nan lokɨ nginəi pi nya madɨ ra’a el, eli eyina: «De kam in luwə.» ");
INSERT INTO gqr_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Lo lə kibo kɨ dɔ dor’tɨ kakin, kɨ tɔ’a nan Pibilusɨ, to kadɨ lo’tɨ non ndəkba. Ə Pibilusɨ uwə’je kɨ rɔ’ne’tɨ majɨ ngayn, adɨ’je kəy jɨ to’tɨ ndɔ mutə. ");
INSERT INTO gqr_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Ningə baw Pibilusɨ to monyi nanga: rɔ’a tingə ge, ndəngɨ mosɨ ge. Ə Pol ində taa aw ində ji’ne dɔ’a’tɨ adɨ ingə lapiya. ");
INSERT INTO gqr_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Go’tɨ, ndəgɨ njemonyi’gɨ kɨ me ɓe’tɨ rei ingəi Pol adɨ adɨ’de lapiya tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","De’gɨ ɔsi kurə’je non be. Nga ningə, lokɨ kagilo asɨ kadɨ j’awi nga a, adɨ’je nya’gɨ kɨ j’aw ndoo’de kadɨ rai se’je dɔ row mbah’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Jɨ ra nanyi mutə non be ɓay taa kadɨ j’ilə dɔ’je kɨ tokibo kɨ in Alegijandiri’tɨ kɨ ɓari’ə nan Kasitɔr num, Polusɨ num. Tokibo kin, kagilo kul dər dɔ’a’tɨ me ɓe’tɨ kin. ");
INSERT INTO gqr_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Lokɨ j’aw jɨ te Sirakusɨ, j’isɨ’tɨ non ndɔ mutə. ");
INSERT INTO gqr_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Lo kin’tɨ non, j’in j’un kadɨ ba, j’aw jɨ te Rejiyo. Lo ti go’tɨ, nəl kɨ in holo tumginn kulə, ə jɨ ra ndɔ joo ə jɨ te Pujol. ");
INSERT INTO gqr_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Me ɓe’tɨ kin ə j’ingə ngannkon’je’gɨ kɨ dəji’je adɨ jɨ ra ndɔ siri se’de ɓay taa j’aw. In be ə j’aw’n kɨ nja’je kadɨ jɨ te’n Rɔm’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Ngannkon’je’gɨ kɨ Rɔm’tɨ kɨ oyi poy’je, rei tiləi kum’je bitɨ lo sukɨ’tɨ kɨ Apiyusɨ kɨ lo kəy kusɔ nya’gɨ kɨ mutə. Lokɨ Pol oo’de, ra oyo Luwə, ə təl ingə tɔgɨ. ");
INSERT INTO gqr_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Go te’je Rɔm’tɨ, adi tarow Pol kadɨ isɨ lo lə’ne kɨ njerɔ kare kɨ kadɨ ində kum’ne go’ə’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Ndɔ mutə go’tɨ, Pol ɓar kibo’gɨ lə Juwipɨ’gɨ kadɨ rei ingəi’ə. Lokɨ kawinan, Pol el’de ene: «Ngannkon’m’gɨ, m’ra nya madɨ m’ɔsɨ’n ta de’gɨ lə’je el num, m’ɔsɨ’n ta nya jibəlɓe lə kaw’je’gɨ el num tɔ. Nan Juwipɨ’gɨ uwəi m’in Jerujalem’tɨ iləi m’in dangay’tɨ ji de’gɨ kɨ Rɔm’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Go ta’tɨ kɨ de’gɨ kɨ Rɔm’tɨ dəji m’in, ingəi nya madɨ kɨ asɨ kadɨ de gangɨ’n ta koy dɔ’m’tɨ el, adɨ ndigɨ kadɨ inyəi m’in. ");
INSERT INTO gqr_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Nan Juwipɨ’gɨ ɔdi el. Lo kin’tɨ, tɔgɨ isɨ dɔ’m’tɨ kadɨ m’dəjɨ kɨ ra non Sejar’tɨ, kɨ kanjɨ kadɨ m’ində’n ta dɔ de’gɨ’tɨ lə’m. ");
INSERT INTO gqr_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","In tadɔ kin ə, m’dəjɨ kadɨ m’ingə’se, m’el’se ta. Tadɔ in nya kindəmedɔtɨ lə Isirayel ə m’to’n dangay’tɨ kin.» ");
INSERT INTO gqr_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Lo kin’tɨ, Juwipɨ’gɨ eli’ə eyina: «J’ingə makitu madɨ kɨ in Jude’tɨ kɨ elta kɨ dɔ’i’tɨ el, taa ngannkon’gɨ madɨ kɨ kadɨ rei eli’je ta’gɨ kɨ dɔ’i’tɨ eke ɓari tɔi majel ka goto tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Nan jɨ ndigɨ kadɨ el’je ta lə’i kɨ ɔjidɔ kutɨ kɨ in me’tɨ kin adɨ j’oo. Tadɔ jɨ gər kadɨ kɨ lo’gɨ pətɨ, de’gɨ ɔdi ta lə kutɨ kin el.» ");
INSERT INTO gqr_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Be ə, ɔji nan ndɔ ə rei ngayn ingəi Pol lo kis’ə’tɨ. Pol ilə’de mbər konɓe lə Luwə. Ra dɔ ndukun’tɨ lə Mojɨ kɨ de’gɨ kɨ njekeltakita Luwə’tɨ, manyinajɨ lə Jeju. Taa sangɨ kadɨ n’ɓukɨ’de go’ne’tɨ ɔjidɔ tɔ Jeju tɔ. Eli nan ta sin bitɨ lo sɔl’de. ");
INSERT INTO gqr_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","De’gɨ madɨ oyi kadɨ ta kɨ el’de in ta kɨ rɔta’tɨ, nan nje kɨ nungɨ mbeti kunme’de tɔ. ");
INSERT INTO gqr_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Lo kɨ indəi sananyinan kɨ ndu kasɨ nan el, Pol el’de ene: «Ta kɨ Ndil Luwə el baw’se’gɨ kɨ ta njekeltakita Luwə’tɨ Ejay in ta kɨ rɔta’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Ndil el’ə ene: “Aw ingə de’gɨ kam ə el’de ene: A oyi ta kɨ mbi’se, nan a in gəri me’ə el; A gonyi lo kɨ kum’se, nan a oyi lo el. ");
INSERT INTO gqr_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Tadɔ ngar me’de ngirə ngororo. Boyi mbi’de’gɨ, ndəmi kum’de’gɨ, Tadɔ kadɨ kum’de oo lo el num, mbi’de oo ta el num. Tadɔ kadɨ n’gəri nya kare el, nan to n’in n’təli rɔ’de go’m’tɨ adɨ m’ajɨ’de.”» ");
INSERT INTO gqr_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Pol təl ilə’tɨ ɓay ene: «Kadɨ in gəri tokɨ, ta kajɨ lə Luwə kin, ulə’n adɨ de’gɨ kɨ in Juwipɨ’gɨ el. Ningə ingɨ a uri mbi’de kadɨ oyi.» ");
INSERT INTO gqr_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Lokɨ Pol elta kin ningə, Juwipɨ’gɨ indəi taa, ai kɨ ta kɨ manjɨ nan dann’de’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Pol ra ɓal joo asɨ nan me kəy’tɨ kɨ uwə nanyi’tɨ. Ningə de’gɨ pətɨ kɨ rei rɔ’a’tɨ, uwə’de kɨ rɔ’ne’tɨ. ");
INSERT INTO gqr_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Pol iləmbər Konɓe lə Luwə num, ndo de’gɨ ta kɨ dɔ Burəɓe Jeju Kirisitɨ’tɨ kɨ me kɨ kare kɨ kanjɨ kadɨ nya madɨ ɔg’ɔ dɔ num.");
INSERT INTO gqr_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","M’in Pol kɨ njekuləɓər lə Jeju Kirisitɨ ə m’ndangɨ ta kin m’adɨ’se. M’in kɨ Luwə ɓarɨ’m to njekawkulə, ində’m ta dangɨ kadɨ m’iləmbər Poyta kɨ majɨ li’ə. ");
INSERT INTO gqr_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Poyta kɨ majɨ kɨ Luwə un ndu’ne kɨ de’gɨ kɨ njekeltakita’a’tɨ kete, adɨ eli ta’a me Makitu’tɨ li’ə kɨ ar njay. ");
INSERT INTO gqr_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","In Poyta kɨ majɨ kɨ ɔjidɔ Ngonn’o kɨ oji’ə ginn kaw’tɨ lə ngar Dabidɨ. ");
INSERT INTO gqr_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Adɨ in Burəɓe lə’je Jeju Kirisitɨ kɨ Luwə un dɔ’a taa adɨ in Ngonn’o, kɨ tɔgɨ lə Ndil Luwə, lokɨ ində’n taa dann njekoy’gɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","In kɨ takul Jeju Kirisitɨ ə, Luwə ra’n sə’m majɨ adɨ m’təl’n njekawkulə li’ə kadɨ de’gɨ pətɨ kɨ dɔnangɨ’tɨ ne, uni me’de, təli rɔ’de go ta’tɨ li’ə kadɨ tɔ’a ɓar. ");
INSERT INTO gqr_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Ingɨ kaa in mbunə de’gɨ’tɨ kin tɔ. In de’gɨ kɨ Luwə ɓar’se kadɨ in de’gɨ lə Jeju Kirisitɨ. ");
INSERT INTO gqr_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Ingɨ pətɨ kɨ sii Rɔm’tɨ, kɨ Luwə ndigɨ’se ə ɓar’se to de’gɨ lə’ne, kadɨ majɨ kɨ kisimajɨ lə Luwə kɨ Baw’je in kɨ Burəɓe lə’je Jeju Kirisitɨ in sese nan’tɨ. ");
INSERT INTO gqr_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Nya kɨ dɔkete, m’ra oyo Luwə lə’m me tɔ Jeju Kirisitɨ’tɨ tadɔ lə’se pətɨ. Tadɔ de’gɨ elita kɨ dɔ kunme’tɨ lə’se kɨ dɔ dɔnangɨ ba pətɨ. ");
INSERT INTO gqr_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Luwə kɨ m’njɨ m’ra kulə li’ə kɨ me kɨ kare, kɨ gorow kiləmbər Poyta kɨ majɨ lə Ngonn’o, asɨ kadɨ a mannajɨ lə’m tokɨ m’njɨ m’elta lə’se kɨ dɔkagilo’gɨ pətɨ. ");
INSERT INTO gqr_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Ningə m’njɨ m’dəj’ə kɨ ndɔ’gɨ pətɨ, kadɨ re in ndigɨ li’ə ə, kadɨ adɨ’m tarow adɨ m’aw’n rɔ’se’tɨ. ");
INSERT INTO gqr_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","M’ndigɨ ngayn kadɨ m’aw m’oo’se, m’adɨ’se kadikare lə Ndil Luwə kɨ kadɨ ra sese adɨ nganyi me kunme’tɨ lə’se. ");
INSERT INTO gqr_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Taa, kisi’je nan’tɨ, kadɨ kunme kɨ kare kɨ j’awi kin, a ra adɨ j’uləi dingəm me nan’tɨ yo kɨ ne. ");
INSERT INTO gqr_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Ngannkon’m’gɨ kɨ dene kɨ kɨ dingəm, m’ndigɨ kadɨ in gəri tokɨ, m’sangɨ row ngayn kadɨ m’aw rɔ’se’tɨ, nan bitɨ ɓone kaa m’ingə row el. M’ndigɨ kadɨ m’aw, adɨ m’ingə kandɨ kulə rɔ’se’tɨ tokɨ m’ingə’n rɔ ndəgɨ de’gɨ’tɨ kɨ dɔnangɨ’tɨ ne kin be tɔ. ");
INSERT INTO gqr_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Majɨ kadɨ m’ində kum go de’gɨ’tɨ pətɨ, njekumte’gɨ kɨ njekumte’gɨ el, nje nyagər’gɨ kɨ nje nyagər’gɨ el. ");
INSERT INTO gqr_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","In tadɔ kin ə, m’ndigɨ ngayn kadɨ m’aw m’ilə’se mbər Poyta kɨ majɨ, ingɨ kɨ sii Rɔm’tɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Tadɔ m’in Pol, rɔ’m sɔl’m el kadɨ m’iləmbər Poyta kɨ majɨ. Poyta kɨ majɨ kin in tɔgɨ lə Luwə kɨ kadɨ ajɨ de kɨ ra kɨ un me’ne adɨ Jeju Kirisitɨ. Kajɨ kɨ ulə ngirə’ne dɔ Juwipɨ’gɨ’tɨ kete, taa re te’n dɔ de’gɨ’tɨ kɨ in *Juwipɨ’gɨ el. ");
INSERT INTO gqr_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Kɨ rɔta’tɨ, Poyta kɨ majɨ tɔjɨ row kɨ Luwə ɔr’n ta dɔ de’gɨ’tɨ kɨ uni me’de adɨ’ə. In kɨ gorow kində me dɔ me majɨ’tɨ lə Luwə tokɨ makitu lə Luwə el’n ene: «De kɨ Luwə tudə de’tɨ lə’ne kɨ gorow kunme li’ə, a isɨ kɨ dɔ’ne taa.» ");
INSERT INTO gqr_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Luwə isɨ dɔran’tɨ taa nu, tɔjɨ wongɨ lə’ne dɔ de’gɨ’tɨ kɨ njeramajel, njera nya kɨ low’ə’tɨ el. Kulə ra’de’gɨ kɨ dana el utɨ dɔ nya kɨ rɔta’tɨ. ");
INSERT INTO gqr_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Kuləra Luwə tɔji taga wangɨ kadɨ de gər. Luwə inɓe tɔjɨ de’gɨ kulə ra’ne kɨ taga. ");
INSERT INTO gqr_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Tokɨ rɔta’tɨ, lo kulə ngirə kində nya’gɨ’tɨ nu, nya’gɨ kɨ to rɔ Luwə’tɨ, kɨ de oo’de kɨ kum’ne el, kɨ tɔgɨ kɨ to bitɨ kɨ non’tɨ, kɨ k’in ə Luwə, nya’gɨ kin toi kɨ taga me kulə ra’a’tɨ kadɨ de gər kɨ nyagər kɨ awɨ’n dɔ’ne’tɨ. Adɨ nya kɨ kadɨ me Luwə a sɔl’n dɔ de’tɨ goto. ");
INSERT INTO gqr_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","De’gɨ gəri Luwə majɨ, nan mbeti kadɨ ɔsikurə num, mbeti təl kɨ oyo kad’a num, tokɨ majɨ kadɨ rai. Mərta lə’de ur’de mu yo, nyagər lə’de goto, adɨ uləi rɔ’de me lo kɨ ndul’tɨ. ");
INSERT INTO gqr_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Oyi rɔ’de to nje gosɨ’gɨ, nan təli mbo’gɨ. ");
INSERT INTO gqr_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Kadɨ ɔsi məkəsɨ’de nanga non Luwə’tɨ kɨ nje koy el ningə, ɔsi məkəsɨ’de nanga non nya’gɨ’tɨ kɨ de’gɨ rai’de to banakum de’gɨ’tɨ kɨ ndɔ madɨ ə a gotoi, təli’de yel’gɨ’tɨ, təli’de da’gɨ’tɨ kɨ nja’de in sɔ, kɨ nje kɨ nje kagɨ nanga. ");
INSERT INTO gqr_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","In tadɔ kin ə, Luwə inyə’n de me nyara’gɨ’tɨ kɨ majel kɨ me’de ndigɨ, njenyi kɨ rɔ’de, adɨ uləi rɔsɔl dɔ darɔ’de’tɨ inɓe’gɨ. ");
INSERT INTO gqr_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Uni nya kɨ rɔta’tɨ lə Luwə mbəli nya kɨ ngom. Ningə gosi ə rai kulə adi nya’gɨ kɨ Luwə ində’de kin yo, ə inyəi Luwə kɨ nje kində nya’gɨ kɨ kɔsikurə in li’ə bitɨ kɨ non’tɨ kin. *Amen. ");
INSERT INTO gqr_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","In tadɔ kin ə, Luwə inyə’n’de me nyənn darɔ’tɨ kɨ to rɔsɔl. Ne’de’gɨ, inyəi ta sa nan lə dene kɨ dingəm kɨ gorow’ə’tɨ, ə təli nanyinan ta sanginan’tɨ kɨ gorow’ə’tɨ el. ");
INSERT INTO gqr_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Dingəm’gɨ kaa inyəi taa sangɨ ne’de’gɨ, ə nanyinan ta sanginan’tɨ dann’de inɓe’gɨ. Rai nya kɨ kɔw kɨ nan, adɨ ingəi nyakugə go kulə ra’de kɨ ur se’de mu. ");
INSERT INTO gqr_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Lokɨ mbeti kadɨ n’gəri row lə Luwə, Luwə inyə’de adɨ uni row kigo nya gərɨ’tɨ lə’de kɨ rugɨ, kɨ asɨ kadɨ ɔr’de tarow el. Lo kin’tɨ, sii ta nya ra’tɨ kɨ kadɨ de ra el. ");
INSERT INTO gqr_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Nya ra kɨ dana el rosɨ me’de, in njeramajel’gɨ, in njera kumnda nya lə de’gɨ, in nje mendul, jangɨ rosɨ me’de, in nje tɔl de’gɨ, in nje kɔl, nje kədɨ de’gɨ, nya ra’de in kɨ gorow’ə’tɨ el, in nje tətɨ ta dɔ de’gɨ’tɨ, ");
INSERT INTO gqr_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","inɓe’gɨ isɨ elita kɨ majel dɔnan’tɨ, in njeban’gɨ lə Luwə, nje ta kɨ to, nje kun dɔ’de taa, nje kɔjɨ rɔ’de, mərta lə’de pətɨ in dɔ majel’tɨ kɨ ra, in nje tanrɔ nje kojɨ’de’gɨ, ");
INSERT INTO gqr_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","nyagər lə’de goto, in de’gɨ kɨ oyi tor mindɨ’de el, in de’gɨ kɨ usɨ’de dɔ de’tɨ el, taa oyi kumtondoo lə de el tɔ. ");
INSERT INTO gqr_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Gəri ta kɨ gangɨ lə Luwə majɨ, kadɨ de’gɨ kɨ njera nya kɨ be kin, in de’gɨ kɨ asi ta koy, nan toi ta ra’a’tɨ par par. Ningə in ra’a par ə rai el, nan de’gɨ kɨ rangɨ kɨ isɨ rai kaa, ndigɨ se’de dɔ’tɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","In kɨ isɨ gangɨ ta dɔ mad’i’gɨ’tɨ, re in’n nan nan kaa, de a inyə go kɔ adi el, tadɔ isɨ gangɨ ta dɔ de’gɨ’tɨ kɨ njera nya’gɨ kɨ majel, nan kulə rai to to kulə ra’de be tɔ. Adɨ ta kɨ isɨ gangɨ kin, isɨ gangɨ ta dɔ rɔ’i’tɨ inɓe. ");
INSERT INTO gqr_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Jɨ gər majɨ, kadɨ Luwə isɨ gangɨ ta, kɨ gorow kɨ rɔta’tɨ, dɔ de’gɨ’tɨ kɨ njera nya’gɨ kɨ majel kɨ be kin. ");
INSERT INTO gqr_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Nga in kɨ isɨ gangɨ ta dɔ de’gɨ’tɨ kɨ njera nya’gɨ kɨ majel, ningə isɨ ra nya’gɨ kɨ isɨ rai kakin tɔ kin, kadɨ oo ene, in a goto me ta kɨ gangɨ’tɨ lə Luwə, el. ");
INSERT INTO gqr_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","In, isɨ kidɨ ra majɨ lə Luwə kɨ ətɨ ɓol, kɨ koreme li’ə, kɨ kisidɔtɨ li’ə num, kɨ kadɨ in gər tokɨ, ra majɨ li’ə kin isɨ ɔsi kadɨ inyə gorow njiyəi kɨ majel kɔ el. ");
INSERT INTO gqr_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Isɨ ta ra me ngan’tɨ, mbəti k’inyə row nyara kɨ majel kɔ. Lo kin’tɨ, isɨ kaw wongɨ kɨ ngan dɔ’i’tɨ, isɨ nginə’n ndɔ kɨ, Luwə kɨ njegangita kɨ dana, a re’n kadɨ ɔjɨ’n wongɨ lə’ne dɔ de’gɨ’tɨ kɨ njera nya kɨ majel. ");
INSERT INTO gqr_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Luwə kɨ nje kugə de kɨ ra ɓangɨ kuləra’a. ");
INSERT INTO gqr_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","De’gɨ kɨ uwəi tɔgɨ’de ba me nya ra’tɨ kɨ majɨ, isɨ sangi tɔɓar, kɨ kɔsikurə, kɨ isɨ sangi kadɨ n’oyi el, Luwə a adɨ’de kisikidɔtaa kɨ bitɨ kɨ non’tɨ. ");
INSERT INTO gqr_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Nan nje kɨ nje kur mu, nje tanrɔ ta kɨ rɔta’tɨ, ə təli rɔ’de go nya ra’tɨ kɨ dana el, Luwə a mbətɨ’de, a adɨ wongɨ li’ə kibo osɨ dɔ’de’tɨ. ");
INSERT INTO gqr_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","A adɨ me kon kɨ əti ɓol a ra de’gɨ pətɨ kɨ njeramajel. A ulə ngirə dɔ Juwipɨ’gɨ’tɨ ɓay taa re’n dɔ de’gɨ’tɨ kɨ in Juwipɨ’gɨ el’tɨ. ");
INSERT INTO gqr_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Ningə de’gɨ kɨ njera majɨ, Luwə a adɨ’de tɔɓar, kɨ kɔsikurə, kɨ kisimajɨ, a ulə ngirə dɔ Juwipɨ’gɨ’tɨ ɓay taa re’n dɔ de’gɨ’tɨ kɨ in Juwipɨ’gɨ el. ");
INSERT INTO gqr_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Tadɔ kɔr kum nan goto rɔ Luwə’tɨ. ");
INSERT INTO gqr_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","De’gɨ kɨ in Juwipɨ’gɨ el kɨ rai majel kɨ kanjɨ gər ndukun lə *Mojɨ, a tuji kigo lo gər’ə’tɨ el inɓe kin tɔ, nan Juwipɨ’gɨ kɨ gəri ndukun lə Mojɨ ɓətɨ ə rai majel, ndukun a gangɨ ta dɔ’de’tɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Ningə, in nje kɨ isɨ oyi ndukun mbi’de’tɨ be par ə Luwə isɨ ɔr ta dɔ’de el, nan in nje kɨ isɨ oyi, ə təli rɔ’de go’tɨ ə, Luwə təl’de de’gɨ kɨ dana takum’ne’tɨ. ");
INSERT INTO gqr_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","De’gɨ kɨ in Juwipɨ’gɨ el, kɨ gəri ndukun lə Mojɨ el, nan isɨ rai nya kɨ ndukun dəjɨ, kɨ kanjɨ gər kin, inɓe’gɨ in ndukun kɨ njegangita dɔ rɔ’de’tɨ. ");
INSERT INTO gqr_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Me lo’tɨ kin, tɔji kadɨ nya kɨ ndukun dəjɨ kadɨ de ra kin, in kɨ ndangɨ ngarme’de’tɨ. Ningə, me’de kɨ uwə’de kɨ ta kaa mannajɨ dɔ ta’tɨ kin, taa gangɨ kɨ isɨ gangɨ ta dɔ rɔ’de’gɨ’tɨ, isɨ ɔri ta dɔ rɔ’de’gɨ’tɨ kin kaa mannaj’a tɔ. ");
INSERT INTO gqr_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Ningə tokɨ mbər Poyta kɨ majɨ kɨ m’njɨ m’ilə, el’n, in kin ə in nya kɨ a ra nya ndɔ’tɨ kɨ Luwə a un Jeju Kirisitɨ kadɨ a gangi’n ta dɔ nya’tɨ pətɨ kɨ de’gɨ iyəi me’de’tɨ. ");
INSERT INTO gqr_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Ningə in kɨ isɨ ɓar rɔ’i Juwipɨ, kɨ ra dɔ ndukun’tɨ ngan, rɔ’i isɨ n’eli dɔ Luwə’tɨ lə’i; ");
INSERT INTO gqr_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","kɨ in gər nya kɨ in ndigɨ li’ə majɨ, ndukun ndoi nya kadɨ mbətɨ nya kɨ majɨ dann kɨ majel’tɨ. ");
INSERT INTO gqr_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","In oo rɔ’i majɨ ngayn kadɨ asɨ kɔr njekumtɔ’gɨ tarow, oo rɔ’i kadɨ in kunjɨ lə de’gɨ kɨ rai lokɨ ndul’tɨ, ");
INSERT INTO gqr_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","in nje ndonya nje nyagər el’gɨ, nje ndonya ngann’gɨ kɨ du. In isɨ ra nya’gɨ kin be, tadɔ oo kadɨ me ndukun’tɨ, ingə nyagər, kɨ ta kɨ rɔta’tɨ nga. ");
INSERT INTO gqr_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","In isɨ ndo nya de’gɨ, nan asɨ kadɨ ndo rɔ’i inɓe el, isɨ iləmbər kadɨ de’gɨ ɓogi el, ə inɓe isɨ ɓogɨ. ");
INSERT INTO gqr_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Isɨ el de’gɨ kadɨ uwəi marum el, nan inɓe isɨ uwə marum, isɨ elta lə yo’gɨ kɨ ra majel, ə isɨ kər nya me kəy’tɨ lə’de. ");
INSERT INTO gqr_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Isɨ ra rɔnel dɔ ndukun’tɨ, nan isɨ aldɔ’a, adɨ mbəti kɔsikurə Luwə. ");
INSERT INTO gqr_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Lo kin’tɨ, tokɨ ndangi me makitu’tɨ lə Luwə, de’gɨ kɨ in Juwipɨ’gɨ el isɨ elita kɨ mal dɔ Luwə’tɨ tadɔ kulə ra’se in kɨ in Juwipɨ’gɨ. ");
INSERT INTO gqr_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Ningə kadɨ in gəri majɨ tokɨ kujə mɔtɨ in nya kɨ nda’a to, lokɨ de isɨ təl rɔ’ne go ndukun’tɨ, nan lokɨ in təl rɔ’i go ndukun’tɨ el ə, in kɨ de kɨ ujə mɔtɨ’ne el, asi nan. ");
INSERT INTO gqr_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Kin ə de kɨ ujə mɔtɨ’ne el, təl rɔ’ne go ndukun’tɨ ə, Luwə a oo’ə to de kɨ ujə mɔtɨ’ne. ");
INSERT INTO gqr_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","De’ə kɨ, ujə mɔtɨ’ne kigo darɔ’tɨ el, nan təl rɔ’ne go ndukun’tɨ kin, a gangɨ ta dɔ’i’tɨ. A gangɨ ta dɔ’i’tɨ, in kɨ aw kɨ ndukun kɨ ndangɨ me ji’tɨ, taa ujə mɔt’i tɔ, nan in təl rɔ’i go ndukun’tɨ el kin. ");
INSERT INTO gqr_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Tokɨ rɔta’tɨ, k’in Juwipɨ, in ba gidɨ’tɨ taga ne el, taa kujə mɔtɨ in me ndaja kɨ rɔ’tɨ kin el tɔ, ");
INSERT INTO gqr_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","nan k’in Juwipɨ kɨ rɔta’tɨ in me’tɨ kəy. Ningə kujə mɔtɨ, in kujə mɔtɨ kɨ ngarme’tɨ. In kujə mɔtɨ kɨ in rɔ Ndil Luwə’tɨ, um me ndukun’tɨ kɨ ndangɨ el. De kɨ ujə mɔtɨ’ne, in de kɨ ingə tɔjɨ kɨ rɔ Luwə’tɨ um rɔ de’gɨ’tɨ el. ");
INSERT INTO gqr_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","K’in Juwipɨ, maj’a to’tɨ, kujə mɔtɨ, nda’a to’tɨ. ");
INSERT INTO gqr_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Maj’a in ngayn me nya’gɨ’tɨ pətɨ, tadɔ, in Juwipɨ’gɨ ə Luwə ulə ta lə’ne ji’de’tɨ kete. ");
INSERT INTO gqr_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Ə re kɨ madɨ’gɨ in nje ra nya kɨ low’ə’tɨ el ə, ra nya kɨ low’ə’tɨ el lə’de a ra kadɨ Luwə yətɨ ndu’ne el. ");
INSERT INTO gqr_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Luwə a yətɨ ndu’ne el jagɨ! Ningə majɨ kadɨ de’gɨ gəri tokɨ Luwə in nje kelta kɨ rɔta’tɨ, ə de’gɨ pətɨ in nje kelta kɨ ngom, tokɨ ndangi me makitu’tɨ eyina: «Majɨ kadɨ de’gɨ gəri kɨ ra dana lə’i me ta keli’tɨ, A re awi kadɨ gangɨ ta dɔ’i’tɨ ə, Kadɨ ta uwəi el, kadɨ in te me’tɨ to nje tətɨ rɔ.» ");
INSERT INTO gqr_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Kin ə re nya kɨ dana el kɨ j’isɨ ra, ra adɨ de gər tokɨ Luwə in de kɨ dana ə, de oo ta kɨ kadɨ j’eli el. Ke Luwə in de kɨ dana el lokɨ ra se’je wongɨ lokɨ jɨ ra majel wa? M’elta kin be kigo k’oo’ə’tɨ lə de. ");
INSERT INTO gqr_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Ningə kadɨ in gəri tokɨ, Luwə in de kɨ dana el, el jagɨ. Kin ə Luwə in de kɨ dana el ə, a asɨ kadɨ gangɨ ta dɔ de’gɨ’tɨ kɨ dɔnangɨ el. ");
INSERT INTO gqr_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Ningə kin ə, me ta ngom’tɨ kɨ isɨ te ta’m’tɨ, ra adɨ ta kɨ rɔta’tɨ lə Luwə te kɨ taga, kadɨ Luwə ingə’n tɔjɨ ningə, ginn’ə in ri ə kadɨ de a gangɨ ta dɔ’m’tɨ to njeramajel ɓay wa? ");
INSERT INTO gqr_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","J’a j’eli kɨ kete par j’ene: «Ji rai majel j’adi nya kɨ majɨ te me’tɨ.» Tokɨ de’gɨ madɨ indəi taa dɔ’m’tɨ eyina: m’in ə m’ene jɨ ra majel kadɨ nya kɨ majɨ te me’tɨ kakin be. Degə’gɨ kɨ elita kin asi ta kadɨ de gangɨ ta koy dɔ’de’tɨ. ");
INSERT INTO gqr_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Ningə in nya kɨ kadɨ de el’n ene: j’in kɨ j’in Juwipɨ’gɨ, j’utəi ndəgɨ de’gɨ, el. J’utəi’de el, ningə j’elita dɔ’tɨ nga j’ene: Juwipɨ’gɨ kɨ de’gɨ kɨ in Juwipɨ’gɨ el, pətɨ, in ginn tɔgɨ’tɨ lə majel. ");
INSERT INTO gqr_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Tokɨ makitu lə Luwə el’n ene: «De kare be kɨ kadɨ in de kɨ dana goto. ");
INSERT INTO gqr_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","De kare be kɨ kadɨ gər nya goto, De kare be kɨ kadɨ sangɨ Luwə goto. Pətɨ inyəi row kɨ majɨ, ndəmi row. ");
INSERT INTO gqr_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","De kare kɨ njera majɨ goto, Kɨ kare be kaa goto. ");
INSERT INTO gqr_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Row mindɨ’de to to ɓe ninn kɨ ta’a to tagira, Ndonn’de in ndonn kelta kɨ ngom, Ndar ta’de rosɨ kɨ kəngɨ lii, ");
INSERT INTO gqr_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Isɨ manni de’gɨ mann kɨ to kelta’a el, Ta’de atɨ kangɨ dɔ de’gɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Nja’de in nja kanyi kalangɨ kɨ lo tɔl de’tɨ, ");
INSERT INTO gqr_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","lokɨ dəri’tɨ ningə, dɔ nja’de in nya kɨ tujɨ kɨ me kon. ");
INSERT INTO gqr_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","In de’gɨ kɨ gəri row lapiya el. ");
INSERT INTO gqr_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Ɓol Luwə kɨ nden goto me’de’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Jɨ gər kadɨ nya’gɨ pətɨ kɨ ndukun el, el de’gɨ kɨ in ginn ndukun’tɨ, kadɨ ta de madɨ te elta dɔ rɔ’a’tɨ el, ə kadɨ de’gɨ pətɨ gəri go majel’gɨ lə’de non Luwə’tɨ. ");
INSERT INTO gqr_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","In tadɔ kin ə, de kɨ Luwə a təl’ə de kɨ dana takum’ne’tɨ kɨ gorow təl rɔ go ndukun’tɨ goto. Tadɔ ndukun to kadɨ ɔjɨ de’gɨ adɨ gəri nya kɨ ɓari’ə majel. ");
INSERT INTO gqr_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Kɨ ngɔsine kin, Luwə tɔjɨ’je gorow kɨ təl’n de’gɨ, de’gɨ’tɨ kɨ dana kɨ kanjɨ ndukun. Ningə in, ndukun lə Mojɨ kɨ kɨ de’gɨ kɨ njekeltakita Luwə’tɨ manyinaj’a. ");
INSERT INTO gqr_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Luwə təl de’gɨ, de’gɨ’tɨ kɨ dana kɨ gorow kunme kadɨ Jeju Kirisitɨ. Tarow kin to tadɔ lə de’gɨ pətɨ kɨ uni me’de adi Jeju Kirisitɨ, tadɔ de’gɨ pətɨ asi nan: ");
INSERT INTO gqr_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","de’gɨ pətɨ in njeramajel’gɨ, adɨ tɔɓar lə Luwə nal’de. ");
INSERT INTO gqr_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Nan Luwə təl’de de’gɨ’tɨ kɨ dana takum’ne’tɨ kare. In kigo memajɨ’tɨ li’ə, me tɔ Jeju Kirisitɨ’tɨ kɨ taa’de ilə’de taa ginn tɔgɨ’tɨ lə majel. ");
INSERT INTO gqr_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","In Jeju Kirisitɨ ə, Luwə un’ə to nya kugə dɔ majel, me mos’o’tɨ kɨ anyi, kɨ gorow kunme. Luwə ra be kadɨ tɔjɨ’n nyara kɨ dana lə’ne, tadɔ majel’gɨ kɨ de’gɨ rai’de kete, tudə go’ə el, ");
INSERT INTO gqr_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","dɔkagilo kisidɔtɨ li’ə. Luwə tɔjɨ nyara kɨ dana lə’ne dɔkagilo’tɨ kɨ ɓone, kadɨ in nje kɨ ra dana, taa kadɨ tudə’n de’gɨ kɨ uni me’de adi Jeju təl’de de’gɨ kɨ dana takum’ne’tɨ. ");
INSERT INTO gqr_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Nya kare kɨ kadɨ de ində’n gu’ne goto, tadɔ nya kɨ Luwə ra dɔ’tɨ, in təl rɔ go ndukun’tɨ el, nan in kunme kadɨ Jeju Kirisitɨ. ");
INSERT INTO gqr_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Jɨ gər majɨ kadɨ Luwə təl’de de’tɨ kɨ dana takum’ne’tɨ kɨ gorow kunme kadɨ Jeju Kirisitɨ, um in kɨ gorow təl rɔ go ndukun’tɨ el. ");
INSERT INTO gqr_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Luwə in Luwə lə Juwipɨ’gɨ par el. Kɨ rɔta’tɨ, in Luwə lə’de par el, nan in Luwə lə ndəgɨ de’gɨ pətɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Tadɔ Luwə in kareba. In ə təl Juwipɨ’gɨ de’gɨ’tɨ kɨ dana takum’ne’tɨ kɨ gorow kunme num de’gɨ kɨ in Juwipɨ’gɨ el ka təl’de de’gɨ’tɨ kɨ dana takum’ne’tɨ kɨ gorow kunme tɔ. ");
INSERT INTO gqr_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Lokɨ j’uni me’je j’adi Kirisitɨ kin, tɔjɨ kadɨ nda ndukun goto wa? Lo kin’tɨ, jɨ tɔjɨ kadɨ nda’a in ngayn to kin yo. ");
INSERT INTO gqr_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Kadɨ j’elita lə kaw’je *Abiraham ningə, nya madɨ kɨ ingə kigo tɔg’ɔ’tɨ inɓe goto. ");
INSERT INTO gqr_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Kin ə Luwə tudə Abiraham de’tɨ kɨ dana takum’ne’tɨ kɨ takul kulə ra’a’gɨ ə, asɨ kadɨ Abiraham a ində’n gu’ne inɓe, nan a ində gu’ne non Luwə’tɨ el. ");
INSERT INTO gqr_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Tadɔ, ta kɨ makitu lə Luwə el ə to kin: «Abiraham un me’ne adɨ Luwə, ə Luwə tudə kunme li’ə ə oo’n’ə de’tɨ kɨ dana takum’ne’tɨ.» ");
INSERT INTO gqr_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Ningə nya kare, de kɨ ra kulə ingə’n nyakugə goji, nya kɨ ingə kin, ingə kare el, nan in nya kɨ ingə tor kulə’tɨ kɨ ra. ");
INSERT INTO gqr_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Kin ə de ra kulə madɨ el, nan un me’ne adɨ Luwə kɨ in nje təl de kɨ njeramajel, de’tɨ kɨ dana takum’ne’tɨ ə, Luwə a təl’ə de’tɨ kɨ dana, kigo tudə kunme li’ə kɨ ində dɔ me majɨ’tɨ lə Luwə. ");
INSERT INTO gqr_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","In be ə, *Dabidɨ un’n ndu’ne kɨ taa el’n ta lə majɨ kɨ ingə kɨ rɔ Luwə’tɨ. Adɨ in de kɨ Luwə tudə de’tɨ lə’ne kɨ kanjɨ gon kulə ra’a’gɨ. ");
INSERT INTO gqr_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","Dabidɨ ene: «De’gɨ kɨ Luwə inyə nyara’de’gɨ kɨ go’tɨ el, kɔ, Luwə bɔr majel’gɨ lə’de kɔ, in nje majikur’gɨ. ");
INSERT INTO gqr_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","De kɨ Luwə tudə majel li’ə dɔ’a’tɨ el in nje majikur.» ");
INSERT INTO gqr_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Majɨ kin in tadɔ lə njekujəmɔtɨ par el, nan in tadɔ lə njekujəmɔtɨ’gɨ el tɔ. Tadɔ j’eli j’ene: Luwə təl Abiraham de’tɨ kɨ dana takum’ne’tɨ, tudə’n kunme li’ə oo’n’ə de’tɨ kɨ dana. ");
INSERT INTO gqr_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Eke nya kin ra nya dɔkagilo’tɨ kɨ ra wa? Ke in kete non kujə mɔtɨ Abiraham’tɨ eke in go’tɨ wa? Nya kin ra nya kete non’tɨ, um in go’tɨ gogɨ el. ");
INSERT INTO gqr_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","12","Ningə nyakɔjɨ kɨ dɔ kujə mɔtɨ’tɨ re go’tɨ gogɨ to ndaj’a, kɨ kadɨ tɔjɨ tokɨ Luwə təl Abiraham de’tɨ kɨ dana takum’ne’tɨ, kɨ takul kun kɨ un me’ne adɨ Luwə, dɔkagilo’tɨ kɨ ujə’n mɔtɨ’ne el ɓay. Lo kin’tɨ, de’gɨ kɨ ujəi mɔtɨ’de el kaa Luwə təl’de de’gɨ’tɨ kɨ dana takum’ne’tɨ num, de’gɨ kɨ ujəi mɔtɨ’de kaa təl’de de’gɨ’tɨ kɨ dana takum’ne’tɨ num tɔ. Ningə Abiraham təl baw de’gɨ pətɨ kɨ ujəi mɔtɨ’de el, kɨ uni me’de, taa təl baw de’gɨ kɨ ujəi mɔtɨ’de tɔ. Adɨ in nje’gɨ kɨ uwəi kul kujə mɔtɨ par el, nan uni dɔ nja baw’je Abiraham kɨ un, ə un me’ne adɨ Luwə kete non kujə mɔtɨ’ne’tɨ kin. ");
INSERT INTO gqr_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Luwə un ndu’ne adɨ Abiraham kɨ de’gɨ kɨ ginn kojɨ’tɨ li’ə tokɨ dɔnangɨ in nya nduwə lə’de. Ningə in tadɔ təl kɨ Abiraham təl rɔ’ne go ndukun’tɨ el, nan in tadɔ təl kɨ Luwə təl’ə de’tɨ kɨ dana takum’ne’tɨ kɨ gorow kunme kadɨ Luwə. ");
INSERT INTO gqr_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Kin ə re nya nduwə kin in tadɔ lə de’gɨ kɨ nje təl rɔ’de go ndukun’tɨ par ningə, kar kunme goto, taa kunndu kɨ un adɨ Luwə kaa təl nya kɨ kum’ə goto tɔ. ");
INSERT INTO gqr_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Tadɔ ndukun ə in nje re kɨ wongɨ lə Luwə. Tadɔ lo kɨ ndukun goto’tɨ, k’aldɔ ndukun kaa goto’tɨ tɔ. ");
INSERT INTO gqr_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Lo kin’tɨ, nya nduwə kɨ Luwə un ndu’ne kadɨ n’a n’adɨ’de kin, de a ingə kɨ gorow kunme kadɨ Luwə. Be kadɨ in nya kadikare kɨ Luwə adɨ, kɨ nda’a to’tɨ tadɔ lə de’gɨ pətɨ kɨ uni me’de to Abiraham be, um tadɔ lə de’gɨ kɨ nje təl rɔ’de go ndukun’tɨ par el. Abiraham kɨ in baw de’gɨ pətɨ. ");
INSERT INTO gqr_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Makitu lə Luwə elta dɔ Abiraham’tɨ ene: «M’ra’i to baw de’gɨ ngayn kɨ dɔnangɨ’tɨ ne.» Abiraham in baw’je takum Luwə’tɨ kɨ un me’ne ad’a. Luwə kɨ nje kadɨ njekoy’gɨ indəi taa lo koy’tɨ, kɨ nje kadɨ nya’gɨ kɨ kete gotoi, toi. ");
INSERT INTO gqr_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Abiraham un me’ne adɨ Luwə, adɨ təl baw de’gɨ ngayn kɨ dɔnangɨ’tɨ ne tokɨ makitu lə Luwə el’n ene: «Ginn de’gɨ lə’i a banyinan to mee’gɨ kɨ dɔran’tɨ be.» Lo kin’tɨ, nya kɨ kadɨ de ində me’ne dɔ’tɨ goto, nan Abiraham aw kɨ kindəmedɔtɨ. ");
INSERT INTO gqr_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Abiraham aw kɨ ɓal kɨ asɨ ndəkba kɨ ɓu kare, ningə gər kadɨ n’tɔgɨ, tɔgɨ’ne goto, taa ne’ə Sara kaa in kujɨ tɔ, nan gon lo kin el, un me’ne kadɨ kun mindɨ lə Luwə kɨ un kin a ra nya. ");
INSERT INTO gqr_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Abiraham ilə kunme lə’ne kɔ el, taa me’ə tɔsɨ dɔ kunndu kɨ Luwə un ad’a el tɔ. Ingə tɔgɨ to kingə me kunme’tɨ lə’ne, ulə’n tɔjɨ dɔ Luwə’tɨ. ");
INSERT INTO gqr_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Ningə gər dɔ’ne’tɨ majɨ ngayn kadɨ nya kɨ Luwə un ndu’ne kadɨ n’ra kin, aw kɨ tɔgɨ kadɨ a ra’n. ");
INSERT INTO gqr_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","In tadɔ kin ə, Luwə tudə’n Abiraham de’tɨ kɨ dana. ");
INSERT INTO gqr_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Ningə lokɨ makitu ene: «Luwə tudə Abiraham de’tɨ kɨ dana», kin, in tadɔ lə Abiraham kɨ kar’ne par el. ");
INSERT INTO gqr_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","Nan in ta kɨ sɔw dɔ’je tɔ. J’in kɨ kadɨ Luwə a tudə’n’je de’gɨ’tɨ kɨ dana, kɨ takul kunme lə’je. J’un me’je j’adɨ Luwə kɨ ində kɨ Burəɓe lə’je Jeju dann njekoy’gɨ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Jeju kɨ Luwə un’ə adɨ koy tadɔ majel’gɨ lə’je, ningə un’ə dann njekoy’gɨ’tɨ te si’ə kadɨ tudə’n’je de’gɨ’tɨ kɨ dana takum’ne’tɨ. ");
INSERT INTO gqr_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Lokɨ Luwə təl’je de’gɨ kɨ dana takum’ne’tɨ kɨ gorow kunme, dann’je si’ə in kɨ lapiya kɨ takul Burəɓe lə’je Jeju Kirisitɨ. ");
INSERT INTO gqr_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","In kɨ takul Jeju Kirisitɨ, kɨ gorow kunme ə, j’ingə’n majikur lə Luwə. Majikur kɨ jɨ ra me’tɨ, j’isɨ jɨ ra rɔnel, tadɔ j’ində me’je dɔ’tɨ kadɨ j’a j’in ginn tɔɓar’tɨ lə Luwə. ");
INSERT INTO gqr_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","In kɨ utə, me kon’tɨ kaa jɨ ra rɔnel, tadɔ jɨ gər kadɨ kon a re kɨ koreme, ");
INSERT INTO gqr_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","ningə de kɨ nje koreme’ne, a ra dɔ nja’ne’tɨ me nya’gɨ’tɨ kɨ to, ə de kɨ nje kɨ ra dɔ nja’ne’tɨ, in de kɨ aw kɨ nya kindəmedɔtɨ, ");
INSERT INTO gqr_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","ningə nya kɨ ində me’ne dɔ’tɨ kin, a in nya kɨ ngom el. Tadɔ Luwə ɓukɨ ndiginan kɨ ində ngarme’je’tɨ kɨ gorow lə Ndil Luwə kɨ kar njay kɨ adɨ’je. ");
INSERT INTO gqr_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Kirisitɨ re oy tadɔ lə njeramajel’gɨ, lokɨ j’asɨ kadɨ jɨ ra nya madɨ kɨ dɔrɔ’je el. Ningə oy kɨ dɔkagilo kɨ Luwə inɓe ɔjɨ. ");
INSERT INTO gqr_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","De kɨ dana inɓe mindɨ kaa, ngan ngayn kadɨ de a adɨ rɔ’ne koy’tɨ tadɔ li’ə. Re dum inɓe ningə, de kɨ njera nya kɨ majɨ, ə de mad’a kɨ rangɨ, a uwə rɔ’ne ba kadɨ oy tadɔ li’ə. ");
INSERT INTO gqr_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Lo kin’tɨ, Luwə tɔjɨ’je ndigɨ kɨ ndigɨ’je kɨ taga adɨ j’oo. Luwə adɨ Kirisitɨ re oy tadɔ lə’je, dɔkagilo’tɨ kɨ jɨ nanyi’n me majel’tɨ kɨ ra ɓay. ");
INSERT INTO gqr_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Ningə, tokɨ ngɔsine, kadɨ rɔ koy’tɨ lə Kirisitɨ, təl’je de’gɨ’tɨ kɨ dana takum Luwə’tɨ takul mos’o kin ningə, kibo ngayn ɓay, Kirisitɨ a ajɨ’je ta wongɨ’tɨ lə Luwə kɨ a re. ");
INSERT INTO gqr_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Kete kɨ j’in njeban’gɨ lə Luwə ɓay mindɨ ə, inɓe ulə’je nojɨ nan’tɨ sə’ne kɨ gorow koy Ngonn’o. Ningə kɨ ngɔsine kin ulə’je nojɨ nan’tɨ kɨ rɔ’ne taa, inɓe a ajɨ’je me kisikidɔtaa’tɨ lə Ngonn’o el wa. ");
INSERT INTO gqr_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Ningə, in in kin par el, rɔ’je nəl’je ngayn takum Luwə’tɨ, tadɔ lə Burəɓe lə’je Jeju Kirisitɨ kɨ un’ə ulə’n’je nojɨ nan’tɨ kɨ rɔ’ne. ");
INSERT INTO gqr_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","In kɨ gorow lə de kɨ kare be kɨ in Adam, ə majel re’n dɔ dɔnangɨ’tɨ, ningə majel re’n kɨ koy, koy ɔdɨ de’gɨ pətɨ, tadɔ de kɨ ra majel el goto, de’gɨ pətɨ rai majel. ");
INSERT INTO gqr_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Ningə, kete taa kadɨ Luwə te kɨ dɔ ndukun adɨ Mojɨ, majel kɨ ra to me dɔnangɨ’tɨ ne nga, nan tokɨ in dɔkagilo kɨ ndukun goto ɓay, Luwə tudə majel’gɨ kɨ de’gɨ isɨ rai el. ");
INSERT INTO gqr_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Nya kare, koy onɓe dɔ de’gɨ’tɨ pətɨ, ulə ngirə dɔ Adam’tɨ bitɨ te’n dɔ Mojɨ’tɨ. Nje kɨ alidɔ ndu Luwə el, tokɨ Adam aldɔ ndu Luwə kin be kaa, koy onɓe dɔ’de’tɨ. Adam in banakum de kɨ majɨ kadɨ a re. ");
INSERT INTO gqr_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Nga ningə, nya kɨ kadɨ de a ɔjɨ’n majel lə Adam in kɨ kadikare memajɨ lə Luwə kin nan’tɨ goto. In kɨ rɔta’tɨ kadɨ de’gɨ ngayn oyi koy majel lə de kɨ kare kɨ in Adam kin, nan memajɨ lə Luwə in kibo ngayn. Ningə nya kɨ Luwə adɨ bulə de’gɨ ngayn kare, kɨ gorow lə de kare be par, kɨ in Jeju Kirisitɨ kin, nda’a in ngayn. ");
INSERT INTO gqr_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Kadikare lə Luwə kɨ adɨ kin, kand’a to ta dangɨ kɨ kandɨ majel lə de kɨ kareba kin. Majel lə de kɨ kare kin, ndu kɨ osɨ dɔ’tɨ in ta kɨ gangɨ, nan kadikare kɨ re go nyara go’tɨ el kɨ ngayn, kand’a in ta kɨ kɔr dɔ’tɨ. ");
INSERT INTO gqr_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Kin ə re, kɨ tarow lə de kɨ kare be par, kɨ tarow majel li’ə, koy onɓe dɔ de’gɨ’tɨ pətɨ ningə, kɨ tarow lə Jeju Kirisitɨ kɨ kare inɓe kin, j’a j’ingə’n nya kɨ majɨ ngayn kɨ rɔ Luwə’tɨ 