﻿USE sofia;
DROP TABLE IF EXISTS sofia.gok_vpl;
CREATE TABLE gok_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES gok_vpl WRITE;
INSERT INTO gok_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","ಅಬ್ರಹಾಮಾಚಾ಼ ಲ್ಯೊಕ್ ಜಾ಼ಲ್ಯಾವ ದಾವಿದಾಚಾ಼ ಲ್ಯೊಕ್ ಜಾ಼ಲ್ಯಾಲ್ಯಾ ಯೇಸು ಕ್ರಿಸ್ತಾಚಿ ಪಿಳ್ಗಿ. ");
INSERT INTO gok_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","ಅಬ್ರಹಾಮಾಚಾ಼ ಲ್ಯೊಕ್ ಇಸಾಕ್. ಇಸಾಕಾಚಾ಼ ಲ್ಯೊಕ್ ಯಾಕೊಬ್. ಯಾಕೊಬಾಚಾ಼ ಲ್ಯೊಕ್ ಯೆಹುದ, ತ್ಯಚಾ಼ ಬಾಹು ಯೆಹುದಾಚಿ ಪ್ಯುರ್ಗಿ. ");
INSERT INTO gok_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","ಯೆಹುದಾಲಾ ತಾಮಾರಳಾಪ ಪೆರೆಚನಾಲಾ, ಜೆರಹನ್ ಜ಼ಲಾಮ್ಲಾ. ಪೆರೆಸಾಚಾ಼ ಲ್ಯೊಕ್ ಹೆಚ್ರೊನ್. ");
INSERT INTO gok_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","ಹೆಚ್ರೊನಾಚಾ಼ ಲ್ಯೊಕ್ ಅರಾಮ್, ಅರಾಮಾಚಾ಼ ಲ್ಯೊಕ್ ಅಮಿನಾದಾಬ್. ಅಮಿದಾನಾದಾಬಾಚಾ಼ ಲ್ಯೊಕ್ ನಹಶೊನ್. ನಹಶೊನಾಚಾ಼ ಲ್ಯೊಕ್ ಸಲ್ಮೊನ್. ");
INSERT INTO gok_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","ಸಲ್ಮೊನಾಚಾ಼ ಲ್ಯೊಕ್ ಬೊವಜನ್ ರಾಹಾಬಾಳಾಲಾ ಜ಼ಲಾಮ್‌ಲ್ಯಾಲಾ. ಬೊವಜಚಾ಼ ಲ್ಯೊಕ್ ಒಬೆದ್ ರುತಾಲಾ ಜ಼ಲಾಮ್ಲಾ. ಒಬೆದಾಚಾ಼ ಲ್ಯೊಕ್ ಇಶಾಯನ್. ");
INSERT INTO gok_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ಇಶಾಯನಾಚಾ಼ ಲ್ಯೊಕ್ ರಾಜಾ಼ ಜಾ಼ಲ್ಯಾಲಾ ದಾವಿದ್. ದಾವಿದಾಚಾ಼ ಲ್ಯೊಕ್ ಸಲೊಮೊನ್, ಉರಿಯಾಚೆ ಬ್ಯಾಯ್ಕೊಲಾ ಜಾ಼ಲ್ಯಾಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","ಸೊಲೊಮೊನಾಚಾ಼ ಲ್ಯೊಕ್ ರೆಹಬ್ಬಾಬ. ರೆಹಬ್ಬಾಮಾಚಾ಼ ಲ್ಯೊಕ್ ಅಬೀಯನ್. ಅಬೀಯನಾಚಾ಼ ಲ್ಯೊಕ್ ಆಸನ್. ");
INSERT INTO gok_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","ಆಸನಾಚಾ಼ ಲ್ಯೊಕ್ ಯೆಹೊಶಾಪಾಟ್, ಯೆಹೊಶಪಾಟಾಚಾ಼ ಲ್ಯೊಕ್ ಯೆಹೊರಾಮನ್. ಯೆಹೊರಾಮನಾಚಾ಼ ಲ್ಯೊಕ್ ಉಜ್ಜಿಯನ್. ");
INSERT INTO gok_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","ಉಜ್ಜಿಯಾಚಾ಼ ಲ್ಯೊಕ್ ಯೊತಮನ್. ಯೊತಮನಾಚಾ಼ ಲ್ಯೊಕ್ ಆಹಾಜನನ್. ಆಹಾಜನಾಚಾ಼ ಲ್ಯೊಕ್ ಹಿಜ್ಕಿಯಲ್. ");
INSERT INTO gok_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","ಹಿಜ್ಕಿಯಾಚಾ಼ ಲ್ಯೊಕ್ ಮನಸ್ಸೆಯನ್. ಮನಸ್ಸೆಚಾ಼ ಲ್ಯೊಕ್ ಅಮೊನನ್. ");
INSERT INTO gok_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","ಅಮೊನಾಚಾ಼ ಲ್ಯೊಕ್ ಯೊಶಿಯನ್, ಬಾಬಿಲೊನಾಲಾ ಕ್ಯೊಂಡಲ್ಯಾಲ್ಯಾ ಯಳಾತ್ ಯೊಶಿಯಲಾ ಯೆಕೊನ್ಯನ್, ತ್ಯಚ಼ ಬಾಹು ಜ಼ಲಾಮ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","ಬಾಬಿಲೊನಾಲಾ ಕ್ಯೊಂಡಲ್ಯಾವ ಯೆಕೊನ್ಯ ಶೆಯಲ್ತಿಯಾಚಾ಼ ಲ್ಯೊಕ್ ಜೆರುಬಾಬೆಲಾನಾಲಾ ");
INSERT INTO gok_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","ಜೆರುಬಾಬೆಲಾನಾಚಾ಼ ಲ್ಯೊಕ್ ಅಬಿಹುದನ್. ಅಬಿಹುದನಾಚಾ಼ ಲ್ಯೊಕ್ ಎಲೆಕಿಮ. ಎಲೆಕಿಮಚಾ಼ ಲ್ಯೊಕ್ ಅಜೊ಼ರನ್. ");
INSERT INTO gok_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","ಅಜೊ಼ರನಾಚಾ಼ ಲ್ಯೊಕ್ ಸದೊಕನ್. ಸದೊಕನಾಚ಼ಾ ಲ್ಯೊಕ್ ಅಖಿಮನ್. ಅಖಿಮನಾಚಾ಼ ಲ್ಯೊಕ್ ಎಲಿಹುದ್. ");
INSERT INTO gok_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","ಎಲಿಹುದಾಚಾ಼ ಲ್ಯೊಕ್ ಎಲಿಯಾಜ಼ರ್. ಎಲಿಯಾಜ಼ರಾಚಾ಼ ಲ್ಯೊಕ್ ಮತ್ತಾನ್. ಮತ್ತಾನಾಚಾ಼ ಲ್ಯೊಕ್ ಯಾಕೊಬ್. ");
INSERT INTO gok_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ಯಾಕೊಬಾಚಾ಼ ಲ್ಯೊಕ್ ಯೊಸೆಫ. ಯೊಸೆಫ್ ಮರಿಯಾಚಾ಼ ದನ್ಗೊರ್. ಹೆ ಮರಿಯಾಪ್ನಿಸ್ ಕ್ರಿಸ್ತ್ ಮಂಥ್ಯಾಲಾ ಯೇಸು ಜ಼ಲಾಮ್‌ಲ್ಯಾಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","ಅಬ್ರಹಾಮಾದರ್ನಿ ದಾವಿದಾ ಪರ‍್ಯಾತ್ ಸಗ್‌ಳ್ಯಾ ಚೌ಼ದಾ ಡೊಯಾ. ದಾವಿದಾಪ್ನಿ ಬಾಬಿಲೊನಾಚಾ ಹಾತಾತ್ ಜಾ಼ಯಿಪರ‍್ಯಾತ್ ಚೌ಼ದಾ ಡೊಯಾ, ಬಾಬಿಲೊನಾಚಾ ಹಾತಾತ್ನಿ ಕ್ರಿಸ್ತಾಚಾ ದಿಸಾಪರೇತ್ ಚೌ಼ದಾ ಡೊಯಾ. ");
INSERT INTO gok_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","ಯೇಸು ಕ್ರಿಸ್ತಾಚಾ಼ ಜ಼ಲ್ಮ ಕಸಾ ಜಾ಼ಲ್ಯಾ ಮನ್‌ಲ್ಯಾವ, ತ್ಯಚಿ ಆಯಿ ಮರಿಯಾಚಿ ಆನಿ ಯೊಸೆಫಾಚಿ ಸಾಕಾರ್ ಸಾಡಿ ಜಾ಼ಲ್ಥಿ. ತ್ಯಂಚ಼ ದೊಗಾಂಚ಼ ಲಗೀನ್ ವ್ಹವುನ್ ಯಕಿಕ್ಡ ವ್ಹವುನ್ ಜೀವ್ನಾ ಕರಾಚೆ ಆಂದಿ ಮರಿಯಾ ಪವಿತ್ರಾತ್ಮಾಚಾ ಬಳಾನಿ ಗರ್ವಾರ್ ಹಾ ಮನ್ಹುನ್ ಸಮಾಜ಼್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","ಫನ್ ತಿಚಾ಼ ದನ್ಗೊರ್ ಜಾ಼ಲ್ಯಾಲಾ ಯೊಸೆಫ್ ನಿಯತಿಚಾ಼ ಹುತಾ ಮನ್ಹುನ್ ಮರಿಯಾಲಾ ಯಕಿಕ್ಡ ಹಾಕ್ಟುನ್ ಮರ‍್ಯಾದ್ ಗಾಲ್ಹಾಚೆ ಆಂದಿ ಶೊಡ್ಸುಟಿ ಗಿಹ್ಯಾ ಯವ್ಜಿತಾ. ");
INSERT INTO gok_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","ತ್ಯೊ ಆಸ ಯವಜ಼ತಾ ಆಸ್ತಾನಾ, ದೇವ್ದುತ್ ತ್ಯಚಾ ಸಪ್ನಾತ್ ಯವುನ್, ದಾವಿದಾಚಾ಼ ಲ್ಯೊಕ್ ಜಾ಼ಲ್ಯಾಲ್ಯಾ ಯೊಸೆಫಾ, ತು ಮರಿಯಾಲಾ ದನ್ಗರ್ ಮನ್ಹಾಯಾ ಲಾಜು಼ನಕೊಸ್. ತೀ ಗರ್ವಾರ್ ಜಾ಼ಲ್ಯಾಲಿ ಪವಿತ್ರಾತ್ಮಾನಿ. ");
INSERT INTO gok_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","ತೀ ಯಕಾ ಲೇಕಾಲಾ ಜ಼ಲ್ಮದೇನಾರ್; ತ್ಯಚ಼ ನಾವ್ ‘ಯೇಸು’ ಮನ್ಹುನ್ ಥೆವಾಯಾ ವ್ಹಯಿಸ್; ಕಾ ಮಂಜೆ ತ್ಯೊಸ್ ಆಪ್‌ಲ್ಯಾ ಲೊಕಾನಾ ತ್ಯಂಚಾ ಪಾಪಾತ್ನಿ ಸುಡ್ವುನ್ ರ‍್ಯಾಕ್ನಾರ್, ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","ಪ್ರಭುನಿ ಪ್ರವಾದಿಂಚಾಪ್ನಿ ಸಾಂಗ್‌ಲ್ಯಾಲ್ಯಾ ಬೊಲ್ಯಾ ಘಡಶಾರ್ಕ್ಯಾ ಹ್ಯ ಸಗ್ಳ ಚಾ಼ಲ್ಲ; ಹ್ಯಾ ಬೊಲ್ಯಾ ಕ್ಯಾ ಮಂಜೆ. ");
INSERT INTO gok_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","ಹಬ, ಯಕ್ ಕನ್ಯಾ ಗರ್ವಾರ್ ವ್ಹವುನ್ ಲೆಕಾಲಾ ಜ಼ಲ್ಮ ದೆನಾರ್; ತ್ಯಲಾ ಇಮಾನ್ ವೇಲ್ ಮನ್ಹುನ್ ನಾವ್ ಥೆವ್ನಾರ್. ‘ದೇವ್ ಆಮ್ಚಿಸಂಗ ಹಾ ಮನ್ಹುನ್’ ಹ್ಯಾ ನಾವಾಚಾ಼ ಆರ್ಥ. ");
INSERT INTO gok_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","ತವಾ ಯೊಸೆಫ್ ಜಾ಼ಗಾ ವ್ಹವುನ್ ದೇವ್ದುತಾನಿ ಶೆಪ್ಪತ್ ದಿಲ್ಯಾಶಾರ್ಕಿ ಮರಿಯಾಲಾ ದನ್ಗರ್ ಕರುನ್ ಗಿತ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","ಫನ್ ತಿ ಮುಲಾಲಾ ಜ಼ಲ್ಮದಿಯಿಪರ‍್ಯಾತ್ ತಿಚಿಸಂಗಸ್ ಶರಿರ್ ಸಮನ್ ನಸ್ಥಾನಾ ಹುತ್ತಾ. ತವಾ ಯೊಸೆಫಾನಿ ತ್ಯಾ ಮುಲಾಲಾ ‘ಯೇಸು’ ಮನ್ಹುನ್ ನಾವ್ ಥೆವ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","ಹೆರೊದ್ ರಾಜಾ಼ ಆಸ್‍ಲ್ಯಾಲ್ಯಾ ಕಾಲಾತ್ ಯುದಾಯ್ ಬೆತ್ಲೆಹೇಮ್ ಮಂಥ್ಯಾಲ್ಯಾ ಗಾವಾತ್ ಯೇಸು ಜ಼ಲಾಮ್ಲಾ ತವಾ ಉಗಾವ್ತೆ ದೇಶೆತ್ಲ ಶಾನ ಯೆರುಸಲೇಮಿತ್ ಆಲ. ");
INSERT INTO gok_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“ಯೆಹುದ್ಯಾಂಚಾ಼ ರಾಜಾ಼ ಜ಼ಲಾಮ್ಲಾ ನವ್ಹ ತ್ಯೊ ಕುಠ ಹಾ? ತ್ಯೊ ಜ಼ಲಾಮ್‍ಲ್ಯಾಲಾ ದ್ಯಾವ್‍ತ್ಯಾಲಿ ಚಾನ್ನಿ ಆಮಿ ಉಗಾವ್ತೆ ದೆಶೆತ್ ಬಗುನ್ ತ್ಯಲಾ ವವ್ಯಾಳಾಲಾ ಆಲ್ಯಾವ್” ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","ಹ್ಯ ಐಕುನ್ ಹೆರೊದ್ ರಾಜಾ಼ ಆನಿ ಯೇರುಸಲೇಮಿತ್ಲಿ ಲೊಕ ಸಗ್ಳಿ ಗಾಭಾರ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","ತವಾ ಹೆರೊದಾನಿ ಯೆಹುದ್ಯಾಂಚಾ ಮುಖ್ಯ ಯಾಜಕಾನಾ ಮೊಶೆಚಾ ಧರ್ಮಾಚಾ಼ ಶಿಕ್ಶಕ್ ಧರ್ಮ ಉಪದೆಶಕಾಂಚಾ಼ ಮೇಳಾ ಕೆಲಾ ಆನಿ “ಕ್ರಿಸ್ತ ಜ಼ಲ್ಮಾಚಾ಼ ಜಾ಼ಗಾ ಕಚಾ಼? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","ತೇ, “ಯುದಾಯಾಚಿ ಬೆತ್ಲೆಹೇಮ್ ಮಂಥ್ಯಾಲ್ಯಾ ಗಾವಾತ್ ಜ಼ಲಾಮ್ನಾರ್. ಕಾ ಮಂಜೆ ಪ್ರವಾದಿನಿ ಪವಿತ್ರ ಪುತೀಕಾತ್ ಆಸ ಮನ್ಹುನ್ ಲಿವ್‌ಲ್ಯಾಲ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","ಯೆಹುದ್ಯಾತ್ ಆಸ್‍ಲ್ಯಾಲ್ಯಾ ಜಾ಼ಗ್ಯಾತ್ಲೆ ಬೆತ್ಲೆಹೇಮೆ. ಯೆಹುದ್ಯಲಾ ಚಾ಼ಲಿವತ್ಯಾಲೆ ತುಸ್ ಮೊರ‍್ಯಾ ವ್ಹನಾರ್ ವ್ಹಯ್ ಜಾಂತಾ ಯೊಕ್ ತುಜಾತ್ಲಾಸ್ ಯನಾರ್. ಮಾಜಿ ಲೊಕ ಇಸ್ರಾಯಲಾನಾ ತ್ಯೊಸ್ ಮೊರ‍್ಹ ಚಾ಼ಲಿವ್ನಾರ್ ಮನ್ಹುನ್ ಉತ್ತರ್ ದಿಲಾ’” ");
INSERT INTO gok_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","ತವಾ ಹೆರೊದಾನಿ ಕುನಾಲಾ ಸಮ್ಜಾಚೆ ಆಂದಿ ಉಗಾವ್ತೆ ದೇಶೆತ್‍ಲ್ಯಾ ಶಾನ್ಯಾನಾ ಹಾಕ್ಟುನ್ ತಿ ಚಾನ್ನಿ ದಿಸಲ್ಯಾಲಾ ಯೊಳ್ ತ್ಯಂಚಿಪ್ನಿಸ್ ಶಾರ್ಕಾ ಸಮಜು಼ನ್ ಗೆತ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","ಹೆರೊದಾನಿ ತ್ಯಾ ಶಾನ್ಯಾನಾ ತುಮಿ ಜಾ಼ವುನ್ ತ್ಯಾ ಮುಲಾಚಾ಼ ಶಾರ್ಕಾ ಇಚಾರ್ ಕರುನ್ ತ್ಯ ಮುಲ್ ಕುಠ ಹಾ ಮನ್ಹುನ್ ಸಮಜು಼ನ್ ಮನಾ ಸಾಂಗಾ ಮಿ ಯವು‍ನ್ ತ್ಯಲಾ ವವ್ಯಾಳಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಸಾಂಗುನ್ ತ್ಯನಾ ಬೆತ್ಲೆಹೇಮತ್ ಲಾವುನ್ ದಿಲ. ");
INSERT INTO gok_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","ತೆಂಚಾನಿ ರಾಜಾಚಿ ಬುಲಿ ಐಕುನ್ ತಿಥ್ನಿ ನಿಗಾಲ ತವಾ ಉಗಾವ್ತೆ ದೆಶೆತ್ ಉಗಾವಲ್ಯಾಲಿ ಚಾನಿ ತ್ಯಂಚೆ ಮೊರ‍್ಹ ಲಾಗುನ್ ಮುಲ್ ಆಸ್‍ಲ್ಯಾಲ್ಯಾ ಜಾ಼ಗ್ಯಾವ ಉಬಿರಾಯ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","ತ್ಯಂಚಾನಿ ತೇ ಚಾನ್ನಿಲಾ ಬಗುನ್ ಖುಬ್ ಸಂತೊಶ್ ಜಾ಼ಲ. ");
INSERT INTO gok_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","ಆನಿ ತೇ ತ್ಯಾ ಗರ‍್ಹಾತ್ ಜಾ಼ವುನ್ , ತ್ಯಾ ಮುಲಾಲಾ ಆಯಿ ಮರಿಯಾಪ ಬಗು‍ನ್ ತ್ಯಲಾ ಆಡ್ವ ಪಡುನ್ ವವ್ಯಾಳಾ. ಆನಿ ತ್ಯಂಚಾನಿ ಮೂಲಾಸಾಟಿ ಆನ್‌ಲ್ಯಾಲಿ ದಿನ್ಗಿ ಸುಡುನ್ ಸೊನ, ಧುಪ್ ಆನಿ ಚಾ಼ಂಗ್ಲ ವಾಸಾಚ಼ ತ್ಯಾಲ್ ದಿಲ. ");
INSERT INTO gok_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","ಫನ್ ದೇವಾನಿ ಶಾನ್ಯಾಂಚಾ ಸಪ್ನಾತ್, “ತುಮಿ ಹೆರೊದಾಪ ಮಾಗಾರ ಪರ್ತುನ್ ಜಾ಼ವುನಕೋಸಾ” ಮನ್ಹುನ್ ತಾಕಿತ್ ದಿಲಿ. ತವಾ ತೆ ದುಸ್ರೆ ವಾಟನಿ ಆಪ್ಲೆ ದೇಶೆತ್ ನಿಗುನ್ ಗೆಲ. ");
INSERT INTO gok_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","ಶಾನ ನಿಗುನ್ ಗೆಲ ತವಾ ಪ್ರಭುಚಾ಼ ಧುತ್ ಯೊಸೆಪಾಲಾ ಸಪ್ನಾತ್ ಯವುನ್ “ಉಟ್ ಮುಲಾಲಾ ಆನಿ ತ್ಯಚೆ ಆಯಿಲಾ ಗಿಹುನ್ ಐಗುಪ್ತಾತ್ ಪಳುನ್ ಜಾ಼. ಹೆರೊದ್ ಹ್ಯಾ ಮುಲಾಲಾ ಮಾರುನ್ ಟಾಕಾಯಾ ಸೋದಾಯಾ ಲಾಗ್‌ಲ್ಯಾ. ಮಿ ಸಾಂಗಿ ಪರ‍್ಯಾತ್ ತು ಐಗುಪ್ತಾತುಸ್ ರ‍್ಹಾ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","ತವಾಸ್ ಯೊಸೆಪ್ ಉಠುನ್ ಮುಲ್ ಆನಿ ತ್ಯಚಿ ಆಯಿ ಸಂಗ ಐಗುಪ್ತಾತ್ ರ‍್ಯಾಚಾ಼ಸ್ ಪಳುನ್ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","ಹೆರೊದ್ ಮರ ಪರ‍್ಯಾತ್ ಯೊಸೆಪ್ ಐಗುಪ್ತಾತುಸ್ ರಾಯ್ಲಾ. ಮಿ ಮಾಜಾ ಮುಲಾಲಾ ಐಗುಪ್ತಾತ್ನಿಸ್ ಹಾಕಟ್ಲಾ ಮನ್ಹುನ್ ಪ್ರವಾದಿಚಾ ತೊಂಡಾತ್ನಿ ಪ್ರಭುನಿ ಸಾಂಗ್‌ಲ್ಯಾಲಿ ಬುಲಿ ಹಿತ್ತ ಘಡ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","ಶಾನ್ಯಾಂಚಾನಿ ಆಪ್‌ಲ್ಯಾಲಾ ಫಸಿವ್ಲ ಮನ್ಹುನ್ ಸಮಾಜ಼ಲ ತವಾ ಹೆರೊದಾನಿ ಖುಬ್ ರಾಗ್ ಕರುನ್ ತ್ಯ ಮುಲ್ ಜ಼ಲಾಮ್‌ಲ್ಯಾಲಾ ಯೊಳ್ ಹೆರೊದಾನಿ ಶಾನ್ಯಾಂಚಿಪ್ನಿ ಸಮಜು಼ನ್ ಗೇತ್ಲಾ ತ್ಯ ಮುಲ್ ಜ಼ಲ್ಮುನ್ ದೊನ್ ವರ್ಸ ಜಾ಼ಲ್ತಿತ ಮನ್ಹುನ್ ಹೆರೊದಾನಿ ಬೆತ್ಲೆಹೇಮಿತ್ ಆನಿ ತ್ಯಚೆ ಸರ್ಬೌತಚಾ ಗಾವಾತ್ನಿ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ದೊನ್ ವರ್ಸಾಚಿ ಆನಿ ತ್ಯಂಚಿವ್ನಿ ಬಾರೀಕ್ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ಪೊರ್ಗ್ಯಾನಾ ಸಗ್‌ಳ್ಯಾ ಮಾರುನ್ ಟಾಕಾ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","ಆಸ ದೇವಾನಿ ಆಪ್‌ಲ್ಯಾ ಪ್ರವಾದಿ ಜಾ಼ಲ್ಯಾಲ್ಯಾ ಯೆರೆಮಿಯಾಪ್ನಿ ಸಾಂಗ್‌ಲ್ಯಾಲಾ ಸಬ್ದ ಗಡ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“ರಾಮಾತ್ ಬ್ವಾಬ್ ಐಕು ಆಲಿ. ತೀ ಖುಬ್ ತರಾಸಾಚಿ ಆನಿ ಖುಬ್ ದುಖಾಚಿ ಬ್ವಾಬ್ ಜಾ಼ಲ್ಥಿ. ರಾಹೇಲಳ್ ಆಪ್‌ಲ್ಯಾ ಪೊರಾಂಚೆಸಾಟಿ ರಡ್ನಾರ್ ತೀ ಮಿಲಿತ ಮನ್ಹುನ್ ಸಮಾದಾನ್ ವ್ಹಯಿತ್ ನಾಹಿ” ");
INSERT INTO gok_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","ಹೆರೊದ್ ಮೆಲ್ಯಾ ನಂತರ್ ಪ್ರಭುಚಾ಼ ಧುತ್ ಯೊಸೆಪಾಚಾ ಸಪ್ನಾತ್ ದಿಸ್ಲಾ ತ್ಯೊ ಐಗುಪ್ತಾತ್ ಆಸ್ಥಾನಾಸ್ ಹ್ಯ ಜಾ಼ಲ ");
INSERT INTO gok_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ತ್ಯನಿ ತ್ಯಲಾ ಉಟ್ ಮುಲಾಲಾ ಆನಿ ತ್ಯಚೆ ಆಯಿಲಾ ಗಿಹುನ್ ಇಸ್ರಾಯಲ್ ದೇಶೆತ್ ಜಾ಼ ಮುಲಾಲಾ ಮಾರುನ್ ಟಾಕಾಯಾ ಟಪ್‌ಲ್ಯಾಲ ಮೆಲ ಮನ್ಹು‍ನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","ಮನ್ಹುನ್ ಯೊಸೆಪಾನಿ ಮುಲಾಲಾ ಆನಿ ಆಯಿಲಾ ಗಿಹುನ್ ಇಸ್ರಾಯಲಾತ್ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","ಫನ್ ಹೆರೊದ್ ಮೆಲ್ಯಾ ನಂತರ್ ತ್ಯಚಾ಼ ಲ್ಯೊಕ್ ಅರ್ಖೆಲಾಯಾ ಯುದಾಯಾತ್ ರಾಜಾ಼ ಜಾ಼ಲ್ಯಾ ಮನ್ಹುನ್ ಐಕುನ್ ತಿಥ ಜಾ಼ಯಾ ಭಿಹ್ಯಾಲಾ ಸಪ್ನಾತ್ ಆಪ್‌ಲ್ಯಾಲಾ ದಿಲ್ಯಾಲೆ ಹುಶಾರ್ಕಿ ಶಾರ್ಕ ತ್ಯನಿ ತ್ಯೊ ಜಾ಼ಗಾ ಸುಡುನ್ ಗಲಿಲಾಯಾ ಪ್ರದೇಶಾತ್ ಗೆಲಾ, ");
INSERT INTO gok_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ನಜರೇತ್ ಮಂಥ್ಯಾಲ್ಯಾ ಗಾವಾತ್ ರಾಯ್ಲಾ. ತ್ಯಲಾ ‘ನಜರೇತಿಚಾ಼’ ಮನ್ಹುನ್ ಹಾಕಟ್ಯಾತ ಆಸ ದೇವಾನಿ ಪ್ರವಾದಿಂಚಿಪ್ನಿ ಸಾಂಗ್‌ಲ್ಯಾಲ ಆಸ ಘಡ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","ತ್ಯಾ ಕಾಲಾತ್ ಬಾಪ್ತಿಸ್ಮಾ ಯೊಹಾನ್ ಯುದಾಯಾಚಾ ರಾನಾತ್ ಸಿಕ್ವಾಯಾ ಲಾಗ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“ಪಾಪ ಸೊಡಾ ಕಾ ಮಂಜೆ ದೇವಾಚ಼ ರಾಜೆ ಜ಼ವಳ್ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","“‘ಪ್ರಭುಚಾ಼ ಮಾರ್ಗ ನಿಟ್ ಕರಾ; ತ್ಯಚಾ ವಾಟಾ ನಿಟ್ ಕರಾ’ ಮನ್ಹುನ್ ರಾನಾತ್ ಯಕ್ಲಾ ಹಳ್ಯಾ ಮ್ಯಾರ್‌ತ್ಯಾಲಾ ಹಾ” ಮನ್ಹುನ್ ಬಾಪ್ತಿಸ್ಮಾ ಯೊಹಾನಾಚೆ ಗುಶ್ಟಿತ್ ಪ್ರವಾದಿ ಜಾ಼ಲ್ಯಾಲ್ಯಾ ಯೆಶಾಯಾನಿ ಸಾಂಗ್ಲ ");
INSERT INTO gok_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","ಬಾಪ್ತಿಸ್ಮಾ ಯೊಹಾನ್ ಹುಟಾಚಾ ಕೇಸಾಂಚ಼ ಕಪ್ಡ ಗಾಲಿತಾ. ತ್ಯಚೆ ಕಂಬ್ರತ್ ಚ಼ಮ್‌ಡ್ಯಾಚ಼ಾ ಪಟ್ಟಾ ಹುತ್ತಾ. ತ್ಯೊ ಟ್ವಾಳ್ ರಾನಾತ್ಲ ಮಹು ಜೆವಾನ್ ಮನ್ಹುನ್ ಖಾಯಿತಾ. ");
INSERT INTO gok_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","ಲೊಕ ಬಾಪ್ತಿಸ್ಮಾ ಯೊಹಾನಾಪ ಯೆರುಸಲೇಮಿತ್ಲಿ ಯುದಾಯಾ ಆನಿ ಯೊರ್ದಾನ್ ನ್ಹಚೆ ಸರ್ ಬೌತಿ ಸಗ್ಳಿಕ್ನಿ ಯೊಹಾನಾಪ ಯಯಿತಿತ. ");
INSERT INTO gok_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ಲೊಕಾಂಚಾನಿ ಆಪ್ನು ಕೆಲ್ಯಾಲ್ಯಾ ಚು಼ಕಿ ವ್ಹಯ್ ಮನ್ಲಿತ ತವಾ ಬಾಪ್ತಿಸ್ಮಾ ಯೊಹಾನಾನಿ ತ್ಯನಾ ಯೊರ್ದಾನ್ ನ್ಹತ್ ಬಾಪ್ತಿಸ್ಮಾ ದಿಯಿತಾ. ");
INSERT INTO gok_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","ಕಿತೀಕಿ ಫರಿಸಾಯ್ ಆನಿ ಸದುಕಾಯ್ ಬಾಪ್ತಿಸ್ಮಾ ಯೊಹಾನಾಪ್ನಿ ಬಾಪ್ತಿಸ್ಮಾ ಗಿಹ್ಯಾ ಆಲ. ಬಾಪ್ತಿಸ್ಮಾ ಯೊಹಾನಾನಿ ತ್ಯನಾ ಬಗುನ್ “ಸಾಪಾಚಾ ಪೊರಾಂಚಾನು” ಯತ್ಯಾಲ್ಯಾ ದೇವಾಚಾ ರಾಗಾತ್ನಿ ಚು಼ಕ್ವುನ್ ಗಿಹ್ಯಾ ತುಮಾನಾ ಜಾ಼ಗೃತ್ ಕೆಲ್ಯಾಲ ಕುನಿ? ");
INSERT INTO gok_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","ತುಮಿ ಪಾಪ ಸ್ಯೊಡ್‌ಲ್ಯಾಸಾ ಮನ್ಹುನ್ ತುಮಚಾ ಕರ್ತ್ಯಾಲ್ಯಾ ಕಾಮಾಂಚಾನಿ ದಾವಾ. ");
INSERT INTO gok_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","ಅಬ್ರಹಾಮ್ ಆಮಚಾ಼ ವಡಿಲ್ ಮನ್ಹು‍ನ್ ತುಮಿ ದೇವಾಚಾ ನ್ಯಾಯಾತ್ನಿ ಚು಼ಕ್ನಾರ್ ಮನ್ಹುನ್ ಸಮಜ಼ು ನಕೊಸಾ ದೇವ್ ಅಬ್ರಮಾಲಾ ಹ್ಯಾ ದೊಂಢ್ಯಾಂಚಾನಿ ಪೊರ ದಿವು ಸಕ್ತೊ ಮನ್ಹುನ್ ಮಿ ತುಮಾನಾ ಸಾಂಗ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","ಜಾ಼ಢ ತುಡುನ್ ಟಾಕಾಯಾ ಕುರ‍್ಯಾಡ್ ಆತಾಸ್ ತಯಾರ್ ಹಾ ಚಾ಼ಂಗ್ಲ ಫಳ್ ದಿಯಿ ನಸ್ನಾರ ಪರ್ತೇಕ್ ಝಾ಼ಡ್ ಮುಳಾತ್ನಿ ತುಡುನ್ ಇಸ್‌ಥ್ಯಾತ್ ಗ್ಯಾಲ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","ತುಮಿ ಪಾಪ ಸುಡ್ಲಿಸಾ ಮನ್ಹುನ್ ದಾವುನ್ ದಿಯಾ ಸಾಟಿ ಮಿ ತುಮಾನಾ ಪಾನ್ಯಾನಿ ಬಾಪ್ತಿಸ್ಮಾ ದೇತೊ ಫನ್ ಮಾಜೆ ಮಾಗ್ನಿ ಯತ್ಯಾಲಾ ಮಾಜಿವ್ನಿ ಮೊಟಾ ತ್ಯಚೆ ವ್ಹಾನಚಾ಼ ಪಠಾ ಸುಡುನ್ ಕಾಡಾಯಾಬಿ ಮಿ ಬರಾ ನಾಹಿ ತ್ಯೊ ತುಮಾನಾ ಪವಿತ್ರಾತ್ಮಾನಿ ಇಸ್‍ಥ್ಯಾತ್ನಿ ಬಾಪ್ತಿಸ್ಮಾ ದೀಯಿಲ್. ");
INSERT INTO gok_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","ತ್ಯೊ ದಾನ ವಾರ‍್ಯಾ ಕರಾಯಾ ಸೂಪ್ ಹಾತಾತ್ ದರ‍್ಹುನ್ ಉಬಾ ಹಾ. ತ್ಯೊ ದಾನ ಚಿಂಬಾತ್ನಿ ಯಗಳುನ್ ಚಾ಼ಂಗ್ಲ ದಾನ ಕಳಂಜಾ಼ತ್ ಬರ‍್ಹುನ್ ವ್ಹಟ್ ಇಜ಼ತ್ ನಸ್‍ಲ್ಯಾಲ್ಯಾ ಇಸ್‌ಥ್ಯಾನಿ ಜಾಳನಾರ್ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","ತ್ಯಾ ಯಳಾಲಾಸ್ ಬಾಪ್ತಿಸ್ಮಾ ಯೊಹಾನಾಪ್ನಿ ಯೇಸು ಬಾಪ್ತಿಸ್ಮಾ ಗಿಹ್ಯಾಲಾ ಗಲಿಲಾಯಾತ್ನಿ ಯೊರ್ದಾನ್ ನ್ಹಪ ಆಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","ಫನ್ ಯೊಹಾನಾನಿ, “ಮಿ ತುಜಿಪ್ನಿ ಬಾಪ್ತಿಸ್ಮಾ ಗಿಹ್ಯಾ ವ್ಹಯಿ ಆಸ್ಥಾನಾ ಮಾಜಿಪ್ನಿ ಬಾಪ್ತಿಸ್ಮಾ ಗಿಹ್ಯಾ ತು ಯಯಾಚ಼ ಕ್ಯಾ ಮನ್ಹುನ್ ಸಾಂಗುನ್ ತ್ಯಲಾ ಥಾಂಬ್ವಾಯಾ ಬಗಿತಾ. ");
INSERT INTO gok_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","ತವಾ ಯೇಸು, “ಆತಾ ಹು ಮನ್. ಆಸಿ ಆಮಿ ದೇವಾಚಿ ಚಾ಼ಂಗ್ಲಿ ಕಾಮ ಕರಾಯಾ ವ್ಹಯಿತ” ಮನ್ಲಾ. ತವಾ ಬಾಪ್ತಿಸ್ಮಾ ಯೊಹಾನ್ ಯೇಸುಲಾ ಬಾಪ್ತಿಸ್ಮಾ ದಿಯಾ ಹು ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","ಯೇಸು ಬಾಪ್ತಿಸ್ಮಾ ಗಿಹುನ್ ಪಾನ್ಯಾತ್ನಿ ವರ್ ಆಲಾ ತವಾಸ್ ಆಬಾಳ್ ಉಗಾಡ್ಲ. ದೇವಾಚ಼ ಆತ್ಮ ಪ್ಯಾರ್‌ವ್ಯಾಚೆಗತ್ ಖಾಲ್ ಉತ್ರುನ್ ಆಪ್ಲಿವ ಯತ್ಯಾಲ ಯೇಸುನಿ ಬಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","ತವಾ ಸ್ವರ್ಗಾತ್ನಿ ಯೊಕ್ ಆವಾಜ಼್ ಯವುನ್ ಹ್ಯೊ ಯೇಸುಸ್ ಮಾಜೆ ಮಾಯಾಚಾ಼ ಲ್ಯೊಕ್ ಹ್ಯನಿ ಮನಾ ಸಂತೊಶ್ ಜಾ಼ಲಾ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","ತವಾ ದೇವಾಚಾ ಆತ್‌ಮ್ಯಾನಿ ಸೈತಾನಾಪ್ನಿ ಪರಿಕ್ಶೆ ಕರಾಯಾ ಯೇಸುಲಾ ರಾನಾತ್ ನೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","ಆನಿ ತ್ಯನಿ ಚಾಳಿಸ್ ರ‍್ಯಾತ್ ದೀಸ್ ಉಪಾಸ್ ಕೆಲಾ ನಂತರ್ ತ್ಯಲಾ ಖುಬ್ ಬುಕ್ ಲಾಗ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","ತವಾ ತ್ಯಚಿ ಪರಿಕ್ಶೆ ಕರಾಯಾ ಸೈತಾನ್ ಯವುನ್, “ತು ದೇವಾಚಾ಼ ಲ್ಯೊಕ್ ಹಾಸ್ತ ಹ್ಯಾ ದೊಂಡ್ಯಾಚಾ ಬಾಖರ‍್ಯಾ ಹೊ ಮನ್ಹುನ್ ಸಾಂಗ್. ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","ಯೇಸುನಿ ತ್ಯಲಾ, “‘ಮಾನುಸ್ ನಿಸ್ತೆ ಬಾಕ್ರಿನಿ ಜ಼ಗತ್ ನಾಹಿ, ಮಾನ್ಸಾಚ಼ಾ ಜೀವ್ನಾ ದೇವಾನಿ ಸಾಂಗ್‍ಲ್ಯಾಲೆ ಪರತೇಕ್ ಬುಲಿಲಾ ಆಧಾರ್ ಜಾ಼ಲ್ಯಾ’ ಮನ್ಹುನ್ ಪವಿತ್ರ ಪುತೀಕಾತ್ ಲಿವ್‍ಲ್ಯಾ” ಮನ್ಹುನ್ ಜ಼ಬಾಬ್ ದಿಲಾ ");
INSERT INTO gok_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","ತವಾ ಸೈತಾನಾನಿ ಯೇಸುಲಾ ಪವಿತ್ರ ಯೆರುಸಲೇಮ್ ಪೆಠತ್ ಹಾಕ್ಟುನ್ ನಿಹುನ್ ದೇವ್ಳಾಚಾ ಟೊಕಾವ ಉಬಾ ಕರುನ್ ");
INSERT INTO gok_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ತು ದೇವಾಚಾ಼ ಲ್ಯೊಕ್ ಆಸ್ಲಾಸ್ತ ಹಿತ್ನಿ ಖಾಲ್ ಉಡಿ ಮ್ಯಾರ್. ದೇವ್ ತುಜಿ ಸಾಟಿ ಆಪ್‍ಲ್ಯಾ ಧುತಾನಾ ಹುಕುಮ್ ದಿಯಿಲ್. ತುಜ಼ ಪ್ಯಾ ದೊಂಡ್ಯಾನಾ ಆದ್ಳಾಚೆ ಆಂದಿ ತೇ ತುಲಾ ಹತಾತ್ ಉಚ್ಲು಼ನ್ ದರ್ಥಿಲ. ಮನ್ಹುನ್ ಪವಿತ್ರ ಗ್ರಂಥಾತ್ ಲಿವ್‌ಲ್ಯಾ ನವ್ಹ. ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","ತ್ಯಲಾಸ್ ಯೇಸುನಿ, “ತುಜಾ಼ ದೇವ್‍ ಜ಼ಾಲ್ಯಾಲ್ಯಾ ಪ್ರಭುಚಿ ಪರಿಕ್ಶೆ ಕರು ನಕೊಸ್” ಮನ್ಹುನ್ ಪವಿತ್ರ ಪುತೀಕ್ ಸಾಹಿತ್ ಆಸ ಸಾಂಗ್ತ” ಮನ್ಹುನ್ ಜ಼ವಾಬ್ ದಿಲಾ ");
INSERT INTO gok_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","ಮಂಗ್ ಸೈತಾನಾನಿ ಯೇಸುಲಾ ಮೊಟ್ಯಾ ಗುಢ್ಯಾವ ನಿಹುನ್ ಪರಪಂಚಾತ್ಲ ರಾಜೆ ಸಗ್ಳ ಆನಿ ತ್ಯಚಿ ಸಗ್ಳಿ ಸೊಭಾ ದಾವುನ್, ");
INSERT INTO gok_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","ಸೈತಾನ್ ಯೇಸುಲಾ ತು ಮನಾ ಆರಾದನ್ ಕೆಲ್ಯಾವ ಮಿ ತ್ಯ ಸಗ್ಳ ತುಲಾ ದಿಯಿನ್ ಮನಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","ಯೇಸು ಸೈತಾನಾಲಾ, “ಮಾಜಿಪ್ನಿ ಜಾ಼! ತುಜಾ಼ ಪ್ರಭು ತುಜಾ಼ ದೇವ್ ತ್ಯಲಾ ಆರಾದನ್ ಕರ್ ಆನಿ ತ್ಯಚಾ ಪಾಯಾ ಪಡ್ ಮನ್ಹುನ್ ಪವಿತ್ರ ಪುತೀಕಾತ್ ಲಿವ್‌ಲ್ಯಾ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","ತವಾ ಸೈತಾನ್ ಯೇಸುಲಾ ಸುಡುನ್ ಗೆಲ ಆನಿ ಥೊಡ್ಯಾ ದೇವ್ ದುತಾಂಚಾನಿ ಯವುನ್ ತ್ಯಚಿ ಸೇವಾ ಕಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","ಬಾಪ್ತಿಸ್ಮಾ ಯೊಹಾನಾಲಾ ಕ್ಯೊಂಡ್‍ಲ್ಯಾ ಮನ್ಹುನ್ ಯೇಸುಲಾ ಸಮಾಜ಼್ಲ ತವಾ ಯೇಸು ಗಲಿಲಾಯ್ ಸಿಮತ್ ಗೆಲಾ ");
INSERT INTO gok_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","ತ್ಯೊ ನಜ಼ರೇತಿತ್ ಉತ್ರಾಚೆ ಆಂದಿ ನಿಗುನ್ ಜಾ಼ವುನ್ ಗಲಿಲಾಯ್ ಸಮಿಂದೊರಾಚೆ ಜ಼ವಳ್ ಆಸ್‍ಲ್ಯಾಲ್ಯಾ ಕಪೆರ್ನೌಮ್ ಗಾವಾತ್ ರಾಯ್ಲಾ ಹಿ ಪ್ಯಾಟ್ ಜೆಬುಲೊನ್ ಆನಿ ನಫ್ತಾಲಿ ಸಿಮಚೆ ಜ಼ವಳ್ ಹಾ ");
INSERT INTO gok_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","ಪ್ರವಾದಿ ಜಾ಼ಲ್ಯಾಲ್ಯಾ ಯೆಶಾಯಾನಿ ಸಾಂಗ್‍ಲ್ಯಾಲ್ಯಾ ಬೊಲ್ಯಾ ಆಶಾ ಗಡ್‍ಲ್ಯಾ ತ್ಯಾ ಕ್ಯಾ ಮಂಜೆ ");
INSERT INTO gok_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","ಜೆಬುಲೊನ್ ಸಿಮತ್ಲಿ ನಪ್ತಾಲಿ ಸಿಮತ್ಲಿ ಯೊರ್ದಾನ್ ನ್ಹಚೆ ಪಲಿಕ್ಲೆ ಸಿಮತ್ಲಿ, ಸಮಿಂದೊರಾಕ್ಡ ಆಸ್‍ಲ್ಯಾಲೆ ಸಿಮತ್ಲಿ, ಯೆಹುದಿ ನಸ್‍ಲ್ಯಾಲಿ ಗಲಿಲಾಯ್ ಸಿಮತ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ಲೊಕ ಆಂದಾರಾತ್ ಹುತ್ತಿತ. ತವಾ ತ್ಯನಾ ಮೊಟಾ ಯೊಕ್ ಉಜಿಡ್ ದಿಸ್ಲಾ. ಮರ್ನಾಚಾ ಕಾಳೊಕಾತ್ ರಾಥ್ಯಾಲ್ಯಾ ತ್ಯಾ ಲೊಕಾನಾ ಉಜಿಡ್ ಗಾವ್ಲಾ. ” ");
INSERT INTO gok_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","ತವಾಚಾನ್ ಯೇಸುನಿ ಸಿಕ್ವಾಚ಼ ಚಾ಼ಲು ಕೆಲ. “ದೇವಾಚ಼ ರಾಜೆ ಜ಼ವಳ್ ಹಾ ಮನ್ಹುನ್ ತುಮಿ ತುಮ್ಚಿ ಪಾಪ ಸೋಡಾ” ಆಸ ಯೇಸುನಿ ಸಿಕಿವ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","ಗಲಿಲಾಯ್ ಸಮಿಂದೋರಾಕ್ಡ ಯೇಸು ಫಿರತಾನಾ. ತ್ಯನಿ ಸಿಮೊನ್ ಹ್ಯಲಾಸ್ ಪೇತ್ರ ಮನ್ಹುನ್ ಹಕ್ಟಿತಾ. ಆನಿ ಸಿಮೊನಾಚಾ಼ ಬಾಹು ಆಂದ್ರೆಯಾಲಾ ಬಗ್ಲಾ ಹೆ ದೊಗ ಮಾಸ ದರ್ತ್ಯಾಲ ತ್ಯಾ ಸಮಿಂದೊರಾತ್ ಬಲಿ ಗಾಲ್ಹುನ್ ಮಾಸ ದರಿತ. ");
INSERT INTO gok_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","ಯೇಸು ತ್ಯನಾ “ಮಾಜೆ಼ ಮಾಗ್ನಿ ಯವಾ; ತುಮಿ ಲೊಕಾನಾ ದೇವಾಸಾಟಿ ಹಾಕಟ್ಯಾಲ ಕರ್ತೊ” ಮನ್ಲಾ ");
INSERT INTO gok_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","ತವಾಸ್ ಸಿಮೊನ್ ಆನಿ ಆಂದ್ರೇಯ್ ಆಪ್ಲಿ ಜಾ಼ಳಿ ಸುಡುನ್ ತ್ಯಚೆ ಮಾಗ್ನಿ ಗೆಲ. ");
INSERT INTO gok_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","ಯೇಸು ಗಲಿಲಾಯ್ ಸಮೀಂದೊರಾಚೆ ದರನಿ ಚಾ಼ಲತ್ ಜಾ಼ತಾನಾ ಜೆಬೆದಾಯಾಚ಼ ಲ್ಯಾಕ್ ಯಾಕೊಬ್ ಆನಿ ಯೊಹಾನ್ ಹ್ಯಾ ದೊಗಾ ಬಾವ್ಹಾನಾ ಬಗ್ಲ ತೇ ಆಪ್‍ಲ್ಯಾ ಬಾ ಜೆಬೆದಾಯಾಚೆ ಸಂಗ ವ್ಹಡಿತ್ ಹುತ್ತ ತೆ ಮಾಸ ದರಾಯಾ ಆಪ್ಲಿ ಜಾ಼ಳಿ ಶಾರ್ಕಿ ಕರೀತ್ ಹುತ್ತ. ತವಾ ಯೇಸುನಿ ತ್ಯನಾ ಹಾಕಟ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ತವಾಸ್ ತೆ ವ್ಹಡಿ ಆನಿ ಆಪ್‌ಲ್ಯಾ ಬಾಲಾ ಸುಡುನ್ ತ್ಯಚೆ ಮಾಗ್ನಿ ಗೆಲ. ");
INSERT INTO gok_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","ಯೇಸು ಗಲಿಲಾಯಾ ಸಿಮತ್ ಗೆಲಾ ಆನಿ ಯೆಹುದ್ಯಾಂಚಾ ಸಭಾಸ್ಥಾನಾತ್ನಿ ಸಿಕಿವ್ಲ ಆನಿ ಸ್ವರ್ಗಾಚಾ ರಾಜಾಚೆ ಗುಶ್ಟಿತ್ ಚಾ಼ಂಗ್ಲಿ ಖಬರ್ ಸಿಕಿವ್ಲಿ. ಯೇಸುನಿ ಸಗ್‍ಳ್ಯಾ ಲೊಕಾಂಚಿ ಧುಖ್ನಿ ಆನಿ ರ‍್ವಾಗ್ ಬರ ಕೆಲ. ");
INSERT INTO gok_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","ಯೇಸುಚಿ ಖಬರ್ ಸಿರಿಯಾ ದೇಶೆತ್ ಪಗಾಳ್ಳಿ. ಲೊಕಾಂಚಾನಿ ಧುಖ್ನಿ ಆಸ್‍ಲ್ಯಾಲ್ಯಾನಾ ಯೇಸುಪ ಆನ್ಲಿತ. ತೀ ಖುಬ್ ತರಚಾ ರಾಗಾತ್ನಿ ಆನಿ ದುಕ್‍ನ್ಯಾತ್ನಿ ತರಾಸ್ ಖಾಯಿತಿತ. ಥುಡಿ ಖುಬ್ ದುಖಾನಿ ತಳ್ಮಳಿತಿತ. ಆನಿ ಥುಡಿ ಭುಥಾಂಚಾನಿ ದರ್‌ಲ್ಯಾಲಿ ಹುತ್ತಿತ. ಥುಡಿ ಫೀಟಚಾ ರೊಗಾಚಿ ಹುತ್ತಿತ. ಆನಿ ಥುಡಿ ಲಕ್ವಾ ಮ್ಯಾರ್‌ಲ್ಯಾಲಿ ಹುತ್ತಿತ. ಯೇಸುನಿ ಹ್ಯನಾ ಸಗ್‍ಳ್ಯಾನಾ ಬರಿ ಕಿಲಿತ. ");
INSERT INTO gok_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","ಖುಬ್ ಲೊಕ ಯೇಸುಚೆ ಮಾಗ್ನಿ ಗಿಲಿತ. ಹಿ ಲೊಕ ಗಲಿಲಾಯಾತ್ನಿ ಗಾವಾಚಾ ಪರದೇಶಾತ್ನಿ ಯೇರುಸಲೇಮಿತ್ನಿ ಯುದಾಯಾತ್ನಿ ಆನಿ ಯೊರ್ದಾನ್ ನ್ಹಚೆ ಪಲಿಕಲ್ಯಾ ಜಾ಼ಗ್ಯಾತ್ನಿ ಆಲ್ತಿತ. ");
INSERT INTO gok_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","ಯೇಸುನಿ ಹ್ಯಾ ಲೊಕಾಂಚಾ಼ ಮೇಳಾ ಬಗುನ್ ಗುಢ್ಯಾವ ಜಾ಼ವುನ್ ಬಸ್ಲಾ. ತ್ಯಚ಼ ಶಿಶಾ ಸಾಹಿತ್ ತ್ಯಚೆ ಸರ್ಬೌತ ಜ಼ಮ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ತವಾ ಯೇಸುನಿ ಲೊಕಾನಾ ಹ್ಯ ಗಿನ್ಯಾನ್ ಸಿಕಿವ್ಲ: ");
INSERT INTO gok_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“ದೇವಾವ ಇಸ್ವಾಸ್ ಥೆವ್ನಾರಿ ಸಂತೊಸ್ ಜಾ಼ಲ್ಯಾತ. ಸ್ವರ್ಗಾಚ಼ ರಾಜೆ ತ್ಯಂಚ಼. ");
INSERT INTO gok_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","ಆತಾ ದುಖಾನಿ ಆಸ್‍ಲ್ಯಾಲಿ ಸಂತೊಸ್ ಹಾಸಾ. ದೇವ್ ತ್ಯನಾ ಸಮಜಾವ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","ಥಂಡ್ ಫನಾನಾನಿ ರಾಥ್ಯಾಲಿ ಸಂತೊಸ್ ಜಾ಼ಲ್ಯಾಸಾ. ದೇವಾನಿ ದಿಲ್ಯಾಲ್ಯಾ ವಚ್ನಾಚಿ ಜಿಮಿನ್ ತೀ ಗೆನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","ದೇವಾಚೆ ನದ್ರಲಾ ಚಾ಼ಂಗ್ಲ ಆಸ್‌ಲ್ಯಾಲ ಕರಾಯಾ ಮನ್ ಆಸ್‌ಲ್ಯಾಲಿ ತುಮಿ ಸಂತೊಸ್ ಜಾ಼ಲ್ಯಾಸಾ. ದೇವ್ ತುಮಾನಾ ಸಮಾಧಾನ್ ದೇನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","ದುಸ್‌ರ‍್ಯಾನಾ ಕರ್ನಾ ದ್ಯಾವ್ನಾರಿ ತುಮಿ ಸಂತೊಸ್ ಜಾ಼ಲ್ಯಾಸಾ. ತ್ಯನಾ ಕರ್ನಾ ಮಿಳಲ್. ");
INSERT INTO gok_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","ನಿಚ಼ಳ್ ಮನಾಚಿ ತುಮಿ ಸಂತೊಸ್ ಜಾ಼ಲ್ಯಾಸಾ. ತೀ ದೇವಾಲಾ ಬಗ್ತಿಲ. ");
INSERT INTO gok_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","ಶಾಂತ್ ಕರ್ತ್ಯಾಲಿ ತುಮಿ ಸಂತೊಸ್ ಜಾ಼ಲ್ಯಾಸಾ. ತೀ ‘ದೇವಾಚಿ ಪೊರ’ ಮನ್ಹುನ್ ಗಿತಿಲ. ");
INSERT INTO gok_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","ಚಾ಼ಂಗಲ್ಯಾಸ್ ಲಾಗುನ್ ಜಾ಼ಸ್ ಗೆನಾರಿ ತುಮಿ ಸಂತೊಸ್ ಜಾ಼ಲ್ಯಾಸಾ. ಸ್ವರ್ಗಾಚ಼ ರಾಜೆ ತ್ಯಂಚ಼ಸ್. ");
INSERT INTO gok_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","ತುಮಿ ಮಾಜೆ ಮಾಗ್ನಿ ಯತಾಸಾ ಮನ್ಹುನ್ ಲೊಕಾಂಚಾನಿ ತುಮ್ಚಿ ನಿಂದಾ ಕಿಲಿಕಿ. ಜಾ಼ಚ಼್ ಕೇಲಾಕಿ ನಾಹಿತ ತುಮ್ಚಿವ ಬುರ‍ಶಾ ಗುಶ್ಟಿ ವಾವಲ್ಯಾವ ತುಮಿ ಬರಿ. ");
INSERT INTO gok_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","ಆನಂದಾನಿ ರಾವ್ಹಾ ಸ್ವರ್ಗಾತ್ ತುಮ್ಚಿ ಸಾಟಿ ಥೆವ್‍ಲ್ಯಾಲ ಪ್ರತಿ ಫಳ್ ತುಮಾನಾ ಗಾವಲ್. ತುಮ್ಚೆ ಆಂದಿ ಆಸ್‍ಲ್ಯಾಲ್ಯಾ ಪ್ರವಾದಿನಾ ಲೊಕಾಂಚಾನಿ ಆಸಸ್‍ ಕೆಲ್ತ. ");
INSERT INTO gok_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","ತುಮಿ ದರ್ಥಿವ್‌ಲ್ಯಾ ಲೊಕಾನಾ ಮಿಠಾಚೆಗತ್ ಜಾ಼ಲ್ಯಾಸಾ. ಫನ್ ಮಿಠಾನಿ ಆಪ್ಲಿ ಚ಼ವ್ ಸಾಂಡುನ್ ಗಿತ್ಲಿಕಿ ತ್ಯಲಾ ಆನಿಕ್ ಮಿಠಾಚಿ ಚ಼ವ್ ಕರಾಯಾ ವ್ಹಯಿತ್ ನಾಹಿ ತಸ್‍ಲ್ಯಾ ಮಿಠಾನಿ ಕಾಯೇಕ್ ಉಪೆಗ್ ನಾಹಿ ಲೊಕ ತ್ಯ ಗಿಹುನ್ ಬಾಹಿರ್ ಟಾಕುನ್ ತುಡಿವ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","ತುಮಿ ದರ್ಥಿವ್‌ಲ್ಯಾ ಲೊಕಾನಾ ಉಜಿಡಾಚೆಗತ್ ಜಾ಼ಲ್ಯಾಸಾ. ಗುಢ್ಯಾವ ಬ್ಯಾಂದ್‍ಲ್ಯಾಲಾ ಗಾವ್ ದಡುನ್ ರಾನ್ಹಾರ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","ಲೊಕ ದಿವಾ ಲಾವುನ್ ಐದಾನಾ ಬುಡಿ ಥಿವಿತ್ ನಾಹಿತ ದಿವ ಲ್ಯಾವ್‍ನ್ಯಾವ ಥೆವ್‍ತ್ಯಾತ ತವಾ ಗರ‍್ಹಾತ್ ಆಸ್ನಾರ‍್ಯಾನಾ ಉಜಿಡ್ ದಿಸ್ತೊ ");
INSERT INTO gok_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","ತಸಸ್ ತುಮಿ ಲೋಕಾನಾ ಉಜಿಡ್ ವ್ಹವುನ್ ರಾಹ್ಯಾ ವ್ಹಯಿ. ಆಸಿ ತುಮ್ಚಿ ಚಾ಼ಂಗ್ಲಿ ಕಾಮ ಬಗುನ್ ಸ್ವರ್ಗಾತ್‍ಲ್ಯಾ ತುಮ್ಚಾ ಬಾಲಾ ವವ್ಯಾಳುನ್ತ. ");
INSERT INTO gok_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","ಮಿ ಮೊಶೆಚ಼ ಧರ್ಮ ಶಾಸ್ತಾರ್ ವ್ಹವುನಿ ಪ್ರವಾದಿಚ಼ ಸಿಕಿವ್ನ ವ್ಹವುನಿ ಕಾಡಾಯಾ ಆಲ್ಯೊ ಮನ್ಹುನ್ ಸಮಜು಼ ನಕೊಸಾ ಮಿ ತೀ ಕಾಡಾಯಾ ನವ್ಹ ತ್ಯ ಪುರ್ನ ಕರಾಯಾ ಆಲ್ಯೊ. ");
INSERT INTO gok_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","ಮಿ ತುಮಾನಾ ಖರ ಸಾಂಗ್ತೊ ಆಬಾಳ್ ದರ್ಥಿ ಪುಸುನ್ ಜಾ಼ಯಿ ಪರೇತ್ ಪುತಿಕಾತ್ಲ ಸಗ್ಳ ಪುರ್ನ ವ್ಹಯಿ ಪರತ್ ತ್ಯಾತ್ಲ ಯಾಕ್ ಅಕ್ಷಾರ್ ನಾಹಿತ ತ್ಯಾತ್ಲಾ ಯೊಕ್ ಟಿಕ್ಕಾ ಪುಸುನ್ ಜಾ಼ನಾರ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","ಮಾನುಸ್ ಪ್ರತೇಕ್ ಹುಕ್ಮಾಲಾ ಮಂಜೆ ಬ್ಯಾರ್‌ಕ್ಯಾ ಬ್ಯಾರ್‌ಕ್ಯಾ ಹುಕ್ಮಾ ಶಾರ್ಕ ಚಾ಼ಲಾಯಾ ಪಾಯ್ಜೆ ಕುನಿ ಯಕಾನಿ ಹುಕ್ಮಾ ಶಾರ್ಕಾ ಚಾ಼ಲಾಚೆ ಆಂದಿ ತ್ಯಾ ಹುಕ್ಮಾ ಶಾರ್ಕ ದಿಸರ‍್ಯಾನಾ ಚಾ಼ಲಾಯಾ ಸಾಂಗ್‌ಲ್ಯಾವ ತ್ಯೊ ಖುಬ್ ಬಾರೀಕ್ ವ್ಹನಾರ್. ತ್ಯೊ ಸ್ವರ್ಗಾಚಾ ರಾಜಾತ್ ಬಾರಿಕ್ ವ್ಹನಾರ್ ಫನ್ ಮೊಶೆಚಾ ಧರ್ಮ ಶಾಸ್ತಾರಾಚೆಗತ್ ಚಾ಼ಲತ್ ಧರ್ಮಶಾಸ್ತಾರಾಲಾ ಆತ್ ವ್ಹವುನ್ ರಾಹ್ಯಾ ದುಸ್‍ರ್ಯಾನಾ ಸಾಂಗ್‌ತ್ಯಾಲಾ ಸ್ವರ್ಗಾಚಾ ರಾಜಾತ್ ಮೊಟಾ ವ್ಹನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","ದೇವಾಚಾ ಮನಾ ಶಾರ್ಕ ಧರ್ಮೊಪದೇಶಾಂಚಿವ್ನಿ ಪರಿಸಾಯಾಂಚಿವ್ನಿ ತುಮಿ ಚಾ಼ಂಗ್ಲ ಕರಾಯಾ ವ್ಹಯಿ ನಾಹಿತ ತುಮಿ ಸ್ವರ್ಗಾಚಾ ರಾಜಾತ್ ಜಾ಼ಯಾ ವ್ಹಯಿತ್ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","ಕುನಾಚಾ಼ ಖುನ್ ಕರು ನಕೊಸಾ ಖುನ್ ಕರ್ತ್ಯಾಲಾ ನ್ಯಾಯಿತ್ ಗಾವಲ್ ಮನ್ಹುನ್ ಖುಬ್ ಕಾಲಾಚೆ ಮಾಗ ಆಮ್ಚಾ ಲೊಕಾನಾ ಸಾಂಗ್‌ಲ್ಯಾಲ ತುಮಿ ಐಕ್‌ಲ್ಯಾಸಾ ");
INSERT INTO gok_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","ಫನ್ ಮಿ ತುಮಾನಾ ಸಾಂಗಾಚ಼ ಕ್ಯಾ ಮಂಜೆ ಕುನಾವ ರಾಗ್ ಥಿವುನಕೊಸಾ ಸಗಳಬಿ ತುಜ಼ಸ್ ಬಾಹು. ತುಮಿ ದುಸ್‌ರ‍್ಯಾವ ರಾಗ್ ಕೆಲ್ಯಾವ ತುಮ್‍ಚಾ಼ ನ್ಯಾಯಿ ವ್ಹಯಿಲ್. ತುಮಿ ಕುನಾಲಾ ತರಿ ‘ಬುರ್ಸ’ ಬೊಲ್ಲಾಸಾತ ಯೆಹುದ್ಯಾಂಚಾ ನ್ಯಾಯಾತ್ ಗಾವ್ಸಿಲಾ ತುಮಿ ಕುನಾಲಾ ತರಿ ‘ಖುಳಾ’ ಮನ್ಹುನ್ ಮನ್ಲಾಸಾತ ಆಗ್ನಿಚಾ ನರ್ಕಾತ್ ಜಾ಼ಯಾಚಾ ಭ್ಯಾತ್ ಹಾಸಾ ");
INSERT INTO gok_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","ತ್ಯಚಿಸ್ ಲಾಗುನ್ ತುಮಿ ತುಮ್ಚಿ ದಿನ್ಗಿ ದೇವಾಚೆ ಮೊರ‍್ಹ ದೇತಾನಾ ತುಮ್ಚಾ ಬಾವ್ಹಾಚೆ ಗುಸ್ಟಿತ್ ಕಸ್ಲಾ ತರಿ ರಾಗ್ ಆಸಲ್ಯಾಲಾ ತುಮ್ಚೆ ಯದತ್ ಆಲಾತ. ");
INSERT INTO gok_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ತುಮ್ಚಿ ದಿನ್ಗಿ ದೇವಾಪಸ್ ಸುಡುನ್ ಆಂದಿ ಬಾವ್ಹಾಸಂಗ ರಾಜಿ ವ್ಹವಾ. ಪರತ್ ಯವುನ್ ತುಮ್ಚಿ ದಿನ್ಗಿ ದೇವಾ. ");
INSERT INTO gok_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","ತುಮ್‍ಚಾ಼ ವಾದಿ ತುಮಾನಾ ನ್ಯಾಯಿತ್ ವಡುನ್ ನೆತಾನಾ ಬಿಗಿನಿ ತ್ಯಚಿ ಸಂಗ ಸುಪ್ತಿ ವ್ಹವಾ. ತುಮಿ ನ್ಯಾಯಿತ್ ಜಾ಼ಯಾಚೆ ಆಂದಿಸ್ ಹ್ಯ ಕರಾಯಾ ವ್ಹಯಿ ನಾಹಿತ ತ್ಯೊ ತುಮಾನಾ ನ್ಯಾಯಿ ಕರ್ತ್ಯಾಲ್ಯಾಂಚಿಪ್ನಿ ದಿಯಿಲ್ ನ್ಯಾಯಿ ಕರ್ತ್ಯಾಲ ತುಮಾನಾ ತುರುಂಗಾಚಾ ಅಧಿಕಾರ‍್ಯಾಪ ದಿತಿಲ. ");
INSERT INTO gok_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","ಯೆಕ್ ದಮ್ಡಿ ಉರವಾಚೆ ಆಂದಿ ಸಗ್ಳ ದಿಯಿ ಪರ‍್ಯಾತ್ ತು ತಿತ್ನಿ ಯಯಾ ವ್ಹಯಿತ್ನಾಹಿ ಮನ್ಹುನ್ ತುಲಾ ಖರ ಸಾಂಗ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","ರಾಂಡ್ ಸಂಗತ್ ಕರು ನಕೊಸಾ ಮನ್ಹುನ್ ಸಾಂಗ್‍ಲ್ಯಾಲ ತುಮಿ ಐಕ್‌ಲ್ಯಾಸಾ. ");
INSERT INTO gok_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","ಫನ್ ಯಕಾನಿ ದುಸ್ರೆ ಬ್ಯಾಯ್ಕಾ ಮಾನ್ಸಾಲಾ ಬಗುನ್ ತಿಚಿವ ಮನ್ ಕೇಲತ ತ್ಯನಿ ತವಾಸ್ ಆಪ್‍ಲ್ಯಾ ಮನಾತ್ ತಿಚಿ ಸಂಗ ರಾಂಡ್ ಸಂಗ್ ಕೆಲಾ ಮನ್ಹುನ್ ಮಿ ತುಮಾನಾ ಸಾಂಗ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","ತುಜಾ಼ ಉಜ಼್ ವ್ಯಾಂಗ್‌ಚಾ಼ ಡೊಳಾ ತುಲಾ ಪಾಪಾತ್ ಪ್ಯಾಡ್‍ತ್ಯೊತ, ತ್ಯೊ ಕಾಡುನ್ ಟ್ಯಾಕ್. ತುಜ಼ ಸಗ್ಳ ಆಂಗ್ ನರಕಾತ್ ಜಾ಼ಯಾಚೆ ವಾಟ್ನಿಚ಼. ತುಜಾ಼ ಯೊಕ್ ಡೊಳಾ ನಸಲ್ಯಾವ ಕ್ಯವ್ಡ ಬರ. ");
INSERT INTO gok_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","ತುಜಾ಼ ಉಜ್ವಾ಼ ಹಾತ್ ತುಲಾ ಪಾಪಾತ್ ನಿಹಿತ್ ಆಸ್ಲಾತ. ತ್ಯೊ ತುಡುನ್ ಟ್ಯಾಕ್. ತುಜ಼ ಸಗ್ಳ ಆಂಗ್ ನರಕಾತ್ ಜಾ಼ಯಾಚೆ ವಾಟ್ನಿಚ಼ ತುಜಾ಼ ಯೊಕ್ ಹಾತ್ ನಸಲ್ಯಾವ ಬರ. ");
INSERT INTO gok_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","ಆಪ್ಲೆ ದನ್ಗರಿಲಾ ಸುಡುನ್ ದೆತೊ ಮನ್‍ತ್ಯಾಲಾ ತಿಲಾ ಶೊಡ್ ಸುಟಿಚ಼ ಪತ್ರ ಲಿವುನ್ ದಿವುನಿ ಮನ್ಹುನ್ ಸಾಂಗ್‍ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","ಫನ್ ಮಿ ಸಾಂಗಾಚ಼ ಕ್ಯಾ ಮಂಜೆ ಆಪ್ಲೆ ದನ್ಗರಿಲಾ ಶೊಡ್‍ತ್ಯಾಲಾ ತಿನಿ ರಾಂಡ್‍ ಸಂಗತ್ ಕರಾಯಾ ಕಾರನ್ ವ್ಹತೊ ಆನಿ ಬ್ಯಾಯ್ಕೊ ದುಸ್‌ರ‍್ಯಾ ಗಡ್ಯಾ ಸಂಗ ಹಾ ಮನ್ಹುನ್ ಸಮಾಜ್ಲತಸ್ ತಿಲಾ ದನ್ಗಾರಾನಿ ಸುಡುನ್ ದಿಯಾ ಗಾವ್ತ ಶೊಡ್ ಸುಟಿಚಿ ಚೀಟಿ ಗೇತಲ್ಯಾಲಿಲಾ ಲಗಿನ್ ವ್ಹತ್ಯಾಲಾ ತ್ಯೊ ಗಡಿ ಬೀ ರಾಂಡ್‍ ಸಂಗತ್ ಕರ್ತ್ಯಾಲಾ ವ್ಹತ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","ತುಮಿ ದಿಲ್ಯಾಲಿ ಶಪತ್ ವಲ್ಯಾಂಡು ನಕೊಸಾ ಪ್ರಭುವ ಥೆವ್‍ಲ್ಯಾಲಿ ಶಪತ್ ಚಾ಼ಲ್ವಾಲಾಸ್ ವ್ಹಯಿಸಾ, ಮನ್ಹುನ್ ಆಮ್ಚಾ ವಡ್ಲಾನಾ ಸಾಂಗ್‍ಲ್ಯಾಲ ತುಮಿ ಐಕ್‍ಲ್ಯಾಸಾ ");
INSERT INTO gok_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","ಫನ್ ಮಿ ತುಮಾನಾ ಸಾಂಗಾಚ಼ ಕ್ಯಾ ಮಂಜೆ ಶಪತ್ ಗಾಲು ನಕೊಸಾ ಆಬ್ಳಾವ ಶಪತ್ ಗಾಲುಕೊಸಾ ಕಾ ಮಂಜೆ ತ್ಯ ದೇವಾಚ಼ ಸಿಂಹಾಸನ್ ");
INSERT INTO gok_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ದರ್ಥಿವ ಶಪತ್ ಗಾಲು ನಕೊಸಾ ಕಾ ಮಂಜೆ ತಿಚಿವ ದೇವಾಚಾ಼ ಪ್ಯಾ ಹಾ ಯೇರುಸಲೇಮಿವ ಶಪತ್ ಗಾಲು ನಕೊಸಾ ಕಾ ಮಂಜೆ ತೀ ತ್ಯಾ ಮೊಟ್ಯಾ ರಾಜಾಚ಼ ಗಾವ್. ");
INSERT INTO gok_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","ತುಮ್ಚೆ ಡುಯಿವ ಶಪತ್ ಗಾಲು ನಕೊಸಾ ಕಾ ಮಂಜೆ ಡುಯಿತ್ಲಾ ಯೊಕ್ ಕ್ಯೊಸ್ ಪಾಂಡ್ರಾ ನಾಹಿತ ಕಾಳಾ ಕರಾಯಾ ತುಮ್ಚಿಪ್ನಿ ವ್ಹನಾರ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","ವ್ಹಯ್ ತ ‘ವ್ಹಯ್’ ಮನಾ. ನಾಹಿ ತ ‘ನಾಹಿ’ ಮನಾ. ಹ್ಯಚಿವ್ನಿ ಆಗಾವ್ ಸಾಂಗ್‍ತ್ಯಾಲ ಸೈತಾನಾಪ್ನಿ ಆಲ್ಯಾಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“‘ಡೊಳ್ಯಾಲಾ ಡೊಳಾ, ದಾತಾಲಾ ದಾತ್’ ಮನ್ಹುನ್ ಸಾಂಗ್‌ತ್ಯಾಲ ತುಮಿ ಐಕ್ಲಸಾ. ");
INSERT INTO gok_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","ಫನ್ ಮಿ ತುಮಾನಾ ಸಾಂಗ್‌ತ್ಯಾಲ ಕ್ಯಾ ಮಂಜೆ, ಬುರ್‌ಶಾಲಾ ಆಡ್ಯಾವು ನಕೊಸಾ. ಕುನಿತರಿ ತುಮ್ಚಾ ಉಜ಼್ ವ್ಯಾ ಗಾಲಾವ ಮ್ಯಾರ್ಲತ. ಆನಿ ಡಾವಾ ಗಾಲ್ ದಾವಾ. ");
INSERT INTO gok_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","ಕುನಿತರಿ ತುಮ್ಚಿ ವೈಲೆ ಆಂಗಿ ಮಾಗ್ಲಿತ ತುಮಿ ತುಮ್ಚಿ ಆತ್ಲಿ ಆಂಗಿ ಬಿ ತ್ಯಲಾ ದೇವಾ. ");
INSERT INTO gok_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","ಕಚಾ ತರಿ ಸೈನಿಕಾನಿ ಆಪ್ಲಿ ಸಂಗ ಯೇಕ್ ಮೈಲ್ ದುರ್ ಯಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಖುಬ್ ಹಾಕಟ್ಲತ ತ್ಯಚಿ ಸಂಗ ದೊನ್ ಮೈಲ್ ದುರ್ ಜಾ಼ವಾ. ");
INSERT INTO gok_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","ಕುನಿ ತರಿ ತುಮ್ಚಿಪ ಆಸ್‍ಲ್ಯಾಲ ಕಾಯ್ ತರಿ ಮಾಗ್ಲತ ತ್ಯಲಾ ದೇವಾ. ತುಮ್ಚಿಪ್ನಿ ಉಸ್ನ ಗಿಹ್ಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಆಲ್ಯಾಲ್ಯಾಲಾ ದಿಯಾಚೆ ಆಂದಿ ರಾಹು ನಕೊಸಾ. ");
INSERT INTO gok_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“‘ತುಜಾ ಸೊಪ್‍ತ್ಯಾಂಚಿ ಮಾಯಾ ಕರ್ ಆನಿ ತುಜಾ ವಾದಿಂಚಾ಼ ರಾಗ್ ಕರ್’ ಮನ್ಹುನ್ ಸಾಂಗ್‍ಲ್ಯಾಲ ತುಮಿ ಐಕ್ಲಸಾ. ");
INSERT INTO gok_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","ಖರ ಮಿ ತುಮಾನಾ ಸಾಂಗ್‍ತ್ಯಾಲ ಕ್ಯಾ ಮಂಜೆ ತುಮ್ಚಾ ವಾದಿಂಚಿ ಮಾಯಾ ಕರಾ ತುಮಾನಾ ತರಾಸ್ ಕರ್ತ್ಯಾಲ್ಯಾ ಲೊಕಾಂಚೆ ಸಾಟಿ ಮಾಗ್ನ ಕರಾ. ");
INSERT INTO gok_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ತವಾ ತುಮಿ ಸ್ವರ್ಗಾತ್‍ಲ್ಯಾ ತುಮ್ಚಾ ಬಾಚಿ ಖರಿ ಪೊರ ವ್ಹಸಿಲಾ. ತುಮ್‍ಚಾ಼ ಬಾ ಚಾ಼ಂಗಲ್ಯಾಂಚೆ ಸಾಟಿ ಆನಿ ಬುರ್ಶಾಂಚೆ ಸಾಟಿ ದೀಸ್ ಉಗಿವ್ನಾರ್ ಆನಿ ಪಾವುಸ್ ಶೊಡ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","ತುಮ್ಚಿ ಮಾಯಾ ಕರ್ತ್ಯಾಲ್ಯಾಚಿ ತುಮಿ ಮಾಯಾ ಕಿಲಿಸಾತ ತ್ಯನಿ ತುಮಾನಾ ಕ್ಯಾ ಫಾಯ್ದಾ ಗಾವ್ನಾರ್ ಜ಼ಖತ್ದಾರ್ ಸಾಹಿತ್ ತಸಸ್ ಕರ್ತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","ತುಮಿ ತುಮ್ಚಾ ಬಾವ್ಹಾಂಚೆ ಸಂಗ ತ್ಯವ್ಡಸ್ ಚಾ಼ಂಗ್ಲ ರಾಯ್ಲಾಸಾತ ತುಮಿ ದುಸ್‌ರ‍್ಯಾಂಚಿವ್ನಿ ಚಾ಼ಂಗ್ಲ ನವ್ಹಸಾ ದೇವಾಲಾ ಸಮಜು಼ನ್ ಗೇತಲ್ಯಾ ನಸ್ನಾಲಿ ಲೊಕ ಸಾಹಿತ್ ಆಸಿಸ್ ರಾಥ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","ಮನ್ಹುನ್ ಸ್ವರ್ಗಾತ್ ಆಸ್‍ನಾರಾ ತುಮಚಾ಼ ಬಾ ದೆವ್ ಸಗ್‌ಳ್ಯಾ ಗುಶ್ಟಿತ್ನಿ ನಿಫಕ್ ಹಾ ತಸಿ ತುಮಿ ನಿಫಕ್ ವ್ಹವುನ್ ರಾವ್ಹಾ. ");
INSERT INTO gok_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“ಹುಶಾರ್! ರಾವ್ಹಾ ತುಮಿ ಚಾ಼ಂಗ್ಲಿ ಕಾಮ ಲೊಕಾಂಚೆ ಮೊರ‍್ಹ ಕರು ನಕೊಸಾ. ಲೊಕ ಬಗುಂಥ ಮನ್ಹುನ್ ತುಮಿ ತಿ ಕೆಲ್ಯಾವ ಸ್ವರ್ಗಾತ್ ಆಸ್‍ಲ್ಯಾಲ್ಯಾ ತುಮ್ಚಾ ಬಾಪ್ನಿ ಪ್ರತಿ ಫಳ್ ಗಾವ್ನಾರ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“ತುಮಿ ಗರಿಬ್ ಲೊಕಾನಾ ದಾನ್ ಕೆಲ್ಯಾಲ ಸಾಂಗಿತ್ ಜಾ಼ವು ನಕೊಸಾ. ತುಮಿ ಕಪ್‌ಟ್ಯಾಂಚೆಗತ್ ಕರುನಕೊಸಾ. ಆಪ್ನು ದಾನ್ ಕೆಲ್ಯಾಲ ಲೊಕಾನಾ ದಾವಾಯಾ ಸಾಟಿ ಕಪ್ಟಿ ಸಭಾಸ್ಥಾನಾತ್ನಿ ಆನಿ ಪಾಂದಿತ್ನಿ ತುತ್ತುರಿ ವಾಜಿವ್‍ತ್ಯಾತ. ಮಿ ತುಮಾನಾ ಖರ ಸಾಂಗ್ತೊ ತ್ಯನಾ ಯಯಾ ಪಾಯ್ಜೆ ತ್ಯ ಪ್ರತಿ ಫಳ್ ಗಿಹುನ್ ಜಾ಼ಲ. ");
INSERT INTO gok_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","ಫನ್ ತುಮಿ ಗರಿಬ್ ಲೊಕಾನಾ ದೇತಾನಾ. ಉಜ಼್ ವ್ಯಾ ಹಾತಾನಿ ದಿಲ್ಯಾಲ ಡಾವ್ಯಾ ಹಾತಾಲಾಬಿ ಸಮಜು಼ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ತುಮಿ ದಾನ್ ಕರ್ತಾನಾ ಗಪ್ಚಿಪ್ ಕರಾ. ಗಪ್ಚಿಪ್ ಕರ್ತ್ಯಾಲಿ ಕಾಮ ಬಗ್‌ತ್ಯಾಲಾ ತುಮಚಾ಼ ಬಾ ತುಮಾನಾ ಪ್ರತಿ ಫಳ ದಿಯಿಲ್. ");
INSERT INTO gok_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“ತುಮಿ ಮಾಗ್ನ ಕರ್ತಾನಾ ಕಪಟ್ಯಾಚೆಗತ್ ಮಾಗ್ನ ಕರು ನಕೊಸಾ ಕಪಟಿ ಸಭಾಸ್ಥಾನಾತ್ ಆನಿ ಪಾಂದಿವ್ನಿ ಉಬರಾಹುನ್ ಜೊ಼ರಾನಿ ಮಾಗ್ನ ಕರಾಯಾ ಮನ್ ಕರ್ತ್ಯಾತ ಆಪ್ನು ಮಾಗ್ನ ಕರ್ತ್ಯಾಲ ಲೊಕ ಬಗುಂತ ಮನ್ಹುನ್ ತ್ಯಂಚ಼ ಮನ್ ತೆ ತವಾಸ್ ತ್ಯಚ಼ ಸಗ್ಳ ಪ್ರತಿಫಳ್ ಗಿಹುನ್ ಜಾ಼ಲ್ಹ ಮನ್ಹುನ್ ಮಿ ತುಮಾನಾ ಖರ‍್ಯಾನಿ ಸಾಂಗ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","ತುಮಿ ಮಾಗ್ನ ಕರ್ತಾನಾ, ತುಮ್ಚಾ ಸೊಪ್ಯಾತ್ ದಾರ್ ಗಾಲುನ್ ತುಮಾನಾ ದಿಸ ನಸ್ನಾರ‍್ಯಾ ತುಮ್ಚಾ ಬಾಪ ಮಾಗ್ನ ಕರಾ. ಗಪ್ಚಿಪ್ ಚಾ಼ಲತ್ಯಾಲಿ ಕಾಮ ಬಗ್‌ತ್ಯಾಲಾ ತುಮಚಾ಼ ಬಾ ತುಮಾನಾ ಪ್ರತಿ ಫಳ್ ದೇನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“ತುಮಿ ಮಾಗ್ನ ಕರ್ತಾನಾ ದೇವಾಲಾ ಸಮಜು಼ನ್ ಗೆತಲ್ಯಾ ನಸ್‌ಲ್ಯಾಲ್ಯಾ ಲೊಕಾಂಚೆಗತ್ ಮಾಗ್ನ ಕರು ನಕೊಸಾ. ತೀ ಅರ್ಥ ನಸ್‌ಲ್ಯಾಲ್ಯಾ ಗುಶ್ಟಿ ಸಾಂಗಿತ್ ರಾಥ್ಯಾತ. ತಸ ಮಾಗ್ನ ಕರು ನಕೊಸಾ ಆಪ್ನು ಖುಬ್ ಗುಶ್ಟಿ ಸಾಂಗ್ತಾನಾ ದೇವ್ ಆಪ್ಲ ಮಾಗ್ನ ಆಯಿಕ್ತೊ ಮನ್ಹುನ್ ತ್ಯಂಚಾ಼ ಇಚಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","ತುಮಿ ತ್ಯಂಚೆಗತ್ ವ್ಹವುನಕೊಸಾ ತುಮಿ ಮಾಗಾಚೆ಼ ಆಂದಿ ತುಮಾನಾ ಕ್ಯಾಕ್ಯಾ ವ್ಹಯಿ ತ್ಯ ತುಮ್ಚಾ ಬಾಲಾ ಠಾವ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","ಮನ್ಹುನ್ ತುಮಿ ಮಾಗ್ನ ಕರ್ತಾನಾ: ‘ಸ್ವರ್ಗಾತ್‌ಲ್ಯಾ ಆಮ್ಚಾ ಬಾ ದೆವಾ, ತುಜ಼ ಪವಿತ್ರ ನಾವ್ ವವ್ಯಾಳುಂತ. ");
INSERT INTO gok_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","ತುಜ಼ ರಾಜ ಯವುನಿ. ತುಜಾ ಮನಾಚೆಗತ್ ಸ್ವರ್ಗಾತ್ ಜಾ಼ಲ್ಯಾ ಶಾರ್ಕ ದರ್ಥಿವ ಬಿ ವ್ಹವುನಿ. ");
INSERT INTO gok_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","ಆಮ್‌ಚ಼ ಖಾಯಿಮಚ಼ ಜೆವಾನ್ ಹ್ಯಾ ಯಳಾಲಾ ಆಮಾನಾ ದೆ. ");
INSERT INTO gok_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","ಆಮಾನಾ ಚು಼ಕ್‍ ಕೆಲ್ಯಾಲ್ಯಾನಾ ಆಮಿ ಮಾಪ್‍ ಕೆಲ್ಯಾ ಶಾರ್ಕಿ ಆಮ್ಚಿ ಪಾಪ ಮಾಪ್ ಕರ್. ");
INSERT INTO gok_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","ಆಮಾನಾ ಪರಿಕ್ಶೆತ್ ಗಾಲಾಚೆ ಆಂದಿ ನಾಸ್ ಕರ್ತ್ಯಾಲ್ಯಾ ಸೈತಾನಾಪ್ನಿ ಆಮಾನಾ ರ‍್ಯಾಕ್. ");
INSERT INTO gok_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","ವ್ಹಯ್, ದುಸ್‌ರ‍್ಯಾಂಚಾನಿ ತುಮಾನಾ ಕೆಲ್ಯಾಲಿ ಚು಼ಕ್ ತುಮಿ ಮಾಪ್ ಕೆಲ್ಯಾವ, ಪರಲೊಕಾತ್ಲಾ ದೆವ್ ತುಮ್ಚಾ ಚು಼ಕಿ ಮಾಪ್ ಕರ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","ಫನ್ ಲೊಕಾಂಚಾನಿ ತುಮಾನಾ ಕೆಲ್ಯಾಲ್ಯಾ ಚು಼ಕಿ ತುಮಿ ಮಾಪ್ ಕೆಲ್ಯಾ ನಾಹಿಸಾತ, ಬಾ ದೇವ್ಬಿ ತುಮ್ಚಾ ಚು಼ಕಿ ಮಾಪ್ ಕರ್ನಾರ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“ತುಮಿ ಉಪಾಸ್ ಕರ್ತಾನಾ ತುಮಚ಼ ತ್ವಾಂಡ್ ಬಾವು ನಾಹಿ. ಕಪಟಿ ತಸಸ್ ಕರ್ತ್ಯಾತ ಫನ್ ತುಮಿ ಕಪಟಿಂಚೆಗತ್ ರಾಹು ನಕೊಸಾ. ಆಪ್ನು ಉಪಾಸ್ ಕರ್ತ್ಯಾಲ ಮನ್ಹುನ್ ಲೊಕಾನಾ ದಾವಾಯಾ ತೆ ಅಪ್ಲಿ ತೊಂಡ ಬಾವ್‌ಲ್ಯಾಚೆಗತ್ ಆಸ್‌ಥ್ಯಾತ. ತೆ ಕಪಟಿ ಆಪ್‌ಲ್ಯಾಲಾ ಯಯಾ ಪಾಯ್ಜೆ ತ್ಯ ಪ್ರತಿ ಫಳ್ ಸಗ್ಳ ಗಾವ್ಲ ಮನ್ಹುನ್ ಮಿ ತುಮಾನಾ ಖರ‍್ಯಾನಿ ಸಾಂಗ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","ಮನ್ಹುನ್ ತುಮಿ ಉಪಾಸ್ ಕರ್ತಾನಾ ತ್ವಾಂಡ್ ದುಹ್ಯಾವ್ಹಯಿ ಆನಿ ಡುಯಿಲಾ ತ್ಯಾಲ್ ಲಾವಾ. ");
INSERT INTO gok_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ತವಾ ತುಮಿ ಉಪಾಸ್ ಕರ್ತ್ಯಾಸಾ ಮನ್ಹುನ್ ಲೊಕಾನಾ ಠಾವ ವ್ಹಯಿತ್ ನಾಹಿ. ಫನ್ ತುಮಾನಾ ದಿಸ ನಸ್ನಾರಾ ತುಮ್ಚಾ ಬಾ ತುಮಾನಾ ಬಗ್ನಾರ್. ಗಪ್ಚಿಪ್ ಚಾ಼ಲ್ನಾರ‍್ಯಾ ಗುಶ್ಟಿ ಬಗ್ನಾರಾ ತುಮ್‍ಚಾ಼ ಬಾಸ್ ತುಮಾನಾ ಪ್ರತಿ ಫಳ್ ದೇನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","ತುಮ್ಚೆ ಸಾಟಿ ಹೆ ದರ್ಥಿವ ಆಸ್ಥಿ ಗೊಳಾ ಕರುನ್ ಥಿವು ನಕೊಸಾ ತಿ ಕಿರ್ವಿ ಲಾಗುನ್ ಬಾದ್ ವ್ಹತಿ ಚ್ವಾ಼ರ್ ತುಮ್ಚ ಘರ್ ಫುಡುನ್ ತುಮ್ಚಿಪ ಆಸ್‍ಲ್ಯಾಲ ಚೊರ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","ಫನ್ ತುಮ್ಚಿ ಆಸ್ಥಿ ಸ್ವರ್ಗಾತ್ ಕರುನ್ ಥೆವಾ ತಿಥ ತ್ಯನಾ ಕಿರ್ವಿ ಲಾಗುನ್ ಹಾಳ್ ವ್ಹಯಿತ್ ನಾಹಿ ಟ್ಯಾಂಬ್ರ ಲಾಗತ್ ನಾಹಿ ಚ್ವಾ಼ರ್ ಘರ್ ಫುಡಿತ್ ನಾಹಿತ. ");
INSERT INTO gok_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","ಕುಠ ತುಮಚ಼ ಧನ್ ತಿಥ ತುಮಚ಼ ಮನ್ ಹಾ.. ");
INSERT INTO gok_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","ಡೊಳ ಆಂಗಾಲಾ ಉಜಿಡ್ ಜಾ಼ಲ್ಯಾತ ತುಜ಼ ಡೊಳ ಶಾರ್ಕ ಆಸ್ಲತ ತುಜ಼ ಆಂಗ್ ಸಗ್ಳ ಉಜಿಡಾನಿ ಬರ‍್ಹುನ್ ರಾನ್ಹಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","ಫನ್ ತುಜ಼ ಡೊಳ ಬುರ್ಸ ಆಸ್ಲತ ತುಜ಼ ಆಂಗ್ ಸಗ್ಳ ಆಂದಾರಾನಿ ಬರ್ನಾರ್ ತುಜಿಪ್ ಆಸ್‍ಲ್ಯಾಲಾ ಯೊಕುಸ್ ಉಜಿಡ್ ಖರ‍್ಯಾನಿಸ್ ಅಂದಾರ್ ಜಾ಼ಲಾತ ತವಾ ತು ಕಾಳೊಕಾತುಸ್ ರಾನ್ಹಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","ಕುನಾಲಾ ದೊಗಾ ದನ್ಯಾಂಚಿ ಯಂಗದಾಸ್ ಚಾ಼ಕ್ರಿ ಕರಾಯಾ ವ್ಹಯಿತ್ ನಾಹಿ. ತ್ಯೊ ಎಕಾ ದನ್ಯಾಚಾ಼ ರಾಗ್ ಕರುನ್ ಆನಿ ಯಕಾಚಿ ಮಾಯಾ ಕರ್ತೊ ಮನ್ಹುನ್ ಯಕಾ ದನ್ಯಾಚೆ ಮಾಗ್ನಿ ಜಾ಼ವುನ್ ಆನಿ ಯಕ್‌ಲ್ಯಾಲಾ ನಕ್ವಾಟ್ ಕರ್ತೊ ತಸಸ್ ತು ದೇವಾಚಿ ಆನಿ ಪೈಶಾಂಚಿ ಯಂಗದಾಸ್ ಮಾಯಾ ಕರಾಯಾ ವ್ಹಯಿತ್ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","ತಸ ಮನ್ಹುನ್ ತುಮ್ಚಾ ಜೀವಾಲಾ ಪಾಯ್ಜೆ ತ್ಯಾ ಖಾನ್ಯಾ ಪಿನ್ಯಾಚಿ ಆಂಗಾಲಾ ವ್ಹಯಿಜಾ಼ಲ್ಯಾಲ್ಯಾ ಕಪ್‌ಡ್ಯಾಂಚೆ ಸಾಟಿ ತುಮಿ ಕ್ಯಾಳ್ಜಿ ಕರುನಕೊಸಾ ಜೀವ್ ಆನಾಪಕ್ಶಿ ಆಂಗ್ ಕಪ್‍ಡ್ಯಾಪಕ್ಶಿ ಖುಗ್ ಅವಶ ಮನ್ಹುನ್ ಮಿ ತುಮಾನಾ ಸಾಂಗ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","ಪಾಖ್ರಾನಾ ಬಗಾ ತಿ ಪಿರಿತ್ ನಾಹಿತ ಕಾಪಿತ್ ನಾಹಿತ ಕಳಂಜಾ಼ತ್ನಿ ಬರುನ್ ಥಿವಿತ್ ನಾಹಿತ ಫನ್ ಪರಲೊಕಾತ್ಲಾ ದೆವ್ ತ್ಯನಾ ಖಾಯಾ ದೇತೊ. ತುಮಿ ತ್ಯಾ ಪಾಕ್ರಾಂಚಿವ್ನಿ ಖುಬ್ ಕಿಮ್ತಿಚಿ ಹಾಸಾ ಮನ್ಹುನ್ ತುಮಾನಾ ಠಾವ ನಾಹಿ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","ತುಮಿ ಕ್ಯಾಳ್ಜಿ ಕರುನ್ ತುಮ್ಚ ವಯೆ ವಾಡ್ವಾಯಾ ವ್ಹತ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","ಕಪ್‍ಡ್ಯಾಂಚೆ ಸಾಟಿ ಕ್ಯಾಳ್ಜಿ ಕರಾಚಿ ಕಾ? ಸೇತಾತ್ಲಿ ಫುಲ ಬಗಾ ತೀ ಫುಲತ್ಯಾತ ಕಸಿ ಮನ್ಹುನ್ ಯವಜಾ. ತೀ ರಾಬತ್ ನಾಹಿತ ಆನಿ ಆಪ್ಲಿ ಸಾಟಿ ಕಪ್ಡ ಸಿವಿತ್ನಾಹಿತ. ");
INSERT INTO gok_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","ಫನ್ ಮಿ ತುಮಾನಾ ಸಾಂಗಾಚ಼ ಕ್ಯಾ ಮಂಜೆ, ಸೊಲೊಮೊನ್ ಆಪ್‌ಲ್ಯಾ ವೈಭವಾತ್ ಆಸ್ಥಾನಾಬಿ ಹ್ಯಾ ಫುಲ್ಲಾತ್‍ಲ್ಯಾ ಯಕಾಲಾ ಸೊಬಾ ಹಾ ತ್ಯವ್ಡ ಸೊಬಚ಼ ಕಪ್ಡ ಗ್ಯಾತ್ಲ ನವ್ಥ. ");
INSERT INTO gok_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","ರಾನಾತ್ಲ ಫುಲ್ ಆಜ಼್ ರಾಹುನ್ ಸಕಾಳ್ ಇಸ್‍ಥ್ಯಾತ್ ಗ್ಯಾಲ್ನಾರ್ ತ್ಯಲಾ ಯವ್ಡ ಗ್ಯಾತಲ್ಯಾವ ದೇವ್ ತುಮಾನಾ ತ್ಯಂಚಿವ್ನಿ ಆಗಾವ್ ಗಾಲನಾರ್ ಮನ್ಹುನ್ ತುಮಾನಾ ಠಾವ ಹಾ. ಇಸ್ವಾಸ್ ನಸ್‍ಲ್ಯಾಚೆಗತ್ ರಾಹು ನಕೊಸಾ! ");
INSERT INTO gok_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","ಆಮಿ ಕ್ಯಾ ಖಾಯಾಚ಼? ಕ್ಯಾ ಪಿಯಾಚ಼? ಕ್ಯಾ ಗಾಲಾಯಾ ಪಾಯ್ಜೆ? ಮನ್ಹುನ್ ಕ್ಯಾಳ್ಜಿ ಕರು ನಕೊಸಾ. ");
INSERT INTO gok_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","ದೇವಾಲಾ ಸಮ್ಜುನ್ ಗೆತಲ್ಯಾ ನಸ್‍ಲ್ಯಾಲಿ ಲೊಕ ಹ್ಯ ಸಗ್ಳ‍ ಗಿಹ್ಯಾ ಖಟ್ಪಟ್ ಕರ್ತ್ಯಾತ. ಕ್ಯಾಳ್ಜಿ ಕರು ನಕೊಸಾ ಕಾ ಮಂಜೆ ಹಿ ಸಾಮ್ನ ತುಮಾನಾ ಪಾಯ್ಜೆ ಮನ್ಹುನ್ ತುಮ್ಚಾ ಸ್ವರ್ಗಾತ್‍ಲ್ಯಾ ಬಾ ದೆವಾಲಾ ಠಾವ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","ಮನ್ಹುನ್ ತುಮಿ ದೇವಾಚಾ ರಾಜಾಸಾಟಿ ಆನಿ ತೆಚಾ ಮನಾ ಶಾರ್ಕಿ ಕಾಮ ಕರಾಯಾ ಖುಬ್ ಖಟ್ ಪಟ್ ಕರಾ ತವಾ ತುಮಾನಾ ಹ್ಯ ಸಗ್ಳ ದೇನಾರ್ ");
INSERT INTO gok_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","ಮನ್ಹುನ್ ಸಖಾಳ್ಚೆ ಸಾಟಿ ಕ್ಯಾಳ್ಜಿ ಕರು ನಕೊಸಾ ಪರತೇಕ್ ದೀಸ್ ಆಪ್ಲ ತ್ಯಸ್ ತರಾಸ್ ಗೆತಲ್ಯಾತ. ಸಕ್ಕಾಳಚಾ಼ ದೀಸ್ ಬೀ ಆಪ್ಲಿ ತೀಸ್ ಕ್ಯಾಳ್ಜಿ ಗಿಹುನ್ ರಾಥೊ. ");
INSERT INTO gok_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","ದುಸ್‌ರ‍್ಯಾಂಚಾ಼ ನ್ಯಾಯಿ ನಿವ್ಡು ನಕೊಸಾ. ತವಾ ದೇವ್ ತುಮ್‍ಚಾ಼ ನ್ಯಾಯಿ ನಿವ್ಡಿತ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","ತುಮಿ ದುಸ್‌ರ‍್ಯಾಂಚಾ಼ ನ್ಯಾಯಿ ಕಸಾ ಕರ್ತಾಸಾ. ತಸಾಸ್ ತುಮ್‍ಚಾ಼ ನ್ಯಾಯಿ ವನ್ಹಾರ್. ತುಮಿ ಮ್ಯಾಪ್‌ಲ್ಯಾಲ್ಯಾ ಮಾಪಾನಿ ತುಮಾನಾ ಮ್ಯಾಪ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“ತು ತುಜಾ ಡೊಳ್ಯಾತ್ಲ ಮುಸಾಳ್ ಬಗಾಚೆ ಆಂದಿ ತುಜಾ ಬಾವ್ಹಾಚಾ ಡೊಳ್ಯಾತ್ಲ ಕುಸಾಳ್ ಕಾ ಬಗ್ತೊಸ್? ");
INSERT INTO gok_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","ತುಜಾ ಡೊಳ್ಯಾತ್ಲ ಕುಸಾಳ್ ಮಿ ಬಾಹಿರ್ ಕ್ಯಾಡ್ತೊ ಮನ್ಹುನ್ ತುಜಾ ಬಾವ್ಹಾಲಾ ಸಾಂಗ್ತೊಸ್ ಕಾ? ಆಂದಿ ತುಜಾ಼ ಡೊಳಾ ಬಗ್! ತುಜಾ ಡೊಳ್ಯಾತ್ ಮುಸಾಳ್ ಆಜ಼ುನ್ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","ತು ಕಪ್ಟಿ! ತುಜಾ ಡೊಳ್ಯಾತ್ಲ ಮುಸಾಳ್ ಕ್ಯಾಡ್. ಮಂಜೆ ತುಜಾ ಬಾವ್ಹಾಚಾ ಡೊಳ್ಯಾತ್ಲ ಬ್ಯಾರ್ಕ ಕುಸಾಳ್ ಕಾಡಾಯಾ ತುಲಾ ಶಾರ್ಕ ದಿಸಲ್. ");
INSERT INTO gok_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","ಚಾ಼ಂಗ್ಲಾ ಜಿನೊಸ್ ಕುತ್‌ರ‍್ಯಾಂಚೆ ಮೊರ‍್ಹ ದಿವುನಕೊಸಾ, ಆನಿ ಚಾ಼ಂಗ್ಲಾ ಜಿನೊಸ್ ಡುಕ್ರಾಂಚೆ ಮೊರ‍್ಹ ಟಾಕುನಕೊಸಾ ಕಾ ಮಂಜೆ ತೀ ತ್ಯ ತುಡಿವ್ನಾರ್. ಆನಿ ತೀ ಮಾಗಾರಿ ಪರ್ತುನ್ ತುಮಾನಾ ಚಾವ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“ಮಾಗಾ, ತವಾ ದೇವ್ ತುಮಾನಾ ದೇನಾರ್. ಸೋದಾ, ತವಾ ತುಮಾನಾ ದಿಸಲ್. ದಾರ್ ವಾಜ್ವಾ಼, ತವಾ ತುಮಾನಾ ಉಗಡ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","ವ್ಹಯ್, ಮಾಗ್ತೊ ತ್ಯಲಾ ದೆನಾರ್. ಸುದಿತ್ ರಾಥ್ಯಾಲ್ಯಾನಾ ದಿಸ್ನಾರ್, ವಾಜ್ವಿತ್ ರಾಥ್ಯಾಲ್ಯಾನಾ ದಾರ್ ಉಗಡ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“ತುಮ್ಚಾ ಲೆಕಾನಿ ಬಾಕ್ರಿ, ಮಾಗ್ಲಿತ ದೊಂಡ ದೇನಾರ್ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","ಮಾಸ ಮಾಗ್ಲತ, ಸಾಪ್ ದೇನಾರ್ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","ತುಮಿ ಚಾ಼ಂಗ್ಲಿ ನವ್ಹಸಾ, ಬುರ್ಸಿ ಹಾಸಾ, ತುಮ್ಚಾ ಪೊರಾನಾ ಚಾ಼ಂಗ್ಲ ಜಿನೊಸ್ ದಿಯಾ ವ್ಹಯಿತ ಮನ್ಹುನ್ ತುಮಾನಾ ಠಾವ ಹಾ. ಆಸ ಆಸ್ಥಾನಾ ತುಮ್‍ಚಾ಼ ಸ್ವರ್ಗಾತ್ಲಾ ಬಾ ಸಾಹಿತ್ ಆಪ್ಲಿಪ ಮಾಗ್‌ತ್ಯಾಲ್ಯಾನಾ ಚಾ಼ಂಗ್ಲ ಜಿನೊಸ್ ಆನಿ ಖುಬ್ ದೇನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","ತುಮಾನಾ ದುಸ್‌ರ‍್ಯಾಂಚಾನಿ ಕ್ಯಾ ಕರಾಯಾ ವ್ಹಯಿ ಮಂಥಾಸಾ ತ್ಯ ತುಮಿ ತ್ಯನಾ ಕರಾ. ಹ್ಯೊ ಮೊಶೆಚಾ ನೇಮಾಚಾ಼ ಆನಿ ಪ್ರವಾದಿಂಚಾ ಸಿಕಿವ್‌ನ್ಯಾಚಾ಼ ಅರ್ಥ. ");
INSERT INTO gok_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","ಆವಳ್ ದಾರಾನಿ ಜಾ಼ವಾ. ನಾಸಾಚೆ ವಾಟಚಿ ಮುಟಿ ದಾರ ಖುಬ್ ರುಂದ್ ಖುಬ್ ಲೊಕ ತ್ಯಾ ದಾರಾತ್ನಿ ಜಾ಼ತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","ಫನ್ ಶಾಶ್ವತ್ ಜೀವ್ನಾಲಾ ಆಸ್‍ಲ್ಯಾಲ ದಾರ್ ಖುಬ್ ಆವಳ್. ವಾಟ್ ತರಾಸಾಚಿ. ಥೊಡ್ಯಾನಾ ತ್ಯವ್ಡಿಸ್ ತೀ ವಾಟ್ ಗಾವ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","ಲಬಾಡ್ ಪ್ರವಾದಿಂಚೆ ಗುಶ್ಟಿತ್ನಿ ಹುಶಾರ್ ರಾವ್ಹಾ. ತೇ ಮೇಂಡ್ರಾಂಚೆಗತ್ ದಿಸತ್ ತುಮ್ಚಿಪ ಯತ್ಯಾತ. ಫನ್ ತೇ ಕೂಳಿಸ್‍ನ್ಯಾಂಚೆಗತ್ ಖರ‍್ಯಾನಿಸ್ ಗಾತ್ಕಿ ಜಾ಼ಲ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","ತ್ಯಂಚೆ ಕರ್ತುಕಿನಿ ತುಮಿ ತ್ಯನಾ ಸಮಜು಼ನ್ ಗೇನಾರ್. ಕಾಟ್ಯಾಂಚೆ ಜಾ಼ಳಿತ್ ದರಾಕ್ಶಿ ಕಸಿ ಗಾವತ್ನಾಹಿ ತಸಸ್ ಚಾ಼ಂಗ್ಲ ಬುರ್‌ಶಾ ಲೊಕಾತ್ನಿ ಯಯಿತ್ ನಾಹಿ ಹುಂಬ್ರ ಕರ್ವಂದಿಚೆ ಜಾ಼ಳಿತ್ ಗಾವತ್ ನಾಹಿತ. ");
INSERT INTO gok_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","ತಸಸ್ ಪರತೇಕ್ ಚಾ಼ಂಗ್ಲ ಝಾ಼ಡ್ ಚಾ಼ಂಗ್ಲ ಫಳ್ ದೇತ ಬುರ್ಸ ಝಾ಼ಡ್ ಬುರ್ಸ ಪಳ್ ದೇತ. ");
INSERT INTO gok_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","ಚಾ಼ಂಗ್ಲ ಝಾ಼ಡ್ ಬುರ್ಸ ಫಳ್ ದಿಯಿತ್ ನಾಹಿ ಆನಿ ಬುರ್ಸ ಝಾ಼ಡ್ ಚಾ಼ಂಗ್ಲ ಫಳ್ ದಿಯಿತ್ನಾಯಿ. ");
INSERT INTO gok_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","ಆನಿ ಚಾ಼ಂಗ್ಲ ಫಳ್ ದಿಯಿತ್ ನಸ್ನಾರ ಪರತೇಕ್ ಝಾ಼ಡ್ ತುಡುನ್ ಇಸ್‌ಥ್ಯಾತ್ ಟ್ಯಾಕ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","ಹ್ಯಾ ಲಬಾಡ್ ಪ್ರವಾದಿನಾ ತೇ ಕರ್ತ್ಯಾಲ್ಯಾ ಕಾಮಾನಿಸ್ ತುಮಿ ಸಮಜು಼ನ್ ಗೆನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“‘ಪ್ರಭು ಪ್ರಭು’ ಮಂಥ್ಯಾಲಿ ಸಗ್ಳಿ ಸ್ವರ್ಗಾಚಾ ರಾಜಾತ್ ಜಾ಼ಯಿತ್ ನಾಹಿತ. ಸ್ವರ್ಗಾತ್ ಆಸ್‍ಲ್ಯಾಲ್ಯಾ ಮಾಜಾ ಬಾಚಾ ಮನಾ ಶಾರ್ಕ ಕರ್ತ್ಯಾಲ. ಸ್ವರ್ಗಾಚಾ ರಾಜಾತ್ ಜಾ಼ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","ನ್ಯಾಯಿ ನಿವ್ಡಾಚಾ ದಿಸಾತ್ ಖುಬ್ ಜ಼ನ ಮನಾ, ‘ಪ್ರಭು ಪ್ರಭು! ಪ್ರಭುಚಾ ನಾವಾಚಿ ಖಬರ್ ಸಾಂಗ್ಲಿ. ತುಜಾ ನಾವಾನಿ ಭುಥ ಸುಡಿವ್‌ಲ್ಯಾತ ಆನಿ ಖುಬ್ ಚಮತ್ಕಾರ್ ಕಿಲಿತ. ಮನ್ಹುನ್ ಸಾಂಗ್‍ತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","ಫನ್ ಮಿ ತ್ಯನಾ, ‘ಧರ್ಮಾಚೆ ಅಡ್ವ ಆಸ್‍ಲ್ಯಾಲ್ಯಾನು, ತುಮಿ ಕೊನ್ ಮನ್ಹುನ್ ಮನಾ ಠಾವ ನಾಹಿ. ಮಾಜಿಪ್ನಿ ಚ಼ಲಾ’. ಮನ್ಹುನ್ ಖರ‍್ಯಾನಿ ಸಾಂಗ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“ಮಾಜಾ ಹ್ಯಾ ಬೊಲ್ಯಾ ಐಕುನ್ ತ್ಯಂಚಿಗತ್ ಚಾ಼ಲತ್ಯಾಲಾ ಪರ್ತೆಕ್ ಜಾ಼ನ್ ಆಪ್ಲ ಘರ್ ಖಡ್ಕಾವ ಬ್ಯಾಂದ್‍ಲ್ಯಾಲ್ಯಾ ಶಾನ್ಯಾಚೆಗತ್ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","ಜೊ಼ರಾನಿ ಪಾವುಸ್ ಪಡುನ್ ಪಾನಿ ವರ್ ಯತ. ಚಾರಿಕ್ನಿ ವಾರ ಸುಟುನ್ ತ್ಯಾ ಗರ‍್ಹಾವ ಅದಾಳ್ತ ಫನ್ ತ್ಯ ಘರ್ ಖಡ್ಕಾವರ್ ಬ್ಯಾಂದ್‌ಲ್ಯಾಲ ಹಾ ಮನ್ಹುನ್ ತ್ಯ ಪಡ್ಲ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","ಜೆ ಕೊನ್ ಮಾಜಾ ಬೊಲ್ಯಾ ಐಕುನ್ ತೆಂಚಿಗತ್ ಚಾ಼ಲನಸ್ನಾರಾ ಖುಳಾ ಜಾ಼ಲ್ಯಾ. ತ್ಯಾ ಖುಳ್ಯಾನಿ ವಾಳ್ವವ ಆಪ್ಲ ಘರ್ ಬ್ಯಾಂದ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","ಜೊ಼ರಾನಿ ಪಾವುಸ್ ಪಡುನ್ ನ್ಹಲಾ ಪವುಡ್ ಆಲಾ, ಚಾರಿಕ್ನಿ ವಾರ ಸುಟ್ಟುನ್ ತ್ಯಾ ಗರ‍್ಹಾವ ಆದಾಳ್ಳ ತವಾ ತ್ಯ ಘರ್ ಧಾಪ್‌ಕ್ಯಾನಿ ಪಡ್ಲ. ” ");
INSERT INTO gok_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","ಯೇಸುನಿ ಸಿಕಿವ್‌ಲ್ಯಾಲ್ಯಾ ಹ್ಯಾ ಗುಶ್ಟಿ ಐಕುನ್ ಲೊಕ ಖುಬ್ ಆಜಾಬ್ ಜಾ಼ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ಕಾ ಮಂಜೆ ತ್ಯನಿ ಧರ್ಮ ಸಿಕಿವ್‌ತ್ಯಾಲ್ಯಾಂಚಿಗತ್ ಸಿಕ್ವಾಚ಼ ಸುಡುನ್ ಹುಕುಮ್ ಆಸ್‌ಲ್ಯಾಚೆಗತ್ ಸಿಕಿವ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","ಯೇಸು ಕನ್ಯಾವ್ನಿ ಖಾಲ್ ಉತ್ರುನ್ ಆಲಾ. ತವಾ ಲೊಕ ಹಿಂಡಾಹಿಂಡಾನಿ ತ್ಯಚೆ ಮಾಗ್ನಿ ಗಿಲಿತ. ");
INSERT INTO gok_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","ತವಾ ಯೊಕ್ ಕುಶ್ಟ ರೊಗಿ ಯೇಸುಪ ಆಲಾ. ತ್ಯೊ ಯೇಸುಚೆ ಮೊರ‍್ಹ ಆಡ್ವಾ ಪಡುನ್ “ಪ್ರಭು, ತು ಮನ್‌ ಕೆಲ್ಯಾವ ಮನಾ ಬರ ಕರ್ನಾರ್” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","ಯೇಸುನಿ ಆಪ್ಲಾ ಹಾತ್ ಲಾವುನ್, “ತುಲ್ಲಾ ಬರಕರಾಯಾ ಮನಾ ಮನ್ ಹಾ, ಬರಾಹೊ” ಮನ್ಲಾ. ತವ್ವಾಸ್ ತ್ಯಚಾ಼ ಕುಶ್ಟ ರೊಗ್ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","ಯೇಸುನಿ ತ್ಯಲಾ, “ಐಕ್ ಹ್ಯ ಕಸ ಜಾ಼ಲ ಮನ್ಹುನ್ ಕುನಾಲಾ ಸಾಂಗು ನಕೊಸ್. ಅತ್ತಾ ತು ಜಾ಼ವುನ್ ಯಾಜಕಾಲಾ ತುಜ಼ ಆಂಗ್ ದ್ಯಾವ್. ಬರಜಾ಼ಲ್ಯಾಲ್ಯಾಂಚಾನಿ ಮೊಶೇಚಾ ನೇಮಾ ಶಾರ್ಕ ದೆತ್ಯಾಲಿ ದಿನ್ಗಿ ದೇ. ತು ಬರಾ ಜ಼ಾಲ್ಯಾಲ್ಯಾಲಾ ತೀ ವಳಕ್ ವ್ಹವುನ್ ರಾನ್ಹಾರ್” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","ಯೇಸು ಕಪೆರ್ನೌಮ್ ಪೆಠತ್ ಗೆಲಾ. ತ್ಯೊ ಪೆಠತ್ ಗೆಲಾ ತವಾ ಶತಾದಿಪತಿ ಯೊಕ್ ಯವುನ್, ");
INSERT INTO gok_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“ಪ್ರಭು, ಮಾಜಾ಼ ಚಾ಼ಕೊರ್ ಪಾರ್ಶಿ ಮಾರುನ್ ಹಾತ್ರುನಾತ್ ಹಾ. ತ್ಯೊ ಖುಬ್ ದುಃಖಾನಿ ಕಳವಳ್‍ತ್ಯೊ” ಮನ್ಹುನ್ ಮಜ಼ತಿ ಸಾಟಿ ಮಾಗ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","ಯೇಸುನಿ ತ್ಯಾ ಶತಾದಿಪತಿಲಾ, “ಮಿ ಯವುನ್ ತ್ಯಲಾ ಬರ ಕರ್ತೊ” ಮನ್‍ಲ್ಹಾ. ");
INSERT INTO gok_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","ತವಾ ತ್ಯೊ ಶತಾದಿಪತಿ, “ಪ್ರಭು, ಮಾಜಾ ಗರ‍್ಹಾತ್ ತು ಯಯಿಶಾರ್ಕಾ ಮಿ ಮೊಟಾ ನವ್ಹ. ತ್ಯಲಾ ಬರ ವ್ಹವುನಿ ಮನ್ಹುನ್ ತು ಯೊಕ್ ಸಬ್ದ ಸಾಂಗ್ಲಾಸ್ ಪುರ ತ್ಯಲಾ ಬರ ವ್ಹನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","ಮೀಬೀ ದಿಸರ‍್ಯಾ ಯಕಾಚಾ ಹಾತಾಖಾಲ್ ಹಾ ಮಾಜಾ ಹಾತಾಚೆ ಖಾಲ್ ಸಿಪಾಯಿ ಹಾತ್ತ. ಮಿ ಯಕಾ ಸಿಪಾಯಿಲಾ ‘ಜಾ಼’ ಮನ್ಲೊತ ತ್ಯೊ ಜಾ಼ತೊ; ಆನಿ ಯಕಾಲಾ ‘ಯೇ’ ಮನ್ಲೊತ ತ್ಯೊ ಯತೊ. ಮಿ ಮಾಜಾ ಚಾ಼ಕ್ರಾಲಾ ಹ್ಯ ಕರ್ ಮನ್ಲೊತ ತ್ಯೊ ತಸಾ ಕರ್ತೊ. ” ಮನ್‍ಲ್ಹಾ. ");
INSERT INTO gok_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","ಹ್ಯ ಐಕುನ್ ಯೇಸುಲಾ ಆಜಾಬ್ ವಾಟ್ಲ. ಯೇಸುನಿ ಆಪ್ಲಿ ಸಂಗ ಆಸ್‍ಲ್ಯಾಲ್ಯಾನಾ, “ಮಿ ಇಸ್ರಾಯಲಾತ್ ಬಿ ಯವ್ಡಾಸ್ ಇಸ್ವಾಸ್ ಆಸ್ನಾರ‍್ಯಾ ಮಾನ್ಸಾಲಾ ಬಗ್ಲಾ ನಾಹಿ ಮನ್ಹುನ್ ತುಮಾನಾ ಖರ‍್ಯಾನಿ ಸಾಂಗ್ತೊ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","ಮಿ ತುಮಾನಾ ಸಾಂಗ್ತೊ. ಖುಬ್ ಲೊಕ ಉಗಾವ್ತೆ ಆನಿ ಮಾವಾಳ್ತೆ ಬಾಜೊ಼ಕ್ನಿ ಯತ್ಯಾತ. ತೀ ಸ್ವರ್ಗಾಚಾ ರಾಜಾತ್ ಅಬ್ರಹಾಮ್, ಇಸಾಕ್, ಯಾಕೊಬ್ ಹ್ಯಂಚಿ ಸಂಗ ಬಸುನ್ ಜೆವಾನ್ ಖಾತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","ದೆವಾಚಾ ರಾಜಾತ್ ಜಾ಼ನಾರ್ ಮಂಥ್ಯಾಲ್ಯಾನಾ ಬಾಹಿರ್ ಅಂದಾರಾತ್ ಟ್ಯಾಕ್ನಾರ್. ತಿಥ ರಡ್ನಾರ್ ಆನಿ ದಾತ್ ಖಾನಾರ್” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","ಮಂಗ್ ಯೇಸುನಿ ತ್ಯಾ ಶತಾದಿಪತಿಲಾ, “ಗರ‍್ಹಾತ್ ಜಾ಼, ತು ಇಸ್ವಾಸ್ ಥೆವ್‌ಲ್ಯಾ ಶಾರ್ಕಾ ತುಜಾ ಚಾ಼ಕ್ರಾಲಾ ಬರ ವ್ಹನಾರ್” ಮನ್ಲಾ. ತವಾಸ್ ತ್ಯಚಾ ಚಾ಼ಕ್ರಾಲಾ ಬರ ಜಾ಼ಲ. ");
INSERT INTO gok_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","ಯೇಸು ಪೇತ್ರಾಚಾ ಗರ‍್ಹಾತ್ ಗೆಲಾ. ತಿಥ ಪೇತ್ರಾಚಿ ಸಾಸೊ ಖುಬ್ ತಾಪಾನಿ ಹಾತ್ರುನಾತ್ ನಿಜ್‍ಲ್ಯಾಲಿ ಯೇಸುನಿ ಬಗ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","ಯೇಸುನಿ ತಿಚಾ ಹಾತಾಲಾ ಹಾತ್ ಲ್ಯಾವ್ಲಾ ತವಾ ತಿಚಾ಼ ತಾಪ್ ಸುಡುನ್ ಗೆಲಾ ತವಾ ತಿನಿ ವರ್ ಉಠುನ್ ತ್ಯಂಚಿ ಸೆವಾ ಕಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","ತೀಸಿಸ್ ಶಾಂಚಿ ಲೊಕ ಬುಥ ದರ್‌ಲ್ಯಾಲ್ಯಾ ಖುಬ್ ಜ಼ನಾನಾ ಯೇಸುಪ ಆನ್ಲಿತ. ಯೇಸುನಿ ಬುಲಿನಿಸ್ ಬುಥ ತ್ಯಂಚಿಪ್ನಿ ಪಳಿವ್ಲಿತ ದುಖನ್ಕರ‍್ಯಾ ಲೊಕಾನಾ ಸಗ್‌ಳ್ಯಾ ಬರಿ ಕಿಲಿತ. ");
INSERT INTO gok_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","“ತ್ಯನಿ ಆಮ್ಚಿ ದುಕ್ನಿ ಗಿತ್ಲಿತ, ಆಮ್ಚ಼ ರ‍್ವಾಗ್ ಉಚ್ಲು಼ನ್ ಗೇತ್ಲ” ಹ್ಯ ಸಗ್ಳ ಪ್ರವಾದಿ ಯೆಶಾಯನಿ ಸಾಂಗ್‌ಲ್ಯಾಲ ಪುರ್ನ ವ್ಹಯಾ ಸಾಟಿ ಆಸ ಜಾ಼ಲ ");
INSERT INTO gok_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","ಯೇಸುನಿ ಆಪ್ಲೆ ಸರ್ಬೌತಿ ಆಸ್ನಾರ‍್ಯಾ ಲೊಕಾನಾ ಸಗ್‍ಳ್ಯಾ ಬಗುನ್ ಆಪ್‌ಲ್ಯಾ ಶಿಶಾನಾ ಸಮಿಂದೋರಾಚೆ ಪಲಿಕ್ಡ ಜಾ಼ಯಾಲಾ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","ತವಾ ದರ್ಮೊಪದೆಶಕ್ ಯೇಸುಪ ಯವುನ್, “ಸಿಕಿವ್‌ನ್ಯಾರ‍್ಯಾ, ತು ಕುಟಲ್ಯಾ ಜಾ಼ಗ್ಯಾವ ಗೆಲಾಸ್ ತರಿ ಮಿ ತುಜೆ ಮಾಗ್ನಿ ಯತೊ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","ಯೇಸುನಿ ತ್ಯಲಾ, “ಕೊಲ್ಯಾನಾ ಗಭಿ ಹಾತ್ತಾ, ಪಾಕ್ರಾನಾ ಕುಟಿ ಹಾತ್ತ. ಫನ್ ಮಾನ್ಸಾಚಾ ಲೇಕಾಲಾ ಡುಯಿ ಥೆವಾಯಾ ಜಾ಼ಗಾ ನಾಹಿ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","ಶಿಶಾತ್ಲಾ ಯಕ್ಲಾ ಯೇಸುಲಾ, “ಪ್ರಭು ಮನಾ ಆಂದಿ ಮಾಜಾ ಬಾಚೆ ಮಾತಿಲಾ ಜಾ಼ವುನ್ ಯಯಾ ಹುಕುಮ್ ದೆ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","ಫನ್ ಯೇಸು ತ್ಯಲಾ ಮೇಲ್ಯಾಲಿಸ್ ಮೆಲ್ಯಾಲ್ಯಾನಾ ಮಾತಿ ದಿವುಂತ. ಮಾಜೆ ಮಾಗ್ನಿ ಯೆ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","ಯೇಸು ವ್ಹಡಿತ್ ಗೆಲಾ. ತವಾ ತ್ಯಚ಼ ಶಿಶಾ ತ್ಯಚಿ ಸಂಗ ಗೆಲ. ");
INSERT INTO gok_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","ವ್ಹಡಿ ದರ್ ಸುಡುನ್ ಗೀಲಿ ತವಾ ಯಗ್ದಮ್ ಮುಟಿ ವಾವ್ಡಳ್ ಸಮಿಂದೊರಾತ್ ಆಲಿ. ಲ್ವಾಟಾಂಚಾನಿ ವ್ಹಡಿಲಾ ಜಾ಼ಕುನ್ ಗಿತ್ಲಿ. ಫನ್ ಯೇಸು ವ್ಹಡಿತುಸ್ ನಿಜ್ಲಾ಼ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","ಯೇಸುಚ಼ ಶಿಶಾ ತ್ಯಚಿಪ ಯವುನ್ ತ್ಯಲಾ ಉಠ್ವುನ್, “ಪ್ರಭು ಆಮಾನಾ ಉರಿವ್! ಆಮಿ ಬುಡ್‍ತ್ಯಾವ್!” ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","ಯೇಸುನಿ, “ತುಮಿ ಬಿತ್ತಾಸಾ‍ ಕಾ? ತುಮ್ಚಿಪ ಪಾಯ್ಜೆ ತ್ಯವ್ಡಾ ಇಸ್ವಾಸ್ ನಾಹಿ” ಮನ್ಹುನ್ ಉತ್ತರ್ ದಿಲಾ ಉಠುನ್ ಉಬಾ ರಾಹುನ್ ತೇ ಮೊಟೆ ವಾರ ಮುಡಿಲಾ ಲಾಟಾನಾ ದಪ್‌ಕ್ಯಾವ್ಲ. ತವಾ ತ್ಯ ಸಗ್ಳ ಶಾಂತ್ ಜಾ಼ಲ. ");
INSERT INTO gok_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","“ತ್ಯೊ ಕಸ್ಲಾ ಮಾನುಸ್? ವಾರಮ್ಯೊಡ್ ಆನಿ ಪಾನಿ ಹ್ಯಚಾ಼ ಸಬ್ದ ಐಕ್‌ತ್ಯಾತ ನವ್ಹ” ಆಸಿ ಲೊಕ ಮನ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","ಯೇಸು ಸಮಿಂದೊರಾಚೆ ಗದರೇನ್ ಸಿಮತ್ ಆಲಾ. ತವಾ ತಿಥ ಬುಥ ‌ಲಾಗ್‌ಲ್ಯಾಲ ದೊಗ ಯೇಸುಪ ಆಲ. ತೇ ಮಸುರ್ಡಿತ್ನಿ ರಾಹಿತ ಆನಿ ಖುಬ್ ಗಾತ್ಕಿ ಜಾ಼ಲ್ಥ. ಮನ್ಹುನ್ ಲೊಕ ತೇ ವಾಟನಿ ಜಾ಼ಯಿತ್ನವ್ಥಿತ. ");
INSERT INTO gok_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","ತೇ ದೊಗ ಯೇಸುಪ ಯವುನ್. “ತು ಆಮಾನಾ ಕ್ಯಾ ಕರಾಯಾ ವ್ಹಯಿ ಮಂಥೊಸ್? ದೇವಾಚಾ ಲೇಕಾ, ದಿಲ್ಯಾಲ್ಯಾ ಯಳಾಚೆ ಆಂದಿ ಆಮಾನಾ ಶಿಕ್ಷಾ ದಿಯಾ ಹಿತ್ತ ಆಲಾಸ್ ಕ್ಯಾ? ಮನ್ಹುನ್‍ ತವಾಸ್ ಜೊ಼ರಾನಿ ವರಾಡ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","ತ್ಯಾ ಜಾ಼ಗ್ಯಾಚೆ ಜ಼ವಳ್ ಡುಕ್ರಾಂಚಾ಼ ಮೊಟಾ ಹಿಂಡ್ ಚ಼ರತಾ. ");
INSERT INTO gok_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","ತ್ಯಾ ಬುಥಾಂಚಾನಿ, “ಆಮಿ ಹ್ಯಾ ದೊಗಾನಾಬಿ ಸುಡುನ್ ಜಾ಼ಯಾ ವ್ಹಯಿ ಮನ್ಲಾಸ್ತ, ದಯಾ ಥಿವುನ್ ಆಮಾನಾ ತ್ಯಾ ಡುಕ್ರಾತ್ನಿ ಲಾವುನ್ದೇ” ಮನ್ಹುನ್ ಇನಂತಿ ಕಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","ಯೇಸು ತ್ಯನಾ, “ಜಾ಼ವಾ” ಮನ್ಲಾ. ತವಾ ತೀ ಬುಥ ತ್ಯನಾ ದೊಗಾನಾ ಸುಡುನ್ ಡುಕ್ರಾತ್ನಿ ಗಿಲಿತ. ತವಾಸ್ ಡುಕ್ರ ಸಗ್ಳಿ ಗುಢ್ಯಾವ್ನಿ ಖಾಲ್ ಪಳತ್ ಯವುನ್ ಸಮಿಂದೊರಾತ್ ಬುಡಾಲಿತ. ");
INSERT INTO gok_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","ಡುಕ್ರ ಚಾರತ್ಯಾಲ ಪೆಠತ್ ಪಳತ್ ಜಾ಼ವುನ್ ಭುಥ ಲಾಗ್‌ಲ್ಯಾಲ್ಯಾಂಚೆ ಸಂಗ ಜಾ಼ಲ್ಯಾಲ ಲೊಕಾನಾ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","ತವಾ ತೆ ಸಿಮತ್ಲಿ ಲೊಕ ಸಗ್ಳಿ ಯೇಸುಲಾ ಬಗಾಯಾ ಆಲಿತ, ಆನಿ ತ್ಯಲಾ ಬಗುನ್ ಆಪ್ಲಿ ಸಿಮಾ ಸುಡುನ್ ಜಾ಼ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","ಯೇಸು ವ್ಹಡಿತ್ ಚ಼ಡುನ್ ಸಮಿಂದೊರ್ ವಲ್ಯಾಂಡುನ್ ಆಪ್‌ಲ್ಯಾ ಸ್ವತಾಚಾ ಗಾವಾತ್ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","ಥೊಡ್ಯಾಂಚಾನಿ ಯಕಾ ಪಾರ್ಶಿಚಾ ರೊಗಿಲಾ ಯೇಸುಪ ಆನ್ಲಾ ತ್ಯೊ ಆಪ್‌ಲ್ಯಾ ಹಾತ್ರು ನಾವ ನಿಜ಼ಲಾ ಹುತ್ತಾ. ಯೇಸುನಿ ಹ್ಯಾ ಲೊಕಾಂಚಾ಼ ಇಸ್ವಾಸ್ ಬಗುನ್, “ತ್ಯಲಾ ಲೇಕಾ, ದಿರ‍್ಹಾನಿ ರ‍್ಹಾ. ತುಜಿ ಪಾಪ ಮಾಪ್” ಜಾ಼ಲಿತ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","ತಿತ್ಲ ಧರ್ಮೊಪದೇಶಕ್, “ಹ್ಯೊ ಮಾನುಸ್ ದೇವಾಚಿ ನಿಂದಾ ಕರ್ತೊ” ಆಸ ಆಪ್‌ಲ್ಯಾ ಆಪ್‌ಲ್ಯಾತುಸ್ ಬೊಲತ. ");
INSERT INTO gok_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","ತ್ಯಂಚಾನಿ ಆಸಸ್ ಯವಜ್‌ಲ್ಯಾ ಮನ್ಹುನ್ ಯೇಸುಲಾ ಸಮಾಜ್ಲ. ತ್ಯನಿ ತ್ಯನಾ, “ತುಮಿ ಕಾ ಬುರ್ಸ ಯವಸ್ಥಾಸಾ? ");
INSERT INTO gok_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","ಕಚ಼ ಸಲ್ಪ? ಹ್ಯಾ ಲಕ್ವಾ ಮ್ಯಾರ್‌ಲ್ಯಾಲ್ಯಾ ರೊಗಿಲಾ, ‘ತುಜಿ ಪಾಪ ಮಾಪ್ ಜಾ಼ಲಿತ’ ಮನ್ಹುನ್ ಸಾಂಗಾಚ಼ ನಾಹಿತ ‘ವರ್ ಉಠುನ್ ಚಾ಼ಲ್’ ಮನ್ಹುನ್ ಸಾಂಗಾಚ಼ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","ಫನ್ ಮಾನ್ಸಾಚಾ ಲೇಕಾಲಾ ಪಾಪ ಮಾಪ್ ಕರಾಯಾ ದರ್ಥಿವ ಹಾಕ್ ಹಾ ಮನ್ಹುನ್ ಮಿ ತುಮಾನಾ ಖರ ಕರುನ್ ದ್ಯಾವ್ತೊ” ಮನ್‍ಲ್ಹಾ. ನಂತರ್ ಯೇಸುನಿ ಲಕ್ವಾ ಮ್ಯಾರ್‌ಲ್ಯಾಲ್ಯಾ ರೊಗಿಲಾ, “ಉಠುನ್, ತುಜ಼ ಹಾತ್ರುನ್ ಗಿಹುನ್ ಗರ‍್ಹಾತ್ ಜಾ಼” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","ತವಾ ತ್ಯೊ ಉಠುನ್ ಗರ‍್ಹಾತ್ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","ಲೊಕ ಹ್ಯ ಸಗ್ಳ ಬಗುನ್ ಗಾಭಾರ್ಲಿತ. ಮಾನ್ಸಾನಾ ಆಪ್ಲಾ ಹಾಕ್ ದಿಲಾ ಮನ್ಹುನ್ ಲೊಕಾಂಚಾನಿ ದೇವಾಲಾ ವವ್ಯಾಳಾ. ");
INSERT INTO gok_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","ಯೇಸು ಜಾ಼ಯಿತ್‍ ಆಸ್ಥಾನಾ, ಜ಼ಖತ್ ಗೊಳಾ ಕರ್ತ್ಯಾಲ್ಯಾ ಮತ್ತಾಯಾ ಮಂಥ್ಯಾಲ್ಯಾ ಮಾನ್ಸಾಲಾ ಬಗ್ಲಾ. ಮತ್ತಾಯಾ ಜ಼ಖತಿಚಾ ಕಠ್ಯಾವ ಬಸ್ಲಾ ಹುತ್ತಾ. ಯೇಸು ತ್ಯಲಾ ಮಾಜೆ ಮಾಗ್ನಿ ಯೇ ಮನ್ಲಾ. ತವಾ ಮತ್ತಾಯಾ ಉಠುನ್ ಯೇಸುಚೆ ಮಾಗ್ನಿ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","ಯೇಸು ಮತ್ತಾಯಾಚಾ ಗರ‍್ಹಾತ್ ಜೆವ್ನಾಲಾ ಬಸ್ಲಾ. ತವಾ ಜ಼ಖತ್ ಗೊಳಾ ಕರ್ತ್ಯಾಲ ಆನಿ ಪಾಪಿ ಲೊಕ್ ಯೇಸುಚೆ ಸಂಗ ಖಾಯಾ ಬಸ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","ಹ್ಯ ಬಗ್‌ಲ್ಯಾಲ ಫರಿಸಾಯ್ ಯೇಸುಚಾ ಶಿಶಾನಾ, “ತುಮ್‍ಚಾ಼ ಪ್ರಭು ಜ಼ಖತ್ ಗೊಳಾಕರ್ತ್ಯಾಲ್ಯಾಂಚೆ ಸಂಗ ಆನಿ ಪಾಪಿ ಲೊಕಾಂಚೆ ಸಂಗ ಕಾ ಜೆವಾನ್ ಖಾತ್ಯೊ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","ಫರಿಸಾಯಾಂಚಾನಿ ಸಾಂಗ್‌ಲ್ಯಾಲ ಐಕುನ್ ಯೇಸುನಿ ತ್ಯನಾ, “ಬರಿ ಆಸ್‌ಲ್ಯಾಲ್ಯಾನಾ ವೈದ್ಯಾ ನಕೊ. ಬರಿ ನಸ್‌ಲ್ಯಾಲ್ಯಾನಾ ವೈದ್ಯಾ ವ್ಹಯಿ ");
INSERT INTO gok_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","ತುಮಿ ಜಾ಼ವುನ್, ‘ಮನಾ ಯಜ್ಞ ನಕೊ, ದಯಾ ವ್ಹಯಿ’ ಮನ್ಹುನ್ ದರ್ಮ ಶಾಸ್ತಾರಾತ್ ಲಿವ್‌ಲ್ಯಾಲ್ಯಾ ಸಬ್ದಾಚಾ಼ ಅರ್ಥ ಸಿಕಾ. ಮಿ ನಿಯತಿಚಾನಾ ಹಾಕ್ಟಾಯಾ ಆಲೊ ನಾಹಿ, ಪಾಪಿನಾ ಹಾಕ್ಟಾಯಾ ಆಲ್ಯೊ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","ಮಂಗ್ ಬಾಪ್ತಿಸ್ಮಾ ಯೊಹಾನಾಚಾ಼ ಶಿಶಾ ಯೇಸುಪ ಯವುನ್. ತೇ ಯೇಸುಲಾ, “ಆಮಿ ಆನಿ ಫರಿಸಾಯ್ ತವಾತವಾ ಉಪಾಸ್ ಕರ್ತಾವ್. ಖರ ತುಜ಼ ಶಿಶಾ ಕಾ ಉಪಾಸ್ ಕರೀತ್ನಾಹಿತ? ಮನ್ಹುನ್ ಇಚಾರ್ತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","ಯೇಸುನಿ, “ಲಗ್ನಾಚಾ ಯಳಾಲಾ ನೌವ್‌ರ‍್ಯಾ ಸಂಗ ಆಸ್ನಾರ ತ್ಯಚ಼ ಸುಪ್ತಿ ದುಃಖಾನಿ ರಾಥ್ಯಾತ ಕ್ಯಾ? ನಾಹಿ ಫನ್ ನೌರಾ ತ್ಯನಾ ಸುಡುನ್ ಜಾ಼ಯಾಚಾ಼ ಯೊಳ್ ಯನಾರ್. ತವಾ ತೇ ಉಪಾಸಿ ರಾಥ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“ಕೊನ್ ಫಾಟುನ್ ಗೆಲ್ಯಾಲೆ ಜು಼ನ್ನೆ ವೈಲೆ ಆಂಗಿಲಾ ನವ್ಯಾ ಕಪ್‌ಡ್ಯಾಚಾ಼ ತುಕ್ಡಾ ಲಾವುನ್ ಸಿವಿತ್ನಾಹಿತ. ಆಕಾಸ್ಮಾತ್ ಸಿವ್‌ಲ್ಯಾವ, ತ್ಯೊ ಪಡ್ಕಾ ಪಿಂಜುಳುನ್ ಆಂಗಿತ್ನಿ ನಿಕ್ಳುನ್‌ಯನಾರ್. ತವಾ ತೀ ಆಂಗಿ ಆನಿಕ್ ಖುಬ್ ಫಾಟ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","ಯವ್ಡಸ್ ನವ್ಹ ಲೊಕ ನವಾ ದರಾಕ್ಶಿಚಾ಼ ರಸ್ ಜು಼ನ್ಯಾ ದರಾಕ್ಶಿಚಾ ರಸಾಚೆ ಚ಼ಮ್‌ಡ್ಯಾಚೆ ಪಿಸ್ವಿತ್ ಗಾಲ್ಹಿತ್ ನಾಹಿತ; ಕಾ ಮಂಜೆ ಜು಼ನ್ಯಾ ಚ಼ಮ್‌ಡ್ಯಾಚಾ ಪಿಸವ್ಯಾ ಫಾಟುನ್ ಜಾ಼ತ್ಯಾತಾ. ಆನಿ ದರಾಕ್ಶಿಚಾ಼ರಸ್ ಲಂವ್ಡುನ್ ಜಾ಼ತೊ. ತ್ಯಚಿಸ್ ಲಾಗುನ್ ಲೊಕ ಕವಾಬಿ ನವಾ ದರಾಕ್ಶಿಚಾ಼ರಸ್ ನವೆ ಚ಼ಮ್‍ಡ್ಯಾಚೆ ಪಿಸ್ವಿತ್ ಗಾಲ್ಹುನ್ ಥೆವ್‌ತ್ಯಾತ ತವಾ ದುನಿಬ್ಲಿಬಿ ರಾಥ್ಯಾತ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","ಯೇಸು ಹ್ಯಾ ಗುಶ್ಟಿ ಸಾಂಗ್‌ತ್ಯಾಲಾ ಆಸ್ಥಾನಾ ಸಭಾಸ್ಥಾನಾತ್ಲಾ ಅಧಿಕಾರಿಯಕ್ಲಾ ತ್ಯಚಿಪ ಯವುನ್ ತ್ಯಲಾ ವಾಕುನ್ ಹಾತ್ ಜು಼ಡುನ್, “ಮಾಜಿ ಲೇಕ್ ಆತಾಸ್ ಮಿಲಿ. ಫನ್ ತು ಯವುನ್ ತಿಲಾ ಹಾತ್‌ಲ್ಯಾವ್‌ಲ್ಯಾವ ತೀ ಆನಿಕ್ ಜಿತ್ತಿ ವ್ಹನಾರ್” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","ತವಾ ಯೇಸು ಉಠುನ್ ಅಧಿಕಾರ‍್ಯಾ ಸಂಗ ಗೆಲಾ. ಯೇಸುಚ಼ ಶಿಶಾ ಸಾಹಿತ್ ಗೆಲ. ");
INSERT INTO gok_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","ಬಾರಾ ವರ್ಸಾಠಾವ್ನಿ ಆಂಗಾವ್ನಿ ರಗಾತ್ ಜಾ಼ತ್ಯಾಲಾ ರೊಗ್ ಆಸ್‌ಲ್ಯಾಲಿ ಯೇಕ್ ಬಾಯಿಲ್ ಮಾನುಸ್ ತಿಥ ಹುತ್ತಿ. ತೀ ಬಾಯಿಲ್ ಮಾನುಸ್ ಯೇಸುಚೆ ಮಾಗ್ನಿ ಯವುನ್ ತ್ಯಚೆ ವೈಲೆ ಆಂಗಿಚಾ ಟೊಕಾಲಾ ಹಾತ್‌ಲ್ಯಾವ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","ತೇ ಬಾಯಿಲ್ ಮಾನ್ಸಾನಿ, “ತ್ಯಚೆ ಆಂಗಿಲಾ ಹಾತ್‌ಲ್ಯಾವ್‌ಲ್ಯಾವ ಪುರೊ, ಮಿ ಬರಿ ವ್ಹನಾರ್” ಮನ್ಹುನ್ ಇಚಾರ್ ಕೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","ಯೇಸು ಮಾಗಾರಾ ಪರ್ತುನ್ ತೇ ಬ್ಯಾಯ್ಕಾ ಮಾನ್ಸಾಲಾ ಬಗುನ್, “ಲೀಕಿ, ದಿರ‍್ಹಾನಿ ರ‍್ಹಾ! ತುಜಾ ಇಸ್ವಾಸಾನಿ ತುಲಾ ಬರ ಜಾ಼ಲ” ಮನ್ಹುನ್ ಸಾಂಗ್ತೊ. ತವಾಸ್ ತೀ ಬರಿ ಜಾ಼ಲಿ. ");
INSERT INTO gok_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","ಮಂಗ್ ಯೇಸು ಅಧಿಕಾರ‍್ಯಾ ಸಂಗ ತ್ಯಚಾ ಗರ‍್ಹಾತ್ ಗೆಲಾ. ಮಡ ನಿಹ್ಯಾ ಆಲ್ಯಾಲ ವಾಜ಼ಪ ವಾಜಿವ್‌ತ್ಯಾಲ್ಯಾನಾಬಿ ರಡ್‌ತ್ಯಾಲ್ಯಾನಾಬಿ ಯೇಸುನಿ, ");
INSERT INTO gok_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","“ದುರ್ ಜಾ಼ವಾ, ಪ್ಯೊರ್ ಮೀಲಿ ನಾಹೀ. ತೀ ನಿಜ್ಲೆ಼” ಮನ್ಲಾ. ಫನ್ ತ್ಯಂಚಾನಿ ಯೇಸುಚಿ ಟಿಂಗಲ್ನಾ ಕಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","ಲೊಕಾನಾ ಬಾಹಿರ್ ಲಾವುನ್ ದಿಲ್ಯಾವ ಯೇಸು ಆತ್ ಜಾ಼ವುನ್. ಪುರಿಚಾ ಹಾತಾಲಾ ದರ್ಲ ತವಾಸ್ ತೀ ಪ್ಯೊರ್ ಉಠುನ್ ಉಬಿರಾಯ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","ಹಿ ಬಾತ್ನಿ ಸಗ್ಳೆ ದುನೆತ್ ಪಗಾಳ್ಳಿ. ");
INSERT INTO gok_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","ಯೇಸು ತಿಥ್ನಿ ಜಾ಼ತಾನಾ ದೊಗ ಆಂದ್ಳ ತ್ಯಚೆ ಮಾಗ್ನಿ ಗೆಲ. ತೇ ದಾವಿದಾಚಾ ಲೇಕಾ ಆಮ್ಚಿವ ದಯಾ ದ್ಯಾವ್ ಮನ್ಹುನ್ ಜೊ಼ರಾನಿ ವರಾಡ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","ಯೇಸು ಗರ‍್ಹಾತ್ ಗೆಲಾ. ದೊಗ ಆಂದ್ಳ ತವಾ ತ್ಯಚೆ ಸಂಗ ಗೆಲ. ಯೇಸು ತ್ಯನಾ, “ಮಿ ತುಮಾನಾ ಬರ ಕರ್ತೊ ಮನ್ಹುನ್ ತುಮಿ ಇಸ್ವಾಸ್ ಥೆವ್ತಾಸಾ ಕ್ಯಾ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ಅಂದ್ಳ, “ವ್ಹಯ್ ಪ್ರಭು, ಆಮಿ ಇಸ್ವಾಸ್ ಥೆವ್ತಾವ್” ಮನ್ಹುನ್ ಉತ್ತರ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","ತವಾ ಯೇಸುನಿ ತ್ಯಂಚಾ ಡೊಳ್ಯಾನಾ ಹಾತ್ ಲಾವುನ್, “ತುಮಿ ಇಸ್ವಾಸ್ ಥೆವ್‌ಲ್ಯಾ ಶಾರ್ಕ ತುಮಾನಾ ಬರ ವ್ಹವುನಿ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","ತವಾಸ್ ತ್ಯನಾ ನದಾರ್ ಆಲಿ. “ಹಿ ಗ್ಯೊಶ್ಟ್ ಕುನಾಲಾ ಸಾಂಗು ನಕೊಸಾ” ಮನ್ಹುನ್ ಯೇಸುನಿ ತ್ಯನಾ ಖಡ್ಯಾವುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","ಖರ ತೇ ಆಂದ್ಳ ತಿಥ್ನಿ ನಿಗುನ್ ಜಾ಼ವುನ್ ಯೇಸುಚಿ ಬಾತ್ನಿ ತೆ ಸಗಳೆ ದುನೆತ್ ಪಗಾಳ್ಳಿ. ");
INSERT INTO gok_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","ತೇ ದೊಗ ಜಾ಼ತಾನಾ ಥೊಡ್ಯಾಂಚಾನಿ ದುಸ್‌ರ‍್ಯಾ ಯಕಾಲಾ ಯೇಸುಚೆ ಜ಼ವಳ ಆನ್ಲಾ. ತ್ಯಚಿಪ ಭುಥ್ ಹುತ್ತ ಮನ್ಹುನ್ ತ್ಯೊ ಮುಕ್ಕಾ ಜಾ಼ಲ್ಥಾ. ");
INSERT INTO gok_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","ಯೇಸು ತ್ಯಾ ಭುಥಾಲಾ ಸುಡುನ್ ಜಾ಼ ಮನ್ಹುನ್ ತಾಕಿತ್ ಕರ್ತೊ. ತವಾ ತ್ಯೊ ಬೊಲಾಯಾ ಲಾಗ್ಲಾ ಹ್ಯ ಬಗ್‌ಲ್ಯಾಲಿ ಲೊಕ ಚಮತ್ಕಾರ್ ವ್ಹವುನ್, “ಇಸ್ರಾಯಲಾತ್ ಆಸ್ಲಿ ಕಾಮ ಬಗ್ಲಿಸ್ ನಾಹಿತ” ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","ಫನ್ ಫರಿಸಾಯ್ ಲೊಕ್, “ಹ್ಯೊ ಭುಥಾಂಚಾ ಅಧಿಕಾರಿಚಾ ಬಳಾನಿ ಭುಥ ಸುಡಿವ್‍ತ್ಯೊ” ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","ಯೇಸು ಸಗ್ಳೆ ಪೆಠತ್ನಿ ಆನಿ ಸಗ್‌ಳ್ಯಾ ಗಾವಾತ್ನಿ ಪಿರ್ಲಾ. ಯೇಸು ತ್ಯಂಚಾ ಸಭಾಸ್ಥಾನಾತ್ನಿ ಸಿಕಿವಿತ್ ದೇವಾಚಾ ರಾಜಾಚೆ ಗುಶ್ಟಿತ್ ಚಾ಼ಂಗಲ್ಯಾ ಖಬ್ರಿ ಸಾಂಗ್‌ಲ್ಯಾ. ಸಗಳೆ ತರಚ಼ ರ‍್ವಾಗ್ ದುಖ ಬರಿ ಕಿಲಿತ ");
INSERT INTO gok_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","ದುಖಾತ್ನಿ ತಳ್ಮಳ್‌ತ್ಯಾಲಿ ಆನಿ ಮಜ಼ತ್ ನಸ್ನಾರಿ ಕಿತಿತರಿ ಲೊಕಾನಾ ಯೇಸು ಬಗುನ್ ರಡ್ಲಾ. ಗುರಿಕಾ ನಸ್‌ಲ್ಯಾಲ್ಯಾ ಮೆಂಡ್ರಾಂಚಿಗತ್ ತೀ ಹುತ್ತಿತ. ");
INSERT INTO gok_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","ಯೇಸುನಿ ಆಪ್‌ಲ್ಯಾ ಶಿಶಾನಾ ಸಾಂಗ್ಲ, “ಪೀಕ್ ಖುಬ್, ಫನ್ ಕಾಮ್ಗಾರ್ ಥೊಡ. ");
INSERT INTO gok_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","ಪಿಕಾಚಾ಼ ದನ್ಹಿ ದೇವ್. ಮನ್ಹುನ್ ಖುಬ್ ಕಾಮ್ಗಾರ‍್ಯಾನಾ ಲಾನಿಸಾಟಿ ಲಾವುನ್ ದಿಯಾ ತ್ಯಚಿಪ ಮಾಗ್ನ ಕರಾ” ಮನ್‍ಲ್ಹಾ. ");
INSERT INTO gok_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","ಯೇಸುನಿ ಆಪ್‍ಲ್ಯಾ ಬಾರಾಜಾ಼ನ್ ಶಿಶಾನಾ ಯಕಾನ್ಸಿ ಹಾಕ್ಟುನ್, ತ್ಯನಾ ಬುರ್ಸಿ ಆತ್ಮ ಸೊಡ್ವಾಯಾ ಸಗಳೆ ತರಚ಼ ರ‍್ವಾಗ್ ಆನಿ ದುಖ್ನಿ ಬರಿ ಕರಾಯಾ ಹುಕುಮ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","ಬಾರಾ ಜಾ಼ನ್ ಅಪೊಸ್ತಲಾಂಚಿ ನಾವ ಆಸಿ ಹತ್ತ. ಸಿಮೊನಾಲಾ ಪೇತ್ರು ಮನ್ಹುನ್ ಹಾಕಟ್‌ತ್ಯಾತ ಆನಿ ಹ್ಯಚಾ಼ ಬಾಹು ಆಂದ್ರೆಯಾ, ಜೆಬೆದಾಯಾಚಾ಼ ಲ್ಯೊಕ್ ಜಾ಼ಲ್ಯಾಲಾ ಯಾಕೊಬ್, ತ್ಯಚಾ಼ ಬಾಹು ಯೊಹಾನ್, ");
INSERT INTO gok_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ಫಿಲಿಪ್ಪ ಆನಿ ಬಾರ್ತೊಲೊಮಾಯಾ, ತೊಮ, ಜ಼ಖತ್ ಗೊಳಾಕರ್ತ್ಯಾಲಾ ಮತ್ತಾಯ್, ಅಲ್ಪಾಯಾಚಾ಼ ಲ್ಯೊಕ್ ಯಾಕೊಬ್, ತದ್ದಾಯ, ");
INSERT INTO gok_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ದೇಶೆಚಾ಼ ಭಗತ್ ಸಿಮೊನ್ ಆನಿ ಯೇಸುಲಾ ವೈರಿಂಚಾ ತಾಬ್ಯಾತ್ ದಿಲ್ಯಾಲಾ ಇಸ್ಕರಿಯೊತ್ ಯುದ್. ");
INSERT INTO gok_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","ಯೇಸುನಿ ಹ್ಯಾ ಬಾರಾ ಅಪೊಸ್ತಲಾನಾ ಥೊಡಾ ಹುಕುಮ್ ದಿವುನ್ ಸ್ವರ್ಗಾಚಾ ರಾಜಾಚ಼ ಸಾಂಗಾಯಾ ತ್ಯನಾ ಲಾವುನ್ ದಿಲ. ಯೇಸುನಿ ತ್ಯನಾ: “ಯೆಹುದಿ ನಸ್‌ಲ್ಯಾಲ್ಯಾ ಲೊಕಾಂಚಿಕ್ಡ ವ್ಹವುನಿ ಸಮಾರ‍್ಯಾತ್ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ಕಚಾಸ್ ಗಾವಾತ್ ಜಾ಼ವುನಕೋಸಾ. ಮನ್ಹುನ್ ಸುಸ್ನಾ ದಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","ಫನ್ ಚು಼ಕಲ್ಯಾಲ್ಯಾ ಮೆಂಡ್ರಾಂಚೆಗತ್ ಆಸ್‍ಲ್ಯಾಲ್ಯಾ ಇಸ್ರಾಯಲಾಂಚಿಪ ಜಾ಼ವಾ, ");
INSERT INTO gok_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","ಸ್ವರ್ಗಾಚ಼ ರಾಜ ಬಿಗಿನಿ ಯನಾರ್ ಮನ್ಹುನ್ ಜಾ಼ವುನ್ ಸಾಂಗಾ. ");
INSERT INTO gok_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","ರೊಗಿನಾ ಬರಕರಾ. ಮೇಲ್ಯಾಲ್ಯಾನಾ ಜಿತ್ತಿ ಕರಾ. ಕುಶ್ಟರೊಗಿನಾ ಬರ ಕರಾ. ಲೊಕಾನಾ ಬುಥಾಂಚಿಪ್ನಿ ಸುಟ್ಕಿಕರಾ. ಮಿ ತುಮಾನಾ ಫುಕಟ್ ದೇತೊ. ಮನ್ಹುನ್ ತುಮಿ ದುಸ್‌ರ‍್ಯಾನಾ ಫುಕಟ್ ದೆವಾ. ");
INSERT INTO gok_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","ತುಮ್ಚಿ ಸಂಗ ತಾಂಬ್ಯಾಚ಼ ಪೈಸ, ಚಾ಼ಂದಿ ಸೊನ ವ್ಹವುನಿ ಗಿಹುನ್ ಜಾ಼ವು ನಕೊಸಾ ");
INSERT INTO gok_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ಪಿಸ್ವಿ, ಆಗಾವ್ ಕಪ್ಡ, ವ್ಹಾನಾ, ಕಾಠ್ಯಾ, ಗಿಹುನ್ ಜಾ಼ವು ನಕೊಸಾ. ಆಳಾಲಾ ವ್ಹಯಿ ತ್ಯ ದೆವಾ. ");
INSERT INTO gok_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","ತುಮಿ ಕಚಾ ತರಿ ಗಾವಾತ್ ನಾಹಿತ ಗರ‍್ಹಾತ್ ಗೆಲಾಸಾಕಿ ತಿಥ ತುಮ್ಚಿ ದೆಕ್ರೆಕಿ ಕರ್ತ್ಯಾಲ್ಯಾ ಮಾನ್ಸಾಲಾ ತುಮಿ ತ್ಯೊ ಗಾವ್ ಸುಡಿ ಪರತ್ ತ್ಯಚಾ ಗರ‍್ಹಾತುಸ್ ರಾವ್ಹಾ. ");
INSERT INTO gok_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","ತ್ಯಾ ಗರ‍್ಹಾತ್ ತುಮಿ ಗೆಲಾಸಾಕಿ, ‘ತುಮಾನಾ ಬರ ವ್ಹವುನಿ’ ಮನ್ಹಾ. ");
INSERT INTO gok_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","ತ್ಯಾ ಗರ‍್ಹಾತ್ಲಿ ಲೊಕ ತುಮ್ಚಾ ಆಶಿರ್ವಾದಾಲಾ ಚಾ಼ಂಗ್ಲಿ ಆಸ್ಲಿತತ ತ್ಯೊ ಆಶಿರ್ವಾದ್ ತ್ಯನಾ ರಾಹುನಿ. ನಸ್ಲಿತತ ತ್ಯೊ ಆಶಿರ್ವಾದ್ ತುಮಾನಾ ಮಾಗಾರಾ ಪರ್ತುನ್ ಯವುನಿ. ");
INSERT INTO gok_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","ಯಕಾ ಗರ‍್ಹಾತಲ್ಯಾಂಚಾನಿ ನಾಹಿತ ಯಕಾ ಗಾವಾತಲ್ಯಾಂಚಾನಿ ತುಮಾನಾ ಹಾಕಟ್ಲ ನಾಹಿತ ತುಮ್ಚಿ ಬುಲಿ ಐಕ್ಲಿ ನಾಹಿತ ತುಮಿ ತ್ಯೊ ಜಾ಼ಗಾ ಸುಡುನ್ ಜಾ಼ತಾನಾ, ತುಮ್ಚಾ ಪಾಯಾಚಿ ಧುಳ್ ಜಾ಼ಢಾ. ");
INSERT INTO gok_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","ನ್ಯಾಯಿ ನಿವ್ಡಾಚಾ ದಿಸಾತ್ ಹ್ಯಾ ಗಾವಾಚಿ ಪರಸ್ಥಿತಿ ಸೊದೊಮ್ ಆನಿ ಗೊಮೊರಾವ್ನಿ ಖುಬ್ ಬುರ್ಸಿ ವ್ಹನಾರ್ ಮನ್ಹುನ್ ಮಿ ತುಮಾನಾ ಖರ‍್ಯಾನಿ ಸಾಂಗ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“ಐಕಾ! ನ್ಯಾನ್‌ಗ್ಯಾಂಚೆ ಮದ್ದಿ ಮೆಂಡ್ರ ಶೊಡ್‌ಲ್ಯಾಚೆಗತ್ ಮಿ ತುಮಾನಾ ಲಾವುನ್ ದೇತೊ. ಮನ್ಹುನ್ ತುಮಿ ಸಾಪಾಚೆಗತ್ ಹುಶಾರ್ ರಾವ್ಹಾ ಪ್ಯಾರ್‌ವ್ಯಾಚೆಗತ್ ಥಂಡ್ ರಾವ್ಹಾ. ");
INSERT INTO gok_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","ಲೊಕಾಂಚೆ ಗುಶ್ಟಿತ್ ಹುಶಾರಿನಿ ರಾವ್ಹಾ. ತೀ ತುಮಾನಾ ನ್ಯಾಯಿ ಕರ್ತ್ಯಾಲ್ಯಾಂಚಾಪ ಬಾಂದುನ್ ನೆನ್ಹಾರ್. ತೇ ತುಮಾನಾ ಆಪ್‌ಲ್ಯಾ ಯೆಹುದ್ಯಾಂಚಾ ಸಭಾಸ್ಥಾನಾತ್ ಕಾಟ್ಯಾಚಾ ಚಾಬುಕಾನಿ ಮ್ಯಾರ‍್ನಾರ್ ");
INSERT INTO gok_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","ತುಮಾನಾ ಮಾಜಿಸ್‍ ಲಾಗುನ್ ಅಧಿಕಾರ‍್ಯಾಂಚೆ ಮೊರ‍್ಹ ರಾಜಾಂಚೆ ಮೊರ‍್ಹ ಯೆಹುದಿ ನಸ್‌ಲ್ಯಾಲ್ಯಾ ಲೊಕಾಂಚೆ ಮೊರ‍್ಹ ನೆನ್ಹಾರ್ ತಿಥ ತುಮಿ ಮಾಜಿ ವಳಕ್ ವ್ಹವುನ್ ರಾನ್ಹಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","ತುಮಾನಾ ಬ್ಯಾಂದ್ಲತ ತುಮಿ ಕ್ಯಾ ಬೊಲಾಯಾ ವ್ಹಯಿ ತ್ಯ ಯವ್ಜು ನಕೊಸಾ ತುಮಿ ಸಾಂಗಾಯಾ ವ್ಹಯಿ ತ್ಯ ತ್ಯಾ ಯಳಾಲಾ ತುಮಾನಾ ಸಮಾಜ಼ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","ಬೊಲ್ನಾರ ಖರ‍್ಯಾ ಫನಾನಿ ತುಮಿ ನವ್ಹಸಾ. ತುಮ್ಚಾ ಬಾಚ಼ ಪವಿತ್ರ ಆತ್ಮ ತುಮ್ಚಿ ಸಂಗ ಬೊಲ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“ಬಾಹು ಸ್ವತಾಚಾ ಬಾವ್ಹಾನಾ ವಾದಿ ವ್ಹವುನ್ ಮಾರುನ್ ಟಾಕಾಯಾ ದಿಯಿಲ್. ಬಾಸ ಆಪ್‌ಲ್ಯಾ ಸ್ವತಾಚಾ ಪೊರಾನಾ ವಾದಿ ವ್ಹವುನ್ ಮಾರುನ್ ಟಾಕಾಯಾ ದಿಯಿಲ್ ಪೊರ ಆಯಿ ಬಾಲಾ ವಾದಿ ವ್ಹವುನ್ ತ್ಯನಾ ಮಾರುನ್ ಟಾಕಾಯಾ ದಿತಿಲ. ");
INSERT INTO gok_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","ತುಮಿ ಮಾಜೆ ಮಾಗ್ನಿ ಯತಾಸಾ ಮನ್ಹುನ್ ಲೊಕಾಂಚಾನಿ ತುಮ್ಚಿ ನಿಂದಾ ಕರ್ತ್ಯಾತ. ಫನ್ ಮರ ಪರ‍ತ್ ಸುಸ್ವುನ್ ರಾಹಿಲ್‍ ತ್ಯಚ಼ ರಕ್ಷನ್ ವ್ಹಯಿಲ್. ");
INSERT INTO gok_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","ಯಕಾ ಗಾವಾತ್ ತುಮಾನಾ ಸತಿವ್ಲತ ದುಸ್‌ರ‍್ಯಾ ಗಾವಾತ್ ಜಾ಼ವಾ. ಮಾನ್ಸಾಚಾ಼ ಲ್ಯೊಕ್ ಪರ್ತುನ್ ಯಯಾಚೆ ಆಂದಿ ತುಮಿ ಇಸ್ರಾಯಲ್ ಗಾವಾತ್ನಿ ಸಗ್‍ಳ್ಯಾ ಜಾ಼ಯಾಚ಼ ಸಪಿವ್ನಾರ್ ನಾಹಿಸಾ ಮನ್ಹುನ್ ಮಿ ತುಮಾನಾ ಖರ‍್ಯಾನಿ ಸಾಂಗ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“ಶಿಶಾ ಗುರುವ್ನಿ ಮೊಟಾ ನವ್ಹ. ಚಾ಼ಕೊರ್ ಆಪ್‌ಲ್ಯಾ ದನ್ಯಾವ್ನಿ ಮೊಟಾ ನವ್ಹ. ");
INSERT INTO gok_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","ಶಿಶಾ ಆಪ್‌ಲ್ಯಾ ಗುರುಚೆಗತ್ ಚಾ಼ಲ್ಲಾ ಪುರೊ. ಚಾ಼ಕೊರ್ ದನ್ಯಾಚೆಗತ್ ಚಾ಼ಲ್ಲಾ ಪುರೊ. ಕುಟ್ಮಾಚಾ ದನ್ಯಾಲಾ ಬುಥಾಂಚಾ಼ ದನ್ಹಿ ಬೆಲ್ಜೆಬುಲ್’ ಮನ್ಹುನ್ ಹಾಕಟ್‌ಲ್ಯಾವ, ತ್ಯಾ ಕುಟ್ಮಾತಲ್ಯಾ ದುಸ್‌ರ‍್ಯಾನಾ ಆನಿಕ್ ಖುಬ್ ಬುರ್ಶಾ ನಾವಾನಿ ಹಾಕಟ್ನಾರ್ ನವ್ಹ? ");
INSERT INTO gok_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“ತ್ಯಚಿಸಾಟಿ ತ್ಯಾ ಲೊಕಾನಾ ಬಿಹುನಕೋಸಾ ಆಡ್‌ಶಾ ಆಸ್ನಾರ ಪರ್ತೆಕ್ ಬಾಹಿರ್ ಯನಾರ್ ಚು಼ರುನ್ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ಪರತೇಕ್ ಗುಶ್ಟಿ ಬಾಹಿರ್ ಯನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","ಆಂದಾರಾತ್ ಕುನಾಲಾ ಠಾವ್ಯಾ ನಸಲ್ಯಾಲ್ಯಾ ಹ್ಯಾ ಗುಶ್ಟಿ ಮಿ ತುಮಾನಾ ಸಾಂಗ್ತೊ. ಖರ ತುಮಿ ಹ್ಯಾ ಗುಶ್ಟಿ ಉಜಿಡಾತ್ ಸಾಂಗಾಯಾ ವ್ಹಯಿಸಾ ಮನ್ಹುನ್ ಮಾಜಿ ಇಚ್ಚಾ. ಮಿ ಹ್ಯಾ ಗುಶ್ಟಿ ತುಮಾನಾ ಸಾವ್ಕಾಸ್ ಸಾಂಗ್ತೊ. ಫನ್ ತುಮಿ ಹ್ಯಾ ಗುಶ್ಟಿ ಲೊಕಾನಾ ಸಗ್‌ಳ್ಯಾ ಜೊ಼ರಾನಿ ಸಾಂಗಾ. ");
INSERT INTO gok_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","“ಲೊಕಾನಾ ಬಿಹುನಕೋಸಾ. ತೀ ದಢಾಲಾ ತ್ಯವ್ಡಸ್ ಮ್ಯಾರ್ತಿಲ. ಜೀವಾಲಾ ತೀ ಮಾರಿತ್ ನಾಹಿತ. ಧಡ್ ಆನಿ ಜೀವ್ ನರ್ಕಾತ್ ಗ್ಯಾಲ್ನಾರ‍್ಯಾ ದೇವಾಲಾ ಬಿವ್ಹಾ. ");
INSERT INTO gok_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","ಬಾಜಾ಼ರಾತ್ ದೊನ್ ಚಿಮ್ನಿ ಪಾಕ್ರ ದೊನ್ ಪೈಶಾನಾ ಇಕ್‌ತ್ಯಾತ ಖರ ತುಮ್ಚಾ ಬಾನಿ ಹುಕುಮ್ ದಿಯಿ ಪರತ್ ತ್ಯಾತ್ಲ ಯಾಕ್ಬಿ ಮರ್ನಾರ್ ನಾಹಿ ");
INSERT INTO gok_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","ತುಜೆ ಡುಯಿತ್ಲ ಕ್ಯಾಸ್ ಕ್ಯವ್ಡ ಹಾತ್ತ ಮನ್ಹುನ್ ದೇವಾಲಾ ಠಾವ ಹಾತ್ತ. ");
INSERT INTO gok_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","ತ್ಯಚಿಸ್ ಲಾಗುನ್ ಬಿಹುನಕೋಸಾ. ತುಮಿ ಚಿಮನ್ಯಾ ಪಾಕ್ರಾಂಚಿವ್ನಿ ಖುಬ್ ಕಿಮ್ತಿಚಿ ಹಾಸಾ. ");
INSERT INTO gok_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“ಯಕಾನಿ ದುಸ್‌ರ‍್ಯಾಚೆ ಮೊರ‍್ಹ ಆಪ್ನು ಮಾಜಾ಼ ಮನ್ಹುನ್ ಸಾಂಗ್‌ಲ್ಯಾವ, ಮಿ ಸ್ವರ್ಗಾತ್ ಮಾಜಾ ಬಾಚೆ ಮೊರ‍್ಹ ತ್ಯಲಾ ಮಾಜಾ಼ ಮನ್ಹುನ್ ಸಾಂಗ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","ಫನ್ ಯಕಾನಿ ಲೊಕಾಂಚೆ ಮೊರ‍್ಹ, ಆಪ್ನು ಮಾಜಾ಼ ನವ್ಹ ಮನ್ಹುನ್ ಸಾಂಗ್ಲಾತ, ಮಿ ಬಿ ಸ್ವರ್ಗಾತ್‍ಲ್ಯಾ ಮಾಜಾ ಬಾಚೆ ಮೊರ‍್ಹ ತ್ಯೊ ಮಾಜಾ಼ ನವ್ಹ ಮನ್ಹುನ್ ಸಾಂಗ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“ದರ್ಥಿವ ಸಮಾದಾನ್ ಕರಾಯಾ ಮಿ ಆಲ್ಯೊ ಮನ್ಹುನ್ ಯವ್ಜುನಕೊಸಾ. ಮಿ ಸಮಾದಾನ್ ದಿಯಾ ಆಲೊ ನಾಹಿ, ದುಯಿ ಗಾಲಾಯಾ ಆಲ್ಯೊ. ");
INSERT INTO gok_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","36","‘ಯಕಾಲಾ ತ್ಯಚಾ ಗರ‍್ಹಾತ್ಲಿಸ್ ವಾದಿ ವ್ಹನಾರ್ ಲ್ಯೊಕ್ ಬಾಲಾ, ಲೇಕ್ ಆಯಿಲಾ, ಸೂನ್ ಸಾಸೊಲಾ ವಾದಿ ವ್ಹನಾರ್’ ");
INSERT INTO gok_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“ಕುನಿತರಿ ಮನಾ ಮಾಯಾ ಕರಾಚಿ ಸುಡುನ್ ಲ ಆಪ್‌ಲ್ಯಾ ಬಾಲಾ ನಾಹಿತ ಆಯಿಲಾ ಮಾಯಾ ಕಿಲಿತ, ತ್ಯೊ ಮಾಜಿ ಮಾಗ್ನಿ ಯಯಾಲಾ ಲಾಯಕ್ ನಾಹಿ. ಕುನಿತರಿ ಮಾಜಿ ಮಾಯಾ ಕರಾಚಿ ಸುಡುನ್ ಆಪ್‌ಲ್ಯಾ ಲೇಕಾಚಿ ನಾಹಿತ ಲೀಕಿಚಿ ಮಾಯಾ ಕಿಲಿತ, ತ್ಯೊ ಮಾಜೆ ಮಾಗ್ನಿ ಯಯಾ ಲಾಯ್ಕ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","ಕೊನ್ತರಿ ಮಾಜೆ ಮಾಗ್ನಿ ಯತಾನಾ ತ್ಯಲಾ ಆಲ್ಯಾಲ ದುಖ್ ಆಪ್ಲ ಮನ್ಹುನ್ ಮನ್‍ಲ್ಹಾ ನಾಹಿತ, ತ್ಯೊ ಮಾಜೆ ಮಾಗ್ನಿ ಯಯಾಲಾ ಲಾಯಕ್ ನಾಹಿ ");
INSERT INTO gok_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","ಮನಾ ಮಾಯಾ ಕರಾಚೆ ಪಕ್ಶಿ ಆಪ್‌ಲ್ಯಾ ಜೀವಾಚಿ ಮಾಯ ಕರ್ತ್ಯಾಲಾ. ತ್ಯೊ ಸಾಂಡುನ್ ಗೇತೊ. ಮಾಜಿಸಾಟಿ ಆಪ್ಲಾ ಜೀವ್ ಸಾಂಡುನ್ ಗೆಥ್ಯಾಲಾ ತ್ಯೊ ಪುನಃ ಗಾವಲ್. ");
INSERT INTO gok_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“ತುಮಾನಾ ಹಾಕ್ಟುನ್ ಗೆತ್ಯಾಲಾ ಮನಾ ಹಾಕಟ್ನಾರ್. ಮನಾ ಹಾಕಟ್ನಾರಾ ಮನಾ ಲಾವುನ್ ದಿಲ್ಯಾಲ್ಯಾ ದೇವಾಲಾಬಿ ಹಾಕ್ಟುನ್ ಗೇತೊ. ");
INSERT INTO gok_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","ಪ್ರವಾದಿಲಾ ಪ್ರವಾದಿ ಮನ್ಹುನ್ ಹಾಕಟ್ಯಾಲ್ಯಾಲಾ ತ್ಯಾ ಪ್ರವಾದಿಲಾ ಯತ್ಯಾಲಾ ಆಶಿರ್ವಾದ್ ಗಾವ್ನಾರ್. ನಿಯೆತಿಚಾನಾ ನಿಯೆತಿನಿ ಆಸಲ್ಯಾಲ್ಯಾಚಾ಼ ಆಶಿರ್ವಾದ್ ಗಾವ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","ಆನಿ ಹಿತ್‌ಲ್ಯಾ ಬಾರಿಕ್ ಆಸ್‍ಲ್ಯಾಲ್ಯಾ ಕುಚಾಲಾತರಿ ಯಕಾಲಾ ಮಾಜಾ ಶಿಶಾತ್ಲಾ ಯೊಕ್ ಮನ್ಹುನ್ ಕಚಾನಿತರಿ ಯೊಕ್ ಲೊಟಾ ಪಾನಿ ದಿಲತ ತ್ಯಲಾ ಯಯಾಚ಼ ಪ್ರತಿ ಫಳ್ ಚು಼ಕ್ನಾರುಸ್ ನಾಹಿ ಮನ್ಹುನ್ ಮಿ ಖರ‍್ಯಾನಿ ಸಾಂಗ್ತೊ ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","ಯೇಸುನಿ ಆಪ್‌ಲ್ಯಾ ಬಾರಾಜಾ಼ನ್ ಶಿಶಾನಾ ಹ್ಯಾ ಗುಶ್ಟಿ ಸಾಂಗಲ್ಯಾ ನಂತರ್ ತಿಥ್ನಿ ಸಿಕ್ವಾಯಾ ಆನಿ ಸಾಂಗಾಯಾ ಗಲಿಲಾಯ್ ಪೆಠತ್ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","ಬಾಪ್ತಿಸ್ಮಾ ಯೊಹಾನ್ ತುರುಂಗಾತ್ ಹುತ್ತಾ. ಕ್ರಿಸ್ತ ಕರ್ತ್ಯಾಲಿ ಕಾಮ ತ್ಯಲಾ ಸಮಾಜ್ಲಿತ. ಮನ್ಹುನ್ ಯೊಹಾನಾನಿ ಆಪ್‌ಲ್ಯಾ ಥೊಡ್ಯಾ ಶಿಶಾನಾ ತ್ಯಚಿಪ ಲಾವುನ್ ದಿಲ. ");
INSERT INTO gok_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ಯೊಹಾನಾಚ಼ ಶಿಶಾ ಯೇಸುಲಾ, “ಯೊಹಾನಾನಿ ಸಾಂಗ್‌ಲ್ಯಾ ಶಾರ್ಕ ಯನಾರಾ ಕ್ರಿಸ್ತ ತುಸ್ ಕ್ಯಾ ಆಮಿ ದುಸ್‌‍ರ‍್ಯಾಚಿ ವಾಟ್ ಬಗಾಯಾ ವ್ಹಯಿ? ಮನ್ಹುನ್ ಇಚಾರ್ತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","ತ್ಯಲಾ ಯೇಸುನಿ, “ತುಮಿ ಹಿತ್ತ ಐಕ್‌ಲ್ಯಾಲಿ ಆನಿ ಬಗಲ್ಯಾಲಿ ಕಾಮ ಯೊಹಾನಾಲಾ ಸಾಂಗಾ. ");
INSERT INTO gok_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","ಆಂದ್‌ಳ್ಯಾನಾ ನದಾರ್ ಯನಾರ್; ಥೊಟ ಆನಿಕ್ ಚಾ಼ಲತ್ಯಾತ; ಕುಶ್ಟರೊಗಿ ಬರ ವ್ಹತ್ಯಾತ; ಕಿವಂಡ್ಯಾಲಾ ಐಕು ಯತ ಮೇಲ್ಯಾಲ ಜಿತ್ತ ವ್ಹತ್ಯಾತ ಆನಿ ಗರೀಬ್ ಲೊಕಾನಾ ಚಾ಼ಂಗ್ಲಿ ಖಬರ್ ಸಾಂಗ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","ಮಾಜಿವ ಸಂಸೆವ್ ಕರಿನಸ್ನಾರಾ ಬರಾ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","ಯೊಹಾನಾಚ಼ ಶಿಶಾ ನಿಗುನ್ ಜಾ಼ತಾನಾ ಯೇಸು ಲೊಕಾಂಚೆ ಬರ್ಬರ್ ಯೊಹಾನಾಚ಼ ಬೊಲಾಯಾ ಲಾಗ್ಲಾ. ಯೇಸುನಿ, “ತುಮಿ ಕ್ಯಾ ಬಗಾಯಾ ರಾನಾತ್ ಗೆಲ್ತಾಸಾ? ವಾರ‍್ಯಾನಿ ಹಾಲ್‌ತ್ಯಾಲ ಡಾಳ್ಹ ಕ್ಯಾ? ನವ್ಹ! ");
INSERT INTO gok_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","ಖರ‍್ಯಾನಿ ತುಮಿ ಕ್ಯಾ ಬಗಾಯಾ ಗೆಲ್ತಾಸಾ? ನವ ಕಪ್ಡ ಗ್ಯಾತ್‌ಲ್ಯಾಲ್ಯಾ ಮಾನ್ಸಾಲಾ ಕ್ಯಾ? ನಾಹಿ! ನವ ಕಪ್ಡ ಗಾಲ್ಹುನ್ ಆಸ್‌ಲ್ಯಾಲಿ ಲೊಕ ರಾಜಾಚಾ ಗರ‍್ಹಾತ್ ರಾಥ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","ತಸ ಜಾ಼ಲ್ಯಾ, ಕ್ಯಾ ಬಗಾಯಾ ಗೆಲ್ತಾಸಾ? ಯಕಾ ಪ್ರವಾದಿಲಾ ಕ್ಯಾ? ವ್ಹಯ್! ಯೊಹಾನ್ ಪ್ರವಾದಿಂಚಿವ್ನಿ ಮೊಟಾ ಮನ್ಹುನ್ ಮಿ ತುಮಾನಾ ಸಾಂಗ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","ದೇವಾನಿ ಯೊಹಾನಾಚ಼ ಪವಿತ್ರ ಪುತೀಕಾತ್ ಆಸ ಸಾಂಗ್‌ಲ್ಯಾ: ‘ಹಬ! ಮಿ ಮಾಜಾ ದುತಾಲಾ ತುಜೆ ಆಂದಿ ಲಾವುನ್ ದೇತೊ ತ್ಯೊ ತುಜಿ ವಾಟ್ ತಯಾರ್ ಕರ್ನಾರ್ ");
INSERT INTO gok_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“ಆಜು಼ನ್ ಪರ‍್ಯಾತ್ ಮಾನ್ಸಾತ್ನಿ ಜ಼ಲಾಮ್‌ಲ್ಯಾಲಾತ್ ಬಾಪ್ತಿಸ್ಮಾ ಯೊಹಾನಾವ್ನಿ ಮೊಟಾ. ಕೊನುಸ್ ನಾಹಿ ಫನ್ ದೇವಾಚಾ ರಾಜಾತ್ ಆಸ್‌ಲ್ಯಾಲಾ ಬ್ಯಾರ್ಕಾಬಿ ಯೊಹಾನಾವ್ನಿ ಮೊಟಾ ಮನ್ಹುನ್ ಮಿ ತುಮಾನಾ ಖರ‍್ಯಾನಿ ಸಾಂಗ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","ಬಾಪ್ತಿಸ್ಮಾ ಯೊಹಾನ್ ಆಲ್ಯಾಲ್ಯಾ ಯಳಾದರ್ನಿ ಇತ್ಪರತ್ ಸ್ವರ್ಗಾಚ಼ ರಾಜೆ ಬಳಾನಿ ಮೊರ‍್ಹ ಮೊರ‍್ಹ ಜಾ಼ತ, ಘಾತ್ಕಿ ಲೊಕ ಜು಼ಲ್ಮಿನಿ ತ್ಯಂಚಿವ ಹುಕುಮ್ ಚಾ಼ಲ್ವಾಯಾ ಯತ್ನ ಕರ್ತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","ಸಗ್‌ಳ್ಯಾ ಪ್ರವಾದನೆ ಆನಿ ಮೊಶೆಚ಼ ಧರ್ಮಶಾಸ್ತಾರ್ ಯೊಹಾನ್ ಯಯಿಪರತ್ ದೇವಾಚಾ ರಾಜಾಚ಼ ಆಂದಿಸ್ ಸಾಂಗ್‍ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","ಧರ್ಮಶಾಸ್ತಾರ್ ಆನಿ ಪ್ರವಾದಿಂಚಾನಿ ಸಾಂಗ್‌ಲ್ಯಾಲ್ಯಾವ ತುಮಿ ಇಸ್ವಾಸ್ ಥೆವ್‌ಲ್ಯಾವ ಹ್ಯೊ ಯೊಹಾನುಸ್ ಎಲಿಯಾ. ತ್ಯೊ ಯನಾರ್ ಮನ್ಹುನ್ ಧರ್ಮಶಾಸ್ತಾರಾತ್ ಸಾಂಗ್‍ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","ಕುನಾಲಾ ಕಾನ್ ಹಾತ್ತ, ತ್ಯೊ ಐಕುನಿ! ");
INSERT INTO gok_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“ಹ್ಯಾ ಕಾಲಾತ್‌ಲ್ಯಾ ಲೊಕಾಂಚ಼ ಮಿ ಕ್ಯಾ ಸಾಂಗು? ತೀ ಕಸಿ ಹಾತ್ತ? ಹ್ಯಾ ಕಾಲಾತ್ಲಿ ಲೊಕ ಬಾಜಾ಼ರಾತ್ನಿ ಬಸುನ್ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ಪೊರಾಂಚೆಗತ್ ಹಾತ್ತ. ಯಕಾ ಹಿಂಡಾತ್ಲಿ ಪೊರ ಆನಿ ಯಕಾ ಹಿಂಡಾತ್‌ಲ್ಯಾ ಪೊರಾನಾ ಆಸಿ ಮಂತ್ಯಾತ: ");
INSERT INTO gok_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘ಆಮಿ ತುಮ್ಚೆಸಾಟಿ ವಾಜ಼ಪ ವಾಜಿವ್ಲಿತ ತುಮಿ ನಾಚ್ಲಾ಼ನಾಹಿಸಾ; ಆಮಿ ಮೇಲ್ಯಾಲ್ಯಾಂಚೆಸಾಟಿ ಮ್ಹನ್ ಮನ್ಹುನ್ ರಡ್ಲಾವ್, ತುಮಿ ರಡ್ಲಾ ನಾಹಿಸಾ’ ");
INSERT INTO gok_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","ಕಾ ಮಂಜೆ ಯೊಹಾನ್ ಆಲಾ. ಫನ್ ತ್ಯನಿ ದುಸ್‌ರ‍್ಯಾ ಲೊಕಾಂಚೆಗತ್ ಖಾಲ ನಾಹಿ ಉಪಾಸ್ ಕೆಲಾ. ದರಾಕ್ಶಿಚಾ಼ ರಸ್ ಪಿಯಾಲಾ ನಾಹಿ; ಫನ್ ಲೊಕ, ‘ತ್ಯಲಾ ಭುತ್ ದರ್‌ಲ್ಯಾ’ ಮನ್‍ಲ್ಹಿತ. ");
INSERT INTO gok_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","ಮಾನ್ಸಾಚಾ಼ ಲ್ಯೊಕ್ ಆಲಾ ತ್ಯೊ ದುಸ್‌ರ‍್ಯಾ ಲೊಕಾಂಚೆಗತ್ ಜೆವಾನ್ ಖಾತೊ; ದರಾಕ್ಶಿಚಾ಼ ರಸ್ ಪಿತೊ. ಫನ್ ಲೊಕ, ‘ಬಗಾ! ತ್ಯೊ ಖಾದೊಡಾ, ಪಿದೊಡಾ, ಜ಼ಖತ್ದಾರ್ ಆನಿ ಬುರ್ಸಿ ಲೊಕ ತ್ಯಚ಼ ಸುಪ್ತಿ ಜಾ಼ಲ್ಯಾತ ಮನ್ಹುನ್ ಮಂಥ್ಯಾತ ಫನ್ ಗಿನ್ಯಾನ್ ಆಪ್‌ಲ್ಯಾ ಕಾಮಾನಿಸ್ ಆಪ್ಲ ಗುನ್ ದಾವುನ್ ದೇತ. ” ");
INSERT INTO gok_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","ಮಂಗ್ ಯೇಸುನಿ, ಆಪ್ನು ಕುಟ್ಲೆ ಪೆಠತ್ ಖುಬ್ ಚಮತ್ಕಾರಾಚಿ ಕಾಮ ಕಿಲಿತ ತೇಸ್ ಪೆಠಲಾ ಖಡ್ಯಾವ್ಲಿ. ಕಾ ಮಂಜೆ ತೆ ಪೆಠತ್‌ಲ್ಯಾ ಲೊಕಾಂಚಾನಿ ಆಪ್ಲಾ ಜೀವ್ನಾ ಬದ್ದಲ್ಲಾ ನಾಹಿ ಆನಿ ಪಾಪ್ ಕರಾಚಿ ಥಾಂಬಿವ್ಲಿ ನಾಹಿತ. ");
INSERT INTO gok_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","ಯೇಸುನಿ ಸಾಂಗ್‌ಲ್ಯಾಲ ಕ್ಯಾ ಮಂಜೆ: “ಖೊರಾಜಿನೇ, ತುಜಿ ಹಾಕಿಗತ್ ಕ್ಯಾ ಸಾಂಗು? ಬೆತ್ಸಾಯ್, ತುಜಿ ಹಾಕಿಗತ್ ಕ್ಯಾ ಸಾಂಗು! ಮಿ ತುಮ್ಚಿಪ ಚಮತ್ಕಾರ ಕಿಲಿತ ತೀ ಚಮತ್ಕಾರ ತುರ್, ಸಿದೋನಾತ್ ಕಿಲಿ ಆಸ್ಥಿತತ. ತಿತಲ್ಯಾ ಲೊಕಾಂಚಾನಿ ಖುಬ್ ಕಾಲಾಚೆ ಮಾಗಸ್ ಆಪ್ಲ ಜೀವ್ನಾ ಬದಲ್ಲ ಆಸ್ಥ; ಆಪ್‌ಲ್ಯಾ ಪಾಪಾಂಚಿಸಾಟಿ ರಡುನ್ ಗೊಂತ್ಯಾಂಚ಼ ತಳ್ಕ ಬಾಂದುನ್ ಗಿಹಿತಿತ; ಆಂಗಾವ ರಾಕ್ ಗಾಲ್ಹುನ್ ಗಿಹಿತಿತ. ");
INSERT INTO gok_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","ಫನ್ ನ್ಯಾಯಿಚಾ ದಿಸಾತ್ ತುರ್, ಸಿದೋನಾವ್ನಿ ತುಮ್ಚಿ ಹಾಕಿಗತ್ ಖುಬ್ ಬುರ್ಸಿ ಸ್ಥಿತಿ ವ್ಹನಾರ್ ಮನ್ಹುನ್ ಮಿ ತುಮಾನಾ ಸಾಂಗ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“ಕಪೆರ್ನೌಮ್, ತು ಸ್ವರ್ಗಾತ್ ಉಚಾ಼ಲ್ನಾರ್ ಮನ್ಹುನ್ ಯವಸ್ತಿಸ್ ಕ್ಯಾ? ನಾಹಿ! ತು ನರಕಾತ್ ಪಡ್ನಾರ್. ಮಿ ತುಜಿಪ ಖುಬ್ ಚಮತ್ಕಾರ ಕಿಲಿತ. ಸೊದೊಮಿತ್ ತೀ ಚಮತ್ಕಾರ ಕಿಲಿ ಆಸ್ಥಿತತ. ತಿತಲ್ಯಾ ಲೊಕಾಂಚಾನಿ ಪಾಪ ಕರ್ತ್ಯಾಲಿ ಥಾಂಬಿವ್ಲಿ ಆಸ್ಥಿತ ಆನಿ ಆಜು಼ನ್ ಪರತ್ ತೀ ಪ್ಯಾಟುಸ್ ವ್ಹವುನ್ ರಾಹಿತಿ. ");
INSERT INTO gok_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","ಫನ್ ನ್ಯಾಯಿ ನಿವ್ಡಾಚಾ ದಿಸಾತ್ ತುಜಿ ಹಾಕಿಗತ್ ಸೊದೊಮಾವ್ನಿ ಖುಬ್ ಬುರ್ಸಿ ವ್ಹನಾರ್ ಮನ್ಹುನ್ ಮಿ ತುಮಾನಾ ಸಾಂಗ್ತೊ. ” ");
INSERT INTO gok_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","ಮಂಗ್ ಯೇಸುನಿ, “ಸ್ವರ್ಗಾಚಾ ಆನಿ ದರ್ಥಿವ್‌ಲ್ಯಾ ಪ್ರಭು ಜಾ಼ಲ್ಯಾಲ್ಯಾ ಬಾ, ತುಲಾ ಮಿ ಹಾತ್ ಜೊಡ್ತೊ. ಮಿ ತುಲಾ ವವ್ಯಾಳ್ತೊ. ಕಾ ಮಂಜೆ, ತು ಹ್ಯಾ ಗುಶ್ಟಿ ಶಾನ್ಯಾನಾ ಆನಿ ಬುದ್ದಿ ಆಸ್ನಾರ‍್ಯಾನಾ ಆಡ್‍ಶಾ ಕೇಲ್ಯಾಸ್. ಫನ್ ಬ್ಯಾರ್ಕ್ಯಾ ಮೂಲಾಂಚಿಗತ್ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ಹ್ಯಾ ಲೊಕಾನಾ ತು ದಾವುನ್ ದಿಲ್ಯಾಸ್. ");
INSERT INTO gok_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","“ವ್ಹಯ್ ಬಾ, ಹ್ಯ ಖರ‍್ಯಾನಿಸ್ ತುಜ಼ ಮನ್ ಹಾ ಮನ್ಹುನ್ ತು ಆಸ ಕೇಲ್ಯಾಸ್. ");
INSERT INTO gok_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“ಮಾಜಾ ಬಾನಿ ಸಗ್ಳ ಮನಾ ದಿಲ್ಯಾ. ಕುನಿ ಲೇಕಾಲಾ ಸಮಜು಼ನ್ ಗೆತ್ಲಾನಾಹಿ. ಬಾನಿ ತ್ಯವ್ಡಾಸ್ ಲೇಕಾಲಾ ಸಮಜು಼ನ್ ಗೇತಲ್ಯಾ ಕುನಿ ಬಾಲಾ ಸಮ್ಜುನ್ ಗೆತ್ಲ ನಾಹಿ. ಲೇಕಾನಿ ತ್ಯಡಸ್ ಬಾಲಾ ಸಮ್ಜುನ್ ಗೇತಲ್ಯಾ ಲ್ಯೊಕ್ ಬಾಲಾ ಕುನಾಲಾ ದಾವುನ್ ದಿಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಮನ್ ಕರ್ತೊ ತೇ ಬಾಲಾ ಸಮ್ಜುನ್ ಗೇತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“ತರಾಸ್ ಖಾತ್ಯಾಲ್ಯಾನು, ವಜ಼ ಗೆತಲ್ಯಾನು, ತುಮಿ ಸಗ್ಳಿ ಮಾಜಿಪ ಯವಾ ಮಿ ತುಮಾನಾ ಆರಾಮ್ ದೇತೊ. ");
INSERT INTO gok_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","ಮಾಜಾ ಜ್ವಾ಼ಲಾ ಖಾಂದಾ ದಿವುನ್ ಮಾಜಿಪ್ನಿ ಸಿಕಾ. ಮಿ ದಯಾಳು‍ ಆನಿ ಸಾದಾ ಬೊಳ್ಹಾ ಮಾನುಸ್ ಜಾ಼ಲ್ಯೊ ಮನ್ಹುನ್ ತುಮಿ ತುಮ್ಚಾ ಜೀವಾಲಾ ಆರಾಮ್ ಬಗ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","ವ್ಹಯ್, ಮಾಜ಼ ಜು಼ ತುಮಾನಾ ಉಚ್ಲಾ಼ಯಾ ಸಲ್ಪ ಜಾ಼ಲ್ಯಾ; ಮಾಜ಼ ವಜ಼ ಹಾಲ್ಕ ಜಾ಼ಲ್ಯಾ. ” ");
INSERT INTO gok_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","ಸಬ್ಬತ್ ದಿಸಾದಿಸಿ. ಯೇಸು ಪಿಕಾಚಾ ಸೇತಾಚೆ ವಾಟನಿ ಚಾ಼ಲತ್ ಜಾ಼ಯಿತಾ. ಯೇಸುಚ಼ ಶಿಶಾ ತ್ಯಚಿ ಸಂಗ ಹುತ್ತ. ತೇ ಬುಖ್ಯಾಲ್ತ ಮನ್ಹುನ್ ಶಿಶಾಂಚಾನಿ ಕನ್ಸ ಮುಡುನ್ ಖಾಲಿತ. ");
INSERT INTO gok_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","ಹ್ಯ ಬಗ್‌ಲ್ಯಾಲ್ಯಾ ಪರಿಸಾಯಾಂಚಾನಿ ಯೇಸುಲಾ, “ಬಗ್! ಸಬ್ಬತ್‍ ದಿಸಾದಿಸಿ ಕರುನಾಹಿತತಿ ಕಾಮ ಮೊಶೆಚೆ ಧರ್ಮಶಾಸ್ತಾರಾಚೆ ಆಡ್ವ ತುಜ಼ ಶಿಶಾ ಕರ್ತ್ಯಾತ” ಮನ್ಹುನ್ ಸಾಂಗ್‌ತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","ತ್ಯಲಾಸ್ ಯೇಸುನಿ, “ಆಪ್ನು ಆನಿ ಆಪ್ಲಿ ಸಂಗ ಆಸ್‌ಲ್ಯಾಲಿ ಲೊಕ ಬುಖ್ಯಾಲಿತ ತವಾ ದಾವಿದಾನಿ ಕ್ಯಾ ಕೆಲ ಮನ್ಹುನ್ ತುಮಿ ವಾಚಿವ್ಲ ನಾಹಿಸಾ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","ದಾವೀದ್ ದೇವಾಚಾ ದೇವ್ಳಾತ್ ಗೆಲಾ ತವಾ ದೇವಾಲಾ ಥೆವ್‌ಲ್ಯಾಲ್ಯಾ ನಿವ್ದಾಚಾ ಭಾಕ್‌ರ‍್ಯಾ ದಾವಿದಾನಿ ಆನಿ ತ್ಯಚಿ ಸಂಗ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ಲೊಕಾಂಚಾನಿ ಖಾಲ್ಯಾ. ತ್ಯಂಚಾನಿ ತ್ಯಾ ಖಾಯಾಚಾ ಧರ್ಮಶಾಸ್ತಾರಾಲಾ ಆಡ್ವ ಜಾ಼ಲ್ಥ ತ್ಯಾ ಖಾಯಾ ಯಾಜಕಾನಾ ತ್ಯವ್ಡಾಸ್ ಹುಕುಮ್ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","ಯಾಜಕ್ ದೇವ್ಳಾತ್ ಆರಾಮಾಚಾ ದಿಸಾಚಾ಼ ನೇಮ್ ವಲ್ಯಾಂಡುನ್ ಗೆಲ ತ್ಯ ಪವಿತ್ರ ನವ್ಹ ಮನ್ಹುನ್ ತುಮಿ ಮೊಶೇಚಾ ಧರ್ಮಶಾಸ್ತಾರಾತ್ ವಾಚಿವ್ಲ ನಾಹಿಸಾ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","ಫನ್ ದೇವ್ಳಾವ್ನಿ ಮೊಟಾ ಹಿತ್ತ ಕೊನ್ ಯೊಕ್ ಹಾ ಮನ್ಹುನ್ ಮಿ ತುಮಾನಾ ಸಾಂಗ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","‘ಜ಼ನಾವರ ಕಾಪಾಚಿ ಮನಾ ನಕೊತ, ಕರ್ನಾಸ್ ಮನಾ ವ್ಹಯಿ’ ಮನ್ಹುನ್ ಚಾ಼ಂಗಲ್ಯಾ ಪುತೀಕಾತ್ ಸಾಂಗ್ತ. ತ್ಯಚಾ಼ ಅರ್ಥ ತುಮಿ ಖರ‍್ಯಾ ಫನಾನಿ ಸಮಜು಼ನ್ ಗೆತ್ಲಾ ನಾಹಿಸಾ ತುಮಿ ತ್ಯಚಾ಼ ಅರ್ಥ ಸಮಜು಼ನ್ ಗೇತ್ಲಾತ ಚು಼ಕ್ ಕೆಲ್ಯಾನಸಲ್ಯಾಲ್ಯಾ ಲೊಕಾನಾ ಚು಼ಕ್ ಕರ್ತ್ಯಾಲಿ ಮನ್ಹುನ್ ಥರ್ವಿತ್ ನಾಹಿಸಾ. ");
INSERT INTO gok_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","“ಮಾನ್ಸಾಚಾ಼ ಲ್ಯೊಕ್ ಆರಾಮಾಚಾ ದಿಸಾಲಾಬಿ ಪ್ರಭು ಜಾ಼ಲ್ಯಾ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","ಯೇಸು ತ್ಯೊ ಜಾ಼ಗಾ ಸುಡುನ್ ತ್ಯಂಚಾ ಸಭಾಸ್ಥಾನಾತ್ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","ತ್ಯಾ ಸಭಾಸ್ಥಾನಾತ್ ಯಕಾಚಾ಼ ಹಾತ್ ವಾಳ್ಳಾ ಹುತ್ತಾ. ಯೆಹುದ್ಯಾತ್ಲಿ ಥುಡಿ ಯೇಸುವ ಚು಼ಕ್ ವಾವಾಯಾ ಕಾರನ್ ಸುದಿತಿತ. ಮನ್ಹುನ್ ತ್ಯಂಚಾನಿ ಯೇಸುಲಾ ಆರಾಮಾಚಾ ದಿಸಾದಿಸಿ ಬರ ಕರಾಚ಼ ಶಾರ್ಕ ಕ್ಯಾ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","ಯೇಸುನಿ, “ತುಮ್ಚಿಪ ಕುನಾಪ ತರಿ ಯಾಕ್ ಮೆಂಡಾರ್ ಆಸುನ್, ತ್ಯ ಮೆಂಡಾರ್ ಆರಾಮಾಚಾ ದಿಸಾದಿಸಿ ಘಳ್ನಾತ್ ಪಡ್ಲತ, ತುಮಿ ತ್ಯಾ ಮೆಂಡ್ರಾಲಾ ಘಳ್ನಾತ್ನಿ ವರ್ ಉಚ಼್ಲಾಚೆ ಆಂದಿ ರಾನ್ಹಾರ್ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","ಮಾನುಸ್ ಮೆಂಡ್ರಾವ್ನಿ ಖುಬ್ ಕಿಮ್ತಿಚಾ಼ ಹಾ ನವ್ಹ. ಮನ್ಹುನ್ ಆರಾಮಾಚಾ ದಿಸಾದಿಸಿ ಚಾ಼ಂಗ್ಲ ಕಾಮ ಕರಾಯಾ ಸಾಟಿ ಮೊಶೇಚಾ ಧರ್ಮಶಾಸ್ತಾರಾಚೆಗತ್ ಹಾ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","ಮಂಗ್ ಯೇಸು ಹಾತ್ ವಾಳ್ಯಾಲ್ಯಾ ಮಾನ್ಸಾಲಾ, “ತುಜಾ಼ ಹಾತ್ ದ್ಯಾವ್” ಮನ್ಲಾ. ತ್ಯನಿ ಆಪ್ಲಾ ಹಾತ್ ತ್ಯಚಿಕ್ಡ ಕೆಲಾ. ತವಾಸ್, ತ್ಯಚಾ಼ ಹಾತ್ ದುಸ್‌ರ‍್ಯಾ ಹಾತಾಚೆಗತ್ ಜಾ಼ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","ಫನ್ ಫರಿಸಾಯ್ ಬಾಹಿರ್ ಜಾ಼ವುನ್ ಯೇಸುಲಾ ಮಾರುನ್ ಟಾಕಾಯಾ ಪಾರಕ್ ಸೊದಾಯಾ ಲಾಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","ಫರಿಸಾಯ್ ಕ್ಯಾ ಕರ್ತ್ಯಾತ ಮನ್ಹು‍ನ್ ಯೇಸುಲಾ ಸಮಾಜ಼್ಲ ಹುತ್ತ ಮನ್ಹುನ್ ತ್ಯೊ ಜಾ಼ಗಾ ಸುಡುನ್ ಗೆಲಾ ಖುಬ್ ಲೊಕ ತ್ಯಚೆ ಮಾಗ್ನಿ ಗಿಲಿತ ತ್ಯನಿ ಸಗ್‌ಳ್ಯಾ ರೊಗಿನಾ ಬರ ಕೆಲ. ");
INSERT INTO gok_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ಫನ್ ಆಪ್ನು ಕೊನ್ ಮನ್ಹುನ್ ದುಸ್‌ರ‍್ಯಾ ಲೊಕಾನಾ ಸಾಂಗು ನಕೊಸಾ ಆಸಿ ತ್ಯನಿ ತ್ಯನಾ ತಾಕಿತ್ ಕಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","ಪ್ರವಾದಿ ಜಾ಼ಲ್ಯಾಲ್ಯಾ ಯೆಶಾಯಾನಿ ಸಾಂಗ್‌ಲ್ಯಾಲ ಕರಾಯಾ ಪಾಯ್ಜೆ ಮನ್ಹುನ್ ಯೇಸುನಿ ಹ್ಯ ಸಗ್ಳ ಕೆಲ. ಯೆಶಾಯಾನಿ ಸಾಂಗ್‌ಲ್ಯಾಲ ಕ್ಯಾ ಮಂಜೆ: ");
INSERT INTO gok_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“ಬಗಾ, ಮಾಜ಼ಾ ಸೇವಕ್. ತ್ಯಲಾ ಮಿ ನಿವ್ಡುನ್ ಗೇತ್ಲಾ. ತ್ಯಚಿ ಮಾಯಾ ಕರ್ತೊ, ತ್ಯಚಿವ ಮಿ ಸಂತೊಶ್ ಹಾ. ತ್ಯಚಿವ ಮಾಜ಼ ಆತ್ಮ ಥೆವ್ನಾರ್. ತ್ಯೊ ಸರ್ವ್ಯಾ ಲೊಕಾನಾ ಖರ‍್ಯಾಚಾ಼ ತೀರ್ಮಾನ್ ಕರ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","ತ್ಯೊ ಕಳ್ ಕರೀತ್ ನಾಹಿ, ವರಡತ್ ನಾಹಿ. ಪಾಂದಿತ್ ತ್ಯಚಾ಼ ಸಬ್ದ ಐಕು ಯಯಿತ್ನಾಹಿತ. ");
INSERT INTO gok_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","ವಾಕ್‌ಲ್ಯಾಲ ಡಾಳ ತ್ಯೊ ಮುಡಿತ್ನಾಹಿ; ಇಜ಼ತ್ಯಾಲಿ ವ್ಯಾತ್ ಇಜು಼ದಿಯಿತ್ ನಾಹಿ. ಖರಾ ತೀರ್ಮಾನ್ ಜಿತ್ತ ಶಾರ್ಕ ಕರ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","ಸಗ್ಳಿ ಲೊಕ ತ್ಯಚಿವ ಇಸ್ವಾಸ್ ಥೆವ್ನಾರ್ ");
INSERT INTO gok_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","ತವಾ ಥೊಡ್ಯಾ ಲೊಕಾಂಚಾನಿ ಯಕಾಲಾ ಯೇಸುಚೆ ಕಡಸ್ ಆನ್ಲಾ. ತ್ಯಚಿಪ ಭುತ್ ಹುತ್ತ ಮನ್ಹುನ್ ತ್ಯೊ ಅಂದ್ಳಾ ಆನಿ ಮುಕ್ಕಾ ಜಾ಼ಲ್ಥಾ. ಯೇಸುನಿ ತ್ಯಾ ಮಾನ್ಸಾಲಾ ಚಾ಼ಂಗ್ಲ ಕೆಲಾ ಮನ್ಹುನ್ ಬೊಲಾಯಾ ಬಗಾಯಾ ಲಾಗ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","ಲೊಕ ಸಗ್ಳಿ ಆಜಾಬ್ ವ್ಹವುನ್. “ದಾವಿದಾಚಾ಼ ಲ್ಯೊಕ್ ಹ್ಯೊಸ್ ಆಸಲ್” ಮನ್ಹುನ್ ಬುಲ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","ಲೊಕ ಆಸಿಸ್ ಬೊಲ್‌ತ್ಯಾಲಿ ಆಸ್ಥಾನಾ ಐಕ್‌ಲ್ಯಾಲ ಫರಿಸಾಯ್, “ಬೆಲ್ಜೆಬುಲ್ ಭುಥಾಂಚಾ಼ ದನ್ಹಿ ಜಾ಼ಲ್ಯಾ. ತ್ಯಚಾ ಬಳಾನಿ ಯೇಸು ಭುಥ ಸುಡಿವ್‍ತ್ಯೊ. ಮನ್‌ಲ್ಹ. ” ");
INSERT INTO gok_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","ಫರಿಸಾಯ್ ಯವಸ್‌ತ್ಯಾಲ್ಯಾ ಗುಶ್ಟಿ ಯೇಸುಲಾ ಸಮಾಜ್‌ಲ್ಯಾ ಹುತ್ಯಾ. ಮನ್ಹುನ್ ಯೇಸುನಿ ತ್ಯನಾ, “ಆತ್ಲೆ ಖುಬಿನಿ ಲಡ್‌ತ್ಯಾಲ ರಾಜ ನಾಸ್ ವ್ಹನಾರ್. ಆತ್ಲೆ ಕಳಿನಿ ಫುಟ್ ಪಡಲ್ಯಾಲ ಪರತೇಕ್ ರಾಜ ಖಾಯಿಮ್ ರಾನ್ಹಾರ್ ನಾಹಿ. ಭೇದ್ ಭಾವಾನಿ ಬರ್‌ಲ್ಯಾಲಾ ಕುಟುಮ್ ನಾಸ್ ವ್ಹಯಿಲ್. ");
INSERT INTO gok_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","ತಸಸ್ ಸೈತಾನಾಂಚಾ ರಾಜಾತ್ ದೊನ್ ಭಾಗ್ ವ್ಹವುನ್ ಯಕಾಚೆ ಆಡ್ವ ಯೊಕ್ ಮಾರಾ ಮಾರ‍್ಯಾ ಕರೀತ್ ರಾಯ್ಲತ ತ್ಯಚ಼ ರಾಜ ಬಿಗಿನಿ ಹಾಳ್ ವ್ಹವುನ್ ಜಾ಼ತ? ");
INSERT INTO gok_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","ಮಿ ಬೆಲ್ಜೆಬುಲಾಚಾ ಬಳಾನಿ ಭುಥ ಶೊಡ್ತೊ? ಮನ್ಹುನ್ ತುಮಿ ಸಾಂಗ್ತಾಸಾ ತ್ಯ ಖರ ಜಾ಼ಲತ ತುಮ್ಚಿ ಲೊಕ ಕಸ್‌ಲ್ಯಾ ಬಳಾನಿ ಭುಥ ಸುಡಿವ್‌ತ್ಯಾತ ಮನ್ಹುನ್ ಸ್ವತಾಚಿ ಲೊಕ ತುಮಾನಾ ಚು಼ಕ್ ಕರ್ತ್ಯಾಲ ಮನ್ಹುನ್ ದಾವುನ್ ದೇತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","ಫನ್ ಮಿ ಬೆಲ್ಜೆಬುಲಾಪ್ನಿ ನವ್ಹ. ದೇವಾಚಾ ಆತ್‌ಮ್ಯಾಚಾ ಬಳಾನಿ ಭುಥ ಸುಡಿವ್ತೊ. ದೇವಾಚ಼ ರಾಜೆ ತುಮ್ಚಿಪ ಆಲ್ಯಾ ಮನ್ಹುನ್ ಹ್ಯ ದಾವುನ್ ದೇತ. ");
INSERT INTO gok_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","ಯಕಾ ಮಾನ್ಸಾಲಾ ಯಕಾ ಬಳ್ ವಾಲ್ಯಾಚಾ ಗರ‍್ಹಾತ್ ಬರ‍್ಹುನ್ ತ್ಯಚಿ ಆಸ್ಥಿ ಚೊ಼ರಾಯಾ ವ್ಹಯಿತ್ ನಾಹಿ, ಆಂದಿ ತ್ಯನಿ ತ್ಯಾ ಬಳ್ವಾಲ್ಯಾಲಾ ಬಾಂದುನ್ ಗಾಲಾಯಾ ವ್ಹಯಿ. ತವಾ ತ್ಯಾ ಪೈಲ್ವಾನಾಚಾ ಗರ‍್ಹಾತ್ಲಿ ಆಸ್ಥಿ ಚೊ಼ರಾಯಾ ತ್ಯಲಾ ವ್ಹನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","ಮಾಜಿ ಸಂಗ ನಸ್‌ಲ್ಯಾಲಾ ಮನಾ ವಾದಿ. ವ್ಹವುನ್ ಹಾ ಮಾಜಿ ಸಂಗ ಮಿಳ್ವಿತ್ ನಸ್‍ಲ್ಯಾಲಾ ಯಗಾಳ್ಯಾಲಾ ವ್ಹವುನ್ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“ಮನ್ಹುನ್ ಮಿ ತುಮಾನಾ ಸಾಂಗಾಚ಼ ಕ್ಯಾ ಮಂಜೆ, ಲೊಕ ಕರ್ತ್ಯಾಲ್ಯಾ ಪಾಪಾನಾ ಬುರ್ಸ್ಯಾ ಬೊಲ್ಯಾನಾ ಮಾಪಿ ವ್ಹಯಿಲ್. ಫನ್ ಪವಿತ್ರಾತ್ಮಾಚಿ ನಿಂದಾ ಕರ್ತ್ಯಾಲ್ಯಾಲಾ ಮಾಪಿ ಕಂದಿಸ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","ಮಾನ್ಸಾಚಾ ಲೇಕಾಲಾ ಆಡ್ವ ಬೊಲಲ್ ತ್ಯಲಾ ಮಾಪಿ ಹಾ. ಫನ್ ಪವಿತ್ರಾತ್ಮಾಚೆ ಆಡ್ವ ಬೊಲಲ್ ತ್ಯಲಾ ಆತಾ ನಾಹಿತ ಕಂದಿಸ್ ಮಾಪಿ ವ್ಹನಾರ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“ತುಮಾನಾ ಚಾ಼ಂಗ್ಲ ಫಳ್ ಪಾಯ್ಜೆತ ತುಮಚ಼ ಝಾ಼ಡ್ ಚಾ಼ಂಗ್ಲ ರಾಹ್ಯಾ ವ್ಹಯಿ. ತುಮಚ಼ ಝ಼ಾಡ್ ಚಾ಼ಂಗ್ಲ ನಸ್ಲತ ತ್ಯ ಬುರ್ಸ ಫಳ್ ದೇತ. ಜಾ಼ಡ್ ತ್ಯಚಾ ಶೊಡ್‌ತ್ಯಾಲ್ಯಾ ಫಳಾನಿಸ್ ಸಮಾಸ್ತ. ");
INSERT INTO gok_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","ತುಮಿ ಸಾಪ್! ತುಮಿ ಬುರ್ಸಿ! ಚಾ಼ಂಗ್ಲ ತುಮಿ ಕಸಿ ಸಾಂಗ್ಸಿಲಾ? ತುಮ್ಚಾ ಮನಾತ್ ಹಾ ತ್ಯಸ್ ತುಮಚ಼ ತ್ವಾಂಡ್ ಬೊಲ್ತ. ");
INSERT INTO gok_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","ಚಾ಼ಂಗ್ಲಾ ಮಾನುಸ್ ಆಪ್‌ಲ್ಯಾ ಮನಾತ್ಲ ಚಾ಼ಂಗ್ಲತ್ಯಸ್ ಥಿವುನ್ ಗಿಹುನ್ ಚಾ಼ಂಗ್ಲ ಬೊಲ್ತೊ. ಫನ್ ಬುರ್ಸಾ ಆಪ್‌ಲ್ಯಾ ಮನಾತ್ ಬುರ್ಸತ್ಯಸ್ ಥಿವುನ್ ರಾಥೊ ಮನ್ಹುನ್ ತ್ಯೊ ಬುರ್ಸ ತ್ಯಸ್ ಬೊಲ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","ಲೊಕ ನಕೊತಸ್‌ಲ್ಯಾ ಇಚಾರಾನಿ ಬೊಲ್ಯಾಲೆ ಪರತೇಕ್ ಗುಶ್ಟಿಲಾ ನ್ಯಾಯಿ ನಿವ್ಡಾಚಾ ದಿಸಾತ್ ಉತ್ತರ್ ದಿಯಾಹ್ವಯಿ. ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","ತುಮ್ಚಾ ಸಬ್ದಾನಿಸ್ ತುಮಾನಾ ನಿರ್ದೊಶಿ ಮನ್ಹುನ್ ಥರಲ್, ತುಮ್ಚಾ ಸಬ್ದಾನಿಸ್ ತುಮಾನಾ ದುಶಿ ಮನ್ಹುನ್ ಥರ್ವಿಲ್” ಮನ್‍ಲ್ಹಾ. ");
INSERT INTO gok_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","ತವಾ ಥೊಡ ಫರಿಸಾಯ್ ಆನಿ ಧರ್ಮೊಪದೇಶಕ್ ಯೇಸುಲಾ, “ಮಾಸ್ಥರಾ, ತು ಸಾಂಗ್‌ಲ್ಯಾಲ ಖರ ವಾಟಾಯಾ ಯಾಕ್ ಚಮತ್ಕಾರಾಚ಼ ಕಾಮ್ ಕರ್” ಮನ್ಹುನ್ ಮನ್‍ಲ್ಹ. ");
INSERT INTO gok_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","ಯೇಸುನಿ, “ಬುರ್ಸ ಆನಿ ಪಾಪಿ ಚಮತ್ಕಾರ್ ಬಗಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಮಂಥ್ಯಾತ. ಫನ್ ತ್ಯನಾ ಪ್ರವಾದಿ ಯೊನಾಚಿ ವಳಕ್ ಸುಡುನ್ ದಿಸ್ರಿ ಕುಟ್ಲಿಸ್ ವಳಕ್ ದಾವಾಯಾ ವ್ಹಯಿತ್ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","ಯೊನಾ ರ‍್ಯಾತ್ ದೀಸ್ ತೀನ್ರೊಜ಼್ ಯಕಾ ಮೊಟ್ಯಾ ಮಾಶಾಚಾ ಪೊಟಾತ್ ಕಸಾ ಹುತ್ತಾ ತಸಾಸ್ ಮಾನ್ಸಾಚಾ಼ ಲ್ಯೊಕ್ ರ‍್ಯಾತ್ ದೀಸ್ ತೀನ್ ರೊಜ಼್ ಜಿಮ್ನಿಚಾ ಪೊಟಾತ್ ರಾಥೊ. ");
INSERT INTO gok_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","ನ್ಯಾಯಿ ನಿವ್ಡಾಚಾ ದೀಸಾತ್ ನಿನವೆ ಪೆಠತ್ಲಿ ಲೊಕ ಆನಿ ಅತ್ತಾ ಜೀವ್ನಾ ಕರ್ತ್ಯಾಲಿ ಲೊಕ ತುಜಿ ಸಂಗ ಉಬಿ ರಾಹುನ್ ಹಿ ಪಿಳ್ಗಿ ತುಮಾನಾ ಚು಼ಕ್ ಕರ್ತ್ಯಾಲಿ ಮನ್ಹುನ್ ಸಾಂಗ್ನಾರ್. ಕಾ ಮಂಜೆ ಯೊನಾನಿ ಸಿಕಿವ್ಲ ತವಾ ತ್ಯಂಚಾನಿ ಅಪ್ಲಾ ಜೀವ್ನಾ ಬದಲ್ಲಾ. ಫನ್ ಮಿ ತುಮಾನಾ ಸಾಂಗಾಚ಼ ಕ್ಯಾ ಮಂಜೆ ಮಿ ಯೊನಾವ್ನಿ ಮೊಟಾ ವ್ಹವುನ್ ರಾನ್ಹಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","“ನ್ಯಾಯಿ ನಿವ್ಡಾಚಾ ದೀಸಾತ್ ಶಿಬಾಚಿ ರಾನಿ ಆಜು಼ನ್ ಜೀವ್ನಾ ಕರ್ತ್ಯಾಲೆ ತುಮ್ಚಿ ಸಂಗ ಉಠುನ್ ತುಮಾನಾ ಚು಼ಕ್ ಕರ್ತ್ಯಾಲ ಮನ್ಹುನ್ ಥರಿವ್ನಾರ್. ಕಾ ಮಂಜೆ, ತೀ ರಾನಿ ಸೊಲೊಮೊನಾಚ಼ ಗಿನ್ಯಾನಾಚ಼ ಸಿಕಿವ್ನ ಐಕಾಲಾ ಆಪ್ಲೆ ದೇಶೆತ್ನಿ. ಮಿ ತರಿ ಸೊಲೊಮೋನಾವ್ನಿ ಮೊಟಾ ಹಾ ಮನ್ಹುನ್ ತುಮಾನಾ ಸಾಂಗ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“ಬುರ್ಸ ಆತ್ಮ ಮಾನ್ಸಾತ್ನಿ ಬಾಹಿರ್ ಆಲ ತವಾ ಆರಾಮ್ ಕರಾಯಾ ಸಾಟಿ ಜಾ಼ಗಾ ಸುದಿತ್ ವಾಳ್ಕೆ ಜಿಮ್ನಿತ್ ಫಿರ್ತ. ಫನ್ ತ್ಯಾ ಬುರ್ಶಾ ಆತ್‌ಮ್ಯಾಲಾ ಪಾಯ್ಜೆ ತ್ಯೊ ಆರಾಮ್ ಕರಾಯಾ ಜಾ಼ಗಾ ಗಾವ್ಹತ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ತವಾ ತ್ಯ, ‘ಮಿ ಸುಡುನ್ ಆಲ್ಯಾಲ್ಯಾ ಗರ‍್ಹಾತ್ ಪರ್ತುನ್ ಜಾ಼ತೊ’ ಮನ್ಹುನ್ ಮಂಥ. ಆನಿ ತ್ಯ ತಿಥ ಯತ ತವಾ ತ್ಯ ಘರ್ ಚಾ಼ಂಗ್ಲ ಲ್ಯೊಟ್‌ಲ್ಯಾಲ ರಿಕಾಮ ದಿಸ್ತ. ");
INSERT INTO gok_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","ತವಾ ತ್ಯ ಬಾಹಿರ್ ಜಾ಼ವುನ್ ಆಪ್ಲಿವ್ನಿ ಬುರ್ಸಿ ಜಾ಼ಲ್ಯಾಲಿ ಸಾತ್ ಆತ್ಮ ಹಾಕ್ಟುನ್ ಗಿಹುನ್ ಯತ ತೀ ಬುರ್ಸಿ ಆತ್ಮಿ ಸಗ್ಳಿ ತ್ಯಾ ಮಾನ್ಸಾತ್ ಬರ‍್ಹುನ್ ರಾಥ್ಯಾತ ತವಾ ತ್ಯಾ ಮಾನ್ಸಾಚಿ ಪರಿಸ್ತಿತಿ ಪೈಲ್ಯಾವ್ನಿ ಖುಬ್ ತರಾಸಾಚಿ ವ್ಹತ್ತಿ ಹ್ಯಾ ದಿಸಾತ್ ಜೀವ್ನಾ ಕರ್ತ್ಯಾಲ್ಯಾ ಬುರ್ಶಾ ಲೊಕಾನಾ ತಸಸ್ ವ್ಹನಾರ್ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","ಯೇಸು ಲೊಕಾಂಚಿ ಸಂಗ ಬೊಲ್‍ತ್ಯಾಲಾ ಆಸ್ಥಾನಾ, ತ್ಯಚಿ ಆಯಿ ಆನಿ ಬಾಹು ಯವುನ್ ಬಾಹಿರ್ ಉಬಿ ರಾಯ್ಲಿತ. ತಿ ತ್ಯಚಿ ಸಂಗ ಬೊಲಾಯಾ ವ್ಹಯಿ ಮನ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","ಯೊಕ್ ಮಾನುಸ್ ಯವುನ್ ಯೇಸುಲಾ, “ತುಜಿ ಆಯಿ ಆನಿ ಬಾಹು ತುಜೆ ಸಾಟಿ ಬಾಹಿರ್ ರ‍್ಯಾಕ್‌ತ್ಯಾತ, ತೀ ತುಜೆ ಬರ್ಬರ್ ಬೊಲಾಯಾ ವ್ಹಯಿ” ಮನ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","ಯೇಸು, “ಮಾಜಿ ಆಯಿ ಕೊನ್? ಆನಿ ಮಾಜ಼ ಬಾಹು ಕೊನ್? ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","ಆಪ್‌ಲ್ಯಾ ಶಿಶಾಂಚಿಕ್ನಿ ಹಾತ್ ಕರುನ್, “ಬಗಾ! ಹಿ ಮಾಜಿ ಆಯಿ ಆನಿ ಮಾಜ಼ ಬಾಹು. ");
INSERT INTO gok_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","ಸ್ವರ್ಗಾತ್ ಆಸ್ನಾರ‍್ಯಾ ಮಾಜಾ ಬಾಚಾ ಮನಾಶಾರ್ಕ ಕರ್ತ್ಯಾಲಾ ಮಾಜಾ಼ ಖರಾ ಬಾಹು, ಭನ್ಹಿ ಆನಿ ಆಯಿ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","ತೀಸಿಸ್ ಯೇಸು ಗರ‍್ಹಾತ್ನಿ ಜಾ಼ವುನ್ ಸಮಿಂದೊರಾಚೆ ದರವ ಬಸ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","ಖುಬ್ ಲೊಕ ಯೇಸುಚೆ ಸರ್ಬೌತಿ ಜ಼ಮ್ಲಿತ. ಮನ್ಹುನ್ ಯೇಸು ವ್ಹಡಿತ್ ಜಾ಼ವುನ್ ಬಸ್ಲಾ. ಲೊಕ ಸಗ್ಳಿ ದರವ ಉಬಿ ಹುತೀತ. ");
INSERT INTO gok_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","ತವಾ ಯೇಸುನಿ ಕ್ಯಾಯ್ನಿನಿಸ್ ಖುಬ್ ಗುಶ್ಟಿ ತ್ಯನಾ ಸಿಕಿವ್‌ಲ್ಯಾ. ಯೇಸುನಿ ತ್ಯನಾ ಹಿ ಕ್ಯಾಯ್ನಿ ಸಾಂಗ್ಲಿ: “ಯೊಕ್ ಕಮ್ತಾ ಕರ್ತ್ಯಾಲಾ ಬೀ ಪೇರಾಯಾ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","ತ್ಯೊ ಬೀ ಟ್ಯಾಕ್ತಾನಾ ಥೊಡ ಬೀ ವಾಟಚೆ ಬಾಜು಼ಲಾ ಪಡ್ಲ. ಪಾಕ್ರ ಯವುನ್ ಬೀ ಸಗ್ಳ ಖಾವುನ್ ಟ್ಯಾಕ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","ಥೊಡ ಬೀ ದೊಂಡ್ಯಾಚೆ ಜಿಮ್ನಿತ್ ಪಡ್ಲ. ತ್ಯಾ ಜಾ಼ಗ್ಯಾತ್ ಪಾಯ್ಜೆ ತ್ಯವ್ಡಿ ಮಾತಿ ನವ್ಥಿ. ಮನ್ಹುನ್ ಬೀ ಚಾ಼ಟಕ್ಯಾನ್ ಉಗಾವ್ಲ ");
INSERT INTO gok_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","ಫನ್ ಉನಾನಿ ಕೊಂಬ್ರ ಜ಼ಳುನ್ ವಾಳುನ್ ಗೆಲ. ಕಾ ಮಂಜೆ ತ್ಯಲಾ ಖಾಲ್ ಪರತ್ ಮುಳ ಗಿಲಿ ನವ್ಥಿತ. ");
INSERT INTO gok_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","ದುಸ್ರ ಥೊಡ ಬೀ ಕಾಟ್ಯಾಚೆ ಜಾ಼ಳಿತ್ ಪಡ್ಲ. ಕಾಟ್ಯಾಚ಼ ಡಾಳ ವಾಡುನ್ ಚಾ಼ಂಗ್ಲ ಡಾಳ ವಾಡ್‌ತ್ಯಾಲ ಥಾಂಬಿವ್ಲ ");
INSERT INTO gok_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","ದುಸ್ರ ಥೊಡ ಬೀ ಚಾ಼ಂಗ್ಲೆ ಜಿಮ್ನಿತ್ ಪಡ್ಲ. ಆನಿ ಥೊಡ ಶೆಂಬಾರ ಇತ್ಕ, ಥೊಡ ಸಾಟಾ ಇತ್ಕ, ಆನಿ ಥೊಡ ತಿಸಾ ಇತ್ಕ ಪಿಕ್ ದಿಲ. ");
INSERT INTO gok_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","ಕುನಾಲಾ ಕಾನ್ ಹಾತ್ತ ತ್ಯೊ, ಐಕುನಿ!” ಮನ್ಹುನ್ ಯೇಸುನಿ ತೀ ಕ್ಯಾಯ್ನಿ ಸುಪಿವ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","ತವಾ ಶಿಶಾ ಯೇಸುಪ ಯವುನ್, “ತು ಕ್ಯಾಯ್ನಿನಿಸ್ ಲೊಕಾನಾ ಸಾಂಗ್ತೊಸ್ ಕಾ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","ಯೇಸುನಿ, “ಸ್ವರ್ಗಾಚಾ ರಾಜಾಚ಼ ಆಡ್‍ಶಾ ಆಸ್‍ಲ್ಯಾಲ ಗಿನ್ಯಾನ್ ತುಮಾನಾ ತ್ಯವ್ಡಸ್ ಸಮಾಜ್ನಾರ್. ಹ್ಯ ಗಿನ್ಯಾನ್ ದುಸ್‌ರ‍್ಯಾ ಲೊಕಾನಾ ಸಮಾಜ್ನಾರ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","ಥೊಡ ಗಿನ್ಯಾನ್ ಆಸ್‌ಲ್ಯಾಲಾ ಆನಿಕ್ ಖುಬ್ ಗಿನ್ಯಾನ್ ಗಿಹುನ್ ಮೊಟಾ ಜ್ಞಾನಿ ವ್ಹತ್ತೊ. ಫನ್ ಗಿನ್ಯಾನ್ ನಸ್‌ಲ್ಯಾಲಾ ಆಪ್ಲಿಪ ಆಸ್‌ಲ್ಯಾಲ ಥೊಡ ಗಿನ್ಯಾನ್ ಇಸ್ರುನ್ ಜಾ಼ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","ಹ್ಯಾ ಕಾರ್ನಾನಿಸ್ ಮಿ ಕ್ಯಾಯ್‌ನ್ಯಾನಿ ತ್ಯನಾ ಸಿಕಿವ್ತೊ ಹ್ಯಾ ಲೊಕಾಂಚಾನಿ ಬಗ್ಲ ತರಿ ದಿಸ್ನಾರ್ ನಾಹಿ, ಐಕ್ಲತರಿ ಸಮಜ಼ತ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","ಹ್ಯಾ ಪ್ರವಾದಿ ಯೆಶಾಯಚಾ ತೊಂಡಾನಿ ಸಾಂಗ್‌ಲ್ಯಾಲ್ಯಾ ಬೊಲ್ಯಾ: ತೀ ಐಕತ್ ರಾಥ್ಯಾತ ತರಿ, ತ್ಯನಾ ಸಮಜ಼ತ್ ನಾಹಿ. ತುಮಿ ಬಗಿತ್ ಬಗಿತ್ ರಾಯ್ಲಿತ ತರಿ. ತ್ಯನಾ ದಿಸತ್ಯಾಲ ಸಮಜ಼ತ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","ವ್ಹಯ್, ಹ್ಯಂಚಿ ಮನ ಘಟ್ ಜಾ಼ಲ್ಯಾ. ಕಾನ್ ಮುದಾಲ್ಯಾತ ಡೊಳ್ಯಾನಾ ಆಂದಾರಿ ಆಲೆ. ತ್ಯಂಚಾನಿ ಆಪ್‌ಲ್ಯಾ ಡೊಳ್ಯಾನಿ ಬಗುನಾಹಿ ಆಸ ಆಪ್‌ಲ್ಯಾ ಕಾನಾನಿ ಐಕುನ್ ಗಿಹುನಾಹಿ ಆಸ ಆಪ್‌ಲ್ಯಾ ಮನಾನಿ ಸಮಜು಼ನ್ ಗಿಹುನಾಹಿ ಆಸ ಮಾಜಿಕ್ಡ ಪರ್ತಾಚೆ ಆಂದಿ ಮಾಜಿಪ್ನಿ ಬರ ವ್ಹಯಾಚೆ ಆಂದಿ ಆಸ ಜಾ಼ಲ. ");
INSERT INTO gok_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","ಫನ್ ತುಮಿ ಸಂತೊಸ್ ಹಾಸಾ. ತುಮಾನಾ ದಿಸತ್ಯಾಲ್ಯಾ ಆನಿ ಸಾಂಗ್‌ತ್ಯಾಲ್ಯಾ ಗುಶ್ಟಿ ಸಮಾಜ್‍಼ತ್ಯಾತಾ. ");
INSERT INTO gok_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","ಮಿ ತುಮಾನಾ ಖರ‍್ಯಾನಿ ಸಾಂಗ್ತೊ ತುಮಿ ಹ್ಯಾ ಬಗ್‌ಲ್ಯಾಲ್ಯಾ ಗುಶ್ಟಿ ಬಗಾಯಾ ಆನಿ ಆತಾ ತುಮಿ ಐಕ್‌ತ್ಯಾಲ್ಯಾ ಹ್ಯಾ ಗುಶ್ಟಿ ಐಕಾಯಾ ಖುಬ್ ಪ್ರವಾದಿಂಚಾನಿ ಆನಿ ನಿಯತಿಚಾ ಲೊಕಾಂಚಾನಿ ಮನ್ ಕೆಲ, ಫನ್ ತ್ಯನಾ ಐಕಾಯಾ ಆನಿ ಬಗಾಯಾ ಜಾ಼ಲ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","ಆಸ ಆಸ್ಥಾನಾ ಪೆರ್ನಾರ‍್ಯಾಚೆ ಕ್ಯಾಯ್ನಿಚಾ಼ ಅರ್ಥ ಐಕಾ. ");
INSERT INTO gok_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","“ಬಾಜು಼ಸ್ ಪಡ್‌ಲ್ಯಾಲ ಬೀ ಮಂಜೆ ಕ್ಯಾ? ಸ್ವರ್ಗಾಚಾ ರಾಜಾಚ಼ ಸಿಕಿವ್ನ ಐಕುನ್ ತ್ಯ ಸಮಜು಼ನ್ ಗಿಹ್ಯಾಚೆ ಆಂದಿ ಆಸ್ನಾರಾ ಮಾನುಸ್. ಸೈತಾನ್ ಯವುನ್ ತ್ಯಾ ಮಾನ್ಸಾಚಾ ಮನಾತ್ ಯವುನ್ ಪೇರ್‌ಲ್ಯಾಲ ಬೀ ಕಾಡುನ್ ಟ್ಯಾಕ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","“ದೊಂಡ್ಯಾಚೆ ಜಿಮ್ನಿವ ಪಡ್‌ಲ್ಯಾಲ ಬಿ ಮಂಜೆ ಕ್ಯಾ? ದೇವಾಚ಼ ಸಬಾತ್ ಸಾಂಗ್‌ಲ್ಯಾಲ ಐಕ್‌ಲ್ಯಾ ಬರ್ಬರ್ ತ್ಯ ಸಂತೊಶಾನಿ ಗೆಥ್ಯಾಲಾ ಮಾನುಸ್. ");
INSERT INTO gok_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","ಫನ್ ತ್ಯಾ ಮಾನ್ಸಾನಿ ಸಾಂಗ್‌ಲ್ಯಾಲ ವಚನ್ ಐಕುನ್ಬಿ ಜೀವ್ನಾತ್ ಮುಳ ಸುಡ್ಲಿ ನಾಹಿತ. ಮನ್ಹುನ್ ತ್ಯನಿ ತ್ಯ ಐಕ್‌ಲ್ಯಾಲ್ಯಾಚೆಗತ್ ಥೊಡ ದೀಸ್ ತ್ಯವ್ಡಸ್ ಚಾ಼ಲ್ತೊ. ತಸಾಸ್ ಚಾ಼ಲ್ಯಾ ಸಾಟಿ ಆಪ್‌ಲ್ಯಾಲಾ ತರಾಸ್ ಆನಿ ನಿಂದಾ ಆಲಿಕಿ ತ್ಯ ಬಿಗಿನಿ ಸುಡುನ್ ದೇತೊ. ");
INSERT INTO gok_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","“ಕಾಟ್ಯಾಚೆ ಜಾ಼ಳಿತ್ ಪಡ್‌ಲ್ಯಾಲ ಬೀ ಮಂಜೆ ಕ್ಯಾ? ಸಾಂಗ್‌ಲ್ಯಾಲ ವಚನ್ ಐಕುನ್ಬಿ ಜೀವ್ನಾಚೆ ಕ್ಯಾಳ್ಜಿತ್ನಿ ಆನಿ ದುನಿಯಾವ್‍ಲ್ಯಾ ಪೈಶಾಚೆ ಮಾಯೆನಿ ಸಿಕಿವ್‌ಲ್ಯಾಲ ಆಪ್ಲಿಪ ವಾಡು ನಾಹಿ. ಮನ್ಹುನ್ ಸಿಕಿವ್‌ಲ್ಯಾಲಾ ತ್ಯಾ ಮಾನ್ಸಾಚಾ಼ ಜೀವ್ನಾ ಪೀಕ್ ದಿಯಿತ್ ನಾಹಿ ");
INSERT INTO gok_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","“ಚಾ಼ಂಗ್ಲೆ ಜಿಮ್ನಿವ ಬೀ ಪಡ್‌ಲ್ಯಾಲ ಮಂಜೆ ಕ್ಯಾ? ಸಾಂಗ್‌ಲ್ಯಾಲ ವಚನ್ ಐಕುನ್ ತ್ಯೊ ಇಚಾರ್ ಕರುನ್ ಗೆಥ್ಯಾಲಾ ಯೊಕ್ ಮಾನುಸುಸ್ ಬೀ ಪಡ್‌ಲ್ಯಾಲ ಚಾ಼ಂಗ್ಲಿ ಜಿಮಿನ್ ಜಾ಼ಲ್ಯಾ. ತ್ಯೊ ಮಾನುಸ್ ವಾಡುನ್ ಥೊಡೆ ಪಾವ್ಟಿ ಶೆಂಬರಾಯವ್ಡ ಆನಿಕ್ ಥೊಡೆ ಪಾವ್ಟಿ ಸಾಟಾ ಯವ್ಡ ಥೊಡೆ ಪಾವ್ಟಿ ತಿಸಾಯವ್ಡ ಪೀಕ್ ದೇನಾರ್” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ ");
INSERT INTO gok_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","ಮಂಗ್ ಯೇಸುನಿ ತ್ಯನಾ ಆನಿ ಯೇಕ್ ಕ್ಯಾಯ್ನಿನಿ ಸಾಂಗ್ಲಿ. ತಿ ಕ್ಯಾ ಮಂಜೆ: “ಸ್ವರ್ಗಾಚ಼ ರಾಜ ಚಾ಼ಂಗ್ಲ ಬೀ ಆಪ್‌ಲ್ಯಾ ಸೇತಾತ್ ಪೇರ್ತ್ಯಾಲ್ಯಾ ಯಕಾ ಕಮ್ತಾ ಕರ್ತ್ಯಾಲ್ಯಾಚಿಗತ್ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","ತೇ ರಾತಿ ಲೊಕ ಸಗ್ಳಿ ನಿಜ್ಲಿ಼ ಹುತ್ತಿತ ತವಾ ತ್ಯಚಾ಼ ವಾದಿ ಯವುನ್ ಘವ್ಹಾಚೆ ಮದ್ದಿ ರಾನ್ ಫಿರುನ್ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","ಮಂಗ್ ಘಹು ವಾಡುನ್ ಕನ್ಸ ಶುಡ್ಲಿತ. ತ್ಯಂಚಿ ಸಂಗ ರಾನ್ ಸಾಹಿತ್ ದಿಸ್ಲ ");
INSERT INTO gok_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","ತವಾ ತ್ಯಾ ಕಮ್ತಾ ಕರ್ತ್ಯಾಲ್ಯಾಚ಼ ಸೇವಕ್ ತ್ಯಚಿಪ ಯವುನ್, ‘ತುಜಾ ಸೆತಾತ್ ತು ಚಾ಼ಂಗ್ಲ ಬೀ ಪೇರ‍್ಲ ಹುತ್ತಸ್. ರಾನ್ ಕುಟ್ನಿ ಆಲ?’ ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","ತ್ಯಾ ಕಮ್ತ ವಾಲ್ಯಾನಿ, ಯಕಾ ವಾದಿನಿ ಯವುನ್ ರಾನ್ ಪೇರ‍್ಲ ಮನ್ಹುನ್ ಉತ್ತರ್ ದಿಲಾ. ತೇ ಸೇವಕ್ ಆಮಿ ಜಾ಼ವುನ್ ರಾನ್ ಕಾಡಾಯಾ ವ್ಹಯಿ ಕ್ಯಾ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","ತ್ಯಾ ಮಾನ್ಸಾನಿ ನಕೊ ಕಾ ಮಂಜೆ ತುಮಿ ರಾನ್ ಕ್ಯಾಡ್ತಾನಾ ಘಹುಬಿ ಕ್ಯಾಡ್ಸಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","ಲಾನಿಚಾ ದೀಸಾ ಮಂಗ್ ರಾನ್ ಘಹು ಸಂಗಸ್ ವಾಡುಂತ. ಲಾನಿಚಾ ದಿಸಾತ್ ಮಿ ಕಾಮ್ಯಾರ‍್ಯಾನಾ, ಆಂದಿ ಗವಾತ್ ಗೊಳಾ ಕರಾ ತೀ ಜಾ಼ಳಾಯಾ ಭಾರ‍್ಹ ಬಾಂದುನ್, ಮಂಗ್ ಘಹು ಗೊಳಾ ಕರುನ್ ತೇ ಮಾಜಾ ಕಳಂಜಾ಼ತ್ ಆನಾ’ ಮನ್ಹುನ್ ಉತ್ತರ್ ದಿಲಾ. ” ");
INSERT INTO gok_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","ಮಂಗ್ ಯೇಸುನಿ ಆನಿ ಯೇಕ್ ಕ್ಯಾಯ್ನಿ ಸಾಂಗ್ಲಿ: “ಸ್ವರ್ಗಾಚ಼ ರಾಜ ಆಸ ಹಾ ಯಕಾನಿ ಮೌರಿ ಗಿಹುನ್ ಆಪ್‌ಲ್ಯಾ ಸೇತಾತ್ ಪೇರ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","ತ್ಯ ಸಗ್‌ಳ್ಯಾ ಬ್ಯಾವ್ನಿ ಬ್ಯಾರ್ಕ ಬೀ ಜಾ಼ಲ್ಯಾ ಖರ ತ್ಯ ವಾಡ್ಲ ತವಾ ಬಾಜಿಪಾಲ್ಯಾಚಾ ಡಾಳ್ಯಾಂಚಿವ್ನಿ ಮೊಟ ಝಾ಼ಡ್ ವ್ಹತ ಪಾಕ್ರ ಯವುನ್ ತ್ಯಚೆ ಡಾಳ್ಹಿನಾ ಕುಟಿ ಬ್ಯಾಂದತ್ಯಾತ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","ಮಂಗ್ ಯೇಸುನಿ ಲೊಕಾನಾ ಆನಿ ಯೇಕ್ ಕ್ಯಾಯ್ನಿ ಸಾಂಗ್ಲಿ: “ಸ್ವರ್ಗಾಚ಼ ರಾಜೆ ಆಸ ಹಾ. ಯೇಕ್ ಬ್ಯಾಯ್ಕಾ ಮಾನುಸ್ ಬಾಕ್ರಿ ಕರಾಯಾ ಯಕಾ ಮೊಟ್ಯಾ ಐದಾನಾತ್‍ ಖಾತ್ಯಾಲ್ಯಾ ಸೊಡ್ಯಾಚೆಗತ್ ಹಾ. ತ್ಯೊ ಸೋಡಾ ತೀನ್ ಶೇರ್ ಪೀಟ್ ಮಳ್ಯಾಲ ಸಗ್ಳ ಫುಗಿವ್ತೊ,” ");
INSERT INTO gok_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","ಯೇಸುನಿ ಹ್ಯ ಸಗ್ಳ ಲೊಕಾನಾ ಕ್ಯಾಯ್ನಿಂಚಾನಿ ಸಾಂಗ್ಲ ತ್ಯನಿ ಗಿನ್ಯಾನ್ ಸಾಂಗ್ತಾನಾ. ಕ್ಯಾಯ್‍ನ್ಯಾ ಉಪೆಗ್ ವಾಪ್ರಿತಾ. ");
INSERT INTO gok_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","ಪ್ರವಾದಿನಿ ಸಾಂಗ್‌ಲ್ಯಾಲಿ ಹಿ ಬುಲಿ ಹ್ಯನಿ ಗಡ್ಲಿ: “ಮಿ ಕ್ಯಾಯ್‌ನ್ಯಾ ಸಿಕಿವ್ತೊ. ಲೊಕ ಉತ್ಪತ್ತಿ ಜಾ಼ಲ್ಯಾ ಠಾವ್ನಿ ಆಡಶಾ ಆಸ್ನಾರ‍್ಯಾ ಗುಶ್ಟಿ ಮಿ ಸಾಂಗ್ತೊ. ” ");
INSERT INTO gok_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","ಮಂಗ್ ಯೇಸು ಲೊಕಾಂಚಾ಼ ಹಿಂಡ್ ಸುಡುನ್ ಗರ‍್ಹಾತ್ ಗೆಲಾ. ತ್ಯಚ಼ ಶಿಶಾ ತ್ಯಚಿಪ ಯವುನ್, “ಸೇತಾತ್ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ಗವ್ತಾಚ಼ ಸಮಜು಼ನ್ ಗಿಹ್ಯಾ ಆಮಾನಾ ಉಗ್ಡುನ್ ಸಾಂಗ್” ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","ಯೇಸುನಿ ಆಸ ಸಾಂಗ್ಲ: “ಸೇತಾತ್ ಚಾ಼ಂಗ್ಲ ಬೀ ಪೇರ್ತ್ಯಾಲಾ ಮಾನ್ಸಾಚಾ಼ ಲ್ಯೊಕ್. ");
INSERT INTO gok_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ತ್ಯ ಶಾತ್ ಹಿ ದುನೆ ಜಾ಼ಲೆ ಚಾ಼ಂಗ್ಲ ದಾನ ದೇವಾಚಾ ರಾಜಾಚಿ ಪೊರ. ಬುರ್ಸಿ ಸೈತಾನಾಚಿ ಪೊರ. ");
INSERT INTO gok_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ಗವಾತ್ ಪೇರ್ಲ್ಯಾಲಾ ವಾದಿ ಸೈತಾನ್. ಲ್ಯಾನ್ ಮಂಜೆ ದುನೆಚಾ಼ ಸರ್ತಾಯೋಳ್. ಗೊಳಾಕರಾಚ಼ ಕಾಮ್ ಕರ್ತ್ಯಾಲಸ್ ದೇವ್ದುತ್. ");
INSERT INTO gok_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","ರಾನ್ ಕಾಡುನ್ ಜಾಳ್‍ತ್ಯಾತ. ಹೆ ದುನೆಚಾ ಸರ್ತ್ಯಾಯಳಾಲಾ ವ್ಹಯಾಚ಼ ಹ್ಯಸ್. ");
INSERT INTO gok_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","ಮಾನ್ಸಾಚಾ಼ ಲ್ಯೊಕ್ ಆಪಲ್ಯಾ ದುತಾನಾ ಲಾವುನ್ ದೇನಾರ್ ತೇ ಧುತ್ ಪಾಪ ಕರ್ತ್ಯಾಲ್ಯಾನಾ ಆನಿ ಧರ್ಮಾಚೆ ಅಡ್ವ ಚಾ಼ಲ್ಯಾಲ್ಯಾ ಲೊಕಾನಾ ಗೊಳಾ ಕರ್ನಾರ್ ತ್ಯನಾ ತ್ಯಚಾ ರಾಜಾತ್ನಿ ಬಾಹಿರ್ ಗಾಲ್ಹುನ್ ");
INSERT INTO gok_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ಪೆಟ್ಯಾಲೆ ಆಗಿತ್ ವ್ಹಲ್ಪಟುನ್ ದೇನಾರ್. ತಿಥ ತೀ ರಡತ್ ದುಃಖಾನಿ ಆಪ್ಲ ದಾತ್ ಚಾವ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","ಚಾ಼ಂಗ್ಲಿ ತರಿ ದಿಸಾಚಾ ಉಜಿಡಾಚೆಗತ್ ಆಪ್‌ಲ್ಯಾ ಬಾಚಾ ರಾಜಾತ್ ರಾನ್ಹಾರ್. ಕಾನ್ ಆಸ್‌ಲ್ಯಾಲಿ, ಐಕುಂತ! ");
INSERT INTO gok_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“ಆಂದಿ ಸ್ವರ್ಗಾಚ಼ ರಾಜೆ ಸೇತಾತ್ ಪುರುನ್ ಥೆವ್‌ಲ್ಯಾಲ್ಯಾ ಮಾಲ್ಹಾಚೆಗತ್ ಹಾ. ಯೇಕಸಿ ಯಕಾನಿ ತ್ಯೊ ಮ್ಹಾಲ್ ಬಗುನ್ ತ್ಯೊ ಸೇತಾತುಸ್ ಚು಼ರುನ್ ಥೆವ್ಲಾ. ಆನಿ ತ್ಯನಿ ಆಪ್ಲಿ ಆಸ್ಥಿ ಸಗ್ಳಿ ಇಕುನ್ ತ್ಯ ಶಾತ್ ಹೌಸನಿ ಇಕತ್ ಗೇತ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“ಸ್ವರ್ಗಾಚ಼ ರಾಜೆ ಚಾ಼ಂಗಲ್ಯಾ ಮುತ್ ಶೊತ್ಯಾಲ್ಯಾ ಮಾನ್ಸಾಚೆಗತ್ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","ಯಕಸಿ ತ್ಯಾ ಮಾನ್ಸಾಲಾ ಖುಬ್ ಕಿಮ್ತಿಚಾ಼ ಯೊಕ್ ಮುತ್ತ್ ಗಾವ್ಲಾ. ತವಾ ತ್ಯನಿ ಆಪ್ಲಿ ಸಗ್ಳಿ ಆಸ್ಥಿ ಇಕುನ್ ತ್ಯೊ ಗೇತ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“ಪರಲೊಕ್ ರಾಜ ಸಮಿಂದೊರಾತ್ ಟ್ಯಾಕ್‌ಲ್ಯಾಲ್ಯಾ ಜಾ಼ಳ್ಯಾಚೆಗತ್ ಹಾ. ತ್ಯಾ ಜಾ಼ಳ್ಯಾತ್ ಖುಬ್ ಜಾ಼ತಿಚ಼ ಮಾಸ ಗಾವ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","ತವಾ ತ್ಯ ಜಾ಼ಳ ಬರ‍್ಹುನ್ ಗೆಲ. ಮಾಸ ದರ್ಥ್ಯಾಲ್ಯಾಂಚಾನಿ ತ್ಯ ಬಲ ದರಕ್ಡ ವಡುನ್ ಆನುನ್ ಚಾ಼ಂಗ್ಲ ಮಾಸ ಸಗ್ಳ ಬುಟ್ಯಾತ್ನಿ ಬರ‍್ಹುನ್ ಬುರ್ಸ ಮಾಸ ಟಾಕುನ್ ದೀಲ. ");
INSERT INTO gok_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","ಹೆ ದುನೆಚಾ ಸರ್ತ್ಯಾ ಯಳಾಲಾ ತಸಸ್ ವ್ಹನಾರ್ ದೇವ್ ಧುತ್ ಯವುನ್ ಚಾ಼ಂಗಲ್ಯಾ ಲೊಕಾತ್ನಿ ಬುರ್ಶಾ ಲೊಕಾನಾ ಯಗಳ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ದೇವ್ ದುತ್ ಬುರ್ಶಾ ಲೊಕಾನಾ ಇಸ್‌ಥ್ಯಾತ್ ವ್ಹಲ್ಪಟ್ಯಾತ. ತ್ಯಾ ಜಾ಼ಗ್ಯಾವ ಲೊಕ ರಡತ್ ದುಖಾನಿ ಆಪ್ಲ ದಾತ್ ಕಾರ್ ಕಾರ್ ಚಾವ್ನಾರಾ. ” ");
INSERT INTO gok_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","ಯೇಸುನಿ ಆಪ್‌ಲ್ಯಾ ಶಿಶಾನಾ, “ತುಮಿ ಹ್ಯಾ ಗುಶ್ಟಿ ಸಗ್‌ಳ್ಯಾ ಸಮಜು಼ನ್ ಗೇತ್‌ಲ್ಯಾಸಾ ಕ್ಯಾ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ತ್ಯಲಾ ಶಿಶಾಂಚಾನಿ, “ಆಮಿ ಸಮಜು಼ನ್ ಗೇತ್ಲ ಮನ್ಹುನ್ ಉತ್ತರ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","ತವಾ ಯೇಸುನಿ ಆಪ್‌ಲ್ಯಾ ಶಿಶಾನಾ, “ಆಸ ಆಸ್ಥಾನಾ ಗುಶ್ಟಿತ್ ಸಿಕಿವ್‌ಲ್ಯಾಲ ಪರ್ತೇಕ್ ದರ್ಮೊಪದೆಶಕ್ ದೇವಾಚಾ ರಾಜಾಚ಼ ಶಿಶಾ ಯಕಾ ಗರ‍್ಹಾಚಾ ಧನ್ಯಾಚೆಗತ್ ಹಾ ತ್ಯೊ ಮಾನುಸ್ ನವ ಸಾಮಾನ್ ಜು಼ನ್ನ ಸಾಮಾನ್ ಮಿಳ್ವುನ್ ತ್ಯ ಬಾಹಿರ್ ಆನ್ನಾರ್” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","ಯೇಸುನಿ ಹ್ಯಾ ಕ್ಯಾಯ್‍ನ್ಯಾನಿ ಸಿಕಿವ್‌ಲ್ಯಾ ನಂತರ್ ತಿಥ್ನಿ ");
INSERT INTO gok_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ಆಪ್‌ಲ್ಯಾ ಸ್ವತಾಚಾ ಗಾವಾತ್ ಜಾ಼ವುನ್. ಸಭಾಸ್ಥಾನಾತ್ ಸಿಕಿವ್ಲ ತವಾ ಲೊಕ ಆಜಾಬ್ ವ್ಹವುನ್ ಹ್ಯ ಗಿನ್ಯಾನ್ ಆನಿ ಚಮತ್ಕಾರಾಚಿ ಕಾಮ ಕರ್ತ್ಯಾಲ ಹ್ಯ ಬಳ್ ಖುಟ್ನಿ ಗೇತ್ಲ? ");
INSERT INTO gok_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","ಹ್ಯೊ ತ್ಯಾ ಸುತಾರಾಚಾ಼ ಲ್ಯೊಕ್ ನವ್ಹ ಕ್ಯಾ? ಹ್ಯಚಿ ಆಯಿ ಮರಿಯಾ ಯಾಕೊಬ್, ಯೊಸೆಪ್, ಸಿಮೊನ್ ಆನಿ ಯುದ್ ಹ್ಯಚ಼ ಬಾಹು. ");
INSERT INTO gok_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","ತ್ಯಚಾ ಬನ್ಹಿ ಸಗ್‌ಳ್ಯಾ ಆಮ್ಚಿಪ ಹಾತ್ತಾ ಆಸ ಆಸ್ಥಾನಾ ಹ್ಯನಿ ಹ್ಯ ಗಿನ್ಯಾನ್ ಆನಿ ಚಮತ್ಕಾರಾಚಿ ಕಾಮ ಕರಾಯಾ ಬಳ್ ಖುಟ್ನಿ ಗೆತ್ಲ? ಮನ್ಹುನ್ ಬುಲುನ್. ತ್ಯಲಾ ಗೇತ್ಲಾ ನಾಹಿ ");
INSERT INTO gok_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","ಯೇಸುನಿ ತ್ಯನಾ, “ಪ್ರವಾದಿಲಾ ದುಸ್ರಿಲೋಕ ಮರ‍್ಯಾದ್ ದೇತ್ಯಾತ; ಖರ ಸ್ವತಾಚಾ ಗಾವಾತ್ಲಿ ವ್ಹವುಂತ ಸ್ವತಾಚಾ ಗರ‍್ಹಾತ್ಲಿ ಹ್ವವುಂತ ಮರ‍್ಯಾದ್ ದಿಯಿತ್ ನಾಹಿತ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","ತ್ಯಾ ಲೊಕಾನಾ ಇಸ್ವಾಸ್ ನಸ್‌ಲ್ಯಾಲಾಸ್ ಲಾಗುನ್ ತ್ಯನಿ ತಿಥ ಖುಬ್ ಚಮತ್ಕಾರಾಚಿ ಕಾಮ ಕಿಲಿ ನಾಹಿತ. ");
INSERT INTO gok_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","ತ್ಯಾ ಕಾಲಾತ್ ಹೆರೊದ್ ರಾಜಾ಼ ಗಲಿಲಾಯಾತ್ ರಾಜಾಭಾರ್ ಕರೀತಾ. ಲೊಕ ಯೇಸುಚಾ ಸಾಂಗ್‌ತ್ಯಾಲ್ಯಾ ಗುಶ್ಟಿ ಸಗಳ್ಯಾ ತ್ಯಲಾ ಸಮಾಜ್‌ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ಮನ್ಹುನ್ ಹೆರೊದಾನಿ ಆಪ್‌ಲ್ಯಾ ಅಧಿಕಾರ‍್ಯಾನಾ, “ಖರ‍್ಯಾನಿಸ್ ಯೇಸುಸ್ ಬಾಪ್ತಿಸ್ಮಾ ಯೊಹಾನ್. ತ್ಯೊ ಆನಿಕ್ ಜಿತ್ತಾ ವ್ಹವುನ್ ಆಲ್ಯಾ. ಮನ್ಹುನ್ ತ್ಯೊ ಹಿ ಚಮತ್ಕಾರಾಚಿ ಕಾಮ ಕರಯಾ ವ್ಹತ್ಯಾತ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","ಹ್ಯಾ ಯಳಾಚೆ ಆಂದಿ ಹೆರೊದಿನಿಸ್ ಲಾಗುನ್ ಹೆರೊದಾನಿ ಯೊಹಾನಾಲಾ ಸರ್ಪೊಳ್ಯಾಂಚಾನಿ ಬಾಂದುನ್, ಕುಂಡುನ್ ಗ್ಯಾತ್ಲಾ. ಹೆರೋದಾಚಾ಼ ಬಾಹು ಪಿಲಿಪ್ ಹ್ಯಚಿ ದನ್ಗರ್ ಹೆರೊದಿನಿ ಹಿಚೆಸಾಟಿ ಹ್ಯ ಸಗ್ಳ ಕೆಲ. ");
INSERT INTO gok_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","ಯೊಹಾನ್ ಹೆರೋದಾಲಾ, “ಹೆರೊದಿನಿಲಾ ತು ಥಿವುನ್ ಗೇತಲ್ಯಾಲಿ ಶಾರ್ಕ ನವ್ಹ” ಮನ್ಹುನ್ ಸಾಂಗಲ್ಯಾಲಸ್ ಕೊಂಡಾಯಾ ಕಾರನ್. ");
INSERT INTO gok_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","ಹೆರೋದ್ ಯೊಹಾನಾಲಾ ಮಾರುನ್ ಟಾಕಾಯಾ ವ್ಹಯಿ ಮನ್‌ಲ್ಹಾತರಿ ಲೋಕಾಂನಾ ಭಿಹುನ್ ಮ್ಯಾರ್ಲಾ ನವ್ಥಾ. ಲೊಕಾನಾ ಯೊಹಾನ್ ಯೊಕ್ ಪ್ರವಾದಿ ಮನ್ಹುನ್ ಇಸ್ವಾಸ್ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","ಹೆರೋದ್ ಜ಼ಲಾಮ್‌ಲ್ಯಾಲ್ಯಾ ಸಂತೋಶಾಚಾ ದಿಸಾದಿಸಿ ಹೆರೊದಿನಿಚಿ ಲೇಕ್ ಹೆರೋದ್ ಆನಿ ತ್ಯಚಾ ಪಾವ್‌ನ್ಯಾಂಚೆ ಮೊರ‍್ಹ ನಾಚ್ಲಿ. ಹೆರೋದಾಲಾ ತೀ ಖುಬ್ ಆವಾಡ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ಮನ್ಹುನ್ ತ್ಯನಿ, “ತುಲಾ ಕ್ಯಾ ಪಾಯ್ಜೆ ತ್ಯ ಮಿ ದೇತೊ” ಮನ್ಹುನ್ ತಿಲಾ ಸಬ್ದ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","ಕ್ಯಾ ಮಾಗಾಯಾ ಪಾಯ್ಜೆ ಮನ್ಹುನ್ ಹೆರೊದಾನಿ ಆಪ್ಲೆ ಲಿಕಿಲಾ ಸಾಂಗುನ್ ದಿಲ. ಮನ್ಹುನ್ ತಿನಿ ಹೆರೋದಾಲಾ, “ಬಾಪ್ತಿಸ್ಮಾ ಯೊಹಾನಾಚಿ ಡುಯಿ ಆತಾಸ್ ಹಿತ್ತಸ್ ಹೆ ಪರ‍್ಯಾತಿತ್ನಿ ದೇ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","ಹೆರೋದ್ ರಾಜಾಲಾ ಖುಬ್ ದುಕ್ ಜಾ಼ಲ ಫನ್ ಕ್ಯಾ ಮಾಗ್ಲ ತರಿ ದೇತೊ ಮನ್ಹುನ್ ಮಿ ತಿಲಾ ಸಬ್ದ ದಿಲ್ಯಾ. ಹೆರೊದಾನಿ ಸಾಂಗ್‌ಲ್ಯಾಲ ತ್ಯಚಾ ಪಾವನ್ಯಾಂಚಾನಿ ಸಾಹಿತ್ ಐಕ್ಲ ಹುತ್ತ. ಮನ್ಹುನ್ ತಿನಿ ಮಾಗ್‌ಲ್ಯಾಲ ದಿಯಾಲಾ ಹೆರೊದಾನಿ ಹುಕುಮ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","ತುರುಂಗಾತ್ ಜಾ಼ವುನ್ ಯೊಹಾನಾಚಿ ಡುಯಿ ತುಡುನ್ ಗಿಹುನ್ ಯಯಾ ತ್ಯನಿ ಸೈನಿಕಾನಾ ಲಾವುನ್ ದಿಲ. ");
INSERT INTO gok_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","ತ್ಯಂಚಾನಿ ಯೊಹಾನಾಚಿ ಡುಯಿ ಪರ‍್ಯಾತಿತ್ನಿ ಆನುನ್ ತಿಲಾ ದಿಲಿ. ತಿನಿ ತೀ ಆಪ್ಲೆ ಆಯಿ ಹೆರೊದಿನಿಪ ನಿಲ್ಹಿ. ");
INSERT INTO gok_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","ಯೊಹಾನಾಚಾ ಶಿಶಾಂಚಾನಿ ಯವುನ್ ತ್ಯಚ಼ ಮಡ ನಿಹುನ್ ಪುರ್ಲ. ಮಂಗ್ ತೇ ಯೇಸುಪ ಜಾ಼ವುನ್ ಜಾ಼ಲ್ಯಾಲ ಸಗ್ಳ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","ಯೊಹಾನಾಲಾ ಜಾ಼ಲ್ಯಾಲ ಸಗ್ಳ ಐಕ್ಲ ತವಾ ಯೇಸು ವ್ಹಡಿತ್ ಚ಼ಡುನ್ ಯಕಾನ್ಸಿ ಜಾ಼ಗ್ಯಾವ ಗೆಲಾ. ಫನ್ ಹಿ ಬಾತ್ನಿ ಲೊಕಾನಾ ಸಮಾಜ್ಲಿ. ಮನ್ಹುನ್ ತೀ ಆಪ್ಲ ಗಾವ್ ಸುಡುನ್ ಚಾ಼ಲತ್ ತ್ಯೊ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ಜಾ಼ಗ್ಯಾಪ ಗಿಲಿತ. ");
INSERT INTO gok_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","ಯೇಸು ತಿಥ ಆಲಾ ತವಾ, ಲೊಕಾಂಚಾ಼ ಹಿಂಡ್ ಜ಼ಮಲ್ಯಾಲಾ ಬಗುನ್ ತ್ಯಂಚಿಸಾಟಿ ದಯಾನಿ ಬರ‍್ಹುನ್ ರೊಗಾತ್‌ಲ್ಯಾನಾ ಬರಿ ಕಿಲಿತ. ");
INSERT INTO gok_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","ಶಾಂಜ಼್ ಜಾ಼ಲಿ ತವಾ, ಶಿಶಾ ಯೇಸುಪ ಯವುನ್, “ಹ್ಯಾ ಜಾ಼ಗ್ಯಾತ್ ಲೊಕ ರಾಹಿತ್ನಾಹಿತ ಆತಾಸ್ ಯೊಳ್ ಜಾ಼ಲ್ಯಾ. ಲೊಕಾಂಚಾನಿ ಆಪ್ಲೆ ಸಾಟಿ ಜೆವಾನ್ ಇಕತ್ ಗಿಹ್ಯಾ ಲಾವುನ್ದೆ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","ಯೇಸುನಿ, “ಲೊಕ ಜಾ಼ಯಾಚಿ ನಕೊತ. ತುಮಿಸ್ ತ್ಯನಾ ಜೆವಾನ್ ದೇವಾ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","ತವಾ ಶಿಶಾಂಚಾನಿ, “ಆಮ್ಚಿಪ ನಿಸ್‍ಥ್ಯಾ ಪಾಚ಼್ ಬಾಕರ‍್ಯಾ ಆನಿ ದೊನ್ ಮಾಸ ತ್ಯವ್ಡಸ್ ಹಾತ್ತ” ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","ಯೇಸು ತ್ಯನಾ, “ತೀ ಮಾಜಿಪ ಗಿಹುನ್ ಯವಾ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","ಪರತ್ ತ್ಯನಿ ಲೊಕಾನಾ ಗವ್ತಾವ ಬಸಾಯಾ ಸಾಂಗುನ್ ಪಾಚ಼್ ಬಾಕರ‍್ಯಾ ಆನಿ ದೊನ್ ಮಾಸ ಗಿಹುನ್ ಪರಲೊಕಾಕ್ಡ ಬಗುನ್ ತ್ಯಚಿ ಸಾಟಿ ದೇವಾಲಾ ಸ್ತೊತ್ರ ಕರುನ್, ಬಾಕ್‌‍ರ‍್ಯಾ ಮುಡುನ್ ಆಪ್‌ಲ್ಯಾ ಶಿಶಾಂಚಾ ಹಾತಾತ್ ದಿಲ್ಯಾ. ಶಿಶಾಂಚಾನಿ ಬಾಕರ‍್ಯಾ ಲೊಕಾನಾ ವ್ಯಾಡ್‌ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","ಲೊಕ ಸಗ್ಳಿ ಖಾವುನ್ ಸಮಾದಾನ್ ಜಾ಼ಲ್ಹಿತ. ಲೊಕ ಖಾವುನ್ ಜಾ಼ಲ್ಯಾವ ಉರಲ್ಯಾಲ ತುಕ್ಡ ಶಿಶಾಂಚಾನಿ ಗೊಳಾ ಕೆಲ ತವಾ ಬಾರಾ ಬುಟ್ಯಾ ಬರ್‌ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","ಜೆವಾನ್ ಖಾಲ್ಯಾಲ್ಯಾತ್ ಬ್ಯಾಯ್ಕಾ ಮಾನ್ಸ ಆನಿ ಪ್ಯೊರಗ್ಯಾನಾ ಸುಡುನ್, ನಿಸ್ಥ ಗಡಿಸ್ ಪಾಚ಼್ ಹಾಜಾ಼ರ್ ಹುತ್ತ. ");
INSERT INTO gok_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","ಮಂಗ್ ಯೇಸುನಿ ಆಪ್‌ಲ್ಯಾ ಶಿಶಾನಾ, “ಮಿ ಹ್ಯಾ ಲೊಕಾನಾ ಸುಡುನ್ ಯತೊ. ತುಮಿ ಆತಾಸ್ ವ್ಹಡಿತ್ ಚ಼ಡುನ್ ಸಮಿಂದೊರಾಚೆ ಪಲಿಕ್ಡ ಜಾ಼ವ್ಹಾ” ಮನ್ಹುನ್ ಸಾಂಗುನ್ ಲಾವುನ್ ದಿಲ. ");
INSERT INTO gok_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","ತ್ಯನಿ ಲೊಕಾನಾ ಲಾವುನ್ ದಿಲ್ಯಾ ಪರತ್ ಮಾಗ್ನ ಕರಾಯಾ ಸಾಟಿ ಆಪ್ನು ಯಕ್ಲಾಸ್ ಕನ್ಯಾವ ಗೆಲಾ. ತವಾಸ್ ರ‍್ಯಾತ್ ಜಾ಼ಲ್ಥಿ ತಿಥ ತ್ಯೊ ಯಕ್ಲಾಸ್ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","ತ್ಯವ್‌ಡ್ಯಾತ್ ವ್ಹಡಿ ಸಮಿಂದೊರಾತ್ ಖುಬ್ ದುರ್ ಗಿಲ್ತಿ. ವಾರ‍್ಯಾನಿ ಮುರ್ನಿ ಬಡಾವ್‌ತ್ಯಾಲ್ಯಾ ಲ್ವಾಟಾತ್ನಿ ಮದ್ದಿಸ್ ಗಾವ್ಲಿ ಹುತ್ತಿ. ");
INSERT INTO gok_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","ತೇ ರ‍್ಯಾತ್ ಸರ್ತ್ಯಾಯಳಾಲಾ ಚಾರಾಕ್ಡ ತ್ಯಚ಼ ಶಿಶಾ ಹ್ವಡಿತುಸ್ ಹುತ್ತ. ಯೇಸು ಸಮಿಂದೊರಾಚಾ ಪಾನ್ಯಾವ ಚಾ಼ಲತ್ ತ್ಯಂಚಿಪ ಯಯಾ ಲಾಗ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","ಪಾನ್ಯಾವ್ ಚಾ಼ಲತ್ ಯತ್ಯಾಲ್ಯಾಲಾ ಬಗುನ್ ಶಿಶಾ ಭುತ್ ಮನ್ಹುನ್ ಬಿಹುನ್ ವರಾಡ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","ತವಾಸ್ ಯೇಸು, “ಧಿರಾನಿ ರಾವ್ಹಾ! ಮಿಸ್! ತ್ಯೊ ಭಿಹು ನಕೊಸಾ ಮನ್ಹುನ್ ತ್ಯಂಚಿ ಸಂಗ ಬೊಲ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","ತವಾ ಪೇತ್ರಾ, “ಪ್ರಭು ಖರ‍್ಯಾನಿಸ್ ತು ಆಸ್ಲಾಸ್ತ, ಪಾನ್ಯಾವ್ನಿ ಚಾ಼ಲುನ್ ತುಜಿಪ ಯಯಾ ಮನಾ ಹುಕುಮ್ ದೇ” ಮನ್ಲಾ ");
INSERT INTO gok_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","ಯೇಸು, “ಪೇತ್ರಾ, ಯೇ” ಮನ್ಲಾ. ತವಾಸ್ ಪೇತ್ರಾ ವ್ಹಡಿತ್ನಿ ಉತ್ರುನ್ ಯೇಸುಕ್ಡ ಪಾನ್ಯಾವ್ನಿ ಚಾ಼ಲತ್ ಜಾ಼ಯಿತಾ. ");
INSERT INTO gok_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","ಫನ್ ತ್ಯೊ ವಾರ‍್ಯಾಚ಼ ಆರ್ಬಾಟ್ ಬಗುನ್ ಬಿಹ್ಯಾಲಾ ಮನ್ಹುನ್ ಪಾನ್ಯಾತ್ ಬುಡತಾ ತವಾ ತ್ಯೊ ಪ್ರಭು ಮನಾ ರ‍್ಯಾಕ್” ಮನ್ಹುನ್ ವರಾಡ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","ಯೇಸುನಿ ಆಪ್ಲಾ ಹಾತ್ ದಿವುನ್ ಪೇತ್ರಾಲಾ ದರ್ಲಾ. ಯೇಸು, “ಥೊಡಾ ಇಸ್ವಾಸ್ ಆಸ್ನಾರ‍್ಯಾ, ಕಾ ಸಂವ್ಸೆವ್ ಕೆಲಾಸ್? ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","ಪೇತ್ರಾ ಆನಿ ಯೇಸು ವ್ಹಡಿತ್ ಚ಼ಡ್ಲ ತವಾ ವಾರ ಥಾಂಬ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","ವ್ಹಡಿತ್ ಆಸ್‌ಲ್ಯಾಲ ಶಿಶಾಂಚಾನಿ ಯೇಸುಲಾ, “ತು ಖರ‍್ಯಾನಿಸ್ ದೇವಾಚಾ಼ ಲ್ಯೊಕ್” ಮನ್ಹುನ್ ತ್ಯಲಾ ವವ್ಯಾಳಾ. ");
INSERT INTO gok_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","ತೇ ಸಮಿಂದೊರ್ ವಲ್ಯಾಂಡುನ್ ಗೆನೆಜ಼ರೆತಾತ್ಲೆ ದರವ ಆಲ. ");
INSERT INTO gok_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","ತಿಥ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ಲೊಕಾಂಚಾನಿ ಯೇಸುಲಾ ಬಗ್ಲಾ. ತ್ಯೊ ಕೊನ್ ಮನ್ಹುನ್ ತ್ಯನಾ ಠಾವಾ ಹುತ್ತಾ. ಮನ್ಹುನ್ ತ್ಯಂಚಾನಿ ಸರ್ಬೌತಚಾ ಗಾವಾತಲ್ಯಾ ಲೊಕಾನಾ ಯೇಸು ಆಲ್ಯಾ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ಆನಿ ತ್ಯಂಚಾನಿ ಲೊಕ ರೊಗಾತ್ನಿ ದುಃಖ್‍ನ್ಯಾತ್ನಿ ಆಸಲ್ಯಾಲ್ಯಾ ಸಗ್‌ಳ್ಯಾನಾ ತ್ಯಚಿಪ ಆನ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","ತ್ಯಚಿ ವೈಲಿ ಆಂಗಿ ತರಿ ಹಾತ್ ಲಾವುನ್ ಬರ ವ್ಹಯಾ ಅವ್ಕಾಸ್ ದಿಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಮಾಗ್ಲ. ತ್ಯಚೆ ವೈಲೆ ಆಂಗಿಲಾ ಹಾತ್ ಲ್ಯಾವ್‌ಲ್ಯಾಲಿ ಲೊಕ ಸಗ್ಳಿ ಬರಿ ಜಾ಼ಲ್ಹಿತ. ");
INSERT INTO gok_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","ತವಾ ಥೊಡ ಫರಿಸಾಯ್ ಆನಿ ಧರ್ಮೊಪದೇಶಕ್ ಯೆರುಸಲೆಮೆತ್ ಯೇಸುಪ ಯವುನ್, ");
INSERT INTO gok_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“ಆಮ್ಚಾ ವಡ್ಲಾಂಚಾಪ್ನಿ ಆಲ್ಯಾಲಾ ನೇಮ್ ಸಾಂಗ್‌ಲ್ಯಾಲಾ ತುಜ಼ ಶಿಶಾ ಕಾ ಐಕಿತ್ ನಾಹಿತ ತೇ ಖಾಯಾಚೆ ಆಂದಿ ಹಾತ್ ದುಯಿತ್ ನಾಹಿತ ಕಾ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","ಯೇಸುನಿ, “ತುಮ್ಚಾ ನೇಮಾಚೆಗತ್ ಚಾ಼ಲಾಯಾ ದೇವಾಚಾ಼ ಹುಕುಮ್ ವಲ್ಯಾಂಡುನ್ ಜಾ಼ಯಾಚಾ಼ ಕಾ? ");
INSERT INTO gok_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","‘ತುಮ್ಚೆ ಆಯಿ ಬಾಲಾ ಮರ‍್ಯಾದ್ ದೇವಾ’ ಮನ್ಹುನ್ ದೇವಾಚಾ಼ ಹುಕುಮ್. ಕೊನ್ತರಿ ಆಪ್ಲೆ ಆಯಿ ಬಾಲಾ ಸರಾಪ್ಲಾತ ತ್ಯಲಾ ಮಾರುನ್ ಟಾಕಾಯಾ ವ್ಹಯಿ’ ಮನ್ಹುನ್ ದೇವಾಚಾ಼ ಹುಕುಮ್ ");
INSERT INTO gok_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","ಫನ್ ಯೊಕ್ ಮಾನುಸ್ ಆಪ್‌ಲ್ಯಾ ಆಯಿ ಬಾಲಾ ‘ತುಮಾನಾ ಮಜ಼ತ್ ಕರಾಯಾ ಮನಾ ವ್ಹಯಿತ್ನಾಹಿ, ಕಾ ಮಂಜೆ ಮಾಜಿಪ ಆಸ್‍ಲ್ಯಾಲ ಪರ್ತೇಕ್ ದೇವಾಲಾ ದಿಲ್ಯಾ’ ಮನ್ಹುನ್ ಸಾಂಗ್‌ಲ್ಯಾವ, ");
INSERT INTO gok_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ತ್ಯನಿ ಆಪ್ಲೆ ಆಯಿ ಬಾಲಾ ಮರ‍್ಯಾದ್ ದಿಯಾ ಗರಜ್ ನಾಹಿ ಮನ್ಹುನ್ ಸಿಕಿವ್ತಾಸಾ. ಆಸ ಆಸ್ಥಾನಾ ತುಮ್ಚಾ ನೇಮಾನಿ ದೇವಾಚಾ ಹುಕ್ಮಾಲಾ ದುರ್ ಕೆಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","ತುಮಿ ಕಪ್ಟಿ ಯೆಶಾಯನಿ ತುಮ್ಚೆ ಗುಶ್ಟಿತ್ ಸಾಂಗ್‌ಲ್ಯಾಲ ಖರ ಹಾ. ತ್ಯ ಕ್ಯಾ ಮಂಜೆ: ");
INSERT INTO gok_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","ಹಿ ಲೊಕ ಮನಾ ಬುಲಿನಿ ಮರ‍್ಯಾದ್ ದೇತ್ಯಾತ. ಹ್ಯಂಚ಼ ಮನ್ ಮಾಜಿಪ್ನಿ ದುರ್ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","ಹ್ಯಂಚಾನಿ ಮನಾ ಆರಾದನ್ ಕರಾಚಿ ಉಗಸ್. ಹಿ ಮಾನ್ಸಾಂಚ಼ ಶಿಕ್ಶನ್ ಮಾಜಾ ಶಿಕ್ಶನಾಚೆಗತ್ ಸಾಂಗ್‌ತ್ಯಾತ’” ");
INSERT INTO gok_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","ಯೇಸುನಿ ಲೊಕಾನಾ ಆಪ್ಲಿಪ ಹಾಕ್ಟುನ್, “ಮಿ ಸಾಂಗ್‌ತ್ಯಾಲ ಐಕಾ ಆನಿ ಸಮ್ಜುನ್ ಗೇವ್ಹಾ. ");
INSERT INTO gok_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","ಯಕ್ಲಾ ಬುರ್ಸಾ ವ್ಹಯಾಚ಼ ತ್ಯಚಾ ತೊಂಡಾತ್ನಿ ಆತ್‌ ಜಾ಼ತ್ಯಾಲ ನವ್ಹ. ತ್ಯಚಾ ತೊಂಡಾತ್ನಿ ಬಾಹಿರ್ ಯತ್ಯಾಲ್ಯಾ ಬುರ್ಶಾ ಸಬ್ದಾನಿ ತ್ಯಲಾ ಬುರ್ಸ ಕರ್ನಾರ್” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","ತವಾ ತ್ಯಚ಼ ಶಿಶಾ ಯೇಸುಪ ಯವುನ್, “ತು ಸಾಂಗ್‌ಲ್ಯಾಲ ಐಕುನ್ ಫರಿಸಾಯ್ ಬೇಜಾರ್ ಜಾ಼ಲ್ಯಾಲ ಸಮಾಜ಼ಲ ಕ್ಯಾ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","ತವಾ ಯೇಸು, “ಸ್ವರ್ಗಾತ್ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ಮಾಜಾ ಬಾನಿ ಲ್ಯಾವ್‌ಲ್ಯಾಲ ಪರತೆಕ್ ಝಾ಼ಡ್ ಮುಳಾಸಕಟ್ ಕಾಡುನ್ ಟ್ಯಾಕ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","ಫರಿಸಾಯಾಂಚಿಪ್ನಿ ದುರ್ ರಾವ್ಹಾ. ತೇಸ್ ಆಂದ್ಳ, ಆನಿ ಯಕಾಲಾ ವಾಟ್ ದಾವಾಯಾ ಜಾ಼ತ್ಯಾತ. ಆಂದಳ್ಯಾನಿ ಆಂದ್‌ಳ್ಯಾಲಾ ವಾಟ್ ದ್ಯಾವ್‌ಲ್ಯಾವ ತೇ ದೊಗ ಬಿ ಚೊ಼ಳತ್ ಪಡ್ನಾರ್” ಮನ್ಹುನ್ ಉತ್ತರ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","ತವಾ ಪೇತ್ರಾ, “ತು ಲೊಕಾನಾ ಆಂದಿ ಕ್ಯಾಯ್ನಿ ಫುಡುನ್ ಸಾಂಗ್‌” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","ಯೇಸುನಿ, “ತುಮಾನಾ ಹ್ಯ ಸಮಜ಼ತ್ನಾಹಿ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","ಯಕಾ ಮಾನ್ಸಾಚಾ ತೊಂಡಾತ್ನಿ ಪೊಟಾತ್ ಜಾ಼ತ ತ್ಯ ಪರತ್ ಬಾಹಿರ್ ಯತ. ಹ್ಯ ತುಮಾನಾ ಠಾವ ಆಸ್‍ಲ್ಯಾಲಸ್ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","ಫನ್ ಯಕಾ ಮಾನ್ಸಾಚಾ ತೊಂಡಾತ್ನಿ ಜಾ಼ನಾರ‍್ಯಾ ಬುರ್ಶಾ ಬೊಲ್ಯಾ ತ್ಯಚಾ ಮನಾತ್ನಿಸ್ ಯತ್ಯಾತಾ ತ್ಯಾ ತ್ಯಲಾ ಬುರ್ಶಾ ಕರ್ತ್ಯಾತಾ. ");
INSERT INTO gok_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","ಮಾನ್ಸಾಚಾ ಮನಾತ್ಲಿ ಬುರ್ಸಿ ಯವಜ್ನಾ಼, ಖುನ್, ರಾಂಡ್ ಸಂಗತ್, ಸೂಳಿಚಾ಼ ದಂಧಾ, ಚು಼ರಿ, ಲಬಾಡ್ ವಳಕ್ ಆನಿ ಸಿವ್ಯಾ ಯತ್ಯಾತಾ. ");
INSERT INTO gok_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","ಹ್ಯ ಮಾನ್ಸಾಲಾ ಬುರ್ಸ ಕರ್ತ. ಫನ್ ಜೆವಾಚೆ ಆಂದಿ ಹಾತ್ ಧುತ್ಲಾತಸ್ ಮಾನುಸ್ ಬುರ್ಸಾ ವ್ಹಯಿತ್ ನಾಹಿ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","ಯೇಸುನಿ ತ್ಯೊ ಜಾ಼ಗಾ ಸುಡುನ್, ತುರ್ ಆನಿ ಸೀದೊನಾಚಾ ಸರ್ಬೌತಾಚಾ ಪ್ರದೇಶಾತ್ನಿ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","ತ್ಯಾ ಜಾ಼ಗ್ಯಾತ್ನಿ ಕಾನಾನ್ಯ ಜಾ಼ಲ್ಯಾಲಿ ಯೇಕ್ ಬ್ಯಾಯ್ಕಾ ಮಾನುಸ್ ಯೇಸುಪ ಯವುನ್, “ಪ್ರಭು, ದಾವಿದಾಚಾ ಲೇಕಾ, ಮಾಜಿವ ಕರ್ನಾ ದ್ಯಾವ್!. ಮಾಜೆ ಲೀಕಿಲಾ ಭುತ್ ದರ್ಲ್ಯಾ ಆನಿ ತೀ ಖುಬ್ ತರಾಸ್ ಖಾತೆ” ಮನ್ಹುನ್ ಜೊ಼ರಾನಿ ವರಾಡ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","ಫನ್ ಯೇಸುನಿ ತೇ ಬ್ಯಾಯ್ಕಾ ಮಾನ್ಸಾಲಾ ಉತ್ತರ್ ದಿಲಾ ನಾಹಿ. ಮನ್ಹುನ್ ಶಿಶಾಂಚಾನಿ ಯೇಸುಪ ಯವುನ್, “ತೇ ಬ್ಯಾಯ್ಕಾ ಮಾನ್ಸಾಲಾ ಜಾ಼ಯಾ ಸಾಂಗ್ ತೀ ವರ್ಡತ್ ಆಮ್ಚೆ ಮಾಗ್ನಿ ಯತ್ಯಾಲಿ ಹಾ” ಮನ್‌ಲ್ಹ. ");
INSERT INTO gok_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","ಯೇಸು, “ಚು಼ಕಲ್ಯಾಲ್ಯಾ ಮೆಂಡ್ರಾಂಚೆಗತ್ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ಇಸ್ರಾಯಲಾಂಚಿಪ ತ್ಯವ್ಡಾಸ್ ಮನಾ ಲಾವುನ್ ದಿಲ್ಯಾ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","ತವಾ ತಿ ಬ್ಯಾಯ್ಕಾ ಮಾನುಸ್ ಯೇಸುಪ ಯವುನ್ ತ್ಯಚೆ ಮೊರ‍್ಹ ಆಡ್ವಿ ಪಡುನ್, “ಪ್ರಭು, ಮನಾ ಮಜ಼ತ್ ಕರ್” ಮನ್‌ಲ್ಹಿ. ");
INSERT INTO gok_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","ಯೇಸು, “ಪೊರ ಖಾತ್ಯಾಲಿ ಭಾಕ್ರಿ ಗಿಹುನ್ ಕುತ್‌ರ‍್ಯಾನಾ ಟಾಕಾಚಿ ಬರಿ ನವ್ಹ” ಮನ್‍ಲ್ಹಾ. ");
INSERT INTO gok_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","ತೀ ಬ್ಯಾಯ್ಕಾ ಮಾನುಸ್, “ವ್ಹಯ್ ಪ್ರಭು, ಫನ್ ಕುತ್ರಿ ಆಪ್‌ಲ್ಯಾ ದನ್ಯಾಚಾ ಮಂಚಾವ್ನಿ ಪಡ್‌ಲ್ಯಾಲ ಉಸ್ಟ ಖಾತ್ಯಾತ ನವ್ಹ” ಮನ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","ತವಾ ಯೇಸು, “ಆಯಿ, ತುಜಾ಼ ಇಸ್ವಾಸ್ ಮೊಟಾ. ತುಜ಼ ಮಾಗ್ನ ಮಿ ಪುರ್ನ ಕರ್ತೊ” ಮನ್ಲಾ ತವಾಸ್ ತಿಚಿ ಲೇಕ್ ಬರಿ ಜಾ಼ಲಿ. ");
INSERT INTO gok_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","ತವಾ ಯೇಸು ತ್ಯೊ ಜಾ಼ಗಾ ಸುಡುನ್ ಗಲಿಲಾಯ ಸಮಿಂದೊರಾಚೆ ದರವ ಜಾ಼ವುನ್ ಯಕಾ ಕನ್ಯಾವ ಬಸ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","ಲೊಕ ಹಿಂಡಾ ಹಿಂಡಾನಿ ಯೇಸುಪ ಆಲಿತ. ತ್ಯಂಚಾನಿ ಖುಬ್ ತರಚಾ ದುಕ್‌ನ್ಯಾತ್‌ಲ್ಯಾನಾ ಹಾಕ್ಟುನ್ ಆನುನ್. ಯೇಸುಪ ಶುಡ್ಲಿತ, ತಿಥ ಮುಡ್ಕಿ, ಆಂದ್ಳಿ, ಲಂಗ್ಡಿ, ಕಿಂವ್ಡಿ, ಹಾತ್‌ಪ್ಯಾ ನಸ್‌ಲ್ಯಾಲಿ ಬೊಚ಼ ಗಸ್ಟಿ ಆಸ್ಲಿ ಖುಬ್ ಲೊಕ ಹುತ್ತಿತ. ತ್ಯನಿ ಹ್ಯನಾ ಸಗ್‌ಳ್ಯಾನಾ ಬರ ಕೆಲ ");
INSERT INTO gok_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","ಮುಕ ಆನಿಕ್ ಬೊಲ್‌ತ್ಯಾಲ ಕುಂಟ ಚಾ಼ಲತ್ಯಾಲ ಹಾತ್‌ ಪ್ಯಾ ನಸ್‌ಲ್ಯಾಲಿ ಚಾ಼ಂಗ್ಲಿ ಜಾ಼ಲಿತ ಆಂದ್‌ಳ್ಯಾನಾ ಆನಿಕ್ ನದಾರ್ ಆಲ್ಯಾಲಿ ಬಗುನ್ ಲೊಕ ಸಗ್ಳಿ ಗಾಬ್ರುನ್ ಇಸ್ರಾಯಲ್ ದೇವಾಚೆ ಮೊರ‍್ಹ ನಾಚ಼್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","ಯೇಸು ಆಪ್‌ಲ್ಯಾ ಶಿಶಾನಾ ಹಾಕ್ಟುನ್, “ಮಿ ಹ್ಯಾ ಲೊಕಾಂಚೆ ಸಾಟಿ ತರಾಸ್ ಖಾತೊ. ಹಿ ತೀನ್ ರೊಜಾ಼ ಠಾವ್ನಿಸಿ ಮಾಜಿ ಸಂಗ ಹಾತ್ತ. ಆತಾ ಹ್ಯನಾ ಖಾಯಾಲಾ ಕಾಯ್ ನಾಹಿ. ಹ್ಯನಾ ಭುಖಚಿ ಲಾವುನ್ ದಿಯಾ ಮನಾ ಮನ್ ನಾಹಿ. ಹಿ ಗರ‍್ಹಾತ್ ಜಾ಼ತಾನಾ ಚಕರ್ ಯವುನ್ ಪಡ್ತಿಲ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","ಶಿಶಾಂಚಾನಿ ಯೇಸುಲಾ, “ಹ್ಯಾ ಲೊಕಾಂಚಾ ಹಿಂಡಾಲಾ ಖಾಯಾ ಪಾಯ್ಜೆ ತ್ಯವ್‍ಡ್ಯಾ ಬಾಕರ‍್ಯಾ ಆಮಾನಾ ಕುಠ ಗಾವ್ನಾರ್? ಹಿತ್ತ ಕಚ಼ ಗಾವ್ ಜ಼ವಳ್ ನಾಹಿ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","ತ್ಯನಿ, “ತುಮ್ಚಿಪ ಕ್ಯವಡ್ಯಾ ಬಾಕರ‍್ಯಾ ಹಾತ್ತಾ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ಶಿಶಾಂಚಾನಿ, “ಆಮ್ಚಿಪ ಸಾತ್ ಬಾಕರ‍್ಯಾ ಹಾತ್ತಾ ಆನಿ ಥೊಡ ಬಾರಿಕ್ ಮಾಸ ಹಾತ್ತ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","ತವಾ ಲೊಕಾನಾ ಜಿಮ್ನಿವ ಬಸಾಲಾ ತ್ಯನಿ ಸಾಂಗ್ಲ, ");
INSERT INTO gok_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","ತವಾ ತ್ಯಾ ಸಾತ್ ಬಾಕರ‍್ಯಾ ಆನಿ ಮಾಸ ಗಿಹುನ್ ತ್ಯಂಚಿಸಾಟಿ ದೇವಾಪ ಸ್ತೊತ್ರ ಸಾಂಗುನ್. ಮಂಗ್ ತ್ಯಾ ಮುಡುನ್ ಶಿಶಾಚಾಂಚಿಪ ದಿಲ್ಯಾ ತ್ಯಂಚಾನಿ ಲೊಕಾನಾ ವ್ಯಾಡ್‌ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","ತವಾ ಲೊಕ ಸಗ್ಳಿ ಖಾವುನ್ ಸಮಾದಾನ್ ಜಾ಼ಲ್ಹಿತ. ಮಾಗ ಖಾಯಾಚೆ ಆಂದಿ ರಾಯ್‌ಲ್ಯಾಲ ಬಾಕ್ರಿಂಚ಼ ತುಕ್ಡ ಶಿಶಾಂಚಾನಿ ಗೊಳಾ ಕೆಲ ತವಾ ಸಾತ್ ಬುಟ್ಯಾ ಬರ್‌ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","ತಿಸಿ ಖಾಲ್ಯಾಲ್ಯಾತ್ಲ ಗಡಿ ಮಾನುಸ್ ಕಮ್ಮಿಸ್ ಕಮ್ಮಿ ಚಾರ್ ಹಾಜಾ಼ರ್ ಜಾ಼ನ್ ಹುತ್ತ. ಯವ್ಡಸ್ ನವ್ಹ ಬ್ಯಾಯ್ಕಾ ಮಾನ್ಸ ಆನಿ ಪೊರಾಂಚಾನಿ ಜೆವಾನ್ ಖಾಲ್ತ. ");
INSERT INTO gok_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","ಮಂಗ್ ಯೇಸುನಿ ಆಪ್‌ಲ್ಯಾ ಆಪ್‌ಲ್ಯಾ ಗರ‍್ಹಾತ್ ಜಾ಼ಯಾ ತ್ಯನಾ ಸಾಂಗುನ್ ಲಾವುನ್ ದಿಲಿತ ಮಂಗ್ ವ್ಹಡಿತ್ ಚ಼ಡುನ್ ಮಗ್ದಾನ್ ಮಂಥ್ಯಾಲ್ಯಾ ಗಾವಾತ್ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","ಫರಿಸಾಯ್ ಆನಿ ಸದುಕಾಯ್ ಯೇಸುಪ ಆಲ. ತೇ ಯೇಸುಚಿ ಪಾರಕ್ ಕರಾಯಾ, “ತು ದೇವಾಪ್ನಿ ಆಲ್ಯಾಲಾ ಮನ್ಹುನ್ ದಾವುನ್ ದಿಯಾ ಯಾಕ್ ಚಮತ್ಕಾರಾಚ಼ ಕಾಮ್ ಕರುನ್ ದ್ಯಾವ್” ಮನ್ಹುನ್ ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","ಯೇಸುನಿ, “ದೀಸ್ ಮಾವಾಳ್ತಾನಾ ವಾತಾವರನ್ ಕಸ ಆಲ ಮನ್ಹುನ್ ತುಮಾನಾ ಸಮಾಜ಼ಲ್ಯಾ. ಆಬಾಳ್ ತಾಂಬ್ಡ ಜಾ಼ಲ್ಹಕಿ, ಆಮಾನಾ ಚಾ಼ಂಗ್ಲ ವಾತಾವರನ್ ಹಾ ಮಂಥಾಸಾ. ");
INSERT INTO gok_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","ಸಕಾಳಚಾ಼ ದೀಸ್ ಉಗಾವ್‌ತ್ಯಾಲಾ ಬಗ್ತಾಸಾ. ಆಬಾಳ್ ಕಾಳ ಜಾ಼ಲ್ಹಕಿ ನಾಹಿತ ತಾಂಬ್ಡ ಜಾ಼ಲ್ಹಕಿ, ಆಜ಼್ ಪಾವುಸ್ ಯನಾರ್ ಮಂಥಾಸಾ, ಹ್ಯ ಸಗ್ಳಿ ವಾತಾವರನಾಚಿ ವಳಕ್ ಜಾ಼ಲೆ. ತುಮಿ ಹಿ ವಳಕ್ ಬಗುನ್ ತ್ಯಚಾ಼ ಆರ್ಥ ಸಮಜು಼ನ್ ಗೆಥಾಸಾ. ತಸಸ್ ತುಮಿ ಬಗ್‌ತ್ಯಾಲ್ಯಾ ಹ್ಯಾ ಗುಶ್ಟಿ ದಿಕಿಲ್ ವಳಕ್ ಜಾ಼ಲೆ. ಫನ್ ಹ್ಯಾ ದಿಸಾಚಾ ವಳ್ಕಿಂಚಾ಼ ಆರ್ಥ ತುಮಾನಾ ಠಾವಾ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","ಬುರ್ಸಿ ಆನಿ ದೇವಾಲಾ ನಕ್ವಾಟ್ ಕೆಲ್ಯಾಲಿ ಲೊಕ ವಳ್ಕಿ ಸಾಟಿ ಯಾಕ್ ಚಮತ್ಕಾರಾಚ಼ ಕಾಮ್ ಬಗಾಯಾ ಮನ್ ಕರ್ತ್ಯಾತ. ಫನ್ ತ್ಯನಾ ಯೊನಾಪ ಜಾ಼ಲ್ಯಾಲ ಚಮತ್ಕಾರಾಚ಼ ಕಾಮ್ ಸುಡುನ್ ದುಸ್ರ ಕುಟ್ಲ ಚಮತ್ಕಾರಾಚ಼ ಕಾಮ್ ಗಾವ್ನಾರ್ ನಾಹಿ” ಮನ್ಲಾ. ನಂತರ್ ಯೇಸು ತ್ಯೊ ಜಾ಼ಗಾ ಸುಡುನ್ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","ಯೇಸು ಆನಿ ತ್ಯಚ಼ ಶಿಶಾ ಸಮಿಂದೊರ್ ವಲ್ಯಾಂಡುನ್ ಗೆಲ. ಫನ್ ಶಿಶಾ ಬಾಕ್‌ರ‍್ಯಾ ಆನಾಯಾ ಇಸಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","ಯೇಸುನಿ ಶಿಶಾನಾ, “ಹುಶಾರಿನಿ ರಾವ್ಹಾ! ಫರಿಸಾಯಾಂಚೆ ಆನಿ ಸದ್ದುಕಾಯಾಂಚಾ ಖಾತ್ಯಾಲ್ಯಾ ಸೊಡ್ಯಾತ್ ಜಾ಼ಗೃತಿನಿ ರಾವ್ಹಾ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","ತ್ಯಂಚಾನಿ ಹ್ಯಚಾ ಅರ್ಥಾಚಾ಼ ಇಚಾರ್ ಕೆಲಾ. ತೇ, “ಆಮಿ ಬಾಖ್‌ರ‍್ಯಾ ಆನಾಯಾ ಇಸಾರ್ಲಾವ್ ಮನ್ಹುನ್ ಯೇಸುನಿ ಆಸ ಸಾಂಗ್ಲ ಆಸಲ್ ಕ್ಯಾ? ಮನ್ಹುನ್ ಬುಲುನ್ ಗೇತ್ಯಾತ ");
INSERT INTO gok_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","ಶಿಶಾ ಹೆ ಗುಶ್ಟಿಚಾ಼ ಇಚಾರ್ ಕರ್ತ್ಯಾಲ ಯೇಸುಲಾ ಸಮಾಜ಼ಲಾ ಹುತ್ತಾ. ಮನ್ಹುನ್ ಯೇಸು ತ್ಯನಾ, “ಬಾಕ್ರಿ ನಾಹಿ ಮನ್ಹುನ್ ಬೊಲ್ತಾಸಾ ಕಾ? ಥೊಡಾ ಇಸ್ವಾಸ್ ಆಸ್‌ಲ್ಯಾಲ್ಯಾನು, ");
INSERT INTO gok_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","ತುಮಿ ಆಜು಼ನ್ ಸಮಜು಼ನ್ ಗೇತ್ಲ ನಾಹಿಸಾ ಕ್ಯಾ? ಪಾಚ಼್ ಬಾಕ್‌ರ‍್ಯಾಂಚಾನಿ ಪಾಚ಼್ ಹಾಜಾ಼ರ್ ಲೊಕಾನಾ ಜೆವಾನ್ ದಿಲ್ಯಾಲ ತುಮಾನಾ ಯಾದ್ ನಾಹಿ ಕ್ಯಾ? ಲೊಕ ಜೆವಾನ್ ಖಾವುನ್ ಜಾ಼ಲ್ಯಾವ ತುಮಿ ಖುಬ್ ಬುಟ್ಯಾತ್ನಿ ಬಾಕ್ರಿ ಬರ್‌ಲ್ಯಾಲ್ಯಾ ತುಮಾನಾ ಯಾದ್ ನಾಹಿ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","ಸಾತ್ ಬಾಕ್‌ರ‍್ಯಾಂಚ಼ ತುಕ್ಡ ಚಾರ್ ಹಾಜಾ಼ರ್ ಲೊಕಾನಾ ಜೆವಾನ್ ವ್ಯಾಡ್‌ಲ್ಯಾ ತುಮಾನಾ ಯಾದ್ ನಾಹಿ ಕ್ಯಾ? ಲೊಕ ಖಾವುನ್ ಜಾ಼ಲ್ಯಾವ ಮಂಗ್ ತುಮಿ ಖುಬ್ ಬುಟ್ಯಾತ್ನಿ ಬಾಕ್ರಿ ಬರ್‌ಲ್ಯಾಲ್ಯಾ ತುಮಾನಾ ಯಾದ್ ನಾಹಿ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","ಮನ್ಹುನ್ ಮಿ ತುಮಾನಾ ಸಾಂಗ್‌ಲ್ಯಾಲ ಬಾಕ್ರಿಂಚ಼ ನವ್ಹ. ತುಮಿ ಹ್ಯ ಸಮಜು಼ನ್ ಗಿಹಿತ್ ನಾಹಿಸಾ ಕಾ? ಫರಿಸಾಯ್ ಆನಿ ಸದ್ದುಕಾಯಾಂಚಾ ಖಾತ್ಯಾಲ್ಯಾ ಸೊಡ್ಯಾತ್ ಗಾವ್ಹಾಚೆ ಆಂದಿ ತುಮಿ ಜಾ಼ಗೃತ್ ರಾಹ್ಯಾ ವ್ಹಯಿಸಾ ಮನ್ಹುನ್ ಮಿ ತುಮಾನಾ ಹುಶಾರ್ಕಿ ದಿಲಿ” ಮನ್ಲಾ” ");
INSERT INTO gok_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","ತವಾ ಶಿಶಾಂಚಾನಿ ಬಾಕ್ರಿಂಚಾ ಆಂಬಾಟ್ ಪಿಠಾಚೆ ಗುಸ್ಟಿತ್ ಹುಶಾರ್ ರಾಹ್ಯಾ ಆಮಾನಾ ಸಾಂಗಲ್ಯಾಲ ನವ್ಹ; ಫರಿಸಾಯ್ ಆನಿ ಸದ್ದು ಕಾಯಾಂಚಾ ಸಿಕಿವ್‌ನ್ಯಾಲಾ ಹುಶಾರ್ ರಾಹ್ಯಾ ಸಾಂಗಲ್ಯಾ ಮನ್ಹುನ್ ಸಮಜು಼ನ್ ಗೆತ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","ಯೇಸು ಪಿಲಿಪ್ಪ ಕೈಸರ್ ಮಂಥ್ಯಾಲ್ಯಾ ಗಾವಾಚೆ ಜ಼ವಳ್. ಯೇಸುನಿ ಆಪ್‌ಲ್ಯಾ ಶಿಶಾನಾ, “ಮಾನ್ಸಾಚಾ಼ ಲ್ಯೊಕ್ ಜಾ಼ಲ್ಯಾಲಾ ಮನಾ ಲೊಕ ಕೊನ್ ಮನ್ಹುನ್ ಸಾಂಗ್‌ತ್ಯಾತ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","ಶಿಶಾ, “ಥುಡಿ ಬಾಪ್ತಿಸ್ಮಾ ಯೊಹಾನ್ ಮಂಥ್ಯಾತ ಆನಿ ಥುಡಿ ಎಲಿಯಾ ಮಂಥ್ಯಾತ. ಆನಿ ಥುಡಿ ಯೆರೆಮಿಯಾ ನಾಹಿತ ಪ್ರವಾದಿತ್ಲಾ ಯೊಕ್ ಮಂಥ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","ತ್ಯಲಾ ತ್ಯನಿ, “ತುಮಿ ಮನಾ ಕೊನ್ ಮಂಥಾಸಾ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","ಸಿಮೊನ್ ಪೇತ್ರಾ, “ತುಸ್ ಕ್ರಿಸ್ತ್. ದೇವಾಪ್ನಿ ಲಾವುನ್ ದಿಲ್ಯಾಲಾ ರಕ್ಷಕ್ ಜಾ಼ಲ್ಯಾಲಾ ಕ್ರಿಸ್ತ್” ಮನ್ಹುನ್ ಉತ್ತರ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","ಯೇಸುನಿ, “ಯೊಹಾನಾಚಾ ಲೇಕಾ ಸಿಮೊನಾ ತು ಬರಾ. ತ್ಯ ತುಲಾ ಸಾಂಗಲ್ಯಾಲ ಮಾನ್ಸಾನಿ ನವ್ಹ. ಸ್ವರ್ಗಾತ್ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ಮಾಜಾ ಬಾನಿ ತುಲಾ ಸಾಂಗುನ್ ದಿಲ. ");
INSERT INTO gok_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","ಮನ್ಹುನ್ ಮಿ ತುಲಾ ಸಾಂಗಾಚ಼ ಕ್ಯಾ ಮಂಜೆ, ತುಸ್ ಪೇತ್ರಾ. ಮಿ ಹೆ ದುಂಢಿವ ಸಬೆ ಬ್ಯಾಂತೊ. ಪಾತಾಳಾತಲ್ಯಾ ಬಳಾಲಾ ಸಾಹಿತ್ ಸಭಾಲಾ ಪಾಡಯಾ ವ್ಹನಾರ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","ಸ್ವರ್ಗಾಚಾ ರಾಜಾಚಿ ಕುಲ್ಪಾಚಿ ಚಾವಿ ಮಿ ತುಲಾ ದೇತೊ. ತು ದರ್ಥಿವ ಅನುಮತಿ ದಿಯಾ ವ್ಹನಾರ್ ತೀ ಸ್ವರ್ಗಾತ್ಬಿ ಅನುಮತಿ ದಿಯಾ ವ್ಹನಾರ್. ತು ಧರ್ಥಿವ ಅನುಮತಿ ದಿಯಾ ವ್ಹಯಿತ್ನಾಯಿ ತೀ ಸ್ವರ್ಗಾತ್ಬಿ ದಿಯಾ ವ್ಹಯಿತ್ನಾಹಿ” ಮನ್‍ಲ್ಹಾ. ");
INSERT INTO gok_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","ಮಂಗ್ ಯೇಸುನಿ ಆಪ್‌ಲ್ಯಾ ಶಿಶಾನಾ, ಆಪ್ನು ಕ್ರಿಸ್ತ ಮನ್ಹುನ್ ಕುನಾಲಾ ಸಾಂಗುನಕೋಸಾ ಮನ್ಹುನ್ ತಾಕಿತ್ ದಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","ತ್ಯಾ ಯಳಾಲಾ ಯೇಸು, “ಆಪ್ನು ಯೆರುಸಲೆಮಿತ್ ಜಾ಼ಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ತಿಥ ಆನಿ ಯೆಹುದ್ಯಾಂಚಾ ಮುಖ್ಯ ಜಾಂತ್ಯಾಂಚ್ಯಾಪ್ನಿ ಮುಖ್ಯ ಯಾಜಕಾಂಚಿಪ್ನಿ ಆನಿ ಧರ್ಮೊಪದೇಶಾಕಾಂಚಿಪ್ನಿ ಆಪ್ನು ಖುಬ್ ತರಾಸ್ ಖಾವುನ್ ಮಾರುನ್ ಟಾಕುನ್ ತಿನ್ವೆ ದೀಸಿ ಮೆಲ್ಯಾಲ್ಯಾತ್ನಿ ಜಿತ್ತಾ ವ್ಹವುನ್ ಉಠುನ್ ಯಯಾ ವ್ಹಯಿ” ಮನ್ಹುನ್ ಆಪ್‌ಲ್ಯಾ ಶಿಶಾನಾ ಉಗ್ಡುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","ತವಾ ಪೇತ್ರಾನಿ ಯೇಸುಲಾ ಕಡವ ನಿಹುನ್, “ ಪ್ರಭು, ದೆವಾನಿ ತುಲಾ ತಸ ಕರುನಾಹಿ!” ತುಲಾ ಆಸ ಕಂದಿಸ್ ವ್ಹವುನಾಹಿ ಮನ್ಹುನ್ ದಪ್‍ಕ್ಯಾವಾಯಾ ಲಾಗಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","ತವಾ ಯೇಸುನಿ ಪೇತ್ರಾಲಾ ಪರ್ತುನ್ ಸಾಂಗ್ಲ, “ಸೈತಾನಾ, ಹಿತ್ನಿ ಜಾ಼! ತು ಮನಾ ಆಡ್ವಾ ಜಾ಼ಲ್ಯಾಸ್! ತುಜಿ ಯವಜ್ನಾ಼ ಮಾನ್ಸಾಚಿ ಯವಜ್ನಾ಼ ದೇವಾಚಿ ನವ್ಹ. ” ");
INSERT INTO gok_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","ಮಂಗ್ ಯೇಸುನಿ ಆಪ್‌ಲ್ಯಾ ಶಿಶಾನಾ, “ಮಾಜೆ ಮಾಗ್ನಿ ಯಯಾ ಮನ್ ಕರ್ತ್ಯಾಲಾ ಆಪ್‌ಲ್ಯಾಲಾಸ್ ಆಪ್ನು ನಕ್ವಾಟ್ ಕರಾಯಾ ವ್ಹಯಿ. ತ್ಯನಿ ತರಾಸ್ ಖಾವುನ್ ಮರಾಯಾಬಿ ತಯಾರ್ ವ್ಹವುನ್ ಮಾಜೆ ಮಾಗ್ನಿ ಯಯಾ ವ್ಹಯಿ. ");
INSERT INTO gok_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","ಆಪ್ಲಾ ಜೀವ್ ಉರ್ವಾ ವ್ಹಯಿ ಮಂಥ್ಯಾಲಾ ತ್ಯೊ ಸಾಂಡುನ್ ಗೇನಾರ್. ಮಾಜಿ ಸಾಟಿ ಆಪ್ಲಾ ಜೀವ್ ದೇನಾರ‍್ಯಾಲಾ ತ್ಯೊ ಪರ್ತುನ್ ಗಾವ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","ಯಕಾನಿ ದುನ್ಯಾ ಸಗ್ಳಿ ಕಮುವುನ್ ಆಪ್ಲಾ ಜೀವ್ ನಾಸ್ ಕರುನ್ ಗೇತ್ಲಾತ ತ್ಯನಿ ತ್ಯಲಾ ಫಾಯ್ದಾ ಕ್ಯಾ? ಮಾನಸಾನಿ ಆಪ್ಲಾ ಜೀವ್ ಗಿಹ್ಯಾ ಸಾಟಿ ಕ್ಯಾ ದಿಯಾ ವ್ಹಯಿಲ್? ");
INSERT INTO gok_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","ಮಾನ್ಸಾಚಾ಼ ಲ್ಯೊಕ್ ಆಪ್‌ಲ್ಯಾ ಬಾಚ಼ ಮೊಟ ಫನ್ ಆನಿ ಆಪ್‌ಲ್ಯಾ ದುತಾ ಸಂಗ ಪರ್ತುನ್ ಯವುನ್ ಪರತೇಕಾಲಾ ತ್ಯಚಾ ತ್ಯಚಾ ಕಾಮಾಜೊ಼ಗ ಪ್ರತಿ ಫಳ್ ದೇನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","ಮಿ ತುಮಾನಾ ಖರ ಸಾಂಗ್ತೊ ಆತಾ ಹಿತ್ತ ಉಬಿ ರಾಯ್‍ಲ್ಯಾಲ್ಯಾತ್ಲಿ ಥುಡಿ ಮಾನ್ಸಾಚಾ಼ ಲ್ಯೊಕ್ ಸಗ್‌ಳ್ಯಾಂಚಾ಼ ರಾಜಾ಼ ವ್ಹವುನ್ ಯತ್ಯಾಲಾ ಬಗಿ ಪರತ್ ಮರ್ನಾರ್ ನಾಹಿತ” ಮನ್ಹು‍ನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","ಸಾ ದಿಸಾ ನಂತರ್, ಪೇತ್ರಾ, ಯಾಕೊಬ್ ಆನಿ ಯಾಕೊಬಾಚಾ಼ ಬಾಹು ಯೊಹಾನಾಲಾ ಹಾಕ್ಟುನ್ ಮೊಟ್ಯಾ ಯಕಾ ಕನ್ಯಾವ ಗೆಲಾ. ತ್ಯನಾ ಸುಡುನ್ ತಿಥ ಕೊನ್ ನವ್ಥ. ");
INSERT INTO gok_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","ಹ್ಯಾ ಶಿಶಾಂಚೆ ನದ್ರ ಮೊರ‍್ಹ ತ್ಯಚ಼ ರುಪ್ ಬದಾಲ್ಲ. ತ್ಯಚ಼ ತ್ವಾಂಡ್ ದಿಸಾಚಾ ಉಜಿಡಾಚಿಗತ್ ಜಾ಼ಲ. ತ್ಯಚ಼ ಕಪ್ಡ ಉಜಿಡಾಚೆಗತ್ ಪಾಂಡ್ರ ಜಾ಼ಲ. ");
INSERT INTO gok_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","ತ್ಯವ್ಡಸ್ ನವ್ಹ ತ್ಯಚೆ ಸಂಗ ದೊಗ ಜಾ಼ನ್ ಗಡಿ ಬೊಲತ್ ಉಬ ಹುತ್ತ. ತೇಸ್ ಮೊಶೇ ಆನಿ ಎಲಿಯಾ. ");
INSERT INTO gok_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","ಪೇತ್ರಾನಿ ಯೇಸುಲಾ, “ಪ್ರಭು, ಆಮಿ ಹಿತ್ತಸ್ ರಾಹ್ಯಾಚ಼ ಬರ. ತು ಹು ಮನ್‌ಲ್ಯಾವ ಹಿತ್ತ ತೀನ್ ಪಾಕ್ಟ ಗಾಲುಯಾ. ತುಲಾ ಯಾಕ್, ಮೊಶೇಲಾ ಯಾಕ್ ಆನಿ ಎಲಿಯಾಲಾ ಯಾಕ್” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","ಪೇತ್ರಾ ಬೊಲ್‌ತ್ಯಾಲಾ ಆಸ್ಥಾನಾ ಪಾಂಡ್ರಾ ಖಡ್ ಯೊಕ್ ಢಗ್ ತ್ಯಂಚಿವ ಆಲಾ ಆನಿ ತ್ಯಾ ಡಘಾತ್ನಿ ಯೊಕ್ ಆವಾಜ಼್ ಆಲಾ, “ಹ್ಯೊ ಮಾಜೆ ಮಾಯೆಚಾ಼ ಲ್ಯೊಕ್. ಹ್ಯೊ ಮನಾ ಖುಬ್ ಆವ್‌ಡ್ಲಾ. ಹ್ಯನಿ ಸಾಂಗ್‌ಲ್ಯಾ ಶಾರ್ಕ ಚಾ಼ಲಾ!” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","ಯೇಸುಚೆ ಸಂಗ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ಶಿಶಾನಾ ಹ್ಯೊ ಸಬ್ದ ಐಕು ಆಲಾ. ತೇ ಖುಬ್ ಬಿಹುನ್ ಪಾಲ್ಥ ಪಡ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","ತವಾ ತ್ಯೊ ಶಿಶಾಂಚಿಪ ಯವುನ್ ತ್ಯನಾ ಹಾತ್ ಲಾವುನ್, “ಉಠಾ ಬಿಹು ನಕೊಸಾ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","ತ್ಯಂಚಾನಿ ಡೊಳ ಉಗ್ಡುನ್ ಬಗ್ಲ ತವಾ ಯೇಸು ಯಕ್ಲಾಸ್ ತಿಥ ಹುತಾ. ");
INSERT INTO gok_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","ಕನ್ಯಾವ್ನಿ ಉತ್ರುನ್ ಯತಾನಾ ಯೇಸುನಿ ಆಪ್‌ಲ್ಯಾ ಶಿಶಾನಾ ತುಮಿ ಕನ್ಯಾವ ಬಗ್‌ಲ್ಯಾಲ ದರ್ಶನ್ ಆತಾ ಕುನಾಲಾ ಸಾಂಗಾಚೆ ಆಂದಿ ಮಾನ್ಸಾಚಾ಼ ಲ್ಯೊಕ್ ಮರುನ್ ಜಿತ್ತಾ ವ್ಹವುನ್ ಆಲ್ಯಾವ ಸಾಂಗಾ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","ಶಿಶಾಂಚಾನಿ ಯೇಸುಲಾ, “ಕ್ರಿಸ್ತ್ ಯಯಾಚೆ ಆಂದಿ ಎಲಿಯಾ ಯಯಾಪಾಯ್ಜೆ ಮನ್ಹುನ್ ಧರ್ಮೊಪದೇಶಕಾಂಚಾನಿ ಸಾಂಗಾಚ಼ ಕಾ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","ಯೇಸುನಿ, “ಎಲಿಯಾ ಯನಾರ್ ಮನ್ಹುನ್ ತೆ ಸಾಂಗ್‌ತ್ಯಾಲ ಖರ. ಖರ‍್ಯಾನಿಸ್ ಎಲಿಯಾ ಯವುನ್ ಸಗ್ಳ ಶಾರ್ಕ ಕರ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","ಫನ್ ಮಿ ತುಮಾನಾ ಸಾಂಗಾಚ಼ ಕ್ಯಾ ಮಂಜೆ, ಎಲಿಯಾ ಆತಾಸ್ ಆಲ್ಯಾ, ಫನ್ ತ್ಯೊ ಕೊನ್ ಮನ್ಹುನ್ ಲೊಕಾನಾ ವಳಾಕ್ಲಾ ನಾಹಿ, ಲೊಕಾಂಚಾನಿ ಆಪ್‌ಲ್ಯಾ ಮನಾತ್ ಯಯಿಲ್ ತಸಾ ತ್ಯಲಾ ತರಾಸ್ ದಿಲಾ. ತಸಾಸ್ ತೀ ಮಾನ್ಸಾಚಾ ಲೇಕಾಲಾ ತರಾಸ್ ದೇನಾರ್” ಮನ್ಹುನ್ ಉತ್ತರ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","ಯೇಸು ಸಾಂಗ್‌ತ್ಯಾಲಾ ಬಾಪ್ತಿಸ್ಮಾ ಯೊಹಾನಾಚ಼ಸ್ ಮನ್ಹುನ್ ಶಿಶಾಂಚಾನಿ ಸಮಜು಼ನ್ ಗೇತ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","ಯೇಸು ಆನಿ ತ್ಯಚ಼ ಶಿಶಾ ಲೊಕಾಂಚಿಪ ಮಾಗಾರ ಗೆಲ. ಯಕ್ಲಾ ಯೇಸುಪ ಯವುನ್ ತ್ಯಚೆ ಮೊರ‍್ಹ ನಡ್ಗ ಗ್ಯಾತ್ಲ, ");
INSERT INTO gok_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“ಪ್ರಭು, ಮಾಜಾ ಲೇಕಾವ ದಯಾ ದ್ಯಾವ್. ತ್ಯೊ ಫೀಟಚಾ ರೊಗಾನಿ ಖುಬ್ ತರಾಸ್ ಖಾತ್ಯೊ. ತ್ಯೊ ತವಾ ತವಾ ಇಸ್‌ಥ್ಯಾತ್ ನಾಹಿತ ಪಾನ್ಯಾತ್ ಪಡ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","ಮಿ ಮಾಜಾ ಲೇಕಾಲಾ ತುಜಾ ಶಿಶ್ಯಾಂಚಾಪ್ನಿ ಆನ್ಲಾ ಫನ್ ತ್ಯಲಾ ಬರ ಕರಾಯಾ ತ್ಯನಾ ಜಾ಼ಲ ನಾಹಿ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","ಯೇಸುನಿ, “ಯೇ, ಇಸ್ವಾಸ್ ನಸ್‌ಲ್ಯಾಲೆ ಆಡ್ವೆ ಪೀಳ್ಗಿ, ಆಜು಼ನ್ ಕಿತಿರೊಜ಼್ ತುಮ್ಚಿ ಸಂಗ ರಾಹು? ಆಜು಼ನ್ ಕಿತಿರೊಜ಼್ ತುಮಾನಾ ಸುಸ್ವುನ್ ಗಿಹು? ತ್ಯಾ ಪ್ಯೊರ್‌ಗ್ಯಾಲಾ ಹಿಕ್ಡ ಹಾಕ್ಟುನ್ ಆನಾ” ಮನ್ಹುನ್ ಉತ್ತರ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","ಯೇಸುನಿ ಪ್ಯೊರ್‌ಗ್ಯಾಪ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ಭುಥಾಲಾಮೊಟ್ಯಾನಿ ಭ್ಯಾ ಗ್ಯಾತ್ಲ ತವಾ ಭುತ್ ತ್ಯಲಾ ಸುಡುನ್ ಗೆಲ ತ್ಯಲಾ ತವಾಸ್ ಬರ ಜಾ಼ಲ. ");
INSERT INTO gok_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","ತವಾ ಶಿಶಾ ತ್ಯವ್ಡಸ್ ಯಗ್ಳುನ್ ಯೇಸುಪ ಯವುನ್, “ತ್ಯಲಾ ಭುಥಾಪ್ನಿ ಸೊಡ್ವಾಯಾ ಆಮಿ ಯತ್ನ ಕಿಲಿತರಿ ಆಮಾನಾ ಕಾ ಜಾ಼ಲ ನಾಹಿ? ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","ತವಾ ಯೇಸುನಿ, “ತುಮಾನಾ ಇಸ್ವಾಸ್ ನಸ್‌ಲ್ಯಾಲಾಸ್ ತ್ಯಲಾ ಕಾರನ್ ಮಿ ತುಮಾನಾ ಖರ ತ್ಯ ಸಾಂಗ್ತೊ ತುಮ್ಚಾ ಇಸ್ವಾಸ್ ಮೌರ‍್ಹಿಚಾ ದಾನ್ಯಾ ಯವ್ಡಾ ಆಸ್ಲಾತ ಹ್ಯಾ ಮೊಟ್ಯಾ ಗುಢ್ಯಾಲಾ ಹಿತ್ನಿ ತಿಥ ಜಾ಼ ಮನ್ಹುನ್ ತುಮಿ ಸಾಂಗ್ಲಸಾತ ತ್ಯೊ ಜಾ಼ತೊ ತುಮ್ಚೆ ಹಾತ್ನಿ ಹ್ವಯಿತ್ನಸ್ನಾರ ಕಾಮ್ ಕಚ಼ಸ್ ನಾಹಿ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","ತುಮಿ ಉಪಾಸಾನಿ ಮಾಗ್ನ ಕೇಲಸಾತ ಆಸ್ಲಿ ಭುಥ ಸುಡುನ್ ಜಾ಼ಯಾ ವ್ಹನಾರ್ ");
INSERT INTO gok_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","ತೆ ಗಲಿಲಾಯಾತ್ ಆಸ್ಥಾನಾಸ್. ಯೇಸುನಿ ಆಪ್‌ಲ್ಯಾ ಶಿಶಾನಾ, “ಮಾನ್ಸಾಚಾ ಲೇಕಾಲಾ ಲೊಕಾಂಚೆ ಹಾತಾತ್ ದೇನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ತೀ ತ್ಯಲಾ ಮಾರುನ್ ಟ್ಯಾಕ್ನಾರ್ ಖರ ತಿನ್ವೆ ದಿಸಿ ತ್ಯೊ ಮೆಲ್ಯಾಲ್ಯಾತ್ನಿ ವರ್ ಉಠುನ್ ಯನಾರ್” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ ಹ್ಯ ಶಿಶಾಂಚಾನಿ ಐಕುನ್ ಖುಬ್ ಬೇಜಾರ್ ಜಾ಼ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","ಯೇಸು ಆನಿ ತ್ಯಚ಼ ಶಿಶಾ ಕಪೆರ್ನೌಮತ್ ಗೆಲ. ದೇವ್ಳಾತ್ ಯೆಹುದ್ಯಾಂಚಿಪ್ನಿ ವರ್ಸಾಚಿ ಜ಼ಖತ್ ಗೊಳಾ ಕರ್ತ್ಯಾಲ ಥೊಡಜಾ಼ನ್ ಪೇತ್ರಾಪ ಯವುನ್ ತುಮಚಾ಼ ಸಿಕಿವ್ನಾರಾ ದೇವ್ಳಾಚಿ ವರ್ಸಾಚಿ ಜ಼ಖತ್ ದಿಯಿತ್ ನಾಹಿ ಕ್ಯಾ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","ತ್ಯಲಾ ಪೇತ್ರಾನಿ, “ವ್ಹಯ್ ದೇತೊನು” ಮನ್ಹುನ್ ಉತ್ತರ್ದಿಲಾ. ಮಂಗ್ ಪೇತ್ರಾ ಯೇಸು ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ಗರ‍್ಹಾತ್ ಗೆಲಾ. ತ್ಯನಿ ತೀ ಗ್ಯೊಶ್ಟ್ ಸಾಂಗಾಚೆ ಆಂದಿ ಯೇಸುನಿ ತ್ಯಲಾ ದರ್ಥಿವ್ಲ ರಾಜ಼ ಲೊಕಾಪ್ನಿ ಕಿತಿಕಿ ತರಚಾ ಜ಼ಖತ್ ಗೆಥ್ಯಾತ ಖರ ಜ಼ಖತ್ ದೇತ್ಯಾಲಿ ಲೊಕ ಕೊನ್? ರಾಜಾಚಿ ಪ್ಯುರ್ಗಿ ಕ್ಯಾ ದುಸ್ರಿ ಲೊಕ? ತುಜ಼ ಮನ್ನ ಕ್ಯಾ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","ಪೇತ್ರಾನಿ ದುಸ್ರಿ ಲೊಕ ಜ಼ಖತ್ ದೆತ್ಯಾತ ಮನ್ಹುನ್ ಉತ್ತರ್ ದಿಲಾ ಯೇಸುನಿ ಪೇತ್ರಾಲಾ ತಸ ಜಾ಼ಲ್ಹತ ರಾಜಾಚಾ ಪ್ಯೊರ್ಗ್ಯಾಂಚಾನಿ ದಿವು ನಾಹಿತ. ");
INSERT INTO gok_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","ಖರ ಜ಼ಖತ್ ಗೊಳಾ ಕರ್ತ್ಯಾಲ್ಯಾನಾ ಆಮಿ ಕಾ ರಾಗ್ ಯಯಿ ಜೊ಼ಗ ಕರಾಚ಼? ತು ಜ಼ಖತ್ ದೇ. ಸಮಿಂದೊರಾತ್ ಜಾ಼ವುನ್ ಮಾಸ ಧರ್ ತುಲಾ ಆಂದಿ ಗಾವಲ್ಯಾಲ್ಯಾ ಮಾಶಾಚ಼ ತ್ವಾಂಡ್ ಉಗಡ್, ತ್ಯಚಾ ತೊಂಡಾತ್ ವರ್ಸಾಚೆ ಜ಼ಖತಿಚಾ಼ ದಿಯಾ ಯೊಕ್ ಪೈಸಾ ಬಗ್ನಾರ್. ತ್ಯೊ ಆನುನ್ ಜ಼ಖತ್ ಗೊಳಾ ಕರ್ತ್ಯಾಲ್ಯಾನಾ ದೇ ತ್ಯನಿ ಮಾಜಿ಼ ಆನಿ ತುಜಿ ಜ಼ಖತ್ ವ್ಹನಾರ್” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","ತ್ಯಾ ಯಳಾಲಾ ಶಿಶಾ ಯೇಸುಪ ಯವುನ್ ಸ್ವರ್ಗಾತ್ ಮೊಟಾ ಜಾ಼ಗಾ ಕುನಾಲಾ ಗಾವ್ನಾರ್ ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","ಯೇಸುನಿ ಬ್ಯಾರ್ಕ್ಯಾ ಮುಲಾಲಾ ಆಪ್ಲೆ ಜ಼ವಳ್ ಹಾಕ್ಟುನ್ ಆಪ್‌ಲ್ಯಾ ಶಿಶಾಂಚೆ ಮೊರ‍್ಹ ತ್ಯಾ ಮುಲಾಲಾ ಉಬ ಕರುನ್ ಆಸ ಮನ್ಲಾ: ");
INSERT INTO gok_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","“ಮಿ ತುಮಾನಾ ಖರ ಸಾಂಗ್ತೊ, ತುಮಿ ಬದ್ಲುನ್ ತುಮ್ಚಾ ಮನಾತ್ ಬಾರಿಕ್ ಮುಲಾಂಚೆಗತ್ ವ್ಹಯಾ ವ್ಹಯಿಸಾ. ನಾಹಿತ, ತುಮಿ ಸ್ವರ್ಗಾಚಾ ರಾಜಾತ್ ಮಿಳ್ನಾರ್ ನಾಹಿಸಾ. ");
INSERT INTO gok_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","ಹ್ಯಾ ಬಾರಿಕ್ ಮುಲಾಚೆಗತ್ ಬ್ಯಾರ್ಕಾ ವ್ಹವುನ್ ಚಾ಼ಲಲ್ ತ್ಯೊ ಸ್ವರ್ಗಾಚಾ ರಾಜಾತ್ ಮೊಟಾ ಜಾ಼ಗಾ ಗೆನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“ಕೊನ್ತರಿ ಮಾಜಾ ನಾವಾನಿ ಬಾರೀಕ್ ಮುಲಾಲಾ ಗೆಥೊ ತ್ಯನಿ ಮನಾ ಗೆತಲ್ಯಾಚೆಗತ್ ವ್ಹನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","ನ್ಹಾನ್ ವ್ಹವುನ್ ಮಾಜೆ ಮಾಗ್ನಿ ಯತ್ಯಾಲ್ಯಾಲಾ ಕೊನ್ ಇಸ್ವಾಸ್ ಸಾಂಡಾಯಾ ಕಾರನ್ ವ್ಹತ್ತೊ ತ್ಯಲಾ ಖುಬ್ ಬುರ್ಸ ವ್ಹನಾರ್. ತ್ಯೊ ಆಪ್‌ಲ್ಯಾ ಗಳ್ಯಾತ್ ಜಾ಼ತ ಬಾಂದುನ್ ಖೋಲ್ ಸಮಿಂದೋರಾತ್ ಬುಡಾಚ಼ ಚಾ಼ಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","ಯೇ! ಲೋಕಾನು ಇಸ್ವಾಸಾಲಾ ಆಡ್ವಿ ಜಾ಼ಲ್ಯಾಲೆ ದುನಿಯಾಚೆ ಗುಶ್ಟಿತ್ ಮಿ ರಡ್ತೊ. ತ್ಯ ಕವಾಬಿ ರಾಥ ಫನ್ ಹ್ಯ ಕೆಲ್ಯಾಲ್ಯಾ ಮಾನ್ಸಾಲಾ ಖುಬ್ ಬುರ್ಸ ವ್ಹನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“ತುಜಾ಼ ಹಾತ್ ನಾಹಿತ, ತುಜಾ಼ ಪ್ಯಾ ತುಜಾ ಇಸ್ವಾಸಾಲಾ ಕಾರನ್ ಆಸ್ಲಾತ ತ್ಯಲಾ ತುಡುನ್ ಟ್ಯಾಕ್. ಹಾತ್ ನಾಹಿತ ಪ್ಯಾ ನಸ್ಥಾನಾ ರಾಹ್ಯಾಚಾ಼ ಶಾಸ್ವತ್ ಜೀವ್ ಗಿಹ್ಯಾಚಾ಼ ತುಲಾ ಚಾ಼ಂಗ್ಲ ದೊನ್ ಹಾತ್ ಆನಿ ದೊನ್ ಪ್ಯಾ ಆಸುನ್ ನರ್ಕಾತ್ ಜಾ಼ಯಾಚೆ ಆಂದಿ ಶಾಶ್ವತ್ ಜಾ಼ಯಾಚ಼ ಬರ. ");
INSERT INTO gok_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","ತುಜ಼ ಡೊಳ ತುಲಾ ಇಸ್ವಾಸಾತ್ ಚಾ಼ಲ್ವಿತ್ ನಸ್ಲತ, ತೇ ಕಾಡುನ್ ಟ್ಯಾಕ್ ದೊನ್ ಡೊಳ ಆಸುನ್ ಇಸ್‌ಥ್ಯಾಚಾ ನರ್ಕಾತ್ ಜಾ಼ಯಾಚೆ ಆಂದಿ ಯೊಕುಸ್ ಡೊಳಾ ಆಸುನ್ ಶಾಶ್ವತ್ ಜೀವ್ ಗಿಹ್ಯಾಚಾ಼ ತುಲಾ ಬರ. ");
INSERT INTO gok_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“ಜಾ಼ಗ್ರತಿನಿ ರಾವ್ಹಾ! ಹ್ಯಾ ಬಾರಿಕ್ ಮುಲಾನಾ ಕಿಮ್ಮತ್ ನಾಹಿ ಮನ್ಹುನ್ ಸಮಜು಼ನಕೋಸಾ. ತ್ಯಂಚಿ ಸಾಟಿ ಸ್ವರ್ಗಾತ್ ದುತಾನಾ ನಿವಡ್‌ಲ್ಯಾತ ತ್ಯಂಚ಼ ಧುತ್ ಸ್ವರ್ಗಾತ್ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ಮಾಜಾ ಬಾಚೆ ಮೊರ‍್ಹ ರಾನ್ಹಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","“ಮಾನ್ಸಾಚಾ಼ ಲ್ಯೊಕ್ ಚು಼ಕುನ್ ಗೆಲ್ಯಾಲ್ಯಾ ಲೊಕಾನಾ ರಾಖಾಯಾ ಆಲಾ. ” ಲುಕ್ ");
INSERT INTO gok_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","ಯಕಾ ಮಾನ್ಸಾಲಾ ಶಂಬರ್ ಮೆಂಡ್ರ ಆಸುನ್ ತ್ಯಾತ್ಲ ಯಾಕ್ ಮೆಂಡಾರ್ ಚು಼ಕ್ಲತ, ತ್ಯೊ ಆಸ್ನಾರಿ ನವದಾವ ನವು ಮೆಂಡ್ರ ರಾನಾತುಸ್ ಸುಡುನ್ ಚು಼ಕ್‌ಲ್ಯಾಲ ಮೆಂಡಾರ್ ಸೊದಾಯಾ ಜಾ಼ನಾರ್ ನವ್ಹ? ");
INSERT INTO gok_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","ಚು಼ಕ್‌ಲ್ಯಾಲ ಮಿಂಡ್ರು ಗಾವ್ಲತ ಚು಼ಕ್‌ಲ್ಯಾ ನಸ್‌ಲ್ಯಾಲಿ ನವದಾವ ನವು ಮೇಂಡ್ರಾವ್ನಿ ತ್ಯಾ ಯಕಾ ಮೇಂಡ್ರಾಚೆ ಗುಶ್ಟಿತ್ ತ್ಯೊ ಖುಬ್ ಸಂತೊಶ್ ವ್ಹನಾರ್ ಮನ್ಹುನ್ ಮಿ ತುಮಾನಾ ಖರ‍್ಯಾನಿ ಸಾಂಗ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","ತಸಸ್ ಹ್ಯಾ ಬಾರಿಕ್ ಮುಲಾತ್ಲ ಯಾಕ್ಬಿ ಚು಼ಕುನ್ ಜಾ಼ವು ನಾಹಿ ಮನ್ಹುನ್ ಸ್ವರ್ಗಾತ್ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ತುಮ್ಚಾ ಬಾಚ಼ ಮನ್ ಜಾ಼ಲ್ಯಾ ");
INSERT INTO gok_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","ತುಜಾ಼ ಬಾಹು ವ್ಹವುನಿ ಭನ್ ವ್ಹವುನಿ ತುಲಾ ಕುನಿತರಿ ಚು಼ಕ್ ಕಿಲಿತ, ತು ಜಾ಼ವುನ್ ತ್ಯೊ ಯಕ್ಲಾಸ್ ಆಸ್ಥಾನಾ ತ್ಯಚಿ ಚು಼ಕ್ ದಾವುನ್ ದೇ. ತ್ಯನಿ ತುಜಾ ಸಬ್ದಾಲಾ ಕಾನ್ ದಿಲಾತ, ಆನಿಕ್ ತುಜಾ಼ ಬಾಹು ವ್ಹವುನ್ ರಾಹ್ಯಾ ತುಸ್ ತ್ಯಲಾ ಮಜ಼ತ್ ಕೇಲ್ಯಾಚೆಗತ್ ವ್ಹನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","ಫನ್ ತ್ಯನಿ ತುಜಿ ಬುಲಿ ಐಕ್ಲಿ ನಾಹಿತ ತುಜೆ ಸಂಗ ದೊಗಾ ತಿಗಾನಾ ಗಿಹುನ್ ತ್ಯಚಿಪ ಜಾ಼ವಾ ತವಾ ಪರತೇಕ್ ಚು಼ಕಿಚೆ ಗುಶ್ಟಿತ್ ದೊಗ ನಾಹಿತ ತಿಗ ವಳಕ್ ರಾನ್ಹಾರ್ ಆಸ ಧರ್ಮ ಶಾಸ್ತಾರ್ ಸಾಂಗ್ತ. ");
INSERT INTO gok_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","ತ್ಯನಿ ತ್ಯಂಚಿ ಬುಲಿ ಐಕ್ಲಿ ನಾಹಿತ ಇಸ್ವಾಸಾಂಚೆ ಸಭೆತ್‌ಲ್ಯಾನಾ ಸಾಂಗಾ. ತ್ಯನಿ ಇಸ್ವಾಸಾಂಚೆ ಸಭೇತ್‌ಲ್ಯಾಂಚ಼ಬಿ ಐಕ್ಲ ನಾಹಿತ ತ್ಯೊ ದೇವಾವ ಇಸ್ವಾಸ್ ನಸ್‌ಲ್ಯಾಲ್ಯಾ ಮಾನ್ಸಾಚೇಗತ್ ರಾಹುನಿ ಜ಼ಖತ್ ಗೊಳಾ ಕರ್ತ್ಯಾಲ್ಯಾಂಚಾ ಲೆಖ್ಯಾತ್ ರಾಹುನಿ. ");
INSERT INTO gok_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“ಮಿ ತುಮಾನಾ ಖರ ಸಾಂಗ್ತೊ. ತುಮಿ ದರ್ಥಿವ ದೇನಾರಾ ಹುಕುಮ್ ದೇವಾನಿಸ್ ದಿಲ್ಯಾಲಾ ಹುಕುಮ್ ರಾಥೊ. ");
INSERT INTO gok_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","ಯವ್ಡಸ್ ನವ್ಹ ಮಿ ತುಮಾನ ಖರ ಸಾಂಗ್ತೊ, ತುಮ್ಚಾತ್‌ಲ್ಯಾ ದೊಗಾಂಚಾನಿ ಹೆ ದುನೆತ್ ಯಕಾ ಮನಾನಿ ಕ್ಯಾಬಿ ಮಾಗ್ಲ ತರಿ ಸ್ವರ್ಗಾತ್ ಆಸ್‌ಲ್ಯಾಲಾ ಮಾಜ಼ ಬಾ ತ್ಯ ಚಾ಼ಲಿವ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","ಕಾ ಮಂಜೆ ದೊಗ ನಾಹಿತ ತಿಗ ಮಾಜಿಪ ಇಸ್ವಾಸ್ ಥಿವುನ್ ಯೇಕ್ ವ್ಹವುನ್ ಯತ್ಯಾತ ತ್ಯಂಚೆ ಮದ್ದಿ ಮಿ ರಾಥೊ. ” ");
INSERT INTO gok_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","ತವಾ ಪೇತ್ರ ಯೇಸುಚೆ ಜ಼ವಳ್ ಯವುನ್, “ಪ್ರಭು, ಮಾಜಾ಼ ಬಾಹು ಕಸ್ಲಿಬಿ ಚು಼ಕ್ ಕರೀತುಸ್ ಆಸ್ಥಾನಾ ಮಿ ಕಿತಿಖೆಪಾ ತ್ಯಲಾ ಮಾಪ್ ಕರಾಯಾ ವ್ಹಯಿ? ಮಿ ತ್ಯಲಾ ಸಾತ್ ಖೆಪಾ ಮಾಪಿ ಕಾರಾಲಾ ವ್ಹಯಿ ಕ್ಯಾ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","ಯೇಸುನಿ ಸಾತ್ ಖೆಪಾ ನವ್ಹ ಸತ್ತರಾವ ಸಾತ್ ಖೆಪಾ ಚು಼ಕ್ ಕಿಲಿತರಿ ತು ತ್ಯಲಾ ಮಾಪಿ ಕರಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಮಿ ತುಲಾ ಸಾಂಗ್ತೊ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","ದೇವಾಚ಼ ರಾಜ ಆಸ ಹಾ. ಆಪ್‌ಲ್ಯಾ ಸೇವಕಾಲಾ ದಿಯಾ ವ್ಹಯಿ ಆಸ್‍ಲ್ಯಾಲ ರಿನಾಚಾ ಪೈಶಾಂಚಾ಼ ಇಸೊಬ್ ಕರಾಯಾ ತಿರ್ಮಾನ್ ಕೆಲ್ಯಾಲ್ಯಾ ಯಕಾ ರಾಜಾಚೆಗತ್ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","ರಾಜಾನಿ ಆಪ್ಲ ಪೈಸ ಗೊಳಾ ಕರಾಚ಼ ಚಾ಼ಲು ಕೆಲ ಯಕಾ ಸೇವಕಾನಿ ಧಾ ಹಾಜಾ಼ರ್ ಚಾ಼ಂದಿಚ಼ ಆನ ರಾಜಾಲಾ ರೀನ್ ದಿಯಾಚ಼ ಹುತ್ತ. ");
INSERT INTO gok_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","ತ್ಯೊ ಸೇವಕ್ ಆಪ್ಲಾ ದನ್ಹಿ ಜಾ಼ಲ್ಯಾಲ್ಯಾ ರಾಜಾಲಾ ರೀನ್ ದಿಯಾ ವ್ಹಯಿತ್ ನಸ್ನಾರಾ ಜಾ಼ಲ್ಥಾ. ಮನ್ಹುನ್ ತ್ಯಾ ಸೇವಕಾಲಾ ಆನಿ ತ್ಯಚಿಪ ಆಸ್‌ಲ್ಯಾಲ ಸಗ್ಳ ತ್ಯಚಿ ಧನ್ಗರ್ ಆನಿ ಪ್ಯೊರ್ಗ್ಯಾಂಚೆ ಸಕಾಟ್ ಇಕುನ್, ಆಲ್ಯಾಲ ಪೈಸ ಸಗ್ಳ ರಿನಾತ್ ಮೊಡಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ರಾಜಾನಿ ತಾಕಿತ್ ದಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“ತವಾ ಸೇವಕ್ ರಾಜಾಚಾ ಪಾಯಾ ಪಡುನ್, ‘ಜ಼ರಾ ಸಮಾಧಾನ್ ಗೇವ್ಹಾ ಮಿ ತುಮಾನಾ ದಿಯಾಚ಼ ಹಾ ತ್ಯ ರೀನ್ ಫೆಡ್ತೊ. ಮಂತೊ. ");
INSERT INTO gok_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","ರಾಜಾ಼ ಆಪ್‌ಲ್ಯಾ ಸೇವಕಾಚೆ ಗುಶ್ಟಿತ್ ದಯಾ ದಾವುನ್ ತ್ಯನಿ ದಿಯಾ ವ್ಹಯಿ ತ್ಯ ರೀನ್ ನಕೊ ಮನ್ಹುನ್ ತ್ಯಲಾ ಮಾಪ್ ಕೆಲಾ ");
INSERT INTO gok_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“ತ್ಯವ್‌ಡ್ಯಾತ್ ತ್ಯೊ ಸೇವಕ್ ಆಪ್‌ಲ್ಯಾಲಾ ಸೆಂಬರ್ ಚಾ಼ಂದಿಚ಼ ಅನ ದಿಯಾಚಾ಼ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ದುಸರ‍್ಯಾ ಯಕಾ ಸೇವಕಾಲಾ ಬಗುನ್ ತ್ಯಚೆ ಮಾನಸ್ ದರ‍್ಹುನ್, ‘ತು ಮನಾ ದಿಯಾ ವ್ಹಯಿ ತೇ ಪೈಸ ದೇ’ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“ತ್ಯೊ ಸೇವಕ್ ತ್ಯಚಾ ಪಾಯಾತ್ ಪಡುನ್, ‘ಜ಼ರಾ ಸಮಾದಾನ್ ಕರ್. ಮಿ ತುಲಾ ದಿಯಾಚ಼ ಹಾ ತ್ಯ ರೀನ್ ಫೆಡ್ತೊ’ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“ಫನ್ ಪೈಲಾ ಸೇವಕ್ ಥಾಂಬ್ಲಾ ನಾಹಿ. ಆಪ್‌ಲ್ಯಾಲಾ ರೀನ್ ದಿಯಾಚಾ಼ ಹಾ ತ್ಯಾ ಸೇವಕಾಚೆ ಗುಶ್ಟಿತ್ ನ್ಯಾಯಿ ಕರ್ತ್ಯಾಲ್ಯಾಂಚಿಪ್ನಿ ಸಾಂಗುನ್ ತ್ಯಲಾ ತುರುಂಗಾತ್ ಗ್ಯಾತ್ಲಾ. ತ್ಯೊ ಸೇವಕ್ ರೀನ್ ಫಿಠ ಪರತ್ ಕುಂಡುನುಸ್ ರಾಹ್ಯಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","ಹ್ಯ ಬಗ್‌ಲ್ಯಾಲ ದುಸ್‌ರ‍್ಯಾ ಸೇವಕಾನಾ ಖುಬ್‌ ಬೆಜಾರ್ ವ್ಹವುನ್ ಜಾ಼ಲ್ಯಾಲಿ ಖನ್ಕತ್ ದನ್ಯಾಲಾ ಸಾಂಗ್ಲಿ. ” ");
INSERT INTO gok_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“ತವಾ ದನ್ಯಾನಿ ಆಪ್‌ಲ್ಯಾ ಸೇವಕಾಲಾ ಹಾಕ್ಟುನ್, ‘ತು ಬರ್ಸಾ ಸೇವಕ್. ತು ಮನಾ ಖುಬ್ ಪೈಸ ದಿಯಾಚ಼ ಹುತ್ತ ಖರ ತು ಮಾಜಿಪ ಮಾಗ್ಲಸ್ ಮನ್ಹುನ್ ಮಿ ತುಜ಼ ರೀನ್ ಸಗ್ಳ ಮಾಪ್ ಕೆಲ. ");
INSERT INTO gok_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","ಆಸ ಆಸ್ಥಾನಾ ಮಿ ತುಲಾ ದಯಾ ದ್ಯಾವ್‌ಲ್ಯಾ ಶಾರ್ಕಿ ತುಜೆ ಸಂಗಚಾ ಸೇವಕಾಲಾ ದಯಾ ದಾವಾಚಿ ಹುತ್ತಿಸ್ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","ಖುಬ್ ರಾಗಾನಿ ತ್ಯಲಾ ಶಿಕ್ಷಾ ದಿಯಾ ಸಾಟಿ ತುರುಂಗಾತ್ ಗ್ಯಾತ್ಲಾ. ತ್ಯೊ ಸೇವಕ್ ಆಪ್ಲ ರೀನ್ ಫಿಠ ಪರತ್ ತುರುಂಗಾತ್ ರಾಯ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“ಸ್ವರ್ಗಾತ್ಲಾ ಮಾಜಾ಼ ಬಾ ತುಮಾನಾ ಕೆಲ್ಯಾಚೆಗತ್ ಹ್ಯಾ ರಾಜಾನಿ ಕೆಲ. ತುಮಿ ತುಮ್ಚಾ ಬಾವ್ಹಾನಾ ವ್ಹವುನಿ ಬನ್ಹಿನಾ ವ್ಹವುನಿ ಖರ‍್ಯಾನಿ ಮಾಪ್ ಕರಾಯಾ ವ್ಹಯಿಸಾ ನಾಹಿತ ಸ್ವರ್ಗಾತ್ಲಾ ಮಾಜಾ಼ ಬಾ ತುಮಾನಾ ಮಾಪ್ ಕರ್ನಾರ್ ನಾಹಿ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","ಯೇಸುನಿ ಹ್ಯಾ ಗುಶ್ಟಿ ಸಾಂಗ್‌ಲ್ಯಾ ಪರತ್ ಗಲಿಲಾಯಾತ್ನಿ ಯೊರ್ದಾನ್ ನ್ಹಚೆ ಪಲಿಕ್ಲೆ ಯುದಾಯಾ ಸಿಮತ್ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","ಯೇಸುಚೆ ಮಾಗ್ನಿ ಖುಬ್ ಲೊಕ ಗಿಲಿತ. ತ್ಯನಿ ತ್ಯಾ ರೊಗಿನಾ ಬರಿಕಿಲಿತ. ");
INSERT INTO gok_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","ಥೊಡ ಫರಿಸಾಯ್ ಯೇಸುಪ ಯವುನ್ ತ್ಯಲಾ ಚು಼ಕಿತ್ ದರಾಯಾಸಾಟಿ, “ಕಚಾಬಿ ಯಕಾ ಕಾರ್ನಾನಿ ಯಕಾನಿ ಆಪ್ಲೆ ದನ್ಗರಿಲಾ ಸುಡುನ್ ದಿಯಾಚಿ ಶಾರ್ಕ ಕ್ಯಾ? ಮನ್ಹುನ್ ಇರ್ಚಾಲ್ಯಾಲ್ಯಾಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","ತ್ಯನಿ, “ಮನುಕ್ಷಾಲಾ ಉತ್ಪನ್ ಕೆಲ್ಯಾಲ್ಯಾನಿ ಆಂದಿಸ್ ತ್ಯನಾ ಬಾಪಯಿ ಆನಿ ಬಾಯಿಲ್ಮಾನುಸ್ ಕೆಲ್ಯಾ, ");
INSERT INTO gok_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ತ್ಯಲಾಸ್ ದೇವಾನಿ, ಬಾಪಯಿ ಆಪ್ಲೆ ಆಯಿ ಬಾಲಾ ಸುಡುನ್ ಆಪ್ಲೆ ದನ್ಗರಿ ಸಂಗ ರಾನ್ಹಾರ್. ತಿ ದೊಗ ಯೆಕ್ ವ್ಹನಾರ್, ಮನ್ಹುನ್ ತುಮಿ ವಾಚಿವ್ಲ ನಾಹಿಸಾ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","ಮನ್ಹುನ್ ತಿ ದೊಗ ಹಿತ್ನಿ ಮೊರ‍್ಹ ದೊಗ ನವ್ಹತ ಯೇಕುಸ್ ತ್ಯನಾ ದೊಗಾನಾ ದೇವಾನಿ ಯೇಕ್ ಕೆಲ್ಯಾತ. ಮನ್ಹುನ್ ಕುಟಲ್ಯಾಸ್ ಮಾನ್ಸಾನಿ ತ್ಯನಾ ಫಾಕಾಚಿ ನಾಹಿತ” ಮನ್ಹುನ್ ಉತ್ತರ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","ಫರಿಸಾಯಾಂಚಾನಿ, “ತಸ ಜಾ಼ಲ್ಯಾ ಯಕಾನಿ ಶೊಡ್ ಸುಟಿಚ಼ ಪತ್ರ ಲಿವುನ್ ದಿವುನ್ ಸುಡುನ್ ದಿಯಾಚ಼ ಮನ್ಹುನ್ ಮೊಶೆನಿ ಆಪ್‌ಲ್ಯಾ ಧರ್ಮಶಾಸ್ತಾರಾತ್ ಸಾಂಗ್ಲ ಕಾ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","ಯೇಸುನಿ, “ತುಮಿ ದೇವಾಚ಼ ಸಿಕಿವ್ನ ಮನಾತ್ ಗೇತ್ಲ ನಾಹಿಸಾ ಮನ್ಹುನ್ ತುಮ್ಚೆ ದನ್ಗರಿನಾ ಸುಡುನ್ ದಿಯಾಚಾ ಮೊಶೆನಿ ಸುಟ್ನುಕ್ ದಿಲಿ. ಫನ್ ದನ್ಗರಿಲಾ ಸೊಡಾಚಿ ಪೈಲ ನವ್ಥ. ");
INSERT INTO gok_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","ಮಿ ತುಮಾನಾ ಸಾಂಗಾಚ಼ ಕ್ಯಾ ಮಂಜೆ, ಆಪ್ಲೆ ದನ್ಗರಿಲಾ ಸುಡುನ್ ದುಸ್ರಿಲಾ ಲಗಿನ್ ವ್ಹತ್ಯಾಲಾ ರಾಂಡ್‌ ಸಂಗತ್ ಕರ್ತ್ಯಾಲಾ ವ್ಹನಾರ್. ಪೈಲಿ ದನ್ಗರ್ ದುಸ್‌ರ‍್ಯಾ ಸಂಗ ರಾಯ್ಲಿತ ತ್ಯನಿ ತಿಲಾ ಸುಡುನ್ ದುಸರಿಲಾ ಲಗಿನ್ ವ್ಹವಾವ” ಮನ್ಹುನ್ ಉತ್ತರ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","ತವಾ ತ್ಯಚಾ ಶಿಶಾಂಚಾನಿ ಯೇಸುಲಾ, “ಯಕಾನಿ ಆಪ್ಲೆ ದನ್ಗರಿಲಾ ಸುಡುನ್ ದಿಯಾ ಹ್ಯ ಯಾಕುಸ್ ಕಾರನ್ ಜಾ಼ಲ್ಯಾವ, ಲಗಿನ್ ಜಾ಼ಲ್ಯಾ ನಸ್‌ಲ್ಯಾವಸ್ ಬರ ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","ತ್ಯಲಾ ಯೇಸುನಿ, “ಲಗ್ನಾಚೆ ಹೆ ಗುಶ್ಟಿತ್ ಹ್ಯ ಖರ ಪರ್ತೇಕ್ ಜಾ಼ನ್ ಗಿಹ್ಯಾ ವ್ಹಯಿತ್ ನಾಹಿ. ಹ್ಯ ಗಿಹ್ಯಾಲಾ ದೇವಾನಿ ಕುನಾಲಾ ಬರಾ ಮನ್ಹುನ್ ಕೆಲ್ಯಾ ತ್ಯಲಾ ತ್ಯವ್ಡಸ್ ವ್ಹನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","ಥುಡಿ ಲಗಿನ್ ವ್ಹಯಾ ನಸಾಲಾ ದುಸ್ರಿ ದುಸ್ರಿ ಕಾರ್ನ ಹಾತ್ತ. ಜ಼ಲಾಮ್‌ಲ್ಯಾ ದರ್ನಿ ಥುಡಿ ಹಿಜ್ಡಿ ವ್ಹವುನ್ ಆಸ್‍ಥ್ಯಾತ. ಆನಿ ಥುಡಿ ದುಸ್‌ರ‍್ಯಾಂಚಾಪ್ನಿ ಹಿಜ್ಡಿ ವ್ಹವುನ್ ರಾಥ್ಯಾತ. ದುಸ್ರಿ ಥುಡಿ ಪರಲೊಕ ರಾಜಾ ಸಾಟಿ ಲಗಿನ್ ಕರುನ್ ಗಿಹಿತ್ ನಾಹಿತ. ಫನ್ ಲಗಿನ್ ವ್ಹನಾರಾ ಲಗ್ನಾಚೆ ಗುಶ್ಟಿತ್ ಹ್ಯ ಸಿಕಿವ್ನ ಗಿಹ್ಯಾ ವ್ಹಯಿ” ಮನ್ಹುನ್ ಉತ್ತರ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","ಮಂಗ್ ಲೊಕ್ ಯೇಸುಚೆ ಜ಼ವಳ್ ಯವುನ್ ಆಪ್‌ಲ್ಯಾ ಬಾರಿಕ್ ಮುಲಾನಾ ಆನುನ್ ತ್ಯಂಚಿ ಸಾಟಿ ಹಾತ್ ಥಿವುನ್ ಮಾಗ್ನ ಕರಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ತ್ಯಚಿಪ ಮಂಥ್ಯಾತ. ಹ್ಯ ಬಗ್‌ಲ್ಯಾಲ್ಯಾ ಶಿಶಾಂಚಾನಿ ಬಾರಿಕ್ ಮುಲಾನಾ ತ್ಯಚಿಪ ಆನುನಕೊಸಾ ಮನ್ಹುನ್ ದಪ್‌ಕ್ಯಾವ್‌ತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","ಫನ್ ಯೇಸುನಿ, “ಬಾರಿಕ್ ಮುಲಾನಾ ಮಾಜಿಪ ಸೊಡಾ ತ್ಯನಾ ಆಡ್ಯಾವು ನಕೊಸಾ. ಕಾ ಮಂಜೆ ದೇವಾಚ಼ ರಾಜೆ ಹ್ಯಾ ಬಾರಿಕ್ ಮುಲಾ ಶಾರ್ಕ ಆಸ್‌ಲ್ಯಾಲ ಲೊಕಾಂಚ಼ಸ್” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","ಮಂಗ್ ಯೇಸುನಿ ಆಪ್ಲ ಹಾತ್ ಮುಲಾವ್ನಿ ಥಿವುನ್ ಆಶಿರ್ವಾದ್ ಕೆಲಾ. ಮಂಗ್ ತಿಥ್ನಿ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","ಯಕಾನಿ ಯೇಸುಚೆ ಜ಼ವಳ್ ಯವುನ್, “ಸಿಕಿವ್ನಾರ‍್ಯಾ ಮಿ ಶಾಶ್ವತ್ ಜೀವ್ ಗಿಹ್ಯಾ ಕ್ಯಾ ಚಾ಼ಂಗ್ಲ ಕಾಮ್ ಕರಾಯಾ ವ್ಹಯಿ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","ಯೇಸುನಿ, “ಚಾ಼ಂಗ್ಲೆ ಗುಶ್ಟಿತ್ ತು ಮನಾ ಇಚಾರಾಚ಼ ಕಾ? ದೇವ್ ಯಕ್ಲಾಸ್ ಚಾ಼ಂಗ್ಲಾ. ಫನ್ ತು ಶಾಶ್ವತ್ ಜೀವ್ ಗಿಹ್ಯಾ ವ್ಹಯಿ ಮನ್‌ಲ್ಹಾಸ್ಥ ಹ್ಯಾ ದೇವಾಚಾ ಹುಕ್ಮಾ ಶಾರ್ಕಾ ಚಾ಼ಲ್” ಮನ್ಹುನ್ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","ತ್ಯೊ ಮಾನುಸ್, “ಕಚಾ಼ ದೇವಾಚಾ಼ ಹುಕುಮ್?ಮನ್ಲಾ. ಯೇಸುನಿ, “ಖುನ್ ಕರಾಚಾ಼ ನಾಹಿ, ವೆಬಿಚಾರ್ ಕರಾಚಾ಼ ನಾಹಿ, ಚು಼ರಿ ಕರಾಚಿ ನಾಹಿ, ಲಬಾಡ್ ಸಾಕ್ಷಿ ಸಾಂಗಾಚಿ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ತುಜೆ ಆಯಿ ಬಾಲಾ ಮರ‍್ಯಾದ್ ದಿಯಾ ವ್ಹಯಿ ಆನಿ ತುಜಿ ತು ಮಾಯಾ ಕರ್ತ್ಯಾಚೆಗತ್ ಸೆಜಾ಼ರ‍್ಯಾಂಚಿ ಮಾಯಾ ಕರಾಯಾ ವ್ಹಯಿಸ್” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","ತ್ಯೊ ಪ್ಯೊರ್ಗಾ, “ಮಿ ಹ್ಯ ಸಗ್ಳ ಕರ್ತ್ಯಾಲೊ ಹಾ. ದುಸ್ರ ಕ್ಯಾ ತರಿ ಕರಾಯಾ ವ್ಹಯಿ ಕ್ಯಾ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","ಯೇಸುನಿ, “ತು ಸಗ್ಳಾ ಪುರ್ನ ವ್ಹಯಾ ವ್ಹಯಿಸ್ತ ಜಾ಼ವುನ್ ತುಜಿ ಆಸ್ಥಿ ಸಗ್ಳಿ ಇಕುನ್, ಆಲ್ಯಾಲ ಪೈಸ ಸಗ್ಳ ಗರಿಬಾನಾ ದೇ. ತವಾ ತುಲಾ ಪರಲೊಕಾತ್ ಮುಟಿ ಆಸ್ಥಿ ಗಾವ್ನಾರ್. ಮಂಗ್ ಮಾಜೆ ಮಾಗ್ನಿ ಯೇ ಮನ್ಹುನ್ ಉತ್ತರ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","ಹ್ಯ ಐಕುನ್ ತ್ಯೊ ಖುಬ್ ದುಃಖಾನಿ ಗೆಲಾ. ಕಾ ಮಂಜೆ ತ್ಯೊ ಮೊಟಾ ಸಾವ್ಕೋರ್ ಜಾ಼ಲ್ಥಾ. ");
INSERT INTO gok_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","ತವಾ ಯೇಸುನಿ ಆಪ್‌ಲ್ಯಾ ಶಿಶಾನಾ, “ಮಿ ತುಮಾನಾ ಖರ ಸಾಂಗ್ತೊ. ಸಾವ್ಕೋರ್ ಆಸ್‌ಲ್ಯಾಲಾ ಸ್ವರ್ಗಾಚಾ ರಾಜಾತ್ ಜಾ಼ಯಾಚ಼ ಖುಬ್ ಕಠಿನ್. ");
INSERT INTO gok_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","ವ್ಹಯ್, ಸಾವ್ಕೋರ್ ಆಸ್‌ಲ್ಯಾಲಾ ದೇವಾಚಾ ರಾಜಾತ್ ಜಾ಼ಯಾಚಾವ್ನಿ ಹೂಟ್ ಸೂಚಾ ಡೊಳ್ಯಾತ್ನಿ ಜಾ಼ಯಾಚ಼ ಸಲ್ಪ ಮನ್ಹುನ್ ಮಿ ತುಮಾನಾ ಸಾಂಗ್ತೊ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","ಶಿಶಾಂಚಾನಿ ಹ್ಯ ಐಕುನ್ ಖುಬ್ ಆಜಾಬ್ ವ್ಹವುನ್, “ತಸ ಜಾ಼ಲ್ಯಾವ ಕುನಾಚಿ ರಕ್ಷಣೆ ವ್ಹನಾರ್? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","ಯೇಸುನಿ ಆಪ್‌ಲ್ಯಾ ಶಿಶ್ಯಾಂಚಿಕ್ಡ ನದಾರ್ ಥಿವುನ್, “ಹ್ಯ ಮಾನ್ಸಾಲಾ ವ್ಹಯಿತ್ ನಸ್‌ಲ್ಯಾಲ ಕಾಮ್. ಫನ್ ದೇವಾಲಾ ಸಗ್ಳ ವ್ಹತ್ತ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","ಪೇತ್ರಾನಿ ಯೇಸುಲಾ, “ಆಮಿ ಆಮಾನಾ ಆಸ್‌ಲ್ಯಾಲ ಸಗ್ಳ ಸುಡುನ್ ತುಜೆ ಮಾಗ್ನಿ ಆಲಾವ್. ಆಮಾನಾ ಕ್ಯಾ ಗಾವ್ನಾರ್” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","ಯೇಸು ಶಿಶಾನಾ ಆಸ ಮನ್‍ಲ್ಹಾ: ಮಿ ತುಮಾನಾ ಖರ ಸಾಂಗ್ತೊ. ನವಿ ದುನಿಯಾ ಕರ್ನಾರ್ ತವಾ ಮಾನ್ಸಾಚಾ಼ ಲ್ಯೊಕ್ ಆಪ್‌ಲ್ಯಾ ಮೊಟ್ಯಾ ಸಿಂಹಾಸನಾವ ಬಸ್ನಾರ್. ಮಾಜೆ ಮಾಗ್ನಿ ಆಲ್ಯಾಲ ತುಮಿ ಸಗ್ಳ ಸಿಂಹಾಸನಾವ ಬಸುನ್ ಇಸ್ರಾಯಲಾತಲ್ಯಾ ಬಾರಾ ಕುಳ್ಯಾಂಚಾ಼ ನ್ಯಾಯಿ ನಿವಡ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","ಮಾಜೆ ಮಾಗ್ನಿ ಯಯಾಲಾ ಆಪ್ಲ ಘರ್, ಭನ್ಹಿ ಬಾವ್ಹಾನಾ, ಆಯಿ ಬಾಲಾ, ಪೊರಾನಾ ಆನಿ ಆಸ್ಥಿ ಶೊಡ್‌ಲ್ಯಾಲ ಪರ್ತೇಕ್ ಜಾ಼ನ್ ಆಪ್ನು ಶೊಡ್‌ಲ್ಯಾಲ್ಯಾವ್ನಿ ಆಗಾವ್ ಗೇನಾರ್. ನಾಹಿತ ಶಾಶ್ವತ್ ಜೀವ್ ಗೇನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","ಫನ್ ಆಂದಿಚಾತ್ಲ ಖುಬ್ ಜಾ಼ನ್ ಮಾಗ್ಲ ವ್ಹನಾರ್; ಮಾಗ್ಲ ಖುಬ್ ಜಾ಼ನ್ ಆಂದಿಚ಼ ವ್ಹನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","ಯೇಸುನಿ “ದೇವಾಚ಼ ರಾಜೆ ಆಸ ಹಾ. ಯೊಕ್ ಮಾನುಸ್, ಯಕಸಿ ಸಕಾಳ್ಚಾ ತ್ಯೊ ಆಪ್ಲೆ ದರಾಕ್ಷಿಚೆ ಬಾಗತ್ ಕಾಮ್ ಕರಾಯಾ ದುಸ್‌‍ರ‍್ಯಾ ಕಾಮ್ಗಾರ‍್ಯಾನಾ ಹಾಕ್ಟಾಯಾ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","ಯಕಾ ದಿಸಾಲಾ ಯಕಾ ಕಾಮ್ಗಾರ‍್ಯಾಲಾ ಯೊಕ್ ಚಾ಼ಂದಿಚಾ಼ ಆನಾ ದೇತೊ ಮನ್ಹುನ್ ಸಾಂಗುನ್ ತ್ಯಾ ಕಾಮ್ಗಾರ‍್ಯಾಲಾ ತ್ಯನಿ ದರಾಕ್ಷಿಚಾ ಮಳ್ಯಾತ್ ಲಾವುನ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“ಜ಼ವ ಜ಼ವಳ್ ನವು ವಾಸ್ತಾನಾ ದನ್ಹಿ ಪೆಠ್ಹತ್ ಗೆಲಾ. ಕಾಯ್ ಕಾಮ್ ನಸ್ಥಾನಾ ಗಪ್ ಉಬಿ ರಾಯ್‌ಲ್ಯಾಲ್ಯಾ ಥೊಡ್ಯಾನಾ ತ್ಯನಿ ತಿಥ ಬಗ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","ತ್ಯನಿ ತ್ಯನಾ, ‘ತುಮಿ ಜಾ಼ವುನ್ ಮಾಜಾ ದರಾಕ್ಷಿಚಾ ಮಳ್ಯಾತ್ ಕಾಮ್ ಕೆಲ್ಯಾವ ತುಮ್ಚಾ ಕಾಮಾ ಶಾರ್ಕಿ ಕುಲ್ ದೇತೊ’ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","ತೇ ಕಾಮ್ಗಾರ್ ಕಾಮ್ ಕರಾಯಾ ತ್ಯಚೆ ಬಾಗತ್ ಗೆಲ. “ತ್ಯೊ ದನ್ಹಿ ತಸಾಸ್ ದೀಸ್ ಡುಯಿವ ಆಲಾ ತವಾ ಯಂಗ್ದಾ ಆನಿ ತೀನ್ ವಾಸ್ಥಾನಾ ಯಂಗ್ದಾ ಪೆಠ್ಹತ್ ಗೆಲಾ. ಆನಿ ತ್ಯನಿ ತಸಸ್ ಕೆಲ. ");
INSERT INTO gok_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","ಜ಼ವ ಜ಼ವಳ್ ಪಾಚ಼್ ವಾಸ್ಥಾನಾ ತ್ಯೊ ದನ್ಹಿ ಆನಿ ಯಂಗ್ದಾ ಪೆಠ್ಹತ್ ಗೆಲಾ ತಿಥ ಉಬಿ ರಾಯ್‌ಲ್ಯಾಲ್ಯಾ ಥೊಡ್ಯಾನಾ ತ್ಯನಿ ಬಗುನ್ ತುಮಿ ದೀಸ್ ಬರ್ ಕಾಯೇಕ್ ಕಾಮ್ ನಸ್ಥಾನಾ ಗಪ್ ಕಾ ಉಬಿಹಾಸಾ?’ ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“ತ್ಯಲಾ ತ್ಯಂಚಾನಿ ಆಮಾನಾ ಕುನಿ ಕಾಮ್ ದಿಲ ನಾಹಿ ಮನ್‌ಲ್ಹಿತ “ತ್ಯಾ ದನ್ಯಾನಿ, ತಸ ಜಾ಼ಲ್ಹತ ತುಮಿ ಜಾ಼ವುನ್ ಮಾಜಾ ದರಾಕ್ಷಿಚಾ ಮಳ್ಯಾತ್ ಕಾಮ್ ಕರಾ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“ತವಾ ಶಾಂಚ಼, ದರಾಕ್ಷಿಚಾ ಮಳ್ಯಾಚಾ ದನ್ಹಿ ಫುಡಾರ‍್ಯಾಲಾ, ‘ಕುಲ್ ಕರ‍್ಯಾನಾ ಹಾಕ್ಟುನ್ ಮಾಗ್ನಿ ಆಲ್ಯಾಲ್ಯಾ ದರ್ನಿ ಆಂದಿ ಆಲ್ಯಾಲ್ಯಾ ಪರತ್ ಕುಲ್ ದೇ’ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“ಪಾಚ಼್ ವಾಸ್ತಾನಾ ಆ‌ಲ್ಯಾಲ ಕಾಮ್ಗಾರ್ ಆಪ್ಲಿ ಕುಲ್ ಗಿಹ್ಯಾ ಆಲ ಪರತೇಕ್ ಆಳಾನಾ ಯೊಕ್ ಯೊಕ್ ಚಾ಼ಂದಿಚಾ಼ ಆನಾ ಗಾವ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","ಮಂಗ್ ಆಂದಿ ಹಾಕಟ್‌ಲ್ಯಾಲ ಆಪ್ಲಿ ಕುಲ್ ಗಿಹ್ಯಾ ಆಲ. ದುಸ್‌ರ‍್ಯಾ ಆಳಾವ್ನಿ ಜಾಸ್ಥಿ ಗಾವಲ್ ಮನ್ಹುನ್ ತ್ಯಂಚಾನಿ ಯವಜ಼್ಲ ಹುತ್ತ. ಫನ್ ತ್ಯನಾಬಿ ಯೊಕ್ ಯೊಕ್ ಚಾ಼ಂದಿಚಾ಼ ಆನಾ ಗಾವ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","ತ್ಯಂಚಾನಿ ಆಪ್ಲಾ ಚಾ಼ಂದಿಚಾ಼ ಆನಾ ಗೇತ್ಲಾ ತವಾ ಮಳ್ಯಾಚಾ ದನ್ಯಾಪ ಟುರ್ಟುರ‍್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘ಮಾಗ್ನಿ ಆಲ್ಯಾಲ್ಯಾ ಆಳಾಂಚಾನಿ ಯೇಕ್ ತಾಸ್ ತ್ಯವ್ಡಸ್ ಕಾಮ್ ಕೇಲ್ತ. ಫನ್ ಹ್ಯನಿ ತ್ಯನಾ ಆಮ್ಚಿ ಯವ್ಡಸ್ ದಿಲ್ಯಾತ. ಆಮಿ ತರಿ ಭರ್ ಉನಾತ್ನಿ ತರಾಸ್ ಖಾವುನ್ ಕಾಮ್ ಕೆಲ’ ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“ಮಳ್ಯಾಚಾ಼ ದನ್ಹಿ ತ್ಯಾ ಆಳಾತ್‌ಲ್ಯಾ ಯಕ್‌ಲ್ಯಾಲಾ, ಸೋಪ್‌ತ್ಯಾ ಮಿ ತುಮಾನಾ ಅನೆವ್ ಕೆಲಾ ನಾಹಿ. ಯಕಾ ಚಾ಼ಂದಿಚಾ ಆನ್ಯಾಸಾಟಿ ಕಾಮ್ ಕರಾಯಾ ಹು ಮನ್ಲಾಸ್ ನವ್ಹ? ");
INSERT INTO gok_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","ಮನ್ಹುನ್ ತು ತುಜಿ ಕುಲ್ ಗಿಹುನ್ ಜಾ಼. ಮಿ ತುಲಾ ಕ್ಯವ್ಡಿ ಕುಲ್ ದಿಲೆ ತ್ಯವ್ಡಿಸ್ ಕುಲ್ ಮಾಗ್ನಿ ಆಲ್ಯಾಲ್ಯಾಲಾಬಿ ದಿಯಾ ಮನ್‌ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","ಮಾಜ಼ ಪೈಸ ಮನಾ ಮನ್ ಯಯಿಲ್ ತ್ಯಲಾ ಮಿ ದೆನಾರ್ ನವ್ಹ? ಮಿ ತ್ಯನಾ ಚಾ಼ಂಗ್ಲ ಕೆಲ ಮನ್ಹುನ್ ತುಲಾ ಖೊಟ ಫನ್ ಕ್ಯಾ? ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“ಹೆಸ್ ತರನಿ ಮಾಗ್ಲ ಆಂದಿಚ಼ ವ್ಹನಾರ್ ಆಂದಿಚ಼ ಮಾಗ್ಲ ವ್ಹನಾರ್. ” ");
INSERT INTO gok_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","ಯೇಸು ಯೆರುಸಲೇಮಿತ್ ಜಾ಼ಯಿತಾ. ತ್ಯಚ಼ ಬಾರಾ ಜಾ಼ನ್ ಶಿಶಾ ತ್ಯಚಿ ಸಂಗ ಹುತ್ತ. ಯೇಸುನಿ ತ್ಯನಾ ಯಕಾನ್ಸಿ ಕಡವ ಹಾಕ್ಟುನ್, ");
INSERT INTO gok_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“ಆಮಿ ಯೆರುಸಲೇಮಿತ್ ಜಾ಼ತ್ಯಾವ್. ಮಾನ್ಸಾಚಾ ಲೇಕಾಲಾ ಮುಖ್ಯ ಯಾಜಕಾಂಚಾ ಆನಿ ಧರ್ಮೊಪದೇಶಕಾಂಚಾ ತಾಬ್ಯಾತ್ ದೇನಾರ್. ತೇ ತ್ಯಲಾ ಯೆಹುದ್ಯ ನಸ್‌ಲ್ಯಾಲ್ಯಾಂಚಾ ಹಾತಾತ್ ದೇನಾರ್ ತೀ ತ್ಯಲಾ ಮರ್ನಾಚಿ ಶಿಕ್ಷಾ ದೇನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ತೆ ತ್ಯಲಾ ದುಸ್‌ರ‍್ಯಾ ಲೊಕಾಂಚಾ ಹಾತಾತ್ ದೇನಾರ್, ತೆ ತ್ಯಚಿ ನಿಂದಾ ಕರುನ್, ಕಾಟ್ಯಾಚಾ ಚಾಬುಕಾನಿ ಮಾರುನ್ ಶಿಲ್ಬೆವ ಗ್ಯಾಲ್ನಾರ್ ಫನ್ ತ್ಯೊ ಮೆಲಾ ತರಿ ತಿನ್ವೆ ದೀಸಿ ಆನಿಕ್ ಜಿತ್ತಾ ವ್ಹವುನ್ ಉಠುನ್ ಯನಾರ್” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","ತವಾ ಜೆಬೆದಾಯಾಚಿ ದನ್ಗರ್ ಯೇಸುಪ ಆಲಿ. ತಿಚ಼ ಪ್ಯೊರ್ಗ ತಿಚಿ ಸಂಗ ಹುತ್ತ. ತೀ ಯೇಸುಚೆ ಮೊರ‍್ಹ ಆಡ್ವಿ ಪಡುನ್ ಆಪ್ಲ ಮಾಗ್ನ ಪುರ್ನ ಕರಾಯಾ ವ್ಹಯಿ ಮನ್ಹು‍ನ್ ಮಾಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","ಯೇಸುನಿ, “ತುಜ಼ ಮಾಗ್ನ ಕ್ಯಾ? ಮನ್ಲಾ ತೀ, “ತುಜಾ ರಾಜಾತ್, ಮಾಜಾ ಪ್ಯೊರ್ಗ್ಯಾತ್ಲಾ ಯಕ್ಲಾ ತುಜೆ ಉಜ್‍ವ್ಯಾಂಗ್ನಿ ಆನಿ ಯಕ್ಲಾ ತುಜೆ ಡಾವ್ಯಾಂಗ್ನಿ ಬಸ ಶಾರ್ಕ ಸಬ್ದ ದೆ” ಮಂಥಿ. ");
INSERT INTO gok_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","ಯೇಸುನಿ ತಿಚಾ ಪೊರಾನಾ, “ತುಮಿ ಕ್ಯಾ ಮಾಗ್‌ತ್ಯಾಸಾ ಮನ್ಹುನ್ ತುಮಾನಾ ಠಾವ ನಾಹಿ. ಮಿ ಗೆಥ್ಯಾಲಾ ತರಾಸಾಚಾ಼ ಲೊಟಾ ತುಮಾನಾ ಗಿಹ್ಯಾ ವ್ಹಯಿಲ್ ಕ್ಯಾ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ತ್ಯಲಾ ತೇ “ವ್ಹಯ್ ಆಮಾನಾ ವ್ಹತ್ತ” ಮನ್ಹುನ್ ಉತ್ತರ್ ದಿಲಾ ");
INSERT INTO gok_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","ಯೇಸುನಿ ತ್ಯನಾ, “ಮಿ ಪಿತ್ಯಾಲ್ಯಾ ತರಾಸಾಚಾ ಲೊಟ್ಯಾತ್ ತುಮಿ ಪಿಸಿಲಾ. ಫನ್ ಮಾಜೆ ಉಜ್‌ವ್ಯಾಂಗ್ನಿ ನಾಹಿತ ಡಾವ್ಯಾಂಗ್ನಿ ಬಸ್ನಾರ‍್ಯಾಲಾ ನಿವ್ಡುನ್ ಗೇತ್ಯಾಲಾ ಮಿ ನವ್ಹ. ಮಾಜಾ಼ ಬಾ ತ್ಯೊ ಜಾ಼ಗಾ ಕುನಾಸಾಟಿ ರಾಖುನ್ ಥೆವ್‌ಲ್ಯಾ ತ್ಯನಾ ತ್ಯೊ ಅವ್ಕಾಸ್ ದೇತೊ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","ಬಾಕಿಚಾ ಧಾಜಾ಼ನ್ ಶಿಶಾಂಚಾನಿ ಹ್ಯ ಐಕ್ಲ ಆನಿ ತ್ಯಾ ಬಾವ್ಹಾಂಚಾ಼ ರಾಗ್ ಕೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","ಯೇಸುನಿ ಶಿಶಾನಾ ಸಗ್‌ಳ್ಯಾನಾ ಯಕಿಕ್ಡ ಹಾಕ್ಟುನ್, ಯೆಹುದ್ಯನಸ್‌ಲ್ಯಾಲ ಅಧಿಪತಿ ಲೊಕಾವ್ನಿ ಆಪ್ಲಾ ಅಧಿಕಾರ್ ದಾವಾಯಾ ಮನ್ ಕರ್ತ್ಯಾತ ಮನ್ಹುನ್ ತುಮಾನಾ ಠಾವ ಹಾ. ಆನಿ ತ್ಯಾತ್ಲ ಮೊರ್ಲ ಜಾಂತ ಲೊಕಾವ್ನಿ ಆಪ್ಲ ಅಧಿಕಾರ್ ಚಾ಼ಲ್ವಾಯಾ ಮನ್ ಕರ್ತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","ಫನ್ ತುಮಿ ತಸ ಕರಾಚ಼ ನಾಹಿ. ತುಮ್ಚಾತ್ ಮೊಟಾ ವ್ಹಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಮನ್‌ ಕರ್ತ್ಯಾಲ್ಯಾನಿ ದುಸ್‍ರ್ಯಾಂಚಿ ಚಾ಼ಕ್ರಿ ಕರಾಯಾ ವ್ಹಯಿ. ");
INSERT INTO gok_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ತುಮ್ಚಿಪ್ಲಾ ಆಂದಿಚಾ಼ ವ್ಹಯಾ ಮನ್ ಕರ್ತ್ಯಾಲಾ ಗುಲಾಮಾಚೆಗತ್ ಚಾ಼ಕ್ರಿಕರಾಯಾ ವ್ಹಯಿ. ");
INSERT INTO gok_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","ಹ್ಯೊಸ್ ನೇಮ್ ಮಾನ್ಸಾಚಾ ಲೇಕಾಲಾ ಬೀ ವ್ಹನಾರ್ ತವಾ ಮಾನ್ಸಾಚಾ಼ ಲ್ಯೊಕ್ ದುಸ್‌ರ‍್ಯಾಪ್ನಿ ಸೇವಾ ಕರುನ್ ಗಿಹ್ಯಾ ಆಲಾ ನಾಹಿ ದುಸ್‌ರ‍್ಯಾಂಚಿ ಸೇವಾ ಕರಾಯಾ ಆನಿ ಕಿತಿಕಿ ಲೊಕಾನಾ ರಾಖಾಯಾ ಸಾಟಿ ಆಪ್ಲಾ ಜೀವುಸ್ ದಿಯಾ ಆಲಾ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","ಯೇಸು ಆನಿ ತ್ಯಚ಼ ಶಿಶಾ ಯೆರಿಕೊವಿತ್ನಿ ನಿಗುನ್ ಯತಾನಾ ಖುಬ್ ಲೊಕ ಯೇಸುಚೆ ಮಾಗ್ನಿ ಆಲಿತ. ");
INSERT INTO gok_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","ವಾಟಚೆ ಜ಼ವಳ್ ದೊಗಜಾ಼ನ್ ಅಂದ್ಳ ಬಸ್ಲ ಹುತ್ತ. ಯೇಸು ಹೆ ವಾಟನಿ ಜಾ಼ತ್ಯೊ ಮನ್ಹುನ್ ತ್ಯಂಚಾನಿ ಐಕ್ಲ ತವಾ, “ಪ್ರಭು, ದಾವಿದಾಚಾ ಲೇಕಾ ಆಮ್ಚಿವ ದಯಾ ದ್ಯಾವ್!” ಮನ್ಹುನ್ ವರಾಡ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","ಲೊಕಾಂಚಾನಿ ಸಗ್‌ಳ್ಯಾ ಆಂದ್‌ಳ್ಯಾನಾ ದಪ್‌ಕ್ಯಾವುನ್, “ಗಪ್ ರಾವ್ಹಾ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ಫನ್ ತೇ ಆಂದ್ಳ, “ಪ್ರಭು, ದಾವಿದಾಚಾ ಲೇಕಾ, ಆಮ್ಚಿವ ದಯಾ ದ್ಯಾವ್!” ಮನ್ಹುನ್ ಖುಬ್ ವರಾಡ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","ಯೇಸು ಉಬಾ ರಾಹುನ್, ತ್ಯಾ ಆಂದ್‌ಳ್ಯಾನಾ “ಮಿ ತುಮಾನಾ ಕ್ಯಾ ಕರಾಯಾ ವ್ಹಯಿ ಮಂಥಾಸಾ? ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","ತವಾ ಆಂದ್ಳ, “ಪ್ರಭು, ಆಮಾನಾ ಬಗಾಯಾ ಮಜ಼ತ್ ಕರ್!” ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","ಯೇಸುನಿ ತ್ಯಂಚಿ ಸಾಟಿ ದುಃಖಾನಿ ತ್ಯಂಚಾ ಡೊಳ್ಯಾನಾ ಹಾತ್ ಲ್ಯಾವ್ಲಾ. ತವಾಸ್ ತ್ಯನಾ ನದಾರ್ ಆಲಿ. ಮಂಗ್ ತೇ ಯೇಸುಚೆ ಮಾಗ್ನಿ ಗೆಲ. ");
INSERT INTO gok_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","ಯೇಸು ಆನಿ ತ್ಯಚ಼ ಶಿಶಾ ಯೇರುಸಲೇಮಿಕ್ಡ ಜಾ಼ತಾನಾ ಆಲಿವ್ ಗುಢ್ಯಾಚೆ ವರ್ ಆಸ್‌ಲ್ಯಾಲೆ ಬೆತ್ಪೆಗೆಚಾ ಗಾವಾತ್ ಆಲ. ತಿಥ ಯೇಸುನಿ ಆಪ್‌ಲ್ಯಾ ದೊಗಾ ಶಿಶಾನಾ ಹಾಕ್ಟುನ್ ಆಪ್ಲೆ ಮೊರ‍್ಹ ಲಾವುನ್ ದಿಲ. ");
INSERT INTO gok_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“ತುಮ್ಚೆ ಮೊರ‍್ಹ ಆಸ್‌ಲ್ಯಾಲೆ ಪೆಠ್ಹತ್ ಜಾ಼ವಾ. ತುಮಿ ತ್ಯಾತ್ ಗೆಲಾಸಾಕಿ, ತಿಥ ಬ್ಯಾಂದ್‌ಲ್ಯಾಲ ಯಾಕ್ ಗಾಡಾವ್ ಬಗ್ನಾರ್. ತ್ಯಾ ಗಾಡ್ವಾಸಂಗ ಯಾಕ್ ತ್ಯಚ಼ ಪ್ವಾರ್ ಸಾಹಿತ್ ತುಮಿ ಬಗ್ನಾರ್. ತೀ ದುನಿ ಗಾಡ್ವ ಸುಡುನ್ ಮಾಜಿಪ ಆನಾ. ");
INSERT INTO gok_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","ತುಮಿ ಕಾ ಗಾಡ್ವ ಗಿಹುನ್ ಜಾ಼ತಾಸಾ ಮನ್ಹುನ್ ತುಮಾನಾ ಕುನಿತರಿ ಇಚಾರ್ಲತ, ‘ಹಿ ಗಾಡ್ವ ಪ್ರಭುಲಾ ವ್ಹಯಿತ. ತ್ಯೊ ತ್ಯನಾ ಚಾ಼ಟಕ್ಯಾನಿ ಮಾಗಾರಿ ಲಾವುನ್ ದೇತ್ಯೊ’ ಮನ್ಹುನ್ ಸಾಂಗಾ” ಆಸ ಸಾಂಗುನ್ ಲಾವುನ್ ದಿಲ. ");
INSERT INTO gok_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","ಯಕಾ ಪ್ರವಾದಿನಿ ಸಾಂಗ್‌ಲ್ಯಾಲಿ ಪ್ರವಾದನೆ ಹಿತ್ತ ಗಡ್ಲಿ. ತ್ಯ ಕ್ಯಾ ಮಂಜೆ: ");
INSERT INTO gok_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“ಸಿಯೋನ್ ಪೆಠ್ಹತ್ ಸಾಂಗಾ. ‘ತುಜಾ಼ ರಾಜಾ಼ ಆತಾ ನ್ಹಾನ್ ತುಜಿಪ ಯತ್ಯೊ. ಶಾಂತ್ ಫನಾನಿ ಗಾಡ್ವಾವ ಬಸುನ್ ಯತ್ಯೊ. ವ್ಹಯ್, ದ್ಯಾನ್‌ಗ್ಯಾ ಗಾಡ್ವಾವ ಬಸುನ್ ಯತ್ಯೊ” ");
INSERT INTO gok_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","ತೇ ಶಿಶಾ ಜಾ಼ವುನ್, ಯೇಸುನಿ ಸಾಂಗ್‌ಲ್ಯಾ ಶಾರ್ಕ ತ್ಯಂಚಾನಿ ಕೆಲ. ");
INSERT INTO gok_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","ಗಾಡಾವ್ ಆನಿ ತ್ಯಚ಼ ಪ್ವಾರ್ ಆನುನ್ ತ್ಯಂಚಾನಿ ಆಪ್‌ಲ್ಯಾ ವೈಲ್ಯಾ ಆಂಗಿ ತ್ಯಂಚಿವ ಗ್ಯಾತ್‌ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","ತವಾ ಯೇಸು ದ್ಯಾನ್‍ಗ್ಯಾ ಗಾಡ್ವಾವ ಬಸುನ್ ಯೆರುಸಲೆಮಿತ್ ಗೆಲಾ ಖುಬ್ ಲೊಕಾಂಚಾನಿ ಆಪ್‍ಲ್ಯಾ ವೈಲ್ಯಾ ಆಂಗ್ಯಾ ಯೇಸು ಸಾಟಿ ವಾಟವ ಹಾತರ್ಲ್ಯಾತಾ. ಥೊಡ್ಯಾಂಚಾನಿ ಜಾ಼ಢಾಂಚ಼ ಕವ್ಳ ಶೆಂಡ ತುಡುನ್ ವಾಟವ ಪಗಳ್ಳ. ");
INSERT INTO gok_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","ಥೊಡಿ ಜ಼ನ ಯೇಸುಚೆ ಮೊರ‍್ಹ ಚಾ಼ಲತ್ ಜಾ಼ಯಿತಿತ ಥುಡಿ ಜ಼ನ ಯೇಸುಚೆ ಮಾಗ್ನಿ ಚಾ಼ಲತ್ ಯಯಿತಿತ. ಲೊಕ ಸಗ್ಳಿ ಆಸಿ ಆರ್ಬಾಟ್ ಕರಿತಿತ: “ದಾವಿದಾಚಾ ಲೇಕಾಲಾ ವವ್ಯಾಳಾ! ‘ಪ್ರಭುಚಾ ನಾವಾನಿ ಯತ್ಯಾಲ್ಯಾಲಾ ದೇವ್ ಆಶಿರ್ವಾದ್ ಕರುನಿ’ ಸ್ವರ್ಗಾತ್‌ಲ್ಯಾ ದೇವಾಲಾ ವವ್ಯಾಳಾ!” ");
INSERT INTO gok_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","ಮಂಗ್ ಯೇಸು ಯೆರುಸಲೇಮಿತ್ ಗೆಲಾ. ಪೆಠ್ಹತ್ ಸಗ್‌ಳ್ಯಾ ಲೊಕಾಂಚಿ ಗವಜಿ ವ್ಹವುನ್. “ಹ್ಯೊ ಮಾನುಸ್ ಕೊನ್? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","ತ್ಯಲಾ ಪ್ರವಾದಿ ಜಾ಼ಲ್ಯಾಲಾ ಯೇಸು ಮನ್ಹುನ್ ಲೊಕಾಂಚಾ಼ ಹಿಂಡ್ ಹಾಕ್ಟಿತಾ, ಹ್ಯೊಸ್ ಯೇಸು. ಹ್ಯೊ ಗಲಿಲಾಯಾತ್ಲೆ ನಜ಼ರೇತ್ ಮಂಥ್ಯಾಲ್ಯಾ ಗಾವಾತ್ಲಾ ಪ್ರವಾದಿ” ಮನ್ಹುನ್ ಉತ್ತರ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","ಯೇಸು ದೇವ್ಳಾಚಾ ಆಂಗ್ನಾತ್ ಗೆಲಾ. ತಿಥ ದೇತ್ಯಾ ಗೆಥ್ಯಾಲ್ಯಾ ಲೊಕಾನಾ ತ್ಯನಿ ಬಾಹಿರ್ ಗ್ಯಾತ್ಲಿತ; ಆನ ಸದಲ್ ಬದಲ್ ಕರ್ತ್ಯಾಲ್ಯಾಂಚಿ ಮೇಜ಼ ಪ್ಯಾಡ್ಲಿತ ಆನಿ ಪ್ಯಾರ್ವ ಇಕ್‌ತ್ಯಾಲ್ಯಾಂಚಾ ಖುರ್ಚಾ ಪ್ಯಾಡ್‌ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","ಯೇಸುನಿ ತಿತಲ್ಯಾ ಲೊಕಾನಾ ಸಗ್‌ಳ್ಯಾ, “ಮಾಜ಼ ಘರ್ ಮಾಗ್ನ ಕರ್ತ್ಯಾಲ ಘರ್’ ಮನ್ಹುನ್ ಗೇನಾರ್. ಆಸ ಪವಿತ್ರ ಪುತೀಕಾತ್ ದೇವಾನಿ ಸಾಂಗ್‌ಲ್ಯಾ. ಫನ್ ತುಮಿ ದೇವಾಚ಼ ಘರ್ ಚೊ಼ರಾಚಿ ಘಬ್ ಕರ್ತ್ಯಾಸಾ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","ಥೊಡ ಜಾ಼ನ್ ಆಂದ್ಳ ಆನಿ ಲಂಗ್ಡ ದೇವ್ಳಾತ್ ಯೇಸುಪ ಆಲ. ಯೇಸುನಿ ತ್ಯನಾ ಬರ ಕೆಲ. ");
INSERT INTO gok_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","ಮುಖ್ಯ ಯಾಜಕ್ ಆನಿ ಧರ್ಮೊಪದೇಶಕಾಂಚಾನಿ ಹ್ಯ ಬಗ್ಲ. ಯೇಸುನಿ ಚಮತ್ಕಾರಾಚಿ ಕಾಮ ಕರ್ತ್ಯಾಲಿ ಆನಿ ದೇವ್ಳಾತ್ ಬಾರಿಕ್ ಪ್ಯೂರ್ಗಿ ಯೇಸುಲಾ ವವ್ಯಾಳ್‌ತ್ಯಾಲಿ ತ್ಯಂಚಾನಿ ಬಗ್ಲಿತ ಬಾರಿಕ್ ಪ್ಯೂರ್ಗಿ, “ದಾವಿದಾಚಾ ಲೇಕಾಲಾ ಸ್ತೊತ್ರ ವ್ಹವುನಿ” ಮನ್ಹುನ್ ವರ್ಡತಿತ. ಮನ್ಹುನ್ ತೇ ರಾಗಾವ ಜಾ಼ಲ. ");
INSERT INTO gok_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ತ್ಯಂಚಾನಿ ಯೇಸುಲಾ, “ಹಿ ಬಾರಿಕ್ ಪ್ಯೂರ್ಗಿ ಸಾಂಗ್‌ತ್ಯಾಲ್ಯಾ ಬೊಲ್ಯಾ ತು ಐಕ್‌ಲ್ಯಾಸ್ ಕ್ಯಾ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ಯೇಸನಿ, “ವ್ಹಯ್, ‘ತು ಬಾರಿಕ್ ಪ್ಯೊರ್ಗ್ಯಾನಾ ತಾನ್ಯಾ ಮುಲಾನಾ ಸ್ತೊತ್ರ ಕರಾಯಾ ಸಿಕಿವ್‌ಲ್ಯಾಸ್’ ಮನ್ಹುನ್ ಪವಿತ್ರ ಪುತೀಕಾತ್ ಸಾಂಗ್‌ಲ್ಯಾ ತುಮಿ ತ್ಯ ವಾಚಿವ್ಲ ನಾಹಿಸಾ ಕ್ಯಾ? ಮನ್ಹುನ್ ಉತ್ತರ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","ಪರತ್ ತ್ಯೊ ಜಾ಼ಗಾ ಸುಡುನ್ ಬೆತಾನಿ ಪೆಠ್ಹತ್ ಗೆಲಾ. ಯೇಸುನಿ ತೀ ರ‍್ಯಾತ್ ತಿಥಸ್ ಗಾಲಿವ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","ದುಸ್ರೆ ದಿಸಿ ಸಕಾಳ್ಚಾ ಯೇಸು ಯೆರುಸಲೇಮ್ ಮಂಥ್ಯಾಲೆ ಪೆಠ್ಹತ್ ಮಾಗಾರಾ ಜಾ಼ಯಿತಾ. ತವಾ ತ್ಯಲಾ ಭುಕ್ ಲಾಗ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","ತ್ಯನಿ ವಾಟಚೆ ಜ಼ವಳ್ ಯಾಕ್ ಅಂಜು಼ರಾಚ಼ ಜಾ಼ಡ್ ಬಗುನ್ ಫಳ ಖಾಯಾ ತ್ಯಚೆ ಜ಼ವಳ್ ಗೆಲಾ ಫನ್ ಜಾ಼ಢಾಲಾ ಪಾನ ತ್ಯವ್ಡಿಸ್ ಹುತ್ತಿತ ಮನ್ಹುನ್ ಯೇಸುನಿ ತ್ಯಾ ಜಾ಼ಢಾಲಾ, “ಹಿತ್ನಿ ಮೊರ‍್ಹ ತುಲಾ ಕವಾಸ್ ಫಳ ಲಾಗು ನಸುನ್ತ! ಮನ್ಲಾ. ತವಾಸ್ ಅಂಜು಼ರಾಚ಼ ಜಾ಼ಡ್ ವಾಳುನ್ ಗೆಲ. ");
INSERT INTO gok_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","ಶಿಶಾ ಹ್ಯ ಬಗುನ್ ಖುಬ್ ಆಜಾಬ್ ಜಾ಼ಲ್ಹ, “ಹ್ಯ ಆಂಜು಼ರಾಚ಼ ಜಾ಼ಡ್ ಯವ್ಡೆ ಬಿಗಿ ಕಸ ವಾಳುನ್ ಗೆಲ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","ಯೇಸುನಿ, “ಮಿ ತುಮಾನಾ ಖರ ಸಾಂಗ್ತೊ. ತುಮಿ ಸಂವಶೆವ್ ಸಸ್ಥಾನಾ ಇಸ್ವಾಸ್ ಥೆವ್ಲಾಸಾತ ಮಿ ಹ್ಯಾ ಅಂಜು಼ರಾಚಾ ಜಾ಼ಢಾಲಾ ಕೆಲ್ಯಾ ಶಾರ್ಕ ತುಮಾನಾ ಕರಾಯಾ ವ್ಹನಾರ್. ಯವ್ಡಸ್ ನವ್ಹ, ತುಮಿ ಹ್ಯಾ ಕನ್ಯಾಲಾ, ‘ತು ಜಾ಼ವುನ್ ಸಮಿಂದೊರಾತ್ ಪಡ್’ ಮನ್ಹುನ್ ಪುರ‍್ಯಾ ಇಸ್ವಾಸಾನಿ ಸಾಂಗ್ಲಸಾತ ತಸಸ್ ವ್ಹನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","ತುಮಿ ಇಸ್ವಾಸಾನಿ, ಮಾಗ್‌ನ್ಯಾತ್ ಕ್ಯಾಬಿ ಮಾಗ್ಲಸಾತ ತುಮಾನಾ ತ್ಯ ಗಾವ್ನಾರ್” ಮನ್ಹುನ್ ಉತ್ತರ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","ಯೇಸು ದೇವ್ಳಾತ್ ಗೆಲಾ. ಯೇಸು ತಿಥ ಸಾಂಗ್‌ತ್ಯಾಲಾ ಆಸ್ಥಾನಾ ಮುಖ್ಯ ಯಾಜಕ್ ಆನಿ ಲೊಕಾಂಚ಼ ಮೊಟ ಜಾಂತ ಯೇಸುಪ ಆಲ, ತೇ ಯೇಸುಲಾ, “ತು ಹ್ಯ ಸಗ್ಳ ಕಸ್‌ಲ್ಯಾ ಹುಕ್ಮಾನಿ ಕರ್ತ್ಯೊಸ್? ಹ್ಯೊ ಹುಕುಮ್ ತುಲಾ ಕುನಿ ದಿಲಾ? ಆಮಾನಾ ಸಾಂಗ್‌” ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","ಯೇಸುನಿ, “ಮಿ ತುಮಾನಾ ಯೇಕ್ ಪ್ರಶ್ನೆ ಇಚಾರ್ತೊ. ತುಮಿ ಮನಾ ಉತ್ತರಾ ದಿಲಾಸಾತ, ಹ್ಯ ಸಗ್ಳ ಕಸ್‌ಲ್ಯಾ ಹಾಕ್ ಕರ್ತ್ಯೊ ಮನ್ಹುನ್ ತುಮಾನಾ ಸಾಂಗ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","ಬಾಪ್ತಿಸ್ಮಾ ದಿಯಾಚಾ಼ ಹುಕುಮ್ ಯೊಹಾನಾಲಾ ದೇವಾಪ್ನಿ ಆಲಾ ಕ್ಯಾ ಮಾನ್ಸಾಪ್ನಿ ಆಲಾ? ಮನಾ ಸಾಂಗಾ! ಮನ್ಲಾ. ಯಾಜಕ್ ಆನಿ ಯೆಹುದ್ಯ ಜಾಂತ ಯೇಸುಚೆ ಪ್ರಶ್ನೆಚೆ ಗುಶ್ಟಿತ್ ಆಪ್‌ಲ್ಯಾತ್, “‘ಯೊಹಾನಾನಿ ದಿಲ್ಯಾಲಾ ಬಾಪ್ತಿಸ್ಮಾ ದೇವಾಪ್ನಿ ಆಲಾ’ ಮನ್‌ಲ್ಹಾವ್ತ, ‘ತಸ ಜಾ಼ಲ್ಹತ ಯೊಹಾನಾವ ತುಮಿ ಕಾ ಇಸ್ವಾಸ್ ಥೆವ್ಲಾ ನಾಹಿಸಾ?’ ಮನ್ಹುನ್ ಇಚಾರಿಲ್. ");
INSERT INTO gok_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","‘ತ್ಯೊ ಮಾನ್ಸಾಪ್ನಿ ಆಲಾ’ ಮನ್ಲಾವ್ತ ಲೊಕ ಸಗ್ಳಿ ಆಮ್ಚಿವ ರಾಗ್ ಕರ್ನಾರ್. ತ್ಯಂಚಾನಿ ಯೊಹಾನಾಲಾ ಯೊಕ್ ಪ್ರವಾದಿ ಮನ್ಹುನ್ ಇಸ್ವಾಸ್ ಥೆವ್‌ಲ್ಯಾ ಮನ್ಹುನ್ ಆಮಿ ತ್ಯನಾ ಭಿಹ್ಯಾ ಪಾಯ್ಜೆ” ಮನ್ಹುನ್ ಬುಲುನ್ ಗೇಥ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","ಮಂಗ್ ತೇ, “ಯೊಹಾನಾಲಾ ಕುಟ್ನಿ ಹುಕುಮ್ ಆಲಾ ಆಮಾನಾ ಠಾವಾ ನಾಹಿ” ಮನ್ಹುನ್ ಉತ್ತರ್ ದೇತ್ಯಾತ. ತವಾ ಯೇಸುನಿ, “ಹ್ಯ ಸಗ್ಳ ಕುಟಲ್ಯಾ ಹುಕ್ಮಾನಿ ಕರ್ತ್ಯೊ ಮನ್ಹುನ್ ಮಿ ಸಾಹಿತ್ ತುಮಾನಾ ಸಾಂಗಿತ್ ನಾಹಿ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“ಆತಾ ತುಮಿ ಕ್ಯಾ ಮಂಥಾಸಾ? ಯಕಾ ಮಾನ್ಸಾಲಾ ದೊಗ ಪ್ಯೊರ್ಗ ಹುತ್ತ. ತ್ಯೊ ಮಾನುಸ್ ಪೈಲ್ಯಾ ಲೇಕಾಪ ಜಾ಼ವುನ್, ‘ಲೇಕಾ ಆಜ಼್ ತು ಜಾ಼ವುನ್ ಮಾಜೆ ದರಾಕ್ಷಿಚಾ ಮಳ್ಯಾತ್ ಕಾಮ್ ಕರ್ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“ತ್ಯಲಾ ಲ್ಯೊಕ್, ‘ಮಿ ಜಾ಼ಯಿತ್ನಾಯಿ’ ಮನ್ಲಾ. ಖರ ತ್ಯೊ ಮಂಗ್ ಆಪ್ಲ ಮನ್ ಪರ್ತುನ್ ಕಾಮಾಲಾ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“ಬಾ ಆನಿ ಯಕಾ ಲೇಕಾಪ ಜಾ಼ವುನ್, ತಸಾಸ್ ಮನ್ಲಾ ಲ್ಯೊಕ್ ಬಾ ಹು ಮಿ ಜಾ಼ವುನ್ ಕಾಮ್ ಕರ್ತೊ ಮನ್ಲಾ ಖರ ತ್ಯೊ ಲ್ಯೊಕ್ ಗೆಲಾಸ್ ನಾಹಿ ");
INSERT INTO gok_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“ಹ್ಯಾ ದೊಗಾತ್‌ಲ್ಯಾ ಕಚಾನಿ ಬಾಚ಼ ಐಕ್ಲ? ತವಾ ಯೆಹುದಿ ಜಾಂತ, “ಆಂದಿಚಾ ಲೇಕಾನಿ” ಮನ್ಲ. ಯೇಸುನಿ ತ್ಯನಾ, “ಮಿ ತುಮಾನಾ ಖರ ತ್ಯ ಸಾಂಗ್ತೊ. ಜ಼ಖತ್ ಗೊಳಾ ಕರ್ತ್ಯಾಲ್ಯಾನಾ ಆನಿ ವ್ಯಬಿಚಾರ್ ಕರ್ತ್ಯಾಲಿ ಬುರ್ಸಿ ಲೊಕ ಮಂಥಾಸಾ. ಫನ್ ತೀ ತುಮ್ಚೆ ಆಂದಿ ದೇವಾಚಾ ರಾಜಾತ್ ಜಾ಼ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","ತುಮಿ ಜ಼ಲ್ಮಾಚಿ ಶಾರ್ಕಿ ವಾಟ್ ದಾವಾಯಾ ಯೊಹಾನ್ ಆಲಾ. ತುಮಿ ತ್ಯಚಿವ ಇಸ್ವಾಸ್ ಥೆವ್ಲಾನಾಹಿಸಾ, ಫನ್ ಜ಼ಖತ್ ಗೊಳಾ ಕರ್ತ್ಯಾಲ ಆನಿ ವ್ಯಬಿಚಾರ್ ತುಮಿ ಬಗ್ಲಸಾ. ಫನ್ ತುಮ್ಚಿ ಮನ ಬದಲಾಯಾ ಆನಿ ತ್ಯಚಿವ ಇಸ್ವಾಸ್ ಥೆವ್ಲಾ ನಾಹಿಸಾ. ");
INSERT INTO gok_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“ಆನಿ ಎಕ್ ಕ್ಯಾಯ್ನಿ ಐಕಾ: ಯಕಾ ಮಾನ್ಸಾಲಾ ಯೇಕ್ ದರಾಕ್ಶಿಚಿ ಬಾಗ್ ಹುತ್ತಿ. ತೆ ಬಾಗಚೆ ಸರ್ಬೌತಿ ಭಿತ್ ಗಾಲ್ಹುನ್ ದರಾಕ್ಶಿಚಾ಼ ರಸ್ ಕಾಡಾಯಾ ಖಡ್ಡಾ ಕೆಲಾ. ರಾಖಾಯಾ ಸಾಟಿ ಮಾಳಾ ಗ್ಯಾತ್ಲಾ. ತ್ಯನಿ ತೀ ಬಾಗ್ ಥೊಡ್ಯಾ ಕಮ್ತವಾಲ್ಯಾನಾ ಖಂಡಾನಿ ದಿವುನ್ ದುರ್ ಗೆಲಾ ");
INSERT INTO gok_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","ದರಾಕ್ಶಿ ಕಾಡಾಚಾ ಯಳಾಲಾ ಆಪ್‌ಲ್ಯಾ ಪಿಕಾಚಿ ವಾಟ್ನಿ ಗಿಯಾ ಜಾ಼ಯಾ ಸೇವಕನಾ ಕಮ್ತವಾಲ್ಯಾಂಚಿಪ ಲಾವುನ್ ದಿಲ. ");
INSERT INTO gok_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“ಫನ್ ಕಮ್ತಕರಿ ತ್ಯಾ ಸೇವಕಾನಾ ದರ‍್ಹುನ್ ಯಕಾಲಾ ಬಡಿವ್ಲಾ; ದುಸ್‌ರ‍್ಯಾ ಯಕಾಲಾ ತುಡುನ್ ಟ್ಯಾಕ್ಲಾ; ತಿನವ್ಯಾ ಸೇವಕಾವ ದೊಂಡ್ಯಾನಿ ಮ್ಯಾರ‍್ಲಾ; ");
INSERT INTO gok_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","ಮನ್ಹುನ್ ತ್ಯನಿ ಆಂದಿ ಲಾವುನ್ ದಿಲ್ಯಾಲ್ಯಾವ್ನಿ ಖುಬ್ ಸೇವಕಾನಾ ಕಮ್ತವಾಲ್ಯಾಂಚಿಪ ಲಾವುನ್ ದಿಲ. ಫನ್ ತ್ಯಂಚಾನಿ ಆಂದಿ ಕೇಲ್ತ ತಸಸ್ ಹ್ಯನಾಬಿ ಕೆಲ. ");
INSERT INTO gok_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","ತವಾ ತ್ಯೊ, ‘ಕಮ್ತದಾರ್ ಮಾಜಾ ಲೇಕಾಲಾ ಮರ‍್ಯಾದ್ ದಿತಿಲ ಮನ್ಹುನ್ ಆಪ್‌ಲ್ಯಾ ಲೇಕಾಲಾ ಲಾವುನ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","ಖರ ಕಮ್ತದಾರ‍್ಯಾಂಚಾನಿ ಲೇಕಾಲಾ ಬಗ್ಲಾ ಆನಿ ಹ್ಯೊ ಮಳ್ಯಾಚಾ ಧನ್ಯಾಚಾ಼ ಲ್ಯೊಕ್. ಹ್ಯೊ ಮಳಾ ಹ್ಯಚಾ಼ ವ್ಹನಾರ್ ಆಮಿ ಹ್ಯಲಾ ಮಾರುನ್ ಟ್ಯಾಕ್‌ಲ್ಯಾವ ಹ್ಯೊ ಮಳಾ ಆಮ್‍ಚಾ಼ಸ್ ವ್ಹನಾರ್ ಮನ್ಹುನ್ ಯಕಾ ಮಕಾಪ ಬೊಲ್‌ತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","ಮನ್ಹುನ್ ಕಮ್ತವಾಲ್ಯಾಂಚಾನಿ ಧನ್ಯಾಚಾ ಲೇಕಾಲಾ ದರ‍್ಹುನ್ ಮಳ್ಯಾತ್ನಿ ಬಾಹಿರ್ ಗಾಲ್ಹುನ್ ತ್ಯಲಾ ಮಾರುನ್ ಟ್ಯಾಕ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","ಆಸ ಯೇಸುನಿ ಇಚಾರ್ಲ, “ಆಸ ಆಸ್ಥಾನಾ ಮಳ್ಯಾಚಾ಼ ದನ್ಹಿ ಆಪ್ನುಸ್ ಆಲಾಕಿ ಹ್ಯಾ ಕಮ್ತದಾರ‍್ಯಾನಾ ಕ್ಯಾ ಕರ್ನಾರ್? ");
INSERT INTO gok_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","ತ್ಯೊ ದನ್ಹಿ ಖರ‍್ಯಾನಿ ತ್ಯಾ ಬುರ್ಸ್ಯಾ ಲೊಕಾನಾ ಮಾರುನ್ ಲಾನಿಚಾ ಯಳಾಲಾ ಆಪ್ಲಿ ವಾಟ್ನಿ ಆಪ್‌ಲ್ಯಾಲಾ ದೇತ್ಯಾಲ್ಯಾ ಕಮ್ತದಾರ‍್ಯಾನಾ ಮಳಾ ಖಂಡಾನಿ ದೇನಾರ್ ಮನ್ಹುನ್ ಸಾಂಗ್‌ತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","ಯೇಸುನಿ ತ್ಯನಾ, “ಖರ‍್ಯಾನಿ ತುಮಿ ಹ್ಯ ಪವಿತ್ರ ಪುತೀಕಾತ್ ವಾಚಿವ್‌ಲ್ಯಾಸಾ” ‘ಘರ್ ಬ್ಯಾಂತ್ಯಾಲ್ಯಾನಿ ನಕೊ ಮನ್ಹುನ್ ಶೊಡ್‌ಲ್ಯಾಲಾ ದೊಂಢಾ ಮುಖ್ಯ ವ್ಹಯಿ ಜಾ಼ಲಾ. ಪ್ರಭುನಿ ಹ್ಯ ಕೆಲ. ಹ್ಯ ಆಮಾನಾ ಆಜಾಬ್ ಜಾ಼ಲ. ");
INSERT INTO gok_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“ಮನ್ಹುನ್ ತುಮಾನಾ ಸಾಂಗಾಚ಼ ಕ್ಯಾ ಮಂಜೆ ದೇವಾಚಾ಼ ರಾಜಾ಼ ತುಮ್ಚಿಪ್ನಿ ಕಾಡುನ್ ಟಾಕುನ್ ತ್ಯಾ ರಾಜಾತ್ ದೇವಾಚಾ ಮನಾ ಶಾರ್ಕ ಕಾಮ್ ಕರ್ತ್ಯಾಲ್ಯಾನಾ ತ್ಯ ದೇನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","ಹ್ಯಾ ದೊಂಡ್ಯಾವ ಪಡ್‌ತ್ಯಾಲಾ ಮಾನುಸ್ ತುಕ್ಡ ತುಕ್ಡ ವ್ಹನಾರ್. ಹ್ಯೊ ದೊಂಡಾ ಮಾನ್ಸಾವ ಪಡ್ಲಾತ ತ್ಯೊ ಜಿಜ್ರು಼ನ್ ಜಾ಼ನ್ಹಾರ್. ” ");
INSERT INTO gok_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","ಮುಖ್ಯ ಯಾಜಕ್ ಆನಿ ಫರಿಸಾಯ್ ಯೇಸುನಿ ಸಾಂಗ್‌ಲ್ಯಾಲ್ಯಾ ಹ್ಯಾ ಕ್ಯಾಯ್‌ನ್ಯಾ ಐಕುನ್, ಆಪ್ಲಸ್ ಹ್ಯ ಸಗ್ಳ ಸಾಂಗ್ಲ ಮನ್ಹುನ್ ಸಮಜು಼ನ್ ಗೇತ್ಲ ");
INSERT INTO gok_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","ತ್ಯಂಚಾನಿ ಯೇಸುಲಾ ದರಾಯಾ ಯತ್ನ ಕಿಲಿತ. ಫನ್ ತೇ ಲೊಕಾನಾ ಬಿಹುನ್ ದರ್ಲಾನಾಹಿ ಕಾ ಮಂಜೆ ಯೇಸು ಯೊಕ್ ಪ್ರವಾದಿ ಮನ್ಹುನ್ ಲೊಕಾಂಚಾನಿ ಇಸ್ವಾಸ್ ಥೆವ್ಲಾ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","ಯೇಸುನಿ ದುಸ್‌ರ‍್ಯಾ ಥೊಡ್ಯಾ ಗುಶ್ಟಿ ಕ್ಯಾಯ್ನಿನಿ ಲೊಕಾನಾ ಸಾಂಗ್‌ಲ್ಯಾ: ");
INSERT INTO gok_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","ಸ್ವರ್ಗಾಚ಼ ರಾಜೆ , ಆಪ್‌ಲ್ಯಾ ಲೇಕಾಚ಼ ಲಗಿನ್ ತಯಾರ್ ಕೆಲ್ಯಾಲ್ಯಾ ಯಕಾ ರಾಜಾಚಿಗತ್ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","ತ್ಯಾ ರಾಜಾನಿ ಥೊಡ್ಯಾ ಲೊಕಾನಾ ಜೆವ್ನಾಲಾ ಹಾಕಟ್ಲಿತ ಜೆವಾನ್ ತಯಾರ್ ಜಾ಼ಲ್ಯಾ ಪರತ್ ರಾಜಾನಿ ಆಪ್‌ಲ್ಯಾ ಸೇವಕಾಂಚಾಪ್ನಿ ತ್ಯಾ ಲೊಕಾನಾ ಸಾಂಗ್ಲ ಫನ್ ತ್ಯನಾ ಯಯಾಲಾ ಮನ್ ನವ್ತ. ");
INSERT INTO gok_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","ಮಂಗ್ ರಾಜಾನಿ ಥೊಡ್ಯಾ ಸೇವಕಾನಾ ಹಾಕ್ಟುನ್, ‘ಹ್ಯಾ ಲೊಕಾನಾ ಮಿ ತವಾಸ್ ಹಾಕಟ್ಲಿತ. ತ್ಯಚಿಸ್ ಲಾಗುನ್ ಆತಾ ಜೆವಾನ್ ತಯಾರ್ ಜಾ಼ಲ್ಯಾ. ಜೆವ್ನಾ ಸಾಟಿ ಮಾತ್‌ಲ್ಯಾಲಾ ಮೆಂಡಾ ಆನಿ ಬಕ್ರ ಮ್ಯಾರ್‌ಲ್ಯಾ. ಸಗ್ಳ ತಯಾರ್ ಜಾ಼ಲ್ಯಾ. ಲಗ್ನಾಚಾ ಜೆವ್ನಾಲಾ ಯಯಾ ತ್ಯನಾ ಸಾಂಗಾ’ ಮನ್ಹುನ್ ಲಾವುನ್ ದಿಲ. ");
INSERT INTO gok_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“ತಸಸ್ ತ್ಯಾ ಸೇವಕಾಂಚಾನಿ ಜಾ಼ವುನ್ ತ್ಯಾ ಲೊಕಾನಾ ಸಾಂಗ್ಲ. ಫನ್ ತ್ಯಂಚಾನಿ ಸೇವಕಾಂಚೆ ಬುಲಿಲಾ ಕಾನ್ ದಿಲಾ ನಾಹಿ. ಯಕ್ಲಾ ಆಪ್‌ಲ್ಯಾ ಸೇತಾತ್ ಕಾಮ್ ಕರಾಯಾ ಗೆಲಾ. ದುಸ್ರಾಯೊಕ್ ಇಕಾಯಾ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ಆನಿ ಥೊಡ ತ್ಯನಾ ಬುರ್ಸ ಕರುನ್ ಸೇವಕಾನಾ ದರ‍್ಹುನ್, ಬಡ್ವುನ್ ಮಾರುನ್ ಟ್ಯಾಕ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","ತವಾ ರಾಜಾ಼ ಖುಬ್ ರಾಗಾನಿ ಆಪ್ಲಿ ಸೈನ್ಯಾ ಲಾವುನ್ ದಿವುನ್ ತ್ಯಾ ಖುನ್ ಕರ್ತ್ಯಾಲ್ಯಾನಾ ಮಾರುನ್ ಟ್ಯಾಕ್ಲ ಆನಿ ತ್ಯಂಚೆ ಪೆಠಲಾ ಜಾ಼ಳುನ್ ಟ್ಯಾಕ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“ಮಂಗ್ ರಾಜಾ಼ ಆಪ್‌ಲ್ಯಾ ಸೇವಕಾನಾ ಲಗ್ನಾಚ಼ ಜೆವಾನ್ ತಯಾರ್ ಜಾ಼ಲ್ಯಾ ಮಿ ಹಾಕಟ್‌ಲ್ಯಾಲಿ ಲೊಕ ಜೆವ್ನಾಲಾ ಯಯಿ ಶಾರ್ಕಿ ಚಾ಼ಂಗ್ಲಿ ನವ್ಥಿತ. ");
INSERT INTO gok_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","ಮನ್ಹುನ್ ಪಾಂದಿಂಚಾ ಕೊನ್ಯಾಕೊನ್ಯಾವ ಜಾ಼ವುನ್ ತುಮಿ ಬಗ್‌ಲ್ಯಾಲ್ಯಾ ಲೊಕಾನಾ ಸಗ್‌ಳ್ಯಾ ಜೆವ್ನಾಲಾ ಹಾಕ್ಟಾ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","ತಸಸ್ ಸೇವಕ್ ಪಾಂದಿಪಾಂದಿತ್ನಿ ಜಾ಼ವುನ್ ಆಪ್ನು ಬಗ್‌ಲ್ಯಾಲಿ ಲೊಕ ಸಗ್ಳಿ ಚಾ಼ಂಗ್ಲಿ ಬುರ್ಸಿ ಮನ್ಹಾಚೆ ಆಂದಿ ಗೊಳಾ ಕರುನ್ ಜೆವಾನ್ ತಯಾರ್ ಜಾ಼ಲ್ಯಾಲ್ಯಾ ಜಾ಼ಗ್ಯಾವ ಹಾಕ್ಟುನ್ ಆನ್ಲಿತ. ತ್ಯೊ ಜಾ಼ಗಾ ಲೊಕಾಂಚಾನಿ ಬರ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“ತವಾ ರಾಜಾ಼ ಲೊಕಾನಾ ಸಗ್‌ಳ್ಯಾ ಬಗಾಯಾ ಆತ್ ಆಲಾ ಲಗ್ನಾಲಾ ಚಾ಼ಂಗ್ಲ ಕಪ್ಡ ಗ್ಯಾತ್‌ಲ್ಯಾ ನಸ್‌ಲ್ಯಾಲಾ ಯಕಾ ಮಾನ್ಸಾಲಾ ರಾಜಾನಿ ಬಗ್ಲಾ ");
INSERT INTO gok_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","ಸೊಪ್‌ತ್ಯಾ ತು ಆತ್ ಕಸಾ ಆಲಾಸ್? ತು ಲಗ್ನಾಲಾ ಚಾ಼ಂಗ್ಲ ಕಪ್ಡ ಗಾಲ್ಹುನ್ ಆಲಾನಾಹಿಸ್ ಮನ್ಲಾ ಖರ ತ್ಯನಿ ಉತ್ತರ್ ದಿಲಾ ನಾಹಿ ");
INSERT INTO gok_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","ತವಾ ರಾಜಾ಼ ಥೊಡ್ಯಾ ಸೇವಕಾನಾ ಹ್ಯಚ಼ ಹಾತ್‌ಪ್ಯಾ ಬಾಂದುನ್ ಬಾಹಿರ್ ಆಂದಾರಾತ್ ಟಾಕಾ ಮನ್ಲಾ ತ್ಯಾಸ್ ರಾಜಾತ್ ಲೊಕ ಲೊಳತ್ ತರಾಸಾನಿ ಆಪ್ಲ ದಾತ್ ಖಾಯಿತಿತ. ");
INSERT INTO gok_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“ವ್ಹಯ್, ಹಾಕಟ್‌ಲ್ಯಾಲಿ ಖುಬ್ ಜಾ಼ಲ್ಹಿತ ತರಿ ನಿವಡ್‌ಲ್ಯಾಲಿ ಥುಡಿಸ್. ” ಯೇಸುನಿ ಆಸ ಸಾಂಗುನ್ ಆಪ್ಲಿ ಕ್ಯಾಯ್ನಿ ಸಪಿವ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","ತವಾ ಫರಿಸಾಯ್, ತಿಥ್ನಿ ನಿಗುನ್ ಜಾ಼ವುನ್ ಯೇಸುಚೆ ಬುಲಿತ್ ಚು಼ಕ್ ದರಾಯಾ ಪಾರ್ಕಿ ಕೆಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","ಫರಿಸಾಯಾಂಚಾನಿ ಥೊಡ್ಯಾನಾ ಲಾವುನ್ ದಿಲ. ತ್ಯಾತ್ಲ ಥೊಡ ಪರಿಸಾಯಾಂಚೆ ಮಾಗ್ನಿ ಜಾ಼ತ್ಯಾಲ ಹುತ್ತ. ಆನಿ ಥೊಡ ಹೆರೊದಾಚಾ ರಾಜ್ಕಿಚಾ ಮೇಳ್ಯಾತ್ಲ ಜಾ಼ಲ್ಥ. ಹಿ ಲೊಕ, “ಮಾಸ್ಥರಾ, ತು ಖರ‍್ಯಾಚಾ಼ ಮನ್ಹುನ್ ಆಮಾನಾ ಠಾವ ಹಾ. ತು ದೇವಾಚಾ ಮಾರ್ಗಾಚ಼ ಖರ ತ್ಯಸ್ ಸಿಕಿವ್ನಾರಾ ಮನ್ಹುನ್ ಆಮಾನಾ ಠಾವಹಾ. ದುಸ್‌ರ‍್ಯಾಂಚಾನಿ ತುಜೆ ಗುಶ್ಟಿತ್ ಕ್ಯಾ ಯವಜ಼್ಲ ತರಿ ತು ಬಿಹಿತ್ನಾಹಿಸ್. ತು ತೊಂಡಾಮಾಗಾರಾ ಕರಿತ್ನಾಹಿಸ್. ");
INSERT INTO gok_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","ಮನ್ಹುನ್ ತುಜ಼ ಮನ್ಹ ಕ್ಯಾ ಸಾಂಗ್. ರೊಮಾಚಾ ರಾಜಾಚಿ ಜ಼ಖತ್ ದಿಯಾಚಿ ಶಾರ್ಕ ಕ್ಯಾ ಚು಼ಕ್? ಮನ್ಹುನ್ ಇಚಾರ್ತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","ಹ್ಯಾ ಲೊಕಾಂಚಿ ಬುರ್ಸಿ ಯವಜ್ನಾ಼ ಯೇಸುಲಾ ಸಮಾಜ್ಲಿ ಹುತ್ತಿ. ಮನ್ಹುನ್ ತ್ಯನಿ, “ತುಮಿ ಕಪ್ಟಿ! ಮನಾ ಚು಼ಕಿತ್ ದರಾಯಾ ಕಾ ಯತ್ನ ಕರ್ತ್ಯಾಸಾ? ");
INSERT INTO gok_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","ಜ಼ಖತಿ ಸಾಟಿ ದೇತ್ಯಾಲಾ ಯೊಕ್ ಆನಾ ಮನಾ ದಾವಾ” ಮನ್ಲಾ. ಲೊಕಾಂಚಾನಿ ಯೊಕ್ ಚಾ಼ಂದಿಚಾ಼ ಆನಾ ತ್ಯಲಾ ದ್ಯಾವ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ತವಾ ತ್ಯನಿ, “ತ್ಯಾ ಆನ್ಯಾವ ಕುನಾಚಾ ತೊಂಡಾಚಾ಼ ಶಿಕಾ ಹಾ ಆನಿ ಕುನಾಚ಼ ನಾವ್ ಹಾ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","ಲೊಕಾಂಚಾನಿ, “ತ್ಯ ರೊಮಾಚಾ ರಾಜಾಚಾ ತೊಂಡಾಚಾ಼ ಶಿಕಾ ಆನಿ ನಾವ್” ಮನ್ಹುನ್ ಉತ್ತರ್ದಿಲಾ. ತವಾ ಯೇಸುನಿ ತ್ಯನಾ, “ರೊಮಾಚಾ ರಾಜಾಚ಼ ರೊಮಾಚಾ ರಾಜಾಲಾ ದೇವಾ; ದೇವಾಚ಼ ದೇವಾಲಾ ದೇವಾ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","ಯೇಸುನಿ ಸಾಂಗ್‌ಲ್ಯಾಲ ಐಕ್‍ಲ್ಯಾಲಿ ತೀ ಲೊಕ ಆಜಾಬ್ ತಿಥ್ನಿ ನಿಗುನ್ಗಿಲಿತ. ");
INSERT INTO gok_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","ತೇಸ್ ದೀಸಿ ಥೊಡ ಸದ್ದುಕಾಯ್ ಯೇಸುಪ ಯವುನ್, ಕುನಾಲಾಸ್ ಮರ್ನಾತ್ನಿ ಉಠುನ್ ಯಯಾ ವ್ಹಯಿತ್ ನಾಹಿ ಮನ್ಹುನ್ ಸದ್ದುಕಾಯಾಂಚಾ಼ ಇಸ್ವಾಸ್. ");
INSERT INTO gok_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“ಮಾಸ್ಥರಾ, ಲಗಿನ್ ಜಾ಼ಲ್ಯಾಲಾ ಪ್ಯೊರ್ಗಿ ವ್ಹಯಾಚೆ ಆಂದಿ ಮೇಲಾತ, ತ್ಯಚೆ ದನ್ಗರಿಲಾ ತ್ಯಚಾ ದಾಕ್‍ಟ್ಯಾ ಬಾವ್ಹಾಲಾ ಲಗಿನ್ ಕರುನ್ ಗಿಹುನ್ ದಾದಾಸಾಟಿ ಪಿಳ್ಗಿ ವ್ಹಯಾವ್ಹಯಿ ಮನ್ಹುನ್ ಮೊಶೆನಿ ಸಾಂಗ್‌ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","ಆಮ್ಚಾತ್ ಸಾತ್ ಜಾ಼ನ್ ಬಾಹು ಹುತ್ತಾವ್. ಪೈಲಾ ಲಗಿನ್ ವ್ಹವುನ್ ಮೆಲಾ. ತ್ಯಲಾ ಪ್ಯೊರ್ಗಿ ನವ್ಥಿತ. ಮನ್ಹುನ್ ತ್ಯಚಾ಼ ದುಸ್ರಾ ಬಾಹು ತ್ಯಚೆ ದನ್ಗರಿಲಾ ಲಗೀನ್ ಜಾ಼ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","ಪರತ್ ದೊನ್ವಾ ಬಾಹುಬಿ ಮೆಲಾ. ಆಸಸ್ ತಿನವ್ಯಾ ಬಾವ್ಹಾಲಾಬಿ ಆನಿ ಸಾತಿ ಬಾವ್ಹಾನಾಬಿ ಜಾ಼ಲ. ");
INSERT INTO gok_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","ಸರ್ತ್ಯಾಲಾ ತೀ ದನ್ಗರ್ಬಿ ಮೀಲಿ. ");
INSERT INTO gok_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","ಫನ್ ಸಾತ್ ಜಾ಼ನ್ಬಿ ತಿಲಾ ಲಗೀನ್ ಜಾ಼ಲ್ಥ. ಆಸ ಆಸ್ಥಾನಾ, ಮರ್ನಾತ್ನಿ ಉಠುನ್ ಯತಾನಾ ತೀ ಕಚಾಚಿ ದನ್ಗರ್ ವ್ಹವುನ್ ರಾನ್ಹಾರ್? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","ಯೇಸುನಿ, “ತುಮಿ ಚು಼ಕುನ್ ಸಮ್ಜುನ್ ಗಿಹ್ಯಾ ಕಾರನ್ ಕ್ಯಾಮಂಝೆ, ಪವಿತ್ರ ಪುತೀಕ್ ಆನಿ ದೇವಾಚ಼ ಬಳ್ ತುಮಾನಾ ಠಾವ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","ಬ್ಯಾಯ್ಕಾ ಆನಿ ಗಡಿ ಮಾನ್ಸ ಮರ್ನಾತ್ನಿ ಉಠುನ್ ಆಲ್ಯಾ ನಂತರ್ ಲಗಿನ್ ಕರುನ್ ಗಿಹಿತ್ ನಾಹಿತ ತೀ ಸಗ್ಳಿ ಸ್ವರ್ಗಾತ್ ದೇವ್ದುತಾಚೆಗತ್ ರಾಥ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","ಮರ್ನಾತ್ನಿ ಉಠುನ್ ಯಯಾಚೆ ಗುಶ್ಟಿತ್, ದೇವಾನಿ ಸಾಂಗ್‌ಲ್ಯಾಲ ತುಮಿ ವಾಚಿವ್ಲ ನಾಹಿಸಾ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘ಮಿ ಅಬ್ರಹಾಮಾಚಾ಼ ಇಸಾಕಾಚಾ಼ ಆನಿ ಯಾಕೊಬಾಚಾ಼ ದೇವ್. ಆಸ ಆಸ್ಥಾನಾ ಜಿತ್ತಿ ಆಸ್ನಾರ‍್ಯಾನಾ ದೇವ್ ಫನ್ ಮೇಲ್ಯಾಲ್ಯಾನಾ ನವ್ಹ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","ಲೊಕಾಂಚಾನಿ ಸಗ್ಳ ಹ್ಯ ಐಕುನ್ ತ್ಯಚಾ ಸಿಕಿವ್‍ನ್ಯಾಲಾ ಆಜಾಬ್ ಜಾ಼ಲ್ಹಿತ. ");
INSERT INTO gok_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","ಸದ್ದುಕಾಯ್ ವಾದ್ ಕರುನಾಹಿ ತಸಾ ಯೇಸುನಿ ಉತ್ತರ್ ದಿಲಾ ಮನ್ಹುನ್ ಫರಿಸಾಯಾನಾ ಸಮ್ಜುನ್ ತೇ ಮಿಳುನ್ ಯೇಸುಪ ಆಲ. ");
INSERT INTO gok_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","ಮೊಶೆಚಾ ಧರ್ಮಶಾಸ್ತಾರಾತ್ ಗಿನ್ಯಾನ್ ಆಸ್‌ಲ್ಯಾಲಾ ಯೊಕ್ ಯವುನ್ ಯೇಸುಲಾ ಪ್ರಶ್ನೆ ಕರಾಯಾ, ");
INSERT INTO gok_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“ಮಾಸ್ಥರಾ, ಧರ್ಮಶಾಸ್ತಾರಾತ್ಲಿ ಮುಟಿ ಆಜ್ಞಾ ಕಚಿ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","ಯೇಸುನಿ, “‘ತುಜಾ಼ ದೇವ್‌ ಜಾ಼ಲ್ಯಾಲ್ಯಾ ಪ್ರಭುಚಿ ಮಾಯಾ ಕರಾಯಾ ವ್ಹಯಿಸ್. ತು ತ್ಯಲಾ ತುಜಾ ಪುರ‍್ಯಾ ಕಾಳ್‍ಜಾ಼ನಿ ಆನಿ ಪುರ‍್ಯಾಜೀವಾನಿ ತುಜಾ ಪುರ‍್ಯಾಮನಾನಿ ಮಾಯಾಕರ್. ");
INSERT INTO gok_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","ಹಿಸ್ ಆಂದಿಚಿ ಆನಿ ವ್ಹಯಿ ಜಾ಼ಲ್ಯಾಲಿ ಆಜ್ಞಾ. ");
INSERT INTO gok_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","ದುನ್ವಿ ಆಜ್ಞೆ ಆಂದಿಚೆ ಆಜ್ಞೆ ಯವ್ಡಿ ವ್ಹಯಿ ಜಾ಼ಲೆ. ‘ತು ತುಜಿ ಮಾಯಾ ಕರ್ತೊಸ್ ತಸಿಸ್ ತುಜಾ ಸೆಜಾರ‍್ಯಾಚಿ ಮಾಯಾ ಕರಾಯಾ ವ್ಹಯಿ’ ಮಂಥ್ಯಾಲಿ ತೀ ಆಜ್ಞಾ. ");
INSERT INTO gok_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","ಪುರ ಧರ್ಮಶಾಸ್ತಾರ್ ಆನಿ ಪ್ರವಾದಿಂಚಿ ಸಗ್ಳಿ ಪುತಿಕ ಹ್ಯಾ ದೊನ್ ಆಜ್ಞಾತ್ನಿ ಹಾತ್ತ” ಮನ್ಹುನ್ ಉತ್ತರ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","ಫರಿಸಾಯ್ ಸಂಗ ಆಲ ತವಾ ಯೇಸುನಿ ತ್ಯನಾ, ");
INSERT INTO gok_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“ಕ್ರಿಸ್ತಾಚೆ ಗುಶ್ಟಿತ್ ತುಮ್ಚಿ ಯವಜ್ನಾ಼ ಕ್ಯಾ? ತ್ಯೊ ಕುನಾಚಾ ವಂವ್ಶಾಚಾ಼ ಲ್ಯೊಕ್? ಮನ್ಹುನ್ ತ್ಯನಾ ಇಚಾರ್ಲ. ಫರಿಸಾಯಾಂಚಾನಿ, “ಕ್ರಿಸ್ತ ದಾವಿದಾಚಾ಼ ಲ್ಯೊಕ್ ಜಾ಼ಲ್ಯಾ ಮನ್ಹುನ್ ಉತ್ತರ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","ತವಾ ಯೇಸುನಿ ಫರಿಸಾಯಾನಾ ತಸ ಜಾ಼ಲ್ಹತ ದಾವಿದಾನಿ ತ್ಯಾಲಾ ‘ಪ್ರಭು’ ಮನ್ಹುನ್ ಕಾ ಹಾಕೊಟೊ ದಾವಿದ್ ಪರಿಶುದ್ದ ಆತ್ಮಾಚಾ ಬಳಾನಿ ಬೊಲ್ಲಾ. ತ್ಯನಿ ಸಾಂಗ್ಲ ಕ್ಯಾಮಂಝೆ: ");
INSERT INTO gok_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘ಪ್ರಭು ಮಾಜಾ ಪ್ರಭುಲಾ ಮನ್‍ಲ್ಹಾ, ಮಿ ತುಜಾ ವಾದಿನಾ ತುಜಾ ಪಾಯಾತ್ ಗಾಲಿಪರತ್ ಮಾಜೆ ಉಜ್‍ವ್ಯಾಂಗ್ನಿ ಬಸುನ್ ರ‍್ಹಾ’ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","ದಾವಿದಾನಿ ಕ್ರಿಸ್ತಾಲಾ ಪ್ರಭು ಮನ್ಹುನ್ ಹಾಕಟ್‌ಲ್ಯಾವ ತ್ಯೊ ದಾವಿದಾಚಾ ಲ್ಯೊಕ್ ಕಸ ವ್ಹನಾರ್? ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","ಯೇಸುಚೆ ಪ್ರಶ್ನೆಲಾ ಜ಼ಬಾಬ್ ದಿಯಾ ಕುನಾಲಾಸ್ ಜಾ಼ಲ್ಹಾನಾಹಿ ತೇ ಠ್ಯಾವ್ನಿ ಯೇಸುಚಾ಼ ಮೊಸ್ ಕರಾಯಾ ಪ್ರಶ್ನೆ ಇಚಾರಾಲಾ ಕುನಿಸ್ ಧೀರ್ ಕೆಲಾ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","ಮಂಗ್ ಯೇಸುನಿ ಜ಼ಮಲ್ಯಾಲ್ಯಾ ಲೊಕಾನಾ ಆನಿ ಆಪ್‌ಲ್ಯಾ ಶಿಶಾನಾ ಕ್ಯಾ ಸಾಂಗ್ಲ ಮಂಜೆ: ");
INSERT INTO gok_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“ಮೊಶೆಚ಼ ಧರ್ಮಶಾಸ್ತಾರ್ ಸಾಂಗ್‌ತ್ಯಾಲ ತುಮಾನಾ ಸಾಂಗಾಯಾ ಧರ್ಮೊಪದೇಶಾಕಾನಾ ಆನಿ ಫರಿಸಾಯಾನಾ ಹುಕುಮ್‌ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","ಮನ್ಹುನ್ ತುಮಿ ತ್ಯಂಚ಼ ಸಬ್ದ ಐಕಾಯಾ ವ್ಹಯಿಸಾ ಆನಿ ತ್ಯಂಚಾನಿ ಸಾಂಗ್‌ಲ್ಯಾಲ್ಯಾಚೆಗತ್ ಚಾ಼ಲಾಯಾ ವ್ಹಯಿಸಾ, ಫನ್ ತ್ಯಂಚಾ ಜೀವ್ನಾಂಚೆಗತ್ ಚಾ಼ಲಾಯಾ ವ್ಹಯಿಜೊ಼ಗ ಆಸ್ಲಾ ಚಾ಼ಂಗ್ಲಾ ಜೀವ್ನಾ ತೆಂಚಾ಼ ನವ್ಹ ತೇ ತುಮಾನಾ ಸಾಂಗ್‌ತ್ಯಾಲ್ಯಾ ಗುಶ್ಟಿಂಚೆಗತ್ ಆಪ್ನುಸ್ ಚಾ಼ಲತ್ ನಾಹಿತ. ");
INSERT INTO gok_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","ತೇ ದುಸ್‌ರ‍್ಯಾನಾ ತರಾಸಾಚ಼ ನೇಮ್ ದಿವುನ್ ತ್ಯಂಚಿಗತ್ ಚಾ಼ಲ್ಹಾ ಮನ್ಹುನ್ ಬಳ್ ಕರ್ತ್ಯಾತ. ಆಪ್ನು ತರಿ ತ್ಯಾ ನೆಮಾತ್ಲ ಯಕಾಚಿಗತ್ಬಿ ಚಾ಼ಲಾಯಾ ಖಟಪಟ್‌ ಕರೀತ್ ನಾಹಿತ. ");
INSERT INTO gok_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“ಆಪ್‌ಲ್ಯಾಲಾ ದುಸ್ರಿ ಲೊಕ ಬಗುಂತ ಮನ್ಯಾ ಸಾಟಿಸ್ ತೇ ಚಾ಼ಂಗ್ಲಿ ಕಾಮ ಕರ್ತ್ಯಾತ. ವಚನಾನಿ ಬರ್ಲ್ಯಾಲ್ಯಾ ಮೊಟ್ಯಾ ಚ಼ಮ್‌ಡ್ಯಾಚಾ ತ್ಯಾಯತ್ಯಾ ಬಾಂದುನ್ ರಾಥ್ಯಾತ ತೇ ಹಿ ಚಿಲ ಆನಿಕ್ ಖುಬ್ ಖುಬ್ ಮುಟಿ ಕರ್ತ್ಯಾತ. ಲೊಕ ಬಗುಂತ ಮನ್ಹುನ್ ತೇ ಖುಬ್ ಮಾಗ್ನ ಕರ್ತ್ಯಾಲ ಕಪ್ಡ ಆನಿಕ್ ಲಾಮ್ ಕರ್ತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","ತೇ ಫರಿಸಾಯ್ ಆನಿ ದರ್ಮೊಪದೆಶಕ್ ಜೆವ್ನಾಚಾ ಜಾ಼ಗ್ಯಾವ ಆನಿ ಸಭಾಸ್ಥಾನಾತ್ ಚಾ಼ಂಗ್ಲಾ ಜಾ಼ಗಾ ಬಗ್‌ತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","ಬಾಜಾ಼ರಾತ್ ಲೊಕ ಆಪ್‌ಲ್ಯಾಲಾ ಮರ‍್ಯಾದ್ ದಿಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಮನ್ ಕರ್ತ್ಯಾತ; ಲೊಕಾಂಚಿಪ್ನಿ ಬುದ್ ಸಾಂಗ್‌ತ್ಯಾಲ ಮನ್ಹುನ್ ಗಿಹ್ಯಾ ಮನ್‌ ಕರ್ತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“ಫನ್ ತುಮಿ ಕುನಾಲಾ ಮಾಸ್ಥರ್ ನಕೊಸಾ ತುಮಿ ಸಗ್ಳಿ ಭನ್ಹಿ ಬಾಹು. ತುಮಾನಾ ಯಕ್ಲಾಸ್ ಮಾಸ್ಥರ್. ");
INSERT INTO gok_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","ಹ್ಯಾ ದುನಿಯಾತ್ ಕುನಾಲಾಸ್ ಬಾ ಮನ್ಹುನ್ ಹಾಕ್ಟು ನಕೊಸಾ ತುಮಾನಾ ಯಕ್ಲಾಸ್ ಬಾ ತ್ಯೊ ಸ್ವರ್ಗಾತ್ ಹಾ ");
INSERT INTO gok_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","ಜಾಂತಾ ಮನ್ಹುನ್ ಹಾಕ್ಟುನ್ ಗಿಹು ನಕೊಸಾ ತುಮಾನಾ ಕ್ರಿಸ್ತುಸ್ ಜಾಂತಾ. ");
INSERT INTO gok_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","ಸೇವಕಾಚೆಗತ್ ತುಮಾನಾ ಸೇವಾ ಕರ್ತ್ಯಾಲಾ ತುಮ್ಚಿಪ ಖುಬ್ ಮೊಟಾ ಜಾ಼ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","ಆಪ್ನು ದಿಸರ‍್ಯಾಂಚಿವ್ನಿ ಚಾ಼ಂಗ್ಲಾ ಮನ್ಹುನ್ ಗೆಥ್ಯಾಲಾ ಖಾಲ್‍ಚಾ಼ ವ್ಹನಾರ್, ಆಪ್ನು ನ್ಹಾನ್ ವ್ಹತ್ಯಾಲಾ ತ್ಯೊ ವರ್ ಯನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","ಧರ್ಮೊಪದೇಶಕಾನು, ಫರಿಸಾಯಾನು, ತುಮ್ಚಿ ಪರಸ್ಥಿತಿ ಕ್ಯಾ ಸಾಂಗು! ತುಮಿ ಕಪ್ಟಿ. ಲೊಕ ಸ್ವರ್ಗಾಚಾ ರಾಜಾತ್ ಜಾ಼ತ್ಯಾಲಿ ವಾಟ್ ತುಮಿ ಜಾಕ್ತಾಸಾ. ತುಮಿ ಜಾ಼ಯಿತ್ನಾಹಿಸಾ ಆನಿ ಜಾ಼ತ್ಯಾಲ್ಯಾನಾಬಿ ಆನಿ ಮನ್ ಕರ್ತ್ಯಾಲ್ಯಾ ಲೋಕಾನಾಬಿ ಸುಡಿತ್ ನಾಹಿಸಾ!. ");
INSERT INTO gok_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","ಧರ್ಮೊಪದೇಶಕಾಂಚಾನನು ಆನಿ ಫರಿಸಾಯಾನು ತುಮಾನಾ ಬುರ್ಸ ವ್ಹನಾರ್ ತುಮಿ ಕಪ್ಟಿ. ತುಮಿ ವಿದ್ವಾಂಚಿ ಗರ‍್ಹ ಕಾಡುನ್ ಗೆಥಾಸಾ ಲೊಕ ತುಮಾನಾ ಬಗುಂತ ಮನ್ಹುನ್ ಲಾಂಬ್ಡಿ ಮಾಗ್ನಿ ಕರ್ತಾಸಾ ತ್ಯಚಿಸ್ ಲಾಗುನ್ ತುಮಾನಾ ಮುಟಿ ಶಿಕ್ಷಾ ವ್ಹನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“ಧರ್ಮೊಪದೇಶಕಾನು, ಫರಿಸಾಯಾನು, ತುಮ್ಚಿ ಗತ್ ಕ್ಯಾ ಸಾಂಗು! ತುಮಿ ಕಪ್ಟಿ. ತುಮ್ಚೆ ವಾಟನಿ ಯತ್ಯಾಲಾ ಯಕ್‍ಲ್ಯಾಲಾ ಬಗಾಯಾ ತುಮಿ ಸಮೀಂದ್ವಾರ್ ವಲ್ಯಾಂಡುನ್ ದುಸ್ರೆ ದುಸ್ರೆ ದೇಶೆತ್ನಿ ಯಕಾಲಾ ಶೊತಾಸಾ ತ್ಯೊ ಗಾವಲ್ಯಾ ನಂತರ್ ತುಮ್ಚಿವ್ನಿ ದೊನ್ ಪಟ್ ಬುರ್ಸಾ ಕರ್ತಾಸಾ. ತುಮಿ ನರ್ಕಾತ್ ಪಡ ಜೊ಼ಗಿ ಬುರ್ಸಿ ಜಾ಼ಲ್ಯಾಸಾ. ");
INSERT INTO gok_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","ಧರ್ಮೊಪದೇಶಕಾನು, ಫರಿಸಾಯಾನು, ತುಮ್ಚಿ ಪರಸ್ಥಿತಿ ಕ್ಯಾ ಸಾಂಗು! ತುಮಿ ಲೊಕಾನಾ ಸಿಕಿವ್ತಾಸಾ. ಖರ ತುಮಿಸ್ ಆಂದ್ಳ ಯಕಾನಿ ದೇವ್ಳಾವ ಶೆಪ್ಪತ್ ದಿಲಿತ ತ್ಯಲಾ ಕ್ಯಾ ಕಿಮ್ಮತ್ ನಾಹಿ ಮನ್ತಾಸಾ. ಫನ್ ಯಕಾನಿ ದೇವ್ಳಾತ್‍ಲ್ಯಾ ಸೊನ್ಯಾವ ಶೆಪ್ಪತ್ ಗ್ಯಾತ್ಲಿತ ತೀ ತ್ಯನಿ ಚಾ಼ಲ್ವಾಯಾ ವ್ಹಯಿ ಮಂಥಾಸಾ. ");
INSERT INTO gok_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","ತುಮಿ ಆಂದ್ಳ ಆಸ್‌ಲ್ಯಾಲ ಹುಚ್ಚ ಕುಟ್ಲ ಜಾಸ್ಥಿ? ಸೊನ ಕ್ಯಾ ದಿವುಳ್? ತ್ಯ ಸೊನ ಚಾ಼ಂಗ್ಲ ಜಾ಼ಲ್ಯಾಲ ದೇವ್ಳಾನಿಸ್. ಮನ್ಹುನ್ ದಿವುಳ್ ಮೊಟ. ");
INSERT INTO gok_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","ಯಕಾನಿ ಯಜ್ಞವೇದಿವ ಶೆಪ್ಪತ್ ಥಿವ್ಲಿತ ತ್ಯಲಾ ಕ್ಯಾ ಕಿಮ್ಮತ್ ನಾಹಿ ಮಂಥಾಸಾ ಫನ್ ಯಕಾನಿ ಯಜ್ಞೆವ್ಲೆ ದಿನ್ಗಿವ ಶೆಪ್ಪತ್ ದಿಲಿತ ತ್ಯನಿ ತ್ಯ ಫೆಡಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಸಾಂಗ್ತಾಸಾ. ");
INSERT INTO gok_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","ತುಮಿ ಆಂದ್ಳ. ತುಮಾನಾ ಕಾಯ್ ಸಮ್ಜತ್ ನಾಹಿ ಕಚ಼ ಜಾಸ್ಥಿ? ದೆನ್ಗಿ ಕ್ಯಾ ಯಜ್ಞೆ ವೇದಿ? ದೆನ್ಗಿ ಚಾ಼ಂಗ್ಲಿ ಕೆಲೆ ತ್ಯಸ್ ಮೊಟ. ");
INSERT INTO gok_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","ಯಜ್ಞವೇದಿವ ಶೆಪ್ಪತ್ ದೇತ್ಯಾಲಾ ಯಜ್ಞವೇದಿವ ಆನಿ ತ್ಯಚೆ ವರ್ ಆಸ್‌ಲ್ಯಾಲೆ ದಿನ್ಗಿವ ಶೆಪ್ಪತ್ ದಿಲ್ಯಾಚೆಗತ್ ಜಾ಼ಲ. ");
INSERT INTO gok_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","ದೇವ್ಳಾವ ಶೆಪ್ಪತ್ ದೇತ್ಯಾಲಾ ಖರ‍್ಯಾನಿಸ್ ದೇವ್ಳಾಚೆ ಆನಿ ತ್ಯಚೆ ಆತ್ ಆಸ್‌ಲ್ಯಾಲ್ಯಾವ ಶೆಪ್ಪತ್ ದಿಲ್ಯಾಚೆಗತ್ ಜಾ಼ಲ. ");
INSERT INTO gok_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","ಸ್ವರ್ಗಾವ ಶೆಪ್ಪತ್ ದಿಲ್ಯಾಲ್ಯಾನಿ ದೇವಾಚೆ ಸಿಂಹಾಸನಾವ ತೇ ಸಿಂಹಾಸನಾವ ಬಸ್‌ಲ್ಯಾಲ್ಯಾವ ಶೆಪ್ಪತ್ ದಿಲ್ಯಾಚೆಗತ್ ಜಾ಼ಲ. ");
INSERT INTO gok_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“ಧರ್ಮೊಪದೇಶಕಾನು, ಫರಿಸಾಯಾನು, ತುಮ್ಚಿ ಗತ್ ಕ್ಯಾ ಸಾಂಗು! ತುಮಿ ಕಪ್ಟಿ. ತುಮ್ಚಿಪ ಆಸ್‌ಲ್ಯಾಲ ಪರತೇಕ್ ಯಕಾತ್ಲ ತುಮ್ಚಾ ಪುದಿನಾ, ಬಾಜಿಚಾ಼ ಪಾಲಾ, ಜಿರ‍್ಯಾಚಾ ಡಾಳ್ಯಾತ್ನಿಬಿ ಧಾತ್ಲಾ ಯೊಕ್ ವಾಟಾ ದೇವಾಲಾ ದೇತಾಸಾ ಫನ್ ಧರ್ಮಶಾಸ್ತಾರಾತ್‌ಲ್ಯಾ ಸಿಕಿವ್‍ನ್ಯಾತ್ಲ ಖರ‍್ಯಾನಿಸ್ ವ್ಹಯಿ ಜಾ಼ಲ್ಯಾಲ್ಯಾ ಆಜ್ಞಾ ಮಂಜೆ ನ್ಯಾಯಿ ಕರ್ನಾರ್ ಖರ ತುಮಿ ಶೊಡ್‌ಲ್ಯಾಸಾ ಹ್ಯಾ ಸಬ್ದಾಂಚೆಗತ್ ಆಂದಿ ತುಮಿ ಚಾ಼ಲಾ ಅತ್ತಾ ಕರೀತ್ ಆಸ್‌ಲ್ಯಾಲಿ ಕಾಮ ಕರಾಯಾ ವ್ಹಯಿತಿತ. ");
INSERT INTO gok_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","ತುಮಿ ಲೊಕಾನಾ ಸಿಕಿವ್ತಾಸಾ. ಫನ್ ತುಮಿಸ್ ಆಂದ್ಳ! ಯಕಾನಿ ಪಿತ್ಯಾಲ್ಯಾ ಪಾನ್ಯಾತ್ನಿ ಬಾರಿಕ್ ಡೊಖಳ್ ಗಾಳುನ್ ತ್ಯಾ ಪರತ್ ಹೂಟ್ ಗಿಳತ್ಯಾಲ್ಯಾಚೆಗತ್ ತುಮಿ ಹಾಸಾ. ");
INSERT INTO gok_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","ಧರ್ಮೊಪದೇಶಕಾನು, ಫರಿಸಾಯಾನು, ತುಮ್ಚಿ ಗತ್ ಕ್ಯಾ ಸಾಂಗು! ತುಮಿ ಕಪ್ಟಿ. ತುಮಿ ತುಮ್ಚಿ ಐದಾನ ಬಾಹಿರ‍್ನಿ ದುಹುನ್ ಚಾ಼ಂಗ್ಲಿ ಕರ್ತಾಸಾ ಫನ್ ತುಮಿ ತರಾಸ್ ಆನಿ ಸ್ವಾರ್ಥಾನಿ ಬರ್ಲ್ಯಾಸಾ. ");
INSERT INTO gok_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","ಫರಿಸಾಯಾನು ತುಮಿ ಆಂದ್ಳ! ಆಂದಿ ಲೊಟಾ ಆತ್ನಿ ಚಾ಼ಂಗ್ಲಿ ಕರಾ. ತವಾ ಲೊಟಾ ಬಾಹಿರ‍್ನಿ ಚಾ಼ಂಗ್ಲ ವ್ಹಯಿಲ್. ");
INSERT INTO gok_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“ಧರ್ಮೊಪದೇಶಕಾನು, ಫರಿಸಾಯಾನು, ತುಮ್ಚಿ ಗತ್ ಕ್ಯಾ ಸಾಂಗು! ತುಮಿ ಕಪ್ಟಿ ತುಮಿ ಚು಼ನ್ನಾ ಲ್ಯಾವ್‌ಲ್ಯಾಲ್ಯಾ ಥಡ್ಯಾಂಚಿಗತ್ ಹಾಸಾ. ತ್ಯಾ ಥಡ್ಯಾಂಚಿಗತ್ ಬಾಹಿರ‍್ನಿ ಚಾ಼ಂಗ್ಲ ದಿಸ್ತಾಸಾ. ಫನ್ ಆತ್ ಮೇಲ್ಯಾಲ್ಯಾಂಚಾ ಹಡಾನಿ ಸಗ್ಳೆ ತರಚಾ ಬುರ್ಶಾನಿ ಬರ‍್ಹುನ್ ರಾಥ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","ತುಮಿ ತಸಿಸ್ ಹಾಸಾ. ತುಮಾನಾ ಬಗ್‌ಲ್ಯಾಲಿ ಲೊಕ ತುಮಿ ಚಾ಼ಂಗ್ಲಿ ಮಂಥ್ಯಾತ ಖರ ತುಮಿ ಧರ್ಮಾಚೆ ಅಡ್ವ ಆನಿ ಆತ್ ಕಪ್ಟಾನಿ ಆನಿ ಬುರ್ಶಾ ಫನಾನಿ ಬರ್‌ಲ್ಯಾಸಾ. ");
INSERT INTO gok_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","ಧರ್ಮೊಪದೇಶಕಾನು, ಫರಿಸಾಯಾನು, ತುಮ್ಚಿ ಗತ್ ಕ್ಯಾ ಸಾಂಗು! ತುಮಿ ಕಪ್ಟಿ. ತುಮಿ ಪ್ರವಾದಿಂಚಿ ಥಡಿ ಬ್ಯಾಂತಾಸಾ. ಚಾ಼ಂಗಲ್ಯಾನಾ ಜೀವ್ನಾ ಕರೀತ್ ನಸ್‌ಲ್ಯಾಲ್ಯಾ ಥಡ್ಯಾನಾ ಸೊಭಾ ಕರ್ತಾಸಾ. ");
INSERT INTO gok_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","‘ಆಮ್ಚಾ ವಡ್ಲಾಂಚಾ ಕಾಲಾತ್ ಆಮಿ ಆಸ್ಥಾವ್ತ ಹ್ಯಾ ಪ್ರವಾದಿನಾ ಮಾರುನ್ ಟಾಕಾಯಾ ತ್ಯನಾ ಮಜ಼ತ್ ಕರೀತ್ ನವ್ಥಾವ್ ಮನ್ಹುನ್ ಸಾಂಗ್ತಾಸಾ. ");
INSERT INTO gok_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","ತ್ಯಾ ಪ್ರವಾದಿನಾ ಮಾರುನ್ ಟ್ಯಾಕ್‌ಲ್ಯಾಲ್ಯಾಂಚಾ಼ ವಂವ್ಶಾ ತುಮಿಸ್ ಮನ್ಹಾಯಾ ಹೀಸ್ ವಳಕ್ ಜಾ಼ಲೆ. ");
INSERT INTO gok_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","ತುಮ್ಚಾ ವಡ್ಲಾಂಚಾನಿ ಚಾ಼ಲು ಕೆಲ್ಯಾಲಿ ತೀ ಪಾಪ ತುಮಿ ಪುರ್ನ ಕರಾ! ");
INSERT INTO gok_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“ತುಮಿ ಸಾಪ್! ತುಮಿ ಇಸಾಚಾ ಸಾಪಾಂಚಾ ವಂವ್ಶಾತ್ಲ ತುಮಿ ದೇವಾಪ್ನಿ ಚು಼ಕುನ್ ಜಾ಼ನ್ಹಾರ್ ನಾಹಿಸಾ ತುಮಿ ಸಗ್ಳ ಚು಼ಕ್ ಕೆಲ್ಯಾಲ ಮನ್ಹುನ್ ನರ್ಕಾಚಿ ಶಿಕ್ಷಾ ಕಸಿ ಚು಼ಕಿವ್ನಾರ್! ");
INSERT INTO gok_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","ಮಿ ತುಮಾನಾ ಸಾಂಗಾಚ಼ ಕ್ಯಾ ಮಂಜೆ ತುಮ್ಚಿಪ ಪ್ರವಾದಿನಾ ಜ್ಞಾನಿನಾ ಸಿಕಿವ್ನಾರ‍್ಯಾನಾ ಲಾವುನ್ ದೇತೊ. ತುಮಿ ತ್ಯಾತ್‌ಲ್ಯಾ ಥೊಡ್ಯಾನಾ ಮಾರುನ್ ಟ್ಯಾಕ್ನಾರ್; ಆನಿ ಥೊಡ್ಯಾನಾ ಶಿಲ್ಬೆವ ಗ್ಯಾಲ್ನಾರ್; ದುಸ್‌ರ‍್ಯಾ ಥೊಡ್ಯಾನಾ ತುಮ್ಚಾ ಸಭಾಸ್ಥಾನಾತ್ ಬಡಿವ್ನಾರ್; ತುಮಿ ತ್ಯನಾ ಗಾವಾತ್ನಿ ಗಾವಾತ್ ಪಾಠಿ ಲಾಗ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","“ಮನ್ಹುನ್ ದರ್ಥಿವ ಮಾರುನ್ ಟ್ಯಾಕ್‌ಲ್ಯಾಲ ಸಗ್‌ಳ್ಯಾ ಸಾಚಿ ಮಾನ್ಸಾನ್ಸಾ ಖುನ್ ಕೆಲ್ಯಾಲೆ ಚು಼ಕಿತ್ ತುಮಿ ಗಾವ್ನಾರ್. ಸಾಚಿ ಜಾ಼ಲ್ಯಾಲ್ಯಾ ಹೆಬೆಲಾ ದರ್ನಿ ಬರಕಿಯಾಚಾ಼ ಲ್ಯೊಕ್ ಜಕರಿಯಾಲಾ ಮಾರುನ್ ಟ್ಯಾಕ್‌ಲ್ಯಾಲಿ ಚು಼ಕಿಚಿ ಶಿಕ್ಷಾ ತುಮ್ಚಿವ ಯನಾರ್. ಜಕರಿಯಾಲಾ ದೇವ್ಳಾಚೆ ಆನಿ ಯಜ್ಞವೇದಿಚೆ ಮದ್ದಿ ಮಾರುನ್ ಟ್ಯಾಕ್ಲಾ ");
INSERT INTO gok_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","ಮಿ ತುಮಾನಾ ಖರ ಸಾಂಗ್ತೊ. ಹ್ಯಾ ಕಾಲಾತ್ ಜೀವ್ನಾ ಕರ್ತ್ಯಾಲ್ಯಾ ಹ್ಯಾ ವಂವ್ಶಾವ ಸಗ್ಳಿ ಶಿಕ್ಷಾ ಯನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“ಯೇರುಸಲೇಮೆ, ಯೇರುಸಲೇಮೆ! ಪ್ರವಾದಿನಾ ಮಾರುನ್ ಟ್ಯಾಕ್‌ತ್ಯಾಲೆ, ದೇವಾನಿ ತುಜೆ ಜ಼ವಳ್ ಲಾವುನ್ ದಿಲ್ಯಾಲ್ಯಾ ಲೊಕಾನಾ ದೊಂಡ್ಯಾಂಚಾನಿ ಮಾರುನ್ ಟ್ಯಾಕ್‌ಲ್ಯಾಲೆ, ಖುಬ್ ಖೆಪಾ ತುಜಾ ಲೊಕಾನಾ ಮಿ ಮಜ಼ತ್ ಕರಾಯಾ ವ್ಹಯಿ ಮನ್ಲೊ. ಕುಂಬ್ಡಿ ಆಪ್‌ಲ್ಯಾ ಪಿಲ್ಯಾನಾ ಪಖಾತ್ ಗೆಥ್ಯಾಚೆಗತ್ ತುಜಾ ಲೊಕಾನಾ ಗಿಹ್ಯಾ ಮನಾ ಮನ್ ಹುತ್ತ. ಫನ್ ತು ವಪ್ಲಿ ನಾಹಿಸ್. ");
INSERT INTO gok_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","ಆತಾ ತುಜ಼ ದಿವುಳ್ ಲೊಕ ಸಗ್ಳಿ ಜಾ಼ವುನ್ ಪಡ್ಸಾರ್ ಪಡ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","ಮಿ ತುಲಾ ಸಾಂಗಾಚ಼ ಕ್ಯಾ ಮಂಜೆ ಪ್ರಭುಚಾ ನಾವಾನಿ ಯತ್ಯಾಲ್ಯಾಲಾ ದೇವ್ ಆಶಿರ್ವಾದ್ ಕರುನಿ ಮನ್ಹುನ್ ತು ಸಾಂಗೀ ಪರತ್ ಮನಾ ಬಗ್ನಾರುಸ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","ಯೇಸು ದೇವ್ಳಾತ್ನಿ ಜಾ಼ತಾನಾ ತ್ಯಚ಼ ಶಿಶಾ ದಿವುಳ್ ಬ್ಯಾಂದ್‌ಲ್ಯಾಲ ದಾವಾಯಾ ತ್ಯಚಿಪ ಆಲ. ");
INSERT INTO gok_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","ತವಾ ಯೇಸುನಿ “ಹ್ಯ ಬ್ಯಾಂದ್‌ಲ್ಯಾಲ ಸಗ್ಳ ಬಗ್‌ತ್ಯಾಸಾಕ್ಯಾ? ಮಿ ತುಮಾನಾ ಖರ ಸಾಂಗ್ತೊ ಹ್ಯ ಸಗ್ಳ ಹಾಳ್ ವ್ಹನಾರ್. ಹಿತ್ತ ದೊಂಡ್ಯಾವ ದೊಂಢ ರಾಹ್ಯಾಚೆ ಆಂದಿ ಸಗ್ಳ ದೊಂಢ ಪ್ಯಾಡ್ನಾರ್” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","ನಂತರ್ ಯೇಸು ಆಲಿವ್ ಗುಢ್ಯಾವ ಬಸ್ಲಾ ತವಾ ಶಿಶಾ ಯಗ್ಳುನ್ ಯೇಸುಚೆ ಜ಼ವಳ್ ಯವುನ್, “ಹ್ಯ ಸಗ್ಳ ಕವಾ ವ್ಹನಾರ್! ತು ಹೆ ದುನೆತ್ ಆನಿ ಯಂಗ್ದಾ ಯತಾನಾ ಆನಿ ದುನೆಚಾ಼ ಸರ್ತಾ ಯೊಳ್ ಆಲಾಕಿ ವಳಕ್ ದಾವಾಯಾ ಕ್ಯಾ ಗಡ್ನಾರ್? ಮನ್ಹುನ್ ಆಮಾನಾ ಸಾಂಗ್‌” ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","ಯೇಸುನಿ ತ್ಯನಾ ದಿಲ್ಯಾಲಾ ಉತ್ತರ್ ಹ್ಯೊ: “ಹುಶಾರಿನಿ ರಾವ್ಹಾ! ತುಮಾನಾ ಫಸವಾಯಾ ಕುನಾಲಾಸ್ ಅವಕಾಸ್ ದಿವುನಕೊಸಾ. ");
INSERT INTO gok_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","ಖುಬ್ ಲೊಕ ಮಾಜಾ ನಾವಾನಿ ಯವುನ್, ‘ಮೀಸ್ ಕ್ರಿಸ್ತ’ ಮನ್ಹುನ್ ಸಾಂಗುನ್ ಖುಬ್ ಜ಼ನಾನಾ ಫಸಿವ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","ತುಮ್ಚೆ ಜ಼ವಳ್ ಚಾ಼ಲತ್ಯಾಲೆ ಲಡಾಯಿಚಾ಼ ಆವಾಜ಼್ ದುರ್ ಚಾ಼ಲತ್ಯಾಲೆ ಲಡಾಯಿಚಿ ಬಾತ್ನಿ ತುಮಿ ಐಕ್ನಾರ್ ಫನ್ ಭಿಹು ನಕೊಸಾ ಸರ್ತಿ ಯೇಳ್ ಯಯಾಚೆ ಆಂದಿ ಹ್ಯ ಸಗ್ಳ ವ್ಹಯಾ ವ್ಹಯಿ ");
INSERT INTO gok_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","ಲೊಕ ದುಸ್‌ರ‍್ಯಾ ಲೊಕಾಂಚೆ ಆಡ್ವಿ ಲಡಾಯಿ ಕರ್ತ್ಯಾತ ರಾಜ ದುಸ್‌ರ‍್ಯಾ ದುಸ್‍ರ‍್ಯಾ ರಾಜಾಂಚಿವ ಲಡಾಯಿ ಕರ್ತ್ಯಾತ. ಬರ್ಗಾಲ್ ಯನಾರ್. ದುಸ್‌ರ‍್ಯಾ ದುಸ್‌ರ‍್ಯಾ ಜಾ಼ಗ್ಯಾವ ಭುಕಂಪ್ ವ್ಹನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","ಹೆ ಸಗ್ಳ ಬಾಳತ್ ಫನಾಚ಼ ಪೈಲ್ಯಾನಿ ಯಾಗ್ ಚಾಲು ಜಾ಼ಲ್ಯಾಲ ತ್ಯವ್ಡಸ್. ");
INSERT INTO gok_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“ತವಾ ಲೊಕ ತುಮಾನಾ ತರಾಸ್ ದಿವುನ್, ಮರ್ನಾಚಿ ಚು಼ಕ್ ದಿಯಾ ಅಧಿಕಾರಿಂಚಾ ತಾಬ್ಯಾತ್ ದೇನಾರ್ ಸಗ್ಳಿ ರಾಶ ಟ್ರ ತುಮ್ಚಿ ದ್ವೆಶ್ ಕರ್ತಿಲ. ತುಮಿ ಮಾಜಿವ ಇಸ್ವಾಸ್ ಥೆವ್‌ಲ್ಯಾಸಾ ಮನ್ಹುನ್ ಹ್ಯ ಸಗ್ಳ ತುಮಾನಾ ವ್ಹನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","ತ್ಯಾ ಯಳಾತ್ ಖುಬ್ ಇಸ್ವಾಸಿ ಲೊಕ ಆಪ್ಲಾ ಇಸ್ವಾಸ್ ಸಾಂಡುನ್ ಗೇನಾರ್. ನಂತರ್ ಇಸ್ವಾಸ್ ಘಾತ್ ಕರ್ತ್ಯಾತ ತೀ ಯಕಾಮಕಾಲಾ ಆಡ್ವಿ ಪರ್ತುನ್ ಯಕಾಮಕಾವ ರಾಗ್ ಥೆವ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","ಖುಬ್ ಲಬಾಡ್ ಪ್ರವಾದಿ ಯವುನ್ ಖುಬ್ ಲೊಕಾನಾ ಫಸಿವ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","ದುನೆತ್ ಧರ್ಮಾಚೆ ಅಡ್ವ ಚಾ಼ಲಾಚ಼ ಖುಬ್ ಜಾ಼ಲ್ಹ ಮನ್ಹುನ್, ಇಸ್ವಾಸಿ ಲೊಕಾಂಚಿ ಮಾಯಾ ದಡುನ್ ಜಾ಼ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","ಫನ್ ಸರ್ತ್ಯಾ ದಿಸಾ ಪರೆತ್ ಘಟ್ ಉಬಾರಾಥ್ಯಾಲ್ಯಾಚಿ ರಕ್ಷನ್ ವ್ಹನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","ದೇವಾಚಾ ರಾಜಾಚಿ ಚಾ಼ಂಗ್ಲಿ ಖಬರ್ ದುನೆತ್‌ಲ್ಯಾ ಸಗ್‌ಳ್ಯಾ ಲೊಕಾನಾ ಸಾಕ್ಶಿ ವ್ಹನಾರ್. ತವಾ ಸರ್ತಾದಿಸ್ ಯನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“ಖುಬ್ ಹಾಳ್ ವ್ಹಯಾ ಕಾರನ್ ಜಾ಼ಲ್ಯಾಲ್ಯಾ ಯಕಾ ಜಿನ್ಸಾಚ಼ ಪ್ರವಾದಿ ದಾನಿಯೆಲಾನಿ ಸಾಂಗ್‍ಲ್ಯಾ. ಹ್ಯೊ ಬುರ್ಸಾ ಜಿನೊಸ್ ದೇವ್ಳಾಚಾ ಪರಿಶುದ್ದ ಜಾ಼ಗ್ಯಾತ್ ಉಬ ರಾಯಲ್ಯಾಲ ತುಮಿ ಬಗ್ನಾರ್ ಹ್ಯ ವಾಚಿವ್‌ತ್ಯಾಲಾ ಹ್ಯ ಸಮ್ಜುನ್ ಗಿಹುನಿ. ");
INSERT INTO gok_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ತ್ಯಾ ಯಳಾಲಾ ಯುದಾಯಾತ್ ರಾಥ್ಯಾಲಿ ಲೊಕ ಕನ್ಯಾವ ಪಳುನ್ ಜಾ಼ವುಂತ. ");
INSERT INTO gok_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","ಗರ‍್ಹಾಚೆ ಮಾಳಿವ ಆಸ್‌ಲ್ಯಾಲಾ ಉತ್ರುನ್ ಆಪ್ಲಿ ಸಾಮ್ನ ಗರ‍್ಹಾತ್ನಿ ಗಿಹ್ಯಾಚೆ ಆಂದಿ ಪಳುನ್ ಜಾ಼ಯಾ ತ್ಯಚಿಪ ಯೊಳ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","ಶೇತಾತ್ ಆಸ್ನಾರಾ ಆಪ್ಲಿ ವೈಲಿ ಆಂಗಿ ಗಿಹ್ಯಾ ಗರ‍್ಹಾತ್ ಪರ್ತುನ್ ಯವು ನಸುನಿ. ");
INSERT INTO gok_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","“ತ್ಯಾ ಯಳಾಲಾ ಗರ್ವಾರ್ನಿನಾ ಥಾನ್ ಪ್ಯಾಸ್‌ತ್ಯಾಲ್ಯಾ ಬ್ಯಾಯ್ಕಾನಾ ಕಸ್ಲಾ ತರಾಸ್! ");
INSERT INTO gok_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","ತುಮಿ ಪಳುನ್ ಜಾ಼ಯಾ ವ್ಹಯಿ ಜಾ಼ಲ್ಯಾಲಾ ಹ್ಯೊ ಯೊಳ್ ಥಂಡಿಚಾ ದಿಸಾತ್ ವ್ಹವುನಿ ಆರಾಮಾಚಾ ದಿಸಾದಿಸಿ ವ್ಹವುನಿ ಯವುನಾಹಿ ಮನ್ಹುನ್ ದೇವಾಪ ಮಾಗ್ನ ಕರಾ. ");
INSERT INTO gok_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","ಕಾ ಮಂಜೆ ತ್ಯಾ ಯಳಾಲಾ ಮೊಟಾ ತರಾಸ್ ರಾನ್ಹಾರ್. ದುನಿಯಾ ಉತ್ಪತ್ತಿ ಜಾ಼ಲಿ ತೆ ದರ್ನಿ ಆಸ್ಲಾ ತರಾಸ್ ಕವಾಸ್ ಜಾ಼ಲಾ ನಾಹಿ. ಹಿತ್ನಿ ಮೊರ‍್ಹಬಿ ವ್ಹನಾರ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","ಫನ್ ದೇವಾನಿ ಮೊಟಾ ತ್ಯೊ ಯೊಳ್ ಕಮ್ಮಿ ಕರಾಯಾ ಥರಿವ್‍ಲ್ಯಾ. ನಾಹಿತ, ಜೀವಾನಿ ರಾಹ್ಯಾ ಕುನಾಲಾಸ್ ವ್ಹನಾರ್ ನಾಹಿ. ಆಪ್ನು ನಿವ್ಡುನ್ ಗೇತ್‌ಲ್ಯಾಲ್ಯಾ ಲೊಕಾಂಚಾ ದೇವಾನಿ ತ್ಯೊ ಯೊಳ್ ಕಮ್ಮಿ ಕೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“ತ್ಯಾ ಯಳಾತ್ ಥುಡಿಜ಼ನ ತುಮಾನಾ, ‘ಬಗಾ, ಕ್ರಿಸ್ತ್ ತಿಥ ಹಾ! ಮನ್ಹುನ್ ಸಾಂಗ್ತಿಲ. ನಾಹಿತ ದುಸ್ರಾ ಯೊಕ್. ತ್ಯೊ ಹಿತ್ತ ಹಾ! ಮನ್ಹುನ್ ಸಾಂಗಿಲ್ ಖರ ತ್ಯಂಚಿವ ಇಸ್ವಾಸ್ ಥಿವುನಕೊಸಾ. ");
INSERT INTO gok_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","ಲಬಾಡ್ ಕ್ರಿಸ್ತ್ ಆನಿ ಲಬಾಡ್ ಪ್ರವಾದಿ ಯವುನ್, ಜಾ಼ಲ್ಹತ ದೇವಾನಿ ನಿವ್ಡುನ್ ಗೇತ್‌ಲ್ಯಾಲ್ಯಾ ಲೊಕಾನಾ ಫಸ್ವಾಯಾ ಸಾಟಿ ಮುಟಿ ಮುಟಿ ಕಾಮ ಆನಿ ಚಮತ್ಕರಾಚಿ ಕಾಮ ಕರ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","ಬಗಾ, ತ್ಯ ಘಢಾಚೆ ಆಂದಿ ಮಿ ತ್ಯಂಚೆ ಗುಶ್ಟಿತ್ ತುಮಾನಾ ಹುಶಾರ್ಕಿ ದಿಲ್ಲೆ. ");
INSERT INTO gok_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“‘ಕ್ರಿಸ್ತ್ ರಾನಾತ್ ಹಾ!’ ಮನ್ಹುನ್ ಥೊಡ್ಯಾಂಚಾನಿ ಸಾಂಗ್ಲತ ರಾನಾತ್ ಜಾ಼ವುನಕೋಸಾ. ‘ತ್ಯೊ ತ್ಯಾ ಸೋಪ್ಯಾತ್ ಬರ್ಲ್ಯಾ!’ ಮನ್ಹುನ್ ಸಾಂಗ್ಲತ ತ್ಯಚಿವ ಇಸ್ವಾಸ್ ಥಿವುನಕೊಸಾ. ");
INSERT INTO gok_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","ಮಾನ್ಸಾಚಾ಼ ಲ್ಯೊಕ್ ಲೊಕಾನಾ. ಪಾಟ್‌ಕ್ಯಾನ್ ಈಜ಼್ ಕಸಿ ಯತಿ ತಸ ಉಗಾವತ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","ಮಡ ಕುಠ ಆಸ್ಥ ತಿಥ ಗಿದ್ಡ ಆಸ್‌ಥ್ಯಾತ ಮನ್ಹುನ್ ತುಮಾನಾ ಠಾವ ಹಾ ತಸಸ್ ಮಾಜ಼ ಯನ ರಾನ್ಹಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","ಹ್ಯ ಜಾ಼ಲ್ಯಾ ಬರ್ಬರ್, “ತ್ಯಾ ದಿಸಾಚ಼ ತರಾಸ್ ಸಪ್‌ಲ್ಯಾ ಬರ್ಬರ್, ‘ದೀಸ್ ಆಂದಾರ್ ವ್ಹನಾರ್. ಚಾ಼ಂದಾಚಾ಼ ಉಜಿಡ್ ನಾಹಿ ವ್ಹನಾರ್ ಚಾನ್ಯಾ ಆಬ್ಳಾತ್ನಿ ನಿಖ್ಳುನ್ ಪಡ್ನಾರ್ ಆಬ್ಳಾಚಿ ಬಳ ಹಲ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“ತವಾ ಮಾನ್ಸಾಚಾ ಲೇಕಾಚಾ ಯನ್ಯಾಚಿ ವಳಕ್ ಆಬ್ಳಾತ್ ದಿಸ್ನಾರ್ ದುನೆತ್ಲಿ ಕುಳ ಸಗ್ಳಿ ಭಿಹುನ್ ರಡತ್ಯಾತ. ಆಬ್ಳಾತ್ ಡಘಾವ್ನಿ ತ್ಯೊ ಯತ್ಯಾಲಾ ಲೊಕ ಸಗ್ಳಿ ಬಗ್ನಾರ್ ತ್ಯೊ ಬಳಾನಿ ಮಹಿಮೆನಿ ಯನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","ಮೊಟ್ಯಾ ಸಬ್ದಾನಿ ತುತ್ತುರಿಚಾ ಆವಾಜಾ಼ನಿ ಮಾನ್ಸಾಚಾ಼ ಲ್ಯೊಕ್ ಆಪ್‌ಲ್ಯಾ ಧುತಾನಾ ಧರ್ತಿವ ಸಗ್ಳಿಕ್ಡ ಲಾವುನ್ ದೇನಾರ್. ತ್ಯನಿ ನಿವ್ಡುನ್ ಗೆತಲ್ಯಾಲ್ಯಾನಾ ದೇವ್ ದುತ್ ಧರ್ಥಿವ ಸಗ್ಳಿಕ್ನಿ ಯಕಿಕ್ಡ ಕರ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“ಅಂಜು಼ರಾಚ಼ ಝಾ಼ಡ್ ಆಮಾನಾ ಯೊಕ್ ಪಾಟಾ ಸಿಕಿವ್ತ. ಅಂಜು಼ರಾಚಾ ಜಾ಼ಢಾಚಾ ಡಾಳ್ಯಾ ಹಿರ್‌ವ್ಯಾ ಕವ್‌ಳ್ಯಾ ವ್ಹವುನ್ ನವಿ ಪಾನ ಯತಾನಾ, ಉನಾಳಾ ಜ಼ವಳ್ ಆಲಾ ಮನ್ಹುನ್ ತುಮಿ ಸಮಜು಼ನ್ ಗೆಥಾಸಾ. ");
INSERT INTO gok_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","ಹ್ಯಾ ಗುಶ್ಟಿ ಸಗ್‌ಳ್ಯಾ ವ್ಹತ್ಯಾಲ್ಯಾ ತುಮಿ ಬಗ್ತಾನಾ, ಮಾನ್ಸಾಚಾ಼ ಲ್ಯೊಕ್ ಯತ್ಯಲಾ ಯೊಳ್ ಜ಼ವಳ್ ಆಲ್ಯಾ ಮನ್ಹುನ್. ");
INSERT INTO gok_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","ಮಿ ತುಮಾನಾ ಖರ ಸಾಂಗ್ತೊ ಆತಾಚಿ ಲೊಕ ಆಜು಼ನ್ ಜಿತ್ತಿ ಆಸ್ಥಾನಾಸ್ ಹ್ಯಾ ಸಗ್‌ಳ್ಯಾ ಗುಶ್ಟಿ ವ್ಹನಾರ್! ");
INSERT INTO gok_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","ದರ್ಥಿ ಆಬಾಳ್ ಹಾಳ್ ವ್ಹನಾರ್, ಖರ ಮಿ ಸಾಂಗ್‌ತ್ಯಾಲಿ ಬುಲಿ ಕವಾಸ್ ಹಾಳ್ ವ್ಹನಾರುಸ್ ನಾಹಿ!. ");
INSERT INTO gok_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“ತ್ಯೊ ದೀಸ್ ನಾಹಿತ ತ್ಯೊ ಯೊಳ್ ಕವಾ ಯನಾರ್ ಮನ್ಹುನ್ ಕುನಾಲಾಸ್ ಸಮಾಜ್ನಾರ್ ನಾಹಿ. ದೇವಾಚಾ ಲೇಕಾಲಾಬಿ ಆನಿ ಸ್ವರ್ಗಾತ್ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ದೇವ್ದುತಾನಾಬಿ ಠಾವಾ ನಾಹಿ. ಬಾ ದೇವಾಲಾ ತ್ಯವ್ಡಾಸ್ ಠಾವಾ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","“ನೊಹಾಚಾ ದಿಸಾತ್ ಜಾ಼ಲ್ಯಾ ಶಾರ್ಕ ಮಾನ್ಸಾಚಾ಼ ಲ್ಯೊಕ್ ಯತಾನಾ ವ್ಹನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","ಪಾನಿ ಯವುನ್ ಸಗಳ ಗಯಿಪ್ ಕರಾಚೆ ಆಂದಿ ಲೊಕ ಖಾಯಿತಿತ ಪಿಯಿತಿತ, ಲಗ್ನ ವ್ಹಯಿತಿತ ಆನಿ ಆಪ್‌ಲ್ಯಾ ಪೊರಾಂಚಿ ಲಗ್ನ ಕರಿತಿತ. ನೊಹಾ, ವ್ಹಡಿತ್ ಜಾ಼ಯಿ ಪರತ್ ಲೊಕ ತ್ಯ ಸಗ್ಳ ಕರೀತುಸ್ ಹುತ್ತಿತ. ");
INSERT INTO gok_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","ಕ್ಯಾ ವ್ಹತ್ಯಾ ಮನ್ಹುನ್ ತ್ಯನಾ ಸಮಾಜ಼್ಲ ನಾಹಿ. ಪಾನಿ ಯವುನ್ ಲೊಕಾನಾ ಸಗ್‌ಳ್ಯಾ ನಾಸ್ ಕಿಲಿತ “ಮಾನ್ಸಾಚಾ಼ ಲ್ಯೊಕ್ ಯತಾನಾಬಿ ತಸಸ್ ವ್ಹನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","ಸೇತಾತ್ ದೊಗ ಕಾಮ್ ಕರ್ತಾನಾ ಯಕಾಲಾ ವರ್ ನೆನ್ಹಾರ್ ಆನಿ ಯಕಾಲಾ ಖಾಲ್ ಶೊಡ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","ದುಗಿ ಬ್ಯಾಯ್ಕಾ ದಾನ ದಳ್ತಾನಾ ಯಕಿಲಾ ವರ್ ನೆನ್ಹಾರ್ ಆನಿ ಯಕಿಲಾ ಖಾಲ್ ಶೊಡ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","ತುಮಚಾ಼ ಪ್ರಭು ಯಯಾಚಾ಼ ದೀಸ್ ತುಮಾನಾ ಸಮಾಜ್ನಾ಼ರ್ ನಾಹಿ. ಮನ್ಹುನ್ ಕವಾಬಿ ತಯಾರ್ ರಾವ್ಹಾ. ");
INSERT INTO gok_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","ಹ್ಯ ಯದತ್ ಗೇವ್ಹಾ ಚೊ಼ರ್ ಕವ್ವಾ ಯನಾರ್ ಮನ್ಹುನ್ ಗರ‍್ಹಾಚಾ ದನ್ಯಾಲಾ ಸಮಾಜ಼ಲ್ಯಾವ ತ್ಯೊ ಜಾ಼ಗಾ ರಾಹುನ್ ಚೊ಼ರಾಲಾ ಘರ್ ಚು಼ರು ದಿಯಿತ್ ನವ್ಥಾ. ");
INSERT INTO gok_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","ಮನ್ಹುನ್ ತುಮಿಬಿ ತಯಾರ್ ರಾವ್ಹಾ ತುಮಿ ಯವಜ಼ಲ್ಯಾ ನಸ್‌ಲ್ಯಾಲ್ಯಾ ಯಳಾಲಾ ಮಾನ್ಸಾಚಾ಼ ಲ್ಯೊಕ್ ಯನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“ಗಿನ್ಯಾನ್ ಆಸ್‌ಲ್ಯಾಲಾ ಇಸ್ವಾಸಾಚಾ಼ ಸೇವಕ್ ಕೊನ್? ದುಸ್‌ರ‍್ಯಾ ಸೇವಕಾನಾ ಜೆವಾನ್ ವ್ಹಯಿ ಜಾ಼ಲ್ಯಾಲ್ಯಾ ಯಳಾಲಾ ದಿಯಾ ದನ್ಹಿ ಕಚಾ ಸೇವಕಾವ ಇಸ್ವಾಸ್ ಥೆವ್ತೊ ತ್ಯೊಸ್. ");
INSERT INTO gok_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","ಆಪ್‌ಲ್ಯಾಲಾ ದಿಲ್ಯಾಲ ಕಾಮ್ ಸೇವಕ್ ಕರ್ತಾ ಆಸ್ಥಾನಾ ತ್ಯಚಾ಼ ದನ್ಯಾನಿ ಯವುನ್ ಬಗ್‌ಲ್ಯಾವ ತ್ಯಲಾ ಸಂತೊಸ್ ವ್ಹತ್ತೊ ಆನಿ ದನ್ಯಾಲಾಬಿ ಸಂತೊಸ್ ವ್ಹತೊ. ");
INSERT INTO gok_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","ಮಿ ತುಮಾನಾ ಖರ‍ ಸಾಂಗ್ತೊ. ತ್ಯೊ ದನಿ ಆಪ್ಲೆ ಸರ್ವೆ ಆಸ್ಥಿಚಾ಼ ಇಚಾರ್ ಕರಾಯಾ ತ್ಯಾ ಸೇವಕಾಲಾ ಥರುವುನ್ ಥೆವ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","“ಫನ್ ಸೇವಕ್ ಬುರ್ಸಾ ಜಾ಼ಲ್ಯಾವ ಆನಿ ಆಪ್ಲಾ ದನ್ಹಿ ಬಿಗಿನಿ ಮಾಗಾರಾ ಪರ್ತುನ್ ಯನಾರ್ ನಾಹಿ ಮನ್ಹುನ್ ಯವಜ಼ಲ್ಯಾವ ತ್ಯಲಾ ಕ್ಯಾ ವ್ಹತ್ತ? ");
INSERT INTO gok_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ತ್ಯೊ ಸೇವಕ್ ದುಸ್‌ರ‍್ಯಾ ಸೆವಕಾನಾ ಬಡ್ವಿತ್ ಆಪ್ಲಿ ಶಾರ್ಕ್ಯಾ ಲೊಕಾಂಚಿ ಸಂಗ್ ಮಿಳುನ್ ಖಾಯಿತ್ ಪಿಯಿತ್ ರಾನ್ಹಾರ್ ");
INSERT INTO gok_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ಆಸ ತ್ಯೊ ತ್ಯಚಿ ವಾಟ್ ಬಗಿ ನಸ್‍ಥ್ಯಾಲ್ಯಾ ಯಳಾಲಾ ತ್ಯೊ ಯನಾರ್ ಆನಿ ತ್ಯೊ ಕವಾ ಯನಾರ್ ಮನ್ಹುನ್ ತ್ಯಲಾ ಠಾವ ನವ್ಥ. ");
INSERT INTO gok_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ತ್ಯಲಾ ಮಾರುನ್ ಶಿಕ್ಷಾ ದಿವುನ್ ಕಪ್ಟಿ ಲೊಕಾಂಚಾ ಜಾ಼ಗ್ಯಾವ ಡಖಲ್ನಾರ್ ತಿತ್ತ ಲೊಕ ತರಾಸಾನಿ ರಡತ್ ಆಪ್ಲ ದಾತ್ ಚಾ಼ವಿತ್ ರಾನ್ಹಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","ತ್ಯಾ ದೀಸಾತ್ ಸ್ವರ್ಗಾಚ಼ ರಾಜೆ ಕಸ ರಾನ್ಹಾರ್ ಮನ್ಹಾಯಾ ಹಿ ಕ್ಯಾಯ್ನಿ ವಳಕ್ ಜಾ಼ಲೆ. ಧಾ ಜ಼ನಿ ಕನ್ಯಾ ಆಪ್ಲ ದಿವ ಗಿಹುನ್ ನವರ‍್ಯಾಪ ಜಾ಼ಯಾ ಗೆಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","ತ್ಯಂಚಾತ್ ಪಾಚ಼್ ಜ಼ನಿ ಬುದ್ದಿ ನಸ್ನಾರ‍್ಯಾ ಹುತ್ಯಾ. ಆನಿಕ್ ರಾಯ್‌ಲ್ಯಾಲ್ಯಾ ಪಾಚ಼್ ಜ಼ನಿ ಶಾನ್ಯಾ ಹುತ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","ಬುದ್ದಿ ನಸ್‌ಲ್ಯಾಲ್ಯಾ ಕನ್ಯಾ ಆಪ್ಲ ದಿವ ಗಿಹುನ್ ಆಲ್ಯಾ ಫನ್ ಆಗಾವ ತ್ಯಾಲ್ ಗೆತ್ಲ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","ಶಾನ್ಯಾಂಚಾನಿ ದಿವ್ಯಾ ಸಂಗ ಆಗಾವ ಡಬ್ಯಾತ್ ವ್ಹಯಿ ತ್ಯವ್ಡ ತ್ಯಾಲ್ ಗೇತ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","ನವ್ರಾ ಯಯಾಚಾ಼ ತಡಾ ಜಾ಼ಲಾ ಆನಿ. ತೀ ಸಗ್ಳಿ ಪುರೊ ವ್ಹವುನ್ ನಿಜ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“ಆರ್ದೆರ‍್ಯಾಚಾ಼, ‘ನವ್ರಾ ಯಯಾಲಾಗ್‌ಲ್ಯಾ! ಯವಾ, ತ್ಯಲಾ ಭೇಠಾ!’ ಮನ್ಹುನ್ ಕುನಿ ಯಕಾನಿ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","ತವಾ ಕನ್ಯಾ ಸಗ್‌ಳ್ಯಾ ಜಾ಼ಗ್ಯಾ ವ್ಹವುನ್ ಆಪ್ಲ ದಿವ ತಯಾರ್ ಕೆಲ. ");
INSERT INTO gok_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","ಬುದ್ದಿ ನಸ್ನಾರ‍್ಯಾ ಕನ್ಯಾಂಚಾನಿ ಶಾನ್ಯಾ ಕನ್ಯಾಂಚಿಪ, ‘ತುಮ್ಚಾ ತೇಲಾತ್ಲ ಥೊಡ ತ್ಯಾಲ್ ಆಮಾನಾ ದೇವಾ. ಆಮ್ಚಾ ದಿವ್ಯಾತ್ಲ ತ್ಯಾಲ್ ಸಗ್ಳ ಸಪ್ಲ’ ಮನ್‌ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“ಶಾನ್ಯಾ, ‘ನಾಹಿ! ಆಮ್ಚಿಪ ಆಸ್‌ಲ್ಯಾಲ ತ್ಯಾಲ್ ತುಮಾನಾಬಿ ಆಮಾನಾಬಿ ಪಾವ್ನಾರ್ ನಾಹಿ. ಆಂಗ್ಡಿತ್ ಜಾ಼ವುನ್ ಗೆವ್ಹಾ’ ಮನ್‌ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“ತವಾ ಪಾಚ್‌ ಜ಼ನಿ ಬುದ್ದಿ ನಸ್ನಾರ‍್ಯಾ ಕನ್ಯಾ ತ್ಯಾಲ್ ಗಿಹ್ಯಾಲಾ ಗೆಲ್ಯಾ ತ್ಯಾ ಜಾ಼ತಾನಾ ನವರ‍್ಹಾ ಆಲ್ಲಾ ತಯಾರ್ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ಕನ್ಯಾ ಲಗ್ನಾಚಾ ನವ್ಹರ‍್ಯಾ ಸಂಗ ಜೆವ್ನಾಲಾಗೆಲ್ಯಾ ತವಾ ದಾರ್ ಜಾಕ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","ಮಂಗ್ ಬುದ್ದಿ ನಸ್ನಾರ‍್ಯಾ ಕನ್ಯಾ ಯವುನ್, ‘ಸ್ವಾಮಿ, ಸ್ವಾಮಿ, ಆತ್ ಯಯಾಲಾ ಆಮಾನಾ ದಾರ್ ಉಗಡ್’ ಮನ್‌ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“ಫನ್ ನವರ‍್ಹಾ, ‘ಮಿ ತುಮಾನಾ ಖರ ಸಾಂಗ್ತೊ. ತುಮಿ ಕೊನ್ ತ್ಯಾ ಮನಾ ಠಾವ್ಯಾ ನಾಹಿಸಾ’ ಮನ್‍ಲ್ಹಾ. ");
INSERT INTO gok_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“ಮನ್ಹುನ್ ಕವಾಬಿ ತಯಾರ್ ರಾವ್ಹಾ. ಮಾನ್ಸಾಚಾ಼ ಲ್ಯೊಕ್ ಯತ್ಯಾಲಾ ದೀಸ್ ವ್ಹವುನಿ ಯೊಳ್ ವ್ಹವುನಿ ತುಮಾನಾ ಠಾವ ನಾಹಿ. ಯೇಸುನಿ ಹ್ಯ ಸಾಂಗುನ್ ಸಪಿವ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“ಸ್ವರ್ಗಾಚ಼ ರಾಜೆ ಆಸ ಹಾ, ಆಪ್ಲ ಘರ್ ಸುಡುನ್ ದುಸ್ರಾ ಜಾ಼ಗಾ ಬಗಾಯಾ ಜಾ಼ತ್ಯಾಲ್ಯಾ ಯಕಾ ಮಾನ್ಸಾಚೆಗತ್ ಹಾ. ತ್ಯೊ ಮಾನುಸ್ ಆಪ್ನು ಜಾ಼ಯಾಚೆ ಆಂದಿ ಆಪ್‌ಲ್ಯಾ ಸೇವಕಾಂಚೆ ಸಂಗ ಬುಲುನ್, ಆಪ್ಲಿ ಆಸ್ಥಿ ಬಗಾಯಾ ತ್ಯನಾ ಸಾಂಗ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","ತ್ಯೊ ತ್ಯಾ ಸೇವಕಾಂಚಾ ಕಾಮಾಚಾ ಬಳಾಜೊ಼ಗ ತ್ಯನಿ ಯಕಾ ಸೇವಕಾಲಾ ಪಾಚ಼್ ಹಾಜಾ಼ರ್ ಸೊನ್ಯಾಚ಼ ಅನ ಆನಿ ಯಕಾಲಾ ದೊನ್ ಹಾಜ಼ರ್. ತಿನವ್ಯಾ ಸೇವಕಾಲಾ ಯೇಕ್ ಹಾಜಾ಼ರ್ ಆನ ದಿಲ್ಲ. ಮಂಗ್ ತ್ಯೊ ದುಸ್‌ರ‍್ಯಾ ಜಾ಼ಗ್ಯಾವ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","ಪಾಚ಼್ ಹಾಜಾ಼ರ್ ಸೊನ್ಯಾಚ಼ ಆನ ಗೆತಲ್ಯಾಲ್ಯಾ ಸೇವಕಾನಿ ತವಾಸ್ ಜಾ಼ವುನ್ ತೆ ಆನ ಯವಾರಾಲಾ ಗಾಲ್ಹುನ್ ಆನೀಕ್ ಪಾಚ಼್ ಹಾಜಾ಼ರ್ ಸೊನ್ಯಾಚ಼ ಆನ ಮಿಳಿವ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","ತಸಸ್ ದೊನ್ ಹಾಜಾ಼ರ್ ಸೊನ್ಯಾಚ಼ ಆನ ಗೇತ್‌ಲ್ಯಾಲ್ಯಾ ಸೇವಕಾನಿಬಿ ತೇ ಆನ ಯವಾರಾತ್ ಗಾಲ್ಹುನ್ ಆನಿ ದೊನ್ ಹಾಜಾ಼ರ್ ಸೊನ್ಯಾಚ಼ ಆನ ಮಿಳಿವ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","ಫನ್ ಯೇಕ್ ಹಾಜಾ಼ರ್ ಸೊನ್ಯಾಚ಼ ಆನ ಗೇತಲ್ಯಾಲಾ ನಿಗುನ್ ಜಾ಼ವುನ್ ಜಿಮ್ನಿತ್ ಯೊಕ್ ಖಢಾ ಮಾರುನ್ ತ್ಯಾ ದನ್ಯಾಚ಼ ಆನ ಚು಼ರುನ್ ಥೇವ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","ಖುಬ್ ದಿಸಾ ನಂತರ್ ದನ್ಹಿ ಗರ‍್ಹಾತ್ ಯವುನ್ ಆಪ್ನು ದಿಲ್ಯಾಲ್ಯಾ ಆನ್ಯಾಂಚಾ಼ ಸೇವಕನಾ ಲೇಖಾ ಇಚಾರ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","ಪಾಚ಼್ ಹಾಜಾ಼ರ್ ಸೊನ್ಯಾಚ಼ ಆನ ಗೇತ್‍ಲ್ಯಾಲ್ಯಾ ಸೇವಕಾನಿ ಆನಿಕ್ ಪಾಚ಼್ ಹಾಜಾ಼ರ್ ಸೊನ್ಯಾಚ಼ ಆನ ಆಪ್‍ಲ್ಯಾ ದನ್ಯಾಪ ಆನುನ್ ಧನ್ಯಾ ಪಾಚ಼್ ಹಾಜಾ಼ರ್ ಸೊನ್ಯಾಚ಼ ಆನ ದಿಲಸ್ ಮಿ ತೇ ಉಪೆಗ್ ಕರುನ್ ಆನಿಕ್ ಪಾಚ಼್ ಹಾಜಾ಼ರ್ ಸೊನ್ಯಾಚ಼ ಆನ ಮಿಳಿವ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","ದನ್ಯಾನಿ, ‘ತ್ಯಲಾ ಶಭಾಸ್ ತು ಇಸ್ವಾಸಾಚಾ಼ ಚಾ಼ಂಗ್ಲಾ ಸೇವಕ್. ಮಿ ತುಲಾ ಹ್ಯಚಿವ್ನಿ ಮೊಟ ಕಾಮ್ ದೇತೊ ಯವುನ್ ಮಾಜೆ ಸಂಗ ಸಂತೊಶಾನಿ ರ‍್ಹಾ’ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“ಮಂಗ್ ದೊನ್ ಹಾಜಾ಼ರ್ ಸೊನ್ಯಾಚ಼ ಅನ ಗೆತಲ್ಯಾಲಾ ಸೇವಕ್ ದನ್ಯಾಪ ಯವುನ್, ‘ಧನ್ಯಾ, ತು ಮನಾ ದೊನ್ ಹಾಜಾ಼ರ್ ಸೊನ್ಯಾಚ಼ ಅನ ದಿಲಸ್. ತ್ಯನಿ ಬಗ್, ಮಿ ಆನಿಕ್ ದೊನ್ ಹಾಜಾ಼ರ್ ಸೊನ್ಯಾಚ಼ ಅನ ಮಿಳಿವ್ಲ’ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","ದನ್ಯಾನಿ ತು ಶಭಾಸ್ ಇಸ್ವಾಸಾಚಾ಼ ಚಾ಼ಂಗ್ಲಾ ಸೇವಕ್ ತು ತೇ ಥೊಡ ಆನ ಚಾ಼ಂಗ್ಲ ವಾಪರ್ಲಸ್ ಮನ್ಹುನ್ ಮಿ ತುಲಾ ಹ್ಯಚಿವ್ನಿ ಮೊಟ ಕಾಮ್ ದೇತೊ ಯವುನ್ ಮಾಜೆ ಸಂಗ ಸಂತೊಶಾನಿ ರ‍್ಹಾ’ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","ನಂತರ ಯೇಕ್ ಹಾಜಾ಼ರ್ ಸೊನ್ಯಾಚ಼ ಆನ ಗೇತಲ್ಯಾಲಾ ಸೇವಕ್ ದನ್ಯಾಪ ಯವುನ್ ದನ್ಯಾ ತು ಖುಬ್ ತರಾಸ್ ದೇತ್ಯಾಲಾ ಮಾನುಸ್ ಮನ್ಹುನ್ ಮನಾ ಠಾವ ಹಾ. ತು ಲಾವಾಚೆ ಆಂದಿ ರ‍್ಯಾಸ್ ಕರ್ತ್ಯಾಲಾ ಆನಿ ಬೀ ಪೆರಾಚೆ ಆಂದಿ ಕ್ಯಾಪ್‌ತ್ಯಾಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","ಮನ್ಹುನ್ ಮಿ ಭಿಹುನ್ ತುಜ಼ ಆನ ಜಿಮ್ನಿತ್ ಚು಼ರುನ್ ಥೆವ್ಲ. ತು ಮನಾ ದಿಲ್ಯಾಲ ಆನ ಹಿತ್ತ ಹಾತ್ತ. ");
INSERT INTO gok_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","ತ್ಯಲಾಸ್ ದನ್ಯಾನಿ ತು ಆಳ್ಸೊಟಾ ಬುರ್ಸಾ ಸೇವಕ್! ಮಿ ಲಾವಿ ನಸ್‌ಲ್ಯಾಲ್ಯಾ ಜಾ಼ಗ್ಯಾಕ್ಡ ರ‍್ಯಾಸ್ ಕರ್ನಾರಾ ಬೀ ಪೇರ್ಲ್ಯಾ ನಸ್‌ಲ್ಯಾಲ್ಯಾ ಜಾ಼ಗ್ಯಾಕ್ಡ ಕ್ಯಾಪ್ನಾರಾ ಮನ್ಹುನ್ ತುಲಾ ಠಾವ ಹಾ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ತಸ ಜಾ಼ಲ್ಯಾವ ತು ಮಾಜ಼ ಅನ ಬಡ್ಡಿನಿ ದಿಯಾ ವ್ಹಯಿತಸ್ ತವಾ ಮಿ ದಿಲ್ಯಾಲ್ಯಾ ಅನ್ಯಾ ಸಂಗ ಬಡ್ಡಿಬಿ ಗಿತ್ಲಿ ಆಸ್ಥಿ’ ಮನ್‍ಲ್ಹಾ. ");
INSERT INTO gok_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","ಮಂಗ್ ದನ್ಯಾನಿ ಆಪ್‌ಲ್ಯಾ ದುಸ್‌ರ‍್ಯಾ ಸೇವಕಾನಾ ತ್ಯಚಿಪ್ಲ ಯೇಕ್ ಹಾಜಾ಼ರ್ ಸೊನ್ಯಾಚ಼ ಅನ ಗಿಹುನ್ ಧಾ ಹಾಜಾ಼ರ್ ಸೊನ್ಯಾಚ಼ ಅನ ಆಸ್‍ಲ್ಯಾಲ್ಯಾ ಸೇವಕಾಲಾ ದೇವಾ. ");
INSERT INTO gok_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","ಆಪ್ಲಿಪ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ಪರತೇಕಾಲಾ ಜಾಸ್ಥಿ ದೇನಾರ್ ಫನ್ ನಸ್‌ರ‍್ಯಾಪ್ನಿ ಆಸ್‌ಲ್ಯಾಲಬಿ ಕಾಡುನ್ ಗೇನಾರ್ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","ಮಂಗ್ ತ್ಯಾ ದನ್ಯಾನಿ ಕಾಮಾಲಾ ಯಯಿನಸ್ನಾರ‍್ಯಾ ತ್ಯಾ ಸೇವಕಾಲಾ ಲೊಕ ರಡತ್ ತರಾಸಾನಿ ಆಪ್ಲ ದಾತ್ ಚಾವತ್ಯಾಲ್ಯಾ ಆಂದಾರಾಚಾ ಜಾ಼ಗ್ಯಾತ್ ಢಕ್ಲಾ’ ಮನ್ಹುನ್ ಹುಕುಮ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“ಮಾನ್ಸಾಚಾ಼ ಲ್ಯೊಕ್ ಆಪ್‌ಲೆ ಮೈಮೆನಿ ಸಗ್‌ಳ್ಯಾ ಧುತಾಂಚೆ ಸಂಗ ಆನಿ ಯತಾನಾ ರಾಜಾ಼ ವ್ಹವುನ್ ಮೊಟ್ಯಾ ಸಿಂಹಾಸನಾವ ಬಸ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","ಸಗ್ಳೆ ಭಾಶೆಂಚಿ ಲೊಕ ತ್ಯಚೆ ಮೊರ‍್ಹ ಜ಼ಮ್ನಾರ್ ಕುರುಬುರಾನಿ ಮೆಂಡ್ರ ಸೆರ್ಡಾತ್ನಿ ಯಗಳ್ಯಾ ಶಾರ್ಕಿ ತ್ಯೊ ತ್ಯನಾ ಯಗಳ್ನಾರ್; ");
INSERT INTO gok_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","ಮಾನ್ಸಾಚಾ಼ ಲ್ಯೊಕ್ ನಿಯತೀಚಾನಾ ಆಪ್‌ಲ್ಯಾ ಉಜ್‌ವ್ಯಾಂಗ್ನಿ ಆನಿ ನಿಯತ್ ನಸ್‌ಲ್ಯಾಲ್ಯಾನಾ ಆಪ್ಲೆ ಡಾವ್ಯಾಂಗ್ನಿ ಉಬಿ ಕರ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“ತವಾ ರಾಜಾ಼ ಆಪ್ಲೆ ಉಜ್‌ವ್ಯಾಂಗ್ನಿ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ಲೊಕಾನಾ, ‘ಯವಾ, ಮಾಜಾ ಬಾನಿ ತುಮಾನಾ ಮೊಟಾ ಆಶಿರ್ವಾದ್ ದಿಲ್ಯಾ. ಯವಾ, ದೇವಾನಿ ತುಮಾನಾ ವಚನ್ ದಿಲ್ಯಾಲ ರಾಜೆ ಗೇವ್ಹಾ. ತ್ಯ ರಾಜೆ ಲೊಕ ಉತ್ಪತ್ತಿ ಜಾ಼ಲ್ಯಾ ಠಾವ್ನಿ ತುಮ್ಚಿ ಸಾಟಿ ತಯಾರ್ ಕೆಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","ತಮಿ ಹ್ಯ ರಾಜೆ ಗೆವ್ಹಾ ಕಾ ಮಂಜೆ ಮಿ ಬುಖ್ಯಾಲ್ತೊ ತುಮಿ ಮನಾ ಜೆವಾನ್ ದಿಲಸಾ ಮಿ ತಾನ್ಯಾಲ್ತೊ ತುಮಿ ಮನಾ ಪಾನಿ ಪಿಯಾ ದಿಲಸಾ ಮಿ ಯಕ್ಲಾಸ್ ಗರ‍್ಹಾತ್ನಿ ದುರ್ ಆಸ್ಥಾನಾ ತುಮಿ ಮನಾ ತುಮ್ಚಾ ಗರ‍್ಹಾತ್ ಗೇತ್ಲಾಸಾ ");
INSERT INTO gok_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","ಮಿ ಉಗ್ಡಾ ಹುತೊ; ತುಮಿ ಮನಾ ಗಾಲಾಯಾ ಕಪ್ಡ ದಿಲಸಾ ಮಿ ದುಕ್‌ನ್ಯಾತ್ ಪಡ್ಲೊ ವ್ಹತೊ ತುಮಿ ಮಾಜಿ ಸೇವಾ ಕಿಲಿಸಾ ಮಿ ತುರುಗಾಂತ್ ಹುತ್ತೊ ತವಾ ತುಮಿ ಮನಾ ಬಗಾಯಾ ಆಲಾಸಾ’ ಮನ್ಹುನ್ ಸಾಂಗ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“ತವಾ ಚಾ಼ಂಗ್ಲಿ ಲೊಕ, ‘ಪ್ರಭು, ತು ಬುಖ್ಯಾಲ್ಯಾಲಾ ಬಗುನ್ ಕವಾ ಜೆವಾನ್ ದಿಲ್ತ? ತು ತಾನ್ಯಾಲ್ಯಾಲಾ ಬಗುನ್ ಕವಾ ಪಾನಿ ಪಿಯಾ ದಿಲ್ತ ");
INSERT INTO gok_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","ತು ಯಕ್ಲಾಸ್ ಗರ‍್ಹಾತ್ನಿ ದುರ್ ಆಸ್‌ಲ್ಯಾಲಾ ಬಗುನ್ ಕವಾ ಆಮ್ಚಾ ಗರ‍್ಹಾತ್ ಗೇತ್ಲಾ? ತುಲಾ ಕಪ್ಡ ನಸ್‌ಲ್ಯಾಲ ಬಗುನ್ ಕವಾ ಗಾಲಾಯಾ ಕಪ್ಡ ದಿಲ? ");
INSERT INTO gok_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","ತು ದುಕ್‌ನ್ಯಾತ್ ಪಡ್‌ಲ್ಯಾಲಾ ನಾಹಿತ ತುರುಂಗಾತ್ ಗ್ಯಾತ್‌ಲ್ಯಾಲಾ ಬಗುನ್ ಕವಾ ತುಜಿ ಸೇವಾ ಕಿಲಿ? ಮನ್ಹುನ್ ಸಾಂಗ್ತಿಲ. ");
INSERT INTO gok_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“ತವಾ ರಾಜಾನಿ, ‘ಮಿ ತುಮಾನಾ ಖರ ಸಾಂಗ್ತೊ. ತುಮಿ ಹಿತ್ತ ಮಾಜಾ ಬನ್ಹಿ ಬಾವ್ಹಾಂಚೆ ಸಾಟಿ ಕ್ಯಾ ಕ್ಯಾ ಕರ್ಸಿಲಾ ತ್ಯ ಸಗ್ಳ ಮನಾ ಕೆಲ್ಯಾ ಶಾರ್ಕಸ್’ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“ಮಂಗ್ ರಾಜಾನಿ ಆಪ್‌ಲ್ಯಾ ಡಾವ್ಯಾಂಗ್ಚಾ ಲೊಕಾನಾ, ‘ಮಾಜಿಪ್ನಿ ನಿಗುನ್ ಜಾ಼ವಾ ತುಮಿ ಸರಾಪ್ ಲಾಗಲ್ಯಾಲಿ ಲೊಕ ತುಮಾನಾ ಶಿಕ್ಷಾ ವ್ಹಯಾವ್ಹಯಿ ಮನ್ಹುನ್ ದೇವಾನಿ ಥರಿವ್‌ಲ್ಯಾ ಸೈತಾನಾಲಾ ಆನಿ ತ್ಯಚಾ ಧುತಾನಾ ತಯಾರ್ ಕೆಲ್ಯಾಲ್ಯಾ ಇಜ಼ತ್ ನಸ್‌ಲ್ಯಾಲ್ಯಾ ಶಾಶ್ವತ್ ಇಸ್‌ಥ್ಯಾತ್ ಪಡಾ. ");
INSERT INTO gok_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","ಕಾ ಮಂಜೆ ಮಿ ಬುಖ್ಯಾಲ್ತೊ, ತುಮಿ ಮನಾ ಖಾಯಾ ದಿಲ ನಾಹಿಸಾ. ಮಿ ತಾನ್ಯಾಲ್ತೊ ತುಮಿ ಮನಾ ಪಿಯಾ ಪಾನಿ ದಿಲನಾಹಿಸಾ. ");
INSERT INTO gok_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ಮಿ ಪರದೇಶಿ ಜಾ಼ಲ್ತೊ, ತುಮಿ ಮನಾ ತುಮ್ಚಾ ಗರ‍್ಹಾತ್ ಗೇತ್ಲಾ ನಾಹಿಸಾ. ಮನಾ ಕಪ್ಡ ನವ್ಥ ತುಮಿ ಮನಾ ಗಾಲಾಯಾ ಕಪ್ಡ ದಿಲ ನಾಹಿಸಾ. ಮಿ ದುಕ್‌ನ್ಯಾತ್ ಪಡ್ಲೊ ಹುತ್ತೊ ಆನಿ ತುರುಂಗಾತ್ ಹುತ್ತೊ ತುಮಿ ಮಾಜಿ ಸೇವಾ ಕಿಲಿ ನಾಹಿಸಾ’ ಮನ್ಹು‍ನ್ ಸಾಂಗ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“ತೇ, ‘ಪ್ರಭು, ತು ಕವಾ ಬುಖ್ಯಾಲ್ತಾಸ್ ಆನಿ ತಾನ್ಯಾಲ್ತಾಸ್? ತು ಕವಾ ಆದಾರ್ ನಸ್‌ಲ್ಯಾಲಾ ಹುತ್ತಾಸ್? ತುಲಾ ಕವಾ ಕಪ್ಡ ನವ್ಥ? ತು ಕವಾ ದುಕ್‌ನ್ಯಾತ್ ಪಡ್ಲಾ ಹುತ್ತಾಸ್ ಆನಿ ತುರುಂಗಾತ್ ಹುತ್ತಾಸ್ ಹ್ಯ ಸಗ್ಳ ಆಮಿ ಬಗುನ್ಬಿ ತುಲಾ ಮಜ಼ತ್ ಕರಾಚೆ ಆಂದಿ ಗೆಲಾವ್ ಕವಾ? ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","ತವಾ ರಾಜಾನಿ ಮಿ ತುಮಾನಾ ಖರ ಸಾಂಗ್ತೊ ತುಮಿ ಹಿತ್ತ ಮಾಜಾ ಖಾಲ್ಚಾ ಲೊಕಾನಾ ಕ್ಯಾ ಕ್ಯಾ ಕೆಲ ನಾಹಿಸಾ ತ್ಯ ಮನಾ ಕೆಲ್ಯಾ ನಸ್‌ಲ್ಯಾಚೆಗತ್’ ಮನ್ಹುನ್ ಉತ್ತರ್ ದಿಯಿಲ್. ");
INSERT INTO gok_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“ತವಾ ಬುರ್ಸಿ ಲೊಕ ತಿಥ್ನಿ ನಿಗುನ್ ಜಾ಼ತಿಲ. ತ್ಯನಾ ಶಾಶ್ವತ್ ದಂಡ ವ್ಹನಾರ್ ಚಾ಼ಂಗಲ್ಯಾ ಲೊಕಾನಾ ಶಾಸ್ವಾತ್ ಜೀವ್ನಾ ಗಾವ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","ಯೇಸುನಿ ಹ್ಯಾ ಗುಶ್ಟಿ ಸುಪಿವ್‌ಲ್ಯಾ ನಂತರ್, ಆಪ್‌ಲ್ಯಾ ಶಿಶಾನಾ ಸಾಂಗ್ಲ ");
INSERT INTO gok_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“ಪರ್ವಾದಿಸಿ ಪಸ್ಕಾಚಾ಼ ಸನ್ ಮನ್ಹುನ್ ತುಮಾನಾ ಠಾವಾ ಹಾ. ತವಾ ಮಾನ್ಸಾಚಾ ಲೇಕಾಲಾ ಶಿಲಬೆವ ಗಾಲಾಲಾ ವಾದಿಂಚಾ ಹಾತಾತ್ ದೇನಾರ್. ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","ಹಿಕ್ಡ ಮಹಾಯಾಜಕ್ ಆನಿ ಯೆಹುದಿ ಜಾಂತ್ಯಾಂಚಾ಼, ಮುಖ್ಯ ಯಾಜಕಾಚಾ ಗರ‍್ಹಾಚಾ ಆಂಗ್ನಾತ್ ಮೇಳಾ ಜ಼ಮ್ಲಾ. ಮುಖ್ಯ ಯಾಜಕಾಚ಼ ನಾವ್ ಕಾಯಪ್. ");
INSERT INTO gok_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ತ್ಯಾ ಮೇಳಾತ್ ತೆ ಯೇಸುಲಾ ಪಾರ್ಕಿನಿ ದರುನ್ ಮಾರುನ್ ಟಾಕಾಯಾ ಯವಜ್ನಾಕಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","ಫನ್ ಲೊಕಾಂಚಾನಿ ಆಮಿ ಪಸ್ಕಾಚಾ ಸನಾಚಾ ಕಾಲಾತ್ ಯೇಸುಲಾ ಕೊಂಡಾಯಾ ವ್ಹನಾರ್ ನಾಹಿ ಕಾ ಮಂಜೆ ಲೊಕಾಂಚಾ಼ ಗಾನ್ಹಾ ವ್ಹಯಿಲ್ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","ಯೇಸು ಬೆತಾನಿತ್ ಆಸ್ಥಾನಾ ಸಿಮೊನ್ ಮಂಥ್ಯಾಲ್ಯಾ ಕುಶ್ಟ ರೊಗಿಚಾ ಗರ‍್ಹಾತ್ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ತವಾ ಯೇಕ್ ಬ್ಯಾಯ್ಕಾ ಮಾನುಸ್ ಖುಬ್ ಕಿಮ್ತಿಚ಼ ವಾಸಾಚ಼ ತ್ಯಾಲ್ ಗಾರಚಾ ದೊಂಡ್ಯಾಚಿ ಬರ್ನ್ಹಿ ಗಿಹುನ್ ಯವುನ್ ಜೆವ್ನಾಲಾ ಬಸ್‌ಲ್ಯಾಲ್ಯಾ ಯೇಸುಚೆ ಡುಯಿವ ತ್ಯ ವಾಸಾಚ಼ ತ್ಯಾಲ್ ವತ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","ಹ್ಯ ಬಗ್‌ಲ್ಯಾಲ್ಯಾ ಶಿಶಾಂಚಾನಿ ತೇ ಬ್ಯಾಯ್ಕಾ ಮಾನ್ಸಾವ ರಾಗ್ ಕರುನ್, “ತ್ಯ ವಾಸಾಚ಼ ತ್ಯಾಲ್ ಕಾ ನಾಸ್ ಕೆಲಸ್? ");
INSERT INTO gok_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","ತ್ಯ ಖುಬ್ ಪೈಸ್ಯಾನಾ ಇಕುನ್ ಗರಿಬ್ ಲೊಕಾನಾ ದಿಯಾಚ಼ ಹುತಸ್ ನವ್ಹ!” ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","ಫನ್ ಹ್ಯಾ ಕಾಮಾಲಾ ಕಾರನ್ ಸಮಾಜ್‌ಲ್ಯಾಲಾ ಯೇಸು ಆಪ್‌ಲ್ಯಾ ಶಿಶಾನಾ, ಹೆ ಬ್ಯಾಯ್ಕಾ ಮಾನ್ಸಾಲಾ ಕಾ ತರಾಸ್ ದೇತಾಸಾ? ತಿನಿ ಮನಾ ಖುಬ್ ಚಾ಼ಂಗ್ಲ ಕಾಮ್ ಕೆಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","ಗರಿಬ್ ಲೊಕ ತುಮ್ಚಿ ಸಂಗ ಕವಾಬಿ ರಾಥ್ಯಾತ ಫನ್ ಮಿ ತುಮ್ಚಿ ಸಂಗ ಖಾಯಿಮ್ ರಾಹಿತ್ನಾಹಿ ");
INSERT INTO gok_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","ಮಿ ಮೆಲ್ಯಾ ನಂತರ್ ಮನಾ ಮಸುರ್ಡಿತ್ ನೆಥಾನಾ ತಯಾರ್ ಕರಾಯಾ ಸಾಟಿ ಹೆ ಬ್ಯಾಯ್ಕಾ ಮಾನ್ಸಾನಿ ಮಾಜಾ ಆಂಗಾವ ವಾಸಾಚ಼ ತ್ಯಾಲ್ ವತ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","ಮಿ ತುಮಾನಾ ಖರ ಸಾಂಗ್ತೊ. ದುನೆತ್ ಕುಠ ಕುಠ ಚಾ಼ಂಗ್ಲಿ ಖಬರ್ ಸಾಂಗ್ತಿಲ ತಿಥ ಹ್ಯ ಕಾಮ್ ಹಿಚೆ ಯದಸಾಟಿ ಸಾಂಗನಾರ್ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","ಮಂಗ್ ಬಾರಾ ಜಾ಼ನ್ ಶಿಶಾತ್ಲಾ ಯೊಕ್ ಇಸ್ಕರಿ ಯುದ್ ಮಹಾಯಾಜಕಾಂಚಿಪ ಜಾ಼ವುನ್, ");
INSERT INTO gok_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","“ಯೇಸುಲಾ ತುಮಾನಾ ದರ‍್ಹುನ್ ದಿಲಾತ ತುಮಿ ಮನಾ ಕ್ಯವ್ಡ ಪೈಸ ದೇನಾರ್? ಮನ್ಹುನ್ ಇಚಾರ್ಲ ಮಹಾ ಯಾಜಕಾಂಚಾನಿ ತೀಸ್ ಚಾ಼ಂದಿಚ಼ ಆನ ಯುದಾಲಾ ದಿಲ. ");
INSERT INTO gok_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","ತಿಸಿಚಾನ್ ಯೇಸುಲಾ ದರುನ್ ದಿಯಾ ಯೊಳ್ ರಾಖಿತಾ. ");
INSERT INTO gok_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","ಆಂಬಾಟ್ ನಸ್‌ಲ್ಯಾಲ್ಯಾ ಬಾಕ್ರಿಚಾ ಸನಾಚಾ ಪೈಲ್ಯಾ ದಿಸಾ ದಿಸಿ ಶಿಶಾಂಚಾನಿ ಯೇಸುಪ ಯವುನ್ “ಆಮಿ ತುಜಿ ಸಾಟಿ ಪಸ್ಕಾಚಾ ಸನಾಚ಼ ಜೆವಾನ್ ಕುಠ ತಯಾರ್ ಕರಾವ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","ತ್ಯಲಾ ಯೇಸುನಿ ತುಮಿ ಪೆಠತ್ ಜಾ಼ವುನ್ ಮಿ ದ್ಯಾವ್‌ತ್ಯಾಲ್ಯಾ ಮಾನ್ಸಾಪ ಜಾ಼ವುನ್ ತ್ಯಲಾ ನಿವ್ಡುನ್ ಗೇತಲ್ಯಾಲಾ ಯೊಳ್ ಜ಼ವಳ್ ಆಲಾ ಮಿ ಪಸ್ಕಾಚಾ ಸನಾಚ಼ ಜೆವಾನ್ ತುಜಾ ಗರ‍್ಹಾತ್ ಮಾಜಾ ಶಿಶಾಂಚೆ ಸಂಗ ಕರ್ತೊ ಮನ್ಹುನ್ ಮಾಸ್ಥರ್’ ಸಾಂಗ್‍ತ್ಯೊ ಮನ್ಹುನ್ ಸಾಂಗಾ.” ");
INSERT INTO gok_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","ಯೇಸುನಿ ಸಾಂಗ್‌ಲ್ಯಾ ಶಾರ್ಕ ಶಿಶಾಂಚಾನಿ ಪಸ್ಕಾಚಾ ಸನಾಚ಼ ಜೆವಾನ್ ತಯಾರ್ ಕೆಲ. ");
INSERT INTO gok_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","ಶಾಂಚ಼ ಯೇಸು ಆಪ್‌ಲ್ಯಾ ಬಾರಾ ಜಾ಼ನ್ ಶಿಶಾಂಚೆ ಸಂಗ ಜೆವ್ನಾಲಾ ಬಸ್ಲಾ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","ತೇ ಸಗ್ಳ ಜೆವಾನ್ ಖಾತಾನಾ ಯೇಸುನಿ, “ಮಿ ತುಮಾನಾ ಖರ ಸಾಂಗ್ತೊ. ಹಿತ್ತ ಆಸ್‌ಲ್ಯಾಲ್ಯಾತ್ಲಾ ಯಕ್ಲಾ ಮನಾ ವಾದಿಂಚಿಪ್ನಿ ದೇನಾರ್ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","ಶಿಶಾಂಚಾನಿ ಹ್ಯ ಐಕುನ್ ಖುಬ್ ರಡ್ಲ ಆನಿ ಪರತೇಕ್ ಶಿಶಾ ಯೇಸುಲಾ ಪ್ರಭು ಖರ‍್ಯಾನಿ ಮಿ ನವ್ಹ? ಮನ್ಹುನ್ ಸಾಂಗಾಯಾ ಲಾಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","ಯೇಸುನಿ ವ್ಯಾಟ್‍ಕ್ಯಾತ್ ಮಾಜೆ ಸಂಗ ಆಪ್ಲ ಹಾತ್ ಗ್ಯಾಲತ್ಯಾಲಾ ಮನಾ ಮಾಜಾ ವೈರಿಂಚಾ ಹಾತಾತ್ ದಿಯಿಲ್. ");
INSERT INTO gok_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","ಪವಿತ್ರ ಪುತೀಕಾತ್ ಲಿವ್‌ಲ್ಯಾ ಶಾರ್ಕ ಮಾನ್ಸಾಚಾ಼ ಲ್ಯೊಕ್ ನಿಗುನ್ ಜಾ಼ವುನ್ ಮರ್ನಾರ್. ಖರ ತ್ಯಲಾ ಮಾರುನ್ ಟಾಕಾಯಾ ದೇತ್ಯಾಲ್ಯಾಲಾ ಖುಬ್ ತರಾಸ್ ವ್ಹನಾರ್ ತ್ಯೊ ಜ಼ಲಾಮ್ಲಾ ನಸ್ಥಾತ ಖುಬ್ ಬರ ವ್ಹಯಾಚ಼ ಹುತ್ತ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","ತವಾ, ಯೇಸುಲಾ ತ್ಯಚಾ ವಾದಿಂಚಾ ಹಾತಾತ್ ದೇತ್ಯಾಲಾ ಯುದ್ ಪ್ರಬು ಮಿ ಕ್ಯಾ? ಮನ್ಲಾ. ತ್ಯಲಾ ಯೇಸು ವ್ಹಯ್ ತುಸ್ ತ್ಯೊ? ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","ತೇ ಜೆವ್ತಾನಾ ಯೇಸುನಿ ಬಾಕ್ರಿ ಗಿಹುನ್ ತ್ಯಚಿ ಸಾಟಿ ದೇವಾಲಾ ಉಪ್ಕಾರ್ ಸಾಂಗುನ್ ತೀ ಮುಡುನ್ ಗೇವ್ಹಾ ಖಾವಾ ಹ್ಯ ಮಾಜ಼ ಧಡ್ ಮನ್ಹುನ್ ಸಾಂಗುನ್ ಆಪ್‌ಲ್ಯಾ ಶಿಶಾನಾ ದಿಲ. ");
INSERT INTO gok_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","ಮಂಗ್ ಯೇಸುನಿ ದರಾಕ್ಶಿಚಾ ರಸಾಚ಼ ಐದಾನ್ ಗಿಹುನ್ ತ್ಯಚಿಸಾಟಿ ದೇವಾಲಾ ಉಪ್ಕಾರ್ ಸಾಂಗುನ್, “ತುಮಿ ಸಗ್ಳ ಹ್ಯ ಪಿವಾ. ಮನ್‍ಲ್ಹಾ ");
INSERT INTO gok_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","ಹ್ಯ ನವಾ ಕರಾರ್ ದಾವುನ್ ದೇತ್ಯಾಲ ಮಾಜ಼ ರಗಾತ್. ಹ್ಯ ಖುಬ್ ಲೊಕಾಂಚ಼ ಪಾಪ ಮಾಪ್ ಕರಾಯಾ ಶಾಂಡ್‌ಲ್ಯಾಲ ರಗಾತ್ ");
INSERT INTO gok_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","ಮಿ ತುಮಾನಾ ಸಾಂಗ್ತೊ, ಮಾಜಾ ಬಾಚಾ ರಾಜಾತ್ ಆನಿಕ್ ಮಿಳುನ್ ದರಾಕ್ಶಿಚಾ಼ ರಸ್ ನವಿನಿ ಪಿಯಿ ಪತರ್ ತ್ಯ ಆನಿಕ್ ಪಿನಾರುಸ್ ನಾಹಿ” ಮನ್ಹುನ್ ಸಾಂಗುನ್ ಲೊಕಾನಾ ಪಿಯಾ ದಿಲ. ");
INSERT INTO gok_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","ತವಾ ಶಿಶಾ ಸಗ್ಳ ಪಸ್ಕಾಚಾ ಸನಾಚ಼ ಗೀತ್ ಮನ್ಲ ನಂತರ್ ತೇ ಆಲಿವ್ ಮೊಟ್ಯಾ ಗುಢ್ಯಾವ ಗೆಲ. ");
INSERT INTO gok_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","ತವಾ ಯೇಸುನಿ ಆಪ್‍ಲ್ಯಾ ಶಿಶಾನಾ, “ಆಚ್ಚೆ ರಾತಿತ್ ತುಮಿ ಮನಾ ಸುಡುನ್ ಪಳುನ್ ಜಾ಼ನ್ಹಾರ್. ‘ಮಿ ಕುರುಬುರಾಲಾ ಮಾರುನ್ ಟ್ಯಾಕ್ನಾರ್, ತವಾ ಮೆಂಡ್ರ ಸಗ್ಳಿ ಪಗಾಳ್ನಾರ್’ ಮನ್ಹುನ್ ದೇವಾನಿ ಪವಿತ್ರ ಪುತೀಕಾತ್ ಲಿವ್‌ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","ಫನ್ ಮಿ ಮೆಲ್ಯಾ ನಂತರ್ ಜಿತ್ತಾ ವ್ಹವುನ್ ಯನಾರ್ ಪರತ್ ಮಿ ಗಲಿಲಾಯಾತ್ ಜಾ಼ನಾರ್ ತುಮಿ ತಿಥ ಜಾ಼ಯಾಚೆ ಆಂದಿ ಮಿ ತಿಥ ರಾನ್ಹಾರ್ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","ಫನ್ ಪೇತ್ರಾ ಆನಿ ರಾಯ್‌ಲ್ಯಾಲ ಶಿಶಾ ಸಗ್ಳ ತುಜಿಸ್ ಲಾಗುನ್ ಆಪ್ಲಾ ಇಸ್ವಾಸ್ ಸಾಂಡುನ್ ಗಿತಿಲ ಫನ್ ಮಿ ತ್ಯವ್ಡಾಸ್ ತಸ ಕರ್ನಾರ್ ನಾಹಿ ಮನ್ಹುನ್ ಉತ್ತರ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","ಯೇಸುನಿ, “ಮಿ ತುಮಾನಾ ಖರ ಸಾಂಗ್ತೊ. ಆಜ಼್ ರ‍್ಯಾಚಾ಼ ಕೊಂಬ್ಡಾ ಬವಾಚೆ ಆಂದಿ ತು ಮಾಜೆ ಗುಶ್ಟಿತ್ ತ್ಯೊ ಮನಾ ಠಾವಾಸ್ ನಾಹಿ ಮನ್ಹುನ್ ತೀನ್ ಖೆಪಾ ಸಾಂಗ್ನಾರ್” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","ಫನ್ ಪೇತ್ರಾ, “ಮಿ ತುಜಿ ಸಂಗ ಮೇಲೊ ತರಿ, ತು ಮನಾ ಠಾವಾ ನಾಹಿ ಮನ್ನಾರ್‌ ನಾಹಿ” ಮನ್ಲಾ. ರಾಹಿಲ್ಯಾಲ್ಯಾ ಶಿಶಾಂಚಾನಿಬಿ ತಸಸ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","ಮಂಗ್ ಯೇಸು ಆಪ್‌ಲ್ಯಾ ಶಿಶಾಂಚೆ ಸಂಗ ಗೆತ್ಸೆಮನೆ ಮಂಥ್ಯಾಲ್ಯಾ ಜಾ಼ಗ್ಯಾವ ಗೆಲಾ. ಯೇಸುನಿ ಆಪ್‌ಲ್ಯಾ ಶಿಶಾನಾ ಮಿ ತಿಥ ಜಾ಼ವುನ್ ಮಾಗ್ನ ಕರುನ್ ಯಯಿಪರತ್ ಹಿತ್ತಸ್ ರಾವ್ಹಾ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","ಯೇಸು ಪೇತ್ರಾಲಾ ಆನಿ ಜೆಬೆದಾಯಾಚಾ ದೊಗಾ ಪ್ಯೊರ್‌ಗ್ಯಾನಾ ಆಪ್ಲಿ ಸಂಗ ಗಿಹುನ್ ಗೆಲಾ. ತವಾ ಯೇಸುಚಾ ಮನಾಲಾ ಖುಬ್ ದುಕ್ ವ್ಹವುನ್ ");
INSERT INTO gok_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","ತ್ಯನಾ, “ಮಾಜಾ ಮನಾಲಾ ಖುಬ್ ದುಕ್ ಜ಼ಾಲ್ಯಾ. ಮಾಜ಼ ಮನ್ ದುಖಾನಿ ಮರ ಶಾರ್ಕಿ ಜಾ಼ಲ್ಯಾ. ತುಮಿ ಮಾಜಿ ಸಂಗ ಹಿತ್ತಸ್ ಜಾ಼ಗ ರಾವ್ಹಾ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","ಮಂಗ್ ಯೇಸು ತ್ಯಂಚಿಪ್ನಿ ಥೊಡಾ ದುರ್ ಜಾ಼ವುನ್ ಜಿಮ್ನಿವ ಆಡ್ವಾ ಪಡುನ್ ಮಾಜಾ ಬಾ ಜಾ಼ಲತ ತರಾಸಾಚ಼ ಹ್ಯ ಐದಾನ್ ಮನಾ ದಿವು ನಕೊ. ಫನ್ ಮಾಜಾ ಮನಾ ಶಾರ್ಕ ನವ್ಹ ತುಜಾ ಮನಾ ಶಾರ್ಕಸ್ ಕರ್ ಮನ್ಹುನ್ ಮಾಗ್ನ ಕೆಲ ");
INSERT INTO gok_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","ಮಂಗ್ ಯೇಸು ಆಪ್‌ಲ್ಯಾ ಶಿಶಾಂಚಿಕ್ಡ ಮಾಗಾರಾ ಪರಾತ್ಲಾ. ತೇ ನಿಸ್‌ತ್ಯಾಲ ಬಗುನ್ ತ್ಯನಿ, “ತುಮಾನಾ ಮಾಜಿಸಂಗ ಯೇಕ್ ತಾಸ್ ತರಿ ಜಾ಼ಗ ರಾಹ್ಯಾ ವ್ಹಯಿತ್ನಾಹಿ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","ತುಮಿ ಪರಿಕ್ಷೆತ್ ಗಾವುನಾಹಿಸಾ ಮನ್ಹುನ್ ಜಾ಼ಗ ರಾಹುನ್ ಮಾಗ್ನ ಕರಾ. ಮನ್ ಶಾರ್ಕ ಹಾ ಫನ್ ಆಂಗಾಲಾ ಬಳ್ ಪುರೊ ವ್ಹಯಿನಾ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","ಯೇಸು ದೊನ್ವೆ ಪಾವ್ಟಿ ಥೊಡಾ ದುರ್ ಜಾ಼ವುನ್ ಮಾಗ್ನ ಕರೀತ್ ಮಾಜಾ ಬಾ ತರಾಸಾಚ಼ ಹ್ಯ ಐದಾನ್ ಮಾಜಿಪ್ನಿ ಕಾಡುನ್ ಗಿಹ್ಯಾ ವ್ಹಯಿತ್ನಾಹಿತ ಆನಿ ಮಿ ತ್ಯ ಕರಾಲಾಸ್ ವ್ಹಯಿ ಮನ್ಲಾಸ್ತ ತುಜಾ ಮನಾ ಶಾರ್ಕಸ್ ವ್ಹವುನಿ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","ಮಂಗ್ ಯೇಸು ಆಪ್‌ಲ್ಯಾ ಶಿಶಾಂಚಿಕ್ಡ ಮಾಗಾರಾ ಪರಾತ್ಲಾ ತವಾ ತೇ ಆನಿ ನಿಜ಼ಲ್ಯಾಲ ಬಗ್ಲ. ತ್ಯಂಚ಼ ಡೊಳ ಪೆಂಗಾನಿ ಬರ್ಲ ಹುತ್ತ. ");
INSERT INTO gok_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","ಮನ್ಹುನ್ ಯೇಸುನಿ ಆನಿಯಂಗ್ದಾ ತ್ಯನಾ ಸುಡುನ್ ಥೊಡಾ ದುರ್ ಜಾ಼ವುನ್ ತಿನ್ವೆ ಪಾವ್ಟಿ ತಸಸ್ ಮಾಗ್ನ ಕೆಲ. ");
INSERT INTO gok_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","ಮಂಗ್ ಯೇಸು ಆಪ್‌ಲ್ಯಾ ಶಿಶಾಂಚಿಕ್ಡ ಪರ್ತುನ್, “ತುಮಿ ಆನಿಕ್ ನಿಜ಼ತ್ ಆರಾಮ್ ಗೇಥ್ಯಾಸಾ ಕ್ಯಾ? ಪಾಪಿ ಜಾ಼ಲ್ಯಾಲ್ಯಾ ಲೊಕಾಂಚಿಪ ಮಾನ್ಸಾಚಾ ಲೇಕಾಲಾ ದಿಯಾಚಾ಼ ಯೊಳ್ ಜ಼ವಳ್ ಆಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","ಆಮಿ ಜಾ಼ಯಾ ವ್ಹಯಿ. ಉಠಾ! ಮನಾ ವಾದಿಪ್ನಿ ದೇತ್ಯಾಲಾ ಮಾನುಸ್ ಹಿತ್ತಸ್ ಯಯಾಲಾಗ್‌ಲ್ಯಾ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","ಯೇಸು ಬೊಲ್‌ತ್ಯಾಲಾ ಆಸ್ಥಾನಾಸ್ ಯುದ್ ತಿಥ ಆಲಾ. ಯುದ್ ಬಾರಾಜಾ಼ನ್ ಶಿಶಾತ್ಲಾ ಯೊಕ್ ಜಾ಼ಲ್ಥಾ ಮಹಾಯಾಜಕ್ ಆನಿ ಜಾಂತ್ಯಾಂಚಾನಿ ಲಾವುನ್ ದಿಲ್ಯಾಲಿ ಖುಬ್ ಲೊಕ ತ್ಯಚಿ ಸಂಗ ಹುತ್ತಿತ. ತೀ ಕೊಂಗಳ್ಯಾ ಆನಿ ಟೊನ ದರುನ್ ಹುತ್ತಿತ. ");
INSERT INTO gok_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","ಯೇಸು ಕೊನ್ ಮನ್ಹುನ್ ಸಮಜು಼ನ್ ಗಿಹ್ಯಾ ಯುದಾನಿ ತ್ಯನಾ ಮಿ ಕಚಾಚಾ಼ ಮುಕ್ಕಾ ಗೆತೊ ತ್ಯೊಸ್. ತ್ಯಲಾ ದರ‍್ಹಾ” ಮನ್ಹುನ್ ಯೇಕ್ ಖುನಾ ಸಾಂಗುನ್ ದಿಲ್ತಿ. ");
INSERT INTO gok_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","ತಸಾಸ್ ಯುದ್ ಯೇಸುಪ ಜಾ಼ವುನ್, “ಮಾಸ್ಥರಾ ಬರಾ ಹಾಸ್ ಕ್ಯಾ ಮನ್ಹುನ್ ಸಾಂಗುನ್ ತ್ಯಚಾ಼ ಮುಕ್ಕಾ ಗೆತ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","ತವಾ ಯೇಸುನಿ, “ಸೋಪ್‌ತ್ಯಾ, ತು ಕರಾಲಾ ಆಲ್ಯಾಲ ಕಾಮ್ ಹ್ಯಸ್ ಕ್ಯಾ? ಮನ್ಲಾ. ತವಾಸ್ ತ್ಯಾ ಲೊಕಾಂಚಾನಿ ಯವುನ್ ಯೇಸುಲಾ ದರುನ್ ಕ್ಯೊಂಡ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","ತವಾ ಯೇಸುಚೆ ಸಂಗ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ಯಕಾನಿ ಆಪ್ಲ ಹತ್ಯಾರ್ ಬಾಹಿರ್ ವಡುನ್ ಮುಖ್ಯ ಯಾಜಕಾಚಾ ಸೇವಕಾಲಾ ಮಾರುನ್ ತ್ಯಚಾ಼ ಕಾನ್ ತುಡುನ್ ಟ್ಯಾಕ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","ಯೇಸು ತ್ಯಲಾ ಮನ್‍ಲ್ಹಾ, “ತುಜ಼ ಹತ್ಯಾರ ಆತ್ ಗ್ಯಾಲ್ ಕುಂಗ್ಳಿ ಗೇಥ್ಯಾಲಿ ಲೊಕ ಕುಂಗ್ಳಿನಿಸ್ ಮರ್‌ತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","ಮಿ ಮಾಜಾ ಬಾಪ ಮಾಗ್‌ಲ್ಯಾವ. ತ್ಯೊ ಮನಾ ದೇವ್ದುತಾಂಚಾ ಸೈನ್ಯಾಚಾ಼ ಬಾರಾ ಹಿಂಡ್ ದೇನಾರ್ ಮನ್ಹುನ್ ತುಲಾ ಠಾವ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","ಫನ್ ಪವಿತ್ರ ಪುತೀಕಾತ್ ಲಿವ್‌ಲ್ಯಾ ಶಾರ್ಕ ಆಸಸ್ ವ್ಹಯಾವ್ಹಯಿ. ಮನ್ಹುನ್ ಸಾಂಗ್ಲ ");
INSERT INTO gok_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","ಮಂಗ್ ಯೇಸುನಿ ತ್ಯಾ ಲೊಕಾನಾ ತುಮಿ ಗುನ್ನಾ ಕೇಲ್ಯಾಲ್ಯಾಲಾ ಕ್ಯೊಂಡ್‌ತ್ಯಾಲ್ಯಾಂಚೆಗತ್ ಕೊಂಗಳ್ಯಾ ಆನಿ ಟೊನ ದರ‍್ಹುನ್ ಹಿತ್ತ ಆಲ್ಯಾಸಾ ಮಿ ರೊಜ್ ದೇವ್ಳಾತ್ ಬಸುನ್ ಸಿಕ್ವಿತ್ ಆಸ್ಥಾನಾ ತುಮಿ ಮನಾ ತಿಥ ದರ್ಲಾ ನಾಹಿಸಾ. ");
INSERT INTO gok_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","ಫನ್ ಪ್ರವಾದಿಂಚಾನಿ ಲಿವ್‌ಲ್ಯಾಲ ಸಗ್ಳ ವ್ಹಯಾವ್ಹಯಿ ಮನ್ಹುನ್ ಹ್ಯ ಸಗ್ಳ ಜಾ಼ಲ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ ತವಾ ಶಿಶಾ ಸಗ್ಳ ತ್ಯಲಾ ಸುಡುನ್ ಪಳುನ್ ಗೆಲ. ");
INSERT INTO gok_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","ಮಂಗ್ ಯೇಸುಲಾ ಕ್ಯೊಂಡ್‌ಲ್ಯಾಲ ತ್ಯಲಾ ಮುಖ್ಯ ಯಾಜಕ್ ಜಾ಼ಲ್ಯಾಲ್ಯಾ ಕಾಯಪಾಚಾ ಗರ‍್ಹಾತ್ ಹಾಕ್ಟುನ್ ನೆಲಾ. ತಿಥ ಧರ್ಮೊಪದೇಶಕಾನಿ ಯಹೂದ್ಯಾತ್ಲ ಜಾಂತ ಯಂಗ್ದಾಸ್ ಜ಼ಮ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","ಯೇಸುಲಾ ಕ್ಯಾ ವ್ಹತ್ಯಾ ಮನ್ಹುನ್ ಬಗಾಯಾ ಪೇತ್ರಾ ದುರ್ನಿಸ್ ಮಾಗ್ನಿ ಯಯಿತ್ ಮುಖ್ಯ ಯಾಜಕಾಚಾ ಗರ‍್ಹಾಚಾ ಆಂಗ್ನಾತ್ ಯವುನ್ ರ‍್ಯಾಖ್‌ತ್ಯಾಲ್ಯಾಂಚೆ ಸಂಗ ಬಸ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","ಮುಖ್ಯ ಯಾಜಕ್ ಆನಿ ಯೆಹುದ್ಯಾಂಚಾನಿ ನ್ಯಾಯಿ ನಿವ್ಡಾಚಾ಼ ಮೇಳ್ಯಾನಿ ಯೇಸುಲಾ ಮರ್ನಾಚಿ ಶಿಕ್ಶಾದಿಯಾ ವ್ಹಯಿ ಜಾ಼ಲ್ಯಾಲ್ಯಾ ಲಬಾಡ್ ಸಾಕ್ಶಾ ಶೊದ್‌ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","ಖುಬ್ ಜ಼ನಾಂಚಾನಿ ಯವುನ್ ಯೇಸುಚಾ ಲಬಾಡ್ ಗುಶ್ಟಿ ಸಾಂಗ್‌ಲ್ಯಾ. ಫನ್ ಯೇಸುಲಾ ಮಾರುನ್ ಟಾಕಾಯಾ ಪಾಯ್ಜೆ ಆಸ್‌ಲ್ಯಾಲಾ ಗುನ್ನಾ ಮೆಳ್ಯಾಲಾ ಗಾವ್ಲಾನಾಹಿ ತವಾ ದೊಗ ಯವುನ್, ");
INSERT INTO gok_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“ಹ್ಯಾ ಮಾನ್ಸಾನಿ, ‘ಮಿ ದಿವುಳ್ ಪಾಡುನ್ ತ್ಯ ಆನಿಕ್ ತೀನ್ ದಿಸಾತುಸ್ ಬ್ಯಾಂತೊ’ ಮನ್ಹುನ್ ಸಾಂಗ್‌ಲ್ಯಾ” ಮನ್‌ಲ್ಹ. ");
INSERT INTO gok_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","ಮುಖ್ಯ ಯಾಜಕ್ ವರ್ ಉಠುನ್ ಯೇಸುಲಾ ಹಿ ಲೊಕ ತುಜಿವ ವಾವ್‌ತ್ಯಾಲೆ ಚು಼ಕಿಲಾ ತು ಕ್ಯಾ ತರಿ ಸಾಂಗಾಚಾ಼ ಹಾಸ್ ಕ್ಯಾ? ಹಿ ಸಾಂಗ್‌ತ್ಯಾಲಿ ಸಗ್ಳ ಖರ ಕ್ಯಾ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","ಫನ್ ಯೇಸು ಗಪ್ ಹುತ್ತಾ ಮುಖ್ಯ ಯಾಜಕ್ ಆನಿಕ್ ಯೇಸುಲಾ ಜೀವ್ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ದೇವಾವ ಸೆಪ್ಪತ್ ಥಿವುನ್ ಇಚಾರ್ತ್ಯೊ ತು ದೇವಾಚಾ಼ ಲ್ಯೊಕ್ ಕ್ರಿಸ್ತ್ ಕ್ಯಾ ಆಮಾನಾ ಸಾಂಗ್ ಮನ್ಲಾ ");
INSERT INTO gok_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","ಯೇಸುನಿ, “ವ್ಹಯ್, ತು ಸಾಂಗ್‌ಲ್ಯಾ ಶಾರ್ಕ ತ್ಯೊಸ್ ಮಿ. ಫನ್ ತುಲಾ ಸಾಂಗಾಚ಼ ಕ್ಯಾ ಮಂಜೆ, ಹಿತ್ನಿ ಮೊರ‍್ಹ ಮಾನ್ಸಾಚಾ಼ ಲ್ಯೊಕ್ ದೇವಾಚೆ ಉಜ್‌ವ್ಯಾಂಗ್ನಿ ಬಸ್‌ಲ್ಯಾಲಾ ಆಬ್ಳಾಚಾ ಡಘಾವ ಬಸುನ್ ಯತ್ಯಾಲಾ ತುಮಿ ಬಗ್ನಾರ್ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","ಮುಖ್ಯ ಯಾಜಕಾನಿ ಹ್ಯ ಐಕುನ್ ಖುಬ್ ರಾಗ್ ಕರುನ್ ಆಪ್ಲ ಕಪ್ಡ ಫಾಟುನ್ ಹ್ಯೊ ಮಾನುಸ್ ದೇವಾಚೆ ಆಡ್ವ ಬೊಲ್ಲಾ. ಆಮಾನಾ ಆನಿಕ್ ಕ್ಯಾ ಗುನ್ನಾ ವ್ಹಯಿ. ಹ್ಯೊ ದೇವಾಚೆ ಆಡ್ವ ಬೊಲ್ಯಾಲಾ ತುಮಿಸ್ ಐಕ್ಲಸಾ. ");
INSERT INTO gok_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","ತುಮ್ಚಾ ನಿರ್ದಾರ್ ಕ್ಯಾ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ಯೆಹುದ್ಯಾಂಚಾನಿ, ಹ್ಯನಿ ಗುನ್ನಾ ಕೆಲ್ಯಾ ಹ್ಯೊ ಮರಾಲಾಸ್ ಪಾಯ್ಜೆ ಮನ್‍ಲ್ಹ. ");
INSERT INTO gok_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","ಮಂಗ್ ಲೊಕ ತಿಥಸ್ ಯೇಸುಚಾ ತೊಂಡಾವ ಥುಕ್ಲಿತ. ಮುಟ್‌ಕ್ಯಾನಿ ತ್ಯಲಾ ಮ್ಯಾರ್ಲಾ. ತ್ಯಚಾ ಗಾಲಾವ ಮ್ಯಾರ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ತೇ, “ಕ್ರಿಸ್ತಾ, ಆಮಾನಾ ಪ್ರವಾದನೆ ಸಾಂಗ್! ತುಲಾ ಮ್ಯಾರ್‌ಲ್ಯಾಲ ಕುನಿ? ಮನ್ಹುನ್ ಟಿಂಗಲ್ನಾ ಕಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","ಹಿಕ್ಡ ಪೇತ್ರಾ ಆಂಗ್ನಾತ್ ಬಸ್ಲಾ ಹುತ್ತಾ. ಸೇವಕಿ ಯೇಕ್ ಪೇತ್ರಾಪ ಯವುನ್, “ತುಬಿ ಗಲಿಲಾಯಾತಲ್ಯಾ ಯೇಸು ಸಂಗ ಆಸ್‌ಲ್ಯಾಲಾ” ಮನ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","ಫನ್ ಪೇತ್ರಾ, ತಿತಲ್ಯಾ ಲೊಕಾಂಚೆ ಮೊರ‍್ಹ ತಿಲಾ, “ತು ಕ್ಯಾ ಸಾಂಗ್ತೆಸ್ ತ್ಯ ಮನಾ ಠಾವ ನಾಹಿ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","ಮಂಗ್ ಪೇತ್ರಾ ತಿಥ್ನಿ ಉಠುನ್ ಮೊರ್ಲ್ಯಾ ದಾರಾತ್ ಆಲಾ ತವಾ ಆನಿ ಯೇಕ ಸೇವಕಿನಿ ತ್ಯಲಾ ಬಗುನ್ ತಿತಲ್ಯಾ ಲೊಕಾನಾ, “ಹ್ಯೊ ಮಾನುಸ್ ನಜರೇತಾತ್‌ಲ್ಯಾ ಯೇಸು ಸಂಗ ಆಸ್‌ಲ್ಯಾಲಾ” ಮನ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","ತವಾ ಪೇತ್ರಾ, “ಮಿ ದೇವಾ ಸೆಪ್ಪತ್ ಸಾಂಗ್ತೊ. ಮನಾ ಯೇಸು ಮಂಥ್ಯಾಲಾ ಮಾನುಸ್ ಕೊನ್ ಮನ್ಹುನ್ ಠಾವಾಸ್ ನಾಹಿ!” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","ಥೊಡ್ಯಾ ಯಳಾ ನಂತರ್, ತಿಥ ಉಬಿ ರಾಯ್‌ಲ್ಯಾಲಿ ಥುಡಿ ಲೊಕ ಪೇತ್ರಾಚೆ ಜ಼ವಳ ಜಾ಼ವುನ್, “ಯೇಸುಚೆ ಮಾಗ್ನಿ ಆಲ್ಯಾಲ್ಯಾ ಲೊಕಾತ್ಲಾ ತುಬಿ ಯೊಕ್ ಮನ್ಹುನ್ ತುಜಿ ಬುಲಿಸ್ ತುಲಾ ದಾವುನ್ ದೇತೆ” ಮನ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","ಪೇತ್ರಾನಿ ಸಾಂಗ್ಲ, ಮಿ ಖರ ಸಾಂಗ್ತೊ. ಜ಼ರ್ ಮಿ ಲಬಾಡ್ ಬೊಲತ್ ಆಸ್ಲೊತ ದೇವ್ ಮನಾ ಶಿಕ್ಷಾ ದಿವುನಿ. ಮನಾ ಹ್ಯೊ ಮಾನುಸ್ ಠಾವಾ ನಾಹಿ. ” ಮನ್‍ಲ್ಹಾ. ತವಾಸ್ ಕೊಂಬ್ಡಾ ಬವಾಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","ತ್ಯೊ ಮನಾ ಕೊನ್‌ ತ್ಯೊ ಠಾವಾಸ್ ನಾಹಿ ಮನ್ಹುನ್ ಕೊಂಬ್ಡಾ ಬವಾಚೆ ಆಂದಿ ತು ತೀನ್ ಖೆಪಾ ಸಾಂಗ್ನಾರ್ ಮನ್ಹುನ್ ಆಪ್‌ಲ್ಯಾಲಾ ಯೇಸುನಿ ಸಾಂಗ್‌ಲ್ಯಾಲ ಪೇತ್ರಾನಿ ಯವಜು಼ನ್ ಬಾಹಿರ್ ಜಾವುನ್ ಖುಬ್ ದುಖಾನಿ ರಡ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","ಸಕಾಳ್ಚ. ಮುಖ್ಯ ಯಾಜಕ್ ಆನಿ ಜಾಂತ್ಯಾಂಚಾನಿ ಸಗ್‌ಳ್ಯಾ ಯೇಸುಲಾ ಮಾರುನ್ ಟಾಕಾಯಾ ಯವಜ್ನಾ಼ ಕೇಲಿ. ");
INSERT INTO gok_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","ತ್ಯಂಚಾನಿ ತ್ಯಲಾ ಸಾಕ್‌ಳ್ಯಾಂಚಾನಿ ಬಾಂದುನ್ ರೊಮಾಚಾ ರಾಜಪಾಲ್ ಪಿಲಾತಾಪ ಹಾಕ್ಟುನ್ ನಿಹುನ್ ದಿಲಾ ");
INSERT INTO gok_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","ಯೇಸುಲಾ ತ್ಯಚಾ ವಾದಿಪ್ನಿ ದರುನ್ ದಿಲ್ಯಾಲಾ ಯುದ್, ಯೇಸುಲಾ ಜಾ಼ಲ್ಯಾಲ ಬಗುನ್, ಆಪ್ನು ಕೆಲ್ಯಾಲೆ ಚು಼ಕಿಸಾಟಿ ಖುಬ್ ಮನಾಲಾ ಬೇಜಾರ್ ವ್ಹವುನ್ ತ್ಯನಿ ಚಾ಼ಂದಿಚ಼ ಆನ ಮುಖ್ಯ ಯಾಜಕಾಂಚಿಪ ಆನಿ ಜಾಂತ್ಯಾಂಚಿಪ್ನಿ ನಿಹುನ್ ");
INSERT INTO gok_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“ಮಿ ಪಾಪ್ ಕೆಲ, ಚು಼ಕ್ ಕೆಲ್ಯಾ ನಸ್‌ಲ್ಯಾಲ್ಯಾಲಾ ಮಾರುನ್ ಟಾಕಾಯಾ ತುಮ್ಚಿಪ ದಿಲಾ” ಮನ್ಲಾ. ಯೇಹುದಿ ಜಾಂತ, “ತ್ಯಲಾ ಆಮಿ ಕ್ಯಾ ಕರಾವ! ತಿ ತುಜಿ ಚು಼ಕ್ ಆಮ್ಚಿ ನವ್ಹ!” ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","ತವಾ ಯುದಾನಿ ತೇ ಪೈಸ ದೇವ್ಳಾತ್ ಟಾಕುನ್ ಜಾ಼ವುನ್ ಫಾಸ್ ಲಾವುನ್ ಗೇತ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","ಮುಖ್ಯ ಯಾಜಕಾಂಚಾನಿ ದೇವ್ಳಾತ್ಲ ಪೈಸ ಗಿಹುನ್ ಹೆ ಪೈಸ ಯಕಾ ಮಾನ್ಸಾಚಾ಼ ಖುನ್ ಕರಾಯಾ ದಿಲ್ಯಾಲ ಹೆ ದೇವ್ಳಾತ್‌ಲ್ಯಾ ಪೈಶಾತ್ನಿ ಮಿಸ್ಳಾಚ಼ ಆಮ್ಚಾ ಧರ್ಮಶಾಸ್ತಾರಾಚೆ ಆಡ್ವ ಮನ್ಹುನ್ ಸಾಂಗ್‌ತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","ಮನ್ಹುನ್ ತ್ಯಂಚಾನಿ ತ್ಯಾ ಪೈಶಾನಿ ಕುಂಬಾರಾಚ಼ ಶಾತ್ ಮಂಥ್ಯಾಲಿ ಜಿಮಿನ್ ಗಿಹ್ಯಾಲಾ ತೀರ್ಮಾನ್ ಕೆಲಾ ಯೆರುಸಲೇಮಾತ್ ಪರವಾಸಾಲಾ ಆಲ್ಯಾಲಿ ಮಿಲಿತ ತ, ತ್ಯನಾ ಹ್ಯಾ ಸೇತಾತ್ ಮಾತಿ ದಿಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ತಿರ್ಮಾನ್ ಕೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","ಮನ್ಹುನ್ ತ್ಯ ಶಾತ್ ತವಾಚೆ ದರ್ನಿ ಆಜು಼ನ್ ಪರ‍್ಯಾತ್ ಘಾತ್ಕ ಶಾತ್ ಮಂಥ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","ಆಸ ಪ್ರವಾದಿ ಜಾ಼ಲ್ಯಾಲ್ಯಾ ಯೆರೆಮೀಯಾನಿ ಸಾಂಗ್‌ಲ್ಯಾಲಿ ಬುಲಿ ಘಡ್ಲಿ. ತೀ ಕ್ಯಾ ಮಂಜೆ: “ತ್ಯಂಚಾನಿ ತೀಸ್ ಚಾ಼ಂದಿಚ಼ ಆನ ಗಿಹುನ್ ಯೆಹುದ್ಯಾಂಚಾನಿ ತ್ಯಚಾ ಜೀವಾಚಿ ಕಿಮ್ಮತ್ ಕೆಲ್ಯಾಲಿ ತ್ಯವ್ಡಿಸ್. ");
INSERT INTO gok_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ಪ್ರಭುನಿ ಮನಾ ಸಾಂಗ್‌ಲ್ಯಾ ಶಾರ್ಕ ತ್ಯಂಚಾನಿ ತೀಸ್ ಚಾ಼ಂದಿಚಾ ಆನ್ಯಾನಿ ಕುಂಬಾರಾಚ಼ ಶಾತ್ ಗೇತ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","ಯೇಸುಲಾ ಪಿಲಾತಾಚೆ ಮೊರ‍್ಹ ಉಬಾ ಕೆಲಾ ಪಿಲಾತಾನಿ ತ್ಯಲಾ ತು ಯಹುದ್ಯಾಚಾ಼ ರಾಜಾ಼ ಕ್ಯಾ ಮನ್ಹುನ್ ಇಚಾರ್ಲ ಯೇಸು ವ್ಹಯ್ ತು ಸಾಂಗ್‌ಲ್ಯಾ ಶಾರ್ಕ ತ್ಯೊಸ್ ಮಿ ಮನ್ಹುನ್ ಉತ್ತರ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","ಮುಖ್ಯ ಯಾಜಕ ಆನಿ ಯೆಹುದಿ ಜಾಂತ್ಯಾಂಚಾನಿ ಯೇಸುಚಿ ಚಾ಼ಡಿ ಸಾಂಗ್ಲಿತವಾ, ತ್ಯೊ ಗಪ್ಚಿಪ್ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","ಮನ್ಹುನ್ ಪಿಲಾತಾನಿ ಯೇಸುಲಾ, “ಹ್ಯಾ ಲೊಕಾಂಚಾನಿ ತುಜಿವ ವಾವ್‌ಲ್ಯಾಲಿ ಹಿ ಚು಼ಕ್ ತು ಐಕ್‌ತ್ಯಾಲಾ ಆಸ್ಥಾನಾ ಕಾ ಬೊಲನಾಸ್? ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","ಫನ್ ಯೇಸು ಕಾಯ್ ಬೊಲಾಸ್ ನಾಹಿ. ಪಿಲಾತಾಲಾ ಖುಬ್ ಆಜಾಬ್ ವಾಟ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","ಪರತೇಕ್ ವರ್ಸಿ ಪಸ್ಕಾಚಾ ಸನಾಚಾ ಯಳಾತ್ ಲೊಕಾಂಚಾ ಮನಾ ಶಾರ್ಕ ಗುನ್ನಗಾರಾತಲ್ಯಾ ಯಕಾಲಾ ರಾಜಪಾಲಾನಿ ಸೊಡ್ವಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ತವಾಚಿ ಪದ್ದತ್ ವ್ಹತ್ತಿ. ");
INSERT INTO gok_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","ತ್ಯಾ ಕಾಲಾತ್ ಚು಼ಕ್ ಕೆಲ್ಯಾಲಾ ಮನ್ಹುನ್ ಸಗ್‌ಳ್ಯಾನಾ ಠಾವಾ ಆಸ್‌ಲ್ಯಾಲಾ ಗುನ್ನದಾರ್ ಯೊಕ್ ತುರುಂಗಾತ್ ಹುತ್ತಾ. ತ್ಯಚ಼ ನಾವ್ ಬರಬ್ಬ. ");
INSERT INTO gok_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","ಲೊಕ ಸಗ್ಳಿ ಪಿಲಾತಾಚಾ ಅಂಗ್ನಾತ್ ಜ಼ಮ್ಲಿತ. ಪಿಲಾತಾನಿ ತ್ಯನಾ ಮಿ ತುಮ್ಚಿ ಸಾಟಿ ಕಚ್ಚಾ ಗುನ್ನದಾರಾಲಾ ಸುಡ್ವು, ಬರಬ್ಬಲಾ ಕ್ಯಾ ಯೇಸು ಕ್ರಿಸ್ತಾಲಾ ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","ಯೆಹುದ್ಯ ಜಾಂತ್ಯಾಂಚಾನಿ ಖೊಟ್ಯಾ ಫನಾನಿ ಯೇಸುಲಾ ಆಪ್ಲಿಪ ದಿಲ್ಯಾ ಮನ್ಹುನ್ ಪಿಲಾತಾಲಾ ಠಾವಾ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","ಪಿಲಾತ್ ನ್ಯಾಯಿ ಕರ್ತ್ಯಾಲೆ ಖುರ್ಚಿವ ಬಸ್ಲಾ ಹುತ್ತಾ ತವಾ ತ್ಯಚೆ ದನ್ಗರಿನಿ ಯವುನ್ ಬಾತ್ನಿ ಲಾವುನ್ ದಿಲಿ. “ತ್ಯಾ ಮಾನ್ಸಾಲಾ ಕಾಯೇಕ್ ಕರು ನಕೊಸ್. ತ್ಯೊ ಚು಼ಕ್ ಕೆಲ್ಯಾಲಾ ನವ್ಹ. ಮನ್ಹುನ್ ಕ್ಯಾಲ್ಚೆ ರಾತಿ ಸಪ್ನಾತ್ ಖುಬ್ ಕಶ್ಟ ಖಾಲ್ಯಾ ಮನ್ಹುನ್ ತ್ಯ ಸಾಂಗ್ನ. ");
INSERT INTO gok_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","ಫನ್ ಮುಖ್ಯ ಯಾಜಕ್ ಆನಿ ಯೆಹುದ್ಯ ಜಾಂತ ಬರಬ್ಬಲಾ ಸೊಡ್ವಾಲಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಯೇಸುಲಾ ಮಾರುನ್ ಟಾಕಾಯಾ ವ್ಹಯಿ ಮನಾಯಾ ಲೊಕಾನಾ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","ಪಿಲಾತಾನಿ, “ತ್ಯಾ ಲೊಕಾಂಚಾನಿ ಮಿ ಕುನಾಲಾ ಸುಡ್ವು? ಬರಬ್ಬಾಲಾ ಕ್ಯಾ? ಯೇಸುಲಾ? ಮನ್ಹುನ್ ಇಚಾರ್ತೊ ತ್ಯಂಚಾನಿ ಬರಬ್ಬಾಲಾ ಮನ್ಹುನ್ ಉತ್ತರ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","ಪಿಲಾತ್ ತಸ ಜಾ಼ಲ್ಯಾ ಯೇಸು ಮನ್ಹುನ್ ಹಾಕಟ್ಯಾಲ್ಯಾ ಕ್ರಿಸ್ತಾಲಾ ಮಿ ಕ್ಯಾ ಕರು ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ಲೊಕ ಸಗ್ಳಿ ತ್ಯಲಾ ಶಿಲ್ಬೆವ ಗ್ಯಾಲ್ ಮನ್‌ಲ್ಹಿತ. ");
INSERT INTO gok_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","ಪಿಲಾತಾನಿ, ತುಮಿ ತ್ಯಲಾ ಶಿಲ್ಬೇವ ಗಾಲಾಯಾ ವ್ಹಯಿ ಕಾ ಮಂಥಾಸಾ? ತ್ಯನಿ ಕ್ಯಾ ಚು಼ಕ್ ಕೆಲೆ ಮನ್‍ಲ್ಹಾ. ಫನ್ ಲೊಕ ಸಗ್ಳಿ ತ್ಯಲಾ ಶಿಲ್ಬೆವ ಗ್ಯಾಲ್ ಮನ್ಹುನ್ ಜೊ಼ರಾನಿ ವರಾಡ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","ಲೊಕಾಂಚ಼ ಮನ್ ಪರ್ತಾಯಾ ಆಪ್‌ಲ್ಯಾಲಾ ವ್ಹಯಿತ್ ನಾಹಿ ಲೊಕ ಗದ್ಲಾ ಕರಾಚಿ ಹಾತ್ತ ಮನ್ಹುನ್ ಸಮಜು಼ನ್ ಪಿಲಾತಾನಿ ಥೊಡ ಪಾನಿ ಗಿಹುನ್ ಲೊಕಾಂಚೆ ಮೊರ‍್ಹ ಆಪ್ಲ ಹಾತ್ ದುಹಿತ್ ಹ್ಯಾ ಮಾನ್ಸಾಚಾ ಮರ್ನಾಲಾ ಮಿ ಜವಾಬ್ದಾರ್ ನವ್ಹ. ತ್ಯಲಾ ಶಿಲ್ಬೆತ್ ಗ್ಯಾಲತ್ಯಾಲಿ ತುಮಿಸ್ ಮನ್ಹುನ್ ಸಾಂಗ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","ಲೊಕ ಸಗ್ಳಿ ತ್ಯಚಾ ಮರ್ನಾಲಾ ಆಮಿಸ್ ಜವಾಬ್ದಾರ್ ತ್ಯಚಾ ಮರ್ನಾಲಾ ಕಾಯ್ ತರಿ ಶಿಕ್ಷಾ ಆಸ್ಲಿತ ತೀ ಆಮಿ ಆನಿ ಆಮ್ಚಿ ಪೊರ ಗೆಥಾವ್” ಮನ್ಹುನ್ ಉತ್ತರ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","ತವಾ ಪಿಲಾತ್ ಬರಬ್ಬಲಾ ಸುಡ್ವುನ್ ಯೇಸುಲಾ ಚಾಬುಕಾನಿ ಬಡ್ವುನ್ ಶಿಲ್ಬೆವ ಗಾಲಾಯಾ ಸೈನಿಕಾಪ್ನಿ ದೇತೊ. ");
INSERT INTO gok_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","ಪಿಲಾತಾಚಾ ಸೈನಿಕಾಂಚಾನಿ ರಾಜಾಚಾ ಗರ‍್ಹಾತ್ ಸೈನಿಕ್ ಸಗ್ಳ ಯೇಸುಚೆ ಸರ್ಬವ್ಹಾರ ಹುತ್ತ. ");
INSERT INTO gok_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","ಸೈನಿಕಾಂಚಾನಿ ತ್ಯಚ಼ ಕಪ್ಡ ಸಗ್ಳ ಕಾಡುನ್ ಟಾಕುನ್ ತ್ಯಲಾ ಯೇಕ್ ತಾಂಬ್ಡಾ ಜ಼ಘಾ ಗ್ಯಾತ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","ಕಾಟ್ಯಾಚೆ ಯಲಿನಿ ಯಾಕ್ ಕಿರಿಟ್ ಕರುನ್ ತ್ಯಚೆ ಡುಯಿತ್ ಥಿವ್ಲ ತ್ಯಚಾ ಉಜ಼ವ್ಯಾ ಹಾತಾತ್ ಯೇಕ್ ಕಾಟಿ ದಿಲಿ ಮಂಗ್ ಸೈನಿಕಾಂಚಾನಿ ಯೇಸುಚೆ ಮೊರ‍್ಹ ವಾಕುನ್ ಯೆಹುದ್ಯಾಂಚಾ ರಾಜಾ ಜಯ್ ಹೊ ಮನ್ಹುನ್ ಟಿಂಗಲ್ನಾ ಕಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","ತ್ಯಚಿವ ಥುಕ್ಲಿತ ತ್ಯಚಾ ಹಾತಾತ್ಲಿ ಕಾಠಿ ಕಾಡುನ್ ಗಿಹುನ್ ಡುಯಿವ ಮ್ಯಾರ‍್ಲಿ ");
INSERT INTO gok_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","ಆಸಿ ಹಿರ್ಮಟ್ನಾ ಕೆಲ್ಯಾ ನಂತರ್ ತ್ಯಚಾ಼ ತಾಂಬ್ಡಾ ಜ಼ಘಾ ಕಾಡುನ್ ತ್ಯಚ಼ ಕಪ್ಡ ಆನಿಕ್ ತ್ಯಲಾಸ್ ಗಾಲ್ಹುನ್ ಶಿಲ್ಬೆತ್ ಗಾಲಾಯಾ ಹಾಕ್ಟುನ್ ನೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","ಸೈನಿಕ್ ಯೇಸು ಸಂಗ ಪೆಠತ್ನಿ ಬಾಹಿರ್ ಜಾ಼ತಾನಾ ಸೀರೆನ್ ಪೆಠತ್ಲಾ ಸಿಮೊನ್ ಮಂಥ್ಯಾಲ್ಯಾ ಮಾನ್ಸಾಲಾ ಬಗ್ಲಾ ತ್ಯಚಿ ಶಿಲ್ಬೆ ಗಿಹುನ್ ಜಾ಼ಯಾಸಾಟಿ ತ್ಯಂಚಾನಿ ತ್ಯಲಾ ಬಳ್ ಕೆಲ. ");
INSERT INTO gok_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","ತೇ ಗೊಲ್ಗತಾ ಮಂಥ್ಯಾಲ್ಯಾ ಜಾ಼ಗ್ಯಾತ್ ಆಲ ಗೊಲ್ಗತಾ ಮಂಜೆ ಡುಯಿಚಾ಼ ಜಾ಼ಗಾ ಮನ್ಹುನ್ ಅರ್ಥ. ");
INSERT INTO gok_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ಗೊಲ್ಗೊತಾತ್ ಸೈನಿಕಾಂಚಾನಿ ತ್ಯಲಾ ಪಿಯಾ ದರಾಕ್ಶಿಚಾ಼ ರಸ್ ದಿಲಾ ತ್ಯಾ ದರಾಕ್ಶಿಚಾ ರಸಾಲಾ ಕಡು ಗ್ಯಾತ್ಲ. ತ್ಯನಿ ದರಾಕ್ಶಿಚಾ ರಸಾಚಿ ಚ಼ವ್ ಬಗುನ್ ತ್ಯ ಪಿಯಾಲಾ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","ಸೈನಿಕಾಂಚಾನಿ ತ್ಯಲಾ ಶಿಲ್ಬೆವ ಮೊಳ್ಹ ಮ್ಯಾರ್ಲ ಮಂಗ್ ಕಪ್‌ಡ್ಯಾಂಚಿ ಸಾಟಿ ಆಪ್‌ಲ್ಯಾತುಸ್ ಚಿಟ್ಯಾ ಗಾಲ್ಹುನ್ ಕಾಡುನ್ ಗೇತಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","ಸೈನಿಕ್ ಯೇಸುಲಾ ರಾಖಿತ್ ತಿಥಸ್ ಬಸ್ಲ ಹುತ್ತ. ");
INSERT INTO gok_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","ಯವ್ಡಸ್ ನವ್ಹ ತ್ಯಚಿವ ವಾವ್‌ಲ್ಯಾಲಿ ಚು಼ಕ್ ಲಿವುನ್ ತ್ಯಚೆ ಡುಯಿಚೆ ವರ್ ಲ್ಯಾವ್ಲಿ. “ಹ್ಯೊ ಯೇಸು, ಯೆಹುದ್ಯಾಂಚಾ಼ ರಾಜಾ಼” ಮಂಥ್ಯಾಲಿಸ್ ತೀ ಚು಼ಕ್. ");
INSERT INTO gok_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","ಯೇಸುಚೆ ಕಡಸ್ ದೊಗಾ ಚೊ಼ರಾನಾ ಶಿಲ್ಬೆತ್ ಗ್ಯಾತ್ಲ ಯಕಾ ಚೊ಼ರಾಲಾ ಯೇಸುಚೆ ಉಜ್‌ವ್ಯಾಂಗ್ನಿ ಆನಿಯಕಾ ಚೊ಼ರಾಲಾ ಯೇಸುಚೆ ಡಾವ್ಯಾಂಗ್ನಿ ಗ್ಯಾತ್ಲಾ ");
INSERT INTO gok_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","ವಾಟನಿ ಜಾ಼ತ್ಯಾಲಿ ಲೊಕ ಡುಯಿ ಹಾಲ್ವಿತ್, ");
INSERT INTO gok_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“ತು ದೀವುಳ್ ಪಾಡುನ್ ತ್ಯ ಆನೀಕ್ ತಿನ್ವೆ ದೀಸಿ ಬ್ಯಾಂತೊ ಮನ್ಹುನ್ ಸಾಂಗಿತಾಸ್ ಖರ ಆತಾ ತುಲಾಸ್ ತು ರ‍್ಯಾಕ್ ತು ಖರ‍್ಯಾನಿಸ್ ದೇವಾಚಾ಼ ಲ್ಯೊಕ್ ಆಸ್ಲಾಸ್ತ ಶಿಲ್ವಬೆವ್ನಿ ಖಾಲ ಉತ್ರುನ್ ಯೇ ಮನ್ಹುನ್ ಹಿರಮಟ್ನಾ ಕಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","ಮುಖ್ಯ ಯಾಜಕ್ ಧರ್ಮೊಪದೇಶ್ ಆನಿ ಥೊರ್ಲ ವಡಿಲ್ ಯೆಹುದಿ ಜಾಂತ ತಿಥ ಹುತ್ತ ಹ್ಯಂಚಾನಿ ಸಾಹಿತ್ ದುಸ್‌ರ‍್ಯಾ ಲೊಕಾಂಚೆಗತ್ ಯೇಸುಚಿ ಹಿರ್ಮಟ್ನಾ ಕಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","ಹ್ಯನಿ ದುಸ್‌ರ‍್ಯಾನಾ ರ‍್ಯಾಕ್ಲ. ಫನ್ ಆಪ್‌ಲ್ಯಾ ಆಪ್ನು ರಾಖಾಯಾ ಜಾ಼ಲ ನಾಹಿ! ಇಸ್ರಾಯಲಚಾ಼ ರಾಜಾ಼ ಮನ್ಹುನ್ ಲೊಕ ಸಾಂಗ್‌ತ್ಯಾತ. ಹ್ಯೊ ರಾಜಾ಼ ಆಸ್ಲಾತ ಶಿಲ್ಬೆವ್ನಿ ಖಾಲ್‍ ಉತ್ರುನ್ ಯವುನಿ ತವಾ ಹ್ಯಚಿವ ಆಮಿ ಇಸ್ವಾಸ್ ಥೆವ್ತಾವ್!. ");
INSERT INTO gok_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","ಹ್ಯೊ ದೇವಾವ ಆದಾರ್ ವ್ಹವುನ್ ಹಾ. ಆತಾ ದೇವಾಲಾ ಖರ‍್ಯಾನಿಸ್ ಹ್ಯೊ ವ್ಹಯಿ ಜಾ಼ಲಾ ಆಸ್ಲಾತ, ದೇವುಸ್ ಹ್ಯಲಾ ರಾಖುನಿ. ‘ಮಿ ದೇವಾಚಾ಼ ಲ್ಯೊಕ್’ ಮನ್ಹುನ್ ಹ್ಯನಿಸ್ ಸಾಂಗ್‌ಲ್ಯಾ ನವ್ಹ” ಮನ್ಹುನ್ ತ್ಯಂಚಾನಿ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","ತಸಸ್ ಯೇಸುಚೆ ಆಜು಼ಬಾಜು಼ಸ್ ಶಿಲ್ಬೆತ್ ಗ್ಯಾತ್‌ಲ್ಯಾಲ್ಯಾ ಚೊ಼ರಾಂಚಾನಿ ಬಿ ತ್ಯಚಿ ನಿಂದಾಕಿಲಿ ");
INSERT INTO gok_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","ತವಾ ದುಪ್ಯಾರ್ಚ಼ ಬಾರಾ ಠ್ಹಾವ್ನಿ ತೀನ್ ವಾಜ಼ ಪರೆತ್ ದುನೆವ ಸಗ್ಳೆ ಆಂದಾರಿ ಆಲ್ತಿ. ");
INSERT INTO gok_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","ಜ಼ವ ಜ಼ವಳ್ ತೀನ್ ವಾಸ್ಥಾನಾ ಯೇಸು, “ಏಲೀ, ಏಲೀ, ಲಮಾ ಸಬಕ್ತಾನಿ?” ಮನ್ಹುನ್ ಜೊ಼ರಾನಿ ವರಾಡ್ಲಾ ಆಸ ಮಂಜೆ ಮಾಜಾ ದೇವಾ ಮಾಜಾ ದೇವಾ ಕಾ ಮನಾ ಹಾತ್ ಸುಡುನ್ ದಿಲಾಸ್ ಮನ್ಹುನ್ ಅರ್ಥ. ");
INSERT INTO gok_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","ತಿಥ ಉಬಿ ರಾಯ್‌ಲ್ಯಾಲಿ ಥುಡಿ ಲೊಕ, “ಹ್ಯ ಐಕುನ್ ಹ್ಯೊ ಎಲಿಯಾಲಾ ಹಾಕಟ್ಯೊ” ಮಂತೊ. ");
INSERT INTO gok_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","ತವಾಸ್ ತಿತ್ಲಾ ಯೊಕ್ ಮಾನುಸ್ ಪಳತ್ ಜಾ಼ವುನ್ ಕಾಪುಸ್ ಆನುನ್, ತ್ಯೊ ಆಂಬಾಟ್ ರಸಾತ್ ಬುಡ್ವುನ್, ತೇ ಯಕ ಕಾಟಿಚಾ ಟೊಕಾಲಾ ಬಾಂದುನ್ ಯೇಸುಲಾ ಪಿಯಾ ದೆತೊ. ");
INSERT INTO gok_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","ಫನ್ ದುಸ್ರಿ ಲೊಕ ತ್ಯಚಿ ಕ್ಯಾಳ್ಜಿ ಕರುನಕೊ ತ್ಯಲಾ ಉರ್ವಾಯಾ ಎಲಿಯಾ ಯತ್ಯೊ ಕ್ಯಾ ಬಗುಯಾ ಮನ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","ಮಂಗ್ ಯೇಸು ಆನಿಕ್‍ ಜೊ಼ರಾನಿ ವರ್ಡುನ್ ಜೀವ್ ಶೊಡ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","ತವಾ ದೇವ್ಳಾಚಾ಼ ಪಡ್ದಾ ವಯ್ನಿ ದರ್ನಿ ಖಾಲ್ ಪರೆತ್ ಫಾಟುನ್ ದೊನ್ ಜಾ಼ಲ. ಜಿಮಿನ್ ಹಾಲ್ಲಿ. ದುಂಡಿ ಫುಟುನ್ ಗೆಲ್ಯಾ ");
INSERT INTO gok_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ಮಸುರ್ಡ್ಯಾ ಉಗಾಡ್‌ಲ್ಯಾ ಮರುನ್ ಗೆಲ್ಯಾಲಿ ದೇವಾಚಿ ಲೊಕ ಮಸುರಡಿತ್ನಿ ಜಿತ್ತಿ ವ್ಹವುನ್ ವರ್ ಉಟ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ಯೇಸು ಮರುನ್ ಜಿತ್ತಾ ಜಾ಼ಲ್ಯಾ ನಂತರ್, ತೀ ಪರಿಶುದ್ದ ಶಾರ್ ಜಾಲ್ಯಾಲೆ ಯೆರುಸಲೇಮತ್ ಗಿಲಿತ ಲೊಕಾಂಚಾನಿ ತ್ಯನಾ ಡೊಳ್ಯಾನಿ ಬಗ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","ಯೇಸುಲಾ ರ‍್ಯಾಕ್‌ತ್ಯಾಲಾ ಸೈನ್ಯಾಧಿಪತಿ ಆನಿ ಸೈನಿಕ್ ಭುಕಂಪ್ ಜಾ಼ಲ್ಯಾಲ ಬಗುನ್ ಖುಬ್ ಬಿಹುನ್, “ಹ್ಯೊ ಖರ‍್ಯಾನಿಸ್ ದೇವಾಚಾ಼ ಲ್ಯೊಕ್ ಜಾ಼ಲ್ಥಾ!” ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","ಯೇಸುಚಿ ಸೇವಾ ಕರೀತ್ ಗಲಿಲಾಯಾತ್ನಿ ತ್ಯಚೆ ಮಾಗ್ನಿ ಆಲ್ಯಾಲಿ ಖುಬ್ ಬ್ಯಾಯ್ಕಾ ಮಾನ್ಸ ದುರ್ನಿ ಬಗಿತ್ ಉಬಿ ರಾಯ್ಲಿ ಹುತ್ತಿತ. ");
INSERT INTO gok_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","ಮಗ್ದಲಾಚಿ ಮರಿಯಾ, ಯಾಕೊಬ್ ಆನಿ ಯೊಸೆಪಾಚಿ ಆಯಿ ಮರಿಯಾ, ಆನಿ ಜೆಬೆದಾಯಾಚಿ ಧನ್ಗರ್ ತಿಥ ಹುತ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","ತೇ ಸಾಂಜ಼ ಯೊಸೆಪ್ ಮಂಥ್ಯಾಲಾ ಸಾವ್ಕೋರ್ ಮಾನುಸ್ ಆಲಾ. ಅರಿಮತಾಯಾ ಪೆಠತ್ಲಾ ಹ್ಯೊ ಯೇಸುಚಾ಼ ಶಿಶಾ ಜಾ಼ಲ್ಥಾ. ");
INSERT INTO gok_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","ಹ್ಯೊ ಪಿಲಾತಾಪ ಜಾ಼ವುನ್, ಯೇಸುಚ಼ ಮಡ ಆಪ್‌ಲ್ಯಾಲಾ ದಿಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಮಾಗ್ಲ. ಯೇಸುಚ಼ ಮಡ ಯೊಸೆಪಾಲಾ ದೆವಾ ಮನ್ಹುನ್ ಪಿಲಾತಾನಿ ಸೈನಿಕಾನಾ ಹುಕುಮ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","ಯೊಸೆಪಾನಿ ತ್ಯಚ಼ ಮಡ ಗಿಹುನ್ ನವ್ಯಾ ಕಪ್ನಾಚಾ ಕಪ್‌ಡ್ಯಾನಿ ಬಾಂದುನ್. ");
INSERT INTO gok_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ದುಂಡಿತ್ ಆಪ್ನು ಖ್ಯಾಂದ್‌ಲ್ಯಾಲೆ ನವೆ ಮಸುರ್ಡಿತ್ ಥೆವ್ಲ. ಮಸುರ್ಡಿಚಾ ದಾರಾವ ಯೊಕ್ ಮೊಟಾ ದೊಂಡಾ ಡಕ್ಲುನ್ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","ಮಗ್ದಲಾಚಿ ಮರಿಯಾ ಆನಿ ಆನಿಯೇಕ್ ಮರಿಯಾ ತೇ ಮಸುರ್ಡಿಕ್ಡ ಪರ್ತುನ್ ಬಸ್‍ಲ್ಯಾ ಹುತ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","ದುಸ್ರೆ ದಿಸಿ ಆರಾಮಾಚಾ ದಿಸಾ ದಿಸಿ ಮುಖ್ಯ ಯಾಜಕ್ ಆನಿ ಫರಿಸಾಯ್ ಪಿಲಾತಾಪ ಜಾ಼ವುನ್, ");
INSERT INTO gok_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","“ಮಾಸ್ಥರಾ, ತ್ಯೊ ಲಬ್ಡಾ ಜಿತ್ತಾ ಹುತ್ತಾ ತವಾ, ‘ತೀನ್ ದಿಸಾ ನಂತರ್ ಮಿ ಮರುನ್ ತೀನ್ ದಿಸಾಚೆ ನಂತರ್ ಜಿತ್ತಾ ವ್ಹನಾರ್’ ಮನ್ಹುನ್ ಸಾಂಗ್‌ಲ್ಯಾಲ ಆಮಾನಾ ಆಜು಼ನ್ ಯಾದ್ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","ಮನ್ಹುನ್ ತೀನ್ ದಿಸಾ ಪರ‍್ಯಾತ್ ತೀ ಮಸುರ್ಡಿ ಚಾ಼ಂಗ್ಲಿ ರಾಖಾಯಾ ಸಾಂಗ್ ತ್ಯಚ಼ ಶಿಶಾ ಯವುನ್ ತ್ಯಚ಼ ಮಡ ಚು಼ರುನ್ ನಿಹುನ್ ತ್ಯೊಸ್ ಮಸುರ್ಡಿತ್ನಿ ವರ್ ಉಠುನ್ ಆಲ್ಯಾ ಮನ್ಹುನ್ ಲೊಕಾನಾ ಸಾಂಗ್ತಿಲ. ತವಾ ಪೈಲ್ಯಾವ್ನಿ ಆತಾ ಮೊಟಾ ಗೊಠಾಳಾ ವ್ಹಯಿಲ್” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","ಪಿಲಾತಾನಿ, “ಥೊಡ್ಯಾ ಸೈನಿಕಾನಾ ಹಾಕ್ಟುನ್ ನಿಹುನ್, ತುಮಾನಾ ವ್ಹಯಿ ತಸಿ ಮಸುರ್ಡಿ ರಾಖಾ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","ತ್ಯಂಚಾನಿ ಜಾ಼ವುನ್, ಮಸುರ್ಡಿಲಾ ಸಿಕ್ಕಾ ಮಾರುನ್ ಸೈನಿಕಾನಾ ರಾಖಾಯಾ ಥಿವುನ್, ಮಸುರ್ಡಿ ಘಟ್ ಕಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","ಆರಾಮಾಚಾ಼ ದೀಸ್ ಸರ್ಲಾ ಹುತ್ತಾ. ಐತ್ವಾರಿ ಉಜ್ಡಾಚ಼ ಹುತ್ತ. ತವಾ ಮಗ್ದಲಾಚಿ ಮರಿಯಾ ಆನಿ ದಿಸ್ರಿ ಯೇಕ್ ಮರಿಯಾ ಮಸುರ್ಡಿ ಬಗಾಯಾ ಗೆಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","ತವಾಸ್ ಮೊಟ ಭುಕಂಪ ಜಾ಼ಲ. ಪ್ರಭುಚಾ಼ ಧುತ್ ಯೊಕ್ ಆಬ್ಳಾತ್ನಿ ಉತ್ರುನ್ ಆಲಾ. ತ್ಯೊ ದೇವ್ ಧುತ್ ಮಸುರ್ಡಿಪ ಜಾ಼ವುನ್, ಮಸುರ್ಡಿಚಾ ದಾರಾವ್ಲಾ ದೊಂಡಾ ಗೊಲ್ಗಟುನ್ ತೇ ದುಂಡಿವ ಬಸ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","ದೇವ್ ದುತ್ ಇಜ಼ಚೆಗತ್ ಚ಼ಕ್ಮಕಿತಾ ತ್ಯಚ಼ ಕಪ್ಡ ಬರ್ಪಾಚೆಗತ್ ಪಾಂಡ್ರ ಹುತ್ತ. ");
INSERT INTO gok_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","ಮಸುರ್ಡಿ ರ‍್ಯಾಖ್‌ತ್ಯಾಲ ಸೈನಿಕ್ ಬಿಹುನ್ ವಾಡತ್ ಮೆಲ್ಯಾಚೆಗತ್ ಜಾ಼ಲ. ");
INSERT INTO gok_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","ದೇವ್ದುತ್ ತ್ಯಾ ಬ್ಯಾಯ್ಕಾ ಮಾನ್ಸಾನಾ, “ಬಿಹುನಕೋಸಾ, ಶಿಲ್ಬೆವ ಚ಼ಡಿವ್‌ಲ್ಯಾಲ್ಯಾ ಯೇಸುಲಾ ತುಮಿ ಶೊತ್ಯಾಸಾ ಮನ್ಹುನ್ ಮನಾ ಸಮಾಜ್‌ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","ಫನ್ ತ್ಯೊ ಹಿತ್ತ ನಾಹಿ. ತ್ಯನಿ ಆಪ್ನು ಸಾಂಗ್‌ಲ್ಯಾ ಶಾರ್ಕ ಮೆಲ್ಯಾಲ್ಯಾತ್ನಿ ಉಟ್‌ಲ್ಯಾ. ಯವಾ, ತ್ಯಚ಼ ಮಡ ಆಸ್‌ಲ್ಯಾಲಾ ಜಾ಼ಗಾ ಬಗಾ. ");
INSERT INTO gok_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","ಬಿಗಿನಿ ಜಾ಼ವುನ್ ತ್ಯಚಾ ಶಿಶಾನಾ, ‘ಯೇಸು ಮರ್ನಾತ್ನಿ ಜಿತ್ತಾ ಜಾ಼ಲ್ಯಾ. ತ್ಯೊ ಗಲಿಲಾಯಾಕ್ಡ ಜಾ಼ಯಾ ಲಾಗ್‌ಲ್ಯಾ. ತುಮ್ಚೆ ಆಂದಿ ತ್ಯೊ ತಿಥ ರಾನ್ಹಾರ್. ತುಮಿ ತ್ಯಲಾ ತಿಥ ಬಗ್ನಾರ್’ ಮನ್ಹುನ್ ಸಾಂಗಾ. ಮಿ ತುಮಾನಾ ಸಾಂಗಾಯಾ ವ್ಹಯಿತಿ ಬಾತ್ನಿ ಹಿಸ್, ಇಸ್ರು, ನಕೊಸಾ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","ತವಾಸ್ ತೀ ಬ್ಯಾಯ್ಕಾ ಮಾನ್ಸ ಭ್ಯಾನಿ ಸಂತೊಶಾನಿ ಮಸುರ್ಡಿತ್ನಿ ನಿಗಾಲಿತ ಜಾ಼ಲ್ಯಾಲಿ ಖನ್ಕತ್ ಶಿಶಾನಾ ಸಾಂಗಾಯಾ ತ್ಯಾ ಪಳತ್ ಜಾ಼ತಾನಾ, ");
INSERT INTO gok_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","ಯೇಸು ತ್ಯನಾ ಆಚಾನಕ್ ಮೊರ‍್ಹ ದಿಸುನ್, ತುಮಾನಾ ಬರ ವ್ಹವುನಿ ಮನ್‍ಲ್ಹಾ. ತವಾ ತಿ ಬ್ಯಾಯ್ಕಾ ಮಾನ್ಸ ಯೇಸುಪ ಜಾ಼ವುನ್, ತ್ಯಚ಼ ಪ್ಯಾ ದರ‍್ಹುನ್ ತ್ಯಲಾ ವವ್ಯಾಳ್ಳಾ. ");
INSERT INTO gok_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","ಯೇಸು ತ್ಯಾ ಬ್ಯಾಯ್ಕಾ ಮಾನ್ಸಾನಾ, “ಬಿಹುನಕೋಸಾ, ಮಾಜಾ ಬಾವ್ಹಾಂಚಿಪ್ನಿ ಜಾ಼ವುನ್ ಗಲಿಲಾಯಾತ್ ಯಯಾಲಾ ಸಾಂಗಾ ತೇ ಮನಾ ತಿಥ ಬಗುಂತ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ ");
INSERT INTO gok_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","ತೀ ಬ್ಯಾಯ್ಕಾ ಮಾನ್ಸ ಶಿಶಾನಾ ಸಾಂಗಾಯಾ ಗೆಲ್ಯಾ. ತವಾ ತಿಥ ಮಸುರ್ಡಿ ರ‍್ಯಾಕ್‌ಥ್ಯಾಲ ಥೊಡ ಸೈನಿಕ್ ಪೆಠತ್ ಜಾ಼ವುನ್ ಜಾ಼ಲ್ಯಾಲಿ ಖನ್ಕತ್ ಸಗ್ಳಿ ಮುಖ್ಯ ಯಾಜಕಾನಾ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","ತವಾ ಮುಖ್ಯ ಯಾಜಕ್ ಜಾ಼ಂತ್ಯಾ ಯೆಹುದ್ಯಾನಾ ಮಿಳುನ್ ಇಚಾರ್ ಕೆಲಾ ಆನಿ ರ‍್ಯಾಕ್ನಾರ‍್ಯಾನಾ ಖುಬ್ ಪೈಸ ದಿಲ. ");
INSERT INTO gok_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ತ್ಯಂಚಾನಿ ರ‍್ಯಾಕ್ನಾರ‍್ಯಾನಾ ರ‍್ಯಾಚ಼ ಆಮಿ ನಿಜ್ಲಾ಼ವ್ ತವಾ ಯೇಸುಚಾ ಶಿಶಾಂಚಾನಿ ಯವುನ್ ತ್ಯಚ಼ ಮಡ ಚು಼ರುನ್ ನೆಲ ಮನ್ಹುನ್ ಲೊಕಾನಾ ಸಾಂಗಾ. ");
INSERT INTO gok_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","ಹ್ಯ ರಾಜಪಾಲಾಲಾ ಠಾವ ಜಾ಼ಲ್ಹತರಿ ಆಮಿ ತ್ಯಲಾ ಥಾಂಬಿವ್ತಾವ್ ಆನಿ ತುಮಿ ಕಾಯ್ ಕ್ಯಾಳ್ಜಿ ಗಿಹುನಕೊಸಾ ಆಮಿ ಬಗ್ತಾವ್” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","ಸೈನಿಕಾಂಚಾನಿ ಪೈಸ ಗಿಹುನ್, ತ್ಯಂಚಾನಿ ಸಾಂಗ್ಲ ತಸ ಕೆಲ. ಮನ್ಹುನ್ ಹಿ ಲಬಾಡ್ ಕಥಾ ಆಜು಼ನ್ ಪರೆತ್ ಯೆಹುದ್ಯಾತ್ನಿ ಪಗಾಳ್ಳೆ. ");
INSERT INTO gok_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","ಆಕ್ರಾ ಜಾ಼ನ್ ಶಿಶಾ ಗಲಿಲಾಯಾತ್ ಜಾ಼ವುನ್ ಯೇಸುನಿ ಸಾಂಗ್‌ಲ್ಯಾಲ್ಯಾ ಕನ್ಯಾವ ಗೆಲ. ");
INSERT INTO gok_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","ಶಿಶಾಂಚಾನಿ ಕನ್ಯಾವ ಯೇಸುಲಾ ಬಗುನ್ ತ್ಯಲಾ ವವ್ಯಳಾ ಖರ ಥೊಡ್ಯಾ ಶಿಶಾಂಚಾನಿ ತ್ಯಚಾ಼ ಇಸ್ವಾಸ್ ಕೆಲಾ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","ಮನ್ಹುನ್ ಯೇಸು ತ್ಯಂಚಿಪ ಯವುನ್ ಸ್ವರ್ಗಾವ ಆನಿ ದರ್ಥಿವ ಸಗ್ಳಾ ಅಧಿಕಾರ್ ಮನಾ ದಿಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","ಮನ್ಹುನ್ ತುಮಿ ಜಾ಼ವುನ್, ದುನೆತ್ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ಸರ್ವೆ ಭಾಷೆಚಾ ಲೊಕಾನಾ ಮಾಜ಼ ಶಿಶಾ ಕರಾ. ಬಾಚಾ, ಲೇಕಾಚಾ ಆನಿ ಪವಿತ್ರಾತ್ಮಾಚಾ ನಾವಾನಿ ತ್ಯನಾ ಸಗ್‍ಳ್ಯಾನಾ ಬಾಪ್ತಿಸ್ಮಾ ದೇವಾ. ");
INSERT INTO gok_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ಮಿ ತುಮಾನಾ ಸಾಂಗ್‌ಲ್ಯಾಲ ಸಗ್ಳ ಲೊಕಾನಾ ಸಾಂಗಾ, ಆನಿ ದುನ್ಯಾ ಸರಪರ‍್ಯಾತ್ ಖಾಯಿಮ್, ಮಿ ತುಮ್ಚಿ ಸಂಗ ರಾಥೊ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ.");
INSERT INTO gok_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","ದೇವಾಚಾ಼ ಲ್ಯೊಕ್ ಯೇಸು ಕ್ರಿಸ್ತಾಚಿ ಚಾ಼ಂಗ್ಲಿ ಖಬರ್ ಸುರುಜಾ಼ಲ್ಯಾಲಿ. ");
INSERT INTO gok_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","ದೇವ್ ಸಾಂಗ್ತೋ “ಬಗ್ ಮಿ ಮಾಜಾ಼ ಸಾಂಗ್ ಸಾಂಗ್ನಾರ‍್ಯಾಲಾ ತುಜೆ ಮೋರ್ಹ ಲಾವುನ್ ದೇತೊ; ");
INSERT INTO gok_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","ತು ಜಾ಼ತ್ಯಾಲಿ ವಾಟ್ ತ್ಯೊ ಶಾರ್ಕಿ ಕರ್ನಾರ್” ಪ್ರಬುಚಾ಼ ಮಾರ್ಗ ತಯಾರ್ ಕರಾ; ತ್ಯಚಾ಼ ರಸ್ಥಾ ಶಾರ್ಕಾ ಕರಾ” ಮನ್ಹುನ್ ರಾನಾತ್ ವರಾಡ್‌ ತ್ಯಾಲಾ ಸಬ್ದ ಹಾ” ಮನ್ಹುನ್. ");
INSERT INTO gok_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","ಯೆಶಾಯ್ ಪ್ರವಾದಿಚಾ ಗ್ರಂಥಾತ್ ಲಿವ್‌ಲ್ಯಾ ಶಾರ್ಕ ಬಾಪ್ತಿಸ್ಮಾ ಯೊಹಾನ್ ಯವುನ್ ಲೊಕಾನಾ “ತುಮಿ ತುಮ್ಚಾ ಪಾಪಾಂಚಿ ಸಾಟಿ ಪಶ್ಚಾ ತಾಪಾನಿ ದೇವಾಕ್ಡ ಪರ್ತುನ್ ಬಾಪ್ತಿಸ್ಮಾ ಗಿಹ್ಯಾ ವ್ಹಯಿ ತವಾ ದೇವ್ ತುಮ್ಚಿ ಪಾಪ ಮಾಪಿ ಕರಿಲ್ ಮನ್ಹುನ್ ಸಗ್‌ಳ್ಯಾನಾ ಸಾಂಗಿತ್ ಬಾಪ್ತಿಸ್ಮಾ ದಿಯಿತ್ ರಾನಾತ್ ಹುತ್ತಾ ");
INSERT INTO gok_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","ತವಾ ಯುದಾಯಾ ಸಿಮತ್ಲಿ ಯೆರುಸಲೇಮಿತ್ಲಿ ಸಗ್ಳಿ ಲೊಕ ತ್ಯಚಿಪ ಜಾ಼ವುನ್ ಆಪ್ಲಿ ಆಪ್ಲಿ ಪಾಪ ಸಾಂಗುನ್ ಯೊರ್ದಾನ್ ನ್ಹತ್ ಯೊಹಾನಾಪ್ನಿ ಬಾಪ್ತಿಸ್ಮಾ ಗಿಹಿತಿತ. ");
INSERT INTO gok_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","ಹ್ಯೊ ಯೊಹಾನ್ ಹುಟಾಚಾ ಕೆಸಾಂಚ಼ ಕಪ್ಡ ಗಾಲಿತಾ ಕಂಬ್ರಲಾ ಚ಼ಮ್‌ಡ್ಯಾಚಾ಼ ಪಟ್ಟಾ ಬಾಂದಿ; ಪೊಟಾಲಾ ಟ್ವಾಳ್ ಆನಿ ರಾನಾತ್ಲ ಮಹು ಖಾಯಿ. ");
INSERT INTO gok_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","ತ್ಯೊ “ಮಾಜಿ಼ವ್ನಿ ಥೊರ್ಲಾ ಮಾಜೆ ಮಾಗ್ನಿ ಯನಾರ್; ತ್ಯಚೆ ವ್ಹಾನಚಾ಼ ಪಟ್ಟಾ ವಾಕುನ್ ಸೊಡಾಯಾ ಮಿ ಚಾ಼ಂಗ್ಲಾ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","ಮಿ ತುಮಾನಾ ಪಾನ್ಯಾನಿ ಬಾಪ್ತಿಸ್ಮಾ ದಿಲಿ; ತ್ಯೊ ತುಮಾನಾ ದೇವಾಚಾ ಆತ್ಮಾಚಿ ಬಾಪ್ತಿಸ್ಮಾ ಗ್ಯಾಲ್ನಾರ್” ಮನ್ಹುನ್ ಸಗ್‌ಳ್ಯಾನಾ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","ತ್ಯಾ ದಿಸಾದಿಸಿ ಯೇಸು ಗಲಿಲಾಯ್ ಸಿಮತ್ ಮಿಸಾಳ್ಯಾಲ್ಯಾ ನಜ಼ರೆತ್ ಮಂಥ್ಯಾಲ್ಯಾ ಗಾವಾತ್ನಿ ಯವುನ್ ಯೊರ್ದಾನ್ ನ್ಹತ್ ಯೊಹಾನಾಪ್ನಿ ಪವಿತ್ರ ಬಾಪ್ತಿಸ್ಮಾ ಗೆತ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","ಗೆತಲ್ಯಾ ಬರ್ಬರ್ ಯೇಸು ಪಾನ್ಯಾತ್ನಿ ವರ್ ಯತಾನಾ ಸ್ವರ್ಗಾತ್ನಿ ದೇವಾಚ಼ ಆತ್ಮ ಕವ್‌ಡ್ಯಾಚೆಗತ್ ಆಪ್ಲಿ ವರ್ ಉತ್ರುನ್ ಯತ್ಯಾಲ ಯೇಸುನಿ ಬಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","ತವಾ ಸ್ವರ್ಗಾತ್ನಿ ಆಸ ಸಬ್ದ ಆಲಾ, “ತು ಮಾಜಾ಼ ಮಾಯೆಚಾ಼ ಲ್ಯೊಕ್ ಮಿ ತುಲಾ ವಪ್ಲೊ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","ತವಾಸ್ ಯೇಸು ದೇವಾಚಾ ಆತಮ್ಯಾಚಾ ಸಾಂಗ್‌ನ್ಯಾನಿ ರಾನಾತ್ ಗಾಲ್ಹಿವ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ತ್ಯೊ ಚಾಳಿಸ್ ದಿಸ್ ರಾನಾತ್‌ಲ್ಯಾ ಜ಼ನಾವಾರಾಂಚೆ ಸಂಗ ರಾಯ್ಲಾ ತವಾ ಸೈತಾನ್ ತ್ಯಲಾ ಪಾಪಾತ್ ಪಾಡಾಯಾ ಬಗಿತಾ ಖರ ಯೇಸು ಪಾಪಾತ್ ಪಡ್ಲಾ ನಾಹಿ; ತವಾ ದೇವ್ದುತಾಂಚಾನಿ ಯವುನ್ ತ್ಯಚಿ ಸೇವಾ ಕೆಲಿ. ");
INSERT INTO gok_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","ಯೊಹಾನಾಲಾ ಕ್ಯೋಂಡಲ್ಯಾ ನಂತರ್ ಯೇಸು ಗಲಿಲಾಯ್ ಸಿಮತ್ ಯವುನ್ “ಕಾಲ್ ಗೆಲ. ದೇವಾಚ಼ ರಾಜೆ ಜ಼ವಳ್ ಆಲ. ");
INSERT INTO gok_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“ಕಾಲ್ ಗೆಲ. ದೇವಾಚ಼ ರಾಜೆ ಜ಼ವಳ್ ಆಲ. ತುಮ್ಚಾ ಪಾಪಾಂಚಿ ಸಾಟಿ ಪಶ್ಚಾತಾಪಾನಿ ದೇವಾಕ್ಡ ಪರ್ತಾ ಚಾ಼ಂಗ್ಲೆ ಖಬ್ರಿವ ಇಸ್ವಾಸ್ ಥೇವಾ” ಮನ್ಹುನ್ ದೇವಾಚಿ ಚಾ಼ಂಗ್ಲಿ ಖಬರ್ ಸಗ್‌ಳ್ಯಾನಾ ಸಾಂಗ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","ತವಾ ಯೇಸು ಗಲಿಲಾಯ್ ಸಮಿಂದೋರಾಕ್ಡ ಜಾ಼ತಾನಾ ಸಿಮೊನ್ ಆನಿ ತ್ಯಚಾ಼ ಬಾಹು ಆಂದ್ರೇಯ್ ಸಮಿಂದೋರಾತ್ ಮಾಶಾಂಚಿ ಜಾ಼ಳಿ ಗ್ಯಾಲಥ್ಯಾಲ ದಿಸ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","ಯೇಸು ತ್ಯನಾ “ಮಾಜೆ಼ ಮಾಗ್ನಿ ಯವಾ; ತುಮಿ ಲೊಕಾನಾ ದೇವಾಸಾಟಿ ಹಾಕಟ್ಯಾಲ ಕರ್ತೊ” ಮನ್ಲಾ ");
INSERT INTO gok_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","ಮನಲ್ಯಾ ಬರ್ಬರ್ ತೇ ಆಪ್ಲಿ ಜಾ಼ಳಿ ಸುಡುನ್ ತ್ಯಚೆ ಮಾಗ್ನಿ ಗೆಲ. ");
INSERT INTO gok_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","ಆನಿ ಜ಼ರಾ ಮೊರ‍್ಹ ಗೆಲಾ ತವಾ ಜೆಬೆದಾಯಾಚಾ಼ ಲ್ಯೊಕ್ ಯಾಕೊಬ್ ಆನಿ ತ್ಯಚಾ಼ ಬಾಹು ಯೊಹಾನ್ ದಿಸ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","ತವಾಸ್ ತ್ಯನಾ ಯೇಸುನಿ ಹಾಕಟ್ಲ. ತವಾ ತ್ಯಂಚಾನಿ ಆಪಲ್ಯಾ ಬಾಲಾ ಜೆಬೆದಾಯಾಚಾ ಕಾಮಾಚಾ ಮಾನ್ಸಾಂಚಿಪ ವ್ಹಡಿತ್ ಸುಡುನ್ ತ್ಯಚೆ ಮಾಗ್ನಿ ಗೆಲ. ");
INSERT INTO gok_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","ಯೇಸು ಆನಿ ತ್ಯಚ಼ ಶಿಶಾ ಕಪೆರ್ನೌಮ ಗಾವಾತ್ ಗೆಲ ಆನಿ ಯತ್ಯಾಲ್ಯಾ ಸಬ್ಬತ್ ದಿಸಾತ್ ಯೇಸುನಿ ಸಬಾ ಸ್ತಾನಾತ್ ಉಪದೆಶ್ ಕೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","ಲೊಕ ತ್ಯಚಾ಼ ಉಪದೆಶ್ ಐಕುನ್ ಆಜಾಬ್ ಜಾ಼ಲಿತ; ಕಾ ಮನ್‌ಲ್ಯಾವ ತ್ಯೊ ಮೋಸೆಚ಼ ದರ್ಮ ಶಾಸ್ತಾರ್ ಠಾವ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ಕ್ಯಾಯ್ದದಾರಾಂಚೆಗತ್ ಸಾಂಗಾಚ಼ ಸುಡುನ್ ಹುಕುಮ್ ಆಸ್‌ಲ್ಯಾಚೆಗತ್ ತ್ಯನಾ ಸಾಂಗ್ಲ ");
INSERT INTO gok_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","ತವಾ ಲಾಗಿರ್ ಲಾಗ್‌ಲ್ಯಾಲಾ ಯೊಕ್ ಮಾನುಸ್ ಸಬಾ ಸ್ತಾನಾತ್ ಯವುನ್ ಜೊ಼ರಾನಿ. ");
INSERT INTO gok_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","ತ್ಯೊ “ನಜ಼ರೆತಿಚಾ಼ ಯೇಸು, ಆಮ್ಚಿಪ್ನಿ ತುಲಾ ಕ್ಯಾ ವ್ಹಯಾ ವ್ಹಯಿ? ಅಮಾನಾ ನಾಸ್ ಕರಾಯಾ ಆಲಾಸ್ ಕ್ಯಾ? ತು ಕೊನ್ ಠಾವಾ ಹಾಸ್; ತು ಪರ್ಮೇಶ್ವರಾಪ್ನಿ ಆಲ್ಯಾಲಾ ಯೋಕ್‍ ಪವಿತ್ರ” ಮನ್ಹುನ್ ವರ್ಡುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","ಯೇಸುನಿ ತ್ಯಲಾ ದಪ್‌ಕಾವುನ್ “ಗಪ್ಚಿಪ್ ರ‍್ಹಾ ಹೆಲಾ ಸುಡುನ್ ಜಾ಼” ಮನ್ಲಾ ");
INSERT INTO gok_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","ತವಾ ತ್ಯ ಲಾಗಿರ್ ತ್ಯಲಾ ವರ್ಡ್ಯಾವುನ್ ಲುಳ್ವುನ್ ಸುಡುನ್ ಗೆಲ. ");
INSERT INTO gok_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","ತ್ಯಲಾ ಸಗ್ಳಿ ಗಾಬ್ರುನ್ “ಹ್ಯ ಕ್ಯಾ ಆಸಲ್ ಹ್ಯೊ ನವಾ ಉಪದೆಸ್. ಹ್ಯೊ ಹುಕ್ಮಾನಿ ಲಾಗಿರಾನಾ ಸಾಂಗ್ತೋ; ತೀ ತ್ಯಚಾ಼ ಸಬೊತ್ ಐಕ್‌ತ್ಯಾತ” ಮನ್ಹುನ್ ಆಪ್‌ಲ್ಯಾ ಆಪ್‌ಲ್ಯಾತ್ ವಿಚಾರ್ ಕರಾಯಾ ಲಾಗ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","ಬಿಗಿನಿ ತ್ಯಚಿ಼ ಖಬರ್ ಗಲಿಲಾಯ್ ಸಿಮತ್ ಸಗ್ಳಿಕ್ಡ ಪಗಾಳ್ಳಿ. ");
INSERT INTO gok_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","ನಂತರ್ ಯೇಸು ಆನಿ ತ್ಯಚ಼ ಶಿಶಾ ಸಬಾ ಮಂದಿರಾತ್ನಿ ನಿಗುನ್ ಯಾಕೊಬ್ ಯೊಹಾನಾಚೆ ಸಂಗ ಸಿಮೊನ್ ಆಂದ್ರೇಯಾಚಾ ಗರ‍್ಹಾತ್ ಆಲ. ");
INSERT INTO gok_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","ತಿಥ ಸಿಮೊನಾಚಿ ಸಾಸೊ ತಾಪಾನಿ ನಿಜ್ಲಿ಼ ಹುತ್ತಿ ತ್ಯಂಚಾನಿ ತಿಚಿ ಪರಸ್ತಿತಿ ಬಿಗಿನಿ ಯೇಸುಲಾ ಸಾಂಗ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","ಯೇಸು ಜ಼ವಳ್ ಯವುನ್ ತಿಚಾ಼ ಹಾತ್ ದರುನ್ ಉಚ಼ಲ್ತಾನಾಸ್ ತಿಲಾ ತಾಪ್ ಸುಡುನ್ ಗೆಲಾ; ಆನಿ ತಿನಿ ತ್ಯಂಚಿ ಸೆವಾ ಕಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","ಶಾಂಜ಼್ ವ್ಹವುನ್ ದಿಸ್ ಮಾವಾಳ್ಯಾ ನಂತರ್ ಮಾನ್ಸಾಂಚಾನಿ ಲಾಗಿರ್ ದರ್‌ಲ್ಯಾಲ್ಯಾನಾ ಬರ ನಸ್‌ಲ್ಯಾಲ್ಯಾ ಸಗ್‌ಳ್ಯಾನಾ ಯೇಸುಪ ಆನ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","ಗಾವಾತ್ಲಿ ಸಗ್ಳಿ ತ್ಯಾ ಗರ‍್ಹಾಚಾ ದಾರಾ ಮೋರ್ಹ ಜ಼ಮ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","ತವಾ ತ್ಯನಿ ತರತರಾಚಾ ರೊಗಾನಿ ಅಂಗಾತ್ ಬರ ನಸ್‌ಲ್ಯಾಲ್ಯಾ ಖುಬ್ ಜ಼ನಾನಾ ಬರಕರುನ್ ಖುಬ್ ಲಾಗಿರ ಸುಡಿವ್ಲಿತ. ಆನಿ ಆಪ್ನು ಆಸ್ಲಾ ಮನ್ಹುನ್ ತ್ಯನಾ ಠಾವ ಹುತ ಮನ್ಹುನ್ ತ್ಯನಿ ತ್ಯನಾ ಬುಲುದಿಲಿ ನಾಹಿತ. ");
INSERT INTO gok_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","ಸಕಾಳ್ಚಾ ಕಾಳೊಕ್ ಆಸ್ಥಾನಾ ಯೇಸು ಯಕಾನ್ಸಿ ಜಾ಼ವುನ್ ದೇವಾಪ ಮಾಗ್ನ ಕರೀತ್ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","ಸಿಮೊನ್ ಆನಿ ತ್ಯಚ಼ ಸುಪ್ತಿ ಯೇಸುಲಾ ಸುದಿತ್ ಗೆಲ ಆನಿ ತ್ಯಲಾ ಬಗುನ್ ");
INSERT INTO gok_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","“ಸಗ್ಳಿ ತುಲಾ ಶೊತ್ಯಾತ” ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","ಯೇಸು ತ್ಯನಾ, “ಆಮಿ ಜ಼ವಳ್ಚಾ ದುಸ್‌ರ‍್ಯಾ ಗಾವಾತ್ನಿ ಜಾ಼ವುಯಾ; ತಿಥಬಿ ಮಿ ಬರಿ ಖಬರ್ ಸಾಂಗಾಯಾ ವ್ಹಯಿ; ಹ್ಯಚೆ ಸಾಟಿ ಮಿ ಆಲ್ಯೊ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ” ");
INSERT INTO gok_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","ಮಂಗ್ ತ್ಯೊ ಗಲಿಲಾಯ್ ಸಿಮತ್ ಸಗ್ಳಿಕ್ಡ ಜಾ಼ವುನ್ ತಿತಲ್ಯಾ ಸಬಾ ಮಂದಿರಾತ್ನಿ ಉಪದೆಸ್ ಕರಿತ್ ಲಾಗಿರ ಸುಡ್ವಿತ್ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","ಯೊಕ್ ಕುಶ್ಟ ರೊಗಿ ಯೇಸುಪ ಯವುನ್ ನಡ್ಗ ಗಾಲುನ್ “ತು ಮನ್ ಕೆಲ್ಯಾವ ಮನಾ ಬರ ಕರಾ ವ್ಹಯಿಲ್” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","ಯೇಸುನಿ ಕನಿಕರಾ ದಾವುನ್ ತ್ಯಲಾ ಹಾತ್ ಲಾವುನ್ “ಮನಾ ಮನ್ ಹಾ; ಬರಾ ಹೋ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","ತವಾಸ್ ತ್ಯಚಾ಼ ರೊಗ್ ಜಾ಼ವುನ್ ತ್ಯೊ ಬರಾ ಜಾ಼ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","ತವಾ ಯೇಸು ತ್ಯಲಾ “ಕುನಾಲಾ ಕಾಯ್ ಸಾಂಗು ನಕೊ ಜಾ಼ ");
INSERT INTO gok_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","ಫನ್ ಜಾ಼ವುನ್ ಯಾಜಕಾನಾ ತುಜ಼ ಆಂಗ್ ದಾವುನ್ ಮೊಶೆನಿ ಥರಿವ್‌ಲ್ಯಾಲಾ ನೆಮ್ ಕರುನ್ ತುಲಾ ಶುದ್ದಾಚಾರ್ ಕರುನ್ ಘೇ ತ್ಯ ಲೊಕಾನಾ ಸಾಕ್ಸಿ ವ್ಹವುನಿ” ಮನ್ಹುನ್ ಸಾಂಗುನ್ ತ್ಯಲಾ ಲಾವುನ್ ದಿಲಾ ");
INSERT INTO gok_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","ತ್ಯನಿ ಜಾ಼ವುನ್ ತಿ ಬಾತ್ನಿ ಸಗ್ಳಿಕ್ಡ ಸಾಂಗುನ್ ಪಗಳ್ಳಿ ಮನ್ಹುನ್ ಯೇಸುಲಾ ಆನಿ ಕಚಾ ಗಾವಾತ್ತಾತ್ ಜಾ಼ಯಾ ಜಾ಼ಲ ನಾಹಿ ಬಾಹಿರ್ ಯಕಾನ್ಸಿ ರಾಹಿತಾ. ಆನಿ ಲೊಕ ಚಾರಿ ಬಾಜು಼ಕ್ನಿ ತ್ಯಚಿಪ ಯಯಿತಿತ. ");
INSERT INTO gok_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","ಥೋಡ್ಯಾ ದಿಸಾ ನಂತರ್ ಯೇಸು ಕಪೆರ್ನೌಮತ್ ಪರ್ತುನ್ ಆಲಾ. ಗರ‍್ಹಾತ್ ಹಾ ಮನ್ಹುನ್ ಸುದ್ದಿ ಪಗಾಳ್ಳಿ. ");
INSERT INTO gok_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","ತವಾ ಖುಬ್ ಲೊಕ ಜ಼ಮುನ್ ಆಲಿತ ಮನ್ಹುನ್ ದಾರಾಚೆ ಕಡಸ್ ಬೀ ಜಾ಼ಗಾ ರಾಯ್ಲ ನಾಹಿ. ಯೇಸು ಲೊಕಾನಾ ದೇವಾಚಿ಼ ವಚ್ನ ಸಾಂಗಿತ್ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","ತ್ಯವ್‌ಡ್ಯಾತ್ ಯಕಾ ಪಾರ್ಶಿಚಾ ರೊಗಿಲಾ ಚಾರ್ ಜ಼ನಾಂಚಾನಿ ಉಚ್ಲು಼ನ್ ತಿಥ ಆನ್ಲಾ ");
INSERT INTO gok_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","ಲೊಕ ಖುಬ್ ಜ಼ಮ್ಲಿಹುತ್ತಿತ ಮನ್ಹುನ್ ತ್ಯಲಾ ಯೇಸುಚೆ ಜ಼ವಳ ನಿಹ್ಯಾ ಜಾ಼ಲಾ ನಾಹಿ ಮನ್ಹುನ್ ಯೇಸು ಬಸ್‌ಲ್ಯಾಲ್ಯಾ ಗರಾಚೆ ವೈಲಾ ಥಾಟ್ ಕಾಡುನ್ ವೈನಿ ಹಾತ್ರುನಾಸಾಹಿತ್ ತ್ಯಾ ರೊಗಿಲಾ ಯೇಸುಪ ಉತರ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","ಯೇಸುನಿ ತ್ಯಂಚಾ಼ ಇಸ್ವಾಸ್ ಬಗುನ್ ತ್ಯಾ ರೊಗಿಲಾ “ಲೇಕಾ ತುಜಾ ಪಾಪಾಂಚಿ ಮಾಪಿ ಜಾ಼ಲಿ ಮನ್ಲಾ. ” ");
INSERT INTO gok_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","ಫನ್ ಥೋಡಜಾ಼ನ್ ದರ್ಮ ಸಿಕಿವ್‌ತ್ಯಾಲ ಶಾನ ತಿಥ ಬಸುನ್ ");
INSERT INTO gok_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“ಹ್ಯೊ ಕಾ ಆಸಾ ಬೊಲ್ತೊ ಹ್ಯನಿ ದೇವಾಲಾ ಅವ್ಮಾನ್ ವ್ಹತೊ ದೇವಾಲಾ ಸುಡುನ್ ಆನಿ ಕುನಾಲಾ ಪಾಪ ಮಾಪ್ ಕರಾಯಾ ವ್ಹಯಿತ್ನಾಹಿ? ಮನ್ಹುನ್ ಆಪ್‍ಲ್ಯಾ ಆಪ್‍ಲ್ಯಾ ಮನಾತ್ ಮನ್ಹಿತ್ ಹುತ್ತ. ");
INSERT INTO gok_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","ತ್ಯ ಯೇಸುನಿ ತವಾಸ್ ಆಪ್‍ಲ್ಯಾ ಆತ್‌ಮ್ಯಾತ್ ಸಮಜು಼ನ್ “ತುಮಿ ತುಮ್ಚಾ ಮನಾತ್ ಕಾ ಆಸ್ಲ ಯವಸ್ತಾಸಾ? ");
INSERT INTO gok_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","ಕಚ಼ ಸಲ್ಪ; ತುಜ಼ ಪಾಪ್ ಮಾಪ್ ಜಾ಼ಲ ಮನ್ಹಾಚ಼ ಕ್ಯಾ ಉಠುನ್ ತುಜ಼ ಹಾತ್ರುನ್ ಗಿವುನ್ ಜಾ಼ ಮನ್ಹಾಚ಼? ");
INSERT INTO gok_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","ಫನ್ ಪಾಪ್ ಮಾಪಿ ಕರಾಯಾ ಮಾನ್ಸಾಚಾ ಲೇಕಾಲಾ ದರ್ಥಿವ ಹಾಕ್ ಹಾ ಮನ್ಹುನ್ ತುಮಾನಾ ಸಮಜಾ಼ಯಾ ಪಾಯ್ಜೆ” ಮನ್ಹುನ್ ತ್ಯಾ ಪಾರ್ಶಿವಾಯಿ ರೊಗಿಲಾ ಬಗುನ್ ");
INSERT INTO gok_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“ಉಠುನ್ ತುಜ಼ ಹಾತ್ರುನ್ ಗಿವುನ್ ಗರ‍್ಹಾತ್ ಜಾ಼” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","ತ್ಯೊ ತವಾಸ್ ಉಠುನ್ ಆಪ್ಲ ಹಾತ್ರುನ್ ಗಿವುನ್ ಸಗ್‌ಳ್ಯಾಂಚೆ ಮದ್ನಿ ಗೆಲಾ. ತ್ಯ ಬಗುನ್ ಸಗ್ಳಿ ಗಾಬಾರ್ಲಿತ ಆಜು಼ನ್ ಪರ‍್ಯಾತ್ ಆಮಿ ಆಸ್ಲ ಕವಾಸ್ ಬಗ್ಲ ನಾಹಿ. ಮನ್ಹಿತ್ ದೇವಾಲಾ ಸ್ತುತಿ ಕರುನ್ ತ್ಯಚ಼ ನಾವ್ ಗ್ಯಾವ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","ಯೇಸು ಪರತ್ ಆನಿ ಗಲಿಲಾಯ್ ಸಮಿಂದೋರಾಕ್ಡ ಗೆಲಾ. ಲೊಕ ತ್ಯಚಿಪ ಜ಼ಮ್ಲಿತ ತ್ಯನಿ ಲೊಕಾನಾ ಪರ್ಮೆಶ್ವರಾಚಾ಼ ಉಪದೆಶ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","ತ್ಯೊ ತಿಥ್ನಿ ಜಾ಼ಯಿತ್ ಆಸ್ಥಾನಾ ಜ಼ಖತ್ ವಸುಲಿ ಕರಾಯಾ ಕತ್ರಿವ ಬಸ್‌ಲ್ಯಾಲಾ ಅಲ್ಪಾಯಾಚಾ಼ ಲ್ಯೊಕ್ ಲೇವಿಲಾ ಬಗುನ್ “ಮಾಜೆ ಮಾಗ್ನಿ ಯೇ” ಮನ್ಹುನ್ ಹಾಕಟ್ಲಾ ತ್ಯೊ ಉಠುನ್ ತ್ಯಚೆ ಮಾಗ್ನಿ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","ನಂತರ್ ಯೇಸು ಲೇವಿಚಾ ಗರ‍್ಹಾತ್ ಖಾಯಾ ಆಲಾ. ತವಾ ಜ಼ಖತ್ ವಸುಲಿ ಕರ್ತ್ಯಾಲ ಆನಿ ಪಾಪಿಂಚಾ಼ ಹಿಂಡ್ ಯೇಸುಚೆ ಮಾಗ್ನಿ ಆಲಾ. ತ್ಯಾತ್ಲ ಥೋಡಜಾ಼ನ್ ಯೇಸು ಆನಿ ತ್ಯಚಾ ಶಿಶಾಂಚೆ ಸಂಗ ಪಂಗ್ತಿತ್ ಖಾಯಾ ಬಸ್ಲ ಹುತ್ತ. ");
INSERT INTO gok_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","ಫರಿಸಾಯ್ ಜಾ಼ಲ್ಯಾಲ ಕ್ಯಾಯ್ದದಾರಾಂಚಾತ್ಲ ಥೋಡಜಾ಼ನ್ ಪಾಪಿಂಚೆ ಆನಿ ಜ಼ಖತ್ ವಸುಲಿ ಕರ್ತ್ಯಾಲ್ಯಾಂಚೆ ಸಂಗ ಯೇಸು ಬಸ್‌ಲ್ಯಾಲಾ ಬಗುನ್ “ಹ್ಯೊ ಹ್ಯಂಚಿ ಸಂಗ ಖಾಯಾ ಬಸ್‌ಲ್ಯಾ ಕಾ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","ಯೇಸುನಿ ತ್ಯ ಐಕುನ್ “ಬರ ಆಸ್‌ಲ್ಯಾಲ್ಯಾಲಾ ಆತಾ ವೈದಿ ನಕೊ; ಬರ ನಸ್‌ಲ್ಯಾಲ್ಯಾಲಾ ವ್ಹಯಿ. ಮಿ ಚಾ಼ಂಗಲ್ಯಾನಾ ಹಾಕ್ಟಾಯಾ ಆಲ್ಯಾಲೊ ನವ್ಹ, ಪಾಪಿನಾ ಹಾಕ್ಟಾಯಾ ಆಲ್ಯಾಲೊ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","ಯೋಹಾನಾಚ ಶಿಶಾ ಆನಿ ಫರಿಸಾಯ್ ಉಪಾಸ್ ಕರೀತ್ ಹುತ್ತ. ತವಾ ಥುಡಿಲೊಕ ಯೇಸುಪ ಯವುನ್ “ಹೆ ಉಪಾಸ್ ಕರ್ತ್ಯಾತ ಆನಿ ತುಜ಼ ಶಿಶಾ ಕಾ ಉಪಾಸ್ ಕರೀತ್ ನಾಹಿತ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","ಯೇಸು ತ್ಯನಾ ಮನ್ಲಾ “ನವರ‍್ಯಾ ಸಂಗ ವ್ಹರಾಡ್ ಆಸ್ಥಾನಾ ಉಪಾಸಿ ರಾಥಕ್ಯಾ? ನಾಹಿ! ನವರ‍್ಹಾ ತ್ಯಂಚೆ ಸಂಗ ಆಸಸ್ಪರ‍್ಯಾತ್ ತೀ ಉಪಾಸಿ ರಾಹಿತ್ ನಾಹಿತ ");
INSERT INTO gok_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","ಖರ ನವರ‍್ಯಾಲಾ ನಿಹ್ಯಾಚಾ಼ ಯೊಳ್ ಯಯಿಲ್; ತ್ಯಾ ಯಳಾಲಾ ವ್ಹರಾಡ್ ಉಪಾಸಿ ರಾಹಿಲ್. ");
INSERT INTO gok_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","ಕೊನ್ ನವ್ಯಾ ಕಪ್‌ಡ್ಯಾಚಾ಼ ತುಕ್ಡಾ ಜು಼ನ್ಯಾ ಕಪ್‌ಡ್ಯಾಲಾ ತ್ಯಾಪಿ ಲಾವಿತ್ ನಾಹಿ; ಲ್ಯಾವ್ಲತ ನವಾ ಕಪ್ಡಾ ಜು಼ನ್ಯಾ ಕಪ್‌ಡ್ಯಾಲಾ ಲಸ್ ಪಿಂಜ಼ಳ್ತೋ. ");
INSERT INTO gok_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","ಆನಿ ಜು಼ನ್ಯಾ ಚ಼ಮ್‌ಡ್ಯಾಚೆ ಪಿಸ್ವಿತ್ ನವಾ ದ್ರಾಕ್ಶಿಚಾ಼ ರಸ್ ಕೊನ್ ಗಾಲುನ್ ಥಿವಿತ್ ನಾಹಿ. ಥೆವ್‌ಲ್ಯಾವ ತ್ಯಾ ದ್ರಾಕ್ಶಿಚಾ ರಸಾನಿ ಚ಼ಮ್‌ಡ್ಯಾಚಿ ಪಿಸ್ವಿ ಫುಟುನ್ ರಸ್ ಆನಿ ಪಿಸ್ವಿ ದುನಿ ಬಾದ್ ವ್ಹತ್ಯಾತ. ನವಾ ರಸ್ ನವ್ಯಾ ಚ಼ಮ್‌ಡ್ಯಾಚೆ ಪಿಸ್ವಿತ್ ಥೆವಾವ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","ಯೇಸು ಸಭತ್ ದಿಸಾ ದಿಸಿ ಪಿಕಾಚಾ ಸೆತಾತ್ನಿ ಜಾ಼ಯಿತ್ ಆಸ್ಥಾನಾ, ಯೇಸುಚಾ ಶಿಶಾಂಚಾನಿ ಕನ್ಸ ಮುಡುನ್ ಗೆತ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","ಫರಿಸಾಯಾಂಚಾನಿ ಯೇಸುಲಾ “ಬಗ್ ಹೆ ಸಬ್ಬತ್ ದಿಸಾದಿಸಿ ಕರುನಾಹಿತ್ಯ ಕಾಮ್ ಕಾ ಕರ್ತ್ಯಾತ” ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","ಯೇಸು ತ್ಯನಾ “ದಾವೀದಾನಿ ಆಪ್ನು ಆನಿ ಆಪ್ಲೆ ಸಂಗಚಾನಾ ಭುಕ್ ಲಾಗುನ್ ಖಾಯಾ ಕಾಯ್ ನಸ್ತಾನಾ ಕ್ಯಾ ಕೆಲ ಮನ್ಹುನ್ ತುಮಿ ಕಂದಿತರಿ ವಾಚಿವ್ಲ ನಾಹಿಸಾ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","ಆಮ್ಚಾ ಕ್ಯಾಯ್‌ದ್ಯಾಶಾರ್ಕ ದಾವೀದಾನಿ ಮುಖ್ಯ ಯಾಜಕ್ ಅಬಿಯಾತಾರಾಚಾ ಕಾಲಾತ್ ದೇವಾಚಾ ದೇವ್ಳಾತ್ ಜಾ಼ವುನ್ ಯಾಜಾಕಾನಿ ಖಾಯಾಚಾ ನಿವ್ದಾವ್‌ಲ್ಯಾ ಬಾಕ್‌ರ‍್ಯಾ ಆಪ್ನು ಖಾವುನ್ ಆಪ್ಲೆ ಸಂಗಚಾನಾ ದೀಲ್ಯಾ ನವ್ಹ? ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","ಆನಿ ಯೇಸು ಪರಿಸಾಯಾಲಾ ಸಾಂಗ್ತೊ “ಸಬ್ಬತ್ ದಿಸ್ ಮಾನ್ಸಾನಾ ಮಜ಼ತ್ ಕರಾಸಾಟಿ ಜಾ಼ಲ್ಯಾ ಸಬ್ಬತ್ ದಿಸಾನಿ ಮಾನ್ಸಾಂಚಿವರ್ ಹಾಕ್ ಚಾ಼ಲ್ವಾಯಾ ನವ್ಹ; ");
INSERT INTO gok_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","ಆಸ ಆಸ್ಥಾನಾ, ಮಾನ್ಸಾಚಾ ಲೇಕಾಲಾ ಸಬ್ಬತ್ ದಿಸಾವರ್ ಹಾಕ್ ಹಾ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","ಆನಿ ಏಕ್ ದಿಸಿ ಯೇಸು ಸಬಾ ಸ್ತಾನಾತ್ ಗೆಲಾ ತವಾ ತಿಥ ಹಾತ್ ವಾಳ್ಯಾಲಾ ಯೊಕ್ ಮಾನುಸ್ ಹುತ್ತಾ ");
INSERT INTO gok_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","ಥುಡಿಜ಼ನ ಯೇಸುಪ ಚು಼ಕ್ ದರಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಸಬ್ಬತ್ ದಿಸಾತ್ ತ್ಯಲಾ ಬರಕರ್ತ್ಯೋಕ್ಯಾ ಬಗುಯಾ ಮನ್ಹುನ್ ಯೇಸುಲಾ ಟಪುನ್ ಬಗಿತ್ ಹುತ್ತ. ");
INSERT INTO gok_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","ತ್ಯನಿ ಹಾತ್ ವಾಳ್ಯಾಲ್ಯಾಲಾ. “ಉಠುನ್ ಮದ್ದಿ ಯೆ” ಮನ್ಹುನ್ ಸಾಂಗುನ್. ");
INSERT INTO gok_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","ತ್ಯನಾ “ಮೋಸೆಚಾ ಕ್ಯಾಯ್‌ದ್ಯಾಶಾರ್ಕ ಸಬ್ಬತ್ ದಿಸಾದಿಸಿ ಕಚ಼ ಕೆಲ್ಯಾಲ ಬರ? ಚಾ಼ಂಗ್ಲ ಕೆಲ್ಯಾಲ, ಕ್ಯಾ ಬಾದ್ ಕೆಲ್ಯಾಲ? ಜೀವ್ ಉರ್ವಾಚಾ಼, ಕ್ಯಾ ಕಾಡಾಚಾ಼? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ತೇ ಗಪ್ ಹುತ್ತ. ");
INSERT INTO gok_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","ತವಾ ತ್ಯನಿ ತ್ಯಂಚ಼ ಮನ್ ಕಠಿನ್ ಜಾ಼ಲ್ಯಾಲ ಬಗುನ್ ಬೆಜಾರ್ ಕರುನ್ ರಾಗಾನಿ ಸರ್ ಭವ್ಹಾರಾ ಬಗುನ್ ತ್ಯಾ ಮಾನ್ಸಾಲಾ “ತುಜಾ಼ ಹಾತ್ ಮೋರ್ಹ ಕರ್” ಮನ್ಲಾ. ತ್ಯನಿ ಮೋರ್ಹ ಕೆಲಾ; ಹಾತ್ ಬರಾ ಜಾ಼ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","ಫರಿಸಾಯ್ ಲೊಕ್ ಬಿಗಿನಿ ಭಾಹಿರ್ ಯವುನ್ ಹೆರೊದ್ ರಾಜಾಚಾ ಮೆಳಾತ್‌ಲ್ಯಾಂಚಿಪ ಜಾ಼ವುನ್ ಹ್ಯಲಾ ಕಸ್ಸಾ ಮಾರುನ್ ಟಾಕುಯಾ ಮನ್ಹುನ್ ತ್ಯಚೆ ಆಡ್ವ ಪಾರಕ್ ಯವಜು಼ ಲಾಗಲ. ");
INSERT INTO gok_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","ಮಂಗ್ ಯೇಸು ಆಪ್‍ಲ್ಯಾ ಶಿಶಾಂಚೆ ಸಂಗ ತ್ಯೊ ಜಾ಼ಗಾ ಸುಡುನ್ ಗಲಿಲಾಯ್ ಸಮಿಂದೋರಾಕ್ಡ ಗೆಲಾ. ಗಲಿಲಾಯ್ ಸಿಮತ್ನಿ ಖುಬ್ ಲೊಕ ತ್ಯಚೆ ಮಾಗ್ನಿ ಗಿಲಿತ. ");
INSERT INTO gok_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ಆನಿ ಯೇಸು ಮುಟಿ ಮುಟಿ ಕಾಮ ಕರ್ತೊ ಮನ್ಹುನ್ ಐಕುನ್ ಲೊಕ ಯುದಾಯ್ ಸಿಮತ್ನಿ, ಯೆರುಸಲೆಮ್ ಪೆಠತ್ನಿ , ಇದುಮಾಯ್ ಸಿಮತ್ನಿ, ಯೊರ್ದಾನ್ ವ್ಹಾಳಚೆ ಪಲಿಕ್ನಿ, ತುರ್ ಆನಿ ಸಿದೋನ್ ಪೆಠಚೆ ಸರ್ ಬೌತಚಿ಼ ಲೊಕ ತ್ಯಚಿಪ ಆಲಿತ. ");
INSERT INTO gok_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","ಲೊಕ ಜ಼ಮಲ್ಯಾಲಿ ಬಗುನ್ ಆಪ್‌ಲ್ಯಾಲಾ ಡಖಲ್ತಿಲ ಮನ್ಹುನ್ ಯವಜು಼ನ್ ಆಪ್‌ಲ್ಯಾಲಾ ವ್ಹಡಿ ತಯಾರ್ ರಾಹುನಿ ಮನ್ಹುನ್ ಶಿಶಾನಾ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","ಕಾ ಮನ್‌ಲ್ಯಾವ ತ್ಯನಿ ಖುಬ್ ಲೊಕಾನಾ ಬರ ಕೆಲ್ತ ಮನ್ಹುನ್ ರೊಗ್ ಆಸ್‌ಲ್ಯಾಲಿ ತ್ಯಲಾ ಹಾತ್ ಲಾವಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಲೊಕಾನಾ ಡಕ್ಲಿತ್ ತ್ಯಚಿಪ ಯಯಿತಿತ. ");
INSERT INTO gok_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","ಆನಿ ಲಾಗಿರ್ ದರ್ಲ್ಯಾಲಿ ಮಾನ್ಸ ಯೇಸುಲಾ ಬಗುನ್ ತ್ಯಚಾ ಪಾಯಾತ್ ಪಡುನ್ “ತು ದೇವಾಚಾ಼ ಲ್ಯೊಕ್” ಮನ್ಹುನ್ ವರ್ಡತಿತ. ");
INSERT INTO gok_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","ಫನ್ ಯೇಸುನಿ ಆಪ್ನು ಆಸ್ಲಾ ಮನ್ಹುನ್ ಕುನಾಲಾ ಸಾಂಗು ನಕೊಸಾ ಮನ್ಹುನ್ ಲಾಗಿರಾನಾ ಖಡ್ಯಾವುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","ಮಂಗ್ ಯೇಸು ಗುಢ್ಯಾವ ಚ಼ಡುನ್ ಆಪ್‌ಲ್ಯಾಲಾ ವ್ಹಯಿ ಜಾ಼ಲ್ಯಾಲ್ಯಾನಾ ಜ಼ವಳ್ ಹಾಕಟ್ಲ ತವಾ ತೆ ತ್ಯಚಿಕ್ಡ ಆಲ. ");
INSERT INTO gok_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","ಯೇಸು ಕ್ರಿಸ್ತಾನಿ ತ್ಯಾತ್ನಿ ಬಾರಾ ಜ಼ನಾನಾ ಥರಿವ್ಲ ತ್ಯನಾ ಅಪೊಸ್ತಲ್‍ ಮನ್ಹುನ್ ಹಾಕಟ್ಲ ಆನಿ ತ್ಯನಿ ಸಾಂಗ್ಲ “ತುಮಿ ಮಾಜೆ ಸಂಗ ರಾಹ್ಯಾ ಸಾಟಿ, ದೇವಾಚಿ ಖಬರ್ ಸಾಂಗಾಯಾ ಲಾವುನ್ ದೆತ್ಯೊ ಆನಿ ಲಾಗಿರ ಸೋಡ್ವಾಚಾ಼ ಹುಕುಮ್ ಮಿ ತುಮಾನಾ ದೇತೊ. ” ");
INSERT INTO gok_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","ಯೇಸುನಿ ಥರಿವ್‌ಲ್ಯಾಲ್ಯಾ ಹ್ಯಾ ಬಾರಾ ಜ಼ನಾತ್ ಸಿಮೊನಾಲಾ (ಯೇಸುನಿ ಪೇತ್ರಾ ಮನ್ಹುನ್ ನಾವ್ ಥೆವ್ಲ) ");
INSERT INTO gok_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ಜೆಬೆದಾಯಾಚಾ಼ ಲ್ಯೊಕ್ ಯಾಕೊಬಾಲಾ ಆನಿ ತ್ಯಚಾ಼ ಬಾಹು ಯೊಹಾನ್ ಹ್ಯಂಚ಼ ಯೇಸುನಿ ಬೋವಾನೆರ್ಗೆಸ್ ಮನ್ಹುನ್ ನಾವ್ ಥೆವ್ಲ ಮಂಜೆ ಗಡ್‌ಘಡ್ಯಾಚಿ ಪೊರ; ");
INSERT INTO gok_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","ಆನಿ ಬಾಕಿಚ಼ ಆಂದ್ರೇಯ್, ಪಿಲಿಪ, ಬಾರ್ತೊಲೊಮ್, ಮತ್ತಾಯ್, ತೊಮ್, ಅಲ್ಪಾಯಾಚಾ಼ ಲ್ಯೊಕ್ ಯಾಕೊಬ್, ತದ್ದಯ್, ದೇಶೆಚಾ಼ ಬಗತ್ ಮಂಥ್ಯಾಲಾ ಸಿಮೊನ್, ");
INSERT INTO gok_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ಯೇಸುಲಾ ದರ‍್ಹುನ್ ದಿಲ್ಯಾಲಾ ಇಸ್ಕರಿತ್ ಯುದ್. ");
INSERT INTO gok_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","ಮಂಗ್ ಯೇಸು ಗರ‍್ಹಾತ್ ಆಲಾ ತವಾ ಲೊಕ ಖುಬ್ ಜ಼ಮಲ್ಯಾಲೆಸಾಟಿ ಯೇಸುಲಾ ಆನಿ ತ್ಯಚಾ ಶಿಶಾನಾ ಖಾಯಾ ಪುರ್ಸತ್ ಗಾವ್ಲಿ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","ತ್ಯೊ ಪಿಸಾಳ್ಯಾ ಮನ್ಹುನ್ ಲೊಕ ಬೋಲ್‌ತ್ಯಾಲಿ ಐಕುನ್ ತ್ಯಚಾ ಗರ‍್ಹಾತ್ಲಿ ತ್ಯಲಾ ಗರ‍್ಹಾತ್ ಆನಾಯಾ ಗಿಲಿತ. ");
INSERT INTO gok_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","ಆನಿ ಯೆರುಸಲೆಮಿತ್ನಿ ಆಲ್ಯಾಲ ಅಧಿಕಾರಿ “ಹ್ಯಲಾ ಬೆಲ್ಜೆಬುಲ್ ದರ್ಲಾ ಮನ್ಹುನ್ ಹ್ಯೊ ಬುತ್ಹಾಂಚಾ ದನ್‌ಹ್ಯಾಚೆ ಮಜ಼ತಿನಿ ಭುಥ ಸುಡಿವ್ತೋ” ಮನ್ಹಿತ್ ಹುತ್ತ. ");
INSERT INTO gok_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","ಯೇಸುನಿ ತ್ಯನಾ ಜ಼ವಳ್ ಹಾಕ್ಟುನ್ ಕ್ಯಾಯ್ನಿನಿ ಆಸ ಸಾಂಗ್ಲ “ಸೈತಾನ್ ಆಪ್‌ಲ್ಯಾಲಾಸ್ ಆಪ್ನು ಕಸ್ಸಾ ಸುಡಿವ್ನಾರ್? ");
INSERT INTO gok_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","ಯಕಾ ರಾಜಾ ಮದಿ ಪುಟಾಪುಟ್ ವ್ಹವುನ್ ಕಳಿ ಜಾ಼ಲ್ಯಾ ನಂತರ್ ತ್ಯ ರಾಜ್ ಸಥ್ಯಾನಾಸ್ ವ್ಹನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","ಯಕಾ ಗರ‍್ಹಾತ್ ಯಕಾಮಕಾ ಸಂಗ ಕಳಿ ಬಾಂಡ್ನ ಜಾ಼ಲ್ಯಾ ನಂತರ್ ತ್ಯ ಘರ್ ರಾಹಿತ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","ತಸಸ್ ಸೈತಾನ್ ಆಪ್ಲೆ ಆಡ್ವ ಉಠುನ್ ಆಪ್‌ಲ್ಯಾತ್ ಬೆದ್ ಬಾವ್ ಆಲ್ಯಾವ ತ್ಯೊ ಖಾಲ್ ಪಡ್ತೊ ಶಾಶ್ವತ್ ರಾಹಿತ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","ಆನಿ ಪಯಿಲ್ವಾನಾಲಾ ಬಾಂದಾಚೆ ಆಂದಿ ತ್ಯಚಾ ಗರ‍್ಹಾತ್ ಬರ್ಹುನ್ ತ್ಯಚಿ ಆಸ್ಥಿ ಗಿಹ್ಯಾ ವ್ಹಯಿತ್ ನಾಹಿ; ಬಾಂದುನ್ ನಂತರ್ ನಿಹ್ಯಾ ವ್ಹಯಿಲ್. ");
INSERT INTO gok_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","29","ಮಿ “ತುಮಾನಾ ಖರ ಸಾಂಗ್ತೋ ಮಾನ್ಸಾಂಚಾನಿ ಕೆಲ್ಯಾಲ್ಯಾ ಸಗ್‌ಳ್ಯಾ ಪಾಪಾಂಚಿ ಪರ್ಮೇಶ್ವರಾಚಿ ನಿಂದಾ ಕೆಲ್ಯಾಲಿ ಮಾಪಿ ವ್ಹಯಿಲ್, ಖರ ಕೊನ್ ಪವಿತ್ರಾತ್ಮಾಚಿ ನಿಂದಾ ಕರ್ತೊ ತ್ಯಲಾ ಮಾಪಿ ನಾಹಿ, ತ್ಯೊ ಶಾಶ್ವತ್ ಪಾಪಾತ್ ರಾನ್ಹಾರ್” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","“ಯೇಸುಲಾ ಸೈತಾನ್ ದರ್ಲ್ಯಾ” ಮನ್ಲ ಮನ್ಹುನ್ ಯೇಸುನಿ ಆಸ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","ನಂತರ್ ಯೇಸುಚಿ ಆಯಿ ಆನಿ ಬಾಹು ತಿಥ ಆಲಿತ ತೀ ಭಾಹಿರ್ ಉಬಿ ರಾಹುನ್ ಯೇಸುಲಾ ಹಕ್ಟಾಯಾ ಯಕಾಪ ಸಾಂಗುನ್ ಲಾವುನ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","ಯೇಸುಚೆ ಸರ್ ಬೌತಿ ಖುಬ್ ಲೊಕ ಬಸ್ಲಿ ಹುತ್ತಿತ ತವಾ ತ್ಯೊ “ತುಜಿ ಆಯಿ ಆನಿ ಬಾಹು ಭನ್ಹಿ ತುಲಾ ಸುದಿತ್ ಯವುನ್ ಬಾಹಿರ್ ಉಬಿ ಹಾತ್ತ ಬಗ್” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","ತವಾ ಯೇಸು ತ್ಯನಾ ಮಾಜಿ ಆಯಿ ಆನಿ ಬಾಹು ಬನ್ಹಿ ಕೊನ್? ");
INSERT INTO gok_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","ಆಪ್ಲೆ ಸರ್ ಬವ್ಹಾರಿ ಬಸ್‌ಲ್ಯಾಲ್ಯಾನಾ ಬಗುನ್ “ಹ್ಯಬಿಕ್ ಹಿ ಮಾಜಿ ಆಯಿ ಆನಿ ಮಾಜ಼ ಬಾಹು ಬನ್ಹಿ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","“ಕೊನ್ ಪರಮೇಶ್ವರಾಚಾ ಮನಾಶಾರ್ಕ ಚಾ಼ಲಲ್ ತೀ ಮಾಜಿ ಆಯಿ ಭನ್ ಬಾಹು ವ್ಹನಾರ್” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","ಆನಿ ಯಕಸಿ ಯೇಸು ಗಲಿಲಾಯ್‍ ಸಮಿಂದೋರಾಚೆ ದರವ ಉಪದೆಶ್ ಸಾಂಗಾಯಾ ಲಾಗ್ಲಾ. ತವಾ ಖುಬ್ ಲೊಕ ತ್ಯಚೆ ಸರ್ಬೌತ ಜ಼ಮ್ಲಿತ ಮನ್ಹುನ್ ಯೇಸು ಯಕ ವ್ಹಡಿತ್ ಜಾ಼ವುನ್ ಬಸುನ್ ಸಮಿಂದೊರಾತ್ ಆತ್ ಜ಼ರಾ ಮೋರ್ಹ ಗೆಲಾ. ಲೊಕ ಸಗ್ಳಿ ಸಮಿಂದೊರಾಚೆ ದರವ ಹುತ್ತಿತ. ");
INSERT INTO gok_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","ತವಾ ತ್ಯನಿ ಕ್ಯಾಯ್ನಿನಿ ತ್ಯನಾ ಖುಬ್ ಉಪದೆಶ್ ಕೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“ಐಕಾ! ಯಕಸಿ ಯಕ್ಲಾ ಬೀ ಪೆರ್ತ್ಯಾಲಾ ಪೆರಾಯಾ ನಿಗಾಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","ತ್ಯೊ ಪೆರ್ತಾನಾ ಥೋಡ ಬೀ ವಾಟಚೆ ಕಡಸ್ ಪಡ್ಲ; ತ್ಯ ಪಾಖರಾಂಚಾನಿ ಬುಡಿ ಯವುನ್ ಖಾಲ. ");
INSERT INTO gok_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","ಆನಿ ಥೋಡ ಬೀ ಖುಬ್ ಮಾತಿ ನಸ್‌ಲ್ಯಾಲೆ ಖಡ್ಯಾಚೆ ಜಿಮ್ನಿತ್ ಪಡ್ಲ; ತ್ಯ ಬಿಗಿನಿ ಉಗಾವ್ಲ ಕಾ ಮನ್‌ಲ್ಯಾವ ತಿಥ ಮಾತಿ ಪಾತಳ್ ಹುತ್ತಿ. ");
INSERT INTO gok_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","ಖರ ಉನ್ ಆಲ ತವಾ ತ್ಯ ಆಳ ವಾಳುನ್ ಗೆಲ ಕಾ ಮನ್‌ಲ್ಯಾವ ತ್ಯಚಿ ಮುಳ ಖಾಲ್ ಗೆಲಿ ನವ್ಥಿತ. ");
INSERT INTO gok_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","ಆನಿ ಥೋಡ ಬೀ ಕಾಟ್ಯಾಚಾ ಗಾದಾತ್ ಪಡ್ಲ; ತ್ಯ ಉಗಾವ್ಲ ಗಾದ್ ತ್ಯಚೆ ವರ್ ಗೆಲ ಆನಿ ತಿ ಆಳಿ ಬುಡುನ್ ಗಿಲಿತ ಮನ್ಹುನ್ ಪಿಕ್ ಗಾವ್ಲ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","ಆನಿ ಥೋಡ ಬೀ ಚಾ಼ಂಗ್ಲೆ ಜಿಮ್ನಿತ್ ಪಡ್ಲ. ತ್ಯ ಬಿ ಉಗಾವ್ಲ ಮೊಟ ಡಾಳ ಜಾ಼ಲ ಫಳ ಲಾಗ್ಲಿತ ತ್ಯಾತ್‌ಲ್ಯಾ ಯಕಾನಿ ತಿಸಾ ಯವ್ಡ , ಯಕಾನಿ ಸಾಟಾ ಯವ್ಡ ಯಕಾನಿ ಸೆಂಬರಾ, ಯವ್ಡ ಪಿಕ್ ದಿಲ. ” ");
INSERT INTO gok_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","ನಂತರ್ ಯೇಸುನಿ, “ಮಿ ಸಾಂಗ್‌ಲ್ಯಾಲ್ಯಾ ಗುಶ್ಟಿಂಚಿವ ದ್ಯಾನ್ ಥೆವಾ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ” ");
INSERT INTO gok_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","ಯೇಸು ಯಕ್ಲಾಸ್ ಆಸ್ಥಾನಾ ತ್ಯಚ಼ ಬಾರಾಜಾ಼ನ್ ಶಿಶಾ ಆನಿ ತ್ಯನಿ ಸಾಂಗ್‌ತ್ಯಾಲ ಐಕ್‌ಲ್ಯಾಲ್ಯಾತ್ಲಿ ಥುಡಿಜ಼ನ ಯವುನ್ ಕ್ಯಾಯ್ನಿಂಚಾ಼ ಅರ್ಥ ಫುಡುನ್ ಸಾಂಗ್ ಮನ್ಹುನ್ ತ್ಯಲಾ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","ತ್ಯೊ ತ್ಯನಾ ಮನ್ಲಾ ‘ದೇವಾಚಾ ರಾಜಾಚಿ ಗುಟ್ ತುಮಾನಾ ದಿಲೆ ಬಾಹಿರ್ಲ್ಯಾನಾ ಸಗ್ಳ ಕ್ಯಾಯ್ನಿಚಿಗತ್ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ಕಾ ಮನ್‌ಲ್ಯಾವ: ತೀ ಡೊಳ್ಯಾನಿ ಬಗ್‍ತ್ಯಾತ ಬಗ್ಲ ತರಿ ದಿಸತ್ ನಾಹಿ; ಕಾನಾನಿ ಐಕ್‌ತ್ಯಾತ ಐಕ್ಲ ತರಿ ಸಮ್ಜ಼ತ್ ನಾಹಿ. ಸಮಾಜ್‌ಲ್ಯಾವ ತೀ ಪರ್ಮೇಶ್ವರಾಕ್ಡ ಪರಾತ್ಲಿ ಆಸ್ಥಿತ ಆನಿ ತ್ಯಂಚಾ ಪಾಪಾಂಚಿ ಮಾಪಿ ಜಾ಼ಲಿ ಆಸ್ಥಿ’ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","ನಂತರ್ ಯೇಸು ತ್ಯನಾ, “ಹಿ ಕ್ಯಾಯ್ನಿ ತುಮಾನಾ ಸಮಾಜ಼ಲಿ ಜಾ಼ಲಿ ಕ್ಯಾ? ತುಮಿ ಹಿಸ್ ಸಮಜು಼ನ್ ಗಿತ್ಲಿ ನಾಹಿಸಾ ಮಂಜೆ ದುಸ್ರಿ ಕಚಿ ಕ್ಯಾಯ್ನಿ ಸಮಾಜ಼ನಾರ್? ");
INSERT INTO gok_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","ಪೆರ್ತ್ಯಾಲಾ ಪರ್ಮೇಶ್ವರಾಚ಼ ವಚನ್ ಪೆರ್ತೊ ");
INSERT INTO gok_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","ಥುಡಿಜ಼ನ ವಚ಼್ನ ಐಕ್‌ತ್ಯಾತ ಖರ ತ್ಯಂಚಿಪ ಪೆರ್ಲ್ಯಾಲ ವಚನ್ ಸೈತಾನ್ ಯವುನ್ ಕಾಡುನ್ ಟ್ಯಾಕ್ತೊ. ಹ್ಯ ವಾಟಚೆ ಕಡಸ್ ಪಡ್‌ಲ್ಯಾಲ ಬೀ. ");
INSERT INTO gok_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","ತಸಸ್ ಥುಡಿಜ಼ನ ವಚ಼್ನ ಐಕ್‌ಲ್ಯಾ ಬರ್ಬರ್ ಸಂತೋಸ್ ವ್ಹತ್ಯಾತ; ಥೋಡ ದಿಸ್ ತ್ಯವ್ಡ ರಾಥ್ಯಾತ ");
INSERT INTO gok_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","ನಂತರ್ ದೇವಾಚಾ ವಚ಼್ನಾಂಚಿಸ್ ಲಾಗುನ್ ತರಾಸ್ ಆಲಾಕಿ ತ್ಯನಾ ಮುಳ್ ನಸ್‌ಲ್ಯಾಲ್ಯಾಸ್ ಲಾಗುನ್ ಮಾಗಾರಿ ಜಾ಼ತ್ಯಾತ ಹಿ ದೊಂಡ್ಗಾಳ್ ಜಿಮ್ನಿತ್ ಪಡ್‌ಲ್ಯಾಲ ಬೀ. ");
INSERT INTO gok_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","ಆನಿ ಥುಡಿ ಜ಼ನ ಕಾಟ್ಯಾಚ಼ ಗಾದ್ ಆಸ್‌ಲ್ಯಾಲೆ ಜಿಮ್ನಿತ್ ಪೆರ್ಲ್ಯಾಲ್ಯಾ ಬ್ಯಾಚೆಗತ್ ರಾಥ್ಯಾತ ಹಿ ಲೊಕ ");
INSERT INTO gok_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ವಚ್ನ ಐಕ್‌ತ್ಯಾತ ಖರ ಹ್ಯಾ ಜೀವ್ನಾಚೆ ಕ್ಯಾಳ್ಜಿನಿ, ಪೈಶಾವ್‍ಲ್ಯಾ ಮನಾನಿ ಆನಿ ಪ್ರಪಂಚಾತ್ಲೆ ಸಗ್ಳೆ ತರಚೆ ಆಸೆಂಚಾನಿ ಬರ್ಹುನ್ ವಚ್ನ ಇಸಾರ್ತ್ಯಾತ ಆನಿ ಪಿಕ್ ದಿಯಿತ್ ನಾಹಿತ. ");
INSERT INTO gok_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","ತಸಸ್ ಥುಡಿ ಜ಼ನ ಚಾ಼ಂಗ್ಲೆ ಜಿಮ್ನಿತ್ ಪಡ್‌ಲ್ಯಾಲ್ಯಾ ಬ್ಯಾಚೆಗತ್ ಹಾತ್ತ. ತೀ ವಚ಼್ನ ಐಕುನ್ ತ್ಯಚಿಗತ್ ಚಾ಼ಲುನ್ ತಿಸಾಯವ್ಡ, ಸಾಟಾಯವ್ಡ, ಸೆಂಬರಾಯವ್ಡ ಆಸ ಪಿಕ್ ದೆತ್ಯಾತ; ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","ಮಂಗ್ ಯೇಸು ತ್ಯನಾ, ದಿವಾ ಲಾವುನ್ ಐದಾನಾ ಬುಡಿ ನಾಹಿತ ಪಲಂಗಾ ಬುಡಿ ಥೆವ್‌ತ್ಯಾತ ಕ್ಯಾ? ನಾಹಿ! ದೀವಾ ದೀವಲಾವನ್ಯಾವ ಥೆವ್‌ತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","ಕಾಯೇಕ್ ಆಡ್‍ಶಾ ಆಸ್‍ಲ್ಯಾಲ ಸಗ್ಳ ನದ್ರಸ್ ಲಾಗ್ನಾರ್. ಜಾ಼ಕ್‌ಲ್ಯಾಲ ಸಗ್ಳ ಉಗಡ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","ಮಾಜ಼ ಬೊಲ್ನ ಐಕ್‌ತ್ಯಾಲ್ಯಾಂಚಾನು ಲಕ್ಶೆ ದಿವುನ್ ಐಕಾ! ");
INSERT INTO gok_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","“ತುಮಿ ಕ್ಯಾ ಐಕ್ತಾಸಾ ತ್ಯ ದ್ಯಾನ್ ದಿವುನ್ ಇಚಾರ್ ಕರಾ. ತುಮಿ ಮ್ಯಾಪ್‌ಲ್ಯಾಲ್ಯಾ ಮಾಪಾನಿ ತುಮಾನಾ ಮ್ಯಾಪ್ನಾರ್; ");
INSERT INTO gok_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","ಆಸ್‌ಲ್ಯಾಲ್ಯಾಲಾ ಆನಿಕ್ ದೆನಾರ್ ನಸ್‌ಲ್ಯಾಲ್ಯಾಪ್ನಿ ಆಸ್‌ಲ್ಯಾಲಬಿ ಕಾಡುನ್ ಗೆನಾರ್. ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","ಆನಿ ಯೇಸು ತ್ಯನಾ ಮನ್ಲಾ, “ಪರ್ಮೇಶ್ವರಾಚ಼ ರಾಜೆ ಆಸ ಹಾ. ಯಕಾ ಮಾನ್ಸಾನಿ ಸೆತಾತ್ ಬೀ ಪೆರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","ತ್ಯೊ ಮಾನುಸ್ ರಾತಿನಿ ನಿಜು಼ನ್ ದಿಸಾಚಾ಼ ಉಠತ್ ಆಸ್ಥಾನಾ ತ್ಯ ಬೀ ರುಜು಼ನ್ ಮೋಟ್ಟ ವ್ಹತ ತ್ಯ ಕಸ ಮನ್ಹುನ್ ರೈತಾಲಾ ಕಳತ್ ನಾಹಿ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","“ಜಿಮಿನ್ ಆಪೊ ಆಪ್ ಪಿಕ್ ದಿತಿ ಪಯ್‌ಲ್ಯಾನಿ ಬ್ಯಾಲಾ ಕೊಂಬ್ರಾ ಯತೋ ನಂತರ್ ಪುಟ್ರಿಸ್ ಯತ ನಂತರ್ ಕನಿಸ್ ಯತ ಮಂಗ್ ಕನ್ಸಾಲಾ ದಾನ ಯತ್ಯಾತ ");
INSERT INTO gok_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","ತೇ ಜು಼ನ್ ಜಾ಼ಲಕಿ ಲ್ಯಾನ್ ಆಲೆ ಮನ್ಹುನ್ ಸಮಜು಼ನ್ ರೈತ್ ಖುರ್ಪ ಗಿವುನ್ ಕ್ಯಾಪ್ತೊ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","ಮಂಗ್ ಯೇಸು, “ಪರ್ಮೇಶ್ವರಾಚ಼ ರಾಜೆ ಕಸ ಹಾ? ಕಚಿ ಕ್ಯಾಯ್ನಿ ಗಿಹುನ್ ತುಮಾನಾ ಸಾಂಗು? ");
INSERT INTO gok_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","ಪರ್ಮೇಶ್ವರಾಚ಼ ರಾಜೆ ಆಸ ಹಾ, “ಯೊಕ್ ರೈತ್ ಸಗಳ್ಯಾ ಬ್ಯಾತ್ನಿ ಬಾರಿಕ್ ಜಾ಼ಲ್ಯಾಲ ಮೌರಿಚ಼ ಬಿ ಗಿಹುನ್ ಸೆತಾತ್ ಪೆರ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","ತ್ಯ ಥೊಡ ದಿಸ್ ಜಾ಼ಲ್ಯಾ ನಂತರ್ ಸೆತಾತ್‌ಲ್ಯಾ ದಿಸರ‍್ಯಾ ಆಳ್ಯಾಂಚಿವ್ನಿ ಮೋಟ ವ್ಹವುನ್ ತ್ಯಲಾ ಹಾರ‍್ಯಾ ಫುಟ್ಯಾತಾ ಪಾಕ್ರ ತ್ಯಚೆ ಸಾವ್ಲಿಲಾ ಯವುನ್ ಕುಟಿ ಬಾಂದುನ್ ರಾಥ್ಯಾತ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","ಯೇಸು ಆಸ್‍ಲ್ಯಾ ಕ್ಯಾಯ್‌ನ್ಯಾಂಚಾನಿ ಲೊಕಾನಾ ಉಪದೆಸ್ ಕರೀತಾ , ತ್ಯನಾ ಕ್ಯವ್ಡ ಸಮಜ಼ಲ್ ತ್ಯವ್ಡ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","ತ್ಯನಿ ಕ್ಯಾಯ್ನಿ ನಸ್ತಾನಾ ತ್ಯನಾ ಕಾಯ್ ಸಾಂಗ್ಲ ನಾಹಿ. ಖರ ಆಪ್ಲ ಶಿಶಾ ತ್ಯವ್ಡಸ್ ಆಸ್ಥಾನಾ ಸಗ್ಳ ತ್ಯನಾ ಫುಡುನ್ ಸಾಂಗಿತ್ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","ತೆ ದಿಸಿ ಸಾಂಜ಼ ಯೇಸು ಆಪ್‌ಲ್ಯಾ ಶಿಶಾನಾ, “ಯವಾ ಆಮಿ, ಸಮಿಂದೊರಾಚೆ ಪಲಿಕ್ಡ ಜಾ಼ವುಯಾ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","ತವಾ ತೇ ಲೊಕಾನಾ ತಿಥಸ್ ಸುಡುನ್ ಯೇಸು ಬಸಲ್ಯಾಲೆ ವ್ಹಡಿತ್ ಶಿಶಾ ಚ಼ಡುನ್ ತಸಾಸ್ ಯೇಸುಲಾ ಗಿಹುನ್ ಗೆಲ. ದುಸರ‍್ಯಾ ವ್ಹಡ್ಯಾಬಿ ತ್ಯಂಚೆ ಬರ್ಬರ್ ಹುತ್ಯಾ ");
INSERT INTO gok_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","ಆಸ್ಥಾ ಆಸ್ಥಾಸ್ ಮುಟಿ ವಾವ್ಡಳ್ ಆಲಿ ಆನಿ ಪಾನ್ಯಾಚಾ ಲ್ವಾಟಾ ವ್ಹಡಿವ ಅದ್ಳತ್ಯಾ ವ್ಹಡಿ ಪಾನ್ಯಾನಿ ಬರ್ಹತ್ ಆಲಿ. ");
INSERT INTO gok_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","ಯೇಸು ವ್ಹಡಿಚಾ ಮಾಗ್‌ಲ್ಯಾ ಖನಾತ್ ಉಸ ಲಾವುನ್ ಸುಸೆಗಾತ್ ನಿಜ್ಲಾ಼ ಹುತ್ತಾ; ತವಾ ತ್ಯಚಾ ಶಿಶಾಂಚಾನಿ ತ್ಯಲಾ “ಉಟುವುನ್ ಪ್ರಬುಜಿ಼! ಆಮಿ ಬುಡುನ್ ಜಾ಼ತ್ಯಾವ್ ತ್ಯಚಿ಼ ತುಲಾ ಕಾಯ್ ಕ್ಯಾಳ್ಜಿ ನಾಹಿ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","ತವಾ ತ್ಯನಿ ಉಠುನ್ ವಾರ‍್ಯಾಲಾ ಆನಿ ಲಾಟಾನಾ ದಪ್‌ಕಾವುನ್ “ಗಪ್ ರಾವ್ಹಾ! ಶಾಂತ್ ವ್ಹವಾ!” ಮನ್ಲಾ ತಸ ವಾರ ಬಂದ್ ಜಾ಼ಲ ಆನಿ ಸಮಿಂದೋರ್ ಶಾಂತ್ ಜಾ಼ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","ಮಂಗ್ ತ್ಯೊ ತ್ಯನಾ “ತುಮಿ ಇತ್ಕ ಕಾ ಬಿಥಾಸಾ? ತುಮಾನಾ ಆಜು಼ನ್ ಇಸ್ವಾಸ್ ನಾಹಿ ಕ್ಯಾ? ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","ತವಾ ತೆ ಬಿಹುನ್, “ಹ್ಯೊ ಕೊನ್ ಆಸಲ್? ವಾರ ಆನಿ ಸಮಿಂದೋರ್ ಸಾಯಿತ್ ಹ್ಯಚ ಸಬಾತ್ ಐಕ್‌ತ್ಯಾತ!” ಮನ್ಹುನ್ ತೇ ತೇಸ್ ಬೊಲತ್. ");
INSERT INTO gok_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","ಮಂಗ್ ಯೇಸು ಆನಿ ತ್ಯಚ಼ ಶಿಶಾ ಗಲಿಲಾಯ್ ಸಮಿಂದೋರಾಚೆ ಪಲಿಕ್ಡ ಗೆನೆಜ಼ರೆತ್ ಸಿಮತ್ ಆಲ. ");
INSERT INTO gok_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","ಆನಿ ತ್ಯೊ ವ್ಹಡಿತ್ನಿ ಬಾಹಿರ್ ಯತಾನಾಸ್, ಲಾಗಿರ್ ಲಾಗ್‍ಲ್ಯಾಲಾ ಯೊಕ್ ಮಾನುಸ್ ಮಸುರ್ಡಿತ್ನಿ ತ್ಯಚೆ ಮೊರ‍್ಹ ಆಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","ತ್ಯೊ ಮಸುರ್ಡಿತ್ನಿ ರಾಥ್ಯಾಲಾ, ತ್ಯಲಾ ಬಾಂದುನ್ ಗಾಲಾಯಾ ಕುನಾಲಾ ಶಕ್ಯಾ ನವ್ಥಿ. ತ್ಯಲಾ ಸಾಕ್ಳಿನಿ ಬ್ಯಾಂದ್ಲಾ ತರಿ ಉಪೆಗ್ ವ್ಹಯಿತ್ ನವ್ಥ. ಬಾಂದುನ್ ಗ್ಯಾತ್ಲಾ ಖರ. ಸಗ್‍ಳ್ಯಾ ತುಡುನ್ ಟ್ಯಾಕ್‍ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","ಲೊಕಾಂಚಾನಿ ಖುಬ್ ಖೆಪಾ ತ್ಯಚ಼ ಹಾತ್ ಪ್ಯಾ ಸಾಕ್‌ಳ್ಯಾಂಚಾನಿ ಬ್ಯಾಂದ್ಲ ಹುತ್ತ. ಫನ್ ತ್ಯನಿ ತ್ಯಾ ಸಗ್‍ಳ್ಯಾ ತುಡುನ್ ಟ್ಯಾಕ್‍ಲ್ಯಾ. ತ್ಯಲಾ ದರ್‌ಥ್ಯಾಲಾ ಪೈಲ್ ವಾನ್ ತಿಥ ಕೊನ್ ನವ್ಥಾ. ");
INSERT INTO gok_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","ತ್ಯೊ ಖಾಯಿಮ್ ರ‍್ಯಾತ್ದಿಸ್ ಗುಢ್ಯಾವ್ನಿ ಗಬ್ಹಿತ್ನಿ ವರ್ಡತ್ ರಾಹಿತಾ ಆನಿ ದೋಂಡ್ಯಾನಿ ಆಪ್ಲ ಆಂಗ್ ಜಿ಼ಜ್ರು಼ನ್ ಗಿಹಿತಾ. ");
INSERT INTO gok_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","ತ್ಯನಿ ಯೇಸುಲಾ ದುರ್ನಿ ಬಗುನ್ ಪಳತ್ ಆಲಾ ಆನಿ ತ್ಯಚೆ ಮೊರ‍್ಹ ನಡ್ಗ ಟಿಕ್ವುನ್ ಪಡ್ಲಾ: ");
INSERT INTO gok_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ಆನಿ ಜೊ಼ರಾನಿ ವರ್ಡುನ್, “ಯೇಸು ಪರಮೇಶ್ವರಾಚಾ ಲೇಕಾ, ಮಾಜಿ ಕ್ಯಾಳ್ಜಿ ತುಲಾ ಕಾ? ದೇವಾಶಪತ್ ಮನಾ ಜಾ಼ಚ಼್ ಕರು ನಕೊ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","(ಕಾ ಮನ್‌ಲ್ಯಾವ ಯೇಸು ತ್ಯಲಾ, “ಲಾಗಿರಾ ಹ್ಯಾ ಮಾನ್ಸಾಲಾ ಸುಡುನ್ ಬಾಹಿರ್ ಯೇ” ಮನ್ಹಿತಾ). ");
INSERT INTO gok_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","ತವಾ ಯೇಸುನಿ ತ್ಯಲಾ, “ತುಜ಼ ನಾವ್ ಕ್ಯಾ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ತ್ಯನಿ, “ಮಾಜ಼ ನಾವ್ ಹಿಂಡ್ ಕಾ ಮಂಜೆ ಆಮಿ ಖುಬ್ ಜ಼ನ ಲಾಗಿರ್ ಹಾವ್” ಮನ್ಹುನ್ ಉತ್ತರ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","ಆನಿ, “ಹ್ಯಾ ಜಾ಼ಗ್ಯಾವ್ನಿ ಲಾಗಿರಾನಾ ಗಾಲ್ವು ನಕೊಸ್” ಮನ್ಹುನ್ ತ್ಯೊ ಯೇಸುಲಾ ಮನ್ಹಿತಾ. ");
INSERT INTO gok_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","ತಿಥ ಗುಢ್ಯಾಚೆ ಬಾಜೊ಼ಲಾ ಯೊಕ್ ಮೊಟಾ ಡುಕ್ರಾಂಚಾ಼ ಹಿಂಡ್ ಚ಼ರತ್ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","ತವಾ ಲಾಗಿರಾಂಚಾನಿ ಯೇಸುಪ, “ಆಮಾನಾ ತ್ಯಾ ಡುಕ್ರಾತ್ನಿ ಲವುನ್ ದೇ ಆಮಿ ಡುಕ್ರಾತ್ನಿ ಜಾ಼ತಾವ್” ಮನ್ಹುನ್ ಇನಂತಿ ಕೆಲಿ. ");
INSERT INTO gok_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","ಆನಿ ಯೇಸುನಿ ತ್ಯನಾ ಮೊಕಳ್ ದಿಲಿ; ತವಾ ತೀ ಲಾಗಿರ ಮಾನ್ಸಾತ್ನಿ ಬಾಹಿರ್ ಯವುನ್. ಡುಕ್ರಾತ್ನಿ ಬರ್ಲಿತ ತೀ ಡುಕ್ರ ಗುಢ್ಯಾವ್ನಿ ಉತ್ರುನ್ ದಾವ್ಹತ್ ಜಾ಼ವುನ್ ದರವ್ನಿ ಸಮಿಂದೋರಾತ್ ಪಡ್ಲಿತ ಆನಿ ಪಾನ್ಯಾತ್ ಬುಡುನ್ ಮಿಲಿತ ತೀ ಕಮಿಸ್ಕಮಿ ದೊನ್ ಹಾಜಾ಼ರ್ ಹುತ್ತಿತ. ");
INSERT INTO gok_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","ಡುಕ್ರ ರ‍್ಯಾಕ್ನಾರ‍್ಯಾಂಚಾನಿ ಪಳತ್ ಜಾ಼ವುನ್ ಗಾವಾತಲ್ಯಾನಾ ಸೆತಾತ್‍ಲ್ಯಾನಾ ಜಾ಼ಲ್ಯಾಲಿ ಖಬರ್ ಸಾಂಗ್ಲಿ, ತವಾ ಕ್ಯಾ ಜಾ಼ಲ ಮನ್ಹುನ್ ಬಗಾಯಾ ಲೊಕ ತಿಥ ಆಲಿತ ");
INSERT INTO gok_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","ಆನಿ ತ್ಯಾ ಲೊಕಾಂಚಾನಿ ಲಾಗಿರ್ ದರ್‌ಲ್ಯಾಲಾ ಮಾನುಸ್, ಶಾನಾ ವ್ಹವುನ್ ಚಾ಼ಂಗ್ಲ ಕಪ್ಡ ಗಾಲ್ಹುನ್ ಥಂಡ್ ಬಸ್‍ಲ್ಯಾಲಾ ಬಗುನ್ ಬಿಹ್ಯಾಲಿತ. ");
INSERT INTO gok_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","ಲಾಗಿರ್ ದರ್‌ಲ್ಯಾಲ್ಯಾ ಮಾನ್ಸಾಚಿ ಆನಿ ಡುಕ್ರಾಂಚಿ ಹಾಕಿಗತ್ ಕುನಿ ಕುನಿ ಬಗ್ಲಿ ಹುತ್ತಿ ತ್ಯಂಚಾನಿ ಆಲ್ಯಾಲ್ಯಾ ಲೊಕಾನಾ ಸಾಂಗ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","ತವಾ ತೀ ಲೊಕ ಯೇಸುಲಾ, “ತು ಆಮಚಾ಼ ಗಾವ್ ಸುಡುನ್ ಜಾ಼” ಮನ್ಹುನ್ ಖುಬ್ ಇನಂತಿ ಕರಾಯಾಲಾಗ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","ನಂತರ್ ಯೇಸು ವ್ಹಡಿತ್ ಚ಼ಡ್ತಾ ಆಸ್ಥಾನಾ, ಆಂದಿ ಲಾಗಿರ್ ದರ್‌ಲ್ಯಾಲಾ ಮಾನುಸ್ ತ್ಯಲಾ, “ಮನಾ ತುಜೆ ಸಂಗ ಯಯಾ ಹುಕುಮ್ ದೇ” ಮನ್ಹುನ್ ಇನಂತಿ ಕರಾಯಾ ಲಾಗ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","ಖರ ಯೇಸುನಿ ತ್ಯಲಾ ಯವು ದಿಲಾ ನಾಹಿ ತ್ಯಲಾ ಮನ್ಲಾ, ತು ತುಜಾ ಗರ‍್ಹಾತ್ ಆನಿ ತುಜಾ ಸೋಪ್‌ತ್ಯಾಂಚಿಪ ಜಾ಼ ಆನಿ; ಪ್ರಭುನಿ ತುಲಾಕೆಲ್ಯಾಲ ಉಪ್ಕಾರ್ ಆನಿ ತುಜಿವ ದ್ಯಾವ್‍ಲ್ಯಾಲಿ ದಯಾ ತ್ಯನಾ ಸಾಂಗ್. ” ");
INSERT INTO gok_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","ತವಾ ತ್ಯೊ ನಿಗಾಲಾ ಆನಿ ಯೇಸುನಿ ಆಪ್‌ಲ್ಯಾಲಾ ಕೆಲ್ಯಾಲ ಉಪ್ಕಾರ್ ಆನಿ ದಯಾ ದೆಕಪೊಲಿಸ್ ಸಾಂಗಾಯಾ ಲಾಗ್ಲಾ; ತವಾ ಸಗ್‍ಳ್ಯಾನಾ ಆಜಾಬ್ ಜಾ಼ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","ಮಂಗ್ ಯೇಸು ವ್ಹಡಿತ್ ಬಸುನ್ ಆನಿಕ್ ಸಮಿಂದೋರಾಚೆ ದಿಸ್‍ರೆ ಬಾಜೊ಼ಲಾ ಗೆಲಾ ತಿಥ ದರವ ಖುಬ್ ಲೊಕಾಂಚಾ಼ ಯೊಕ್ ಹಿಂಡ್ ತ್ಯಚೆ ಸರ್ಬೌತಾ ಜ಼ಮ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","ತವಾ ಸಬಾ ಮಂದಿರಾತ್ಲಾ ಅಧಿಕಾರಿ ಯಾಯಿರ್ ಮಂಥ್ಯಾಲಾ ತಿಥ ಆಲಾ, ಆನಿ ಯೇಸುಲಾ ಬಗುನ್ ತ್ಯಚಾ ಪಾಯಾತ್ ಪಡ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ಆನಿ ಮಾಜಿ಼ ಲ್ಯಾಡ್ಕಿ ಲೇಕ್ ಮರ್ತೆ ತೀ ಜ಼ಗುನಿ ಮನ್ಹುನ್ ತು ಯವುನ್ ತಿಚಿವ ಹಾತ್ ಥೆವ್; ಮನ್ಹುನ್ ತ್ಯಲಾ ಖುಬ್ ಇನಂತಿ ಕರಾಯಾ ಲಾಗ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","ಯೇಸು ತ್ಯಚೆ ಸಂಗ ಗೆಲಾ, ಖುಬ್ ಲೊಕ ಯೇಸುಚೆ ಸಂಗ ಜಾ಼ಯಿತಿತ ಆನಿ ತ್ಯಲಾ ರಿಟಿತಿತ. ");
INSERT INTO gok_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","ತಿಥ ಬಾರಾ ವರ್ಸ ಅಂಗಾವ್ನಿ ರಗಾತ್ ಜಾ಼ತ್ಯಾಲಾ ರೊಗ್ ಆಸ್‍ಲ್ಯಾಲಿ ಯೇಕ್ ಬಾಯಿಲ್ ಮಾನುಸ್ ಹುತ್ತಿ. ");
INSERT INTO gok_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","ತಿನಿ ಖುಬ್ ದವಾಖಾನ ಕೆಲ್ತ ಆಪ್ಲಿಪ್ಲ ಸಗ್ಳ ಪೈಸ ಖರ್ಚ ಕೆಲ ಖರ ತಿಲಾ ಕಾಯ್‍ ಗುನ್ ಗಾವ್ಲಾ ನಾಹಿ ರೊಗ್ ಚಾ಼ವಾಳಾ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","ತಿನಿ ಯೇಸುಚಿ ಖಬರ್ ಐಕ್ಲಿ, ಆನಿ ಲೊಕಾಂಚೆ ಮದ್ದಿ ಯೇಸುಚೆ ಮಾಗ ಆಲಿ. ");
INSERT INTO gok_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","ತಿ ಆಪ್‌ಲ್ಯಾ ಮನಾತ್, “ಮಿ ತ್ಯಚಾ ಕಪ್‍ಡ್ಯಾನಾ ಹಾತ್ ಲ್ಯಾವ್ಲಾ ಪುರಾ ಮಿ ಬರಿ ವ್ಹನಾರ್” ಮನ್ಲಿ. ಆನಿ ");
INSERT INTO gok_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","ತಿನಿ ತ್ಯಚಾ ಕಪ್‍ಡ್ಯಾಲಾ ಹಾತ್ ಲ್ಯಾವ್ಲಾ. ತವಾಸ್ ತಿಚಾ ಅಂಗಾವ್ನಿ ರಗಾತ್ ಜಾ಼ಯಾಚ಼ ಬಂದ್ ಜಾ಼ಲ, ತಿಚಾ ಮನಾಲಾ ಆಪ್‌ಲ್ಯಾಲಾ ಬರ ಜಾ಼ಲ ಮನ್ಹುನ್ ಸಮಾಜ಼್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","ತವಾಸ್ ಯೇಸುಲಾ ಆಪ್ಲಿಪ್ಲ ಬಳ್ ಗೆಲ್ಯಾಲ ಸಮಾಜ಼್ಲ, ಆನಿ ಯೇಸುನಿ ಮಾಗಾರ ಪರ್ತುನ್ ಲೊಕಾನಾ, “ಮಾಜಾ ಕಪ್‍ಡ್ಯಾಲಾ ಕುನಿ ಹಾತ್ ಲ್ಯಾವ್‍ಲ್ಯಾಲಾ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","ತ್ಯಚ಼ ಶಿಶಾ ತ್ಯಲಾ ಮನ್ಲ, “ ಸಗ್ಳಿಕ್ನಿ ಲೊಕ ತುಲಾ ರೆಟ್ಯಾಲಿ ತು ಬಗತ್ಯೊಸ್ ಆನಿ ಕುನಿ ಮನಾ ಹಾತ್ ಲ್ಯಾವ್ಲಾ ಮನ್ಹೂ‍ನ್‍ ಕಾ ಇಚಾರ್ತೊಸ್? ");
INSERT INTO gok_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","ಖರ ಯೇಸು ಹಾತ್ ಲ್ಯಾವ್‍ಲ್ಯಾಲಿಲಾ ಬಗಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಸರ್ಬೌರ್ ಪರ್ತುನ್ ಬಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","ತವಾ ತೀ ಬಾಯಿಲ್ ಮಾನುಸ್ ಆಪ್‌ಲ್ಯಾಲಾ ಜಾ಼ಲ್ಯಾಲ ಸಮಜು಼ನ್ ಬಿಹುನ್ ಮೊರ‍್ಹ ಯವುನ್ ಯೇಸುಚಾ ಪಾಯಾತ್ ಪಡುನ್ ಸಗ್ಳ ಖರ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","ಯೇಸು ತಿಲಾ ಮನ್ಲಾ, “ಲಿಕಿ ತುಜಾ ಇಸ್ವಾಸಾನಿ ತುಲಾ ಬರ ಜಾ಼ಲ್ಯಾ ಸಮಾದಾನಾನಿ ಜಾ಼ ಆನಿ ತುಜಾ ರೊಗಾತ್ನಿ ಸುಟ್ಕಿ ಹೋ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","ಯೇಸು ಹ್ಯ ಸಾಂಗಿತ್ ಆಸ್ಥಾನಾ ಸಬಾ ಮಂದಿರಾತ್ಲಾ ಅಧಿಕಾರಿ ಜಾ಼ಲ್ಯಾಲ್ಯಾ ಯಾಯಿರಾಚಾ ಗರ‍್ಹಾತ್ನಿ ಥೊಡಜಾ಼ನ್ ಯವುನ್, “ತುಜಿ ಲೇಕ್ ಮಿಲಿ ಆತಾ ಪ್ರಬುಲಾ ಕಶಾಲಾ ಕಾಂಬಿವ್ತೊಸ್? ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","ಖರ ಯೇಸುನಿ ತ್ಯಂಚ಼ ಬೊಲ್ನ ದೆನ್ಹಾತ್ ಗೆತ್ಲ ನಾಹಿ ಆನಿ ಸಬಾಮಂದಿರಾತ್‌ಲ್ಯಾ ಅಧಿಕಾರ‍್ಯಾಲಾ , “ಬಿಹು ನಕೊ, ಇಸ್ವಾಸ್ ತ್ಯವ್ಡಾಸ್‍ ರಾಹುನಿ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","ನಂತರ್ ಪೇತ್ರಾ, ಯಾಕೊಬ್, ಯಾಕೋಬಾಚಾ ಬಾಹು ಯೊಹಾನ್ ಹ್ಯನಾ ಸುಡುನ್ ಆನಿ ಕುನಾಲಾ ಆಪ್ಲೆ ಸಂಗ ಯವುದಿಲ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","ತೇ ಸಬಾಮಂದಿರಾತ್ಲಾ ಅಧಿಕಾರಿ ಜಾ಼ಲ್ಯಾಲ್ಯಾ ಯಾಯಿರಾಚಾ ಗರ‍್ಹಾತ್ ಆಲ, ತವಾ ಲೊಕ ಮೊಟ್ಯಾನಿ ರಡತ್ ತಳ್ಮಳತ್ ಗಾನ್ಹಾ ಕರ್ತ್ಯಾಲಿ ಬಗುನ್, ");
INSERT INTO gok_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","ಯೇಸು ಆತ್ ಜಾ಼ವುನ್, “ತುಮಿ ಕಾ ರಡ್ತಾಸಾ? ಕಸ್ಯಾಲಾ ಯವ್ಡಾ ಗಾನ್ಹಾ ಕರ್ತಾಸಾ? ಪ್ಯೊರ್ ಮಿಲಿ ನಾಹಿ, ನಿಜ್ಲೆ಼” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","ತವಾ ಲೊಕಾಂಚಾನಿ ತ್ಯ ಮಸ್ಕರಿ ಸಮಜು಼ನ್ ಹಾಸ್ಲಿತ. ಫನ್ ಯೇಸುನಿ ತ್ಯನಾ ಸಗ್‍ಳ್ಯಾನಾ ಬಾಹಿರ್ ಗಾಲಿವ್ಲಿತ, ಆನಿ ಪುರಿಚಿ ಆಯಿ ಬಾಲಾ ಆನಿ ಆಪ್ಲೆ ಸಂಗ ಆಲ್ಯಾಲ್ಯಾನಾ ಗಿಹುನ್ ಆತ್ ಪ್ಯೊರ್ ಹುತ್ತಿ ತಿಥ ಗೆಲ. ");
INSERT INTO gok_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","ಆನಿ ಪುರಿಚಾ಼ ಹಾತ್ ದರುನ್ ತಿಲಾ, “ತಲಿಥಾ ಕುಮ್!” ಮನ್ಲಾ. ಮಂಜೆ ಹ್ಯಚಾ಼ ಆರ್ಥ “ಬಾಯಾ ಉಟ್!” ಮನ್ಹುನ್. ");
INSERT INTO gok_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","ತವಾಸ್ ತೀ ಪ್ಯೊರ್ ಉಠುನ್ ಚಾ಼ಲಾಯಾ ಲಾಗ್ಲಿ, ತಿ ಬಾರಾ ವರ್ಸಾಚಿ ಪ್ಯೋರ್, ಹ್ಯ ಬಗುನ್ ಲೊಕಾನಾ ಆಜಾಬ್ ಜಾ಼ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","ಮಂಗ್ ಯೇಸುನಿ ತ್ಯನಾ, “ಹ್ಯ ಕುನಾಲಾ ಸಾಂಗು ನಕೊಸಾ ಮನ್ಹುನ್ ಖಡ್ಯಾವುನ್ ಸಾಂಗುನ್ ತೆ ಪುರಿಲಾ “ಖಾಯಾ ದೇವಾ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","ಯೇಸು ತ್ಯೊ ಜಾ಼ಗಾ ಸುಡುನ್ ಆಪ್‌ಲ್ಯಾ ಸ್ವತಾಚಾ ಗಾವಾತ್ ಗೆಲಾ ಆನಿ ತ್ಯಚ಼ ಶಿಶಾ ತ್ಯಚೆ ಮಾಗ್ನಿ ಆಲ. ");
INSERT INTO gok_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","ಸಬ್ಬತ್ ದಿಸಾದಿಸಿ ಯೇಸು ಸಬಾ ಸ್ತಾನಾತ್ ಉಪದೆಸ್ ಸಾಂಗಾಯಾ ಲಾಗ್ಲಾ, ತಿಥ ಖುಬ್ ಲೊಕ ಹುತ್ತಿತ, ತೀ ತ್ಯಚ಼ ಸಬಾತ್ ಐಕುನ್ ಆಜಾಬ್ ಜಾ಼ಲಿತ, ಆನಿ “ಹ್ಯಲಾ ಹ್ಯ ಸಗ್ಳ ಕುಟ್ನಿ ಗಾವ್ಲ? ಕಸ್ಲ ಗಿನ್ಯಾನ್ ಹ್ಯಲಾ ಗಾವಲ್ಯಾ? ಹ್ಯೊ ಕಸಾ ಚಮತ್ಕಾರ್ ಕರೀತ್ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","ಹ್ಯೊ ಸುತಾರ್ ನವ್ಹ? ಹ್ಯೊ ಮರಿಯಾಚಾ಼ ಲ್ಯೊಕ್, ಆನಿ ಯಾಕೊಬ್, ಯೊಸೆ, ಯುದ್, ಸಿಮೊನ್, ಹ್ಯಂಚಾ಼ ಬಾಹು ನವ್ಹ? ಹ್ಯಚಾ ಭನ್ಹಿ ಹಿತ ಆಮ್ಚಿಪ ಹಾತಾ ನವ? ಆಸ ಮನ್ಹುನ್ ತ್ಯಂಚಾನಿ ತ್ಯಚಾ಼ ನಕಾರ್ ಕೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","ತವಾ ಯೇಸು ತ್ಯನಾ, ಆಪ್‍ಲ್ಯಾ ಸ್ವತಾಚಾ ಗರ‍್ಹಾತ್ ಆಪ್ಲೆ ಮಾಯೆತ್ ಆನಿ ಆಪ್‍ಲ್ಯಾ ಗಾವಾತ್‍ ಸುಡುನ್ ದುಸ್ರಿಕ್ಡ ಸಗ್ಳಿಕ್ಡ ಪ್ರವಾದಿಲಾ ಮರ‍್ಯಾದ್ ದೇತ್ಯಾತ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","ಲೊಕಾನಾ ಇಸ್ವಾಸ್ ನವಥಾ ಮನ್ಹುನ್ ತ್ಯನಿ ತಿಥ ಥೊಡ್ಯಾ ರೊಗಿನಾ ಬರಕೆಲ ಹ್ಯಾ ಸಿವಾರ್ ದಿಸ್ರ ಮೊಟ ಕಾಯ್ ಚಮತ್ಕಾರ್ ಕೆಲ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","ಲೊಕಾನಾ ಇಸ್ವಾಸ್ ನಸ್‍ಲ್ಯಾಲಾ ಬಗುನ್ ತ್ಯಲಾ ಖುಬ ಆಜಾಬ್ ಜಾ಼ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","ನಂತರ್ ಯೇಸು ಸರ್ಬೌತಚಾ ಗಾವಾ ಗಾವಾತ್ನಿ ಜಾ಼ವುನ್ ಲೊಕಾನಾ ದೇವಾಚಿ಼ ಬರಿ ಖಬರ್ ಸಾಂಗಾಯಾ ಲಾಗ್ಲಾ. ತ್ಯನಿ ಬಾರಾಜಾ಼ನ್ ಶಿಶಾನಾ ಹಾಕ್ಟುನ್ ತ್ಯನಾ ಲಾಗಿರಾಂಚಿ಼ವ ಹುಕುಮ್ ದಿವುನ್ ದೊಗಾ ದೊಗಾನಾ ದೇವಾಚಿ಼ ಬರಿ ಖಬರ್ ಸಾಂಗಾಯಾ ಲಾವುನ್ ದಿಲ. ");
INSERT INTO gok_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","ಆನಿ ವಾಟನಿ ಜಾ಼ತಾನಾ ಕಾಠಿ ವಾಚು಼ನ್, ಬಾಖ್ರಿ, ಪಿಸ್ವಿ, ಕಿಸ್ಯಾತ್ ಪೈಸ, ಆಸ್ಲ ಕಾಯೇಕ್ ಗಿವು ನಕೊಸಾ, ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","ಪಾಯಾತ್ ವ್ಹಾನಾ ಗಾಲಾ ಖರ ದೊನ್ ಆಂಗ್ಯಾ ಗಿಹು ನಕೊಸಾ. ");
INSERT INTO gok_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","ತುಮಿ ಜಾ಼ತಾನಾ ತುಮಾನಾ ಮಾಯೆನಿ ಗರ‍್ಹಾತ್ ಹಾಕಟ್ಲತ ತುಮಿ ಜಾ಼ವುನ್ ತಿಥ ರಾಯ್ಲಾಸಾತ ತಿಥ್ನಿ ನಿಗುನ್ ಜಾ಼ಯಿಸ್ ಪರತ್ ತಿಥಸ್ ರಾವ್ಹಾ. ");
INSERT INTO gok_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","ಆನಿ ತುಮಿ ಯಕಾ ಗಾವಾತ್ ಯತಾನಾ ತ್ಯಂಚಾನಿ ತುಮಾನಾ ಗೆತ್ಲ ನಾಹಿತ, ಲೊಕಾಂಚಾನಿ ತುಮಿ ಸಾಂಗಲ್ಯಾಲ ಐಕ್ಲ ನಾಹಿ ಮಂಜೆ ತುಮ್ಚಾ ಪಾಯಾಚಿ ಧುಳ್ ತಿಥಸ್ ಜಾ಼ಢಾ; ತೀ ತ್ಯನಾ ಯಚರ್ಕಿಲಾ ರಾಹುನಿ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","ತೇ ತಿಥ್ನಿ ನಿಗಾಲ ಆನಿ ಲೊಕಾನಾ, ಪಶ್ಚಾತಾಪಾನಿ ದೆವಾಕ್ಡ ಪರ್ತಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಪ್ರಸಂಗ್ ಕರುಲಾಗಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","ತ್ಯಂಚಾನಿ ಖುಬ್ ಲಾಗಿರ ಸುಡಿವ್ಲಿತ ಆನಿ ಒಲೀವ್ ತ್ಯಾಲ್ ಲಾವುನ್ ರೊಗಿನಾ ಮಾಗ್ನ ಕೆಲ ತವಾ ತ್ಯನಾ ಬರ ಜಾ಼ಲ. ");
INSERT INTO gok_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","ಯೇಸುಚಿ಼ ಸುದ್ದಿ ಸಗ್ಳಿಕ್ಡ ಪಗಾಳ್ಳಿ ತಿ ಹೆರೊದ್ ರಾಜಾಲಾ ದಿಕಿಲ್ ಪಾವ್ಲಿ. ಥುಡಿ ಲೊಕ “ಬಾಪ್ತಿಸ್ಮಾ ಯೊಹಾನ್ ಜಿ಼ತ್ತಾ ವ್ಹವುನ್ ಆಲ್ಯಾ ಮನ್ಹೂನುಸ್ ಪವಾಡ ಕರ್ತ್ಯಾಲಿ ತಾಕತ್ ಆಲೆ” ಮನ್ಹುನ್ ಬೋಲತಿತ. ");
INSERT INTO gok_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","ಥುಡಿಜ಼ನ ಹ್ಯೊ ಎಲಿಯಾ ಆಸಲ್ ಮನ್ಹಿತಿತ. ಆನಿ ಕಾಯ್ ಥುಡಿ, ಹ್ಯೊ ಪೈಲ್ಯಾ ಕಾಲಾತ್ಲಾ ಯೊಕ್ ಪ್ರವಾದಿ ಆಸ್ನಾರ್ ಮನ್ಹಿತಿತ. ");
INSERT INTO gok_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","ಹ್ಯ ಐಕ್ಲ ತವಾ ಹೆರೊದ್ ರಾಜಾ಼ ಹ್ಯೊ ಬಾಪ್ತಿಸ್ಮಾ ಯೊಹಾನುಸ್ ಮಿ ತ್ಯಚಿ಼ ಡುಯಿ ತ್ಯೊಡ್ಲೆ ಖರ ಆತಾ ತ್ಯೊ ಪರ್ತುನ್ ಜಿತ್ತಾ ವ್ಹವುನ್ ಆಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","ಸ್ವತಾ ಹೆರೊದಾನಿ ಯೊಹಾನಾಲಾ ಬಾಂದುನ್ ಬಂದಿಖಾನ್ಯಾತ್ ಗಾಲಾಯಾ ಸಾಂಗ್ಲ. ಕಾ ಮನ್‌ಲ್ಯಾವ ಹೇರೋದಾಚಾ಼ ಬಾಹು ಪಿಲಿಪ್ ಹ್ಯಚಿ ಬ್ಯಾಯ್ಕೊ ಹೆರೊದಿ, ಹಿ ಹೇರೊದಾ ಸಂಗ ಸುಕ್ಲಿ ಹುತಿ. ");
INSERT INTO gok_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","ಬಾಪ್ತಿಸ್ಮಾ ಯೊಹಾನ್ ಹೆರೊದಾಲಾ, ತುಜಾ ಬಾವ್ಹಾಚೆ ಬ್ಯಾಯ್ಕೊಲಾ ಥಿವುನ್ ಗೆತ್ಲೆಸ್ ತ್ಯ ದರ್ಮ ನವ್ಹ ಮನ್ಹುನ್ ಪರತ್ ಪರತ್ ಮನ್ಹಿತ್ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","ಮನ್ಹುನ್ ಹೆರೊದಿನಿಲಾ ಯೊಹಾನಾವ ರಾಗ್ ಹುತ್ತಾ ತೀ ತ್ಯಲಾ ಮಾರುನ್ ಟಾಕಾಯಾ ಟಪುನ್ ಹುತ್ತಿ ಫನ್ ಹೇರೋದಾಸ್ ಲಾಗುನ್ ಜಾ಼ಲ ನವ್ತ. ");
INSERT INTO gok_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ಯೊಹಾನ್ ಖರಾ ಆನಿ ಪವಿತ್ರ ಮಾನುಸ್ ಜಾ಼ಲ್ಥಾ ಮನ್ಹುನ್ ಹೆರೊದ್ ಬಿಹುನ್. ತ್ಯಲಾ ರಕ್ಶನ್ ದಿವುನ್ ಕಾಯ್ ತರಾಸ್ ದಿಲಾ ನವ್ತಾ, ಯೋಹಾನಾಸ್ ಲಾಗುನ್ ಹೇರೊದಾಚಾ ಮನಾಚಿ಼ ಗಾಹಿ ಜಾ಼ಲಿ ತರಿ ತ್ಯನಿ ಸಾಂಗ್‍ಲ್ಯಾಲ ಸಬ್ದ ಮನಾಪಾಸುನ್ ಐಕಿ. ");
INSERT INTO gok_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","ಆಸ ಆಸ್ಥಾನಾ ಹೆರೊದಿನಿಲಾ ಯೊಕ್ ಬರಾ ಯೊಳ್ ಆಲಾ. ತ್ಯೊ ಹೇರೋದ್ ಜ಼ಲಾಮ್‍ಲ್ಯಾಲಾ ದಿಸ್. ತೀಸಿ ಸರ್ಕಾರಾಚಾ ಆನಿ ಸೈನಿಕಾಂಚಾ, ಗಲಿಲಾಯಾತಲ್ಯಾ ಮೊಟ್ಯಾ ಜಾಂತ್ಯಾನಾ ಹಾಕ್ಟುನ್ ಜೆವಾನ್ ತಯಾರ್ ಕೆಲ. ");
INSERT INTO gok_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","ತವಾ ಹೆರೊದಿನಿಚೆ ಲಿಕಿನಿ ಯವುನ್ ನಾಟಕ್ ಕೆಲಾ ನಾಟ್ಕಾನಿ ಹೇರೋದಾಲಾ ಆನಿ ತ್ಯಚೆ ಬರ್ಬರ್ ಆಸ್‌ಲ್ಯಾಲ್ಯಾನಾ ಆನಂದ್ ಜಾ಼ಲಾ. ತವಾ ಹೇರೋದ್ ತೆ ಪುರಿಲಾ ತುಲಾ ಕ್ಯಾ ಪಾಯ್ಜೆ? ತುಲಾ ಕ್ಯಾ ವ್ಹಯಿತ್ಯ ಮಾಗ್ ದೇತೊ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","ತ್ಯನಿ ಖುಬ್ ಮಾಗ್ನಿ ಇಚಾರ್ಲಿತ, ತು ಕ್ಯಾ ಇಚಾರ್ಲಸ್ ತರಿ ಮಿ ದೆತೊ “ಮಾಜಾ ರಾಜಾತ್ಲ ಆರ್ದ ರಾಜೆ ಮಾಗ್” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","ತೆ ಪೂರಿನಿ ಜಾ಼ವುನ್ ಆಪ್ಲೆ ಆಯಿಲಾ ಇಚಾರ್ಲ “ಮಿ ಕ್ಯಾ ಮಾಗು? ತವಾ ತಿಚೆ ಆಯಿನಿ “ಬಾಪ್ತಿಸ್ಮಾ ಯೋಹಾನಾಚಿ ಡುಯಿ ಮಾಗ್” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","ತವಾ ತಿ ಪ್ಯೋರ್ ಹೇರೋದ್ ರಾಜಾಪ ಪಳತ್ ಯವುನ್ ತು ಆತಾಚೆ ಆತಾ ಮನಾ ಬಾಪ್ತಿಸ್ಮಾ ಯೋಹಾನಾಚಿ ಡುಯಿ ಪರ‍್ಯಾತಿತ್ನಿ ಆನುನ್ ದೇ ಮನ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","ಹ್ಯನಿ ರಾಜಾಲಾ ಖುಬ್ ದುಖ್ ಜಾ಼ಲ ಫನ್ ತ್ಯನಿ ಸಗಳ್ಯಾಂಚೆ ಮೋರ್ಹ ಮನ್‌ಲ್ಯಾಲೆ ಸಾಟಿ ತ್ಯ ನಾಹಿ ಮನ್ಹಾಯಾ ಜಾ಼ಲ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","ಆನಿ ರಾಜಾನಿ ಸಿಪಾಯಿಲಾ ಯೊಹಾನಾಚಿ ಡುಯಿ ಆನಾಯಾ ಲಾವುನ್ ದಿಲಾ; ");
INSERT INTO gok_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ತ್ಯನಿ ಬಂದಿಖಾನ್ಯಾತ್ ಜಾ಼ವುನ್ ಯೋಹಾನಚಿ ಡುಯಿ ತುಡುನ್ ಪರ‍್ಯಾತಿತ್ನಿ ಆನುನ್ ತೇ ಪೂರಿಲಾ ದಿಲಿ. ತೆ ಪೂರಿನಿ ಡುಯಿ ಆಪ್ಲೆ ಆಯಿಲಾ ನಿಹುನ್ ದಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","ಯೊಹಾನಾಚಾ ಶಿಶಾಂಚಾನಿ ಹ್ಯ ಐಕುನ್ ಯವುನ್ ತ್ಯಚ಼ ಮಡ ನಿಹುನ್ ಮಾತಿ ದಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","ಅಪೊಸ್ತಲ್‍ ಪರ್ತುನ್ ಯವುನ್ ತ್ಯಂಚಾನಿ ಯೇಸುಲಾ ಬಗುನ್ ಚಾ಼ಲ್ಯಾಲ ಆನಿ ಶಿಕಿವ್‍ಲ್ಯಾಲ ಸಗ್ಳ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","ಖುಬ್ ಲೊಕ ಯಯಿತ್ ಜಾ಼ಯಿತಿತ ಮನ್ಹುನ್ ಯೇಸುಲಾ ಆನಿ ಶಿಶಾನಾ ಖಾಯಾ ಫುರ್ಸತ್ ನವ್ಥಿ. ತವಾ ಯೇಸುನಿ “ಆಮಿ ಜ಼ರಾ ದುರ್ ಜಾ಼ವುಯಾ ತುಮಾನಾ ತಿಥ ಜ಼ರಾ ಇಶ್ರಾಂತಿ ಗಿಹ್ಯಾ ಗಾವಲ್” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","ತವಾ ತೆ ಯಕ ವ್ಹಡಿತ್ ಬಸುನ್ ಕಡವ ಯಕಾನ್ಸಿ ಜಾ಼ಯಾ ಗೆಲ. ");
INSERT INTO gok_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","ತ್ಯ ಖುಬ್ ಲೊಕಾಂಚಾನಿ ಬಗುನ್ ತ್ಯನಾ ವಳಖುನ್ ತೆ ಜಾ಼ಯಾಚೆ ಆಂದಿ ಸಗಳ್ಯಾ ಗಾವಾತ್ನಿ ಪಾಯ್‌ವಾಟನಿ ಲೊಕ ಪಳತ್ ತ್ಯಂಚೆ ಆಂದಿ ತಿಥ ಪಾವ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","ಯೇಸು ವ್ಹಡಿತ್ನಿ ಉತಾರ್ಲಾ ತವಾ ಯೊಕ್ ಮೊಟಾ ಲೊಕಾಂಚಾ಼ ಹಿಂಡ್ ಬಗ್ಲಾ ಆನಿ ತ್ಯಚಾ ಮನಾತ್ ಕಳಕಳಿ ಆಲಿ. ಕಾ ಮಂಜೆ ತೀ ಗುರಿಕಾ ನಸ್‍ಲ್ಯಾಲ್ಯಾ ಮೆಂಡ್ರಾಂಚೆಗತ್ ಹುತ್ತಿತ. ತ್ಯನಾ ಯೇಸು ಖುಬ್ ಉಪದೆಶ್ ಶಿಕವಾಯಾ ಲಾಗ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","ಖುಬ್ ಯೊಳ್ ಜಾ಼ಲಾ ತವಾ ಶಿಶಾಂಚಾನಿ ಯವುನ್ ಸಾಂಗ್ಲ “ಆತಾ ಯೊಳ್ ಜಾ಼ಲ್ಯಾ ಹ್ಯೊ ಯೆಕಾನ್ಸಿ ಜಾ಼ಗಾ ");
INSERT INTO gok_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","ಲೊಕಾನಾ ಲಾವುನ್ ದೇ ತೀ ಬೌತ್ತಚಾ ಗಾವಾತ್ನಿ ನಾಹಿತ ಸೆತಾತ್ನಿ ಜಾ಼ವುಂತ ತಿಥ ತ್ಯನಾ ಖಾಯಾ ಕಾಯ್ ತರಿ ಗಾವಲ್ ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","ತವಾ ಯೇಸು, ತುಮಿಸ್ ತ್ಯನಾ ಜೆವಾನ್ ದೇವಾ ಮನ್ಲಾ. ತ್ಯಲಾ ತೇ “ಆಮಿ ಜಾ಼ವುನ್ ದೊನ್ ಶಂಬರ್ ಆನ್ಯಾಂಚಾ ಬಾಕ್‌ರ‍್ಯಾ ಗಿವುನ್ ತ್ಯನಾ ಖಾಯಾ ದೇವಾವ ಕ್ಯಾ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","ಯೇಸುನಿ ತುಮ್ಚಿಪ ಕ್ಯವಡ್ಯಾ ಬಾಕ್‌ರ‍್ಯಾ ಹಾತ್ತಾ? ಜಾ಼ವುನ್ ಬಗುನ್ ಯವಾ ಮನ್ಲಾ. ತ್ಯಂಚಾನಿ ಬಗುನ್ ಯವುನ್, ಪಾಚ಼್ ಬಾಕ್‌ರ‍್ಯಾ ದೊನ್ ಬಾಂಗ್ಡ ಹಾತ್ತ ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","ಯೇಸುನಿ ಆಪ್‌ಲ್ಯಾ ಶಿಶಾನಾ ಲೊಕಾನಾ ಗವ್ತಾವ ಪಂಗ್ತಿನಿ ಬಸ್ವಾ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","ತವಾ ಲೊಕ ಪಂಗ್ತಿಲಾ ಪನ್ನಾಸ್ ಶಂಬರ್ ಆಸಿ ಬಸ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","ಮಂಗ್ ಯೇಸುನಿ ಪಾಚ಼್ ಬಾಕ್‌ರ‍್ಯಾ ಆನಿ ದೊನ್ ಬಾಂಗ್ಡ ಗಿವುನ್ ವರ್ ಬಗುನ್ ದೇವಾಲಾ ದಾವುನ್ ತ್ಯಾ ಬಾಕ್‌ರ‍್ಯಾ ಮುಡುನ್, ಲೊಕಾನಾ ವಾಡಾಯಾ ಶಿಶಾಂಚಾ ಹಾತಾತ್ ದಿಲ್ಯಾ ಆನಿ ತೆ ದೊನ್ ಬಾಂಗ್ಡಬಿ ಸಗ್‌ಳ್ಯಾನಾ ವಾಡಾಯಾ ದೀಲ. ");
INSERT INTO gok_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","ತೀ ಸಗ್ಳಿ ಲೊಕ ಜಿ಼ವುನ್ ತ್ರಪ್ತ್ ಜಾ಼ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","ಉರ್ಲ್ಯಾಲ್ಯಾ ಬಾಕ್‌ರ‍್ಯಾಂಚ಼ ಆನಿ ಬಾಂಗಡ್ಯಾಂಚ಼ ತುಕ್ಡ ಶಿಶಾಂಚಾನಿ ಗೊಳಾ ಕೆಲ ತೆ ಬಾರಾ ಟುಪ್ಲಿ ಬರ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","ತಿಥ ಪಾಚ಼್ ಹಾಜಾ಼ರ್ ಬಾಪೊಯಿಸ್ ಹುತ್ತ. ");
INSERT INTO gok_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","ಯೇಸುನಿ, “ಮಿ ಲೊಕಾನಾ ಲಾವುನ್ ದಿವುನ್ ಯತೊ ತುಮಿ ವ್ಹಡಿತ್ ಚ಼ಡುನ್ ಪಲಿಕ್ಡ ಬೆತ್ಸಾಯಿದ್ ಗಾವಾತ್ ಮೋರ್ಹ ಜಾ಼ಯಾಲಾಗಾ” ಮನ್ಹುನ್ ಆಪ್‍ಲ್ಯಾ ಶಿಶಾನಾ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","ಮಂಗ್ ಲೊಕಾಂಚಿಪ್ನಿ ಕಡವ ತ್ಯೊ ಮಾಗ್ನ ಕರಾಯಾ ಗುಢ್ಯಾವ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","ದಿಸ್ ಮಾವಾಳ್ಯಾ ನಂತರ್ ವ್ಹಡಿ ಸಮಿಂದೋರಾಚೆ ಮದ್ದಿ ಆಲ್ತಿ ಆನಿ ಯೇಸು ಯಕ್ಲಾಸ್ ದರವ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","ಶಿಶಾನಾ ಸಮೀಂದೋರಾತ್ ವ್ಹಡಿ ರೆಟಾಲಾ ವ್ಹಯಿನಾ ತ್ಯ ಬಗ್ಲ ಕಾ ಮನ್‌ಲ್ಯಾವ ವ್ಹಡಿಲಾ ಮುರ್ನಿ ವಾರ ಮಾರಿತ್ ಹುತ್ತ ಮನ್ಹುನ್ ಶಿಶಾ ವಳ್ನಾ ಮಾರಿತ, ತವಾ ತಿನಾಸ್ನಿ ಸಾಚೆ ಮದ್ದಿ ಯೇಸು ಪಾನ್ಯಾವ್ನಿ ಚಾ಼ಲತ್ ತ್ಯಂಚೆ ಕಡಸ್ನಿ ಮೋರ್ಹ ಜಾ಼ಯಿತ್ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ಯೇಸು ಸಮಿಂದೋರಾವ ಚಾ಼ಲತ್ಯಾಲಾ ಬಗುನ್ ಶಿಶಾಂಚಾನಿ ಭುತ್! ಮನ್ಹುನ್ ಸಮ್‌ಜು಼ನ್ ಬಿಹುನ್ ಜೊ಼ರಾನಿ ವರಾಡ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","ತವಾಸ್ ಯೇಸು “ದಿರ‍್ಹಾನಿ ರಾವ್ಹಾ! ಮಿ ತ್ಯೊ. ಬಿಹುನಕೋಸಾ!” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","ತವಾ ತ್ಯೊ ವ್ಹಡಿತ್ ಚ಼ಡ್ಲಾ ಆನಿ ವಾರ‍್ಯಾಲಾ ಥಂಡ್ ಕೆಲ ಹ್ಯ ಬಗುನ್ ಶಿಶಾನಾ ಆಜಾಬ್ ವಾಟ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ಕಾ ಮನ್‌ಲ್ಯಾವ ಪಾಚ಼್ ಹಾಜಾ಼ರ್ ಲೊಕಾನಾ ಜೆವಾನ್ ದಿಲ್ಯಾಲ ಖರಿ ಖಬರ್ ತ್ಯನಾ ಸಮಾಜ್ಲಿ಼ ನವ್ಥಿ. ");
INSERT INTO gok_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","ತೆ ಸಮಿಂದೋರಾಚೆ ಪಲಿಕ್ಡ ಪೋಚ಼್ಲ ಆನಿ ಗೆನೆಜರೆತಾಚೆ ದರವ ವ್ಹಡಿ ಬ್ಯಾಂದ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","ತೆ ವ್ಹಡಿತ್ನಿ ಉತಾರ್ಲ್ಯಾ ಬರ್ಬರ್ ಲೊಕಾಂಚಾನಿ ಯೇಸುಲಾ ವಳಕ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ಲೊಕ ಸಿಮತ್ನಿ ಪಳತ್ ಜಾ಼ವುನ್ ತ್ಯೊ ಕುಠ ಕುಠ ಹಾ ಮನ್ಹುನ್ ಐಕ್ಲ ತಿಥ ಹಾತ್ರುನಾತ್ ಆಸ್‍ಲ್ಯಾಲ್ಯಾ ದುಕನ್ಕರ‍್ಯಾನಾ ಹಾತ್ರುನಾ ಸಾಹಿತ್ ಉಚ್ಲು಼ನ್ ಆನ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","ಯೇಸು ಕುಠ ಕುಠ ಗೆಲಾ, ಖೆಡ್ಯಾತಲ್ಯಾ, ಫೆಠತ್‍ಲ್ಯಾ, ಸೆತಾತ್‌ಲ್ಯಾ, ಬಾಜಾ಼ರಾತ್ನಿ. ಲೊಕಾಂಚಾನಿ ಯೇಸುಚಾ ಕಪ್‍ಡ್ಯಾಲಾ ಹಾತ್ ಲಾವಾಯಾ ದುಕನ್ಕರ‍್ಯಾನಾ ಉಚ್ಲು಼ನ್ ಆನ್ಲಿತ. ಕುನಿ ಕುನಿ ಹಾತ್ ಲ್ಯಾವ್ಲಾ ತಿ ಬರಿ ಜಾ಼ಲ್ಹಿತ. ");
INSERT INTO gok_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","ಥೊಡ ಫರಿಸಾಯ್, ಆನಿ ಯೇರುಸಲೇಮಿತ್ನಿ ಆಲ್ಯಾಲ ದರ್ಮ ಶಾಸ್ತಾರ್ ಉಪದೆಸ್ ಕರ್ತ್ಯಾಲ ಯೇಸುಚೆ ಸರ್ ಬೌತ ಜ಼ಮ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","ಯೇಸುಚಾ ಶಿಶಾಂಚಾನಿ ತ್ಯಂಚೆ ಪದ್ದತಿಚೆಗತ್ ಹಾತ್ ದುಹ್ಯಾಚೆ ಆಂದಿ ಖಾತ್ಯಾಲ ಬಗ್ಲ ಮಂಜೆ ಪರಿಸಾಯಾಂಚಾ ಉಪದೆಸಾಚೆಗತ್ ತ್ಯಂಚಾನಿ ಹಾತ್ ದುತ್ಲ ನಾಹಿತ. ");
INSERT INTO gok_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(ಫರಿಸಾಯ್ ಆನಿ ಸಗ್ಳ ಯೆಹುದಿ ಲೊಕ್ ತ್ಯನಾ ಗಾವಲ್ಯಾಲ್ಯಾ ಉಪದೆಸಾ ಶಾರ್ಕ ಹಾತ್ ದುಹ್ಯಾಚೆ ಆಂದಿ ತೇ ಖಾಯಿತ್ ನವ್ಥ. ");
INSERT INTO gok_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","ಆನಿ ಬಾಜಾ಼ರಾತ್ನಿ ಆನ್‌ಲ್ಯಾಲ ಸಾಮಾನ್ ಚಾ಼ಂಗ್ಲ ದುಹ್ಯಾಚೆ ಆಂದಿ ತೇ ಖಾಯಿತ್ ನವ್ಥ, ಆಪ್‌ಲ್ಯಾ ವಡ್ಲಾಂಚಿಪ್ನಿ ಆಲ್ಯಾಲ್ಯಾ ಪದ್ದತಿ. ಮಂಜೆ ಲೋಟ, ಗಾಗ್ರಿ, ತಪ್ಲಿ, ಹಾತ್ರುನ ದುಹ್ಯಾಚಿ಼ ಪದ್ದತ್ ಚಾ಼ಲ್ವಿತ). ");
INSERT INTO gok_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","ಫರಿಸಾಯ್ ಆನಿ ಕ್ಯಾಯ್ದದಾರಾಂಚಾನಿ ಯೇಸುಲಾ, “ತುಜ಼ ಶಿಶಾ ವಾಡವಡ್ಲಾಂಚಿಪ್ನಿ ಆಲ್ಯಾಲಿ ಚಾಲ್ ಕಾ ಶೋಡ್‍ತ್ಯಾತ? ಬುರ್ಶಾ ಹತಾನಿ ಕಾ ಖಾತ್ಯಾತ? ಮನ್ಹುನ್ ಇಚಾರ‍್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","ಯೇಸುನಿ ತ್ಯನಾ ಸಾಂಗ್‌ಲ್ಯಾಲ ಕ್ಯಾ ಮನ್‌ಲ್ಯಾವ “ತುಮ್‍ಚಿ ಶಾರ್ಕ್ಯಾ ಕಪ್‍ಟ್ಯಾನಾ ಯೆಶಾಯಾನಿ ಠಿಕ್ ಸಾಂಗ್‌ಲ್ಯಾ; ಕ್ಯಾ ಮಂಜೆ ಪರ್ಮೇಶ್ವರ ಮಂಥೋ ಹಿ ಲೊಕ ತೊಂಡಾನಿ ಮನಾ ವವ್ಯಾಳ್‌ತ್ಯಾತ, ಖರ ತ್ಯಂಚ಼ ಮನ್ ಮಾಜಿಪ್ನಿ ದುರ್ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","ಹ್ಯಂಚಾನಿ ಮಾಜಿ಼ ಸೇವಾ ಕರುನ್ ಉಪೆಗ್ ಕ್ಯಾ. ಪರ್ಮೇಶ್ವರಾಚಾ಼ ನೆಮ್ ಸುಡುನ್ ಮಾನ್ಸಾನಿ ಕೆಲ್ಯಾಲಾ ನೆಮ್ ಸಿಕಿವ್‌ತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","ತುಮಿ ದೇವಾಚಾ ಆಜ್ಞಾ ಸುಡುನ್ ಮಾನ್ಸಾಚಾ ಉಪದೆಸಾಚೆಗತ್ ಚಾ಼ಲ್ತಾಸಾ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","ಯೇಸುನಿ ಆನಿಕ್ ತ್ಯನಾ “ತುಮಿ ತುಮ್ಚಾ ಉಪದೆಸ್ ಚಾ಼ಲ್ವಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಆನಿ ದೇವಾಚಾ಼ ಉಪದೆಸ್ ಮುಡುನ್ ಗಾಲಾಯಾ ಖುಬ್ ಶಾನ ಹಾಸಾ. ");
INSERT INTO gok_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","ಮೊಶೆನಿ ಕ್ಯಾ ಸಾಂಗ್‌ಲ್ಯಾ ಮನ್‌ಲ್ಯಾವ ‘ಆಪ್ಲೆ ಆಯಿ ಬಾಲಾ ಮರ‍್ಯಾದ್ ದಿಯಾ ವ್ಹಯಿ’ ಮನ್ಹುನ್ ‘ಕೊನ್ ಆಪ್ಲೆ ಆಯಿ ಬಾಲಾ ಸರಾಪ್ತೊ ತ್ಯಲಾ ಮರ್ನಾಚಿ ಶಿಕ್ಷಾ ದಿಯಾ ವ್ಹಯಿ’ ");
INSERT INTO gok_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","ಖರ ತುಮಿ ತ್ಯನಾ ಆಸ ಸಿಕಿವ್ತಾಸಾ ಯಕಾನಿ ಆಪ್ಲೆ ಆಯಿಬಾಲಾ ಬಗುನ್, ಮಿ ತುಮಾನಾ ಬಾಳ್ಗಾಯಾ ಥೆವ್‌ಲ್ಯಾಲಿ ಆಸ್ಥಿ ಕೊರ್ಬಾನ್ ಕೆಲ್ಯಾ (ಮಂಜೆ, ದೇವಾಸಾಟಿ ಥೆವ್‌ಲೆ) ಮನ್ಹುನ್ ");
INSERT INTO gok_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ಆಯಿಬಾಲಾ ಬಾಳಗ್ಲ ನಾಹಿ ಮಂಜೆ ಚು಼ಕ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","ಆಸ್ಹಸ್ ತುಮಿ ದುಸ್‌ರ‍್ಯಾನಾ ಸಿಕಿವ್‌ತ್ಯಾಲ್ಯಾ ಶಿಕ್ಶೆನಾನಿ ದೇವಾಚಾ ಸಬ್ದಾಂಚಿ಼ ನಕಾರ್ ಕರ್ತಾಸಾ. ಆನಿ ಆಸ್ಲಿ ಕಾಮ ಕಿತಿತರಿ ಕರ್ತಾಸಾ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","ಯೇಸುನಿ ಲೊಕಾನಾ ಪರತ್ ಆನಿ ಆಪ್ಲಿಪ ಹಾಕ್ಟುನ್ “ಮಿ ಸಾಂಗ್‌ಲ್ಯಾಲ ಸಗ್ಳಿ ಜ಼ನ ಐಕಾ ಆನಿ ಸಮಜು಼ನ್ ಗೆವಾ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","ಬಾಹಿರ್ನಿ ಮಾನ್ಸಾಚಾ ಪೊಟಾತ್ ಜಾ಼ವುನ್ ತ್ಯಲಾ ಬಾಟಿವ್‌ತ್ಯಾಲ ಕಾಯೇಕ್ ನಾಹಿ; ಖರ ಮಾನ್ಸಾಚಾ ಮನಾತ್ನಿ ಯತ್ಯಾಲಸ್ ತ್ಯಲಾ ಬಾಟಿವ್ತ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","ಜೆ ಕುನಾಲಾ ಐಕಾಯಾ ಕಾನ್ ಹಾತ್ತ ತಿ ಐಕಾ. ");
INSERT INTO gok_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","ಯೇಸು ಮಾನ್ಸಾಂಚಾ ಹಿಂಡಾತ್ನಿ ನಿಗುನ್ ಯಕಾ ಗರ‍್ಹಾತ್ ಗೆಲಾ, ಶಿಶಾಂಚಾನಿ ತ್ಯನಿ ಸಾಂಗ್‌ಲ್ಯಾಲ್ಯಾಚಾ಼ ಆರ್ಥ ಕ್ಯಾ ಮನ್ಹುನ್ ತ್ಯಲಾ ಇಚಾರ್ಲ ತವಾ ");
INSERT INTO gok_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","ಯೇಸು ತ್ಯನಾ, “ತುಮಾನಾಬಿ ತ್ಯ ಸಮಾಜ಼್ಲ ನಾಹಿ? ಬಾಹಿರ್ನಿ ಮಾನ್ಸಾಂಚೆ ಆತ್ ಜಾ಼ತ್ಯಾಲ ತ್ಯಲಾ ಬಾಟ್ವಿತ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","ಕಾ ಮನ್‌ಲ್ಯಾವ ತ್ಯ ತ್ಯಚಾ ಆತ್‌ಮ್ಯಾಲಾ ಲಾಗತ್ ನಾಹಿ ತ್ಯ ಪೊಟಾತ್ ಜಾ಼ವುನ್ ಬಾಹಿರ್ ಯತ ತ್ಯನಿ ತ್ಯ ಬಾಟ್ವಿತ್ ನಾಹಿ ಆಸ ಮಂಜೆ ಖಾತ್ಯಾಲಾ ಜಿ಼ನೊಸ್ ಸಗ್ಳಾ ಬರಾಸ್ ತ್ಯೊ ಖಾವಾವ ಮನ್ಹುನ್ ಯೇಸುನಿ ದಾವುನ್ ದಿಲ” ");
INSERT INTO gok_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","ಯೇಸುನಿ ಆನಿ ಸಾಂಗ್ಲ, ಮಾನ್ಸಾಂಚೆ ಆತ್ನಿ ಬಾಹಿರ್ ಯತ್ಯಾಲಸ್ ಮಾನ್ಸಾನಾ ಬಾಟಿವ್ತ; ");
INSERT INTO gok_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","ಯಕಾ ಮಾನ್ಸಾಚಾ ಮನಾತ್ನಿ ಯತ್ಯಾಲಿ ಪಾಪಾಚಿ ಕಾಮ, ");
INSERT INTO gok_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ರಾಂಡ್ ಸಂಗ್, ಚು಼ರಿ, ಖುನ್, ಪೈಶಾಂಚಿ ಆಸೆ, ಲಬಾಡ್ ಬೋಲಾಚ, ಘಾತ್ ಕರಾಚಾ಼, ಖೊಟಫನ್, ಸಿವ್ಯಾ, ಫಸವಾಚ, ವಾಯಿಟ್ಫನ್, ಗಮೇಂಡಿ. ");
INSERT INTO gok_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","ಹ್ಯೊ ವಾಯಿಟ್ ಇಚಾರ್ ಸಗ್ಳಾ ಮನಾತ್ನಿ ಆತ್ನಿ ಯವುನ್ ಮಾನ್ಸಾಲಾ ಬಾಟಿವ್ತೋ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","ಯೇಸು ತಿಥ್ನಿ ನಿಗುನ್ ತುರ್ ಪೆಠತ್‌ಲ್ಯಾ ಸರ್‌ಬೌಥಚಾ ಪ್ರದೇಶಾತ್‌ಲ್ಯಾ ಯಕಾ ಗರ‍್ಹಾತ್ ಗೆಲಾ ತ್ಯ ಕುನಾಲಾ ಕಳುನಾಹಿ ಮನ್ಹುನ್ ತ್ಯಚಾ ಮನಾತ್ ಹುತ್ತ; ಫನ್ ಮಾನ್ಸಾನಾ ಚು಼ಕುವುನ್ ರಾಹ್ಯಾ ಜಾ಼ಲ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","ತಿಥ ಯಕ ಬಾಯಿಚೆ ಲಿಕಿಲಾ ಲಾಗಿರ್ ದರ್ಲ ಹುತ್ತ ತಿನಿ ಯೇಸುಚಿ ಬಾತ್ನಿ ಐಕ್‌ಲ್ಯಾ ಬರ್ಬರ್ ಯವುನ್ ಯೇಸುಚಾ ಪಾಯಾತ್ ಪಡ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","ತೀ ಯಹುದ್ದಿ ನವ ದುಸರೆ ಜಾ಼ತಿತ್ಲಿ ಗ್ರೀಕಾತ್ಲಿ ಸಿರಿಯಾ ಪ್ರದೇಶಾತ್‌ಲ್ಯಾ ಪೊಯಿನಿಕೆತ್ ಜ಼ಲಾಮಲ್ಯಾಲಿ. ತೀ ಆಪ್ಲೆ ಲಿಕಿವ್ಲ ಲಾಗಿರ್ ಸೊಡ್ವಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಯೇಸುಲಾ ಸಾಂಗಾಯಾ ಲಾಗ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","ಯೇಸು ತಿಲಾ ಮನ್ಲಾ, “ ಆಂದಿ ಪೊರಾಂಚ಼ ಪ್ವಾಟ್ ಬರುನಿ. ಪೊರ ಖಾತ್ಯಾಲಿ ಬಾಖ್ರಿ ಗಿಹುನ್ ಕುತ್‌ರ‍್ಯಾನಾ ಗಾಲಾಚಿ಼ ಬರ ನವ್ಹ. ” ");
INSERT INTO gok_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","ತವಾ ಬಾಯಿ ಮನ್ಲಿ, “ಪ್ರಭು ಪೊರಾಂಚಾನಿ ಖಾವುನ್ ಉರ್ಲ್ಯಾಲಿ ಕುತ್ರಿ ಖಾತ್ಯಾತ. ” ");
INSERT INTO gok_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","ತವಾ ಯೇಸು ತಿಲಾ, “ತು ಚಾ಼ಂಗ್ಲಾ ಉತ್ರಾ ದಿಲಾಸ್ ತವಾಸ್ ತಿಥ ತುಜೆ ಲಿಕಿಲಾ ಲಾಗಿರ ಸುಡುನ್ ಗೆಲ್ಯಾ ತ್ಯ ತು ಗರ‍್ಹಾತ್ ಜಾ಼ವುನ್ ಬಗ್!. ಮನ್ಲಾ ");
INSERT INTO gok_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","ತೀ ಗರ‍್ಹಾತ್ ಗಿಲಿತವಾ ತಿಚಿ ಲೇಕ್ ಪಲಂಗಾವ ಆರಾಮ್ ಹುತ್ತಿ; ಆನಿ ಲಾಗಿರ್ ತಿಲಾ ಸುಡುನ್ ಗೆಲ್ತ. ");
INSERT INTO gok_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","ಯೇಸು ತುರ್ ಪೆಠತ್‌ಲ್ಯಾ ಸರ್‌ಬೌಥಚಾ ಪ್ರದೇಶ್ ಸುಡುನ್ ಸಿದೊನ್ ಪೆಠಚಾ ಮಾರ್ಗಾನಿ ದೆಕಪೊಲಿ ಪ್ರದೇಶಾತ್ನಿ ಗಲಿಲಾಯ್ ಸಮಿಂದೊರಾಪ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","ಥೋಡ್ಯಾ ಜ಼ನಾಂಚಾನಿ ಯಕಾ ಚೊ಼ಚ್ರಾ಼ ಆನಿ ಕಿವಂಡ್ಯಾಲಾ ಯೇಸುಪ ಆನುನ್, “ಹೆಚಿವ ತುಜಾ಼ ಹಾತ್ ಥೆವಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ತ್ಯಲಾ ಇನಂತಿ ಕಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","ತ್ಯನಿ ತ್ಯಲಾ ಮಾನ್ಸಾತ್ನಿ ಬಾಹಿರ್ ನಿಹುನ್ ಆಪ್ಲಿ ಬೊಟ ತ್ಯಚಾ ಕಾನಾತ್ ಗಾಲುನ್ ಥುಕುನ್ ತ್ಯಚೆ ಜಿಬಿಲಾ ಹಾತ್ ಲ್ಯಾವ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","ವರ್ ಬಗುನ್ ಉಸ್ಸಾಸ್ ಸುಡುನ್ ತ್ಯಲಾ “ಯಪಥಾ!” ಮನ್ಲಾ, ತ್ಯಾ ಸಬ್ದಾಲಾ “ಉಗ್ಡುನಿ!” ಮನ್ಹುನ್ ಆರ್ಥ. ");
INSERT INTO gok_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","ತವಾಸ್ ತ್ಯಚ಼ ಕಾನ್ ಉಗಾಡ್ಲ; ಆನಿ ತ್ಯಚೆ ಜಿ಼ಬಿಚ ಬಾಂದಾನ್ ಸುಟ್ಲ ಆನಿ ತ್ಯೊ ನಿಟ್ ಬೋಲಾಯಾ ಲಾಗ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","ತವಾ ಯೇಸುನಿ, “ಹ್ಯ ಕುನಾಲಾ ಸಾಂಗುನಕೊಸಾ” ಮನ್ಹುನ್ ಲೊಕಾನಾ ಸಾಂಗ್ಲ, ಫನ್ ತ್ಯಂಚಾನಿ ಸಗ್ಳಿಕ್ಡ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","ಐಕ್‌ಲ್ಯಾಲ್ಯಾನಾ ಆಜಾಬ್ ಜಾ಼ಲ “ಯೇಸು ಸಗ್ಳ ಬರ ಕರ್ತೊ! ಕಿವಂಡ್ಯಾಂಚಾನಿ ಐಕಿಜೊ಼ಗ, ಚೊ಼ಚ಼ರ‍್ಯಾಂಚಾನಿ ಬೋಲ ಜೊ಼ಗ, ಕರ್ತೊ!” ಮನ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","ಹ್ಯ ಜಾ಼ಲ್ಯಾ ನಂತರ್ ಆನಿ ಯಂಗ್ದಾ ಖುಬ್ ಲೊಕ ಜ಼ಮ್ಲಿ ಹುತ್ತಿತ ತ್ಯನಾ ಜೆವಾನ್ ಕಾಯ್ ನವ್ಥ ತವಾ ಯೇಸುನಿ ಆಪ್‌ಲ್ಯಾ ಶಿಶಾನಾ ಜ಼ವಳ್ ಹಾಕ್ಟುನ್, ");
INSERT INTO gok_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“ಹ್ಯಾ ಲೊಕಾನಾ ಬಗುನ್ ಮನಾ ಬೆಜಾರ್ ವ್ಹತ್ಯೋ, ಹಿ ಮಾಜಿಪ ಯವುನ್ ತೀನ್ ದಿಸ್ ಜಾ಼ಲ; ಹ್ಯಂಚಿಪ ಖಾಯಾ ಕಾಯ್ ನಾಹಿ, ");
INSERT INTO gok_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","ಹ್ಯನಾ ಉಪಾಸಿ ಗರ‍್ಹಾತ್ ಲಾವುನ್ ದಿಲ್ಯಾವ ಹಿ ಜಾ಼ತಾನಾ ವಾಟವ ಬುಕನಿ ಚಕರ್ ಯವುನ್ ಪಡ್ತಿಲ; ಕಾ ಮನ್‌ಲ್ಯಾವ ಹ್ಯಾತ್ಲಿ ಥುಡಿ ಜ಼ನ ದುರ್ನಿ ಆಲ್ಯಾತ” ಮನ್ಹುನ್ ತ್ಯನಾ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","ತ್ಯಲಾ ಶಿಶಾಂಚಾನಿ, “ಹ್ಯಾ ಎಕಾಂತ್ ಪ್ರದೇಶಾತ್ ಯವ್‌ಡ್ಯಾ ಲೊಕಾನಾ ಕುಠ ಜೆವಾನ್ ಗಾವ್‌ನಾರ್” ಮನ್ಹುನ್ ಯೇಸುಲಾ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","ಯೇಸುನಿ ಶಿಶಾನಾ “ತುಮ್ಚಿಪ ಕ್ಯವಡ್ಯಾ ಬಾಕ್‌ರ‍್ಯಾ ಹಾತಾ. ” ಮನ್ಹುನ್ ಇಚಾರ್ಲ ತ್ಯಲಾ ತೆ, “ಸಾತ್ ಹಾತಾ” ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","ತವಾ ಯೇಸುನಿ, ಲೊಕಾನಾ, “ಜಿಮ್ನಿವ ಬಸಾ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ ಆನಿ ತ್ಯಾ ಸಾತ್ ಬಾಕ್‌ರ‍್ಯಾ ಹಾತಾತ್ ಗಿಹುನ್ ಪರ್ಮೇಶ್ವರಾಲಾ ದಾವುನ್ ಬಾಕ್‌ರ‍್ಯಾ ಮುಡುನ್ ಶಿಶಾಂಚಾ ಹಾತಾತ್ ಲೊಕಾನಾ ವಾಡಾಯಾ ದಿಲ್ಯಾ; ತ್ಯಂಚಾನಿ ಲೊಕಾನಾ ವ್ಯಾಟ್‌ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","ಆನಿ ತ್ಯಂಚಿಪ ಥೊಡ ಬಾರಿಕ್ ಬಾಂಗ್ಡ ಹುತ್ತ; ತೆ ಯೇಸುನಿ ಗಿಹುನ್ ಪರ್ಮೇಶ್ವರಾಲಾ ದಾವುನ್ ಶಿಶಾಂಚಾ ಹಾತಾತ್ ದಿವುನ್ ತೆ ಮಾನ್ಸಾನಾ ವಾಟಾಯಾ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","ಪ್ವಾಟ್ಬ ಖಾವುನ್. ಆನಿ ಉರ್ಲ್ಯಾಲ ತುಕ್ಡ ಶಿಶಾಂಚಾನಿ ಜ಼ಮಾ ಕೆಲತೆ ಸಾತ್ ಟುಪ್ಲಿ ಜಾ಼ಲ. ಜೆವ್‌ಲ್ಯಾಲಿ ಲೊಕ ಕಮಿಸ ಕಮಿ ಚಾರ್ ಹಾಜಾ಼ರ್ ಹುತ್ತಿತ. ");
INSERT INTO gok_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ಮಂಗ್ ಯೇಸು ತ್ಯನಾ ಲಾವುನ್ ದಿವುನ್ ತವಾಸ್ ಆಪ್‌ಲ್ಯಾ ಶಿಶಾನಾ ಗಿಹುನ್ ವ್ಹಡಿತ್ ಚ಼ಡುನ್ ದಲ್ಮನೂತ್ ಪ್ರದೇಶಾತ್ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","ಥೊಡ್ಹ ಫರಿಸಾಯ್ ಯೇಸುಪ ಯವುನ್ ತ್ಯಚೆ ಗುಶ್ಟಿತ್ ಕಾಯ್ತರಿ ಚು಼ಕ್ ದರಾಯಾ ತ್ಯಚಿ ಸಂಗ ವಾದ್ ಗಾಲ್ಹಿತ್ ದೇವಾನಿ ತ್ಯಲಾ ಲಾವುನ್ ದಿಲ್ಯಾಲಾ ಜಾ಼ಲ್ಯಾ ತ್ಯನಿ ಆಬ್ಳಾತ್ ಯಾಕ್ ಚಮತ್ಕಾರ್ ಕರಾಯಾ ವ್ಹಯಿ ಮನ್ಹಿತ. ");
INSERT INTO gok_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","ತವಾ ಯೇಸುನಿ ಉಸ್ಸಾಸ್ ಸುಡುನ್, “ಹಿ ಪಿಳ್ಗಿ ಚಮತ್ಕಾರ್ ಇಚಾರ್ತ್ಯಾಲಿ ಕಾ? ತುಮಾನಾ ಖರ ಸಾಂಗ್ತೋ, ಹೆ ಪಿಳ್ಗಿಲಾ ಚಮತ್ಕಾರ್ ಗಾವನ್ಹಾರುಸ್ ನಾಹಿ” ಮನ್ಹುನ್ ಸಾಂಗುನ್. ");
INSERT INTO gok_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","ತ್ಯನಾ ಸುಡುನ್ ಪರ್ತುನ್ ವ್ಹಡಿತ್ ಚ಼ಡುನ್ ಪಲಿಕ್ಡ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","ತ್ಯಚ಼ ಶಿಶಾ ಬಾಕ್‌ರ‍್ಯಾ ಗಿಹ್ಯಾ ಇಸಾರ್ಲ. ವ್ಹಡಿತ್ ತ್ಯಂಚಿಪ ಏಕ್ ಬಾಖ್ರಿ ತ್ಯವ್ಡಿಸ್ ಹುತ್ತಿ; ");
INSERT INTO gok_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","ಯೇಸುನಿ ತ್ಯನಾ, “ಫರಿಸಾಯ್ ಆನಿ ಹೆರೊದಾಚಾ ಆಂಬಾಟ್ ಪಿಠಾಬದಲ್ ಹುಶಾರ್ ರಾವ್ಹಾ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","ತ್ಯಲಾ ತೆ “ಆಮ್ಚಿಪ ಬಾಕ್‌ರ‍್ಯಾ ನಾಹಿತಾ ಮನ್ಹುನ್ ಆಪ್‌ಲ್ಯಾ ಆಪ್‌ಲ್ಯಾತ್ ಬೊಲತ್ ಹುತ್ತ. ");
INSERT INTO gok_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","ಯೇಸುನಿ ತ್ಯ ಸಮ್‌ಜು಼ನ್, “ಬಾಕ್‌ರ‍್ಯಾ ನಾಹಿತಾ ಮನ್ಹುನ್ ಕಸ್ಯಾಲಾ ಬೋಲ್ತಾಸಾ? ತುಮಿ ಆಜು಼ನ್ ಸಮ್‌ಜು಼ನ್ ಗೆತ್ಲನಾಹಿ ಕ್ಯಾ? ತುಮಾನಾ ತಿಳವಳಕಿ ಆಲಿ ನಾಹಿ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","ತುಮ್ಚ ಮನ್ ಘಟ್ ಜಾ಼ಲ ಕ್ಯಾ? ಡೊಳ ಆಸುನ್ ಆಂದ್ಳ ಕ್ಯಾ? ಕಾನ್ ಆಸುನ್ ಕಿಂವ್ಡ ಕ್ಯಾ? ತುಮಾನಾ ಯಾದ್ ನಾಹಿ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ಮಿ ತ್ಯಾ ಪಾಚ಼್ ಬಾಕ್‌ರ‍್ಯಾ ಮುಡುನ್ ಪಾಚ಼್ ಹಾಜಾ಼ರ್ ಲೊಕಾನಾ ವ್ಯಾಟ್‌ಲ್ಯಾತವಾ ತುಕ್ಡ ಬರ್ಲ್ಯಾಲಿ ಟುಪ್ಲಿ ಕ್ಯವ್ಡಿ ನಿಲ್ಹಿಸಾ. ” ಮನ್ಹುನ್ ಇಚಾರ್ಲ ತ್ಯಲಾ ತೆ “ಬಾರಾ ಟುಪ್ಲಿ” ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“ಆನಿ ತ್ಯಾ ಸಾತ್ ಬಾಕ್‌ರ‍್ಯಾ ಚಾರ್ ಹಾಜಾ಼ರ್ ಲೊಕಾನಾ ವ್ಯಾಟ್‌ಲ್ಯಾ ತವಾ ತುಕ್‌ಡ್ಯಾನಿ ಬರ್ಲ್ಯಾಲ್ಯಾ ಬುಠ್ಯಾ ಕ್ಯವಡ್ಯಾ ಗಿಹುನ್ ಗೆಲಾಸಾ” ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ತ್ಯಲಾ ತೆ “ಸಾತ್ ಬುಠ್ಯಾ” ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","ತವಾ ಯೇಸು ತ್ಯನಾ “ತುಮಾನಾ ಆಜು಼ನ್ ಸಮಾಜ್ಲ ನಾಹಿ ಕ್ಯಾ? ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","ತೆ ಬೆತ್ಸಾಯಿತ್ ಆಲ. ತಿಥ ಲೊಕಾಂಚಾನಿ ಯಕಾ ಆಂದ್‍ಳ್ಯಾಲಾ ಯೇಸುಪ ಆನುನ್, “ಹ್ಯಲಾ ತು ಹಾತ್ ಲಾವಾಯಾ ವ್ಹಯಿ” ಮನ್ಹಾಯಾ ಲಾಗ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","ತ್ಯನಿ ಅಂದಳ್ಯಾಚಾ಼ ಹಾತ್ ದರುನ್ ಗಾವಾಚೆ ಬಾಹಿರ್ ಗಿಹುನ್ ಜಾ಼ವುನ್ ತ್ಯಚಾ ಡೊಳ್ಯಾತ್ ಥುಕುನ್ ತ್ಯಚಿವ ಹಾತ್ ಥಿವುನ್, “ತುಲಾ ಕಾಯ್ ದಿಸಥ್ಯಾ ಕ್ಯಾ? ಮನ್ಹುನ್ ತ್ಯಲಾ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","ತ್ಯನಿ ಡುಯಿ ಉಚ್ಲು಼ನ್ ಬಗುನ್ “ಮನಾ ಮಾನ್ಸ ದಿಸಥ್ಯಾತ; ತಿ ಜಾ಼ಢಾಂಚೆಗತ್ ದಿಸ್ಲಿತ ತರಿ ಫಿರತ್ ಹಾತ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","ತವಾ ಯೇಸುನಿ ತ್ಯಚಾ ಡೋಳ್ಯಾವ ಆನಿಕ್ ಹಾತ್ ಥೆವ್ಲಾ; ತ್ಯನಿ ಡೊಳ ಉಗ್ಡುನ್ ಬಗ್ಲ ತವಾ ತ್ಯಲಾ ಬರ ಜಾ಼ಲ ಹುತ್ತ; ಸಗ್ಳ ಚಾ಼ಂಗ್ಲ ದಿಸಾಯಾ ಲಾಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","ಯೇಸು ತ್ಯಲಾ “ತು ಲೊಕಾಂಚಿಪ್ನಿ ಆಲಾಸ್ ತಿಥ ಜಾ಼ವು ನಕೊಸ್” ತುಜಾ ಗರ‍್ಹಾತ್ ಜಾ಼ ಮನ್ಹುನ್ ಲಾವುನ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","ಯೇಸು ಆನಿ ತ್ಯಚ಼ ಶಿಶಾ ಫಿಲಿಪಾಚಾ ಕೈಸರಾಚಾ ಜ಼ವಳ್ಚಾ ಗಾವಾಗಿರ್ಮಾತ್ನಿ ನಿಗಾಲ. ವಾಟವ ತ್ಯನಿ, “ಲೊಕ ಮನಾ ಕೊನ್ ಮಂಥ್ಯಾತ? ಮನ್ಹುನ್ ಆಪ್‍ಲ್ಯಾ ಶಿಶಾನಾ ಇಚಾರ್ಲ ತ್ಯಲಾ ತೆ. ");
INSERT INTO gok_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","“ತುಲಾ ಥುಡಿಜ಼ನ ಬಾಪ್ತಿಸ್ಮಾ ಯೊಹಾನ್ ಮನ್‌ಥ್ಯಾತ; ಥುಡಿ ಯಲಿಯಾ ಮಂಥ್ಯಾತ; ಆನಿ ಥುಡಿ ಪ್ರವಾದಿತ್ಲಾ ಯೊಕ್ ಮನ್‌ಥ್ಯಾತ” ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","ಯೇಸು ತ್ಯನಾ, “ಖರ ತುಮಿ ಮನಾ ಕೊನ್ ಮಂಥಾಸಾ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ ತ್ಯಲಾ ಪೇತ್ರ, “ತು ಯನಾರಾ ಕ್ರಿಸ್ತ್” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","ತವಾ ಯೇಸು “ಹ್ಯ ಕುನಾಲಾ ಸಾಂಗು ನಕೊಸಾ” ಮನ್ಹುನ್ ತ್ಯನಾ ಖಡ್ಯಾವುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","ಯೇಸು ಆಪ್‌ಲ್ಯಾ ಶಿಶಾನಾ ಸಾಂಗಾಯಾ ಲಾಗ್ಲಾ, “ಮಾನ್ಸಾಚಾ಼ ಲ್ಯೊಕ್ ಖುಬ್ ತರಾಸ್ ಖಾನಾರ್ ಜಾಂತ ತ್ಯಲಾ ನಕ್ವಾಟ್ ಕರ್ನಾರ್, ಮುಖ್ಯ ಯಾಜಕ್, ದರ್ಮ ಶಾಸ್ತಾರ್ ಸಾಂಗ್‌ತ್ಯಾಲ ತ್ಯಚಾ಼ ರಾಗ್ ಕರ್ನಾರ್ ತ್ಯಲಾ ಮಾರಾಯಾ ದೆನಾರ್ ಆನಿ ತೀನ್ ದಿಸಾ ನಂತರ್ ಜಿ಼ತ್ತಾ ವ್ಹವುನ್ ಉಠುನ್ ಯನಾರ್” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","ತ್ಯನಿ ಹೆ ಸಬಾತ್ ಉಗ್ಡುನ್ ಸಾಂಗ್ಲ. ತವಾ ಪೇತ್ರ ತ್ಯಚಾ಼ ಹಾತ್ ದರುನ್ ತ್ಯಲಾ ದಪ್‌ಕಾವಾಯಾ ಲಾಗ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","ಯೇಸು ಮಾಗಾರಾ ಪರ್ತುನ್ ಆಪ್‌ಲ್ಯಾ ಶಿಶಾನಾ ಬಗುನ್ ಪೇತ್ರಾಲಾ, “ಸೈತಾನಾ, ಮಾಜೆ ಮೋರ್ಹ ಉಬಾ ರಾಹು ನಕೊ! ಚ಼ಲಾಯಾ ಲಾಗ್! ತುಜಾ಼ ಇಚಾರ್ ಮಾನ್ಸಾಚಾ ಇಚಾರ್ ದೇವಾಚಾ಼ ನವ್ಹ” ಮನ್ಹುನ್ ದಪ್‌ಕ್ಯಾವುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","ತ್ಯಾ ನಂತರ್ ತ್ಯನಿ ಆಪ್‌ಲ್ಯಾ ಶಿಶಾಂಚೆ ಸಂಗ ಲೊಕಾನಾ ಜ಼ವಳ್ ಹಾಕ್ಟುನ್ ತ್ಯನಾ ಕ್ಯಾ ಸಾಂಗ್ಲ ಮನ್‌ಲ್ಯಾವ, “ಕುನಾಲಾ ತರಿ ಮಾಜೆ ಮಾಗ್ನಿ ಯಯಾ ಮನ್ ಆಸ್ಲತ ತ್ಯನಿ ಆಪ್ಲ ಸಗ್ಳ ಇಸ್ರುನ್ ತ್ಯಚಾ಼ ಶಿಲ್ಬೆಚಾ಼ ಖಾಂಬ್ ತ್ಯೊಸ್ ಗಿಹುನ್ ಮಾಜೆ಼ ಮಾಗ್ನಿ ಯವುನಿ. ");
INSERT INTO gok_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","ಕೊನ್ ಆಪ್ಲಾ ಜೀವ್ ಹ್ಯಾ ಲೋಕಾಮದಿ ಉರ್ವಾ ವ್ಹಯಿ ಮನ್ಥೊ ತ್ಯಚಾ಼ ಜೀವ್ ನಾಸ್ ವ್ಹನ್ಹಾರ್; ಫನ್ ಮಾಜಿ಼ಸ್ ಲಾಗುನ್, ಆನಿ ಸೂವಾರ್ತೆಸ್ ಲಾಗುನ್ ಆಪ್ಲಾ ಜೀವ್ ದಿಯಿಲ್ ತ್ಯಲಾ ಶಾಸ್ವಿತ್ ಜೀವ್ ಗಾವಲ್. ");
INSERT INTO gok_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","ಯಕಾ ಮಾನ್ಸಾನಿ ಜ಼ಗ್ ಸಗ್ಳಾ ಮಿಳ್ವುನ್ ಆಪ್‌ಲ್ಯಾ ಜೀವಾಚಾ಼ ನಾಸ್ ಕರುನ್ ಗೆತಲ್ಯಾವ ತ್ಯಲಾ ಕ್ಯಾ ಉಪೆಗ್? ");
INSERT INTO gok_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","ಆಪ್ಲಾ ಜೀವ್ ಮಾಗಾರಾ ಗಿಹ್ಯಾ ಕ್ಯಾ ದಿಯಾ ವ್ಹಯಿಲ್? ಕಾಯೇಕ್ ನಾಹಿ! ");
INSERT INTO gok_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","ವ್ಯಬಿಚಾರಾಚೆಗತ್ ಆಸ್‌ಲ್ಯಾಲೆ ಹೆ ಪಾಪಿ ಪಿಳ್ಗಿ ಮದಿ ಕೊನ್ ಮನಾ ಆನಿ ಮಾಜಾ ಸಬ್ದಾನಾ ಲಾಸ್ತೋ, ತ್ಯಲಾ ಮಾನ್ಸಾಚಾ ಲ್ಯೊಕ್ ಆಪ್ನು ಆಪ್‌ಲ್ಯಾ ಬಾಚೆ ಮೈಮೆನಿ ಚ಼ಮಾಕತ್ಯಾಲ್ಯಾ ಉಜಿಡಾನಿ ಪವಿತ್ರ ದೇವ್ದುತಾಂಚೆ ಸಂಗ ಯತಾನಾ ಲಾಜ಼ಲ್. ");
INSERT INTO gok_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","ಆನಿಕ್ ತ್ಯನಾ “ತುಮಾನಾ ಖರ ಸಾಂಗ್ತೊ, ಹಿತ ರಾಹಿಲ್ಯಾಲ್ಯಾತ್ ಥೋಡಿಜ಼ನ ದೇವಾಚ಼ ರಾಜೆ ಬಾಚೆ ತಾಕ್ತಿನಿ ಚ಼ಮಾಕತ್ಯಾಲ್ಯಾ ಉಜಿಡಾನಿ ಯತ್ಯಾಲ ಬಗಿಸ್ ಪರ‍್ಯಾತ್ ಮರಾನ್ ಪಾವ್ನಾರ್ ನಾಹಿತ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","ಸಾ ದಿಸ್ ಜಾ಼ಲ್ಯಾ ನಂತರ್ ಯೇಸುನಿ ಪೇತ್ರಾ, ಯಾಕೊಬ್, ಯೊಹಾನ್, ಹ್ಯನಾ ಆಪ್ಲೆ ಸಂಗ ಯಕಾ ಮೊಟ್ಯಾ ಗುಢ್ಯಾವ ಯಕಿಕ್ಡ ನೆಲ ಆನಿ ತಿಥ ತ್ಯಂಚೆ ಮೋರ್ಹ ತ್ಯಚ಼ ರುಪ್ ಬದಾಲ್ಲ; ");
INSERT INTO gok_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ತ್ಯಚ಼ ಕಪ್ಡ ಚ಼ಕ್ಚ಼ಕಿತ್ ಪಾಂಡ್ರಖಡ್ ಜಾ಼ಲ ಹುತ್ತ ತ್ಯವ್ಡ ಪಾಂಡ್ರ ವ್ಹಯಿಸ ಕಪ್ಡ ದುನ್ಹಾರಾ ಹೆ ದರ್ಥಿವ ಕೊನ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","ತವಾ ಮೋಸೆ ಆನಿ ಯಲಿಯಾ ಸಾಹಿತ್ ತ್ಯನಾ ತಿಥ ದಿಸ್‌ಲ; ತೆ ಯೇಸು ಸಂಗ ಬೊಲತ್ ಹುತ್ತ. ");
INSERT INTO gok_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","ತವಾ ಪೇತ್ರಾ ಯೇಸುಲಾ ಮನ್ಲಾ, ಪ್ರಬುಜಿ಼, ಆಮಿ ಹಿತ್ತ ರಾಯ್‍ಲ್ಯಾವ ಬರ ಹಾ; ತವಾ ಆಮಿ ತೀನ್ ಮಾಂಡಾವ್ಟ ಗಾಲುಯಾ, ತುಲಾ ಯೊಕ್, ಮೋಸೆಸಾಟಿ ಯೊಕ್ ಆನಿ ಯಲಿಯಾ ಸಾಟಿ ಯೊಕ್. ");
INSERT INTO gok_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","ಕ್ಯಾ ಬೊಲಾಚ಼ ತ್ಯ ತ್ಯಲಾ ಸಮಾಜ಼ಲ ನಾಹಿ; ಮನ್ಹುನ್ ಆಸಾ ಬೋಲ್ಲಾ. ಆನಿ ತೆ ಖುಬ್ ಬಿಹ್ಯಾಲ ಹುಥ. ");
INSERT INTO gok_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","ತಿತ್‍ಕ್ಯಾತ್ ತ್ಯಂಚಿವ ಯೊಕ್ ಢಗ್ ಯವುನ್ ದಡಿವ್ಲ. ಆನಿ ತ್ಯಾ ಡಘಾತ್ನಿ “ಹ್ಯೊ ಮಾಜಾ಼ ಮಾಯೆಚಾ಼ ಲ್ಯೊಕ್; ಹ್ಯಚ಼ ಸಬ್ದ ಐಕಾ” ಮನ್ಹುನ್ ಅವಾಜ಼್ ಆಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","ತವಾಸ್ ತ್ಯಂಚಾನಿ ಸರ್ಬೌತ ಬಗ್ಲ ತವಾ ತ್ಯನಾ ಯೇಸುಸಿವಾರ್ ಆನಿ ಕೊನ್ ದಿಸ್ಲ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","ತೆ ತ್ಯಾ ಗುಢ್ಯಾವ್ನಿ ಉತ್ರುನ್ ಯತಾನಾ ಯೇಸುನಿ ತ್ಯನಾ “ತುಮಿ ಬಗ್‍ಲ್ಯಾಲ ಮಾನ್ಸಾಚಾ಼ ಲ್ಯೊಕ್ ಮರುನ್ ಜಿ಼ತ್ತಾ ವ್ಹವುನ್ ಯಯಿಸ್ ಪರ‍್ಯಾತ್ ಕುನಾಲಾ ಸಾಂಗುನಾಹಿ ಮನ್ಹುನ್ ಖಡ್ಯಾವುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","ತ್ಯಂಚಾನಿ ಹ್ಯೊ ಸಬ್ದ ದರ‍್ಹುನ್ ಮರುನ್ ಜಿತ್ತಾ ವ್ಹವುನ್ ಯಯಾಚ಼ ಮಂಜೆ ಕ್ಯಾ ಮನ್ಹುನ್ ಯಕಾಮಕಾಲಾ ಇಚಾರಾಯಾ ಲಾಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","ಆನಿ ತ್ಯಂಚಾನಿ ತ್ಯಲಾ “ಯಲಿಯಾ ಆಂದಿ ಯಯಾಚಿ ಗರಜ಼್ ಹಾ ಮನ್ಹುನ್ ಕ್ಯಾಯ್ದದಾರ್ ಮಂಥ್ಯಾತ ನವ್ಹ, ಹ್ಯ ಕಸ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ ತವಾ ತ್ಯನಿ. ");
INSERT INTO gok_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","“ಯಲಿಯಾ ಆಂದಿ ಯವುನ್ ಸಗ್ಳ ಶಾರ್ಕ ಕರ್ನಾರ್ ತ್ಯ ಖರ. ಆನಿ ಮಾನ್ಸಾಚಾ ಲೇಕಾನಿ ಖುಬ್ ದುಃಖ್ ಸುಸ್ವುನ್ ಗಿಹ್ಯಾ ವ್ಹಯಿ ನಿಂದಾ ಕರುನ್ ಗಿಹ್ಯಾ ವ್ಹಯಿ ಆಸ ತ್ಯಚಿ ಖಬರ್ ಲಿವ್ಲೆ ತ್ಯ ಕಸ? ");
INSERT INTO gok_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","ಖರ ಮಿ ತುಮಾನಾ ಸಾಂಗಾಚ಼ ಕ್ಯಾ ಮಂಜೆ, ಯಲಿಯಾ ಆಂದಿಸ್ ಆಲ್ಯಾ; ಆನಿ ವಚನಾತ್ ಲಿವ್‍ಲ್ಯಾ ಶಾರ್ಕ ತ್ಯಲಾ ಲೊಕಾಂಚಾನಿ ಆಪ್‍ಲ್ಯಾ ಮನಾಸ್ ವಾಟಲ್ ತಸಾ ತರಾಸ್ ದಿಲಾ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","ನಂತರ್ ತೆ ರಾಯ್‌ಲ್ಯಾಲ್ಯಾ ಶಿಶಾಂಚಿಪ ಯವುನ್ ತ್ಯಂಚೆ ಸರ್ಬೌತಿ ಲೊಕ ಜ಼ಮಲ್ಯಾಲಿ ಆನಿ ತ್ಯಂಚೆ ಸಂಗ ಕ್ಯಾಯ್ದದಾರ್ ಸಿಕ್‌ಲ್ಯಾಲ ವಾದ್ ಗ್ಯಾಲಥ್ಯಾಲ ಬಗ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","ತವಾಸ್ ತ್ಯಾ ಲೊಕಾಂಚಾನಿ ಯೇಸುಲಾ ಬಗುನ್ ಯಗ್ದಮ್ ಆಜಾಬ್ ವ್ಹವುನ್ ತ್ಯಚಿಪ ಪಳತ್ ಯವುನ್ ತ್ಯಲಾ ನಮಸ್ಕಾರ್ ಕೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","ತ್ಯನಿ ಶಿಶಾನಾ, “ಹ್ಯಂಚಿ ಸಂಗ ಕಶಾಸಾಟಿ ವಾದ್ ಗಾಲಿತಾಸಾ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ ತವಾ. ");
INSERT INTO gok_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","ಯಕಾನಿ “ಪ್ರಬು, ಮಾಜಾ ಲೇಕಾಲಾ ತುಜಿಕ್ಡ ಗಿಹುನ್ ಆಲ್ತೊ; ತ್ಯಲಾ ಲಾಗಿರ್ ಲಾಗ್‌ಲ್ಯಾ ತವಾಚಾನ್ ತ್ಯೊ ಬೊಲತ್ ನಾಹಿ; ");
INSERT INTO gok_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","ತ್ಯ ತ್ಯಚಿವ ಕವಾ ಯತ ತವಾ ತ್ಯಲಾ ಪಾಡುನ್ ಗ್ಯಾಲ್ತ; ತವಾ ತ್ಯಚಾ ತೊಂಡಾತ್ನಿ ಫ್ಯೊಸ್‌ಯವುನ್ ಕಾರ್ ಕಾರ್ ದಾತ್ ಚಾ಼ವಿತ್ ತಾಠೊ. ತ್ಯ ಸೊಡ್ವಾಯಾ ತುಜಾ ಶಿಶಾನಾ ಸಾಂಗ್ಲ; ತ್ಯನಾ ಜಾ಼ಲ ನಾಹಿ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","ತ್ಯಲಾ ಯೇಸು, “ಆರ ಇಸ್ವಾಸ್ ನಸ್‌ಲ್ಯಾಲೆ ಪಿಳ್ಗೆ? ಮಿ ಆಜು಼ನ್ ಕೆವ್ಡ ದಿಸ್ ತುಮ್ಚೆ ಸಂಗ ರಾವು? ಆಜು಼ನ್ ಕೆವ್ಡ ದಿಸ್ ತುಮಾನಾ ಸಂಬ್ಯಾಳು? ಪ್ಯೋರ್ಗ್ಯಾಲಾ ಮಾಜಿ಼ಪ ಗಿಹುನ್ ಯವಾ. ");
INSERT INTO gok_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","ತ್ಯಾ ಪ್ಯೋರ್ಗ್ಯಾಲಾ ತ್ಯಚಿಪ ಗಿಹುನ್ ಆಲಿತ. ಯೇಸುಲಾ ಬಗ್‌ಲ್ಯಾ ಬರ್ಬರ್ ತ್ಯಾ ಲಾಗಿರಾನಿ ಪ್ಯೋರ್ಗ್ಯಾಲಾ ಟ್ಯಾಕ್ಲ ತವಾ ತ್ಯಲಾ ಫೀಟ್ ಆಲಿ ಆನಿ ತ್ಯಚಾ ತೊಂಡಾತ್ನಿ ಫ್ಯೊಸ್‌ಯವುನ್ ಲೊಳಾಯಾ ಲಾಗ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","ಯೇಸುನಿ ತ್ಯಚಾ ಬಾಲಾ, “ಹ್ಯ ಹ್ಯಚಿವ ಯವುನ್ ಕ್ಯವ್ಡ ದಿಸ್ ಜಾ಼ಲ” ಮನ್ಹುನ್ ಇಚಾರ್ಲ ತವಾ ತ್ಯನಿ. ");
INSERT INTO gok_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","“ನ್ಹಾನ್ ಆಸ್ಥಾನಾಸ್ ಆಲ್ಯಾ; ಆನಿ ಹ್ಯಲಾ ಮಾರುನ್ ಟಾಕಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಕವಾ ಕವಾ ಇಸ್‌ಥ್ಯಾತ್, ಪಾನ್ಯಾತ್ ಪ್ಯಾಡ್‌ಲ್ಯಾ; ತುಜಿಪ್ನಿ ವ್ಹಯಾಚ಼ ಆಸ್ಲತ ಆಮ್ಚಿವ ಕರುನಾ ದಾವುನ್ ಆಮಾನಾ ಮಜ಼ತ್ ಕರ್” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","ಯೇಸು ತ್ಯಲಾ “ತುಜಿಪ್ನಿ ವ್ಹಯಾಚ಼ ಆಸ್ಲತ ಮಂಥೊಸ್? ಇಸ್ವಾಸ್ ಥೆವ್‌ಲ್ಯಾಲ್ಯಾಲಾ ಸಗ್ಳ ವ್ಹತ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","ತ್ಯಾ ಬರ್ಬರ್ ಪ್ಯೋರ್ಗ್ಯಾಚಾ಼ ಬಾ “ಇಸ್ವಾಸ್ ಥೆವ್ತೊ, ಮನಾ ಇಸ್ವಾಸ್ ಕಮ್ಮಿ ಆಸ್ಲಾತ ತು ಮಜ಼ತ್ ಕರ್” ಆಸಾ ಜೊ಼ರಾನಿ ವರ್ಡುನ್ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","ತವಾ ಯೇಸುನಿ ಲೊಕ ಗೊಳಾ ವ್ಹತ್ಯಾಲಿ ಬಗುನ್ ತ್ಯಾ ಲಾಗಿರಾಲಾ ದಪ್‌ಕ್ಯಾವುನ್, “ಯೇ ಐಕು ಆನಿ ಬುಲು ದಿಯಿ ನಸ್ನಾರ‍್ಯಾ ಲಾಗಿರಾ, ಹ್ಯಲಾ ಸುಡುನ್ ಜಾ಼; ಹಿತ್ನಿ ಮೋರ್ಹ ದರ‍್ಹುನಕೊ ಮನ್ಹುನ್ ಮಿ ತುಲಾ ಆಜ್ಞೆ ದೆತ್ಯೊ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","ತವಾ ತ್ಯಾ ಲಾಗಿರಾನಿ ತ್ಯಲಾ ಜೊ಼ರಾನಿ ಲುಳ್ವುನ್ ಸುಡುನ್ ಗೆಲ. ತ್ಯೊ ಪ್ಯೊರ್ಗಾ ಮೆಲ್ಯಾಚೆಗತ್ ಪಡ್ಲಾ ತವಾ ಖುಬ್ ಲೊಕ, “ತ್ಯೊ ಮೆಲಾ ಮನ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","ಖರ ಯೇಸುನಿ ಹಾತ್ ದರ‍್ಹುನ್ ಉಚ಼ಲ್ಲಾ ತಸಾ ಉಠುನ್ ಉಬಾ ರಾಯ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","ಯೇಸು ಗರ‍್ಹಾತ್ ಆಲಾ ತವಾ ತ್ಯಚಾ ಶಿಶಾಂಚಾನಿ, “ತ್ಯ ಸೋಡ್ವಾಯಾ ಆಮಾನಾ ಕಾ ಜಾ಼ಲ ನಾಹಿ ಮನ್ಹುನ್ ಯಕಾನ್ಸಿ ತ್ಯಲಾ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","ತ್ಯಲಾ ತ್ಯನಿ, “ಹಿ ಜಾತ್ ದೇವಾಪಲ್ಯಾ ಮಾಗ್‍ನ್ಯಾ ಸಿವಾರ್ ಆನಿ ಕಶಾನಿ ಜಾ಼ಯಿತ್ ನಾಹಿ ಮನ್ಹುನ್ ತ್ಯನಾ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","ಯೇಸು ಆನಿ ತ್ಯಚ಼ ಶಿಶಾ ತಿಥ್ನಿ ನಿಗುನ್ ಗಲಿಲಾಯಾತ್ನಿ ಜಾ಼ಯಿತ್ ಹುತ್ತ, ಹ್ಯ ಲೊಕಾನಾ ಸಮ್‌ಜು಼ ನಾಹಿ ಆಸ ತ್ಯಚಾ ಮನಾತ್ ಹುತ್ತ. ");
INSERT INTO gok_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ಕಾ ಮನ್‌ಲ್ಯಾವ ತ್ಯೊ ಆಪ್‌ಲ್ಯಾ ಶಿಶಾನಾ ಸಿಕ್ವಿತಾ “ಮಾನ್ಸಾಚಾ ಲೇಕಾಲಾ ಲೊಕಾಂಚಾ ಹಾತಾತ್ ದಿಯಾ ಲಾಗ್ನಾರ್; ತಿ ತ್ಯಲಾ ಮಾರುನ್ ಟ್ಯಾಕ್ನಾರ್; ಮೆಲ್ಯಾವ ತ್ಯೊ ತೀನ್ ದಿಸಾ ನಂತರ್ ಜಿ಼ತ್ತಾ ವ್ಹವುನ್ ಉಠುನ್ ಯನಾರ್” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","ಫನ್ ಶಿಶಾನಾ ತೆ ಸಬ್ದ ಸಮಾಜ಼್ಲ ನಾಹಿತ, ಖರ ಯೇಸುಲಾ ಪರ್ತುನ್ ಇಚಾರಾಯಾ ಬಿಹ್ಯಾಲ. ");
INSERT INTO gok_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","ಆನಿ ತೇ ಕಪೆರ್ನೌಮತ್ ಆಲ. ತಿಥ ತ್ಯೊ ಯಖಾ ಗರ‍್ಹಾತ್ ಆಸ್ಥಾನಾ, “ತುಮಿ ವಾಟವ ಕ್ಯಾ ಬೋಲತಾಸಾ” ಮನ್ಹುನ್ ಶಿಶಾನಾ ಇಚಾರ್ಲ ತವಾ ತೇ ಗಪ್ ರಾಯ್ಲ; ");
INSERT INTO gok_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","ಕಾ ಮಂಜೆ ತೇ ವಾಟವ ಯಕಾಮಕಾ ಸಂಗ ಆಪ್‌ಲ್ಯಾತ್ ಮೊಟಾ ಕೊನ್ ಮನ್ಹುನ್ ಬೊಲತ. ");
INSERT INTO gok_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","ಯೇಸು ಖಾಲ್ ಬಸ್ಹುನ್ ಆಪ್‌ಲ್ಯಾ ಬಾರಾ ಜಾ಼ನ್ ಶಿಶಾನಾ ಹಾಕ್ಟುನ್ ತ್ಯನಾ, “ಕಚಾ಼ತರಿ ಮೊಟಾ ವ್ಹಯಾ ವ್ಹಯಿ ಆಸ್ಲತ ತ್ಯನಿ ಸಗ್‍ಳ್ಯಾಂಚಿವ್ನಿ ಬಾರಿಕ್ ಸಗ್‍ಳ್ಯಾಂಚಾ಼ ಸೇವಕ್ ವ್ಹಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಸಾಂಗುನ್. ");
INSERT INTO gok_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","ಯಕಾ ಬಾರಿಕ್ ಮೂಲಾಲಾ ಗಿಹುನ್ ತ್ಯಂಚೆ ಮದ್ದಿ ಉಬ ಕರುನ್ ಯಾಂಗ್ ಗಾಲ್ಹುನ್ ತ್ಯನಾ ಮನ್ಲಾ, ");
INSERT INTO gok_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“ಕಚಾನಿತರಿ ಮಾಜಾ ನಾವಾನಿ ಆಸ್‌ಲ್ಯಾ ಯಕಾ ಬಾರಿಕ್ ಮೂಲಾಲಾ ಗಿಹಿಲ್ ತ್ಯನಿ ಮನಾ ಗೆತಲ್ಯಾ ಪರ್ಮಾನ್ ಜಾ಼ಲ; ಆನಿ ಕಚಾನಿತರಿ ಮನಾ ಗೆತ್ಲ ತ ಮನಾ ನವ್ಹ, ಮನಾ ಲಾವುನ್ ದಿಲ್ಯಾಲ್ಯಾಲಾಸ್ ಗೆತಲ್ಯಾ ಪರ್ಮಾನ್ ಜಾ಼ಲ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","ಯೊಹಾನ್ ತ್ಯಲಾ “ಪ್ರಬು, ಕೊನ್ ಯೊಕ್ ತುಜಾ ನಾವಾನಿ ಲಾಗಿರ್‍ ಸುಡಿವ್‌ತ್ಯಾಲಾ ಆಮಿ ಬಗುನ್ ತ್ಯೊ ಆಮ್ಚಾತ್ಲಾ ನವ್ಹ ಮನ್ಹುನ್ ತ್ಯಲಾ ಆಡ್ಯಾವ್ಲಾ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","ತವಾ ಯೇಸು, “ತ್ಯಲಾ ಆಡ್ಯಾವು ನಕೊಸಾ; ಮಾಜಾ ನಾವಾನಿ ಚಮತ್ಕಾರ್ ಕರುನ್ ತವಾಸ್ ಮಾಜಿ಼ ನಿಂದಾ ಕರ್ನಾರಾ ಕೊನ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","ಆಮಾನಾ ಆಡ್ವ ಕರಿನಸ್ನಾರಾ ತ್ಯೊ ಆಮ್‍ಚಾ಼ಸ್. ");
INSERT INTO gok_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","ಕ್ರಿಸ್ತಾಚ಼ ಮನ್ಹುನ್ ತುಮಾನಾ ಕಚಾನಿತರಿ ಏಕ್ ತಾಂಬ್ಯಾ ಪಿಯಾ ಪಾನಿ ದಿಲ್ಯಾವ ತ್ಯಲಾ ತ್ಯಚ಼ ಪ್ರತಿ ಫಳ್ ಚು಼ಕತ್ ನಾಹಿ ಮನ್ಹುನ್ ತುಮಾನಾ ಖರ‍್ಯಾನಿ ಸಾಂಗ್ತೊ.” ಮನ್ಲಾ ");
INSERT INTO gok_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","ಆನಿ ಇಸ್ವಾಸ್ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ಹ್ಯಾ ಬ್ಯಾರ್ಕ್ಯಾತ್‌ಲ್ಯಾ ಯಕಾಲಾ ಕಚಾನಿತರಿ ಆಡ್ಯಾವ್ಲತ ತಸ್‌ಲ್ಯಾಚಾ ಗಳ್ಯಾತ್ ಜಾ಼ತ ಬಾಂದುನ್ ತ್ಯಲಾ ಸಮಿಂದೊರಾತ್ ಟ್ಯಾಕ್‌ಲ್ಯಾವ ಬರ. ");
INSERT INTO gok_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","ತ್ಯವ್ಡಸ್ ನವ್ಹ ತುಜ಼ ಹಾತ್ ತುಲಾ ಪಾಪಾತ್ ಪ್ಯಾಡ್‌ತ್ಯಾತ ತ ತೆ ತುಡುನ್ ಟ್ಯಾಕ್; ");
INSERT INTO gok_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","ದೊನ್ ಹಾತ್ ರಾಹುನ್ ಇಜ಼ತ್ ನಸ್‌ಲ್ಯಾಲ್ಯಾ ಇಸ್ಥು ಜಾ಼ಲ್ಯಾಲ್ಯಾ ನರ್ಕಾತ್ ಪಡಾಚೆ ವಾಟ್ನಿಚ಼ ಹಾತ್ ನಸುನ್ ಸ್ವರ್ಗಾತ್ ಜಾ಼ಯಾಚ಼ ತುಲಾ ಬರ ");
INSERT INTO gok_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","ಆನಿ ತುಜ಼ ಪ್ಯಾ ತುಲಾ ಪಾಪಾತ್ ನೆಥ್ಯಾತ ತ ತೆ ತುಡುನ್ ಟ್ಯಾಕ್; ");
INSERT INTO gok_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","ದೊನ್ ಪ್ಯಾ ರಾಹುನ್ ನರ್ಕಾತ್ ಜಾ಼ಯಾಚೆ ವಾಟ್ನಿಚ಼ ಪ್ಯಾ ನಸುನ್ ಶಾಶ್ವತ್ ಜೀವ್ನಾತ್ ಜಾ಼ಯಾಚ಼ ತುಲಾ ಬರ. ");
INSERT INTO gok_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","ತುಜಾ಼ ಡೊಳಾ ತುಲಾ ಪಾಪಾತ್ ಪ್ಯಾಡ್‍ತ್ಯೊತ ತ್ಯೊ ಕಾಡುನ್ ಟ್ಯಾಕ್; ದೊನ್ ಡೊಳ ರಾಹುನ್ ನರ್ಕಾತ್ ಜಾ಼ಯಾಚೆ ವಾಟ್ನಿಚ಼ ಯಕಾಸ್ ಡೊಳ್ಯಾನಿ ದೇವಾಚಾ ರಾಜಾತ್ ಜಾ಼ಯಾಚ಼ ತುಲಾ ಬರ ");
INSERT INTO gok_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","ನರ್ಕಾತ್ ತ್ಯನಾ ಚಾವತ್ಯಾಲ ಕಿಡ ಮರತ್ನಾಹಿತ, ಇಸ್ಥು ಇಜ಼ತ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","ಪರ್ತೆಕ್‍ ಜ಼ನ ಇಸ್‌ಥ್ಯಾನಿ ಶುದ್ದ್ ವ್ಹತಿಲ ತಸ ಯದ್ನ ಮಿಠಾನಿ ಶುದ್ ವ್ಹತ. ");
INSERT INTO gok_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","ಮಿಟ್ ಚಾ಼ಂಗ್ಲಾ ಜಿನೊಸ್; ಮಿಟಾಲಾ ಚ಼ವ್ ನಾಹಿ ಮಂಜೆ ತ್ಯಲಾ ಆನಿ ಕಶಾನಿ ಚ಼ವ್ ಆನ್ನಾರ್? ತುಮ್ಚೆ ಆತ್ ಮಿಟಾಶಾರ್ಕಿ ಮಾಯಾ ರಾಹುನಿ, ಯಕಾಮಕಾ ಸಂಗ ಸಮಾದಾನಾನಿ ರಾವ್ಹಾ. ");
INSERT INTO gok_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","ತಿಥ್ನಿ ಯೇಸು ಉಠುನ್ ಯುದಾಯ್ ಪ್ರಾಂತ್ಯಾತ್ನಿ ಯೊರ್ದಾನ್ ವ್ಹಾಳಚೆ ಪಲಿಕ್ಲೆ ಸಿಮತ್ನಿ ಆಲಾ. ತಿಥ ಲೊಕ ಪರತ್ ಆನಿ ಹಿಂಡಾ ಹಿಂಡಾನಿ ಜ಼ಮುನ್ ತ್ಯಲಾ ಸುದಿತ್ ಆಲಿತ ತವಾ ತ್ಯೊ ಖಾಯಿಮ್ಚೆಗತ್ ತ್ಯನಾ ಉಪದೆಸ್ ಸಾಂಗಾಯಾ ಲಾಗ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","ತವಾ ಫರಿಸಾಯ್ ಲೊಕ ತ್ಯಚಿ ಪರಿಕ್ಶೆ ಕರಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಯವಜು಼ನ್ ತ್ಯಚಿಪ ಯವುನ್, “ಯಕಾನಿ ಬ್ಯಾಯ್ಕೋ ಸುಡುನ್ ದಿಯಾಚಿ ದರ್ಮ ಕ್ಯಾ” ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","ಯೇಸುನಿ ತ್ಯಲಾ, “ಮೊಶೆಚ಼ ದರ್ಮ ಶಾಸ್ತಾರಾತ್ ತುಮಾನಾ ಕ್ಯಾ ಆಜ್ಞೆ ದಿಲೆ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","“ತೆ, ಶೊಡ್ ಸುಟಿಚ಼ ಪತ್ರ ಲಿವುನ್ ದಿವುನ್ ತಿಲಾ ಸುಡುನ್ ದಿಯಾ ಗಾವ್ಥಿ ಮನ್ಹುನ್ ಮೊಶೆನಿ ಆಜ್ಞೆ ದಿಲೆ” ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","ಫನ್ ಯೇಸುನಿ ತ್ಯನಾ, “ಮೊಶೆನಿ ತುಮ್ಚ ಮೋಚಾ಼ಟ್ಫನ್ ಬಗುನ್ ತುಮಾನಾ ಆಸ್ಲಿ ಆಜ್ಞೆ ಲಿವುನ್ ಥೆವ್ಲೆ. ");
INSERT INTO gok_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","ದೇವಾನಿತರಿ ಸ್ರಶ್ಟಿಚಾ ದಿಸಾದರ್ನ್ಹಿಸ್ ಮಾನ್ಸಾನಾ ಪುರುಶ್ ಆನಿ ಬಾಯಿಲ್ ಮಾನುಸ್ ಕೆಲ್ಯಾತ ");
INSERT INTO gok_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","ಹ್ಯಾ ಕಾರ್ನಾನಿ ಪುರುಶ್ ಆಪ್ಲೆ ಆಯಿಬಾಲಾ ಸುಡುನ್ ಆಪ್ಲೆ ಬ್ಯಾಯ್ಕೊ ಬರ್ಬರ್ ರಾಥೊ ತಿ ದೊಗಬಿ ಯಾಕುಚ಼್ ಧಡ್ ಮನ್ಹುನ್ ಲಿವ್‍ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ಆಸ ಆಸ್ಥಾನಾ ತೀ ಆತಾ ದೊಗ ನವ್ಹತ, ಯಾಕುಸ್ ಧಡ್ ಜಾ಼ಲ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","ಮನ್ಹುನ್ ದೇವಾನಿ ಜೊಡ್‌ಲ್ಯಾಲ ಮಾನ್ಸಾನಿ ಮುಡು ನಾಹಿ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","ಯಕಾ ಗರ‍್ಹಾತ್ ಆಲ ತವಾ ತ್ಯಚಾ ಶಿಶಾಂಚಾನಿ ಹಿ ಗ್ಯೊಶ್ಟ್ ಪರತ್ ಆನಿ ತ್ಯಲಾ ಇಚಾರ್ಲಿ ");
INSERT INTO gok_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","ಯೇಸುನಿ ತ್ಯನಾ “ಆಪ್ಲಿ ಬ್ಯಾಯ್ಕೊ ಸುಡುನ್ ದುಸ್ರಿಲಾ ಲಗಿನ್ ಕರುನ್ ಗೆನಾರಾ ಆಪ್ಲೆ ಬ್ಯಾಯ್ಕೋಲಾ ವೈರಿ ವ್ಹವುನ್ ರಾಂಡ್ ಸಂಗ್ ಕೆಲ್ಯಾ ಸಮಾನ್; ");
INSERT INTO gok_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","ಆಸ್ಹಸ್ ಬ್ಯಾಯ್ಕೋನಿ ಆಪ್‌ಲ್ಯಾ ಘ್ವಾಲಾ ಸುಡುನ್ ದುಸ್‌ರ‍್ಯಾಲಾ ಲಗಿನ್ ಜಾ಼ಲ್ಯಾವ ತಿನಿ ಸುಳಿಫನ್ ಕೆಲ್ಯಾಚೆಗತ್” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","ನಂತರ್ ಥೊಡ್ಯಾಂಚಾನಿ ಆಪ್‌ಲ್ಯಾ ಪೊರಾನಾ ಯೇಸುಪ್ನಿ ಹಾತ್ ಲಾವುನ್ ಗಿಹ್ಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ತ್ಯಚಿಪ ಆಂತಾನಾ ಶಿಶಾಂಚಾನಿ ತ್ಯನಾ ದಪ್‌ಕ್ಯಾವ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","ಖರ ಯೇಸುನಿ ತ್ಯ ಬಗುನ್ ರಾಗ್ ಕರುನ್ ತ್ಯನಾ, “ಪೊರ್‌ಗ್ಯಾನಾ ಮಾಜಿಕ್ಡ ಸೊಡಾ ತ್ಯನಾ ಅಡ್ಯಾವು ನಕೊಸಾ, ಕಾ ಮನ್‌ಲ್ಯಾವ ದೇವಾಚ಼ ರಾಜ ಆಸ್‌ಲ್ಯಾಂಚ಼ಸ್. ");
INSERT INTO gok_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","ಮಿ ತುಮಾನಾ ಖರ ಸಾಂಗ್ತೋ. ಕೊನ್ ದೇವಾಚ಼ ರಾಜ ಪೊರಾಂಚೆ ಬಾವ್‌ನ್ಹಾನಿ ಗಿಹಿತ್ ನಾಹಿ ತ್ಯೊ ತ್ಯಾತ್ ಜಾ಼ಯಿತ್ ನಾಹಿ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","ಮಂಗ್ ಯೇಸುನಿ ಪೊರಾನಾ ಯಾಂಗ್ ಗಾಲ್ಹುನ್ ತ್ಯಂಚಿವ ಹಾತ್ ಥಿವುನ್ ಆಶಿರ್ವಾದ್ ಕೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","ತ್ಯೊ ನಿಗುನ್ ವಾಟನಿ ಜಾ಼ತಾನಾ ಎಕಜು಼ನ್ ಪಳತ್ ತ್ಯಚೆ ಮೊರ‍್ಹ ಯವುನ್ ಆಪ್ಲ ನಡ್ಗ ಟಿಕ್ವುನ್, “ಚಾ಼ಂಗಲ್ಯಾ ಗುರು, ಶಾಶ್ವತ್ ಜೀವ್ ಮಿಳಾಲಾ ಮಿ ಕ್ಯಾ ಕರಾಯಾ ವ್ಹಯಿ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","ತ್ಯಲಾ ಯೇಸುನಿ, “ತು ಮನ್ಹಾ ಚಾ಼ಂಗ್ಲಾ ಮನ್ಹುನ್ ಕಾ ಮನ್ಥೋಸ್? ಕಚಾ಼ಸ್ ಮಾನುಸ್ ಚಾ಼ಂಗ್ಲಾ ನವ್ಹ. ದೇವ್ ತ್ಯವ್ಡಾಸ್ ಚಾ಼ಂಗ್ಲಾ ");
INSERT INTO gok_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","ತುಲಾ ಸರ್ವ್ಯಾ ಕಾಲಾಚಾ಼ ಜೀವ್ ವ್ಹಯಿ ಆಸ್ಲಾತ ತುಲಾ ಠಾವ್ಯಾ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ಹ್ಯಾ ಆಜ್ಞಾ ಪ್ಯಾಳ್: ಖುನ್ ಕರು ನಕೊ, ವ್ಯಬಿಚಾರ್ ಕರುನಕೊ, ಚು಼ರಿ ಕರುನಕೊ, ಇನ್ನಾಕಾರನ್ ಕುನಾವ್ ಚು಼ಕ್ ವಾವುನಕೊ, ಫಸವು ನಕೊ, ಆನಿ ತುಜೆ ಆಯಿಬಾಲಾ ಮರ‍್ಯಾದ್ ದೇ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","ತವಾ ತ್ಯೊ, “ಪ್ರಬು, ಮಿ ನ್ಹಾನ್ ಫನಾಸ್ನಿ ಹ್ಯಾ ಆಜ್ಞಾ ಪಾಳಿತ್ ಆಲ್ಯೊ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","ಯೇಸುನಿ ತ್ಯಾ ಮಾನ್ಸಾಲಾ ಮಾಯೆನಿ ನದಾರ್ಥಿವುನ್ ಬಗುನ್, “ತು ಯಾಕ್ ಕಾಮ್ ಕರಾ ವ್ಹಯಿಸ್. ಜಾ಼ವುನ್, ತುಜ಼ ಹಾ ತ್ಯ ಸಗ್ಳ ಇಕುನ್, ಆಲ್ಯಾಲ ಪೈಸ ಸಗ್ಳ ಗರಿಬಾನಾ ದೆ ಆನಿ ಮಂಗ್ ಮಾಜೆ ಮಾಗ್ನಿ ಯೆ. ತುಲಾ ದೇವ್ಲೋಕಾತ್ ಸಗ್ಳ ದನ್ ದವಲತ್ ಗಾವಲ್. ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","ಯೇಸುಚ ಹೆ ಸಬಾತ್ ಐಕುನ್ ತ್ಯಚ಼ ತ್ವಾಂಡ್ ಬಾವ್ಲ ಆನಿ ಬೆಜಾರ್ ಕರುನ್ ಗೆಲಾ ಕಾ ಮನ್‌ಲ್ಯಾವ ತ್ಯೊ ಖುಬ್ ಸಾವ್ಕೊರ್ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","ಮಂಗ್ ಯೇಸುನಿ ಸರ್ ಬೌಥ ಆಪ್‌ಲ್ಯಾ ಶಿಶಾಂಚಿಕ್ಡ ಬಗುನ್, “ಸಾವ್ಕೊರ್ ದೇವಾಚಾ ರಾಜಾತ್ ಜಾ಼ಯಾಚ ಕ್ಯವ್ಡ ಕಠಿನ್ ಹಾ! ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","ಯೇಸುಚ ಹೆ ಸಬಾತ್ ಐಕುನ್ ಶಿಶಾನಾ ಆಜಾಬ್ ಜಾ಼ಲ. ಫನ್ ಯೇಸು ಆನಿಕ್ ತ್ಯನಾ, “ಮಾಜಾ ಮುಲಾನು, ದೇವಾಚಾ ರಾಜಾತ್ ಜಾ಼ಯಾಚ಼ ಕ್ಯವ್ಡ ಕಠಿನ್ ಹಾ! ");
INSERT INTO gok_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","ಸಾವ್ಕೋರ್ ದೇವಾಚಾ ರಾಜಾತ್ ಜಾ಼ಯಾಚೆ ಬದ್ಲಿಸ್ ಹೂಟ್ ಸುಚಾ ಡೊಳ್ಯಾತ್ನಿ ಫಾಸ್ ವ್ಹವುನ್ ಜಾ಼ಯಾಚ಼ ಸಲ್ಪ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","ಶಿಶಾನಾ ಆಜಾಬ್ ವ್ಹವುನ್, ಯಕಾಮಕಾಲಾ, ತಸಜಾ಼ಲ್ಯಾ ಕೊನ್ ರಕ್ಶನ್ ವ್ಹನಾರ್? ಮನ್ಹುನ್ ಬೋಲತ. ");
INSERT INTO gok_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","ಯೇಸುನಿ ಶಿಶಾಂಚಿಕ್ಡ ಬಗುನ್, “ಹ್ಯ ಮಾನ್ಸಾನಾ ವ್ಹಯಿತ್ ನಾಹಿ, ಫನ್ ದೇವಾಲಾ ನವ್ಹ ದೇವಾಲಾ ಸಗ್ಳ ವ್ಹತ್ತ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","ಪೇತ್ರಾ ಯೇಸುಲಾ “ಆತಾ ಆಮಿ ಸಗ್ಳ ಸುಡುನ್ ದಿವುನ್ ತುಜೆ ಮಾಗ್ನಿ ಆಲ್ಯಾವ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","ತವಾ ಯೇಸು “ಮಿ ತುಮಾನಾ ಖರ ಸಾಂಗ್ತೊ. ಮಾಜೆಸಾಟಿ ಆನಿ ಸುವಾರ್ತೆಸಾಟಿ ಆಪ್ಲ ಘರ್, ಬಾಹು, ಭನ್, ಆಯಿ, ಬಾ, ಪೊರ, ಜ಼ಮಿನ್ ಶೋಡ್‌ಲ್ಯಾಲ್ಯಾ ಪರ್ತೆಕಾಲಾ ");
INSERT INTO gok_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ಹ್ಯಾ ಪ್ರಪಂಚಾ ಮದಿ ತ್ಯನಾ ಕಿತಿತರಿ ಗರ‍್ಹ, ಬಾಹು, ಭನ್ಹಿ, ಆಯಿ, ಪೊರ ಆನಿ ಜಿಮಿನ್ ತರಾಸ್ ಸಾಹಿತ್ ಶಂಬರಾಯವ್ಡಿ ಗಾವ್‌ನ್ಹಾರ್. ಆನಿ ಸ್ವರ್ಗ್ ದುನೆತ್ ತ್ಯಲಾ ಶಾಶ್ವತ್ ಜೀವ್ ಗಾವ್‌ನ್ಹಾರ್. ");
INSERT INTO gok_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","ಫನ್ ಪಯ್ಲ ಖುಬ್ ಜಾ಼ನ್ ಮಾಗ ರಾನ್ಹಾರ್; ಮಾಗ್ಲ ಖುಬ್ ಜಾ಼ನ್ ಪಯ್ಲ ವ್ಹನಾರ್” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","ಯೇಸು ಆನಿ ತ್ಯಚೆ ಸಂಗ ಆಸ್‌ಲ್ಯಾಲಿ ಲೊಕ ಯೆರುಸಲೆಮಿತ್ ವಾಟನಿ ಜಾ಼ತಾನಾ ಯೇಸು ತ್ಯಾ ಸಗ್‌ಳ್ಯಾಂಚೆ ಮೊರ‍್ಹ ಜಾ಼ಯಿತ್ ಹುತ್ತಾ. ತ್ಯ ಬಗುನ್ ಯೇಸುಚ ಶಿಶಾ ಆನಿ ತ್ಯಂಚೆ ಮಾಗ್ನಿ ಯತ್ಯಾಲಿ ಲೊಕ ಬಿಹ್ಯಾಲಿತ. ಆಪ್‍ಲ್ಯಾ ಬಾರಾಜಾ಼ನ್ ಶಿಶಾನಾ ಆಪ್ಲಿಕ್ಡ ಹಾಕ್ಟುನ್, ಯೆರುಸಲೆಮಿತ್ ಆಪ್‌ಲ್ಯಾಲಾ ವ್ಹಯಾಚ಼ ಆಸ್‌ಲ್ಯಾಲ ಸಗ್ಳ ತ್ಯನಾ ಸಾಂಗಿತ್ , ");
INSERT INTO gok_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“ಐಕಾ ಆಮಿ ಯೆರುಸಲೆಮಿತ್ ಜಾ಼ನಾರ್. ಮಾನ್ಸಾಚಾ ಲೇಕಾಲಾ ಮುಖ್ಯ ಯಾಜಕಾಂಚಾ ಆನಿ ಕ್ಯಾಯ್ದದಾರಾಂಚಾ ತಾಬ್ಯಾತ್ ದೆನಾರ್. ತೆ ತ್ಯಲಾ ಮರ್ನಾಚಿ ಶಿಕ್ಷಾ ಥರ್ವುನ್ ಯೆಹುದಿ ನಸ್‌ಲ್ಯಾಲ್ಯಾ ದುಸ್‌ರ‍್ಯಾ ಲೊಕಾಂಚೆ ತಾಬ್ಯಾತ್ ದೆನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ತಿ ಲೊಕ ತ್ಯಲಾ ಬಗುನ್ ತ್ಯಚಿ ಮಸ್ಕರಿ ಕರ್ನಾರ್, ತ್ಯಚಿವ ಥುಕ್ನಾರ್, ಕಾಟ್ಯಾಚಾ ಚಾಬುಕಾನಿ ಮಾರ್ನಾರ್, ಆನಿ ಮಾರುನ್ ಟ್ಯಾಕ್ನಾರ್. ಫನ್ ತ್ಯೊ ತೀನ್ ದಿಸಾ ನಂತರ್ ಆನಿಕ್ ಜಿತ್ತಾ ವ್ಹವುನ್ ಉಠುನ್ ಯನಾರ್” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","ಮಂಗ್ ಜೆಬೆದಾಯಾಚ಼ ಲ್ಯಾಕ್ ಯಾಕೊಬ್ ಆನಿ ಯೊಹಾನ್ ಯೇಸುಪ ಯವುನ್, “ಪ್ರಬು , ಆಮ್‌ಚ಼ ಯಾಕ್ ಮಾಗ್ನ ಹಾ ತ್ಯ ತು ಚಾ಼ಲ್ವುನ್ ದಿಯಾ ವ್ಹಯಿ” ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","ಯೇಸುನಿ, ತುಮ್ಚ಼ ಮಾಗ್ನ ಕ್ಯಾ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","ತ್ಯಂಚಾನಿ, ತು ತುಜಾ ರಾಜಾಮದಿ ಮಹಿಮೆನಿ ಸಿಂಹಾಸನಾವ ಬಸ್ಥಾನಾ ಆಮ್ಚಾತ್‌ಲ್ಯಾ ಯಕಾಲಾ ತುಜೆ ಉಜ್‍ವ್ಯಾಂಗ್ನಿ ಆನಿ ಯಕಾಲಾ ತುಜೆ ಡಾವ್ಯಾಂಗ್ನಿ ಬಸಾಯಾ ದೆ ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","ಯೇಸುನಿ, ತುಮಿ ಕ್ಯಾ ಮಾಗ್‍ತ್ಯಾಸಾ ತ್ಯ ತುಮಾನಾ ಸಮಾಜ್ಲ ನಾಹಿ. ಮಿ ಪಿಯಾಚಾ ಕಸ್ಟಾಚಾ ತಾಂಬ್ಯಾತ್ನಿ ಪಿಯಾಲಾ ವ್ಹಯಿಲ್ ಕ್ಯಾ? ಮಿ ಗಿಹ್ಯಾ ವ್ಹಯಿ ಆಸ್‌ಲ್ಯಾಲಿ ಪವಿತ್ರ ಬಾಪ್ತಿಸ್ಮಾ ತುಮಿ ಗಿಹ್ಯಾ ವ್ಹಯಿಲ್ ಕ್ಯಾ? ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","ತೆ, ವ್ಹಯ್ ಆಮಾನಾ ವ್ಹತ ಮನ್ಲ. ಯೇಸು ತ್ಯನಾ, ಮಿ ಪಿತ್ಯಾಲ್ಯಾ ತಾಂಬ್ಯಾತ್ನಿ ತುಮಿ ಪಿಸಿಲಾ ಮಿ ಗಿಹ್ಯಾಚಿ ಪವಿತ್ರ ಬಾಪ್ತಿಸ್ಮಾ ಗಿಸಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","“ಫನ್ ಮಾಜೆ ಡಾವ್ಯಾಂಗ್ನಿ ನಾಹಿತ ಉಜ್‍ವ್ಯಾಂಗ್ನಿ ಬಸ್ನಾರ‍್ಯಾ ಮಾನ್ಸಾಲಾ ನಿವಡ್‍ತ್ಯಾಲಾ ಮಿ ನವ್ಹ. ತ್ಯೊ ಪರ್ಮೇಶ್ವರ ತ್ಯೊ ಜಾ಼ಗಾ ಕುನಾಲಾ ರಾಖುನ್ ಥೆವ್‌ಲ್ಯಾ ತ್ಯನಾಸ್ ತ್ಯೊ ವ್ಹನಾರ್” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","ರಾಯ್‌ಲ್ಯಾಲ್ಯಾ ಧಾ ಜಾ಼ನ್ ಶಿಶಾಂಚಾನಿ ಹ್ಯ ಐಕುನ್ ತ್ಯಾ ದೊಗಾಂಚಿವ ರಾಗ್ ಕೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","ಯೇಸುನಿ ಸಗ್‌ಳ್ಯಾನಾ ಯಕಿಕ್ಡ ಹಾಕ್ಟುನ್, “ಯೆಹುದಿ ನಸ್‌ಲ್ಯಾಲ್ಯಾ ಲೊಕಾಂಚ಼ ಅಧಿಪತಿ ಹಾತ ತೆ ಲೋಕಾಂಚಿವರ್ ಅಧಿಕಾರ್ ಚಾ಼ಲಿವತ್ಯಾತ, ತ್ಯೊ ಹುಕುಮ್ ತ್ಯನಾ ದಿಲ್ಯಾಲಾ ಹಾ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","ಹೆ ತರನಿ ತುಮ್ಚಾತ್ ರಾಹು ನಾಹಿ, ಥೊರ್ ವ್ಹಯಾ ವ್ಹಯಿ ಮಂಥ್ಯಾಲಾ ಸಗ್‌ಳ್ಯಾಂಚಿವ್ನಿ ನ್ಹಾನ್ ವ್ಹವುನ್ ತ್ಯಂಚಿ ಸೇವಾ ಕರಾ ವ್ಹಯಿ. ");
INSERT INTO gok_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ಆನಿ ಮೊಟಾ ವ್ಹಯಾ ವ್ಹಯಿ ಮಂಥ್ಯಾಲಾ ಆಳಾಚೆಗತ್ ತುಮ್ಚಿ ಸಗ್‌ಳ್ಯಾಂಚಿ ಚಾ಼ಕ್ರಿ ಕರಾ ಪಾಯ್ಜೆ. ");
INSERT INTO gok_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","ತಸಸ್ ಮಾನ್ಸಾಚಾ಼ ಲ್ಯೊಕ್ ಲೊಕಾಂಚಿಪ್ನಿ ಸೇವಾ ಕರುನ್ ಗಿಹ್ಯಾ ಆಲಾನಾಹಿ, ಲೊಕಾಂಚಿ ಸೇವಾ ಕರಾಯಾ ಆಲ್ಯಾ. ಮಾನ್ಸಾಚಾ಼ ಲ್ಯೊಕ್ ಖುಬ್ ಲೊಕಾನಾ ಸುಟ್ಕ ಕರಾಯಾಸಾಟಿ ಆಪ್ಲಾ ಜೀವ್ ದಿಯಾ ಆಲ್ಯಾ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","ಮಂಗ್ ತೆ ಯೆರಿಕೊ ಗಾವಾತ್ ಆಲ. ಯೇಸು ಆಪ್‌ಲ್ಯಾ ಶಿಶಾಂಚಿ ಸಂಗ ಆನಿ ಖುಬ್ ಲೊಕಾಂಚಿ ಸಂಗ ತ್ಯ ಗಾವ್ ಸುಡುನ್ ನಿಗಾಲಾ. ತಿಮಾಯಾಚಾ಼ ಲ್ಯೊಕ್ ಬಾರ್ತಿಲೊಮಾಯ್ ಮಂಥ್ಯಾಲಾ ಆಂದ್ಳಾ ವಾಟಚೆ ಕಡಸ್ ಬಸುನ್ ಭಿಕ್ ಮಾಗಿತಾ. ");
INSERT INTO gok_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","ನಜ಼ರೆತಿಚಾ಼ ಯೇಸು ತೆ ವಾಟನಿ ಜಾ಼ತ್ಯೋ ಮನ್ಹುನ್ ಐಕುನ್, ಯೇಸುಗಾ! ದಾವಿದಾಚಾ ಲೇಕಾ! ಮಾಜಿವ ಕರ್ನೆದ್ಯಾವ್! ಮನ್ಹುನ್ ಜೊ಼ರಾನಿ ವರಾಡ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","ಥೊಡ ಜಾ಼ನ್ ತ್ಯಾ ಆಂದ್‍ಳ್ಯಾಲಾ ದಪ್‌ಕಾವುನ್ ಗಪ್ ರ‍್ಹಾ ಮನ್ಲ. ಫನ್ ತ್ಯೊ ದಾವಿದಾಚಾ ಲೇಕಾ ಮಾಜಿವ ಕರ್ನಾ ದ್ಯಾವ!” ಮನ್ಹುನ್ ಆನಿ ಜೊ಼ರಾನಿ ವರಾಡ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","ಯೇಸು ಉಬಾರಾಹುನ್, “ತ್ಯಲಾ ಹಾಕ್ಟಾ” ಮನ್ಲಾ. ತವಾ ತ್ಯಂಚಾನಿ ತ್ಯಾ ಆಂದ್‌ಳ್ಯಾಲಾ ಹಾಕ್ಟುನ್, ದಿರ‍್ಹಾನಿ ರ‍್ಹಾ, ಉಟ್ ಯೇಸು ತುಲಾ ಹಾಕಟ್ಯೋ ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","ತ್ಯೊ ಆಂದ್ಳಾ ತವಾಸ್ ಉಬಾರಾಹುನ್ ಆಪ್ಲ ಕಾಂಬ್ರುನ್ ತಿಥಸ್ ಟಾಕುನ್ ಯೇಸುಪ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","ಯೇಸುನಿ, “ಮಾಜಿಪ್ನಿ ತುಲಾ ಕ್ಯಾ ವ್ಹಯಾ ವ್ಹಯಿ” ಮನ್ಹುನ್ ತ್ಯಲಾ ಇಚಾರ್ಲ. ತ್ಯನಿ, “ಪ್ರಬು, ಮನಾ ಡೊಳ್ಯಾನಿ ದಿಸ ಶಾರ್ಕ ಕರ್” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","ಯೇಸು, “ಜಾ಼, ತುಜಾ ಇಸ್ವಾಸಾನಿ ತುಲಾ ಬರ ಜಾ಼ಲ್ಯಾ” ಮನ್ಲಾ. ತವಾಸ್ ತ್ಯಲಾ ದೀಸಾಯಾ ಲಾಗ್ಲ. ತ್ಯೊ ಯೇಸುಚೆ ಮಾಗ್ನಿ ತೆ ವಾಟನಿ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","ಯೇಸು ಆನಿ ತ್ಯಚ಼ ಶಿಶಾ ಯೆರುಸಲೆಮಿಚೆ ಜ಼ವಳ್ ಆಸ್‌ಲ್ಯಾಲೆ ಬೆತ್ಪೆ ಆನಿ ಬೆತಾನಿಚೆ ಕಡಸ್ ಆಲ ತವಾ. ತೇ ಆಲಿವ್ ಜಾ಼ಢಾಚಾ ಗುಢ್ಯಾವ ಪೋಚ಼್ಲ ತಿಥ ಯೇಸುನಿ ಆಪ್‌ಲ್ಯಾದೊಗಾ ಶಿಶಾನಾ ಹಾಕ್ಟುನ್ ");
INSERT INTO gok_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“ತಿಥ ದಿಸಥ್ಯಾಲ್ಯಾ ಗಾವಾತ್ ಜಾ಼ವಾ. ತುಮಿ ತಿಥ ಗೆಲಾಸಾಕಿ ಕಂದಿಸ್ ಕೊನ್ ತ್ಯಚಿವ ಬಸ್‌ಲ್ಯಾನಸ್‌ಲ್ಯಾಲ ಯೊಕ್ ಗಾಡ್ವಾಚಾ಼ ಪೆಟಾ ಬ್ಯಾಂದ್‌ಲ್ಯಾಲಾ ದಿಸಲ್. ತ್ಯಲಾ ಗಿಹುನ್ ಮಾಜಿಪ ಯವಾ. ");
INSERT INTO gok_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","ಕುನಿತರಿ ತ್ಯಲಾ ಕಾ ಗಿಹುನ್ ಜಾ಼ತಾಸಾ ಮನ್ಹುನ್ ತುಮಾನಾ ಇಚಾರ್ಲತ, ದನ್‌ಹ್ಯಾಲಾ, ವ್ಹಯಿಜಾ಼ಲ್ಯಾ. ತ್ಯೊ ಹ್ಯಲಾ ಬಿಗಿನಿ ಮಾಗಾರಾ ಲಾವುನ್ ದೆನಾರ್ ಮನ್ಹುನ್ ತ್ಯಲಾ ಸಾಂಗಾ” ಮನ್ಹುನ್ ಸಾಂಗುನ್ ತ್ಯನಾ ಲಾವುನ್ ದಿಲ. ");
INSERT INTO gok_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","ಶಿಶಾ ಗಾವಾತ್ ಗೆಲ ತವಾ ವಾಟಚೆ ಕಡಸಲ್ಯಾ ಯಕಾ ಗರ‍್ಹಾಚಾ ದಾರಾಚೆ ಕಡಸ್ ಬ್ಯಾಂದ್‌ಲ್ಯಾಲ ಗಾಡಾವ್ ದಿಸ್ಲ. ಶಿಶಾಂಚಾನಿ ತ್ಯ ಗಾಡಾವ್ ಶೊಡ್ಲ ತವಾ, ");
INSERT INTO gok_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ತಿಥ ಉಬಿ ರಾಯ್‌ಲ್ಯಾಲ್ಯಾ ಲೊಕಾಂಚಾನಿ “ತುಮಿ ಕ್ಯಾ ಕರ್ತಾಸಾ? ತ್ಯಲಾ ಕಾ ಶೊಡ್ತಾಸಾ? ಮನ್ಹುನ್” ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","ಯೇಸುನಿ ಆಪ್‌ಲ್ಯಾಲಾ ಸಾಂಗ್‌ಲ್ಯಾ ಶಾರ್ಕ ಶಿಶಾಂಚಾನಿ ಸಾಂಗ್ಲ. ತವಾ ಲೊಕಾಂಚಾನಿ ಗಾಡಾವ್ ತ್ಯನಾ ಸುಡುನ್ ದಿಲ. ");
INSERT INTO gok_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","ಶಿಶಾಂಚಾನಿ ಗಾಡಾವ್ ಯೇಸುಪ ಆನುನ್ ಆಪ್ಲ ಶಾಲು ಗಾಡ್ವಾವರ್ ಹಾತರ್ಲ. ತವಾ ಯೇಸು ತ್ಯಾವರ್ ಬಸ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","ಖುಬ್ ಲೊಕಾಂಚಾನಿ ತ್ಯಚಿ ಸಾಟಿ ವಾಟವ ಆಪ್ಲ ಕಪ್ಡ ಹಾತರ್ಲ. ದುಸ್‌ರ‍್ಯಾ ಥೊಡ್ಯಾಂಚಾನಿ ಬಾಗತ್ನಿ ಪಾನ ಕಾಪುನ್ ಆನುನ್ ವಾಟವ ಪಗಳ್ಳಿತ. ");
INSERT INTO gok_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","ಥುಡಿ ಲೊಕ ಯೇಸುಚೆ ಮೊರ‍್ಹ ಆನಿ ಮಾಗ್ಹ ಜಾ಼ತ್ಯಾಲಿ “ತ್ಯಲಾ ಸ್ತುತಿ ಕರಾ! ಪ್ರಬುಚಾ ನಾವಾನಿ ಯತ್ಯೊ ತ್ಯಲಾ ದೇವ್ ಆಶಿರ್ವಾದ್ ಕರುನಿ! ");
INSERT INTO gok_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","ಆಮ್‌ಚಾ಼ ವಡಿಲ್ ದಾವಿದಾಚ಼ ಯನಾರ್ ತ್ಯಲಾ ದೇವ್ ಆಶಿರ್ವಾದ್ ಕರುನಿ! ದೇವಾಲಾ ಸ್ತುತಿ ವ್ಹವುನಿ ಆಸಿ ಜೊ಼ರಾನಿ ಮನ್ಹಿತಿತ. ");
INSERT INTO gok_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","ಯೇಸುನಿ ಯೆರುಸಲೆಮಿತ್ ಪ್ರವೆಸ್ ಕರುನ್, ದೇವ್ಳಾತ್ ಜಾ಼ವುನ್ ತಿತ್ಲ ಸರ್ಬೌಥ ಸಗ್ಳ ಬಗ್ಲ. ಫನ್ ತವಾ ಯೊಳ್ ಜಾ಼ಲ್ಥಾ. ಮನ್ಹುನ್ ಯೇಸು ಬಾರಾ ಜಾ಼ನ್ ಶಿಶಾಂಚಿ ಸಂಗ ಬೆತಾನಿತ್ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","ದಿಸ್ರೆ ದಿಸಿ ತೇ ಬೆತಾನಿತ್ನಿ ಯಯಿತ್ ಆಸ್ಥಾನಾ ಯೇಸುಲಾ ಭುಕ್ ಲಾಗ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","ತ್ಯನಿ ಪಾನಾನಿ ಬರ್‌ಲ್ಯಾಲ ಯಾಕ್ ಅಂಜು಼ರಾಚ಼ ಜಾ಼ಡ್ ಬಗ್ಲ. ಆನಿ ತ್ಯಲಾ ಫಳ ಲಾಗ್‌ಲ್ಯಾತ ಕ್ಯಾ ಬಗಾಯಾ ತಿಥ ಗೆಲಾ. ಖರ ತ್ಯಲಾ ತಿಥ ಯಾಕ್ಬಿ ಫಳ್ ದಿಸ್ಲ ನಾಹಿ. ನಿಸ್ಥಿ ಪಾನ ತ್ಯವ್ಡಿಸ್ ಹುತ್ತಿತ ಕಾ ಮನ್‌ಲ್ಯಾವ ತ್ಯ ಪಿಕಾಚ ಸಿಜ಼ನ್ ನವ್ಥ. ");
INSERT INTO gok_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","ಮನ್ಹುನ್ ಯೇಸುನಿ ತ್ಯಾ ಜಾ಼ಢಾಲಾ, ಹಿತ್ನಿ ಮೊರ‍್ಹ ತುಜ಼ ಫಳ್ ಕುನಿ ಖಾವು ನಾಹಿ ಆಸ ವ್ಹವುನಿ ಮನ್ಲಾ. ಯೇಸುಚಾ ಶಿಶಾಂಚಾನಿಬಿ ಹ್ಯೊ ಸಬೊತ್ ಐಕ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","ತೇ ಯೆರುಸಲೆಮಿತ್ ಆಲ. ತವಾ ಯೇಸು ದೇವ್ಳಾತ್ ಗೆಲಾ ತಿಥ ಸಾಮಾನ್ ಇಕ್‌ತ್ಯಾಲ್ಯಾನಾ ಗೆಥ್ಯಾಲ್ಯಾನಾ ತ್ಯನಿ ತಿಥ್ನಿ ಬಾಹಿರ್ ಪಳಿವ್ಲಿತ; ಪೈಶಾಚಾ಼ ಯವಾರ್ ಕರ್ತ್ಯಾಲ್ಯಾಂಚಿ ಬೆಂಚ ಕವ್ಡ ಇಕ್‌ತ್ಯಾಲ್ಯಾಂಚಿ ಬಿಸ್ನಿ ತ್ಯನಿ ಪಾಡುನ್ ಗ್ಯಾತ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","ವಜ್ಜಿ ಗಿಹುನ್ ಯಹುದಿಂಚಾ ಮೊಟ್ಯಾ ದೇವ್ಳಾಚಾ ಆಂಗ್ನಾತ್ನಿ ಜಾ಼ತ್ಯಾಲ್ಯಾನಾ ತ್ಯನಿ ಥಾಂಬಿವ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","ಮಂಗ್ ಯೇಸುನಿ ತ್ಯಾ ಲೊಕಾನಾ “ಮಾಜ಼ ದಿವುಳ್ ಸಗ್‌ಳ್ಯಾ ದೇಸೆತ್‌ಲ್ಯಾ ಲೊಕಾಂಚ಼ ಮಾಗ್‍ನ್ಯಾಚ ದಿವುಳ್ ವ್ಹಯಾಚ಼, ಮನ್ಹುನ್ ಪವಿತ್ರ ಶಾಸ್ತಾರಾತ್ ಪರ್ಮೇಶ್ವರಾನಿ ಸಾಂಗ್‌ಲ್ಯಾ. ಫನ್ ತುಮಿ ದಿವುಳ್ ಚೊ಼ರಾಚಿ ಘಬ್ ಕಿಲಿಸಾ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","ಲೊಕ ಸಗ್ಳಿ ಯೇಸುಚಿ ಗ್ಯೋಸ್ಟ್ ಐಕುನ್ ಖುಬ್ ಗಾಭಾರ್ಲ್ಯಾಲಿ ಹುತ್ತಿತ ಮನ್ಹುನ್ ಮುಖ್ಯ ಯಾಜಕ ಆನಿ ದರ್ಮಶಾಸ್ತಾರ್ ಸಿಕಿವ್‌ತ್ಯಾಲ ಯೇಸುಲಾ ಬಿಹ್ಯಾಲ ಆನಿ ಯೇಸುಚ಼ ಹೆ ಸಬ್ಧ ಐಕುನ್ ತ್ಯಲಾ ಠಾರ್ ಮಾರಾಯಾ ಪಾರಕ್ ಯವಜಾ಼ಯಾ ಲಾಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","ತಿಸಿ ಶಾಂಜ಼್ ಜಾ಼ಲಿ ತವಾ ಯೇಸು ಆನಿ ತ್ಯಚ಼ ಶಿಶಾ ಶಾರ್ ಸುಡುನ್ ಬಾಹಿರ್ ಗೆಲ. ");
INSERT INTO gok_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","ದಿಸ್ರೆ ದಿಸಿ ಸಕಾಳಚ಼, ವಾಟನಿ ಜಾ಼ತಾನಾ. ಮಾಗ್‍ಲ್ಯಾ ದಿಸಾ ದಿಸಿ ಯೇಸುನಿ ಸರಾಪ್‌ಲ್ಯಾಲ ಅಂಜು಼ರಾಚ಼ ಝಾ಼ಡ್ ತ್ಯಂಚಾನಿ ಬಗ್ಲ ತ್ಯ ಝಾ಼ಡ್ ಮುಳಾ ಸಾಹಿತ್ ವಾಳುನ್ ಗೆಲ್ತ. ");
INSERT INTO gok_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","ಪೇತ್ರಾನಿ ಜಾ಼ಲಹ್ಯಾಲ ಯವಜು಼ನ್, ಯೇಸುಲಾ, “ಪ್ರಬು, ಬಗ್! ಕ್ಯಾಲ್ ತು ಸರಾಪ್‌ಲ್ಯಾಲ ಅಂಜು಼ರಾಚ಼ ಝಾ಼ಡ್ ವಾಳುನ್ಗೆಲ್ಯಾ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","ಯೇಸು, “ದೇವಾವ ಇಸ್ವಾಸ್ ಥೆವಾ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","“ಮಿ ತುಮಾನಾ ಖರ ಸಾಂಗ್ತೊ. ಕೊನ್ತರಿ ಹ್ಯಾ ಗುಢ್ಯಾಲಾ, ತು ಉಪ್ಟುನ್ ಜಾ಼ವುನ್ ಸಮಿಂದೊರಾತ್ ಪಡ್, ಮನ್ಹುನ್ ಸಾಂಗುನ್, ಆನ್ಮಾನ್ ನಸ್ಥಾನಾ, ತ್ಯನಿ ಸಾಂಗ್‌ಲ್ಯಾಲ ವ್ಹನಾರ್ ಮನ್ಹುನ್ ಇಸ್ವಾಸ್ ಥೆವ್‌ಲ್ಯಾವ, ಪರ್ಮೇಶ್ವರ್ ತ್ಯ ತ್ಯಚಿಸಾಟಿ ಕರ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","ಮನ್ಹುನ್ ತುಮಿ ಮಾಗ್ನ ಕರ್ತಾನಾ ಕಾಯ್ತರಿ ಮಾಗ್‍ಲ್ಯಾವ ತ್ಯ ಗಾವ್ಲ ಮನ್ಹುನ್ ಇಸ್ವಾಸ್ ಥೆವ್ಲಾತ ತವಾಸ್ ತುಮಿ ಮಾಗ್‍ಲ್ಯಾಲ ತುಮಾನಾ ಗಾವ್ಲ ");
INSERT INTO gok_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","ತುಮಿ ಮಾಗ್ನ ಕರ್ತಾನಾ ತುಮಾನಾ ಕುನಾವತರಿ ಕಸ್ಲಾತರಿ ರಾಗ್ ಆಸ್‌ಲ್ಯಾಲಾ ಯದತ್ ಆಲ್ಯಾವ ತ್ಯಲಾ ಮಾಪ್ ಕರಾ. ");
INSERT INTO gok_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","ತವಾ ಪರಲೊಕಾತ್ಲಾ ದೆವ್ ತುಮ್ಚಿ ಚು಼ಕ್ ಮಾಪ್ ಕರಿಲ್” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","ಯೇಸು ಆನಿ ತ್ಯಚ಼ ಶಿಶಾ ಆನಿಕ್ ಯಂಗ್ದಾ ಯೆರುಸಲೆಮಿತ್ ಆಲ. ಯೇಸು ದೆವ್ಳಾತ್ ಫಿರತ್ ಆಸ್ಥಾನಾ ಮುಖ್ಯ ಯಾಜಕ್ ದರ್ಮ ಉಪದೆಸ್ ಕರ್ತ್ಯಾಲ ಆನಿ ಯೆಹುದಿ ಜಾಂತ ತ್ಯಚಿಪ ಯವುನ್. ");
INSERT INTO gok_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","“ಹ್ಯ ಸಗ್ಳ ಕರಾಯಾ ತುಲಾ ಕ್ಯಾ ಹಾಕ್ ಹಾ? ಕುನಿ ಹ್ಯೊ ಹುಕುಮ್ ದಿಲಾ? ಆಮಾನಾ ಸಾಂಗ್!” ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","ಯೇಸು ತ್ಯನಾ “ಮಿ ತುಮಾನಾ ಯೊಕ್ ಸಬ್ಧ ಇಚಾರ್ತೊ. ತುಮಿ ಮಾಜಾ ಸಬ್ಧಾಲಾ ಉತ್ತರ್ ದಿಲ್ಯಾವ ಮಿ ಕಚಾ ಹುಕ್ಮಾನಿ ಹ್ಯ ಕರ್ತೊ ಮನ್ಹುನ್ ತುಮಾನಾ ಸಾಂಗ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","ಯೊಹಾನಾನಿ ಲೊಕಾನಾ ಪವಿತ್ರ ಬಾಪ್ತಿಸ್ಮಾ ದಿಲ್ಯಾಲ ದೇವಾನಿ ದಿಲ್ಯಾಲ್ಯಾ ಹುಕ್ಮಾನಿ ಕ್ಯಾ ಮಾನ್ಸಾನಿ ದಿಲ್ಯಾಲ್ಯಾ ಹುಕ್ಮಾನಿ? ಮನಾ ಸಾಂಗಾ!” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","ತವಾ ತ್ಯಂಚಾನಿ, “ಆಮಿ ಕ್ಯಾ ಸಾಂಗುಯಾ ದೇವಾಪ್ನಿ ಆಲ್ಯಾಲಾ ಹಾಕ್ ಮನ್‌ಲ್ಯಾವ ತುಮಿ ಕಾ ತ್ಯಚಿವ ಇಸ್ವಾಸ್ ಥೆವ್ಲಾ ನಾಹಿಸಾ ಮನ್ಹುನ್ ಇಚಾರ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","ಯೆಕ್ ವೆಳಿ ಮಾನ್ಸಾಪ್ನಿ ಆಲ್ಯಾಲ್ಯಾ ಹುಕ್ಮಾನಿ ಮನ್‌ಲ್ಯಾವ ಲೊಕ ಆಮ್ಚಿವ ರಾಗ್ ಕರ್ನಾರ್” ಮನ್ಹುನ್ ಆಪ್‍ಲ್ಯಾ ಆಪ್‌ಲ್ಯಾತ್ ಬೋಲ. (ಸಗ್‌ಳ್ಯಾಲೋಕಾಂಚಾನಿ ಯೊಹಾನ್ ಪ್ರವಾದಿ ಮನ್ಹುನ್ ಇಸ್ವಾಸ್ ಥೇವ್ಲಾ ಹುತ್ತಾ) ಮನ್ಹುನ್ ಲೊಕಾನಾ ಬಿಹ್ಯಾಲ. ");
INSERT INTO gok_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","ಹ್ಯಚೆ ಸಾಟಿ ತೆ ಯೇಸುಲಾ, “ತ್ಯ ಆಮಾನಾ ಠ್ಹಾವ ನಾಹಿ” ಮನ್ಲ. ಯೇಸುನಿ ತ್ಯನಾ, “ತಸ ಜಾ಼ಲ್ಯಾ ಮಿ ಸಾಹಿತ್ ಕಚಾ ಹಕ್ಕಾನಿ ಹ್ಯ ಸಗ್ಳ ಕರ್ತೊ ತುಮಾನಾ ಸಾಂಗಿತ್ ನಾಹಿ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","ಮಂಗ್ ಯೇಸು ಲೊಕಾನಾ ಸಾಮ್ಯಾನಿ ಸಾಂಗಾಯಾ ಲಾಗ್ಲಾ: “ಯಕಾನಿ ದರಾಕ್ಶಿಚಾ಼ ಮಳಾ ಗಾಲ್ಹುನ್, ತ್ಯಲಾ ಸರ್ಬೌತಾ ಕುಪ್ ಗಾಲ್ಹುನ್, ದರಾಕ್ಶಿಚಾ಼ ರಸ್ ಕಾಡಾಯಾ ಖಡ್ಡಾ ಕಾಡುನ್ ರಾಖಾಯಾ ಮಾಳಾ ಗಾಲ್ಹುನ್ ದರಾಕ್ಶಿಚಾ಼ ಮಳಾ ರೈತಾನಾ ಖಂಡಾನಿ ದಿವುನ್ ತ್ಯೊ ಬಾಹಿರ್ಲೆ ದೇಶೆತ್ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","“ಮೊರ‍್ಹ ಲ್ಯಾನ್ ಆಲಿ ತವಾ ಆಪ್ಲೆ ವಾಟ್ನಿಚಿ ದರಾಕ್ಷಿ ಆನಾಯಾ ಆಪ್‌ಲ್ಯಾ ಯಕಾ ಆಳಾಲಾ ತ್ಯಂಚಿಪ ಲಾವುನ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","ತ್ಯಂಚಾನಿ ತ್ಯಲಾ ದರ‍್ಹುನ್ ಮಾರುನ್ ಮೊಕ್‌ಳ್ಯಾ ಹಾತಾನಿ ಲಾವುನ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","ತವಾ ದನ್‌ಹ್ಯಾನಿ ಪರತ್ ಆನಿ ಯಕಾ ಆಳಾಲಾ ತ್ಯಂಚಿಪ ಲಾವುನ್ ದಿಲಾ, ತ್ಯಂಚಾನಿ ತ್ಯಚಿ ಡುಯಿ ಫುಡುನ್ ಅವ್ಮಾನ್ ಕರುನ್ ಲಾವುನ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","ಮನ್ಹುನ್ ದನ್‌ಹ್ಯಾನಿ ಆನಿ ಯಕಾ ಆಳಾಲಾ ಲಾವುನ್ ದಿಲಾ, ತ್ಯಂಚಾನಿ ತ್ಯಾ ಆಳಾಲಾ ಮಾರುನುಸ್ ಟ್ಯಾಕ್ಲಾ. ತ್ಯಾ ದನ್‌ಹ್ಯಾನಿ ಆಸ ಖುಬ್ ಆಳಾನಾ ತ್ಯಂಚಿಪ ಲಾವುನ್ ದಿಲ, ತ್ಯಂಚಾನಿ ಕಾಯ್ ಥೊಡ್ಯಾನಾ ಬಡಿವ್ಲ ಆನಿ ಕಾಯ್ ಥೊಡ್ಯಾನಾ ಮಾರುನ್ ಟ್ಯಾಕ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“ತ್ಯಾ ದನ್‌ಹ್ಯಾಲಾ ಆತಾ ತ್ಯಂಚಿಪ ಲಾವುನ್ ದಿಯಾ ತ್ಯಚಾ಼ ಯಕಚಾ಼ ಯೊಕ್ ಲ್ಯಾಡ್ಕಾ ಲ್ಯೊಕ್ ತ್ಯವ್ಡಾಸ್ ರಾಲ್ಥಾ ತೆ ಮಾಜಾ ಲೇಕಾಲಾ ತರಿ ಮರ‍್ಯಾದ್ ದಿತಿಲ ಮನ್ಹುನ್ ಸಮಜು಼ನ್ ಲಾಸ್ಟಾಸ್ ದನ್ಯಾನಿ ತ್ಯಲಾಸ್ ಲಾವುನ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","ಫನ್ ತ್ಯಂಚಾನಿ “ಹ್ಯೋಚ಼್ ಹೆ ಆಸ್ಥಿಚಾ಼ ವಾರ್ಸಿ, ಯವಾ ಹ್ಯಲಾ ಮಾರುನ್ ಟಾಕುಯಾ; ತವಾ ಆಸ್ಥಿ ಆಮ್ಚಿ ವ್ಹಯಿಲ್” ಮನ್ಹುನ್ ಯಕಾಮಕಾ ಬರ್ಬರ್ ಬುಲುನ್ ಗಿಹುನ್ ");
INSERT INTO gok_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","ತ್ಯಲಾ ದರ‍್ಹುನ್ ಜೀವ್ ಕಾಡುನ್ ದರಾಕ್ಶಿಚಾ ಮಳ್ಯಾತ್ನಿ ಬಾಹಿರ್ ಟ್ಯಾಕ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“ಆಸ ಆಸ್ಥಾನಾ ತ್ಯೊ ದನ್ಹಿ ಕ್ಯಾ ಕರ್ತೊ? ತ್ಯೊ ದರಾಕ್ಶಿಚಾ ಮಳ್ಯಾತ್ ಜಾ಼ವುನ್ ತ್ಯನಾ ಮಾರುನ್ ದುಸ್‌ರ‍್ಯಾ ಲೊಕಾನಾ ಖಂಡಾನಿ ದೆತೊ. ");
INSERT INTO gok_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","ಪವಿತ್ರ ಶಾಸ್ತಾರಾತ್ ಲಿವ್‌ಲ್ಯಾಶಾರ್ಕ , “ಘರ್ ಬ್ಯಾಂತ್ಯಾಲ್ಯಾನಿ ನಕೊ ಮನ್ಹುನ್ ನಕ್ವಾಟ್ ಕೆಲ್ಯಾಲಾ ದೊಂಢಾ ಮುದ್ದಮ್ ಕೊನ್ಯಾಲಾಸ್ ವ್ಹಯಿ ಜಾ಼ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","ಹ್ಯ ಪರ್ಮೇಶ್ವರಾಪ್ನಿ ಜಾ಼ಲ. ಹ್ಯ ಆಮ್ಚೆ ನದ್ರಲಾ ಆಜಾಬ್ ದಿಸ್ಲ. ” ");
INSERT INTO gok_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","ಯೇಸುನಿ ಸಾಂಗ್‌ಲ್ಯಾಲ ಹ್ಯ ಸಾಮ್ಯಾ ತಿತಲ್ಯಾ ಯೆಹುದಿ ಜಾಂತ್ಯಾಂಚಾನಿ ಐಕುನ್ ಆಮಾನಾ ದರ‍್ಹುನ್ ಹ್ಯ ಸಾಂಗ್ಲ ಮನ್ಹುನ್ ಸಮಜು಼ನ್ ಯೇಸುಲಾ ದರ‍್ಹಾಯಾ ಖಟ್ಪಟ್ಲ ಫನ್ ಲೊಕಾನಾ ಬಿಹುನ್ ತ್ಯಲಾ ಸುಡುನ್ ಗೆಲ. ");
INSERT INTO gok_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","ಮಂಗ್ ಹೆರೊದಾಚಾ ತಂಡ್ಯಾತ್‌ಲ್ಯಾನಾ ಪರಿಸಾಯಾತ್‌ಲ್ಯಾ ಥೊಡ್ಯಾನಾ ಯೇಸುಚಾ ಸಬ್ದಾತ್ನಿ ಚು಼ಕ್ ದರ‍್ಹಾಯಾ ಲಾವುನ್ ದಿಲ. ");
INSERT INTO gok_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","ತೆ ಯೇಸುಪ ಯವುನ್ ತ್ಯಲಾ, “ಪ್ರಬು, ತು ಖರಾ ಮನ್ಹುನ್ ಆಮಾನಾ ಸಮಾಜ಼ಲ್ಯಾ, ತುಜೆಯಸಿ ಲೊಕ ಕ್ಯಾ ಯವಸ್‌ತ್ಯಾತ ತ್ಯಚ಼ ತುಲಾ ಭೆ ನಾಹಿ. ಸಗ್ಳಿ ಲೊಕ ತುಲಾ ಯೆಕುಸ್ ಆನಿ ತು ದೇವಾಚೆ ಗುಶ್ಟಿತ್ ಖರ ಸಾಂಗ್‌ತ್ಯಾಲಾ ಮನ್ಹುನ್ ಆಮಾನಾ ಠಾವ ಹಾ. ಹ್ಯಚೆಸಾಟಿ ಆಮಿ ರೊಮ್ ದೇಶೆಚಾ಼ ಚಕ್ರವರ್ತಿ ಕೈಸರಲಾ ಜ಼ಖತ್ ದಿಯಾಚಿ ಪದ್ದತ್ ಖರಿ? ಕ್ಯಾ ಖುಟಿ? ಆಮಿ ಜ಼ಖತ್ ದಿಯಾ ವ್ಹಯಿ ಕ್ಯಾ ನಕೊ? ಆತಾ ಆಮಾನಾ ಸಾಂಗ್” ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","ತ್ಯನಿ ತ್ಯಂಚಿ ಯವಜ್ನಾ಼ ವಳ್ಖುನ್, ತ್ಯೊ ತ್ಯನಾ “ಮಾಜಿ ಪಾರಕ್ ಆಸಿ ಕಾ ಕರ್ತಾಸಾ? ಮನಾ ಯೆಕ್ ಪಾವ್ಲಿ ದಾವಾ ಮಿ ತಿ ಬಕ್ತೋ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","ತ್ಯಂಚಾನಿ ತ್ಯಲಾ ಯೆಕ್ ಪಾವ್ಲಿ ದಿಲಿ. ಯೇಸುನಿ ತ್ಯನಾ “ಪಾವ್ಲಿವ ಕುನಾಚಾ಼ ಸಿಕ್ಕಾ ಹಾ? ಆನಿ ತ್ಯಚಿವ ಕುನಾಚ಼ ನಾವ್‍ ಹಾ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ ತೆ “ಹ್ಯ ಕೈಸರಾಚ಼” ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","ತವಾ ಯೇಸು ತ್ಯನಾ “ಕೈಸರಾಚ಼ ಕೈಸರಾಲಾ ದೆವಾ, ದೇವಾಚ಼ ದೇವಾಲಾ ದೆವಾ” ಮನ್ಲಾ. ಯೇಸುನಿ ಸಾಂಗ್‌ಲ್ಯಾಲ ಹ್ಯ ಐಕುನ್ ತ್ಯನಾ ಆಜಾಬ್ ವಾಟ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","ಮಂಗ್ ಮರ್ನಾತ್ನಿ ಉಠುನ್ ಆಲ್ಯಾ ಮಂಥ್ಯಾಲ ಸದ್ದುಕಾಯ್ ಯೇಸುಪ ಯವುನ್. ");
INSERT INTO gok_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“ಪ್ರಬು, ಯಕ್ಲಾ ಲಗಿನ್ ವ್ಹವುನ್ ಪೊರ ನಸ್ತಾನಾ ಮೆಲಾಕಿ, ತ್ಯಚಾ ಬಾಹ್ವಾನಿ ತ್ಯಚೆ ಬ್ಯಾಯ್ಕೊಲಾ ಲಗಿನ್ ವ್ಹವುನ್ ಮೆಲ್ಯಾಲ್ಯಾ ಬಾವ್ಹಾಸಾಟಿ ಪ್ಯೂರ್ಗಿ ಕಾಡಾ ವ್ಹಯಿತ ಮನ್ಹುನ್ ಮೊಶೆನಿ ಲಿವ್‍ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","ಆಸ ಸಾತ್ ಜಾ಼ನ್ ಬಾಹು ಹುತ್ತ. ಪಯ್ಲಾ ಬಾಹು ಲಗಿನ್ ವ್ಹವುನ್ ಪೊರ ನಸ್ತಾನಾ ಮೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","ದೊನ್ವಾ ತಿಲಾ ಲಗಿನ್ ಜಾ಼ಲಾ ತ್ಯಲಾಬಿ ಪೊರ ವ್ಹಯಾಚೆ ಆಂದಿ ಮೆಲಾ ಆನಿ ತಿನ್ವಾಬಿ ಆಸಸ್ ವ್ಹವುನ್ ಮೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ಸಾತ್‌ಜಾ಼ನ ಬಾಹುಬಿ ತಿಲಾ ಲಗಿನ್ ವ್ಹವುನ್ ಪೊರ ನಸ್ತಾನಾ ಮೆಲ. ಮಾಗ್ನಿ ತೀ ಬಿ ಮಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","ಸಾತ್‌ಜಾ಼ನ್ ಬಾಹುಬಿ ತಿಲಾ ಲಗಿನ್ ಜಾ಼ಲ ಆಸ ಆಸ್ಥಾನಾ ಮಾನ್ಸ ಮರ್ನಾತ್ನಿ ಉಠುನ್ ಯತಾನಾ ತೀ ಕಚಾಚಿ ಬ್ಯಾಯ್ಕೋ ವ್ಹನಾರ್? ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","ಯೇಸು ತ್ಯನಾ “ತುಮಾನಾ ದರ್ಮ ಶಾಸ್ತಾರ್ ಆನಿ ದೇವಾಚಿ ತಾಕತ್ ಠಾವ ನಾಹಿ ಮನ್ಹುನ್ ಆಸ್ಲಾ ಚು಼ಕಿಚಾ಼ ಇಚಾರ್ ಕರ್ತಾಸಾ! ");
INSERT INTO gok_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","“ಮೆಲ್ಯಾಲಿ ಪುನರ್ಜಿವ್ ಜಾ಼ಲ್ಯಾವ ಲಗಿನ್ ಕರುನ್ ಗಿಹಿತ್ ನಾಹಿತ ಆನಿ ಲಗಿನ್ ಕರುನ್ ದಿಯಿತ್ ನಾಹಿತ. ದೇವ್‌ಲೊಕಾತ್‌ಲ್ಯಾ ದೇವ್ದುತಾಚೆಗತ್ ರಾಥ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","ಫನ್ ಮೆಲ್ಯಾಲಿ ಪುನರುತ್ಥಾನ್ ವ್ಹತ್ಯಾಲ ಸಾಂಗಾಯಾ ವ್ಹಯಿತ ‘ಮಿ ಅಬ್ರಹಾಮಾಚಾ಼ ದೇವ್, ಇಸಾಕಾಚಾ಼ ದೇವ್, ಯಾಕೊಬಾಚಾ಼ ದೇವ್’ ಮನ್ಹುನ್ ಜ಼ಳ್‌ತ್ಯಾಲೆ ಕನ್ಯಾರಿಚೆ ಜಾ಼ಳಿತ್ಲಿ ಖಬರ್ ಮೊಶೆಚಾ ಗ್ರಂಥಾತ್ ತುಮಿ ವಾಚಿವ್ಲಿ ನಾಹಿಸಾ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","ತ್ಯೊ ಜಿತ್ಯಾನಾ ದೆವ್ ಜಾ಼ಲ್ಯಾ ಮೆಲ್ಯಾಲ್ಯಾನಾ ನವ್ಹ. ಹೆ ಗುಸ್ಟಿತ್ ತುಮಿ ಖುಬ್ ಚು಼ಕ್ ಸಮಜು಼ನ್ ಗೆತಲೆಸಾ.” ");
INSERT INTO gok_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","ಯೊಕ್ ದರ್ಮ ಉಪದೆಸ್ ತಿಥ ಆಲಾ ಆನಿ ತ್ಯಂಚಾ಼ ವಾದ್ ಚಾ಼ಲ್ಯಾಲಾ ಐಕ್ಲಾ ಯೇಸುನಿ ಸಧುಕಾಯಾನಾ ಶಾರ್ಕಾ ಉತ್ರಾ ದಿಲ್ಯಾಲಾ ಬಗುನ್ ಯೇಸುಪ ಯವುನ್ ತ್ಯನಿ ತ್ಯಲಾ “ಸಗ್‌ಳ್ಯಾತ್ ಪೈಲಿ ಆಜ್ಞಾ ಕಚಿ? ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","ತ್ಯಲಾ ಯೇಸು “ಇಸ್ರಾಯಲ್ ಲೋಕಾನು ಐಕಾ ಆಮಚಾ಼ ದೇವ್ ಪರ್ಮೇಶ್ವರ್ ಯೋಕುಸ್ ದೇವ್. ");
INSERT INTO gok_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","ತುಮಚಾ಼ ದೇವ್ ಪರ್ಮೇಶ್ವರಾಲಾ ಪುರ‍್ಯಾ ಮನಾನಿ, ಪುರ‍್ಯಾ ಆತ್‌ಮ್ಯಾನಿ, ಪೂರೆ ಬುದ್ದಿನಿ, ಪುರೆ ತಾಕ್ತಿನಿ ತ್ಯಚಿ ಮಾಯಾ ಕರಾ ಹಿಚ಼್ ಪೈಲಿ ಆಜ್ಞೆ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","ಆನಿ “ತುಮಿ ತುಮ್ಚಿ ಕಸಿ ಮಾಯಾ ಕರ್ತಾಸಾ ತಸಿಸ್ ತುಮ್ಚಾ ಸೆಜಾ಼ರ‍್ಯಾಚಿ ಮಾಯಾ ಕರಾ ವ್ಹಯಿ ಹಿ ದುನ್ವಿ ಆಜ್ಞೆ ಹ್ಯಾ ದುನಿ ಸಿವಾರ್ ಮುಟಿ ಆಜ್ಞೆ ನಾಹಿ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","ತವಾ ದರ್ಮ ಉಪದೆಸ್ ಯೇಸುಲಾ “ಪ್ರಬು, ತ್ಯೊ ಚಾ಼ಂಗ್ಲಾ ಉತ್ತರ್ ಖರಾ ದೇವ್ ಯೋಕುಚ಼್ ತ್ಯೊ ಪರ್ಮೇಶ್ವರ್ ಆನಿ ದಿಸ್ರಾ ದೇವ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","ತ್ಯಚೆ ಸಿವಾರ್ ಆನಿ ದಿಸ್ರಾ ದೇವ್ ನಾಹಿ ಮಾನ್ಸಾನಿ ದೇವಾಲಾ ಆಪ್‌ಲ್ಯಾ ಪುರ‍್ಯಾ ಮನ್ಹಾನಿ, ಪೂರೆ ಬುದ್ದಿನಿ, ಪೂರೆ ತಾಕ್ತಿನಿ, ಬಖ್ತಿ ಕರಾ ವ್ಹಯಿ ಆನಿ ಯೊಕ್ ಮಾನುಸ್ ಆಪ್‌ಲ್ಯಾಲಾ ಕ್ಯವ್ಡಿ ಮಾಯಾ ಕರ್ತೊ ತ್ಯವ್ಡಿ ಸೆಜಾ಼ರ‍್ಯಾಲಾಬಿ ಕರಾ ವ್ಹಯಿ. ಆಮಿ ದೇವಾಲಾ ದೆತ್ಯಾಲ್ಯಾ ಜ಼ನಾವಾರಂಚಾ ಯದ್‌ನ್ಯಾಪರಾಸ್ ಹ್ಯಾ ಆಜ್ಞಾ ಖುಬ್ ಮೊಟ್ಯಾ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","ತ್ಯನಿ ಶಾನ್ಪನಾನಿ ಸಾಂಗ್‌ಲ್ಯಾಲ ಉತ್ತರ್ ಐಕುನ್, ಯೇಸು “ತು ದೇವಾಚಾ ರಾಜಾಲಾ ಜ಼ವಳ್ ಹಾಸ್” ಮನ್ಲಾ. ತವಾಚಾನ್ ಯೇಸುಲಾ ಪ್ರಶ್ನೆ ಇಚಾರಾಯಾ ಕುನಾಲಾ ಧೀರ್ ಜಾ಼ಲಾ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","ಯೇಸು ದೇವ್ಳಾತ್ ಉಪದೆಸ್ ಸಾಂಗಿತ್ ಆಸ್ಥಾನಾ, “ಕ್ರಿಸ್ತ್ ದಾವಿದಾಚಾ಼ ಲ್ಯೊಕ್” ಮನ್ಹುನ್ ದರ್ಮೊಪದೆಶಕ್ ಮಂತ್ಯಾತ ತ್ಯ ಕಾ? ");
INSERT INTO gok_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","ದಾವಿದ್ ಪವಿತ್ರಾತ್ಮಾನಿ ಬರ್ಹುನ ಕ್ಯಾ ಸಾಂಗ್ಲ ಮನ್‌ಲ್ಯಾವ ದೇವ್ ಪರ್ಮೇಶ್ವರಾನಿ ಮಾಜಾ ಪ್ರಭುಲಾ ಸಾಂಗ್ಲ, “ಮಿ ತುಜಾ ವೈರಿನಾ ತುಜಾ ಪಾಯಾ ಖಾಲ್ ಗಾಲಿ ಪರ‍್ಯಾತ್ ತು ಮಾಜೆ಼ ಉಜ಼ವ್ಯಾಂಗ್ನಿ ಬಸ್ಹುನ್ ರ‍್ಹಾ!. ");
INSERT INTO gok_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","ದಾವಿದುಸ್ ಸ್ವತಾ ಮೆಸಿಯಾಲಾ ಪ್ರಭು ಮನ್‌ಲ್ಯಾ ನಂತರ್, ಆನಿ ತ್ಯೊ ತ್ಯಚಾ಼ ಲ್ಯೊಕ್ ಕಸಾ ವ್ಹಯಿಲ್? ಮನ್ಲಾ. ಯೇಸುಚ಼ ಬೋಲ್ನ ಐಕುನ್ ಖುಬ್ ಲೊಕಾನಾ ಆನಂದ್ ಜಾ಼ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","ಯೇಸುನಿ ಆಪ್ಲ ಬೋಲ್ನ ಚಾಲು ಕರುನ್, “ದರ್ಮೋಪದೇಶಕಾಂಚೆ ಗುಶ್ಟಿತ್ ಹುಶಾರ್ ರಾವ್ಹಾ ತೇ ಲಾಮ್ ಲಾಮ್ ಜ಼ಘ ಗಾಲ್ಹುನ್ ಬಾಜಾ಼ರಾತ್ನಿ ಫಿರ್ತಾನಾ ಲೊಕಾಂಚಿಪ್ನಿ ಆಪ್‌ಲ್ಯಾಲಾ ಮರ‍್ಯಾದ್ ಗಾವಾಸಾಟಿ ನಮಸ್ಕಾರ್ ಕರಾವಾ ಮಂತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ಆನಿ ಸಬಾ ಸ್ತಾನಾತ್ ಮುಖ್ಯ ಸ್ಥಾನ್, ಪಂಗ್ತಿತ್ ಮುಖ್ಯ ಸ್ಥಾನ್ ವ್ಹಯಿ ಮಂತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","ಆನಿ ತೆ ವಿದವೆಂಚಿ ಗರ್‍ಹ ಗಿಳುನ್ ಮೊಸ್ ಕರ್ತ್ಯಾತ ಆನಿ ಮೊಟ್ಯಾನಿ ಮಾಗ್ನ ಕರ್ತ್ಯಾತ. ದೇವ್ ಆಸ್‌ಲ್ಯಾನಾ ಕಠಿನ್ ಸಿಕ್ಶಾ ದೆನಾರ್” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","ಯೇಸು ದೇವ್ಳಾತ್ ದಿನ್ಗಿಚೆ ಪಿಟಿ ಮೋರ್ಹ ಬಸ್ಲಾಹುತ್ತಾ ತವಾ ಲೊಕ ಪಿಟಿತ್ ಪೈಸ ಗ್ಯಾಲತ್ಯಾಲ್ಯಾಕ್ಡ ಲಕ್ಶೆ ದಿಲ. ಸಾವ್ಕಾರ್ ಲೊಕ ಖುಬ್ ಪೈಸ ಗಾಲ್ಹಿತಿತ. ");
INSERT INTO gok_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","ಮಂಗ್ ಏಕ್ ಗರಿಬ್ ವಿದ್ವಾ ಯವುನ್ ತಿನಿ ದೊನ್ ಆನ ಗ್ಯಾತ್ಲ ಮಂಜೆ ಯೊಕ್ ಪೈಸಾ ಗ್ಯಾತ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","ಯೇಸುನಿ ಆಪ್‌ಲ್ಯಾ ಶಿಶಾನಾ ಕಡಸ್ ಹಾಕ್ಟುನ್, “ಮಿ ತುಮಾನಾ ಖರ ಸಾಂಗ್ತೊ ದಿನ್ಗಿ ಗ್ಯಾತ್‌ಲ್ಯಾಲ್ಯಾತ್ ಸಗ್‌ಳ್ಯಾ ಪಕ್ಶಿ ಗರಿಬ್ ವಿದ್ವೆನಿ ಖುಬ್ ಗ್ಯಾತ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","ರಾಲ್ಯಾಲ್ಯಾಂಚಾನಿ ಆಪ್‌ಲ್ಯಾಲಾ ಪುರೊಹ್ವವುನ್ ಉರ್ಲ್ಯಾಲ್ಯಾತ್ ಥೊಡ ಗ್ಯಾತ್‌ಲ್ಯಾ. ಹಿನಿ ಆಪ್ಲೆ ಗರಿಬ್ತಿತಿತ್ ಆಪ್ಲಿಪ ಆಸ್‌ಲ್ಯಾಲ ಸಗ್ಳ ದಿಲ, ಆಪ್ಲಾ ಜೀವ್ನಾಸ್ ದಿಲಾ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","ಯೇಸು ದೇವ್ಳಾತ್ನಿ ಜಾ಼ತಾನಾ ತ್ಯಚಾ ಯಕಾ ಶಿಶಾನಿ ತ್ಯಲಾ “ಪ್ರಬು, ಬಗ್! ಕ್ಯವ್ಡ ಮೊಟ ದೊಂಢ! ಕ್ಯವ್ಡ ಮೊಟ ಬಾಂದ್ ಕಾಮ್!” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","“ತುಮಿ ಹ್ಯ ಮೊಟ ಬಾಂದ್ ಕಾಮ್ ಬಗ್‍ತ್ಯಾಸಾ ನವ್ಹ? ಹ್ಯ ಸಗ್ಳ ಬಾದ್ ವ್ಹನಾರ್ ದೋಂಡ್ಯಾವ ದೊಂಢಾ ರಾನ್ಹಾರ್ ನಾಹಿ ಸಗ್ಳ ದೊಂಢ ಪಡ್ನಾರ್” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","ಮಂಗ್ ತ್ಯೊ ದೇವ್ಳಾಚೆ ಮೋರ್ಹ ಒಲೀವ್ ತೆಲಾಚಾ ಜಾ಼ಢಾಚಾ ಗುಢ್ಯಾವ ಬಸ್ಲಾ ತವಾ ಪೇತ್ರ, ಯಾಕೊಬ್, ಯೊಹಾನ್, ಆಂದ್ರೇಯ್, ");
INSERT INTO gok_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“ತ್ಯ ಕವಾ ವ್ಹನಾರ್? ತ್ಯ ಸಗ್ಳ ವ್ಹತಾನಾ ಕಸ ಸಮಾಜ್ನಾ಼ರ್ ಕ್ಯಾ ವಳಕ್ ಹಾ ಆಮಾನಾ ಸಾಂಗ್” ಮನ್ಹುನ್ ತ್ಯಲಾ ಯಕಾನ್ಸಿ ಇಚಾರಾಯಾ ಲಾಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","ತ್ಯಲಾ ಯೇಸುನಿ ತ್ಯನಾ “ಕೊನ್ ತರಿ ತುಮಚಾ಼ ಘಾತ್ ಕರಿಲ್ ಜಾ಼ಗ್ರತ್ ರಾವ್ಹಾ. ");
INSERT INTO gok_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","ಖುಬ್ ಜಾ಼ನ್ ಯವುನ್ ಮಾಜ಼ ನಾವ್ ಗಿಹುನ್ “ಮಿಸ್ ತ್ಯೊ ಕ್ರಿಸ್ತ್, ಮನ್ಹುನ್ ಖುಬ್ ಜ಼ನಾನಾ ಫಸಿವ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","ಆನಿ ಜ಼ವಳ್ ಚಾ಼ಲತ್ಯಾಲ್ಯಾ ಲಡಾಯಿಂಚಾ಼ ಆವಾಜ಼್ ಐಕು ಯನಾರ್ ದುರ್ ಚಾ಼ಲತ್ಯಾಲೆ ಲಡಾಯಿಂಚಿ ಬಾತ್ನಿ ಐಕು ಯನಾರ್ ತ್ಯಲಾ ಬಿಹುನಕೊಸಾ ಸಮಾಪ್ತಿ ವ್ಹಯಾಚೆ ಆಂದಿ ಹ್ಯ ವ್ಹಯಾಸ್ ಪಾಯ್ಜೆ ಖರ ಹ್ಯಚ಼್ ಸಮಾಪ್ತಿ ನವ್ಹ. ");
INSERT INTO gok_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","ಲೊಕ ಲೊಕಾಂಚೆ ಆಡ್ವಿ ಲಡ್ನಾರ್ ರಾಜಾಂಚೆ ಆಡ್ವ ರಾಜ ಲಡ್ನಾರ್ ಜಿತ ಜಿತ ಭುಕಂಪ ವ್ಹನಾರ್, ಆನಾಲಾ ಬರ್ಗಾಲ್ ಯನಾರ್, ಹ್ಯ ಬಾಳತ್ಪನಾಚ಼ ಯಾಗ್ ಸುರು ಜಾ಼ಲ್ಯಾಚೆಗತ್ ರಾನ್ಹಾರ್. ");
INSERT INTO gok_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","ತುಮಿ ಸಂಬಾಳುನ್ ರಾವ್ಹಾ! ಮಾಜೆ಼ ಮಾಗ್ನಿ ಯತಾಸಾ ಮನ್ಹುನ್ ಲೊಕ ತುಮಾನಾಬಿ ದರ‍್ಹುನ್ ಚೌ಼ಕಸಿ ಕರ್ನಾರ್, ಸಬಾ ಸ್ತಾನಾತ್ ನಿಹುನ್ ತುಮಾನಾ ಮಾರ್ನಾರ್, ರಾಜಾಂಚೆ ಮೊರ‍್ಹ ತುಮಾನಾ ಉಬ ಕರುನ್ ಮಾಜಿ ಸಾಕ್ಶಿ ಸಾಂಗಾ ಮನ್ಹಾರ್. ");
INSERT INTO gok_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","ಖರ ಅಂತ್ಯ ಯಯಾಚೆ ಆಂದಿ ತುಮಿ ಸಗ್ಳೆ ಜಾ಼ತಿಚಾ ಲೊಕಾನಾ ಸುವಾರ್ತಾ ಸಾಂಗಾ ವ್ಹಯಿಸಾ. ");
INSERT INTO gok_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","ತುಮಾನಾ ದರ‍್ಹುನ್ ಚೌ಼ಕಸಿ ಕರ್ತಾನಾ ತುಮಿ ಕ್ಯಾ ಸಾಂಗಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಆಂದಿಸ್ ಯವ್ಜು ನಕೊಸಾ ತೆ ಗಟ್ಕಲಾ ತುಮಾನಾ ಪರ್ಮೇಶ್ವರ್ ಕ್ಯಾ ಸಮಜು಼ನ್ ದಿಯಿಲ್ ತ್ಯ ಬೊಲಾ ಕಾ ಮನ್‌ಲ್ಯಾವ ಬೊಲ್ನಾರ‍ ತುಮಿ ನವ್ಹ ತುಮ್ಚೆ ಸಂಗ ಪವಿತ್ರಾತ್ಮ ಬೊಲ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“ಬಾಹು ಬಾವ್ಹಾನಾ, ಬಾ ಆಪ್‌ಲ್ಯಾ ಪೊರಾನಾ ಮಾರಾಲಾ ದಿಯಿಲ್. ಪೊರ ಆಪ್ಲೆ ಆಯಿ ಬಾಚೆ ಆಡ್ವ ಪರ್ತುನ್ ತ್ಯನಾ ಮಾರಾಯಾ ದೆನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","ತುಮಿ ಮಾಜೆ ಮಾಗ್ನಿ ಯತಾಸಾ ಮನ್ಹುನ್ ಲೊಕ ತುಮಚಾ಼ ರಾಗ್ ಕರ್ನಾರ್. ಫನ್ ಸೆವಟ್ ಪರ್ಯಾತ್ ಥಾಂಬ್ನಾರಾ ದೇವಾಚಾ ನ್ಯಾಯಾ ತೀರ್ಪಾತ್ನಿ ಚು಼ಕುನ್ ದೇವ್ಲೋಕಾತ್ ಜಾ಼ಯಾಲಾ ಚಾ಼ಂಗ್ಲ ವ್ಹನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“ಆನಿ ಯಕಸಿ ನಾಸ್ ಕರ್ತ್ಯಾಲಾ ಬುರ್ಸಾ ಜಿನೊಸ್ ರಾಹುನಾಹಿತ್ಯಾ ಜಾ಼ಗ್ಯಾವ ಉಬಾರಾಯ್‌ಲ್ಯಾಲಾ ಬಕ್ಸಿಲಾ ತವಾ ಯುದಾಯಾತ್ಲಿ ಲೊಕ ಗುಢ್ಯಾವ ಜಾ಼ನಾರ್ (ಹ್ಯ ವಾಚಿವ್‌ತ್ಯಾಲಾ ಸಮಜು಼ನ್ ಗಿಹುನಿ) ತವಾ ಯೂದಾಯಾತ್‌ಲ್ಯಾಂಚಾನಿ ಗುಢ್ಯಾಂಚಿವ ಪಳುನ್ ಜಾ಼ಯಾ ವ್ಹಯಿ. ");
INSERT INTO gok_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","ಮಾಳಿವ ಆಸ್ನಾರಾ ಖಾಲ್ ಉತ್ರುನ್ ಗರ‍್ಹಾತ್ಲ ಕಾಯೇಕ್ ನಿಹ್ಯಾಚೆ ಆಂದಿ ಪಳುನ್ ಜಾ಼ವುನಿ. ");
INSERT INTO gok_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","ಸೆತಾತ್ ಆಸ್‌ಲ್ಯಾಲ್ಯಾನಿ ಆಪ್ಲ ಕಪ್ಡ ಗಿಹ್ಯಾ ಪರ್ತುನ್ ಗರ‍್ಹಾಕ್ಡ ಜಾ಼ವು ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","“ತ್ಯಾ ಯಳಾಲಾ ಗರ್ವಾರ್ಕರ್ನಿಲಾ ಆನಿ ಬಾರಿಕ್ ಪಿತ್ಯಾಲ ಮುಲ್ ಆಸ್ನಾರಿಲಾ ಖುಬ್ ತರಾಸ್ ವ್ಹನಾರ್! ");
INSERT INTO gok_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","ಹ್ಯ ಪಾವುಸಾತ್ ಥಂಡಿಚಾ ದಿಸಾತ್ ವ್ಹವು ನಾಹಿ ಮನ್ಹುನ್ ದೇವಾಪ ಮಾಗಾ. ");
INSERT INTO gok_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","ಕಾ ಮನ್‌ಲ್ಯಾವ ತೆ ದಿಸ್ ಖುಬ್ ತರಾಸಾನಿ ಬರ್‌ಲ್ಯಾಲ ರಾನ್ಹಾರ್. ದೇವಾನಿ ಹ್ಯೊ ಪರ್‌ಪಂಚಾ ಸ್ರಶ್ಟಿ ಕೆಲ್ಯಾ ಠಾವ್ನಿ ತಸ್ಲಾ ತರಾಸ್ ಆಜು಼ನ್ಪರ‍್ಯಾತ್ ಆಲಾನಾಹಿ, ಹಿತ್ನಿ ಮೊರ‍್ಹಬಿ ಯನಾರ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","ದೇವಾನಿ ಹೆ ದಿಸ್ ಕಮ್ಮಿ ಕರಾಯಾ ಯವಜ಼್ಲ ನಾಹಿತ ಕೊನೆಕ್ ಮಾನುಸ್ ಜಿತ್ತ ರಾಹ್ಯಾ ವ್ಹಯಿತ್ ನವ್ಥ. ಫನ್ ದೇವಾನಿ ಆಪ್ನು ನಿವಡ್‌ಲ್ಯಾಲ್ಯಾ ಲೊಕಾಂಚೆ ಸಾಟಿ ತೆ ದಿಸ್ ಕಮ್ಮಿ ಕೆಲ. ");
INSERT INTO gok_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“ತವಾ ಕೊನ್ತರಿ ತುಮಾನಾ ‘ಕ್ರಿಸ್ತ್ ಹ್ಯಾ ಜಾ಼ಗ್ಯಾವ ಹಾ, ತ್ಯಾ ಜಾ಼ಗ್ಯಾವ ಹಾ, ಬಗಾ ಮನ್ಥಿಲ ತ್ಯ ಖರ ದರು ನಕೊಸಾ. ");
INSERT INTO gok_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","ಸಾದ್ಯ ಜಾ಼ಲ್ಯಾವ ದೇವಾನಿ ನಿವಡ್‌ಲ್ಯಾಲ್ಯಾ ಲೊಕಾಂಚಾ಼ ಘಾತ್ ಕರಾಯಾ ಲಬಾಡ್ ಕ್ರಿಸ್ತ್, ಲಬಾಡ್ ಪ್ರವಾದಿ ಯವುನ್ ಪವಾಡ ಆನಿ ಮುಟಿ ಮುಟಿ ಕಾಮ ಕರ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","ಮನ್ಹುನ್ ತುಮಿ ಸಂಬಾಳುನ್ ರಾವ್ಹಾ, ಮಿ ತುಮಾನಾ ಆಗೊದಾರ್ ಸಗ್ಳ ಸಾಂಗ್‌ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“ಹೆ ತರಾಸಾಚ಼ ದಿಸ್ ಯವುನ್ ಗೆಲ್ಯಾ ನಂತರ್, ದಿಸ್ ಅಂದಾರ್ ವ್ಹನಾರ್. ಚಾ಼ಂದ್ ಚಾನ್ನ ದೆನಾರ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ಚಾನ್ಯಾ ಆಬ್ಳಾತ್ನಿ ಪಡ್ನಾರ್. ಆನಿ ಆಬ್ಳಾತ್ಲ ಬಳ್ ಹಲ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","ತವಾ ಮಾನ್ಸಾಚಾ ಲ್ಯೊಕ್ ಮೊಟ್ಯಾ ಹುಕ್ಮಾನಿ ಆನಿ ಮಹಿಮೆನಿ ಡಘಾತ್ನಿ ಯತ್ಯಾಲಿ ಲೊಕ ಬಗ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","ಮಂಗ್ ಮಾನ್ಸಾಚಾ ಲೇಕಾನಿ ಆಪ್‍ಲ್ಯಾ ದೇವ್ದುತಾನಾ ದರ್ಥಿವ ಸಗ್ಳಿಕ್ಡ ಲಾವುನ್ ದಿವುನ್ ಆಪ್ನು ನಿವಡ್‌ಲ್ಯಾಲ್ಯಾನಾ ದರ್ತಿವ ಸಗ್ಳಿಕ್ಡ ಆನಿ ದೇವ್ಲೋಕಾತ್ನಿ ಸಗ್ಳಿಕ್ನಿ ಯಕಿಕ್ಡ ಜ಼ಮಾ ಕರ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“ಅಂಜು಼ರಾಚ಼ ಝಾ಼ಡ್ ಆಮಾನಾ ಯೊಕ್ ಪಾಟಾ ಸಿಕಿವ್ತ. ತ್ಯಾ ಜಾ಼ಢಾಲಾ ಕವ್ಳ ಡಾಳ್ಳಾ ಯವುನ್ ಹಿರ್ವಿ ಪಾನ ಯತಾನಾ ಉನಾಳಾ ಜ಼ವಳ್ ಆಲಾ ಮಂಥಾಸಾ ನವ್ಹ. ");
INSERT INTO gok_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","ತಸಸ್ ತುಮಿಬಿ ಹ್ಯ ಸಗ್ಳ ವ್ಹತ್ಯಾಲ ಬಗ್ತಾನಾ ಯೊಳ್ ಜ಼ವಳ್ ಆಲ್ಯಾ, ದಾರಾತ್ ಉಬಾ ಹಾ ಮನ್ಹುನ್ ಸಮಜು಼ನ್ ಗೆವ್ಹಾ. ");
INSERT INTO gok_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","ಯದತ್ ರಾಹುನಿ ಹ್ಯ ಸಗ್ಳ ವ್ಹಯಿಸ್ ಪರ‍್ಯಾತ್ ಹಿ ಪಿಳ್ಗಿ ಪುಸುನ್ ಜಾ಼ನಾರ್ ನಾಹಿ ಮನ್ಹುನ್ ತುಮಾನಾ ಖರ ಸಾಂಗ್ತೊ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","ದರ‍್ತಿ ಆಬಾಳ್ ಪುಸುನ್ ಜಾ಼ಯಿಲ್. ಖರ ಮಿ ಸಾಂಗ್‌ಲ್ಯಾಲ ವ್ಹಯಾಚೆ ಆಂದಿ ರಾನಾರ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","ಆನಿ “ತ್ಯೊ ದಿಸ್ ನಾಹಿತ ತಿ ಗಟ್ಕಾ ಪರ್ಮೇಶ್ವರಾಲಾ ಸುಡುನ್ ದೇವ್ದುತಾನಾ ನಾಹಿತ, ಲೇಕಾಲಾ ಸಾಹಿತ್, ಸಮಾಜ಼ಲಿ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","ಸಂಬಾಳುನ್ ರಾವ್ಹಾ! ಖಾಯಿಮ್ ತಯಾರ್ ರಾವ್ಹಾ! ತ್ಯ ಕವಾ ವ್ಹಯಿಲ್ ಮನ್ಹುನ್ ತುಮಾನಾ ಠಾವ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","ಕಸ ಮನ್‌ಲ್ಯಾವ “ಯೊಕ್ ಮಾನುಸ್ ದುಸ್‌ರ‍್ಯಾ ಮುಲ್ಕಾತ್ ಜಾ಼ತಾನಾ ಆಪ್ಲ ಘರ‍್ದಾರ್ ಆಳಾಂಚಿವ ಸುಡುನ್ ಜಾ಼ತಾನಾ ಯಕಾ ಯಕಾಲಾ ತ್ಯಂಚ಼ ತ್ಯಂಚ಼ ಕಾಮ್ ಸಾಂಗುನ್ ಘರ್ ರಾಕ್ನಾರ‍್ಯಾಲಾ ಸಂಬಾಳುನ್ ರ‍್ಹಾ ಮನ್ಹುನ್ ಸಾಂಗ್‌ತ್ಯಾಚೆಗತ್ (ಮಿ ತುಮಾನಾ ಸಾಂಗ್ತೋ). ");
INSERT INTO gok_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","ಗರ‍್ಹಾಚಾ಼ ದನ್ಹಿ ಶಾಂಚಾ಼ ಯಯಿಲ್ ಕ್ಯಾ ಆರ್ದೆ ರ‍್ಯಾಚಾ಼ ಯಯಿಲ್ ಕ್ಯಾ ಕೊಂಬ್ಡಾ ಬವ್ತಾ ಯಯಿಲ್ ಕ್ಯಾ ಸಕಾಳಚಾ಼ ಯಯಿಲ್ ತುಮಾನಾ ಠಾವ ನಾಹಿ ಮನ್ಹುನ್ ಸಂಬಾಳುನ್ ರಾವ್ಹಾ. ");
INSERT INTO gok_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","ತ್ಯೊ ಬಿಗಿನಿ ಮಾಗಾರಾ ಯಯಿಲ್ ತವಾ ತುಮಿ ನಿಜ಼ಲ್ಯಾಲ ಬಗು ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","ಮಿ ತುಮಾನಾ ಸಾಂಗ್‌ಲ್ಯಾಲ ಸಗ್‌ಳ್ಯಾನಾ ಸಾಂಗ್ತೋ ಸಂಬಾಳುನ್ ರಾವ್ಹಾ!” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","ಪಸ್ಕಾಚಾ಼ ಆನಿ ಆಂಬಾಟ್ ನಸ್‌ಲ್ಯಾಲ್ಯಾ ಬಾಕ್‌ರ‍್ಯಾಂಚಾ಼ ಸನ್ ಯಯಾಚೆ ದೊನ್ ದಿಸ್‌ ಆಂದಿ ಮುಖ್ಯ ಯಾಜಕ್ ಆನಿ ಕ್ಯಾಯ್ದದಾರ್ ಲೊಕ್ ಯೇಸುಪ ಉಗಸ್‌ಚಿ಼ ಚು಼ಕ್ ದರಾಯಾ ಪಾರಕ್ ಸುದಿತ. ");
INSERT INTO gok_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","“ಖರ ಸನಾತ್ ದರ‍್ಹು ನಾಹಿ, ಆಮ್ಚಾ ಲೊಕಾಂಚಾ಼ ಗಾನ್ಹಾ ವ್ಹಯಿಲ್ ಮನ್ಹುನ್ ಬೊಲ. ” ");
INSERT INTO gok_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","ತ್ಯೊ ಬೆತಾನಿತ್ ಕುಶ್ಟರೊಗಿ ಜಾ಼ಲ್ಯಾಲ್ಯಾ ಸಿಮೊನಾಚಾ ಗರ‍್ಹಾತ್ ರಾಹುನ್ ಜೆವ್ನಾಲಾ ಬಸ್ಲಾ ಹುತ್ತಾ ತವಾ ಯೆಕ ಬಾಯಿಲ್ ಮಾನ್ಸಾನಿ ಖುಬ್ ಕಿಮ್ತಿಚ಼ ವಾಸಾಚ಼ ಜಟಮಾಸಿ ತೇಲಾನಿ ಬರ್ಲ್ಯಾಲಿ ಯೆಕ್ ಬರ್ನ್ಹಿ ಆನುನ್ ಫುಡುನ್ ತ್ಯಾಲ್ ಯೇಸುಚೆ ಡುಯಿವ ವತ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","ಖರ ಥೋಡ್ಯಾಂಚಾನಿ ಆಪ್‌ಲ್ಯಾ ಮನಾತ್ ರಾಗ್ ಕರುನ್ “ಹ್ಯ ತ್ಯಾಲ್ ಹಾಳ್ ಕಾ ಕೇಲಸ್? ");
INSERT INTO gok_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","ತಿನ್ಸೆ ಚಾ಼ಂದಿಚಾ ಪೈಸ್ಯಾನಾ ಇಕುನ್ ಗೊರ್ಗರಿಬಾನಾ ದಿಯಾ ಗಾವ್ಲ ಆಸ್ಥ ನವ್ಹ” ಮನ್ಹುನ್ ತಿಲಾ ದಪ್‌ಕ್ಯಾವಾಲಾಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","ಖರ ಯೇಸು, “ಹಿಲಾ ಸೊಡಾ ಹಿಲಾ ಕಶಾಲಾ ತರಾಸ್ ದೆತಾಸಾ? ಹಿನಿ ಮಾಜೆ ಸಾಟಿ ಯಾಕ್ ಚಾ಼ಂಗ್ಲ ಕಾಮ್ ಕೆಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","ಗೊರ್ಗರಿಬ ಕವಾಬಿ ತುಮ್ಚಿಪ ರಾಥ್ಯಾತ; ತುಮ್ಚಾ ಮನಾಸ್ ಯಯಿಲ್ ತವಾ ತ್ಯನಾ ತುಮಿ ಮಜ಼ತ್ ಕರಾಯಾ ಗಾವಲ್; ಫನ್ ಮಿ ಖಾಯಿಮ್ ತುಮ್ಚಿ ಸಂಗ ರಾನ್ಹಾರ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","ಹಿನಿ ಮಿ ಮೆಲ್ಯಾ ನಂತರ್ ಮಾಜಾ ಮಡ್ಯಾಲಾ ಲ್ಯಾವ್‌ತ್ಯಾಲ ತ್ಯಾಲ್ ಅತ್ತಾಚ಼್ ಮಾಜಾ ಆಂಗಾಲಾ ಲ್ಯಾವ್‌ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","ಸೂವಾರ್ತಾ ಜ಼ಗತಿತ್ ಕುಠ ಕುಠ ಸಾಂಗ್ಸಿಲಾ ತಿಥ ತಿಥ ಹಿನಿ ಕೆಲ್ಯಾಲ ದಿಕಿಲ್ ಹಿಚೆ ಯದಸಾಟಿ ಸಾಂಗಾವಿ ಲಾಗಲ್ ಮನ್ಹುನ್ ತುಮಾನಾ ಖರ‍್ಯಾನಿ ಸಾಂಗ್ತೋ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","ತ್ಯಾ ನಂತರ್ ಬಾರಾಜಾ಼ನ್ ಶಿಶಾತ್ಲಾ ಯಕ್ಲಾ ಇಸ್ಕರಿತ್ ಯುದ್ ಯೇಸುಲಾ ಮುಖ್ಯ ಯಾಜಕಾಂಚಿ಼ಪ ದರ‍್ಹುನ್ ದಿಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ತ್ಯಂಚಿಪ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","ತ್ಯ ಐಕುನ್ ಯಾಜಕ್ ಸಂತೋಸ್ ಜಾ಼ಲ, “ಆನಿ ತ್ಯಲಾ ತ್ಯಂಚಾನಿ ಪೈಸ ದಿಯಾಚ಼ ಕೆಲ ತ್ಯೊ ಯೇಸುಲಾ ದರ‍್ಹುನ್ ದಿಯಾ ಚಾ಼ಂಗ್ಲಾ ಯೊಳ್ ಸುದುಲಾಗ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","ಆಂಬಾಟ್ ನಸ್‌ಲ್ಯಾಲ್ಯಾ ಬಾಕ್‌ರ‍್ಯಾಂಚಾ ಸನಾಚೆ ಪೈಲೆ ದಿಸಿ. ಮಂಜೆ ವಲಾಂಡ್ಯಾಚ಼ ಬಕ್ರ ಮ್ಯಾರ್ತ್ಯಾಲ್ಯಾ ದಿಸಾ ದಿಸಿ ಯೇಸುಚಾ ಶಿಶಾಂಚಾನಿ, “ಯೇಸುಲಾ ವಲಾಂಡ್ಯಾಚ಼ ಜೆವಾನ್ ಕರಾಯಾ ಆಮಿ ಕುಠ ಜಾ಼ವುನ್ ತಯಾರ್ ಕರಾವ ಮನ್ಥೋಸ್” ಮನ್ಹುನ್ ತ್ಯಲಾ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","ತ್ಯಲಾ ಯೇಸುನಿ ಆಪ್‌ಲ್ಯಾ ಶಿಶಾತ್‌ಲ್ಯಾ ದೊಗಾನಾ ಹಾಕ್ಟುನ್, “ತುಮಿ ಪೆಠತ್ ಜಾ಼ವಾ; ತಿಥ ಯೊಕ್ ಮಾನುಸ್ ಬರ್ಲ್ಯಾಲಿ ಪಾನ್ಯಾಚಿ ಗಾಘರ್ ಗಿಹುನ್ ತುಮ್ಚೆ ಮೊರ‍್ಹ ಯಯಿಲ್; ತುಮಿ ತ್ಯಚೆ ಮಾಗ್ನಿ ಜಾ಼ವಾ; ");
INSERT INTO gok_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ತ್ಯೊ ಕಚಾ ಗರ‍್ಹಾತ್ ಜಾ಼ಯಿಲ್ ತ್ಯಾ ಗರ‍್ಹಾಚಾ ದನ್‌ಹ್ಯಾಲಾ, “ಆಮ್‌ಚಾ಼ ಪ್ರಬು ಆಪ್‌ಲ್ಯಾ ಶಿಶಾಂಚಿ ಸಂಗ ವಲಾಂಡ್ಯಾಚ಼ ಜೆವಾನ್ ಕರಾಯಾ ವ್ಯವಸ್ತಿತ್ ಆಸ್‌ಲ್ಯಾಲಿ ಖುಲಿ ಕಚಿ ಮನ್ಹುನ್ ಇಚಾರ್ತ್ಯೊ ಮನ್ಹುನ್ ಸಾಂಗಾ ");
INSERT INTO gok_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","ಮಂಗ್ ತ್ಯೊ ತುಮಾನಾ ಸಗ್ಳ ಸಂಜಿತ್ ಆಸ್‌ಲ್ಯಾಲೆ ಮಾಡಿ ವೈಲಿ ಯೆಕ್ ಮುಟಿ ಖುಲಿ ದಾವಿಲ್ ತಿಥ ಮಾಜೆಸಾಟಿ ತಯಾರ್ ಕರಾ” ಮನ್ಹುನ್ ಸಾಂಗುನ್ ತ್ಯನಾ ಲಾವುನ್ ದಿಲ. ");
INSERT INTO gok_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","ಶಿಶಾ ನಿಗುನ್ ಪೆಠತ್ ಜಾ಼ವುನ್ ತ್ಯನಿ ಆಪ್‌ಲ್ಯಾನಾ ಸಾಂಗ್‌ಲ್ಯಾ ಶಾರ್ಕ ತಿಥ ಬಗುನ್ ಪಸ್ಕಾಚಾ ಸನಾಚಾ ಜೆವ್ನಾಚಿ ತಯಾರಿ ಕಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","ಶಾಂಜ್ ಜಾ಼ಲಿ ತವಾ ತ್ಯೊ ಆಪ್‌ಲ್ಯಾ ಬಾರಾ ಜಾ಼ನ್ ಶಿಶಾಂಚಿ ಸಂಗ ಆಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","ತೇ ಬಸುನ್ ಜೆವಾನ್ ಖಾತಾನಾ ಯೇಸು, “ತುಮ್ಚಾತ್ಲಾ ಯಕ್ಲಾ ಮನಾ ದರ‍್ಹುನ್ ದೆನಾರ್ ತ್ಯೊ ಮಾಜೆ ಸಂಗ ಖಾನಾರಾಸ್ ಮನ್ಹುನ್ ತುಮಾನಾ ಖರ ಸಾಂಗ್ತೋ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","ತವಾ ತೇ ಬೆಜಾರ್ ಕರುನ್ “ಮಿ ನವ್ಹ” ಮನ್ಹುನ್ ಯೊಕ್ ಯೊಕ್ ತ್ಯಲಾ ಮನ್ಹು ಲಾಗಲ. ");
INSERT INTO gok_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","ತ್ಯನಿ ತ್ಯನಾ, “ತ್ಯೊ ಮಾಜಾ ಬಾರಾ ಜ಼ನಾತ್ಲಾ ಯೊಕ್, ಮಾಜೆ ಸಂಗ ತಾಟಿತ್ ಹಾತ್ ಗಾಲ್ಹುನ್ ಬಾಖ್ರಿ ಖಾನಾರಾಸ್ ");
INSERT INTO gok_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","ಶಾಸ್ತಾರಾತ್ ಲಿವ್‍ಲ್ಯಾ ಶಾರ್ಕ ಮಾನ್ಸಾಚಾ಼ ಲ್ಯೊಕ್ ಮರ್ನಾರ್. ಖರ ಕೊನ್ ಮಾನ್ಸಾಚಾ ಲೇಕಾಲಾ ದರ‍್ಹುನ್ ದೇತೊ ತ್ಯಚಿ ಹಾಕಿಗತ್ ಕ್ಯಾ ಸಾಂಗು ತ್ಯೊ ಮಾನುಸ್ ಜ಼ಲಾಮ್ಲಾ ನಸ್‌ತ್ತಾ ತ ತ್ಯಲಾ ಬರ ಹುತ್ತ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","ತೇ ಖಾಯಿತ್ ಆಸ್ಥಾನಾ ಯೇಸು ಬಾಖ್ರಿ ಗಿಹುನ್ ದೇವಾಲಾ ದಾವುನ್ ಮುಡುನ್ ತ್ಯನಾ ದಿವುನ್ “ಗೆವ್ಹಾ; ಹ್ಯ ಮಾಜ಼ ಧಡ್” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","ತ್ಯಾ ನಂತರ್ ತ್ಯನಿ ಪೇಲಾ ಗಿಹುನ್ ದೆವಾಲಾ ದಾವುನ್ ತ್ಯನಾ ದಿಲಾ; ತೇ ಸಗ್ಳ ತ್ಯಾತ್ ಪಿಯಾಲ. ");
INSERT INTO gok_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","ಆನಿ ಯೇಸುನಿ ತ್ಯನಾ “ಹ್ಯ ಮಾಜ಼ ರಗಾತ್ ಹ್ಯ ದೇವಾನಿ ಆಪ್‍ಲ್ಯಾ ಲೊಕಾಂಚೆ ಸಂಗ ನವಿನಿ ಕೆಲ್ಯಾಲಾ ಕರಾರ್; ಹ್ಯ ಖುಬ್ ಲೊಕಾಂಚಿ ಸಾಟಿ ಶಾಂಡ್‌ಲ್ಯಾಲ ರಗಾತ್. ");
INSERT INTO gok_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","ತುಮಾನಾ ಖರ ಸಾಂಗ್ತೋ, ಮಿ ದೇವಾಚಾ ರಾಜಾತ್ ದರಾಕ್ಶಿಚಾ ರಸ್ ನವಿನಿ ಪಿಯಾಚಾ ದಿಸ್ಹಾ ಪರ‍್ಯಾತ್ ಹ್ಯೊ ಹಿತ್ನಿ ಮೊರ‍್ಹ ಪಿನಾರ್ ನಾಹಿ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","ನಂತರ್ ತೆ ಗೀತ್ ಸಾಂಗುನ್ ತಿಥ್ನಿ ನಿಗುನ್ ತೆಲಾಚಾ ಜಾ಼ಢಾಚಾ ಒಲೀವ್ ಗುಢ್ಯಾವ ಗೆಲ. ");
INSERT INTO gok_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","ತವಾ ಯೇಸುನಿ ತ್ಯನಾ “ತುಮಿ ಸಗ್ಳ ಬಿಹುನ್ ಮಾಗ ಸರ್ನಾರ್. ದೇವ್ ಗುರಿಕ್ಯಾಲಾ ಮಾರುನ್ ಟ್ಯಾಕ್ನಾರ್, ಬಕ್ರಿ ಸಗ್ಳಿ ಪಳುನ್ ಜಾ಼ನಾರ್’ ಮನ್ಹುನ್ ಶಾಸ್ತಾರಾತ್ ಲಿವ್‌ಲ್ಯಾಲ ಹಾ ");
INSERT INTO gok_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","ಖರ ಮಿ ಮೆಲ್ಯಾವ ದೇವಾನಿ ಮನಾ ಜಿ಼ತ್ತಾ ಕೆಲ್ಯಾ ನಂತರ್ ತುಮ್ಚೆ ಮೋರ್ಹ ಗಲಿಲಾಯಾತ್ ಜಾ಼ನಾರ್” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","ತವಾ ಪೇತ್ರ ತ್ಯಲಾ “ಸಗ್ಳ ತುಲಾ ಸುಡುನ್ ಗೆಲತರಿ ಮಿ ಸುಡುನ್ ಜಾ಼ನಾರ್ ನಾಹಿ” ಮನ್ಹುನ್ ಸಾಂಗ್ತಾನಾ. ");
INSERT INTO gok_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","ಯೇಸು “ತುಲಾ ಖರ ಸಾಂಗ್ತೋ, ಆಚ್ಚೆ ರಾತಿತ್ ಕೊಂಬ್ಡಾ ದೊನ್ ಖ್ಯಪಾ ಬವಾಚೆ ಆಂದಿ ತು ತೀನ್ ಖ್ಯಪಾ ಮಾಜೆಯಸಿ ತ್ಯೊ ಮನಾ ಠಾವಾ ನಾಹಿ ಮನ್ಹಾರ್” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","ಫನ್ ಮಿ “ತುಜಿ ಸಂಗ ಮರಾಚ಼ ಆಲತರಿ ಠಾವಾ ನಾಹಿ ಮನ್ಹುನ್ ಸಾಂಗ್ನಾರ್ ನಾಹಿ” ಆಸ ಖಾತ್ರಿನಿ ಸಾಂಗಾಯಾ ಲಾಗ್ಲಾ. ತಸಸ್ ಸಗ್ಳ ಮನ್ಹಾಯಾ ಲಾಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","ನಂತರ್ ತೇ ಗೆತ್ಸೆಮನೆ ಬಾಗತ್ ಆಲ. ಯೇಸುನಿ ಆಪ್‌ಲ್ಯಾ ಶಿಶಾನಾ, “ಹಿತ್ತ ಬಸ್ಹಾ, ಮಿ ಮಾಗ್ನ ಕರುನ್ ಯತೋ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","ಪೇತ್ರ, ಯಾಕೊಬ್, ಯೊಹಾನ್, ಹ್ಯನಾ ಆಪ್ಲೆ ಸಂಗ ಗಿಹುನ್ ಜಾ಼ವುನ್ ಮನಾತ್ ದುಖಾನಿ ಬರ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ಆನಿ ತ್ಯನಾ, “ಮಾಜಾ಼ ಜೀವ್ ಮರಾಯಾ ಜಾ಼ಲ್ಯಾ. ತುಮಿ ಹಿತ ರಾಹುನ್ ಜಾ಼ಗ್ರುತ್ ರಾವ್ಹಾ” ಮನ್ಹುನ್ ಸಾಂಗುನ್. ");
INSERT INTO gok_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","ಜ಼ರಾ ಮೋರ್ಹ ಜಾ಼ವುನ್ ಜಿಮ್ನಿವ ಆಡ್ವಾ ಪಡುನ್, “ಶಕ್ಯ ಜಾ಼ಲ್ಹತರ್ ಹ್ಯೊ ತರಾಸಾಚಾ಼ ಯೊಳ್ ಆಪ್‌ಲ್ಯಾಲಾ ಸುಡುನ್ ಜಾ಼ವುನಿ” ಮನ್ಹುನ್ ದೇವಾಪ ಮಾಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","ಮಂಗ್ ಯೇಸು, “ ಮಾಜಾ ಬಾ! ತುಲಾ ಸಗ್ಳ ವ್ಹತ; ಹ್ಯೊ ತರಾಸಾಚಾ಼ ಯೊಳ್ ಮಾಜಿ಼ಪ್ನಿ ದುರ್ ಕರ್. ಫನ್ ಮಾಜಾ ಮನಾಚೆಗತ್ ನಕೊ ತುಜಾ ಮನಾಚೆಗತ್ ವ್ಹವುನಿ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","ಮಂಗ್ ತ್ಯೊ ಯವುನ್ ತೇ ನಿಜ಼್ಲ್ಯಾಲ ಬಗುನ್ ಪೇತ್ರಾಲಾ, ಸಿಮೊನಾ, “ನಿಸ್ತೋಸ್‌ ಕಾ? ಯೆಕ್ ತಾಸ್ಬಿ ಮಾಜಿ ಸಂಗ ಜಾ಼ಗಾ ರಾಹಿತ್ ನಾಹಿಸ್ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","ಯೇಸು ತುಮಿ ಪಾಪಾತ್ ಪಡುನಾಹಿ ಮನ್ಹುನ್ ಹುಶಾರ್ ರಾಹ್ಯಾ ದೇವಾಪ ಮಾಗಾ; ತುಮಚ಼ ಮನ್ ತಯಾರ್ ಹಾ ಫನ್ ಆಂಗಾತ್ ಬಳ್ ನಾಹಿ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","ಯೇಸು ಆನಿಕ್ ದುರ್ ಜಾ಼ವುನ್, ತೆಚ಼್ ಸಬಾತ್ ಮನ್ಹಿತ್ ದೇವಾಪ ಮಾಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","ಆನಿ ಆಲಾ ತವಾ ತೇ ನಿಜ಼್ಲ್ಯಾಲ ದಿಸ್‌ಲ; ತ್ಯಂಚ಼ ಡೊಳ ಖುಬ್ ಜ಼ಡ್ ಜಾ಼ಲ್ಥ; ಆನಿ ತ್ಯನಿ ಇಚಾರ್ಲ್ಯಾಲ್ಯಾಲಾ ಕ್ಯಾ ಸಾಂಗಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ತ್ಯನಾ ಸಮಾಜ಼್ಲ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","ಯೇಸು ತಿನ್‌ವ್ಯಾನಿ ಯವುನ್ ತ್ಯನಾ ಕ್ಯಾ ಸಾಂಗ್ಲ ಮನ್‌ಲ್ಯಾವ, “ತುಮಿ ಆಜು಼ನ್ ನಿಜ಼ಲ್ಯಾಸಾ ಕ್ಯಾ, ಪುರ, ಮಾನ್ಸಾಚಾ ಲೇಕಾಲಾ ಪಾಪಿ ಮಾನ್ಸಾಂಚಾ ಹಾತಾತ್ ದರ‍್ಹುನ್ ದಿಯಾಚಾ಼ ಯೊಳ್ ಆಲಾ ಬಗಾ; ");
INSERT INTO gok_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","ಉಠಾ ಆಮಿ ಜಾ಼ವುಯಾ; ಮನಾ ದರ‍್ಹುನ್ ದೆನಾರಾ ಜ಼ವಳ್ ಆಲ್ಯಾ ಬಗಾ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","ತ್ಯೊ ಬೋಲ್ತಾ ಆಸ್ಥಾನಾಸ್ ಬಾರಾ ಜಾ಼ನ್ ಶಿಶಾತ್ಲಾ ಯಕ್ಲಾ ಮಂಜೆ ಯುದ್ ತಿಥ ಆಲಾ ತ್ಯಚೆ ಸಂಗ ಆನಿ ಮುಖ್ಯ ಯಾಜಕ್, ಕ್ಯಾಯ್ದದಾರ್ ಆನಿ ವಡಿಲ್ ಹ್ಯಂಚಾನಿ ಯೊಕ್ ಲೊಕಾಂಚಾ಼ ಹಿಂಡ್ ಲಾವುನ್ ದಿಲಾ ತೀ ಥಲ್ವಾರ ಆನಿ ಟೊನ ಗಿಹುನ್ ಆಲಿತ. ");
INSERT INTO gok_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","ತ್ಯಲಾ ದರ‍್ಹುನ್ ದೆನಾರ‍್ಯಾನಿ ತ್ಯನಾ, “ಮಿ ಕಚಾಚಾ಼ ಮುಕ್ಕಾ ಗೆಥೊ ತ್ಯೊಸ್ ಯೇಸು ವ್ಹನಾರ್ ತ್ಯಲಾ ದರ‍್ಹಾ ಆನಿ ಹುಶಾರಿನಿ ಬಂದೋ ಬಸ್ಥಾನಿ ಗಿಹುನ್ ಜಾ಼ವಾ” ಆಸಿ ಖುನಾ ಸಾಂಗ್ಲಿ ಹುತ್ತಿ. ");
INSERT INTO gok_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","ತ್ಯೊ ತಿಥ ಆಲ್ಯಾ ಬರ್ಬರ್ ಯೇಸುಪ ಜಾ಼ವುನ್, “ಪ್ರಬು ಮನ್ಹುನ್ ತ್ಯಚಾ಼ ಮುಕ್ಕಾ ಗೆತ್ಲಾ. ” ");
INSERT INTO gok_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","ತವಾ ತ್ಯಂಚಾನಿ ತ್ಯಚಿವ ಹಾತ್ ಗಾಲ್ಹುನ್ ತ್ಯಲಾ ದರ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","ಖರ ಕಡಸ್ ಉಬಾ ರಾಯ್‌ಲ್ಯಾಲ್ಯಾ ಯಕಾನಿ ಆಪ್ಲ ಥಲ್ವಾರ್ ಕಾಡುನ್ ಮುಖ್ಯ ಯಾಜಕಾಚಾ ಆಳಾಲಾ ಮಾರುನ್ ತ್ಯಚಾ಼ ಕಾನ್ ತ್ಯೊಡ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","ತವಾ ಯೇಸು ತ್ಯನಾ, “ಚೊ಼ರಾಲಾ ದರ‍್ಹಾಯಾ ಯತ್ಯಾಚೆಗತ್ ಥಲ್ವಾರ ಟೊನ ಗಿಹುನ್ ಮನಾ ದರ‍್ಹಾಯಾ ಆಲಾಸಾ? ");
INSERT INTO gok_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","ಮಿ ಖಾಯಿಮ್ ತುಮ್ಚೆ ಸಂಗ ರಾಹುನ್ ದೇವ್ಳಾತ್ ಸಿಕ್ವಿತೊ ತವಾ ತುಮಿ ಮನಾ ದರ್ಲ ನಾಹಿಸಾ. ಖರ ಶಾಸ್ತಾರಾತ್ಲಿ ವಚ್ನ ಪುರ್ತಿ ವ್ಹಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಆಸ ಹ್ಯ ಸಗ್ಳ ಗಡ್ಲ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","ತವಾ ತ್ಯಚ಼ ಶಿಶಾ ಸ‌ಗ್ಳ ತ್ಯಲಾ ಸುಡುನ್ ಪಳುನ್ ಗೆಲ. ");
INSERT INTO gok_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","ಯೊಕ್ ದ್ಯಾನ್ಗಾ ಪೋರ್ ಉಗ್‌ಡ್ಯಾ ಆಂಗಾವ ಮಡಿಚ ದೊಥಾರ್ ಗಿಹುನ್ ಯೇಸುಚೆ ಮಾಗ್ನಿ ಮಾನ್ಸಾಂಚೆ ಸಂಗ ಯಯಿತ್ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ತ್ಯಂಚಾನಿ ತ್ಯಲಾ ದರ್ಲಾ ತವಾ ತ್ಯನಿ ತ್ಯ ಮಡಿಚ ದೊಥಾರ್ ಟಾಕುನ್ ಉಗ್ಡಾಸ್ ತಿಥ್ನಿ ಪಳುನ್ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","ಮಂಗ್ ತ್ಯಂಚಾನಿ ಯೇಸುಲಾ ಮಹಾ ಯಾಜಕಾಚಾ ಗರ‍್ಹಾತ್ ನೆಲಾ. ತ್ಯಚಿಪ ಮುಖ್ಯ ಯಾಜಕ್, ವಡಿಲ್, ಕ್ಯಾಯ್ದದಾರ್ ಹೆ ಸಗ್ಳ ಜ಼ಮುನ್ ಆಲ. ");
INSERT INTO gok_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","ಆನಿ ಪೇತ್ರಾ ದುರ್ನಿ ತ್ಯಚೆ ಮಾಗ್ನಿ ಜಾ಼ಯಿತ್ ಮುಖ್ಯ ಯಾಜಕಾಚಾ ಗರ‍್ಹಾಚಾ ಆಂಗ್ನಾತ್ ಆತ್ ಯವುನ್ ರ‍್ಯಾಕ್ನಾರ‍್ಯಾಂಚಿ ಸಂಗ ಆಕ್ಟಿವ ತಾಪತ್ ಬಸ್ಲಾ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","ತವಾ ಮುಖ್ಯ ಯಾಜಕ್ ಆನಿ ಯೆಹುದಿ ನಾಯಕಾಂಚಿ ಮುಟಿ ಸಬಾ ಸಗ್ಳಿ ಯೇಸುಲಾ ಮಾರುನ್ ಟಾಕಾಯಾ ತ್ಯಚೆ ಆಡ್ವಿ ಸಾಕ್ಶಾ ಸೊದಾಯಾ ಲಾಗ್ಲಿ; ಖರ ಕಾಯ್ ಗಾವ್ಲ ನಾಹಿ ");
INSERT INTO gok_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","ಖುಬ್ ಲೊಕ ತ್ಯಚೆ ಆಡ್ವ ಲಬಾಡ್ ಸಾಕ್ಶಾ ಸಾಂಗಾಯಾ ಲಾಗ್ಲಿತ ಖರ ತ್ಯಂಚಾ ಸಾಕ್ಶಾಂಚಾ಼ ಯಕಾಲಾ ಯೆಕ್ ಮೆಳ್ ಬಸ್ಲಾ ನವ್ಥಾ. ");
INSERT INTO gok_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","58","ಮಂಗ್ ಕಾಯ್ ಜಾ಼ನ್ ಉಬರಾಹುನ್, “ಮಾನ್ಸಾಚಾ ಹಾತಾನಿ ಬ್ಯಾಂದ್‌ಲ್ಯಾಲ ಹ್ಯ ದಿವುಳ್ ಮಿ ಪಾಡುನ್ ಮಾನ್ಸಾಚಾ ಹಾತಾನಿ ಬಾಂದಿನಸ್‌ಲ್ಯಾಲ ಆನಿ ಯಾಕ್ ದಿವುಳ್ ತೀನ್ ದಿಸಾತ್ ಬ್ಯಾಂತೊ” ಮನ್ಹುನ್ ಹ್ಯನಿ ಸಾಂಗ್‌ಲ್ಯಾಲ ಆಮಿ ಆಯಿಕ್‌ಲ್ಯಾ ಮನ್ಹುನ್ ತ್ಯಚೆ ಆಡ್ವಿ ಲಬಾಡ್ ಸಾಕ್ಶಿ ಸಾಂಗ್ಲಿ ");
INSERT INTO gok_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","ಆಸ ಸಾಂಗ್ಲ ತರಿ ತ್ಯಂಚಾ ಸಾಕ್ಷಿಂಚಾ ಯಕಾಲಾ ಯೆಕ್ ಮೆಳ್ ಬಸನಾ. ");
INSERT INTO gok_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","ತವಾ ಮುಖ್ಯ ಯಾಜಕ್ ಉಠುನ್ ಸಗ್‌ಳ್ಯಾಂಚೆ ಮದ್ದಿ ಉಬಾರಾಹುನ್ ಯೇಸುಲಾ, “ಹಿ ಲೊಕ ತುಜಿವ ವಾವ್‌ತ್ಯಾಲ್ಯಾ ಹ್ಯಾ ಸಾಕ್ಶಾ ಖರ‍್ಯಾ ಕ್ಯಾ? ಹ್ಯಲಾ ತು ಕಾಯ್ ಉತ್ತರ್ ದಿಯಿತ್ ನಾಹಿಸ್? ಮನ್ಹುನ್ ಯೇಸುಲಾ ಪ್ರಶ್ನೆ ಕೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","ಖರ ಯೇಸು ಗಪ್ ಹುತ್ತಾ ಕಾಯ್ ಉತ್ತರ್ ದಿಲಾ ನಾಹಿ ಪರತ್ ಆನಿ. ಮುಖ್ಯ ಯಾಜಕ್, “ಆರಾದನೆಲಾ ಚಾ಼ಂಗ್ಲ ಜಾ಼ಲ್ಯಾಲ್ಯಾಚಾ಼ ಲ್ಯೊಕ್ ಕ್ರಿಸ್ತ್ ಕ್ಯಾ ತು? ಮನ್ಹುನ್ ತ್ಯಲಾ ಇಚಾರ್ಲ್ಯಾಲ್ಯಾಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","ಯೇಸು, “ಮೀಚ಼್ ವ್ಹಯ್ ಆನಿ ತುಮಿ ಮಾನ್ಸಾಚಾ಼ ಲ್ಯೊಕ್ ಸರ್ವಸಮರ್ತಾಚಾ ಉಜ್‍ವ್ಯಾಂಗ್ನಿ ಬಸ್‌ಲ್ಯಾಲಾ ಆನಿ ಆರ್ಬಾಟಾಚಾ ಡಘಾವ್ನಿ ಯತ್ಯಾಲಾ ಬಕ್ಸಿಲಾ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","ಮುಖ್ಯ ಯಾಜಕ್‍ ಹ್ಯ ಐಕುನ್ ಆಪ್ಲ ಕಪ್ಡ ಫಾಟುನ್, “ಆಮಾನಾ ಆನಿ ದಿಸರ‍್ಯಾ ಸಾಕ್ಶಾ ಕಸ್ಯಾಲಾ ವ್ಹಯಿತಾ? ");
INSERT INTO gok_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","ಹ್ಯ ದೇವಾಚೆ ಆಡ್ವ ಬೊಲ್ಯಾಲ್ಯಾಲ ಬೊಲ್ನ ಆಯಿಕ್ಲಸಾ ನವ್ಹ; ತುಮಾನಾ ಕಸ ವಾಟ ಮನ್ಲಾ, ತವಾ ತ್ಯಾ ಸಗ್‌ಳ್ಯಾಂಚಾನಿ. “ಹ್ಯಲಾ ಮಾರುನುಸ್ ಟಾಕಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ತಿರ್ಮಾನ್ ಕೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","ತ್ಯಾ ನಂತರ್ ಕಾಯ್ ಥೊಡಿ ಜ಼ನ ತ್ಯಚಿವ ಥುಕುನ್ ತ್ಯಚ಼ ತ್ವಾಂಡ್ ಕಪ್‌ಡ್ಯಾನಿ ಬಾಂದುನ್ ತ್ಯಲಾ ಮಾರುನ್. “ಆತಾ ತುಲಾ ಕುನಿ ಮ್ಯಾರ್ಲತ್ಯ ಸಾಂಗ್” ಮನ್ಹಿತಿತ ಆನಿ ರ‍್ಯಾಖ್ನಾರ‍್ಯಾಂಚಾನಿ ತ್ಯಚಾ ಕಾನ್ಫಾಡಾವ ಮಾರುನ್ ಆಪ್‌ಲ್ಯಾ ತಾಬ್ಯಾತ್ ಗೆತ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","ಹಿಕ್ಡ ಪೇತ್ರಾ ಖಾಲ್ ಆಂಗ್ನಾತ್ ಆಸ್ಥಾನಾ ಮುಖ್ಯ ಯಾಜಕಾಚಾ ಕಾಮ್ಯಾರ‍್ಯಾತ್ಲೆ ಯಕಿನಿ ಯವುನ್ ತ್ಯೊ ತಾಪತ್ ಬಸ್‌ಲ್ಯಾಲಾ ಬಗ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ಆನಿ ಪೇತ್ರಾಲಾ, “ತು ದಿಖಿಲ್ ತ್ಯಾ ನಜ಼ರೆತಿಚಾ ಯೇಸು ಸಂಗ ಆಸ್‌ಲ್ಯಾಲಾ” ಮನ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","ತ್ಯೊ “ನವ್ಹ; ತು ಕ್ಯಾ ಮನ್ಥಿಸ್ ತ್ಯೊ ಮನಾ ಠ್ಹಾವನಾಹಿ, ಮನ್ಹುನ್ ಸಾಂಗುನ್ ಆಂಗ್ನಾತ್ನಿ ಬಾಹಿರ್ ಗೆಲಾ ತವಾ ಕೊಂಬ್ಡಾ ಬವ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","ತಿಥ ತಿನಿ ಆನಿಕ್ ತ್ಯಲಾ ಬಗುನ್ ಕಡಸ್ ಉಬಿರಾಯ್‌ಲ್ಯಾಲ್ಯಾನಾ, “ಹ್ಯೊ ತ್ಯಂಚಾಂತ್ಲಾಸ್ ಯೊಕ್” ಮನ್ಹುನ್ ಪರತ್ ಆನಿ ಸಾಂಗಾಯಾ ಲಾಗ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","ತ್ಯೊ ಆನಿಕ್ ನವ್ಹಸ್ ಮನ್ಲಾ. ಥೊಡಾ ಯೊಳ್ ಜಾ಼ಲ್ಯಾ ನಂತರ್ ತಿಥ ಉಬಾ ರಾಯ್‌ಲ್ಯಾಲ್ಯಾ ಪೇತ್ರಾಲಾ, “ಖರ‍್ಯಾನಿಸ್ ತು ತ್ಯಂಚಾತ್ಲಾ ಯೊಕ್; ತು ಗಲಿಲಾಯಾತ್ಲಾಸ್” ಮನ್ಹುನ್ ಆನಿಕ್ ಮನ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","ಖರ “ತುಮಿ ಸಾಂಗ್‌ತ್ಯಾಲಾ ತ್ಯೊ ಮಾನುಸ್ ಮನಾ ಕೊನ್ ತ್ಯೊ ಠಾವಾ ನಾಹಿ ಮನ್ಹುನ್ ಸಾಂಗುನ್ ಆಪ್‌ಲ್ಯಾಲಾ ಆಪ್ನುಸ್ ಸರ್ಪುನ್ ಶಪ್ತಿ” ಗಾಲ್ಹುನ್ ಗಿಯಾ ಲಾಗ್ಲಾ ತವಾಸ್ ಕೊಂಬ್ಡಾ ದೊನ್ವೆ ಖೆಪಾ ಬವಾಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","ತವಾ ಪೇತ್ರಾ “ಕೊಂಬ್ಡಾ ದೊನ್ ಖೆಪಾ ಬವಾಚೆ ಆಂದಿ ತೀನ್ ಖೆಪಾ ಮಾಜೆ ಗುಶ್ಟಿತ್ ಮನಾ ತ್ಯಚಿ ವಳಕ್ ನಾಹಿ ಮನ್ಹುನ್ ಸಾಂಗ್ನಾರ್” ಆಸ ಯೇಸುನಿ ಆಪ್‌ಲ್ಯಾಲಾ ಸಾಂಗ್‌ಲ್ಯಾಲ ಸಬಾತ್ ಯವಜು಼ನ್ ತ್ಯಚಿಸಾಟಿ ಖುಬ್ ರಡ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","ಉಜಾ಼ಡಲ್ಯಾ ಬರ್ಬರ್ ಮುಖ್ಯ ಯಾಜಕ್, ವಡಿಲ್ ಆನಿ ಕ್ಯಾಯ್ದದಾರ್, ಮುಟಿ ಸಬಾ ಸಗ್ಳಿ ಜ಼ಮುನ್ ಮಸ್ಲತ್ ಕರುನ್ ಯೇಸುಲಾ ಬಾಂದುನ್ ನಿಹುನ್ ಪಿಲಾತಾಚಾ ತಾಬ್ಯಾತ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","ಪಿಲಾತಾನಿ ತ್ಯಲಾ “ತು ಯೆಹುದ್ಯಾಂಚಾ ರಾಜಾ಼ ಕ್ಯಾ? ತ್ಯಲಾ. ಯೇಸುನಿ “ತುಸ್ ಸಾಂಗ್‌ತ್ಯೋಸ್” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","4","ಮುಖ್ಯ ಯಾಜಕ್ ತ್ಯಚಾ ಖುಬ್ ಚು಼ಕಿ ಸಾಂಗಿತ ತವಾ ಪಿಲಾತಾನಿ ಆನಿ ಯಂಗ್ದಾ ಯೇಸುಲಾ, “ತು ಕಾಯ್ ಸಾಂಗಿತ್ ನಾಹಿಸ್? ಹೆ ತುಜೆ ಆಡ್ವ ಸಾಂಗ್‌ತ್ಯಾತ” ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","ಫನ್ ಯೇಸು ಗಪ್ ಹುತ್ತಾ. ತ್ಯ ಬಗುನ್ ಪಿಲಾತ್ ಆಜಾಬ್ ಜಾ಼ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","ಪಿಲಾತಾನಿ ಪರ್ತೆಕ್ ವರ್ಶಿ ಪಸ್ಕಾಚಾ ಸನಾತ್ ಲೊಕಾಂಚಾನಿ ಮಾಗ್‌ಲ್ಯಾಲ್ಯಾ ಖೈದಿಲಾ ತ್ಯನಾ ಸುಡುನ್ ದಿಯಾಚಾ಼ ಸಿರಿಸ್ತಾ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","ತವಾ ಬರಬ್ ಮಂಥ್ಯಾಲಾ ಯೊಕ್ ಮಾನುಸ್ ಹುತ್ತಾ ಹ್ಯಲಾ ದಂಗ್ಯಾತ್ ಖುನ್ ಕೆಲ್ಯಾಲ್ಯಾ ಕಳ್‌ಚೊ಼ಟ್ಯಾಂಚಿ಼ ಸಂಗ ಕುಂಡುನ್ ಗ್ಯಾತ್ಲಾ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","ಲೊಕ ಪಿಲಾತಾಪ ಜಾ಼ವುನ್ “ತು ಆಮಾನಾ ಕರೀತ್ ಆಲ್ಯಾಲಾ ಸಿರಿಸ್ತಾ ಕರ್” ಮನ್ಹುನ್ ಮನ್ಹಿತಿತ. ");
INSERT INTO gok_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","ಮುಖ್ಯ ಯಾಜಕಾಂಚಾನಿ ಖೊಟ್ಯಾಫನಾನಿ ಯೇಸುಲಾ ದರ‍್ಹುನ್ ದಿಲ್ಯಾ ಮನ್ಹುನ್ ಸಮಜು಼ನ್ “ಮಿ ಯಹುದ್ ರಾಜಾಲಾ ತುಮಾನಾ ಸುಡುನ್ ದಿಯಾ ವ್ಹಯಿ ಮಂಥಾಸಾ ಕ್ಯಾ” ಮನ್ಹುನ್ ತ್ಯನಾ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","ತಿಕ್ಡ ಮುಖ್ಯ ಯಾಜಕ್. “ಬರಬ್ಬಾಲಾಸ್ ಸುಡುನ್ ದಿಯಾ ವ್ಹಯಿ” ಮನ್ಹುನ್ ಮನಾ ಸಾಂಗಿತ. ");
INSERT INTO gok_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","ಮನ್ಹುನ್ ಪಿಲಾತಾನಿ ಆನಿಕ್ ತ್ಯನಾ “ತಸ ಜಾ಼ಲ್ಯಾ ತುಮಿ ಸಾಂಗ್‌ತ್ಯಾಲ್ಯಾ ಯಹುದ್ ರಾಜಾಲಾ ಮಿ ಕ್ಯಾ ಕರು” ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","ತ್ಯಂಚಾನಿ ತ್ಯಲಾ ಶಿಲ್ಬೆಚಾ ಖಾಂಬಾವ ಟ್ಯಾಂಗ್” ಮನ್ಹುನ್ ಆನಿಕ್ ಜೊ಼ರಾನಿ ವರಾಡ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","ಪಿಲಾತಾನಿ “ಕಾ? ಕ್ಯಾ ವಾಯಿಟ್ ಕೆಲ್ಯಾ? ಮನ್ಲಾ. ಫನ್ ತ್ಯಾ ಲೊಕಾಂಚಾನಿ “ತ್ಯಲಾ ಶಿಲುಬೆವ ಟ್ಯಾಂಗ್” ಮನ್ಹುನ್ ಜೊ಼ರಾನಿ ಆರ್ಬಾಟ್ ಕೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","ಮನ್ಹುನ್ ಪಿಲಾತಾನಿ ಲೊಕಾಂಚ಼ ಮನ್ ಥಂಡ್ ಕರಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ತ್ಯನಾ ಬರಬ್ಬಾಲಾ ಸುಡುನ್ ದಿಲಾ ಯೇಸುಲಾ ಕಾಠಿನಿ ಮಾರುನ್ ಶಿಲ್ಬೆವ ಟಾಂಗಾಯಾ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","ಮಂಗ್ ಸಿಪಾಯಿಂಚಾನಿ ತ್ಯಲಾ ರಾಜ ಪಾಲನ್ ಕರ್ತ್ಯಾಲ್ಯಾ ಅಧಿಪತಿಚಾ ಗರ‍್ಹಾಚಾ ಆಂಗ್ನಾತ್ ಆತ್ ನೆಲಾ ಆನಿ ರಾಯ್‌ಲ್ಯಾಲ್ಯಾ ಸಿಪಾಯಿನಾ ಹಾಕಟ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","ಆನಿ ತ್ಯಂಚಾನಿ ಯೇಸುಲಾ ತಾಂಬ್ಡಾ ರಾಜಾಚಾ ಕಪ್ಡಾ ಗಾಲ್ಹುನ್ ಕಾಟ್ಯಾಂಚಿ಼ ಟುಪಿ ಕರುನ್ ತ್ಯಚೆ ಡುಯಿವ ಗಾಲ್ಹುನ್, ");
INSERT INTO gok_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","“ಯಹುದಾಚಾ ರಾಜಾ, ತುಲಾ ನಮಸ್ಕಾರ್” ಆಸ ಮನ್ಹಿತ್ ");
INSERT INTO gok_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","ಬೆತ್ತಾಚೆ ಕಾಠಿನಿ ತ್ಯಚೆ ಡುಯಿವ ಮಾರುನ್ ತ್ಯಚಿವ ಥುಕುನ್ ತ್ಯಚೆ ಮೊರ‍್ಹ ನಡ್ಗ ಟಿಕ್ವುನ್ ಆಡ್ವ ಪಡ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","ಆಸಿ ತ್ಯಚಿ ಟಿಂಗಲ್ನಾ ಕರುನ್ ಜಾ಼ಲ್ಯಾವ ತ್ಯಚಾ಼ ತಾಂಬ್ಡಾ ಜ಼ಘಾ ಕಾಡುನ್ ತ್ಯಚ಼ ಪೈಲ ಕಪ್ಡ ಗಾಲ್ಹುನ್ ತ್ಯಲಾ ಶಿಲ್ಬೆವ ಟಾಂಗಾಯಾ ಗಿಹುನ್ ಗೆಲ. ");
INSERT INTO gok_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","ತವಾ ಸಿಮೊನ್ ನಾವಾಚಾ಼ ಕುರೆನ್ ಪೆಠತ್ಲಾ ಆಲೆಕ್ಸಾಂಡರ್ ಮಂಥ್ಯಾಲ್ಯಾಂಚಾ಼ ಬಾ ಸೆತಾತ್ನಿ ತೆ ವಾಟನಿ ಯತ್ಯಾಲಾ ಆಸ್ಥಾನಾ ಯೇಸುಚಿ ಶಿಲ್ಬೆ ತ್ಯಲಾ ಸೈನಿಕಾಂಚಾನಿ ಜು಼ಲ್ಮಿನಿ ಗಿಹ್ಯಾ ಲ್ಯಾವ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","ಮಂಗ್ ತ್ಯಲಾ ಗೊಲ್ಗತಾ ಮಂಥ್ಯಾಲ್ಯಾ ಜಾ಼ಗ್ಯಾವ ಗಿಹುನ್ ಆಲ ಗೊಲ್ಗತಾ ಮಂಜೆ ಡುಯಿಚೆಗತ್ ಆಸ್‌ಲ್ಯಾಲಾ ಜಾ಼ಗಾ. ");
INSERT INTO gok_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","ತಿಥ ತ್ಯಲಾ ರಗಾತ್ ಬೊಳ್ ಮಿಸಳ್ಯಾಲಾ ದರಾಕ್ಶಿಚಾ಼ ರಸ್ ಪಿಯಾ ದಿಲಾ, ಫನ್ ಯೇಸುನಿ ತ್ಯೊ ರಸ್ ಗೆತ್ಲಾ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","ತ್ಯಂಚಾನಿ ತ್ಯಲಾ ಶಿಲುಬೆಚಾ ಖಾಂಬಾವ ಗಾಲ್ಹುನ್ ತ್ಯಚ಼ ಕಪ್ಡ ಕಚ಼ ಕಚ಼ ಕುನಾ ಕುನಾಲಾ ವ್ಹಯಿತ ಮನ್ಹುನ್ ಚಿಟ್ಯಾ ಗಾಲ್ಹುನ್ ವಾಟುನ್ ಗೆತ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","ತ್ಯಲಾ ಶಿಲುಬೆವ ಟ್ಯಾಂಗ್ತಾನಾ ಸಕಾಳಚ಼ ನವೂ ಗಂಠ ಜಾ಼ಲ್ಥ ");
INSERT INTO gok_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","ಆನಿ ತ್ಯಂಚಾನಿ ತ್ಯಚಿವ ವಾವ್‌ಲ್ಯಾಲಾ ಆಪ್ರಾದ್ ಲಿವುನ್ ಶಿಲ್ಬೆಚಾ ಖಾಂಬಾಲಾ ಲ್ಯಾವ್ಲಾ ಹುತ್ತಾ ತ್ಯೊ ಕ್ಯಾ ಮನ್‌ಲ್ಯಾವ, ಯಹುದಾಚಾ಼ ರಾಜಾ಼ ಮನ್ಹುನ್ ");
INSERT INTO gok_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","ಆನಿ ದೊಗಾ ಚೊ಼ರಾನಾ ಆನುನ್ ತ್ಯಚೆ ಸಂಗ ಯಕಾಲಾ ತ್ಯಚೆ ಉಜ಼ವ್ಯಾಂಗ್ನಿ ಆನಿ ಯಕಾಲಾ ಡಾವ್ಯಾಂಗ್ನಿ ಶಿಲ್ಬೆಚಾ ಖಾಂಬಾವ್ನಿ ಟ್ಯಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","ತ್ಯೊ ಚೊ಼ರಾಂಚಾ ಇಸಾಬಾತ್ ಆಲಾ ಆಸ ಶಾಸ್ತಾರಾತ್ ಲಿವ್‌ಲ್ಯಾ ಶಾರ್ಕ ಜಾ಼ಲ. ");
INSERT INTO gok_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","ಮಂಗ್ ತಿಥ್ನಿ ಯತ್ಯಾ ಜಾ಼ತ್ಯಾಲಿ ಮಾನ್ ಡುಲ್ವಿತ್ ಆರ ದಿವುಳ್ ಮುಡುನ್ ತೀನ್ ದಿಸಾ ನಂತರ್ ಬ್ಯಾದ್ನಾರ‍್ಯಾ ");
INSERT INTO gok_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","ಶಿಲ್ಬೆಚಾ ಖಾಂಬಾವ್ನಿ ಉತ್ರುನ್ ತುಜಾ಼ ಜೀವ್ ಉರುವುನ್ ಘೇ ಮನ್ಹುನ್ ತ್ಯಚಿ ಟಿಂಗಲ್ನಾ ಕರಿತಿತ. ");
INSERT INTO gok_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","ತಸಸ್ ಮುಖ್ಯ ಯಾಜಕ್ ಆನಿ ಕ್ಯಾಯ್ದದಾರ್ ಸಾಹಿತ್, “ತ್ಯನಿ ಆನಿ ಯಕಾಲಾ ಜ಼ಗಿವ್ಲಾ; ಆಪ್ಲಾ ಜೀವ್ ಉರುವುನ್ ಗಿಹಿತ್ ನಾಹಿ” ಆಸ ಮನ್ಹಿತ ");
INSERT INTO gok_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","ಇಸ್ರಾಯಲಾಂಚಾ಼ ರಾಜಾ಼ ಜಾ಼ಲ್ಯಾಲಾ ಹ್ಯೊ ಕ್ರಿಸ್ತ್ ಆತಾ ಶಿಲ್ಬೆಚಾ ಖಾಂಬಾವ್ನಿ ಉತ್ರುನ್ ಯವುನಿ: ತ್ಯ ಬಗುನ್ ಆಮಿ ಇಸ್ವಾಸ್ ಥೆವ್ತಾವ್ ಆಸ ಆಪ್‌ಲ್ಯಾ ಆಪ್‌ಲ್ಯಾತ್ ಮಸ್ಕರಿನಿ ಬೊಲತ ಆನಿ ಯೇಸುಚೆ ಸಂಗ ಶಿಲುಬೆವ ಟ್ಯಾಂಗ್‌ಲ್ಯಾಲ ಸಾಹಿತ್ ತ್ಯಚಿ ನಿಂದಾ ಕರಾಯಾ ಲಾಗಲ. ");
INSERT INTO gok_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","ದೊಪಾರಾ ಬಾರಾ ಗಂಠ ಜಾ಼ಲ ತವಾ ದುನೆಬ ಆಂದಾರ್ಗುಪ್ ವ್ಹವುನ್ ತೀನ್ ಗಂಠ್ಯಾ ಪರ‍್ಯಾತ್ ಹುತ್ತಾ ");
INSERT INTO gok_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","ತೀನ್ ಗಂಠ್ಯಾಲಾ ಯೇಸು “ಏಲೋಹಿ, ಏಲೋಹಿ, ಲಮಾ” ಸಬಕ್ತಾನೀ ಮಂಜೆ “ಮಾಜಾ ದೇವಾ, ಮಾಜಾ ದೇವಾ, ಕಾ ಮನಾ ಹಾತ್ ಶೋಡ್ಲಾಸ್” ಮನ್ಹುನ್ ಮೊಟ್ಯಾನಿ ವರಾಡ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","ಕಡಸ್ ಉಬಿ ರಾಯ್‌ಲ್ಯಾಲ್ಯಾತ್‌ಲ್ಯಾ ಥೊಡ್ಯಾ ಜ಼ನಾಂಚಾನಿ ತ್ಯ ಐಕುನ್ “ಬಗಾ ಯಲಿಯಾಲಾ ಹಾಕಟ್ಯೋ” ಮನ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","ತವಾ ಯಕ್ಲಾ ಪಳತ್ ಜಾ಼ವುನ್ ಕಾಪುಸ್ ಆಂಬ್‌ಲ್ಯಾಲ್ಯಾ ರಸಾತ್ ಬುಡುವುನ್ ಕಾಠಿತ್ ಆಡ್‌ಕ್ಯಾವುನ್ ತ್ಯಲಾ ಪಿಯಾ ದಿವುನ್, “ಸೊಡಾ ಯಲಿಯಾ ಹ್ಯಲಾ ಶಿಲ್ಬೆಚಾ ಖಾಂಬಾವ್ನಿ ಉತ್ರಾಯಾ ಯಯಿಲ್ ಬಗುಯಾ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","ಖರ ಯೇಸುನಿ ಮೊಟ್ಯಾನಿ ವರ್ಡುನ್ ಜೀವ್ ಶೊಡ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","ತವಾ ದೇವ್ಳಾಚಾ ಪವಿತ್ರ ಜಾ಼ಗ್ಯಾವ್ಲಾ ಪಡ್ದಾ ವೈನಿ ದರ್ನಿ ಖಾಲ್ ಪರ‍್ಯಾತ್ ಫಾಟುನ್ ದೊನ್ ಭಾಗ್ ಜಾ಼ಲ. ");
INSERT INTO gok_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","ಯೇಸುನಿ ಆಸಾ ಜೀವ್ ಶೋಡ್‌ಲ್ಯಾಲಾ ತ್ಯಚೆ ಮೋರ್ಹ ಉಬಾ ರಾಯ್‌ಲ್ಯಾಲ್ಯಾ ಶತಾದಿಪತಿನಿ ಬಗುನ್, “ಹ್ಯೊ ಮಾನುಸ್ ಖರ‍್ಯಾನಿಸ್ ದೇವಾಚಾ಼ ಲ್ಯೊಕ್ ಹುತ್ತಾ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","ಆನಿ ಥುಡಿ ಬ್ಯಾಯ್ಕಾಮಾನ್ಸ ಸಾಹಿತ್ ದುರ್ನಿ ಬಗಿತಿತ; ತ್ಯಾತ್ ತ್ಯೊ ಗಲಿಲಾಯಾತ್ ಆಸ್ಥಾನಾ ತ್ಯಚೆ ಮಾಗ್ನಿ ಯವುನ್ ಸೇವಾ ಕರ್ತ್ಯಾಲ್ಯಾ ಮಗ್ದಲಾಚಿ ಮರಿಯಾ, ಬ್ಯಾರ್ಕಾ ಯಾಕೊಬ್ ಆನಿ ಯೊಸೆಪಾಚಿ ಆಯಿ ಜಾ಼ಲ್ಯಾಲಿ ಮರಿಯಾ, ಸಲೋಮೆ ಮಂಥ್ಯಾಲಿ, ಆನಿ ತ್ಯಚೆ ಸಂಗ ಯೆರುಸಲೆಮಿತ್ ಆಲ್ಯಾಲ್ಯಾ ಕಿತಿಕಿ ದುಸ್ರಿ ಬ್ಯಾಯ್ಕಾ ಮಾನ್ಸ ಹುತ್ತಿತ. ");
INSERT INTO gok_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","ತವಾ ಶಾಂಜ಼್ ಜಾ಼ಲಿ ಹುತ್ತಿ; ಆನಿ ತ್ಯೊ ದಿಸ್ ತಯಾರಿಚಾ಼ ದಿಸ್. (ಮಂಜೆ ಸಭತ್ ದಿಸಾಚೆ ಆದ್ಲಾ ದಿಸ್ ಜಾ಼ಲ್ಥಾ) ");
INSERT INTO gok_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ತವಾ ಅರಿಮತ್ತಾಯಾಚಾ಼ ಯೊಸೆಪ್ ಮಂಥ್ಯಾಲಾ ಯವುನ್ ಪಿಲಾತಾಪ ಜಾ಼ವುನ್ ದಿರ‍್ಹಾನಿ ಯೇಸುಚ ಮಡ ಆಪ್‌ಲ್ಯಾಲಾ ದಿಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಮಾಗ್ಲ ಹ್ಯೊ ನ್ಯಾಯ ಮಂಡಳಿಚಾ಼ ಯೊಕ್ ಮರೆದಿಚಾ಼ ಜಾಂತಾ. ಸ್ವತಾ ಆಪ್ನು ದೇವಾಚಾ ರಾಜಾಚಿ ವಾಟ್ ಬಗ್‌ತ್ಯಾಲಾ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","ಯೇಸು ಇತ್ಕೆ ಬಿಗಿ ಮೆಲಾ ಮನ್ಹುನ್ ಪಿಲಾತಾಲಾ ಚಮತ್ಕಾರ್ ವಾಟ್ಲಿ ಆನಿ ತ್ಯನಿ ಶತಾದಿಪತಿಲಾ ಹಾಕ್ಟುನ್ ತ್ಯೊ ತವಾಸ್ ಮೆಲಾ ಕ್ಯಾ ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","ಯೇಸು ಮೆಲ್ಯಾಲಾ ಶತಾದಿಪತಿಪ್ನಿ ಐಕುನ್ ಮಡ ಯೊಸೆಪಾಲಾ ದಿಯಾ ಲ್ಯಾವ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","ಯೊಸೆಪಾನಿ ಖುಬ್ ಕಿಮ್ತಿಚ಼ ಕಪಾನ್ ಇಕತ್ ಆನುನ್ ಯೇಸುಲಾ ಶಿಲ್ಬೆವ್ನಿ ಖಾಲ್ ಉತ್ರುನ್ ಖುಬ್ ಕಿಮ್ತಿಚ಼ ಕಪಾನ್ ಆನುನ್ ತ್ಯಾತ್ ಬಾಂದುನ್ ದೋಂಡ್ಯಾನಿ ಕೆಲ್ಯಾಲೆ ಗಬ್ಹಿತ್ ಥೆವ್ಲಾ ಆನಿ ಗಭಿಚಾ ತೊಂಡಾವ ದೊಂಢಾ ಖಿಚು಼ನ್ ಬಸ್ಹಿವ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","ಮಗ್ದಲಾಚಿ ಮರಿಯಾ ಆನಿ ಯೊಸೆಚಿ ಆಯಿ ಮರಿಯಾನಿ ಯೇಸಚ಼ ಮಡ ಥೆವ್‌ತ್ಯಾಲಾ ಜಾ಼ಗಾ ಬಗ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","ಸಬ್ಬತ್ ದಿಸ್ ಜಾ಼ಲ್ಯಾ ನಂತರ್. ಮಗ್ದಲಾಚಿ ಮರಿಯಾ, ಯಾಕೊಬಾಚಿ ಆಯಿ ಮರಿಯಾ ಆನಿ ಸಲೊಮಿ, ಹ್ಯಂಚಾನಿ ಯೇಸುಚಾ ಮಡ್ಯಾಲಾ ಲಾವಾಯಾಸಾಟಿ ವಾಸಾಚ಼ ತ್ಯಾಲ್ ಇಕತ್ ಗೆತ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","ಆನಿ ವಾರಾಚಾ ಪೈಲ್ಯಾ ದಿಸಾ ದಿಸಿ ಸಕಾಳ್ಚಾ ದಿಸ್ ಉಗಾವಲ್ಯಾವ ನಸ್ಕಾತ್ ಯೇಸುಚೆ ಮಸುರ್ಡಿಪ ಆಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","4","ತವಾ ಮಸುರ್ಡಿಚಾ ತೊಂಡಾವ ಜಾಕ್‌ಲ್ಯಾಲಾ ದೊಂಢಾ ಖುಬ್ ಮೊಟಾ ಹುತ್ತಾ ಮನ್ಹುನ್, “ಹ್ಯೊ ದೊಂಢಾ ಹಿತ್ನಿ ಕಾಡಾಯಾ ಆಮ್ಚಿಸಾಟಿ ಕೊನ್ ಹಾ” ಮನ್ಹುನ್ ತ್ಯಾ ಆಪ್‌ಲ್ಯಾ ಆಪ್‌ಲ್ಯಾತ್ ಬೊಲತ್ಯಾ, ತವಾ ಡುಯಿ ವರ್ ಕರುನ್ ಬಗ್ತಾನಾ ತ್ಯೊ ದೊಂಢಾ ಕಡವ ಶಾರ್ಲ್ಯಾಲಾ ದಿಸ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","ತ್ಯಾ ಮಸುರ್ಡಿಪ ಗೆಲ್ಯಾ ತವಾ ಯೊಕ್ ದ್ಯಾನ್ಗಾ ಮಾನುಸ್ ಪಾಂಡ್ರಾ ಜ಼ಘಾ ಗಾಲ್ಹುನ್ ಉಜ್ವೆ಼ ಬಾಜು಼ಕ್ಡ ಬಸ್‌ಲ್ಯಾಲಾ ಬಗುನ್ ತ್ಯಾ ಗಾಭಾರ್ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","ತ್ಯೊ ತ್ಯನಾ “ಗಾಭ್ರು ನಕೊಸಾ. ಶಿಲುಬೆಚಾ ಖಾಂಬಾವ ಟ್ಯಾಂಗ್‌ಲ್ಯಾಲ್ಯಾ ನಜ಼ರೆತಿಚಾ ಯೇಸುಲಾ ಶೋತ್ಯಾಸಾ ನವ್ಹ. ತ್ಯೊ ಹಿತ್ಹ ನಾಹಿ, ಜಿ಼ತ್ತಾ ವ್ಹವುನ್ ಉಟ್‌ಲ್ಯಾ; ತ್ಯಲಾ ಥೆವ್‌ಲ್ಯಾಲಾ ಜಾ಼ಗಾ ಹ್ಯೋಚ಼್ ಬಗಾ. ");
INSERT INTO gok_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","ಖರ ತುಮಿ ಜಾ಼ವುನ್ ತ್ಯಚಾ ಶಿಶಾನಾ ಪೇತ್ರಾಲಾಬಿ, “ಯೇಸುನಿ ತುಮಾನಾ ಸಾಂಗ್‌ಲ್ಯಾ ಶಾರ್ಕ ತ್ಯೊ ತುಮ್ಚೆ ಮೋರ್ಹ ಗಲಿಲಾಯಾತ್ ಜಾ಼ನಾರ್. ತಿಥ ತ್ಯಲಾ ಬಗ್ಸಿಲಾ ಆಸ ಸಾಂಗಾ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","ತ್ಯಾ ಬಿಹುನ್ ಗಾಬ್ರುನ್ ಮಸುರ್ಡಿಪ್ನಿ ಬಾಹಿರ್ ಪಳುನ್ ಗೆಲ್ಯಾ; ತ್ಯಾ ಖುಬ್ ಬಿಹ್ಯಾಲ್ಯಾ ಹುತ್ಯಾ ಮನ್ಹುನ್ ಕುನಾಲಾ ಖರ ಸಾಂಗ್ಲ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","ವಾರಾಚಾ಼ ಪೈಲಾ ದಿಸ್ ಐತ್ವಾರಾದಿಸಿ ಯೇಸು ಜಿ಼ತ್ತಾ ವ್ಹವುನ್ ಉಟ್‌ಲ್ಯಾ ನಂತರ್ ಸಕಾಳಚಾ಼ ಮಗ್ದಲಾಚೆ ಮರಿಯಾಲಾ. ಪೈಲ್ಯಾನಿ ದಿಸ್‌ಲಾ. ತಿಲಾ ಸಾತ್ ಲಾಗಿರ ದರ್‌ಲ್ಯಾಲಿ ಸುಡಿವ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","ತ್ಯೊ ದಿಸಲ್ಯಾಲಾ ತಿನಿ ಜಾ಼ವುನ್ ಆಂದಿ ತ್ಯಚೆ ಸಂಗ ಹುತ ತ್ಯನಾ ಕಳಿವ್ಲ. ಹೆ ಖುಬ್ ಕ್ಯಾಳ್ಜಿ ಕರೀತ್ ರಡತ್ ಬಸ್ಲ ಹುತ್ತ. ");
INSERT INTO gok_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","ತ್ಯೊ ಜಿ಼ತ್ತಾ ಹಾ ಮನಾ ದಿಸ್ಲಾ ಮನ್‌ಲ್ಯಾಲ ಐಕ್ಲ ತವಾ ತ್ಯಂಚಾನಿ ಖರ ದರ್ಲ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","ತ್ಯಾ ನಂತರ್ ಶಿಯಾತ್ಲ ದೊಗ ಯಕಾ ಗಾವಾತ್ ವಾಟನಿ ಚಾ಼ಲತ್ ಜಾ಼ಯಿತ್ ಆಸ್ಥಾನಾ ತ್ಯೊ ತ್ಯನಾ ದುಸ್‌ರ‍್ಯಾ ಆವ್ತಾರಾನಿ ದಿಸ್‌ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","ತ್ಯಂಚಾನಿ ಜಾ಼ವುನ್ ರಾಯ್‌ಲ್ಯಾಲ್ಯಾನಾ ಕಳಿವ್ಲ ತವಾ ತ್ಯಂಚಾನಿಬಿ ಖರ ದರ್ಲ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","ಮಂಗ್ ಆಕ್ರಾಜಾ಼ನ್ ಶಿಶಾ ಜೆವ್ನಾಲಾ ಬಸ್‌ಲ ತವಾ ತ್ಯೊ ತ್ಯನಾಬಿ ದಿಸ್ಲಾ. ಆಪ್ನು ಜಿ಼ತ್ತಾ ವ್ಹವುನ್ ಉಠುನ್ ಆಲ್ಯಾ ನಂತರ್ ಆಪ್‌ಲ್ಯಾಲಾ ಬಗ್‌ಲ್ಯಾಲ್ಯಾಂಚಾ ಸಬ್ದಾಂಚಿವ ಇಸ್ವಾಸ್ ಥೆವ್ಲಾ ನಾಹಿ ಮನ್ಹುನ್ ತ್ಯನಿ ತ್ಯಂಚಾ ಅವಿಸ್ವಾಸಾಲಾ ಆನಿ ಕಠಿನ್ ಮನಾಲಾ ದಪ್‌ಕ್ಯಾವ್ಲ. ");
INSERT INTO gok_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","ಮಂಗ್ ತ್ಯನಾ ಯೇಸುನಿ “ಸರ್ವೆ ಜ಼ಗತಿತ್ ಜಾ಼ವುನ್ ಸರ್ವೆ ಜ಼ಗತಿಲಾ ಸುವಾರ್ತಾ ಸಾಂಗಾ. ");
INSERT INTO gok_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","ಇಸ್ವಾಸ್ ಥಿವುನ್ ಕೊನ್ ಬಾಪ್ತಿಸ್ಮಾ ಗಿಹಿಲ್ ತ್ಯಚ಼ ರಕ್ಶನ್ ವ್ಹಯಿಲ್; ಆನಿ ಕೊನ್ ಇಸ್ವಾಸ್ ಥಿವಿತ್ ನಾಹಿ ತ್ಯಲಾ ಮುಟಿ ಶಿಕ್ಶೆ ವ್ಹನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","ಆನಿ ಇಸ್ವಾಸ್ ಥೆವ್‌ಲ್ಯಾಲ್ಯಾಂಚಿಪ್ನಿ ಹಿ ಕಾಮ ವ್ಹತಿಲ, ತೇ ಮಾಜಾ ನಾವಾನಿ ಲಾಗಿರ ಸುಡಿವ್ನಾರ್; ನವ್ಯಾ ನವ್ಯಾ ಬಾಶಾ ಬೊಲ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ಸಾಪ್ ಉಚ಼ಲ್ನಾರ್. ಕಾಯ್ತರಿ ಇಸಾಚಾ ಜಿ಼ನೊಸ್ ಪಿಯಾಲ ತರಿ ಕಾಯ್ ನಾಸ್ ವ್ಹನಾರ್ ನಾಹಿ. ತ್ಯಂಚಾನಿ ರೋಗಿವ ಹಾತ್ ಥೆವ್‌ಲ್ಯಾವ ರೊಗಿಲಾ ಬರ ವ್ಹನಾರ್” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","ಯೇಸು ಪ್ರಭು ತ್ಯಂಚಿ ಸಂಗ ಬೋಲ್ಯಾ ನಂತರ್ ವರ್ ಸ್ವರ್ಗಾತ್ ಉಚ಼ಲುನ್ ನೆಲ್ಯಾವ ಪರ್ಮಶ್ವರಾಚೆ ಉಜ್ವೆ಼ ಬಾಜು಼ಲಾ ಬಸ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","ಶಿಶಾಂಚಾನಿ ಪರ್ಪಂಚಾತ್ ಜಾ಼ವುನ್, ಸಗ್ಳಿಕ್ಡ ಲೊಕಾನಾ ಸೂವಾರ್ತಾ ಸಾಂಗ್ಲಿ. ಆನಿ ಪ್ರಭು ತ್ಯಂಚೆ ಸಂಗ ರಾಹುನ್ ಮಹತ್ಕಾರ್ಯ ಕರುನ್ ಸುವಾರ್ತೆ ಖರಿ ಮನ್ಹುನ್ ದ್ಯಾವ್ಲಿ).");
INSERT INTO gok_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","ಮಾಯೆಚಾ ಥೆಯೊಪಿಲಾ, ಆಮ್ಚೆ ಮದ್ದಿ ಚಾ಼ಲ್ಯಾಲಿ ಕಾಮ ಸಾಂಗಾಯಾಸಾಟಿ ಖುಬ್ ಜ಼ನಾಂಚಾನಿ ಖಟ್ಪಟ್ ಕಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","ಮುಳಾದರ‍್ನಿ ಹಿ ಕಾಮ ಡೊಳ್ಯಾನಿ ಬಗುನ್ ದೇವಾಚಿ ಖಬರ್ ಸಾಂಗ್ಲೆ ಮನ್ಹುನ್ ಆಮಿ ಐಕ್‌ಲ್ಯಾಲ್ಯಾ ಗುಶ್ಟಿಸ್ ತ್ಯಂಚಾನಿ ಲಿವ್‌ಲ್ಯಾತಾ. ");
INSERT INTO gok_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","ಪರ್ತೆಕ್ ಯೇಕ್ ಖಬರ್ ಮಿ ಮುಳಾದರ‍್ನಿ ಧ್ಯಾನ್‌ಥಿವುನ್ ವಾಚಿವ್‌ಲ್ಯಾಲೆಸಾಟಿ ತ್ಯ ಸಗ್ಳ ತುಲಾ ಶಾರ್ಕ ಸಮಜಾ಼ಯಾ ಪುಸ್ತಕಾಚೆಗತ್ ಲಿವ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ತುಲಾ ಸಾಂಗ್‌ಲ್ಯಾಲ್ಯಾ ಗುಶ್ಟಿ ಖರ‍್ಯಾ ಮನ್ಹುನ್ ಹ್ಯನಿ ತುಲಾ ಚಾ಼ಂಗ್ಲ ಸಮಜ಼ಲ್. ");
INSERT INTO gok_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","ಯುದಾಯಾಚಾ಼ ರಾಜಾ಼ ಹೆರೊದ್ ಹ್ಯಚಾ ಕಾಲಾತ್ ಅಬಿಯಚಾ ವರ್ಗತ್ಲಾ ಜಕರಿಯಾ ನಾವಾಚಾ಼ ಯೊಕ್ ಯಾಜಕ್ ಹುತ್ತಾ. ತ್ಯಚಿ ದನ್ಗರ್ ಆರೊನ್ ಯಾಜಕಾಚಾ ಗರ‍್ಹಾನ್ಯಾಚಿ. ತಿಚ಼ ನಾವ್ ಎಲಿಜಬೆತ್. ");
INSERT INTO gok_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","ಜಕರಿಯಾ ಆನಿ ಎಲಿಜಬೆತ್ ಖರ‍್ಯಾನಿ ದೇವಾಚೆ ನದ್ರಲಾ ಚಾ಼ಂಗ್ಲಿ ಹುತ್ತಿತ. ಪ್ರಭುಚಾ ಸಗ್‌ಳ್ಯಾ ಆಜ್ಞಾ ಚು಼ಕಾಚೆಆಂದಿ ಪಾಳಿತಿತ ಆನಿ ತೀ ಚು಼ಕ್ ನಸ್ನಾರಿ ಹುತ್ತಿತ. ");
INSERT INTO gok_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","ಫನ್ ತ್ಯನಾದೊಗಾನಾ ಪ್ಯುರ್ಗಿನವ್ಥಿತ; ಕಾ ಮಂಜೆ ಎಲಿಜಬೆತ್ ವಾಂಜೊಳಿ ಹುತ್ತಿ; ಆನಿ ತ್ಯಾ ದೊಗಾನಾಬಿ ವಯಾಜಾ಼ಲಿಹುತ್ತಿ. ");
INSERT INTO gok_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","ಯಕಸಿ ಜಕರಿಯಾಚಿ ಪಾಳಿ ಆಲಿ ತವಾ, ತ್ಯೊ ದೇವ್ಳಾತ್ ದೇವಾಚೆ ಮೊರ‍್ಹ ‍ಯಾಜಕಾಚ಼ ಕಾಮ್ ಕರೀತಾ. ");
INSERT INTO gok_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ಯಾಜಕಾಂಚಾನಿ ಧುಪ್ ಗಾಲಾಯಾ ಆಪ್ಲೆ ಚಾ಼ಲಿಚೆಗತ್ ಚಿಟ್‌ ಗಾಲ್ಹುನ್ ಯಕಾ ಯಾಜಕಾಲಾ ನಿವ್ಡಿತಿತ. ಜಕರಿಯಾಲಾ ಯಾಜಕಾಂಚೆ ಪದ್ದತಿಚೆಗತ್ ಜಕರಿಯಾಲಾ ದೇವ್ಳಾತ್ ಧುಪ್ ಗಾಲಾಯಾ ಚೀಟಿ ಗಾಲ್ಹುನ್ ನಿವಡ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","ಜಕರಿಯಾ ಧುಪ್ ಗ್ಯಾಲ್‌ಥ್ಯಾಲ್ಯಾ ಯಳಲಾ ಲೊಕ ಸಗ್ಳಿ ಬಾಹಿರ್ ಉಬಿರಾಹುನ್ ದೇವಾಪ ಮಾಗ್ನ ಕರಿತಿತ. ");
INSERT INTO gok_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","ತವಾ, ದೇವಾಚಾ಼ ಧುತ್ ಯೊಕ್ ಯವುನ್ ದುಪಾರ್ತಿಚೆ ಉಜ಼ವ್ಯಾಂಗ್ನಿ ಉಬಾರಾಯ್‌ಲ್ಯಾಲಾ ತ್ಯಲಾ ದಿಸ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","ತವಾ ಜಕರಿಯಾ ತ್ಯಲಾ ಬಗುನ್ ಬಿಹುನ್ ಕ್ಯಾಪ್ರ ಬರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","ಫನ್ ತ್ಯಾ ಧುತಾನಿ ತ್ಯಲಾ “ಜಕರಿಯಾ ಬಿಹುನಕೊ; ತುಜ಼ ಮಾಗ್ನ ದೇವಾಲಾ ಐಕು ಆಲ್ಯಾ ತುಜಿ ದನ್ಗರ್ ಎಲಿಜ಼ಬೆತ್ ತಿಲಾ ಯೊಕ್ ಪ್ಯೊರ್ಗಾ ಜ಼ಲಾಮ್ನಾರ್. ತು ತ್ಯಲಾ ಯೊಹಾನ್ ಮನ್ಹುನ್ ನಾವ್ ಥೇವಾಯಾಹ್ವಯಿ. ");
INSERT INTO gok_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","ತ್ಯೊ ಜ಼ಲಾಮ್ಲಾ ಮನ್ಹುನ್ ತುಲಾ ಖುಬ್ ಹೌಸ್ ಉಲ್ಲಾಸ್ ವ್ಹಯಿಲ್; ಆನಿ ಖುಬ್ ಲೊಕಾನಾ ಆಂನದ್ ವ್ಹನಾರ್. ");
INSERT INTO gok_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","ದೇವಾಚೆ ನದ್ರಲಾ ಯೊಹಾನ್ ಮೊಟಾ ಮಾನುಸ್ ವ್ಹನಾರ್; ದರಾಕ್ಶಿಚಾ಼ ರಸ್ ನಾಹಿತ ನಿಶಾಚಾ಼ ರಸ್ ಪಿನಾರ್ ನಾಹಿ; ಯೊಹಾನ್ ಜ಼ಲಾಮ್‌ಲ್ಯಾ ದರ್ನ್ಹಿ ಪವಿತ್ರಾತ್ಮಾನಿ ಬರ‍್ಹುನ್ ರಾನ್ಹಾರ್. ");
INSERT INTO gok_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","“ಹ್ಯೊ ಇಸ್ರಾಯಲ್ ಪಿಳ್ಗಿತ್‌ಲ್ಯಾ ಖುಬ್ ಲೊಕಾನಾ ತ್ಯಂಚಾ಼ ದೇವ್ ಪರಮೇಶ್ವರಾಕ್ಡ ಪರತಾಯಾ ಮಜ಼ತ್ ಕರ್ನಾರ್ ");
INSERT INTO gok_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","ತ್ಯೊ ದೇವಾಚಾ಼ ಫುಡಾರಿ ವ್ಹವುನ್ ಜಾ಼ವುನ್ ಪ್ರವಾದಿ ಜಾ಼ಲ್ಯಾಲ್ಯಾ ಯಲಿಯಾಚಾ ಆತ್‌ಮ್ಯಾನಿ ಆನಿ ಬಳಾನಿ ಬರ‍್ಹುನ್ ಬಾಸಂಚ಼ ಮನ್ ಪೊರಾಂಚಿಕ್ಡ. ಹಾಟ್ ದರ್ಲ್ಯಾಲ್ಯಾಲಾ ನಿತಿವಂತಾಂಚಾ ಗಿನ್ಯಾನಾಕ್ಡ ಪರ್ತುನ್ ತಯಾರ್ ಜಾ಼ಲ್ಯಾಲ್ಯಾ ಲೊಕಾನಾ ದೇವಾಕ್ಡ ನೇನಾರ್” ");
INSERT INTO gok_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","ಜಕರಿಯಾನಿ ದೇವ್ದುತಾಲಾ ಆಸ ಇಚಾರ್ಲ “ಹ್ಯ ಮಿ ಕಸ ಸಮಜು಼ನ್ ಗಿಹು? ಮಿ ಮಾಥಾರಾ; ಮಾಜಿ ದನ್ಗರ್ ವಯೆಜಾ಼ಲ್ಯಾಲಿ” ");
INSERT INTO gok_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","ದೇವ್ದುತಾನಿ, “ಮಾಜ಼ ನಾವ್ ಗಬ್ರಿಯಲ್. ಮಿ ದೇವಾಚೆ ಮೊರ‍್ಹ ಉಬಾರಾಥ್ಯಾಲಾ ದೇವಾನಿ ಹ್ಯೊ ಚಾ಼ಂಗ್ಲಾ ಸಮಾಚಾರ್ ತುಲಾ ಕಳ್ವಾಯಾಸಾಟಿ ಮನಾ ಲಾವುನ್ದಿಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","ಆತಾ ಐಕ್! ಹ್ಯೊ ಮಾಜಾ಼ ಸಬೋತ್ ಗಡ್ನಾರ್; ಖರ ತು ತ್ಯಚಿವ ಇಸ್ವಾಸ್ ಥೆವ್ಲಾನಾಹಿಸ್ ಮನ್ಹುನ್ ಮಿ ಸಾಂಗ್‌ಲ್ಯಾಲಾ ಸಬ್ದ ಗಢ ಪರ‍್ಯಾತ್ ಬೋಲಾಚೆಆಂದಿ ಮುಕ್ಕಾಹ್ವವುನ್ ರಾನ್ಹಾರ್” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","ಆನಿ ಹಿಕ್ಡ ಲೊಕ ಜಕರಿಯಾಚಿ ವಾಟ್ ಬಗಿತ್ ತ್ಯನಿ ದೇವ್ಳಾತ್ ಖುಬ್ ಯೊಳ್ ಕಾ ಕೆಲಾ ಮನ್ಹುನ್ ಗಾಭಾರ್ಲಿತ ");
INSERT INTO gok_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","ಮಂಗ್ ಜಕರಿಯಾ ದೇವ್ಳಾತ್ನಿ ಬಾಹಿರ್ ಆಲಾ ತವಾ ತ್ಯಂಚಿ ಸಂಗ ಕಾಯ್ ಬೊಲಾಚೆಆಂದಿ ರಾಯ್ಲಾ ತವಾಚಾನ್ ತ್ಯೊ ತ್ಯನಾ ಹಾತಾನಿ ಖುನಾ ಕರೀತ್ ಮುಕ್ಕಾಹ್ವವುನ್ ಹುತ್ತಾ. ತವಾ ಲೊಕಾಂಚಾನಿ ತ್ಯಲಾ ಕಾಯ್ ತರಿ ದರ್ಶಾನ್ ಜಾ಼ಲ ಆಸಲ್ ಮನ್ಹುನ್ ಸಮಜು಼ನ್ ಗೆತ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","ಕವಾ ಆಪ್ಲೆ ಯಾಜಕಾಚೆ ಪಾಳಿಚ಼ ದಿಸ್ ಸರ್ಲ ತವಾ ಜಕರಿಯಾ ಆಪ್‌ಲ್ಯಾ ಗರ‍್ಹಾತ್ ಮಾಗಾರಾ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","ತೆ ದಿಸ್ ಜಾ಼ಲ್ಯಾ ನಂತರ್ ತ್ಯಚಿ ದನ್ಗರ್ ಎಲಿಜಬೆತ್ ಗರ್ವಾರ್ ರಾಹುನ್ ಪಾಚ಼್ ಮೈನ್ಹ ಗರ‍್ಹಾತ್ನಿ ಬಾಹಿರ್ ಆಲಿನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","ಆನಿ ಎಲಿಜ಼ಬೆತ್, “ಬಗಾ, ದೇವಾನಿ ಮಾಜಿಸಾಟಿ ಕ್ಯವ್ಡ ಮೊಟ ಕಾಮ್ ಕೆಲ್ಯಾ! ಹೆ ದುನೆತ್ ಮನಾ ಆಸ್‌ಲ್ಯಾಲಾ ಆವ್ಮಾನ್ ದುರ್” ಕೆಲಾ ಮನ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","ಎಲಿಜಬೆತ್ ಸಾ ಮೈನ್ಯಾಚಿ ಗರ್ವಾರ್ ಆಸ್ಥಾನಾ ದೇವಾನಿ ಗಬ್ರಿಯಲ್ ಮಂಥ್ಯಾಲ್ಯಾ ಆಪ್‌ಲ್ಯಾ ಧುತಾಲಾ ಗಲಿಲಾಯಾ ಸಿಮೆಚೆ ನಜ಼ರೇತ್ ಮಂಥ್ಯಾಲ್ಯಾ ಗಾವಾತ್ ಯಕ ಕನ್ಯಾಪ ಲಾವುನ್ ದಿಲಾ; ");
INSERT INTO gok_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ತೆ ಕನೆಚ಼ ನಾವ್ ಮರಿಯಾ; ತಿಚಿ ರಾಜಾ಼ ಜಾ಼ಲ್ಯಾಲ್ಯಾ ದಾವಿದಾಚಾ ಗರ‍್ಹಾನ್ಯಾಚಾ಼ ಯೊಸೆಪ್ ಮಂಥ್ಯಾಲ್ಯಾ ಪ್ಯೊರ್ಗ್ಯಾ ಸಂಗ ಸಾಕಾರ್ಸಾಡಿ ಜಾ಼ಲ್ಥಿ. ");
INSERT INTO gok_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","ತ್ಯೊ ದುತ್ ತೀಚಿಪ ಯವುನ್ “ದೇವಾಚಿ ದಯೆ ಆಸ್ನಾರೆ, ತುಲಾ ಬರ ವ್ಹವುನಿ! ದೇವ್ ತುಜೆ ಸಂಗ ಹಾ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","ದೇವ್‌ದುತಾಚಾ಼ ಸಬ್ದ ಐಕುನ್ ಗಾಬ್ರುನ್ ಮರಿಯಾ “ಹ್ಯಚಾ಼ ಆರ್ಥ ಕ್ಯಾ ಆಸಲ್? ಮನ್ಹುನ್ ಯವ್ಜಿತಿ. ");
INSERT INTO gok_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","ಪರತ್ ದೇವ್ದುತ್ ತಿಲಾ ಮನ್ಲಾ “ಮರಿಯಾ, ಬಿಹುನಕೊಸ್; ದೇವಾನಿ ತುಜಿವ ಖುಬ್ ಕ್ರುಪಾ ಕಿಲಿ. ” ");
INSERT INTO gok_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","ಐಕ್! ಆತಾ ತು ಗರ್ವಾರ್ ರಾಹುನ್ ಯಕಾ ಲೇಕಾಲಾ ಜ಼ಲ್ಮ ದೇನಾರ್. ತ್ಯಲಾ, ‘ಯೇಸು’ ಮನ್ಹುನ್ ನಾವ್ ಥೆವಾಯಾ ವ್ಹಯಿ. ");
INSERT INTO gok_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","ತ್ಯೊ ಮೊಟಾ ಮಾನುಸ್‌ವ್ಹಯಿಲ್. ಆನಿ ಲೊಕ ತ್ಯಲಾ ಸಗ್‌ಳ್ಯಾತ್ ಥೊರ್‌ಲ್ಯಾ ದೇವಾಚಾ಼ ಲ್ಯೊಕ್ ಮಂಥಿಲ; ತ್ಯವ್ಡಸ್ ನವ್ಹ ದೇವ್‌ಜಾ಼ಲ್ಯಾಲಾ ಪ್ರಭು ತ್ಯಲಾ, ತ್ಯಚಾ಼ ಪೈಲಾ ವಡಿಲ್ ರಾಜಾ಼ ದಾವಿದಾಚಿ ಜಾಂತಿಕ್ ದಿಯಿಲ್. ");
INSERT INTO gok_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ತ್ಯೊ ಯಾಕೊಬಾಚಾ ಗರಾನ್ಯಾವ ಖಾಯಿಮ್ ಅಧಿಕಾರ್ ಚಾ಼ಲಿವ್ನಾರ್; ತ್ಯಚಾ಼ ರಾಜ್‌ಭಾರ್ ಕಂದಿಸ್ ಸಪ್ನಾರ್ನಾಹಿ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","ಮರಿಯಾ ದೇವ್ದುತಾಲಾ “ಹ್ಯ ಕಸ ವ್ಹಯಿಲ್? ಮಿ ಲಗಿನ್ ಜಾ಼ಲ್ಯಾಲಿ!” ನವ್ಹ ಮನ್ಲಿ ");
INSERT INTO gok_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","ತವಾ ದೇವ್ದುತ್ ಮರಿಯಾಲಾ, “ತುಜಿವ ಪವಿತ್ರಾತ್ಮ ಯನಾರ್; ಪರ್ಮೇಶ್ವರಾಚಾ ಬಳಾಚ಼ ಸಾವುಟ್ ತುಜಿವ ಪಡ್ನಾರ್. ಮನ್ಹುನ್ ಜ಼ಲಾಮ್‌ತ್ಯಾಲ ತ್ಯ ಪವಿತ್ರ ಮುಲ್ ದೇವಾಚಾ಼ ಲ್ಯೊಕ್ ವ್ಹನಾರ್. ");
INSERT INTO gok_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","ಆನಿ ತುಜೆ ಮಾಯೆಚಿ ಜಾ಼ಲ್ಯಾಲಿ ಎಲಿಜಬೆತ್ ಹಾ ನವ್ಹ. ತೀ ಸಾಹಿತ್ ಮಾಥಾರಿಜಾ಼ಲಿತರಿ ಗರ್ವಾರ್ ಹಾ; ತೀಚಾ ಪೊಟಾತ್ ಪ್ಯೊರ್ಗಾ ಹಾ; ಲೊಕಾಂಚಾನಿ ತಿಲಾ ಪೊರ ವ್ಹನಾರುಸ್ ನಾಹಿತ ಮನ್‌ಲ್ಯಾಲಿ ತೀ ಆತಾ ಸಾ ಮೈನ್ಯಾಚಿ ಗರ್ವಾರ್ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","ಕಾ ಮಂಜೆ ದೇವಾಲಾ ವ್ಹಯಿತ್ನಾಹಿ ಆಸ ಕಚ಼ಸ್ ನಾಹಿ,”ಆನಿ ದೆವಾಪ್ನಿ ಆಲ್ಯಾಲಾ ಸಬ್ದ ಯೊಕ್ಬಿ ವಾಯಾ ಜಾ಼ಯಿತ್ನಾಹಿ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","ತವಾ ಮರಿಯಾ “ಮಿ ಪ್ರಭುಚಿ ಚಾ಼ಕ್ರಿನ್. ತು ಸಾಂಗ್‌ಲ್ಯಾಶಾರ್ಕ ಮನಾ ವ್ಹವುನಿ!” ಮನ್ಲಿ. ಮಂಗ್ ದೇವ್ದುತ್ ತಿಚಿಪ್ನಿ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","ತವಾಸ್ ಮರಿಯಾ ಉಠುನ್ ಗಡ್ಬಡಿನಿ ಗುಢ್ಯಾವ್ನಿ ಯಹುದಾತ್‌ಲ್ಯಾ ಯಕಾ ಗಾವಾತ್ ಜಾ಼ವುನ್, ");
INSERT INTO gok_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","ತಿಥ ಜಕರಿಯಾಚಾ ಗರ‍್ಹಾತ್ ಯವುನ್ ಎಲಿಜ಼ಬೆತಾಲಾ ನಮಸ್ಕಾರ್ ಕೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","ಎಲಿಜ಼ಬೆತನಿ ಮರಿಯಾಲಾ ನಮಸ್ಕಾರ್ ಕೆಲಾ ತವಾಸ್ ತೀಚಾ ಪೊಟಾತ್‌ಲ್ಯಾ ಮುಲಾನಿ ಉಡಿ ಮ್ಯಾರ್ಲಿ. ಆನಿ ಎಲಿಜ಼ಬೆತ್ ಪವಿತ್ರಾತ್ಮಾನಿ ಬರುನ್ ಹುತ್ತಿ ");
INSERT INTO gok_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ಆನಿ ಮೊಟ್ಯಾನಿ ಆಸಿ ಮನ್ಲಿ: “ಬ್ಯಾಯ್ಕಾಮಾನ್ಸಾಂಚೆಮದಿ’ ತು ದೇವಾವಾಪ್ನಿ ಖುಬ್ ಆಶಿರ್ವಾದ್ ಗೆತಲ್ಯಾಲಿ ಆನಿ ತುಲಾ ಜ಼ಲಾಮ್‌ತ್ಯಾಲ್ಯಾ ಮುಲಾಲಾಬಿ ದೇವಾನಿ ಆಶಿರ್ವಾದ್ ‌ಕೆಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","ಮಾಜಾ ಪ್ರಭುಚಿ ಆಯಿ ಮಾಜಿಪ ಯಯಾಚಿ ಮಾಜ಼ ಮೊಟ ನಸೀಬ್! ");
INSERT INTO gok_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","ತುಜಾ಼ ನಮಸ್ಕಾರಾಚಾ಼ ಆವಾಜ಼್ ಮಾಜಾ ಕಾನಾವ ಪಡ್ತಾನಾಸ್ ಮುಲ್ ಮಾಜಾ ಪೊಟಾತ್ ಸಂತೊಶಾನಿ ಉಡಿ ಮ್ಯಾರ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","ಇಸ್ವಾಸ್ ಥೆವ್‌ಲ್ಯಾಲಿ ತು ಬರಿ ಪ್ರಭುನಿ ತುಲಾ ಸಾಂಗ್‌ಲ್ಯಾಲ್ಯಾ ಗುಶ್ಟಿ ಪುರ್ತಿ ವ್ಹನಾರ್. ಮನ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","ತವಾ ಮೆರಿ ಮನ್ಲಿ, “ಮಾಜಾ಼ ಜೀವ್ ಪ್ರಭುಲಾ ಧನ್ಯಾವಾದ ಕರ್ತ್ಯೊ” ");
INSERT INTO gok_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ದೇವುಸ್ ಮಾಜಾ಼ ರಾಖ್ನಿ ಜಾ಼ಲ್ಯಾ ಮನ್ಹುನ್ ಮಾಜ಼ ಮನ್ ಸಂತೊಶ್ ಜಾ಼ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","ದೇವಾನಿ ಆಪ್ಲೆ ಚಾ಼ಕ್ರಿನಿಚ಼ ಹಾಲ್ ಬಗ್ಲ. ಆನಿ ಆಚ್ಚಾನಿ ಲೊಕ ಸಗ್ಳಿ ಮನಾ ಬರಿ ಮನ್ಹಾರ್. ");
INSERT INTO gok_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ತಸ ಮನ್ಹುನ್ ಸರ್ವಶಕ್ತ ಜಾ಼ಲ್ಯಾಲ್ಯಾ ದೇವಾನಿ ಮನಾ ಮೊಟಾ ಉಪಕಾರ್ ಕೆಲ್ಯಾ; ತ್ಯಚ಼ ನಾವ್ ಪರಿಶುದ್ದ ");
INSERT INTO gok_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","ಆನಿ ದೇವಾಲಾ ಕೊನ್ ಬಿಥೊ ತ್ಯಚಿವ ದೇವಾಚಿ ದಯಾ ತ್ಯಚೆ ಪಿಡಿನ್ಪಿಡಿ ಪರ‍್ಯಾತ್ ರಾಹಿಲ್. ");
INSERT INTO gok_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","ತ್ಯನಿ ಆಪ್ಲ ಬಳ್ ದಾವುನ್ ಮಸ್ತಾವ್‌ಲ್ಯಾಲ್ಯಾಂಚಿ ಮನ ತ್ಯೊ ಖಿದಡ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","ಫನ್ ಅಧಿಕಾರ‍್ಯಾನಾ ಸಿಂಹಾಸಾವ್ನಿ ಉತ್ರುನ್ ಗರಿಬಾನಾ ವರ್ ಆಂತೊ. ");
INSERT INTO gok_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","ಫನ್ ಬುಖ್ಯಾಲ್ಯಾಲ್ಯಾನಾ ಚಾ಼ಂಗ್ಲಿ ಸಾಮ್ನ ದಿವುನ್ ಲಾವುನ್ ದಿಲಿತ ಸಾವ್ಕಾರಾನಾ ಮೊಕ್‌ಳ್ಯಾಹಾತಾನಿ ಲಾವುನ್ ದಿಲಿತ ");
INSERT INTO gok_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","ದೇವಾನಿ ಆಮ್ಚಾ ವಡ್ಲಾನಾ ಸಬ್ದ ದಿಲ್ಯಾ ಶಾರ್ಕಾ ಆನಿ ಗುಲಾಮಾತ್ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ಆಪ್‍ಲ್ಯಾ ಇಸ್ರಾಯಲಾನಾ ಮಜ಼ತ್ ಕರಾಯಾ ಆಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ತ್ಯೊ ಅಬ್ರಹಾಮಾಲಾ ಯದತ್ ಥಿವುನ್ ದಯಾ ದಾವುನ್ ಸಗ್‍ಳ್ಯಾ ಲೊಕಾನಾ ಕವಾಬಿ ಆಸ್ನಾರಿ ಕೃಪಾ ದ್ಯಾವ್ಲೆ. ");
INSERT INTO gok_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","ಮರಿಯಾ ಕಮಿಸ್ ಕಮಿ ತೀನ್ ಮೈನ ಎಲಿಜ಼ಬೆತಾಪ ರಾಹುನ್ ಆಪ್‌ಲ್ಯಾ ಗರ‍್ಹಾತ್ ಪರ್ತುನ್ ಗಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","ಎಲಿಜಬೆತಾಲಾ ಬಾಳತ್ಫನಾಚ ದೀಸ್ ಬರ್ಹುನ್ ಯೊಕ್ ಪ್ಯೊರ್ಗಾ ಜಾ಼ಲಾ ");
INSERT INTO gok_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","ತಿಚಾ ಸೆಜಾರ‍್ಯಾಂಚಿ ಮಾಯೆದಾಯೆಚಿ ತಿಚಿವ ದೇವಾನಿ ಆಪ್ಲಿ ದಯೆ ವಿಶೆಸ್ ದ್ಯಾವ್ಲಿ ಮನ್ಹುನ್ ಐಕುನ್ ತಿಚಿ ಸಂಗ ಆನಂದ್ ಜಾ಼ಲ್ಹಿತ. ");
INSERT INTO gok_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","ಆಟ್ವೆ ದಿಸಿ ತೀ ತ್ಯಾ ಮೂಲಾಲಾ ಮುಂಜಿ ಕರಾಲಾ ಯವುನ್ ತ್ಯಲಾ “ಜಕರಿಯಾ” ಮನ್ಹುನ್ ನಾವ್ ಥೆವಾ ವ್ಹಯಿ ಮನ್ಲಿತ. ಕಾ ಮಂಜೆ ತ್ಯ ತ್ಯಾ ಮುಲಾಚಾ ಬಾಚ಼ ನವ್ ಜಾ಼ಲ್ತ. ");
INSERT INTO gok_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","ಫನ್ ಹೆ ಗುಶ್ಟಿಲಾ ತ್ಯಚಿ ಆಯಿ, “ನಕೊ! ‘ಯೊಹಾನುಸ್, ಮನ್ಹುನ್ ತ್ಯಚ಼ ನಾವ್ ಥೆವಾಯಾ ವ್ಹಯಿ” ಮನ್ಲಿ ");
INSERT INTO gok_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","ಖರ ಆಲ್ಯಾಲಿ ಲೊಕ ಎಲಿಜಬೆತಾಲಾ, “ತುಜಾ ಗರ‍್ಹಾನ್ಯಾತ್ ಹ್ಯಾ ನಾವಾಚ಼ ಕೊನ್ ನಾಹಿ ನವ್ಹ!” ಮನ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","ಮಂಗ್ ಹ್ಯಲಾ ಕ್ಯಾ ನಾವ್ ಥೆವಾವ್ಹಯಿ ಮನ್ಥೊಸ್ ಮನ್ಹುನ್ ಮುಲಾಚಾ ಬಾಲಾ ಖುನಾ ಕರುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","ತ್ಯನಿ ಯೇಕ್ ಪಾಟಿ ಆನುನ್ ಗಿಹುನ್ “ತ್ಯಚ಼ ನಾವ್ ಯೊಹಾನುಸ್” ಮನ್ಹುನ್ ಲಿವ್ಲ ತ್ಯಲಾ ಲೊಕಸಗ್ಳಿ ಗಾಭಾರ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","ತವಾಸ್ ತ್ಯಲಾ ತ್ವಾಂಡ್ ಆಲ ಜಿ಼ಬ್ ಸಯಿಲ್ ಜಾ಼ಲಿ ತ್ಯಲಾ ಬೋಲಾಲಾ ಬಳ್ ಯವುನ್ ದೇವಾಲಾ ಉಪ್ಕಾರ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","ಹ್ಯ ಐಕುನ್ ಸೆಜಾ಼ರವಾಲ್ಯಾನಾ ಭೆವಾಟಾಯಾಲಾಗ್ಲ ಆನಿ ಹ್ಯಾ ಸಗ್‌ಳ್ಯಾ ಗುಶ್ಟಿಚೆ ಬದಲ್ ಯುದಾಯಾಚೆ ಡಂಗ್ಳಿಚಾಗಾವಾತ್ನಿ ಬೊಲತಿತ ");
INSERT INTO gok_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","ಐಕ್‍ಲ್ಯಾಲಿ ಸಗ್ಳಿ ಲೊಕ ಗಾಬ್ರುನ್ ಆಜಾಬ್ ವ್ಹವುನ್ ಹ್ಯ ಮುಲ್ ಮೊಟಹ್ವವುನ್ ಕಸ್ಲಾ ಮಾನುಸ್ ವ್ಹತ್ಯೊ? ಮನ್ಹುನ್ ಯವ್‌ಜಾ಼ಯಾಲಾಗ್ಲಿತ ಕಾ ಮಂಜೆ ದೇವಾಚ಼ ಬಳ್ ತ್ಯಚಿವ ಹುತ್ತ. ");
INSERT INTO gok_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","ತ್ಯವ್ಡಸ್ ನವ್ಹ ಯೊಹಾನಾಚಾ಼ ಬಾ ಜಕರಿಯಾ ಪವಿತ್ರಾತ್ಮಾನಿ ಬರ‍್ಹನ್ ದೇವಾಚ಼ ವಾಕ್ಯ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“ಇಸ್ರಾಯಲ್ ಲೊಕಾಂಚಾ಼ ದೇವ್ ಜಾ಼ಲ್ಯಾಲ್ಯಾ ಪ್ರಭುಲಾ ಸ್ತೊತ್ರ ವ್ಹವುನಿ. ಆಪ್‌ಲ್ಯಾ ಲೊಕಾನಾ ಮಜ಼ತ್ ಕರಾಯ ಆನಿ ಆಪ್‌ಲ್ಯಾ ಲೊಕಾನಾ ಸೊಡ್ವಾಯಾ ಆಲಾ; ");
INSERT INTO gok_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","ಆಪ್ಲಾ ಸೇವಕ್ ದಾವಿದಾಚಾ ಗರ‍್ಹಾನ್ಯಾತ್ ದೇವಾನಿ ಸರ್ವಶಕ್ತ ರಕ್ಷಕ್ ಆಮಾನಾ ದಿಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","ಹ್ಯ ತ್ಯನಿ ಪೈಲ್ಯಾಕಾಲಾತ್‌ಲ್ಯಾ ಆಪ್‌ಲ್ಯಾ ಪವಿತ್ರ ಪ್ರವಾದಿಂಚಾಪ್ನಿ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ದೇವಾನಿ ಆಮಾನಾ ಆಮ್ಚಾ ವಾದಿಂಚಾಪ್ನಿ ಆನಿ ರಾಗಿಷ್ಟಾಂಚಾ ಹತಾತ್ನಿ ರಕ್ಶಿಸ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","ಕರ್ನಾ ದ್ಯಾವ್ನಾರ್ ವಡ್ಲಾನಾ ಕೆಲ್ಯಾಲಿ ಆಪ್ಲಿ ಶೆಪತ್ ತ್ಯನಿ ಯದತ್ ಆನ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","ಆಮ್ಚಾ ವಾದಿಂಚಾ ಹಾತಾತ್ನಿ ಆಮಾನಾ ಸೊಡ್ವಾಯಾ ದೇವಾನಿ ಆಮಚಾ಼ ವಡಿಲ್ ಅಬ್ರಹಾಮಾಲಾ ಶೆಪತ್ ದಿಲೆ. ");
INSERT INTO gok_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ತ್ಯೊ ಆಮ್ಚಾ ವಾದಿಂಚಾ ಹಾತಾತ್ನಿ ಆಮಾನಾ ಸೊಡ್ವಾಯಾ ಆಮಾನಾ ತ್ಯಲಾ ಕಾಯೇಕ್ ಭೆನಸ್ತಾನಾ ಉಪ್ಕಾರ್ ಕರಾಯಾ ಹುಕುಮ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ಹ್ಯಚಿಸ್ ಲಾಗುನ್ ಆಮಿ ತ್ಯಚಿ ಮೊರ‍್ಹ ಆಮ್ಚಾ ಜೀತಾಚ಼ ಸಗ್ಳ ದೀಸ್ ತ್ಯಚೆ ಮೊರ‍್ಹ ಪರಿಶುದ್ದ ಆನಿ ನಿಯತೀನಿ ವ್ಹವುನ್ ರಾಹ್ಯಾ ವ್ಹಯಿ ");
INSERT INTO gok_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","ಆನಿ ಜಕರಿಯಾ ಬಾಳಾ ತುತರಿ ಪರಾತ್ಪರಾಚಾ಼ ಸಾಂಗ್ ಸಾಂಗ್ನಾರಾ (ಪ್ರಾವಾದಿ) ಮನ್ಹುನ್ ಗಿಹಿಲ್ ತು ಪ್ರಭುಚೆ ಮೊರ‍್ಹ ಜಾ಼ವುನ್ ತ್ಯಚಾ಼ ರಸ್ತಾ ನೀಟ್ ಕರ್ನಾರಾ ವ್ಹವುನ್ ");
INSERT INTO gok_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ಆನಿಕ್ ಆಮಚಾ಼ ದೇವ್ ಪಾಪ ಮಾಪ್ ಕರಾಯಾ ಸಾಟಿ ರಕ್ಷನೆಚಾ ಗಿನ್ಯಾನ್ ಆಪ್‌ಲ್ಯಾ ಲೊಕಾನಾ ದೇನಾರಾ ");
INSERT INTO gok_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ಆಮಚಾ಼ ದೇವ್ ದಯಾ ದಾವುನ್ ಕರ್ನಾ ಆಸ್ನಾರಾ ಪರಲೊಕಾತ್ನಿ ಸಕಾಳಚ಼ ರಕ್ಶನೆಚಾ಼ ನವಾ ದೀಸ್ ಆಮ್ಚಿವ ಉಗುವುನ್. ");
INSERT INTO gok_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ಆಂದಾರಾತ್ನಿ ಮರ್ನಾಚಾ ಭ್ಯಾತ್ ರಾಥ್ಯಾಲ್ಯಾ ಆಮಾನಾ ಉಜಿಡ್ ದಿವುನ್ ತ್ಯೊ ಅಮಾನಾ ಶಾಂತಿಚೆ ವಾಟವ ಲಾವುನ್ ಚಾ಼ಲಿವ್ನಾರ್ ಮನ್ಲಾ ");
INSERT INTO gok_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","ತ್ಯೊ ಪ್ಯೊರ್ಗಾ ಆಂಗಾತ್ಬಿ ಬರ‍್ಹುನ್ ಆನಿ ಆತ್‌ಮ್ಯಾನಿ ಬರ‍್ಹುನ್ ಇಸ್ರಾಯಲ್ ಲೊಕಾನಾ ಆಪ್‌ಲ್ಯಾಲಾ ದಾವುನ್ ದಿಯಾಚಾ ದಿಸಾಪರ‍್ಯಾತ್ ರಾನಾತ್ನಿ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","ತ್ಯಾ ಯಳಾತ್ ರೊಮ್ ರಾಜ ಸಗ್ಳ ಜನಗನತಿ ಕರಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಕೈಸರ್ ಅಗಸ್ಟಸಾಪ್ನಿ ಆಜ್ಞೆ ಆಲಿ ");
INSERT INTO gok_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","ಕುರೆನಿಯಾ ಸಿರಿಯಾ ದೇಸೆಚಾ಼ ಅಧಿಪತಿ ಜಾ಼ಲ್ಯಾಲಾ ಆಸ್ಥಾನಾ ಹಿ ಪೈಲಿ ಗನತಿ ಚಾ಼ಲ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","ಆನಿ ತವಾ ಸಗ್ಳಿ ಲೊಕ ನಾವ ಲಿವುನ್ ಗಿಹ್ಯಾ ಆಪ್‌ಲ್ಯಾ ಆಪ್‌ಲ್ಯಾ ಗಾವಾತ್ ನಿಗಾಲಿತ. ");
INSERT INTO gok_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","ಮನ್ಹುನ್ ಯೊಸೆಪ್ ಸಾಹಿತ್ ಆಪ್ನು ದಾವಿದಾಚಾ ಗರ‍್ಹಾನ್ಯಾಚಾ ಮನ್ಹುನ್ ನಾವ್ ಲಿವುನ್ ಗಿಹ್ಯಾ ಸಾಟಿ ಆಪ್‌ಲ್ಯಾಲಾ ಥರಿವ್‍ಲ್ಯಾಲೆ ಮರಿಯಾಚೆ ಸಂಗ ಗಲಿಲಾಯ್ ಸಿಮೆಚೆ ನಜೆರೆತ್ ಮಂಥ್ಯಾಲ್ಯಾ ಗಾವಾತ್ನಿ ನಿಗುನ್ ಯುದಾಯಾತ್ ಆಸ್‌ಲ್ಯಾಲೆ ಬೆತ್ಲೆಹೇಮ್ ಮಂಥ್ಯಾಲ್ಯಾ ದಾವಿದಾಚಾ ಗಾವಾತ್ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","ತ್ಯೊ ನಾವ ಲಿವುನ್ ಗಿಹ್ಯಾ ಮರಿಯಾ ಸಂಗ ಗೆಲಾ ಆನಿ ತೀಚಿ ಸಂಗ ಸಾಕಾರ್ಸಾಡಿ ಜಾ಼ಲ್ಥಿ ತವಾ ತೀ ಗರ್ವಾರ್ ಹುತ್ತಿ. ");
INSERT INTO gok_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","ತವಾ ಮರಿಯಾ ಗರ್ವಾರ್ ಹುತ್ತಿ. ತೀ ತಿಥ ಆಸ್ಥಾನಾ ತಿಚ ದೀಸ್ ಬರ್ಲ್ಹ. ");
INSERT INTO gok_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","ತಿನಿ ಆಪ್‌ಲ್ಯಾ ಪೈಲ್ಯಾ ಲೇಕಾಲಾ ಜ಼ಲ್ಮ ದೀವುನ್ ಕಪ್‍ಡ್ಯಾತ್ ಗುಂಡ್ಯಾಳುನ್ ತ್ಯನಾ ಗರ‍್ಹಾತ್ನಿ ಜಾ಼ಗಾ ನವ್ಥಾ ಮನ್ಹುನ್ ತ್ಯಲಾ ಗುರಾಂಚೆ ಅಡ್ಗಳಿತ್ ಥೆವ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","ತೇ ರಾತಿ ಥೊಡ ಕುರುಬುರ್ ಗಾವಾತಲ್ಯಾ ಸೇತಾತ್ನಿ ರಾಹುನ್ ಆಪ್ಲಾ ಮೆಂಡ್ರಾಂಚಾ಼ ಹಿಂಡ್ ರಾಖಿತ. ");
INSERT INTO gok_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","ಪ್ರಭುಚಾ಼ ಯೊಕ್ ಧುತ್ ಯವುನ್ ತ್ಯಂಚೆ ಮೊರ‍್ಹ ಉಬಾ ರಾಯ್ಲಾ. ಪ್ರಭುಚಾ಼ ಉಜಿಡ್ ತ್ಯಂಚೆ ಸರ್ಬೌಥ ಪಡ್ಲಾ; ತೇ ಖುಬ್ ಬಿಹ್ಯಾಲ್ಹ. ");
INSERT INTO gok_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","ತ್ಯಾ ಧುತಾನಿ ತ್ಯನಾ ಬಿಹುನಕೊಸಾ, ಐಕಾ ಲೊಕಾನಾ ಸಂತೊಶ್ ಆಂತ್ಯಾಲಾ ಚಾ಼ಂಗ್ಲ ಸಮಾಚಾರ್ ಮಿ ತುಮಾನಾ ಸಾಂಗ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","ತ್ಯ ಕ್ಯಾ ಮನ್‌ಲ್ಯಾವ, ಹೆ ಯಳಿ ತುಮ್ಚೆಸಾಟಿ ದಾವಿದಾಚಾ ಗಾವಾತ್ ಯೊಕ್ ರಾಖ್ನಿ ಜ಼ಲಾಮ್‌ಲ್ಯಾ, ತ್ಯೊ ಪ್ರಭು ಜಾ಼ಲ್ಯಾಲಾ ಯೇಸು ಕ್ರಿಸ್ತ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","ತ್ಯ ತುಮಾನಾ ಠಾವಾ ವ್ಹಯಾ ವಳಕ್ ಕ್ಯಾ ಮನ್‌ಲ್ಯಾವ ಕಪ್‌ಡ್ಯಾನಿ ಗುತ್ಪಳ್ಯಾಲ ಯಾಕ್ ಮುಲ್ ಅಡ್ಗಳಿತ್ ನಿಜಿವ್‌ಲ್ಯಾಲ ಬಕ್ಸಿಲಾ. ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","ಪಾಕ್ಕನ್ ತ್ಯಾ ದುತಾ ಸಂಗ ಪರಲೊಕ್ ಸೈನ್ಯಾಚಾ಼ ಯೊಕ್ ಮೊಟಾ ಹಿಂಡ್ ಯವುನ್ ಆಂದಿಚಾ ದೇವ್ದುತಾ ಬರ್ಬರ್ ಮಿಳುನ್ ದೇವಾಲಾ ಸ್ತುತಿ ಕೆಲಿ ");
INSERT INTO gok_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","ವೈಲ್ಯಾ ದುನಿಯಾತ್ ದೇವಾಲಾ ಮಹಿಮೆ; ಭುಲೊಕಾತ್ ಮಾನ್ಚಾಮದಿ ಸಮಾದಾನಾ ದೇವ್ ತ್ಯನಾ ಪಾವನ್ ವ್ಹನಾರ್ ಮನ್ಹುನ್ ದೇವಾಲಾ ಉಪ್ಕಾರ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","ದೇವ್ದುತ್ ತ್ಯಂಚಿಪ್ನಿ ಪರಲೊಕಾತ್ ನಿಗುನ್ ಗೆಲ್ಯಾ ನಂತರ್ ತೆ ಕರುಬುರ್ “ಆಮಿ ಆತಾಸ್ ಬೆತ್ಲೆಹೇಮತ್ ಜಾ಼ವುನ್ ಆಮಾನಾ ಸಾಂಗುನ್ ದಿಲ್ಯಾಲಿ ಖಬರ್ ಬಗುಯಾ ಚ಼ಲಾ ಮನ್ಹುನ್ ಆಪ್‍ಲ್ಯಾ ಆಪ್‍ಲ್ಯಾತ್ ಬೊಲ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","ಪಾಟ್ನಿ ಜಾ಼ವುನ್ ಮರಿಯಾ ಯೊಸೆಪ್ ಆನಿ ಅಡ್ಗಳಿತ್ ನಿಜ಼ಲ್ಯಾಲ ತವಾಸ್ ಜ಼ಲಾಮ್‌ಲ್ಯಾಲ ಮುಲ್ ಬಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","ತ್ಯಲಾ ಬಗ್ಲ ತವಾ ತ್ಯಂಚಾನಿ ತ್ಯಚೆ ಗುಶ್ಟಿತ್ ಆಪ್‍ಲ್ಯಾಲಾ ಸಾಂಗ್‍ಲ್ಯಾಲ ಸಾಂಗಾಲಾಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","ಕುರುಬುರಾಂಚಾನಿ ಸಾಂಗ್‍ಲ್ಯಾಲ ಐಕ್‍ಲ್ಯಾಲಿ ಸಗ್ಳಿ ಗಾಭಾರ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","ಫನ್ ಮರಿಯಾನಿ ತ್ಯ ಸಗ್ಳ ಸಬಾತ್ ಆಪ್‍ಲ್ಯಾ ಮನಾತ್ ಥೀವುನ್ ಯವ್ಜಿತ್ ಹುತ್ತಿ. ");
INSERT INTO gok_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","ಕುರುಬುರಾಂಚಾನಿ ಆಪ್‍ಲ್ಯಾಲಾ ದುತಾಂಚಿಪ್ನಿ ಸಾಂಗಿತ್‍ಲ್ಯಾ ಶಾರ್ಕ ಸಗ್‍ಳ್ಯಾ ಗುಶ್ಟಿ ಐಕುನ್ ಬಗುನ್ ತ್ಯಂಚಿ ಸಾಟಿ ದೇವಾಲಾ ಗೀತ್‍ ಗಾವಿತ್ ಉಪ್ಕಾರ್ ಸಾಂಗಿತ್ ಮಾಗಾರ ಗೆಲ. ");
INSERT INTO gok_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","ತ್ಯಾ ಮೂಲಾಲಾ ಮುಂಜ಼ ಕರಾಯಾ ಆಟ್ವೆ ದಿಸಿ ನೇಲ ಆನಿ ತ್ಯಲಾ ಯೇಸು ಮನ್ಹುನ್ ನಾವ್ ಥೆವ್ಲ “ತ್ಯ ಪೊಟಾತ್ ಪಿಂಡ್ ಗಡ್ಡಾಚೆ ಆಂದಿ ದೇವ್ದುತಾನಿ ತ್ಯಚ಼ ನಾವ್ ಸಾಂಗ್ಲ ಹುತ್ತ. ");
INSERT INTO gok_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","ಮಂಗ್ ಮೊಶೆಚಾ ಧರ್ಮಶಾ ಶಾರ್ಕ ತ್ಯಂಚ಼ ಸುತೀಕ್ ಜಾ಼ಯಾ ವ್ಹಯಿ ಆಸ್‌ಲ್ಯಾಲ ದೀಸ್ ಬರ್ಲ್ಯಾವ ಯೊಸೆಪ್ ಆನಿ ಮರಿಯಾ ತ್ಯಾ ಮೂಲಾಲಾ ಯೆರುಸಲೆಮಿಚಾ ದೇವ್ಳಾತ್ ಪ್ರಭುಲಾ ಪ್ರತಿಶ್ಟೆ ಕರಾಯಾ ನೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","ಕಾ ಮನ್‌ಲ್ಯಾವ ಪೈಲ್ಯಾನಿ ಜ಼ಲಾಮ್‍ಲ್ಯಾಲ ಪ್ಯೊರ್ಗಾ ತ್ಯ ದೇವಾಲಾ ಸೊಡಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ದೇವಾಚಾ ಧರ್ಮ ಶಾಸ್ತಾರಾತ್ ಸಾಂಗ್‍ಲ್ಯಾ ಶಾರ್ಕ ತ್ಯ ದೇವಾಲಾ ದಿಯಾ ವ್ಹಯಿ ಜಾ಼ಲ್ಥ. ");
INSERT INTO gok_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","ಆನಿ ದೇವಾಚಾ ಧರ್ಮಶಾಸ್ತಾರಾತ್ ಸಾಂಗ್‍ಲ್ಯಾ ಶಾರ್ಕ ಯಕ ಜು಼ಡಿ ಕವ್ಡ ನಾಹಿತ ಪ್ಯಾರ್‌ವ್ಯಾಚಿ ದೊನ್ ಪಿಲಿ ಕಾಪಾ ವ್ಹಯಿತಿತ. ");
INSERT INTO gok_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","ತ್ಯಾ ದೀಸಾತ್ ಯೆರುಸಲೇಮಿತ್ ಸಿಮೊನ್ ನಾವಾಚಾ ಮಾನುಸ್ ಹುತ್ತಾ. ಹ್ಯೊ ಮಾನುಸ್ ನಿಯತಿಚಾ ದೇವಾಚಾ ಭಗತ್ ವ್ಹವುನ್ ಇಸ್ರಾಯಲ್ ಲೊಕಾನಾ ಮಜ಼ತ್ ಕರ್ತ್ಯಾಲಾ ಕವಾ ಯನಾರ್ ಮನ್ಹಿತ್ ಹುತ್ತಾ. ಆನಿ ಪವಿತ್ರಾತ್ಮ ತ್ಯಚಿ ಸಂಗ ಹುತ್ತ. ");
INSERT INTO gok_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ಆನಿ ದೇವಾನಿ ಲಾವುನ್ ದಿಯಾ ವ್ಹಯಿ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ಮೆಸ್ಸಿಯಾಲಾ ಬಗಾಚೆ ಆಂದಿ ತು ಮರ್ನಾರ್ ನಾಹಿ ಮನ್ಹುನ್ ಪವಿತ್ರಾತ್ಮಾನಿ ಸಿಮೊನಾಲಾ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","ಸಿಮೊನ್ ಪವಿತ್ರಾತ್ಮಾಚಾ ಸಾಂಗ್‌ನ್ಯಾನಿ ದೇವ್ಳಾತ್ ಆಲಾ. ತವಾ ಯೊಸೆಪ್ ಆನಿ ಮರಿಯಾ ಯೇಸು ಮಂಥ್ಯಾಲ್ಯಾ ಮೂಲಾಲಾ ಧರ್ಮ ಶಾಸ್ತ್ರಾಶಾರ್ಕ ಚಾ಼ಲ್ವಾ ಪಾಯ್ಜೆ ಮನ್ಹುನ್ ತ್ಯಲಾ ಆತ್ ಆನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ಸಿಮೋನಾನಿ ಮುಲ್ ಆಪ್‍ಲ್ಯಾ ಹತಾತ್ ಗಿಹುನ್ ದೇವಾಲಾ ಉಪಕಾರ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","ಪ್ರಭು ತು ಸಾಂಗ್‍ಲ್ಯಾ ಶಾರ್ಕ ಕೆಲಸ್. ಆತಾ ಸಮಾದಾನಾನಿ ಜಾ಼ಯಾಲಾ ತುಜಾ ಶಿಶಾಲಾ ಮೊಕಳ್ ಜಾ಼ಲಿ. ");
INSERT INTO gok_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","ತು ಥರಿವ್‌ಲ್ಯಾಲ್ಯಾ ರಕ್ಶಕಾಲಾ ಮಿ ಮಾಜಾ ಡೊಳ್ಯಾನಿ ಬಗ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ತು ತ್ಯಲಾ ಸಗ್‌ಳ್ಯಾ ಲೊಕಾನಾ ದಿಸ ಜೊ಼ಗ ಕೇಲಾಸ್. ");
INSERT INTO gok_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","ತ್ಯೊ ಯಹುದ್ಯ ನಸ್‍ಲ್ಯಾಲ್ಯಾ ಲೊಕಾನಾ ತುಜಿ಼ ವಾಟ್ ದ್ಯಾವ್‌ತ್ಯಾಲಾ ಉಜಿಡ್ ಜಾ಼ಲ್ಯಾ. ತುಜಿ ಪರಜೆ ಜಾ಼ಲ್ಯಾಲಿ ಇಸ್ರಾಯಲಾನಾ ಮೈಮಾ ವ್ಹನಾರ್. ");
INSERT INTO gok_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","ಸಿಮೊನಾನಿ ತ್ಯಾ ಮುಲಾಚೆ ಗುಶ್ಟಿತ್ ಸಾಂಗ್‍ಲ್ಯಾಲ್ಯಾ ಹ್ಯಾ ಸಬ್ದಾನಾ ತ್ಯಚೆ ಆಯಿ ಬಾಲಾ ಚಮತ್ಕಾರ್ ವಾಟ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","ಸಿಮೊನಾನಿ ತ್ಯನಾ ಆಶಿರ್ವಾದ ಕರುನ್ ಆಯಿ ಮರಿಯಾಲಾ “ಬಗಾ ಹ್ಯ ಹ್ಯಚಿಸ್ ಲಾಗುನ್ ಲೊಕ ಪಡ್‌ತ್ಯಾತ ಆನಿ ಉಟ್ಯಾತ ಆನಿ ಲೊಕ ಹ್ಯಲಾ ವಿರೊದ್ ವ್ಹವುನ್ ಚಾ಼ಲತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","ಲೊಕ ಚು಼ರುನ್ ಆತ್ ಬೊಲತ್ಯಾಲ್ಯಾ ಗುಶ್ಟಿ ಬಾಹಿರ್ ಪಡ್ನಾರ್. ಮೊರ‍್ಹ ವ್ಹನಾರ‍್ಯಾ ಗುಶ್ಟಿ ಐಕುನ್. ತುಜಾ ಕಾಳ್‍ಜಾ಼ಲಾತರಿ ಹತ್ಯಾರ ಲಾಗ್‍ಲ್ಯಾಚೆಗತ್‌ವ್ಹಯಿಲ್” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","ಇತ್ಕಸ್ ನವ್ಹ. ಅಸೆರಾಚಾ ಕುಳಾತ್ ಫನುವೆಲಾಚಿ ಲೇಕ್ ಅನ್ನಾ ಮಂಥ್ಯಾಲಿ ಯೆಕ್ ಪ್ರವಾದಿನಿ ಹುತ್ತಿ. ತಿಚ಼ ಲಗಿನ್ ವ್ಹವುನ್ ನವರ‍್ಯಾ ಸಂಗ ಸಾತ್ ವರ್ಸ ಸಂಸಾರ್ ಕರುನ್ ಆತಾ ತೀ ಖುಬ್ ಮಾಥಾರಿ ಜಾ಼ಲ್ಥಿ. ");
INSERT INTO gok_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ಆತಾ ತಿಲಾ ಐಂಸಿವ ಚಾರ್ ವರ್ಸ ವಯಾ ಜಾ಼ಲಿ. ಆನಿ ತೀ ರಾಂಡಾವ್ ಹುತ್ತಿ ತೀ ದೀವುಳ್ ಸುಡುನ್ ಜಾ಼ಯಾಚೆ ಆಂದಿ ದೇವ್ಳಾತ್ ಉಪಾಸಿ ಮಾಗ್ನ ಕರೀತ್ ರ‍್ಯಾತ್ ದೀಸ್ ದೇವಾಚಿ ಸೇವಾ ಕರೀತ್ ಹುತ್ತಿ. ");
INSERT INTO gok_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","ತೀ ತೇಸ್ ಗಟ್ಕಲಾ ತಿಥ ಯವುನ್, ದೇವಾಲಾ ಉಪ್ಕಾರ್ ಸಾಂಗುನ್ ದೇವಾನಿ ಯೆರುಸಲೇಮಚೆ ಸುಟ್ನುಕಿಚಿ ವಾಟ್ ಬಕ್‌ತ್ಯಾಲ್ಯಾಂಚಿ ಸಂಗ ತ್ಯಚಿ ಖಬರ್ ಸಾಂಗ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","ಪ್ರಭುಚಾ ಧರ್ಮಶಾಸ್ತಾರಾತ್ ಸಾಂಗ್‍ಲ್ಯಾಲ ಕಾರ್ಯಾ ಸಗ್ಳ ಕೆಲ್ಯಾ ನಂತರ್ ಯೊಸೆಪ್ ಆನಿ ಮರಿಯಾ ಗಲಿಲಾಯಾತ್ ಆಸ್‍ಲ್ಯಾಲ್ಯಾ ನಜರೆತ್ ಮಂಥ್ಯಾಲ್ಯಾ ಆಪ್‍ಲ್ಯಾ ಗಾವಾತ್ ಪರ್ತುನ್ ಗಿಲಿತ. ");
INSERT INTO gok_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","ತ್ಯ ಮುಲ್ ವಾಡತ್ ಮೊಟಾ ವ್ಹವುನ್ ಗಿನ್ಯಾನಾನಿ ಆನಿ ಬಳಾನಿ ಬರ‍್ಹುನ್; ದೇವಾಚಿ ದಯೆ ತ್ಯಚಿ ಬರ್ಬರ್ ಹುತ್ತಿ. ");
INSERT INTO gok_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","ತ್ಯಚಿ ಆಯಿ ಬಾ ಪೆರ್ತೆಕ್ ವರ್ಸಿ ವಲಾಂಡ್ಯಾಚಾಸನಾಲಾ ಯೆರುಸಲೇಮಿತ್ ಜಾ಼ಯಿತಿತ. ");
INSERT INTO gok_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","ಆಸ ಆಸ್ಥಾನಾ ತೆ ಬಾರಾ ವರ್ಸಾಚಾ ಜಾ಼ಲ್ಹಾತವಾ ತೀ ಖಾಯಿಮ್ಚೆ ಪದ್ದತಿ ಶಾರ್ಕ ಪಸ್ಕಾಚಾ ಸನಾಲಾ ತಿಥ ಗಿಲಿತ. ");
INSERT INTO gok_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","ಸನಾಚ ದೀಸ್ ಸಪುನ್ ಮಾಗಾರಿ ಯತಾನಾ ಯೇಸು ಯೆರುಸಲೇಮಿತುಸ್ ರಾಯ್ಲಾ ತ್ಯ ತ್ಯಚೆ ಆಯಿ ಬಾಲಾ ಸಮಾಜ಼್ಲನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","ಯೊಸೆಪ್ ಆನಿ ಮರೆಯಾ ತ್ಯೊ ವಾಟನಿ ಜಾ಼ತ್ಯಾಲ್ಯಾಂಚೆ ಸಂಗ ಆಸಲ್ ಮನ್ಹುನ್ ಯವ್ಜುನ್ ಯೇಕ್ ದಿಸಾಚಿ ವಾಟ್ ಚಾ಼ಲುನ್ ಆಪ್ಲೆ ಮಾಯಾದಾಯೆಂಚಿಪ್ನಿ ವಳ್ಕಿಂಚಾಪ್ನಿ ತ್ಯಲಾ ಶೊದ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ಫನ್ ಯೇಸು ದಿಸ್ಲಾನಾಹಿ, ತವಾ ಮಾಗಾರಿ ಯೆರುಸಲೇಮಿತ್ ಸುದಿತ್ ಗೆಲಿತ. ");
INSERT INTO gok_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","ತೀನ್ವೆ ದಿಸಿ ಯೇಸುಲಾ ದೇವ್ಳಾತ್ ಬಗ್ಲಾ. ತ್ಯೊ ಯೆಹುದ್ಯ ಪಂಡಿತಾಂಚೆ ಮದ್ದಿ ಬಸ್ಸುನ್ ತ್ಯಂಚ಼ ಬೋಲ್ನ ಐಕಿತ್ ಪ್ರಶ್ನೆ ಇಚಾರಿತ್ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","ಯೇಸು ಬೊಲ್ಯಾಲ ಸಬಾತ್ ಐಕ್‍ಲ್ಯಾಲಿ ಸಗ್ಳಿ ತ್ಯಚೆ ಬುದ್ದಿಲಾ ಆನಿ ಉತ್ತರ್ ದಿಲ್ಯಾಲಾ ಬಗುನ್ ಗಾಭಾರ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","ಆಯಿ ಬಾನಿ ಯೇಸುಲಾ ಬಗುನ್ ಚಮತ್ಕಾರ್ ವಾಟ್ಲ; ಆನಿ ತ್ಯಚಿ ಆಯಿ “ಲೇಕಾ ತು ಆಮಾನಾ ಆಸ ಕಾ ಕೆಲಸ್? ಬಗ್ ತುಜಾ಼ ಬಾ ಆನಿ ಮಿ ಕ್ಯವ್ಡಿ ತಳ್ಮಳುನ್ ತುಲಾ ಸುದಿತ್ ಆಲಾವ್ ನವ್ಹ” ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","ತವಾ ಯೇಸು ತ್ಯನಾ “ತುಮಿ ಮನಾ ಕಸ್ಯಾಲಾ ಸುದಿತಾಸಾ? ಮಿ ಮಾಜಾ ಬಾಚಾ ಗರ‍್ಹಾತ್ ರಾನ್ಹಾರ್ ಮನ್ಹುನ್ ತುಮಾನಾ ಕಳ್ಳನಾಹಿಕ್ಯಾ? ಮನ್ಹುನ್ ಉತ್ತರ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","ಖರ ತ್ಯನಿ ಸಾಂಗ್‍ಲ್ಯಾಲ್ಯಾ ಸಬ್ದಾಂಚಾ಼ ಅರ್ಥ ತ್ಯನಾ ಜಾ಼ಲ್ಹಾನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","ನಂತರ್ ಯೇಸು ತ್ಯಂಚೆ ಸಂಗ ನಜರೆತಿತ್ ಯವುನ್ ತ್ಯಂಚಿಗತ್ ರಾಯ್ಲ. ಫನ್ ತ್ಯಚಿ ಆಯಿ ಹ್ಯ ಸಗ್ಳ ಆಪ್‌ಲ್ಯಾ ಮನಾತ್ ಥಿವುನ್ ಯವ್ಜಿತಿ. ");
INSERT INTO gok_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","ಯೇಸು ಗಿನ್ಯಾನಾನಿ ಆನಿ ಆಂಗಾನಿ ಬರ‍್ಹುನ್ ಆಲಾ; ತ್ಯವ್ಡಸ್ ನವ್ಹ ದೇವಾಚಿ ಆನಿ ಮಾನ್ಸಾಚಿ ದಯಾ ತ್ಯಚಿವ ಖುಬ್ ಜಾ಼ಲಿ. ");
INSERT INTO gok_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","ಸಿಸೆರ್ ತಿಬೆರಿ ಚಕ್ರವರ್ತಿಚ಼ ಪಂದ್ರಾವ ವರಿಸ್ ಜಾ಼ಲ್ಥ. ತವಾ, ಪೊಂತಿಪಿಲಾತ್ ಯುದಾಯಾಂಚಾ಼ ಅಧಿಕಾರಿ ಹುತ್ತಾ. ಹೆರೊದ್ ಗಲಿಲಾಯಾತ್ ಉಪರಾಜ. ಆನಿ ಹೆರೊದಾಚ಼ಾ ದಾಕ್ಠಾ ಬಾಹು ಪಿಲಿಪ್ ಇತುರಿಯಾ ಆನಿ ತ್ರಕೊನಿತಿ ಹೆ ದೇಸೆಂಚಾ ಉಪರಾಜಾ ಹುತ್ತಾ. ಆನಿ ಲುಸನ್ಯಾ ಅಬಿಲೆಸೆಚಾ಼ ಉಪರಾಜಾ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","ತಸಸ್ ಅನ್ನಾ ಆನಿ ಕಾಯಪ್ ಮುಖ್ಯ ಯಾಜಕ್ ಹುತ್ತ. ತವಾ ಜಕರಿಯಾಚಾ಼ ಲ್ಯೊಕ್ ಯೊಹಾನಾಲಾ ರಾನಾತ್ ದೇವಾಪ್ನಿ ಆಜ್ಞೆ ಆಲಿ ಆನಿ ಯೊಹಾನ್ ಕಡ್ಯಾತ್ನಿ ರಾಥ್ಯಾಲ್ಯಾ ಲೊಕಾತ್ನಿ ರಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","ಮಂಗ್ ಯೊಹಾನ್ ಯೊರ್ದಾನ್ ವ್ಹಾಳಚೆ ಸರ್ಬೌರ್ ಸಗ್‍ಳ್ಯಾ ಪರದೆಶಾತ್, “ಪಾಪಾಂಚಾ ಮಾಪಿಸಾಟಿ ದೇವಾಕ್ಡ ಪರ್ತುನ್ ಬಾಪ್ತಿಸ್ಮಾ ಗಿಹ್ಯಾ ವ್ಹಯಿ ” ಆಸ ಜೊ಼ರಾನಿ ಸಾಂಗಿತ್ ಫಿರತಾ, ದೇವ್ ತುಮ್ಚ ಪಾಪ್ ಮಾಪ್ಕರ್ನಾರ್ ಮನ್ಹುನ್ ಸಾಂಗಿತ್ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","ಹ್ಯ ಯೆಶಾಯ ಪ್ರವಾದಿಚಾ ಪುಸ್ತಕಾತ್ ಕಸ ಲಿವಲ್ಯಾಲಹಾ ತಸಸ್ ಜಾ಼ಲ ತ್ಯ ಆಸಹಾ. ಕೊನ್ ಯೊಕ್ ರಾನಾತ್ ವರಾಡ್‌ತ್ಯಾಲಾ ಆವಾಜ಼್ ಹಾ, “ಪ್ರಭುಚಾ಼ ಮಾರ್ಗ ತಯಾರ್ ಕರಾ, ತ್ಯಚಾ ವಾಟಾ ನಿಟ್ ಕರಾ, ");
INSERT INTO gok_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","ಪರ್ತೆಕ್ ಖನ್ ಮುದ್ನಾರ್, ಪರ್ತೆಕ್ ಕನ್ನ ಆನಿ ಗುಢ ಶಾರಕ ವ್ಹನಾರ್, ವಾಕ್‍ಡ್ಯಾ ವಾಟಾ ಸಗ್‌ಳ್ಯಾ ನಿಟ್ ವ್ಹನಾರ್, ಡಬ್ರ ಪಡ್‌ಲ್ಯಾಲ್ಯಾ ವಾಟಾ ಸಪ್ಪಯ್ ವ್ಹನಾರ್, ");
INSERT INTO gok_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","ಆನಿ ಸಗ್ಳಿ ಮಾನ್ಸ ದೇವಾನಿ ಕೆಲ್ಯಾಲಿ ಸುಟ್ನುಕ್ ಬಗ್ನಾರ್, ");
INSERT INTO gok_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","ತವಾ ತಿ ಲೊಕ ತ್ಯಚಾ ಹಾತಾನಿ ಬಾಪ್ತಿಸ್ಮಾ ಗಿಹ್ಯಾಸಾಟಿ, ತ್ಯಚಿಕ್ಡ ಯಯಿತ್ಆಸ್ತಾನಾ ತ್ಯನಾ ಯೊಹಾನ್ ಆಸ ಮನ್ಲಾ “ಯೇ ಸಾಪಾಂಚೆ ಪಿಳ್ಗಿನು ಹಾಸ್ಸಾ! ಮೊರ‍್ಹ ದಿಸುನ್ ಯತ್ಯಾಲ್ಯಾ ದೇವಾಚಾ ರಾಗಾತ್ನಿ ಚು಼ಕುವುನ್ ಗಿಹ್ಯಾ ತುಮಾನಾ ಕುನಿ ಜಾ಼ಗೃತ್ ಕಿಲಿತ? ");
INSERT INTO gok_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","ತಸ ಜಾ಼ಲ್ಯಾಲ್ಯಾ ತುಮ್ಚ ಮನ್ ದೇವಾಕ್ಡ ಪರಾತ್‍ಲ್ಯಾ ಮನ್ಹುನ್ ತುಮ್ಚಾ ಚಾ಼ಂಗಲ್ಯಾ ಕಾಮಾಂಚಾನಿ ದಾವಾ ಅಬ್ರಹಾಮ್ ಆಮಚಾ಼ ವಡಿಲ್ ಮನ್ಹು‍ನ್ ತುಮಿ ಬಡಾಯಿ ಕರುನಕೊಸಾ. ದೇವ್ ಅಬ್ರಮಾಲಾ ಹ್ಯಾ ದೊಂಡ್ಯಾಂಚಾನಿ ಪೊರ ದಿವು ಸಕ್ತೊ ಮನ್ಹುನ್ ತುಮಾನಾ ಸಾಂಗ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","“ಆತಾಸ್ ಜ಼ಾಢಾಚಾ ಬುಡ್‍ಖ್ಯಾತ್ ಕುರ‍್ಯಾಡ್ ಗ್ಯಾತ್ಲೆ, ಚಾ಼ಂಗ್ಲ ಪೀಕ್ ದಿಯಿತ್ ನಸಲ್ಯಾಲಿ ಸಗ್ಳಿ ಜಾ಼ಢ ತುಡುನ್ ಇಸ್‌ಥ್ಯಾತ್ ಗ್ಯಾಲ್ನಾರ್” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","ತವಾ ತ್ಯಾ ಲೊಕಾಂಚಾನಿ ತ್ಯಲಾ “ತಸ ಜಾ಼ಲ್ಯಾ ಆಮಿ ಕ್ಯಾ ಕರಾ ವ್ಹಯಿ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","ತವಾ ಯೊಹಾನಾನಿ ತ್ಯನಾ ಉತ್ತರ್ ದಿಲಾ, “ತುಮ್ಚಿಪ ದೊನ್ ಆಂಗ್ಯಾ ಆಸ್‌ಲ್ಯಾಲ್ಯಾನಿ ಕುನಾಲಾ ಅಂಗಿ ನಸ್ನಾರ‍್ಯಾಲಾ ಏಕ್ ದೇವಾವ. ಆನಿ ಕಚಾಪ ಆನ್ ಹಾ, ತ್ಯನಿ ಆನ್ ನಸನಾರ‍್ಯಾಲಾ ಖಾಯಾ ದೇವಾವ” ಮನ್ಹುನ್ ತ್ಯನಾ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","ಜ಼ಕದಾರ್ ಸಾಹಿತ್ ಬಾಪ್ತಿಸ್ಮಾ ಗಿಹ್ಯಾವ್ಹಯಿ ಮನ್ಹುನ್ ಯವುನ್ ಪ್ರಭು “ಆಮಿ ಕ್ಯಾ ಕರಾವ್ಹಯಿ; ಮನ್ಹುನ್ ಯೊಹಾನಾಲಾ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","ತವಾ ಯೊಹಾನ್ ತ್ಯನಾ “ಥರಿವ್‌ಲ್ಯಾಲೆ ಕಿಮ್ತಿವ್ನಿ ಆಗಾವ್ಚ಼ ಕಾಯ್ ವಡುನ್ ಗಿಹುನಕೊಸಾ” ಮನ್ಹುನ್ ತ್ಯನಾ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","ಥೊಡ್ಯಾ ಸಿಪಾಯಿಂಚಾನಿ ಯವುನ್ “ಆಮಿ ಕ್ಯಾ ಕರಾವಮನ್ಹೂನ್ ತ್ಯಲಾ ಇಚಾರ್ಲ. ತವಾ ಯೊಹಾನ್ ತ್ಯನಾ “ಕುನಾಲಾ ತರಿ ಬುಜುವುನಕೋಸಾ, ಕುನಾವಬಿ ಲಬಾಡ್ ಚು಼ಕ್ ವಾವುನಕೋಸಾ ಆನಿ ಅನ್ಯಾಯಾನಿ ಪೈಸ ಕಾಡುನ್ ಗಿಹುನಕೊಸಾ ತುಮ್ಚೆ ಕುಲಿತ್ ತುಮಿ ಸಮಾದಾನಾನಿ ರಾವ್ಹಾ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","ಆಸ ಆಸ್ಥಾನಾ ಇಸ್ರಾಯಲ್ ಲೊಕ ಯನಾರ‍್ಯಾ ಕ್ರಿಸ್ತಾಚಿ ವಾಟ್ ಬಗಿತ್ ಹುತ್ತಿತ. ಮನ್ಹುನ್ ತೀ ಸಗ್ಳಿ ಯೊಹಾನಾಚೆ ಗುಶ್ಟಿತ್ “ಹ್ಯೊಚ್ ತ್ಯೊ ಕ್ರಿಸ್ತ್ ಆಸಲ್ ಕ್ಯಾ ಕುನಾಲಾ ಠಾವಾ” ಮನ್ಹುನ್ ಆಪ್‍ಲ್ಯಾ ಮನಾತ್ನಿ ಇಚಾರ್ ಕರಿತಿತ. ");
INSERT INTO gok_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","ತವಾ ಯೊಹಾನ್ ತ್ಯನಾ ಸಗ್‍ಳ್ಯಾನಾ, “ಮಿ ತರಿ ತುಮಾನಾ ಪಾನ್ಯಾನಿ ಬಾಪ್ತಿಸ್ಮಾ ದೇನಾರಾ; ಖರ ಮಾಜಿವ್ನಿ ಮೊಟಾ ಯನಾರ್, ತ್ಯಚೆ ವ್ಹಾನಚಾ ಪಟಾ ಸೊಡಾಯಾ ಮಿ ಲಾಯಕ್ ನಾಹಿ ನವ್ಹ. ತ್ಯೊ ಪವಿತ್ರಾತ್ಮಾನಿ ಆನಿ ಇಸ್‍ತ್ಯಾನಿ ತುಮಾನಾ ಬಾಪ್ತಿಸ್ಮಾ ದೇನಾರ್. ");
INSERT INTO gok_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","ತ್ಯನಿ ಸೂಪ್ ಹಾತಾತ್ ದರ್‌ಲ್ಯಾ; ಆಪ್‌ಲ್ಯಾ ಖಳ್ಯಾತ್ಲಿ ರ‍್ಯಾಸ್ ವಾರ‍್ಯಾ ಕರುನ್ ಬರಿ ಕರುನ್ ಗಹು ಕಳಂಜಾ಼ತ್ ಬರ‍್ಹುನ್ ಥೆವ್ನಾರ್, ವ್ಹಟ್ ಇಜ಼ತ್ ನಸ್‍ಲ್ಯಾಲ್ಯಾ ಇಸ್‌ಥ್ಯಾನಿ ಜಾಳನಾರ್” ಮನ್ಹುನ್ ಉತ್ತರ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","ಆನಿ ಖುಬ್ ತರನಿ ಯೊಹಾನ್ ಇಸ್ರಾಯೆಲ್ ಲೊಕಾನಾ ಬುದಿ ಸಾಂಗುನ್ ಬರಿ ಖಬರ್ ಸಾಂಗಿತಾ. ");
INSERT INTO gok_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","ಯೊಹಾನಾನಿ ಹೆರೊದಾಲಾ ಖಡ್ಯಾವ್ಲಾ ಕಾ ಮಂಜೆ ತ್ಯೊ ಆಪ್‌ಲ್ಯಾ ಬಾವ್ಹಾಚಿ ದನ್ಗರ್ ಹೇರೊದಿಯಾಸಂಗ ಅನೈತಿಕ ಸಮಂದ್ ಹುತ. ಆನಿ ದಿಸರಿ ಬುರ್ಸಿ ಕಾಮ ಖುಬ್ ಕಿಲಿತ. ");
INSERT INTO gok_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","ಹೆರೊದಾಲಾ ಯೊಹಾನ್ ದಪಕ್ಯಾವಿತ್ ಹುತ್ತಾ. ಮನ್ಹುನ್ ಯೊಹಾನಾಲಾ ಹೆರೊದಾನಿ ಕುಂಡುನ್ ಥೆವ್ಲಾ ಆನಿ ಆಪ್‍ಲ್ಯಾ ವಾಯಿಟ್ ಕಾಮಾಚಾ ಇಸೊಬ್ ಜಾಸ್ತಿಕೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","ಲೊಕಾಂಚಾನಿ ಯೊಹಾನಾಪ್ನಿ ಬಾಪ್ತಿಸ್ಮಾ ಗೆತ್ಲಿ ತವಾ ಯೇಸುನಿ ದಿಕಿಲ್ ಬಾಪ್ತಿಸ್ಮಾ ಗಿತ್ಲಿ ತವಾ ಯೇಸು ಮಾಗ್ನ ಕರ್ತಾನಾ ಆಬಾಳ್ ಉಗಾಡ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ಆನಿ ಪವಿತ್ರಾತ್ಮ ಪ್ಯಾರ್‌ವ್ಯಾಚೆಗತ್ ವ್ಹವುನ್ ಯೇಸುವ ಉತ್ತಾರ್ಲ. ತವಾ “ತು ಮಾಜಾ಼ ಮಾಯೆಚಾ಼ ಲ್ಯೊಕ್, ತು ಮಾಜಾ ಮನಾತ್ ಬರಲ್ಯಾಸ್” ಮನ್ಹುನ್ ಸ್ವರ್ಗಾತ್ನಿ ಸಬ್ದ ಆಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","ಯೇಸುನಿ ಉಪದೆಸ್ ಸುರು ಕೆಲಾ ತವಾ ಹಿಕ್ಡ ತಿಕ್ಡ ತೀಸ್ ವರ್ಸಾಚಾ಼ ಹುತ್ತಾ. ತ್ಯೊ ಲೊಕಾಂಚೆ ಇಸಾಬಾನಿ ಯೊಸೆಪಾಚಾ ಲ್ಯೊಕ್ ಯೊಸೆಪ್ ಹೆಲಿಚಾ ಲ್ಯೊಕ್; ");
INSERT INTO gok_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ಹೆಲಿ ಮಥಾತಾಚಾ ಲ್ಯೊಕ್. ಹ್ಯೊ ಮಥಾತಾ ಲೆವಿಚಾ ಲ್ಯೊಕ್. ಹ್ಯೊ ಮೆಲ್ಕಿಚಾ ಲ್ಯೊಕ್. ಹ್ಯೊ ಜನ್ನಾಯಾಚಾ಼ ಲ್ಯೊಕ್. ಹ್ಯೊ ಯೊಸೆಪಾಚಾ ಲ್ಯೊಕ್. ");
INSERT INTO gok_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ಹ್ಯೊ ಮಥತಿಚಾ ಲ್ಯೊಕ್. ಹ್ಯೊ ಆಮೊಸಾಚಾ಼ ಲ್ಯೊಕ್; ಹ್ಯೊ ನಹುಮಾಚಾ ಲ್ಯೊಕ್; ಹ್ಯೊ ಎಸ್ಲಿಚಾ಼ ಲ್ಯೊಕ್; ");
INSERT INTO gok_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ಹ್ಯೊ ನಗ್ಗಾಯಾಚಾ ಲ್ಯೊಕ್; ಹ್ಯೊ ಮಹಾಥಾಚಾ ಲ್ಯೊಕ್; ಹ್ಯೊ ಮಥತಿಚಾ ಲ್ಯೊಕ್; ಶಿಮಿಚಾ ಲ್ಯೊಕ್; ಹ್ಯೊ ಜೋಸೆಸಾ ಲ್ಯೊಕ್; ");
INSERT INTO gok_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ಹ್ಯೊ ಯುದಾಚಾ ಲ್ಯೊಕ್; ಹ್ಯೊ ಜೊನಾಚಾ಼ ಲ್ಯೊಕ್; ಹ್ಯೊ ರೇಸಾಸಾ ಲ್ಯೊಕ್; ಜೆರುಬಾಬೆಲಾಚಾ ಲ್ಯೊಕ್; ಹ್ಯೊ ಸಲಥಿಯಲಾಚಾ ಲ್ಯೊಕ್; ಹ್ಯೊ ಸೆರಿಯಾಚಾ ಲ್ಯೊಕ್; ಹ್ಯೊ ಮೆಲ್ಕಿಯಾಚಾ ಲ್ಯೊಕ್; ");
INSERT INTO gok_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ಹ್ಯೊ ಅದ್ದಿಚಾ಼ ಲ್ಯೊಕ್; ಕೊಸಾಮಾಚಾ ಲ್ಯೊಕ್; ಹ್ಯೊ ಎಲ್ಮಿದಾಚಾ ಲ್ಯೊಕ್; ಹ್ಯೊ ಎರಾಚಾ಼ ಲ್ಯೊಕ್; ");
INSERT INTO gok_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ಹ್ಯೊ ಜೊಹೊಶುಚಾ಼ ಲ್ಯೊಕ್; ಹ್ಯೊ ಎಲಿಯೆಜರಾಚಾ಼ ಲ್ಯೊಕ್; ಹ್ಯೊ ಜೊರೈಮಾಚಾ಼ ಲ್ಯೊಕ್; ಹ್ಯೊ ಮಥಾತಾಚಾ಼ ಲ್ಯೊಕ್; ಹ್ಯೊ ಲೇವಿಚಾ಼ ಲ್ಯೊಕ್; ");
INSERT INTO gok_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ಹ್ಯೊ ಸಿಮೊನಾಚಾ಼ ಲ್ಯೊಕ್; ಹ್ಯೊ ಯುದಾಚಾ಼ ಲ್ಯೊಕ್; ಹ್ಯೊ ಯೊಸೆಪಾಚಾ಼ ಲ್ಯೊಕ್; ಯೊನಾಮಾಚಾ಼ ಲ್ಯೊಕ್; ಹ್ಯೊ ಎಲಿಕಿಮಾಚಾ಼ ಲ್ಯೊಕ್; ");
INSERT INTO gok_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ಹ್ಯೊ ಮಲೆಯಾಚಾ಼ ಲ್ಯೊಕ್; ಹ್ಯೊ ಮನ್ನಾಚಾ ಲ್ಯೊಕ್; ಮಥಾಥಚಾ ಲ್ಯೊಕ್; ಹ್ಯೊ ನಾತನಾಚಾ ಲ್ಯೊಕ್; ಹ್ಯೊ ದಾವಿದಾಚಾ ಲ್ಯೊಕ್; ");
INSERT INTO gok_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ಹ್ಯೊ ಯೆಸಿಯಾಚಾ಼ ಲ್ಯೊಕ್; ಹ್ಯೊ ಜಬೆದಾಯಾಚಾ ಲ್ಯೊಕ್; ಹ್ಯೊ ಬೋವಜಾ಼ಚಾ ಲ್ಯೊಕ್; ಸಲ್ಮೊನಾಚಾ ಲ್ಯೊಕ್; ನಹಸ್ಸೊನಾಚಾ ಲ್ಯೊಕ್; ");
INSERT INTO gok_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ಹ್ಯೊ ಅಮಿನಾದಾಬಾಚಾ ಲ್ಯೊಕ್; ಹ್ಯೊ ಅರನೈಯಾಚಾ ಲ್ಯೊಕ್; ಹೆಸ್ರೋನಾಚಾ ಲ್ಯೊಕ್; ಹ್ಯೊ ಪರೆಸಾಚಾ ಲ್ಯೊಕ್; ");
INSERT INTO gok_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ಹ್ಯೊ ಜು಼ದಾಚಾ ಲ್ಯೊಕ್; ಹ್ಯೊ ಯಾಕೊಬಾಚಾ಼ ಲ್ಯೊಕ್; ಹ್ಯೊ ಇಸಾಕಾಚಾ ಲ್ಯೊಕ್; ಹ್ಯೊ ಅಬ್ರಹಾಮಾಚಾ ಲ್ಯೊಕ್; ಹ್ಯೊ ತೇರಹಾಚಾ಼ ಲ್ಯೊಕ್; ಹ್ಯೊ ನಹೋರಾಚಾ ಲ್ಯೊಕ್; ");
INSERT INTO gok_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ಹ್ಯೊ ಸೆರುಗಾಚಾ ಲ್ಯೊಕ್; ಹ್ಯೊ ರೆಗುವಾಚಾ ಲ್ಯೊಕ್; ಹ್ಯೊ ಪೆಲೆಗಾಚಾ ಲ್ಯೊಕ್; ಹ್ಯೊ ಹೆಬೆರಾಚೆ ಲ್ಯೊಕ್; ಹ್ಯೊ ಸಾಲಾಚಾ ಲ್ಯೊಕ್; ");
INSERT INTO gok_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ಹ್ಯೊ ಕಾಯಿನಾಚಾ಼ ಲ್ಯೊಕ್; ಹ್ಯೊ ಅರ್ಪಕ್ಷಚಾ಼ ಲ್ಯೊಕ್; ಹ್ಯೊ ಶೇಮನಾಚಾ಼ ಲ್ಯೊಕ್; ಹ್ಯೊ ನೊಹನಾಚಾ಼ ಲ್ಯೊಕ್; ಹ್ಯೊ ಲಾಮೆಕಾಚಾ಼ ಲ್ಯೊಕ್; ");
INSERT INTO gok_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ಹ್ಯೊ ಹನೊಕಾಚಾ ಲ್ಯೊಕ್; ಹ್ಯೊ ಜೆರೆದಾಚಾ಼ ಲ್ಯೊಕ್; ಹ್ಯೊ ಮಹಲಲೇಲಾಚಾ ಲ್ಯೊಕ್; ಹ್ಯೊ ಕಯಿನಾಚಾ಼ ಲ್ಯೊಕ್; ");
INSERT INTO gok_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ಹ್ಯೊ ಯೆನೊಶನಾಚಾ ಲ್ಯೊಕ್; ಹ್ಯೊ ಸೇಥನಚಾ ಲ್ಯೊಕ್; ಹ್ಯೊ ಆದಾಮಾಚಾ಼ ಲ್ಯೊಕ್; ಆದಾಮ್ ದೇವಾಚಾ ಲ್ಯೊಕ್. ");
INSERT INTO gok_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","ಯೇಸು ಪವಿತ್ರಾತ್ಮಾನಿ ಬರ‍್ಹುನ್ ಯೊರ್ದಾನ್ ನ್ಹತ್ನಿ ಪರಾತ್ಲಾ. ಆನಿ ತ್ಯಲಾ ಆತ್‌ಮ್ಯಾನಿ ಕಡ್ಯಾತ್ ರಾಥ್ಯಾಲ್ಯಾ ಲೊಕಾಪ್ನಿ ನೆಲಾ; ");
INSERT INTO gok_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","ತಿಥ ಸೈತಾನಾನಿ ಚಾಳಿಸ್ ದಿಸ್ ತ್ಯಚಿ ಪರಿಕ್ಷೆ ಕಿಲಿ. ತ್ಯಾ ದೀಸಾತ್ ಯೇಸುನಿ ಕಾಯ್ ಖಾಲನಾಹಿ. ತೇ ದೀಸ್ ಸಪ್‌ಲ್ಯಾವರ್, ತ್ಯಲಾ ಖುಬ್ ಭುಕ್ ಲಾಗ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","ತವಾ ಸೈತಾನ್ ಯೇಸುಲಾ ಮನ್ಲಾ. “ತು ದೇವಾಚಾ಼ ಲ್ಯೊಕ್ ಹಾಸ್ತ ಹ್ಯಾ ದೊಂಡ್ಯಾಚಾ ಬಾಖರ‍್ಯಾ ಹೊ ಮನ್ಹುನ್ ಸಾಂಗ್. ” ");
INSERT INTO gok_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","ತ್ಯಲಾ ಯೇಸು “ಮಾನುಸ್ ನಿಸ್ತೆ ಬಾಕ್ರಿನಿ ಜ಼ಗತ್ ನಾಹಿ, ಆಸ ಮೋಸೆಚಾ ಧರ್ಮಶಾಸ್ತಾರಾತ್ ಲಿವ್‌ಲ್ಯಾ” ಮನ್ಹುನ್ ಜ಼ಬಾಬ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","ಮಂಗ್ ಸೈತಾನಾನಿ ಯೇಸುಲಾ ಮೊಟ್ಯಾ ಗುಢ್ಯಾವ ನಿಹುನ್ ಪರಪಂಚಾತ್ಲ ರಾಜೆ ಸಗ್ಳ ಯಂಗ್ದಾಸ್ ದಾವುನ್; ");
INSERT INTO gok_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","ಹ್ಯಂಚಿವ್ಲಾ ಸಗ್ಳಾ ಅಧಿಕಾರ್ ಆನಿ ಹ್ಯಂಚಾ಼ ವೈಭವ್ ಮನಾ ದಿಲ್ಯಾಲಹಾ ಹ್ಯ ಮಿ ಮಾಜಾ ಮನಾಸ್ ಯಯಿಲ್‌ತ್ಯಲಾ ದೆತೊ. ");
INSERT INTO gok_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","ಮನ್ಹುನ್ “ಯೇಸುಲಾ ತು ಮನಾ ಆರಾದನ್ ಕೆಲ್ಯಾವ ಮಿ ಹ್ಯ ಸಗ್ಳ ತುಲಾ ದಿಯಿನ್” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","ತವಾ ಯೇಸುನಿ ತ್ಯಲಾ ಉತ್ತರ್ ದಿಲಾ “ಪ್ರಭು ತುಜಾ಼ ದೇವ್ ತ್ಯಲಾ ಆರಾದನ್ ಕರ್ ಆನಿ ತ್ಯಚಾ ಪಾಯಾ ಪಡ್ ಆಸ ಮೋಸೆಚಾ ಧರ್ಮಶಾಸ್ತಾರಾತ್ ಲಿವ್‍ಲ್ಯಾಲಹಾ” ಮನ್ಲಾ ");
INSERT INTO gok_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","ಮಂಗ್ ಸೈತಾನಾನಿ ಯೇಸುಲಾ ಯೆರುಸಲೇಮಿತ್ ದೇವ್ಳಾಚಾ ಟೊಕಾವ ನಿಹುನ್ ತು ದೇವಾಚಾ಼ ಲ್ಯೊಕ್ ಆಸ್ಲಾಸ್ತ ಹಿತ್ನಿ ಖಾಲ್ ಉಡಿ ಮ್ಯಾರ್. ");
INSERT INTO gok_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","ತುಲಾ ರಕ್ಶನ್ ಕರಾಲಾ ದೇವ್ ಆಪ್‌ಲ್ಯಾ ಧುತಾನಾ ತುಜೆಯಸಿ ಆಜ್ಞಾ ದಿಯಿಲ್ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ಆನಿ ತುಜ಼ ಪ್ಯಾ ದೊಂಡ್ಯಾವ ಆಪ್ಟು ನಾಹಿ ಮನ್ಹುನ್ ತೇ ತುಲಾ ಹತಾತ್ ಜಾ಼ಖುನ್ ದರ್ಥಿಲ ಆಸ ಮೋಸೆಚಾ ಧರ್ಮಶಾಸ್ತಾರಾತ್ ಲಿವ್‍ಲ್ಯಾಲಹಾ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","ತವಾ, ““ತುಜಾ಼ ದೇವ್‍ ಜ಼ಾಲ್ಯಾಲ್ಯಾ ಪ್ರಭುಚಿ ಪರಿಕ್ಷಾ ಕರು ನಕೊಸ್” ಆಸ ಮೊಸೇಚಾ ಧರ್ಮಶಾಸ್ತಾರಾತ್ ಲಿವ್‌ಲ್ಯಾಲಹಾ ಮನ್ಹುನ್ ಯೇಸುನಿ ಸೈತಾನಾಲಾ ಉತ್ತರ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","ಮಂಗ್ ಸೈತಾನ್ ಸಗ್‌ಳ್ಯಾ ಪರಿಕ್ಷಾ ಸುಪುನ್ ಥೊಡಾ ಯೊಳ್ ಯೇಸುಲಾ ಸುಡುನ್ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","ಮಂಗ್ ಯೇಸು ಪವಿತ್ರಾತ್ಮಾಚಾ ಬಳಾನಿ ಬರ‍್ಹುನ್ ಗಲಿಲಾಯ್ ಸಿಮತ್ ಆಲಾ ಆನಿ ತ್ಯಚಿ ಕಿರ್ತಿ ತಿತ್ಲೆ ದುನೆತ್ ಪಗಾಳಿ. ");
INSERT INTO gok_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","ಯೇಸು ತ್ಯಂಚಾ ಆರಾದನೆಚಾ ಜಾ಼ಗ್ಯಾವ ಉಪದೆಸ್ ದಿಯಿತಾ ಆನಿ ಸಗ್ಳಿ ಲೊಕ ತ್ಯಲಾ ವವ್ಯಾಳಿತಿತ. ");
INSERT INTO gok_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","ಮಂಗ್ ಯೇಸು ನಾನ್ಹಾಚಾ ಥೊರ್‌ಜಾ಼ಲ್ಯಾಲೆ ನಜರೆತಿತ್ ಆಲಾ ಆನಿ ಆಪ್ಲೆ ಪದ್ದತಿ ಶಾರ್ಕ ಸಬ್ಬತ್ ದಿಸಾದಿಸಿ ಆರಾದನೆಚಾ ಜಾ಼ಗ್ಯಾವ ಜಾ಼ವುನ್ ಪುತೀಕ್ ವಾಚವಾಯಾ ಉಬಾರಾಯಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ತವಾ ಪ್ರವಾದಿ ಯೆಶಾಯಚ಼ ಗ್ರಂಥ ತ್ಯಲಾ ವಾಚವಾಯ ದಿಲ ಯೇಸುನಿ ತ್ಯ ಉಗ್ಡುನ್ ವಾಚಿವ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","ತಿಥ ಆಸ ಲಿವ್ಲ ಹುತ್ತ “ಪ್ರಬುಚ಼ ಆತ್ಮ ಮಾಜಿ಼ವ ಹಾ. ತ್ಯನಿ ಮನಾ ಗರಿಬಾನಾ ಬರಿ ಖಬರ್ ಸಾಂಗಾಯಾ ಥರಿವ್‌ಲ್ಯಾ. ದರುನ್ ನೆಲ್ಯಾಲ್ಯಾನಾ ಸೊಡಾಯಾ ಆನಿ ಅಂದ್‌ಳ್ಯಾನಾ ಡೊಳ್ಯಾನಿ ದಿಸಶಾರ್ಕ ಕರಾಯಾ. ಮನ್ ಮೊಡ್‌ಲ್ಯಾಲಾನಾ ಸುಡುನ್ ಲಾವುನ್ ದಿಯಾ. ");
INSERT INTO gok_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ಪ್ರಭುನಿ ಆಪ್‌ಲ್ಯಾ ಲೊಕಾನಾ ಸೊಡ್ವಾಯಾ ಯೊಳ್ ಆಲ್ಯಾ ಮನ್ಹುನ್ ಸಾಂಗಾಯಾ ಮನಾ ಲಾವುನ್ ದಿಲ್ಯಾ. ಮನ್ಹುನ್ ");
INSERT INTO gok_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","ಮನ್ಹುನ್ ಯೇಸುನಿ ತ್ಯಾ ಗ್ರಂಥಾಚಿ ಇಡಿ ಕರುನ್ ಸೇವಕಾಪ ದಿವುನ್ ತ್ಯೊ ಖಾಲ್ ಬಸ್ಲಾ ಆನಿ ಆರಾದನೆಚಾ ಜಾ಼ಗ್ಯಾವಲ್ಯಾ ಸಗ್‍ಳ್ಯಾ ಲೊಕಾಂಚಿ ನದಾರ್ ಯೇಸುವ ಹುತ್ತಿ. ");
INSERT INTO gok_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","ಯೇಸುನಿ ತ್ಯನಾ ಸಾಂಗ್‌ಲ್ಯಾಲ ಕ್ಯಾ ಮನ್‌ಲ್ಯಾವ, “ಮಿ ಆತಾ ವಾಚಿವ್‌ಲ್ಯಾಲ ಹ್ಯ ಸಬಾತ್ ತುಮಿ ಆಯಿಕ್ಲಸಾ ತವಾಸ್ ತೇ ಪುರ ಜಾ಼ಲ!” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","ತವಾ ಲೊಕ ಸಗ್ಳಿ ತ್ಯಲಾ ವವ್ಯಾಳುನ್ ತ್ಯನಿ ಸಾಂಗ್‍ಲ್ಯಾಲ ಚಾ಼ಂಗ್ಲ ಸಬ್ದಾನಾ ಸಾಹಿತ್ ಆಜಾಬ್ ಜಾ಼ಲಿತ ಆನಿ ಹ್ಯೊ ಆಸ ಕಸಾ ಬೊಲ್ತೊ? ಹ್ಯೊ ಯೊಸೆಪಾಚಾ಼ ಲ್ಯೊಕ್ ನವ್ಹ ಕ್ಯಾ? ಮನ್ಹಾ ಲಾಗ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","ತ್ಯೊ ತ್ಯನಾ ಮನ್ಲಾ, “ಖರ‍್ಯಾನಿಸ್ ತುಮಿ ಜು಼ನ್ನ ಮ್ಹನ ಮನಾ ಲಾಗು ಕರ್ನಾರ್ ಯೇ ವೈದ್ಯಾ ತು ತುಲಾಸ್ ಬರಕರ್’ ಕಪೆರ್ನೌಮತ್ ಜೆ ಗುಶ್ಟಿ ತು ಕೆಲ್ಯಾಸ್ ತ್ಯಾ ಆಮಿ ಐಕ್‍ಲ್ಯಾತಾ ತ್ಯಾ ಹಿತಬಿ ಆಮ್ಚಾ ಗಾವಾತ್ ಕರ್. ” ");
INSERT INTO gok_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","ಯೇಸು ತ್ಯನಾ ಮನ್ಲಾ, ಖರ‍್ಯಾನಿ ಸಾಂಗ್ತೊ ಕಚಾ಼ಸ್ ಪ್ರವಾದಿಲಾ ಆಪ್‌ಲ್ಯಾ ಸ್ವತಾಚಾ ಗಾವಾತ್ ಮರ‍್ಯಾದ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","ಆನಿ “ಮಿ ತುಮಾನಾ ಖರ ಸಾಂಗ್ತೊ ಯಲಿಯಾಚಾ, ಕಾಲಾತ್ ಸಾಡತೀನ್ ವರ್ಸ ಆಬಾಳ್ ಬಂದ್ರಾಹುನ್ ಸಗ್ಳೆ ದೇಶೆತ್ ಪಾವುಸ್ ಲಾಗಾಚೆಆಂದಿ ಬರ್ಗಾಲ್ ಪಡ್ಲಹುತ್ತ. ತ್ಯಾ ಕಾಲಾತ್ ಇಸ್ರಾಯಲಾತ್ ಕಿತೀಕಿ ವಿದ್ವಾ ಹುಥ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","ಫನ್ ತ್ಯಾತ್ಲೆ ಯಕಿಪಬಿ ಯಲಿಯಾಲಾ ಲಾವುನ್ ದಿಲಾ ನವಥಾ; ಖರ ಸಿದೊನ್ ಪರದೇಶಾತ್ಲೆ ಸರೆಪತ್ ಗಾವಾತ್ಲೆ ಯಕ ವಿದವೆಪ ತ್ಯವ್ಡಾಸ್ ಲಾವುನ್ ದಿಲಾಹುತ್ತಾ. ” ");
INSERT INTO gok_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","ಆನಿ ಎಲಿಶ್ “ಪ್ರವಾದಿಚಾ ಕಾಲಾತ್ ಇಸ್ರಾಯಲ್ ದುನಿಯಾತ್ ಕಿತಿತರಿ ಲೊಕ ಕುಶ್ಟ ರೊಗಾಚಿ ಹುತ್ತಿತ. ಫನ್ ತ್ಯಾತ್ಲ ಯೊಕ್ಬಿ ಶುದ್ದ ವ್ಹಯಾಚೆ ಆಂದಿ ಸಿರಿಯಾ ದೆಶೆತ್ಲಾ ನಾಮನ್ ತ್ಯವ್ಡಾಸ್ ಬರಜಾ಼ಲ್ಹಾ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","ಸಭಾಸ್ಥಾನತ್ಲಿ ಲೊಕ ಸಗ್ಳಿ ಹೆ ಸಬ್ದ ಐಕುನ್ ಖುಬ್ ರಾಗ್ ಕರುನ್ ");
INSERT INTO gok_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","ಉಠುನ್ ಯೇಸುಲಾ ಗಾವಾತ್ನಿ ಬಾಹಿರ್ ಗಾಲುನ್ ತ್ಯಂಚಾ ಗಾವ್‍ ಬ್ಯಾಂದ್‌ಲ್ಯಾಲ್ಯಾ ಗುಢ್ಯಾ ವರ್ ನಿಹುನ್ ಡಕ್ಲುನ್ ಗಾಲ್ಹಾಹ್ವಯಿ ಮನ್ಹಿತಿತ. ");
INSERT INTO gok_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","ಖರ ತ್ಯೊ ತ್ಯಂಚೆ ಮದ್ನಿ ನಿಗುನ್ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","ಯೇಸು ಗಲಿಲಾಯಾತ್ ಉತುರುನ್ ಗಲಿಲಾಯಾತ್ಲೆ ಕಪೆರ್ನೌಮ ಗಾವಾತ್ ಗೆಲಾ ತಿಥ ಸಬ್ಬತ್ ದಿಸಾತ್ ತ್ಯನಾ ಶಿಕ್ಶನ್ ದಿಯಿತ್ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","ತ್ಯಚ಼ ಶಿಕ್ಶನ್ ಐಕುನ್ ತೇ ಖುಬ್ ಆಜಾಬ್ ಜಾ಼ಲ ಕಾ ಮಂಜೆ ತ್ಯಚ಼ ಬೋಲ್ನ ಅಧಿಕಾರಾಚ಼ ಹುತ್ತ. ");
INSERT INTO gok_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","ತವಾ ಲಾಗಿರ ಲಾಗ್‌ಲ್ಯಾಲಾ ಮಾನುಸ್ ಸಭಾಸ್ಥಾನಾತ್ ಹುತ್ತಾ. ತ್ಯೊ ಮೊಟ್ಯಾನಿ ವರ್ಡುನ್ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","ಆರ ನಜ಼ರೆತಿಚಾ ಯೇಸು; ತು ಆಮ್ಚೆ ಮಾಗ ಕಾ ಲಾಗ್ತೊಸ್? ತು ಆಮ್‌ಚಾ಼ ನಾಸ್ ಕರಾಯಾ ಆಲಾಸ್ ಕ್ಯಾ? ತು ಕೊನ್ ಠಾವಾ ಹಾಸ್, ತು ದೇವಾನಿ ಲಾವುನ್ ದಿಲ್ಯಾಲಾ ಪರಿಶುದ್ದ. ");
INSERT INTO gok_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","ತವಾ ಯೇಸುನಿ ತ್ಯಲಾ ದಪ್‌ಕಾವುನ್ “ಗಪ್ಚಿಪ್ ರ‍್ಹಾ ಹೆಲಾ ಸುಡುನ್ ಜಾ಼” ಮನ್ಲಾ ಲಾಗಿರ್ ತ್ಯಾ ಮಾನ್ಸಾಲಾ ತ್ಯಂಚೆ ಮದ್ದಿ ಖಾಲ್ ಅಪ್ಟುನ್ ಕಾಯ್ ತರಾಸ್ ಕರಾಚೆ ಆಂದಿ ತ್ಯಚೆ ಆತ್ನಿ ನಿಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","ತವಾ ಸಗ್ಳಿ ಹ್ಯ ಬಗುನ್ ಲೊಕ ಗಾಬ್ರುನ್ ಹ್ಯ ಕ್ಯಾ ಬೋಲ್ನ? ಹ್ಯೊ ಅಧಿಕಾರಾನಿ ಆನಿ ಬಳಾನಿ ಲಾಗಿರಾನಾ ಆಜ್ಞೆ ಕರ್ತ್ಯೊ ಆನಿ ತಿ ನಿಗುನ್ ಜಾ಼ತ್ಯಾತ ಮನ್ಹುನ್ ಯಕಾಮಕಾಲಾ ಮನ್ಹೂಲಾಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","ಆನಿ ಮಂಗ್ ಯೇಸುಚಿ ಖಬರ್ ಸರ್ಬೌತಾಚಾ ಗಾವಾತ್ನಿ ಸಗ್ಳಿಕ್ಡ ಪಗಳತ್ ಗಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","ಯೇಸು ಸಭಾಸ್ಥಾನಾತ್ನಿ ಉಠುನ್ ಸಿಮೊನಾಚಾ ಗರ‍್ಹಾತ್ ಆಲಾ, ತಿಥ ಸಿಮೊನಾಚಿ ಸಾಸೊ ಖುಬ್ ತಾಪ್ ಯವುನ್ ಪಡ್ಲಿಹುತ್ತಿ ತಿಚೆ ಸಾಟಿ ತ್ಯಚಿಪ ತ್ಯಂಚಾನಿ ಇನಂತಿಕಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","ತವಾ ಯೇಸು ತಿಚಿಪ ಉಬಾರಾಹುನ್ ತ್ಯಾ ತಾಪಾಲಾ ದಪ್‍ಕ್ಯಾವಾಲಾ ತವಾ ತಿಲಾ ತಾಪ್ ಸುಡುನ್ ಗೆಲಾ, ತವಾಸ್ ತಿನಿ ಉಠುನ್ ತ್ಯಂಚಿ ಸೆವಾ ಕಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","ಮಂಗ್ ದೀಸ್ ಮಾವಾಳ್ತಾನಾ ಕುನಾಕುನಾಚಾ ಗರಾತ್ನಿ ತರತರಾಚಾ ರೊಗಾನಿ ಆಸ್‌ಲ್ಯಾಲ್ಯಾನಾ ಲೊಕಾಂಚಾನಿ ಯೇಸುಪ ಆನ್ಲಿತ ಆನಿ ಯೇಸುನಿ ತ್ಯಂಚಾತ್‍ಲ್ಯಾ ಪರತೇಕಾವ ಹಾತ್‍ ಥೆವುನ್ ತ್ಯನಾ ಬರ ಕೆಲ ");
INSERT INTO gok_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","ತು ದೇವಾಚಾ಼ ಲ್ಯೊಕ್ ಹಾಸ್, ಆಸಿ ವರ್ಡತ್ ಲಾಗಿರ ದಿಕಿಲ್ ಖುಬ್ ಮಾನ್ಚಾತ್ನಿ ನಿಗಲಿತ ಫನ್ ಯೇಸುನಿ ಲಾಗಿರಾನಾ ದಪ್‌ಕ್ಯಾವಿತ್ ಆನಿ ಬುಲುದಿಲಿ ನಾಹಿತ ಕಾ ಮಂಜೆ ತ್ಯೊ ಕ್ರಿಸ್ತ ಮನ್ಹುನ್ ತ್ಯನಾ ಠಾವಾ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","ಮಂಗ್ ದಿಸ್ರೆ ದಿಸಿ ಯೇಸು ಲೊಕಾನಾ ಸುಡುನ್ ಯಕಾನ್ಸಿ ಗೆಲಾ ತವಾ ಲೊಕ್ ಸಮುದಾಯಾ ತ್ಯಲಾ ಸುದಿತ್ ತ್ಯಚೆ ಜ಼ವಳ್ ಆಲಿ ಆನಿ ಆಪ್ಲಿಪ್ನಿ ತ್ಯನಿ ಜಾ಼ವು ನಾಹಿ ಆಸ ತ್ಯಲಾ ಆಡ್ಯಾವುನ್ ಸರ್ಬೌರಿ ರಾಹ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","ಫನ್ ಯೇಸು ತ್ಯನಾ ಮನ್ಲಾ “ಮನಾ ಸಗ್‌ಳ್ಯಾ ಗಾವಾತ್ನಿಬಿ ದೇವಾಚಾ ರಾಜಾಚಿ ಖಬರ್ ಸಾಂಗಾಯಾ ಪಾಯ್ಜೆ ಕಾ ಮಂಜೆ ತ್ಯಚಿಸಾಟಿಸ್ ಮನಾ ಲಾವುನ್ ದಿಲ್ಯಾಲಾ ಹಾ. ” ");
INSERT INTO gok_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","ಮಂಗ್ ತ್ಯೊ ತೇ ದೇಶೆಚಾ ಸಗ್‌ಳ್ಯಾ ಸಭಾಸ್ಥಾನಾತ್ನಿ ಉಪದೆಸ್ ಕೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","ಯೇಕ್ ದೀಸ್ ಯೇಸು. ಲೊಕ್ ಸಮುದಾಯಾ ಯೇಸುಚೆ ಜ಼ವಳ ಗರ್ದಿಕರುನ್ ದೇವಾಚ಼ ಸಬ್ದ ಐಕ್ತಾ ಆಸ್ಥಾನಾ ತ್ಯೊ ಗೆನೆಜ಼ರೇತ್ ತಳಿಚೆ ದರವ ಉಬಾಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","ತವಾ ತ್ಯನಿ ತಳಿಚೆ ದರವ ಲಾಗಲ್ಯಾಲ್ಯಾ ದೊನ್‍ ವ್ಹಡ್ಯಾ ಬಗಲ್ಯಾ; ಮಾಸದರ್ಥ್ಯಾಲ ತ್ಯಾತ್ನಿ ಬಾಹಿರ್ ಯವುನ್ ಆಪ್ಲಿ ಜಾ಼ಳಿ ದುಹಿತ್ ಹುತ್ತ. ");
INSERT INTO gok_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","ತ್ಯಾ ವ್ಹಡ್ಯಾತ್ನಿ ಯೇಕ್ ವ್ಹಡಿ ಸಿಮೊನಾಚಿ ಹುತ್ತಿ. ತಿಚಿವ ಯೇಸು ಚ಼ಡುನ್ ದರ್ ಸುಡುನ್ ಜ಼ರಾ ಮೊರ‍್ಹ ರೆಟಾ ಮನ್ಹುನ್ ತ್ಯನಾ ಸಾಂಗ್ಲ; ಮಂಗ್ ತ್ಯೊ ವ್ಹಡಿತ್ ಬಸುನ್ ಲೊಕ್ ಸಮುದಾಯಾಲಾ ಶಿಕ್ಶನ್ ದಿಯಾಲಾಗ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","ಆಪ್ಲ ಬೊಲ್ನ ಸಪ್‌ಲ್ಯಾವ ಯೇಸು ಸಿಮೊನಾಲಾ ಮನ್ಲಾ, “ಖೋಲ್ ಪಾನ್ಯಾತ್ ಚ಼ಲ್ ಆನಿ ಮಂಗ್ ಮಾಸ ದರಾಯಾಸಾಟಿ ತುಮಿ ತುಮ್ಚಿ ಜಾ಼ಳಿ ಖಾಲ್ ಸೋಡಾ.” ");
INSERT INTO gok_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","ಸಿಮೊನ್ ಯೇಸುಲಾ “ಗುರು ಆಮಿ ಸಾರಿ ರ‍್ಯಾತ್ ಖುಬ್ ತರಾಸ್ ಕರುನ್ ಕಾಯೇಕ್ ಗಾವ್ಲನಾಹಿ; ಫನ್ ತುಜಾ ಸಾಂಗ್‌ನ್ಯಾನಿ ಮಿ ಜಾ಼ಳ ಶೊಡ್‌ತ್ಯೊ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","ಮಂಗ್ ತ್ಯನಿ ಆಸ ಕೇಲ್ಯಾವ ಮಾಸ ದರ್ಥ್ಯಾಲ್ಯಾಂಚಾನಿ ಮಾಶಾಂಚಿ ಮುಟಿ ರ‍್ಯಾಸ್ ಜಾ಼ಳ್ಯಾತ್ ಆಡಾಕ್ಲಿ ಆನಿ ತ್ಯಂಚಿ ಜಾ಼ಳಿ ಫಾಟ ಶಾರ್ಕಿ ಜಾ಼ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","ತವಾ ತ್ಯಂಚಾ ಸೊಪ್‌ತ್ಯಾನಾ ಸಿಮೊನಾನಿ ಯವುನ್ ಆಪ್‌ಲ್ಯಾಲಾ ಮಜ಼ತ್ ಕರಾ ಮನ್ಹುನ್ ಹಾತಾನಿ ಖುನಾ ಕಿಲಿ. ತವಾ ತೇ ಆಲ್ಯಾ ನಂತರ್ ದುನಿ ವ್ಹಡ್ಯಾಬಿ ಬರ‍್ಹುನ್ ಬುಡಾಯಾ ಜಾ಼ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","ಹ್ಯ ಬಗುನ್ ಸಿಮೊನ್ ಪೇತ್ರಾನಿ ಯೇಸುಚಾ ಪಾಯಾತ್ ಪಡುನ್ “ಪ್ರಭು ಮಾಜಿ಼ಪ್ನಿ ಜಾ಼ ಕಾ ಮಂಜೆ ಮಿ ಪಾಪಿ ಮಾನುಸ್” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","ಕಾ ಮಂಜೆ ಪೇತ್ರಾನಿ ದರ್ಲ್ಯಾಲ್ಯಾ ಮಾಶಾಂಚಿ ರ‍್ಯಾಸ್ ಬಗುನ್ ತ್ಯೊ ಆನಿ ತ್ಯಚೆ ಸಂಗ ಆಸ್‍ಲ್ಯಾಲ ಸಗ್ಳ ಸುಪ್ತಿ ಗಾಬಾರ್ಲ ಹುತ್ತ. ");
INSERT INTO gok_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","ತಸಸ್ ಸಿಮೊನಾಚ ಜೆಬೆದಾಯಾಚ಼ ಲ್ಯಾಕ್ ಯಾಕೊಬ್ ಆನಿ ಯೊಹಾನ್ ಹೆ ಸಾಹಿತ್ ಗಾಬಾರ್ಲ ಹುತ್ತ. ತವಾ ಯೇಸು ಸಿಮೊನಾಲಾ ಮನ್ಲಾ, “ಬಿಹು ನಕೊ ಹಿತ್ನಿ ಮೊರ‍್ಹ ತು ಲೊಕಾನಾ ದೇವಾಸಾಟಿ ಹಾಕಟ್ಯಾಲಾ ಕರ್ತೊ”! ");
INSERT INTO gok_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","ಮಂಗ್ ವ್ಹಡಿ ದರಲಾ ಲ್ಯಾವಲ್ಯಾ ನಂತರ್ ಸಗ್ಳ ಸುಡುನ್ ದಿವುನ್ ತೇ ಯೇಸುಚೆ ಮಾಗ್ನಿ ಗೆಲ. ");
INSERT INTO gok_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","ಯೇಸು ಯಕಾ ಗಾವಾತ್ ಆಸ್ಥಾನಾ ಆಂಗ್ ಸಗ್ಳ ಕುಶ್ಟ ರೊಗಾನಿ ಬರ್ಲ್ಯಾಲಾ ಯಕಾ ಮಾನ್ಸಾನಿ ಯೇಸುಲಾ ಬಗುನ್ ಆಡ್ವಾ ಪಡುನ್, “ಪ್ರಭು ತುಲಾ ಮನ್ ಆಸ್‌ಲ್ಯಾವ ಮನಾ ಬರ ಕರಾಯಾ ವ್ಹಯಿಲ್” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","ತವಾ ಯೇಸುನಿ ಹಾತ್ ಮೊರ‍್ಹ ಕರುನ್ ತ್ಯಲಾ ಲಾವುನ್, ಮನಾ ಮನ್ ಹಾ ಬರಾ ಹೊ ಮನ್ಲಾ. ತವಾಸ್ ತ್ಯಚಾ಼ ಕುಶ್ಟ ರೊಗ್ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","ಮಂಗ್ ಯೇಸುನಿ ತ್ಯಲಾ ಖಡ್ಯಾವುನ್ ಸಾಂಗ್ಲ, ಕುನಾಲಾ ತು ಸಾಂಗು ನಕೊಸ್ ಫನ್ ಜಾ಼ವುನ್ ಯಾಜಕಾಲಾ ತುಜ಼ ಆಂಗ್ ದ್ಯಾವ್ ಆನಿ ಮೊಶೆನಿ ಕೆಲ್ಯಾಲ್ಯಾ ನೇಮಾನಿ ಯಜ್ಞ ದಿವುನ್ ತುಜಾ಼ ಶುದ್ದಾಚಾರ್ ಕರ್ ತ್ಯ ಲೊಕಾನಾ ಸಾಕ್ಶಿ ವ್ಹವುನಿ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","ಖರ ಯೇಸುಚಿ ಖಬರ್ ಆನಿಕ್ ಖುಬ್ ಪಗಾಳಿ. ಲೊಕ ತ್ಯಚಾ ಗುಶ್ಟಿ ಐಕಾಯಾ ಆನಿ ಆಪ್ಲ ಆಪ್ಲ ರ‍್ವಾಗ್ ಬರ ಕರುನ್ ಗಿಹ್ಯಾ ಹಿಂಡ್ ಹಿಂಡಾನಿ ಜ಼ಮ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","ಫನ್ ಯೇಸು ಯಕಾನ್ಸಿ ಜಾ಼ವುನ್ ದೇವಾಪ ಮಾಗ್ನ ಕರೀತ್ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","ಯಕಸಿ ಯೇಸು ಲೊಕಾನಾ ಉಪದೆಸ್ ಕರೀತ್ ಆಸ್ಥನಾ ಗಲಿಲಾಯಾತಲ್ಯಾ ಯುದಾಯಚಾ ಸಗ್‍ಳ್ಯಾ ಗಾವಾತ್ನಿ ಯೆರುಸಲೇಮ್ ಪೆಠತ್ನಿ ಆಲ್ಯಾಲ ಫರಿಸಾಯ್ ಮೋಶೆಚಾ಼ ಧರ್ಮ ಶಾಸ್ತ್ರ ಚಾ಼ಂಗ್ಲ ಠಾವ ಆಸ್‌ಲ್ಯಾಲ ಜಾಂತ ತ್ಯಚಿಪ ಬಸ್ಲ ಹುತ್ತ. ಆನಿ ಬರ ಕರಾಯಾ ಪ್ರಭುಚ಼ ಬಳ್ ತ್ಯಚಿಪ ಹುತ್ತ. ");
INSERT INTO gok_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","ತವಾ ಥೊಡ್ಯಾ ಲೊಕಾಂಚಾನಿ ಯಕಾ ಪಾರ್ಶಿಚಾ ರೊಗಿಲಾ ಹಾತುರುನಾವ್ನಿ ಉಚ್ಲು಼ನ್ ಗಿಹುನ್ ಆನ್‌ಲ್ಹಾ. ಆನಿ ತ್ಯಲಾ ಆತ್ ನಿಹುನ್ ತ್ಯಚೆ ಮೊರ‍್ಹ ಥೆವಾಯಾ ಖಟ್ಪಪಟ್ ಕಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","ಫನ್ ಲೊಕಾಂಚೆ ಗರ್ದಿಸ್ಲಾಗುನ್ ತ್ಯಲಾ ಆತ್ ನಿಹ್ಯಾ ವಾವ್ ಗಾವನಾ ಮನ್ಹುನ್ ತ್ಯಂಚಾನಿ ಗರ‍್ಹಾವರ್ ಚ಼ಡುನ್ ಖಾಪರ‍್ಯಾ ಕಾಡುನ್ ಹಾತ್ರುನಾ ಸಾಹಿತ್ ಖೊಲ್ಯಾತ್ನಿ ಯೇಸುಚೆ ಮೊರ‍್ಹ ಖಾಲ್ ಉತ್ತರ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","ತವಾ ತ್ಯಂಚಾ ಇಸ್ವಾಸ್ ಬಗುನ್ ಯೇಸು ತ್ಯಾ ಪಾರ್ಶಿಚಾ ರೊಗಿಲಾ, “ಸೊಪ್‌ತ್ಯಾ ತುಜಿ ಪಾಪ ಮಾಪ್ ಜಾ಼ಲಿತ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","ತ್ಯಲಾ ತೆ ಜಾಂತ ಆನಿ ಫರಿಸಾಯ್ “ದೇವಾಚೆ ಆಡ್ವ ಬೋಲ್ನಾರಾ ಹ್ಯೊ ಕೊನ್? ಪಾಪ್ ಮಾಪ್ಕರ್ನಾರಾ ದೇವ ತ್ಯವ್ಡಾಸ್? ಮನ್ಹುನ್ ಇಚಾರ್ ಕರಾಯಾ ಲಾಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","ತವಾ ಯೇಸುನಿ ತ್ಯಂಚಾ಼ ಇಚಾರ್ ವಳ್ಕುನ್ ತ್ಯನಾ “ತುಮಿ ತುಮ್ಚಾ ಮನಾತ್ನಿ ಆಸ್ಲಾ ಇಚಾರ್ ಕಾ ಕರ್ತಾಸಾ? ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","ತುಜಿ ಪಾಪ್ ಮಾಪ್ ಜಾ಼ಲಿತ ಮನ್ಹಾಚ ಕ್ಯಾ? ನಾಹಿತ ರೊಗಿಲಾ ಉಠುನ್ ಚಾ಼ಲ್ ಮನ್ಹಾಚ ಹ್ಯಾತ್ಲ ಕಚ಼, ಮನ್ಹಾಚ ಸಲ್ಪ? ");
INSERT INTO gok_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","ಖರ ದರ್ಥಿವ ಪಾಪಾಂಚಿ ಮಾಪ್ಕರಾಲಾ ಮಾನ್ಸಾಚಾ ಲೇಕಾಲಾ ಹಾಕ್ ಹಾ ಹ್ಯ ತುಮಾನಾ ಸಮ್ಜಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ತ್ಯೊ ಪಾರ್ಶಿಚಾ ರೊಗಿಲಾ ಮನ್ಲಾ ಮಿ ತುಲಾ ಸಾಂಗ್ತೊ ಉಟ್ ತುಜ಼ ಹಾತ್ರುನ್ ಉಚ಼್ಲುನ್ ಗಿಹುನ್ ತುಜಾ ಗರ‍್ಹಾತ್ ಜಾ಼” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","ತ್ಯೊ ತವಾಸ್ ತ್ಯಂಚೆ ಹುಜು಼ರ್ ಉಠುನ್ ಕಸ್ಯಾ ವರ್ ತ್ಯೊ ಪಡುನ್ಹುತ್ತಾ. ತ್ಯ ಉಚ್ಲು಼ನ್ ಗಿಹುನ್ ದೇವಾಲಾ ವವ್ಯಾಳಿತ್ ಆಪ್‌ಲ್ಯಾ ಗರ‍್ಹಾತ್ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","ತವಾ ತೆ ಸಗ್ಳ ಯಗ್ದಮ್ ಗಾಬಾರ್ಲ ತೀ ಸಗ್ಳಿ ದೇವಾಚ ನಾವ್ ವವ್ಯಾಳಾಲಾಗ್ಲಾ ಆನಿ ಖುಬ್ ಬಿಹುನ್ ಆಮಿ ಆಜ಼್ ಮೊಟ್ಯಾ ಚಮತ್ಕಾರಿಚಾ ಗುಶ್ಟಿ ಬಗಲ್ಯಾ ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","ತ್ಯಾ ನಂತರ್ ಯೇಸು ಬಾಹಿರ್ ಆಲಾ ತವಾ ಲೇವಿ ನಾವಾಚಾ ಯಕಾ ಜ಼ಕತ್ದಾರಾಲಾ ಜ಼ಕತಿಚಾ ನಾಖ್ಯಾವ ಬಸ್‍ಲ್ಯಾಲಾ ಬಗ್ಲಾ ಆನಿ ತ್ಯಲಾ “ಮಾಜೆ ಮಾಗ್ನಿ ಯೇ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","ತವಾ ತ್ಯ ಸಗ್ಳ ತಿಥಸ್ ಸುಡುನ್ ದಿವುನ್ ಉಟ್ಲಾ ಆನಿ ಯೇಸುಚೆ ಮಾಗ್ನಿ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","ಮಂಗ್ ಲೇವಿನಿ ಯೇಸುಲಾ ಆಪ್‌ಲ್ಯಾ ಗರ‍್ಹಾತ್ ಮೊಟ ಜೆವಾನ್ ದಿಲತವಾ ತ್ಯಂಚೆ ಸಂಗ ಜಖತ್ದಾರ್ ಆನಿ ದುಸ್‌ರ‍್ಯಾ ಲೊಕಾಂಚಿ ಮೊಟ್ಯಾ ಸಮುದಾಯಾತ್ ಜೆವಾಯಾ ಬಸ್ಲಿಹುತ್ತಿ. ");
INSERT INTO gok_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","ತವಾ ಫರಿಸಾಯ್ ಆನಿ ಧರ್ಮ ಶಾಸ್ತ್ರಾಚ಼ ಜಾಂತ ಹೆ ಯೇಸುಚಾ ಶಿಶಾನಾ, “ತುಮಿ ಜಖತ್ದಾರ್ ಆನಿ ಖಾಯ್ಲೆ ಜಾತಿಂಚಿ ಸಂಗ ಆನಿ ಪಾಪಿಂಚೆ ಸಾಟಿ ತುಮಿ ಕಾ ಖಾತಾ ಪಿತಾಸಾ? ಮನ್ಹುನ್ ಟುರ್ಟುರಿತ ");
INSERT INTO gok_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","ಯೇಸುನಿ ತ್ಯನಾ, “ರೊಗ್ ನಸ್‍ನಾರ‍್ಯಾಲಾ ವೈದ್ಯಾಚಿ ಗರಜ಼್ ನಸ್ತಿ ಖರ ರೊಗಿಲಾ ವೈದ್ಯಾಚಿ ಗರಜ಼್ ಆಸ್ಥಿ” ಮನ್ಹುನ್ ಉತ್ತರ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","“ಮಿ ಆಲ್ಯಾಲೊ ಮರೆದಿಚಾನಾ ಪಶ್ಚಾತಾಪ್ ಪಡ್ವಾಯಾ ಸಾಟಿ ಆಲೊ ನಾಹಿ ಪಾಪಿಂಚೆ ಸಾಟಿ ಆಲ್ಯೊ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","ಫರಿಸಾಯ್ ಯೇಸುಲಾ ಮನ್ಲ, ಯೊಹಾನಾಚಾ ಶಿಶಾ ಪರ್ತುನ್ ಪರ್ತುನ್ ಉಪಾಸ್ ಆನಿ ಮಾಗ್ನಿ ಕರ್‌ತ್ಯಾತ ತಸಸ್ ಪರಿಸಾಯಾಂಚ ಶಿಶಾ ಬಿ ಕರತ್ಯಾತ ಫನ್ ತುಜ಼ ಶಿಶಾ ಖಾಯಿಮ್ ಖಾತ್ಯಾತ ಪಿತ್ಯಾತ” ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","ಯೇಸು ತ್ಯನಾ ವ್ಹರಾಡಾ ಸಂಗ ನವರ‍್ಹಾ ಆಸ್ಥಾನಾ ಪರ‍್ಯಾತ್ ತುಮಿ ತ್ಯನಾ ಉಪಾಸಿ ಲಾವುನ್ ದಿಯಾ ವ್ಹಯಿಲ್ ಕ್ಯಾ? ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","ಫನ್ ಆಸ್ಲ ದೀಸ್ ಯತಿಲ ನವರ್ಹಾ ತ್ಯಂಚಿಪ್ನಿ ಕಾಡುನ್ ಗಿಹ್ಯಾಚ಼ ಯಯಿಲ್ ತ್ಯಾ ದೀಸಾತ್ ಉಪಾಸಿ ರಾಥಿಲ. ");
INSERT INTO gok_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","ತ್ಯನಾ ಯೇಕ್ ಕ್ಯಾಯ್ನಿ ಸಾಹಿತ್ ಸಾಂಗ್ಲಿ. ತಿ ಕ್ಯಾ ಮಂಜೆ, “ಕೊನ್ ನವಾ ಕಪ್ಡಾ ಫಾಟುನ್ ಜು಼ನ್ಯಾ ಕಪ್‌ಡ್ಯಾಲಾ ಲಾವಿತ್ ನಾಹಿ ಲ್ಯಾವಲತ, ತ್ಯೊ ನವಾ ಕಪಡಾ ಫಾಟುನ್ ಬಾದ್ ಕೇಲ್ಯಾಚೆಗತ್ ಜಾ಼ಲಾ ಆನಿ ನವಾ ಫಾಟುನ್ ಲ್ಯಾವ್‌ಲ್ಯಾಲಾ ಜು಼ನ್ಯಾಲಾ ಬರಾ ದಿಸತ್ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","ಆನಿ ಜು಼ನ್ನೆ ಚ಼ಮ್‌ಡ್ಯಾಚೆ ಪಿಸ್ವಿತ್ ನವಾ ದ್ರಾಕ್ಶಿಚಾ಼ ರಸ್ ಕೊನ್ ಗಾಲಿತ್ನಾಹಿ. ಗ್ಯಾತ್ಲತ ನವಾ ದ್ರಾಕ್ಶಿಚಾ಼ ರಸ್ ಚ಼ಮ್‌ಡ್ಯಾಚಿ ಪಿಸ್ವಿ ಫುಟುನ್ ಲವಂಡುನ್ ಜಾ಼ನಾರ್ ಆನಿ ಚ಼ಮ್‌ಡ್ಯಾಚಾ ಪಿಸವ್ಯಾ ಬಾದ್ ವ್ಹನಾರ್. ");
INSERT INTO gok_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","ಖರ ನವಾ ದ್ರಾಕ್ಶಿಚಾ಼ರಸ್ ನವ್ಯಾ ಚ಼ಮ್‌ಡ್ಯಾಚೆ ಪಿಸ್ವಿತ್ ಗಾಲುನ್ ಥೆವಾವ. ");
INSERT INTO gok_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","ತ್ಯವ್ಡಸ್ ನವ್ಹ ಜುನ್ನಾ ದ್ರಾಕ್ಶಿಚಾ಼ ರಸ್ ಪಿಯಾಲಿತ ತ ನವಾ ದ್ರಾಕ್ಶಿಚಾ಼ ರಸ್ ವ್ಹಯಿ ಮನ್ಹಿತ್ ನಾಹಿತ. ಜು಼ನ್ನಾಸ್ ಚಾ಼ಂಗ್ಲ ಹಾ ಮನ್‌ಥೊ. ");
INSERT INTO gok_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","ಮಂಗ್ ಯಕಸಿ ಸಬ್ಬತ್ ದಿಸಾದಿಸಿ ಯೇಸು ಸೇತಾ ಮದ್ನಿ ಜಾ಼ತಾನಾ ತ್ಯಚಾ ಶಿಶಾಂಚಾನಿ ಕನ್ಸ ಮುಡುನ್ ಹತ್ತಾವ ಚು಼ಳುನ್ ಖಾಲಿತ. ");
INSERT INTO gok_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","ತವಾ ಪರಿಸಾಯಾತ್ಲ ಕಾಯ್‌ ಥೊಡ ಯೇಸುಲಾ, “ಕಾ ತುಮಿ ಧರ್ಮಶಾಸ್ತಾರಾಚೆ ಅಡ್ವ ಸಬ್ಬತಾ ದೀಸಿ ಕರು ನಾಹಿತ್ಯ ಕಾಮ ಕರ್ತಾಸಾ? ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","ಯೇಸುನಿ ತ್ಯನಾ ಆಸಾ ಉತ್ತರ್ ದಿಲಾ ದಾವಿದ್ ಆನಿ ತ್ಯಚೆ ಸಂಗಚಾ ಮಾನ್ಸಾಂಚಾನಿ ಭುಕ್ ಲಾಗ್ಲಿ ತವಾ ದಾವಿದಾನಿ ಕ್ಯಾ ಕೆಲ, ತ್ಯ ತುಮಿ ವಾಚಿವ್ಲ ನಾಹಿಸಾ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","ದಾವಿದ್ ದೇವಾಚಾ ದೇವ್ಳಾತ್ ಗೆಲಾ ಆನಿ ತ್ಯಾ ನಿವ್ದಾಚಾ ಬಾಕ್‌ರ‍್ಯಾ ಯಾಜಕಾ ಸಿವಾರ್ ಆನಿ ಕುನಿ ಖಾವು ನಾಹಿತಾ ಆಸಾ ನೇಮ್ ಹುತ್ತಾ ತ್ಯಾ ಗಿಹುನ್ ತ್ಯನಿ ಕಶಾ ಖಾಲ್ಯಾ ಆನಿ ಆಪ್ಲಿ ಸಂಗ ಆಸ್‍ಲ್ಯಾಲ್ಯಾನಾ ಸಾಹಿತ್ ಕಶಾ ದಿಲ್ಯಾ ಹ್ಯ ತುಮಿ ಕಂದಿ ವಾಚಿವ್ಲ ನಾಹಿಸಾ ಕ್ಯಾ? ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","ಆನಿ ಯೇಸು ತ್ಯನಾ “ಮಾನ್ಸಾಚಾ಼ ಲ್ಯೊಕ್ ಸಬ್ಬತ್ ದಿಸಾವ್ನಿ ಥೊರ್ಲಾ ಹಾ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","ಮಂಗ್ ದುಸ್‌ರ‍್ಯಾ ಯಕಾ ಸಬ್ಬತಾ ದಿಸಿ ಆಸ ಜಾ಼ಲ ಯೇಸು ಸಭಾಸ್ಥಾನಾತ್ ಜಾ಼ವುನ್ ಸಿಕ್ವಿತ್ ಆಸ್ಥಾನಾ ತಿಥ ಉಜ಼ವಾ ಹಾತ್ ವಾಳ್ಯಾಲಾ ಯೊಕ್ ಮಾನುಸ್ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","ತವಾ ಶಾಸತ್ರಿ ಆನಿ ಫರಿಸಾಯ್ ಯೇಸುವ ಚು಼ಕ್ ವಾವಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಸಬ್ಬತ್ ದಿಸಾದಿಸಿ ರೊಗ್ ಬರಾ ಕರ್ತ್ಯೊ ಕ್ಯಾ ನಾಹಿ ಬಗಾಯಾ ಟಪುನ್ ರಾಯ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","ಫನ್ ಯೇಸುನಿ ತ್ಯಂಚಾ಼ ಇಚಾರ್ ವಳ್ಕುನ್ ತ್ಯಾ ಹಾತ್ ವಾಳ್ಯಾಲ್ಯಾ ಮಾನ್ಸಾಲಾ, “ಉಠುನ್ ಹಿತ್ತ ಉಬಾ ರ‍್ಹಾ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ ತವಾ ತ್ಯೊ ಉಠುನ್ ಉಬಾ ರಾಯ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","ತವಾ ಯೇಸು ತ್ಯನಾ ಮನ್ಲಾ. “ಮಿ ತುಮಾನಾ ಇಚಾರ್ತೊ ಸಬ್ಬತ್ ದಿಸಾದಿಸಿ ಬರ ಕರಾಚ಼ ಚಾ಼ಂಗ್ಲ ಕ್ಯಾ ವಾಯಿಟ್ ಕರಾಚ಼ ಚಾ಼ಂಗ್ಲ ಜೀವ್ ಉರ್ವಾಚಾ಼ ಚಾ಼ಂಗ್ಲ ಕ್ಯಾ ಜೀವ್ ಕಾಡಾಚಾ಼ ಚಾ಼ಂಗ್ಲ? ");
INSERT INTO gok_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","ಮಂಗ್ ಯೇಸುನಿ ಸರ್ಬೌತಚಾ ಸಗ್‌ಳ್ಯಾಂಚಿಕ್ಡ ಬಗುನ್ ತ್ಯಲಾ ಮನ್ಲಾ, “ತುಜಾ಼ ಹಾತ್ ಮೊರ‍್ಹ ಕರ್” ತವಾ ತ್ಯನಿ ಮೊರ‍್ಹ ಕೆಲಾ ಆನಿ ತ್ಯಚಾ಼ ಹಾತ್ ಬರಾ ಜಾ಼ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","ಮಂಗ್ ಪರಿಸಾಯ‍ ಆನಿ ಧರ್ಮ ಶಾಸ್ತ್ರಾಂಚಾ ಜಾಂತ್ಯಾನಾ ರಾಗ್ ಆಲಾ ಆನಿ ಯೇಸುಲಾ ಕ್ಯಾ ಕರುಯಾ ಮನ್ಹುನ್ ಯಕಾಮಕಾಲಾ ಇಚಾರ್ ಕರುಲಾಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","ಮಂಗ್ ಯಕಸಿ ಯೇಸು ಮಾಗ್ನ ಕರಾಯಾ ಕನ್ಯಾವ ಗೆಲಾ ಆನಿ ರ‍್ಯಾತ್ಬರ್ ದೇವಾಪ ಮಾಗ್ನ ಕರೀತ್ ರಾಹ್ಯಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","ಮಂಗ್ ದಿಸ್ ಉಗಾವಲ್ಯಾವರ್ ಯೇಸುನಿ ಆಪ್‌ಲ್ಯಾ ಶಿಶಾನಾ ಹಾಕಟ್ಲ; ಆನಿ ತ್ಯಾತ್‍ಲ್ಯಾ ಬಾರಾ ಜ಼ನಾನಾ ನಿವ್ಡುನ್ ತ್ಯನಾ ಅಪೊಸ್ತಲ್‍ ಮನ್ಹುನ್ ನಾವ್ ಥೆವ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","ಸಿಮೊನ್ (ಹ್ಯಲಾ ಯೇಸುನಿ ಪೇತ್ರ ಮನ್ಹುನ್ ನಾವ್ ಥೆವ್ಲ.) ಆನಿ ತ್ಯಚಾ಼ ಬಾಹು ಆಂದ್ರೆಯ್, ಯಾಕೊಬ್ ಆನಿ ಯೊಹಾನ್, ಫಿಲಿಪ್ಪ ಆನಿ ಬಾರ್ತೊಲೊಮಾಯಾ, ");
INSERT INTO gok_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ಮತ್ತಾಯ, ತೊಮ್, ಅಲ್ಪಾಯಾಚಾ಼ ಲ್ಯೊಕ್ ಯಾಕೊಬ್, (ದೇಶಾಚಾ಼ ಅಭಿಮಾನಿ ಮಂಥ್ಯಾಲಾ) ಸಿಮೊನ್, ");
INSERT INTO gok_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ಯಾಕೊಬಾಚಾ಼ ಲ್ಯೊಕ್ ಯುದ್, ಆನಿ ಮೊರ‍್ಹ ಯೇಸುಲಾ ದರುನ್ ದೇತ್ಯಾಲಾ ಇಸ್ಕರಿತ್ ಯುದ್, ");
INSERT INTO gok_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","ನಂತರ್ ಯೇಸು ಅಪೊಸ್ತಲಾಂಚೆ ಸಂಗ ಕನ್ಯಾವ್ನಿ ಆಲಾ ದುಸ್‌ರ‍್ಯಾ ಸಗ್‌ಳ್ಯಾ ಶಿಶಾಂಚಿ ಸಂಗ ಸಪ್ತಾಳ್ ಜಾ಼ಗ್ಯಾವ ಉಬಾ ರಾಯ್ಲಾ ಯುದಾಯಾತ್ನಿ ಯೆರುಸಲೆಮಿತ್ನಿ ಸಮಿಂದೊರಾಚೆ ಜ಼ವಳಚೆ ಸಿದೊನ್ ಆನಿ ತುರ್ ಪೆಠತ್ನಿ ಆಲ್ಯಾಲ್ಯಾ ಲೊಕಾಂಚಾ಼ ಮೊಟಾ ಹಿಂಡ ತಿಥ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","ತೀ ಯೇಸುಚ಼ ಸಬಾತ್ ಐಕಾಯಾ ಆನಿ ತ್ಯಚಿಪ್ನಿ ರ‍್ವಾಗ್ ಬರ ಕರುನ್ ಗಿಹ್ಯಾ ಆಲ್ತಿತ ತವಾ ಲಾಗಿರಾನಿ ಪಿಡಲ್ಯಾಲಿ ಹುತ್ತಿತ. ತೀ ಬಿ ಬರಿ ಜಾ಼ಲ್ಹಿತ. ");
INSERT INTO gok_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","ತವಾ ಸಗ್ಳಿ ಸಮುದಾಯಾಚಿ ತ್ಯಲಾ ಹಾತ್ ಲಾವಾಯಾ ಗಡ್ಬಡ್‍ ಚಾ಼ಲ್ಲಿ ಹುತ್ತಿ, ಕಾ ಮಂಜೆ ಯೇಸುಪ್ನಿ ದೇವಾಚ಼ ಬಳ್ ನಿಗುನ್ ತ್ಯಾ ಸಗ್‍ಳ್ಯಾನಾ ಬಿನ್‌ರೊಗಿ ಕರೀತ್ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","ತವಾ ಯೇಸು ಆಪ್‌ಲ್ಯಾ ಶಿಶಾಂಚಿಕ್ಡ ನದಾರ್ ಥಿವುನ್ ಮನ್ಲಾ, “ಗರಿಬ್ ಆಸ್ನಾರ ತುಮಿ ಬರ; ಕಾ ಮಂಜೆ ದೇವಾಚ಼ ರಾಜೆ ತುಮಚ಼. ");
INSERT INTO gok_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","ಆತಾ ಬುಖಚ಼ ಆಸ್‍ಲ್ಯಾಲ ತುಮಿ ಬರ; ಕಾ ಮಂಜೆ ತುಮಚ಼ ಮನ್ ಥಂಡ್ ವ್ಹನಾರ್. ಜೆ ಆತಾ ರಡತ್ಯಾಲಿ ತುಮಿ ಬರ; ತುಮಿ ಹಸ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","ಮಾನ್ಸಾಚಾ ಲೇಕಾಸ್ಲಾಗುನ್ ಲೊಕ ತುಮಚಾ಼ ರಾಗ್ ಕರ್ನಾರ್, ತುಮಾನಾ ಯಗಳ್ತಿಲ, ತುಮ್ಚಿ ನಿಂದಾ ಕರತಿಲ, ಆನಿ ತುಮಚ಼ ನಾವ್ ವಾಯಿಟ್ ಮನ್ಹುನ್ ಕ್ಯಾಡಲ್ಯಾವ, ತುಮಿ ಬರಿ. ");
INSERT INTO gok_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","ತೇ ದೀಸಿ ಆನಂದಾನಿ ರಾವ್ಹಾ; ಕಾ ಮಂಜೆ ಸ್ವರ್ಗಾತ್ ತುಮ್ಚಿ ಸಾಟಿ ಥೆವ್‍ಲ್ಯಾಲ ಪ್ರತಿ ಫಳ್ ತುಮಾನಾ ಗಾವಲ್.. ಹ್ಯಂಚಾ ವಡ್ಲಾಂಚಾನಿ ಪ್ರವಾದಿನಾ ಆಸಸ್ ಕೆಲ್ತ. ");
INSERT INTO gok_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“ಫನ್ ಸಾವ್ಕಾರಾ ತುಮ್ಚಿ ಕ್ಯವ್ಡಿ ದುರ್ದೆಶ್ನಾ ವ್ಹನಾರ್! ಕಾ ಮಂಜೆ ತುಮಿ ತುಮ್ಚ ಸುಕ್ ಖಾಲ್ಯಾಸಾ. ");
INSERT INTO gok_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","ಜೆತುಮಿ ಆತಾ ಥಂಡ್ ಜಾ಼ಲ್ಯಾಲ ಹಾಸಾ ತ್ಯಂಚಿ ಕ್ಯವ್ಡಿ ದುರ್ದೆಶ್ನಾ ವ್ಹನಾರ್! ಕಾ ಮಂಜೆ ತುಮಾನಾ ಭುಕ್ ಲಾಗ್ನಾರ್. ಆತಾ ಹಸತಾಸಾ ತ್ಯಂಚಿ ಕ್ಯವ್ಡಿ ದುರ್ದೆಶ್ನಾ ವ್ಹನಾರ್! ಕಾ ಮಂಜೆ ತುಮಿ ದುಃಖಾನಿ ರಡ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","ಸಗ್ಳಿ ಲೊಕ ಕವಾ ತುಮಾನಾ ಬರ ಮಂಥಿಲ ತವಾ ತುಮ್ಚಿ ಕೆವ್ಡಿ ದುರ್ದೆಶ್ನಾ ವ್ಹನಾರ್! ತ್ಯಂಚ಼ ವಡಿಲ್ ಖೊಟ್ಯಾ ಪ್ರವಾದಿನಾ ಆಸ್ಹಸ್ ಮನ್ಹಿತ. ");
INSERT INTO gok_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“ಫನ್ ಮಾಜ಼ ಸಬಾತ್ ಐಕ್‌ತ್ಯಾಲ್ಯಾನಾ ಮಿ ಸಾಂಗ್ತೊ ತುಮಿ ತುಮಚಾ಼ ವೈರಿಂಚಿ ಮಾಯಾ ಕರಾ, ತುಮ್ಚಾ ರಾಗ್ ಕರ್ತ್ಯಾತ ತ್ಯನಾ ಬರ ಕರಾ; ");
INSERT INTO gok_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","ಕೊನ್ ತುಮಾನಾ ಸರಾಪ್‍ತ್ಯಾತ ತ್ಯನಾ ಆಶಿರ್ವಾದ್ ಕರಾ; ತುಮ್ಚೆ ಸಂಗ ವಾಯಿಟ್ ರಾಥ್ಯಾಲ್ಯಾಂಚಿಸಾಟಿ ಮಾಗ್ನ ಕರಾ. ");
INSERT INTO gok_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","ಕುನಿ ತರಿ ತುಜಾ ಯಕಾ ಗಾಲಾವ ಮ್ಯಾರ್ಲತ, ತ್ಯಚೆ ಮೊರ‍್ಹ ದುಸರಾ ಗಾಲ್ ಕರ್; ಆನಿ ತುಜಿ ವೈಲಿ ಆಂಗಿ ನೆಥ್ಯಾಲ್ಯಾಲಾ ಆತ್ಲ ಬನ್ಯಾಲ್ ನಿಹ್ಯಾ ಥಾಂಬುವು ನಕೊ. ");
INSERT INTO gok_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","ತುಜಿಪ ಕೊನ್ ಮಾಗಾಯಾ ಯತೊ ತ್ಯಲಾ ದೇ ಆನಿ ತುಮ್ಚ಼ ಜಾ಼ಲ್ಯಾಲ ಕ್ಯಾಬಿ ಕಾಡುನ್ ಗೆತೊ ತ್ಯಚಿಪ ತ್ಯ ಪರ್ತುನ್ ಮಾಗು ನಕೊಸ್. ");
INSERT INTO gok_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","ತುಮಾನಾ ದುಸ್‌ರ‍್ಯಾಂಚಾನಿ ಕ್ಯಾ ಕರಾಯಾ ವ್ಹಯಿ ಮಂಥಾಸಾ ತ್ಯ ತುಮಿ ತ್ಯನಾ ಕರಾ. ");
INSERT INTO gok_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“ತುಮ್ಚಿ ಮಾಯಾ ಕರ್ತ್ಯಾತ ತ್ಯಂಚಿ ತುಮಿ ಮಾಯಾ ಕಿಲಿಸಾತ ತ್ಯನಿ ಪ್ಯಾಯ್ದಾ ಕ್ಯಾ ಹಾ? ಕಾ ಮಂಜೆ ಪಾಪಿ ಸಾಹಿತ್ ಆಪ್ಲಿ ಮಾಯಾ ಕರತ್ಯಾಲ್ಯಾವರ್ ಮಾಯಾ ಥೆವ್‍ತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","ತುಮಾನಾ ಬರ ಕೆಲ್ಯಾಲ್ಯಾನಾ ತುಮಿ ಬರ ಕೆಲತ ತ್ಯಾತ್ ತುಮಚಾ಼ ಉಪಕಾರ್ ಕ್ಯಾ? ಪಾಪಿ ಲೊಕ ಸಾಹಿತ್ ತಸಿಸ್ ಕರ್ತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","ಆನಿ ತುಮಾನಾ ಕಚಾಪ್ನಿ ಪರತ್ ಮಿಳಾಚ಼ ಹಾ ತ್ಯಲಾ ತುಮಿ ರೀನ್ ದಿಲತ ತ್ಯಾತ್ ತುಮಾನಾ ಕ್ಯಾ ಪ್ಯಾಯ್ದಾ? ಕ್ಯವ್ಡ ದಿಲ ತ್ಯವ್ಡ ಪರತ್ ಮಿಳ್ವಾಯಾಸಾಟಿ ಪಾಪಿ ಲೊಕಾನಾ ಪಾಪಿ ಲೊಕ್ ಉಸ್ನ ದೆತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","ತುಮಿ ತರಿ ತುಮ್ಚಾ ವಾದಿಂಚಿ ಮಾಯಾ ಕರಾ, ತ್ಯನಾ ಬರ ಕರಾ, ಆನಿ ತ್ಯ ತುಮಾನಾ ಪರತ್ ಮಿಳಲ್ ಮನ್ಹುನ್ ಆಶಾ ಥೆವಾಚೆ ಆಂದಿ ಉಸ್ನ ದೇವಾ. ಮಂಜೆ ತುಮಚ಼ ಪ್ರತಿಫಳ ಮೊಟ ವ್ಹಯಿಲ್, ಆನಿ ತುಮಿ ಸರ್ವ್ಯಾತ್ ಮೊಟ್ಯಾ ದೇವಾಚಿ ಲೇಕ್ರ ವ್ಹಸಿಲಾ; ತ್ಯೊ ತರಿ ಉಪ್ಕಾರ್ ನಸ್‌ಲ್ಯಾಲ್ಯಾ ಬುರ್ಶಾ ಲೋಕಾನಾಬಿ ಉಪಕಾರ್ ಕರ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","ತುಮಚಾ಼ ಸ್ವರ್ಗಾತ್ಲ ಬಾ ದೆವ್ ಕಸಾ ದಯಾಳುಹಾ ತಸಿ ತುಮಿಬಿ ದಯಾಳು ಹ್ವವುನ್ ರಾವ್ಹಾ. ");
INSERT INTO gok_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","ದುಸ್‌ರ‍್ಯಾಂಚಾ಼ ನ್ಯಾಯಿ ನಿವ್ಡು ನಕೊಸಾ, ಮಂಜೆ ತುಮಚಾ಼ ದೊಶ್ ದೇವ್ ಕ್ಯಾಡ್ನಾರ್ ನಾಹಿ; ಕುನಾವ ಚು಼ಕ್ ಥರ್ವು ನಕೊಸಾ; ಮಂಜೆ ತುಮ್ಚಿವ ದೇವ್ ದೊಶ್ ಥರ್ವಿತ್ ನಾಹಿ; ಮಾಪ್ ಕರಾ ಮಂಜೆ ತುಮಾನಾಬಿ ಮಾಪಿ ವ್ಹಯಿಲ್. ");
INSERT INTO gok_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","ತುಮಿ ಆಂದಿ ದುಸ್‌ರ‍್ಯಾನಾ ದೆವಾ ಮಂಜೆ ತುಮಾನಾ ದೇವ್ ದಿಯಿಲ್; ಮಾಪ್ ಚಾ಼ಂಗ್ಲ ದಡಪುನ್, ಹಾಲ್ವುನ್ ಆನಿ ಶಿಗ್ ಬರ‍್ಹುನ್ ತುಮ್ಚಾ ಪದರಾತ್ ಗ್ಯಾಲ್ನಾರ್; ಕಾ ಮಂಜೆ ತುಮಿ ಮ್ಯಾಪ್‌ಲ್ಯಾಲ್ಯಾ ಮಾಪಾನಿ ದೇವ್ ತುಮಾನಾ ಮ್ಯಾಪ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","ಯೇಸುನಿ ತ್ಯನಾ ಹಿ ಕ್ಯಾಯ್ನಿ ಸಾಂಗ್ಲಿ: “ಯೊಕ್ ಅಂದ್ಳಾ ಆನಿಯಕಾ ಆಂದ್‌ಳ್ಯಾಲಾ ವಾಟ್ ದಾವಾಯಾ ವ್ಹಯಿಲ್ ಕ್ಯಾ? ದೊಗಬಿ ಖಡ್ಯಾತ್ ಪಡತಿಲ ಕ್ಯಾ ನಾಹಿ? ");
INSERT INTO gok_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","ಶಿಶಾ ಗುರುವ್ನಿ ಮೊಠಾ ನವ್ಹ; ಫನ್ ಸಗ್ಳ ಸಿಕ್‍ಲ್ಯಾಲಾ ಪರ್ತೇಕ್ ಶಿಶಾ ಆಪ್‌ಲ್ಯಾ ಗುರು ಶಾರ್ಕಾ ವ್ಹಯಿಲ್. ");
INSERT INTO gok_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“ತು ತುಜಾ ಡೊಳ್ಯಾತ್ಲ ಮುಸಾಳ್ ಬಗಾಚೆ ಆಂದಿ, ತುಜಾ ಬಾವ್ಹಾಚಾ ಡೊಳ್ಯಾತ್ಲ ಕುಸಾಳ್ ಕಾ ಬಗ್ತೊಸ್? ");
INSERT INTO gok_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","ನಾಹಿತ ತು ತುಜಾ ಡೊಳ್ಯಾತ್ಲ ಮುಸಾಳ್ ಬಗಿತ್ ನಾಹಿಸ್ ಆನಿ ತುಜಾ ಬಾವ್ಹಾಲಾ ತುಜಾ ಡೊಳ್ಯಾತ್ಲ ಕುಸಾಳ್ ಕ್ಯಾಡ್ತೊ ಯೇ ಮನ್ಹುನ್ ಕಾ ಸಾಂಗ್ತೊಸ್? ಆರ ಕಪ್‍ಟ್ಯಾ ಆಂದಿ ತುಜಾ ಡೊಳ್ಯಾತ್ಲ ಮುಸಾಳ್ ಕ್ಯಾಡ್ ಮಂಜೆ ತುಜಾ ಬಾವ್ಹಾಚಾ ಡೊಳ್ಯಾತ್ಲ ಕುಸಾಳ್ ಕಾಡಾಯಾ ತುಲಾ ನಿಟ್ ದಿಸಲ್. ");
INSERT INTO gok_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","ಚಾ಼ಂಗ್ಲ ಝಾ಼ಡ್ ಕುಚ಼ಕ ಫಳ್ ದಿಯಿತ್ ನಾಹಿ ತಸಸ್ ಕುಚ಼ಕ ಝಾ಼ಡ್ ಚಾ಼ಂಗ್ಲ ಫಳ ದಿಯಿತ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","“ಪರತೇಕ್ ಝಾ಼ಡ್ ತ್ಯಚಾ ಫಳಾವ್ನಿಸ್ ವಳ್ಕುನ್ ಯತ. ಕನ್ಯಾರಿಚೆ ಜಾ಼ಳಿತ್ ಕೊನ್ ಅಂಜುರ್ ಕಾಡಿತ್ ನಾಹಿತ ಆನಿ ರುದ್ರಾಕ್ಶಿಚಾ ಜಾ಼ಢಾತ್ನಿ ಕೊನ್ ದರಾಕ್ಶಿಚ಼ ಫಳ್ ಕಾಡಿತ್ ನಾಹಿತ. ");
INSERT INTO gok_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","ಯೊಕ್ ಚಾ಼ಂಗ್ಲಾ ಮಾನುಸ್ ಚಾ಼ಂಗಲ್ಯಾ ಗುಶ್ಟಿ ಆಂತೊ ಆಪ್‌ಲ್ಯಾ ಮನಾತ್ ಥೆವ್‌ಲ್ಯಾಲ್ಯಾ ಚಾ಼ಂಗಲ್ಯಾ ಗುಶ್ಟಿ ಯೊಕ್ ಬುರ್ಸಾ ಮಾನುಸ್ ಬರ್ಶಾ ಗುಶ್ಟಿ ಆಂತೊ ಮನಾತ್ ಬರ್ಲ್ಯಾಲಸ್ ತ್ವಾಂಡ್ ಬೊಲ್ತ. ");
INSERT INTO gok_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“ತುಮಿ ಮನಾ ಪ್ರಭು, ಪ್ರಭು, ಮನ್ಥಾಸಾ ಆನಿ ಮಿ ಸಾಂಗ್‌ಲ್ಯಾಲ ಕಾ ಕರೀತ್ ನಾಹಿಸಾ? ");
INSERT INTO gok_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","ಕೊನ್ ಮಾಜಿಕ್ಡ ಯತೊ ಆನಿ ಮಾಜ಼ ಸಬಾತ್ ಕೊನ್ ಐಕ್ತೊ ತ್ಯಚಿ ಶಾರ್ಕಾ ಚಾ಼ಲ್ತೊ ಆನಿ ತಸ ಕರ್ತೊ ತ್ಯೊ ಕುನಾ ಶಾರ್ಕಾ ಹಾ ತ್ಯ ಮಿ ತುಮಾನಾ ಸಾಂಗ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","ಯೊಕ್ ಮಾನುಸ್ ಖೋಲ್ ಖಾಂದುನ್ ಖಡ್ಕಾವ ಪಾಯಾ ಗಾಲುನ್ ಘರ್ ಬ್ಯಾಂತೊ ಮಂಗ್ ವ್ಹಾಳ್ ಪಾನ್ಯಾನಿ ಬರ್ಹುನ್ ಯವುನ್ ತ್ಯಾ ಗರ‍್ಹಾವ ಆದಾಳ ತರಿ ತ್ಯ ಘರ್ ಹಾಲತ್ ನಾಹಿ ಕಾ ಮಂಜೆ ತ್ಯ ಖಡ್ಕಾವ ಹುತ್ತ. ");
INSERT INTO gok_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","ಕೊನ್ ಮಾಜ಼ ಸಬಾತ್ ಐಕ್ತೊ ಫನ್ ತೆ ಪಾಳಿತ್ನಸಲ್ಯಾಲಾ ಕಸ್ಲಾ ಹಾ ಮಂಜೆ ತ್ಯೊ ಪಾಯಾ ನಸ್ತಾನಾ ಘರ್ ಬ್ಯಾಂದ್‌ಲ್ಯಾಚೆಗತ್ ಆಸ್ಥೊ ತ್ಯಾ ಗರ‍್ಹಾಲಾ ಪಾನಿ ಯವುನ್ ಅದಾಳ್ತಾನಾ ತ್ಯ ಪಡುನ್ ಹಾಳ್ ವ್ಹತ್ತ. ");
INSERT INTO gok_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","ಮಂಗ್ ಹಿ ಸಗ್ಳಿ ವಚ಼ನ ಲೊಕಾಂಚಾ ಕಾನಾವ ಪಡ್ಲಿತ ತವಾ ಯೇಸು ಆಪ್ಲ ಬೋಲ್ನ ಉಬಕರುನ್ ಕಪೆರ್ನೌಮ್ ಪೆಠತ್ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","ತಿಥ ಶಥಾದಿಪತಿಲಾ ಆವ್ಡಚಾ಼ ಯೊಕ್ ಚಾ಼ಕೊರ್ ಸಿಕ್ ಪಡುನ್ ಮರಾಯಾ ಜಾ಼ಲ್ಥಾ. ");
INSERT INTO gok_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","ಶತಾದಿಪತಿನಿ ಯೇಸುಚಿ ಬಾತ್ನಿ ಐಕುನ್ ಯೆಹುದ್ಯಾಂಚಾ ವಡ್ಲಾನಾ ತ್ಯಚಿಕ್ಡ ಲಾವುನ್ ದಿವುನ್ ಆನಿ ತ್ಯಂಚಾನಿ ತು ಯವುನ್ ಮಾಜಾ ಚಾ಼ಕ್ರಾಲಾ ಬರಕರಾವ ಮನ್ಹುನ್ ಇನಂತಿ ಕರಾಯಾಲ್ಯಾವ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","ತೇ ಯೇಸುಕ್ಡ ಯವುನ್, ತ್ಯನಿ ಖುಬ್ ಇಚಾರ್ಲ ಹ್ಯೊ ಮಾನುಸ್ ತುಜೆ ಮಜ಼ತಿಲಾ ಯೊಗೆತಾಚಾ಼ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ಕಾ ಮಂಜೆ ತ್ಯೊ ಆಮ್ಚಾ ಲೊಕಾಂಚಿವ ಮಾಯಾ ಆಸ್ನಾರಾ ಆನಿ ಹ್ಯನಿಸ್ ಆಮ್ಚೆ ಸಾಟಿ ಸಭಾಸ್ಥಾನ್ ಬಾಂದುನ್ ದಿಲ್ಯಾಲ ಹಾ” ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","ತವಾ ಯೇಸು ತ್ಯಂಚೆ ಸಂಗ ಗೆಲಾ ಆನಿ ತ್ಯಚಾ ಗರ‍್ಹಾಚೆ ಜ಼ವಳ್ ಯತಾನಾಸ್ ತ್ಯನಿ ಯೇಸುಕ್ಡ ಆಪ್‌ಲ್ಯಾ ಸೊಪ್‌ತ್ಯಾನಾ ಸಾಂಗ್ ಲಾವುನ್ ದಿವುನ್ ಪ್ರಭು ತರಾಸ್ ಗಿಹು ನಕೊಸ್, ತು ಮಾಜಾ ಗರ‍್ಹಾತ್ ಯಯಿಜೊ಼ಗಾ ಮಿ ಮೊಟಾ ನವ್ಹ. ");
INSERT INTO gok_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","ನಾಹಿತ ಮಿ ತುಜಿಪ ಯಯಾಚಿ ಯೊಗೆತಾಬಿ ಮನಾ ನಾಹಿ ಫಕ್ತ ತು ಯೊಕ್ ಸಬ್ದ ಸಾಂಗ್ಲಾಸ್ಕಿ ಮಾಜಾ಼ ಚಾ಼ಕೊರ್ ಬರಾ ವ್ಹಯಿಲ್. ");
INSERT INTO gok_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","ಮಿ ಸಾಹಿತ್ ಆನಿ ಯಕಾಚಾ ಹಾತಾ ಖಾಲ್ ಆಸ್‌ಲ್ಯಾಲಾ ಮಾನುಸ್ ಹಾ ಮಾಜಾ ತಾಬ್ಯಾತ್ ಸಿಪಾಯಿ ಹಾತ; ಮಿ ಯಕಾಲಾ ಜಾ಼ ಮನ್ಲೊ ಮಂಜೆ ತ್ಯೊ ಜಾ಼ತೊ ದುಸ್‌ರ‍್ಯಾಲಾ ಯೆ ಮನ್ಲೊ ಮಂಜೆ ತ್ಯೊ ಯತೊ ಆನಿ ಆಪ್‌ಲ್ಯಾ ಚಾ಼ಕ್ರಾಲಾ ಆಮ್ಕ ಕರ್ ಮನ್ಲೊ ಮಂಜೆ ತ್ಯೊ ಕರ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","ಹ್ಯ ಐಕುನ್ ಯೇಸುಲಾ ಆಜಾಬ್ ವಾಟ್ಲ ಆನಿ ತ್ಯೊ ಗುಳ್ಹುನ್ ಆಪ್ಲೆ ಮಾಗ್ನಿ ಚಾ಼ಲತ್ಯಾಲ್ಯಾ ಲೊಕಾನಾ ಮನ್ಲಾ ಮಿ ತುಮಾನಾ ಸಾಂಗ್ತೊ ಆಸ್ಲಾ ಇಸ್ವಾಸ್ ಮನಾ ಇಸ್ರಾಯಲಾತ್ಬಿ ಕುಠ ದಿಸ್ಲಾ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","ಮಂಗ್ ಲಾವುನ್ ದಿಲ್ಯಾಲ ಮಾನುಸ್ ಪರತ್ ಗರ‍್ಹಾತ್ ಆಲ್ಯಾವ ತ್ಯನಾ ತ್ಯೊ ಚಾ಼ಕೊರ್ ಬರಾ ಜಾ಼ಲ್ಯಾಲಾ ದಿಸ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","ಮಂಗ್ ಯೇಸು ನಾಯಿನ್ ನಾವಾಚಾ ಗಾವಾತ್ ಗೆಲಾ ತ್ಯಚ಼ ಶಿಶಾ ಆನಿ ಮೊಟಾ ಲೊಕಾಂಚಾ಼ ಹಿಂಡ್ ತ್ಯಚೆ ಸಂಗ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","ಯೇಸು ಗಾವಾಚೆ ಯಸಿಚೆ ಜ಼ವಳ್ ಆಲಾ ತವಾ ಯಾಕ್ ಮಡ ಬಾಹಿರ್ ನೆಥ್ಯಾಲ ಬಗ್ಲ; ತ್ಯೊ ಆಪ್ಲೆ ಆಯಿಲಾ ಯೊಕುಸ್ ಯೊಕ್ ಲ್ಯೊಕ್ ಹುತ್ತಾ ಆನಿ ತಿ ವಿದ್ವಾ ಹುತ್ತಿ ಆನಿ ತ್ಯಾ ಗಾವಾತ್ಲಿ ಖುಬ್ ಲೊಕ ತಿಚೆ ಸಂಗ ಹುತ್ತಿತ. ");
INSERT INTO gok_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","ತಿಲಾ ಬಗುನ್ ಯೇಸುಲಾ ತಿಚಿ ಕಳ್‍ವಳ್ ಆಲಿ ಆನಿ ತಿಲಾ ಮನ್ಲಾ “ರಡುನಕೊ. ” ");
INSERT INTO gok_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","ಮಂಗ್ ಜ಼ವಳ್ ಜಾ಼ವುನ್ ಯೇಸುನಿ ಕಿರ್ಡಿಲಾ ಹಾತ್ ಲ್ಯಾವ್ಲಾ ತವಾ ಖಾಂದಕರಿ ಉಬ ರಾಯ್ಲ; ಮಂಗ್ ಯೇಸು “ಪ್ಯೊರ್ಗ್ಯಾ ಮಿ ತುಲಾ ಸಾಂಗ್ತೊ ಉಟ್” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","ತ್ಯೊ ಮೆಲ್ಯಾಲಾ ಪ್ಯೊರ್ಗಾ ಉಠುನ್ ಬಸ್ಲಾ ಆನಿ ಬೊಲಾಯಾ ಲಾಗ್ಲಾ ತವಾ ಯೇಸುನಿ ತ್ಯಲಾ ತ್ಯಚೆ ಆಯಿಚಾ ತಾಬ್ಯಾತ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","ತ್ಯ ಬಗುನ್ ಸಗ್‍ಳ್ಯಾನಾ ಭೆ ವಾಟ್ಲ ಆನಿ ತೆ ದೇವಾಲಾ ವವ್ಯಾಳುನ್ ಸಾಂಗ್‍ಲ್ಯಾಲ ಕ್ಯಾ ಮನ್‌ಲ್ಯಾವ, “ಆಮ್ಚೆ ಮದ್ದಿ ಮೊಟಾ ಪ್ರವಾದಿ ಆಲ್ಯಾ ಆನಿ ದೇವ್ ಆಪ್‌ಲ್ಯಾ ಲೊಕಾಂಚಾ಼ ರಕ್ಶನ್ ಕರಾಯಾ ಆಲ್ಯಾ. ” ");
INSERT INTO gok_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","ಯೇಸುಚೆ ಗುಶ್ಟಿಚಿ ಹಿ ಬಾತ್ನಿ ಯುದಾಯಾತ್ ಆನಿ ಚೌಕಲ್ಯಾ ಸಗ್‍ಳ್ಯಾ ಪರದೇಶಾತ್ ಪಗಾಳ್ಳಿ. ");
INSERT INTO gok_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","ಯೊಹಾನಾಚಾ ಶಿಶಾಂಚಾನಿ ಹ್ಯಾ ಗುಶ್ಟಿ ಸಗ್‌ಳ್ಯಾ ತ್ಯಲಾ ಸಾಂಗ್‍ಲ್ಯಾ, ");
INSERT INTO gok_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ತವಾ ಯೊಹಾನಾನಿ ಆಪ್‌ಲ್ಯಾ ಶಿಶಾತ್‍ಲ್ಯಾ ದೊಗಾನಾ ಜ಼ವಳ್ ಹಾಕ್‌ಟುನ್ ಯೊಹಾನಾನಿ ಸಾಂಗ್‍ಲ್ಯಾಲಾ “ಯಯಾಚಾ಼ ಆಸ್‌ಲ್ಯಾ ತ್ಯೊ ತುಸ್ ಕ್ಯಾ ಆಮಿ ದುಸರ‍್ಯಾಚಿ ವಾಟ್ ಬಗಾ ವ್ಹಯಿ? ಮನ್ಹುನ್ ಇಚಾರಾಯಾ ಯೇಸುಪ ಲಾವುನ್ ದಿಲ. ");
INSERT INTO gok_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","ತೇ ಮಾನುಸ್ ಯೇಸುಪ ಯವುನ್ ಬಾಪ್ತಿಸ್ಮಾ ಯೊಹಾನಾನಿ ಆಮಾನಾ ತುಜಿಪ ಲಾವುನ್ ದಿಲ್ಯಾತ ಕಾ ಮಂಜೆ “ಯನಾರಾ ತ್ಯೊ ತುಸ್ ಕ್ಯಾ ಆಮಿ ದುಸ್‌ರ‍್ಯಾಚಿ ವಾಟ್ ಬಗಾಯಾ ವ್ಹಯಿ? ಮನ್ಹುನ್ ಇಚಾರಾಯಾ ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","ತೇಸ್ ಗಟ್ಕಲಾ ಯೇಸುನಿ ಖುಬ್ ಲೊಕಾನಾ ರೊಗ್ ಪಿಡಾ ಆನಿ ವಾಯಿಟ್ ಆತ್ಮಾಂಚಿಪ್ನಿ ಬರಿ ಕಿಲಿಹುತ್ತಿತ ಆನಿ ಕಿತಿತರಿ ಆಂದಳ್ಯಾ ಲೊಕಾನಾ ನದಾರ್ ದಿಲಿಹುತ್ತಿ. ");
INSERT INTO gok_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","ಯೇಸು ತ್ಯನಾ ತುಮಿ ಕಚಾ ಗುಶ್ಟಿ ಬಗ್‌ಲ್ಯಾಸಾ ಆನಿ ಐಕ್‌ಲ್ಯಾಸಾ ತ್ಯಾ ಯೊಹಾನಾಲಾ ಜಾ಼ವುನ್ ಸಾಂಗಾ ಆಂದ್‍ಳ್ಯಾನಾ ಡೊಳ ಯತ್ಯಾತ; ಲಂಗ್ಡ ಚಾ಼ಲತ್ಯಾತ; ಕುಶ್ಟ ರೊಗಿ ಚಾ಼ಂಗ್ಲ ವ್ಹತ್ಯಾತ ಕಿವಂಡ್ಯಾಲಾ ಐಕುಯತ ಮೇಲ್ಯಾಲ ಜಿತ್ತ ವ್ಹತ್ಯಾತ ಆನಿ ಗರಿಬಾನಾ ಬರಿ ಖಬರ್ ಸಾಂಗ್ಲಿ ಮನ್ಲಾ ");
INSERT INTO gok_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","“ಕೊನ್ ಮಾಜಿವ ಸಂಸೆವ್ ಥಿವಿತ್ ನಾಹಿತ ತೇ ಕ್ಯವ್ಡ ಬರ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","ಮಂಗ್ ಯೋಹಾನಾಚ಼ ಶಿಶಾ ಗೆಲ್ಯಾವರ್ ಯೇಸು ಯೊಹಾನಾಚಿ ಖಬರ್ ಲೊಕಾನಾ ಸಾಂಗಾಯಾಲಾಗ್ಲಾ. “ತುಮಿ ಕ್ಯಾ ಬಗಾಯಾ ರಾನಾತ್ ಗೆಲಾ ಹುತ್ತಾಸಾ? ವಾರ‍್ಯಾನಿ ಹಲ್‌ತ್ಯಾಲ ದಾಂಡ್ಹ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","ಕ್ಯಾ ಬಗಾಯಾ ಗೆಲಾ ಹುತ್ತಾಸಾ? ಚಾ಼ಂಗ್ಲ ಕಪ್ಡ ಗ್ಯಾತ್‌ಲ್ಯಾಲ್ಯಾ ಮಾನ್ಸಾನಾ ಕ್ಯಾ? ಬಗಾ ಚಾ಼ಂಗ್ಲ ಕಪ್ಡ ಗಾಲ್ಹುನ್ ಚೈ಼ನಿ ಮಾರ್ನಾರ ರಾಜ್‍಼ ವಾಡ್ಯಾತ್ ರಾಥ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","ಮನಾ ಸಾಂಗಾ ತುಮಿ ಕ್ಯಾ ಬಗಾಯಾ ಗೆಲಾ ಹುತ್ತಾಸಾ? ಪ್ರವಾದಿಲಾ ಕ್ಯಾ? ವ್ಹಯ್ ಮಿ ತುಮಾನಾ ಸಾಂಗ್ತೊ ಪ್ರವಾದಿವ್ನಿ ಮೊಟ್ಯಾಲಾ ತುಮಿ ಬಗ್ಲಾಸಾ. ");
INSERT INTO gok_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","ಹ್ಯ ಯೊಹಾನಾಚ಼ಸ್ ಲಿವ್‍ಲ್ಯಾ ಬಗಾ ಮಿ ಮಾಜಾ ಶಿಶಾಲಾ ತುಜೆ ಮೊರ‍್ಹ ಲಾವುನ್ ದೇತೊ ತ್ಯೊ ತುಜೆ ಮೊರ‍್ಹ ತುಜಿ ವಾಟ್ ತಯಾರ್ ಕರಿಲ್ ");
INSERT INTO gok_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","ಯೇಸು ಮನ್ಲಾ, “ಮಿ ತುಮಾನಾ ಸಾಂಗ್ತೊ ಹ್ಯ ದುನೆತ್ ಜ಼ಲಾಮ್‌ಲ್ಯಾಲ್ಯಾತ್ ಯೊಹಾನಾವ್ನಿ ಮೊಟಾ ಕೊನ್ ನಾಹಿ ತರಿ ದೇವಾಚಾ ರಾಜಾತ್ ಕೊನ್ ಬಾರಿಕ್ ಹಾ ತ್ಯೊ ಯೊಹಾನಾವ್ನಿ ಮೊಟಾ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","ಜ಼ಖತ್‍ದಾರಾಂಚಾನಿ ಆನಿ ಸಗ್‍ಳ್ಯಾ ಲೊಕಾನಿ ತ್ಯ ಐಕುನ್ ದೇವಾಚಾ಼ ಮಾರ್ಗ ಶಾರ್ಕಾ ಹಾ ಕಾ ಮಂಜೆ ತ್ಯಂಚಾನಿ ಬಾಪ್ತಿಸ್ಮಾ ಯೊಹಾನಾನಿ ಆಂದಿಸ್ ತ್ಯನಾ ಬಾಪ್ತಿಸ್ಮಾ ದಿಲ್ತಿ. ");
INSERT INTO gok_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","ಫನ್ ಫರಿಸಾಯ್ ಆನಿ ಕ್ಯಾಯ್ದದಾರಾಂಚಾನಿ ದೇವಾಚಿ ಯವಜ಼್ನಾ ಸುಡುನ್ ಯೊಹಾನಾಪ್ನಿ ಬಾಪ್ತಿಸ್ಮಾ ಗೆತ್ಲ ನವ್ಥ. ");
INSERT INTO gok_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","ಯೇಸುನಿ ಹೆ ಪೀಡಿಚಾ ಲೊಕಾಂಚ಼ ಕ್ಯಾ ಸಾಂಗು ಹಿ ಲೊಕ ಕುನಾಚೆಗತ್ ಹಾತ್ತ? ತೀ ಕುನಾಶಾರ್ಕಿ ಹಾತ್ತ? ");
INSERT INTO gok_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","ಹ್ಯಾ ಕಾಲಾತ್ಲಿ ಲೊಕ ಬಾಜಾ಼ರಾತ್ ಬಸುನ್ ಆನಿ ಯಕಾಮಕಾಲಾ ಹಳ್ಯಾ ಮ್ಯಾರ್ತ್ಯಾಲ್ಯಾ ಪೊರಾಂಚೆಗತ್ ಹಾತ್ತ. ಲಗ್ನಾಚ಼ ವಾಜಾ಼ಪ್ ವಾಜಿ಼ವ್ಲ ತರಿ ತುಮಿ ನಾಚ಼ಲಾ ನಾಹಿಸಾ; ದುಖಾನಿ ಲೊಳ್ಳಾವ್‌ ತರಿ ತುಮಿ ರಡ್ಲಾ ನಾಹಿಸಾ ಮಂಥ್ಯಾಲ್ಯಾಂಚಿಗತ್ ಹಾತ್ತ. ");
INSERT INTO gok_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","ಬಾಪ್ತಿಸ್ಮಾ ಯೊಹಾನ್ ಬಾಕ್ರಿ ಖಾತ್ಯಾಲಾ ನವ್ಹ ದರಾಕ್ಶಿಚಾ ರಸ್ ಪಿತ್ಯಾಲಾ ನವ್ಹ ಆನಿ ತುಮಿ ತ್ಯಲಾ ಲಾಗಿರ್ ಲಾಗ್‌ಲ್ಯಾ ಮಂಥಾಸಾ. ");
INSERT INTO gok_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","ಮಾನ್ಸಾಚಾ಼ ಲ್ಯೊಕ್ ಆಲಾ ತ್ಯೊ ಖಾತ್ಯಾಪಿತ್ಯಾಲಾ ಹಾ ಆನಿ ತುಮಿ ತ್ಯಲಾ ಮನ್ಲಾಸಾ ಹ್ಯೊ ಖಾದೊಡಾ ಪಿದೊಡಾ ಜ಼ಖತ್ ದಾರಾಂಚಾ಼ ಆನಿ ಪಾಪಿಂಚಾ಼ ಸುಪ್ತಿ ಮಂತಾಸಾ. ");
INSERT INTO gok_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","ಫನ್ ದೇವಾಚ಼ ಗಿನ್ಯಾನ್ ಆಪ್‌ಲ್ಯಾಲಾ ಖರ ಮನ್ಹುನ್ ತ್ಯ ಕೊನ್ ವ್ಹಯ್ ಮಂಥ್ಯಾಲ್ಯಾ ಪೊರಾಂಚಿಪ್ನಿಸ್ ದಿಸುನ್ ಯತ. ");
INSERT INTO gok_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","ಪರಿಸಾಯಾತ್‌ಲ್ಯಾ ಯಕಾನಿ ಯೇಸುಲಾ ಆಪ್ಲೆ ಸಂಗ ಖಾಯಾ ಸಾಟಿ ಇಂತಿ ಕೆಲಿ ತವಾ ಯೇಸು ತ್ಯಾ ಪರಿಸಾಯಚಾ ಗರ‍್ಹಾತ್ ಜಾ಼ವುನ್ ಖಾಯಾ ಬಸ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","ಬಗಾ ತ್ಯಾ ಗಾವಾತ್ ಯೇಕ್ ಪಾಪಿ ಬಾಯಿಲ್ಮಾನುಸ್ ಹುತ್ತಿ. ಯೇಸು ಪರಿಸಾಯಾಚಾ ಗರ‍್ಹಾತ್ ಖಾಯಾ ಬಸ್‍ಲ್ಯಾ ಮನ್ಹುನ್ ಐಕುನ್ ತಿನಿ ಚಾ಼ಂಗಲ್ಯಾ ವಾಸಾಚಾ ತೇಲಾಚಿ ಬರ್ನ್ಹಿ ಗಿಹುನ್ ಆಲಿ. ");
INSERT INTO gok_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","ಆನಿ ಯೇಸುಚಾ ಪಾಯಾಚೆ ಕಡಸ್ ಯವುನ್ ಉಬಿ ರಾಹುನ್ ಬಸುನ್ ರಡತ್ ಆಪ್‌ಲ್ಯಾ ಡೋಳ್ಯಾಚಾ ಪಾನ್ಯಾನಿ ತ್ಯಚ಼ ಪ್ಯಾ ವಲ್ಲ ಕರುನ್ ಆಪ್ಲೆ ಡುಯಿಚಾ ಕೇಸಾನಿ ತೆ ಪುಸ್ಲ; ಆನಿ ತ್ಯಚಾ ಪಾಯಾಚ ಮುಕ ಗಿಹುನ್ ಪಾಯಾಂಚಿವ ವಾಸಾಚ಼ ತ್ಯಾಲ್ ವತ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","ತವಾ ಯೇಸುಲಾ ಖಾಯಾ ಹಾಕಟ್‍ಲ್ಯಾಲ್ಯಾ ಪರಿಸಾಯಾನಿ ಹ್ಯ ಬಗುನ್ “ಹ್ಯೊ ಪ್ರವಾದಿ ಆಸ್ಥಾತ ಆಪ್‌ಲ್ಯಾಲಾ ಹಾತ್‍ಲ್ಯಾವ್‌ಲ್ಯಾಲಿ ಬಾಯಿಲ್ಮಾನುಸ್ ಕೊನ್ ಕಸಿ ಹಾ ಮಂಜೆ ತಿ ಪಾಪಿ ತ್ಯ ತ್ಯಲಾ ವಳಾಕ್ಲಿ ಆಸ್ಥಿ” ಮನ್ಹುನ್ ಮನಾತ್ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","ತವಾ ಯೇಸುನಿ ತ್ಯಲಾ “ಸಿಮೊನಾ ಮನಾ ತುಮ್ಚಿ ಸಂಗ ಕಾಯ್ತರಿ ಬೊಲಾಚ಼ ಹಾ” ಮನ್ಲಾ ತವಾ ಸಿಮೊನ್ “ಗುರು, ಸಾಂಗಾ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","ತವಾ ಯೇಸುನಿ ಸಾಂಗ್ಲ, “ಯಕಾ ಸಾವ್ಕಾರಾಲಾ ದೊಗ ರಿನ್ಕರಿ ಹುತ್ತ; ಯಕಾನಿ ಪಾಚ್ಚೆ ಚಾ಼ಂದಿಚ಼ ಆನ ದಿಯಾಚ಼ ಹುತ್ತ, ಆನಿಯಕಾನಿ ಪನ್ನಾಸ್ ಚಾ಼ಂದಿಚ಼ ಆನ ದಿಯಾಚ಼ ಹುತ್ತ. ");
INSERT INTO gok_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","“ಫೆಡಾಯಾ ತ್ಯಂಚಿಪ ಕಾಯ್ ನವ್ಥ ಮನ್ಹುನ್ ತ್ಯನಿ ತ್ಯಾ ದೊಗಾನಾ ತ್ಯ ರೀನ್ ಶೊಡ್ಲ ತವಾ ತ್ಯಾತ್ಲಾ ತ್ಯಾ ಸಾವ್ಕಾರಾಲಾ ಕಚಾ಼ ಖುಬ್ ಮಾಯಾ ಕರ್ನಾರ್? ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","ತವಾ ಸಿಮೊನ್ ಕಚಾಲಾ ಖುಬ್ ಶೊಡ್‌ಲ್ಯಾ ತ್ಯೊ ಖುಬ್ ಮಾಯಾ ಕರ್ನಾರ್ ಮನ್ಲಾ, ತವಾ ಯೇಸು ಸಿಮೊನಾಲಾ “ಖರ ಸಾಂಗ್ಲಸ್” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","ಆನಿ ಯೇಸು “ತೆ ಬಾಯಿಲ್ಮಾನ್ಸಾಕ್ಡ ಬಗುನ್ ಸಿಮೊನಾಲಾ ತು ಹೆ ಬಾಯಿಲಾ ಬಗ್ಲೆಸ್ ಕ್ಯಾ? ಮನ್ಲಾ. ಮಿ ತುಜಾ ಗರ‍್ಹಾತ್ ಆಲೊ ತವಾ ತು ಮನಾ ಪ್ಯಾ ದುಹ್ಯಾ ಪಾನಿ ದಿಲನಾಹಿ ಫನ್ ಹಿನಿ ಆಪ್‌ಲ್ಯಾ ದುಃಖಾನಿ ಮಾಜ಼ ಪ್ಯಾ ದುವುನ್ ಆಪ್‌ಲ್ಯಾ ಕೇಸಾನಿ ತೆ ಪುಸ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","ತು ಯಂಗ್ದಾಬಿ ಮಾಜಾ಼ ಮುಕ್ಕಾ ಗೆತ್ಲಾ ನಾಹಿಸ್ ಫನ್ ಮಿ ಆತ್ ಆಲ್ಯಾ ದರ್ನಿ ಹಿನಿ ಮಾಜಾ ಪಾಯಾಂಚ಼ ಮುಕ್ಕ ಗಿಹ್ಯಾಚ಼ ಥಾಂಬಿವ್ಲ ನಾಹಿತ. ");
INSERT INTO gok_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","ತು ಮಾಜೆ ಡುಯಿಲಾ ತ್ಯಾಲ್ ಲ್ಯಾವ್ಲ ನಾಹಿಸ್ ಫನ್ ಹಿನಿ ಮಾಜಾ ಪಾಯಾಲಾ ವಾಸಾಚ಼ ತ್ಯಾಲ್ ಲ್ಯಾವ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","ಮನ್ಹುನ್ ಮಿ ತುಮಾನಾ ಸಾಂಗ್ತೊ ಹಿಚಿ ಕ್ಯಾ ಖುಬ್ ಪಾಪ ಹಾತತಿ ಮಾಪ್ ಜಾ಼ಲಿತ ಕಾ ಮಂಜೆ ಹಿನಿ ಖುಬ್ ಮಾಯಾ ಕಿಲಿ ಕಚಾಲಾ ಥುಡಿ ಮಾಪಿ ಜಾ಼ಲೆ ತ್ಯೊ ಥುಡಿ ಮಾಯಾ ಕರ್ತೊ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","ಮಂಗ್ ಯೇಸು ತಿಲಾ, “ತುಜಿ ಪಾಪ ಮಾಪ್‍ ಜಾ಼ಲಿತ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","ತವಾ ತ್ಯಚೆ ಸಂಗ ಜೆವ್ನಾಲಾ ಬಸ್‌ಲ್ಯಾಲ ದಿಸ್ರ, “ಪಾಪ ದಿಕಿಲ್ ಮಾಪಿ ಕರ್ನಾರಾ ಹ್ಯೊ ಕೊನ್? ಆಸ ಆಪ್‌ಲ್ಯಾ ಆಪ್‌ಲ್ಯಾತ್ ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","ಮಂಗ್ ಯೇಸು ತೆ ಬಾಯಿಲ್ ಮಾನ್ಸಾಲಾ, “ತುಜಾ ಇಸ್ವಾಸಾನಿ ತುಜ಼ ರಕ್ಶನ್ ಜಾ಼ಲ್ಯಾ ಸಮಾದಾನಾನಿ ಜಾ಼” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","ತ್ಯ ಜಾ಼ಲ್ಯಾ ನಂತರ್ ಯೇಸು ಉಪದೆಸ್ ಕರೀತ್ ದೇವಾಚಾ ರಾಜಾಚಿ ಖಬರ್ ಸಾಂಗಿತ್ ನಗರಾ ನಗರಾನಿ ಗಾವಾ ಗಾವಾನಿ ಫಿರತ್ ಹುತ್ತಾ ತವಾ ತ್ಯಚೆ ಸಂಗ ತೆ ಬಾರಾಜಾ಼ನ್ ಶಿಶಾ ಹುತ್ತ. ");
INSERT INTO gok_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ಥುಡಿ ಬ್ಯಾಯ್ಕಾ ಮಾನ್ಸ ಯೇಸು ಸಂಗ ಹುತ್ಯಾ ತ್ಯಾ ದುಶ್ಟ ಆತ್ಮಿ ಆನಿ ರೊಗಾತ್ನಿ ಸುಟ್ಕಿ ಕೆಲ್ಯಾಲ್ಯಾ ಆಸಿ ಕಿತಿತರಿ ಬ್ಯಾಯ್ಕಾ ಮಂಜೆ ತಿ ಮಗ್ದಲಿಯಾ ಮಂಥ್ಯಾಲೆ ಮರಿಯಾತ್ನಿ ಸಾತ್ ಲಾಗಿರ ನಿಗ್ಲಿ ಹುತ್ತಿತ. ");
INSERT INTO gok_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ಆನಿ ಹೆರೊದಾಚಾ಼ ಮ್ಯಾನೆಜರ್ಕಿ ಕರ್ನಾರಾ ಖುಜಾ ಹ್ಯಚಿ ಬ್ಯಾಯ್ಕೊ ಯೊಹನ್ನಾ, ತಸಿಸ್ ಸುಸನ್ನ, ಆನಿ ದುಸ್‌ರ‍್ಯಾ ಖುಬ್ ಬ್ಯಾಯ್ಕಾ ಮಾನ್ಸ ಹುತ್ತಿತ. ತ್ಯಾ ಆಪ್‌ಲ್ಯಾ ಪೈಶಾ ಅಡ್‌ಕ್ಯಾನಿ ತ್ಯನಾ ಮಜ಼ತ್ ಕರಿತ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","ತವಾ ಮೊಟಾ ಲೊಕ್ ಸಮುದಾಯ್ ಯಕಿಕ್ಡ ಜ಼ಮಲ್ಯಾಲಾ ಆಸ್ಥಾನಾ ಗಾವಾ ‍ಗಾವಾ‍ಚಿ ಲೊಕ ತ್ಯಚಿಪ ಯಯಿತ್ ಆಸ್ಥಾನಾ ಯೇಸು ಕ್ಯಾಯ್ನಿನಿ ಸಾಂಗಾಯಾ ಲಾಗ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","ಯೊಕ್ ಸೇತ್ಕರಿ ಬೀ ಪೆರಾಯಾ ನಿಗಾಲಾ; ಆನಿ ತ್ಯೊ ಪೀರಿತ್ ಆಸ್ಥಾನಾ ಕಾಯ್ ಥೊಡ ಬೀ ವಾಟವ ಪಡ್ಲ; ತ್ಯ ತುಡಾವ್ಲ ಆನಿ ಪಾಕ್ರಾಂಚಾನಿ ಖಾಲ. ");
INSERT INTO gok_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","ಆನಿ ಕಾಯ್ ಥೊಡ ಬೀ ದೊಂಡ್ಗಳ್ ಜಿಮ್ನಿತ್ ಪಡ್ಲ; ತ್ಯ ವಲ್ ನವ್ತಿ ಮನ್ಹುನ್ ಉಗಾವ್ತಾನಾಸ್ ವಾಳುನ್ ಗೆಲ. ");
INSERT INTO gok_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","ಆನಿ ಕಾಯ್ ಥೊಡ ಬೀ ಕಾಟ್ಯಾತ್ನಿ ಪಡ್ಲ; ಕಾಟ್ಯಾಚ಼ ಪಂದ ತ್ಯಚಿ ಬರ್ಬರ್ ವಾಡುನ್ ತ್ಯ ಬುಡಾಲ. ");
INSERT INTO gok_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","ಕಾಯ್ ಥೊಡ ಬೀ ಚಾ಼ಂಗ್ಲೆ ಜಿಮ್ನಿತ್ ಪಡ್ಲ ತ್ಯ ಉಗಾವ್ಲ ಆನಿ ಶೆಂಬರಾ ಯಿತ್ಕ ಪೀಕ್ ದಿಲ ಆಸ ಸಾಂಗುನ್ ತ್ಯೊ, “ಮೊಟ್ಯಾನಿ ಕಚಾಲಾ ಐಕಾಯಾ ಮನ್ ಹಾ ತ್ಯೊ ಐಕುನಿ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","ತವಾ ಯೇಸುಚಾ ಶಿಶಾಂಚಾನಿ ತ್ಯಲಾ “ಹೆ ಕ್ಯಾಯ್ನಿಚಾ಼ ಅರ್ಥ ಕ್ಯಾ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","ಯೇಸು ತ್ಯನಾ ಮನ್ಲಾ “ದೇವಾಚಾ ರಾಜಾಚಿ ಗುಟ್ ಸಮಜಾ಼ಯಾ ಸಾಟಿ ಗಿನ್ಯಾನ್ ತುಮಾನಾ ದಿಲ್ಯಾ. ಫನ್ ದಿಸರ‍್ಯಾನಾ ತ್ಯ ಕ್ಯಾಯ್ನಿನಿ ಸಾಂಗ್‍ಲ್ಯಾ, ಕಾ ಮಂಜೆ, ‘ತ್ಯಂಚಾನಿ ಬಗ್ಲ ತರಿ ತ್ಯನಾ ದಿಸತ್ ನಾಹಿ, ಆನಿ ಐಕ್ಲತರಿ ತ್ಯನಾ ಸಮ್ಜ಼ತ್ ನಾಹಿ’. ");
INSERT INTO gok_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","ಹಿ ಕ್ಯಾಯ್ನಿಚಾ಼ ಅರ್ಥ ಕ್ಯಾ ಮಂಜೆ ಬಿ ದೇವಾಚ಼ ವಚ಼ನ್. ");
INSERT INTO gok_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","ವಾಟವ ಪಡ್‌ಲ್ಯಾಲ ಬಿ ಮಂಜೆ? ಹಿ ದೇವಾಚಿ ವಚ಼ನ ಕೊನ್ ಐಕ್‍ತ್ಯಾತ ಮಂಗ್ ತ್ಯನಿ ಇಸ್ವಾಸ್ ಥಿವುನಾಹಿ ಆನಿ ತ್ಯಚ಼ ರಕ್ಶನ್ ವ್ಹವುನಾಹಿ ಮನ್ಹುನ್ ಸೈತಾನ್ ತ್ಯಂಚೆ ಆತ್ ಯವುನ್ ಮನಾತ್ಲ ವಚ಼ನ ಕಾಡುನ್ ಗೆತೊ. ");
INSERT INTO gok_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","ದೊಂಡ್ಕಾಳ್ ಜಿಮ್ನಿತ್ ಪಡ್‌ಲ್ಯಾಲ ಬೀ ಮಂಜೆ ತಿ ಐಕ್‍ತ್ಯಾತ ತವಾ ವಚ಼ನ ಆನಂದಾನಿ ಗೆಥ್ಯಾತ; ಫನ್ ತ್ಯನಾ ಮುಳ ನಸತ್ಯಾತ; ತಿ ಥೊಡ್ಯಾ ದಿಸಾ ಪರ‍್ಯಾತ್ ಇಸ್ವಾಸ್ ಥೆವ್‌ತ್ಯಾತ ಆನಿ ಪರಿಕ್ಶೆಚಾ ಯಳಾಲಾ ಪಡತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","ಕಾಟ್ಯಾಚಾ ಪಂದ್ಯಾತ್ ಪಡ್‌ಲ್ಯಾಲ ಬೀ ಮಂಜೆ ತಿ ಐಕ್‌ತ್ಯಾತ ಆನಿ ಸಂಸಾರಾಚಿ ಕ್ಯಾಳ್ಜಿ ಧನ್ ಆನಿ ಹ್ಯಾ ಲೋಕಾತ್‌ಲ್ಯಾ ಸುಖಾನಿ ರಾಹ್ಯಾ ಯವಸ್‍ತ್ಯಾತ ಹಿ ಪಕ್ಕ ಫಳ್ ದಿಯಿತ್ ನಾಹಿತ. ");
INSERT INTO gok_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","ಫನ್ ಚಾ಼ಂಗ್ಲೆ ಮಾತಿತ್ ಪಡ್‌ಲ್ಯಾಲ ಬೀ ಮಂಜೆ ತ್ಯ ವಚ಼ನ್ ಐಕುನ್ ಚಾ಼ಂಗಲ್ಯಾ ಗುನಾನಿ ಆನಿ ಚಾ಼ಂಗಲ್ಯಾ ಮನಾನಿ ದರುನ್ ಥೆವ್‍ತ್ಯಾತ ಆನಿ ದಿರ‍್ಹಾನಿ ಫಳ್ ದೇತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“ಕೊನ್ ದಿವಾ ಲಾವುನ್‍ ಐದಾನ ಬುಡಿ ನಾಹಿತ ಪಲಂಗಾ ಬುಡಿ ಥಿವಿತ್ ನಾಹಿತ ಆತ್ ಯತ್ಯಾಲ್ಯಾನಾ ಉಜಿಡ್ ದಿಸಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ತ್ಯೊ ದಿವಲಾವನ್ಯಾವ ಥೆವ್‌ತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","ಆಮಿ ಕಾಯ್ ತರಿ ಜಾ಼ಕುನ್ ಥೆವ್‌ಲ್ಯಾಲ ತ್ಯ ಉಜಿಡಾತ್ ಯಯಾ ಆನಿ ಕಾಯ್ತರಿ ಜಾ಼ಕುನ್ ಥೆವ್‌ಲ್ಯಾಲ ಉಜಿಡಾತ್ ದಿಸ್ತ. ");
INSERT INTO gok_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","ಮನ್ಹುನ್ ತುಮಿ ಕ್ಯಾ ಐಕ್ತಾಸಾ ತ್ಯಾ ಗುಶ್ಟಿನಾ ಜ಼ಪುನ್ ರಾವ್ಹಾ ಆಸ್ನಾರ‍್ಯಾಲಾಸ್ ದೇನಾರ್ ನಸ್ನಾರ‍್ಯಾಪ್ನಿ ತ್ಯಚ಼ ಕಾಯ್ ಥೊಡ ಆಸ್‌ಲ್ಯಾಲಬಿ ಕಾಡುನ್ ಗೆನಾರ್” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","ಯೇಸುಚಿ ಆಯಿ ಆನಿ ಬಾಹು ತ್ಯಚಿಪ ಆಲಿತ ಫನ್ ಗರ್ದಿಸ್ ಲಾಗುನ್ ತ್ಯನಾ ಯೇಸುಪ ಯಯಾ ವ್ಹಯಿನಾ. ");
INSERT INTO gok_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","ತವಾ “ತುಜಿ ಆಯಿ ಆನಿ ತುಜ಼ ಬಾಹು ತುಲಾ ಬಗಾಯಾ ಬಾಹಿರ್ ಉಬಿ ಹತ್ತ” ಮನ್ಹುನ್ ಯೇಸುಲಾ ಸಾಂಗ್ನ ಆಲ. ");
INSERT INTO gok_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","ತವಾ ಯೇಸುನಿ ತ್ಯನಾ, “ಕೊನ್ ದೇವಾಚಿ ವಚ್ನ ಐಕ್ತೊ ಆನಿ ತ್ಯಂಚಿಗತ್ ಚಾ಼ಲ್ತೊ ತಿಸ್ ಮಾಜಿ ಆಯಿ ಆನಿ ಬಾಹು!” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","ಯಕಸಿ ಯೇಸು ಆಪ್‌ಲ್ಯಾ ಶಿಶಾಂಚೆ ಸಂಗ ಯಕ ವ್ಹಡಿತ್ ಚ಼ಡುನ್, “ಸಮಿಂದೊರಾಚೆ ಪಲಿಕ್ಡ ಜಾ಼ವುಯಾ ಮನ್ಲ” ತವಾ ತ್ಯಂಚಾನಿ ವ್ಹಡಿ ಪಾನ್ಯಾತ್ ರಿಟುನ್ ನಿಗಾಲ್ಹ. ");
INSERT INTO gok_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","ಮಂಗ್ ತೆ ಜಾ಼ತಾ ಆಸ್ಥಾನಾ ಯೇಸುಚಿ ನೀಜ಼್ ಲಾಗ್ಲಿ ತವಾ ಸಮಿಂದೊರಾತ್ ಯಗ್ದಮ್ ಮುಟಿ ವಾವ್ಡಳ್ ಸುಟುನ್ ವ್ಹಡಿತ್ ಪಾನಿ ಬರ್ಲ ಆನಿ ತೆ ದೊಖ್ಯಾತ್ ಪಡ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","ತವಾ ಶಿಶಾ ಯೇಸುಪ ಯವುನ್ ತ್ಯಲಾ ಜಾ಼ಗಾ ಕರುನ್ “ಪ್ರಭು ಪ್ರಭು” ಆಮಿ ಬುಡಾಲಾವ್‌ ಮನ್ಲ, ತವಾ ತ್ಯನಿ ವಾರ‍್ಯಾಲಾ ಆನಿ ಪಾನ್ಯಾಲಾ ದಪ್‌ಕ್ಯಾವ್ಲ ತವಾ ವಾರ ಆನಿ ಪಾನಿ ಬಂದ್ ವ್ಹವುನ್ ಥಂಡ್ ಜಾ಼ಲ. ");
INSERT INTO gok_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","ತವಾ ಯೇಸು ತ್ಯನಾ, “ತುಮಚಾ಼ ಇಸ್ವಾಸ್ ಕುಠ ಹಾ? ಮನ್ಲಾ ತವಾ ತೆ ಬಿಹುನ್ ಗಾಭಾರ್ಲ ಆನಿ ಯಕಾಮಕಾಲಾ, “ಹ್ಯೊ ಕೊನ್ ಆಸಲ್? ಮನ್ಲ ವಾವ್ಡಳಿಲಾ ಆನಿ ಪಾನ್ಯಾಚಾ ಲ್ವಾಟಾನಾ ದಿಕಿಲ್ ಹ್ಯೊ ದಪ್‌ಕ್ಯಾವ್ತೊ ಆನಿ ತಿ ತ್ಯಚ಼ ಐಕ್‌ತ್ಯಾತ” ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","ಮಂಗ್ ಯೇಸು ಆನಿ ತ್ಯಚ಼ ಶಿಶಾ ಗಲಿಲಾಯಾಚಾ ಸಮಿಂದೊರ್ ವಲ್ಯಾಂಡುನ್ ಗೆನೆಜ಼ರೆತ್ ಸಿಮತ್ ಯವುನ್ ಪೊಚ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","ಯೇಸು ಜಿಮ್ನಿವ ಉತಾರ್ಲ್ಯಾ ಬರ್ಬರ್ ಗಾವಾತ್ಲಾ ಯೊಕ್ ಮಾನುಸ್ ತ್ಯಲಾ ಗಾವ್ಲಾ, ತ್ಯಲಾ ಲಾಗಿರ ಲಾಗ್ಲಿ ಹುತ್ತಿತ ಖುಬ್ ದಿಸ್ ತ್ಯನಿ ಕಪಡ ಗ್ಯಾತ್ಲ ನವ್ಥ ಆನಿ ಗರ‍್ಹಾತ್ ರಾಹಿತ್ ನವ್ಥಾ ಮಸುರ್ಡಿತ್ನಿ ರಾಹಿತಾ. ");
INSERT INTO gok_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","ತ್ಯನಿ ಯೇಸುಲಾ ಬಗುನ್ ಜೊ಼ರಾನಿ ವರ್ಡುನ್ ತ್ಯಚೆ ಮೊರ‍್ಹ ಪಾಯಾತ್ ಪಡುನ್, “ಯೆ ಯೇಸು ಪರಾತ್ಪರ್ ದೇವಾಚಾ ಲೇಕಾ ತು ಮಾಜೆ ಮಾಗ ಕಾ ಲಾಗ್‌ಲ್ಯಾಸ್? ಮಿ ತುಲಾ ಇನಂತಿ ಕರ್ತೊ ಮನಾ ಕಾಂಬ್ವು ನಕೊಸ್? ");
INSERT INTO gok_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","ಕಾ ಮಂಜೆ ಯೇಸುನಿ ತ್ಯಾ ಲಾಗಿರಾಲಾ ತ್ಯಾ ಮಾನ್ಸಾತ್ನಿ, “ಸುಡುನ್ ಜಾ಼” ಮನ್ಹುನ್ ದಪ್‌ಕ್ಯಾವ್ಲ ಹುತ್ತ. ತ್ಯ ಲಾಗಿರ್ ತ್ಯಲಾ ದರ‍್ಹುನ್ ಖುಬ್ ದೀಸ್ ಜಾ಼ಲ ಹುತ್ತ. ಆನಿ ಸಾಕ್‌ಳ್ಯಾನಿ ಆನಿ ಬೇಡ್ಯಾನಿ ತ್ಯಚ಼ ಹಾತ್ ಪ್ಯಾ ಲೊಕಾಂಚಾನಿ ಬಾಂದುನ್ ಥೆವ್ಲಾ ಹುತ್ತಾ ತರಿಬಿ ತ್ಯೊ ತಿ ಬಾಂದ್ನ ತುಡಿತಾ ಆನಿ ಲಾಗಿರ ತ್ಯಲಾ ರಾನಾತ್ ಹಾಕ್ಟುನ್ ನಿಹಿತ. ");
INSERT INTO gok_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","ಯೇಸುನಿ ತ್ಯಲಾ, “ತುಜ಼ ನಾವ್ ಕ್ಯಾ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ ತ್ಯೊ “ಹಿಂಡ್” ಮನ್ಲಾ ಕಾ ಮಂಜೆ ತ್ಯಚಿಪ ಖುಬ್ ಲಾಗಿರ ಬರ್ಲಿ ಹುತ್ತಿತ. ");
INSERT INTO gok_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","ತಿ ಯೇಸುಲಾ “ಆಮಾನಾ ಪಾತಾಳಾತ್ ಲಾವುನ್ ದಿವು ನಕೊ ಮನ್ಹುನ್ ಮಾಗ್ನ ಕರಿತಿತ. ");
INSERT INTO gok_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","ತಿಥ ಡುಕ್ರಾಂಚಾ಼ ಮೊಟಾ ಹಿಂಡ್ ಗುಢ್ಯಾವ ಚ಼ರತ್ ಹುತ್ತಾ ತ್ಯಾತ್ ಆಮಾನಾ ಲಾವುನ್ ದೇ ಮನ್ಹುನ್ ತ್ಯಾ ಲಾಗಿರಾಂಚಾನಿ ಯೇಸುಪ ಮಾಗ್ನ ಕೆಲ ತವಾ ಯೇಸುನಿ ತ್ಯನಾ ಲಾವುನ್ ದಿಲಿತ. ");
INSERT INTO gok_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","ತವಾ ಲಾಗಿರ ತ್ಯಾ ಮಾನ್ಸಾತ್ನಿ ನಿಗುನ್ ತ್ಯಾ ಡುಕ್ರಾತ್ನಿ ಬರ್ಲಿತ ಆನಿ ತ್ಯೊ ಖಾಂಡ್ ದಾವತ್ ಜಾ಼ವುನ್ ಗುಢ್ಯಾವ್ನಿ ಸಮಿಂದೊರಾತ್ ಪಡುನ್ ಬುಡಾಲಿತ. ");
INSERT INTO gok_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","ಮಂಗ್ ಡುಕ್ರ ಚಾರ್ನಾರಿ ಮಾನ್ಸ ಹ್ಯ ಜಾ಼ಲ್ಯಾಲ ಬಗುನ್, ಪಳಾಲಿತ ಆನಿ ಗಾವಾತಲ್ಯಾ ಆನಿ ಸೇತಾತ್‌ಲ್ಯಾ ಲೊಕಾನಾ ಜಾ಼ವುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","ತವಾ ಕ್ಯಾ ಜಾ಼ಲ್ಯಾ ತ್ಯ ಬಗಾಯಾ ಲೊಕ ನಿಗಾಲಿತ ಆನಿ ಯೇಸುಪ ಆಲಿತ ತವಾ ತ್ಯಾ ಮಾನ್ಸಾತ್ನಿ ಲಾಗಿರ ನಿಗ್ಲಿ ಹುತ್ತಿತ ಆನಿ ತ್ಯೊ ಯೇಸುಚಾ ಪಾಯಾಕ್ಡ ಚಾ಼ಂಗ್ಲ ಕಪ್ಡ ಗಾಲ್ಹುನ್; ಚಾ಼ಂಗ್ಲೆ ಬುದ್ದಿನಿ ಬಸ್‍ಲ್ಯಾಲಾ; ತ್ಯನಾ ದಿಸ್ಲಾ ತವಾ ತೀ ಬಿಹ್ಯಾಲಿತ. ");
INSERT INTO gok_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","ಕುನಿ ಕುನಿ ಹ್ಯ ಬಗ್ಲ ಹುತ್ತ ತ್ಯ ಲೊಕಾನಾ ಸಾಂಗ್ಲ ಕೊನ್ ತರನಿ ಹ್ಯೊ ಮಾನುಸ್ ಹಾ ಬರಾ ಜಾ಼ಲಾ ಮನ್ಹುನ್ ");
INSERT INTO gok_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","ತೇ ಗೆನೆಜ಼ರೇತ್ ಸಿಮೆತ್‌ಲ್ಯಾ ಲೊಕಾಂಚಾನಿ ಯೇಸುಲಾ ಆಮಾನಾ ಸುಡುನ್ ಜಾ಼ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ ಕಾ ಮಂಜೆ ತಿ ಖುಬ್ ಗಾಭಾರ್ಲಿ ಹುತ್ತಿತ ಮಂಗ್ ಯೇಸು ವ್ಹಡಿತ್ ಬಸುನ್ ಜಾ಼ತಾನಾ. ");
INSERT INTO gok_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","ತವಾ ಕಚಾ ಮಾನ್ಸಾತ್ನಿ ಲಾಗಿರ ನಿಗ್ಲಿ ಹುತ್ತಿತ ತ್ಯೊ ಮಾನುಸ್ ಯೇಸುಪ “ಮನಾ ತುಜಿ ಸಂಗ ಯವುದೆ” ಮನ್ಹುನ್ ಮಾಗ್ನ ಕರಯಾ ಲಾಗ್ಲಾ ಫನ್ ಯೇಸು ತ್ಯಲಾ, “ಮಾಗಾರಾ ಪರ್ತುನ್ ಜಾ಼” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“ತು ಗರ‍್ಹಾತ್ ಪರ್ತುನ್ ಜಾ಼ ಆನಿ ದೇವಾನಿ ತುಜೆ ಸಾಟಿ ಕಿತಿ ಮೊಟ ಕಾಮ್ ಕೆಲ ತ್ಯ ಸಗ್‌ಳ್ಯಾನಾ ಸಾಂಗಿತ್ ಜಾ಼” ಮನ್ಲಾ. ಮಂಗ್ ತ್ಯೊ ಯೇಸುನಿ ಆಪ್‌ಲ್ಯಾಲಾ ಕೆಲ್ಯಾಲಿ ಕಾಮ ಗಾವ್ಬರ್ ಸಾಂಗಿತ್ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","ಮಂಗ್ ಯೇಸು ಪರತ್ ಆನಿ ಯಕ ದರವ ಆಲಾ ತವಾ ಲೊಕ್ ಸಮುದಾಯಾನಿ ತ್ಯಲಾ ಸ್ವಾಗತ್ ಕೆಲಾ; ಕಾ ಮಂಜೆ ತೀ ಸಗ್ಳಿ ತ್ಯಚಿ ವಾಟ್ ಬಗಿತ್ ಹುತ್ತಿತ. ");
INSERT INTO gok_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","ತವಾ ಯಾಯಿರ್ ನಾವಾಚಾ಼ ಯೊಕ್ ಮಾನುಸ್ ಆಲಾ ತ್ಯೊ ಸಭಾಸ್ಥಾನಚ಼ಾ ಅಧಿಕಾರಿ ಹುತ್ತಾ. ತ್ಯನಿ ಯೇಸುಚಾ ಪಾಯಾತ್ ಪಡುನ್ ತ್ಯನಿ ಆಪ್‌ಲ್ಯಾ ಗರ‍್ಹಾತ್ ಯಯಾ ಇನಂತಿ ಕಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ಕಾ ಮಂಜೆ ತ್ಯಲಾ ಸುಮಾರ್ ಬಾರಾ ವರ್ಸಾಚಿ ಯೇಕುಸ್ ಲೇಕ್ ಹುತ್ತಿ ತಿ ಮರಾಯಾ ಜಾ಼ಲ್ಥಿ ತವಾ ಯೇಸು ತ್ಯಂಚಿ ಸಂಗ ಜಾ಼ತಾನಾ ಲೊಕ ತ್ಯಚೆ ಸರ್ಬೌತ ಜ಼ಮ್ಲಿ ಹುತ್ತಿತ. ");
INSERT INTO gok_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","ತ್ಯಾ ಹಿಂಡಾತ್ ಯೇಕ್ ಬ್ಯಾಯ್ಕಾ ಮಾನುಸ್ ಬಾರಾ ವರ್ಸಾದರ್ನಿ ರಗಾತ್ ಜಾ಼ಯಿತ್ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ರೊಗಾತ್ನಿ ತರಾಸ್ ಖಾಯಿತಿ ತಿನಿ ತೀಚಿಪ್ಲ ಆಸ್‌ಲ್ಯಾಲ ಪೈಸ ಸಗ್ಳ ಸಪಿವ್ಲ ಖರ ಕುನಾಲಾಸ್ ಬರ ಕರಾಯಾ ಜಾ಼ಲ ನಾಹಿ, ");
INSERT INTO gok_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","ಯೇಸುಚೆ ಮಾಗ ಯವುನ್ ತ್ಯಚಾ ಕಪ್‌ಡ್ಯಾಲಾ ಹಾತ್ ಲ್ಯಾವ್ಲಾ ತವಾಸ್ ತಿಚ಼ ರಗಾತ್ ಜಾ಼ತ್ಯಾಲ ಥಾಂಬ್ಲ ");
INSERT INTO gok_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","ಫನ್ ಯೇಸು ಮನ್ಲಾ ಮನಾ ಕುನಿ ಹಾತ್‍ ಲ್ಯಾವ್ಲಾಸಾ? ತವಾ ಸಗ್ಳಿ ಜ಼ನ ಮಿ ನವ ಮಿ ನವ ಮನ್ಹಿತಿತ ತವಾ ಪೇತ್ರ, “ಪ್ರಭು ಲೊಕಾಂಚಿ ಗರ್ದಿ ತುಜೆ ಸರ್‌ಬವಾರಿ ಹಾ” ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","ಫನ್ ಯೇಸು, “ಕುನಿತರಿ ಮನಾ ಹಾತ್ ಲ್ಯಾವ್‌ಲ್ಯಾ ಮಾಜಿಪ್ನಿ ದೇವಾಚ಼ ಬಳ್ ಗೆಲ ಹ್ಯ ಮನಾ ಸಮಾಜ಼್ಲ” ಮನ್ಲಾ ");
INSERT INTO gok_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","ಮಂಗ್ ಮಿ ದಡುನ್ ರಾಹಿಲೆ ನಾಹಿ ಮನ್ಹುನ್ ಸಮಜು಼ನ್ ತೀ ಬ್ಯಾಯ್ಕೊ ಮಾನುಸ್ ಕ್ಯಾಪ್ರ ಬರ‍್ಹುನ್ ಮೊರ‍್ಹ ಯವುನ್ ತ್ಯಚಾ ಪಾಯಾತ್ ಪಡುನ್ ಆಪ್ನು ಕ್ಯಾ ಕಾರ್ನಾನಿ ತ್ಯಲಾ ಹಾತ್ ಲ್ಯಾವ್ಲಾ ತವಾಸ್ ಕಸಿ ಬರಿ ಜಾ಼ಲಿ ತ್ಯ ತಿನಿ ಸಗ್‍ಳ್ಯಾ ಲೊಕಾಂಚೆ ಮೊರ‍್ಹ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","ತವಾ ಯೇಸು ತಿಲಾ, “ಲಿಕಿ, ತುಜಾ ಇಸ್ವಾಸಾನಿ ತುಲಾ ಬರ ಕೆಲ್ಯಾ ಶಾಂತಿನಿ ಜಾ಼” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","ಯೇಸು ಬೊಲತ್ ಆಸ್ಥಾನಾ ಸಬಾಮಂದಿರಾತ್ಲಾ ಅಧಿಕಾರಿಚಾ ಗರ‍್ಹಾಕ್ಲಾ ಯೊಕ್ ಯವುನ್ ತ್ಯಾ ಅಧಿಕಾರ‍್ಯಾಲಾ, “ತುಜಿ ಲೇಕ್ ಮಿಲಿ ಆನಿ ಆತಾ ಪ್ರಭುಲಾ ಕಾಂಬು ನಕೊಸ್” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","ತ್ಯ ಐಕುನ್ ಯೇಸು ಯಾಯಿರಾಲಾ ಮನ್ಲಾ, “ಭಿಹುನಕೊ ಇಸ್ವಾಸ್ ತ್ಯವ್ಡಾಸ್ ರಾಹುನಿ ಮಂಜೆ ತಿ ಬರಿ ವ್ಹಯಿಲ್. ” ");
INSERT INTO gok_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","ನಂತರ್ ತ್ಯಾ ಗರ‍್ಹಾತ್ ಆಲ ತವಾ ಯೇಸು, ಪೇತ್ರ, ಯೊಹಾನ್, ಯಾಕೊಬ್, ಆನಿ ಪುರಿಚಿ ಆಯಿ ಬಾ ಹೆಂಚಿ ಸಿವಾರ್ ಆನಿ ಕುನಾಲಾ ಆಪ್ಲಿ ಸಂಗ ಆತ್ ಯವುದಿಲ ನಾಹಿತ. ");
INSERT INTO gok_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","ಮೆಲ್ಯಾಲೆ ಪುರಿಸಾಟಿ ಸಗ್ಳಿ ಲೊಕ ರಡತ್ ಹುತ್ತಿತ ಆನಿ ದುಃಖಾತ್ ಹುತ್ತಿತ ಫನ್ ಯೇಸು ಮನ್ಲಾ, “ರಡುನಕೊಸಾ ಕಾ ಮಂಜೆ ತಿ ಮೀಲಿ ನಾಹಿ ನಿಜ಼ಲೆ. ” ");
INSERT INTO gok_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","ಫನ್ ಪ್ಯೊರ್ ಮೆಲ್ಯಾಲಿ ಸಮ್ಜುನ್ ತೀ ಲೊಕ ಸಗ್ಳಿ ಯೇಸುಲಾ ಹಸಾಯಾ ಲಾಗ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","ಮಂಗ್ ಯೇಸುನಿ ತಿಚಾ಼ ಹಾತ್ ದರ‍್ಹುನ್ “ಬಾಯಾ ಉಟ್” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","ತವಾಸ್ ತಿಚಾ಼ ಜೀವ್ ಪರತ್ ಆಲಾ ಆನಿ ತಿ ತವಾಸ್ ಉಟ್ಲಿ ಮಂಗ್ ತಿಲಾ ಕಾಯ್ತರಿ ಖಾಯಾ ದೇವಾ ಮನ್ಹುನ್ ಯೇಸುನಿ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","ತವಾ ಪುರಿಚಿ ಆಯಿಬಾ ಗಾಭಾರ್ಲಿತ: “ಫನ್ ಹಿ ಗಡ್‌ಲ್ಯಾಲಿ ಗ್ಯೊಶ್ಟ್ ಕುನಾಲಾ ಸಾಂಗು ನಕೊಸಾ” ಆಸ ಯೇಸುನಿ ತ್ಯನಾ ಖಡ್ಯಾವ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","ಮಂಗ್ ಯೇಸುನಿ ಬಾರಾಜಾ಼ನ್ ಅಪೊಸ್ತಲಾನಾ ಯಕಾನ್ಸಿ ಹಾಕ್ಟುನ್ ಸಗ್ಳಿ ಲಾಗಿರ ಕಾಡಾಯಾ ಆನಿ ರ‍್ವಾಗ್ ಬರ ಕರಾಯಾ ಬಳ್ ಆನಿ ಹುಕುಮ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","ಆನಿ ತ್ಯನಾ ದೇವಾಚಾ ರಾಜಾಚಿ ಖಬರ್ ಸಾಂಗಾಯಾ ಆನಿ ರೊಗಿನಾ ಬರ ಕರಾಯಾ ಲಾವುನ್ ದಿಲ. ");
INSERT INTO gok_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","ಯೇಸುನಿ ತ್ಯನಾ ಸಾಂಗ್ಲ, “ಪ್ರವಾಸಾಲಾ ಜಾ಼ತಾನಾ ಕಾಠಿ ಜು಼ಳ್ಹಿ ಬಾಖರಿ ನಾಹಿತ ಪೈಸ ಗಿಹುನಕೊಸಾ. ಅಗಾವ ಆಂಗ್ಯಾ ಗಿಹುನಕೊಸಾ. ");
INSERT INTO gok_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","ಕಚಾ ಗರ‍್ಹಾತ್ ತುಮಿ ಜಾ಼ಸಿಲಾ ತ್ಯಾ ಗರ‍್ಹಾತುಸ್ ರಾವ್ಹಾ, ");
INSERT INTO gok_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","ಕೊನ್ ತುಮಾನಾ ಹಾಕ್ಟಿತ್ ನಾಹಿ ತ್ಯಂಚೆ ಆಡ್ವ ಸಾಕ್ಶಿ ರಾವ್ಹಾವ ಮನ್ಹುನ್ ತುಮಿ ತ್ಯಾ ಗಾವಾತ್ನಿ ನಿಗುನ್ ಜಾ಼ತಾನಾ ತುಮ್ಚಾ ಪಾಯಾಚಿ ಧುಳ್ ತಿಥ ಜಾ಼ಢಾ ತೀಸ್ ತುಮಾನಾ ವಳಕ್ ವ್ಹವುನ್ ರಾಹುನಿ” ಮನ್ಲಾ ");
INSERT INTO gok_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","ಮಂಗ್ ತೆ ನಿಗುನ್ ಸಗ್ಳಿಕ್ಡ ಖಬರ್ ಸಾಂಗಿತ್ ಆನಿ ರ‍್ವಾಗ್ ಬರ ಕರೀತ್ ಗಾವಾಗಾವಾನಿ ಫಿರಾಯಾಲಾಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","ತವಾ ಜಾ಼ಲ್ಯಾಲ್ಯಾ ಸಗ್‌ಳ್ಯಾ ಗುಶ್ಟಿ ಮಂಡಳಿಚಾ ಹೆರೊದಾನಿ ಐಕ್‍ಲ್ಯಾ ಆನಿ ತ್ಯೊ ಮೊಟೆ ಗಡಬಡಿತ್ ಪಡ್ಲಾ. ಕಾ ಮಂಜೆ ಬಾಪ್ತಿಸ್ಮಾ ಯೊಹಾನ್ ಮರುನ್ ಉಟ್‍ಲ್ಯಾ ಆಸ ಥುಡಿ ಲೊಕ ಮನ್ಹಿತಿತ. ");
INSERT INTO gok_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ಕಾಯ್ ಥುಡಿ, “ಯಲಿಯಾ ದಿಸ್ಲಾ” ಮನ್ಹಿತಿತ. ಆನಿ ಕಾಯ್ ಥುಡಿ, “ಪೈಲ್ಯಾ ಕಾಲಾತ್ಲಾ ಪ್ರವಾದಿತ್ಲಾ ಕೊನ್ತರಿ ಪುನಾ ಉಠುನ್ ಅಲ್ಯಾ” ಆಸಿ ಮನ್ಹಿತಿತ. ");
INSERT INTO gok_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","ಫನ್ ಹೆರೊದ್, “ಮಿಚ್ ಯೊಹಾನಾಚಿ ಮಾನ್ ಮ್ಯಾರ್ಲೆ ಆನಿ ಹ್ಯೊ ಕೊನ್? ಆಸ್‌ಲ್ಯಾ ಗುಶ್ಟಿ ಮಿ ಐಕ್‌ತ್ಯೊ ಮನ್ಹುನ್ ತ್ಯಲಾ ಬಗಾಯಾ ಯೇಳ್ ಬಗಿತ್ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","ಮಂಗ್ ಅಪೊಸ್ತಲಾಂಚಾನಿ ಪರತ್ ಯವುನ್ ಆಪ್ನು ಕ್ಯಾ ಕ್ಯಾ ಕೆಲ ತ್ಯ ತ್ಯ ಪುಡುನ್ ಸಾಂಗ್ಲ. ತವಾ ಯೇಸುನಿ ತ್ಯನಾ ಸಂಗ ಗಿಹುನ್ ಬೆತ್ಸಾಯಿದ ನಾವಾಚಾ ಗಾವಾಕ್ಡ ಯಕಾನ್ಸಿ ಜಾ಼ಗ್ಯಾವ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","ಹ್ಯ ಸಮಜು಼ನ್ ಲೊಕಾಂಚಾ಼ ಹಿಂಡ್ ತ್ಯಚೆ ಮಾಗ್ನಿ ಗೆಲಾ ತವಾ ತ್ಯನಾ ಸ್ವಾಗತ್ ಕರುನ್ ತ್ಯೊ ತ್ಯಂಚೆ ಸಂಗ ದೇವಾಚಾ ರಾಜಾಚಾ ಗುಶ್ಟಿ ಬೊಲತ್ ಹುತ್ತಾ, ಆನಿ ಕುನಾಲಾ ಬರ ವ್ಹಯಾಚ಼ ವ್ಹಯಿ ಹುತ್ತ. ತ್ಯನಾ ಬರ ಕರೀತ್ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","ದೀಸ್ ಮಾವ್ಳತ್ ಆಲಾ ತವಾ ತೇ ಬಾರಾಜಾ಼ನ್ ಅಪೊಸ್ತಲ್‍ ಕಡಸ್ ಯವುನ್ ಯೇಸುಲಾ ಮನ್ಲ, “ಲೊಕಾನಾ ಹುಕುಮ್ದೆ ಮಂಜೆ ತಿ ಬೌಥಚಾ ಗಾವಾತ್ನಿ ಆನಿ ಸೆತಾತ್ನಿ ಜಾ಼ವುನ್ ಖಾನ್ಯಾಚಿ ಸುಯಿ ಕರುಂತ ಕಾ ಮಂಜೆ ಆಮಿ ಯಾಕಾನ್ಸಿ ಜಾ಼ಗ್ಯಾವ ಹಾವ್. ” ");
INSERT INTO gok_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","ಫನ್ ಯೇಸು ತ್ಯನಾ, “ತುಮಿಸ್ ತ್ಯನಾ ಖಾಯಾದೆವಾ” ಮನ್ಲಾ. ತವಾ ತೆ, “ಆಮಿ ಹ್ಯಾ ಸಗ್‍ಳ್ಯಾ ಲೊಕಾಂಚಿ ಸಾಟಿ ಜೆವಾನ್ ಇಕತ್ ಆನಾ ವ್ಹಯಿ ಕಾ ಮಂಜೆ ಪಾಚ಼್ ಬಾಕ್‌ರ‍್ಯಾ ಆನಿ ದೊನ್ ಮಾಸ ಯವ್‌ಡ್ಯಾ ಸಿವಾರ್ ಆಮ್ಚಿಪ ಕಾಯ್ ನಾಹಿ” ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","ಕಾ ಮಂಜೆ ತೇ ಜ಼ವಳ್ ಜ಼ವಳ್ ಪಾಚ಼್ ಹಾಜಾ಼ರ್ ಗಡಿ ಮಾನುಸುಸ್ ಹುತ್ತ ತವಾ ಯೇಸುನಿ ಆಪ್‌ಲ್ಯಾ ಅಪೊಸ್ತಲಾನಾ ಸಾಂಗ್ಲ ಪನ್ನಾ ಪನ್ನಾಸ್ ಲೊಕಾಂಚಾ ಪಂಗ್ತಿ ಬಸ್ವಾ. ");
INSERT INTO gok_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","ತ್ಯಂಚಾನಿ ತಸ ಕರುನ್ ಸಗ್‌ಳ್ಯಾನಾ ಬಸಿವ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","ತವಾ ಯೇಸುನಿ ತ್ಯಾ ಪಾಚ಼್ ಬಾಕ್‌ರ‍್ಯಾ ದೊನ್ ಮಾಸ ಗಿಹುನ್, ಪರಲೊಕಾಕ್ಡ ಬಗುನ್, ತ್ಯನಾ ಆಶಿರ್ವಾದ್ ಕೆಲಾ ಆನಿ ತ್ಯಂಚ಼ ತುಕ್ಡ ಕರುನ್ ತೆ ಲೊಕಾನಾ ವಾಡಾಯಾ ಅಪೊಸ್ತಲಾಂಚಿಪ ದಿಲ. ");
INSERT INTO gok_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","ತವಾ ಸಗ್ಳಿ ಜ಼ನ ಜಿವುನ್ ತ್ರಪ್ತ ಜಾ಼ಲ್ಹಿತ ಆನಿ ತ್ಯಂಚಾನಿ ಉರ್ಲ್ಯಾಲ ತುಕ್ಡ ಬರ್ಲತೆ ಬಾರಾ ಬುಟ್ಯಾ ಜಾ಼ಲ. ");
INSERT INTO gok_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","ಯಂಗ್ದಾ ಯೇಸು ಯಕಾನ್ಸಿ ಮಾಗ್ನ ಕರೀತ್ ಆಸ್ಥಾನಾ ತ್ಯಚ಼ ಅಪೊಸ್ತಲ ಸಂಗ ಹುತ್ತ ತವಾ ಯೇಸುನಿ ತ್ಯನಾ “ಲೊಕ ಮನಾ ಕೊನ್ ಮಂಥ್ಯಾತ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","ಮಂಗ್ ತ್ಯಂಚಾನಿ, “ಬಾಪ್ತಿಸ್ಮಾ ಯೊಹಾನ್ ಮಂತ್ಯಾತ; ಆನಿ ಕಾಯ್ ಥುಡಿ ಯಲಿಯಾ ಮಂಥ್ಯಾತ; ಆನಿ ಕಾಯ್ ಥುಡಿ ಪೈಲ್ಯಾ ಕಾಲಾತ್‌ಲ್ಯಾ ಪ್ರವಾದಿತ್ಲಾ ಕೊನ್ಯೊಕ್ ಪುನ್ಹಾ ಉಠುನ್ ಆಲ್ಯಾ ಮಂಥ್ಯಾತ” ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","ಯೇಸುನಿ ತ್ಯಾನಾ, ಫನ್ ತುಮಿ ಮಿ ಕೊನ್ ಮಂಥಸಾ? ತವಾ ಪೇತ್ರ, “ತು ದೇವಾಚಾ಼ ಕ್ರಿಸ್ತ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","ಮಂಗ್ ಹ್ಯ ಕುನಾಲಾ ಸಮಜು಼ನಾಹಿ ಮನ್ಹುನ್ ಯೇಸುನಿ ತ್ಯನಾ ಖಡ್ಯಾವ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","ಆನಿ ಮಾನ್ಸಾಚಾ ಲೇಕಾನಿ ಖುಬ್ ತರಾಸ್ ಖಾವಾವ ಆನಿ ವಡ್ಲಾಂಚಿಪ್ನಿ ಮುಖ್ಯ ಯಾಜಕ್ ಆನಿ ದರ್ಮಶಾಸ್ತ್ರಾಚ಼ ಶಾನ ರಾಗ್ ಕರುನ್ ಜೀವಾನಿ ಮಾರ‍್ನಾರ್ ಆನಿ ತಿನ್ವೆ ದಿಸಿ ಪರತ್ ಉಟ್ನಾರ್ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","ಮನ್ಹುನ್ ಯೇಸು ಸಗ್‌ಳ್ಯಾನಾ ಮನ್ಲಾ, “ಜ಼ರ್ ಕೊನ್ ಮಾಜೆ ಮಾಗ್ನಿ ಯಯಾ ಬಗ್ತೊ ತ್ಯನಿ ಆಪ್ಲಾ ಜೀವ್ ಇಸ್ರುನ್ ದರೊಜ್ ಆಪ್ಲಿ ಶಿಲ್ಬೆ ಉಚ್ಲು಼ನ್ ಗಿಹುನ್ ಮಾಜೆ ಮಾಗ್ನಿ ಯವಾವ. ");
INSERT INTO gok_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","ಕೊನ್ ಆಪ್ಲಾ ಜೀವ್ ಉರ್ವಾಯಾ ಬಗ್ತೊ ತ್ಯೊ ಜೀವಾಲಾ ಮುಕಲ್, ಫನ್ ಕೊನ್ ಮಾಜಿಸ್ ಲಾಗುನ್ ಆಪ್‌ಲ್ಯಾ ಜೀವಾಲಾ ಮುಕಲ್ ತ್ಯಲಾ ಪರತ್ ಮಿಳಲ್. ");
INSERT INTO gok_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","ಯಕಾ ಮಾನ್ಸಾನಿ ಸಗ್ಳಾ ಪರಪಂಚಾ ಮಿಳ್ವುನ್ ಸ್ವತಾ ಆಪ್ಲಾ ಜೀವ್ ನಾಸ್ ಕರುನ್ ಗೆತ್ಲಾಕಿ ತ್ಯಲಾ ಕ್ಯಾ ಫ್ಯಾಯ್ದಾ? ");
INSERT INTO gok_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","ಕೊನ್ ಮನಾ ಆನಿ ಮಾಜಾ ಸಬ್ದಾನಾ ಲಾಜ಼ತೊ ತ್ಯಲಾ ಮಾನ್ಸಾಚಾ಼ ಲ್ಯೊಕ್ ಆಪಲ್ಯಾ ಬಾ ದೆವಾಚಾ಼, ಆನಿ ಸ್ವರ್ಗಾಚ಼ ಪವಿತ್ರ ದೇವ್‌ ಧುತಾಂಚಾ ಗೌರವಾನಿ ಯತಾನಾ ಲಾಜ಼ಲ್‌. ");
INSERT INTO gok_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","ಮಿ ಖರ ಸಾಂಗ್ತೊ ಹಿತ ಉಬಿ ಆಸ್ನಾರ‍್ಯಾತ್ ಕಾಯ್ ಥುಡಿ ದೇವಾಚ಼ ರಾಜ ಬಗಿ ಪರ್ಯಾತ್ ಮರ್ನಾರ್ ನಾಹಿತ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","ಹ್ಯಾ ಬೊಲ್‌ನ್ಯಾ ನಂತರ್ ಆಟ್ ದಿಸಾನಿ ಪೇತ್ರಾ, ಯೊಹಾನ್, ಆನಿ ಯಾಕೊಬ್, ಹ್ಯನಾ ಸಂಗ ಗಿಹುನ್ ಯೇಸು ಗುಢ್ಯಾವ ಮಾಗ್ನ ಕರಾಯಾ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","ಆನಿ ತ್ಯೊ ಮಾಗ್ನ ಕರೀತ್ ಆಸ್ಥಾನಾ ತ್ಯಚ಼ ತ್ವಾಂಡ್ ಬದಲುನ್ ತ್ಯಚ಼ ಕಪ್ಡ ಪಾಂಡ್ರ ಚ಼ಕ್ಚ಼ಕಿತ್ ಜಾ಼ಲ. ");
INSERT INTO gok_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","ತವಾಸ್ ಮೊಶೆ ಆನಿ ಯಲಿಯಾ ಹೆ ದೊಗಜಾ಼ನ್ ತ್ಯಚಿ ಸಂಗ ಬೊಲತ್ ಹುತ್ತ. ");
INSERT INTO gok_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ತೆ ದೊಗ ಚ಼ಕ್ಚ಼ಕಿತ್ ದಿಸ್ಲ ಆನಿ ಯೆರುಸಲೇಮಿತ್ ವ್ಹಯಾಚಾ ಮರನಾಚ಼ ಯೇಸು ಸಂಗ ಬೊಲತ್ ಹುತ್ತ. ");
INSERT INTO gok_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","ತವಾ ಪೇತ್ರ ಆನಿ ತ್ಯಚ಼ ಸುಪ್ತಿ ಪೆಂಗತ. ಫನ್ ತೆ ಜಾ಼ಗ ಜಾ಼ಲ ಆನಿ ತ್ಯನಾ ತಚಿ ಮೈಮಾ ಆನಿ ತ್ಯಚೆ ಸಂಗ ಉಬ ರಾಹಿಲ್ಯಾಲ ದೊಗ ಮಾನುಸ್ ದಿಸಲ. ");
INSERT INTO gok_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","ಮಂಗ್ ತೆ ದೊಗ ಯೇಸುಪ್ನಿ ಜಾ಼ತಾ ಆಸ್ಥಾನಾ ಪೇತ್ರ ಯೇಸುಲಾ “ಪ್ರಭು ಆಮಿ ಹಿತ್ತಸ್ ರಾಯ್‌ಲ್ಯಾವ ಬರಹಾ ಆಮಿ ತೀನ್ ಖೊಪ್ಟ ಕರುಯಾ ತುಜೆ ಸಾಟಿ ಯಾಕ್ ಮೊಶೆ ಸಾಟಿ ಯಾಕ್ ಆನಿ ಯಲಿಯಾ ಸಾಟಿ ಯಾಕ್” ಮನ್ಲಾ ಹ್ಯ ಬೊಲತ್ಯಾಲ ತ್ಯಚ಼ ತ್ಯಲಾಸ್ ಸಮಾಜ಼್ಲ ನವ್ತ. ");
INSERT INTO gok_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","ತ್ಯೊ ಹ್ಯ ಬೊಲತ್ ಆಸ್ಥಾನಾಸ್ ಢಗ್ ಯವುನ್ ತ್ಯಂಚಿವ ಉತಾರ್ಲಾ ಆನಿ ತೆ ಢಗಾತ್ ಬರ್ಲ ತವಾ ಹೆ ಬಿಹ್ಯಾಲ. ");
INSERT INTO gok_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","ತವಾಸ್ ಢಗಾತ್ನಿ, “ಹ್ಯೊ ಮಾಜಾ಼ ಲ್ಯೊಕ್ ಮಿ ನಿವಡ್‌ಲ್ಯಾಲಾ ಹಾ ಹ್ಯಚ಼ ತುಮಿ ಐಕಾ” ಆಸಾ ಸಬ್ದ ಆಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","ಹ್ಯೊ ಸಬ್ದ ಆಲಾ ತವಾ ಯೇಸು ಯಕ್ಲಾಸ್ ದಿಸ್ಲಾ ಹ್ಯಾ ನಂತರ್ ತೆ ಗಪ್ ರಾಹಿಲ ಆನಿ ತ್ಯಂಚಾನಿ ಬಗಲ್ಯಾ ಹುತ್ಯಾ ತ್ಯಾತ್ಲಿ ಎಕ್ಬಿ ತ್ಯಾ ದಿಸಾತ್ ತ್ಯಂಚಾನಿ ಕುನಾಲಾ ಸಾಂಗ್ಲಿ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","ಮಂಗ್ ದುಸರೆ ದಿಸಿ ತೆ ತಿಗ ತ್ಯಾ ಗುಢ್ಯಾವ್ನಿ ಖಾಲ್ ಆಲ್ಯಾವ ಮೊಟಾ ಲೊಕಾಂಚಾ಼ ಹಿಂಡ್ ತ್ಯಲಾ ಯವುನ್ ಭೇಟ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","ತವಾ ಹಿಂಡಾತ್ಲಾ ಯೊಕ್ ಮಾನುಸ್ ಮೊಟ್ಯಾನಿ ವರ್ಡುನ್ “ಪ್ರಭು ಮಿ ತುಮ್ಚಿಪ ಮಾಗ್ನ ಕರ್ತೊ ಮಾಜಾ ಲೇಕಾಲಾ ಬಗ್ ಕಾ ಮಂಜೆ ಹ್ಯೊ ಮಾಜಾ಼ ಯಕ್ಲಾಸ್ ಯೊಕ್ ಲ್ಯೊಕ್ ಹಾ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","“ಆನಿ ಯಾಕ್ ಭುಥ್ ಹ್ಯಲಾ ದರ್ಥ ಆನಿ ಹ್ಯೊ ಯಕಾಯಖಿ ವರಾಡ್ತೊ ಆನಿ ಹ್ಯಚಾ ತೊಂಡಾತ್ನಿ ಫ್ಯೊಸ್ ಯತೊ ತ್ಯ ಹ್ಯಲಾ ಖುಬ್ ತರಾಸ್ ದೇತ. ");
INSERT INTO gok_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","ಹ್ಯ ಕಾಡುನ್ ಟಾಕಾ ಮನ್ಹುನ್ ತುಜಾ ಅಪೊಸ್ತಲಾನಾ ಸಾಂಗ್ಲ ಫನ್ ತ್ಯ ತ್ಯನಾ ಕಾಡಾ ವ್ಹಯಿನಾ. ” ");
INSERT INTO gok_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","ಯೇಸು ಮನ್ಲಾ “ಇಸ್ವಾಸ್ ನಸ್‌ಲ್ಯಾಲಿ ಆನಿ ಬುರ್ಸಿ ಲೊಕ ತುಮಿ ಮಿ ಕುಟ್ಪರ‍್ಯಾತ್ ತುಮ್ಚಿ ಸಂಗ ರಾಹು ಆನಿ ತುಮಾನಾ ಸುಸುವು? ತು ತುಜಾ ಪ್ಯೊರ್ಗ್ಯಾಲಾ ಹಿಕ್ಡ ಗಿಹುನ್ ಯೇ? ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","ತ್ಯೊ ಪ್ಯೊರ್ಗಾ ಜ಼ವಳ್ ಯತಾನಾ ಲಾಗಿರಾನಿ ತ್ಯಲಾ ಆಪಟ್ಲಾ ಆನಿ ಪಿಳುನ್ ಟ್ಯಾಕ್ಲಾ ಫನ್ ಯೇಸುನಿ ತ್ಯಾ ಲಾಗಿರಾಲಾ ದಪ್‌ಕ್ಯಾವ್ಲ ಆನಿ ಪ್ಯೊರ್ಗ್ಯಾಲಾ ಬರಾ ಕರುನ್ ತ್ಯಚಾ ಬಾಚಾ ತಾಬ್ಯಾತ್ ಪರ್ತುನ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","ದೇವಾಚ಼ ಹ್ಯ ಮೊಟ ಕಾಮ್ ಬಗುನ್ ಸಗ್ಳಿ ಲೊಕ ಗಾಭಾರ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“ತುಮಿ ಹ್ಯಾ ಗುಶ್ಟಿ ಲಕ್ಶೆತ್ ಥೆವಾ ಮಾನ್ಸಾಚಾ ಲೇಕಾಲಾ ಲೊಕಾಂಚಾ ಹಾತಾತ್ ದರುನ್ ದೆನಾರ್. ” ");
INSERT INTO gok_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","ಹಿ ಗ್ಯೊಶ್ಟ್ ಅಪೊಸ್ತಲಾನಾ ಸಮಾಜ್ಲಿ ನಾಹಿ ಹಿ ತ್ಯನಾ ಸಮಜು಼ ನಾಹಿ ಮನ್ಹುನ್ ಗಪ್ಚಿಪ್ ಥಿವ್ಲಿ ಹುತ್ತಿ. ಆನಿ ಹಿ ಗ್ಯೊಶ್ಟ್ ತ್ಯಲಾ ಇಚಾರಾಯಾ ತೆ ಬಿಹಿತ್ ಹುತ್ತ. ");
INSERT INTO gok_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","ಮಂಗ್ ಆಪ್‌ಲ್ಯಾತ್ ಮೊಟಾ ಕೊನ್ ತ್ಯಚಾ಼ ಅಪೊಸ್ತಲಾತ್ ಇಚಾರ್ ಸುರು ಜಾ಼ಲ್ಥಾ. ");
INSERT INTO gok_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","ಯೇಸುನಿ ತ್ಯಂಚಾ ಮನಾತ್ಲಾ ಇಚಾರ್ ವಳ್ಕುನ್ ಯಕಾ ಬಾರಿಕ್ ಮುಲಾಲಾ ಗಿಹುನ್ ತ್ಯಲಾ ಆಪ್ಲೆ ಜ಼ವಳ್ ಉಬಕೆಲ. ");
INSERT INTO gok_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ಆನಿ ತ್ಯನಾ “ಜೆ ಕೊನ್ ಹ್ಯಾ ಮುಲಾಲಾ ಮಾಜಾ ನಾವಾನಿ ಸ್ವಿಕಾರ್ ಕರ್ತೊ ತ್ಯೊ ಮನಾ ಸ್ವಿಕಾರ್ ಕರ್ತೊ ಆನಿ ಜೆ ಕೊನ್ ಮನಾ ಸ್ವಿಕಾರ್ ಕರ್ತೊ ತ್ಯೊ ಕಚಾನಿ ಮನಾ ಲಾವುನ್ ದಿಲ್ಯಾ ತ್ಯಲಾ ಸ್ವಿಕಾರ್ ಕರ್ತೊ ಕಾ ಮಂಜೆ ತುಮ್ಚಾತ್ ಕೊನ್ ಬಾರಿಕ್ ವ್ಹಯಿಲ್ ತ್ಯೊಸ್ ಮೊಟಾ ವ್ಹಯಿಲ್ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","ಯೊಹಾನ್ ಯೇಸುಲಾ ಮನ್ಲಾ, “ಪ್ರಭು ಆಮಿ ಯೊಕ್ ಮಾನುಸ್ ತುಜಾ ನಾವಾನಿ ಲಾಗಿರ ಕ್ಯಾಡತ್ಯಾಲಾ ಬಗ್ಲಾ ತವಾ ಆಮಿ ತ್ಯಲಾ ಆಡ್ಯಾವ್ಲಾ ಕಾ ಮಂಜೆ ತ್ಯೊ ಆಮ್ಚೆ ಸಂಗ ನಸಲ್ಯಾಲಾ”. ");
INSERT INTO gok_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","ಯೇಸು ಯೊಹಾನಾಲಾ ಆನಿ ತ್ಯಚಾ ಸಗ್‌ಳ್ಯಾ ಅಪೊಸ್ತಲಾನಾ, ಮನ್ಲಾ. “ತ್ಯಲಾ ಆಡ್ಯಾವು ನಕೊಸಾ ಕಾ ಮಂಜೆ ತುಮಚಾ಼ ವೈರಿ ನಸ್ನಾರಾ ತುಮಚಾ಼ಸ್ ತ್ಯೊ” ");
INSERT INTO gok_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","ತವಾ ಯೇಸುಚಾ಼ ಸ್ವರ್ಗಾತ್ ವರ್ ಜಾ಼ಯಾಚಾ಼ ಯೊಳ್ ಜ಼ವಳ್ ಆಲಾ ತವಾ ತ್ಯನಿ ಯೆರುಸಲೇಮಿತ್ ಜಾ಼ಯಾಲಾ ಘಟ್ ಮನ್ ಕೆಲ. ");
INSERT INTO gok_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","ಆನಿ ತ್ಯನಿ ಆಪ್ಲೆ ಮೊರ‍್ಹ ಸಾಂಗ್ ಸಾಂಗ್‌ತ್ಯಾಲ್ಯಾನಾ ಲಾವುನ್ ದಿಲ ತವಾ ತೆ ನಿಗುನ್ ತ್ಯಚಿ ಸಾಟಿ ಸಗ್ಳ ತಯಾರಿ ಕರಾಯಾ ಸಮಾರ‍್ಯಾಚಾ ಯಕಾ ಗಾವಾತ್ ಗೆಲ. ");
INSERT INTO gok_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","ಫನ್ ತಿಥಲ್ಯಾ ಲೊಕಾಂಚಾನಿ ತ್ಯಂಚಾ಼ ಸ್ವಾಗತ್ ಕೆಲಾ ನಾಹಿ ಕಾ ಮಂಜೆ ತ್ಯೊ ಯೆರುಸಲೇಮಿಕ್ಡ ಜಾ಼ಯಾಚಾ಼ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","ಹ್ಯ ಬಗುನ್ ತ್ಯಚ಼ ಶಿಶಾ ಯಾಕೊಬ್ ಆನಿ ಯೊಹಾನ್ ದೊಗಾಂಚಾನಿ ಸಾಂಗ್ಲ, “ಪ್ರಭು ತುಲಾ ಮನ್‌ ಆಸ್ಲತ ಪರಲೊಕಾತ್ನಿ ಇಸ್ತು ಪಡುನ್ ತ್ಯಂಚಾ಼ ನಾಸ್ ವ್ಹವುನಿ ಮಂಥಾವ್? ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","ಯೇಸುನಿ ಪರ್ತುನ್ ತ್ಯನಾ ದಪ್‌ಕ್ಯಾವ್ಲ ");
INSERT INTO gok_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","ಮಂಗ್ ತೇ ದಿಸರ‍್ಯಾ ಗಾವಾತ್ ಗೆಲ ");
INSERT INTO gok_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","ತೇ ವಾಟನಿ ಜಾ಼ತಾ ಆಸ್ಥಾನಾ ಯಕ್ಲಾ ಯೇಸುಲಾ, “ತು ಕುಠ ಜಾ಼ಸಿಲ್ ತಿಥ ಮಿ ತುಜೆ ಮಾಗ್ನಿ ಯತೊ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","ತವಾ ಯೇಸು ತ್ಯಲಾ, “ಕೊಲ್ಯಾನಾ ಗಭಿ ಹಾತ್ತಾ ಆನಿ ಪಾಕ್ರಾನಾ ಕುಟಿ ಹಾತ್ತ ಫನ್ ಮಾನ್ಸಾಚಾ ಲೇಕಾಲಾ ಡುಯಿ ಟೆಕ್ವಾಯಾಬಿ ಜಾ಼ಗಾ ನಾಹಿ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","ಆನಿ ದುಸರ‍್ಯಾ ಯಕಾಲಾ ಮಾಜೆ ಮಾಗ್ನಿ ಯೆ ಮನ್ಲಾ, ಫನ್ ತ್ಯೊ “ಪ್ರಭು ಆಂದಿ ಮನಾ ಮಾಜಾ ಬಾಚೆ ಮಾತಿಲಾ ಜಾ಼ವುನ್ ಯತೊ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","ಯೇಸು ತ್ಯಲಾ ಮನ್ಲಾ, “ಮೆಲ್ಯಾಲ್ಯಾನಾ ಆಪ್ಲಿ ಮೆಲ್ಯಾಲಿ ಪುರುಂತ ತು ಜಾ಼ವುನ್ ದೇವಾಚಾ ರಾಜಾಚಿ ಗ್ಯೊಶ್ಟ್ ಸಾಂಗ್. ” ");
INSERT INTO gok_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","ತ್ಯಾ ನಂತರ್ ಆನಿ ಯಕ್ಲಾ ಮನ್ಲಾ, “ಪ್ರಭು ಮಿ ತುಜೆ ಮಾಗ್ನಿ ಯತೊ ಫನ್ ಆಂದಿ ಮಿ ಮಾಜಾ ಗರ್ಚಾ ಮಾನ್ಸಾನಾ ಸಾಂಗುನ್ ಯತೊ. ");
INSERT INTO gok_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","ಯೇಸು ತ್ಯಲಾ, “ಕುನಿ ನಾಂಗರಿವ ಹಾತ್ ಥೆವಲ್ಯಾ ತ್ಯನಿ ಮಾಗ ಬಗಲ್ಯಾವ ತ್ಯೊ ದೇವಾಚಾ ರಾಜಾತ್ ಕಾಮ ಕರಾಯಾ ಲಾಯಕ್ ನಾಹಿ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","ಹ್ಯಾ ನಂತರ್ ಯೇಸುನಿ ಆನಿ ಸತ್ತರಾವ ದೊನ್ ಜ಼ನಾನಾ ನೆಮುನ್ ಕಚಾ ಕಚಾ ಗಾವಾತ್ ಕಚಾ ಕಚಾ ಜಾ಼ಗ್ಯಾವ ಯೇಸು ಆಪ್ನು ಸ್ವತಾ ಜಾ಼ಯಾಚಾ಼ ಹುತ್ತಾ. ತಿಥ ಆಂದಿಸ್ ದೊಗಾ ದೊಗಾನಾ ಲಾವುನ್ ದಿಲ. ");
INSERT INTO gok_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","ತವಾ ಯೇಸು ತ್ಯನಾ, “ಪೀಕ್ ಖುಬ್, ಹಾ ಫನ್ ಕಾಮ್ಯಾರ ಥೊಡ ಹಾತ್ತ. ಪಿಕಾಚಾ ದನ್ಯಾನಿ ಆಪ್‌ಲ್ಯಾ ಪಿಕಾಸಾಟಿ ಕಾಮ್ಯಾರ ಲಾವುನ್ ದೇವಾವ ಮನ್ಹುನ್ ದೇವಾಪ ಮಾಗ್ನ ಕರಾ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","“ಜಾ಼ವಾ ಕೂಳಿಸನ್ಯಾತ್ನಿ ಬಕರಿ ಗ್ಯಾತ್‌ಲ್ಯಾಚೆಗತ್ ಮಿ ತುಮಾನಾ ಲಾವುನ್ ದೇತೊ ಬಗಾ. ");
INSERT INTO gok_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","ಪೈಶಾಚಿ ಪಿಸ್ವಿ ಜು಼ಳ್ಹಿ ನಾಹಿತ ವ್ಹಾನಾ ಸಂಗ ಗಿಹುನಕೊಸಾ. ವಾಟವ ಕುನಾಲಾ ನಮಸ್ಕಾರ್ ಕರುನಕೊಸಾ. ");
INSERT INTO gok_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","ಆನಿ ಕಚಾ ಯಕಾ ಗರ‍್ಹಾತ್ ಜಾ಼ಸಿಲಾ ತ್ಯಾ ಗರ‍್ಹಾತ್ ಸಮಾದಾನ್ ರಾಹುನಿ ಮನ್ಹಾ. ");
INSERT INTO gok_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","ತಿಥ ಕೊನ್ ಸಮಾದಾನಾಚಾ಼ ಮಾನುಸ್ ಆಸ್ಲಾತ ತುಮಚಾ಼ ಸಮಾದಾನ್ ತ್ಯಚಿಪ ರಾಹಿಲ್, ನಸ್ಲಾತ ಪರತ್ ಯಯಿಲ್. ");
INSERT INTO gok_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","ತ್ಯಚಾ ಗರ‍್ಹಾತ್ ವಸ್ತಿಲಾ ರಾಹುನ್ ತಿ ಕ್ಯಾ ದಿತಿಲ ತ್ಯ ಖಾವುನ್ ಪಿವುನ್ ರಾವ್ಹಾ ಕಾ ಮಂಜೆ ಆಳ್ ಆಪ್ಲೆ ಮಜು಼ರಿಲಾ ಯೊಗ್ಯ ಹಾ ಗರ‍್ಹ ಬದಲು ನಕೊಸಾ. ");
INSERT INTO gok_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","ಕಚಾಬಿ ಗಾವಾತ್ ತುಮಿ ಗೆಲಾಸಾಕಿ ತ್ಯಂಚಾನಿ ತುಮಾನಾ ಹಾಕಟ್ಲತ ತಿ ತುಮಾನಾ ಕ್ಯಾ ವ್ಯಾಡ್ತಿಲ ತ್ಯ ಖಾವಾ. ");
INSERT INTO gok_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","ತ್ಯಾತ್ ಕೊನ್ ದುಖನ್ಕರಿ ಹಾ ತ್ಯನಾ ಬರಿ ಕರಾ ಆನಿ ತ್ಯನಾ ದೇವಾಚ಼ ರಾಜ ತುಮ್ಚೆ ಜ಼ವಳ್ ಆಲ್ಯಾ ಮನ್ಹುನ್ ಸಾಂಗಾ. ");
INSERT INTO gok_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","ಆನಿ ತುಮಿ ಕಚಾಬಿ ಗಾವಾತ್ ಗೆಲಾಸಾ ಆನಿ ತ್ಯಂಚಾನಿ ತುಮಾನಾ ಹಾಕಟ್ಲ ನಾಹಿತ ತಿತ್ಲೆ ಪಾಂದಿವ ಜಾ಼ವುನ್ ಆಸ ಮನ್ಹಾ. ");
INSERT INTO gok_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","ಆಮ್ಚಾ ಪಾಯಾನಾ ಲಾಗ್‌ಲ್ಯಾಲಿ ತುಮ್ಚಾ ಗಾವಾಚಿ ಧುಳ್ಬಿ ತುಮ್ಚಿ ತುಮಾನಾಸ್ ಜಾ಼ಢುನ್ ಟ್ಯಾಕ್ತಾವ್ ಫನ್ ದೇವಾಚ಼ ರಾಜ ಜ಼ವಳ್ ಆಲ್ಯಾ ಹ್ಯ ಲಕ್ಶೆತ್ ಥೆವಾ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","ಮಿ ತುಮಾನಾ ಸಾಂಗ್ತೊ ತ್ಯಾ ನ್ಯಾಯಿ ನಿವ್ಡಾಚಾ ದಿಸಾದಿಸಿ ತಸಲ್ಯಾ ಗಾವಾಚಿ ಹಾಕಿಗತ್ ಸದೊಮ್ ಗಾವಾಚೆ ಹಾಕಿ ಗತಿವ್ನಿ ಕಠಿನ್ ವ್ಹಯಿಲ್ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“ಖೊರಾಜಿನಿ, ಬೆತ್ಸಾಯಿದಾ ತುಜಿ಼ ದುರದೇಸ್ನಾ ಕ್ಯಾ ಸಾಂಗು; ಕಾ ಮಂಜೆ ತುಮ್ಚೆ ಮದ್ದಿ ಗಡಲ್ಯಾಲಿ ಪರಾಕ್ರಮಾಚಿ ಕಾಮ ತುರ್ ಆನಿ ಸಿದೊನಾತ್ನಿ ಗಡಲಿ ಆಸ್ಥಿತ ತ್ಯಂಚಾನಿ ತವಾಸ್ ಚಿಲಾಚ಼ ಗೊನ್ತಾ ಬಾಂದುನ್ ರಾಖ್ ಆಂಗಾವ ಗಿಹುನ್ ಬಸುನ್ ಪಶ್ಚಾತಾಪ್ ಪಡ್ಲಿ ಆಸ್ಥಿತ. ");
INSERT INTO gok_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","ಹ್ಯಚಿಸ್ ಲಾಗುನ್ ನ್ಯಾಯಿ ನಿವ್ಡಾಚಾ ದಿಸಾತ್ ದೇವ್ ತುಮ್ಚೆ ಪರಾಸ್ ತುರ್ ಆನಿ ಸಿದೊನ್ ಗಾವಾಂಚಿವ ಕರ್ನಾದಾವಿಲ್. ");
INSERT INTO gok_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","ಆನಿ ಕಪೆರ್ನೌಮ ತು ಪರಲೊಕಾತ್ ಚ಼ಡ್ಸಿಲ್ ಕ್ಯಾ? ನಾಹಿ! ತು ನರಕಾತ್ ಉತಾರ್ಸಿಲ್. ");
INSERT INTO gok_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","ಕಚಾ಼ ತುಮ್ಚ಼ ಐಕ್ತೊ ತ್ಯೊ ಮಾಜ಼ ಐಕ್ತೊ ಆನಿ ಕಚಾ಼ ತುಮಾನಾ ನಾಖರ್ತೊ ತ್ಯೊ ಮನಾ ನಾಖರ್ತೊ ಆನಿ ಕಚಾ಼ ಮನಾ ನಾಖರ್ತೊ ತ್ಯೊ ಕಚಾನಿ ಮನಾ ಲಾವುನ್ ದಿಲ್ಯಾ ತ್ಯಲಾ ನಾಖರ್ತೊ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","ಮಂಗ್ ತೆ ಸತ್ತರಾವ ದೊನ್ ಜಾ಼ನ್ ಆನಂದಾನಿ ಪರತ್ ಯವುನ್ ಮನ್ಲ, “ಪ್ರಭು ತುಜಾ ನಾವಾನಿ ಭುಥ ದಿಕಿಲ್ ಆಮ್ಚಾ ತಾಬ್ಯಾತ್ ರಾಥ್ಯಾತ. ” ");
INSERT INTO gok_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","ತವಾ ಯೇಸು ತ್ಯನಾ ಮನ್ಲಾ, “ಸೈತಾನ್ ಪರಲೊಕಾತ್ನಿ ಇಜ಼ಚೆಗತ್ ಪಾಕ್ಕನ್ ಪಡ್‌ಲ್ಯಾಲ ಬಗಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","ಬಗಾ ಮಿ ತುಮಾನಾ ಸಾಪ್ ಆನಿ ಇಚು಼ ಹ್ಯನಾ ತುಡುವಾಯಾ ಆನಿ ವೈರಿಚಾ ಸಗ್‌ಳ್ಯಾ ಬಳಾವರ್ ಹಾಕ್ ದಿಲ್ಯಾ ತುಮಾನಾ ಕಾಯೇಕ್ ಅನ್ನೆವ್ ವ್ಹಯಿತ್ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","ಫನ್ ಬುಥ ತುಮ್ಚಾ ತಾಬ್ಯಾತ್ ರಾಥ್ಯಾತ ಮನ್ಹುನ್ ಆನಂದ್ ವ್ಹವುನಕೊಸಾ ತುಮ್ಚಿ ನಾವ ಸ್ವರ್ಗಾತ್ ಲಿವ್‌ಲ್ಯಾಲಿ ಹಾತ್ತ ಹ್ಯಚಾ಼ ಆನಂದ್ ಕರಾ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","ತೆ ಗಟ್ಕಲಾ ಯೇಸು ಪವಿತ್ರ ಆತ್ಮಾಚೆ ಹೌಸನಿ ಮನ್ಲಾ, “ಬಾ ಸ್ವರ್ಗಾಚಾ ಆನಿ ಪ್ರತ್ವಿಚಾ ಪ್ರಭು ಮಿ ತುಲಾ ವವ್ಯಾಳ್ತೊ ಕಾ ಮಂಜೆ ಜ್ಞಾನಿ ಆನಿ ಶಿಕ್‌ಲ್ಯಾಲ್ಯಾಂಚಿಪ್ನಿ ಹ್ಯಾ ಗುಶ್ಟಿ ಗಪ್ ಥಿವುನ್ ತ್ಯಾ ತು ಕಾಯ್ ಸಿಕ್‌ಲ್ಯಾ ನಸ್‍ಲ್ಯಾಲ್ಯಾನಾ ಉಗ್ಡುನ್ ದಾವಾಚ಼ ತುಲಾ ಬರ ದಿಸ್ಲ ಮನ್ಹುನ್ ತುಲಾ ವವ್ಯಾಳ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","ಮಾಜಾ ಬಾನಿ ಸಗ್ಳ ಮಾಜಾ ತಾಬ್ಯಾತ್ ದಿಲ್ಯಾ, ಲ್ಯೊಕ್ ಕೊನ್ ಹಾ ಹ್ಯ ಬಾ ವಾಚು಼ನ್ ಕುನಾಲಾ ಠಾವ ನಾಹಿ ಆನಿ ಬಾ ಕೊನ್ ಹಾ ಹ್ಯ ಲೇಕಾಲಾ ತ್ಯವ್ಡಸ್ ಠಾವ ಆನಿ ಕಚಾಲಾ ತ್ಯೊ ಉಗ್ಡುನ್ ದಾವಾಚಿ ಲೇಕಾಚಿ ಇಚ್ಚಾ ಆಸಲ್ ತ್ಯಚೆ ವಾಚು಼ನ್ ಕುನಾಲಾ ಠಾವ ನಾಹಿ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","ಯೇಸು ಶಿಶಾಂಚಿಕ್ಡ ಪರ್ತುನ್‍ ತೇ ಯಕಾನ್ಸಿ ಆಸ್ಥಾನಾ ತ್ಯನಾ ಕ್ಯಾ ಸಾಂಗ್ಲ ಮಂಜೆ “ಹ್ಯಾ ಗುಶ್ಟಿ ಬಗ್‌ತ್ಯಾಲ ತುಮಿ ಕ್ಯವ್ಡ ಬರ. ” ");
INSERT INTO gok_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","ಹ್ಯಚಿಸ್ ಲಾಗುನ್ ತುಮಾನಾ ಸಾಂಗ್ತೊ ತುಮಿ ಬಗ್‌ತ್ಯಾಲಿ ಕಾಮ್ ಬಗನ್ಯಾಚಿ ಇಚಾ ಖುಬ್ ಪ್ರವಾದಿಂಚಾನಿ ಆನಿ ರಾಜಾಂಚಾನಿ ಕಿಲಿ ತರಿ ತ್ಯನಾ ಬಗಾಯಾ ಮಿಳಾಲಿ ನಾಹಿ ಆನಿ ತುಮಿ ಐಕಿತ್ ಹಾಸಾ ತ್ಯ ಐಕಾನ್ಯಾಚಿ ಇಚಾ ಕಿಲಿ ತರಿ ತ್ಯನಾ ಐಕಾಯಾ ಮಿಳಾಲ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","ಮಂಗ್ ಬಗಾ ಯೊಕ್ ಶಾಸ್ತ್ರಿ ಉಬಾ ರಾಯ್ಲಾ ಆನಿ ಯೇಸುಚಿ ಪಾರಕ್ ಕರಾಯಾಸಾಟಿ ಮನ್ಲಾ, “ಪ್ರಭು, ಕ್ಯಾ ಕೆಲ್ಯಾವ ಮನಾ ಶಾಶ್ವತ್ ಜೀವನ್ ಮಿಳಲ್? ");
INSERT INTO gok_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","ಯೇಸು ತ್ಯಲಾ “ಮೋಸೆಚಾ ಧರ್ಮ ಶಾಸ್ತಾರಾತ್ ಕ್ಯಾ ಲಿವ್‌ಲ್ಯಾಲ ಹಾ? ತು ಕ್ಯಾ ಸಮಜು಼ನ್ ಗೆತ್ಲಸ್? ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","ತವಾ ಶಾಸ್ತ್ರಿ, “ತು ತುಜಾ಼ ದೇವ್ ಪರಮೇಶ್ವರಾಚಿ ಪುರ‍್ಯಾ ಮನಾನಿ ಪುರ‍್ಯಾ ಜಿ಼ವಾನಿ ಪುರ‍್ಯಾ ಬಳಾನಿ ಆನಿ ಪುರ‍್ಯಾ ಮನಾನಿ ಮಾಯಾ ಕರ್ ಆನಿ ತುಜಿ಼ಗತ್ ತುಜಾ ಸೆಜಾರ‍್ಯಾಚಿ ಮಾಯಾ ಕರ್ ಆಸ ಲಿವಲ್ಯಾ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","ಯೇಸುನಿ ಶಾಸ್ತ್ರಿಲಾ, “ಉತ್ತರ್ ತು ಠಿಕ್ ದಿಲಾಸ್ ಮನ್ಲಾ. ಹ್ಯಚ಼್ ಕರ್ ಮಂಜೆ ಜ಼ಗಸಿಲ್” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","ಫನ್ ಆಪ್ನು ನಿತಿವಂತ್ ಮನ್ಹುನ್ ಗಿಹ್ಯಾಚಿ ಇಚಾ ದರುನ್ ತ್ಯೊ ಯೇಸುಲಾ, “ಫನ್ ಮಾಜಾ಼ ಸೇಜಾ಼ರಿ ಕೊನ್? ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","ಯೇಸುನಿ ಉತ್ತರ್ ದಿಲಾ, ಯೊಕ್ ಮಾನುಸ್ ಯೆರುಸಲೇಮಿತ್ನಿ ಖಾಲ್ ಉತುರುನ್ ಯೆರಿಕೊಸ್ ಜಾ಼ಯಿತ್ ಆಸ್ಥಾನಾ ಚೊ಼ರಾಂಚಾ ಹಾತಾತ್ ಗಾವ್ಲಾ ತ್ಯಂಚಾನಿ ತ್ಯಚ಼ ಕಪ್ಡ ಕಾಡುನ್ ಗಿಹುನ್ ತ್ಯಲಾ ಮ್ಯಾರ್ಲಾ ಆನಿ ತ್ಯಲಾ ಆಡ್ಕಾಚಾ಼ ಮಾರುನ್ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","ತವಾಸ್ ಯೊಕ್ ಯೆಹುದ್ಯ ಯಾಜಕ್ ತೆ ವಾಟನಿ ಖಾಲ್ ಜಾ಼ಯಿತ್ ಹುತ್ತಾ; ತ್ಯನಿ ತ್ಯಲಾ ಬಗುನ್ ದುಸರೆ ಬಾಜು಼ಕ್ನಿ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","ತಸಾಸ್ ಯೊಕ್ ಲೆವಿ ತಿಥ ಆಲಾ ತ್ಯಲಾ ಬಗುನ್ ತ್ಯೊಬಿ ದುಸರೆ ಬಾಜು಼ಕ್ನಿ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","ಫನ್ ಯೊಕ್ ಸಮಾರ‍್ಯಾ ಆಲಾ ತೆ ವಾಟನಿ ಯತಾನಾ ತ್ಯೊ ಹುತ್ತಾ ತಿಥ ಆಲಾ ಆನಿ ತ್ಯಲಾ ಬಗುನ್ ತ್ಯಚಿ಼ವ ತ್ಯಲಾ ಕರ್ನಾ ಆಲಿ. ");
INSERT INTO gok_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","ತ್ಯೊ ಜ಼ವಳ್ ಜಾ಼ವುನ್ ತ್ಯಚಾ ಗಾವ್ಹಾನಾ ತ್ಯಾಲ್ ಆನಿ ದರಾಕ್ಶಿಚಾ ರಸ್ ಲಾವುನ್ ಬ್ಯಾಂದಲಾ ಆನಿ ತ್ಯಲಾ ಆಪ್‌ಲ್ಯಾ ಗಾಡ್ವಾವರ್ ಬಸ್ವುನ್ ದವಖಾನ್ಯಾತ್ ಆನ್ಲಾ ಆನಿ ತ್ಯಚಿ ಕ್ಯಾಳ್ಜಿ ಗಿತ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","ದುಸರೆ ದಿಸಿ ತ್ಯನಿ ದೊನ್ ರುಪಯಿ ಕಾಡುನ್ ದವಖನ್ಯಾತಲ್ಯಾ ರಕ್ಶಕಾಲಾ ದಿವುನ್ ಹ್ಯಚಿ ಕ್ಯಾಳ್ಜಿ ಘೇ ಆನಿ ಹ್ಯಚಿವ್ನಿ ? ಆಗಾವ್ ಖರ್ಚ಼ ಜಾ಼ಲ್ಯಾಲಾ ಮಿ ಪರತ್ ತುಲಾ ದೇತೊ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","ತವಾ ಯೇಸು “ತುಜಾ ಮನ್ಯಾನಿ ಚೊ಼ರಾಂಚಾ ಹಾತಾತ್ ಗಾವಲ್ಯಾಲ್ಯಾ ಮಾನ್ಸಾಚಾ಼ ಸೇಜಾ಼ರಿ ಹ್ಯಾ ತಿಗಾತ್ ಕೊನ್ ಜಾ಼ಲಾ? ");
INSERT INTO gok_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","ತವಾ ಶಾಸ್ತ್ರಿ, “ತ್ಯಚಿ಼ವ ದಯಾ ದ್ಯಾವ್‌ಲ್ಯಾಲಾ” ಮನ್ಲಾ. ತವಾ ಯೇಸು ತ್ಯಲಾ “ಜಾ಼ ಆನಿ ತು ಬಿ ತಸಸ್ ಕರ್” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","ಮಂಗ್ ತೆ ಮೊರ‍್ಹ ಜಾ಼ಯಿತ್ ಆಸ್ಥಾನಾ ತ್ಯೊ ಯಕಾ ಗಾವಾತ್ ಆಲಾ ತವಾ ಮಾರ್ಥಾ ನಾವಾಚಿ಼ ಯೇಕ ಬಾಯಿಲ್ ಮಾನ್ಸಾನಿ ತ್ಯಲಾ ಆಪ್‌ಲ್ಯಾ ಗರ‍್ಹಾತ್ ಹಾಕಟ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","ತಿಲಾ ಮರಿಯಾ ನಾವಾಚಿ ಯೇಕ್ ಭನ್ ಹುತ್ತಿ ತಿ ಪ್ರಭುಚಾ ಪಾಯಾಕ್ಡ ಬಸುನ್ ತ್ಯಚ಼ ಬೊಲ್ನ ಐಕಿತ್ ರಾಹಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","ತವಾ ಮಾರ್ಥಾಲಾ ಖುಬ್ ಕಾಮ್ ಲಾಗ್ಲ ಮನ್ಹುನ್ ತಿಚ಼ ತಾರಾಂಗನ್ ಜಾ಼ಲ ಆನಿ ತಿ ಮೊರ‍್ಹ ಯವುನ್, “ಪ್ರಭು ಮಾಜೆ ಭನ್ಹಿನಿ ಮಾಜಿವ ಯಕ್ಲಿವಸ್ ಕಾಮಾಚಾ಼ ಭಾರ್ ಟ್ಯಾಕ್ಲಾ ಹ್ಯ ತುಲಾ ಬರ ದಿಸ್ತ ಕ್ಯಾ? ಮನಾ ಮಜ಼ತ್ ಕರಾಯಾ ಸಾಂಗ್” ಮನ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","ಪ್ರಭು ತಿಲಾ, “ಮಾರ್ಥಾ ಮಾರ್ಥಾ ತು ಖುಬ್ ಗುಶ್ಟಿಂಚಿ ಯವಜ್ನಾ಼ ಆನಿ ಗಡಬಡ್ ಕರ್ತೆಸ್. ");
INSERT INTO gok_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","ಫನ್ ಥೊಡ್ಯಾ ತ್ಯವ್‍ಡ್ಯಾಸ್ ಗುಶ್ಟಿ ಉಪೆಗಿಚಾ ಹಾತ್ತಾ. ಮರಿಯಾನಿ ಯೇಕುಸ್ ಚಾ಼ಂಗ್ಲಿ ನಿವುಡುನ್ ಗೆತ್ಲೆ ತಿ ತಿಚಿಪ್ನಿ ಕಾಡುನ್ ಗಿಹ್ಯಾ ವ್ಹನಾರ್ ನಾಹಿ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","ಮಂಗ್ ಯಕಸಿ ಯಕಾ ಜಾ಼ಗ್ಯಾವ ಮಾಗ್ನ ಕರೀತ್ ಹುತ್ತಾ ತ್ಯ ತ್ಯನಿ ಸಪಿವ್‌ಲ್ಯಾವ ತ್ಯಚಾ ಶಿಶಾತ್ಲಾ ಯೊಕ್ ಮನ್ಲಾ, “ಪ್ರಭು ಯೊಹಾನಾನಿ ಕಸ ಆಪ್‌ಲ್ಯಾ ಶಿಶಾನಾ ಮಾಗ್ನ ಕರಾಚ಼ ಶಿಕಿವ್‍ಲ್ಯಾ ತಸ ತು ಆಮಾನಾ ಸಿಕಿವ್. ” ");
INSERT INTO gok_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","ತವಾ ಯೇಸು ತ್ಯನಾ ಮನ್ಲಾ. “ತುಮಿ ಮಾಗ್ನ ಕರ್ತಾನಾ ಸ್ವರ್ಗಾತ್‌ಲ್ಯಾ ಆಮ್ಚಾ ಬಾ ದೆವಾ, ತುಜ಼ ನಾವ್ ಪವಿತ್ರ ಮನ್ಹಾವ. ತುಜ಼ ರಾಜೆ ಯವಾವ. ");
INSERT INTO gok_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","ಆಮ್‌ಚ಼ ಖಾಯಿಮಚ಼ ಜೆವಾನ್ ಆಮಾನಾ ಖಾಯಿಮ್ ದೇ. ");
INSERT INTO gok_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","ಆನಿ ಆಮ್ಚಿ ಪಾಪ ಮಾಪ್ ಕರ್ ಕಾ ಮಂಜೆ ಆಮಾನಾ ಚು಼ಕ್ ಕೆಲ್ಯಾಲ್ಯಾ ಪರ್ತೇಕಾಲಾ ಆಮಿ ಮಾಪ್ ಕರ್ತಾವ್. ಆನಿ ಆಮಾನಾ ಪರಿಕ್ಶೆತ್ ಗಾಲುನಕೊಸ್. ");
INSERT INTO gok_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","ಆನಿ ಯೇಸು ಶಿಶಾನಾ ಮನ್ಲಾ, “ತುಮ್ಚಾತ್‍ಲ್ಯಾ ಯಕಾಲಾ ಯೊಕ್ ಸುಪ್ತಿ ಆಸ್ಥೊ ತ್ಯೊ ತ್ಯಚಿಪ ಅರ್ದೆ ರಾತಿತ್ ಜಾ಼ವುನ್ ತ್ಯಲಾ ಸೊಪ್‌ತ್ಯಾ ಮನಾ ತೀನ್ ಬಾಕ್‌ರ‍್ಯಾ ಉಸ್‌ನ್ಯಾ ದೇ. ");
INSERT INTO gok_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ಕಾ ಮಂಜೆ ಮಾಜಾ಼ ಯೊಕ್ ಸುಪ್ತಿ ಮಾಜಾ ಗರ‍್ಹಾತ್ ಆಲ್ಯಾ ಆನಿ ತ್ಯಲಾ ಖಾಯಾ ದಿಯಾ ಮಾಜಿಪ ಕಾಯ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","ತವಾ ತ್ಯೊ ಆತ್ನಿ, “ಮನಾ ತರಾಸ್ ದಿವುನಕೋಸ್ ಆತಾ ದಾರ್ ಲ್ಯಾವ್‌ಲ್ಯಾ ಆನಿ ಮಾಜಿ ಪ್ಯೂರ್ಗಿ ಮಾಜಿಪ ನಿಜ಼ಲ್ಯಾತ ಮಿ ಉಠುನ್ ತುಲಾ ಕಾಯ್ ದಿಯಾ ವ್ಹಯಿತ್ ನಾಹಿ” ಮನ್ಹಿಲ್. ");
INSERT INTO gok_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","ಮಿ ತುಮಾನಾ ಸಾಂಗ್ತೊ, ತ್ಯೊ ತ್ಯಚಾ಼ ಸುಪ್ತಿ ಜಾ಼ಲಾತರಿ ತ್ಯಲಾ ತ್ಯೊ ಉಠುನ್ ದೇನಾರ್ ನಾಹಿ ಫನ್ ತ್ಯಚಾ ಜಾ಼ಚಾ಼ನಿ ತ್ಯೊ ಉಠುನ್ ತ್ಯಲಾ ಪಾಯ್ಜೆ ತ್ಯವ್ಡ ದೇನಾರ್. ಮನ್ಲಾ ");
INSERT INTO gok_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","ಮಿ ತುಮಾನಾ ಸಾಂಗ್ತೊ, ಮಾಗಾ ತವಾ ದೇವ್ ತುಮಾನಾ ದೆನಾರ್ ಸೋದಾ ತವಾ ತುಮಾನಾ ಗಾವ್ನಾರ್ ದಾರ್ ವಾಜ಼್ವಾ ತವಾ ತುಮ್ಚೆ ಸಾಟಿ ದಾರ್ ಉಗಡ್ತಿಲ. ");
INSERT INTO gok_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","ಕಾ ಮಂಜೆ ಕೊನ್ ಮಾಗ್ತೊ ತ್ಯಲಾ ದೆನಾರ್ ಕೊನ್ ಶೊಥೊ ತ್ಯಲಾ ಗಾವ್ಥ ಕೊನ್ ದಾರ್ ಬಡಿವ್ತೊ ತ್ಯಲಾ ಉಗಾಡ್ತ. ");
INSERT INTO gok_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","ತುಮ್ಚಾತ್ ಆಸ್ಲಾ ಕುನಾಚಾ಼ ಬಾ ಹಾಕ್ಯಾ, ತ್ಯೊ ಆಪ್‌ಲ್ಯಾ ಮುಲಾನಿ ಮಾಸ ಮಾಗ್ಲತ ತ್ಯಲಾ ಮಾಸಾ ದಿಯಾಚಾ಼ ಸುಡುನ್ ಸಾಪ್ ದಿಯಿಲ್ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","ನಾಹಿತ ಆಂಡ ಮಾಗ್‌ಲ್ಯಾಲ ಆಸ್ಥಾನಾ ತ್ಯಲಾ ಇಚು಼ ದಿಯಿಲ್ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","ತುಮಿ ವಾಯಿಟ್ ಆಸ್ಥಾನಾ ತುಮಿ ತುಮ್ಚಾ ಮುಲಾನಾ ಚಾ಼ಂಗ್ಲ ದಿಯಾ, ಗಿಹ್ಯಾ ಕಳತ ತ ಸ್ವರ್ಗಾತಲ್ಯಾ ಬಾಪ ಕೊನ್ ಮಾಗತೊ ತ್ಯಲಾ ತ್ಯೊ ಕಿತ್ಕ ಇಸೆಸ್ ಕರುನ್ ಪವಿತ್ರಾತ್ಮ ದಿಯಿಲ್. ” ");
INSERT INTO gok_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","ಯಕಸಿ ಯೇಸು ಯಾಕ್ ಭುತ್ ಕಾಡಿತ್ ಹುತ್ತಾ. ತ್ಯ ಮುಖ ಹುತ್ತ ತವಾ ಭುತ್ ನಿಗಲ್ಯಾವರ್ ಮುಖಾ ಬೋಲಾ ಲಾಗ್ಲಾ ತ್ಯ ಬಗುನ್ ಲೊಕ ಗಾಭಾರ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","ಫನ್ ತ್ಯಾತ್ಲ ಕಿತೀಕಿ ಜಾ಼ನ್ ಮನ್ಲ, “ಹ್ಯೊ ಭುಥಾಂಚಾ಼ ದನ್ಹಿ ಬೆಲ್ಜೆಬುಲ್ ಹ್ಯಚಾ ಬಳಾನಿ ಹ್ಯೊ ಭುಥ ಕ್ಯಾಡತ್ಯೊ ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","ಆನಿ ದುಸರ ಥೊಡ ಜಾ಼ನ್ ಯೇಸುಚಿ ಪರಿಕ್ಶೆ ಕರುನ್ ಬಗಾಯಾ, “ತ್ಯಚಿಪ ಯೇಕ್ ವಳಕ್ ದ್ಯಾವ್” ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","ಫನ್ ಯೇಸುನಿ ತ್ಯಂಚಾ ಮನಾತ್ಲಾ ಇಚಾರ್ ವಳ್ಕುನ್ ತ್ಯನಾ ಮನ್ಲಾ, “ಆಪ್‌ಲ್ಯಾತ್ ಫುಟ್ ಪಡ್‌ಲ್ಯಾಲ ಪರ್ತೇಕ್ ರಾಜ ಹಾಳ್ ಪಡ್ತ ಆನಿ ಗರ‍್ಹಾವ ಘರ್ ಪಡ್ತ. ");
INSERT INTO gok_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","ಸೈತಾನಾತ್ನಿ ದುಯಿ ಪಡ್ಲಿಕಿ ತ್ಯಂಚ಼ ರಾಜ ಕಸ ಟಿಕಲ್? ಕಾ ಮಂಜೆ ಮಿ ಬೆಲ್ಜೆಬುಲಾಚಾ ಬಳಾನಿ ಭುಥ ಕ್ಯಾಡ್ತೊ ಆಸ ತುಮಿ ಮಂಥಾಸಾ. ");
INSERT INTO gok_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","ಫನ್ ಮಿ ಬೆಲ್ಜೆಬುಲಾಚಾ ಬಳಾನಿ ಭುಥ ಕಾಡಿತ್ ಆಸಲ್ ತ ತುಮ್ಚಿ ಲೊಕ ಕುನಾಚಾ ಬಳಾನಿ ಕ್ಯಾಡತ್ಯಾತ? ಮನ್ಹುನ್ ತುಮ್ಚಿ ಲೊಕ ತುಮ್ಚಿಸ್ ಚು಼ಕ್ ಮನ್ಹಾರ್; ");
INSERT INTO gok_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","ಫನ್ ಮಿ ಜ಼ರ್ ದೇವಾಚಾ ಬಳಾನಿ ಭುಥ ಕ್ಯಾಡತ್ಯಾಲಾ ಹಾ ತ ದೇವಾಚ಼ ರಾಜೆ ತುಮ್ಚಿಪ ಆಲ್ಯಾಲ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","ಹಾತ್ಯಾರಿ ಗಿಹುನ್ ಬಳ್ ಆಸಲ್ಯಾಲಾ ಮಾನುಸ್ ಆಪ್ಲ ಘರ್ ರಾಖಿತ್ ಆಸ್ಥಾನಾ ತ್ಯಚಾ಼ ಮ್ಹಾಲ್ ಮಾಥಾ ಶಾರ್ಕಾ ರಾಥೊ. ");
INSERT INTO gok_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","ಫನ್ ತ್ಯಚಿವ್ನಿ ಬಳಾಚಾ಼ ಮಾನುಸ್ ತ್ಯಚಿಪ ಯವುನ್ ತ್ಯಲಾ ದರ್ತೊ ತವಾ ಕಚಾ ಹತ್ಯಾರ‍್ಯಾಂಚಿವ ತ್ಯನಿ ಇಸ್ವಾಸ್ ಥೆವ್ಲಾ ಹುತ್ತಾ ತಿ ಹ್ಯೊ ಗಿಹುನ್ ಜಾ಼ತೊ ಆನಿ ತ್ಯಚ಼ ನೆಲ್ಯಾಲ ಸಗ್ಳ ವಾಟುನ್ ಟ್ಯಾಕ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","ಕೊನ್ ಮಾಜಾ಼ ನಸ್ತೊ ತ್ಯೊ ಮಾಜಾ಼ ವಾದಿ ವ್ಹತೊ; ಆನಿ ಕಚಾ಼ ಮಾಜಿ ಸಂಗ ಜು಼ಡಿತ್ ನಾಹಿ ತ್ಯೊ ಉದಳ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","ಯಕಾ ಮಾನ್ಸಾತ್ನಿ ಭುತ್ ನಿಗಾಲ ಮಂಜೆ ತ್ಯ ಇಸ್ರಾಮಾ ಸುದಿತ್ ಪಾನಿ ನಸ್‌ಲ್ಯಾಲ್ಯಾ ಜಾ಼ಗ್ಯಾವ್ನಿ ಫಿರತ್ ರಾಥ ಇಸ್ರಾಮಾ ಗಾವ್ಲಾ ನಾಹಿ ಮನ್ಹುನ್ ತ್ಯ ಮಿ ಸುಡುನ್ ಆಲ್ಯಾಲ್ಯಾ ಮಾನ್ಸಾಚೆ ಆತ್ ಪರತ್ ಜಾ಼ತೊ ಮಂಥ. ");
INSERT INTO gok_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","ಆನಿ ಯವುನ್ ತ್ಯ ಗರ್ ಲುಟುನ್ ಶಾದ್ರ ಕೆಲ್ಯಾಲ ಬಗುನ್ ");
INSERT INTO gok_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","ತ್ಯ ಭುತ್ ಜಾ಼ವುನ್ ಆಪ್ಲಿಪ್ನಿ ವಾಯಿಟ್ ಆಸ್‌ಲ್ಯಾಲಿ ದುಸ್ರಿ ಸಾತ್ ಭುಥ ಗಿಹುನ್ ಯನಾರ್ ತೀ ತ್ಯಾ ಮಾನ್ಸಾತ್ ಬರ್ಹುನ್ ತಿಥ ರಾನ್ಹಾರ್ ಮಂಗ್ ತ್ಯಾ ಮಾನ್ಸಾಚಿ ಸೆವಟ್ಚಿ ಪರಸ್ಥಿತಿ ಪೈಲ್ಯಾವ್ನಿ ವಾಯಿಟ್ ವ್ಹತ್ತಿ” ಮನ್ಲಾ, ");
INSERT INTO gok_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","ಮಂಗ್ ಆಸ ಜಾ಼ಲ. ಯೇಸು ಹ್ಯಾ ಗುಶ್ಟಿ ಬೊಲತ್ ಆಸ್ಥಾನಾ ಮಾನ್ಸಾತ್ಲಿ ಯೇಕ್ ಬ್ಯಾಯ್ಕೊ ಮಾನುಸ್ ಮೊಟ್ಯಾನಿ ತ್ಯಲಾ “ತುಲಾ ಜ಼ಲ್ಮ ದಿವುನ್ ಬಾಳಗ್‌ಲ್ಯಾಲಿ ಬ್ಯಾಯ್ಕಾ ಮಾನುಸ್ ಖುಬ್ ಬರಿ” ಮನ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","ತವಾ ಯೇಸು, ತ್ಯಚೆ ಪಕ್ಶಿ ಕೊನ್ ದೇವಾಚಿ ವಚ್ನ ಐಕ್ತೊ ಆನಿ ಪ್ಯಾಳ್ತೊ ತ್ಯೊಸ್ ಖುಬ್ ಬರಾ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","ತವಾ ಲೊಕ ತ್ಯಚಿಪ ಯಕಜಾ಼ಗಿ ಜ಼ಮತ್ ಆಸ್ಥಾನಾ ಯೇಸು ಆಸ ಮನ್ಹಾಯಾ ಲಾಗ್ಲಾ ಹಿ ಪಿಳ್ಗಿ ಬುರ್ಸಿ ಪಿಳ್ಗಿ ಹಾ ಹಿ ಅದ್ಬುತ್ ಮಾಗ್ತೆ ಫನ್ ಯೊನಾಚಾ ಅದ್ಬುತಾ ಶಿವಾರ್ ದಿಸಿರಾ ಅದ್ಬುತ್ ಹ್ಯನಾ ಮಿಳ್ನಾರ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","ಕಾ ಮಂಜೆ ಯೊನಾ ಕಸಾ ನಿನೆವೆವಾಲ್ಯಾನಾ ವಳಕ್ ಜಾ಼ಲಾ ತಸಾ ಮಾನ್ಸಾಚಾ಼ ಲ್ಯೊಕ್ ಹೆ ಪಿಳ್ಗಿಲಾ ವ್ಹಯಿಲ್. ");
INSERT INTO gok_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","ಶೆಬತ್ಲಿ ರಾನಿ ನ್ಯಾಯಿಚಾ ಯಳಾತ್ ಹೆ ಪಿಳ್ಗಿಚಾ ಲೊಕಾ ಸಂಗ ಉಠುನ್ ತ್ಯಂಚಿವ ಚು಼ಕ್ ಥರವಿಲ್: ಕಾ ಮಂಜೆ ಸೊಲೊಮನಾಚ಼ ಗಿನ್ಯಾನ್ ಐಕಾಯಾ ತಿ ಪ್ರತ್ವಿಚಾ ಮುಳಾತ್ನಿ ಆಲಿ ಆನಿ ಮಿ ತುಮಾನಾ ಕ್ಯಾ ಸಾಂಗಾಚ಼ ಮಂಜೆ ಬಗಾ ಸಲೊಮೊನಾವ್ನಿ ಥೊರ್ಲಾ ಯೊಕ್ ಹಿತ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","ನಿನೆವೆಚಿ ಲೊಕ ನ್ಯಾಯಿಚಾ ಯಳಾತ್ ಹೆ ಪಿಳ್ಗಿ ಸಂಗ ಉಬಿ ರಾಹುನ್ ಹೆ ಪಿಳ್ಗಿವ ಚು಼ಕ್ ಥರಿವ್ನಾರ್ ಕಾ ಮಂಜೆ ಪ್ರವಾದಿ ಜಾ಼ಲ್ಯಾಲಾ ಯೋನಾಚಾ ಉಪದೆಸಾನಿ ಪಶ್ಚತಾಪ್ ಜಾ಼ಲಾ; ಫನ್ ಬಗಾ ಮಿ ತುಮಾನಾ ಸಾಂಗ್ತೊ ಯೊನಾವ್ನಿ ಥೊರ್ಲಾ ಯೊಕ್ ಹಿಥ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","ದೀವಾ ಲಾವುನ್ ಕೊನ್ ಐದಾನಾ ಬುಡಿ ನಾಹಿತ ಕಶಾಚೆ ಆಡ್‌ಶಾ ಥಿವಿತ್ ನಾಹಿ, ತ್ಯೊ ಆತ್ ಯತ್ಯಾಲ್ಯಾನಾ ಉಜಿಡ್ ದಿಸಾಯಾ ವ್ಹಯಿ ಮನ್ಹು‍ನ್ ದಿವಲವನ್ಯಾವ ಥೆವ್‌ತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","ತುಜಾ ಅಂಗಾಚಾ಼ ದಿವಾ ತುಜ಼ ಡೊಳ, ತುಜ಼ ಡೊಳ ನಿರ್ದೊಸ್ ಆಸ್‍ಲ್ಯಾವ ತುಜ಼ ಆಂಗ್ ಸಗ್ಳ ಉಜಿಡಾಸ್ ರಾಥ; ದೊಶ್ ರಾಹಿಲ್ ತರ್ ತುಜ಼ ಆಂಗ್ ಬಿ ಆಂದಾರಾತ್ ರಾಥ. ");
INSERT INTO gok_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","ತುಮ್ಚೆ ಮದ್ಲಾ ಉಜಿಡ್ ಆಂದಾರ್ ವ್ಹವು ನಾಹಿ ಆಸ ಬಗಾ. ");
INSERT INTO gok_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","ತುಜ಼ ಸಗ್ಳ ಆಂಗ್ ಉಜಿಡಾಸ್ ರಾಹಿಲ್ ಆನಿ ತ್ಯಚಾ಼ ಕಚಾ಼ಸ್ ಜಾ಼ಗಾ ಆಂದಾರಾತ್ ನಸ್ನಾರ್, ಆಕಾಸ್ಮಾತ್ ತುಮಚ಼ ಆಂಗ್ ಉಜಿಡಾನಿ ಬರ್ಲ್ಯಾವ ತುಮ್ಚಾ ಆಂಗಾಚಾ಼ ಕಚಾ಼ಸ್ ಜಾ಼ಗಾ ಆಂದಾರಾತ್ ರಾಹಿತ್ನಾಹಿ ತವಾ ತುಮಚ಼ ಆಂಗ್ ಸಗ್ಳ ಉಜಿಡಾತ್ ರಾಥ. ");
INSERT INTO gok_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","ಯೇಸು ಬೊಲತಾ ಇತ್‍ಕ್ಯಾತ್ ಯಕಾ ಪರಿಸಾಯಾನಿ ತ್ಯಲಾ ಆಪ್ಲಿಕ್ಡ ಜೆವ್ನಾಲಾ ಹಾಕಟ್ಲಾ ತವಾ ಯೇಸು ಆತ್ ಜಾ಼ವುನ್ ಜೆವ್ನಾಲಾ ಬಸ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","ಯೇಸುನಿ ಜೆವಾಚೆ ಆಂದಿ ಹಾತ್ ಪ್ಯಾ ದುತ್ಲ ನಾಹಿತ ಹ್ಯ ಬಗುನ್ ಪರಿಸಾಯಾಲಾ ಆಜಾಬ್ ವಾಟ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","ಫನ್ ಪ್ರಭು ತ್ಯಲಾ ಮನ್ಲಾ, “ತುಮಿ ಪರಿಸಾಯಾಚಾ ತಾಟಾ ಬಾಹೀರ‍್ನಿ ಚಾ಼ಂಗಲ್ಯಾ ಕರ್ತಾಸಾ ಫನ್ ತುಮಚಾ಼ ಆತ್ಲಾ ಜಾ಼ಗಾ ಮೊಸಾನಿ ಆನಿ ಬುರ್ಶಾಫನಾನಿ ಬರ್ಹುನ್ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","ತುಮಿ ಬುದ್ದಿ ನಸ್‍ಲ್ಯಾಲ್ಯಾ ಮಾನ್ಸಾನು ದೇವಾನಿ ಬಾಹಿರ್ಲಾ ಜಾ಼ಗಾ ಕೆಲಾ ತ್ಯನಿಸ್ ಆತ್ಲಾ ಜಾ಼ಗಾ ಕೆಲ್ಯಾಲಾ ನವ್ಹ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","ಮನ್ಹುನ್ ಐದಾನಾತ್ನಿ ಆಸ್‍ಲ್ಯಾಲ ಗರಿಬಾನಾ ದಾನ್ ದರ್ಮ ಕರಾ ತವಾ ತುಮಿ ಕ್ಯಾಯ್‌ದ್ಯಾ ಶಾರ್ಕಿ ಬರಿ ವ್ಹನಾರ್. ");
INSERT INTO gok_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","ಆರ ಫರಿಸಾಯಾನು ತುಮ್ಚಿ ಹಾಕಿಗತ್ ಕ್ಯಾ ಸಾಂಗು, ತುಮಿ ದೇವಾಲಾ ತುಮ್ಚೆ ಬಾಗತ್‍ಲ್ಯಾ ಪುದಿನಾ, ಸತಾಪ, ಆನಿ ಪರ್ತೇಕ್ ಬಾಝಿಂಚಾ ಧಾತ್ಲಾ ಯೊಕ್ ಭಾಗ್ ದೇತಾಸಾ ಫನ್ ನ್ಯಾಯಿ ಆನಿ ದೇವಾಚಿ ಮಾಯಾ ಇಸಾರ್ತಾಸಾ ಹ್ಯಾ ಗುಶ್ಟಿ ಕರಾಚಾ ಹುಥ್ಯಾ ಸೊಡಾಚಾ ನವ್‌ಥ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","ಪರಿಸಾಯಾನು ತುಮ್ಚಿ ಹಾಕಿಗತ್ ಕ್ಯಾ ಸಾಂಗು, ಸಭಾಸ್ಥಾನಾತ್‍ ಚಾ಼ಂಗ್ಲ ಮನ್ಹುನ್ ಗಿಹ್ಯಾಚ಼ ಆನಿ ಬಾಜಾ಼ರಾತ್ನಿ ಲೊಕಾಂಚಿಪ್ನಿ ನಮಸ್ಕಾರ್ ಕರುನ್ ಗಹ್ಯಾಚ಼ ತುಮಾನಾ ಆವಾಡ್ತ. ");
INSERT INTO gok_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","ಕಸ್ಲಿ ಲೊಕ ತುಮಿ ಕಾ ಮಂಜೆ ಜಿಮ್ನಿಚಿಗತ್ ಜಾ಼ಲ್ಯಾಲೆ ಮಸುರ್ಡಿಚಿಗತ್ ಹಾಸಾ ತ್ಯಂಚಿವರ್ ಚಾ಼ಲತ್ಯಾಲ್ಯಾ ಲೊಕಾನಾ ಹ್ಯಾ ಮಸುರ್ಡ್ಯಾ ಮನ್ಹುನ್ ಸಮ್ಜ಼ತ್ ನಾಹಿತಾ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","ಹ್ಯ ಐಕುನ್ ಯಕಾ ದರ್ಮೊಪದೇಶಕಾನಿ ಯೇಸುಲಾ “ಪ್ರಭು ಹೆ ಸಬಾತ್ ಬುಲುನ್ ಆಮ್ಚಿ ನಿಂದಾ ಕೆಲ್ಯಾಚೆಗತ್ ಜಾ಼ಲಿ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","ತವಾ ಯೇಸು ಧರ್ಮೊಪದೇಶಕನಾ ತುಮ್ಚಿ ದುರ್ದೇಸ್ನಾ ಕ್ಯಾ ಸಾಂಗು? ತುಮಿ ಲೊಕಾಂಚಿವ ಉಚ಼್ಲತ್ ನಾಹಿ ಯವ್ಡ ವಜ಼ ವಾವ್ತಾಸಾ; ತುಮಿ ತರಿ ತ್ಯಾ ವಜಾಲಾ ಯಾಕ್ ಬ್ವಾಟ್ ಸಾಹಿತ್ ಲಾವಿತ್ ನಾಹಿಸಾ ");
INSERT INTO gok_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","ತುಮಿ ಕಸ್ಲ ಮಾನುಸ್? ತುಮಿ ಪ್ರವಾದಿಂಚಿ ಥಡಿ ಬ್ಯಾಂತಾಸಾ; ಫನ್ ತ್ಯನಾ ಮ್ಯಾರ್ಲ್ಯಾಲ ತುಮ್ಚಾ ವಡ್ಲಾಂಚಾನಿಸ್! ");
INSERT INTO gok_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","ಮನ್ಹುನ್ ತುಮ್ಚಾ ವಡ್ಲಾಂಚಾನಿ ಕೆಲ್ಯಾಲ್ಯಾ ಕಾಮಾನಾ ತುಮಿಸ್ ಸಾಕ್ಶಿ ಆನಿ ತ್ಯಂಚಿ ಕಾಮ ತುಮಿ ವಪ್‌ಲ್ಯಾ ಶಾರ್ಕಿ ಜಾ಼ಲ್ಹಿತ ಕಾ ಮಂಜೆ ತ್ಯಂಚಾನಿ ಪ್ರವಾದಿನಾ ಮ್ಯಾರ್ಲ ತುಮಿ ತ್ಯಂಚಿ ಥಡಿ ಬ್ಯಾಂಥಾಸಾ. ");
INSERT INTO gok_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","ಮನ್ಹುನ್ ದೇವಾಚ಼ ಗಿನ್ಯಾನ್ ಕ್ಯಾ ಸಾಂಗ್ತ ಮನ್‌ಲ್ಯಾವ “ಮಿ ತ್ಯಂಚಿಪ ಪ್ರವಾದಿನಾ ಆನಿ ಚಾ಼ಂಗ್ಲಿ ಖಬರ್ ಸಾಂಗ್‌ತ್ಯಾಲ್ಯಾನಾ ಲಾವುನ್ ದೇನಾರ್ ತ್ಯಾತ್‌ಲ್ಯಾ ಥೊಡ್ಯಾನಾ ಮಾರುನ್ ಟ್ಯಾಕ್ನಾರ್ ಆನಿ ಥೊಡ್ಯಾನಾ ತರಾಸ್ ದೇನಾರ್. ");
INSERT INTO gok_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","ಪೈಲೆ ದರ್ನಿ ಮ್ಯಾರ್‌ಲ್ಯಾಲ ಸಗ್ಳ ಪ್ರವಾದಿನಾ ಆನಿ ಚಾ಼ಂಗ್ಲಿ ಖಬರ್ ಸಾಂಗ್‌ತ್ಯಾಲ್ಯಾಂಚಾ ಮರ‍್ನಾತ್ ಗಾವಲ್ಯಾಲ್ಯಾ ಲೋಕಾನು ತುಮಾನಾ ಶಿಕ್ಷಾ ವ್ಹನಾರ್. ");
INSERT INTO gok_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","ಹೆಬೆಲಾಲಾ ಮ್ಯಾರ್ಲ್ಯಾ ದರ‍್ನಿ ಯಜ್ಞ ವೆದಿ ಆನಿ ಪವಿತ್ರ ಸ್ಥಾನ್ ಹ್ಯಂಚೆ ಮದ್ದಿ ಜಕರಿಯಾಲಾ ಮ್ಯಾರ್ಲ್ಯಾಪರ‍್ಯಾತ್ ಸಗ್‍ಳ್ಯಾ ಪ್ರವಾದಿಂಚಾ ಮರ್ನಾಚಿ ಸಿಕ್ಸೆ ಹೆ ಪಿಳ್ಗಿಲಾ ವ್ಹನಾರ್ ಮನ್ಹುನ್ ತುಮಾನಾ ಸಾಂಗ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","ಆರ ದರ್ಮೊಪದೇಶಕಾನು ತುಮಿ ಕಸ್ಲ ಮಾನುಸ್ ಗಿನ್ಯಾನಾಚಾ ಗರ್ಹಾಚಿ ಚಾವಿ ಚುರ್ಲಿಸಾ ಆನಿ ತುಮಿ ಆತ್ ಗೆಲಾ ನಾಹಿಸಾ; ಆತ್ ಜಾ಼ತ್ಯಾಲ್ಯಾನಾ ಆಡ್ವ ರಾಯ್‌ಲ್ಯಾಸಾ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","ಮಂಗ್ ಯೇಸು ತಿಥ್ನಿ ಬಾಹಿರ್ ಆಲಾ ತವಾ ಶಾಸ್ತ್ರಿ ಆನಿ ಫರಿಸಾಯ್ ತ್ಯಲಾ ಖುಬ್ ಆಡ್ವ ವ್ಹವುನ್ ಕಿತಿತರಿ ಗುಶ್ಟಿತ್ ತ್ಯಲಾ ಆಡ್ವ ತಿಡ್ವ ಪ್ರಶ್ನೆ ಇಚಾರಾಯಾ ಯವ್ಜಿತ ");
INSERT INTO gok_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ಆನಿ ತ್ಯಚಾ ಸಬ್ದಾತ್ನಿ ಕಾಯ್ ತರಿ ಚು಼ಕ್ ದರಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ತ್ಯಲಾ ಬಗಿತ್ ಹುತ್ತ. ");
INSERT INTO gok_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","ತವಾಸ್ ಖುಬ್ ಲೊಕಾಂಚಿ ಗರ್ದಿ ಜಾ಼ಲಿ ಆನಿ ತೀ ಯಕಾಮಕಾಲಾ ತುಡುವಾಯಾ ಲಾಗ್ಲಿತ; ತವಾ ಯೇಸು ಆಂದಿ ಆಪ್‌ಲ್ಯಾ ಶಿಶಾನಾ ಸಾಂಗಾಯಾಲಾಗ್ಲಾ ತುಮಿ ಪರಿಸಾಯಾಂಚಾ ಕಪಟ್ ಫನಾಚಾ ಆಂಬಾಟ್ ಪಿಠಾಚೆ ಗುಶ್ಟಿತ್ ಹುಶಾರ್ ರಾವ್ಹಾ. ");
INSERT INTO gok_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","ಜಾ಼ಕ್‌ಲ್ಯಾಲ ಸಗ್ಳ ಉಗಡ್ನಾರ್, ಜಾ಼ಕ್‍ಲ್ಯಾಲ ಸಗ್ಳ ಮಾಳಾವ ಯನಾರ್. ");
INSERT INTO gok_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","ತುಮಿ ಆಂದಾರಾತ ಬೋಲ್ಯಾಲ ಉಜಿಡಾಸ್ ಐಕು ಯಯಿಲ್ ಆನಿ ಆತ್ ಸೊಪ್ಯಾತ್ ಕಾನಾತ್ ಸಾಂಗ್‍ಲ್ಯಾಲ ಬಾಹಿರ್ ಮಾಳಿವ ಜೊ಼ರಾನಿ ಪಗಳುನ್ ಯಯಿಲ್. ");
INSERT INTO gok_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","ಮಾಜಾ ಸೊಪ್‌ತ್ಯಾನು “ಮಿ ತುಮಾನಾ ಸಾಂಗ್ತೊ ಧಡ್ ಮಾರುನ್ ಟ್ಯಾಕ್ತಿಲ ಖರ ತ್ಯನಾ ಆನಿ ಕಾಯ್ ಕರಾ ವ್ಹಯಿತ್ ನಾಹಿ ತ್ಯನಾ ಬಿಹುನಕೋಸಾ. ");
INSERT INTO gok_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","ಫನ್ ತುಮಿ ಕುನಾಲಾ ಬಿಹ್ಯಾ ವ್ಹಯಿಸಾ ತ್ಯ ಮಿ ತುಮಾನಾ ಸಾಂಗ್ತೊ ಮೆಲ್ಯಾ ನಂತರ್ ನರಕಾತ್ ಟಾಕಾಚಾ಼ ಅಧಿಕಾರ್ ಆಸ್ನಾರ‍್ಯಾ ದೇವಾಲಾ ಬಿವ್ಹಾ. ");
INSERT INTO gok_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“ಪಾಚ಼್ ಚಿಮ್ನಿ ಪಾಕ್ರ ದೊನ್ ದಮ್‍ಡ್ಯಾನಾ ಇಕ್ಲಿತ? ತರಿ. ತ್ಯಾತ್ಲ ಯಾಕ್ಬಿ ದೇವ್ ಇಸ್ರತ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","ತ್ಯಚಿ ಸಾಟಿ ತುಮ್ಚೆ ಡುಯಿತ್ಲ ಕ್ಯಾಸ್ ಸಾಹಿತ್ ಸಗ್ಳ ಮೇಜ಼ಲ್ಯಾಲ ಹಾತ್ತ ಬಿಹು ನಕೊಸಾ ಖುಬ್ ಚಿಮನ್ಯಾ ಪಾಕ್ರಾಂಚಿವ್ನಿ ತುಮಿ ಕಿಮ್ತಿಚಿ ಹಾಸಾ. ");
INSERT INTO gok_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","ಮಿ ತುಮಾನಾ ಸಾಂಗ್ತೊ ಕೊನ್ ಮಾನ್ಸಾಂಚೆ ಮೊರ‍್ಹ ಮನಾ ಆಪ್ಲಾ ಮಂತೊ ತ್ಯಲಾ ಮಾನ್ಸಾಚಾ಼ ಲ್ಯೊಕ್ಬಿ ದೇವ್ದುತಾಚೆ ಮೊರ‍್ಹ ಆಪ್ಲಾ ಮನ್ಥೊ. ");
INSERT INTO gok_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","ಖರ ಕಚಾ಼ ಮನಾ ಲೊಕಾಂಚೆ ಮೊರ‍್ಹ ನಕ್ವಾಟ್ತೊ ತ್ಯಲಾ ಮಾನ್ಸಾಚಾ ಲ್ಯೊಕ್ ಬಿ ದೇವ್ದುತಾಂಚೆ ಮೊರ‍್ಹ ನಕ್ವಾಟ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","ಆನಿ ಜೇ ಕೊನ್ ಮಾನ್ಸಾಚಾ ಲೇಕಾಚೆ ಆಡ್ವ ಕಾಯ್ ತರಿ ಬೊಲಲ್ ತ್ಯಲಾ ತ್ಯಚಿ ಮಾಪಿ ವ್ಹಯಿಲ್ ಫನ್ ಕೊನ್ ಪವಿತ್ರಾ ಆತ್ಮಾಚೆ ಆಡ್ವ ಬುರ್ಸ ಬೋಲಲ್ ತ್ಯಲಾ ತ್ಯಚಿ ಮಾಪ್ ವ್ಹನಾರ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“ತ್ಯಂಚಾನಿ ತುಮಾನಾ ಸಭಾಸ್ಥಾನಾತ್ ಸರಕಾರಾಚಾ ಅಧಿಕಾರಾಂಚೆ ಮೊರ‍್ಹ ನಿಥಿಲ ತವಾ ಕಸಾ ಕ್ಯಾ ಉತ್ತರ್ ದೆವಾವ ನಾಹಿತ ಕ್ಯಾ ಬೋಲಾವ ಹ್ಯಚಿ ಕ್ಯಾಳ್ಜಿ ಕರುನಕೊಸಾ ");
INSERT INTO gok_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","ಕಾ ಮಂಜೆ ಕ್ಯಾ ಬೊಲಾಚ಼ ತ್ಯ ಪವಿತ್ರಾತ್ಮಾ ತೆ ಗಟ್ಕಲಾ ತುಮಾನಾ ಸಿಕ್ವಿಲ್. ” ");
INSERT INTO gok_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","ತವಾ ಲೊಕಾತ್‌ಲ್ಯಾ ಯಕಾನಿ, ಯೇಸುಲಾ, “ಪ್ರಭು ಮನಾ ಮಾಜಾ ಬಾನಿ ಸುಡುನ್ ಗೆಲ್ಯಾಲೆ ಆಸ್ಥಿತ್ಲಿ ವಾಟ್ನಿ ದಿಯಾ ಮಾಜಾ ಬಾವ್ಹಾಲಾ ಸಾಂಗ್” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","ಯೇಸು ತ್ಯಲಾ “ಸೊಪ್‌ತ್ಯಾ ಮಿ ತುಮಚಾ಼ ನ್ಯಾಯಿ ಕರತ್ಯಾಲಾ ನಾಹಿತ ವಾಟ್ನಿ ಕರ್ನಾರಾ ಮನ್ಹುನ್ ಕಚಾನಿ ಥರಿವ್ಲಾಸಾ? ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","ಯೊಕ್ ಮಾನುಸ್ ತ್ಯಚಿಪ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ದಾಗಿ‌ನ್ಯಾನಿ ಸಾವ್ಕೋರ್ ವ್ಹಯಿತ್ ನಾಹಿ ");
INSERT INTO gok_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","ಆನಿ ಯೇಸುನಿ ತ್ಯನಾ ಯೇಕ್ ಕ್ಯಾಯ್ನಿ ಸಾಂಗ್ಲಿ; ತಿಥ ಯೊಕ್ ಸಾವ್ಕೋರ್ ಮಾನುಸ್ ಹುತ್ತಾ ತ್ಯಚಾ ಸೇತಾತ್ ಪೀಕ್ ಆಲ ");
INSERT INTO gok_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","ತವಾ ತ್ಯೊ ಆಪ್‌ಲ್ಯಾ ಮನಾತ್ ಮನ್ಲಾ, “ಆತಾ ಮಿ ಕ್ಯಾ ಕರು? ಕಾ ಮಂಜೆ ದಾನ ಥೆವಾಯಾ ಜಾ಼ಗಾ ನಾಹಿ. ” ");
INSERT INTO gok_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","ಮಂಗ್ ತ್ಯೊ ಮನ್ಲಾ, “ಮಿ ಆಸ ಕರ್ತೊ ಮಿ ಮಾಜ಼ ಕಳಾಂಜ಼್ ಮುಡುನ್ ಮೊಟ ಬ್ಯಾಂಥೊ; ಆನಿ ತ್ಯಾತ್ನಿ ಮಾಜ಼ ಸಗ್ಳ ದಾನ ಸಾಠಿವ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","ಮಂಗ್ ಮಿ ಮಾಜಾ ಜಿ಼ವಾಲಾ ಮನ್ಹಿನ್ ಎ ಜಿ಼ವಾ ತುಲಾ ಖುಬ್ ವರ್ಸ ವ್ಹಯಿ ಜೊ಼ಗಾ ಮ್ಹಾಲ್ ಥೆವ್‍ಲ್ಯಾಲಾ ಹಾ; ಆರಾಮ್ ರ‍್ಹಾ; ಖಾ ಪೀ ಆನಂದ್ ಕರ್. ");
INSERT INTO gok_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","ಫನ್ ದೇವ್ ತ್ಯಲಾ ಮನ್ಲಾ ಆರ ಖುಳ್ಯಾ ಆಜ಼್ ರ‍್ಯಾಚಾ಼ ತುಜಾ಼ ಜೀವ್ ತುಜಿಪ್ನಿ ನಿಹ್ಯಾ ಯತಿಲ ತವಾ ತು ಕಮಿವ್‌ಲ್ಯಾಲ ಸಗ್ಳ ಕುನಾಚ಼ತರಿ ವ್ಹಯಿಲ್? ");
INSERT INTO gok_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","ಕೊನ್ ಆಪ್ಲಿ ಸಾಟಿ ಧನ್ ಕಮುವುನ್ ಥೆವ್ತೊ ತ್ಯೊ ದೇವಾಚೆ ನದ್ರಲಾ ಸಾವ್ಕೋರ್ ನವ್ಹ. ");
INSERT INTO gok_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","ತವಾ ಯೇಸು ಆಪ್‌ಲ್ಯಾ ಶಿಶಾನಾ ಮನ್ಲಾ. “ಮಿ ತುಮಾನಾ ಸಾಂಗ್ತೊ ಆಪ್ನು ಕ್ಯಾ ಖಾಯಾಚ ಆಸ ಆಪ್‌ಲ್ಯಾ ಜಿ಼ವಾಚಿ ನಾಹಿತ ಆಪ್ನು ಕ್ಯಾ ಗಾಲ್ಹಾವ ಆಶಿ ಕಪ್‌ಡ್ಯಾಂಚಿ ಕ್ಯಾಳ್ಜಿ ಕರುನಕೊಸಾ. ");
INSERT INTO gok_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","ಕಾ ಮಂಜೆ ಆನಾವ್ನಿ ಜೀವ್ ಆನಿ ಕಪ್‌ಡ್ಯಾವ್ನಿ ಧಡ್ ಮೊಟ ಹಾ ");
INSERT INTO gok_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","ಕಾವ್‍ಳ್ಯಾಂಚಾ಼ ಇಚಾರ್ ಕರಾ ತೆ ಪಿರಿತ್ ನಾಹಿತ, ಕಾಪಿತ್ ನಾಹಿತ ತ್ಯಂಚ಼ ಕಳಾಂಜ಼್ ಆನಿ ಟುಪ್ಲಿ ನಾಹಿತ ಫನ್ ದೇವ್ ತ್ಯನಾ ಬಾಳಕ್ತೊ ಪಾಕ್ರಾಂಚಿವ್ನಿ ತುಮಿ ಖುಬ್ ಕಿಮ್ತಿಚಿ ಹಾಸಾ!. ");
INSERT INTO gok_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","ತ್ಯಂಚಿ ಕ್ಯಾಳ್ಜಿ ಕರುನ್ ಆಪ್ಲಿ ವಯೆ ವಾಡ್ವಾಯಾ ತುಮ್ಚಾತ್ ಕುನಾಲಾ ವ್ಹನಾರ್? ");
INSERT INTO gok_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","ಮನ್ಹುನ್ ಯಗ್ದಮ್ ನ್ಹಾನ್ ಗ್ಯೊಶ್ಟ್ ದಿಖಿಲ್ ತುಮ್ಚಿಪ್ನಿ ವ್ಹಯಿತ್ ನಾಹಿ ತ ದಿಸರ‍್ಯಾ ಮೊಟ್ಯಾ ಗುಶ್ಟಿಚಿ ಕ್ಯಾಳ್ಜಿ ಕಾ ಕರೀತ್ ಬಸ್ತಾಸಾ? ");
INSERT INTO gok_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","ರಾನಾತ್ಲಿ ಫುಲ ಕಸಿ ವಾಡ್‍ತ್ಯಾತ ಹ್ಯಚಾ಼ ಇಚಾರ್ ಕರಾ; ತೀ ರಾಬತ್ ನಾಹಿತ ವವಿತ್ ನಾಹಿತ ತರಿ ಹ್ಯಾ ಫುಲ್ಲಾತ್‌ಲ್ಯಾ ಯಕಾ ಫುಲಾಲಾ ಆಸ್‍ಲ್ಯಾಲಿ ಸೊಬಾ ಸೊಲೊಮನ್ ರಾಜಾಲಾಬಿ ನವ್ಥಿ. ");
INSERT INTO gok_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","ಆರ ಇಸ್ವಾಸ್ ನಸ್‌ಲ್ಯಾಲ್ಯಾ ಲೋಕಾನು ರಾನಾತ್ಲ ಗವಾತ್ ಆಜ಼್ ಹಾ ಆನಿ ಸಕಾಳ್ ಜ಼ಳುನ್ ಜಾ಼ತ ತ್ಯಲಾ ದೇವ್ ಆಸಾ ಸುಬಿವ್ತೊ ತ ಹ್ಯಚಿವ್ನಿ ಖುಬ್ ತುಮಾನಾ ನಿಸ್ವಿಲ್, ");
INSERT INTO gok_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","ಕ್ಯಾ ಖಾಯಾಚ಼? ಕ್ಯಾ ಪಿಯಾಚ಼? ಹ್ಯಚೆ ಮಾಗ ಲಾಗು ನಕೊಸಾ ನಾಹಿತ್ ಮನಾತ್ ಯವಜು಼ನ್ ಗಿಹುನಕೊಸಾ. ");
INSERT INTO gok_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","ಹ್ಯಾ ಸಗ್‍ಳ್ಯಾ ಪರಪಂಚಾತ್ಲಿ ಲೊಕ ಖಟ್ಪಟ್ ಕರ್ತ್ಯಾತ ಫನ್ ತುಮಾನಾ ತ್ಯಚಿ ಗರಜ಼್ ಹಾ ಮನ್ಹು‍ನ್ ತುಮ್ಚಾ ಸ್ವರ್ಗಾತ್‍ಲ್ಯಾ ಬಾ ದೆವಾಲಾ ಠಾವ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","ಫನ್ ತುಮಿ ಆಂದಿ ತ್ಯಚ಼ ರಾಜೆ ಮೀಳ್ವಾಯಾ ಜ಼ಠಾ ಮಂಜೆ ತ್ಯಚೆ ಸಂಗ ಹ್ಯ ಸಗ್ಳ ತುಮಾನಾ ಮಿಳಲ್. ");
INSERT INTO gok_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","ಯೇ ಬಾರಿಕ್ ಹಿಂಡಾ ಬಿಹುನಕೋಸ್ ಕಾ ಮಂಜೆ ತುಮಾನಾ ತ್ಯ ರಾಜೆ ದಿಯಾ ತುಮ್ಚಾ ಸ್ವರ್ಗಾತ್‍ಲ್ಯಾ ಬಾ ದೇವಾಲಾ ಮನ್ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","ತುಮಚ಼ ಕ್ಯಾ ಹಾ ತ್ಯ ಇಕುನ್ ಗರಿಬಾನಾ ದಾನ್ ಧರ್ಮ ಕರಾ ತಸಸ್ ಸ್ವರ್ಗಾತ್ ಫಾಟುನ್ ಜಾ಼ಯಿ ನಸ್‍ಲ್ಯಾಲ್ಯಾ ಪಿಸವ್ಯಾ ಪುಸುನ್ ಜಾ಼ಯಿ ನಸ್‍ಲ್ಯಾಲಿ ಆಸ್ಥಿ ಕರಾ ತಿಥ ಚೊ಼ರ್ ಯಯಿತ್ ನಾಹಿ ಕಸರ್ ಲಾಗತ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","ಕಾ ಮಂಜೆ ಕುಠ ತುಮಚ಼ ಧನ್ ತಿಥ ತುಮಚ಼ ಮನ್ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","ತುಮಚ಼ ಕಪ್ಡ ಗಾಲ್ಹುನ್ ದಿವ ಲಾವುನ್ ತಯಾರ್ ರಾವ್ಹಾ. ");
INSERT INTO gok_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","ದನ್ಹಿ ಲಗನಾವ್ನಿ ಯವುನ್ ದಾರ್ ವಾಜಿವ್ತೊ ತವಾಸ್ ತುಮಿ ತ್ಯಚಿ ಸಾಟಿ ಉಗಡಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ತ್ಯೊ ಯಯಾಚಿ ವಾಟ್ ಬಗ್‌ತ್ಯಾಲ್ಯಾ ಸೇವಕಾಚೆಗತ್ ತುಮಿ ರಾವ್ಹಾ. ");
INSERT INTO gok_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","ದನ್ಹಿ ಆಲ್ಯಾವ ಕಚಾ ಚಾ಼ಕೊರ್ ಜಾ಼ಗಾ ಆಸ್‌ಲ್ಯಾಲಾ ದೀಸಲ್ ತ್ಯೊ ಬರಾ; ಮಿ ತುಮಾನಾ ಖರ‍್ಯಾನಿ ಸಾಂಗ್ತೊ; ತ್ಯೊಸ್ ಆಪ್ನು ತ್ಯನಾ ಜೆವಾಯಾ ಬಸ್ವಿಲ್ ಆನಿ ಆಪ್ಲಿ ಆಂಗಿ ಕಾಡುನ್ ತ್ಯಂಚಿ ಸೇವಾ ಕರಿಲ್. ");
INSERT INTO gok_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","ತೇ ಆಳ್ ಆಪ್ಲಾ ದನ್ಹಿ ಮದ್ಲೆ ರಾತಿಚಾ಼ ಖುಬ್ ಯೊಳ್ ಕರುನ್ ಯಯಿಲ್ ತವಾ ತ್ಯಲಾ ಜಾ಼ಗಾ ದೀಸಲ್ ತ ತ್ಯಲಾ ಕ್ಯವ್ಡಾ ಆನಂದ್ ವ್ಹನಾರ್. ");
INSERT INTO gok_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","ಆನಿ ಹ್ಯ ಲಕ್ಶೆತ್ ಗೆವಾ, ಆಮ್ಕೆ ಗಟ್ಕಲಾ ಚೊ಼ರ್ ಯಯಿಲ್ ಹ್ಯ ಗರ‍್ಹಾಚಾ ದನ್ಯಾಲಾ ಸಮಾಜ಼್ಲ ಆಸ್ಥತ ತ್ಯೊ ಜಾ಼ಗಾ ರಾಹುನ್ ಆಪ್ಲ ಘರ್ ಚು಼ರು ದಿಲ ನಸ್ತ. ");
INSERT INTO gok_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","ತಸಸ್ ತುಮಿ ಸಾಹಿತ್ ತಯಾರ್ ರಾವ್ಹಾ ಕಾ ಮಂಜೆ ತುಮಿ ಯವ್ಜಿ ನಸ್‍ಲ್ಯಾಲೆ ಗಟ್ಕಲಾ ಮಾನ್ಸಾಚಾ಼ ಲ್ಯೊಕ್ ಯಯಿಲ್. ");
INSERT INTO gok_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","ತವಾ ಪೇತ್ರ ಮನ್ಲಾ, “ಪ್ರಭು ಹಿ ವಳಕ್ ತು ಆಮಾನಾ ತ್ಯವ್ಡಿಸ್ ಸಾಂಗ್‌ತ್ಯೊಸ್? ಕ್ಯಾ ಸಗ್‌ಳ್ಯಾನಾ ಸಾಂಗ್ತೊಸ್? ");
INSERT INTO gok_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","ತವಾ ಪ್ರಭು ಮನ್ಲಾ, “ದನ್ಹಿ ಆಪ್‌ಲ್ಯಾ ಕುಟ್ಮಾಲಾ ಶಾರ್‌ಕ್ಯಾ ಯಳಾಲಾ ಸಾಮಾನ್ ತಯಾರ್ ಕರುನ್ ದಿಯಾಲಾ ಕುನಾಲಾ ಥರ್ವಿಲ್ ಆಸ ಇಸ್ವಾಸಾಚಾ಼ ಆನಿ ಶಾನಾ ಗರ‍್ಹಾತ್ಲಾ ಕಾಮಾಚಾ಼ ಮಾನುಸ್ ಕೊನ್? ");
INSERT INTO gok_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","ತ್ಯಚಾ಼ ದನ್ಹಿ ಮಾಗಾರಾ ಯಯಿಲ್ ತವಾ ತ್ಯೊ ಆಳ್ ತಸ ಕರ್ತ್ಯಾಲಾ ದಿಸಲ್ ತವಾ ತ್ಯಾ ಆಳಾಲಾ ಖುಬ್ ಬರ ವಾಟ್ನಾರ್” ");
INSERT INTO gok_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","ಮಿ ತುಮಾನಾ ಖರ ಸಾಂಗ್ತೊ, ತ್ಯಲಾ ದನ್ಹಿ ಆಪ್‌ಲ್ಯಾ ಸಗ್‌ಳ್ಯಾವ ಅಧಿಕಾರ್ ದಿಯಿಲ್. ");
INSERT INTO gok_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","ಫನ್ ಆಪ್ಲಾ ದನ್ಹಿ ಯಯಾ ಉಸಿರ್ ಹಾ ಆಸ ಆಪ್‌ಲ್ಯಾ ಮನಾತ್ ಮನ್ಹುನ್ ಕಚಾ಼ ಆಳ್ ಚಾ಼ಕ್ರಾಲಾ ಆನಿ ಚಾ಼ಕ್ರಿನಿಲಾ ಮಾರ್‌ಜೊ಼ಡ್ ಕರ್ತೊ ಆನಿ ಖಾವುನ್ ಪಿವುನ್ ನಿಸೇತ್ ರಾಹಿಲ್. ");
INSERT INTO gok_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ಆನಿ ತ್ಯಾ ಆಳಾಲಾ ಠಾವಿ ನಸ್‌ಲ್ಯಾಲೆ ಗಟ್ಕಲಾ ತ್ಯಚಾ಼ ದನ್ಹಿ ಯವುನ್ ತ್ಯಲಾ ಶಿಕ್ಶಾದಿವುನ್ ಇಸ್ವಾಸ್ ನಸ್‌ಲ್ಯಾಲ್ಯಾ ಲೊಕಾಂಚೆ ಸಂಗ ಗ್ಯಾಲ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","ಆಪ್‌ಲ್ಯಾ ದನ್ಯಾಚಿ ಇಚಾ ಕ್ಯಾ ಮನ್ಹುನ್ ಠಾವಿ ಆಸುನ್ ತ್ಯಾ ಆಳಾನಿ ತಯಾರ್ ಕಿಲಿ ನಾಹಿ ಮಂಜೆ. ತ್ಯಚಾ ಮನಾಶಾರ್ಕ ಕೇಲನಾಹಿ ತ್ಯಲಾ ಖುಬ್ ತಡಾಕ ಮ್ಯಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","ದನ್‌ಹ್ಯಾಪ್ನಿ ತಡಾಕ ಗಿಹ್ಯಾಚ಼ ಬರ ಫನ್ ಕಚಾನಿ ತಡಾಕ ಗಿಹಿ ಜೊ಼ಗ ಕಾಮ್ ಠಾವ ನಸ್ಥಾನಾ ಕೆಲ್ಯಾ ತ್ಯಲಾ ಥೊಡ ಮಿಳ್ತಿಲ ಜೆ ಕಚಾಲಾ ಖುಬ್ ದಿಲ್ಯಾಲ ಹಾ ತ್ಯಚಿಪ್ನಿ ಖುಬ್ ಗೆನಾರ್ ಆನಿ ಕಚಾಪ ಖುಬ್ ಜವಾಬ್ದಾರಿ ದಿಲ್ಯಾಲಿ ಹಾ ತ್ಯಚಿಪ್ನಿ ಆನಿ ಖುಬ್ ಮಾಗ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“ಮಿ ದರ್ಥಿವ ಆಗ್ ಪೆಟ್ವಾಯಾ ಆಲ್ಯೊ ತೀ ಹ್ಯಚೆ ಆಂದಿ ಪೆಟ್ಲೆ ಮಂಥೊ! ");
INSERT INTO gok_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","ಮನಾ ದುಸ್ರೆ ತರನಿ ಬಾಪ್ತಿಸ್ಮಾ ವ್ಹಯಾಚಿ ಹಾ ತಿ ವ್ಹಯಿಸ್ ಪರ‍್ಯಾತ್ ಮಿ ಮೊಟ್ಯಾ ಪೆಚಾಟಾತ್ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","“ಮಿ ದರ್ಥಿವ ಶಾಂತ್ ಕರನ್ಯಾಸ್ ಆಲ್ಯೊ ಆಸ ತುಮಾನಾ ವಾಟ್ಯಾ ಕ್ಯಾ? ನಾಹಿ ಮಿ ದುಯಿ ಗಾಲಾಯಾ ಆಲ್ಯೊ” ಮನ್ಹುನ್ ಮಿ ತುಮಾನಾ ಸಾಂಗ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","ಆತಾಚಾನ್ ಯಕಾ ಗರ‍್ಹಾತಲ್ಯಾ ಪಾಚ಼್ ಜ಼ನಾತ್ ದೊಗಾಂಚೆ ಆಡ್ವ ತಿಗ ಆನಿ ತಿಗಾಂಚೆ ಆಡ್ವ ದೊಗ ಆಸಿ ದುಯಿ ಪಡಲ್. ");
INSERT INTO gok_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","ಲೇಕಾಚೆ ಆಡ್ವಾವ ಬಾ ಆನಿ ಬಾಚೆ ಆಡ್ವಾ ಲ್ಯೊಕ್ ಲೀಕಿಚೆ ಆಡ್ವಿ ಆಯಿ ಆನಿ ಆಯಿಚೆ ಆಡ್ವಿ ಲೇಕ್ ಸುನಚೆ ಆಡ್ವಿ ಸಾಸೊ ಆನಿ ಸಾಸೊಚೆ ಆಡ್ವಿ ಸುನ್ ಆಸಿ ದುಯಿ ಪಡಲ್. ");
INSERT INTO gok_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","ಆನಿ ಯೇಸು ಲೊಕಾನಾ ಮನ್ಲಾ, “ತುಮಿ ಢಗ್ ಪಶ್ಚಿಮಾತ್ನಿ ವರ್ ಯತ್ಯಾಲಾ ಬಗ್ತಾಸಾ ತವಾಸ್ ತುಮಿ ಪಾವುಸ್ ಯತ್ಯೊ ಮಂಥಾಸಾ ಆನಿ ತಸಸ್ ವ್ಹತ್ತ ");
INSERT INTO gok_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","ದಕ್ಶಿನಾತ್ನಿ ವಾರ ಸುಟ್ಟ ತವಾ ಗರ್ಮಿ ವ್ಹನಾರ್ ಆಸ ತುಮಿ ಮನ್ಥಾಸಾ ಆನಿ ತಸ್ಸಸ್ ವ್ಹತ್ತ. ");
INSERT INTO gok_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","ಆರ ಕುಸಡ್ಯಾನು ತುಮಾನಾ ಅಬ್ಳಾತ್ಲ ಆನಿ ದರ್ಥಿವ್ಲ ಹವಾಮಾನ್ ಸಮಾಸ್ತ ಆನಿ ಹ್ಯಾ ಯಳಾಚಾ಼ ಅರ್ಥ ಫುಡುನ್ ಸಾಂಗಾಯಾ ತುಮಾನಾ ಕಾ ಠಾವಾ ನಾಹಿ? ");
INSERT INTO gok_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","ಚಾ಼ಂಗ್ಲ ಕರಾಯಾ ತುಮಾನಾ ತುಮಿಸ್ ಕಾ ಪರಿಕ್ಶೆ ಕರುನ್ ಗಿಹಿತ್ನಾಹಿಸಾ? ");
INSERT INTO gok_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","ತು ತುಜಾ ವಾದಿ ಸಂಗ ಮೊಟ್ಯಾ ಮಾನ್ಸಾಪ ಜಾ಼ತಾನಾ ವಾಟತುಸ್ ತ್ಯಂಚಿ ಸಂಗ ಯಕಿ ವ್ಹಯಾ ಯತ್ನ ಕರ್; ನಾಹಿತ ತ್ಯೊ ತುಲಾ ನ್ಯಾಯಿ ಕರ್ತ್ಯಾಲ್ಯಾಪ ವಡುನ್ ನಿಹಿಲ್; ಆನಿ ನ್ಯಾಯಿ ಕರ್ತ್ಯಾಲಾ ತುಲಾ ಪೊಲ್ಸಾಚಾ ಹತಾತ್ ದೆನಾರ್ ಆನಿ ತೇ ಕುಂಡುನ್ ಗ್ಯಾಲತಿಲ. ");
INSERT INTO gok_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","ತು ತುಜಿ ಸೆವಟ್ಚಿ ದಮಡಿ ಫಿಡಿ ಪರೆತ್ ತು ತಿತ್ನಿ ಬಾಹಿರ್ ಯಯಾ ವ್ಹಯಿತ್ನಾಹಿ ಮನ್ಹುನ್ ತುಲಾ ಡಾಚು಼ನ್ ಸಾಂಗ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","ತ್ಯಾ ಯಳಾತ್ ತಿಥ ಆಸ್‍ಲ್ಯಾಲಿ ಥುಡಿ ಲೊಕ ಯವುನ್ ಪಿಲಾತಾನಿ ಗಲಿಲಾಯಾ ಕರಾಂಚ಼ ರಗಾತ್ ತ್ಯಂಚಾನಿ ಅರ್ಪನ್ ಕೆಲ್ಯಾಲ್ಯಾ ಯಜ್ಞಾತ್ ಮಿಸಳ್ಯಾ ಮನ್ಹುನ್ ಯೇಸುಲಾ ಕಳಿವ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","ಮಂಗ್ ಯೇಸುನಿ ತ್ಯನಾ ಸಾಂಗ್ಲ ಗಲಿಲಾಯಾತ್ ಮ್ಯಾರ್ಲ್ಯಾಲಿ ದಿಸ್ರಿ ಖುಬ್ ಪಾಪಿ ಮನ್ಹುನ್ ತುಮಿ ಸಮಜು಼ನ್ ಗೆಥಾಸ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","ತಸ ಸಮಜು಼ನಕೋಸಾ ಜ಼ರ್ ತುಮಿ ಪಶ್ಚಾತಾಪಾನಿ ದೇವಾಕ್ಡ ಪರಾತ್ಲಾ ನಾಹಿಸಾ ತ ತುಮಚಾ಼ ಸಗ್‌ಳ್ಯಾಂಚಾ಼ ತ್ಯಂಚಿಗತ್ ನಾಸ್ ವ್ಹನಾರ್! ");
INSERT INTO gok_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","ತ್ಯಾ ಆಟ್ರಾ ಜ಼ನಾವ ಶಿಲೊಹಾತ್ಲಾ ಬುರುಜ್ ಪಡ್ಲಾ ಆನಿ ತೇ ಠಾರ್ ಮೆಲ ತೆ ಯೆರುಸಲೇಮಿತ್ ರಾಥ್ಯಾಲ್ಯಾ ಸಗ್‌ಳ್ಯಾ ಲೊಕಾಂಚಿವ್ನಿ ಅದಿಕ್ ಅಪರಾದಿ ಹುತ್ತ ಆಸ ತುಮಾನಾ ವಾಟ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","ಮಿ ತುಮಾನಾ ಸಾಂಗ್ತೊ, ತಸ ನವ್ಥ ಫನ್ ಜ಼ರ್ ತುಮಿ ತುಮ್ಚಾ ಪಾಪಾತ್ನಿ ಪರಾತ್ಲಾ ನಾಹಿಸಾತ ತುಮ್ಚಾ ಸಗ್‌ಳ್ಯಾಂಚಾ಼ ತ್ಯಂಚಿಗತ್ ನಾಸ್ ವ್ಹನಾರ್!” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","ಯೇಸುನಿ ಹಿ ಕ್ಯಾಯ್ನಿ ಸಾಂಗ್ಲಿ: “ಯಕಾ ಮಾನ್ಸಾನಿ ಆಪ್‌ಲ್ಯಾ ದರಾಕ್ಶಿಚಾ ಮಳ್ಯಾತ್ ಅಂಜು಼ರಾಚ಼ ಜಾ಼ಡ್ ಲ್ಯಾವ್ಲ ಹುತ್ತ. ತ್ಯಲಾ ತ್ಯೊ ಯಂಗ್ದಾ ಫಳ್ ಬಗಾಯಾ ಆಲಾ ಖರ ತ್ಯಲಾ ಕಾಯ್ ದಿಸ್ಲ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","ತವಾ ತ್ಯನಿ ಕಾಮ್ಯಾರ‍್ಯಾಲಾ ಹಾಕ್ಟುನ್ ಬಗ್ ಮಿ ಹ್ಯ ಝ಼ಾಡ್ ಫಳ್ ದಿಯಿಲ್ ಮನ್ಹುನ್ ತೀನ್ ವರ್ಸಾ ಠಾವ್ನಿ ಯತ್ಯೊ ಫನ್ ಕಾಯ್ ಗಾವ್ಲ ನಾಹಿ ತ್ಯ ತುಡುನ್ ಟ್ಯಾಕ್ ಉಗಸ್ ತ್ಯನಿ ಜಾ಼ಗಾತರಿ ಕಾ ಆಡ್ಯಾವಾಚಾ಼? ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","ತವಾ ತ್ಯೊ ಕಾಮ್ಯಾರಾ, “ಧನ್ಯಾ ಯವ್ಡ ವರಿಸ್ ತ್ಯ ರಾಹು‍ನಿ ಮಂಜೆ ಮಿ ತ್ಯಚೆ ಬೌತ ಖಾಂದುನ್ ಖತ್ ಗ್ಯಾಲ್ಥೊ; ");
INSERT INTO gok_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","ತವಾ ಮೊರ್ಲ್ಯಾ ವರ್ಸಾತ್ ಆಂಜು಼ರಾಚ಼ ಫಳ್ ಆಲ ತ ಬರ, ನಾಹಿತ ಮಿ ತ್ಯಲಾ ತುಡುನ್ ಟ್ಯಾಕ್ತೊ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","ಯೇಸು ಸಬ್ಬತ್ ದಿಸಾದಿಸಿ ಯಕಾ ಸಭಾಸ್ಥಾನಾತ್ ಸಿಕ್ವಿತ್ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","ಆಟ್ರಾ ವರ್ಸಾ ದ್ನರಿ ಬರ್ಶಾ ಆತ್‌ಮ್ಯಾನಿ ಕಂಬಾರ್ ವಾಕುನ್ ಸೀಕ್ ಪಡ್‌ಲ್ಯಾಲಿ ಯೇಕ್ ಬಾಯಿಲ್ ಮಾನುಸ್ ಹುತ್ತಿ. ");
INSERT INTO gok_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","ಯೇಸುನಿ ತಿಲಾ ಬಗುನ್ ಹಾಕ್ಟುನ್ “ಬಾಯಿ ತು ತುಜಾ ರೊಗಾತ್ನಿ ಸುಟ್ಕಿ ಜಾ಼ಲಿಸ್” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","ಯೇಸುನಿ ತಿಚಿವರ್ ಹಾತ್ ಥೆವ್ತಾನಾಸ್ ತಿ ನಿಟ್ ಜಾ಼ಲಿ ಆನಿ ದೇವಾಚಿ ಮೈಮಾ ಗಾವಾಲಾಗ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","ಯೇಸುನಿ ಸಬ್ಬತಾ ದಿಸಿ ರೊಗ್ ಬರಾ ಕೆಲಾ ಮನ್ಹುನ್ ಸಬಾಮಂದಿರಾತ್ಲಾ ಅಧಿಕಾರಿ ರಾಗ್ ಕರುನ್ ಲೊಕ್ ಸಮುದಾಯಾಲಾ ಮನ್ಲಾ, “ವ್ಹಯಿತ್ಯ ಕಾಮ್ ಕರಾಯಾ ಸಾ ದೀಸ್ ಹಾತ್ತ ತವಾ ತ್ಯಾ ದಿಸಾತ್ ಯವುನ್ ಬರ ವ್ಹವುನ್ ಜಾ಼ವಾ ಸಬ್ಬತಾ ದಿಸಿ ತ್ಯವ್ಡ ನಕೊ. ");
INSERT INTO gok_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","ಫನ್ ಯೇಸು ತ್ಯಲಾ ಮನ್ಲಾ, “ಕುಸಡ್ಯಾನು ತುಮ್ಚಾತ್ಲಾ ಪರ್ತೇಕ್ ಜಾ಼ನ್ ಆಪ್ಲಾ ಬೈಲ್ ಕಿವಾ ಗಾಡಾವ್ ಸಬ್ಬತಾ ದಿಸಿ ಗೊಟ್ಯಾತ್ನಿ ಸುಡುನ್ ಪಾನ್ಯಾತ್ ನೆಥ್ಯಾತ ನವ್ಹ? ");
INSERT INTO gok_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","ಹಿ ಬಾಯಿ ಅಬ್ರಹಾಮಾಚಾ ವಂಶಾತ್ಲಿ ಹಿಲಾ ಸೈತಾನಾನಿ ಆಟ್ರಾ ವರ್ಸ ಬಾಂದುನ್ ಥಿವ್ಲಿಹುತ್ತಿ ಸಬ್ಬತಾ ದಿಸಿ ಹಿಲಾ ಹ್ಯಾ ಬಾಂದಾನಾತ್ನಿ ಶೊಡ್‌ಲ್ಯಾಲ ಬರ ನವ್ಹ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","ತ್ಯೊ ಹ್ಯ ಬೊಲ್ತಾನಾ ತ್ಯಚ಼ ಸಗ್ಳ ವಾದಿ ಫಸ್ಲ ಆನಿ ತ್ಯನಿ ತಿಥ ಚಮತ್ಕಾರಿಚಿ ಕಾಮ ಕಿಲಿತ ತವಾ ಸಗ್‌ಳ್ಯಾನಾ ಆನಂದ್ ಜಾ಼ಲಾ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","ಯೇಸು ಕ್ಯಾ ಮನ್ಲಾ ಮಂಜೆ “ದೇವಾಚ಼ ರಾಜೆ ಕಶಾ ಶಾರ್ಕ ಹಾ? ಮಿ ತ್ಯಲಾ ಕಶಾಚಿ ಉದಾರನ್ ದಿವು? ");
INSERT INTO gok_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","ದೇವಾಚ಼ ರಾಜೆ ಮೌರಿಚಾ ದಾನ್ಯಾ ಶಾರ್ಕ ಹಾ. ತ್ಯ ಯಕಾ ಮಾನ್ಸಾನಿ ಗಿಹುನ್ ಆಪ್‌ಲ್ಯಾ ಶೆತಾತ್ ಪೇರ್ಲ ತ್ಯ ಉಗವುನ್ ಮೊಟಾ ಡಾಳ್ಹಾ ಜಾ಼ಲ್ಹಾ. ಆನಿ ಆಬ್ಳಾತ್ಲಿ ಪಾಕ್ರ ತ್ಯಚಾ ಖಾಂಡ್ಯಾವ್ನಿ ಕುಟಿ ಕರುನ್ ರಾಹ್ಯಾ ಲಾಗ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","ತ್ಯೊ ಆನಿಕ್ ಮನ್ಲಾ, ಮಿ ದೇವಾಚಾ ರಾಜಾಲಾ ಕ್ಯಾ ಉದಾರನ್ ದಿವು? ");
INSERT INTO gok_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","ತ್ಯ ಅಂಬಾಟ್ ಫಿಠಾಚೆಗತ್ ಹಾ, ತ್ಯ ಯಕ ಬಾಯಿಲ್ ಮಾನ್ಸಾನಿ ಗಿಹುನ್ ತೀನ್ ಶೇರ್ ಪಿಠಾತ್ ಮಿಸಳ್ಳ ನಂತರ್ ತ್ಯ ಸಗ್ಳ ಪೀಟ್ ಫುಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","ಯೇಸು ಗಾವಾ ಗಾವಾನಿ ಖೆಡ್ಯಾ ಖೆಡ್ಯಾನಿ ಶಿಕ್ಶನ್ ದಿಯಿತ್ ಯೆರುಸಲೇಮಿಕ್ಡ ಜಾ಼ಯಿತಾ. ");
INSERT INTO gok_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","ತವಾ ಯಕ್ಲಾ ಯೇಸುಲಾ “ಪ್ರಭು ರಕ್ಷನ್ ವ್ಹಯಾಚಿ ಆಸ್‌ಲ್ಯಾಲಿ ಥೂಡಿಸ್ ಲೊಕ ಹಾತ್ತ ಕ್ಯಾ? ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","ಯೇಸು ತ್ಯಲಾ ಮನ್ಲಾ, “ಆವಳ್ ದಾರಾನಿ ಆತ್ ಜಾ಼ಯಾಲಾ ಯತ್ನ ಕರಾ, ಕಾ ಮಂಜೆ ಮಿ ತುಮಾನಾ ಸಾಂಗ್ತೊ ಖುಬ್ ಲೊಕ ಆತ್ ಜಾ಼ಯಾಲಾ ಬಗ್ತಿಲ ಫನ್ ತ್ಯನಾ ಜಾ಼ಯಾ ವ್ಹನಾರ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","ಗರ‍್ಹಾಚಾ ದನ್‌ಹ್ಯಾನಿ ಉಠುನ್ ದಾರ್ ಜಾಕಲ್ಯಾ ನಂತರ್ ತುಮಿ ಬಾಹಿರ್ ಉಬಿ ರಾಹುನ್ ದಾರ್ ಬಡವಿತ್, “ಪ್ರಭು ಆಮ್ಚಿ ಸಾಟಿ ದಾರ್ ಉಗಡ್ ಮನ್ಸಿಲಾ ತವಾ ತ್ಯೊ ತುಮಾನಾ ತುಮಿ ಕೊನ್ ತ್ಯ ಮನಾ ಠಾವಿ ನಾಹಿಸಾ” ಮನ್ಹುನ್ ಉತ್ತರ್ ದಿಯಿಲ್. ");
INSERT INTO gok_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","ತವಾ ತುಮಿ ಮನ್ಹಾಯಾ ಲಾಗ್ಸಿಲಾ, “ಆಮಿ ತುಜಿ ಸಂಗ ಖಾನ ಪಿನ ಕೆಲ್ಯಾ ಆನಿ ತು ಆಮ್ಚಾ ಗಾವಾತ್ ಶಿಕ್ಶನ್ ದಿಲಸ್. ");
INSERT INTO gok_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","ಫನ್ ತ್ಯೊ ಮನ್ಹಿಲ್, “ಮಿ ತುಮಾನಾ ಸಾಂಗ್ತೊ ತುಮಿ ಕೊನ್ ಕುಟ್ಲಿ ಹಾಸಾ ಹ್ಯ ಮನಾ ಠಾವ ನಾಹಿ ತುಮಿ ಬುರ್ಸಿ ಲೊಕ ಮಾಜಿಪ್ನಿ ದುರ್ ಜಾ಼ವಾ. ");
INSERT INTO gok_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","ತುಮಿ ದೇವಾಚಾ ರಾಜಾತ್ನಿ ಬಾಹಿರ್ ಗಾಲ್ಹುನ್ ಅಬ್ರಹಾಮ್, ಇಸಾಕ್, ಯಾಕೊಬ್, ಆನಿ ಸಗ್‌ಳ್ಯಾ ಪ್ರವಾದಿನಾ ದೇವಾಚಾ ರಾಜಾತ್ ಆಸ್‌ಲ್ಯಾಲಿ ಬಗ್ಸಿಲಾ ತುಮಾನಾ ಬಾಹಿರ್ ಗ್ಯಾಲ್ನಾರ್ ತವಾ ತಿಥ ರಡ್ನಾರ್ ಆನಿ ದಾತ್ ಖಾನಾರ್ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","ಪೂರ್ವಾಕ್ನಿ ಪಶ್ಚಿಮಾಕ್ನಿ ಆನಿ ಉತ್ತರಾಕ್ನಿ ದಕ್ಶಿನಾಕ್ನಿ ಲೊಕ ಯವುನ್ ದೇವಾಚಾ ರಾಜಾತ್ ಜೆವಾನ್ ಖಾಯಾಲಾ ಬಸ್ತಿಲ. ");
INSERT INTO gok_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","ಆನಿ ಬಗಾ ಪೈಲಿ ಆಸ್‌ಲ್ಯಾಲಿ ಥುಡಿಜನ ಸೆವಟ್ಚಿ ವ್ಹನಾರ್ ಆನಿ ಸೆವಟ್ಚಿ ಜಾ಼ಲ್ಯಾಲಿ ಥುಡಿಜನ ಪೈಲಿ ವ್ಹನಾರ್ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","ತೆ ಗಟ್ಕಲಾ ಥೊಡ ಫರಿಸಾಯ್ ಯೇಸುಪ ಯವುನ್ ಮನ್ಲ, “ಹಿತ್ನಿ ನಿಗುನ್ ಜಾ಼ ಕಾ ಮಂಜೆ ಹೆರೊದ್ ತುಲಾ ಜಿ಼ವಾನಿ ಮಾರಾಯಾ ಬಗತ್ಯಾಲಾ ಹಾ. ” ");
INSERT INTO gok_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","ಯೇಸು ತ್ಯನಾ ಮನ್ಲಾ, “ತ್ಯಾ ಕೊಲ್ಯಾಲಾ ಜಾ಼ವುನ್ ಸಾಂಗಾ ಬಗಾ ಮಿ ಆಜ಼್ ಆನಿ ಸಕಾಳ್ ಭುಥ ಕ್ಯಾಡ್ತೊ ರೊಗ್ ಬರಾಕರ್ತೊ ಆನಿ ತಿನ್ವೆ ದಿಸಿ ಮಿ ಸಗ್ಳ ಸಪಿವ್ತೊ, ");
INSERT INTO gok_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","ತರಿ ಮಿ ಆಜ಼್ ಸಕಾಳ್ ನಾಹಿತ ಪರ್ವಾದಿಸಿ ಮೊರ‍್ಹ ಜಾ಼ಯಾ ಪಾಯ್ಜೆ ಕಾ ಮಂಜೆ ಯೆರುಸಲೇಮಿಚೆ ಬಾಹಿರ್ ಪ್ರವಾದಿಚಾ಼ ನಾಸ್ ವ್ಹನಾರ್. ");
INSERT INTO gok_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","ಯೆರುಸಲೇಮೆ, ಯೇರುಸಲೇಮೆ ಪ್ರವಾದಿಚಾ಼ ಘಾತ್ ಕರ್ನಾರೆ ಆನಿ ತುಜಿಪ ಲಾವುನ್ ದಿಲ್ಯಾಲ್ಯಾನಾ ದೊಂಢ ಮಾರ್ನಾರೆ! ಕುಂಬ್ಡಿ ಕಸಿ ಆಪ್ಲಿ ಪಿಲಿ ಪಖಾ ಖಾಲ್ ಯಕಿಕ್ಡ ಕರೀತ್ ಆಸ್ಥಿ ತಸ ತುಜಾ ಮುಲಾ ಬಾಳಾನಾ ಯಕಿಕ್ಡ ಕರಾಚಿ ಖುಬ್ ಮಾಜಿ ಇಚ್ಚಾ ವ್ಹತ್ತಿ ಫನ್ ತುಮ್ಚಿ ಇಚ್ಚಾ ನವ್ಥಿ! ");
INSERT INTO gok_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","ಬಗಾ ತುಮಚ಼ ಘರ್ ಮೊಕ್ಳ ವ್ಹನಾರ್ ಮಿ ತುಮಾನಾ ಸಾಂಗ್ತೊ ಪ್ರಬುಚಾ ನಾವಾನಿ ಯನಾರ‍್ಯಾಲಾ ಧನ್ಯವಾದ್ ವ್ಹವುನಿ ಆಸ ತುಮಿ ಮನ್ಹಿಸ್ ಪರ‍್ಯಾತ್ ಮಿ ತುಮ್ಚೆ ನದ್ರಲಾ ಪಡ್ನಾರ್ ನಾಹಿ. ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","ಯೇಸು ಯಕಾ ಸಬ್ಬತ್ ದಿಸಾದಿಸಿ ಪರಿಸಾಯಾತ್‌ಲ್ಯಾ ಯಕಾ ಅಧಿಕಾರಿಚಾ ಗರ‍್ಹಾತ್ ಜೆವ್ನಾಲಾ ಗೆಲಾ ತವಾ ಥುಡಿ ಲೊಕ ಯೇಸುಚೆ ಪಾಳತಿವ ಬಸ್ಲಿ ಹುತಿತ. ");
INSERT INTO gok_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","ಆನಿ ಹಾತ್ ಪ್ಯಾ ಸುಜ್‌ಲ್ಯಾಲಾ ಮಾನುಸ್ ಯೇಸುಚೆ ಮೊರ‍್ಹ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","ಯೇಸುನಿ ಶಾಸ್ತ್ರಿನಾ ಆನಿ ಫರಿಸಾಯಾನಾ ಸಬ್ಬತಾ ದಿಸಿ ರೊಗ್ ಬರಾ ಕರಾಚಾ಼ ಯೊಗ್ಯ ಕ್ಯಾ ನಾಹಿ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","ತವಾ ತೇ ಗಪ್ ರಾಹಿಲ ಮಂಗ್ ಯೇಸುನಿ ತ್ಯಲಾ ಜ಼ವಳ ಗಿಹುನ್ ಬರಾ ಕೆಲಾ ಆನಿ ಲಾವುನ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","ಮಂಗ್ ಯೇಸು ತ್ಯನಾ ಮನ್ಲಾ, “ತುಮ್ಚಾತ್ ಕುನಾಚಾ಼ತರಿ ಪ್ಯೊರ್ಗಾ ನಾಹಿತ ಬೈಲ್ ಬಾವಿತ್ ಪಡ್ಲಾ ತ ತುಮಿ ತ್ಯಲಾ ಸಬ್ಬತಾದಿಸಿ ತಾಬಡ್ತೊಬ್ ಬಾಹಿರ್ ಕಾಡಿತ್ ನಾಹಿಸಾ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","ತವಾ ತ್ಯನಾ ತ್ಯಚಾ ತ್ಯಾ ಪ್ರಶ್ನೆಲಾ ಉತ್ತರ್ ದಿಯಾಲಾ ವ್ಹಯಿನಾ. ");
INSERT INTO gok_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","ತವಾ ಹಾಕಟ್‌ಲ್ಯಾಲಿ ಲೊಕ ಚಾ಼ಂಗ್ಲ ಜಾ಼ಗ ನಿವುಡುನ್ ಹುತ್ತಿತ ತ್ಯ ಬಗುನ್ ಯೇಸುನಿ ಹಿ ಕ್ಯಾಯ್ನಿ ಸಾಂಗ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","ಕುನಿ ತರಿ ತುಲಾ ಲಗ್ನಾಚಾ ಜೆವ್ನಾಲಾ ಹಾಕಟ್ಲತ ಚಾ಼ಂಗಲ್ಯಾ ಜಾ಼ಗ್ಯಾವ ಬಸು ನಕೊ ಆಕಾಸ್ಮಾತ್ ತುಜಿವ್ನಿ ಮೊಟ್ಯಾ ಮರೆದಿಚಾ ಮಾನ್ಸಾಲಾ ತ್ಯನಿ ಹಾಕಟ್‍ಲ್ಯಾಲ ರಾಹಿಲ್. ");
INSERT INTO gok_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ಮಂಗ್ ಕಚಾನಿ ತುಲಾ ಆನಿ ತ್ಯಲಾ ಹಾಕಟ್ಲ ಹುತ್ತ ತ್ಯೊ ತುಜಿಪ ಯವುನ್ ಹ್ಯಲಾ ಜಾ಼ಗಾ ದೇ ಮನ್ಹಿಲ್ ತವಾ ತು ಮರ‍್ಯಾದ್ ನಸ್ಥಾನಾ ತವಾಸ್ ಆಗ್ದಿ ಖಾಲ್ಚಾ ಜಾ಼ಗ್ಯಾವ ಜಾ಼ವುನ್ ಬಸ್ಸಿಲ್. ");
INSERT INTO gok_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","ಫನ್ ತುಲಾ ಹಾಕಟ್‍ಲ್ಯಾಲ್ಯಾಲಾ ತು ಜಾ಼ವುನ್ ಆಗ್ದಿ ಖಾಲ್ಚಾ ಜಾ಼ಗ್ಯಾವ ಭಸ್. ಮಂಜೆ ಕಚಾನಿ ತುಲಾ ಹಾಕಟ್ಲ ಹುತ್ತ ತ್ಯೊ ಯವುನ್ ತುಲಾ ಸೊಪ್‌ತ್ಯಾ ವರ್ ಯವುನ್ ಭಸ್ ಮನ್ಹಿಲ್ ತವಾ ತುಜೆ ಸಂಗ ಜೆವ್ನಾಲಾ ಬಸ್‍ಲ್ಯಾಲ್ಯಾಂಚೆ ಮೊರ‍್ಹ ತುಲಾ ಮಾನ್ ಯಯಿಲ್. ");
INSERT INTO gok_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","ಕಾ ಮಂಜೆ ಕೊನ್ ಆಪ್‌ಲ್ಯಾಲಾ ಆಪ್ನುಸ್ ಮೊಟಾ ಮನ್ಹುನ್ ಗೆಥೊ ತ್ಯೊ ಬಾರಿಕ್ ವ್ಹತೊ ಆನಿ ಬಾರಿಕ್ ರಾಹಿಲ್ ತ್ಯೊ ಮೊಟಾ ವ್ಹತೊ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","ಮಂಗ್ ಯೇಸು ಕಚಾನಿ ಆಪ್‌ಲ್ಯಾಲಾ ಹಾಕಟ್ಲಾ ಹುತ್ತಾ ತ್ಯಲಾಬಿ ಮನ್ಲಾ, “ತು ದುಪ್ಯಾರ್ಚಾ ಜೆವ್ನಾಲಾ ನಾಹಿತ ಶಾಂಚಾ ಜೆವ್ನಾಲಾ ತುಜಾ ಸೊಪ್‌ತ್ಯಾನಾ ನಾಹಿತ ತುಜಾ ಬಾವ್ಹಾನಾ ನಾಹಿತ ತುಜೆ ಮಾಯೆ ದಾಯೆಲಾ ಸಾವ್ಕಾರ್ ಆಸ್‍ಲ್ಯಾಲ್ಯಾ ಸೆಜಾ಼ರ‍್ಯಾನಾ ಹಾಕಟುನಕೊ ತೀ ತುಲಾ ಸಾಹಿತ್ ಹಾಕಟ್ತಿಲ ಆನಿ ತುಮ್ಚಿ ಫಿಟಾಪಿಟ್ ವ್ಹಯಿಲ್. ” ");
INSERT INTO gok_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","ತುಮಿ ಜೆವಾನ್ ಗಾಲ್ಹಾಚ಼ ತವಾ ಗರಿಬಾನಾ ಲುಲ್ಯಾನಾ ಆಂದ್‌ಳ್ಯಾನಾ ಹಾಕ್ಟಾ. ");
INSERT INTO gok_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","ಮಂಜೆ ತುಮಿ ಬರ ವ್ಹನಾರ್ ಕಾ ಮಂಜೆ ತುಮಾನಾ ಫಿಟಾಪಿಟ್ ಕರಾಯಾ ತ್ಯಂಚಿಪ ಕಾಯ್ ನಾಹಿತರಿ ಮರ್ನಾತ್ನಿ ಉಠುನ್ ಯತಾನಾ ದೇವ ತುಲಾ ಆಶಿರ್ವಾದ್ ಕರಿಲ್. ");
INSERT INTO gok_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","ಯೇಸು ಸಂಗ ಜೆವ್ನಾಲಾ ಬಸ್‌ಲ್ಯಾಲ್ಯಾತ್ ಯಕಾನಿ ಹೆ ಸಬಾತ್ ಐಕುನ್ ಸ್ವರ್ಗಾಚಾ ರಾಜಾತ್ ಕೊನ್ ಜೆವಾನ್ ಖಾಯಿಲ್ ತ್ಯೊ ಬರಾ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","ಯೇಸು ತ್ಯಲಾ ಮನ್ಲಾ, “ಯಕಾ ಮಾನ್ಸಾನಿ ಜೆವಾನ್ ಕೆಲ ತವಾ ಖುಬ್ ಲೊಕಾನಾ ಹಾಕಟ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","ಆನಿ ಜೆವ್ನಾಚಾ ಯಳಾಲಾ ಆತಾ ಯವಾ ಜೆವಾನ್ ತಯಾರ್ ಜಾ಼ಲ್ಯಾ ಆಸ ಆಂದಿ ಹಾಕಟ್‍ಲ್ಯಾಲ್ಯಾನಾ ಸಾಂಗಾಯಾ ತ್ಯನಿ ಆಪ್‌ಲ್ಯಾ ಯಕಾ ಆಳಾಲಾ ಲಾವುನ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","ತವಾ ತೆ ಸಗ್ಳ ಶಾರ್ಕ ಎಕುಸ್ ತರನಿ ಸಾಂಗಾಯಾ ಲಾಗ್ಲ ಆಂದಿಚಾನಿ, “ಮಿ ಶಾತ್ ಇಕತ್ ಗೆತಲ್ಯಾ ತ್ಯ ಮಿ ಜಾ಼ವುನ್ ಬಗಾ ವ್ಹಯಿ ಮನಾ ಮಾಪ್ ಕರಾ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","ದಿಸ್ರಾ ಮನ್ಲಾ, “ಬೈಲಾಂಚಾ ಪಾಚ಼್ ಜೊ಼ಡ್ಯಾ ಇಕತ್ ಗೆತಲ್ಯಾತಾ ತ್ಯಾ ತಪಾಸಾಲಾ ಮಿ ಜಾ಼ತ್ಯೊ ಮನಾ ಮಾಪ್ ಕರಾ ಆಸಿ ಮಿ ವಿನಂತಿ ಕರ್ತೊ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","ಆನಿ ಯೊಕ್ ಮನ್ಲಾ, “ಮಿ ಲಗಿನ್ ಜಾ಼ಲ್ಯೊ ಮನ್ಹುನ್ ಮನಾ ಯಯಾ ವ್ಹಯಿತ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","ಮಂಗ್ ತ್ಯಾ ಆಳಾನಿ ಯವುನ್ ಆಪ್‌ಲ್ಯಾ ದನ್ಯಾಲಾ ಹ್ಯಾ ಹಾಕಿಗತಿ ಸಾಂಗ್‌ಲ್ಯಾ ತವಾ ತ್ಯಲಾರಾಗ್ ಆಲಾ ಆನಿ ತ್ಯೊ ಆಪ್‌ಲ್ಯಾ ಆಳಾಲಾ ಮನ್ಲಾ, “ಗಾವಾಚೆ ಪಾಂದಿವ್ನಿ ಸಾಂದಿತ್ನಿ ಜಾ಼ ಆನಿ ಗರಿಬ್ ಲಂಗಡಿ ಆಂದ್ಳಿ ಹ್ಯನಾ ಹಿಥ ಗಿಹುನ್ ಯೇ. ” ");
INSERT INTO gok_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","ಆಳ್ ಮನ್ಲಾ, “ದನ್ಯಾ ತುಮಿ ಸಾಂಗ್‍ಲ್ಯಾ ಶಾರ್ಕ ಜಾ಼ಲ್ಯಾ ಫನ್ ಆಜು಼ನ್ ಜೆವಾನ ಖಾಯಾ ಖುಬ್ ಜಾ಼ಗಾ ಹಾ. ” ");
INSERT INTO gok_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","ದನ್ಹಿ ಆಳಾಲಾ ಮನ್ಲಾ, “ಮಾಜ಼ ಘರ್ ಬರ್ಹಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ತು ವಾಟವ್ನಿ ಆನಿ ಸೇತಾತ್ನಿ ರೊಡಾಕ್ನಿ ಜಾ಼ವುನ್ ಲೊಕಾನಾ ಖಟ್ಪಟ್ ಕರುನ್ ಗಿಹುನ್ ಯೇ; ");
INSERT INTO gok_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","ಕಾ ಮಂಜೆ ಮಿ ತುಮಾನಾ ಸಾಂಗ್ತೊ, ಆಂದಿ ಸಾಂಗ್‍ಲ್ಯಾಲ್ಯಾ ಮಾನ್ಸಾತ್‍ಲ್ಯಾ ಯಕಾಲಾ ಬಿ ಮಾಜಾ ಜೆವ್ನಾತ್ಲ ಕಾಯ್ ಚ಼ವ್ ಬಗಾಯಾ ಮಿಳ್ನಾರ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","ಯಕಸಿ ಯೇಸು ಸಂಗ ಖುಬ್ ಲೊಕ ಜಾ಼ಯಿತ್ ಹುತ್ತಿತ ತವಾ ಯೇಸು ತ್ಯಂಚಿಕ್ಡ ಗುಳ್ಹುನ್ ಮನ್ಲಾ, ");
INSERT INTO gok_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“ಕೊನ್ ತರಿ ಮಾಜೆ ಮಾಗ್ನಿ ಯವುನ್ ಮಾಜೆ ಪಕ್ಶಿ ಆಪ್ಲಿ ಆಯಿ ಬಾ ಬ್ಯಾಯ್ಕೊ ಪೊರ ಬಾಹು ಭನ್ಹಿ ಹ್ಯನಾ ಆನಿ ಆಪ್ಲಾ ಜೀವ್ ಸಾಹಿತ್ ಇಸ್ರನಸ್ನಾರಾ ಮಾಜಾ಼ ಶಿಶಾ ವ್ಹಯಿತ್ ನಾಹಿ. ” ");
INSERT INTO gok_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","ಕೊನ್ ಆಪ್ಲಿ ಶಿಲ್ಬೆ ಆಪ್ನು ಗಿಹುನ್ ಮಾಜೆ ಮಾಗ್ನಿ ಯಯಿತ್ ನಾಹಿ ತ್ಯಲಾ ಮಾಜಾ಼ ಶಿಶಾ ವ್ಹಯಾ ವ್ಹಯಿತ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","ತುಮ್ಚಾತ್ ಕೊನ್ ಆಸಾ ಹಾ ಕ್ಯಾ ತ್ಯಲಾ ಘರ್ ಬಾಂದಾಚ಼ ಇಚಾ ಹಾ ತ ತ್ಯೊ ಆಂದಿ ಬಸುನ್ ಖರ್ಚಾಚಾ಼ ಆಂದಾಜ಼್ ಗಾಲ್ಹುನ್ ಆಪ್ಲಿಪ ತ್ಯ ಪುರಾ ಕರಾಯಾ ವ್ಹಯಿ ಯವ್ಡ ಪೈಸ ಹಾತ ಕ್ಯಾ ನಾಹಿ ಹ್ಯ ಬಗಿತ್ ನಾಹಿ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","ನಾಹಿತ ತಸಾಸ್ ಬಾಂದಾಯಾ ಲಾಗಲ್ತ ಪಾಯಾ ಗ್ಯಾತ್‍ಲ್ಯಾವ ತ್ಯಲಾ ಜ಼ರ್ ತ್ಯ ಪುರಾ ಕರಾ ಜಾ಼ಲ ನಾಹಿ ಮಂಜೆ ಬಗ್ನಾರಿ ಸಗ್ಳಿ ಲೊಕ ತ್ಯಲಾ ಹಾಸ್ತಿಲ. ");
INSERT INTO gok_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","ಹ್ಯೊ ಮಾನುಸ್ ಬಾಂದಾಯಾ ಲಾಗ್ಲಾ ಖರ ಕಾಮ್ ಪುರ ಕರಾಜಾ಼ಲ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","ನಾಹಿತ ಯೊಕ್ ರಾಜಾ಼ ದುಸರ‍್ಯಾ ರಾಜಾ ಸಂಗ ಲಡಾಯಿ ಖೆಳಾಯಾ ಜಾ಼ಯಾಚೆ ಆಂದಿ ಬಸೂನ್ ಇಚಾರ್ ಕರೀತ್ ನಾಹಿ ಕ್ಯಾ? ತ್ಯೊ ಈಸ್ ಹಾಜಾ಼ರ್ ಸೈನ್ಯಾ ಗಿಹುನ್ ಮಾಜಿ಼ವ ಯತೊ ತ್ಯಚಿವ ಮಿ ಧಾ ಹಾಜಾ಼ರ್ ಸೈನ್ಯಾ ಗಿಹುನ್ ಜಾ಼ಯಾ ಯಯಿಲ್ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","ಜಾ಼ಯಾ ಯಯಿತ್ ನಾಹಿ ತವಾ ತ್ಯೊ ದುರ್ ಆಸ್ಥಾನಾಸ್ ಹ್ಯೊ ವಕಿಲ್ ಲಾವುನ್ ದಿವುನ್ ಯಕ್ಕಿ ವ್ಹಯಾಚ಼ ಬೊಲ್ನ ಸುರು ಕರಿಲ್. ");
INSERT INTO gok_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","ತಸಸ್ ಯೇಸುನಿ ತ್ಯನಾ ಆಸ ಸಾಂಗುನ್ ಸಪಿವ್ಲ ತುಮ್ಚಾತ್ ಕೊನ್ ಆಪ್‌ಲ್ಯಾ ಸರ್ವ್ಯಾಚಾ಼ ಇಚಾರ್ ಕರೀತ್ ನಾಹಿ ತ್ಯಲಾ ಮಾಜಾ಼ ಶಿಶಾ ವ್ಹಯಾ ಯಯಿತ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","ಮಿಟ್ ಚಾ಼ಂಗ್ಲ ಜಿನೊಸ್ ಫನ್ ಮಿಟಾಚಿ ಚ಼ವ್ ಗಿಲಿತ ತ್ಯಲಾ ಆನಿ ಕಶಾನಿ ಚ಼ವ್ ಆನಾಯಾ ವ್ಹಯಿಲ್? ");
INSERT INTO gok_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","ತ್ಯ ಮಾತಿತ್ ನಾಹಿತ ಉಕಿರಡ್ಯಾತ್ ಟಾಕಾಯಾ ಉಪೆಗ್ ನಾಹಿ; ತ್ಯ ಬಾಹಿರ್ ಟಾಕುನ್ ದೆತ್ಯಾತ ಕಚಾಲಾ ಐಕಾಯಾ ಕಾನ್ ಹಾತ್ತ ತ್ಯೊ ಐಕುನಿ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","ಯಕಸಿ ಸಗ್ಳ ಜ಼ಖತ್ದಾರ್ ಆನಿ ಪಾಪಿ ತ್ಯಚಿ ಬೂಲಿ ಐಕಾಯಾ ತ್ಯಚಿಪ ಆಲ್ತಿತ. ");
INSERT INTO gok_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","ತವಾ ಫರಿಸಾಯ್ ಆನಿ ಕ್ಯಾಯ್ದ ಸಾಂಗ್‌ತ್ಯಾಲ, “ಹ್ಯೊ ಪಾಪಿನಾ ಜ಼ವಳ್ ಹಾಕ್ಟುನ್ ತ್ಯಂಚೆ ಸಂಗ ಖಾತೊ” ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","ಮಂಗ್ ಯೇಸುನಿ ತ್ಯನಾ ಯೇಕ್ ಕ್ಯಾಯ್ನಿ ಸಾಂಗ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","ತ್ಯ ಕ್ಯಾ ಮಂಜೆ ತುಮ್ಚಾತ್ ಕಚಾ಼ತರಿ ಮಾನುಸ್ ಆಪ್‌ಲ್ಯಾಲಾ ಶೆಂಬರ್ ಮೆಂಡ್ರ ಆಸ್ಥಾನಾ ತ್ಯಾತ್ಲ ಯಾಕ್ ಚು಼ಕುನ್ ಗೆಲಕಿ ತ್ಯೊ ನವದಾವ ನವು ಮೆಂಡ್ರ ರಾನಾತ್ ಸುಡುನ್ ಚು಼ಕುನ್ ಗೆಲ್ಯಾಲ ಗಾವ್ಹಸ್ ಪರ‍್ಯಾತ್ ತ್ಯಲಾ ಸುದಿತ್ ಜಾ಼ಯಾಚೆ ಆಂದಿ ರಾಥೊ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","ಗಾವ್ಲಕಿ ತ್ಯೊ ಆನಂದ್ ಜಾ಼ಲಾ ಆನಿ ತ್ಯಲಾ ಆಪ್‌ಲ್ಯಾ ಖಾಂದ್ಯಾವ ಗಿಹುನ್ ");
INSERT INTO gok_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ಗರ‍್ಹಾತ್ ಯವುನ್ ಸೊಪ್‌ತ್ಯಾನಾ ಆಜು಼ಬಾಜು಼ಚಾನಾ ಜ಼ಮುವುನ್, “ಚು಼ಕುನ್ ಗೆಲ್ಯಾಲ ಮೆಂಡಾರ್ ಗಾವ್ಲ ಮಾಜಿ ಸಂಗ ಆನಂದ್ ವ್ಹವಾ” ಮನ್ಹುನ್ ತ್ಯನಾ ಸಾಂಗ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","ತಸಸ್ ದೇವಾಕ್ಡ ಚು಼ಕ್ ವಪುನ್ ಪರ್ತಾಯಾ ಗರಜ಼್ ನಸನಾರ‍್ಯಾ ನವದಾವ ನವು ಜ಼ನ ನಿಯತಿಂಚಿಗತ್ ದೇವಾಕ್ಡ ಚು಼ಕ್ ವಪುನ್ ಪರಾತ್ಯಾಲ್ಯಾ ಯಕಾ ಪಾಪಿಚೆ ಗುಶ್ಟಿತ್ ಪರಲೊಕಾತ್ ಆನಂದ್ ವ್ಹಯಿಲ್ ಮನ್ಹುನ್ ಮಿ ತುಮಾನಾ ಸಾಂಗ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","ಯೆಕ್ ಬಾಯಿಲ್ ಮಾನುಸ್ ಆಪ್ಲಿಪ ಧಾ ಚಾ಼ಂದಿಚಾ ಪಾವಲ್ಯಾ ರಾಹುನ್ ಯೇಕ್ ಪಾವಲಿ ಸಾಂಡ್ಲಿಕಿ ದಿವಾ ಲಾವುನ್ ಘರ್ ಲುಟುನ್ ಗಾವ್ಹಸ್ ಪರ‍್ಯಾತ್ ತ್ಯ ಜಾ಼ಗೃತಿನಿ ಸೊದಾಚೆ ಆಂದಿ ರಾಹಿಲ್ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","ತಿಲಾ ತೀ ಪಾವ್ಲಿ ಗಾವಲ್ಯಾ ನಂತರ್ ತಿ ಆಪ್‌ಲ್ಯಾ ಸುಪ್ತಿನಿನಾ ಸೆಜಾ಼ರ‍್ನಿನಾ ಗೊಳಾಕರುನ್ ಸಾಂಡ್‍ಲ್ಯಾಲಿ ಪಾವ್ಲಿ ಗಾವ್ಲಿ ಮಾಜಿ ಸಂಗ ಆನಂದ್ ಕರಾ ಮನ್ಹುನ್ ಸಾಂಗಿಲ್ ನವ್ಹ. ");
INSERT INTO gok_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","ತಸಸ್ ಯೊಕ್ ಪಾಪಿ ದೇವಾಕ್ಡ ಚು಼ಕ್ ವಪುನ್ ಪರಾತ್ಯಾಲೆ ಗುಶ್ಟಿತ್ ದೇವ್ ಧುತಾಂಚೆ ಮೊರ‍್ಹ ಆನಂದ್ ವ್ಹಯಿಲ್ ಮನ್ಹುನ್ ತುಮಾನಾ ಸಾಂಗ್ತೊ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","ಆನಿ ಯೇಸುನಿ ಆನಿ ಕ್ಯಾ ಸಾಂಗ್ಲ ಮಂಜೆ, “ಯಕಾ ಮಾನ್ಸಾಲಾ ದೊಗ ಲ್ಯಾಕ್ ಹುತ್ತ ");
INSERT INTO gok_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","ತ್ಯಾತ್ಲಾ ದಾಕ್ಟಾ ಲ್ಯೊಕ್ ಬಾಲಾ, “ಬಾ ಆಸ್ಥಿತ್ ಮಾಜಿ ಯಯಾಚಿ ವಾಟ್ನಿ ದೇ” ಮನ್ಲಾ ತವಾ ಬಾನಿ, ಆಸ್ಥಿ ವಾಟುನ್ ದಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","ಥೊಡ ದೀಸ್ ಜಾ಼ಲ ತವಾ ದಾಕ್ಟಾ ಲ್ಯೊಕ್ ಆಪ್ಲೆ ವಾಟ್ನಿಚಿ ಸಗ್ಳಿ ಆಸ್ಥಿ ಇಕುನ್ ಪೈಸ ಗಿಹುನ್ ದುರ್ಚೆ ದೇಶೆತ್ ಗೆಲಾ ಆನಿ ತಿಥ ಫಟಿಂಗ್ ವ್ಹವುನ್ ಆಪ್ಲ ಪೈಸ ಸಗ್ಳ ಉದಳ್ಳ. ");
INSERT INTO gok_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","ತ್ಯನಿ ಆಪ್ಲ ಸಗ್ಳ ಉದಳ್ಯಾ ನಂತರ್ ತೇ ದೇಶೆತ್ ಮೊಟ ಬರ್ಗಾಲ್ ಪಡ್ಲ ತವಾ ತ್ಯಲಾ ಗತಿ ನಾಹಿ ಜಾ಼ಲಿ. ");
INSERT INTO gok_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","ಮಂಗ್ ತ್ಯೊ ತೇ ದೇಶೆತ್‍ಲ್ಯಾ ಯಕಾಪ ಜಾ಼ವುನ್ ತ್ಯಲಾ ಲಾಗುನ್ ರಾಯ್‍ಲ್ಹಾ, ತ್ಯನಿ ತ್ಯಲಾ ಆಪ್‌ಲ್ಯಾ ಸೇತಾತ್ ಡುಕ್ರ ಚಾ಼ರಾಯಾ ಲಾವುನ್ ದಿಲಾ ");
INSERT INTO gok_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","ತವಾ ಡುಕ್ರ ಗಡ್ಡ ಖಾಯಿತ್ ಆಸ್ಥಾನಾ ತ್ಯಾತ್ಲ ಗಡ್ಡ ತರಿ ಖಾವುನ್ ಪ್ವಾಟ್ ಬರುಯಾ ಆಸ ತ್ಯಲಾ ಖುಬ್ ಮನ್ ವ್ಹಯಿ; ತ್ಯಲಾ ಕೊನ್ ಕಾಯ್ ದಿಯಿತ್ ನವ್ತ. ");
INSERT INTO gok_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","ನಂತರ್ ತ್ಯಲಾ ಚು಼ಕಿಚಿ ಅಕ್ಕಲ್ ಯವುನ್ ತ್ಯೊ, “ಮಾಜಾ ಬಾಪ ಖುಬ್ ಜಾ಼ನ್ ಕುಲ್‍ಕರ‍್ಯಾ ಲೊಕಾನಾ ವ್ಹಯಿ ತ್ಯವ್ಡ ಆನ್ ಹಾ; ಮಿ ತರಿ ಹಿತ್ತ ಬುಖನಿ ಮರ್ತ್ಯೊ ");
INSERT INTO gok_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","ಹಿತ್ನಿ ನಿಗುನ್ ಮಾಜಾ ಬಾಪ ಜಾ಼ತೊ ಆನಿ ತ್ಯಲಾ, “ಬಾ ಮಿ ದೇವಾಚೆ ಆನಿ ತುಜೆ ಮೊರ‍್ಹ ಚು಼ಕ್ ಕಿಲಿ” ಆನಿ ತುಜಾ಼ ಲ್ಯೊಕ್ ಮನ್ಹುನ್ ಗಿಹ್ಯಾ ಯೊಗ್ಯ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","“ಮನಾ ತುಜಾ ಕುಲ್ಕರ‍್ಯಾತಲ್ಯಾ ಯಕಾಚೆಗತ್ ಕರ್” ಮನ್ಹುನ್ ಸಾಂಗ್ತೊ ಆಸ ಯವುಜು಼ನ್ ನಿಗುನ್ ಆಪ್‌ಲ್ಯಾ ಬಾಪ ಆಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","ತ್ಯೊ ಆಜು಼ನ್ ದುರ್ ಆಸ್ಥಾನಾಸ್ ತ್ಯಚಾ ಬಾನಿ ತ್ಯಲಾ ಬಗುನ್ ಕನಿಕಾರಾನಿ ಪಳತ್ ಯವುನ್ ತ್ಯಚಾ ಗಳ್ಯಾತ್ ಯಾಂಗ್ ಗಾಲ್ಹುನ್ ತ್ಯಲಾ ಖುಬ್ ಮುಖ ದಿಲ. ");
INSERT INTO gok_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","ಫನ್ ಲ್ಯೊಕ್ ತ್ಯಲಾ, “ಬಾ ದೇವಾಚೆ ಆನಿ ತುಜೆ ಮೊರ‍್ಹ ಚು಼ಕ್ ಕಿಲಿ. ಆತಾ ಮಿ ತುಜಾ಼ ಲ್ಯೊಕ್ ಮನ್ಹುನ್ ಗಿಹ್ಯಾ ಚಾ಼ಂಗ್ಲ ನಾಹಿ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","ತವಾಸ್ ಬಾನಿ ಆಪ್‌ಲ್ಯಾ ಆಳಾನಾ ಹಾಕ್ಟುನ್ ಚಾ಼ಂಗ್ಲ “ಜ಼ಘಾ ಆನುನ್ ಹ್ಯಲಾ ಗಾಲ್ಹಾ ಹ್ಯಚಾ ಹಾತಾತ್ ಆಂಗ್ಟಿ ಆನಿ ಪಾಯಾತ್ ವ್ಹಾನಾ ಗಾಲ್ಹಾ. ");
INSERT INTO gok_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","ಆನಿ ಮಾತ್‍ಲ್ಯಾಲ ಮಿಂಡುರ್ ಆನುನ್ ಕಾಪಾ ಆಮಿ ಆನಂದಾನಿ ಜೆವಾನ್ ಕರುಯಾ ");
INSERT INTO gok_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","ಕಾ ಮಂಜೆ ಹ್ಯೊ ಮಾಜಾ಼ ಲ್ಯೊಕ್ ಮೆಲಾ ಹುತ್ತಾ, ತ್ಯೊ ಆನಿಕ್ ಜಿತ್ತಾ ಜಾ಼ಲ್ಯಾ; ಚು಼ಕ್ಲಾ ಹುತ್ತಾ ತ್ಯೊ ಗಾವಲ್ಯಾ” ಮನ್ಲಾ. ತವಾ ತೆ ಮಜೆನಿ ಜೆವಾನ್ ಕರಾಯಾ ಲಾಗ್ಲ ");
INSERT INTO gok_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","ಫನ್ ತ್ಯಚಾ಼ ಥೊರ‍್ಲಾ ಲ್ಯೊಕ್ ಸೆತಾತ್ ಹುತ್ತಾ, ತ್ಯೊ ಗರ‍್ಹಾಚೆ ಜ಼ವಳ್ ಜ಼ವಳ್ ಯತಾನಾ ವಾಜಾ಼ಪ್ ನಾಚ಼್ನ ಗಾನ ಐಕ್ಲ ");
INSERT INTO gok_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","ಆನಿ ಆಳಾತ್‍ಲ್ಯಾ ಯಕಾಲಾ ಆಪ್ಲಿಪ ಹಾಕ್ಟುನ್, “ಹ್ಯ ಕ್ಯಾ” ಮನ್ಹು‍ನ್ ಇಚಾರ್ಲ ");
INSERT INTO gok_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","ಆಳಾನಿ ತ್ಯಲಾ, “ತುಜಾ಼ ಬಾಹು ಮಾಗಾರಾ ಆಲ್ಯಾ ಮನ್ಹುನ್ ತುಜಾ ಬಾನಿ ತ್ಯ ಮಾತ್‍ಲ್ಯಾಲ ಮಿಂಡುರ್ ಕ್ಯಾಪ್‍ಲ್ಯಾ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","ಹ್ಯ ಐಕುನ್ ತ್ಯಲಾ ರಾಗ್ ಯವುನ್ ಆತ್ ಜಾ಼ಯಿನಾ, ತವಾ ತ್ಯಚಾ ಬಾನಿ ಬಾಹಿರ್ ಯವುನ್ ತ್ಯಲಾ ಆತ್ ಯೆ ಮನ್ಹುನ್ ಇನಂತಿ ಕಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","ಫನ್ ತ್ಯೊ ಆಪ್‌ಲ್ಯಾ ಬಾಲಾ, “ಬಗ್ ಯವ್ಡಿ ವರ್ಸ ಮಿ ತುಜಿ಼ ಚಾ಼ಕ್ರಿ ಕಿಲಿ ಆನಿ ಮಿ ತುಜಾ಼ ಯೊಕ್ ಸಬೋತ್ ವಲ್ಯಾಂಡ್ಲಾ ನಾಹಿ; ತರಿಬಿ ಮಿ ಮಾಜಾ ಸೊಪ್‌ತ್ಯಾಂಚೆ ಸಂಗ ಮಾಜಾ ಕರಾಯಾ ತು ಕಂದಿಸ್ ಮನಾ ಯಾಕ್ ಬಕ್ರ ಸಾಹಿತ್ ದಿಲ ನಾಹಿಸ್. ");
INSERT INTO gok_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","ಫನ್ ತ್ಯನಿ ಸುಳ್ಯಾನಾ ಗಿಹುನ್ ತುಜಿ ಆಸ್ಥಿ ಆನಿ ಪೈಸ ಹಾಳ್ ಕೆಲ್ಯಾಲಾ ತುಜಾ಼ ಲ್ಯೊಕ್ ಆಲಾ ತವಾ ಮಾತ್‍ಲ್ಯಾಲ ಮಿಂಡುರ್ ತ್ಯಲಾ ಕ್ಯಾಪ್‍ಲ್ಯಾಸ್” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","ತವಾ ಬಾ ಮನ್ಲಾ, “ಲೇಕಾ ತು ಖಾಯಿಮ್ ಮಾಜಿ ಸಂಗ ಹಾಸ್ ಆನಿ ಮಾಜ಼ ಸಗ್ಳ ತುಜ಼ಸ್ ");
INSERT INTO gok_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","ಫನ್ ಮಜಾ ಕರಾಚಿ ಬರ ಹಾ. ಕಾ ಮಂಜೆ ಹ್ಯೊ ತುಜಾ಼ ಬಾಹು ಮೆಲ್ಯಾಚೆಗತ್ ಜಾ಼ಲ್ಥಾ ಪರ್ತುನ್ ಜಿತ್ತಾ ವ್ಹವುನ್ ಆಲಾ; ಚು಼ಕುನ್ ಗೆಲ್ತಾ ಗಾವ್ಲಾ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","ಯೇಸುನಿ ಆಪ್‌ಲ್ಯಾ ಶಿಶಾನಾ ಕ್ಯಾ ಸಾಂಗ್ಲ ಮಂಜೆ ಯಕಾ ಸಾವ್ಕಾರಾಲಾ ಯೊಕ್ ಘರ್ ಚಾ಼ಕೊರ್ ಹುತ್ತಾ. ಹ್ಯಚಿ ಖಬರ್‍ ಧನ್ಯಾಪ, “ಹ್ಯೊ ತುಜಿ ಆಸ್ಥಿ ಹಾಳ್ ಕರ್ತ್ಯೊ” ಮನ್ಹು‍ನ್ ಕಚಾನಿ ಚಾ಼ಡಿ ಸಾಂಗ್ಲಿ ");
INSERT INTO gok_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","ತವಾ ದನ್‍ಹ್ಯಾನಿ ತ್ಯಲಾ ಹಾಕ್ಟುನ್ ಹ್ಯ‍ ಕ್ಯಾ ಮಿ ತಿಜಿ಼ ಖಬರ್ ಐಕಾಚಿ? ತು ಗರ‍್ಹಾಚಾ ಲೆಖಾ ಸಾಂಗ್; ತು ಆಚ್ಚಾನ್ ಗರ‍್ಹಾಚಾ಼ ಚಾ಼ಕೊರ್ ವ್ಹವುನ್ ರಾಹ್ಯಾ ವ್ಹಯಿತ್ ನಾಹಿ” ಮನ್ಹು‍ನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","ತವಾ ತ್ಯಾ ಚಾ಼ಕ್ರಾನಿ, “ಮಿ ಕ್ಯಾ ಕರು? ಮಾಜಾ಼ ದನ್ಹಿ ಮಾಜಿಪ್ನಿ ಹ್ಯ ಕಾಮ್ ಕಾಡುನ್ ಗೆಥ್ಯೊ ನವ್ಹ ಖಾಂದಾಯಾ ಮನಾ ಬಳ್ ನಾಹಿ; ಭೀಕ್ ಮಾಗಾಯಾ ಮನಾ ಲಾಜ಼್ ವಾಟ್ಟಿ. ");
INSERT INTO gok_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","ಹ್ಯಾ ಕಾಮಾವ್ನಿ ಮನಾ ಕ್ಯಾಡ್ಲಕಿ ಲೊಕಾಂಚಾನಿ ಮನಾ ಆಪ್‌ಲ್ಯಾ ಗರ‍್ಹಾತ್ನಿ ಗಿಹ್ಯಾಸಾಟಿ ಮಿ ಕ್ಯಾ ಕರಾ ವ್ಹಯಿ” ತ್ಯ ಸಮಾಜ಼್ಲ ಮನ್ಹುನ್ ಯವುಜು಼ನ್ ");
INSERT INTO gok_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","ಆಪ್‌ಲ್ಯಾ ದನ್ಯಾಚಾ ರಿನ್ಕರ‍್ಯಾತ್‍ಲ್ಯಾ ಪರ್ತೆಕಾಲಾ ಹಾಕ್ಟುನ್ ಪೈಲ್ಯಾಲಾ, “ತು ಮಾಜಾ ದನ್ಯಾಲಾ ಕ್ಯಾ ದಿಯಾಚ಼ ಹಾ” ಮನ್ಹುನ್ ಇಚಾರ್ಲ ");
INSERT INTO gok_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","ತವಾ ತ್ಯನಿ, “ಸೆಂಬರ್ ಡಬ್ಬ ತ್ಯಾಲ್” ಮನ್ಲಾ ತವಾ ತ್ಯೊ ತ್ಯಲಾ ಹ್ಯ ತುಜ಼ ಪತ್ರ ಗಿಹುನ್ ಬಿಗಿನಿ ಪನ್ನಾಸ್ ಡಬ್ಬ ಲಿವ್” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","ಮಂಗ್ ಆನಿ ಯಕಾಲಾ ತು ಕ್ಯಾ ದಿಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಇಚಾರ್ಲ ತವಾ ತ್ಯೊ, “ಹಜಾ಼ರ್ ಚಿಲ ಘಹು” ಮನ್ಲಾ ತವಾ ತ್ಯಲಾ, “ಹ್ಯ ತುಜ಼ ಪತ್ರ ಗಿಹುನ್ ಆಟ್ಸೆ ಚಿಲ ಲಿವ್” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","ದನ್ಯಾನಿ ಹ್ಯ ಐಕುನ್ ಚು಼ಕ್ ಕೆಲ್ಯಾಲ್ಯಾ ತ್ಯಾ ಚಾ಼ಕ್ರಾಲಾ, ‘ಹ್ಯನಿ ಶಾನ್ಫನ್ಕೆಲ ಮನ್ಹುನ್ ತ್ಯಲಾ ವವ್ಯಾಳಾ ಕಾ ಮಂಜೆ ಹೆ ದುನೆತ್ಲಿ ಬುರ್ಸಿ ಲೊಕ ಆಪ್ಲಿ ಕಾಮ ಕರಾಯಾ ದೇವಾಚಾ ರಾಜಾತ್‌ಲ್ಯಾ ಲೊಕಾವ್ನಿ ಶಾನಿ ಹಾತ್ತ. ");
INSERT INTO gok_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","ಮಿ ತುಮಾನಾ ಸಾಂಗ್ತೊ ತುಮಾನಾ ಹ್ಯಾ ಲೊಕಾತ್ಲೆ ಆಸ್ಥಿತ್ನಿ ಅನ್ಯಾಯ್ ಕರ್ತ್ಯಾಲ ಸುಪ್ತಿ ಜೊ಼ಡಾ ಹಿ ಆಸ್ಥಿ ಸಪ್ಲಿಕಿ ತುಮಾನಾ ಶಾಶ್ವತಾಚಾ ಗರ‍್ಹಾತ್ ಹಾಕಟ್ತಿಲ. ");
INSERT INTO gok_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","ಥೊಡ್ಯಾವ ಇಸ್ವಾಸಿ ಜಾ಼ಲ್ಯಾಲಾ ಮೊಟ್ಯಾವ ಬಿ ಇಸ್ವಾಸಿ ವ್ಹನಾರ್; ಥೊಡ್ಯಾವ ಖೊಟಾ ಜಾ಼ಲ್ಯಾಲಾ ಮೊಟ್ಯಾತ್ ಬಿ ಖೊಟಾ ವ್ಹನಾರ್. ");
INSERT INTO gok_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","ಆಸ ಆಸ್ಥಾನಾ ಪ್ರಪಂಚಾತ್‌ಲ್ಯಾ ಆಸ್ಥಿ ಗುಶ್ಟಿತ್ ತುಮಿ ಖರ‍್ಯಾನಿ ಇಸ್ವಾಸ್ ನಸ್ನಾರ ಜಾ಼ಲ್ಯಾವ ಸ್ವರ್ಗಾಚಿ ಆಸ್ಥಿ ತುಮ್ಚಾ ತಾಬ್ಯಾತ್ ಕೊನ್ ದೇನಾರ್? ");
INSERT INTO gok_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","ಆನಿ ಯಕಾಚೆ ಆಸ್ಥಿಚೆ ಗುಶ್ಟಿತ್ ತುಮಿ ಇಸ್ವಾಸಿ ನವ್ಹ ಜಾ಼ಲ್ಯಾವ ತುಜಿ ಆಸ್ಥಿ ತುಮಾನಾ ಕೊನ್ ದೇನಾರ್? ");
INSERT INTO gok_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","ಕಚಾ಼ಸ್ ಆಳ್ ದೊಗಾ ದನ್ಯಾಂಚಿ ಚಾ಼ಕ್ರಿ ಕರೀತ್ ನಾಹಿ; ತ್ಯೊ ಯಕಾಚಾ಼ ರಾಗ್ ಕರುನ್ ಆನಿ ಯಕಾಚಿ ಮಾಯಾ ಕರಿಲ್, ನಾಹಿತ ಯಕಾ ಸಂಗ ರಾಹುನ್ ಆನಿ ಯಕಾಲಾ ಸುಡುನ್ ದಿಯಿಲ್, ತುಮಿ ದೇವಾಲಾಬಿ ಆನಿ ಪೈಶಾನಾಬಿ ಸಂಗ ಅನುಭವಸಾಯಾ ವ್ಹಯಿತ್ ನಾಹಿ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","ಫರಿಸಾಯಾಂಚಾನಿ ಹೆ ಸಗ್ಳ ಸಬಾತ್ ಐಕುನ್ ಆಪ್ನು ಪೈಶಾಚೆ ಆಸೆಚ಼ ಹುತ್ತ ಮನ್ಹುನ್ ಯೇಸುಲಾ ಹಾಸಾಯಾಲಾಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","ತವಾ ಯೇಸುನಿ ತ್ಯನಾ ಕ್ಯಾ ಸಾಂಗ್ಲ ಮಂಜೆ, “ಮಾನ್ಸಾಂಚೆ ಮೊರ‍್ಹ ಆಪ್ನು ಚಾ಼ಂಗ್ಲ ಮನ್ಹುನ್ ದಾವುನ್ ದೆತ್ಯಾಲ ತುಮಿ ಖರ ದೇವಾನಿ ತುಮಚ಼ ಮನ್ ಸಮಜು಼ನ್ ಗೆತಲ್ಯಾ ಲೊಕಾಂಚೆ ನದ್ರಲಾ ಚಾ಼ಂಗ್ಲ ಜಾ಼ಲ್ಯಾಲ ದೇವಾಚೆ ನದ್ರತ್ ಬಾದ್ ಜಾ಼ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","ಮೊಶೆಚ಼ ದರ್ಮ ಶಾಸ್ತಾರ್ ಆನಿ ಪ್ರವಾದಿ ಬಾಪ್ತಿಸ್ಮಾ ಯೊಹಾನಾ ಪರ‍್ಯಾತುಸ್ ಹ್ಯಾಂಗ್ನಿ ದೇವಾಚಾ ರಾಜಾಚಿ ಬರಿ ಖಬರ್ ಉಗ್ಡುನ್ ದೆ ತ್ಯೊ ತ್ಯಾತ್ ಸಗ್ಳಿ ಲೊಕ ಜಾ಼ಯಾ ಯತ್ನ ಕರ್ತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","ಆಬಾಳ್ ದರ್ಥಿ ಪುಸುನ್ ಜಾ಼ಯಿಲ್ ಫನ್ ದರ್ಮ ಶಾಸ್ತಾರಾತ್ಲಾ ಯೊಕ್ ಸಬೋತ್ ಸಾಹಿತ್ ಪುಸುನ್ ಜಾ಼ನಾರ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","ಆಪ್ಲಿ ಬ್ಯಾಯ್ಕೊ ಸುಡುನ್ ದುಸ್ರಿಲಾ ಲಗಿನ್ ಕರುನ್ ಗೆಥ್ಯಾಲಾ ಪರ್ತೇಕ್ ಯೊಕ್ ರಾಂಡ್ ಸಂಗತ್ ಕರ್ತ್ಯಾಲಾ ಜಾ಼ಲ್ಯಾ; ಆನಿ ಘೊ ಶೊಡ್‍ಲ್ಯಾಲಿಲಾ ಲಗಿನ್ ಕರುನ್ ಗೆನಾರಾ ರಾಂಡ್ ಸಂಗತ್ ಕರ್ತ್ಯಾಲಾ ಜಾ಼ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","ಯೊಕ್ ಸಾವ್ಕೊರ್ ಮಾನುಸ್ ಹುತ್ತಾ ತ್ಯೊ ಸಗ್‍ಳ್ಯಾಂಚಿವ್ನಿ ಚಾ಼ಂಗ್ಲ ಕಿಮ್ತಿಚ಼ ಆಸ್‍ಲ್ಯಾಲ ಕಪಡ ಗಾಲುನ್ ಖಾಯಿಮ್ ಶಾದ್ರಾ ವ್ಹವುನ್ ಆರಾಮ್ ರಾಹಿತಾ. ");
INSERT INTO gok_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","ತ್ಯಚಾ ಗರ‍್ಹಾಚಾ ದಾರಾ ಮೊರ‍್ಹ ಲಾಜ಼ರ್ ಮಂಥ್ಯಾಲಾ ಯೊಕ್ ಬಿಖಾರಿ ಮಾನುಸ್ ತ್ಯಚಾ ಬಾಹಿರ್‌ಲ್ಯಾ ದಾರಾವ ಪಡುನ್ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ಹ್ಯೊ ಆಂಗ್ ಬರ‍್ಹುನ್ ಖಾಂಡ್ಕ ಜಾ಼ಲ್ಯಾಲಾ; ಸಾವ್ಕಾರಾನಿ ಖಾವುನ್ ಟ್ಯಾಕ್‌ಲ್ಯಾಲ ಉಸ್ಟ ಖಾವುನ್ ಪ್ವಾಟ್ ಬರಾವ ಮನ್ಹುನ್ ಹುತ್ತಾ; ಆನಿ ಕುತ್ರಿ ಯವುನ್ ತ್ಯಚಿ ಖಾಂಡ್ಕ ಚಾ಼ಟಿತಿತ. ");
INSERT INTO gok_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","ಆಸ ಆಸ್ಥಾನಾ ಥೊಡ್ಯಾ ದಿಸಾನಿ ಬಿಖಾರಿ ಮಾನುಸ್ ಮೆಲಾ, ಪರಲೋಕಾಚಾ ಧುತಾಂಚಾನಿ ತ್ಯಲಾ ನಿಹುನ್ ಅಬ್ರಹಾಮಾಚೆ ಕಡಸ್ ಬಸಿವ್ಲಾ. ಆನಿ ತ್ಯೊ ಸಾವ್ಕೊರ್ ಮಾನುಸ್ ಬಿ ಮೆಲಾ; ತ್ಯಚಿ ಉತ್ತರ್ ಕ್ರಿಯಾ ಕಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","ತ್ಯೊ ನರಕಾತ್ ಯಾಪ್ ಖಾತಾನಾ ನದಾರ್ ವರ್ ಕರೂನ್ ದುರ್ನಿ ಅಬ್ರಹಾಮಾಲಾ ಆನಿ ತ್ಯಚೆ ಕಡಸ್ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ಲಾಜ಼ರಾಲಾ ಬಗ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","ತವಾ ತ್ಯೊ, “ಬಾ ಅಬ್ರಹಾಮಾ ಮಾಜಿವ ದಯೆ ಥೆವುನ್ ಲಾಜ಼ರಲಾ ಮಾಜಿಪ ಲಾವುನ್ ದೇ; ತ್ಯೊ ಆಪ್‌ಲ್ಯಾ ಬೊಟಾಚ಼ ಟ್ವಾಕ್ ಪಾನ್ಯಾತ್ ಬುಡುವುನ್ ಮಾಜಿ಼ ಜಿಬ್ ತಂಡ ಕರಾಯಾ ಹೆ ಜ಼ಳ್ಹಿತ್ ಯಾಪ್ ಖಾತ್ಯೊ” ಮನ್ಹುನ್ ವರ್ಡುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","ಫನ್ ಅಬ್ರಹಾಮ್, “ಮುಲಾ ತು ಯವಜ಼ಲ್ಯಾಲ ಸಗ್ಳ ಸುಕ್ ತುಜಾ ಜೀವ್ನಾತ್ ಜಿತ್ತಾ ಆಸ್ಥಾನಾ ಖಾಲ್ಯಾಸ್ ತಸಸ್ ಲಾಜ಼ರಾನಿ ಯಾಪ್ ಖಾಲ್ಯಾತ ತೆ ಯದತ್ ಆನುನ್ ಘೇ ಆತಾ ಹಿತ್ತ ಹ್ಯಲಾ ಸುಕ್ ಹಾ ಫನ್ ತುಲಾ ಯಾಪ್ ಹಾತ್ತ, ");
INSERT INTO gok_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","ಹ್ಯ ಯವ್ಡಸ್ ನವ್ಹ ಆಮ್ಚೆ ತುಮ್ಚೆ ಮದ್ದಿ ಯೊಕ್ ಮೊಟಾ ಘಾಟ್ ಹಾ ಹ್ಯಚಿಸ್ ಲಾಗುನ್ ಹಿಕುನಿ ತುಮ್ಚಿಪ ಜಾ಼ಯಾ ವ್ಹಯಿ ಮನ್‌ಲ್ಯಾಲಿ ಜಾ಼ಯಿತ್ ನಾಹಿತ ಆನಿ ತಿಕುನಿ ಆಮ್ಚಿಪ ಕುನಾಲಾ ವಲ್ಯಾಂಡುನ್ ಯಯಾ ವ್ಹಯಿತ್ ನಾಹಿ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","ತವಾ ಸಾವ್ಕೊರ್ ಮಾನುಸ್ ಅಬ್ರಹಾಮಾಲಾ “ತಸಜಾ಼ಲ್ಯಾ ಲಾಜ಼ರಾಲಾ ಮಾಜಾ ಬಾಚಾ ಗರ‍್ಹಾತ್ ಲಾವುನ್ ದೇ ಮನ್ಹುನ್ ತುಜಿಪ ಮಾಗ್ನ ಕರ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ಮನಾ ಪಾಚ಼್ ಜಾ಼ನ್ ಬಾಹು ಹಾತ್ತ; ತೇ ಸಾಹಿತ್ ಹ್ಯಾ ಯಪಾತ್ನಿ ಯತಿಲ; ಯವುನಾಹಿ ಆಸ ತ್ಯನಿ ಆಪ್ನು ಬಗ್‍ಲ್ಯಾಲ ತ್ಯನಾ ಚಾ಼ಂಗ್ಲ ಸಾಂಗುನಿ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“ಫನ್ ಅಬ್ರಹಾಮ್ ಮೊಶೆಚ಼ ದರ್ಮಶಾಸ್ತಾರ್ ಆನಿ ಪ್ರವಾದಿಂಚಿ ಗ್ರಂಥ ತ್ಯಂಚಿಪ ಹಾತ್ತ ತೀ ಐಕುಂತ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","ತವಾ ತ್ಯೊ, “ಬಾ ಅಬ್ರಹಾಮಾ ತಸ ನವ್ಹ; ಮೆಲ್ಯಾಲ್ಯಾತ್ನಿ ಯಕ್ಲಾ ತ್ಯಂಚಿಪ ಗೆಲ್ಯಾವ ತೇ ಪಾಪಾತ್ನಿ ಮಾಗಾರ ದೇವಾಕ್ಡ ಪರಾತ್ತಿಲ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","ಅಬ್ರಹಾಮಾನಿ ತ್ಯಲಾ, “ತ್ಯಂಚಾನಿ ಮೊಶೆಚ಼ ಆನಿ ಪ್ರವಾದಿಂಚ಼ ಸಬಾತ್ ಐಕ್ಲ ನಾಹಿ ಮಂಜೆ ಮೆಲ್ಯಾಲಾ ಯಕ್ಲಾ ಜಿತ್ತಾ ವ್ಹವುನ್ ಉಟ್ಲಾತರಿ ತೆ ಖರ ದರಿತ್ ನಾಹಿತ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","ಯೇಸು ಆಪ್‌ಲ್ಯಾ ಶಿಶಾನಾ ಮನ್ಲಾ, “ಲೊಕ ಪಾಪ ಕರಾಚಾ ಸಂಗತಿ ಯಯಾಚಾ ಹಾತಾ ಫನ್ ಹ್ಯಾ ಯತ್ಯಾಲ್ಯಾ ಗುಶ್ಟಿ ನಾಹಿತ ಹ್ಯಾ ಗುಶ್ಟಿನಾ ಕಾರನ್ ಜಾ಼ಲ್ಯಾಲ್ಯಾ ಮಾನ್ಸಾಚಿ ಗತ್ ಚಾ಼ಂಗ್ಲಿ ರಾಹಿತ್ನಾಹಿ? ");
INSERT INTO gok_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","ತ್ಯೊ ಹ್ಯಾ ಬ್ಯಾರ್ಕ್ಯಾತ್‍ಲ್ಯಾ ಯಕಾಲಾ ಪಾಪಾತ್ ಪಾಡಾಚೆ ವಾಟ್ನಿಚ಼ ತ್ಯಚಾ ಗಳ್ಯಾತ್ ಜಾ಼ತ್ಯಾಚಾ಼ ದೊಂಢಾ ಬಾಂದುನ್ ಸಮಿಂದೊರಾತ್ ಟಾಕುನ್ ದಿಯಾಚ಼ ಬರ. ");
INSERT INTO gok_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","ತುಮ್ಚೆ ಗುಶ್ಟಿತ್ ಸಂಬಾಳುನ್ ರಾವ್ಹಾ! ತುಜಾ ಬಾವ್ಹಾನಿ ಚು಼ಕ್ ಕಿಲಿತರ್ ತ್ಯಲಾ ದಪ್‌ಕ್ಯಾವ್. ತ್ಯೊ ಚು಼ಕ್ ವಪುನ್ ಆಲಾತ ತ್ಯಚಿ ಚು಼ಕ್ ಮಾಪ್ ಕರುನ್ ಶೊಡ್. ");
INSERT INTO gok_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","ತ್ಯನಿ ದಿಸಾಲಾ ಸಾತ್ ಖೆಪಾ ತುಜೆ ಆಡ್ವಾ ಚು಼ಕ್ ಕರುನ್ ಸಾತ್ ಖೆಪಾಬಿ ತುಜಿ಼ಕ್ಡ ಪರ್ತುನ್ ಮಾಜಿ ಚು಼ಕ್ ಜಾ಼ಲಿ ಮಾಪ್ಕರ್ ಮನ್ಹುನ್ ಸಾಂಗ್ಲತ ತ್ಯಲಾ ಮಾಪ್ ಕರ್ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","ಅಪೊಸ್ತಲಾಂಚಾನಿ ಪ್ರಭುಲಾ, “ಆಮಚಾ಼ ಇಸ್ವಾಸ್ ವಾಡಿವ್” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","ತವಾ ಪ್ರಭುನಿ, “ಮೌರ‍್ಹಿ ಇತ್ಕಾ ಇಸ್ವಾಸ್ ತುಮಾನಾ ರಾಯ್‍ಲ್ಯಾವ ತುಮಿ ಹ್ಯಾ ಹುಂಬ್ರಾಚಾ ಜಾ಼ಢಾಲಾ, ‘ತು ಮುಳಾ ಸಾಹಿತ್ ಉಪ್ಟುನ್ ಜಾ಼ವುನ್ ಸಮಿಂದೊರಾತ್ ಉಬ ರ‍್ಹಾ ಮನ್ಹುನ್ ಸಾಂಗ್‍ಲ್ಯಾವಬಿ ತ್ಯ ತುಮಚಾ಼ ಸಬೊತ್ ಐಕ್ನಾರ್ ");
INSERT INTO gok_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","ತುಮ್ಚಾತ್ ಕಚಾಲಾ ತರಿ ಶಾತ್ ನಾಂಗರ‍್ನಾರಾ ನಾಹಿತ ಬಕ್ರಿ ವಳ್‍ತ್ಯಲಾ ಆಳ್ ಆಸ್‍ಲ್ಯಾವ ತ್ಯೊ ಸೆತಾತ್ನಿ ಗರ‍್ಹಾತ್ ಅಲ್ಯಾಲ್ಯಾ ತ್ಯಾ ಆಳಾಲಾ, ‘ತು ಪಾಟ್ನಿ ಯವುನ್ ಖಾಯಾ ಬಸ್ ಮನ್ಹುನ್ ಸಾಂಗಿಲ್ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","ನಾಹಿ! ತಸ ಸಾಂಗಾಚ಼ ಸುಡುನ್, ‘ತು ಮನಾ ಜೆವ್ನಾಲಾ ಕಾಯ್ತರಿ ತಯಾರ್‍ ಕರ್ ಮಿ ಖಾವುನ್ ಪಿವುನ್ ವ್ಹಯಿಸ್ ಪರ‍್ಯಾತ್ ಮಾಜಿ ಚಾ಼ಕ್ರಿ ಕರ್ ಮಂಗ್ ತು ಖಾ ಪಿ’ ಮನ್ಹುನ್ ಸಾಂಗ್ನಾರ್ ನವ್ಹ. ");
INSERT INTO gok_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","ಆಪ್ನು ಸಾಂಗ್‌ಲ್ಯಾ ಶಾರ್ಕ ಕೆಲ್ಯಾಲ್ಯಾ ತ್ಯಾ ಆಳಾಲಾ ತುಜಿಪ್ನಿ ಮಜ಼ತ್ ಜಾ಼ಲಿ ಮನ್ಹುನ್ ಸಾಂಗಿಲ್ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","ತುಮಿ ತುಮಾನಾ ಸಾಂಗ್‍ಲ್ಯಾಲ ಸಗ್ಳ ಕೆಲ್ಯಾ ನಂತರ್ ಆಮಿ ಸಾದರನ್ ಆಳ್, ಕರಾ ವ್ಹಯಿ ಆಸ್‍ಲ್ಯಾಲಸ್ ಕೆಲ್ಯಾ ಮನ್ಹಾ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","ಯೇಸು ಯೆರುಸಲೇಮಿತ್ ಜಾ಼ತ್ಯಾಲಾ ಆಸ್ಥಾನಾ ಸಮಾರ‍್ಯ ಗಲಿಲಾಯ್ ಸಿಮಂಚೆ ಮದ್ನಿ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","ಯಕಾ ಖೆಡ್ಯಾ ಗಾವಾತ್ ಆಲಾ ತವಾ ಧಾ ಜಾ಼ನ್ ಕುಶ್ಟ ರೊಗಿ ತ್ಯಚೆ ಮೊರ‍್ಹ ಯವುನ್ ದುರ್ ಉಬರಾಹುನ್, ");
INSERT INTO gok_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","“ಯೇಸು! ಪ್ರಭು! ಆಮ್ಚಿವ ಕರ್ನಾ ಥೆವ್” ಮನ್ಹುನ್ ವರ್ಡುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","ಯೇಸುನಿ ತ್ಯನಾ ಬಗುನ್, “ತುಮಿ ಜಾ಼ವುನ್ ತುಮ್ಚಾ ಯಾಜಕಾಲಾ ಆಂಗ್ ದಾವಾ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ತೇ ಜಾ಼ತಾನಾಸ್ ಬರ ಜಾ಼ಲ. ");
INSERT INTO gok_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","ತ್ಯಾತ್‍ಲ್ಯಾ ಯಕಾನಿ ಆಪ್‌ಲ್ಯಾಲಾ ಬರ ಜಾ಼ಲ್ಯಾಲ ಬಗುನ್ ಮೊಟ್ಯಾನಿ ದೇವಾಲಾ ವವ್ಯಾಳಿತ್ ಮಾಗಾರಾ ಆಲಾ ");
INSERT INTO gok_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","ಆನಿ ತ್ಯೊ ಯೇಸುಚಾ ಪಾಯಾತ್ ಪಡುನ್ ತ್ಯಲಾ ಉಪ್ಕಾರ್ ಸಾಂಗ್ಲಾ ತ್ಯೊ ಸಮಾರ‍್ಯಾತ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","ಯೇಸುನಿ ಹ್ಯ ಬಗುನ್, “ಧಾ ಜಾ಼ನ್ಬಿ ಬರ ಜಾ಼ಲ್ಥ ನವ್ಹ? ಆನಿ ರಾಯ್‍ಲ್ಯಾಲ ನವುಜಾ಼ನ್ ಕುಠ? ");
INSERT INTO gok_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","ಪ್ರಭುಲಾ ವವ್ಯಾಳಾಲಾ ಹ್ಯೊ ದುಸ್ರೆ ದೆಶಾತ್ಲಾ ಸುಡುನ್ ಆನಿ ಕಚಾ಼ಸ್ ಮಾಗಾರಾ ಪರ್ತುನ್ ಆಲಾ ನಾಹಿ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","ಮನ್ಹು‍ನ್ ಸಾಂಗುನ್ ತ್ಯಲಾ, “ಉಠುನ್ ಜಾ಼ ತುಜಾ ಇಸ್ವಾಸಾನಿ ತುಲಾ ಬರ ಕೆಲ್ಯಾ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","ಯಕಸಿ ಥೊಡ್ಯಾ ಫರಿಸಾಯಂಚಾನಿ ಯೇಸುಲಾ, “ದೇವಾಚ಼ ರಾಜೆ ಕವಾ ಯನಾರ್” ಮನ್ಹುನ್ ಇಚಾರ್ಲ ತವಾ ತ್ಯೊ ತ್ಯನಾ, “ದೇವಾಚ಼ ರಾಜೆ ಯತ್ಯಾಲ ಧ್ಯಾನ್ತಿವುನ್ ಕುನಾಲಾ ವಳ್ಕಾಯಾ ವ್ಹಯಿತ್ ನಾಹಿ, ");
INSERT INTO gok_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","“ಹಾಬ ಹಿತ್ತ ಹಾ, ಥಬ ತಿಥ ಹಾ, ಮನ್ಹುನ್ ಸಾಂಗಾಯಾ ವ್ಹಯಿತ್ ನಾಹಿ; ದೇವಾಚ಼ ರಾಜೆ ತುಮ್ಚಿಪಸ್ ಹಾ ಮನ್ಹುನ್ ಸಮಜು಼ನ್ ಗೆವ್ಹಾ” ಮನ್ಹುನ್ ಉತ್ತರ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","ಆನಿ ತ್ಯನಿ ಆಪ್‌ಲ್ಯಾ ಶಿಶಾನಾ ಕ್ಯಾ ಸಾಂಗ್ಲ ಮಂಜೆ, “ಯೊಕ್ ಟಾಯಿಮ್ ಯನಾರ್ ತ್ಯಾತ್ ತುಮಿ ಮಾನ್ಸಾಚಾ ಲೇಕಾಚಾ ದಿಸಾತ್ ಯೊಕ್ ದಿಸ್ ಬಗಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಆಶಾ ಕಿಲಿಸಾ ತರಿ ತ್ಯೊ ಬಗಾಚೆ ಆಂದಿ ರಾಸಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","ಲೊಕಾಂಚಾನಿ ತುಮಾನಾ, ‘ಥಬೊ, ತಿಥ ಹಾ, ಹಬೊ ಹಿತ್ತ ಹಾ!’ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ ತರ್ ತುಮಿ ಜಾ಼ವು ನಕೊಸಾ. ");
INSERT INTO gok_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","ಕಾ ಮಂಜೆ ಅಬ್ಳಾತ್ ಚ಼ಕ್ಮಕ್‍ತ್ಯಾಲೆ ಇಜ಼ಚೆಗತ್ ಹಾ ತೀ ಯವುನ್ ಯಕಿಕ್ನಿ ಆನಿ ಯಕಿಕ್ಡ ಕಸಾ ಉಜಿಡ್ ದಿಸ್ತೊ ತಸಾಸ್ ಮಾನ್ಸಾಚಾ಼ ಲ್ಯೊಕ್ ಮಿ ಯತಾನಾ ತುಮಾನಾ ಸಮಾಜ್ನಾ಼ರ್. ");
INSERT INTO gok_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","ಫನ್ ಆಂದಿ ತ್ಯನಿ ಖುಬ್ ಯಾಪ್ ಖಾವುನ್ ಹೆ ಪಿಳ್ಗಿಚಾ ಲೊಕಾಂಚಿಪ್ನಿ ನಾಖರುನ್ ಗಿಹ್ಯಾ ವ್ಹಯಿ. ");
INSERT INTO gok_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","ನೊಹಾಚಾ ದಿಸಾತ್ ಜಾ಼ಲ್ಯಾ ಶಾರ್ಕ ಮಾನ್ಸಾಚಾ ಲೇಕಾಚಾ ದಿಸಾತ್ಬಿ ಚಾ಼ಲ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","ನೊಹಾ ವ್ಹಡಿತ್ ಗೆಲ್ಯಾಲ್ಯಾ ದಿಸಾ ಪರ‍್ಯಾತ್ ಲೊಕ ಖಾಯಿತಿತ, ಪಿಯಿತಿತ, ಲಗ್ನ ಕರುನ್ ದಿಯಿತಿತ, ತವಾ ಪ್ರಳಯ್ ಯವುನ್ ಸಗ್‌ಳ್ಯಾಂಚಾ಼ ನಾಸ್ ಕೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","ಆನಿ ಲೊಟಾಚಾ ದಿಸಾತ್ ಆಸಸ್‍ ಹುತ ತಿ ಲೊಕ ಖಾಯಿತ್, ಪಿಯಿತ್ ಹುತ್ತಿತ, ನಿಹಿತಿತ, ಇಕಿತಿತ, ಪಿರಿತಿತ, ಗರ‍್ಹ ಬಾಂದಿತಿತ, ");
INSERT INTO gok_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","ಫನ್ ಲೊಟಾ ಸೊದೊಮ್ ಗಾವ್ ಸುಡುನ್ ಗೆಲ್ಯಾಲ್ಯಾ ದಿಸಾದಿಸಿ ಆಬ್ಳಾತ್ನಿ ಇಸ್ತು ಆನಿ ಇಂಗಾಳ್ ಪಡುನ್ ತ್ಯನಾ ಸಗ್‍ಳ್ಯಾನಾ ನಾಸ್ ಕೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","ಮಾನ್ಸಾಚಾ಼ ಲ್ಯೊಕ್ ಯತ್ಯಾಲ್ಯಾ ದಿಸಾತ್ ತಸಸ್ ವ್ಹನಾರ್. ");
INSERT INTO gok_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","ತ್ಯಾ ದಿಸಾತ್ ಮಾಳಿವ ಆಸ್‍ಲ್ಯಾಲಾ ಆಪ್ಲಾ ದಾಗಿನಾ ಗಿಹ್ಯಾ ಉತ್ರುನ್ ಯವು ನಾಹಿ; ತಸಸ್ ಸೆತಾತ್ ಆಸ್‍ಲ್ಯಾಲಾ ಸಾಹಿತ್ ಪರ್ತುನ್ ಗರ‍್ಹಾತ್ ಮಾಗಾರಾ ಜಾ಼ವು ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","ದೇವಾನಿ ಶಿಕ್ಶೆ ದಿಲ್ಯಾಲೆ ಲೊಟಾಚೆ ಬ್ಯಾಯ್ಕೊಚಿ ಯಾದ್ ಕರಾ ");
INSERT INTO gok_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","ಆಪ್ಲಾ ಜೀವ್ ಉರ್ವಾ ವ್ಹಯಿ ಮನ್‍ಲ್ಯಾಲಾ ಜೀವ್ ಸಾಂಡುನ್ ಗೆನಾರ್; ಆನಿ ಜೀವ್ ಸಾಂಡುನ್ ಗೆತಲ್ಯಾಲ್ಯಾನಿ ಜೀವ್ ರಾಖುನ್ ಗೆನಾರ್. ");
INSERT INTO gok_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“ತೇ ರಾತಿತ್ ಯಕಾ ಪಲಂಗಾವ ದೊಗ ರಾನ್ಹಾರ್; ತ್ಯಾತ್‌ಲ್ಯಾ ಯಕಾಲಾ ನೆನ್ಹಾರ್ ಆನಿ ಯಕಾಲಾ ತಿಥಸ್ ಥೆವ್ನಾರ್ ");
INSERT INTO gok_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","ದುಗಿ ಬ್ಯಾಯ್ಕಾ ಯಕಾಸ್ ಜಾ಼ತ್ಯಾವ ದಳ್ನಾರ್; ಯಕಿ ಲಾ ನೇನ್ಹಾರ್ ಆನಿ ಯಕಿಲಾ ಸುಡುನ್ ಜಾ಼ನಾರ್ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","ಹ್ಯಾ ಸಬ್ದಾಲಾ ಶಿಶಾಂಚಾನಿ, “ಪ್ರಭು ತ್ಯ ಕುಠ ವ್ಹನಾರ್ ಮನ್ಹು‍ನ್ ಇಚಾರ್ಲ ತ್ಯಲಾ ಯೇಸುನಿ ತ್ಯನಾ ಮಡ ಕುಠ ತಿಥ ಗಿದ್ಡ ಜ಼ಮತ್ಯಾತ ಮನ್ಹುನ್ ಉತ್ತರ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","ಯೇಸುನಿ ಆಪ್‌ಲ್ಯಾ ಶಿಶಾನಾ ಬೆಜಾರ್ ಕರಾಚೆ ಆಂದಿ ಕವಾಬಿ ಮಾಗ್ನ ಕರಾವ ಹೆ ಗುಶ್ಟಿತ್ ಯೇಕ್ ಕ್ಯಾಯ್ನಿ ಸಾಂಗ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","ತೀ ಕ್ಯಾ ಮಂಜೆ, “ಯಕ್ಕಾ ಗಾವಾತ್ ಯೊಕ್ ನ್ಯಾಯಿ ಕರ್ತ್ಯಾಲಾ ಹುತ್ತಾ. ತ್ಯೊ ದೇವಾಲಾ ಬಿಹಿ ನಸ್ನಾರಾ ಮಾನ್ಸಾಂಚಿಕ್ಡ ಲಕ್ಶೆ ಕರೀತ್ ನಸ್ನಾರಾ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","ತ್ಯಾಚ್ ಗಾವಾತ್ ಯೇಕ್ ವಿದ್ವಾ ಹುತ್ತಿ. ತಿ ತ್ಯಚಿಪ ಕಾಯಿಮ್ ಯವುನ್, “ಮಾಜಾ ವಾದಿಪ್ನಿ ನ್ಯಾಯಿ ಕರುನ್ ಮನಾ ಸುಡಿವ್” ಮನ್ಹುನ್ ಸಾಂಗಿತ್ ಹುತ್ತಿ. ");
INSERT INTO gok_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","ತ್ಯನಿ ಥೊಡ ದಿಸ್ ಮನ್‌ಕೆಲ ನಾಹಿ. ತ್ಯಾ ನಂತರ್ ತ್ಯನಿ ಮಿ ದೇವಾಲಾ ಬಿಥ್ಯಾಲೊ ನವ್ಹ, ಮಾನ್ಸಾಂಚಿಕ್ಡ ಲಕ್ಶೆ ದೆತ್ಯಾಲೊ ನವ್ಹ. ");
INSERT INTO gok_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ಫನ್ ಹಿ ವಿದ್ವಾ ಮನಾ ಕಾಂಬಿವ್ತೆ ಮನ್ಹುನ್ ಹಿಚಾ಼ ನ್ಯಾಯಿ ಕರಿನ್ ನಾಹಿತ ಹಿ ಖಾಯಿಮ್ ಯವುನ್ ಮನಾಸ್ ಕಾಂಬ್ವಿಲ್” ಮನ್ಹುನ್ ಆಪ್‌ಲ್ಯಾ ಮನಾತ್ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","ಪ್ರಭುನಿ ಹಿ ಕ್ಯಾಯ್ನಿ ಸಾಂಗ್‌ಲ್ಯಾ ನಂತರ್ ಆಪ್‌ಲ್ಯಾ ಶಿಶಾನಾ ಐಕಾ ಅನ್ಯಾಯ್ ಕರ್ತ್ಯಾಲ್ಯಾ ನ್ಯಾಯಾದಿಪತಿನಿ ಕ್ಯಾ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","ರ‍್ಯಾತ್ ದೀಸ್ ಖಾಯಿಮ್ ಮಾಗ್ನ ಕರ್ತ್ಯಾಲ್ಯಾ ಆಪ್‌ಲ್ಯಾ ಲೊಕಾನಾ ದೇವ್ ನ್ಯಾಯಾ ದೀತ್ ನಾಹಿಕ್ಯಾ? ತ್ಯೊ ಮಜ಼ತ್ ಕರಾಯಾ ಲೇಟ್ ಕರಿಲ್ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","ತ್ಯನಾ ಬೀಗಿ ನ್ಯಾಯಿ ಕರಿಲ್ ಮನ್ಹುನ್ ತುಮಾನಾ ಸಾಂಗ್ತೊ. ಆಸ ಆಸ್ಥನಾ ಮಾನ್ಸಾಚಾ ಲ್ಯೊಕ್ ಯಯಿಲ್ ತವಾ ದರ್ಥಿವ ಇಸ್ವಾಸ್ ಬಗಿಲ್? ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","ಆನಿ ಆಪ್ನುಸ್ ಚಾ಼ಂಗ್ಲ ಮನ್ಹುನ್ ಆಪ್ಲಿವ ಇಸ್ವಾಸ್ ಥಿವುನ್ ರಾಯ್‍ಲ್ಯಾಲ್ಯಾನಾ ನಿಯತ್ ನಸ್ನಾರಿ ಮಂಥ್ಯಾಲ್ಯಾ ಥೊಡ್ಯಾನಾ ಯೇಕ್ ಕ್ಯಾಯ್ನಿ ಸಾಂಗ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","ತಿ ಕ್ಯಾ ಮಂಜೆ, “ಮಾಗ್ನ ಕರಾ ವ್ಹಯಿ ಮನ್ಹು‍ನ್ ದೊನ್ ಮಾನುಸ್ ದೇವ್ಳಾತ್ ಗೆಲ; ಯೊಕ್ ಫರಿಸಾಯ್ ಆನಿ ಯೊಕ್ ಜ಼ಖತ್ ದಾರ್. ");
INSERT INTO gok_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","ಫರಿಸಾಯ್ ಉಬಾರಾಹುನ್ ಮಾಗ್ನ ಕರ್ತಾನಾ ಆಪ್‌ಲ್ಯಾ ಮನಾತ್, “ದೇವಾ ಸುಲುನ್ ಖಾತ್ಯಾಲ್ಯಾ ಚು಼ಕ್ ಕರ್ತ್ಯಾಲ್ಯಾ ರಾಂಡ್‍ ಸಂಗತ್ ಕರ್ತ್ಯಾಲ್ಯಾ ದಿಸರ‍್ಯಾ ಲೊಕಾಂಚಿಗತ್ ಮಿ ನವ್ಹ, ಹ್ಯಾ ಜ಼ಖತ್ ದಾರಾಚಿಗತ್ ಬಿ ನವ್ಹ ಮನ್ಹುನ್ ತುಲಾ ಉಪ್ಕಾರ್ ಕರ್ತೊ ");
INSERT INTO gok_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","ವಾರಾತ್ನಿ ದೊಂದಾ ಉಪಾಸ್ ಕರ್ತೊ; ಮಿ ಕಮಿವ್‍ಲ್ಯಾಲ್ಯಾ ಪರ್ತೆಕಾತ್ ಧಾತ್ಲಾ ಯೊಕ್ ಭಾಗ್ ದೆತೊ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","ಫನ್ ತ್ಯೊ ಜ಼ಖತ್ ದಾರ್ ದುರ್ ಉಬಾರಾಹುನ್ ಆಬ್ಳಾಕ್ಡ ಡೊಳ ಉಗ್ಡುನ್ ಬಗಾಯಾ ದಿಕಿಲ್ ಮನ್‌ ನಸ್ಥಾನಾ ಶಾತಿ ಬಡವುನ್ ಗಿಹಿತ್, “ದೇವಾ ಪಾಪಿ ಆಸ್‍ಲ್ಯಾಲ್ಯಾ ಮಾಜಿವ ಕರ್ನಾ ಥೆವ್” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","ದೆವಾಚೆ ನದ್ರಲಾ ಹ್ಯೊ ನಿಯತಿಚಾ಼ ಮನ್ಹು‍ನ್ ಥರುನ್ ಆಪ್‌ಲ್ಯಾ ಗರ‍್ಹಾತ್ ಗೆಲಾ ತ್ಯೊ ಫರಿಸಾಯ್ ತಸಾ ವ್ಹವುನ್ ಗೆಲಾ ನಾಹಿ ಮನ್ಹುನ್ ತುಮಾನಾ ಸಾಂಗ್ತೊ. ಆಪ್‌ಲ್ಯಾಲಾ ಆಪ್ನು ಥೊರ್ ಮಂಥೊ ತ್ಯೊ ನ್ಹಾನ್ ವ್ಹಯಿಲ್; ಆನಿ ಆಪ್‌ಲ್ಯಾತ್ ಆಪ್ನು ನ್ಹಾನ್ ಮನ್ಹುನ್ ರಾಹಿಲ್ ತ್ಯೊ ಥೊರ್ ವ್ಹಯಿಲ್ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","ಥೊಡ್ಯಾಂಚಾನಿ ಆಪ್‌ಲ್ಯಾ ಬಾರಿಕ್ ಮುಲಾನಾ ಯೇಸುಪ್ನಿ ಹಾತ್ ಲಾವುನ್ ಗಿಹ್ಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಯೇಸುಪ ಆಂತ್ಯಾಲಿ ತ್ಯಚಾ ಶಿಶಾಂಚಾನಿ ಬಗುನ್ ತ್ಯನಾ ದಪ್‌ಕ್ಯಾವ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","ಫನ್ ಯೇಸುನಿ ತ್ಯಾ ಮುಲಾನಾ ಆಪ್ಲಿಪ ಹಾಕ್ಟುನ್, ಆಸಾ ಮನ್ಲಾ “ಮುಲಾನಾ ಮಾಜಿ಼ಪ ಯವುದೇವಾ; ತ್ಯನಾ ಆಡ್ಯಾವು ನಕೊಸಾ ದೇವಾಚ಼ ರಾಜೆ ಆಸ್‍ಲ್ಯಾಂಚ಼ಸ್. ");
INSERT INTO gok_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","ಆನಿ ಮಿ ತುಮಾನಾ ಖರ ಸಾಂಗ್ತೊ ಕೊನ್ ಪೋರಾಚೆ ಬಾವ್ನನಿ ದೇವಾಚ಼ ರಾಜೆ ಗಿಹಿತ್ ನಾಹಿ ತ್ಯೊ ತ್ಯಾತ್ ಜಾ಼ಯಿತ್ ನಾಹಿ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","ಯೊಕ್ ಯೆಹುದ್ಯಾಂಚಾ಼ ಅಧಿಕಾರಿ ಯವುನ್, “ಚಾ಼ಂಗಲ್ಯಾ ಗುರು ಮನಾ ಶಾಶ್ವತ್ ಜೀವ್ ಗಾವಾ ವ್ಹಯಿತ ಮಿ ಕ್ಯಾ ಕರಾ ವ್ಹಯಿ? ಮನ್ಹುನ್ ಯೇಸುಲಾ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","ತವಾ ಯೇಸು ತ್ಯಲಾ, “ಮನಾ ಚಾ಼ಂಗ್ಲ ಮನ್ಹುನ್ ಕಾ ಮಂಥೊಸ್? ದೇವ್ ಯೊಕುಸ್ ಚಾ಼ಂಗ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","ರಾಂಡ್ ಸಂಗತ್ ಕರುನಾಹಿ ಖುನ್ ಕರುನಾಹಿ; ಚು಼ರಿ ಕರುನಾಹಿ; ಲಬಾಡ್ ಸಾಕ್ಶಿ ಸಾಂಗು ನಾಹಿ ಆಯಿ ಬಾಲಾ ಮರ‍್ಯಾದ್ ದಿಯಾ ವ್ಹಯಿ ಹ್ಯಾ ಆಜ್ಞಾ ಠಾವ್ಯಾ ಹಾತಾ ತ್ಯವ್‍ಡ್ಯಾಸ್ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","ತವಾ ತ್ಯೊಮಾನುಸ್, “ಮಿ ನ್ಹಾನ್ಪಸ್ನಿ ಹ್ಯಂಚಿ ಶಾರ್ಕಾ ಚಾ಼ಲತ್ ಆಲ್ಯೊ” ಮನ್ಹುನ್ ಮನ್ಲಾ ತವಾ. ");
INSERT INTO gok_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","ಯೇಸು ತ್ಯ ಐಕುನ್ ತ್ಯಲಾ, “ಆಜು಼ನ್ ತುಲಾ ಯಾಕ್ ಕಮ್ಮಿ ಜಾ಼ಲ್ಯಾ; ತುಜ಼ ಆಸ್‌ಲ್ಯಾಲ ಸಗ್ಳ ಇಕುನ್ ಪೈಸ ಗರಿಬಾನಾ ವಾಟುನ್ ದೇ; ಪರಲೊಕಾತ್ ತುಲಾ ಸಂಪತ್ ಗಾವಲ್ ತು ಯವುನ್ ಮಾಜೆ ಮಾಗ ಲಾಗ್ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","ತ್ಯೊ ಮಾನುಸ್ ಖುಬ್ ಸಾವ್ಕೊರ್ ಹುತ್ತಾ ಮನ್ಹುನ್ ಹ್ಯ ಐಕುನ್ ಖುಬ್ ದುಃಕ್ ಜಾ಼ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","ತವಾ ಯೇಸುನಿ ತ್ಯಲಾ ಬಗುನ್, “ಸಾವ್ಕೊರ್ ಮಾನುಸ್ ದೇವಾಚಾ ರಾಜಾತ್ ಜಾ಼ಯಾಚ಼ ಕ್ಯವ್ಡ ಕಠಿನ್ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","ಸಾವ್ಕೊರ್ ಮಾನುಸ್ ದೇವಾಚಾ ರಾಜಾತ್ ಜಾ಼ಯಾಚೆ ವಾಟ್ನಿಚ಼ ಹುಟ್ ಸುಚಾ ಡೋಳ್ಯಾತ್ನಿ ಜಾ಼ಯಾಚ಼ ಸಲ್ಪ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","ಯೇಸುಚ಼ ಹೆ ಸಬಾತ್ ಐಕ್‍ಲ್ಯಾಲ, “ಆಸ ಜಾ಼ಲ್ಯಾ ಕುನಾಲಾ ರಕ್ಶನ್ ವ್ಹಯಿಲ್” ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","ತವಾ ಯೇಸುನಿ ತ್ಯನಾ, “ಮಾನ್ಸಾನಾ ವ್ಹಯಿತ್ ನಸ್‍ಲ್ಯಾಲ ದೇವಾಲಾ ವ್ಹತ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","ತವಾ ಪೇತ್ರ, “ಆತಾ ಆಮಿ ಆಮ್ಚಿ ಘರ್ ದಾರ ಸೂಡುನ್ ತುಜೆ ಮಾಗ್ನಿ ಆಲ್ಯಾವ್” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","ತವಾ ಯೇಸು ತ್ಯನಾ, “ತುಮಾನಾ ಖರ ಸಾಂಗ್ತೊ. ಕೊನ್ ದೇವಾಚಾ ರಾಜಾ ಸಾಟಿ ಘರ್, ಬ್ಯಾಯ್ಕೊ ಬಾಹು ಆಯಿ ಬಾ ಪೊರಾನಾ ಸುಡುನ್ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ತ್ಯಲಾ ಆತಾಚಾ ಕಾಲಾತ್ ಖುಬ್ ವಾಟ್ನಿ ಗಾವ್ನಾರ್; ಆನಿ ಮೊರ್ಲೆ ದುನೆತ್ ಶಾಶ್ವತ್ ಜೀವ್ ಮಿಳ್ನಾರ್” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","ಯೇಸುನಿ ಆಪ್‌ಲ್ಯಾ ಬಾರಾ ಜಾ಼ನ್ ಶಿಶಾನಾ ಹಾಕ್ಟುನ್ ತ್ಯನಾ, “ಬಗಾ ಆಮಿ ಯೆರುಸಲೇಮಿತ್ ಜಾ಼ತ್ಯಾವ್ ಆನಿ ಮಾನ್ಸಾಚಾ ಲೇಕಾಚೆ ಗುಶ್ಟಿತ್ ಪ್ರವಾದಿಂಚಾನಿ ಲಿವ್‍ಲ್ಯಾಲ ಸಗ್ಳ ತ್ಯಚಿಪ ಗಡ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","“ತ್ಯಲಾ ಯೆಹುದ್ಯ ನಸ್‍ಲ್ಯಾಲ್ಯಾ ದಿಸರ‍್ಯಾ ಲೊಕಾಂಚಾ ತಾಬ್ಯಾತ್ ದೇನಾರ್ ತೀ ತ್ಯಚಿ ನಿಂದಾ ಕರ್ನಾರ್ ಸಿವ್ಯಾದೇನಾರ್ ಥುಕ್ನಾರ್ ");
INSERT INTO gok_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ಕಾಟ್ಯಾಚಾ ಬಾರ‍್ಕುಲಾನಿ ಮಾರುನ್ ಜೀವ್ ಕ್ಯಾಡ್ನಾರ್. ಆನಿ ತೀನ್ ದಿಸಾ ನಂತರ್ ತ್ಯೊ ಪರತ್ ಜಿತ್ತಾ ವ್ಹವುನ್ ಉಠುನ್ ಯನಾರ್” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","ಫನ್ ಶಿಶಾಂಚಾನಿ ಹ್ಯಾತ್ಲಿ ಯೇಕ್ ಗ್ಯೊಶ್ಟ್ ಬಿ ಸಮಜು಼ನ್ ಗಿತ್ಲಿ ನಾಹಿ ಹ್ಯಾ ಗುಶ್ಟಿ ತ್ಯನಾ ಆಡ್‍ಶಾ ಹುತ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","ಯೇಸು ಯೆರಿಕೊಚೆ ಜ಼ವಳ್ ಆಲಾ ತವಾ ವಾಟಚೆ ಕಡಸ್ ಬಸುನ್ ಭೀಕ್ ಮಾಗ್‍ತ್ಯಾಲಾ ಯೊಕ್ ಕುರ್ಡಾ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","ತ್ಯನಿ ವಾಟನಿ ಹಿಂಡಾನಿ ಜಾ಼ತ್ಯಾಲ್ಯಾ ಲೊಕಾಂಚ಼ ಸಬ್ದ ಐಕುನ್ ಹ್ಯ ಕ್ಯಾ ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","ತ್ಯಂಚಾನಿ ತ್ಯಲಾ, “ನಜ಼ರೇತಿಚಾ಼ ಯೇಸು ಹೆ ವಾಟನಿ ಜಾ಼ತ್ಯೊ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","ತವಾ ತ್ಯೊ ಕುರ್ಡಾ “ಯೇಸುಗಾ ದಾವಿದಾಚಾ ಲೇಕಾ ಮಾಜಿವ ಕರ್ನಾ ದ್ಯಾವ್” ಮನ್ಹುನ್ ಜೊ಼ರಾನಿ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","ಮೊರ‍್ಹ ಜಾ಼ತ್ಯಾಲ್ಯಾ ಲೊಕಾಂಚಾನಿ ಗಪ್ ರ‍್ಹಾ ಮನ್ಹು‍ನ್ ತ್ಯಲಾ ದಪ್‌ಕ್ಯಾವ್ಲಾ ತವಾ ತ್ಯೊ, “ದಾವಿದಾಚಾ ಲೇಕಾ, ಮಾಜಿವ ಕರ್ನಾ ಥೆವ್” ಮನ್ಹುನ್ ಆನಿಕ್ ವರಾಡ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","ತವಾ ಯೇಸು ಉಬಾರಾಹುನ್ ತ್ಯಲಾ ಆಪ್ಲಿಪ ಹಾಕ್ಟುನ್ ಆನಾಯಾ ಸಾಂಗ್ಲ ");
INSERT INTO gok_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","ತ್ಯೊ ಜ಼ವಳ್ ಆಲಾ ತವಾ ಯೇಸುನಿ ತ್ಯಲಾ, “ಮಿ ತುಲಾ ಕ್ಯಾ ಕರಾ ವ್ಹಯಿ ಮಂಥೊಸ್” ಮನ್ಹುನ್ ಇಚಾರ್ಲ್ಯಾಲ್ಯಾಲಾ ತ್ಯನಿ, “ಮಿ ಆನಿಕ್ ಸಗ್ಳ ಬಗಿ ಜೊ಼ಗ ಕರ್” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","ಯೇಸು ತ್ಯಲಾ, “ತುಲಾ ದಿಸುನಿ; ತುಜಾ ಇಸ್ವಾಸಾನಿ ತುಲಾ ಬರಾ ಕೆಲ್ಯಾ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","ತವಾಸ್ ತ್ಯಲಾ ದಿಸಾಯಾಲಾಗ್ಲ ತ್ಯೊ ದೇವಾಲಾ ವವ್ಯಾಳಿತ್ ಯೇಸುಚೆ ಮಾಗ್ನಿ ಗೆಲಾ ಲೊಕ ಸಗ್ಳಿ ಚಾ಼ಲ್ಯಾಲಿ ಹಾಕಿಗತ್ ಬಗುನ್ ದೇವಾಲಾ ಉಪ್ಕಾರ್ ಕರಾಯಾ ಲಾಗ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","ಯಂಗ್ದಾ ಯೇಸು ಯೆರಿಕೊ ಗಾವಾತ್ ಬರ್ಹುನ್ ತಿಥ್ನಿ ಮೊರ‍್ಹ ಜಾ಼ಯಿತ್ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","ತಿಥ ಜಖಾಯಾ ಮಂಥ್ಯಾಲಾ ಯೊಕ್ ಮಾನುಸ್ ಹುತ್ತಾ; ತ್ಯೊ ಜಖತಿಚಾ಼ ಗುತ್ಕಿ ಗೆಥ್ಯಾಲಾ ಆನಿ ಸಾವ್ಕೊರ್ ");
INSERT INTO gok_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","ತ್ಯೊ ಯೇಸು ಕೊನ್ ಮನ್ಹುನ್ ಬಗಾಯಾ ಖಟಪಟ್ ಕರೀತಾ ಫನ್ ಗರ್ದಿಸ್ ಲಾಗುನ್ ತ್ಯಚ಼ ಕಾಯ್ ಚಾ಼ಲನಾ ಕಾ ಮಂಜೆ ತ್ಯೊ ಗಿಡ್ಡಾ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","ಮನ್ಹುನ್ ಯೇಸುಲಾ ಬಗಾಯಾಸಾಟಿ ಮೊರ‍್ಹ ಪಳತ್ ಜಾ಼ವುನ್ ತ್ಯೊ ತಿಥ ಯೆರಿಕೋಚೆ ವಾಟವ್‍ಲ್ಯಾ ವಡಾಚಾ ಜಾ಼ಢಾವ ಚ಼ಡುನ್ ಬಸ್ಲಾ ಹುತ್ತಾ ಯೇಸು ತೆ ವಾಟನಿ ಜಾ಼ಯಾಚಾ಼ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","ಯೇಸು ತಿಥ ಯವುನ್ ವರ್ ಬಗುನ್, “ಜಕಾಯಾ ಪಾಟ್ನಿ ಉತುರುನ್ ಯೇ, ಮಿ ಹೆ ಯಳಿ ತುಜಾ ಗರ‍್ಹಾತ್ ರಾಹ್ಯಾ ವ್ಹಯಿ” ಮನ್ಹುನ್ ತ್ಯಲಾ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","ತವಾ ತ್ಯೊ ಪಾಟ್ನಿ ಉತುರುನ್ ಯವುನ್ ಯೇಸುಲಾ ಆನಂದಾನಿ ಹಾಕಟ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","ಹ್ಯ ಬಗ್‌ಲ್ಯಾಲಿ ಸಗ್ಳಿಜ಼ನ, “ಹ್ಯೊ ಪಾಪಿಚಾ ಗರ‍್ಹಾತ್ ರಾಹ್ಯಾ ಗೆಲ್ಯಾ” ಮನ್ಹುನ್ ಟೂರ್ ಟೂರ‍್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","ಫನ್ ಜಕಾಯಾ ಉಬಾ ರಾಹುನ್ ಸ್ವಾಮಿಲಾ, “ಪ್ರಭು ಬಗ್, ಮಾಜೆ ಆಸ್ಥಿತ್ಲಿ ಆರ್ದಿ ಗರಿಬಾನಾ ದೇತೊ; ಆನಿ ಮಿ ಅನ್ಯಾಯಾನಿ ಕುನಾಪ್ನಿ ಕಾಯ್ ತರಿ ವಡುನ್ ಗೆತ್ಲ ಆಸ್ಲತ ಚಾರ್ ಫಟ್ ಮಾಗಾರ ದೇತೊ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","ಹ್ಯ ಐಕುನ್ ಯೇಸು, “ಹೆ ಯಳಿ ಹ್ಯಾ ಗರ‍್ಹಾಚ಼ ರಕ್ಶನ್ ಜಾ಼ಲ; ಹ್ಯೊ ಸಾಹಿತ್ ಅಬ್ರಹಾಮಾಚಾ ವಂಶಾತ್ಲಾ ನವ್ಹ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","ಕಾ ಮಂಜೆ ಮಾನ್ಸಾಚಾ಼ ಲ್ಯೊಕ್ ಚು಼ಕುನ್ ಗೆಲ್ಯಾಲ್ಯಾಲಾ ಸೂದುನ್ ರಾಕಾಯಾ ಆಲ್ಯಾ” ಮನ್ಹುನ್ ಸಾಂಗ್‍ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","ತೆ ಹ್ಯಾ ಗುಶ್ಟಿ ಐಕಿತ್ ಆಸ್ಥಾನಾ ಯೇಸು ಯೆರುಸಲೇಮಿಲಾ ಜ಼ವಳ್ ಜಾ಼ಲ್ಥಾ ಮನ್ಹುನ್ ದೇವಾಚ಼ ರಾಜೆ ತವಾಸ್ ಪ್ರತ್ಯಕ್ಷ ವ್ಹಯಾಚೆಗತ್ ಹಾ ಮನ್ಹುನ್ ತ್ಯಂಚಾನಿ ಸಮಜು಼ನ್ ಗೆತ್ಲ ಹುತ್ತ ಮನ್ಹುನ್ ಆನಿ ಯೇಕ್ ಕ್ಯಾಯ್ನಿ ಸಾಂಗ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","ತೀ ಕ್ಯಾ ಮಂಜೆ, “ಯೊಕ್ ಮೊಟ್ಯಾ ಗರಾನ್ಯಾಚಾ಼ ಮಾನುಸ್ ಆಪ್ನು ರಾಜಾ಼ ವ್ಹವುನ್ ಪರತ್ ಯಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ದುರ್ಚೆ ದೇಶೆತ್ ನಿಗಾಲ. ");
INSERT INTO gok_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","ಜಾ಼ತಾನಾ ಆಪ್‌ಲ್ಯಾ ಆಳಾತ್‍ಲ್ಯಾ ಧಾ ಜ಼ನಾನಾ ಹಾಕ್ಟುನ್ ತ್ಯನಾ ಧಾ ಸೊನ್ಯಾಚ಼ ಆನ ದಿವುನ್ ಮಿ ಯಯಿ ಪರ‍್ಯಾತ್ ದಂಧಾ ಕರುನ್ ರಾವ್ಹಾ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","ಫನ್ ತ್ಯಚಾ ಗಾವಾತಲ್ಯಾ ಮಾನ್ಸಾಂಚಾನಿ ತ್ಯಚಿವ ರಾಗ್ ಕರುನ್ ತ್ಯಚೆ ಮಾಗ್ನಿ ವಕಿಲ್ ಲಾವುನ್ ದಿವುನ್ ಹ್ಯೊ ಆಮಾನಾ ರಾಜಾ಼ ವ್ಹಯಾಚಾ಼ ಆಮ್ಚಾ ಮನಾತ್ ನಾಹಿ ಮನ್ಹುನ್ ಸಾಂಗಾಯಾ ಲ್ಯಾವ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","ತ್ಯಾ ನಂತರ್ ತ್ಯೊ ರಾಜಾ಼ ವ್ಹವುನ್ ಮಾಗಾರಾ ಯವುನ್ ಆಪ್ನು ಪೈಸ ದಿಲ್ಯಾಲ್ಯಾ ಆಳಾಂಚಾನಿ ದಂದಾಕರುನ್ ಕ್ಯವ್ಡಾ ಕ್ಯವ್ಡಾ ಪ್ಯಾಯ್ದಾ ಕೆಲ್ಯಾ ಮನ್ಹುನ್ ಸಮಜಾ಼ಯಾ ತ್ಯನಾ ಆಪ್ಲಿಪ ಹಾಕಟ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","ಪೈಲಾ ತ್ಯಚೆ ಮೊರ‍್ಹ ಯವುನ್, “ದನ್ಯಾ, ತು ದಿಲ್ಯಾಲ್ಯಾ ಅನ್ಯಾನಿ ಧಾ ಆನ ಕಮಿವ್‍ಲ್ಯಾತ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","ತವಾ ತ್ಯೊ ತ್ಯಲಾ, ಶಬಾಸ್! ತು ಚಾ಼ಂಗ್ಲಾ ಆಳ್; ತು ನಖಾಡೆ ಗುಶ್ಟಿತ್ ಇಸ್ವಾಸಾನಿ ರಾಯ್ಲಾಸ್ ಮನ್ಹುನ್ ಧಾ ಗಾವಾಂಚಿವ ಅಧಿಕಾರಿ ಹೋ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","ದೊನ್ವಾ ಯವುನ್, “ದನ್ಯಾ ತು ದಿಲ್ಯಾಲ್ಯಾ ಯಕಾ ಆನ್ಯಾನಿ ಪಾಚ಼್ ಆನ ಮಿಳಿವ್ಲ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","ತವಾ ತ್ಯೊ ತ್ಯಲಾ, “ತು ದಿಖಿಲ್ ಪಾಚ಼್ ಗಾವಾಂಚಿವ ಆದಿಕಾರಿ ರ‍್ಹಾ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","ಮಂಗ್ ಆನಿ ಯೊಕ್ ಯವುನ್, “ದನ್ಯಾ ಹಬ ತು ದಿಲ್ಯಾಲ ಸೊನ್ಯಾಚ಼ ಆನ ಹ್ಯ ಫಡಕ್ಯಾತ್ ಬಾಂದುನ್ ಥೆವ್‍ಲ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","ತು ಥೆವ್‍ಲ್ಯಾ ನಸ್‍ಲ್ಯಾಲ ಉಚ್ಲು಼ನ್ ಗಿಹುನ್ ಜಾ಼ನಾರಾ ಪಿರಿನಸ್ತಾನಾ ಕ್ಯಾಪ್ನಾರಾ ಖುಬ್ ಬಾದ್ ಮಾನುಸ್ ಮನ್ಹುನ್ ತುಲಾ ಬಿಹುನ್” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","ತ್ಯೊ ದನ್ಹಿ, “ತು ಬರ್ಸಾ ಆಳ್ ತುಜಾ ಬೊಲ್‍ನ್ಯಾವಸ್ ತುಜಾ಼ ನ್ಯಾಯಿ ಕರ್ತೊ ಮಿ ಥಿವಿನಸ್‍ಲ್ಯಾಲ ಉಚ್ಲು಼ನ್ ನೆನ್ಹಾರಾ ಪಿರಿ ನಸ್ಥಾನಾ ಕ್ಯಾಪ್ನಾರ್ ಮಾನುಸ್ ಮನ್ಹುನ್ ಸಮಾಜ಼್ಲಾಸ್? ");
INSERT INTO gok_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","ತಸ ಜಾ಼ಲ್ಯಾ ತು ಮಾಜ಼ ಸೊನ್ಯಾಚ಼ ಆನ ಬಡ್ಡಿನಿ ಕಾ ದಿಲನಾಹಿತ? ಮಿ ಮಂಗ್ ಯವುನ್ ತೆ ಬಡ್ಡಿನಿ ಗಿಹಿತೊ ಮನ್ಹು‍ನ್ ಸಾಂಗುನ್ ");
INSERT INTO gok_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","ಕಡಸ್ ಉಬಿರಾಯ್‍ಲ್ಯಾಲ್ಯಾನಾ ತೆ ಆನ ಹ್ಯಚಿಪ್ನಿ ಗಿಹುನ್ ಧಾ ಆನ ಆಸ್‍ಲ್ಯಾಲ್ಯಾಲಾ ದೆವಾ ಮನ್ಹು‍ನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","ತವಾ ತೆ, “ದನ್ಯಾ ಧಾ ಆನ ತ್ಯಚಿಪ ಹಾತ್ತ ನವ್ಹ” ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","ತ್ಯಲಾ ತ್ಯೊ ಕಚಾಪ ಥೊಡ ಹಾ ತ್ಯಲಾ ಆನಿ ದೆನಾರ್ ಕಚಾಪ ಕಾಯ್ ನಾಹಿ ತ್ಯಚಿಪ್ನಿ ಆಸ್‌ಲ್ಯಾ ಸಗ್ಳ ಕಾಡುನ್ ಗೆನಾರ್” ಮನ್ಹುನ್ ಮಿ ತುಮಾನಾ ಸಾಂಗ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","ಆನಿ ಮಿ ಆಪ್ಲಾ ರಾಜಾ಼ ವ್ಹಯಾಚ಼ ಮನಾತ್ ನಾಹಿ ಮನ್ಹುನ್ ಸಾಂಗ್‍ಲ್ಯಾಲ್ಯಾ ತ್ಯಾ ಮಾಜಾ ವೈರಿನಾ ಹಿತ್ತ ಮಾಜೆ ಮೊರ‍್ಹ ಆನುನ್ ಮಾರುನ್ ಟಾಕಾ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","ಯೇಸುನಿ ಹೆ ಸಬಾತ್ ಸಾಂಗ್‍ಲ್ಯಾ ನಂತರ್ ಯೆರುಸಲೆಮಿಕ್ಡ ಮೊರ‍್ಹ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","ನಂತರ್ ತ್ಯೊ ಒಲೀವ್ ತೆಲಾಚಾ ಜಾ಼ಢಾಂಚಾ಼ ಗುಢಾ ಮಂಥ್ಯಾಲ್ಯಾ ಗುಢ್ಯಾಚೆ ಜ಼ವಳ್ ಆಸ್‍ಲ್ಯಾಲೆ ಬೆತ್ಸೆಬಾ ಆನಿ ಬೆತಾನ್ಯಾಚೆ ಜ಼ವಳ್ ಆಲಾ ತವಾ ಶಿಶಾತ್‍ಲ್ಯಾ ದೊಗಾನಾ ಹಾಕ್ಟುನ್ ತುಮ್ಚೆ ಮೊರ‍್ಹ ಆಸ್‍ಲ್ಯಾಲ್ಯಾ ಗಾವಾತ್ ಜಾ಼ವಾ; ");
INSERT INTO gok_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ತುಮಿ ತಿಥ ಜಾ಼ತಾನಾಸ್ ತಿಥ ಬಾಂದ್‍ಲ್ಯಾಲ ಯಾಕ್ ಗಾಡ್ವಾಚ಼ ಪ್ವಾರ್ ದಿಸಲ್: ಆಜು಼ನ್ ಪರ‍್ಯಾತ್ ತ್ಯಚಿವ ಕೊನ್ ಬಸ್ಲ ನಾಹಿ; ತ್ಯ ಸುಡುನ್ ದರುನ್ ಆನಾ ");
INSERT INTO gok_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","ಕಚಾನಿ ತರಿ ತುಮಾನಾ ಕಾ ತ್ಯ ಶೊಡ್ತಾಸಾ ಮನ್ಹುನ್ ಇಚಾರ್ಲತ ಹ್ಯ ಪ್ರಭುಲಾ ವ್ಹಯಿ ಜಾ಼ಲ್ಯಾ ಮನ್ಹಾ. ಮನ್ಹುನ್ ಸಾಂಗುನ್ ಲಾವುನ್ ದಿಲ. ");
INSERT INTO gok_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","ಲಾವುನ್ ದಿಲ್ಯಾಲ್ಯಾಂಚಾನಿ ಜಾ಼ವುನ್ ತ್ಯನಿ ಆಪ್‌ಲ್ಯಾನಾ ಸಾಂಗ್‍ಲ್ಯಾ ಶಾರ್ಕ ಗಾಡ್ವಾಲಾ ಬಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","ತೆ ದೊಗ ಶಿಶಾ ಗಾಡ್ವಾಚಾ಼ ಪೆಟಾ ಶೊಡ್ತಾ ಆಸ್ಥಾನಾ ತ್ಯಚಾ ದನ್ಯಾನಿ, “ತ್ಯಲಾ ಕಾ ಶೊಡ್ತಾಸಾ” ಮನ್ಹುನ್ ತ್ಯನಾ ಇಚಾರ್ಲ್ಯಾಲ್ಯಾಲಾ ");
INSERT INTO gok_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","ತ್ಯಂಚಾನಿ, “ಹ್ಯ ಪ್ರಭುಲಾ ವ್ಹಯಿಜಾ಼ಲ್ಯಾ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","ತ್ಯಾ ಗಾಡ್ವಾಲಾ ಶಿಶಾಂಚಾನಿ ಯೇಸುಪ ಆನುನ್ ಆಪ್ಲ ಕಪ್ಡ ತ್ಯಚಿವ ಗಾಲ್ಹುನ್ ಯೇಸುಲಾ ಬಸಿವ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","ಯೇಸು ಜಾ಼ಯಿತ್ ಆಸ್ಥಾನಾ ಲೊಕಾಂಚಾನಿ ಆಪ್ಲ ಕಪ್ಡ ವಾಟವ ಹಾತರ‍್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","ತ್ಯೊ ಯೆರಸಲೇಮಿಚೆ ಜ಼ವಳ್ ಆಲಾ ತವಾ ಒಲೀವ್ ತೆಲಾಚಾ ಜಾ಼ಢಾಚಾ ಗುಢ್ಯಾಚೆ ಉತಾರ್ಡಿಸ್ ಆಲಾ ತವಾ ಶಿಶಾಂಚಿ ಮಂಡಳಿ ಆನಂದ್ ವ್ಹವುನ್ ಆಪ್ನು ಬಗ್‍ಲ್ಯಾಲ್ಯಾ ಸಗ್‍ಳ್ಯಾ ಮೊಟ್ಯಾ ಕಾರ‍್ಯಾಂಚೆ ಗುಶ್ಟಿತ್ ದೇವಾಲಾ ವವ್ಯಾಳ್ಳಾ ");
INSERT INTO gok_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","ದೇವಾಚಾ ನಾವಾನಿ ಯನಾರ‍್ಯಾ ರಾಜಾಲಾ ಆಶಿರ್ವಾದ್ ಪರಲೊಕಾತ್ ಶಾಂತಿ ವರ್ಲೆ ದುನೆತ್ ಶಾಂತಿ ಗೌರವ್ ಮನ್ಹುನ್ ಮೊಟ್ಯಾನಿ ದೇವಾಲಾ ವವ್ಯಾಳಾಲಾ ಲಾಗ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","ತವಾ ಲೊಕಾತ್ನಿ ಥೊಡ ಫರಿಸಾಯಂಚಾನಿ ಯೇಸುಲಾ “ಪ್ರಭು ತುಜಾ ಶಿಶಾನಾ ದಪ್‌ಕ್ಯಾವ್” ಮನ್ಹುನ್ ಸಾಂಗ್‍ಲ್ಯಾಲ್ಯಾಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","ಯೇಸು, “ಹಿ ಲೊಕ ಗಪ್‍ ರಾಯ್ಲಿತತ ಹೆ ದೊಂಢ ವರಾಡ್ನಾರ್ ಮನ್ಹುನ್ ತುಮಾನಾ ಸಾಂಗ್ತೊ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","ಮಂಗ್ ಯೇಸು ಯೇರುಸಲೆಮಿಚೆ ಜ಼ವಳ್ ಆಲಾ ತವಾ ತ್ಯ ಶಾರ್ ಬಗುನ್ ರಡತ್. ");
INSERT INTO gok_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ಆಸ ಮನ್ಲಾ ತು ತರಿ ಸಮಾದಾನಾಲಾ ವ್ಹಯಿ ಜಾ಼ಲ್ಯಾಲ್ಯಾ ಹ್ಯಾ ದಿಸಾದಿಸಿ ಸಮಜು಼ನ್ ಗೆತ್ಲ ಆಸ್ಥತ ಖುಬ್ ಬರ ಹುತ್ತ ಫನ್ ಆತಾ ತ್ಯ ತುಜಾ ಡೊಳ್ಯಾನಾ ಆಡ್‌ಶಾ ಜಾ಼ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","ಕಾ ಮಂಜೆ ತ್ಯೊ ಯೊಳ್ ತುಮ್ಚಿವ ಆಲ್ಯಾ ವೈರಿ ಸರ್ಬವ್ಹಾರ ಕುಡುನ್ ತುಮಾನಾ ದರ್ಥಿಲ ಆನಿ ಸಗ್‌ಳ್ಯಾ ವಾಟಾ ಜಾ಼ಗ್ತಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","ತೇ ತುಲಾ ಪುರ್ತಿ ನಾಸ್ ಕರ್ನಾರ್ ತುಜೆ ಗ್ವಾಡ್ಯಾಂಚೆ ಆತ್ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ಲೊಕಾನಾ ನಾಸ್ ಕರ್ನಾರ್ ಯಕಾ ದೊಂಡ್ಯಾವ ಯೊಕ್ ದೊಂಢಾ ರಾನ್ಹಾರ್ ನಾಹಿ ಕಾ ಮಂಜೆ ದೇವ್ ತುಲಾ ರಕ್ಶನ್ ಕರಾಯಾ ಆಲಾ ತ್ಯ ತುಮಿ ವಳಕ್ಲ ನಾಹಿಸಾ. ");
INSERT INTO gok_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","ಮಂಗ್ ಯೇಸು ದೇವ್ಳಾತ್ ಜಾ಼ವುನ್ ಇಕರ‍್ಯಾನಾ ತಿಥ್ನಿ ಬಾಹಿರ್ ಗಾಲಾಯಾ ಲಾಗುನ್ ");
INSERT INTO gok_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ತ್ಯನಾ ಮಾಜ಼ ದಿವುಳ್ ಮಾಗ್ನ ಕರ್‌ತ್ಯಾಲ ದಿವುಳ್ ವ್ಹನಾರ್ ಮನ್ಹುನ್ ಧರ್ಮ ಶಾಸ್ತಾರಾತ್ ಲಿವ್‍ಲ್ಯಾ ನವ್ಹ; ಫನ್ ತುಮಿ ತ್ಯ ಚೊ಼ರಾಂಚಿ ಘಬ್ ಕೆಲೆಸಾ ಮನ್ಲಾ ");
INSERT INTO gok_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","ಆನಿ ಯೇಸು ಖಾಯಿಮ್ ದೇವ್ಳಾತ್ ಸಿಕ್ವಿತ್ ಹುತ್ತಾ. ತ್ಯವ್‍ಡ್ಯಾತ್ ದೊನ್ವಾ ಯಾಜಕ್ ಕ್ಯಾಯ್ದದಾರ್ ಲೊಕಾಂಚ಼ ಜಾಂತ ತ್ಯಲಾ ಠಾರ್ ಮಾರಾಯಾ ಯೊಳ್ ಸುದಿತ ");
INSERT INTO gok_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","ಫನ್ ಲೊಕ ತ್ಯಲಾ ಖಿಟುನ್ ತ್ಯಚ಼ ಶಿಕ್ಶನ್ ದ್ಯಾನ್ ದಿವುನ್ ಐಕಿತಿತ ಮನ್ಹು‍ನ್ ಕ್ಯಾ ಕರಾವ್ಹಯಿ ತ್ಯ ತ್ಯನಾ ಸಮ್‍ಜ಼ನಾ. ");
INSERT INTO gok_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","ಯಕಸಿ ಯೇಸು ದೇವ್ಳಾತ್ ಲೊಕಾನಾ ಉಪದೆಸ್ ಕರೀತ್ ಬರಿ ಖಬರ್ ಸಾಂಗ್ತಾನಾ ದೊನ್ವಾ ಯಾಜಕ್ ಕ್ಯಾಯ್ದವಾಲ್ಯಾನಾ ಮಂಡಳಿಚಾ ಜಾಂತ್ಯಾನಾ ಜ಼ಮವುನ್ ");
INSERT INTO gok_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ಪಾಟ್ಕನ್ ಯವುನ್, “ತು ಕಚಾ ಹಖಾನಿ ಹ್ಯ ಸಗ್ಳ ಕರ್ತೊಸ್? ಹ್ಯೊ ಹಾಖ್ ತುಲಾ ಕುನಿ ದಿಲಾ ಆಮಾನಾ ಸಾಂಗ್? ಮನ್ಹುನ್ ತ್ಯಲಾ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","ತವಾ ಯೇಸು ತ್ಯನಾ, “ಮಿ ದಿಖಿಲ್ ತುಮಾನಾ ಯೊಕ್ ಸಬೊತ್ ಇಚಾರ್ತೊ ಮನಾ ಸಾಂಗಾ. ");
INSERT INTO gok_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ಲೊಕಾನಾ ಬಾಪ್ತಿಸ್ಮಾ ದಿಯಾಚಾ಼ ಹುಕುಮ್ ಯೊಹಾನಾಲಾ ಪರಲೊಕಾತ್ನಿ ಆಲಾ ಕ್ಯಾ ಮಾನ್ಸಾಂಚಾಪ್ನಿ ಆಲಾ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","ತವಾ ತೇ, “ದೇವಾಪ್ನಿ ಆಲಾ ಮನ್ಹುನ್ ಆಮಿ ಸಾಂಗ್‍ಲ್ಯಾವ ತುಮಿ ತ್ಯಚಿವ ಕಾ ಇಸ್ವಾಸ್ ಥೆವ್ಲಾ ನಾಹಿಸಾ? ಮನ್ಹಾರ್. ");
INSERT INTO gok_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","ಮಾನ್ಸಾಂಚಿಪ್ನಿ ಆಲಾ ಮನ್‍ಲ್ಯಾವ ಲೊಕ ಸಗ್ಳಿ ಯೊಹಾನಾಲಾ ಪ್ರವಾದಿ ಮನ್ಹಿತಿತ ಮನ್ಹುನ್ ತೀ ಆಮಾನಾ ದೊಂಡ್ಯಾನಿ ಮಾರುನ್ ಟ್ಯಾಕ್ತಿಲ” ಮನ್ಹುನ್ ಆಪ್‌ಲ್ಯಾ ಆಪ್‌ಲ್ಯಾತ್ ಬುಲುನ್ ಗಿಹುನ್. ");
INSERT INTO gok_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","“ತ್ಯೊ ಕುಟ್ನಿ ಆಲ್ಯಾ ಆಮಾನಾ ಠಾವಾ ನಾಹಿ” ಮನ್ಹುನ್ ಉತ್ತರ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","ತವಾ ಯೇಸು ತ್ಯನಾ, “ಹ್ಯ ಸಗ್ಳ ಕಚಾ ಹುಕ್ಮಾನಿ ಕರ್ತೊ ತ್ಯ ಮಿ ತುಮಾನಾ ಸಾಂಗಿತ್ ನಾಹಿ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","ತವಾ ಯೇಸು ಲೊಕಾನಾ ಯೇಕ್ ಕ್ಯಾಯ್ನಿ ಸಾಂಗಾಯಾ ಲಾಗ್ಲಾ ತೀ ಕ್ಯಾ ಮಂಜೆ, “ಯಕಾ ಮಾನ್ಸಾನಿ ಯೊಕ್ ದರಾಕ್ಶಿಚಾ಼ ಮಳಾ ಲಾವುನ್ ತ್ಯೊ ದಿಸರ‍್ಯಾನಾ ಖಂಡಾನಿ ದಿವುನ್ ಆಪ್ನು ದುಸ್ರೆ ದೆಶೆತ್ ಜಾ಼ವುನ್ ತಿಥ ಖುಬ್ ದಿಸ್ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","ಸುಗ್ಗಿ ಆಲಿ ತವಾ ದನ್‌ಹ್ಯಾನಿ ದರಾಕ್ಷಿಚಾ ಮಳ್ಯಾಚಾ಼ ಆಪ್ಲಾ ಖಂಡ್ ದೇವಾ ಮನ್ಹುನ್ ತ್ಯಂಚಿಪ ಆಪ್‌ಲ್ಯಾ ಯಕಾ ಆಳಾಲಾ ಲಾವುನ್ ದಿಲಾ; ತವಾ ತ್ಯಾ ಖಂಡ್ ಕರ‍್ಯಾನಿ ತ್ಯಲಾ ಬಡವುನ್ ರಿಕಾಮಾ ಲಾವುನ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","ಆನಿಕ್ ದನ್ಯಾನಿ ದಿಸರ‍್ಯಾ ಯಕಾ ಆಳಾಲಾ ಲಾವುನ್ ದಿಲಾ; ತ್ಯಲಾಬಿ ತ್ಯನಿ ಬಡವುನ್ ತ್ಯಚಿ ಮರ‍್ಯಾದ್ ಕಾಡುನ್ ರಿಕಾಮಾ ಲಾವುನ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","ಆನಿಕ್ ದನ್ಯಾನಿ ತಿನವ್ಯಾಲಾ ಲಾವುನ್ ದಿಲಾ ತ್ಯಲಾಬಿ ತ್ಯನಿ ಘಾವ್ ವ್ಹಯಿ ಜೊ಼ಗಾ ಮಾರುನ್ ಬಾಹಿರ್ ಗ್ಯಾತ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","ತವಾ ತ್ಯಾ ದರಾಕ್ಶಿಚಾ ಮಳ್ಯಾಚಾ ದನ್ಹಿ, “ಮಿ ಕ್ಯಾ ಕರು? ಮಾಜಾ ಲ್ಯಾಡ್‍ಕ್ಯಾ ಲೇಕಾಲಾ ಲಾವುನ್ ದೇತೊ ಯೇಕ್ ವೆಳಿ ತ್ಯಲಾತರಿ ಮರ‍್ಯಾದ್ ದಿತಿಲ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","ಖರ ಲಾವುನ್ ದಿಲಾ ತವಾ ತ್ಯಾ ಖಂಡ್ ವಾಲ್ಯಾಂಚಾನಿ‌ ತ್ಯಲಾ ಬಗುನ್, “ಹ್ಯೊಸ್ ವಾರಸ್ ದಾರ್ ಹ್ಯಲಾ ಮಾರುನ್ ಟಾಕುಯಾ ಹ್ಯಚಿ ಆಸ್ಥಿ ಆಮ್ಚಿ ವ್ಹವುನಿ” ಮನ್ಹುನ್ ಯಕಾ ಮಕಾ ಸಂಗ ಬುಲುನ್ ಗಿಹುನ್. ");
INSERT INTO gok_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","ತ್ಯಲಾ ದರಾಕ್ಶಿಚಾ ಮಳ್ಯಾತ್ನಿ ಬಾಹಿರ್ ಡಕ್ಲುನ್ ಮಾರುನ್ ಟ್ಯಾಕ್ಲಾ ತಸ ಜಾ಼ಲ್ಯಾ ದರಾಕ್ಶಿಚಾ ಮಳ್ಯಾಚಾ಼ ದನ್ಹಿ ಖಂಡ್ ವಾಲ್ಯಾನಾ ಕ್ಯಾ ಕರ್ನಾರ್? ಮನ್ಹುನ್ ಯೇಸುನಿ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","ತ್ಯೊ ಯವುನ್ ತ್ಯಾ ಖಂಡ್ವಾಲ್ಯಾನಾ ಮಾರುನ್ ಟಾಕುನ್ ಆಪ್ಲಾ ಮಳಾ ದಿಸರ‍್ಯಾ ಲೊಕಾನಾ ಖಂಡಾನಿ ದಿಯಿಲ್ ಮನ್ಲಾ. ಹ್ಯ ಲೊಕಾಂಚಾನಿ ಐಕುನ್, “ತಸ ವ್ಹವು ನಾಹಿ” ");
INSERT INTO gok_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","ಮನ್ಲಿತ ಖರ ಯೇಸುನಿ ತ್ಯನಾ ನದಾರ್ ಥಿವುನ್, “ತಸ ಜಾ಼ಲ್ಯಾ ಘರ್ ಬ್ಯಾಂತ್ಯಾಲ್ಯಾನಿ ನಕೊ ಮನ್ಹುನ್ ಶೊಡ್‍ಲ್ಯಾಲಾ ದೊಂಡ್ಹಾಸ್ ಕೊನ್ಯಾಲಾ ವ್ಹಯಿ ಜಾ಼ಲಾ ಮನ್ಹುನ್ ಕ್ಯಾಯ್‌ದ್ಯಾತ್ ಲಿವ್‍ಲ್ಯಾಲ್ಯಾ ಸಬ್ದಾಚಾ಼ ಆರ್ಥ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","ಹ್ಯಾ ದೊಂಡ್ಯಾವ ಪಡ್‍ತ್ಯಾಲ್ಯಾ ಪರ್ತೆಕಾಚ಼ ತುಕ್ಡ ತುಕ್ಡ ವ್ಹನಾರ್; ಹ್ಯೊ ಕುನಾ ಕುನಾವ ಪಡಲ್ ತ್ಯಚಿ ಪುಡಿ ಪುಡಿ ವ್ಹನಾರ್!” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","ಕ್ಯಾಯ್ದದಾರ್ ಆನಿ ಮುಖ್ಯ ಯಾಜಕಾಂಚಾನಿ ಹೆ ಸಬಾತ್ ಐಕುನ್, “ಆಮ್ಚಿಸ್ ಲಾಗುನುಸ್ ಹಿ ಕ್ಯಾಯ್ನಿ ಸಾಂಗ್ಲಿ” ಮನ್ಹುನ್ ಸಮಜು಼ನ್ ತೇಸ್ ಗಟ್ಕಲಾ ತ್ಯಲಾ ದರಾಯಾ ಯೇಳ್ ಶುದ್ಲಿ; ಫನ್ ತ್ಯನಾ ಜಾ಼ಲ ನಾಹಿ ತೆ ಲೊಕಾನಾ ಬಿಹ್ಯಾಲ. ");
INSERT INTO gok_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","ಮಂಗ್ ತೇ ಯೇಸುಲಾ ರೊಮ್ ಅಧಿಕಾರ‍್ಯಾಚೆ ತಾವ್ಡತ್ ದಿಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ನಿಯೆತಿಚಾಂಚೆಗತ್ ನಾಟಕ್ಯಾ ಲೊಕಾನಾ ತ್ಯಚೆ ಗುಶ್ಟಿತ್ ಕಾಯ್ ತರಿ ಚು಼ಕ್ ದರಾಯಾ ಲಂಚಾ಼ ದಿವುನ್ ಯೇಸುಪ ಲಾವುನ್ ದಿಲ. ");
INSERT INTO gok_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","ಹೆ ಮನ್ಲ, “ಪ್ರಭು ತು ಠಿಕ್ ಬೊಲ್ತೊಸ್, ಆನಿ ಸಿಕಿವ್ತೊಸ್ ತು ತ್ವಾಂಡ್ ಬಗುನ್ ನವ್ಹ ದೇವಾಚಾ಼ ಮಾರ್ಗ ಖರಾ ಸಾಂಗ್ತೊಸ್ ಮನ್ಹುನ್ ಠಾವ ಹಾ, ಮಾನ್ಸಾವ ದೇವಾಚಾ ಉದ್ದೆಸ್ ಕ್ಯಾ ಹಾ. ಮನ್ಹುನ್ ಸಾಂಗ್ತೊಸ್ ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","ರೊಮ್ ಚಕ್ರವರ್ತಿಲಾ ಕರ್ ದಿಯಾಚ಼ ಹಾ ಕ್ಯಾ ನಾಹಿ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","ಯೇಸುನಿ ತ್ಯಂಚ಼ ಕಪಟ್ ಫನ್ ವಳ್ಕುನ್ ತ್ಯನಾ, ");
INSERT INTO gok_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“ಮನಾ ಯೊಕ್ ಚಾ಼ಂದಿಚಾ಼ ಪೈಸಾ ದಾವಾ ಹ್ಯಚಿವ ಕುನಾಚಾ಼ ಮುಖಾಡಾ ಆನಿ ಲಿವ್ನ ಹಾ” ಮನ್ಹುನ್ ಇಚಾರ್ಲ್ಯಾಲ್ಯಾಲಾ ತೇ, “ಕೈಸರಾಚಾ಼” ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","ಯೇಸು ತ್ಯನಾ, “ತಸ ಜಾ಼ಲ್ಯಾ ಕೈಸರಾಚ಼ ಕೈಸರಾಲಾ ದೇವಾ ಆನಿ ದೇವಾಚ಼ ದೇವಾಲಾ ದೇವಾ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","ತವಾ ತ್ಯನಾ ಲೊಕಾಂಚೆ ಹುಜು಼ರ್ ತ್ಯಚಾ ಬೊಲ್‍ನ್ಯಾತ್ ಕಾಯ್ ಚು಼ಕ್ ದರಾಯಾ ವ್ಹಯಿನಾ ಆನಿ ತ್ಯನಿ ದಿಲ್ಯಾಲ್ಯಾ ಉತ್ತರಾಲಾ ಆಜಾಬ್ ವ್ಹವುನ್ ಗಪ್ ಜಾ಼ಲ. ");
INSERT INTO gok_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","ಮಂಗ್ ಮರ್ನಾತ್ನಿ ಉಠುನ್ ಯಯಿತ್ನಾಹಿತ ಮಂಥ್ಯಾಲ್ಯಾ ಸದುಕಾಯಾತಲ್ಯಾ ಥೊಡ್ಯಾಂಚಾನಿ ಯವುನ್ ");
INSERT INTO gok_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","ತ್ಯಲಾ ಯೆಕ್ ಪ್ರಶ್ನೆ ಇಚಾರ್ಲಿ ಪ್ರಭು ಮೊಶೆನಿ ಆಮಾನಾ ಆಸ ಲಿವುನ್ ಥೆವ್‌ಲ್ಯಾ ಯೊಕ್ ಮಾನುಸ್ ಮರುನ್ ತ್ಯಚೆ ಬ್ಯಾಯ್ಕೊಲಾ ಪೊರ ನಸ್ಥಾನಾ ತ್ಯಚಾ ಬಾವ್ಹಾನಿ ತ್ಯಚೆ ಬ್ಯಾಯ್ಕೊಲಾ ಲಗಿನ್ ವ್ಹವುನ್ ತಿಲಾ ಪೊರ ಜಾ಼ಲ್ಹಿತಕಿ ತೀ ಪೊರ ಮೆಲ್ಯಾಲ್ಯಾಚಿ ವ್ಹತ್ಯಾತ? ");
INSERT INTO gok_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","ತಸ ಸಾತ್ ಜಾ಼ನ್ ಬಾಹು ರಾಯ್ಲತರಿ ಆಂದಿಚಾನಿ ಲಗಿನ್ ವ್ಹವುನ್ ಪೊರ ನಸ್ಥಾನಾ ಮೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","ದೋನ್ವಾಬಿ ತಸಾಸ್ ವ್ಹವುನ್ ಮೆಲಾ ");
INSERT INTO gok_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ತಿನ್ವಾಬಿ ತಿಲಾ ಲಗಿನ್ ಜಾ಼ಲಾ ಆಸ್ಹಸ್ ಸಾತ್ ಜ಼ನಾಂಚಾನಿ ಲಗಿನ್ ವ್ಹವುನ್ ಪೊರ ನಸ್ಥಾನಾ ಮೇಲ್ಹ. ");
INSERT INTO gok_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","ಮಾಗ್ನಿ ತೀ ಬಾಯಿಲ್ ಮಾನುಸ್ ಬಿ ಮೀಲಿ, ");
INSERT INTO gok_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","ತಸ ಜಾ಼ಲ್ಯಾ ಮರ್ನಾತ್ನಿ ಉಠುನ್ ಯತ್ತಾನಾ ತೀ ಬಾಯಿಲ್ ಮಾನುಸ್ ತ್ಯಾತ್‌ಲ್ಯಾ ಕಚಾಚಿ ಬ್ಯಾಯ್ಕೊ ವ್ಹವುನ್ ರಾನ್ಹಾರ್? ತಿಲಾ ಸಾತ್ ಜಾ಼ನ್ ಬಿ ಯಕಾ ಮಾಗ ಯೆಕ್ ಲಗಿನ್ ಜಾ಼ಲ್ಯಾತ ನವ್ಹ” ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","ಯೇಸುನಿ ತ್ಯನಾ, “ಹ್ಯಾ ಪ್ರಪಂಚಾತ್ಲಿ ಗಡಿ ಆನಿ ಬ್ಯಾಯ್ಕಾ ಮಾನ್ಸ ಲಗಿನ್ ಕರುನ್ ಗೆಥ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","ಫನ್ ಪ್ರಪಂಚಾತ್ಲಿ ಮರ್ನಾತ್ನಿ ಉಠುನ್ ಯಯಾ ಚಾ಼ಂಗ್ಲ ಆಸ್‌ಲ್ಯಾಲಿ ಥುಡಿ ಲೊಕ ಉಠುನ್ ಯವುನ್ ಜೀವ್ನಾ ಕರ್ತ್ಯಾತ ಆನಿ ಲಗಿನ ಕರುನ ಗಿಹಿತ್ ನಾಹಿತ. ");
INSERT INTO gok_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","ತಿಥ್ನಿ ಮೊರ‍್ಹ ತಿ ಮರನಾಲಾ ಥರತ್ ನಾಹಿತ ಮರ್ನಾತ್ನಿ ಉಠುನ್ ಯವುನ್ ದೇವ್ ದುತಾಂಚೆಗತ್ ವ್ಹವುನ್ ದೇವಾಚಿ ಮುಲ ಜಾ಼ಲ್ಯಾತ ಮೆಲ್ಯಾಲಿ ಜಿತ್ತಿ ವ್ಹವುನ್ ಉಟ್ಯಾತ ");
INSERT INTO gok_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","ಮನ್ಹುನ್ ಮೊಶೆನಿ” ಸಾಂಗ್‍ಲ್ಯಾ. ತ್ಯನಿ ಜಾ಼ಳಿಚಿ ಖನ್ಕತಿ ಆಸ್‍ಲ್ಯಾಲ್ಯಾ ಆಜ್ಞಾತ್ ಪರಮೇಶ್ವರಾಲಾ ಅಬ್ರಹಾಮಾಚಾ಼ ದೇವ್ ಇಸಾಕಾಚಾ ದೇವ್, ಯಾಕೊಬಾಚಾ ದೇವ್, ಮನ್ಹುನ್ ಸಾಂಗ್‍ಲ್ಯಾ ");
INSERT INTO gok_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","ದೇವ್ ಜಿತ್ಯಾನಾ ದೇವ್ ಜಾ಼ಲ್ಯಾ ತ್ಯ ಸೂಡುನ್ ಜೀವ್ ನಸ್‍ನಾರ‍್ಯಾಲಾ ನವ್ಹ. ತ್ಯಲಾ ಸಗ್ಳಿ ಜ಼ಗನಾರಿ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","ಶಾಸ್ತ್ರಿತ್ಲ ಥೊಡ, “ಪ್ರಭು ಚಾ಼ಂಗ್ಲ ಸಾಂಗ್ಲಸ್ ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","ತ್ಯಲಾ ಆನಿಕಾಯ್ ಇಚಾರಾಯಾ ತ್ಯನಾ ಧಿರ್ ಜಾ಼ಲಾ ನಾಹಿ ಮನ್ಹುನ್ ಕುನಿ ಪ್ರಶ್ನೆ ಇಚಾರ್ಲ ನಾಹಿತ. ");
INSERT INTO gok_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","ತವಾ ಯೇಸು, “ಯನಾರಾ ಕ್ರಿಸ್ತ ದಾವಿದಾಚಾ ವಂಶಾಚಾ ಮಂಥ್ಯಾತ ನವ್ಹ, ತ್ಯ ಕಸ ವ್ಹಯಿಲ್? ");
INSERT INTO gok_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","ಕಿರ್ತನೆತ್ ದಾವಿದುಸ್ ಸಾಂಗ್‍ತ್ಯೊ ಪರಮೇಶ್ವರಾನಿ ಮಾಜಾ ದನ್ಯಾಲಾ ಕ್ಯಾ ಸಾಂಗ್ಲ. ಮಂಜೆ ಮಾಜೆ ಉಜ಼ವ್ಯಾಂಗ್ನಿ ಬಸುನ್ ರ‍್ಹಾ. ");
INSERT INTO gok_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ಮಿ ತುಜಾ ವೈರಿನಾ ತುಜಾ ಪಾಯಾ ಬುಡಿ ಥಿವಿ ಪರ‍್ಯಾತ್ ");
INSERT INTO gok_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","ದಾವಿದ್ ಮೆಶಾಯಾಲಾ ದನ್ಹಿ ಮನ್‌ಲ್ಯಾವ ಯೇಸು ದಾವಿದಾಚಾ ವಂಶಾವಳಿತ್ಲಾ ಕಸಾ ವ್ಹನಾರ್” ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","ಮಂಗ್ ಲೊಕ ಸಗ್ಳಿ ಐಕ್ತಾ ಆಸ್ಥಾನಾ ತ್ಯನಿ ಆಪ್‌ಲ್ಯಾ ಶಿಶಾನಾ ಕ್ಯಾ ಸಾಂಗ್ಲ ಮಂಜೆ. ");
INSERT INTO gok_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","ಕ್ಯಾಯ್ದ ವಾಲ್ಯಾಂಚೆ ಗುಶ್ಟಿತ್ ಹುಶಾರ್ ರಾವ್ಹಾ ತೇ ಲಾಮ್ ಜ಼ಘ ಗಾಲ್ಹುನ್ ಫಿರಾಯಾ ಮನ್‌ ಕರ್ತ್ಯಾಲ ಬಾಜಾ಼ರಾತ್ನಿ ಪಾಂದಿತ್ನಿ ನಮಸ್ಕಾರ್ ಸಭಾಸ್ಥಾನಾತ್ ಪೈಲಾ ಜಾ಼ಗಾ ಜೆ಼ವ್ನಾಚೆ ಪಂಗತಿತ್ ಪೈಲಾ ಜಾ಼ಗಾ ಬಗ್‌ತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","ತೇ ವಿದ್ವೆಂಚ಼ ಪೈಸ ಕಾಡುನ್ ಗೆಥ್ಯಾತ ದೇವಾಪ ಲಾಮ್ ಲಾಮ್ ಮಾಗ್ನಿ ಕರ್ತ್ಯಾತ ಆಸ್‍ಲ್ಯಾನಾ ಖುಬ್ ಮುಟಿ ಸಿಕ್ಶಾ ವ್ಹನಾರ್” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","ಯೇಸುನಿ ನದಾರ್ ವರ್ ಕರುನ್ ಬಗ್ಲ ತವಾ ಥೊಡಿ ಸಾವ್ಕಾರ್ ಲೊಕ ದೇವ್ಳಾತ್ಲೆ ಪಿಟಿತ್ ದಿನ್ಗಿ ಗ್ಯಾಲತ್ಯಾಲಿ ದಿಸ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","ತವಾ ಯೇಕ್ ಗರಿಬ್ ವಿದವೆನಿ ದೊನ್ ಆನ ಗ್ಯಾತ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","ತೆ ಯೇಸುನಿ ಬಗುನ್, “ತುಮಾನಾ ಖರ‍್ಯಾನಿ ಸಾಂಗ್ತೊ ಹೆ ಗರಿಬ್ ವಿದವೆನಿ ಸಗ್‍ಳ್ಯಾಂಚಿವ್ನಿ ಜಾಸ್ಥಿ ಗ್ಯಾತ್ಲ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","ಕಸ ಮಂಜೆ ತ್ಯಾ ಸಗ್‍ಳ್ಯಾಂಚಾನಿ ಆಪ್‌ಲ್ಯಾನಾ ಪುರೊ ವ್ಹವುನ್ ಉರ್‌ಲ್ಯಾಲ್ಯಾತ್ಲ ದಿನ್ಗಿ ದಿಲೆ; ಹಿನಿ ಆಪ್ಲೆ ಗರಿಬ್ ತಿತ್ ಆಪ್‌ಲ್ಯಾ ಜೀವ್ನಾಲಾ ಆಸ್‍ಲ್ಯಾಲ ಸಗ್ಳ ದಿಲ್ಯಾ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","ಶಿಶಾತ್ಲ ಥೊಡ ಜಾ಼ನ್ ದೀವುಳ್ ಚಾ಼ಂಗಲ್ಯಾ ದೊಂಡ್ಯಾಂಚಾನಿ ಆನಿ ಮಾಗ್ನ ಕೆಲ್ಯಾಲ್ಯಾ ದಾಗಿನ್ಯಾಂಚಾನಿ ಸುಬಿವ್‍ಲ್ಯಾ!” ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","ಫನ್ ಯೇಸುನಿ ತ್ಯನಾ, “ತುಮಿ ಹ್ಯ ಸಗ್ಳ ಬಗ್ತಾಸಾ ಹಿತ್ತ ದೊಂಡ್ಯಾವರ್ ದೊಂಢ ರಾಹ್ಯಾಚೆ ಆಂದಿ ಸಗ್ಳ ಪಾಡುನ್ ಗಾಲ್ಹಾಚ಼ ದಿಸ್ ಯನಾರ್” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","ತವಾ ಶಿಶಾಂಚಾನಿ, “ಪ್ರಭು ತ್ಯ ಕವಾ ವ್ಹನಾರ್? ತ್ಯ ವ್ಹತಾನಾ ಕ್ಯಾ ವಳಕ್ ದಿಸ್ನಾರ್? ಮನ್ಹುನ್ ತ್ಯಲಾ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","ತವಾ ಯೇಸುನಿ ಕ್ಯಾ ಸಾಂಗ್ಲ ಮಂಜೆ, “ತುಮಿ ಫಸು ನಾಹಿ ಆಸ ಬಗಾ ಕಾ ಮಂಜೆ ಖುಬ್ ಜಾ಼ನ್ ಯವುನ್ ಮಾಜ಼ ನಾವ್ ಸಾಂಗುನ್ ಮಿಚ್ ಕ್ರಿಸ್ತ ಮಿಚ್ ಕ್ರಿಸ್ತ ಮನ್ಹುನ್ ತೆ ದಿಸ್ ಜ಼ವಳ್ ಆಲ ಮನ್ಹುನ್ ಸಾಂಗ್ತಿಲ: ತ್ಯಂಚೆ ಮಾಗ್ನಿ ಜಾ಼ವು ನಕೊಸಾ, ");
INSERT INTO gok_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","ತ್ಯವ್ಡಸ್ ನವ್ಹ ಮಾರಾಮಾರ‍್ಯಾ ಗೊಂದೊಳ್ ವ್ಹತ್ಯಾಲ ತುಮಿ ಐಕ್ತಾನಾ ಗಾಬ್ರು ನಕೊಸಾ; ಕಾ ಮಂಜೆ ಹ್ಯ ಸಗ್ಳ ಆಂದಿ ವ್ಹಯಾಚಿ ಗರಜ಼್ ಹಾ; ಫನ್ ತವಾಸ್ ಸಮಾಪ್ತ್ ವ್ಹನಾರ್ ನಾಹಿ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","ಮಂಗ್ ಯೇಸುನಿ ತ್ಯನಾ ಕ್ಯಾ ಸಾಂಗ್ಲ ಮನ್‌ಲ್ಯಾವ, “ದೇಶಾಂಚೆ ವರ್ ದಿಸ್ರಿ ದೇಶಾ ರಾಜಾಂಚೆ ಆಡ್ವ ದಿಸ್ರಾ ರಾಜ಼ ಉಟ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","ಆನಿ ಮೊಟಾ ಭೂಕಂಪ ವ್ಹನಾರ್; ಜಾ಼ಗ ಜಾ಼ಗ ಬರ್ಗಾಲ್ ಪಡ್ನಾರ್; ಉಪದ್ರವಾತ್ ಆನಿ ಆಬ್ಳಾತ್ ಮುಟಿ ಕಾಮ ಗಡ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","ಫನ್ ಹ್ಯ ಸಗ್ಳ ವ್ಹಯಾಚೆ ಆಂದಿ ತೆ ತುಮಾನಾ ದರುನ್ ಸಭಾಸ್ಥಾನಾತ್ ಆನಿ ಕಚ್ಚೆರಿತ್ ಕುಂಡುನ್ ಅಧಿಕಾರ‍್ಯಾಂಚಾ ತಾಬ್ಯಾತ್ ದಿವುನ್ ಮಾಜಾ ನಾವಾಪಸುನ್ ರಾಜಾಂಚೆ ಮೊರ‍್ಹ ಜಾ಼ಚ಼್ ದೇನಾರ್ ");
INSERT INTO gok_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","ಹಿ ಬರಿ ಖಬರ್ ಸಾಂಗಾಯಾ ತುಮಾನಾ ಉಪೆಗ್ ವ್ಹನಾರ್ ");
INSERT INTO gok_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","ತ್ಯಾ ಯಳಾಲಾ ಕ್ಯಾ ಉತ್ತರ್ ದಿಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ತುಮಿ ಆಂದಿಸ್ ಕ್ಯಾಳ್ಜಿ ಕರುನಕೊಸಾ. ");
INSERT INTO gok_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","ಕಾ ಮಂಜೆ ತುಮ್ಚ ವಾದಿ ಸಗ್ಳ ಮೊರ‍್ಹ ಉಬರಾಹ್ಯಾ ಮೊರ‍್ಹ ಬೊಲಾಯಾ ವ್ಹವುನಾಹಿ ಆಸ್ಲ ಬೊಲ್‌ನ್ಯಾಚ಼ ಗಿನ್ಯಾನ್ ಮೀಸ್ ತುಮಾನಾ ದೆತೊ ");
INSERT INTO gok_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","ಫನ್ ತುಮ್ಚೆ ಆಯಿಬಾ, ಬಾಹು, ಮಾಯಾದಯಾಚ಼, ಸುಪ್ತಿ, ತುಮಾನಾ ದರೂನ್ ದೆನಾರ್ ಆನಿ ತುಮ್ಚಾತ್‍ಲ್ಯಾ ಖುಬ್ ಜ಼ನಾನಾ ಜೀವಾನಿ ಮ್ಯಾರ‍್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","ಆನಿ ಮಾಜಿಸ್ ಲಾಗುನ್ ಸಗ್ಳಿ ಲೊಕ ತುಮಚಾ಼ ರಾಗ್‌ ಕರ್ನಾರ್ ");
INSERT INTO gok_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","ಫನ್ ತುಮ್ಚೆ ಡುಯಿತ್ಲಾ ಯೊಕ್ ಕ್ಯೊಸ್ ಸಾಹಿತ್ ನಾಸ್ ವ್ಹನಾರ್ ನಾಹಿ ");
INSERT INTO gok_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","ತುಮಿ ಇಸ್ವಾಸಾತ್ ಘಟ್ ದಿರ‍್ಹಾನಿ ರಾವಾ ತವಾ ತುಮಚಾ಼ ಜೀವ್ ಮಿಳಿವ್ಸಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","ಫನ್ ಯೆರುಸಲೇಮಿತ್ ಸೈನ್ಯಾಂಚಾ಼ ಯಡಾ ಪಡ್‍ಲ್ಯಾಲಾ ತುಮಿ ಬಗ್ತಾನಾ ತ್ಯ ನಾಸ್ ವ್ಹಯಾಚಾ಼ ಕಾಲ್ ಜ಼ವಳ್ ಆಲ್ಯಾ ಮನ್ಹುನ್ ಸಮ್ಜುನ್ ಗೆವ್ಹಾ. ");
INSERT INTO gok_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","ತವಾ ಯುದಾಯಾತ್ ಆಸ್‍ಲ್ಯಾಲಿ ಗುಢ್ಯಾಂಚಿವ ಪಳುನ್ ಜಾ಼ವುಂತ; ಕೊನ್ ಪೆಠತ್ ಆಸ್‌ಲ್ಯಾಲಿ ಪ್ಯಾಟ್ ಸುಡುನ್ ಜಾ಼ವುಂತ. ಸೇತಾತ್ನಿ ಆಸ್‌ಲ್ಯಾಲಿ ಪೆಠ್ಹತ್ನಿ ಜಾ಼ವು ನಾಹಿತ. ");
INSERT INTO gok_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","ಕಾ ಮಂಜೆ ಕ್ಯಾಯ್‌ದ್ಯಾತ್ ಲಿವಲ್ಯಾಲ ಸಗ್ಳ ಗಢಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ತೇ ದಂಡಾಚ಼ ದೀಸ್ ಜಾ಼ಲ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","ತ್ಯಾ ದಿಸಾತ್ ಗರ್ವಾರ್ ಕರ್ನಿನಾ ತಾನ್ಯಾ ಬ್ಯಾಯ್ಕಾನಾ ವ್ಹತ್ಯಾಲಾ ತರಾಸ್ ಕ್ಯಾ ಸಾಂಗು? ಹೆ ಸಿಮವ ಮೊಟಾ ಸಂಕಟ್ ಯಯಿಲ್ ಹ್ಯಾ ಲೊಕಾಂಚಿವ ದೇವಾಚಿ ಮುಟಿ ಸಿಕ್ಶೆ ಯನಾರ್. ");
INSERT INTO gok_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","ತಿ ಥಲವಾರಾಂಚಿವ ಪಡ್ತಿಲ; ತ್ಯನಾ ಪರದೇಶೆತ್ನಿ ದರುನ್ ನೆನ್ಹಾರ್ ಪರ‍್ದೇಶೆತ್‍ಲ್ಯಾಂಚಾ಼ ಟಾಯಿಮ್ ಸಪ ಪರ‍್ಯಾತ್ ಯೆರುಸಲೇಮ್ ಪರದೇಶೆತ್‍ಲ್ಯಾಂಚಿಪ್ನಿ ತುಡುವುನ್ ಗಿಹುನ್ ರಾನ್ಹಾರ್. ");
INSERT INTO gok_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","ಆನಿ ದಿಸ್ ಚಾ಼ಂದ್ ಚಾನ್ಯಾತ್ನಿ ವಿಚಿತ್ರ ವಳಕ್ ದಿಸ್ನಾರ್ ದರ್ಥಿವ ಸಗ್‌ಳ್ಯಾ ದೇಶಾತ್ನಿ ತರಾಸ್ ಯನಾರ್ ಸಮಿಂದೋರಾಚ ಆನಿ ಲ್ವಾಟಾಂಚೆ ಆವಾಜಾ಼ನಿ ಲೊಕಾನಾ ಭೆ ಬರ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","ಆಬ್ಳಾತ್ಲಿ ಬಳ ಡಳಮಳ್ಳಿತ ಮನ್ಹುನ್ ಮಾನ್ಸ ಬಿಹುನ್ ಪರಪಂಚಾತ್ ಕ್ಯಾ ಯತ್ಯಾ ಮನ್ಹುನ್ ಬಿಹ್ಯಾಲಿತ. ");
INSERT INTO gok_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","ತ್ಯಾಸ್ ಯಳಾಲಾ ಮಾನ್ಸಾಚಾ಼ ಲ್ಯೊಕ್ ಬಳಾನಿ ಮೊಟೆ ಮೈಮೆನಿ ಡಘಾತ್ನಿ ಯತ್ಯಾಲಾ ತೀ ಬಗ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","ಫನ್ ಹ್ಯ ವ್ಹತಾನಾ ವರ್‍ ಬಗಾ, ತುಮ್ಚಿ ಡುಯಿ ಉಚ಼್ಲಾ ತುಮ್ಚಿ ಸುಟ್ನುಕ್ ಜ಼ವಳ್ ಆಲೆ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","ಯೇಸುನಿ ತ್ಯನಾ ಯೇಕ ಕ್ಯಾಯ್ನಿನಿ ಕ್ಯಾ ಸಾಂಗ್ಲ ಮಂಜೆ, “ಅಂಜು಼ರಾಚ಼ ಆನಿ ದುಸ್ರಿ ಜಾ಼ಡ ಬಗಾ ");
INSERT INTO gok_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","ತೀ ಪಾಲಾವ್ಲಿತ ಮಂಜೆ ತ್ಯ ತುಮಿ ಬಗುನ್ ಆತಾ ಉನಾಳಾ ಜ಼ವಳ್ ಆಲಾ ಮನ್ಹುನ್ ತುಮಿಸ್ ಸಮಜು಼ನ್ ಗೆಥಾಸಾ. ");
INSERT INTO gok_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","ತಸಸ್ ತುಮಿ ಹ್ಯ ಸಗ್ಳ ವ್ಹತ್ಯಾಲ ಬಗ್ತಾನಾ ದೇವಾಚ ರಾಜೆ ಖುಬ್ ಜ಼ವಳ್ ಹಾ ಮನ್ಹುನ್ ಸಮಜು಼ನ್ ಗೆವ್ಹಾ. ");
INSERT INTO gok_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","ಸಗ್ಳ ಹಿ ಗ್ಯೊಶ್ಟ್ ವ್ಹಯಿ ಪರ್ಯಾತ್ ಹಿ ಪಿಳ್ಗಿ ಮರುನ್ ಜಾ಼ನಾರುಸ್ ನಾಹಿ ಮನ್ಹುನ್ ತುಮಾನಾ ಖರ‍್ಯಾನಿ ಸಾಂಗ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","“ದರ್ಥಿ ಆಬಾಳ್ ಪುಸುನ್ ಜಾ಼ತಿಲ ಫನ್ ಮಾಜ಼ ಸಬಾತ್ ಕಂದಿಸ್ ಪುಸುನ್ ಜಾ಼ನಾರುಸ್ ನಾಹಿತ. ");
INSERT INTO gok_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","ತುಮ್ಚೆ ಗುಶ್ಟಿತ್ ಸಂಬಾಳುನ್ ರಾವ್ಹಾ. ಖಾದಿ ಪಿದಿನಿ ಪರಪಂಚಾಚೆ ಕ್ಯಾಳ್ಜಿನಿ ತುಮ್ಚಿ ಮನ್ ಬರ‍್ಹುನ್ ಜಾ಼ವುನ್ ತ್ಯೊ ದಿಸ್ ತುಮ್ಚಿವ ಆಚಾನಕ್ ಯಯಿಲ್. ");
INSERT INTO gok_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","ತ್ಯೊ ದಿಸ್ ಸಗ್‍ಳ್ಯಾ ಲೊಕಾಂಚಿವ ಫ್ಯಾಸ್‌ಕ್ಯಾಚೆಗತ್ ಯನಾರ್. ");
INSERT INTO gok_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","ಫನ್ ಯಯಿ ಆಸ್‍ನಾರ‍್ಯಾ ಹ್ಯಾ ಸಗ್‌ಳ್ಯಾ ಗುಶ್ಟಿತ್ನಿ ಚು಼ಕ್ವುನ್ ಗಿಹ್ಯಾ ಮಾನ್ಸಾಚಾ ಲೇಕಾಚೆ ಮೊರ‍್ಹ ಉಬಿರಾಹ್ಯಾ ತುಮಿ ಪುರಾ ಶಕ್ತ ವ್ಹಯಿ ಜೊ಼ಗ ಸಗ್‍ಳ್ಯಾ ಕಾಲಾತ್ ಜಾ಼ಗಿ ರಾಹುನ್ ದೇವಾಪ ಮಾಗ್ನ ಕರೀತ್ ಸಂಬಾಳುನ್ ರಾವ್ಹಾ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","ಯೇಸು ದಿಸಾಚಾ಼ ದೇವ್ಳಾತ್ ಶಿಕ್ವಿತ್ ರ‍್ಯಾಚಾ ಬಾಹಿರ್ ಜಾ಼ವುನ್ ಒಲೀವ್ ಜಾ಼ಢಾಚಾ ಗುಢ್ಯಾವ ರಾಹಿತ್ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","ಲೊಕ ಸಗ್ಳಿ ತ್ಯಚ಼ ಸಿಕ್ಶನ್ ಐಕಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಖಾಯಿಮ್ ಸಕಾಳ್ಚಿ ದೇವ್ಳಾತ್ ತ್ಯಚಿಪ ಯಯಿತಿತ. ");
INSERT INTO gok_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","ಆಂಬಾಟ್ ನಸ್‍ಲ್ಯಾಲ್ಯಾ ಬಾಕ್‌ರ‍್ಯಾ ಖಾತ್ಯಾಲಾ ವಲಾಂಡ್ಯಾಚಾ಼ ಸನ್ ಜ಼ವಳ್ ಆಲ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","ತವಾ ದೊನ್ವಾ ಯಾಜಕ್ ಆನಿ ಕ್ಯಾಯ್ದವಾಲ ಯೇಸುಲಾ ಠಾರ್ ಮಾರಾಯಾ ವ್ಹಯಿ ಮನ್ಹಿತ ಫನ್ ಮಾನ್ಸಾನಾ ಬಿಹುನ್ ಹ್ಯಚಾ಼ ಕಸಾ ಘಾತ್ ಕರಾಚಾ಼ ಮನ್ಹುನ್ ಇಚಾರ್ ಕರೀತ. ");
INSERT INTO gok_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","ತವಾ ಬಾರಾ ಜಾ಼ನ್ ಶಿಶಾತ್ಲಾ ಯುದ್ ಮಂಥ್ಯಾಲ್ಯಾತ್ ಸೈತಾನ್ ಬರ‍್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","ತವಾ ಯುದ್ ದೊನವ್ಯಾ ಯಾಜಕಾಂಚಿಕ್ಡ ಆನಿ ದೇವ್ಳಾಚಾ ಅಧಿಕಾರ‍್ಯಾಂಚಿಕ್ಡ ಗೆಲಾ ಆನಿ ತ್ಯಂಚಾ ಹಾತಾತ್ ಯೇಸುಲಾ ಕಸಾ ದರುನ್ ದಿಯಾಚಾ಼ ಹ್ಯ ತ್ಯನಿ ತ್ಯಂಚಿ ಸಂಗ ಬೊಲ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","ತವಾ ತ್ಯನಾ ಆನಂದ್ ಜಾ಼ಲಾ ಆನಿ ತ್ಯಂಚಾನಿ ತ್ಯಲಾ ಪೈಸ ದಿಯಾಚಾ಼ ಕರಾರ್ ಕೆಲಾ ");
INSERT INTO gok_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","ತ್ಯಲಾ ತ್ಯೊ ಹು ಮನ್ಲಾ ಆನಿ ಲೊಕಾಂಚಿ ಗರ್ದಿನಸ್ಹಲ್ ತವಾ ತ್ಯಂಚಾ ಹಾತಾತ್ ಯೇಸುಲಾ ದರುನ್ ದಿಯಾ ಯೇಳ್ ತ್ಯೊ ಬಗಾಯಾ ಲಾಗ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","ಮಂಗ್ ವಲಾಂಡ್ಯಾಚ಼ ಯಜ್ಞಪಶು ಮಾರಾಚ಼ ಆಂಬಾಟ್ ನಸ್‍ಲ್ಯಾಲ್ಯಾ ಬಾಕ್‌ರ‍್ಯಾ ಖಾಯಾಚಾ಼ ತ್ಯೊ ದಿಸ್ ಆಲಾ ");
INSERT INTO gok_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","ತವಾ ಯೇಸು ಪೇತ್ರಾಲಾ ಆನಿ ಯೊಹಾನಾಲಾ, “ತುಮಿ ಜಾ಼ವುನ್ ಆಮಿ ವಲಾಂಡ್ಯಾಚ಼ ಜೆವಾನ್ ಕರಾಯಾ ತಯಾರಿ ಕರಾ ಮನ್ಹುನ್ ಸಾಂಗುನ್ ತ್ಯನಾ ಲಾವುನ್ ದಿಲ ");
INSERT INTO gok_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","ತೇ ಆಮಿ ಕುಠ ತಯಾರಿ ಕರಾವ ಮಂಥೊಸ್? ಮನ್ಲ ");
INSERT INTO gok_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","ತವಾ ಯೇಸು ತ್ಯನಾ, “ತುಮಿ ಯೇರುಸಲೆಮ್ ಪೆಠತ್ ಗೆಲಾಸಾಕಿ ಯೊಕ್ ಮಾನುಸ್ ಬರಲ್ಯಾಲಿ ಗಾಘರ್ ಗಿಹುನ್ ತುಮ್ಚೆ ಮೊರ‍್ಹ ಯಯಿಲ್ ತ್ಯೊ ಜಾ಼ತ್ಯಾಲ್ಯಾ ಗರ‍್ಹಾತ್ ತುಮಿ ತ್ಯಚೆ ಮಾಗ್ನಿ ಜಾ಼ವುನ್ ");
INSERT INTO gok_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ತ್ಯಾ ಗರ‍್ಹಾಚಾ ದನ್‍ಹ್ಯಾಲಾ, “ಆಮ್ಚಾ ಪ್ರಭುನಿ ಆಪ್‌ಲ್ಯಾ ಶಿಶಾಂಚಿ ಸಂಗ ವಲಾಂಡ್ಯಾಚ಼ ಜೆವಾನ್ ಕರಾಯಾ ಜೆವ್ನಾಚಿ ಖುಲಿ ಕುಠ ಮನ್ಹು‍ನ್ ಇಚಾರಾ ");
INSERT INTO gok_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","ತ್ಯೊ ಸಗ್ಳ ಸಾಮಾನ್ ಆಂದಿಸ್ ಥೆವ್‍ಲ್ಯಾಲ ಮಾಳಿವ ಮುಟಿ ಖುಲಿ ತುಮಾನಾ ದಾವಿಲ್; ತಿಥ ತಯಾರ್ ಕರಾ ಮನ್ಹುನ್ ಸಾಂಗುನ್ ಲಾವುನ್ ದಿಲ. ");
INSERT INTO gok_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","ತೆ ನಿಗಾಲ ಆನಿ ಯೇಸುನಿ ಆಪ್‌ಲ್ಯಾನಾ ಸಾಂಗ್‍ಲ್ಯಾ ಶಾರ್ಕ ಬಗುನ್ ವಲಾಂಡ್ಯಾಚ಼ ಜೆವಾನ್ ತಯಾರ್ ಕೆಲ. ");
INSERT INTO gok_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","ಜೆವ್ನಾಚಾ಼ ಯೊಳ್ ಆಲಾ ತವಾ ಯೇಸು ಆಪ್‌ಲ್ಯಾ ಬಾರಾ ಅಪೊಸ್ತಲಾಂಚೆ ಸಂಗ ಜೆವಾಯಾ ಬಸ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","ತವಾ ಯೇಸುನಿ ತ್ಯನಾ, “ಮಿ ತರಾಸ್ ಖಾಯಾಚೆ ಆಂದಿ ತುಮ್ಚೆ ಸಂಗ ಹ್ಯ ವಲಾಂಡ್ಯಾಚ಼ ಜೆವಾನ್ ಖಾಯಾ ಖುಬ್ ಹಾವುಸ್ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","ಮಿ ತುಮಾನಾ ಸಾಂಗ್ತೊ ಹ್ಯಚಾ಼ ಖರಾ ಆರ್ಥ ದೇವಾಚಾ ರಾಜಾತ್ ಗಢ ಪರ‍್ಯಾತ್ ಮಿ ಹಿತ್ನಿ ಮೊರ‍್ಹ ವಲಾಂಡ್ಯಾಚ಼ ಜೆವಾನ್ ಖಾನಾರ್ ನಾಹಿ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","ತ್ಯಾ ನಂತರ್ ಯೇಸುನಿ ದರಾಕ್ಶಿಚಾ ರಸಾಚ಼ ಲ್ಯೊಟ್ಕ ಗಿಹುನ್ ದೇವಾಲಾ ಸ್ತೊತ್ರ ಕರುನ್, “ಹ್ಯ ಗಿಹುನ್ ತುಮಿ ವಾಟುನ್ ಗೆವ್ಹಾ. ");
INSERT INTO gok_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","ಆಚಾನಿ ದೇವಾಚ಼ ರಾಜೆ ಯಯಿ ಪರ‍್ಯಾತ್ ಮಿ ಆನಿ ಆಂಬಾಟ್ ಜಾ಼ಲ್ಯಾಲಾ ದರಾಕ್ಶಿಚಾ಼ ರಸ್ ಪಿನಾರುಸ್ ನಾಹಿ ಮನ್ಹುನ್ ತುಮಾನಾ ಮಿ ಸಾಂಗ್ತೊ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","ಮಂಗ್ ತ್ಯನಿ ಬಾಖ್ರಿ ಗಿಹುನ್ ದೇವಾಲಾ ಉಪ್ಕಾರ್ ಕರುನ್ ಮುಡುನ್ ತ್ಯನಾ ದಿವುನ್, “ಹ್ಯ ತುಮ್ಚಿ ಸಾಟಿ ದಿಲ್ಯಾಲ ಮಾಜ಼ ಧಡ್; ಮಾಜಿ ಯಾದ್ ಕಾಡಾಯಾ ಆಸ ಕರಾ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","ಜೆವಾನ್ ಜಾ಼ಲ್ಯಾ ನಂತರ್ ಯೇಸುನಿ ತಸಸ್ ಲ್ಯೊಟ್ಕ ಗಿಹುನ್, “ಹ್ಯ ಲ್ಯೊಟ್ಕ ತುಮ್ಚಿ ಸಾಟಿ ಶಾಂಡ್ನಾರ‍್ಯಾ ಮಾಜಾ ರಕ್ತಾನಿ ಕೆಲ್ಯಾಲಾ ನವಾ ಕರಾರ್ ದಾವುನ್ ದೆತ್ಯೊ. ");
INSERT INTO gok_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“ಫನ್, ಬಗಾ! ಮನಾ ದರ‍್ಹುನ್ ದೆನಾರ್ ಮಾಜಿಸಂಗ ಮೆಜಾ಼ವ ಹಾತ್ ಥಿವುನ್ ಖಾತ್ಯೊ. ");
INSERT INTO gok_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","ದೇವಾಚಾ ಮನಾಶಾರ್ಕ ಮಾನ್ಸಾಚಾ಼ ಲ್ಯೊಕ್ ನಿಗುನ್ ಜಾ಼ನಾರ್ ತ್ಯ ಖರ; ಫನ್ ತ್ಯಲಾ ದರುನ್ ದೆನಾರ‍್ಯಾ ಮಾನ್ಸಾಚಿ ಹಾಕಿಗತ್ ಕ್ಯಾ ಸಾಂಗು” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","ಹ್ಯ ಐಕುನ್ ತೆ, “ಆಸ್ಲ ಕಾಮ್ ಕರಾ ವ್ಹಯಿ ಮನ್‌ಲ್ಯಾಲಾ ಆಮ್ಚಾತ್ ಕೊನ್ ಆಸಲ್” ಮನ್ಹುನ್ ಯಕಾಮಕಾಲಾ ಇಚಾರಾಯಾ ಲಾಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","ಮಂಗ್ ಶಿಶಾಂಚಾ಼ ಆಪ್‌ಲ್ಯಾತ್ ಕಚಾ಼ ಥೊರ‍್ಲಾ ಮನ್ಹುನ್ ಗಿಹಿಲ್ ಹೆ ಗುಶ್ಟಿತ್ ವಾದ್ ವಿವಾದ್ ಚಾ಼ಲ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","ತವಾ ಯೇಸು ತ್ಯನಾ, “ದುಸ್ರೆ ದೆಸೆಚ಼ ರಾಜ಼ ಆಪ್‌ಲ್ಯಾ ಬಳಾನಿ ಆಪ್‌ಲ್ಯಾ ಲೊಕಾನಾ ಹಾಕಾನಿ ಚಾ಼ಲಿವತ್ಯಾತ ಆನಿ ಅಧಿಕಾರಿ ಲೊಕಾಂಚ಼ ಸುಪ್ತಿ ಮನ್ಹುನ್ ಗೆಥ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","ತುಮ್ಚಾತ್ ತಸ ರಾಹು ನಾಹಿ; ತುಮ್ಚಾತ್ ಥೊರ‍್ಲಾ ಬ್ಯಾರ್‌ಕ್ಯಾಂಚಿಗತ್ ವ್ಹಯಾ ವ್ಹಯಿ ದನ್ಹಿ ಆಳಾಚೆಗತ್ ವ್ಹಯಾ ವ್ಹಯಿ ");
INSERT INTO gok_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","ಕಚಾ಼ ಥೊರ‍್ಲಾ; ಖಾಯಾ ಬಸ್‍ಲ್ಯಾಲಾ ಕ್ಯಾ ಸೇವಾ ಕರ್ನಾರಾ? ಖಾಯಾ ಬಸ್‍ಲ್ಯಾಲಾಸ್ ಫನ್ ಮಿ ತುಮ್ಚಾತ್ ಸೆವಕಾಚೆಗತ್ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","ತುಮಿ ಮಾಜಾ ಸಗ್‌ಳ್ಯಾ ತರಾಸಾತ್ ಮಾಜಿಸಂಗ ಖಾಯಿಮ್ ಆಸ್‍ಲ್ಯಾಲ ");
INSERT INTO gok_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","ಮನ್ಹುನ್ ಮಾಜಾ ಪರಮೇಶ್ವರ್ ಬಾನಿ ಮನಾ ಹಾಕ್ ದಿಲ್ಯಾ ಶಾರ್ಕಾ ಮಿ ತುಮಾನಾ ದೆತೋ. ");
INSERT INTO gok_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ಮಾಜಾ ರಾಜಾತ್ ತುಮಿ ಮಾಜಾ ಮೆಜಾವ ಜೆವಾನ್ ಖಾನಾರ್ ಪಿನಾರ್; ಆನಿ ರಾಜಾಚೆ ಖುರ್ಚಾಂಚಾವ್ನಿ ಬಸುನ್ ಇಸ್ರಾಯಲಾಚಾ ಬಾರಾ ಕುಳಾನಾ ನ್ಯಾಯಿ ನಿವಡ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","ಸಿಮೊನಾ ಸಿಮೊನಾ ಐಕ್ ಸೈತಾನಾನಿ ತುಮಾನಾ ಚಾ಼ಂಗಲ್ಯಾತ್ನಿ ಬುರ್ಸ ಕಾಡಾಯಾ ಮಾಜಿಪ್ನಿ ಹುಕುಮ್ ಮಾಗ್‌ಲ್ಯಾ ತ್ಯೊ ಕಸಾ ಮಂಜೆ ತ್ಯ ಬುರ್ಶಾತ್ನಿ ಚಾ಼ಂಗ್ಲ ಕಾಡಾಯಾ ಕಸಾ ಯೊಕ್ ಸೇತ್ಕರಿ ಘಹು ಸಡ್ತೊ ತಸ. ");
INSERT INTO gok_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","ಫನ್ ಸಿಮೊನಾ ತುಜಾ಼ ಇಸ್ವಾಸ್ ಠಕು ನಾಹಿ ಮನ್ಹುನ್ ಮಿ ತುಜೆ ಗುಶ್ಟಿತ್ ದೇವಾಪ ಮಾಗುನ್ ಗೆತ್ಲ ಆನಿ ತು ಪರಾತ್‍ಲ್ಯಾ ನಂತರ್ ತುಜಾ ಬಾವ್ಹಾನಾ ಧೀರ್ ದೇ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","ಫನ್ ಪೇತ್ರಾ, “ಪ್ರಭು ತುಜಿ ಸಂಗ ತುರುಂಗಾತ್ ಜಾ಼ಯಾಬಿ ಮರಾಯಾಬಿ ಮಿ ಉಬಾ ಹಾ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","ಯೇಸು, “ಪೇತ್ರಾ, ಮಾಜೆ ಗುಶ್ಟಿತ್ ಆಜ಼್ ಸಕಾಳಚಾ಼, ‘ಹ್ಯೊ ಮನಾ ಠಾವಾ ನಾಹಿ’ ಮನ್ಹು‍ನ್ ತು ತೀನ್ ಖೆಪಾ ಸಾಂಗಿ ಪರ‍್ಯಾತ್ ಕೊಂಬ್ಡಾ ಬವ್ನಾರ್ ನಾಹಿ ಆಸ ತುಲಾ ಸಾಂಗ್ತೊ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","ಆನಿ ಯೇಸುನಿ ಆಪ್‌ಲ್ಯಾ ಶಿಶಾನಾ, “ತುಮಾನಾ ಪೈಶಾಚಿ ಪಿಸ್ವಿ, ಜು಼ಳ್ಹಿ ವ್ಹಾನಾ ನಸ್ಥಾನಾ ಮಿ ಲಾವುನ್ ದಿಲ ತವಾ ತುಮಾನಾ ಕಾಯ್ತರಿ ಕಮ್ಮಿ ಜಾ಼ಲ ಕ್ಯಾ” ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ತವಾ ತೇ, “ಕಾಯ್‍ ನಾಹಿ” ಮನ್ಹುನ್ ಉತ್ತರ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","ತ್ಯಲಾ ಯೇಸು, “ಆತಾತರಿ ಕಚಾಪ ಪಿಸ್ವಿ ಹಾ ತ್ಯನಿ ಗೆವ್ಹಾವಿ ಜು಼ಳ್ಹಿ ಗೆವ್ಹಾವಿ ಆನಿ ಕಚಾಪ ಹತ್ಯಾರ್ ನಾಹಿ ತ್ಯನಿ ಆಪ್ಲ ಕಪ್ಡ ಇಕುನ್ ಹತ್ಯಾರ ಗೆವ್ಹಾವ. ");
INSERT INTO gok_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","ಕಾ ಮಂಜೆ, ‘ತ್ಯೊ ಅಪರಾದಿತಲ್ಯಾ ಯಕಾಚೆಗತ್ ಥರ್ಲಾ ಹುತ್ತಾ ಮನ್ಹುನ್ ಪ್ರವಾದಿಂಚಾನಿ ಲಿವ್‌ಲ್ಯಾಲ್ಯಾ ಪುಸ್ತಕಾತ್ಲ ಸಬಾತ್ ಮಾಜಿವ ಗಢಾ ವ್ಹಯಿ ಜಾ಼ಲ್ಯಾತ ಮನ್ಹುನ್ ತುಮಾನಾ ಸಾಂಗ್ತೊ; ಮಾಜಿ ಗ್ಯೊಶ್ಟ್ ಸಪಾಯಾ ಪಾಯ್ಜೆ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","ತವಾ ಶಿಶಾ, “ಪ್ರಭು ಹಾಬಿ ಹಿತ್ತ ದೊನ್ ಹತ್ಯಾರಿ ಹಾತ್ತ” ಮನ್ಲ ತವಾ ಯೇಸು ತ್ಯನಾ, “ತ್ಯವ್ಡಿ ಪುರೊ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","ಮಂಗ್ ಯೇಸು ನಿಗುನ್ ಯೆರುಸಲೆಮ್ ಪ್ಯಾಟ್ ಸುಡುನ್ ಖಾಯಿಮ್ಚಿಗತ್ ಒಲೀವ್ ಜಾ಼ಢಾಂಚಾ ಗುಢ್ಯಾವ ಗೆಲಾ ಆನಿ ಶಿಶಾಬಿ ತ್ಯಚೆ ಮಾಗ್ನಿ ಗೆಲ. ");
INSERT INTO gok_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","ತ್ಯೊ ತ್ಯಾ ಠಿಕಾನ್ಯಾವ ಆಲಾ ತವಾ ಯೇಸುನಿ ತ್ಯನಾ, “ತುಮಿ ಪರಿಕ್ಷೆತ್ ಗಾವು ನಾಹಿ ಆಸ ದೇವಾಪ ಮಾಗ್ನ ಕರಾ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","ಮಂಗ್ ಯೇಸು ತ್ಯನಾ ಸೂಡುನ್ ದೊಂಡ್ಯಾಚಾ ಹೊಲ್ಪಾಟ್ಯಾ ಇತ್ಕಾ ದುರ್ ಜಾ಼ವುನ್ ನಡ್ಗ ಟಿಕುವುನ್, ");
INSERT INTO gok_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“ಬಾ ದೇವಾ ತುಲಾ ಮನ್ ಆಸ್ಲತ ಹ್ಯ ತರಾಸಾಚ಼ ಐದಾನ್ ಮಾಜಿಪ್ನಿ ಕ್ಯಾಡ್; ಕಸ ಬಿ ಮಾಜಾ ಮನಾ ಶಾರ್ಕ ನವ್ಹ ತುಜಾ ಮನಾಚೆಗತ್ ವ್ಹವುನಿ” ಆಸ ಮಾಗ್ನ ಕೆಲ. ");
INSERT INTO gok_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","ತವಾ ಪರಲೊಕಾತ್ನಿ ಆಲ್ಯಾಲಾ ಯೊಕ್ ದೇವ್ ಧುತ್ ತ್ಯಲಾ ದಿಸುನ್ ಧೀರ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","ತ್ಯೊ ಮನಾಲಾ ಬೆಜಾರ್ ವ್ಹವುನ್ ಆಜು಼ನ್ ಮನಾನಿ ಮಾಗ್ನ ಕರ್ತಾನಾ ತ್ಯಚಾ಼ ಘಾಮ್ ದರ್ಥಿವ ಪಡ್‍ತ್ಯಾಲ್ಯಾ ರಕ್ತಾಚಾ ಮೊಟ್ಯಾ ಠೆಮಾಚೆಗತ್ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","ಯೇಸುನಿ ಮಾಗ್ನ ಸಪ್ವುನ್ ಉಠುನ್ ಶಿಶಾಂಚಿಪ ಯವುನ್ ಹ್ಯನಾ ನಿಜ಼್ ಲಾಗ್‌ಲ್ಯಾಲಿ ಬಗುನ್ ದುಃಖಾನಿ ಬರ‍್ಹುನ್. ");
INSERT INTO gok_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","ತ್ಯೊ ಶಿಶಾನಾ, “ತುಮಿ ನಿಸ್‍ತ್ಯಾಲ ಕ್ಯಾ? ಉಠಾ ಪರಿಕ್ಶೆತ್ ಗಾಹು ನಾಹಿ ಆಸ ಮಾಗ್ನ ಕರಾ” ಮನ್ಹುನ್‍ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","ಯೇಸು ಆಜು಼ನ್ ಬೊಲ್ತಾ ಆಸ್ಥಾನಾಸ್ ತಿಥ ಮಾನ್ಸಾಂಚಾ಼ ಹಿಂಡ್ ದಿಸ್ಲಾ. ಬಾರಾಜಾ಼ನ್ ಶಿಶಾತ್ಲಾ ಯಕ್ಲಾ ಯುದ್ ಮಂಥ್ಯಾಲಾ ತ್ಯಾ ಲೊಕಾಂಚೆ ಮೊರ‍್ಹ ಮೊರ‍್ಹ ಲಾಗ್ಲಾ ಆನಿ ತ್ಯನಿ ಯೇಸುಚಾ಼ ಮುಖಾ ಗೆತ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","ತವಾ ಯೇಸು ತ್ಯಲಾ, “ಯುದಾ ಯೊಕ್ ಮುಖಾ ಗಿಹುನ್ ಮಾನ್ಸಾಚಾ ಲೇಕಾಲಾ ದರುನ್ ದೇತೊಸ್ ಕ್ಯಾ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","ತ್ಯಚೆ ಮೊರ‍್ಹ ಗಡ್ನಾರ ಸಮಜು಼ನ್, “ಪ್ರಭು ಆಮಿ ಹಾತ್ಯಾರಿ ಗೆವ್ಹಾವಕ್ಯಾ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ ");
INSERT INTO gok_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","ತ್ಯಾತ್‍ಲ್ಯಾ ಯಕಾನಿ ಮದ್‌ಲ್ಯಾ ಯಾಜಕಾಚಾ ಆಳಾಲಾ ಮಾರುನ್ ತ್ಯಚಾ಼ ಉಜ್ವಾ಼ ಕಾನ್ ತ್ಯೊಡ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","ಫನ್ ಯೇಸುನಿ ಯವ್‍ಡ್ಯಾವಸ್ ಸೊಡಾ ಮನ್ಹುನ್ ಸಾಂಗುನ್ ತ್ಯಾ ಕಾನಾಲಾ ಹಾತ್ ಲಾವುನ್ ತ್ಯಲಾ ಬರಾ ಕೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","ಮಂಗ್ ಯೇಸು ಆಪ್‌ಲ್ಯಾಲಾ ದರಾಯಾ ಆಲ್ಯಾಲ್ಯಾ ಮದ್‌ಲ್ಯಾ ಯಾಜಕಾಲಾ ದೇವ್ಳಾಚಾ ಸರದಾರಾನಾ ಆನಿ ವಡ್ಲಾನಾ, “ಚೊ಼ರಾಲಾ ದರಾಯಾ ಆಲ್ಯಾಚೆಗತ್ ಹಾತ್ಯಾರಿ ಟೊನ ಗಿಹುನ್ ಆಲ್ಯಾಸಾ? ");
INSERT INTO gok_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","ಮಿ ಖಾಯಿಮ್ ದೇವ್ಳಾತ್ ತುಮ್ಚಿ ಸಂಗ ಆಸ್ಥಾನಾ ತುಮಿ ಮನಾ ದರ್ಲಾ ನಾಹಿಸಾ, ಫನ್ ಹ್ಯೊ ತುಮಚಾ಼ ಯೊಳ್, ಹ್ಯಚಿವ ಆಂದಾರಾಚಿ ಸತ್ತಾ ಹಾ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","ತ್ಯಂಚಾನಿ ಯೇಸುಲಾ ದರುನ್ ಮುಖ್ಯ ಯಾಜಕಾಚಾ ಗರ‍್ಹಾತ್ ಗಿಹುನ್ ಗಿಲಿತ; ಪೇತ್ರಾ ದುರ್ನಿ ಮಾಗ್ನಿ ಮಾಗ್ನಿ ಜಾ಼ಯಿತಾ. ");
INSERT INTO gok_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","ಆಂಗ್ನಾತ್ ಮದ್ದಿ ತ್ಯಂಚಾನಿ ಇಸ್ತು ಕರುನ್ ಯಕಿಕ್ಡ ಜ಼ಮುನ್ ತಾಪತ್ ಬಸ್ತಾನಾ ತ್ಯಂಚೆ ಮದ್ದಿ ಪೇತ್ರಾಬಿ ಬಸ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","ತ್ಯೊ ಉಜಿಡಾಕ್ಡ ತ್ವಾಂಡ್ ಕರುನ್ ಬಸ್‍ಲ್ಯಾಲಾ ಆಸ್ಥಾನಾ ಯಕ ದಾಸಿನಿ ತ್ಯಲಾ ಶಾರ್ಕ ಬಗುನ್ ಹ್ಯೊ ಸಾಹಿತ್ ಯೇಸುಚೆ ಸಂಗ ಆಸ್‍ಲ್ಯಾಲಾ ಮನ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","ಫನ್ ಪೇತ್ರ, “ಮನಾ ತ್ಯಚಿ ವಳಕ್ ನಾಹಿಗ ಬಾಯಿ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","ಥೊಡ್ಯಾ ಯಳಾ ನಂತರ್ ಯಾಕಾ ಆಳಾನಿ ತ್ಯಲಾ ಬಗು‍ನ್, “ತು ದಿಕಿಲ್ ತ್ಯಂಚಾತ್ಲಾ ಯೊಕ್ ಮನ್ಲಾ ತವಾ ಪೇತ್ರ, “ನವ್ಹ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","ಖುಬ್ ಥೊಡಾ ಯಕಾ ತಾಸಾ ನಂತರ್ ಆನಿಯಕ್ಲಾ, “ಖರ‍್ಯಾನಿಸ್ ಹ್ಯೊ ದಿಖಿಲ್ ತ್ಯಚಿ ಸಂಗ ಆಸ್‍ಲ್ಯಾಲಾಸ್ ಹ್ಯೊ ಗಲಿಲಾಯಾತ್ಲಾಸ್” ಮನ್ಹು‍ನ್ ಖಾತ್ರಿನಿ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","ಫನ್ ಪೇತ್ರ, “ತು ಸಾಂಗ್‍ತ್ಯಾಲ ಕ್ಯಾತ್ಯ ಮನಾ ಠಾವಸ್ ನಾಹಿ” ಮನ್ಲಾ ತ್ಯೊ ಹ್ಯೊ ಸಬೊತ್ ಬೊಲ್ತಾ ಆಸ್ಥಾನಾ ಕೊಂಬ್ಡಾ ಬವಾಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","ಪ್ರಭುನಿ ಮಾಗಾರಾ ಪರ್ತುನ್ ಪೇತ್ರಾಕ್ಡ ನದಾರ್ ಕಿಲಿ ತವಾ ಪೇತ್ರಾ, “ಆಜ಼್ ರ‍್ಯಾಚಾ಼ ಕೊಂಬ್ಡಾ ಬವಾಚೆ ಆಂದಿ ತೀನ್ ಖೆಪಾ ಮಾಜೆ ಯಸಿ ತ್ಯೊ ಮನಾ ಠಾವಾ ನಾಹಿ ಮನ್ಹುನ್ ಸಾಂಗ್ಸಿಲ್” ಮನ್ಹುನ್ ಪ್ರಭುನಿ ಸಾಂಗ್‍ಲ್ಯಾಲಾ ಸಬೊತ್ ಯವುಜು಼ನ್ ");
INSERT INTO gok_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","ಬಾಹಿರ್ ಜಾ಼ವುನ್ ಮೊಟ್ಯಾ ದುಖಾನಿ ರಡ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","ಮಂಗ್ ಯೇಸುಲಾ ರ‍್ಯಾಕ್‌ತ್ಯಾಲ ತ್ಯಚಿ ಮಸ್ಕರಿ ಕರೀತ. ");
INSERT INTO gok_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","ತ್ಯಚ಼ ಡೊಳ ಬಾಂದುನ್ ಮಾರುನ್ “ತುಲಾ ಮ್ಯಾರ್ಲ್ಯಾಲ ಕುನಿ ತ್ಯ ಸಾಂಗ್? ಮನ್ಹುನ್ ತ್ಯಲಾ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","ತ್ಯಲಾ ಆಜು಼ನ್ ಖುಬ್ ಬಾದ್ ಸಬಾತ್ ಬುಲುನ್ ತ್ಯಂಚಾನಿ ತ್ಯಚಿ ನಿಂದಾ ಕಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","ದಿಸ್ರೆ ದಿಸಿ ಉಜಾ಼ಡಲ್ಯಾ ನಂತರ್ ಯೆಹುದ್ಯಾಂಚ಼ ಮುಖ್ಯ ಯಾಜಕ್, ಕ್ಯಾಯ್ದದಾರ್, ಜಾಂತ ಜ಼ಮುನ್ ತ್ಯಲಾ ಆಪ್ಲೆ ನ್ಯಾಯಿ ಕರ್ತ್ಯಾಲೆ ಸಭೆತ್ ಆನುನ್ ತ್ಯಂಚೆ ಮೊರ‍್ಹ ಉಬಾ ಕೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“ತು ಕ್ರಿಸ್ತ ಆಸ್ಲಾಸ್ತ ಆಮಾನಾ ಸಾಂಗ್” ಮನ್ಲ ತ್ಯೊ ತ್ಯನಾ, ಮಿ ತುಮಾನಾ ಸಾಂಗ್ಲಕಿ ತುಮಿ ಖರ ದರ‍್ನಾರ್ ನಾಹಿಸಾ. ");
INSERT INTO gok_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ಮಿ ತುಮಾನಾ ಕಾಯ್ತರಿ ಇಚಾರ್ಲತ ತುಮಿ ಉತ್ತರ್ ದಿಯಿತ್ ನಾಹಿಸಾ. ");
INSERT INTO gok_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","ಫನ್ ಆತಾಚಾನ್ ಮಾನ್ಸಾಚಾ಼ ಲ್ಯೊಕ್ ಸರ್ವಶಕ್ತ ಜಾ಼ಲ್ಯಾಲ್ಯಾ ದೇವಾಚೆ ಉಜ಼ವ್ಯಾಂಗ್ನಿ ಬಸ್ನಾರ್ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","ತವಾ ಸಗ್ಳಿ, “ತಸ ಜಾ಼ಲ್ಯಾ ತು ದೇವಾಚಾ಼ ಲ್ಯೊಕ್ ಕ್ಯಾ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ್ಯಾಲ್ಯಾಲಾ ತ್ಯನಿ ತ್ಯನಾ, “ಮಿ ತ್ಯೊಸ್ ಮನ್ಹುನ್ ತುಮಿಸ್ ಸಾಂಗ್ತಾಸಾ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","ತವಾ ತೇ, “ಆಮಾನಾ ಆನಿ ಸಾಕ್ಶಿ ಕಶಾಲಾ ವ್ಹಯಿ ಆಮಿಸ್ ಹ್ಯಚಾ ತೊಂಡಾನಿ ಐಕ್‍ಲ್ಯಾ ನವ್ಹ” ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","ತಿಥ ಜ಼ಮಲ್ಯಾಲಿ ಸಗ್ಳಿ ಲೊಕ ಉಠುನ್ ಯೇಸುಲಾ ಪಿಲಾತಾಪ ಗಿಹುನ್ ಗಿಲಿತ. ");
INSERT INTO gok_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","ಹ್ಯೊ ಆಪ್ನುಸ್ ಕ್ರಿಸ್ತ ಮನ್ಹುನ್ ಯೊಕ್ ರಾಜಾ಼ ಜಾ಼ಲ್ಯೊ ಮನ್ಹುನ್ ಸಾಂಗಿತ್ ಕೈಸರಾಲಾ ತೆರಗೆ ದಿಯಾಚಿ ನಾಹಿ ಮನ್ಹುನ್ ಸಾಂಗಿತ್ ಆಮ್ಚಾ ಮಾನ್ಸಾನಾ ವಾಕ್ಡೆ ವಾಟವ ನೆಥ್ಯಾಲಾ ಆಮಿ ಬಗ್‍ಲ್ಯಾ ಮನ್ಹುನ್ ತ್ಯಚಿವ ಚು಼ಕಿ ಸಾಂಗಾಯಾ ಲಾಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","ಪಿಲಾತಾನಿ ತ್ಯಲಾ, ತು ಯೆಹುದ್ಯಾಂಚಾ ರಾಜಾ಼ ವ್ಹಯ್ ಕ್ಯಾ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ್ಯಾಲ್ಯಾಲಾ ಯೇಸು, “ತುಸ್ ಸಾಂಗ್‍ಲ್ಯಾಸ್” ಮನ್ಹುನ್ ಉತ್ತರ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","ಪಿಲಾತಾನಿ ಮುಖ್ಯ ಯಾಜಕಾನಾ ಆನಿ ಲೊಕಾನಾ, “ಹ್ಯಾ ಮಾನ್ಸಾಪ ಮನಾ ಕಾಯ್ ಗುನ್ನಾ ದಿಸತ್ ನಾಹಿ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","ತ್ಯಲಾ ತೇ, “ಗಲಿಲಾಯಾತ್ ಸುರುಕರುನ್ ಹಿತ್ಪರ‍್ಯಾತ್ ಯುದಾಯ್ ಸಿಮೆತ್ ಸಗ್ಳೆ ಹ್ಯೊ ಶಿಕ್ಶನ್ ದಿಯಿತ್ ಲೊಕಾನಾ ವಾಕ್ಡೆ ವಾಟನಿ ನೆಥ್ಯೊ” ಮನ್ಹುನ್ ಆನಿಕ್ ತ್ಯಂಚಾನಿ ಡಾಚುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","ಹ್ಯ ಪಿಲಾತಾನಿ ಐಕುನ್, ಹ್ಯೊ ಮಾನುಸ್ ಗಲಿಲಾಯಾತ್ಲಾ ಕ್ಯಾ ಮನ್ಹುನ್ ಇಚಾರ್ಲ ");
INSERT INTO gok_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","ಯೇಸು ಹೆರೊದಾಚಾ ಅಧಿಕಾರಾತ್ ಆಸ್‍ಲ್ಯಾಲಾ ಮನ್ಹುನ್ ಸಮಜು಼ನ್ ತ್ಯಲಾ ತ್ಯಚಿಪ ಲಾವುನ್ ದಿಲಾ. ಹೆರೊದ್ ತ್ಯಾ ದಿಸಾತ್ ಯೆರುಸಲೇಮಿತುಸ್ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","ಹೆರೊದಾನಿ ಯೇಸುಲಾ ಬಗ್ಲಾ ತವಾ ಖುಬ್ ಆನಂದ್ ಜಾ಼ಲಾ; ಕಾ ಮಂಜೆ ತ್ಯಚೆ ಗುಶ್ಟಿತ್ ಕಿತಿತರಿ ಗುಶ್ಟಿ ಐಕ್‍ಲ್ಯಾ ಹುತ್ಯಾ ಮನ್ಹುನ್ ತ್ಯಲಾ ಬಗಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಖುಬ್ ದಿಸಾಠಾವ್ನಿ ತ್ಯಚಾ ಮನಾತ್ ಹುತ್ತ. ತ್ಯಚಿಪ್ನಿ ಕಾಯ್ತರಿ ಯಾಕ್ ಮೊಟ ಕಾರ‍್ಯಾ ವ್ಹತ್ಯಾಲ ಬಗಾಹ್ವಯಿ ಮನ್ಹುನ್ ಮನ್ ಕೆಲ್ತ. ");
INSERT INTO gok_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","ಫನ್ ಹೆರೊದಾನಿ ಖುಬ್ ಸಬ್ದಾನಿ ಯೇಸುಲಾ ಪ್ರಶ್ನೆ ಇಚಾರ್ಲ ತರಿ ಯೇಸುನಿ ತ್ಯಲಾ ಕಾಯ್ ಉತ್ತರ್ ದಿಲಾ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","ಮುಖ್ಯ ಯಾಜಕ್ ಆನಿ ಕ್ಯಾಯ್ದದಾರ್ ಉಬರಾಹುನ್ ತ್ಯಚಿವ ಖುಬ್ ಚು಼ಕಿ ಸಾಂಗಿತ. ");
INSERT INTO gok_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","ಮಂಗ್ ಹೆರೊದಾನಿ ಆಪ್‌ಲ್ಯಾ ಸಿಪಾಯಿನಾ ಗಿಹುನ್ ಯೇಸುಲಾ ನಾಖಾರುನ್ ನಿಂದಾ ಕರುನ್ ಚಾ಼ಂಗ್ಲ ಕಪ್ಡ ಗಾಲ್ಹುನ್ ಪರತ್ ಆನಿ ಪಿಲಾತಾಕ್ಡ ಲಾವುನ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","ತೇ ದಿಸಿಸ್ ಹೆರೊದ್ ಆನಿ ಪಿಲಾತ್ ದೊಗ ಸುಪ್ತಿ ಜಾ಼ಲ; ತ್ಯಚೆ ಆಂದಿ ವಾದಿ ಜಾ಼ಲ್ಥ. ");
INSERT INTO gok_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","ಮಂಗ್ ಪಿಲಾತಾನಿ ಮುಖ್ಯ ಯಾಜಕಾನಾ ಆನಿ ಅಧಿಕಾರಿನಾ ಪ್ರಜೆಲಾ ಯಂಗ್ದಾಸ್ ಹಾಕ್ಟುನ್ ");
INSERT INTO gok_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ತ್ಯನಾ, “ಹ್ಯೊ ಮಾನುಸ್ ಲೊಕಾನಾ ವಾಕ್ಡೆ ವಾಟವ ನೆಥ್ಯಾಲಾ ಮನ್ಹುನ್ ಹ್ಯಲಾ ಮಾಜಿಕ್ಡ ಆನ್‍ಲ್ಯಾಸಾ ನವ್ಹ; ತುಮಿ ಹ್ಯಚಿವ ವಾವ್‍ಲ್ಯಾಲ್ಯಾ ಚು಼ಕಿಂಚಿ ತುಮ್ಚೆ ಮೊರ‍್ಹಸ್ ಪಾರಕ್ ಕಿಲಿ ಫನ್ ಹ್ಯಚಿಪ ಯೇಕ್ ಚು಼ಕ್ ದಿಖಿಲ್ ಮನಾ ದಿಸ್ಲಿ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","ಹೆರೊದಾಲಾ ಸಾಹಿತ್ ತ್ಯಚಿಪ ಚು಼ಕ್ ದಿಸ್ಲಿ ನಾಹಿ; ತ್ಯನಿ ಹ್ಯಲಾ ಪರ್ತುನ್ ಮಾಜಿ಼ ಪಸ್ ಲಾವುನ್ ದಿಲ್ಯಾ ಹ್ಯನಿ ಮರ‍್ನಾಚೆ ಶಿಕ್ಶೆ ಜೊ಼ಗಿ ಚು಼ಕ್ ಕಾಯ್ ಕೆಲ್ಯಾಲಿ ನಾಹಿ ಮನ್ಹುನ್ ಜಾ಼ಲ. ");
INSERT INTO gok_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","ಮನ್ಹುನ್ ಮಿ ಹ್ಯಲಾ ಕಾಟ್ಯಾಚಾ ಬಾರ‍್ಕುಲಾನಿ ಮಾರುನ್ ಸುಡುನ್ ದೆತೊ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","ವಲ್ಯಾಂಡ್ಯಾಚಾ ಸನಾದಿಸಿ ಪಿಲಾತಾನಿ ಲೊಕಾನಾ ಕೈದಿಲಾ ಸೊಡಾಚ಼ ಹುತ್ತ. ");
INSERT INTO gok_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","ಫನ್ ತ್ಯಂಚಾನಿ, “ತ್ಯಲಾ ಮಾರುನ್ ಟ್ಯಾಕ್ ಆಮಾನಾ ಬರಬ್ಬಾಲಾ ಸುಡುನ್ ದೆ ಮನ್ಹುನ್ ಯಂಗ್ದಾಸ್ ವರಾಡ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(ಹ್ಯಾ ಬರಭಾಲಾ ತ್ಯಾ ಶೆರಾತ್ ಚಾ಼ಲ್ಯಾಲ್ಯಾ ಯಕಾ ದಂಗ್ಯಾಸ್ ಲಾಗುನ್ ಆನಿ ಖುನ್ ಕೆಲ್ಯಾಲ್ಯಾಸ್ ಲಾಗುನ್ ಕ್ಯೊಂಡ್ಲಾ ಹುತ್ತಾ.) ");
INSERT INTO gok_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","ಪಿಲಾತ್ ಯೇಸುಲಾ ಸೊಡ್ವಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಪರತ್ ಆನಿ ತ್ಯಂಚಿ ಸಂಗ ಬೊಲ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","ಫನ್ ತೇ, “ತ್ಯಲಾ ಶಿಲ್ಬೆವ ಟ್ಯಾಂಗ್ ಶಿಲ್ಬೆವ ಟ್ಯಾಂಗ್ ಮನ್ಹುನ್ ವರ್ಡತಿತ ");
INSERT INTO gok_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","ಪಿಲಾತ್ ತಿನ್‍ವ್ಯಾನಿ, “ಕ್ಯಾ ವಾಯಿಟ್ ಕೆಲ? ಮಿ ಹ್ಯಚಿಪ ಮರ್ನಾಚೆ ಶಿಕ್ಶೆಜೊ಼ಗಿ ಚು಼ಕ್ ಕಾಯ್ ಬಗ್ಲಿ ನಾಹಿ ಮನ್ಹು‍ನ್ ಹ್ಯಲಾ ಮಾರು‍ನ್ ಸುಡುನ್ ದೇತೊ ಮನ್ಹುನ್ ತ್ಯನಾ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","ಫನ್ ತ್ಯಂಚಾನಿ ಮೊಟ್ಯಾನಿ ಗಾನ್ಹಾ ಕರೀತ್, “ತ್ಯಲಾ ಶಿಲ್ಬೆವ ಟಾಂಗಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಬಳ್ ಕೆಲ; ತ್ಯಂಚಾ ಗಾನ್ಯಾ ಶಾರ್ಕ ಜಾ಼ಲ. ");
INSERT INTO gok_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","ಪಿಲಾತ್, “ತುಮಿ ಮಾಗ್‍ಲ್ಯಾ ಶಾರ್ಕಸ್ ವ್ಹವುನಿ ಮನ್ಹುನ್ ಸಾಂಗುನ್ ತ್ಯಲಾ ಮಾರಾಯಾ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","ದಂಗಾ ಆನಿ ಖುನ್ ಕೆಲ್ಯಾಲ್ಯಾಸ್ ಲಾಗುನ್ ಕ್ಯೊಂಡ್‍ಲ್ಯಾಲ್ಯಾ ತ್ಯಾ ಮಾನ್ಸಾಲಾ ತ್ಯಂಚಾನಿ ಮಾಗ್‍ಲ್ಯಾ ಶಾರ್ಕ ಸುಡುನ್ ದಿವುನ್ ಯೇಸುಲಾ ತ್ಯಂಚಾ ಮನಾ ಶಾರ್ಕ ಕೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","ಸೈನಿಕ್ ಯೇಸುಲಾ ಗಿಹುನ್ ಜಾ಼ತಾನಾ ಸೆತಾತ್ನಿ ಗಾವಾತ್ ಯತ್ಯಾಲಾ ಸಿಮೊನ್ ಮಂಥ್ಯಾಲ್ಯಾಲಾ ದರುನ್ ಶಿಲ್ಬೆ ತ್ಯಚಿವ ಥಿವುನ್ ಯೇಸುಚೆ ಮಾಗ್ನಿ ಗಿಹುನ್ ಯಯಿ ಸಾರ ಕೆಲ. ");
INSERT INTO gok_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","ಖುಬ್ ಲೊಕ ಆನಿ ಬ್ಯಾಯ್ಕಾ ಮಾನ್ಸ ಜ಼ಮುನ್ ತ್ಯಚೆ ಮಾಗ್ನಿ ಆಲಿತ ತೀ ಬ್ಯಾಯ್ಕಾ ಮಾನ್ಸ ಶಾತಿ ಬಡುವುನ್ ಗಿಹಿತ್ ತ್ಯಚೆ ಸಾಟಿ ರಡತಿತ. ");
INSERT INTO gok_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","ತವಾ ಯೇಸು ತ್ಯಂಚಿಕ್ಡ ಪರ್ತುನ್, “ಯೆರುಸಲೇಮಿಚಾ ಬ್ಯಾಯ್ಕಾ ಮಾನ್ಸಾನು, ಮಾಜಿ ಸಾಟಿ ರಡುನಕೋಸಾ ತುಮ್ಚಿ ಸಾಟಿ ತುಮ್ಚಾ ಲೇಕ್ರಾಂಚೆ ಸಾಟಿ ರಡಾ. ");
INSERT INTO gok_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","ಕಾ ಮಂಜೆ ಪ್ಯುರ್ಗಿ ನಸ್ನಾರ‍್ಯಾ ಥಾನ ಪಾಜಿ಼ ನಸ್ನಾರ‍್ಯಾ ಬರ‍್ಯಾ ಮನ್ಹುನ್ ಲೊಕಾಂಚಾನಿ ಸಾಂಗಾಚ಼ ದೀಸ್ ಯನಾರ್. ” ");
INSERT INTO gok_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","ತ್ಯಾ ದೀಸಾತ್ ಲೊಕ, “ಕನ್ಯಾನು ಆಮ್ಚಿವ ಪಡಾ; ಗುಢ್ಯಾನು ಆಮಾನಾ ಜಾ಼ಖುನ್ ಗೆವ್ಹಾ” ಮನ್ಹಾರ್. ");
INSERT INTO gok_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","ಝಾ಼ಡ್ ವಲ್ಲ ಆಸ್ಥಾನಾ ಯವ್ಡ ಕೆಲ ತ ಝಾ಼ಡ್ ವಾಳ್ಯಾವ ಕ್ಯಾ ವ್ಹಯಿಲ್? ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","ಯೇಸುಚೆ ಸಂಗ ದುಸ್‌ರ‍್ಯಾ ದೊಗಾಜ಼ನಾನಾ ಮಾರಾಯಾ ನೆಲ ತೇ ಅಪರಾದಿ ಹುತ್ತ. ");
INSERT INTO gok_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","ತೇ ಕಫಾಲ್ ಮಂಥ್ಯಾಲ್ಯಾ ಠಿಕಾನ್ಯಾವ ಆಲ ತವಾ ತಿಥ ಯೇಸುಲಾ ಆನಿ ತ್ಯಾ ಅಪರಾಧಿನಾ ಶಿಲ್ಬೆವ ಗ್ಯಾತ್ಲ, ಯಕಾಲಾ ತ್ಯಚೆ ಉಜ಼ವ್ಯಾಂಗ್ನಿ ಆನಿ ಯಕಾಲಾ ತ್ಯಚೆ ಡಾವ್ಯಾಂಗ್ನಿ ಗ್ಯಾತ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","ತವಾ ಯೇಸು, “ಬಾ ದೇವಾ, ತ್ಯನಾ ಮಾಪ್ ಕರ್; ಆಪ್ನು ಕ್ಯಾ ಕರ್ತ್ಯಾತ ತ್ಯ ತ್ಯನಾ ಠಾವ ನಾಹಿ” ಮನ್ಲ. ನಂತರ್ ತ್ಯಚ಼ ಕಪ್ಡ ಚೀಟಿ ಗಾಲ್ಹುನ್ ವಾಟುನ್ ಗೆತ್ಲ ");
INSERT INTO gok_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","ತಿಥ ಲೊಕ ಬಗಿತ್ ರಾಹಿಲಿತ ಆನಿ ಅಧಿಕಾರಿ ಮಸ್ಕರಿ ಕರೀತ, “ತ್ಯನಿ ಆನಿ ಯಕಾಲಾ ಉರಿವಲ್ಯಾ; ತ್ಯೊ ದೇವಾನಿ ನಿವಡ್‍ಲ್ಯಾಲಾ ಕ್ರಿಸ್ತ ಆಸ್ಲಾತ ಆಪ್‌ಲ್ಯಾಲಾ ಆಪ್ನುಸ್ ಉರ್ವುನಿ” ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","ಸಿಪಾಯಿಂಚಾನಿ ತ್ಯಚಿ ಮಸ್ಕರಿ ಕಿಲಿ; ತೇ ತ್ಯಚಿಪ ಯವುನ್ ಆಂಬಾಟ್ ದರಾಕ್ಶಿಚಾ಼ ರಸ್ ದಿವುನ್ ");
INSERT INTO gok_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","“ತು ಯೆಹುದ್ಯಾಂಚಾ಼ ರಾಜಾ಼ ಆಸ್ಲಾಸ್ತ ತುಲಾ ಉರ್ವುನ್ ಘೇ” ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","ಆನಿ ಯೇಸುಚೆ ಶಿಲಬೆವ, “ಹ್ಯೊ ಯೆಹುದ್ಯಾಂಚಾ಼ ರಾಜಾ಼” ಮನ್ಹುನ್ ಫಳಿವ ಲಿವುನ್ ಲ್ಯಾವ್ಲ ಹುತ್ತ. ");
INSERT INTO gok_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","ಟ್ಯಾಂಗ್‍ಲ್ಯಾಲ್ಯಾ ತ್ಯಾ ಅಪರಾದ್ಯಾತ್ಲಾ ಯಕ್ಲಾ ತ್ಯಲಾ ಸರ್ಪತ್: “ತು ಕ್ರಿಸ್ತ ನವ್ಹಕ್ಯಾ? ತುಲಾಬಿ ಉರಿವ್ ಆನಿ ಆಮಾನಾಬಿ ಉರಿವ್” ಮನಲ್ಯಾಲ್ಯಾಲಾ ");
INSERT INTO gok_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","ದೋನವ್ಯಾ ಅಪರಾದಿನಿ ತ್ಯಲಾ ದಪ್‍ಕ್ಯಾವುನ್, “ತುಲಾ ಹಿ ಶಿಕ್ಶಾ ಜಾ಼ಲಿತರಿ ದೇವಾಲಾ ಬಿಹಿತ್ ನಾಹಿಸ್ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","ಆಮಿ ತರಿ ಖರ‍್ಯಾನಿ ಶಿಕ್ಶೆತ್ ಹಾವ್, ಆಮಿ ಕೆಲ್ಯಾಲೆ ಚು಼ಕಿ ಶಾರ್ಕಿ ಶಿಕ್ಶೆ ಮಿಳಾಲೆ ಹ್ಯನಿ ತರಿ ತಸ್ಲಿ ಕಾಯೇಕ್ ಚು಼ಕ್ ಕೆಲಿ ನಾಹಿ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","ನಂತರ್ ತ್ಯೊ ಯೇಸುಲಾ, “ಯೇಸು ತು ತುಜ಼ ರಾಜೆ ಗಿಹುನ್ ಯತಾನಾ ಮಾಜಿ ಯಾದ್ ಕರ್” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","ತ್ಯಲಾ ಯೇಸುನಿ, “ತು ಆಜು಼ಸ್ ಮಾಜಿ಼ ಸಂಗ ಸ್ವರ್ಗಾತ್ ರಾಸಿಲ್ ಮನ್ಹುನ್ ತುಲಾ ಖರ‍್ಯಾನಿ ಸಾಂಗ್ತೊ” ಮನ್ಹುನ್ ಉತ್ತರ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","ತಿತ್‍ಕ್ಯಾತ್ ದ್ಯೊಪ್ಯಾರ್ ಜಾ಼ಲ್ತಿ ಆನಿ ದಿಸಾವ ಆಂದಾರ್ ಯವುನ್ ತೀನ್ ಗಂಟ್ಯಾ ಪರ‍್ಯಾತ್ ಸಗ್ಳೆ ದುನೆಬ ಆಂದಾರ್ ಪಡ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","ಆನಿ ದೇವ್ಳಾತ್ಲಾ ಪಡ್ದಾ ಮದ್ದಿಸ್ ಫಾಟ್ಲಾ ಆನಿ ದೊನ್ ಭಾಗ್ ಜಾ಼ಲ. ");
INSERT INTO gok_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","ಮಂಗ್ ಯೇಸು, “ಬಾ ದೇವಾ ಮಾಜ಼ ಆತ್ಮ ತುಜಾ ಹಾತಾತ್ ದೇತೊ” ಮನ್ಹುನ್ ಜೊ಼ರಾನಿ ವರಾಡ್ಲಾ ಹ್ಯ ಸಾಂಗ್‍ಲ್ಯಾ ನಂತರ್ ಪರಾನ್ ಶೊಡ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","ಹ್ಯ ಸಗ್ಳ ಜಾ಼ಲ್ಯಾಲ ಸೈನ್ಯಾಚಾ ಅಧಿಕಾರ‍್ಯಾನಿ ಬಗುನ್, “ಖರ‍್ಯಾನಿಸ್ ಹ್ಯೊಮಾನುಸ್ ನಿಯತಿಚಾ಼ ಮನ್ಹುನ್ ದೇವಾಲಾ ವವ್ಯಾಳಾ. ");
INSERT INTO gok_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","ಹ್ಯ ಬಗಾಯಾ ಜ಼ಮಲ್ಯಾಲಿ ಲೊಕ ಸಗ್ಳಿ ಚಾ಼ಲ್ಯಾಲ ಸಗ್ಳ ಬಗುನ್ ದುಃಖಾನಿ ಶಾತಿ ಬಡುವುನ್ ಗಿಹಿತ್ ಮಾಗಾರಿ ಗರ‍್ಹಾತ್ ಗಿಲಿತ. ");
INSERT INTO gok_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","ಆನಿ ಯೇಸುಚೆ ವಳ್ಖಿಚಿ ಸಗ್ಳಿ ಗಲಿಲಾಯಾತ್ನಿ ತ್ಯಚೆ ಮಾಗ್ನಿ ಆಲ್ಯಾಲ್ಯಾ ಬ್ಯಾಯ್ಕಾ ಮಾನ್ಸ ದುರ್ ಉಬ್ಯಾ ರಾಹುನ್ ಹಿ ಕಾಮ ಬಗಿತಿತ. ");
INSERT INTO gok_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","ಯೇಹುದ್ಯಾಂಚಾ ಅರಿಮತಾಯ್ ಗಾವಾತ್ಲಾ ಯೊಕ್ ಮಾನುಸ್ ಹುತ್ತಾ; ತ್ಯಚ಼ ನಾವ್ ಯೊಸೆಪ್, ತ್ಯೊ ನ್ಯಾಯ್ ಸಭೆತ್ಲಾ ಚಾ಼ಂಗ್ಲ ಧರ್ಮಾಚಾ಼ ದೇವಾಚಾ ರಾಜಾಚ಼ ಯನ ಬಗ್‌ತ್ಯಾಲಾ ನ್ಯಾಯ್ ಸಭೆಚಾ ಇಚಾರಾಚಾ ಕಾಮಾತ್ ಡುಯಿ ದಿಲಿ ನವ್ತಿ. ");
INSERT INTO gok_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","ತ್ಯನಿ ಪಿಲಾತಾಪ ಜಾ಼ವುನ್ ಯೇಸುಚ಼ ಮಡ ಆಪ್‌ಲ್ಯಾಲಾ ದಿಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಮಾಗುನ್ ಗೆತ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","ತ್ಯ ಉತುರುನ್ ಚಾ಼ಂಗಲ್ಯಾ ಕಪ್‌ಡ್ಯಾನಿ ಗುಂಡ್ಯಾಳುನ್ ಖಡ್ಕಾತ್ ಖ್ಯಾಂದ್‍ಲ್ಯಾಲೆ ಮಸುರ್ಡಿತ್ ಥೆವ್ಲ. ತ್ಯಾತ್ ತಿತ್‍ತ್ಪರ‍್ಯಾತ್ ಕುನಾಲಾ ಥೆವ್ಲಾ ನವ್ಥ. ");
INSERT INTO gok_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","ತ್ಯೊ ದೀಸ್ ತಯಾರಿಚಾ಼ ದೀಸ್ ಜಾ಼ಲ್ಥಾ; ಆನಿ ಸಬ್ಬತ್ ದಿಸ್ ಸುರು ವ್ಹಯಾಚಾ಼ ಯೊಳ್ ತ್ಯವ್ಡಾಸ್ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","ಆಸ ಆಸ್ಥಾನಾ ಗಲಿಲಾಯಾತ್ನಿ ತ್ಯಚೆ ಸಂಗ ಆಲ್ಯಾಲಿ ಬ್ಯಾಯ್ಕಾ ಮಾನ್ಸಾ ಯೋಸೆಪಾಚೆ ಸಂಗಸ್ ಮಾಗ್ನಿ ಜಾ಼ವುನ್ ತಿ ಮಸುರ್ಡಿ ಆನಿ ತ್ಯಚ಼ ಮಡ ಥೆವ್‍ಲ್ಯಾಲ ಬಗ್ಲ ");
INSERT INTO gok_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","ಆನಿ ಮಾಗಾರ‍್ಯಾ ಯವುನ್ ಚಾ಼ಂಗ್ಲ ದ್ರವ್ಯ ಆನಿ ವಾಸಾಚ಼ ತ್ಯಾಲ್ ತಯಾರ್ ಕೆಲ ಸಬ್ಬತಾ ದೀಸಿ ತ್ಯಂಚಾನಿ ಇಸ್ರಾಂತಿ ಗೆತ್ಲಿ ಕಾ ಮಂಜೆ ಮೊಶೆಚಾ ಕ್ಯಾಯ್‌ದ್ಯಾತ್ ಸಾಂಗ್‌ಲ್ಯಾ ಶಾರ್ಕ ಸಬ್ಬತಾ ದಿಸಿ ಇಸ್ರಾಂತಿ ಗಿಹ್ಯಾಚಿ ಹುತ್ತಿ. ");
INSERT INTO gok_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","ತೀ ಬ್ಯಾಯ್ಕಾ ಮಾನ್ಸ ಸಬ್ಬತ್ ದಿಸಾತ್ ಕ್ಯಾಯ್‌ದ್ಯಾಚೆಗತ್ ಇಶ್ರಾಂತಿ ಗಿಹುನ್ ಆಯಿತ್ವಾರಿ ಸಕಾಳ್ಚ ಆಜು಼ನ್ ಕಾಳೊಕ್ ಆಸ್ಥಾನಾಸ್ ಆಪ್ನು ತಯಾರ್ ಕೆಲ್ಯಾಲ ವಾಸಾಚ಼ ತ್ಯಾಲ್ ಗಿಹುನ್ ಮಸುರ್ಡಿಪ ಆಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","ತವಾ ಮಸುರ್ಡಿವ ಜಾಕ್‍ಲ್ಯಾಲಾ ದೊಂಢಾ ತಿಥ್ನಿ ಡಖಲ್ಯಾಲಾ ಬಗುನ್. ");
INSERT INTO gok_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","ಮಸುರ್ಡಿತ್ ಜಾ಼ವುನ್ ಬಕ್ತಾನಾ ಪ್ರಭು ಯೇಸುಚ಼ ಮಡ ದಿಸ್ಲ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","ಹೆ ಗುಶ್ಟಿತ್ ತ್ಯನಾ ಗಡಗಬಡ್ ಜಾ಼ಲಿ ತವಾ ಚ಼ಕ್ಮಕ್ ತ್ಯಾಲ ಕಪ್ಡ ಗಾಲ್ಹುನ್ ದೊಗ ಗಡಿ ಗಾಪ್ನ ತ್ಯಂಚಿಪ ಉಬ ರಾಹಿಲ. ");
INSERT INTO gok_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","ತೀ ಬ್ಯಾಯ್ಕಾ ಮಾನ್ಸ ಭಿಹುನ್ ಆಪ್ಲಿ ತೊಂಡ ಖಾಲ್ ಕರುನ್ ಆಸ್ಥಾನಾ ತೇ ಗಡಿ ತ್ಯನಾ, “ಮರುನ್ ಜಿ಼ತ್ತಾ ಜಾ಼ಲ್ಯಾಲ್ಯಾಲಾ ಸೊದಾಚ಼ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","ತ್ಯೊ ಹಿತ್ತ ನಾಹಿ ಉಟ್‌ಲ್ಯಾ ತ್ಯೊ ಆಜು಼ನ್ ಗಲಿಲಾಯಾತ್ ಆಸ್ಥಾನಾ ತುಮಾನಾ ಸಾಂಗ್‍ಲ್ಯಾಲ ಯಾದ್ ಕರಾ? ");
INSERT INTO gok_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","ಮಾನ್ಸಾಚಾ಼ ಲ್ಯೊಕ್ ಪಾಪಿ ಮಾನ್ಸಾಂಚಾ ಹಾತಾತ್ ದಿವುನ್ ಶಿಲ್ಬೆವ ಗಾಲ್ಹುನ್ ತಿನ್ವೆ ದಿಸಿ ಉಠು‍ನ್ ಯನಾರ್” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","ತವಾ ತ್ಯಾ ಬಾಯಿಲ್ ಮಾನ್ಸಾನಾ ತೇ ಸಬಾತ್ ಯದತ್ ಆಲ ");
INSERT INTO gok_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","ಆನಿ ಮಸುರ್ಡಿಪ್ನಿ ಮಾಗಾರ‍್ಯಾ ಜಾ಼ವುನ್ ತಿ ಖಬರ್ ಆಕ್ರಾ ಜಾ಼ನ್ ಶಿಶಾನಾ ಆನಿ ಬಾಕಿ ಸಗ್‍ಳ್ಯಾನಾ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","ತೀ ಬ್ಯಾಯ್ಕಾ ಮಾನ್ಸ ಕೊನ್ ಕೊನ್ ಮಂಜೆ ಮಗ್ದಲಾಚಿ ಮರಿಯಾ, ಯೊಹಾನಿ, ಯಾಕೊಬಾಚಿ ಆಯಿ ಮರಿಯಾ ಹ್ಯಾಚ್ ಹ್ಯಂಚೆ ಸಂಗ ಆಸ್‍ಲ್ಯಾಲ್ಯಾ ದಿಸರ‍್ಯಾ ಬ್ಯಾಯ್ಕಾ ಮಾನ್ಸಾಂಚಾನಿ ಸಾಹಿತ್ ಶಿಶಾನಾ ತೀ ಖಬರ್ ಸಾಂಗ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","ತ್ಯಂಚಾನಿ ಖರ ದರ್ಲ ನಾಹಿ; ತೇ ಸಬಾತ್ ತ್ಯನಾ ಮಸ್ಕರಿ ಆಸ ವಾಟ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","ಫನ್ ಪೇತ್ರಾ ಉಠುನ್ ಮಸುರ್ಡಿಪ ಪಳತ್ ಜಾ಼ವುನ್ ವಾಕುನ್ ಬಗುನ್ ಮಡ್ಯಾಲಾ ಬ್ಯಾಂದ್‌ಲ್ಯಾಲಾ ಕಪ್ಡಾ ತ್ಯವ್ಡಾಸ್ ಬಗುನ್ ಚಾ಼ಲ್ಯಾಲೆ ಖಬರಿಲಾ ಆಪ್‌ಲ್ಯಾತ್ ಗಾಬ್ರುನ್ ನಿಗುನ್ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","ತೇಸ್ ದಿಸಿ ಯೇಸುಚೆ ಮಾಗ್ನಿ ಜಾ಼ತ್ಯಾಲ್ಯಾತ್ಲ ದೊಗ ಜಾ಼ನ್ ಯೆರುಸಲೇಮಿತ್ ಸಾತ್ ಮೈಲ್ ದುರ್ ಆಸ್‍ಲ್ಯಾಲೆ ಎಮ್ಮಾಹು ಮಂಥ್ಯಾಲ್ಯಾ ಖೆಡ್ಯಾಸ್ ಜಾ಼ಯಿತ. ");
INSERT INTO gok_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","ಚಾ಼ಲ್ಯಾಲ್ಯಾ ಹ್ಯಾ ಸಗ್‍ಳ್ಯಾ ಕಾಮಾ ಬದಲ್ ಬೊಲತ ");
INSERT INTO gok_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","ತ್ಯಂಚಾ ಬೊಲ್‍ನ್ಯಾತ್ ಇಚಾರ್ ಕರ್ತಾನಾ ಯೇಸು ಆಪ್ನುಸ್ ಜ಼ವಳ್ ಯವುನ್ ತ್ಯಂಚೆ ಸಂಗ ಗೆಲಾ ");
INSERT INTO gok_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","ಫನ್ ತ್ಯಂಚಾನಿ ಯೇಸುಲಾ ವಳಕ್ಲಾ ನಾಹಿ, ");
INSERT INTO gok_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","ಯೇಸುನಿ ತ್ಯನಾ, “ತುಮಿ ಯಕಾಮಾಕಾಲಾ ವಾಟನಿ ಜಾ಼ತಾನಾ ಕ್ಯಾ ಬೊಲತಾಸಾ? ತವಾ ತೆ ಬೆಜಾರ್ ಕರುನ್ ಉಬ ರಾಯ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","ತ್ಯಂಚಾತ್ ಕ್ಲೆಯೊಪ್ ಮಂಥ್ಯಾಲಾ ಯಕ್ಲಾ ತ್ಯಲಾ, “ಯೆರುಸಲೇಮಿತ್ ಆಲ್ಯಾಲ್ಯಾ ದುಸ್ರಿಕ್‍ಲ್ಯಾ ಸಗ್‍ಳ್ಯಾನಾ ಹ್ಯಾ ದಿಸಾತ್ ತ್ಯಾತ್ ಚಾ಼ಲ್ಯಾಲ್ಯಾ ಖಬರಿ ಠಾವ್ಯಾ ಹಾತ್ತಾ ಆನಿ ತುಲಾ ತ್ಯವ್ಡಸ್ ಠಾವ ನಾಹಿ ಕ್ಯಾ” ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","ತವಾ ಯೇಸುನಿ ತ್ಯನಾ, “ಕ್ಯಾ ಖಬರ್? ಮನ್ಹುನ್ ಇಚಾರ್ಲ ತ್ಯಲಾ ತೇ, “ನಜ಼ರೇತಿಚಾ ಯೇಸುಚಿ ಖಬರ್ ತ್ಯೊ ದೇವಾಚೆ ಮೊರ‍್ಹ ಆನಿ ಮಾನ್ಸಾಂಚೆ ಮೊರ‍್ಹ ಬಳಾಲಾ ಆನಿ ಬೊಲ್‍ನ್ಯಾಲಾ ಬರಾ ಪ್ರವಾದಿ ಹುತ್ತಾ ಆನಿ ತ್ಯನಿ ಸಾಂಗ್‌ಲ್ಯಾಚೆಗತ್ ಕೆಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","ತ್ಯಲಾ ದೊನವ್ಯಾ ಯಾಜಕಾಂಚಾನಿ ಆಮ್ಚಾ ಅಧಿಕಾರಿಂಚಾನಿ ಮರ‍್ನಾಚಿ ಶಿಕ್ಶೆ ದಿವುನ್ ತ್ಯಲಾ ಶಿಲ್ಬೆವ ಗ್ಯಾತ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","ಆಮಿ ತರಿ ಇಸ್ರಾಯಲ್ ಲೊಕಾನಾ ಶೊಡ್ನಾರಾ ತ್ಯೊಸ್ ಮನ್ಹುನ್ ಸಮಜು಼ನ್ ಗೆತಲ್ಯಾ ತ್ಯವ್ಡಸ್ ತ್ಯ ಕಾಮ್ ವ್ಹವುನ್ ಆಜ಼್ ತೀನ್ ದಿಸ್ ಜಾ಼ಲ. ");
INSERT INTO gok_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","ಫನ್ ಆಮ್ಚಾತ್ಲಿ ಥುಡಿ ಬ್ಯಾಯ್ಕಾ ಮಾನ್ಸ ಉಜಾ಼ಡ್ತಾನಾ ಮಸುರ್ಡಿಪ ಜಾ಼ವುನ್ ");
INSERT INTO gok_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ತ್ಯಚ಼ ಮಡ ತಿಥ ದಿಸ ನಸ್ಥಾನಾ ತಿಥ್ನಿ ಯವುನ್ ಆಪ್‌ಲ್ಯಾಲಾ ದೇವ್ದುತಾಂಚ಼ ದರ್ಶಾನ್ ಜಾ಼ಲ ಆನಿ ತ್ಯೊ ಜ಼ಗಲ್ಯಾ ಮನ್ಹುನ್ ತ್ಯಂಚಾನಿ ಸಾಂಗ್‍ಲ್ಯಾ ಮನ್ಹುನ್ ಸಾಂಗುನ್ ಆಮಾನಾ. ");
INSERT INTO gok_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","ಆಮ್ಚಿ ಸಂಗ ಆಸ್‍ಲ್ಯಾಲಿ ಥುಡಿ ಮಸುರ್ಡಿಪ ಜಾ಼ವುನ್ ತ್ಯಾ ಬಾಯಿಲ್ ಮಾನ್ಸಾನಿ ಸಾಂಗ್‍ಲ್ಯಾ ಶಾರ್ಕ ಬಗ್ಲ; ಮಸುರ್ಡಿ ಮುಕ್ಳಿ ಹುತ್ತಿ. ತ್ಯಲಾ ಮತರ್ ಬಗ್ಲಾನಾಹಿ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","ತವಾ ಯೇಸು ತ್ಯನಾ, “ಆರ ಆಕಲ್ ಸಾಂಡ್ಯಾನು ಪ್ರವಾದಿಂಚಾನಿ ಸಾಂಗ್‍ಲ್ಯಾಲ್ಯಾ ಸಗ್‍ಳ್ಯಾವ ಇಸ್ವಾಸ್ ಥಿವಿ ನಸ್‍ಲ್ಯಾಲ್ಯಾ ಮದ್ದಡ್ ಮಾನ್ಸಾನು. ");
INSERT INTO gok_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","ಕ್ರಿಸ್ತಾನಿ ಆಸ್ಲ ತರಾಸ್ ಗಿವುನ್ ಆಪ್ಲೆ ಮೊಟೆ ಪದ್ವಿತ್ ಜಾ಼ಯಾಚಿ಼ ನಡ್ ಹುತ್ತಿ ನವ್ಹ ಮನ್ಹುನ್ ಸಾಂಗುನ್ ");
INSERT INTO gok_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","ಮೊಶೆಚ಼ ಆನಿ ಸಗ್‍ಳ್ಯಾ ಪ್ರವಾದಿಂಚಾ ಪುತಿಕಾತ್ನಿ ಆಪ್ಲೆ ಖಬರಿಚಾ ವಳಕಿ ತ್ಯನಾ ಫುಡುನ್ ಸಾಂಗ್‍ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","ತೆ ಜಾ಼ತ್ಯಾಲ್ಯಾ ಗಾವಾಚೆ ಜ಼ವಳ್ ಆಲ ತವಾ ತ್ಯೊ ಮೊರ‍್ಹ ಜಾ಼ತ್ಯಾಲ್ಯಾಚೆಗತ್ ದಿಸ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","ಫನ್ ತ್ಯಂಚಾನಿ, “ಆಮ್ಚಿ ಸಂಗ ರ‍್ಹಾ ಶಾಂಜ಼್ ಜಾ಼ಲ್ಹೆ ದೀಸ್ ಮಾವ್ಳತ್ ಆಲಾ” ಮನ್ಹುನ್ ತ್ಯಲಾ ಸಾಂಗುನ್ ಬಳ್ಕೆಲ ತವಾ ತ್ಯೊ ತ್ಯಂಚಿ ಸಂಗ ರಾಹ್ಯಾ ಗಾವಾತ್ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","ಯೇಸು ತ್ಯಂಚಿ ಸಂಗ ಖಾಯಾ ಬಸ್ಲಾ ತವಾ ಬಾಕ್ರಿ ಗಿಹುನ್ ದೇವಾಲಾ ಉಪ್ಕಾರ್ ಕರುನ್ ಮುಡುನ್ ತ್ಯನಾ ದಿಲಿ, ");
INSERT INTO gok_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","ತವಾ ತ್ಯಂಚ಼ ಡೊಳ ಉಗಾಡ್ಲ. ಆನಿ ತ್ಯಂಚಾನಿ ತ್ಯಲಾ ವಳಕ್ಲಾ; ತ್ಯೊ ತ್ಯಂಚಾ ಡೊಳ್ಯಾನಾ ಆಡಶಾ ಜಾ಼ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","ತವಾ ತೇ ಯಕಾಮಕಾಲಾ, “ತ್ಯೊ ವಾಟವ ಆಮ್ಚೆ ಸಂಗ ಬೊಲ್ಲಾ ತವಾ ಪ್ರವಾದಿಂಚಾ ಪುತೀಕಾಚ಼ ಅರ್ಥ ಆಮಾನಾ ಫುಡುನ್ ಸಾಂಗ್ಲ. ತವಾ ಆಮ್‌ಚ಼ ಮನ್ ಆತ್ಲೆ ಆತ್ ಉಖ್ಳತ ನವ್ಹ? ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","ತವಾಸ್ ತೇ ದೊಗ ಉಠುನ್ ಯೆರುಸಲೇಮಿತ್ ಮಾಗಾರ ಪರ್ತುನ್ ಗೆಲ. ತಿಥ ಆಕ್ರಾಜಾ಼ನ್ ಶಿಶಾ ತ್ಯಂಚಿ ಸಂಗ ಆಸ್‍ಲ್ಯಾಲ ಯಕಿಕ್ಡ ಜ಼ಮ್ಲ ");
INSERT INTO gok_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","“ಪ್ರಭು ಮೆಲ್ಯಾಲ್ಯಾತ್ನಿ ಉಟ್‍ಲ್ಯಾಲಾ ಖರ; ತ್ಯೊ ಸಿಮೊನಾಲಾ ದಿಸ್ಲಾ ಮನ್ಹುನ್ ಸಾಂಗಿತ್ ಹುತ್ತ. ");
INSERT INTO gok_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","ತ್ಯ ಬಗುನ್ ತ್ಯಂಚಾನಿ ವಾಟವ ಚಾ಼ಲ್ಯಾಲಿ ಖನ್ಕತ್ ಆನಿ ಬಾಕ್ರಿ ಮ್ಯೊಡ್ತಾನಾ ಆಪ್ನು ತ್ಯಲಾ ವಳಕ್‍ಲ್ಯಾಲ ಫುಡುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","ತೇ ಹಿ ಖನ್ಕತ್ ಬೊಲ್ತಾನಾ ತ್ಯಂಚೆ ಮದ್ದಿ ಯೇಸು ಪಾಕ್ಕನ್ ಉಬಾರಾಹುನ್ “ತುಮಾನಾ ಸಮಾದಾನ್ ವ್ಹವುನಿ” ಮನ್ಹುನ್ ತ್ಯನಾ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","ತೇ ಬಿಹುನ್ ಆಪ್ನು ಬಗ್‍ತ್ಯಾಲ ಭುತ್ ಮನ್ಹುನ್ ಸಮಜು಼ನ್ ಗೆತ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","ಯೇಸುನಿ ತ್ಯನಾ, “ಕಾ ಬಿಹ್ಯಾಲಾಸಾ? ತುಮ್ಚಾ ಮನಾತ್ನಿ ಅನ್ಮಾನ್ ಕಾ ಯತೊ? ");
INSERT INTO gok_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","ಮಾಜ಼ ಹಾತ್ ಪ್ಯಾ ಬಗಾ, ಮಿಸ್ ನವ್ಹ. ಮನಾ ಹಾತ್ ಲಾವುನ್ ಬಗಾ, ತುಮಾನಾ ದಿಸತ್ಯಾ ಶಾರ್ಕ ಮನಾ ಹಾಡ್ ಮಾಸ್ ಹಾತ್ತ; ತ್ಯ ಭುಥಾಲಾ ನಾಹಿ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","ತ್ಯ ಸಾಂಗ್‍ಲ್ಯಾ ನಂತರ್ ತ್ಯನಿ ತ್ಯನಾ ಆಪ್ಲ ಹಾತ್ ಪ್ಯಾ ದ್ಯಾವ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","ಫನ್ ತೇ ಆನಂದ್ ಜಾ಼ಲ್ಯಾಲ್ಯಾಸ್ ಲಾಗುನ್ ತ್ಯನಾ ಖರ ದರ್ಲ ನಾಹಿ ಮನ್ಹುನ್ ತ್ಯನಿ ಖಾತ್ಯಾಲಾ ಜಿನೊಸ್ ಕಾಯ್ ತರಿ ಹಿತ್ತ ತುಮ್ಚಿಪ ಹಾ ಕ್ಯಾ ಮನ್ಹುನ್ ತ್ಯನಾ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","ತವಾ ತ್ಯಂಚಾನಿ ಬ್ಯಾಜ಼ಲ್ಯಾಲ್ಯಾ ಬಾಂಗ್‍ಡ್ಯಾಚಾ಼ ಯೊಕ್ ತುಕ್ಡಾ ತ್ಯಲಾ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ತ್ಯನಿ ಗಿಹುನ್ ತ್ಯಂಚೆ ಮೊರ‍್ಹ ಖಾಲಾ ");
INSERT INTO gok_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","ಮಂಗ್ ತ್ಯೊ, “ಮಿ ತುಮ್ಚೆ ಸಂಗ ಆಸ್ಥಾನಾ ಹ್ಯ ಸಗ್ಳ ತುಮಾನಾ ಸಾಂಗ್ಲ ನವ್ತ ಕ್ಯಾ? ಮಾಜಿ ಖಬರ್ ಮೊಶೆಚಾ ಕ್ಯಾಯ್‌ದ್ಯಾತ್ ಪ್ರವಾದಿಂಚಾ ಗ್ರಂಥಾತ್ ಕಿರ್ತಾನಾತ್ನಿ ಲಿವ್‍ಲ್ಯಾಲ ಸಗ್ಳ ವ್ಹಯಾಚಿ ನಡ್ ಹಾ ಮನ್ಹು‍ನ್ ತುಮಾನಾ ಸಾಂಗ್ಲ ನವ್ಥ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","ತ್ಯಾ ನಂತರ್ ತ್ಯಂಚಾನಿ ಧರ್ಮ ಶಾಸ್ತಾರಾತ್ಲ ಸಬಾತ್ ಸಮಜ಼ ಜೊ಼ಗ ತ್ಯನಿ ತ್ಯಂಚ಼ ಗಿನ್ಯಾನ್ ಉಗ್ಡುನ್. ");
INSERT INTO gok_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ತ್ಯನಾ, “ಕ್ರಿಸ್ತ ತರಾಸ್ ಗಿವುನ್ ಮರುನ್ ತಿನ್ವೆ ದಿಸಿ ಜಿತ್ತಾ ವ್ಹವುನ್ ಉಠುನ್ ಯನಾರ್ ಮನ್ಹು‍ನ್. ");
INSERT INTO gok_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","ಪಾಪ್‍ ಮಾಪ್ ಕರಾಯಾ ಪಶ್ಚಾತಾಪಾನಿ ದೇವಾಕ್ಡ ಪರ್ತಾಹ್ವಯಿ ಆನಿ ತ್ಯಚಿ ಬರಿ ಖಬರ್ ಹೆ ಸಬಾತ್ ಯೆರುಸಲೇಮಿ ದರ‍್ನಿ ಸಗ್‍ಳ್ಯಾ ಪರಪಂಚಾತ್ ತ್ಯಚಾ ನಾವಾನಿ ತ್ಯಚಿ ಖಬರ್ ಸಾಂಗ್ನಾರ್ ಮನ್ಹುನ್ ಲಿವ್‍ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","ಹೆ ಗುಶ್ಟಿನಾ ತುಮಿಸ್ ಸಾಕ್ಶಿ ವ್ಹನಾರ್. ");
INSERT INTO gok_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","ಆನಿ ಆತಾ ಮಾಜಾ ಬಾನಿ ತುಮಾನಾ ಯೊಕ್ ಸಬ್ದ ದಿಲ್ಯಾ ತ್ಯೊ ತುಮಾನಾ ಲಾವುನ್ ದೇತೊ. ದೇವ್ ಪರಲೊಕಾತ್ನಿ ತುಮಾನಾ ಬಳ್ ದಿಯಿ ಪರ‍್ಯಾತ್ ಹೆ ಯೇರುಲೇಮಿತುಸ್ ರಾಖಿತ್ ರಾವ್ಹಾ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","ಆನಿ ಯೇಸುನಿ ತೆ ಪೆಠ್ಹತ್ನಿ ಬಾಹಿರ್ ತ್ಯನಾ ಬೆತಾನ್ಯಾ ಯವ್‌ಡ್ಯಾತ್ ತ್ಯನಾ ಗಿಹುನ್ ಜಾ಼ವುನ್ ಆಪ್ಲ ಹಾತ್ ಉಚ್ಲು಼ನ್ ತ್ಯನಾ ಆಶಿರ್ವಾದ್ ಕೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","ಆಶಿರ್ವಾದ್ ಕರ್ತಾನಾ ತ್ಯೊ ತ್ಯನಾ ಸುಡುನ್ ಪರಲೊಕಾತ್ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","ತ್ಯಂಚಾನಿ ತ್ಯಲಾ ಆರಾದನ್ ಕರುನ್ ಮೊಟ್ಯಾ ಹೌಸನಿ ಯೆರುಸಲೇಮಿತ್ ಪರತ್ ಗೆಲ. ");
INSERT INTO gok_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","ಆನಿ ತೇ ದೇವ್ಳಾತ್ ದೇವಾಲಾ ಖಾಯಿಮ್ ವವ್ಯಾಳಿತ್ ರಾಯ್ಲ.");
INSERT INTO gok_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","ಸರ್ವ್ಯಾಚೆ ಆಂದಿಸ್ ಸಬ್ದ ಆಸ್ಥಿತ್ವಾತ್ ಹುತ್ತಾ, ತ್ಯೊ ಸಬ್ದ ದೇವಾ ಸಂಗ ಹುತ್ತಾ, ತ್ಯೊ ಸಬ್ದಸ್ ದೇವ್ ಜಾ಼ಲ್ಥಾ. ");
INSERT INTO gok_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","ಸರ್ವ್ಯಾಚೆ ಆಂದಿಸ್ ತ್ಯೊ ಸಬ್ದ ದೇವಾಪ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","ಸಗ್ಳಿ ಸಾಮ್ನ ದೇವಾನಿ ತ್ಯಚಿಸ್ ಲಾಗುನುಸ್ ಬನಿವ್ಲಿತ. ತ್ಯೊ ನಸ್ಥಾನಾ ಕಚ಼ಸ್ ಬನ್ಲ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","ತ್ಯೊ ಸಬ್ದ ಜೀವಾಚ಼ ಮುಳ್ ಹುತ್ತಾ. ತ್ಯೊ ಜಿವ್ ಮಾನ್ಸಾನಾ ಉಜಿಡ್ ಜಾ಼ಲ್ಥಾ. ");
INSERT INTO gok_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","ಉಜಿಡ್ ಆಂದಾರಾತ್ ಚ಼ಮಾಕ್ಲಾ, ಆನಿ ಆಂದಾರಾಲಾ ಹ್ಯ ಸಮಾಜ್ಲಾ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","ದೇವಾನಿ ಆಪ್ಲಾ ಸಂದೇಶ್ ಪುಚಿವ್ನಾರ‍್ಯಾಲಾ ಲಾವುನ್ ದಿಲಾ ತ್ಯಚ಼ ನಾವ್ ಯೊಹಾನ್ ಹುತ್ತ. ");
INSERT INTO gok_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","ಆನಿ ತ್ಯೊ ಉಜಿಡಾಚೆ ಗುಶ್ಟಿತ್ ಲೊಕಾನಾ ವಳಕ್ ಸಾಂಗಾಯಾ ಆಲಾ, ಕಾ ಮಂಜೆ ಸಗ್‌ಳ್ಯಾ ಲೊಕಾಂಚಾನಿ ತ್ಯೊ ಸಂದೇಶ್ ಐಕಾಯಾ ಆನಿ ಇಸ್ವಾಸ್ ಥೆವಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಆಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","ಯೊಹಾನುಸ್ ಸ್ವತಾ ಆಪ್ನು ಉಜಿಡ್ ನವ್ಥಾ. ಫನ್ ತ್ಯೊ ನಿಸ್ಥಾ ಉಜಿಡಾಚೆ ಗುಶ್ಟಿತ್ ಲೊಕಾನಾ ವಳಕ್ ದಿಯಾ ಆಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","ಹ್ಯೊ ಖರಾ ಉಜಿಡ್ ಜಾ಼ಲ್ಯಾ ಹ್ಯೊ ದುನಿಯಾತ್ ಯಯಾಚಾ಼ ಹುತ್ತಾ. ಸಗ್‌ಳ್ಯಾ ಲೊಕಾಂಚಿವ ಚ಼ಮಕಾಚಾ಼ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","ತ್ಯೊ ಸಬ್ದ ದುನಿಯಾತ್ ಹುತ್ತಾ, ಆನಿ ದೇವಾನಿ ತ್ಯಚಿಸ್ ಲಾಗುನ್ ದುನಿಯಾ ಉತ್ಪನ್ ಕೆಲೆ, ಫನ್ ಹೆ ದುನಿಯಾನಿ ತ್ಯಲಾ ಸಮ್ಜುನ್ ಗೇತ್ಲಾ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","ತ್ಯೊ ಆಪ್ಲೆ ಸ್ವತಾಚೆ ದೇಶೆತ್ ಆಲಾ, ಫನ್ ತ್ಯಂಚಾನಿ ತ್ಯಲಾ ಮ್ಯಾನ್ಲಾ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","ಫನ್ ಕುನಿ ಕುನಿ ತ್ಯಲಾ ಮ್ಯಾನ್ಲಾ ಆನಿ ತ್ಯಚಿವ ಇಸ್ವಾಸ್ ಥೆವ್ಲಾ ತ್ಯನಾ ತ್ಯನಿ ದೇವಾಚಿ ಪೊರ ವ್ಹಯಾ ಹುಕುಮ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","ದೇವಾಚಾ ಲೇಕಾಚಾ ರುಪಾತ್ ತೇ ಸ್ವಾಭಾವಿಕ್ ನವ್ಹ, ನಾಹಿತ ರಕ್ತಾನಿ ಜ಼ಲಾಮ್ಲಿ ನಾಹಿತ, ಕಚಾ ಶರಿರಾಚೆ ಆಶೆನಿ ವ್ಹವುನಿ ಆನಿ ಆಯಿ ಬಾನಿ ಜ಼ಲಾಮ್ಲಿ ನಾಹಿತ. ಫನ್ ತೀ ದೇವಾಪ್ನಿ ಜ಼ಲಾಮ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","ತ್ಯಾ ಸಬ್ದಾನಿ ಮಾನ್ಸಾಚ಼ ರುಪ್ ಗೆತ್ಲ ಆನಿ ತ್ಯೊ ಸಗಳೆ ಕ್ರಪಾನಿ ಆನಿ ಖರ‍್ಯಾನಿ ಬರ್ಲಾ ಹುತ್ತಾ, ಆನಿ ತ್ಯೊ ಆಮ್ಚಿ ಸಂಗ ಹುತ್ತಾ. ಆಮಿ ತ್ಯಚಿ ಮೈಮಾ ಬಗ್ಲಿ, ತೀ ಬಾಚಾ ಯಕ್‌ಲ್ಯಾಸ್ ಯಕಾ ಲೇಕಾಚಿ ಮೈಮಾ ಜಾ಼ಲ್ಥಿ. ");
INSERT INTO gok_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","ಯೊಹಾನಾನಿ ತ್ಯಚೆ ಗುಶ್ಟಿತ್ ವಳಕ್ ದಿಲಿ ಆನಿ ಜೊ಼ರಾನಿ ಸಾಂಗ್ಲ, “ಮಿ ಕಚಾಚೆ ಗುಶ್ಟಿತ್ ಸಾಂಗ್ಲ ಹುತ್ತ. ತ್ಯೊಸ್ ಹ್ಯೊ ಜಾ಼ಲ್ಯಾ, ‘ಕೊನ್ ಮಾಜೆ ನಂತರ್ ಯನಾರಾ ಹಾ ತ್ಯೊ ಮಾಜಿವ್ನಿ ಮೊಟಾ ಹಾ, ಕಾ ಮಂಜೆ ತ್ಯೊ ಮಿ ಜ಼ಲ್ಮಾಚೆ ಆಂದಿಸ್ ಆಸ್ಥಿತ್ವಾತ್ ಹುತ್ತಾ. ” ");
INSERT INTO gok_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","ತ್ಯಚೆ ಭರ್ ಬಖಮ್ ಕ್ರಪೆನಿ ಆಮಾನಾ ಆಶಿರ್ವಾದಾವ ಆಶಿರ್ವಾದ್ ಗಾವ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","ದೇವಾನಿ ಆಮಾನಾ ಧರ್ಮಶಾಸ್ತಾರ್ ಮೊಶೆಪ್ನಿ ದಿಲ್ತ, ಫನ್ ಕ್ರಪಾ ಆನಿ ಖರ ಯೇಸು ಕ್ರಿಸ್ತಾಪ್ನಿ ಆಲ. ");
INSERT INTO gok_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","ದೇವಾಲಾ ಕುನಿ ಕಂದಿಸ್ ಬಗ್ಲಾ ನಾಹಿ. ಫನ್ ಯಕ್ಲಾಸ್ ಯೊಕ್ ಲ್ಯೊಕ್ ತ್ಯೊ ದೇವಾಚೆಗತ್ ಹಾ ಆನಿ ಬಾಚೆ ಸಂಗ ಚಾ಼ಂಗಲ್ಯಾ ನಾತ್ಯಾತ್ ಹಾ, ತ್ಯಾ ಲೆಕಾನಿಸ್ ಆಮಾನಾ ದೇವ್ ಕೊನ್ ಮನ್ಹುನ್ ದಾವುನ್ ದಿಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","ಯೆರುಸಲೇಮಿಚಾ ಯೆಹುದಿ ಜಾಂತ್ಯಾಂಚಾನಿ ಯೊಹಾನಾಪ ಥೊಡ್ಯಾ ಯಾಜಕಾನಾ ಆನಿ ಲೆವಿನಾ, “ತು ಕೊನ್? ಮನ್ಹುನ್ ಇಚಾರಾಯಾ ಲಾವುನ್ ದಿಲ. ");
INSERT INTO gok_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","ಯೊಹಾನಾನಿ ಕಾಯೇಕ್ ದಡ್ವಾಚೆ ಆಂದಿ, “ಮಿ ಕ್ರಿಸ್ತ ನವ್ಹ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","ಯೆಹುದ್ಯಾಂಚಾನಿ ಯೊಹಾನಾಲಾ, “ತಸ ಜಾ಼ಲ್ಯಾ ತು ಕೊನ್? ತು ಎಲಿಯಾ ಕ್ಯಾ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ತವಾ ಯೊಹಾನ್, “ಮಿ ಎಲಿಯಾ ನವ್ಹ” ಮನ್ಲಾ. ತವಾ ತ್ಯಂಚಾನಿ “ತು ಪ್ರವಾದಿ ಕ್ಯಾ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ತ್ಯನಾ ತ್ಯೊ, “ಮಿ ಪ್ರವಾದಿ ನವ್ಹ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","ತವಾ ತ್ಯಂಚಾನಿ, “ತಸ ಜಾ಼ಲ್ಯಾ ತು ಕೊನ್ ಮನ್ಹುನ್ ಆಮಾನಾ ಸಾಂಗ್ ಆಮಾನಾ ಲಾವುನ್ ದಿಲ್ಯಾಲ್ಯಾನಾ ಜಾ಼ವುನ್ ಉತ್ತರ್ ದಿಯಾ ವ್ಹಯಿ ತು ತುಜೆ ಗುಶ್ಟಿತ್ ಕ್ಯಾ ಸಾಂಗ್ತೊಸ್? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","ತವಾ ಯೊಹಾನಾನಿ ಪ್ರವಾದಿ ಜಾ಼ಲ್ಯಾಲ್ಯಾ ಯೆಶಾಯಾನಿ ಸಾಂಗಲ್ಯಾಶಾರ್ಕ: “ ಪ್ರಭುಚಾ಼ ಮಾರ್ಗ ನಿಟ್ ಕರಾ ಆಸಾ ಮಿ ರಾನಾತ್ ವರಾಡ್‌ತ್ಯಾಲಾ ಆವಾಜ಼್ ಜಾ಼ಲ್ಯೊ: ");
INSERT INTO gok_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","ಫರಿಸಾಯಾಂಚಾನಿ ಬಾತ್ನಿ ಸಾಟಿ ಲಾವುನ್ ದಿಲ್ಯಾಲ ಲೊಕ್. ");
INSERT INTO gok_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","ತ್ಯಂಚಾನಿ ಯೊಹಾನಾಲಾ ಇಚಾರ್ಲ, “ತು ಕ್ರಿಸ್ತ ನವ್ಹ ಎಲಿಯಾಬಿ ನವ್ಹ ಪ್ರವಾದಿಬಿ ನವ್ಹ ಮನ್ಹುನ್ ಸಾಂಗ್ತೊಸ್ ತ ತು ಲೊಕಾನಾ ಕಾ ಬಾಪ್ತಿಸ್ಮಾ ದೇತೋಸ್? ");
INSERT INTO gok_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","ಯೊಹಾನಾನಿ ಉತ್ತರ್ ದಿಲಾ, “ಮಿ ಲೊಕಾನಾ ಪಾನ್ಯಾನಿ ಬಾಪ್ತಿಸ್ಮಾ ದೇತೊ ಫನ್ ತುಮಾನಾ ಠಾವಾ ನಸ್‌ಲ್ಯಾಲಾ ಯೊಕ್ ತುಮ್ಚೆ ಮದ್ದಿ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","ಮಾಜೆ ನಂತರ್ ಯತ್ಯಾಲಾ ತ್ಯೊಸ್ ತ್ಯಚಾ ಪಾಯಾತಲ್ಯಾ ವ್ಹಾನಂಚಾ಼ ಪಟ್ಟಾ ಕಾಡಾಯಾಬಿ ಮಿ ಲಾಯಿಕ್ ನಾಹಿ. ” ");
INSERT INTO gok_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","ಹ್ಯಾ ಸಗ್‌ಳ್ಯಾ ಬೊಲ್ಯಾ ಬೆತಾನಿತ್ ಜಾ಼ಲ್ಯಾ ಹ್ಯ ಯೊರ್ದಾನ್ ನ್ಹಚೆ ಪುರ್ವಾಕ್ಡ ಹಾ ತಿಥ ಯೊಹಾನ್ ಬಾಪ್ತಿಸ್ಮಾ ದಿಯಿತಾ. ");
INSERT INTO gok_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","ದುಸ್ರೆ ದೀಸಿ ಯೊಹಾನ್ ಆಪ್ಲಿಪ ಯತ್ಯಾಲ್ಯಾ ಯೇಸುಲಾ ಬಗುನ್ ಆಸಾ ಮನ್ಲಾ, “ಬಗಾ, ದೇವಾಚಾ ಮೆಂಡ್ರಾಲಾ ಬಗಾ ತ್ಯ ದುನೆತ್ಲಿ ಪಾಪ ದುರ್ ಕರ್ತ. ");
INSERT INTO gok_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","ಮಾಜೆ ನಂತರ್ ಯೊಕ್ ಮಾನುಸ್ ಯನಾರ್ ತ್ಯೊ ಮಾಜಿವ್ನಿ ಮೊಟಾ ಹಾ ಕಾ ಮನ್‌ಲ್ಯಾವ ತ್ಯೊ ಮಿ ಜ಼ಲ್ಮಾಚೆ ಆಂದಿಸ್ ಆಸ್ಥಿತ್ವಾತ್ ಹುತ್ತಾ. ಆನಿ ಮಿ ಸಾಂಗ್‌ತ್ಯಾಲಾ ಹ್ಯಚೆ ಗುಶ್ಟಿತುಸ್. ");
INSERT INTO gok_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","ತ್ಯೊ ಕೊನ್ ಮನ್ಹುನ್ ಮನಾಬಿ ಠಾವಾ ನವ್ಥಾ ಫನ್ ತ್ಯಲಾ ಇಸ್ರಾಯಲ್ ಲೊಕಾನಾ ಸಾಂಗಾಯಾಸಾಟಿ ಮಿ ಲೊಕಾನಾ ಪಾನ್ಯಾನಿ ಬಾಪ್ತಿಸ್ಮಾ ದೇತೊ. ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","ಆನಿ ಯೊಹಾನಾನಿ ಆಪ್ಲಿ ವಳಕ್ ದಿವುನ್: ಸಾಂಗ್‌ಲ್ಯಾಲ ಕ್ಯಾ ಮಂಜೆ: “ಮಿ ಸ್ವರ್ಗಾತ್ನಿ ದೇವಾಚ಼ ಆತ್ಮ ಪ್ಯಾರ್ವ್ಯಾಚೆಗತ್ ತ್ಯಚಿವ ಆಲ್ಯಾಲ ಬಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","ತ್ಯೊ ಹ್ಯೊ ಮನ್ಹುನ್ ಮನಾಬಿ ಠಾವ ನವ್ಥ ಫನ್ ಕಚಾ ದೇವಾನಿ ಮನಾ ಪಾನ್ಯಾನಿ ಬಾಪ್ತಿಸ್ಮಾ ದಿಯಾಲಾ ಲಾವುನ್ ದಿಲ್ಯಾ ತ್ಯನಿ ಮನಾ ಸಾಂಗ್‌ಲ್ಯಾ ‘ತು ದೇವಾಚ಼ ಆತ್ಮ ವೈನಿ ಯಕಾ ಮಾನ್ಸಾವ ಉತಾರ್ತ್ಯಾಲ ಬಗ್ಸಿಲ್ ತ್ಯೊ ಪವಿತ್ರಾತ್ಮಾನಿ ಬಾಪ್ತಿಸ್ಮಾ ದೆತ್ಯಾಲಾ ಜಾ಼ಲ್ಯಾ’ ");
INSERT INTO gok_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","ಯೊಹಾನ್ ಮನ್ಲಾ, “ಮಿ ತ್ಯಲಾ ಬಗ್‌ಲ್ಯಾ ಆನಿ ಮೀಸ್ ತ್ಯಚಿ ಸಾಕ್ಷಿ ದೆತೊ ತ್ಯೊಸ್ ದೇವಾಚಾ಼ ಲ್ಯೊಕ್ ಜಾ಼ಲ್ಯಾ. ” ");
INSERT INTO gok_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","ದುಸ್ರೆ ದಿಸಿ ಯೊಹಾನ್ ಆನಿ ಯಂಗ್ದಾ ಆಪ್‌ಲ್ಯಾ ದೊಗಾ ಶಿಶಾಂಚೆ ಸಂಗ ಉಬಾ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ತಿಥ ಯೇಸುಲಾ ಚಾ಼ಲತ್ ಯತ್ಯಾಲಾ ಬಗುನ್. “ಬಗಾ ಹ್ಯ ದೇವಾಚ಼ ಮೆಂಡಾರ್!” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","ಯೊಹಾನಾಚಿ ಹಿ ಬುಲಿ ಐಕುನ್ ತೇ ದೊಗ ಶಿಶಾ ಯೇಸುಚೆ ಮಾಗ್ನಿ ಗೇಲ. ");
INSERT INTO gok_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","ತೇ ಆಪ್ಲೆ ಮಾಗ್ನಿ ಯತ್ಯಾಲ ಯೇಸುನಿ ಪರ್ತುನ್ ಬಗುನ್ ತ್ಯನಾ ಇಚಾರ್ಲ, “ತುಮಾನಾ ಕ್ಯಾ ವ್ಹಯಿ? ತವಾ ತೇ ದೊಗ ಮನ್ಲ, “ರಬ್ಬಿ ತು ಕುಠ ರಾಥೊಸ್? ರಬ್ಬಿ ಮಂಜೆ ಗುರು. ");
INSERT INTO gok_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","ಯೇಸುನಿ, ಮಾಜೆ ಸಂಗ ಯವಾ ತವಾ ತುಮಿಸ್ ಬಗ್ಸಿಲಾ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ ಮನ್ಹುನ್ ತೇ ದೊಗ ಜಾ಼ವುನ್ ಯೇಸು ರಾಥ್ಯಾಲಾ ಜಾ಼ಗಾ ಬಗ್ಲಾ ತವಾ ಸಾಂಜ಼ ಚಾರ್ ವಾಜ಼್ಲ ಹುತ್ತ ತಿಸಿ ತೆ ತಿಥ ರಾಯ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","ಯೊಹಾನಾಚಿ ಬುಲಿ ಐಕುನ್ ಯೇಸುಚೆ ಮಾಗ್ನಿ ಗೇಲ್ಯಾಲ್ಯಾ ದೊಗಾ ಶಿಶಾತ್ಲಾ. ಸಿಮೊನ್ ಪೇತ್ರಾಚಾ಼ ದಾಕ್ಠಾ ಬಾಹು ಆಂದ್ರೆಯ್ ಯೊಕ್ ಜಾ಼ಲ್ಥಾ. ");
INSERT INTO gok_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","ಆಂದಿ ತ್ಯೊ ಆಪ್ಲಾ ಬಾಹು ಜಾ಼ಲ್ಯಾಲ್ಯಾ ಸಿಮೊನಾಲಾ ಬಗಾಯಾ ಜಾ಼ವುನ್ ತ್ಯಲಾ ಆಮಿ ಮೆಸ್ಸಿಯಲಾ ಬಗ್ಲಾ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ ಮೆಸ್ಸಿಯಾ ಮಂಜೆ ಕ್ರಿಸ್ತ್. ");
INSERT INTO gok_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","ತ್ಯನಿ ಸಿಮೊನಾಲಾ ಯೇಸುಪ ಹಾಕ್ಟುನ್ ಆನ್ಲಾ. ಯೇಸು ಸಿಮೊನಾಕ್ಡ ಬಗುನ್, “ಯೊಹಾನಾಚಾ಼ ಲ್ಯೊಕ್ ಜಾ಼ಲ್ಯಾಲ್ಯಾ ತುಜ಼ ನಾವ್ ಸಿಮೊನ್ ತು ಕೇಫ ಮನ್ಹುನ್ ಗೆನ್ಹಾರ್” ಮನ್ಲಾ. ಕೇಫ ಮಂಜೆ ಪೇತ್ರ, “ಮಂಜೆ ಧ್ಯೊಂಡ್. ” ");
INSERT INTO gok_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","ದುಸ್ರೆ ದಿಸಿ ಯೇಸುನಿ ಗಲಿಲಾಯಾತ್ ಜಾ಼ಯಾ ತಿರ್ಮಾನ್ ಕೆಲಾ ಯೇಸುನಿ ಫಿಲಿಪ್ಪಾಲಾ ಬಗುನ್ ತ್ಯಲಾ, “ಮಾಜೆ ಮಾಗ್ನಿ ಯೇ” ಮನ್‍ಲ್ಹಾ. ");
INSERT INTO gok_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","ಆಂದ್ರೆಯ್ ಆನಿ ಪೇತ್ರಾಂಚಿಗತ್ ಫಿಲಿಪ್ಪಾ ಸಾಹಿತ್ ಬೆತ್ಸಾಯಿ ಪೆಠತ್ಲಾ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","ಫಿಲಿಪ್ಪಾನಿ ನತಾನಿಯೇಲಾ ಬಗುನ್ ತ್ಯಲಾ ಮನ್ಲಾ ಕುನಾಚೆ ಗುಶ್ಟಿತ್ ಮೊಶೆನಿ ಧರ್ಮಶಾಸ್ತಾರಾತ್ ಲಿವ್‌ಲ್ಯಾ ಆನಿ ಪ್ರವಾದಿಂಚಾನಿ ಲಿವ್‌ಲ್ಯಾ ತ್ಯಲಾ ಆಮಿ ಬಗ್ಲಾ ತ್ಯಚ಼ ನಾವ್ ಯೇಸು ತ್ಯೊ ನಜ಼ರೇತಿತಲ್ಯಾ ಯೊಸೆಫಾಚಾ಼ ಲ್ಯೊಕ್. ");
INSERT INTO gok_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","ಫನ್ ನತಾನಿಯೇಲಾನಿ ಫಿಲಿಪ್ಪಾಲಾ, “ನಜ಼ರೇತಿತ್ನಿ ಚಾ಼ಂಗ್ಲ ಕಾಯ್ತರಿ ಯತ್ಯಾ ಕ್ಯಾ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ತವಾ ಫಿಲಿಪ್ಪ್, “ಯವುನ್ ಬಗ್” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","ಯೇಸು ಆಪ್ಲಿಪ ಯತ್ಯಾಲ್ಯಾ ನತಾನಿಯೇಲಾ ಬಗುನ್ ತ್ಯಚೆ ಗುಶ್ಟಿತ್ ಹ್ಯೊ ಖರಾ ಇಸ್ರಾಯಲ್ ಹ್ಯಚಿಪ ಕಪಟ್ಪನ್ ನಾಹಿ ಮನ್ಹುನ್ ಸಾಂಗ್ ಲ ");
INSERT INTO gok_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","ನತಾನಿಯೇಲಾನಿ ತು ಮನಾ ಕಸಾ ಠಾವಾ ಹಾಸ್ ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ಯೇಸು ಫಿಲಿಪ್ಪಾಲಾ ಮನ್ಲಾ, “ತುಲಾ ಹಾಕ್ಟಾಚೆ ಆಂದಿ ತು ಆಂಜು಼ರಾಚಾ ಜಾ಼ಡಾಚೆ ಬುಡಿ ಬಗ್ಲಾ. ” ");
INSERT INTO gok_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","ತವಾ ನತಾನಿಯೇಲಾನಿ ತ್ಯಲಾ ಸಾಂಗ್ಲ, “ಗುರು ತುಸ್ ದೇವಾಚಾ಼ ಲ್ಯೊಕ್ ಆನಿ ಇಸ್ರಾಯಲಾಚಾ಼ ರಾಜಾ಼. ” ");
INSERT INTO gok_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","ಯೇಸುನಿ ತ್ಯಲಾ, “ತು ಆಂಜು಼ರಾಚಾ ಜಾ಼ಡಾಚೆ ಬುಡಿ ಹುತ್ತಾಸ್ ತವಾ ಮಿ ತುಲಾ ಬಗ್ಲಾ ಆಸ ಮಿ ಸಾಂಗ್‌ತ್ಯೊ ಮನ್ಹುನ್ ತು ಮಾಜಿವ ಇಸ್ವಾಸ್ ಥೆವ್ನಾರ್ ಕ್ಯಾ? ಫನ್ ತ್ಯಚಿವ್ನಿ ಮುಟಿ ಕಾಮ ತು ಬಗ್ನಾರ್!” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","ಯೇಸುನಿ ತ್ಯನಾ, “ಮಿ ತುಮಾನಾ ಖರ ಸಾಂಗ್ತೊ ಸ್ವರ್ಗ ಉಗಾಡ್‌ಲ್ಯಾಲ ಮಾನ್ಸಾಚಾ ಲೇಕಾಪ ದೇವ್ದುತ್ ಯತ್ಯಾಲ ವರ್ ಜಾ಼ತ್ಯಾಲ ತುಮಿ ಬಗ್ನಾರ್” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","ತಿಸ್ರೆ ದಿಸಿ ಗಲಿಲಾಯಾಚಾ ಕಾನಾ ಗಾವಾತ್ ಯಾಕ್ ಲಗಿನ್ ಹುತ್ತ. ಯೇಸುಚಿ ಆಯಿಬಿ ಹುತ್ತಿ, ");
INSERT INTO gok_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ಯೇಸುಲಾ ಆನಿ ತ್ಯಚಾ ಶಿಶಾನಾ ಸಾಹಿತ್ ಹಾಕಟ್ಲ ಹುತ್ತ. ");
INSERT INTO gok_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","ಲಗ್ನಾತ್ ವ್ಹಯಿ ತ್ಯವ್ಡಾ ದರಾಕ್ಶಿಚಾ಼ ರಸ್ ನವ್ಥಾ ಆಸ್‌ಲ್ಯಾಲಾ ದರಾಕ್ಶಿಚಾ಼ ರಸ್ ಸಗ್ಳಾ ಸಪ್ಲಾ ತವಾ ಯೇಸುಚೆ ಆಯಿನಿ ತ್ಯಲಾ, “ತ್ಯಂಚಿಪ ಕಚಾ಼ಸ್ ದರಾಕ್ಶಿಚಾ಼ ರಸ್ ನಾಹಿ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","ತವಾ ಯೇಸುನಿ, “ಬಾಯಿ ಹ್ಯ ಸಗ್ಳ ಮನಾ ತು ಕಾ ಸಾಂಗ್ತಿಸ್? ಮಾಜಾ಼ ಯೊಳ್ ಆಜು಼ನ್ ಆಲಾ ನಾಹಿ” ಮನ್‍ಲ್ಹಾ. ");
INSERT INTO gok_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","ಯೇಸುಚೆ ಆಯಿನಿ ಸೇವಕಾನಾ ಯೇಸು ತುಮಾನಾ ಕ್ಯಾ ಸಾಂಗ್ತೊ ತ್ಯ ಕರಾ, ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","ದೊಂಡ್ಯಾನಿ ಕೆಲ್ಯಾಲ್ಯಾ ಸಾ ಬಾನ್ಯಾ ತಿಥ ಹುತ್ಯಾ. ಯೆಹುದಿ ಲೊಕಾಂಚೆ ಪದ್ದತಿ ಶಾರ್ಕ ಶುದ್ದಾಚಾರ್ ಕರಾಯಾ ಹ್ಯಾ ದೊಂಡ್ಯಾಚಾ ಬಾನ್ಯಾ ಗಿಹಿತ. ಪರತೇಕ್ ಬಾನ್ಯಾತ್ನಿ ಐಸಿಸ್ನಿ ಏಕ್ಸೆ ಈಸ್ ಲೀಟರಾ ಇತ್ಕ ಪಾನಿ ರಾಹಿತ. ");
INSERT INTO gok_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","ಯೇಸುನಿ ಸೇವಕಾನಾ ತ್ಯಾ ಬಾನ್ಯಾತ್ನಿ ಪಾನಿ ಬರ‍್ಹಾ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ತಸಸ್ ಸೇವಕಾಂಚಾನಿ ಬಾನ್ಯಾ ಪಾನ್ಯಾನಿ ಟುಮ್ ಬರಿವ್‌ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","ತವಾ ಯೇಸುನಿ ಸೇವಕಾನಾ, “ಆತಾ ತ್ಯಾತ್ಲ ಥೊಡ ಪಾನಿ ಕಾಡುನ್ ಜೇವ್ನಾಚಿ ದೆಕ್ರೆಕಿ ಕರ್ತ್ಯಾಲ್ಯಾಪ ನಿಹುನ್ ದೆವಾ” ಮನ್ಹುನ್ ಸಾಂಗ್ತೊ. ತಸಸ್ ತ್ಯಂಚಾನಿ ನಿಹುನ್ ತ್ಯ ದಿಲ. ");
INSERT INTO gok_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","ಜೇವ್ನಾಚಿ ದೆಕ್ರೆಕಿ ಕರ್ತ್ಯಾಲ್ಯಾನಿ ದರಾಕ್ಶಿಚಾ಼ ರಸ್ ಜಾ಼ಲ್ಯಾಲ್ಯಾ ಪಾನ್ಯಾಚಿ ಚ಼ವ್ ಬಗ್ಲಿ ಆನಿ ತ್ಯೊ ದರಾಕ್ಶಿಚಾ಼ ರಸ್ ಕುಠ್ನಿ ಆಲಾ ಮನ್ಹುನ್ ತ್ಯಲಾ ಠಾವಾ ನವ್ಥಾ ಫನ್ ತ್ಯ ಪಾನಿ ಕ್ಯಾಡಲ್ಯಾಲ್ಯಾ ಸೇವಕಾನಾ ಠಾವ ಹುತ್ತ. ಜೆವ್ನಾಚಿ ದೆಕ್ರೆಕಿ ಕರ್ತ್ಯಾಲ್ಯಾನಿ ನವ್ಹರ‍್ಯಾಲಾ ಹಾಕ್ಟು‍ನ್ ");
INSERT INTO gok_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ಲೊಕ ಚಾ಼ಂಗ್ಲಾ ದರಾಕ್ಶಿಚಾ಼ ರಸ್ ಕವಾಬಿ ಆಂದಿ ವ್ಯಾಡ್‌ತ್ಯಾತ. ಪಾವ್ನ ಪಿವುನ್ ತೃಪ್ತ ಜಾ಼ಲ್ಯಾವ ತ್ಯನಾ ಸಾದಾ ದರಾಕ್ಶಿಚಾ಼ ರಸ್ ದೇತ್ಯಾತ. ಫನ್ ತು ಚಾ಼ಂಗ್ಲಾ ದರಾಕ್ಶಿಚಾ಼ ರಸ್ ಆಜು಼ನ್ ಪರ‍್ಯಾತ್ ಥೆವ್‌ಲ್ಯಾಸ್ ಮನ್ಹುನ್ ಸಾಂಗ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","ಕಾನಾ ಗಾವಾತ್ ಯೇಸುನಿ ಕೆಲ್ಯಾಲ ಪೈಲ ಚಮತ್ಕಾರ್. ತಿಥ ತ್ಯನಿ ಆಪ್ಲಿ ಮೈಮಾ ದ್ಯಾವ್ಲಿ. ತ್ಯಚಾ ಶಿಶಾಂಚಾನಿ ತ್ಯಚಿವ ಇಸ್ವಾಸ್ ಥೆವ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","ತ್ಯಾ ನಂತರ್ ಯೇಸು ಆಪ್ಲೆ ಆಯಿ, ಬಾವ್ಹಾಂಚೆ, ಶಿಶಾಂಚೆ ಸಂಗ ಕಪೆರ್ನೌಮ್ ಗಾವಾತ್ ಗೆಲಾ. ಆನಿ ತಿಥ ಥೊಡ ದೀಸ್ ರಾಯ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","ತವಾ ಯೆಹುದ್ಯಾಂಚಾ಼ ವಲ್ಯಾಂಡಾಚಾ಼ ಸನ್ ಖುಬ್ ಜ಼ವಳ್ ಜಾ಼ಲ್ಥಾ. ಮನ್ಹುನ್ ಯೇಸು ವರ್ ಯೆರುಸಲೇಮಿತ್ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","ದೇವ್ಳಾತ್ ಲೊಕ ಗುರ, ಮೆಂಡ್ರ ಆನಿ ಪ್ಯಾರ್ವ ಯಿಕ್‌ತ್ಯಾಲಿ ಯೇಸುನಿ ಬಗ್ಲ. ದುಸ್ರಿ ಲೊಕ ಟೆಬ್ಲಾಪ ಬಸುನ್ ಪೈಸ ಬದ್ಲಿ ಕರೀತ ಆನಿ ಯಾಪಾರ್ ಕರೀತ. ");
INSERT INTO gok_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","ಯೇಸುನಿ ದೊರ‍್ಯಾಂಚ಼ ತುಕ್ಡ ಗಿಹುನ್, ಯೊಕ್ ಚಾಬುಕ್ ವಳುನ್, ತ್ಯಾ ಜ಼ನಾವಾರಾನಾ ಆನಿ ಗುರಾನಾ, ಮೆಂಡ್ರಾನಾ ಬಾಹಿರ್ ಗ್ಯಾತ್ಲಿತ. ಯೇಸುನಿ ಟೆಬಲ್ ಪಾಡುನ್ ಪೈಸ ಟ್ಯಾಕ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","ಪ್ಯಾರ್ವ ಇಕ್‌ತ್ಯಾಲ್ಯಾನಾ, “ತುಮಿ ಹ್ಯನಾ ಬಾಹಿರ್ ಗಿಹುನ್ ಜಾ಼ವಾ ಮಾಜಾ ಬಾಚ಼ ಘರ್ ಯಾಪಾರಾಚಾ಼ ಜಾ಼ಗಾ ಕರುನಕೊಸಾ” ಮನ್ಹುನ್ ಸಾಂಗ್ತೊ ");
INSERT INTO gok_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","ತುಜಾ ದೇವ್ಳಾವ್ಲಿ ಮಾಯಾ ಮಾನಾ ಇಸ್‌ತ್ಯಾಚಿಗತ್ ಜಾಳ್ತೆ ಮನ್ಹುನ್ ಪವಿತ್ರ ಪುತೀಕಾತ್ ಲಿವ್‌ಲ್ಯಾಲ ಸಬ್ದ ಯೇಸುಚಾ ಶಿಶಾಂಚಾನಿ ಯಾದ್ ಕಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","ಯೆಹುದಿ ಜಾಂತ ತ್ಯಚಿಪ ಯವುನ್, “ಹ್ಯ ಸಗ್ಳ ಕರಾಯಾ ತುಲಾ ಹುಕುಮ್ ಹಾ ಮನ್ಹುನ್ ದಾವಾಯಾ ಕಸ್ಲಿ ಚಮತ್ಕಾರಾಚಿ ಕಾಮ ಕರ್ನಾರ್? ಹ್ಯನಿ ತು ಕ್ಯಾ ಕರ್ತ್ಯೊಸ್ ತ್ಯಚಾ಼ ಹುಕುಮ್ ಖರಾ ವ್ಹಯಿಲ್ ಮನ್‍ಲ್ಹ. ");
INSERT INTO gok_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","ತವಾ ಯೇಸುನಿ, “ಹ್ಯ ದಿವುಳ್ ಪಾಡಾ, ತೀನ್ ದಿಸಾತ್ ತ್ಯ ಮಿ ಆನಿಕ್ ಬ್ಯಾಂತೊ” ಮನ್‍ಲ್ಹಾ. ");
INSERT INTO gok_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","ಯೆಹುದಿ ತ್ಯಲಾ ಮನ್‍ಲ್ಹ, “ಹ್ಯ ದಿವುಳ್ ಬಾಂದಾಯಾ ಚಾಳ್ಸಾವ ಸಾ ವರ್ಸ ಲಾಗ್‍ಲ್ಯಾತ! ಆನಿ ತು ಹ್ಯ ಪರ್ತುನ್ ತೀನ್ ದಿಸಾತುಸ್ ಬ್ಯಾಂತೋಸ್ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","ಫನ್ ಯೇಸು ಕಚಾ ದೇವ್ಳಾಚೆ ಗುಶ್ಟಿತ್ ಬೊಲತಾ ಮಂಜೆ ತ್ಯ ತ್ಯಚ಼ ಸ್ವತಾಚ಼ ಶರಿರ್ ಜಾ಼ಲ್ಥ. ");
INSERT INTO gok_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","ಯೇಸು ಮೆಲ್ಯಾಲ್ಯಾತ್ನಿ ಉಠುನ್ ಆಲಾ ತವಾ ತ್ಯಚಾ ಶಿಶಾಂಚಾನಿ ತ್ಯಚಾ ಹ್ಯಾ ಬೊಲ್ಯಾಂಚಿ ಯಾದ್ ಕಿಲಿ. ಆನಿ ತ್ಯಂಚಾನಿ ಪವಿತ್ರ ಪುತೀಕಾವ ಆನಿ ತ್ಯನಿ ಸಾಂಗ್‌ಲ್ಯಾಲೆ ಸಗ್ಳೆ ಬುಲ್ನಿವ ಇಸ್ವಾಸ್ ಥೆವ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","ಯೇಸು ವಲ್ಯಾಂಡಾಚಾ ಸನಾಲಾ ಯೆರುಸಲೇಮಿತ್ ಹುತ್ತಾ ತ್ಯನಿ ಕೆಲ್ಯಾಲಿ ಚಮತ್ಕಾರಾಚಿ ಕಾಮ ಬಗ್ಲಿತ ತವಾ ಖುಬ್ ಲೊಕಾಂಚಾನಿ ತ್ಯಚಿವ ಇಸ್ವಾಸ್ ಥೆವ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","ಫನ್ ಯೇಸುನಿ ಆಪ್‌ಲ್ಯಾಸ್ ತ್ಯಂಚಾ ಇಸ್ವಾಸಾವ ಶೊಡ್ಲಾ ನಾಹಿ. ಕಾ ಮಂಜೆ ತೀ ತ್ಯಲಾ ಚಾ಼oಗ್ಲಿ ಠಾವಿ ಹುತ್ತಿತ. ");
INSERT INTO gok_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","ಲೊಕಾಂಚೆ ಗುಶ್ಟಿತ್ ತ್ಯಲಾ ಕುನಿಸ್ ಸಾಂಗಾಯಾ ನಕೊ ಹುತ್ತ. ಮಾನ್ಸಾಚಾ ಮನಾತ್ ಕ್ಯಾ ಹಾ ಮನ್ಹುನ್ ಯೇಸುಲಾ ಠಾವ ಹುತ್ತ. ");
INSERT INTO gok_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","ತ್ಯೊ ಯೊಕ್ ಯೆಹುದಿ ಮುಖ್ಯ ಅಧಿಕಾರಿ ಹುತ್ತಾ ತ್ಯಚ಼ ನಾವ್ ನಿಕೊದೇಮ್ ಆನಿ ತ್ಯೊ ಫರಿಸಾಯಾತ್‌ಲ್ಯಾ ಮೆಳ್ಯಾತ್ಲಾ ಯೊಕ್ ಜಾ಼ಲ್ಥಾ. ");
INSERT INTO gok_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","ಯಕಸಿ ರ‍್ಯಾಚಾ಼ ನಿಕೊದೇಮ್ ಯೇಸುಪ ಆಲಾ. ನಿಕೊದೇಮಾನಿ, “ಗುರು, ತು ದೇವಾಪ್ನಿ ಲಾವುನ್ ದಿಲ್ಯಾಲಾ ಸಿಕಿವ್ನಾರಾ ಮನ್ಹುನ್ ಆಮಾನಾ ಠಾವಾ ಹಾ ತು ಕರ್ತ್ಯಾಲಿ ಹಿ ಚಮತ್ಕಾರ್ ದೇವಾಚಿ ಮಜ಼ತ್ ನಸ್ಥಾನಾ ಕುನಾಲಾ ಕರಾಲಾ ವ್ಹಯಿತ್ ನಾಹಿ” ಮನ್ಲಾ ");
INSERT INTO gok_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","ಯೇಸುನಿ ಸಾಂಗ್ಲ, “ಮಿ ತುಮಾನಾ ಖರ ಸಾಂಗ್ತೊ ಯೊಕ್ ನವಿನಿ ಜ಼ಲ್ಮಾಲಾ ಪಾಯ್ಜೆ ಯೊಕ್ ನವಿನಿ ಜ಼ಲಾಮ್ಲಾ ನಾಹಿತ ತ್ಯೊ ದೇವಾಚ಼ ರಾಜೆ ಬಗ್ನಾರ್ ನಾಹಿ. ” ");
INSERT INTO gok_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","ನಿಕೊದೇಮಾನಿ ತ್ಯಲಾ ಇಚಾರ್ಲ, “ಯೊಕ್ ಮಾನುಸ್ ಮಾಥಾರ ಜಾ಼ಲ್ಯಾವ ಜ಼ಲಾಮ್ನಾರ್ ಕಸ? ಯಕಾ ಮಾನ್ಸಾನಿ ಆಪ್ಲೆ ಆಯಿಚಾ ಪೊಟಾತ್ ಆನಿಕ್ ಯಂಗ್ದಾ ಜಾ಼ಯಾ ವ್ಹಯಿಲ್ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","ತ್ಯಲಾ ಯೇಸುನಿ, “ಮಿ ತುಮಾನಾ ಖರ ಸಾಂಗ್ತೊ ಯೊಕ್ ಪಾನ್ಯಾನಿ ಆತಮ್ಯಾನಿ ಜ಼ಲ್ಮಾಯಾ ಪಾಯ್ಜೆ ನಾಹಿತ ತ್ಯೊ ದೇವಾಚಾ ರಾಜಾತ್ ಜಾ಼ನಾರ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","ಯೊಕ್ ಮಾನುಸ್ ಶರಿರಾತ್ ಆಪ್‌ಲ್ಯಾ ಆಯಿಬಾನಿ ಜ಼ಲಾಮ್ತೊ. ಫನ್ ಆತ್‌ಮ್ಯಾಚಾ ಜಿವ್ನಾತ್ ಆತ್‌ಮ್ಯಾನಿ ಜ಼ಲಾಮ್‌ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","‘ತು ನವಿನಿ ಜ಼ಲ್ಮಾಲಾಸ್ ಪಾಯ್ಜೆ’ ಮನ್ಹುನ್ ಮಿ ಸಾಂಗ್‌ಲ್ಯಾಲ್ಯಾಲಾ ಗಾಬ್ರು ನಕೊಸ್. ");
INSERT INTO gok_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","ವಾರ ಆಪ್‌ಲ್ಯಾಲಾ ಮನ್ ಯಯಿಲ್ ತಿಕ್ಡ ಜಾತ. ವಾರ‍್ಯಾಚಾ಼ ಆವಾಜ಼್ ತು ಐಕ್ತೊಸ್ ಖರ ವಾರ ಕುನಿಕ್ನಿ ಯತ ಆನಿ ಕುನಿಕ್ನಿ ಜಾ಼ತ ತುಲಾ ಸಮಜ಼ತ್ ನಾಹಿ. ಆತ್‌ಮ್ಯಾನಿ ಜ಼ಲಾಮ್‌ಲ್ಯಾಲಾ ಪರತೇಕ್ ಯೊಕ್ ತ್ಯಚಿಗತ್ ಹಾ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","ನಿಕೊದೇಮಾನಿ, “ಹ್ಯ ಸಗ್ಳ ಕಸ ವ್ಹನಾರ್? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","ಯೇಸು ಮನ್ಲಾ, “ತು ಇಸ್ರಾಯಲಾಚಾ಼ ಮೊಟಾ ಸಿಕಿವ್ನಾರಾ ಜಾ಼ಲ್ಯಾಸ್ ಆನಿ ಹ್ಯಾ ಖನ್ಕತಿ ತುಲಾ ಸಮಜ಼ತ್ ನಾಹಿತಾ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","ಮಿ ತುಮಾನಾ ಖರ ಸಾಂಗ್ತೊ. ಆಮಾನಾ ಠಾವ್ಯಾ ಆಸ್‌ಲ್ಯಾಲ್ಯಾಚೆ ಗುಶ್ಟಿತ್ ಆಮಿ ಬೊಲ್ತಾವ್ ಆಮಿ ಬಗ್‌ಲ್ಯಾಲ್ಯಾಚೆ ಗುಶ್ಟಿತ್ ಆಮಿ ಸಾಕ್ಷಿ ದೇತಾವ್. ತರಿಬಿ ಆಮಿ ಸಾಂಗ್‌ಲ್ಯಾಲ ತುಮಿ ಖರ ದರಿತ್ನಾಹಿಸಾ. ");
INSERT INTO gok_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","ಮಿ ತುಮಾನಾ ದರ್ಥಿವ್ಲೆ ಗುಶ್ಟಿಂಚ಼ ಸಾಂಗ್ಲತರಿ ತುಮಿ ಮಾಜಿವ ಇಸ್ವಾಸ್ ಥಿವಿತ್ನಾಹಿಸಾ. ತ ಮಿ ಸ್ವರ್ಗಾಚೆ ಗುಶ್ಟಿಂಚ಼ ತುಮಾನಾ ಸಾಂಗ್‌ಲ್ಯಾವ ತುಮಿ ಕಸಾ ಇಸ್ವಾಸ್ ಥೆವ್ನಾರ್? ");
INSERT INTO gok_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","ಸ್ವರ್ಗಾತ್ನಿ ಉತ್ರುನ್ ಆಲ್ಯಾಲ್ಯಾ ಮಾನ್ಸಾಚಾ ಲೇಕಾಲಾ ಸುಡುನ್ ಕೊನುಸ್ ಸ್ವರ್ಗಾತ್ ಗೇಲಾನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","ಕಸಾ ಮೊಶೆನಿ ಉಸ್ಕಚೆ ಜಿಮ್ನಿವ ಸಾಪಾಲಾ ಉಚ಼್ ಖಾಂಬಾವ ಥೆವ್ಲಾ. ತಸಾ ಮಾನ್ಸಾಚಾ ಲೇಕಾಲಾಬಿ ಉಚ಼್ ಖಾಂಬಾವ ಥೆವ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ಆನಿ ಕೊನ್ ತ್ಯಚಿವ ಇಸ್ವಾಸ್ ಥೆವ್ನಾರ್ ತ್ಯೊ ಶಾಶ್ವತ್ ಜೀವ್ ಗೇನಾರ್ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ ");
INSERT INTO gok_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","ವ್ಹಯ್, ದೇವಾನಿ ದುನೆಚಿ ಖುಬ್ ಮಾಯಾ ಕರುನ್ ಆಪ್‌ಲ್ಯಾ ಯಕ್‍ಲ್ಯಾಸ್ ಲೇಕಾಲಾ ಲಾವುನ್ ದಿಲಾ ತ್ಯಚಿವ ಇಸ್ವಾಸ್ ಥೆವ್‌ಲ್ಯಾಲಾ ಪರತೇಕ್ ಯೊಕ್ಬಿ ನಾಸ್ ವ್ಹವುನಾಹಿ ಮನ್ಹುನ್ ಸಗ್‌ಳ್ಯಾನಾ ಶಾಶ್ವತ್ ಜೀವ್ ಗಾವ್ಹಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ತ್ಯಲಾ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","ದೇವಾನಿ ಆಪ್‌ಲ್ಯಾ ಲೇಕಾಲಾ ಹೆ ದುನೆತ್ ಲಾವುನ್ ದಿಲ್ಯಾಲಾ ತ್ಯಚಿಪ್ನಿ ಹೆ ದುನೆತ್‌ಲ್ಯಾ ಲೊಕಾನಾ ಗುನ್ನದಾರ್ ಮನ್ಹುನ್ ನ್ಯಾಯಿ ನಿವ್ಡಾಯಾ ನವ್ಹ ರಕ್ಶನ್ ಗಿಹುಂತ ಮನ್ಹುನ್ ದೇವಾನಿ ತ್ಯಲಾ ಲಾವುನ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","ದೇವಾಚಾ ಲೇಕಾವ ಇಸ್ವಾಸ್ ಥೆವ್‍ಲ್ಯಾಲ್ಯಾಚಾ಼ ನ್ಯಾಯಿ ತಿರ್ಮಾನ್ ವ್ಹಯಿತ್ನಾಹಿ ಫನ್ ತ್ಯಚಿವ ಇಸ್ವಾಸ್ ಥೆವ್‌ಲ್ಯಾ ನಸಲ್ಯಾಲ್ಯಾಚಾ಼ ತವಾಸ್ ನ್ಯಾಯಿ ತಿರ್ಮಾನ್ ಜಾ಼ಲ್ಯಾ ಕಾ ಮಂಜೆ ತ್ಯನಿ ದೇವಾಚಾ ಯಕ್‌ಲ್ಯಾಸ್ ಲೇಕಾವ ಇಸ್ವಾಸ್ ಥೆವ್ಲಾ ನಾಹಿ ");
INSERT INTO gok_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","ನ್ಯಾಯಿತಿರ್ಮಾನಾಚ಼ ಕಾಮ್ ಆಸ ಹಾ: ಉಜಿಡ್ ದುನೆತ್ ಆಲಾ ಫನ್ ಲೊಕಾಂಚಾನಿ ಉಜಿಡಾಚೆ ಬದ್ಲಿ ಆಂದಾರಾಲಾ ಮಾಯಾ ಕಿಲಿ. ಕಾ ಮಂಜೆ ತ್ಯಂಚಿ ಕಾಮ ಬುರ್ಸಿ ಹುತ್ತಿತ. ");
INSERT INTO gok_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","ಬುರ್ಸ ಕರ್ತ್ಯಾಲಾ ಪರತೇಕ್ ಜಾ಼ನ್ ಉಜಿಡಾಚಾ಼ ರಾಗ್ ಕರ್ತೊ ತ್ಯೊ ಉಜಿಡಾತ್ ಯಯಿತ್ನಾಹಿ ಕಾ ಮಂಜೆ ತ್ಯನಾ ತ್ಯಂಚಿ ಬುರ್ಸಿ ಕಾಮ ಉಜಿಡಾತ್ ದಾವಾಯಾ ಮನ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","ಫನ್ ಕೊನ್ ಖರ‍್ಯಾಚೆ ವಾಟನಿ ಚಾ಼ಲ್ತೊ ತ್ಯೊ ಉಜಿಡಾಕ್ಡ ಯತೊ. ಕಾ ಮಂಜೆ ಉಜಿಡಾತ್ ತ್ಯಂಚಿ ಕಾಮ ದಿಸುಂತ ತ್ಯಂಚಾನಿ ಕೆಲ್ಯಾತ ತೀ ದೇವಾಪ್ನಿ ಕೆಲ್ಯಾಲಿ ಜಾ಼ಲ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","ತ್ಯಾ ನಂತರ್ ಯೇಸು ಆನಿ ತ್ಯಚ಼ ಶಿಶಾ ಯುದಾಯ್ ಸಿಮತ್ ಗೆಲ ತಿಥ ತ್ಯನಿ ತ್ಯಂಚಿ ಸಂಗ ಕಾಯ್ ಯೊಳ್ ರಾಯ್ಲಾ ಆನಿ ಬಾಪ್ತಿಸ್ಮಾ ದಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","ಯೊಹಾನ್ ಸಾಹಿತ್ ಸಲೆಮಿಪ ಐನೊನಿತ್ ಬಾಪ್ತಿಸ್ಮಾ ದಿಯಿತಾ ಕಾ ಮಂಜೆ ತಿಥ ವ್ಹತಸ ಪಾನಿ ಹುತ್ತ ಲೊಕ ತಿಥ ಯವುನ್ ಬಾಪ್ತಿಸ್ಮಾ ಗಿಹಿತಿತ. ");
INSERT INTO gok_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","ತಬರ್ ಯೊಹಾನಾಲಾ ತುರುಂಗಾತ್ ಗ್ಯಾತ್ಲಾ ನವ್ಥಾ. ");
INSERT INTO gok_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","ಯೊಹಾನಾಚಾ ಶಿಶಾತ್‌ಲ್ಯಾ ಥೊಡ್ಯಾಂಚಾ಼ ಆನಿ ಯಕಾ ಯೆಹುದ್ಯಾಚಾ಼ ದಾರ್ಮಿಕ್ ಶುದ್ದಾಚಾರಾಚೆ ಗುಶ್ಟಿತ್ ವಾದ್ ಚಾ಼ಲ್ಲಾ ");
INSERT INTO gok_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","ಮನ್ಹುನ್ ಯೊಹಾನಾಪ ಯವುನ್ ಸಾಂಗ್ಲ, “ಗುರು, ಕ್ಯಾ ತುಲಾ ಯಾದ್ ಹಾ ತ್ಯೊ ಮಾನುಸ್ ಯೊರ್ದಾನ್ ನ್ಹಚೆ ಪಲಿಕ್ಡ ತುಜಿ ಸಂಗ ಹುತ್ತಾ ಆನಿ ತ್ಯಚೆ ಗುಶ್ಟಿತ್ ತು ಸಾಂಗ್ಲ ಹುತ್ತಸ್? ತ್ಯೊಸ್ ಲೊಕಾನಾ ಬಾಪ್ತಿಸ್ಮಾ ದೇತ್ಯೊ ಖುಬ್ ಲೊಕ್ ತ್ಯಚಿಪ ಜಾ಼ತ್ಯಾತ” ");
INSERT INTO gok_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","ಯೊಹಾನಾನಿ ಉತ್ತರ್ ದಿಲಾ, “ದೇವಾನಿ ಸ್ವರ್ಗಾತ್ನಿ ದಿಲ್ಯಾಲ ತ್ಯವ್ಡಸ್ ಸುಡುನ್ ಮಾನ್ಸಾಲಾ ದುಸ್ರ ಕಾಯೇಕ್ ಗಾವ್ನಾರ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","ತುಮಿ ಸಗ್ಳಿ ಸಾಕ್ಶಿ ಹಾಸಾ ಮಿ ಸಾಂಗ್ಲ ಹುತ್ತ: ಮಿ ಕ್ರಿಸ್ತ ನವ್ಹ ಫನ್ ಮನಾ ತ್ಯಚೆ ಆಂದಿಸ್ ಲಾವುನ್ ದಿಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","ನವ್ರಿ ನವ್ಹರ‍್ಯಾಚಿಸ್ ವ್ಹತ್ತಿ. ನವ್ಹರ‍್ಯಾಲಾ ಮಜ಼ತ್ ಕರ್ತ್ಯಾಲಾ ಸುಪ್ತಿ ನವ್ರಾ ಯತ್ಯಾಲಿ ವಾಟ್ ಬಗ್ತೊ ಆನಿ ತ್ಯಚಾ ಸಬ್ದಾಲಾ ಕಾನ್ ದೇತೊ ನವರ‍್ಯಾಚಾ಼ ಸಬ್ದ ಐಕ್ತಾನಾ ಹ್ಯೊ ಸುಪ್ತಿ ಖುಬ್ ಸಂತೊಶ್ ವ್ಹತೊ ತ್ಯೊ ಮಾಜಾ಼ ಸಂತೊಶ್ ಪುರ್ನ ಜಾ಼ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","ತ್ಯೊ ಥೊರ್ ವ್ಹಯಾ ವ್ಹಯಿ ಆನಿ ಮಿ ನ್ಹಾನ್ ವ್ಹಯಾ ವ್ಹಯಿ. ");
INSERT INTO gok_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","ಕೊನ್ ವೈನಿ ಆಲ್ಯಾ ತ್ಯೊ ಸಗ್‌ಳ್ಯಾವ್ನಿ ಮೊಟಾ ಆನಿ ಕೊನ್ ದರ್ಥಿವ್ಲಾ ಹಾ ತ್ಯೊ ದರ್ಥಿಲಾ ಸಂಬದ್ ಆಸ್‌ಲ್ಯಾಲ ಬೊಲ್ತೊ. ಫನ್ ಕೊನ್ ಸ್ವರ್ಗಾತ್ನಿ ಆಲ್ಯಾ ತ್ಯೊ ಸಗ್‌ಳ್ಯಾವ್ನಿ ಮೊಟಾ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ತ್ಯೊ ಆಪ್ನು ಬಗ್‌ಲ್ಯಾಲ ಆನಿ ಐಕ್‌ಲ್ಯಾಲ್ಯಾಚೆ ಗುಶ್ಟಿತ್ ಸಾಕ್ಶಿ ದೆತೊ. ಫನ್ ತ್ಯಚಿ ಸಾಕ್ಶಿ ಲೊಕ ಖರಿ ದರಿತ್ನಾಹಿತ. ");
INSERT INTO gok_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","ಫನ್ ಕೊನ್ ತ್ಯಚಿ ಸಾಕ್ಶಿ ಖರಿ ಮಂಥೊ ತ್ಯೊ ಆಸ ಕರ್ತ್ಯಾಲ್ಯಾನಿ ದೇವ್ ಖರಾ ಮನ್ಹುನ್ ಸಾಬಿತ್ ಕರ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","ದೇವಾನಿ ಕುನಾಲಾ ಲಾವುನ್ ದಿಲ್ಯಾ ತ್ಯೊ ದೇವಾಚಿ ಬುಲಿ ಬೊಲ್ತೊ ಕಾ ಮಂಜೆ ದೇವಾನಿ ಆತ್‌ಮ್ಯಾಚಿ ಪರಿಪುರ್ನತಾ ತ್ಯಲಾ ದಿಲೆ. ");
INSERT INTO gok_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","ಬಾ ಲೇಕಾಚಿ ಮಾಯಾ ಕರ್ತೊ ಬಾನಿ ಲೇಕಾಲಾ ಸಗ್‌ಳ್ಯಾವ ಹುಕುಮ್ ದಿಲ್ಯಾ ");
INSERT INTO gok_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","ಜೆ ಕಚಾನಿ ಲೇಕಾವ ಇಸ್ವಾಸ್ ಥೆವ್‌ಲ್ಯಾ ತ್ಯಲಾ ಶಾಶ್ವತ್ ಜೀವ್ ದೆತೊ ಫನ್ ಲೇಕಾನಿ ಸಾಂಗ್‌ಲ್ಯಾ ಶಾರ್ಕ ಚಾ಼ಲತ್ ನಸ್ನಾರ‍್ಯಾಲಾ ಶಾಶ್ವತ್ ಜೀವ್ ಕವಾಸ್ ಗಾವ್‌ನ್ಹಾರ್ ನಾಹಿ ದೇವಾಚಾ಼ ರಾಗ್ ತ್ಯಚಿವ ರಾಥೊ. ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","ಆಪ್ನು ಯೊಹಾನಾವ್ನಿ ಜಾಸ್ಥಿ ಶಿಶಾ ಕರುನ್ ತ್ಯನಾ ಬಾಪ್ತಿಸ್ಮಾ ದೆತ್ಯಾಲಿ ಖಬರ್ ಫರಿಸಾಯಾನಾ ಸಮಾಜ್ಲಿ ಮನ್ಹುನ್ ಯೇಸುಲಾ ಸಮಾಜ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","ಫನ್ ಖರ‍್ಯಾನಿ ಲೊಕಾನಾ ಬಾಪ್ತಿಸ್ಮಾ ದಿಲ್ಯಾಲಿ ಯೇಸುನಿ ನವ್ಹ ತ್ಯಚಾ ಶಿಶಾಂಚಾನಿ ದಿಲ್ಯಾಲಿ. ");
INSERT INTO gok_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","ಸಗ್‌ಳ್ಯಾಂಚಾನಿ ಬೊಲ್ಯಾಲ ಐಕ್ಲ ತವಾ ತ್ಯೊ ಯುದಾಯ ಸುಡುನ್ ಆನಿ ಪರತ್ ಗಲಿಲಾಯಾತ್ ಗೇಲಾ ");
INSERT INTO gok_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","ಯೇಸು ಜಾ಼ತಾನಾ ಸಮಾರ್ಯ ಸಿಮಾ ವಲ್ಯಾಂಡುನ್ ಗಲಿಲಾಯಾತ್ ಜಾ಼ಯಾಚಾ಼ ಹುತ್ತ. ");
INSERT INTO gok_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","ಯೇಸು ಸಮಾರ್ಯಾಚಿ ಪ್ಯಾಟ್ ಸುಖಾರ್ ಮಂಥ್ಯಾತ ತಿಥ ಆಲಾ ಯಾಕೊಬಾನಿ ಆಪ್ಲಾ ಲ್ಯೊಕ್ ಯೊಸೆಪಾಲಾ ದಿಲ್ಯಾಲೆ ಜಿಮ್ನಿಚೆ ಜವಳ್ ತ್ಯ ಗಾವ್ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","ಯಾಕೊಬಾಚಿ ಬ್ಯಾವ್ ತಿಥ ಹುತ್ತಿ ಯೇಸು ಚಾ಼ಲುನ್ ದಮ್ಲಾ ಹುತ್ತಾ. ಮನ್ಹುನ್ ತ್ಯೊ ಬಾವಿಪ ಬಸ್ಲಾ ತವಾ ಜ಼ವ ಜ಼ವಳ್ ದ್ಯೊಪ್ಯಾರ‍್ಚಾ ಯೊಳ್ ಜಾ಼ಲ್ಥಾ. ");
INSERT INTO gok_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","ಯೇಕ್ ಸಮಾರ್ಯಾಚೆ ಸಿಮತ್ಲಿ ಬಾಯಿಲ್ ಮಾನುಸ್ ಪಾನಿ ನಿಹ್ಯಾ ತೇ ಬಾವಿಪ ಆಲಿ ಯೇಸುನಿ ತಿಚಿಪ, “ಪಿಯಾ ಥೊಡ ಪಾನಿ ದಿತಿಸ್ ಕ್ಯಾ? ಮನ್ಹುನ್ ಮಾಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","ತ್ಯಚ಼ ಶಿಶಾ ಖಾಯಾ ಕಾಯ್ತರಿ ಆನಾಯಾ ಪೆಠತ್ ಗೆಲ್ತ. ");
INSERT INTO gok_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","ತೀ ಸಮಾರ‍್ಯಾಚಿ ಬಾಯಿಲ್ ಮಾನುಸ್ ತು ಪಿಯಾ ಪಾನಿ ಮಾಜಿಪ ಮಾಗಾಚ಼ ಮನಾ ಆಜಾಬ್ ವಾಟ್ಯಾ ತು ಯೊಕ್ ಯೆಹುದಿ ಆನಿ ಮಿ ಯೆಕ್ ಸಮಾರ್ಯಾತ್ಲಿ ಮನ್‌ಲ್ಹಿ. ಯೆಹುದ್ಯಾಂಚೆ ಆನಿ ಸಮಾರ‍್ಯಾಂಚೆ ಮದ್ದಿ ಕಸ್ಲಾಸ್ ಸಮಂದ್ ನವ್ಥ. ");
INSERT INTO gok_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","ಯೇಸುನಿ ತಿಲಾ ಸಾಂಗ್ಲ, “ಯಕ ಯಳಿ ದೇವಾನಿ ದಿಲ್ಯಾಲ ವರಾ ಕ್ಯಾ ಮನ್ಹುನ್ ತು ಯವ್ಡ ಸಮಾಜ್ಲಿ ಆಸ್ಥಿತ ‘ಪಿಯಾ ಪಾನಿ ದೇ ಮನ್ಹುನ್ ತುಲಾ ಇಚಾರ್ಲ್ಯಾಲಾ ಕೊನ್ ಮನ್ಹುನ್ ಸಮಾಜ್ಲಾ ಆಸ್ಥಾತ ತ್ಯಚಿಪ ಮಾಗ್ಲ ಆಸ್ಥಸ್ ಆನಿ ತ್ಯೊ ತುಲಾ ಜೀವಾಚಾ಼ ಜ಼ರ‍್ಹಾ ದಿಯಿತಾ. ” ");
INSERT INTO gok_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","ತೀ ಬಾಯಿಲ್ ಮಾನುಸ್ ಪ್ರಭುಲಾ ತ್ಯೊ ಜೀವಾಚಾ಼ ಜ಼ರ‍್ಹಾ ತುಲಾ ಕುಠ ಗಾವ್ನಾರ್? ಬ್ಯಾವ್ ಖುಬ್ ಖೊಲ್ ಹಾ ಆನಿ ಪಾನಿ ಕಾಡಾಯಾ ತುಜಿಪ ಕಾಯ್ ಐದಾನ್ ನಾಹಿ, ");
INSERT INTO gok_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","ಆಮಾನಾ ಹಿ ಬ್ಯಾವ್ ಯಾಕೊಬಾನಿಸ್ ದಿಲೆ. ಆನಿ ತ್ಯೊಸ್ ಹ್ಯ ಪಾನಿ ಪಿಯಾಲ್ಯಾ ತ್ಯಚಿ ಪೊರ ಹೆ ಬಾವಿಚ಼ ಪಾನಿ ಪಿಯಾಲಿತ ತ್ಯಚಿ ಜ಼ನಾವಾರ ಸಗ್ಳಿ ಹೆ ಬಾವಿಚ಼ ಪಾನಿ ಪಿಯಾಲಿತ ತ್ಯಾ ಆಮ್ಚಾ ವಡಿಲ್ ಯಾಕೊಬಾವ್ನಿ ತು ಥೊರ‍್ಲಾ ಕ್ಯಾ? ಮನ್‌ಲ್ಹಿ. ");
INSERT INTO gok_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","ಯೇಸು ಮನ್‍ಲ್ಹಾ, “ಹ್ಯ ಪಾನಿ ಪಿತ್ಯಾಲ್ಯಾ ಪರತೇಕಾಲಾ ಪರತ್ ಆನಿಕ್ ತಾನ್ ಲಾಗ್ನಾರ್, ");
INSERT INTO gok_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","ಫನ್, ಮಿ ದೇತ್ಯಾಲ ಪಾನಿ ಕೊನ್ ಪಿತಿಲ್ ತ್ಯನಾ ತಾನುಸ್ ಲಾಗ್ನಾರ್ ನಾಹಿ. ಮಿ ತ್ಯನಾ ದೇತ್ಯಾಲ ತ್ಯಂಚೆ ಆತ್ ಪಾನ್ಯಾಚಾ಼ ಜ಼ರ‍್ಹಾ ವ್ಹನಾರ್. ಆನಿ ತ್ಯ ಪಾನಿ ತ್ಯನಾ ಶಾಶ್ವತ್ ಜೀವ್ ದೇತ. ” ");
INSERT INTO gok_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","ತವಾ ತೀ ಬಾಯಿಲ್ ಮಾನುಸ್ ಯೇಸುಲಾ, “ಪ್ರಭು ತ್ಯ ಪಾನಿ ಮನಾ ದೇ! ಮನಾ ಆನಿ ಕಂದಿಸ್ ತಾನ್ ಲಾಗತ್ ನಾಹಿ. ಮಿ ಪಾನಿ ನಿಹ್ಯಾ ಹಿತ ಆನಿ ಯಯಾಚಿ ಗರಜ಼್ ನಾಹಿ” ಮನ್‌ಲ್ಹಿ. ");
INSERT INTO gok_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","ಯೇಸುನಿ ತಿಲಾ, “ಜಾ಼ವುನ್ ತುಜಾ ದನ್ಗಾರಾಲಾ ಹಾಕ್ಟುನ್ ಗಿಹುನ್ ಯೇ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","ತವಾ ತೀ ಬಾಯಿಲ್ ಮಾನುಸ್, “ಮನಾ ದನ್ಗೊರ್ ನಾಹಿ” ಮನ್‌ಲ್ಹಿ ಯೇಸು ತಿಲಾ ಮನ್‍ಲ್ಹಾ, “ತಲಾ ದನ್ಗೊರ್ ನಾಹಿ ಮನ್ಹುನ್ ಖರ ಸಾಂಗ್ಲಸ್, ");
INSERT INTO gok_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","ಖರ‍್ಯಾನಿಸ್ ತುಲಾ ಪಾಚ್ ಜಾ಼ನ್ ದನ್ಗಾರ್ ಹುತ್ತ ಫನ್ ಆತಾ ತು ಕಚಾಪ ಜ಼ಲ್ಮ ಕರ್ತೆಸ್ ತ್ಯೊ ತುಜಾ಼ ದನ್ಗೊರ್ ನವ್ಹ ತು ಮನಾ ಖರ ಸಾಂಗ್ಲಸ್”. ");
INSERT INTO gok_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","ತವಾ ತೀ, “ಪ್ರಭು ತು ಮನಾ ಯೊಕ್ ಪ್ರವಾದಿಚಿಗತ್ ಆಸಾ ವಾಟ್ಯೊ. ");
INSERT INTO gok_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","ಆಮ್ಚಾ ವಡ್ಲಾಂಚಾನಿ ಹ್ಯಾ ಗುಢ್ಯಾವ ಆರಾಧನಾ ಕಿಲಿ, ಫನ್ ಲೊಕಾಂಚಾನಿ ಆರಧನಾ ಕರಾಚಾ಼ ಜಾ಼ಗಾ ಯೆರುಸಲೇಮ್ ಮನ್ಹುನ್ ಯೆಹುದಿ ಜಾ಼ಲ್ಯಾಲ ತುಮಿ ಸಾಂಗ್ತಾಸಾ, ಮನ್‌ಲ್ಹಿ ");
INSERT INTO gok_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","ಯೇಸುನಿ ತಿಲಾ ಸಾಂಗ್ಲ, “ಮಾಜಿವ ಇಸ್ವಾಸ್ ಥೆವ್ ತೀ ಆನಿ ಕಂದಿಸ್ ದೇವಾಲಾ ಯೆರುಸಲೇಮಿತ್ ವ್ಹವುನಿ ಹ್ಯಾ ಗುಢ್ಯಾವ ವ್ಹವುನಿ ಆರಾಧನ್ ಕರಾಯಾ ವ್ಹನಾರ್ ನಾಹಿ ಆಸಾ ಯೊಳ್ ಯನಾರ್. ");
INSERT INTO gok_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","ತುಮಿ ಸಮಾರ್ಯಾಚಿ ಲೊಕ ಕುನಾಲಾ ಆರಾಧನ್ ಕರ್ತಾಸ್ ತ್ಯೊ ತುಮಾನಾ ಠಾವಾ ನಾಹಿ ಫನ್ ಆಮಿ ಯೆಹುದಿ ಲೊಕ ಆರಾಧನ್ ಕರ್ತ್ಯಾಲಾ ಆಮಾನಾ ಠಾವ ಹಾ. ಕಾ ಮಂಜೆ ಸುಟ್ನುಕ್ ಯೆಹುದ್ಯಾಂಚಿಪ್ನಿ ಯನಾರ್. ");
INSERT INTO gok_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","ಖರ‍್ಯಾನಿ ಆರಾಧನ್ ಕರ್ತ್ಯಾಲ ಬಾಚಿ ಆರಧನಾ ಆತ್‌ಮ್ಯಾನಿ ಖರ‍್ಯಾನಿ ಕರ್ನಾರ್ ಆಸ್ಲಾ ಯೊಳ್ ಯಯಾಲಾಗ್‍ಲ್ಯಾ ನಾಹಿತ ಸಮ್ಜುನ್ ಗೆವ್ಹಾ ತ್ಯೊ ಯೊಳ್ ಆತಾಸ್ ಆಲ್ಯಾ ಆನಿ ಆರಧನ್ ಕರ್ತ್ಯಾಲ್ಯಾ ಆಸ್‍ಲ್ಯಾನಾಸ್ ದೇವ್ ಶೊತ್ಯೊ. ");
INSERT INTO gok_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","ದೇವ್ ಆತ್ಮ ಹಾ ದೇವಾಲಾ ಆರಾಧನ್ ಕರ್ತ್ಯಾಲ್ಯಾಂಚಾನಿ ಆತ್‌ಮ್ಯಾನಿ ಖರ‍್ಯಾನಿ ಆರಾಧನ್ ಕರಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","ತೀ ಬಾಯಿಲ್ ಮಾನುಸ್ ಯನಾರ್ ಮೆಸ್ಸಿಯಾ ಮನ್ಹುನ್ ಮನಾ ಠಾವ ಹಾ ತ್ಯೊ ಆಲಾಕಿ ಆಮಾನಾ ಸಗ್ಳ ಫುಡುನ್ ಸಾಂಗ್ನಾರ್ ಮನ್‌ಲ್ಹಿ. ");
INSERT INTO gok_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","ಯೇಸುನಿ ತಿಲಾ ಸಾಂಗ್ಲ, “ತುಜಿ ಸಂಗ ಬೊಲ್‌ತ್ಯಾಲಾ ಮಿಸ್ ತ್ಯೊ. ” ");
INSERT INTO gok_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","ತವಾಸ್ ತ್ಯಚ ಶಿಶಾ ಪರ್ತುನ್ ಮಾಗಾರ ಆಲ ಯೇಸು ಯಕ ಬಾಯಿಲ್ ಮಾನ್ಸಾ ಸಂಗ ಬೊಲ್‌ತ್ಯಾಲಾ ಬಗುನ್ ಖುಬ್ ಆಜಾಬ್ ವಾಟ್ಲ ಫನ್ ತಿಲಾ ತುಲಾ ಕ್ಯಾ ವ್ಹಯಿ? ನಾಹಿತ ತು ತಿಚಿ ಸಂಗ ಕಾ ಬೊಲ್‌ತ್ಯೊಸ್? ಮನ್ಹುನ್ ತ್ಯಾತ್‌ಲ್ಯಾ ಯಕಾನಿಬಿ ಇಚಾರ್ಲ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","ಮಂಗ್ ತೇ ಬಾಯಿಲ್ ಮಾನ್ಸಾನಿ ಆಪ್ಲಿ ಗಾಘರ್ ತಿಥಸ್ ಸುಡುನ್ ಪೆಠತ್ ಮಾಗಾರಿ ಜಾ಼ವುನ್ ಲೊಕಾನಾ ಸಾಂಗ್ಲ, ");
INSERT INTO gok_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","ಮಿ ಆಜು಼ನ್ ಪರ‍ತ್ ಕೆಲ್ಯಾಲ ಸಗ್ಳ ಯಕಾ ಮಾನ್ಸಾನಿ ಮನಾ ಸಾಂಗ್ಲ ಯವುನ್ ತ್ಯಲಾ ಬಗಾ ತ್ಯೊಸ್ ಕ್ರಿಸ್ತ ಆಸಲ್? ");
INSERT INTO gok_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","ಮನ್ಹುನ್ ಲೊಕ ಸಗ್ಳಿ ತ್ಯಲಾ ಬಗಾಯಾ ಪೆಠತ್ನಿ ಬಾಹಿರ್ ಆಲಿತ. ");
INSERT INTO gok_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","ತ್ಯವ್‍ಡ್ಯಾತ್ ಯೇಸುಚಾ ಶಿಶಾಂಚಾನಿ, “ಗುರು ಜೇವಾನ್ ಖಾ ಮನ್ಹುನ್ ತ್ಯಲಾ ಇನಂತಿ ಕಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","ಫನ್ ತ್ಯಲಾ ಯೇಸು, “ಮಾಜಿಪ ಖಾಯಾ ಜೇವಾನ್ ಹಾ ತ್ಯಚೆ ಯಸಿ ತುಮಾನಾ ಕಾಯ್ ಠಾವ ನಾಹಿ” ಮನ್‍ಲ್ಹಾ. ");
INSERT INTO gok_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","ಮನ್ಹುನ್ ಶಿಶಾ ಕುನಿ ತರಿ ತ್ಯಲಾ ಆಂದಿಸ್ ಜೇವಾನ್ ಆನುನ್ ದಿಲ ಕ್ಯಾ? ಮನ್ಹುನ್ ಆಪ್‌ಲ್ಯಾತ್ ಯಕಾಮಕಾಲಾ ಇಚಾರಾಯಾ ಲಾಗ್ಲ ");
INSERT INTO gok_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","ಯೇಸುನಿ ತ್ಯಲಾ ಸಾಂಗ್ಲ ಮಾಜ಼ ಜೇವಾನ್ ಕುನಿ ಮನಾ ಲಾವುನ್ ದಿಲ್ಯಾ ತ್ಯಚಿ ಇಚ್ಚಾ ಪುರ್ನ ಕರಾಚಿ ಜಾ಼ಲ್ಯಾ. ಆನಿ ಮಾಜಾ ತಾಬ್ಯಾತ್ ದಿಲ್ಯಾಲಿ ಕಾಮ್ ಪುರ್ನ ಕರಾಯಾ ವ್ಹಯಿತ. ");
INSERT INTO gok_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","ಲಾನಿಲಾ ಆಜು಼ನ್ ಚಾರ್ ಮೈನ ರಾಖಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ತುಮಿ ಮಂಥ್ಯಾಸಾ ಫನ್ ಮಿ ತುಮಾನಾ ಸಾಂಗ್ತೊ ತುಮ್ಚ ಡೊಳ ಉಗ್ಡುನ್ ಸೆತಾಂಚಿಕ್ಡ ಬಗಾ ತೀ ಕಾಪಾಯಾ ಆಲ್ಯಾತ ");
INSERT INTO gok_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","ಪೀಕ್ ಕ್ಯಾಪ್ನಾರ‍್ಯಾಲಾ ಆತಾ ಸಾಹಿತ್ ಕುಲ್ ಮಿಳಲ್ ಆನಿ ತ್ಯ ಪೀಕ್ ಶಾಶ್ವತ್ ಜೀವ್ನಾ ಸಾಟಿ ಗೊಳಾ ಕರ್ತ್ಯೊ ಮನ್ಹುನ್ ಪೇರ್ತ್ಯಾಲ ಆನಿ ಕ್ಯಾಪ್‌ತ್ಯಾಲ ಯಂಗ್ದಾಸ್ ಸಂತೊಶ್ ವ್ಹತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","ಯೊಕ್ ಪೇರ್ತೊ ಆನಿ ದಿಸ್ರಾ ಕ್ಯಾಪ್ತೊ ಮನ್ಹುನ್ ಆಮಿ ಮಂತ್ಯಾಲ ಮನ್ಹ ಖರ. ");
INSERT INTO gok_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","ತುಮಿ ರಾಬ್‌ಲ್ಯಾ ನಸ್‌ಲ್ಯಾಲ ಪೀಕ್ ಕಾಪಾಯಾ ಸಾಟಿ ಮಿ ತುಮಾನಾ ಲಾವುನ್ ದೇತೊ ದುಸ್ರಿ ರಾಬ್ಲಿತ ಫನ್ ತ್ಯಂಚಾ ರಾಬ್‌ನ್ಯಾನಿ ತುಮಿ ಫ್ಯಾಯ್ದಾ ಗೆಥಾಸಾ ಮನ್‍ಲ್ಹಾ. ");
INSERT INTO gok_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","ತೇ ಪೆಠತ್ಲಿ ಖುಬ್ ಸಮಾರ‍್ಯಾ ಲೊಕಾಂಚಾನಿ ಯೇಸುವ ಇಸ್ವಾಸ್ ಥೆವ್ಲಾ ಕಾ ಮಂಜೆ ತೇ ಬಾಯಿಲ್ ಮಾನ್ಸಾನಿ ತ್ಯಚಿ ವಳಕ್ ತ್ಯನಾ ಮಿ ಕೆಲ್ಯಾಲ ಪರತೇಕ್ ಸಗ್ಳ ಮನಾ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","ಸಮಾರ‍್ಯಾತ್‌ಲ್ಯಾಂಚಾನಿ ಯೇಸುಪ ಜಾ಼ವುನ್ ಆಪ್ಲಿ ಸಂಗ ರ‍್ಹಾ ಮನ್ಹುನ್ ತ್ಯಲಾ ಇನಂತಿ ಕಿಲಿ ತವಾ ತ್ಯೊ ದೊನ್ ದೀಸ್ ತಿಥ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","ತ್ಯನಿ ಸಾಂಗ್‌ಲ್ಯಾಲ್ಯಾ ಸಬ್ದ ಐಕುನ್ ಖುಬ್ ಲೊಕಾಂಚಾನಿ ಇಸ್ವಾಸ್ ಥೆವ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","ತ್ಯಂಚಾನಿ ತ್ಯಾ ಬಾಯಿಲ್ ಮಾನ್ಸಾಲಾ ಆಮಿ ಆಂದಿ ತುಜ ಸಾಂಗ್ನ ಐಕುನ್ ಯೇಸುವ ಇಸ್ವಾಸ್ ಥೆವ್‍ಲ್ಥಾ. ಫನ್ ಆತಾ ಆಮಿಸ್ ತ್ಯಚ ಸಬ್ದ ಐಕ್ಲ ಮನ್ಹುನ್ ಇಸ್ವಾಸ್ ಥೆವ್‌ಲ್ಯಾ ಖರ‍್ಯಾನಿ ಹ್ಯೊಸ್ ದುನಿಯಾಲಾ ಸುಡಿವ್ನಾರಾ ಮನ್ಹುನ್ ಆತಾ ಆಮಾನಾ ಸಮಾಜ್‌ಲ್ಯಾ ಮನ್‌ಲ್ಹಿತ. ");
INSERT INTO gok_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","ಯೇಸು ದೊನ್ ದೀಸ್ ತಿಥ ರಾಯಲ್ಯಾ ನಂತರ್ ಗಲಿಲಾಯಾತ್ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","ಪ್ರವಾದಿಲಾ ಸ್ವತಾಚಾ ಗಾವಾತ್ ಮರ‍್ಯಾದ್ ನಾಹಿ ಮನ್ಹುನ್ ಯೇಸುನಿ ಸಾಂಗ್ಲ ");
INSERT INTO gok_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","ತ್ಯೊ ಗಲಿಲಾಯಾತ್ ಪೊಚ್ಲಾ ತವಾ ತಿತಲ್ಯಾ ಲೊಕಾಂಚಾನಿ ತ್ಯಲಾ ಸ್ವಾಗತ್ ಕೆಲಾ. ಕಾ ಮಂಜೆ ತ್ಯಂಚಾನಿ ಬಗ್‌ಲ್ಯಾಲ ಸಗ್ಳ ತ್ಯನಿ ಯೆರುಸಲೇಮಿತ್ ಸನಾಚಾ ದಿಸಾತ್ ಕೆಲ್ತ ಕಾ ಮಂಜೆ ತೀ ಸಗ್ಳಿ ಹ್ಯಾ ಯಳಾತ್ ಸನಾಲಾ ಗಿಲಿತ. ");
INSERT INTO gok_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","ಯೇಸುನಿ ಗಲಿಲಾಯಾಚಾ ಕಾನಾ ಗಾವಾತ್ ಆನಿ ಯಂಗ್ದಾ ಭೇಟ್ ದಿಲಿ ತಿಥಸ್ ತ್ಯನಿ ಪಾನ್ಯಾನಿ ದರಾಕ್ಶಿಚಾ಼ ರಸ್ ಕೆಲ್ಯಾಲಾ. ತ್ಯಾಸ್ ಗಾವಾತ್ ಯೊಕ್ ಸರ್ಕಾರಿ ಅಧಿಕಾರಿ ಹುತ್ತಾ ತ್ಯಚಾ಼ ಲ್ಯೊಕ್ ಕಪೆರ್ನೌಮ್ ಪೆಠತ್ ಸೀಕ್ ಪಡುನ್ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","ಯೇಸು ಯುದಾಯಾತ್ನಿ ಯವುನ್ ಆತಾ ಗಲಿಲಾಯಾತ್ ಹಾ ಮನ್ಹಾಚಿ ಬಾತ್ನಿ ತ್ಯನಿ ಐಕ್ಲಿ ಆನಿ ತ್ಯೊ ತ್ಯಚಿಪ ಜಾ಼ವುನ್ ಮರಾಯಾ ಠಕ್‌ಲ್ಯಾಲ್ಯಾ ಆಪ್‌ಲ್ಯಾ ಲೆಕಾಲಾ ಬರಾ ಕರಾಯಾ ಕಪೇರ್ನೌಮಿತ್ ಯೇ ಮನ್ಹುನ್ ಇನಂತಿ ಕೆಲಿ. ");
INSERT INTO gok_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","ಯೇಸುನಿ ತ್ಯಲಾ ತುಮಿ ಮುಟಿ ಮುಟಿ ಅದ್ಬುತಾಚಿ ಆನಿ ಚಮತ್ಕಾರಾಚಿ ಕಾಮ ಬಗ್‌ಲ್ಯಾ ಸಿವಾರ್ ಮಾಜಿವ ಇಸ್ವಾಸ್ ಥಿವಿತುಸ್ ನಾಹಿಸಾ ಮನ್‍ಲ್ಹಾ. ");
INSERT INTO gok_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","ಸರಕಾರಿ ಅಧಿಕಾರಿ ಪ್ರಭು ಮಾಜಾ಼ ಲ್ಯೊಕ್ ಮರಾಚೆ ಆಂದಿಸ್ ತು ಮಾಜಿ ಸಂಗ ಚ಼ಲ್. ");
INSERT INTO gok_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","ಯೇಸು ತ್ಯಲಾ ಜಾ಼ ತುಜಾ಼ ಲ್ಯೊಕ್ ಜಿತ್ತಾ ರಾನ್ಹಾರ್. ಯೇಸುಚಾ ಸಬ್ದಾವ ಇಸ್ವಾಸ್ ಥಿವುನ್ ಮಾಗಾರಾ ಗರ‍್ಹಾತ್ ಜಾ಼ಯಾ ಗೇಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","ತ್ಯೊ ಗರ‍್ಹಾತ್ ಜಾತಾನಾ ತ್ಯಚ ಆಳ್ ತ್ಯಚಿಪ ಯವುನ್ ತುಜಾ಼ ಲ್ಯೊಕ್ ಜಿತ್ತಾ ಜಾ಼ಲ್ಯಾ ಮನ್‌ಲ್ಹ. ");
INSERT INTO gok_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","ತ್ಯನಿ ಮಾಜಾ ಲೇಕಾಲಾ ಕಿತಿ ವಾಸ್ತಾ ಬರ ಜಾ಼ಲ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ತವಾ ಸೇವಕಾಂಚಾನಿ ಕ್ಯಾಲ್ ದೊಪಾರಾ ಯೇಕ್ ವಾಸ್ತಾ ತ್ಯಚ಼ ತಾಪ್ ಗೇಲಾ ಮನ್‌ಲ್ಹ. ");
INSERT INTO gok_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","ತುಜಾ಼ ಲ್ಯೊಕ್ ಜಿತ್ತಾ ವ್ಹನಾರ್ ಮನ್ಹುನ್ ಯೇಸುನಿ ಸಾಂಗ್‌ಲ್ಯಾಲ ಹ್ಯಾಸ್ ಯಳಾಲಾ ಬಾನಿ ಸಮ್ಜುನ್ ಗೆತ್ಲ ತ್ಯನಿ ಆನಿ ತ್ಯಚಾ ಗರ‍್ಹಾತಲ್ಯಾ ಸಗ್‌ಳ್ಯಾಂಚಾನಿ ಯೇಸುವ ಇಸ್ವಾಸ್ ಥೆವ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","ಯೇಸು ಯುದಾಯಾತ್ನಿ ಗಲಿಲಾಯಾತ್ ಆಲ್ಯಾವ ಕೆಲ್ಯಾಲ ದೊನ್ವ ಮೊಟ ಚಮತ್ಕಾರಾಚ಼ ಕಾಮ್ ಹ್ಯ. ");
INSERT INTO gok_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","ತ್ಯಾ ನಂತರ ಯೇಸು ಯೆಹುದ್ಯಾಂಚಾ಼ ಯಕಾ ಸನಾಲಾ ಯೆರುಸಲೇಮಿತ್ ಗೇಲಾ ");
INSERT INTO gok_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","ಯೆರುಸಲೇಮಿತ್ ಪಾಚ್ ಮಾಂಡ್ವಾಚಾನಿ ಮಿಳಾಲ್ಯಾಲ ಯಾಕ್ ತಳ ಹಾ ಇಬ್ರಿಯಾ ಬಾಶೆತ್ ತ್ಯಲಾ ಬೆತ್ಸಥ ಮಂಥ್ಯಾತ ಹ್ಯ ತಳ ಮೆಡ್ರಾಂಚ಼ ದಾರ್ ಮಂಥ್ಯಾಲ್ಯಾ ಜಾ಼ಗ್ಯಾಪ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","ತಳ್ಯಾಪ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ಮಾಂಡ್ವಾತ್ನಿ ಖುಬ್ ರೊಗಿ ಪಡುನ್ ಹುತ್ತ. ತ್ಯಂಚಾತ್ಲ ಥೊಡ ಆಂದ್ಳ ಹುತ್ತ. ಥೊಡ ಲಂಗ್ಡ ಹುತ್ತ ಆನಿ ಥೊಡ ಲಕ್ವಾ ಮ್ಯಾರ್‌ಲ್ಯಾಲ ರೊಗಿ ಹುತ್ತ. ತೇ ಪಾನಿ ಹಲ್‌ತ್ಯಾಲ ರಾಖಿತ್ ರಾಹಿತ, ");
INSERT INTO gok_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","ಕಾ ಮಂಜೆ ಪರತೇಕ್ ಖೆಪಾ ಥೊಡ್ಯಾ ಯಳಾ ನಂತರ್ ಪ್ರಭುಚಾ ಧುತ್ ಖಾಲ್ ಯವುನ್ ತಳಿತ್ಲ ಪಾನಿ ಹಲ್ವಿತಾ. ದುಖನ್ಕರ‍್ಯಾತ್ಲಾ ಕಚಾ಼ಬಿ ಯೊಕ್ ಮಾನುಸ್ ಪಾನಿ ಹಾಲ್ತಾನಾ ಆಂದಿ ಜಾ಼ತೊ ತ್ಯೊ ದುಖ್‌ನ್ಯಾತ್ನಿ ಬರಾ ವ್ಹತ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","ತಿಸಾವ ಆಟ್ ವರ್ಸಾ ದರ‍್ನಿ ರೊಗಾತ್ ಆಸ್‌ಲ್ಯಾಲಾ ಯೊಕ್ ತಿಥ ಪಡುನ್ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","ತ್ಯೊ ಖುಬ್ ವರ್ಸಾ ದರ‍್ನಿ ರೊಗಿ ವ್ಹವುನ್ ತಿಥ ರಾಯ್‌ಲ್ಯಾಲಾ ಯೇಸುಲಾ ಠಾವಾ ಹುತ್ತಾ. ಆನಿ ತ್ಯನಿ ತ್ಯಲಾ ಬಗುನ್ ತುಲಾ ಬರಾ ವ್ಹಯಾ ಮನ್ ಹಾ ಕ್ಯಾ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","ತ್ಯೊ ದುಖನ್ಕರಿ, “ಪಾನಿ ಉತು ಯತಾನಾ ತಳ್ಯಾತ್ ಉತ್ರಾಯಾ ಮನಾ ಕೊನ್ ಮಜ಼ತ್ ಕರೀತ್ ನಾಹಿತ. ಮಿ ಸಗ್‌ಳ್ಯಾಂಚೆ ಆಂದಿ ಮಿ ಪಾನ್ಯಾತ್ ಉತ್ರಾಯಾ ಯತ್ನ ಕರ್ತೊ. ಫನ್ ಪರತೇಕ್ ಖೆಪಾ ಮಾಜೆ ಆಂದಿ ದುಸ್ರಾ ಉತಾರ್ತೊ” ಮನ್ಹುನ್ ಸಾಂಗ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","ತವಾ ಯೇಸು, “ಉಟ್! ತುಜ಼ ಹಾತ್ರುನ್ ಗಿಹುನ್ ಚ಼ಲ್” ಮನ್ಹುನ್ ಸಾಂಗ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","ತವಾಸ್ ತ್ಯೊ ಮಾನುಸ್ ಬರಾ ವ್ಹವುನ್, ಆಪ್ಲ ಹಾತ್ರುನ್ ಗಿಹುನ್ ಗೇಲಾ ಹ್ಯ ಸಗ್ಳ ಜಾ಼ಲ್ಯಾಲ ಸಬ್ಬತ್ ದಿಸಾ ದಿಸಿ. ");
INSERT INTO gok_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","ಮನ್ಹುನ್ ಬರಾ ಜಾ಼ಲ್ಯಾಲ್ಯಾ ತ್ಯಾ ಮಾನ್ಸಾಲಾ ಯೆಹುದಿ ಅಧಿಕಾರಿ, “ಆಜ಼್ ಸಬ್ಬತ್ ದೀಸ್. ತು ಸಬ್ಬತ್ ದಿಸಾದಿಸಿ ಹಾತ್ರುನ್ ಗಿಹುನ್ ಜಾ಼ಯಾಚ಼ ಆಮ್ಚ ಧರ್ಮಶಾಸ್ತಾರ್ ವಲ್ಯಾಂಡ್‌ಲ್ಯಾಚೆಗತ್” ಮನ್‍ಲ್ಹ. ");
INSERT INTO gok_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","ತ್ಯನಾ ತ್ಯನಿ, “ಮನಾ ಬರಾ ಕೆಲ್ಯಾಲ್ಯಾನಿ ತುಜ಼ ಹಾತ್ರುನ್ ಉಚ಼ಲುನ್ ಗಿಹುನ್ ಜಾ಼ ಮನ್ಹುನ್ ಸಾಂಗ್‌ಲ್ಯಾ” ಮಂಥೊ. ");
INSERT INTO gok_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","ತವಾ ತ್ಯಂಚಾನಿ, “ತುಜ಼ ಹಾತ್ರುನ್ ಉಚ಼ಲುನ್ ಗಿಹುನ್ ಜಾ಼ಯಾ ತುಲಾ ಸಾಂಗ್‌ಲ್ಯಾಲಾ ಕೊನ್? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","ಫನ್ ಬರಜಾ಼ಲ್ಯಾಲ್ಯಾ ಮಾನ್ಸಾಲಾ ಆಪ್‌ಲ್ಯಾಲಾ ಬರ ಕೆಲ್ಯಾಲಾ ಯೇಸು ಕೊನ್ ಮನ್ಹುನ್ ಠಾವಾ ನವ್ಥಾ ತ್ಯಾ ಜಾ಼ಗ್ಯಾವ ಖುಬ್ ಜ಼ನ ಹುತ್ತಿತ ಮನ್ಹುನ್ ಯೇಸು ತ್ಯಲಾ ಚು಼ಕ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","ತ್ಯಾ ನಂತರ್ ಯೇಸುನಿ ತ್ಯಾ ಮಾನ್ಸಾಲಾ ದೇವ್ಳಾತ್ ಬಗುನ್ ತ್ಯಲಾ ಐಕ್ ಆತಾ ತು ಬರಾ ಜಾ಼ಲ್ಯಾಸ್ ಹಿತ್ನಿ ಮೊರ‍್ಹ ಪಾಪ್ ಕರಾಚ಼ ಶೊಡ್ ಹ್ಯನಿ ತುಲಾ ಕಾಯ್ ನಾಸ್ ವ್ಹವು ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","ತವಾ ತ್ಯಾ ಮಾನ್ಸಾನಿ ಯೆಹುದ್ಯಾಂಚಿಪ ಜಾ಼ವುನ್, “ಮನಾ ಬರ ಕೆಲ್ಯಾಲ ಯೇಸುನಿಸ್” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ ");
INSERT INTO gok_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","ಯೇಸುನಿ ಹಿ ಕಾಮ ಸಬ್ಬತ್ ದಿಸಾದಿಸಿ ಕಿಲಿತ ಮನ್ಹುನ್ ಯೆಹುದಿ ತ್ಯಲಾ ತರಾಸ್ ದಿಯಾಲಾಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","ಫನ್ ಯೇಸುನಿ ತ್ಯನಾ ಸಾಂಗ್ಲ, “ಮಾಜಾ಼ ಬಾ ಕವಾಬಿ ಕಾಮ್ ಕರೀತ್ ರಾಥೊ ಮನ್ಹುನ್ ಮಿಬಿ ಮಾಜಿ ಕಾಮ ಕರಾಯಾ ವ್ಹಯಿತ. ” ");
INSERT INTO gok_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","ಹ್ಯಾ ಸಾಂಗನ್ಯಾನಿ ಯೆಹುದಿ ಅದಿಕಾರ್ಯಾಂಚಾನಿ ಯೇಸುಲಾ ಮಾರುನ್ ಟಾಕಾಯಾ ಘಟ್ ತಿರ್ಮಾನ್ ಕೆಲಾ, ಸಬ್ಬತ್ ವಲ್ಯಾಂಡಾಚಾ಼ ತ್ಯವ್ಡಸ್ ನವ್ಹ ದೇವಾಲಾ ಆಪ್ಲಾ ಬಾ ಮಂತ್ಯೊ ಆನಿ ಆಪ್‌ಲ್ಯಾಲಾ ದೇವಾ ಶಾರ್ಕಾ ಕರ್ತ್ಯೊ. ");
INSERT INTO gok_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","ತ್ಯಲಾ ಯೇಸು ಆಸಾ ಮನ್‍ಲ್ಹಾ ಮಿ ತುಮಾನಾ ಖರತ್ಯ ಸಾಂಗ್ತೊ ಲ್ಯೊಕ್ ಆಪ್ಲೆ ಆಪ್ನು ಕಾಯೇಕ್ ಕರೀತ್ನಾಹಿ ಬಾನಿ ಕೆಲ್ಯಾಲಿ ಕಾಮ ಬಗುನ್ ಲ್ಯೊಕ್ ತಸಿಸ್. ");
INSERT INTO gok_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","ಬಾ ಲೇಕಾಚಿ ಮಾಯಾ ಕರ್ತೊ ಆನಿ ಆಪ್ನು ಕರ್ತ್ಯಾಲಿ ಸಗ್ಳಿ ಕಾಮ ಲೇಕಾಲಾ ದ್ಯಾವ್ತೊ. ಆನಿ ಹ್ಯಚಿವ್ನಿ ಖುಬ್ ಕಾಮ ಬಗುನ್ ತುಮಿ ಸಗ್ಳಿ ಗಾಭಾರ್ಸಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","ಬಾ ಮೆಲ್ಯಾಲ್ಯಾತ್ನಿ ಉಠ್ವುನ್ ತ್ಯನಾ ಜೀವ್ ದೇತೊ. ತೇಸ್ ತರನಿ ಲ್ಯೊಕ್ ಆಪ್ನು ಆಪ್‌ಲ್ಯಾಲಾ ವ್ಹಯಿ ಜಾ಼ಲ್ಯಾಲ್ಯಾನಾ ಜೀವ್ ದೇತೊ. ");
INSERT INTO gok_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","ಯವ್ಡಸ್ ನವ್ಹ ಬಾ ಕುನಾಚಾ಼ ನ್ಯಾಯಿ ತಿರ್ಮಾನ್ ಕರೀತ್ನಾಹಿ ಫನ್ ಬಾನಿ ನ್ಯಾಯಿ ತಿರ್ಮಾನ್ ಕರಾಚಾ಼ ಸಗ್ಳಾ ಹುಕುಮ್ ಲೇಕಾಲಾ ದಿಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ಮನ್ಹುನ್ ಸಗ್‌ಳ್ಯಾಂಚಾನಿ ಬಾಲಾ ಮರ‍್ಯಾದ್ ದೆತ್ಯಾಶಾರ್ಕಿ ಲೇಕಾಲಾಬಿ ಮರ‍್ಯಾದ್ ದಿಯಾವ್ಹಯಿ ಮನ್ಹುನ್ ದೇವಾನಿ ಆಸ ಕೆಲ. ಲೇಕಾಲಾ ಮರ‍್ಯಾದ್ ದಿಯಿತ್ ನಸ್ನಾರಾ ತ್ಯಲಾ ಲಾವುನ್ ದಿಲ್ಯಾಲ್ಯಾ ಬಾಲಾಬಿ ಮರ‍್ಯಾದ್ ದಿಯಿನಸ್ನಾರಾ ಜಾ಼ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","ಮಿ ತುಮಾನಾ ಖರತ್ಯ ಸಾಂಗ್ತೊ ಮಾಜಿ ಬುಲಿ ಐಕುನ್ ಮನಾ ಲಾವುನ್ ದಿಲ್ಯಾಲ್ಯಾವ ಇಸ್ವಾಸ್ ಥೆವ್‌ತ್ಯಾಲಾ ಶಾಶ್ವತ್ ಜೀವ್ ಗೇನಾರ್ ತ್ಯಚಾ಼ ನ್ಯಾಯಿ ತಿರ್ಮಾನ್ ವ್ಹಯಿತ್ ನಾಹಿ. ತ್ಯೊ ಆತಾಸ್ ಮರ್ನಾತ್ನಿ ಪಾರ್ ವ್ಹವುನ್ ಜೀವ್ ಗೇತಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","ಮಿ ತುಮಾನಾ ಖರತ್ಯ ಸಾಂಗ್ತೊ ಮೆಲ್ಯಾಲಿ ದೇವಾಚಾ ಲೇಕಾಚಿ ಬುಲಿ ಐಕಾ ದೀಸ್ ಯನಾರ್ ತೇ ಆತಾಸ್ ಆಲ್ಯಾತ ಐಕ್‍ತ್ಯಾಲಿ ಜೀವ್ ಗೆತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","ಬಾನಿ ಜೀವ್ ದೇತ್ಯಾಲ ಬಳ್ ಆಪ್ನು ಗೆತಲ್ಯಾ ಶಾರ್ಕ ಲೇಕಾಲಾಬಿ ಜೀವ್‌ ದೆತ್ಯಾಲ ಬಳ್ ದಿಲ್ಯಾ ");
INSERT INTO gok_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","ಆನಿ ನ್ಯಾಯಿ ತಿರ್ಮಾನ್ ಕರಾಸಾಚಾ಼ ಹುಕುಮ್ ಬಾನಿ ಲೇಕಾಲಾ ದಿಲ್ಯಾ ಕಾಮಂಜೆ ತ್ಯೊ ಮಾನ್ಸಾಚಾ಼ ಲ್ಯೊಕ್ ಜಾ಼ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","ಮನ್ಹುನ್ ಹ್ಯಚೆ ಗುಶ್ಟಿತ್ ಗಾಬ್ರುನಕೊಸಾ ಕಾಮಂಜೆ ಮಸುರ್ಡಿತ್ಲಿ ಸಗ್ಳಿ ತ್ಯಚಿ ಬುಲಿ ಐಕಾಚ಼ ದೀಸ್ ಯನಾರ್. ");
INSERT INTO gok_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ಆನಿ ತೇ ಆಪ್ಲೆ ಮಸುರ್ಡಿತ್ನಿ ಉಠುನ್ ಯನಾರ್: ಕುನಿ ಚಾ಼ಂಗ್ಲ ಕಾಮ ಕೆಲ್ಯಾ ತ್ಯೊ ಮರ್ನಾತ್ನಿ ಉಠುನ್ ಶಾಶ್ವತ್ ಜೀವ್ ಗೆನ್ಹಾರ್, ಆನಿ ಕುನಿ ಬುರ್ಸ ಕೆಲ್ಯಾ ತ್ಯೊ ಪುನರುಥಾನ್ ಫನ್ ತ್ಯನಾ ಶಿಕ್ಶಾ ವ್ಹತಿ. ");
INSERT INTO gok_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","ಮಾಜಾನಿಸ್ ಮನಾ ಕಾಯೇಕ್ ಕರಾಯಾ ವ್ಹಯಿತ್ನಾಹಿ. ಫನ್ ನಿಸ್ಥ ಬಾನಿ ಸಾಂಗ್‌ಲ್ಯಾಲ ಐಕುನ್ ತ್ಯಚಿಗತ್ ಮಿ ನ್ಯಾಯಿ ಕರ್ತೊ ಮನ್ಹುನ್ ಮಾಜಾ಼ ನ್ಯಾಯಿ ಶಾರ್ಕಾ ಹಾ. ಕಾಮಂಜೆ ಮಿ ಮಾಜಾ ಮನಾ ಶಾರ್ಕ ಕರೀತ್ ನಾಹಿ ಮನಾ ಲಾವುನ್ ದಿಲ್ಯಾಲ್ಯಾ ಮಾಜಾ ಬಾಚಾ ಮನಾ ಶಾರ್ಕ ಕರ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","ಮಾಜೆ ಗುಶ್ಟಿತ್ ಮಾಜಿ ಮಿಸ್ ಸಾಕ್ಶಿ ಸಾಂಗ್ಲಿತ ಮಾಜೆ ಸಾಕ್ಶಿಲಾ ಕಾಯ್ ಕಿಮ್ಮತ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","ಫನ್ ಮಾಜಾ ಗುಶ್ಟಿಸ್ ಸಾಕ್ಶಿ ಸಾಂಗ್‌ತ್ಯಾಲಾ ಯೊಕ್ ಮಾನುಸ್ ಹಾ. ತ್ಯೊ ಸಾಂಗ್‌ತ್ಯಾಲಾ ಸಾಕ್ಶಿ ಖರಿ ಹಾ ಮನ್ಹುನ್ ಠಾವ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","ತುಮಿ ಯೊಹಾನಾಪ ಸಾಕ್ಶಿ ಸಾಂಗ್ನಾರ‍್ಯಾನಾ ಲಾವುನ್ ದಿಲ್ಯಾಸಾ, ತ್ಯಂಚಾನಿ ತುಮಾನಾ ಖರ ಸಾಂಗ್ಲ ");
INSERT INTO gok_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","ಫನ್ ಮಾಜೆ ಗುಶ್ಟಿತ್ ಲೊಕಾನಾ ಸಾಂಗಾಯಾ ಕಚಾ ಮಾನ್ಸಾಚಿ ಸಾಕ್ಶಿ ವ್ಹಯಿ ಮನ್ಹುನ್ ನಾಹಿ ಫನ್ ತುಮಾನಾ ರಕ್ಶನ್ ವ್ಹಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಮಿ ಹ್ಯಾ ಗುಶ್ಟಿ ತುಮಾನಾ ಸಾಂಗ್‌ತ್ಯೊ. ");
INSERT INTO gok_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","ಯೊಹಾನ್ ಪೆಟ್ಯಾಲ್ಯಾ ಆನಿ ಉಜಿಡ್ ದೇತ್ಯಾಲ್ಯಾ ದಿವ್ಯಾಚೆಗತ್ ಹುತ್ತಾ, ಫನ್ ಥೊಡಾ ಯೊಳ್ ತುಮಿ ತ್ಯೊ ಉಜಿಡ್ ಗಿಹ್ಯಾ ಬಗ್ಲಾಸಾ. ");
INSERT INTO gok_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","ಫನ್ ಮಾಜಿ ಸಾಕ್ಶಿ ಯೊಹಾನಾಚೆ ಸಾಕ್ಶಿವ್ನಿ ಮುಟಿ ಜಾ಼ಲೆ: ಕಾ ಮಂಜೆ ಬಾನಿ ಕಚ಼ ಕಾಮ್ ಪುರ್ನ ಕರಾಯಾ ಮನಾ ಒಪಸಲ್ಯಾ ಮಿ ತೀಸ್ ಕಾಮ ಕರ್ತ್ಯೊ. ಆನಿ ಬಾನಿ ಮನಾ ಲಾವುನ್ ದಿಲ್ಯಾ ಮನ್ಹುನ್ ಹಿ ಕಾಮಸ್ ಮಾಜಿ ಸಾಕ್ಶಿ ಜಾ಼ಲ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","ಮನಾ ಲಾವುನ್ ದಿಲ್ಯಾಲಾ ಬಾಸ್ ಮಾಜಿ ಸಾಕ್ಶಿ ಜಾ಼ಲ್ಯಾ. ಫನ್ ತುಮಿ ತ್ಯಸಾಚಾ಼ ಆವಾಜ್ ಕಂದಿಸ್ ಐಕ್ಲ ನಾಹಿಸಾ. ತ್ಯಚ಼ ರುಪ್ ಕಂದಿ ಬಗ್ಲ ನಾಹಿಸಾ. ");
INSERT INTO gok_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ಆನಿ ಬಾನಿ ಸಾಂಗ್‌ಲ್ಯಾಲಾ ಸಾಂಗ್ ತುಮ್ಚಿಪ ನಾಹಿ ಕಾಮಂಜೆ ಬಾನಿ ಲಾವುನ್ ದಿಲ್ಯಾಲ್ಯಾವ ತುಮಿ ಇಸ್ವಾಸ್ ಥಿವಿತ್ ನಾಹಿಸಾ. ");
INSERT INTO gok_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","ತುಮಿ ಶಾಸ್ತಾರ ವಾಚಿವ್ತಾಸಾ ಹ್ಯನಿ ಶಾಶ್ವತ್ ಜೀವ್ ಗಾವ್ತೊ ಮನ್ಹುನ್ ಯವಸ್ಥಾಸಾ ಫನ್ ಹಿ ಸಗ್ಳಿ ಶಾಸ್ತಾರ ಮಾಜಿ ಸಾಕ್ಶಿ ದೆತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","ಆಜುನ್ಬಿ ತುಮಿ ಶಾಶ್ವತ್ ಜೀವ್ ಗಿಹ್ಯಾ ಮಾಜಿಪ ಯಯಾ ಮನ್ ಕರೀತ್ ನಾಹಿಸಾ. ");
INSERT INTO gok_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","ಮನಾ ಮಾನ್ಸಾಂಚಾನಿ ವವ್ಯಾಳಾಚ಼ ನಕೊ. ");
INSERT INTO gok_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","ಫನ್ ತುಮಿ ಕಸ್ಲಿ ಮಾನ್ಸ ಹಾಸಾತಿ ಮನಾ ಠಾವಿ ಹಾಸಾ ತುಮಾನಾ ದೇವಾವ ಮಾಯಾ ನಾಹಿ ಮನ್ಹುನ್ ಮನಾ ಸಮಾಜಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","ಮಿ ಮಾಜಾ ಬಾಚಾ ಹುಕ್ಮಾನಿ ಆಲ್ಯೊ, ತರಿಬಿ ತುಮಿ ಮನಾ ಗಿಹಿತ್ ನಾಹಿಸಾ. ಫನ್ ಕಚಾ಼ ತರಿ ಯೊಕ್ ಆಪ್‌ಲ್ಯಾ ಸ್ವತಾಚಾ ಹುಕ್ಮಾನಿ ಯವುನ್ ಆಪ್ಲಿ ಸಾಟಿ ಬೊಲ್ಲಾತ ತುಮಿ ತ್ಯಲಾ ಗೆಥಾಸಾ. ");
INSERT INTO gok_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","ತುಮಿ ದುಸ್‌ರ‍್ಯಾಪ್ನಿ ಮರ‍್ಯಾದ್ ವ್ಹಯಿ ಮಂಥಾಸಾ ಫನ್ ಯಕಾ ದೇವಾಪ್ನಿ ಯತ್ಯಾಲಿ ಮರ‍್ಯಾದ್ ಗಿಹ್ಯಾ ತುಮಿ ಕಂದಿಸ್ ಮನ್ ಕರೀತ್ ನಾಹಿಸಾ ಆನಿ ತುಮಿ ಮಾಜಿವ ಕಸಾ ಇಸ್ವಾಸ್ ಥಿವ್ಸಿಲಾ? ");
INSERT INTO gok_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","ಮಿ ದೇವಾಚೆ ಮೊರ‍್ಹ ತುಮಿ ಚು಼ಕಿಚಿ ಆಸ ಸಾಂಗ್ನಾರಾ ಮನ್ಹುನ್ ಯವಜು಼ನಕೊಸಾ. ತುಮಿ ಚು಼ಕ್‌ ಕರ್ತ್ಯಾಲಿ ಮನ್ಹುನ್ ತುಮಿ ಇಸ್ವಾಸ್ ಥೆವ್‌ಲ್ಯಾಲಾ ಮೊಶೆಚಾ಼ ನೇಮ್ ದಾವುನ್ ದೇನಾರ. ");
INSERT INTO gok_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","ತುಮಿ ಖರ‍್ಯಾನಿಸ್ ಮೊಶೆವ ಇಸ್ವಾಸ್ ಥೆವ್‌ಲ್ಯಾವ ತುಮಿ ಮಾಜಿವಬಿ ಇಸ್ವಾಸ್ ಥಿವಿತಾಸಾ ಕಾಮಂಜೆ ತ್ಯನಿ ಮಾಜೆ ಗುಶ್ಟಿತ್ ಲಿವ್‌ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","ಫನ್ ಆಜು಼ನ್ಬಿ ಮೊಶೆನಿ ಲಿವ್‌ಲ್ಯಾಲ್ಯಾವ ತುಮಿ ಇಸ್ವಾಸ್ ಥೆವ್ಲಾ ನಾಹಿಸಾತ, ಮಿ ಸಾಂಗ್‌ಲ್ಯಾಲ್ಯಾವ ತುಮಿ ಕಸಾ ಇಸ್ವಾಸ್ ಥಿವ್ಸಿಲಾ? ");
INSERT INTO gok_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","ನಂತರ್ ಯೇಸು ಗಲಿಲಾಯ್ ಸಮೀಂದೊರ್ ವಲ್ಯಾಂಡುನ್ ಪಲಿಕ್ಡ ಗೇಲಾ. ತ್ಯಲಾಸ್ ತಿಬೇರಿಯಾ ಸಮಿಂದೊರ್ ಮಂಥ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","ಖುಬ್ ಲೊಕ ತ್ಯಚೆ ಮಾಗ್ನಿ ಗಿಲಿತ ಕಾಮಂಜೆ ತ್ಯಂಚಾನಿ ಯೇಸುನಿಸ ರೊಗಿನಾ ಬರ ಕೆಲ್ಯಾಲ ಚಮತ್ಕಾರ್ ಬಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","ತವಾ ಯೇಸು ಕನ್ಯಾವ ಚ಼ಡುನ್ ಆಪ್‌ಲ್ಯಾ ಶಿಶಾಂಚೆ ಸಂಗ ಬಸ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","ಯೆಹುದ್ಯಾಂಚಾ಼ ವಲ್ಯಾಂಡಾಚಾ಼ ಸನ್ ಖುಬ್ ಜ಼ವಳ್ ಆಲ್ಥಾ. ");
INSERT INTO gok_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","ಯೇಸುಲಾ ಆಪ್ಲಿಪ ಯತ್ಯಾಲಾ ಲೊಕಾಂಚಾ಼ ಹಿಂಡ್ ದಿಸ್ಲಾ ತವಾ ಫಿಲಿಪ್ಪಾಲಾ, “ಹ್ಯಾ ಸಗ್‌ಳ್ಯಾ ಲೊಕಾನಾ ಪುರಜೊ಼ಗ ಜೇವಾನ್ ಆಮಿ ಕುಟ್ನಿ ಆನುಯಾ? ಮನ್ಹುನ್ ಇಚಾರ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","ಪಿಲಿಪಾಚಿ ಪಾರಕ್ ಕರಾಯಾ ಯೇಸುನಿ ಆಸ ಇಚಾರ್ಲ. ಫನ್ ಖರ‍್ಯಾನಿಸ್ ಆಪ್ನು ಕರಾಯಾ ವ್ಹಯಿ ಜಾ಼ಲ್ಯಾಲ ಕಾಮ್ ಆಂದಿಸ್ ತ್ಯಚಾ ಮನಾತ್ ಹುತ್ತ. ");
INSERT INTO gok_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","ಫಿಲಿಪ್ಪ ಮನ್ಲಾ, “ಹಿತ್ತ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ಪರತೇಕಾಲಾ ಥುಡಿ ಥುಡಿ ಬಾಕ್ರಿ ದಿಯಾ ವ್ಹಯಿತ, ದೊನ್ಸೆವ್ನಿ ಆಗಾವ್ ಚಾ಼ಂದಿಚ಼ ಆನ ವ್ಹಯಿತ. ” ");
INSERT INTO gok_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","ಯೇಸುಚಾ಼ ಆನಿ ಯೊಕ್ ಶಿಶಾ ಜಾ಼ಲ್ಯಾಲ್ಯಾ ಆಂದ್ರೆಯಾ ಸಿಮೊನಾನಿ ಪೇತ್ರಾಚಾ಼ ಬಾಹುಜಾ಼ಲ್ಯಾಲಾ, ");
INSERT INTO gok_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","ಅಂದ್ರೆಯ್ ಹಿತ್ತ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ಯಕಾ ಪ್ಯೊರ್ಗ್ಯಾಪ ಗವ್ಹಾಚಾ ಪಾಚ಼್ ಬಾಕ್‌ರ‍್ಯಾ ಹಾತ್ತಾ ಆನಿ ದೊನ್ ಮಾಸ ಹಾತ್ತ. ಫನ್ ತ್ಯಾ ಯವ್‌ಡ್ಯಾ ಲೊಕಾನಾ ಪುರ್ನಾರ್ ನಾಹಿತ, ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","ಯೇಸು ಲೊಕಾನಾ ಬಸಾಯಾ ಸಾಂಗಾ ಮನ್ಲಾ ತ್ಯಾ ಜಾಗ್ಯಾತ್ ಗವಾತ್ ಲ ವಾಡ್ಲ ಹುತ್ತ ತಿಥ ಬಸ್‌ಲ್ಯಾಲ್ಯಾತ್ ಕಮಿಸ್ ಕಮಿ ಪಾಚ಼್ ಹಾಜಾ಼ರ್ ಗಡಿಸ್ ಹುತ್ತ. ");
INSERT INTO gok_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","ನಂತರ್ ಯೇಸುನಿ ತ್ಯಾ ಬಾಕ್‌ರ‍್ಯಾ ಗಿಹುನ್ ತ್ಯಂಚಿಸಾಟಿ ದೇವಾಲಾ ಧನ್ಯಾವಾದ್ ಸಾಂಗುನ್. ಬಸ್‌ಲ್ಯಾಲ್ಯಾ ಲೊಕಾನಾ ವ್ಯಾಟ್‌ಲ್ಯಾ. ತ್ಯನಿ ಮಾಶಾನಾಬಿ ತಸಸ್ ಕೆಲ. ಸಗ್‌ಳ್ಯಾಂಚಾನಿ ಆಪ್‌ಲ್ಯಾಲಾ ವ್ಹಯಿ ತ್ಯವ್ಡ ಖಾಲ. ");
INSERT INTO gok_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","ತ್ಯಂಚ಼ ಸಗ್‌ಳ್ಯಾಂಚ಼ ಪ್ವಾಟ್ ಬರ್ಲ ತವಾ ಯೇಸುನಿ ಸಾಂಗ್ಲ ಆಪ್‍ಲ್ಯಾ ಶಿಶಾನಾ ಉರ್ಲ್ಯಾಲ ತುಕ್ಡ ಗೊಳಾ ಕರಾ ಕಾ ಮಂಜೆ ಕಚ಼ಸ್ ಹಾಳ್ ವ್ಹವುನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","ಆನಿ ಶಿಶಾಂಚಾನಿ ಲೊಕಾನಾ ವ್ಯಾಟ್‌ಲ್ಯಾಲ್ಯಾ ಗವ್ಹಾಚಾ ಪಾಚ಼್ ಬಾಕ್‌ರ‍್ಯಾಂಚಾ ಉರ್ಲ್ಯಾಲ್ಯಾ ತುಕ್‌ಡ್ಯಾಂಚಾನಿ ಬಾರಾ ಬುಟ್ಯಾ ಬರ್ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","ಯೇಸುನಿ ಕೆಲ್ಯಾಲ ಚಮತ್ಕಾರಾಚ಼ ಕಾಮ್ ಬಗ್‌ಲ್ಯಾ ನಂತರ್ ಲೊಕ, ಹೆ ದುನೆತ್ ಯಯಾಚಾ಼ ಆಸ್‌ಲ್ಯಾಲಾ ಪ್ರವಾದಿ ಖರ‍್ಯಾನಿ ಹ್ಯೊಸ್, ಮನ್ಹಾಯಾ ಲಾಗ್ಲಿತ. ” ");
INSERT INTO gok_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","ಆಪ್‌ಲ್ಯಾಲಾ ಬಳ್ ಜು಼ರಿನಿ ರಾಜಾ಼ ಕರಾಯಾ ಲೊಕ ಯವಸ್‌ತ್ಯಾತ ಮನ್ಹುನ್ ಯೇಸುಲಾ ಸಮಾಜ಼್ಲ ಹುತ್ತ. ಮನ್ಹುನ್ ತ್ಯೊ ತಿಥ್ನಿ ಆಪ್ನು ಯಕ್ಲಾಸ್ ಪರತ್ ಕನ್ಯಾಪ ಆನಿ ಗೇಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","ತಿಸಿ ಶಾಂಜ಼್ ಜಾ಼ಲಿ ತವಾ ಯೇಸುಚ಼ ಶಿಶಾ ಸಮಿಂದೊರಾತ್ ಗೇಲ. ");
INSERT INTO gok_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ತವಾ ಶಿಶಾ ವ್ಹಡಿತ್ ಚ಼ಡುನ್ ಸಮಿಂದೋರಾಚೆ ಪಲಿಕ್ಡ ಕಪೇರ್ನೌಮಿತ್ ಜಾ಼ಯಿತ ತವಾ ಆಂದಾರ್ ಜಾ಼ಲ್ಥಾ. ಆನಿ ಯೇಸು ತ್ಯಂಚಿಪ ಆಜು಼ನ್ ಆಲಾ ನವ್ಥಾ. ");
INSERT INTO gok_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","ತವಾ ಖುಬ್ ಜೊ಼ರ್ ವಾರ ಸುಟ್ಲ ಹುತ್ತ ಸಮಿಂದೊರಾಚಾ ಲ್ವಾಟಾ ಮೊಟ್ಯಾನಿ ಯಯಿತ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","ತೇ ಹುಟ್ ಗಾಲಿತ್ ಜ಼ವ ಜ಼ವಳ್ ತೀನ್ ಚಾರ್ ಮೈಲ್ ವ್ಹಡಿ ಚಾ಼ಲಿವಲ್ಯಾ ನಂತರ್ ಯೇಸುಲಾ ಬಗ್ಲಾ. ತ್ಯೊ ಪಾನ್ಯಾವ ಚಾ಼ಲತ್ ವ್ಹಡಿಪ ಯತ್ಯಾಲಾ ಬಗುನ್ ತೇ ಬಿಹ್ಯಾಲ. ");
INSERT INTO gok_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","ಯೇಸು ತ್ಯನಾ, “ಭಿಹುನಕೊಸಾ, ಮೀಸ್ ತ್ಯೊ” ಮನ್ಲಾ ");
INSERT INTO gok_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","ತವಾ ತೇ ಯೇಸುಲಾ ವ್ಹಡಿತ್ ಗಿಹ್ಯಾ ವ್ಹಯಿ ಮನ್ಹಿತ. ತ್ಯವ್‌ಡ್ಯಾತ್ ತೇ ಜಾ಼ಯಾಚಾ ಜಾ಼ಗ್ಯಾವ ವ್ಹಡಿ ಪುಚ್ಲಿ ಹುತ್ತಿ. ");
INSERT INTO gok_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","ದುಸ್ರೆ ದೀಸಿ. ಥುಡಿ ಲೊಕ ಸಮಿಂದೊರಾಚೆ ಪಲಿಕ್ಡ ರಾಯ್ಲಿ ಹುತ್ತಿತ ಯೇಸು ಆಪ್‌ಲ್ಯಾ ಶಿಶಾಂಚೆ ಸಂಗ ವ್ಹಡಿತ್ನೀ ಗೇಲಾ ನಾಹಿ ಮನ್ಹುನ್ ಹ್ಯಾ ಲೊಕಾನಾ ಠಾವ ಹುತ್ತ. ಯೇಸುಚ಼ ಶಿಶಾ ತ್ಯವ್ಡಸ್ ವ್ಹಡಿತ್ನಿ ಗೇಲ್ಯಾತ ಆನಿ ಯೇಕುಸ್ ವ್ಹಡಿ ತಿಥ ಹುತ್ತಿ ಮನ್ಹುನ್ ತ್ಯನಾ ಠಾವಿ ಹುತ್ತಿ ಕಾ ಮಂಜೆ ತೇ ತ್ಯಲಾ ಯಕ್‌ಲ್ಯಾಲಾಸ್ ಮಾಗ ಸುಡುನ್ ಗೆಲ್ತ. ");
INSERT INTO gok_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","ತವಾ ದುಸ್‌ರ‍್ಯಾ ವ್ಹಡ್ಯಾ ತಿಬೇರಿಯಾಚಾ ಸಮಿಂದೊರಾತ್ನಿ ಪ್ರಭುನಿ ದನ್ಯಾವಾದ್ ಸಾಂಗ್‌ಲ್ಯಾ ನಂತರ್ ದಿಲ್ಯಾಲ್ಯಾ ಬಾಕ್‌ರ‍್ಯಾ ಲೊಕಾಂಚಾನಿ ಖಾಲ್ಯಾಲ್ಯಾ ಜಾ಼ಗ್ಯಾಚೆ ಜ಼ವಳ್ ಡೆಗವ ಯವುನ್ ಪುಚ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","ಯೇಸು ಆನಿ ತ್ಯಚ಼ ಶಿಶಾ ತಿಥ ನಸ್‌ಲ್ಯಾಲ ಬಗುನ್ ವ್ಹಡಿತ್ ಚ಼ಡುನ್ ಯೇಸುಲಾ ಸುದಿತ್ ಕಪೇರ್ನೌಮಿತ್ ಗಿಲಿತ. ");
INSERT INTO gok_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","ಲೊಕಾಂಚಾನಿ ಯೇಸುಲಾ ಸಮಿಂದೊರಾಚೆ ಪಲಿಕ್ಡ ದರವ ಬಗ್ಲಾ ಆನಿ ತ್ಯಂಚಾನಿ ತ್ಯಲಾ ಗುರು ತು ಹಿತ್ತ ಕವಾ ಆಲಾಸ್? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","ಯೇಸು ಮನ್ಲಾ, “ಮಿ ತುಮಾನಾ ಖರ ಸಾಂಗ್ತೊ ತುಮಿ ಮಾಜಿ ಚಮತ್ಕಾರಾಚಿ ಕಾಮ ಬಗುನ್‌ ತುಮಿ ಮನಾ ಶೊತ್ಯಾಲಿ ನವ್ಹಸಾ ತುಮಾನಾ ಪ್ವಾಟ್ಬ ಖಾಯಾ ಗಾವ್ಲ ಮನ್ಹುನ್ ಶೊತ್ಯಾಸಾ. ");
INSERT INTO gok_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","ಬಾದ್ ವ್ಹತ್ಯಾಲ್ಯಾ ಜೇವ್ನಾಲಾ ರಾಬು ನಕೊಸಾ ಫನ್ ಶಾಶ್ವತ್ ಜೀವ್ ದೆತ್ಯಾಲ್ಯಾ ಜೆವ್ನಾಸಾಟಿ ರಾಬಾ ತ್ಯ ಮಾನ್ಸಾಚಾ಼ ಲ್ಯೊಕ್ ದೆನಾರ್ ತ್ಯಚಿವ ಬಾ ದೇವಾನಿ ಹುಕ್ಮಾಚಾ಼ ಶಿಕ್ಕಾ ಥೆವ್‌ಲ್ಯಾ ಮನ್ಹುನ್ ಸಾಂಗ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","ಲೊಕಾಂಚಾನಿ ಯೇಸುಲಾ ಇಚಾರ್ಲ, “ಆಮಿ ಕಸ್ಲಿ ಕಾಮ ಕರಾಯಾ ವ್ಹಯಿತ ಮನ್ಹುನ್ ದೇವ್ ಮಂಥೊ. ” ");
INSERT INTO gok_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","“ದೇವಾನಿ ಲಾವುನ್ ದಿಲ್ಯಾಲ್ಯಾವ ತುಮಿ ಇಸ್ವಾಸ್ ಥೆವಾಯಾ ವ್ಹಯಿಸಾ ಹಿ ಕಾಮ ದೇವ್ ತುಮ್ಚಿಪ್ನಿ ಬಗ್ತೊ.” ಮನ್ಲಾ ");
INSERT INTO gok_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","ತವಾ ಲೊಕ ದೇವಾಪ್ನಿ ಲಾವುನ್ ದಿಲ್ಯಾಲಾ ತುಸ್ ಮನ್ಹುನ್ ಖರ ಕರಾಯಾ ತು ಕಸ್ಲಿ ಚಮತ್ಕಾರಾಚಿ ಕಾಮ ಕರ್ನಾರ್ ");
INSERT INTO gok_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","ಆಮ್ಚಾ ವಡ್ಲಾಂಚಾನಿ ರಾನಾತ್ ದಿಲ್ಯಾಲಾ ಮನ್ನಾ ಖಾಲ ಆಸ ಹ್ಯಾ ಶಾಸ್ತಾರಾತ್ ಲಿವ್‌ಲ್ಯಾ ತ್ಯನಾ ತ್ಯನಿ ಖಾಯಾ ಸ್ವರ್ಗಾತ್ನಿ ಬಾಕ್ರಿ ದಿಲಿ. ಮನ್ಲಿತ ");
INSERT INTO gok_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","ತವಾ,ಯೆಸು “ಮಿ ತುಮಾನಾ ಖರ ಸಾಂಗ್ತೊ ತುಮ್ಚಾ ಲೊಕಾನಾ ಸ್ವರ್ಗಾತ್ನಿ ಬಾಕ್ರಿ ದಿಲ್ಯಾಲಿ ಮೊಶೆನಿ ನವ್ಹ ಮಾಜಾ ಬಾನಿ ಪರಲೊಕಾತ್ನಿ ಖರಿ ಬಾಕ್ರಿ ದಿಲೆ. ");
INSERT INTO gok_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","ದೇವ್ ದೇತ್ಯಾಲಿ ತೀ ಬಾಕ್ರಿ ಸ್ವರ್ಗಾತ್ನಿ ಉತ್ರುನ್ ಆಲೆ ಆನಿ ದುನೆಲಾ ಜೀವ್ ದಿತಿ.ಮನ್ಲಾ ");
INSERT INTO gok_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","ತವಾ ಲೊಕ, “ಸ್ವಾಮಿ ತೀ ಬಾಕ್ರಿ ಆಮಾನಾ ಖಾಯಿಮ್ ದೇ ಮನ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","ತವಾ ಯೇಸುನಿ ತ್ಯನಾ ಸಾಂಗ್ಲ, “ಮೀಸ್ ತೀ ಜೀವ್ ದೇತ್ಯಾಲಿ ಬಾಕ್ರಿ ಮಾಜಿಪ ಯತ್ಯಾಲ್ಯಾಲಾ ಕಾವಾಸ್ ಭುಕ್ ಲಾಗ್ನಾರ್ ನಾಹಿ ಮಾಜಿವ ಇಸ್ವಾಸ್ ಥೆವ್‌ತ್ಯಾಲ್ಯಾಲಾ ಕವಾಸ್ ತಾನ್ ಲಾಗ್ನಾರ್ ನಾಹಿ. ” ");
INSERT INTO gok_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","ಮಿ ತುಮಾನಾ ಆಂದಿ ಸಾಂಗ್‌ಲ್ಯಾ ಶಾರ್ಕ ತುಮಿ ಮನಾ ಬಗ್ಲಾಸಾ ತರಿ ಆಜು಼ನ್ ಮಾಜಿವ ಇಸ್ವಾಸ್ ಥಿವಿತ್ ನಾಹಿಸಾ. ");
INSERT INTO gok_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","ಮಾಜಾ ಬಾನಿ ದಿಲ್ಯಾಲಿ ತೀ ಸಗ್ಳಿ ಲೊಕ ಮಾಜಿಪ ಯತ್ಯಾತ. ಆನಿ ಮೀ ಮಾಜಿಪ ಯತ್ಯಾಲ್ಯಾ ಕುನಾಲಾಸ್ ಕಂದಿಸ್ ಮಾಗಾರಿ ಲಾವುನ್ ದಿಯಿತ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","ಕಾ ಮಂಜೆ ಮಿ ಸ್ವರ್ಗಾತ್ನಿ ಮಾಜಾ ಮನಾ ಶಾರ್ಕ ಕರಾಯಾ ಆಲ್ಯಾಲೊ ನವ್ಹ. ಕಚಾನಿ ಮನಾ ಲಾವುನ್ ದಿಲ್ಯಾ ತ್ಯಚಿ ಇಚ್ಚಾ ಪುರ್ನ ಕರಾಯಾ ಆಲ್ಯೊ. ");
INSERT INTO gok_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","ಆನಿ ಮನಾ ಲಾವುನ್ ದೆನಾರ‍್ಯಾಚಿ ಇಚ್ಚಾ ಹಿ ಜಾ಼ಲೆ ಮಿ ಕುನಾಲಾ ದೇವಾನಿ ಒಪಸಲ್ಯಾತ ತ್ಯಾತ್ಲಾ ಯೊಕ್ಬಿ ಮಾಜಿಪ್ನಿ ಸಾಂಡುನ್ ಜಾ಼ವುನಾಹಿ ಆನಿ ಸರ್ತ್ಯಾ ದಿಸಾತ್ ಜಿವಂತ್ ಉಟ್ವಾಯಾ ವ್ಹಯಿ. ");
INSERT INTO gok_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","ಲೇಕಾಲಾ ಬಗುನ್ ತ್ಯಚಿವ ಇಸ್ವಾಸ್ ಥೆವ್‌ತ್ಯಾಲ್ಯಾ ಪರತೇಕಾನಿ ಶಾಶ್ವತ್ ಜೀವ್ ಗೇತಲ್ಯಾ ಸರ್ತ್ಯಾ ದಿಸಾತ್ ತ್ಯಾ ಮಾನ್ಸಾಲಾ ಜೀತ್ತಾ ಉಠಿವ್ತೊ ಮಾಜಾ ಬಾಚಿ ಇಚ್ಚಾಬಿ ಹೀಸ್. ");
INSERT INTO gok_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","ಯೆಹುದಿ ಯೇಸುಚೆ ಗುಶ್ಟಿತ್ ಬಡಬಡ್ಲ ಕಾ ಮಂಜೆ ತ್ಯನಿ ಸ್ವರ್ಗಾತ್ನಿ ಉತ್ರುನ್ ಆಲ್ಯಾಲಿ ಬಾಕ್ರಿ ಮೀಸ್ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","ಯೆಹುದಿ ಹ್ಯಚಿ ಆಯಿ ಬಾ ಆಮಾನಾ ಠಾವಿ ಹಾತ್ತ. ಹ್ಯೊ ಯೊಸೆಫಾಚಾ಼ ಲ್ಯೊಕ್ ಯೇಸು ನವ್ಹ ಕ್ಯಾ? ಮಿ ಸ್ವರ್ಗಾತ್ನಿ ಉತ್ರುನ್ ಆಲ್ಯೊ ಮನ್ಹುನ್ ಹ್ಯನಿ ಸಾಂಗಾಯಾ ಕಸ ವ್ಹನಾರ್? ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","ತವಾ ಯೇಸುನಿ ತುಮಿ ಬಡಬಡಾಚ಼ ಥಾಂಬ್ವಾ. ");
INSERT INTO gok_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","ಮನಾ ಲಾವುನ್ ದಿಲ್ಯಾಲ್ಯಾ ಮಾಜಾ ಬಾನಿ ಮಾಜಿಪ ಲಾವುನ್ ದಿಯಿಸ್ಪರ‍್ಯಾತ್ ಕೊನ್ ಮಾಜಿಪ ಪರ‍್ಯಾತ್ ಯಯಿತ್ನಾಹಿ. ಆನಿ ಮಿ ಸರ್ತ್ಯಾ ದಿಸಾತ್ ತ್ಯನಾ ಜಿವಂತ್ ಉಠಿವ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","ಪ್ರವಾದಿಂಚಾನಿ ಲಿವ್‌ಲ್ಯಾ ಆನಿ ‘ತೇ ಸಗ್ಳ ದೇವಾಪ್ನಿ ಲಾವುನ್ ದಿಲ್ಯಾಲ ಜಾ಼ಲ್ಯಾತ. ಕೊನ್ ಬಾಪ್ನಿ ಐಕುನ್ ಸಿಕ್ತೊ ತ್ಯೊ ಮಾಜಿಪ ಯತೊ. ");
INSERT INTO gok_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","ಬಾಪ್ನಿ ಆಲ್ಯಾಲಾ ತ್ಯವ್ಡಾಸ್ ಬಾಲಾ ಬಗ್ತೊ ದುಸ್‌ರ‍್ಯಾ ಕುಟಲ್ಯಾ ಮಾನ್ಸಾನಿ ಬಾಲಾ ಬಗ್ಲಾ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","ಮಿ ತುಮನಾ ಖರ ಸಾಂಗ್ತೊ ಕೊನ್ ಇಸ್ವಾಸ್ ಥೆವ್ತೊ ತ್ಯಲಾ ಶಾಶ್ವತ್ ಜೀವ್ ಗಾವ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","ಮೀಸ್ ಜೀವಾಚಿ ಬಾಕ್ರಿ. ");
INSERT INTO gok_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","ತುಮ್ಚಾ ವಡ್ಲಾಂಚಾನಿ ರಾನಾತ್ ಮನ್ನಾ ಖಾಲಾ ತರಬಿ ಮೆಲ. ");
INSERT INTO gok_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","ಫನ್ ಸ್ವರ್ಗಾತ್ನಿ ಆಲ್ಯಾಲ್ಯಾಲಿ ಬಾಕ್ರಿ ಕೊನ್ ಖಾಯಿಲ್ ತ್ಯೊ ಮರತ್ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","ಸ್ವರ್ಗಾತ್ನಿ ಆಲ್ಯಾಲಿ ಜೀವಾಚಿ ಬಾಕ್ರಿ ಮೀಸ್. ಹಿ ಬಾಕ್ರಿ ಖಾತ್ಯಾಲ್ಯಾಲಾ ಶಾಶ್ವತ್ ಜಿವ್ ರಾನ್ಹಾರ್. ಮಿ ತುಮಾನಾ ದೆತ್ಯಾಲಿ ಬಾಕ್ರಿ ಮಾಜ಼ ಶರಿರ್ ಜಾ಼ಲ್ಯಾ. ತ್ಯ ಮಿ ದುನೆಚಾ ಜಿವಾಸಾಟಿ ದೆತೊ. ");
INSERT INTO gok_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","ತವಾ ಯೆಹುದಿ ಹ್ಯೊ ಮಾನುಸ್ ಆಪ್ಲ ಶರಿರ್ ಆಮಾನಾ ಖಾಯಾ ದಿಯಾ ಕಸ ವ್ಹತ ಮನ್ಹುನ್ ಆಪ್‌ಲ್ಯಾ ಆಪ್‌ಲ್ಯಾತ್ ವಾದ್ ಕರಾಯಾ ಲಾಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","ಯೇಸುನಿ ಮಿ ತುಮಾನಾ ಖರ ಸಾಂಗ್ತೊ. ತುಮಿ ಮಾನ್ಸಾಚಾ ಲೇಕಾಚ಼ ಶರಿರ್ ಖಾಲನಾಹಿಸಾತ ತ್ಯಚ಼ ರಗಾತ್ ಪಿಯಾಲಾ ನಾಹಿಸಾತ ತುಮಾನಾ ಜೀವ್ ರಾನ್ಹಾರ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","ಕೊನ್ ಮಾಜ಼ ಶರಿರ್ ಖಾತೊ ಆನಿ ಮಾಜ಼ ರಗಾತ್ ಪಿತೊ ತ್ಯಲಾ ಶಾಶ್ವತ್ ಜೀವ್ ಗಾವ್ತೊ. ಆನಿ ಸರ್ತ್ಯಾ ದಿಸಾತ್ ತ್ಯಾ ಮಾನ್ಸಾಲಾ ಮಿ ಜಿತ್ತಾ ಕರ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","ಮಾಜ಼ ಶರಿರ್ ಖರ ಜೇವಾನ್ ಜಾ಼ಲ್ಯಾ ಮಾಜ಼ ರಗಾತ್ ಖರ ಪಿನ ಜಾ಼ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","ಮಾಜ಼ ಶರಿರ್ ಖಾವುನ್ ಮಾಜ಼ ರಗಾತ್ ಪಿವುನ್ ಕೊನ್ ಮಾಜಿಪ ರಾಥೊ ತ್ಯಚಿಪ ಮಿ ರಾಥೊ. ");
INSERT INTO gok_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","ಜೀವ್ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ಬಾನಿ ಮನಾ ಲಾವುನ್ ದಿಲ್ಯಾ ಆನಿ ತ್ಯಚಾನಿಸ್ ಮಿ ಜಿವ್ನಾ ಕರ್ತ್ಯೊ, ಮನ್ಹುನ್ ಕೊನ್ ಮನಾ ಖಾತೊ ತ್ಯೊ ಮಾಜಿಪ್ನಿ ಜಿವ್ನಾ ಕರ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","ಹಿ ಸ್ವರ್ಗಾತ್ನಿ ಉತ್ರುನ್ ಆಲ್ಯಾಲಿ ಬಾಕ್ರಿ ಜಾ಼ಲೆ, ತುಮ್ಚಾ ವಡ್ಲಾಂಚಾನಿ ಮನ್ನಾ ಖಾಲಾ ಮರುನ್ ಗೇಲ, ಫನ್ ಕೊನ್ ಹಿ ಬಾಕ್ರಿ ಖಾಯಿಲ್ ತ್ಯೊ ಶಾಶ್ವತ್ ಜಿತ್ತಾ ರಾನ್ಹಾರ್. ");
INSERT INTO gok_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","ಯೇಸುನಿ ಕಪೇರ್ನೌಮ್ ಸಭಾಸ್ಥಾನಾತ್ ಸಿಕಿವ್ತಾನಾ ಹ್ಯ ಸಗ್ಳ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","ಹ್ಯ ಸಿಕಿವ್ನ ಖುಬ್ ಕಶ್ಟಾಚ಼ ಹ್ಯ ಕೊನ್ ಮಾನಿತ್ ನಾಹಿತ. ");
INSERT INTO gok_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","ಆಪ್ಲ ಶಿಶಾ ಬಡಬಡ್‌ತ್ಯಾತ ಮನ್ಹುನ್ ಯೇಸುಲಾ ಸಮಾಜ಼್ಲ ಹ್ಯಾ ಸಾಂಗ್‌ನ್ಯಾನಿ ತುಮಾನಾ ತರಾಸ್ ಜಾ಼ಲಾ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","ಯೆಕ್ ಯಳಿ ಮಾನ್ಸಾಚಾ಼ ಲ್ಯೊಕ್ ಆಂದಿ ಕುಠ ಹುತ್ತಾ ತಿಥ ಜಾ಼ತ್ಯಾಲಾ ಬಗ್‌ಲ್ಯಾವ ತುಮಿ ಕ್ಯಾ ಕರ್ನಾರ್? ");
INSERT INTO gok_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","ಜಿವ್ ದೆತ್ಯಾಲ ದೇವಾಚ಼ ಆತ್ಮ ಜಾ಼ಲ್ಯಾ. ಮಾನ್ಸಾಚಾ ಸಾಮರ್ಥ್ಯಾನಿ ಕಾಯ್ ಉಪೆಗ್ ನಾಹಿ. ಮಿ ತುಮಾನಾ ಕಚಾ ಬೊಲ್ಯಾ ಸಾಂಗ್‌ಲ್ಯಾತಾ ತೀ ದೇವಾಚಿ ಆತ್ಮ ಜಾ಼ಲ್ಯಾತ ಆನಿ ಜೀವ್ ದೆತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","ತರಿಬಿ ತುಮ್ಚಾತ್ಲ ಥೊಡ ಇಸ್ವಾಸ್ ಥಿವಿತ್ ನಾಹಿತ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ಆಪ್ಲಿವ ಇಸ್ವಾಸ್ ಥೆವ್‌ಲ್ಯಾನಸ್‌ಲ್ಯಾಲ ಕೊನ್ ಕೊನ್ ಮನ್ಹುನ್ ಆಪ್ಲಾ ಮೊಸ್ ಕರ್ನಾರಾ ಕೊನ್ ಮನ್ಹುನ್ ಯೇಸುಲಾ ಆಂದಿಸ್ ಸಮಾಜ಼್ಲ ಹುತ್ತ. ");
INSERT INTO gok_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","ಯೇಸು “ಬಾನಿ ಲಾವುನ್ದಿಯಾಚೆ ಆಂದಿ ಮಾಜಿಪ ಕೊನುಸ್ ಯಯಿತ್ನಾಹಿ ಮನ್ಹುನ್, ಮಿ ತುಮಾನಾ ಹ್ಯಚಿ ಸಾಟಿಸ್ ಸಾಂಗ್ಲ ಹುತ್ತ.”ಮನ್ಲಾ ");
INSERT INTO gok_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","ಯೇಸುನಿ ಹ್ಯಾ ಗುಶ್ಟಿ ಸಾಂಗ್‌ಲ್ಯಾ ನಂತರ್ ಯೇಸುಚೆ ಮಾಗ್ನಿ ಜಾ಼ತ್ಯಾಲ ಖುಬ್ ಜಾ಼ನ್ ಶಿಶಾ ತ್ಯಲಾ ಸುಡುನ್ ಗೆಲ. ಆನಿ ಕವಾಸ್ ತ್ಯಚೆ ಮಾಗ್ನಿ ಆಲ ನಾಹಿತ. ");
INSERT INTO gok_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","ಯೇಸುನಿ ಆಪ್‌ಲ್ಯಾ ಬಾರಾ ಜಾ಼ನ್ ಶಿಶಾನಾ, “ತುಮಿಬಿ ಮನಾ ಸುಡುನ್ ಜಾ಼ಯಾ ವ್ಹಯಿ ಮಂಥಾಸಾ ಕ್ಯಾ ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","ಸಿಮೊನ್ ಪೇತ್ರಾ ಯೇಸುಲಾ , “ಪ್ರಭು ಆಮಿ ಕುನಾಪ ಜಾ಼ವಾವ? ಶಾಶ್ವತ್ ಜೀವ್ ದಿಯಾಚ಼ ಸಬ್ದ ತುಜಿಪ ಹಾತ್ತ. ");
INSERT INTO gok_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","ಆಮಿ ತುಜಿವ ಇಸ್ವಾಸ್ ಥೆವ್ತಾವ್. ತು ದೇವಾಪ್ನಿ ಆಲ್ಯಾಲಾ ಪರಿಶುದ್ದ ಮನ್ಹುನ್ ಆಮಾನಾ ಠಾವಾ ಹಾಸ್” ಮನ್ಲಾ ");
INSERT INTO gok_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","ತವಾ ಯೇಸು, “ತುಮಾನಾ ಬಾರಾ ಜ಼ನಾನಾ ಮಿ ನಿವಡ್ಲ ನಾಹಿತ ಕ್ಯಾ? ತರಿಬಿ ತುಮ್ಚಾತ್ ಯೊಕ್ ಸೈತಾನ್ ಜಾ಼ಲ್ಯಾ.ಮನ್ಲಾ ");
INSERT INTO gok_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","ಯೇಸು ಸಿಮೊನ್ ಇಸ್ಕರಿಯುತಾಚಾ಼ ಲ್ಯೊಕ್ ಯುದಾಚ಼ಸ್ ಬೊಲತಾ. ಯುದ್ ಬಾರಾ ಜಾ಼ನ್ ಅಪೊಸ್ತಲಾತ್ಲಾ ಯೊಕ್ ಜಾ಼ಲ್ಥಾ. ಫನ್ ಮೊರ‍್ಹ ಯೇಸುಚಾ಼ ಮೊಸ್ ಕರ್ತ್ಯಾಲಾ ತ್ಯೊಸ್. ");
INSERT INTO gok_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","ಹ್ಯ ಜಾ಼ಲ್ಯಾವ ಯೇಸು ಗಲಿಲಾಯಾತ್ ಫಿರ‍್ಲಾ ತ್ಯಲಾ ಯುದಾಯಾತ್ ಜಾ಼ಯಾ ಮನ್ ನವ್ಥ. ಕಾ ಮಂಜೆ ತಿತ್ಲ ಯೆಹುದಿ ತ್ಯಲಾ ಮಾರುನ್ ಟಾಕಾಯಾ ರಾಖಿತ. ");
INSERT INTO gok_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","ತವಾ ಯೆಹುದ್ಯಾಂಚಾ಼ ಮಾಂಡ್ವಾಚಾ ಸನಾಚಾ಼ ಯೊಳ್ ಜಾ಼ಲ್ತಾ ");
INSERT INTO gok_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ಮನ್ಹುನ್ ಯೇಸುಚ಼ ಶಿಶಾ ತ್ಯಲಾ, “ತು ಹಿತ್ನಿ ಗಲಿಲಾಯ್ ಸುಡುನ್ ಯುದಾಯಾತ್ ಜಾ಼, ತವಾ ತಿಥ ಆಸ್‌ಲ್ಯಾಲ ತುಜಿ ಮಾಗ್ನಿ ಯತ್ಯಾಲ ಬಾಹು ತು ಕರ್ತ್ಯಾಲ ಚಮತ್ಕಾರಾಚ಼ ಕಾಮ್ ಬಗ್ತಿಲ” ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","ಕಚಾ಼ ಮಾನುಸ್ ದುನೆತ್ ಮೊಟಾ ವ್ಹಯಾ ವ್ಹಯಿ ಮಂಥೊ ತ್ಯೊ ಆಪ್ಲಿ ಕಾಮ ಚು಼ರುನ್ ಕರೀತ್ನಾಹಿ ತು ಚಮತ್ಕಾರಾಚಿ ಕಾಮ ಕರತ್ಯೊಸ್ ಸಗ್ಳೆ ದರ್ಥಿವ ತುಜ಼ ತುಸ್ ಸಾಂಗ್. ");
INSERT INTO gok_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","ಯೇಸುಚ಼ ಬಾಹು ಸಾಹಿತ್ ತ್ಯಚಿವ ಇಸ್ವಾಸ್ ಥಿವಿತ್ ನವ್ಥ. ");
INSERT INTO gok_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","ಯೇಸು ಆಪ್‌ಲ್ಯಾ ಬಾವ್ಹಾನಾ ಮಾಜಾ಼ ಶಾರ್ಕಾ ಯೊಳ್ ಆಜು಼ನ್ ಆಲಾ ನಾಹಿ ತುಮಾನಾ ಸಗ್ಳಾ ಯೊಳ್ ಶಾರ್ಕಾಸ್. ");
INSERT INTO gok_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","ಹ್ಯಾ ಲೊಕಾತ್ಲಿ ತುಮ್ಚಿ ನಕ್ವಾಟ್ ಕರೀತ್ನಾಹಿತ ಫನ್ ಮನಾ ನಕ್ವಾಟ್ ಕರ್ತ್ಯಾತ ಕಾ ಮಂಜೆ ಮಿ ಹೆ ದುನೆತ್‍ಲ್ಯಾ ಮಾನ್ಸಾನಾ ತೀ ಕರ್ತ್ಯಾಲಿ ಕಾಮ ಬುರ್ಸಿ ಮನ್ಹುನ್ ಸಾಂಗ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","ಮನ್ಹುನ್ ತುಮಿ ಸನಾಲಾ ಜಾ಼ವಾ ಮಿ ಹ್ಯಾ ಸನಾಲಾ ಜಾ಼ಯಿತ್ನಾಹಿ ಮಾಜಾ಼ ಶಾರ್ಕಾ ಯೊಳ್ ಆಜು಼ನ್ ಆಲಾ ನಾಹಿ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","ಆನಿ ಯೇಸು ಆಸಾ ಸಾಂಗುನ್ ಗಲಿಲಾಯೆತ್ತುಸ್ ರಾಯ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","ಮನ್ಹುನ್ ಯೇಸುಚ಼ ಬಾಹು ಸನಾಲಾ ನಿಗಾಲ ತೇ ಗೆಲ್ಯಾ ನಂತರ್ ಯೇಸು ಲೊಕಾನಾ ಸಮಜಾ಼ಚೆ ಆಂದಿ ಗೇಲಾ ");
INSERT INTO gok_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","ಸನಾತ್ ಯೆಹುದ್ಯಾಂಚ಼ ಜಾಂತ ಯೇಸು ಕುಠ ಹಾ. ಮನ್ಹುನ್ ಇಚಾರಿತ್ ತ್ಯಲಾ ಸುದಿತ. ");
INSERT INTO gok_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","ತಿಥ ಲೊಕಾಂಚಾ಼ ಮೊಟಾ ಹಿಂಡ್ ಯೊಕ್ ಜ಼ಮ್ಲಾ ಹುತ್ತಾ. ತ್ಯಾತ್ಲಿ ಥುಡಿ ಜ಼ನ ಯೇಸುಚ಼ಸ್ ಗುಸು ಗುಸು ಬೊಲತಿತ ಥುಡಿಜ಼ನ ತ್ಯೊ ಚಾ಼ಂಗ್ಲಾ ಮನ್ಹುನ್ ಆನಿ ಥುಡಿಜ಼ನ ನಾಹಿ ತ್ಯೊ ಲೊಕಾನಾ ಫಸಿವ್‍ತ್ಯೋ ಮನ್ಹುನ್ ಬೊಲತಿತ. ");
INSERT INTO gok_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","ಫನ್ ಯೇಸುಚೆ ಗುಶ್ಟಿತ್ ಸಗ್‌ಳ್ಯಾಂಚೆ ಮೊರ‍್ಹ ಬೊಲಾಯಾ ತ್ಯಾತ್‌ಲ್ಯಾ ಕುನಾಲಾ ತ್ಯವ್ಡಾ ಧಿರ್ ನವ್ಥಾ ಲೊಕ ಯೆಹುದಿ ಅಧಿಕಾರ‍್ಯಾನಾ ಬಿಹಿತಿತ. ");
INSERT INTO gok_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","ಸನ್ ಲ ಥೊಡಾ ಅರ್ದಾ ಸಪ್ಲಾ ಹುತ್ತಾ. ತವಾ ಯೇಸು ದೇವ್ಳಾತ್ ಜಾ಼ವುನ್ ಸಿಕ್ವಾಯಾ ಲಾಗ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","ಯೆಹುದಿ ಅಧಿಕಾರಿ ಆಜಾಬ್ ಜಾ಼ಲ. ಆನಿ ಹ್ಯೊ ಮಾನುಸ್ ಸಾಳಾ ಸಿಕ್ಲಾ ನಾಹಿ. ತರಿ ಹ್ಯ ಯವ್ಡ ಸಗ್ಳ ಕಸಾ ಸಿಕ್ಲಾ? ಮನ್ಹುನ್ ಇಚಾರ್ ಕರಾಯಾ ಲಾಗ್ಲ ");
INSERT INTO gok_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","ಯೇಸು ಮಿ ಹ್ಯ ಸಿಕಿವ್‌ತ್ಯಾಲ ಮಾಜ಼ ಸ್ವತಾಚ಼ ನವ್ಹ. ಮಿ ಸಿಕಿವ್‌ತ್ಯಾಲ ಮನಾ ಲಾವುನ್ ದಿಲ್ಯಾಲ್ಯಾ ಬಾಪ್ನಿ ಆಲ್ಯಾಲ. ");
INSERT INTO gok_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","ದೇವಾಚಾ ಮನಾತ್ ಆಸ್‌ಲ್ಯಾಲ ಕರಾಯಾ ವ್ಹಯಿ ಮಂಥ್ಯಾಲ್ಯಾಲಾ ಮಾಜ಼ ಸಿಕಿವ್ನ ದೇವಾಪ್ನಿಸ್ ಆಲ್ಯಾಲ ಮಾಜ಼ ಸ್ವತಾಚ಼ ನವ್ಹ ಮನ್ಹುನ್ ಸಮಾಜ಼್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","ಕೊನ್ ಆಪ್‌ಲ್ಯಾ ಸ್ವತಾಚಾ ಅಧಿಕಾರಾನಿ ಬೊಲ್ತೊ ತ್ಯೊ ಆಪ್‌ಲ್ಯಾಲಾ ಮೈಮಾ ಗಿಹ್ಯಾ ಯತ್ನ ಕರ್ತೊ ಫನ್ ಕುನಿ ತ್ಯಲಾ ಲಾವುನ್ ದಿಲ್ಯಾ ತ್ಯಲಾ ಮೈಮಾ ದಿಯಾ ವ್ಹಯಿ ಮಂತೊ ತ್ಯೊ ಮಾನುಸ್ ನಿಯತಿಚಾ಼ ಆನಿ ತ್ಯಚಿಪ ಕಸ್ಲಿಸ್ ಲಬಾಡ್ಗಿರಿ ರಾಹಿತ್ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","ಮೊಶೆನಿ ತುಮಾನಾ ಧರ್ಮಶಾಸ್ತಾರ್ ದಿಲ ನಾಹಿ ಕ್ಯಾ? ಫನ್ ತುಮ್ಚಾತ್ಲಾ ಯೊಕ್ಬಿ ತ್ಯಚಿಗತ್ ಚಾ಼ಲತ್ ನಾಹಿಸಾ. ತುಮಿ ಕಾ ಮನಾ ಮಾರುನ್ ಟಾಕಾಯಾ ಯತ್ನ ಕರ್ತ್ಯಾಸಾ? ಮನ್ಲಾ ");
INSERT INTO gok_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","ತವಾ ಲೊಕ , “ತುಲಾ ಲಾಗಿರ್ ಲಾಗ್‌ಲ್ಯಾ. ಕೊನ್ ತುಲಾ ಮಾರುನ್ ಟಾಕಾಯಾ ಬಗ್‌ತ್ಯಾತ? ಮನ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","ತವಾ ಯೇಸು ತ್ಯನಾ , “ಮಿ ಕೆಲ್ಯಾಲ ಯಾಕ್ ಚಮತ್ಕಾರಚ಼ ಕಾಮ್ ಬಗುನ್ ತುಮಿ ಸಗ್ಳಿ ಗಾಭಾರ್ಲ್ಯಾಸಾ, ");
INSERT INTO gok_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","ಮೊಶೆನಿ ತುಮಾನಾ ಮುಂಜಿಚೆ ಗುಶ್ಟಿತ್ ನಿಯಮ್ ದಿಲ್ತಾ. ಫನ್ ಖರ‍್ಯಾನಿಸ್ ತೀ ತುಮಾನಾ ದಿಲ್ಯಾಲಿ ಮೊಶೆನಿ ನವ್ಹ ತ್ಯಚೆ ಆಂದಿ ಆಮ್ಚಾ ವಡ್ಲಾಂಚಿಪ್ನಿ ಹಿ ಪದ್ದತ್ ಆಲೆ ಮನ್ಹುನ್ ತುಮಿ ಸಬ್ಬತ್ ದಿಸಾದಿಸಿ ಮಾನ್ಸಾಚಿ ಮುಂಜಿ ಕರ್ತಾಸಾ. ");
INSERT INTO gok_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","ಸಬ್ಬತ್ ದಿಸಾದಿಸಿ ಕುನಾಲಾ ಕುನಿ ಮುಂಜಿ ಕಾ ಕರ್ತ್ಯಾತ ಮಂಜೆ ಮೊಶೆಚಾ಼ ನೆಮ್ ವಲ್ಯಾಂಡು ನಾಹಿ. ಇಸ್ರಾಂತಿಚಾ ದಿಸಾತ್ ಯಕಾ ಮಾನ್ಸಾಲಾ ಸಗ್ಳೆ ತರನಿ ಬರಾ ಕೆಲ್ಯಾಲ್ಯಾಲಾ ಕಾ ರಾಗ್ ಕರ್ತಾಸಾ? ");
INSERT INTO gok_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","ಡೊಳ್ಯಾನಿ ದಿಸತ್ಯಾಲ್ಯಾಲಾ ನ್ಯಾಯಿ ತಿರ್ಮಾನ್ ಕರಾಚೆ ಆಂದಿ ಖರ‍ ಕ್ಯಾ ಹಾ ತ್ಯಚಿವ ನ್ಯಾಯಿ ತಿರ್ಮಾನ್ ಕರಾ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","ನಂತರ್ ಯೆರುಸಲೇಮಿತ್ ರಾಯ್‍ಲ್ಯಾಲ್ಯಾತ್‌ಲ್ಯಾ ಥೊಡ್ಯಾಂಚಾನಿ, “ಅಧಿಕಾರಿ ಕಚಾಲಾ ಮಾರುನ್ ಟಾಕಾ ವ್ಹಯಿ ಮನ್ಹಿತ ತ್ಯೊ ಮಾನುಸ್ ಹ್ಯೊಸ್ ನವ್ಹ ಕ್ಯಾ. ” ");
INSERT INTO gok_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","ಬಗಾ ಹ್ಯೊ ಸಗ್‌ಳ್ಯಾ ಲೊಕಾಂಚೆ ಮೊರ‍್ಹಸ್ ಬೊಲ್ತ್ಯೊ ಚಾ಼ಲತ್ಯೊ ಫನ್ ತೀ ಲೊಕ ತ್ಯಚೆ ಆಡ್ವಿ ಕಾಯೇಕ್ ಬೊಲಂತ ಹ್ಯೊ ಖರ‍್ಯಾನಿಸ್ ಕ್ರಿಸ್ತ್ ಮನ್ಹುನ್ ಯೆಹುದಿ ಅಧಿಕಾರಿಂಚಾನಿ ಸಮಜು಼ನ್ ಗೆತಲ್ಯಾ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","ಫನ್ ಆಮಾನಾ ಠಾವ ಹಾ ಹ್ಯೊ ಮಾನುಸ್ ಕುಟ್ನಿ ಆಲ್ಯಾ ಮನ್ಹುನ್. ಕ್ರಿಸ್ತ್ ಕವಾ ಯನಾರ್ ಕುಟ್ನಿ ಯನಾರ್ ಹ್ಯ ಕುನಾಲಾಸ್ ಠಾವ ನಾಹಿ ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","ತವಾ ಯೇಸುನಿ ದೇವ್ಳಾತ್ ಸಿಕಿವ್ತಾ ಆಸ್ಥಾನಾ ಜೊ಼ರಾನಿ, “ ತುಮಾನಾ ಮಾಜೆ ಗುಶ್ಟಿತ್ ಠಾವ ಹಾ,ಆನಿ ಮಿ ಕುಟ್ನಿ ಆಲ್ಯೊ ಮನ್ಹುನ್ ತುಮಾನಾ ಸಮಾಜ್‍಼ಲ್ಯಾ. ಖರ ಮಿ ಆಲ್ಯಾಲೊ ಮಾಜಾ ಸ್ವತಾಚಾ ಹುಕ್ಮಾನಿ ನವ್ಹ. ಕುನಿ ಮನಾ ಲಾವುನ್ ದಿಲ್ಯಾ ತ್ಯೊ ಖರಾ ಹಾ. ತುಮಾನಾ ತ್ಯೊ ಠಾವಾನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","ಫನ್ ಮನಾ ತ್ಯೊ ಠಾವಾಹಾ. ಮಿ ತ್ಯಚಿಪ್ನಿಸ್ ಆಲ್ಯೊ ಆನಿ ತ್ಯನಿಸ್ ಮನಾ ಲಾವುನ್‍ದಿಲ್ಯಾ.” ಮನ್ಲಾ ");
INSERT INTO gok_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","ಹ್ಯ ಐಕುನ್ ಲೊಕ ತ್ಯಲಾ ಕೊಂಡಾಯಾ ಬಗಿತಿತ. ಖರ ಯೇಸುಲಾ ದರಾಯಾ ಕುನಾಲಾಸ್ ಜಾ಼ಲನಾಹಿ, ಕಾ ಮಂಜೆ ತ್ಯಚಾ಼ ಶಾರ್ಕಾ ಯೊಳ್ ಆಲಾ ನವ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","ಫನ್‍ ತ್ಯಾ ಹಿಂಡಾತ್‌ಲ್ಯಾ ಖುಬ್ ಲೊಕಾಂಚಾನಿ ಯೇಸುವ ಇಸ್ವಾಸ್ ಥಿವುನ್. ಮನ್ಲಿತ, “ಕ್ರಿಸ್ತ್ ಯನಾರ್ ತವಾ ಹ್ಯಚಿವ್ನಿ ಆಗಾವ್ ಕಾಮ ತ್ಯೊ ಕರಿಲಕ್ಯಾ? ಮನ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","ಯೇಸುಚೆ ಗುಶ್ಟಿತ್ ಲೊಕ ಗುಸುಗುಸು ಬೊಲ್‌ತ್ಯಾಲ ಫರಿಸಾಯಾಂಚಾನಿ ಐಕ್ಲ. ಆನಿ ಮುಖ್ಯ ಯಾಜಕಾಂಚಾನಿ ಆನಿ ಫರಿಸಾಯಾಂಚಾನಿ ಯೇಸುಲಾ ದರಾಯಾ ಸೈನಿಕಾನಾ ಲಾವುನ್‌ ದಿಲ. ");
INSERT INTO gok_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","ತವಾ ಯೇಸು, “ಆಜು಼ನ್ ಥೊಡಾ ಯೊಳ್ ಮಿ ತುಮ್ಚಿ ಸಂಗ ರಾನ್ಹಾರ್. ಮಂಗ್, ಮನಾ ಲಾವುನ್ ದಿಲ್ಯಾಲ್ಯಾಪ ಮಿ ಮಾಗಾರಾ ಜಾ಼ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","ತುಮಿ ಮನಾ ಶೊದ್ನಾರ್, ಫನ್ ತುಮಿ ಮನಾ ಬಗ್ನಾರ್ ನಾಹಿಸಾ, ಆನಿ ಮಿ ರಾನ್ಹಾರ್ ತೀಥ ತುಮಿ ಯನಾರ್ ನಾಹಿಸಾ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","ತವಾ ಯೆಹುದಿ ಅಧಿಕಾರಿ ಆಪ್‌ಲ್ಯಾ ಆಪ್‌ಲ್ಯಾತ್, “ಹ್ಯಲಾ ಆಮಿ ಬಗ್ನಾರ್ ನಾಹಿ ಆಸಾ ಹ್ಯೊ ಕುಠ ಜಾ಼ನಾರ್? ಆಮ್ಚಿ ಲೊಕ ನಾಂತ್ಯಾಲ್ಯಾ ಗ್ರೀಕ್ ಲೊಕಾಂಚೆ ಪೆಠತ್ನಿ ಜಾ಼ವುನ್ ಗ್ರೀಕ್ ಲೊಕಾನಾ ಸಿಕಿವ್ನಾರ್ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","‘ತಮಿ ಮನಾ ಶೊದ್ನಾರ್, ಫನ್ ಮನಾ ಬಗ್ನಾರ್ ನಾಹಿಸಾ. ‘ಮಿ ಜಾ಼ನಾರ್ ತಿಥ ತುಮಿ ಯನಾರ್ ನಾಹಿಸಾ’ ಮಂಥ್ಯೊ. ಮಂಜೆ ಕ್ಯಾ? ಮನ್ಹುನ್ ಯಕಾಮಕಾ ಸಂಗ ಬೊಲ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","ಸನಾಚಾ ಸರ್ತ್ಯಾ ಆನಿ ಮಹತ್ವಾಚಾ ದಿಸಾ ದಿಸಿ. ಯೇಸು ಉಬಾ ರಾಹುನ್, “ಕುನಾಲಾ ತರಿ ತಾನ್ ಲಾಗ್ಲಿತ ತ್ಯೊ ಮಾಜಿಪ ಯವುನ್ ಪಿವುನಿ. ");
INSERT INTO gok_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","ಕೊನ್ ಮಾಜಿವ ಇಸ್ವಾಸ್ ಥೆವ್ಥೊ ಶಾಸ್ತಾರ್ ಸಾಂಗ್‌ಲ್ಯಾಶಾರ್ಕ ತ್ಯಚೆ ಆತ್ನಿ ಜಿವ್ನಾ ದೆತ್ಯಾಲ್ಯಾ ಪಾನ್ಯಾಚಾ಼ ಜ಼ರ‍್ಹಾ ವ್ಹಾವ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","ಯೇಸುನಿ ಹ್ಯ ಪವಿತ್ರಾತ್ಮಾಚೆ ಗುಶ್ಟಿತ್ ಸಾಂಗ್ಲ. ಕೊನ್ ತ್ಯಚಿವ ಇಸ್ವಾಸ್ ಥೆವ್ತೊ. ತ್ಯಲಾ ತ್ಯ ಗಾವ್ನಾರ್. ತ್ಯಾ ಯಳಾ ಪರತ್ ತ್ಯನಾ ಪವಿತ್ರಾತ್ಮ ದಿಲ ನವ್ಥ ಕಾ ಮಂಜೆ ಆಜು಼ನ್ ಪರ‍್ಯಾತ್ ಯೇಸು ಮೈಮಾನಿ ಜಿತ್ತಾ ವ್ಹವುನ್ ಉಠುನ್ ಆಲಾ ನವ್ಥಾ. ");
INSERT INTO gok_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","ಹಿಂಡಾತ್‌ಲ್ಯಾ ಥೊಡ್ಯಾ ಲೊಕಾಂಚಾನಿ ಹ್ಯ ಐಕ್ಲ ತವಾ, “ಹ್ಯೊ ಮಾನುಸ್ ಖರ‍್ಯಾನಿಸ್ ಪ್ರವಾದಿ” ಮನ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","“ತ್ಯೊಸ್ ಕ್ರಿಸ್ತ” ಮನ್ಹುನ್ ಆನಿ ಥೊಡ್ಯಾಂಚಾನಿ ಸಾಂಗ್ಲ. ಆನಿ ಥೊಡಿಜ಼ನ, “ಕ್ರಿಸ್ತ ಗಲಿಲಾಯಾತ್ನಿ ಯನಾರ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","ಕ್ರಿಸ್ತ ದಾವೀದಾಚಾ ಗರ‍್ಹಾನ್ಯಾಚಾ಼ ಮನ್ಹುನ್ ದಾವೀದ್ ನಾಂದ್‌ಲ್ಯಾಲ್ಯಾ ಬೆತ್ಲೆಹೇಮ್ ಗಾವಾತ್ನಿ ತ್ಯೊ ಯನಾರ್ ಮನ್ಹುನ್ ಪವಿತ್ರ ಪುತೀಕ್ ಸಾಂಗ್ತ” ಮನ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","ಆಸಿ ಯೇಸುಚೆ ಗುಸ್ಟಿತ್ ಲೊಕಾತ್ನಿ ದುಯಿ ಬರ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","ಥುಡಿ ಯೇಸುಲಾ ದರಾಯಾ ವ್ಹಯಿ ಮನಿತಿತ. ಫನ್ ತ್ಯಲಾ ಹಾತ್‌ ಲಾವಾಯಾ ಕುನಾಲಾಸ್ ಜಾ಼ಲಾ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","ದೇವ್ಳಾತ್ಲ ರಕ್ವಲ್ದಾರ್ ಪರತ್ ಆಲ ತವಾ, ಮುಖ್ಯ ಯಾಜಕಾಂಚಾನಿ ಆನಿ ಫರಿಸಾಯಾಂಚಾನಿ ತ್ಯನಾ, “ತುಮಿ ತ್ಯಲಾ ಕಾ ದರುನ್ ಆನ್ಲಾ ನಾಹಿಸಾ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","ರಕ್ವಲ್ದಾರ್ ಮನ್ಲ, “ಹ್ಯೊ ಬೊಲ್‌ತ್ಯಾಚೆಗ್ ದುಸ್ರಾ ಕೊನ್ ಆಜು಼ನ್ ಪರ‍್ಯಾತ್ ಬೊಲ್ಲಾ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","ಫರಿಸಾಯಾಚಾಂನಿ, ತಸ ಜಾ಼ಲತ ಯೇಸುನಿ ತುಮಾನಾಬಿ ಫಸಿವ್ಲ! ");
INSERT INTO gok_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","ಅಧಿಕಾರಾತ್ಲ ವ್ಹವುಂತ ಫರಿಸಾಯಾತ್ಲ ವ್ಹವುಂತ ಕಚಾನಿತರಿ ಯಕಾನಿ ಇಸ್ವಾಸ್ ಥೆವ್‌ಲ್ಯಾ ಕ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","ಫನ್ ಲೊಕಾಂಚಾ ಹಿಂಡಾಲಾ ಮೊಶೆಚಾ ಧರ್ಮಶಾಸ್ತಾರಾಚೆ ಗುಸ್ಟಿತ್ ಕಾಯ್ ಠಾವ ನಾಹಿ. ಆನಿ ತೀ ದೇವಾಚಾ ಸರಾಪಾತ್ ಗಾವಲ್ಯಾತ!” ಆಸ ಮನ್ಲ ");
INSERT INTO gok_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","ಫನ್ ಪರಿಸಾಯಾತ್‌ಲ್ಯಾಂಚಾತ್ ನಿಕೊದೇಮ್ ಹುತ್ತಾ. ಹ್ಯೊ ಆಂದಿ ಯಂಗ್ದಾ ಯೇಸುಲಾ ಬಗಾಯಾ ಗೆಲ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","ನಿಕೊದ್ಯಮ್ ತ್ಯನಾ, “ಆಮ್ಚಾ ಧರ್ಮಶಾಸ್ತಾರಾಚಾ ನೆಮಾಶಾರ್ಕ ಕುನಿ ಕಾಯ್ ಐಕಾಚೆ ಆಂದಿ ಆನಿ ತ್ಯನಿ ಕ್ಯಾ ಕೆಲ್ಯಾ ಮನ್ಹುನ್ ಬಗಾಚೆ ಆಂದಿ ಗುನ್ನದಾರ್ ಮನ್ಹುನ್ ಸಾಂಗಾಯಾ ವ್ಹಯಿತ್ನಾಹಿ.ಮನ್ಲಾ ");
INSERT INTO gok_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","ತವಾ ತೇ ತ್ಯಲಾ , “ತುಬಿ ಗಲಿಲಾಯಾತ್ಲಾ ಕ್ಯಾ? ತೂಸ್ ಪವಿತ್ರ ಪುತಿಕಾತ್ ಬಗ್. ಗಲಿಲಾಯಾತ್ನಿ ಕಚಾ಼ಸ್ ಪ್ರವಾದಿ ಯಯಿತ್ ನಾಹಿ. ” ಮನ್ಲ ");
INSERT INTO gok_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","ಮಂಗ್ ಸಗ್ಳ ಆಪ್‍ಲ್ಯಾ ಆಪ್‍ಲ್ಯಾ ಗರ‍್ಹಾತ್ನಿ ಗೆಲ. ");
INSERT INTO gok_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","ಫನ್ ಯೇಸು ಆಲಿವ್ ಮಂಥ್ಯಾಲ್ಯಾ ಗುಢ್ಯಾವ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","ತ್ಯೊ ದೇವ್ಳಾಚಾ ಅಂಗ್ನಾತ್ ಮಾಗಾರಾ ಗೇಲಾ. ಲೊಕ ಸಗ್ಳಿ ಯೇಸುಚೆ ಸರ್ಬೌವಾರಿ ಜ಼ಮ್ಲಿತ. ತ್ಯೊ ತಿಥ ಬಸುನ್ ಲೊಕಾನಾ ಸಿಕ್ವಾಯಾಲಾಗ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","ತವಾ ದರ್ಮೊಪದೆಶಕ್ ಆನಿ ಫರಿಸಾಯಾಂಚಾನಿ ವೆಬಿಚಾರ್ ಕರ್ತಾನಾ ಗಾವಲ್ಯಾಲೆ ಯೆಕ ಬಾಯಿಲ್ ಮಾನ್ಸಾಲಾ ತಿಥ ಗಿವುನ್ ಆಲ. ತ್ಯಂಚಾನಿ ತೆ ಬಾಯಿಲ್ ಮಾನ್ಸಾಲಾ ಲೊಕಾಂಚೆ ಮೊರ‍್ಹ ಉಬಿ ಕರುನ್, ");
INSERT INTO gok_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","ಯೇಸುಲಾ, “ಗುರು, ಹಿ ಬಾಯಿಲ್ ಮಾನುಸ್ ವ್ಯಬಿಚಾರ್ ಕರ್ತ್ಯಾಲಿ ಗಾವ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","ಆಸ್ಲಿ ಕಾಮ ಕರ್ತ್ಯಾಲ್ಯಾ ಪರತೇಕ್ ಬಾಯಿಲ್ ಮಾನ್ಸಾಲಾ ದೊಂಢ್ಯಾನಿ ಮಾರುನ್ ಟಾಕಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಮೊಶೆನಿ ಧರ್ಮಶಾಸ್ತಾರಾತ್ ಆಜ್ಞೆ ಕೆಲೆ. ಹ್ಯಲಾ ತು ಕ್ಯಾ ಸಾಂಗ್ತೊಸ್? ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","ಯೇಸು ಸಬ್ದಾತ್ ಗಾವಲ್ಯಾವ ತ್ಯಚಿವ ಚು಼ಕ್ ವಾವಾಯಾ ವ್ಹತೆ ಮನ್ಹುನ್ ಹೆ ಪ್ರಶ್ನೆ ಇಚಾರ್ಲ. ಫನ್ ಯೇಸು ಖಾಲ್ ವಾಕುನ್ ಆಪ್‌ಲ್ಯಾ ಬೊಟಾನಿ ಜಿಮ್ನಿವ ಲಿವಾಯಾ ಲಾಗ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","ತ್ಯಂಚಾನಿ ತಿಸ್ ಪ್ರಶ್ನೆ ಆನೀಕ್ ಇಚಾರ್ಲಿ. ತವಾ ಯೇಸು ಶಾರ್ಕಾ ಉಬಾರಾಹುನ್, “ತುಮ್ಚಾತ್ ಪಾಪ್ ಕೆಲ್ಯಾ ನಸ್‌ಲ್ಯಾಲ್ಯಾನಿ ತಿಚಿವ ಪಯ್ಲಾ ದೊಂಢಾ ಮಾರುನಿ” ಮನ್ಹುನ್ ಸಾಂಗುನ್, ");
INSERT INTO gok_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","ಆನೀಕ್ ತ್ಯನಿ ವಾಕುನ್ ಜಿಮ್ನಿವ ಲಿವ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","ಯೇಸುಚ಼ ಹ್ಯ ಬೊಲ್ನ ಐಕ್‌ಲ್ಯಾಲಿ ತಿ ಲೊಕ ಸಗ್ಳಿ ಯಾಕ್ ಯಾಕುಸ್ ಜಾಂತಬಿ ತಿಥ್ನಿ ನಿಗುನ್ ಗಿಲಿತ. ಮಂಗ್ ತಿಥ ರಾಯ್‌ಲ್ಯಾಲಾ ಯೇಸು ತ್ಯವ್ಡಾಸ್. ಆನಿ ತಿ ಬಾಯಿಲ್ ಮಾನುಸ್ ತ್ಯಚೆ ಮೊರ‍್ಹ ಉಬಿ ರಾಯ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","ಯೇಸು ಉಬಾರಾಹುನ್, “ಬಾಯಿ, ತೆ ಸಗ್ಳ ಕುಠ ಹಾತ್ತ? ತುಜಿವ ಚು಼ಕ್ ದಿಯಾ ಕೊನುಸ್ ರಾಯ್ಲ ನಾಹಿತ ಕ್ಯಾ? ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","ತಿ ಬಾಯಿಲ್ ಮಾನುಸ್, “ಕೊನ್ ರಾಯ್ಲ ನಾಹಿತ ಪ್ರಭು” ಮನ್ಲಿ. ಯೇಸು ತಿಲಾ, “ಮನ್ಹುನ್ ಮಿ ಬಿ ತುಜಿವ ಚು಼ಕ್ ವಾವಿತ್ ನಾಹಿ. ಆತಾ ತು ಜಾ಼, ಫನ್ ಹಿತ್ನಿ ಮೊರ‍್ಹ ಪಾಪ್ ಕರುನಕೊಸ್” ಮನ್ಹುನ್ ಖಡ್ಯಾವ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","ಮಂಗ್, ಯೇಸು ಲೊಕಾಂಚೆ ಸಂಗ ಬೊಲತ್, “ಮೀಸ್ ದುನೆಲಾ ಉಜಿಡ್ ಜಾ಼ಲ್ಯೊ. ಮಾಜೆ ಮಾಗ್ನಿ ಯನಾರಾ ಆಂದಾರಾತ್ ಕಂದಿಸ್ ಜಿವ್ನಾ ಕರೀತ್ ನಾಹಿ. ತ್ಯೊ ಜೀವ್ ದೆತ್ಯಾಲಾ ಉಜಿಡ್ ಗೆತಲ್ಯಾಲಾ ವ್ಹನಾರ್” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","ಫರಿಸಾಯ್ ಯೇಸುಲಾ, “ತುಲಾ ತುಸ್ ಸಾಕ್ಶಿ ದೆತ್ಯೊಸ್ ತುಜಿ ಸಾಕ್ಷಿ ಕಿಮ್ತಿಚಿ ನವ್ಹ ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","ತವಾ ಯೇಸು, “ಮಿ ಮಾಜಿ ಸ್ವತಾಚಿ ಸಾಕ್ಷಿ ಸಾಂಗ್ಲಿ ತರಿ ತಿಲಾ ಕಿಮ್ಮತ್ ಹಾ. ಮಿ ಕುಟ್ನಿ ಆಲ್ಯೊ ಆನಿ ಕುಠ ಜಾ಼ನಾರ್ ಮನ್ಹುನ್ ಮನಾ ಠಾವ ಹಾ. ಫನ್ ಹ್ಯ ತುಮಾನಾ ಠಾವ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","ತುಮಿ ಮಾನ್ಸಾಚೆಗತ್ ನ್ಯಾಯಿ ತಿರ್ಮಾನ್ ಕರ್ತಾಸಾ. ಫನ್ ಮಿ ಕುನಾಚಾ಼ ನ್ಯಾಯಿ ತಿರ್ಮಾನ್ ಕರೀತ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","ಮಿ ಕರ್ತ್ಯಾಲಾ ನ್ಯಾಯಿ ತಿರ್ಮಾನ್ ಶಾರ್ಕಾ ರಾಥೊ. ಕಾ ಮಂಜೆ ಮಿ ಯಕ್ಲಾ ನಾಹಿ ಮನಾ ಲಾವುನ್ ದಿಲ್ಯಾಲಾ ಬಾ ಮಾಜೆ ಸಂಗ ರಾಥೊ. ");
INSERT INTO gok_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","ದೊಗಾಂಚಿ ಸಾಕ್ಷಿಲಾ ಕಿಮ್ಮತ್ ಹಾ ಮನ್ಹುನ್ ತುಮ್ಚಾ ಧರ್ಮಶಾಸ್ತಾರಾತ್ ಲಿವ್‍ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","ಮಾಜಾ ಸಾಂಗ್‌ನ್ಯಾಲಾ ಮಿ ಯೇಕ್ ಸಾಕ್ಶಿ ಜಾ಼ಲ್ಯೊ, ಮನಾ ಲಾವುನ್ ದಿಲ್ಯಾಲಾ ಬಾಬಿ ಮಾಜಿ ಆನಿ ಯೇಕ್ ಸಾಕ್ಶಿ ಜಾ಼ಲ್ಯಾ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","ತವಾ ತ್ಯಂಚಾನಿ, “ತುಜಾ಼ ಬಾ ಕುಠ ಹಾ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ತವಾ ಯೇಸು ತ್ಯನಾ, “ತುಮಾನಾ ಮಿ ವ್ಹವುನಿ, ಮಾಜಾ಼ ಬಾ ವ್ಹವುನಿ ಠಾವಾ ನಾಹಿ. ಮಿ ತುಮಾನಾ ಠಾವಾ ಆಸ್ಲೊತ, ಮಾಜಾ಼ ಬಾಬಿ ಠಾವಾ ಆಸತಾ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","ತ್ಯೊ ದೇವ್ಳಾತ್ ಲೊಕ ದಿನ್ಗಿ ಗ್ಯಾಲತ್ಯಾಲ್ಯಾ ಜಾ಼ಗ್ಯಾಪ ಉಬಾ ರಾಹುನ್ ಸಿಕಿವ್ತಾನಾ ಹ್ಯಾ ಬೊಲ್ಯಾ ಸಾಂಗ್‌ಲ್ಯಾ. ಫನ್ ಕುನಿ ತ್ಯಲಾ ಕ್ಯೊಂಡ್ಲಾ ನಾಹಿ, ಕಾ ಮಂಜೆ ಆಜು಼ನ್ ತ್ಯಚಾ಼ ಯೊಳ್ ಆಲಾ ನವ್ಥಾ. ");
INSERT INTO gok_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","ಯೇಸುನಿ ಆನಿಕ್ ಸಾಂಗ್ಲ, “ಮಿ ಜಾ಼ತ್ಯೊ. ತುಮಿ ಮನಾ ಶೊದ್ನಾರ್. ಫನ್ ತುಮಿ ತುಮ್ಚಾ ಪಾಪಾತ್ನಿಸ್ ಮರ್ನಾರ್. ಮಿ ಜಾ಼ನಾರ್ ತಿಥ ತುಮಿ ಯನಾರ್ ನಾಹಿಸಾ. ” ");
INSERT INTO gok_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","ಹಿ ಬುಲಿ ಯೆಹುದ್ಯಾನಾ, “ತ್ಯೊ ಆಪ್‌ಲ್ಯಾಲಾಸ್ ಆಪ್ನು ಖುನ್ ಕರುನ್ ಗೆನಾರ್ ಕ್ಯಾ? ಮನ್ಹುನ್, ಮಿ ಜಾ಼ನಾರ್ ತಿಥ ತುಮಾನಾ ಯಯಾ ವ್ಹಯಿತ್ ನಾಹಿ ಮನ್ಹುನ್ ಸಾಂಗ್‌ತ್ಯೊ ಕ್ಯಾ? ಮನ್ಹುನ್ ಆಪ್‍ಲ್ಯಾ ಆಪ್‌ಲ್ಯಾಲಾತ್ ಇಚಾರ್ ಕೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","ಫನ್ ಯೇಸುನಿ, “ತುಮಿ ಖಾಯ್ಲ ಹಾಸಾ. ಮಿ ವೈಲಾ. ತುಮಿ ಹೆ ದುನೆತ್ಲಿ ಹಾಸಾ. ಫನ್ ಮಿ ಹೆ ದುನೆತ್ಲಾ ನವ್ಹ. ");
INSERT INTO gok_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","ತ್ಯಚಿ ಸಾಟಿ ಮಿ ತುಮಾನಾ ಸಾಂಗ್‌ಲ್ಯಾ ತುಮಿ ತುಮ್ಚಾ ಪಾಪಾತ್ನಿಸ್ ಮರ್ನಾರ್ ಮಿ ಕೊನ್ ಜಾ಼ಲ್ಯೊ ತ್ಯೊ ತುಮಿ ಸಮಜು಼ನ್ ಇಸ್ವಾಸ್ ಥೆವ್ಲಾ ನಾಹಿಸಾತ ತುಮಿ ತುಮ್ಚಾ ಪಾಪಾತುಸ್ ಮರ್ನಾರ್” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","ತವಾ ತ್ಯಂಚಾನಿ, “ತು ಕೊನ್? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. “ಮಿ ಕೊನ್ ಮನ್ಹುನ್ ತುಮಾನಾ ಆಂದಿ ದರ್ನಿ ಸಾಂಗಿತ್ ಆಲ್ಯೊ, ತ್ಯೊಸ್ ಮಿ. ");
INSERT INTO gok_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","ತುಮಚಾ಼ ನ್ಯಾಯಿ ತಿರ್ಮಾನ್ ಕರಾಯಾ ಮಾಜಿಪ ಖುಬ್ ಹಾ. ಫನ್ ಮನಾ ಲಾವುನ್ ದಿಲ್ಯಾಲಾ ಖರಾ, ಆನಿ ಮಿ ತ್ಯಚಿಪ್ನಿ ಕ್ಯಾ ಐಕ್‌ಲ್ಯಾ ತ್ಯಸ್ ಲೊಕಾನಾ ಸಾಂಗ್ತೊ. ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","ಯೇಸು ಆಪ್ಲೆ ಬಾಚೆ ಗುಶ್ಟಿತ್ ಸಾಂಗ್‌ತ್ಯೊ ಮನ್ಹುನ್ ತ್ಯನಾ ಸಮಾಜ಼್ಲ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","ಮನ್ಹುನ್ ಯೇಸುನಿ ತ್ಯನಾ, “ಕವಾ ತುಮಿ ಮಾನ್ಸಾಚಾ ಲೇಕಾಲಾ ವರ್ ಚ಼ಡಿವ್ತಾಸಾ, ತವಾ ತ್ಯೊ ಮೀಸ್ ಮನ್ಹುನ್ ತುಮಾನಾ ಸಮಾಜ್ನಾ಼ರ್. ತವಾ ಮಿ ಕರ್ತ್ಯಾಲ ಮಾಜಾ ಮನಾನಿ ನವ್ಹ ಮಾಜಾ ಬಾನಿ ಸಾಂಗ್‌ಲ್ಯಾಚೆಗತ್ ಸಿಕಿವ್‌ತ್ಯೊ. ");
INSERT INTO gok_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","ಮನಾ ಲಾವುನ್ ದಿಲ್ಯಾಲಾ ಮಾಜಿ ಸಂಗ ಹಾ. ತ್ಯನಿ ಮನಾ ಯಕ್‌ಲ್ಯಾಲಾಸ್ ಶೊಡ್ಲಾ ನಾಹಿ. ತ್ಯಚಿ ಸಾಟಿ ಮಿ ಕವಾಬಿ ತ್ಯಲಾ ಆವ್ಡಜೊ಼ಗ ಕರ್ತೊ. ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","ಯೇಸು ಹ್ಯಾ ಖನ್ಕತಿ ಸಾಂಗ್ತಾನಾ, ಖುಬ್ ಲೊಕಾಂಚಾನಿ ತ್ಯಚಿವ ಇಸ್ವಾಸ್ ಥೆವ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","ಮನ್ಹುನ್ ಯೇಸುನಿ ಆಪ್ಲಿವ ಇಸ್ವಾಸ್ ಥೆವ್‍ಲ್ಯಾಲ್ಯಾ ಯೆಹುದ್ಯಾನಾ, “ತುಮಿ ಮಾಜಾ ಸಿಕಿವ್‍ನ್ಯಾ ಶಾರ್ಕ ಹಾಸಾ ಮನ್ಹುನ್, ತುಮಿ ಖರ‍್ಯಾನಿಸ್ ಮಾಜೆ ಮಾಗ್ನಿ ಯತ್ಯಾಲ ಶಿಶಾ ಜಾಲ್ಯಾಸಾ. ");
INSERT INTO gok_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","ತುಮಿ ಖರ ಸಮಜು಼ನ್ ಗೆನಾರ್. ತ್ಯ ಖರ ತುಮಾನಾ ಸ್ವತಂತ್ರ ದೇನಾರ್” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","ತವಾ ತ್ಯಂಚಾನಿ, “ಆಮಿ ಅಬ್ರಹಾಮಾಚಿ ಪಿಳ್ಗಿತ್ಲಿ. ಆಮಿ ಕಂದಿ ಕುನಾಚ಼ ಗುಲಾಮ್ ಜಾ಼ಲಾ ನವ್ಥಾವ್. ಆಸ ಆಸ್ಥಾನಾ, ಆಮಾನಾ ಸ್ವತಂತ್ರ ಗಾವ್ನಾರ್ ಮನ್ಹುನ್ ತು ಸಾಂಗಾಚ಼ ಕ್ಯಾ? ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","ಯೇಸುನಿ, “ಮಿ ತುಮಾನಾ ಖರ ಸಾಂಗ್ತೊ. ಪಾಪ್ ಕರ್ತ್ಯಾಲಾ ಪರತೇಕ್ ಯೊಕ್ ಪಾಪಾಚಾ಼ ಗುಲಾಮ್ ಜಾ಼ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","ಗುಲಾಮ್ ಗರ‍್ಹಾತ್ ಶಾಶ್ವತ್ ರಾಹಿತ್ ನಾಹಿ. ಫನ್ ಲ್ಯೊಕ್ ಶಾಶ್ವತ್ ರಾಥೊ. ");
INSERT INTO gok_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","ಮನ್ಹುನ್ ಲೆಕಾನಿ ತುಮಾನಾ ಸ್ವತಂತ್ರ ಕೆಲ್ಯಾವ, ತುಮಿ ಖರ‍್ಯಾನಿಸ್ ಸ್ವತಂತ್ರ ವ್ಹನಾರ್. ");
INSERT INTO gok_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","ತುಮಿ ಅಬ್ರಹಾಮಾಚಿ ಪಿಳ್ಗಿತ್ಲಿ ಮನ್ಹುನ್ ಮನಾ ಠಾವಿ ಹಾಸಾ. ಫನ್ ತುಮಿ ಮನಾ ಮಾರುನ್ ಟಾಕಾಯಾ ವ್ಹಯಿ ಮಂಥಾಸಾ. ಕಾ ಮಂಜೆ ಮಿ ಸಾಂಗ್‌ಲ್ಯಾಲ ವ್ಹಯ್ ಮನಿತ್ ನಾಹಿಸಾ. ");
INSERT INTO gok_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","ಮಾಜಾ ಬಾನಿ ಮನಾ ದ್ಯಾವ್‍ಲ್ಯಾಲ ಮಿ ತುಮಾನಾ ಸಾಂಗ್ತೊ. ತುಮಿ ತರಿ ತುಮ್ಚಾ ಬಾನಿ ಸಾಂಗ್‍ಲ್ಯಾಲಿ ಕಾಮ ಕರ್ತ್ಯಾಸಾ” ಮನ್ಹುನ್ ಸಾಂಗ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","ತೆ, “ಅಬ್ರಹಾಮುಸ್ ಆಮಚಾ಼ ಬಾ” ಮನ್ಲ. ಯೇಸುನಿ, “ತುಮಿ ಖರ್‍ಯಾನಿಸ್ ಅಬ್ರಹಾಮಾಚಿ ಪಿಳ್ಗಿ ಜಾ಼ಲ್ಯಾಸಾತ, ಅಬ್ರಹಾಮಾನಿ ಕೆಲ್ಯಾಚೆಗತ್ ಕರೀತಾಸಾ. ");
INSERT INTO gok_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","ದೇವಾಪ್ನಿ ಐಕ್‌ಲ್ಯಾಲ ಖರ ತುಮಾನಾ ಸಾಂಗ್‌ತ್ಯಾಲಾ ಮಾನುಸ್ ಮಿ ಜಾ಼ಲ್ಯೊ ಫನ್ ತುಮಿ ಮಾರುನ್ ಟಾಕಾಯಾ ಬಗ್‌ತ್ಯಾಸಾ. ಅಬ್ರಹಾಮಾನಿ ತಸ್ಲ ಕಾಯೇಕ್ ಕೆಲ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","ಮನ್ಹುನ್ ತುಮ್ಚಾ ಸ್ವತಾಚಾ ಬಾನಿ ಕೆಲ್ಯಾಲಸ್ ತುಮಿ ಕರ್ತ್ಯಾಸಾ” ಮನ್ಲಾ. ಫನ್ ತೇ ಯೇಸುಲಾ ಮನ್ಲ, “ಆಮಿ ವೆಬಿಚಾರಾನಿ ಜ಼ಲಾಮ್ಲಾವ್ ನಾಹಿ. ಆಮಚಾ಼ ಯೊಕುಸ್ ಬಾ ಆನಿ ತ್ಯೊಸ್ ದೇವ್ ಜಾ಼ಲ್ಯಾ ಆನಿ ಆಮಿ ತ್ಯಚಿ ಪೊರ ಜಾ಼ಲ್ಯಾವ್. ");
INSERT INTO gok_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","ಯೇಸುನಿ ತ್ಯಾ ಯೆಹುದ್ಯಾನಾ, “ದೇವ್ ಖರ‍್ಯಾನಿಸ್ ತುಮಚಾ಼ ಬಾ ಆಸ್‍ಲ್ಯಾವ, ತುಮಿ ಮಾಜಿ ಮಾಯಾ ಕರೀತಾಸಾ. ಕಾ ಮಂಜೆ ಮಿ ದೇವಾಪ್ನಿ ಆಲ್ಯೊ ಆನಿ ಮಿ ಹಿತ್ತ ಹಾ. ಮಿ ಆಲ್ಯಾಲೊ ಮಾಜಾ ಸ್ವತಾಚಾ ಹುಕ್ಮಾನಿ ನವ್ಹ. ದೇವಾನಿಸ್ ಮನಾ ಲಾವುನ್ ದಿಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","ಮಿ ಸಾಂಗ್‌ತ್ಯಾಲ್ಯಾ ಖನ್ಕತಿ ತುಮಿ ಸಮಜು಼ನ್ ಗಿಹಿತ್ ನಾಹಿಸಾ ಕಾ? ಕಾ ಮಂಜೆ ಮಿ ಸಾಂಗ್‌ತ್ಯಾಲ ತುಮಾನಾ ಸುಸ್ವುನ್ ಗಿಹ್ಯಾ ವ್ಹಯಿತ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","ಸೈತಾನುಸ್ ತುಮಚಾ಼ ಬಾ. ತುಮಿ ತ್ಯಚಿ ಪೊರ. ಆನಿ ತುಮಿ ತುಮ್ಚಾ ಮನಾ ಶಾರ್ಕ ಕರಾಯಾ ಬಗ್ತಾಸಾ. ತ್ಯೊ ಆಂದಿ ದರ್ನಿ ಖುನ್ಸಿ ವ್ಹವುನ್ ಖರ‍್ಯಾಲಾ ಆಡ್ವಾ ಹಾ. ತ್ಯಚಿಪ ಖರ ನಾಹಿಸ್ ನಾಹಿ.ತ್ಯಚಾ಼ ಸಬಾವುಸ್ ಲಬಾಡ್ ಬೊಲಾಚಾ಼. ತ್ಯೊ ಲಬ್ಡಾ ಲಬ್‍ಡ್ಯಾಚಾ಼ ಬಾಪ್ ಜಾ಼ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","ಫನ್ “ಮಿ ಖರ ಸಾಂಗ್ತೊ. ಮನ್ಹುನ್ ತುಮಿ ಮಾಜಿವ ಇಸ್ವಾಸ್ ಥಿವಿತ್ ನಾಹಿಸಾ. ");
INSERT INTO gok_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","ಮಾಜಿಪ ಪಾಪ್ ದಾವುನ್ ದೆತ್ಯಾಲಾ ತುಮ್ಚಾತ್ ಕೊನ್‌ತರಿ ಹಾ ಕ್ಯಾ? ಮಿ ಖರ ಸಾಂಗ್ಲ ತರಿ ತುಮಿ ಕಾ ಖರ ದರಿತ್ ನಾಹಿಸಾ? ");
INSERT INTO gok_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","ದೇವಾಪ್ನಿ ಜ಼ಲಾಮ್‌ಲ್ಯಾಲಾ ದೇವಾನಿ ಸಾಂಗ್‍ಲ್ಯಾಲ ಸಬ್ದ ಐಕ್ತೊ. ಫನ್ ದೇವಾಪ್ನಿ ಜ಼ಲಾಮ್ಲಾ ನಾಹಿ ಮನ್ಹುನ್ ತ್ಯಚ ಸಬಾತ್ ಐಕಿತ್ನಾಹಿಸಾ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","ಯೆಹುದಿಂಚಾನಿ ಆಸಾ ಉತ್ತರ್ ದಿಲಾ, “ಆಮಿ ಸಾಂಗ್‌ಲ್ಯಾಲ ಖರ ನವ್ಹ ಕ್ಯಾ ತು ಸಮಾರ‍್ಯಾಚಾ಼ ಮನ್ಹುನ್! ತುಲಾ ಲಾಗಿರ್ ಲಾಗ್‌ಲ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","ಯೇಸು ಮನ್ಲಾ, “ಮನಾ ಲಾಗಿರ್ ಲಾಗ್ಲ ನಾಹಿ. ಮಿ ಮಾಜಾ ಬಾಲಾ ಮರ‍್ಯಾದ್ ದೆತೋ, ಫನ್ ತುಮಿ ಮನಾ ಮರ‍್ಯಾದ್ ದಿಯಿತ್ನಾಹಿಸಾ. ");
INSERT INTO gok_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","ಮನಾ ಮರ‍್ಯಾದ್ ಗಿಹ್ಯಾ ಮಿ ಖಟಪಟ ಕರೀತ್ನಾಹಿ. ಮನಾ ಮರ‍್ಯಾದ್ ಗಾವಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಮನ್ ಕರ್ತ್ಯಾಲಾ ಯಕ್ಲಾ ಹಾ. ತ್ಯೊಸ್ ನ್ಯಾಯಿ ತಿರ್ಮಾನ್ ಕರ್ತ್ಯಾಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","ಮಿ ತುಮಾನಾ ಖರ ಸಾಂಗ್ತೊ. ಮಿ ಸಿಕಿವ್‌ಲ್ಯಾಚೆಗತ್ ಚಾ಼ಲತ್ಯಾಲಾ ಕಂದಿಸ್ ಮರ್ನಾರ್ ನಾಹಿ. ” ");
INSERT INTO gok_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","ಯೆಹುದಿ ತ್ಯಲಾ, “ತುಜಿಪ ಖರ‍್ಯಾನಿಸ್ ಲಾಗಿರ್ ಹಾ ಮನ್ಹುನ್ ಆತಾ ಆಮಾನಾ ಸಮಾಜ಼್ಲ! ಅಬ್ರಹಾಮ್ ಆನಿ ಪ್ರವಾದಿ ಸಾಹಿತ್ ಮೆಲ. ಫನ್ ‘ಮಾಜಾ ಸಿಕಿವ್‌ನ್ಯಾ ಶಾರ್ಕ ಚಾ಼ಲ್ನಾರಾ ಕಂದಿಸ್ ಮರತ್ ನಾಹಿ’ ಮನ್ಹುನ್ ತು ಸಾಂಗ್‌ತ್ಯೊಸ್ ನವ್ಹ. ");
INSERT INTO gok_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","ಅಮಚಾ಼ ಬಾ ಅಬ್ರಹಾಮಾವ್ನಿ ತು ಮೊಟಾ ಮನ್ಹುನ್ ಸಮಜು಼ನ್ ಗೆತ್ಯೊಸ್ ಕ್ಯಾ? ಅಬ್ರಹಾಮ್ ಮೆಲಾ ಆನಿ ಪ್ರವಾದಿಬಿ ಮೆಲ. ಆಸ ಆಸ್ಥಾನಾ, ತು ತುಲಾ ಕೊನ್ ಮನ್ಹುನ್ ಸಮಜು಼ನ್ ಗೆತ್ಯೊಸ್? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","ಯೇಸುನಿ ಉತ್ತರ್ ದಿಲಾ, “ಮನಾ ಮೀಸ್ ಮೈಮಾ ಕಿಲಿತ, ತೇ ಮೈಮಾಲಾ ಕಾಯ್ ಕಿಮತ್ ನಾಹಿ. ಮಾಜಾ಼ ಬಾಸ್ ಮನಾ ಮೈಮಾ ದೇನಾರ್. ಕುನಾಲಾ ತುಮಿ ತುಮಚಾ಼ ಬಾ ಮಂಥಾಸಾ. ");
INSERT INTO gok_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","ತುಮಿ ತ್ಯಲಾ ಕಂದಿಸ್ ವಳಕ್ಲಾ ನಾಹಿಸಾ. ಫನ್ ಮನಾ ತ್ಯೊ ಠಾವಾ ಹಾ. ಮನಾ ತ್ಯೊ ಠಾವಾ ನಾಹಿ ಮನ್‌ಲ್ಯಾವ ತುಮ್ಚಿಗತ್ ಮಿ ಲಬಾಡ್ ವ್ಹನಾರ್. ಮನಾ ತ್ಯೊ ಠಾವಾ ಹಾ. ಮಿ ತ್ಯಚಾ ಸಬ್ದಾ ಶಾರ್ಕಾ ಚಾ಼ಲ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","ಮಿ ಯಯಾಚಾ಼ ದಿಸ್ ಆಪ್ನು ಬಗ್ನಾರ್ ಮನ್ಹುನ್ ತುಮ್ಚಾ ಬಾ ಅಬ್ರಹಾಮಾಲಾ ಖುಬ್ ಸಂತೊಸ್ ಹುತ್ತಾ. ತ್ಯನಿ ತ್ಯೊ ದಿಸ್ ಬಗ್ಲಾ ಆನಿ ಖುಬ್ ಸಂತೊಸ್ ಜಾ಼ಲಾ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","ಯೆಹುದ್ಯಾಂಚಾನಿ ತ್ಯಲಾ ಸಾಂಗ್ಲ, “ತುಲಾ ಆಜು಼ನ್ ಪನ್ನಾಸ್ ವರ್ಸಬಿ ಜಾ಼ಲಿ ನಾಹಿತ! ಆನಿ ತು ಅಬ್ರಹಾಮಾಲಾ ಬಗ್‌ಲ್ಯಾಸ್ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","ಯೇಸುನಿ ಉತ್ತರ್ ದಿಲಾ, “ಮಿ ತುಮಾನಾ ಖರ ಸಾಂಗ್ತೊ. ಅಬ್ರಹಾಮ್ ಜ಼ಲ್ಮಾಚೆ ಆಂದಿ ದರ್ನಿ ಮಿ ಹಾ!” ");
INSERT INTO gok_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","ಹ್ಯ ಐಕ್‌ಲ್ಯಾ ಬರ್ಬರ್ ಲೊಕಾಂಚಾನಿ ತ್ಯಚಿವ ಮಾರಾಯಾ ದೊಂಢ ಗೆತ್ಲ. ಫನ್ ಯೇಸು ದೇವ್ಳಾತ್ನಿ ಬಾಹಿರ್ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","ಯೇಸು ಚಾ಼ಲತ್ ಜಾ಼ತಾನಾ ಯೊಕ್ ಜ಼ಲ್ಮತ್ ಆಂದ್ಳಾ ದಿಸ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","ಯೇಸುಚ಼ ಶಿಶಾ, “ಗುರು ಹ್ಯೊ ಮಾನುಸ್ ಆಂದ್ಳಾ ವ್ಹವುನ್ ಜ಼ಲ್ಮಾಯಾ ಕುನಾಚ಼ ಪಾಪ್ ಕಾರನ್? ತ್ಯಚ಼ ಸ್ವತಾಚ಼ ಪಾಪ್ ಕ್ಯಾ? ತ್ಯಚೆ ಆಯಿ ಬಾಚ಼ ಪಾಪ್” ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","ಯೇಸುನಿ ಆಸ ಸಾಂಗ್ಲ, “ತ್ಯಚ಼ ಪಾಪ್ ವ್ಹವುನಿ ತ್ಯಚೆ ಆಯಿ ಬಾಚ಼ ಪಾಪ್ ವ್ಹವುನಿ ಹ್ಯಲಾ ಕಾರನ್ ನವ್ಹ. ದೇವಾಚ಼ ಕಾಮ್ ತ್ಯಚಿಪ ದಿಸುನ್ ಯಯಾ ಆಸ ಜಾ಼ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","ಮನಾ ಲಾವುನ್ ದಿಲ್ಯಾಲ್ಯಾಚ಼ ಕಾಮ್ ಆಮಿ ದಿಸಚ಼ ಕರಾಯಾ ವ್ಹಯಿ. ರ‍್ಯಾತ್ ಆಲಿಕಿ. ಕುನಾಲಾ ಕಾಮ್ ಕರಾಯಾ ವ್ಹಯಿತ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","ಮಿ ಹೆ ದುನೆತ್ ಆಸ್ಥಾನಾ, ಮಿಸ್ ಹೆ ದುನೆಲಾ ಉಜಿಡ್ ಜಾ಼ಲ್ಯೊ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","ಯೇಸುನಿ ಹ್ಯೊ ಸಬೊತ್ ಸಾಂಗಲ್ಯಾ ನಂತರ್ ಜಿಮ್ನಿವ ಥುಕುನ್ ತ್ಯನಿ ಚಿಖುಲ್ ಕರುನ್ ಗಿವುನ್ ತ್ಯಾ ಮಾನ್ಸಾಚಾ ಡೊಳ್ಯಾನಾ ಲ್ಯಾವ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ಯೇಸುನಿ ತ್ಯಾ ಮಾನ್ಸಾಲಾ, “ಜಾ಼ವುನ್ ಸಿಲೊವಾ ತಳ್ಯಾತ್ ಧು” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ಸಿಲೊವಾ ಮಂಜೆ, “ಲಾವುನ್ ದಿಲ್ಯಾಲಾ. ” ತಸಸ್ ತ್ಯನಿ ಜಾ಼ವುನ್ ದುತ್ಲ. ಆನಿ ಮಾಗಾರ ಯತಾನಾ ಡೊಳ್ಯಾಂಚಾನಿ ದಿಸಾಯಾ ಲಾಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","ತ್ಯಚಾ಼ ಸೆಜಾರಿ ಆನಿ ತ್ಯೊ ಭಿಕ್ ಮಾಗ್‌ತ್ಯಾಲ ಬಗ್‌ತ್ಯಾಲ್ಯಾ ಲೊಕಾಂಚಾನಿ, “ಖಾಯಿಮ್ ಭಿಕ್ ಮಾಗಿತ್ ಬಸ್‍ಲ್ಯಾಲಾ ಹ್ಯೊಸ್ ನವ್ಹ” ಮನ್ಹುನ್ ಇಚಾರ್ ಕೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","ಥುಡಿ ಲೊಕ, “ವ್ಹಯ್ ತ್ಯೊಸ್” ಮನ್ಲಿತ. ಆನಿ ಥುಡಿ, “ನಾಹಿ, ಹ್ಯೊ ತ್ಯೊ ಮಾನುಸ್ ನವ್ಹ. ಹ್ಯೊ ತ್ಯಚಿ ಗತ್ ಹಾ ತ್ಯವ್ಡಾಸ್” ಮನ್ಲಿತ. ತ್ಯಲಾ ತ್ಯೊ ಮಾನುಸ್, “ಮಿಸ್ ತ್ಯೊ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","ಲೊಕಾಚಾಂನಿ ಇಚಾರ್ಲ, “ತುಲಾ ನದಾರ್ ಕಸಿ ಆಲಿ? ");
INSERT INTO gok_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","ತ್ಯಾ ಮಾನ್ಸಾನಿ, “ಯೇಸು ಮಂತ್ಯಾಲ್ಯಾನಿ ಥೊಡಾ ಚಿಖುಲ್ ಕರುನ್ ಮಾಜಾ ಡೊಳ್ಯಾನಾ ಲಾವುನ್, ಸಿಲೊವಾ ತಳ್ಯಾತ್ ಜಾ಼ವುನ್ ಮನಾ ದುಯಾ ಸಾಂಗ್ಲ. ತಸಸ್ ಮಿ ದುತ್ಲ. ಆತಾ ಮನಾ ಡೊಂಳ್ಯಾಂಚಾನಿ ದಿಸತ್ಯಾ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","ಲೊಕಾಚಾಂನಿ ತ್ಯಲಾ, “ತ್ಯೊ ಮಾನುಸ್ ಕುಠ ಹಾ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ತವಾ ತ್ಯನಿ, “ಮನಾ ಠಾವಾನಾಹಿ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","ಮಂಗ್ ಲೊಕಾಚಾಂನಿ ತ್ಯಾ ಮಾನ್ಸಾಲಾ ಫರಿಸಾಯಾಂಚಿಪ ಆನ್ಲಾ. ಆಂದಿ ಅಂದ್ಳಾ ಹುತ್ತಾ ತ್ಯೊ ಮಾನುಸ್ ಹ್ಯೊಸ್, ");
INSERT INTO gok_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","ಯೇಸುನಿ ಚಿಖುಲ್ ಕರುನ್ ತ್ಯಚ಼ ಡೊಳ ಬರ ಕೆಲ. ಯೇಸುನಿ ಹ್ಯ ಕಾಮ್ ಕೆಲ್ಯಾಲ ಸಬ್ಬತ್ ದಿಸಾದಿಸಿ. ");
INSERT INTO gok_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","ತವಾ ಫರಿಸಾಯಾಂಚಾನಿ ಆನಿ ಯಂಗ್ದಾ ಇಚಾರ್ಲ, “ತುಲಾ ನದಾರ್ ಕಸಿ ಆಲಿ? ತ್ಯಾ ಮಾನ್ಸಾನಿ ಸಾಂಗ್ಲ, “ತ್ಯನಿ ಮಾಜಾ ಡೊಳ್ಯಾನಾ ಚಿಖುಲ್ ಲ್ಯಾವ್ಲಾ. ಮಿ ದುತ್ಲ. ಆತಾ ಮನಾ ಡೊಳ್ಯಾನಿ ದಿಸ್ತ. ” ");
INSERT INTO gok_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","ಫರಿಸಾಯಾತ್‌ಲ್ಯಾ ಥೊಡ್ಯಾಂಚಾನಿ, “ಹ್ಯೊ ಮಾನುಸ್ ದೇವಾಪ್ನಿ ಆಲ್ಯಾಲಾ ನವ್ಹ ಕಾ ಮಂಜೆ ಹ್ಯೊ ಸಬ್ಬತ್ ದಿಸ್ ಪಾಳಿತ್ ನಾಹಿ. ” ಮನ್ಲ. ತ್ಯಲಾ ದುಸ್ರ ಮನ್ಲ, “ಕಚಾ಼ ಪಾಪಿ ಮಾನುಸ್ ಆಸ್ಲಿ ಚಾ಼oಗ್ಲಿ ಕಾಮ ಕರಾಯಾ ಕಸ ವ್ಹನಾರ್? ಆಸಾ ತ್ಯಂಚೆ ಮದ್ದಿ ಬೆದ್ ಭಾವ್ ಜಾ಼ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","ಪರಿಸಾಯಾಂಚಾನಿ ನದಾರ್ ಆಲ್ಯಾಲ್ಯಾ ತ್ಯಾ ಮಾನ್ಸಾಲಾ ಪರತ್ ಆನಿ ಯಂಗ್ದಾ ಇಚಾರ್ಲ, “ಕಚಾನಿ ತುಲಾ ನದಾರ್ ದಿಲಿ ತ್ಯಾ ಮಾನ್ಸಾಚೆ ಗುಶ್ಟಿತ್ ತು ಕ್ಯಾ ಸಾಂಗ್ತೊಸ್? ತವಾ ತ್ಯನಿ ಸಾಂಗ್ಲ, “ತ್ಯೊ ಯೊಕ್ ಪ್ರವಾದಿ” ಮನ್ಹುನ್. ");
INSERT INTO gok_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","ಹ್ಯೊ ಮಾನುಸ್ ಆಂದಿ ಆಂದ್ಳಾ ಜಾ಼ಲ್ತಾ. ಫನ್ ಆತಾ ಹ್ಯಲಾ ದಿಸತ್ಯಾ ಮನ್ಹುನ್ ಯೆಹುದಿ ಅಧಿಕಾರಿಂಚಾನಿ ತ್ಯಚೆ ಆಯಿ ಬಾಲಾ ಹಾಕ್ಟುನ್ ಆನಿಸ್ ಪರ‍್ಯಾತ್ ತ್ಯಚಿವ ಇಸ್ವಾಸ್ ಥೆವ್ಲಾ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ತ್ಯಂಚಾನಿ ತ್ಯಚೆ ಆಯಿ ಬಾಲಾ, “ಹ್ಯೊ ತುಮಚಾ಼ ಲ್ಯೊಕ್ ಕ್ಯಾ? ಹ್ಯೊ ಜ಼ಲಮತ್ ಆಂದ್ಳಾ ಹುತ್ತಾ ಮನ್ಹುನ್ ತುಮಿ ಸಾಂಗತಾಸಾ. ತಸ ಜಾ಼ಲತ ಹ್ಯಲಾ ಆತಾ ಹ್ಯಚಾ ಡೊಳ್ಯಾಚಾಂನಿ ಕಸ ದಿಸತ್ಯಾ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","ಆಯಿ ಬಾನಿ, “ಹ್ಯೊ ಆಮಚಾ಼ ಲ್ಯೊಕ್ ಮನ್ಹುನ್ ಆಮಾನಾ ಠಾವಾ ಹಾ. ಆನಿ ಹ್ಯೊ ಜ಼ಲಮತ್ ಆಂದ್ಳಾ ಮನ್ಹುನ್ ಆಮಾನಾ ಠಾವಾ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","ಫನ್ ಆತಾ ತ್ಯಲಾ ಕಸ ಡೊಳ್ಯಾಚಾಂನಿ ದಿಸತ್ಯಾ. ಕುನಿ ತ್ಯಚಾ ಡೊಳ್ಯಾನಾ ಚಿಖುಲ್ ಲಾವುನ್ ನದಾರ್ ದಿಲೆ. ಆಮಾನಾ ಠಾವ ನಾಹಿ. ತ್ಯಲಾಸ್ ಇಚಾರಾ. ತ್ಯೊ ಆಪ್ಲೆ ಆಪ್ನುಸ್ ಸಾಂಗಿ ಜೊಗಾ ಮೊಟಾ ಜಾ಼ಲ್ಯಾ” ಮನ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","ತ್ಯಚೆ ಆಯಿ ಬಾನಿ ಯೆಹುದಿ ಜಾಂತ್ಯಾನಾ ಭಿವುನ್ ತಸ ಸಾಂಗ್ಲ. ಕಾ ಮಂಜೆ ತ್ಯಂಚಾನಿ ಆಂದಿ ನಿರ್ದಾರ್ ಕೆಲ್ತಾ ಕುನಿ ತರಿ ಯೇಸುಲಾ ಕ್ರಿಸ್ತ ಮನ್ಹುನ್ ಸಾಂಗ್ಲತ ತ್ಯಲಾ ಯೆಹುದ್ಯಾಂಚಾ ಸಬಾಸ್ತಾನಾತ್ನಿ ಬಾಹಿರ್ ಗಾಲಿತಿತ. ");
INSERT INTO gok_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","ಮನ್ಹುನ್ ತ್ಯಚೆ ಆಯಿ ಬಾನಿ, “ತ್ಯೊ ಥೊರ್ಲಾ ಜಾ಼ಲ್ಯಾ. ತ್ಯಲಾಸ್ ಇಚಾರಾ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","ಯೆಹುದಿ ಅಧಿಕಾರಿಂಚಾನಿ ಪರತ್ ದೊನ್ವೆ ಪಾವ್ಟಿ ತ್ಯಾ ಆಂದ್‌ಳ್ಯಾಲಾ ಹಾಕಟ್ಲ ಆನಿ ಸಾಂಗ್ಲ. ತು ಖರ ಸಾಂಗ್‌ತ್ಯೊಸ್ ಮನ್ಹುನ್ ದೇವಾಚೆ ಮೊರ‍್ಹ ಶೆಪ್ಪತ್ ಕರ್. ಕಾ ಮಂಜೆ ತ್ಯೊ ಮಾನುಸ್ ಪಾಪಿ ಮನ್ಹುನ್ ಆಮಾನಾ ಠಾವಾ ಹಾ. ” ");
INSERT INTO gok_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","ತ್ಯೊ ಮಾನುಸ್, “ಪಾಪಿ ವ್ಹಯ್ ಕ್ಯಾ ನವ್ಹ ಮನಾ ಠಾವಾನಾಹಿ. ಫನ್ ಮಿ ಆಂದ್ಳಾ ಜಾ಼ಲ್ತೊ; ಆತಾ ಮನಾ ನದಾರ್ ಆಲೆ ಮನ್ಹುನ್ ಮನಾ ಠಾವಿ ಹಾ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","ಯೆಹುದಿ ಅಧಿಕಾರಿಂಚಾನಿ ಇಚಾರ್ಲ, “ತ್ಯನಿ ತುಲಾ ಕ್ಯಾ ಕೆಲ? ತ್ಯನಿ ತುಜ಼ ಡೊಳ ಕಸ ಬರ ಕೆಲ? ");
INSERT INTO gok_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","ತ್ಯೊ ಮಾನುಸ್, “ತುಮಾನಾ ಮಿ ಆಂದಿಸ್ ಸಾಂಗ್‌ಲ್ಯಾ. ಫನ್ ತುಮಿ ಮಾಜಿಕ್ಡ ಕಾನ್ ದಿಲಾ ನಾಹಿಸಾ. ಆತಾ ತ್ಯ ಕಾ ಇಚಾರಾಯಾ ವ್ಹಯಿ ಮಂತಾಸಾ? ತುಮಿ ಸಾಯಿತ್ ತ್ಯಚೆ ಮಾಗ್ನಿ ಜಾ಼ಯಾ ವ್ಹಯಿ ಮಂಥಾಸಾ ಕ್ಯಾ? ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","ತ್ಯಲಾಸ್ ತ್ಯಂಚಾನಿ ಹಿರ್ಮಟ್ನಾ ಕಿಲಿ ಆನಿ ತು ಯೇಸುಚೆ ಮಾಗ್ನಿ ಜಾ಼ತ್ಯಾಲಾ ಜಾ಼ಲ್ಯಾಸ್ ಆಮಿ ಮೊಶೆಚೆ ಮಾಗ್ನಿ ಜಾ಼ತ್ಯಾಲ ಜಾ಼ಲ್ಯಾವ್. ");
INSERT INTO gok_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","ದೇವ್ ಮೊಶೆ ಸಂಗ ಬೊಲ್ಯಾ ಮನ್ಹುನ್ ಆಮಾನಾ ಠಾವಾ ಹಾ. ಫನ್ ಹ್ಯೊ ಮಾನುಸ್ ಕುಟ್ನಿ ಆಲ್ಯಾ ಮನ್ಹುನ್ ಆಮಾನಾ ಠಾವಾ ನಾಹಿ ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","ತ್ಯಾ ಮಾನ್ಸಾನಿ ಹಿ ಖುಬ್ ಚಮತ್ಕಾರಾಚಿ ಗ್ಯೊಸ್ಟ್ ಕುಟ್ನಿ ಆಲೆ ಮನ್ಹುನ್ ಮನಾ ಠಾವ ನಾಹಿ ಫನ್ ತ್ಯನಿ ಮನಾ ನದಾರ್ ದಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","ಮನಾ ಠಾವ ಹಾ ದೇವ್ ಪಾಪಿಂಚ಼ ಐಕಿತ್ನಾಹಿ. ಫನ್ ಕೊನ್ ಭಕ್ತಿನಿ ರಾಥೊ ಆನಿ ತ್ಯಚಾ ಮನಾ ಶಾರ್ಕ ಕರ್ತೊ ತ್ಯಚ಼ ಐಕ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","ಜ಼ಲ್ಮತ್ ಆಂದಳಾ ಆಸಲ್ಯಾಲ್ಯಾ ಯಕಾ ಮಾನ್ಸಾಚ಼ ಡೊಳ ಕಚಾನಿತರಿ ಉಗಡಲ್ಯಾಲ ಪೈಲೆದರ್ನಿ ದುನೆತ್ ಕಚಾನಿ ಐಕ್ಲನಾಹಿ ");
INSERT INTO gok_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","ಎಕ್‍ವೆಳಿ ಹ್ಯೊ ಮಾನುಸ್ ದೇವಾಪ್ನಿ ಆಲ್ಯಾಲಾ ನಸ್ಥಾತ ಹ್ಯಲಾ ಕಾಯ್ ಕರಾಯಾ ವ್ಹಯಿತ್ ನವ್ಥ.ಮನ್ಲಾ ");
INSERT INTO gok_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","ತವಾ ತೆ, “ಪಾಪಾತ್ ಜ಼ಲಾಮ್‌ಲ್ಯಾಲಾ ತು! ಆಮಾನಾ ಸಿಕಿವ್ತೊಸ್ ಕ್ಯಾ? ಮನ್ಲ ಆನಿ ತ್ಯಂಚಾನಿ ತ್ಯಲಾ ಯೆಹುದಿ ಸಬಾಸ್ಥಾನಾತ್ನಿ ಡಕ್ಲುನ್ ಬಾಹಿರ್ ಗ್ಯಾತ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","ಯೆಹುದಿ ಅಧಿಕಾರಿಂಚಾನಿ ತ್ಯಾ ಮಾನ್ಸಾಲಾ ಬಾಹಿರ್ ಗ್ಯಾತ್‌ಲ್ಯಾಲಾ ಯೇಸುಲಾ ಸಮಾಜ಼್ಲ. ಯೇಸುನಿ ತ್ಯಲಾ ಬಗುನ್ ತು ಮಾನ್ಸಾಚಾ ಲೇಕಾವ ಇಸ್ವಾಸ್ ಥೆವ್ನಾರ್ ಕ್ಯಾ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","ತವಾ ತ್ಯೊ, “ಗುರು ತ್ಯೊ ಕೊನ್ ಮನಾ ಸಾಂಗ್ ಮಂಜೆ ಮಿ ತ್ಯಚಿವ ಇಸ್ವಾಸ್ ಥಿವಿನ್” ಮನ್ಲಾ ");
INSERT INTO gok_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","ಯೇಸು, “ತು ತ್ಯಲಾ ಬಗ್‌ಲ್ಯಾಸ್ ಆತಾ ತುಜಿ ಸಂಗ ಕೊನ್ ಬೊಲ್‌ತ್ಯೊ ತ್ಯೊಸ್ ತ್ಯೊ .ಮನ್ಲಾ ");
INSERT INTO gok_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","ತವಾ, “ಪ್ರಭು ಮಿ ಇಸ್ವಾಸ್ ಥೆವ್ತೊ. ” ಮನ್ಲಾ ಆನಿ ತ್ಯನಿ ತ್ಯಚೆ ಮೊರ‍್ಹ ಡೊಗ್ಲ ಮ್ಯುಡ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","ತವಾ ಯೇಸು. ಮಿ ಹೆ ದುನೆತ್ಲಾ ನ್ಯಾಯಿ ನಿವ್ಡಾಯಾ ಆಲ್ಯೊ ಹ್ಯನಿ ಹಿತ್ತ ಕೊನ್ ಆಂದ್ಳ ಹಾತ್ತ ತ್ಯನಾ ದಿಸುನಿ ಆನಿ ಕುನಾಲಾ ದಿಸತ್ಯಾಲ ಹಾ ತೇ ಆಂದ್ಳ ವ್ಹವುಂತ. ಮನ್ಲಾ ");
INSERT INTO gok_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","ಹ್ಯ ತಿತಲ್ಯಾ ಥೊಡ್ಯಾ ಫರಿಸಾಯಾಂಚಾನಿ ಐಕುನ್, “ಆಮಾನಾ ಸಾಹಿತ್ ಆಂದ್ಳ ಮನ್ಹುನ್ ಖರ‍್ಯಾನಿ ಸಾಂಗ್ತೊಸ್ ಕ್ಯಾ? ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","ತವಾ ಯೇಸು ತುಮಿ ಖರ‍್ಯಾನಿಸ್ ಆಂದ್ಳ ಜಾ಼ಲ ಆಸ್ಥಾಸಾತ ಪಾಪಾಚೆ ಚು಼ಕಿತ್ ಗಾವತ್ ನವ್ಥಾಸಾ ಫನ್ ತುಮಿ ಆಮಾನಾ ದಿಸತ್ಯಾ ಮಂಥಾಸಾ ಮನ್ಹುನ್ ತುಮಿ ಪಾಪಿ ಜಾ಼ಲ್ಯಾಸಾ ಮನ್ಲಾ. ” ");
INSERT INTO gok_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","ಯೇಸು, “ಮಿ ತುಮಾನಾ ಖರ ಸಾಂಗ್ತೊ. ಕೊನ್ ಮೆಂಡ್ರಾಂಚಾ ಸಾಟಾಚಾ ದಾರಾನಿ ಜಾ಼ಯಿತ್ ನಾಹಿ. ದುಸ್ರಿಕ್ನಿ ಚ಼ಡುನ್ ಆತ್ ಯತೊ ತ್ಯೊ ಚೊ಼ರ್ ಆನಿ ಲುಟ್ಯಾರಾ ಜಾ಼ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","ಕೊನ್ ದಾರಾತ್ನಿ ಆತ್ ಯತೊ ತ್ಯೊ ಮೆಂಡ್ರ ಚಾರತ್ಯಾಲಾ ದನ್ಹಿ ಜಾ಼ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","ದಾರ್ ರ‍್ಯಾಕ್ನಾರಾ ಕುರುಬುರಾಲಾ ದಾರ್ ಉಗಡ್ತೊ. ಆನಿ ಕುರುಬುರ್ ಆಪ್‌ಲ್ಯಾ ಮೆಂಡ್ರಾನಾ ನಾವ್ ಗಿಹುನ್ ಹಾಕಟಾನಾ ಮೆಂಡ್ರ ತ್ಯಚಾ ಸಬ್ದಾಲಾ ಕಾನ್ ದೇತ್ಯಾತ ತವಾ ಕುರುಬುರ್ ಮೊರ‍್ಹ ಲಾಗ್ತೊ ಮೆಂಡ್ರ ತ್ಯಚೆ ಮಾಗ್ನಿ ಜಾ಼ತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","ಕವಾ ತ್ಯೊ ಆಪ್‌ಲ್ಯಾ ಸಗ್‌ಳ್ಯಾ ಮೆಂಡ್ರಾನಾ ಬಾಹಿರ್ ಗಿಹುನ್ ಜಾ಼ತೊ ತವಾ. ತ್ಯೊ ಮೊರ‍್ಹ ಜಾ಼ತ್ಯೊ ಮೆಂಡ್ರ ತ್ಯಚೆ ಮಾಗ್ನಿ ಜಾ಼ತ್ಯಾತ ಕಾ ಮಂಜೆ ತೀ ತ್ಯಚಾ಼ ಸಬ್ದ ವಳಕ್‌ತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","ಫನ್ ಮೆಂಡ್ರ ಕವಾಸ್ ವಳಕ್ ನಸ್‌ಲ್ಯಾಲ್ಯಾಚೆ ಮಾಗ್ನಿ ಜಾ಼ಯಿತ್ ನಾಹಿತ. ತೀ ತ್ಯಚಿಪ್ನಿ ದುರ್ ಪಳುನ್ ಜಾ಼ತ್ಯಾತ ಕಾ ಮಂಜೆ ತೀ ವಳಕ್ ನಸ್‌ಲ್ಯಾಲ್ಯಾಚಾ಼ ಸಬ್ದ ವಳ್ಕಿತ್ ನಾಹಿತ. ");
INSERT INTO gok_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","ಯೇಸುನಿ ಹಿ ಕ್ಯಾಯ್ನಿ ಸಾಂಗ್ಲಿ ಫನ್ ತ್ಯನಾ ಹ್ಯಚಾ಼ ಅರ್ಥ ಸಮಾಜ಼್ಲಾ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","ಮನ್ಹುನ್ ಯೇಸುನಿ ಆನಿಕ್ ಮಿ ತುಮಾನಾ ಖರ ಸಾಂಗ್ತೊ ಮೀಸ್ ಮೆಂಡ್ರಾನಾ ದಾರ್ ");
INSERT INTO gok_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","ಮಿ ಯಯಾಚೆ ಆಂದಿ ಆಲ್ಯಾಲ ಸಗ್ಳ ಚ್ವಾ಼ರ್ ಜಾ಼ಲ್ಥ ಆನಿ ಸುಲುನ್ ಖಾತ್ಯಾಲ ಜಾ಼ಲ್ಥ ಮೆಂಡ್ರಾಂಚಾನಿ ತ್ಯಂಚಾ಼ ಸಬ್ದ ಐಕ್ಲಾ ನವ್ಥಾ. ");
INSERT INTO gok_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","ಮೀಸ್ ದಾರ್ ಜಾ಼ಲ್ಯೊ. ಕೊನ್ ಮಾಜಿಸ್ ಲಾಗುನ್ ಯಯಿಲ್ ತ್ಯಚಿ ರಕ್ಶನ್ ವ್ಹನಾರ್ ತ್ಯೊ ಆತ್ ಜಾ಼ನಾರ್ ಆನಿ ಬಾಹಿರ್ ಯನಾರ್ ಆನಿ ತ್ಯಲಾ ಚಾ಼ರಾ ಗಾವಲ್. ");
INSERT INTO gok_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","ಚೊ಼ರ್ ಚು಼ರಿ ಕರಾಯಾ, ಮಾರುನ್ ಟಾಕಾಯಾ, ನಾಸ್ ಕರಾಯಾ ಯತೊ, ಮಿ ತರಿ ಜೀವ್ನಾ ದಿಯಾ ಆಲ್ಯೊ. ಆನಿ ಹ್ಯ ಸಗ್ಳ ಭರ್ಪುರ್ ಜಿವನ್ ದಿಯಾ ಆಲ್ಯೊ. ");
INSERT INTO gok_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","ಮೀಸ್ ಚಾ಼Oಗ್ಲಾ ಕುರುಬುರ್ ಚಾ಼ಂಗ್ಲಾ ಕುರುಬುರ್ ಆಪ್‌ಲ್ಯಾ ಮೆಂಡ್ರಾಚೆ ಸಾಟಿ ಆಪ್ಲಾ ಜೀವ್ ದೇತೊ ");
INSERT INTO gok_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","ಆಳ್ ಮೆಂಡ್ರಾಚಾ಼ ಧನ್ಹಿ ವ್ಹಯಿತ್ ನಾಹಿ. ಆನಿ ಮೆಂಡ್ರ ತ್ಯಚಿ ಸ್ವತಾಚಿ ವ್ಹಯಿತ್ ನಾಹಿತ ನ್ಯಾನ್ಗ ಯತ್ಯಾಲ ಬಗುನ್ ಮೆಂಡ್ರ ಸುಡುನ್ ಪಳುನ್ ಜಾ಼ತೊ. ತವಾ ನ್ಯಾನ್ಗ ಮೆಂಡ್ರಾನಾ ದರ್‍ಹುನ್ ತ್ಯನಾ ಪಗಳ್‌ತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","ತ್ಯೊ ಪಳುನ್ ಜಾ಼ತೊ ಕಾಮಂಜೆ ತ್ಯೊ ನಿಸ್ಥಾ ಆಳ್ ಜಾ಼ಲ್ಯಾ. ತ್ಯಚಾ ಮೆಂಡ್ರಾಚೆ ಗುಶ್ಟಿತ್ ಖರಿ ಕ್ಯಾಳ್ಜಿ ತ್ಯಲಾ ನಸ್ಥಿ. ");
INSERT INTO gok_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","ಮಿ ಚಾ಼Oಗ್ಲಾ ಕುರುಬುರ್ ಹಾ ಕಸಾ ಬಾ ಮನಾ ವಳಕ್ತೊ ತಸಾ ಮಿ ಬಾಲಾ ವಳಕ್ತೊ ತೇಸ್ ತರನಿ ಮಿ ಮಾಜಾ ಮೆಂಡ್ರಾನಾ ವಳಕ್ತೊ ಆನಿ ತೀ ಮನಾ ವಳಕ್‌ತ್ಯಾತ. ಆನಿ ಮಿ ಮಾಜಾ ಮೆಂಡ್ರಾಂಚೆಸಾಟಿ ಜೀವ್ ದಿಯಾ ತಯಾರ್ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","ಮನಾ ದುಸ್ರಿ ಮೆಂಡ್ರ ಸಾಹಿತ್ ಹಾತ್ತ ತೀ ಹಿತ್ತ ಸಾಟಾತ್ ನಾಹಿತ ಮಿ ತ್ಯನಾಬಿ ಆತ್ ನಿಹ್ಯಾ ವ್ಹಯಿತ ತೀ ಮಾಜ಼ ಸಬ್ದ ಐಕ್‍ತ್ಯಾತ. ತವಾ ಯೊಕುಸ್ ಹಿಂಡ್ ಆನಿ ಯೊಕುಸ್ ಕುರುಬುರ್ ರಾನ್ಹಾರ್. ");
INSERT INTO gok_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","ಬಾ ಮಾಜಿ ಮಾಯಾ ಕರ್ತೊ ಕಾ ಮಂಜೆ ಮಿ ಮಾಜಾ಼ ಜೀವ್ ಆನಿಕ್ ಗಿಹ್ಯಾ ಸಾಟಿ ದೇತೊ. ");
INSERT INTO gok_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","ಮಾಜಾ಼ ಜೀವ್ ಮಾಜಿಪ್ನಿ ಕೊನ್ ಕಾಡುನ್ ಗಿಹಿತ್ ನಾಹಿ ಮಿ ಮಾಜಾ ಮನಾನಿ ದೇತೊ. ಮಾಜಾ಼ ಜೀವ್ ದಿಯಾ ತ್ಯೊ ಆನಿಕ್ ಗಿಹ್ಯಾ ಮನಾ ಹಾಕ್ ಹಾ. ಆಸ ಕರಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಬಾನಿ ಮನಾ ಹುಕುಮ್ ದಿಲ್ಯಾ. ಮನ್ಹುನ್ ಸಾಂಗ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","ಆನಿ ಯಂಗ್ದಾ ಹ್ಯ ಐಕುನ್ ಯೆಹುದ್ಯಾಪ್ನಿ ಆನಿ ಯಂಗ್ದಾ ದುಯಿ ಪಡ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","ಖುಬ್ ಜ಼ನ ಸಾಂಗಾಯಾ ಲಾಗ್ಲಿತ ಹ್ಯಚಿಪ ಲಾಗಿರ್ ಹಾ ಹ್ಯೊ ಖುಳಾ ಹಾ. ಹ್ಯಚ಼ ಕ್ಯಾ ಐಕ್ತಾಸಾ? ");
INSERT INTO gok_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","ಹಿತ್ತ ದುಸ್ರ ಸಾಂಗಿತ ಲಾಗಿರ್ ಲಾಗ್‌ಲ್ಯಾಲಾ ಆನಿ ಖುಳಾ ಜಾ಼ಲ್ಯಾಲಾ ಮಾನುಸ್ ಆಸಾ ಬೊಲತ್ ನಾಹಿ. ಆಂದ್‌ಳ್ಯಾಂಚ಼ ಡೊಳ ಬರ ಕರಾಯಾ ಲಾಗಿರಾಲಾ ವ್ಹತ ಕ್ಯಾ? ನಾಹಿ ಮನ್ಹುನ್ ಸಾಂಗ್‌ತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","ದೇವ್ಳಾಚಾ಼ ಅರ್ಪನ್ ಕರ್ತ್ಯಾಲಾ ಸನ್ ಯೆರುಸಲೇಮಿತ್ ಚಾ಼ಲತಾ. ತ್ಯೊ ಥಂಡಿಚಾ ದಿಸಾತ್ ಕರ್ತ್ಯಾಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","ಯೇಸು ಸೊಲೊಮನಾಚಾ ದೇವ್ಳಾಚಾ ಮಾಂಡ್ವಾತ್ ಫಿರತಾ. ");
INSERT INTO gok_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","ಯೆಹುದಿ ಯೇಸುಚೆ ಸರ್ ಬವಾರ ಜ಼ಮ್ಲ ಹುತ್ತ. ತೆ ತ್ಯಲಾ, “ಆಜು಼ನ್ ಕ್ಯವ್ಡ ದಿಸ್ ತು ಆಮಾನಾ ಚು಼ರುನ್ ರಾಥೊಸ್? ಆಮಾನಾ ಖರ ಸಾಂಗ್” ತು ಕ್ರಿಸ್ತ್ ಕ್ಯಾ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","ಯೇಸುನಿ ತ್ಯನಾ ಉತ್ತರ್ ದಿಲಾ, “ಮಿ ತವಾಸ್ ತುಮಾನಾ ಸಾಂಗಲ್ಯಾ. ಫನ್ ತುಮಿ ಇಸ್ವಾಸ್ ಥ್ಯೆವ್ಲಾ ನಾಹಿಸಾ. ಮಿ ಮಾಜಾ ಬಾಚಾ ಹುಕ್ಮಾನಿ ಚಮತ್ಕಾರಾಚಿ ಕಾಮ ಕರ್ತೊ. ಮಿ ಕೊನ್ ಮನ್ಹುನ್ ತಿ ಚಮತ್ಕಾರಾಚಿ ಕಾಮ ದ್ಯಾವತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","ಫನ್ ತುಮಿ ಇಸ್ವಾಸ್ ಥಿವಿತ್ ನಾಹಿಸಾ. ಕಾ ಮಂಜೆ ತುಮಿ ಮಾಜಿ ಮೆಂಡ್ರ ನವ್ಹಸಾ. ");
INSERT INTO gok_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","ಮಾಜಿ ಮೆಂಡ್ರ ಮಾಜಾ಼ ಸಬ್ದ ಐಕ್‌ತ್ಯಾತ; ಮನಾ ತಿ ಠಾವಿ ಹಾತ ಆನಿ ತಿ ಮಾಜೆ ಮಾಗ್ನಿ ಯತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","ಮಾಜಾ ಮೆಂಡ್ರಾನಾ ಮಿ ಶಾಶ್ವತ್ ಜೀವ್ ದೆತೊ. ತಿ ಕಂದಿಸ್ ಮರತ್ ನಾಹಿತ, ಆನಿ ತ್ಯನಾ ಮಾಜಿಪ್ನಿ ಕಾಡುನ್ ಗಿಹುನ್ ದುರ್ ಕರಾಯಾ ಕುನಾಲಾ ವ್ಹಯಿತ್ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","ತ್ಯನಾ ಮಾಜಾ ಬಾನಿಸ್ ಮನಾ ದಿಲಿತ. ತ್ಯೊ ಸಗಳ್ಯಾವ್ನಿ ಥೊರ್ ಜಾ಼ಲ್ಯಾ. ತ್ಯನಾ ಮಾಜಾ ಬಾಚಾ ಹಾತಾತ್ನಿ ಕಾಡುನ್ ಗಿಹ್ಯಾ ಕುನಾಲಾ ವ್ಹಯಿತ್ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","ಬಾ ಆನಿ ಮಿ ಯೆಕುಸ್ ಹಾವ್” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","ತವಾ ಯೆಹುದ್ಯಾಂಚಾನಿ ಯೇಸುಲಾ ಮಾರಾಯಾ ಆನಿಕ್ ದೊಂಢ ಯಚ಼ುನ್ ಗೆತ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","ಫನ್ ಯೇಸುನಿ ತ್ಯನಾ, “ಮಿ ಬಾಪ್ನಿ ಖುಬ್ ಚಮತ್ಕಾರಾಚಿ ಕಾಮ ಕೆಲ್ಯಾತ. ತುಮಿ ತಿ ಕಾಮ ಬಗಲ್ಯಾಸಾ. ತ್ಯಾ ಚಮತ್ಕಾರಾಚಾ ಕಾಮಾತಲ್ಯಾ ಕಚಾಸ್ಲಾಗುನ್ ತುಮಿ ಮಾಜಿವ ದೊಂಢ ಮಾರಾಯಾ ವ್ಹಯಿ ಮಂಥಾಸಾ? ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","ಯೆಹುದ್ಯಾಂಚಾನಿ, “ಆಮಿ ತುಜಿವ ದೊಂಢ ಮ್ಯಾರ್‌ಲ್ಯಾಲ ತು ಕೆಲ್ಯಾಲ್ಯಾ ಕಚಾಸ್ ಕಾಮಾಸ್ ಲಾಗುನ್ ನವ್ಹ. ತು ಬೊಲ್ಯಾಲೆ ನಿಂದಸಾಟಿ. ಕಾಮಂಜೆ ತು ಯೊಕ್ ಮಾನುಸ್. ಫನ್ ತು ತುಲಾಸ್ ದೇವ್ ಮನ್ಹುನ್ ಸಾಂಗ್‌ತ್ಯೊಸ್!” ಮನ್ಹುನ್. ");
INSERT INTO gok_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","ತ್ಯಲಾ ಯೇಸುನಿ “ತುಮ್ಚಾ ಧರ್ಮಶಾಸ್ತಾರಾತ್” ‘ಮಿ ಆನಿ ತುಮಿ ದ್ಯಾವ್ ಮನ್ಹುನ್ ಲಿವ್ಲ ನಾಹಿಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","ಯೆಕ್ ಯಳಿ ದೇವಾಚಾ಼ ಸಬ್ದ ಕುನಾಪ ಆಲ್ಯಾ ತ್ಯನಾ ದೇವ್ ಮನ್ಹುನ್ ಹಾಕ್ಟಾಚ಼ ಜಾ಼ಲ್ಯಾವ. ಪವಿತ್ರ ಪುತೀಕ್ ಖೊಟ ನವ್ಹ. ");
INSERT INTO gok_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","ಆಸ ಆಸ್ಥಾನಾ ಬಾನಿ ಆಪ್‌ಲ್ಯಾಲಾ ಸ್ವತಾಚಾ಼ ಮನ್ಹುನ್ ನಿವ್ಡುನ್ ಹೆ ದುನೆತ್ ಲಾವುನ್ ದಿಲ್ಯಾಲ್ಯಾಚೆ ಗುಶ್ಟಿತ್ ಕಸ ಆಸಲ್? ಮಿ ದೇವಾಚಾ಼ ಲ್ಯೊಕ್ ಜಾ಼ಲ್ಯೊ ಮನ್ಹುನ್ ಸಾಂಗ್‌ಲ್ಯಾಲ್ಯಾಲಾ ಮಿ ದ್ವೆಶ್ ಕರ್ತ್ಯೊ ಮನ್ಹುನ್ ಸಾಂಗಾಚ಼ ಕಾ? ");
INSERT INTO gok_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","ಮಾಜಾ ಬಾಚಿ ಕಾಮ ಮಿ ಕೆಲ್ಯಾ ನಸ್‌ಲ್ಯಾವ, ತುಮಿ ಮಾಜಿವ ಇಸ್ವಾಸ್ ಥೀವುನಕೊಸಾ. ");
INSERT INTO gok_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","ಫನ್ ಮಿ ತೀ ಕಾಮ ಕರೀತ್ ರಾಯ್ಲೊ ತರಿ, ತುಮಿ ಮಾಜಿವ ಇಸ್ವಾಸ್ ಥಿವಿನ್ಸಾ. ಚಮತ್ಕಾರಾಂಚಿವ ಇಸ್ವಾಸ್ ಥೆವಾ ಆಸ ಬಾ ಮಾಜಿಪ ಮಿ ಬಾಪ ಹಾ ಮನ್ಹುನ್ ತುಮಾನಾ ಠಾವ ವ್ಹನಾರ್ ಆನಿ ಸಮಾಜ಼್ನಾರ್” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","ಆನಿಕ್ ಯೇಸುಲಾ ದರಾಯಾ ಯೆಹುದ್ಯಾಂಚಾನಿ ಆನಿ ಯತ್ನ ಕಿಲಿತ. ಫನ್ ಯೇಸುನಿ ತ್ಯಂಚಿಪ್ನಿ ಚು಼ಕುವುನ್ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","ಮಂಗ್ ಯೇಸು ಯೊರ್ದಾನ್ ನ್ಹಚೆ ಪಲಿಕ್ಡ ಮಾಗಾರಾ ಗೆಲಾ. ಯೊಹಾನ್ ಆಂದಿ ಬಾಪ್ತಿಸ್ಮಾ ದೆತ್ಯಾಲ್ಯಾ ಜಾ಼ಗ್ಯಾವ ಯೇಸು ಜಾ಼ವುನ್ ತಿಥ ರಾಯ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","ತವಾ ಖುಬ್ ಲೊಕ ತ್ಯಚಿಪ ಆಲಿತ. “ಯೊಹಾನಾನಿ ಚಮತ್ಕಾರಾಚಿ ಕಾಮ ಕಂದಿಸ್ ಯಾಕ್ಬಿ ಕೆಲ ನಾಹಿ. ಫನ್ ಯೊಹಾನಾನಿ ಹ್ಯಾ ಮಾನ್ಸಾಚೆ ಗುಸ್ಟಿತ್ ಸಾಂಗಲ್ಯಾಲ ಸಗ್ಳ ಖರ” ಆಸ ತ್ಯಂಚಾನಿ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","ಆನಿ ತಿಥ ಖುಬ್ ಲೊಕಾಂಚಾನಿ ಯೇಸುವ ಇಸ್ವಾಸ್ ಥೆವ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","ಲಾಜ಼ರ್ ಮಂಥ್ಯಾಲಾ ಯೊಕ್ ಬರಾ ನವ್ತಾ. ತ್ಯೊ ಬೆತಾನ್ಯಾ ಮಂಥ್ಯಾಲ್ಯಾ ಗಾವಾತ್ ಹುತಾ. ಮರಿಯಾ ಆನಿ ತಿಚಿ ಭನ್ ಮಾರ್ಥಾ ಹ್ಯಾಸ್ ಗಾವಾತ್ ಹುತ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","ಪ್ರಭುಲಾ ವಾಸಾಚ಼ ತ್ಯಾಲ್ ಲಾವುನ್ ತ್ಯಚ಼ ಪ್ಯಾ ಆಪ್‍ಲ್ಯಾ ಡುಯಿಚಾ ಕೆಸಾಚಾಂನಿ ಪುಸ್‌ಲ್ಯಾಲ ಹಿನಿಸ್. ಬರಾ ನಸಲ್ಯಾಲಾ ಲಾಜ಼ರ್ ಹ್ಯೊಸ್ ಮರಿಯಾಚಾ಼ ಬಾಹು ಜಾ಼ಲ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","ಬನ್ಹಿಂಚಾನಿ ಯೇಸುಲಾ, “ಪ್ರಭು, ತುಜಾ಼ ಮಾಯೆಚಾ಼ ಸುಪ್ತಿ ಲಾಜ಼ರ್ ಬರಾ ನಾಹಿ” ಮನ್ಹುನ್ ಬಾತ್ನಿ ಲಾವುನ್ ದಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","ಯೇಸುನಿ ಹ್ಯ ಐಕ್ಲ ತವಾ, “ಹ್ಯ ದುಃಖ್ನ ಲಾಜ಼ರಾಚಾ಼ ಜಿವ್ ಕಾಡಾಯಾ ಆಲ್ಯಾಲ ನವ್ಹ ದೇವಾಚ಼ ಆನಿ ದೇವಾಚಾ ಲೇಕಾಚಾ ನಾವಾಚೆ ಮೈಮಾ ಸಾಟಿ ಆಲ್ಯಾಲ. ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","ಯೇಸು ಮಾರ್ಥಾಚಿ ತಿಚೆ ಭನ್ಹಿಚಿ ಆನಿ ಲಾಜ಼ರಾಚಿ ಮಾಯಾ ಕರೀತಾ. ");
INSERT INTO gok_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","ಲಾಜ಼ರ್ ದುಕ್‌ನ್ಯಾತ್ ಹಾ ಮಂಥ್ಯಾಲಿ ಖಬರ್ ತ್ಯನಿ ಐಕ್ಲಿ ತವಾ ಆಪ್ನು ಹುತ್ತಾ ತಿತ್ತಸ್ ಆನಿಕ್ ದೊನ್ ದೀಸ್ ರಾಯ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","ಮಂಗ್ ತ್ಯನಿ ಆಪ್‌ಲ್ಯಾ ಶಿಶಾನಾ ಆಮಿ ಯುದಾಯಾತ್ ಮಾಗಾರ ಜಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ ");
INSERT INTO gok_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","ಶಿಶಾಂಚಾನಿ ಪ್ರಭು ಯುದಾಯಾಚ಼ ಯೆಹುದ್ಯಾಂಚಾನಿ ತುಲಾ ದೊಂಡ್ಯಾನಿ ಮಾರಾಯಾ ಯತ್ನಕಿಲಿತ. ತ್ಯ ಜಾ಼ಲ್ಯಾಲ ನಿಸ್ಥ ಥೊಡ್ಯಾ ಯಳಾಚೆ ಮಾಗ ತ್ಯವ್ಡಸ್ ಆತಾ ತು ಆನಿಕ್ ತಿಥ ಜಾ಼ಯಾ ವ್ಹಯಿ ಮಂಥೊಸ್ ಕ್ಯಾ? ಮನ್ಹುನ್ ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","ತವಾ ಯೇಸು ದಿಸಾಚ಼ ಬಾರಾ ತಾಸ್ ಹಾತ್ತ ವ್ಹಯ್ ಕ್ಯಾ ನವ್ಹ? ದಿಸಾಚಾ಼ ಚಾ಼ಲತ್ಯಾಲಾ ಠ್ಯಾಸ್ ಲಾಗುನ್ ಪಡತ್ ನಾಹಿ ಕಾ ಮಂಜೆ ಹೆ ದುನೆತ್‌ಲ್ಯಾ ಉಜಿಡಾನಿ ಬಗ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","ಫನ್ ರ‍್ಯಾಚಾ಼ ಚಾ಼ಲತ್ಯಾಲಾ ಪಡ್ತೊ ಕಾ ಮಂಜೆ ಬಗುನ್ ಚಾ಼ಲಾಯಾ ಕಸ್ಲಾ ಉಜಿಡ್ ತ್ಯಲಾ ರಾಹಿತ್ ನಾಹಿ ಮನ್ಹುನ್ ಉತ್ತರ್ ದೇತೊ ");
INSERT INTO gok_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","ಯೇಸುನಿ ಹ್ಯಾ ಗುಶ್ಟಿ ಸಾಂಗ್‍ಲ್ಯಾ ನಂತರ್ ಆಮಚಾ಼ ಸುಪ್ತಿ ಲಾಜ಼ರ್ ಆತಾ ನಿಜ಼ಲ್ಯಾ ತ್ಯಲಾ ಉಟ್ವಾಯಾ ಮಿ ತಿಥ ಜಾ಼ತ್ಯೊ ಮನ್ಲಾ ");
INSERT INTO gok_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","ಶಿಶಾ ಪ್ರಭು ತ್ಯೊ ನಿಜ್ಲಾ಼ ಆಸ್ಲಾತ ಬರಾ ವ್ಹನಾರ್ ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","ಯೇಸು ಲಾಜ಼ರಾಚಾ ಮರ್ನಾಚೆ ಗುಶ್ಟಿತ್ ಬೊಲತಾ ಫನ್ ಶಿಶಾಂಚಾನಿ ತ್ಯೊ ಸ್ವಾಬಾವಿಕ್ ನಿಜ಼ಚೆ ಗುಶ್ಟಿತ್ ಬೊಲ್‌ತ್ಯೊ ಮನ್ಹುನ್ ಯವಜ಼ಲ. ");
INSERT INTO gok_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","ಯೇಸುನಿ ಲಾಜ಼ರ್ ಮೆಲ್ಯಾ ಮನ್ಹುನ್ ಶಾರ್ಕ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","ಫನ್ ಮಿ ತಿತ್ತ ನವ್ತೊತ್ಯೊ ಬರ ಜಾ಼ಲ್ಹ. ಕಾ ಮಂಜೆ ತುಮಾನಾ ಮಾಜಿವ ಇಸ್ವಾಸ್ ಯಯಾ ಹ್ಯ ಸಗ್ಳ ಜಾ಼ಲ್ಹ. ಯವಾ ಆಮಿ ತ್ಯಚಿಪ ಜಾ಼ವುಯಾ ಮನ್ಲಾ ");
INSERT INTO gok_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","ತವಾ ದಿದುಮ್ ಮಂತ್ಯಾಲಾ ತೊಮಾ ಬಾಕಿಚಾ ಶಿಶಾನಾ ಯವಾ ಆಮಿಬಿ ತ್ಯಚಿಸಂಗ ತಿಥ ಮರಾಯಾ ಜಾ಼ವುಯಾ.ಮನ್ಲಾ ");
INSERT INTO gok_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","ಯೇಸು ಬೆತಾನ್ಯಾತ್ ಆಲಾ. ಲಾಜ಼ರಾಲಾ ಮಸುರ್ಡಿತ್ ಥಿವುನ್ ಚಾರ್ ದೀಸ್ ಜಾ಼ಲ್ಯಾತ ಮನ್ಹುನ್ ಯೇಸುಲಾ ಸಮಾಜ಼್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","ಬೆತಾನಿ ಯೆರುಸಲೇಮಿತ್ನಿ ದೊನ್ ಮೈಲಾಚೆ ಆತ್ ಹುತ್ತಿ. ");
INSERT INTO gok_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ಬಾಹು ಜಾ಼ಲ್ಯಾಲಾ ಲಾಜರಾಚೆ ಗುಶ್ಟಿತ್ ಸಮಜಾ಼ವಾಯಾ ಖುಬ್ ಯೆಹುದಿ ಮಾರ್ಥಾ ಆನಿ ಮರಿಯಾಪ ಆಲ್ತ. ");
INSERT INTO gok_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","ಯೇಸು ಯತ್ಯೊ ಮನ್ಹುನ್ ಬಾತ್ನಿ ಐಕುನ್ ಮಾರ್ಥಾ ತ್ಯಲಾ ಭೇಠಾಯಾ ಬಾಹಿರ್ ಗಿಲಿ ಫನ್ ಮರಿಯಾ ಗರ‍್ಹಾತುಸ್ ಹುತ್ತಿ ");
INSERT INTO gok_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","ಮಾರ್ಥಾನಿ ಯೇಸುಲಾ ಪ್ರಭು ತು ಹಿತ್ತ ಆಸ್ಥಾಸ್ತ ಮಾಜಾ಼ ಬಾಹು ಮರತ್ ನವ್ಥಾ ");
INSERT INTO gok_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","ಫನ್ ಆತಾಸಾಹಿತ್ ದೇವಾಪ ಮಾಗ್‌ಲ್ಯಾಲ ತ್ಯೊ ತುಲಾ ದೆನಾರ್ ಮನ್ಹುನ್ ಠಾವ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","ಯೇಸುನಿ ತುಜಾ ಬಾಹು ಆನಿಕ್ ಜಿತ್ತಾ ವ್ಹವುನ್ ಉಠುನ್ ಯನಾರ್ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","ಮಾರ್ಥಾ ಸರ್ತ್ಯಾ ದಿಸಾತ್ ಮರ್ನಾತ್ನಿ ಉಠುನ್ ಯತಾನಾ ತ್ಯೊ ಆನಿಕ್ ಉಠುನ್ ಯನಾರ್ ಮನ್ಹುನ್ ಮನಾ ಠಾವಾ ಹಾ. ಮನ್ಹುನ್ ಮನ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","ಯೇಸು ತಿಲಾ ಮೀಸ್ ಮರ್ನಾತ್ನಿ ಉಠುನ್ ಯನಾರಾ ಆನಿ ಮಾಜಿವ ಇಸ್ವಾಸ್ ಥೆವ್‍ತ್ಯಾಲಾ ಮೆಲ್ಯಾ ನಂತರ್ ಆನಿಕ್ ಜೀವ್ ಗೇನಾರ್. ");
INSERT INTO gok_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ಆನಿಕ್ ಜೀವ್ನಾ ಕರೀತ್ ಮಾಜಿವ ಇಸ್ವಾಸ್ ಥೆವ್‌ಥ್ಯಾಲಾ ಕಂದಿಸ್ ಮರತ್ ನಾಹಿ ಹ್ಯಚಿವ ತು ಇಸ್ವಾಸ್ ಥಿವ್ತಿಸ್ ಕ್ಯಾ? ಮನ್ಲಾ ");
INSERT INTO gok_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","ತವಾ ತಿ, “ವ್ಹಯ್ ಪ್ರಭು ತು ಕ್ರಿಸ್ತ ಮನ್ಹುನ್ ಮಿ ಇಸ್ವಾಸ್ ಥೆವ್ತೆ, ದೇವಾಚಾ಼ ಲ್ಯೊಕ್, ಹೆ ದುನೆತ್ ಯನಾರಾ ತುಸ್, ಮನ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","ಹ್ಯಾ ನಂತರ್ ಮಾರ್ಥಾ ತಿಥ್ನಿ ಮಾಗಾರಿ ಗಿಲಿ ಆನಿ ಆಪ್ಲಿ ಭನ್ ಮರಿಯಾಲಾ ಯಕಾನ್ಸಿ ಹಾಕ್ಟುನ್, “ಗುರು ಹಿತ್ತ ಹಾ ಆನಿ ತುಲಾ ಹಾಕಟ್ಯೊ. ಮನ್ಹುನ್ ಸಾಂಗ್ತಿ. ");
INSERT INTO gok_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","ಹ್ಯ ಐಕ್‌ಲ್ಯಾ ಬರ್ಬರ್ ಮರಿಯಾ ಉಠುನ್ ಯೇಸುಪ ಬಿಗಿ ಬಿಗಿ ಗಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","ಯೇಸು ಆಜು಼ನ್ ಗಾವಾತ್ ಆಲಾ ನವ್ಥಾ. ಮಾರ್ಥಾ ಆಪ್‌ಲ್ಯಾಲಾ ಗಾವಲ್ಯಾಲ್ಯಾ ಜಾ಼ಗ್ಯಾವಸ್ ತ್ಯೊ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","ಯೆಹುದಿ ಮರಿಯಾ ಸಂಗ ಗರ‍್ಹಾತ್ ಹುತ್ತ ತಿಲಾ ಸಮ್ಜಾವಿತ ಮರಿಯಾ ಉಠುನ್ ಗಡ್ಬಡಿನಿ ಜಾ಼ತ್ಯಾಲಿ ತ್ಯಂಚಾನಿ ಬಗ್ಲಿ ತೀ ರಡಾಯಾ ಸಾಟಿ ಮಸುರ್ಡಿಪ ಜಾ಼ತೆ ಮನ್ಹುನ್ ತ್ಯಂಚಾನಿ ಸಮಜು಼ನ್ ಗಿಹುನ್ ತೀಚೆ ಮಾಗ್ನಿ ಗೇಲ. ");
INSERT INTO gok_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","ಯೇಸು ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ಜಾ಼ಗ್ಯಾವ ಮರಿಯಾ ಗಿಲಿ ಆನಿ ಯೇಸುಲಾ ಬಗ್‌ಲ್ಯಾ ಬರ್ಬರ್ ತ್ಯಚಾ ಪಾಯಾತ್ ಪಡುನ್ ಪ್ರಭು ತು ಹಿತ್ತ ಆಸ್ಥಾಸ್ತ ಮಾಜಾ಼ ಬಾಹು ಮರಾಚಾ಼ ನವ್ಥಾ ಮನ್ಲಿ ");
INSERT INTO gok_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","ಮರಿಯಾ ಆನಿ ತಿಚೆ ಸಂಗ ಆಲ್ಯಾಲ್ಯಾ ಯೆಹುದ್ಯಾಂಚ಼ ದುಕ್ ಯೇಸುನಿ ಬಗ್ಲ ತವಾ ತ್ಯಚಾ ಮನಾಲಾ ಖುಬ್ ದುಕ್ ಜಾ಼ಲ. ");
INSERT INTO gok_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","ಆನಿ ಯೇಸುನಿ ತ್ಯನಾ ತ್ಯಲಾ ಕುಠ ಥೆವ್‍ಲ್ಯಾಸಾ ಮನ್ಹುನ್ ಇಚಾರ್ಲ ತವಾ ತೇ ಪ್ರಭು ಯವುನ್ ಬಗ್ ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","ಯೇಸು ರಡ್ಲಾ ");
INSERT INTO gok_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","ತ್ಯಲಾ ಯೆಹುದಿಂಚಾನಿ ಬಗಾ ಹ್ಯೊ ಲಾಜ಼ರಾಚಿ ಕ್ಯವ್ಡಿ ಮಾಯಾ ಕರ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","ಫನ್ ಥೊಡ ಯೆಹುದಿ ಯೇಸುನಿ ಆಂದ್‍ಳ್ಯಾಚ಼ ಡೊಳ ಬರ ಕೆಲ ನವ್ಹ ಲಾಜ಼ರಾಲಾ ಸಾಹಿತ್ ಮಜ಼ತ್ ಕರುನ್ ತ್ಯಲಾ ಮರ್ನಾತ್ನಿ ಚು಼ಕ್ವು ನಾಹಿ ಕ್ಯಾ?ಮನ್ಹಿತ. ");
INSERT INTO gok_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","ಯೇಸುಲಾ ಆನಿಕ್ ದುಕ್ ವ್ಹವುನ್, ಲಾಜ಼ರಾಚೆ ಮಸುರ್ಡಿಪ ಗೇಲಾ, ತೀ ಮಸುರ್ಡಿ ಯೇಕ್ ಘಬ್ ಹುತ್ತಿ. ತಿಚಾ ತೊಂಡಾಲಾ ಮೊಟಾ ದೊಂಢಾ ಜಾಕ್ಲಾ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","ತ್ಯೊ ದೊಂಢಾ ಕಾಡಾ ಮನ್ಹುನ್ ಯೇಸುನಿ ಸಾಂಗ್ಲ. ಮೆಲ್ಯಾಲ್ಯಾಚಿ ಭನ್ ಮಾರ್ಥಾನಿ, “ಪ್ರಭು ಲಾಜ಼ರ್ ಮರುನ್ ಚಾರ್ ದೀಸ್ ಜಾ಼ಲ. ಆತಾ ಬುರ್ಸಾ ವಾಸ್ ಯಯಿತ್ ಆಸಲ್” ಮಂಥಿ. ");
INSERT INTO gok_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","ಯೇಸುನಿ ತಿಲಾ ಸಾಂಗ್ಲ, “ಮಿ ತುಲಾ ಸಾಂಗ್‌ಲ್ಯಾಲ್ಯಾವ ಇಸ್ವಾಸ್ ಥೆವ್‍ಲ್ಯಾವ ದೇವಾಚಿ ಮೈಮಾ ಬಗ್ನಾರ್? ");
INSERT INTO gok_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","ಮನ್ಹುನ್ ತ್ಯಂಚಾನಿ ಮಸುರ್ಡಿಚಾ ತೊಂಡಾವ್ಲಾ ದೊಂಢಾ ಕ್ಯಾಡ್ಲಾ ತವಾ ಯೇಸುನಿ ವರ್ ಬಗುನ್ ಬಾ ಮಾಜ಼ ಮಾಗ್ನ ಐಕ್ಲಸ್ ಮನ್ಹುನ್ ತುಲಾ ವವ್ಯಾಳ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","ತು ಕವಾಬಿ ಮಾಜ಼ ಐಕ್ತೊಸ್ ಮನ್ಹುನ್ ಮನಾ ಠಾವ ಹಾ. ಫನ್ ಹಿತ್ತ ಮಾಜೆ ಸರಬವಾರಿ ಆಸ್‍ಲ್ಯಾಲ್ಯಾ ಲೊಕಾಂಚೆ ಸಾಟಿ ಮಿ ಹ್ಯಾ ಗುಶ್ಟಿ ಸಾಂಗ್‌ಲ್ಯಾ. ತುಸ್ ಮನಾ ಲಾವುನ್ ದಿಲ್ಯಾಸ್ ಮನ್ಹುನ್ ತ್ಯಂಚಾನಿ ಇಸ್ವಾಸ್ ಥೆವಾಲಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಮಿ ಮನ್ ಕರ್ತೊ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","ಹ್ಯ ಸಗ್ಳ ಸಾಂಗ್‌ಲ್ಯಾ ನಂತರ್ ಯೇಸು ಜೋ಼ರಾನಿ, “ಲಾಜ಼ರಾ ಬಾಹಿರ್ ಯೇ” ಮನ್ಹುನ್ ಹಾಕಟ್ಟೊ. ");
INSERT INTO gok_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","ಮೆಲ್ಯಾಲಾ ಮಾನುಸ್ ಬಾಹಿರ್ ಆಲಾ. ತ್ಯಚ಼ ಹಾತ್ ಪ್ಯಾ ಕಪ್ನಾನಿ ಬ್ಯಾಂದ್ಲ ಹುತ್ತ. ತ್ಯಚ಼ ತ್ವಾಂಡ್ಬಿ ತ್ಯನಿಸ್ ಜಾಕ್ಲ ಹುತ್ತ. ತವಾ ಯೇಸುನಿ ತ್ಯನಾ ಸಾಂಗ್ಲ ತ್ಯಲಾ ಸೊಡಾ ತ್ಯೊ ಜಾ಼ವುನಿ. ");
INSERT INTO gok_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","ಮರಿಯಾಲಾ ಬೊಲ್ವಾಯಾ ಆಲ್ಯಾಲ ಯೆಹುದಿ ತಿಥ ಖುಬ್ ಹುತ್ತ. ಯೇಸುನಿ ಕೆಲ್ಯಾಲ ಹ್ಯ ಕಾಮ್ ಬಗ್‌ಲ್ಯಾಲ ತ್ಯಾತ್‍ಲ್ಯಾ ಖುಬ್ ಜ಼ನಾಂಚಾನಿ ತ್ಯಚಿವ ಇಸ್ವಾಸ್ ಥೆವ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","ಫನ್ ಯೇಸುನಿ ಕ್ಯಾ ಕೆಲ ಮನ್ಹುನ್ ತ್ಯಾತ್‌ಲ್ಯಾ ಥೊಡ್ಯಾಂಚಾನಿ ಫರಿಸಾಯಾಂಚಿಪ ಜಾ಼ವುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","ತವಾ ಮುಖ್ಯ ಯಾಜಕ್ ಆನಿ ಫರಿಸಾಯ್ ಯೆಹುದ್ಯಾಂಚಾ ಯವಜ್ನಾ಼ಚಾ ಮೆಳ್ಯಾಲಾ ಹಾಕ್ಟುನ್ ಆಮಿ ಕ್ಯಾ ಕರಾಯಾ ವ್ಹಯಿ? ಹ್ಯೊ ಮಾನುಸ್ ಖುಬ್ ಚಾ಼ಂಗ್ಲಿ ಕಾಮ ಕರ್ತ್ಯೊ. ");
INSERT INTO gok_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","ಹಿ ಕಾಮ ಕರಾಯಾ ಆಮಿ ತ್ಯಲಾ ಆವ್ಕಾಸ್ ದಿಲಾತ ಲೊಕ ಹ್ಯಚಿವ ಇಸ್ವಾಸ್ ಥೆವ್ನಾರ್ ತವಾ ರೊಮ್ ರಾಜಾತ್ನಿ ಯವುನ್ ಆಮ್‌ಚ಼ ದಿವುಳ್ ಆನಿ ಆಮ್ಚ಼ ರಾಜೆ ನಾಸ್ ಕರ್ನಾರ್ ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","ತ್ಯಾತ್ ಕಾಯಫ್ ಮಂಥ್ಯಾಲಾ ಯೊಕ್ ಹುತ್ತಾ. ತ್ಯೊ ತ್ಯಾ ವರ್ಸಾತ್ ಮಹಾಯಾಜಕ್ ಜಾ಼ಲ್ಥಾ ತ್ಯನಿ, “ತುಮಾನಾ ಕಾಯ್ ಠಾವ ನಾಹಿ ");
INSERT INTO gok_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","ಹ್ಯಾ ಸಬ್ದಾಚಾ಼ ಅರ್ಥ ಆಜು಼ನ್ ತುಮಾನಾ ಸಮಾಜ್ಲಾ಼ ನಾಹಿ ಹ್ಯನಿ ತುಮಾನಾ ಫ್ಯಾಯ್ದಾ ಹಾ ಸಗಳ್ಯಾಂಚೆಸಾಟಿ ಯಕಾನಿ ಮರಾಚ಼ ಯಕಾಸ್ಲಾಗುನ್ ಸರ್ವಿ ದುನ್ಯಾ ಹಾಳ್ ವ್ಹಯಾಚೆ ಆಂದಿ ರಾಹುನಿ ");
INSERT INTO gok_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","ಹಿ ಕಾಯಾಫಾಚಿ ಸ್ವತಾಚಿ ಯವಜ್ನಾ಼ ನವ್ಹ. ತ್ಯೊ ತ್ಯಾ ವರ್ಸಾತ್ ಮುಖ್ಯ ಯಾಜಕ್ ಜಾ಼ಲ್ಥಾ ಮನ್ಹುನ್ ಯೆಹುದ್ಯಾಂಚಾ ಲೊಕಾಸಾಟಿ ಯೇಸು ಮರ್ನಾರ್ ಮನ್ಹುನ್ ತ್ಯನಿ ಪ್ರವಾದನೆ ಕಿಲ್ತಿ. ");
INSERT INTO gok_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","ವ್ಹಯ್ ಯೆಹುದ್ಯಾಂಚೆ ಸಾಟಿ ದುನೆತ್ ಪಗಾಳ್ಯಾಲ್ಯಾ ದೇವಾಚಾ ಪೊರಾನಾ ಯೇಕ್ ಕರಾಯಾ ಸಾಟಿ ತ್ಯೊ ಮರ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","ತಿಥ್ನಿ ದರ್ನಿ ಯೆಹುದಿ ಜಾಂತ ಯೇಸುಲಾ ಮಾರಾಯಾ ಪಿತ್ತುರಿ ಕರಾಯಾ ಲಾಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","ಮನ್ಹುನ್ ಯೇಸು ಯಹುದ್ಯಾಂಚೆ ಮದ್ದಿ ರಾಜಾರೊಸ್ ಫಿರ್ಲಾ ನಾಹಿ. ಫನ್ ತ್ಯೊ ಜಾ಼ಗಾ ಸುಡುನ್ ಯಕಾನ್ಸಿ ರಾನಾಚೆ ಜ಼ವಳ್ ಆಸಲ್ಯಾಲ್ಯಾ ಎಪ್ರಾಯೀಮ್ ಮಂಥ್ಯಾಲ್ಯಾ ಗಾವಾತ್ ಆಪ್‌ಲ್ಯಾ ಶಿಶಾಂಚೆಸಂಗ ರಾಯ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","ತವಾ ಯೆಹುದ್ಯಾಂಚಾ಼ ವಲ್ಯಾಂಡಾಚಾ಼ ಸನ್ ಯಯಾಚಾ಼ ಹುತ್ತಾ ಖುಬ್ ಲೊಕ ಆಪ್‌ಲ್ಯಾ ಗಾವಾತ್ನಿ ವರ್ ಯೆರುಸಲೇಮಿತ್ ಗಿಲ್ತಿತ ತೀ ವಲಾಂಡ್ಯಾಚಾ ಸನಾಚೆ ಆಂದಿ ಆಸಿ ತೀ ಧಾರ್ಮಿಕ್ ಪದ್ದತಿಚೆಗತ್ ಶುದ್ದ ಕರಾಯಾ ಗಿಲಿತ. ");
INSERT INTO gok_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","ಆನಿ ತೇ ಯೇಸುಲಾ ಸುದಿತ್ ದೇವ್ಳಾತ್ ಉಬ ರಾಹುನ್ ತುಮಿ ಕ್ಯಾ ಯವಸ್ತಾಸಾ ಕ್ಯಾ ಖರ‍್ಯಾನಿಸ್ ತ್ಯೊ ಹ್ಯಾ ಸನಾಲಾ ಯನಾರ್ನಾಹಿ ಕ್ಯಾ? ಮನ್ಹುನ್ ಯಕಾಮಕಾಲಾ ಇಚಾರಾಯಾ ಲಾಗ್ಲ ");
INSERT INTO gok_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","ಆನಿ ತ್ಯಂಚಾನಿ ತ್ಯೊ ಆಸಲ್ಯಾಲಾ ಜಾ಼ಗಾ ಕುನಾಲಾ ತರಿ ಸಮಾಜ್ಲಾ಼ತ ಆಮಾನಾ ಸುಸ್ನಾ ದೇವಾ ಮನ್ಹುನ್ ಖಡ್ಯಾವ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","ವಲ್ಯಾಂಡಾಚಾ ಸನಾಲಾ ಆಜು಼ನ್ ಸಾ ದಿಸ್ ಆಸ್ಥಾನಾ ಯೇಸು ಬೆತಾನಿತ್ ಗೆಲಾ. ಲಾಜರಾಚ಼ ಗಾವುಸ್ ಬೆತಾನಿ. ಯೇಸುನಿ ಮೆಲ್ಯಾಲಾ ಜಿತ್ತಾ ಕೆಲ್ಯಾಲಾ ಮಾನುಸುಸ್ ಲಾಜ಼ರ್. ");
INSERT INTO gok_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","ತ್ಯಂಚಾನಿ ಯೇಸುಲಾ ರಾತಿಚ಼ ಜೆವಾನ್ ತಯಾರ್ ಕೆಲ. ಮಾರ್ಥಾ ಸೇವಾ ಕರೀತಿ. ಯೇಸು ಸಂಗ ಜೆವಾನ್ ಖಾತ್ಯಾಲ್ಯಾತ್ ಲಾಜ಼ರ್ಬಿ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","ತವಾ ಮರಿಯಾನಿ, ಜಟಾ ಮಾಸ ವಾಸಾಚಾ ತೆಲಾಚಿ ಖುಬ್ ಕಿಮ್ತಿಚಿ ಬರ್ನಿ ಆನುನ್, ಯೇಸುಚಾ ಪಾಯಾವ ವತ್ಲ. ಆನಿ ತಿನಿ ಆಪ್‌ಲ್ಯಾ ಕೆಸಾಂಚಾನಿ ತ್ಯಚ಼ ಪ್ಯಾ ಪುಸ್ಲ. ತ್ಯಾ ತೆಲಾಚಾ಼ ಚಾ಼ಂಗ್ಲಾ ವಾಸ್ ಘರ್ಬರ್ ಜಾ಼ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","ಇಸ್ಕರಿತ್ ಯುದ್ ತಿಥ ಹುತ್ತಾ. ತ್ಯೊ ಯೇಸುಚಾ ಶಿಶಾತ್ಲಾ ಯೊಕ್ ಜಾ಼ಲ್ಥಾ. ಮೊರ‍್ಹ, ಯೇಸುಲಾ ದರುನ್ ದೆತ್ಯಾಲಾ ಹ್ಯೊಸ್. ");
INSERT INTO gok_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","ತ್ಯೊ, “ತ್ಯ ವಾಸಾಚ಼ ತ್ಯಾಲ್ ತಿನ್ಸೆ ಚಾ಼ಂದಿಚಾ ಆನ್ಯಾನಾ ಇಕುನ್ ತೇ ಗರಿಬಾನಾ ಕಾ ದಿಲ ನಾಹಿ? ಮನ್ಲಾ ");
INSERT INTO gok_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","ಫನ್ ಯುದಾಲಾ ಗರಿಬಾಂಚಿ ಕ್ಯಾಳ್ಜಿ ನವ್ಥಿ. ಫನ್ ತ್ಯೊ ಚೊ಼ರ್ ಹುತ್ತಾ. ಆನಿ ಪೈಶಾಂಚಿ ಪಿಸ್ವಿ ತ್ಯಚಾ ತಾಬ್ಯಾತ್ ಹುತ್ತಿ. ತ್ಯಾತ್ಲ ಪೈಸ ಚು಼ರುನ್ ಆಪ್‌ಲ್ಯಾ ಕಾಮಾಲಾ ವಾಪ್ರಿತಾ. ಮನ್ಹುನ್ ತಸಾ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","ಯೇಸುನಿ ತ್ಯಲಾ, “ತಿಲಾ ಥಾಂಬ್ವು ನಕೊಸ್. ಮಾಜೆ ಮಾತಿಚಾ ದಿಸಾದಿಸಿ ಕರಾಚ಼ ಕಾಮ್ ತಿ ಆತಾ ಕರ್ತೆ. ");
INSERT INTO gok_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","ಗರಿಬ ಕವಾಬಿ ತುಮ್ಚಿ ಸಂಗ ರಾಥ್ಯಾತ ಫನ್ ಮಿ ತುಮ್ಚಿ ಸಂಗ ಖಾಯಿಮ್ ರಾಹಿತ್ ನಾಹಿ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","ಯೇಸು ಬೆತಾನಿತ್ ಹಾ ಮನ್ಯಾಚ಼ ಯೆಹುದ್ಯಾಂಚಾನಿ ಐಕುನ್ ಆನಿ ಲಾಜ಼ರಾಲಾ ಬಗಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ತಿಥ ಗಿಲಿತ. ಯೇಸುನಿ ಜಿತ್ತಾ ಕೆಲ್ಯಾಲಾ ಲಾಜ಼ರ್. ");
INSERT INTO gok_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","ಫನ್ ಮುಖ್ಯ ಯಾಜಕಾಂಚಾನಿ ಲಾಜ಼ರಾಲಾಬಿ ಮಾರುನ್ ಟಾಕಾಯಾ ಪಾರ್ಖಿ ಕೆಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ಲಾಜ಼ರಾಸ್ ಲಾಗುನ್ ಖುಬ್ ಯೆಹುದಿ ಲೊಕ ಆಪ್‌ಲ್ಯಾ ಜಾಂತ್ಯಾನಾ ಸುಡುನ್ ಯೇಸುವ ಇಸ್ವಾಸ್ ಥಿವಿತಿತ. ");
INSERT INTO gok_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","ದಿಸ್ರೆದಿಸಿ, ವಲಾಂಡ್ಯಾಚಾ ಸನಾಲಾ ಆಲ್ಯಾಲ್ಯಾ ಲೊಕಾಂಚಾ ಮೊಟ್ಯಾ ಹಿಂಡಾನಿ ಯೇಸು ಯೆರುಸಲೇಮಿತ್ ಯತ್ಯೊ ಮನ್ಹುನ್ ಬಾತ್ನಿ ಐಕ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ಆನಿ ಲೊಕ ಖರ್ಜುರಾಚಾ ಢಾಳ್ಯಾ ಗಿವುನ್ ತ್ಯಲಾ ಬಗಾಯಾ ಗಿಲಿತ. ಆನಿ “ಹೊಸನ್ನಾ” ಪ್ರಭುಚಾ ನಾವಾನಿ ಯತ್ಯಾಲ್ಯಾಲಾ ದೇವ್ ಆಶಿರ್ವಾದ್ ಕರುನಿ, ಇಸ್ರಾಯಲಾಚಾ ರಾಜಾಲಾ ದೇವ್ ಆಶಿರ್ವಾದ್ ದಿವುನಿ. ಆಸಿ ತೀ ವರ್ಡುನ್ ಸಾಂಗಿತಿತ. ");
INSERT INTO gok_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","ಯೇಸುಲಾ ಯಾಕ್ ಗಾಡಾವ್ ಗಾವ್ಲ, ತ್ಯಚಿವ ಬಸುನ್ ನಿಗಾಲಾ. ಧರ್ಮಶಾಸ್ತಾರ್ ಸಾಂಗತ್ಯಾ ಶಾರ್ಕ ಹ್ಯ ಗಡ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“ಚಿಯೊನ್ ಪೆಠತ್‌ಲ್ಯಾ ಲೊಕಾನಾ, ಭಿಹು ನಕೊಸಾ! ಬಗಾ! ತುಮಚಾ಼ ರಾಜಾ಼ ತ್ಯೊ. ತ್ಯೊ ಗಾಡ್ವಾಚಾ ಪೊರಾವ ಬಸುನ್ ಯತ್ಯೊ. ");
INSERT INTO gok_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","ಯೇಸುಚಾ ಶಿಶಾಂಚಾನಿ ಆಂದಿ ಹ್ಯ ಸಮ್‍ಜು಼ನ್ ಗೆತ್ಲ ನಾಹಿ. ಫನ್ ಯೇಸು ಮೈಮಾನಿ ಜಿತ್ತಾ ವ್ಹವುನ್ ಉಟ್‌ಲ್ಯಾ ನಂತರ್, ಹ್ಯಾ ಗುಸ್ಟಿ ಧರ್ಮಶಾಸ್ತಾರಾತ್ ಲಿವ್‍ಲ್ಯಾತಾ ಮನ್ಹುನ್ ಶಿಶಾನಾ ಯಾದ್ ಆಲಿ; ಲೊಕ ಹೆ ತರನಿ ತ್ಯಚಿ ಸಂಗ ಚಾ಼ಲ್ಲಿತ ತವಾ. ");
INSERT INTO gok_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","ಯೇಸುನಿ ಲಾಜ಼ರಾಲಾ ಮಸುರ್ಡಿತ್ನಿ ಬಾಹಿರ್ ಹಾಕಟ್‌ಲ್ಯಾಲ ಆನಿ ಮರ್ನಾತ್ನಿ ಜಿತ್ತಾ ಕೆಲ್ಯಾಲ ತ್ಯಚೆ ಮಾಗ ಆಸಲ್ಯಾಲ್ಯಾಂಚಾನಿ ಬಗ್ಲ ಆನಿ ಸಾಕ್ಶಿ ದಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","ಯೇಸುನಿ ಕೆಲ್ಯಾಲಿ ಹಿ ಚಮತ್ಕಾರಾಚಿ ಕಾಮ ಐಕುನ್, ಲೊಕ ಹಿಂಡಾ ಹಿಂಡಾನಿ ಯೇಸುಲಾ ಬೆಠಾಯಾ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","ಮನ್ಹುನ್ ಫರಿಸಾಯ್, “ಬಗುನ್! ಆಮ್ಚಿ ಯವಜ್ನಾ಼ ಉಪೆಗ್ ಜಾ಼ಲಿ ನಾಹಿ. ದುನ್ಯಾ ಸಗ್ಳಿ ತ್ಯಚೆ ಮಾಗ್ನಿ ಜಾ಼ಯಾ ಲಾಗ್ಲಿ!” ಮನ್ಹುನ್ ಯಕಾಮಕಾಲಾ ಬೊಲ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","ವಲಾಂಡ್ಯಾಚಾ ಸನಾಲಾ ಆರಾಧನ್ ಕರಾಯಾ ಯೆರುಸಲೆಮಿತ್ ಆಲ್ಯಾಲ್ಯಾತ್ ಥೊಡ್ ಗ್ರೀಕ್ಬಿ ಹುತ್ತ. ");
INSERT INTO gok_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","ತೇ ಗಲಿಲಾಯಾಚಾ ಬೆತ್ಸಾಯಿ ಗಾವಾತಲ್ಯಾ ಫಿಲಿಪ್ಪಾಪ ಗಿಲಿತ. “ಆನಿ ಸಾಯಬಾ, ಆಮಿ ಪ್ರಭು ಯೇಸುಲಾ ಬಗಾಯಾ ವ್ಹಯಿ” ಮನ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","ಫಿಲಿಪ್ಪ ಆಂದ್ರೆಯಾಪ ಗೆಲಾ ತ್ಯಾ ದೊಗಾಂಚಾನಿ ಯೇಸುಪ ಜಾ಼ವುನ್ ಹಿ ಖನ್ಕತ್ ಸಾಂಗ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","ಯೇಸುನಿ ಉತ್ತರ್ ದಿಲಾ, “ಮಾನ್ಸಾಚಾ಼ ಲ್ಯೊಕ್ ಆಪ್ನು ಮೈಮಾ ಗಿಯಾಚಾ಼ ಯೊಳ್ ಆತಾ ಆಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","ಮಿ ತುಮಾನಾ ಖರ ಸಾಂಗ್ತೊ. ಕುಟ್ಪರ‍್ಯಾತ್ ಘವ್ಹಾಚಾ಼ ಯೊಕ್ ದಾನಾ ಜಿಮ್ನಿವ ಪಡುನ್ ಮರತ್ ನಾಹಿ. ತಬರ್ ತ್ಯ ಯಾಕುಸ್ ರಾಥ ಕವಾ ತ್ಯ ಮರ್ತ ತವಾ ಮೆಜಾ಼ಯಾ ವ್ಹಯಿತ್ ನಾಹಿ ತ್ಯವ್ಡ ಘಹು ಉತ್ಪನ್ ಕರ್ತ. ");
INSERT INTO gok_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","ಕೊನ್ ಆಪ್ಲಾ ಸ್ವತಾಚಾ ಜೀವಾಚಿ ಮಾಯಾ ಕರ್ತೊ ತ್ಯೊ ತ್ಯ ಸಾಂಡುನ್ ಗೆತೊ. ಕೊನ್ ಆಪ್ಲಾ ಸ್ವತಾಚಾ ಜಿವ್ ದ್ವೆಶ್ ಕರ್ತೊ ತ್ಯೊ ಶಾಶ್ವತ್ ಜಿವಾಲಾ ರಾಕುನ್ ಥೆವ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","ಕೊನ್ ಮಾಜಿ ಸೇವಾ ಕರಾಯಾ ವ್ಹಯಿ ಮಂಥೊ ತ್ಯೊ ಮಾಜೆ ಮಾಗ್ನಿ ಯಯಾಸ್ ವ್ಹಯಿ. ಆನಿ ಮಾಜ಼ ಸೇವಕ್ ಮಿ ಕುಠ ಹಾ ತಿಥ ರಾನ್ಹಾರ್. ಆನಿ ಮಾಜಾ಼ ಬಾ ಮಾಜಿ ಸೇವಾ ಕೊನ್ ಕರ್ತ್ಯೊ ತ್ಯಲಾ ಆದಾರ್ ಕರ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","ಯೇಸುನಿ ಬುಲಿ ಚಾ಼ಲು ಕರುನ್, “ಆತಾ ಮಾಜಾ಼ ಜೀವ್ ಗಾಬಾರಲ್ಯಾ. ಮಿ ಕ್ಯಾ ಸಾಂಗು? “‘ಬಾ, ಹ್ಯೊ ಯೊಳ್ ಮಾಜಿವ ಯವು ದಿವುನಕೊಸ್ ಮನ್ಹುನ್ ಸಾಂಗು ಕ್ಯಾ”? ಕಾ ಮಂಜೆ ಮಿ ಹ್ಯಾ ತರಾಸಾಚಾ ಯಳಾತ್ನಿ ಜಾ಼ಯಾ ವ್ಹಯಿ. ");
INSERT INTO gok_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","ಬಾ, ತುಜ಼ ನಾವ್ ಮೊಟ ಕರ್!” ಮನ್ಲಾ. ತವಾ ಸ್ವರ್ಗಾತ್ನಿ, “ ಮೊಟ ಕೆಲ್ಯಾ ಆನೀಕ್ ಮೊಟ ಕರ್ನಾರ್.” ಆಸಾ ಆವಾಜ಼್ ಆಲಾ ");
INSERT INTO gok_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","ತಿಥ ಉಬಿ ರಾಯ್‌ಲ್ಯಾಲ್ಯಾ ಲೊಕಾಂಚಾನಿ ಹ್ಯೊ ಆವಾಜ಼್ ಐಕುನ್, “ತ್ಯ ಗರಾಜ಼ಲ್ಯಾಲ” ಮನ್ಲ. ಫನ್ ದುಸ್ರಿ ಲೊಕ, “ದೇವ್ದುತ್ ಯೊಕ್ ಯೇಸು ಸಂಗ ಬೊಲ್ಲಾ ಮನ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","ಯೇಸುನಿ ಲೊಕಾನಾ, “ತ್ಯೊ ಆವಾಜ಼್ ಜಾ಼ಲ್ಯಾಲಾ ಮಾಜಾ ಬರ‍್ಯಾ ಸಾಟಿ ನವ್ಹ, ತುಮ್ಚಾ ಬರ‍್ಯಾ ಸಾಟಿ. ");
INSERT INTO gok_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","ಆತಾ ಹ್ಯಾ ಲೊಕಾಚಾ಼ ನ್ಯಾಯಿ ತಿರ್ಮಾನ್ ವ್ಹಯಚಾ಼ ಯೊಳ್ ಆಲ್ಯಾ. ಆತಾ ಹೆ ದುನೆಚಾ ಅಧಿಕಾರ‍್ಯಾಲಾ ಬಾಹಿರ್ ಢಕಲ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","ಮಿ ಕವಾ ಹೆ ದರ್ಥಿವ್ಲಾ ವರ್ ಜಾ಼ನಾರ್. ತವಾ ಸಗ್‌ಳ್ಯಾ ಲೊಕಾನಾ ಮಿ ಮಾಜಿಕ್ಡ ಗೆನಾರ್” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","ಆಪ್ನು ಕಸಾ ಮರ್ನಾರ್ ಮನ್ಹುನ್ ಯೇಸುನಿ ಹೆ ಬುಲಿನಿ ದಾವುನ್ ದಿಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","ಲೊಕಾಚಾಂನಿ ಉತ್ತರ್ ದಿಲಾ, “ಕ್ರಿಸ್ತ ಶಾಶ್ವತ್ ಜೀವ್ನಾ ಕರ್ನಾರ್ ಮನ್ಹುನ್ ಆಮಚ಼ ಧರ್ಮಶಾಸ್ತಾರ್ ಸಾಂಗ್ತ. ಆನಿ, ‘ಮಾನ್ಸಾಚಾ಼ ಲ್ಯೊಕ್ ವರ್ ಉಚ಼ಲ್ನಾರ್’ ಮನ್ಹುನ್ ತು ಸಾಂಗಾಚ ಕಾ? ಹ್ಯೊ ಮಾನ್ಸಾಚಾ಼ ಲ್ಯೊಕ್ ಕೊನ್? ");
INSERT INTO gok_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","ತ್ಯವಾ ಯೇಸು ತ್ಯನಾ, “ಆನಿ ಥೊಡ ದಿಸ್ ತ್ಯವ್ಡಸ್ ಉಜಿಡ್ ತುಮ್ಚಿ ಸಂಗ ರಾನ್ಹಾರ್. ಕುಟ್ಪರ‍್ಯಾತ್ ಉಜಿಡ್ ಹಾ ತಿತ್ಪರ‍್ಯಾತ್ ಚಾ಼ಲತ್ ರಾವ್ಹಾ. ಕಾ ಮಂಜೆ ಅಂದಾರಾನಿ ತುಮಾನಾ ಜಾ಼ಕುನ್ ಗಿಹುನಾಹಿ. ಅಂದಾರಾತ್ ಚಾ಼ಲತ್ಯಾಲ್ಯಾಲಾ ಆಪ್ನು ಕುಠ ಜಾ಼ತ್ಯೊ ಮನ್ಹುನ್ ಸಮಜ಼ತ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","ಕುಟ್ಪರ‍್ಯಾತ್ ಉಜಿಡ್ ತುಮ್ಚಿ ಸಂಗ ಹಾ ತಿತ್ಪರ‍್ಯಾತ್ ತ್ಯಚಿವ ಇಸ್ವಾಸ್ ಥೆವಾ. ತ್ಯಚಿಸಾಟಿ ಉಜಿಡಾಚಿ ವ್ಹಸಿಲಾ” ಮನ್ಲಾ. ಹ್ಯಾ ಖನ್ಕತಿ ಸಾಂಗ್‌ಲ್ಯಾ ನಂತರ್ ಯೇಸು ತಿಥ್ನಿ ನಿಗುನ್ ಗೆಲಾ, ಆಪ್ಲೆ ಆಪ್ನುಸ್ ದಡಾಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","ಯೇಸುನಿ ಖುಬ್ ಚಮತ್ಕಾರಾಚಿ ಕಾಮ ತ್ಯಂಚೆ ಮೊರ‍್ಹ ಕಿಲಿತ. ತರಿಬಿ ತ್ಯಚಾಂನಿ ತ್ಯಚಿವ ಇಸ್ವಾಸ್ ಥೆವ್ಲಾ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ಹ್ಯಚಿಸ್‌ ಲಾಗುನ್, ಪ್ರವಾದಿ ಯೆಶಾಯಾನಿ ಸಾಂಗ್‌ಲ್ಯಾಲ ತ್ಯ ಖರ ಪುರ್ನ ವ್ಹವುನಿ. ತ್ಯ ಕ್ಯಾ ಮಂಜೆ. “ಪ್ರಭು, ಆಮ್ಚಾ ಸಾಂಗ್‌ನ್ಯಾವ ಕುನಿ ಇಸ್ವಾಸ್ ಥೆವ್ಲಾ? ಪ್ರಭುಚ಼ ಬಳ್ ಕುನಾವ ಪ್ರಗಟ್ ಕೆಲ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","ತ್ಯಂಚಿಸ್ ಲಾಗುನ್ ಲೊಕಾನಾ ಇಸ್ವಾಸ್ ತೆವಾಯಾ ಜಾ಼ಲಾ ನಾಹಿ. ಕಾ ಮಂಜೆ ಯೆಶಾಯಾನಿ ಆನಿ ಯಕಿಕ್ಡ ಆಸ ಸಾಂಗ್ಲ: ");
INSERT INTO gok_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","ದೇವಾನಿ ತ್ಯಂಚ಼ ಡೊಳ್ ಆಂದ್ಳ ಕೆಲ್ಯಾತ ಆನಿ ತ್ಯಂಚಿ ಮನ ಕಟೊರ್ ಕೆಲ್ಯಾತ ಆನಿ ತ್ಯಂಚಾನಿ ಆಪಲ್ಯಾ ಡೊಳ್ಯಾನಿ ಬಗು ನಾಹಿ ಆಪ್ಲೆ ಬುದ್ದಿನಿ ಸಮಜು಼ನ್ ಗಿಹು ನಾಹಿ. ಆನಿ ತೀ ಮಾಜಿಕ್ಡ ಪರ್ತುನಾಹಿ ಆಸ ಮಿ ತ್ಯನಾ ಬರ ಕರುನಾಹಿ. ಮನ್ಹುನ್ ");
INSERT INTO gok_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","ಯೆಶಾಯಾನಿ ಹ್ಯ ಸಾಂಗ್‌ಲ್ಯಾಲ ಕ್ಯಾ ಮಂಜೆ ತ್ಯನಿ ತ್ಯಚಿ ಮೈಮಾ ಬಗ್ಲಿ ಹುತ್ತಿ ಆನಿ ತ್ಯಚೆ ಗುಶ್ಟಿತ್ ಬೊಲ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","ತವಾ ಖುಬ್ ಲೊಕಾಚಾಂನಿ ಯೇಸುವ ಇಸ್ವಾಸ್ ಥೆವ್ಲಾ. ಖುಬ್ ಯೆಹುದಿ ಅಧಿಕಾರಿಂಚಾನಿ ಸಾಹಿತ್ ಯೇಸುವ ಇಸ್ವಾಸ್ ಥೆವ್ಲಾ. ಫನ್ ತ್ಯಂಚಾನಿ ಫರಿಸಾಯಾನಾ ಬಿಹುನ್ ಆಪ್ಲಾ ಇಸ್ವಾಸ್ ಬಾಹಿರ್ ದ್ಯಾವ್ಲಾ ನಾಹಿ. ಆಪ್ಲ ಫರಿಸಾಯ್ ಸಬಾಸ್ತಾನಾತ್ನಿ ಬಾಹಿರ್ ಗ್ಯಾಲ್ನಾರ್ ಮನ್ಹುನ್ ತ್ಯನಾ ಭೆ ಹುತ್ತ. ");
INSERT INTO gok_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","ತ್ಯನಾ ಮಾನ್ಸ ದೆತ್ಯಾಲಿ ಮರ‍್ಯಾದ್ ದೇವಾಚೆ ಮರ‍್ಯಾದಿವ್ನಿ ಮುಟಿ ಜಾ಼ಲ್ಥಿ. ");
INSERT INTO gok_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","ನಂತರ್ ಯೇಸು ಜೊ಼ರಾನಿ ಆಸಾ ಮನ್ಲಾ: “ಕೊನ್ ಮಾಜಿವ ಇಸ್ವಾಸ್ ಥೆವ್ತೊ ತ್ಯೊ ಮಾಜಿವ ತ್ಯವ್ಡಾಸ್ ನವ್ಹ ಮನಾ ಲಾವುನ್ ದಿಲ್ಯಾಲ್ಯಾವಬಿ ಇಸ್ವಾಸ್ ಥೆವ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","ಮನಾ ಕೊನ್ ಬಗ್ನಾರ್ ತ್ಯೊ ಮನಾ ತ್ಯವ್ಡಸ್ ನವ್ಹ ಮನಾ ಲಾವುನ್ ದಿಲ್ಯಾಲ್ಯಾಲಾಬಿ ಬಗ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","ಮಿ ದುನೆತ್ ಉಜಿಡಾಚಾ ರುಪಾತ್ ಆಲ್ಯೊ ಕಾ ಮಂಜೆ ಕೊನ್ ಮಾಜಿವ ಇಸ್ವಾಸ್ ಥೆವ್ನಾರಾ ತ್ಯೊ ಆಂದಾರಾತ್ ರಾಹುನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","ಕೊನ್ ಮಾಜಾ಼ ಸಮಾಚಾರ್ ಐಕುನ್ ತ್ಯಚಿವ ಇಸ್ವಾಸ್ ಥಿವಿತ್ ನಾಹಿ ಮಿ ತ್ಯಚಾ಼ ನ್ಯಾಯಿ ತಿರ್ಮಾನ್ ಕರ್ನಾರ್ ನಾಹಿ ಕಾ ಮಂಜೆ ಮಿ ನ್ಯಾಯಿ ಕರಾಯಾ ಆಲೊನಾಹಿ ತ್ಯನಾ ರಕ್ಶನ್ ಕರಾಯಾ ಆಲ್ಯೊ. ");
INSERT INTO gok_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","ಕೊನ್ ಮನಾ ನಕ್ವಾಟ್ ಕರ್ತೊ ಮಾಜಾ ಬೊಲ್ಯಾ ಮಾನಿತ್ನಾಹಿ ತ್ಯನಾ ನ್ಯಾಯಿ ತಿರ್ಮಾನ್ ಕರ್ತ್ಯಾಲಾ ಯೊಕ್ ಹಾ ತ್ಯೊ ಮಿ ಸಾಂಗ್‌ಲ್ಯಾಲ ಮಾಜ಼ ವಚ಼ನುಸ್ ಜಾ಼ಲ್ಯಾ ಸರ್ತ್ಯಾ ದಿಸಾತ್ ತ್ಯಾ ಬೊಲ್ಯಾಸ್ ತ್ಯಚಾ಼ ನ್ಯಾಯಿ ತಿರ್ಮಾನ್ ಕರ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","ಹ್ಯ ಖರ ಹಾ, ಕಾ ಮಂಜೆ ಮಿ ಮಾಜಾ ಅಧಿಕಾರಾನಿ ಕಾಯ್ ಸಾಂಗ್ಲ ನಾಹಿ ಫನ್ ಮನಾ ಲಾವುನ್ ದಿಲ್ಯಾಲ್ಯಾ ಬಾನಿ ಹುಕುಮ್ ದಿಲ್ಯಾ ಮಿ ಕ್ಯಾ ಸಾಂಗು ಆನಿ ಸಿಕ್ವು. ಮನ್ಹುನ್ ");
INSERT INTO gok_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","ತ್ಯಚಾ ಆಜ್ಞೆ ಶಾಶ್ವತ್ ಜೀವ್ ಜಾ಼ಲ್ಯಾತಾ ತ್ಯ ಮನಾ ಠಾವ ಹಾ ಮನ್ಹುನುಸ್ ಮಿ ಬೊಲತ್ಯಾಲ ಸಗ್ಳ ಬಾನಿ ಮನಾ ಸಾಂಗ್‌ಲ್ಯಾಲಸ್. ” ");
INSERT INTO gok_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","ವಲ್ಯಾಂಡಾಚಾ ಸನಾಚೆ ಆದ್ಲೆ ದಿಸಿ ಯೇಸು ಆಪ್ನಿ ಹಿ ದುನೆ ಸುಡುನ್ ಬಾಪ ಜಾ಼ಯಾಚಾ಼ ಯೊಳ್ ಜ಼ವಳ್ ಆಲ್ಯಾ ಮನ್ಹುನ್ ಸಮಜು಼ನ್. ಹೆ ದುನೆತ್ ಆಪ್ಲಿ ಆಸಲ್ಯಾಲ್ಯಾಂಚಿ ಮಾಯಾ ಕರುನ್ , ತ್ಯಂಚಿ ಸರತ್ಯಾಪರತ್ ಮಾಯಾ ಕರಿತ್ ಆಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","ಯೇಸು ಆನಿ ತ್ಯಚ಼ ಶಿಶಾ ರಾತಿಚಾ ಜೆವ್ನಾಲಾ ಬಸ್ಲ. ಯೇಸುಚಾ಼ ಮೊಸ್ ಕರಾಯಾ ಸೈತಾನ್ ಸಿಮೊನ್ ಇಸ್ಕರಿಯುತಾಚಾ಼ ಲ್ಯೊಕ್ ಯುದಾಲಾ ಆತಾಸ್ ಯವಜ್ನಾ಼ದಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","ಯೇಸುಲಾ ಹ್ಯ ಠಾವ ಹುತ್ತ. ಬಾನಿ ಸಗ್‌ಳ್ಯಾವ ಆಪ್‌ಲ್ಯಾಲಾ ಹುಕುಮ್ ದಿಲ್ಯಾ. ತ್ಯವ್ಡಸ್ ನವ್ಹ ಆಪ್ನು ದೇವಾಪ್ನಿ ಆಲ್ಯೊ ಮನ್ಹುನ್ ಆನಿ ಆತಾ ದೇವಾಪ ಪರ್ತುನ್ ಜಾ಼ನಾರ್ ಮನ್ಹುನ್ ತ್ಯಲಾ ಠಾವ ಹುತ. ");
INSERT INTO gok_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","ತೆ ಜೆವ್‍ತ್ಯಾಲ ಆಸ್ಥಾನಾ ಯೇಸುನಿ ಉಠುನ್ ಆಪ್ಲಿ ವೈಲಿ ಆಂಗಿ ಕಾಡುನ್ ಯೊಕ್ ಟವಲ್ ಗಿಹುನ್ ಕಂಬ್ರಲಾ ಬ್ಯಾಂದ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","ನಂತರ್ ಯಕಾ ತಪಲ್ಯಾತ್ ಪಾನಿ ಬರುನ್ ಶಿಶಾಂಚ಼ ಪ್ಯಾ ದುತ್ಲ. ಆನಿ ಆಪ್ನು ಬ್ಯಾಂದ್‍ಲ್ಯಾಲ್ಯಾ ಟವಲಾನಿ ತ್ಯಂಚ಼ ಪ್ಯಾ ಪುಸ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","ತ್ಯೊ ಸಿಮೊನ್ ಪೇತ್ರಾಪ ಆಲಾ ತವಾ ಪೇತ್ರಾ, “ಪ್ರಭು, ತು ಮಾಜ಼ ಪ್ಯಾ ದುತ್ಯೊಸ್? ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","ಯೇಸುನಿ, “ಆತಾ ಮಿ ಕ್ಯಾ ಕರ್ತ್ಯೊ ಮನ್ಹುನ್ ತುಮಾನಾ ಠಾವ ನಾಹಿ. ಫನ್ ಮೊರ‍್ಹ ತುಲಾ ಸಮಾಜ್ನಾ಼ರ್” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","ಪೇತ್ರಾ ತ್ಯಲಾ ಮನ್‍ಲ್ಹಾ, “ನಾಹಿ! ಮಾಜ಼ ಪ್ಯಾ ತು ಕಂದಿಸ್ ದುಯಾಚ಼ ನವ್ಹತ” ಯೇಸು ಮನ್‍ಲ್ಹಾ, “ತುಜ ಪ್ಯಾ ಮಿ ದುತ್ಲ ನಾಹಿತ, ತು ಹಿತ್ನಿ ಮೊರ‍್ಹ ಮಾಜಾ಼ ಶಿಶಾ ವ್ಹಯಾ ವ್ಹಯಿತ್ನಾಹಿ. ” ");
INSERT INTO gok_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","ತವಾ ಸಿಮೊನ್ ಪೇತ್ರಾನಿ, “ಪ್ರಭು, ಮಾಜ಼ ಪ್ಯಾ ತ್ಯವ್ಡಸ್ ನವ್ಹ ಮಾಜ಼ ಹಾತ್ ಆನಿ ಡುಯಿ ದು!” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","ಯೇಸುನಿ ತ್ಯನಾ ಸಾಂಗ್ಲ, “ಕುನಿ ಆಂಗುಳ್ ಗೆತ್ಲೆ ತ್ಯನಿ ಆಪ್ಲ ಪ್ಯಾ ತ್ಯವ್ಡಸ್ ಸುಡುನ್ ದುಸ್ರ ಕಾಯ್ ದುಯಾಚಿ ಗರಜ಼ ನಾಹಿ ತುಮಿ ಶುದ್ದ ಹಾಸಾ ನವ್ಹ. ");
INSERT INTO gok_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","ತ್ಯಲಾ ಠಾವ ಹುತ್ತ. ಕೊನ್ ತ್ಯಲಾ ಫಸ್ವುನ್ ದರುನ್ ದೆತೊ ಮನ್ಹುನ್ ತ್ಯಚಿಸಾಟಿ ತ್ಯನಿ ಸಾಂಗ್ಲ ತುಮ್ಚಾತ್ಲಿ ಸಗ್ಳಿ ಶುದ್ದ ನವ್ಹ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","ಯೇಸುನಿ ತ್ಯಚ಼ ಪ್ಯಾ ದುತ್‌ಲ್ಯಾ ನಂತರ್ ಆಪ್ಲಿ ವೈಲಿ ಆಂಗಿ ಗಾಲ್ಹುನ್ ಪರತ್ ಆಪ್‌ಲ್ಯಾ ಜಾ಼ಗ್ಯಾವ ಬಸ್ಲಾ ಆನಿ ತ್ಯನಿ ಸಾಂಗ್ಲ: “ಆತಾ ಮಿ ತುಮ್ಚೆ ಸಾಟಿ ಕೆಲ್ಯಾಲ ಕ್ಯಾ ಮನ್ಹುನ್ ತುಮಾನಾ ಸಮಾಜ಼್ಲ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","ತುಮಿ ಮನಾ, ‘ಗುರು, ಪ್ರಭು’ ಮನ್ಹುನ್ ಹಾಕಟ್ಟಾಸಾ. ಹ್ಯ ಶಾರ್ಕ ಹಾ. ಕಾ ಮಂಜೆ ಮಿ ತ್ಯೊಸ್ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","ಹ್ಯಚಿ ಸಾಟಿ ಮಿ ಪ್ರಭು ಆನಿ ಗುರು ವ್ಹವುನ್ ತುಮಚ಼ ಪ್ಯಾ ದುತ್ಲ. ತುಮಿ ಸಾಹಿತ್ ಯಕಾ ಮಕಾಚ಼ ಪ್ಯಾ ದುಹ್ಯಾಸಾಟಿ. ");
INSERT INTO gok_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","ಹ್ಯಾ ಕಾಮಾನಿ ಮೀಸ್ ತುಮಾನಾ ಯೆಕ್ ಉದಾರನ್ ಜಾ಼ಲ್ಯೊ. ಕಾ ಮಂಜೆ ಮಿ ತುಮಾನಾ ಕೆಲ್ಯಾ ಶಾರ್ಕ ತುಮಿ ಯಕಾ ಮಕಾಲಾ ಕರಾ. ");
INSERT INTO gok_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","ಮಿ ತುಮಾನಾ ಖರ ಸಾಂಗ್ತೊ. ಸೇವಕ್ ದನ್ಯಾವ್ನಿ ಮೊಟಾ ನವ್ಹ. ಮನ್ಹುನ್ ಬಾತ್ನಿಸಾಂಗಾಯಾ ಸಾಟಿ ಲಾವುನ್ ದಿಲ್ಯಾಲಾ ಲಾವುನ್ ದಿಲ್ಯಾಲ್ಯಾವ್ನಿ ಮೊಟಾ ನವ್ಹ. ");
INSERT INTO gok_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","ಆನಿ ತುಮಿ ಹ್ಯ ಖರ ಸಮಾಜು಼ನ್ ಗೆತಲ್ಯಾಸಾ, ತುಮಿ ಹ್ಯ ಕೆಲ್ಯಾವ ತುಮಿ ದನ್ಯ. ");
INSERT INTO gok_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","ಮಿ ತುಮ್ಚೆ ಸಗ್‌ಳ್ಯಾಂಚೆ ಗುಸ್ಟಿತ್ ಬೊಲತ್ ನಾಹಿ. ಮಿ ನಿವಡ್‌ಲ್ಯಾಲ್ಯಾ ಲೊಕಾಂಚೆ ಗುಸ್ಟಿತ್ ಮನಾ ಠಾವ ಹಾ. ಫನ್ ‘ಮಾಜಿ ಸಂಗ ಜೆವಾನ್ ಖಾತ್ಯಾಲಾಸ್ ಮಾಜಾ಼ ಘಾತ್ ಕರ್ತೊ. ಮಂಥ್ಯಾಲಿ ಧರ್ಮ ಶಾಸ್ತಾರಾತ್ಲಿ ಬುಲಿ ಘಢಾಯಾ ವ್ಹಯಿ. ");
INSERT INTO gok_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","ಹ್ಯ ಘಡ್ಹಾಚೆ ಆಂದಿ ತ್ಯ ತುಮಾನಾ ಸಾಂಗ್‌ತ್ಯೊ. ತ್ಯ ಘಡ್ನಾರ್ ತವಾ ಮೀಸ್ ತ್ಯೊ ಮನ್ಹುನ್ ತುಮಿ ಇಸ್ವಾಸ್ ಥೆವಾಯಾ. ");
INSERT INTO gok_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","ಮಿ ತುಮಾನಾ ಖರ ಸಾಂಗ್ತೊ. ಮಿ ಲಾವುನ್ ದಿಲ್ಯಾಲ್ಯಾಲಾ ಮ್ಯಾನ್ಲಾಸಾ ತ ಮನಾ ಮ್ಯಾನ್ನಾರ್. ಆನಿ ಮನಾ ಮ್ಯಾನ್ನಾರಾ ಮನಾ ಲಾವುನ್ ದಿಲ್ಯಾಲ್ಯಾಲಾಬಿ ಮ್ಯಾಂತೊ. ");
INSERT INTO gok_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","ಯೇಸುನಿ ಹ್ಯಾ ಖನ್ಕತಿ ಸಾಂಗ್‌ಲ್ಯಾ ನಂತರ್ ಮನಾಲಾ ದುಕ್ ವ್ಹವುನ್ ಮಿ ತುಮಾನಾ ಖರ ಸಾಂಗ್ತೊ. ತುಮ್ಚಾತ್ಲಾ ಯೊಕ್ ಮಾಜಾ಼ ಘಾತ್ ಕರ್ನಾರ್ ಮನ್ಹುನ್ ಉಗ್ಡುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","ಯೇಸುಚ಼ ಶಿಶಾ ಸಗ್ಳ ಯಕಾ ಮಕಾಲಾ ಬಗಾಯಾ ಲಾಗ್ಲ. ತ್ಯೊ ಕುನಾಚೆ ಗುಶ್ಟಿತ್ ಬೊಲಾಯಾ ಲಾಗ್‌ಲ್ಯಾ ಮನ್ಹುನ್ ತ್ಯನಾ ಸಮಾಜ಼್ಲ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","ತ್ಯಚಾ ಶಿಶಾತ್ಲಾ ಯೊಕ್ ತ್ಯಚೆ ಕಡಸ್ ಬಸುನ್ ವ್ಹತ್ತಾ. ಯೇಸು ತ್ಯಚಿಸ್ ಖುಬ್ ಮಾಯಾ ಕರೀತಾ. ");
INSERT INTO gok_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","ಸಿಮೊನ್ ಪೇತ್ರಾನಿ ಹ್ಯಾ ಶಿಶಾಲಾ ಕುನಾಚೆ ಗುಶ್ಟಿತ್ ಯೇಸು ಸಾಂಗ್‌ತ್ಯೊ ಮನ್ಹುನ್ ಐಕುನ್ ಸಮಜು಼ನ್ ಗಿಹ್ಯಾ ಖುನಾ ಕರ್ತ್ಯೊ. ");
INSERT INTO gok_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","ಮನ್ಹುನ್ ತ್ಯೊ ಶಿಶಾ ಯೇಸುಕ್ಡ ವಾಕುನ್ ಪ್ರಭು ತ್ಯೊ ಕೊನ್ ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","ಯೇಸುನಿ ಹಿ ಬಾಕ್ರಿ ಮಿ ತಾಟಿತ್ ಬುಡ್ವುನ್ ತೀ ಕುನಾಲಾ ದೇತೊ ತ್ಯೊಸ್ ಮಾಜಾ಼ ಘಾತ್ ಕರ್ನಾರ್ ಮನ್ಹುನ್ ಸಾಂಗುನ್ ಬಾಕ್ರಿಚಾ಼ ತುಕ್ಡಾ ಗಿಹುನ್ ತ್ಯೊ ತಾಟೀತ್ ಬುಡ್ವುನ್ ಸಿಮೊನ್ ಇಸ್ಕರಿಯುತಾಚಾ಼ ಲ್ಯೊಕ್ ಜಾ಼ಲ್ಯಾಲ್ಯಾ ಯುದಾಲಾ ದಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","ಯುದಾನಿ ತೀ ಬಾಕ್ರಿ ಗಿತ್ಲಿ ತವಾಸ್ ಸೈತಾನ್ ತ್ಯಚೆ ಆತ್ ಬರ್ಲ. ಯೇಸುನಿ ಯುದಾಲಾ ತು ಕರಾಯಾ ವ್ಹಯಿ ಜಾ಼ಲ್ಯಾಲ ಕಾಮ್ ಬಿಗಿನಿ ಕರ್! ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","ಫನ್ ಯೇಸುನಿ ಯುದಾಲಾ ಕಾ ತಸ ಸಾಂಗ್ಲ ಮನ್ಹುನ್ ಖಾಯಾ ಬಸ್‌ಲ್ಯಾಲ್ಯಾತ್ ಯಕಾಲಾಬಿ ಸಮಾಜ಼ಲ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","ಶಿಶಾಂಚಾ ತಂಡ್ಯಾತ್‌ಲ್ಯಾ ಪೈಶಾಚೆ ಪಿಸ್ವಿಚಿ ಜವಾಬ್ದಾರಿ ಯುದಾಚಿ ಜಾ಼ಲ್ತಿ. ಮನ್ಹುನ್ ಸನಾಲಾ ಪಾಯ್ಜೆ ತಸ್ಲಿ ಥುಡಿ ಸಾಮ್ನ ಗಿಹುನ್ ಯಯಾ ಆನಿ ಗರೀಬ್ ಲೊಕಾನಾ ಕಾಯ್ ತರಿ ದಿಯಾ ಸಾಟಿ ಯೇಸುನಿ ತ್ಯಲಾ ಸಾಂಗ್ಲ ಆಸಲ್ ಮನ್ಹುನ್ ಥೊಡ್ಯಾ ಶಿಶಾಂಚಾನಿ ಸಮಜು಼ನ್ ಗೇತ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","ಯೇಸುನಿ ದಿಲ್ಯಾಲಿ ಬಾಕ್ರಿ ಗೆತಲ್ಯಾ ಬರ್ಬರ್ ಯುದ್ ತಿಥ್ನಿ ನಿಗುನ್ ಗೇಲಾ ತವಾ ರ‍್ಯಾತ್ ಜಾ಼ಲ್ಥಿ. ");
INSERT INTO gok_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","ಯುದ್ ನಿಗುನ್ ಗೇಲ್ಯಾ ನಂತರ್ ಯೇಸುನಿ ಆತಾ ಮಾನ್ಸಾಚಾ ಲೇಕಾನಿ ಮೈಮಾ ಗಿತ್ಲಿ ಆನಿ. ದೇವಾನಿ ತ್ಯಚಿಪ್ನಿ ಮೈಮಾ ಗೆತ್ಲೆ. ");
INSERT INTO gok_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","ಆನಿ ಯಕ ಯಳಿ ತ್ಯಚಿಸ್ ಲಾಗುನ್ ದೇವಾಲಾ ಮೈಮಾ ಯಯಾಚಿ ಜಾ಼ಲ್ಯಾವ ದೇವ್ ಆಪ್ಲಿಪಸ್ ಲೆಕಾಲಾ ಮೈಮೆ ಕರ್ನಾರ್. ಆನಿ ತವಾಸ್ ಮಹಿಮೆ ಕರ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","ಯೇಸು ಮಾಜಾ ಪೊರಾನು ಆಜು಼ನ್ ಥೊಡಾ ಯೊಳ್ ತ್ಯವ್ಡಾಸ್ ಮಿ ತುಮ್ಚಿ ಸಂಗ ರಾನ್ಹಾರ್ ತುಮಿ ಮನಾ ಶೊದ್ನಾರ್ ಮಿ ಯೆಹುದ್ಯಾನಾ ಸಾಂಗ್‌ಲ್ಯಾಲ ತುಮಾನಾಬಿ ಸಾಂಗ್ತೊ. ಮಿ ಜಾ಼ನಾರ್ ತಿಥ ತುಮಿ ಯನಾರ್ ನಾಹಿಸಾ. ");
INSERT INTO gok_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","ಮಿ ಯೆಕ್ ನವಿ ಆಜ್ಞೆ ತುಮಾನಾ ದೇತೊ. ಯಕಾಮಕಾಚಿ ಮಾಯಾ ಕರಾ. ಮಿ ತುಮ್ಚಿ ಮಾಯಾ ಕಸಿ ಕಿಲೆ ತಸಿಸ್ ತುಮಿ ಯಕಾಮಕಾಚಿ ಮಾಯಾ ಕರಾಯಾಸ್ ವ್ಹಯಿಸಾ. ");
INSERT INTO gok_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","ಯೆಕ್ ಯಳಿ ತುಮಿ ತುಮ್ಚಿ ಯಕಾಮಾಚಿ ಮಾಯಾ ಕಿಲಿಸಾತ್ ತುಮಿ ಮಾಜ಼ ಶಿಶಾ ಮನ್ಹುನ್ ಸಗ್‌ಳ್ಯಾನಾ ಸಮಾಜ್ನಾರ್. ಮನ್ಹುನ್ ಸಾಂಗ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","ಸಿಮೊನ್ ಪೇತ್ರ ಯೇಸುಲಾ, “ಪ್ರಭು, ತು ಕುಠ ಜಾ಼ತ್ಯೊಸ್? ಮನ್ಹುನ್ ಇಚಾರ್ತೊ. ಯೇಸು ಮನ್ಲಾ, “ಮಿ ಜಾ಼ಯಿನ್ ತಿಥ ಆತಾ ತುಲಾ ಮಾಗ್ನಿ ಯಯಾಲಾ ವ್ಹನಾರ್ ನಾಹಿ. ಫನ್ ಮಂಗ್ ತು ಮಾಗ್ನಿ ಯಸಿಲ್. ” ");
INSERT INTO gok_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","ಪೇತ್ರಾನಿ, “ಪ್ರಭು, ಆತಾ ಮಿ ತುಜೆ ಮಾಗ್ನಿ ಯಯಾಲಾ ಕಾ ವ್ಹಯಿತ್ ನಾಹಿ? ಮಿ ತುಜಿ ಸಾಟಿ ಜೀವ್ ದಿಯಾ ಉಬಾ ಹಾ!” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","ಯೇಸುನಿ ಉತ್ತರ್ ದಿಲಾ, “ತು ಮಾಜಿಸಾಟಿ ಖರ್‍ಯಾನಿಸ್ ಜೀವ್ ದೇನಾರ್ ಕ್ಯಾ? ಮಿ ತುಲಾ ಖರ ಸಾಂಗ್ತೊ, ಕೊಂಬ್ಡಾ ಬವಾಚೆ ಆಂದಿ ತು ತುಲಾ ಮಿ ಕೊನ್ ಮನ್ಹುನ್ ಠಾವಾ ನಾಹಿ ಆಸಾ ತೀನ್ ಪಾವ್ಟಿ ಸಾಂಗ್ನಾರ್. ” ");
INSERT INTO gok_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","ಯೇಸುನಿ ತುಮ್ಚಿ ಮನ ಕಳ್ವಳು ನಾಹಿತ. ದೇವಾವ ಆನಿ ಮಾಜಿವಬಿ ಇಸ್ವಾಸ್ ಥೆವಾ. ");
INSERT INTO gok_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","ಮಾಜಾ ಬಾಚಾ ಗರ‍್ಹಾತ್ ಖುಬ್ ಖೊಲ್ಯಾ ಹಾತ್ತ ಆಸ ನಸ್‌ಲ್ಯಾವ ಮಿ ತುಮ್ಚಿ ಸಾಟಿ ಜಾ಼ಗಾ ತಯಾರ್ ಕರಾಯಾ ತಿಥ ಜಾ಼ತ್ಯೊ ಮನ್ಹುನ್ ಸಾಂಗಿತ್ ನವ್ಥೊ. ");
INSERT INTO gok_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","ಮಿ ತಮ್ಚಿ ಸಾಟಿ ಜಾ಼ಗಾ ತಯಾರ್ ಕರುನ್ ಜಾ಼ಲ್ಯಾವ, ಮಾಗಾರಾ ಯವುನ್ ಮಾಜಿ ಸಂಗ ತುಮಾನಾ ನೆಥೊ. ಆಸಿ ಮಿ ರಾಹಿನ್ ತಿಥ ತುಮಿಬಿ ರಾನ್ಹಾರ್. ");
INSERT INTO gok_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","ಮಿ ಜಾ಼ತ್ಯಾಲ್ಯಾ ಜಾ಼ಗ್ಯಾಚಿ ವಾಟ್ ತುಮಾನಾ ಠಾವಿ ಹಾ ಮನ್ಹುನ್ ಸಾಂಗ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","ತೊಮಾನಿ ಯೇಸುಲಾ ಇಚಾರ್ಲ, “ಪ್ರಭು ತು ಜಾ಼ಯಾಚಾ಼ ಕುಠ ತ್ಯೊ ಆಮಾನಾ ಠಾವಾ ನಾಹಿ ಆಸ ಆಸ್ಥಾನಾ ತೀ ವಾಟ್ ಆಮಾನಾ ಠಾವಿ ಹಾ ಮನ್ಹುನ್ ಕಸಿ ಸಾಂಗ್ನಾರ್” ");
INSERT INTO gok_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","ಯೇಸುನಿ ಸಾಂಗ್ಲ, “ಮೀಸ್ ಮಾರೊಗ್, ಖರಾ, ಜೀವ್, ಜಾ಼ಲ್ಯೊ. ಬಾಪ ಮಾಜಿ ಸಂಗ ಸುಡುನ್ ದಿಸರ‍್ಯಾ ಕುನಾಸಂಗ ಜಾ಼ಯಾ ವ್ಹಯಿತ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","ಯೆಕ್ ಯಳಿ ತುಮಿ ಮನಾ ಖರ‍್ಯಾನಿಸ್ ಸಮ್‍ಜು಼ನ್ ಗೆತ್ಲಾ ಆಸ್ತಾಸಾತ ಮಾಜಾ ಬಾಲಾಬಿ ಶಾರ್ಕಾ ಸಮ್‍ಜು಼ನ್ ಗೆತ್ಲಾ ಆಸ್ಥಾಸಾ. ಫನ್ ಆತಾ ತುಮಿ ತ್ಯಲಾ ಸಮ್‍ಜು಼ನ್ ಗೆತಲ್ಯಾಸಾ ಆನಿ ಬಗ್‌ಲ್ಯಾಸಾ. ” ");
INSERT INTO gok_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","ಫಿಲಿಪ್ಪಾನಿ ಯೇಸುಲಾ ಸಾಂಗ್ಲ, “ಪ್ರಭು ಆಮಾನಾ ಬಾಲಾ ದ್ಯಾವ್ ತ್ಯವ್ಡಸ್ ಪುರೊ. ” ");
INSERT INTO gok_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","ಯೇಸುನಿ ಉತ್ತರ್ ದಿಲಾ, “ಫಿಲಿಪ್ಪಾ ಮಿ ಯವ್ಡ ದೀಸ್ ತುಜೆ ಸಂಗ ರಾಯ್ಲೊ ತರಿ ತು ಮನಾ ಸಮ್‍ಜು಼ನ್ ಗೆತ್ಲ ನಾಹಿಸ್ ಕ್ಯಾ? ಮನಾ ಬಗ್‌ಲ್ಯಾಲ್ಯಾನಿ ಬಾಲಾಬಿ ಬಗ್‌ಲ್ಯಾ ಮನ್ಹುನ್ ಬಾಲಾ ಆಮಾನಾ ದ್ಯಾವ್ ಮನ್ಹುನ್ ಕಾ ಇಚಾರ್ತಾಸಾ? ");
INSERT INTO gok_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","ಮಿ ಬಾಪ ಹಾ ಆನಿ ಬಾ ಮಾಜಿಪ ಹಾ ಮನ್ಹುನ್ ತುಮಿ ಇಸ್ವಾಸ್ ಥೆವ್ನಾರ್ ನಾಹಿಸಾ ಕ್ಯಾ? ಮಿ ಸಾಂಗ್‌ತ್ಯಾಲ್ಯಾ ಬೊಲ್ಯಾ ಮಾಜಾ ನವ್ಹತಾ ಮಾಜಿಪ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ಬಾಚಾ ಜಾ಼ಲ್ಯಾತಾ. ");
INSERT INTO gok_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","ಮಿ ಬಾಪ ಹಾ ಆನಿ ಬಾ ಮಾಜಿಪ ಹಾ ಮಂಥ್ಯಾಲೆ ಮಾಜೆ ಬುಲಿವ ಇಸ್ವಾಸ್ ಥೆವಾ ನಾಹಿತ ಮಿ ಸಾಕ್ಷಿ ಸಾಟಿ ಕೆಲ್ಯಾಲ್ಯಾ ಚಮತ್ಕಾರಾಚಿ ಕಾಮ ತರಿ ಬಗುನ್ ಮಾಜಿವ ಇಸ್ವಾಸ್ ಥೆವಾ ");
INSERT INTO gok_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","ಮಿ ತುಮಾನಾ ಖರ ಸಾಂಗ್ತೊ ಮಾಜಿವ ಇಸ್ವಾಸ್ ಥೆವ್‍ತ್ಯಾಲಾ ಮಾನುಸ್ ಮಿ ಕೆಲ್ಯಾಲಿ ಕಾಮ ಕರ್ನಾರ್ ತ್ಯೊ ಮಿ ಕೆಲ್ಯಾಲ್ಯಾ ಕಾಮಾವ್ನಿ ಮುಟಿ ಕಾಮ ಕರ್ನಾರ್ ಕಾ ಮಂಜೆ ಮಿ ಬಾಪ ಜಾ಼ತ್ಯೊ. ");
INSERT INTO gok_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","ತುಮಿ ಮಾಜಾ ನಾವಾನಿ ಕ್ಯಾ ಮಾಗ್ಲಸಾ ತರಿ ಮಿ ತ್ಯ ಕರ್ನಾರ್ ಹ್ಯಚಿಸ್ ಲಾಗುನ್ ಲ್ಯೊಕ್ ಬಾಲಾ ಮೈಮಾ ಆನ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","ತುಮಿ ಮಾಜಾ ನಾವಾನಿ ಕಾಯೇಕ್ ಮಾಗ್ಲಸಾ ತರಿ ಮಿ ತ್ಯ ಕರ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","ಜ಼ರ್ ತುಮಿ ಮಾಜಿ ಮಾಯಾ ಕರ್ತ್ಯಾಲ ಜಾ಼ಲ್ಹಾಸಾತ ಮಾಜಿ ಆಜ್ಞೆ ಪ್ಯಾಳ್ಸಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","ಮಿ ಬಾಪ ಮಾಗ್ತೊ ತವಾ ತ್ಯೊ ದುಸ್ರಾ ಮಜ಼ತ್ ಕರ್ತ್ಯಾಲ್ಯಾಲಾ ತುಮಾನಾ ದೇನಾರ್ ತ್ಯೊ ಮಜ಼ತ್ ಕರ್ತ್ಯಾಲಾ ಶಾಶ್ವತ್ ತುಮ್ಚೆ ಸಂಗ ರಾನ್ಹಾರ್ ");
INSERT INTO gok_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","ಖರ‍್ಯಾಚ಼ ಆತ್ಮಸ್ ತ್ಯೊ ಮಜ಼ತ್ ಕರ್ತ್ಯಾಲಾ ಹೆ ದುನೆನಿ ತ್ಯಲಾ ಬಗ್ಲಾನಾಹಿ ಆನಿ ಸಮ್‍ಜು಼ನ್ ಗೆತ್ಲಾನಾಹಿ. ಫನ್ ತುಮಾನಾ ತ್ಯೊ ಸಮಾಜ಼ಲ್ಯಾ ಮನ್ಹುನ್ ತ್ಯೊ ತುಮ್ಚಿ ಸಂಗ ಆನಿ ತುಮ್ಚೆ ಆತುಸ್ ರಾನ್ಹಾರ್. ");
INSERT INTO gok_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","ಮಿ ತುಮಾನಾ ಆಯಿ ಬಾ ನಸ್‌ಲ್ಯಾಲ್ಯಾ ಪೊರಾಂಚಿಗತ್ ಪರದೆಶಿ ಸುಡುನ್ ಜಾ಼ಯಿತ್ನಾಹಿ. ಮಿ ತುಮ್ಚಿಪ ಯತೊ ");
INSERT INTO gok_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","ಆನಿ ಥೊಡ ದೀಸ್ ಜಾ಼ಲ್ಯಾ ನಂತರ್ ಹೆ ದುನೆತ್ಲಿ ಲೊಕ ಮನಾ ಹಿತ್ನಿ ಮೊರ‍್ಹ ಬಗ್ನಾರ್ ನಾಹಿತ. ಫನ್ ತುಮಿ ಮನಾ ಬಗ್ನಾರ್. ಕಾ ಮಂಜೆ ಮಿ ಜಿತ್ತಾ ಹಾ ಮನ್ಹುನ್ ತುಮಿ ಜಿತ್ತಿ ರಾನ್ಹಾರ್. ");
INSERT INTO gok_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","ತೆ ದಿಸಿ ಮಿ ಮಾಜಾ ಬಾಪ ಆಸ್‌ಲ್ಯಾಲಾ ಆನಿ ತುಮಿ ಮಾಜಿಪ ಆಸ್‌ಲ್ಯಾಲಿ ಮಿ ತುಮ್ಚಿಪ ಆಸ್‌ಲ್ಯಾಲಾ ಸಮಜು಼ನ್ ಗೆನ್ಹಾರ್. ");
INSERT INTO gok_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","ಯಕಾನಿ ಮಾಜಾ ಆಜ್ಞೆ ಹು ಮನ್ಹುನ್ ತ್ಯಂಚಿಗತ್ ಚಾ಼ಲ್ಲಾತ ತ್ಯನಿ ಮಾಜಿ ಖರ‍್ಯಾನಿಸ್ ಮಾಯಾ ಕಿಲಿ, ಕೊನ್ ಮಾಜಿ ಮಾಯಾ ಕರ್ತೊ. ತ್ಯಚಿ ಮಾಜಾ಼ ಬಾ ಮಾಯಾ ಕರ್ತೊ. ಆನಿ ಮಿ ತ್ಯಚಿ ಮಾಯಾ ಕರ್ತೊ. ಮಿ ತ್ಯಲಾ ಮನಾಸ್ ದಾವುನ್ ದೇತೊ ಮನ್ಹು‍ನ್ ಉತ್ತರ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","ತವಾ ಯುದ್ ಹ್ಯೊ ಇಸ್ಕರಿತ್ ಯುದ್ ನವ್ಹ, “ಫನ್ ಪ್ರಭು ತು ತುಲಾ ಹೆ ದುನೆಲಾ ದಾವುನ್ ದಿಯಾಚೆ ಆಂದಿ ಆಮಾನಾ ತ್ಯವ್ಡಸ್ ದಾವುನ್ ದಿಯಾಚ಼ ಕಾ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","ಯೇಸುನಿ ಆಸಾ ಉತ್ತರ್ ದಿಲಾ. ಮಾಜಿ ಮಾಯಾ ಕರ್ತ್ಯಾಲಾ ಮಿ ಸಿಕಿವ್‌ಲ್ಯಾ ಶಾರ್ಕ ಚಾ಼ಲ್ತೊ ಮಾಜಾ಼ ಬಾಬಿ ತ್ಯಚಿ ಮಾಯಾ ಕರ್ತೊ. ಆಮಿ ದೊಗ ಯವುನ್ ತ್ಯಚಿಪ ರಾಥಾವ್ ");
INSERT INTO gok_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","ಫನ್ ಮಾಜಿ ಮಾಯಾ ಕರೀತ್ ನಸ್ನಾರಾ ಮಿ ಸಿಕಿವ್‌ಲ್ಯಾ ಶಾರ್ಕಾ ಚಾ಼ಲತ್ ನಾಹಿ. ತುಮಿ ಐಕ್‌ತ್ಯಾಲ ಹ್ಯ ಸಿಕ್ಷನ್ ಖರ‍್ಯಾನಿಸ್ ಮಾಜ಼ ನವ್ಹ. ಮನಾ ಲಾವುನ್ ದಿಲ್ಯಾಲ್ಯಾ ಮಾಜಾ ಬಾಚ಼ ");
INSERT INTO gok_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","ಮಿ ತುಮ್ಚಿಪ ಆಸ್ಥಾನಾ ಹ್ಯಾ ಸಗ್‌ಳ್ಯಾ ಖನ್ಕತಿ ತುಮಾನಾ ಸಾಂಗ್‌ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","ಫನ್ ತ್ಯೊ ಮಜ಼ತ್ ಕರ್ತ್ಯಾಲಾ, ತುಮನಾ ಸಗ್ಳ ಸಿಕಿವ್ನಾರ್ ಆನಿ ಸಾಂಗ್ನಾರ್ ಮಿ ತುಮಾನಾ ಸಾಂಗ್‌ಲ್ಯಾಲ್ಯಾ ಖನ್ಕತಿ ತ್ಯೊ ಮಜ಼ತ್ ಕರ್ತ್ಯಾಲಾ ತುಮ್ಚೆ ಯದತ್ ಆನ್ನಾರ್ ಬಾ ಮಾಜಾ ನಾವಾನಿ ಲಾವುನ್ ದೇತ್ಯಾಲ ಪವಿತ್ರಾತ್ಮಸ್ ತ್ಯ ಮಜ಼ತ್ ಕರ್ತ್ಯಾಲ. ");
INSERT INTO gok_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","ಮಿ ಸಮಾದಾನ್ ತುಮ್ಚಿ ಸಂಗ ಶೊಡ್ತೊ. ಮಾಜಾ಼ ಸಮಾದಾನ್ ತುಮಾನಾ ದೆತೊ. ಹಿ ದುನ್ಯಾ ದೇತ್ಯಾ ಶಾರ್ಕಿ ನವ್ಹ. ತುಮ್ಚಿ ಮನ ಕಳ್ವಳು ನಸುಂತ ತುಮಿ ಬಿಹುನಕೊಸಾ. ");
INSERT INTO gok_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","ಮಿ ನಿಗುನ್ ಜಾ಼ತೊ ಖರ ಪರ್ತುನ್ ಮಾಗಾರಾ ಯನಾರ್ ಮನ್ಹುನ್ ಮಿ ಸಾಂಗ್‍ಲ್ಯಾಲ ತುಮಿ ಐಕ್ಲಸಾ ತುಮಿ ಮಾಜಿ ಮಾಯಾ ಕರ್ತ್ಯಾಲ ಜಾ಼ಲಾಸಾತ ಮಿ ಬಾಪ ಪರ್ತುನ್ ಜಾ಼ಯಾಚೆ ಖನ್ಕತಿತ್ ಸಂತೊಶ್ ವ್ಹಯಿತಾಸಾ ಕಾಮಂಜೆ ಬಾ ಮಾಜಿವ್ನಿ ಥೊರ‍್ಲಾ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","ಹ್ಯ ವ್ಹಯಾಚೆ ಆಂದಿ ಮಿ ತುಮಾನಾ ಸಾಂಗ್‌ಲ್ಯಾ. ಆಸ ಆಸ್ಥಾನಾ ಹ್ಯ ವ್ಹತಾನಾ ತುಮಿ ಇಸ್ವಾಸ್ ಥೆವ್ನಾರ್ ");
INSERT INTO gok_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","ಮಿ ತುಮ್ಚಿ ಸಂಗ ಆನಿ ಖುಬ್ ಯೊಳ್ ಬೊಲತ್ ನಾಹಿ ಹೆ ದುನೆಚಾ಼ ಅಧಿಕಾರಿ ಯತ್ಯೊ. ತ್ಯಲಾ ಮಾಜಿವ ಕಾಯೇಕ್ ಹುಕುಮ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ಫನ್ ಮಿ ಬಾಚಿ ಮಾಯಾ ಕರ್ತ್ಯೊ ಆನಿ ತ್ಯ ಮಿ ಮಾಜಾ ಬಾಚೆ ಆಜ್ಞೆ ಶಾರ್ಕ ಕರ್ತ್ಯೊ ಮನ್ಹುನ್ ದುನೆಲಾ ಸಮ್‍ಜಾ಼ಯಾ ವ್ಹಯಿ. ಯವಾ ಆಮಿ ಹಿತ್ನಿ ಜಾ಼ವುಯಾ. ");
INSERT INTO gok_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","ಮಿ ಖರಾ ದರಾಕ್ಶಿಚಾ಼ ಯೊಲ್ ಆನಿ ಮಾಜಾ಼ ಬಾ ಬಾಗಚಾ಼ ದನ್ಹಿ. ");
INSERT INTO gok_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","ಫಳ್ ದಿಯಿ ನಸ್ನಾರಿ ಪರತೇಕ್ ಢ್ಯಾಳ್ ಮಾಜಿಪ್ನಿ ತುಡುನ್ ಗ್ಯಾಲ್ನಾರ್. ಫಳ್ ದೇತ್ಯಾಲೆ ಡಾಳ್ಹಿಲಾ ಆನಿಕ್ ಖುಬ್ ಫಳ್ ದಿಯಿ ಶಾರ್ಕಿ ಚಾ಼Oಗ್ಲಿ ಕರ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","ಮಿ ತುಮಾನಾ ದಿಲ್ಯಾಲ್ಯಾ ಸಿಕಿವ್‌ನ್ಯಾನಿ ಆತಾಸ್ ತುಮಿ ಶುದ್ದ ಜಾ಼ಲ್ಹಾಸಾ. ");
INSERT INTO gok_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","ತುಮಿ ಮಾಜಿಪ ರಾವ್ಹಾ ಮಿ ತುಮ್ಚಿಪ ರಾಥೊ. ಕಚಿ ಢ್ಯಾಳ್ ಆಪ್ಲೆ ಆಪ್ನು ಫಳ್ ದಿಯಿತ್ನಾಹಿ ತ್ಯ ದರಾಕ್ಶಿಚಾ ಯಲಾಲಾಸ್ ರಾಹ್ಯಾ ವ್ಹಯಿ ಹ್ಯ ತುಮಾನಾಬಿ ತುಮಿ ತುಮ್ಚಾನಿಸ್ ಫಳ್ ದೇನಾರ್ ನಾಹಿಸಾ ತುಮಿ ಮಾಜಿಪ ರಾಹ್ಯಾ ವ್ಹಯಿಸಾ. ");
INSERT INTO gok_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","ಮೀಸ್ ದರಾಕ್ಶಿಚಾ಼ ಯೊಲ್ ತುಮಿಸ್ ಡಾಳ್ಹಿ ಯಕ್ಲಾ ಮಾಜಿಪ ರಾಯ್ಲಾತ ಆನಿ ಮಿ ತ್ಯಚಿಪ ರಾಯ್ಲೊತ ತ್ಯೊ ಖುಬ್ ಫಳ್ ದೇನಾರ್ ಫನ್ ತ್ಯೊ ಮನಾ ಸುಡುನ್ ಕಾಯ್ ಕರಾಯಾ ವ್ಹಯಿತ್ ನಾಹಿ ");
INSERT INTO gok_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","ಮಾಜಿಪ ರಾಹಿತ್‌ ನಸ್‌ಲ್ಯಾಲಾ ವಾಳುನ್ ಗೇಲ್ಯಾಲೆ ಡಾಳ್ಹಿಂಚೆಗತ್ ಹಾ ಲೊಕ ಗೊಳಾ ಕರುನ್ ಇಸ್‌ಥ್ಯಾತ್ ಟ್ಯಾಕ್‌ತ್ಯಾತ, ತಿಥ ತೀ ಜ಼ಳ್‌ತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","ತುಮಿ ಮಾಜಿಪ ರಾಯ್‌ಲ್ಯಾವ ಆನಿ ಮಾಜ಼ ಸಬ್ದ ತುಮ್ಚಿಪ ರಾಯಲ್ಯಾವ ತುಮಿ ಕ್ಯಾ ಮಾಗ್ಲಸಾ ತರಿ ತುಮಾನಾ ಗಾವ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","ತುಮಿ ಲ ಪೀಕ್ ದಿವುನ್ ಮಾಜಿ ಮೈಮಾ ದಾವಾ. ಹ್ಯನಿ ತುಮಿ ಮಾಜ಼ ಶಿಶಾ ಮನ್ಹುನ್ ದ್ಯಾವ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","ಬಾನಿ ಮಾಜಿ ಕಸಿ ಮಾಯಾ ಕೆಲೆ ತಸಿ ಮಿ ತುಮ್ಚಿ ಮಾಯಾ ಕೆಲೆ ಮಾಜೆ ಮಾಯೆತ್ ರಾವ್ಹಾ. ");
INSERT INTO gok_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","ಯೆಕ್ ಯಳಿ ತುಮಿ ಮಾಜಾ ಆಜ್ಞೆ ಪಾಳ್ಯಾಸಾತ ತುಮಿ ಮಾಜೆ ಮಾಯೆತ್ ಯೆಕ್ ವ್ಹವುನ್ ಹಾಸಾ ತಸಿ ತುಲಾ ಮಾಯಾ ಕರ್ತ್ಯೊ. ");
INSERT INTO gok_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","ಮಾಜಿಪ ಆಸ್‌ಲ್ಯಾಲಾ ಆನಂದ್ ತುಮಾನಾಬಿ ಗಾಹುನಿ ಮನ್ಹುನ್ ಮಿ ತುಮಾನಾ ಹ್ಯಾ ಖನ್ಕತಿ ಸಾಂಗ್‌ಲ್ಯಾ ತುಮ್ಚಿ ಹೌಸ್ ಪುರ್ನ ವ್ಹಯಾವ್ಹಯಿ ಮನ್ಹುನ್ ಮನ್ ಕರ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","ಮಿ ತುಮ್ಚಿ ಮಾಯಾ ಕೆಲ್ಯಾ ಶಾರ್ಕಿ ತುಮಿ ಯಕಾಮಕಾಚಿ ಮಾಯಾ ಕರಾಯಾ ವ್ಹಯಿಸಾ ಮನ್ಹುನ್ ಮಿ ತುಮಾನಾ ದೆತ್ಯಾಲಿ ಆಜ್ಞೆ ಜಾ಼ಲೆ. ");
INSERT INTO gok_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","ಸೊಪ್‌ತ್ಯಾಂಚೆ ಸಾಟಿ ಸ್ವತಾಚಾ಼ ಜೀವ್‌ ದೆತ್ಯಾಲೆ ಮಾಯೆವ್ನಿ ದುಸ್ರಿ ಮುಟಿ ಮಾಯಾ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","ಮಿ ದಿಲ್ಯಾಲೆ ಆಜ್ಞೆ ಶಾರ್ಕ ತುಮಿ ಚಾ಼ಲಾಸಾತ್ ತುಮಿ ಮಾಜ಼ ಸುಪ್ತಿ. ");
INSERT INTO gok_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","ಆತಾ ಮಿ ಹಿತ್ನಿ ಮೊರ‍್ಹ ತುಮಾನಾ ಮಾಜ಼ ಸೇವಕ್ ಮನ್ಹುನ್ ಹಾಕ್ಟಿತ್ ನಾಹಿ. ಕಾ ಮಂಜೆ ಸ್ವಾಮಿ ಕ್ಯಾ ಕರ್ತೊ ತ್ಯೊ ತ್ಯಾ ಸೇವಕಾಲಾ ಕರೀತ್ನಾಹಿ.ಮನ್ಹುನ್ ಮಿ ತುಮಾನಾ ಮಾಜ಼ ಸುಪ್ತಿ ಮಂಥೊ ಕಾಮಂಜೆ ಮಾಜಾ ಬಾಪ್ನಿ ಕ್ಯಾ ಐಕ್‌ಲ್ಯಾ ತ್ಯ ತುಮಾನಾ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","ತುಮಿ ಮನಾ ನಿವ್ಡುನ್ ಗೆತ್ಲನಾಹಿಸಾ ಮಿ ತುಮಾನಾ ನಿವ್ಡುನ್ ಗೆತ್ಲ ಆನಿ ತುಮಿ ಜಾ಼ವುನ್ ಫಳ್ ದಿಯಾ ವ್ಹಯಿಸಾ ತ್ಯ ಫಳ್ ಕವಾಬಿ ರಾಥ್ಯಾಲ ಆನಿ ಮಾಜಾ ನಾವಾನಿ ಕ್ಯಾಬಿ ಮಾಗ್ಲ ತರಿ ಬಾ ತ್ಯ ತುಮಾನಾ ದೇನಾರ್ ");
INSERT INTO gok_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","ತುಮಿ ಯಕಾಮಕಾಚಿ ಮಾಯಾ ಕರಾಯಾ ವ್ಹಯಿಸಾ ಹಿ ಮಾಜಿ ಆಜ್ಞೆ. ");
INSERT INTO gok_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","ಹಿ ದುನೆನಿ ತುಮಚಾ಼ ದ್ವೆಶ್ ಕೆಲಾತ ತ್ಯನಿ ಆಂದಿ ಮಾಜಾ಼ಸ್ ದ್ವೆಶ್ ಕೆಲ್ಯಾಲಾ ಯದತ್ ಆನಾ. ");
INSERT INTO gok_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","ತುಮಿ ಹೆ ದುನೆತ್ ಮಿಳಾಲ್ಯಾಲ ಆಸ್ಲಾಸಾತ ಹಿ ದುನ್ಯಾ ಆಪ್‌ಲ್ಯಾ ಸ್ವತಾಚಾ ಲೊಕಾನಾ ಮಾಯಾ ಕರ್ತ್ಯಾ ಶಾರ್ಕಿ ತುಮ್ಚಿಬಿ ಮಾಯಾ ಕರೀತಿ. ಫನ್ ಮಿ ತುಮಾನಾ ಹೆ ದುನೆತ್ನಿ ನಿವ್ಡುನ್ ಗೆತಲ್ಯಾತ ಮನ್ಹುನ್ ತುಮಿ ಹೆ ದುನೆತ್ ಮಿಸಾಳ್ಯಾಲ ನವ್ಹಸಾ ಮನ್ಹುನುಸ್ ಹಿ ದುನ್ಯಾ ತುಮಚಾ಼ ರಾಗ್ ಕರ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","ಮಾಜಿ ಹಿ ಬುಲಿ ಯಾದ್ ಕರ್ ಯೊಕ್ ಆಳ್ ಆಪ್‌ಲ್ಯಾ ಧನ್ಯಾವ್ನಿ ಮೊಟಾ ನವ್ಹ. ಯೆಕ್ ಯಳಿ ಲೊಕಾಂಚಾನಿ ಮನಾ ಸತಿವ್ಲತ ತೇ ತುಮಾನಾಬಿ ಸತಿವ್ನಾರ್ ಯೆಕ್ ಯಳಿ ತ್ಯಂಚಾನಿ ಮಾಜ಼ ಸಬಾತ್ ಪ್ಯಾಳ್ಳತ ತುಮಚ಼ಬಿ ಪ್ಯಾಳ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","ಮನಾ ಲಾವುನ್ ದಿಲ್ಯಾಲ್ಯಾಲಾ ತ್ಯಂಚಾನಿ ಸಮಜು಼ನ್ ಗೆತ್ಲ ನಾಹಿ ಮನ್ಹುನ್ ತಿ ಹ್ಯ ಸಗ್ಳ ತುಮಾನಾ ಕರ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","ಮಿ ಯಯಿತ್ ನವ್ಥೊ ಆನಿ ತ್ಯಂಚಿ ಸಂಗ ಬೊಲತ್ ನಸ್ತೊ ತ ತ್ಯನಾ ಪಾಪಾಚಾ಼ ದೊಸ್ ಸಮಾಜ಼್ಲ ನಸ್ಥ. ಹೆ ದುನೆತ್‌ಲ್ಯಾ ಲೊಕಾಪ ಬೊಲ್ಲೊನಸ್ಥೊತ ತ್ಯನಾ ಪಾಪಾಚಾ ದೊಸ್ ಮನ್ಹುನ್ ಸಾಂಗಾಲಾ ವ್ಹಯಿತ್ ನವ್ಥ ಖರ ಮಿ ಆತಾ ತ್ಯಂಚಿ ಸಂಗ ಬೊಲ್ಯೊ ಮನ್ಹುನ್ ಆಪ್‌ಲ್ಯಾ ಪಾಪಾಲಾ ತ್ಯನಾ ಕಾಯ್ ನೆವಾ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","ಮಾಜಾ಼ ರಾಗ್‌ ಕರ್ತ್ಯಾಲಾ ಮಾಜಾ ಬಾಚಾ಼ಬಿ ರಾಗ್ ಕರ್ನಾರ್ ");
INSERT INTO gok_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","ಕುನಿ ಕೆಲ್ಯಾ ನಸ್‌ಲ್ಯಾಲಿ ಕಾಮ ಮಿ ತ್ಯಂಚೆ ಮದ್ದಿ ಕರೀತ್ ನಸ್ತೊತ. ತ್ಯನಾ ಪಾಪ್ ರಾಹಿತ್ ನವ್ತ. ಫನ್ ಆತಾ ಮಾಜಿ ಕಾಮ ಬಗಲ್ಯಾತ ತರಬಿ ಮಾಜಾ಼ ಆನಿ ಮಾಜಾ ಬಾಚಾ಼ ದ್ವೆಶ್ ಕರ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","‘ತ್ಯಂಚಾನಿ ಕಾರನ್ ನಸ್ಥಾನಾ ಮಾಜಾ಼ ದ್ವೆಶ್ ಕೆಲಾ’ ಮನ್ಹುನ್ ತ್ಯಂಚಾ ಧರ್ಮಶಾಸ್ತಾರಾತ್ ಲಿವ್‌ಲ್ಯಾಲಿ ಬುಲಿ ಖರಿ ವ್ಹವುನಿ ಮನ್ಹುನ್ ಆಸ ಜಾ಼ಲ. ");
INSERT INTO gok_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","ಯೊಕ್ ಮಜ಼ತ್ ಕರ್ತ್ಯಾಲಾ ಯನಾರ್, ತ್ಯೊ ಪವಿತ್ರ ಆತ್ಮ ಜಾ಼ಲ್ಯಾ. ಆನಿ ದೇವಾಚ಼ ಖರ ದಾವುನ್ ದೆತೊ ಆನಿ ತ್ಯೊ ಬಾಪ್ನಿ ಆಲ್ಯಾ. ಮಿ ತ್ಯಲಾ ಬಾಪ್ನಿ ಲಾವುನ್ ದೆತೊ ಆನಿ ತ್ಯೊ ಮಾಜಿ ಸಾಕ್ಷಿ ದೇನಾರ್. ");
INSERT INTO gok_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","ಆನಿ ತುಮಿ ಆಂದಿಸ್ಠಾವ್ನಿ ಮಾಜಿಪ ಹಾಸಾ ಮನ್ಹುನ್ ತುಮಿಬಿ ಮಾಜೆ ಗುಶ್ಟಿತ್ ಲೊಕಾನಾ ಸಾಕ್ಶಿ ಸಾಂಗ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","ಹ್ಯಾ ಬೊಲ್ಯಾ ಮಿ ತುಮಾನಾ ಸಾಂಗ್‌ಲ್ಯಾಲ್ಯಾ ಕಾ ಮಂಜೆ ತುಮಿ ಇಸ್ವಾಸ್ ಸುಡುನಕೊಸಾ. ");
INSERT INTO gok_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","ತೀ ತುಮಾನಾ ಯೆಹುದಿ ಸಬಾಸ್ತಾನಾತ್ನಿ ಬಾಹಿರ್ ಗ್ಯಾಲ್ನಾರ್. ಆನಿ ತ್ಯೊ ಯೊಳ್ ಯತ್ಯೊ ಆನಿ ತುಮ್ಚಾತ್‌ಲ್ಯಾ ಯಕಾಲಾ ಮಾರುನ್ ಹಿ ದೇವಾಚಿ ಸೇವಾ ಕೆಲ್ಯಾಚೆಗತ್ ಮನ್ಹುನ್ ಯವಜ಼ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","ಫನ್ ಮಿ ಹ್ಯ ಹ್ಯಚಿಸಾಟಿ ಸಾಂಗ್ಲ ಕವಾ ತ್ಯಂಚಾನಿ ಹ್ಯ ಸಗ್ಳ ಕರಾಚಾ಼ ಯೊಳ್ ಯನಾರ್ ತವಾ ತುಮಾನಾ ಯಾದ್ ರಾಹುನಿ ಆಂದಿಸ್ ಹೆ ಸಬಾತ್ ಮಿ ತುಮಾನಾ ಸಾಂಗ್ಲ ನಾಹಿತ ಕಾ ಮಂಜೆ ಮಿ ತುಮ್ಚೆ ಸಂಗ ಹುತ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","ಫನ್ ಆತಾ ಮಿ ತುಮಾನಾ ಹ್ಯಚಿ ಸಾಟಿ ಸಗ್‌ಳ್ಯಾ ಗುಶ್ಟಿ ಸಾಂಗ್‌ಲ್ಯಾತಾ ಆಸ ಆಸ್ಥಾನಾ ಹ್ಯಾ ಗುಶ್ಟಿ ಘಡಾಚ಼ ದೀಸ್ ಆಲಕಿ ಮಾಜೆ ಜಾ಼ಗೃತಿಚಾ ಬೊಲ್ಯಾಂಚಿ ತುಮಿ ಯಾದ್ ಕರ್ನಾರ್. ಮಿ ಹ್ಯಾ ಸಗ್‍ಳ್ಯಾ ಗುಶ್ಟಿ ತುಮಾನಾ ಆಂದಿಸ್ ಸಾಂಗ್‌ಲ್ಯಾ ನಾಹಿತಾ ಕಾಮಂಜೆ ತವಾ ಮಿ ತುಮ್ಚೆ ಸಂಗ ಹುತ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","ಆತಾತರಿ ಮನಾ ಲಾವುನ್ ದಿಲ್ಯಾಲ್ಯಾಪ ಜಾ಼ತೊ ಖರ ತುಮ್ಚಿಪ್‌ಲ್ಯಾ ಯಕಾನಿ ತರಿ ತು ಕುಂಡ ಜಾ಼ತ್ಯೊಸ್? ಮನ್ಹುನ್ ಮನಾ ಇಚಾರ್ಲ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","ಮಿ ತುಮಾನಾ ಹ್ಯಾ ಗುಶ್ಟಿ ಸಾಂಗ್‌ಲ್ಯಾ ಮನ್ಹುನ್ ತುಮ್ಚಿ ಮನ ದುಖಾನಿ ಬರ್ಲ್ಯಾತ ");
INSERT INTO gok_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","ಫನ್ ಮಿ ತುಮಾನಾ ಖರ ತ್ಯ ಸಾಂಗ್ತೊ ಮಿ ಜಾ಼ಯಾಚ಼ ತುಮ್ಚಾ ಬರ‍್ಯಾಲಾಸ್ ಕಾಮಂಜೆ ಮಿ ಜಾ಼ವುನ್ ಮಜ಼ತ್ ಕರ್ತ್ಯಾಲ್ಯಾಲಾ ತುಮ್ಚಿಪ ಲಾವುನ್ ದೆತೊ ಮಿ ಗೆಲೊ ನಾಹಿತ ಮಜ಼ತ್ ಕರ್ತ್ಯಾಲಾ ತುಮ್ಚಿಪ ಯನಾರ್ ನಾಹಿ ");
INSERT INTO gok_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","ಕವಾ ತ್ಯೊ ಯನಾರ್, ಪಾಪ್, ನಿಯತ್, ನ್ಯಾಯಿ ತೀರ್ಮಾನಾಚೆ ಗುಶ್ಟಿತ್ ದುನೆಚಾ಼ ಅನ್ಮಾನ್ ದುರ್ ಕರ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","ಪಾಪಾಚೆ ಗುಶ್ಟಿತ್ ತೆ ಚುಕ್‌ಲ್ಯಾತ ಕಾ ಮಂಜೆ ಮಾಜಿವ ಇಸ್ವಾಸ್ ಥೆವ್ಲಾ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","ಮಿ ಬಾಪ ಜಾ಼ತ್ಯೊ ಆನಿ ತುಮಿ ಮನಾ ಖುಬ್ ಯೊಳ್ ಬಗ್ನಾರ್ ನಾಹಿಸಾ ಹ್ಯಚಿಸಾಟಿ ತೆ ನಿಯತಿಚೆ ಗುಶ್ಟಿತ್ ಚು಼ಕ್‌ಲ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ನ್ಯಾಯಿನಿವ್ಡಾಚೆ ಗುಶ್ಟಿತ್ ತೇ ಚುಕ್‌ಲ್ಯಾತ ಕಾ ಮಂಜೆ ಹೆ ದುನೆಚಾ ಅಧಿಪತಿಲಾ ಆಂದಿಸ್ ನ್ಯಾಯಿ ತಿರ್ಮಾನ್ ಜಾ಼ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","ಮಿ ತುಮಾನಾ ಸಾಂಗಾಯಾ ಪಾಯ್ಜೆತ್ಯಾ ಆನಿಕ್ ಖುಬ್ ಗುಶ್ಟಿ ಹಾತ್ತಾ. ಫನ್ ಆತಾ ತ್ಯಾ ಗುಶ್ಟಿ ತುಮಾನಾ ಸೊಸ್ನಾರ್ ನಾಹಿತಾ. ");
INSERT INTO gok_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","ಫನ್ ಖರ‍್ಯಾಚ಼ ಆತ್ಮ ಆಲಕಿ ತ್ಯೊ ತುಮಾನಾ ಸಗ್ಳೆ ಗುಶ್ಟಿತ್ನಿ ಖರ‍್ಯಾತ್ ಚಾ಼ಲಿವ್ನಾರ್. ಖರ‍್ಯಾಚ಼ ಆತ್ಮ ಸಾಂಗ್‌ತ್ಯಾಲ ಆಪ್‌ಲ್ಯಾ ಸ್ವತಾಚಾ ಬೊಲ್ಯಾ ನವ್ಹತಾ ಆಪ್ನು ಐಕ್‌ಲ್ಯಾಲ ತ್ಯವ್ಡಸ್ ತ್ಯೊ ಸಾಂಗ್ತೊ ವ್ಹತ್ಯಾಲ್ಯಾ ಗುಶ್ಟಿತ್ ತ್ಯೊ ತುಮಾನಾ ಸಾಂಗ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","ಮಿ ಸಾಂಗಲ್ಯಾಲ್ಯಾ ಗುಶ್ಟಿ ಗಿಹುನ್ ತುಮಾನಾ ಸಾಂಗ್‌ತ್ಯಾಲಾಸ್ ಮನಾ ಮೈಮಾ ಕರ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","ಮಾಜಾ ಬಾಪ ಆಸ್‌ಲ್ಯಾಲ ಸಗ್ಳ ಮಾಜ಼ಸ್ ಮನ್ಹುನ್ ಪವಿತ್ರಾತ್ಮ ಮಾಜಿಪ್‌ಲ್ಯಾ ಗುಶ್ಟಿ ಗಿಹುನ್ ತುಮಾನಾ ಸಾಂಗ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","ಥೊಡಾ ಯೊಳ್ ಜಾ಼ಲ್ಯಾನಂತರ್ ತುಮಿ ಮನಾ ಬಗ್ನಾರ್ ನಾಹಿಸಾ ತ್ಯಾ ನಂತರ್ ಥೊಡದೀಸ್ ಜಾ಼ಲ್ಯಾವ ತುಮಿ ಮನಾ ಆನಿಕ್ ಬಗ್ನಾರ್ ");
INSERT INTO gok_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","ಶಿಶಾತ್ಲ ಥೊಡ ಥೊಡ್ಯಾಯಳಾ ನಂತರ್ ತುಮಿ ಮನಾ ಬಗ್ನಾರ್ನಾಹಿಸಾ ಫನ್ ತ್ಯಾ ನಂತರ್ ಥೊಡ್ಯಾಯಳಾ ನಂತರ್ ಆನಿಕ್ ಬಗ್ನಾರ್ ಕಾಮಂಜೆ ಮಿ ಬಾಪ ಜಾ಼ತ್ಯೊ ಮನ್ಹುನ್ ತ್ಯನಿ ಸಾಂಗ್‌ಲ್ಯಾಲ ಅರ್ಥ ಕ್ಯಾ? ಮನ್ಹುನ್ ಯಕಾಮಕಾಲಾ ಬುಲುನ್ ಗೆತ್ಲ ");
INSERT INTO gok_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","ತ್ಯಂಚಾನಿ ಇಚಾರ್ಲ, “ಥೊಡಾ ಯೊಳ್ ಮಂಜೆ ಕ್ಯಾ? ತ್ಯಚ಼ ಬೊಲ್ನಸ್ ಆಮಾನಾ ಸಮಾಜ಼್ಲ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","ಶಿಶಾ ಹ್ಯಚ಼ ಆಪ್‌ಲ್ಯಾಲಾಸ್ ಇಚಾರಾಚ಼ ಹಾತ್ತ ಮನ್ಹುನ್ ಯೇಸುಲಾ ಸಮಾಜ಼್ಲ ಹುತ್ತ ಮನ್ಹುನ್ ತ್ಯನಿ ಥೊಡಾ ಯೊಳ್ ಜಾ಼ಲ್ಯಾ ನಂತರ್ ತುಮಿ ಮನಾ ಬಗ್ನಾರ್ ನಾಹಿಸಾ ಫನ್ ತ್ಯಾ ನಂತರ್ ಥೊಡಾಯೋಳ್ ಜಾ಼ಲ್ಯಾನಂತರ್ ಮನಾ ಬಗ್ನಾರ್ ಮನ್ಹುನ್ ಮಿ ಸಾಂಗ್‌ಲ್ಯಾಲ್ಯಾಚಾ಼ ಅರ್ಥ ಕ್ಯಾ ಮನ್ಹುನ್ ತುಮಿ ಯಕಾಮಕಾಲಾ ಇಚಾರ್ತ್ಯಾಸಾ? ");
INSERT INTO gok_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","ತುಮಾನಾ ಖರ‍್ಯಾನಿ ಸಾಂಗ್ತೊ. ತುಮಿ ರಡ್ನಾರ್. ಕಳ್ವಳ್ನಾರ್ ದುಖ್ ವ್ಹನಾರ್ ಆನಿ ತುಮ್ಚ ದುಖ್ ಜಾ಼ವುನ್ ಸಂತೊಶ್ ವ್ಹನಾರ್. ");
INSERT INTO gok_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","ಗರ್ವಾರ್ ಬಾಯಿಲ್ ಮಾನುಸ್ ಬಾಳತ್ ಫನಾಚ಼ ಯಾಗ್ ಯತಾನಾ ತಿಲಾ ತರಾಸ್ ವ್ಹತ್ತೊ. ಮುಲ್ ಜ಼ಲಾಮ್ಲಕಿ ದುನೆತ್ ಯಾಕ್ ಮುಲ್ ಜ಼ಲಾಮ್‌ಲ್ಯಾಲೆ ಹೌಸನಿ ತೀ ತ್ಯೊ ತರಾಸ್ ಇಸ್ರುನ್ ಜಾ಼ತಿ. ");
INSERT INTO gok_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","ಹ್ಯ ತುಮಾನಾಬಿ ಠಾವ ಹಾ ಆತಾ ತುಮಿ ತರಾಸಾನಿ ಹಾಸಾ. ಫನ್ ತುಮಿ ಮನಾ ಆನಿಕ್ ಬಗ್ತಾನಾ ಸಂತೊಶ್ ವ್ಹನಾರ್ ತ್ಯೊ ಸಂತೊಶ್ ಕೊನ್ ತುಮ್ಚಿಪ್ನಿ ಕಾಡುನ್ ಗಿಹಿತ್ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","ತ್ಯಾ ದಿಸಾತ್ ತುಮಿ ಮನಾ ಕಸ್ಲಿಸ್ ಪ್ರಶ್ನೆ ಇಚಾರ್ನಾರ್ ನಾಹಿಸಾ ಮಿ ತುಮಾನಾ ಖರ ಸಾಂಗ್ತೊ ತುಮಿ ಮಾಜಾ ನಾವಾನಿ ಕ್ಯಾ ಮಾಗ್ಲಸಾ ತರಿ ಬಾ ತ್ಯ ತುಮನಾ ದೇನಾರ್ ");
INSERT INTO gok_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","ತುಮಿ ಮಾಜಾ ನಾವಾನಿ ಕಾಯೇಕ್ ಮಾಗ್ಲ ನಾಹಿಸಾ ಮಾಗಾ ತವಾ ತುಮಾನಾ ಗಾವ್ನಾರ್ ಆನಿ ತುಮಚಾ಼ ಸಂತೊಶ್ ಪುರ್ನ ವ್ಹನಾರ್. ");
INSERT INTO gok_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","ಮಿ ತುಮಾನಾ ಹ್ಯಾ ಗುಶ್ಟಿ ಕ್ಯಾಯ್ನಿಚಿಗತ್ ಸಾಂಗ್‌ಲ್ಯಾ. ಫನ್ ಯೊಳ್ ಯನಾರ್ ತವಾ ಮಿ ಕ್ಯಾಯ್‌ನ್ಯಾ ದಿಯಾಚೆ ಆಂದಿ ಮಾಜಾ ಬಾಚೆ ಗುಶ್ಟಿತ್ ಉಗ್ಡುನ್ ನಿಟ್ ಸಾಂಗ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","ತವಾ ತುಮಿ ಮಾಜಾ ನಾವಾನಿ ಬಾಪ ಮಾಗ್ನಾರ್ ಮಿ ತುಮ್ಚಿ ಸಾಟಿ ಬಾಪ ಇಚಾರಾಚ಼ ವ್ಹಯಿ ಜಾ಼ಲ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","ಬಾ ಸ್ವತಾ ಆಪ್ನು ತುಮ್ಚಿ ಮಾಯಾ ಕರ್ತೊ. ತುಮಿ ಮಾಜಿ ಮಾಯಾ ಕಿಲಿಸಾ ಮನ್ಹುನ್ ಆನಿ ಮಿ ದೇವಾಪ್ನಿ ಆಲ್ಯೊ ಮನ್ಹುನ್ ತುಮಿ ಇಸ್ವಾಸ್ ಥೆವ್‍ಲ್ಯಾಸಾ ಮನ್ಹುನ್ ತ್ಯೊ ತುಮ್ಚಿ ಮಾಯಾ ಕರ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","ಮಿ ಬಾಪ್ನಿ ಹೆ ದುನೆತ್ ಆಲೊ ಆತಾ ಮಿ ಹಿ ದುನ್ಯಾ ಸುಡುನ್ ಬಾಪ ಮಾಗಾರಾ ಜಾ಼ತ್ಯೊ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ ");
INSERT INTO gok_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","ತವಾ ಶಿಶಾಂಚಾನಿ ಯೇಸುಲಾ ಆತಾ ತು ಆಮ್ಚಿ ಸಂಗ ಶಾರ್ಕ ಬೊಲ್‌ತ್ಯೊಸ್ ಸಮಜ಼ತ್ ನಸ್‌ಲ್ಯಾಲ್ಯಾ ತರಾಸಾಚಾ ಬೊಲ್ಯಾ ಬೊಲತ್ ನಾಹಿಸ್. ");
INSERT INTO gok_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","ತುಲಾ ಸಗ್‌ಳ್ಯಾ ಗುಶ್ಟಿ ಠಾವ್ಯಾ ಹಾತ್ತಾ ಮನ್ಹುನ್ ಆತಾ ಆಮಾನಾ ಸಮಾಜ಼್ಲ. ಆನಿ ತುಲಾ ಕುನಿ ಪ್ರಶ್ನೆ ಇಚಾರಾಚಿ ಗರಜ಼್ ನಾಹಿ ತು ದೇವಾಪ್ನಿ ಆಲ್ಯಾಲಾ ಮನ್ಹುನ್ ಖರ ವ್ಹತ್ತ. ");
INSERT INTO gok_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","ಯೇಸುನಿ ತ್ಯನಾ ಇಚಾರ್ಲ, “ಆತಾ ತುಮಿ ಇಸ್ವಾಸ್ ಥೆವ್ತಾಸಾ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","ಐಕಾ ತ್ಯೊ ದೀಸ್ ಆತಾಸ್ ಆಲ್ಯಾ ತವಾ ತುಮಿ ಪರತೆಕ್‍ಜಾ಼ನ್ ಆಪ್‌ಲ್ಯಾ ಆಪ್‍ಲ್ಯಾ ಗರ‍್ಹಾತ್ನಿ ಪಳುನ್ ಜಾ಼ನಾರ್ ಆನಿ ಮಿ ಯಕ್ಲಾಸ್ ವ್ಹನಾರ್ ಖರ ಮಿ ಯಕ್ಲಾ ನವ್ಹ ಮಾಜಾ಼ ಬಾ ಮಾಜಿ ಸಂಗ ಹಾ ");
INSERT INTO gok_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","ತುಮಿ ಮಾಜಿಪ ಸಮಾದಾನಾನಿ ರಾಹ್ಯಾ ವ್ಹಯಿಸಾ ಮನ್ಹುನ್ ಮಿ ತುಮಾನಾ ಹ್ಯಾ ಸಗ್‌ಳ್ಯಾ ಗುಶ್ಟಿ ಸಾಂಗ್‌ಲ್ಯಾ ಹೆ ದುನೆತ್ ತುಮಾನಾ ತರಾಸ್ ಹಾ ಫನ್ ಧಿರ‍್ಹಾನಿ ರಾವ್ಹಾ ಮಿ ಹಿ ದುನ್ಯಾ ಜಿತಲ್ಯೊ. ಮನ್ಹುನ್ ಸಾಂಗ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","ಯೇಸುನಿ ಹ್ಯಾ ಗುಶ್ಟಿ ಸಾಂಗ್‌ಲ್ಯಾ ನಂತರ್ ಆಬ್ಳಾಕ್ಡ ಬಗುನ್ ಆಸ ಮಾಗ್ನ ಕೆಲ, “ಬಾ ಯೊಳ್ ಆಲ್ಯಾ. ತುಜಾ ಲೇಕಾಲಾ ಮೈಮಾ ದೇ. ಹ್ಯಚಿಸ್ ಲಾಗುನ್ ತ್ಯೊ ತುಲಾ ಮೈಮಾ ದಿವುನಿ. ");
INSERT INTO gok_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","ಕಾ ಮಂಜೆ ಸಗ್‌ಳ್ಯಾ ಲೊಕಾಂಚಿವ ತು ಹುಕುಮ್ ದಿಲ್ಯಾ ಆಸ ತು ತ್ಯಲಾ ದಿಲ್ಯಾಲ್ಯಾ ಪರತೇಕಾಲಾ ಶಾಶ್ವತ್ ಜೀವ್ ದಿಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","ಯಕ್ಲಾಸ್ ಖರಾ ದೇವ್ ಜಾ಼ಲ್ಯಾಲ್ಯಾ ತುಲಾ ಆನಿ ತು ಲಾವುನ್ ದಿಲ್ಯಾಲ್ಯಾ ಯೇಸು ಕ್ರಿಸ್ತಾಲಾ ಸಮ್‌ಜು಼ನ್ ಗಿಹ್ಯಾಚಾ಼ಸ್ ಶಾಶ್ವತ್ ಜೀವ್. ");
INSERT INTO gok_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","ತು ಮನಾ ದಿಲ್ಯಾಲ ಕಾಮ್ ಮಿ ಕರುನ್ ಸಪಿವ್ಲ ಮಿ ದರ್ಥಿವ ತುಲಾ ಮೈಮಾ ಕಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","ಆತಾ ಬಾ ತು ತುಜೆ ಮೊರ‍್ಹ ಮನಾ ಮೈಮಾ ಕರ್. ಆತಾ ದುನ್ಯಾ ಉತ್ಪನ್ ವ್ಹಯಾಚೆ ಆಂದಿ ಮಿ ತುಜಿ ಸಂಗ ಗೆತಲ್ಯಾಲಿ ಮೈಮಾ ಮನಾ ದೇ. ");
INSERT INTO gok_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","ತು ಹೆ ದುನೆತ್‌ಲ್ಯಾ ಲೊಕಾನಾ ಮನಾ ದಿಲಿತಸ್. ಮಿ ತ್ಯನಾ ತುಲಾ ದ್ಯಾವ್ಲಾ. ಹಿ ತುಜಿ ಜಾ಼ಲ್ಯಾತ. ಆನಿ ತು ಹ್ಯನಾ ಮನಾ ದಿಲ್ಯಾತಸ್. ಆನಿ ತೀ ತುಜಾ ಸಬ್ದಾ ಶಾರ್ಕಿ ಚಾ಼ಲ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","ತು ಮನಾ ಕ್ಯಾ ದಿಲ್ಯಾಸ್ ತ್ಯ ಸಗ್ಳ ತುಜಿಪ್ನಿಸ್ ಆಲ್ಯಾ ಮಂಥ್ಯಾಲ ಹ್ಯನಾ ಅತ್ತಾ ಸಮಾಜ಼ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","ತು ಮನಾ ದಿಲ್ಯಾಲ್ಯಾ ಬೊಲ್ಯಾ ಮಿ ಹ್ಯನಾ ದಿಲ್ಯಾ ತ್ಯಂಚಾನಿ ತ್ಯಾ ಬೊಲ್ಯಾ ಗೆತಲ್ಯಾ. ಮಿ ಖರ‍್ಯಾನಿಸ್ ತುಜಿಪ್ನಿ ಆಲ್ಯೊ ಮನ್ಹುನ್ ತ್ಯನಾ ಸಮಾಜ಼ಲ್ಯಾ ಆನಿ ತುಸ್ ಮನಾ ಲಾವುನ್ ದಿಲ್ಯಾಸ್ ಮನ್ಹುನ್ ಹ್ಯಂಚಾನಿ ಇಸ್ವಾಸ್ ಥೆವ್‌ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","ಮಿ ಹ್ಯಂಚಿಸಾಟಿ ಮಾಗ್ನ ಕರ್ತೊ. ಹೆ ದುನೆತಲ್ಯಾ ಲೊಕಾಂಚೆ ಸಾಟಿ ಮಾಗ್ನ ಕರೀತ್ ನಾಹಿ ಫನ್ ತು ಮಾಜಿಪ ದಿಲ್ಯಾಲ್ಯಾಂಚೆ ಸಾಟಿ ಮಾಗ್ನ ಕರ್ತೊ ಕಾಮಂಜೆ ಹಿ ತುಜಿ ಜಾ಼ಲ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","ಮಾಜಿಪ ಆಸ್‌ಲ್ಯಾಲ ಸಗ್ಳ ತುಜ಼ ಆನಿ ತುಜಿಪ ಆಸ್‌ಲ್ಯಾಲ ಸಗ್ಳ ಮಾಜ಼ ಹ್ಯಚಿಸ್ ಲಾಗುನ್ ಮನಾ ಮೈಮಾ ಜಾ಼ಲಿ. ");
INSERT INTO gok_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","ಆತಾ ಮಿ ತುಜಿಪ ಯತ್ಯೊ. ಆನಿಕ್ ಮಿ ಹೆ ದುನೆತ್ ಖುಬ್ ಯೊಳ್ ರಾನ್ಹಾರ್ ನಾಹಿ. ಫನ್ ಆನಿ ಹೆ ದುನೆತುಸ್ ರಾನ್ಹಾರ್ ಪರಿಶುದ್ದ ಬಾ ತುಜಾ ನಾವಾಚೆ ತಾಕ್ತಿನಿ ಹ್ಯಂಚಿ ರಖ್ವಾಲಿ ಕರ್. ತು ಕಚ಼ ನಾವ್ ಮನಾ ದಿಲ್ಯಾಸ್ ತ್ಯನಿ ಆಸಿ ತೀ ಯೆಕ್ ವ್ಹವುಂತ ಕಸ ಮಿ ಆನಿ ತು ಹಾವ್ ತಸ. ");
INSERT INTO gok_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","ಮಿ ಹ್ಯಂಚಿಪ ಆಸ್ಥಾನಾ ತುಜಾ ನಾವಾಚೆ ತಾಕ್ತಿನಿ ಹ್ಯಂಚಿ ರಖ್ವಾಲಿ ಕಿಲಿ. ತ್ಯ ನಾವ್ ತು ಮನಾ ದಿಲ್ಯಾಸ್. ಶಾಸ್ತಾರಾಚ಼ ವಚ಼ನ್ ಖರ ವ್ಹಯಾ ಮಿ ತ್ಯನಾ ರ‍್ಯಾಕ್ಲ ಆನಿ ತ್ಯಂಚಾತ್ಲ ಕೊನ್ ನಾಸ್ ಜಾ಼ಲಾ ನಾಹಿ. ನಾಸ್ ವ್ಹಯಾ ಜ಼ಲಾಮಲ್ಯಾಲಾ ಸುಡುನ್. ");
INSERT INTO gok_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","ಆತಾ ಮಿ ತುಜಿಪ ಯಯಾಲಾಗ್‌ಲ್ಯೊ ಫನ್ ಮಿ ಹೆ ದುನೆತ್ ಆನಿಕ್ ಆಸ್ಥಾನಾ ಹೆ ಗುಶ್ಟಿ ಸಾಟಿ ಮಾಗ್ನ ಕರ್ತ್ಯೊ ಹಿ ಲೊಕ ಮಾಜಿಪ ಆನಂದ್ ಗಿಹ್ಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಆನಿ ಮಾಜಿ ಹೌಸ್ ಹ್ಯಂಚಿಪ ಪುರ್ತಿ ವ್ಹಯಾಸಾಟಿ ಹ್ಯಾ ಗುಶ್ಟಿ ಸಾಂಗ್ತೊ ");
INSERT INTO gok_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","ಮಿ ಹ್ಯನಾ ತುಜಾ಼ ಸಮಾಚಾರ್ ದಿಲ್ಯಾ ಹಿ ದುನ್ಯಾ ಹ್ಯಂಚಾ಼ ದ್ವೆಶ್ ಕರ್ತೆ. ಕಸಾ ಮಿ ಹೆ ದುನೆತ್ಲಾ ನವ್ಹ ತಸ ತೆಬಿ ದುನೆತ್ಲ ನವ್ಹತ. ");
INSERT INTO gok_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","ತು ಹ್ಯನಾ ಹೆ ದುನೆತ್ನಿ ಗಿಹ್ಯಾ ವ್ಹಯಿಸ್ ಮನ್ಹುನ್ ಮಿ ಮಾಗ್ನ ಕರೀತ್ನಾಹಿ ಫನ್ ಹ್ಯನಾ ಬುರಶಾಪ್ನಿ ಚು಼ಕ್ವುನ್ ಚಾ಼Oಗ್ಲಿ ರಾಹ್ಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಮಿ ಮಾಗ್ನ ಕರ್ತ್ಯೊ ");
INSERT INTO gok_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","ಕಸಾ ಮಿ ಹೆ ದುನೆತ್ಲಾ ನವ್ಹ ತಸಿಸ್ ತೀ ಬಿ ಹೆ ದುನೆತ್ಲಿ ನವ್ಹತ. ");
INSERT INTO gok_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","ತು ತುಜೆ ಸಾಟಿ ಹ್ಯನಾ ಸಮರ್ಪನ್ ಕರುನ್ ಘೆ ಮಂಜೆ ಖರ‍್ಯಾಸಾಟಿ ತುಜ಼ ಸಬ್ದ ಖರ ಹಾತ್ತ. ");
INSERT INTO gok_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","ಕಸ ತು ಮನಾ ಹೆ ದುನೆತ್ ಲಾವುನ್ ದಿಲ್ಯಾ ಶಾರ್ಕ ತಸಿಸ್ ಮಿ ಹ್ಯನಾ ಹೆ ದುನೆತ್ ಲಾವುನ್ ದೆತೊ. ");
INSERT INTO gok_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","ಆನಿ ಮಿ ತ್ಯಂಚಿಸಾಟಿ ಮನಾಸ್ ತುಲಾ ಒಪ್ಸುನ್ ದೆತೊ ಆಸ ತೆಬಿ ಖರ‍್ಯಾನಿ ಆಪ್‌ಲ್ಯಾಲಾಸ್ ತುಲಾ ದಿವುಂತ. ");
INSERT INTO gok_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","ಮಿ ಹ್ಯಂಚಿಸಾಟಿ ತ್ಯವ್ಡಸ್ ನವ್ಹ ಕೊನ್ ಹ್ಯಂಚಾನಿ ಸಾಂಗಲ್ಯಾಲ ಐಕುನ್ ಮಾಜಿವ ಇಸ್ವಾಸ್ ಥೆವ್‌ಲ್ಯಾಲ್ಯಾ ಸಗ್‌ಳ್ಯಾಂಚೆ ಸಾಟಿ ಮಿ ಮಾಗ್ನ ಕರ್ತ್ಯೊ. ");
INSERT INTO gok_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","ಬಾ ಮಿ ತುಜಿಪ ತು ಮಾಜಿಪ ಕಸ ಹಾವ್ ತಸಿಸ್ ತಿ ಆಮ್ಚಿ ವ್ಹವುಂತ. ಹ್ಯನಿ ತುಸ್ ಮನಾ ಲಾವುನ್ ದಿಲ್ಯಾಸ್ ಮನ್ಹುನ್ ದುನ್ಯಾ ಇಸ್ವಾಸ್ ಥಿವುನಿ. ");
INSERT INTO gok_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","ತು ಮನಾ ದಿಲ್ಯಾಲಿ ಮೈಮಾ ಮಿ ತ್ಯನಾ ದಿಲೆ. ಕಾ ಮಂಜೆ ಕಸ ಮಿ ಆನಿ ತು ಯೆಕ್ ಹಾವ್ ತಸಿ ತೀ ಯೆಕ್ ವ್ಹಂವುತ. ");
INSERT INTO gok_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","ಮಿ ತ್ಯಂಚಿಪ ರಾಥೊ ಆನಿ ತು ಮಾಜಿಪ ರಾಥೊಸ್ ಆಸಿ ತೀ ಸಗ್ಳಿ ಯೇಕ್ ವ್ಹವುಂತ. ಮನಾ ತು ಲಾವುನ್ ದಿಲ್ಯಾಸ್ ಆನಿ ತು ಮಾಜಿ ಮಾಯಾ ಕಸಿ ಕಿಲಿಸ್ ತಸಿಸ್ ತ್ಯಂಚಿಬಿ ಮಾಯಾ ಕಿಲಿಸ್ ಮನ್ಹುನ್ ದುನ್ಯಾ ಸಮ್‍ಜು಼ನ್ ಗಿಹುನಿ. ");
INSERT INTO gok_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","ಬಾ ತು ಮನಾ ದಿಲ್ಯಾಲಿ ಹಿ. ಮಿ ಆಸ್ಥೊ ತಿಥ ಮಾಜಿ ಸಂಗ ರಾಹ್ಯಾ ವ್ಹಯಿತ ಮನ್ಹುನ್ ಆನಿ ಮಾಜಿ ಮೈಮಾ ಬಗಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಮನ್ ಕರ್ತೊ ಹಿ ದುನ್ಯಾ ಉತ್ಪನ್ ವ್ಹಯಾಚೆ ಆಂದಿ ತು ಮಾಜಿ ಮಾಯಾ ಕೆಲೆಸ್ ಮನ್ಹುನ್ ತುಸ್ ಮನಾ ಹಿ ಮೈಮಾ ದಿಲೆಸ್. ");
INSERT INTO gok_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","ನಿಯತಿಚಾ ಬಾ ಹೆ ದುನೆತಲ್ಯಾಂಚಾನಿ ತುಲಾ ಸಮಜು಼ನ್ ಗೆತ್ಲ ನಾಹಿ ಖರ ಮಿ ತುಲಾ ಸಮಜು಼ನ್ ಗೆತ್ಲ ಆನಿ ತುಸ್ ಮನಾ ಲಾವುನ್ ದಿಲ್ಯಾಸ್ ಮಂಥ್ಯಾಲ ಹ್ಯ ಲೊಕಾನಾ ಸಮಾಜ಼್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","ನಿಸ್ಥ ಮಿ ತು ಹ್ಯನಾ ಠಾವ ನಾಹಿಚೆಗತ್ ಕೆಲ ನಾಹಿ. ಮಿ ಹ್ಯನಾ ತುಜಿ ವಳಕ್ ಕರುನ್ ದಿಲೆ. ಆನಿ ಮಿ ತ್ಯ ಕರೀತುಸ್ ರಾನ್ಹಾರ್ ಮನ್ಹುನ್ ಕಚಿ ಮಾಯಾ ತು ಮನಾ ದ್ಯಾವ್ಲೆಸ್ ತಿ ತ್ಯಂಚಿಪಬಿ ರಾಹುನಿ ಆನಿ ಮಿಬಿ ತ್ಯಂಚಿಪ ರಾಹುನಿ. ");
INSERT INTO gok_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","ಯೇಸುನಿ ಮಾಗ್ನ ಕೆಲ್ಯಾ ನಂತರ್ ಆಪ್‌ಲ್ಯಾ ಶಿಶಾಂಚೆ ಸಂಗ ಗೆಲಾ ತೇ ಕೆದ್ರೊನ್ ಚ಼್ವಾಳ್, ವಲ್ಯಾಂಡುನ್ ಯಕ ಬಾಗತ್ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","ಯೇಸುಚಾ಼ ಘಾತ್ ಕರ್ತ್ಯಾಲ್ಯಾ ಯುದಾಲಾಬಿ ಹ್ಯೊ ಜಾ಼ಗಾ ಠಾವಾ ಹುತ್ತಾ ಕಾಮಂಜೆ ಯೇಸು ಆಪ್‌ಲ್ಯಾ ಶಿಶಾಂಚೆ ಸಂಗ ತವಾ ತವಾ ತಿಥ ಯಯಿತಾ. ");
INSERT INTO gok_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","ಹ್ಯಚಿ ಸಾಟಿ ಯುದಾನಿ ರೊಮ್ ಸೈನಿಕಾಂಚಾ಼ ಯೊಕ್ ತಂಡಾ ಆನಿ ಮುಖ್ಯ ಯಾಜಕ್ ಫರಿಸಾಯಾಂಚಾನಿ ಥೊಡ್ಯಾ ದೆವ್ಳಾಚಾ ರಕ್ವಲ್ದಾರಾನಾ ಲಾವುನ್ ದಿಲ. ತೇ ಲಾಟ್ನಿ, ಚು಼ಡಿ ಆನಿ ಹಾತ್ಯಾರಿ ದರುನ್ ಆಲ್ತ. ");
INSERT INTO gok_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","ಆಪ್‌ಲ್ಯಾಲಾ ವ್ಹನಾರ ಪರತೇಕ್ ಯೇಸುಲಾ ಸಮಾಜ಼್ಲ ಹುತ್ತ. ತ್ಯನಿ ಮೊರ‍್ಹ ಜಾ಼ವುನ್ ತುಮಿ ಕುನಾಲಾ ಶೊತ್ಯಾಸಾ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","ತ್ಯಂಚಾನಿ ನಜ಼ರೆತಿಚಾ ಯೇಸುಲಾ ಮನ್ಹುನ್ ಉತ್ತರ್ ದಿಲಾ. ತವಾ, “ಮೀಸ್ ತ್ಯೊ” ಮನ್ಲಾ. ತವಾ ಯೇಸುಚಾ಼ ಮೊಸ್ ಕೆಲ್ಯಾಲಾ ಯುದ್ ತ್ಯಂಚಿ ಸಂಗ ಉಬಾ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","ಕವಾ ಮೀಸ್ ತ್ಯೊ ಮನ್ಲಾ ತವಾ ತೇ ಮಾಗಸರುನ್ ಜಿಮ್ನಿವ ಪಡ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","ಯೇಸುನಿ ತ್ಯನಾ ಆನಿ ತುಮಿ ಕುನಾಲ ಸೊದಾಯಾ ಲಾಗ್‍ಲ್ಯಾಸಾ ಮನ್ಹುನ್ ಇಚಾರ್ಲ ತ್ಯಂಚಾನಿ ನಜ಼ರೆತಿಚಾ ಯೇಸುಲಾ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","ತವಾ ಯೇಸು, “ಮಿ ಆಂದಿಸ್ ಸಾಂಗ್‌ಲ್ಯಾ ನವ್ಹ ಮೀಸ್ ತ್ಯೊ ಮನ್ಹುನ್ ತುಮಿ ಮನಾ ಸುದಿತ್ ಆಸ್ಲಾಸಾತ ಬಾಕಿಚಾನಾ ಸುಡುನ್ ದೆವಾ.ಮನ್ಲಾ ");
INSERT INTO gok_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","ಹ್ಯಚಿ ಸಾಟಿ ತ್ಯೊ ಆಸಾ ಮನ್ಲಾ. “ತು ಮನಾ ದಿಲ್ಯಾಲ್ಯಾ ಲೊಕಾತ್ಲ ಯಾಕ್ಬಿ ಸಾಂಡ್ಲ ನಾಹಿ. ಮನ್ಹುನ್ ಯೇಸುನಿ ಆಂದಿ ಸಾಂಗ್‌ಲ್ಯಾಲಿ ಬುಲಿ ಆಸಿ ಖರಿ ಜಾ಼ಲಿ. ");
INSERT INTO gok_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","ಸಿಮೊನ್ ಪೇತ್ರಾಪ ಯಾಕ್ ತಲ್ವಾರ್ ಹುತ್ತ. ತ್ಯನಿ ತ್ಯ ತಲ್ವಾರ್ ಬಾಹಿರ್ ಕಾಡುನ್ ಮುಖ್ಯ ಯಾಜಕಾತ್‌ಲ್ಯಾ ಯಕಾ ಸೇವಕಾಚಾ಼ ಉಜ಼ವಾ ಕಾನ್ ತ್ಯೊಡ್ಲಾ ತ್ಯಾ ಸೇವಕಾಚ಼ ನಾವ್ ಮಾಲ್ಕ. ");
INSERT INTO gok_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","ಯೇಸುನಿ ಪೇತ್ರಾಲಾ ತುಜ಼ ತಲ್ವಾರ್ ಆತ್ ಗ್ಯಾಲ್. ಬಾನಿ ಮನಾ ದಿಲ್ಯಾಲ ತರಾಸಾಸ ಐದಾನ್ ಮಿ ಗಿಹ್ಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ತುಲಾ ಠಾವ ನಾಹಿ ಕ್ಯಾ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","ನಂತರ್ ರೊಮಾಚ಼ ಸೈನಿಕ್ ಆನಿ ತ್ಯಂಚಾ಼ ಜಾಂತಾ ಜಾ಼ಲ್ಯಾಲ್ಯಾ ಯೆಹುದ್ಯಾಂಚಾನಿ ಯೇಸುಲಾ ದರುನ್ ಬಾಂದುನ್ ಅನ್ನಾಪ ಆನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","ಅನ್ನಾ ಕಾಯಫಾಚಾ಼ ಸಾಸ್ರಾ. ತೇ ವರ್ಸಿ ಮುಖ್ಯ ಯಾಜಕ್ ಜಾ಼ಲ್ಥಾ. ");
INSERT INTO gok_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","ಸಗ್‍ಳ್ಯಾ ಲೊಕಾಂಚೆ ಸಾಟಿ ಯಕಾನಿ ಮರಾಚ಼ ಬರ ಮನ್ಹುನ್ ಯೆಹುದಿ ಅಧಿಕಾರ‍್ಯಾನಾ ಪಾರಕ್ ದಿಲ್ಯಾಲಿ ಕಾಯಫಾನಿಸ್. ");
INSERT INTO gok_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","ಸಿಮೊನ್ ಪೇತ್ರಾ ಆನಿ ಯೇಸುಚಾ ಶಿಶಾತ್ಲಾ ಆನಿ ಯೊಕ್ ಯೇಸುಚೆ ಮಾಗ್ನಿ ಮಾಗ್ನಿ ಗೇಲ. ತ್ಯಾ ಆನಿ ಯಕಾ ಶಿಶಾಲಾ ಮುಖ್ಯ ಯಾಜಕಾಚಿ ವಳಕ್ ಹುತ್ತಿ. ಮನ್ಹುನ್ ತ್ಯೊ ಮುಖ್ಯ ಯಾಜಕಾಚಾ ಗರ‍್ಹಾಚಾ ಆಂಗ್ನಾತ್ ಗೇಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","ಖರ ಪೇತ್ರಾ ದಾರಾಚೆ ಬಾಹಿರ್ ರಾಖಿತ್ ಹುತ್ತಾ ಮುಖ್ಯ ಯಾಜಕಾಚೆ ವಳ್ಕಿಚಾ಼ ಶಿಶಾ ಬಾಹಿರ್ ಯವುನ್ ಬೇಡ್ಯಾಪ ರಾಯ್ಲಾ. ತವಾ ಮಹಾ ಯಾಜಕಾಚಿ ವಳಕ್ ಆಸ್‌ಲ್ಯಾಲಾ ಶಿಶಾ ಬೆಡ ರ‍್ಯಾಕ್‌ತ್ಯಾಲೆ ತೇ ಪುರಿ ಸಂಗ ಬುಲುನ್ ಪೇತ್ರಾಲಾ ಆತ್ ಗಿಹುನ್ ಆಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","ದಾರ್ ರ‍್ಯಾಕ್ನಾರಿನಿ ಪೇತ್ರಾಲಾ ತ್ಯಾ ಮಾನ್ಸಾಚಾ ಶಿಶಾತ್ಲಾ ತುಬಿ ಯೊಕ್ ನವ್ಹಸ್ ಕ್ಯಾ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ಪೇತ್ರಾ ನಾಹಿ ಮಿ ನವ್ಹ! ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","ತವಾ ಥಂಡ್ ಹುತ್ತಿ ಮನ್ಹುನ್ ರ‍್ಯಾಕ್ನಾರ‍್ಯಾಂಚಾನಿ ಆನಿ ಸೈನಿಕಾಂಚಾನಿ ಇಸ್ತು ಕರುನ್ ತ್ಯಚೆ ಸರ್ ಬವಾರ ಉಬ ರಾಹುನ್ ಸೆಕತ ಪೇತ್ರಾಬಿ ಜಾ಼ವುನ್ ತ್ಯಂಚಿ ಸಂಗ ಸೆಕತ್ ಉಬಾ ರಾಯ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","ಮುಖ್ಯ ಯಾಜಕಾನಿ ಯೇಸುಲಾ ತ್ಯಚಾ ಶಿಶಾಂಚೆ ಗುಸ್ಟಿತ್ ತ್ಯನಿ ಸಿಕಿವ್‌ಲ್ಯಾಲ್ಯಾಚೆ ಗುಶ್ಟಿತ್ ಪ್ರಸ್ನೆ ಇಚಾರ್ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","ತ್ಯಲಾ ಯೇಸುನಿ ಮಿ ಉಗ್ಡುನ್ ಲೊಕಾಪ್ನಿ ಬೊಲ್ಯೊ ಕವಾಬಿ ಸಭಾಸ್ಥಾನಾತ್ ಆನಿ ದೇವ್ಳಾತ್ ಸಾಂಗ್‌ಲ್ಯಾಲ ಯೆಹುದಿ ಸಗ್ಳ ತಿಥ ಯಕಿಕ್ಡ ಮಿಳತ ಮಿ ಕಚ಼ಸ್ ದಡವುನ್ ಸಾಂಗ್ಲ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","ಆಸ ಆಸ್ಥಾನಾ ತು ಮನಾ ಪ್ರಶ್ನೆ ಕರಾಚಿ ಕಾ ಮಾಜ಼ ಸಿಕಿವ್ನ ಐಕ್‌ತ್ಯಾಲ್ಯಾ ಲೊಕಾನಾ ಇಚಾರ್ ಮಿ ಸಾಂಗ್‌ಲ್ಯಾಲ ತ್ಯನಾ ಠಾವ ಹಾ ಮನ್ಹುನ್ ಉತ್ತರ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","ಯೇಸುನಿ ಆಸ ಸಾಂಗ್ಲ ತವಾ ತಿಥ ಉಬಾ ರಾಯ್‌ಲ್ಯಾಲ್ಯಾ ರ‍್ಯಾಕ್ನಾರ‍್ಯಾತಲ್ಯಾ ಯಕಾನಿ ಯೇಸುವ ತಡಾಕಾ ದಿಲಾ ಆನಿ ತು ಮುಖ್ಯ ಯಾಜಕಾ ಸಂಗ ತಸ ಬೊಲಾಯಾ ಕ್ಯವ್ಡಾ ಧಿರ್? ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","ಯೇಸುನಿ ಮಿ ಚು಼ಕಿಚ಼ ಬೊಲ್ಲೊ ಆಸ್ಲೊತ ಮಿ ಸಾಂಗ್‌ಲ್ಯಾಲ ಚು಼ಕ್ ಮನ್ಹುನ್ ಹಿತ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ಸಗ್‌ಳ್ಯಾನಾ ದಾವುನ್ ದೇ ಫನ್ ಮಿ ಸಾಂಗ್‌ಲ್ಯಾಲ ಖರ ಆಸ್ಲತ ತು ಮನಾ ಮ್ಯಾರ್ಲಸ್ ಕಾ? ಮನ್ಹುನ್ ಉತ್ತರ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","ತವಾ ಅನ್ನಾನಿ ಯೇಸುಲಾ ಬ್ಯಾಂದ್ಲಾ ಹುತ್ತಾ ತಸಾಸ್ ಮುಖ್ಯ ಯಾಜಕ್ ಕಾಯಫಾಪ ಲಾವುನ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","ಸಿಮೊನ್ ಪೇತ್ರಾ ಆಪ್ಲ ಆಂಗ್ ಸೀಕ್ವಿತ್ ಇಸ್‍ಥ್ಯಾಪ ಉಬಾ ಹುತ್ತಾ. ತಿಥ ಆಸ್‍ಲ್ಯಾಲ್ಯಾ ಪೇತ್ರಾಲಾ ತ್ಯಾ ಶಿಶಾತ್ಲಾ ತು ಯೊಕ್ ನವ್ಹ ಕ್ಯಾ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ ತವಾ ಪೇತ್ರ, “ನವ್ಹ ಮಿ ನವ್ಹ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","ಮುಖ್ಯ ಯಾಜಕಾಚಾ ಸೇವಕಾತ್ಲಾ ಯೊಕ್ ಪೇತ್ರಾಪ್ನಿ ಕಾನ್ ಕಾತ್ರುನ್ ಗೆತಲ್ಯಾಲಾ ಸೇವಕಾಚಾ಼ ಪಾವ್ನಾ ಜಾ಼ಲ್ಥಾ. ತ್ಯೊ ಸೇವಕ್, “ತು ಬಾಗತ್ ತ್ಯಚಿ ಸಂಗ ರಾಯ್‌ಲ್ಯಾಲಾ ಮಿ ಬಗ್ಲಾ ನಾಹಿ ಕ್ಯಾ? ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","ಫನ್ ಪೇತ್ರಾ ಆನಿಕ್ ನಾಹಿ ಮಿ ತ್ಯಚಿ ಸಂಗ ನವ್ಥೊ ಮನ್ಲಾ ತ್ಯಾ ಬರ್ಬರ್ ಕೊಂಬ್ಡಾ ಬವ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","ನಂತರ್ ಯೆಹುದಿ ಯೇಸುಲಾ ಕಾಯಫಾಚಾ ಗರ‍್ಹಾತ್ನಿ ಫಾಟೆಕ್ ಸಕಾಳ್ಚಿ ರೊಮ್ ರಾಜ಼ಭಾರ್ ಕರ್ತ್ಯಾಲ್ಯಾಚಾ ಗರ‍್ಹಾತ್ ಹಾಕಟ್ಲಾ. ತವಾ ಪಾಂಡ್ರ ಜಾ಼ಲ್ಥ ಯೆಹುದಿ ಗರ‍್ಹಾತ್ ಗೇಲ ನಾಹಿತ ತೇ ವಲ್ಯಾಂಡಾಚಾ ಸನಾಚ಼ ಜೇವಾನ್ ಜೇವಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಆಪ್‌ಲ್ಯಾಲಾ ಬುರ್ಸ ಕರುನ್ ಗಿಹ್ಯಾ ಮನ್ ಕೆಲ ನಾಹಿ ");
INSERT INTO gok_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","ಮನ್ಹುನ್ ಪಿಲಾತ್ ತ್ಯಾ ಯೆಹುದ್ಯಾಪ್ನಿ ಆಲಾ ಆನಿ ತ್ಯಾ ಮಾನ್ಸಾವ ತುಮಿ ವಾವ್‌ತ್ಯಾಲಿ ಚು಼ಕ್ ಕ್ಯಾ ಮನ್ಹುನ್ ಇಚಾರ್ಲ ");
INSERT INTO gok_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","ಯೆಹುದಿ ಹ್ಯೊ ಚು಼ಕಿಚಾ಼ ನಸ್ಥಾತ ಹ್ಯಲಾ ಆಮಿ ತುಜಿಪ ಕಶಾಲಾ ಆನಿತಾವ್. ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","ಪಿಲಾತಾನಿ ಯೆಹುದಿ ಜಾ಼ಲ್ಯಾಲ ತುಮಿಸ್ ಹ್ಯಲಾ ಹಾಕ್ಟುನ್ ನವ್ಹ ತುಮ್ಚಾ ಧರ್ಮಶಾಸ್ತಾರಾಚೆಗತ್ ನ್ಯಾಯಿ ಕರಾ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ಯೆಹುದಿ ಖರ ಯಕಾಲಾ ಮರ್ನಾಚಿ ಶಿಕ್ಷಾ ದಿಯಾ ತುಮ್‌ಚಾ಼ ಕಾನುನ್ ಆಮಾನಾ ಅವಕಾಸ್ ದಿಯಿತ್ ನಾಹಿ. ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","ಆಪ್‌ಲ್ಯಾ ಮರ್ನಾಚ಼ ಯೇಸುನಿ ಸಾಂಗ್‌ಲ್ಯಾಲ ಖರ ವ್ಹಯಾ ಆಸ ಜಾ಼ಲ. ");
INSERT INTO gok_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","ನಂತರ್ ಪಿಲಾತ್ ಗರ‍್ಹಾತ್ ಮಾಗಾರಾ ಜಾ಼ವುನ್ ಯೇಸುಲಾ ಹಾಕ್ಟುನ್ ತು ಯೆಹುದ್ಯಾಂಚಾ಼ ರಾಜಾ಼ ಕ್ಯಾ ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","ಯೇಸು ಹ್ಯೊ ತುಜಾ಼ಸ್ ಪ್ರಶ್ನೆ ಕ್ಯಾ? ನಾಹಿತ ಮಾಜ಼ ದುಸ್‍ರ‍್ಯಾ ಲೊಕಾಂಚಾನಿ ತುಲಾ ಸಾಂಗ್ಲ? ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","ಪಿಲಾತಾನಿ ಉತ್ತರ್ ದಿಲಾ, “ಮಿ ಯೆಹುದಿ ಮನ್ಹುನ್ ತು ಯವಜ಼ಲಸ್ ಕ್ಯಾ? ಹಿ ತುಜಿ ಸ್ವತಾಚಿ ಲೊಕ ಜಾ಼ಲ್ಯಾತ ಆನಿ ಮುಖ್ಯ ಯಾಜಕಾಂಚಾನಿ ತುಲಾ ಮಾಜಾ ತಾಬ್ಯಾತ್ ದಿಲ್ಯಾ ತು ಕ್ಯಾ ಕೆಲಸ್. ” ");
INSERT INTO gok_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","ಯೇಸುನಿ ಮಾಜ಼ ರಾಜೆ ಹೆ ದುನೆತ್ಲ ನವ್ಹ. ತ್ಯ ಹೆ ದುನೆತ್ಲ ಆಸ್ತತ ಮಿ ಯೆಹುದ್ಯಾಂಚಾ ಹಾತಾತ್ ಗಾಹುನಾಹಿ ಆಸ ಮಾಜ಼ ಸೆವಕ್ ಮಾಜಿಸಾಟಿ ಲಡ್ಲ ಆಸ್ತ ಫನ್ ಮಾಜ಼ ರಾಜೆ ಹಿತ್ಲ ನವ್ಹ” ಮನ್ಲಾ ");
INSERT INTO gok_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","ಪಿಲಾತ್ ಮನ್ಲಾ, “ತಸ ಜಾ಼ಲ್ಯಾ ತು ರಾಜಾ಼ ಕ್ಯಾ? ತವಾ ಯೇಸುನಿ ಉತ್ತರ್ ದಿಲಾ, “ತು ಮಂಥ್ಯೊಸ್ ಮಿ ರಾಜಾ಼. ಮಿ ಲೊಕಾನಾ ಖರ‍್ಯಾಚೆ ಗುಶ್ಟಿತ್ ಸಾಂಗಾಯಾ ಸಾಟಿ ಜ಼ಲಾಮ್‌ಲ್ಯೊ ತ್ಯಚಿಸ್ ಲಾಗುನ್ ಮಿ ಹೆ ದುನೆತ್ ಆಲ್ಯೊ ಖರ‍್ಯಾತ್ ಮಿಸಾಳ್ಯಾಲಾ ಪರತೇಕ್ ಮಾಜಿಕ್ಡ ಕಾನ್ ದೇತೊ” ಮನ್ಹುನ್ ಉತ್ತರ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","ಪಿಲಾತ್, “ ಖರ ಮಂಜೆ ಕ್ಯಾ ಮನ್ಹುನ್ ಇಚಾರುನ್ ಆನಿಕ್ ಯೆಹುದ್ಯಾಂಚಿಪ ಬಾಹಿರ್ ಯವುನ್ ಹ್ಯಚಿಪ ಮನಾ ಚು಼ಕ್ ಕಾಯ್ ದಿಸತ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","ಫನ್ ವಲ್ಯಾಂಡಾಚಾ ಸನಾಚಾ ದಿಸಾತ್ ಮಿ ತುಮ್ಚಿ ಸಾಟಿ ಗುನ್ನದಾರಾತಲ್ಯಾ ಯಕಾಲಾ ಸೊಡಾಚಿ ತುಮ್ಚಿ ಪದ್ದತ್ ಜಾ಼ಲ್ಹೆ. ತಸಾ ಮಿ ಯೆಹುದ್ಯಾಚಾ ರಾಜಾಲಾ ಸೊಡಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ತುಮಿ ಮನ್ ಕರ್ತ್ಯಾಸಾ ಕ್ಯಾ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","ಯೆಹುದ್ಯಾಂಚಾನಿ ನಾಹಿ ತ್ಯಲಾ ನವ್ಹ ಬರಬಾಲಾ ಸೊಡಾ ಮನ್ಹುನ್ ವರಾಡ್ಲಿತ ಹ್ಯೊ ಬರಬ್ಬ ಯೊಕ್ ಚ಼ೊರ್ ಜಾ಼ಲ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","ನಂತರ್ ಯೇಸುಲಾ ದರ್‍ಹುನ್, ಚಾಬುಕಾನಿ ಮಾರಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಪಿಲಾತಾನಿ ಆಜ್ಞೆ ದಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","ಸೈನಿಕಾಂಚಾನಿ ಕಾಟ್ಯಾಚಾ ಡಾಳ್ಯಾಂಚಾನಿ ಯಾಕ್ ಕಿರೀಟ್ ಕರುನ್ ಯೇಸುಚೆ ಡುಯಿವ ಥೆವ್ಲ. ನಂತರ್ ಸೈನಿಕಾಂಚಾನಿ ಯೇಸುಲಾ ಜಾ಼Oಬ್ಳಿ ಆಂಗಿ ಗ್ಯಾತ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","ತ್ಯಚಿಪ ಯವುನ್ ಯೆಹುದ್ಯಾಂಚಾ ರಾಜಾ ತುಲಾ ನಮಸ್ಕಾರ್ ಮನ್ಹಿತ್ ತ್ಯಚಾ ಗಾಲಾವ ಮ್ಯಾರ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","ಪಿಲಾತ್ ಆನಿಕ್ ಬಾಹಿರ್ ಯವುನ್ ಯೆಹುದ್ಯಾನಾ ಬಗಾ ಮಿ ಯೇಸುಲಾ ತುಮ್ಚಿಪ ಆಂತ್ಯೊ ತ್ಯಚಿಪ ಮನಾ ಕಾಯ್ ಚು಼ಕ್ ದಿಸತ್ನಾಹಿ ಮನ್ಹುನ್ ತ್ಯೊ ಮನಾ ಸಮಾಜ಼್ಲ ನಾಹಿ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","ತವಾ ಯೇಸು ಬಾಹಿರ್ ಆಲಾ ತ್ಯಚೆ ಡುಯಿವ ಕಾಟ್ಯಾಚ಼ ಕಿರೀಟ್ ಥೆವ್ಲ ಆನಿ ಜಾ಼ಂಬ್ಳಿ ಆಂಗಿ ತ್ಯಲಾ ಗ್ಯಾತ್ಲಿ ಪಿಲಾತಾನಿ ಯೆಹುದ್ಯಾನಾ ಹಬೊ ಹ್ಯೊ ಮಾನುಸ್ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ ");
INSERT INTO gok_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","ಮುಖ್ಯ ಯಾಜಕ್ ಆನಿ ಯೆಹುದಿ ದಿವುಳ್ ರ‍್ಯಾಕ್ನಾರ‍್ಯಾಂಚಾನಿ ಯೇಸುಲಾ ಬಗುನ್ ತ್ಯಲಾ ಶಿಲ್ಬೆವ ಗಾಲಾ ತ್ಯಲಾ ಶಿಲ್ಬೆವ ಗಾಲಾ ಮನ್ಹುನ್ ವರಾಡ್‌ತ್ಯಾತ. ಫನ್ ಪಿಲಾತ್ ತುಮಿಸ್ ತ್ಯಲಾ ಗೆವ್ಹಾ ಆನಿ ಶಿಲ್ಬೆವ ಗಾಲಾ ಮನಾ ತ್ಯಚಿಪ ಕಾಯ್ ಚು಼ಕ್ ದಿಸತ್‌ ನಾಹಿ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","ಯೆಹುದಿ ಆಮಾನಾ ಯೊಕ್ ನೆಮ್ ಹಾ ತ್ಯಚಿಗತ್ ಹ್ಯಲಾ ಮರ್ನಾಚಿ ಶಿಕ್ಷಾ ವ್ಹಯಾ ವ್ಹಯಿ ಕಾ ಮಂಜೆ ಹ್ಯೊ ಆಪ್‌ಲ್ಯಾಲಾಸ್ ದೇವಾಚಾ಼ ಲ್ಯೊಕ್ ಮಂತ್ಯೊ. ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","ಹ್ಯ ಐಕುನ್ ಪಿಲಾತ್ ಖುಬ್ ಬಿಹ್ಯಾಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","ಆನಿಕ್ ಆಂಗ್ನಾತ್ ಜಾ಼ವುನ್ ಪಿಲಾತಾನಿ ತು ಕುಟ್ಲಾ ಮನ್ಹುನ್ ಇಚಾರ್ಲ ಪನ್ ಯೇಸುನಿ ಕಾಯ್ ಉತ್ತರ್ ದಿಲಾನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","ಪಿಲಾತಾನಿ ತು ಮಾಜಿ ಸಂಗ ಬೊಲತ್ ನಾಹಿಸ್ ಕ್ಯಾ ತುಲಾ ಸೊಡ್ವಾಚಾ಼ ಅಧಿಕಾರ್ ಆನಿ ಶಿಲ್ಬೆವ ಗಾಲಾಚಾ಼ ಅಧಿಕಾರ್ ಮನಾ ಹಾ ಮನ್ಹುನ್ ತುಲಾ ಠಾವ ನಾಹಿಕ್ಯಾ ಮನ್ಲಾ ");
INSERT INTO gok_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","ಯೇಸುನಿ ಉತ್ತರ್ ದಿಲಾ ತಿತ್ ಪರ‍್ಯಾತ್ ತುಲಾ ಮಾಜಿವ ಕಚಾ ಅಧಿಕಾರ್ ನವ್ಥಾ. ಕುಟ್ಪರ‍್ಯಾತ್ ತ್ಯ ತುಲಾ ದೇವಾಪ್ನಿ ದಿಲ್ತ. ಕಚಾ ಮಾನ್ಸಾನಿ ತುಲಾ ಮಾಜಾ ಹಾತಾತ್ ದಿಲ್ಯಾ. ತ್ಯೊ ಖುಬ್ ಮೊಟ್ಯಾ ಪಾಪಾಚಾ಼ ದೊಶಿ ಜಾ಼ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","ಹ್ಯ ಜಾ಼ಲ್ಯಾ ನಂತರ್ ಯೇಸುಲಾ ಸೊಡ್ವಾಯಾ ಪಿಲಾತಾನಿ ಯತ್ನ ಕಿಲಿತ ಫನ್ ಯೆಹುದಿ ಆಪ್‌ಲ್ಯಾಲಾ ರಾಜಾ಼ ಮನ್ಹುನ್ ಸಾಂಗ್‌ತ್ಯಾಲಾ ಕುಟ್ಲಾ ಮಾನುಸ್ ಸಿಸರಾಚಾ಼ ವಾದಿ ಜಾ಼ಲ್ಯಾ. ಮನ್ಹುನ್ ತು ಹ್ಯಾ ಮಾನ್ಸಾಲಾ ಸುಡಿವ್ಲಾಸ್ತ ತು ಸಿಸರಾಚಾ಼ ಸುಪ್ತಿ ನವ್ಹ” ಮನ್ಹುನ್ ವರಾಡ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","ಯೆಹುದ್ಯಾಂಚಾನಿ ಸಾಂಗ್‌ಲ್ಯಾಲ ಐಕುನ್ ಪಿಲಾತಾನಿ ಯೇಸುಲಾ ಬಾಹಿರ್ ಹಾಕ್ಟುನ್ ದೊಂಡ್ಯಾನಿ ಕೆಲ್ಯಾಲ್ಯಾ ಕಠ್ಯಾವ ನೆಲ್ಹಾ ತ್ಯಾ ಜಾ಼ಗ್ಯಾಲಾ ಇಬ್ರಿಯಾ ಬಾಶೆತ್ ತ್ಯಂಚ಼ ನಾವ್ ಗಬ್ಬಥ ವೈಲೆ ನ್ಯಾಯಿ ಕರ್ತ್ಯಾಲೆ ಖುರ್ಚಿವ ಬಸ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","ತಿಸಿ ವಲ್ಯಾಂಡಾಚಾ ಸನಾಚೆ ತಯಾರಿಚಾ಼ ದೀಸ್ ಜಾ಼ಲ್ತಾ ತವಾಸ್ ಜ಼ವಜ಼ವಳ್ ದುಪ್ಯಾರ್ ಜಾ಼ಲ್ಥಿ ಪಿಲಾತಾನಿ ಯೆಹುದ್ಯಾನಾ ಹಬೊಕ್ ತುಮಚಾ಼ ರಾಜಾ಼ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ ");
INSERT INTO gok_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","ತವಾ ಯೆಹುದಿ ಮಾರುನ್ ಟಾಕಾ ಮಾರುನ್ ಟಾಕಾ ತ್ಯಲಾ ಶಿಲ್ಬೆವ ಗಾಲಾ ಮನ್ಹುನ್ ವರಾಡ್ಲ ಪಿಲಾತಾನಿ ಯೆಹುದ್ಯಾನಾ ತುಮ್ಚಾ ರಾಜಾಲಾ ಶಿಲ್ಬೆವ ಗಾಲಾಯಾ ವ್ಹಯಿ ಕ್ಯಾ? ಮನ್ಹುನ್ ಇಚಾರ್ತೊ. ತವಾ ಮುಖ್ಯ ಯಾಜಕಾಂಚಾನಿ ಆಮಾನಾ ಸಿಸರಾಲಾ ಸುಡುನ್ ದುಸ್ರಾ ರಾಜಾ಼ ನಾಹಿ” ಮನ್ಹುನ್ ಉತ್ತರ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","ತವಾ ಪಿಲಾತಾನಿ ಯೇಸುಲಾ ಶಿಲ್ಬೆವ ಗಾಲಾಯಾ ತ್ಯಂಚಿಪ ದಿಲಾ. ಆಸ ತ್ಯಂಚಾನಿ ಯೇಸುಲಾ ಆಪ್‌ಲ್ಯಾ ತಾಬ್ಯಾತ್ ಗೆತ್ಲಾ. ಸೈನಿಕಾಂಚಾನಿ ಯೇಸುಲಾ ಹಾಕ್ಟುನ್ ನೇಲಾ ");
INSERT INTO gok_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","ಯೇಸು ಆಪ್ಲಿ ಶಿಲ್ಬೆ ಗಿಹುನ್ ಬಾಹಿರ್ ಆಲಾ ಆನಿ ಟಕ್ಲ ಮಂಥ್ಯಾಲ್ಯಾ ಜಾ಼ಗ್ಯಾತ್ ನಿಗಾಲಾ ಇಬ್ರಿಯಾ ಬಾಶೆತ್ ಹ್ಯಾ ಜಾ಼ಗ್ಯಾಚ಼ ನಾವ್ ಗೊಲ್ಗೊಥಾ ");
INSERT INTO gok_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","ತಿಥ ತ್ಯಂಚಾನಿ ತ್ಯಲಾ ಶಿಲ್ಬೆತ್ ಗ್ಯಾತ್ಲ ತ್ಯಚಿ ಸಂಗ ಆನಿ ದೊಗಾನಾ ಗ್ಯಾತ್ಲ. ತ್ಯನಾ ದೊಗಾನಾ ಯೇಸುಚೆ ದೊಯಾಂಗ್ನಿ ಗಾಲ್ಹುನ್ ಯೇಸುಲಾ ತ್ಯಂಚೆ ಮದ್ದಿ ಗ್ಯಾತ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","ಪಿಲಾತಾನಿ ಯೇಕ ಫಳಿವ ಲಿವುನ್ ಶಿಲ್ಬೆವ ತ್ಯಚಿವರ್ ಲ್ಯಾವ್ಲಿ ತೇ ಫಳಿವ ನಜ಼ರೆತಿಚಾ಼ ಯೇಸು ಯೆಹುದ್ಯಾಂಚಾ಼ ರಾಜಾ಼ ಮನ್ಹುನ್ ಲಿವ್ಲ ಹುತ್ತ. ");
INSERT INTO gok_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","ತೇ ಫಳಿಲಾ ಇಬ್ರಿಯಾ ಬಾಶೆತ್ ಲ್ಯಾಟಿನ್ ಆನಿ ಗ್ರೀಕ್ ಬಾಶೆನಿ ಲಿವ್ಲ ಹುತ್ತ. ಫಳಿವ ಲಿವ್‌ಲ್ಯಾಲ ಖುಬ್ ಲೊಕಾಂಚಾನಿ ವಾಚಿವ್ಲ ಕಾ ಮಂಜೆ ಕುಠ ಯೇಸುಲಾ ಶಿಲ್ಬೆವ ಗ್ಯಾತ್ಲಾ ಹುತ್ತಾ ತ್ಯೊ ಜಾ಼ಗಾ ಪೆಠಚೆ ಜ಼ವಳ್ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","ಯೆಹುದ್ಯಾಂಚಾ ಮುಖ್ಯ ಯಾಜಕಾಂಚಾನಿ ಪಿಲಾತಾಲಾ ಯೆಹುದ್ಯಾಂಚಾ಼ ರಾಜಾ಼ ಮನ್ಹುನ್ ಲಿವು ನಕೊಸ್. ಹ್ಯಚೆ ಬದ್ಲಿ ಆಪ್‌ಲ್ಯಾಲಾಸ್ ಯೆಹುದ್ಯಾಂಚಾ಼ ರಾಜಾ಼ ಮನ್ಹಿತಾ ಮನ್ಹುನ್ ಲಿವ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","ಪಿಲಾತಾನಿ ಮಿ ಲಿವ್‌ಲ್ಯಾಲ ಕಾಡಾಯಾ ಯಯಿತ್ನಾಹಿ ಮನ್ಹುನ್ ಉತ್ತರ್ ದಿಲಾ ");
INSERT INTO gok_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","ಸೈನಿಕಾಂಚಾನಿ ಯೇಸುಲಾ ಶಿಲ್ಬೆತ್ ಗ್ಯಾತ್‌ಲ್ಯಾ ನಂತರ್ ತ್ಯಚಾ ಕಪ್‌ಡ್ಯಾಂಚ಼ ಚಾರ್ ಭಾಗ್ ಕರುನ್ ಯಕಾ ಯಕಾನಿ ಯೊಕ್ ಯೊಕ್ ಭಾಗ್ ಗೇತ್ಲಾ. ತ್ಯಚಿ ಆತ್ಲಿ ಆಂಗಿ ಬಿ ಗಿತ್ಲಿ ತೀ ಸಿವನ್ ನಸ್ಥಾನಾ ಆಖಂಡ್ ತಸಿಸ್ ಹುತ್ತಿ. ");
INSERT INTO gok_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","ಮನ್ಹುನ್ ಸೈನಿಕ್ ಆಮಿ ಫಾಟುನ್ ವಾಟ್ನಿ ಕರಾಚಿ ನಾಹಿ. ಆಮಿ ಚೀಟ್ಯಾ ಗಾಲ್ಹುನ್ ಹ್ಯ ಕುನಾಲಾ ಯತ್ಯಾ ಬಗುಯಾ ಮನ್ಹುನ್ ಬುಲುನ್ ಗಿಹುನ್ ತಸಸ್ ಕೆಲ. ತ್ಯಂಚಾನಿ ಮಾಜ಼ ಕಪ್ಡ ಆಪ್ಲಿಪ ವಾಟ್ನಿ ಕೆಲ. ಮಾಜೆ ಆಂಗಿ ಸಾಟಿ ಚೀಟಿ ಗ್ಯಾತ್ಲಿ. ಮನ್ಹುನ್ ಧರ್ಮ ಶಾಸ್ತಾರಾತ್ ಲಿವ್‌ಲ್ಯಾಲಿ ಬುಲಿ ಆಸಿ ಖರಿ ಜಾ಼ಲಿ. ");
INSERT INTO gok_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","ಯೇಸುಚಿ ಆಯಿ ತಿಚಿ ಭನ್ ಕ್ಲೊಪಾಚಿ ದನ್ಗರ್ ಮರಿಯಾ ಆನಿ ಮಗ್ದಲಾಚಿ ಮರಿಯಾ ಶಿಲ್ಬೆಪ ಉಬ್ಯಾ ಹುತ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","ಯೇಸುನಿ ಆಪ್ಲೆ ಆಯಿಲಾ ಆನಿ ತಿಥಸ್ ಉಬಾ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ಆಪ್‌ಲ್ಯಾ ಮಾಯೆಚಾ ಶಿಶಾಲಾ ಬಗುನ್ ಆಪ್ಲೆ ಆಯಿಲಾ ಆಯಿ ಹಬೊಕ್ ತುಜಾ಼ ಲ್ಯೊಕ್ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","ನಂತರ್ ಯೇಸು ಆಪ್‌ಲ್ಯಾ ಶಿಶಾಲಾ ಹಬಿಕ್ ತುಜಿ ಆಯಿ ಮನ್ಲಾ ತವಾಚಾನ್ ತ್ಯಾ ಶಿಶಾನಿ ತಿಲಾ ಹಾಕ್ಟುನ್ ನಿಹುನ್ ಆಪ್‌ಲ್ಯಾ ಗರ‍್ಹಾತ್ ಥಿವ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","ಹ್ಯ ಜಾ಼ಲ್ಯಾವ ಸಗ್ಳ ಘಡ್ಲ ಮನ್ಹುನ್ ಸಮಜು಼ನ್ ಧರ್ಮ ಶಾಸ್ತಾರಾಚಿ ಬುಲಿ ವ್ಹಯಾ ಸಾಟಿ ಯೇಸು ಮನಾ ತಾನ್ ಲಾಗ್ಲೆ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","ತಿಥ ಸಾದ್ಯಾ ಆಂಬಾಟ್ ದರಾಕ್ಶಿಚಾ ರಸಾಚ಼ ಐದಾನ್ ಯಾಕ್ ಹುತ್ತ ಸೈನಿಕಾಂಚಾನಿ ಕಾಪುಸ್ ಆಂಬ್ಟಾಚಾ ರಸಾತ್ ಬುಡುವುನ್ ಹಿಸ್ಸೊಪ್ ಜಾ಼ಡ್ಹಾಚೆ ಕಾಠಿತ್ ಗಾಲ್ಹುನ್ ತ್ಯ ವರ್ ಕರುನ್ ಯೇಸುಚಾ ತೊಂಡಾಸ್ ಲ್ಯಾವ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","ಯೇಸುನಿ ಆಂಬಾಟ್ ದರಾಕ್ಶಿಚಾ಼ ರಸ್ ಜು಼ರ್ಪುನ್ ಸರ್ಲ ಮನ್ಹುನ್ ಸಾಂಗುನ್ ಡುಯಿ ಖಾಲ್ ಕರುನ್ ಜೀವ್ ಶೊಡ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","ಆನಿ ಯೆಹುದ್ಯಾಂಚಾನಿ ಪಿಲಾತಾಲಾ ತ್ಯಂಚ಼ ಪ್ಯಾ ಮುಡುನ್ ಬಿಗಿನಿ ಶಿಲ್ಬೆವ್ನಿ ಖಾಲ್ ಉತ್ರಾಯಾ ಸಾಂಗ್ಲ ಕಾ ಮಂಜೆ ತ್ಯೊ ಸುಕಿರ‍್ವಾರ್ ತಯಾರಿಚಾ಼ ದೀಸ್ ಜಾ಼ಲ್ಥಾ ಆನಿ ಸಬ್ಬತ್ ದಿಸಾ ದಿಸಿ ಮಡಿ ಶಿಲ್ಬೆವ ರಾಹ್ಯಾಚಿ ನಕೊತ ಮನ್ಹುನ್ ಕಾ ಮಂಜೆ ಯತ್ಯಾಲಾ ವಲಾಂಡ್ಯಾಚಾ ಸನ್ ಖುಬ್ ಪವಿತ್ರ ಜಾ಼ಲ್ತಾ ");
INSERT INTO gok_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","ಮನ್ಹುನ್ ಸೈನಿಕಾಂಚಾನಿ ಯವುನ್ ಯೇಸು ಸಂಗ ಶಿಲ್ಬೆತ್ ಗ್ಯಾತ್‌ಲ್ಯಾಲ್ಯಾ ದೊಗಾಂಚ಼ ಪ್ಯಾ ಮ್ಯೊಡ್ಲ ");
INSERT INTO gok_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","ನಂತರ್ ತೇ ಯೇಸುಪ ಆಲತವಾ ತ್ಯೊ ಆಂದಿಸ್ ಮೆಲ್ಯಾಲಾ ಬಗುನ್ ತ್ಯಚ಼ ಪ್ಯಾ ಮ್ಯೊಡ್ಲ ನಾಹಿತ ");
INSERT INTO gok_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","ಫನ್ ಸೈನಿಕಾತ್‌ಲ್ಯಾ ಯಕಾನಿ ಆಪ್ಲೆ ಬರ್ಚಿನಿ ಯೇಸುಚೆ ಕುಸ್ಸಿತ್ ಟ್ಯೊಪ್ಲ ಕುಸಿತ್ನಿ ರಗಾತ್ ಆನಿ ಪಾನಿ ಬಾಹಿರ್ ಆಲ. ");
INSERT INTO gok_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","ಹ್ಯ ಬಗ್‌ಲ್ಯಾಲ್ಯಾನಿ ಹ್ಯಚೆ ಗುಶ್ಟಿತ್ ಸಾಕ್ಷಿ ದಿಲೆ. ತುಮಿ ಇಸ್ವಾಸ್ ಥೆವಾಯಾ ತ್ಯನಿ ಹಿ ಸಾಕ್ಷಿ ಸಾಂಗಲೆ. ತ್ಯ ತ್ಯಲಾ ಖರ ಮನ್ಹುನ್ ಠಾವ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","ಧರ್ಮ ಶಾಸ್ತಾರಾತ್ ಲಿವ್‌ಲ್ಯಾಲ ತ್ಯಚಾ ಹಾಡಾತ್ಲ ಯಾಕ್ಬಿ ಹಾಡ್ ಮೊಡ್ನಾರ್ ನಾಹಿ ಮಂಥ್ಯಾಲಿ ಬುಲಿ ಆಸಿ ಘಡ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","ಧರ್ಮ ಶಾಸ್ತಾರಾತ್ ಆನಿ ಯಕಿಕ್ಡ ಲಿವ್‌ಲ್ಯಾ ಲೊಕ ಆಪ್ನು ಬರ್ಚಿ ಟ್ಯೊಪ್‌ಲ್ಯಾಲ್ಯಾಲಾ ಜ಼ಪುನ್ ಬಗ್ನಾರ್ ಮನ್ಹುನ್. ");
INSERT INTO gok_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","ಹ್ಯ ಜಾ಼ಲ್ಯಾವ ಅರಿಮತ್ತಾಯಾ ಗಾವಾತ್ಲಾ ಯೊಸೆಪ್ ಮಂಥ್ಯಾಲಾ ಯೇಸುಚ಼ ಮಡ ಆಪ್‌ಲ್ಯಾಲಾ ದಿಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಪಿಲಾತಾಪ ಮಾಗ್ತೊ. ಯೊಸೆಪ್ ಯೇಸುಚಾ಼ ಯೊಕ್ ಶಿಶಾ ಜಾ಼ಲ್ಥಾ ಮನ್ಹುನ್ ತ್ಯೊ ಯೆಹುದ್ಯಾನಾ ಬಿಹುನ್ ಹುತ್ತಾ. ಆನಿ ತ್ಯಚೆ ಗುಶ್ಟಿತ್ ಲೊಕಾನಾ ಸಾಂಗ್ಲ ನವ್ಥ. ಯೇಸುಚ಼ ಮಡ ಗಿಹುನ್ ಜಾ಼ಯಾ ಪಿಲಾತಾನಿ ತ್ಯಲಾ ಹುಕುಮ್ ದಿಲಾ. ಮನ್ಹುನ್ ತ್ಯೊ ಯವುನ್ ಯೇಸುಚ಼ ಮಡ ಗಿಹುನ್ ಗೇಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","ನಿಕೊದೇಮ್ ಯೇಸುಚೆ ಸಂಗ ಗೇಲಾ ಮಾಗ ಯೇಕ ರಾತಿತ್ ಯೇಸುಪ ಯವುನ್ ತ್ಯಚಿ ಸಂಗ ಬೊಲ್ಯಾಲಾ ನಿಕೊದೇಮುಸ್‍ ತ್ಯೊ ಜ಼ವಜ಼ವಳ್ ತೀಸ್ ಕಿಲೊ ವಾಸಾಚ಼ ತ್ಯಾಲ್ ಗಿಹುನ್ ಆಲಾ ತ್ಯ ವಾಸಾಚ಼ ತ್ಯಾಲ್ ರಗಾತ್ ಬಾವ್ಲಿ ಆನಿ ಚುರ‍್ಯಾನಿ ಮಿಳುನ್ ಹುತ್ತ. ");
INSERT INTO gok_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","ಹೆ ದೊಗ ಯೇಸುಚ಼ ಮಡ ಗಿಹುನ್ ತ್ಯಲಾ ವಾಸಾಚ಼ ತ್ಯಾಲ್ ಗಾಲ್ಹುನ್ ಕಪ್ನಾನಿ ಬ್ಯಾಂದ್ಲಾ ಯೆಹುದ್ಯಾಂಚೆ ಪದ್ದತಿಚೆಗತ್ ತ್ಯಲಾ ತಯಾರ್ ಕೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","ಕುಠ ಯೇಸುಲಾ ಶಿಲ್ಬೆವ ಗ್ಯಾತ್ಲಾ ಹುತ್ತಾ ತಿಥ ಯೆಕ್ ಬಾಗ್ ಹುತ್ತಿ ತೆ ಬಾಗತ್ ಮಡಿ ಗ್ಯಾಲತ್ಯಾಲಿ ಯೆಕ್ ನವಿ ಮಸುರ್ಡಿ ಹುತ್ತಿ. ತ್ಯಾತ್ ಹಿತ್ಪರ‍್ಯಾತ್ ಕುನಾಲಾ ಗ್ಯಾತ್ಲ ನವ್ಥ ");
INSERT INTO gok_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","ತ್ಯೊ ಸಬ್ಬತಾಚಾ಼ ದಿಸ್ ಸುಕಿರ್ವಾರ್ ಹುತ್ತಾ. ತ್ಯಚಿಸಾಟಿ ಯೆಹುದ್ಯಾಂಚಾನಿ ಯೇಸುಲಾ ಮಸುರ್ಡಿತ್ ಥೆವ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","ಆಯಿತ್ವಾರಿ ಖರ್ ಫಾಕ್ತಾನಾ ಮಗ್ದಲಾಚಿ ಮರಿಯಾ ಯೇಸುಚ಼ ಮಡ ಆಸ್‌ಲ್ಯಾಲೆ ಮಸುರ್ಡಿಕ್ಡ ಆಲಿ. ತವಾ ಆಜು಼ನ್ ಕಾಳೊಕ್ ಹುತ್ತಾ ಮಸುರ್ಡಿಚಾ ದಾರಾವ ಜಾ಼ಕ್‌ಲ್ಯಾಲಾ ಮೊಟಾ ದೊಂಡಾ ತಿಥ್ನಿ ಕ್ಯಾಡ್‍ಲ್ಯಾಲಾ ಮರಿಯಾನಿ ಬಗ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","ಸಿಮೊನ್ ಪೇತ್ರಾಪ ಆನಿ ಯೇಸುಚಾ ಮಾಯೆಚಾ ಶಿಶಾಪ ತೀ ಪಳತ್ ಯವುನ್ ಮಸುರ್ಡಿತ್ನಿ ಪ್ರಭುಲಾ ಕುಠ ಗ್ಯಾತ್‌ಲ್ಯಾ ತ್ಯಲಾ ಥೆವ್‌ಲ್ಯಾ ಆಮಾನಾ ಠಾವ ನಾಹಿ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","ತವಾ ಪೇತ್ರಾ ಆನಿ ಯೊಕ್ ಶಿಶಾ ಮಸುರ್ಡಿಪ ಗೇಲ. ");
INSERT INTO gok_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","ತೀ ದೊಗ ಪಳತ್ ಗಿಲಿತ ಫನ್ ಆನಿ ಯೊಕ್ ದಿಸ್ರಾ ಶಿಶಾ ಪೇತ್ರಾವ್ನಿ ಜೊ಼ರ್ ಪಳತ್ ಜಾ಼ವುನ್ ಮಸುರ್ಡಿಪ ಆಂದಿ ಗೇಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","ತ್ಯಾ ಶಿಶಾನಿ ವಾಕುನ್ ಆತ್ ಬಗ್ಲ. ತಿಥ ಕಪ್ನಾಚ಼ ಕಪ್ಡ ಪಡ್ಲ ಹುತ್ತ. ಫನ್ ತ್ಯೊ ಆತ್ ಗೇಲಾ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","ಮಾಗ್ನಿ ಆಲ್ಯಾಲಾ ಸಿಮೊನ್ ಪೇತ್ರಾ ನೀಟ್ ಆತ್ ಗೆಲಾ. ಆನಿ ಕಪ್ನಾಚ಼ ಕಪ್ಡ ಮಸುರ್ಡಿತ್ ಪಡ್‌ಲ್ಯಾಲ. ");
INSERT INTO gok_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ತ್ಯಚೆ ಡುಯಿಲಾ ಬ್ಯಾಂದ್‍ಲ್ಯಾಲಾ ಕಪ್ಡಾ. ಗೊಳಾ ಕರುನ್ ಕಪ್ನಾಚ಼ ಕಪ್ಡ ಸುಡುನ್ ದುಸ್ರಿಕ್ಡ ಪಡ್ಲ ಹುತ್ತ. ");
INSERT INTO gok_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","ಮಂಗ್ ಆಂದಿಚಾ಼ ಶಿಶಾಬಿ ಆತ್ ಗೆಲಾ ತ್ಯನಿ ಮಸುರ್ಡಿತ್ ಜಾ಼ಲ್ಯಾಲ ಬಗುನ್ ಇಸ್ವಾಸ್ ಥೆವ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","ತ್ಯೊ ಮರುನ್ ಜಿತ್ತಾ ವ್ಹವುನ್ ಉಠುನ್ ಯಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ದರ್ಮ ಶಾಸ್ತಾರಾತ್ ಲಿವ್‍ಲ್ಯಾಲ ಹ್ಯಾ ಶಿಶಾನಾ ಆಜು಼ನ್ ಸಮಾಜ಼್ಲ ನವ್ಥ. ");
INSERT INTO gok_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","ಮಂಗ್ ಶಿಶಾ ಮಾಗಾರ ಗರ‍್ಹಾತ್ ಗೇಲ. ");
INSERT INTO gok_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","ಫನ್ ಮರಿಯಾ ರಡತ್ ಮಸುರ್ಡಿಚೆ ಬಾಹಿರ್ ಉಬಿ ಹುತ್ತಿ. ತಿನಿ ರಡತ್ ರಡತ್ ಮಸುರ್ಡಿತ್ ವಾಕುನ್ ಬಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ತವಾ ಪಾಂಡ್ರ ಕಪ್ಡ ಗ್ಯಾತ್‌ಲ್ಯಾಲ್ಯಾ ದೊಗಾ ದೇವ್ದುತಾನಾ ಬಗ್ತಿ ಯೇಸುಚ಼ ಮಡ ಥೆವ್‌ಲ್ಯಾಲಾ ಜಾ಼ಗಾ ತ್ಯಾತ್ಲಾ ಯೊಕ್ ಯೇಸುಚೆ ಡುಯಿಪ ಆನಿಯೊಕ್ ಪಾಯಾಕ್ಡ ಬಸ್ಲಾ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","ದೇವ್ ಧೂತ್ ಮರಿಯಾಲಾ ಬಾಯಿ ಕಾ ರಡ್ತೇಸ್ ಮನ್ಹುನ್ ಇಚಾರ್ತ್ಯಾತ. ಮರಿಯಾ ಮಾಜಾ ಪ್ರಭುಚ಼ ಮಡ ಥುಡಿ ಲೊಕ ಗಿಹುನ್ ಗೇಲ್ಯಾತ ತ್ಯಂಚಾನಿ ತ್ಯಲಾ ಕುಠ ಥೆವ್‌ಲ್ಯಾ ಮನಾ ಠಾವಾ ನಾಹಿ. ಮನ್ಹುನ್ ಉತ್ತರ್ ದೀತಿ. ");
INSERT INTO gok_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","ಮರಿಯಾ ಆಸಸ್ ಸಾಂಗುನ್ ಮಾಗಾರಿ ಪರಾತಿ ತವಾ ತಿಥಸ್ ಯೇಸು ಉಬಾ ರಾಯ್‌ಲ್ಯಾಲಾ ಬಗ್ತಿ ಫನ್ ತ್ಯೊ ಯೇಸು ಮನ್ಹುನ್ ತಿಲಾ ಠಾವಾ ನವ್ಥಾ. ");
INSERT INTO gok_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","ಯೇಸುನಿ ತೀಲಾ ಬಾಯಿ ಕಾ ರಡ್ತೇಸ್ ತು ಕುನಾಲಾ ಶೊತೇಸ್ ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ತ್ಯೊ ಬಾಗ್ ರ‍್ಯಾಕ್‌ತ್ಯಾಲಾ ಆಸಲ್ ಮನ್ಹುನ್ ಮರಿಯಾನಿ ಯವಜು಼ನ್ ತ್ಯಲಾ, ಬಾಬಾ ತು ಯೇಸುಲಾ ಗಿಹುನ್ ಗೇಲ್ಯಾಸ್ ಕ್ಯಾ? ತ್ಯಲಾ ಕುಠ ಥೆವ್‌ಲ್ಯಾಸ್ ಮನಾ ಸಾಂಗ್ ಮಿ ಜಾ಼ವುನ್ ತ್ಯಲಾ ಬಗ್ತೆ ಮಂತಿ. ");
INSERT INTO gok_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","ಯೇಸು ತಿಲಾ ಮರಿಯಾ ಮನ್ಲಾ ಮರಿಯಾ ತ್ಯಚಿಕ್ಡ ಪರ್ತುನ್ ಇಬ್ರಿಯಾ ಬಾಶೆತ್ ರಬ್ಬಿ ಮನ್ಲಿ ರಬ್ಬಿ ಮಂಜೆ ಗುರು. ");
INSERT INTO gok_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","ಯೇಸುನಿ ತಿಲಾ ಮನಾ ಹಾತ್ ಲಾವು ನಕೊಸ್ ಮಿ ಬಾಪ ಆಜು಼ನ್ ಮಾಗಾರಾ ಗೇಲೊ ನಾಹಿ ಫನ್ ತು ಮಾಜಾ ಬಾವ್ಹಾನಾ ಜಾ಼ವುನ್ ಮಾಜಾ಼ ಬಾ ತುಮಚಾ಼ ಬಾ಼ ಮಾಜಾ಼ ದೇವ್ ತುಮಚಾ಼ ದೇವ್ ಜಾ಼ಲ್ಯಾಲ್ಯಾಪ ಮಿ ಮಾಗಾರಾ ಜಾ಼ತ್ಯೊ ಮನ್ಹುನ್ ಸಾಂಗ್ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","ಮಗ್ದಲಾಚಿ ಮರಿಯಾ ಶಿಶಾಂಚಿಪ್ನಿ ಜಾ಼ವುನ್ ಮಿ ಪ್ರಭುಲಾ ಬಗ್ಲ ಮನ್ಹುನ್ ಸಾಂಗ್ತಿ ಆನಿ ಯೇಸುನಿ ಸಾಂಗ್‌ಲ್ಯಾಲ್ಯಾ ಗುಶ್ಟಿ ತೀ ತ್ಯನಾ ಸಾಂಗ್ತಿ. ");
INSERT INTO gok_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","ತೀಸಿಸ್ ಮಂಜೆ ವಾರಾಚಾ ಪೈಲ್ಯಾ ದಿಸಾದಿಸಿ ಶಾಂಚ಼ ಶಿಶಾ ಯಕಿಕ್ಡ ಜಮ್ಲ ತೇ ಯೆಹುದಿ ಅಧಿಕಾರ‍್ಯಾನಾ ಬಿಹುನ್ ದಾರ ಜಾ಼ಖುನ್ ಆತುಸ್ ಹುತ್ತ. ತವಾ ಯೇಸು ಯವುನ್ ತ್ಯಂಚೆ ಮದ್ದಿ ಉಬಾ ರಾಹುನ್ ತ್ಯನಾ ಸಮಾದಾನ್ ತುಮ್ಚಿಪ ರಾಹುನಿ ಮನ್ಲಾ ");
INSERT INTO gok_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","ಯೇಸುನಿ ಆಸ ಸಾಂಗ್‌ಲ್ಯಾ ನಂತರ್ ಆಪ್ಲ ಹಾತ್ ಆನಿ ಆಪ್ಲಿ ಕುಸ್ ತ್ಯನಾ ದ್ಯಾವ್ಲಿ ಪ್ರಭುಲಾ ಬಗುನ್ ಶಿಶಾನಾ ಖುಬ್ ಸಂತೊಶ್ ಜಾ಼ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","ಮಂಗ್ ಯೇಸು ಆನಿಕ್ ಸಮಾದಾನ್ ತುಮ್ಚಿಪ ರಾಹುನಿ ಬಾನಿ ಮನಾ ಲಾವುನ್ ದಿಲ್ಯಾ ತಸಸ್ ಆತಾ ಮಿ ತುಮಾನಾ ಲಾವುನ್ ದೇತೊ ಮನ್ಹುನ್ ಸಾಂಗ್ತೊ ");
INSERT INTO gok_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","ಯೇಸುನಿ ಆಸ ಸಾಂಗ್‌ಲ್ಯಾ ನಂತರ್ ಶಿಶಾವ್ನಿ ಫುಕುನ್ ಪವಿತ್ರಾತ್ಮ ಗೇವಾ. ");
INSERT INTO gok_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","ತುಮಿ ಕುನಾಚ಼ ಪಾಪ್ ಮಾಪ್ ಕರ್ತಾಸಾ ತ್ಯಂಚ಼ ಪಾಪ್ ಮಾಪ್ ವ್ಹನಾರ್ ತುಮಿ ಕುನಾಚ಼ ಪಾಪ್ ಮಾಪ್ ಕರೀತ್ನಾಹಿಸಾ ತ್ಯಂಚಿ ಪಾಪ ಮಾಪ್ ವ್ಹಯಿತ್ ನಾಹಿತ ಮನ್ಹುನ್ ಸಾಂಗ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","ಯೇಸು ಆಲಾ ತವಾ ದಿದುಮ್ ಮಂಥ್ಯಾಲಾ ತೊಮ್ ಬಾರಾಜಾ಼ನ್ ಶಿಶಾಂಚೆ ಸಂಗ ನವ್ಥಾ. ");
INSERT INTO gok_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","ಬಾಕಿಚ಼ ಶಿಶಾ ತೊಮಾಲಾ, “ಆಮಿ ಪ್ರಭುಲಾ ಬಗ್ಲಾ ಮನ್ಹುನ್ ಸಾಂಗ್‍ತ್ಯಾತ ತೊಮಾ ತ್ಯಚಾ ಹಾತಾನಾ ಮ್ಯಾರಲ್ಯಾಲ್ಯಾ ಮೊಳಾಚಾ಼ ಘಾವ್ ಮಿ ಬಗುನ್ ತ್ಯಾತ್ ಮಾಜ಼ ಬ್ವಾಟ್ ಥಿವಿ ಪರೇತ್ ಆನಿ ತ್ಯಚೆ ಕುಸಿತ್ ಮಾಜಾ಼ ಹಾತ್ ಥಿವುನ್ ಬಗಿ ಪರೇತ್ ಮಿ ತ್ಯಚಿವ ಇಸ್ವಾಸ್ ಥಿವಿತ್ ನಾಹಿ. ಮನ್ಹುನ್ ಸಾಂಗ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","ಯೊಕ್ ಆಠಾವ್ಡಾ ಜಾ಼ಲ್ಯಾವ ಶಿಶಾ ಯಕಾ ಗರ‍್ಹಾತ್ ಯಂಗ್ದಾಸ್ ಜ಼ಮ್ಲ. ತೊಮಾಬಿ ತ್ಯಚಿ ಸಂಗ ಹುತ್ತಾ. ದಾರ ಜಾಕ್ಲಿ ಹುತ್ತಿತ. ತವಾ ಯೇಸುನಿ ಯವುನ್ ತ್ಯಚೆ ಮದಿ ಉಬಾರಾಹುನ್ ತ್ಯನಾ, ಸಮಾದಾನ್ ತುಮ್ಚಿಪ ರಾಹುನಿ ಮನ್ಹುನ್ ಸಾಂಗ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","ಮಂಗ್ ಯೇಸುನಿ ತೊಮಾಲಾ, ತುಜ಼ ಬ್ವಾಟ್ ಹಿತ ಗ್ಯಾಲ್. ಮಾಜ಼ ಹಾತ್ ಬಗ್. ತುಜಾ಼ ಹಾತ್ ಮಾಜೆ ಕುಸಿಪ ಲ್ಯಾವ್. ಅನ್ಮಾನ್ ಯಯಾಚೆ ಆಂದಿ ಇಸ್ವಾಸ್ ತೆವ್ ಮನ್ಹುನ್ ಸಾಂಗ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","ತೊಮಾ ಯೇಸುಲಾ, ಮಾಜಾ ಪ್ರಭು, ಮಾಜಾ ದೇವಾ ಮನ್‍ಲ್ಹಾ. ");
INSERT INTO gok_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","ಯೇಸು ತೊಮಾಲಾ ತು ಮನಾ ಬಗ್ಲಾಸ್ ಮನ್ಹುನ್ ಇಸ್ವಾಸ್ ತೆವ್ಲಾಸ್ ಮನಾ ಬಗಾಚೆ ಆಂದಿ ಇಸ್ವಾಸ್‍ ಥೆವ್ನಾರಿ ಖರ‍್ಯಾನಿ ಬರಿ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","ಯೇಸುನಿ ಆಜು಼ನ್ ದುಸ್ರಿ ಚಮತ್ಕಾರಾಚಿಕಾಮ ಆಪ್‍ಲ್ಯಾ ಶಿಶಾಂಚೆ ಮೊರ‍್ಹ ಕೆಲ್ಯಾತ. ತಿ ಹ್ಯಾ ಪುಸ್ತಕಾತ್ ಲಿವ್ಲಿನಾಹಿತ. ");
INSERT INTO gok_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","ಫನ್ ತ್ಯಲಾ ಯೇಸು ಕ್ರಿಸ್ತ ದೇವಾಚಾ಼ ಲ್ಯೊಕ್ ಮನ್ಹುನ್ ತುಮಿ ಇಸ್ವಾಸ್ ಥೆವಾಯಾ ವ್ಹಯಿಸಾ ತುಮ್ಚಾ ಇಸ್ವಾಸಾನಿ ಶಾಶ್ವತ್ ಜೀವ್ ಗಿಹ್ಯಾ ವ್ಹಯಿಸಾ ಮನ್ಹುನ್ ಹ್ಯ ಲಿವ್‌ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","ಮಂಗ್ ಯೇಸು ಆನಿ ಯಂಗ್ದಾ ಆಪ್‌ಲ್ಯಾ ಶಿಶಾನಾ ತಿಬೇರಿಯ ಗಲಿಲಾಯ್ ತಳಿಪ ದಿಸ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","ಥೊಡ ಶಿಶಾ ಯಂಗ್ದಾಸ್ ಜ಼ಮ್ಲ ತೇ ಕೊನ್ ಮಂಜೆ ಸಿಮೊನ್ ಪೇತ್ರ ದಿದುಮ್ ನಾವಾಚಾ಼ ತೊಮ ಗಲಿಲಾಯಾತಲ್ಯಾ ಕಾನಾ ಗಾವಾತ್ಲಾ ನತಾನಿಯೇಲ್ ಜೆಬೆದಾಯಾಚ಼ ದೊಗ ಪ್ಯೊರ್ಗ ಆನಿ ದೊಗ ಶಿಶಾ. ");
INSERT INTO gok_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","ಪೇತ್ರಾ ತ್ಯನಾ ಮಿ ಮಾಸ ದರಾಯಾ ಜಾ಼ತ್ಯೊ ಮನ್ಲಾ. ರಾಯ್‌ಲ್ಯಾಲ ಶಿಶಾ ಆಮಿ ತುಮ್ಚಿ ಸಂಗ ಯತಾವ್ ಮನ್ಹುನ್ ಸಾಂಗ್‌ತ್ಯಾತ. ತವಾಸ್ ಶಿಶಾ ಸಗ್ಳ ಗೇಲ ವ್ಹಡಿತ್ ಚ಼ಡ್ಲ. ತ್ಯಂಚಾನಿ ರ‍್ಯಾತ್‌ ಸಾರಿ ಜಾ಼ಳಿ ಗ್ಯಾತ್ಲಿತ ಫನ್ ಯೊಕ್ ಮಾಸಾಬಿ ಗಾವ್ಲಾ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","ತವಾ ಸಕಾಳಚ಼ಾ ಯೇಸು ದುರ್ ಉಬಾರಾಯಲ್ಯಾಲಾ ಬಗ್ಲಾ ಫನ್ ತ್ಯೊಸ್ ಯೇಸು ಮನ್ಹುನ್ ಶಿಶಾನಾ ವಳಾಕ್ಲಾ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","ತವಾ ಯೇಸುನಿ ಆಪ್‌ಲ್ಯಾ ಶಿಶಾನಾ ಸೊಪ್‌ತ್ಯಾನು ತುಮಾನಾ ಮಾಸ ಗಾವ್ಲ ಕ್ಯಾ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ಶಿಶಾಂಚಾನಿ ನಾಹಿ. ಮನ್ಹುನ್ ಉತ್ತರ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","ಯೇಸು ತುಮ್ಚೆ ವ್ಹಡಿಚೆ ಉಜ್‍ವ್ಯಾಂಗ್ನಿ ತುಮ್ಚಿ ಜಾ಼ಳಿ ಗಾಲ್ಹಾ ತಿಥ ಥೊಡ ಮಾಸ ಗಾವ್ತಿಲ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ ಶಿಶಾಂಚಾನಿ ತಸಸ್ ಕೆಲ ಖುಬ್ ಮಾಸ ಗಾವ್ಲ ಮನ್ಹುನ್ ತ್ಯನಾ ವ್ಹಡಿತ್ ಗಿಹ್ಯಾ ಗಾವ್ಲ ನಾಹಿತ. ");
INSERT INTO gok_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","ಯೇಸುಚಾ಼ ಮಾಯಾಚಾ಼ ಶಿಶಾ ಪೇತ್ರಾಲಾ ತ್ಯೊ ಮಾನುಸ್ ಪ್ರಭು ಮನ್ಹುನ್ ಸಾಂಗ್ಲ ತವಾಸ್ ಪೇತ್ರಾನಿ ಆಪ್ಲಿ ಆಂಗಿ ಗಾಲ್ಹುನ್ ಪಾನ್ಯಾತ್ ಉಡಿಮ್ಯಾರ್ಲಿ ಪೇತ್ರಾನಿ ಆಪ್ಲಿ ಆಂಗಿ ಕ್ಯಾಡ್ಲಿ ಹುತ್ತಿ. ");
INSERT INTO gok_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","ಉರ್ಲ್ಯಾಲ ಶಿಶಾ ವ್ಹಡಿತ್ನಿ ದುರ್ ಗೇಲ ತ್ಯಂಚಾನಿ ಜಾ಼ಳಿ ಬರ‍್ಹುನ್ ಮಾಶಾನಾ ದರವ ವಡುನ್ ನೇಲ್ಹ ತೇ ದರಪ್ನಿ ಖುಬ್ ದುರ್ ನವ್ಥ ಜ಼ವಜ಼ವಳ್ ತಿನ್ಸೆ ಫುಟ್ ದುರ್ ಹುತ್ತ. ");
INSERT INTO gok_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","ಶಿಶಾ ವ್ಹಡಿತ್ನಿ ಉತ್ರುನ್ ದರವ ಗೇಲ ತವಾ ಇಸ್‍ಥ್ಯಾಚ಼ ಇಂಗಾಳ್ ಬಗ್ಲ ಇಸ್‍ಥ್ಯಾವ ಮಾಸ ಹುತ್ತ ಆನಿ ಥೊಡ್ಯಾ ಬಾಖರ‍್ಯಾ ತಿಥ ಹುತ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","ಮಂಗ್ ಯೇಸುನಿ ತುಮಿ ದರ್ಲ್ಯಾಲ್ಯಾ ಮಾಶಾತ್ಲ ಥೊಡ ಆನಾ ಮನ್ಹುನ್ ಸಾಂಗ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","ಸಿಮೊನ್ ಪೇತ್ರಾ ವ್ಹಡಿತ್ ಜಾ಼ವುನ್ ಜಾ಼ಳ ದರಕ್ಡ ವಡುನ್ ಆಂತೊ ಜಾ಼ಳ ಮೊಟ್ಯಾ ಮಾಶಾಂಚಾನಿ ಬರ್ಲ ಹುತ್ತ, ತ್ಯಾತ್ ಯಕ್ಸೆ ಪನ್ನಾಸಾವ ತೀನ್ ಮಾಸ ಹುತ್ತ. ತೇ ಖುಬ್ ಜ಼ಡ್ ಜಾ಼ಲ ತರಿ ಜಾ಼ಳ ಫಾಟ್ಲ ನಾಹಿ ");
INSERT INTO gok_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","ಯೇಸುನಿ ತ್ಯನಾ ಯವುನ್ ಜೇವಾನ್ ಖಾವಾ ಮನ್ಹುನ್ ಸಾಂಗ್ತೊ ಶಿಶಾತ್‌ಲ್ಯಾ ಯಕಾನಿಬಿ ತು ಕೊನ್ ಮನ್ಹುನ್ ತ್ಯಲಾ ಇಚಾರ್ಲ ನಾಹಿ ತ್ಯನಾ ತ್ಯೊ ಪ್ರಭು ಮನ್ಹುನ್ ಠಾವಾ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","ಯೇಸುನಿ ಜ಼ವಳ್ ಯವುನ್ ಬಾಕ್ರಿ ಗಿಹುನ್ ತ್ಯನಾ ದಿಲ್ಯಾ ತ್ಯನಿ ಮಾಸಬಿ ಗಿಹುನ್ ತಸಸ್ ಕೆಲ. ");
INSERT INTO gok_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","ಯೇಸುನಿ ಮೆಲ್ಯಾಲ್ಯಾತ್ನಿ ಉಠುನ್ ನಂತರ್ ಆಪ್‌ಲ್ಯಾ ಶಿಶಾನಾ ದಿಸಲ್ಯಾಲಾ ಹ್ಯ ತಿನ್ವೆ ಖೆಪಾ. ");
INSERT INTO gok_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","ತೇ ಜೀವುನ್ ಜಾ಼ಲ್ಯಾ ನಂತರ್ ಯೇಸುನಿ ಸಿಮೊನ್ ಪೇತ್ರಾಲಾ ಯೊಹಾನಾಚಾ ಲೇಕಾ ಸಿಮೊನಾ ಹಿತ್ತ ಆಸ್‌ಲ್ಯಾಲ ಹೆ ಮಾಜಿ ಮಾಯಾ ಕರಾಚೆ ಆಂದಿ ತು ಮಾಜಿ ಮಾಯಾ ಕರ್ನಾರ್ ಕ್ಯಾ? ಮನ್ಹುನ್ ಇಚಾರ್ತೊ ಪೇತ್ರಾನಿ ವ್ಹಯ್ ಪ್ರಭು ಮಿ ತುಜಿವ ಮಾಯಾ ಥೆವ್ಲೆ ಮನ್ಹುನ್ ತುಲಾ ಠಾವ ಹಾ ಮನ್ಲಾ ಯೇಸು ಪೇತ್ರಾಲಾ ಮಾಜಿ ಮೆಂಡ್ರ ಚಾರ್ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","ದೊನವ್ಯಾನಿ ಯೇಸುನಿ ಪೇತ್ರಾಲಾ ಯೊಹಾನಾಚಾ ಲೇಕಾ ಸಿಮೊನಾ ತು ಮಾಜಿ ಮಾಯಾ ಕರ್ತ್ಯೊಸ್ ಕ್ಯಾ ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ಪೇತ್ರಾನಿ ವ್ಹಯ್ ಪ್ರಭು ಮಿ ತುಜಿವ ಮಾಯಾ ಥೆವ್ಲೆ ಮನ್ಹುನ್ ತುಲಾ ಠಾವಿ ಹಾ ಮನ್ಲಾ. ಯೇಸು ಪೇತ್ರಾಲಾ ಮಾಜಿ ಮೆಂಡ್ರ ರ‍್ಯಾಕ್ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","ಯೇಸು ತೀನ್‍ವ್ಯಾನಿ ಯೊಹಾನಾಚಾ ಲೇಕಾ ಸಿಮೊನಾ ತು ಮಾಜಿ ಮಾಯಾ ಕರ್ತೊಸ್ ಕ್ಯಾ ಮನ್ಹುನ್ ಇಚಾರ್ತೊ. ಯೇಸುನಿ ತು ಮಾಜಿ ಮಾಯಾ ಕರ್ತೊಸ್ ಕ್ಯಾ ಮನ್ಹುನ್ ತೀನ್ ಖೆಪಾ ಇಚಾರ್ಲ ಮನ್ಹುನ್ ಪೇತ್ರಾಲಾ ದುಖ್ ಜಾ಼ಲ ಪೇತ್ರಾನಿ ಪ್ರಭು ತುಲಾ ಸಗ್ಳ ಠಾವ ಹಾ ಮಿ ತುಜಿವ ಮಾಯಾ ಥೆವ್ಲೆ ಮನ್ಹುನ್ ತುಲಾ ಠಾವಿ ಹಾ ಮನ್ಲಾ ಯೇಸುನಿ ಪೇತ್ರಾಲಾ ಮಾಜಿ ಮೆಂಡ್ರ ಚಾರ್. ");
INSERT INTO gok_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","ಮಿ ತುಲಾ ಖರ ಸಾಂಗ್ತೊ. ತು ಪ್ಯೊರ್ಗಾ ಆಸ್ಥಾನಾ ಕಂಬಾರ್ ಬಾಂದುನ್ ತುಲಾ ಮನ್ ಹಾ ತಿಕ್ಡ ಗೇಲಾಸ್ ಫನ್ ತು ಮಾಥಾರಾ ಜಾ಼ಲಾಸ್ ತವಾ ತುಜ಼ ಹಾತ್ ಪಗಳ್ನಾರ್ ಆನಿ ದುಸ್ರಾ ಯೊಕ್ ತುಜಿ ಕಂಬಾರ್ ಬಾಂದುನ್ ತುಲಾ ಮನ್ ನಾಹಿ ತಿಕ್ಡ ಚಾ಼ಲ್ವಿತ್ ನೇನ್ಹಾರ್ ಮನ್ಹುನ್ ಸಾಂಗ್ತೊ ");
INSERT INTO gok_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","ದೇವಾಚ಼ ನಾವ್ ಮೈಮಾ ವ್ಹಯಾ ಪೇತ್ರಾ ಕಸಾ ಮರ್ನಾರ್ ಮನ್ಹುನ್ ದಾವಾಯಾ ಯೇಸುನಿ ಆಸ ಸಾಂಗ್ಲ ನಂತರ್ ಯೇಸು ಪೇತ್ರಾಲಾ ಮಾಜಿ ಸಂಗ ಯೇ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","ಪೇತ್ರಾನಿ ಮಾಗಾರ ಪರ್ತುನ್ ಬಗ್ಲ ತವಾ ಯೇಸುಚೆ ಮಾಯೆಚಾ಼ ಶಿಶಾ ಆಪ್ಲೆ ಮಾಗ್ನಿ ಚಾ಼ಲತ್ ಯತ್ಯಾಲಾ ಬಗ್ಲಾ ರ‍್ಯಾಚಾ಼ ಜೇವ್ನಾಚಾ ಯಳಾಲಾ ವಾಕುನ್ ಪ್ರಭು ತುಜಾ಼ ಘಾತ್ ಕರ್ತ್ಯಾಲಾ ಕೊನ್ ಮನ್ಹುನ್ ಇಚಾರ್ತೊ ಹ್ಯೊ ");
INSERT INTO gok_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","ಪೇತ್ರಾನಿ ಆಪ್ಲೆ ಮಾಗ್ನಿ ಯತ್ಯಾಲಾ ಹ್ಯಾ ಶಿಶಾಲಾ ಬಗುನ್ ಯೇಸುಲಾ ಪ್ರಭು ಹ್ಯಚಿ ಗ್ಯೊಸ್ಟ್ ಕ್ಯಾ ಮನ್ಹುನ್ ಇಚಾರ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","ಯೇಸುನಿ ಮಿ ಯಯಿ ಪರತ್ ತ್ಯೊ ಜಿತ್ತಾ ರಾಹ್ಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಮಾಜ಼ ಮನ್ ಜಾ಼ಲ್ಹತ ತ್ಯನಿ ತುಲಾ ಕ್ಯಾ? ತು ಮಾಜೆ ಮಾಗ್ನಿಯೆ ಮನ್ಹುನ್ ಉತ್ತರ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","ಆಸ ಹಿ ಬಾತ್ನಿ ಯೇಸುಂಚಾ ಶಿಶಾಂಚೆ ಮದ್ದಿಪಗಾಳ್ಳಿ ಹ್ಯೊ ಬಾಹು ಮರ್ನಾರ್ನಾಹಿ ಮನ್ಹುನ್ ನವ್ಹ ಮನಾ ಮನ್ ಆಸಲ್ಯಾವ ಮಿ ಯಯಿ ಪರತ್ ಹ್ಯಿ ಜಿತ್ತಿ ರಾನ್ಹಾರ್ ತ್ಯನಿ ತುಮಾನಾ ಕ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","ಹ್ಯಾ ಗುಶ್ಟಿ ಲಿವ್ನಾರಾ ಆನಿ ಹ್ಯಚೆ ಗುಶ್ಟಿತ್ ಸಾಕ್ಷಿ ಸಾಂಗ್‌ತ್ಯಾಲಾ ಶಿಶಾ ತ್ಯೊಸ್ ತ್ಯನಿ ಸಾಂಗ್‌ಲ್ಯಾಲ ಖರ ಮನ್ಹುನ್ ಆಮಾನಾ ಠಾವ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","ಯೇಸುನಿ ಆಸ್ಲಿ ಖುಬ್ ಕಾಮ ಕಿಲಿತ ತ್ಯಾತ್ಲಿ ಯಾಕ್ ಯಾಕ್ ಲಿವಾಚ಼ ಜಾ಼ಲ್ಯಾವ ಲಿವ್‌ಲ್ಯಾಲಿ ಪುಸ್ತಕ ಸಗ್ಳಿ ದುನೆತ್ ಮಾವಚಿ ನವ್ಥಿತ ಮನ್ಹುನ್ ಮಿ ಯವಸ್ತೊ.");
INSERT INTO gok_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","ಮಾಯೆಚಾ ತಿಯೊಪಿಲಾ, ಯೆಸುನಿ ಕೆಲ್ಯಾಲ್ಯಾ ಕಾಮಾಂಜೆ ಗುಸ್ಟಿತ್ ಆನಿ ದಿಲ್ಯಾಲ್ಯಾ ಶಿಕ್ಷೆನಾಚೆ ಗುಸ್ಟಿತ್ ಪರತೆಕ್ ಯಾಕ್ ಮಿ ಮಾಜಾ ಪೈಲ್ಯಾ ಪುಸ್ತಕಾತ್ ಲಿವ್‍ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ತ್ಯನಿ ಸ್ವರ್ಗಾತ್ ನೆಲ್ಯಾಲ್ಯಾ ದಿಸಾಪರೇತ್ ಆನಿ ಆಪ್ಲ ಅಪೊಸ್ತಲ್ ಮನ್ಹುನ್ ನಿವ್ಡುನ್ ಗೆತಲ್ಯಾಲ್ಯಾನಾ ಪವಿತ್ರಾತ್ಮಾಚಾ ಬಳಾನಿ ಸಿಕಿವ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","ಹಿ ತ್ಯಚಾ ಮರ್ನಾಚೆ ನಂತರ್ ಗಡ್‌ಲ್ಯಾಲಿ ಖನ್ಕತ್. ಆಪ್ನು ಜಿತ್ತಾ ಆಸ್‌ಲ್ಯಾಲಾ ತ್ಯನಿ ಅಪೊಸ್ತಲಾನಾ ದಾವುನ್ ದಿಲ. ಆನಿ ಬಳಾಚಿ ಕಾಮ ಖುಬ್ ಕರುನ್ ತೀ ದ್ಯಾವ್ಲಿತ. ಯೇಸು ಜಿತ್ತಾ ವ್ಹವುನ್ ಆಲ್ಯಾ ನಂತರ್ ಚಾಳಿಸ್ ದಿಸಾತ್ ಅಪೊಸ್ತಲಾಂಚಾನಿ ತ್ಯಲಾ ಖುಬ್ ಖೆಪಾ ಬಗ್ಲಾ. ಯೇಸುನಿ ದೇವಾಚಾ ರಾಜಾಚೆ ಗುಶ್ಟಿತ್ ಅಪೊಸ್ತಲಾಂಚೆ ಸಂಗ ಬೊಲ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","ಯಂಗ್ದಾ ಯೇಸು ತ್ಯಂಚಿ ಸಂಗ ಜೇವಾನ್ ಖಾತಾನಾ ಯೇರುಸಲೇಮ್ ಸುಡುನ್ ಜಾ಼ಯಾಚ಼ ನಾಹಿ ಮನ್ಹುನ್ ತ್ಯನಾ ಆಜ್ಞಾ ದಿಲಿ. “ಬಾನಿ ತುಮಾನಾ ಯೊಕ್ ಸಬ್ದ ದಿಲ್ಯಾ ಹ್ಯಚೆ ಗುಶ್ಟಿತ್ ತುಮಿ ಆಂದಿಸ್ ಐಕ್‌ಲ್ಯಾಸಾ ಹ್ಯಾ ಸಬ್ದಾಚ಼ ವರ್ದಾನ್ ಗಿಹ್ಯಾಸಾಟಿ. ಯೆರುಸಲೇಮಿತುಸ್ ರಾಖಿತ್ ರಾವ್ಹಾ. ");
INSERT INTO gok_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","ಯೊಹಾನಾನಿ ಲೊಕಾನಾ ಪಾನ್ಯಾನಿ ಬಾಪ್ತಿಸ್ಮಾ ದಿಲಿ, ಫನ್ ಆನಿ ಥೊಡ್ಯಾ ದಿಸಾತುಸ್ ತುಮಾನಾ ಪವಿತ್ರಾತ್ಮಾನಿ ಬಾಪ್ತಿಸ್ಮಾ ವ್ಹಯಿಲ್” ಮನ್ಹುನ್ ತ್ಯನಿ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","ಅಪೊಸ್ತಲ್ ಯಕಿಕ್ಡ ಜ಼ಮ್ಲ ತವಾ, ತ್ಯಂಚಾನಿ ಯೆಸುಲಾ, “ಪ್ರಭು, ತು ಇಸ್ರಾಯಲ್ ಲೊಕಾನಾ ಆನಿಕ್ ತ್ಯಂಚ಼ ರಾಜ ದೇನಾರ್ ತ್ಯ ಹ್ಯಾ ಕಾಲಾತುಸ್ ಕ್ಯಾ? ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","ಯೇಸುನಿ ತ್ಯನಾ, “ದೀಸ್ ಆನಿ ಯೊಳ್ ಥರವಾಚಾ಼ ಹುಕುಮ್ ಆಸ್‌ಲ್ಯಾಲಾ ಬಾಲಾ ಯಕ್‌ಲ್ಯಾಲಾಸ್. ತುಮಿ ತ್ಯ ಸಮಜು಼ನ್ ಗಿಹ್ಯಾ ವ್ಹಯಿತ್ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","ಫನ್ ಪವಿತ್ರಾತ್ಮ ತುಮ್ಚಿವ ಆಲಕಿ ತುಮಾನಾ ಬಳ್ ಯವುನ್ ಯೇರುಸಲೇಮಿತ್ಬಿ ಸಗ್ಳೆ ಯುದಾಯಾತ್ಬಿ ಸಮಾರ‍್ಯಾತ್ಬಿ ಆನಿ ಧರ್ಥಿವ ಸಗ್ಳಿಕ್ಡ ಸಾಕ್ಷಿ ವ್ಹವುನ್ ಸರ್ತ್ಯಾ ಪರತ್ ರಾನ್ಹಾರ್” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","ಯೇಸುನಿ ಹ್ಯಾ ಖನ್ಕತಿ ಅಪೊಸ್ತಲಾನಾ ಸಾಂಗ್‌ಲ್ಯಾ ನಂತರ್ ಅಪೊಸ್ತಲ್ ಬಗ್‌ತ್ಯಾಲ ಆಸ್ಥಾನಾಸ್ ಆಬ್ಳಾತ್ ಉಚ಼ಲುನ್. ಢಘಾನಿ ತ್ಯಲಾ ಜಾ಼ಖುನ್ ಗೆತಲ್ಯಾಲ್ಯಾನಿ ತ್ಯಂಚಾನಿ ತ್ಯಲಾ ಬಗಾಯಾ ಜಾ಼ಲ್ಹ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","ಯೇಸು ಜಾ಼ತಾನಾ ಅಪೊಸ್ತಲ್ ಅಬ್ಳಾಕ್ಡಸ್ ಬಗಿತ್ ಹುತ್ತ. ತವಾ ಪಾಂಡ್ರ ಕಪ್ಡ ಗ್ಯಾತ್‌ಲ್ಯಾಲ ದೊಗ ಗಡಿ ಪಾಟ್ನ ತ್ಯಂಚಿಪ ಉಬ ರಾಯ್ಲ, ");
INSERT INTO gok_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","“ಗಲಿಲಾಯಾತಲ್ಯಾನು, ತುಮಿ ಕಾ ಆಬಾಳುಸ್‍ ಬಗಿತ್ ರಾಯ್‌ಲ್ಯಾಸಾ? ಯೇಸು ತುಮ್ಚಾ ಡೊಳ್ಯಾ ಮೊರ‍್ಹ ಸ್ವರ್ಗಾತ್ ಕಸಾ ಉಚ್ಲು಼ನ್ ಗೇಲಾ ತಸಾಸ್ ಪರ್ತುನ್ ಆನಿ ಯನಾರ್” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","ಮಂಗ್ ಅಪೊಸ್ತಲ್ ಆಲಿವ್ ಜಾ಼ಢಾಂಚಾ ಗುಢ್ಯಾತ್ನಿ ಯೆರುಸಲೇಮಿತ್ ಪರ್ತುನ್ ಗೇಲ. ಹ್ಯಾ ಗುಢ್ಯಾಲಾ ಆನಿ ಯೇರುಸಲೇಮಿಲಾ ಜ಼ವ ಜ಼ವಳ್ ಆರ್ದಾ ಮೈಲ್ ಫರಕ್ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","ಅಪೊಸ್ತಲ್ ಪೆಠತ್ ಆಪ್ಲೆ ರಾವ್ಠಿವ ಗೇಲ. ತೇ ಮಾಳಿವ ಹುತ್ತ. ತೇ ಅಪೊಸ್ತಲ್ ಕಚ಼ ಮಂಜೆ: ಪೇತ್ರಾ, ಯೊಹಾನ್, ಯಾಕೊಬ್ ಆನಿ ಆಂದ್ರೆಯ, ಪಿಲಿಪ, ತೊಮ, ಬಾರ್ತೊಲೊಮಾಯ, ಮತ್ತಾಯ, ಅಲ್ಪಾಯಾಚಾ಼ ಲ್ಯೊಕ್ ಯಾಕೊಬ್ ದೇಶೆಚಾ಼ ಅಭಿಮಾನ್ ಆಸ್‌ಲ್ಯಾಲಾ ಸಿಮೊನ್ ಆನಿ ಯಾಕೊಬಾಚಾ಼ ಲ್ಯೊಕ್ ಯುದ್. ");
INSERT INTO gok_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","ಅಪೊಸ್ತಲ್ ಸಗ್ಳ ಯಕಿಕ್ಡ ಜ಼ಮ್ಲ ತೇ ಯಕಾಸ್ ಮನಾನಿ ಚು಼ಕ್ವಾಚೆ ಆಂದಿ ಮಾಗ್ನ ಕರೀತ. ಥುಡಿ ಬ್ಯಾಯ್ಕಾಮಾನ್ಸ ಯೇಸುಚಿ ಆಯಿ ಮರಿಯಾ ಆನಿ ಬಾಹು ಅಪೊಸ್ತಲಾಂಚೆ ಸಂಗ ಹುತ್ತ. ");
INSERT INTO gok_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","ಥೊಡ ದೀಸ್ ಜಾ಼ಲ್ಯಾ ನಂತರ್ ಇಸ್ವಾಸಿಂಚಿ ಮಂಡಳಿ ಜ಼ಮ್ಲಿ. ತಿಥ ಜ಼ವಳ್ ಜ಼ವಳ್ ಯಕ್ಸೆ ಈಸ್ ಲೊಕ ಹುತ್ತಿತ. ಪೇತ್ರಾ ಉಬಾರಾಹುನ್ ಆಸಾ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“ಬನ್ಹಿ ಬಾವ್ಹಾನು, ಪವಿತ್ರಾತ್ಮಾನಿ ದಾವಿದಾಸಂಗ ಪವಿತ್ರ ಪುತಿಕಾತ್ ಆಂದಿ ಸಾಂಗ್‌ಲ್ಯಾಲ್ಯಾ ಖನ್ಕತಿ ವ್ಹಯಾ ವ್ಹಯಿ ಜಾ಼ಲ್‌ಥ್ಯಾ. ಆಮ್ಚಾ ಸ್ವತಾಚಾ ಮೆಳ್ಯಾತ್ಲಾ ಯೊಕ್‌ ಜಾ಼ಲ್ಯಾಲ್ಯಾ ಯುದಾಚೆ ಗುಶ್ಟಿತ್ ದಾವಿದಾನಿ ಸಾಂಗ್‌ಲ್ಯಾ. ಯುದಾನಿ ಆಮ್ಚಿ ಸಂಗ ಸೇವೆ ಕಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","ತ್ಯೊ ಆಮ್ಚಾ ಹಿಂಡಾತ್ಲಾ ಜಾ಼ಲ್ತಾ ಆನಿ ಆಮ್ಚೆ ಸೇವೆಚಾ ಕಾಮಾತ್ ನಿವಡ್‌ಲ್ಯಾಲಾ ಜಾ಼ಲ್ಥಾ.” ");
INSERT INTO gok_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","ಹ್ಯ ಮೊಸಾಚ಼ ಕಾಮ್ ಕರಾಯಾ ಯುದಾಲಾ ಪೈಸ ದಿಲ್ತ. ತ್ಯಾ ಪೈಸ್ಯಾನಿ ತ್ಯಲಾ ಯಾಕ್ ಶಾತ್ ಗೆತ್ಲ ಹುತ್ತ. ಫನ್ ಯುದ್ ಡುಯಿ ಖಾಲ್ ವ್ಹವುನ್ ಪಡ್ಲಾತವಾ ಪ್ವಾಟ್ ಫುಠುನ್ ಗೇಲ. ತ್ಯಚಿ ಆತ್ಡಿ ಸಗ್ಳಿ ಬಾಹಿರ್ ಆಲಿತ. ");
INSERT INTO gok_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","ತ್ಯಚೆ ಗುಶ್ಟಿತ್ ಯೇರುಸಲೇಮಿತ್‌ಲ್ಯಾನಾ ಸಗ್ಳ ಸಮಾಜ಼್ಲ. ಮನ್ಹುನ್ ತ್ಯಂಚಾನಿ ತ್ಯಾ ಶೆತಾಲಾ ಅಕೆಲ್ದಮಾ ಮನ್ಹುನ್ ನಾವ್ ಥೆವ್ಲ. ತ್ಯಂಚೆ ಬಾಶೆತ್ ಅಕೆಲ್ದಮಾ ಮಂಜೆ ‘ರಕ್ತಾಚ಼ ಶಾತ್’ ಮನ್ಹುನ್ ಆರ್ಥ. ");
INSERT INTO gok_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","ತ್ಯಚ಼ ಘರ್ ನಾಸ್ ವ್ಹವುನಿ, ತ್ಯಾತ್ ಕುನಿ ರಾಹುನಾಹಿ ಆನಿ ತ್ಯಚ಼ ಕಾಮ್ ದುಸ್‍ರ‍್ಯಾಲಾ ವ್ಹವುನಿ ಆಸ ಕಿರ್ತನ್ ಗ್ರಂಥಾತ್ ಲಿವ್‍ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“ಮನ್ಹುನ್ ದುಸ್ರಾ ಯೊಕ್ ಆಮ್ಚಿ ಸಂಗ ಮಿಳುನ್, ಪ್ರಭು ಜಾ಼ಲ್ಯಾಲಾ ಯೇಸು ಆಮ್ಚಿಪ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ಕಾಲಾತ್ ತ್ಯೊ ಆಮ್ಚಾ ಮೆಳ್ಯಾತ್ಲಾ ರಾಹ್ಯಾ ವ್ಹಯಿ. ");
INSERT INTO gok_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","ಯೊಹಾನಾನಿ ಬಾಪ್ತಿಸ್ಮಾ ದಿಯಾ ಸುರು ಕೆಲ್ಯಾಲೆ ದರ್ನಿ ಯೇಸು ಆಮ್ಚಿಪ್ನಿ ಸ್ವರ್ಗಾತ್ ನಿಹಿಪರ‍್ಯಾತ್ ತ್ಯೊ ಆಮ್ಚಿ ಸಂಗ ರಾಯ್‌ಲ್ಯಾಲಾ ರಾಹ್ಯಾ ವ್ಹಯಿ ಕಾ ಮಂಜೆ, ತ್ಯಂಚಾತ್ಲಾ ಯೊಕ್ ಯೇಸು ಮರುನ್ ಜಿತ್ತಾ ಜಾ಼ಲ್ಯಾಲ್ಯಾಲಾ ವಳಕ್ ವ್ಹವುನ್ ರಾಹ್ಯಾ ವ್ಹಯಿ. ” ");
INSERT INTO gok_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","ಅಪೊಸ್ತಲಾಂಚಾನಿ ದೊಗಾನಾ ನಿವ್ಡುನ್ ಮಂಡಳಿಚೆ ಮೊರ‍್ಹ ಉಬಕೆಲ. ಯೊಕ್ ಬಾರ್ಸೆಬ ಮಂಥ್ಯಾಲಾ ಯೊಸೆಪ್. ಹ್ಯಲಾ ಯುಸ್ತ್ ಮನ್ಹುನ್ ಹಾಕ್ಟಿತಿತ. ಆನಿ ಯೊಕ್ ಮತ್ತಿಯ. ");
INSERT INTO gok_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","ತವಾ ತ್ಯಂಚಾನಿ ಆಸ ಮಾಗ್ನ ಕೆಲ: “ಪ್ರಭು ಸಗ್‌ಳ್ಯಾ ಲೊಕಾಂಚ಼ ಮನ್ ಸಮಜು಼ನ್ ಗೆತಲ್ಯಾಸ್ ಹ್ಯ ಕಾಮ್ ಕರಾಯಾ ಹ್ಯಾ ದೊಗಾತ್‌ಲ್ಯಾ ಕಚಾಲಾ ತು ನಿವಡ್‌ಲ್ಯಾಸ್, ");
INSERT INTO gok_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ಮನ್ಹುನ್ ಯುದ್ ಅಪೊಸ್ತಲಾಚಾ಼ ಆನಿ ಸೇವೆಚಾ಼ ಜಾ಼ಗಾ ಸುಡುನ್ ಆಪ್ನು ಜಾ಼ಯಾ ವ್ಹಯಿ ಜಾ಼ಲ್ಯಾಲ್ಯಾ ಜಾ಼ಗ್ಯಾವ ಗೆಲಾ. ಪ್ರಭು ತ್ಯಚಾ ಜಾ಼ಗ್ಯಾವ ಅಪೊಸ್ತಲ್ ವ್ಹವುನ್ ಕಚಾಲಾ ಥರ್ವಾವ್ಹಯಿ ಆಮಾನಾ ದ್ಯಾವ್. ");
INSERT INTO gok_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","ಮಂಗ್ ಅಪೊಸ್ತಲಾಂಚಾನಿ ತ್ಯಾ ದೊಗಾತ್‌ಲ್ಯಾ ಯಕಾಲಾ ನಿವ್ಡಾಯಾ ಚೀಟಿ ಗ್ಯಾತ್ಲಿ. ಚೀಟಿ ಮತ್ತಿಯಾಲಾ ಆಲಿ ಮನ್ಹುನ್ ಆಕ್ರಾ ಜ಼ನಾಂಚೆ ಸಂಗ ತ್ಯೊಬಿ ಅಪೊಸ್ತಲ್ ಜಾ಼ಲ್ಹಾ. ");
INSERT INTO gok_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","ಪಂಚಾಶತಮಾನ ಸನಾಚಾ಼ ದೀಸ್ ಆಲಾ ತವಾ ತೀ ಸಗ್ಳಿ ಇಸ್ವಾಸಿ ಲೊಕ ಯಕಿಕ್ಡಸ್ ಮಿಳಾಲಿತ. ");
INSERT INTO gok_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","ತವಾ ಅಬ್ಳಾತ್ನಿ ಯೊಕ್ ಸಬ್ದ ಯಗ್ದಮ್ ಆಲಾ ವಾರಮುಡಿಚೆಗತ್ ತ್ಯೊ ಸಬ್ದ ಹುತ್ತಾ. ತೆ ಬಸ್‌ಲ್ಯಾಲ್ಯಾ ಗರ‍್ಹಾತ್ ಸಗ್‍ಳ್ಯಾ ತ್ಯೊ ಸಬ್ದ ಬರ‍್ಲಾ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","ಆನಿ ಯಗ್‌ಳ್ಯಾ ಯಗ್‌ಳ್ಯಾ ವ್ಹಯಿತ್ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ಇಸ್‌ಥ್ಯಾಚಾ ಜಿಬಿ ಶಾರ್ಕ್ಯಾ ತ್ಯನಾ ದಿಸಲ್ಯಾ, ಆನಿ ಪರತೇಕಾವ ತ್ಯಾ ಯೇಕ್ ಯೇಕ್ ಆಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","ತೀ ಸಗ್ಳಿ ಪವಿತ್ರಾತ್ಮಾನಿ ಬರ್‌ಲ್ಯಾಲಿ ಜಾ಼ಲಿತ ಆನಿ ದುಸ್ರೆ ದುಸ್ರೆ ಬಾಶೆತ್ನಿ ಬೊಲಾಯಾ ಲಾಗ್ಲಿತ ಪವಿತ್ರಾತ್ಮಾನಿಸ್ ತ್ಯ ಬಳ್ ತ್ಯನಾ ದಿಲ. ");
INSERT INTO gok_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","ಖುಬ್ ಬಕ್ತಿವಾನ್ ಯೆಹುದಿ ತ್ಯಾ ಯಳಾತ್ ಯೇರುಸಲೇಮಿತ್ ಹುತ್ತ. ಹ್ಯಂಚಿಪ ದುನೆತ್‌ಲೆ ಪರತೇಕ್ ದೇಶೆತ್ನಿ ಆಲ್ಯಾಲಿ ಲೊಕ ಹುತ್ತಿತ. ");
INSERT INTO gok_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","ತ್ಯೊ ಸಬ್ದ ಆಲಾ ತವಾ ಲೊಕ ಸಗ್ಳಿ ಯೇಕ್ ವ್ಹವುನ್ ಯವುನ್ ಪರತೇಕ್ ಜ಼ನ ಆಪ್ಲೆ ಆಪ್ಲೆ ಬಾಶೆತ್ ತೀ ಬೊಲ್‌ತ್ಯಾಲಿ ಬಗು‍ನ್ ಆಜಾಬ್ ಜಾ಼ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","ತೇ ಸಗ್ಳ ಆಜಾಬ್ ವ್ಹವುನ್, “ಬಗಾ; ಹೆ ಬೊಲ್‌ತ್ಯಾಲ ಸಗ್ಳ ಗಲಿಲಾಯಾತ್ಲ ನವ್ಹ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","ಫನ್ ಆಮಿ ಪರತೇಕ್ ಯೊಕ್ ಆಮ್ಚೆ ಆಮ್ಚೆ ಸ್ವತಾಚೆ ಬಾಶೆತ್ ಹೆ ಬೊಲ್‌ತ್ಯಾಲ ಐಕ್‌ತ್ಯಾವ್ ನವ್ಹ, ಹ್ಯ ಕಸ? ");
INSERT INTO gok_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","ಆಮ್ಚಿಪ ಪಾರ್ತಿ, ಮೆದಿ ಆನಿ ಎಲಾಮಿ, ಮೆಸೊಪೊಟೆಮಾ, ಯುದಾಯ್, ಕಪದೊಕ್ಯಾತ್ಲ, ಪೊಂತ್ಯಾತ್ಲ, ಆಶಾ. ");
INSERT INTO gok_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ಪ್ರಿಜಿಯಾತ್ಲ, ಪಾಂಪಿಲಿಯಾತ್ಲ, ಈಜಿಪ್ಟಾತ್ಲ, ಆನಿ ಸೆರೆನಿಚೆ ಜ಼ವಳ್ ಆಸ್‌ಲ್ಯಾಲ ಲೆಬಿಯಾ ಗಾವಾತ್ಲ ಆನಿ ಆಮ್ಚಾತ್ಲ ಥೊಡ ರೊಮಾತ್ಲ ಹಾತ್ತ. ");
INSERT INTO gok_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ಯೆಹುದಿ ಆನಿ ಯೆಹುದಿ ಧರ್ಮ ಪ್ಯಾಳ್‌ತ್ಯಾಲಿ ದುಸ್ರಿ ಲೊಕ ಕ್ರೆತಾ ಆನಿ ಅರಬಿ ದೇಶೆತ್ಲಿ ಜಾ಼ಲ್ಯಾಲಿ ಆಮಿ ಆಮ್ಚೆ ಆಮ್ಚೆ ಬಾಶೆತ್ನಿ ಹ್ಯಂಚಾನಿ ದೇವಾಚಾ ಮಹತ್ಕಾರಾಚೆ ಗುಶ್ಟಿತ್ ಸಾಂಗ್‌ತ್ಯಾಲ ಐಕ್‌ಲ್ಯಾ ಮನ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","ಲೊಕ ಸಗ್ಳ ಗಾಬ್ರುನ್ ಆನಿ ಗುಂದ್ಳುನ್, ಹ್ಯ ಕ್ಯಾ ಆಸಲ್? ಮನ್ಹುನ್ ಯಕಾಮಕಾಲಾ ಇಚಾರಾಯಾ ಲಾಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","ಥೊಡ್ಯಾಂಚಾನಿ ಅಪೊಸ್ತಲಾನಾ ಬಗುನ್ ಹೇ ಖುಬ್ ದರಾಕ್ಷಿಚಾ಼ ರಸ್ ಪಿವುನ್ ನಿಶಾ ಚ಼ಡ್ಲಿ ಮನ್ಹುನ್ ಮಸ್ಕರಿ ಕಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","ಮಂಗ್ ಪೇತ್ರಾ ಉರಲ್ಯಾಲ್ಯಾ ಆಕ್ರಾಜಾ಼ನ್ ಆಪೊಸ್ತಲಾಂಚಿ ಸಂಗ ಉಠುನ್ ಉಬಾ ರಾಹುನ್. ಸಗ್‍ಳ್ಯಾನಾ ಐಕಜೊ಼ಗಾ ಜೊ಼ರಾನಿ ಆಸಾ ಮನ್ಲಾ ಯಹುದ್ಯಾನು ಯೇರುಸಲೇಮಿತಲ್ಯಾನು ಐಕಾ ತುಮಾನಾ ಸಮಜಾ಼ಯಾ ವ್ಹಯಿ ಜಾ಼ಲ್ಯಾಲಿ ಖನ್ಕತ್ ಫುಡುನ್ ಸಾಂಗ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","ತುಮಿ ಮಂತ್ಯಾಚೆಗತ್ ಹಿ ಲೊಕ ಪಿವುನ್ ನಿಶಾ ಚ಼ಡಲ್ಯಾಲಿ ನವ್ಹತ. ಆತಾ ಸಕಾಳಚ಼ ನವು ಗಂಟ ತ್ಯವ್ಡಸ್!. ");
INSERT INTO gok_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","ಫನ್ ಆತಾಹಿತ್ತ ಚಾ಼ಲತ್ಯಾಲ್ಯಾ ಖನ್ಕತಿಂಚೆ ಗುಶ್ಟಿತ್ ಪ್ರವಾದಿ ಜಾ಼ಲ್ಯಾಲಾ ಯೊವೆಲ್ ಆಸಾ ಬೊಲ್ಯಾ: ");
INSERT INTO gok_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","ದೇವ್ ಆಸಾ ಮಂಥ್ಯೊ ಸೇವಟ್ಚಾ ದಿಸಾತ್ ಆಸ ವ್ಹಯಿಲ್ ಮಿ ಮಾನ್ಸಾನಾ ಮಾಜ಼ ಆತ್ಮ ದಿಯಿನ್ತವಾ ಪ್ಯೊರ್ಗ್ಯಾನಾ ಪುರಿನಾ ಭವಿಶ್ವಾನಿ ಸಾಂಗ್ನಾರ್ ತುಮ್ಚಾ ತರ್ನ್ಯಾನಾ ದರ್ಶಾನ ಗಾವ್ನಾರ ತುಮ್ಚಾ ವಡ್ಲಾನಾ ಸಪ್ನ ಪಡ್ನಾರ್ ");
INSERT INTO gok_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","ಆನಿ ಮಾಜ಼ ಆತ್ಮ ಮಿ ಮಾಜಾ ಸೆವಕ್ ಆನಿ ಸೆವಕಿಂಚಿವ ದೆನಾರ್ ತಿಬಿ ಭವಿಶ್ವಾನಿ ಸಾಂಗ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","ಆನಿ ವರ್ ಅಬ್ಳಾತ್ ಅದ್ಬುತ ಖಾಲ್ ದರ್ಥೀವ ಚಿ಼ನ್ನ, ಮಂಜೆ ರಗಾತ್, ಇಸ್ಥು, ಆನಿ ಹವಚಿವಾಪ್ ಆಸ ಮಿ ದಾವಿನ್. ");
INSERT INTO gok_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","ಆನಿ ದೀಸಾವ ಆಂದಾರ್ ಯನಾರ್ ಚಾ಼ಂದ್ ರಕ್ತಾಚೆಗತ್ ತಾಂಬ್ಡಾ ವ್ಹನಾರ್ ತವಾ ಪ್ರಭುಚ಼ ಯನ ಮೈಮೆಚಾ಼ ಆನಿ ಮೊಟಾ ದೀಸ್ ಯನಾರ್. ");
INSERT INTO gok_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","ಪ್ರಭುಚಾ ನಾವಾನಿ ಮಾಗ್ನ ಕರ್ನಾರ‍್ಯಾ ಸಗ್‌ಳ್ಯಾಂಚ಼ ರಕ್ಶನ್ ವ್ಹನಾರ್. ");
INSERT INTO gok_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","ಇಸ್ರಾಯೆಲ್ ಲೊಕಾನು ಮಿ ಸಾಂಗ್‌ತ್ಯಾಲ ಐಕಾ ನಜ಼ರೇತಿಚಾ಼ ಯೇಸು ಹಾ ಮನ್ಹುನ್ ತುಮಾನಾ ಠಾವ ಆಸ್‌ಲ್ಯಾಚೆಗತ್ ದೇವಾನಿ ತ್ಯಚಾ ಹಾತಾನಿ ಮೊಟಿ ಆನಿ ಚಮತ್ಕಾರಾಚಿ ಕಾಮ ತುಮ್ಚಿಪ ಚಾ಼ಲ್ವುನ್ ತ್ಯೊ ಆಪ್‌ಲ್ಯಾಲಾ ಆವಾಡಲ್ಯಾ ಮನ್ಹುನ್ ತುಮಾನಾ ತ್ಯನಿ ಶಾರ್ಕ ದಾವುನ್ ದಿಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","ಯೇಸುಲಾ ತುಮ್ಚಾ ತಾಬ್ಯಾತ್ ದಿಲ್ತಾ ತುಮಿ ಬುರ್ಶಾಂಚೆ ಮಜ಼ತಿನಿ ಶಿಲುಬೆವ ಗ್ಯಾತ್ಲಾಸಾ ಫನ್ ಹ್ಯ ಸಗ್ಳ ವ್ಹನಾರ್ ಮನ್ಹುನ್ ದೇವಾಲಾ ಠಾವ ಹುತ್ತ. ಹೀ ದೇವಾಚಿ ಯವಜ್ನಾ಼. ");
INSERT INTO gok_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","ಯೇಸುನಿ ಮರ್ನಾಚಾ಼ ತರಾಸ್ ಗೆತ್ಲಾ. ಫನ್ ದೇವಾನಿ ತ್ಯಲಾ ಸುಡಿವ್ಲಾ ದೇವಾನಿ ಯೇಸುಲಾ ಮೇಲ್ಯಾಲ್ಯಾತ್ನಿ ಜಿತ್ತಾ ಕರುನ್ ಉಠಿವ್ಲಾ. ಮರ್ನಾಚೆ ಹಾತ್ನಿ ಯೇಸುಲಾ ದರಯಾ ಜಾ಼ಲ್ಹ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","ಯೇಸುಚೆ ಗುಶ್ಟಿತ್ ದಾವಿದಾನಿ ಆಸ ಸಾಂಗ್‌ಲ್ಯಾ, “ಪ್ರಭು ಕವಾಬಿ ಮಾಜೆ ಮೊರ‍್ಹ ಆಸ್‌ಲ್ಯಾಲಾ ಬಗ್‌ಲ್ಯಾ ಮೀ ಡಳು ನಾಹಿ ಆಸ ಮಾಜೆ ಉಜ಼ವ್ಯಾಂಗ್ನಿಸ್ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","ಮನ್ಹುನ್ ಮಾಜ಼ ಮನ್ ಆನಂದಾನಿ ಬರ್‌ಲ್ಯಾ. ಮಾಜ಼ ತ್ವಾಂಡ್ ವವ್ಯಾಳ್‌ತ್ಯಾ, ಮಾಜ಼ ಶರೀರ್ ಆಶಾನಿ ಬರ‍್ಹುನ್ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","ಕಾ ಮಂಜೆ ತು ಮಾಜಾ ಜೀವಾಚ಼ ಆತ್ಮ ಪಾತಾಳಾತ್ ಸುಡಿತ್ನಾಹಿಸ್, ಮಾಜಾ ಪವಿತ್ರ ಮಾನ್ಸಾಲಾ ಕುಜು಼ದಿಯಿತ್ ನಾಹಿಸ್. ");
INSERT INTO gok_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","ಆಸ ಜೀವ್ನಾ ಕರಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ತು ಮನಾ ದ್ಯಾವ್ಲಸ್ ತುಜೆ ಮೊರ್ಹಸ್ ಮನಾ ಆನಂದಾನಿ ಬರಿವ್ನಾರ್ ಮನ್ಹುನ್ ಸಾಂಗ್‍ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","ಮಾಜೆ ಬನ್ಹಿ ಬಾವ್ಹಾನು ಆಮಚಾ಼ ಪೈಲಾ ವಡಿಲ್ ರಾಜಾ಼ ದಾವಿದಾಚೆ ಗುಶ್ಟಿತ್ ಮಿ ತುಮಾನಾ ಖರ ಸಾಂಗ್ತೊ. ತ್ಯೊ ಮೆಲಾ ಆನಿ ತ್ಯಲಾ ಪುರ್ಲಾ ತ್ಯಚಿ ಮಸುರ್ಡಿ ಆಮ್ಚೆ ಮದ್ದಿ ಆಜ಼್ಪರೇತ್ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","ದಾವಿದ್ ಯೊಕ್ ಪ್ರವಾದಿ ಜಾ಼ಲ್ಥಾ ಆನಿ ತುಜೆ ಪಿಳ್ಗಿತ್‌ಲ್ಯಾ ಯಕಾಲಾ ತುಜೆ ರಾಜ್ ಚಾ಼ಲಿವತ್ಯಾಲೆ ಖುರ್ಚಿವ ಬಸಿವ್ನಾರ್ ಮನ್ಹುನ್ ದೇವಾನಿ ತ್ಯಲಾ ಶಪ್ಪತ್ ದಿವುನ್ ವಚ಼ನ್ ದಿಲ್ಯಾಲ ತ್ಯಲಾ ಠಾವ ಹುತ್ತ. ");
INSERT INTO gok_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","ದೇವ್ ಮೊರ‍್ಹ ಕ್ಯಾ ಕರ್ನಾರ್ ಮನ್ಹುನ್ ದಾವಿದಾಲಾ ಠಾವ ಹುತ್ತ. ಯೇಸು ಮರ್ನಾತ್ನಿ ಜಿತ್ತಾ ವ್ಹಯಾಚೆ ಗುಶ್ಟಿತ್, ತ್ಯಲಾ ಪಾತಾಳಾತ್ ಶೊಡ್ನಾರ್ ನಾಹಿ ಮನ್ಹುನ್ ತ್ಯಚ಼ ಶರೀರ್ ಕುಜು಼ದಿಯಿತ್ ನಾಹಿಸ್ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","ಮನ್ಹುನ್ ದೇವಾನಿ ಯೇಸುಲಾ ಮರ‍್ನಾತ್ನಿ ಜಿತ್ತಾ ಕರುನ್ ಉಠಿವಲ್ಯಾಲ್ಯಾ ಹ್ಯಲಾ ಆಮಿ ಸಗ್ಳ ಸಾಕ್ಷಿ ಆಮಿ ತ್ಯಲಾ ಬಗ್‌ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","ಯೇಸು ಸ್ವರ್ಗಾತ್ ಗೆಲಾ ಆತಾ ತ್ಯೊ ತಿಥ ಹಾ ದೇವಾಚೆ ಉಜ಼ವ್ಯಾಂಗ್ನಿ ಹಾ ಆತಾ ದೇವಾನಿ ಪವಿತ್ರಾತ್ಮ ಯೇಸುಲಾ ದಿಲ್ಯಾ. ಪವಿತ್ರಾತ್ಮ ದೇನಾರ್ ಮನ್ಹುನ್ ದೇವಾನಿ ಸಬ್ದ ದಿಲ್ತಾ ಮನ್ಹುನ್ ಯೇಸುನಿ ಆತಾ ತ್ಯ ಆತ್ಮ ದಿಲ್ಯಾ. ತುಮಿ ಬಗ್‌ತ್ಯಾಲ ಆನಿ ಐಕ್‌ತ್ಯಾಲ ಹ್ಯಸ್. ");
INSERT INTO gok_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","ದಾವಿದ್ ರಾಜಾ಼ ಸ್ವರ್ಗಾತ್ ಗೆಲಾ ನಾಹಿ ಫನ್ ತ್ಯೊ ಸಾಂಗತ್ಯಾಲಾ ಕ್ಯಾ ಮಂಜೆ. ");
INSERT INTO gok_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ಮಿ ತುಜಾ ವಾದಿನಾ ತುಜಾ ಪಾಯಾಖಾಲ್ ಗಾಲಿ ಪರತ್ ತು ಮಾಜೆ ಉಜ಼ವ್ಯಾಂಗ್ನಿ ಬಸುನ್ ರ‍್ಹಾ. ");
INSERT INTO gok_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","ಮನ್ಹುನ್ ಸಗ್‌ಳ್ಯಾ ಯೆಹುದ್ಯಾಂಚಾನಿ ಹ್ಯ ಖರ‍್ಯಾನಿ ಸಮಜು಼ನ್ ಗಿಹ್ಯಾ ವ್ಹಯಿ. ತುಮಿ ಶಿಲ್ಬೆವ ಗಾಲ್ಹುನ್ ಮ್ಯಾರಲ್ಯಾಲ್ಯಾಲಾ ದೆವಾನಿ ಪ್ರಭು ಆನಿ ಕ್ರಿಸ್ತ ಮನ್ಹುನ್ ಥರಿವ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","ಹ್ಯ ಐಕ್ಲ ತವಾ ತ್ಯಂಚೆ ಶಾತಿತ್ ಕಾಟಾ ಬೊಚ಼ಲ್ಯಾಚೆಗತ್ ಜಾ಼ಲ್ಹಾ ತ್ಯಂಚಾನಿ ಪೇತ್ರಾಲಾ ಆನಿ ಅಪೊಸ್ತಲಾನಾ, “ಬಾವ್ಹಾನು ಆತಾ ಆಮಿ ಕ್ಯಾ ಕರಾಯಾ ವ್ಹಯಿ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","ಪೇತ್ರನಾನಿ ತ್ಯನಾ ತುಮ್ಚಾತ್ ಪರತೇಕ್ ಯಕಾನಿ ತುಮ್ಚಾ ಪಾಪಾಂಚೆಸಾಟಿ ಪಶ್ಚಾತಾಪಾನಿ ದೇವಾಕ್ಡ ಪರ್ತುನ್ ಯೇಸು ಕ್ರಿಸ್ತಾಚಾ ನಾವಾನಿ ಬಾಪ್ತಿಸ್ಮಾ ಗೆವ್ಹಾ. ತವಾ ದೇವ್ ತುಮ್ಚಿ ಪಾಪ ಮಾಪ್ಕರೀಲ್. ಆನಿ ದೇವಾನಿ ಸಬ್ದ ದಿಲ್ಯಾಲಾ ವರ್ ಪವಿತ್ರಾತ್ಮ ಗಿಸಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","ದೇವಾಚಾ಼ ಸಬ್ದ ತುಮಾನಾ ತುಮ್ಚಾ ಪೊರಾನಾ ಖುಬ್ ದುರ್ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ಲೊಕಾನಾ ದಿಲ್ಯಾ. ಪ್ರಭು ಆಮ್ಚಾ ದೇವಾನಿ ಆಪ್ಲಿಪ ಹಾಕಟ್‌ಲ್ಯಾಲ್ಯಾ ಪರ್ತೇಕಾಲಾ ಹ್ಯೊ ಸಬ್ದ ದಿಲ್ಯಾ. ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","ಪೆತ್ರಾನಿ ಆನಿಕ್ ದುಸರ‍್ಯಾ ಸಬ್ದಾಂಚಾನಿ ತ್ಯನಾ ಖಡ್ಯಾವುನ್ ಹೇ ಬುರ್ಸೆ ಪಿಳ್ಗಿಚೆ ಶಿಕ್ಷಾತ್ನಿ ತುಮಿ ಚು಼ಕ್ವುನ್ ಗೆವ್ಹಾ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","ನ್ಯಾಯಿ ತಿರ್ಮಾನಾಲಾ ಆತ್ ಜಾ಼ಲ್ಯಾಲ್ಯಾಂಚಿಪ್ನಿ ಚು಼ಕ್ವುನ್ ಗೆವ್ಹಾ ಮನ್ಹುನ್ ಸಾಂಗ್‌ಲ್ಯಾಲ ಐಕ್‌ಲ್ಯಾಲ್ಯಾ ಲೊಕಾಂಚಾನಿ ಬಾಪ್ತಿಸ್ಮಾ ಗಿತ್ಲಿ. ತೀಸಿ ಜ಼ವ ಜ಼ವಳ್ ತೀನ್ ಹಾಜಾ಼ರ್ ಲೊಕ ತ್ಯಂಚಿ ಸಂಗ ಮಿಸಾಳ್ಳಿತ. ");
INSERT INTO gok_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","ಹಿ ಸಗ್ಳಿ ಅಪೊಸ್ತಲಾಂಚ಼ ಶಿಕ್ಷನ ಐಕ್‌ನ್ಯಾತ್ ಬಾವ್ಹಾಂಚೆ ಯಕಿತ್ ಮಿಳುನ್ ಖಾತ್ಯಾಲ್ಯಾತ್ ಮಾಗ್ನ ಕರ್ನ್ಯಾತ್ ರಾಹಿತಿತ. ");
INSERT INTO gok_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","ಅಪೊಸ್ತಲ್ ಖುಬ್ ಚಮತ್ಕಾರಾಚಿ ಕಾಮ ಆನಿ ಸಾಕ್ಷಿ ಕರಿತ ಆನಿ ಪರತೇಕ್ ಯಕಾಲಾ ದೇವಾವ ಭೆ ಆನಿ ಭಕ್ತಿ ಆಲಿ. ");
INSERT INTO gok_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","ಸಗ್ಳಿ ಇಸ್ವಾಸಿ ಯಕಿಕ್ಡಸ್ ರಾಹಿತಿತ ತೀ ಆಪ್ಲ ಪರ್ತೇಕ್ ಯಾಕ್ ಸಾಮಾನ್ ವಾಟುನ್ ಗಿಹಿತಿತ. ");
INSERT INTO gok_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","ಆಪ್ಲಿ ಜಿಮಿನ್ ಆನಿ ಆಪ್ಲ ಮ್ಹಾಲ್ಮಾತ ಇಕುನ್ ಆಲ್ಯಾಲ ಪೈಸ ಸಗ್ಳ ತ್ಯಂಚಿ ಗರಜ಼್ ಆಸ್‌ಲ್ಯಾನಾ ವಾಟುನ್ ದಿಯಿತಿತ. ");
INSERT INTO gok_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","ಖಾಯಿಮ್ ದೇವ್ಳಾತ್ ಜ಼ಮತಿತ ತ್ಯಂಚಾ಼ ಸಗ್‌ಳ್ಯಾಂಚಾ಼ ಉದ್ದೆಸ್ ಯೊಕುಸ್ ಜಾ಼ಲ್ಥಾ ತೆ ಆಪ್‌ಲ್ಯಾ ಗರ‍್ಹಾತ್ನಿ ಬಾಕ್‌ರ‍್ಯಾ ಮುಡುನ್ ಸಗ್ಳಿ ಮಿಳುನ್ ಖಾಯಿತಿತ. ತ್ಯಂಚಿ ಖರಿ ಮನ ಆನಂದಾನಿ ಬರ್ಲಿ ಹುತ್ತಿತ. ");
INSERT INTO gok_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","ತೀ ದೇವಾಲಾ ಸ್ತುತಿ ಕರಿತಿತ ಆನಿ ಲೊಕ ಸಗ್ಳಿ ತ್ಯಂಚಿ ಮಾಯಾ ಕರಿತಿತ ಖಾಯಿಮ್ ಖುಬ್ ಲೊಕ ರಕ್ಶನೆತ್ ಯಯಿತಿತ ಪ್ರಭು ತ್ಯನಾ ಸಗ್‌ಳ್ಯಾನಾ ಇಸ್ವಾಸಿಂಚಾ ಮೆಳ್ಯಾತ್ ಗಾಲಿತಾ. ");
INSERT INTO gok_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","ಯಕಸಿ ಪೇತ್ರಾ ಆನಿ ಯೊಹಾನ್ ದೊಪ್ಯಾರ್ಚ಼ ತಿನ್ ಗಂಟ್ಯಾಲಾ ದೇವ್ಳಾತ್ ಮಾಗ್ನ ಕರಾಯಾ ಗೆಲ ತ್ಯೊ ಮಾಗ್ನ ಕರ್ತ್ಯಾಲಾ ಯೊಳ್ ಜಾ಼ಲ್ಥಾ. ");
INSERT INTO gok_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","ತೇ ದೇವ್ಳಾತ್ ಜಾ಼ತಾನಾ ತಿಥ ಯೊಕ್ ಜ಼ಲ್ಮತ್ ಚಾ಼ಲಾಯಾ ಯಯಿತ್ ನಸ್‌ಲ್ಯಾಲಾ ಲಂಗ್ಡಾ ಹುತ್ತಾ. ತ್ಯಲಾ ಚಾ಼ಲಾಯಾ ಯಯಿತ್ ನವ್ಥ ತ್ಯಲಾ ಖಾಯಿಮ್ ಕೊನ್ತರಿ ದೇವ್ಳಾತ್ ಉಚ್ಲುನ್ ಆನುನ್ ದೇವ್ಳಾಚಾ ಬಾಹಿರ್‌ಲ್ಯಾ ಯಕಾ ಶಾದ್ರ ಮಂಥ್ಯಾಲ್ಯಾ ಬೇಡ್ಯಾಪ ಬಸ್ವಿತ. ತ್ಯೊ ದೇವ್ಳಾತ್ ಜಾ಼ತ್ಯಾಲ್ಯಾ ಲೊಕಾಂಚಿಪ ಭಿಕ್ ಮಾಗಿತಾ. ");
INSERT INTO gok_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","ತಿಸಿ ದೇವ್ಳಾಕ್ಡ ಜಾ಼ತ್ಯಾಲ್ಯಾ ಪೆತ್ರಾ ಯೊಹಾನಾನಾ ಬಗುನ್ ತ್ಯಂಚಿಪ್ನಿ ಕಾಯ್ತರಿ ಗಾವಲ್ ಮನ್ಹುನ್ ಭಿಕ್ ಮಾಗ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","ಪೇತ್ರಾ ಆನಿ ಯೊಹಾನಾನಿ ತ್ಯಾ ಲಂಗ್‌ಡ್ಯಾಲಾ ಜ಼ಪುನ್ ಬಗುನ್ “ಆಮ್ಚಿಕ್ಡ ಬಗ್!” ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","ಆಪ್‌ಲ್ಯಾಲಾ ಕಾಯ್ತರಿ ದಿತಿಲ ಮನ್ಹುನ್ ತ್ಯನಿ ತ್ಯಂಚಿಕ್ಡ ಬಗ್ಲ ");
INSERT INTO gok_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","ಫನ್ ಪೇತ್ರಾ ಚಾ಼ಂದಿ ಸೊನ ಮಾಜಿಪ ನಾಹಿ ಮಾಜಿಪ ಹಾತ್ಯ ತುಲಾ ದೆತೊ. ನಜ಼ರೇತಿಚಾ ಯೇಸು ಕ್ರಿಸ್ತಾಚಾ ನಾವಾನಿ ಚಾ಼ಲ್ ಮನ್ಹುನ್, ");
INSERT INTO gok_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","ತ್ಯಚಾ಼ ಉಜ಼ವಾ ಹಾತ್ ದರ‍್ಹುನ್ ಉಚ಼ಲ್ಲಾ. ತವಾಸ್ ತ್ಯಚಾ ಪಾಯಾನಾ ಆನಿ ಸಾಂದ್ಯಾನಾ ಬಳ್ ಆಲ. ");
INSERT INTO gok_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ತ್ಯನಿ ಉಡಿಮಾರುನ್ ಆಪ್‌ಲ್ಯಾ ಪಾಯಾವ ಉಬಾ ರಾಹುನ್ ಚಾ಼ಲಾಯಾ ಲಾಗ್ಲಾ. ತ್ಯೊ ತ್ಯಂಚಿಸಂಗ ದೇವ್ಳಾತ್ ಗೇಲಾ ತ್ಯನಿ ಚಾ಼ಲತ್ ನಾಚ಼ತ್ ದೇವಾಲಾ ವವ್ಯಾಳಾ. ");
INSERT INTO gok_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","ಆತಾ ತ್ಯೊಸ್ ಮಾನುಸ್ ಚಾ಼ಲತ್ ದೇವಾಲಾ ವವ್ಯಾಳ್‌ತ್ಯಾಲಾ ಲೊಕಾಂಚಾನಿ ಬಗ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ಶಾದ್‌ರ‍್ಯಾ ಬೆಡ್ಯಾಚೆ ಮೊರ‍್ಹ ಬಸುನ್ ಭಿಕ್ ಮಾಗ್‌ತ್ಯಾಲಾ ಲಂಗ್ಡಾ ಹ್ಯೊಸ್ ಮನ್ಹುನ್. ಸಗ್‌ಳ್ಯಾ ಲೊಕಾಂಚಾನಿ ತ್ಯಲಾ ವಳಕ್ಲಾ ಆನಿ ಸಗ್ಳಿ ಆಜಾಬ್ ಜಾ಼ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","ತ್ಯೊ ಮಾನುಸ್ ಪೇತ್ರಾ ಆನಿ ಯೊಹಾನಾಂಚೆ ಸಂಗ ರಾಯ್ಲಾ ತ್ಯಲಾ ಬರ ಜಾ಼ಲ್ಹ ಮನ್ಹುನ್ ಲೊಕ ಸಗ್ಳಿ ಗಾಭಾರ್ಲಿತ. ಸೊಲೊಮೊನಾಚಾ ಅಂಗ್ನಾತ್ ಉಬರಾಯಲ್ಯಾಲ್ಯಾ ಪೇತ್ರಾ ಆನಿ ಯೊಹಾನಾಪ ತೀ ಪಳತ್ ಆಲಿತ ");
INSERT INTO gok_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","ತವಾ ಪೇತ್ರಾ ತ್ಯನಾ ಮಾಜಾ ಇಸ್ರಾಯಲ್ ಲೊಕಾನು ಹ್ಯ ಬಗುನ್ ತುಮಿ ಕಾ ಆಜಾಬ್ ವ್ಹತಾಸಾ? ಹ್ಯಾ ಮಾನ್ಸಾಲಾ ಚಾ಼ಲಜೊ಼ಗ ಕೆಲ್ಯಾಲ ಆಮ್ಚಾ ಬಳಾನಿ ಮನ್ಹುನ್ ತುಮಿ ಆಮಾನಾ ಬಗ್ತಾಸಾ ಆಮಿ ಚಾ಼ಂಗ್ಲ ಹಾವ್ ಮನ್ಹುನ್ ಹಿ ಕಾಮ ವ್ಹತ್ಯಾತ ಮನ್ಹುನ್ ಸಮಜು಼ನ್ ಗೆಥಾಸಾ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","ಅಬ್ರಹಾಮಾಚಾ಼ ದೇವ್ ಇಸಾಕಾಚಾ಼ ದೇವ್ ಆನಿ ಯಾಕೊಬಾಚಾ಼ ದೇವ್. ಆನಿ ಆಮ್ಚಾ ವಡ್ಲಾಂಚಾ಼ ದೇವ್. ತ್ಯನಿ ಆಪ್ಲಾ ಸೆವಕ್ ಯೇಸುಲಾ ಮೈಮೆ ಕೆಲೆ. ಫನ್ ತುಮಿ ಯೇಸುಲಾ ಮಾರುನ್ ಟಾಕಾಯಾ ದಿಲಾಸಾ ತ್ಯಲಾ ಸೊಡಾಯಾ ಪಿಲಾತಾನಿ ಥರಿವ್ಲಾ ಫನ್ ತುಮಿ ಪಿಲಾತಾಪ ನಕ್ವಾಟ್ ಕಿಲಿ ");
INSERT INTO gok_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","ಯೇಸು ಪರಿಶುದ್ದ ಜಾ಼ಲ್ಥಾ ಆನಿ ನಿಯತಿಚಾ಼ ಜಾ಼ಲ್ಥಾ. ಫನ್ ತುಮಿ ತ್ಯಲಾ ನಕೊ ಮನ್ಲಾಸಾ ತ್ಯಚೆ ಬದ್ಲಿ ಗಾತ್‌ಕ್ಯಾಲಾ ಸೊಡಾಯಾ ವ್ಹಯಿಸಾ ಮನ್ಹುನ್ ಪಿಲಾತಾಲಾ ಸಾಂಗ್ಲಸಾ. ");
INSERT INTO gok_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","ಆಸ ತುಮಿ ಜೀವ್ ದೇತ್ಯಾಲ್ಯಾಲಾ ಮಾರುನ್‌ಟ್ಯಾಕ್ಲಾಸಾ ಫನ್ ದೇವಾನಿ ತ್ಯಲಾ ಮೆಲ್ಯಾಲ್ಯಾತ್ನಿ ಜಿತ್ತಾ ಕರುನ್ ಉಠಿವ್ಲಾ ಹ್ಯಲಾ ಆಮಿಸ್ ಸಾಕ್ಷಿ. ");
INSERT INTO gok_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","ಹ್ಯಾ ಲಂಗ್‌ಡ್ಯಾ ಮಾನ್ಸಾಲಾ ಬಳ್ ದಿಲ್ಯಾಲ ತ್ಯಚಾ ನಾವಾನಿಸ್ ತುಮಿ ಕ್ಯಾ ಸಮಜು಼ನ್ ಗೆತಲ್ಯಾಸಾ ಆನಿ ಬಗ್‌ತ್ಯಾಸಾ ಹ್ಯ ಸಗ್ಳ ಜಾ಼ಲ್ಯಾಲ ಯೇಸುವ ಥೆವಲ್ಯಾಲ್ಯಾ ಇಸ್ವಾಸಾನಿಸ್ ಬರ ಜಾ಼ಲ್ಯಾಲ ಹ್ಯ ಸಗ್ಳ ತುಮಿ ಬಗಾಯಾ ವ್ಹತ. ");
INSERT INTO gok_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“ಇಸ್ರಾಯಲಾನು ತುಮಿ ಸಮಜಾ಼ಚೆ ಆಂದಿ ಯೇಸುಲಾ ಆಸ ಕೆಲ್ಯಾಸಾ ಮನ್ಹುನ್ ಮನಾ ಠಾವಹಾ ತುಮ್ಚಾ ಅಧಿಕಾರ‍್ಯಾಂಚಾನಿ ಸಾಹಿತ್ ಸಮಜು಼ನ್ ಗೆತ್ಲನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","ಕ್ರಿಸ್ತ್ ತರಾಸ್ ಗಿಹುನ್ ಮರ್ನಾರ್ ಮನ್ಹುನ್ ದೇವಾನಿ ಆಪ್‌ಲ್ಯಾ ಪ್ರವಾದಿಂಚಾ ತೊಂಡಾನಿ ಆಂದಿಸ್ ಸಾಂಗ್‌ಲ್ಯಾಲ ಆಸ ಕೆಲ. ");
INSERT INTO gok_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","ಮನ್ಹುನ್ ತುಮಿ ತುಮ್ಚಾ ಪಾಪಾಂಚೆ ಸಾಟಿ ಪಶ್ಚಾತಾಪ್ ಪಡುನ್ ದೇವಾಕ್ಡ ಪರ್ತಾ ತವಾ ತ್ಯೊ ತುಮ್ಚಿ ಪಾಪ ಮಾಪ್ ಕರಿಲ್. ");
INSERT INTO gok_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ಪ್ರಭು ತುಮಾನಾ ಆತ್ಮಿಕ್ ಇಸ್ರಾಮಾ ದೆನಾರ್ ತ್ಯನಿ ತುಮ್ಚಿಸಾಟಿ ಆಂದಿಸ್ ನಿವಡ್‌ಲ್ಯಾಲ್ಯಾ ಕ್ರಿಸ್ತಾಲಾ ಲಾವುನ್ ದೆನಾರ್. ");
INSERT INTO gok_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","ಸಗ್ಳ ಶಾರ್ಕ ಕರಾಚ಼ ದಿಸ್ ಯಯಿ ಪರ‍್ಯಾತ್ ಯೇಸು ಸ್ವರ್ಗಾತುಸ್ ರಾಹ್ಯಾ ವ್ಹಯಿ. ದೇವಾನಿ ಖುಬ್ ದಿಸಾಂಚೆ ಮಾಗ ಆಪ್‌ಲ್ಯಾ ಪವಿತ್ರ ಪ್ರವಾದಿಂಚೆ ಸಂಗ ಬೊಲ್ಲಾ ತವಾ ಹ್ಯಾ ಕಾಲಾತ್ಲ ಆಂದಿಸ್ ಸಾಂಗ್ಲಹುತ್ತ. ");
INSERT INTO gok_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","ತ್ಯಚಿಸಾಟಿ ಮೊಶೆ ಆಸಾ ಮನ್‌ಲ್ಯಾ ತುಮಚಾ಼ ಪ್ರಬು ದೆವ್ ತುಮಾನಾ ಯೊಕ್ ಪ್ರವಾದಿ ದೆನಾರ್ ತುಮಚಾ ಲೊಕಾತ್ನಿಸ್ ತ್ಯೊ ಪ್ರವಾದಿ ಯನಾರ್. ತ್ಯೊ ಮಾಜಿಗತ್ ರಾನ್ಹಾರ್. ತ್ಯೊ ಪ್ರವಾದಿ ಸಾಂಗಿಲ್‌ತ್ಯ ಸಗ್ಳ ತುಮಿ ಐಕಾಯಾ ವ್ಹಯಿಸಾ. ");
INSERT INTO gok_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","ತ್ಯಚ಼ ಐಕ್‌ಲ್ಯಾ ನಸ್‌ಲ್ಯಾಲಾ ದೇವಾಚಾ ಮಾನ್ಸಾಪ್ನಿ ದುರ್ ರಾಹುನ್ ನಾಸ್ ವ್ಹನಾರ್. ");
INSERT INTO gok_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","ಸಮುವೆಲಾ ದರ್ನಿ ಸಗ್ಳ ಪ್ರವಾದಿ ಆತಾಚಾ ಹ್ಯಾ ಕಾಲಾತ್ಲ ಬೊಲ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","ತ್ಯಾ ಪ್ರವಾದಿಂಚಾನಿ ಸಾಂಗ್‌ಲ್ಯಾಲ್ಯಾ ಗುಶ್ಟಿ ತುಮಿ ಐಕ್‌ಲ್ಯಾಸಾ. ದೇವಾನಿ ತುಮ್ಚಾ ವಡ್ಲಾಂಚೆ ಸಂಗ ಕೆಲ್ಯಾಲ್ಯಾ ಕರಾರಾಲಾ ತುಮಿಬಿ ವಾಟದಾರ್ ಜಾ಼ಲ್ಯಾಸಾ ದೇವಾನಿ ತುಮ್‌ಚಾ಼ ವಡಿಲ್ ಜಾ಼ಲ್ಯಾಲ್ಯಾ ಅಬ್ರಹಾಮಾಲಾ ತುಜೆ ಪಿಳ್ಗಿನಿ ದರ್ಥಿವ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ಲೊಕಾನಾ ಆಶಿರ್ವಾದ್ ವ್ಹನಾರ್ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","ದೇವಾನಿ ಆಪ್‌ಲ್ಯಾ ಸೆವಕಾಲಾ ಮರ್ನಾತ್ನಿ ಉಟ್ವುನ್ ಸಗ್‌ಳ್ಯಾಂಚೆ ಆಂದಿ ತುಮ್ಚಿಪ ಲಾವುನ್ ದಿಲಾ. ತುಮಾನಾ ಆಶಿರ್ವಾದ್ ಕರಾಯಾ ಸಾಟಿ ದೇವಾನಿ ತ್ಯಲಾ ಲಾವುನ್ ದಿಲಾ. ತ್ಯೊ ತುಮಾನಾ ತುಮ್ಚಾ ಬುರ್ಶಾ ಕಾಮಾತ್ನಿ ದುರ್ ಕರುನ್ ಆಶಿರ್ವಾದ್ ಕರ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","ಪೇತ್ರಾ ಆನಿ ಯೊಹಾನ್ ಲೊಕಾಂಚೆ ಸಂಗ ಬೊಲ್‌ತ್ಯಾಲ ಆಸ್ಥಾನಾ ಥುಡಿ ಲೊಕ ತ್ಯಂಚಿಪ ಆಲಿತ ತಿಥ ಥೊಡ ಯಹುದಿ ಯಾಜಕ್ ಹುತ್ತ. ಥೊಡ ಸಧುಕಾಯ್ ಹುತ್ತ. ಆನಿ ದಿವುಳ್ ರಾಕ್‌ತ್ಯಾಲ್ಯಾ ಸಿಪಾಯಿಂಚ಼ ದಳಪತಿ ಹುತ್ತ. ");
INSERT INTO gok_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","ಹೇ ದೊಗ ಅಪೊಸ್ತಲ್ ಲೊಕಾನಾ ಸಿಕಿವ್‌ತ್ಯಾಲ ಬಗುನ್ ತ್ಯಂಚಾನಿ ರಾಗ್ ಕೇಲಾ ಯೇಸುಚಾ ಬಳಾನಿ ಲೊಕ ಪುನರುಥಾನ್ ವ್ಹತ್ಯಾತ ಮನ್ಹುನ್ ಪೇತ್ರಾ ಆನಿ ಯೊಹಾನ್ ಶಿಕ್ವಿತ. ");
INSERT INTO gok_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","ಯೆಹುದಿ ಜಾಂತ್ಯಾಂಚಾನಿ ತ್ಯನಾ ದೊಗಾನಾ ದರುನ್ ತುರುಂಗಾತ್ ಗ್ಯಾತ್ಲ ತವಾ ಕಾಳೊಕ್ ಜಾ಼ಲ್ಹಾ ಮನ್ಹುನ್ ತ್ಯಂಚಾನಿ ತ್ಯನಾ ದಿಸರ‍್ಯಾ ದಿಸಾ ಪರ‍್ಯಾತ್ ತುರುಂಗಾತುಸ್ ಥೆವ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","ಫನ್ ಪೇತ್ರಾ ಆನಿ ಯೊಹಾನಾಚ಼ ಶಿಕ್ಷೆನ್ ಐಕುನ್ ಖುಬ್ ಲೊಕಾಂಚಾನಿ ಇಸ್ವಾಸ್ ಥೆವ್ಲಾ. ತವಾ ಲೊಕಾಂಚೆ ಮದ್ದಿ ಬಾಪಯಿ ಇಸ್ವಾಸಿಂಚಾ಼ ಸಂಖೆ ಜ಼ವಜ಼ವಳ್ ಪಾಚ಼್ ಹಾಜಾ಼ರ್ ಚ಼ಡ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","ದಿಸ್ರೆ ದಿಸಿ ಯೆಹುದಿ ಫುಡಾರಿ ಆನಿ ಜಾಂತ ಧರ್ಮಶಾಸ್ತಾರ್ ಸಾಂಗ್‌ತ್ಯಾಲ್ಯಾಂಚಿ ಯೆರುಸಲೆಮಿತ್ ಸಬೆ ಜ಼ಮ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","ತಿಥ ಹನ್ನಾ ಮುಖ್ಯ ಯಾಜಕ್ ಕಾಯಫ್ ಯೊಹಾನ್ ಆನಿ ಅಲೆಕ್ಸಾಂಡರ್ ಹುತ್ತ. ಮುಖ್ಯಾ ಯಾಜಕಾಂಚಾ ಕುಟ್ಮಾಚಾ ನಾತ್ಯಾತ್ಲ ಪರತೇಕ್‌ಜಾ಼ನ್ ತಿಥ ಹುತ್ತ. ");
INSERT INTO gok_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","ತ್ಯಂಚಾನಿ ಪೇತ್ರ ಯೊಹಾನಾಲಾ ತಿಥ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ಸಗ್‌ಳ್ಯಾ ಲೊಕಾಂಚೆ ಮೊರ‍್ಹ ಉಬಕೇಲ. ಯೆಹುದಿ ಜಾಂತ್ಯಾಂಚಾನಿ ತ್ಯನಾ ತುಮಿ ಹ್ಯಾ ಲಂಗ್‌ಡ್ಯಾಲಾ ಕಸಾ ಬರಾ ಕೆಲಾಸಾ? ತುಮಿ ಕಚ಼ ಬಳ್ ವಾಫರ್ಲ್ಯಾಸಾ? ಹ್ಯ ಕುನಾಚಾ ಅಧಿಕಾರಾನಿ ಕೆಲ್ಯಾಸಾ ಮನ್ಹುನ್ ಖುಬ್ ಪಾವ್ಟಿ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","ತವಾ ಪೇತ್ರಾ ಪವಿತ್ರಾತ್ಮಾನಿ ಬರ‍್ಹುನ್, ತ್ಯನಾ ಲೊಕಾಂಚಾ ಜಾಂತ್ಯಾನು ಆನಿ ಫುಡಾರ‍್ಯಾನು, ");
INSERT INTO gok_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ತ್ಯಾ ಲಂಗ್‌ಡ್ಯಾಲಾ ಜಾ಼ಲ್ಯಾಲ ಚಾ಼ಂಗಲ್ಯಾಚೆ ಗುಶ್ಟಿತ್ ತುಮಿ ಆಮಾನಾ ಪಶ್ನೆ ಇಚಾರ್ಲಸಾತ. ");
INSERT INTO gok_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ತುಮಿ ಶಿಲ್ಬೆವ ಗ್ಯಾತ್‌ಲ್ಯಾಲ್ಯಾ ಆನಿ ದೇವಾನಿ ತ್ಯಲಾ ಮರ್ನಾತ್ನಿ ಉಠಿವಲ್ಯಾಲ್ಯಾ ನಾವಾನಿಸ್ ಹ್ಯೊ ಮಾನುಸ್ ಬಾರಾ ವ್ಹವುನ್ ತುಮ್ಚೆ ಮೊರ‍್ಹ ಉಬಾ ಹಾ ಮನ್ಹುನ್ ತುಮಾನಾ ಆನಿ ಇಸ್ರಾಯಲ್ ಲೊಕಾನಾಬಿ ಹೀ ಗ್ಯೊಸ್ಟ್ ಸಮಜು಼ನಿ! ");
INSERT INTO gok_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11",", “ಘರ್ ಬ್ಯಾಂತ್ಯಾಲ ತುಮಿ ನಕೊ ಮನ್ಹುನ್ ಶೊಡ್‌ಲ್ಯಾಲಾ ದೊಂಢಾ ತ್ಯೊ ತ್ಯೊ ದೊಂಢಾಸ್ ಕೊನ್ಯಾಲಾ ಮುದಮ್ ವ್ಹಯಿ ಜಾ಼ಲ್ಯಾ”. ");
INSERT INTO gok_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","ಸುಟ್ನುಕ್ ಯೇಸುಪ್ನಿ ಸುಡುನ್ ದುಸ್‌ರ‍್ಯಾ ಕುನಾಪ್ನಿಸ್ ಗಾವತ್ ನಾಹಿ ತ್ಯಚಾ ನಾವಾನಿ ಸುಡುನ್ ಆಬ್ಳಾಚೆ ಖಾಲ್ ದರ್ಥಿಚೆ ವರ್ ಮಾನ್ಸಾನಾ ದಿಲ್ಯಾಲ್ಯಾ ದಿಸರ‍್ಯಾ ಕಚಾಸ್ ನಾವಾನಿ ಆಮಾನಾ ಸುಟ್ನುಕ್ ವ್ಹನಾರ್ ನಾಹಿ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","ಹ್ಯನಾ ಕಸ್ಲ ಸಿಕ್ಷನ್ ನವ್ಥ ಮನ್ಹುನ್ ಯೆಹುದಿ ಅಧಿಕಾರ‍್ಯಾನಾ ಠಾವಹುತ್ತ. ಆನಿ ತೇ ಬಿಹ್ಯಾಚೆ ಆಂದಿ ಬೊಲ್‌ತ್ಯಾಲ ಯೆಹುದಿ ಅಧಿಕಾರ‍್ಯಾಂಚಾನಿ ಬಗುನ್ ಖುಬ್ ಆಜಾಬ್ ಜಾ಼ಲ್ಹ ಆನಿ ತೇ ಯೇಸು ಸಂಗ ಹುತ್ತ ಮನ್ಹುನ್ ತ್ಯನಾ ಮಂಗ್ ಸಮಾಜ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","ಹ್ಯಾ ದೊಗಾ ಅಪೊಸ್ತಲಾಂಚೆ ಕಡಸ್ ಉಬಾ ರಾಯ್‌ಲ್ಯಾಲ್ಯಾ ತ್ಯಾ ಲಂಗ್‌ಡ್ಯಾಲಾ ಬಗ್ಲಾ. ತ್ಯಲಾ ಬರ ಜಾ಼ಲ್ಯಾಲ ತ್ಯಂಚಾನಿ ಬಗ್ಲ ಮನ್ಹುನ್ ಅಪೊಸ್ತಲಾಂಚೆ ಬುಲಿಲಾ ಅಡ್ವ ತ್ಯನಾ ಕಾಯ್ ಬೊಲಾಯಾ ವ್ಹಯಿನಾ. ");
INSERT INTO gok_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","ಯೆಹುದಿ ಅಧಿಕಾರಿಂಚಾನಿ ಅಪೊಸ್ತಲಾನಾ ಸಭೆತ್ನಿ ಬಾಹಿರ್ ಲಾವುನ್ ದಿವುನ್, ಆಪ್‌ಲ್ಯಾ ಆಪ್‌ಲ್ಯಾತ್ ಬುಲುನ್ ");
INSERT INTO gok_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","ತೆ, “ಹ್ಯನಾ ಆಮಿ ಕ್ಯಾ ಕರುಯಾ? ಹ್ಯಂಚಾನಿ ಮುಟಿ ಚಮತ್ಕಾರಾಚಿ ಕಾಮ ಕೆಲ್ಯಾಲಿ ಯೆರುಸಲೆಮಿತ್‌ಲ್ಯಾ ಸಗ್‌ಳ್ಯಾನಾ ಠಾವಿ ಹಾತ್ತ. ಹಿ ಕಾಮ ಖರಿ ಹಾತ್ತ ತೀ ಲಬಾಡ್ ಮನ್ಹುನ್ ಸಾಂಗಾಯಾ ವ್ಹಯಿತ್ ನಾಹಿತ. ");
INSERT INTO gok_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","ಫನ್ ಹ್ಯಾ ಮಾನ್ಸಾಚೆ ಗುಶ್ಟಿತ್ ಲೊಕಾನಾ ಸಾಂಗುನಾಹಿ ಆಸ ಆಮಿ ತ್ಯನಾ ಭೆ ಗಾಲಾಯಾ ವ್ಹಯಿ. ತವಾ ಹೀ ಖಬರ್ ಲೊಕಾಂಚೆ ಮದ್ದಿ ಪಗ್ಳತ್ನಾಹಿ” ಮನ್ಹುನ್ ತೇ ಬೊಲ್ಲ ");
INSERT INTO gok_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","ಆನಿ ತ್ಯಂಚಾನಿ ತ್ಯನಾ ಆನಿಕ್ ಆತ್ ಹಾಕ್ಟುನ್, ಯೇಸುಚಾ ನಾವಾನಿ ಕಾಯ್ ಸಾಂಗಾಚ಼ ನಾಹಿ, ಕಾಯ್ ಸಿಕ್ವಾಚ಼ ನಾಹಿ, ಮನ್ಹುನ್ ಖಡ್ಯಾವ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","ತವಾ ತೇ ತ್ಯನಾ, “ತುಮಚ಼ ಐಕಾಚ಼ ಕ್ಯಾ ದೇವಾಚ಼ ಐಕಾಚ಼? ಹ್ಯಾತ್ ದೇವಾಲಾ ವ್ಹಯಿ ಜಾ಼ಲ್ಯಾಲ ಕಚ಼? ತುಮಿಸ್ ಆಮಾನಾ ಸಾಂಗಾ ");
INSERT INTO gok_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","ಆಮಿ ತರಿ ಗಪ್ ರಾನ್ಹಾರ‍್ನಾಹಿ. ಆಮಿ ಬಗ್‌ಲ್ಯಾಲ್ಯಾ ಆನಿ ಐಕ್‌ಲ್ಯಾಲ್ಯಾ ಗುಶ್ಟಿ ಲೊಕಾನಾ ಸಾಂಗಾಚೆಆಂದಿ ರಾನ್ಹಾರ್ನಾಹಿ” ಮನ್ಲ ");
INSERT INTO gok_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","ಯೆಹುದಿ ಅಧಿಕಾರ‍್ಯಾನಾ ಆನಿ ಫುಡಾರ‍್ಯಾನಾ ಜಾಂತ್ಯಾನಾ ಅಪೊಸ್ತಲಾನಾ ದಂಡ್ವಾಯಾ ಕಚಿಸ್ ವಾಟ್ ಸಮಜ಼ನಾ ತವಾ ತ್ಯಂಚಾನಿ ದಪ್‌ಕ್ಯಾವುನ್ ಸುಡುನ್ದಿಲ, ಕಾ ಮಂಜೆ ಜಾ಼ಲ್ಯಾಲೆ ಖನ್ಕತಿಲಾ ಲೊಕ ಸಗ್ಳಿ ದೆವಾಲಾ ವವ್ಯಾಳಿತಿತ ");
INSERT INTO gok_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","ಹ್ಯಾ ಚಮತ್ಕಾರಾಚಾ ಕಾಮಾನಿ ಬರಾ ಜಾ಼ಲ್ಯಾಲ್ಯಾ ಮಾನ್ಸಾಲಾ ಚಾಳ್ಸಾವ್ನಿ ವರ್ ವಯಾ ಜಾ಼ಲ್ಥಿ. ");
INSERT INTO gok_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","ತೇ ಯೆಹುದಿ ಅಧಿಕಾರ‍್ಯಾಂಚೆ ಸಭೆತ್ನಿ ಆಪ್‌ಲ್ಯಾ ಲೊಕಾಂಚಿಪ ಗೆಲ. ಆನಿ ತ್ಯಂಚಾನಿ ಆಪ್‌ಲ್ಯಾನಾ ಸಾಂಗ್‌ಲ್ಯಾಲ ಸಗ್ಳ ಆಪ್‌ಲ್ಯಾ ಸಮುದಾಯಾತ್‌ಲ್ಯಾನಾ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","ಹ್ಯ ಐಕ್‌ಲ್ಯಾಲ್ಯಾ ಇಸ್ವಾಸಿಂಚಾನಿ ಯಕಾ ಮನಾನಿ ಮೊಟ್ಯಾನಿ ದೇವಾಪ ಮಾಗ್ನ ಕೆಲ: ತ್ಯಾ ಸಗ್‌ಳ್ಯಾಂಚಿಪ ಯಾಕುಸ್ ಮನ್ ಹುತ್ತ. “ದನ್ಯಾ ಅಬಾಳ್ ಧರ್ಥಿ ಸಮಿಂದೊರ್ ದುನೆತ್ ಆಸ್‌ಲ್ಯಾಲ ಸಗ್ಳ ಬನಿವ್‌ಲ್ಯಾಲ ತುಸ್. ");
INSERT INTO gok_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","ಆಮಚಾ಼ ವಡಿಲ್ ಜಾ಼ಲ್ಯಾಲಾ ದಾವಿದ್ ತುಜಾ಼ ಸೇವಕ್ ಜಾ಼ಲ್ಥಾ. ತ್ಯನಿ ಪವಿತ್ರಾತ್ಮಾಚೆ ಮಜ಼ತಿನಿ ಹೆ ಸಬಾತ್ ಲಿವ್ಲ: ದುಸ್‍ರ‍್ಯಾ ಲೊಕಾಂಚಾನಿ ಕಾ ರಾಗ್ ಕೆಲಾ? ಲೊಕಾಂಚಾನಿ ಉಪೇಗ್ ನಸ್‌ಲ್ಯಾಲ್ಯಾ ಕಾಮಾಂಚಿ ಯವಜ್ನಾ಼ ಕಾ ಕಿಲಿ? ");
INSERT INTO gok_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","ಪ್ರಭುಲಾ ಆನಿ ತ್ಯನಿ ಅಬಿಸೆಕ್ ಕೆಲ್ಯಾಲ್ಯಾ ಕ್ರಿಸ್ತಾಲಾ ಅಡ್ವ ವ್ಹವುನ್ ಉಟ್ನಾರ್ ದರ್ಥಿವ್ಲ ರಾಜ಼ ಸಗ್ಳ ಲಡಾಯಿಕರಾಯಾ ತಯಾರ್ ಜಾ಼ಲ್ಯಾತ ಅಧಿಕಾರಿ ಸಗ್ಳ ಯೆಕ್ ಜಾ಼ಲ್ಹ ಮನ್ಹುನ್ ಸಾಂಗಾಯಾ ಲ್ಯಾವ್ಲಸ್? ");
INSERT INTO gok_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","ಖರ‍್ಯಾನಿ ತಸಸ್ ಹೆರೊದ್ ರಾಜಾ಼ ಪೊಂತಿಪಿಲಾತ್, ಯೆಹುದಿ ನಸ್‌ಲ್ಯಾಲಿ ಲೊಕ ಆನಿ ಇಸ್ರಾಯಲಾತ್ಲಿ ಹೇ ಪೆಠತ್ ಯೆಕ್ ವ್ಹವುನ್ ಯೇಸುಲಾ ಇರೊದ್ ಕೆಲಾ. ತುಜಾ಼ ಪವಿತ್ರ ಸೇವಕ್ ಜಾ಼ಲ್ಯಾಲ್ಯಾ ಯೇಸು ಕ್ರಿಸ್ತಲಾ ತು ಅಭಿಶೇಕ್ ಕೆಲ್ಯಾಸ್. ");
INSERT INTO gok_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","ಯೇಸುಲಾ ಅಡ್ವಿ ಯೆಕ್ ವ್ಹವುನ್ ಆಲ್ಯಾಲ್ಯಾ ಹ್ಯಾ ಲೊಕಾಂಚಾನಿ ತುಜಿ ಯವಜ್ನಾ ಪುರಿ ಕಿಲಿ. ತುಜಾ ಬಳಾನಿ ತುಜಾ ಮನಾನಿ ಹ್ಯ ಜಾ಼ಲ್ಹ. ");
INSERT INTO gok_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","ಪ್ರಭು, ತೇ ಭೆ ಗ್ಯಾಲತ್ಯಾಲ್ಯಾವ್ನಿ ತುಸ್ ಧ್ಯಾನ್ ದೆ. ತಿ ಆಮಾನಾ ಭೆ ಗಾಲಾಯಾ ಖಟ್ಪಟ್ ಕರ್ತ್ಯಾತ! ಪ್ರಭು ಆಮಿ ತುಜ಼ ಸೇವಕ್. ತುಜಿ ವಚ಼ನ ಭೆ ನಸ್ಥಾನಾ ಸಾಂಗಾಯಾ ಆಮಾನಾ ಮಜ಼ತ್ ಕರ್. ");
INSERT INTO gok_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","ತುಜ಼ ಹಾತ್ ಪಗಳುನ್ ಪವಿತ್ರ ಯೇಸುಚಾ ನಾವಾನಿ ರೊಗಿನಾ ಬರ ಕರ್; ಚಮತ್ಕಾರಾಚಿ ಕಾಮ ಅದ್ಬುತಾಚಿ ಕಾಮ ಕರ್” ಮನ್ಹುನ್ ತ್ಯಂಚಾನಿ ಮಾಗ್ನ ಕೇಲ. ");
INSERT INTO gok_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","ತವಾಸ್, ಮಂಡಳಿ ಜ಼ಮಲ್ಯಾಲಾ ಜಾ಼ಗಾ ಹಲ್ಲಾ, ತ್ಯಂಚಿವ ಸಗ್‌ಳ್ಯಾಂಚಿವ ಪವಿತ್ರಾತ್ಮ ಆಲ ಆನಿ ದೇವಾಚ಼ ಸಬ್ದ ಭೆ ನಸ್ಥಾನಾ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","ಸಗ್‌ಳ್ಯಾ ಇಸ್ವಾಸಿಂಚ಼ ಮನ್ ಆನಿ ಜೀವ್ ಯೆಕುಸ್ ಜಾ಼ಲ್ಥಾ. ಸಮುದಾಯಾತ್ಲಾ ಕೊನುಸ್ ಆಪಲ್ಯಾ ಮ್ಹಾಲ್ಮಾತ್ಯಾತ್ಲ ಆಪ್ಲ ಮನ್ಹಿತ್ ನವ್ಥ. ತ್ಯ ಸಗ್ಳಿಜ಼ನ ವಾಟುನ್ ಗಿಹಿತಿತ. ");
INSERT INTO gok_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","ಪ್ರಭು ಜಾ಼ಲ್ಯಾಲಾ ಯೇಸು ಖರ‍್ಯಾನಿ ಮೇಲ್ಯಾಲ್ಯಾತ್ನಿ ಜಿತ್ತಾ ವ್ಹವುನ್ ಉಠುನ್ ಆಲ್ಯಾ ಮನ್ಹುನ್ ಅಪೊಸ್ತಲ್ ಖಾಯಿಮ್ ಖುಬ್ ಧಿರಾನಿ ಲೊಕಾನಾ ಸಾಕ್ಷಿ ಸಾಂಗಿತ. ದೇವಾಚೆ ಕ್ರಪೆನಿ ತ್ಯಂಚಿಪ ಮೊಟ ಕಾಮ್ ಕೇಲ. ");
INSERT INTO gok_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","ತ್ಯಾತಲ್ಯಾ ಕುನಾಲಾ ಕಾಯ್ ಕಮ್ಮಿ ನವ್ತ ಕಾ ಮಂಜೆ ಘರ ಜಿಮಿನ್ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ಪರತೇಕಾನಿ ತೀ ಇಕುನ್, ಪೈಸ ಆನಿತ ");
INSERT INTO gok_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ತೇ ಅಪೊಸ್ತಲಾಂಚಿಪ ದಿಯಿತಿತ ಮಂಗ್ ತೇ ಸಗ್ಳ ಗರಜ಼್ ಆಸ್‌ಲ್ಯಾನಾ ವಾಟುನ್ ದಿಯಿತಿತ. ");
INSERT INTO gok_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","ತ್ಯಾ ಇಸ್ವಾಸಿತ್ನಿ ಯೊಸೆಪ್ ಮಂಥ್ಯಾಲಾ ಹುತ್ತಾ. ಅಪೊಸ್ತಲ್ ತ್ಯಲಾ ಬಾರ್ನಬಾ ಮನ್ಹುನ್ ಹಾಕ್ಟಿತ ಬಾರ್ನಬಾ ಮಂಜೆ “ಉಮೇದಿಚಾ಼ ಲ್ಯೊಕ್’. ಕ್ರುಪ್ ದ್ವಿಪಾತ್ ಜ಼ಲಾಮ್‌ಲ್ಯಾಲಾ ಹ್ಯೊ ಲೇವಿ ಜಾ಼ಲ್ಥಾ. ");
INSERT INTO gok_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","ಯೊಸೆಫಾಲಾ ಯಾಕ್ ಶಾತ್ ಹುತ್ತ. ತ್ಯನಿ ತ್ಯ ಈಕುನ್ ಆಲ್ಯಾಲ ಪೈಸ ಅಪೊಸ್ತಲಾಂಚಿಪ ಆನುನ್ ದಿಲ. ");
INSERT INTO gok_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","ಅನನಿಯಾ ಮಂತ್ಯಾಲಾ ಯೊಕ್ ಮಾನುಸ್ ಹುತ್ತಾ. ತ್ಯಚೆ ಬ್ಯಾಯ್ಕೊಚ಼ ನಾವ್ ಸಪೈರಾ. ಅನನಿಯಾನಿ ಆಪ್ಲಿಪ ಆಸಲ್ಯಾಲಿ ಥುಡಿ ಜಿಮಿನ್ ಇಕ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","ಫನ್ ಆಲ್ಯಾಲ್ಯಾ ಪೈಶಾತ್ಲ ಥೊಡ ತ್ಯವ್ಡಸ್ ಅಪೊಸ್ತಲಾಂಚಿಪ ದಿಲ. ಆನಿ ಥೊಡ ಆಪಲ್ಯಾಲಾ ಚು಼ರುನ್ ಥಿವುನ್ ಗೆತ್ಲ. ಹ್ಯ ತ್ಯಚೆ ಬ್ಯಾಯ್ಕೊಲಾ ಠಾವ ಹುತ್ತ. ತಿಬಿ ತ್ಯಲಾ ಹು ಮನ್ಲಿಹುತ್ತಿ. ");
INSERT INTO gok_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","ಪೆತ್ರಾನಿ, “ಅನನಿಯಾ ತುಜ಼ ಮನ್ ಸೈತಾನಾಚಾ ತಾಬ್ಯಾತ್ ಕಾ ದಿಲಸ್? ತು ಲಬಾಡ್ ಸಾಂಗುನ್, ಪವಿತ್ರಾತ್ಮಾಲಾ ಫಸ್ವಾಯಾ ಬಗ್ಲಸ್. ತು ತುಜ಼ ಶಾತ್ ಇಕ್ಲಸ್, ಆನಿ ಆಲ್ಯಾಲ್ಯಾ ಪೈಶಾತ್ಲ ಥೊಡ ತುಲಾ ಚ಼ುರುನ್ ಕಾ ಥೆವ್ಲಸ್? ");
INSERT INTO gok_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","ತು ಶಾತ್ ಇಕಾಚೆ ಆಂದಿ ತ್ಯ ತುಜ಼ಸ್ ಹುತ್ತ. ಇಕ್‌ಲ್ಯಾ ನಂತರ್ ತೇ ಪೈಸ ತುಜ಼ಸ್ ಹುತ್ತ. ಹ್ಯ ಬುರ್ಸ ಕಾಮ್ ಕರಾಯಾ ತು ಕಾ ಯವಜ಼್ಲಸ್? ತು ಲಬಾಡ್ ಸಾಂಗ್‌ಲ್ಯಾಲ ದೇವಾಲಾ, ಮನ್ಸಾನಾ ನವ್ಹ!” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","ಅನನಿಯಾನಿ ಹ್ಯ ಐಕ್‌ಲ್ಯಾ ಬರ್ಬರ್ ಖಾಲ್ ಪಡ್ಲಾ ಆನಿ ಜೀವ್ ಶೊಡ್ಲಾ. ತ್ಯ ಬಗ್‌ಲ್ಯಾಲಿ ಲೊಕ ಖುಬ್ ಬಿಹ್ಯಾಲಿತ. ");
INSERT INTO gok_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","ಥೊಡ್ಯಾ ಪ್ಯೊರ್ಗ್ಯಾಂಚಾನಿ ಯವುನ್ ತ್ಯಚ಼ ಮಡ ಕಪಡ್ಯಾತ್ ಗುಂಡ್ಯಾಳ. ತ್ಯಂಚಾನಿ ತ್ಯ ನಿಹುನ್ ಪುರ್ಲ. ಹ್ಯ ಐಕ್‌ಲ್ಯಾಲಿ ಸಗ್ಳಿ ಬಿಹ್ಯಾಲಿತ. ");
INSERT INTO gok_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","ಜ಼ವ ಜ಼ವಳ್ ತೀನ್ ತಾಸ್ ಜಾ಼ಲ್ಯಾ ನಂತರ್ ತ್ಯಚಿ ಬ್ಯಾಯ್ಕೊ ಸಫೆರಾ ಆತ್ ಆಲಿ. ಜಾ಼ಲ್ಯಾಲಿ ಖನ್ಕತ್ ಸಪೇರ್ಲಾ ಠಾವಿನವ್ಥಿ. ");
INSERT INTO gok_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","ಪೇತ್ರಾ ತಿಲಾ, “ಖರ‍್ಯಾನಿಸ್ ತುಮ್ಚಿ ಜಿಮಿನ್ ಇಕುನ್ ಆಲ್ಯಾಲ ಪೈಸ ಯವ್ಡಸ್ ಕ್ಯಾ? ಮನಾ ಸಾಂಗ್” ಮನ್ಲಾ. ಸಪೇರಾ, “ವ್ಹಯ್!” ಮನ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","ತವಾ ಪೇತ್ರಾ ತಿಲಾ, “ತು ಆನಿ ತುಜಾ ದನ್ಗಾರಾನಿ ದೇವಾಚಾ ಆತ್‌ಮ್ಯಾಚಿ ಪಾರಕ್ ಕಿಲಿಸಾ ಕಾ? ಥಬ, ತುಜಾ ಗ್ವಾಲಾ ಪುರಾಯಾ ಗೆಲ್ಯಾಲ ಗಡಿ ದಾರಾಪ ಆಲ್ಯಾತ! ತೇ ತುಲಾಬಿ ತಸಸ್ ಗಿಹುನ್ ಜಾ಼ನಾರ್” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","ತವಾಸ್ ಸಪೇರಾ ತ್ಯಚಾ ಪಾಯಾಪ ಪಡ್ಲಿ ಆನಿ ಮಿಲಿ. ತ್ಯಾ ಪ್ಯೊರ್ಗ್ಯಾಂಚಾನಿ ಆತ್ ಯವುನ್ ಬಗ್ಲ ತವಾ ತೀ ಮಿಲ್ತಿ. ತ್ಯಂಚಾನಿ ತಿಲಾ ನಿಹುನ್ ತಿಚಾ ಘ್ವಾಚೆ ಕಡಸ್ ಪುರ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","ಹ್ಯಾ ಗುಶ್ಟಿ ಐಕ್‌ಲ್ಯಾಲಿ ಇಸ್ವಾಸಿ ಲೊಕ ಸಗ್ಳಿ ಬಿಹ್ಯಾಲಿತ. ");
INSERT INTO gok_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","ಅಪೊಸ್ತಲಾಂಚಾನಿ ಖುಬ್ ಚಮತ್ಕಾರಾಚಿ ಕಾಮ ಆನಿ ಅದ್ಬುತ್‍ ಕಾಮ ಕಿಲಿತ. ಲೊಕಾಂಚಾನಿ ತೀ ಕಾಮ ಸಗ್ಳಿ ಬಗ್ಲಿತ. ತೀ ಸಗ್ಳಿ ಯೇಕ ವ್ಹವುನ್ ಸಲೊಮೊನಾಚಾ ಮಾಂಡ್ವಾತ್ ರಾಹಿತಿತ. ");
INSERT INTO gok_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","ತ್ಯಂಚಿ ಸಂಗ ಉಬರಾಹ್ಯಾ ಆಪ್‌ಲ್ಯಾಲಾಬಿ ಯೊಗ್ಯತೆ ಹಾ ಮನ್ಹುನ್ ದಿಸರ‍್ಯಾ ಕುನಾಲಾ ವಾಟ್ಲನಾಹಿ. ಬಾಹಿರ್ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ಲೊಕಾನಾ ಅಪೊಸ್ತಲಾಂಚೆ ಗುಶ್ಟಿತ್ ಬೊಲಾಯಾ ಕುನಾಲಸ್ ಧೀರ್ ನವ್ಥಾ ಕಾ ಮಂಜೆ ಲೊಕ ತ್ಯಾ ಅಪೊಸ್ತಲಾಂಚೆ ಗುಶ್ಟಿತ್ ಖುಬ್ ಚಾ಼ಂಗ್ಲ ಸಾಂಗಿತಿತ. ");
INSERT INTO gok_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","ಫನ್ ಖುಬ್ ಲೊಕಾಂಚಾನಿ ಪ್ರಭುವ ಇಸ್ವಾಸ್ ಥೆವ್ಲಾ. ಬಾಯಿಲ್ ಮಾನುಸ್ ಆನಿ ಗಡಿಮಾನುಸ್ ಖುಬ್ ಜಾ಼ನ್ ಇಸ್ವಾಸಿಂಚಾ ಮೆಳ್ಯಾತ್ ಬರ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","ತವಾ ಪೇತ್ರಾ ವಾಟನಿ ಜಾ಼ತ್ಯಾಲಿ ಖಬರ್ ಐಕ್‌ಲ್ಯಾಲ್ಯಾ ಲೊಕಾಂಚಾನಿ ರೊಗಾತ್ ಆಸ್‌ಲ್ಯಾಲ್ಯಾನಾ ಹಾತ್ರುನಾಸಾಹಿತ್ ಉಚ಼್ಲುನ್ ನಿಹುನ್ ವಾಟವ ನಿಜ್ವಿತಿತ ಪೇತ್ರಾಚ಼ ಸಾವುಟ್ ಪಡ್ಲ ಪುರೊ. ");
INSERT INTO gok_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","ಯೆರುಸಲೆಮಿಚೆ ಸರ್ಬೌತಚಾ ಸಗ್‌ಳ್ಯಾ ಗಾವಾತ್ಲಿ ಲೊಕ ಹಿಂಡಾ ಹಿಂಡಾನಿ ಯಯಿತಿತ. ತೀ ರೊಗಾತ್ ಆಸ್‌ಲ್ಯಾಲ್ಯಾನಾ ಲಾಗಿರ್ ಲಾಗ್‌ಲ್ಯಾಲ್ಯಾನಾ ಉಚ಼್ಲುನ್ ಆನಿತಿತ. ಹ್ಯನಾ ಸಗ್‌ಳ್ಯಾನಾ ಬರ ವ್ಹಯಿತ. ");
INSERT INTO gok_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","ಮುಖ್ಯಾ ಯಾಜಕಾನಾ ತ್ಯಂಚೆ ಸಂಗಚಾ ಸದ್ದುಕಾಯಾಂಚಾ ಮೆಳ್ಯಾತಲ್ಯಾನಾ ಖುಬ್ ಬೇಜಾರ್ ಜಾ಼ಲ್ಹಾ. ");
INSERT INTO gok_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","ತ್ಯಂಚಾನಿ ಅಪೊಸ್ತಲಾನಾ ದರ್ಹುನ್ ಸಾದ್ಯಾ ತುರುಂಗಾತ್ ಗ್ಯಾತ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","ಫನ್ ರ‍್ಯಾಚಾ಼ ಪ್ರಭುಚಾ ಯಕಾ ದುತಾನಿ ತುರುಂಗಾಚಿ ದಾರ ಉಗಡ್ಲಿತ ದೇವ್ ದುತಾನಿ ಅಪೊಸ್ತಲಾನಾ ಹಾಕ್ಟುನ್ ಬಾಹಿರ್ ಆನುನ್ ತ್ಯನಾ, ");
INSERT INTO gok_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“ಜಾ಼ವುನ್ ದೇವ್ಳಾತ್ ಉಬ ರಾವ್ಹಾ. ನವ್ಯಾ ಜೀವ್ನಾಚೆ ಗುಶ್ಟಿತ್ ಪರತೇಕ್ ಯಾಕ್ ಲೊಕಾನಾ ಸಾಂಗಾ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","ತಸಸ್ ತೆ ದುಸ್ರೆ ದಿಸಿ ಸಕಾಳ್ಚ಼ ದೇವ್ಳಾತ್ ಜಾ಼ವುನ್ ಸಿಕ್ವಾಯಾ ಲಾಗ್ಲ ಮುಖ್ಯ ಯಾಜಕ್ ಆನಿ ತ್ಯಚ಼ ಸುಪ್ತಿ ದೇವ್ಳಾತ್ ಆಲ. ತ್ಯಂಚಾನಿ ಯೆಹುದಿ ಅಧಿಕಾರಿಂಚ಼ ಆನಿ ಇಸ್ರಾಯಲಾಚಾ ಜಾಂತ್ಯಾಚಾ಼ ಮೇಳಾ ಮಿಳಿವ್ಲಾ. ಮಂಗ್ ಅಪೊಸ್ತಲಾನಾ ಆಪ್ಲಿಪ ಹಾಕ್ಟಾಯಾ ಥೊಡ್ಯಾನಾ ತುರುಂಗಾತ್ ಲಾವುನ್ ದಿಲ. ");
INSERT INTO gok_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","ಸೇವಕ್ ತುರುಂಗಾಪ ಗೇಲ ತವಾ ತಿಥ ಅಪೊಸ್ತಲ್ ದಿಸ್ಲ ನಾಹಿತ ಮನ್ಹುನ್ ತೇ ಮಾಗಾರ್ ಯವುನ್ ನ್ಯಾಯಿಚೆ ಮೆಳ್ಯಾಲಾ ಸಾಂಗಿತ್, ");
INSERT INTO gok_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“ತುರುಂಗಾಚ಼ ದಾರ್ ಲಾವುನ್ ಕುಲುಪ್ ಗ್ಯಾತ್ಲ ಹುತ್ತ ಆನಿ ಸೇವಕ್ ದಾರಾಪ ಉಬ ಹುತ್ತ. ಫನ್ ಆಮಿ ದಾರ ಉಗಡ್ಲಿತ ತವಾ ತುರಂಗಾತ್ ಕೊನ್ ನವ್ಥ!” ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","ದೇವ್ಳಾಚಾ ಸೇವಕಾಂಚಾ಼ ದಳಪತಿ ಆನಿ ಮುಖ್ಯ ಯಾಜಕಾಂಚಾನಿ ಹ್ಯ ಐಕುನ್ ಅಪೊಸ್ತಲಾಂಚೆ ಸಂಗ ಕ್ಯಾ ಜಾ಼ಲ್ಹ ಆಸಲ್ ಮನ್ಹುನ್ ಗಾಭಾರ್ಲ. ಹ್ಯನಿ ಕ್ಯಾ ವ್ಹತ್ಯಾ ಕುನಾನ್ಠಾವ ಮನ್ಹುನ್ ಬಿಹ್ಯಾಲ. ");
INSERT INTO gok_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","ಮಂಗ್ ದುಸ್‌ರ‍್ಯಾ ಯಕಾನಿ ಯವುನ್, “! ತುಮಿ ತುರುಂಗಾತ್ ಗ್ಯಾತ್‌ಲ್ಯಾಲ ಮಾನುಸ್ ದೇವ್ಳಾಚಾ ಅಂಗ್ನಾತ್ ಉಬ ಹಾತ್ತ ತೇ ಲೊಕಾನಾ ಸಿಕಿವ್‌ತ್ಯಾತ!” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ ");
INSERT INTO gok_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","ತವಾ ದಳಪತಿನಿ ಆನಿ ತ್ಯಚಾ ಮಾನ್ಸಾಂಚಾನಿ ಜಾ಼ವುನ್ ಅಪೊಸ್ತಲಾನಾ ಮಾಗಾರ ಹಾಕ್ಟುನ್ ಆನ್ಲ. ಫನ್ ತ್ಯಂಚಾನಿ ಬಳ್ ಕೇಲ ನಾಹಿ. ಕಾ ಮಂಜೆ ಲೊಕ ರಾಗಾನಿ ದೊಂಢ ಗಿಹುನ್ ಆಪ್‌ಲ್ಯಾಲಾ ಮ್ಯಾರ್ತಿಲ ಮನ್ಹುನ್ ತೇ ಬಿಹ್ಯಾಲ. ");
INSERT INTO gok_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","ತೇ ಅಪೊಸ್ತಲಾನಾ ನ್ಯಾಯಿಚಾ ಮೆಳ್ಯಾತ್ ಹಾಕ್ಟುನ್ ಆನುನ್ ಯೆಹುದಿ ಅಧಿಕಾರಿಂಚೆ ಮೊರ‍್ಹ ಉಬಕೆಲ ಮಹಾ ಯಾಜಕಾನಿ ಅಪೊಸ್ತಲಾನಾ, ");
INSERT INTO gok_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“ತ್ಯಚೆ ಗುಶ್ಟಿತ್ ತುಮಿ ಸಿಕ್ವಾಚ಼ನಾಹಿ ಮನ್ಹುನ್ ಆಮಿ ತುಮಾನಾ ಖಡ್ಯಾವ್ಲ ಹುತ್ತ. ಫನ್ ತುಮಿ ಕೆಲ್ಯಾಲ ಕ್ಯಾ? ತುಮಿ ಯೆರುಸಲೇಮ್ ತುಮ್ಚಾ ಸಿಕ್ಷನಾನಿ ಬರಿವ್ಲಿಸಾ ತ್ಯಾ ಮಾನ್ಸಾಚಾ ಮರ್ನಾಲಾ ಆಮಿಸ್ ಕಾರನ್ ಮನ್ಹುನ್ ಕರಾಯಾ ತುಮಿ ಖಟ್ಪತ್ ಕರ್ತ್ಯಾಸಾ” ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","ಪೇತ್ರಾ ಆನಿ ರಾಯ್‌ಲ್ಯಾಲ ಅಪೊಸ್ತಲ್, “ಆಮಿ ಐಕಾಯಾ ವ್ಹಯಿ ಜಾ಼ಲ್ಯಾಲ ದೇವಾಚ಼ ಮಾನ್ಸಾಚ಼ ನವ್ಹ! ");
INSERT INTO gok_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","ತುಮಿ ಯೆಸುಲಾ ಮಾರುನ್ ಟ್ಯಾಕ್ಲಾಸಾ ತುಮಿ ತ್ಯಲಾ ಶಿಲ್ಬೆವ ಟಾಂಗುನ್ ಮಾರುನ್ ಟ್ಯಾಕ್ಲಾಸಾ. ಫನ್ ದೇವಾನಿ, ಮಂಜೆ ಆಮ್ಚಾ ವಡ್ಲಾಂಚಾ ದೇವಾನಿ ತ್ಯಲಾ ಮರ್ನಾತ್ನಿ ಜಿತ್ತಾ ಕರುನ್ ಉಠಿವ್ಲಾ! ");
INSERT INTO gok_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","ದೇವಾಚೆ ಉಜ್‌ವ್ಯಾಂಗ್ನಿ ಬಸ್‌ಲ್ಯಾಲಾ ಯೇಸುಸ್. ಸಗ್‌ಳ್ಯಾ ಇಸ್ರಾಯಲಾಂಚಾನಿ ಆಪ್‌ಲ್ಯಾ ಪಾಪಾಂಚೆ ಸಾಟಿ ದೇವಾಕ್ಡ ಪರ್ತುನ್ ಪಾಪಾಂಚಾ಼ ಮಾಪ್ ಕರಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ದೇವಾನಿ ತ್ಯಲಾ ಆಮ್‌ಚಾ಼ ಅದಿಪತಿ ಆನಿ ರ‍್ಯಾಕ್‌ತ್ಯಾಲಾ ಕೆಲ್ಯಾ ");
INSERT INTO gok_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","ಹೇ ಗುಶ್ಟಿಲಾ ಆಮಿಸ್ ಸಾಕ್ಷಿ , ಆಪ್ಲ ಐಕ್‌ತ್ಯಾಲ್ಯಾ ಸಗ್‌ಳ್ಯಾ ಲೊಕಾನಾ ದೇವಾನಿ ದಿಲ್ಯಾಲ ಪವಿತ್ರಾತ್ಮ ಸಾಕ್ಷಿ ಹಾ” ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","ಯೆಹುದಿ ಜಾಂತ್ಯಾಂಚಾನಿ ಹ್ಯಾ ಬೊಲ್ಯಾ ಐಕುನ್ ಚ಼ೌತಾಳುನ್ ರಾಗಾನಿ ಅಪೊಸ್ತಲಾನಾ ಮಾರುನ್ ಟಾಕಾಯಾ ವ್ಹಯಿ ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","ತವಾ ಪರಿಸಾಯಾತ್ಲಾ ಯೊಕ್ ನ್ಯಾಯಿಚಾ ಮೆಳ್ಯಾತ್ ಉಠುನ್ ಉಬಾ ರಾಯ್ಲಾ: ತ್ಯಚ಼ ನಾವ್ ಗಮಲಿಯಲ್ ತ್ಯೊ ದರ್ಮೊಪದೆಶಕ್ ಹುತ್ತಾ. ಆನಿ ಲೊಕ ಸಗ್ಳಿ ತ್ಯಲಾ ಮರ‍್ಯಾದ್ ದಿಯಿತಿತ. ಥೊಡ್ಯಾ ಯಳಾಲಾ ಅಪೊಸ್ತಲಾನಾ ಸಭೆತ್ನಿ ಬಾಹಿರ್ ಗಾಲ್ಹಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ತ್ಯನಿ ಲೊಕಾನಾ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","ನಂತರ್ ತ್ಯೊ ನ್ಯಾಯಿಚಾ ಮೆಳ್ಯಾಲಾ, “ಇಸ್ರಾಯೆಲ್ ಲೊಕಾನಾ ತುಮಿ ಹ್ಯನಾ ಕರಾಯಾ ವ್ಹಯಿ ಮಂಥ್ಯಾಲೆ ಗುಸ್ಟಿತ್ ಹುಶಾರಿನಿ ರಾವ್ಹಾ. ");
INSERT INTO gok_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","ಯಂಗ್ದಾ ಥೈದಾ ಮಂಥ್ಯಾಲಾ ಆಲ್ಯಾಲಾ ತುಮ್ಚೆ ಯದತ್ ಹಾ ಕ್ಯಾ? ತ್ಯೊ ಆಪ್ನಿ ಯೊಕ್ ಮೊಟಾ ಮಾನುಸ್ ಮನ್ಹುನ್ ಸಾಂಗ್ತೊ. ಜ಼ವಜ಼ವಳ್ ಚಾರ್ಸೆ ಲೊಕ ತ್ಯಚಿಪ ಜ಼ಮ್ಲಿತ. ಫನ್ ತ್ಯಲಾ ಮಾರುನ್ ಟ್ಯಾಕ್ಲಾ. ತ್ಯಚೆ ಮಾಗ್ನಿ ಜಾ಼ತ್ಯಾಲಿ ಸಗ್ಳಿ ಪಗ್ಳುನ್ ಪಳುನ್ ಗಿಲಿತ. ತ್ಯಂಚೆ ಹಾತ್ನಿ ಕಾಯಿಸ್ ಕರಾಯಾ ಜಾ಼ಲ್ಹನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","ನಂತರ್ ಯುದ್ ಮಂಥ್ಯಾಲಾ ಗಲಿಲಾಯಾತ್ನಿ ಆಲಾ, ತ್ಯೊ ಲೊಕಾಂಚಾ಼ ಗಿಂತಿಚಾ಼ ಕಾಲ್ ಜ಼ಾಲ್ಥಾ. ತ್ಯನಿ ಲೊಕಾನಾ ಬುಲುವುನ್ ಯೊಕ್ ತಂಡಾ ಕೆಲಾಹುತ್ತಾ. ತ್ಯೊಬಿ ಮೆಲಾ ಆನಿ ತ್ಯಚಿವ ಬೊಲ್ಯಾಲಿ ಸಗ್ಳಿ ಪಗಳುನ್ ಗಿಲಿತ. ");
INSERT INTO gok_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","ಮನ್ಹುನ್ ಆತಾ ಮಿ ತುಮಾನಾ ಸಾಂಗಾಚ಼ ಕ್ಯಾ ಮಂಜೆ ಹ್ಯಾ ಲೊಕಾಪ್ನಿ ದುರ್ ರಾವ್ಹಾ. ತ್ಯನಾ ಸುಡು‍ನ್ ದೇವಾ ತ್ಯಂಚಿ ಯವಜ್ನಾ಼ ಮಾನ್ಸಾಪ್ನಿ ಆಲ್ಯಾಲಿ ಆಸ್ಲಿತ ತೀ ನಾಸ್ ವ್ಹನಾರ್. ");
INSERT INTO gok_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","ಫನ್ ತ್ಯ ದೇವಾಪ್ನಿ ಆಲ್ಯಾಲ ಆಸ್ಲತ ತುಮಿ ತ್ಯನಾ ಥಾಂಬ್ವಾಯಾ ವ್ಹನಾರ್ನಾಹಿ ತುಮಿ ದೇವಾಲಾ ಆಡ್ವ ವ್ಹವುನ್ ಲಡಾಯಿ ಕೆಲ್ಯಾಚೆಗತ್ ವ್ಹನಾರ್!” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ಗಮಲಿಯೆಲಾಚೆ ಬುಲಿಲಾ ಯೆಹುದಿ ಜಾಂತ ವ್ಹಯ್ ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","ತ್ಯಂಚಾನಿ ಅಪೊಸ್ತಲಾನಾ ಆತ್ ಹಾಕ್ಟುನ್ ಮಾರಾಯಾ ಲಾವುನ್ ಯೇಸುಚೆ ಗುಶ್ಟಿತ್ ಲೊಕಾನಾ ಸಾಂಗಾಚ಼ ನಾಹಿ ಮನ್ಹುನ್ ತಾಕಿತ್ ಕರುನ್ ಲಾವುನ್ದಿಲ. ");
INSERT INTO gok_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","ಅಪೊಸ್ತಲ್ ಮಂಡಳಿತ್ನಿ ಗೆಲ. ಯೇಸುಚಾ ನಾವಾನಿ ಅವ್ಮಾನ್ಗಿಹ್ಯಾ ಥರಲ್ಯಾಲ. ಮನ್ಹುನ್ ತೇ ಆನಂದ್ ಜಾ಼ಲ್ಹ. ");
INSERT INTO gok_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","ತ್ಯಂಚಾನಿ ಲೊಕಾನಾ ಉಪದೇಶ್ ಕಾರಾಚ಼ ಥಾಂಬಿವ್ಲ ನಾಹಿ ಯೇಸು ಕ್ರಿಸ್ತ ಮಂಥ್ಯಾಲಿ ಚಾ಼ಂಗ್ಲಿ ಖಬರ್ ಲೊಕಾನಾ ಸಾಂಗಾಚ಼ ಚಾ಼ಲುಕೆಲ ತೆ ಪರತೆಕ್ ದಿಸಿ ದೇವ್ಳಾತ್ಬಿ ಲೊಕಾಂಚಾ ಗರ‍್ಹಾತ್ನಿತ್ಬಿ ಸಿಕ್ವಿತ ಆನಿ ಉಪದೇಶ್ ಕರಿತ. ");
INSERT INTO gok_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","ತೇ ದಿಸಿ ಶಿಶಾಂಚಿ ಮಂಡಳಿ ಬಳಕಾಟ್ಲಿ ಹುತ್ತಿ ತವಾ ತ್ಯಂಚಾತ್ ಗ್ರೀಕ್ ಬಾಶೆ ಬೊಲ್‌ತ್ಯಾಲ ಯೆಹುದಿ ಇಬ್ರಿಯಾ ಬಾಶೆ ಬೊಲ್‌ತ್ಯಾಲ್ಯಾ ಯೆಹುದ್ಯಾಂಚೆ ಗುಶ್ಟಿತ್ ಸಾಂಗ್ಲ ಖಾಯಿಮ್ ವಾಟ್ನಿ ಕರ್ತಾನಾ ಆಮ್ಚಾ ವಿದವೆನಾ ಶಾರ್ಕಿ ವಾಟ್ನಿ ಗಾವತ್ನಾಹಿ ಮನ್ಹುನ್ ತ್ಯಂಚೆ ಗುಶ್ಟಿತ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","ತವಾ ಬಾರಾ ಜಾ಼ನ್ ಅಪೊಸ್ತಲಾಂಚಾನಿ ಸಗಳ್ಯಾ ಶಿಶಾನಾ ಯಕಿಕ್ಡ ಹಾಕ್ಟುನ್, ಆಮಿ ದೆವಾಚ಼ ವಾಕ್ಯಾ ಸಾಂಗಾಚ಼ ಸುಡುನ್ ಖಾನ್ಯಾ ಪಿನ್ಯಾಚಿ ಸೆವಾ ಕರಾಚಿ ಬರ ನವ್ಹ. ");
INSERT INTO gok_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","ಮನ್ಹುನ್ ಭನ್ಹಿ ಬಾವ್ಹಾನು ತುಮ್ಚಾತ್ಲಿ ಸಾತಜ಼ನ ಚಾ಼ಂಗಲ್ಯಾನಾ ನಿವ್ಡಾ ತಿ ಲೊಕಾಪ್ನಿ ಚಾ಼ಂಗ್ಲಿ ಮನ್ಹುನ್ ಗೆಥ್ಯಾಲಿ ರಾಹ್ಯಾ ವ್ಹಯಿತ, ಸಗ್ಳ ಗಿನ್ಯಾನ್ ಆಸ್‌ಲ್ಯಾಲಿ ರಾಹ್ಯಾ ವ್ಹಯಿತ ಆನಿ ಪವಿತ್ರಾತ್ಮಾನಿ ಬರ್‌ಲ್ಯಾಲಿ ರಾಹ್ಯಾ ವ್ಹಯಿತ ಆಮಿ ತ್ಯನಾ ಹ್ಯಾ ಕಾಮಾಸಾಟಿ ಥರಿವ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","ತವಾ ಆಮಿ ಸಗ್ಳ ಮಾಗ್ನ ಕರಿತ್ ದೇವಾಚ಼ ವಾಕ್ಯಾ ಸಾಂಗಿತ್ ರಾನ್ಹಾರ್ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","ಸಗ್ಳೆ ಸಮುದಾಯಾಲಾ ತೀ ಯವಜ್ನಾ಼ ಆವಾಡ್ಲಿ ಹುತ್ತಿ ಮನ್ಹುನ್ ತ್ಯಂಚಾನಿ ಹ್ಯಾ ಸಾತ್ ಜ಼ನಾನಾ ನಿವಡ್‌ಲ್ಯಾಲ ಮೊಟಾ ಇಸ್ವಾಸ್ ಆನಿ ಪವಿತ್ರಾತ್ಮಾನಿ ಬರ್‌ಲ್ಯಾಲ ಮಾನುಸ್ ಸ್ತೆಫನ್, ಪಿಲಿಪ್, ಪ್ರೊಖೊರ್, ನಿಕೊನೊರ್, ತಿಮೊನ್, ಪರ್ಮೆನ್ ಆನಿ ಯೆಹುದಿ ಜಾ಼ಲ್ಯಾಲಾ ನಿಕೊಲಾಯ್ ಹ್ಯೊ ಅಂತಿಯೊಕ್ಯಾತ್ಲಾ ಜಾ಼ಲ್ಥಾ. ");
INSERT INTO gok_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","ನಂತರ್ ತ್ಯಂಚಾನಿ ತ್ಯಾ ಸಾತ್ ಜ಼ನಾನಾ ಅಪೊಸ್ತಲಾಂಚೆ ಮೊರ‍್ಹ ಉಬಕೆಲ. ಅಪೊಸ್ತಲಾಂಚಾನಿ ಮಾಗ್ನ ಕರುನ್ ತ್ಯಂಚೆ ಡುಯಿವ ಆಪ್ಲ ಹಾತ್ ಥೆವ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","ದೇವಾಚಾ ವಾಕ್ಯಾ ಖುಬ್ ಲೊಕಾಪ್ನಿ ಪೊಚಾಯಾ ಲಾಗ್‌ಲ್ಯಾ ಯೇರುಸಲೆಮ್ ಪೆಠತ್‌ಲ್ಯಾ ಶಿಶಾಂಚಾ಼ ಮೆಳಾ ಖುಬ್ ಬಳಕಾಟ್ಲಾ. ಯಾಜಕ್ಬಿ ಖುಬ್‍ಜಾ಼ನ್ ಕ್ರಿಸ್ತಾವ ಇಸ್ವಾಸ್ ಥೆವಾಯಾ ಲಾಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","ಸ್ತೆಪ ದೇವಾಚೆ ಕ್ರಪೆನಿ ಬಳಾನಿ ಬರ್‌ಲ್ಯಾಲಾ ವ್ಹವುನ್ ಅದ್ಬುತ್ ಕಾಮ ಆನಿ ಚಮತ್ಕಾರಾಚಿ ಕಾಮ ಲೊಕಾಂಚೆ ಮದ್ದಿ ಕರಿತಾ. ");
INSERT INTO gok_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","ಫನ್ ಸ್ವತಂತ್ರ ಮನ್ಹುನ್ ಹಾಕಟ್‌ಲ್ಯಾಲ ಸಭಾಸ್ಥಾನಾಚ಼ ಸದಸ್ಯ ಮನ್ಹುನ್ ಹಾಕಟ್ಯಾಲ ಸಭಾಸ್ಥಾನಾಚ಼಼ ಸದಸ್ಯ ಮಂಜೆ ಸಿರಿಯಾ ಆನಿ ಅಲೆಕ್ಸಾಂದ್ರಿಯಾಚ಼ ಯೆಹುದಿ ತೇ ಆನಿ ಥೊಡ ಕಿಲಿಕ್ಯ ಆನಿ ಆಶಾತ್ನಿ ಆಲ್ಯಾಲ ಯೆಹುದಿ ಸ್ತೆಫಾ ಸಂಗ ವಾದ್ ಗಾಲ್ಹಿತ. ");
INSERT INTO gok_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","ಫನ್ ಸಮಾದಾನಾನಿ ಬೊಲಾಯಾ ಪವಿತ್ರಾತ್ಮಾನಿ ತ್ಯಲಾ ಮಜ಼ತ್ ಕಿಲಿ. ಸ್ತೆಫನಾಚಾ ಬೊಲ್ಯಾ ಖುಬ್ ಬಳಾಚಾ ಹುತ್ಯಾ ಮನ್ಹುನ್ ತ್ಯಚಿ ಸಂಗ ವಾದ್ ಕರಾಯಾ ತ್ಯನಾ ಜಾ಼ಲ್ಹ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","“ತವಾ ಮೊಶೆಚೆ ಆನಿ ದೇವಾಚೆ ಆಡವ್ಯಾ ಬುರ್ಶಾ ಖನ್ಕತಿ ಸಾಂಗ್ತೊ. ತ್ಯಾ ಆಮಿಸ್ ಐಕ್‌ಲ್ಯಾತಾ!” ಮನ್ಹುನ್ ಸಾಂಗಾಯಾ ಥೊಡ್ಯಾನಾ ಪೈಸ ದಿವುನ್ ಥೆವ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","ಆಸಸ್ ಹ್ಯಾ ಯೆಹುದ್ಯಾಂಚಾನಿ ಲೊಕಾನಾ ಯೆಹುದಿ ಜಾಂತ್ಯಾನಾ ಧರ್ಮಉಪದೇಶಾಕಾನಾ ಚಿಡಿವ್ಲ ಆನಿ ತ್ಯಲಾ ಕುಂಡುನ್ ಯೆಹುದಿ ಜಾಂತ್ಯಾಂಚೆ ನ್ಯಾಯಿತ್ ನೆಲ್ಹಾ. ");
INSERT INTO gok_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","ತವಾ ತೇ ಯೆಹುದಿ ಥೊಡ್ಯಾ ಲಬಾಡ್ ಸಾಕ್ಷಿ ಗಿಹುನ್ ಹ್ಯೊ ಮಾನುಸ್ ಹ್ಯಾ ಪವಿತ್ರ ದೇವ್ಳಾಚೆ ಆಡ್ವಾ ಮೊಶೆಚಾ ಧರ್ಮಶಾಸ್ತಾರಾಚೆ ಆಡ್ವಾ ಬುರ್ಶಾ ಗುಶ್ಟಿ ಖಾಯಿಮ್ ಬೊಲ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","ತ್ಯೊ ನಜ಼ರೆತಿಚಾ಼ ಯೇಸು ಹ್ಯ ದಿವುಳ್ ಪಾಡುನ್ ಮೊಶೆನಿ ದಾವುನ್ ದಿಲ್ಯಾಲಿ ಪದ್ದತ್ ಬದಲ್ನಾರ್ ಮನ್ಹುನ್ ಹ್ಯೊ ಸಾಂಗ್‌ತ್ಯಾಲಾ ಆಮಿ ಐಕ್‌ಲ್ಯಾ” ಮನ್ಹುನ್ ಸಾಂಗಾಯಾ ಲಾಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","ನ್ಯಾಯಿಚಿ ಮಂಡಳಿ ಬಸ್‌ಲ್ಯಾಲಿ ಸಗ್ಳಿ ಸ್ತೆಫನನಾಚ಼ ತ್ವಾಂಡ್ ಜ಼ಪುನ್ ಬಕ್ತಾನಾ ತ್ಯಚ಼ ತ್ವಾಂಡ್ ದೇವ್ ದುತಾಚಾ ತೊಂಡಾಚೆಗತ್ ದಿಸ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","ಮುಖ್ಯ ಯಾಜಕಾನಿ ಸ್ತೆಪಾಲಾ, “ಹ್ಯಾ ಖನ್ಕತಿ ಖರ‍್ಯಾ ಕ್ಯಾ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","ತವಾ ತ್ಯೊ ಆಸಾ ಮನ್ಲಾ. ಮಾಜಾ ಬಾಪಾನು, ಆನಿ ಬಾವ್ಹಾನು ಮಾಜ಼ ಐಕಾ ಆಮ್‍ಚಾ಼ ವಡಿಲ್ ಅಬ್ರಹಾಮಾಲಾ ಮೈಮಾ ಆಸಲ್ಯಾಲ್ಯಾ ಆಮ್ಚಾ ದೇವಾನಿ ದರಶಾನ್ ದಿಲ. ಆಬ್ರಾಮ್ ಹಾರಾನಾತ್ ರಾಹ್ಯಾಚೆ ಆಂದಿ ಮೆಸೊಪೊಟೆಮಿತ್ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","ದೇವಾನಿ ಅಬ್ರಾಹಾಮಾಲಾ, ‘ತುಜಿ ದೆಶಾ ಆನಿ ತುಜಿ ಲೊಕ ಸುಡುನ್ ಮಿ ತುಲಾ ದ್ಯಾವ್‌ತ್ಯಾಲೆ ದೆಶೆತ್ ಜಾ಼’ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","ಮನ್ಹುನ್ ಅಬ್ರಹಾಮ್ ಖಾಲ್ದೆಯ್ ದೆಶಾ ಸುಡುನ್ ಹಾರಾನಿತ್ ಜಿವ್ನಾ ಕರಾಯಾ ಗೇಲಾ. ಅಬ್ರಹಾಮಾಚಾ಼ ಬಾ ಮೆಲ್ಯಾ ನಂತರ್ ದೆವಾನಿ ತ್ಯಲಾ ಆತಾ ತುಮಿ ಜಿವ್ನಾ ಕರ್ತ್ಯಾಲ್ಯಾ ಜಾ಼ಗ್ಯಾವ ಲಾವುನ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","ದೇವಾನಿ ಅಬ್ರಹಾಮಾಲಾ ಹಿತ್ತ ಪಸಾಬಬಿ ಜೀಮಿನ್ ದಿಲಿ ನಾಹಿ. ಫನ್ ಮೊರ್‌ಲ್ಯಾ ಕಾಲಾತ್ ಹಿ ದೇಶಾ ತ್ಯಲಾಬಿ ತ್ಯಚಾ ಪೊರಾನಾ ದೆತೊ ಮನ್ಹುನ್ ದೆವಾನಿ ಅಬ್ರಹಾಮಾಲಾ ವಾಗ್ದಾನ್ ಕೆಲಾ. ಅಬ್ರಹಾಮಾಲಾ ಪೊರ ನಸ್ಥಾನಾಸ್ ಹ್ಯ ಸಗ್ಳ ಜಾ಼ಲ್ಹ. ");
INSERT INTO gok_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","ದೇವಾನಿ ತ್ಯಲಾ, ‘ತುಜಿ ಪಿಳ್ಗಿ ಸಗ್ಳಿ ದುಸ್ರೆ ದೆಶೆತ್ ರಾನ್ಹಾರ್. ತೇ ಪರದೆಶಿ ವ್ಹವುನ್ ತಿತ್ಲಿ ಲೊಕ‍ ತ್ಯನಾ ಗುಲಾಮ್ ಕರುನ್ ಚಾರ್ಶೆ ವರ್ಸಾ ಪರೆತ್ ತ್ಯನಾ ಖುಬ್ ಜಾ಼ಸ್ ಕರ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","ಫನ್ ತ್ಯನಾ ಗುಲಾಮ್ ಕೆಲ್ಯಾಲ್ಯಾ ಲೊಕಾನಾ ಮಿ ಸಿಕ್ಷಾ ದೇನಾರ್’ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ಮಂಗ್ ತೇ ತೇ ದೇಶೆತ್ನಿ ಬಾಹಿರ್ ಯವುನ್ ಮನಾ ವವ್ಯಾಳ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","ದೇವಾನಿ ಅಬ್ರಾಹಾಮಾ ಸಂಗ ಯೊಕ್ ಕರಾರ್ ಕೇಲಾ ತ್ಯಾ ಕರಾರಾಚಿ ವಳಕ್ ಮುಂಜಿ. ಆಸ ಆಸ್ಥಾನಾ ಅಬ್ರಾಹಾಮಾಲಾ ಯೊಕ್ ಲ್ಯೊಕ್ ಜಾ಼ಲ್ಹಾ ತವಾ ತ್ಯಲಾ ಆಟ್‌ವ್ಯಾ ದಿಸಾತ್ ಮುಂಜಿ ಕಿಲಿ ತ್ಯಚಾ ಲೇಕಾಚ಼ ನಾವ್ ಇಸಾಕ್, ಇಸಾಕಾನಿಬಿ ಆಪ್ಲಾ ಲ್ಯೊಕ್ ಯಾಕೊಬಾಲಾ ಮುಂಜಿ ಕಿಲಿ ಆನಿ ಯಾಕೊಬಾನಿ ಆಪ್‌ಲ್ಯಾ ಸಗ್‌ಳ್ಯಾ ಪ್ಯೊರ್ಗ್ಯಾನಾ ಮುಂಜಿ ಕಿಲಿ. ಹೇ ಪ್ಯೊರ್ಗಸ್ ಮೊರ್ಹ ಬಾರಾಜಾ಼ನ್ ವಡಿಲ್ ಜಾ಼ಲ್ಹ. ");
INSERT INTO gok_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","ಯಾಕೊಬಾಚಾ ಹ್ಯಾ ವಡ್ಲಾಂಚಾನಿಸ್ ಆಪ್ಲಾ ಬಾಹು ಯೊಸೆಪಲಾ ಖೊಟ್ಯಾಫನಾನಿ. ಈಜಿಪ್ಟ ಲೊಕಾನಾ ಇಕ್ಲಾ. ಫನ್ ದೇವ್ ಯೊಸೆಫಾಸಂಗ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ಯೆಸೆಫಲಾ ತಿಥ ಖುಬ್ ತರಾಸ್ ಆಲಾ. ಫನ್ ದೇವಾನಿ ತ್ಯಾ ಸಗ್‌ಳ್ಯಾ ತರಾಸಾತ್ನಿ ತ್ಯಲಾ ರ‍್ಯಾಕ್ಲಾ. ತವಾ ಫರೊಹನ್ ಈಜಿಪ್ಟಾಚಾ಼ ರಾಜಾ಼ ಜಾ಼ಲ್ಥಾ. ದೇವಾನಿ ಯೊಸೆಫಾಲಾ ದಿಲ್ಯಾಲ್ಯಾ ಗಿನ್ಯಾನಾಸ್ಲಾಗುನ್ ಫರೊಹನಾಲಾ ಯೊಸೆಪ್ ಆವಾಡ್ಲಾ ಆನಿ ಮರ‍್ಯಾದ್ ದಿಲಿ. ಪರೊಹನಾನಿ ಯೊಸೆಪಾಲಾ ಐಗುಪ್ತ ದೆಶೆವ ಆನಿ ಆಪ್‌ಲ್ಯಾ ರಾಜ್ಭಾರಾವ ಅಧಿಕಾರಿ ಥರಿವ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","ಫನ್ ಐಗುಪ್ತಾತ್ ಆನಿ ಕಾನಾನಾತ್ ಬರಗಾಲ್ ಆಲ.ಆನಿ ಆಮ್ಚಾ ವಡ್ಲಾನಾಸಾಹಿತ್ ಆನ್ ಮಿಳಾಲ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","ಫನ್ ಐಗುಪ್ತಾತ್ ದಾನ ಹಾತ ಮಂಥ್ಯಾಲಿ ಖಬರ್ ಯಾಕೊಬಾನಿ ಐಕುನ್ ಆಮ್ಚಾ ವಡ್ಲಾನಾ ತಿಥ ಪೈಲೆ ಪಾವ್ಟಿ ಲಾವುನ್ ದಿಲ. ");
INSERT INTO gok_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","ನಂತರ್ ತೆ ತಿಥ ದೊನವ್ಯಾನಿ ಗೇಲ ತವಾ. ಯೊಸೆಪಾನಿ ಆಪ್‌ಲ್ಯಾ ಬಾವ್ಹಾನಾ ಆಪ್ಲಿ ವಳಕ್ ದ್ಯಾವ್ಲಿ, ತವಾ ಯೊಶೆಪಾಚ಼ ಗರ್ಹಾನ ಫರೊಹ ರಾಜಾಲಾ ಸಮಾಜ಼್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","ತವಾ ಯೊಸೆಪಾನಿ ಆಪ್ಲಾ ಬಾ ಯಾಕೊಬಾಲಾ ಆನಿ ಮಾಯೆಚಾನಾ ತೀ ಸಗ್ಳಿ ಮಿಳುನ್ ಸತ್ತರಾವ ಪಾಚ಼್ ಲೊಕಾನಾ ಐಗುಪ್ತಾತ್ ಹಾಕ್ಟುನ್ ಗಿತ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","ಮನ್ಹುನ್ ಯಾಕೊಬ್ ಐಗುಪ್ತಾತ್ ಗೇಲಾ ತ್ಯೊ ಆನಿ ತ್ಯಚ಼ ಲ್ಯಾಕ್ ಮರಸ್ಪರತ್ ತಿಥಸ್ ಹುತ್ತ. ");
INSERT INTO gok_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","ನಂತರ್ ತ್ಯಂಚಾ ಹಡಾಂಚಾ ಪಾಂಜ್ರಿ ಶೆಕೆಮಿತ್ ಆನ್‌ಲ್ಯಾ. ತಿತ್ಲೆ ಯಕ ಮಸುರ್ಡಿತ್ ತ್ಯನಾ ಪುರ್ಲ್ಯಾ. ಅಬ್ರಹಾಮಾನಿ ಹಾಮೊರಾಚಾ ಲೆಕಾನಾ ಚ಼ಾಂದಿ ದಿವುನ್ ಇಕತ್ ಗೆಥಲ್ಯಾಲಿ ಮಸುರ್ಡಿ ಹಿಸ್ ");
INSERT INTO gok_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“ದೇವಾನಿ ಅಬ್ರಹಾಮಾಲಾ ವಾಗ್ದಾನ್ ಕೆಲ್ಯಾಲಾ ಕಾಲ್ ಬಿಗಿನಿ ಯಯಚಾ಼ ಹುತ್ತಾ. ತವಾ ಐಗುಪ್ತಾತ್ ಆಮ್ಚಿ ಲೊಕ ಜಾ಼ಲ್ಯಾಲಿ ಯೆಹುದ್ಯಾಂಚಿ ಸಂಖ್ಯಾ ಖುಬ್ ಜಾ಼ಲ್ಹಿ. ");
INSERT INTO gok_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","ನಂತರ್ ದುಸ್ರಾ ಯೊಕ್ ರಾಜಾ಼ ಐಗುಪ್ತಾತ್ ರಾಜ಼್ಬಾರ್ ಕರಾಯಾ ಲಾಗ್ಲಾ. ತ್ಯಲಾ ಯೊಸೆಪಾಚೆ ಗುಶ್ಟಿತ್ ಕಾಯೆಕ್ ಠಾವ ನವ್ಥ. ");
INSERT INTO gok_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","ಹ್ಯಾ ರಾಜಾನಿ ಆಮ್ಚಾ ಲೊಕಾನಾ ಮೊಸ್ ಕೆಲಾ. ತ್ಯನಿ ಆಮ್ಚಾ ವಡ್ಲಾನಾ ಬಾದ್ ಕೆಲ. ತ್ಯಂಚಾ ಮುಲಾನಾ ಮಾರುನ್ ಟಾಕಾಯಾ ಗರ‍್ಹಾತ್ನಿ ಬಾಹಿರ್ ಟಾಕಾಯಾ ಲ್ಯಾವ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","ಮೊಶೆ ಜ಼ಲಾಮ್‌ಲ್ಯಾಲಾ ಹ್ಯಾ ಕಾಲಾತುಸ್, ತ್ಯೊ ಖುಬ್ ಶಾದ್ರಾ ಹುತ್ತಾ. ಮೊಶೆಲಾ ತ್ಯಚೆ ಆಯಿ ಬಾಚಾ ಗರ‍್ಹಾತ್ ತೀನ್ ಮೈನಿ ಬಾಳಗ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","ತ್ಯಂಚಾನಿ ಮೊಶೆಲಾ ಬಾಹಿರ್ ಟ್ಯಾಕ್ಲಾ ತವಾ ಫರೊಹನಾಚಿ ಲಿಕಿನಿ ತ್ಯಲಾ ಗೆತ್ಲಾ. ತೀನಿ ತ್ಯಲಾ ಆಪ್‌ಲ್ಯಾ ಲೇಕಾಚೆಗತ್ ಬಾಳಗ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","ಐಗುಪ್ತಾತಲ್ಯಾಂಚಾನಿ ಆಪ್‌ಲ್ಯಾಲಾ ಠಾವ ಆಸ್‌ಲ್ಯಾಲ ಸಗ್ಳ ಗಿನ್ಯಾನ್ ಮೊಶೆಲಾ ಸೀಕಿವ್ಲ. ತ್ಯೊ ಬೊಲಾಯಾ ಕಾಮ ಕರಾಯಾ ಖುಬ್ ಹುಶಾರ್ ಜಾ಼ಲ್ಥಾ. ");
INSERT INTO gok_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","ಮೋಶೆಲಾ ಚಾಳಿಸ್ ವರ್ಸ ಜಾ಼ಲ್ಹಿತ ತವಾ, ಆಪ್ಲ ಬಾಹು ಜಾ಼ಲ್ಯಾಲ್ಯಾ ಇಸ್ರಾಯಲ್ ಲೊಕಾನಾ ಬಗಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ತ್ಯನಿ ಮನ್ ಕೆಲ. ");
INSERT INTO gok_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","ಐಗುಪ್ತಾತಲ್ಯಾ ಯಕಾನಿ ಇಸ್ರಾಯಲಾತಲ್ಯಾ ಯಕಾಲಾ ಅನೆವ್ ಕರ್ತ್ಯಾಲಾ ಬಗುನ್ ಮೊಶೆನಿ ತ್ಯಾ ಐಗುಪ್ತಾತಲ್ಯಾಲಾ ಮಾರುನ್ ಟಾಕುನ್ ಡಾವ್ ಫಾರಿಕ್ ಕರ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","ಆಪ್‌ಲ್ಯಾಲಾ ರಾಖಾಯಾ ದೇವಾನಿ ಮೊಶೆಲಾ ಉಪೇಗ್ ಕೆಲ್ಯಾ ಮನ್ಹುನ್ ಆಪ್ಲ ಇಸ್ರಾಲ್ ಬಾಹು ಸಮಜು಼ನ್ ಗೆಥ್ಯಾತ ಮನ್ಹುನ್ ಮೊಶೆನಿ ಯವಜ಼್ಲ. ಫನ್ ತ್ಯಂಚಾನಿ ಸಮಜು಼ನ್ ಗೆತ್ಲ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","ದುಸ್ರೆ ದಿಸಿ ದೊಗ ಇಸ್ರಾಯಲುಸ್ ಮಾರಾಮಾರಿ ಕರ್ತ್ಯಾಲ ಮೊಶೆನಿ ಬಗ್ಲ. ತ್ಯನಾ ಸಮಾಧಾನ್ ಕರಾಯಾ ಜಾ಼ವುನ್ ತ್ಯನಿ ಸೊಪ್‌ತ್ಯಾನು ತುಮಿ ಬಾಹು ಜಾ಼ಲ್ಯಾಸಾ! ತುಮಿ ಯಕಾ ಮಕಾಲಾ ಅನ್ನೆವ್ ಕಾ ಕರ್ತಾಸಾ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","ತ್ಯಾತ್‌ಲ್ಯಾ ಯಕಾನಿ ಮೊಶೆಲಾ ಮಾಗ ಡಕ್ಲುನ್ ತುಲಾ ಅದಿಕಾರಿ ನಾಹಿತ ನ್ಯಾಯಿ ನಿವಡತ್ಯಾಲಾ ಕುನಿ ಕೆಲ್ಯಾ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ ");
INSERT INTO gok_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","ಕ್ಯಾಲ್ ತ್ಯಾ ಐಗುಪ್ತಾತಲ್ಯಾಲಾ ಮಾರುನ್ ಟ್ಯಾಕ್‌ಲ್ಯಾಚೆಗತ್ ಮನಾಬಿ ಮಾರುನ್ ಟ್ಯಾಕ್ನಾರ್ ಕ್ಯಾ? ಮನ್ಲಾ ");
INSERT INTO gok_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","ಹ್ಯ ಐಕುನ್ ಮೊಶೆ ಐಗುಪ್ತಾತ್ನಿ ಪಳುನ್ ಜಾ಼ವುನ್ ಮಿದ್ಯಾನ್ ದೇಶಾತ್ ವಳಕ್ ನಸ್‌ಲ್ಯಾಲಾ ವ್ಹವುನ್ ರಾಯಲಾ, ತಿಥ ತ್ಯಲಾ ದೊಗ ಪ್ಯೊರ್ಗ ಜ಼ಲಾಮ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","ಚಾಳಿಸ್ ವರ್ಸ ಜಾ಼ಲ್ಯಾನಂತರ್ ಮೊಶೆ ಸಿನಾಯ್ ಗುಢ್ಯಾಚೆ ಜ಼ವಳ್ ಆಸ್‌ಲ್ಯಾಲೆ ಉಸ್ಕಾಚೆ ಜಿಮ್ನಿತ್ ಆಸ್ಥಾನಾ ಪೆಟ್ಯಾಲೆ ಜಾ಼ಳಿತ್ ಯೊಕ್ ದೇವ್ದುತ್ ದಿಸ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","ಮೊಶೆ ಗಾಬ್ರುನ್ ಬಗಾಯಾ ಜ಼ವಳ್ ಗೇಲಾ ತವಾ ಮೊಶೆಲಾ ಯೊಕ್ ಸಬ್ದ ಐಕ್ವಾಲಾ ತ್ಯೊ ಪ್ರಭುಚಾ಼ ಸಬ್ದ ಜಾ಼ಲ್ಥಾ. ");
INSERT INTO gok_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","ಪ್ರಭುನಿ ತ್ಯಲಾ ಮೀಸ್ ತುಜಾ ವಡ್ಲಾಂಚಾ಼ ದೇವ್ ಮೀಸ್ ಅಬ್ರಹಾಮಾಚಾ಼ ದೇವ್ ಇಸಾಕಾಚಾ಼ ದೇವ್ ಆನಿ ಯಾಕೊಬಾಚಾ಼ ದೇವ್ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ಮೊಶೆಲಾ ಬಿಹುನ್ ಕ್ಯಾಪ್ರಬರ್ಲ. ಆನಿ ಜಾ಼ಳಿಕ್ಡ ಬಗಾಯಾ ಬಿಹ್ಯಾಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","ಪ್ರಭು ತ್ಯಲಾ, ತುಜಾ ಪಾಯಾತಲ್ಯಾ ವ್ಹಾನಾ ಕ್ಯಾಡ್ ಕಾ ಮಂಜೆ ಆತಾ ತು ಉಬಾ ರಾಯ್‌ಲ್ಯಾಲಾ ಜಾ಼ಗಾ ಪರಿಶುದ್ದ ಜಾ಼ಲ್ಯಾಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","ಐಗುಪ್ತಾತ್ ಲೊಕ ಖುಬ್ ತರಾಸ್ ಖಾತ್ಯಾಲಿ ಮೀ ಬಗ್ಲಿತ ತ್ಯಂಚ಼ ರಡ್ನ ಮನಾ ಐಕು ಆಲ್ಯಾ: ಮಿ ತ್ಯನಾ ಸೊಡ್ವಾಯಾ ಉತ್ರುನ್ ಆಲ್ಯೊ ಆತಾ ಮೀ ತುಲಾ ಐಗುಪ್ತಾತ್ ಲಾವುನ್ ದೇತೊ. ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","ತ್ಯಾ ಯೆಹುದ್ಯಾಂಚಾನಿ ತುಲಾ ಅದಿಕಾರಿ ನಾಹಿತ ನ್ಯಾಯಿ ನಿವಡತ್ಯಾಲಾ ಕುನಿ ಕೆಲ್ಯಾ, ಮನ್ಹುನ್ ಮೊಶೆಚಿ ನಕ್ವಾಟ್ ಕಿಲ್ತಿ. ಫನ್ ದೇವಾನಿ ಅಧಿಕಾರಿ ಆನಿ ಸುಡಿವ್ನಾರಾ ಕರುನ್ ಆಪ್‌ಲ್ಯಾ ದುತಾಸಂಗ ಮೊಶೆಲಾ ಲಾವುನ್ ದಿಲಾ. ಪೆಟ್ಯಾಲೆ ಜಾ಼ಳಿತ್ ಮೊಶೆನಿ ಬಗ್‌ಲ್ಯಾಲಾ ಧುತ್ ಹ್ಯೊಸ್. ");
INSERT INTO gok_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","ಮನ್ಹುನ್ ಮೊಶೆನಿ ಲೊಕಾನಾ ಐಗುಪ್ತಾತ್ನಿ ಹಾಕ್ಟುನ್ ಆನ್ಲಾ. ತ್ಯನಿ ಚಮತ್ಕಾರಾಚಿ ಕಾಮ ಅದ್ಬುತಾಚಿ ಕಾಮ ಐಗುಪ್ತಾತ್ ತಾಂಬಡ್ಯಾ ಸಮುದ್ರಾತ್ ಆನಿ ಚಾಳಿಸ್ ವರ್ಸ ರಾನಾತ್ ಚಾ಼ಲಿವ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","ಹ್ಯಾಸ್ ಮೊಶೆನಿ ಇಸ್ರಾಯಲ್ ಲೊಕಾನಾ ದೇವ್ ತುಮಾನಾ ಯೊಕ್ ಪ್ರವಾದಿ ದೆನಾರ್ ತ್ಯೊ ಪ್ರವಾದಿ ತುಮಚಾಸ್ ಲೊಕಾತ್ನಿ ಯನಾರ್ ತ್ಯೊ ಮಾಜಿಗತುಸ್ ರಾನ್ಹಾರ್ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","ರಾನಾತ್ ಇಸ್ರಾಯಲಾಂಚಾ ಮೆಳ್ಯಾತ್ ರಾಯ್‌ಲ್ಯಾಲಾ ಹ್ಯೊ ಮೊಶೆಸ್. ಸಿನಾಯ್ ಮೊಟ್ಯಾ ಗುಡ್ಯಾಪ ಮಾಜಿ ಸಂಗ ಬೊಲ್ಯಾಲ್ಯಾ ದೇವ್ದುತಾ ಸಂಗ ತ್ಯೊ ಹುತ್ತಾ. ತ್ಯವ್ಡಸ್ ನವ್ಹ ಆಮ್ಚಾ ವಡ್ಲಾಂಚಿಸಂಗ ಹುತ್ತಾ. ಜೀವಾಚ಼ ಸಬ್ದ ಮೊಶೆನಿ ದೇವಾಫ್ನಿ ಗಿಹುನ್ ತೇ ಆಮಾನಾ ದಿಲ. ");
INSERT INTO gok_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","ಫನ್ ಮೊಶೆನಿ ಸಾಂಗಲ್ಯಾಲ ಆಮ್ಚಾ ವಡ್ಲಾನಾ ಆವಾಡ್ಲ ನವ್ಥ. ತ್ಯಂಚಾನಿ ತ್ಯಲಾ ನಕ್ವಾಟ್ ಕರುನ್, ಐಗುಪ್ತಾತ್ ಮಾಗಾರ ಜಾ಼ಯಾ ವ್ಹಯಿ ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","ತ್ಯಂಚಾನಿ ಆರೊನಾಲಾ, ‘ಆಮಾನಾ ಐಗುಪ್ತ ದೇಶಾತ್ನಿ ಹಾಕ್ಟುನ್ ಆನಲ್ಯಾಲಾ ಮೊಶೆ. ಕ್ಯಾ ಜಾ಼ಲ್ಹ ಆಮಾನಾ ಠಾವಾ ನಾಹಿ. ಆಮಿ ಮೊರ‍್ಹ ಜಾ಼ಯಾ ಆನಿ ಆಮಾನಾ ಚಾ಼ಲ್ವಾಯಾ ದ್ಯಾವ್ ಕರುನ್ ದೆ’ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","ತವಾ ತ್ಯಂಚಾನಿ ವಾಸರಾಚ಼ ಯಾಕ್ ಪಾಶಾನ್ ಬನಿವ್ಲ ಆನಿ ತ್ಯಚೆ ಮೊರ್ಹ ಬಲಿ ದಿವುನ್. ಆಪ್‌ಲ್ಯಾ ಹಾತಾನಿ ಕೆಲ್ಯಾಲ್ಯಾ ಪಾಶಾನಾಂಚೆ ಗುಶ್ಟಿತ್ ಖುಬ್ ಆನಂದ್ ಕೆಲಾ!. ");
INSERT INTO gok_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","ಫನ್ ದೇವಾನಿ ತ್ಯಂಚಿಕ್ಲ ತ್ವಾಂಡ್ ಪರತ್ಲ, ಆನಿ ಆಬ್ಳಾತ್‌ಲ್ಯಾ ಚಾ಼ಂದ್ ದೀಸ್ ಚಾನ್ಯಾನಾ ಪುಜಾ಼ಯಾ ತ್ಯನಾ ಸುಡುನ್ ದಿಲ. “ಹ್ಯ ಪ್ರವಾದಿಂಚಾ ಪುಸ್ತಕಾತ್ ಲಿವ್‌ಲ್ಯಾ. ಇಸ್ರಾಯಲ್ ಲೊಕಾನಾ ಚಾಳಿಸ್ ವರ್ಸ ರಾನಾತ್ ಆಸ್ಥಾನಾ ಕವಾತರಿ ಯಜ್ಞಾ ವ್ಹವುನಿ ಬಲಿ ವ್ಹವುನಿ ದಿಲ್ತಸಾ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","ತುಮಿ ಪುಜಾ಼ಯಾ ಕೆಲ್ಯಾಲಿ ಪಾಶಾನ ಮಂಜೆ ಮೊಲೊಖಾಚಾ ಮಾಂಡ್ವಾವ ರೆಫಾನ್ ದೆವಿಚ಼ ಚಾನ್ನಿಚ಼ ರುಪ್ಕರುನ್ ಉಚ಼ಲುನ್ ನಿಹಿತಾಸಾ ಮನ್ಹುನ ಮಿ ತುಮಾನಾ ಬಾಬಿಲೊನಾಚಾ ತಾಬ್ಯಾತ್ ದೆನಾರ್. ");
INSERT INTO gok_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","ದೇವ್ ರಾಥ್ಯಾಲಾ ಮಾಂಡವ್ ತ್ಯಾ ಇಸ್ರಾಯಲಾಂಚೆ ಸಂಗ ರಾನಾತ್ ಹುತ್ತಾ ತ್ಯೊ ಮಾಂಡವ್ ಕರ್ತ್ಯಾಲ್ಯಾಂಚೆ ಗುಶ್ಟಿತ್ ದೇವಾನಿ ಮೊಶೆಲಾ ಸಾಂಗುನ್ ದಿಲ. ದೇವಾನಿ ಆಪ್‌ಲ್ಯಾಲಾ ದ್ಯಾವ್‌ಲ್ಯಾಚೆಗತ್ ಮೊಶೆನಿ ಬನಿವ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","ಆಮ್ಚಾ ವಡ್ಲಾಂಚಾನಿ ತ್ಯ ಆಪ್‌ಲ್ಯಾ ವಡ್ಲಾಂಚಿಪ್ನಿ ಗೆತ್ಲಾ ಹುತ್ತಾ. ತ್ಯಂಚಾನಿ ಯೊಹೊಶಾಚಾ ಫುಡಾರಿ ಫನಾತ್ ತ್ಯೊ ಮಾಂಡೊವ್ ಕಾನಾನ್ ದೆಶಾತ್ ಆನ್ಲಾ ತವಾ ತಿ ದೆಶಾ ದುಸ್‌ರ‍್ಯಾ ಲೊಕಾಂಚಿ ಹುತ್ತಿ. ಫನ್ ದೇವಾನಿ ಆಮ್ಚಾ ವಡ್ಲಾಂಚಾ ಡೊಳ್ಯಾ ಮೊರ‍್ಹಸ್ ತ್ಯಾತ್‌ಲ್ಯಾ ಲೊಕಾನಾ ಬಾಹಿರ್ ಗ್ಯಾತ್ಲಿತ. ಆನಿ ದಾವಿದಾಚಾ ಕಾಲಾ ಪರ‍್ಯಾತ್ ತಸಸ್ ಹುತ್ತ. ");
INSERT INTO gok_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","ದಾವಿದಾಲಾ ದೇವಾಚಿ ಕ್ರಪಾ ಮಿಳಾಲಿ. ತ್ಯನಿ ಮೀ ಯಾಕೊಬಾಚಾ ದೇವಾಪ ಮಾಗ್ನ ಕರಾಯಾ ಘರ್ ಬಾಂದಾಯಾ ಮನಾ ಮೊಕಳ್ದೇ ಮನ್ಹುನ್ ದೇವಾಪ ಮಾಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","ಫನ್ ದೇವಾಸಾಟಿ ದಿವುಳ್ ದಾವಿದಾಚಾ಼ ಲ್ಯೊಕ್ ಸೊಲೊಮೊನಾನಿ ಬ್ಯಾಂದ್ಲ ");
INSERT INTO gok_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","ಫನ್ ಮಾನ್ಸಾನಿ ಆಪ್‌ಲ್ಯಾ ಹಾತಾನಿ ಬ್ಯಾಂದ್‌ಲ್ಯಾಲ್ಯಾ ಗರ‍್ಹಾತ್ನಿ ಮಹೊನ್ನತ ದೆವ್ ರಾಹಿತ್ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","ಪ್ರಭು ಆಸಾ ಮಂಥೊ, ಸ್ವರ್ಗ ಮಾಜ಼ ರಾಜಾಸನ್, ದರ್ಥಿವ ಮಾಜ಼ ಪ್ಯಾ ಹಾತ. ತುಮಿ ಮನಾ ಕಸ್ಲ ಘರ ಬ್ಯಾಂದನಾರ್? ನಾಹಿತ ಮಾಜಾ಼ ರಾಹ್ಯಾಚ಼ಾ ಜಾ಼ಗಾ ಕಚಾ಼? ");
INSERT INTO gok_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","ಯಾದ್ ರಾಹುನಿ ತೀ ಸಾಮ್ನ ಸಗ್ಳಿ ಕೆಲ್ಯಾಲಿ ಮಿಸ್!” ಆಸ ಪ್ರವಾದಿನಿ ಲಿವ್‌ಲ್ಯಾ: ");
INSERT INTO gok_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","ಸ್ತೆಫನಾನಿ ಬೊಲ್ನ ಸುರು ಕೆಲ. ಹಾಟೊಳ್ಯಾ ಲೊಕಾನು! ತುಮಿ ತುಮ್ಚಿ ಮನ ದೇವಾಲಾ ದಿಲಿ ನಾಹಿಸಾ. ತುಮಿ ತ್ಯಚ಼ ಐಕ್ಲ ನಾಹಿಸಾ. ಪವಿತ್ರಾತ್ಮ ತುಮಾನಾ ಸಾಂಗಾಯಾ ಯತ್ನ ಕರ್ತ್ಯಾಲೆ ಗುಶ್ಟಿತ್ ತುಮಿ ಕವಾಬಿ ವಾದಿ ಜಾ಼ಲ್ಯಾಸಾ. ತುಮ್ಚಾ ವಡ್ಲಾಂಚಾನಿ ಆಸಸ್ ಕೆಲ ಆನಿ ತುಮಿ ತ್ಯಂಚಿಗತುಸ್ ಹಾಸಾ. ");
INSERT INTO gok_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","ಪರತೇಕ್ ಪ್ರವಾದಿಲಾ ತುಮ್ಚಾ ವಡ್ಲಾಂಚಾನಿ ನಿಂದಾ ಕಿಲಿ ಯೊಕ್ ನಿಯತಿಚಾ಼ ಯತ್ಯೊ ಮನ್ಹುನ್ ಖುಬ್ ಕಾಲಾಚೆ ಮಾಗಸ್ ತ್ಯಾ ಪ್ರವಾದಿಂಚಾನಿ ಸಾಂಗ್ಲ ಹುತ್ತ. ಫನ್ ತುಮ್ಚಾ ವಡ್ಲಾಂಚಾನಿ ತ್ಯನಾ ಮಾರುನ್ ಟ್ಯಾಕ್ಲ. ಆತಾ ತುಮಿ ತ್ಯಲಾ ದರ್ಹುನ್ ಮಾರುನ್ ಟ್ಯಾಕ್‍ಲ್ಯಾಲಿ ಜಾ಼ಲ್ಯಾಸಾ. ");
INSERT INTO gok_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","ದೇವಾನಿ ಆಪ್‌ಲ್ಯಾ ಧುತಾಂಚಿಪ ಧರ್ಮಶಾಸ್ತಾರ್ ಲಾವುನ್ ದಿಲ ಫನ್ ತುಮಿ ತ್ಯ ಪ್ಯಾಳ್ಳ ನಾಹಿಸಾ!” ");
INSERT INTO gok_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","ಸ್ತೆಫನನಾಚಾ ಹ್ಯಾ ಬೊಲ್ಯಾ ಐಕ್‌ಲ್ಯಾಲ ಯೆಹುದಿ ಅದಿಕಾರಿ ಖುಬ್ ರಾಗಾವ ಆಲ ತ್ಯಂಚಾನಿ ರಾಗಾನಿ ಸ್ತೆಫನಾವ ದಾತ್ಚಾವ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","ಫನ್ ಸ್ತೆಪನ್ ಪವಿತ್ರಾತ್ಮಾನಿ ಬರ್‌ಲ್ಯಾಲಾ ಜಾ಼ಲ್ಥಾ. ತ್ಯನಿ ಅಬ್ಳಾಕ್ಡ ಜ಼ಪುನ್ ಬಗುನ್ ದೇವಾಚಿ ಮೈಮಾ ಆನಿ ಯೇಸು ದೇವಾಚೆ ಉಜ಼ವ್ಯಾಂಗ್ನಿ ಉಬಾ ರಾಯ್‌ಲ್ಯಾಲಾ ಬಗ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","ತ್ಯನಿ “ಬಗಾ, ಸ್ವರ್ಗ ಉಗಾಡ್‌ಲ್ಯಾಲ ಮಾನ್ಸಾಚಾ಼ ಲ್ಯೊಕ್ ದೇವಾಚೆ ಉಜ಼ವ್ಯಾಂಗ್ನಿ ಉಬಾ ರಾಯ್‌ಲ್ಯಾಲಾ ಮಿ ಬಗತ್ಯೊ!” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","ತವಾ ಯೆಹುದಿ ಅದಿಕಾರಿ ಸಗ್ಳ ಜೊ಼ರಾನಿ ವರ್ಡತ್ ಆಪ್ಲ ಕಾನ್ ಜಾ಼ಖುನ್. ತೇ ಸಗ್ಳ ಯಕ್‌ವ್ಹವುನ್ ತ್ಯಚಾ ಆಂಗಾವ ಆಲ. ");
INSERT INTO gok_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ಆನಿ ತ್ಯಲಾ ಪೆಠತ್ನಿ ಬಾಹಿರ್ ವಡುನ್ ನಿಹುನ್ ತ್ಯೊ ಮರಸ್ ಪರ‍್ಯಾತ್ ತ್ಯಚಿವ ದೊಂಢ ಮ್ಯಾರ್ಲ. ತ್ಯಚೆ ಅಡವ್ಯಾ ಸಾಕ್ಷಿ ಸಾಂಗ್‌ಲ್ಯಾಲಿ ಲೊಕ ಆಪ್ಲ ಕಪ್ಡ ಕಾಡುನ್ ಸೌಲ ಮಂಥ್ಯಾಲ್ಯಾ ಪ್ಯೊರಗ್ಯಾಚಾ ಪಾಯಾತ್ ಥೆವ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","ಸ್ತೆಪನಾಲಾ ದೊಂಢ ಮ್ಯಾರ್ಲ ಫನ್ ಸ್ತೆಪನ್ ಮಾಗ್ನ ಕರಿತ್ ಪ್ರಭು ಜಾ಼ಲ್ಯಾಲ್ಯಾ ಯೇಸು ಮಾಜ಼ ಆತ್ಮ ಘೆ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","ತ್ಯನಿ ಡೊಗ್ಲ ಮುಡುನ್, “ಪ್ರಭು ಹ್ಯ ಪಾಪ್ ಹ್ಯಂಚಿವ ಗಾಲು ನಕೊಸ್” ಮನ್ಹುನ್ ಜೊ಼ರಾನಿ ವರ್ಡುನ್ ಜೀವ್ ಶೊಡ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","ತ್ಯಚಾ಼ ವಾದ್ ಸೌಲಾಲಾ ಮಾನ್ಯ ಹುತಾ ತ್ಯಾ ದಿಸಾತ್ ಯೆರುಸಲೆಮಿತ್ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ಇಸ್ವಾಸಿಂಚಾ ಮೆಳ್ಯಾಲಾ ಜಾ಼ಚ಼್ ಜಾ಼ಲ್ಹಾ ಅಪೊಸ್ತಲಾನಾ ಸುಡುನ್ ಸಗ್ಳ ಯೆಹುದ್ಯ ಆನಿ ಸಮಾರ‍್ಯಾ ಸಿಮತ್ನಿ ಪಗಾಳ್ಳಿತ. ");
INSERT INTO gok_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","ಥೊಡ್ಯಾ ಇಸ್ವಾಸಿಂಚಾನಿ ಸ್ತೆಪಾಚ಼ ಮಡ ನಿಹುನ್ ಪುರ್ಲ. ತ್ಯಚಿಸಾಟಿ ಖುಬ್ ರಡ್ಲ, ");
INSERT INTO gok_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","ಫನ್ ಸೌಲಾನಿ ಸಭೆಚಾ಼ ನಾಸ್ ಕರಾಯಾ ಸುರು ಕೆಲ ಇಸ್ವಾಸಿಂಚಾ ಗರ‍್ಹಾತ್ನಿ ಬರ‍್ಹುನ್ ಗಡ್ಯಾನಾ ಬಾಯಿಲ್ ಮಾನ್ಸಾನಾ ವಡುನ್ ನಿಹುನ್ ತುರುಂಗಾತ್ ಗ್ಯಾತ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","ಇಸ್ವಾಸಿ ಸಗ್ಳಿಕ್ಡ ಪಗ್ಳುನ್ ಗಿಲಿತ. ಆನಿ ತಿ ಗೆಲ್ಯಾಲ್ಯಾ ಪರತೇಕ್ ಜಾ಼ಗ್ಯಾವ ಲೊಕಾನಾ ಬರಿ ಖಬರ್ ಸಾಂಗ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","ಪಿಲಿಪ್ಪಾನಿ ಸಮಾರ‍್ಯಾ ಪೆಠತ್ ಜಾ಼ವುನ್ ಕ್ರಿಸ್ತಾಚೆ ಗುಶ್ಟಿತ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","ತ್ಯನಿ ಕೆಲ್ಯಾಲಿ ಚಮತ್ಕಾರಿಚಿ ಕಾಮ ಬಗ್ಲಿತ. ತ್ಯನಿ ಸಾಂಗ್‌ಲ್ಯಾಲ್ಯಾ ಸಗ್‌ಳ್ಯಾ ಗುಶ್ಟಿ ಲೊಕಾಂಚಾನಿ ಧ್ಯಾನ್ ದಿವುನ್ ಐಕ್‍ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","ಕಾ ಮಂಜೆ ಖುಬ್ ಲೊಕಾಂಚೆ ಆತ್ನಿ ಬುಥ ವರ್ಡತ್ ಬಾಹಿರ್ ನಿಗುನ್ ಗಿಲಿತ ತಿಥ ಲುಲ್ಲಿ ಆನಿ ಪಾರ್ಸಿ ಮ್ಯಾರಲ್ಯಾಲಿ ಸಾಹಿತ್ ಬರಿ ಜಾ಼ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","ಹ್ಯಚಿಸ್ ಲಾಗುನ್ ಪೆಠತ್ ಆಸ್‌ಲ್ಯಾಲಿ ಲೊಕ ಖುಬ್ ಸಂತೊಶ್ ಜಾ಼ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","ಫನ್ ತೇ ಪೆಠತ್ ಸಿಮೊನ್ ಮಂಥ್ಯಾಲಾ ಮಾನುಸ್ ಹುತ್ತಾ. ತ್ಯೊ ಘಾಡ್ಫನ್ ಕರೀತಾ ತ್ಯನಿ ಆಪ್‌ಲ್ಯಾ ಘಾಡ್ಫನಾನಿ ಸಮಾರ‍್ಯಾಚಾ ಸಗ್‌ಳ್ಯಾ ಲೊಕಾನಾ ಆಜಾಬ್ ಕರಿತಾ. ತ್ಯೊ ಆಪ್ನು ಮೊಟಾ ಮಾನುಸ್ ಮನ್ಹಿತಾ. ");
INSERT INTO gok_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","ನ್ಹಾನ್ ಥೊರ್ ಸಗ್ಳಿ ಲೊಕ, ಹ್ಯ ಮೊಟ ಬಳ್ ಮಂತ್ಯಾಲ ದೆವಾಚ಼ ಬಳುಸ್ ಮನ್ಹುನ್ ತ್ಯಚಿಕ್ಡ ಧ್ಯಾನ್ ದಿಯಿತಿತ. ");
INSERT INTO gok_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","ಖುಬ್ ದಿಸಾದರ್ನಿ ತ್ಯಚಾ ಘಾಡ್ಪನಾತ್ ಗಾವಲ್ಯಾಲಿ ಲೊಕ ತ್ಯಚೆ ಬುಲಿಲಾ ಧ್ಯಾನ್ ದಿಯಿತಿತ ಆನಿ ತ್ಯಚೆ ಮಾಗ್ನಿ ಜಾ಼ಯಿತಿತ. ");
INSERT INTO gok_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","ಫನ್ ಪಿಲಿಪಾನಿ ದೇವಾಚಾ ರಾಜಾಚೆ ಗುಶ್ಟಿತ್ ಆನಿ ಯೇಸು ಕ್ರಿಸ್ತಾಚಾ ಬಳಾಚೆ ಗುಶ್ಟಿತ್ ಲೊಕಾನಾ ಬರಿಖಬರ್ ಸಾಂಗ್ಲಿ ಬಾಪಯಿ ಆನಿ ಬಾಯಿಲ್ ಮಾನ್ಸಾಂಚಾನಿ ಪಿಲಿಪ್ಪಾನಿ ಸಾಂಗ್‌ಲ್ಯಾಲ್ಯಾವ ಇಸ್ವಾಸ್ ಥಿವುನ್ ಬಾಪ್ತಿಸ್ಮಾ ಗಿತ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","ಸಿಮೊನಾನಿ ಸಾಹಿತ್ ಇಸ್ವಾಸ್ ಥಿವುನ್ ಬಾಪ್ತಿಸ್ಮಾ ಗಿತ್ಲಿ. ಸಿಮೊನ್ ಪಿಲಿಪ್ಪಾಚೆ ಜ಼ವಳುಸ್ ಹುತ್ತಾ. ಪಿಲಿಪ್ಪಾನಿ ಕೆಲ್ಯಾಲಿ ಚಮತ್ಕಾರಿಚಿ ಕಾಮ ಆನಿ ಅದ್ಬುತ್ಕಾಮ ಸಿಮೊನಾನಿ ಬಗುನ್ ಗಾಭಾರ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","ಅಪೊಸ್ತಲ್ ಆಜು಼ನ್ ಯೆರುಸಲೆಮಿತ್ ಹುತ್ತ. ಸಮಾರ‍್ಯಾಚಾ ಲೊಕಾಂಚಾನಿ ದೇವಾಚಾ ವಾಕ್ಯಾ ಸ್ವಿಕಾರ್ ಕೆಲ್ಯಾಲ್ಯಾ ತ್ಯನಾ ಸಮಾಜ಼್ಲ. ಮನ್ಹುನ್ ತ್ಯಂಚಾನಿ ಪೇತ್ರಾಲಾ ಆನಿ ಯೊಹಾನಾಲಾ ತ್ಯಂಚಿಪ ಲಾವುನ್ ದಿಲ. ");
INSERT INTO gok_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","ತೇ ತಿಥ ಯವುನ್ ಸಮಾರ‍್ಯಾಚಾ ಇಸ್ವಾಸಿನಾಬಿ ಪವಿತ್ರಾತ್ಮ ಗಾವ್ಹಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ತ್ಯಂಚಿಸಾಟಿ ಮಾಗ್ನ ಕೆಲ. ");
INSERT INTO gok_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","ಹ್ಯಾ ಲೊಕಾಮಚಾನಿ ಪ್ರಭು ಜಾ಼ಲ್ಯಾಲ್ಯಾ ಯೇಸುಚಾ ನಾವಾನಿ ಬಾಪ್ತಿಸ್ಮಾ ಗೆತ್ಲಿ. ಫನ್ ಪವಿತ್ರಾತ್ಮ ತ್ಯಂಚಿವ ಕುನಾವಸ್ ಆಜು಼ನ್ ಆಲ ನವ್ಥ. ");
INSERT INTO gok_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","ಪೇತ್ರಾನಿ ಆನಿ ಯೊಹಾನಾನಿ ತ್ಯಂಚಿವ ಆಪ್ಲ ಹಾತ್ ಥೆವ್ಲ ತವಾ ತ್ಯನಾ ಪವಿತ್ರಾತ್ಮ ಗಾವ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","ಅಪೊಸ್ತಲಾಂಚಾನಿ ಲೊಕಾಂಚಿವ ಹಾತ್ ಥೆವ್ಲಾ ತವಾ ಲೊಕಾನಾ ಪವಿತ್ರಾತ್ಮ ಗಾವಲ್ಯಾಲ ಸಿಮೊನಾನಿ ಬಗ್ಲ ಮನ್ಹುನ್ ಸಿಮೊನ್ ಅಪೊಸ್ತಲಾನಾ ಪೈಸ ದಿವುನ್ ");
INSERT INTO gok_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“ಮಿ ಕುನಾವ ಹಾತ್ ಥೆವ್ತೊ ತ್ಯಲಾ ಪವಿತ್ರಾತ್ಮ ಗಾವಸಾರ ಮನಾ ಬಳ್ ದೆವಾ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","ಫನ್ ಪೇತ್ರಾನಿ ಸಿಮೊನಾಲಾ, “ತು ನಾಸ್ ಹೊ! ತುಜ಼ ಪೈಸ ಹಾಳ್ ವ್ಹವುಂತ! ದೇವಾಚ಼ ವರ ಪೈಶಾನಿ ಗಿಹ್ಯಾಚ಼ ಮನ್ಹುನ್ ತು ಯವಜ಼್ಲಸ್. ");
INSERT INTO gok_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","ಹ್ಯಾ ಕಾಮಾತ್ ತು ಆಮ್ಚಿ ಸಂಗ ಮಿಳಾಯಾ ವ್ಹಯಿತ್ನಾಹಿ. ತುಜ಼ ಮನ್ ದೆವಾಚೆ ನದ್ರಲಾ ಶಾರ್ಕ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","ತುಜ಼ ಮನ್ ಪರತ್! ತು ಕೆಲ್ಯಾಲ್ಯಾ ಬುರಶಾ ಕಾಮಾತ್ನಿ ಪರಾತ್. ಪ್ರಭುಪ ಮಾಗ್ನ ಕರ್, ತು ಆಸ ಯವಸ್‌ತ್ಯಾಲ ತ್ಯೊ ಮಾಪ್ ಕರೀಲ್. ");
INSERT INTO gok_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","ತುಜಾ ಮನಾತ್ ಖುಬ್ ಕಡು ರಾಗ್ ಬರ್‌ಲ್ಯಾಲಾ ಪಾಪಾಚಾ ಬಾದ್ನಾತ್ ಹಾಸ್. ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","ಸಿಮೊನಾನಿ, “ತ್ಯನಾ ದೊಗಾನಾ ಮಾಜಿ ಸಾಟಿ ಪ್ರಭುಪ ಮಾಗ್ನ ಕರಾ. ತುಮಿ ಸಾಂಗ್‌ಲ್ಯಾಲ್ಯಾ ಗುಶ್ಟಿ ಮನಾ ವ್ಹಯಾಚೆ ಆಂದಿ ಮಾಗ್ನ ಕರಾ!” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","ನಂತರ್ ಪೇತ್ರಾ ಆನಿ ಯೊಹಾನಾನಿ ಆಪ್ನು ಬಗ್‌ಲ್ಯಾಲಿ ಯೇಸುಚಿ ಕಾಮ ಲೊಕಾನಾ ಸಾಂಗ್ಲಿತ. ತವಾ ತ್ಯಂಚಾನಿ ಲೊಕಾನಾ ಪ್ರಭುಚಾ಼ ಸಂದೆಶ್ ಸಾಂಗ್ಲಾ. ತ್ಯಾ ನಂತರ್ ತೇ ಯೆರುಸಲೆಮಿಕ್ಡ ಮಾಗಾರ ಆಲ. ವಾಟವ ತೇ ಸಮಾರ‍್ಯಾಚಾ ಖುಬ್ ಗಾವಾತ್ನಿ ಜಾ಼ವುನ್ ಬರಿ ಖಬರ್ ಸಾಂಗ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","ಪ್ರಭುಚಾ಼ ದೇವ್ ದುತ್ ಯೊಕ್ ಪಿಲಿಪ್ಪಾಲಾ, “ತು ತಯಾರ್ ವ್ಹವುನ್ ದಕ್ಷನಾಕ್ಡ ಮಂಜೆ ಯೆರೆಸಲೆಮಿತ್ನಿ ಗಾಜಾಕ್ಡ ಜಾ಼ತ್ಯಾಲ್ಯಾ ರಾನಾಕ್ಡ ಜಾ಼” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","ಮನ್ಹುನ್ ಪಿಲಿಪ ನಿಗುನ್ ಜಾ಼ತಾನಾ ಗರ‍್ಹಾತ್. ಇಥಿಯೊಪಿಚಾ ಯಕಾಲಾ ತ್ಯನಿ ವಾಟವ ಬಗುನ್. ಹ್ಯೊ ಮಾನುಸ್ ನೆಪೊಸಿ ಹುತ್ತಾ. ಇಥಿಯೊಪಿಚಿ ರಾನಿ ಜಾ಼ಲ್ಯಾಲಿ ಕಂದಾಕಿಪ ಹ್ಯೊ ಮುಖ್ಯ ಅಧಿಕಾರಿ ಜಾ಼ಲ್ಥಾ. ಪೈಸ ಸಗ್ಳ ಬಗಾಚಿ ಜವಾಬ್ದಾರಿ ಹ್ಯಚಿಸ್ ಜಾ಼ಲ್ಥಿ. ಹ್ಯೊ ಮಾನುಸ್ ವವ್ಯಾಳಾಯಾ ಸಾಟಿ ಯೆರುಸಲೆಮಿತ್ ಗೆಲ್ತಾ. ಆನಿ ಆತಾ ತ್ಯೊ ಆಪ್‌ಲ್ಯಾ ಗರ‍್ಹಾತ್ ಪರ್ತುನ್ ಜಾ಼ಯಿತಾ. ");
INSERT INTO gok_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ತ್ಯೊ ಆಪ್‌ಲ್ಯಾ ರಥಾವ ಬಸುನ್ ಜಾ಼ತಾನಾ ಯೆಶಾಯಾ ಪ್ರವಾದಿ ಗ್ರಂಥ ವಾಚ್ವಿತಾ. ");
INSERT INTO gok_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","ಪವಿತ್ರಾತ್‌ಮ್ಯಾನಿ ಪಿಲಿಪಾಲಾ, “ರಥಾಪ ಜಾ಼ವುನ್ ತ್ಯಚೆ ಜ಼ವಳ್ ರ‍್ಹಾ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","ತಸಾಸ್ ಪಿಲಿಪ್ ರಥಾಪ ಗೆಲಾ. ತ್ಯೊ ಮಾನುಸ್ ವಾಚಿವ್‌ತ್ಯಾಲಾ ತ್ಯಲಾ ಐಕು ಆಲ. ತ್ಯೊ ಯೆಶಾಯಚ಼ ಪ್ರವಾದನ್ ವಾಚ್ವಿತಾ. ಪಿಲಿಪ್ಪಾನಿ ತ್ಯಲಾ, “ತು ವಾಚಿವ್‌ತ್ಯಾಲ ತುಲಾ ಸಮಾಸ್‌ತ್ಯಾ ಕ್ಯಾ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","ತವಾ ತ್ಯೊ“ಮನಾ ಕಸ ಸಮಜ಼ಲ್? ದುಸ್‌ರ‍್ಯಾನಿ ಕಚಾನಿತರಿ ತ್ಯ ಮನಾ ಸಾಂಗಾಯಾ ವ್ಹಯಿ!”ಮನ್ಲಾ. ಆನಿ, ರಥಾವ ಚ಼ಡುನ್ ಆಪ್ಲಿಪ ಭಸ್ ಎ ಮನ್ಹುನ್ ತ್ಯನಿ ಪಿಲಿಪಾಲಾ ಹಾಕಟ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","ತ್ಯೊ ವಾಚಿವ್‌ತ್ಯಾಲ ಪವಿತ್ರ ಗ್ರಂಥ ಆಸ ಹಾ: ತೊಡಾಯಾ ನೆಥ್ಯಾಲ್ಯಾ ಬಕರ‍್ಯಾಚೆಗತ್ ತ್ಯಲಾ ನೆಲ್ಹಾ; ಆನಿ ಕ್ಯಾಸ್ ಕಾತರತ್ಯಾಲ್ಯಾಚೆ ಮೊರ‍್ಹ ಮೆಂಡ್ರಾಚೆಗತ್ ಕಾಯ್ ಬೊಲಾಚೆ ಆಂದಿ ಗಪ್ ಹುತಾ. ");
INSERT INTO gok_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","ತ್ಯಲಾ ನಿಂದಾ ಕಿಲಿತರಿ. ತ್ಯಲಾ ನ್ಯಾಯಿ ಗಾವ್ಲಾ ನಾಹಿ. ತ್ಯಚೆ ಪಿಳ್ಗಿಚಾ಼ ವರ್ನನ್ ಕೊನ್ ಕರ‍್ನಾರ್? ಕಾ ಮಂಜೆ ದರ್ಥಿವ್ಲಾ ತ್ಯಚಾ಼ ಜೀವ್ನಾ ಸಪ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","ಅಧಿಕಾರಿ ಪಿಲಿಪಾಲಾ, “ದಯಾ ಥಿವುನ್ ಮನಾ ಸಾಂಗ್ ಕಚಾ ಪ್ರವಾದಿಚೆ ಗುಶ್ಟಿತ್ ಹಿತ್ತ ಸಾಂಗ್‌ತ್ಯೊ? ತ್ಯೊ ಆಪ್ಲೆ ಗುಶ್ಟಿತ್ ಸಾಂಗ್‌ತ್ಯೊ ಕ್ಯಾ? ದುಸರ‍್ಯಾಚ಼ ಸಾಂಗತ್ಯೊ” ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","ಪಿಲಿಪಾನಿ ಪವಿತ್ರ ಗ್ರಂಥಾಚಾ ಹ್ಯಾ ಭಾಗಾನಿಸ್ ಯೆಸುಚೆ ಗುಸ್ಟಿತ್ ಬರಿ ಖಬರ್ ತ್ಯಲಾ ಸಾಂಗ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","ತೇ ಜಾ಼ತಾನಾ ಪಾನಿ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ಯಕಾ ತಳ್ಯಾಪ ಆಲ. ತವಾ ಅಧಿಕಾರಿ, “ಬಗ್! ಹಿತ್ತ ಪಾನಿ ಹಾ. ಮಿ ಬಾಪ್ತಿಸ್ಮಾ ಗಿಹ್ಯಾ ಕಾಯ್ತರಿ ಆಡ್ಚ಼ನ್ ಹಾ ಕ್ಯಾ? ಮನ್ಹುನ್ ಪಿಲಿಪ್ಪಾಲಾ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","ತವಾ ಪಿಲಿಪ್ ತ್ಯಲಾ ತು ಪುರ‍್ಯಾ ಮನಾನಿ ಇಸ್ವಾಸಾನಿ ರಾಯ್ಲಾಸ್ತ ತು ಬಾಪ್ತಿಸ್ಮಾ ಗಿಹ್ಯಾ ವ್ಹಯಿಲ್. ತವಾ ಅಧಿಕಾರಿ, “ಯೇಸು ಕ್ರಿಸ್ತ್ ದೇವಾಚಾ಼ ಲ್ಯೊಕ್ ಮನ್ಹುನ್ ಮಿ ಇಸ್ವಾಸ್ ಥೆವ್ತೊ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","ನಂತರ್ ತ್ಯನಿ ರಥ್ ಉಬಕರ್ ಮನ್ಹುನ್ ಆಜ್ಞಾ ದಿಲಿ. ತೆ ದೊಗ ಪಾನ್ಯಾತ್ ಉತಾರ್ಲ, ಪಿಲಿಪ್ಪಾನಿ ತ್ಯಲಾ ಬಾಪ್ತಿಸ್ಮಾ ದಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","ತೆ ಪಾನ್ಯಾತ್ನಿ ವರ್ ಆಲ ತವಾ ಪ್ರಭುಚಾ ಆತ್ಮಾನಿ ಪಿಲಿಪ್ಪಾಲಾ ನೆಲ್ಹಾ. ತ್ಯನಿ ಪಿಲಿಪ್ಪಾಲಾ ಆನಿ ಕಂದಿಸ್ ಬಗ್ಲಾ ನಾಹಿ. ಫನ್ ತ್ಯೊ ಖುಬ್ ಸಂತೊಶಾನಿ ಮೊರ‍್ಹ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","ಫನ್ ಪಿಲಿಪ್ಪ ಅಜೊತ್ ಮಂಥ್ಯಾಲೆ ಪೆಠತ್ ದಿಸ್ಲಾ ತಿತ್ನಿ ಕೈಜ಼ರಾಪರೆತ್ ಸಗ್‌ಳ್ಯಾ ಗಾವಾತ್ನಿ ಬರಿ ಖಬರ್ ಸಾಂಗಿತ್ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","ಸೌಲಾ ಆಜು಼ನ್ ಪ್ರಭುಚಾ ಶಿಶಾಂಚಿವ ರಾಗ್‌ ಥಿವುನ್ ದಮಕಿಚಾ ಬೊಲ್ಯಾ ಬೊಲತ್ ತ್ಯನಾ ಮಾರುನ್ ಟಾಕಾಯಾ ಯವಜು಼ನ್ ಮಹಾ ಯಾಜಕಾಪ ಜಾ಼ವುನ್; ");
INSERT INTO gok_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ಹ್ಯೊ ಮಾರೊಗ್ ದರ್‌ಲ್ಯಾಲ ಗಡಿಮಾನುಸ್ ರಾಹುಂತ, ಬಾಯಿಲ್ಮಾನುಸ್ ವ್ಹವುಂತ ಮೀ ತ್ಯನಾ ಬಾಂದುನ್ ಯೆರುಸಲೆಮಿತ್ ಆನಾಯಾ, ದಮಸ್ಕಾತ್ ಆಸ್‌ಲ್ಯಾಲ ಸಭಾಮಂದಿರಾತ್‍ಲ್ಯಾನಾ ತು, ಪತ್ರ ದಿಯಾ ವ್ಹಯಿ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","ತ್ಯೊ ಪ್ರಯಾನ್ ಕರೀತ್ ದಮಸ್ಕಾಚೆ ಜ಼ವಳ್ ಆಲಾ ತವಾ, ಪಾಕನ್ ಆಬ್ಳಾತ್ನಿ ಯೊಕ್ ಉಜಿಡ್ ತ್ಯಚೆ ಬೌತ ಚ಼ಮಾಕ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","ತ್ಯೊ ಜಿಮ್ನಿವ ಪಡ್ಲಾ ತವಾ, “ಸೌಲಾ, ಸೌಲಾ, ಮನಾ ಕಾ ಜಾ಼ಸ್ ಕರ್ತೊಸ್? ಮನ್ಹುನ್ ಸಾಂಗ್‌ತ್ಯಾಲಾ ಸಬ್ದ ಐಕ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","ತ್ಯಲಾ ಸೌಲಾನಿ; ಪ್ರಭು, ತು ಕೊನ್? ಮನ್ಹುನ್ ಇಚಾರ್ಲ್ಯಾಲ್ಯಾಲಾ ಪ್ರಭುನಿ ಸಾಂಗ್ಲ, ತು ನಿಂದಾ ಕರ್ತ್ಯಾಲಾ ಯೇಸುಸ್ ಮೀ; ");
INSERT INTO gok_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","ಫನ್ ಆತಾ ತು ಉಠುನ್ ಪೆಠತ್ ಜಾ಼, ತು ಕರಾಚ಼ ತಿಥ ತುಲಾ ಸಾಂಗ್ನಾರ್” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","ಸೌಲಾಚೆ ಸಂಗ ಜಾ಼ತ್ಯಾಲ್ಯಾಂಚಾನಿ ಸಬ್ದ ತ್ಯವ್ಡಾಸ್ ಐಕುನ್, ಕಾಯ್ಬಗಾಚೆ ಆಂದಿ ಮುಖ್ಯಾಚೆಗತ್ ಗಾಬ್ರುನ್ ಗಪ್ ಉಬ ರಾಯ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","ಸೌಲಾನಿ ಜಿಮ್ನಿವ್ನಿ ಉಠುನ್ ಡೊಳ ಉಗಡ್ಲ ತವಾ ಕಾಯ್ ದಿಸ್ಲ ನಾಹಿ. ತವಾ ತ್ಯಂಚಾನಿ ತ್ಯಚ಼ಾ ಹಾತ್ ದರುನ್ ದಮಸ್ಕಾತ್ ನೆಲ್ಹಾ. ");
INSERT INTO gok_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","ತ್ಯಲಾ ತೀನ್ ದಿಸಾ ಪರತ್ ಕಾಯ್ ದಿಸ್ಲ ನಾಹಿ. ಆನಿ ತ್ಯೊ ಕಾಯ್ ಖಾಯಾಚೆ ಆಂದಿ ಪಿಯಾಚೆ ಆಂದಿ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","ದಮಸ್ಕಾತ್ ಅನನಿಯಾ ಮಂಥ್ಯಾಲಾ ಯೊಕ್ ಇಸ್ವಾಸಿ ಹುತ್ತಾ; ಪ್ರಭುಚಾ ದರ್ಶನಾತ್, ಅನನೀಯಾ, ಮನ್ಹುನ್ ತ್ಯಲಾ ಹಾಕಟ್‌ಲ್ಯಾಲ್ಯಾಲಾ ತ್ಯೊ; ಪ್ರಭು, ಹಬೊಕ್, ಹಾ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","ಪ್ರಭು ತ್ಯಲಾ, ತು ಉಠುನ್ ನಿಟಪಾಂದಿ ಮಂಥ್ಯಾಲೆ ಪಾಂದಿತ್ ಜಾ಼. ತಿಥ ಯುದಾಚ಼ ಘರ್ ಬಗುನ್ ತಾರ್ಸಾಚಾ ಸೌಲ್ ಮಂಥ್ಯಾಲ್ಯಾಚೆ ಗುಶ್ಟಿತ್ ಇಚಾರ್, ಕಾ ಮಂಜೆ ತ್ಯೊ ತಿಥ ಮಾಗ್ನ ಕರತ್ಯೊ. ");
INSERT INTO gok_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ಅನನಿಯಾ ಮಂಥ್ಯಾಲಾ ಯೊಕ್ ತ್ಯಚೆ ಜ಼ವಳ್ ಯವುನ್ ಆಪ್ಲ ಹಾತ್ ತ್ಯಚಿವ ಥೆವ್ನಾರ್ ತವಾ ತ್ಯಲಾ ಆನಿಕ್ ನದಾರ್ ಯನಾರ್. ಹ್ಯಸ್ ತ್ಯ ದರ್ಶಾನ್ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","ತವಾ ಅನನಿಯಾ, ಪ್ರಭು ಯೇರುಸಲೆಮಿತ್ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ತುಜಾ ಲೊಕಾನಾ ಹ್ಯಾ ಮಾನ್ಸಾನಿ ಕೆಲ್ಯಾಲಿ ಬುರಶಾ ಕಾಮಾಂಚೆ ಗುಶ್ಟಿತ್ ಲೊಕ ಮನಾ ಸಾಂಗ್‌ತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","ತವಾ ತ್ಯೊ ದಮಸ್ಕಾತ್ ಆಲ್ಯಾ, ತುಜ಼ ನಾವ್ ಸಾಂಗ್‌ತ್ಯಾಲ್ಯಾನಾ ಗೆತ್ಯಾಲ್ಯಾ ಸಗ್‌ಳ್ಯಾ ಲೊಕಾನಾ ಕ್ಯೊಂಡ್‌ತ್ಯಾಲಾ ಅಧಿಕಾರ್ ಮುಖ್ಯ ಯಾಜಕಾಂಚಾಪ್ನಿ ಗೆತಲ್ಯಾ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","ಫನ್ ಪ್ರಭು ಅನನೀಯಾಲಾ, “ಜಾ಼! ಮುಖ್ಯ ಕಾಮಾಸಾಟಿ ಮಿ ಸೌಲಾಲಾ ನಿವಡ್‌ಲ್ಯಾ. ತ್ಯನಿ ಮಾಜೆ ಗುಶ್ಟಿತ್ ರಾಜಾನಾ ಯೆಹುದಿ ನಸ್‌ಲ್ಯಾಲ್ಯಾನಾ ಆನಿ ಇಸ್ರಾಯಲ್ ಲೊಕಾನಾ ಸಾಂಗ್‌ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","ತ್ಯೊ ಮಾಜಾ ನಾವಾನಿ ಕರಾಯಾ ವ್ಹಯಿ ಮಂಥ್ಯಾಲಾ ತರಾಸ್ ತ್ಯಲಾ ಮೀ ದ್ಯಾವ್ತೊ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","ಆನಿ ಅನನಿಯ ತಿತ್ನಿ ಯುದಾಚಾ ಗರ‍್ಹಾತ್ ಗೆಲಾ. ತ್ಯನಿ ಸೌಲಾವ ಆಪ್ಲ ಹಾತ್ ಥಿವುನ್ “ಸೌಲಾ ಮಾಜಾ ಬಾವ್ಹಾ ಪ್ರಭು ಯೇಸುನಿ ಮನಾ ಲಾವುನ್ ದಿಲ್ಯಾ. ತು ಹಿತ್ನಿ ಯತಾನಾ ವಾಟವ ಬಗ್‌ಲ್ಯಾಲಾ ತ್ಯಲಾಸ್ ತು ಆನಿಕ್ ನದಾರ್ ಗಿಹ್ಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಪವಿತ್ರಾತ್ಮಾನಿ ಬರ್‌ಲ್ಯಾಲಾ ವ್ಹಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಯೇಸುನಿ ಮನಾ ಲಾವುನ್ ದಿಲ್ಯಾ. ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","ತವಾಸ್ ತ್ಯಚಾ ಡೊಳ್ಯಾತ್ನಿ ಖಪಲಿಚೆಗತ್ ಕ್ಯಾ ಪಡ್ಲ ಸೌಲಾಲಾ ದಿಸಾಯಾ ಲಾಗ್ಲ! ವರ್ ಉಠುನ್ ತ್ಯನಿ ಬಾಪ್ತಿಸ್ಮಾ ಗಿತ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","ನಂತರ್ ತ್ಯನಿ ಖಾವುನ್ ಬಳ್ ಗೆತ್ಲ. ಸೌಲಾಚಾ ದಮಸ್ಕಾತ್ ಶಿಶಾಂಚಿಪ ಥೊಡ ದೀಸ್ ರಾಯ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","ತ್ಯನಿ ತವಾಸ್, ಸಭಾಸ್ಥಾನಾತ್ನಿ ಜಾ಼ವುನ್ ಯೆಸುಚೆ ಗುಶ್ಟಿತ್ ತ್ಯೊಸ್ ದೇವಾಚಾ಼ ಲ್ಯೊಕ್ ಮನ್ಹುನ್ ಸಾಂಗಾಯಾ ಸುರು ಕೆಲ. ");
INSERT INTO gok_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","ಐಕ್‌ಲ್ಯಾಲಿ ಲೊಕ ಸಗ್ಳಿ ಆಜಾಬ್ ವ್ಹವುನ್; ಯೇಸು ಕ್ರಿಸ್ತಾಚ಼ ನಾವ್ ಸಾಂಗ್‌ತ್ಯಾಲ್ಯಾನಾ ಯೆರುಸಲೆಮಿತ್ ನಾಸ್ ಕರ್ತ್ಯಾಲಾ ಹ್ಯೊಸ್! ನವ್ಹ ಕ್ಯಾ? ತಸ್‌ಲ್ಯಾನಾ ಕುಂಡುನ್ ಮುಖ್ಯ ಯಾಜಕಾಂಚಿಪ ನಿಹ್ಯಾವ್ಹಯಿ ಮನ್ಹುನ್ ಹಿತ್ತ ಆಲ್ಯಾಲಾ ನವ್ಹಕ್ಯಾ? ಮನ್ಹುನ್ ಬೊಲತಿತ. ");
INSERT INTO gok_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","ಫನ್ ಸೌಲ್ ಆಜು಼ನ್ಬಿ ಖುಬ್ ಬಳಾಚಾ಼ ವ್ಹವುನ್ ಯೇಸುಸ್ ಕ್ರಿಸ್ತ ಮನ್ಹುನ್ ಖರ ಕರಿತ್. ದಮಸ್ಕಾತಲ್ಯಾ ಯೆಹುದ್ಯಾಂಚಾನಿ ತ್ಯಚಿ ಸಂಗ ವಾದ್ ಕರುನಾಹಿ ಆಸ ಕೆಲ. ");
INSERT INTO gok_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","ಖುಬ್ ದೀಸ್ ಜಾ಼ಲ್ಯಾ ನಂತರ್ ಯೆಹುದ್ಯಾಂಚಾನಿ ಸೌಲಾಲಾ ಮಾರಾಯಾ ಯವಜ್ನಾ಼ ಕಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","ಯೆಹುದಿ ಸೌಲಾಲಾ ಬಗಿತ್ ಪೆಠಚಿ ದಾರ ರ‍್ಯಾತ್ ದಿಸಿ ರಾಕಿತ. ಫನ್ ತೀ ಯವಜ್ನಾ಼ ಸೌಲಾಲಾ ಸಮಾಜ಼್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","ಯಕಸಿ ರ‍್ಯಾಚ಼, ಸೌಲಾಲಾ ಥೊಡ ಶಿಶಾ ಪೆಠತ್ನಿ ಬಾಹಿರ್ ಲಾವುನ್ ದಿಯಾಸಾಟಿ ಯಕ ಬುಟ್ಟಿತ್ ಬಸ್ವುನ್, ಬಿಥಿ ಬರ‍್ಬರ‍್ನಿ ಖಾಲ್ ಉತ್ತರ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","ಸೌಲ್ ಯೆರುಸಲೆಮಿತ್ ಗೆಲಾ. ತ್ಯನಿ ಇಸ್ವಾಸಿಂಚ಼ ಸಮುದಾಯತ್ ಮಿಳಾಯಾ ಯತ್ನ ಕಿಲಿತ. ಫನ್ ತೇ ಸಗ್ಳ ತ್ಯಲಾ ಬಿಹ್ಯಾಲ. ಸೌಲಾ ಖರ‍್ಯಾನಿಸ್ ಯೇಸುಚಾ಼ ಶಿಶಾ ಮನ್ಹುನ್ ಇಸ್ವಾಸ್ ನವ್ಥಾ. ");
INSERT INTO gok_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","ಫನ್ ಬಾರ್ನಬ ತ್ಯಚೆ ಮಜ಼ತಿಲಾ ಯವುನ್ ಸೌಲಾಲಾ ಅಪೊಸ್ತಲಾಂಚಿಪ ಗಿಹುನ್ ಆಲಾ. ತ್ಯನಿ ದಮಸ್ಕಾಚೆ ವಾಟವ ಪ್ರಭುಲಾ ಬಗ್‍ಲ್ಯಾಲ ಪ್ರಭುನಿ ತ್ಯಚಿ ಸಂಗ ಬೊಲ್ಯಾಲ ತ್ಯನಾ ಸಾಂಗ್ಲ. ಆನಿ ತ್ಯನಿ ದಮಸ್ಕಾತ್ ಲೊಕಾನಾ ಯೇಸುಚಾ ನಾವಾನಿ ಭೆ ನಸ್ತಾನಾ ಸಾಂಗಿತಾ. ");
INSERT INTO gok_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","ತವಾಚಾನ್ ಸೌಲ್ ಇಸ್ವಾಸಿಂಚೆ ಸಂಗ ಹುತ್ತಾ. ತ್ಯನಿ ಪ್ರಭುಚಾ ನಾವಾನಿ ಯೆರುಸಲೆಮಿತ್ ದಿರ‍್ಹಾನಿ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","ಗ್ರೀಕ್ ಬೊಲ್‌ತ್ಯಾಲ್ಯಾ ಯೆಹುದ್ಯಾಂಚಿ ಸಂಗ ಬೊಲತ್ ಸೌಲ್ ವಾದ್ ಗಾಲ್ಹಿತಾ. ಫನ್ ತೆ ತ್ಯಲಾ ಮಾರುನ್ ಟಾಕಾಯಾ ಯತ್ನ ಕರಿತ. ");
INSERT INTO gok_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","ಹ್ಯ ಇಸ್ವಾಸಿನಾ ಸಮಾಜ಼್ಲ ತವಾ ತ್ಯಂಚಾನಿ ಸೌಲಾಲಾ ಸೆಜರೆಯ ಪೆಠತ್ ನೆಲಾ. ತಿತ್ನಿ ತಾರ್ಸತ್ ಪೆಠತ್ ಲಾವುನ್ ದಿಲ. ");
INSERT INTO gok_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","ಆಸ ಆಸ್ಥಾನಾ ಯುದಾಯ್ ಗಲಿಲಾಯ್ ಆನಿ ಸಮಾರ‍್ಯಾ ಪೆಠತ್ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ಸಬೆ ಸಮಾದಾನ್ ಜಾ಼ಲತ್ಯಾ. ಪವಿತ್ರಾತ್ಮಾಚೆ ಮಜ಼ತಿನಿ ಸಬೆ ಬಕ್ತಿತ್ ಬಳಕಾಟುನ್ ದೆವಾಲಾ ಬಿಹುನ್ ಚಾ಼ಲತ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","ಪೇತ್ರಾ ಸಗ್‌ಳ್ಯಾ ಗಾವಾತ್ನಿ ಫಿರತ, ಯಕಾ ಯಳಾತ್ ಲುಧಾತ್ ರಾಥ್ಯಾಲ್ಯಾ ದೇವಾಚಾ ಲೊಕಾನಾ ಭೆಟ್ ಜಾ಼ಲ್ಹಾ. ");
INSERT INTO gok_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","ತಿಥ ಪಾರ್ಶ್ವವಾಯ್ ರೊಗಿ ವ್ಹವುನ್ ಆಟ್ ವರ್ಸಾನಿ ಹಾತ್ರುನಾವ ಪಡ್‌ಲ್ಯಾಲಾ ಐನೆಯ ಮಂಥ್ಯಾಲ್ಯಾ ಯಕಾ ಮಾನ್ಸಾಲಾ ಬಗ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","ಪೇತ್ರಾನಿ ತ್ಯಲಾ, “ಐನೇಯಾ, ಯೇಸು ಕ್ರಿಸ್ತ ತುಲಾ ಬರ ಕರ‍್ನಾರ್; ಉಠುನ್ ತುಜ಼ ಹಾತ್ರುನ್ ಕಾಡುನ್ ಥೆವ್!” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ ತವಾಸ್ ಐನೆಯ ಉಬಾ ರಾಯ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","ಲುಧಾತ್ ಆನಿ ಸಾರೊನಿಪ ರಾಥ್ಯಾಲ್ಯಾ ಸಗ್‌ಳ್ಯಾ ಲೊಕಾಂಚಾನಿ ತ್ಯಲಾ ಬಗುನ್ ಪ್ರಭು ಯೇಸುವ ಇಸ್ವಾಸ್ ಥೆವ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","ಯೊಪ್ಪ ಪೆಠತ್ ತಬಿಥಾ ಮಂಥ್ಯಾಲಿ ಯೆಕ್ ಇಸ್ವಾಸಿ ಹುತ್ತಿ. ಗ್ರೀಕ್ ಬಾಶೆತ್ ತಿಚ಼ ನಾವ್ ದೊರ್ಕಾ ಮಂಜೆ ಚಿ಼ತ್ತಾಳ್. ತೀ ಲೊಕಾನಾ ಕವಾಬಿ ಚಾ಼ಂಗ್ಲ ಕಾಮ್ ಕರಿತಿ. ತೀ ಗರೀಬ್ ಲೊಕಾನಾ ಮಜ಼ತ್ ಕರೀತಿ. ");
INSERT INTO gok_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","ಪೆತ್ರಾ ಲುಧಾತ್ ಆಸ್ಥಾನಾ ಸೀಕ್ ಯವುನ್ ಮರುನ್ ಗಿಲಿ. ಲೊಕಾಂಚಾನಿ ತಿಚ಼ ಮಡ ದುಹುನ್ ವೈಲೆ ಮಾಳಿವಲ್ಯಾ ಯಕ ಖುಲಿತ್ ಥೆವ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","ಪೇತ್ರಾ ಲುಧಾತ್ ಹಾ ಮನ್ಹುನ್ ಬಾತ್ನಿ ಇಸ್ವಾಸಿ ಲೊಕಾನಾ ಯೊಪ್ಪಾತ್ ಸಮಾಜ಼್ಲ. ಲುಧಾ ಯೊಪ್ಪಾಚೆ ಕಡಸ್ ಹಾ. ಮನ್ಹುನ್ ತ್ಯಂಚಾನಿ ದೊಗಾನಾ ಪೆತ್ರಾಪ ಲಾವುನ್ ದಿಲ. ತ್ಯಂಚಾನಿ “ಥಾಂಬಾಚೆ ಆಂದಿ ಆಮ್ಚಿಪ ಎ” ಮನ್ಹುನ್ ಬಾತ್ನಿ ಲಾವುನ್ ದಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","ಪೇತ್ರಾ ತಯಾರ್ ವ್ಹವುನ್ ತ್ಯಂಚಿ ಸಂಗ ಗೇಲಾ. ತ್ಯೊ ತಿಥ ಪೊಚ಼್ಲಾ ತವಾ. ತ್ಯಂಚಾನಿ ತ್ಯಲಾ ವರ್ ಮಾಳಿಚಾ ಯಕಾ ಸೊಪ್ಯಾತ್ ಗಿಹುನ್ ಗೆಲ. ವಿದ್ವಾ ಸಗ್‌ಳ್ಯಾ ರಡತ್ ಪೇತ್ರಾಚೆ ಸರ್ಬೌತ್ಯಾ ಆಲ್ಯಾ. ಜಿತ್ತಿ ಆಸ್ತಾನಾ ಆಪ್ಲಿಸಾಟಿ ತಯಾರ್ ಕರಾಯಾ ಕೆಲ್ಯಾಲಾ ಜ಼ಘಾ ಅನಿ ಪೊಶಕ್ ತ್ಯಂಚಾನಿ ಪೇತ್ರಾಲಾ ದ್ಯಾವ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","ಪೇತ್ರಾನಿ ಸಗ್‌ಳ್ಯಾ ಲೊಕಾನಾ ಖುಲಿತ್ನಿ ಬಾಹಿರ್ ಗಾಲುನ್ ಡೊಗ್ಲ ಮುಡುನ್ ಮಾಗ್ನ ಕೆಲ. ನಂತರ್ ತ್ಯೊ ಮಡ್ಯಾಕ್ಡ ಪರ್ತುನ್ ತಬಿಥಾ ವರ್ ಉಟ್ ಮನ್ಲಾ. ತಿನಿ ಆಪ್ಲ ಡೊಳ ಉಗ್ಡುನ್ ಪೆತ್ರಾಲಾ ಬಗುನ್ ಉಠುನ್ ಬಸ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","ತ್ಯನಿ ಹಾತ್ ದಿವುನ್ ಉಠುನ್ ಉಬಿ ರಾಹ್ಯಾ ತಿಲಾ ಮಜ಼ತ್ ಕಿಲಿ. ನಂತರ್ ತ್ಯನಿ ಆಪ್‌ಲ್ಯಾ ಇಸ್ವಾಸಿನಾ ಆನಿ ವಿದ್ವಾನಾ ಖುಲಿತ್ ಹಾಕ್ಟುನ್ ತ್ಯನಾ ತಭಿಥಳಾಲಾ ದ್ಯಾವ್ಲಿ. ತೀ ಜಿಥಿ ಜಾ಼ಲ್ಥಿ. ");
INSERT INTO gok_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","ಯೊಪ್ಪಾತ್ ಸಗ್ಳಿಕ್ಡ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ಲೊಕಾನಾ ಹಿ ಬಾತ್ನಿ ಸಮಾಜ್ಲಿ. ಆನಿ ಖುಬ್ ಜ಼ನಾಂಚಾನಿ ಪ್ರಭುವ ಇಸ್ವಾಸ್ ಥೆವ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","ಪೇತ್ರಾ ಖುಬ್ ದಿಸಾ ಪರತ್ ಯೊಪ್ಪಾತ್ ಹುತ್ತಾ. ಚ಼ಮ್‌ಡ್ಯಾಚ಼ ಕಾಮ್ ಕರತ್ಯಾಲ್ಯಾ ಸಿಮೊನ ನಾವಾಚಾ ಚಾ಼ಂಬಾರಾಚಾ ಗರ‍್ಹಾತ್ ತ್ಯೊ ಖುಬ್ ದಿಸ್ ರಾಯಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","ಸೆಜ಼ರಿಯ ಪೆಠತ್ ಕೊರ‍್ನೆಲ್ ಮಂತ್ಯಾಲಾ ಹುತ್ತಾ. ಇಟಲಿಯಾ ಸೈನ್ಯಾತ್ಲಾ ತ್ಯೊ ಶತಾಧಿಪತಿ ಜಾ಼ಲ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","ತ್ಯೊ ದೇವಾಚಾ಼ ಬಘತ್ ಜಾಲ್ಥಾ. ತ್ಯೊ ಆನಿ ತ್ಯಚಾ ಕುಟ್ಮಾತ್ಲಿ ಸಗ್ಳಿ ಜ಼ನ ದೇವಾಲಾ ವವ್ಯಾಳಿತಿತ. ತ್ಯೊ ಗರಿಬಾನಾ ದಾನ್ ಧರ್ಮ ಕರಿತಾ. ಖಾಯಿಮ್ ದೇವಾಪ ಮಾಗ್ನ ಕರಿತಾ. ");
INSERT INTO gok_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","ಯಕಸಿ ದೊಪಾರಿ ಜ಼ವಜ಼ವಳ್ ತೀನ್ ಗಂಟ್ಯಾಲಾ ಕೊರ್ನೆಲಾಲಾ ಯಾಕ್ ದರ್ಶಾನ್ ಜಾ಼ಲ್ಹ. ತ್ಯಾ ದರ್ಶಾನಾತ್ ಯೊಕ್ ದೇವ್ ದುತ್ ತ್ಯಚಿಪ ಯವುನ್, “ಕೊರ್ನೆಲಾ” ಮನ್ಹುನ್ ಹಾಕಟ್ಲ ತ್ಯ ತ್ಯನಿ ಚಾ಼ಂಗ್ಲ ಬಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","ಕೊರ್ನೆಲ್ ದೆವ್ ದುತಾಲಾ ಬಗುನ್ ಬಿಹುನ್ “ಸ್ವಾಮಿ, ಹ್ಯ ಕ್ಯಾ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ದೇವ್ ದುತಾನಿ, “ದೇವಾನಿ ತುಜ಼ ಮಾಗ್ನ ಐಕ್‌ಲ್ಯಾ ತು ಗರಿಬಾನಾ ದಿಲ್ಯಾಲ ತ್ಯನಿ ಬಗ್‌ಲ್ಯಾ ತು ದೆವಾಚಾ ಮನಾಸ್ ಆಲ್ಯಾಸ್. ");
INSERT INTO gok_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","ಆತಾ ಪೇತ್ರಾ ಮನ್ಹುನ್ ಹಾಕಟ್ಯಾಲ್ಯಾ ಸಿಮೊನ್ ಮಂಥ್ಯಾಲ್ಯಾ ಮಾನ್ಸಾಲಾ ಹಾಕ್ಟುನ್ ಆನಾಯಾ ತು ಲೊಕಾನಾ ಆತಾ ಯೊಪ್ಪ ಪೆಠತ್ ಲಾವುನ್ ದೆ. ");
INSERT INTO gok_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","ಸಿಮೊನ್ ಚಾ಼ಂಬ್ರಾಚಾ ಗರ‍್ಹಾತ್ ಹಾ. ತ್ಯಚ಼ ಗ್ಹರ್ ಸಮಿಂದೊರಾಚೆ ಜ಼ವಳ್ ಹಾ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","ಕೊರ್ನೆಲಾಸಂಗ ಬೊಲ್ಯಾಲಾ ದೆವ್ದುತ್ ಗೇಲಾ. ಮಂಗ್ ತ್ಯನಿ ಆಪ್‌ಲ್ಯಾ ಸೆವಕಾತ್‌ಲ್ಯಾ ದೊಗಾನಾ ಆನಿ ಕವಾಬಿ ಆಪ್ಲಿ ಸಂಗ ರಾಥ್ಯಾಲ್ಯಾ ಯಕಾ ಸಿಪಾಯಿಲಾ ಹಾಕಟ್ಲ. ಹ್ಯೊ ಸಿಪಾಯಿ ದೇವಾಚಾ಼ ಬಘತ್ ಜಾ಼ಲ್ಥಾ. ತ್ಯೊ ಮಜ಼ತ್ ಕರ್ತ್ಯಾಲ್ಯಾತ್ ಹ್ಯೊಬಿ ಯೊಕ್ ಜಾ಼ಲ್ಥಾ. ");
INSERT INTO gok_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","ಕೊರ್ನೆಲಾನಿ ಹ್ಯಾ ತಿಗಾನಾ ಸಗ್ಳ ಉಗಡುನ್ ಸಾಂಗ್ಲ ಆನಿ. ತ್ಯನಾ ಯೊಪ್ಪಾತ್ ಲಾವುನ್ ದಿಲ. ");
INSERT INTO gok_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","ದುಸ್ರೆ ದಿಸಿ ತೇ ಯೊಪ್ಪಾಚೆ ಜ಼ವಳ್ ಗೆಲ ತವಾ ದೊಪ್ಯಾರ್ ಜಾ಼ಲ್ಥಿ. ತವಾ ಪೆತ್ರಾ ಮಾಗ್ನ ಕರಾಯಾ ಮಾಳಿವ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","ಪೆತ್ರಾಲಾ ಬುಖನಿ ಖಾವುಸ ವಾಟಾಯಾ ಲಾಗ್ಲ. ತಿಥ ತ್ಯಚಿಸಾಟಿ ಜೆವಾನ್ ಕರಿತ, ಹಿತ ಪೆತ್ರಾಲಾ ಯಾಕ್ ದರ್ಶಾನ್ ಜಾ಼ಲ. ");
INSERT INTO gok_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","ಆಬಾಳ್ ಉಗ್ಡುನ್ ಕಸ್ಲಾ ಯೊಕ್ ಜಿನೊಸ್ ಉತ್ರುನ್ ಯತ್ಯಾಲಾ ತ್ಯನಿ ಬಗ್ಲಾ ತ್ಯ ಮೊಟೆ ತಾಟಚೆಗತ್ ಹುತ್ತ. ತ್ಯಚಾ ಚಾರಿ ಕೊನ್ಯಾನಾ ದೊರ‍್ಯಾ ಬಾಂದುನ್ ದರ್ಥಿವ ಉತ್ತರ್ಲ ಹುತ್ತ. ");
INSERT INTO gok_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","ತ್ಯಾತ್ ಚಾರ್ ಪಾಯಾಚಿ ಜ಼ನಾವಾರ ಹುತ್ತಿತ. ಪ್ವಾಟ್ ಲಾವುನ್ ಜಾ಼ತ್ಯಾಲಿ ಆನಿ ಕಿಡ ಆನಿ ಫುರ್ಕಾನಿ ಗೆಥ್ಯಾಲಿ ಪಾಕ್ರ ಹುತ್ತಿತ. ");
INSERT INTO gok_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","ತವಾ ಪೇತ್ರಾಲಾ: ಉಟ್! ಕಾಪುನ್ ಖಾ” ಮನ್ಹುನ್ ಸಬ್ದ ಆಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","ಫನ್ ಪೇತ್ರಾ, “ಪ್ರಭು ಮಿ ತಸ ಕರ್ನಾರ್ ನಾಹಿ! ಬಾಟ್‌ಲ್ಯಾಲ ಆನಿ ಬಾಟ್‌ಲ್ಯಾ ನಸ್‌ಲ್ಯಾಲ ಮಿ ಕಂದಿಸ್ ಖಾಲ್ಯಾಲ ನಾಹಿ. ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","ಫನ್ ತ್ಯಾ ಆವಾಜಾ಼ನಿ ತ್ಯಲಾ ಆನಿ ಸಾಂಗ್ಲ, “ದೇವಾನಿ ಹ್ಯ ಸಗ್ಳ ಚಾ಼ಂಗ್ಲ ಕೆಲ್ಯಾ ಪವಿತ್ರ ನಸ್‍ಲ್ಯಾಲ ಮನ್ಹು ನಕೊಸ್. ” ");
INSERT INTO gok_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","ಆಸ ತೀನ್ ಖೆಪಾ ಜಾ಼ಲ್ಹ. ತವಾಸ್ ತ್ಯ ಸಗ್ಳ ವರ್ ಅಬ್ಳಾತ್ ಮಾಗಾರ ನೆಲ್ಹ. ");
INSERT INTO gok_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","ಪೇತ್ರಾ ಆಪ್ನು ಬಗ್‌ಲ್ಯಾಲ್ಯಾ ದರ್ಶನಾಚಾ಼ ಅರ್ಥ ಕ್ಯಾ ಆಸಲ್ ಮನ್ಹು‍ನ್ ಆಜಾಬ್ ಜಾ಼ಲ್ಹಾ. ತ್ಯವ್‌ಡ್ಯಾತ್ ಮಂಜೆ, ಕೊರ್ನೆಲಾನಿ ಲಾವುನ್ ದಿಲ್ಯಾಲ ಮಾನುಸ್‍ ಸಿಮೊನಾಚಾ ಗರ‍್ಹಾಪ ಯವುನ್ ಬೆಡ್ಯಾಪ ಉಬ ರಾಹುನ್, ");
INSERT INTO gok_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","ಹಾಳಿ ಮಾರುನ್, “ಸಿಮೊನ್ ಪೇತ್ರಾ ಹಿತ್ತ ಹಾ ಕ್ಯಾ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","ಪೇತ್ರಾ ಆಜು಼ನ್ ದರ್ಶಾನಾಚಿ ಯವಜ್ನಾ಼ ಕರೀತ್ ಹುತ್ತಾ. ಫನ್ ಪವಿತ್ರಾತ್ಮಾನಿ ತ್ಯಲಾ, “ತುಲಾ ತೀಗ ಸುದಿತ್ ಆಲ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","ತು ಖಾಲ್ ಜಾ಼ವುನ್ ತ್ಯಂಚಿ ಸಂಗ ಜಾ಼ಯಾ ಮಾಗ ಸರುನಕೊ ಮಿಸ್ ತ್ಯನಾ ತುಜಿಪ ಲಾವುನ್ ದಿಲ್ಯಾತ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","ಮನ್ಹುನ್ ಪೇತ್ರಾ ಖಾಲ್ ಉತ್ರುನ್ ತ್ಯಾ ಮಾನ್ಸಾಂಚಿಪ ಜಾ಼ವುನ್, “ತುಮಿ ಶೊತ್ಯಾಲಾ ಮಾನುಸ್ ಮಿಸ್, ತುಮಿ ಹಿತ್ತ ಕಾ ಆಲ್ಯಾಸಾ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","ತ್ಯಂಚಾನಿ ಉತ್ತರ್ ದಿಲಾ, “ಕೊರ್ನ್ಯೊಲ್ ಮಂಥ್ಯಾಲಾ ಶತಾದಿಪತಿ. ತ್ಯೊ ಧಾರ್ಮಿಕ್ ಮಾನುಸ್ ದೇವಾಲಾ ವವ್ಯಾಳ್‌ತ್ಯಾಲಾ ಯೆಹುದಿ ಲೊಕ ತ್ಯಲಾ ಮರ‍್ಯಾದ್ ದೆತ್ಯಾತ, ತು ಸಾಂಗ್‌ತ್ಯಾಲ್ಯಾ ಗುಶ್ಟಿ ಐಕಾಯಾ ವ್ಹಯಿತಾ ಮನ್ಹುನ್ ತುಲಾ ಆಪ್‌ಲ್ಯಾ ಗರ‍್ಹಾತ್ ಹಾಕ್ಟುನ್ ಆನಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಯಕಾ ದೇವ್ ದುತಾನಿ ಕೊರ್ನೆಲಾಲಾ ಸಾಂಗ್‌ಲ್ಯಾ” ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","ಪೇತ್ರಾನಿ ತ್ಯನಾ ಆತ್‌ ಹಾಕ್ಟುನ್ ತೇ ರಾತಿಲಾ ತಿಥ ರಾಹ್ಯಾ ಸಾಂಗಲ ದುಸ್ರೆ ದಿಸಿ ಪೇತ್ರಾ ತಯಾರ್ ವ್ಹವುನ್ ತ್ಯಾ ತಿಗಾಂಚೆ ಸಂಗ ನಿಗಾಲಾ ಯೊಪ್ಪತ್ಲಿ ಥುಡಿ ಇಸ್ವಾಸಿ ತ್ಯಚಿ ಸಂಗ ಗಿಲಿತ. ");
INSERT INTO gok_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","ದುಸ್ರೆ ದಿಸಿ ತೇ ಸಜ಼ರೇಯ ಪೆಠತ್ ಪೊಚ಼್ಲ ಕೊರ್ನೆಲಿಯಾ ತ್ಯಂಚಿಸಾಟಿ ಆಪ್‌ಲ್ಯಾ ಪಾವ್‌ನ್ಯಾನಾ ಸೊಪ್‌ತ್ಯಾನಾ ಆಪ್‌ಲ್ಯಾ ಗರ‍್ಹಾತ್ ಹಾಕ್ಟುನ್ ತಿಥ ರಾಖಿತಾ. ");
INSERT INTO gok_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","ಪೇತ್ರಾ ಗರ‍್ಹಾತ್ ಆಲಾ ತವಾ ತ್ಯೊ ಪೆತ್ರಾಲಾ ಬೆಠಾಯಾ ಗೆಲಾ. ಆನಿ ಪೆತ್ರಾಚಾ ಪಾಯಾ ಪಡುನ್ ತ್ಯನಿ ನಮಸ್ಕಾರ್ ಕೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","ಫನ್ ಪೇತ್ರಾನಿ ತ್ಯಲಾ ಉಚ಼್ಲುನ್, “ಉಟ್! ಮೀ ತುಜಿಗತ್ ಯೊಕ್ ಮಾನುಸ್” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","ಪೇತ್ರಾ ಕೊರ್ನೆಲಾ ಸಂಗ ಬೊಲತ್ ಆತ್ ಗೇಲಾ ತವಾ. ತಿಥ ಜ಼ಮ್‌ಲ್ಯಾಲ್ಯಾ ಖುಬ್ ಲೊಕಾಂಚಾ಼ ಹಿಂಡ್ ಬಗ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","ಪೇತ್ರಾ ತ್ಯನಾ. ಯೊಕ್ ಯೆಹುದಿ ದಿಸರ‍್ಯಾ ಲೊಕಾಂಚೆ ಸಂಗ ಸಮನ್ ಜೊಡ್‌ತ್ಯಾಲಾ ನಾಹಿತ ತ್ಯಂಚಿ ಭೆಟ್ ಗೆಥ್ಯಾಲಾ ಆಮ್ಚಾ ಯೆಹುದಿ ಧರ್ಮಶಾಸ್ತಾರಾಲಾ ವಿರುದ್ ಹಾತ್ಯ ಠಾವ ಹಾ. ಫನ್ ಕಚಾ ಮಾನ್ಸಾಲಾ (ಅಪವಿತ್ರ ನಾಹಿತ ಅಶುದ್ದ) ಮನ್ಹಾಚ಼ ನಾಹಿ ಮನ್ಹುನ್ ದೆವಾನಿ ಮನಾ ದಾವುನ್ ದಿಲ್ಯಾ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","ಮನ್ಹುನ್ ಮನಾ ಹಿತ್ತ. ಹಾಕ್ಟಾಯಾ ಆಲ್ಯಾಲ್ಯಾ ಲೊಕಾಂಚೆ ಸಂಗ ಮಿ ವಾದ್ ಕೆಲಾ ನಾಹಿ. ಫನ್ ಆತಾ ತುಮಿ ಮನಾ ಕಶಾಲಾ ಹಾಕಟ್‌ಲ್ಯಾಸಾ? ತ್ಯ ಆಂದಿ ಸಾಂಗಾ. ” ಮನ್ಲಾ ");
INSERT INTO gok_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","ತವಾ ಕೊರ್ನೆಲ, “ತಿನ್ ದಿಸಾಚೆ ಮಾಗ ಮೀ ಮಾಜಾ ಗರ‍್ಹಾತ್ ಮಾಗ್ನ ಕರಿತೊ ತವಾ ದೊಪ್ಯಾರ್ಚ಼ ತೀನ್ ಗಂಟ ವ್ಹಯಾ ಆಲ್ತ. ಗಾಪ್ಕನ್ ಯೊಕ್ ಮಾನುಸ್ ಮಾಜೆ ಮೊರ‍್ಹ ಉಬಾರಾಯ್ಲಾ ತ್ಯನಿ ಗ್ಯಾತ್‌ಲ್ಯಾಲ ಕಪ್ಡ ಚ಼ಕ್ಮಕಿತ. ");
INSERT INTO gok_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ತ್ಯೊ ಮಾನುಸ್. ‘ಕೊರ್ನೆಲಾ! ದೇವಾನಿ ತುಜ಼ ಮಾಗ್ನ ಐಕ್‌ಲ್ಯಾ ತು ಗರಿಬಾನಾ ದಿಲ್ಯಾಲ ದೇವಾಪ ಗೆಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","ಮನ್ಹು‍ನ್ ಥೊಡ್ಯಾನಾ ಯೊಪ್ಪಾ ಪೆಠತ್ ಲಾವುನ್ ದಿವುನ್ ಸಿಮೊನ್ ಮಂಥ್ಯಾಲ್ಯಾ ಪೆತ್ರಾಲಾ ಯಯಾಸಾಂಗ್ ತ್ಯೊ ಸಿಮೊನ ಚಾ಼ಂಬಾರಾಚಾ ಗರ‍್ಹಾತ್ ಹಾ. ತ್ಯಚ಼ ಘರ್ ಸಮಿಂದೊರಾಚೆ ಕಡಸ್ ಹಾ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","ಮನ್ಹುನ್, ಮಿ ತವಾಸ್ ತುಲಾ ಹಾಕ್ಟಾಯಾ ಲಾವುನ್ ದಿಲ. ತು ತಿಥ ಆಲ್ಯಾಲಾ ಖುಬ್ ಬರ ಜಾ಼ಲ್ಹ. ಆಮಾನಾ ಸಾಂಗಾಯಾ ವ್ಹಯಿ ಜಾ಼ಲ್ಯಾಲ ಪ್ರಭುನಿ ತುಲಾ ಸಾಂಗ್‌ಲ್ಯಾಲ ಸಗ್ಳ. ಐಕಾಯಾ ಆಮಿ ಸಗ್ಳಿ, ದೇವಾಪ ಜ಼ಮ್‌ಲ್ಯಾವ್” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","ಪೇತ್ರಾನಿ ಬೊಲ್ನ ಸುರು ಕರುನ್ ಆಸಾ ಮನ್ಲಾ, “ದೇವ್ ಸಗ್‌ಳ್ಯಾನಾ ಯೇಕುಸ್ ತರನಿ ಬಗ್ತೊ ಮನ್ಹುನ್ ಮನಾ ಆತ್ತಾ ಸಮಾಜ಼್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","ಆಪ್‌ಲ್ಯಾಲಾ ವವ್ಯಾಳ್‍ತ್ಯಾಲಿ ನಿಯತಿಚಿ ಕೊನ್ ಆಸ್ಲಿತ ತರಿ ದೇವ್ ತ್ಯನಾ ಗೆಥೊ. ತ್ಯೊ ಕಚೆ ಜಾ಼ತಿತ್ಲಾ ಮನ್ಹುನ್ ಸಂಬಂದ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","ದೇವ್ ಇಸ್ರಾಯಲ್ ಲೊಕಾಂಚೆ ಸಂಗ ಬೊಲ್ಯಾ ಯೇಸು ಕ್ರಿಸ್ತಾಪ್ನಿ ಸಮಾದಾನಾಚಿ ಬರಿ ಖಬರ ದೇವಾನಿ ತ್ಯನಾ ಲಾವುನ್ ದಿಲಿ. ಯೇಸು ಸಗ್‌ಳ್ಯಾ ಲೊಕಾನಾ ಪ್ರಭು ಜಾ಼ಲ್ಯಾ! ");
INSERT INTO gok_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","“ಯುದಾಯಾ ಸಿಮತ್ ಕ್ಯಾ ಜಾ಼ಲ್ಹ ತ್ಯ ತುಮಾನಾ ಠಾವ ಹಾ ಗಲಿಲಾಯಾತ್ ಯೊಹಾನಾನಿ ಬಾಪ್ತಿಸ್ಮಾಚೆ ಗುಶ್ಟಿತ್ ಲೊಕಾನಾ ಸಿಕಿವ್‌ಲ್ಯಾ ನಂತರ್, ");
INSERT INTO gok_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","ನಜ಼ರೇತಿಚಾ ಯೇಸುಲಾ ದೇವಾನಿ ಪವಿತ್ರಾತ್ಮ, ಬಳ್ ದಿವುನ್ ತ್ಯಲಾ ಅಭಿಶೇಕ್ ಕೆಲ್ಯಾ. ತ್ಯೊ ಸಗ್ಳಿಕ್ಡ ಲೊಕಾನಾ ಬರ ಕರೀತ್ ಗೆಲಾ. ಬುಥ ಲಾಗ್‌ಲ್ಯಾನಾ ತ್ಯನಿ ಬರ ಕೆಲ. ಕಾ ಮಂಜೆ ದೆವ್ ತ್ಯಚಿ ಸಂಗ ಹಾ ಮನ್ಹುನ್ ಹ್ಯ ದಾವುನ್ ದೆತ. ");
INSERT INTO gok_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“ಯದಾಯ್ ಸಿಮತ್ ಆನಿ ಯೆರುಸಲೆಮಿತ್ ತ್ಯನಿ ಕೆಲ್ಯಾಲಿ ಸಗ್ಳಿ ಕಾಮ ಆಮಿ ಬಗ್‌ಲ್ಯಾತ. ತ್ಯಂಚಿಸಾಟಿ ಆಮಿ ಸಾಕ್ಷಿ ಹಾವ್. ಫನ್ ಯೆಸುಲಾ ಶಿಲ್ಬೆವ ಗಾಲ್ಹುನ್ ತ್ಯಲಾ ಮಾರುನ್ ಟ್ಯಾಕ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","ಫನ್ ದೇವಾನಿ ತ್ಯಲಾ ತಿನ್ವೆ ದಿಸಿ ಮರ್ನಾತ್ನಿ ಜಿ಼ತ್ತಾ ಕರುನ್ ಉಠಿವ್ಲಾ! ಆನಿ ತ್ಯೊ ದಿಸಚಾ಼ ಕೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","ಫನ್ ತ್ಯೊ ಸಗ್‌ಳ್ಯಾ ಲೊಕಾನಾ ದಿಸ್ಲಾ ನಾಹಿ. ದೇವಾಪ್ನಿ ಆಂದಿಸ್ ಸಾಕ್ಷಿಸಾಟಿ ಥರಿವ್‌ಲ್ಯಾಲ್ಯಾಂಚಾನಿ ತ್ಯವ್ಡಾಸ್ ತ್ಯಲಾ ಬಗ್ಲಾ! ಯೇಸು ಮರ್ನಾತ್ನಿ ಜಿ಼ತ್ತಾ ವ್ಹವುನ್ ಆಲ್ಯಾ ನಂತರ್ ಆಮಿ ತ್ಯಚಿ ಸಂಗ ಖಾಲ ಪಿಲ. ");
INSERT INTO gok_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","“ಲೊಕಾನಾ ಸಾಂಗಾಯಾ ವ್ಹಯಿಸಾ ಮನ್ಹುನ್ ತ್ಯನಿ ಆಮಾನಾ ಸಾಂಗ್ಲ ಜಿತ್ತಿ ಆಸ್‌ಲ್ಯಾಲ್ಯಾನಾಬಿ ಮೆಲ್ಯಾಲ್ಯಾನಾಬಿ ದೇವಾನಿ ಥರಿವ್‌ಲ್ಯಾಲಾ ನ್ಯಾಯಾದಿಪತಿ. ಆಪ್ನುಸ್ ಮನ್ಯಾಚ಼ ಲೊಕಾನಾ ಸಾಂಗಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ತ್ಯನಿ ಆಮಾನಾ ಸಾಂಗಾಯಾ ಹುಕುಮ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","ತ್ಯಚಿವ ಇಸ್ವಾಸ್ ಥೆವ್‌ಲ್ಯಾಲ್ಯಾ ಪರತೇಕಾಚಿ ಪಾಪ ನಾವಾನಿಸ್ ಮಾಪ್ ಕರ್ನಾರ್. ಹ್ಯ ಖರ ಮನ್ಹುನ್ ಪ್ರವಾದಿಂಚಾನಿ ವಳಕ್ ದಿಲೆ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","ಪೇತ್ರಾ ಆಜು಼ನ್ ಆಸ ಸಾಂಗ್ತಾ ಆಸ್ಥಾನಾಸ್ ತ್ಯಚ಼ ಸಂದೆಶ್ ಐಕ್‌ತ್ಯಾಲ್ಯಾಂಚಿವ ಪವಿತ್ರಾತ್ಮ ಉತಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","ಪೇತ್ರಾ ಸಂಗ ಆಲ್ಯಾಲಿ ಯೆಹುದಿ ಇಸ್ವಾಸಿ ಗಾಭಾರ್ಲಿತ. ಯೆಹುದಿ ನಸ್‌ಲ್ಯಾಲ್ಯಾಂಚಿವ ಸಾಹಿತ್ ಪವಿತ್ರಾತ್ಮಾಚ಼ ವರ ಆಲ್ಯಾಲ ಬಗುನ್ ತ್ಯನಾ ಆಜಾಬ್ ವಾಟ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","ಕಾ ಮಂಜೆ ತೇ ದುಸ್ರೆ ದುಸ್ರೆ ಬಾಶೆತ್ನಿ ಬುಲುನ್ ದೇವಾಲಾ ಸ್ತೊತ್ರ ಕರ್ತ್ಯಾಲಿ ತ್ಯಾ ಯೆಹುದಿ ಇಸ್ವಾಸಿಂಚಾನಿ ಐಕ್ಲ. ಮಂಗ್ ಪೇತ್ರಾ, ");
INSERT INTO gok_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“ಪಾನ್ಯಾನಿ ಬಾಪ್ತಿಸ್ಮಾ ಗಿಹುನಾಹಿ ಮನ್ಹುನ್ ಆಮಿ ಹ್ಯಾ ಲೊಕಾನಾ ಆಡ್ಯಾವಾಯಾ ವ್ಹಯಿತ್ನಾಹಿ. ಆಮಿ ಗೆತಲ್ಯಾ ಶಾರ್ಕ ಹ್ಯಂಚಾನಿಬಿ ಪವಿತ್ರ ಆತ್ಮ ಗೆತಲ್ಯಾ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","ಮನ್ಹುನ್ ಯೇಸು ಕ್ರಿಸ್ತಾಚಾ ನಾವಾನಿ ಬಾಪ್ತಿಸ್ಮಾ ಗಿಹ್ಯಾಲಾ ತ್ಯನಾ ಹುಕುಮ್ ದಿಲಾ. ಮಂಗ್ ತ್ಯಂಚಾನಿ ಆಪ್ಲಿ ಸಂಗ ಥೊಡ ದೀಸ್ ರಾಹ್ಯಾ ಪೇತ್ರಾಲಾ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","ಯೆಹುದಿ ನಸ್‌ಲ್ಯಾಲಿ ಸಾಹಿತ್ ದೇವಾಚಾ ವಾಕ್ಯಾ ಗೆಥ್ಯಾತ ಮನ್ಹುನ್ ಅಪೊಸ್ತಲಾನಾಬಿ ಯುದಾಯಾತ್‍ಲ್ಯಾ ಇಸ್ವಾಸಿನಾ ಸಮಾಜ಼್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","ಪೇತ್ರಾ ಯೆರುಸಲೆಮಿತ್ ಆಲಾ ತವಾ ಮುಂಜಿ ಕೆಲ್ಯಾಲ್ಯಾ ಯೆಹುದಿ ಇಸ್ವಾಸಿಂಚಾನಿ ತ್ಯಚಿವ ವಾದ್ ಕೆಲಾ; ");
INSERT INTO gok_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","ತು ಮುಂಜಿ ನಸಲ್ಯಾಲ್ಯಾಂಚಾ ಗರ‍್ಹಾತ್ ಜಾ಼ವುನ್ ಖಾಲಸ್ ನವ್ಹ. ");
INSERT INTO gok_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","ಮನ್ಹುನ್ ಪೇತ್ರಾನಿ ಚಾ಼ಲ್ಯಾಲ್ಯಾ ಸಗ್‌ಳ್ಯಾ ಗುಶ್ಟಿ ತ್ಯನಾ ಆಂದಿಸ್ಟಾವ್ನಿ ಶಾರ್ಕ ಫುಡುನ್ ಸಾಂಗ್ಲ, ");
INSERT INTO gok_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","ತ್ಯ ಕ್ಯಾ ಮಂಜೆ, “ಮಿ ಯೊಪ್ಪ ಪೆಠತ್ ಹುತ್ತೊ. ಮಿ ಮಾಗ್ನ ಕರ್ತಾನಾ ಮನಾ ಯಾಕ್ ದರ್ಶಾನ್ ಜಾ಼ಲ್ಹ. ತ್ಯಾ ದರ್ಶಾನಾತ್ ಆಬ್ಳಾತ್ನಿ ಉತ್ರುನ್ ಆಲ್ಯಾಲ ಯೊಕ್ ಜಿನೊಸ್ ಬಗ್ಲಾ. ತ್ಯ ಯಕಾ ಪಾಂಡರ‍್ಯಾ ಕಪ್‌ಡ್ಯಾಚೆಗತ್ ಹುತ್ತ. ತ್ಯಚ಼ ಚಾರಿ ಕೊನ ಬಾಂದುನ್ ಉತ್ರಾಯಾ ದರ್ಥಿವ ಶೊಡ್ಲಹುತ್ತ. ತ್ಯ ಉತ್ರುನ್ ಯವುನ್ ಮಾಜಿಪ ಆಲ. ");
INSERT INTO gok_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","ಮಿ ಬಗ್ಲತವಾ ತ್ಯಾತ್ ಚಾ಼ರ್ ಪಾಯಾಚಿ ಜ಼ನಾವಾರ ಕ್ರುರಿ ಭ್ಯಾಚಿ ಜ಼ನಾವಾರ ಫುರ್ಕ್ಯಾಗೆಥ್ಯಾಲಿ ಜ಼ನಾವರ ಆನಿ ಪಾಖ್ರ ಹುತ್ತಿತ. ");
INSERT INTO gok_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","ತವಾ ಮನಾ ಯೊಕ್ ಸಬ್ದ ಐಕು ಆಲಾ, ತ್ಯೊ “ಪೇತ್ರಾ ಉಟ್! ಹ್ಯಾತ್ಲ ಕಚ಼ ವ್ಹಯಿತ್ಯ ಕಾಪುನ್ ಖಾ!’ ಮನ್ಹುನ್. ");
INSERT INTO gok_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“ಫನ್, “ಪ್ರಭು, ಮಿ ತಸ ಕರೀತ್ನಾಹಿ! ಬಾಟ್‌ಲ್ಯಾಲ ಆನಿ ಶುದ್ದ ನಸ್‌ಲ್ಯಾಲ ಕಾಯ್ತರಿ ವ್ಹವುನಿ ಮಿ ಕಂದಿಸ್ ಖಾಲ ನಾಹಿ’ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“ಫನ್, ‘ದೇವಾನಿ ಹ್ಯ ಸಗ್ಳ ಚಾ಼ಂಗ್ಲ ಕೆಲ್ಯಾ ಬುರ್ಸ ಮನ್ಹುನ್ ಸಾಂಗುನಕೊಸ್! ಮನ್ಹುನ್ ತ್ಯಾ ಸಬ್ದಾನಿ ಮನಾ ಉತ್ತರ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","“ಆಸ ತೀನ್ ಖೆಪಾ ಜಾ಼ಲ್ಹ. ನಂತರ್ ತೀ ಸಗ್ಳಿ ಸಾಮ್ನ ಅಬ್ಳಾಕ್ಡ ಮಾಗಾರಿ ಗಿತ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","ತ್ಯಾಸ್ ಯಳಾತ್ ಮಿ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ಗರ‍್ಹಾತ್ ತಿಗ ಜಾ಼ನ್ ಆಲ. ತ್ಯಾ ತಿಗಾನಾಬಿ ಸೆಜ಼ರೆಯಾ ಪೆಠತ್ನಿ ಲಾವುನ್ ದಿಲ್ಯಾಲ. ");
INSERT INTO gok_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","ಅನ್ಮಾನ್ ಕರಾಚೆ ಆಂದಿ ತ್ಯಂಚೆ ಸಂಗ ಜಾ಼ಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಪವಿತ್ರಾತ್ಮಾನಿ ಮನಾ ಸಾಂಗ್ಲ. ಹಿತ್ತ ಆಸ್‌ಲ್ಯಾಲ ಹೆ ಸಾ ಜಾ಼ನ್ ಬಾಹು ಆಮ್ಚಿ ಸಂಗ ಆಲ. ಆಮಿ ಕೊರ್ನೆಲಿಯಾಚಾ ಗರ‍್ಹಾತ್ ಗೆಲಾವ್. ");
INSERT INTO gok_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","ಮಾಜಾ ಗರ‍್ಹಾತ್ ದೇವ್ದುತ್ ಯೊಕ್ ಉಬಾರಾಯ್‌ಲ್ಯಾಲಾ ಆಪ್ನು ಬಗ್‌ಲ್ಯಾಲೆ ಗುಶ್ಟಿತ್ ಕೊರ್ನೆಲಾನಿ ಮನಾ ಸಾಂಗ್ಲ. ತ್ಯೊ ದೇವ್ ದುತ್ ಕೊರ್ನೆಲಾಲಾ, ‘ಥೊಡ್ಯಾ ಲೊಕಾನಾ ಯೊಪ್ಪಾತ್ ಲಾವುನ್ ದೆ. ಸಿಮೊನ್ ಪೆತ್ರಾಲಾ ತುಜಿಪ ಹಾಕ್ಟುನ್ ಗೇ. ");
INSERT INTO gok_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","ತ್ಯೊ ತುಮ್ಚಿ ಸಂಗ ಬೊಲ್ನಾರ್. ತ್ಯೊ ಸಾಂಗ್‌ತ್ಯಾಲಾ ಗುಶ್ಟಿ ತುಲಾಬಿ ತುಜಾ ಕುಟ್ಮಾಲಾಬಿ ರಕ್ಶನ್ ವ್ಹನಾರ್’ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","ಮಿ ಮಾಜ಼ ಸಿಕಿವ್ನ ಸುರ್ವಾತ್ ಕೆಲ್ಯಾವ, ಆಂದಿಸ್ಠಾವ್ನಿ ಪವಿತ್ರಾತ್ಮ ಆಮ್ಚಿವ ಆಲ್ಯಾಚೆಗತ್ ತ್ಯಂಚಿವಬಿ ಆಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","ತವಾ ಪ್ರಭುನಿ ಸಾಂಗ್‌ಲ್ಯಾಲ ಮಾಜೆ ಯದತ್ ಆಲ. ‘ಫನ್ ತುಮಿ ಪವಿತ್ರಾತ್ಮಾನಿ ಬಾಪ್ತಿಸ್ಮಾ ಗೆನಾರ್ ಮನ್ಹುನ್ ಯೊಹಾನಾನಿ ಲೊಕಾನಾ ಪಾನ್ಯಾನಿ ಬಾಪ್ತಿಸ್ಮಾ ದೀಲಾ’ ಮನ್ಹುನ್ ಪ್ರಭುನಿ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","ಪ್ರಭು ಜಾ಼ಲ್ಯಾಲ್ಯಾ ಯೇಸು ಕ್ರಿಸ್ತಾವ ಇಸ್ವಾಸ್ ಥೆವ್‌ಲ್ಯಾಲ್ಯಾ ಆಮಾನಾ ದಿಲ್ಯಾಲ ವರುಸ್ ದೇವಾನಿ ಹ್ಯಾ ಲೊಕಾನಾ ದಿಲ. ಆಸ ಆಸ್ಥಾನಾ ದೇವಾಚ಼ ಕಾಮ್ ಥಾಂಬ್ವಾಯಾ ಮಿ ಕೊನ್? ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","ಯೆಹುದಿ ಇಸ್ವಾಸಿ ಹ್ಯಾ ಗುಶ್ಟಿ ಐಕ್‌ಲ್ಯಾವ ವಾದ್ ಥಾಂಬ್ವುನ್, ದೇವಾಲಾ ವವ್ಯಾಳಿತ್, “ತಸ ಜಾ಼ಲ್ಯಾವ ಆಮ್ಚಿಗತ್ ಆಪ್ಲಿ ಮನಬಿ ಪರ್ತುನ್ ಗಿಹುನ್ ಜಿವ್ನಾ ಗಿಹ್ಯಾ ದೇವಾನಿ ಯೆಹುದಿ ನಸ್‌ಲ್ಯಾಲ್ಯಾನಾಬಿ ಅವ್ಕಾಸ್ ದಿಲಾ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","ಸ್ತೆಫನಾಚಾ಼ ಘಾತ್ ಕೆಲ್ಯಾ ನಂತರ್ ಜಾ಼ಲ್ಯಾಲ್ಯಾ ಜಾ಼ಚಾ಼ನಿ ಇಸ್ವಾಸಿ ಪಗ್ಳುನ್ ಗೆಲಿತ. ಇಸ್ವಾಸಿತ್ಲ ಥೊಡ ಖುಬ್ ದುರ್ಚಾ ಜಾ಼ಗ್ಯಾವ ಪೊಯಿನಿಕೆ ಸಿಮತ್, ಕ್ರುಪ ಆನಿ ಅಂತಿಯೊಕ್ಯಾತ್ ಗೆಲ. ಇಸ್ವಾಸಿಂಚಾನಿ ಹ್ಯಾ ಜಾ಼ಗ್ಯಾವ್ನಿ ಬರಿ ಖಬರ್ ಸಾಂಗ್ಲಿ. ಫನ್ ತ್ಯಂಚಾನಿ ಯೆಹುದ್ಯಾಂಚೆ ಮದ್ದಿ ತ್ಯವ್ಡಿಸ್ ಸಾಂಗ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","ಹ್ಯಾ ಇಸ್ವಾಸಿತ್ಲ ಥೊಡ ಕ್ರುಪಾತ್ಲ ಆನಿ ಕುರೇನ್ ಜಾ಼ಗ್ಯಾವ್ಲ ಜಾ಼ಲ್ತ. ಹಿ ಲೊಕ ಅಂತಿಯೊಕ್ಯಾತ್ ಆಲಿತ ತವಾ ತ್ಯಂಚಾನಿ, ಪ್ರಭು ಜಾ಼ಲ್ಯಾಲ್ಯಾ ಯೇಸುಚೆ ಗುಶ್ಟಿತ್ ಬರಿ ಖಬರ್ ತಿತಲ್ಯಾ ಗ್ರೀಕ್ ಲೊಕಾನಾಬಿ ಸಾಂಗ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","ಪ್ರಭು ಇಸ್ವಾಸಿ ಲೊಕಾನಾ ಮಜ಼ತ್ ಕರಿತಾ. ಪ್ರಭುಚ಼ ಬಳ್ ತ್ಯಂಚಿ ಸಂಗ ಹುತ್ತ ಆನಿ ಖುಬ್ ಲೊಕಾಂಚಾನಿ ಇಸ್ವಾಸ್ ಥೆವ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","ಹಿ ಖಬರ್ ಯೆರುಸಲೇಮಿಚೆ ಸಬೆಲಾ ಪುಚ್ಲಿ ಹುತ್ತಿ. ಮನ್ಹುನ್ ತ್ಯಂಚಾನಿ ಬಾರ್ನಬಾಲಾ ಅಂತಿಯೊಕ್ಯಾತ್ ಲಾವುನ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","ಬಾರ್ನಬಾ ತಿಥ ಯವುನ್ ಪೊಚ್ಲಾ಼ ತವಾ ದೇವಾಚೆ ಕ್ರಪೆನಿ ಕಸ್ಲ ಕಾಮ ಕೆಲ್ಯಾ ಮನ್ಹುನ್ ಬಗುನ್ ಆನಿ ತ್ಯೊ ಸಂತೊಶ್ ಜಾ಼ಲ್ಹಾ ಆನಿ ತ್ಯನಾ ಸಗ್‌ಳ್ಯಾನಾ ಪ್ರಭುನಿ ಪುರ‍್ಯಾ ಮನಾನಿ ಪ್ರಭುಪ ರಾಹ್ಯಾಲಾ ಉಮೇದ್ ದಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","ಬಾರ್ನಬಾ ಯೊಕ್ ಚಾ಼ಂಗ್ಲಾ ಮಾನುಸ್ ಜಾ಼ಲ್ಥಾ ತ್ಯೊ ಪವಿತ್ರಾತ್ಮಾನಿ ಇಸ್ವಾಸಾನಿ ಬರ್‌ಲ್ಯಾಲಾ ಜಾ಼ಲ್ಥಾ ಆನಿ ಖುಬ್ ಲೊಕಾನಾ ಪ್ರಭುಕ್ಡ ಹಾಕ್ಟುನ್ ಆನ್‌ಲ್ಯಾಲಾ ಜಾ಼ಲ್ಥಾ. ");
INSERT INTO gok_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","ನಂತರ್ ಬಾರ್ನಬ್ ಸೌಲಾಲಾ ಸುದಿತ್ ತಾರ್ಸಸ್ ಪೆಠತ್ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","ಬಾರ್ನಬಾನಿ ತಿಥ ಸೌಲಾಲಾ ಸುದುನ್ ತ್ಯಲಾ ಅಂತಿಯೊಕ್ಯಾತ್ ಗಿಹುನ್ ಆಲಾ. ಸೌಲ್ ಆನಿ ಬಾರ್ನಬ್ ಅಂತಿಯೊಕ್ಯಾತ್ ಯಾಕ್ ವರಿಸ್ ಪುರ ಸಭೆಚೆ ಯಕಿತ್ ರಾಹುನ್ ಖುಬ್ ಲೊಕಾನಾ ಸಿಕಿವ್ಲ. ಮನ್ಹುನ್ ಆಂದಿ ಯೆಸುಚೆ ಮಾಗ್ನಿ ಜಾ಼ತ್ಯಾಲ್ಯಾನಾ ‘ಕ್ರಿಸ್ಚೆನ’ ಮನ್ಹುನ್ ನಾವ್ ಆಲ್ಯಾಲ ಅಂತಿಯೊಕ್ಯಾತುಸ್. ");
INSERT INTO gok_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","ತ್ಯಾ ಕಾಲಾತ್ ಥೊಡ ಪ್ರವಾದಿ ಯೆರುಸಲೆಮಿತ್ನಿ ಅಂತಿಯೊಕ್ಯಾತ್ ಗೇಲ. ");
INSERT INTO gok_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","ತ್ಯಾತ್ನಿ ‘ಅಗಬ’ ಮಂಥ್ಯಾಲಾ ಯೊಕ್ ಹುತ್ತಾ. ತ್ಯೊ ಅಂತಿಯೊಕ್ಯಾತ್ ಪವಿತ್ರಾತಮ್ಯಾಚಾ ಸಾಂಗ್‍ನ್ಯಾನಿ, “ಸಗ್‍ಳ್ಯಾ ಪ್ರಪಂಚಾಲಾಸ್ ಖುಬ್ ಬರಗಾಲ್ ಯಯಾಚ಼ ಹಾ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ಹ್ಯ ಬರ್ಗಾಲ್ ಕ್ಲವದ್ಯ ರಾಜಾಚಾ ಕಾಲಾತ್ ಆಲ್ತ. ");
INSERT INTO gok_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","ಶಿಶಾಂಚಾನಿ ಯುದಾಯಾತ್‌ಲ್ಯಾ ಬನ್ಹಿ ಬಾವ್ಹಾನಾ ಮಜ಼ತ್ ಕರಾಯಾ ಇಸ್ವಾಸಿಂಚಾನಿ ನಿರ್ದಾರ್ ಕೆಲಾ. ಇಸ್ವಾಸಿತಲ್ಯಾ ಪರತೆಕ್ ಯಕಾನಿ ಆಪ್ಲಿಪ್ನಿ ವ್ಹಯಿಲ್ ತ್ಯವ್ಡ ತ್ಯನಾ ಲಾವುನ್ ದಿಯಾ ಯವಜ್ನಾ಼ ಕಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","ತ್ಯಂಚಾನಿ ಪೈಸ ಗೊಳಾ ಕರುನ್ ಬಾರ್ನಬಾಲಾ ಆನಿ ಸೌಲಾಲಾ ದಿಲ. ನಂತರ್ ಬಾರ್ನಬ್ ಆನಿ ಸೌಲ್ ತ್ಯ ಆನುನ್ ಯುದಾಯಾತ್ ಸಭೆಚಾ ಜಾಂತ್ಯನಾ ಲಾವುನ್ ದಿಲ. ");
INSERT INTO gok_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","ತ್ಯಾ ಕಾಲಾತ್ ಹೆರೊದ್ ರಾಜಾ಼ ಸಭೆತ್‌ಲ್ಯಾ ಥೊಡ್ಯಾನಾ ಜಾ಼ಸ್ ಕರಾಯಾ ಲಾಗ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","ಯಾಕೊಬಾಚಾ಼ ಕುಂಗ್ಳಿನಿ ಘಾತ್ ಕೆಲಾ. ಯಾಕೊಬ್ ಯೊಹಾನಾಚಾ಼ ಬಾಹು. ");
INSERT INTO gok_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","ಯೆಹುದ್ಯಾನಾ ಹ್ಯ ಆವಾಡಲ್ಯಾ ಮನ್ಹುನ್ ಹೆರೊದಾಲಾ ಸಮಾಜ಼್ಲ. ಆನಿ ತ್ಯನಿ ಪೇತ್ರಾಲಾ ಕುಂಡುನ್ ತುರುಂಗಾತ್ ಗ್ಯಾತ್ಲಾ. ಹ್ಯ ಚಾ಼ಲ್ಯಾಲ ಯೆಹುದ್ಯಾಂಚಾ ಫುಗತ್ ನಸ್‌ಲ್ಯಾಲೆ ಭಾಕ್ರಿಚಾ ಸನಾಚಾ ಕಾಲಾತ್. ");
INSERT INTO gok_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","ಚಾರ್ ಜನಾಂಚಾ ಸೈನಿಕಾಂಚ಼ ಚಾರ್ ಹಿಂಡ್ ಪೇತ್ರಾಲಾ ರಾಖಿತ. ವಲಾಂಡ್ಯಾಚಾ ಸನಾಚ಼ ಕಾಲ್ ಸೊಪ್‌ಲ್ಯಾ ನಂತರ್ ಪೇತ್ರಾಲಾ ಲೊಕಾಂಚೆ ಮೊರ‍್ಹ ಉಬಕರಾಯಾ ವ್ಹಯಿ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","ಆಸ ಪೇತ್ರಾನಿ ತುರುಂಗಾತ್ ಆಸ್ಥಾನಾ ಸಭೆತ್‌ಲ್ಯಾಂಚಾನಿ ತ್ಯಚಿಸಾಟಿ ಖಾಯಿಮ್ ದೇವಾಪ ಮನ್ ಥಿವುನ್ ಮಾಗ್ನ ಕರಿತಾ. ");
INSERT INTO gok_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","ಪೇತ್ರಾ ದೊಗಾ ಸೈನಿಕಾಂಚೆ ಮದ್ದಿ ನಿಜ಼್ಲಾ ಹುತ್ತಾ. ತ್ಯಲಾ ದೊನ್ ಸರ್ಪೊಳ್ಯಾನಿ ಬ್ಯಾಂದ್ಲಾ ಹುತ್ತಾ. ಖುಬ್ ಸೈನಿಕ್ ತುರುಂಗಾಚ಼ ದಾರ್ ರಾಖಿತ. ತವಾ ರ‍್ಯಾತ್ ಜಾ಼ಲ್ಥಿ. ದುಸ್ರೆ ದಿಸಿ ಸಕಾಳ್ಚ಼ ಪೇತ್ರಾಲಾ ಲೊಕಾಂಚೆ ಮೊರ‍್ಹ ಆನಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಹೆರೊದಾನಿ ಯವಜ಼್ಲ ಹುತ್ತ. ");
INSERT INTO gok_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","ಪಾಕನ್ ಪ್ರಭುಚಾ಼ ದೇವ್ ದುತ್ ಯೊಕ್ ತಿಥ ಉಬಾರಾಯ್ಲಾ. ತೇ ಖುಲಿತ್ ಉಜಿಡ್ ಬರ್ಲಾ. ದೇವ್ ದುತಾ ಪೇತ್ರಾಚೆ ಕುಸಿತ್ ಹಾತ್ ಲಾವುನ್, “ಬಿಗಿನಿ ಉಟ್!” ಮನ್ಲಾ. ತವಾಸ್ ಸರ್ಪೊಳ್ಯಾ ಪೇತ್ರಾಚಾ ಹಾತಾತ್ನಿ ಸುಟುನ್ ಪಡ್‌ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","ದೇವದುತಾನಿ ಪೇತ್ರಾಲಾ, “ಕಪ್ಡ ಗ್ಯಾಲ್ ವ್ಹಾನಾ ಗ್ಯಾಲ್” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ತಸಸ್ ಪೇತ್ರಾನಿ ಕೇಲ. ನಂತರ್ ದೇವ್ ದುತ್, “ತುಜಾ಼ ಜ಼ಘಾ ಗುತ್ಪಳುನ್ ಮಾಜೆ ಮಾಗ್ನಿ ಯೆ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","ದೇವ್ ದುತ್ ಬಾಹಿರ್ ಗೇಲಾ ಪೇತ್ರಾ ತ್ಯಚೆ ಮಾಗ್ನಿ ಗೆಲಾ. ದೇವ್ ದುತ್ ಆಸ ಕರತ್ಯೊ ಮನ್ಹುನ್ ಪೇತ್ರಾಲಾ ಖರ‍್ಯಾನಿಸ್ ಸಮಾಜ಼್ಲ ನವ್ಥ. ಆಪ್ನು ದರ್ಶಾನ್ ಬಗ್‌ತ್ಯೊ ಮನ್ಹುನ್ ಯವಜ಼್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","ಪೇತ್ರಾ ಆನಿ ದೇವ್ ದುತ್ ಯಕವ್ಯಾ ಆನಿ ದೊನವ್ಯಾ ಸೈನಿಕಾನಾ ವಲ್ಯಾಂಡುನ್ ಗೆಲ. ನಂತರ್ ತೇ ಆಪ್‌ಲ್ಯಾಲಾ ಪೆಠತ್ ಜಾ಼ತ್ಯಾಲ್ಯಾ ಲೊಖಾಂಡಾಚಾ ದಾರಾಪ ಆಲ. ತ್ಯ ದಾರ್ ತ್ಯಂಚಿಸಾಟಿ ಆಪ್ಲೆ ಆಪ್ನು ಉಗಾಡ್ಲ ಹುತ್ತ. ಪೇತ್ರಾ ಆನಿ ತ್ಯೊ ದೇವ್ ದುತ್ ದಾರಾನಿ ಬಾಹಿರ್ ಯವುನ್ ಯೆಕ ಪಾಂದಿನಿ ಗೇಲ. ತವಾ ಪಾಕನ್ ತ್ಯೊ ದೇವ್ ದುತ್ ತ್ಯಲಾ ಸುಡುನ್ ಗೇಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","ತವಾ ಚಾ಼ಲ್ಯಾಲ್ಯಾ ಖನ್ಕತಿ ಪೇತ್ರಾ ಆಪ್‌ಲ್ಯಾಲಾ ಆಪ್ನುಸ್ ಮನ್ಹುನ್ ಗೆಥೊ, “ಪ್ರಭುನಿ ಆಪ್‌ಲ್ಯಾ ದೇವ್ ದುತಾಲಾ ಖರ‍್ಯಾನಿಸ್ ಲಾವುನ್ ದಿಲ್ತಾ ಮನ್ಹುನ್ ಆತಾ ಮನಾ ಸಮಾಜ಼್ಲ. ತ್ಯನಿ ಮನಾ ಹೆರೊದಾಚಾ ಹಾತಾತ್ನಿ ಪಾರ್ ಕೆಲಾ. ಮಾಜಾ಼ ನಾಸ್ ವ್ಹನಾರ್ ಮನ್ಹುನ್ ಯೆಹುದಿ ಮನ್ಲ ಹುತ್ತ. ಫನ್ ಪ್ರಭುನಿ ಮನಾ ತ್ಯಾ ನಾಸಾತ್ನಿ ರ‍್ಯಾಕ್ಲಾ” ");
INSERT INTO gok_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","ನಂತರ್ ಪೇತ್ರಾ ಯೊಹಾನಾಚಿ ಆಯಿ ಜಾ಼ಲ್ಯಾಲೆ ಮರಿಯಾಚಾ ಗರ‍್ಹಾತ್ ಗೆಲಾ. ಯೊಹಾನಾಲಾ ಮಾರ್ಕ್ ಮನ್ಹುನ್ ಹಾಕ್ಟಿತಿತ. ಖುಬ್ ಲೊಕ ತಿಥ ಜ಼ಮ್ಲಿಹುತ್ತಿತ. ತೀ ಸಗ್ಳಿ ಮಾಗ್ನ ಕರೀತಿತ ");
INSERT INTO gok_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","ಪೇತ್ರಾನಿ ಬಾಹಿರ್ಲ ದಾರ್ ಬಡಿವ್ಲ ಕೊನ್ ತ್ಯ ಇಚಾರಾಯಾ ರೊದೆ ಮಂಥ್ಯಾಲಿ ಸೇವಕಿ ಆಲಿ. ");
INSERT INTO gok_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","ರೊದೆನಿ ಪೇತ್ರಾಚಾ಼ ಸಬ್ದ ವಳಕ್ಲಾ. ತೀಲಾ ಖುಬ್ ಸಂತೊಶ್ ಜಾ಼ಲ್ಹಾ. ಆನಿ ದಾರ್ ಕಾಡಾಚ಼ ಇಸ್ರುನ್ ಮಾಗಾರಿ ಮಾನ್ಸಾಂಚಿಪ ಪಳತ್ ಜಾ಼ವುನ್, “ಪೇತ್ರಾ ದಾರಾಪ ಉಬಾ ರಾಯಲ್ಯಾ! ಮನ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","ತೇ ಇಸ್ವಾಸಿ ತಿಲಾ, “ತುಲಾ ಖುಳ ದರ್‌ಲ್ಯಾ! ಮನ್ಲ. ಫನ್ ತಿ ಆಪ್ನು ಸಾಂಗ್‌ತ್ಯಾಲ ಖರ ಮನ್ಹುನ್ ಜೊ಼ರಾನಿ ಸಾಂಗ್ಲ. ತವಾ ತೇ, “ತ್ಯೊ ಪೇತ್ರಾಚಾ಼ ದುತ್ ಆಸಲ್” ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","ಫನ್ ಪೇತ್ರಾ ದಾರ್ ಬಡ್ವಿತುಸ್ ಹುತ್ತಾ. ತವಾ ತ್ಯಂಚಾನಿ ದಾರ್ ಉಗಡ್ಲ ಆನಿ ತ್ಯಂಚಾನಿ ಪೇತ್ರಾಲಾ ಬಗುನ್ ಗಾಭಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","ಪೇತ್ರಾನಿ ತ್ಯನಾ ಗಪ್ ರಾಹ್ಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಸುಸ್ನಾ ಕಿಲಿ. ಪ್ರಭುನಿ ಆಪ್‌ಲ್ಯಾಲಾ ತುರುಂಗಾತ್ನಿ ಸುಡಿವಲ್ಯಾಲ ತ್ಯನಿ ತ್ಯನಾ ಫುಡುನ್, “ಯಾಕೊಬಾಲಾ ಆನಿ ಇಸ್ವಾಸಿನಾ ಹಿ ಖನ್ಕತ್ ಸಾಂಗಾ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ನಂತರ್ ಪೇತ್ರಾ ದುಸ್‌ರ‍್ಯಾ ಯಕಾ ಜಾ಼ಗ್ಯಾವ ತಿತ್ನಿ ಗೇಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","ಸಕಾಳ್ಚ಼ ಪೇತ್ರಾ ಕ್ಯಾ ಜಾ಼ಲ್ಹಾ ಮನ್ಹುನ್ ಸೈನಿಕಾಂಚಾ಼ ಮೊಟಾ ಗೊಂದೊಳ್ ಜಾ಼ಲ್ಹಾ. ");
INSERT INTO gok_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","ಹೆರೊದಾನಿ ಕುಠ ಕುಠ ಶೊದ್ಲ ತರಿ ಪೇತ್ರಾಲಾ ದರಾಯಾ ಜಾ಼ಲ್ಹ ನಾಹಿ. ಮನ್ಹುನ್ ಹೆರೊದಾನಿ ರ‍್ಯಾಕ್‌ತ್ಯಾಲ್ಯಾನಾ ಇಚಾರುನ್ ತ್ಯನಾ ಮರ್ನಾಚೆ ಶಿಕ್ಷಾ ದಿಲಿ. ತವಾಸ್ ಹೆರೊದ್ ಯುದಾಯಾತ್ನಿ ನಿಗುನ್ ಕೈಸರೆಯಾ‍ ಪೆಠತ್‍ ಯವುನ್ ತಿಥ ಥೊಡ ದಿಸ್ ರಾಯ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","ಥೈರ್ ಆನಿ ಸಿದೊನ್ ಪೆಠಚಾ ಲೊಕಾಂಚಿವ ಹೆರೊದ್ ಖುಬ್ ರಾಗಾವ ಜಾ಼ಲ್ಥಾ. ತೀ ಸಗ್ಳಿ ಲೊಕ ಹೆರೊದಾಲಾ ಭೆಟ್ ವ್ಹಯಾ ಯಂಗ್ದಾಸ್ ಗಿಲಿತ. ತ್ಯಂಚಾನಿ ಬ್ಲಾಸ್ತನಾಲಾ ಆಪ್ಲಿಕ್ಡ ವಳಿವ್ಲಾ. ಬ್ಲಾಸ್ತನ್ ರಾಜಾಚಾ಼ ಸಗ್ಳ ದೆಕ್ರೆಕ್ ಕರ್ನಾರಾ. ತ್ಯಂಚಾನಿ ಆಪ್ಲಿಸಂಗ ಸಮಾಧಾನಾನಿ ರಾಹ್ಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಹೆರೊದಾಲಾ ಇಚಾರ್ಲ. ಕಾ ಮಂಜೆ ತ್ಯಂಚಾ ಗಾವಾಲಾ ಹೆರೊದಾಚಾ ಗಾವಾತ್ನಿ ಪ್ಯುಡ್ಗಿ ಆನಾಯಾ ವ್ಹಯಿ ಜಾ಼ಲ್ಥಿ. ");
INSERT INTO gok_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","ತ್ಯನಾ ಭೆಟ್ ವ್ಹಯಾ ಹೆರೊದಾನಿ ಯೊಕ್ ದಿಸ್ ಥರಿವ್ಲಾ. ತಿಸಿ ಹೆರೊದಾನಿ ಶಾದ್ರಾ ರಾಜಾಚಾ಼ ಪೊಶಾಕ್ ಗಾಲ್ಹುನ್. ಆಪ್‌ಲ್ಯಾ ಸಿಂಹಾಸನಾವ ಬಸುನ್ ಸಗ್‌ಳ್ಯಾ ಲೊಕಾನಾ ಬಾಶಾನ್ ಕೆಲ. ");
INSERT INTO gok_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","ತೀ ಲೊಕ, “ಹ್ಯೊ ಸಬ್ದ ಮಾನ್ಸಾಚಾ಼ ನವ್ಹ ದೇವಾಚಾ಼ ಮನ್ಹುನ್ ವರಾಡ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","ಹೆರೊದಾನಿ ಹ್ಯ ವವ್ಯಾಳ್ನ ಆಪ್ನು ಗೆತ್ಲ. ದೇವಾಲಾ ಮೈಮಾ ಕಿಲಿ ನಾಹಿ. ಮನ್ಹುನ್ ತವಾಸ್ ಪ್ರಭುಚಾ ದುತಾನಿ ತ್ಯಲಾ ಮಾರುನ್ ಬುಡಿ ಪಾಡುನ್ ಗ್ಯಾತ್ಲಾ. ತ್ಯೊ ಕಿಡ ಪಡುನ್ ಮೇಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","ದೇವಾಚ಼ ಸಬಾತ್ ಪಗಾಳ ಆನಿ ಖುಬ್ ಲೊಕಾಂಚಿಪ ಗೆಲ. ಇಸ್ವಾಸಿಂಚಾ಼ ಸಮುದಾಯ್ ದಿಸುನ್ದಿಸ್ ಬಳ್ಕಾಟ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","ಬಾರ್ನಬ್ ಆನಿ ಸೌಲ್ ಯೇರುಸಲೆಮಿತ್ ಆಪ್ಲಿ ಕಾಮ ಸುಪಿವ್‌ಲ್ಯಾವ ಮಾಗರ ಪರ್ತುನ್ ಆಲ. ಮಾರ್ಕ್ ಮಂಥ್ಯಾಲಾ ಯೋಹಾನ್ ತ್ಯಂಚಿ ಸಂಗ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","ಅಂತಿಯೊಕ್ಯಾತ್ಲೆ ಸಭೆತ್ ಪ್ರವಾದಿ ಆನಿ ಸಿಕಿವ್ನಾರ ಹುತ್ತ. ತೇ ಕೊನ್ ಮಂಜೆ ಬಾರ್ನಬ್, ನೀಗರ್ ಮಂಥ್ಯಾಲಾ ಸಿಮೆಯೊನ್, ಕುರೇನ್ಯಾಚಾ಼ ಲುಕ್ಯ, ಸಾಮಂತ ಹೆರೊದಾಚೆ ಸಂಗವಾಡಲ್ಯಾಲಾ ಮೆನಹೇನ್, ಸೌಲ್ ಹೇಸ್. ");
INSERT INTO gok_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","ಹೇ ಪ್ರಭುಲಾ ವವ್ಯಾಳಿತ್ ಉಪಾಸ್ ಕರ್ತ್ಯಾಲ ಆಸ್ಥಾನಾ ಪವಿತ್ರಾತ್ಮ ಮನಾ ಬಾರ್ನಬಾಲಾ ಆನಿ ಸೌಲಾಲಾ ಹಾಕಟ್‌ಲ್ಯಾಲೆ ಸೆವೆ ಸಾಟಿ ತ್ಯನಾ ಯಗ್ಳಾ ಮನ್ಹುನ್ ಸಾಂಗ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","ತವಾ ಬಾರ್ನಾಬಾ ಆನಿ ಸೌಲ್ ಉಪಾಸ್ ರಾಹುನ್ ಮಾಗ್ನ ಕರುನ್ ತ್ಯಾ ದೊಗಾವ ಹಾತ್ ಥಿವುನ್ ತ್ಯನಾ ಲಾವುನ್ ದೆತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","ಆಸಸ್ ತೇ ಪವಿತ್ರತ್ಮಾನಿ ಲಾವುನ್ ದಿಲ್ಯಾಲ ವ್ಹವುನ್ ಸೆಲ್ಯುಕ್ಯಾತ್ ಆಲ; ತಿತ್ನಿ ಸಮಿಂದೊರಾವ್ನಿ ವ್ಹಡಿತ್ನಿ ಸೈಪ್ರಸ್ ದ್ವಿಪಾತ್ ಗೆಲ. ");
INSERT INTO gok_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","ಸಲಾಮಿಸ್ ಮಂಥ್ಯಾಲ್ಯಾ ಜಾ಼ಗ್ಯಾವ ಜಾ಼ವುನ್ ತಿಥ ಯೆಹುದ್ಯಾಂಚಾ ಸಭಾಸ್ಥಾನಾತ್ ದೇವಾಚಾ ವಾಕ್ಯಾ ಸಾಂಗ್‌ಲ್ಯಾ. ಮಾರ್ಕ್ ಮನ್ಹುನ್ ಗೆಥ್ಯಾಲಾ ಯೊಹಾನ್ ಮಜ಼ತ್ ಕರ್ತ್ಯಾಲಾ ವ್ಹವುನ್ ತ್ಯಂಚಿ ಸಂಗ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","ತೇ ದ್ವಿಪಾತ್ ಸಗ್‌ಳ್ಯಾ ಫಿರುನ್ ಪಾಪೊಸ್ ಮಂಥ್ಯಾಲ್ಯಾ ಗಾವಾ ಪರೇತ್ ಯವುನ್ ತಿಥ ಲಬಾಡ್ ಪ್ರವಾದಿ ಘಾಡ್ಫನ್ ಕರ್ನಾರಾ ಬಾರ‍್ಯೇಸು ಮಂಥ್ಯಾಲ್ಯಾ ಯಕಾ ಯೆಹುದಿ ಮಾನ್ಸಾಲಾ ಬಗ್‌ತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","ತ್ಯೊ ರಾಜ್ ದರ್ಬಾರ್ ಕರ್ನಾರಾ ಸೆರ್ಗ್ಯಾ ಪೌಲ್ ಮಂಥ್ಯಾಲ್ಯಾ ಅಧಿಪತಿ ಸಂಗ ಸುಪ್ತಿ ಹುತ್ತಾ. ತ್ಯೊ ಅಧಿಪತಿ ಶಾನಾ ವ್ಹವುನ್ ಬಾರ್ನಬಾಲಾ ಆನಿ ಸೌಲಾಲಾ ಆಪ್ಲಿಪ ಹಾಕ್ಟುನ್ ದೇವಾಚಾ ವಾಕ್ಯಾ ಐಕಾಯಾ ಮನ್ ಕೇಲ. ");
INSERT INTO gok_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","ಫನ್ ಗಾಢಿ ಜಾ಼ಲ್ಯಾಲಾ ಎಲಿಮನ್ ಬಾರ್ನಬ ಆನಿ ಸೌಲಾನಾ ಆಡ್ಯಾವಿತಾ. ರಾಜಪಾಲಾನಿ ಇಸ್ವಾಸ್ ಥಿವುನಾಹಿ ಆಡ್ಯಾವಿತಾ. ");
INSERT INTO gok_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","ಫನ್ ಪೌಲ ಸೌಲಾಚ಼ ಆನಿ ಯಾಕ್ ನಾವ್ ಪೌಲ್ ಪವಿತ್ರಾತ್ಮಾನಿ ಬರ್‌ಲ್ಯಾಲಾ ಜಾ಼ಲ್ಹಾ ಪೌಲಾನಿ ಎಲಿಮಾಲಾ ಬಗುನ್. ");
INSERT INTO gok_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ತ್ಯಲಾ, “ತು ಸೈತಾನಾಚಾ಼ ಲ್ಯೊಕ್ ಪರತೇಕ್ ಚಾ಼ಂಗಲ್ಯಾಲಾ ತು ವೈರಿ ಬುರ್ಸೆ ಯವಜ್ನಾ಼ನಿ ಲಬಾಡಾನಿ ಬರ್‌ಲ್ಯಾಲಾ ಜಾ಼ಲ್ಯಾಸ್ ಪ್ರಭುಚ಼ ಖರ ತು ಲಬಾಡ್ ಕರಾಯಾ ಕವಾಬಿ ಯತ್ನ ಕರ್ತೊಸ್! ");
INSERT INTO gok_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","ಬಗ, ಪ್ರಭುನಿ ತುಜಿವ ಹಾತ್ ಉಚ಼ಲ್ಯಾ. ತು ಅಂದ್ಳಾ ವ್ಹವುನ್ ಥೊಡ್ಯಾ ಯಳಾ ಪರತ್ ಕಾಯೆಕ್ ಬಗ್ನಾರ್ ನಾಹಿಸ್; ದಿಸಾಚಾ಼ ಉಜಿಡ್ ಸಾಹಿತ್ ಬಗ್ನಾರ್ ನಾಹಿಸ್” ಮನ್ಲಾ. ತವಾ ಎಲಿಮಾಲಾ ಸಗ್ಳ ಆಂದಾರ್ ಜಾ಼ಲ್ಹ ಆಪ್‌ಲ್ಯಾಲಾ ಕೊನ್ತರಿ ಹಾತ್ ದರ‍್ಹುನ್ ಚಾ಼ಲ್ವುನಿ ಮನ್ಹುನ್ ತ್ಯೊ ತಳ್ಮಳಿತ್ ಸರ್ಬೌರಾ ಚಾ಼ಲ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","ಹ್ಯ ಬಗ್‌ಲ್ಯಾಲ ರಾಜಪಾಲಾನಿ ಪ್ರಭುವ ಇಸ್ವಾಸ್ ಥೆವ್ಲಾ. ಪ್ರಭುಚೆ ಗುಶ್ಟಿತ್ ಸಿಕಿವ್ನ ಐಕುನ್ ಆಜಾಬ್ ಜಾ಼ಲ್ಹಾ. ");
INSERT INTO gok_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","ಪೌಲ್ ಆನಿ ತ್ಯಚೆ ಬರ್ಬರ್ಚ಼ ಪಾಪೊಸಿತ್ನಿ ಸಮಿಂದೊರಾತ್ನಿ. ಪಂಪುಲ್ಯ ಸಿಮತಲ್ಯಾ ಪೆರ್ಗ ಮಂಥ್ಯಾಲೆ ಪೆಠತ್ ತೆ ಆಲ. ಫನ್ ಮಾರ್ಕ್ ಮಂಥ್ಯಾಲಾ ಯೊಹಾನ್ ತ್ಯನಾ ಸುಡುನ್ ಯೆರುಸಲೆಮಿತ್ ಮಾಗಾರಾ ಗೇಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","ತ್ಯಂಚಾನಿ ಆಪ್ಲ ಪ್ರಯಾನ್ ಪೆರ್ಗಾತ್ನಿ ಚಾ಼ಲಿವ್ಲ, ಪಿಸಿದ್ಯ ಸಿಮತ್ ಮಿಳಾಲ್ಯಾಲೆ ಅಂತಿಯೊಕ್ಯಾತ್ ಗೆಲ. ತೇ ಅಂತಿಯೊಕ್ಯಾತ್ ಸಬ್ಬತ್ ದಿಸಾದಿಸಿ ಯೆಹುದ್ಯಾಂಚಾ ಸಭಾಮಂದಿರಾತ್ ಜಾ಼ವುನ್ ಬಸ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","ಮೊಶೆಚ಼ ಧರ್ಮಶಾಸ್ತಾರ್ ಆನಿ ಪ್ರವಾದಿಂಚ಼ ಪುತಿಕ್ ವಾಚಿವ್ಲ. ನಂತರ್ ಸಬಾಮಂದಿರಾಚ಼ ಜಾಂತ ಪೌಲ್ ಬಾರ್ನಬನಾ, “ಬಾವ್ಹಾನು ಹಿತ್‌ಲ್ಯಾ ಲೊಕಾನಾ ಮಜ಼ತ್ ವ್ಹತ್ಯಾಚೆಗತ್ ಕಾಯ್ತರಿ ತುಮಿ ಸಾಂಗಾಯಾ ವ್ಹಯಿ ಮಂಥಾಸಾತ ದಯಾ ಥಿವುನ್ ಸಾಂಗಾ ಮನ್ಹುನ್ ಸಾಂಗ್ನ ಲಾವುನ್ ದಿಲ. ");
INSERT INTO gok_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","ಪೌಲಾನಿ ವರ್ ಉಠುನ್ ಅಪ್ಲ ಬೊಲ್ನ ಐಕಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಹಾತಾನಿ ಖುನ್ನಾ ಕರುನ್ ಆಸಾ ಮನ್ಲಾ. ಮಾಜಾ ಇಸ್ರಾಯಲಾಚಾ ಲೊಕಾನು ಖರ‍್ಯಾ ದೇವಾಲಾ ವವ್ಯಾಳ್‌ತ್ಯಾಲ್ಯಾ ಯೆಹುದಿ ನಸ್‌ಲ್ಯಾಲ್ಯಾ ಲೊಕಾನು ಮಾಜ಼ ಐಕಾ! ");
INSERT INTO gok_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","ಇಸ್ರಾಯೆಲ್ ಲೊಕಾನು, ಆನಿ ಯೆಹುದಿ ಲೊಕಾನು, ಐಕಾ. ಆಮ್ಚಾ ಇಸ್ರಾಯೆಲ್ ಲೊಕಾನಾ ದೇವಾನಿ ನಿವಡಲ್ಯಾಲ ಆಮಚ಼ ವಾಡವಡಿಲ್ ಐಗುಪ್ತಾತ್ ಹುತ. ತವಾ ತ್ಯನಾ ದೇವಾನಿ ಅಬಿವ್ರದಿ ಕರುನ್ ಉದಾರ್ ಕಿಲಿತ. ಆಪ್‌ಲ್ಯಾ ಮೊಟ್ಯಾ ಬಳಾನಿ ತ್ಯನಾ ತೆ ದೆಶೆತ್ನಿ ಆನ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","ತ್ಯನಿ ಜ಼ವ ಜ಼ವಳ್ ರಾನಾತ್ ಚಾಳಿಸ್ ವರ್ಸಾ ಪರತ್ ತ್ಯನಾ ಸುಸ್ವುನ್ ಗಿತ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","ಕಾನಾನ್ ದೆಶೆತಲ್ಯಾ ಸಾತ್ ರಾಷ್ಟಾನಾ ನಾಸ್ ಕರುನ್ ಆಪ್‌ಲ್ಯಾ ಲೊಕಾನಾ ತ್ಯಾ ಜಾ಼ಗ್ಯಾವ್ಲ ಧನ್ಹಿ ಕೆಲ. ");
INSERT INTO gok_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","ಹ್ಯ ಸಗ್ಳ ಜ಼ವಜ಼ವಳ್ ಚಾರ್ಸೆ ಪನ್ನಾಸ್ ವರ್ಸಾ ಪರತ್ ಚಾ಼ಲ್ಲ, “ಹ್ಯ ಜಾ಼ಲ್ಯಾವ ಪ್ರವಾದಿ ಜಾ಼ಲ್ಯಾಲ್ಯಾ ಸಮುವೆಲಾಚಾ ಕಾಲಾ ಪರತ್ ದೇವಾನಿ ಆಮ್ಚಾ ಲೊಕಾನಾ ನ್ಯಾಯಿ ತಿರ್ಮಾನ್ ಕರ್ತ್ಯಾಲ್ಯಾನಾ ದಿಲ. ");
INSERT INTO gok_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","ನಂತರ್ ಲೊಕಾಂಚಾನಿ ಆಪ್‌ಲ್ಯಾಲಾ ರಾಜಾ಼ ವ್ಹಯಿ ಮನ್ಹುನ್ ಮಾಗ್ಲ. ದೇವಾನಿ ತ್ಯನಾ ಕೀಶಚಾ಼ ಲ್ಯೊಕ್ ಜಾ಼ಲ್ಯಾಲ್ಯಾ ಸೌಲಾಲಾ ದಿಲಾ. ಸೌಲ್ ಬೆನ್ಯಾಮಿನ್ ಕುಳಾತ್ಲಾ. ತ್ಯೊ ಚಾಳಿಸ್ ವರ್ಸಾ ಪರತ್ ರಾಜಾ಼ ವ್ಹವುನ್ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","ದೇವಾನಿ ಸೌಲಾಲಾ ಕಾಡುನ್ ಟ್ಯಾಕ್‌ಲ್ಯಾವ ದಾವಿದಾಲಾ ತ್ಯಂಚಾ಼ ರಾಜಾ಼ ಕೇಲಾ ಇಶಾಯಾಚಾ಼ ಲ್ಯೊಕ್ ದಾವಿದ್ ಮನಾ ಆವಾಡಲ್ಯಾಲಾ ತ್ಯೊ ಮಾಜಾ ಮನಾಜು಼ಗಿ ಕಾಮ ಕರ್ತೊ’ ಮನ್ಹುನ್ ದೇವಾನಿ ದಾವಿದಾಚೆ ಗುಶ್ಟಿತ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","ದೇವಾನಿ ಆಪ್‌ಲ್ಯಾ ವಾಗ್ದಾನಾಚೆಗತ್ ದಾವಿದಾಚಾ ವಂಶಾತ್‍ಲ್ಯಾ ಯಕಾಲಾ ಇಸ್ರಾಯಲಾಚಾ಼ ರ‍್ಯಾಕ್ನಾರಾ ಮನ್ಹುನ್ ಲಾವುನ್ ದಿಲ್ಯಾ. ತ್ಯೊಸ್ ಯೇಸು. ");
INSERT INTO gok_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","ಯೇಸು ಯಯಾಚೆ ಆಂದಿ ಸ್ನಾನಿಕ್ ಯೊಹಾನಾನಿ ಯೆಹುದಿ ಲೊಕಾನಾ ಸಗ್‌ಳ್ಯಾ, “ತುಮ್ಚಾ ಪಾಪಾಸಾಟಿ ಪಶ್ಚಾತಾಪಾನಿ ದೇವಾಕ್ಡ ಪರ್ತುನ್ ಬಾಪ್ತಿಸ್ಮಾ ಗೆವ್ಹಾ. ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","ಮಿ ಕೋನ್ ಮನ್ಹುನ್ ತುಮಿ ಯವಸ್ತಾಸಾ ? ಮೀ ಕ್ರಿಸ್ತ ನವ್ಹ ತ್ಯೊ ಮಾಜೆ ನಂತರ್ ಯನಾರ್. ತ್ಯಚೆ ಪಾಯಾತ್ಲೆ ವ್ಹಾನಚಾ಼ ಪಟ್ಟಾ ಸೊಡಾಯಾಬಿ ಮಿ ಲಾಯಿಕ್ ನಾಹಿ. ಮನ್ಹುನ್ ಸ್ನಾನಿಕ್ ಯೊಹಾನಾನಿ ಆಪ್ಲಿ ಕಾಮ ಕರುನ್ ಪುರಿ ಕಿಲಿತ ತವಾ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","ಮಾಜಾ ಬಾವ್ಹಾನು ಅಬ್ರಹಾಮಾಚಾ ಕುಟ್ಮಾತಲ್ಯಾನು ಖರ‍್ಯಾ ದೇವಾಲಾ ವವ್ಯಾಳ್‌ತ್ಯಾಲ್ಯಾ ಯೆಹುದಿ ನಸ್‌ಲ್ಯಾಲ್ಯಾನು ಐಕಾ ಹ್ಯೊ ರ‍ಕ್ಷೆನೆಚಾ಼ ಸಾಂಗ್ ಲಾವುನ್ ದಿಲ್ಯಾಲಾ ಆಮ್ಚಿಸಾಟಿಸ್. ");
INSERT INTO gok_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","ಯೇರುಸಲೆಮಿತ್ ಜಿವ್ನಾ ಕರ್ತ್ಯಾಲ ಯೆಹುದಿ ಆನಿ ಯೆಹುದಿ ಜಾಂತ್ಯಾಂಚಾನಿ ಯೇಸುಸ್ ಸುಡಿವ್ನಾರಾ ಮನ್ಹುನ್ ಸಮಜು಼ನ್ ಗೆತ್ಲ ನವ್ಥ. ಪ್ರವಾದಿಂಚಾನಿ ಯೇಸುಚೆ ಗುಶ್ಟಿತ್ ಲಿವ್‌ಲ್ಯಾಲ ಸಬಾತ್ ಪರತೆಕ್ ಸಬ್ಬತ್ ದಿಸಾದಿಸಿ ವಾಚ್ವಿತಿತ. ಫನ್ ತ್ಯಂಚಾನಿ ಸಮಜು಼ನ್ ಗೆತ್ಲ ನಾಹಿ. ತ್ಯಾ ಯೆಹುದ್ಯಾಂಚಾನಿ ಯೇಸುಲಾ ಗುನ್ನಾದಾರ್ ಮನ್ಹುನ್ ತಿರ್ಪ್ ದಿಲಾ. ಆಸ ಕರತ್ಯಾಲ್ಯಾಸ್ ಲಾಗುನ್ ಪ್ರವಾದಿಚ಼ ಸಬಾತ್ ಘಢ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","ಯೇಸು ಮರಾಯಾಸ್ ವ್ಹಯಿ ಮನ್ಹುನ್ ಶಾರ್ಕಾ ಕಾರನ್ ತ್ಯನಾ ದರಾಯಾ ಜಾ಼ಲಾನಾಹಿತರಿ ಯೇಸುಲಾ ಮಾರುನ್ ಟಾಕಾಯಾಸ್ ಪಾಯ್ಜೆ ಮನ್ಹುನ್ ಪಿಲಾತಾಪ ಮಾಗುನ್ ಗೆತ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","ಪವಿತ್ರ ಪುಸ್ತಾಕಾತ್ ಲಿವ್‌ಲ್ಯಾಚೆಗತ್ ಯೇಸುಲಾ ವ್ಹಯಾ ವ್ಹಯಿ ಜಾ಼ಲ್ಯಾಲ ಸಗ್ಳ ಯೆಹುದ್ಯಾಂಚಾನಿ ಕೆಲ. ನಂತರ್ ತ್ಯಂಚಾನಿ ಯೇಸುಲಾ ಶಿಲ್ಬೆತ್ನಿ ಖಾಲ್ ಉತ್ರುನ್ ಮಸುರ್ಡಿತ್ ಥೆವ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","ಫನ್ ದೇವಾನಿ ತ್ಯಲಾ ಮೆಲ್ಯಾಲ್ಯಾತ್ನಿ ಜಿ಼ತ್ತಾ ಕೆಲಾ! ");
INSERT INTO gok_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","ಹ್ಯ ಜಾ಼ಲ್ಯಾವ ಗಲಿಲಾಯಾತ್ನಿ ಯೆಸುಸಂಗ ಯೆರುಸಲೆಮಿತ್ ಆಲ್ಯಾಲ್ಯಾಂಚಾನಿ ಖುಬ್ ದಿಸಾಪರತ್ ತ್ಯಲಾ ಬಗ್ಲಾ ತವಾ ತ್ಯಚೆ ಗುಶ್ಟಿತ್ ತೆಸ್ ಲೊಕಾನಾ ಸಾಕ್ಷಿ ಜಾ಼ಲ. ");
INSERT INTO gok_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","ದೇವಾನಿ ಆಮ್ಚಾ ವಡ್ಲಾನಾ ಕೆಲ್ಯಾಲ್ಯಾ ವಾಗ್ದಾನಾಚೆ ಗುಶ್ಟಿತ್ ಬರಿ ಖಬರ್ ಆಮಿ ತುಮನಾ ಸಾಂಗ್ತಾವ್. ");
INSERT INTO gok_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ಆಮಿ ತ್ಯಂಚಿ ಪಿಳ್ಗಿಜಾ಼ಲ್ಯಾವ್. ದೇವಾನಿ ಯೇಸುಲಾ ಮೆಲ್ಯಾಲ್ಯಾತ್ನಿ ಜಿತ್ತಾ ಕರುನ್ ಉಟಿವಲ್ಯಾಲ್ಯಾಸ್ ಲಾಗುನ್ ತ್ಯ ವಾಗ್ದಾನ್ ಆಮ್ಚಿಸಾಟಿ ಘಡಿವಲ್ಯಾತಾ. ಹ್ಯೆಚೆ ಗುಶ್ಟಿತ್ ದೊನ್ವೆ ಕಿರ್ತನೆತ್ ಆಸ ಲಿವ್‌ಲ್ಯಾ: ಹ್ಯಾ ಯಳಾತುಸ್ ಮಿ ತುಲಾ ಬಾ ಜಾ಼ಲ್ಯೊ. ");
INSERT INTO gok_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","ದೇವಾನಿ ಯೇಸುಲಾ ಜಿತ್ತಾ ಕರುನ್ ಉಟಿವಲ್ಯಾ ಮನ್ಹುನ್ ತ್ಯೊ ಹಿತ್ನಿ ಮೊರ‍್ಹ ಮಸುರ್ಡಿತ್ ಕುಜ಼ತ್ನಾಹಿ ಮನ್ಹುನ್ ದೇವ್ ಆಸ ಮಂಥೊ: ");
INSERT INTO gok_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","ಫನ್ ಆನಿಯಕಾ ಜಾ಼ಗ್ಯಾವ ದೇವ್ ಆಸಾ ಮಂಥೊ: ತು ತುಜಾ ಸೆವಕಾಚ಼ ಶರಿರ್ ಕುಜು಼ದಿಯಿತ್ ನಾಹಿಸ್. ");
INSERT INTO gok_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","ದಾವಿದಾನಿ ಆಪ್ಲಾ ಜಿವ ಆಸ ಪರತ್ ದೇವಾಚಾ ಮನಾಶಾರ್ಕಾ ಜಿವ್ನಾ ಕೆಲಾ. ನಂತರ್ ತ್ಯೊ ಮರುನ್ ಗೆಲಾ. ದಾವಿದಾಲಾ ತ್ಯಚಾ ವಡ್ಲಾಂಚೆ ಸಂಗ ಮಾತಿ ದಿಲಿ. ತ್ಯಚ಼ ಶರಿರ ಮಸುರ್ಡಿತ್ ಕುಜ಼ುನ್ ಗೆಲ! ");
INSERT INTO gok_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","ಫನ್ ದೇವಾನಿ ಜಿತ್ತಾ ಕರುನ್ ಉಟಿವಲ್ಯಾಲ್ಯಾ ಯೇಸುಚ಼ ಶರೀರ್ ಮಸುರ್ಡಿತ್ ಕುಜ಼್ಲ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","ಭನ್ಹಿ ಬಾವ್ಹಾನು ಯೇಸುಪ್ನಿಸ್ ಪಾಪ ಮಾಪ್ ವ್ಹತ್ಯಾತ ಹ್ಯ ತುಮನಾ ಠಾವ ರಾಹುನಿ. ");
INSERT INTO gok_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","ಮೊಶೆಚಾ ನೇಮಾನಿ ಸುಟಕಿ ವ್ಹವುನ್ ನಿಯೆತಿಚಿ ವ್ಹಯಾಚೆ ಆಂದಿ ಹಾಸಾ. ಫನ್ ತ್ಯಚಿವ ಇಸ್ವಾಸ್ ಥೆವಲ್ಯಾಲಿ ಸಗ್ಳಿ ತ್ಯಚಿಪ್ನಿ ಸುಟ್ಕಿ ವ್ಹವುನ್ ನಿಯೆತಿಚಿ ಮನ್ಹುನ್ ಗೆನ್ಹಾರ್. ");
INSERT INTO gok_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","ಮನ್ಹುನ್ ಪ್ರವಾದಿಂಚಾನಿ ಸಾಂಗ್‌ಲ್ಯಾಲ್ಯಾ ಹ್ಯಾ ಖನ್ಕತಿ ತುಮ್ಚಿಪ ಖರ‍್ಯಾ ವ್ಹಯಾಚೆ ಆಂದಿ ಹುಶಾರ್ ರಾವ್ಹಾ; ");
INSERT INTO gok_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","ಆರ, ನಕೊ ಮಂತ್ಯಾಲ್ಯಾನು, ಆಜಾಬ್ ವ್ಹವಾ, ನಾಸ್ ವ್ಹವುನ್ ಜಾ಼ವಾ. ತುಮ್ಚಾ ಕಾಲಾತ್ ಮಿ ಯಾಕ್ ಕಾಮ್ ಕರ್ನಾರ್; ತ್ಯ ಕಾಮ್ ಯಕಾನಿ ತುಮಾನಾ ಫುಡುನ್ ಸಾಂಗ್ಲ ತರಿ ತುಮಿ ಜ಼ರಾಬಿ ಖರ ದರ‍್ನಾರ್ನಾಹಿಸಾ!’ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","ಪೌಲ್ ಆನಿ ಬಾರ್ನಬ್ ಸಬಾಸ್ಥಾನಾತ್ನಿ ಜಾ಼ತಾನಾ ಹ್ಯಾ ಖನ್ಕತಿಚೆ ಗುಶ್ಟಿತ್ ಆಜು಼ನ್ ಖುಬ್ ಸಾಂಗಾಯಾಸಾಟಿ ಮೊರ್‌ಲ್ಯಾ ಸಬ್ಬತ್ ದಿಸಾದಿಸಿ ಆನಿಕ್ ಯಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಲೊಕಾಂಚಾನಿ ತ್ಯಲಾ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","ಸಬೆ ಸಪ್ಲಿತವಾ ಯೆಹುದ್ಯಾತ್ಲ ದೆವಾವ ಬಕ್ತಿ ಆಸಲ್ಯಾಲ ಖುಬಜಾ಼ನ್ ಪೌಲ್ ಬಾರ್ನಬಾಚೆ ಮಾಗ್ನಿ ಗೆಲ. ಹೆ ತ್ಯಂಚಿ ಸಂಗ ಬುಲುನ್ ದೆವಾಚೆ ಕ್ರುಪೆನಿ ಉಬಿರಾಹ್ಯಾ ವ್ಹಯಿಸಾ ಮನ್ಹುನ್ ಉಮೇದ್ ದಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","ಮೊರ್‌ಲ್ಯಾ ಸಬ್ಬತ್ ದಿಸಾತ್ ಪ್ರಭುಚಾ ವಾಕ್ಯಾ ಐಕಾಯಾಸಾಟಿ ಖುಬ್ ಗಾವಾತ್ಲಿ ಲೊಕ ಸಗ್ಳಿ ಹಿಂಡಾನಿ ಆಲಿತ. ");
INSERT INTO gok_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","ಹ್ಯ ಬಗ್‌ಲ್ಯಾಲ ಯೆಹುದ್ಯಾನಾ ಖೊಟಫನ್ ಆಲ. ಆನಿ ತೆ ಪೌಲಾಚಾ ಬೊಲನ್ಯಾಲಾ ಆಡ್ಯಾವಿತ್ ಹುತ. ");
INSERT INTO gok_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","ಫನ್ ಪೌಲ್ ಬಾರ್ನಬ್ ಧಿರಾನಿ ಬುಲುನ್, “ಆಮಿ ದೇವಾಚಿ ವಾಕ್ಯಾ ಯೆಹುದಿ ಜಾ಼ಲ್ಯಾಲ್ಯಾ ತುಮಾನಾಸ್ ಸಾಂಗಾಯಾ ವ್ಹಯಿ. ಫನ್ ತುಮಿ ತುಮಾನಾಸ್ ಶಾಸ್ವತ್ ಜಿವಾಲಾ ಉಪೆಗ್ ನಸಲ್ಯಾಲಿ ಮನ್ಹುನ್ ನಕ್ವಾಟ್ ಕರ್ತ್ಯಾಸಾ. ಮನ್ಹುನ್ ಆಮಿ ಯೆಹುದಿ ನಸ್‌ಲ್ಯಾಲ್ಯಾಂಚಿಪ ಜಾ಼ತಾವ್! ");
INSERT INTO gok_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","ಕಾ ಮಂಜೆ ಪ್ರಭುನಿ ಆಮಾನಾ ದಿಲ್ಯಾಲಿ ಆಜ್ಞಾ ಆಸಿ ಹಾ: ತು ದುನೆಚೆ ಸಗ್ಳಿಕ್ಡ ಸುಡಿವ್ನಾರಾ ಜಾ಼ಲ್ಯಾಚೆಗತ್ ತುಲಾಬಿ ಯೆಹುದಿ ನಸ್‌ಲ್ಯಾಲ್ಯಾ ಲೊಕಾನಾಬಿ ಉಜಿಡ್ ಕರುನ್ ಥರಿವಲ್ಯಾ ಮನ್ಹುನ್ ದೆವಾನಿ ಸಾಂಗ್‌ಲ್ಯಾ” ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","ತಿಥ ಪೌಲಾಚಾ ಬೊಲ್ಯಾ ಐಕ್‌ಲ್ಯಾಲ ಯೆಹುದಿ ನಸ್‌ಲ್ಯಾಲಿ ಲೊಕ ಖುಬ್ ಸಂತೊಶಾನಿ ಸಂದೆಶಾಸಾಟಿ ಸ್ತುತಿಕಿಲಿ. ಶಾಸ್ವತ್ ಜಿವ್ ಗಿಹ್ಯಾ ನಿವಡ್‌ಲ್ಯಾಲ್ಯಾ ಸಗ್‌ಳ್ಯಾಂಚಾನಿ ಇಸ್ವಾಸ್ ಥೆವ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","ಪ್ರಭುಚ಼ ಸಂದೆಶ್ ಸಗ್ಳೆ ಸಿಮತ್ ಪಗಾಳ್ಳಾ. ");
INSERT INTO gok_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","ಫನ್ ಯೆಹುದ್ಯಾಂಚಾನಿ ಆಪಲ್ಯಾ ದರ್ಮಾವ ಬಕ್ತಿ ಆಸಲ್ಯಾಲ್ಯಾ ಉಡಾಳ್ ಬಾಯಿಲ್ಮಾನ್ಸಾನಾ, ಗಾವಾಚಾ ಜಾಂತ್ಯಾನಾ ಪೌಲ್ ಬಾರ್ನಬಾವ ತೆ ರಾಗಾವ ಯಯಿಶಾರ್ಕ ಚಾ಼ವಳುನ್ ತ್ಯನಾ ಆಪಲ್ಯಾ ಪ್ರಾಂತ್ಯಾತ್ನಿ ಬಾಹಿರ್ ಗ್ಯಾತ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","ತ್ಯಂಚಾನಿ ಆಪ್‌ಲ್ಯಾ ಪಾಯಾಂಚಿ ಧುಳ್ ಜಾ಼ಢುನ್ ಇಕೊನಿಯಾ ಪೆಠತ್ ಗೆಲ. ");
INSERT INTO gok_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","ಫನ್ ಯೇಸುಚ಼ ಅಂತಿಯೊಕ್ಯಾಚ಼ ಇಸ್ವಾಸಿ ಸಂತೊಶಾನಿ ಪವಿತ್ರಾತ್ಮಾನಿ ಬರ್‌ಲ್ಯಾಲ ಜಾ಼ಲ್ತ. ");
INSERT INTO gok_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","ಇಕೊನ್ಯಾತ್ ಪೌಲ್ ಆನಿ ಬಾರ್ನಬ ತೆಸ್ ತರನಿ ಯೆಹುದ್ಯಾಂಚಾ ಸಭಾಸ್ಥಾನಾತ್ ಜಾ಼ವುನ್ ಹುಕುಮ್ ದಿಲ್ಯಾಲ ಸಿಕ್ಷಾನ್ ದಿವುನ್ ಬೊಲ್ಲ ಮನ್ಹುನ್ ಯೆಹುದ್ಯಾತ್‍ಲ್ಯಾ, ಗ್ರೀಕಾತಲ್ಯಾ ಖುಬ್ ಲೊಕಾಂಚಾನಿ ಇಸ್ವಾಸ್ ಥೆವ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","ಫನ್ ಇಸ್ವಾಸ್ ನಸ್‌ಲ್ಯಾಲ ಯೆಹುದ್ಯಾಂಚಾನಿ, ದಿಸರ‍್ಯಾ ಲೊಕಾಂಚಿ ಮನ ಹ್ಯಾ ಬಾವ್ಹಾಚೆ ಆಡ್ವಿ ಚಾ಼ವಳುನ್ ಹಾಳ್ ಕಿಲಿತ. ");
INSERT INTO gok_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","ಆಸ ಆಸ್ತಾನಾ ತೆ ಖುಬ್ ದಿಸ್ ತಿಥ ರಾಹುನ್ ಪ್ರಭುನಿ ತ್ಯಂಚಾ ಹಾತಾನಿ ಚಮತ್ಕಾರಾಚಿ ಆನಿ ಅದ್ಬುತಾಚಿ ಕಾಮ ವ್ಹಯಿ ಶಾರ್ಕ ಕರುನ್ ಆಪ್ಲೆ ಕ್ರಪಾ ವಾಕ್ಯಾಲಾ ಸಾಕ್ಷಿ ದಿಲಿ ಮನ್ಹುನ್ ತ್ಯಂಚಿವ ಇಸ್ವಾಸ್ ಥಿವುನ್ ದಿರ‍್ಹಾನಿ ಬೊಲತ. ");
INSERT INTO gok_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","ತವಾ ತ್ಯಾ ಗಾವಾತಲ್ಯಾ ಲೊಕಾಂಚಿ ದುಯಿ ಜಾ಼ಲಿ; ಥುಡಿ ಜ಼ನ ಯೆಹುದ್ಯಾಂಚಿಪ ಗಿಲಿತ, ಆನಿ ಥುಡಿ ಅಪೊಸ್ತಲಾಂಚಿಪ ಗಿಲಿತ. ");
INSERT INTO gok_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","ದುಸ್ರಿ ಲೊಕ, ಯೆಹುದಿ ಆನಿ ತ್ಯಂಚ಼ ಫುಡಾರಿ ಮಿಳುನ್ ಆಪ್‍ಲ್ಯಾ ಅಧಿಪತಿಚಾ ಹುಕ್ಮಾನಿ ಅಪೊಸ್ತಲಾನಾ ತರಾಸ್ ದಿಯಾ, ದೊಂಡ್ಯಾಂಚಾನಿ ಮಾರಾಯಾ ಗೆಲ, ");
INSERT INTO gok_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","ತ್ಯ ಅಪೊಸ್ತಲಾಂಚಾನಿ ಸಮಜು಼ನ್ ಗಿಹುನ್ ತಿತ್ನಿ ಪಳುನ್ ಜಾ಼ವುನ್ ಲುಕ್ಯವೊನ್ಯಾತ್ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ಲುಸ್ತ್ರ ಆನಿ ದೆರ್ಬೆ ಪೆಠತ್ನಿ ಸರ್ಬೌತಚಾ ಗಾವಾತ್ನಿ ಗೆಲ. ");
INSERT INTO gok_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","ತಿಥ ಬರಿ ಖಬರ್ ಸಾಂಗ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","ಲುಸ್ತ್ರಾ ಪೆಠತ್ ಪಾಯಾನಾ ಬಳ್ ನಸ್‌ಲ್ಯಾಲಾ ಯೊಕ್ ಮಾನುಸ್ ಬಸ್‌ಲ್ಯಾಲಾ ಹುತ್ತಾ. ತ್ಯೊ ಜ಼ಲ್ಮತ್ ಲಂಗಡಾ ವ್ಹವುನ್ ಹುತ್ತಾ. ತ್ಯೊ ಕಂದಿಸ್ ಚಾ಼ಲ್ಲಾ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","ಪೌಲ್ ಬೊಲ್‌ತ್ಯಾಲ್ಯಾ ಬೊಲ್ಯಾ ತ್ಯೊ ಕಾನ್ ದಿವುನ್ ಐಕಿತಾ. ಪೌಲಾನಿ ತ್ಯಲಾ ಜ಼ಪುನ್ ಬಗುನ್ ಬರ ವ್ಹಯಾ ವ್ಹಯಿತ್ಯೊ ಇಸ್ವಾಸ್ ಹಾ; ");
INSERT INTO gok_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","“ತುಜ಼ ಪ್ಯಾ ಟಿಕುವುನ್ ನಿಟ್ ಉಬಾರ‍್ಹಾ” ಮನ್ಹುನ್ ಜೊ಼ರಾನಿ ಸಾಂಗ್ಲ. ತವಾಸ್ ತ್ಯೊ ಮಾನುಸ್ ಉಡಿ ಮಾರುನ್ ಚಾ಼ಲಾಯಾ ಲಾಗ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","ಪೌಲಾನಿ ಕೆಲ್ಯಾಲಿ ಕಾಮ ಜ಼ಮಲ್ಯಾಲ್ಯಾ ಲೊಕಾಂಚಾನಿ ಬಗುನ್; “ದ್ಯಾವ್ ಮಾನ್ಸಾಂಚ಼ ಆವ್ತಾರ್ ಗಿವ್ಹುನ್ ಆಮ್ಚಿಪ ಉತ್ರುನ್ ಆಲ್ಲ” ಮನ್ಹುನ್ ಲುಕವೊನ್ಯಾ ಭಾಶೆತ್ ವರಡಾಯಾ ಲಾಗ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","ಬಾರ್ನಬಾಲಾ ದ್ಯೌಸ್, ದೇವ್ ಮನ್ಹುನ್ ಪೌಲ್ ಚಾ಼ಂಗ್ಲಾ ಭಾಶಾನ್ ಕರ್ನಾರಾ ಮನ್ಹುನ್ ತ್ಯಲಾ ‘ಹೆರ್ಮೆ’ ದೇವ್ ಮಂಥ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","ಗಾವಾಚೆ ಮೊರ್ಹ ಆಸ್‌ಲ್ಯಾಲಾ ದ್ಯೌಸ್ ದೇವಾಚಾ ದೆವ್ಳಾಚಾ಼ ಪುಜಾರಿ ಬೈಲ, ಪುಲಾಚಾ ಮಾಳಾ ಗಾವಾಚಾ ದಾರಾಪ ಬಾರ್ನಬ ಆನಿ ಪೌಲಾಚೆ ಮೊರ್ಹ ಆನುನ್ ಲೊಕಾಂಚೆ ಸಂಗ ಕಾಪಾಚ಼ ಮನ್ಹುನ್ ಕೆಲ. ");
INSERT INTO gok_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","ಹ್ಯ ಐಕುನ್ ಅಪೊಸ್ತಲ್ ಜಾ಼ಲ್ಯಾಲಾ ಬಾರ್ನಬ ಆನಿ ಪೌಲಾನಿ ಆಪ್ಲ ಕಪ್ಡ ಫಾಟುನ್ ಲೊಕಾಂಚಾ ಹಿಂಡಾತ್ ಬರ‍್ಹುನ್ ಆಸ ವರ್ಡುನ್ ಸಾಂಗ್ಲ; ");
INSERT INTO gok_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“ಲೊಕಾನು, ತುಮಿ ಆಸಿ ಕಾ ಕರ್ತ್ಯಾಸಾ? ಆಮಿ ತುಮ್ಚಿಗತ್ ಮಾನ್ಸ ಜಾ಼ಲ್ಯಾವ್. ತುಮಿ ಹ್ಯ ನಕೊ ಜಾ಼ಲ್ಯಾಲ ಕಾಮ್ ಸುಡುನ್ ಅಬಾಳ್ ಧರ್ಥಿ ಸಮಿಂದೊರ್ , ತ್ಯಾತ್ ಆಸ್‍ಲ್ಯಾಲ ಸರ್ವ ಉತ್ಪನ್ ಕೆಲ್ಯಾಲ್ಯಾ ಜೀವ್ ಆಸ್ನಾರ‍್ಯಾ ದೇವಾಕ್ಡ ಪರ್ತಾಲಾ ವ್ಹಯಿಸಾ ಮನ್ಹುನ್ ಬರಿ ಖಬರ್ ತುಮಾನಾ ಸಾಂಗಾಯಾ ಆಮಿ ಹಿತ್ತ ಹಾವ್. ");
INSERT INTO gok_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","ಗೆಲ್ಯಾಲ್ಯಾ ಕಾಲಾತ್ ತ್ಯನಿ ಸಗಳ್ಯಾ ಲೊಕಾನಾ ಆಪ್‌ಲ್ಯಾಲಾವಾಟಲ್ತಸಿ ಚಾ಼ಲಾಯಾ ಸುಡುನ್ ದಿಲಿತ. ");
INSERT INTO gok_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","ಫನ್ ದೇವಾನಿ ಆಪ್‌ಲ್ಯಾ ತಾಬ್ಯಾತ್ ಆಸ್‌ಲ್ಯಾಲ ಸಮಜಾ಼ಯಾ ಸಾಟಿ ಚಾ಼ಂಗಲ್ಯಾ ಕಾಮಾಸ್ ಲಾಗುನ್ ವಳಕ್ ದಿಯಿತುಸ್ ಆಲ್ಯಾ; ಆಬ್ಳಾತ್ನಿ ಪಾವುಸ್ ಶಾರ್ಕ್ಯಾ ಯಳಾಲಾ ಯವುನ್, ಪೀಕ್ ದಿವುನ್, ಜೆವಾನ್ ದಿವುನ್ ತುಮ್ಚಿ ಮನ ಸಂತೊಶಾನಿ ಬರ‍್ಹುನ್, ಮಜ಼ತ್ ಕರಿತ್ ಆಲ್ಯಾಲಾ ತ್ಯೊಸ್” ಮನ್ಹುನ್ ಸಾಂಗ್‍ತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","ಬಾರ್ನಬಾನಿ ಆನಿ ಪೌಲಾನಿ ಹ್ಯಾ ಬೊಲ್ಯಾ ಸಾಂಗ್‌ಲ್ಯಾತರಿ ಲೊಕ ಆಪ್‌ಲ್ಯಾ ಯಜ್ಞಾ ದೆತ್ಯಾಲಿ ಥಾಂಬ್ವಾಯಾ ಜಾ಼ಲ್ಹನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","ನಂತರ್ ಅಂತಿಯೊಕ್ಯಾತ್ನಿ, ಇಕೊನ್ಯಾತ್ನಿ ಯೆಹುದ್ಯಿ ಯವುನ್, ಲೊಕಾನಾ ಚಾ಼ವಳುನ್ ಪೌಲಾಲಾ ಮಾರುನ್ ಟಾಕಾಯಾ ಧೊಂಡ ಮ್ಯಾರ್ಲ, ತ್ಯೊ ಮೆಲಾ ಮನ್ಹುನ್ ಸಮಜು಼ನ್ ಗಾವಾಚೆ ಬಾಹಿರ್ ತ್ಯಲಾ ವಡುನ್ ಲ್ಯಾವ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","ಫನ್ ಶಿಶಾ ತ್ಯಚೆ ಸರ್ಬೌರ್ ಉಬ್ಬ ಆಸ್ತಾನಾ ತ್ಯೊ ಉಟುನ್ ಪೆಠತ್ ಗೆಲಾ. ದುಸ್ರೆ ದಿಸಿ ಪೌಲ್, ಬಾರ್ನಬಾ ಸಂಗ ದೆರ್ಬೆತ್ ನಿಗಾಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","ತೇ ಪೆಠತ್ ಪೌಲ್ ಆನಿ ಬಾರ್ನಬಾನಿ ಬರಿ ಖಬರ್ ಸಾಂಗುನ್ ಖುಭ್ ಜ಼ನಾನಾ ಶಿಶಾ ಕೆಲ್ಯಾ ನಂತರ್ ಮಾಗಾರ ಲುಸ್ತ್ರಾತ್, ಇಕೊನ್ಯಾತ್, ಅಂತಿಯೊಕ್ಯಾತ್ ಆಲ. ");
INSERT INTO gok_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","ತಿಥ ಶಿಶಾಂಚಿ ಮನ ಘಟ್ ಕರುನ್ ಕ್ರಿಸ್ತಾಚಾ ಇಸ್ವಾಸಾತ್ ಘಟ್ ಉಬ ರಾವ್ಹಾ ಮನ್ಹುನ್ ಉಮೆದ್ ದೆತ್ಯಾತ. ಆಮಿ ಖುಬ್ ತರಾಸ್ ಖಾವುನ್ ದೇವಾಚಾ ರಾಜಾತ್ ಜಾ಼ಯಾವ್ಹಯಿ ಮನ್ಹುನ್ ಸಿಕಿವ್‌ತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","ಯವ್ಡಸ್ ನವ್ಹ ಪರ್ತೆಕ್ ಸಭೆಲಾ ಜಾಂತ ಥರಿವ್ಲ. ಉಪಾಸ್ ಕರುನ್ ಮಾಗ್ನ ಕರುನ್ ತ್ಯಂಚಾನಿ ಇಸ್ವಾಸ್ ಥೆವ್‌ಲ್ಯಾಲ್ಯಾ ಪ್ರಭುಚಾ ಹಾತಾತ್ ತ್ಯನಾ ದಿಲ. ");
INSERT INTO gok_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","ನಂತರ್ ಪಿಸಿದ್ಯಾ ಸೀಮಾ ವಲ್ಯಾಂಡುನ್ ಪಂಪುಲ್ಯಾ ಸೀಮತ್ ಆಲ. ");
INSERT INTO gok_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","ತ್ಯಲಾ ಮಿಳಾಲ್ಯಾಲ್ಯಾ ಪೆರ್ಗೆ ಗಾವಾತ್ ಪ್ರಭುಚ಼ ವಾಕ್ಯಾ ಸಾಂಗ್‌ಲ್ಯಾ ನಂತರ್ ಅತಾಲ್ಯ ಪೆಠತ್ ಗೆಲ. ");
INSERT INTO gok_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","ತಿತ್ನಿ ಸಮಿಂದೊರಾವ್ನಿ ಜಾ಼ವುನ್ ಅಂತಿಯೊಕ್ಯಾತ್ ಪೊಚ಼್ಲ. ತ್ಯೆ ಆಜು಼ನ್ ಪರತ್ ಕರಿತ್ ಆಲ್ಯಾಲ್ಯಾ ಕಾಮಾ ಸಾಟಿ ಆಪ್‌ಲ್ಯಾಲಾಸ್ ಆಪ್ನು ದೇವಾಚೆ ಕ್ರಪೆಚಾ ಹಾತಾತ್ ಆಂದಿ ದಿಲ್ಯಾಲ ಹ್ಯಾಸ್ ಗಾವಾತ್. ");
INSERT INTO gok_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","ತಿಥ ಮಂಡಳಿ ಮಿಳ್ವುನ್, ದೇವ್ ಆಪ್ಲಿ ಸಂಗ ಆಸುನ್ ಕೆಲ್ಯಾಲಿ ಕಾಮ ಸಗ್ಳಿ, ತ್ಯನಿ ಯೆಹುದಿ ನಸ್‌ಲ್ಯಾಲ್ಯಾನಾ ಇಸ್ವಾಸಾಚ಼ ದಾರ್ ಉಗಡಲ್ಯಾಲ ವಿವರನ್ ಕರುನ್ ತ್ಯನಾ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","ನಂತರ್ ತ್ಯೆ ತಿಥ ಇಸ್ವಾಸಿಂಚೆ ಸಂಗ ಖುಬ್ ದೀಸ್ ರಾಯ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","ನಂತರ್ ಥೊಡಜಾ಼ನ್ ಯುದಾಯಾತ್ನಿ ಅಂತಿಯೊಕ್ಯಾತ್ ಯವುನ್; “ತುಮಿ ಮೊಶೆಚಾ ಧರ್ಮಶಾಸ್ತಾರಾತ್ ಸಾಂಗ್‌ಲ್ಯಾಲ್ಯಾ ನೆಮಾಚೆ಼ಗತ್ ಮುಂಜಿ಼ ಕರುನ್ ಗೆತಲ್ಯಾ ನಸ್‌ಲ್ಯಾವ ತುಮಾನಾ ರಕ್ಶನ್ ವ್ಹನಾರ್ ನಾಹಿ” ಮನ್ಹುನ್ ಬಾವ್ಹಾನಾ ಸಿಕ್ವಿತ. ");
INSERT INTO gok_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","ತ್ಯಂಚಿ ಸಂಗ ಪೌಲ್ ಆನಿ ಬಾರ್ನಬಾಂಚಾ಼ ಚರ್ಚಾ ಆನಿ ಮೊಟಾ ವಾದ ಲಾಗ್ಲಾ ತವಾ ಪೌಲ್, ಬಾರ್ನಬಾ ಆನಿ ಆಪ್ಲಿಪ್ಲ ದುಸ್ರ ಥೊಡಜಾ಼ನ್ ಯೆರುಸಲೇಮಾತ್ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ಸಭೆಚಾ ಜಾಂತ್ಯಾಚಾಂಪ್ನಿ ಆನಿ ಅಪೊಸ್ತಲಾಂಚಾಪ್ನಿ ಜಾ಼ಯಾವ್ಹಯಿ ಮನ್ಹುನ್ ಬಾವ್ಹಾಂಚಾನಿ ತಿರ್ಮಾನ್ ಕೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","ಆನಿ ಸಭೆತ್‌ಲ್ಯಾಂಚಾನಿ ತ್ಯನಾ ಲಾವುನ್ ದಿಲ ತವಾ ತ್ಯೆ ಪೊಯಿನಿಕೆ ಆನಿ ಸಮಾರ‍್ಯಾ ಸೀಮಾ ವಲ್ಯಾಂಡುನ್ ಜಾ಼ತಾನಾ ಯೆಹುದಿ ನಸ್‌ಲ್ಯಾಲಿ ಪ್ರಭುಕ್ಡ ಪರಾತ್‌ಲ್ಯಾಲ್ಯಾ ಖನ್ಕತಿ ತಿತಲ್ಯಾ ಇಸ್ವಾಸಿನಾ ಉಗ್ಡುನ್ ಸಾಂಗಲ್ಯಾ ತವಾ ತ್ಯನಾ ಸಗ್‌ಳ್ಯಾನಾ ಖುಬ್ ಸಂತೊಶ್ ಜಾ಼ಲ್ಹಾ. ");
INSERT INTO gok_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","ತ್ಯೆ ಯೆರುಸಲೇಮಾತ್ ಆಲ್ಯಾ ನಂತರ್ ಸಭೆತ್ಲ ಅಪೊಸ್ತಲ್ ಸಭೆಚಾ ಜಾಂತ್ಯಾಂಚಾನಿ ತ್ಯನಾ ಮಿಳ್ವುನ್ ಗೆತಲ್ಯಾ ನಂತರ್ ದೇವಾನಿ ಆಪ್ಲಿ ಸಂಗ ರಾಹುನ್ ಕೆಲ್ಯಾಲಿ ಕಾಮ ತ್ಯನಾ ಸಾಂಗ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","ಫನ್ ಪರಿಸಾಯ ಧರ್ಮಾತ್ಲಿ ಯೇಸುವ ಇಸ್ವಾಸ್ ಥೆವ್‌ಲ್ಯಾಲಿ ಥುಡಿ ಉಟುನ್; “ದೇವಾಕ್ಡ ಪರಾತ್‌ಲ್ಯಾಲ್ಯಾ ಯೆಹುದಿ ನಸ್‌ಲ್ಯಾಲ್ಯಾನಾ ಮುಂಜಿ಼ ಕರಾಯಾವ್ಹಯಿ, ಆನಿ ಮೊಶೆಚಾ ಧರ್ಮಶಾಸ್ತಾರಾಚೆಗತ್ ಚಾ಼ಲಾಯಾ ತ್ಯನಾ ಆಜ್ಞೆ ದಿಯಾವ್ಹಯಿ” ಮನ್ಹುನ್ ಸಾಂಗ್‌ತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","ಫನ್ ಅಪೊಸ್ತಲ್ ಸಬೆಚ಼ ಜಾಂತ ಹೆ ಗುಶ್ಟಿತ್ ಯವಜಾ಼ಯಾ ಮಿಳುನ್ ಆಲ್ಲ ತವಾ, ತ್ಯಂಚಾತ್ ಖುಬ್ ಚರ್ಚಾ ಚಾ಼ಲ್ಯಾ ನಂತರ್ ಪೇತ್ರಾ ಉಟುನ್ ತ್ಯನಾ; ");
INSERT INTO gok_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","“ಬನ್ಹಿ ಬಾವ್ಹಾನು, ದುಸರ‍್ಯಾ ಲೊಕಾಂಚಾನಿ ಮಾಜಾ ತೊಂಡಾನಿ ಬರೆ ಖಬ್ರಿಚಾ ವಾಕ್ಯಾ ಐಕುನ್ ಇಸ್ವಾಸ್ ತೆವಾಯಾವ್ಹಯಿ ಮನ್ಹುನ್ ದೇವಾನಿ ಖುಬ್ ದಿಸಾಚೆ಼ ಮಾಗ ತುಮ್ಚೆ ಮದ್ದಿ ಮನಾ ನಿವಡ್‌ಲ್ಯಾಲ ತುಮಾನಾ ಠಾವ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","ಆನಿ ಮನ್ ಸಮಜು಼ನ್ ಗೆತಲ್ಯಾಲ್ಯಾ ದೇವಾನಿ ಕಸ ಪವಿತ್ರಾತ್ಮ ಆಮಾನಾ ದಿಲ್ಯಾ ತಸಸ್ ತ್ಯನಾ ದಿವುನ್ ಸಾಕ್ಷಿ ದಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","ಯವ್ಡಸ್ ನವ್ಹ ತ್ಯೊ ಆಮಾನಾಬಿ, ತ್ಯನಾಬಿ ಕಾಯೆಕ್ ಬುರ್ಸ ಕರಾಚೆ ಆಂದಿ ತ್ಯಂಚಿ ಮನ ಇಸ್ವಾಸಾಸ್ ಲಾಗುನ್ ಚಾ಼ಂಗ್ಲಿ ಕಿಲಿತ. ");
INSERT INTO gok_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","ಆಸ ಆಸ್ಥಾನಾ ಆಮ್ಚ಼ ವಡಿಲ್ ವ್ಹವುನ್ತ, ಆಮಿವ್ಹವುನಿ ನಿಹ್ಯಾ ವ್ಹಯಿತ್ ನಸ್‌ಲ್ಯಾಲ ವಜ಼ ತುಮಿ ಇಸ್ವಾಸಿಂಚಾ ಖಾಂದ್ಯಾವ ದಿವುನ್ ದೇವಾಚಿ ಪಾರಕ್ ಕರಾಚಿ ಕಾ? ");
INSERT INTO gok_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","ಪ್ರಭು ಯೇಸು ಕ್ರಿಸ್ತಾಚೆ ಕ್ರಪಾನಿಸ್ ಆಮಿ ರಕ್ಶನ್ ಗೆನಾರ್ ಮನ್ಹುನ್ ಇಸ್ವಾಸ್ ಥೆವ್ತಾವ್ ನವ್ಹ; ತಸಸ್ ತೇ ಗೆನಾರ್” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","ಜ಼ಮಲ್ಯಾಲ್ಯಾ ಸಗಳ್ಯಾಂಚಾನಿ ಹ್ಯಾ ಬೊಲ್ಯಾ ಐಕುನ್ ಗಪ್ ರಾವುನ್ ಬಾರ್ನಬ ಆನಿ ಪೌಲ್ ಆಪ್ಲಿಪ್ನಿ ದೇವಾನಿ ದುಸರ‍್ಯಾ ಲೊಕಾಂಚೆ ಮದಿ ಕೆಲ್ಯಾಲಿ ಸಗ್ಳಿ ಚಮತ್ಕಾರಾಚಿ ಕಾಮ, ಚಾ಼ಂಗ್ಲಿ ಸಗ್ಳಿ ಕಾಮ ಸಾಂಗ್‌ಲ್ಯಾಲಿ ಧ್ಯಾನ್ ದಿವುನ್ ಐಕ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","ತ್ಯಂಚಾನಿ ಬೊಲ್ನ ಸಪಿವ್‌ಲ್ಯಾ ನಂತರ್ ಯಾಕೊಬಾನಿ ತೆ ಗುಶ್ಟಿಚ಼ ಸಾಂಗ್‌ಲ್ಯಾಲ ಕ್ಯಾ ಮಂಜೆ; “ಬನ್ಹಿ ಬಾವ್ಹಾನು, ಮೀ ಸಾಂಗತ್ಯಾಲ ಐಕಾ. ");
INSERT INTO gok_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","ದೇವಾನಿ ಆಂದಿ ಯೆಹುದಿ ನಸ್‌ಲ್ಯಾಲ್ಯಾನಾ ಕ್ರಪೆನಿ ಬಗುನ್ ಆಪ್‌ಲ್ಯಾ ನಾವಾಸಾಟಿ ತ್ಯಂಚಾತ್ನಿ ಯಕಾಲಾ ನಿವಡ್‌ಲ್ಯಾಲಿ ರಿತ್ ಸಿಮೆಯೊನಾನಿ ಸಾಂಗ್‍ಲ್ಯಾ ತ್ಯವ್ಡಸ್. ");
INSERT INTO gok_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","ಪ್ರವಾದಿಚಾ ಬೊಲ್ಯಾ ಸಾಹಿತ್ ಹ್ಯಲಾ ವ್ಹಯ್ ಮಂತ್ಯಾತಾ. ಕಶಾ ಮಂಜೆ ಪವಿತ್ರ ಪುತಿಕಾತ್ ಲಿವ್‌ಲ್ಯಾಚೆಗತ್; ");
INSERT INTO gok_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","“ಹ್ಯ ಜಾಲ್ಯಾ ನಂತರ್ ಮೀ ಮಾಗಾರಾ ಪರ್ತುನ್ ಯವುನ್ ದಾವೀದಾಚ಼ ರಾಜ ಪಡಲ್ಯಾಲ ಪರ್ತುನ್ ಬ್ಯಾನ್ನಾರ್. ಹಾಳ್ ಪಡ್ಯಾಲ ಬರಕರುನ್ ಶಾರ್ಕ ಬ್ಯಾನ್ನಾರ್ ಆನಿ ತ್ಯ ಘಟ್ ಕರ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","ಉರ್ಲ್ಯಾಲಿ ಸಗ್ಳಿ ಮಾನ್ಸಾಚಿ ಜಾತ್ ಮಾಜಿಕ್ಡ ಯಯಿಲ್ ಯೆಹುದ್ಯ ನಸ್‌ಲ್ಯಾಲ್ಯಾ ಲೊಕಾನಾ ಸಾಹಿತ್ ಹಾಕ್ಟುನ್ ಮಾಜಾ ಸ್ವತಾಚಾ ಲೊಕಾಂಚೆಗತ್ ಕರ್ನಾರ್ ಮನ್ಹುನ್ ಪ್ರಭು ಸಾಂಗ್‌ತ್ಯೊ. ");
INSERT INTO gok_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","ಪೈಲೆದರ್ನಿ ಹ್ಯೀ ಕಾಮ ಸಾಂಗುನ್ ದಿಲ್ಯಾತ, ");
INSERT INTO gok_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“ಆಸ ಆಸ್ತಾನಾ ಮಾಜ಼ ಮನ್ಹ ಕ್ಯಾ ಮಂಜೆ; ದುಸರಿ ಲೊಕಾ ದೇವಾಕ್ಡ ಪರಾತಾನಾ ತರಾಸ್ ಕರಾಚಾ಼ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","ಫನ್ ಪಾಶಾನಾನಾ ಥೆವಲ್ಯಾಲಾ ನಿವದ್ ಖಾವುನಾಹಿ, ವ್ಯಭಿಚಾರ್, ಮಾನ್ ಆವಳುನ್ ಮ್ಯಾರ್ಲ್ಯಾಲ, ರಗಾತ್ ಖಾಯಾಚ಼ ನಾಹಿ ಆಸ ಆಮಿ ತ್ಯನಾ ಪತ್ರ ಲಿವುಯಾ ಮನ್ಹುನ್ ನಿರ್ದಾರ್ ಕರ್ತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","ಕಾ ಮಂಜೆ ಪೈಲೆಠವ್ನಿ ಸಗ್ಳೆ ಪೆಠತ್ನಿ ಮೊಶೆಚ಼ ಧರ್ಮಶಾಸ್ತಾರಾಚ಼ ಶಿಕಿವ್‍ತ್ಯಾಲ ಹಾತ್ತ; ತ್ಯ ಪರ್ತೆಕ್ ಸಬ್ಬತ್ ದಿಸಾಸಿದಿ ಸಭಾಸ್ಥಾನಾತ್ನಿ ವಾಚಿವ್‍ತ್ಯಾತ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","ತವಾ ಅಪೊಸ್ತಲ್, ಸಬೆಚ಼ ಜಾಂತ ಸಗ್‍ಳ್ಯಾ ಸಭೆಚಾ ಹುಕ್ಮಾನಿ ಆಪ್‌ಲ್ಯಾತಲ್ಯಾ ಥೊಡ್ಯಾನಾ ನಿವ್ಡುನ್ ಪೌಲ್ ಆನಿ ಬಾರ್ನಬಾ ಸಂಗ ಅಂತಿಯೊಕ್ಯಾತ್ ಲಾವುನ್ ದಿಯಾಚ಼ ಬರ ಮನ್ಹುನ್ ನಿರ್ಧಾರ್ ಕರ್ತ್ಯಾತ. ತ್ಯಚಿಸ್ ಲಾಗುನ್ ಇಸ್ವಾಸಿಂಚಾತ್ ಫುಡಾರಿ ಜಾ಼ಲ್ಯಾಲ್ಯಾ ಬಾರ್ಸಬ್ಬ ಮಂಥ್ಯಾಲ್ಯಾ ಯುದಾಲಾ, ಸೀಲಾಲಾ ನಿವ್ಡುನ್ ಗಿಹುನ್, ");
INSERT INTO gok_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","ತ್ಯಚಾ ಹಾತಾತ್ ಲಿವುನ್ ದಿಲ್ಯಾಲ ಕ್ಯಾ ಮಂಜೆ; “ಬಾಹು, ಅಪೊಸ್ತಲ್ ಆನಿ ಜಾಂತ, ಅಂತಿಯೊಕ್ಯಾ, ಸಿರಿಯ, ಕಿಲಿಕ್ಯ ಸೀಮತ್ನಿ ರಾತ್ಯಾಲಿ ದುಸರ‍್ಯಾ ಲೊಕಾತ್ನಿ ಇಸ್ವಾಸಿ ಜಾ಼ಲ್ಯಾಲ್ಯಾನಾಬಿ ನಮಸ್ಕಾರ್; ");
INSERT INTO gok_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","“ಆಮ್ಚಿಪ್ಲ ಥೊಡಜಾ಼ನ್ ಆಮ್ಚಿ ಪರ್ವಾನ್ಗಿ ನಸ್ತಾನಾ ಆಪ್‌ಲ್ಯಾ ಬೊಲ್ಯಾಂಚಾನಿ ತುಮ್ಚಿ ಮನ ಹಾಳ್ ಕೆಲ್ಯಾಲಿ ಆನಿ ಗೊಂದೊಳ್ ಗ್ಯಾತ್‌ಲ್ಯಾಲಾ ಐಕಲ್ಯಾ ಮನ್ಹುನ್. ");
INSERT INTO gok_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","ಆಮಿ ಸಗ್ಳ ಯಕಿಕ್ಡ ವ್ಹವುನ್ ತುಮ್ಚಿಪ ಆಮ್ಚೆ ಮಾಯೆಚ಼ ಭಾಹು ಜಾ಼ಲ್ಯಾಲ ಪೌಲಾಚೆ ಆನಿ ಬಾರ್ನಬಾಚೆ ಸಂಗ ಲಾವುನ್ ದೆತ್ಯಾವ್. ");
INSERT INTO gok_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ಆಮ್ಚೆ ಮಾಯೆಚಾ಼ ಬಾರ್ನಬ ಆನಿ ಪೌಲಾಂಚೆ ಸಂಗ ತುಮ್ಚಿಪ ಲಾವುನ್ ದಿಯಾಚ಼ ಚಾ಼ಂಗ್ಲ ಮನ್ಹುನ್ ಆಮಿ ಥೊಡ್ಯಾನಾ ನಿವ್ಡುನ್ ಗಿಹುನ್ ಆಮಚಾ಼ ಪ್ರಭು ಜಾ಼ಲ್ಯಾಲ್ಯಾ ಯೇಸು ಕ್ರಿಸ್ತಾಚೆ ಸೆವೆತ್ ಜೀವ್ ಒಪ್ಸುನ್ ದಿಲ್ಯಾ, ");
INSERT INTO gok_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","ಮನ್ಹುನ್ ಯುದಾಲಾ, ಸೀಲಾಲಾ ಲಾವುನ್ ದೆತ್ಯಾವ್. ತ್ಯಂಚಾನಿ ಆಮಿ ಲಿವ್‌ಲ್ಯಾಲ್ಯಾ ಹ್ಯಾ ಗುಶ್ಟಿ ತೊಂಡಾನಿ ಸಾಂಗನಾರ್. ");
INSERT INTO gok_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","ತ್ಯೊ ಕಚಾ಼ ಮಂಜೆ, ಪಾಶಾನಾನಾ ಥೆವಲ್ಯಾಲಾ ನಿವದ್, ರಗಾತ್, ಮಾನ್ ಆವಳುನ್ ಮ್ಯಾರ್‌ಲ್ಯಾಲ ಜ಼ನಾವಾರ, ನಿಯತಿಚೆ ಆಡ್ವ ಕೆಲ್ಯಾಲ ಸೊಡಾಯಾ ವ್ಹಯಿ ಜಾ಼ಲ್ಯಾ ");
INSERT INTO gok_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","ಹ್ಯಚಿವ್ನಿ ಖುಬ್ ವಜ಼ ತುಮ್ಚಿವ ವಾವು ನಾಹಿ ಮನ್ಹುನ್ ಪವಿತ್ರಾತ್ಮಾಚಾ಼ ನಿರ್ದಾರ್; ತ್ಯಲಾ ಆಮಿ ವಪ್‌ಲ್ಯಾವ್ ತುಮಿ ಹೆ ನೆಮ್ ತ್ಯವ್ಡಸ್ ಗಿಹ್ಯಾ ವ್ಹಯಿಸಾ. ತುಮಾನಾ ಚಾ಼ಂಗ್ಲ ವ್ಹನಾರ್. ಬರ ವ್ಹವುನಿ. ");
INSERT INTO gok_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","ಆಸ ತ್ಯಂಚಾನಿ ಪರ್ವಾನ್ಕಿ ಗಿಹುನ್ ಅಂತಿಯೊಕ್ಯಾತ್ ಯವುನ್ ಸಬೆ ಮಿಳ್ವುನ್ ತ್ಯ ಪತ್ರ ತ್ಯಂಚಿಪ ದಿಲ. ");
INSERT INTO gok_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","ಲೊಕಾಂಚೆ ಮೊರ‍್ಹ ಜೊ಼ರಾನಿ ವಾಚ್ವು಼ನ್ ಆನಿ ತ್ಯಾತ್ ಆಸ್‌ಲ್ಯಾಲ ಉಮೆದಿಚಾ಼ ಸಂದೆಶ್ ಐಕುನ್ ದಿರಾನಿ ಆನಂದ್ ಜಾ಼ಲ್ಹ. ");
INSERT INTO gok_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","ಯುದ್, ಸೀಲ್ ಆಪ್ನುಸ್ ಪ್ರವಾದಿ ಜಾ಼ಲ್ತ ಮನ್ಹುನ್ ಬಾವ್ಹಾನಾ ಖುಬ್ ಬೊಲ್ಯಾಂಚಾನಿ ಧೀರ್ ಆನಿ ಬಳ್ ದಿವುನ್ ಘಟ್ಕೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","ತಿಥ ಥೊಡ ದಿಸ್ ಗೆಲ್ಯಾನಂತರ್ ಆಪ್‌ಲ್ಯಾನಾ ಲಾವುನ್ ದಿಲ್ಯಾಲ್ಯಾಚಾಂಪ್ನಿ ಪರ್ತುನ್ ಜಾ಼ಯಾ ಇಸ್ವಾಸಿಚಾಂಪ್ನಿ ಪರ್ವಾನ್ಕಿ ಗೆತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","ಫನ್ ಸೀಲಾಲಾ ತಿಥಸ್ ರಾಹ್ಯಾಚ಼ ಚಾ಼ಂಗ್ಲ ವಾಟ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","ಫನ್ ಪೌಲ್ ಆನಿ ಬಾರ್ನಬಾ ಅಂತಿಯೊಕ್ಯಾತುಸ್ ರಾಹುನ್ ದುಸ್‌ರ‍್ಯಾನಾ ಸಿಕ್ವಿತ್ ಪ್ರಭುಚ಼ ವಾಕ್ಯಾ ಮಂತ್ಯಾಲಿ ಬರಿ ಖಬರ್ ಸಾಂಗಿತ್ ಹುತ. ");
INSERT INTO gok_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","ಥೊಡ ದಿಸ್ ಜಾ಼ಲ್ಯಾ ನಂತರ್ ಪೌಲ್ ಬಾರ್ನಬಾಲಾ; “ಆಮಿ ಪ್ರಭುಚಿ ವಾಕ್ಯಾ ಸಾಂಗ್‌ಲ್ಯಾಲ್ಯಾ ಸಗ್‌ಳ್ಯಾ ಗಾವಾತ್ನಿ ಪರ್ತುನ್ ಜಾ಼ವುನ್ ತಿತ್ಲಿ ಇಸ್ವಾಸಿ ಕಸ ಹಾತ ಮನ್ಹುನ್ ಬಗುಯಾ ಯೆ” ಮನ್ಹುನ್ ಸಾಂಗ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","ತ್ಯಲಾ ಬಾರ್ನಬಾ ಮಾರ್ಕ್ ಮನ್ಹುನ್ ಗೆತ್ಯಾಲ್ಯಾ ಯೊಹಾನಾಲಾ ");
INSERT INTO gok_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","ಆಪ್ಲಿ ಸಂಗ ಹಾಕ್ಟುನ್ ಗಿಹುನ್ ಜಾ಼ವುಯಾ ಮಂತಾನಾ ಪೌಲ್; ಆಮ್ಚಿ ಸಂಗ ಸೇವೆಲಾ ಯಯಾಚೆ ಆಂದಿ ಪಂಪುಲ್ಯಾತ್ ಆಮಾನಾ ಸುಡುನ್ ಗೆಲ್ಯಾಲ್ಯಾಲಾ ಹಾಕ್ಟುನ್ ನಿಹ್ಯಾಚಾ಼ ಶಾರ್ಕ ನವ್ಹ ಮನ್ಹುನ್ ಯವಜ಼್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","ಹ್ಯೆ ಗುಸ್ಟಿತ್ ಖುಬ್ ವಾದ್ ವ್ಹವುನ್ ತೆ ಯಗ್ಳ ಜಾ಼ಲ್ಹ. ಬಾರ್ನಬಾ ಮಾರ್ಕಾಲಾ ಹಾಕ್ಟುನ್ ಗಿಹುನ್ ಸಮಿಂದೊರಾಚೆ ವಾಟನಿ ಕುಪ್ರ ದ್ವೀಪಾತ್ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","ಪೌಲ್ ಸೀಲಾಲಾ ಗಿಹುನ್ ಇಸ್ವಾಸಿಂಚಾಪ್ನಿ ಪ್ರಭುಚಾ ಕ್ರಪಾಚಾ ಹಾತಾತ್ ದಿವುನ್ ತಿತ್ನಿ ");
INSERT INTO gok_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","ತ್ಯೊ ನಿಗುನ್ ಸಿರಿಯಾ ಆನಿ ಕಿಲಿಕ್ಯಾ ಸೀಮತ್ನಿ ಫಿರತ್ ಸಬೆ ಘಟ್ ಕರ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","ತ್ಯಾ ನಂತರ್ ತ್ಯೊ ದೆರ್ಬೆಲಾ, ಲುಸ್ತ್ರಾತ್ ಆಲಾ. ಲುಸ್ತ್ರಾತ್ ತಿಮೊತಿ ಮಂತ್ಯಾಲಾ ಯೊಕ್ ಶಿಶಾ ಹುತಾ. ತ್ಯೊ ಕ್ರಿಸ್ತಾವ ಇಸ್ವಾಸ್ ಥೆವ್‌ಲ್ಯಾಲಾ ತ್ಯೊ ಯಕ ಯೆಹುದ್ಯಿ ಬ್ಯಾಯ್ಕಾಮಾನ್ಸಾಚಾ಼ ಲ್ಯೊಕ್ ತಿಬಿ ಇಸ್ವಾಸಿ ಜಾ಼ಲ್ಥಿ. ತ್ಯಚಾ಼ ಬಾ ಗ್ರೀಕ್. ");
INSERT INTO gok_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","ತ್ಯೊ ಲುಸ್ತ್ರಾತ್, ಇಕೊನ್ಯಾತ್ ಹುತ ತ್ಯಾ ಇಸ್ವಾಸಿಂಚಿಪ್ನಿ ಚಾಂಗ್ಲಿ ವಳಕ್ ಗೆತಲ್ಯಾಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","ತ್ಯೊ ಆಪ್ಲಿ ಸಂಗ ಯಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಪೌಲಾನಿ ಮನ್ ಕರುನ್ ತಿತಲ್ಯಾ ಯಹುದ್ಯಾಂಚಿಸ್ಲಾಗುನ್ ತ್ಯಲಾ ಮುಂಜಿ಼ ಕರ್ತೊ, ಕಾ ಮಂಜೆ ತ್ಯಂಚಾ಼ ಬಾ ಗ್ರೀಕ್ ಮನ್ಹುನ್ ಸಗ್‌ಳ್ಯಾನಾ ಠಾವ ಹುತ. ");
INSERT INTO gok_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","ನಂತರ್ ತೇ ಗಾವಾ ಗಾವಾತ್ನಿ ಜಾ಼ತಾನಾ ತಿಥ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ಇಸ್ವಾಸಿನಾ ಯೆರುಸಲೇಮಿತ್ ಆಸ್‍ಲ್ಯಾಲ ಅಪೊಸ್ತಲ್, ಸಬೆಚಾ ಜಾಂತ್ಯಾಂಚಾನಿ ತಿರ್ಮಾನ್ ಕೆಲ್ಯಾಲಾ ನೆಮ್ ತ್ಯನಾ ಸಾಂಗುನ್ ತೇ ತುಮಿ ಪಾಳಾಯಾ ವ್ಹಯಿಸಾ ಮನ್ಹುನ್ ಸಿಕಿವ್‌ತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","ಸಬೆ ಕ್ರಿಸ್ತಾಚಾ ಇಸ್ವಾಸಾತ್ ಘಟ್ ವ್ಹಯಿತ್ ಲೆಕ್ಯಾತ್ ದಿಸುನ್ ದಿಸ್ ವಾಡತ್ ಆಲಿ. ");
INSERT INTO gok_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","ಆಶಾ ಸೀಮತ್ ವಾಕ್ಯಾ ಸಾಂಗು ನಾಹಿ ಮನ್ಹುನ್ ಪವಿತ್ರಾತ್ಮಾನಿ ಥಾಂಬಿವ್ಲ ಮನ್ಹುನ್ ತ್ಯೆ ಪ್ರುಗ್ಯ, ಗಲಾತ್ಯಾ ಸೀಮಾ ವಲ್ಯಾಡುನ್ ಜಾ಼ವುನ್, ");
INSERT INTO gok_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","ಮುಶಾಪ ಜ಼ವಳ್ ಆಲ ತವಾ, ಬಿಥುನ್ಯಾತ್ ಜಾ಼ಯಾ ಯತ್ನ ಕರ್ತ್ಯಾತ. ತಿಥಬಿ ಯೇಸುಚಾ ಆತ್‌ಮ್ಯಾನಿ ತ್ಯನಾ ಜಾ಼ವು ದಿಲ ನಾಹಿತ. ");
INSERT INTO gok_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","ತವಾ ತ್ಯೆ ಮುಶಾವ್ನಿ ತ್ರೊವಾತ್ ಆಲ. ");
INSERT INTO gok_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","ತ್ಯೆ ರಾತಿ ಪೌಲಾಲಾ ಯಾಕ್ ಸಪಾನ್ ಪಡ್ಲ, ಕ್ಯಾ ಮಂಜೆ, ಮಕೆದೊನ್ಯಾ ದೇಶಾತ್ಲಾ ಯೊಕ್ ಮಾನುಸ್ ಉಬಾ ರಾಹುನ್; “ತು ಸಮಿಂದೊರ್ ವಲ್ಯಾಂಡುನ್ ಮಕೆದೊನ್ಯಾತ್ ಯವುನ್ ಆಮಾನಾ ಗಾಹುನ್ ಜಾ಼ಯಾವ್ಹಯಿಸ್ ಮನ್ಹುನ್” ಇನಂತಿ ಕಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","ಪೌಲಾಲಾ ತ್ಯ ದರ್ಶನ್ ದಿಸಲ್ಯಾ ನಂತರ್, ತ್ಯೆ ಸೀಮತ್‌ಲ್ಯಾನಾ ಬರಿ ಖಬರ್ ಸಾಂಗಾಯಾ ದೇವಾನಿ ಆಮಾನಾ ಹಾಕಟ್‌ಲ್ಯಾತ ಮನ್ಹುನ್ ಆಮಿ ಖಾತ್ರಿ ಕರುನ್, ತವಾಸ್ ಮಕೆದೊನ್ಯಾತ್ ನಿಗುನ್ ಜಾ಼ಯಾ ಬಳ್ ಕೆಲ. ");
INSERT INTO gok_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","ಆಮಿ ತ್ರೊವಾತ್ನಿ ಸಮಿಂದೊರಾವ್ನಿ ನಿಟ್ ಸಮೊಥ್ರಾಕೆತ್ ಯವುನ್ ದುಸ್ರೆ ದಿಸಿ ನೆಯಾಪೊಲಿತ್ ಗೆಲಾವ್ ತಿಥ್ನಿ ಫಿಲಿಪಿತ್ ಪೊಚ಼್ಲಾವ್ ");
INSERT INTO gok_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","ತೀ ಮಕೆದೊನ್ಯಾಚಿ಼ ಮೊಟ್ಟಿ ಪ್ಯಾಟ್ ರೊಮಾಪುರಾತ್ಲ ಯಾಕ್ ಗಾವ್ ಜಾ಼ಲ್ಥ. ಹೇ ಪೆಠತ್ ಆಮಿ ಥೊಡ ದಿಸ್ ಹುತಾವ್. ");
INSERT INTO gok_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","ಯಕಾ ಸಬ್ಬತ್ ದಿಸಾತ್ ನ್ಹಚೆ ಕಡಸ್ ದೇವಾಚ಼ ಮಾಗ್ನ ಕರ್ತ್ಯಾಲಾ ಜಾ಼ಗಾ ಹಾ ಮನ್ಹುನ್ ಸಮ್‍ಜು಼ನ್ ಗಾವಾಚಾ ದಾರಾಚೆ಼ ಬಾಹಿರ್ ಜಾ಼ವುನ್ ತಿಥ ಮಿಳುನ್ ಆಲ್ಯಾಲ್ಯಾ ಬ್ಯಾಯ್ಕಾ ಮಾನ್ಸಾ ಸಂಗ್ನಿ ಬಸುನ್ ಬೊಲಾವ್. ");
INSERT INTO gok_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","ಆಮ್ಚಾ ಬೊಲ್ಯಾ ಐಕ್‍ಲ್ಯಾಲ್ಯಾತ್ ಲುದ್ಯಾ ಮಂಥ್ಯಾಲಿ ಯೆಕ್ ಬ್ಯಾಯ್ಕಾ ಮಾನುಸ್ ಹುತಿ. ತೀ ಜಾ಼ಂಬ್ಳ ಕಪ್ಡ ಇಕ್‌ತ್ಯಾಲಿ ಜಾ಼ಲ್ಥಿ, ಥುವತೈರ ಮಂತ್ಯಾಲ್ಯಾ ಗಾವಾತ್ಲಿ, ದೇವಾಲಾ ವವ್ಯಾಳ್‌ತ್ಯಾಲಿ ಜಾ಼ಲ್ಥಿ. ಪೌಲ್ ಸಾಂಗ್‍ತ್ಯಾಲ್ಯಾ ಬೊಲ್ಯಾವ್ನಿ ಲಕ್ಷಾ ದಿಯಾ ಸಾಟಿ ಪ್ರಭುನಿ ತಿಚ಼ ಮನ್ ಉಗಡ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","ತಿನಿ, ತಿಚಾ ಗರಾತಲ್ಯಾಂಚಾನಿ ಬಾಪ್ತಿಸ್ಮಾ ಗೆತಲ್ಯಾ ನಂತರ್, ತೀ; “ಪ್ರಭುವ ಇಸ್ವಾಸ್ ಥೆವ್‍ಲ್ಯಾಲಿ ಮನ್ಹುನ್ ತುಮಿ ಮಾಜೆ ಗುಸ್ಟಿತ್ ಖಾತ್ರಿ ಕೆಲಿ ಆಸ್ಲಿತ ಮಾಜಾ ಗರ‍್ಹಾತ್ ಯವುನ್ ರಾಹ್ಯಾ ವ್ಹಯಿಸಾ ಮನ್ಹುನ್” ಆಮಾನಾ ಬಳ್ ಜು಼ರಿ ಕಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","ನಂತರ್ ಪ್ರಭು ಮಾಗ್ನ ಕರತ್ಯಾಲ್ಯಾ ತ್ಯಾ ಜಾ಼ಗ್ಯಾವ ಆಮಿ ಜಾ಼ತಾನಾ ಘಾಡ್ಪನ್ ಕರತ್ಯಾಲಿ ಯೆಕ್ ಬ್ಯಾಯ್ಕಾಮಾನುಸ್ ಆಮ್ಚಿಪ ಆಲಿ. ತ್ಯಿ ಭವಿಶಾ ಸಾಂಗಿತಿ ಮನ್ಹುನ್ ತಿಚಾ ನವರ‍್ಯಾಲಾ ಖುಬ್ ಪ್ಯಾಯ್ದಾವ್ಹಯಿ. ");
INSERT INTO gok_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","ಪೌಲಾನಿ, ಆಮಿ ಜಾ಼ತಾನಾ ತೀ ಆಮ್ಚೆ ಮಾಗ್ನಿ ಯವುನ್; “ಹ್ಯೆ ಮಾನುಸ್ ಮಹೊನ್ನತ ದೇವಾಚ಼ ಸೇವಕ್; ತುಮಾನಾ ರಕ್ಷನೆಚಾ ವಾಟಾ ಸಾಂಗ್‌ತ್ಯಾತ” ಮನ್ಹುನ್ ವರ್ಡುನ್ ಸಾಂಗಿತಿ. ");
INSERT INTO gok_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","ಖುಬ್ ದಿಸ್ ತೀ ಆಸಿ ಕರಿ ಮನ್ಹುನ್ ಪೌಲಾಲಾ ಖುಬ್ ಬೆಜಾರ್ ವ್ಹವುನ್ ಮಾಗಾರಾ ಪರ್ತುನ್ ತಿಚೆ ಆತ್ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ಬುರ್ಶಾ ಆತ್‌ಮ್ಯಾಲಾ ಮನ್ಲಾ; “ತಿಲಾ ಸುಡುನ್ ಜಾ಼ ಮನ್ಹುನ್ ಯೇಸು ಕ್ರಿಸ್ತಾಚಾ ನಾವಾನಿ ತುಲಾ ಆಜ್ಞಾ ಕರ್ತೊ” ಮನ್ಲಾ. ತವಾಸ್ ತ್ಯ ಸುಡುನ್ ಗೆಲ. ");
INSERT INTO gok_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","ತ್ಯಿಚಾ ದನ್ಯಾಂಚಾನಿ ಆಪ್ಲಾ ಫ್ಯಾಯ್ದಾ ಚು಼ಕ್ಲಾ ಮನ್ಹುನ್ ಸಮ್‍ಜು಼ನ್ ಪೌಲಾಲಾ ಆನಿ ಸೀಲಾಲಾ ದರುನ್ ಬಾಜಾ಼ರಾಚಾ ಜಾ಼ಗ್ಯಾತ್ ಅಧಿಕಾರಿಪ ವಡುನ್ ನೆಲ. ");
INSERT INTO gok_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","ತ್ಯನಾ ಅಧಿಕಾರಿಪ ಆನುನ್; “ಹ್ಯೆ ಮಾನುಸ್ ಯೆಹುದಿ ಹೆ ಆಮ್ಚೆ ಪೆಠತ್ ಖುಬ್ ಗೊಂದೊಳ್ ಉಠಿವತ್ಯಾತ; ");
INSERT INTO gok_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","ತೇ ಆಮ್ಚೆ ಪದ್ದತಿಚಾ ನೆಮಾಚೆ ಆಡ್ವ ಸಿಕಿವ್‌ತ್ಯಾತ ಆಮಿ ರೊಮಾತ್ಲ ಆಸ್ಲಿ ಪದ್ದತ್ ಸ್ವಿಕಾರ್ ಕರುನ್ ಗಿಹ್ಯಾ ವ್ಹಯಿತ್ ನಾಹಿ” ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","ತವಾ ಲೊಕ ಸಗ್ಳಿ ಮಿಳುನ್, ತ್ಯಂಚೆ ಆಡ್ವಿ ಉಟ್ಲಿತ. ಆನಿ ಅಧಿಕಾರ‍್ಯಾಚಾಂನಿ; ತ್ಯಂಚ಼ ಕಪ್ಡ ಪಾಟುನ್, ಕಾಡುನ್, ಚಡಿನಿ ಮಾರಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಪರ್ವಾನ್ಕಿ ದೆತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","ತ್ಯನಾ ಖುಬ್ ತಡಾಕ ಮ್ಯಾರ್ಲ್ಯಾ ನಂತರ್ ತುರುಂಗಾತ್ ಗಾಲುನ್, ಹ್ಯನಾ ಶಾರ್ಕ ರಾಕಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ತುರುಂಗಾಚಾ ಜಾಂತ್ಯಾಲಾ ಆಜ್ಞಾಕಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","ಹ್ಯೊ ಆಸ್ಲಿ ಪರ್ವಾನ್ಕಿ ಗಿಹುನ್ ತ್ಯನಾ ತುರುಂಗಾಚಾ ಆತ್‌ಲ್ಯಾ ಸೊಪ್ಯಾತ್ ಗಾಲ್ಹುನ್ ತ್ಯಂಚಾ ಪಾಯಾನಾ ಲಾಕ್ಡಾಂಚಾ ಫಳ್ಯಾಂಚೆ ಮದ್ದಿ ಗಾಲ್ಹುನ್ ಆವ್ಳುನ್ ಬ್ಯಾಂತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","ಭರ್ ರ‍್ಯಾಚ಼ ಪೌಲ್ ಆನಿ ಸೀಲ್ ಮಾಗ್ನ ಕರಿತ್ ದೇವಾಲಾ ಸ್ತುತಿ ಗೀತ ಮನ್ಹಿತ; ತುರುಂಗಾತ್ ಆಸ್‌ಲ್ಯಾಲಿ ಸಗ್ಳಿ ಕಾನ್ ದಿವುನ್ ಐಕಿತಿತ. ");
INSERT INTO gok_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","ಆಪ್ಚಿತ್ ಮೊಟ್ಟ ಭುಕಂಪ್ ಜಾ಼ಲ್ಹಾ. ತುರುಂಗಾಚಾ಼ ಪಾಯಾ ಸಗ್ಳ ಹಾಲ್ಲಾ. ತವಾಸ್ ದಾರ ಸಗ್ಳಿ ನಿಗ್ಲಿತ, ಸಗ್‌ಳ್ಯಾಂಚಾ ಪಾಯಾಚಾ ಫಳ್ಯಾ ನಿಕ್ಳುನ್ ಪಡ್‍ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","ಆತ್ಮಹತ್ಯೆ ಮನ್ಹುನ್ ಸಾಂಗ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","ಫನ್ ಪೌಲ್ ಮೊಟ್ಯಾನಿ ತ್ಯಲಾ; ತು ಕಾಯ್ ಘಾತ್ ಕರುನ್ ಗಿಹುನಕೊಸ್, ಆಮಿ ಸಗ್ಳಿ ಹಿತ್ತಸ್ ಹಾವ್ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","ತವಾ ತ್ಯೊ; ದಿವ್ವಾ ಆನಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ವರ್ಡುನ್ ಆತ್ ಬಿಹುನ್ ವಾಡತ್ ಪೌಲಾಚೆ಼ ಆನಿ ಸೀಲಾಚೆ಼ ಮೊರ್ಹ ಆಡ್ವಾ ಪಡ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","ಆನಿ ತ್ಯನಾ ಬಾಹಿರ್ ಹಾಕ್ಟುನ್ ಆನುನ್; “ಸ್ವಾಮಿ, ಮೀ ರಕ್ಶನ್ ಗಿಹ್ಯಾ ಕ್ಯಾ ಕರಾಯಾವ್ಹಯಿ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ, ");
INSERT INTO gok_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","ತ್ಯಂಚಾನಿ; ಪ್ರಭು ಜಾ಼ಲ್ಯಾಲ್ಯಾ ಯೇಸುವ ಇಸ್ವಾಸ್ ಥೆವ್, ತವಾ ತು ರಕ್ಷನ್ ಗೆನಾರ್, ಆನಿ ತುಜಾ ಗರಾತ್ಲಿಬಿ ರಕ್ಶನ್ ವ್ಹನಾರ್” ಮನ್ಹುನ್ ಸಾಂಗುನ್, ");
INSERT INTO gok_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","ತ್ಯಲಾಬಿ ತ್ಯಂಚಾ ಗರಾತಲ್ಯಾ ಸಗ್‌ಳ್ಯಾನಾ ದೇವಾಚಾ಼ ಸಂದೇಶ್ ಸಾಂಗ್ಲಾ ");
INSERT INTO gok_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","ತ್ಯಾ ನಂತರ್ ತ್ಯೊ ಭರ್ ರ‍್ಯಾಚಾ಼ ತ್ಯಾಸ್ ಯಳಾಲಾ ತ್ಯನಾ ಹಾಕ್ಟುನ್ ನಿಹುನ್ ತ್ಯಂಚ಼ ಘಾವ್ ದುಹುನ್ ತವಾಸ್ ಆಪ್ನುಬಿ ಆನಿ ಗರ‍್ಹಾತಲ್ಯಾಂಚಾನಿಬಿ ಬಾಪ್ತಿಸ್ಮಾ ಗೆತ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","ನಂತರ್ ತ್ಯನಾ ಆಪ್‌ಲ್ಯಾ ಗರ‍್ಹಾತ್ ಹಾಕ್ಟುನ್ ನಿಹುನ್ ಜೆವಾನ್ದಿಲ. ತ್ಯನಿ ಆಪ್‍ಲ್ಯಾ ಗರಾತಲ್ಯಾಂಚೆ ಸಂಗ ದೇವಾವ ಇಸ್ವಾಸ್ ಥಿವುನ್ ಸಂತೊಶ್ ಜಾ಼ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","ಪಾಂಡ್ರಜಾ಼ಲ ತವಾ ರೊಮಾಚಾ ಥೊಡ್ಯಾ ಅಧಿಕಾರಿಂಚಾನಿ; “ತ್ಯಾ ಮಾನ್ಸಾನಾ ಸುಡುನ್ದೆವಾ” ಮನ್ಹುನ್ ಸಿಪಾಯಿಂಚಿಪ ಸಾಂಗುನ್ ಲಾವುನ್ ದಿಲ. ");
INSERT INTO gok_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","ತುರುಂಗಾಚಾ಼ ಜಾಂತ್ಯಾನಿ ಹೀ ಬುಲಿ ಪೌಲಾಲಾ; “ತುಮಾನಾ ಸೊಡಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಆಮ್ಚಾ ಅಧಿಕಾರಿಂಚಾನಿ ಸಾಂಗಲ್ಯಾ, ಆತಾ ತುಮಿ ಸಮಾಧಾನಾನಿ ಜಾ಼ವಾ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","ತ್ಯಲಾ ಪೌಲ್; “ತೆಂಚಾನಿ ಇಚಾರ್ ಕರಾಚೆ಼ ಆಂದಿ ರೊಮಾಪುರಾಚಾ಼ ಹುಕುಮ್ ಆಸಲ್ಯಾಲ್ಯಾ ಆಮಾನಾ ಸಗ್‌ಳ್ಯಾಂಚೆ ಮೊರ‍್ಹ ಮಾರುನ್ ತುರುಂಗಾತ್ ಗ್ಯಾತ್ಲ; ಆತಾ ಆಮಾನಾ ಗಪ್ ಬಾಹಿರ್ ಲಾವುನ್ ದೆತ್ಯಾತ ಕ್ಯಾ? ತಸ ಕವಾಸ್ ವ್ಹನಾರ್ನಾಹಿ; ತ್ಯಂಚಾನಿಸ್ ಯವುನ್ ಆಮಾನಾ ಬಾಹಿರ್ ನೆಲ್ಹತ ಬರ” ಮನ್ಹುನ್ ಸಾಂಗ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","ಸಿಪಾಯಿಂಚಾನಿ ಹ್ಯ ಅಧಿಕಾರಿಂಚಿಪ ಸಾಂಗ್ಲ ತವಾ ರೊಮಾಪುರಾಚಾ಼ ಹುಕುಮ್ ಆಸಲ್ಯಾಲ ಮನ್ಹುನ್ ಐಕ್ಲ ತವಾ ತೇ ಬಿಹ್ಯಾಲ. ");
INSERT INTO gok_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","ಆನಿ ಪೌಲ್ ಸೀಲಾಚಿಂಪ ಜಾ಼ವುನ್ ಮಾಯೆನಿ ಬುಲುನ್ ತ್ಯನಾ ಬಾಹಿರ್ ಹಾಕ್ಟುನ್ ಆನುನ್; ತುಮಿ ಗಾವ್ ಸುಡುನ್ ಜಾ಼ಯಾವ್ಹಯಿಸಾ ಮನ್ಹುನ್ ಇನಂತಿ ಕರತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","ತವಾ ತ್ಯೆ ತುರುಂಗಾತ್ನಿ ನಿಗುನ್ ಲುದ್ಯಳಾಚಾ ಗರ‍್ಹಾತ್ ಯವುನ್ ಇಸ್ವಾಸಿನಾ ಬಗುನ್ ತ್ಯನಾ ಧೀರ್ ದಿವುನ್ ತಿಥ್ನಿ ನಿಗುನ್ ಗೆಲ. ");
INSERT INTO gok_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","ಪೌಲ್ ಆನಿ ಸೀಲಾ ಮೊರ್ಹ ಜಾ಼ಯಿತ್ ಅಂಫಿಪೊಲಿ ಆನಿ ಅಪೊಲೊನ್ಯಾ ಮಂತ್ಯಾಲ್ಯಾ ಪೆಠಾ ವಲ್ಯಾಂಡುನ್ ಥೆಸಲೊನಿಕಾತ್ ಆಲ. ತಿಥ ಯೆಹುದ್ಯಾಂಚಾ಼ ಯೊಕ್ ಸಭಾಸ್ಥಾನ್ ಹುತಾ. ");
INSERT INTO gok_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","ಪೌಲ್ ಆಪ್ಲೆ ಪದ್ಧತಿಚೆ಼ಗತ್ ತಿತಲ್ಯಾ ಲೊಕಾಂಚಿಪ ಜಾ಼ವುನ್ ತೀನ್ ಸಬ್ಬತ್ ದಿಸಾತ್ ದೇವಾಚಾ ವಾಕ್ಯಾಂಚಾನಿ ತ್ಯಂಚಿ ಸಂಗ ಚರ್ಚಾ ಕರುನ್, ");
INSERT INTO gok_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","ಪಾಯ್ಜೆತ್ಯಾ ವಾಕ್ಯಾಚಾ಼ ಆರ್ಥ ಉಗಡುನ್ ಸಾಂಗಿತ್; ಕ್ರಿಸ್ತ ತರಾಸ್ ಖಾವುನ್ ಮರುನ್ ಉಟುನ್ ಯಯಾಚಿ ಗರಜ಼್ ಹಾ ಮನ್ಹುನ್ ಮೀ ತುಮಾನಾ ಸಾಂಗತ್ಯಾಲಾ ಯೇಸುಸ್ ತ್ಯೊ ಕ್ರಿಸ್ತ ಮನ್ಹುನ್ ” ಮನ್ಹುನ್ ಖರ ಕೆಲ. ");
INSERT INTO gok_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","ತ್ಯಂಚಾತ್ ಥೊಡಜಾ಼ನ್ ದೇವಾಚ಼ ಬಗತ್ ಜಾ಼ಲ್ಯಾಲ್ಯಾ ಗ್ರೀಕಾಂಚಾ಼ ಮೊಟಾ ಹಿಂಡ್ ಆನಿ ಫುಡಾರಿ ಬ್ಯಾಯ್ಕಾಮಾನ್ಸಾತ್ನಿ ಖುಬ್ ಜ಼ನಿ ಒಪ್ಪುನ್ ಪೌಲ ಆನಿ ಸೀಲಾಲಾ ಮಿಳಾಲಿತ. ");
INSERT INTO gok_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","ಯೆಹುದ್ಯಾಂಚಾನಿ ಖೊಟಫನ್ ಕರುನ್ ಪೆಠತ್ ಉದುಗ್ಡಿ ಫಿರತ್ಯಾಲ್ಯಾ ಥೊಡ್ಯಾನಾ ಹಾಕ್ಟುನ್ ಯವುನ್ ಹಿಂಡ್ ಕರುನ್ ಗಾವಾತ್ ಗೊಂದೊಳ್ ಕರುನ್ ಪೌಲಾಲಾ ಆನಿ ಸೀಲಾಲಾ ಪೆಠಚೆ ಸಭೆಚೆ ಮೊರ‍್ಹ ಆನಾಯಾವ್ಹಯಿ ಮನ್ಹುನ್ ತ್ಯನಾ ಸುದಿತ ಯಾಸೊನಾಚ಼ ಘರ್ ಯಡ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","ತ್ಯೆ ಗಾವ್ಲ ನಾಹಿತ ಮನ್ಹುನ್ ತೀ ಲೊಕ ಯಾಸೊನಾಲಾ ಆನಿ ದಿಸರ‍್ಯಾ ಬಾವ್ಹಾನಾ ಗಾವಾಚಾ ಅಧಿಕಾರಿಂಚಿಪ ವಡುನ್ ನಿಹುನ್; “ದುನ್ಯಾ ಉಲ್ಟಿ ಪಲ್ಟಿ ಕೆಲ್ಯಾಲ ತೇ ಮಾನುಸ್ ಹೀತಬಿ ಆಲ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","ಯಾಸೊನಾನಿ ತ್ಯನಾ ಗೆತ್ಲ ಮನ್ಹುನ್, ತ್ಯೆ ಸಗ್ಳ ಯೇಸು ಮಂತ್ಯಾಲಾ ಆನಿ ಯೊಕ್ ರಾಜಾ಼ ಹಾ ಮನ್ಹುನ್ ಸಾಂಗುನ್ ಚಕ್ರವರ್ತಿಚಾ ಆಜ್ಞಾನಾ ಆಡ್ವ ಚಾ಼ಲ್ಯಾತ” ವರಡತ್ ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","ಪೆಠತ್ಲ ಆನಿ ತಿತ್ಲ ಅಧಿಕಾರಿ ಹ್ಯಾ ಬೊಲ್ಯಾ ಐಕುನ್ ಗೊಂದೊಳ್ ವ್ಹವುನ್ ");
INSERT INTO gok_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","ಯಾಸೊನಾನಿ ಆಂದಿಂಚಾಪ್ನಿ ಜಾ಼ಮಿನ್ ಗಿಹುನ್ ನಂತರ್ ತ್ಯನಾ ಸುಡುನ್ ದಿಲ. ");
INSERT INTO gok_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","ತ್ಯಾ ಬಾವ್ಹಾಂಚಾನಿ ರ‍್ಯಾಚ಼ ಪೌಲಾಲಾ ಆನಿ ಸೀಲಾಲಾ ಬೆರೊಯಾತ್ ಲಾವುನ್ ದಿಲ. ತ್ಯೆ ತಿಥ ಮಿಳುನ್ ಯೆಹುದ್ಯಾಂಚಾ ಸಭಾಸ್ಥಾನಾತ್ ಗೆಲ. ");
INSERT INTO gok_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","ತ್ಯೆ ಸಭೆತ್ಲಿ ದೇವಾಚ಼ ವಾಕ್ಯಾ ಚಾ಼ಂಗಲ್ಯಾ ಮನಾನಿ ಗಿಹುನ್ ಹ್ಯಂಚಾನಿ ಸಾಂಗ್‌ಲ್ಯಾಲ್ಯಾ ಬೊಲ್ಯಾ ವ್ಹಯ್ ಕ್ಯಾ ನವ್ಹ ಮನ್ಹುನ್ ಬಗಾಯಾ ಪರ್ತೆಕ್ ದಿಸಿ ಶಾಸ್ತಾರಾಚಾ ಪುತಿಕಾತ್ ಸುದಿತಿತ ಮನ್ಹುನ್ ತೀ ಥೆಸಲೊನಿಕಾತ್‌ಲ್ಯಾಂಚಿವ್ನಿ ಚಾ಼ಂಗಲ್ಯಾ ಗುನಾಚಿ ಜಾ಼ಲ್ತಿತ. ");
INSERT INTO gok_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","ಮನ್ಹುನ್ ತ್ಯಂಚಾತ್ ಬುರಶಾ ಗ್ರೀಕ್ ಬ್ಯಾಯ್ಕಾಂಚಾನಿ, ಗಡ್ಯಾಂಚಾನಿ ಇಸ್ವಾಸ್ ಥೆವ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","ಫನ್ ಪೌಲ್ ಬೆರೊಯಾತ್ ದೇವಾಚ಼ ವಾಕ್ಯಾ ಸಾಂಗತ್ಯೊ ಮನ್ಹುನ್ ಬಾತ್ನಿ ಥೆಸಲೊನಿಕಾತ್‌ಲ್ಯಾನಾ ಯೆಹುದ್ಯಾನಾ ಸಮಾಜ್ಲಿ ಮನ್ಹುನ್ ತೇ ತಿಥಬಿ ಯವುನ್ ಲೊಕಾಂಚಾ ಹಿಂಡಾಲಾ ಉಮೇದ್ ದಿವುನ್ ಪಗಾಳ್ಳ. ");
INSERT INTO gok_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","ತವಾಸ್ ಇಸ್ವಾಸಿ ಪೌಲಾಲಾ ಸಮಿಂದೊರಾಪ ಜಾ಼ಯಾ ಲಾವುನ್ದಿಲಾ. ಫನ್ ಸೀಲ್, ಆನಿ ತಿಮೊಥೆ ತಿಥಸ್ ಥಾಂಬ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","ಪೌಲಾಲಾ ಲಾವುನ್ ದಿಲ್ಯಾಲಾ ತ್ಯಲಾ ಅಥೇನೆಯಾ ಪರತ್ ಹಾಕ್ಟುನ್ ಗಿಹುನ್ ಗೇಲ, ಸೀಲಾಲಾ, ತಿಮೊಥೆಲಾ ಭೇಟ್ ಜಾ಼ಲ್ಯಾ ಬರ್ಬ ಆಪ್ಲಿಪ ಯಯಾವ್ಹಯಿ ಮನ್ಹುನ್ ಪರ್ವಾನ್ಕಿ ಪೌಲಾಪ್ನಿ ಗಿಹುನ್ ನಿಗುನ್ ಆಲ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","ಪೌಲ್ ತ್ಯಂಚಿಸಾಟಿ ಅಥೇನೆಯ ಪೆಠತ್ ರ‍್ಯಾಕ್ತಾನಾ ತ್ಯೆ ಪೆಠತ್ ಸಗ್ಳಿಕ್ಡ ಪಾಶಾನ ಬಗುನ್ ತ್ಯಂಚ಼ ಆತ್ಮ ಖವಾಳ. ");
INSERT INTO gok_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","ಮನ್ಹುನ್ ತ್ಯೊ ಸಭಾಸ್ಥಾನಾತ್ ಯೆಹುದಿ ಆನಿ ದೇವಾಚ಼ ಬ್ಯಾ ಆಸ್‍ಲ್ಯಾಲ ಗ್ರೀಕ್ ಪರ್ತೆಕ್ ದಿಸಿ ಪೆಠತ್ ದಿಸರ‍್ಯಾಂಚೆ ಸಂಗ ಚರ್ಚಾ ಕರ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","ತ್ಯವ್ಡಸ್ ನವ್ಹ ಎಪಿಕುರಿಯಾನಾ, ಸ್ತೊಯಿಕ್ ಮಂತ್ಯಾಲ ಸಗ್‌ಳ್ಯಾಚಾ಼ ಇಚಾರ್ ಆಸ್‌ಲ್ಯಾಲ ಥೊಡ ತ್ಯಂಚಿ ಸಂಗ ಚರ್ಚಾ ಕರ್ತ್ಯಾತ. ತ್ಯಾತ್ಲ ಥೊಡಜಾ಼ನ್; “ಹ್ಯೊ ಬೊಲ್ಕೊರ್ ಕ್ಯಾ ಸಾಂಗಾಯಾವ್ಹಯಿ ಮಂತ್ಯೊ? ಮಂತ್ಯಾತ. ತ್ಯೊ ಯೇಸುಚೆ಼ ಗುಸ್ಟಿಚ಼ ಆನಿ ಮೆಲ್ಯಾಲ ಉಟುನ್ ಯನಾರ್ ಮಂತ್ಯಾಲೆ ಗುಸ್ಟಿಚ಼ ಸಾಂಗ್ತೊ ಮನ್ಹುನ್; “ಹ್ಯೊ ದುಸ್‌ರ‍್ಯಾ ದೇಶಾತ್‌ಲ್ಯಾ ದೇವಾನಾ ಸಾಂಗ್ನಾರಾ ಆಸಾ ದಿಸ್ತೊ ಮನ್ಹುನ್” ದುಸ್‌ರ‍್ಯಾ ಥೊಡ್ಯಾಂಚಾನಿ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","ತ್ಯಂಚಾನಿ ತ್ಯಲಾ ದರುನ್ ಅರಿಯೊಪಾತ್ ಹಾಕ್ಟುನ್ ನಿಹುನ್; “ತು ಸಾಂಗ್‌ತ್ಯಾಲ ಹ್ಯ ನವ ಶಿಕಿವ್ನ ಆಮಿ ಸಮಜು಼ನ್ ಗಿಹ್ಯಾ ವ್ಹಯಿಲ್ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","ಠಾವ್ಯಾ ನಸಲ್ಯಾಲ್ಯಾ ಗುಸ್ಟಿ ಆಮಾನಾ ಸಾಂಗ್‌ತ್ಯೊಸ್ ನವ್ಹ; ಮನ್ಹುನ್ ತ್ಯ ಕ್ಯಾ ಮನ್ಯಾಚ಼ ಸಮಜಾ಼ಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಆಮಾನಾ ಮನ್ ಹಾ” ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","ಅಥೇನಾತ್ಲಿ ತಿಥ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ದುಸರ‍್ಯಾನಾ ನವ್ಯಾ ನವ್ಯಾ ಗುಸ್ಟಿ ಸಾಂಗ್‌ತ್ಯಾತ, ತ್ಯಾ ಐಕಾಚಾ ಸುಡುನ್, ದುಸ್‌ರ‍್ಯಾ ಕಶಾಲಾಸ್ ಯೊಳ್ ದಿಯಿತ್ ನವ್ಥ. ");
INSERT INTO gok_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","ಪೌಲ್ ಅರಿಯೊಪಾಚೆ ನ್ಯಾಯ ಸಭಾಚೆ ಮೊರ‍್ಹ ಉಬಾರಾಹುನ್ ಸಾಂಗ್‌ಲ್ಯಾಲ ಕ್ಯಾ ಮಂಜೆ; “ಅಥೇನಿಯಾ ಲೊಕಾನು, ತುಮಿ ಸಗ್‌ಳ್ಯಾತ್ ಖುಬ್ ದೇವಾಚಿ ಬಕ್ತಿ ಕರ್ತ್ಯಾಲ ಮನ್ಹುನ್ ಮನಾ ದಿಸತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","ಮೀ ತುಮ್ಚೆ ಪೆಠತ್ ಪಿರತ್ ತುಮಿ ಪುಜ಼ತ್ಯಾಲ್ಯಾ ದೇವಾಚಿ ಪಾಶಾನ ಚಾ಼ಂಗ್ಲಿ ಬಗ್‌ತ್ಯಾಲಾ ಆಸ್ಥಾನಾ ಜ಼ನಾವಾರ್ ಮ್ಯಾರ್ತ್ಯಾಲಾ ವೆದಿಚಾ಼ ಜಾ಼ಗಾ ಮಾಜೆ ನದ್ರಲಾ ಪಡ್ಲಾ; ತ್ಯಚಿವ ‘ಸಮಜ಼ತ್ನಸ್‌ಲ್ಯಾಲ್ಯಾ ದೇವಾಲಾ’ ಮನ್ಹುನ್ ಲಿವ್ಲಹುತ್ತ; ಮನ್ಹುನ್ ತುಮಿ ಕಚ಼ಸ್ ಸಮಜಾ಼ಚೆ ಆಂದಿ ಪುಜಾ ಕರ್ತಾಸಾ ತ್ಯಸ್ ತುಮಾನಾ ಸಾಂಗ್ತೊ, ಐಕಾ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“ದುನ್ಯಾ ತ್ಯಾತ್ ಆಸ್‌ಲ್ಯಾಲ ಸಗ್ಳ, ಉತ್ಪನ್ ಕೆಲ್ಯಾಲಾ ದೇವ್ ಆಭಾಳ್ ದರ್ತಿಚಾ಼ ಪ್ರಭು ಜಾ಼ಲ್ಯಾ ಮನ್ಹುನ್ ತ್ಯೊ ಹಾತಾನಿ ಭ್ಯಾಂದ್‌ಲ್ಯಾಲ್ಯಾ ಗರ‍್ಹಾತ್ ರಾನ್ಹಾರಾ ನವ್ಹ; ");
INSERT INTO gok_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","ಆಪ್ನುಸ್ ಸಗ್‌ಳ್ಯಾನಾ ಜೀವ್ ವಾರ ಆನಿ ಪಾಯ್ಜೆತ್ಯ ಸಗ್ಳ ದೆನಾರಾ ವ್ಹವುನ್ ಥೊಡ ಆಸ್‌ಲ್ಯಾಲ ವ್ಹವುನ್ ಮಾನ್ಸಾಂಚಿಪ್ನಿ ಕಾಮ್ ಕರುನ್ ಗೆನಾರಾ ನವ್ಹ. ");
INSERT INTO gok_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","ದೇವ್ ಯಕಾ ಮಾನ್ಸಾಪ್ನಿ ಸಗ್ಳಿ ಮಾನ್ಸ ಉತ್ಪನ್ ಕರುನ್, ತೀ ರಾಹ್ಯಾ ವ್ಹಯಿತ ತೇ ದಿಸ್ ಆನಿ ತ್ಯನಾ ಗರ‍್ಹ ದರ್ತಿವ ಸಗ್ಳಿಕ್ಡ ತ್ಯನಾ ಥಿವುನ್, ");
INSERT INTO gok_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","ಎಕ ಯಳಿ ತೀ ಮಾಗ್ನಿತರಿ ಆಪ್‌ಲ್ಯಾಲಾ ಬಕ್ತಿಲ ಮನ್ಹುನ್ ಆಪ್‌ಲ್ಯಾಲಾ ಶೊದ್ನಾರಿ ಕರ್ತೊ. ತ್ಯೊ ಆಮ್ಚಾತ್ ಯಕಾಲಾಬಿ ದುರ್ ಜಾ಼ಲ್ಹಾ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","ಕಾ ಮಂಜೆ ತ್ಯಚಿಪಸ್ ಆಮಿ ಜೀವ್ನಾ ಕರ್ತಾವ್, ಚಾ಼ಲ್ತಾವ್ ಆನಿ ರಾಥಾವ್. ತುಮ್ಚಾ ಥೊಡ್ಯಾ ಕವಿಂಚಾನಿ, ‘ಆಮಿ ತ್ಯಚೆ ಪಿಳ್ಗಿತ್ಲ’ ಮನ್ಹುನ್ ಸಾಂಗ್‍ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“ಆಮಿ ದೇವಾಚಿ ಪಿಳ್ಗಿತ್ಲಿ ಜಾ಼ಲ್ಯಾ ನಂತರ್ ದೇವ್ ಮಾನ್ಸಾಚಾ ಗಿನ್ಯಾನಾನಿ ಆನಿ ಯವಜ಼ನಾನಿ ಬನಿವಲ್ಯಾಲ, ಸೊನ, ಚಾ಼ಂದಿ ಆನಿ ದೊಂಡ್ಯಾಂಚಿಗತ್ ಮನ್ಹುನ್ ಆಮಿ ಸಮಜು಼ನ್ ಗಿಹುನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","ತ್ಯೆ ಖುಳ್ಯಾಪನಾಚ಼ ದಿಸ್ ದೇವಾನಿ ಲೆಖ್ಯಾತ್ ಗೆತ್ಲ ನಾಹಿತ; ಆತಾತರಿ ತ್ಯೊ ಚಾರಿ ದಿಕಾವಲ್ಯಾ ಪಶ್ಚಾತಾಪಾನಿ ಆಪ್ಲಿಕ್ಡ ಪರ್ತಾಲಾವ್ಹಯಿ ಮನ್ಹುನ್ ಪರ್ವಾನ್ಕಿ ದೆತ್ಯೊ. ");
INSERT INTO gok_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","ಕಾ ಮಂಜೆ, ತ್ಯೊ ತೀರ್ಮಾನ್ ಕೆಲ್ಯಾಲ್ಯಾ ಗಡ್ಯಾಚಾ ಹಾತಾನಿ ನೀತಿಚೆ಼ಗತ್ ದರ್ತಿಚಾ಼ ನ್ಯಾಯಿ ನಿವ್ಡಾಯಾ ಯೊಕ್ ದಿಸ್ ಠಾವಾ ಕೆಲ್ಯಾ. ತ್ಯಲಾ ಮೆಲ್ಯಾಲ್ಯಾಂಚಾತ್ನಿ ಉಟಿವಲ್ಯಾ ಮನ್ಹುನ್ ಹ್ಯಚಿವ ಇಸ್ವಾಸ್ ಥೆವಾಯಾ ಸಗ್‌ಳ್ಯಾನಾ ವಳಕ್ ದಿಲೆ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","ಮೆಲ್ಯಾಲ ವರ್ ಉಠುನ್ ಯನಾರಿ ಗ್ಯೊಶ್ಟ ಐಕ್ಲಿತವಾ ಥೊಡ್ಯಾಂಚಾನಿ ಪೌಲಾಚಿ ಟಿಂಗಲ್ನಾ ಕೆಲಿ, ದುಸರಿ ಥುಡಿಜ಼ನ; “ತು ಹ್ಯೆ ಗುಸ್ಟಿತ್ ಸಾಂಗ್‌ತ್ಯಾಲ ಆಮಿ ಆನಿ ಯಂಗ್ದಾ ಐಕ್ತಾವ್” ಮನ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","ಆಸ ಆಸ್ತಾನಾ ಪೌಲ್ ತ್ಯಂಚೆ ಮದ್ನಿ ನಿಗುನ್ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","ಥುಡಿಜ಼ನ ತ್ಯಚಿಸಂಗ ಜಾ಼ವುನ್ ಇಸ್ವಾಸ್ ಥೆವ್ಲಾ; ಇಸ್ವಾಸ್ ಥೆವ್‌ಲ್ಯಾಲ್ಯಾತ್ ಅರಿಯೊಪಾಗಾಚೆ ಸಬೆಚಾ಼ ದಿಯೊನುಶಾ, ದಾಮರಿ ಮಂತ್ಯಾಲಿ ಆನಿ ಥುಡಿಜ಼ನ ಹುತಿತ. ");
INSERT INTO gok_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","ಹ್ಯ ಜಾ಼ಲ್ಯಾ ನಂತರ್ ಪೌಲ್ ಅಥೇನೆಯಾ ಸುಡುನ್ ಕೊರಿಂಥಾತ್ ಗೇಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","ಪೊಂತ್ಯಾತ್ ಜ಼ಲಾಮಲ್ಯಾಲಾ ಅಕ್ವಿನ್ ಮಂತ್ಯಾಲ್ಯಾ ಯಕಾ ಯೆಹುದಿಲಾ ತಿಥ ಬಗ್ಲಾ. ಯೆಹುದ್ಯಿ ಸಗ್ಳ ರೊಮಾಪುರ್ ಸುಡುನ್ ಜಾ಼ಯಾವ್ಹಯಿ ಮನ್ಹುನ್ ಕ್ಲೌದಿಚಾ ಚಕ್ರವರ್ತಿನಿ ಹುಕುಮ್ ಕೆಲಾ ಮನ್ಹುನ್ ಅಕ್ವಿನ್ ತ್ಯಚಿ ದನ್ಗರ್ ಪ್ರಿಸ್ಕಿಲ್ ಥೊಡ್ಯಾ ದಿಸಾಚೆ಼ ಆಂದಿಸ್ ಇತಾಲ್ಯಾತ್ನಿ ತಿಥ ಆಲ್ತಿತ ಪೌಲ್ ತ್ಯನಾ ಬಗಾಯಾ ಗೆಲಾ, ");
INSERT INTO gok_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","ಕಾ ಮಂಜೆ ತಿಬಿ ತ್ಯಚಿಗತ್ ಕಾಮ್ ಕರ್ತ್ಯಾಲಿ ಜಾ಼ಲ್ತಿತ; ಗುಢಾರ ಕರಾಚ಼ ತ್ಯಂಚ಼ ಕಾಮ್ ಜಾ಼ಲ್ತ. ");
INSERT INTO gok_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","ತ್ಯೊ ಪರತೆಕ್ ಸಬ್ಬತ್ ದಿಸಾತ್ ಸಬಾಸ್ಥಾನಾತ್ ಲೊಕಾಂಚಿಸಂಗ ಚರ್ಚಾ ಕರುನ್ ಯೆಹುದ್ಯಾನಾ ಗ್ರೀಕಾನಾ ಯೆಕ್ ಕರಿ. ");
INSERT INTO gok_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","ಸೀಲಾ ಆನಿ ತಿಮೊಥೆ ಮಕೆದೊನ್ಯಾತ್ನಿ ಆಲ ತವಾ ಪೌಲ್ ದೇವಾಚ಼ ವಾಕ್ಯಾ ಸಿಕ್ವಿತ್ ಯೇಸುಸ್ ಕ್ರಿಸ್ತ ಮನ್ಹುನ್ ಯೆಹುದ್ಯಾನಾ ಸಾಕ್ಷಿ ದೆತೊ. ");
INSERT INTO gok_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","ಫನ್ ತ್ಯಂಚಾನಿ ತ್ಯಚಾ಼ ಇರೊದ್ಕೆಲಾ, ಆನಿ ನಿಂದಾ ಕಿಲಿ ಮನ್ಹುನ್ ತ್ಯೊ ಆಪ್ಲ ಕಪ್ಡ ಜಾ಼ಢುನ್; “ತುಮಿ ಹಾಳ್ ವ್ಹಯಾ ತುಮಿಸ್ ಕಾರನ್ ಮಿ ಜವಾಬ್ದಾರ್ ನಾಹಿ. ಮೀ ಆಚಾನ್ ಯೆಹುದಿ ನಸ್‍ಲ್ಯಾಲ್ಯಾ ಲೊಕಾಂಚಿಪ ಜಾ಼ತೊ” ಮನ್ಹುನ್ ತ್ಯನಾ ಸಾಂಗುನ್, ");
INSERT INTO gok_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","ತ್ಯೊ ಜಾ಼ಗಾ ಸುಡುನ್ ದೇವಾಲಾ ಬಿಥ್ಯಾಲ್ಯಾ ತೀತ್ ಯುಸ್ತ ಮಂಥ್ಯಾಲ್ಯಾಚಾ ಗರ‍್ಹಾತ್ ಗೆಲಾ. ತ್ಯೊ ದೆವಾಲಾ ವವ್ಯಾಳತ್ಯಾಲಾ ಜಾ಼ಲ್ತಾ ತ್ಯಚ಼ ಘರ್ ಸಭಾಸ್ಥಾನಾಪ ಹುತ. ");
INSERT INTO gok_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","ಸಭಾಸ್ಥಾನಾಚಾ಼ ಫುಡಾರಿ ಜಾ಼ಲ್ಯಾಲ್ಯಾ ಕ್ರಿಸ್ತಾನಿ ಆಪ್‍ಲ್ಯಾ ಗರ‍್ಹಾತಲ್ಯಾಂಚೆ ಸಂಗ ಪ್ರಭುವ ಇಸ್ವಾಸ್ ಥೆವ್ಲಾ. ಆನಿ ಕೊರಿಂಥಾತ್ಲಿ ಖುಬ್ ಜ಼ನಾಂಚಾನಿ ಪೌಲಾಚ಼ ಶಿಕ್ಷೆನ್ ಐಕುನ್ ಇಸ್ವಾಸ್ ಥಿವುನ್ ಬಾಪ್ತಿಸ್ಮಾ ಗೆತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","ಪ್ರಭುನಿ ರ‍್ಯಾಚ಼ ಪೌಲಾಲಾ ದರ್ಶಾನ್ ದಿವುನ್; “ತು ಬಿಹುನಕೊ; ಫನ್ ಗಪ್ ರಾಯಾಚೆ಼ ಆಂದಿ ಬರಿ ಖಬರ್ ಸಾಂಗಿತುಸ್ ರ‍್ಹಾ, ");
INSERT INTO gok_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","ಕಾ ಮಂಜೆ ಮೀಸ್ ತುಮ್ಚಿ ಸಂಗ ಹಾ; ಕೊನ್ ತುಲಾ ಬುರ್ಸ ಕರಿತ್ನಾಹಿ; ಹ್ಯೆ ಪೆಠತ್ ಮಾಜಿ ಖುಬ್ ಲೊಕ ಹಾತ” ಮನ್ಹುನ್ ಸಾಂಗತೊ. ");
INSERT INTO gok_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","ತ್ಯೊ ದಿಡ್ ವರಿಸ್ ತಿಥ ರಾಹುನ್ ತ್ಯಾ ಲೊಕಾನಾ ದೇವಾಚಾ ವಾಕ್ಯಾ ಶಿಕ್ವಿತಾ. ");
INSERT INTO gok_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","ಗಲ್ಲಿಯೊನ್ ಅಖಾಯಾಚಾ಼ ಅಧಿಪತಿಹುತಾ ತವಾ ಯೆಹುದ್ಯಿ ಎಕ್‍ವ್ಹವುನ್ ಪೌಲಾಲಾ ದರ‍್ಹುನ್ ನ್ಯಾಯಾಸನಾಚೆ಼ ಮೊರ‍್ಹ ಆನುನ್; ");
INSERT INTO gok_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","“ಹ್ಯೊ ಮಾನುಸ್ ಆಮ್ಚಾ ಧರ್ಮಶಾಸ್ತಾರಾಚೆ ಆಡ್ವಾ ದೆವಾಲಾ ವವ್ಯಾಳಾಲಾ ಲೊಕಾಂಚ಼ ಮನ್ ವಳವಾಯಾ ಖಟಪಟ್ ಕರ್ತ್ಯೊ. ");
INSERT INTO gok_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","ಪೌಲ್ ಬೊಲಾಯಾ ವ್ಹಯಿ ಮನ್ಹಿತಾ ಯವಡ್ಯಾತ್ ಗಲ್ಲಿಯೊನ್, ಯೆಕ್ ಯಳಿ ಹಿ ಮುಟಿ ಚು಼ಕ್ ನಾಹಿತ ಮೊಟಾ ಗುನ್ಹಾ ಜಾ಼ಲ್ಯಾವ ಮಿ ಹೆ ಜವಾಬ್ದಾರಿಚಾ಼ ವ್ಹವುನ್ ಐಕಾಯಾ ವ್ಹಯಿತ. ");
INSERT INTO gok_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","ತುಮಿ ಕರ್ತ್ಯಾಲ ವಾದ್, ತುಮ್ಚಾ ಬೊಲ್ಯಾ ಆನಿ ನಾವ ತುಮ್ಚಾ ಸ್ವತಾಚಾ ಧರ್ಮಶಾಸ್ತಾರಾಲಾ ಸಂಬಂದ್ ಆಸಲ್ಯಾಲ ಹ್ಯ ತುಮ್ಚಿ ಸಾಟಿಸ್ ತುಮಿ ಶಾರ್ಕ ಕರಾಯಾ ವ್ಹಯಿಸಾ ಆಸಲ್ಯಾ ಗುಸ್ಟಿನಾ ಮೀ ನ್ಯಾಯಿ ತಿರ್ಮಾನ್ ಕರಿತ್ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","ಮನ್ಹುನ್ ತ್ಯನಿ ತ್ಯನಾ ನ್ಯಾಯಾಸನಾಚಾ ಜಾ಼ಗ್ಯಾತ್ನಿ ಬಾಹಿರ್ ಗ್ಯಾತ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","ತವಾ ಲೊಕ ಸಗ್ಳಿ ಸಭಾಸ್ಥಾನಾಚಾ಼ ಫುಡಾರಿ ಜಾ಼ಲ್ಯಾಲ್ಯಾ ಸೊಸ್ಥೆನಾಲಾ ದರುನ್ ಕೊರ್ಟಾಚೆ಼ ಮೊರ‍್ಹಸ್ ಮ್ಯಾರ್ತ್ಯಾತ. ಗಲ್ಲಿಯೊನಾನಿ ತ್ಯಾತ್‍ಲ್ಯಾ ಯಕಾವಬಿ ಧ್ಯಾನ್ ದಿಲನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","ಪೌಲ್ ಥೊಡ ದಿಸ್ ತಿಥ ರಾಯಲ್ಯಾ ನಂತರ್ ಶಪತ್ ಕಿಲ್ತಿ ಮನ್ಹುನ್ ಕೆಂಖ್ರೆಯಾಚೆ ಪೆಠತ್ ಕಾಪ್ನಿ ಕರುನ್ ವ್ಹಡಿತ್ ಚ಼ಡುನ್ ಸಿರಿಯಾತ್ ನಿಗಾಲಾ. ಪ್ರಿಸ್ಕಿಲ್ ಆನಿ ಅಕ್ವಿಲ್ ತ್ಯಚಿ ಸಂಗ ನಿಗಾಲಿತ. ");
INSERT INTO gok_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","ಎಫೆಸಾತ್ ಆಲಿತ ತವಾ ತ್ಯನಾ ತಿಥಸ್ ಸುಡುನ್, ಆಪ್ನು ಸಭಾಸ್ಥಾನಾತ್ ಜಾ಼ವುನ್ ಯೆಹುದ್ಯಾಂಚೆ಼ ಸಂಗ ಚರ್ಚಾ ಕರ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","ಲೊಕಾಂಚಾನಿ ತ್ಯಲಾ ಆನಿ ಥೊಡ ದಿಸ್ ತಿತಸ್ ರಾಹ್ಯಾವ್ಹಯಿ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ, ಖರ ತ್ಯೊ ಹು ಮನ್ಲಾ ನಾಹಿ, ");
INSERT INTO gok_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","ಹ್ಯಚೆ ಬದಲಿಸ್ ದೇವಾಚ಼ ಮನ್ ಆಸ್ಲತ ಪರತ್ ತುಮ್ಚಿಪ ಯತೊ” ಮನ್ಹುನ್ ಸಾಂಗುನ್. ನಂತರ್ ಎಫೆಸಾತ್ನಿ ವ್ಹಡಿತ್ ಚ಼ಡುನ್ ಸಮಿಂದೊರಾವ್ನಿ ನಿಗಾಲಾ, ");
INSERT INTO gok_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","ತ್ಯೊ ಕೈಸರ‍್ಯಾತ್ ಯವುನ್ ಪೊಚ಼ಲಾತವಾ ಯೆರುಸಲೇಮಿತ್ ಜಾ಼ವುನ್ ಸಬೆಲಾ ಬೇಟ್ ವ್ಹವುನ್ ಅಂತಿಯೊಕ್ಯಾತ್ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","ಪೌಲ್ ಅಂತಿಯೊಕ್ಯಾತ್ ಥೊಡ ದಿಸ್ ರಾಹುನ್ ಪರತ್ ತಿತ್ನಿ ನಿಗುನ್ ಗಲಾತ್ಯ ಸೀಮತ್, ಪ್ರುಗ್ಯಾತ್ ಪಿರತ್ ಸಗಳ್ಯಾ ಇಸ್ವಾಸಿನಾ ಗಟ್ ಕಿಲಿತ. ");
INSERT INTO gok_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","ತ್ಯವಡ್ಯಾತ್ ಅಲೆಕ್ಸಾಂದ್ರಿಯಾತ್ ಜ಼ಲಾಮಲ್ಯಾಲಾ ಅಪೊಲೊಸ್ ಮಂತ್ಯಾಲಾ ಯೊಕ್ ಯೆಹುದ್ಯಿ ಎಫೆಸಾತ್ ಆಲಾ. ತ್ಯೊ ಬುಲಿಲಾ ಹುಶಾರ್ ಆಸಲ್ಯಾಲಾ ಪವಿತ್ರ ಪುತಿಕಾತ್ನಿ ಹುಶಾರ್ ಆಸಲ್ಯಾಲಾ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","ತ್ಯೊ ಪ್ರಬುಚೆ ಗುಸ್ಟಿತ್ ಚಾ಼ಂಗ್ಲ ಶಿಕ್ಷೆನ್ ಗೆತಲ್ಯಾಲಾ ಜಾ಼ಲ್ತಾ ಆನಿ ತ್ಯೊ ಖುಬ್ ಹೌಸನಿ ಯೆಸುಚೆ ಗುಸ್ಟಿತ್ ಸಾಂಗತೊ ಆನಿ ಶಿಕಿವ್ತೊ ತ್ಯಲಾ ಯೊಹಾನಾನಿ ದಿಲ್ಯಾಲ ಬಾಪ್ತಿಸ್ಮಾ ತ್ಯವ್ಡಸ್ ಠಾವ ಹುತ. ");
INSERT INTO gok_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","ತ್ಯನಿ ಸಬಾಸ್ಥಾನಾತ್ ದಿರ‍್ಹಾನಿ ಬೊಲಾಚ಼ ಸುರುಕೆಲ. ತ್ಯಚಾ ಬೊಲ್ಯಾ ಪ್ರಿಸ್ಕಿಲಾ ಆನಿ ಅಕ್ವಿನಾನಿ ಐಕುನ್ ತ್ಯಲಾ ಆಪ್‍ಲ್ಯಾ ಗರ‍್ಹಾತ್ ಹಾಕ್ಟುನ್ ನಿಹುನ್ ದೇವಾಚಿ಼ ವಾಟ್ ತ್ಯಲಾ ಆನಿ ಶಾರ್ಕಿ ಸಾಂಗ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","ತ್ಯೊ ಅಖಾಯಾತ್ ಪೊಚ಼ಲ್ಯಾ ನಂತರ್ ತಿಥ ದೆವಾಚೆ ಕ್ರಪೆನಿ ಇಸ್ವಾಸಿನಾ ಎಕ್ ಮುಟಿ ಮಜ಼ತ್ ಜಾ಼ಲಿ. ");
INSERT INTO gok_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","ಕಾ ಮಂಜೆ ತ್ಯಚಾ ಮೊಟ್ಯಾ ವಾದ್ ವಿವಾದಾಸ್ಲಾಗುನ್ ಸಗ್‍ಳ್ಯಾಂಚೆ ಮೊರ‍್ಹ ವ್ಹತ್ಯಾಲೆ ಚರ್ಚೆತ್ ಪವಿತ್ರ ಪುತಿಕಾತ್ ಯೆಸುಸ್ ಕ್ರಿಸ್ತ್ ಮನ್ಹುನ್ ಖರಕರುನ್ ಯಹುದ್ಯಾನಾ ಹಾರಿವ್ ತೊ. ");
INSERT INTO gok_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","ಅಪೊಲೊಸ್ ಕೊರಿಂಥಾತ್ ಆಸ್ತಾನಾ ಪೌಲ್ ಮಲಾಡಾತ್ ಪಿರತ್ ಎಫೆಸಾತ್ ಯವುನ್ ಥೊಡ್ಯಾ ಶಿಶಾನಾ ಬಗುನ್; ");
INSERT INTO gok_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","“ತುಮಿ ಇಸ್ವಾಸ್ ತೆವ್ಲಾತವಾ ಪವಿತ್ರಾತ್ಮ ಗೆತಲ್ಯಾಸಾ ಕ್ಯಾ? ಮನ್ಹುನ್ ತ್ಯನಾ ಇಚಾರ್ತಾನಾ ತ್ಯಂಚಾನಿ ತ್ಯಲಾ; “ನಾಹಿ, ಪವಿತ್ರಾತ್ಮ ಹಾ ಮನ್ಹುನ್ ಆಮಿ ಐಕ್ಲಸ್ನಾಹಿ” ಮನ್ಹುನ್ ಉತ್ತರ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","ತವಾ ತ್ಯನಿ; “ತುಮಿ ಕಸ್ಲಿ ಬಾಪ್ತಿಸ್ಮಾ ಗಿತ್ಲಿಸಾ” ಮನ್ಹುನ್ ಇಚಾರ್ಲ್ಯಾಲ್ಯಾಲಾ ತ್ಯಂಚಾನಿ; “ಯೊಹಾನಾಚ಼ ಬಾಪ್ತಿಸ್ಮಾ ಗೆತ್ಲಿ” ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","ತವಾ ಪೌಲಾ “ಯೊಹಾನ್ ಪಾಪ್ ಸುಡುನ್ ದೆವಾಕ್ಡ ಪರಾತಲ್ಯಾಲಾ ಬಾಪ್ತಿಸ್ಮಾ ದಿವುನ್ ಆಪ್ಲೆ ಮಾಗ್ನಿ ಯತ್ಯಾಲ್ಯಾ ಯೆಸುವ ಇಸ್ವಾಸ್ ಥೆವಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಲೊಕಾನಾ ಸಾಂಗ್ತೊ” ಮನ್ಲಾ ತವಾ ");
INSERT INTO gok_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","ತ್ಯಂಚಾನಿ ತ್ಯಾ ಬೊಲ್ಯಾ ಐಕುನ್ ಪ್ರಭು ಯೇಸು ಕ್ರಿಸ್ತಾಚಾ ನಾವಾನಿ ಬಾಪ್ತಿಸ್ಮಾ ಗೆತ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","ಪೌಲಾನಿ ತ್ಯಂಚಿವ ಹಾತ್ ಥೆವ್ಲಾ ತವಾ ಪವಿತ್ರಾತ್ಮ ತ್ಯಂಚಿವ ಆಲ; ತೀ ದುಸ್‍ರ‍್ಯಾ ದುಸ್‍ರ‍್ಯಾ ಬೊಲ್ಯಾ ಬೊಲಾಯಾ ಲಾಗ್ಲಿತ, ಆನಿ ದೆವಾಚಿ ಖಬರ್ ಸಾಂಗ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","ತೇ ತಿಥ ನಾಹಿ ಮನ್ಲತ ಬಾರಾಜಾ಼ನ್ ಗಡಿಹುತ್ತ. ");
INSERT INTO gok_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","ತೇ ಪೆಠತ್ ಪೌಲ್ ಸಭಾಸ್ಥಾನಾತ್ ಜಾ಼ವುನ್, ತಿನ್ ಮೈನ್ಹ ತಿಥಸ್ ದೇವಾಚಾ ರಾಜಾಚೆ ಖನ್ಕತಿಚೆ ಗುಸ್ಟಿಚಿ ಚರ್ಚಾ ಕರಿತ್ ದಿರ‍್ಹಾನಿ ಬುಲುನ್ ಲೊಕಾಂಚ಼ ಮನ್ ವಳ್ವಿತಾ. ");
INSERT INTO gok_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","ಫನ್ ಥೊಡ್ಯಾಚಾಂನಿ ಆಪ್ಲಿ ಮನ ಘಟ್ ಕೆಲಿತ. ಆನಿ ಇಸ್ವಾಸ್ ಕೆಲಾನಾಹಿ ಆನಿ ಸಗ್‍ಳ್ಯಾ ಲೊಕಾಂಚಾ ಹಿಂಡಾಚೆ ಮೊರ‍್ಹ ಪ್ರಭುಚಾ ಮಾರ್ಗಾಚೆ ಗುಸ್ಟಿತ್ ವಾಯಿಟ್ ಬುಲ್ಲಿತ ಮನ್ಹುನ್ ಪೌಲ್ ತ್ಯನಾ ಸುಡುನ್ ಇಸ್ವಾಸ್ ನಸ್‌ಲ್ಯಾಲ್ಯಾನಾ ಆಪ್ಲಿ ಸಂಗ ಗಿಹುನ್ ಗೆಲಾ ಆನಿ ಖಾಯಿಮ್ ತ್ಯನಾ ತುರನ್ ಮಂಥ್ಯಾಲ್ಯಾ ತರ್ಕಸಾಳತ್ ನಿಹುನ್ ತ್ಯಂಚಿ ಸಂಗ ಚರ್ಚಾ ಕರಿತಾ. ");
INSERT INTO gok_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","ಹ್ಯ ದೊನ್ ವರ್ಸಾಪರೆತ್ ಚಾ಼ಲ್ಲ ಮನ್ಹುನ್ ಆಶಾ ಸೀಮತ್ ಆಸ್‍ಲ್ಯಾಲ್ಯಾ ಸಗ್‍ಳ್ಯಾ ಯೆಹುದ್ಯಾಚಾಂನಿ, ಆನಿ ಯಹುದಿ ನಸ್‍ಲ್ಯಾಲ್ಯಾಂಚಾನಿ, ಪ್ರಭುಚಾ ವಾಕ್ಯಾ ಐಕ್‍ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","ದೇವ್ ಪೌಲಾಚಾ ಹಾತಾನಿ ಖುಬ್ ಮುಟ್ಟಿ ಕಾಮ ಕರಿತಾ, ");
INSERT INTO gok_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","ಮನ್ಹುನ್ ಪೌಲಾಚಾ ಹಾತಾತ್ಲಾ ಟವಲ್ ಆನಿ ಕಪ್ಡ ಆನ್ಹುನ್ ಲೊಕ್ ಸೀಕ್ ಪಡ್‌ಲ್ಯಾಲ್ಯಾಂಚಿವ ಗ್ಯಾಲ್ಥಾನಾ ತೀ ಬರಿ ವ್ಹಯಿತಿತ ಆನಿ ಲಾಗಿರ ತ್ಯನಾ ಸುಡುನ್ ಜಾ಼ಯಿತಿತ. ");
INSERT INTO gok_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","ಲಾಗಿರ ಸುಡಿವ್ನಾರ ಮನ್ಹುನ್ ಗಿಹಿತ್, ಫಿರ್‌ತ್ಯಾಲ ಥೊಡಜಾ಼ನ್ ಯಹುದಿ ಲಾಗಿರಾನಾ; “ಪೌಲ್ ಸಾಂಗ್‍ತ್ಯಾಲ್ಯಾ ಯೇಸುಚಿ ಆಜ್ಞೆ ದೆತೊ” ಮನ್ಹಿತ್ ಪ್ರಭು ಯೇಸು ಕ್ರಿಸ್ತಾಚ಼ ನಾವ್ ಗಿಯಾಲಾಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","ಯೊಕ್ ಯಹುದಿ ಮೊಟಾಯಾಜಕ್ ಸ್ಕೇವ ಮಂತ್ಯಾಲ್ಯಾಚ಼ ಸಾತ್ ಜಾ಼ನ್ ಲ್ಯಾಕ್ ತಸಸ್ ಕರಿತ. ");
INSERT INTO gok_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","ಫನ್ ಲಾಗಿರ್ ತ್ಯನಾ; “ಯೇಸುಚಿ಼ ವಳಕ್ ಮನಾ ಹಾ, ಪೌಲಾಚಿ ವಳಕ್ ಹಾ, ಫನ್ ತುಮಿ ಕೊನ್? ಮನ್ಹುನ್ ಇಚಾರ್ತ; ");
INSERT INTO gok_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","ಆನಿ ಲಾಗಿರ ಲಾಗ್‍ಲ್ಯಾಲ್ಯಾ ತ್ಯಾ ಮಾನ್ಸಾನಿ ತ್ಯಂಚಿವ ಉಡಿಮಾರುನ್, ಹಾರ್ವುನ್ ದುಕ್ ಕರುನ್ ತ್ಯಂಚ಼ ಕಪ್ಡ ಫ್ಯಾಟ್ಲ ತವಾ ತೆ ತ್ಯಾ ಗರ‍್ಹಾತ್ನಿ ಪಳುನ್ ಗೆಲ. ");
INSERT INTO gok_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","ಹೀ ಗ್ಯೊಸ್ಟ ಎಫೆಸಾತ್ ಆಸ್‍ಲ್ಯಾಲ್ಯಾ ಸಗ್‍ಳ್ಯಾ ಯೆಹುದ್ಯಾನಾ, ಯಹುದಿ ನಸಲ್ಯಾಲ್ಯಾನಾ ಸಮಾಜ್ಲಿ ತವಾ ತೀ ಸಗ್ಳಿ ಬಿಹ್ಯಾಲಿತ. ಆನಿ ಪ್ರಭು ಯೆಸುಚಾ ನಾವಾಲಾ ಖುಬ್ ಮರ‍್ಯಾದ್ ದಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","ತ್ಯಂಚಿವ ಇಸ್ವಾಸ್ ಥೆವ್‍ಲ್ಯಾಲಿ ಖುಬ್ಜ಼ನ ಯವುನ್ ಆಪ್ನು ಕೆಲ್ಯಾಲಿ ಚು಼ಕಿಚಿ ಕಾಮ ಸಗ್‍ಳ್ಯಾಂಚೆ ಮೊರ‍್ಹ ಸಾಂಗಾಯಾ ಲಾಗ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","ಯವ್ಡಸ್ ನವ್ಹ ಘಾಡ್ಫನ್ ಕರ್ತ್ಯಾಲ್ಯಾತ್ ಖುಬ್ಜ಼ನಾಂಚಾನಿ ಆಪ್ಲಿ ಘಾಡ್ಫನಾಚಿ಼ ಪುಸ್ತಕ ಆನುನ್, ಗೊಳಾ ಕರುನ್ ಸಗ್‍ಳ್ಯಾಂಚೆ ಮೊರ‍್ಹ ಜಾಳ್ಳಿತ. ತ್ಯಂಚಿ ಕಿಮ್ಮತ್ ಲೆಖಾ ಕಿಲಿತಿ ಪನಾಸ್ ಹಾಜಾ಼ರ್ ಚಾ಼ಂದಿಚಾ ಆನ್ಯಾ ಇತ್ಕಿ ಜಾ಼ಲ್ತಿ. ");
INSERT INTO gok_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","ಹ್ಯೆ ತರನಿ ಪ್ರಭುಚಿ಼ ವಾಕ್ಯಾ ಪಗಾಳಿ ಆನಿ ಖುಬ್ ಬಳ್ಕಾಟ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","ಹ್ಯಾ ಖನ್ಕತಿ ಸಗಳ್ಯಾ ಜಾ಼ಲ್ಯಾ ನಂತರ್ ಪೌಲ್ ಆಪ್ನು ಮಕೆದೊನ್ಯಾತ್ನಿ, ಅಖಾಯಾತ್ನಿ ಪಿರತ್ ಯೆರುಸಲೇಮಿತ್ ಜಾ಼ಯಾವ್ಹಯಿ ಮನ್ಹುನ್ ಮನಾತ್ ಯವಜು಼ನ್; “ತಿಥಗೆಲ್ಯಾ ನಂತರ್ ರೊಮಾಪುರ್ಸಾಹಿತ ಬಗಾಯಾವ್ಹಯಿ” ಮನ್ಹುನ್ ಸಾಂಗ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","ಫನ್ ತ್ಯೊ ಆಪಲ ಸೇವಕ್ ಜಾ಼ಲ್ಯಾಲ್ಯಾ ತಿಮೊಥೆಲಾ ಆನಿ ಎರಸ್ತನಾಲಾ ಮಕೆದೊನ್ಯಾತ್ ಲಾವುನ್ ದಿವುನ್ ಆಪ್ನು ಆಶಾಸೀಮತ್ ಥೊಡದಿಸ್ ರಾಯ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","ತ್ಯಾ ಕಾಲಾತ್ ಎಪೆಸಾತ್ ಪ್ರಭುಚೆ ವಾಟಚೆ ಗುಸ್ಟಿತ್ ಖುಬ್ ದಂಗಾ ಉಟ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","ಕಸಾ ಮಂಜೆ, ದೇಮೇತ್ರಿ ಮಂತ್ಯಾಲಾ ಯೊಕ್ ಸೊನಾರ್ ಚಾ಼ಂದಿನಿ ಅರ್ತೆಮೀ ದಿವಿಚಾ ದೇವ್ಳಾಚೆ಼ಗತ್ ಬಾರಿಕ್ ಬಾರಿಕ್ ದೇವ್ಳ ಕರಿತಾ ಆನಿ ತ್ಯಚಾ ಕಾಮ್ಯಾರ‍್ಯಾನಾ ಖುಬ್ ಪ್ಯಾಯ್ದಾ ವ್ಹಯಿತಾ. ");
INSERT INTO gok_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","ತ್ಯೊ ತ್ಯನಾ ಆನಿ ತ್ಯಾ ಕಾಮಾಲಾ ಸಮನ್ ಆಸಲ್ಯಾಲ್ಯಾ ಕಾಮ್ಯಾರ‍್ಯಾನಾ ಯಕಿಕ್ಡ ಹಾಕ್ಟುನ್; “ಲೊಕಾನು, ಹ್ಯಾ ಕಾಮಾನಿ ಆಮಿ ಸಾವ್ಕಾರ್ ವ್ಹತ್ಯಾವ್ ತ್ಯ ತುಮಾನಾ ಠಾವಹಾ. ");
INSERT INTO gok_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","ಫನ್ ಹಾತಾನಿ ಕೆಲ್ಯಾಲಿ ಹಿ ಪಾಶಾನ ದ್ಯಾವ್ ನವ್ಹತ ಮನ್ಹುನ್ ತ್ಯಾ ಪೌಲಾನಿ ಸಾಂಗುನ್ ಎಫೆಸಾತ್ ತ್ಯವ್ಡಸ್ ನವ್ಹ ಜ಼ವಳ್ ಜ಼ವಳ್ ಆಶಾ ಸೀಮತ್ ಸಗ್ಳಿಕ್ಡ ಖುಬ್ ಲೊಕಾನಾ ಗೊಂದ್ಳಾತ್ ಗಾಲುನ್ ಪರತ್‍ಲ್ಯಾತ ತ್ಯ ತುಮಿ ಬಗ್‍ತ್ಯಾಸಾ, ಐಕ್‍ತ್ಯಾಸಾ. ");
INSERT INTO gok_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","ಹ್ಯನಿ ಆಮ್ಚಾ ದಂದ್ಯಾಲಾ ದೊಕಾ ಹಾ ಆನಿ ಅರ್ತೆಮೀ ಮೊಟೆ ದೀವಿಚ಼ ದಿವುಳ್ ಲೆಖ್ಯಾತ್ ಯವುನಾಹಿ ಆಸ, ಸಗ್ಳೆ ಆಶಾ ಸೀಮತ್, ಸಗ್ಳಿ ದುನ್ಯಾ ಪುಜ಼ತ್ಯಾಲೆ ಹ್ಯೆ ದೆವಿಚಾ ಮಹತ್ವಾಲಾ ದೊಕಾ ವ್ಹನಾರ್” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","ತ್ಯಂಚಾನಿ ಹ್ಯಾ ಬೊಲ್ಯಾ ಐಕುನ್ ರಾಗ್ ಕರುನ್; “ಎಫೆಸಾಚೆ ಅರ್ತೆಮೀ ದೇವಿ ಮೊಟಿದೇವಿ” ಮನ್ಹುನ್ ಅರ್ಬಾಟ್ ಕರ್ತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","ತವಾ ಗಾವಾತ್ ಗೊಂದೊಳ್ ಬರ‍್ಲಾ ಪ್ರಯಾನಾತ್ ಪೌಲಾಲಾ ಸಂಗಚ಼ ಮಕೆದೊನ್ಯಾಚಾ ಗಾಯೊಸಾಲಾ ಅರಿಸ್ತಾರ್ಕನಾಲಾ ಲೊಕಾಂಚಾನಿ ದರುನ್ ಸಬಾಭವನಾತ್ ಬರ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","ಪೌಲ್ ಲೊಕಾತ್ನಿ ಬರಾಯಾವ್ಹಯಿ ಮಂತಾನಾ ಇಸ್ವಾಸಿಂಚಾನಿ ತ್ಯಲಾ ಶೊಡ್ಲಾನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","ಯವ್ಡಸ್ ನವ್ಹ ಆಶಾಸೀಮಚ಼ ಅಧಿಕಾರ‍್ಯಾತ್ಲ ಥೊಡಜಾ಼ನ್ ಪೌಲಾಚ಼ ಸುಪ್ತಿ ಜಾ಼ಲ್ತ ಮನ್ಹುನ್ ತ್ಯಂಚಿಪ ಲೊಕಾನಾ ಲಾವುನ್ ದಿವುನ್; ತು ಸಬಾಭವನಾತ್ ಜಾ಼ವುನಕೊ ಮನ್ಹುನ್ ಮಂಥ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","ಜ಼ಮ್‍ಲ್ಯಾಲ್ಯಾ ಲೊಕಾತ್ ಗೊಂದೊಳ್ ಉಟ್ಲಾ ಹುತಾ, ಥುಡಿ ಯೆಕ್ ತರನಿ ವರಾಡ್ಲಿತ ಆನಿ ಥುಡಿ ಆನಿ ಯೆಕ್ ತರನಿ ವರಾಡ್ಲಿತ. ಖುಬ್ ಲೊಕಾನಾ ಆಪ್ನು ತಿಥ ಕಶಾಲಾ ಜ಼ಮ್‍ಲ್ಯಾವ್ ಮನ್ಹುನ್ ಠಾವ ನವ್ಥ. ");
INSERT INTO gok_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","ಯೆಹುದ್ಯಿ ಅಲೆಕ್ಸಾಂದ್ರಲಾ ಮೊರ‍್ಹ ಜಾ಼ಯಾ, ಹಿಂಡಾತ್‍ಲ್ಯಾ ಥೊಡ್ಯಾಂಚಾನಿ ತ್ಯಲಾ ಸುಸ್ನಾ ದಿಲಿ. ತವಾ ಅಲೆಕ್ಸಾಂದರ್ ಹಾತಾಚೆ ಖುನನಿ ಗಪ್ಕರುನ್ ಜ಼ಮ್‍ಲ್ಯಾಲ್ಯಾನಾ ಆಪ್ಲೆ ಸಾಟಿ ಲೊಕಾನಾ ಸಾಂಗಾಯಾ ಲಾಗ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","ಫನ್ ತ್ಯೊ ಯೆಹುದ್ಯಿ ಮನ್ಹುನ್ ಸಮಾಜ಼್ಲ ತವಾ ಸಗ್ಳಿ ಎಕುಸ್ ತರನಿ; “ಎಫೆಸಾತ್ಲಿ ಅರ್ತೆಮೀ ದೀವಿ ಮೊಟಿ ದೀವಿ” ಮನ್ಹುನ್ ದೊನ್ ತಾಸ್ ವರಾಡ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","ಮಂಗ್ ಪೆಠಚಾ ಮೆಟ್ಯಾನಿ ಲೊಕಾಚಾ ಹಿಂಡಾಲಾ ಗಪ್ ಕರುನ್; “ಎಫೆಸಾತಲ್ಯಾನು, ಎಫೆಸ ಪೆಠತ್ಲೆ ಅರ್ತೆಮೀ ಮೊಟೆ ದೀವಿಚಾ ದೇವ್ಳಾಲಾ, ಆಬ್ಳಾತ್ನಿ ಪಡ್‍ಲ್ಯಾಲ್ಯಾ ತಿಚಾ ಪಾಶಾನಾಲಾ, ರ‍್ಯಾಕ್ನಾರಿ ಎಪೆಸಾ ಪ್ಯಾಠುಸ್ ಮನ್ಹುನ್ ಸಮಾಜ಼್ಲ ನಸ್‍ಲ್ಯಾಲಾ ಮಾನುಸ್ ಕೊನ್ ಹಾ? ");
INSERT INTO gok_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","ಹ್ಯಾ ಗುಸ್ಟಿ ನವ್ಹ ಮನಾಯಾ ಕುನಾಲಾಸ್ ವ್ಹಯಿತ್ನಾಹಿ ಮನ್ಹುನ್ ತುಮಿ ಥಂಡ್ಪನಾನಿ ರಾಯಾವ್ಹಯಿಸಾ; ಆನಿ ಗಾಹಿನಿ ಕಾಯ್ ಕರುನಕೊಸಾ. ");
INSERT INTO gok_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","ತುಮಿ ದರುನ್ ಆನ್‍ಲ್ಯಾಲ ಹೆ ಮಾನುಸ್ ದೇವ್ಳ ಚೊರ್ನಾರ ನವ್ಹತ, ಆಮ್ಚೆ ದೀವಿಚಿ ನಿಂದಾ ಕರ್ನಾರಬಿ ನವ್ಹತ. ");
INSERT INTO gok_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","ಆಸ ಆಸ್ತಾನಾ ದೇಮೇತ್ರಿಯಾ ಸಂಗ ಆಸ್‍ಲ್ಯಾಲ್ಯಾನಾ ಕುನಾವತರಿ ತಕ್ರಾರ್ ಆಸ್ಲಾತ ನ್ಯಾಯಿ ನಿವಡ್ನಾರ ಅಧಿಪತಿ ಹಾತ್ತ, ತಿಥ ಯಕಾ ಮಕಾವ ಆರೊಪ್ ಕರುನ್ತ. ");
INSERT INTO gok_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","ಕಾಯ್ತರಿ ಖುಬ್ ಇಚಾರ್ ಕರಾಯಾ ವ್ಹಯಿತ ತ್ಯೊ ನೀಯತಿನಿ ಜ಼ಮಲ್ಯಾಲೆ ಸಬೆತ್ ತಿರ್ಮಾನ್ ವ್ಹಯಾವ್ಹಯಿ. ");
INSERT INTO gok_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","ಹ್ಯಾ ದಿಸಾತ್ ಶಾರ್ಕ ಕಾರನ್ ನಸ್ತಾನಾ ಜ಼ಮ್‍ಲ್ಯಾಲ್ಯಾ ಲೊಕಾಂಚೆ ಗುಸ್ಟಿತ್ ಹ್ಯೊ ಯೊಕ್ ದಂಗಾ ಮನ್ಹುನ್ ಆಮ್ಚಿವ ಚು಼ಕ್ ವಾವಾಯಾ ನೆವಾ ಗಾವ್ನಾರ್. ಹ್ಯಾ ದಂಗ್ಯಾಚಾ಼ ಇಚಾರ್ ಕೆಲ್ಯಾವ ಆಮ್ಚಿಪ್ನಿ ಉತ್ತರ್ ದಿಯಾ ವ್ಹಯಿತುಸ್ ನಾಹಿ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","ಹ್ಯಾ ಬೊಲ್ಯಾ ಸಾಂಗುನ್ ಜ಼ಮ್‍ಲ್ಯಾಲ್ಯಾ ಲೊಕಾನಾ ಲಾವುನ್ ದಿಲಿತ. ");
INSERT INTO gok_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","ಗೊಂದೊಳ್ ಥಾಮ್‌ಲ್ಯಾ ನಂತರ್ ಪೌಲಾನಿ ಇಸ್ವಾಸಿನಾ ಯಕಿಕ್ಡ ಗಿಹುನ್ ದೀರ್ ದಿವುನ್ ಜಾ಼ವುನ್ ಯತೊ ಮನ್ಹುನ್ ಸಾಂಗುನ್ ಮಕೆದೊನ್ಯಾತ್ ನಿಗಾಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","ತ್ಯೆ ಸೀಮತ್ ಪಿರತ್ ತಿತಲ್ಯಾನಾ ಖುಬ್ ಸಂದೇಶಾನಿ ಧಿರ್ ದಿವುನ್ ಗ್ರಿಸ್ ದೆಶಾತ್ ಆಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","ತಿಥ ತೀನ್ ಮೈನ್ಹ ಸರ್ಲ್ಯಾ ನಂತರ್ ಸಿರಿಯಾ ದುನ್ಯಾತ್ ಸಮಿಂದೊರಚೆ ವಾಟನಿ ಜಾಯಾವ್ಹಯಿ ಮಂಥಾನಾ ತ್ಯಂಚೆ ಆಡ್ವಯೆಹುದ್ಯಾಂಚಾನಿ ಪಿತುರಿ ಕೆಲ್ಯಾಲಿ ತ್ಯಲಾ ಸಮಾಜ್ಲಿ ಮನ್ಹುನ್ ತ್ಯನಿ ಮಕೆದೊನ್ಯಾಚೆ ವಾಟನಿ ಮಾಗಾರಾ ಪರ್ತುನ್ ಜಾಯಾ ಇಚಾರ್ ಕೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","ಬೆರೊಯಾ ಪೆಟ್ಟಚಾ ಪುರ್ರಾಚಾ಼ ಲ್ಯೊಕ್ ಸೊಪತ್ರಾ, ತೆಸಲೊಕಾತ್ಲಾ ಅರಿಸ್ತಾರ್ಕ್, ಸೆಕುಂದಾ ದೆರ್ಬೆಪೆಟ್ಟತ್ಲಾ ಗಾಯೊಸಾ, ತಿಮೊಥೆ, ಆಸ್ಯಾಸೀಮತ್ಲ ತುಖಿಕ್, ತ್ರೊಫಿಮಾ, ಹೆ ಸಗ್ಳ ತ್ಯಚಿ ಸಂಗ ಹುತ್ತ. ");
INSERT INTO gok_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","ತ್ಯೆ ಆಂದಿಸ್ ಜಾ಼ವುನ್ ಆಮ್ಚಿಸಾಟಿ ತ್ರೊವಾತ್ ರಾಖಿತ ");
INSERT INTO gok_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","ಫುಗತ್ ನಸ್‍ಲ್ಯಾಲ್ಯಾ ಬಾಖ್ರಿಚಾ ಸನಾಚ಼ ದಿಸ್ ಕೆಲ್ಯಾ ನಂತರ್ ಆಮಿ ಫಿಲಿಪಿತ್ನಿ ನಿಗುನ್ ವ್ಹಡಿತ್ ಚ಼ಡುನ್ ಸಮಿಂದೊರಾವ್ನಿ ಪಾಚ್ವೆದಿಸಿ ಯವುನ್ ತ್ಯನಾ ಮಿಳಾಲಾವ್. ತಿಥ ಸಾತ್ರೊಜ಼್ ರಾಯ್‍ಲ್ಯಾವ್. ");
INSERT INTO gok_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","ಸಭತ್ ದಿಸಾದಿಸಿ ಆಮಿ ಬಾಖ್ರಿ ಮೊಡಾಚಾ ನೆಮಾಲಾ ಮಿಳುನ್ ಆಲಾವ್ ತವಾ ಪೌಲ್ ತಿಥ ಜ಼ಮ್‍ಲ್ಯಾಲ್ಯಾ ಇಶ್ವಾಸಿನಾ ಸಿಕಿವ್ತೊ. ದುಸ್ರೆದಿಸಿ ಜಾ಼ಯಾವ್ಹಯಿ ಮಂಥ್ಯಾಲಾ ತ್ಯೊ ತ್ಯನಾ ಸಿಕ್ವಿತ್ ಆರ್ದೆ ರಾತಿ ಪರೆತ್ ರಾಯ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","ಆಮಿ ಜ಼ಮಲ್ಯಾಲೆ ಮಾಳಿವ ಖುಬ್ ದಿವ ಪೆಟತ. ");
INSERT INTO gok_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","ಯುತಿಖ್ ಮಂತ್ಯಾಲಾ ಯೊಕ್ ಪ್ಯೊರ್ಗಾ ಕಿಡಕಿವ ಬಸುನ್ ಜಿಂಘತಾ. ಪೌಲಾ ಸಿಕ್ವಿತ್ ಆಸ್ತಾನಾ ತ್ಯೊ ಪ್ಯೊರ್ಗಾ ಜಿಂಗುನ್ ತೀನವೆ ಮಾಡಿವ್ನಿ ಬುಡಿ ಪಡ್ಲಾ; ತ್ಯಲಾ ಉಠ್ವಾಯಾ ಗೆಲ ತವಾ ತ್ಯೊ ಮೆಲ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","ಫನ್ ಪೌಲ್ ಉತ್ರುನ್ ಜಾ಼ವುನ್ ತ್ಯಚಿವ ಪಡುನ್ ಯಾಂಗ್ ಗಾಲ್ಹುನ್; “ಚಿಂತಾ ಕರುನಕೊಸಾ, ತ್ಯೊ ಜೀತಾಹಾ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","ತವಾ ತ್ಯೊ ವರ್ ಜಾ಼ವುನ್ ಬಾಖ್ರಿ ಮುಡುನ್ ಜೆವಾನ್ ಖಾವುನ್ ಖುಬ್ ಯೊಳ್ ಪಾಂಡ್ರವ್ಹಯಿ ಪರೆತ್ ಬುಲುನ್ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","ತ್ಯಂಚಾನಿ ಜೀತಾ ಜಾ಼ಲ್ಯಾಲ್ಯಾ ಪ್ಯೊರ್ಗ್ಯಾಲಾ ಹಾಕ್ಟುನ್ ಗರ‍್ಹಾತ್ ನೆಲ್ಹಾ ತವಾ ತ್ಯನಾ ಖುಬ್ ಆನಂದ್ ಜಾ಼ಲ್ಹಾ. ");
INSERT INTO gok_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","ಆಮಿ ಆಂದಿಸ್ ತಿಥ ಜಾ಼ವುನ್ ಅಸ್ಸೊಸಿತ್ ಪೌಲಾಲಾ ಆಮ್ಚಿ ಸಂಗ ವ್ಹಡಿತ್ ಚ಼ಡ್ವುನ್ ನಿಹ್ಯಾವ್ಹಯಿ ಮನ್ಹುನ್ ಸಮಿಂದೊರಾವ್ನಿ ಗೆಲಾವ್. ಚಾ಼ಲತ್ ಜಾ಼ಯಾವ್ಹಯಿ ಮನ್ಹುನ್ ಆಮಾನಾ ಆಸ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","ಅಸ್ಸೊಸಿತ್ ತ್ಯೊ ಆಮಾನಾ ಮಿಳಾಲಾ ತವಾ ಆಮಿ ತ್ಯಲಾ ವ್ಹಡಿತ್ ಗಿಹುನ್ ಮಿತಿಲೇನ್ ಪೆಠತ್ ನಿಗಾಲಾವ್. ");
INSERT INTO gok_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","ತಿತ್ನಿ ನಿಗುನ್ ದಿಸ್ರೆದಿಸಿ ಖೀಯೊಸ್ ದ್ವೀಪಾಚೆ ಮೊರ‍್ಹ ಆಲಾವ್ ದಿಸ್ರೆದಿಸಿ ಸಾಮೊಸಾತ್, ಯವುನ್ ತ್ಯಚೆ ದಿಸ್ರೆದಿಸಿ ಮಿಲೇತಾತ್ ಪೊಚ್ಲಾ಼ವ್. ");
INSERT INTO gok_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","ಪೌಲ್ ಆಪ್‍ಲ್ಯಾಲಾ ಜಾ಼ಲತ ಪಂಚಾಶತ್ತಮಾ ದಿಸಾಚಾ ಸನಾಲಾ ಯೆರುಸಲೇಮಿತ್ ರಾಹ್ಯಾವ್ಹಯಿ ಮನ್ಹುನ್ ಗಾಹಿಕರಿತಾ ಮನ್ಹುನ್ ಆಶಾ ಸೀಮತ್ ದಿಸ್ ಗಾಲ್ವಾಯಾ ಮನ್ ನಸ್ತಾನಾ ಎಫೆಸ್ ಪ್ಯಾಟ್ ವಲ್ಯಾಂಡುನ್ ಜಾ಼ಯಾವಯಿ ಮನ್ಹುನ್ ನಿರ್ದಾರ್ ಕೆಲ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","ಪೌಲಾನಿ ಮಿಲೇತಾತ್ನಿ ಎಫೆಸಾತಲ್ಯಾ ಜಾಂತ್ಯಾನಾ ಆಪಲ್ಯಾಲಾ ಭೆಟ್ ವ್ಹಯಾ ಸಾಂಗುನ್ ಲಾವುನ್ ದಿಲ. ");
INSERT INTO gok_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","ತ್ಯೆ ತ್ಯಚಿಪ ಆಲ ತವಾ ತ್ಯನಾ ತ್ಯನಿ ಸಾಂಗ್ಲ್ಯಾಲ ಕ್ಯಾ ಮಂಜೆ; “ಮೀ ಆಶಾಸೀಮತ್ ಪ್ಯಾ ಥೆವಲ್ಯಾದರ್ನಿ ತುಮ್ಚೆ ಮದ್ದಿ ಸಗ್ಳ ದಿಸ್ ಕಸಾ ಚಾ಼ಲ್ಲೊ ಮನ್ಹುನ್ ತುಮಾನಾಸ್ ಠಾವಾ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","ಯೆಹುದ್ಯಾಂಚೆ ಪೀತುರಿನಿ ಜಾ಼ಲ್ಯಾಲ್ಯಾ. ತರಾಸಾತ್, ಮೀ ಖುಬ್ ಥಂಡ್ ಪನಾನಿ, ರಡುನ್ ಪ್ರಬುಚಿ ಸೇವಾ ಕರ್ತ್ಯೊ. ");
INSERT INTO gok_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","ಮೀ ತುಮಾನಾ ಸಗಳ್ಯಾಂಚೆ ಮೊರ‍್ಹ ಆನಿ ತುಮಚಾ ಗರ‍್ಹಾ ಗರ‍್ಹಾತ್ನಿ ಯವುನ್ ತುಮನಾ ಮಜ಼ತ್ ಕರಾಯಾ ವ್ಹಯಿಜಾ಼ಲ್ಯಾಲ ತುಮಾನಾ ಶಿಕ್ವಾಯಾ ಮಾಗಸರ್ಲೊನಾಹಿ ಹ್ಯ ತುಮಾನಾ ಠಾ ಹಾ ");
INSERT INTO gok_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","ಯೆಹುದ್ಯಾನಾ, ಗ್ರೀಕಾನಾ ತ್ಯಂಚಾನಿ ಪಾಪಾಲಾ ಸುಡುನ್ ದೇವಾಕ್ಡ ಪರ್ತಾಯಾವ್ಹಯಿ ಮನ್ಹುನ್, ಆಮ್ಚಾ ಪ್ರಬು ಯೇಸುವ ಇಸ್ವಾಸ್ ತೆವಾಯಾವ್ಹಯಿ ಮನ್ಹುನ್ ಮಿ ಸಾಂಗಲ್ಯಾ, ");
INSERT INTO gok_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","ಆತಾ ಮೀ ಪವಿತ್ರಾತಮ್ಯಾಚಾ ಸಾಂಗನ್ಯಾನಿ ಯೆರುಸಲೇಮಿತ್ ಜಾ಼ತೊ. ತಿಥ ಕ್ಯಾ ಗಢ್ನಾರ್ ಮನಾ ಠಾವನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","ತುರುಂಗ್, ಆನಿ ಸಂಕಟ್ ತುಜಿ ವಾಟ್ ಬಗತ್ಯಾತ ಮನ್ಹುನ್ ಪವಿತ್ರಾತ್ಮ ಪರ್ತೆಕ್ ಪೆಟ್ಟತ್ ಮನಾ ಹುಶಾರ್ಕಿ ದೆತ್ಯೊ ಮನ್ಹುನ್ ಠಾವ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","ಮಿ ಮಾಜಾ ಜೀವ್ನಾಚಿ ಚಿಂತಾ ಕರಿತ್ನಾನಿ ಪ್ರಭು ಯೆಸು ಕ್ರಿಸ್ತಾನಿ ಮನಾ ದಿಲ್ಯಾಲ್ಯಾ ಕಾಮಾಚ಼ ಪಳ್ನ ಪಳುನ್ ಸಪ್ವಾಚ಼ ಮಾಜಾ಼ ಯೊಕುಸ್ ಮುಜ಼್ರಾ ಜಾ಼ಲ್ಯಾ ತ್ಯೊ ದೆವಾಚೆ ಕ್ರುಪೆಚೆ ಬರೆ ಖಬ್ರಿಲಾ ವಳ್ಕಿಚ಼ ಕಾಮ್ ಜಾ಼ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","ಬಗಾ, ಯವ್ಡ ದಿಸ್ ತುಮ್ಚಿಪ ಫಿರತ್ ದೇವಾಚಾ ರಾಜಾಚ಼ ಸಾಂಗ್‍ಲ್ಯಾ ಮಾಜ಼ ತ್ವಾಂಡ್ ಆನಿ ಯಂಗ್ದಾ ತುಮ್ಚಾತ್ಲಾ ಯೊಕ್ಬಿ ಬಗ್ನಾರ್ನಾಹಿ ಮನ್ಹುನ್ ಮನಾ ಠಾವಹಾ. ");
INSERT INTO gok_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","ಮನ್ಹುನ್ ಮೀ ಆಜ಼್ ಖರ‍್ಯಾನಿ ಸಾಂಗ್ತೊ, ತುಮ್ಚಾತ್ ಕೊನ್ತರಿ ಹಾಳ್ ಜಾ಼ಲತ ತ್ಯ ಮಾಜೆ ಚು಼ಕಿನಿ ನವ್ಹ. ");
INSERT INTO gok_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","ಕಾ ಮಂಜೆ ಯಾಕ್ಬಿ ಚು಼ರುನ್ ಥೆವಾಚೆ ಆಂದಿ ದೇವಾಚಿ ಪಾರಕ್ ತುಮಾನಾ ಸಾಂಗಾಯಾ ಮಾಗ ಸರ್ಲೊನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","ಸ್ವತಾ ತುಮಾನಾ ಆನಿ ದೇವಾಚೆ ಸಬೆಲಾ ಬಾಳ್ಗಾಯಾ ದೇವಾನಿ ತುಮಾನಾ ಸಾಂಗ್‌ಲ್ಯಾ ತ್ಯಚಿ ಕ್ಯಾಳ್ಜಿ ಕರಾ ತ್ಯ ಕಾಮ್ ಪವಿತ್ರಾತ್ಮಾನಿ ತುಮನಾ ದಿಲ್ಯಾ ತುಮಿ ಸಬೆಲಾ ಗುರಿಕ್ಯಾ ಶಾರ್ಕ ರಾಹ್ಯಾ ವ್ಹಯಿಸಾ ಹಿ ಸಬಾ ದೇವಾನಿ ಆಪ್‍ಲ್ಯಾ ಲೇಕಾಚ಼ ರಗಾತ್ ದಿವುನ್ ಇಕತ್ ಗೆತ್ಲೆ. ");
INSERT INTO gok_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","ಮೀ ಸುಡುನ್ ಗೆಲ್ಯಾ ನಂತರ್ ಕುಳಿಸ್ನ ತುಮ್ಚಿಪ ಯನಾರ್ ಮನ್ಹುನ್ ಮನಾ ಠಾವ ಹಾ; ತೆ ಹಿಂಡಾಲಾ ಶೊಡ್ನಾರ್ನಾಹಿತ. ");
INSERT INTO gok_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","ಯವ್ಡಸ್ ನವ್ಹ ತುಮ್ಚಾತ್ ಥೊಡಜಾ಼ನ್ ಉಠುನ್ ನಕೊತಸ್ಲ ಸಿಕ್ವುನ್ ಇಸ್ವಾಸಿನಾ ಆಪ್ಲಿಕ್ಡ ವಳವುನ್ ಗೆನಾರ್. ");
INSERT INTO gok_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","ಮನ್ಹುನ್ ಮೀ ರಡತ್ ತೀನ್ ವರ್ಸ ರ‍್ಯಾತ್ ದಿಸ್ ಚು಼ಕ್ವಾಚೆ ಆಂದಿ ಪರ್ತೆಕಾಲಾ ಸಿಕಿವ್‍ಲ್ಯಾ ಮನ್ಹುನ್ ತುಮಿ ಯಾದ್ ಕರುನ್ ಹುಶಾರ್ ರಾವ್ಹಾ. ");
INSERT INTO gok_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","ಮೀ ಆತಾ ತುಮಾನಾ ದೇವಾಚಾ, ಆನಿ ತ್ಯಚಾ ಕ್ರಪೆಚಾ ಸಂದೆಸಾಚಾ ತಾಬ್ಯಾತ್ ದೆತೊ. ತ್ಯಚಿಪ ತುಮಾನಾ ಬಾಂದಾಚ಼ ಬಳ್ ಹಾ, ಆನಿ ತುಮಾನಾ ದೆವ್ ಆಪ್‍ಲ್ಯಾ ಸಗ್‍ಳ್ಯಾ ಲೊಕಾನಾ ದೆತ್ಯಾಲಾ ಆಶಿರ್ವಾದ್ ದೆನಾರ್. ");
INSERT INTO gok_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","ಮೀ ಕುನಾಚಾ ಸೊನ ಚಾಂದಿಲಾ ವ್ಹವುನಿ, ಆಯಾರಾಲಾ ವ್ಹವುನಿ ಮನ್ ಕೆಲನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","ಮಿ ಮಾಜಾ ಹ್ಯಾ ಹಾತಾನಿಸ್ ಕಾಮ್ ಕರುನ್, ಮಾಜಿ ಗರಜ಼್ ಆನಿ ಮಾಜೆ ಸಂಗ ಆಸಲ್ಯಾಲ್ಯಾಂಚಿ ಗರಜ಼್ ಕ್ಯಾಡಲ್ಯಾಲಿ ತುಮಾನಾಸ್ ಠಾವಿ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","ಸಗ್‍ಳ್ಯಾ ಗುಸ್ಟಿತ್ನಿ ಮೀ ತುಮಾನಾ ಮಾದರಿ ದ್ಯಾವಲೆ. ತುಮಿಬಿ ತಸಿಸ್ ರಾಬುನ್ ಬಳ್ ನಸ್‍ಲ್ಯಾಲ್ಯಾನಾ ಮಜ಼ತ್ ಕರಾಯಾವ್ಹಯಿಸಾ; ಆನಿ; ‘ಗಿಹ್ಯಾಚಾವ್ನಿ ದಿಯಾಚಾತುಸ್ ಖುಬ್ ಆಶೀರ್ವಾದ್ ಹಾ ಮನ್ಹುನ್’ ಪ್ರಭು ಯೇಸುನಿ ಸಾಂಗ್‍ಲ್ಯಾಲಾ ಸಬ್ದ ಯದತ್ ಥೆವಾ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","ಹ್ಯಾ ಬೊಲ್ಯಾ ತ್ಯನಿ ಸಾಂಗ್‍ಲ್ಯಾ ನಂತರ್ ನಡ್ಗ ಮುಡುನ್ ತ್ಯಂಚೆ ಸಗ್‍ಳ್ಯಾಂಚೆ ಸಂಗ ಮಾಗ್ನ ಕರ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","ನಂತರ್ ತೀ ಸಗ್ಳಿ ದುಃಖಾನಿ ರಡತ್, ತ್ಯಲಾ ಯಾಂಗ್ ಗಾಲ್ಹುನ್ ಮುಖ ದಿಲ ಜಾ಼ವುನ್ ಎ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","ತ್ಯನಿ ನಂತರ್ ಆನಿ ಮನಾ ಬಗ್ನಾರ್ನಾಹಿಸಾ ಮನ್ಹುನ್ ಸಾಂಗ್‍ಲ್ಯಾಲ್ಯಾಲಾ ತ್ಯನಾ ಖುಬ್ ದುಃಖ್ ಜಾ಼ಲ್ಹ ಆನಿ ತ್ಯಚಿ ಸಂಗ ವ್ಹಡಿಪರೆತ್ ಗಿಲಿತ ಆನಿ ತ್ಯಲಾ ಲಾವುನ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","ಆಮಿ ತ್ಯನಾ ಸುಡುನ್ ವ್ಹಡಿತ್ ಚ಼ಡುನ್ ನೀಟ್ ಕೊಸ್ ದ್ವೀಪಾತ್ ಯವುನ್. ದುಸ್ರೆದಿಸಿ ರೊದ ದ್ವೀಪಾತ್ ಜಾ಼ವುನ್ ತಿತ್ನಿ ಪತರ್ ಪೆಠತ್ ಗೆಲಾವ್. ");
INSERT INTO gok_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","ತಿಥ ಪೊಯಿನೀಕೆತ್ ಜಾ಼ತ್ಯಾಲಿ ವ್ಹಡಿ ಬಗುನ್, ತ್ಯಾತ್ನಿ ಮೊರ‍್ಹ ಜಾ಼ಯಾಲಾಗ್ಲಾವ್. ");
INSERT INTO gok_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","ಮೊರ‍್ಹ ಕುಪ್ರದ್ವೀಪಾ ಬಗುನ್ ಡಾವ್ಯಾಂಗ್ನಿ ಸುಡುನ್ ಸಿರಿಯಾಕ್ಡ ಜಾ಼ವುನ್ ತುರ್ ಪೆಠತ್ ಯವುನ್ ಉತಾರ್ಲಾವ್. ಕಾ ಮಂಜೆ, ತಿಥ ಸಾಮ್ನ ಉತ್ರಾಚಿ ಹುತ್ತಿತ. ");
INSERT INTO gok_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","ತಿಥ ಇಸ್ವಾಸಿನಾ ಸುದುನ್ ಕಾಡುನ್, ಸಾತ್ರೊಜ಼್ ರಾಯ್ಲಾವ್. ತ್ಯೆ ಪವಿತ್ರ ಆತಮ್ಯಾಚಾ ಸಾಂಗನ್ಯಾನಿ ಪೌಲಾಲಾ; ತು ಯೆರುಸಲೇಮಿತ್ ಜಾ಼ವುನಕೊ ಮನ್ಹುನ್ ಸಾಂಗತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","ತೆದಿಸ್ ಸಪ್ವುನ್ ಆಮಿ ಜಾ಼ತಾನಾ ತ್ಯೆ ಸಗ್ಳ ಆಪಲ್ಯಾ ಬ್ಯಾಯ್ಕಾ ಪೊರಾ ಸಾಹಿತ್ ಯವುನ್ ಆಮಾನಾ ಗಾವಾತ್ನಿ ಬಾಹಿರ್ ಲಾವುನ್ ದೆತ್ಯಾತ. ಆಮಿ ಸಂಮೀದೊರಾಪ ನಡ್ಗಟಿಕ್ವುನ್ ಮಾಗ್ನ ಕರುನ್, ");
INSERT INTO gok_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","ಯಕಾಮಕಾಲಾ ಜಾ಼ವುನ್ ಯತಾವ್ ಮನ್ಹುನ್ ಸಾಂಗುನ್ ವ್ಹಡಿತ್ ಚ಼ಡ್ಲಾವ್; ತ್ಯೆ ಮಾಗಾರ ಪರ್ತುನ್ ಆಪ್‍ಲ್ಯಾ ಆಪ್‍ಲ್ಯಾ ಗರಾತ್ನಿ ಗೆಲ. ");
INSERT INTO gok_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","ಆಮಿ ತುರ್ ಪೆಠತ್ನಿ ನಿಗುನ್ ಪ್ತೊಲೆಮಾಯಾತ್ ಜಾ಼ವುನ್ ಸಮಿಂದೊರಾವ್ನಿ ವ್ಹಡಿತ್ನಿ ಪಾರ್ ಜಾ಼ಲಾವ. ತಿತ್ನಿ ಇಸ್ವಾಸಿನಾ ಬಿಠುನ್ ತ್ಯಂಚಿಪ ಯೆಕ್ದಿಸ್ ರಾಹುನ್, ");
INSERT INTO gok_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","ದುಸ್ರೆದಿಸಿ ನಿಗುನ್ ಕೈಸರಾತ್ ಯವುನ್, ಬರಿ ಖಬರ್ ಸಾಂಗ್‍ತ್ಯಾಲ್ಯಾ ಫಿಲಿಪಾಚಾ ಗರಾತ್ ಜಾ಼ವುನ್ ತ್ಯಂಚಿಪಸ್ ರಾಯ್ಲಾವ್. ಯೆರುಸಲೆಮಿಚೆ ಮಜ಼ತಿಸಾಟಿ ನಿವಡ್‍ಲ್ಯಾಲ್ಯಾ ಸಾತ್‍ ಜ಼ನಾತ್ಲಾ ಹ್ಯೊ ಯೊಕ್ ಜಾ಼ಲ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","ತ್ಯಚಾ ಚಾರ್ ಪುರಿ ಹುತ್ಯಾ ತ್ಯಂಚಿ ಲಗ್ನ ಜಾ಼ಲಿ ನವ್ಥಿತ; ತ್ಯಾ ದೆವಾಚಾ ಗುಸ್ಟಿ ಭವಿಸ್ವಾನಿ ಕರಿತ್ಯಾ ");
INSERT INTO gok_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","ಆಮಿ ತಿಥ ಖುಬ್ ದಿಸ್ ರಾಯಲ್ಯಾ ನಂತರ್, ಅಗಬ ನಾವಾಚಾ಼ ಯೊಕ್ ಪ್ರವಾದಿ ಯುದಾಯಾತ್ನಿ ಆಮ್ಚಿಪ ಆಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","ತ್ಯೊ ಆಮಚಿಪ ಯವುನ್ ಪೌಲಾಚೆ ಕಮ್ರತ್ಲಾ ಪಟ್ಟಾ ಗಿಹುನ್, ಆಪ್ಲ ಹಾತ್ ಪ್ಯಾ ಬಾಂದುನ್; “ಹ್ಯೊ ಪಟ್ಟಾ ಕುನಾಚಾ಼ ತ್ಯಲಾ ‘ಯಹುದಿ ಆಸಸ್ ಯೆರುಸಲೇಮಿತ್ ಬಾಂದುನ್ ಯಹುದಿ ನಸಲ್ಯಾಲ್ಯಾಂಚಾ ಹಾತಾತ್ ದೆನಾರ್, ಮನ್ಹುನ್ ಪವಿತ್ರಾತ್ಮ ಸಾಂಗ್ತ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","ಕವಾ ತ್ಯಾ ಬೊಲ್ಯಾ ಐಕ್‍ಲ್ಯಾ ತವಾ ಆಮಿ, ಆನಿ ತಿತಲ್ಯಾಂಚಾನಿ; ತು ಯೆರುಸಲೇಮಿತ್ ಜಾ಼ವುಸ್ ನಕೊ ಮನ್ಹುನ್ ಪೌಲಾಪ ಇಂತಿ ಕಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","ಫನ್ ಪೌಲ್; “ತುಮಿ ರಡುನ್ ಕಾ ಮಾಜ಼ ಮನ್ ಮ್ಯೊಡ್ತಾಸಾ? ಮೀ ಪ್ರಬು ಯೇಸುಚಾ ನಾವಾಸ್ಲಾಗುನ್ ಯೆರುಸಲೇಮಿತ್ ಬೆಡ್ಯಾ ಗಾಲುನ್ ಗಿಹ್ಯಾ ತ್ಯವ್ಡಸ್ ನವ್ಹ ಮರಾಯಾಬಿ ತಯಾರ್ ಹಾ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","ತ್ಯೊ ಹು ಮನ್ಲಾನಾಹಿ ಮನ್ಹುನ್; “ಪ್ರಭುಚಾ ಮನಾಶಾರ್ಕ ವ್ಹವುನಿ” ಮನ್ಹುನ್ ಸಾಂಗುನ್ ಆಮಿ ಗಪ್‍ ಜಾ಼ಲಾವ್. ");
INSERT INTO gok_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","ತ್ಯೆ ದಿಸ್ ಜಾ಼ಲ್ಯಾ ನಂತರ್ ಆಮಿ ತಯಾರ್ ವ್ಹವುನ್ ಯೆರುಸಲೇಮಿತ್ ನಿಗಾಲಾವ್. ");
INSERT INTO gok_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","ಕೈಸರೈತ್ನಿ ಥೊಡ ಶಿಶಾ ಆಮ್ಚೆ ಸಂಗ ಯವುನ್ ಆಮಿ ಜಾ಼ಯಾ ವ್ಹಯಿತ್ಯಾ ಗರ‍್ಹಾಪರೆತ್ ಆಮಾನಾ ಹಾಕ್ಟುನ್ ಗಿಹುನ್ ಗೆಲ. ತ್ಯಾ ಗರಾತ್ಲಾ ಪೈಲ್ಯಾ ಶಿಶಾತ್ಲಾ ಯೊಕ್ ಕ್ರುಪಾತ್ಲಾ ಮ್ನಾಸೊನ್ ಮಂತ್ಯಾಲಾ ಹುತ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","ಆಮಿ ಯೆರುಸಲೇಮಿತ್ ಆಲಾವ್ ತವಾ ಇಸ್ವಾಸಿಂಚಾನಿ ಆಮಾನಾ ಸಂತೊಶಾನಿ ಸ್ವಾಗತ್ ಕೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","ದುಸ್ರೆದಿಸಿ ಪೌಲ್ ಆಮಾನಾ ಹಾಕ್ಟುನ್ ಗಿವುನ್ ಯಾಕೊಬಾಲಾ ಬೆಠಾಲಾ ಗೆಲಾ. ತವಾ ಸಬೆಚ಼ ಜಾಂತ ಸಗ್ಳ ತಿಥ ಹುತ್ತ. ");
INSERT INTO gok_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","ಪೌಲಾನಿ ತ್ಯನಾ ಸ್ವಾಗತ್ ಕರುನ್ ದೇವಾನಿ ಯಹುದಿ ನಸಲ್ಯಾಲ್ಯಾ ಲೊಕಾತ್ನಿ ಕೆಲ್ಯಾಲ ಕಾಮ್ ಯಾಕ್ ಯಾಕ್ ಉಗ್ಡುನ್ ಸಾಂಗ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","ತ್ಯಂಚಾನಿ ತ್ಯ ಐಕುನ್ ದೇವಾಲಾ ವವ್ಯಾಳಾ. ತವಾ ತೆ ತ್ಯಲಾ ಮನ್ಲ; “ಬಾವ್ಹಾ, ಯೆಹುದ್ಯಾತ್ಲ ಯೇಸುವ ಇಸ್ವಾಸ್ ಥೆವ್ನಾರ ಹಾಜಾ಼ರ್ಜಾ಼ನ್ ಆಸ್‍ಲ್ಯಾಲ ಬಕ್ಷಿಲ್. ತ್ಯನಾ ಸಗ್‍ಳ್ಯಾನಾ ಧರ್ಮಶಾಸ್ತಾರ್ ಬಕ್ತಿನಿ ಪಾಳಾಚ಼ ಮಹತ್ವಾಚ಼ ವಾಟ. ");
INSERT INTO gok_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","ಯಹುದಿ ನಸಲ್ಯಾಲ್ಯಾ ಲೊಕಾಂಚೆ ಮದ್ದಿ ರಾನ್ಹಾರ‍್ಯಾ ಯೆಹುದ್ಯಾನಾ; ‘ಯಹುದಿ ನಸಲ್ಯಾಲ್ಯಾ ತುಮ್ಚಾ ಪೊರಾನಾ ಮುಂಜಿ ಕರುನಕೊಸಾ, ತ್ಯಂಚಾ ಆಚಾರಾಚೆಗತ್ ಚಾ಼ಲು ನಕೊಸಾ ದರ್ಮಶಾಸ್ತಾರ್ ಪಾಳುನಕೊಸಾ ಮನ್ಹುನ್ ಶಿಕಿವತೊಸ್’ ಆಸ ತುಜೆ ಗುಸ್ಟಿತ್ ಯಹುದಿ ಲೊಕಾಂಚಾನಿ ಸಾಂಗ್‍ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","ತು ಆಲ್ಯಾಲಾ ತ್ಯನಾ ಕಸಾ ಸಮಾಜ್ನಾ಼ರ್. ಆತಾ ಆಮಿ ಕ್ಯಾ ಕರಾಯಾ ವ್ಹಯಿ? ");
INSERT INTO gok_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","ತವಾ ಆತಾ ಆಮಿ ತುಲಾ ಸಾಂಗತಾವ್ ತಸ ಕರ್. ಆಮ್ಚಿಪ ಶಪತ್ ಕೆಲ್ಯಾಲ ಚಾರ್ಜಾ಼ನ್ ಹಾತ. ");
INSERT INTO gok_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","ತು ತ್ಯನಾ ಹಾಕ್ಟುನ್ ನಿಹುನ್ , ತ್ಯಂಚಿ ಸಂಗ ಶುದ್ ಕರುನ್ ಘೆ ತ್ಯೆ ಆಪಲ್ಯಾ ಆಪಲ್ಯಾ ಶಪ್ತಿ ಫಿಡುಂತ, ತ್ಯಂಚಾ಼ ಕರ್ಚ಼ ತು ದೆ. ಆಸ ಕೆಲ್ಯಾವ ಸಗ್ಳಿ ತುಜೆ ಗುಸ್ಟಿತ್ ಆಪ್ನು ಐಕ್ಯಾಲ್ಯಾಲ ಖರನವ್ಹ ಮನ್ಹುನ್, ತು ದರ್ಮಶಾಸ್ತಾರಾಚೆಗತ್ ಚಾ಼ಲ್ತೊಸ್, ಮನ್ಹುನ್ ಸಮಜು಼ನ್ ಗಿಥಿಲ. ");
INSERT INTO gok_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","ಯಹುದಿ ನಸಲ್ಯಾಲ್ಯಾಂಚಾನಿ ಯೇಸುವ ಇಸ್ವಾಸ್ ತೆವಲ್ಯಾಲ್ಯಾಂಚೆ ಗುಸ್ಟಿತ್, ಪಾಶಾನಾನಾ ಥೆವಲ್ಯಾಲಾ ನಿವದ್, ರಗಾತ್, ಮಾನ್ ಆವ್ಳುನ್ ಮ್ಯಾರ್ಲ್ಯಾಲ ಜ಼ನಾವಾರಾಚ಼ ಮಾಸ್ ಖಾವುನಾಹಿ ವ್ಯಬಿಚಾರ್ ಆನಿ ಅನಿತಿಕ್ ಸಮಂದ್ ಸುಡುನ್ ದುರ್ ವ್ಹಯಾವ್ಹಯಿ ಮನ್ಹುನ್ ಆಮಿ ನಿರ್ಧಾರ್ ಕೆಲ್ಯಾಲಾ ನೆಮ್ ಲಿವುನ್ ಲಾವುನ್ ದಿಲ್ಯಾನವ್ಹ” ಮನ್ಹುನ್ ಸಾಂಗತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","ತವಾ ಪೌಲ್ ದುಸ್ರೆದಿಸಿ ತ್ಯಾ ಚಾರ್ ಜ಼ನಾಸಂಗ್ನಿ ಜಾ಼ವುನ್ ಶುದ್ ಕರಾಚಾ಼ ನೆಮ್ ಕೆಲಾ. ನಂತರ್ ಶುದ್ ಕರುನ್ ಸಪ್ವಾಚ಼ ದಿಸ್ ಸಮಜಾ಼ಯಾ ಸಾಟಿ ದೇವ್ಳಾತ್ ಗೆಲಾ. ತ್ಯಂಚಾತ್ ಪರ್ತೆಕಾಲಾ ಜ಼ನಾವರ ಕವಾ ಮಾರಾಚಿ ಮನ್ಹುನ್ ಸಾಂಗ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","ತ್ಯೆ ಸಾತ್ ದಿಸ್ ಸರ್ತ್ಯಾತ ಮಂಜೆ ಆಶಾ ಸೀಮತ್ನಿ ಆಲ್ಯಾಲ್ಯಾ ಯೆಹುದ್ಯಾಂಚಾನಿ ಪೌಲಾಲಾ ದೇವ್ಳಾತ್ ಬಗುನ್ ಹಿಂಡಾತಲ್ಯಾ ಲೊಕಾನಾ ಸಗಳ್ಯಾ ಪಾಕುನ್ ತ್ಯಲಾ ದರ್ಲಾ; ");
INSERT INTO gok_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","“ಇಸ್ರಾಯೇಲ್ ಲೊಕಾನು, ಆಮಾನಾ ಮಜ಼ತ್ ಕರಾ, ಆಮ್ಚಾ ಲೊಕಾನಾಬಿ, ಧರ್ಮಶಾಸ್ತಾರಾಲಾ, ಹ್ಯಾ ದೇವ್ಳಾಚೆ ಆಡ್ವ ಕುಠಬಿ, ಸಗಳ್ಯಾನಾ ಶಿಕಿವ್ನಾರಾ ತ್ಯೊ ಮಾನುಸ್ ಹ್ಯೊಸ್. ಯವ್ಡಸ್ ನವ್ಹ ಹ್ಯೊ ಗ್ರೀಕಾನಾ ದೇವ್ಳಾತ್ ಹಾಕ್ಟುನ್ ಆನುನ್ ಹ್ಯೊ ಪವಿತ್ರ ಜಾ಼ಗಾ ಬಾಟಿವಲ್ಯಾ” ಮನ್ಹುನ್ ವರಾಡ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","ಆಂದಿ ತೆ ಎಫೆಸಾಚಾ ತೊಪ್ರಿಮಾಲಾ ತ್ಯಂಚಿ ಸಂಗ ಪೆಠತ್ ಬಗ್ಲಾ ಮನ್ಹುನ್ ತ್ಯಲಾ ಪೌಲಾನಿ ದೇವ್ಳಾತ್ ಹಾಕ್ಟುನ್ ಆನ್ಲಾ ಮನ್ಹುನ್ ಸಮಜು಼ನ್ ಗೆತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","ತವಾ ಪೆಠತ್ ಸಗ್ಳಿಕ್ಡ ಗೊಂದೊಳ್ ಜಾ಼ಲ್ಹಾ, ತವಾ ಲೊಕ ಸಗ್ಳಿಕ್ನಿ ಪಳತ್ ಯವುನ್ ಯಕಿಕ್ಡ ಜ಼ಮ್ಲಿತ. ಆನಿ ಪೌಲಾಲಾ ದರುನ್, ದೇವ್ಳಾತ್ನಿ ಬಾಹಿರ್ ವಡುನ್ ಆನಲ್ಯಾ ಬರ್ಬರ್ ದಾರ ಜಾ಼ಖ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","ತೆ ತ್ಯಲಾ ಮಾರುನ್ ಟಾಕಾಯಾ ಯತ್ನ ಕರ್ತಾನಾ ಯೆರುಸಲೇಮಿತ್ ಸಗ್ಳಿಕ್ಡ ಗೊಂದೊಳ್ ಉಟ್ಲಾ ಮನ್ಹುನ್ ಪಟಾಲಮಿಚಾ ಸರದಾರಾಲಾ ಬಾತ್ನಿ ಪುಚ್ಲಿ಼. ");
INSERT INTO gok_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","ತ್ಯೊ ತಾಬಡ್ತೊಬ್ ಸಿಪಾಯಿನಾ, ಶತಾದಿಪತಿನಾ ಅದಿಕಾರ‍್ಯಾನಾ ಗಿಹುನ್ ತಿಥ ಪಳತ್ ಆಲಾ. ತವಾ ತ್ಯಂಚಾನಿ ತ್ಯನಾ ಬಗುನ್ ಪೌಲಾಲಾ ಮಾರಾಚ಼ ಥಾಂಬಿವ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","ಮಂಗ್ ಸರದಾರ್ ಪೌಲಾಪ ಯವುನ್ ತ್ಯಲಾ ದರಲ್ಯಾಲ್ಯಾಲಾ ದೊನ್ ಸಾಕಳ್ಯಾಂಚಾನಿ ಬಾಂದಾಯಾ ಸಾಂಗ್ಲ; ಆನಿ ಹ್ಯೊ ಮಾನುಸ್ ಕೊನ್? ಹ್ಯನಿ ಕ್ಯಾ ಚು಼ಕ್ ಕೆಲೆ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ ");
INSERT INTO gok_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","ತವಾ ಗರ್ದಿತ್ನಿ ಥೊಡ್ಯಾಚಾಂನಿ ಆಸ, ಥೊಡ್ಯಾಚಾಂನಿ ತಸ ಮನ್ಹುನ್ ವರಾಡ್ತಾನಾ ಗೊಂದ್ಳಾಸ್ಲಾಗುನ್ ಖರ ಸಮಜಾ಼ಚೆ಼ ಆಂದಿ ತ್ಯಲಾ ಕೊಟೆತ್ ಗಿಹುನ್ ಜಾ಼ವಾ ಮನ್ಹುನ್ ಹುಕುಮ್ ದೆತೊ. ");
INSERT INTO gok_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","ಪೌಲ್ ಪ್ಯಾಯರ‍್ಯಾಂಚಿವ ಆಸ್ತಾನಾ ಸಿಪಾಯಿಂಚಾನಿ ತ್ಯಲಾ ಉಚ಼ಲುನ್ ನೆಲಾ. ಕಾಮಂಜೆ ಹಿಂಸಕ್ ಲೊಕ ಖುಬ್ ಜ಼ಮ್ಲಿಹುತ್ತಿತ ");
INSERT INTO gok_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","ಮಿಳುನ್ ಆಲ್ಯಾಲಿ ಲೊಕ ಮಾಗ್ನಿ ಯವುನ್; “ತ್ಯಲಾ ಮಾರುನ್ಟಾಕಾ” ಮನ್ಹುನ್ ವರ್ಡತಿತ. ");
INSERT INTO gok_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","ಶಿಪಾಯಿಂಚಾನಿ ಪೌಲಾಲಾ ಕೊಟೆತ್ ಗಿಹುನ್ ಜಾ಼ಯಾಚೆ ಆಂದಿ ತ್ಯನಿ ತ್ಯಾ ಸರದಾರಾಲಾ, “ಮಿ ಜ಼ರಾ ಬುಲು ಕ್ಯಾ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ ತವಾ ತ್ಯನಿ; “ತುಲಾ ಗ್ರೀಕ್ ಬಾಶೆ ಯತಿಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","ಥೊಡ್ಯಾ ದಿಸಾಚೆ ಮಾಗ ದಂಗಾ ಉಟ್ವುನ್ ತ್ಯೆ ಚಾರ್ ಹಾಜಾ಼ರ್ ಜಾ಼ನ್ ಖುನ್ಸಿನಾ ರಾನಾತ್ ಹಾಕ್ಟುನ್ ನೆಲ್ಯಾಲಾ ತ್ಯೊ ಐಗುಪ್ತ್ ತುಸ್ ನವ್ಹಸ್ ಕ್ಯಾ? ಮನ್ಹುನ್ ಇಚಾರ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","ತ್ಯಲಾ ಪೌಲಾನಿ ಉತ್ತರ್ದಿಲಾ; “ಮೀ ಯೆಹುದ್ಯಿ, ತಾರ್ಸಸಾತ್ ಜ಼ಲಾಮಲ್ಯಾಲೊ, ನಾವ್ ವಾಜ಼ಲ್ಯಾಲೆ ಪೆಠಚಾ ಕಿಲಿಕ್ಯಾ ಸಿಮತ್ಲಾ. ದಯೆಥಿವುನ್ ಹ್ಯಾ ಲೊಕಾಂಚಿಸಂಗ ಜ಼ರಾ ಬೊಲಾಯಾ ಮನಾ ಹುಕುಮ್ ದೆ” ");
INSERT INTO gok_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","ಸರದಾರಾನಿ ಹುಕುಮ್ ದಿಲಾ, ಪೌಲ್ ಪ್ಯಾಯರ‍್ಯಾವ್ನಿ ಉಬಾರಾಹುನ್, ಲೊಕಾನಾ ಹಾತಾನಿ ಸುಸ್ನಾ ಕರ್ತೊ. ಗೊಂದೊಳ್ ಖುಬ್ ಶಾಂತ್ ಜಾ಼ಲ್ಯಾ ನಂತರ್ ತ್ಯೊ ಇಬ್ರಿಯಾ ಬಾಶೆತ್ ಬೊಲಾಯಾ ಲಾಗ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“ಯೆಹುದಿ ಸೊಪ್‌ತ್ಯಾನು, ಮಿ ಆತಾ ಸಾಂಗ್‍ತ್ಯಾಲ ಐಕಾ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","ಪೌಲ್ ತ್ಯಂಚೆ ಇಬ್ರಿಯಾ ಬಾಶೆತ್ ಬೊಲ್‌ತ್ಯಾಲಾ ಐಕುನ್ ಯೆಹುದಿ ಆನಿಕ್ ಗಪ್ ಜಾ಼ಲ್ಹ. ತವಾ ತ್ಯೊ ಆಸಾ ಮನ್ಲಾ: ");
INSERT INTO gok_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“ಮಿ ಯೆಹುದಿ ಮಿ ಜ಼ಲಾಮ್‌ಲ್ಯಾಲೊ ಸಿಲಿಯಾ ದೇಶೆಚಾ ತಾರ್ಸಾತ್. ಫನ್ ಮಿ ಮೊಟಾಜಾ಼ಲ್ಯಾಲೊ ಯೇರುಸಲೇಮಿತುಸ್. ಮಿ ಗಮಲಿಯಾಪ ನಾನ್ಹಾಚಾ಼ ಥೊರ್ ಜಾ಼ಲ್ಹೊ. ಆಮ್ಚಾ ವಾಡವಡ್ಲಾಂಚಾ ಧರ್ಮಶಾಸ್ತಾರಾಚೆ ಗುಶ್ಟಿತ್ ಪರತೇಕ್ ಯಾಕ್ ತ್ಯನಿ ಮನಾ ಖುಬ್ ಬರ ಸಾಂಗಲ್ಯಾ. ಆಜ಼್ ಹಿತ್ತ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ತುಮ್ಚಾ ಸಗ್‌ಳ್ಯಾಂಚೆಗತ್ ಮಿ ದೇವಾಚೆ ಸೆವೆಚೆ ಗುಶ್ಟಿತ್ ಖುಬ್ ಮರ‍್ಯಾದ್ ಆಸ್‌ಲ್ಯಾಲಾ ಜಾ಼ಲ್ಯೊ. ");
INSERT INTO gok_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","ಯೇಸುಚಾ ಮಾರ್ಗಾಚೆ ಮಾಗ ಕೊನ್ ಜಾ಼ತ್ಯಾತ ತ್ಯನಾ ಮಿ ಮರ ಪರೇತ್ ಹಿಂಸಾ ಕಿಲಿ. ಮಾಜಿಸ್ಲಾಗುನ್ ತ್ಯಂಚಾತ್ಲ ಘಾತ್ ಜಾ಼ಲ. ಮಿ ಗಡ್ಯಾನಾ ಆನಿ ಬಾಯಿಲ್‍ ಮಾನ್ಸಾನಾ ದರ‍್ಹುನ್ ತುರುಂಗಾತ್ ಗ್ಯಾತ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","“ತವಾ ಮುಖ್ಯಯಾಜಕ್ ಆನಿ ನ್ಯಾಯಿಸಬೆಚೆ ಮೊರ‍್ಹ ಮಿ ಖರ ಸಾಂಗ್ತೊ ತ್ಯಂಚಿಪ್ನಿಸ್ ಮಿ ದಮಸ್ಕಾತ್ ಆಸ್‍ಲ್ಯಾಲ್ಯಾ ಯೆಹುದಿ ಸೊಪ್‌ತ್ಯಾನಾ ಹ್ಯ ಪತ್ರ ಗಿಹುನ್ ತಿಥ ಗೆಲ್ಯಾಲ್ಯಾನಾ ಸಾಕ್‍ಳ್ಯಾಂಚಾನಿ ಬಾಂದುನ್ ಯೆರುಸಲೆಮಿತ್ ವಡುನ್ ಆನಾಯಾ ಜಾ಼ತ್ಯಾಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“ಮಿ ಜಾ಼ತಾನಾ ದಮಸ್ಕಾಚೆ ಜ಼ವಳ್ ಆಲೊ ತವಾ ದೊಪ್ಯಾರ್ ಜಾ಼ಲ್ಥಿ. ತವಾ ಯಖಾಯಖಿ ಉಜಿಡ್ ಯೊಕ್ ಮಾಜೆ ಬೌತ ಚ಼ಮಾಕ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","ಮಿ ಬುಡಿ ಪಡ್ಲೊ. ತವಾ, “ಸೌಲಾ ಸೌಲಾ, ತು ಮನಾ ಕಾ ತರಾಸ್ ದೆತ್ಯೊಸ್? ಮನ್ಹುನ್ ಮನಾ ಸಬ್ದ ಯೊಕ್ ಐಕು ಆಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","ತವಾ ಮಿ ಪ್ರಭು ತು ಕೊನ್? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ತ್ಯೊ ಸಬ್ದ ಮಿ ನಜ಼ರೆತಿಚಾ಼ ಯೇಸು. ತು ತರಾಸ್ ಕರ್ತ್ಯಾಲಾ ಮನಾಸ್ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","ಮಾಜೆ ಸಂಗ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ಲೊಕಾಂಚಾನಿ ಮಾಜೆ ಸಂಗ ಬೊಲ್‌ತ್ಯಾಲ್ಯಾಚಾ಼ ಸಬ್ದ ಐಕ್ಲಾನಾಹಿ. ಫನ್ ತ್ಯಂಚಾನಿ ಉಜಿ಼ಡ್ ಬಗ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","ತವಾ ಮಿ ಪ್ರಬು ಮಿ ಕ್ಯಾ ಕರು? ಮನ್ಲೊ. ಪ್ರಭುನಿ ಉಠುನ್ ದಮಸ್ಕಾತ್ ಜಾ಼. ಮಿ ತುಲಾ ಥರಿವಲ್ಯಾಲ ಕಾಮ್ ಸಗ್ಳ ತಿಥ ತುಲಾ ಸಮಾಜ಼್ನಾರ್ ಮನ್ಹುನ್ ಉತ್ತರ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","ಚ಼ಮಕತ್ಯಾಲ್ಯಾ ತ್ಯಾ ಉಜಿಡಾನಿ ಮನಾ ಅಂದ್ಳಾ ಕೆಲಾ ಮನ್ಹುನ್ ಮನಾ ಕಾಯ್ ದಿಸನಾ. ತವಾ ತ್ಯಾ ಲೊಕಾಂಚಾನಿ ಮನಾ ದಮಸ್ಕಾತ್ ಹಾತ್ ದರುನ್ ಚಾ಼ಲ್ವಿತ್ ನೆಲ್ಹಾ. ");
INSERT INTO gok_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“ತೆ ಪೆಠತ್ ಅನನಿಯಾ ಮಂಥ್ಯಾಲಾ ಯೊಕ್ ಮಾನುಸ್ ಮೊಶೆಚ಼ ಧರ್ಮಶಾಸ್ತಾರ್ ಪ್ಯಾಳತ್ಯಾಲಾ ದೆವಾಚಾ಼ ಬಘತ್ ಜಾ಼ಲ್ಥಾ. ತಿತ್ಲಿ ಯೆಹುದಿ ನಸಲ್ಯಾಲಿ ಸಗ್ಳಿ ತ್ಯಲಾ ಮರ‍್ಯಾದ್ ದಿಯಿತಿತ. ");
INSERT INTO gok_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","ಅನನಿಯಾ ಮಾಜಿಪ ಯವುನ್ ಬಾಹು ಜಾ಼ಲ್ಯಾಲ್ಯಾ ಸೌಲಾ ತುಜಿ ನದಾರ್ ಯವುನಿ ಮನ್ಲಾ ಮನಾ ತವಾಸ್ ನದಾರ್ ಆಲಿ ಆನಿ ಮಿ ತ್ಯಲಾ ಬಗ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","ತು ದೇವಾಚಿ ಯವಜ್ನಾ಼ ಸಮಜು಼ನ್ ಗಿಹ್ಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ನ್ಯಾಯಿಚಾ ಸೆವಕಾಲಾ ಬಗಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ತ್ಯೊ ಆಪಲ್ಯಾ ಸ್ವತಾಚಾ ನಾದಾನಿ ಬೊಲಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ದೇವಾನಿ ತುಲಾ ನಿವಡ್‌ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","ತು ಬಗ್‌ಲ್ಯಾಲ ಆನಿ ಐಕ್‌ಲ್ಯಾಲ್ಯಾ ಖನ್ಕತಿ ಸಗ್‌ಳ್ಯಾ ಲೊಕಾನಾ ಸಾಕ್ಷಿ ಸಾಂಗಾಯಾ ವ್ಹಯಿ. ");
INSERT INTO gok_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","ಆತಾ ತು ಕಾ ಥಾಂಬ್ತೊಸ್? ಉಟ್! ತ್ಯಚಿವ ಇಸ್ವಾಸ್ ಥೀವುನ್ ಬಾಪ್ತಿಸ್ಮಾ ಗಿಹುನ್ ತುಜಿ ಪಾಪ ಧು’ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ ಆನಿ ತ್ಯಚಿಸಾಟಿ ಮಾಗ್ನ ಕೆಲ. ");
INSERT INTO gok_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“ತವಾ ಮಿ ಯೆರುಸಲೆಮಿತ್ ಮಾಗಾರಾ ಪರಾತ್ಲೊ. ಮಿ ದೇವ್ಳಾತ್ ಮಾಗ್ನ ಕರ್ತಾನಾ ಮನಾ ಯಾಕ್ ದರ್ಶಾನ್ ಜಾ಼ಲ್ಹ. ");
INSERT INTO gok_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","ತವಾ ಮಿ ಪ್ರಬುಲಾ ಬಗ್ಲಾ. ತ್ಯನಿ ಮನಾ, ‘ಬಿಗಿನಿ ಯೇರುಸಲೇಮಿತ್ನಿ ಜಾ಼! ಮಾಜೆ ಗುಶ್ಟಿತ್ ಸಾಂಗಲ್ಯಾಲ್ಯಾ ಹ್ಯಾ ಸಾಕ್ಷಿ ತಿ ಲೊಕ ಮಾನಿತ್ನಾಹಿತ’ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","ತವಾ ಮಿ ಮನ್ಲೊ, ‘ಪ್ರಭು, ಸಗ್‍ಳ್ಯಾ ಸಬಾಸ್ಥಾನಾತ್ನಿ ತುಜಿವ ಇಸ್ವಾಸ್ ಥೆವಲ್ಯಾಲ್ಯಾನಾ ತುರುಂಗಾತ್ ಗಾಲ್ಹುನ್ ಮಾರಿತ್ ಹುತೊ. ");
INSERT INTO gok_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","ಆನಿ ತುಜಿ ಸಾಕ್ಷಿ ಜಾ಼ಲ್ಯಾಲ್ಯಾ ಸ್ತೆಪನಾಲಾ ಮಾರುನ್ ಟ್ಯಾಕ್ಲಾ ತವಾ ಮಿ ತಿಥ ಸ್ವತಾ ಉಬಾ ರಾಹುನ್ ತ್ಯಲಾ ಮ್ಯಾರ್ತ್ಯಾಲ್ಯಾಂಚಿ ದಢೊತ ಸಂಬ್ಯಾಳಿತೊ ತ್ಯ ತ್ಯನಾ ಠಾವ ಹಾ!’ ");
INSERT INTO gok_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","ಫನ್ ಪ್ರಭುನಿ ಮನಾ ಆತಾ ಜಾ಼, ಖುಬ್ ದುರ್ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ಯೆಹುದಿ ನಸ್‌ಲ್ಯಾಲ್ಯಾ ಲೊಕಾಂಚಿಪ ಮಿ ತುಲಾ ಲಾವುನ್ ದೆತೊ’ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ” ");
INSERT INTO gok_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","ಹ್ಯಾ ಸಬ್ದಾ ಪರತ್ ಲೊಕಾಂಚಾನಿ ಪೌಲಾನಿ ಸಾಂಗಲ್ಯಾಲ ಸಗ್ಳ ಐಕ್ಲ ಮಂಗ್ ಆಸ್‌ಲ್ಯಾ ಮಾನ್ಸಾಲಾ ದರ್ತಿವ್ನಿ ನಾಹಿ ಕರಾ ಹ್ಯೊ ಜ಼ಗಾಯಾ ಲಾಯಿಕ್ನಾಹಿ! ಮನ್ಹುನ್ ವರಾಡ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","ತೆ ವರಡತ್; ಆಪ್‌ಲ್ಯಾ ವೈಲ್ಯಾ ಅಂಗ್ಯಾ ಕಾಡುನ್; ದುಳ್ಳಾ ವರ್ ವಾರ‍್ಯಾಕೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","ತವಾ ರೊಮಾಚಾ ಸೆನಾಧಿಪತಿನಿ ಪೌಲಾಲಾ ಆತ್ ನಿಹುನ್ ಮಾರಾಯ ಸೈನಿಕಾನಾ ಸಾಂಗ್ಲ. ಲೊಕ ಪೌಲಾಚೆ ಆಡ್ವ ಹೆ ತರನಿ ವರ್ಡಾಯಾ ಕಾರನ್ ಕ್ಯಾ ಮನ್ಹುನ್ ಪೌಲಾಪ್ನಿಸ್ ಸಮಜು಼ನ್ ಗಿಯಾವ್ಹಯಿ ಮನ್ಹುನ್ ಸೆನಾದಿಪತಿಚಿ ಇಚಾ ಜಾ಼ಲ್ಥಿ. ");
INSERT INTO gok_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","ಸೈನಿಕಾಂಚಾನಿ ಪೌಲಾಲಾ ಮಾರಾಯಾ ಬ್ಯಾಂತಾನಾ ತಿಥ ಅಸ್‌ಲ್ಯಾಲ್ಯಾ ರೊಮ್ ಅಧಿಕಾರ‍್ಯಾಲಾ ಪೌಲಾನಿ, “ಚು಼ಕಿಚಾ಼ ಮನ್ಹುನ್ ತಿರ್ಮಾನ್ ವ್ಹಯಾಚೆ ಆಂದಿ ತುಮಿ ರೊಮಾತಲ್ಯಾಲಾ ಮಾರಾಚ಼ ಕ್ಯಾಯ್ದೆಸಿರ್ ಹಾ ಕ್ಯಾ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","ತ್ಯಾ ಅದಿಕಾರಿನಿ ಹ್ಯ ಐಕ್‌ಲ್ಯಾ ಬರ್ಬರ್ ಸರದಾರಾಪ ಜಾ಼ವುನ್, “ತು ಕ್ಯಾ ಕರ್ತ್ಯೊಸ್ ತ್ಯ ತುಲಾ ಠಾವ ಹಾ ಕ್ಯಾ? ಹ್ಯೊ ಮಾನುಸ್ ರೊಮಾತ್ಲಾ!” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","ತವಾ ಸರದಾರ್ ಪೌಲಾಪ ಯವುನ್, “ತು ಖರ‍್ಯಾನಿಸ್ ರೊಮಾಚಾ಼ ಮಾನುಸ್ ಕ್ಯಾ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ಪೌಲಾನಿ, “ವ್ಹಯ” ಮನ್ಹುನ್ ಉತ್ತರ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","ತವಾ ಸೆನಾದಿಪತಿನಿ ಮಿ ರೊಮಾಚಾ಼ ಮಾನುಸ್ ವ್ಹಯಾ ಖುಬ್ ಪೈಸ ದಿಲ್ಯಾತ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ಫನ್ ಪೌಲ್ ಮಿ ಜ಼ಲ್ಮತುಸ್ ರೊಮಾಚಾ಼ ಮಾನುಸ್” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","ಪೌಲಾಲಾ ಪ್ರಶ್ನೆ ಕರಾಯಾ ತಯಾರ್ ಜಾ಼ಲ್ಯಾಲಿ ಲೊಕ ತವಾಸ್ ಪೌಲಾಪ್ನಿ ನಿಗುನ್ ಗಿಲಿತ. ಪೌಲಾಲಾ ಬ್ಯಾಂದ್ಲಾಹುತ್ತಾ. ಮನ್ಹುನ್ ಆನಿ ಪೌಲ್ ರೊಮಾಚಾ಼ ಮಾನುಸ್ ಜಾ಼ಲ್ತಾ ಮನ್ಹುನ್ ಸೇನಾದಿಪತಿಲಾ ಬ್ಯಾ ವಾಟ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","ದಿಸ್ರೆ ದಿಸಿ ಸಕಾಳ್ಚ಼ ಪೌಲಾಲಾ ಆಡ್ವಾ ವ್ಹವುನ್ ಯಹುದ್ಯಾಂಚಾನಿ ಆನ್‌ಲ್ಯಾಲಾ ಆಪವಾದ್ ಕ್ಯಾ ಮನ್ಹುನ್ ಸಮಜು಼ನ್ ಗಿಹ್ಯಾ ಸರದಾರಾನಿ ನಿರ್ದಾರ್ ಕೆಲಾ. ಆನಿ ತ್ಯನಿ ಮುಖ್ಯ ಯಾಜಕಾನಾ ಯೆಹುದ್ಯಾಂಚೆ ನ್ಯಾಯಿ ನಿವಡ್‌ತ್ಯಾಲೆ ಸಭೆಲಾಬಿ ಯಕಿಕ್ಡ ಮಿಳುನ್ ಯಯಾ ಆಜ್ಞಾ ದಿಲಿ. ಸರದಾರಾನಿ ಪೌಲಾಚಾ ಸರಪೊಳ್ಯಾ ಕಾಡುನ್ ತ್ಯಲಾ ಬಾಹಿರ್ ಗಿಹುನ್ ಯವುನ್ ಸಭೆಚೆ ಮೊರ‍್ಹ ಉಬಾಕೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","ಪೌಲ್ ಯೆಹುದ್ಯಾಂಚೆ ನ್ಯಾಯಿಸಬೆಲಾ ಬಗುನ್, “ಬಾವ್ಹಾನು ಮಿ ಆಜು಼ನ್ಪರತ್ ಚಾ಼ಂಗಲ್ಯಾ ಮನಾನಿ ದೇವಾಚೆ ಮೊರ‍್ಹ ಚಾ಼ಲ್ಯೊ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","ಮುಖ್ಯಯಾಜಕ್ ಜಾ಼ಲ್ಯಾಲಾ ಅನನಿಯಾ ತಿಥ ಹುತ್ತಾ. ಪೌಲಾನಿ ಸಾಂಗ್‌ಲ್ಯಾಲ ಐಕ್‌ಲ್ಯಾಲ ತ್ಯನಿ ಪೌಲಾಚೆ ಕಡಸ್ ಉಬಿರಾಯ್‌ಲ್ಯಾಲ್ಯಾನಾ ತ್ಯಚಾ ತೊಂಡಾವ ಮಾರಾಯಾ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","ತವಾ ಪೌಲಾನಿ ಅನನಿಯಾಲಾ, “ದೇವ್ ತುಲಾ ಸಾಹಿತ್ ಮ್ಯಾರ್ನಾರ್! ತು ಚು಼ನ್ನಾ ಲ್ಯಾವಲ್ಯಾಲಿ ಭಿತ್! ಮೊಶೆಚಾ ದರ್ಮಶಾಸ್ತಾರಾಚೆಗತ್ ನ್ಯಾಯಿ ನಿವ್ಡಾಯಾ ತಿಥ ಬಸುನ್ ಮನಾ ಮಾರಾಯಾ ಸಾಂಗ್ತೊಸ್ ಕ್ಯಾ? ಧರ್ಮಶಾಸ್ತಾರಾಲಾ ತ್ಯೊ ಆಡ್ವಾ ಜಾ಼ಲ್ಯಾ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","ಪೌಲಾಚೆ ಜ಼ವಳ್ ಉಬಿ ರಾಯ್‌ಲ್ಯಾಲಿ ಲೊಕ ತ್ಯಲಾ, “ದೇವಾಚಾ ಮುಖ್ಯಯಾಜಕಾಲಾ ತು ಹೆ ತರನಿ ಬೊಲಾಚ಼ ನವ್ಹ! ತು ತ್ಯಚಿ ನಿಂದಾ ಕರ್ತ್ಯೊಸ್!” ಮನ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","ಪೌಲ್, “ಬಾವ್ಹಾನು, ಹ್ಯೊ ಮಾನುಸ್ ಮುಖ್ಯಾ ಯಾಜಕ್ ಮನ್ಹುನ್ ಮನಾ ಠಾವಾ ನವ್ಥಾ. ಫನ್ ‘ತುಮ್ಚಾ ಲೊಕಾಂಚಾ ಅದಿಕಾರ‍್ಯಾಂಚೆ ಆಡ್ವ ವಾಯಿಟ್ ಬುಲು ನಕೊ’ ಮನ್ಹುನ್ ಧರ್ಮಶಾಸ್ತಾರಾತ್ ಲಿವ್‌ಲ್ಯಾಲ ಹಾ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","ಸಭೆತಲ್ಯಾ ಲೊಕಾತ್ನಿ ಥೊಡ ಸದ್ದುಕಾಯ್; ಆನಿ ಥೊಡ ಪರಿಸಾಯ್ ಹುತ್ತ. ಮನ್ಹುನ್ ಪೌಲಾನಿ, “ಮಾಜಾ ಬಾವ್ಹಾನು, ಮಿ ಪರಿಸಾಯ್! ಮಾಜ಼ಾ ಬಾ ಪರಿಸಾಯಾತ್ಲಾ ಜಾ಼ಲ್ಥಾ! ಮೆಲ್ಯಾಲ್ಯಾಂಚಾ ಪುನರುಥಾನಾಚೆ ಗುಸ್ಟಿತ್ ಮಾಜಿ ಆಶಾ ಹಾ ತ್ಯಚಿ ಚರ್ಚಾ ಚಾ಼ಲ್ಲೆ!” ಮನ್ಹುನ್ ವರ್ಡುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","ಪೌಲಾನಿ ಆಸ ಸಾಂಗ್ಲ ತವಾ, ಪರಿಸಾಯಾಂಚ಼ ಆನಿ ಸದ್ದುಕಾಯಾಂಚ಼ ಬಾಂಢಾನ್ ಜಾ಼ಲ್ಹ. ಆನಿ ಸಬೆತ್ ದುಯಿ ಪಡ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","ಮೆಲ್ಯಾಲ್ಯಾನಾ ಪುನರುತ್ಥಾನ್ ನಾಹಿ. ದೇವ್ದುತ್ ಆನಿ ಆತ್ಮಬಿ ನಾಹಿ ಮನ್ಹುನ್ ಸದ್ದುಕಾಯಾಂಚಾ಼ ಇಸ್ವಾಸ್. ಫನ್ ಫರಿಸಾಯಾಂಚಾ಼ ಇಸ್ವಾಸ್ ಹ್ಯಚೆ ಆಡ್ವಾ ಜಾ಼ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","ತಿಥ ಮೊಟಾ ಗಾನ್ಹಾ ಜಾ಼ಲ್ಹಾ. ತವಾ ಪರಿಸಾಯಾತ್ಲ ಥೊಡಜಾ಼ನ್ ದರ್ಮ ಸಿಕಿವ್‌ತ್ಯಾಲ ಉಬ ರಾಹುನ್, “ಹ್ಯಾ ಮಾನ್ಸಾಪ ಆಮಾನಾ ಕಾಯೆಕ್ ಚು಼ಕ್ ದಿಸನಾ! ದಮಸ್ಕಾತ್ ಜಾ಼ತ್ಯಾಲೆ ವಾಟವ ದೆವ್ದುತ್ ವ್ಹವುನಿ ಆತ್ಮ ವ್ಹವುನಿ ತ್ಯಚಿ ಸಂಗ ಬೊಲ್ಲ ಆಸಲ್! ಮನ್ಹುನ್ ವಾದ್ ಕೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","ಹ್ಯ ಬಾಂಢಾನ್ ವ್ಹತ್ಯಾಲ ಆಸ್ತಾನಾ. ಯೆಹುದಿ ಪೌಲಾಲಾ ತುಕ್ಡ ತುಕ್ಡ ಕರ್ನಾರ್ ಮನ್ಹುನ್ ಬಿಹುನ್ ಸೆನಾದಿಪತಿನಿ ಸಿಪಾಯಿನಾ, “ಬುಡಿ ಉತ್ರುನ್ ಜಾ಼ವುನ್ ಪೌಲಾಲಾ ತಿತ್ನಿ ಸಿಪಾಯಿಂಚೆ ಕೊಟೆತ್ ನೆವ್ಹಾ” ಮನ್ಹುನ್ ಹುಕುಮ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","ತಿಸಿ ರ‍್ಯಾಚಾ಼ ಪ್ರಭು ಪೌಲಾಪ ಯವುನ್ ಉಬಾ ರಾಹುನ್, “ದಿರ‍್ಹಾನಿ! ತು ಮಾಜೆ ಗುಶ್ಟಿತ್ ಯೆರುಸಲೆಮಿಚಾ ಲೊಕಾನಾ ಸಾಂಗಲ್ಯಾಶಾರ್ಕ. ತು ರೊಮಾತ್ ಜಾ಼ವುನ್ ತಿತಲ್ಯಾ ಲೊಕಾನಾ ಮಾಜೆ ಗುಶ್ಟಿತ್ ಸಾಂಗಾಯಾ ವ್ಹಯಿ! ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","ದುಸ್ರೆ ದಿಸಿ ಸಕಾಳಚ಼ ಥೊಡ ಯೆಹುದಿ ಯಕಿಕ್ಡ ಜ಼ಮುನ್ ಪಿತುರಿ ಕರುನ್ , ಆಪ್ನು ಪೌಲಾಲಾ ಮಾರುನ್ ಟಾಕಿಪರ‍್ಯಾತ್ ಆಮಿ ಕಾಯ್ ಖಾನಾ ಪಿನಾರ್ನಾಹಿ ಮನ್ಹುನ್ ಶಪತ್ ಕಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","ಆಸಿ ಕಮಿಸ್ಕಮಿ ಚಾಳಿಸ್ ಲೊಕ ಹುತ್ತಿತ. ");
INSERT INTO gok_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","ಹೆ ಮಹಾಯಾಜಕಾಂಚಿಪ ಆನಿ ಜಾಂತ್ಯಾಂಚಿಪ ಜಾ಼ವುನ್, “ಆಮಿ ಪೌಲಾಲಾ ಮಾರುನ್ ಟಾಕಿಸ್ ಪರತ್ ತೊಂಡಾತ್ ಕಾಯ್ ಗಾಲ್ನಾರ್ನಾಹಿ ಮನ್ಹುನ್ ಖಡ್ಯಾವುನ್ ಶಪತ್ ಕಿಲಿ! ");
INSERT INTO gok_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","ಮನ್ಹುನ್ ಆತಾ ತುಮಿ ಕರಾಯಾ ವ್ಹಯಿ ಜಾ಼ಲ್ಯಾಲ ಕ್ಯಾ ಮಂಜೆ, ಸರದಾರಾಲಾ ಆನಿ ಸಗಳ್ಯಾ ಜಾಂತ್ಯಾನಾ ಯಾಕ್ ಸಾಂಗ್ನ ಲಾವುನ್ ದೆವಾ. ಪೌಲಾಲಾ ನ್ಯಾಯಿ ಸಬೆಚೆ ಮೊರ‍್ಹ ಆನಿಕ್ ಪ್ರಶ್ನೆ ಇಚಾರಾಯಾ ವ್ಹಯಿತ ಮನ್ಹುನ್ ಸಾಂಗುನ್ ಆಮ್ಚಿಪ ಹಾಕ್ಟುನ್ ಆನಾಯಾ ರೊಮಾಚಾ ಸರದಾರಾಲಾ ಸಾಂಗಾ. ಪೌಲ್ ಹಿತ್ತ ಯತಾನಾ ಆಮಿ ವಾಟವ ರಾಖಿತ್ ರಾಹುನ್ ತ್ಯಲಾ ಮಾರುನ್ ಟ್ಯಾಕ್ತಾವ್” ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","ಫನ್ ಹೆ ಯವಜ್ನಾ಼ಚೆ ಗುಶ್ಟಿತ್ ಪೌಲಾಚಾ ಬಾಛಾಲಾ ಸಮಾಜ಼್ಲ ತ್ಯೊ ಸೈನ್ಯಾಚೆ ಕೊಟೆತ್ ಜಾ಼ವುನ್ ಹೆ ಯವಜ್ನಾ಼ಚೆ ಗುಶ್ಟಿತ್ ಪೌಲಾಲಾ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","ತವಾ ಪೌಲಾನಿ ಅದಿಕಾರ‍್ಯಾತ್‍ಲ್ಯಾ ಯಕಾಲಾ ಹಾಕ್ಟುನ್, “ಹ್ಯಾ ಪೊರ್ಗ್ಯಾಲಾ ಸೆನಾಧಿಪತಿಪ ಗಿಹುನ್ ಜಾ಼. ಹ್ಯೊ ಯೆಕ್ ಬಾತ್ನಿ ತ್ಯಲಾ ಸಾಂಗಾಚಾ಼ ಹಾ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","ಮನ್ಹುನ್ ಅದಿಕಾರಿ ಪೌಲಾಚಾ ಬಾಚ್ಚಾಲಾ ಸರದಾರಾಪ ಗಿಹುನ್ ಗೆಲಾ. ತ್ಯಾ ಅಧಿಕಾರ‍್ಯಾನಿ ಸರದಾರಾಲಾ, “ಹ್ಯಾ ಪ್ಯೊರ್ಗ್ಯಾಲಾ ತುಜಿಪ ನಿಹ್ಯಾವ್ಹಯಿ ಮನ್ಹುನ್ ತುರುಂಗಾತ್ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ಪೌಲಾನಿ ಮಾಜಿಪ ಮಾಗ್ಲ ಹ್ಯೊ ತುಲಾ ಯೊಕ್ ಸಾಂಗ್ ಸಾಂಗಾಯಾ ವ್ಹಯಿ ಮಂಥ್ಯೊ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","ಸರದಾರಾನಿ ಪ್ಯೊರ್ಗ್ಯಾಲಾ ಹಾತಾಸ್ ದರ‍್ಹುನ್ ಯಕಾನ್ಸಿ ಹಾಕ್ಟುನ್ ನಿಹುನ್, “ತು ಕ್ಯಾ ಸಾಂಗಾಯಾ ವ್ಹಯಿ ಮಂಥೊಸ್? ಮನ್ಹು‍ನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","ತ್ಯೊ, “ ಪೌಲಾಚಾ಼ ಆಜು಼ನ್ ಬಾರಿಕ್ ಇಚಾರ್ ಕರಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ನೆವಾ ಸಾಂಗುನ್ ಸಕಾಳ್ ನ್ಯಾಯಿಸಬೆತ್ ತ್ಯಲಾ ತುಸ್ ಹಾಕ್ಟುನ್ ಆನಾಯಾ ವ್ಹಯಿಸ್ ಮನ್ಹುನ್ ತುಜಿಪ ಸಾಂಗಾಯಾ ಯೆಹುದ್ಯಾಂಚಾನಿ ಬುಲುನ್ ಗೆತಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","ಫನ್ ತ್ಯಂಚ಼ ಖರದರು ನಕೊಸ್! ಪೌಲಾಲಾ ಮಾರುನ್ ಟಾಕಾಯಾ ಚಾಳಿಸ್ ಯೆಹುದಿ ದಡುನ್ ರಾಖಿತ್ ಹಾತ್ತ. ಪೌಲಾಲಾ ಮಾರುನ್ ಟಾಕಿಸ್ ಪರ‍್ಯಾತ್ ಖಾಯಿತ್ಬಿ ನಾಹಿ ಪಿಯಿತ್ಬಿ ನಾಹಿ ಮನ್ಹುನ್ ತ್ಯಂಚಾನಿ ಸಗ್‌ಳ್ಯಾಂಚಾನಿ ಶಪತ್ ಕೆಲೆ! ಆತಾ ತೇ ತುಜೆ ಒಪಿಗೆಲಾ ರ‍್ಯಾಕ್‌ತ್ಯಾತ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","ತವಾ ತ್ಯಾ ಸರದಾರಾನಿ ಪ್ಯೊರ್ಗ್ಯಾಲಾ, “ತ್ಯಂಚೆ ಯವಜ್ನಾಚೆ ಗುಶ್ಟಿತ್ ತು ಮನಾ ಸಾಂಗ್‌ಲ್ಯಾಲ ಕುನಾಲಾಸ್ ಸಾಂಗು ನಕೊಸ್” ಮನ್ಹುನ್ ಸಾಂಗುನ್ ತ್ಯಲಾ ಲಾವುನ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","ನಂತರ್ ಸರದಾರಾನಿ ದೊಗಾ ಆದಿಕಾರ‍್ಯಾನಾ ಹಾಕ್ಟುನ್ ತ್ಯನಾ, “ಕೈಸರ‍್ಯಾತ್ ಲಾವುನ್ ದಿಯಾಲಾ ದೊನ್ಸೆ ಜಾ಼ನ್ ಸೈನಿಕಾನಾ ತಯಾರ್ ಕರ್. ಸತ್ತರ್ ಜ಼ನಾನಾ ಘೊಡ ದೊನ್ಸೆ ಜ಼ನಾನಾ ಬರ್ಚಾ ತಯಾರ್ ಕರಾ. ಹೆ ರಾತಿತ್ ನವು ವಾಸ್ಥಾನಾ ಹಿತ್ನಿ ಜಾ಼ಯಾ ತುಮಿ ತಯಾರ್ ರಾಹ್ಯಾ ವ್ಹಯಿಸಾ. ");
INSERT INTO gok_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","ಪೌಲಾಚಾ ಜಾ಼ನ್ಯಾಸಾಟಿ ಥೊಡ್ಯಾ ಗೊಡ್ಯಾನಾ ಗೆವ್ಹಾ. ರಾಜ್ಭಾರ್ ಕರ್ತ್ಯಾಲ್ಯಾ ಫೆಲಿಕ್ಸಾಪ ತ್ಯಲಾ ಜ಼ಪುನ್ ನಿಹ್ಯಾಲಾ ವ್ಹಯಿ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","ಆನಿ ಸರದಾರಾನಿ ಯಾಕ್ ಪತ್ರ ಲೀವ್ಲ. ತ್ಯಾತ್ ಆಸ ಲಿವ್ಲಹುತ್ತ: ");
INSERT INTO gok_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“ಕ್ಲೊದ್ ಲುಸಿಯಾಪ್ನಿ ಮಹಾರಾಜಾ಼ ಜಾ಼ಲ್ಯಾಲಾ ರಾಜ್ಪಾಲ್ ಫೆಲಿಕ್ಸಾಲಾ, ನಮಸ್ಕಾರ್ ");
INSERT INTO gok_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","ಯೆಹುದಿ ಹ್ಯಾ ಮಾನ್ಸಾಲಾ ದರುನ್ ಮಾರುನ್ ಟಾಕಾಚ಼ ಹುತ. ಫನ್ ಹ್ಯೊ ರೊಮಾತ್ಲಾ ಮಾನುಸ್ ಮನ್ಹುನ್ ಮನಾ ಠಾವ್ಹಾ ಜಾ಼ಲ್ಹ. ತವಾ ಮಿ ಸೈನಿಕಾಂಚೆ ಸಂಗ ಜಾ಼ವುನ್ ಹ್ಯಲಾ ರ‍್ಯಾಕ್ಲಾ ಹುತಾ. ");
INSERT INTO gok_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","ತೆ ಹ್ಯಚಿವ ವಾವ್‌ತ್ಯಾಲ್ಯಾ ಚು಼ಕಿಚ಼ ಕಾರನ್ ಸಮಜು಼ನ್ ಗಿಹ್ಯಾ ಮಿ ನ್ಯಾಯಿತ್ ಹ್ಯಲಾ ಉಬಾಕೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","ತಿಥ ಸಮಜು಼ನ್ ಆಲ್ಯಾಲ ಕ್ಯಾ ಮಂಜೆ ಪೌಲಾನಿ ಬುರ್ಸಿಕಾಮ ಕೆಲ್ಯಾತ ಮನ್ಹುನ್ ಯೆಹುದ್ಯಾಂಚಾನಿ ಸಾಂಗ್ಲ ತ್ಯ ತ್ಯಂಚಾ ಸ್ವತಾಚಾ ಧರ್ಮಶಾಸ್ತಾರಾಲಾ ಸಮ್ಮನ್ ಆಸಲ್ಯಾಲ ಜಾ಼ಲ್ತ. ತ್ಯವ್ಡಸ್ ನವ್ಹ ಹ್ಯಲಾ ತುರುಂಗಾತ್ ವ್ಹವುನಿ ಮರ್ನಾಚಿ ಸಿಕ್ಷಾ ವ್ಹವುನಿ ದಿಯಾ ವ್ಹಯಿ ಮನ್ಹಾಯಾ ಕಸ್ಲಿಸ್ ಚು಼ಕ್ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","ಫನ್ ಯೆಹುದ್ಯಾತ್ಲ ಥೊಡ ತ್ಯಲಾ ಮಾರುನ್ಟಾಕಾಯಾ ವ್ಹಯಿ ಮಂತ್ಯಾಲಿ ಯವಜ಼್ನಾ ಮನಾ ಸಮಾಜ್ಲಿ಼. ಮನ್ಹುನ್ ಮಿ ತುಜಿಪ ಲಾವುನ್ ದಿಲ್ಯಾ. ತ್ಯವ್ಡಸ್‍ ನವ್ಹ. ತ್ಯಚೆ ಆಡ್ವ ಚು಼ಕ್ ವಾವ್‌ತ್ಯಾಲ್ಯಾನಾ ತುಜೆ ಮೊರ‍್ಹ ಆಡ್ವ ವ್ಹವುನ್ ವಾದ್ ಕರಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಪರವಾನ್ಕಿ ದಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","ಸಿಪಾಯಿನಾ ಸಾಂಗಲ್ಯಾ ಶಾರ‍್ಕ ರಾತಿಚಾ ಯಳಾಲಾ ಪೌಲಾಲಾ ಅಂತಿಪತ್ರಿಯಾತ್ ನೆಲ್ಹಾ. ");
INSERT INTO gok_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","ದುಸ್ರೆದಿಸಿ ಪೌಲಾಸಂಗ ಮೊರ‍್ಹ ಜಾ಼ಯಾ ಘೊಡ ಚಾ಼ಲಿವತ್ಯಾಲ್ಯಾನಾ ಸುಡುನ್ ಸೈನಿಕ್ ಮಾಗರ ಪರುತುನ್ ಕೊಟೆತ್ ಆಲ. ");
INSERT INTO gok_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","ಘೊಡ ಚಾ಼ಲಿವತ್ಯಾಲ್ಯಾಂಚಾನಿ ಕೈಸರ‍್ಯಾತ್ ಜಾ಼ವುನ್ ರಾಜ್ಪಾಲಾಲಾ ಪತ್ರ ದಿವುನ್ , ಪೌಲಾಲಾ ತ್ಯಂಚೆ ಮೊರ‍್ಹ ಉಬಾಕೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","ರಾಜ್ಪಾಲಾಲಾ ತ್ಯ ಪತ್ರ ವಾಚ಼್ವುನ್, ಪೌಲಾ ಕುಟ್ಲೆ ಸೀಮೆತ್ಲಾ? ಮನ್ಹುನ್ ಇಚಾರುನ್ ತ್ಯೊ ಕಿಲಿಕ್ಯತ್ಲಾ ಮನ್ಹುನ್ ಸಮಜು಼ನ್; ");
INSERT INTO gok_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","“ತುಜಿವ‍ ಚು಼ಕ್ ವಾವಲ್ಯಾಲ ಅಲ್ಯಾವ, ತುಜ಼ ಐಕ್ತೊ” ಮನ್ಹುನ್ ಸಾಂಗುನ್, ತ್ಯಲಾ ಹೆರೊದಾಚಾ ತುರಂಗಾತ್ ಥಿವುನ್ ರಾಕಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಆಜ್ಞಾದಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","ಪಾಚ಼್ ದಿಸಾ ನಂತರ್, ಮುಖ್ಯಯಾಜಕ್ ಅನನಿಯಾನಿ ಯೆಹುದ್ಯಾಂಚಾ ಥೊಡ್ಯಾ ವಡ್ಲಾನಾ ಆನಿ ತೆರ್ತುಲ್ಲ ಮಂಥ್ಯಾಲ್ಯಾ ವಕಿಲಾಲಾ ಹಾಕ್ಟುನ್ ರಾಜ್ಪಾಲಾಪ ಫಿರ‍್ಯಾತ್ ದಿಯಾ ಸೆಜರೆಯಾ ಪೆಠತ್ ಗೇಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","ಪೌಲಾಲಾ ಸಭೆತ್ ಹಾಕಟ್ಲಾ. ತವಾ ತೆರ್ತುಲ್ಲಾ ತ್ಯಚಿವ ಚು಼ಕಿ ವಾವಾಯಾ ಲಾಗ್ಲಾ: “ಮಹಾ ರಾಜಾ ಪೇಲಿಕ್ಸಾ, ತುಜಿಸ್ ಲಾಗುನ್ ಆಮ್ಚಿ ಲೊಕ ಸಮಾದಾನಾನಿ ಜಿವ್ನಾ ಕರ್ತ್ಯಾತ. ತುಜಾ ಗಿನ್ಯಾನಾನಿ ಆಮ್ಚೆ ದೇಶೆಚಾ ಭರ‍್ಯಾಸಾಟಿ ಚು಼ಕ್‍ಲ್ಯಾಲ ಸಗ್ಳ ಸುದರ್ಲ್ಯಾಸ್. ");
INSERT INTO gok_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","ಆಮಿ ಹಿ ಮಜ಼ತ್ ಪುರಾ ದನ್ಯಾವಾದ್ ಸಗ್‍ಳ್ಯಾ ಯಳಾತ್ ಸಗ್ಳಿಕ್ಡ ಸ್ವಿಕಾರ್ ಕರ್ತಾವ್” ");
INSERT INTO gok_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","ಫನ್ ಮೀ ತುಜಾ಼ ಯೊಳ್ ಆಜು಼ನ್ ಖುಬ್ ಗಿಹ್ಯಾಚೆ ಆಂದಿ, ಥುಡಿಸ್ ಬುಲ್ನಿ ಸಾಂಗ್ತೊ ತ್ಯ ದಯಾ ಥಿವುನ್ ಥಂಡ್ಪನಾನಿ ಐಕ್. ");
INSERT INTO gok_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","ಹ್ಯೊ ಮಾನುಸ್ ಆಮಾನಾ ಪಿಡಾ ಆಸ್‍ಲ್ಯಾಚೆಗತ್ ದಿಸತ್ಯೊ. ಯೆಹುದಿ ದುನೆತ್ ಕುಠಬಿ ರಾಹುಂತ, ತಿಥ ಹ್ಯೊ ಬಾಂಢಾನ್ ಉಠಿವ್ತೊ. ಹ್ಯೊ ‘ನಜ಼ರೆತಿಚಾ’ ಪಂಚಾ಼ಚಾ಼ ಫುಡಾರಿ ಜಾ಼ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","ತ್ಯವ್ಡಸ್ ನವ್ಹ, ಹ್ಯನಿ ದೆವಳಾತ್ ಬುರ್ಸ ಕರಾಯಾ ಯತ್ನ ಕಿಲಿತ, ಫನ್ ಆಮಿ ಹ್ಯಲಾ ಬ್ಯಾಂದ್‍ಲ್ಯಾ. ಆಮಿ ಆಮ್ಚಾ ಸ್ವತಾಚಾ ನೆಮಾಚೆಚೆಗತ್ ತ್ಯಲಾ ನ್ಯಾಯಿ ತಿರ್ಮಾನ್ ಕರಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಯವಜ಼್ಲ ");
INSERT INTO gok_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","ಫನ್ ಸರದಾರ್ ಜಾ಼ಲ್ಯಾಲಾ ಲುಸಿಯಾ ಮದ್ದಿ ಯವುನ್ ಬಳ್‍ಜು಼ರಿನಿ ಆಮ್ಚಾ ಹಾತಾತ್ನಿ ತ್ಯಲಾ ಸುಡ್ವುನ್ ನೆಲ್ಹಾ. ");
INSERT INTO gok_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","ತವಾ ಲುಸಿಯಾನಿ ತ್ಯಚಿವ ಚು಼ಕ್ ವಾವಲ್ಯಾಲ್ಯಾನಾ ಆಜ್ಞೆ ದಿಲೆ. ಆನಿ ತು ಹ್ಯಚಿ ಚೌ಼ಕಸಿ ಕೆಲ್ಯಾವ. ಆಮಿ ಸಾಂಗಲ್ಯಾಲ್ಯಾ ಹ್ಯಾ ಖನ್ಕತಿ ಖರ‍್ಯಾ ಕ್ಯಾ ಖೊಟ್ಯಾ ಮನ್ಹುನ್ ತುಲಾಸ್ ಸಮಾಸ್ತಿಲಾ. ” ");
INSERT INTO gok_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","ಬಾಕಿಚ಼ ಯೆಹುದಿ, “ಹ್ಯಾ ಗುಶ್ಟಿ ಖರ‍್ಯಾ ಹಾತಾ!” ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","ರಾಜ಼್‍ಪಾಲಾನಿ ಪೌಲಾಲಾ ಖುನಾ ಕರುನ್, ಬೊಲಾಯಾ ಸಾಂಗ್ಲ. ತವಾ ಪೌಲ್ ಆಸಾ ಮನ್ಲಾ: “ರಾಜ್‍಼ಪಾಲ್ ಜಾ಼ಲ್ಯಾಲ್ಯಾ ಪೆಲಿಕ್ಸಾ ತು ಖುಬ್ ವರ್ಸಾಠಾವ್ನಿ ಹೆ ದೆಶೆಚಾ಼ ನ್ಯಾಯಿ ತಿರ್ಮಾನ್ ಕರ್ತ್ಯಾಲಾ ಮನಾ ಠಾವ ಹಾ. ಮನ್ಹುನ್ ಸಂತೊಶಾನಿ ತುಜಿ಼ ಮೊರ‍್ಹ ವಾದ್ ಕರ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","ಮಿ ಆರಾದನೆಲಾ ಯೆರುಸಲೆಮಿತ್ ಜಾ಼ವುನ್ ನಿಸ್ತ ಬಾರಾರೊಜ಼್ ಜಾ಼ಲ್ಯಾತ ತ್ಯವ್ಡಸ್. ತ್ಯ ಖರ ಮನ್ಹುನ್ ತುಲಾಸ್ ಸಮಜ಼ಲ್. ");
INSERT INTO gok_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","ಮಿ ದೇವ್ಳಾತ್ ವ್ಹವುನಿ ಸಬಾಸ್ತಾನಾತ್ ವ್ಹವುನಿ ಪೆಠತ್ ವ್ಹವುನಿ ಯಹುದ್ಯಾಂಚಿಸಂಗ ವಾದ್ ಕರ್ತ್ಯಾಲಾ, ನಾಹಿತ ಲೊಕ ಗೊಳಾ ಕರ್ತ್ಯಾಲಾ ಹ್ಯಂಚಾನಿ ಬಗ್ಲಾ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","ಆತಾ ಮಾಜಿವ ವಾವ್‍ತ್ಯಾಲ್ಯಾ ಗುಶ್ಟಿ ಹ್ಯನಾ ತುಜೆ ಮೊರ‍್ಹ ಖರ‍್ಯಾ ಕರಾಯಾ ವ್ಹಯಿತ್ನಾಹಿತಾ. ");
INSERT INTO gok_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","ಫನ್ ಮಿ ತುಲಾ ಹ್ಯ ಖರ ಕರುನ್ದೆತೊ, ಹೆ ಮನಾ ದರ್ಮಾಚಾ಼ ವಾದಿ ಮನ್ಹುನ್ ಸಾಂಗತ್ಯಾಲ್ಯಾ ಮಾರ್ಗಾಚೆ ಮಾಗ್ನಿ ಜಾ಼ತ್ಯಾಲೊ ಮಿ ಆಮ್ಚಾ ವಡ್ಲಾಂಚಾ ದೇವಾಲಾ ಆರಾಧನ್ ಕರ್ತೊ. ಫನ್ ಮೊಶೆಚಾ ಧರ್ಮಶಾಸ್ತಾರಾತ್ ಪ್ರವಾದಿಂಚಾ ಪುಸ್ತಕಾತ್ ಲಿವ್‌ಲ್ಯಾಲ್ಯಾ ಪರತೆಕಾವ ಮಿ ಇಸ್ವಾಸ್ ಥೆವ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","ನಿಯತಿಂಚಾನಾ ಆನಿ ನಿಯತ್ ನಸ್‍ಲ್ಯಾಲ್ಯಾನಾ ಪುನರುತ್ಥಾನ್ ವ್ಹತ ಮಂಥ್ಯಾಲಿ ಆಶಾ ತ್ಯನಾ ಕಸಿ ಹಾ ತೀಸ್ ಆಶಾ ದೆವಾಪ ಮನಾಬಿ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","ಹ್ಯಾ ಕಾರ್ನಾನಿ ಮಿ ಮನಾ ವ್ಹಯಿಲ್‍ತ್ಯವ್ಡ ದೇವಾಚೆ ಮೊರ‍್ಹ ಮಾನ್ಸಾಂಚೆ ಮೊರ‍್ಹ ಶುದ್ ಮನಾನಿ ರಾಹ್ಯಾ ಯತ್ನ ಕರ್ತ್ಯೊ. ");
INSERT INTO gok_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","ಮಿ ಖುಬ್ ವರ್ಸಾನಿ ಯೆರುಸಲೆಮಿತ್ ಆಸ್‍ಲ್ಯಾಲ್ಯಾ ಮಾಜಾ ಲೊಕಾನಾ ದಾನ್ದರ್ಮ ಕರಾಯಾ ಆನಿ ಯಜ್ಞ ದಿಯಾ ಆಲೊ. ");
INSERT INTO gok_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","ಮಿ ಹ್ಯ ಕಾಮ್ ಕರೀತ್ ಅಸ್ಥಾನಾ ಥೊಡ್ಯಾ ಯೆಹುದ್ಯಾಂಚಾನಿ ಮನಾ ದೇವ್ಳಾತ್ ಬಗ್ಲ. ಮಿ ಶುದ್ದಾಚಾರಾಚಾ಼ ನೆಮ್ ಸುಪಿವ್ಲಾ ಹುತಾ. ಮಿ ಕಂದಿಸ್ ಗದ್ಲಾ ಕೆಲಾ ನವ್ಥಾ. ಮಾಜೆ ಸರ್ಬೌರಿ ಕುಟ್ಲಿಸ್ ಲೊಕ ನವ್ಥಿತ. ");
INSERT INTO gok_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","ಫನ್ ಆಶಾತ್ಲ ಥೊಡ ಯೆಹುದಿ ತಿಥ ಹುತ್ತ. ತ್ಯಂಚಾನಿ ಮಾಜಿ ಚು಼ಕ್ ಸಾಂಗಾಯಾ ಯಯಾ ವ್ಹಯಿತ. ");
INSERT INTO gok_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","ಮಿ ಯೆರುಸಲೆಮಿಸ್ ಯೆಹುದ್ಯಾಂಚೆ ನ್ಯಾಯಾಚೆ ಸಬೆತ್ ಉಬಾ ರಾಯ್ಲೊ ತವಾ, ಮಾಜಿಪ ತ್ಯನಾ ಕಚಾ಼ ಅಪ್ವಾದ್ ದಿಸಲ್ಯಾ ಮನ್ಹುನ್ ಹಿತ್ತ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ಹ್ಯಾ ಯೆಹುದ್ಯಾನಾಸ್ ಇಚಾರ್. ");
INSERT INTO gok_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","ಮೀ ತ್ಯಂಚಿ ಮೊರ‍್ಹ ಉಬಾರಾಯ್ಲೊ ತವಾ, ‘ಮೆಲ್ಯಾಲಿ ಪುನರುತ್ಥಾನ್ ವ್ಹತ್ಯಾತ ಮನ್ಹುನ್ ಇಸ್ವಾಸ್ ಥೆವ್ತೊ ಹ್ಯಾಸ್ಲಾಗುನ್ ಆಜ಼್ ಮಿ ಹಿತ್ತ ಉಬಾ ರಾಯಲ್ಯೊ!” ಮನ್ಹುನ್ ಜೊ಼ರಾನಿ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","ಪೇಲಿಕ್ಸಾನಿ ಯೇಸುಚಾ ಮಾರ್ಗಾಚೆ ಗುಶ್ಟಿತ್ ಆಂದಿಸ್ ವ್ಹಯಿತ್ಯವ್ಡ ಸಮ್‌ಜ಼ುನ್ ಗೆತ್ಲ ಹುತ್ತ. ತ್ಯನಿ ಇಚಾರ್ ಕರಾಚಾ಼ ಸುಡುನ್, “ಸರ್ದಾರ್ ಜಾ಼ಲ್ಯಾಲಾ ಲುಸಿಯಾ ಹಿತ್ತ ಯಯಿಲ್ ತವಾ, ಹೆ ಖನ್ಕತಿಚೆ ಗುಶ್ಟಿತ್ ಮಿ ತಿರ್ಮಾನ್ ಕರ್ತೊ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","ಪೌಲಾಲಾ ರಕ್ವಾಲಿತ್ ಥೆವಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಪೇಲಿಕ್ಸಾನಿ ಸಾಂಗ್ಲ. ಫನ್ ಪೌಲಾಲಾ ಥೊಡಾ ಸ್ವತಂತ್ರ ದಿಯಾ ತ್ಯಚಾ ಸೊಪ್‌ತ್ಯಾಂಚಾನಿ ತ್ಯಲಾ ವ್ಹಯಿ ಜಾ಼ಲ್ಯಾಲಿ ಸಾಮ್ನ ಆನುನ್ ದಿಯಾ ಅವ್ಕಾಸ್ ದಿಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಸರ್ದಾರಾನಿ ಅಧಿಕಾರಿಲಾ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","ಥೊಡ ದಿಸ್ ಜಾ಼ಲ್ಯಾವ ಪೇಲಿಕ್ಸಾ ತ್ಯಚಿ ದನ್ಗರ್ ಯೆಹುದಿ ಜಾ಼ಲ್ಯಾಲ್ಯಿ ದ್ರುಸಿಲಾ ಸಂಗ್ನಿ ಆಲಾ. ಪೌಲಾಲಾ ಹಾಕ್ಟಲ. ಕ್ರಿಸ್ತ ಯೆಸುವ ಇಸ್ವಾಸ್ ಥೆವ್‌ಲ್ಯಾಲೆ ಗುಶ್ಟಿತ್ ಪೌಲಾನಿ ಸಾಂಗ್‍ಲ್ಯಾಲ ತ್ಯನಿ ಐಕ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","ಫನ್ ಪೌಲ್ ತಿತ್ನಿ ಜಾ಼ವುನ್ ಚಾ಼ಂಗಲ್ಯಾಚೆ ಗುಶ್ಟಿತ್ ಚರ್ಚಾ ಕರುನ್ ಸ್ವತಾ ಆಪ್‌ಲ್ಯಾ ತಾಬ್ಯಾತ್ ಆನಿ ಮೊರ‍್ಹ ಯತ್ಯಾಲ್ಯಾ ದಿಸಾತ್ ನ್ಯಾಯಿ ತಿರ್ಮಾನಾಚಿ ಗುಶ್ಟಿತ್ ಬೊಲ್ತಾನಾ ಫೆಲಿಕ್ಸ್ ಬಿಹ್ಯಾಲಾ ಆನಿ ಆತ್ತಾ ತು ಜಾ಼ ಮನಾ ಫುರ್ಸತ್ ಗಾವಲ್ ತವಾ ತುಲಾ ಹಾಕಟ್ತೊ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","ಪೌಲಾಪ್ನಿ ಪೈಸ ಗಾವ್ತಿಲ ಮನ್ಹುನ್ ತ್ಯನಿ ಆಶಾ ಕಿಲ್ತಿ, ಮನ್ಹುನ್ ತ್ಯೊ ತ್ಯಲಾ ತ್ಯಾ ಕಾರ್ನಾನಿ ಹಾಕ್ಟುನ್ ಗಿಹುನ್ ತ್ಯಚಿ ಸಂಗ ಬೊಲತಾ. ");
INSERT INTO gok_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","ಫನ್ ದೊನ್ ವರ್ಸಾ ಪರತ್ ಪೇಲಿಕ್ಸಾಚಾ ಜಾ಼ಗ್ಯಾವ ಪುರ್ಕ್ಯಾಫೆಸ್ತ ರಾಜ಼ಪಾಲ್ ಜಾ಼ಲಾ. ಫನ್ ಪೇಲಿಕ್ಸ ಯೆಹುದ್ಯಾನಾ ಬರಾವ್ಹಯಾಸಾಟಿ ಪೌಲಾಲಾ ತುರುಂಗಾತುಸ್ ಸುಡುನ್ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","ಪೆಸ್ತ ರಾಜ್ಪಾಲ ವ್ಹವುನ್ ತೀನ್ ದಿಸ್ ಜಾ಼ಲ್ಯಾವ ಕೈಸರೆಯಾತ್ನಿ ಯೆರುಸಲೆಮಿತ್ ಗೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","ಮುಖ್ಯ ಯಾಜಕ್ ಆನಿ ಪ್ರಮುಕ್ ಯೆಹುದಿ ಜಾಂತ್ಯಾಚಿಪ ಪೆಸ್ತಾಚೆ ಮೊರ‍್ಹ ಪೌಲಾವ ಫಿರ‍್ಯಾತಿ ಕೆಲ್ಯಾ. ತ್ಯವ್ಡಸ್ ನವ್ಹ ಪೌಲಾಲಾ ಯೆರುಸಲೆಮಿತ್ ಪರ್ತುನ್ ಲಾವುನ್ ದಿಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ತ್ಯಂಚಾನಿ ಪೆಸ್ತನಲಾ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","ಕಾ ಮಂಜೆ ತ್ಯಂಚಾನಿ ಪೌಲ್ ಯೆರುಸಲೆಮಿತ್ ಜಾ಼ತ್ಯಾಲೆ ವಾಟವಸ್ ಮಾರುನ್ ಟಾಕಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಯವಜ್ನಾ಼ ಕಿಲ್ತಿ. ");
INSERT INTO gok_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","ಫನ್ ಪೆಸ್ತ್ ಆಸಾ ಮನ್ಲಾ, “ನಾಹಿ! ಪೌಲಾಲಾ ಕೈಸರಿಯಾತುಸ್ ಕ್ಯೊಂಡ್‌ಲ್ಯಾ. ಮೀಸ್ ತಿಥ ಬಿಗಿನಿ ಜಾ಼ಯಾಚೊ಼ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","ತುಮ್ಚಾ ಫುಡಾರ‍್ಯಾತ್ಲ ಥೊಡ ಮಾಜಿ ಸಂಗ ಯವುಂತ. ತ್ಯನಿ ಖರ‍್ಯಾನಿ ಚು಼ಕ್ ಕಿಲಿತ ತ್ಯಚಿವ ಕೈಸರಿಯಾತುಸ್ ತೇ ಚು಼ಕ್ ವಾವುಂತ” ಮನ್ಹುನ್ ಉತ್ತರ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","ಪೆಸ್ತನ್ ಆಜು಼ನ್ ಆಟ್ ಧಾ ದೀಸ್ ಯೇರುಸಲೆಮಿತುಸ್ ಹುತ್ತಾ. ನಂತರ್ ತ್ಯೊ ಕೈಸರಿಯಾತ್ ಮಾಗಾರಾ ಗೆಲಾ. ದುಸ್ರೆದಿಸಿ ಪೆಸ್ತನ್ ನ್ಯಾಯಿ ಕರ್ತ್ಯಾಲ್ಯಾ ಜಾ಼ಗ್ಯಾವ ಬಸ್ಲಾಹುತ್ತಾ ತವಾ ತ್ಯನಿ ಸೈನಿಕಾನಾ ಪೌಲಾಲಾ ಆಪ್ಲೆ ಮೊರ‍್ಹ ಆನಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಆಜ್ಞಾ ದಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","ಯೆರುಸಲೆಮಿತ್ನಿ ಆಲ್ಯಾಲ ಯೆಹುದಿ ತ್ಯಚೆ ಸರ್ಬೌರ್ ಉಬ ರಾಯ್ಲ ತ್ಯಚಿವ ಖುಬ್ ಫಿರ‍್ಯಾತಿ ವಾವ್‌ಲ್ಯಾ. ಫನ್ ತ್ಯಾತ್ಲೆ ಕಚಾಲಾಸ್ ಆದಾರ್ ನವ್ಥಾ. ");
INSERT INTO gok_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","ಫನ್ ಪೌಲಾನಿ ಆಡ್ವಾ ವಾದ್ ಕರೀತ್. “ಮಿ ಯೆಹುದ್ಯಾಂಚಾ ಧರ್ಮಶಾಸ್ತಾರಾಚೆ ಆಡ್ವಾ ದೇವ್ಳಾಚೆ ಆಡ್ವಾ ಚಕ್ರವರ್ತಿ ಸಿಸರಾಲಾ ಆಡ್ವಾ ವ್ಹವುನ್ ಕಚಿಸ್ ಚು಼ಕ್ ಕಿಲಿನಾಹಿ” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","ಫನ್ ಪೆಸ್ತಾನಿ ಯೆಹುದ್ಯಾಂಚಿಪ್ನಿ ಮರ‍್ಯಾದ್ ಗಿಹ್ಯಾಸಾಟಿ ಪೌಲಾಲಾ ತು ಯೆರುಸಲೆಮಿತ್ ಜಾ಼ಯಾ ಯತ್ನ ಕರ್ತಾನಾ ಹೆ ಚು಼ಕಿಚೆ ಗುಶ್ಟಿತ್ ಮಿ ತಿಥಸ್ ತುಲಾ ತಿರ್ಮಾನ್ ಕರಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಮಂಥೊಸ್ ಕ್ಯಾ? ಮನ್ಹುನ್ ಇಚಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","ಪೌಲಾನಿ ಸಾಂಗ್ಲ, “ಆತಾ ಮಿ ಚಕ್ರವರ್ತಿ ಸಿಸರಾಚಾ ನ್ಯಾಯಿ ಕರ್ತ್ಯಾಲ್ಯಾ ಜಾ಼ಗ್ಯಾವ ಉಬಾ ರಾಯ್‍ಲ್ಯೊ. ಮನಾ ತಿರ್ಮಾನ್ ವ್ಹಯಾಚಾ಼ ಹಿತ್ತಸ್! ಮಿ ಯೆಹುದ್ಯಾನಾ ಕಾಯ್ ಅನ್ನೆವ್ ಕೆಲಾ ನಾಹಿ. ಹ್ಯ ತುಮಾನಾ ಚಾ಼ಂಗ್ಲ ಠಾವ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","ಮಿ ಚು಼ಕ್ ಕರ್ತ್ಯಾಲಾ ಜಾ಼ಲ್ಯಾವ ಧರ್ಮಶಾಸ್ತಾರ್ ಮಾನಾ ಮರ್ನಾಚಿ ಸಿಕ್ಷಾ ದಿಲ್ಯಾವಬಿ ಮಿ ತ್ಯೊ ತಿರ್ಪ ಒಪ್ತೊ. ಫನ್ ಹ್ಯಂಚಾ ಚು಼ಕಿ ಖರ‍್ಯಾ ಜಾ಼ಲ್ಯಾವ. ಮನಾ ಹ್ಯಂಚಾ ಹತಾತ್ ದಿಯಾ ಕಚಾಲಾಸ್ ವ್ಹಯಿತ್ನಾಹಿ! ಹ್ಯಾ ಗುಶ್ಟಿ ಕೈಸರುಸ್ ಇಚಾರ್ ಕರುನಿ. ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","ಪೆಸ್ತಾನಿ ಆಪ್ಲೆ ಬರ್ಬರ್ ರಾಥ್ಯಾಲ್ಯಾಂಚೆ ಸಂಗ ಹ್ಯಚಾ ಗುಶ್ಟಿ ಬೊಲ್ಲಾ. ನಂತರ್ ತ್ಯನಿ, “ತುಜೆ ಗುಶ್ಟಿತ್ ಕೈಸರುಸ್ ಬಗುನಿ ಮನ್ಹುನ್ ತು ಇಚಾರ್ಲಸ್ ಮನ್ಹುನ್ ತುಲಾ ಕೈಸರಾಪ ಲಾವುನ್ ದೆತೊ” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","ಥೊಡ ದಿಸ್ ಜಾ಼ಲ್ಯಾವ ಅಗ್ರಿಪ್ ರಾಜಾ಼ ಆನಿ ಬೆರ್ನಿಕ್ ರಾನಿ ಪೆಸ್ತನಾಲಾ ಭೇಟ್ ವ್ಹಯಾ ಆನಿ ನಮಸ್ಕಾರ್ಕರಾಯಾ ಕೈಸರಿಯಾಪ ಆಲಿತ. ");
INSERT INTO gok_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","ತೀ ತಿಥ ಖುಬ್ ದಿಸಾ ಪರತ್ ಹುತ್ತಿತ. ಪೆಸ್ತನಾನಿ ಪೌಲಾಚೆ ಗುಶ್ಟಿತ್ ರಾಜಾಲಾ ಆಸ ಸಾಂಗ್ಲ: “ಫೆಲಿಕ್ಸಾ ತುರುಂಗಾತ್ ಸುಡುನ್ ಗೆಲ್ಯಾಲಾ ಯೊಕ್ ಮಾನುಸ್ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","ಮಿ ಯೆರುಸಲೆಮಿತ್ ಗೆಲೊ ತವಾ ಯೆಹುದಿ ಮುಖ್ಯ ಯಾಜಕ್ ಆನಿ ಜಾಂತ ತ್ಯಲಾ ಆಡ್ವ ವ್ಹವುನ್ ಚು಼ಕಿ ಸಾಂಗ್‌ಲ್ಯಾ. ಮಿ ತ್ಯಲಾ ಮರ್ನಾಚಿ ಸಿಕ್ಷಾ ದಿಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಹ್ಯಾ ಯೆಹುದ್ಯಾಂಚಿ ಆಜ್ಞಾ ಜಾ಼ಲ್ಥಿ. ");
INSERT INTO gok_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","ಫನ್ ಮಿ, ‘ಚು಼ಕ್ ವಾವ್‌ತ್ಯಾಲ್ಯಾ ಮಾನ್ಸಾಚಾ ತಿರ್ಮಾನಾಸಾಟಿ ದುಸ್‌ರ‍್ಯಾನಾ ಒಪ್ಸಾಚ಼ ರೊಮಾಂಚಿ ಪದ್ದತ್ ನವ್ಹ. ಆಂದಿ ವ್ಹವುನ್, ತ್ಯನಿ ಆಪ್ಲಿವ ಚು಼ಕ್ ಸಾಂಗ್‌ತ್ಯಾಲ್ಯಾನಾ ಸಮೊಸಮೊರ್ ಮಿಳುನ್ ತ್ಯಂಚೆ ಚು಼ಕಿಲಾ ಆಡ್ವಾ ವ್ಹವುನ್ ಆಪ್‌ಲ್ಯಾಲಾ ಪ್ರತಿವಾದ್ ಕರಾಯಾ ಅವ್ಕಾಶ್ ದಿಯಾ ವ್ಹಯಿ’ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","“ಮನ್ಹುನ್ ತೆ ಹಿತ್ತ ಆಲತವಾ, ಮಿ ಥಾಂಬಾಚೆಆಂದಿ ದುಸ್ರೆದಿಸಿಸ್ ನ್ಯಾಯಸ್ಥಾನಾವ ಬಸುನ್ ತ್ಯಾ ಮಾನ್ಸಾಲಾ ಆತ್ ಹಾಕ್ಟುನ್ ಆನಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಆಜ್ಞಾ ಕಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","ಯೆಹುದಿ ಉಬ ರಾಹುನ್ ತ್ಯಚೆ ಆಡ್‌ವ್ಯಾ ಚು಼ಕಿ ವಾವ್‌ಲ್ಯಾ. ತರಿ ಮಿ ಯವಜ಼ಲ್ಯಾ ಸಾರ ತ್ಯಂಚಾನಿ ತಚಿವ ಕಚಿ ಬುರ್ಸಿ ಚು಼ಕ್ ವಾವ್ಲಿನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","ತ್ಯಂಚಾನಿ ಸಾಂಗ್‌ಲ್ಯಾಲ್ಯಾ ಖನ್ಕತಿ ತ್ಯಂಚಾ ಸ್ವತಾಚಾ ಧರ್ಮಾಲಾ ಸಂಬಂದ್ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ಆನಿ ಯೇಸು ಮಂಥ್ಯಾಲ್ಯಾ ಮಾನ್ಸಾಚಾ ಜಾ಼ಲ್‍ತ್ಯಾ. ಮರುನ್ ಗೆಲ್ಯಾಲಾ ಯೇಸು ಆತಾ ಜಿತ್ತಾ ವ್ಹವುನ್ ಉಠುನ್ ಆಲ್ಯಾ ಮನ್ಹುನ್ ಪೌಲಾನಿ ಸಾಂಗ್‌ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","ಹೆ ಖನ್ಕತಿಚೆ ಗುಶ್ಟಿತ್ ಮನಾ ಖುಬ್ ಸಮಾಜ಼್ಲ ನಾಹಿ. ಮನ್ಹುನ್ ಮಿ ಪ್ರಶ್ನೆ ಇಚಾರ್ಲ್ಯಾ ನಾಹಿತಾ. ಫನ್ ಮಿ ಪೌಲಾಲಾ ತು ಯೆರುಸಲೆಮಿತ್ ಜಾ಼ವುನ್ ತಿಥಸ್ ನ್ಯಾಯಿತಿರ್ಮಾನ್ ಕರಾಯಾ ವ್ಹಯಿ ಮಂಥೊಸ್ ಕ್ಯಾ? ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","ತ್ಯಲಾ ತ್ಯನಿ, ‘ಚಕ್ರವರ್ತಿ ಕೈಸರಾಪ್ನಿ ಮಾಜ಼ಾ ತಿರ್ಮಾನ್ ವ್ಹವುನಿ. ತಿತ್ಪರ‍್ಯಾತ್ ಮನಾ ತುರುಂಗಾತುಸ್ ಥೆವಾ ಮನ್ಲಾ. ಮನ್ಹುನ್ ರೊಮಾಚಾ ಚಕ್ರವರ್ತಿಪ ಜಾ಼ವುನ್ ಲಾವುನ್ ದಿಯಿ ಪರ‍್ಯಾತ್ ತ್ಯಲಾ ತುರುಂಗಾತ್ ಥೆವಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಆಜ್ಞಾ ಕಿಲಿ. ” ");
INSERT INTO gok_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","ಅಗ್ರಿಪಾನಿ ಪೆಸ್ತಾಲಾ, “ಹ್ಯೊ ಮಾನುಸ್ ಸಾಂಗ್‌ತ್ಯಾಲ ಐಕಾಯಾ ಮನಾ ಮನ್ ಹಾ. ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ಪೆಸ್ತನ್, “ತ್ಯೊ ಸಾಂಗ್‌ತ್ಯಾಲ ತು ಸಕಾಳ್ ಐಕ್!” ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","ದುಸ್ರೆ ದಿಸಿ ಅಗ್ರಿಪ್ ರಾಜಾ಼ ಆನಿ ಬೆರ್ನಿಕ್ ರಾನಿ ವೈಭವಾಚ಼ ಕಪ್ಡ ಗಾಲ್ಹುನ್ ಸೇನಾಧಿಕಾರಿ ಸಂಗ ಆನಿ ಕೈಸರೆಯಾ‍ ಪ್ರಮುಖಾ ಸಂಗ ನ್ಯಾಯಿ ಕರ್ತ್ಯಾಲ್ಯಾತ್ ಆಲ. ಪೌಲಾಲಾ ಆತ್ ಹಾಕ್ಟುನ್ ಯಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಪೆಸ್ತನಾನಿ ಸೈನಿಕಾನಾ ಆಜ್ಞಾ ಕಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","ತವಾ ಪೆಸ್ತನ್ ಆಸಾ ಮನ್ಲಾ, “ರಾಜಾ ಅಗ್ರಿಪಾ, ಆಮ್ಚಿಸಂಗ ಹಿತ್ತ ಆಲ್ಯಾಲ್ಯಾ ಸಗ್‌ಳ್ಯಾ ಲೊಕಾನು, ತುಮಿ ಬಗ್‌ತ್ಯಾಲ್ಯಾ ಹ್ಯಾ ಮಾನ್ಸಾಲಾ ಸಗ್‌ಳ್ಯಾ ಯೆಹುದ್ಯಾಂಚಾನಿ, ಹ್ಯಲಾ ಮರ್ನಾಚಿ ಸಿಕ್ಷಾ ವ್ಹಯಾವ್ಹಯಿ ಮನ್ಹುನ್ ಹಿತಬಿ ಆನಿ ಯೆರುಸಲೆಮಿತ್ಬಿ ಮನಾ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","ಫನ್ ಮಿ ಹ್ಯಚ಼ಾ ಇಚಾರ್ ಕೆಲಾ ತವಾ ಹ್ಯಚಿಪ ಕಚಿ಼ ಚು಼ಕ್ ದಿಸ್ಲಿ ನಾಹಿ. ಕೈಸರಾಪ್ನಿಸ್ ಮಾನಾ ನ್ಯಾಯಿತಿರ್ಮಾನ್ ವ್ಹಯಾ ವ್ಹಯಿ ಆಸಾ ಹ್ಯೊಸ್ ಮನ್ಲಾ ಮನ್ಹುನ್ ತ್ಯಲಾ ರೊಮಾತ್ ಲಾವುನ್ ದಿಯಾ ಮಿ ತಿರ್ಮಾನ್ ಕೆಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","ಫನ್ ಹ್ಯಚೆ ಗುಶ್ಟಿತ್ ಕೈಸರಾಲಾ ಲಿವಾಯಾ ಬ್ಯಾರ್ಕಿ ಚು಼ಕ್ಬಿ ಮನಾ ದಿಸನಾ. ಮನ್ಹುನ್ ಮಿ ಹ್ಯಲಾ ತುಮ್ಚೆ ಸಗ್‌ಳ್ಯಾಂಚೆ ಮೊರ‍್ಹ ಅಗ್ರಿಪ ರಾಜಾಪ ಆನ್‌ಲ್ಯಾ. ಮನ್ಹುನ್ ತುಮಿ ಹ್ಯಲಾ ಪ್ರಶ್ನೆ ಕರುನ್ ಹ್ಯಚೆ ಗುಶ್ಟಿತ್ ಕೈಸರಾಲಾ ಲಿವಾಯಾ ಕಾಯ್ತರಿ ಗೊಸ್ಟ್ ದಿತ್ಯಾಸಾ ಮನ್ಹುನ್ ಆಶಾ ಕರ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","ಮಿ ಯವಜ಼ಲ್ಯಾಚೆಗತ್, ಯಕಾ ಖೈದಿಚೆ ಆಡ್ವಿ ಆಸ್‌ಲ್ಯಾಲಿ ಚು಼ಕ್ ಶಾರ್ಕಿ ಕರಾಚೆ ಆಂದಿ ತ್ಯಲಾ ಸಿಸರಾಪ ಲಾವುನ್ ದಿಯಾಚ಼ ಬರ ನವ್ಹ. ” ");
INSERT INTO gok_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","ತವಾ ಅಗ್ರಿಪ, ಪೌಲಾಲಾ; ತು ಆತಾ ತುಜೆ ಗುಸ್ಟಿತ್ ಬೊಲ್ ಮನ್ಲಾ; ತವಾ ಪೌಲಾನಿ ಹಾತ್ ವರಕರುನ್; ಪ್ರತಿವಾದ್ ಕೆಲಾ; ");
INSERT INTO gok_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","ಅಗ್ರಿಪ ರಾಜಾ ಯೆಹುದ್ಯಾಂಚಾನಿ ಮಾಜಿವ ವಾವಲ್ಯಾಲೆ ಚು಼ಕಿಚೆ ಗುಸ್ಟಿತ್ ತುಜೆ ಮೊರ‍್ಹ ಮಿ ಆತಾ ಬೊಲಚ಼ ಆಲ್ಯಾ ಮನ್ಹುನ್, ಮಿ ಮನಾ ದನ್ಯ ಮನ್ಹುನ್ ಗೆಥೊ. ");
INSERT INTO gok_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","ಕಾ ಮಂಜೆ, ಯೆಹುದ್ಯಾಂಚಿಪ ಆಸ್‌ಲ್ಯಾಲಾ ಸಗ್ಳಾ ಆಚಾರ್ ಆನಿ ಇಚಾರ್, ತುಲಾ ಚಾ಼ಂಗ್ಲ ಠಾವಾ ಹಾ. ಮಾಜಿ ಬುಲಿ ಸಮಾದಾನಾನಿ ಐಕಾಯಾ ವ್ಹಯಿಸ್ ಮನ್ಹುನ್ ಇಂತಿ ಕರ‍್ತೊ. ");
INSERT INTO gok_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","ಮಿ ನ್ಹಾನ್ಪಸ್ನಿ, ಮಾಜೆ ಯೆರುಸಲೆಮಿಚಾ ಸ್ವತಾಚಾ ದೆಶೆಚಾ ಲೊಕಾಂಚಿಸಂಗ ರಾಹುನ್, ತಿಥ ಜೀವ್ನಾ ಕರ್ತ್ಯಾಲ್ಯಾ ಸಗ್‍ಳ್ಯಾ ಯೆಹುದಿನಾ ಮಾಜೆ ಗುಶ್ಟಿತ್ ಚಾ಼ಂಗ್ಲ ಠಾವ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","ಸಾಕ್ಷಿ ಸಾಂಗಾಯಾ ತ್ಯನಾ ಮನ್ ಆಸ್ಲತ ಸಾಂಗಾವ ಮಿ ಆಮ್‍ಚಾ಼ ದರ್ಮ ಶಾರ್ಕಾ ಪಾಳಾಯಾ ಪರಿಸಾಯಾಂಚೆ ಪದತಿಚೆಗತ್ ಚಾ಼ಲಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಆಂದಿ ದರ್ನಿ ತ್ಯನಾ ಠಾವ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","ದೇವಾನಿ ಆಮ್ಚಾ ವಡ್ಲಾನಾ ಕೆಲ್ಯಾಲಾ ವಾಗ್ದಾನಾಚಿ ಮಿ ಆಶಾ ದರ್ಲಿ ಮನ್ಹುನ್ ಆತಾ ನ್ಯಾಯಿ ಇಚಾರಾತ್ ಉಬಾ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","ಆಮ್ಚಿ ಬಾರಾ ಕುಳಾತ್ಲಿ ಲೊಕ ದೀಸ್ ರ‍್ಯಾತ್ ದೇವಾಲಾ ವವ್ಯಾಳಿತ್ ತ್ಯಾ ಸಬ್ದಾಚ಼ ಫಳ್ ಗಿಹ್ಯಾಸಾಟಿ ರ‍್ಯಾಖತ್ಯಾತ ರಾಜಾ ತ್ಯಾಸ್ ಇಸ್ವಾಸಾತ್ ಸಗ್ಳ ಯಹುದಿ ಮನಾ ಆಡ್ವವ್ಹವುನ್ ಚು಼ಕ್ ವಾವ್‍ತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","ದೇವಾನಿ ಮೆಲ್ಯಾಲ್ಯಾನಾ ಆನಿಕ್ ಜಿತ್ತಿ ಉಠಿವತ್ಯಾಲ್ಯಾವ ಇಸ್ವಾಸ್ ಥೆವಾಚಾ಼ ನವ್ಹ ಮನ್ಹುನ್ ತುಮಿ ಯವಜು಼ನ್ ಗೆತಲ್ಯಾಸಾ ಕಾ? ");
INSERT INTO gok_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","ಯಕಾ ಕಾಲಾತ್ ಮಿ ನಜರೇತಿಚಾ ಯೇಸುಚಾ ನಾವಾಚೆ ಆಡ್ವ ಖುಬ್ ಕಾಮ ಕರಾಯಾ ವ್ಹಯಿತ ಮನ್ಹುನ್ ಯವಜ಼್ಲ ಹುತ್ತ. ");
INSERT INTO gok_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","ಯೆರುಸಲೆಮಿತ್ ಇಸ್ವಾಸಿಂಚೆ ಆಡ್ವಿ ಖುಬ್ ಕಾಮ ಕಿಲಿತ. ಹ್ಯಾ ಇಸ್ವಾಸಿತ್ ಖುಬ್ ಜ಼ನಾನಾ ತುರುಂಗಾತ್ ಗಾಲಾಯಾ ಮುಖ್ಯಯಾಜಕಾಂಚಾನಿ ಮನಾ ಅದಿಕಾರ್ ದಿಲಾ. ಯೇಸುಚಾ ಶಿಶಾನಾ ಮ್ಯಾರ್ಲ ತವಾ ಮಿ ತ್ಯನಾ ಅನುಮತಿ ದಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","ಪರ್ತೆಕ್ ಸಬಾಸ್ಥಾನಾತ್ನಿ ಮಿ ತ್ಯನಾ ಸಿಕ್ಷಾದಿಲಿ. ದೆವಾಚೆ ಅಡ್‌ವ್ಯಾ ಚು಼ಕಿಚಾ ಬೊಲ್ಯಾ ತ್ಯಂಚಾ ತೊಂಡಾತ್ನಿ ಯಯಿಸಾರ‍್ಯಾ ಕೆಲ್ಯಾ. ತ್ಯಾ ಇಸ್ವಾಸಿಂಚಿವ ಖುಬ್ ರಾಗ್‌ ಕರುನ್ ತ್ಯನಾ ಸುದುನ್ ನಿಂದಾ ಕರಾಯಾ ದುಸ್ರೆ ದೇಶೆಚೆ ಪೆಠತ್ನಿಬಿ ಗೆಲೊ. ");
INSERT INTO gok_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“ಯಂಗ್ದಾ ದಮಸ್ಕಾ ಪೆಠತ್ ಜಾ಼ಯಾ ಮುಖ್ಯಯಾಜಕಾನಿ ಮನಾ ಹುಕುಮ್ ಆನಿ ಆಜ್ಞೆ ದಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","ಮಿ ದಮಸ್ಕಾಚೆ ವಾಟನಿ ಜಾ಼ಯಿತೊ. ತವಾ ದೊಪ್ಯಾರ್ ಜಾ಼ಲ್ತಿ. ಆಸ್ಥಾ ಆಸ್ಥಾನಾಸ್ ಆಬ್ಳಾತ್ನಿ ಯೊಕ್ ಉಜಿಡ್ ಯವುನ್ ಮಾಜೆ ಬೌತ ಆನಿ ಮಾಜಿಸಂಗ ಜಾ಼ತ್ಯಾಲ್ಯಾಂಚೆ ಬೌತ ಪಗಾಳ್ಳಾ. ");
INSERT INTO gok_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","ಆಮಿ ಸಗ್ಳಿ ಜಿಮ್ನಿವ ಪಡ್ಲಾವ್. ತವಾ ಯೊಕ್ ಸಬ್ದ ಯೆಹುದ್ಯಾಂಚೆ ಬಾಶೆತ್ ಮಾಜಿಸಂಗ ಬೊಲ್‌ತ್ಯಾಲಾ ಐಕ್ವಾಲಾ. ತ್ಯೊ ಸಬ್ದ, ‘ಸೌಲಾ, ಸೌಲಾ, ತು ಮನಾ ಕಾ ತರಾಸ್ ಕರ್ತೊಸ್? ಕಾಟ್ಯಾಚೆ ಕಾಠಿವ ಮ್ಯಾರ್ತಾನಾ ತುಲಾ ಖುಬ್ ತರಾಸ್’ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","ತವಾ “ಮಿ, ‘ಪ್ರಭು, ತು ಕೊನ್?’ ಮನ್ಲೊ. ತವಾ “ಪ್ರಭು, ‘ತು ನಿಂದಾ ಕರ್ತ್ಯಾಲಾ ಯೇಸುಸ್ ಮಿ. ");
INSERT INTO gok_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","ಆತಾ ಉಟ್ ತುಲಾ ಮಾಜಾ಼ ಸೇವಕ್ಬಿ ಸಾಕ್ಷಿಬಿ ಮನ್ಹುನ್ ನಿವ್ಡುನ್ ಗೆತಲ್ಯಾ. ಆತಾ ಮಿ ತುಲಾ ದಿಸಲ್ಯಾಲೆ ಆನಿ ದಿಲ್ಯಾಲ್ಯಾ ದರ್ಶಾನಾಚೆ ಗುಶ್ಟಿತ್ ಲೊಕಾನಾ ಸಾಕ್ಷಿ ವ್ಹವುನ್ ರಾನ್ಹಾರ್. ಹ್ಯಚಿಸಾಟಿಸ್ ಮಿ ತುಲಾ ದಿಸ್‌ಲ್ಯೊ. ");
INSERT INTO gok_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","ತುಜಾ ಇಸ್ರಾಯೆಲ್ ಲೊಕಾಂಚಿಪ್ನಿ ಯೆಹುದಿ ನಸ್‌ಲ್ಯಾಲ್ಯಾ ಲೊಕಾಂಚಿಪ್ನಿ ತುಲಾ ತರಾಸ್ ಯವುನಾಹಿ ಆಸಾ ರ‍್ಯಾಕ್ತೊ. ಮಿ ತುಲಾ ತ್ಯಂಚಿಪ ಲಾವುನ್ ದೆತೊ. ");
INSERT INTO gok_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","ತು ತ್ಯನಾ ಸಗ್‍ಳ್ಯಾನಾ ಖರ ಸಾಂಗುನ್ ತ್ಯನಾ ಆಂದಾರಾತ್ನಿ ಉಜಿಡಾತ್ ಯತ್ಯಾಚೆಗತ್ ಸೈತಾನಾಚಾ ತಾಬ್ಯಾತ್ನಿ ಸುಟುನ್ ದೇವಾಕ್ಡ ಪರಾತ್‌ಲ್ಯಾಚೆಗತ್ ಕರಾಯಾ ವ್ಹಯಿ. ತವಾ ತ್ಯಂಚಿ ಪಾಪ ಮಾಪ್ ಕರ್ನಾರ್. ಮಾಜಿವ ಇಸ್ವಾಸ್ ಥೆವ್‌ಲ್ಯಾಲ್ಯಾಸ್ ಲಾಗುನ್ ದೆವಾನಿ ನಿವ್‍ಡಲ್ಯಾಲ್ಯಾ ಲೊಕಾನಾ ತ್ಯೊ ಸಮಾದಾನ್ ಗಾವ್ನಾರ್’ ಮನ್ಲಾ. ” ");
INSERT INTO gok_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","ತವಾ “ಅಗ್ರಿಪರಾಜಾಲಾ ಸ್ವರ್ಗಾತ್ನಿ ಮನಾ ತ್ಯ ದರ್ಶಾನ್ ಜಾ಼ಲ್ಯಾ ತ್ಯಲಾ ಚು಼ಕಾಚೆ ಆಂದಿ. ");
INSERT INTO gok_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","ದಮಸ್ಕಾಲಾ ನಂತರ್ ಯೇರುಸಲೇಮಿಲಾ ಇಸ್ರಾಯೆಲಾಲಾ ಸಮನ್ನ್ ಆಸಲ್ಯಾ ಯಹುದಿ ನಸಲ್ಯಾಲ್ಯಾ ಲೊಕಾನಾ ತುಮ್‍ಚ಼ ಮನ್ ಪರ್ತಾಯಾ ವ್ಹಯಿ ಆನಿ ತುಮ್‍ಚಾ಼ ಪಾಪಾಚ಼ ಜಿವ್ನಾ ಸುಡುನ್ ದೆವಾಕ್ಡ ಪರ್ತಾಚ಼ ಚಾ಼ಂಗ್ಲ ಕಾಮ್ ಕರಾಯಾ ವ್ಹಯಿಸಾ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","ಮನ್ಹುನ್ ಯೆಹುದ್ಯಾಂಚಾನಿ ಮನಾ ದೇವ್ಳಾತ್ ದರ‍್ಹುನ್ ಮಾರುನ್ಟಾಕಾಯಾ ಯತ್ನ ಕಿಲಿತ. ");
INSERT INTO gok_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","ಫನ್ ದೇವಾನಿ ತ್ಯಾ ದಿಸಾತ್ ಮನಾ ಮಜ಼ತ್ ಕಿಲಿ ಆನಿ ಆಜು಼ನ್ಬಿ ಮಜ಼ತ್ ಕರ್ತ್ಯೊ. ಮನ್ಹುನ್ ಆತಾ ಹಿತ್ತ ಮಿ ಬಗ್‌ಲ್ಯಾಲ್ಯಾ ಖನ್ಕತಿಂಚೆ ಗುಶ್ಟಿತ್ ಲೊಕಾನಾ ಸಗ್‌ಳ್ಯಾ ಸಾಕ್ಷಿ ಸಾಂಗ್‌ತ್ಯೊ. ಮೊಶೆ ಆನಿ ಪ್ರವಾದಿಂಚಾನಿ ಮೊರ‍್ಹ ವ್ಹನಾರ್ ಮನ್ಹುನ್ ಸಾಂಗ್‌ಲ್ಯಾಲ್ಯಾ ಖನ್ಕತಿಸ್ ಸಾಂಗ್ತೊ ನವಿನಿ ಕಾಯ್ ಸಾಂಗಿತ್ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","ಕ್ರಿಸ್ತ ತರಾಸ್ ಗಿಹುನ್ ಮರುನ್, ಮರ್ನಾತ್ನಿ ಆಂದಿಚಾ಼ ವ್ಹವುನ್ ಉಠುನ್ ಯವುನ್, ಯೆಹುದ್ಯಾನಾಬಿ ಯೆಹುದಿ ನಸ್‌ಲ್ಯಾಲ್ಯಾನಾಬಿ ರಕ್ಷೆನೆಚಾ಼ ಉಜಿಡ್ ಆಂತೊ ಮನ್ಹುನ್ ಮೊಶೆನಿ ಆನಿ ಪ್ರವಾದಿಂಚಾನಿ ಸಾಂಗ್‌ಲ್ಯಾ. ” ");
INSERT INTO gok_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","ಪೌಲ್ ಆಪ್ಲಾ ವಾದ್ ಆಪ್ನುಸ್ ಕರ್ತಾನಾ ಪೆಸ್ತ್, “ಪೌಲಾ, ತು ಖುಳಾ ಹಾಸ್! ತುಜಾ ಖುಬ್ ಶಿಕ್ಷೆನಾನಿ ತುಲಾ ಖುಳಾ ಕೆಲ್ಯಾ! ಮನ್ಹುನ್ ಜೊ಼ರಾನಿ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","ಪೌಲಾನಿ, “ಮಹಾರಾಜಾ ಪೆಸ್ತಾ, ಮಿ ಖುಳಾ ನವ್ಹ. ಮಿ ಸಾಂಗ್‌ತ್ಯಾಲ್ಯಾ ಖನ್ಕತಿ ಖರ‍್ಯಾ ಆನಿ ಯೊಗ್ಯ ಜಾ಼ಲ್ಯಾತಾ. ದಿರ‍್ಹಾನಿ ಹ್ಯಾ ಬೊಲ್ಯಾ ಸಾಂಗ್‍ತ್ಯೊ. ");
INSERT INTO gok_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","ಅಗ್ರಿಪರಾಜಾ ಹ್ಯಾ ಖನ್ಕತಿ ತು ಚಾ಼ಂಗಲ್ಯಾ ಸಮಜು಼ನ್ ಗೆತಲ್ಯಾತಾಸ್ ಕಾ ಮಂಜೆ ಮಿ ಖರ‍್ಯಾನಿ ಸಾಂಗ್ತೊ ಹ್ಯಾತ್ಲ ಕಚ಼ಸ್ ದಡವುನ್ ಥೆವಾಯಾ ವ್ಹಯಿತ್ನಾಹಿ ಕಾ ಮಂಜೆ ಹ್ಯ ಯಕಾ ಕೊನ್ಯಾವ ಜಾ಼ಲ್ಯಾಲ ಕಾಮ್ ನವ್ಹ. ");
INSERT INTO gok_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","ಅಗ್ರಿಪರಾಜಾ, ತು ಪ್ರವಾದಿಂಚಿವ ಇಸ್ವಾಸ್ ಥೆವ್ತೊಸ್ ಕ್ಯಾ? ತು ಇಸ್ವಾಸ್ ಥೆವ್ತೊಸ್ ಮನ್ಹುನ್ ಮನಾ ಠಾವ ಹಾ!” ಮನ್ಹುನ್ ಸಾಂಗ್‌ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","ಅಗ್ರಿಪ್ ರಾಜಾ಼ ಪೌಲಾಲಾ, ಮನ್ಲಾ “ತು ಯವ್ಡೆ ಬಿಗಿ ಕ್ರಿಸ್ತಾಕ್ಡ ಮಾಜ಼ ಮನ್ ವಳ್ವಾಯಾ ತುಲಾ ವ್ಹಯಿಲ್ ಮನ್ಹುನ್ ಯವಜ಼ಲ್ಯಾಸ್ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","ತವಾ ಪೌಲ್ ಮನ್ಲಾ, “ಥೊಡಾ ಯೊಳ್ ಖುಬ್ ಯೊಳ್ ಮುಖ್ಯ ನವ್ಹ. ತು ಆನಿ ಹಿತ ಆಸ್‍ಲ್ಯಾಲಾ ಪರತೆಕ್ ಯೊಕ್ ಸಾಕ್‍ಳ್ಯಾಂಚಾನಿ ಬ್ಯಾಂದ್‍ಲ್ಯಾಲ ತ್ಯವ್ಡ ನಕೊ ಬಾಕಿಚಾತ್ ಮಾಜಿಗತುಸ್ ವ್ಹಯಾವ್ಹಯಿ ಮನ್ಹುನ್ ಮಿ ದೇವಾಪ ಮಾಗ್ನ ಕರ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","ಅಗ್ರಿಪ್ ರಾಜಾ಼, ರಾಜಪಾಲ್ ಪೆಸ್ತ, ಬೆರ್ನಿಕೆ ಆನಿ ತ್ಯಂಚಿ ಸಂಗ ಬಸ್‌ಲ್ಯಾಲಿ ಲೊಕ ಸಗ್ಳಿ ಉಟ್ಲಿತ, ");
INSERT INTO gok_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","ಆನಿ ತಿತ್ನಿ ಬಾಹಿರ್ ಜಾ಼ವುನ್. ಯಕಾಮಕಾಸಂಗ ಹ್ಯಾ ಮಾನ್ಸಾಲಾ ಮಾರುನ್ ಟಾಕಾಯಾ ನಾಹಿತ ತುರುಂಗಾತ್ ಗಾಲ್ಹಿಸಿ ಚು಼ಕ್ ಹ್ಯನಿ ಕಾಯ್ ಕಿಲಿನಾಹಿ!” ಮನ್ಹುನ್ ಬುಲ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","ಮಂಗ್ ಅಗ್ರಿಪ್ ರಾಜಾ಼ ಪೆಸ್ತಾಲಾ, ಮನ್ಲಾ “ಹ್ಯೊ ಕೈಸರಾಪ ಜಾ಼ತೊ ಮನ್ಲಾ ನಸ್ತಾತ, ಹ್ಯಲಾ ಸುಡುನ್ ದಿಯಾ ಗಾವ್ಹತಾ” ");
INSERT INTO gok_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","ಆಮ್ಮಿ ಇಟಲಿಯಾಲಾ ವ್ಹಡಿತ್ನಿ ಜಾ಼ಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಥರ್ಲ ತವಾ ಪೌಲಾಲಾ ಆನಿ ಥೊಡ್ಯಾ ಖೈದಿನಾ ಜುಲಿಸ್ ಮಂತ್ಯಲಾ ಶತಾದಿಪತಿ ರಾಖಿತಾ. ಜುಲಿಸ್ ಅಗಸ್ತಸ್ ಸೈನ್ಯಾಚಾ಼ ಯೊಕ್ ಆದಿಕಾರಿ ಜಾ಼ಲ್ಥಾ. ");
INSERT INTO gok_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","ಅಮ್ಮಿ ವ್ಹಡಿತ್ ಚ಼ಡುನ್ ತಿತನಿ ಗೆಲಾವ್. ತಿ ವ್ಹಡಿ ಅದ್ರಮಿತ್ತಿತ್ನಿ ಅಲ್ತಿ ಅನಿ ಆಶಾಚಾ ದುಸರ‍್ಯಾ ದುಸರ‍್ಯಾ ಗಾವಾತ್ನಿ ಜಾ಼ಯಾಲಾ ತಯಾರ ಜಾ಼ಲ. ಅರಿಸ್ತಾರ್ಕ ಅಮ್ಚಿ ಸಂಗ ಹುತ್ತಾ. ತ್ಯೊ ಮಕೆದೊನಿಯಾತ್ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ಥೆಸೆಲೋನಿಕಾತ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","ದುಸ್ರೆ ದಿಸಿ ಆಮಿ ಸಿದೊನ್ ಪೆಠತ್ ಆಲಾವ್. ಜುಲಿಯಸ್ ಪೌಲಾಚೆ ಗುಶ್ಟಿತ್ ದಯಾ ಆಸ್‌ಲ್ಯಾಲಾ ಜಾ಼ಲ್ಥಾ. ಸೊಪ್‌ತ್ಯಾಂಚಿಪ ಜಾ಼ವುನ್ ತ್ಯಂಚಿ ಭೆಟ್ ಗಿಯಾ ತ್ಯನಿ ಪೌಲಾಲಾ ಸ್ವತಂತ್ರ ದಿಲ. ");
INSERT INTO gok_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","ಆಮಿ ಸಿದೊನ್ ಪೆಠತ್ನಿ ಗೆಲಾವ್. ಮೊರ‍್ಹ ವಾರ ಸುಟ್‍ಲ್ಯಾಲ್ಯಾ ಕಾರ್ನಾನಿ ಆಮಿ ಸೈಪ್ರಸ್ ದ್ವಿಪಾಚೆ ದರ ದರನಿ ವ್ಹಡಿತ್ನಿ ಗೆಲಾವ್. ");
INSERT INTO gok_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","ಸಿಲಿಸಿಯಾತ್ಬಿ ಪಾಂಪಿಲಿಯಾತ್ಬಿ ಗಾವಲ್ಯಾಲಾ ಸಮಿಂದೊರಾವ್ನಿ. ಲುಸಿಯಾತ್‍ಲ್ಯಾ ಮುರ ಮಂಥ್ಯಾಲ್ಯಾ ಜಾ಼ಗ್ಯಾವ ಪೊಚ಼್ಲಾವ್. ");
INSERT INTO gok_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","ಅಲೆಕ್ಸಾಂದ್ರಿಯಾತ್ನಿ ಆಲ್ಯಾಲಿ ವ್ಹಡಿ ಮುರಾತ್ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ಶತಾದಿಪತಿನಿ ಬಗ್ಲಿ. ಆತಾ ವ್ಹಡಿ ಇಟಲಿತ್ ಜಾ಼ತೆ. ಮನ್ಹುನ್ ತ್ಯನಿ ಆಮಾನಾ ತ್ಯಾತ್ ಬಸಿವ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","ಆಮಿ ಖುಬ್ ದಿಸ್ ಸಾವ್ಕಾಸ್ ಗೆಲಾವ್. ಜಾ಼ತಾ ಜಾ಼ತಾ ಮೊರ‍್ಹ ವಾರ ಸುಟ್ಲ ಮನ್ಹುನ್ ಆಮಿ ಸ್ನಿಡಾತ್ ಜಾ಼ಯಾಚ಼ ಕಶ್ಟ ಜಾ಼ಲ್ಹ. ಮೊರ‍್ಹ ಜಾ಼ಯಾ ಜಾ಼ಲ್ಹ ನಾಹಿ. ಮನ್ಹುನ್ ಆಮಿ ಕ್ರೆತ ದ್ವಿಪಾಚೆ ಕಡಸ್ನಿ ಸಲಮೊನ್ ಖಡೊಕ್ ವಲ್ಯಾಂಡುನ್ ಮೊರ‍್ಹ ಗೆಲಾವ್. ");
INSERT INTO gok_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","ಹಿತ್ನಿ ಮೊರ‍್ಹ ಆಮ್ಚಿ ವ್ಹಡಿ ಕ್ರೆತ್ ಗುಢ್ಯಾಚೆ ದರನಿ ಮೊಟೆ ಆಡಚ಼ನಿತ್ನಿ ಸುರಕ್ಷಿತ್ ಬಾಂದರಾತ್ ಪೊಚ಼ಲಾವ್. ಲುಸಿಯಾ ಪ್ಯಾಟ್ ತ್ಯಚೆ ಜ಼ವಳುಸ್ ಹುತ್ತಿ. ");
INSERT INTO gok_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","ಫನ್ ಆಮ್‍ಚಾ಼ ಖುಬ್ ಯೊಳ್ ವ್ಹಯಾ ಗೆಲಾ. ಆತಾ ಮೊರ‍್ಹ ಜಾ಼ಯಾಚ಼ ಖುಬ್ ಆವ್ಗಡ್ ಜಾ಼ಲ್ತ. ಕಾಮಂಜೆ ಯೆಹುದ್ಯಾಂಚಾ಼ ಉಪಾಸಾಚ಼ ದಿಸ್ ತವಾಸ್ ಸೊಪ್ಲಾಹುತ್ತ. ");
INSERT INTO gok_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","ಮನ್ಹುನ್ ಪೌಲಾನಿ ತ್ಯನಾ, “ಲೊಕಾನು, ಆಮಿ ಜಾ಼ತಾನಾ ಖುಬ್ ತರಾಸ್ ಹಾ ಆಸ ಮನಾ ದಿಸತ್ಯಾ. ವ್ಹಡಿ ಆನಿ ತ್ಯಾತ್ ಆಸ್‌ಲ್ಯಾಲಾ ಮ್ಹಾಲ್ ನಾಸ್ ವ್ಹನಾರ್. ಆಮಚಾ಼ ಜಿವ್ ಸಾಹಿತ್ ನಾಸ್ ವ್ಹನಾರ್!” ಮನ್ಹುನ್ ಶಾನತ್ ದಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","ಪೌಲಾಚಾ ಸಬ್ದಾನಾ ಕಾನ್ ದಿಲಾ ನಾಹಿ ಫನ್ ವ್ಹಡಿ ಚಾ಼ಲಿವತ್ಯಾಲ್ಯಾಚಾ ಆನಿ ವ್ಹಡಿಚಾ ದನ್ಯಾಚಾ ಸಬ್ದಾಂಚಿವ ಧ್ಯಾನ್ ದಿಲ. ");
INSERT INTO gok_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","ಫನ್ ಸುರಕ್ಷಿತ್ ಬಂದರ್ ಥಂಡಿಚಾ ದಿಸಾತ್ ವ್ಹಡಿ ಉಬಿ ರಾಹ್ಯಾ ಚಾ಼ಂಗ್ಲಾ ಜಾ಼ಗಾ ಜಾ಼ಲ್ಹಾ ನವ್ಥಾ. ಮನ್ಹುನ್ ವ್ಹಡಿ ತಿತ್ನಿ ಜಾ಼ಯಾಲಾಸ್ ವ್ಹಯಿ ಮನ್ಹುನ್ ಖುಬ್ ಜ಼ನಾಂಚಾನಿ. ಥಂಡಿಚ಼ ದಿಸ್ ಗಾಲ್ವಾಯಾ ಪೆನಿಕ್ಸಾತ್ ಪೊಚಾ಼ಯಾ ಬಗಿತಿತ. ಹ್ಯ ಬಂದರ್ ಕ್ರೆತಾ ದ್ವಿಪಾತ್ ಹುತ ಹ್ಯಚ಼ ತ್ವಾಂಡ್ ವ್ಹಡಿ ಚಾ಼ಲವಾಯಾ ಚ಼ಾಂಗ್ಲ ವಾರ ಸುಟ್ಯಾಲ್ಯಾ ದಿಕಾಕ್ಡ ಹುತ್ತ. ");
INSERT INTO gok_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","ಮಂಗ್ ಲೊಕ ಜಾ಼ಯಾ ವ್ಹಯಿ ಮನ್ಹಿತಿತ ತ್ಯಾ ದಿಕಾನಿ ಚಾ಼ಂಗ್ಲ ವಾರ ಸುಟಾಯಾ ಲಾಗ್ಲ. ವ್ಹಡಿತ್ ಆಸ್‌ಲ್ಯಾಲಿ ಲೊಕ, “ಆಮಾನಾ ವ್ಹಯಿ ಆಸ್‍ಲ್ಯಾಲ ವಾರ ಹ್ಯಸ್!” ಮನ್ಹುನ್ ತ್ಯಂಚಾನಿ ವ್ಹಡಿ ಬ್ಯಾಂದ್‍ಲ್ಯಾಲಿ ಗುಕಿ ಸುಡುನ್ ಉಚ಼್ಲುನ್ ಗಿತ್ಲಿ. ಆನಿ ಕ್ರೇತ್ ದ್ವಿಪಾಚೆ ಜ಼ವ ಜ಼ವಳ್ನಿ ಗಿಲಿತ. ");
INSERT INTO gok_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","ಫನ್ ದಿಸ್ ಉಗಾವ್‍ತ್ಯಾಲೆ ಡಾವ್ಯಾಂಗ್ಚೆ ಬಾಜೊ಼ಕ್ನಿ ಮುಟಿ ವಾರಮ್ಯೊಡ್ ಆಲಿ. ");
INSERT INTO gok_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","ಆನಿ ತಿ ಆಮ್ಚೆ ವ್ಹಡಿಲಾ ಆದಾಳ್ಳಿ. ತವಾ ವ್ಹಡಿಲಾ ಮೊರ‍್ಹ ಜಾ಼ಯಾ ಜಾ಼ಲ್ಹ ನಾಹಿ. ಮನ್ಹುನ್ ವಾರ ಸುಟಲ್ ತಿಕ್ಡ ಜಾ಼ಯಾ ಸುಡುನ್ದಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","ಆಮಿ ‘ಕಾವ್ದ’ ಮಂಥ್ಯಾಲ ಬಾರಿಕ್ ದ್ವಿಪಾಚೆ ಕಡಸ್ನಿ ಗೆಲಾವ್. ತವಾ ಆಮಿ ವ್ಹಡಿತ್ ಆಸ್‌ಲ್ಯಾಲಿ ಬಾರಿಕ್ ವ್ಹಡಿ ಆತ್ ಗಿಹ್ಯಾಲಾ ಜಾ಼ಲ್ಹ. ಫನ್ ತ್ಯ ಕಾಮ್ ಖುಬ್ ತರಾಸಾಚ಼ ಹುತ್ತ. ");
INSERT INTO gok_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","ನಂತರ್ ವ್ಹಡಿ ಫುಟು ನಾಹಿ ಆಸ ವ್ಹಡಿಲಾ ಸರ್ಬೌರಿ ದೊರ‍್ಯಾಂಚಾನಿ ಬ್ಯಾಂದ್ಲಿ. ಮಂಗ್ ‘ಸುರ್ತಿಸ್’ ಮಂಥ್ಯಾಲ್ಯಾ ರಿತಿಚಾ ಸಪೈ ಜಾ಼ಗ್ಯಾತ್ ಗಾವಲ್ ಮನ್ಹುನ್ ಬಿಹುನ್. ತ್ಯಂಚಾನಿ ಹಾಯಿ ಉತರುನ್ ವ್ಹಡಿ ವಾರ‍್ಯಾನಿ ಮೊರ‍್ಹ ಜಾ಼ಯಾ ಅವ್ಕಾಸ್ ಕೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","ದುಸ್ರೆ ದಿಸಿ ವಾರಮ್ಯೊಡ್ ಜೊ಼ರಾನಿ ಸುಟ್ಲಿ ಮನ್ಹುನ್ ಲೊಕಾಂಚಾನಿ ವ್ಹಡಿತ್ ಆಸ್‌ಲ್ಯಾಲಿ ಥುಡಿ ಸಾಮ್ನ ಬಾಹಿರ್ ಟ್ಯಾಕ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","ತ್ಯಚೆ ದಿಸ್ರೆದಿಸಿ ವ್ಹಡಿಚಿ ಥುಡಿ ಸಾಮ್ನ ಆಪ್‌ಲ್ಯಾ ಹಾತಾನಿ ವ್ಹಲ್ಪಟುನ್ ದಿಲಿತ. ");
INSERT INTO gok_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","ಖುಬ್ ದಿಸಾ ಪರ‍್ಯಾತ್ ಆಮಿ ದಿಸ್ ಆನಿ ಚಾನ್ಯಾನಾ ಬಗ್ಲ ನಾಹಿ. ವಾರ ಜೊ಼ರ್ ಜ಼ಾಲ್ಥ. ಆಮಿ ಜಿತ್ತಿ ರಾಥ್ಯಾವ್ ಮನ್ಯಾಚಿ ಆಶಾ ತ್ಯನಾ ನವ್ಥಿ. ");
INSERT INTO gok_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","ತ್ಯಾ ಲೊಕಾಂಚಾನಿ ಖುಬ್ ದಿಸಾಪರತ್ ಖಾಲನವ್ಥ. ತವಾ ಯೆಕಸಿ ಪೌಲ್ ವರ್ ಉಠುನ್, “ಲೊಕಾನು, ಕ್ರೇತ ದ್ವಿಪಾತ್ನಿ ಜಾ಼ವುನಕೊಸಾ ಮನ್ಹುನ್ ಮಿ ತುಮಾನಾ ಸಾಂಗ್ಲ ಹುತ್ತ. ತುಮಿ ಮಾಜ಼ ಐಕ್ಲ ಆಸ್ತಸಾತ. ಆತಾ ಯವ್ಡಾ ತರಾಸ್ ಆನಿ ಲುಕ್ಷಾನ್ ವ್ಹಯಿತ್ನವ್ಥಿ. ");
INSERT INTO gok_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","ಆತಾ ತರಿ ತುಮಿ ದಿರ‍್ಹಾನಿ ರಾವ್ಹಾ ಮನ್ಹುನ್ ಮಿ ತುಮಾನಾ ಸಾಂಗ್‌ತ್ಯೊ. ತುಮ್ಚಾತ್ಲಾ ಯೊಕ್ಬಿ ಮರ‍್ನಾರ‍್ನಾಹಿ! ಫನ್ ವ್ಹಡಿ ನಾಸ್ ವ್ಹನಾರ್. ");
INSERT INTO gok_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","ಕ್ಯಾಲ್ಚೆ ರಾತಿ ಮಿ ಸೆವಾ ಕರತ್ಯಾಲ್ಯಾ ಆನಿ ಮನಾ ಸಮಂದ್ ಆಸ್‍ಲ್ಯಾಲಾ ದೇವಾಚಾ಼ ದುತ್ ಮಾಜೆ ಜ಼ವಳ್ ಉಬಾ ಹುತಾ. ತ್ಯಾಸ್ ದೇವಾಲಾ ಮಿ ಆರಾದನ್ ಕರ್ತೊ ಮಿ ತ್ಯಚಾ಼ಸ್ ");
INSERT INTO gok_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","ದೇವಾಚಾ಼ ದುತ್, ಪೌಲಾ ಬಿವುನಕೊಸ್‍! ತು ಸಿಸರಾಚೆ ಮೊರ್ಹ ಉಬಾ ರಾಹ್ಯಾವ್ಹಯಿಸ್. ತುಜೆ ಸಂಗ ವ್ಹಡಿತ್ ಆಸಲ್ಯಾಲಿ ಸಗ್ಳಿ ಲೊಕ ತುಜಿವ್ಲೆ ದಯೆನಿ ಜಿತ್ತಿ ರಾಹ್ಯಾವ್ಹಯಿತ ಮನ್ಹುನ್ ದೇವಾನಿ ಮನಾ ಸಾಂಗಲ್ಯಾ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","ತ್ಯಚಿಸಾಟಿ ಲೊಕಾನು ದಿರ‍್ಹಾನಿ ರಾವ್ಹಾ! ಮಿ ದೇವಾವ ಇಸ್ವಾಸ್ ಥೆವ್‍ಲ್ಯಾಲ್ಯಾ ದೆವಾನಿ ಸಾಂಗ್‍ಲ್ಯಾ ಶಾರ್ಕ ಸಗ್ಳ ವ್ಹಯಿಲ್. ");
INSERT INTO gok_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","ಫನ್ ಆಮಿ ಯಕಾ ದ್ವಿಪಾಚೆ ದರವ ಜಾ಼ವುನ್ ಪೊಚಾ಼ಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","ಚೌ಼ದಾವ್ಯಾ ದಿಸಾಚೆ ರಾತಿಲಾ ಜಿಮ್ನಿಚೆ ಮದ್ದಿ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ಸಮಿಂದೊರಾತ್ನಿ ಮೊರ‍್ಹ ಜಾ಼ತಾನಾ. ಆಮಿ ದರಚೆ ಜ಼ವಳ್ ಆಲ್ಯಾವ್ ಮನ್ಹುನ್ ವ್ಹಡಿ ಚಾ಼ಲಿವತ್ಯಾಲ್ಯಾನಾ ಸಮಾಜ಼್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","ತ್ಯಚಾಂನಿ ಮ್ಯಾಪ್‍ತ್ಯಾಲಾ ವಳಂಬಾ ದುರಿಲಾ ಬಾಂದುನ್ ಪಾನ್ಯಾತ್ ಶೊಡ್ಲಾ. ಪಾನಿ ಖಾಲ್ ಚಾಳಿಸ್ ಮಿಟರ್ ಖೊಲ್ ಹುತ್ತ. ತ್ಯಂಚಾನಿ ಅನಿ ಥೊಡ ಮೊರ‍್ಹ ಜಾ಼ವುನ್ ವಳಂಬಾ ಪಾನ್ಯಾತ್ ಶೊಡ್ಲಾ. ತಿತ್ತ ಪಾನಿ ತಿಸ್ ಮಿಟರ್ ಹುತ್ತ. ");
INSERT INTO gok_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","ವ್ಹಡಿ ದುಂಢಿಂಚಿವ ಆದ್ಳಲ್ ಮನ್ಹುನ್ ವ್ಹಡಿ ಚಾ಼ಲಿವತ್ಯಾಲ ಬಿಹುನ್ ಚಾರ್ ಗುಕಿ ವ್ಹಡಿಚೆ ಮಾಗ್ನಿ ಟಾಕುನ್. ದಿಸ್ ಉಗ್ವಾಯಾ ಹಾತ್ ಜು಼ಡಿತ್ ಹುತ್ತಿತ. ");
INSERT INTO gok_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","ಯಂಗ್ದಾ ತೆ ವ್ಹಡಿತ್ನಿ ಚು಼ಕ್ವುನ್ ಜಾ಼ಯಾ ಸಾಟಿ ಚಾ಼ಲಿವತ್ಯಾಲ್ಯಾಂಚಾನಿ ಯತ್ನ ಕಿಲಿತ ತ್ಯಂಚಾನಿ ಹ್ಯಾ ಬಾರಿಕ್ ವ್ಹಡ್ಯಾ ಗಿಹುನ್ ವ್ಹಡಿ ಮೊರ‍್ಹ ಗುಕಿ ಟ್ಯಾಕ್‍ತ್ಯಾಸಾರಿ ಕರುನ್ ದ್ಯಾವ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","ಫನ್ ಪೌಲಾಲಾನಿ ಸೇನಾಧಿಕಾರಿಲಾ ಆನಿ ಸೈನಿಕಾನಾ, ಹೆ ವ್ಹಡಿ ಚ಼ಾಲಿವತ್ಯಾಲ ನಸ್ತಾನಾ ತುಮ್‍ಚಾ಼ ಜಿವ್ ತುಮಾನಾ ರಾಖಾಯಾ ವ್ಹಯಿತ್ನಾಹಿ ಮನ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","ಮನ್ಹುನ್ ತ್ಯಚೆಸಾಟಿ ಸೈನಿಕಾನಿ ದುರಿ ಕಾಪುನ್ ವ್ಹಡಿಲಾ ಪಾನ್ಯಾತ್ ಶುಡ್ಲಿ. ");
INSERT INTO gok_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","ಆನಿ ದಿಸ್ ಉಗಾವ್ತಾನಾ ಕಾಯತರಿ ಖಾಯಾ ವ್ಹಯಿಸಾ ಮನ್ಹುನ್ ಪೌಲಾನಿ ತ್ಯನಾ ಬಳ್ ಕೆಲ, ಗೆಲ್ಯಾಲ್ಯಾ ಚೌ಼ದಾ ದಿಸಾದರ‍್ನಿ ತುಮಿ ಕಾಯ್ ಖಾಲನಾಹಿಸಾ. ");
INSERT INTO gok_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","ಆತಾ ತುಮಿ ಥೊಡ ತರಿ ಖಾಯಾ ವ್ಹಯಿಸಾ ಮನ್ಹುನ್ ಮಿ ತುಮಾನಾ ಸಾಂಗ್ತೊ. ತುಮಿ ಜಿತ್ತಿ ರಾಯಾ ತುಮಾನಾ ಜೇವ್ನಾಚಿ ಗರಜ಼್ ಹಾ. ತುಮ್ಚಿಪ ಆಸ್‍ಲ್ಯಾಲ್ಯಾ ಕುನಾಚೆ ಡುಯಿಚಾ಼ ಯೊಕ್ ಕ್ಯೊಸ್ ಸಾಹಿತ್ ಸಾಂಡನಾರ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","ಆಸ ಸಾಂಗ್‍ಲ್ಯಾ ನಂತರ್, ಪೌಲಾನಿ ನಖಾಡಿ ಬಾಕರಿ ಗಿವುನ್ ತ್ಯಚಿಸಾಟಿ ಸಂಗ್‍ಳ್ಯಾಂಚೆ ಮೊರ‍್ಹ ದೇವಾಲಾ ದನ್ಯವಾದ್ ಸಾಂಗುನ್. ತ್ಯನಿ ಯೊಕ್ ತುಕಡಾ ಮುಡುನ್ ಖಾಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","ತವಾ ಸಗ್‍ಳ್ಯಾಂಚಾನಿ ಧಿರ್ ಕರುನ್ ಜೆವಾನ್ ಖಾಲ. ");
INSERT INTO gok_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","ತೆ ವ್ಹಡಿತ್ ದೊನ್ಸೆ ಸತರಾವ ಸಾ ಲೊಕ ಹುತಾವ್. ");
INSERT INTO gok_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","ಆಮಿ ಪ್ವಾಟ್ ಬರಸ್ಪರತ್ ಖಾಲ. ಆನಿ ಉರ್‌ಲ್ಯಾಲಿ ಪ್ಯಡ್ಗಿ ಸಮಿಂದೊರಾತ್ ಟಾಕುನ್ ವ್ಹಡಿಲಾ ವಜ಼ ಕಮಿ ಕೆಲ. ");
INSERT INTO gok_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","ಉಜಾ಼ಡ್ಲ ತವಾ ವ್ಹಡಿ ಚಾ಼ಲಿವತ್ಯಾಲ್ಯಾನಾ ದೆಶೆಚಾ಼ ಜಾ಼ಗಾ ದಿಸ್ಲಾ. ಖರ ತ್ಯೊ ಕಸ್ಲಾ ಜಾ಼ಗಾ ಮನ್ಹುನ್ ವಳಾಕ್ಲಾ ನಾಹಿ. ತ್ಯಂಚಾನಿ ಬಗ್‌ಲ್ಯಾಲಿ ರಿತಿಚಿ ದರ್ ಆಸ್‌ಲ್ಯಾಲಿ ಯಾಕ್ ತಳ ಜಾ಼ಲ್ತ. ವ್ಹಡಿ ತಿಥ ನಿಹ್ಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ತ್ಯಂಚಾನಿ ಯವಜ಼್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","ಮನ್ಹುನ್ ತ್ಯಂಚಾನಿ ಗುಕಿ ತುಡುನ್ ಸಮಿಂದೊರಾತ್ ಟ್ಯಾಕ್ಲಿತ ಆನಿ ತವಾಸ್ ದಿಕ್ ಚು಼ಕಿವತ್ಯಾಲ್ಯಾ ದೊರ‍್ಯಾ ಶೊಡ್‍ಲ್ಯಾ. ವ್ಹಡಿ ಮೊರ‍್ಹ ಜಾ಼ಯಾ ಕಪಡ್ಯಾಚಾ಼ ಪಟಾ ಬ್ಯಾಂದ್‍ತ್ಯಾತ. ಆನಿ ಆಮಿ ದರಕ್ಡ ಯಯಾ ಲಾಗ್ಲಾವ್. ");
INSERT INTO gok_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","ಫನ್ ವ್ಹಡಿ ರಿತಿಚಾ ಟೆಂಬ್ಯಾವ ಅಪಾಟ್ಲಿ. ವ್ಹಡಿಚಾ಼ ಮೊರ್ಲಾ ಭಾಗ್ ತ್ಯಾತ್ ಆಡಾಕ್ಲಾ ಹುತ್ತಾ. ವ್ಹಡಿ ಚಾ಼ಲ್ವಾಯಾ ಜಾ಼ಲ್ಹಿ ನಾಹಿ. ನಂತರ್ ಮೊಟ್ಯಾ ಲಾಟಾ ವ್ಹಡಿಚೆ ಮಾಗ ಅಪ್ಟುನ್ ತುಕ್ಡ ತುಕ್ಡ ಕರಾಯಾ ಲಾಗ್‌ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","ಚ಼್ವಾರ್ ಪವುನ್ ಜಾ಼ವುನ್ ಚು಼ಕುನಾಹಿತ ಮನ್ಹುನ್ ಸೈನಿಕಾಂಚಾನಿ ಚೊ಼ರಾನಾ ಮಾರುನ್ ಟಾಕಾಯಾ ನಿರ್ದಾರ್ ಕೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","ಫನ್ ಸೇನಾಧಿಕಾರಿನಿ ಪೌಲಾಲಾ ಉರ್ವಾಯಾಸಾಟಿ ಚೊ಼ರಾನಾ ಮಾರುನ್ಟಾಕಾಯಾ ಸೈನಿಕಾನಾ ಹುಕುಮ್ ದಿಲಾ ನಾಹಿ, ಖರ ಆಸಾ ಹುಕುಮ್ ದಿಲಾ, ಪವಾಯಾ ಯತ್ಯಾಲ ಪವುನ್ ದರವ ಜಾ಼ವುಂತ, ");
INSERT INTO gok_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","ಬಾಕಿಚಿ ಫಳ್ಯಾ ನಾಹಿತ ವ್ಹಡಿಚಾ ಲಾಕಡಾಂಚಾ ತುಕ್‍ಡ್ಯಾಂಚಾ ಆದಾರಾನಿ ಜಾ಼ವಾ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ಆಸಿ ಆಮಿ ಸಗಳ್ಯಾಂಚಾನಿ ಜಿಮಿನ್ ಗ್ಯಾಟ್ಲಿ ತ್ಯಾತ್ಲ ಯಾಕ್ಬಿ ಮೆಲನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","ಆಮಿ ಸಂಬಾಳುನ್ ದರವ ಗೆಲಾವ್ ತ್ಯ ಮಾಲ್ಟ ದ್ವಿಪ್‍ ಮನ್ಹುನ್ ಆಮಾನಾ ಸಮಾಜ಼್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","ತವಾ ಪಾವುಸ್ ವತತಾ ಆನಿ ಖುಬ್ ಥಂಡ್ ಹುತ್ತಿ. ಫನ್ ತಿತಲ್ಯಾ ಲೊಕಾಂಚಾನಿ ಆಮ್ಚಿ ಮಾಯಾ ಕರುನ್ ಆಮ್ಚಿಸಾಟಿ ಆಕ್ಟಿ ಪಿಟ್ವುನ್ ಆಮಾನಾ ತಾಪಾಯಾಸಾಟಿ ಸ್ವಾಗತ್ ಕೆಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","ಪೌಲಾನಿ ಯೊಕ್ ಬಾರ‍್ಹಾ ಲಾಕ್ಡ ಗೊಳಾ ಕರುನ್ ಇಸ್‌ಥ್ಯಾತ್ ಗ್ಯಾಲ್ತಾನಾ ತ್ಯಚೆ ಉಬನಿ ಸಾಪ್ ಯೊಕ್ ಬಾಹಿರ್ ಯವುನ್ ತ್ಯಚಾ ಹಾತಾಲಾ ಯಡಾ ಗ್ಯಾತ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","ಪೌಲಾಚಾ ಹಾತಾತಾ ಯಡಾ ಗ್ಯಾತ್‌ಲ್ಯಾಲ್ಯಾ ತ್ಯಾ ಸಾಪಾಲಾ ತಿತಲ್ಯಾ ಲೊಕಾಂಚಾನಿ ಬಗುನ್ ಹ್ಯೊ ಖುನ್ಸಿಸ್ ಆಸಲ್! ಸಮಿಂದೊರಾತ್ನಿ ಹ್ಯೊ ವಾಚ಼್ಲಾ ಖರ ತ್ಯಚಾ಼ ನ್ಯಾಯಿ ನಿವಡತ್ಯಾಲ್ಯಾನಿ ಶೊಡ್ಲಾನಾಹಿ” ಆಸಿ ಯಕಾಮಕಾ ಸಂಗ ಬುಲ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","ಫನ್ ಪೌಲಾನಿ ತ್ಯಾ ಸಾಪಾಲಾ ಇಸ್‌ಥ್ಯಾತ್ ಝಾಡ್ಲಾ. ಪೌಲಾಲಾ ಕಾಯೆಕ್ ಜಾ಼ಲ್ಹ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","ಪೌಲಾಚ಼ ಆಂಗ್ ಸುಜು಼ನ್ ಮರರ್ನಾರ್ ಮನ್ಹುನ್ ತಿ ಸಮಜು಼ನ್ ಗೆಥ್ಯಾತ. ತ್ಯಲಾಸ್ ಖುಬ್ ಯಳಾ ಪರತ್ ಜ಼ಪುನ್ ಬಗಿತಿತ ಫನ್ ಪೌಲಾಲಾ ಕಾಯೆಕ್ ಜಾ಼ಲ್ಹ ನಾಹಿ ಮನ್ಹುನ್ ತ್ಯಂಚಾನಿ ಮನ ಪರತ್ಲಿತ ಹ್ಯೊ ಯೊಕ್ ದೇವುಸ್ ಮನ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","ತ್ಯಾ ಜಾ಼ಗ್ಯಾವ ಸರ್ಬೌತಿ ಸೆತ ಹುತ್ತಿತ. ತೀ ಸೆತ ತ್ಯಾ ದ್ವಿಪಾಚಾ ಮುಖ್ಯ ಅದಿಕಾರ‍್ಯಾತ್‍ಲ್ಯಾ ಯಕಾಚಿ ಜಾ಼ಲ್ಥಿತ ತ್ಯಚ಼ ನಾವ್ ಪೊಪ್ಲಿಯ. ತ್ಯನಿ ಆಮ್ಚಿ ಮಾಯಾ ಕರುನ್ ಆಪ್‍ಲ್ಯಾ ಗರ‍್ಹಾತ್ ಸ್ವಾಗತ್ ಕೆಲಾ. ಆಮಿ ತ್ಯಚಾ ಗರ‍್ಹಾತ್ ತೀನ್ ದೀಸ್ ಹುತಾವ್. ");
INSERT INTO gok_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","ಪೊಪ್ಲಿನಾಚಾ ಬಾಲಾ ಖುಬ್ ಬರ ನವ್ಥ. ತ್ಯಲಾ ತಾಪ್ ಬರ್ಲಾ ಹುತ್ತಾ ಆನಿ ರಗಾತ್ ಹಾಗತಾ. ಪೌಲ್ ತಿಥ ಜಾ಼ವುನ್ ತ್ಯಚಿವ ಆಪ್ಲ ಹಾತ್ ಥಿವುನ್ ಮಾಗ್ನ ಕರುನ್ ಬರಾ ಕೇಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","ಹ್ಯ ಜಾ಼ಲ್ಯಾವ ದ್ವಿಪಾತ್ ಆಸ್‌ಲ್ಯಾಲಿ ಖುಬ್ ರೊಗಿ ಪೌಲಾಪ ಆಲ. ಪೌಲಾನಿ ತ್ಯನಾ ಸಾಹಿತ್ ಬರ ಕೆಲ. ");
INSERT INTO gok_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","ತಿತಲ್ಯಾಂಚಾನಿ ಅಮಾನಾ ಖುಬ್ ಸನ್ಮಾನ್ ಕೆಲಾ. ಆಮಿ ತಿತ್ನಿ ಜಾ಼ಯಾಲಾ ತಯಾರ್ ವ್ಹತಾನಾ ತ್ಯಂಚಾನಿ ಆಮಾನಾ ವ್ಹಯಿ ಜಾ಼ಲ್ಯಾಲಿ ಸಾಮ್ನ ದಿಲಿತ. ");
INSERT INTO gok_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","ಆಮಿ ತ್ಯಾ ಥಂಡಿಚಾ ದಿಸಾತ್ ತಿಥ ಆಸ್ತಾನಾ ತೀನ್ ಮೈನ್ಯಾ ನಂತರ ಅಲೆಕ್ಸಾಂದ್ರಿಯಾಚಾ ಗಾವಾತ್ನಿ ಆಲ್ಯಾಲೆ ಯಕ ವ್ಹಡಿತ್ ಚ಼ಡ್ಲಾವ್. ತೆ ವ್ಹಡಿಲಾ ಆಸ್ವಿನಿ ದಿವಿ ಮನ್ಹುನ್ ವಳಕ್ ಹುತಿ. ");
INSERT INTO gok_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","ಆಮಿ ಸಿರಾಕೊಸ್ ಪೆಠತ್ ಯವುನ್ ತಿತ್ತ ತೀನ್ ದಿಸ್ ಹುತಾವ್. ");
INSERT INTO gok_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","ತಿತ್ನಿ ನಿಗುನ್ ರೇಗಿಯ ಮಂತ್ಯಾಲ್ಯಾ ಗಾವಾತ್ ಆಲಾವ್. ದುಸ್ರೆ ದಿಸಿ ದಕ್ಷಿನಾಚ಼ ವಾರ ಸುಟ್ಲ. ತ್ಯಚಿಸಾಟಿ ತಿತ್ನಿ ಜಾ಼ಯಾಜಾ಼ಲ್ಹ. ಯೆಕ್ ದಿಸ್ ಜಾ಼ಲ್ಯಾವ ಪುತೊರಿ ಮಂತ್ಯಾಲ್ಯಾ ಗಾವಾತ್ ಆಲಾವ್. ");
INSERT INTO gok_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","ತಿಥ ಥೊಡ್ಯಾ ಇಸ್ವಾಸಿನಾ ಬಗ್ಲಿತ. ಆಮ್ಚೆ ಸಂಗ ಯೇಕ್ ವಾರ್ತರಿ ರಾಯಾ ವ್ಹಯಿಸಾ ಮನ್ಹುನ್ ತ್ಯಂಚಾನಿ ಆಮಾನಾ ಇಚಾರ್ಲ. ಪರತ್ ಅಮಿ ರೊಮಾತ್ ಗೆಲಾವ್. ");
INSERT INTO gok_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","ಅಮಿ ಹಿತ್ತ ರಾಯ್‍ಲ್ಯಾಲ ರೊಮಾತ್‍ಲ್ಯಾ ಇಸ್ವಾಸಿನಾ ಸಮಾಜ಼್ಲ. ತ್ಯಂಚಾನಿ ಅಮಾನಾ ಭೇಟ್ ವ್ಹಯಾಲಾ ಅಪ್ಪಿಚಾ ಬಾಜಾ಼ರಾಚಾ ಜಾ಼ಗ್ಯಾವ ಆಲಾವ್. ಆನಿ ಹಿ ಇಸ್ವಾಸಿ ದಿಸಲ್ಯಾ ನಂತರ್ ಪೌಲನಿ ದೇವಾಲಾ ದನ್ಯಾವಾದ್ ಸಾಂಗ್‍ಲ್ಯಾ ನಂತರ್ ತ್ಯಲಾ ಉಮೆದ್ ಆಲಿ. ");
INSERT INTO gok_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","ಕವಾ ಆಮಿ ರೊಮಾತ ಗೆಲಾವ್ ತವಾ. ತೀಥ ಪೌಲಾಲಾ ಯಕಲ್ಯಾಲಾ ರಾಹ್ಯಾಲಾ ಪರವಾನಗಿ ಮಿಳಾಲಿ. ಖರ ತ್ಯಚೆ ದೆಕರಿಕಿಲಾ ಯಕಾ ಸಿಪಾಯಿಲಾ ಥೆವ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","ತೀನ್ ದಿಸ್ ಜಾ಼ಲ್ಯಾವ ತ್ಯನಿ ತಿತಲ್ಯಾ ಯಹುದಿ ಫುಡಾರ‍್ಯಾನಾ ಯಕಜಾ಼ಗಿ ಹಾಕಟ್ಲ. ಸಗ್ಳ ಜ಼ಮ್ಲ ತವಾ ತ್ಯೊ ತ್ಯನಾ ಮನ್ಲಾ “ಬಾವ್ಹಾನು, ಮಿ ಮಾಜಾ ಬಾವ್ಹಾಂಚೆ ಆಡ್ವ ಕಾಯೆಕ್ ಕೆಲ ನಾಹಿ, ತರಿ ಮನಾ ಯೆರುಸಲೆಮಿತ್ ದರುನ್ ರೊಮಾತ್‍ಲ್ಯಾ ಲೊಕಾಂಚಾ ತಾಬ್ಯಾತ್ ಆಪರಾದಿ ಮನ್ಹುನ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","ರೊಮಾತ್‍ಲ್ಯಾಂಚಾನಿ ಮನಾ ದುಸ್ರ ಪ್ರಶ್ನೆ ಇಚಾರ್ಲ. ಫನ್ ಮರ್ನಾಚಾ ದಂಡಲಾ ಗುರಿ ಕೆಲ್ಯಾಲ ಕಾಯಿಸ್ ಚು಼ಕ್ ಮಾಜಿಪ ತ್ಯನಾ ದಿಸ್ಲಿ ನಾಹಿ. ಮನ್ಹುನ್ ತ್ಯಂಚಾನಿ ಮನಾ ಸುಡುನ್ ಆನಾಯ ಮನ್ಕೆಲ ");
INSERT INTO gok_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","ಫನ್ ತಿಥ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ಯಹುದ್ಯಾಂಚಾನಿ ತ್ಯನಾ ಹಾರ್ಕತ್ ಕಿಲಿ ಮನ್ಹುನ್ ರೊಮಾತ್ ಸಿಸರಾಚೆ ಮೊರ‍್ಹ ಇಚಾರ್ ವ್ಹವುನಿ ಐಕಾಯಾ ವ್ಹಯಿ. ಫನ್ ಮಾಜಾ ಲೊಕಾಂಚಾನಿ ದೊಶ್ ಸಾಂಗ್ಲಾನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","ಮನ್ಹುನುಸ್ ಮಿ ತುಮಾನಾ ಬಗಾಯಾ ಆನಿ ತುಮ್ಚಿ ಸಂಗ ಬೊಲಾಯಾ ಮನ್ ಕೆಲ. ಇಸ್ರಾಯಲಾಚೆ ಆಶೆಸ್ ಲಾಗುನ್ ಹ್ಯಾ ಸರಪೊಳ್ಯಾಂಚಾನಿ ಬ್ಯಾಂದಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","ಯೆಹುದಿ ಪೌಲಾಲಾ, “ತುಜೆ ಗುಶ್ಟಿತ್ ಯುದಾಯಾತ್ನಿ ಆಮಾನಾ ಕಚ಼ ಪತ್ರ ಆಲ ನಾಹಿ. ತಿತ್ನಿ ಆಲ್ಯಾಲ್ಯಾ ಆಮ್ಚಾ ಯೆಹುದಿ ಬಾವ್ಹಾಂಚಾನಿ ತುಜೆ ಗುಸ್ಟಿತ್ ಕಳಿವ್ಲ ನಾಹಿ ನಾಹಿತ ವಾಯಿಟ್ ಬೊಲ್ಲನಾಹಿ ");
INSERT INTO gok_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","ಫನ್ ತುಜಾ ಬೊಲ್ಯಾ ಆಮಿ ತುಜಿಪ್ನಿಸ್ ಐಕಾಯಾ ವ್ಹಯಿ ಮಂಥ್ಯಾವ್. ಕಾಮಂಜೆ ಸಗ್ಳಿಕ್ಲಿ ಲೊಕ ತು ಆಸ್‍ಲ್ಯಾಲ್ಯಾ ತಂಡ್ಯಾಚೆ ಆಡ್ವಿ ಬೊಲ್‌ತ್ಯಾತ ಮನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","ಪೌಲಾನಿ ಆನಿ ಯೆಹುದ್ಯಾಂಚಾನಿ ಸಬೆ ಮಿಳಾಯಾ ಯೊಕ್ ದಿಸ್ ಥರಿವ್ಲಾ, ತವಾ ಪೌಲ್ ರಾಥ್ಯಾಲ್ಯಾ ಜಾ಼ಗ್ಯಾವ ಮುಟಿ ಸಬೆ ಜ಼ಮ್ಲಿ; ದೇವಾಚಾ ರಾಜಾಚೆ ಗುಶ್ಟಿತ್ ಆಪ್ಲಾ ಇಚಾರ್ ತ್ಯನಾ ರ‍್ಯಾತ್ ದೀಸ್ ಫುಡುನ್ ಸಾಂಗ್ಲ, ಆನಿ ಯೇಸುಚೆ ಗುಶ್ಟಿತ್ ಇಸ್ವಾಸ್ ಥೆವಾಯಾ ತ್ಯಂಚಿ ಮನ ವಳ್ವಾಯಾ ಯತ್ನ ಕಿಲಿತ. ಹ್ಯಚಿಸಾಟಿ ತ್ಯನಿ ಮೊಶೆಚ಼ ಧರ್ಮಶಾಸ್ತಾರ್ ಆನಿ ಪ್ರವಾದಿಂಚ಼ ಗ್ರಂಥ ವಾಫರ್ಲ ");
INSERT INTO gok_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","ಪೌಲಾನಿ ಸಾಂಗ್ಯಾಲ್ಯಾ ಖನ್ಕತಿಂಚಿ ಥೊಡ್ಯಾ ಯೆಹುದಿಂಚಾನಿ ಖಾತ್ರಿ ಥಿವ್ಲಿ. ಫನ್ ಉರ್‌ಲ್ಯಾಲ್ಯಾಂಚಾನಿ ಖಾತ್ರಿ ಥಿವ್ಲಿ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","ತ್ಯಂಚಾತ್ ಯಾಕ್ ಮನ್ ನವ್ಥ ತ್ಯಚಿಸಾಟಿ ತೀ ಸುಡುನ್ ಜಾ಼ಯಾ ಲಾಗ್ಲಿತ ಆಸಾ ಪೌಲ್ ಸರ್ತೆ ಪಾವ್ಟಿ ಬೊಲತ್ ಪವಿತ್ರಾತ್ಮ ಯೆಶಾಯಚಾ ಪ್ರವಾದಿಪ್ನಿ ತುಮ್ಚಾ ವಡ್ಲಾ ಸಂಗ್ನಿ ಹ್ಯಾ ಖರ‍್ಯಾಚೆ ಗುಶ್ಟಿತ್ ಬೊಲ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","ಜಾ಼ ಆನಿ ಹ್ಯಾ ಲೊಕಾನಾ ಸಾಂಗ್ ತುಮಿ ಕಾನ್ ದಿವುನ್ ಐಕ್ನಾರ್ ಫನ್ ತುಮಾನಾ ಸಮಾಜ಼ನಾರ್ನಾಹಿ ಜ಼ಪುನ್ ಬಗ್ಲಸಾತರಿ ತುಮಾನಾ ದಿಸ್ನಾರ್ ನಾಹಿ, ");
INSERT INTO gok_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","ಕಾ ಮಂಜೆ ಹ್ಯಾ ಲೊಕಾಂಚಿ ಮನ ದೊಂಢಾ ಜಾ಼ಲ್ಯಾತ ಹಿ ಕಾನಾನಿ ಕಿವಂಡಿ ಜಾ಼ಲ್ಯಾತ; ಡೊಳ್ಯಾನಿ ಆಂದಳಿ ಜಾ಼ಲ್ಯಾತ; ಆಪ್ನು ಡೊಳ್ಯಾನಿ ಬಗುನ್ ಕಾನಾನಿ ಐಕುನ್ ಮನಾನಿ ಸಮಜು಼ನ್ ಮಾಜಿಕ್ಡ ಪರಾತ್ಲಿ ಆಸ್ತಿತ ಆನಿ ಮಿ ತ್ಯನಾ ಬರ ಕೆಲ ಆಸ್ತ. ");
INSERT INTO gok_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","ತವಾ ಪೌಲ್ ದೇವಾಚೆ ರಕ್ಷೆನಿಚಿ ಬಾತ್ನಿ ಯೆಹುದಿ ನಸ್‌ಲ್ಯಾಲ್ಯಾನಾ ಲಾವುನ್ ದಿಲೆ. ತೆ ತ್ಯಲಾ ಕಾನ್ ದೆನಾರ್. ಹ್ಯ ತುಮಾನಾ ಠಾವ ರಾಹುನಿ!” ಮನ್ಹುನ್ ಸಾಂಗಿತ್ ಬೊಲ್ನ ಸಪಿವ್ತೊ ");
INSERT INTO gok_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","ತ್ಯನಿ ಹಿ ಬುಲಿ ಸಾಂಗ್‌ಲ್ಯಾ ನಂತರ್ ತೇ ಯಹುದಿ ಆಪಲ್ಯಾ ಆಪಲ್ಯಾತ್ ಖುಬ್ ವಾದ್ ಗಾಲ್ಹಿತ್ ಗೆಲ. ");
INSERT INTO gok_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","ಪೌಲ್ ಆಪ್‌ಲ್ಯಾ ಬಾಡಗಿಚಾ ಗರ‍್ಹಾತ್ ದೊನ್ ವರ್ಸಾ ಪರತ್ ರಾಯ್ಲಾ ಹುತ್ತಾ. ಆಪ್‌ಲ್ಯಾಲಾ ಭೆಟ್ ವ್ಹಯಾ ಆಲ್ಯಾಲ್ಯಾ ಸಗ್‌ಳ್ಯಾ ಲೊಕಾನಾ ಮಾಯೆನಿ ಸ್ವಾಗತ್ ಕರಿತಾ. ");
INSERT INTO gok_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","ಆನಿ ತ್ಯೊ ಹ್ಯ ಕಾಮ್ ಖುಬ್ ದಿರ‍್ಹಾನಿ ಕರಿತಾ ದೇವಾಚಾ ರಾಜಾಚೆ ಗುಶ್ಟಿತ್ ಸಾಂಗಿತಾ; ಪ್ರಭು ಯೇಸು ಕ್ರಿಸ್ತಾಚೆ ಗುಶ್ಟಿತ್ ಸಿಕ್ವಿತಾ; ತ್ಯಲಾ ಆಡ್ಯಾವಾಯಾ ಕುನಾಲಾಸ್ ಜಾ಼ಲ್ಹ ನಾಹಿ.");
INSERT INTO gok_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","ಕ್ರಿಸ್ತ ಯೇಸುಚಾ಼ ಸೇವಕ್ ಜಾ಼ಲ್ಯಾಲಾ ಪೌಲ್ ಲಿವ್‍ತ್ಯಾಲ ಪತ್ರ. ದೇವಾನಿ ಮನಾ ಅಪೋಸ್ತಲ್ ವ್ಹಯಾಲಾ ಹಾಕಟ್ಲ. ದೇವಾಚಿ ಬರಿ ಖಬರ್ ಸಗ್‌ಳ್ಯಾ ಲೋಕಾನಾ ಸಾಂಗಾಯಾಸಾಟಿ ಮನಾ ನಿವಡ್‍ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","ದೇವಾನಿ ಆಪ್‍ಲ್ಯಾ ಲೋಕಾನಾ ಹಿ ಬರಿ ಖಬರ್ ದಿಯಾಲಾ ಖುಬ್ ಕಾಲಾಚೆ ಮಾಗ ಆಪ್‌ಲ್ಯಾ ಪ್ರವಾದಿಂಚಿಪ್ನಿ ಪವಿತ್ರ ಪುತಿಕಾತ್ ಸಬ್ದ ದಿಲ್ತಾ. ");
INSERT INTO gok_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","ತ್ಯೊ ದೇವಾಚಾ಼ ಲ್ಯೊಕ್ ಆಮಚಾ಼ ಪ್ರಭು ಜಾ಼ಲ್ಯಾಲ್ಯಾ ಯೇಸು ಕ್ರಿಸ್ತಾಚಿ ಗ್ಯೊಶ್ಟುಸ್ ಜಾ಼ಲೆ. ಮಾನ್ಸಾಚಾ ರುಪಾತ್ ತ್ಯೊ ದಾವಿದಾಚಾ ಕುಟ್ಮಾತ್ ಜ಼ಲಾಮ್‌ಲ್ಯಾಲಾ. ");
INSERT INTO gok_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","ಫನ್ ಪವಿತ್ರ ಆತಮ್ಯಾಚಾ ಬಳಾನಿ ಮೇಲ್ಯಾಲ್ಯಾತ್ನಿ ಜೀತ್ತಾ ವ್ಹವುನ್ ಉಠುನ್ ಯವುನ್ ಹ್ಯಲಾ ದೇವಾಚಾ಼ ಲ್ಯೋಕ್ ಮನ್ಹುನ್ ದಾವುನ್ ದಿಲ, ಹ್ಯೊಸ್ ಆಮಚಾ಼ ಪ್ರಭು ಯೇಸು ಕ್ರಿಸ್ತ ಜಾ಼ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","ತ್ಯಚಿಸ್ ಲಾಗುನ್ ದೇವಾನಿ ಮನಾ ಕ್ರಿಸ್ತಾಸಾಟಿ ಅಪೋಸ್ತಲ್ ವ್ಹಯಾ ಕ್ರಪಾ ದಿಲೆ. ಹ್ಯಚಿಸ್ ಲಾಗುನ್ ಸಗ್ಳೆ ದುನೆತಲ್ಯಾ ಲೋಕಾನಾ ತ್ಯಚಿ ಆಜ್ಞಾ ಪಾಳಾಯಾ ಆನಿ ತ್ಯಚಿವ ಇಸ್ವಾಸಾತ್ ಆನಾಯಾ ವ್ಹಯಿಲ್, ");
INSERT INTO gok_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","ರೋಮಾಪುರಾತ್ ಆಸ್‌ಲ್ಯಾಲಿ ತುಮಿ ಸಾಹಿತ್ ಮಿಳುನ್ ಯೇಸು ಕ್ರಿಸ್ತಾಚಿ ವ್ಹಯಾಲಾ ದೇವಾನಿ ಹಾಕಟ್‍ಲ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","ಆನಿ ರೊಮಾತ್‍ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ತುಮಾನಾ ಸಗ್‌ಳ್ಯಾನಾ ಲಿವ್‍ತ್ಯೊ. ದೇವ್ ತುಮ್ಚಿ ಮಾಯಾ ಕರ್ತೊ ಆನಿ ಆಪ್ಲಿ ಸ್ವತಾಚಿ ಲೋಕ ವ್ಹಯಾಲಾ ಹಾಕಟ್‌ಲ್ಯಾತ: ಆಮಚಾ಼ ಬಾ ಜಾ಼ಲ್ಯಾಲ್ಯಾ ದೇವಾಪ್ನಿ ಪ್ರಭು ಜಾ಼ಲ್ಯಾಲ್ಯಾ ಯೇಸು ಕ್ರಿಸ್ತಾಪ್ನಿ ತುಮಾನಾ ಕ್ರಪಾ ಶಾಂತಿ ವ್ಹವುನಿ. ");
INSERT INTO gok_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","ಆಂದಿ, ತುಮಚಾ಼ ಇಸ್ವಾಸ್ ದುನೆತ್ ಸಗ್‌ಳೆ ಮೊರ‍್ಹ ಆಲಾ ಮನ್ಹುನ್ ತುಮಚೆ ಸಗಳ್ಯಾಂಚೆಸಾಟಿ ಯೆಸು ಕ್ರಿಸ್ತಾಪ್ನಿ ಮಾಜಾ ದೆವಾಲಾ ದನ್ಯವಾದ್ ಸಾಂಗ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","ಮಿ ಮಾಗ್ನ ಕರ್ತಾನಾ ಖಾಯಿಮ್ ತುಮಚಿಸಾಟಿ ಇನಂತಿ ಕರ್ತೊ. ದೇವಾಚಾ ಲೇಕಾಚಿ ಬರಿ ಖಬರ್ ಸಾಂಗಿತ್ ದೇವಾಚಿ ಸೆವಾ ಮಾಜಾ ಮನಾನಿ ಕರ್ತೊ ಹ್ಯಲಾ ದೇವುಸ್ ವಳಕ್ ಜಾ಼ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","ಮಾಜಾ ಮಾಗ್‌ನ್ಯಾತ್ನಿ ಮೀ ಪರತೇಕ್ ಪಾವ್ಟಿ ದೇವಾಪ ಮಾಗಾಚ಼ ಕ್ಯಾ ಮಂಜೆ ದೇವ್ ಆಪ್‍ಲ್ಯಾ ಮನಾಚೆಗತ್ ಆತಾತರಿ ತುಮಾನಾ ಬೇಟ್ ವ್ಹಯಾ ದಿವುನಿ. ");
INSERT INTO gok_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","ಮಿ ಖುಬ್ ಮನ್ ಕರ್ತೊ ಕಾ ಮಂಜೆ ಮಿ ತುಮಾನಾ ಬೆಟ್ ವ್ಹವುನ್ ಥೊಡಾ ಆಶಿರ್ವಾದ್ ದಿಯಾ ಹ್ಯಚಿಸ್ ಲಾಗುನ್ ಬಳ್ ಗೆತಲ್ಯಾಲಿ ವ್ಹವಾ. ");
INSERT INTO gok_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","ಮೀ ಸಾಂಗಾಚ಼ ಕ್ಯಾ ಮಂಜೆ, ಮಿ ತುಮ್ಚಿಪ ಯತಾನಾ ಮಾಜಾ ಆನಿ ತುಮ್ಚಾ ಇಸ್ವಾಸಾನಿ ಆಮಿ ಯಕಾಮಕಾಲಾ ಮಜ಼ತ್ ಕರಾಯಾ ವ್ಹಯಿ. ");
INSERT INTO gok_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","ಬಾವ್ಹಾಂಡಾನು, ಹ್ಯ ತುಮಾನಾ ಯಾದ್ ರಾಹುನಿ ಖುಬ್ ಪಾವ್ಟಿ ಮಿ ತುಮಾನಾ ಬೆಟ್ ವ್ಹಯಾ ಯವಜ್ನಾ ಕೆಲೆ. ಫನ್ ಕ್ಯಾ ಯಾಕ್ ಮನಾ ತಸ ಕರಾಯಾ ಥಾಂಬಿತ್ಯಾ. ದುಸ್‍ರ‍್ಯಾ ಲೊಕಾಪ್ನಿ ಮೀ ಜಿತ್‌ಲ್ಯಾಚೆಗತ್ ತುಮ್ಚಿಪ ಸಾಹಿತ್ ಮಿ ಫಳ್ ಜಿತ್ತಾಯಾ ಮನ್ ಕರ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","ಮೀ ಗ್ರೀಕಾಂಚೆ ಆನಿ ಗ್ರೀಕ್ ನಸ್‌ಲ್ಯಾಲ್ಯಾಂಚೆ, ತಸ ಶಾನ್ಯಾಂಚೆ ಆನಿ ಬುದ್ದಿ ನಸ್‌ಲ್ಯಾಲ್ಯಾಂಚೆ ಸೇವೆಚ಼ ವಜ್ಜ ಮಾಜಿವ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","ಮನ್ಹುನ್ ರೊಮಾತ್ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ತುಮಾನಾಬಿ ಬರಿ ಖಬರ್ ಸಾಂಗಾಯಾ ಖುಬ್ ಉಮೇದಿನಿ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","ಬರೆ ಖಬ್ರಿಚೆ ಗುಶ್ಟಿತ್ ಮಿ ಲಾಜ಼ತ್ ನಾಹಿ. ತಿ ಖಬರ್ ಆಂದಿ ಯಹುದ್ಯಾನಾ ಮಂಗ್ ಗ್ರಿಕಾನಾ ಆನಿ ಇಸ್ವಾಸ್‌ ಥೆವ್‍ತ್ಯಾಲ್ಯಾ ಸಗ್‍ಳ್ಯಾನಾ ರ‍್ಯಾಕ್‌ತ್ಯಾಲ ದೇವಾಚ಼ ಬಳ್ ಜಾ಼ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","ಕಸ ಮಂಜೆ ದೆವಾಪ್ನಿ ಗಾವಲ್ಯಾಲಿ ನಿಯೆತ್ ಬರೆ ಖಬರಿತ್ ದಿಸುನ್ ಯತಿ. ಪವಿತ್ರ ಗ್ರಂಥಾತ್ ಆಸ ಲಿವ್‌ಲ್ಯಾ, “ನಿಯತಿಚಾ಼ ಇಸ್ವಾಸಾನಿ ಜೀವ್ನಾ ಕರ್ನಾರ್. ” ತಿ ನಿಯೆತ್ ಇಸ್ವಾಸಾಚ಼ ಫಳ್ ವ್ಹವುನ್ ಇಸ್ವಾಸ್ ಬಳ್ಕಟ. ");
INSERT INTO gok_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","ಸಗ್ಳ ಪಾಪಿ ಆನಿ ಬುರ್ಸ ಲೋಕ್ ಬುರ್ಶಾ ಫನಾನಿ ಖರ ಜಾಕತ್ಯಾತ ತ್ಯಂಚಿವ ದೇವಾಚಾ಼ ರಾಗ್ ಸ್ವರ್ಗಾತ್ನಿ ಉತರುನ್ ಯನಾರ್. ");
INSERT INTO gok_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","ಕಾ ಮಂಜೆ ದೇವಾಚೆ ಗುಶ್ಟಿತ್ ವ್ಹಯಿಲ್ ತ್ಯವ್ಡ ತ್ಯನಾ ಶಾರ್ಕ ಠಾವ ಹಾ. ಕಾ ಮಂಜೆ ದೇವಾನಿಸ್ ತ್ಯನ್ಯಾ ಶಾರ್ಕ ಆಪ್ಲೆ ಗುಶ್ಟಿತ್ ಸಾಂಗ್‍ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","ಕಸ ಮಂಜೆ ಡೊಳ್ಯಾನಾ ದಿಸನಸ್ನಾರ ತ್ಯಚ಼ ಗುನ್ ಶಾಸ್ವತ್ ಬಳ್ ಆನಿ ದೈವಿಕ್ ಸ್ವಭಾವ್ ದುನ್ಯಾ ಉತ್ಪನ್ ಕೆಲ್ಯಾಲೆದರ್ನಿ ತ್ಯನಿ ಉತ್ಪತ್ತಿ ಕೇಲ್ಯಾಲ್ಯಾ ಸಗ್‌ಳ್ಯಾ ಸಾಮಾನಾನಿ ಹ್ಯ ಸಗ್ಳ ಬಗ್ತಾವ್ ಹ್ಯಚಿ ಸಾಟಿ ತ್ಯಾ ಲೊಕಾಂಚಿಪ ಕಚಾ಼ ನೇವಾ ರಾಹಿತ್ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","ಕಾ ಮಂಜೆ ಲೊಕಾನಾ ದೇವ್ ಸಮಾಜ್ಲಾತರಿ ದೇವಾಲಾ ಮಹಿಮೆ ಕಿಲಿನಾಹಿ, ತ್ಯಲಾ ಮರ‍್ಯಾದ್ ನಾಹಿತ ಉಪ್ಕಾರ್ ದಿಲಾನಾಹಿ. ಲೋಕಾಂಚಿ ಯವಜ್ನಾ಼ ಫುಕಟ್ ಜಾ಼ಲಿ. ಬುದಿ ನಸಲ್ಯಾಲಿ ತ್ಯಂಚಿ ಮನ ಆಂದಾರ್ ಜಾ಼ಲ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","ತೀ ಲೊಕ ಆಪ್‌ಲ್ಯಾಲಾ ಶಾನಿ ಮನ್ಹುನ್ ಗೆಥ್ಯಾತ ಫನ್ ತೇ ಮುರ್ಕ್ ಜಾ಼ಲ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","ನಾಸ್ ವ್ಹಯಾಂಚೆ ಅಂದಿ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ದೇವಾಚಿ ಮೈಮಾ ತ್ಯಂಚಾನಿ ನಾಸ್ ವ್ಹನಾರ‍್ಯಾ ಮಾನ್ಸಾಂಚಾ, ಪಾಕ್ರಾಂಚಾ, ಜ಼ನಾವಾರಾಂಚಾ ಸರ್ಪಾಟ್ಯಾನಿ ಜಾ಼ತ್ಯಾಲ್ಯಾ ಜ಼ನಾವಾರಾಂಚಿ ಪಾಶಾನ ಕರುನ್ ತ್ಯನಾ ವವ್ಯಾಳಾಯಾ ಲಾಗ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","ಮನ್ಹುನ್ ತ್ಯಂಚಾನಿ ಮನಾತ್ಲೆ ಬುರ‍್ಸೆ ಆಸೆಂಚೆಗತ್ ಚಾ಼ಲುನ್ ಆಪ್ಲಿ ಆಪ್ಲಿ ಶರಿರ ಆಪಲ್ಯಾತುಸ್ ಮರ‍್ಯಾದ್ ಕಾಡುನ್ ಗಿಹುನ್ತ ಮನ್ಹುನ್ ದೇವಾನಿ ತ್ಯನಾ ಬುರ್ಶಾ ಕಾಮಾನಾ ಥರಿವ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","ತ್ಯಂಚಾನಿ ಖರ‍್ಯಾ ದೆವಾಲಾ ಸುಡುನ್ ಲಬಾಡಾಲಾ ದರ‍್ಹುನ್; ಸ್ರಶ್ಟಿ ಕೇಲ್ಯಾಲ್ಯಾ ದೆವಾಲಾ ಸುಡುನ್ ತ್ಯನಿ ಸ್ರಶ್ಟಿ ಕೆಲ್ಯಾಲೆ ಸ್ರಶ್ಟಿಚಿ ಪುಜಾ ಕರುನ್ ವವ್ಯಾಳಾಯಾ ಲಾಗ್ಲಿತ. ಫನ್ ಸ್ರಶ್ಟಿ ಕೇಲ್ಯಾಲಾ ದೇವ್ ಖಾಯಿಮ್ ವವ್ಯಾಳುನ್ ಗೆನ್ಹಾರ್. ಆಮೇನ್. ");
INSERT INTO gok_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","ತ್ಯಂಚಾನಿ ತಸ ಕೇಲ ಮನ್ಹುನ್, ದೇವಾನಿ ತ್ಯನಾ ಲಾಜ಼ಚಾ ಕಾಮಾನಾ ಸುಡುನ್ ದಿಲಿತ. ತ್ಯಂಚಾ ಬ್ಯಾಯ್ಕಾ ಸಾಹಿತ್ ಸಬಾವಾಚ಼ ಶಾರಿಕ್ ಸಂಬಂದ್ ಸುಡುನ್ ಸಬಾವಾಚೆ ಬಾಹಿರ್ಲಿ ಕಾಮ ಕರಾಯಾ ಲಾಗಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","ತಸಸ್, ಗಡಿಬಿ ಬ್ಯಾಯ್ಕಾಂಚಿ ಸಂಗ ಶಾರಿರಿಕ್ ಸಂಬಂದ್ ಕರಾಚ಼ ಸುಡುನ್ ಆಪ್‌ಲ್ಯಾ ಆಪ್‌ಲ್ಯಾತುಸ್ ಸಲಿಂಗಕಾಮಿ ಜಾ಼ಲ್ಹ.ಲಾಜ಼ಗಿಡ ಜಾ಼ಲ್ಹ ಆಪ್ಲೆ ಬುರ್ಶೆ ಚಾ಼ಲ್ನುಕಿಲಾ ಶಾರ್ಕಿ ಸಿಕ್ಷಾ ತೆ ಆಪ್ಲಿವ ಗೆಥ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","ಕಾ ಮಂಜೆ ದೇವಾಚ಼ ಖರ ಗಿನ್ಯಾನ್ ಗಿಹ್ಯಾಲಾ ತ್ಯಂಚಾನಿ ನಕಾರ್ ಕೇಲಾ. ತ್ಯನಾ ಮನ್ ನವ್ಥ ಮನ್ಹುನ್ ದೇವಾನಿ ತ್ಯನಾ ತ್ಯಂಚಾ ಬುರ್ಶಾ ಮನಾಲಾ ವಪ್ಸುನ್ ದಿಲಿತ. ಮನ್ಹುನ್ ತೀ ಆಪ್ನು ಕರು ನಾಹಿ ತಿ ಕಾಮ್ ಕರ್ತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","ತೀ ಸಗ್ಳೆ ತರಚಾ ಬುರ್ಶಾ ಫನಾನಿ ಬರ್ಲ್ಯಾಲಿ ಹಾತ್ತ , ರಾಗ್ , ಖೊಟಫನ್ ಖುನ್ , ಮಾರಾಮಾರ‍್ಯಾ, ನಿಯತ್ ನಸ್‌ಲ್ಯಾಲಿ, ಮೊಸ್, ಹಗೆತನಾನಿ ಬರ್ಲ್ಯಾಲಿ ಹಾತ್ತ. ಚಾ಼ಡಿ ಸಾಂಗ್‌ತ್ಯಾಲಿ. ");
INSERT INTO gok_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","ಆನಿ ದುಸ್‌ರ‍್ಯಾಂಚೆ ಗುಶ್ಟಿತ್ ಬುರ್ಸ ಬೊಲಾಚ಼, ದೇವಾಚಾ಼ ಇರೊದ್ ಕರ್ತ್ಯಾತ. ದಿಮಾಕಾಚಿ, ಗರ್ವಿಚಿ, ಆನಿ ಆಪ್ಲೆ ಗುಶ್ಟಿತ್ ಬಡಾಯಾ ಸಾಂಗ್‍ತ್ಯಾಲಿ ಜಾ಼ಲ್ಯಾತ. ತೀ ಬುರ್ಸಿ ಕಾಮ ಕರಾಯಾ ಖುಬ್ ವಾಟಾ ಶೊತ್ಯಾತ ತೀ ಆಪ್‌ಲೆ ಆಯಿಬಾಲಾ ಐಕತ್ ನಸ್‍ಲ್ಯಾಲಿ. ");
INSERT INTO gok_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","ತೇ ಸಮಜ಼ತ್ ನಸ್‌ಲ್ಯಾಲ ಸಾಂಗ್‍ಲ್ಯಾಲ್ಯಾ ಸಬ್ದಾಚೆಗತ್ ಕರಿನಸ್ನಾರ ಆನಿ ತೀ ದುಸ್‌ರ‍್ಯಾಂಚಿವ ದಯಾ ಮಾಯಾ ಕರ್ನಾ ನಸ್ನಾರಿ ಜಾ಼ಲ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","ಆಸ್‌ಲ್ಯಾನಾ ಮರ್ನಾಚಿ ಶಿಕ್ಶಾ ವ್ಹಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ದೇವಾಚ಼ ಧರ್ಮಶಾಸ್ತಾರ್ ಸಾಂಗ್ತ ಮನ್ಹುನ್ ತ್ಯನಾ ಠಾವ ಹಾ. ತರೀಬಿ ತೀ ಆಸ್ಲಿ ಕಾಮ ಕರಿತ್ ರಾಥ್ಯಾತ ಆನಿ ಆಸ್ಲಿ ಕಾಮ ಕರಾಯಾ ದುಸ್‍ರ‍್ಯಾನಾ ಉಮೆದ್ ದೇತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","ಮನ್ಹುನ್ ದುಸರ‍್ಯಾಪ ಚು಼ಕ್ ಶೊತ್ಯಾಲಾ ತು ಕೊನ್ ಆಸಲಾಸ್ ತರಿ ತುಜಿ ಚು಼ಕ್ ಮಾಪ್ ವ್ಹನಾರ್ ನಾಹಿ. ಕಾ ಮಂಜೆ ತು ದುಸ್‌ರ‍್ಯಾಂಚಾ಼ ನ್ಯಾಯಿ ತಿರ್ಮಾನ್ ಕರ್ತಾನಾ ತ್ಯಂಚಾನಿ ಕೆಲ್ಯಾಲಿ ಚು಼ಕ್ ತು ಕರ್ತೊಸ್ “ಆನಿ ಯಕಾಪ ಚು಼ಕ್ ಸುದುನುಸ್ ತು ಗುನ್ನದಾರ್ ಜಾ಼ಲ್ಯಾಸ್. ");
INSERT INTO gok_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","ಚು಼ಕ್ ಕರ್ತ್ಯಾಲ್ಯಾ ಲೋಕಾನಾ ದೇವ್ ತಿರ್ಮಾನ್ ಕರ್ತೊ. ತ್ಯಚಾ಼ ತಿರ್ಮಾನ್ ಖರಾ ಮನ್ಹುನ್ ಆಮಾನಾ ಠಾವಾ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","ಫನ್ ದುಸರ‍್ಯಾನಾ ತಿರ್ಮಾನ್ ಕರ್ತ್ಯಾಲ್ಯಾ ತು ದೇವಾಚಾ ತಿರ್ಮಾನಾತ್ನಿ ಚು಼ಕ್ವುನ್ ಗಿಹಿನ್ ಮಂಥೊಸ್ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","ನಾಹಿತ ತ್ಯಚಿ ಮುಟಿ ಕರುನಾ ಥಂಡ್ಫನ್ ಸುಸಿವ್ನ ತುಮಿ ಬಾರಿಕ್ ಸಮಜು಼ನ್ ಗೆಥಾಸಾ ಕ್ಯಾ. ಖರ‍್ಯಾನಿಸ್ ದೇವ್ ಕರುನಾಮಯಿ ಮನ್ಹುನ್ ತುಮಾನಾ ಠಾವಾ. ಕಾ ಮಂಜೆ ತ್ಯೊ ತುಮಚಿ ಮನ ಬದ್ಲಾಯಾಸಾಟಿ ಯತ್ನ ಕರ್ತ್ಯೊ. ");
INSERT INTO gok_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","ಫನ್ ತುಮಿ ಘಟ್ ಮನಾಚ಼ ಆನಿ ಮೊಚಾ಼ಟ್ ಜಾ಼ಲ್ಯಾಸಾ. ಮನ್ಹುನ್ ತುಮಾನಾ ಯತ್ಯಾಲಿ ಶಿಕ್ಶಾ ತುಮಿ ಖುಬ್ ಖುಬ್ ಕರುನ್ ಗೆಥ್ಯಾಸಾ. ದೇವ್ ಆಪ್ಲಾ ರಾಗ್‌ ದ್ಯಾವ್‌ತ್ಯಾಲ್ಯಾ ದಿಸಾತ್ ತುಮಾನಾ ತೀ ಶಿಕ್ಶಾ ವ್ಹನಾರ್. ತ್ಯಾ ದೀಸಾತ್ ದೇವಾಚಾ಼ ನ್ಯಾಯಾಚಾ಼ ತಿರ್ಮಾನ್ ಲೊಕ ಬಗ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","ಕಾ ಮಂಜೆ ದೇವ್ ಪರತೇಕಾಲಾ ತ್ಯಂಚಾ ಕಾಮಾ ಶಾರ್ಕ ಪ್ರತಿ ಫಳ್ ದೇನಾರ್. ");
INSERT INTO gok_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","ಥುಡಿ ಲೋಕ ಚಾ಼ಂಗ್ಲ ಕರ್ತ್ಯಾತ ಆನಿ ಮೈಮಾ ಮರ‍್ಯಾದಿಸಾಟಿ ಆನಿ ಶಾಸ್ವತ್ ಜೀವ್ನಾ ಶೊತ್ಯಾತ ತ್ಯನಾ ದೇವ್ ಶಾಸ್ವತ್ ಜೀವ್ ದೇನಾರ್. ");
INSERT INTO gok_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","ಫನ್ ಬಾಕಿಚಿ ಲೋಕ ಆಪ್‌ಲ್ಯಾಚೆಗತ್ ವ್ಹವುನಿ, ಖರ‍್ಯಾನಿ ಚಾ಼ಲಾಚೆ ಆಂದಿ ಬುರ್ಸ ಕರತ್ಯಾಲಿ ಜಾ಼ಲ್ಯಾತ. ತ್ಯಂಚಿವ ದೇವಾಚಾ಼ ರಾಗ್ ಆನಿ ರೊಸ್ ಯನಾರ್. ");
INSERT INTO gok_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","ಬುರ್ಸ ಚಾ಼ಲಿವತ್ಯಾಲ್ಯಾ ಪರತೇಕ್ ಮಾನ್ಸಾಲಾ ಮಂಜೆ ಆಂದಿ ಯಹುದ್ಯಾನಾ, ತ್ಯಾ ನಂತರ್ ಯೆಹುದಿ ನಸ್‌ಲ್ಯಾಲ್ಯಾನಾ ಸಾಹಿತ್ ಕಶ್ಟ್ ಆನಿ ದುಖ ರಾಥ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","ಫನ್ ಚಾ಼ಂಗ್ಲ ಕರ್ತ್ಯಾಲ್ಯಾ ಪರತೇಕಾಲಾ ಮಂಜೆ ಆಂದಿ ಯಹುದ್ಯಾನಾ, ನಂತರ್ ಯೆಹುದಿ ನಸ್‍ಲ್ಯಾಲ್ಯಾನಾ ಸಾಹಿತ್ ದೇವ್ ಮೈಮಾ, ಮರ‍್ಯಾದ್ ಆನಿ ಥಂಡ್ಪನ್ ದೇನಾರ್. ");
INSERT INTO gok_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","ಕಾ ಮಂಜೆ ದೇವ್ ಪರತೇಕಾಲಾ ಯೆಕುಸ್ ತರನಿ ನ್ಯಾಯಿ ತಿರ್ಮಾನ್ ದೇನಾರ್. ");
INSERT INTO gok_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","ಯೆಹುದಿ ನಸ್‍ಲ್ಯಾಲ್ಯಾನಾ ಮೊಶೆಚಾ಼ ನೇಮ್ ನವ್ಹ. ತೀ ಲೋಕ ಮೊಶೆಚಾ ಧರ್ಮಶಾಸ್ತಾರಾತ್ನಿ ಬಾಹಿರ್ ರಾಹುನ್ ಪಾಪ ಕರ್ತ್ಯಾತ. ಯಹುದ್ಯಾಂಚಿಪ ಧರ್ಮಶಾಸ್ತಾರ್ ಹಾ ತೇ ಪಾಪ್ ಕರ್ತ್ಯಾತ ಆನಿ ತ್ಯನಾ ಧರ್ಮಶಾಸ್ತಾರಾ ಶಾರ್ಕಾ ನ್ಯಾಯಿ ತೀರ್ಮಾನ್ ವ್ಹನಾರ್. ");
INSERT INTO gok_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","ಕಾ ಮಂಜೆ ಧರ್ಮಶಾಸ್ತಾರ್ ಐಕ್‌ಲ್ಯಾಲಿ ಲೋಕ ದೇವಾಚೆ ನದ್ರಲಾ ನೀಯತಿಚಿ ವ್ಹಯಿತ್ನಾಹಿತ. ಧರ್ಮಶಾಸ್ತಾರ್ ಸಾಂಗ್‌ತ್ಯಾಲ್ಯಾ ಶಾರ್ಕ ಚಾ಼ಲತ್ಯಾಲಿ ಲೋಕ ನೀಯತಿಚಿ ವ್ಹತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","ಯಹುದಿ ನಸಲ್ಯಾಲ್ಯಾಂಚಿಪ ದರ್ಮಶಾಸ್ತಾರ್ ನವ್ತ. ಫನ್ ತ್ಯ ಧರ್ಮಶಾಸ್ತಾರ್ ಸಜಾ಼ವರಿ ಪ್ಯಾಳ್‍ತ್ಯಾತ. ತ್ಯನಾ ದರ್ಮಶಾಸ್ತಾರ್ ನಸ್ಲತರಿ ತ್ಯಂಚ಼ ಮನುಸ್ ತ್ಯನಾ ಧರ್ಮಶಾಸ್ತಾರ್ ವ್ಹತ್ತ. ");
INSERT INTO gok_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","ತ್ಯಂಚ಼ ಚಾ಼ಲ್ನ ತ್ಯಂಚಾ ಮನಾತ್ ದರ್ಮಶಾಸ್ತಾರಾಚಾ ಆಜ್ಞಾ ಲಿವ್‌ಲ್ಯಾತಾ ಮನ್ಹುನ್ ದಾವುನ್ ದೆತ. ತ್ಯಂಚಾ ಮನಾಚಾ ಸಾಕ್ಷಿ ಸಾಹಿತ್ ಹ್ಯ ಖರ ಮನ್ಹುನ್ ದಾವುನ್ ದೆತ್ಯಾತಾ ಕಾ ಮಂಜೆ ಥೊಡೆ ಪಾವ್ಟಿ ತ್ಯಂಚಾ ಯವಜ್ನಾ಼ ತೆ ಚು಼ಕ್ ಕರ್ತ್ಯಾತ ಆನಿ ಚುಕ್ ಕರಿತ್ನಾಹಿತ ಮನ್ಹುನ್ ದಾವುನ್ ದೆತ. ");
INSERT INTO gok_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","ಮಾನ್ಸಾಚಾ ಮನಾತ್ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ಗುಶ್ಟಿ ದೇವ್ ತೀರ್ಮಾನ್ ಕರಾಚಾ ದಿಸಾತ್ ಹ್ಯ ಸಗ್ಳ ಘಡ್ನಾರ್. ದೇವ್ ಯೇಸು ಕ್ರಿಸ್ತಾಸ್ ಲಾಗುನ್ ಲೋಕಾನಾ ತೀರ್ಮಾನ್ ಕರ್ನಾರ್ ಮನ್ಹುನ್ ಬರಿ ಖಬರ್ ಸಾಂಗ್ತಿ. ಮೀ ಲೋಕಾನಾ ಸಾಂಗಾಚ಼ ಕ್ಯಾ ಮಂಜೆ ತೀ ಬರಿ ಖಬರುಸ್. ");
INSERT INTO gok_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","“ಫನ್ ತು ತುಲಾಸ್ ಯೆಹುದಿ ಮನ್ಹುನ್ ಗಿಹ್ಯಾಚ಼ ಜಾ಼ಲ್ಯಾವ ಮೊಶೆಚಾ ನೆಮಾಚಾ಼ ಆದಾರ್ ಕರುನ್ ದೇವಾವ ಬಡಾಯಿ ಸಾಂಗ್ತೊಸ್. ");
INSERT INTO gok_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","ತುಮಿ ಕ್ಯಾ ಕರಾಯಾ ವ್ಹಯಿಸಾ ಮನ್ಹುನ್ ದೇವಾಲಾ ಠಾವ ಹಾ ಆನಿ ತುಮಿ ಮೊಶೆಚಾ ನೆಮಾಚೆ ಯವಸ್ತಿನಿ ತುಮಿ ಕಚ಼ ಶಾರ್ಕ ಮನ್ಹುನ್ ಸಿಕ್‍ಲ್ಯಾಸಾ; ");
INSERT INTO gok_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","ತು ಕುರಡ್ಯಾಲಾ ವಾಟ್ ದ್ಯಾವ್‌ತ್ಯಾಲಾ ಆನಿ ಆಂದಾರಾತ್ ಆಸ್‌ಲ್ಯಾಲ್ಯಾನಾ ಉಜಿಡ್ ಜಾ಼ಲ್ಯಾಸ್ ಮನ್ಹುನ್ ತುಲಾ ಖಾತ್ರಿ ಹಾ, ");
INSERT INTO gok_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","ಸಮಜ಼ತ್ ನಸ್‍ಲ್ಯಾಲ್ಯಾ ಲೊಕಾನಾ ಯೊಕ್ ಮಾಸ್ಥರ್ ಜಾ಼ಲ್ಯಾಸ್. ಮೊಶೆಚಾ ನೆಮಾಚ಼ ಸಗ್ಳ ಗಿನ್ಯಾನ್ ಆನಿ ಖರ ತುಲಾ ಠಾವ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","ತು ದುಸ್‌ರ‍್ಯಾನಾ ಸಾಂಗ್ತೊಸ್. ಫನ್ ತು ತುಲಾಸ್ ಸಾಂಗುನ್ ಗಿಹಿತ್ ನಾಹಿಸ್ ಕಾ? ಚೊ಼ರಾಚ಼ ನಾಹಿ ಮನ್ಹುನ್ ಸಾಂಗ್ತೊಸ್, ಫನ್ ತುಸ್ ಕಾ ಚೊರ್ತೊಸ್? ");
INSERT INTO gok_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","ತು ಮಂಥೊಸ್ ವೇಬಿಚಾರ್ ಕರು ನಕೊಸಾ, ಫನ್ ತು ವೇಬಿಚಾರ್ ಕರೀತ್ನಾಹಿಸ್ ಕ್ಯಾ? ತು ಪಾಶಾನಾಂಚಾ಼ ರಾಗ್ ಕರ್ತೊಸ್, ಫನ್ ತು ದೇವ್ಳಾತ್ನಿ ಚು಼ರಿ ಕರಿತ್ ನಾಹಿಸ್ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","ತು ದೇವಾಚಾ಼ ನೇಮ್ ತುಜಿಪ ಆಸ್‌ಲ್ಯಾಚೆಗತ್ ಮೊಟಫನ್ ಸಾಂಗ್ತೊಸ್ ಫನ್ ತ್ಯ ಧರ್ಮಶಾಸ್ತಾರ್ ವಲ್ಯಾಂಡುನ್ ದೇವಾಲಾ ಅವ್ಮಾನ್ ಕರಿತ್ ನಾಹಿಸ್ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","“ಯಹುದಿ ಜಾ಼ಲ್ಯಾಲ್ಯಾ ತುಮ್ಚಿಪ್ನಿಸ್ ಯಹುದಿ ನಸ್‌ಲ್ಯಾಲಿ ಲೊಕ ದೇವಾಚಾ ನಾವಾಲಾ ಆಡ್ವಿ ಬೊಲ್‌ತ್ಯಾತ” ಮನ್ಹುನ್ ಪವಿತ್ರ ಗ್ರಂಥಾತ್ ಲಿವ್‌ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","ತು ಧರ್ಮಶಾಸ್ತಾರಾಚಿ ಆಜ್ಞಾ ಪ್ಯಾಳ್ಯಾವ ತು ಕೇಲ್ಯಾಲೆ ಮುಂಜಿಲಾ ಅರ್ಥ ಹಾ. ಫನ್ ತು ಧರ್ಮಶಾಸ್ತಾರ್ ವಲ್ಯಾಂಡುನ್ ಚಾ಼ಲಾಸ್ತ ತುಲಾ ಮುಂಜಿ ಜಾ಼ಲ್ಹಿ ನಾಹಿ ಆಸ ಜಾ಼ಲ್ಹ. ");
INSERT INTO gok_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","ಯಹುದಿ ನಸ್‌ಲ್ಯಾಲ್ಯಾನಾ ಮುಂಜಿ ಜಾ಼ಲಿನಾಹಿ, ಫನ್ ಧರ್ಮಶಾಸ್ತಾರ್ ಸಾಂಗ್‌ತ್ಯಾಲ ತ್ಯಂಚಾನಿ ಕೇಲತ, ತ್ಯಂಚಾನಿ ಮುಂಜಿ ಕೇಲ್ಯಾಚೆಗತ್ ಜಾ಼ಲ್ಹನಾಹಿ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","ಯೆಹುದಿ ಜಾ಼ಲ್ಯಾಲ್ಯಾ ತುಮಾನಾ ಲೀವ್‌ಲ್ಯಾಲ ಧರ್ಮಶಾಸ್ತಾರ್ ಹಾ ಆನಿ ಮುಂಜಿ ಕೇಲೆ. ಫನ್ ತುಮಿ ಧರ್ಮಶಾಸ್ತಾರ್ ವಲ್ಯಾಂಡುನ್ ಚಾ಼ಲ್ತಾಸಾ. ಆಸ ಆಸ್ಥಾನಾ, ಶರಿರಾಲಾ ಮುಂಜಿ ಕಿಲಿನಾಹಿತರಿ ಧರ್ಮಶಾಸ್ತಾರಾಚೆಗತ್ ಚಾ಼ಲತ್ಯಾಲ್ಯಾ ತುಮಾನಾ ಗುನ್ನದಾರ್ ಮನ್ಹುನ್ ದಾವುನ್ ದೇನಾರ್. ");
INSERT INTO gok_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","ಖರಾ ಯೆಹುದಿ ಆನಿ ಖರಿ ಮುಂಜಿ ಕರಾಚಿ ಮಂಜೆ ಕ್ಯಾ? ಬಾಹಿರ್‌ ಯಹುದಿ ವ್ಹವುನ್ ರಾಥ್ಯಾಲಾ ಯಹುದಿ ನವ್ಹ. ಬಾಹಿರ್ಲಿ ಶರಿರಾಚಿ ಮುಂಜಿ ಖರಿ ಮುಂಜಿ ನವ್ಹ. ");
INSERT INTO gok_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","ಮನಾತ್ ಯಹುದಿ ವ್ಹವುನ್ ರಾಥ್ಯಾಲಾಸ್ ಖರಾ ಯಹುದಿ. ಮನಾಲಾ ಜಾ಼ಲ್ಯಾಲಿ ಮುಂಜಿ ಖರಿ ಮುಂಜಿ. ಹೀ ಮುಂಜಿ ಜಾ಼ಲ್ಯಾಲಿ ದೇವಾಚಾ ಆತ್‍ಮ್ಯಾನಿಸ್ ನಾಹಿತ ಲಿವ್‌ಲ್ಯಾಲ್ಯಾ ಧರ್ಮಶಾಸ್ತಾರಾನಿ ನವ್ಹ. ದೇವಾಚಾ ಆತ್‍ಮ್ಯಾನಿಸ್ ಮನಾಲಾ ಮುಂಜಿ ಜಾ಼ಲ್ಯಾಲಾ ಮಾನುಸ್ ಮರ‍್ಯಾದ್ ಗಿಹ್ಯಾಚಿ ದೇವಾಪ್ನಿಸ್ ಮಾನ್ಸಾಪ್ನಿ ನವ್ಹ. ");
INSERT INTO gok_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","ಆಸ ಜಾ಼ಲ್ಯಾ ಯೆಹುದಿ ವ್ಹವುನ್ ಯೆಹುದಿ ನಸ್‌ಲ್ಯಾಲ್ಯಾಂಚೆ ಪಕ್ಷಿ ಉಪಯೊಗ ಕ್ಯಾ? ಮುಂಜಿ ಕರುನ್ ಗೆತಲ್ಯಾಲ್ಯಾಚಿ ಕಿಮ್ಮತ್ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","ವ್ಹಯ್ ಯೆಹುದ್ಯಾನಾ ಸಾಂಗಾಚ಼ ಖುಬ್ ಹಾ. ಸಗ್‌ಳ್ಯಾ ಗುಶ್ಟಿಂಚ಼ ಸಾಂಗಾಚ಼ ಖುಬ್ ಹಾ ಪೈಲ ವಚನ್ ಯೆಹುದ್ಯಾನ ದಿಲ. ");
INSERT INTO gok_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","ಫನ್ ತ್ಯಾತ್‍ಲ್ಯಾ ಥೊಡ್ಯಾನಾ ಇಸ್ವಾಸ್ ನವ್ಥಾ ಮನ್ಹುನ್ ಕ್ಯಾ ಜಾ಼ಲ್ಹ? ದೇವ್ ಇಸ್ವಾಸಾತ್ ಚು಼ಕತ್ಯಾಲಾ ಜಾ಼ಲ್ಹಾ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","ಖರ‍್ಯಾನಿಸ್ ನವ್ಹ! ಪರತೇಕ್ ಮಾನುಸ್ ಲಬ್ಡಾ ಜಾ಼ಲ್ಹಾತರಿ ದೇವ್ ಖರಾಸ್ ವ್ಹವುನ್ ರಾನ್ಹಾರ್. ಪವೀತ್ರ ಪುತಿಕಾತ್ ಆಸ ಸಾಂಗಲ್ಯಾ: “ತುಜೆ ಬುಲಿತ್ ತು ನೀಯತಿಚಾ಼ ಮನ್ಹುನ್ ದಾವುನ್ ದಿಯಾ ವ್ಹಯಿ. ತುಜಾ಼ ತೀರ್ಮಾನ್ ವ್ಹತಾನಾ ತು ಜಿತ್ತಾಯಾ ವ್ಹಯಿಸ್. ");
INSERT INTO gok_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","ದೇವ್ ನೀಯತಿಚಾ಼ ಮನ್ಹುನ್ ಆಮಿ ಕೇಲ್ಯಾಲಿ ಚು಼ಕ್ ಆನಿ ತ್ಯವ್ಡಿ ಶಾರ್ಕಿ ದ್ಯಾವ್ತಿ ಆಸ ಆಸ್ಥಾನಾ ದೇವ್ ಆಮಾನಾ ಶಿಕ್ಶಾ ದೇತಾನಾ ತ್ಯೊ ಅನೆವ್ ಕರ್ತ್ಯೊ ಮನ್ಹುನ್ ಆಮಿ ಸಾಂಗಾಯಾ ವ್ಹಯಿಲ್ ಕ್ಯಾ? ಕಂದಿಸ್ ನಾಹಿ ಹಿ ಸಜಾ಼ವರಿಚಿ ಬುಲಿ. ");
INSERT INTO gok_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","ಖರ‍್ಯಾನಿಸ್ ನಾಹಿ! ದೇವಾನಿ ನ್ಯಾಯಿಚ಼ ನಸ್ಥಾತ, ತ್ಯೊ ದುನೆಚಾ಼ ನ್ಯಾಯಿ ತೀರ್ಮಾನ್ ಕಸಾ ಕರ್ನಾರ್? ");
INSERT INTO gok_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","“ಮೀ ಬೊಲ್‌ತ್ಯಾಲ ಲಬಾಡ್ ದೇವಾಚ಼ ಖರ ದಾವುನ್ ದಿಯಾ ಮಾಜಾ ಲಾಬಾಡಾನಿ ದೇವಾಲಾ ಖರ‍್ಯಾನಿಸ್ ಮೈಮಾ ವ್ಹಯಾಚಿ ಜಾ಼ಲ್ಯಾವ. ಮನಾ ಪಾಪಿ ಮನ್ಹುನ್ ಖಡ್ಯಾವಾಚಾ಼ ಕಾ? ");
INSERT INTO gok_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","“ಚಾ಼ಂಗ್ಲ ವ್ಹಯಾಸಾಟಿ ವಾಯಿಟ್ ಕರುಯಾ ಮನ್ಹುನ್ ಆಮಿ ಕಾ ಸಾಂಗು ನಾಹಿ? ಆಸ ಮೀಸ್ ಶಿಕಿವತ್ಯೊ ಮನ್ಹುನ್ ಖುಬ್ ಲೊಕ ಮಾಜಿ ನಿಂದಾ ಕರ್ತ್ಯಾತ ತೀ ಲೊಕ ಚು಼ಕಿಚಿ ಮನ್ಹುನ್ ಸಾಂಗಾಚ಼ ಶಾರ್ಕ. ");
INSERT INTO gok_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","ತಸಜಾ಼ಲ್ಯಾ ಆಮಿ ಕ್ಯಾ ಸಾಂಗುಯಾ? ಯಹುದಿ ಜಾ಼ಲ್ಯಾಲ ಆಮಿ ಯೆಹುದಿ ನಸ್‍ಲ್ಯಾಲ್ಯಾಂಚಾವ್ನಿ ಚಾ಼ಂಗ್ಲ ಹಾವ್ ಕ್ಯಾ? ಜ಼ರಾಬಿ ನಾಹಿ! ಯಹುದಿ ವ್ಹವುಂತ ಯಹುದಿ ನಸ್‌ಲ್ಯಾಲಿ ವ್ಹವುಂತ ಸಗ್ಳಿ ಪಾಪಾಚಾ ಅಧಿಕಾರಾತ್ ಹಾತ್ತ ಮನ್ಹುನ್ ಮೀ ತುಮಾನಾ ಆಂದಿಸ್ ದಾವುನ್ ದಿಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","ಪವಿತ್ರ ಗ್ರಂಥ ಆಸ ಸಾಂಗ್ತ: “ನಿಯತಿಚಾ಼ ಯೊಕ್ಬಿ ನಾಹಿ. ನಾಹಿಸ್ನಾಹಿ! ");
INSERT INTO gok_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","ಕೊನುಸ್ ಗಿನ್ಯಾನ್ ಆಸ್‌ಲ್ಯಾಲಾ ನಾಹಿ ನಾಹಿತ ದೇವಾಲಾ ಶೊತ್ಯಾಲಾ ಕೊನುಸ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","ಸಗ್ಳಿ ದೇವಾಚೆ ಆಡ್ವಿ ಪರಾತ್ಲಿತ ಸಗ್ಳಿ ಲೊಕ ಕಾಮಾಲಾ ಯಯಿನಸ್ನಾರಿ ಜಾ಼ಲ್ಯಾತ ಚಾ಼ಂಗ್ಲ ಕರ್ತ್ಯಾಲಾ ಯೊಕ್ಬಿ ನಾಹಿ. ನಾಹಿಸ್ನಾಹಿ! ");
INSERT INTO gok_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","ಲೊಕಾಂಚಿ ತೊಂಡ ಉಗಾಡ್‌ಲ್ಯಾಲೆ ಮಸುರ್ಡಿಚೆಗತ್ ಹಾತ್ತ. ತ್ಯಂಚಾ ಬೊಲ್ಯಾ ಮೊಸಾನಿ ಬರ್ಲ್ಯಾತಾ ತ್ಯಂಚಾ ಜಿಬಿ ಲಬಾಡಾನಿ ಬರ್ಲ್ಯಾತಾ ತ್ಯಂಚಾ ವಟಾವ ಸಾಪಾಚ಼ ಈಸ್ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","ತ್ಯಂಚಾ ತೊಂಡಾತ್ ಸರಾಪ್ ಆನಿ ಕಡುಫನ್ ಬರ್ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","ತರಾಸ್ ದಿಯಾ ಆನಿ ಮಾರುನ್ ಟಾಕಾಯಾ ತೀ ಕವಾಬಿ ತಯಾರ್ ಹಾತ್ತ. ");
INSERT INTO gok_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","ತೆ ಜಾ಼ಯಿಲ್ ತಿಥ ಪಿಡಾ ಆನಿ ನಾಸ್ ತರಾಸ್ ರಾತ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","ತ್ಯನಾ ಸಮಾದಾನಾಚಾ಼ ಮಾರ್ಗ ಸಮಾಜ್ಲಾ಼ ನಾಹಿ.” ");
INSERT INTO gok_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","ತ್ಯಂಚೆ ನದ್ರಲಾ ದೇವಾಚ಼ ಭ್ಯಾ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","ಧರ್ಮಶಾಸ್ತಾರ್ ಕ್ಯಾ ಹಾ ಮನ್ಹುನ್ ಆಮಿ ಸಗ್ಳ ಸಮಜು಼ನ್ ಗೆತಲ್ಯಾ. ಧರ್ಮಶಾಸ್ತಾರಾಚಾ ತಾಬ್ಯಾತ್ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ಲೊಕಾಂಚೆ ಗುಶ್ಟಿತ್ ಸಾಂಗ್ತ, ಮನ್ಹುನ್ ಸಗ್ಳಿ ತೊಂಡ ಜಾ಼ಕ್ನಾರ್ ಆನಿ ಸಗ್ಳಿ ದುನ್ಯಾ ದೇವಾಲಾ ಲೆಖಾ ದಿಯಾವ್ಹಯಿ. ");
INSERT INTO gok_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","ಕಾ ಮಂಜೆ ಧರ್ಮಶಾಸ್ತಾರಾಚೆಗತ್ ಚಾ಼ಲತ್ಯಾಲಾ ಪರತೇಕ್ ಮಾನುಸ್ ದೇವಾಚೆ ನದ್ರಲಾ ನೀಯತಿಚ಼ ವ್ಹಯಾ ಕುನಾಲಾಸ್ ವ್ಹಯಿತ್ನಾಹಿ. ತ್ಯ ಆಮಚ಼ ಪಾಪ್ ತ್ಯವ್ಡಸ್ ದ್ಯಾವ್ತ. ");
INSERT INTO gok_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","ಫನ್ ಆತಾ ಮಾನ್ಸಾಸಾಟಿ ದೇವಾನಿ ಹ್ಯ ದಾವುನ್ ದಿಲ್ಯಾ ತ್ಯೊ ದರ್ಮಶಾಸ್ತಾರಾಚೆ ಸಿವಾರ್ ನೀಯತಿಚಾ಼ ಕರ್ತೊ ಯವ್ಡಸ್ ನವ್ಹ ಹೇ ಬುಲಿಚಿ ವಳಕ್ ಮೊಶೆಚಾ಼ ನೇಮ್ ಆನಿ ಪ್ರವಾದಿ ಜಾ಼ಲ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","ದೇವ್ ಲೋಕಾನಾ ಯೇಸು ಕ್ರಿಸ್ತಾವ ಆಸ್‍ಲ್ಯಾಲ್ಯಾ ಇಸ್ವಾಸಾನಿ ತ್ಯನಿ ಭಕ್ತಿಚ಼ ಮನ್ಹುನ್ ಥರಿವ್ಲ ದೇವಾಪ ಕಸ್ಲಾ ಬೇದ್ ಭಾವ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","ಸಗ್ಳಿ ಲೊಕ ಪಾಪ್ ಕರುನ್ ದೇವಾಚಿ ಮೈಮಾ ಗಿಹ್ಯಾಚೆ ಆಂದಿ ಹಾತ್ತ. ");
INSERT INTO gok_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","ಫನ್ ಯೇಸು ಕ್ರಿಸ್ತಾಚೆ ಸುಟ್ನುಕಿನಿ ದೇವಾಚೆ ಫುಕಟ್ಚೆ ಕ್ರಪೆನಿ ತ್ಯಚೆ ಮೊರ‍್ಹ ಆಮಿ ನಿಯತಿಚ಼ ಮನ್ಹುನ್ ಥರ್ಲ್ಯಾವ್. ");
INSERT INTO gok_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","ದೇವಾನಿ ಇಸ್ವಾಸಾಸ್ ಲಾಗುನ್ ಲೋಕಾಂಚಿ ಪಾಪ ಮಾಪ್ ಕರ್ತ್ಯಾಲಾ ಮಾರ್ಗ ಕೆಲ್ಯಾ. ತ್ಯೊ ಮಾರ್ಗ ಯೇಸು. ಕ್ರಿಸ್ತಾಚಾ ರಕ್ತಾನಿಸ್ ಪಾಪ ಮಾಪಿ ಕೆಲ್ಯಾತ. ದೇವಾನಿ ಕೇಲ್ಯಾಲ ಕವಾಬೀ ಶಾರ್ಕ ರಾಥ ಆನಿ ಶಾರ್ಕ ರಾಥ ಮನ್ಹುನ್ ಹ್ಯ ದ್ಯಾವ್ತ. ದೇವ್ ಮಾಗ್‌ಲ್ಯಾ ಕಾಲಾತ್ ಥಂಡ್ ಫನಾನಿ ರಾಹುನ್ ಲೋಕಾನಾ ತ್ಯಂಚಾ ಪಾಪಾತ್ನಿ ಶಿಕ್ಶಾ ದಿಯಾಚೆ ಆಂದಿ ಗೇಲಾತರಿ ದೇವ್ ನೀಯತಿಚಾ಼ ಜಾ಼ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","ಆಸ ದೇವಾನಿ ಆಪ್ನು ನೀಯತಿಚಾ಼ ಮನ್ಹುನ್ ಆನಿ ಯೇಸುವ ಇಸ್ವಾಸ್ ಥೆವ್‌ತ್ಯಾಲಾ ಕೋನ್ಬಿ ವ್ಹವುನಿ ನೀಯತಿಚಾ಼ ಕರ್ತೊ ಮನ್ಹುನ್ ದ್ಯಾವ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","ತಸಜಾ಼ಲ್ಯಾ ಆಮಾನಾ ಆಮಿ ವವ್ಯಾಳುನ್ ಗಿಹ್ಯಾ ಆವಕಾಸ್ ಕುಠಹಾ? ಕುಠಸ್ನಾಹಿ! ಆನಿ ಹ್ಯಲಾ ಕ್ಯಾ ಕಾರನ್ ಹಾ? ಆಮಿ ಧರ್ಮಶಾಸ್ತಾರ್ ಪಾಳಾಚ಼ ಕಾರನ್ ಹ್ಯ ಕ್ಯಾ? ನಾಹಿ! ಫನ್ ಆಮಿ ಕಚಾವ ಇಸ್ವಾಸ್ ಥೆವ್ತಾವ್ ತ್ಯ ಆಮಚಾ ವವ್ಯಾಳನ್ಯಾಲಾ ಕಾರನ್ ಜಾ಼ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","ಸರ್ತ್ಯಾಲಾ ಮೀ ಹ್ಯ ಸಾಂಗ್ತೊ ಕಚಾ಼ ಮಾನುಸ್ ಧರ್ಮಶಾಸ್ತಾರಾಚೆಗತ್ ಚಾ಼ಲ್ತೊ ಮನ್ಹುನ್ ನವ್ಹ. ನಿಸ್‍ಥ್ಯಾ ಇಸ್ವಾಸಾನಿಸ್ ತ್ಯೊ ನೀಯತಿಚಾ಼ ಮನ್ಹುನ್ ಗೆನ್ಹಾರ್. ");
INSERT INTO gok_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","ನಾಹಿತ ದೇವ್ ನಿಸ್ಥಾ ಯಹುದ್ಯಾನಾ ತ್ಯವ್ಡಾಸ್ ಕ್ಯಾ? ತ್ಯೊ ಯಹುದಿ ನಸ್‌ಲ್ಯಾಲ್ಯಾನಾ ದೇವ್ ನವ್ಹ ಕ್ಯಾ? ಖರ‍್ಯಾನಿಸ್ ವ್ಹಯ್ ತ್ಯೊ ಯೆಹುದಿ ನಸ್‍ಲ್ಯಾಲ್ಯಾನಾಬಿ ದೇವ್ ಜಾ಼ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","ದೇವ್ ಯೊಕುಸ್. ತ್ಯೊ ಯಹುದ್ಯಾಂಚಾ಼ ತ್ಯವಡಾಸ್ ನವ್ಹ. ಯೆಹುದ್ಯಾನಾ ಯಹುದಿ ನಸ್‌ಲ್ಯಾಲ್ಯಾನಾ ತ್ಯಂಚಾ ಇಸ್ವಾಸಾನಿ ನೀಯತಿಚ಼ ಕರ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","ಆಮಿ ಹ್ಯಾ ಇಸ್ವಾಸಾನಿ ಧರ್ಮಶಾಸ್ತಾರ್ ದುರ್ ಕರ್ತ್ಯಾವ್ ಕ್ಯಾ? ನಾಹಿ ಖರ‍್ಯಾನಿಸ್ ನಾಹಿ! ಹ್ಯಚೆ ಬದ್ಲಿ ಆಮಿ ಧರ್ಮಶಾಸ್ತಾರ್ ಉಚ್ಲು಼ನ್ ದರ್ಥಾವ್. ");
INSERT INTO gok_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","ತಸ ಜಾ಼ಲ್ಯಾವ, ಆಮಚಾ಼ ವಡಿಲ್ ಜಾ಼ಲ್ಯಾಲ್ಯಾ ಅಬ್ರಹಾಮಾಚೆ ಗುಶ್ಟಿತ್ ಆಮಿ ಕ್ಯಾ ಸಾಂಗುಯಾ? ತ್ಯೊ ಇಸ್ವಾಸಾಚೆ ಗುಶ್ಟಿತ್ ತ್ಯಚಾ಼ ಕ್ಯಾ ಅನುಭವ್ ಜಾ಼ಲ್ಥಾ? ");
INSERT INTO gok_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","ಫನ್ ತ್ಯೊ ಆಪ್‍ಲ್ಯಾ ಚಾ಼ಂಗಲ್ಯಾ ಕಾಮಾನಿ ನೀಯತಿಚಾ಼ ಜಾ಼ಲ್ಯಾವ ವವ್ಯಾಳುನ್ ಗಿಹ್ಯಾ ತ್ಯಲಾ ಕಾರನ್ ರಾಹಿತ. ಫನ್ ಅಬ್ರಹಾಮಾಲಾ ದೇವಾಚೆ ಮೊರ‍್ಹ ವವ್ಯಾಳುನ್ ಗಿಹ್ಯಾ ಜಾ಼ಲ್ಹ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","ಅಬ್ರಾಹಾಮಾನಿ ದೇವಾವ ಇಸ್ವಾಸ್ ಥೆವ್ಲಾ. ದೇವಾನಿ ಅಬ್ರಹಾಮಾಚಾ ಇಸ್ವಾಸಾಚಾ ಕಾರ್ನಾನಿ ನೀಯತಿಚಾ಼ ಮನ್ಹುನ್ ಗೇತ್ಲಾ. ಆಸ ಪವಿತ್ರ ಗ್ರಂಥ ಸಾಂಗ್ತ. ");
INSERT INTO gok_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","ರಾಬ್‌ತ್ಯಾಲ್ಯಾಲಾ ಗಾವತ್ಯಾಲಾ ಪಗಾರ್ ದಾನ್ ನವ್ಹ, ತ್ಯಚಿವ ತ್ಯಲಾ ಹುಕುಮ್ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","ಫನ್ ಕೊನ್ ಪುನ್ಯಾಚಿ ಕಾಮ ಕರುನ್ ಪಾಪಿನಾ ನಿಯೆತಿಚ಼ ಮನ್ಹುನ್ ಥರಿವತ್ಯಾಲ್ಯಾವಿಸ್ವಾಸ್ ಥೆವ್ತೊ ತ್ಯಚಾ಼ಸ್ ಇಸ್ವಾಸ್ ನಿಯೆತಿಚಾ಼ ವ್ಹತೊ. ");
INSERT INTO gok_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","ದೇವಾನಿ ಯಕಾಚ಼ ಚಾ಼ಂಗ್ಲ ಕಾಮ್ ಬಗಾಚೆ ಆಂದಿ ತ್ಯಲಾ ನೀಯತಿಚಾ಼ ಮನಲ್ಯಾವ ತ್ಯೊ ಖರ‍್ಯಾನಿಸ್ ಬರ‍್ಯಾ ನಸಿಬಾಚಾ಼ ಮನ್ಹುನ್ ದಾವಿದಾನಿ ಸಾಹಿತ್ ಸಾಂಗ್‌ಲ್ಯಾ: ಕಸ ಮಂಜೆ ");
INSERT INTO gok_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","ಕುನಾಚಿ ಪಾಪ ಮಾಪಿ ಜಾ಼ಲ್ಯಾತ ತ್ಯಂಚಾ ಚು಼ಕಿ ಜಾ಼ಕುನ್ ಹಾತ್ತಾ ತೇ ಖರ‍್ಯಾನಿಸ್ ಬರ‍್ಯಾ ನಸಿಬಾಚ಼! ");
INSERT INTO gok_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","ಪ್ರಭು ಕುನಾಚ಼ ಪಾಪ್ ಯದತ್ ದರಿತ್ನಾಹಿ ತ್ಯೊ ಖರ‍್ಯಾನಿಸ್ ಬರ‍್ಯಾ ನಸಿಬಾಚಾ಼ ");
INSERT INTO gok_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","ಹೆ ನಸಿಬ್‌ ಮುಂಜಿ ಕರುನ್ ಗೆತಲ್ಯಾಲ್ಯಾನಾ ತ್ಯವ್ಡಸ್ ಕ್ಯಾ? ಮುಂಜಿ ಕರುನ್ ಗೆತಲ್ಯಾ ನಸ್‌ಲ್ಯಾಲ್ಯಾ ಲೊಕಾನಾಬಿ ಜಾ಼ಲ್ಯಾ. ಕಾ ಮಂ ಜೆ “ಅಬ್ರಹಾಮಾನಿ ದೇವಾವ ಇಸ್ವಾಸ್ ಥೆವ್ಲಾ ತ್ಯಚಾ ಇಸ್ವಾಸಾನಿಸ್ ತ್ಯಲಾ ನೀಯೆತಿಚಾ಼ ಕೆಲಾ ” ಹ್ಯ ಪವಿತ್ರ ಪುತಿಕಾತ್ ಲಿವ್‍ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","ಹ್ಯ ಕವಾ ಜಾ಼ಲ? ತ್ಯಲಾ ಮುಂಜಿ ವ್ಹಹ್ಯಾಚೆ ಆಂದಿ ಕ್ಯಾ ಮುಂಜಿ ಜಾ಼ಲ್ಯಾವ? ಮುಂಜಿ ವ್ಹಹ್ಯಾಚೆ ಆಂದಿಸ್. ");
INSERT INTO gok_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","ದೇವಾನಿ ಆಪಲ್ಯಾಲಾ ಗೆತಲ್ಯಾ ಮನ್ಹುನ್ ದಾವುನ್ ದಿಯಾ ಸಾಟಿ ಅಬ್ರಾಹಾಮಾನಿ ನಂತರ್ ಮುಂಜಿ ಕರುನ್ ಗೆತ್ಲಿ ಅಬ್ರಾಹಾಮಾನಿ ಮುಂಜಿ ಕರುನ್ ಗಿಹ್ಯಾಚೆ ಆಂದಿ ಇಸ್ವಾಸಾನಿಸ್ ನೀಯತಿಚಾ಼ ಜಾ಼ಲ್ಥಾ ಮಂಥ್ಯಾಲ್ಯಾಲಾಸ್ ತ್ಯಚಿ ಮುಂಜಿ ಆದಾರ್ ಜಾ಼ಲೆ. ತ್ಯಾ ಕಾರ್ನಾನಿ ಇಸ್ವಾಸ್ ಥೆವ್‌ತ್ಯಾಲ್ಯಾ ಸಗ್‌ಳ್ಯಾ ಲೊಕಾನಾ ತ್ಯಂಚಾನಿ ಮುಂಜಿ ಕರುನ್ ಗಿತ್ಲಿ ನಸ್ಲಿ ತರಿ ಅಬ್ರಾಹಾಮ್ ಆತ್ಮಿಕ್ ಬಾ ಜಾ಼ಲ್ಯಾ ಕಾ ಮಂಜೆ ತೇ ಆಪ್‌ಲ್ಯಾ ಇಸ್ವಾಸಾಸ್ ಲಾಗುನ್ ನೀಯತಿಚ಼ ಮನ್ಹುನ್ ಗಿಥಿಲ. ");
INSERT INTO gok_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","ತ್ಯವ್ಡಸ್ ನವ್ಹ ಮುಂಜಿ ಕರುನ್ ಗೆತಲ್ಯಾಲ್ಯಾ ಲೊಕಾನಾ ಸಾಹಿತ್ ಅಬ್ರಹಾಮ ಆತ್ಮಿಕ್ ಬಾ ಜಾ಼ಲ್ಯಾ ಫನ್ ತ್ಯನಾ ಆಪ್ಲಾ ಬಾ ಮನ್ಹುನ್ ಕರ್ತ್ಯಾಲಾ ತ್ಯಂಚಿ ಮುಂಜಿ ನವ್ಹ. ಆಮಚಾ಼ ಬಾ ಜಾ಼ಲ್ಯಾಲಾ ಅಬ್ರಾಹಾಮ್ ಮುಂಜಿ ಕರುನ್ ಗಿಹ್ಯಾಚೆ ಆಂದಿ ಗೆತಲ್ಯಾಲ್ಯಾ ಇಸ್ವಾಸಾಚೆಗತ್ ತ್ಯಂಚಾನಿ ಜಿವ್ನಾ ಕೇಲಾತಸ್. ತ್ಯೊ ತ್ಯನಾ ಬಾ ಜಾ಼ಲ್ಯಾ ");
INSERT INTO gok_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","ಅಬ್ರಹಾಮಾಲಾ ಆನಿ ತ್ಯಚೆ ಪಿಳ್ಗಿಲಾ ದುನ್ಯಾ ಸಗ್ಳಿ ದೇತೊ ಮನ್ಹುನ್ ದೇವಾನಿ ಸಬ್ದ ದಿಲ್ಯಾ ಫನ್ ಅಬ್ರಾಮಾನಿ ತ್ಯೊ ಸಬ್ದ ಗೆತಲ್ಯಾಲಾ ಧರ್ಮಶಾಸ್ತಾರಾಚೆಗತ್ ಚಾ಼ಲ್ಯಾಲಿ ನವ್ಹ ಆಬ್ರಹಾಮ್ ಇಸ್ವಾಸಾನಿ ನೀಯತಿಚಾ಼ ಜಾ಼ಲ್ಯಾಲ್ಯಾ ಕಾರ್ನಾನಿ ತ್ಯೊ ಸಬ್ದ ಗೇತ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","ಆಸ ಆಸ್ಥಾನಾ ದೇವಾನಿ ಸಬ್ದ ದಿಲ್ಯಾಲಾ ಲೋಕ ಧರ್ಮ ಶಾಸ್ತಾರಾಚೆಗತ್ ಚಾ಼ಲಾಯಾ ಗಿಹ್ಯಾ ಜಾ಼ಲ್ಹಾತ, ಇಸ್ವಾಸ್ ಉಪೇಗ್ ನಸ್‌ಲ್ಯಾಲಾ ಜಾ಼ಲ್ಯಾ. ತ್ಯವ್ಡಸ್ ನವ್ಹ ದೇವಾನಿ ಆಬ್ರಾಹಾಮಾಲಾ ದಿಲ್ಯಾಲಾ ಸಬ್ದ ಉಪೇಗ್‌ನಸ್‌ಲ್ಯಾಲಾ ಜಾ಼ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","ಧರ್ಮಶಾಸ್ತಾರಾಚೆಗತ್ ತ್ಯಂಚಿವ ದೇವಾಚಾ಼ ರಾಗ್ ಉತ್ರುನ್ ಯತೊ ಫನ್ ಧರ್ಮಶಾಸ್ತಾರ್ ನಾಹಿ ತಿಥ ಧರ್ಮಶಾಸ್ತಾರ್ ಪಾಳಾಚೆ ಆಂದಿ ಆಸ್‍ಲ್ಯಾಲಿ ಪ್ರಶ್ನೆ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","ತ್ಯಾ ಕಾರ್ನಾನಿ ಲೊಕ ಇಸ್ವಾಸಾಸ್ ಲಾಗುನ್ ದೇವಾಚಾ಼ ಸಬ್ದ ಗೇನ್ಹಾರ್. ತ್ಯ ಫುಕಟ್ ದಿಲ್ಯಾಲ ವ್ಹಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಆಸ ಜಾ಼ಲ್ಹ. ತ್ಯ ಫುಕಟ್ ಜಾ಼ಲ್ಯಾಲ ಜಾ಼ಲ್ಯಾವ ಅಬ್ರಹಾಮಾಚಿ ಪಿಳ್ಗಿ ಸಗ್ಳಿ ತ್ಯೊ ಸಬೋತ್ ಗೆಥ್ಯಾತ. ಹ್ಯೊ ಸಬ್ದ ಮೊಶೆಚಾ ಧರ್ಮಾಶಾಸ್ತಾರಾಚೆಗತ್ ಚಾ಼ಲತ್ಯಾಲ್ಯಾ ಲೊಕಾನಾ ತ್ಯವ್ಡಾಸ್ ನವ್ಹ, ಅಬ್ರಾಹಾಮಾಚೆಗತ್ ಇಸ್ವಾಸಾನಿ ಚಾ಼ಲತ್ಯಾಲ್ಯಾ ಸಗ್‌ಳ್ಯಾ ಲೊಕಾನಾ ದಿಲ್ಯಾ. ಕಾ ಮಂಜೆ ಅಬ್ರಾಹಾಮ್ ಆಮಾನಾ ಸಗ್‌ಳ್ಯಾನಾ ಆತ್ಮಿಕ್ ಬಾ ಜಾ಼ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","ಮೀ ತುಲಾ ಖುಬ್ ಲೊಕಾನಾ ಆತ್ಮಿಕ್ ಬಾ ಕೆಲ್ಯಾ. ಮನ್ಹುನ್ ಪವಿತ್ರ ಗ್ರಂಥಾತ್ ಲಿವ್‌ಲ್ಯಾ ಹ್ಯ ದೇವಾಚೆ ಮೊರ‍್ಹ ಖರ ಜಾ಼ಲ್ಯಾ ಮೇಲ್ಯಾಲ್ಯಾನಾ ಜೀವ್ ದೇನಾರಾ ಆಜು಼ನ್ ಗಡ್‌ಲ್ಯಾ ನಸ್‌ಲ್ಯಾಲಿ ಕಾಮ ಕರ್ನಾರಾ ಜಾ಼ಲ್ಯಾಲ್ಯಾ ದೇವಾವ ಅಬ್ರಾಹಾಮಾನಿ ಇಸ್ವಾಸ್ ಥೆವ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","ಅಬ್ರಾಹಾಮಾಲಾ ಪೊರ ವ್ಹತಿಲ ಮನ್ಹುನ್ ಇಸ್ವಾಸ್ ನವ್ಥಾ. ಫನ್ ತ್ಯೊ ದೇವಾವ ಇಸ್ವಾಸ್ ಥಿವುನ್ ಆಪ್ಲೆ ಆಶೆನಿ ಮೊರ‍್ಹ ಸರ್ಲಾ. ತ್ಯಾಸ್ ಕಾರ್ನಾನಿ ತ್ಯೊ ಖುಬ್ ದೆಶೆನಾ ಆತ್ಮಿಕ್ ಬಾ ಜಾ಼ಲ್ಹಾ. ದೇವ್ ತ್ಯಲಾ ತು ಖುಬ್ ಲೊಕಾನಾ ಗೆನಾರ್” ಪವಿತ್ರ ಗ್ರಂಥಾತ್ ತುಜಿ ಪಿಳ್ಗಿ ಆಬ್ಳಾತ್‌ಲ್ಯಾ ಚಾನ್ಯಾಂಚೆಗತ್ ರಾನಾರ್ ಮನ್ಹುನ್ ಪವಿತ್ರ ಗ್ರಂಥ ಸಾಂಗ್ತ. ");
INSERT INTO gok_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","ಅಬ್ರಾಹಾಮಾಲಾ ಜ಼ವ ಜ಼ವಳ್ ಶೆಂಬರ್ ವರ್ಸ ಜಾ಼ಲ್ಥಿತ. ತವಾ ತ್ಯಚ಼ ಶರಿರ್ ಬಳ್ ನಸ್‌ಲ್ಯಾಲ ಜಾ಼ಲ್ಥ. ಮನ್ಹುನ್ ತ್ಯಲಾ ಪೊರ ವ್ಹತಿಲ ಆಶಿ ಆಶಾ ನವ್ತಿ. ನಾಹಿತ ಸಾರಾಳಾಲಾ ಸಾಹಿತ್ ಪೊರ ವ್ಹಯಿತಿಲ ಮನ್ಹುನ್ ಆಶಾ ನವ್ತಿ. ಫನ್ ದೇವಾವ ಆಸಲ್ಯಾಲಾ ತ್ಯಚಾ಼ ಇಸ್ವಾಸ್ ಕಮ್ಮಿ ಜಾ಼ಲ್ಹಾ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","ದೇವಾನಿ ದಿಲ್ಯಾಲ್ಯಾ ಸಬ್ದಾಚೆ ಗುಶ್ಟಿತ್ ತ್ಯಲಾ ಸಂಶೆವ್ ಆಲಾ ನಾಹಿ. ಆನಿ ಆಪ್ಲಾ ಇಸ್ವಾಸ್ ನಾಹಿ ಕೆಲಾನಾಹಿ. ತ್ಯಚಾ ಇಸ್ವಾಸಾನಿಸ್ ತ್ಯಲಾ ಬಳ್ ದಿಲ ಆನಿ ದೇವಾಲಾ ಸ್ತೊತ್ರ ಕಿಲಿತ. ");
INSERT INTO gok_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","ದೇವಾನಿ ಆಪ್ನು ದಿಲ್ಯಾಲಾ ಸಬ್ದ ಖರ‍್ಯಾನಿಸ್ ಚಾ಼ಲಿವ್ನಾರ್ ಮನ್ಹುನ್ ಆಬ್ರಾಹಾಮಾನಿ ಘಟ್ ಇಸ್ವಾಸ್ ಥೆವ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","ಮನ್ಹುನ್, “ದೇವಾನಿ ಅಬ್ರಾಹಾಮಾಲಾ ತ್ಯಚಾ ಇಸ್ವಾಸಾನಿ ತ್ಯಲಾ ನಿಯತಿಚಾ಼ ಮನ್ಹುನ್ ಕೇಲಾ. ” ");
INSERT INTO gok_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","ನಿಯತಿಚಾ಼ ಮಂಥ್ಯಾಲಾ ಹ್ಯೊ ಸಬೊತ್ ತ್ಯಾ ಬೊಲ್ಯಾ ಲಿವ್‌ಲ್ಯಾಲ್ಯಾ ಅಬ್ರಹಾಮಾಲಾ ತ್ಯವಡ್ಯಾಸ್ ನವ್ಹತಾ. ");
INSERT INTO gok_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","ತ್ಯಾ ಆಮ್ಚಾ ಪ್ರಭುಜಾ಼ಲ್ಯಾಲ್ಯಾ ಯೇಸುಲಾ ಜೀವಂತ್ ಉಠಿವಲ್ಯಾಲ್ಯಾವ ಇಸ್ವಾಸ್ ಥೆವ್‍ಲ್ಯಾಲಾ ಆನಿ ನಿಯತಿಚ಼ ಮನ್ಹುನ್ ಸ್ವಿಕಾರ್ ಕರುನ್ ಗೇತ್‍ಲ್ಯಾಲ್ಯಾ ಆಮ್ಚಿ ಸಾಟಿ ಸಾಹಿತ್ ಲಿವ್‍ಲ್ಯಾತಾ. ");
INSERT INTO gok_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","ಆಮ್ಚಾ ಪಾಪಾಸ್ ಲಾಗುನ್ ಯೇಸುಲಾ ಮರಾಯಾ ದಿಲಾ. ಆಮಾನಾ ನಿಯತಿಚ಼ ಮನ್ಹುನ್ ಥರ್ವಾಯಾ ತ್ಯಲಾ ಮೇಲ್ಯಾಲ್ಯಾತ್ನಿ ಪುನಾ ಜಿತ್ತಾ ಉಠೀವ್ಲಾ. ");
INSERT INTO gok_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","ಆಸ ಆಸ್ಥಾನಾ, ಆಮಿ ಇಸ್ವಾಸಾನಿ ನೀಯತಿಚಿ ಹಾವ್. ತ್ಯಾ ಕಾರ್ನಾನಿ ಆಮಚಾ಼ ಪ್ರಭುಜಾ಼ಲ್ಯಾಲ್ಯಾ ಯೇಸು ಕ್ರಿಸ್ತಾಸ್ ಲಾಗುನ್ ಆಮಾನಾ ದೇವಾ ಸಂಗ ಸಮಾದಾನ್ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","ತ್ಯನಿ ಆಮಾನಾ ಆಮ್ಚಾ ಇಸ್ವಾಸಾಸ್ ಲಾಗುನ್ ದೇವಾಚಿ ಕ್ರಪೆ ಗೇತ್ಲೆ ಆತಾ ಆಮಿ ತ್ಯಾತ್ ಜೀವ್ನಾ ಕರ್ತ್ಯಾವ್ ಮನ್ಹುನ್ ದೇವಾಚೆ ಮೈಮೆತ್ ಆಮಿ ವಾಟದಾರ್ ವ್ಹನಾರ್ ಮನ್ಯಾಚಿ ಆಶಾ ಆಮಾನಾ ಹಾ ಮನ್ಹುನ್ ಆಮಿ ಬಡಾಯಿ ಕರ್ತಾವ್. ");
INSERT INTO gok_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","ನಾಹಿತ, ಆಮ್ಚಾತ್ ಕಸ್ಟಾತ್ ತರಾಸಾತ್ ಹೆಮ್ಮೆನಿ ಹಾವ್ ಕಾ ಮಂಜೆ, ಹ್ಯೊ ಕಸ್ಟ ತರಾಸ್ ಆಮ್ಚಾತ್ ಖುಬ್ ಥಂಡ್ ಫನ್ ಆಂತೊ. ");
INSERT INTO gok_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","ದಿರಾನಿ ಚಾ಼ಂಗ್ಲಾ ಸ್ವಭಾವ್ ಉತ್ಪನ್ ವ್ಹತ್ತೊ. ಹ್ಯಾ ಚಾ಼ಂಗಲ್ಯಾ ಸಭಾವಾನಿ ಇಸ್ವಾಸ್ ವ್ಹತ್ತೊ. ಹಿ ಆಶಾ ಆಮಾನಾ ಕವಾಸ್ ನಿರಾಶ್ ಕರಿತ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","ಕಾ ಮಂಜೆ ದೇವಾನಿ ಆಮಾನಾ ಬೊಮಾನ್ ದಿಲ್ಯಾಲ್ಯಾ ಪವಿತ್ರಾತ್ಮಾಸ್ ಲಾಗುನ್ ಆಪ್ಲಿ ಮಾಯಾ ಆಮ್ಚಾ ಮನಾತ್ ಗ್ಯಾತ್ಲೆ. ");
INSERT INTO gok_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","ಆಮಿ ಆಶೆತ್ ನಸ್ಥಾನಾ ದೇವಾನಿ ನಿವಡ್‍ಲ್ಯಾಲ್ಯಾ ಯಳಾಲಾ ಕ್ರಿಸ್ತ ಆಮ್ಚಾ ಬುರ್ಶಾಚೆ ಸಾಟಿ ಮೇಲಾ. ");
INSERT INTO gok_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","ನಿಯೆತಿಚಾ ಸಾಟಿ ಕೊನ್ತರಿ ಮೆಲ್ಯಾವ ಮರಲ್. ಚಾ಼ಂಗಲ್ಯಾ ಸಾಟಿ ಮರಾಯಾ ಖರ‍್ಯಾನಿ ಕೊನ್ತರಿ ಧಿರ್ ಕೆಲ್ಯಾವ ಕರಿಲ್. ");
INSERT INTO gok_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","ಫನ್ ಆಮಿ ಆಜು಼ನ್ ಪಾಪಿ ಆಸ್ಥಾನಾಸ್ ಕ್ರಿಸ್ತಾನಿ ಆಮ್ಚಾ ಪಾಪಾ ಸಾಟಿ ಜೀವ್ ದಿಲಾ ಹ್ಯಚಿಸ್ ಲಾಗುನ್ ದೇವಾನಿ ಆಪ್ಲಿ ಮಾಯಾ ದಾವುನ್ ದಿಲಿ. ");
INSERT INTO gok_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","ಆಮಿ ಕ್ರಿಸ್ತಾಚಾ ರಕ್ತಾನಿ ದೇವಾಚೆ ಮೋರ‍್ಹ ಆಮಿ ನೀಯತಿಚ಼ ಜಾ಼ಲ್ಯಾವ್ ಮನ್ಹುನ್ ತ್ಯಚಿಸ್ ಲಾಗುನ್ ದೇವಾಚಾ ರಾಗಾತ್ನಿ ಖರ‍್ಯಾನಿಸ್ ಚ಼ುಕ್ವುನ್ ಗೆಥಾವ್ ");
INSERT INTO gok_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","ಮಂಜೆ ಆಮಿ ದೇವಾಚ಼ ವಾದಿ ಜಾ಼ಲ್ಯಾಲ ವ್ಹತ್ತಾವ್ ತವಾಸ್ ದೇವಾನಿ ಆಪ್‌ಲ್ಯಾ ಲೇಕಾಚಾ ಮರ್ನಾನಿ ಆಮಾನಾ ಆಪ್ಲ ಸುಪ್ತಿ ಕೇಲ್ಯಾತ. ಆತಾ ಆಮಿ ದೇವಾಚ಼ ಸುಪ್ತಿ ಜಾ಼ಲ್ಯಾವ್ ಆಸ ಆಸ್ಥಾನಾ ಆತಾ ಕ್ರಿಸ್ತಾಚಾ ಜೀವ್ನಾಸ್ ಲಾಗುನ್ ತ್ಯೊ ಆಮ್ಚಿ ಕಿತಿ ಖುಬ್ ರಕ್ಶನ್ ಕರಿಲ್. ");
INSERT INTO gok_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","ಯವ್ಡಸ್ ನವ್ಹ, ಆಮ್ಚಾ ಪ್ರಭುಜಾ಼ಲ್ಯಾಲ್ಯಾ ಯೇಸು ಕ್ರಿಸ್ತಾಸ್ ಲಾಗುನ್ ಆಮಿ ದೇವಾನಿ ಕೆಲ್ಯಾಲ್ಯಾ ಕಾಮಾನಿ ಸಂತೋಶಾನಿ ರಾಥಾವ್. ಆತಾ ಆಮಿ ದೇವಾಚ಼ ಸುಪ್ತಿ ವ್ಹಯಾಚ಼ ತ್ಯಚಿಪ್ನಿಸ್. ");
INSERT INTO gok_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","ಯೊಕ್ ಮಾನುಸ್ ಆದಾಮಾನಿ ಕೇಲ್ಯಾಲ್ಯಾ ಕಾಮಾನಿ ಪಾಪ್ ಹೇ ದುನೆತ್ ಆಲ. ಹ್ಯಾ ಕಾರ್ನಾನಿ ಸಗ್ಳೆ ಮಾನ್ಸಾಚೆ ಜಾ಼ತಿತ್ನಿ ಮರಾನ್ ಪಗಾಳ. ತಚಿಸ್ ಲಾಗುನ್ ಸಗ್ಳಿ ಲೋಕ ಮರಾಯಾಸ್ ವ್ಹಯಿ. ಕಾ ಮಂಜೆ ಸಗ್‌ಳ್ಯಾ ಲೋಕಾಂಚಾನಿ ಪಾಪ್ ಕೇಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","ಮೊಶೆಚಾ ಧರ್ಮಶಾಸ್ತಾರಾಚೆ ಆಂದಿ ಹೇ ದುನೆತ್ ಪಾಪ್ ಹುತ್ತ. ಫನ್ ಧರ್ಮಶಾಸ್ತಾರ್ ಯಯಿ ಪರೆತ್ ಕುನಾಚ಼ಸ್ ಪಾಪ್ ಮೆಜಾ಼ಯಾ ವ್ಹಯಿತ್ ನವ್ಥ. ");
INSERT INTO gok_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","ಫನ್ ಆದಾಮಾಚಾ ಕಾಲಾದರ್ನಿ ಮೊಶೆಚಾ ಕಾಲಾ ಪರತ್ ಸಗ್‍ಳ್ಯಾ ಲೋಕಾನಾ ಮರಾನ್ ಹುತ್ತ. ಫನ್ ಥೊಡ್ಯಾಂಚಾನಿ ಆದಾಮಾಚೆಗತ್ ದೇವಾಚಾ ಆಜ್ಞಾ ವಲ್ಯಾಂಡ್ಯಾಚ಼ ಪಾಪ್ ಕೇಲ್ ನವ್ಥ ತ್ಯನಾ ಫನ್ ಮರಾನ್ ಹುತ್ತ. ಆದಾಮ್ ಮೋರ್‌ಲ್ಯಾ ದೀಸಾತ್ ಯನಾರ‍್ಯಾ ಕ್ರಿಸ್ತಾಲಾ ಮೋರ‍್ಹ ದಾವುನ್ ದೇತ್ಯಾಲಾ ಜಾ಼ಲ್ಥಾ. ");
INSERT INTO gok_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","ಫನ್ ಆದಾಮ್ ಆನಿ ಕ್ರಿಸ್ತ ಯೇಕುಸ್ ನವ್ಹ ಕಾ ಮಂಜೆ ದೇವಾಚ಼ ಫುಕಟ್ ದಾನ್ ಆದಾಮಾಚಾ ಪಾಪಾಚೆಗತ್ ನವ್ಹ. ಹ್ಯ ಖರ ಹಾ ಖುಬ್ ಲೋಕ ತ್ಯಚಾ ಪಾಪಾನಿ ಮಿಲಿತ. ಫನ್ ದೇವಾಚಾ಼ ಆಶಿರ್ವಾದ್ ಖುಬ್ ಮೋಟಾ ಜಾ಼ಲ್ಯಾ ಆನಿ ತ್ಯಚ಼ ದಾನ್ ಯೋಕ್ ಮಾನುಸ್ ಯೇಸು ಕ್ರಿಸ್ತಾಸ್ ಲಾಗುನ್ ಖುಬ್ ಲೋಕಾನಾ ಗಾವ್ಲ. ");
INSERT INTO gok_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","ಆದಾಮಾನಿ ಯಂಗ್ದಾ ಪಾಪ್ ಕೇಲ್ಯಾವ ತ್ಯಲಾ ಗುನ್ನದಾರ್ ಮನ್ಹುನ್ ತೀರ್ಮಾನ್ ಜಾ಼ಲ್ಹಾ. ಫನ್ ದೇವಾಚ಼ ಫುಕಟ್ಚ ದಾನ್ ತ್ಯಲಾ ಆಡ್ವ ಜಾ಼ಲ್ಯಾ. ಖುಬ್ ಪಾಪಾಸ್ ಲಾಗುನ್ ದೇವಾಚ಼ ಫುಕಟ್ಚ ದಾನ್ ಆಲ ತ್ಯ ಫುಕಟ್ಚ ದಾನ್ ಚು಼ಕ್ ನಸ್‍ಲ್ಯಾಲ ಕರ್ತ. ");
INSERT INTO gok_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","ಯಕಾನಿ ಪಾಪ್ ಕೇಲ. ತ್ಯಾ ಯಕಾಸ್ ಲಾಗುನ್ ಸಗ್‌ಳ್ಯಾ ಲೊಕಾವ್ನಿ ಮರ್ನಾಚಾ಼ ಹುಕುಮ್ ಚಾ಼ಲಿವ್ಲಾ. ಫನ್ ಯೋಕ್ ಮಾನುಸ್ ಯೇಸು ಕ್ರಿಸ್ತಾಸ್ ಲಾಗುನ್ ತ್ಯನಿ ಕೇಲ್ಯಾಲಿ ಹ್ಯಾ ಕಾಮಾಚಾ಼ ಪರಿನಾಮ್ ಖುಬ್ ಮೊಟ ಹಾ ತೀ ಸಗ್ಳಿ ಲೋಕ ದೇವಾಚೆ ಖುಬ್ ಕ್ರಪೆ ಆನಿ ಫುಕಟ್ ತ್ಯಚೆ ಮೊರ‍್ಹ ನಿಯತಿಚಿ ಮನ್ಹುನ್ ದಾವುನ್ ದೇತ. ತೀ ಸಗ್ಳಿ ಕ್ರಿಸ್ತಾಸ್ ಲಾಗುನ್ ಜೀವ್ನಾತ್ ರಾಜ್ ಭಾರ್ ಚಾ಼ಲಿವ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","ಕಸ ಯಕಾ ಮಾನ್ಸಾಚ಼ ಪಾಪ್ ಸಗ್‍ಳ್ಯಾ ಲೋಕಾನಾ ಚು಼ಕ್ ಕರ್ತ್ಯಾಲಿ ದ್ಯಾವ್ತ. ತೇಸ್ ತರನಿ ಕ್ರಿಸ್ತಾಚ಼ ಯಾಕ್ ಚಾ಼ಂಗ್ಲ ಕಾಮ್ ತ್ಯಾ ಸಗ್‍ಳ್ಯಾ ಲೋಕಾನಾ ಸ್ವತಂತ್ರ ಕರ್ತ ಆನಿ ಜೀವ್ ದೇತ. ");
INSERT INTO gok_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","ಯೋಕ್ ಮಾನುಸ್ ದೇವಾಲಾ ಆಡ್ವಾ ಚಾ಼ಲ್ಲಾ ಮನ್ಹುನ್ ಸಗ್ಳಿ ಲೋಕ ಪಾಪಿ ಜಾ಼ಲ್ಹಿತ ತಸಸ್ ಯೋಕ್ ದೇವಾಲಾ ವಾಕುನ್ ಚಾ಼ಲ್ಲಾ ಮನ್ಹುನ್ ಸಗ್ಳಿ ನೀಯತಿಚಿ ವ್ಹನಾರ್. ");
INSERT INTO gok_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","ಧರ್ಮಶಾಸ್ತಾರಾಚಾ ಯನ್ಯಾನಿ ಪಾಪ ಖುಬ್ ಜಾ಼ಲ್ಹಿತ ಆನಿ ದಿಸುನ್ ಆಲಿತ ದೇವಾಚ಼ ಅನುಗ್ರಹ ಖುಬ್ ಜಾ಼ಯಿತ್ ಗೆಲ. ");
INSERT INTO gok_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","ಯಕಾ ಕಾಲಾತ್ ಪಾಪಾನಿ ಮರ್ನಾಸ್ ಲಾಗುನ್ ಅಧಿಕಾರ್ ಚಾ಼ಲಿವ್ಲಾ ಫನ್ ದೇವಾನಿ ಲೋಕಾನಾ ನೀಯತಿಚ಼ ಮನ್ಹುನ್ ಕರಾಯಾ ಆಪ್ಲಿ ಕ್ರಪಾ ಲ ದಿಲಿ. ಹೀ ಕ್ರಪಾ ಆಮ್ಚಾ ಪ್ರಭು ಜಾ಼ಲ್ಯಾಲ್ಯಾ ಯೇಸು ಕ್ರಿಸ್ತಾಸ್ ಲಾಗುನ್ ಆಮಾನಾ ಖಾಯಿಮಚಾ಼ ಜೀವ್ನಾ ಆಂತಿ. ");
INSERT INTO gok_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","ತಸ ಜಾ಼ಲ್ಯಾ ತುಮಚ಼ ಮನ್ಹ ಕ್ಯಾ? ದೇವ್ ಆಮಾನಾ ಖುಬ್ ಕ್ರಪಾ ದಾವುನಿ ಮನ್ಹುನ್ ಆಮಿ ಪಾಪಾತುಸ್ ಮೊರ‍್ಹ ಜಾ಼ಯಾವ್ಹಯಿ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","ಆಜೆಬಾದ್ ನಾಹಿ! ಆಮಿ ಪಾಪಾಸಾಟಿ ಮೇಲಾವ್ ಆಸ ಆಸ್ಥಾನಾ ಪಾಪಾತ್ ಕಸಾ ಜೀವ್ನಾ ಕರಾಯಾ ವ್ಹತ್ತೊ? ");
INSERT INTO gok_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","ಆಮಾನಾ ಖರ‍್ಯಾನಿಸ್ ಠಾವ ಹಾ ಆಮಿ ಯೇಸು ಕ್ರಿಸ್ತಾಪ ಬಾಪ್ತಿಸ್ಮಾ ಗೆತಲ್ಯಾ ಮನ್ಹುನ್ ಆಮಿ ತ್ಯಾ ಯಳಾತ್ ತ್ಯಚಾ ಮರ್ನಾಚಾ ಯಳಾತ್ಬಿ ಬಾಪ್ತಿಸ್ಮಾ ಗೇತಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","ಆಸ ಆಸ್ಥಾನಾ, ತ್ಯಚಾ ಮರ್ನಾತ್ ಬಾಪ್ತಿಸ್ಮಾ ಗೇತಲ್ಯಾ ಮನ್ಹುನ್ ಆಮಾನಾ ಕ್ರಿಸ್ತಾ ಸಂಗ ಪುರ್ಲ್ಯಾ. ಆನಿ ತ್ಯಚಾ ಮರ್ನಾತ್ ಆನಿ ಭಾಗ್ ಜಾ಼ಲ್ಯಾವ್ ಕಾ ಮಂಜೆ ಕಸಾ ಕ್ರಿಸ್ತ ಬಾಚಾ ಮಹಿಮೆಚಾ ಬಳಾನಿ ಮರ್ನಾತ್ನಿ ಜಿತ್ತಾ ಉಟ್ಲಾ ತಸಸ್ ಆಮಿ ನವ್ವಾ ಜೀವ್ನಾ ಕರಾವ. ");
INSERT INTO gok_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","ಕಸ ಆಮಿ ತ್ಯಚಿ ಸಂಗ ಯೇಕ್ ವ್ಹವುನ್ ತ್ಯಚಾ ಮರ್ನಾತ್ ವಾಟದಾರ್ ಜಾ಼ಲ್ಯಾವ್ ತಸ ತ್ಯೊ ಜಿತ್ತಾ ವ್ಹವುನ್ ಉಠುನ್ ಯತ್ಯಾಲ್ಯಾತ್ ವಾಟದಾರ್ ವ್ಹತ್ತಾವ್. ");
INSERT INTO gok_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","ಆಮಚಾ಼ ಜು಼ನ್ನಾ ಸ್ವಭಾವ್ ಯೇಸು ಕ್ರಿಸ್ತಾ ಸಂಗ ಶಿಲ್ಬೆವ ಮರುನ್ ಗೇಲಾ ಮನ್ಹುನ್ ಆಮಾನಾ ಠಾವಾ ಹಾ. ಕಾ ಮಂಜೆ ಪಾಪಾಚ಼ ಬಳ್ ನಾಸ್ ವ್ಹವುನಿ ಮನ್ಹುನ್ ಆನಿ ಆಮಿ ಮೊರ‍್ಹ ಪಾಪಾಲಾ ಗುಲಾಮ್ ವ್ಹವುನ್ ರಾಹುನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","ಪಾಪಾಚೆ ವಾಟ್ನಿಸ್ ಮೇಲ್ಯಾಲಾ ಪಾಪಾಚಾ ಬಾನ್ನಾತ್ನಿ ಸುಟ್ಕಾ ಜಾ಼ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","ಆಮಿ ಕ್ರಿಸ್ತಾ ಸಂಗ ಮೇಲ್ಯಾವ. ಆಮಾನಾ ಹ್ಯೊ ಇಸ್ವಾಸ್ ಹಾ ತ್ಯಚಿ ಸಂಗ ಜಿವ್ನಾ ಕರ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","ಕ್ರಿಸ್ತ ಮೇಲ್ಯಾಲ್ಯಾತ್ನಿ ಜಿತ್ತಾ ವ್ಹವುನ್ ಉಠುನ್ ಆಲಾ. ತ್ಯೊ ಆನಿಕ್ ಮರಾಯಾ ವ್ಹಯೀತ್ ನಾಹಿ ಮನ್ಹುನ್ ಆಮಾನಾ ಠಾವ ಹಾ. ಹಿತ್ನಿ ಮೊರ‍್ಹ ಕಂದಿಸ್ ಮರ್ನಾಲಾ ತ್ಯಚಿವ ಅಧಿಕಾರ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","ತ್ಯೊ ಮೇಲ್ಯಾಲಾ ಸಗ್‌ಳ್ಯಾಂಚೆ ಸಾಟಿ ಪಾಪಾಚೆ ವಾಟ್ನಿಸ್ ಯಂಗ್ದಾಸ್ ಮೇಲಾ ಫನ್ ಆತಾ ತ್ಯೊ ದೇವಾ ಸಂಗ ಯೇಕ್ ವ್ಹವುನ್ ಜೀವ್ನಾ ಕರ್ತ್ಯೊ. ");
INSERT INTO gok_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","ತೇಸ್ ತರನಿ ತುಮಿ ಸಾಹಿತ್ ತುಮಚಾ ಪಾಪಾಂಚೆ ವಾಟ್ನಿಲಾ ಮೆಲ್ಯಾಸಾ ಮನ್ಹುನ್ ಆನಿ ಕ್ರಿಸ್ತ ಯೇಸುಸ್ ಲಾಗುನ್ ದೇವಾ ಸಂಗ ಜೀವ್ನಾ ಕರ್ತ್ಯಾಲಿ ಮನ್ಹುನ್ ನಿರ್ದಾರ್ ಕರಾ. ");
INSERT INTO gok_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","ತುಮಚ಼ಾ ನಾಸ್ ವ್ಹತ್ಯಾಲಾ ಶರೀರಾವ ಪಾಪಾನಿ ಹುಕುಮ್ ಚಾ಼ಲ್ವು ನಾಹಿ. ಕಾ ಮಂಜೆ ತು ಪಾಪಾಚೆ ಆಶೆತ್ ಚಾ಼ಲು ನಕೊಸ್. ");
INSERT INTO gok_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","ತುಮ್ಚಾ ಶರಿರಾಚಾ಼ ಭಾಗ್ ಪಾಪಾಚೆ ಸೇವೆಲಾ ವಪ್ಸು ನಕೋಸಾ; ತುಮ್ಚಿ ಆಂಗ ಪಾಪಾಲಾ ವಪ್ಸುನ್ ಬುರ್ಸಫನ ಚಾ಼ಲಿವತ್ಯಾಲಿ ಹಾತ್ಯಾರಿ ವ್ಹವುನಕೋಸಾ. ತ್ಯಚೆ ಬದ್ಲಿ, ಮರ್ನಾತ್ನಿ ಜಿತ್ತ ವ್ಹವುನ್ ತುಮಾನಾ ತುಮಿಸ್ ದೇವಾಲಾ ಅರ್ಪನ್ ಕರಾ. ಆನಿ ತುಮಚಾ ಶರೀರಾಚ಼ ಭಾಗ್ ನಿಯತಿಚಾ ಉದ್ದೆಶಾಚಾ ಉಪಯೋಗಾಸಾಟಿ ದೇವಾಚಾ ತಾಬ್ಯಾತ್ ದೇವಾ. ");
INSERT INTO gok_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","ಪಾಪ್ ತುಮಚಾ಼ ವಡಿಲ್ ವ್ಹಯಿತ್ನಾಹಿ. ಕಾ ಮಂಜೆ, ತುಮಿ ಧರ್ಮಶಾಸ್ತಾರಾಲಾ ಆತ್‍ ನಾಹಿಸಾ. ಫನ್ ಆತಾ ತುಮಿ ದೇವಾಚೆ ಕ್ರಪೆತ್ ಜೀವ್ನಾ ಕರ್ತ್ಯಾಲಿ ಜಾ಼ಲ್ಯಾಸಾ. ");
INSERT INTO gok_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","ಆಸ ಆಸ್ಥಾನಾ ಆಮಿ ಕ್ಯಾ ಕರಾಯಾ ವ್ಹಯಿ? ಆಮಿ ಧರ್ಮಶಾಸ್ತಾರಾಚೆಗತ್ ಆಂದಿ ದೇವಾಚೆ ಕ್ರಪೆತ್ ಹಾವ್ ಮನ್ಹುನ್ ಪಾಪ್ ಕರಾಯಾ ವ್ಹಯಿ ಕ್ಯಾ? ಆಜೆಬಾದ್ ನಾಹಿ! ");
INSERT INTO gok_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","ತುಮಿ ಕುನಾಲಾ ತರಿ ತ್ಯಾ ಆಜ್ಞಾ ಪಾಳಾಯಾ ವಪ್ಸುನ್ ದೇತಾಸಾ ತ್ಯಲಾ ತುಮಿ ಧನ್ಹಿ ವ್ಹತಾಸಾ ಆನಿ ತ್ಯಲಾ ಗುಲಾಮ್ ವ್ಹತಾಸಾ ಆಸ ಆಸ್ಥಾನಾ ತು ಪಾಪಾಚಾ಼ ಗುಲಾಮ್ ವ್ಹನಾರ್ ತ್ಯಚಾ಼ ಪರಿನಾಮ್ ಮರಾನ್ ಜಾ಼ಲ್ಯಾ ನಾಹಿತ ದೇವಾಚೆ ಮೊರ‍್ಹ ನೀಯತಿಚಾ಼ ಮನ್ಹುನ್ ದ್ಯಾವ್ತ. ");
INSERT INTO gok_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","ಮಾಗ್‌ಲ್ಯಾ ಕಾಲಾತ್ ತುಮಿ ಪಾಪಾಲಾ ಗುಲಾಮ್ ಜಾ಼ಲ್ತಾಸಾ ಪಾಪಾನಿ ತುಮಾನಾ ಆಪ್‌ಲ್ಯಾ ಹಾತಾತ್ ದರ್ಲಿ ಹುತ್ತಿತ. ತುಮಾನಾ ಸಾಂಗ್‌ಲ್ಯಾಲೆ ಗುಶ್ಟಿತ್ ತುಮಿ ಪೂರ್ನ ಆತ್‌ ಜಾ಼ಲ್ಯಾಸಾ ಮನ್ಹುನ್ ದೇವಾಲಾ ಸ್ತೊತ್ರ ವ್ಹವುನಿ. ");
INSERT INTO gok_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","ತುಮಿ ಪಾಪಾತ್ನಿ ಸುಟ್ಕಿ ಜಾ಼ಲ್ಯಾಸಾ. ಆತಾ ತುಮಿ ನೀಯತಿಲಾ ಗುಲಾಮ್ ಜಾ಼ಲ್ಯಾಸಾ. ");
INSERT INTO gok_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","ಲೋಕಾನಾ ಸಮಾಜ್‍ಲ್ಯಾಲಿ ಉದಾಹರನಾನಿ ಮೀ ಹ್ಯ ತುಮಾನಾ ಉಗ್ಡುನ್ ಸಾಂಗ್‌ತ್ಯೊ. ಯಕಾ ಕಾಲಾತ್ ತುಮಿ ತುಮ್ಚಾ ಧಡಾಚಾ ಆಂಗಾಲಾ ಪಾಪಾಲಾ ಬುರ್ಶಾ ಫನಾಲಾ ಆನಿ ದುಶ್ಟ ಕಾಮಾಚಾ ಬುರ್ಶಾ ಉದ್ದೆಶಾಚಿ ಗುಲಾಮ್ ಜಾ಼ಲ್ತಾಸಾ. ತಸಸ್ ಆತಾ ತುಮಿ ತುಮಚಾ ಶರಿರಾಚ಼ ಭಾಗ್ ಆಳಾಚಾ ರೂಪಾತ ನಿಯತಿಚಾ ಅಧಿನಾತ್ ಪವಿತ್ರ ಜಾ಼ಲ್ಯಾಲ್ಯಾ ಉದ್ದೆಶಾಸಾಟಿ ವಪ್ಸುನ್ ದೆವಾ. ");
INSERT INTO gok_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","ಕವಾ ತುಮಿ ಪಾಪಾಲಾ ಗುಲಾಮ್ ಜಾ಼ಲ್ಯಾಸಾ ಆನಿ ನೀಯತಿಚಾ ತಾಬ್ಯಾತ್ ನವ್ಥಾಸಾ. ");
INSERT INTO gok_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","ತುಮಿ ಬುರ್ಸಿ ಕಾಮ ಕೆಲ್ಯಾಸಾ. ಆತಾ ತುಮಿ ತ್ಯಾ ಕಾಮಾಚೆ ಗುಶ್ಟಿತ್ ಲಾಜ್‍಼ ವಾಟ್ನಾರ್. ತ್ಯಾ ಕಾಮಾಂಚಾನಿ ತುಮಾನಾ ಮಜ಼ತ್ ಕೇಲೆ ಕ್ಯಾ? ನಾಹಿ. ತ್ಯಾ ಕಾಮಾಂಚಾ಼ ಪರಿನಾಮ್ ಮರಾನ್ ಜಾ಼ಲ್ಯಾ! ");
INSERT INTO gok_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","ಫನ್ ಆತಾ ತುಮಿ ಪಾಪಾತ್ನಿ ಸುಟ್ಕಿ ವ್ಹವುನ್ ದೇವಾಚಿ ಗುಲಾಮ್ ಜಾ಼ಲ್ಯಾಸಾ. ಹ್ಯಚಾ಼ ತುಮಾನಾ ಫಾಯಾಯ್ದಾ ಕ್ಯಾ ಮಂಜೆ ತುಮಚಾ಼ ಜೀವ್ನಾ ತ್ಯನಾ ಅರ್ಪನ್ ಕರಾಚಾ಼ ಆನಿ ಹ್ಯಚಾ಼ ಪರೀನಾಮ್ ಶಾಸ್ವತ್ ಜೀವ್ ಗಿಹ್ಯಾಚಾ಼. ");
INSERT INTO gok_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","ಕಾ ಮಂಜೆ ಪಾಪಾಚಿ ಮಜು಼ರಿ ಮರಾನ್. ಫನ್ ದೇವಾಚ಼ ಫುಕಟ್ ದಾನ್ ಆಮಚಾ಼ ಪ್ರಭು ಜಾ಼ಲ್ಯಾಲ್ಯಾ ಕ್ರಿಸ್ತ ಯೇಸುಪ ಆಸ್‌ಲ್ಯಾಲಾ ಶಾಸ್ವತ್ ಜೀವ್ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","ಬನ್ಹಿ ಬಾವ್ಹಾನು, ಮಿ ಕಚೆ ಗುಶ್ಟಿತ್ ಸಾಂಗ್‌ತ್ಯೊ ಮನ್ಹುನ್ ತುಮಾನಾ ಸಮಾಜ಼ಲ್ಯಾ, ಕಾ ಮಂಜೆ ಮೊಶೆಚಾ ಧರ್ಮಶಾಸ್ತಾರಾಚೆ ಗುಶ್ಟಿತ್ ತುಮಾನಾ ಸಗ್‌ಳ್ಯಾನಾ ಠಾವ ಹಾ. ತ್ಯ ಲೊಕ ಜೀವ್ ಆಸ ಪರೇತ್ ತ್ಯವ್ಡಸ್ ತ್ಯಂಚಿವ ಅಧಿಕಾರ್ ಚಾ಼ಲಿವ್ತ. ");
INSERT INTO gok_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","ಮೀ ತುಮಾನಾ ಯೇಕ್ ಉದಾರನೆ ದೇತೊ: ದನ್ಗೊರ್ ಜ಼ಗಪರೆತ್ ದನ್ಗರ್ ಕಾನುನಾಸ್ ಲಾಗುನ್ ತಾಬ್ಯಾತ್ ರಾಹ್ಯಾ ವ್ಹಯಿ. ಫನ್ ತಿಚಾ಼ ದನ್ಗೊರ್ ಮೇಲ್ಯಾವ, ಲಗ್ನಾಚಾ ಕಾನುನಾನಿ ತೀ ಸುಟ್ಕಿ ಜಾ಼ಲೆ. ");
INSERT INTO gok_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","ಫನ್ ಆಪ್ಲಾ ದನ್ಗೊರ್ ಜೀತ್ತಾ ಆಸ್ಥಾನಾಸ್ ಆನಿ ಯಕಾಲಾ ಲಗೀನ್ ಕರುನ್ ಗೇತ್ಲತ ತೀ ವ್ಯಬೀಚಾರ್ ಮಂಥ್ಯಾಲೆ ಚು಼ಕಿಲಾ ಮುಜ಼ರಾ ಜಾ಼ಲ್ಯಾ ಮನ್ಹುನ್ ಧರ್ಮಶಾಸ್ತಾರ್ ಸಾಂಗ್ತ. ಫನ್ ತೀಚಾ಼ ದನ್ಗೋರ್ ಮರುನ್ ಗೇಲಾತ ತೀ ಲಗ್ನಾಚಾ ಹಂಗಾನಿ ಸುಟ್ಕಿಜಾ಼ಲೆ. ಆಸ ಆಸ್ಥಾನ ಆಪ್ಲಾ ದನ್ಗೋರ್ ಮೇಲ್ಯಾವ ಆನಿ ಯಕಾಲಾ ಲಗೀನ್ ಕರುನ್ ಗೇತ್ಲಾತ ತೀ ವ್ಯಬೀಚಾರ್ ಮಂಥ್ಯಾಲೆ ಚು಼ಕಿಲಾ ಗುರಿ ವ್ಹಯಿತ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","ಮಾಜಾ ಬನ್ಹಿ ಬಾವ್ಹಾನಾ, ಹ್ಯಸ್ ತರನಿ ತುಮಚ಼ ಪೈಲ ಗುನ್ ಮರುನ್ ಗೇಲ; ತುಮಿ ಕ್ರಿಸ್ತಾಚಾ ದಢಾಸ್ ಲಾಗುನ್ ಧರ್ಮಶಾಸ್ತಾರಾಚೆ ವಾಟ್ನಿಲಾ ತುಮಿ ಮೆಲ್ಯಾಸಾ ಆತಾ ತುಮಿ ಮೇಲ್ಯಾಲ್ಯಾತ್ನಿ ಜಿತ್ತಾ ವ್ಹವುನ್ ಉಠುನ್ ಆಲ್ಯಾಲ್ಯಾಪ ಮಿಳುನ್ ಹಾಸಾ. ಆಮಿ ದೇವಾಚೆ ಸೇವೆಲಾ ಉಪೇಗ್ ಜಾ಼ಲ್ಯಾಲಿ ವ್ಹವುನ್ ಫಳ್ ದಿಯಾ ಕ್ರಿಸ್ತಾ ಸಂಗ ಹಾವ್. ");
INSERT INTO gok_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","ಕವಾ ಆಮಿ ಪಾಪಾಚಾ ಸ್ವಭಾವಾತ್ ಜಿವ್ನಾ ಕರೀತಾವ್ ಆಮ್ಚಾ ಪಾಪಾಂಚಿ ಇಚ್ಚಾ ಧರ್ಮಶಾಸ್ತಾರಾಸ್ ಲಾಗುನ್ ಆಮ್ಚಾ ಶರೀರಾತ್ ಹುತ್ತ. ಕಾ ಮಂಜೆ ಆಮಿ ಮರ್ನಾಚ಼ ಫಳ್ ಉತ್ಪನ್ ಕರಾಯಾ ವ್ಹಯಿ. ");
INSERT INTO gok_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","ಫನ್ ಆತಾ ಆಮಾನಾ ಧರ್ಮಶಾಸ್ತಾರಾತ್ನಿ ಸುಟ್ನುಕ್ ಜಾ಼ಲೆ. ಕಾ ಮಂಜೆ ಕಚಾ ಧರ್ಮಶಾಸ್ತಾರಾನಿ ಆಮಾನಾ ಬ್ಯಾಂದ್ಲ ಹುತ್ತ. ಆಮಿ ತ್ಯಚಿ ಸಾಟಿ ಮೇಲ್ಯಾವ್ ಆನಿ ಆತಾ ಜು಼ನ್ನ ಲಿವ್‍ಲ್ಯಾಲ್ಯಾನಿ ನವ್ಹ ಧರ್ಮಶಾಸ್ತಾರಾಚೆಗತ್ ನವ್ಹ ಆತ್‍ಮ್ಯಾಚೆ ನವೆ ತರನಿ ಆಮಿ ದೇವಾಚಿ ಸೇವಾ ಕರ್ತಾವ್. ");
INSERT INTO gok_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","ಧರ್ಮಶಾಸ್ತಾರ್ ಪಾಪಿ ಮನ್ಹುನ್ ಮಿ ಸಾಂಗತ್ಯೊ ಕ್ಯಾ? ಖರ್ಯಾನಿ ನವ್ಹ. ಪಾಪ್ ಮಂಜೆ ಕ್ಯಾ ಮನ್ಹುನ್ ಸಿಕಾಯಾ ಧರ್ಮಶಾಸ್ತಾರ್ ಯಾಕುಸ್ ಮಾರ್ಗ ಜಾ಼ಲ್ಯಾ. ಧರ್ಮಶಾಸ್ತಾರ್ ನಸ್ಥತ ಬುರ್ಸಿ ಆಶಾ ಮಂಜೆ ಕ್ಯಾ ಮನ್ಹುನ್ ಮನಾ ಸಮಜ಼ತ್ ನವ್ಥಿ. “ದುಸರ‍್ಯಾಂಚಾ ಸಾಮಾನಾವ ತುಮಾನಾ ಮನ್ ರಾಹು ನಾಹಿ ಮನ್ಹುನ್ ಧರ್ಮಶಾಸ್ತಾರಾನಿ ಸಾಂಗ್‌ಲ್ಯಾ ತ್ಯ ಮನಾ ಸಮಾಜ್ಲ. ");
INSERT INTO gok_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","ಫನ್ ಪಾಪ್ ತ್ಯಾ ಆಜ್ಞಾ ಉಪೇಗ್ ಕರುನ್ ಮಾಜಿಪ ಸಗ್‌ಳೆ ತರಚಾ ಬುರ್ಶೆ ಆಶತ್ನಿ ಪ್ಯಾಡ್ಲ. ಮನ್ಹುನ್ ತೇ ಆಜ್ಞೆನಿ ಪಾಪ್ ಮಾಜಿಪ ಆಲ. ಫನ್ ಧರ್ಮಶಾಸ್ತಾರ್ ನಸ್ಥತ, ಪಾಪ್ ಮಂಥ್ಯಾಲ ರಾಹಿತ್ ನವ್ಥ. ");
INSERT INTO gok_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","ಮೀ ಧರ್ಮಶಾಸ್ತಾರ್ ಸಮಜು಼ನ್ ಗಿಹ್ಯಾಚೆ ಆಂದಿ ಧರ್ಮಶಾಸ್ತಾರ್ ನಸ್‌ಲ್ಯಾಚೆಗತ್ ಜಿತ್ತಾ ಹುತ್ತೊ. ಫನ್ ಧರ್ಮಶಾಸ್ತಾರಾಚಾ ಆಜ್ಞಾ ಮಾಜಿಪ ಆಲ್ಯಾ ತವಾ. ಪಾಪ್ ಜೀವ್ನಾ ಕರಾಯಾ ಲಾಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","ಮೀ ಪಾಪಾಸ್ ಲಾಗುನ್ ಆತ್‍ಮ್ಯಾನಿ ಮರುನ್ ಗೇಲೊ. ಜೀವ್ ಆನಾಯಾ ವ್ಹಯಿ ಜಾ಼ಲ್ಯಾಲೆ ಆಜ್ಞಾನಿ ಮನಾ ಮರಾನ್ ಆನ್ಲ. ");
INSERT INTO gok_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","ಕಾ ಮಂಜೆ ನೆಮಾನಿ ಗಾವಲ್ಯಾಲಾ ಅವ್ಕಾಶ್ ಪಾಪ್ ಉಪಯೊಗ್ ಕರುನ್ ಮನಾ ಮೊಸ್ ಕೆಲಾ ಆನಿ ತ್ಯಚಿಸ್ ಲಾಗುನ್ ಮನಾ ಮ್ಯಾರ್ಲ. ");
INSERT INTO gok_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","ಆಸ ಆಸ್ಥಾನಾ ಧರ್ಮಶಾಸ್ತಾರ್ ನಿರ್ಮಳ್ ಹಾ, ಆನಿ ಆಜ್ಞಾ ನಿರ್ಮಳ್ ಆನಿ ಶಾರ್ಕ ಆಸ್‌ಲ್ಯಾಲ ಆನಿ ಚಾ಼ಂಗ್ಲ ಜಾ಼ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","ತಸ ಜಾ಼ಲ್ಯಾವ, ಚಾ಼ಂಗ್ಲ ತ್ಯಸ್ ಮನಾ ಮರಾನ್ ಆಂತ್ಯಾಲ ಮನ್ಹುನ್ ಕ್ಯಾ? ಆಜೆಬಾದ್ ನಾಹಿ! ಫನ್ ಪಾಪ್ ಚಾಂಗ್ಲ ತ್ಯಸ್ ಉಪೇಗ್ ಕರುನ್ ಮನಾ ಮರಾನ್ ಆಂತ. ಹ್ಯಚಿಸ್ ಲಾಗುನ್, ಮೀ ಪಾಪಾಲಾ ಸಮಜು಼ನ್ ಗೇತಲ್ಯಾ. ಪಾಪ್ ಖುಬ್ ಬುರ್ಸ ಮನ್ಹುನ್ ಆಜ್ಞಾನಿ ಸಮಾಜ್ಲ. ");
INSERT INTO gok_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","ಧರ್ಮಶಾಸ್ತಾರ್ ಆತ್ಮಿಕ್ ಜಾ಼ಲ್ಯಾ ಮನ್ಹುನ್ ಮನಾ ಠಾವ ಹಾ. ಫನ್ ಮೀ ಶಾರಿರಿಕ್ ಮಾನುಸ್. ಮೀ ಪಾಪಾಚಾ಼ ಗುಲಾಮ್ ವ್ಹವುನ್ ಇಕ್‍ಲ್ಯಾಲಾ ಜಾ಼ಲ್ಯೊ. ");
INSERT INTO gok_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","ಮೀ ಕರ್ತ್ಯಾಲಿ ಕಾಮ ಮನಾ ಸಮಜ಼ತ್ ನಾಹಿತ. ಕಾ ಮಂಜೆ ಮೀ ಕುಟ್ಲ ಚಾ಼ಂಗ್ಲ ಕಾಮ್ ಕರಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಮನ್ ಕರ್ತೊ ತೀ ಕಾಮ ಕರಾಚೆ ಆಂದಿ ಮೀ ನಕ್ವಾಟ್ ಕೇಲ್ಯಾಲ್ಯಾಲಿ ಬುರ್ಸಿ ಕಾಮಸ್ ಕರ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","ಮೀ ಕರುನಾಹಿ ಮಂಥ್ಯಾಲ ಮಿ ಕೆಲ್ಯಾವ ತ್ಯ ಹ್ಯ ದ್ಯಾವ್ತ ಕಾ ಮಂಜೆ ಮೀ ಧರ್ಮಶಾಸ್ತಾರ್ ಚಾ಼ಂಗ್ಲ ಮನ್ಹುನ್ ಮೀ ಗೆಥೊ. ");
INSERT INTO gok_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","ಆಸ ಆಸ್ಥಾನಾ ಹಿ ಬುರ್ಸಿ ಕಾಮ ಕರ್ತ್ಯಾಲಾ ಖರ‍್ಯಾನಿಸ್ ಮೀ ನವ್ಹ. ಮಾಜಿಪ ಆಸ್‌ಲ್ಯಾಲ ಪಾಪುಸ್ ಹೀ ಬುರ್ಸಿ ಕಾಮ ಕರ್ತ. ");
INSERT INTO gok_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","ವ್ಹಯ್, ಮಾಜಿಪ ಮಂಜೆ ಮಾಜಾ ಮಾನ್ಸಾಚಾ ಸ್ವಭಾವಾತ್ ಚಾ಼ಂಗ್ಲ ಕಾಯ್ ರಾಯ್ಲ ನಾಹಿ ಮನ್ಹುನ್ ಮನಾ ಠಾವ ಹಾ. ಚಾ಼ಂಗ್ಲಿ ಕಾಮ ಕರಾಯಾ ಮನಾ ಮನ್ ಆಸ್ಲ ತರಿ ತೀ ಕರುನ್ ದಾವಾಯಾ ವ್ಹಯಿತ್ ನಾಹಿತ. ");
INSERT INTO gok_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","ಕಾ ಮಂಜೆ ಕವಾ ಮೀ ಚಾ಼ಂಗ್ಲಿ ಕಾಮ ಕರಾಯಾ ವ್ಹಯಿ ಮಂಥೊ ತ್ಯ ಮೀ ಕರೀತ್ ನಾಹಿ ಕಚ಼ ಮೀ ಕರಾಯಾ ನಕೊ ಮಂಥೊ ತೀಸ್ ಬುರ್ಸಿ ಕಾಮ ಮೀ ಕರ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","ಆಸ ಆಸ್ಥಾನಾ, ಮೀ ಕರಾಯಾ ನಕೊ ಆಸ್‌ಲ್ಯಾಲಿ ಕಾಮ ಮೀ ಕಿಲಿತತ, ತೀ ಕರ್ತ್ಯಾಲಾ ಖರ‍್ಯಾನಿಸ್ ಮೀ ನವ್ಹ. ಮಾಜಿಪ ಆಸ್‌ಲ್ಯಾಲ ಪಾಪುಸ್ ತಿ ಬುರ್ಸಿ ಕಾಮ ಕರ್ತ. ");
INSERT INTO gok_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","ಆಸ ಆಸ್ಥಾನಾ, ಮೀ ಹ್ಯೊ ನೇಮ್ ಸಿಕ್‌ಲ್ಯೊ: ಮೀ ಚಾ಼ಂಗ್ಲತ್ಯ ಕರಾಯಾ ಮನ್ ಕರ್ತ್ಯಾಲ, ಬುರ್ಸ ಮಾಜಿಪ ರಾಥ. ");
INSERT INTO gok_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","ಕಾ ಮಂಜೆ ಮಾಜೆ ಆತ್ ದೇವಾಚೆ ನೇಮಾಚೆ ಗುಶ್ಟಿತ್ ಮೀ ಸಂತೊಶ್ ವ್ಹತ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","ಫನ್ ಮಾಜಾ ದಢಾತ್ ದುಸ್ರಾ ನೇಮ್ ಕಾಮ್ ಕರ್ತ್ಯಾಲಾ ಮಿ ಬಗ್ತೊ. ಮಾಜೆ ಅತ್ ವ್ಹಯ್ ಮಂಥ್ಯಾಲ್ಯಾ ನೇಮಾಚೆ ಆಡ್ವಾ ತ್ಯೊ ನೆಮ್ ಲಡ್ತೊ. ಮಾಜಾ ಮನಾತ್ ಕಾಮ್ ಕರ್ತ್ಯಾಲ್ಯಾ ತ್ಯಾ ಆನಿ ಯಕಾ ನೇಮಲಾ ನೇಮ್ ಪಾಪಾಚಾ಼ ನೇಮ್ ಜಾ಼ಲ್ಯಾ. ತ್ಯೊ ನೇಮ್ ಮನಾ ಆಪ್‌ಲ್ಯಾ ಪಾಪಾಚಾ ಗುಲಾಮಾತ್ ಬ್ಯಾಂತ. ");
INSERT INTO gok_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","ಮೀ ಕಿತಿ ಖೊಟ್ಯಾ ನಸಿಬಾಚಾ಼ ಹಾ. ಮನಾ ಮರಾನ್ ಆಂತ್ಯಾಲ ಮಾಜಾ ಮನಾತ್ನಿ ಮನಾ ರ‍ಕ್ಷನ್ ಕರ್ತ್ಯಾಲಾ ಕೊನ್? ");
INSERT INTO gok_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","ದೇವುಸ್ ಮನಾ ರ‍್ಯಾಕ್ನಾರ್! ಆಮ್ಚಾ ಪ್ರಭುಜಾ಼ಲ್ಯಾಲ್ಯಾ ಕ್ರಿಸ್ತ ಯೇಸುಸ್ ಲಾಗುನ್ ತ್ಯನಿ ದಿಲ್ಯಾಲೆ ರಕ್ಶನೆಸಾಟಿ ದೇವಾಲಾ ದನ್ಯವಾದ್ ವ್ಹವುನಿ! ಮನ್ಹುನ್ ಮಾಜಾ ಮನಾತ್ ಮೀ ದೇವಾಚಾ ನೇಮಾಲಾ ಗುಲಾಮ್ ಜಾ಼ಲ್ಯೊ. ಫನ್ ಮಾಜಾ ಶರಿರಾಚಾ ಸ್ವಾಭಾವಾನಿ ಮೀ ಪಾಪಾಚಾ ನೇಮಾಚಾ಼ ಗುಲಾಮ್ ಜಾ಼ಲ್ಹೊ. ");
INSERT INTO gok_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","ಮನ್ಹುನ್ ಆತಾ ಕ್ರಿಸ್ತ ಯೇಸುಪ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ಲೊಕಾನಾ ಗುನ್ನ ದಾರ್ ಮನ್ಹುನ್ ತೀರ್ಮಾನ್ ವ್ಹಯಿತ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","ಕಾ ಮಂಜೆ ಕ್ರಿಸ್ತ ಯೇಸುಪ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ಲೊಕಾನಾ ಜೀವ್ ಆನಾರ‍್ಯಾ ಪವಿತ್ರಾತ್ಮಾಚಾ಼ ನೇಮ್ ಮನಾ ಪಾಪ ಆನಿ ಮರಾನ್ ಆಂತ್ಯಾಲ್ಯಾ ನೇಮಾತ್ನಿ ಸುಟ್ಕ ಕೆಲ. ");
INSERT INTO gok_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","ಧರ್ಮಶಾಸ್ತಾರ್ ಬಳ್ ನಸ್‌ಲ್ಯಾಲ ಜಾ಼ಲ. ಕಾ ಮಂಜೆ ಆಮ್ಚಾ ಮಾನ್ಸಾಚಾ಼ ಸ್ವಭಾವ್ ತ್ಯ ಬಳ್ ನಸ್‌ಲ್ಯಾಚೆಗತ್ ಕರ್ತ. ಆಸ ಆಸ್ಥಾನಾ ಧರ್ಮಶಾಸ್ತಾರಾಲಾ ಕರಾಯಾ ವ್ಹಯಿತ್ ನಸ್‌ಲ್ಯಾಲ ದೇವಾನಿ ಕೆಲ. ದೇವಾನಿ ಆಪ್‍ಲ್ಯಾ ಸ್ವತಾಚಾ ಲೇಕಾಲಾ ಪಾಪಾತ್ ಗಾವಲ್ಯಾಲ್ಯಾ ಮಾನ್ಸಾಚಾ ಸ್ವಭಾವಾ ಶಾರ್ಕ ಪಾಪಾಚೆ ಬದ್ಲಿಸ್ ಲಾವುನ್ ದಿಲಾ. ತ್ಯಾ ಕಾರ್ನಾನಿ ದೇವ್ ಪಾಪಾಲಾ ಮರಾನ್ ದಿಯಾ ಸಾಟಿ ಮಾನ್ಸಾಚಾ಼ ಸ್ವಭಾವ್ ಉಪೇಗ್ ಕೇಲಾ. ");
INSERT INTO gok_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","ಆತಾ ಆಮ್ಚಾ ಸ್ವಭಾವ ಶಾರ್ಕಾ ಜೀವ್ನಾ ಕರಾಚೆ ಆಂದಿ ಪವಿತ್ರಾತ್ಮಾ ಶಾರ್ಕಾ ಜೀವ್ನಾ ಕರ್ತ್ಯಾಲ್ಯಾ ಆಮ್ಚಾತ್ ಧರ್ಮ ಶಾಸ್ತಾರಾಚ಼ ನೆಮ್ ಘಢಾಯಾ ಪಾಯ್ಜೆ ಮನ್ಹುನ್ ದೇವಾನಿ ಆಸ ಕೇಲ. ");
INSERT INTO gok_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","ಆಪ್‌ಲ್ಯಾ ಪಾಪಾಶಾರ್ಕಾ ಜೀವ್ನಾ ಕರ್ತ್ಯಾಲಿ ಲೋಕ ಮಾನ್ಸಾಚಾ಼ ಸ್ವಭಾವ್ ಮಂಥ್ಯಾಲೆ ಗುಶ್ಟಿಂಚ಼ ತ್ಯವ್ಡಸ್ ಯವಸ್‍ತ್ಯಾತ. ಫನ್ ಆತ್‌ಮ್ಯಾ ಶಾರ್ಕಿ ಚಾ಼ಲತ್ಯಾಲಿ ಲೋಕ ಆಪ್ಲಿಪ್ನಿ ಆತ್ಮ ಮನ್ ಕರ್ತ್ಯಾಲ್ಯಾ ಕಾಮಾಂಚೆ ಗುಶ್ಟಿತ್ ಯವಸ್‍ಥ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","ಯಕಾಚಿ ಯವಜ್ನಾ಼ ತ್ಯಚಾ ಮಾನ್ಸಾಚಾ ಸ್ವಭಾವಾಚಾ ತಾಬ್ಯಾತ್ ಆಸ್‍ಲ್ಯಾಲ ಮರಾನ್ ಜಾ಼ಲ್ಯಾ. ತ್ಯಚಿಪ ಜೀವ್ ಥಂಡ್ಪನ್ ರಾಥ. ");
INSERT INTO gok_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","ಕಾ ಮಂಜೆ ಯಕಾಚಿ ಯವಜ್ನಾ಼ ತ್ಯಚಾ ಮಾನ್ಸಾಚಾ ಸ್ವಾಭಾತ್ ಆಸ್ಲಿತ ತ್ಯೊ ದೇವಾಲಾ ಆಡ್ವಾ ಜಾ಼ಲ್ಯಾ. ತ್ಯೊ ದೇವಾಚಾ ನೇಮಾ ಶಾರ್ಕಾ ಚಾ಼ಲತ್ ನಾಹಿ. ಆನಿ ಕ್ಯಾ ಕರಾಯಾ ವ್ಹಯಿತುಸ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","ಆಪಲಾ ಮಾನ್ಸಾಚಾ಼ ಸ್ವಭಾವ್ ಚಾ಼ಲಿವತ್ಯಾಲಿ ತೀ ಲೋಕ ದೇವಾಲಾ ವ್ಯವ್ಯಾಳಾಯಾ ವ್ಹಯಿತ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","ಫನ್ ತುಮಿ ತುಮಚಾ಼ ಮಾನ್ಸಾಚಾ಼ ಸ್ವಾಬಾವ್ ಚಾ಼ಲಿವತ್ಯಾಲಿ ಜಾ಼ಲ್ಹಾ ನಾಹಿಸಾ. ದೇವಾಚ಼ ಆತ್ಮ ತುಮ್ಚಿಪ ಖರ‍್ಯಾನಿಸ್ ಆಸ್ಲತ ತುಮಿ ಆತ್ಮಾಚಾ ಚಾ಼ಲಿವ್‌ನ್ಯಾತ್ ಗಾವಲ್ಯಾಸಾ ಕುನಾಪ ತರಿ ಕ್ರಿಸ್ತಾಚ಼ ಆತ್ಮ ನಸ್ಲತ, ತ್ಯೊ ಕ್ರಿಸ್ತಾಲಾ ಮಿಳುನ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","ತುಮಚ಼ ಧಡ್ ಪಾಪಾಚೆ ಆಶೆನಿ ಕವಾಬಿ ಮೇಲ್ಯಾಚೆಗತ್ ಜಾ಼ಲ್ಯಾ. ಫನ್ ಕ್ರಿಸ್ತ ತುಮ್ಚಿಪ ಆಸ್ಲಾತ ಆತ್ಮ ತುಮಾನಾ ಜೀವ್ ದೇತ. ಕಾ ಮಂಜೆ ಕ್ರಿಸ್ತಾನಿ ತುಮಾನಾ ನೀಯತಿಚಿ ಕೇಲ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","ಯೇಸುಲಾ ಮೇಲ್ಯಾಲ್ಯಾತ್ನಿ ಜಿತ್ತಾ ಉಠಿವಲ್ಯಾಲ್ಯಾಚ಼ ಆತ್ಮ ತುಮ್ಚಿಪ ಆಸಲ್ಯಾವ ಕ್ರಿಸ್ತ ಯೆಸುಲಾ ಮೆಲ್ಯಾಲ್ಯಾತ್ನಿ ಉಠಿವಲ್ಯಾಲಾ ತುಮಚಿಪ ಆಸಲ್ಯಾಲ್ಯಾ ಆಪಲ್ಯಾ ಆತಮ್ಯಾನಿ ತುಮಚಿ ಮೆಲ್ಯಾಲಿ ಮಡಿ ಜಿತಿ ಕರ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","ಹ್ಯಚಿ ಸಾಟಿ ಮಾಜಾ ಬನ್ಹಿ ಬಾವ್ಹಾನು ಆಮಿ ಲಾಜಿಮಾತ್ ಹಾವ್ ಫನ್ ಪವಿತ್ರಾತಮ್ಯಾನಿ ಚಾ಼ಲಾಚಾ ಲಾಜಿಮಾತ್ ಹಾವ್ ತ್ಯ ಸುಡುನ್ ಶರಿರಾಚೆ ಆಶೆಚೆಗತ್ ಜ಼ಗಾಚಾ ಲಾಜಿಮಾತ್ ನವ್ಹ. ");
INSERT INTO gok_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","ಕಾ ಮಂಜೆ ತುಮಚ಼ ಶಾರಿರಿಕ್ ಸ್ವಭಾವ್ ಕರಾಯಾ ವ್ಹಯಿ ಮಂಥ್ಯಾಲಿ ಬುರ್ಸಿ ಕಾಮ ಕರಾಯಾ ತುಮಿ ತುಮಚಾ಼ ಜೀವ್ನಾ ಉಪೇಗ್ ಕೇಲಾಸಾತ ತುಮಿ ಆತ್ಮಿಕ್ ತರನಿ ಮರ್ನಾರ್ ಫನ್ ತುಮಿ ತುಮ್ಚಾ ಶರೀರಾನಿ ಕರ್ತ್ಯಾಲ್ಯಾ ಬುರ್ಶಾ ಕಾಮಾನಾ ಮರಾಯಾ ತುಮಿ ಶೊಡ್ಲಸಾತ ಪವಿತ್ರಾತ್ಮಾಚೆ ಮಜ಼ತಿನಿ ಜೀವ್ನಾ ಕರ್ಸಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","ಕೊನ್ ಆಪ್‌ಲ್ಯಾಲಾ ದೇವಾಚಾ ಆತ್‌ಮ್ಯಾಚೆಗತ್ ಚಾ಼ಲ್ವಾಯಾ ವಪ್ಸುನ್ ದೇತ್ಯಾತ ತೀಸ್ ದೇವಾಚಿ ಪೋರ ಜಾ಼ಲ್ಯಾತ. ");
INSERT INTO gok_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","ಆಮಿ ಗೆತಲ್ಯಾಲ ಆತ್ಮ ಆಮಾನಾ ಆನಿಕ್ ಗುಲಾಮ್ ಕರ್ತ್ಯಾಲ ನವ್ಹ ಆನಿ ಆಮ್ಚಾತ್ ಭ್ಯಾ ಆಂತ್ಯಾಲ ನವ್ಹ ಆಮಿ ಗೆತಲ್ಯಾಲ ಪವಿತ್ರಾತ್ಮ ಆಮಾನಾ ದೇವಾಚಿ ಪೋರ ಮನ್ಹುನ್ ಕರ್ತ. ಹ್ಯಾಸ್ ಆತ್‌ಮ್ಯಾನಿ ಆಮಿ ದೇವಾಲಾ “ಬಾ ಮಾಜಾ ಬಾ ಮನ್ಹುನ್ ಹಾಕಟಾವ್, ");
INSERT INTO gok_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","ಆಮಿ ದೇವಾಚಿ ಪೊರ‍ ಜಾ಼ಲ್ಯಾವ್ ಮನ್ಹುನ್ ಪವಿತ್ರಾತ್ಮ ಆಮ್ಚಾ ಆತ್ಮಾ ಸಂಗ ವಳಕ್ ದೇತ. ");
INSERT INTO gok_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","ಆಮಿ ದೇವಾಚಿ ಪೊರ ಜಾ಼ಲ್ಯಾವ್ ಮನ್ಹುನ್ ಆಮಿ ತ್ಯನಿ ಆಪ್‌ಲ್ಯಾ ಲೊಕಾನಾ ಥೆವ್‌ಲ್ಯಾಲ್ಯಾ ಆಶಿರ್ವಾದಾನಾ ವಾರಸ್ದಾರ್ ಜಾ಼ಲ್ಯಾವ್. ಆನಿ ದೇವಾನಿ ಕ್ರಿಸ್ತಾಸಾಟಿ ಥೆವ್‌ಲ್ಯಾಲ್ಯಾತ್ ಸಾಹಿತ್ ಕ್ರಿಸ್ತಾ ಸಂಗ ವಾರಸ್ದಾರ್ ಜಾ಼ಲ್ಯಾವ್ ಕಾ ಮಂಜೆ ಕ್ರಿಸ್ತಾಚಾ ತರಾಸಾತ್ ಆಮಿ ವಾಟದಾರ್ ಜಾ಼ಲ್ಯಾವ ತ್ಯಚೆ ಮೈಮೆತ್ ಸಾಹಿತ್ ಆಮಿ ವಾಟದಾರ್ ವ್ಹನಾರ್. ");
INSERT INTO gok_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","ಮನಾ ವಾಟ ಆತಾ ಆಮಿ ಕಶ್ಟ ತರಾಸ್ ಗೆಥಾವ್. ಫನ್ ಆಮಾನಾ ಮೊರ‍್ಹ ದೇನಾರೆ ಮೈಮೆಲಾ ಹ್ಯೊ ಕಶ್ಟ ತರಾಸ್ ಬಗ್‌ಲ್ಯಾವ ಹ್ಯ ಕಾಮಾಲಾ ಯಯಿತ್ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","ಕಾ ಮಂಜೆ ಉತ್ಪತ್ತಿ ದೇವಾಚಾ ಪೊರಾಂಚೆಸಾಟಿ ದಿಸತ್ಯಾಲ್ಯಾಲಾ ಖುಬ್ ಆತುರಾನಿ ಮೊರ‍್ಹ ಬಗಿತ್ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","ಕಾ ಮಂಜೆ ಸ್ರಶ್ಟಿ ಆಪ್ಲಿ ಆಶಾ ನಸ್‍ಲ್ಯಾಚೆಗತ್ ಜಾ಼ಲ್ತಿ ಆಪ್‍ಲ್ಯಾ ಸ್ವತಾಚಾ ಉದ್ದೆಶಾನಿ ನವ್ಹ, ತ್ಯಚಿ ಇಚ್ಚಾಬಿ ನವ್ಹ, ಫನ್ ಆಸ ವ್ಹಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ದೇವಾಚಿ ಇಚ್ಚಾ ಹುತ್ತಿ. ತ್ಯಲಾ ಸ್ರಶ್ಟಿ ವಾಟ್ ಬಗೀತ್ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","ಸಗ್ಳಿ ಸ್ರಶ್ಟಿ ಯೆಕ್ ದಿಸ್ ಆಪ್ನು ನಾಸ್ ವ್ಹವುನ್ ಜಾ಼ತ್ಯಾಲ್ಯಾ ಗುಲಾಮಾವ್ನಿ ಸುಟ್ನುಕ್ ವ್ಹವುನ್ ಆನಿ ದೇವಾಚಾ ಪೊರಾಂಚ಼ ಮೈಮೆನಿ ಬರ್ಲ್ಯಾಲ್ಯಾ ಸ್ವಾತಂತ್ರ್ಯಾತ್ ವಾಟದಾರ್ ವ್ಹತ್ತ. ");
INSERT INTO gok_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","ಕಾ ಮಂಜೆ ಸ್ರಶ್ಟಿ ಆತಾಚಾ ಯಳಾ ಪರತ್ ಪೈಲ್ಯಾ ಯಳಾಚಾ ದುಖಾಚೆಗತ್ ಲೊಳತ್ ಹಾ ಮನ್ಹುನ್ ಆಮಾನಾ ಠಾವ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","ತ್ಯವ್ಡಸ್ ನವ್ಹ ಫನ್ ಆತ್ಮಾಚ಼ ಪೈಲ ಫಳ್ ಮನ್ಹುನ್ ಗೆತಲ್ಯಾಲಿ ಆಮಿ ಸಾಹಿತ್ ಆಮ್ಚೆಸಾಟಿ ಖುಬ್ ಆಶೆನಿ ದೇವಾಚಿ ಪೊರ ವ್ಹಯಾಲಾ ಸ್ವತಂತ್ರ್ಯಾಲಾ ಆಮ್ಚಾ ಶರಿರಾಚೆ ಸುಟ್ನುಕಿಲಾ ರ‍್ಯಾಕ್‌ತ್ಯಾವ್. ");
INSERT INTO gok_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","ಆಮಿ ರಕ್ಶನ್ ಗೆತ್ಲೆ ಫನ್ ಆಮಿ ಬಗ್‌ತ್ಯಾಲಿ ಆಶಾ ಖರ‍್ಯಾಚಿ ಆಶಾ ನವ್ಹ ಕಾ ಮಂಜೆ ಆತಾತರಿ ಬಗ್‌ಲ್ಯಾಲ್ಯಾಲಾ ಕೊನ್ತರಿ ಆಶಾ ಕರಾಚ಼ ಹಾ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","ಫನ್ ಆಮಿ ಬಗ್‌ಲ್ಯಾ ನಸ್‍ಲ್ಯಾಲ್ಯಾಲಾ ಆಮಿ ಆಶಾ ಕೆಲ್ಯಾವ ಆಮಿ ತ್ಯಲಾ ಥಂಡ್ಪನಾನಿ ರ‍್ಯಾಕ್‌ತ್ಯಾವ್. ");
INSERT INTO gok_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","ತಸಸ್ ಆಮಿ ಬಳ್ ನಸ್‌ಲ್ಯಾಲಿ ಜಾ಼ಲ್ಯಾವ್ ಮನ್ಹುನ್ ಆಮಾನಾ ಬಳ್ ನಸ್‌ಲ್ಯಾಲ್ಯಾತ್ ಪವಿತ್ರಾತ್ಮಾ ಆಮಾನಾ ಮಜ಼ತ್ ಕರ್ನಾರ್. ಕಾ ಮಂಜೆ ಆಮಿ ಕಸ ಮಾಗ್ನ ಕರಯಾ ವ್ಹಯಿ ಆನಿ ಕಶಾಸಾಟಿ ಮಾಗ್ನ ಕರಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಆಮಾನಾ ಸಮಜ಼ತ್ ನಾಹಿ. ಫನ್ ಪವಿತ್ರಾತ್ಮ ಆಪ್ನುಸ್ ಆಮ್ಚಿಸಾಟಿ ದೇವಾಪ ಫೊಡಾಯಾ ವ್ಹಯಿತ್ ನಸ್‌ಲ್ಯಾಲ ಮಾಗ್ನ ಕರ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","ಮನ್ ಬಗ್‌ತ್ಯಾಲ್ಯಾ ದೇವಾಲಾ ಪವಿತ್ರಾತ್ಮಾಚಾ ಮನಾತ್ಲ ಸಗ್ಳ ಠಾವ ಹಾ. ಕಾ ಮಂಜೆ ದೇವಾಚಾ ಮನಾಚೆಗತುಸ್ ಪವಿತ್ರಾತ್ಮ ದೇವಾಚಾ ಲೊಕಾಂಚೆಸಾಟಿ ದೇವಾಲಾ ಆವ್ಡ ಶಾರ್ಕ ಕರ್ತ. ");
INSERT INTO gok_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","ದೇವ್ ಆಪ್‍ಲ್ಯಾಲಾ ಮಾಯಾ ಕರ್ತ್ಯಾಲ್ಯಾಂಚೆ ಚಾ಼ಂಗಲ್ಯಾಸಾಟಿ ಪರತೇಕ್ ಕಾಮ ಕರ್ತ್ಯೊ ಮನ್ಹುನ್ ಆಮಾನಾ ಠಾವ ಹಾ. ತ್ಯಾ ಲೊಕಾನಾ ದೇವಾನಿ ನಿವಡ್‍ಲ್ಯಾಲಿ, ಕಾ ಮಂಜೆ ತೀ ತ್ಯಚಿ ಯವಜ್ನಾ ಜಾ಼ಲ್ಥಿ. ");
INSERT INTO gok_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","ಕುನಾಲಾ ದೇವಾನಿ ಪೈಲೆ ದರ್ನಿ ನಿವ್ಡುನ್ ಗೇತ್ಲ ಹುತ್ತ. ಲೇಕಾಚೆಗತ್ ವ್ಹಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ನಿರ್ದಾರ್ ಕೇಲಾ. ಆಸ ಆಸ್ಥಾನಾ, ಇಸ್ವಾಸಾತ್ ಆಸ್‍ಲ್ಯಾಲ್ಯಾ ಲೊಕಾನಾ ಲ್ಯೊಕುಸ್ ಆಂದಿಚಾ಼ ವ್ಹಯಾ ವ್ಹಯಿ. ");
INSERT INTO gok_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","ಆಸ ಆಸ್ಥಾನಾ ಕುನಾ ಕುನಾಲಾ ತ್ಯನಿ ಹಾಕ್ಟುನ್ ನಿವಡ್‍ಲ್ಯಾತ ಆನಿ ಕುನಾಕುನಾಲಾ ತ್ಯನಿ ಹಾಕಟ್‍ಲ್ಯಾತ ತ್ಯನಾ ತ್ಯೊ ನಿಯತಿಚಿ ಕರ್ತೊ. ಆನಿ ಆಪ್ಲೆ ಮೈಮಾತ್ ವಾಟದಾರ್ ಕರ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","ಆಸ ಆಸ್ಥಾನಾ ಹ್ಯಚೆ ಗುಶ್ಟಿತ್ ಆಮಿ ಕ್ಯಾ ಸಾಂಗುಯಾ? ದೇವ್ ಆಮ್ಚಿ ಸಂಗ ಆಸ್ಥಾನಾ, ಆಮಾನಾ ಆಡ್ವಿ ಯತ್ಯಾಲ ಕೊನ್ ಹಾ? ");
INSERT INTO gok_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","ದೇವ್‍ ಆಪ್‍ಲ್ಯಾ ಸ್ವತಾಚಾ ಲೇಕಾಲಾ ಉರ್ವುನ್ ಗಿಹ್ಯಾಚೆ ಆಂದಿ ಆಮ್ಚೆ ಸಗ್‍ಳ್ಯಾಂಚೆ ಸಾಟಿ ವಪ್ಸುನ್ ದಿಲಾ. ಮನ್ಹುನ್ ಆತಾ, ದೇವ್ ಯೇಸು ಸಂಗ ಆಮಾನಾ ಸಗ್ಳ ಫುಕಟ್ ದಿಯಾಚೆ ಆಂದಿ ರಾಹಿಲ್ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","ದೇವಾನಿ ನಿವಡ್‌ಲ್ಯಾಲ್ಯಾ ಲೊಕಾಂಚಿವ ಕೊನ್ ಗುನ್ನಾ ವಾವ್ನಾರ್? ದೇವಾನಿ ತ್ಯನಾ ಗುನ್ನದಾರ್ ನವ್ಹ ಮನ್ಹುನ್ ನಿರ್ನಯ್ ಕೇಲಾ! ");
INSERT INTO gok_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","ಆಸ ಆಸ್ಥಾನಾ ತ್ಯನಾ ಚು಼ಕಿಚ಼ ಮನ್ಹುನ್ ಕೊನ್ ಸಾಂಗ್ನಾರ್? ಮೇಲ್ಯಾಲಾ ಕ್ರಿಸ್ತ ಯೇಸು ತ್ಯೊ ಮರ್ನಾತ್ನಿ ಉಟ್‍ಲ್ಯಾ ಆನಿ ದೇವಾಚೆ ಉಜ಼ವ್ಯಾಂಗ್ನಿ ಬಸ್ಲಾ ಆನಿ ತ್ಯೊ ಆಮ್ಚಿ ಸಾಟಿ ದೇವಾಪ ಇನಂತಿ ಕರ್ತ್ಯೊ. ");
INSERT INTO gok_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","ಆಸ ಆಸ್ಥಾನಾ ಆಮಾನಾ ಕ್ರಿಸ್ತಾಚೆ ಮಾಯೆತ್ನಿ ದುರ್ ಕರ್ನಾರಾ ಕೊನ್ ಹಾ? ಕಶ್ಟ, ತರಾಸ್, ಸಂಕಟ್ ನಾಹಿತ ಭುಕ್ ವ್ಹವುನಿ ಗರಿಬ್ತಿತಿ ಕ್ಯಾ ಅಪಾಯ, ಮರಾನ್ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","ಪವಿತ್ರ ಗ್ರಂಥಾತ್ ಆಸ ಲಿವ್‌ಲ್ಯಾಲ ಹಾ. “ತುಮ್ಚೆಸಾಟಿಸ್ ಆಮಿ ಸಗ್‌ಳ್ಯಾ ಯಳಾತ್ ಮರ್ನಾಚೆ ತಾವ್ಡತ್ ಹಾವ್ ಕಾಪಾಯಾ ನೆಥ್ಯಾಲ್ಯಾ ಮೆಂಡ್ರಾಚೆಗತ್ ವ್ಯವಾರ್ ಕೆಲ್ಯಾ. ” ");
INSERT INTO gok_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","ಫನ್ ಆಮ್ಚೆ ಸಾಟಿ ಆಪ್ಲಿ ಮಾಯಾ ಕೆಲ್ಯಾಲ್ಯಾಲಾ ಹೇ ಸಗ್ಳೆ ಖನ್ಕತಿತ್ ಆಮಾನಾ ಪೂರ್ನ ಜೀತ್ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","ವ್ಹಯ್, ಕ್ರಿಸ್ತಾಚೆ ಮಾಯೆತ್ನಿ ಆಮಾನಾ ಕಚಾಲಾಸ್ ಯಗಳಾಯಾ ವ್ಹನಾರ್ ನಾಹಿ ಮನ್ಹುನ್ ಮನಾ ಖರ‍್ಯಾನಿಸ್ ಸಮಾಜ಼ಲ್ಯಾ. ಮರಾನ್ ವ್ಹವುನಿ, ಜಿವ್ ವ್ಹವುನಿ ದೇವ್ ದುತ್ ವ್ಹವುಂತ, ಅಧಿಕಾರಿ ವ್ಹವುಂತ ಹ್ಯಾ ಕಾಲಾತ್ ವ್ಹವುನಿ ಮೊರ್ಲ್ಯಾ ಕಾಲಾತ್ ವ್ಹವುನಿ ");
INSERT INTO gok_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","ನಾಹಿತ ಹೆ ದುನೆಚಾ ವೈಲ್ಯಾ ಖನ್ಕತಿ ವ್ಹವುಂತಾ ಬುಡ್‍ಲ್ಯಾ ಖನ್ಕತಿ ವ್ಹವುಂತಾ ಉತ್ಪನ್ ಕೇಲ್ಯಾಲಿ ಕುಟ್ಲಿ ಸಾಮ್ನ ವ್ಹವುಂತ ಆಮ್ಚಾ ಪ್ರಭು ಯೇಸು ಕ್ರಿಸ್ತಾಪ್ನಿ ದಾವುನ್ ಆಲ್ಯಾಲೆ ದೇವಾಚೆ ಮಾಯೆನಿ ಆಮಾನಾ ಯಗಳಾ ವ್ಹನಾರ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","ಮೀ ಕ್ರಿಸ್ತಾಪ ಹಾ ಆನಿ ತುಮಾನಾ ಖರ ಸಾಂಗ್ತೊ. ಮಿ ಲಬಾಡ್ ಸಾಂಗಿತ್ ನಾಹಿ. ಮಾಜಾ ಯವಜ್ನಾ಼ ಪವಿತ್ರಾತ್‌ಮ್ಯಾನಿ ಚಾ಼ಲಿವ್ನಾರ‍್ಯಾಲಾ ಜಾ಼ಲೆ. ತೀಸ್ ಮಾಜಿ ಮನಾಚಿ ವಳಕ್. ");
INSERT INTO gok_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","ಮನಾ ಖುಬ್ ದುಖ್ ಹಾ ಆನಿ ಮಾಜಾ ಮಾನಾತ್ ಕವಾಬಿ ಪಿಡಾ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","ತೇ ಮಾಜ಼ ಭನ್ಹಿ ಭಾಹು ಜಾ಼ಲ್ಯಾತ; ಹೇ ದುನೆಚಾ ಕುಟ್ಮಾತ್ಲ ಜಾ಼ಲ್ಯಾತ. ತ್ಯನಾ ಮಜ಼ತ್ ಕರಾಯಾ ಕ್ರಿಸ್ತಾಲಾ ಸುಡುನ್ ಸರಾಪ್ ಗಿಯಾ ಆಸ ವ್ಹವು ಸಕ್ತ. ");
INSERT INTO gok_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","ತೀ ಇಸ್ರಾಯೇಲಾಚಿ ಲೊಕ ಜಾ಼ಲ್ಯಾತ. ತ್ಯನಾ ಆಪ್ಲಿ ಪೊರ ಮನ್ಹುನ್ ಕೆಲ್ಯಾತ ಆನಿ ಆಪ್ಲಿ ಮೈಮಾ ತ್ಯನಾ ದ್ಯಾವ್ಲೆ; ತ್ಯನಿ ತ್ಯಂಚಿ ಸಂಗ ಕರಾರ್ ಕೆಲ. ಆನಿ ಧರ್ಮಶಾಸ್ತಾರ್ ದಿಲ ತ್ಯಂಚಿಪ ಖರ‍್ಯಾಚಿ ಆರಾದಾನ್ ಹಾ; ತೀ ದೇವಾಚ಼ ವಾಗ್ದಾನ್ ಗೆತಲ್ಯಾಲಿ ಜಾ಼ಲ್ಯಾತ; ");
INSERT INTO gok_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","ತೇ ಆಮ್ಚಾ ಹಿಬ್ರಿಯಾ ವಡ್ಲಾಂಚಿ ಪಿಳ್ಗಿ ಜಾ಼ಲ್ಯಾತ; ಆನಿ ಮಾನ್ಸಾಚಾ ರುಪಾತ್ ಕ್ರಿಸ್ತ್ ತ್ಯಂಚಾ ಕುಳಾತ್ಲಾ ಜಾ಼ಲ್ಯಾ. ಸಗ್‍ಳ್ಯಾವ ರಾಜ಼್ ಭಾರ್ ಚಾ಼ಲಿವತ್ಯಾಲ್ಯಾ ದೇವಾಲಾ ಕವಾಬಿ ಸ್ತೊತ್ರ ವ್ಹವುನಿ! ಆಮೇನ್. ");
INSERT INTO gok_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","ಮೀ ಆಸ ಸಾಂಗಿತ್ ನಾಹಿ. ದೇವಾನಿ ಅಪ್ಲ ವಚ಼ನ್ ಪೂರ್ನ ಕೇಲ ನಾಹಿ ಮನ್ಹುನ್ ಸಾಂಗಿತ್ ನಾಹಿ ಇಸ್ರಾಯಾಲಾಚಿ ಸಗ್ಳಿ ಲೊಕ ಸಾಹಿತ್ ದೇವಾಚಿ ಲೊಕ ನವ್ಹತ. ");
INSERT INTO gok_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","ನಾಹಿತ ಅಬ್ರಹಾಮಾಚೆ ಪಿಳ್ಗಿತ್ಲಿ ಸಗ್ಳಿ ದೇವಾಚಿ ಪೊರ ನವ್ಹತ. ದೇವಾನಿ ಅಬ್ರಹಾಮಾಲಾ ಸಾಂಗ್ಲ ಮೀ ತುಲಾ ಸಬ್ದ ದೇತೊ ಇಸಾಕಾಪ್ನಿ ಯತ್ಯಾಲಿ ಪಿಳ್ಗಿ ತ್ಯವ್ಡಿಸ್ ತುಜಿ. ");
INSERT INTO gok_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","ಹ್ಯಚಾ಼ ಅರ್ಥ ಕ್ಯಾ ಮಂಜೆ ಶರಿರಾಚಾ ಸಮಂದಾನಿ ಜ಼ಲಾಮ್‌ಲ್ಯಾಲಿ ಸಗ್ಳಿ ದೇವಾಚಿ ಪೋರ ನವ್ಹತ. ವಾಗ್ದಾನಾನಿ ಜ಼ಲಾಮ್‌ಲ್ಯಾಲಿ ದೇವಾಚಿ ಪೋರ ಖರಿ ಪಿಳ್ಗಿ ಜಾ಼ಲೆ. ");
INSERT INTO gok_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","ಕಾ ಮಂಜೆ ದೇವಾನಿ ತ್ಯಲಾ, “ನೇಮಸ್‌ಲ್ಯಾಲ್ಯಾ ಕಾಲಾತ್ ಮೀ ಮಾಗಾರಾ ಪರಾತ್ತೊ. ತವಾ ಸಾರಳಲಾ ಯೋಕ್ ಲ್ಯೊಕ್ ರಾನ್ಹಾರ್. ” ಮನ್ಹುನ್ ವಾಗ್ದಾನ್ ಕೇಲ. ");
INSERT INTO gok_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","ತ್ಯವ್ಡಸ್ ನವ್ಹ. ರೆಬೆಕಾಲಾಬಿ ದೋಗ ಪ್ಯೊರ್ಗ ಹುತ್ತ. ತ್ಯಾ ದೊಗಾನಾಬಿ ಯೋಕುಸ್ ಬಾ. ತ್ಯೊಸ್ ಆಮಚಾ಼ ವಡಿಲ್ ಜಾ಼ಲ್ಯಾಲಾ ಇಸಾಕ್. ");
INSERT INTO gok_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","ತೇ ದೋಗ ಪ್ಯೊರ್ಗ ಜ಼ಲ್ಮಾಚೆ ಆಂದಿ ನಾಹಿತ ಚಾ಼ಂಗ್ಲ ನಾಹಿತ ಬುರ್ಸ ಕರಾಚೆ ಆಂದಿ ದೇವಾನಿ ಆಪ್‍ಲ್ಯಾ ಉದ್ದೆಶಾಲಾ ನಿವಡ್‍ಲ್ಯಾಲೆಸಾಟಿ ಆಸ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","ತೇ ಕರ್ತ್ಯಾಲ್ಯಾ ಕಾಮಾಸಾಟಿ ತ್ಯನಾ ಹಾಕಟ್ಲ ನಾಹಿತ. ತ್ಯಂಚಾ ಹಾಕಟ್‍ನ್ಯಾ ಸಾಟಿ ತ್ಯನಿ ತಿಲಾ, “ಥೊರ್ಲಾ ದಾಕ್‍ಟ್ಯಾಚಿ ಸೇವಾ ಕರ್ನಾರ್” ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","ತಸಸ್, ಮೀ ಯಾಕೊಬಾಚಿ ಮಾಯಾ ಕಿಲಿ ಫನ್ ಏಸಾವಲಾ ವಿರೊದ್ ಕೇಲಾ. ಮನ್ಹುನ್ ಪವಿತ್ರ ಗ್ರಂಥ ಸಾಂಗ್ತ. ");
INSERT INTO gok_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","ತಸ ಜಾ಼ಲ್ಯಾವ ಆಮಿ ದೇವಾಲಾ ಅನೆವ್ ಕರ್ತ್ಯಾಲಾ ಮನ್ಹುನ್ ಸಾಂಗಾಯಾ ವ್ಹಯಿಲ್ ಕ್ಯಾ? ಖರ‍್ಯಾನಿಸ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","ಕಾ ಮಂಜೆ ದೇವಾನಿ ಮೊಶೆಲಾ ಮೀ ಕುನಾಲಾ ಕರುನಾ ದಾವಾಯಾ ವ್ಹಯಿ ಮಂಥೊ ತ್ಯಲಾಸ್ ಕರುನೆ ದ್ಯಾವ್ನಾರ್ ಮೀ ಕುನಾಲಾ ಕನಿಕಾರ್ ದಾವಾಯಾ ವ್ಹಯಿ ಮಂಥೊ ತ್ಯನಾಸ್ ಕನಿಕಾರ್ ದ್ಯಾವ್ನಾರ್ ಮನ್ಹುನ್ ಸಾಂಗ್ಲ. ");
INSERT INTO gok_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","ಆಸ ಆಸ್ಥಾನಾ ಸಗ್ಳ ಮಾನ್ಸ ಜಾ಼ಲ್ಯಾಲಿ ಆಮಿ ಕ್ಯಾ ಕರ್ತ್ಯಾವ್ ನಾಹಿತ ಆಮಾನಾ ಕ್ಯಾ ವ್ಹಯಿ ಮಂಥ್ಯಾಲ್ಯಾವ ಆಧಾರ್ ನಾಹಿ. ಫನ್ ನಿಸ್ಥ ದೇವಾಚಾ ಕರುನಾವ ಆಧಾರ್ ವ್ಹವುನ್ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","ಪವಿತ್ರ ಪುತಿಕಾತ್ ದೇವಾನಿ ಈಜಿಪ್ತಾಚಾ ರಾಜಾಲಾ, “ಮಿ ತುಲಾ ಮಾಜ಼ ಬಳ್ ದಾವಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಮಾಜ಼ ನಾವ್ ದುನೆತ್ ಸಗ್ಳ ಪಗಳಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ತುಲಾ ರಾಜಾ಼ ಕೇಲ್ಯಾ. ಮನ್ಹುನ್ ಸಾಂಗ್ಲ ");
INSERT INTO gok_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","ಮನ್ಹುನ್ ದೇವ್ ಕುನಾಲಾ ಕರುನೆ ದಾವಾಯಾ ವ್ಹಯಿ ಮಂಥೊ ತ್ಯಲಾ ಕರುನೆ ದ್ಯಾವ್ತೊ. ದೇವ್ ಕುನಾಲಾ ಹಠೊಳಾ ಕರಾಯಾ ವ್ಹಯಿ ಮಂಥೊ ತ್ಯಲಾಸ್ ಹಠೊಳಾ ಕರ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","ಫನ್, ತುಮ್ಚಾತ್ಲಾ ಕೋನ್ ತರಿ ಮನಾ, “ಆಸ ಆಸ್ಥಾನಾ, ಕೋನ್ ತರಿ ಚು಼ಕಿತ್ ಹಾ ಮನ್ಹುನ್ ಕಸಾ ಶೊದ್ನಾರ್? ದೇವಾಚಾ ಸಬ್ದಾಲಾ ಆಡ್ವಾ ಯನಾರಾ ಕೋನ್? ");
INSERT INTO gok_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","ಫನ್, ಯೇ ಮಾನ್ಸಾ ದೇವಾಲಾ ಆಡ್ವ ಬೊಲಾಯಾ ತು ಕೋನ್? ಯಕಾ ಮಾತಿಚಾ ಮೊಗ್ಯಾನಿ ಆಪ್‍ಲ್ಯಾಲಾ ಘಡಿವಲ್ಯಾಲ್ಯಾಲಾ ತು ಮನಾ ಆಸ ಘಡಿವ್ಲಸ್ ಕಾ ಮನ್ಹುನ್ ಇಚಾರಾಲಾ ವ್ಹಯಿಲ್ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","ಕುಂಬಾರ್ ಆಪ್‌ಲ್ಯಾಲಾ ಮನ್ ಯಯಿಜೊ಼ಗ ಯಕಾಸ್ ಮಾತಿಚಾ ಉಂಡ್ಯಾನಿ ದುಸ್ರಿ ದುಸ್ರಿ ಗ್ಯಾಡ್ಗಿ ಘಡ್ವಿತ್ ನಾಹಿ ಕ್ಯಾ? ತ್ಯೊ ಯಾಕ್ ಚಾಂಗಲ್ಯಾ ಕಾಮಾಲಾ ವಾಪ್ರಾಯಾ ಆನಿ ಯಾಕ್ ಕಸ್‍ಲ್ಯಾಬಿ ಕಾಮಾಲಾ ವಾಪ್ರಾಯಾ ಸಾಟಿ ಘಡಿವ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","ದೇವಾನಿ ಕೇಲ್ಯಾಲ ಸಾಹಿತ್ ಹ್ಯಸ್. ತ್ಯೊ ಆಪ್ಲಾ ರಾಗ್ ದಾವುನ್, ಆಪ್ಲ ಬಳ್ ಲೋಕಾನಾ ದಾವಾಯಾ ವ್ಹಯಿ ಮನ್ಲಾತ. ತ್ಯೊ ಆಪ್‍ಲ್ಯಾ ರಾಗಾತ್ ಗಾಹುನ್ ನಾಶ್ ವ್ಹತ್ಯಾಲ್ಯಾ ಲೋಕಾನಾ ಖುಬ್ ಥಂಡ್ಪನಾನಿ ಸುಸ್ವುನ್ ಗಿತ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","ದೇವಾನಿ ಆಪ್ಲಿ ಪುಸ್ಕಳ್ ಮೈಮೆ ದಾವಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಥಂಡ್ಪನಾನಿ ವಾಟ್ ಬಗಿತಾ. ಆಪ್ಲಿ ಕರುನಾ ಗೆತಲ್ಯಾಲ್ಯಾ ಲೋಕಾನಾ ದೇವಾನಿ ತೀ ಮೈಮಾ ದಿಯಾ ವ್ಹಯಿ ಮನ್ಲಾ. ಆಪ್ಲಿ ಮೈಮಾ ಗಿಹ್ಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ದೇವಾನಿ ತ್ಯಾ ಲೋಕಾನಾ ತಯಾರ್ ಕಿಲಿತ. ");
INSERT INTO gok_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","ಕಾ ಮಂಜೆ ತ್ಯನಿ ಹಾಕಟ್‍ಲ್ಯಾಲ್ಯಾಲಿ ಲೋಕ ಆಮಿಸ್. ದೇವಾನಿ ಆಮಾನಾ ಯೆಹುದ್ಯಾತ್ನಿ ತ್ಯವ್ಡಸ್ ನವ್ಹ ಯೆಹುದಿ ನಸ್‍ಲ್ಯಾಲ್ಯಾತ್ನಿಬಿ ಹಾಕ್ಟಿತ. ");
INSERT INTO gok_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","ಪವಿತ್ರ ಗ್ರಂಥಾಚ಼ ಹೋಶಯಚ಼ ಪುಸ್ತಕ್ ಹೇ ತರನಿ ಲಿವ್‌ಲ್ಯಾ. “ಮಾಜಿ ನಸ್‌ಲ್ಯಾಲಿ ಲೋಕ ಮಾಜಿ ಲೋಕ ಮನ್ಹುನ್ ಸಾಂಗ್ತೊ. ‘ಮಾಜಿ ಮಾಯೆಚಿ ನಸ್‌ಲ್ಯಾಲ್ಯಾನಾ ಮಾಜೆ ಮಾಯೆಚಿ ಮನ್ಹುನ್ ಸಾಂಗ್ನಾರ್’ ಹೋಶಯ 2:23 ");
INSERT INTO gok_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","ಆನಿ ಕಚಾ ಜಾ಼ಗ್ಯಾತ್, ‘ತುಮಿ ಮಾಜಿ ಲೋಕ ನವ್ಹಸಾ ಮನ್ಹುನ್ ಸಾಂಗ್‍ಲ್ಯಾ ತ್ಯಾಸ್ ಜಾ಼ಗ್ಯಾವ ತ್ಯನಾ ಜೀವ್ ಆಸ್ನಾರ‍್ಯಾ ದೇವಾಚಿ ಪೋರ” ಮನ್ಹುನ್ ಹಾಕಟ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","ತ್ಯವ್ಡಸ್ ನವ್ಹ ಯೇಶಾಯನಿ ಇಸ್ರಾಯಲಾಚೆ ಗುಶ್ಟಿತ್ ವರ್ಡುನ್ ಸಾಂಗ್‌ಲ್ಯಾ. “ಸಮಿಂದೊರಾಪ ಆಸ್‌ಲ್ಯಾಲೆ ವಾಳ್ವಚೆಗತ್ ಇಸ್ರಾಲ್ ಲೆಖ್ಯಾತ್ ನಸ್‌ಲ್ಯಾಲಿ ಜಾ಼ಲ್ಯಾತ. ಫನ್ ತ್ಯಾ ಲೋಕಾತ್ ಥುಡಿ ತ್ಯವ್ಡಿಸ್ ರಕ್ಶನ್ ಗೆನಾರ್; ");
INSERT INTO gok_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","ವ್ಹಯ್ ಪ್ರಭು ಧರ್ಥಿವ್‌ಲ್ಯಾ ಲೋಕಾನಾ ಆಪ್ಲಿ ಬುಲಿ ಪಾಟ್‍ಕ್ಯಾನಿ ಕರುನ್ ಸುಪಿವ್ನಾರ್. ” ");
INSERT INTO gok_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","ಹ್ಯ ಕಸ ಮಂಜೆ ಯೇಶಾಯನಿ ಆಂದಿ ಸಾಂಗ್‍ಲ್ಯಾ ಶಾರ್ಕ: “ಸರ್ವ ಶಕ್ತ ಜಾ಼ಲ್ಯಾಲ್ಯಾ ಪ್ರಭುನಿ ಆಮ್ಚಿಸಾಟಿ ಥೊಡ್ಯಾ ಪಿಳ್ಗಿತ್‍ಲ್ಯಾನಾ ಥೆವ್ಲ ನಸ್ಥತ. ತ್ಯನಿ ಆಸ ಕೇಲ್ಯಾ ನಸ್‌ಲ್ಯಾವ ಆಮಿ ಸದೋಮಾಚೆಗತ್ ಗೊಮೊರಾಚೆಗತ್ ರಾಹಿತಾವ್. ” ");
INSERT INTO gok_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","ಹ್ಯಚಾ಼ ಅರ್ಥ ಕ್ಯಾ ಮಂಜೆ, ಯೆಹುದ್ಯ ನಸ್‌ಲ್ಯಾಲಿ ನೀಯತಿಚಿ ವ್ಹಯಾ ಯತ್ನ ಕರಿತ್ ನವ್ಥಿತ. ತೇ ಇಸ್ವಾಸಾನಿ ತ್ಯಚಿ ಸಂಗ ನೀಯತಿಚಿ ಜಾ಼ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","ತ್ಯಾಸ್ ಯಳಾಲಾ ಇಸ್ರಾಯೆಲಾಚಿ ಲೋಕ ಆಪ್‍ಲ್ಯಾಲಾ ನಿಯತಿಚಿ ಕರಾಯಾ ಯೊಕ್ ನಿಯಮ್ ಸುದಿತ ಫನ್ ತ್ಯ ತ್ಯನಾ ಗಾವ್ಲ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","ತ್ಯನಾ ಕಾ ಗಾವ್ಲ ನಾಹಿ? ಕಾಮಾನಿ ನೀಯತಿಚಿ ವ್ಹಯಾಲಾ ತ್ಯಂಚಾನಿ ಯತ್ನ ಕಿಲಿತ ಫನ್ ಇಸ್ವಾಸಾಚಾ಼ ಅದಾರ್ ಕೆಲಾ ನಾಹಿ. ಲೊಕ ದೊಂಡ್ಯಾಚಿ ಠ್ಯಾಸ್ ಲಾಗುನ್ ಪಡ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","ಪವಿತ್ರ ಪುತಿಕ್ ತ್ಯಾ ಧೊಂಡ್ಯಾಚೆ ಗುಶ್ಟಿತ್ ಆಸ ಸಾಂಗ್ತ. “ಹಬಕ್, ಮೀ ಸಿಯೋನಾತ್ ಯೋಕ್ ದೊಂಢಾ ಥೆವ್ತೊ. ಹ್ಯಾ ದೊಂಡ್ಯಾನಿ ಲೋಕ ಠ್ಯಾಸ್ ಲಾಗುನ್ ಪಡ್ನಾರ್. ಫನ್ ತ್ಯಾ ದೊಂಡ್ಯಾವ ಇಸ್ವಾಸ್ ಥೆವ್ನಾರಾ ಕಂದಿಸ್ ಫಸ್ನಾರ್ ನಾಹಿ.” ");
INSERT INTO gok_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","ಮಾಜಾ ಭನ್ಹಿ ಭಾವ್ಹಾನು, ಮಾಜಿ ಲೋಕ ರಕ್ಷನ್ ಗಿಹ್ಯಾ ವ್ಹಯಿತ ಮನ್ಹುನ್ ಮನಾ ಖುಬ್ ಆಶಾ ಹಾ. ಮೀ ದೇವಾಪ ತ್ಯಂಚಿಸಾಟಿ ಮಾಗ್ನ ಕರ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","ತ್ಯನಾ ದೇವಾಪ ಖುಬ್ ಭಕ್ತಿ ಹಾ ಹ್ಯಲಾ ಮೀ ವಳಕ್ ದೇತೊ. ಫನ್ ತ್ಯಂಚಿ ಭಕ್ತಿ ಖರ‍್ಯಾಚಾ ಗಿನ್ಯಾನಾವ ಟಿಕುನ್ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","ದೆವಾಪ್ನಿ ಗಾವತ್ಯಾಲಿ ನೀಯತ್ ತ್ಯನಾ ಠಾವಿ ನಸ್ತಾನಾ ಸ್ವತಾಚಿ ನಿಯೆತ್ ಸ್ತಾಪನ್ ಕರಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ದೆವಾಚೆ ನಿಯೆತಿಲಾ ವಾಕ್ಲಿ ನಾಹಿತ. ");
INSERT INTO gok_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","ಆಪ್ಲಿವ ಇಸ್ವಾಸ್ ಥೆವ್ನಾರಾ ಪರತೇಕ್ ಜಾ಼ನ್ ನೀತಿಚಾ಼ ತೀರ್ಮನ್ ವ್ಹಯಾಸಾಟಿ ಕ್ರಿಸ್ತಾನಿ ದರ್ಮಶಾಸ್ತಾರ್ ಪೂರ್ನ ಕೇಲ. ");
INSERT INTO gok_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","ಧರ್ಮಶಾಸ್ತಾರಾಚ಼ ಐಕುನ್ ತ್ಯಚಿಗತ್ ಚಾ಼ಲತ್ಯಾಲಾ ನಿಯತಿಚಾ಼ ಮನ್ಹುನ್ ಗೆಥ್ಯಾಲ್ಯಾಸ್ ಲಾಗುನ್ ಮೊಶೆನಿ ಆಸ ಲಿವ್‍ಲ್ಯಾ “ಧರ್ಮಶಾಸ್ತಾರ್ ಕೊನ್ ಪ್ಯಾಳ್ತೊ ತ್ಯೊ ಜೀವ್ನಾ ಕರ್ತೊ. ” ");
INSERT INTO gok_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","ಫನ್ ಇಸ್ವಾಸಾನಿ ದೇವಾಚೆ ಮೊರ‍್ಹ ನೀಯತಿಚ಼ ಮನ್ಹುನ್ ಗೆಥ್ಯಾಲ್ಯಾಸ್ ಲಾಗುನ್ ಪವಿತ್ರ ಪುತೀಕ್ ಆಸ ಸಾಂಗ್ತ, “ತು ತುಲಾಸ್ ಕಾಯ್ ಆಸ ಇಚಾರು ನಕೊಸ್ ಕ್ರಿಸ್ತಾಲಾ ಸ್ವರ್ಗಾತ್ನಿ ಖಾಲ್ ಹಾಕ್ಟುನ್ ಆನಾಯಾ ಕೊನ್ ಜಾ಼ನಾರ್? ");
INSERT INTO gok_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","ನಾಹಿತ ತುಲಾಸ್ ತು ಆಸ ಇಚಾರು ನಕೊಸ್ ಕ್ರಿಸ್ತಾಲಾ ಮೇಲ್ಯಾಲ್ಯಾತ್ನಿ ಆನಾಯಾ ಪಾತಾಳಾತ್ ಕೊನ್ ಜಾ಼ನಾರ್? ");
INSERT INTO gok_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","ಪವಿತ್ರ ಪುತೀಕ್ ಆಸ ಸಾಂಗ್ತ. “ದೇವಾಚಿ ವಚ಼ನ ತುಮ್ಚೆ ಜ಼ವಳುಸ್ ಹಾತ. ತಿ ತುಮ್ಚಾ ತೊಂಡಾತ್ ತುಮ್ಚಾ ಮನಾತ್ ಹಾತಾ” ಹೀಸ್ ಇಸ್ವಾಸಾಚಿ ವಚ಼ನ ಪರಚಾರ್ ಕರ್ತಾವ್. ");
INSERT INTO gok_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","ಫನ್ ಯೇಸುಸ್ ಪ್ರಭು ಮನ್ಹುನ್ ತುಜಾ ತೊಂಡಾನಿ ಸಾಂಗ್ಲತ ಆನಿ ದೇವಾನಿ ಕುನಾಲಾ ಮರ್ನಾತ್ನಿ ಉಠಿವಲ್ಯಾ ತ್ಯಚಿವ ತುಮಿ ಇಸ್ವಾಸ್ ಥೆವ್ಲಾಸಾತ ತುಮಿ ರಕ್ಶನ್ ಗೆನ್ಹಾರ್. ");
INSERT INTO gok_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","ಕಾ ಮಂಜೆ ವ್ಹಯ್ ಆಮಿ ಆಮ್ಚಾ ಮನಾತ್ ಇಸ್ವಾಸ್ ಥೆವ್‌ಲ್ಯಾಲ್ಯಾಸ್ ಲಾಗುನ್ ನೀಯತಿಚಿ ವ್ಹನಾರ್ ಇಸ್ವಾಸ್ ಥೆವ್ತಾವ್ ಮನ್ಹುನ್ ತೊಂಡಾನಿ ಸಾಂಗ್‌ತ್ಯಾಲ್ಯಾನಿ ರಕ್ಶನ್ ಗೆಥಾವ್. ");
INSERT INTO gok_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","ಪವಿತ್ರ ಪುತೀಕ್ ಆಸ ಸಾಂಗ್ತ. “ಕೋನ್ ತ್ಯಚಿವ ಇಸ್ವಾಸ್ ಥೆವ್ತೊ ತ್ಯೊ ಫಸತ್ ನಾಹಿ” ");
INSERT INTO gok_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","ಕಾ ಮಂಜೆ ಯೆಹುದ್ಯಾನಾ ಯೆಹುದಿ ನಸ್‌ಲ್ಯಾಲ್ಯಾನಾ ಕಾಯ್ ಫರಕ್ ನಾಹಿ. ಸಗ್‌ಳ್ಯಾನಾ ಯೋಕುಸ್ ಪ್ರಭು ದೇವ್. ಕೋನ್ ಹಾಳಿ ಮ್ಯಾರ್ತೊ ತ್ಯಲಾ ತ್ಯೊ ಖುಬ್ ಆಶಿರ್ವಾದ್ ದೇತೊ. ");
INSERT INTO gok_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","ಪವಿತ್ರ ಪುತೀಕ್ ಸಾಂಗ್‌ತ್ಯಾಚೆಗತ್ ಕೋನ್ ಪ್ರಭುಚಾ ನಾವಾನಿ ಹಾಕಟೊ ತ್ಯಲಾ ರಕ್ಶನ್ ವ್ಹನಾರ್. ");
INSERT INTO gok_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","ಫನ್ ಕೋನ್ ತ್ಯಚಿವ ಇಸ್ವಾಸ್ ಥಿವಿತ್ ನಾಹಿ ತ್ಯಲಾ ಕಸಿ ಹಾಳಿ ಮ್ಯಾರ್ನಾರ್? ಕಚಾನಿ ಪ್ರಭುಚ಼ ವಚ಼ನ್ ಐಕ್ಲ ನಾಹಿ ತ ತೀ ತ್ಯಚಿಪ ಇಸ್ವಾಸ್ ಕಸಾ ಥೆವ್ನಾರ್? ಆನಿ ಯಕಾನಿ ಸಾಂಗಾಚೆ ಆಂದಿ ಪ್ರಭುಚೆ ಗುಶ್ಟಿತ್ ಐಕಾಚ಼ ತರಿ ಕಸ? ");
INSERT INTO gok_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","ಪ್ರಚಾರ್ ಕರಾಯಾ ಕುನಾಲಾ ಲಾವುನ್ ದಿಲಾ ನಾಹಿ ಮಂಜೆ ತ್ಯೊ ಪ್ರಚಾರ್ ಕರ್ನಾರ್ ಕಸಾ? ಮನ್ಹುನ್ ಪವಿತ್ರ ಪುತಿಕಾತ್ ಸಾಂಗ್‍ತ್ಯಾ ಶಾರ್ಕ ಚಾಂಗ್ಲಿ ಖಬರ್ ಸಾಂಗ್‍ತ್ಯಾಂಲ್ಯಾಂಚಿ ಪಾವ್ಲ ಕ್ಯವ್ಡಿ ಶಾದ್ರಿ ಹಾತ್ತ! ");
INSERT INTO gok_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","ಫನ್ ಸಗ್‍ಳ್ಯಾಂಚಾನಿ ಬರಿ ಖಬರ್ ಗೀತ್ಲಿ ನಾಹಿ. ಯೇಶಾಯ್ ಸಾಂಗ್ತೊ, “ಪ್ರಭು ಆಮ್ಚಿ ವಚ಼ನ ಕುನಿ ಐಕ್ಲಿತ ಇಸ್ವಾಸ್ ಥೆವ್ಲಾ? ");
INSERT INTO gok_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","ಆಸ ಆಸ್ಥಾನಾ ವಚ಼ನ ಐಕ್‌ನ್ಯಾನಿ ಇಸ್ವಾಸ್ ಯತೊ. ವಚ಼ನ್ ಐಕ್‍ತಾನಾ ಇಸ್ವಾಸ್ ಯತೊ ಆನಿ ಕ್ರಿಸ್ತಾಚಾ ವಾಕ್ಯಾ ಐಕ್ತಾನಾ ಬಾತ್ನಿ ಯತಿ. ");
INSERT INTO gok_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","ಫನ್ ಲೋಕಾಂಚಾನಿ ಬರಿ ಖಬರ್ ಐಕ್ಲಿ ನಾಹಿಕ್ಯಾ? ಮನ್ಹುನ್ ಮೀ ಪ್ರಶ್ನೆ ಕರ್ತೊ. ವ್ಹಯ್ ತೆಂಚಾನಿ ಐಕ್ಲ ಪವಿತ್ರ ಪುತೀಕ್ ಸಾಂಗ್ತ. ತ್ಯಂಚ಼ ನಾದ್ ದುನೆತ್ ಸಗ್ಳ ಪಗಾಳ. ತ್ಯಂಚಾ ಬೊಲ್ಯಾ ಪರಪಂಚಾತ್ ಸಗ್ಳಿಕ್ಡ ಗೇಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","ಪರ್ತುನ್ ಮೀ ಐಕ್‍ತ್ಯೊ ಕ್ಯಾ ಇಸ್ರಾಯಲ್ ಲೋಕಾನಾ ಸಮಜ಼ತ್ ನವ್ತ ಕ್ಯಾ? ಮೊಶೆ ಸ್ವತಾ ಆಪ್ನು ಸಾಂಗ್ತೊ ಮೀ ತುಮ್ಚಾ ಮನಾತ್ ಆಸ್‍ಲ್ಯಾ ಲೋಕಾಂಚಿಸ್ ಲಾಗುನ್ ಖರಿ ನವ್ಹ ಜಾ಼ಲ್ಯಾಲ್ಯಾಂಚಿಪ್ನಿ ತುಮ್ಚಾ ಮನಾತ್ ಖೊಟ ಫನ್ ಯಯಿಜೊ಼ಗ ಕರೀನ್ ಆನಿ ಮೂರ್ಕ ರಾಶ್ಟ್ರಾಂಚಿಪ್ನಿ ತುಮಾನಾ ರಾಗ್ ಯಯಿ ಶಾರ್ಕಾ ಕರ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","ನಂತರ್ ಯೆಶಾಯ್ ಧಿರ‍್ಹಾನಿ ಸಾಂಗ್ತೊ. ಮನಾ ಸೊದಾಚೆ ಆಂದಿ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ಲೋಕಾಂಚಾನಿ ಬಗ್ಲಾ. ಮಾಜಿಸಾಟಿ ಮಾಗಿತ್ ನಸ್‌ಲ್ಯಾಲ್ಯಾ ಲೋಕಾನಾ ಮೀ ದಿಸ್ಲೊ. ");
INSERT INTO gok_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","ಫನ್ ಇಸ್ರಾಯೆಲಾಂಚೆ ಗುಶ್ಟಿತ್ ತ್ಯೊ ಆಸಾ ಸಾಂಗ್ತೊ. “ಮೀ ಸಗ್‍ಳ್ಯಾ ದಿಸಾತ್ ಆಜ್ಞಾ ಪಾಳಿತ್ ನಸ್‍ಲ್ಯಾಲ್ಯಾನಾ ಆನಿ ವಾದಿಂಚೆ ಮೊರ‍್ಹ ಹಾತ್ ಪಗಳುನ್ ರಾಯ್ಲೊ. ” ");
INSERT INTO gok_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","ತಸ ಜಾ಼ಲ್ಯಾವ, “ದೇವಾನಿ ಆಪ್‌ಲ್ಯಾ ಲೋಕಾಂಚಿ ನಕ್ವಾಟ್ ಕಿಲಿ ಕ್ಯಾ? ಮನ್ಹುನ್ ಮೀ ಇಚಾರ್ತೊ. ನಾಹಿ ಖರ‍್ಯಾನಿಸ್ ನಾಹಿ! ಮೀ ಯೋಕ್ ಇಸ್ರಾಲ್ ಜಾ಼ಲ್ಯೊ. ಮೀ ಅಬ್ರಹಾಮಾಚಾ ಕುಟ್ಮಾತ್ಲಾ: ಬೆನ್ಯಾಮಿನಾಚಾ ಕುಳಾತ್ಲಾ ಜಾ಼ಲ್ಯೊ. ");
INSERT INTO gok_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","ಇಸ್ರಾಲ್ ಜ಼ಲ್ಮಾಚೆ ಆಂದಿ ದೇವಾನಿ ತ್ಯನಾ ಆಪ್ಲಿ ಲೊಕ ಮನ್ಹುನ್ ನಿವ್ಡುನ್ ಗಿತ್ಲಿತ. ತ್ಯನಿ ತ್ಯನಾ ಬಾಹಿರ್ ಢಕಲ್ಲಿ ನಾಹಿತ. ಎಲಿಯಾಚೆ ಗುಶ್ಟಿತ್ ಪವಿತ್ರ ಪುತಿಕ್ ಕ್ಯಾ ಸಾಂಗ್ತ ಮನ್ಹುನ್ ತುಮಾನಾ ಖರ‍್ಯಾನಿಸ್ ಠಾವ ಹಾ: ಇಸ್ರಾಲೆಚಾ ಲೊಕಾಂಚೆ ಆಡ್ವ ಎಲಿಯಾನಿ ದೇವಾಲಾ ಕೇಲ್ಯಾಲ್ಯಾ ಮಾಗ್‌ನ್ಯಾಚೆ ಗುಶ್ಟಿತ್ ತ್ಯಾತ್ ಲಿವ್‌ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","“ಪ್ರಭು, ಲೋಕಾಂಚಾನಿ ತುಜಾ ಪ್ರವಾದಿನಾ ಮಾರುನ್ ಟ್ಯಾಕ್ಲ. ತುಜಾ಼ ಬಲಿ ದಿಯಾಚ಼ ಜಾ಼ಗ ನಾಸ್ ಕೆಲಾ. ಪ್ರವಾದಿತ್ ಮೀಯಕ್ಲಾಸ್ ಆಜು಼ನ್ ಜ಼ಗಲ್ಯೊ. ಆತಾ ಲೊಕ ಮನಾ ಮಾರುನ್ ಟಾಕಾಯಾ ಯತ್ನ ಕರ್ತ್ಯಾತ” ");
INSERT INTO gok_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","ಫನ್ ದೇವಾನಿ ಎಲಿಯಾಲಾ ದಿಲ್ಯಾಲಾ ಉತ್ತರ್ ಕ್ಯಾ? “ಬಾಳ್ ಮಂಥ್ಯಾಲ್ಯಾ ಲಬಾಡ್ ದೇವಾಲಾ ಆರಾದಾನ್ ಕರಾಚೆ ಆಂದಿ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ಸಾತ್ ಹಾಜಾ಼ರ್ ಲೊಕಾನಾ ಮಿ ಮಾಜಿಸಾಟಿ ಥೆವ್‌ಲ್ಯಾತ. ” ಮನ್ಹುನ್ ಉತ್ತರ್ ದಿಲಾ. ");
INSERT INTO gok_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","ತಸಸ್ ಆತಾಬಿ. ದೇವ್ ಆಪ್ಲೆ ಕ್ರಪಾನಿ ನಿವಡ್‌ಲ್ಯಾಲಿ ಥುಡಿಸ್ ಲೊಕ ಹಾತ್ತ. ");
INSERT INTO gok_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","ದೇವಾಚೆ ಕ್ರಪೆನಿ ನಿವಡ್‍ಲ್ಯಾಲಿ ತೀ ದೇವಾಚಿ ಲೊಕ ಜಾ಼ಲ್ಯಾಲಿ ಆಪ್‍ಲ್ಯಾ ಕಾಮಾನಿ ನವ್ಹ. ಕಾ ಮಂಜೆ ದೇವಾಚೆ ಕ್ರಪೆನಿ. ತೇ ತ್ಯಂಚಾ ಕಾಮಾನಿಸ್ ಜಾ಼ಲ್ಯಾಲ ಅಸ್ಥತ ಹೀ ತ್ಯಚಿ ಕ್ರಪಾ ಖರಿ ಜಾ಼ಲ್ಹಿ ನಸ್ಥಿ. ");
INSERT INTO gok_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","ಮನ್ಹುನ್ ಚಾ಼ಲ್ಯಾಲಿ ಖನ್ಕತ್ ಯವ್ಡಿಸ್: ಇಸ್ರಾಯಲಾಚಾ ಲೋಕಾಂಚಾನಿ ನಿಯತಿಚಿ ವ್ಹಯಾ ಯತ್ನ ಕಿಲಿತ. ಫನ್ ತ್ಯಂಚಿಪ್ನಿ ಜಾ಼ಲ್ಹ ನಾಹಿ ಆಸ ಆಸ್ಥಾನಾ ದೇವಾಪ್ನಿ ನಿವಡ್‍ಲ್ಯಾಲಿ ಥುಡಿ ಲೋಕ ನೀಯತಿಚಿ ಜಾ಼ಲ್ಹಿತ. ಫನ್ ಉರ್ಲ್ಯಾಲಿ ಲೋಕ ಕಠಿನ್ ವ್ಹವುನ್ ದೇವಾಚ಼ ಸಾಂಗ್ನ ಐಕ್ಲ ನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","ಪವಿತ್ರ ಪುತೀಕ್ ಆಸ ಸಾಂಗ್ತ. “ಲೊಕಾನಾ ಸಮಜು಼ನಾಹಿ ಆಸ ದೇವಾನಿ ತ್ಯನಾ ಮಂದ್ ಕಿಲಿತ. ” ತೇ ಆಜು಼ನ್ ಪರತ್ ಡೊಳ ಆಸ್ಲ ತರಿ ದಿಸತ್ ನಸ್‌ಲ್ಯಾಚೆಗತ್. ಕಾನ್ ಆಸ್ಲ ತರಿ ಐಕು ಯಯಿನಾಹಿಜೊ಼ಗ ಕೆಲ. ");
INSERT INTO gok_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","ಆನಿ ದಾವಿದ್ ಆಸಾ ಮಂಥೊ: “ತ್ಯಂಚ಼ ಜೇವಾನುಸ್ ತ್ಯನಾ ಫಾಸಿ ಆನಿ ಬಲಿ ಜಾ಼ಲಿತ ತ್ಯನಾ ಪ್ಯಾಡ್ಲಿತ ಆನಿ ಶಿಕ್ಷೆತ್ ಗಾವ್ಲಿತ!. ");
INSERT INTO gok_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","ತ್ಯಂಚ಼ ಡೊಳ ಆಂದ್ಳ ವ್ಹವುಂತ ಕಾ ಮಂಜೆ ತ್ಯನಾ ದಿಸು ನಾಹಿ. ಖಾಯಿಮ್ಚಾ ವಜ್ಜಾನಿ ಪಾಠಿಲಾ ಡೂಗ್ ಯವುನಿ. ” ");
INSERT INTO gok_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","ಆಸ್ ಆಸ್ಥಾನಾ ಮೀ ಇಚಾರ್ತೊ ತೇ ಪಡುನ್ ನಾಸ್ ವ್ಹಯಾ ಗಸಾರ್ಲ ಕ್ಯಾ? ಖರ‍್ಯಾನಿಸ್ ನವ್ಹ ಕಾ ಮಂಜೆ ತ್ಯಂಚಾನಿ ಪಾಪ್ ಕೇಲ್ಯಾ ಮನ್ಹುನ್ ಯೆಹುದಿ ನಸ್‍ಲ್ಯಾಲ್ಯಾನಾ ರಕ್ಷನ್ ಗಾವ್ಲಿ ಕಾ ಮಂಜೆ ತ್ಯಂಚಿವ ಯೆಹುದ್ಯಾಂಚ಼ ಖೊಟಫನ್ ಕರಾಯಾ ವ್ಹಯಿ. ");
INSERT INTO gok_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","ಯೆಹುದ್ಯಾಂಚಾ ಪಾಪಾನಿ ದುನೆಲಾ ಖುಬ್ ಆಶಿರ್ವಾದ್ ತ್ಯಂಚ಼ ಪಡ್ನ ಯೆಹುದಿ ನಸ್‌ಲ್ಯಾಲ್ಯಾ ಲೋಕಾನಾ ಖುಬ್ ಆಶಿರ್ವಾದ್ ಆನಾಯಾ ಕಾರನ್ ಜಾ಼ಲ್ಹಾತ. ಆನಿ ತ್ಯಂಚಾ ಆತ್ಮಿಕ್ ಗರಿಬ್ ತಿಥಿನಿ ಯೆಹುದಿ ನಸ್‍ಲ್ಯಾಲ್ಯಾನಾ ಮೋಟಾ ಆಶಿರ್ವಾದ್ ಗಾವ್ಲಾ ಯಕ ವೇಳಿ ಸಗ್ಳ ಯೆಹುದಿ ಹಿತ್ತ ಯವುನ್ ಮಿಳಾಲತ ಆಸ್ಲಾ ಆಶಿರ್ವಾದ್ ಕ್ಯವ್ಡಾ ಮೊಟಾ ಆಸಲ್! ");
INSERT INTO gok_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","ಆತಾ ಮೀ ಯೆಹುದಿ ನಸ್‌ಲ್ಯಾಲ್ಯಾ ಲೋಕಾಂಚೆ ಗುಶ್ಟಿತ್ ಬೊಲ್‍ತ್ಯೊ. ಮೀ ತ್ಯನಾ ಅಪೋಸ್ತಲ್ ವ್ಹವುನ್ ರಾಹಿ ಪರತ್. ಮಿ ಕರ್ತ್ಯಾಲ್ಯಾ ಕಾಮಾಲಾ ವವ್ಯಾಳುನ್ ಗೆಥೊ. ");
INSERT INTO gok_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","ಮಿ ಮಾಜಿ ಸ್ವತಾಚಿ ಲೊಕ್ ಖೊಟಫನ್ ಕರ್ತ್ಯಾಲ್ಯಾ ಥೊಡ್ಯಾಂಚಾನಿ ತರಿ ರಕ್ಶನ್ ಗಿಹಿಜೊ಼ಗ ಕರಿನ್ ಮನ್ಯಾಚಿ ಆಶಾ ಮಾನಾ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","ಕಾ ಮಂಜೆ ಯೆಹುದಿ ಲೊಕಾಂಚಾನಿ ನಕ್ವಾಟ್ ಕಿಲಿ ಮನ್ಹುನ್ ಜಗತ್ ದೇವಾ ಸಂಗ ಯೇಕ್ ಜಾ಼ಲಿ ಫನ್ ತ್ಯಂಚಾನಿ ಗೆತಲ್ಯಾವ ಕ್ಯಾ ಘಡ್ನಾರ್? ಮೇಲ್ಯಾಲ್ಯಾನಾ ಜೀವ್ ಗಾವತಾ ನವ್ಹ! ");
INSERT INTO gok_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","ಬಾಕ್ರಿಚಾ಼ ಪೈಲಾ ತುಕ್ಡಾ ದೇವಾಲಾ ದಿಲಾತ. ಸಗ್ಳಿ ಬಾಕ್ರಿ ಪವಿತ್ರ ಜಾ಼ಲ್ಹಿ. ಮುಳ ದೇವಾಲಾ ದಿಲತ ಖಾಂಡ್ಯಾಬಿ ತ್ಯಚಾಸ್ ಜಾ಼ಲ್ಯಾ. ");
INSERT INTO gok_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","ಫನ್ ಥೊಡ್ಯಾ ಖಾಂಡ್ಯಾ ಮುಡುನ್, ಆಲಿವ್ ಜಾ಼ಡಾಚಿ ಖಾಂಡಿ ಯೇಕ್ ಆಂದಿಚಾ ಆಲಿವ್ ಜಾ಼ಡಾಲಾ ಲಾಗಲ್ಯಾಚೆಗತ್ ಹಾ. ಯೆಹುದಿ ನಸ್‌ಲ್ಯಾಲಿ ತುಮಿ ಖಾಂಡ್ಯಾಚೆಗತ್ ಹಾಸಾ. ಆನಿ ಆತಾ ತುಮಿ ಯೆಹುದ್ಯಾಂಚಾ ಬಳಾಚಾ ಆತ್ಮಿಕ್ ಜೀವ್ನಾಚೆ ತರನಿ ತುಮಿ ವಾಟದಾರ್ ಜಾ಼ಲ್ಯಾಸಾ. ");
INSERT INTO gok_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","ಮನ್ಹುನ್ ಮೊಡ್‍ಲ್ಯಾಲ್ಯಾ ತ್ಯಾ ಖಾಂಡಿಚಾ಼ ಗಾಳ್ ಕರುನೋಸಾ. ತ್ಯಂಚಾ಼ ಗಾಳ್ ಕರಾಯಾ ತುಮಾನಾ ಕಚ಼ಸ್ ಕಾರನ್ ನಾಹಿ ಕಾ ಮಂಜೆ ತುಮಿ ಮೂಳಾಲಾ ಆದಾರ್ ದಿಯಿತ್ ನಾಹಿಸಾ ಮುಳ್ ತುಮಾನಾ ಆದಾರ್ ದೇತ. ");
INSERT INTO gok_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","ಫನ್ ತುಮಿ ಆಸ ಸಾಂಗು ಸಕ್ತ. “ಆಮಿ ತ್ಯಾ ಜಾ಼ಢಾಚೆ ಖಾಂಡಿನಾ ಮಿಳಾಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ತ್ಯಾ ಖಾಂಡ್ಯಾ ಮೊಡ್‌ಲ್ಯಾ” ");
INSERT INTO gok_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","ತ್ಯ ಖರ. ತ್ಯನಾ ಇಸ್ವಾಸ್ ನವ್ಥಾ ಮನ್ಹುನ್ ತ್ಯನಾ ತ್ಯೊಡ್‍ಲ್ಯಾ ತುಮಾನಾ ತ್ಯಾತ್ ಮೀಳಿವ್ಲಿ ಹುತ್ತಿತ ತುಮಾನಾ ತ್ಯಾತ್ ಇಸ್ವಾಸ್ ಹುತ್ತಾ ಮನ್ಹುನ್ ತುಮಿ ಹ್ಯಾತ್ ದಿಮಾಕ್ ಕರು ನಕೋಸಾ ಭೆ ರಾಹುನಿ. ");
INSERT INTO gok_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","ಸ್ವಭಾವಿಕ್ ಖಾಂಡ್ಯಾಚೆಗತ್ ಅಸ್‍ಲ್ಯಾಲ್ಯಾ ಯೆಹುದಿನಾಸ್ ದೇವಾನಿ ಶುಡ್ಲಿ ನಾಹಿತ. ತುಮಾನಾ ಸುಡಿಲ್ ಮನ್ಹುನ್ ಸಮಾಜ಼ಲಾಸಾ ಕ್ಯಾ? ");
INSERT INTO gok_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","ಮನ್ಹುನ್ ದೇವ್ ದಯಾ ಆಸ್‌ಲ್ಯಾಲಾ ಜಾ಼ಲ್ಯಾ ಆನಿ ಖುಬ್ ಕಠಿನ್ ಜಾ಼ಲ್ಯಾ ಮನ್ಹುನ್ ಸಮಜಾ಼. ದೇವ್ ಆಪ್ಲೆ ಮಾಗ್ನಿ ಯಯಿತ್ ನಸ್‌ಲ್ಯಾಲ್ಯಾ ಲೋಕಾನಾ ಶಿಕ್ಶಾದೇತೊ. ಫನ್ ತು ದೇವಾಚೆ ದಯೆಚಾ಼ ಆದಾರ್ ಕೇಲಾಸ್ತ. ದೇವ್ ತುಲಾ ದಯಾ ಆಸ್‌ಲ್ಯಾಲಾ ಜಾ಼ಲ್ಯಾ. ನಾಹಿತ, ತುಲಾ ತುಡುನ್ ಟ್ಯಾಕ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","ಇಸ್ರಾಯೆಲಾಂಚಿ ಸಂಗ ಆಜು಼ನ್ ಬೆಇಸ್ವಾಸಾನಿ ಥಾಂಬ ನಸ್ತಾನಾ ತ್ಯನಾ ಕಸಿ ಕರ್ನಾರ್. ದೆವಾಲಾ ತ್ಯನಾ ಆನಿಕ್ ಕಸಿ ಕರಾಯಾ ಶಕ್ಯಾ ಹಾ. ");
INSERT INTO gok_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","ರಾನಾಚಿ ಢ್ಯಾಳ್ ಯೇಕ್ ಚಾಂಗಲ್ಯಾ ಝಾ಼ಡಾಚಿ ಢ್ಯಾಳ್ ವ್ಹಯಾಚಿ ಸೊಪ ನವ್ಹ. ಫನ್ ಯೆಹುದಿ ನಸ್‌ಲ್ಯಾಲಿ ತುಮಿ ರಾನ್ ಆಲಿವ್ ಜಾ಼ಡ್ಹಾತ್ನಿ ತ್ಯೊಡ್‍ಲ್ಯಾಲಿ ಢಾಳಿ ವ್ಹವುನ್ ಫನ್ ತ್ಯ ಪ್ರಖರತಿಲಾ ಆಡ್ವಿ ಜಾ಼ಲ್ಯಾಲಿ ಚಾ಼ಂಗ್ಲ ಆಲಿವ್ ಜಾ಼ಢಾಲಾ ಮಿಳಿವ್‍ಲ್ಯಾಚೆಗತ್ ಹಾಸಾ. ಫನ್ ಯೆಹುದಿ ತ್ಯಾಸ್ ಜಾ಼ಢಾಚಿ ತ್ಯೊಡ್‍ಲ್ಯಾಲಿ ಢಾಳ್ಹಿ ಜಾ಼ಲ್ಯಾತ ಆಸ ಆಸ್ಥಾನಾ ದೇವಾಲಾ ಕ್ಯವ್ಡ ಸಲ್ಪ ಆಸಲ್ ತ್ಯೊಡ್‍ಲ್ಯಾಲ್ಯಾ ತ್ಯಾಸ್ ಜಾ಼ಡಾಲಾ ಮಿಳ್ವಾಯಾ ಕ್ಯವ್ಡ ಸಲ್ಪ. ");
INSERT INTO gok_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","ಮಾಜಾ ಭನ್ಹಿ ಭಾವ್ಹಾನು ಮೀ ತುಮಾನಾ ದಡುನ್ ರಾಯಲ್ಯಾಲ ಖರ ತ್ಯ ಮೀ ಆಡಶಾ ಕರೀತ್ ನಾಹಿ ತುಮಿ ತುಮಾನಾಸ್ ಶಾನ ಮನ್ಹುನ್ ಗಿಹುನಕೋಸಾ ಹ್ಯ ಖರ ತುಮಾನಾ ಸಮಜು಼ನಾಹಿ ಆಸ ವ್ಹಯಿತ್ ನಾಹಿ ಆಸಸ್ ಇಸ್ರಾಯೆಲಾಚಿ ಥುಡಿ ಲೋಕ ಕಾರನ್ ಜಾ಼ಲ್ಯಾತ ಆನಿ ಆಸಿ ರಾಥ್ಯಾಲಿ ಕ್ಯವಡ್ಯಾ ಪರೆತ್ ಮನ್‍ಲ್ಯಾವ ಸಗ್ಳಿ ಯೆಹುದಿ ನಸ್‍ಲ್ಯಾಲಿ ಲೋಕ ದೇವಾಚೆ ಸಂಗ ಕ್ಯವಡ್ಯಾಪರೆತ್ ಮನ್‍ಲ್ಯಾವ ಯೆಹುದಿ ದೇವಾಪ ಯಯಿಪರೆತ್. ");
INSERT INTO gok_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","ಆನಿ ಆಸಸ್ ಸಗ್‍ಳ್ಯಾ ಇಸ್ರೆಲ್ ಲೋಕಾಂಚ಼ ರಕ್ಶನ್ ವ್ಹನ್ಹಾರ್. ಪವಿತ್ರ ಪುತೀಕ್ ಆಸ ಲಿವ್‍ಲ್ಯಾ. “ಸಿಯೋನಾತ್ನಿ ರ‍್ಯಾಕ್ನಾರಾ ಯನಾರ್. ತ್ಯೊ ಯಾಕೊಬಾಚಾ ಕುಟ್ಮಾತ್ಲ ಸಗ್ಳ ಬುರ್ಸ ಕಾಡುನ್ ಟ್ಯಾಕ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","ಮೀ ತ್ಯಾ ಲೋಕಾಂಚ಼ ಪಾಪ್ ಪರಿಹಾರ್ ಕರ್ತಾನಾ. ತ್ಯಂಚಿ ಸಂಗ ಹ್ಯೊ ಕರಾರ್ ಕರ್ನಾರ್. ” ");
INSERT INTO gok_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","ಯೆಹುದ್ಯಾಂಚಾನಿ ಬರಿ ಖಬರ್ ಗೀತ್ಲಿ ನಾಹಿ. ಮನ್ಹುನ್ ತೇ ದೇವಾಚ಼ ವಾದಿ ಜಾ಼ಲ್ಯಾತ. ಯೆಹುದಿ ನಸ್‌ಲ್ಯಾಲ್ಯಾ ಲೋಕಾನಾ ಮಜ಼ತ್ ವ್ಹಯಾ ವ್ಹಯಿ ಮನ್ಹುನ್ ಹ್ಯ ಜಾ಼ಲ್ಹ. ಫನ್ ಆಜು಼ನ್ ದೇವಾಪ್ನಿ ನಿವಡ್‍ಲ್ಯಾಲಿ ಲೋಕ ಜಾ಼ಲ್ಯಾತ. ಮನ್ಹುನ್ ತ್ಯೊ ವಡ್ಲಾಂಚೆ ಸಂಗ ಆಪ್ನು ಕೇಲ್ಯಾಲ್ಯಾ ಕರಾರಾಸ್ಲಾಗುನ್ ತ್ಯಂಚಿ ಮಾಯಾ ಕರ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","ತ್ಯೊ, ದೇವಾನಿ ಕುನಾಲಾ ನಿವಡ್‍ಲ್ಯಾತ ತ್ಯಂಚೆ ಗುಶ್ಟಿತ್ ತ್ಯನಾ ಆಸ್‍ಲ್ಯಾಲಾ ಆಶಿರ್ವಾದ್‍ ಬದಲಿತನಾಹಿ. ");
INSERT INTO gok_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","ಯಕಾ ಕಾಲಾತ್ ಯಹುದಿ ನಸ್‍ಲ್ಯಾಲಿ ತುಮಿ ತ್ಯಚಾ ಆಜ್ಞಾ ಪಾಳಿತ್ ನವ್ಥಾಸಾ. ಫನ್ ಆತಾ ತ್ಯಂಚಾನಿ ಆಜ್ಞಾ ಪ್ಯಾಳ್ಯಾ ನಾಹಿತಾ ಮನ್ಹುನ್ ತುಮಾನಾ ದೇವಾಚಿ ದಯಾ ಗಾವ್ಲೆ. ");
INSERT INTO gok_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","ದೇವಾನಿ ತುಮಾನಾ ದಯಾ ದ್ಯಾವ್ಲಿ ಮನ್ಹುನ್ ಆತಾ ಯೆಹುದಿ ಆಜ್ಞಾ ಶಾರ್ಕ ಚಾ಼ಲ್ಲ ನಾಹಿತ. ಫನ್ ತ್ಯಂಚಾನಿ ಸಾಹಿತ್ ದೇವಾಪ್ನಿ ಕರುನೆ ಗಿತ್ಲಿ ಮನ್ಹುನ್ ಆಸ ಜಾ಼ಲ್ಹ. ");
INSERT INTO gok_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","ಸಗ್ಳಿ ದೇವಾಲಾ ಅವಿದೆಯ್ ಜಾ಼ಲಿತ. ದೇವಾನಿ ಸಗ್‍ಳ್ಯಾನಾ ದಯಾ ದಾವಾಯಾ ಸಗ್‌ಳ್ಯಾನಾ ಯಂಗ್ದಾಸ್ ಸಾಂಗ್‍ಲ್ಯಾ ಶಾರ್ಕ ಚಾ಼ಲ್ಲ ನಾಹಿ ಮನ್ಹುನ್ ಕ್ಯೊಂಡ್ಲಿತ. ");
INSERT INTO gok_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","ವ್ಹಯ್ ದೇವಾಚಿ ದವ್ಲತ್ ಖುಬ್ ಹಾ! ದೇವಾಚ಼ ಗಿನ್ಯಾನಾಲಾ ಆನಿ ಬುದ್ದಿಲಾ ಸರ್ತಸ್ ನಾಹಿ! ತ್ಯಚಾ಼ ನಿರ್ದಾರ್ ಫುಡುನ್ ಸಾಂಗ್ನಾರಾ ಕೋನ್ ಹಾ? ತ್ಯಚಾ಼ ಮಾರ್ಗ ಕುನಾಲಾ ಸಮಾಜ್ನಾರ್. ");
INSERT INTO gok_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","ಪವಿತ್ರ ಪುತೀಕ್ ಸಾಂಗ್‌ತ್ಯಾ ಶಾರ್ಕ. “ಪ್ರಭುಚ಼ ಮನ್ ಸಮಜು಼ನ್ ಗೇತ್ಯಾಲಾ ಕೊನ್? ದೇವಾಲಾ ಸಲಹಾ ಕೊನ್ ಸಾಂಗ್ನಾರ್? ");
INSERT INTO gok_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","ತ್ಯಲಾ ಕುನಿ ಕ್ಯಾ ದಿಲ್ಯಾ? ತ್ಯ ತ್ಯೊ ತ್ಯಲಾ ಮಾಗರ ದಿಯಿಲ್. ” ");
INSERT INTO gok_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","ವ್ಹಯ್ ತ್ಯನಿಸ್ ಸಗ್ಳ ಉತ್ಪನ್ ಕೇಲ. ಸಗ್ಳ ತ್ಯಚಿಸ್ ಲಾಗುನ್ ತ್ಯಚಿಸಾಟಿಸ್ ಹಾ. ದೇವಾಲಾ ಖಾಯಿಮ್ಚಾ ಕಾಲಾತ್ ಮೈಮಾ ವ್ಹವುನಿ! ಆಮೆನ್. ");
INSERT INTO gok_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","ಮನ್ಹುನ್ ಬನ್ಹಿ ಬಾವ್ಹಾನಾ, ದೇವಾಚಿ ಕನಿಕರಾ ಯಾದ್ ಕರಿತ್ ತುಮಚಿಪ ಮೀ ಇನಂತಿ ಕರ್ತೊ, ತುಮಿ ತುಮಚಿ ತುಮಚಿ ಶರಿರ ದೇವಾಸಾಟಿ ಥೆವಲ್ಯಾಲಿ, ಆವಾಡಲ್ಯಾಲಿ ಜೀತ್ತಿ ಜ಼ನಾವಾರ ಮಾರಾ. ಹ್ಯಸ್ ಖರ ಆರಾಧನ್ ದೇವಾಲಾ ದಿಯಾ ವ್ಹಯಿಸಾ. ");
INSERT INTO gok_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","ಹೇ ದುನೆಚಾ ಚಾ಼ಲನ್ಯಾಚೆಗತ್ ಚಾ಼ಲಾಚೆ ಆಂದಿ ತುಮ್ಚಿ ಮನ ಬದಲುನ್ ಮನ ನವಿನಿ ಜಾ಼ಲ್ಯಾಚೆಗತ್ ತುಮಿ ರಾವ್ಹಾ. ತವಾ ತುಮಿ ದೇವಾಚಾ ಮನಾಶಾರ್ಕ ಕಚ಼ ಚಾಂಗ್ಲ, ಕಚ಼ ಆವಾಡಲ್ಯಾಲ ಆನಿ ಕಚ಼ ಪರಿ ಪೂರ್ನ ಜಾ಼ಲ್ಯಾಲ ಮನ್ಹುನ್ ಸಮಜು಼ನ್ ಗೇನ್ಹಾರ್. ");
INSERT INTO gok_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","ದೇವಾನಿ ಮನಾ ವಿಶೇಶಾಚಾ಼ ಯೋಕ್ ವರ್ ದಿಲ್ತಾ. ಮನ್ಹುನ್, ತುಮ್ಚಿಪಲ್ಯಾ ಪರತೇಕಾಲಾ ಹ್ಯಾ ಖನ್ಕತಿ ಸಾಂಗ್ತೊ. ತುಮಿ ತುಮ್ಚಾ ಖರ‍್ಯಾ ಯೊಗೆತ್ಯಾವ್ನಿ ಖುಬ್ ತುಮ್ಚೆ ಗುಶ್ಟಿತ್ ಯವಜು಼ನಕೊಸಾ. ಹ್ಯಚೆ ಬದ್ಲಿ ತುಮಿ ತುಮ್ಚೆ ಗುಶ್ಟಿತ್ ಕ್ಯಾ ಯವಜ಼್ಲ ತರಿ ತ್ಯ ಯವಜ಼್ನ ತುಮ್ಚಾ ಖರ‍್ಯಾ ಯೊಗೆತೆಲಾ ಶಾರ್ಕ ರಾಹ್ಯಾ ವ್ಹಯಿ. ದೇವಾನಿ ತುಮಾನಾ ಕ್ಯವ್ಡಾ ಇಸ್ವಾಸ್ ದಿಲ್ಯಾ ತ್ಯಾ ಇಸ್ವಾಸಾಚಾ ಮಾಪಾ ಯಿತ್ಕ ತುಮಾನಾ ತುಮಿಸ್ ಯವಜಾ಼. ");
INSERT INTO gok_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","ಪರತೇಕಾಲಾ ಯಾಕ್ ಶರೀರ್ ಹಾ. ತ್ಯಾ ಶರೀರಾಲಾ ಖುಬ್ ಆಂಗ ಹಾತ್ತ. ತೀ ಆಂಗ ಯಾಕುಸ್ ಕಾಮ ಕರೀತ್ನಾಹಿತ. ");
INSERT INTO gok_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","ತಸಸ್ ಕ್ರಿಸ್ತಾಪ ಆಮಿ ಸಗ್ಳ ಯಾಕುಸ್ ಆಂಗ್ ಜಾ಼ಲ್ಯಾವ್. ಆನಿ ಆಮಿ ಯಕಾ ಶಿರಾಚಾ ದುಸ್‍ರ್ಯಾ ದುಸ್‍ರ‍್ಯಾ ಬಾಗಾಚೆಗತ್ ಶರಿರಾಲಾ ಮಿಳುನ್ ಹಾವ್. ");
INSERT INTO gok_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","ಆಮಿ ಸಗ್‍ಳ್ಯಾಂಚಾನಿ ದುಸ್ರಿ ದುಸ್ರಿ ವರ ಗೆತಲ್ಯಾತ. ದೇವಾನಿ ಆಮಾನಾ ದಿಲ್ಯಾಲೆ ಕ್ರಪೆನಿ ಪರತೇಕ್ ವರ ದಿಲ್ಯಾ. ಪ್ರವಾದಿಚ಼಼ ವರ ದಿಲ ಆಸ್ಲತ ತ್ಯ ಆಪ್‍ಲ್ಯಾ ಇಸ್ವಾಸಾಸಾರ ತ್ಯೊ ವರ ಉಪೇಗ್ ಕರಾಯಾ ವ್ಹಯಿ. ");
INSERT INTO gok_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","ಸೇವಾ ಕರ್ತ್ಯಾಲ ವರ ಗೆಥ್ಯಾಲ್ಯಾನಿ ಸೇವಾ ಕರಾಯಾ ವ್ಹಯಿ. ಸಿಕ್ವಾಚ಼ ವರ ಆಸ್‍ಲ್ಯಾಲಾ ಸಿಕ್ವುನಿ ");
INSERT INTO gok_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","ಉಮೇದ್ ದೇತ್ಯಾಲ ವರ ಆಸ್ಲತ ತಸಸ್ ಕರುನಿ. ಕೋನ್ ವ್ಯಾಡ್‍ತ್ಯಾಲಾ ಹಾ ತ್ಯೊ ಉದಾರ್ ಮನಾನಿ ವಾಡುನಿ. ಜಾಂತಿಕ್ ಚಾ಼ಲಿವತ್ಯಾಲ್ಯಾನಿ ಜಾಂತಿಕ್ ಕರ್ತಾನಾ ಕಶ್ಟಾನಿ ರಾಬಾಯಾ ವ್ಹಯಿ. ಕನಿಕರ್ ದ್ಯಾವ್‌ತ್ಯಾಲ್ಯಾನಿ ಸಂತೋಶಾನಿ ತೀ ಕಾಮ ಕರಾಯಾ ವ್ಹಯಿತ. ");
INSERT INTO gok_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","ತುಮ್ಚಿ ಮಾಯಾ ಖರಿ ರಾಹುನಿ. ಬುರ್ಶಾ ಕಾಮಾಂಚಾ಼ ರಾಗ್ ಕರಾ. ಚಾಂಗ್ಲಿ ಕಾಮ ದರುನ್ ರಾವ್ಹಾ. ");
INSERT INTO gok_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","ಇಸ್ವಾಸಾಚಾ ಬಾವ್ಹಾ ಬನ್ಹಿಂಚೆಗತ್ ಯಕಾ ಮಕಾ ಸಂಗ ಕ್ರಿಸ್ತಾಚೆ ಮಾಯೆಶಾರ್ಕಿ ಮಾಯಾ ಕರಾ. ತುಮಿ ತುಮ್ಚಿಸಾಟಿ ಮಂಥ್ಯಾಲೆ ಮರೆದಿವ್ನಿ ಖುಬ್ ಮರ‍್ಯಾದ್ ತುಮ್ಚಾ ಬನ್ಹಿ ಬಾವ್ಹಾನಾ ದಾವಾ. ");
INSERT INTO gok_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","ತುಮ್ಚಾ ಪ್ರಭುಸಾಟಿ ಸೇವಾಕರಾಚಿ ವ್ಹಯಿ ಆಸ್ಥಾನಾ ಆಳಸೊಟಿ ವ್ಹವುನಕೋಸಾ, ಆತ್ಮಾಚಾ ಸಂತೊಶಾನಿ ತ್ಯಚಿ ಸೇವಾ ಕರಾ. ");
INSERT INTO gok_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","ತುಮಾನಾ ಆಶಾ ಹಾ ಮನ್ಹುನ್ ಸಂತೋಶ್ ವ್ಹವಾ. ತುಮಾನಾ ತರಾಸ್ ಆಸ್ಥಾನಾ ಥಂಡ್ಫನಾನಿ ರಾವ್ಹಾ. ಸಗ್‍ಳ್ಯಾ ಯಳಾತ್ ಮಾಗ್ನ ಕರಾ. ");
INSERT INTO gok_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","ಕೊರತೆತ್ ಆಸ್‌ಲ್ಯಾಲ್ಯಾ ದೇವಾಚಾ ಲೋಕಾನಾ ಮಜ಼ತ್ ಕರಾ, ತುಮಾಚಾ ಗರ‍್ಹಾತ್ಲಿ ದಾರ ವಳಕ್ ನಸ್‍ಲ್ಯಾಲ್ಯಾ ಲೋಕಾಂಚೆ ಸೇವೆ ಸಾಠಿ ಉಡ್ಗುನ್ ಥೆವಾ. ");
INSERT INTO gok_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","ಕೊನ್ ತುಮಾನಾ ಬುರ್ಸ ಕರ್ತ ತ್ಯಂಚಿ ಸಾಟಿ ಪ್ರಬುಪ ಮಾಗಾ ತ್ಯನಾ ಸರ್ಪುನಕೊಸಾ ಆಶಿರ್ವಾದ್ ಕರಾ. ");
INSERT INTO gok_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","ಸಂತೋಶ್ ವ್ಹತ್ಯಾಲ್ಯಾಂಚೆ ಸಂಗ ಸಂತೋಶ್ ವ್ಹವಾ. ದುಖ ವ್ಹತ್ಯಾಲ್ಯಾಂಚೆ ಸಂಗ ದುಖಾನಿ ರಾವಾ. ");
INSERT INTO gok_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","ತುಮಿ ಯಕಾಮಕಾಲಾ ಸಮಾಧಾನಾನಿ ಮಿಳುನ್ ಜೀವ್ನಾ ಕರಾ. ಗಮೆಂಡಿ ಕರುನಕೋಸಾ ಫನ್ ಥಂಡ್ಪನಾನಿ ತುಮ್ಚಾ ಹಾತಾತ್ ಆಸ್‍ಲ್ಯಾಲ್ಯಾ ಲೋಕಾಸಂಗ ಕಾಮ್ ಕರಾ. ತುಮಾನಾ ತುಮಿಸ್ ಶಾನ ಮನ್ಹುನ್ ಗಿಹುನಕೋಸಾ. ");
INSERT INTO gok_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","ಕುನಿ ತರಿ ತುಮಾನಾ ಬುರ್ಸ ಕೇಲತ, ತ್ಯಚೆ ಬದ್ಲಿ ತ್ಯಲಾ ಬುರ್ಸ ಕರುನಕೋಸಾ. ಸಗ್ಳಿ ಲೋಕ ಚಾಂಗ್ಲ ಮನ್ಹುನ್ ಸಮಜು಼ನ್ ಗೆಥ್ಯಾಲಿ ಕಾಮ ಕರಾಯಾ ಯತ್ನ ಕರಾ. ");
INSERT INTO gok_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","ಸಗ್‌ಳ್ಯಾ ಲೋಕಾ ಸಂಗ ಥಂಡ್ಪನಾನಿ ಜೀವ್ನಾಕರಾಯಾ ತುಮ್ಚಿಪ್ನಿ ವ್ಹಯಿಲ್ ತ್ಯವ್ಡ ಯತ್ನ ಕರಾ. ");
INSERT INTO gok_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","ಮಾಜಾ ಸೊಪ್‌ತ್ಯಾನು ತುಮಾನಾ ಬುರ್ಸ ಕರ್ತ್ಯಾಲ್ಯಾ ಲೋಕಾಂಚಿವ್ಲಾ ತುಮಿ ಕವಾಸ್ ಡಾವ್ ಫಾರಿಕ್ ಕರುನಕೋಸಾ. ಫನ್ ದೇವಾಚಾ ರಾಗಾತ್ ತ್ಯನಾ ಸುಡುನ್ ದೇವಾ. ಪವಿತ್ರ ಪುತಿಕಾತ್ ಮೀಸ್ ಡಾವ್ ಫಾರಿಕ್ ಕರ್ನಾರ್ ಆನಿ ಮೀಸ್ ಪ್ರತಿ ಫಳ್ ದೇನಾರ್. ” ಆಸ ಪ್ರಭು ಸಾಂಗ್ತೊ. ");
INSERT INTO gok_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","ತ್ಯಚೆ ಬದ್ಲಿ ಪವಿತ್ರ ಪುತಿಕಾತ್ ಸಾಂಗ್‍ಲ್ಯಾ ಶಾರ್ಕ, ತುಮಚ಼ ವಾದಿ ಭೂಕ್ಯಾಲಾತ, ತ್ಯಲಾ ಖಾಯಾ ದೇವಾ. ತುಮಚ಼ ವಾದಿ ತಾನ್ಯಾಲಾತ, ತ್ಯಲಾ ಪಿಯಾಲಾ ಪಾನಿ ದೇವಾ. ತುಮಿ ಆಸ ಕೇಲಸಾತ, ತ್ಯಚೆ ಡುಯಿವ ಇಂಗಾಳ್ ಥೆವಲ್ಯಾಸಾರ ವ್ಹನಾರ್ ಆನಿ ತ್ಯಲಾ ಲಾಜ಼್ ವಾಟ್ನಾರ್.” ");
INSERT INTO gok_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","ಬುರ್ಶಾ ಫನಾಲಾ ತುಮಾನಾ ಪಡು ದಿವು ನಕೊಸಾ ತ್ಯಚೆ ಬದ್ಲಿ ಚಾ಼ಂಗ್ಲ ಕರ್ತ್ಯಾಲ್ಯಾನಿ ಬುರ್ಶಾ ಫನಾಲಾ ಹರ್ವಾ. ");
INSERT INTO gok_vpl VALUES ("RM13_1","075_13_1","ROM","13","1"