﻿USE sofia;
DROP TABLE IF EXISTS sofia.goj_vpl;
CREATE TABLE goj_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES goj_vpl WRITE;
INSERT INTO goj_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","अब्राहम को बेटो दाउद, को बेटो यीशु मसीह की वंशावली असी हइ. ");
INSERT INTO goj_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","अब्राहम से इसहाक पैयदा हुयो. इसहाक से याकूब पैयदा हुयो. अरु याकूब से यहूदा अरु ओको भैइ पैयदा हुयो. ");
INSERT INTO goj_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","यहूदा अरु तामार से पेरेस व जोरह, पेरेस से हिस्रोन अरु हिस्रोन से एराम, पैयदा हूयो. ");
INSERT INTO goj_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","अरु एराम से अम्‍मीनादाब. अरु अम्‍मीनादाब से नहशोन अरु नहशोन से सलमोन पैयदा हूयो. ");
INSERT INTO goj_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","सलमोन अरु राहब से बोआज, अरु बोआज अरु रुत से ओबेद. अरु ओबेद से यिशय पैयदा हुयो. ");
INSERT INTO goj_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","अरु यिशय से दाउद राजो अरु उरियाह दाउद से सुलैमान उ बय से पैयदा हुयो जो उरीय्याह की लुगेन थी. ");
INSERT INTO goj_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","सुलैमान से रहबाम, अरु रहबाम से अबिय्याह, अरु अबिय्याह से आसा पैयदा हुयो. ");
INSERT INTO goj_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","आसाफ से यहोशाफात, अरु यहोशाफात से योराम, अरु योराम से उज्जियाह पैयदा हुयो. ");
INSERT INTO goj_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","उज्जियाह से योताम से आहाज अरु आहाज से हिजकिय्याह पैयदा हुयो. ");
INSERT INTO goj_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","हिजकिय्याह से मनश्शे से पैयदा हुयो, मनश्शे से पैयदा हुयो आमोन, अरु आमोन योशिय्याह पैयदा हुयो, ");
INSERT INTO goj_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","अरु गिरपतार हुइखे बाबेल जान का टेम मे योशिय्याह से यकुन्याह, अरु ओको भैइ पैयदा हुयो. ");
INSERT INTO goj_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","गिरपतार हुइखे बाबेल पोचान जान का बाद यकुन्याह, से शालतीएल. अरु शालतीएल से जरुब्बाबेल पैयदा हुयो. ");
INSERT INTO goj_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","जरुब्बाबेल से अबिहुद. अबिहुद से एलयाकिम अरु एलयाकीम से अजोर पैयदा हुयो. ");
INSERT INTO goj_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","अजोर से सादोक, सादोक से अखीम. अरु अखीम से इलीहूद पैयदा हुयो. ");
INSERT INTO goj_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","इलीहूद से एलियाजार. एलियाजार से मत्तान. अरु मत्तान से याकूब पैयदा हुयो. ");
INSERT INTO goj_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","याकूब से यूसुफ. जो मरियम को अदमी थो, अरु मरियम से यीशु पैयदा हुयो, जो मसीह बोलस हइ. ");
INSERT INTO goj_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","यो प्रकार अब्राहम से दाउद तक सब चौदा पिडी हुइ अरु दाउद का टेम से बाबेल को गिरपतार हुइ खे पोचान जाना तक, चौदा पिडी अरु गिरपतार हुइ खे बेबीलोन खे पहुची जाना का टेम से लिखे मसीह तक चौदा पिडी हुय. ");
INSERT INTO goj_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","यीशु मसीह को जन्म या रीती से हुय, की जब ओकी माय मरियम की मगनी यूसुफ का साथ हुय गइ, ते उनको भ्याव होना से पैयले वा पवित्र आत्मा का तरप से दिन से हुय गय. ");
INSERT INTO goj_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","येकालिये ओका अदमी यूसुफ ने जो धर्मी होन का कारण ओखे बदनाम करणो नी चाहतो थो, या इच्छा से चुपचाप छोडी देन को मन कर्यो. ");
INSERT INTO goj_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","जब उ या बात का सोच मे थो ते प्रभु को एक स्वर्गदूत ओखे दृष्‍टान्‍त मे दिखानो अरु बोलन लग्यो. हे यूसुफ! दाउद की सन्तान खे तू मरियम खे अपनी बायको बनाना से डरे मत. क्युकी जो ओका पेट मे हइ, उ पवित्र आत्मा का तरप से हइ. ");
INSERT INTO goj_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","उ बेटो पैयदा कर्हे अरु तोने ओको नाम यीशु रखनु. क्युकी वु अपना दुन्याहोन को उनका पाप से उध्दार कर्हे. ");
INSERT INTO goj_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","यो सब कुछ येका लिये हुयो की जो वचन प्रभु ने भविष्यव्दक्ता का वजेसे बोल्यो थो. वु पुरो हुये. ");
INSERT INTO goj_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“देख एक कुव्वारी दिन से हुये अरु एक बेटो पैयदा, अरु ओको नाम इम्मानुएल रख्यो जाह्ये,” जेको मतलब यो हइ की परमेश्वर हमारा साथ. ");
INSERT INTO goj_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","तब यूसुफ नीद से जागीखे प्रभु का दूत की बात कि आज्ञा का जसो ओने अपनी बायको बनान खे अपना घर मे लयली. ");
INSERT INTO goj_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","अरु जब तक मरियम का पास नी गयो जब तक ओने बेटा खे जन्म नी दियो अरु यूसुफ ने ओको नाम यीशु रख्यो. ");
INSERT INTO goj_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","हेरोदेस राजा का दिन मे यहूदीया देस का बैतलहम गाव मे यीशु को जन्म हुयो, ते पूर्व दिशा से कुछ तारा को आभ्यस करण आलो ज्ञानी इन्सान यरुशलेम मे अयखे पुछन लग्या. ");
INSERT INTO goj_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","कि यहूदीयाहोन को राजो जेको जन्म हुयो हइ, वु खा हइ? क्युकी हम ने पूर्व मे ओको तारो देख्यो हइ अरु ओखे प्रणाम करण आनो हइ. ");
INSERT INTO goj_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","यो सुनीखे हेरोदेस राजो अरु ओका सात सब यरुशलेम घबरय गया. ");
INSERT INTO goj_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","तब ओने दुन्याहोन का सब प्राधन याजकहोन अरु नीयम शास्त्रिहोन खे जमा करीखे उनखे पुछ्यो, कि मसीह को जन्म खा होनु चास? ");
INSERT INTO goj_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","उनने ओकासे बोल्यो की यहूदीया देस का बैतलहम गाव मे. क्युकी भविष्यव्दक्ता का वजेसे लिख्यो गयो हइ ");
INSERT INTO goj_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","हे बैतलहम, तू जो यहूदा देस मे हइ, तू कोय भी रीति से तू यहूदा को अधिकारीहोन मे सब से छोटो नी. क्युकी तरा मे से एक राजो नीकले, जो मरी जनता इस्राएल की रखवाली कर्हे. ");
INSERT INTO goj_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","तब हेरोदेस ने तारा को आभ्यस करणवाला ज्ञानी इन्सानहोन खे चुपचाप से बुलय खे उनका से पुछ्यो, की तारो बराबर कोन सा टेम मे दिखय दियो थो. ");
INSERT INTO goj_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","अरु ओने यो बोलीखे उनखे बैतलहम भेज्यो, कि जयखे उ बच्चा का बारे मे बरोबर मालूम करीखे, अरु जब व्हा कुछ मीली जाह्ये ते मेखे खबर दे, ताकी मी भी अयखे ओखे प्रणाम कऱ्यु. ");
INSERT INTO goj_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","वे राजा की बात सुनीखे चली गया, अरु देख, जो तारो उनने पूर्व मे देख्यो थो, वु उनका आगे आगे चल्यो, अरु झा बच्चो थो. वा जगा का उपर पोचीखे रुखी गयो. ");
INSERT INTO goj_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","वु तारा खे देखी खे वे भोत खुश हुय गया. ");
INSERT INTO goj_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","उनने उ घर मे पोची खे वु बच्चा खे ओकी माय मरियम का सात देख्यो, अरु मुडा का उपर गिरीखे बच्चा खे प्रणाम कऱ्यो. अरु अपनी अपनी थैली खोली खे ओखे सोन्नो, अरु लोबान, अरु गन्धरस ओखे दान चडायो. ");
INSERT INTO goj_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","तब दृष्‍टान्‍त मे परमेश्वर का वजेसे या चेतावनी सुनी खे कि हेरोदेस का पास फिर नी जानु, उ दुसरी रस्ता से जय खे अपना देस मे चली गयो. ");
INSERT INTO goj_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","उनका चली जाना का बाद परमेश्वर को एक दूत ने सपना मे यूसुफ खे देखीखे बोल्यो, उट. वु बच्चा खे अरु ओकी माय खे लिखे मीस्र देस मे भागी जा. अरु जब तक मी तरा से नी बोलू तब तक व्हा र्हेनु. क्युकी हेरोदेस यो बच्चा खे ढुडना पर हइ कि ओखे मारी डालस. ");
INSERT INTO goj_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","तब उ रात मे उठीखे बच्चा खे अरु ओकी माय खे लिखे मीस्र देस मे चली गयो. ");
INSERT INTO goj_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","अरु हेरोदेस का मरना तक व्हा ऱ्हीयो. येका लिये की उ वचन जो प्रभु ने भविष्यव्दक्ता का वजेसे बोल्यो थो उ पुरो हुयो खे “मेने अपना बेटा खे मीस्र से बुलायो.” ");
INSERT INTO goj_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","जब हेरोदेस ने यो देख्यो, की पडीतहोन ने ओका सात धोको कऱ्यो हइ, तब उ घुस्सा से भरी गयो अरु दुन्या खे भेजी खे पडीतहोन का वजेसे तारा देखन का टेम का जसो बैतलहम अरु ओका आस पास का सब गावहोन का सब बच्चा खे जो दो साल का या ओकासे छोटा था, मारी डाल्या. ");
INSERT INTO goj_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","तब जो वचन यिर्मयाह भविष्यव्दक्ता का वजेसे बोल्यो गयो थो, उ पुरो हुयो. ");
INSERT INTO goj_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“रामाह मे एक चित्कर, रोन सुनायो दियो, रोनो अरु बडो विलाप राहेल अपना बच्चा का लिये रोय री हइ अरु शांती होनु नी चाती थी ‍क्युकी उ अब नी ऱ्हीयो.” ");
INSERT INTO goj_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","हेरोदेस का मरना का बाद को प्रभु खे दूत ने मीस्र मे यूसुफ का सपना मे दिखय दिखे बोल्यो. ");
INSERT INTO goj_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","उट, बच्चो खे अरु ओकी माय खे लीखे इस्राएल देस मे चली जा. क्युकी जो बच्चा को जान लेनो चाहतो थो, उ मरी गयो. ");
INSERT INTO goj_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","यूसुफ नीद से उठ्यो, अरु बच्चा अरु ओकी माय खे सात लीखे इस्राएल का देस मे आया. ");
INSERT INTO goj_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","पन यो सुनी खे की अरखिलाउस अपना बाप हेरोदेस कि जगा यहूदीया पर राज्य करी रोस हइ, व्हा जाना से डरीखे फिर दृष्‍टान्‍त मे परमेश्वर से सुचना लीखे गलील देस मे चली गयो. ");
INSERT INTO goj_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","अरु नासरत नामको एक नगर मे जय बठ्या. ताकि उ वचन पुरो हुये खे जो भविष्यव्दक्ताहोन का वजेसे बोल्यो गयो थो, “उ नासरी बोल्यो जाह्ये.” ");
INSERT INTO goj_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","उ दिन मे यहून्ना बपतिस्मा देनवालो अयखे यहूदीया का जंगल मे यो प्रचार करण लग्यो. ");
INSERT INTO goj_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","अपना पाप से मन फिराव. क्युकी स्वर्ग को राज्यो नजीक अय गयो हइ. ");
INSERT INTO goj_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","यो उ हइ जोकी बात यशायाह भविष्यव्दक्ता का वजेसे करी गइ “जंगल मे एक पुकारन आलो को आवाज हुय रोस हइ, की प्रभु की रस्ता तैयार कर, ओकी सडक सीधी कर.” ");
INSERT INTO goj_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","यो यहून्ना उट का बाल का कपडा पेन्यो थो, अरु अपनी कमर मे चामडा को पट्टो बाध्यो हुयो थो, अरु ओको खानो टोटर अरु मोहरुस थो. ");
INSERT INTO goj_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","तब यरुशलेम का अरु सब यहूदीया, अरु यरदन नद्दी का आस पास का गाव का दुन्या ओका पास नीकली आया. ");
INSERT INTO goj_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","अरु अपना अपना पाप खे मानी खे यरदन नदी मे ओका से बपतिस्मा लियो. ");
INSERT INTO goj_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","जब ओने भोत सा फरीसीहोन अरु सदूकिहोन खे बपतिस्मा का लिये अपना पास आते देख्यो, ते उनसे बोल्यो, की हे साप का बच्चा तुम खे कोने बतय दियो, की आनवालो घुस्सा से भाग्यो? ");
INSERT INTO goj_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","अपना पाप से मन फिराव खे परमेश्वर तरप चली गयो असो जिवन खुद जिखे बता. ");
INSERT INTO goj_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","अरु अपना अपना मन मे यो नी सोचनू, की हमारो बाप अब्राहम हइ. क्युकी मी तुम से बोलूस हइ, की परमेश्वर यो फत्थर से अब्राहम का लिये बच्चो पैयदा करी सकस हइ. ");
INSERT INTO goj_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","अरु कुल्‍हाडी झाड की जडी पर रखी हुइ हइ, येका लिये जो जो झाड अच्छा फल नी लाय, ओखे, काट्यो अरु अंगार मे डाल्यो जास हइ. ");
INSERT INTO goj_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","मी तो पानी से मन फिराव को बपतिस्मा दियुस हइ, पन जो मरा बाद मे आनवालो हइ, उ मरासे भी शक्तिशाली हइ. मी ओका जुता खे उठान का योग्य नी, उ तुम खे पवित्र आत्मा अरु अंगार से बपतिस्मा देस. ");
INSERT INTO goj_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","ओको सुपडो ओका हात मे हइ, अरु उ अपना खेत अच्छा तरीका से सपा कऱ्हे, अरु अपना गहु खे खेत मे जमा कऱ्हे, पन भूसा खे उ अंगार मे जलाहे जो बुझन की नी. ");
INSERT INTO goj_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","उ टेम यीशु गलील से यरदन नद्दी का धुरा पर यहून्ना को पास ओकासे बपतिस्मा लेन आयो. ");
INSERT INTO goj_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","पन यहून्ना यो बोलीखे ओखे रोखन लग्यो, की मखे तरा हात से बपतिस्मा लेन की जरुरत हइ, अरु तू मरा पास आयो हइ? ");
INSERT INTO goj_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","यीशु ने ओखे यो उत्तर दियो, कि अब तो असो ही होन दे, क्युकी हमने या रीति से सब धार्मीकता खे पुरो करणो परमेश्वर कि नजर मे जरुरती हइ, तब ओने ओकी बात मानी ली. ");
INSERT INTO goj_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","अरु यीशु ने बपतिस्मा लिखे झल्दी पाणी मे से उपर आयो, अरु देख्यो, ओका लिये बद्दल खुली गयो. अरु ओने परमेश्वर की आत्मा खे कबूतर का जसो ओका उपर उतरते देख्यो. ");
INSERT INTO goj_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","अरु देख, या आकाशवाणी हुइ, “यो मरो लाड को बेटो हइ, जेका से मी पुरी तरह खुसी हइ.” ");
INSERT INTO goj_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","जब वा टेम मे आत्मा यीशु खे जंगल मे ली गयो ताकी सैतान से ओकी परीक्षा हुय. ");
INSERT INTO goj_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","उ चालीस दिन, अरु चालीस रात, उपास र्हीयो, तब ओखे भोत भुख लगी. ");
INSERT INTO goj_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","जब परखनआला ने नजीक अय खे ओका से बोल्यो, अगर तु परमेश्वर को बेटो आय, ते बोली दे, कि या फत्थर रोटी बनी जाह्ये. ");
INSERT INTO goj_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","यीशु ने उत्तर दियो, “की शास्त्र मे लिख्यो हइ, इन्सान फक्त रोटी मे से नी, पन हर एक वचन से जो परमेश्वर का मुडा से नीकलस हइ जिन्दो र्हीये.” ");
INSERT INTO goj_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","जब सैतान वोखे पवित्र नगर मे ली गयो अरु मन्‍दिर का छेडा पर खडो कर्यो ");
INSERT INTO goj_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","अरु ओकासे बोल्यो, अगर तु परमेश्वर को बेटो हइ, ते अपना आप खे नीच्चे गीऱ्य दे. क्युकी लिख्यो हइ, उ तरा बारे मे अपना स्वर्गदूत खे आज्ञा दिये. अरु वे तोखे हाथो हात उठय लीहे. असो नी होनु की तरा पाय मे फत्थर से ठोकर खाये. ");
INSERT INTO goj_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","यीशु ने ओकासे बोल्यो “शास्त्र मे यो भी लिख्यो हइ, कि तु प्रभु अपनो परमेश्वर की परीक्षा नी कर्हे.” ");
INSERT INTO goj_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","फिर सैतान ओखे एक भोत उची टेकडी, पर ली गयो अरु जगत कि महिमा राज्य अरु ओको वैभव बतायो. ");
INSERT INTO goj_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","ओकासे बोल्यो, कि अगर तु गिरी खे मेखे प्रणाम कर्हे, ते मी यो सब कुछ तोखे दि दियु. ");
INSERT INTO goj_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","जब यीशु ने ओकासे बोल्यो. हे सैतान दुर हुइ जा, क्युकी लिख्यो हइ, तु प्रभु अपना परमेश्वर खे प्रणाम कर, अरु फक्त ओखे उपासना कर. ");
INSERT INTO goj_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","जब सैतान ओका नजीक से चली गयो, अरु स्वर्गदूत अय खे ओकी सेवा करण लग्यो. ");
INSERT INTO goj_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","जब ओने यो सुन्यो की यहून्ना पकडि दियो गयो, ते व्हा गलील खे चली गयो. ");
INSERT INTO goj_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","अरु नासरत खे छोडी खे कफरनहूम मे जो नद्दी का धुरा जबूलून अरु नपताली खे देस मे हइ जय खे र्हेन लग्यो. ");
INSERT INTO goj_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","ताकी जो यशायाह भविष्यव्दक्ता का वजेसे बोल्यो गयो थो, उ पुरो हुये. ");
INSERT INTO goj_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“नद्दी कि रस्ता से जबूलून अरु नपताली को देस, समुद्र कि रस्ता पर, यरदन नद्दी का उ पार, गैरयहूदीहोन को गलील.” ");
INSERT INTO goj_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","“जो दुन्या अंधारा मे बठ्या था, उनने बडो उजालो देख्यो. अरु जो मरन का देस अरु छाया मी बठ्यो थो, उन पर उजालो चमक्यो.” ");
INSERT INTO goj_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","वो टेम से यीशु ने प्रचार करणो अरु यो बोलनो सुर्वात कऱ्यो, “कि हमारा पाप से मन फिराव क्युकी स्वर्ग को राज नजीक आयो हइ.” ");
INSERT INTO goj_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","ओने गलील की नद्दी का धुरापर घुमते हुये दो भैइ अगर शमौन खे जो पतरस बोलस हइ, अरु ओको भैइ अन्द्रियास खे नद्दी मे जाल डालते देख्यो. क्युकी वे डिम्बरहोन था. ");
INSERT INTO goj_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","अरु ओने बोल्यो, “मरा पिछे चली खे आ, मी तुम खे इन्सानहोन खे परमेश्वर का राज मे लानवाला बानाह्यु.” ");
INSERT INTO goj_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","वे झल्दी जाल खे छोडी खे ओका पिछे लिया. ");
INSERT INTO goj_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","अरु व्हा से आगे बडी खे, ओने अरु दो भैइ अगर जब्दी को बेटो याकूब अरु ओको भैइ यहून्ना खे अपनो बाप जब्दी का सात डोंगा पर अपनी जाल खे सुधारते देख्यो. अरु उनखे भी बुलायो. ");
INSERT INTO goj_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","वे झल्दी डोंगा अरु अपना बाप खे छोडी खे ओका पिच्छे हुय गया. ");
INSERT INTO goj_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","अरु यीशु सब गलील मे घुमते हुयो उनका आराधनालयहोन मे उपदेस करतो थो, अरु राज को सुसमाचार प्रचार करतो थो, अरु दुन्याहोन की हर प्रकार की बिमारी अरु दुर्बलता खे दुर करतो र्हीयो. ");
INSERT INTO goj_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","अरु सब सीरिया देस मे ओको यश फैली गयो. अरु दुन्या सब बिमारी खे, जो दुसरी तरीका की बीमारीहोन अरु दुख मे पड्या हुया था, अरु जोमे बुरी आत्मा थी अरु मीर्गीआला अरु लखवा का रोगीहोन खे ओका पास लायो अरु ओने उन खे अच्छो कऱ्यो. ");
INSERT INTO goj_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","गलील अरु दिकापुलीस, यरुशलेम का यहूदीयाहोन अरु यरदन नदी का पार से बडी गर्दी ओका पिच्छे हुय गइ. ");
INSERT INTO goj_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","उ या गर्दी खे देखी खे, टेकडी पर चेढी गयो. अरु जब बठी गया ते ओका सेवक होन ओका पास आया. ");
INSERT INTO goj_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","यीशु ने उनखे शिक्षा देनो सुरु कऱ्यो ");
INSERT INTO goj_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“अच्छो हइ उ, जो आत्मा से दीन हइ, क्योकि स्वर्ग को राज्य उनका मे हइ.” ");
INSERT INTO goj_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“अच्छो हइ उ.” जो शोक करस हइ, क्युकी वे दुनीया शांती पाये. ");
INSERT INTO goj_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“अच्छो हइ उ, जो नम्र हइ, क्योकि उ धरती को वारीस दार हुये.” ");
INSERT INTO goj_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“अच्छो हइ उ, जो धार्मीकता को भूको अरु प्यासो हइ, क्युकी वे तृप्त धन्य कर्‍यो जाए.” ");
INSERT INTO goj_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","अच्छो हइ उ, जो दयावन हइ, किक्यु उन पर दया करी जाये. ");
INSERT INTO goj_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","अच्छो हइ उ जोको मन अच्छो हइ क्योकि उ परमेश्वर खे देखे. ");
INSERT INTO goj_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","अच्छो हइ उ जो शांती को काम करनवाला हइ; क्योकि वे परमेश्वर का बच्चा बोल्या जाये! ");
INSERT INTO goj_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“अच्छो हइ उ जो धार्मीकता करनआला खे सतायो जास हइ; क्योकि स्वर्ग को राज्य उनकोय हइ! ");
INSERT INTO goj_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“अच्छो हुये तुम जब इन्सान मरा कारन तुम्हारी मजाक उडाये अरु सताये अरु झुठ बोली खे तुम्हारा विरोध मे सब प्रकार की बुरी बात बोलस. ");
INSERT INTO goj_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","तब खुसी अरु मगन होनु, क्योकि तुम्हारा लिये स्वर्ग मे बडो प्रतीफल हइ. येका लिये कि उनने उ भविष्यव्दक्ता खे जो तुम से पैयले थो या रीति से सतायो थो. ");
INSERT INTO goj_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“तुम पृथ्वी का नोन हुये. पन अगर नोन को सवाद बिगडी जाये ते उ फिर कोय चिज से खारो कऱ्यो जाये? फिर उ कोय काम को नी, फक्त येखे बाहेर फेक्यो जाए अरु इन्सानहोन का पाय का नीचे खुद्यो जाए.” ");
INSERT INTO goj_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","तुम जगत को दिवो हुये. जो गाव टेकडी पर बस्यो हुयो हइ उ रुखी नी सकस. ");
INSERT INTO goj_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","अरु दुन्या दिवो जलयखे टोपली, नीचे नी पन दिवा खे घर पर रखस हइ, तब ओकासे घर का सब दुन्याहोन खे उजालो पोचास हइ. ");
INSERT INTO goj_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","यो प्रकार तुम्हारो उजालो इन्सानहोन का सामने चमख्ये कि उ तुम्हारो अच्छो काम खे देख्ये तुम्हारा बाप खे, जो स्वर्ग मे हइ, महिमा कर्‍हे. ");
INSERT INTO goj_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“यो नी समजनु, कि मी मूसा व्यवस्था यो भविष्यव्दक्ता कि शिक्षाहोन खे लोप करण आयो हइ, खतम करण नी आयो, पन पुरो करण आयो हइ.” ");
INSERT INTO goj_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","क्योकि मे तुमारा से सच्ची बोलुस हइ, कि जब तक बद्दल अरु पृथ्वी खतम नी हुइ जाह्ये तब तक व्यवस्था से एक मात्र यो टिम्बो बिना पुरो हुयो नी जाह्ये. ");
INSERT INTO goj_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","येका लिये जो कोय या छोटी सी छोटी आज्ञाहोन मे से कोय एक खे पालन नी कर्‍हे, अरु असो मे दुन्याहोन खे सिखास उ स्वर्ग का राज मे सबसे छोटो बोल्यो जाह्ये पन जो कोय वा आज्ञाहोन को पालन कर्‍हे अरु उनखे सिखाए, उ स्वर्ग का राज्य मे महान बोल्यो जाये. ");
INSERT INTO goj_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","क्युकी मी तुम से बोलुस हइ, कि अगर तुमारी धार्मीकता पंडीतहोन अरु फरीसीहोन की न्यायीपन से बडीखे नी हुये ते तुम स्वर्ग का राज्य मे कभी प्रवेश करणो नी पाये. ");
INSERT INTO goj_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","तुम सुनी चुक्या हइ, की पुरानो काल का दुन्याहोन से बोल्यो गयो थो, कि हत्या नी करणु अरु “जो कोय हत्या कर्‍हे उ कठोर दण्ड का योग्य हुये. ");
INSERT INTO goj_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","पन मी तुम से यो बोलुस हइ, कि जो कोय अपना भैइ पर घुस्सा कर्‍हे उ कोरट मे दण्ड का योग्य हुये अरु जो कोय भैइ खे नीकम्मो बोल्यो उ महासभा मे दण्ड का योग्य हुये. अरु जो कोय बोले अरे मुर्ख. उ नरक कि अंगार को दण्ड का योग्य हुये.” ");
INSERT INTO goj_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","येका लिए अगर तु अपनी दान वेदी पर ला अरु व्हा तु याद कर, कि मरा भैइ का मन मे मरा तरप से कुछ विरोध हइ. ");
INSERT INTO goj_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ते अपनी दान वा वेदी का सामने छोडी दे, अरु जेखे पैयले अपना भैइ से मेल मीलाप कर. फिर अयखे अपनी दान चेडानु. ");
INSERT INTO goj_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","जब तक न्याय तु अपना दुशमन का साथ रस्ता मे हइ, ओकासे झटपट मेल मीलाप करी ले खय असो नी हुये कि दुशमन तोखे डॉक्टर खे सोपे, अरु डॉक्टर तोखे सेवक खे सोपी दिये अरु तू जेल खाना मे डाली दिये जाए. ");
INSERT INTO goj_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","मी तुम से सच्ची बोलुस हइ कि जब तक तु एक-एक सिक्का खे चुकय नी दे तब तक व्हा से छुटयो नी पाये. ");
INSERT INTO goj_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","तुम सुनी चुक्या हइ कि बोल्यो गया थो, व्यभिचार नी करणु. ");
INSERT INTO goj_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","पन मी तुम से यो बोलुस हइ, कि जो कोइ कोय बय पर बुरीनजर डाले उ अपना मन मे ओकासे व्यभिचार करी चुक्यो. ");
INSERT INTO goj_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","अगर तरो जवनो आख तोखे ठोकर खलाये ते ओखे नीकाली खे फेकी दे. क्युकी तरा लिये योही अच्छो हइ कि तरा आंग मे से एक नास हुये जाये अरु तरो पुरो आंग नरक मे नी डाल्यो जाये. ");
INSERT INTO goj_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","अरु अगर तरो जवनो हात तोखे ठोकर खलाये का ते ओखे काटी खे फेकी दे, क्योकि तरा लिये योही अच्छो हइ, कि तरा आंग मे से एक आंग खतम हुये जाये अरु तरो पुरो आंग नरक मे नी डाल्यो जाये. ");
INSERT INTO goj_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","यो भी बोल्यो गयो थो, जो कोय अपनी लुगेन खे छोडी दे, ते ओखे फरकती दे. ");
INSERT INTO goj_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","पन मी तरा से यो बोलुस हइ कि जो कोय अपनी लुगेन खे व्यभिचार का वजेसे कोय अरु करण से फरकती देस, ते उ ओकासे व्यभिचार करवास हइ. अरु जो कोय वा छोडी हुये से भ्याव कर, उ व्यभिचार करस हइ. ");
INSERT INTO goj_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","फिर तुम सुनी चुक्या हइ, कि पुराना जमाना का दुन्याहोन से बोल्यो गयो थो, झुठी कसम नी खानु, पन परमेश्वर का लिये अपनी कसम खे पुरी करणु. ");
INSERT INTO goj_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","पन मी तुम से यो बोलुस हइ, कि कभी कसम नी खानु. नी ते स्वर्ग की, किक्यु उ परमेश्वर की राजगद्दी हइ. ");
INSERT INTO goj_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","नी जमीन की, किक्यु वा ओका पाय की चौकी हइ. नी यरुशलेम की, किक्यु उ महा राजा को गाव हइ. ");
INSERT INTO goj_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","अपना माथा की भी कसम नी खानु किक्यु तु एक बाल खे भी सफेद या कालो नी करी सकस हइ. ");
INSERT INTO goj_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","पन तुम्हारी बात हव की हव, या नी कि नी हुये. किक्यु जो कुछ येका से अधिक होस हइ उ बुरो मे होस हइ. ");
INSERT INTO goj_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","तुम सुनी चुक्या हइ, कि बोल्यो गयो थो, कि आख का बदलो आख, अरु दात का बदलो दात. ");
INSERT INTO goj_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","पन मी तुमसे यो बोलुस हइ, जो तुम से बुरो व्यव्हार करस हइ ओको सामनो नी करणु. पन जो कोय तरा जवनो गाल पर थप्पड मारे ते ओका तरप दुसरो भी गाल दी देनु. ");
INSERT INTO goj_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","अरु अगर कोय तरा पर मुकद्दमो करीखे तरो कुर्ता लेनो चास ते ओखे कपडो भी लेन दे. ");
INSERT INTO goj_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","अरु जो कोय तोखे भोत दुर मजबुरी मे ली जाये ते ओका साथ दो कोस चली जा. ");
INSERT INTO goj_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","अरु जो कोय तरा से मागे, ओखे दे. अरु जो तरा से उधार लेनु चाह्ये, ओकासे मुडो नी मोडनु. ");
INSERT INTO goj_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","तुम सुनी चुक्या हइ, कि बोल्यो गयो थो. कि अपना पडोसी से प्रेम रखनु अरु अपना दुसमन से दुर कर. ");
INSERT INTO goj_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","पन मी तुम से यो बोलुस हइ, कि अपना दुसमन होन से प्रेम रखनु अरु अपना सतानआलो का लिये प्रार्थना करणु. ");
INSERT INTO goj_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","जेका से तुम अपना स्वर्गीय बाप, बच्चा ऱ्हीये क्योकि उ अच्छो अरु बुरो दोय पर अपनो सुरज नीकलस हइ, अरु न्याय अरु धर्मी पन पर पाणी बरसास हइ. ");
INSERT INTO goj_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","किक्यु अगर तुम अपनो प्रेम रखनआला हि से प्रेम रखे, ते तुम्हारा लिये लाभ हुये, चुगी लेनआला भी असो नी करस. ");
INSERT INTO goj_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","अरु अगर तुम फक्त अपना भैइहोन खे हि नमस्कार कर्हे, ते कोन सो बडो काम करस हइ? गैरयहूदिहोन भी असो नी करस. ");
INSERT INTO goj_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","येका लिये सही कि तुम पक्को बन, जसो तुम्हारो स्वर्गीय बाप पक्को हइ. ");
INSERT INTO goj_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","हुशार ऱ्हे तुम इन्सानहोन खे देखन का लिये अपनो धार्मीकता को काम नी करस, नी ते अपना स्वर्गीय बाप से कुछ भी फल नी पास. ");
INSERT INTO goj_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","येका लिये जब तु दान कर्‍हे, ते अपनो ढिडोरो नी पिटनु, जसा कपटि राधनालयहोन अरु गल्लिहोन मे करस हइ, ताकी दुन्या उनकि महिमा कह्रे, मी तरा से सच्ची बोलुस हइ ,कि वे अपनो प्रतीफल ली लिये. ");
INSERT INTO goj_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","पन जब तु दान कर्‍हे, ते जो तरो जवनो हात करस हइ, ओखे तरो डाखोर्‍या हात खे मालुम नी होन देनु. ");
INSERT INTO goj_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ताकि तरो दान गुप्त ऱ्हीहे. अरु तब तरो बाप जो गुप्त मे देखस हइ, तोखे प्रतीफल दिये. ");
INSERT INTO goj_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","अरु जब तु प्रार्थना कर्‍हे, ते कपटिहोन का जसो नी हुये क्योकि दुन्याहोन खे देखन का लिये यहूदीया आराधनालय मे अरु सडकहोन, मोड पर खडो हुइ खे प्रार्थना करणु उनखे अच्छो लगस हइ. मी तरा से सच्ची बोलुस हइ, कि वे अपनो प्रतीफल ली लिये. ");
INSERT INTO goj_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","पन जब तु प्रार्थना कर्‍हे, ते अपनी झोपडि मे जा. अरु दरवाजो बन्द करी खे अपना बाप से जो चुपचाप मे हइ प्रार्थना कर. अरु तब तरो बाप जो चुपचाप मे देखस हइ, तोखे प्रतीफल दिये. ");
INSERT INTO goj_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","प्रार्थना करण का टेम गैरयहूदिहोन का जसो बक-बक नी करणु. क्योकि वे समझस हइ कि उनका भोत बोलना से उनकी सुनी जाये. ");
INSERT INTO goj_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","येका लिये तुम उनका जसो नी बन्नु, क्योकि तुम्हारो बाप तुम्हारा मागना से पैयले हि जानस हइ, कि तुम्हारी का जरुरत हइ. ");
INSERT INTO goj_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","अन्नत तुम या रिती से प्रार्थना कऱ्यो कर्‍हे हे, हमारा बाप तु जो स्वर्ग मे हमारा बाप हइ. तरो नाम पवित्र मान्यो जास; ");
INSERT INTO goj_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","“तरो राज्य आयो. तरी इच्छा जसी स्वर्ग मे पुरी होस हइ” असो पृथ्वी पर भी हुये. ");
INSERT INTO goj_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","हमारी दिन भर की रोटी आज हमखे दे. ");
INSERT INTO goj_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","अरु जो प्रकार हमने अपना गुना खे माफ कऱ्यो हइ, असो हि तु भी हमारी बुराइ खे माफ कर. ");
INSERT INTO goj_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","अरु हमखे परीक्षा मे मत ला, पन बुरोइ से बचास. क्युकी राज्य अरु पराक्रम अरु महिमा कभी भी तरी ही हइ. आमीन. ");
INSERT INTO goj_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“येका लिये अगर तुम इन्सान को बुरो माफ कर्‍हे, ते तुम्हारो स्वर्गीय बाप भी तुमखे माफ करस. ");
INSERT INTO goj_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","अरु अगर तुम इन्सानहोन को बुरो माफ नी करस, ते तुम्हारो बाप भी तुम्हारो बुरो माफ नी कर्‍हे.” ");
INSERT INTO goj_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“जब तुम उपास कर्‍हे ते कपटिहोन का जसी तुम्हारो मुडा पर उदास नी ऱ्हेनु क्योकी वे अपनो मुडो बनायो ऱ्हेस हइ, ताकी दुन्या उनखे उपास जानस. मी तुम से सच्ची बोलुस हइ, कि वे अपनो प्रतीफल ली चुक्या. ");
INSERT INTO goj_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","पन जब तू उपास करस ते अपना माथा पर तेल लगा अरु मुडो धोयले. ");
INSERT INTO goj_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ताकी दुन्या नी पन तरो बाप जो गुप्त मे हइ, तोखे भुको जान्यो. या दशा मे तरो बाप जो गुप्त मे देखस हइ, तोखे प्रतीफल दिये.” ");
INSERT INTO goj_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“अपना लिये जमीन पर धन जमा नी करणु. जेमे कीडा अरु जंग लगस हइ, अरु चोरहोन तोडफोड करी खे चोरी करस हइ. ");
INSERT INTO goj_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","पन अपना लिये स्वर्ग मे धन जमा कर, जेमे कीडा अरु जंग लगस हइ, अरु चोरहोन तोडफोड करीखे चोरी करस हइ. ");
INSERT INTO goj_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","क्योकी तरो धन हइ ओमे तरो मन भी लग्यो ऱ्हेस.” ");
INSERT INTO goj_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“आंग को दिवो आख हइ. येका लिये अगर तरा आख अच्छा हुये ते तरो पुरो आंग भी उजालो हुये; ");
INSERT INTO goj_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","पन अगर तरा आख बुरा हुये तरो पुरो आंग भी अंधारा मे ऱ्हीये. येका कारण उ उजालो जो तरा मे हइ अगर अधारो हुये ते उ अधारो कसो डरवानो हुये.” ");
INSERT INTO goj_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“कोय इन्सान दो स्वामीहोन की सेवा नी करी सकस, क्युकी उ एक से दुजाभाव अरु दुसरा से प्रेम रखस, या एक से नीष्ठावान ऱ्हिये अरु दूसरा को तिरस्कार कर्ये. तुम परमेश्वर अरु धन दोइ की सेवा नी करी सकस.” ");
INSERT INTO goj_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","येका लिये मी तुम से बोलुस हइ, कि अपना जान का लिये यो चिन्ता नी करणु कि हम का खाये अरु का पीये अरु नी अपना आंग का लिये की का पेने का जान खाना से, अरु आंग से कपडा से बडीखे नी? ");
INSERT INTO goj_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","बदल की पक्षिहोन खे देख! वे नी बोलस हइ, वे नी काटस हइ, अरु नी खेत मे जमा हइ. ते भी तुम्हारो स्वर्गीय बाप उनखे खलास हइ, तुम उनसे अधिक महत्व नी रखस? ");
INSERT INTO goj_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","तुम मे कोन हइ, जो चिन्ता करीखे अपना जिवन काल मे एक टेम भी महिमा करी सकस हइ? ");
INSERT INTO goj_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“अरु कपडा का लिये काय बार चिन्ता करस हइ? जंगल का फुल पर ध्यान कर, कि वे कसा बढस हइ, वे नी ते महीनत करस हइ, अरु उनका कपडा बनास हइ. ");
INSERT INTO goj_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","ते भी मी तुम से बोलुस हइ, कि सुलैमान भी, अपना सब महिमा मे ओमे से कोय का जसा कपडा पेन्यो हुयो नी थो. ");
INSERT INTO goj_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","येका लिये जब परमेश्वर मैदान का घास खे, जो आज हइ, अरु कल अंगार मे डाल्यो जाये असो कपडा पेन्यो हइ, ते हे अल्पविश्वासिहोन, तुम खे योका नी पेनास.” ");
INSERT INTO goj_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“येका लिये तुम चिन्ता करी खे यो नी बोलनु, कि हम का खाये या का पीये या का पेन्हे? ");
INSERT INTO goj_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","क्युकी गैरयहूदिहोन सब चिजहोन खे ढुढना मे ऱ्हेस हइ, अरु तुम्हारो स्वर्गीय बाप जानस हइ, की तुमखे या सब चिज होनु. ");
INSERT INTO goj_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","येका लिये पैयले तुम परमेश्वर का राज्य अरु धार्मीकता खे ढुढतो कर ते या सब चिज तुमखे मीली जाये. ");
INSERT INTO goj_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","आखरी कल का लिये चिन्ता नी करणु, क्युकी कल को दिन अपनी चिन्ता खुद करी लेस आज का लिये आज को ही दुख भोत हइ. ");
INSERT INTO goj_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“दोष मत लगानु, जब की तुम पर भी दोष नी लगायो जाये ");
INSERT INTO goj_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","क्युकी जो प्रकार तुम दोष लगास हुये खे उ प्रकार तुम पर भी दोष लगायो जाये. अरु जो माप से तुम मापस हइ, ओका से तुमारा लिये भी नाप्यो जाये.” ");
INSERT INTO goj_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“तु का अपना भैइ का आख खे तिनका देखस हइ, अरु अपना आख कि लाकडी तोखे नी सुझस? ");
INSERT INTO goj_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","जब तरा ही आख मे लाकडी हइ, ते तु अपना भैइ से कसो बोली सकस हइ, ला मी तरा आख से कचरो नीकाली दिउस.” ");
INSERT INTO goj_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","हे पाखण्डी, पैयले अपना आख मे से लाकडी नीकाली ले, तब तु अपना भैइ का आख को कचरो भली भाति देखीखे नीकाली सकस. ");
INSERT INTO goj_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","पवित्र चिज कुत्ताहोन खे नी देनु, अरु अपना किमती चिज डुक्कर का आगे मत डालनु. असो नी हुये की वे उनखे पाय का नीचे दबाये, अरु पलटी खे तुम खे फाडी डाले. ");
INSERT INTO goj_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","माग, ते तुम खे दियो जाये. ढुडे, ते तुम खे मीले. दरवाजो बजा, ते तुम्हारा लिए खोल्यो जाये. ");
INSERT INTO goj_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","क्युकी जो कोय मागस हइ, ओखे मीलस हइ. अरु जो ढुडस हइ, वे लेस हइ. अरु जो दरवजो बजास हइ, ओका लिये खोल्यो जाये. ");
INSERT INTO goj_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“तुम मे से असो कोन सो इन्सान हइ, कि अगर ओको बेटो ओकासे रोटी मागे, ते उ ओखे पत्थर दिये. ");
INSERT INTO goj_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","यो मंछी मागे, ते ओखे साप दिये. ");
INSERT INTO goj_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","जब तुम बुरा हुइ खे, अपना बच्चाहोन खे अच्छो चिज देनु जानस हइ, ते तुम्हरो स्वर्गीय बाप अपना मागनवाला खे अच्छो चिज का नी देस” ");
INSERT INTO goj_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","येका करण जो कुछ तुम चास हइ, की इन्सान तुमारा सात करस, तुम भी उनका सात असो हि करणु. क्योकि मूसा की व्यवस्था, अरु भविष्यव्दक्ता कि शिक्षा यही हइ. ");
INSERT INTO goj_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“छोटा दरवाजो से प्रवेश कर, किक्यु चौडो हइ उ दरवाजो अरु सीधी हइ वा रस्ता जो विनाश का तरप ली जास हइ. अरु भोत सारा दुन्या हइ जो ओकासे आनजानो करस हइ. ");
INSERT INTO goj_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","क्योकि संकेत हइ उ दरवाजो अरु कठिन हइ वा रस्ता जो जिवन खे पहुचास हइ, अरु जरासा दुन्या ओका पास हइ.” ");
INSERT INTO goj_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“झुटा भविष्यव्दक्ताहोन से हुशार ऱ्हे, जो मेढाहोन का भेस मे तुम्हारा पास आस हइ, पन अन्नत मे फाडनआलो लाडग्यो हइ. ");
INSERT INTO goj_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","उनका से तुम उनखे पैच्छानी लेस, काटा की झुडुप से अंगूर, या जंगल झाड से अंजीर तोडस हइ? ");
INSERT INTO goj_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","यो प्रकार हर एक अच्छो झाड अच्छो फल लास हइ अरु नीकम्मो झाड बुरो फल लास हइ. ");
INSERT INTO goj_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","अच्छो झाड बुरो फल नी लय सकस, अरु नी नीकम्मो झाड अच्छो फल लय सकस हइ. ");
INSERT INTO goj_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","जो-जो झाड अच्छो फल नी लास, अरु उ काटस, अरु अंगार मे डाल्यो जास हइ. ");
INSERT INTO goj_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","आखरी उनका काम से तुम झुठो भविष्यव्दक्ताहोन पैच्छानी लेस. ");
INSERT INTO goj_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“जो मरासे, हे ‘प्रभु, हे प्रभु’ बोलस हइ, ओमे से हर एक स्वर्ग का राज्य मे प्रवेश नी करस, पन वा जो मरा स्वर्गीय बाप कि इच्छा पर चलस हइ. ");
INSERT INTO goj_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","न्याय कादिन भोत दुन्या मरासे बोलस ‘हे प्रभु, हे प्रभु, हमने तरा नाम से भविष्यवाणी नी करी, अरु तरा नाम से बुरी आत्माहोन खे नी नीकली, अरु तरा नाम से भोत चमत्कार को काम नी कऱ्यो.’ ");
INSERT INTO goj_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","तब मी उनखे खोली खे बोली दियु, मेने तुम खे कभी नी जान्यो, हे बुरो करणवाला मरा पास से जय जा. ");
INSERT INTO goj_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“येकालिये जो कोय मरी या बात सुनीखे उनखे करस हइ उ ओखे डिमाकआलो इन्सान का जसो बताये जेने अपनो घर पत्थर पर बनायो. ");
INSERT INTO goj_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","अरु पानी आयो, अरु पुर अय अरु हवाधुन हुइ, अरु वु घर पर टाकरा लगया, पन वु घर नी गिऱ्यो, क्युकी ओका पय्या पत्थर पर डाली गइ थी. ");
INSERT INTO goj_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“पन जो कोय मरी या बात खे सुनस हइ अरु उन पर नी चलास वे उ बेडिमाक इन्सान का जसो ऱ्हीहे जेने अपनो घर रेती पर बनायो. ");
INSERT INTO goj_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","अरु पाणी गिर्यो, अरु पुर अय, अरु हवाधुन हुइ, अरु उ घर पर टाकरइ अरु वु गिरीखे सत्यानाश हुये गयो.” ");
INSERT INTO goj_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","जब यीशु या बात बोली दिये, ते असो हुयो की गर्दी ओका उपदेस से चकित हुइ. ");
INSERT INTO goj_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","किक्यु उ उनका पंडीतहोन का जसो नी पन अधिकारी का जसो उनखे उपदेस देतो थो. ");
INSERT INTO goj_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","जब यीशु वा टेकडी से उतर्‍यो, ते एक बडी गर्दी ओका पीछे चलन लग्यी. ");
INSERT INTO goj_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","अरु एक कोढी ने पास अयखे ओखे प्रणाम कऱ्यो अरु बोल्यो, “हे प्रभु, अगर तु चाये ते मेखे अच्छो करी सकस हइ.” ");
INSERT INTO goj_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","यीशु ने हात उटयखे ओखे छुयो, अरु बोल्यो, “मी चैवस हइ, तू अच्छो हुइ जाये” अरु उ झल्दी कोढ से अच्छो हुइ गयो. ");
INSERT INTO goj_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","यीशु ने ओकासे बोल्यो, “देख, कोय से नी बोलनु, पन जयखे अपना आप खे याजक खे देख्यो अरु जो दान चढायो मूसा ने रुख्यो हइ ओखे चेढा, ताकी ओका लिये गवाह हुये.” ");
INSERT INTO goj_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","अरु जब उ कफरनहूम मे आयो ते एक रोमी सेनापति ने ओका पास अयखे ओकासे प्रार्थना करी. ");
INSERT INTO goj_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“हे प्रभु, मरो सेवक घर मे लकवा को मारो भोत दुख पीडा मे हइ.” ");
INSERT INTO goj_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","ओने ओकासे बोल्यो, “मी अयखे ओखे अच्छो कऱ्यु,” ");
INSERT INTO goj_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","सेनापति ने उत्तर दियो, “हे प्रभु, मी यो योग्य नी कि तु मरा घर मे आयो, पर फक्त मुडा से बोली दे ते मरो सेवक अच्छो हुइ जाये.” ");
INSERT INTO goj_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","क्युकी मी भी अधिकार इन्सान हइ, अरु सेवक मरा हात मे हइ, अरु जब एक से बोलस हइ, जा, ते उ जास हइ. अरु दुसरा खे, आ, ते उ आस हइ, अरु अपना दास से बोलस हइ, की यो कर, ते उ करस हइ. ");
INSERT INTO goj_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","यो सुनीखे यीशु ने अचम्बो कऱ्यो, अरु जो ओका पीछे ए रा था उनका से बोल्यो कि “मी तुम से सच्ची बोलुस हइ खे कि मेने इस्राएल मे भी असो विश्वास नी पायो.” ");
INSERT INTO goj_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","अरु मी तुम से बोलुस हइ, कि भोत सारा पूर्व अरु पश्चिम से अयखे अब्राहम अरु इसहाक अरु याकूब का साथ स्वर्ग का राज्य मे बठ. ");
INSERT INTO goj_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","पन राज को वारीस बाहेर अंधारा मे डाली दिया जाये व्हा रोनो अरु दात खे कटरनो हुये. ");
INSERT INTO goj_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","अरु यीशु ने सेनापति से बोल्यो, “जा जसो तरो विश्वास हइ, असो ही तरा लिये हुये.” अरु ओको सेवक उ टेम अच्छो हुइ गयो. ");
INSERT INTO goj_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","अरु यीशु ने पतरस का घर मे अयखे ओकी सासु खे तेज बुखार मे पडी देखी. ");
INSERT INTO goj_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","ओने ओको हात पड्यो अरु ओको बुखार उतरी गयो. अरु वा उठी खे ओकी सेवा करण लगी. ");
INSERT INTO goj_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","जब संज्जा हुइ तब वे ओका पास भोत से दुन्याहोन खे लायो जोमे बुरी आत्मा थी अरु ओने वा आत्माहोन खे अपना वचन से नीकाली दियो, अरु सब बेमारहोन खे अच्छो कऱ्यो. ");
INSERT INTO goj_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","ताकी जो वचन यशायाह भविष्यव्दक्ता का वजेसे बोल्यो गयो थो उ पुरो हुये “ओने खुद हमारी दुर्बलताहोन खे ली लियो अरु हमारी बेमारहोन खे उठय लियो.” ");
INSERT INTO goj_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","यीशु ने अपना चारी तरप एक बडी गर्दी देखी खे नद्दी का वा पार जान की आज्ञा दी. ");
INSERT INTO goj_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","अरु एक पंडीत ने ओका पास अयखे ओकासे बोल्यो, “हे गुरु, तु जहा कही तू जाये वहा मी तरा पीछे-पीछे हुइ लियु.” ");
INSERT INTO goj_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","यीशु ने ओकासे बोल्यो, “लाडग्याहोन को घर अरु बद्दल की पक्षिहोन को बसेरो होस हइ. पन इन्सान का बेटा का लिये माथो धरन की भी जगा नी हइ.” ");
INSERT INTO goj_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","एक अरु सेवक ने ओकासे बोल्यो, “हे प्रभु, मेखे पैयले जान दे, की अपना बाप खे गाडी दियु.” ");
INSERT INTO goj_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","यीशु ने ओकासे बोल्यो, “तु मरा पीछे हुइ ले. अरु मुर्दा खे अपना मुर्दाहोन खे गाडन दे.” ");
INSERT INTO goj_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","जब उ डोंगा पर चेढ्यो, ते ओका सेवक ओका पीछे हुइ लिया. ");
INSERT INTO goj_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","“अरु नदी मे एक असो बडो तुफान उठ्यो की डोंगा पानी की लहर से ढुबन लगी. अरु उ सोय रो थो. ");
INSERT INTO goj_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","तब उनने ओका पास अयखे ओखे जगायो, अरु बोल्यो, हे प्रभु, हमखे बचा, हम खतम हुय रास हइ.” ");
INSERT INTO goj_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","ओने उनका से बोल्यो, “हे अल्पविश्वासिहोन, क्यु डरस हइ?” तब ओने उठीखे हवा अरु पानी खे धमकायो, अरु सब शान्त हुइ गयो. ");
INSERT INTO goj_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","अरु दुनीया खे अचम्बो करीखे बोलन लग्यो, “यो कसो इन्सान हइ, कि हवा अरु पानी भी ओकि आज्ञा मानस हइ.” ");
INSERT INTO goj_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","जब उ वा पार गदरेनीयो का देश मे पोच्यो, ते दो इन्सान जोमे बुरी आत्मा थी कब्र से नीकलते हुये ओखे मीली, जो येतना बलवान था कि कोय वा रस्ता से जय नी सकस हइ. ");
INSERT INTO goj_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","अरु, उनने चिल्लय खे बोल्यो, “हे परमेश्वर का बेटा, हमारो तरा से काम का तु टेम से पैयले हमखे दुख देन ह्या आयो हइ.” ");
INSERT INTO goj_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","उनसे कुछ दुर भोत सा डुक्कर को एक झुड चरी रो थो. ");
INSERT INTO goj_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","बुरी आत्माहोन ने ओकासे बोलीखे प्रार्थना करी, “अगर तु हमखे नीकलस हइ अरु डुक्कर का झुण्ड मे भेजी देस” ");
INSERT INTO goj_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","ओने उनका से बोल्यो, “जा!” अरु उ नीकली खे डुक्कर मे घुसी गया अरु पुरो झुण्ड धुरा पर से झपटिखे पानी मे जय पड्यो अरु डुबी खे मऱ्यो. ");
INSERT INTO goj_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","अरु चरानआला भागीगा, अरु गाव मे जयखे या सब बात अरु जोमे बुरी आत्मा थी. उनको पुरो हाल सुनायो. ");
INSERT INTO goj_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","अरु सब गाव का दुन्या यीशु से मीलन खे नीकली आया अरु ओखे देखीखे प्रार्थना करी की हमारो देश से बाहेर नीकली जा. ");
INSERT INTO goj_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","फिर यीशु डोंगा पर चेडी खे वा पार गयो, अरु अपना गाव मे आयो. ");
INSERT INTO goj_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","अरु देख, कोइ दुन्या एक लकवा को माऱ्यो हुया खे खटीया पर रखी खे ओका पास लायो. यीशु ने ओको विश्वास देखी खे, उ लकवे को माऱ्यो हुयो से बोल्यो, “हे बेटा, हिम्मत रख. तरो पाप माफ हुये गया.” ");
INSERT INTO goj_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","अरु कोय पंडीतहोन आपस मे बोलन लग्या, “यो तो परमेश्वर की नीन्दा करस हइ.” ");
INSERT INTO goj_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","यीशु ने उनका मन कि बात जानीखे बोल्यो, “तुम दुन्या अपना-अपना मन मे बुरो बिचार करी रास हइ? ");
INSERT INTO goj_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","सिधो का हइ? यो बोलनो, ‘तरा पाप माफ हुया’ या यो बोलनो, ‘उट अरु चल फिर.’ ");
INSERT INTO goj_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","पन तुम यो जानी ले की इन्सान का बेटा खे पृथ्वी पर पाप माफ करण को अधिकार हइ.” येका लिये ओने लखवा को माऱ्यो हुयो से बोल्यो, “उट, अपनी खटीया उठा, अरु अपना घर जय जा.” ");
INSERT INTO goj_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","उ उठीखे अपना घर चली गयो. ");
INSERT INTO goj_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","दुन्या यो देखीखे डरी गया अरु परमेश्वर कि महिमा करण लग्या जेने इन्सानहोन खे असो अधिकार दियो हइ. ");
INSERT INTO goj_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","वा से आगे बडीखे यीशु ने मत्ती नाम को एक इन्सान खे चुंगी की चौकी पर बठ्यो देख्यो, अरु ओकासे बोल्यो, “मरा पीछे हुइ लियो.” उ उठीखे ओका पीछे हुइ लियो. ");
INSERT INTO goj_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","अरु जब उ मत्ती का घर मे खानो खान का लिये बठ्यो ते भोत जन चुंगी लेनआला अरु पापी अयखे यीशु अरु ओका सेवक का साथ खान बठ्या. ");
INSERT INTO goj_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","यो देखीखे फरीसीहोन ने ओका सेवक से बोल्यो, “तुम्हारो गुरु चुंगी लेनवाला अरु पापीहोन का साथ का खास हइ?” ");
INSERT INTO goj_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","यो सुनीखे यीशु ने ओकासे बोल्यो, “डाक्टर अच्छा भला खे नी पन बेमारहोन का लिये आकुल्यक हइ. ");
INSERT INTO goj_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","येका लिये तुम जयखे येको अर्थ सीखी ले, कि मी जनवर को बलिदान नी पन दया चाउस हइ. क्योकी मी धर्मीहोन खे नी पन पापीहोन खे बुलान आयो हइ.” ");
INSERT INTO goj_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","तब यहून्ना को सेवक ने ओका पास अयखे बोल्यो, “का कारण हइ कि हम अरु फरीसी येतना उपास करस हइ, पर तरा सेवक उपास नी करस?” ");
INSERT INTO goj_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","यीशु ने ओकासे बोल्यो “बरात जब तक दुलो उनका साथ हइ, दुख करी सकस हइ? पर वे दिन आस कि दुलो उनसे अलग, कऱ्यो जास, उ टेम वे उपास कर्‍हे. ");
INSERT INTO goj_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“नवा कपडा को थेगडो पुराना कपडा पर कोइ नी लगास, क्युकी उ जोड्यो कपडा से अरु कुछ खीची लेस हइ, अरु उ जादा फटी जास हइ. ");
INSERT INTO goj_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","अरु दुन्या नवो अंगूर को रस पुराना चामडा का झोरा मे नी भरस हइ. क्युकी असो करणा से चामडा को झोरो फुटी जास हइ, अरु अंगूर को रस बोह्य जास हइ, अरु चामडा को झोरो खतम हुइ जास हइ, पन नवो अंगूर को रस नवा चामडा का झोरा मे भरस हइ, अरु उ दो बच्यो ऱ्हेस हइ.” ");
INSERT INTO goj_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","उ ओकासे या बात बोली ही रो थो, कि देख, एक मुखियो ने अयखे ओखे प्रणाम कऱ्यो अरु बोल्यो, “मरी बेटी अभी मरी हइ. पन चडीखे अपनो हात ओका पर रख, ते वा जिन्दी हुइ जाये.” ");
INSERT INTO goj_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","यीशु उठीखे अपना सेवक का सात ओका पीछे हुइ लिया. ");
INSERT INTO goj_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","अरु देख, एक बय ने जेखे बारा साल से खुन बोहायो थो ओका पीछे से अयखे ओका कपडा को कोना खे पकडी लियो. ");
INSERT INTO goj_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","क्युकी उ अपना मन मे बोलतो थो, “अगर मी ओका कपडा खे पकडी लिह्यु ते अच्छी हुइ जायु.” ");
INSERT INTO goj_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","यीशु ने पलटी खे ओखे देख्यो अरु बोल्यो, “बेटी हिम्मत रख. तरा विश्वास ने तोखे अच्छो कऱ्यो हइ.” फिर वा बय उ टेम मे अच्छी हुइ गइ. ");
INSERT INTO goj_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","जब यीशु उ मुखिया का घर मे पोच्यो अरु बासरी बजानवाला अरु गर्दी मे हल्लो मचाते देख्यो, ");
INSERT INTO goj_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","तब यीशु ने बोल्यो, “हटी जा, पोरय मरी नी, पर सोय हइ.” येका पर वे ओकी हसी करण लग्या. ");
INSERT INTO goj_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","पन जब गर्दी नीकाली दी गइ, ते ओने अंदर जयखे पोरय को हात पकडीखे उठायो, अरु वा खडी हुइ गइ. ");
INSERT INTO goj_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","अरु या बात की चर्चा पुरा देस मे फैली गय. ");
INSERT INTO goj_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","जब यीशु व्हा से आगे बढ्यो, ते दो अंधा ओका पीछे यो बुलाते हुइ चल्यो, “हे दाउद को बेटा, हम पर दया कर.” ");
INSERT INTO goj_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","जब उ घर मे पोच्यो, ते वे अंधा ओका पास आया, अरु यीशु ने ओकासे बोल्यो “तुमखे विश्वास हइ, की मी तुमखे अच्छो करी सकुस हइ?” ओने ओकासे बोल्यो, “हव प्रभु.” ");
INSERT INTO goj_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","तब यीशु ने ओकी आख पकडिखे बोल्यो, “तुम्हारो विश्वास का जसो तुम्हारा लिये हुइ.” ");
INSERT INTO goj_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","अरु ओका आख खुली गया अरु यीशु ने उनखे आदेस का साथ हुशार कऱ्यो अरु बोल्यो, “हुशार, कोय या बात खे नी जानस.” ");
INSERT INTO goj_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","पर ओने नीकली खे सब देस मे ओको समाचार फैल्य दियो. ");
INSERT INTO goj_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","जब वे बाहेर जय रा था, तब दुन्या एक गूगा खे जोमे बुरीआत्मा थी ओका पास लायो. ");
INSERT INTO goj_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","अरु जब बुरी आत्माहोन नीकाली दी गय, ते गूगो बोलन लग्यो. अरु गर्दी ने अचम्बो करीखे बोल्यो, “इस्राएल मे असो कभी नी देख्यो गयो.” ");
INSERT INTO goj_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","पन फरीसीहोन ने बोल्यो, “यो तो बुरी आत्माहोन का मुखिया की सहायता से बुरी आत्माहोन खे नीकालस हइ.” ");
INSERT INTO goj_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","अरु यीशु सब नगर अरु गाव मे फिरस ऱ्हेस अरु ओका आराधनालय मे उपदेस करस, अरु राज्य को सुसमाचार प्रचार करस, अरु हर प्रकार की बेमारी अरु दुर्बलता खे अच्छो करतो थो. ");
INSERT INTO goj_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","जब ओने गर्दी खे देख्यो ते ओखे दुन्या पर दया अय, क्युकी वे उ मेडा का जसो जेको कोय ठाट्यो नी हइ, व्याकुल अरु भटक्या हुया खे जसो थो. ");
INSERT INTO goj_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","तब यीशु ने अपना सेवक से बोल्यो, “पीक तो भोत हइ पर मजुर जरासा हइ. ");
INSERT INTO goj_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","येका लिये खेत का स्वामी से प्रार्थना कर कि उ अपना खेत मे काम करण का लिये मजुर भेजी दे.” ");
INSERT INTO goj_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","फिर ओने अपना बारा सेवक खे पास बुलय खे, ओने बुरी आत्माहोन पर अधिकार दियो, की उनखे नीकाल अरु सब प्रकार की बेमारीहोन अरु सब प्रकार की दुर्बलताहोन खे दुर कर. ");
INSERT INTO goj_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","ये बारा प्रेरितहोन को नाम यो हइ पयलो शमौन, जो पतरस बोलस हइ, अरु ओको भैइ अन्द्रियास. जब्दी को बेटो याकूब, अरु ओको भैइ यहून्ना. ");
INSERT INTO goj_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","फिलिप्पुस अरु बरतुल्मै, थोमा, अरु चुंगी लेनआलो मत्ती, हलफइस को बेटो याकूब अरु तद्दै. ");
INSERT INTO goj_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","शमौन कनानी, अरु यहूदा इस्करियोती, जेने ओखे पकडायो. ");
INSERT INTO goj_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","ये बाराहोन खे यीशु ने यो आदेस दिखे भेज्यो, “गैरयहूदीहोन का तरप नी जानु, अरु सामरीहोन का कोय नगर मे प्रवेश नी करणु. ");
INSERT INTO goj_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","पन इस्राएल का घरानो की ही गम्या हुया मेडा का पास जानु.” ");
INSERT INTO goj_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","अरु चलते-चलते प्रचार करीखे बोल्यो की स्वर्ग को राज्य बाहेर अय गो हइ. ");
INSERT INTO goj_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","बेमार होन खे अच्छो कर मर्या हुया खे जिन्दो कर, कोढी रोगी खे अच्छो कर, बुरी आत्माहोन खे नीकाल. तुम ने फुकट-मुकट पायो हइ, फुकट-मुकट दे. ");
INSERT INTO goj_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","अपना खीसा मे नी सोन्नो, अरु नी चादी, अरु नी तांबा का पैसा रखनु. ");
INSERT INTO goj_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","रस्ता का लिये नी थैली रखनु, नी कुर्ता को दुसरो जोड, नी जुता अरु नी लकडी ले, क्युकी मजुर खे ओको अधिकार मीलनो चाह्ये. ");
INSERT INTO goj_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","जो कोय नगर या गाव मे जाये ते पतो लगा की व्हा कोन अच्छो हइ? अरु जब तक व्हा से नी नीकले, ओका घर मे ऱ्हेनु. ");
INSERT INTO goj_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","अरु घर मे घुसता टेम मे ओखे आशिष देनु. ");
INSERT INTO goj_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","अगर वे घर का दुन्या अच्छा हुये ते तुम्हारी शांती उन पर पोचे पन अगर वे अच्छा नी हुये ते तुम्हारी शांती तुम्हारास पास वापस आह्ये. ");
INSERT INTO goj_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","अरु जो कोय तुमखे अपनानो नी कर्‍हे, अरु तुम्हारी बात नी सुने, उ घर या नगर से नीकलते हुये अपना पाय को धुलो झाडि डाले. ");
INSERT INTO goj_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","मी तुम से सच्ची बोलुस हइ, की न्याय का दिन उ नगर की दशा से सदोम अरु गमोरा का नगर की दशा जादा सहन्यो योग्य हुये. ");
INSERT INTO goj_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“देख, मी तुमखे लाडगा का जसो मेढाहोन का बीच मे भेजुस हइ येकालिये साप का जसो चेतावनी अरु कबूतर का जसो भोलो ऱ्हे. ");
INSERT INTO goj_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","पन दुन्याहोन से बच्या ऱ्हे, क्युकी वे तुमखे आराधनालयहोन मे दिये, अरु अपना पंचायत मे तुमखे कोडा मारे.” ");
INSERT INTO goj_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","तुम मरा लिये अधिकारीहोन अरु राजाहोन का सामने उन पर, अरु गैरयहूदीहोन पर गवाह होन का लिये पोचायो जाये. ");
INSERT INTO goj_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","जब वे तुमखे पकडे ते या चिन्ता नी करणु, कि हम कोय रीति से का बोले. क्युकी जो कुछ तुम खे बोलनो हुये, उ टेम तुमखे बतायो दियो जाये. ");
INSERT INTO goj_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","क्युकी बोलनवाला तुम नी हुये पन तुम्हारा बाप की आत्मा तुम्हारा वजेसे बोलस हइ. ");
INSERT INTO goj_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“भैइ अपना भैइ खे अरु बाप अपना बेटा खे, मरन का लिये सोपी दिये, अरु बच्चा अपना माय-बाप का खिलाब मे उठीखे उनखे मारी डाले. ");
INSERT INTO goj_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","मरा नाम का कारण सब दुन्या तुम से दुजाभाव कर्‍हे, पर जो अन्नत तक धीरज धरे ओको उध्दार हुये.” ");
INSERT INTO goj_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","जब वे तुमखे एक नगर मे सताये, ते दुसरा खे भागी जानु. मी तुम से सच्ची बोलुस हइ, इन्सान को बेटो आना तक तुम इस्राएल का सब नगर मे काम खतम नी करी सखे ");
INSERT INTO goj_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“सेवक अपना गुरु से बडो नी होस. अरु नी सेवक अपना स्वामी से. ");
INSERT INTO goj_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","सेवक को गुरु का, अरु सेवक को स्वामी का, बरोबर होना मे भोत हइ. जब ओने घर का स्वामी खे सैतान बोल्यो ते ओका घरआला खे कुछ नी बोले.” ");
INSERT INTO goj_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“येकालिये इन्सान से मत डरनु क्योकी कुछ झाख्यो नी, जो खोल्यो नी जास. अरु नी कुछ छिप्यो हइ, जो जान्यो नी जास. ");
INSERT INTO goj_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","जो मी तुम से अंधारा मे बोलुस हइ, ओखे उजाला मे बोल. अरु जो कानहोन से कान सुनस हइ, छपर पर से प्रचार कर. ");
INSERT INTO goj_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","जो आंग खे मारी सकस हइ, पर आत्मा खे अरु मन खे मारी नी सकस, ओकासे मत डरनु. पर परमेश्वर से डर, जो आत्मा अरु आंग दोय खे नरक मे नास करी सकस हइ. ");
INSERT INTO goj_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","का पैसा मे दो चिडी नी बिकस? फिर भी तुम्हारो बाप की इच्छा का बिना ओमे से एक भी जमीन पर नी गिरी सकस. ");
INSERT INTO goj_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","तुम्हारा माथा का बाल भी सब गिन्या हुया हइ. ");
INSERT INTO goj_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","येकालिये डरनु नी. तुम बहोत से चिडीहोन से महत्वपुर्ण हइ ");
INSERT INTO goj_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“जो कोय इन्सान का सामने मेखे मानी लिये, ओखे मी भी अपना स्वर्गीय बाप का सामने मानी लियु. ");
INSERT INTO goj_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","पर जो कोय इन्सानहोन का सामने मेखे इन्कार कर्‍हे ओखे मी भी अपना स्वर्गीय बाप का सामने इन्कार कऱ्यु. ");
INSERT INTO goj_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“यो नी समझनु, की मी पृथ्वी पर मीलनो झुलनो करण खे आयो हइ, मी मीलनो झुलनो करण खे नी, पर तलवार चलान आयो हइ. ");
INSERT INTO goj_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","मी तो आयो हइ, कि बेटा खे ओका बाप से, अरु बेटी खे ओकी माय से, अरु बहू खे ओकी सासु से अलग करी दुयु.” ");
INSERT INTO goj_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","इन्सान का दुसमन ओका घर का ही दुन्या हुये. ");
INSERT INTO goj_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","जो माय या बाप खे मरासे जादा प्रेम करस हइ, उ मरो अच्छो नी अरु जो बेटो या बेटी खे मरा से जादा प्रिय जानस हइ, उ मरो अच्छो नी. ");
INSERT INTO goj_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","अरु जो अपनो क्रुस लिखे मरा पीछी नी चले उ मरा योग्य नी. ");
INSERT INTO goj_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","जो अपनो जान बचास हइ, उ ओखे गमास. अरु जो मरा कारण अपनो जान गमास उ ओखे पास. ");
INSERT INTO goj_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","जो तुमखे स्वीकार करस हइ, उ मेखे ग्रहन करस हइ. अरु जो मेखे ग्रहन करस हइ, उ मरा भेजनवाला खे स्वीकार करस हइ. ");
INSERT INTO goj_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","जो कोय भविष्यव्दक्ता खे भविष्यव्दक्ता जानीखे स्वीकार कर, उ भविष्यव्दक्ता को इनाम मील्हे कर्‍हे. अरु जो धर्मी जानीखे धर्मी खे स्वीकार करस, उ धर्मी खे बदलो पास. ");
INSERT INTO goj_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","“जो कोय इन छोटा मे से एक खे सेवक जानीखे फक्त एक कटोरो थंण्डो पानी पीये, मी तुम से सच्ची बोलुस हइ, उ अपनो इनाम कभी नी पाये.” ");
INSERT INTO goj_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","जब यीशु अपना बारा सेवक खे शिक्षा दी रो थो, ते उ उनका गावहोन मे उपदेस अरु सुसमाचार करण खे व्हा से चली गयो. ");
INSERT INTO goj_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","यहून्ना ने बन्दिघर मे मसीह का काम को सुसमाचार सुनीखे अपना सेवक खे ओका पास भेज्यो. ");
INSERT INTO goj_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“आनवालो तु ही हइ, या हम दुसरा कि रस्ता देखे?” ");
INSERT INTO goj_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","यीशु ने उत्तर दियो, “जो कुछ तुम सुनस हइ अरु देखस हइ, उ सब जयखे यहून्ना से बतय दे. ");
INSERT INTO goj_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","की अंधो देखस हइ अरु लंगडो चलस फिरस हइ, कोढी अच्छा करी जास हइ अरु बाहेर सुनस हइ, मुर्दा होन जिन्दो होस, अरु गरीब होन खे सुसमाचार सुनायो जास हइ. ");
INSERT INTO goj_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","अरु अच्छो हइ उ, जो मरा कारन ठोकर नी खाये.” ");
INSERT INTO goj_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","जब वे व्हा से चली गया, ते यीशु यहून्ना को बारे मे दुन्याहोन सेबोलन लग्यो, “तुम जंगल मे मेखे देखन गया था? हवा से हालते हुये सरकण्डा खे? ");
INSERT INTO goj_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","फिर तुम, देखन गया था? जो अच्छा कपडा पेन्या हुया, या राजभवन मे ऱ्हेस हइ. ");
INSERT INTO goj_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","ते फिर क्यु गया था? कोय भविष्यव्दक्ता खे तुम देखन गया था? हव, मी तुम से बोलुस हइ, जब भविष्यव्दक्ता से भी बडि हइ. ");
INSERT INTO goj_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","यो उ हइ जेका विषय मे लिख्यो हइ की तुम देख, मी अपना स्वर्गदूत खे तरा आगे भेजुस हइ जो तरा आगे तरी रस्ता खे तैयार करस. ");
INSERT INTO goj_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","मी तुम से सच्ची बोलुस हइ, की जो बयहोन से जन्मो हइ, ओमे से यहून्ना बपतिस्मा देनआला से कोय बडो नी हुयो. पर जो स्वर्ग का राज्य मे ऱ्हेस वे छोटा से छोटा हइ उ ओकासे बडो हइ. ");
INSERT INTO goj_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","यहून्ना बपतिस्मा देनआला का दिनहोन से अभी तक स्वर्ग का राज्य मे बलपूर्वक अय रोस हइ, अरु बलवान ओखे छुडय रोस हइ. ");
INSERT INTO goj_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","यहून्ना तक सब भविष्यव्दक्ता अरु मूसा की व्यवस्था भविष्यवाणी करस ऱ्हेस. ");
INSERT INTO goj_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","अरु चाहा ते मानीले, एलिय्याह जो आनवालो थो उ यो हइ. ");
INSERT INTO goj_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","जेका कान हइ उ सुनी ले. ");
INSERT INTO goj_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“मी या टेम मे ये दुन्याहोन की तुलना को का से करु? वे बच्चान का जसा हइ, जो बजार मे बठ्या हुया एक दुसरा से बुलयखे खे बोलस हइ. ");
INSERT INTO goj_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","हमने तुम्हारा लिये बासरी बजय, अरु तुम नी नाचे. हमने दुख कऱ्यो, अरु तुम ने अपनी छाती नी पिटि . ");
INSERT INTO goj_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","क्युकी यहून्ना नी खाते आयो अरु नी पीते आयो, अरु वे दुन्या बोलस हइ की ओमे बुरीआत्मा हइ. ");
INSERT INTO goj_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","इन्सान को बेटो खातो-पीतो आयो, अरु दुन्याहोन बोलस हइ की देख, यो पेटू अरु पियक्कड इन्सान हइ उ चुंगी लेनवालो अरु पापीहोन को दोस्त! पर परमेश्वर को ज्ञान अपना कामहोन मे से सच्चो ठहरो गयो हइ.” ");
INSERT INTO goj_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","तब वे उ गाव मे दोष देन लग्या, जेने ओने भोत अच्छा सामर्थ्य काम कऱ्या था. क्युकी ओने अपनो मन नी फिरायो थो. ");
INSERT INTO goj_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“हाय, खुराजीन! हाय. बैतसैदा! जो सामर्थ काम तुम मे कऱ्यो गयो, अगर वे सूर अरु सैदा मे कऱ्यो जास, ते ठाटी होडीखे खे राख मे बठी, खे वे अपना पाप से मन फिरास हइ ");
INSERT INTO goj_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","पन मी तुम से बोलुस हइ. कि न्याय का दिन मे तुम्हारी दशा से सूर अरु सैदा की दशा अधिक सहन योग्य हुये. ");
INSERT INTO goj_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","अरु हे कफरनहूम, तु स्वर्ग तक उपर कऱ्यो जास? तु तो दुन्याहोन तक नीचे जाये. जो सामर्थ काम तरा मे कऱ्ये गयो हइ, अगर सदोम मे कऱ्यो जास, ते उ आज तक बन्यो ऱ्हेस. ");
INSERT INTO goj_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","पर मी तरा से बोलुस हइ, कि न्याय का दिन तरा देस से सदोम कि दशा अधिक सहन योग्य हुये.” ");
INSERT INTO goj_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","उ टेम यीशु ने बोल्यो, “हे बाप, स्वर्ग अरु पृथ्वी का प्रभु, मी तरो धन्यवाद करुस हइ, की तोने या बात खे ज्ञानीहोन अरु पढ्या लिख्या दुन्या से लुकय खे रखी, अरु बच्चाहोन पर प्रगट कऱ्यो हइ. ");
INSERT INTO goj_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","हव, हे बाप, क्युकी तोखे यो अच्छो लग्यो.” ");
INSERT INTO goj_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“मरा बाप ने मेखे सब कुछ सोपी दियो हइ, अरु कोय बेटा खे नी जानस, फक्त बाप. अरु कोय बाप खे नी जानस, फक्त बेटो अरु उ जेको बेटा खे ओका पर प्रगट करणू चास. ");
INSERT INTO goj_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“हे सब मेहनत करणवालो अरु बोज से दब्या हुया दुन्याहोन, मरा पास आ. मी तुमखे आराम दियु. ");
INSERT INTO goj_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","मरो जुवाडो अपना उपर उठ्य ले. अरु मरासे सीख. क्युकी मी दीन अरु मन से नम्र हइ; अरु तुम अपना मन मे आराम पाये. ");
INSERT INTO goj_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","क्युकी मरो जुवाडो सीदो हुयगो अरु मरो बोजो हलको हुयगो.” ");
INSERT INTO goj_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","उ टेम यीशु आराम का दिन खेत मे से हुइ खे जय रा था, अरु ओका सेवक होन खे भुख लगी थी, अरु वे बाले तोडी-तोडी खे खान लग्या. ");
INSERT INTO goj_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","फरीसीहोन ने यो देखीखे ओकासे बोल्यो की, “देख, तरा सेवक यो काम अच्छो नी कर रास हइ, जो आराम को दिन करणो अच्छो नी हइ.” ");
INSERT INTO goj_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","ओखे बोल्यो “ का तुम ने नी पढ्यो, कि दाउद ने जब उ अरु ओका साथी भूखा हुये ते का कऱ्यो? ");
INSERT INTO goj_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","उ कसो परमेश्वर का घर मे गयो अरु दान की रोटि खुद जेखे खइ नी ते उ अरु नी ओका साथीहोन का पर फक्त याजकहोन खे अच्छो थो? ");
INSERT INTO goj_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","यो का तुम ने मूसा की व्यवस्था मे नी पढ्यो की याजक आराम का दिन मन्‍दिर मे आराम का दिन कि विधी खे तोडीखे पर भी नीर्दोश ठहरस हइ? ");
INSERT INTO goj_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","पर मी तुम से बोलुस हइ कि यो उ हइ, जो मन्‍दिर से भी महान हइ. ");
INSERT INTO goj_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","अगर तुम येको अर्थ जानस की मी दया से सतुष्ट होस हइ, बलिदान से नी, ते तुम नीर्दोश खे दोषी नी ठहरानु. ");
INSERT INTO goj_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","इन्सान को बेटो तो आराम का दिन को भी प्रभु हइ.” ");
INSERT INTO goj_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","व्हा से चलीखे यीशु यहूदीया का आराधनालय मे आयो. ");
INSERT INTO goj_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","व्हा एक इन्सान जो लकवा को थो, जेको हात सुखो हुयो थो. अरु फरीसीहोन ने ओका पर दोष लगान का लिये ओकासे पुछ्यो, “की तु आराम का दिन अच्छो करणु उचित हइ?” ");
INSERT INTO goj_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","ओने उनका से बोल्यो का “तुम मे असो कोन तो इन्सान हइ, जेको एक मेंडो हइ अरु उ आराम का दिन गड्डा मे गिरी जाये ते उ ओखे पकडीखे नी नीकाले? ");
INSERT INTO goj_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","अच्छो, इन्सान को एक मेंडो मे से कतनो बढी खे हइ! येका लिये आराम का दिन भलो करणु अच्छो हइ.” ");
INSERT INTO goj_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","तब ओने उ लखवा इन्सान से बोल्यो, “अपनो हात दे.” ओने हात बडायो अरु उ फिर अपना दुसरो हात का जसो अच्छो हुइ गयो. ");
INSERT INTO goj_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","तब फरीसी ने ओखे बाहेर जयखे ओका विरोध मे बिचार करीखे ओखे कोय रिती से मारी डाले? ");
INSERT INTO goj_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","यो जानीखे यीशु व्हा से चली गयो. अरु भोत दुन्या ओका पीछे चली गया, अरु ओने सब खे बेमारी से अच्छो करी दियो. ");
INSERT INTO goj_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","अरु ओने आज्ञा दी, कि मेखे प्रगट मत करणु. ");
INSERT INTO goj_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","कि जो वचन यशायाह भविष्यव्दक्ता का वजेसे बोल्यो गयो थो, उ पुरो हुये ");
INSERT INTO goj_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“देख, यो मरो सेवक हइ, जेखे मेने चुन्यो हइ. मरो लाडको जेकासे मरो मन सतुष्ट हइ मी अपनी आत्मा ओका पर डाल्यु. अरु उ गैरयहूदीहोन को न्याय को समाचार दियु. ");
INSERT INTO goj_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","उ नी झगडो कर्‍हे, अरु नी धुम मचाये. अरु नी बजार मे कोय ओको शब्द जोर से सुनाये. ");
INSERT INTO goj_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","उ कुचल्यो हुयो सरकण्‍डे खे नी तोडे. अरु धुवा देस हुये बत्ती नी बुझाये जब तक न्याय को प्रबल नी कर्‍हे. ");
INSERT INTO goj_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","अरु गैरयहूदिहोन सब राष्ट्र ओका नाम पर आस रखस.” ");
INSERT INTO goj_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","तब दुन्या एक अंन्धो-मुको इन्सान खे जोमे बुरीआत्मा थी, ओका पास ओखे लायो. अरु ओने ओखे अच्छो कऱ्यो. अरु उ मुको इन्सान बोलन अरु देखन लग्यो. ");
INSERT INTO goj_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","येका पर सब दुन्या चकीत हुइखे बोलन लग्या, “यो का दाउद को बेटो हइ?” ");
INSERT INTO goj_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","पन फरीसीहोन ने यो सुनीखे बोल्यो, “यो तो बुरीआत्माहोन को मुखियो सैतान का सहायता का बिन बुरीआत्माहोन खे नी नीकालस.” ");
INSERT INTO goj_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","ओने उनका मन की बात जानीखे उनसे बोल्यो, “जो कोय राज्य मे अलग होस हइ, उ उजडी जास हइ अरु कोय गाव या घराना मे जोमे अलग होस हइ, बन्यो नी ऱ्हेस.” ");
INSERT INTO goj_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","अरु अगर सैतान खे निकाल्ये, ते उ अपनो ही दुशम्न हुये गयो हुये. फिर ओको राज्य कसो बन्यो ऱ्हेस? ");
INSERT INTO goj_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","अच्छो अगर मी सैतान की सहायता से ओमे बुरीआत्मा खे नीकलुस हइ, ते तुम्हारो कुल कोय की सहायता से नीकालस हइ? येका लिये वे ही तुम्हारो न्याय करस हइ. ");
INSERT INTO goj_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","पन अगर मी परमेश्वर कि आत्मा कि सहायता से बुरीआत्मा खे नीकालुस हइ, ते परमेश्वर को राज्य तुम्हारा पास ए पोच्यो हइ. ");
INSERT INTO goj_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","या कसो कोय इन्सान कोय बलवन्त का घर मे घुसीखे ओका पुरा घर को माल लुटी सकस हइ जब तक कि पैयले उ बलवन्त इन्सान खे बांधी नी ले? अरु तब तक उ ओका घर मे घुसीखे माल चोरी नी सकस. ");
INSERT INTO goj_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","जो इन्सान मरा सात नी, उ मरो विरोध मे हइ. अरु जो इन्सान मरा साथ जमा नी करस, उ फैली जास हइ. ");
INSERT INTO goj_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","येका लिये मी तुम से बोलुस हइ, की इन्सान का सब प्रकार को पाप अरु ओकी नीन्दा माफी करी जास, पर पवित्र आत्मा की नीन्दा करस हइ ओखे माफी नी कऱ्यो जास ");
INSERT INTO goj_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","जो कोय यो इन्सान को बेटा का विरोध मे कोय बात बोले, ओको यो बुरो माफी कऱ्यो जाये पन जो कोय या पवित्र आत्मा का विरोध मे कुछ बोले नी ते यो दुन्या मे या परलोक मे माफी कऱ्यो जाये. ");
INSERT INTO goj_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","अगर झाड खे अच्छो बोलस, ते ओका फल खे भी अच्छो बोल, ते झाड खे नीकम्मो बोले, ते ओका फल खे भी नीकम्मो बोल. क्युकी झाड अपना फल से ही पहचानो जास हइ. ");
INSERT INTO goj_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","हे साप का बच्चा होन, तुम बुरो हुइखे कसी अच्छी बात बोली सकस हइ? क्युकी जो मन मे भऱ्यो हइ, उ मुडा पर आस हइ. ");
INSERT INTO goj_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","अच्छो इन्सान मन का भला खेत से भली बात नीकलस हइ; अरु बुरो इन्सान का मन मे बुरा भण्‍डार से बुरी बात नीकलस हइ. ");
INSERT INTO goj_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“अरु मी तुम से बोलुस हइ, कि जो-जो इन्सान नीकम्मी बात बोलस, न्याय का दिन हर एक बात की लेखी दिये. ");
INSERT INTO goj_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","क्युकी तू अपनी बातकरण नीर्दोष अरु अपनी बातकरण दोषी ठहरायो जास.” ");
INSERT INTO goj_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","येका पर कुछ शास्त्रिहोन अरु फरीसीहोन ने ओकासे बोल्यो, “हे गुरु, हम तरा से एक बडो चिन्ह देखनो चास हइ.” ");
INSERT INTO goj_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","ओने उनखे उत्तर दियो, “येका जमाना खे बुरो अरु व्यभिचार दुन्या बडो चिन्ह ढुढस हइ. पन योना भविष्यव्दक्ता का चिन्ह खे छोडी कोय अरु चिन्ह उनखे नी दियो जास.” ");
INSERT INTO goj_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","योना तीन रात-दीन बडी मच्छी का पेट मे ऱ्हियो, असो इन्सान को बेटो तीन रात-दिन पृथ्वी का अंदर ऱ्हेस. ");
INSERT INTO goj_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","नीनवे का दुन्या न्याय का दिन यो जमाना का दुन्या का साथ उठीखे उनखे दोषी ठहरास, क्युकी ओने योना को प्रचार सुनीखे, मन फिरावो अरु यो उ हइ जो योना से भी बडो हइ. ");
INSERT INTO goj_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","दक्षिन की रानी न्याय को दिन येका जमाना का दुन्या का साथ उठीखे उनखे दोषी ठहरास, क्युकी उ सुलैमान को ज्ञान सुनन का लिये पृथ्वी का छोर से अयखे , अरु यो उ हइ जो सुलैमान से भी बडो हइ. ");
INSERT INTO goj_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","जब बुरी आत्मा इन्सान मे से नीकली जास हइ ते वा बुरी आत्मा सुखी जगा मे आराम ढुढती फिरस हइ अरु नी मीले . ");
INSERT INTO goj_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","तब बोलस हइ, की मी अपना उ घर मे झा से मी नीकली थी, वापस जाह्य, अरु अयखे उ सुन्यो झाड बुहारा अरु सजा-सजायो पास हइ. ");
INSERT INTO goj_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","“तब उ जयखे अपना से अरु बुरी सात आत्माहोन खे अपना साथ ली आस हइ, अरु वे ओमे बठीखे व्हा वास करस हइ, अरु उ इन्सान की पिछे कि दशा पैयले से भी बुरी हुय जास हइ. येका जमाना का बुरा दुन्या की दशा भी असी ही हुये.” ");
INSERT INTO goj_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","जब उ गर्दी से बात करी ही रहो थो, ते ओकी माय अरु भैइ बाहेर खडा था, अरु ओकासे बात करणो चास हइ. ");
INSERT INTO goj_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","कोय ने ओकासे बोल्यो, “देख तरी माय अरु तरो भैइ बाहेर खडा हइ, अरु तरा से बात करणु चास हइ.” ");
INSERT INTO goj_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","यो सुनीखे ओने बोलनवाला खे उत्तर दियो, “कोन हइ मरी माय? अरु कोन हइ मरो भैइ?” ");
INSERT INTO goj_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","अरु अपना सेवकहोन का तरप हात बढय खे बोल्यो, “मरी माय अरु मरो भैइ ये हइ. ");
INSERT INTO goj_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","क्योकी जो कोय मरा स्वर्गीय बाप की इच्छा पर चलस, उ मरो भैइ, अरु भैइन, अरु मरी माय हइ.” ");
INSERT INTO goj_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","उ दीन यीशु घर से नीकलीखे एक झील का किनारा पर जयखे बठ्यो. ");
INSERT INTO goj_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","अरु ओका पास असी बडि गर्दी जमा हुये की उ एक डोंगा पर चेडी खे बठी गो, अरु सब गर्दी किनारा पर ही खडि ऱ्ही गय. ");
INSERT INTO goj_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","अरु यीशु ने उनसे दृष्‍टान्‍त मे भोत सारी बात बोली “अरु एक बोनआलो बीज बोन नीकलस. ");
INSERT INTO goj_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","बोन का टेम मे कुछ बीच रस्ता का किनारा पर गिरी जास अरु पक्षिहोन ने अयखे उनखे खय लियो. ");
INSERT INTO goj_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","कुछ बीचहोन पत्थर जमीन पर गिरी जास, झा उनखे भोत मट्टी नी मीले अरु नरम मट्टी का कारण बीजहोन जल्दी उगी जास. ");
INSERT INTO goj_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","पर बीज सुरज नीकलना पर वे जली गा, अरु जडी नी पकडना से सुखी गा ");
INSERT INTO goj_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","कुछ बीजहोन झाडिहोन मे गिरी जास, अरु झाडि होन ने बढिखे उनखे दबय दियो. ");
INSERT INTO goj_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","पर कुछ बीजहोन अच्छी जमीन पर गिरस, अरु अच्छा फल लास, कोय सौ गुना, अरु कोय साठ गुना, अरु कोय तीस गुना. ");
INSERT INTO goj_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","“जोका कान हुये ते वे सूनी ले.” ");
INSERT INTO goj_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","अरु सेवक होन ने ओका पास अयखे ओकासे बोल्यो, “तू उनका से दृष्‍टान्‍त मे का बात करस हइ?” ");
INSERT INTO goj_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","ओने उत्तर दियो, “तुम खे स्वर्ग का राज्य को भेद कि सजा दी गय हइ, पर उनखे नी. ");
INSERT INTO goj_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","क्योकी जोका पास भोत हइ, ओखे दियो जाये. अरु ओका पास भोत जादा हुय जाये. पर जो इंन्सान का पास कुच नी हइ, ओका से जो कुछ ओका पास हइ, उ भी ली लियो जाये.” ");
INSERT INTO goj_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","मी उनसे दृष्‍टान्‍तहोन मे येकालिये बात करुस हइ, की वे देखता हुये नी देखस. अरु सुनता हुये नी सुने. अरु नी समझस. ");
INSERT INTO goj_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","अरु उनका बारे मे यशायाह कि या भविष्यवाणी पुरी होस हइ तुम कानहोन से ते नी सुने, पर समझे नी अरु आख से ते नी देखन को, पर तुमखे नी सुझे. ");
INSERT INTO goj_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","क्युकी ये दुन्याहोन को मन मे कठोर हुय गयो हइ, अरु वे कान से उचो सुनस हइ अरु ओने अपनी आख बन्द करी लीस हइ. कही असो नी हुये कि वे आख से देखस, अरु कान से सुनस अरु मन से समझस अरु फिरी जाये, अरु मी उनखे अच्छो कऱ्यु. ");
INSERT INTO goj_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“पर धन्य हइ तुम्हारी आख, की वे देखी सकस हइ. अरु तुम्हारा कान, की वे सुनी सकस हइ. ");
INSERT INTO goj_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","क्योकी मी तुम से सच्ची बोलुस हइ, कि बहोत सा भविष्यव्दक्ता अरु धर्मीहोन ने चायो कि जो बात तुम देखस हइ, देख पर देख नी सकस, अरु जो बात तुम सुनस हइ, पर सुनी नी सकस.” ");
INSERT INTO goj_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","अब तुम बोनवाला को दृष्‍टान्‍त को अर्थ सुन. ");
INSERT INTO goj_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","जो कोय राज्य को वचन सुनीखे नी समझस, ओका मन मे जो कुछ बोयो गयो थो, ओखे उ दुष्ट अयखे छुड्य ली जास हइ. यो उ हइ, जो रस्ता का किनारा पर बोयो गयो हइ. ");
INSERT INTO goj_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","अरु जो बीज पत्थर जमीन पर बोयो गयो हइ, यो उ हइ, जो वचन सुनीखे झल्दी आनन्द का साथ मानी लेस हइ. ");
INSERT INTO goj_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","पर अपना मे जडी नी रखन का कारण उ जरासा ही दिन को हइ, अरु जब वचन का कारण क्लेश या अंत्याचार होस हइ, ते झल्दी ठोकर खास हइ. ");
INSERT INTO goj_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","जो झाडिहोन मे बोयो गयो हइ यो उ हइ, जो वचन खे सुनी लेस हइ, पर या जगत की चिन्ता अरु धन खे धोखा वचन खे दबास हइ, अरु उ फल नी लास. ");
INSERT INTO goj_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","“जो अच्छो बीज जमीन पर बोयो गयो, यो उ हइ, जो वचन सुनीखे समझस हइ, अरु फल लास हइ कोय सौ गुना, अरु कोय साट गुना, अरु कोय तीस गुना .” ");
INSERT INTO goj_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","यीशु ने उनखे एक अरु दृष्‍टान्‍त दियो, “स्वर्ग को राज्य उ इंन्सान का जसो हइ जेने अपना खेत मे अच्छो बीज बोयो हइ. ");
INSERT INTO goj_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","पर जब दुन्या सोय रा था ते ओका दुसमन आयखे गहु का जंगली बीज बोयी खे चली गया. ");
INSERT INTO goj_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","जब गहु को कोम नीकली अरु बाली लगी, ते जंगली दाना का झाड भी दिखय दियो.” ");
INSERT INTO goj_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","येका पर गृहस्थ का सेवक ने अय खे ओकासे बोल्यो, “हे स्वामी, का तोने अपना खेत मे अच्छो बीज नी बोयो थो? फिर जंगली का दाना का झाड ओमे खा से आयो?” ");
INSERT INTO goj_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","ओने ओकासे बोल्यो, “ह्या कोय दुसमन को कोय काम नी हइ. सेवक ने ओकासे बोल्यो, का तरी इच्छा हइ, की हम उनखे उखाडि खे फेकी दे?” ");
INSERT INTO goj_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","ओने बोल्यो, नी, असो नी हुये कि जंगली दाना का झाड जमा हुये तुम उनका साथ गहु भी उखाडी दी सकस ते. ");
INSERT INTO goj_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","“काटना तक दोय खे एक साथ बडन दे, अरु काटन का टेम मी काटन वाला से बोल्यु. पैयले जंगली दाना का झाड जमा करीखे जलान का लिये उनका गठ्टा बांदी ले, अरु गहु खे मरा खेत मे जमा करी देस.” ");
INSERT INTO goj_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","ओने उनसे एक अरु दृष्‍टान्‍त दियो, “अरु स्वर्ग को राज्य रइ को एक दाना का जसो हइ, जेने कोय इंन्सान ने लीखे अपना खेत मे बोय दियो. ");
INSERT INTO goj_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","उ सब बीजहोन से छोटो ते हइ पर जब बडो होस हइ, तब सब बगीचो को रोप से बडो होस हइ. अरु असो झाड हुये जास हइ, की बद्दल की पक्षिहोन अयखे ओकी डग्यान पर अपनो घोसलो बनय खे ऱ्हेन लग्या.” ");
INSERT INTO goj_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","ओने अरु एक दृष्‍टान्‍त उनखे सुनायो, “अरु स्वर्ग को राज्य खमीर का जसो हइ जेखे कोय बय ने लीखे तीन पस आटा मे खमीर हुइ गयो.” ");
INSERT INTO goj_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","ये सब बातहोन यीशु ने द्दष्टानहोन मे दुन्या से बोली, अरु बिना दृष्‍टान्‍त उ उनसे कुछ नी बोल्यो थो. ");
INSERT INTO goj_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","की जो वचन भविष्यव्दक्ता का वजेसे बोल्यो गयो थो, उ पुरो हुये “मी दृष्‍टान्‍त बोलन खे अपनो मुढो खोल्यु मी वा सब बात खे जो जगत की उत्पत्ति से दबीखे ऱ्ही हइ प्रगट कऱ्यु.” ");
INSERT INTO goj_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","तब वे गर्दी खे छोडी खे अपना घर मे आया, अरु ओका सेवक होन ने ओका पास अयखे बोल्यो, “खेत का जंगली दाना को दृष्‍टान्‍त हमखे समझ्य दे.” ");
INSERT INTO goj_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","ओने उनखे उत्तर दियो, “अच्छो बीज खे बोनआलो इन्सान को बेटो हइ. ");
INSERT INTO goj_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","खेत जगत हइ, अरु अच्छो बीज राज्य को बेटो हइ, अरु जंगली बीज दुष्ट को बेटो हइ. ");
INSERT INTO goj_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","जो दुसमन ने ओखे बोयो उ सैतान हइ. काटना से जगत को अन्त: हइ अरु काटन वलो स्वर्गदूत हइ. ");
INSERT INTO goj_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","अत: जसो जंगली दाना खे जमाकरी जास अरु जलाया जास हइ असो हि जगत का अन्त: मे होस. ");
INSERT INTO goj_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","इन्सान को बेटो अपनो स्वर्गदूतहोन खे भेजस, अरु वे ओका राज्य मे से सब ठोकर का कारण खे अरु बुरो करणवाला खे जमा करस.” ");
INSERT INTO goj_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","अरु उनखे अंगार का कुव्वा मे डालस, व्हा रोनो अरु दात पिसानो हुये. ");
INSERT INTO goj_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","उ टेम परमेश्वर का धर्मी दुन्या अपना बाप का राज्य मे सुर्य का जसो चमकस. जेको कान हुये उ सुनी लेस. ");
INSERT INTO goj_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","स्वर्ग को राज्य खेत मे लुकायो हुयो धन का जसो हइ, जेखे कोय इंन्सान ने लिखे लुकय दियो, अरु आनन्द का मारे जयखे अपनो सब कुछ बेचीखे उ खेत खे मोल ली लियो. ");
INSERT INTO goj_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","फिर स्वर्ग को राज्य एक धंदा आला का जसो हइ जो अच्छो मोतिहोन का खोज मे हइ. ");
INSERT INTO goj_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","जब ओखे एक बहुमूल्य मोती मील्यो ते ओने जयखे अपनो सब कुछ बेची डालयो अरु उ मोति खे मोल ली लियो. ");
INSERT INTO goj_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","फिर स्वर्ग को राज्य उ बडा जाल का जसो हइ, जो समुदर मे डाल्यो गयो, अरु हर प्रकार की मछलिहोन खे जमाकरी लायो. ");
INSERT INTO goj_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","अरु जब जाल भरी गइ, ते मच्छीहोन ओखे किनारा पर खीची खे लायो, अरु बैठिखे अच्छी-अच्छी बर्तन मे जमाकरी अरु बेकार-बेकार फेकी दि. ");
INSERT INTO goj_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","जगत को अन्त: मे असो ही हुये. स्वर्गदूत अयखे पापीहोन खे धर्मीहोन से अलग करी दिये, ");
INSERT INTO goj_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","अरु उनखे अंगार का कुव्वा मे डाली दिये. व्हा रोनो अरु दात पीसनो हुये. ");
INSERT INTO goj_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","“का तुम ये सब बात समझी गया?” सेवक होन ने उत्तर दियो हव. ");
INSERT INTO goj_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","फिर यीशु ने उनखे बोल्यो, “येकालिये हर एक शास्त्रिहोन जो स्वर्ग का राज्य का सेवक बन्या हइ, उ गृहस्थ का जसो हइ जो अपना भण्‍डार से नवो अरु पुरानो सामन नीकाली देस हइ.” ");
INSERT INTO goj_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","जब यीशु या सब बात को दृष्‍टान्‍त बोली चुक्यो, ते व्हा से चली गयो. ");
INSERT INTO goj_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","अरु अपना गाव मे अयखे उनका आराधनालय मे उनखे असो शिक्षा देन लग्यो. कि वे चकित हुइखे बोलन लग्या, “इनखे यो ज्ञान अरु बडो सामर्थ्य को काम खा से मील्यो? ");
INSERT INTO goj_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","का यो बडो बेटो नी? अरु का येकी माय को नाम मरियम अरु येका भैइ को नाम याकूब, अरु यूसुफ, अरु शमौन अरु यहुदा नी? ");
INSERT INTO goj_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","अरु का इनखे सब भैइनहोन हमारा बीज मे नी ऱ्हेस? फिर इनखे यो सब खा से मालुन होस?” ");
INSERT INTO goj_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","येका प्रकार ओने ओका कारण ठोकर खइ हइ पर यीशु ने उनसे बोल्यो, “भविष्यव्दक्ता अपना गाव अरु अपना घर खे छोडी खे अरु कोय नीरादर नी होस.” ");
INSERT INTO goj_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","अरु ओने व्हा उनका अविश्वास का कारण भोत सामर्थ्य को काम नी कर्‍हे. ");
INSERT INTO goj_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","उ टेम गलील देस को हेरोदेस राजो थो यीशु का बारे मे चर्चा सुनी. ");
INSERT INTO goj_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","अरु अपना सेवकहोन से हेरोदेस बोल्यो, “यो यहून्ना बपतिस्मा देनवालो हइ उ मऱ्या हुया मे से जिन्दो उठ्यो हइ, येका लिये ओकासे सामर्थ को काम प्रगट होस हइ.” ");
INSERT INTO goj_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","क्युकी हेरोदेस ने अपना भैइ फिलिप्पुस की लुगेन हेरोदियास का कारण यहून्ना खे पकडीखे बाध्यो, अरु जेल खाना मे डाली दियो थो. ");
INSERT INTO goj_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","क्युकी यहून्ना ने ओकासे बोल्यो थो, कि येका से भ्याव करणो अच्छो नी हइ. ");
INSERT INTO goj_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","अरु उ ओखे मार डालनो चातो थो, पर दुन्या से डरतो थो, क्युकी वे ओखे भविष्यव्दक्ता मानता था. ");
INSERT INTO goj_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","पर जब हेरोदेस का जन्मदिन आयो, ते हेरोदियोस कि बेटी ने उ तिवार मे नाच बतायो, अरु हेरोदेस खे खुश कऱ्यो. ");
INSERT INTO goj_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","येका लिये ओने कसम खयखे वचन दियो, “जो कुछ तु मागे, ते मी तोखे दियु.” ");
INSERT INTO goj_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","उ अपनी माय खे उकसाना से बोले, “जो यहून्ना बपतिस्मा देनआला को माथो ठाटी मे उही मेखे मागी दे.” ");
INSERT INTO goj_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","राजो दुखी हुयो, पर अपनी कसम का अरु सात बठन आला का कारण, आज्ञा दी, की दी दियो जाये. ");
INSERT INTO goj_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","अरु ओने जेल मे दुन्याहोन खे भेजीखे यहून्ना को माथो काटी दियो. ");
INSERT INTO goj_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","अरु ओको माथो ठाटी मे लायो गयो, अरु ओकी बेटी खे दियो गयो. अरु उ ओखे अपनी माय का पास लीखे गयो. ");
INSERT INTO goj_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","अरु ओका सेवक होन ने अयखे ओका मुर्दा खे ली जयखे गाडी दियो अरु यीशु का सामने पुरो समाचार दियो. ");
INSERT INTO goj_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","जब यीशु ने यहुन्ना का बारे मे सुन्यो, ते डोंगा पर चेडीखे व्हा से कोय सुनसान जगह पर, अकेला मे चली गयो. अरु दुन्या यो सुनीखे गाव-गाव से पयदल ओका पीछे हुये लीयो. ");
INSERT INTO goj_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","ओने डोंगा से नीकलीखे एक बडी गर्दी देखी, अरु उन पर दया अयगी, अरु ओने उनका बेमारहोन खे अच्छो कऱ्यो. ");
INSERT INTO goj_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","जब रात हुइ ते ओका सेवक होन ने ओका पास अयखे ओखे बोल्यो, “या तो सुनसान जगा हइ अरु देर हुये ऱ्ही हइ, अरु दुन्याहोन खे बिदा कऱ्यो जाये की वे बजार मे जयखे अपना लिये खानो मोल लाये.” ");
INSERT INTO goj_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","यीशु ने सेवक होन से बोल्यो, की उनको जानो जरुरी नी हइ! तुम ही जयखे उनका लिये खानो ला ");
INSERT INTO goj_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","ओने ओकासे बोल्यो, “की हमारा पास पाच रोटी अरु दो मंछी खे छोडी खे अरु कुछ नी हइ.” ");
INSERT INTO goj_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","यीशु ने बोल्यो, “उनखे मरा पास लिखे आ.” ");
INSERT INTO goj_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","तब ओने दुन्याहोन खे घास पर बठन खे बोल्यो, अरु वे पाच रोटीहोन अरु दो मंछीहोन खे लीखे आ. अरु स्वर्ग का तरप देखीखे धन्यवाद बोल्यो अरु रोटीहोन खे तोडी-तोडीखे सेवक होन खे दी, अरु सेवक होन ने दुन्‍याहोन खे दी. ");
INSERT INTO goj_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","अरु सब खयखे मगम हुये गया, अरु ओने बचया हुया टुकडाहोन से भरी हुये बारा टोपली उठ्य. ");
INSERT INTO goj_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","अरु खानवाला बय अरु बच्चाहोन खे छोडी खे पाच हजार इन्सान का नजीकपास था. ");
INSERT INTO goj_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","अरु ओने जलदी अपना सेवक होन खे डोंगा पर चडय दियो, कि वे ओकासे पैयले पार चली जाये जब तक कि उ दुन्याहोन खे बिदा करी देस. ");
INSERT INTO goj_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","उ दुन्याहोन खे बिदा करीखे, प्रार्थना करण खे दुसरा टेकडा पर चडी गयो, अरु रात खे उ व्हा अकेलो थो. ");
INSERT INTO goj_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","उ टेम डोंगो झील का बीज मे पानी की लहर से डगमगय रो थो, क्युकी सामने से हवा चालु थी. ");
INSERT INTO goj_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","अरु यीशु फजर का तीन से छे बजे का नजीकपास पानी पर चलतो हुये उनका पास आयो. ");
INSERT INTO goj_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","सेवक ओखे पानी पर चलते हुये देखीखे घबरय गा, अरु बोलन लग्या, “ की उ भुत हइ,” अरु डर का मारे चिल्लान लग्या. ");
INSERT INTO goj_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","यीशु ने उनका साथ बात करीखे बोल्यो, “हिम्मत रख, मी आय. डरे मत.” ");
INSERT INTO goj_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","पतरस ने ओखे उत्तर दियो, “हे प्रभु, अगर तु ही हइ, ते मेखे अपना पास पानी पर चडीखे आन की आज्ञा दे.” ");
INSERT INTO goj_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","यीशु ने बोल्यो, “आ!” तब पतरस डोंगा पर से उतरीखे यीशु का पास जान खे पाणी पर चलन लग्यो. ");
INSERT INTO goj_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","पतरस तब हवा खे देखीखे डरन लग्यो, अरु जब डुबन लग्यो ते ओखे चिल्लय खे बोल्यो, “हे प्रभु, मेखे बचा.” ");
INSERT INTO goj_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","तब यीशु ने ओखे झल्दी हात बढय खे ओखे थामी लियो, अरु ओकासे बोल्यो, “हे अल्पविश्वासिहोन, तोने का सन्देस कऱ्यो?” ");
INSERT INTO goj_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","जब वे डोंगा पर चडी गयो, ते हवा रुखी गइ. ");
INSERT INTO goj_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","येका पर जो डोंगा पर था, ओने ओकी आराधना करीखे बोल्यो, “सचमुच, तू परमेश्वर को बेटो हइ.” ");
INSERT INTO goj_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","“वे छोटी नद्दी का पार उतरीखे जमीन पर गनेसरत देश मे पोच्या. ");
INSERT INTO goj_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","अरु व्हा, दुन्याहोन ने यीशु खे पहचानी खे ओका आस पास का सब देस मे बुलाओ भेज्यो, अरु सब बेमारहोन खे ओका पास लाया. ");
INSERT INTO goj_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","अरु ओकासे प्रार्थना करण लग्या कि उ उनखे अपना कपडा को एक कोना खे ही छिन दे. अरु जतना ने ओखे छुयो, वे अच्छा हुये गा.” ");
INSERT INTO goj_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","“तब यरुशलेम से कुछ फरीसीहोन अरु शास्त्रिहोन यीशु का पास अयखे बोलन लग्या, ");
INSERT INTO goj_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","तरा सेवक होन बापदादा की रितीरिवाज खे काय बर टालस हइ, कि बिना हात धोय रोटि खास हइ?” ");
INSERT INTO goj_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","ओने उनखे उत्तर दियो, “तुम भी अपना रितीरिवाज का कारण क्यु परमेश्वर कि आज्ञा खे टालस हइ? ");
INSERT INTO goj_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","क्युकी परमेश्वर ने बोल्यो, अपना बाप अरु माय को आदर करणो, अरु जो कोय बाप या माय खे बुरो अच्छो बोले ओखे मारी डाल्यो जाये. ");
INSERT INTO goj_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","पर तुम बोलस हइ, कि अगर अपना बाप या माय से बोलस, जो कुछ तोखे मरासे लाभ पोच्यो सकस हइ, उ परमेश्वर खे दान चेडय जय चुक्यो. ");
INSERT INTO goj_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ते उ अपना बाप को आदर नी करस, येका प्रकार तुम ने अपना रितीरिवाज का कारण परमेश्वर का वचन खे टाली दियो. ");
INSERT INTO goj_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","हे कपटिहोन, यशायाह ने तुम्हारा बारे मे या भविष्यवाणी ठिक ही करी हइ! ");
INSERT INTO goj_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“ये दुन्याहोन होठ से मरो आदर करस हइ, पर उनको मन मरासे दुर ऱ्हेस हइ. ");
INSERT INTO goj_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","अरु ये व्यर्थ मरी उपासना करस हइ, उनकी शिक्षा तो फक्त इन्सानहोन ने सिखय हुइ नीयम हइ.” ");
INSERT INTO goj_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","अरु ओने दुन्याहोन खे अपना पास बुल्यखे उनसे बोल्यो, “सुन, अरु समझ. ");
INSERT INTO goj_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","जो मुडा मे जास हइ, उ इन्सान खे अच्छो नी करस हइ, पर जो मुडा से नीकलस हइ, उ इन्सान खे अच्छो करस हइ.” ");
INSERT INTO goj_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","तब ओका सेवक होन ने अयखे ओकासे बोल्यो, “की तुम जानस हइ की फरीसीहोन की भावनाहोन खे ठेस पोचास?” ");
INSERT INTO goj_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","ओने उत्तर दियो, “हर झाड जो मरा स्वर्गीय बाप ने नी लगायो, ओखे जड से उखाडि दियो जाये. ");
INSERT INTO goj_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","उनखे जान दे वे अंधा खे रस्ता बतानवाला हइ अरु अंधा खे अगर अंधो रस्ता बतास, ते दो झना गड्डा मे गिरी जास.” ");
INSERT INTO goj_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","यो सूनीखे पतरस ने ओकासे बोल्यो, “या काहानी हमखे समझय दे.” ");
INSERT INTO goj_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","ओने बोल्यो, “का तुम भी अभी तक नी समझ्या हइ? ");
INSERT INTO goj_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","का तुम नी जानस, कि जो कुछ मुडा मे जास हइ, उ पेट मे गिरस हइ, अरु उ शौच से नीकली जास हइ? ");
INSERT INTO goj_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","पर जो कुछ मुडासे नीकलस हइ उ मन से भी नीकलस हइ, अरु उ इन्सान खे अच्छो करस हइ. ");
INSERT INTO goj_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","क्युकी बुरो बिचार, मारनो, व्यभिचार, चोरी, झुटी गवाही अरु नीन्दा मन मे से नीकलस हइ. ");
INSERT INTO goj_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","यो हइ जो इन्सान खे अच्छो करस हइ, पन हात बिना धोये भोजन करणो इन्सान अच्छो नी करस हइ.” ");
INSERT INTO goj_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","यीशु व्हा से नीकलीखे, सूर अरु सैदा का देस का तरप चली गयो. ");
INSERT INTO goj_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","अरु देख, उ देस से एक कनानी बय नीकली, अरु चिल्लयखे बोलन लगी, “हे प्रभु! दाउद को बेटो, मरा पर दया कर, मरी बेटी बुरी आत्मा मे भोत दुख उठ्य री हइ.” ");
INSERT INTO goj_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","पर ओने ओखे कुछ भी उत्‍तर नी दियो, अरु ओका सेवक होन ने अयखे ओकासे प्रार्थना करीखे बोल्यो, “येखे बिदा कर. क्युकी वा हमारा पीछे पीछे चिलाती चिलाती आस हइ.” ");
INSERT INTO goj_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","ओने उत्तर दियो, “इस्राएल का घराना का गम्या हुये मेडा खे छोडी खे मी कोय का पास नी भेज्यो गयो.” ");
INSERT INTO goj_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","पर उ आयो, अरु वा अयखे अपना टोगर्या टेकीखे प्रणाम कऱ्यो, “हे प्रभु, मरी मदत कर.” ");
INSERT INTO goj_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","ओने उत्तर दियो, “बच्चाहोन की रोटी लिखे कुत्ताहोन का सामने डालनो अच्छो नी हइ.” ");
INSERT INTO goj_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","ओने बोल्यो, “सत्य हइ प्रभु, पर कुत्ताहोन भी वे टुकडा खास हइ, जो उनका स्वामीहोन का मेज से गिरास हइ.” ");
INSERT INTO goj_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","येका पर यीशु ने ओखे उत्तर दिखे बोल्यो, “हे बय, तरो विश्वास बडो हइ. जसो तू चास हइ, तरा लिये असो ही हुये” अरु ओकी बेटी उ टेम अच्छी हुय गइ. ");
INSERT INTO goj_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","यीशु व्हा से चलीखे, गलील का एक समुदर का पास आयो, अरु एक टेकडी पर चडीखे व्हा बठी गयो. ");
INSERT INTO goj_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","अरु गर्दी पर गर्दी ओका पास अयखे , वे अपना सात भोत लगडा, अंधा, मुक्को, ठुट्टो, अरु भोत खे लिखे यीशु का पास आया. अरु उनखे ओका पाय पर डाली दिया, अरु ओने उनखे अच्छो कऱ्यो. ");
INSERT INTO goj_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","अत: जब दुन्याहोन ने देख्यो, कि मुक्को बोलस अरु ठुट्टो अच्छो होस अरु लगडा चलस अरु अंधा देखस हइ, ते अचम्बो करीखे इस्राएल का परमेश्वर खे महिमा करण लग्या ");
INSERT INTO goj_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","यीशु ने अपना सेवक होन खे बुलय खे बल्यो, “मेखे या गर्दी पर दया आस हइ. क्युकी वे तीन दिन से मरा साथ हइ अरु उनका पास कुछ भी खान खे नी हइ. अरु मी उनखे भुखो बिदा करणो नी चास. कही असो नी हुये की रस्ता मे थकीखे गिरी जाये.” ");
INSERT INTO goj_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","सेवकहोन ने ओकासे बोल्यो, “ हमखे या जंगल मे खा से एत्ती रोटी मील्ये कि हम एत्ती बडि गर्दी खे संतुष्ट कर्या” ");
INSERT INTO goj_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","यीशु ने उनसे पुछ्यो, “तुमारा पास कतनी रोटी हइ?” ओने बोल्यो, “सात अरु जरासी छोटी मंछी हइ.” ");
INSERT INTO goj_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","तब ओने दुन्याहोन खे जमीन पर बठ्न कि आज्ञा दी. ");
INSERT INTO goj_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","अरु ओने सात रोटीहोन अरु मंछीहोन खे लीखे धन्यवाद करीखे तोडि खे अरु अपना सेवक होन खे दियो गयो, अरु सेवक होन ने दुन्याहोन खे दी. ");
INSERT INTO goj_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","येका प्रकार सब खयखे संतुष्ट हुये गया अरु बच्या हुया टुकडाहोन से भरी हुइ सात टोपलीहोन उठय. ");
INSERT INTO goj_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","अरु खानवाला बय अरु बच्चाहोन खे छोडी खे चार हजार इन्सान था. ");
INSERT INTO goj_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","तब उ गर्दीहोन खे बिदा करीखे डोंगा पर चेडी गयो, अरु उ मगदन देश मे आयो. ");
INSERT INTO goj_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","अरु फरीसीहोन अरु सदूकिहोन ने ओका पास अयखे ओखे परखन का लिये ओकासे बोल्यो, “ताकी हमखे स्वर्ग को कोय चिन्ह दिख्यो.” ");
INSERT INTO goj_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","ओने उनखे उत्तर दियो, “संजा खे तुम बोलस हइ, कि मोसम अच्छो ऱ्हीहे, क्युकी बद्दल लाल हइ. ");
INSERT INTO goj_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","अरु फजर खे तुम बोलस हइ, कि आज हवाधुन आह्ये क्युकी बद्दल लाल अरु झावरो हइ. तुम आकाश खे दुर लक्षण देखीखे टेमहोन को चिन्ह खे नी बतय सकस हइ? ");
INSERT INTO goj_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","या जमाना का बुरो अरु व्यभिचार दुन्या चिन्हा ढुढस हइ पर योना खे चिन्ह खे छोड कोय अरु चिन्ह उनखे नी दिखय जाये.” अरु उ उनखे छोडी खे चली गयो. ");
INSERT INTO goj_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","अरु सेवक होन नदी का वा बाजु जान का टेम रोटी लेनो भूली गया था. ");
INSERT INTO goj_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","यीशु ने उनका से बोल्यो, “देख, फरीसीहोन अरु सदूकिहोन का खमीर से हुशार ऱ्हेनू.” ");
INSERT INTO goj_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","वे आपस मे बिचार करण लग्या, “हमने रोटी नी लैय. येकालिये उ असो बोलस हइ.” ");
INSERT INTO goj_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","यो जानीखे, यीशु ने उनका से बोल्यो, “हे अल्पविश्वासिहोन, तुम आपस मे का बिचार करस हइ की हमारा पास रोटी नी हइ? ");
INSERT INTO goj_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","का तुम अभी तक नी समझ्या? अरु उ टेम पाच हजार दुन्या खे पाच रोटी याद नी करस, अरु नी यो की खे तनी टोपली उठय थी? ");
INSERT INTO goj_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","अरु नी उ चार हजार दुन्याहोन की सात रोटी, अरु नी ह्या की खे तनी टोपलीहोन भरी खे उठय थी? ");
INSERT INTO goj_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","तुम का नी समझस कि मेने तुम से रोटी का बारे मे नी बोल्यो? पन फरीसीहोन अरु सदूकिहोन का खमीर से हुशार ऱ्हेन खे बतायो थो.” ");
INSERT INTO goj_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","तब उनखे समझ मे आयो, की ओने रोटी का खमीर से नी, पर फरीसीहोन अरु सदूकिहोन कि शिक्षा से हुशार ऱ्हेन का बारे मे बोल्यो थो. ");
INSERT INTO goj_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","यीशु कैसरीया का फिलिप्पी का एक देस मे अयखे अपना सेवक होन से पुछन लग्यो, “दुन्याहोन इन्सान का बेटा खे का बोलस हइ?” ");
INSERT INTO goj_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","उनने बोल्यो, कुछ तो यहून्ना बपतिस्मा देन आलो बोलस हइ अरु कुछ एलिय्याह, अरु कुछ यिर्मयाह यो भविष्यव्दक्ताहोन मे से कोय एक बोलस हइ. ");
INSERT INTO goj_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","ओने उनका से बोल्यो, “पन तुम मरा से का बोलस हइ?” ");
INSERT INTO goj_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","शमौन पतरस ने उत्तर दियो, “तु ही मसीह हइ जिन्दो परमेश्वर को बेटो हइ.” ");
INSERT INTO goj_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","यीशु ने ओखे उत्तर दियो, “हे शमौन, योना को बेटो, तु अच्छो हइ. क्युकी मास अरु खुन नी, पन मरो बाप जो स्वर्ग मे हइ, या बात तरा पर प्रगट करी हइ. ");
INSERT INTO goj_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","अरु मी भी तरा से बोलुस हइ, कि तू पतरस हइ, अरु मी यो पत्थर पर अपनी मंडली बनाउ, अरु मरन को सामर्थ्य दुन्या का फाटक ओका पर विजय नी हुये. ");
INSERT INTO goj_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","मी तोखे स्वर्ग का राज्य कि कुंजी दियु अरु जो कुछ तू पृथ्वी पर बाधे, उ स्वर्ग मे भी बाधे. अरु जो कुछ तु पृथ्वी पर खोले, उ स्वर्ग मे भी खोले.” ");
INSERT INTO goj_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","तब ओने सेवक होन खे चेतावनी दी, “कोय से नी बोलनु! की मी मसीह हइ.” ");
INSERT INTO goj_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","उ टेम से यीशु अपना सेवक होन खे बतान लग्यो, “मेखे जरुरती हइ, की मी यरुशलेम खे जाउ, अरु बापदादाहोन अरु याजकहोन अरु पंडीतहोन का हात से भोत दुख उठायु अरु मार्या डाली जायु अरु तीसरा दिन जिन्दो हुये जायु.” ");
INSERT INTO goj_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","येका पर पतरस ने ओखे अलग ली जयखे धमकान लग्यो, हे प्रभु, परमेश्वर नी करणु! तरा पर असो कभी नी हुये. ");
INSERT INTO goj_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","ओने फिरीखे पतरस से बोल्यो, “हे सैतान, मरा सामने से दुर हुय जा! तू मरा लिये ठेस को कारण हइ. क्युकी तू परमेश्वर की बात नी, पर इन्सानहोन की बात पर मन लगास हइ.” ");
INSERT INTO goj_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","तब यीशु ने अपना सेवक होन से बोल्यो. “अगर कोय मरा पीछे आनो चाह्ये, ते अपना आप खे इन्कार कर अरु अपनो क्रुस उठा, अरु मरा पीछे हुये ले. ");
INSERT INTO goj_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","क्युकी जो कोय अपनो जान बचानो चाह्ये, उ ओखे गमाये. अरु जो कोय मरा लिये अपनो जान गमाये, उ ओखे पाये. ");
INSERT INTO goj_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","अगर इन्सान सब जगत खे मील्यो कर्‍हे ते, अरु अपना जान की हानी उठाये, ते ओखे का लाभा हुये? यो इन्सान अपना जान का बदल मे का दिये? ");
INSERT INTO goj_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","इन्सान को बेटो अपना स्वर्गदूतहोन का सात अपना बाप की महिमा मे आह्ये, अरु उ टेम उ हर एक खे ओका काम का अनुसार प्रतीफल दिये. ");
INSERT INTO goj_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","मी तुम से सच्ची बोलुस हइ की जो ह्या खडा हइ उनमे से केतना असा हइ, की जब तक इन्सान का बेटो खे ओका राज्य मे आते हुये नी देखी लिये, तब तक मरन को सवाद कभी नी चखे.” ");
INSERT INTO goj_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","छे दिन का बाद यीशु ने पतरस अरु याकूब अरु ओको भैइ यहून्ना खे सात लियो, अरु ओखे अकेला मे कोय उची टेकडी पर लीखे गया. ");
INSERT INTO goj_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","अरु व्हा उनका सामने ओको रुपातरण हुयो ओका मुडा पर सुरज का जसो चमक्यो अरु ओका कपडा उजाल्ला का जसो उजालो हुये गयो. ");
INSERT INTO goj_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","अरु मूसा अरु एलिय्याह ओका सात बात करता हुया तीन सेवक खे दिखय दियो. ");
INSERT INTO goj_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","येका पर पतरस ने यीशु से बोल्यो, “हे प्रभु, हमारो ह्या ऱ्हेनो अच्छो हइ. अगर तरी इच्छा हुये ते मी ह्या तीन मण्डप बनायु. एक तरा लिये अरु एक मूसा का लिये अरु एक एलिय्याह का लिये.” ");
INSERT INTO goj_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","उ बोली रो थो, की एक उजालो बद्दल ने उनखे झाकी लियो, अरु उ बद्दल मे से यो बोल नीकल्यो, “उ तरो लाड को बेटो हइ. जेका से मी प्रसन्न हुयो येको सुन.” ");
INSERT INTO goj_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","सेवक होन यो सूनीखे मुडा का बल गिरि गया अरु भोत डरी गा. ");
INSERT INTO goj_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","यीशु ने उनका पास अयखे पकड्यो, अरु बोल्यो, “उट, डरे मत.” ");
INSERT INTO goj_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","तब उनने अपना आख उठ्यखे यीशु खे छोडी खे कोय दुसरा खे नी देख्यो. ");
INSERT INTO goj_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","जब वे टेकडी से उतरी रा था तब यीशु ने उनखे या आज्ञा दि, “जब तक इन्सान को बेटो मऱ्या हुया मे से जिन्दो हुयो, तब तक जो कुछ तुम ने देख्यो हइ कोय दुन्याहोन से नी बोलनु.” ");
INSERT INTO goj_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","अरु ओका सेवक होन ने ओकासे पुछ्यो, “फिर व्यवस्था का शास्त्री का बोलस हइ, एलिय्याह को पैयले आनो नीश्वित हइ?” ");
INSERT INTO goj_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","ओने उत्तर दियो, “एलिय्याह तो जरुरती आह्ये अरु सब कुछ सुधारे. ");
INSERT INTO goj_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","पन मी तुम से बोलुस हइ, की एलिय्याह ए चुक्यो. अरु उनने ओखे नी पैछान्यो. पन जसो चायो असो ही ओका सात कऱ्यो. यो प्रकार से इन्सान को बेटो भी ओका हात से दुख उठाये.” ");
INSERT INTO goj_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","तब सेवक होन ने समझ्यो कि ओने हम से यहून्ना बपतिस्मा देनआला का बारे मे बोल्यो हइ. ");
INSERT INTO goj_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","“जब वे गर्दी का पास पोच्यो, ते एक इन्सान ओका पास आयो, अरु टोगऱ्या टेकी खे बोलन लग्यो. ");
INSERT INTO goj_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","हे प्रभु, मरा बेटा पर दया कर! क्युकी ओखे मीर्गी आस हइ, अरु उ भोत दुख उठास हइ. अरु बार-बार अंगार मे अरु बार-बार पानी मे गिरी जास हइ. ");
INSERT INTO goj_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","अरु मी ओखे तरा सेवक होन का पास लायो थो, पर वे ओखे अच्छो नी करी सक्या.” ");
INSERT INTO goj_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","यीशु ने उत्तर दियो, हे अविश्वासीहोन अरु बिगड्या दुन्याहोन, मी कब तक तुम्हारा सात ऱ्हुयु? कब तक तुम्हारो सहनु? ओखे ह्या मरा पास ला. ");
INSERT INTO goj_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","तब यीशु ने ओखे आज्ञा दी, अरु बुरीआत्मा ओमे से नीकली. अरु बेटो उ टेम मे अच्छो हुय गयो. ");
INSERT INTO goj_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","तब सेवक होन ने एकला मे यीशु का पास अयखे बोल्यो, “हम येखे, नी निकालीस सक्या?” ");
INSERT INTO goj_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","ओने उनका से बोल्यो, “अपना विश्वास कि कमी का कारण क्युकी मी तुम से सच्ची बोलुस हइ, अगर तुमारो विश्वास रइ का दाना का बराबर भी हुये, ते या टेकडी से बोली सखे, ह्या से सरकी खे व्हा से चली जा. ते वा चली जाये. अरु कोय बात तुमारा लिये कठीन नी हुये. ");
INSERT INTO goj_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","पर या जातहोन का बिना प्रार्थना अरु उपास का बिना नी नीकलस.” ");
INSERT INTO goj_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","जब वे गलील मे था, ते यीशु ने उनका से बोल्यो, “इन्सान को बेटो इन्सानहोन का हात मे पकड्यो जाये. ");
INSERT INTO goj_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","अरु वे ओखे मारी डालनो चास कि अरु उ तीसरा दिन जिन्दो उठ्ये.” येका पर वे भोत उदास हुये. ");
INSERT INTO goj_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","जब यीशु अरु सेवक कफरनहूम मे पोच्या, ते मन्‍दिर का लिये कर लेनवाला ने पतरस का पास अय खे ओका से पुछ्यो “तुमारो गुरु मन्‍दिर को कर नी दिये?” ");
INSERT INTO goj_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","ओने बोल्यो, हव देउस हइ. जब उ घर मे आयो, ते यीशु ने ओका पुछना से पैयले ओकासे बोल्यो, “हे शमौन तु का समझस? “पृथ्वी को राजो चुंगी या कर को का से लेस हइ? अपना बेटाहोन से या दुसरा से?” ");
INSERT INTO goj_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","पतरस ने ओकासे बोल्यो? “दुसरा से.” यीशु ने ओकासे बोल्यो, “तब बेटाहोन कर देना से बची गया. ");
INSERT INTO goj_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","फिर भी हम उनखे ठोकी खे नी खलानु, तु नदी का एक किनारा पर जय खे जाल डाल, अरु जो मंछी पैयले नीकले, ओखे ला. ते तोखे ओको मुडो खोलना पर एक चादी को सिक्काको मील्हे, ओखे लिखे मरो अरु अपना बदल मे उनखे दी देनु.” ");
INSERT INTO goj_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","उ टेम सेवक होन यीशु का पास अय खे ओखे पुछन लग्या, “स्वर्ग का राज्य मे बडो कोन हइ?” ");
INSERT INTO goj_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","येका पर ओने एक बच्चा खे ओका पास बुलय खे उनका बिच मे खडो कऱ्यो, ");
INSERT INTO goj_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","अरु तुम बोल्य, “मी तुम से सच्ची बोलुस हइ, अगर तुम नी बदलनु अरु बच्चाहोन का जसो नी बने, ते स्वर्ग का राज्य मे नी जय सकी पाये. ");
INSERT INTO goj_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","जो कोय अपना आप खे यो बच्चा का जसो छोटो कर्‍हे, उ स्वर्ग का राज्य मे बडो हुये. ");
INSERT INTO goj_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","अरु जो कोय मरा नाम से एक असो बच्चा खे अपनास हइ उ मेखे अपनास हइ. ");
INSERT INTO goj_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“पर जो कोय यो छोटा मे से जो मरा पर विश्वास करस हइ उ एक खे विश्वास मे ठोकर देस, ओका लिये अच्छो हुये की बडी चक्की को पाट ओका गला मे लटकायो जाये, अरु उ खोल समुदर मे डूबी जाये. ");
INSERT INTO goj_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","ठोकर का कारण जगत पर हाय! विश्वास मे धोको मीलनो जरुरती हइ. पर हाय उ इन्सान पर जेका वजेसे ठोकर लगस हइ. ");
INSERT INTO goj_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“अगर तरा हात या तरा पाय तोखे विश्वास मे धोको देस, ते उनखे काटी खे फेकी दे. अरु टुट्या या लगडा हुइ खे जिवन मे प्रवेश करणो तरा लिये येका से अच्छो हइ, कि दो हात या दो पाय ऱ्हेता हुये तू अनन्त अंगार मे डाल्यो जाये. ");
INSERT INTO goj_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","अगर तरा आख तोखे विश्वास मे ठोकर दिये ओखे फेकीदे, ते ओखे नीकाली खे फेकी दे, न हुइ खे भी जिवन मे प्रवेश करणो तरा लिये येका से अच्छो नी हइ, की दो आख ऱ्हेते हुये तू नरक की अंगार मे डाल्यो जाये. ");
INSERT INTO goj_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“देख तुम ये छोटा मे से तुच्छ नी जाननु. क्युकी मी तुम से बोलुस हइ, कि स्वर्ग मे उनका स्वर्गदूत मरा स्वर्गीय बाप को मुडो हमेशा देखस हइ. ");
INSERT INTO goj_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","क्युकी इन्सान को बेटो गम्या हुया खे बचान आयो हइ. ");
INSERT INTO goj_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“तुम का समझस हइ? अगर कोय इन्सान का पास सौ मेडा हुये, अरु ओमे से एक भटकी जाये ते, नन्यानन्व खे छोडी खे अरु टेकडी पर जैखे, उ भटकी हुये खे नी ढुढे? ");
INSERT INTO goj_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","अगर असो हुये की ओखे पाये, ते मी तुम से सच्ची बोलुस हइ, कि उ वे नन्यानन्व मेडा का लिये जो भटकी नी थी अतनो आनन्द नी करस, जेतनो की या मेडा का लिये करस हइ. ");
INSERT INTO goj_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","असा मे तुमारा बाप की जो स्वर्ग मे हइ या इच्छा नी की ये छोटा मे से एक भी खतम हुये. ");
INSERT INTO goj_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“अगर तरो भैइ तरा बदल मे पाप करस, ते जा अरु येकला मे बातचीत करीखे ओखे समझा. अगर उ तरी सुने ते अपनो भैइ तोखे मीली गयो. ");
INSERT INTO goj_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","अगर उ नी सुने, ते एक दो झना खे अपना सात लिखे जा, जसो कि शास्त्र मे लिख्यो हइ कि हर एक की बात दो या तीन गवाह का मुडा से रुखी जाये. ");
INSERT INTO goj_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","अगर उ उनकी भी नी माने, ते मंडली से बोली दे, पन अगर उ मंडली कि भी नी माने का ते तू ओखे गैरयहूदिहोन का अरु चुंगी लेनवाला का जसो जानस. ");
INSERT INTO goj_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“मी तुम से सच्ची बोलुस हइ, जो कुछ तुम पृथ्वी पर बाधे, उ स्वर्ग पर भी बाधे अरु जो कुछ तुम पृथ्वी पर खोले, उ स्वर्ग मे भी खोले. ");
INSERT INTO goj_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“फिर मी तुम से बोलुस हइ, अगर तुम मे से दो झना पृथ्वी पर कोय बात का लिये जेखे वे मागस, एक मन हुइ खे ते उ मरा बाप का तरप से जो स्वर्ग मे हइ उनका लिये पुरो कऱ्यो जाये. ");
INSERT INTO goj_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","क्युकी झा दो या तीन मरा नाम पर जमा होस हइ व्हा मी उनका बीच मे होस हइ.” ");
INSERT INTO goj_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","तब पतरस ने ओका पास अय खे, यीशु से बोल्यो, “हे प्रभु, अगर मरो भैइ पाप करतो ऱ्हीये, ते मी केत्तना बार ओखे माफ करु, सात बार तक?” ");
INSERT INTO goj_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","यीशु ने ओकासे बोल्यो, मी तरा से नी बोलुस, की सात बार तक वरन सात बार खे सत्तर गुना तक. ");
INSERT INTO goj_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“येका लिये स्वर्ग को राज्य उ राजा का जसो हइ, जेने अपना सेवक होन से लीख्यो लेनो चायो.” ");
INSERT INTO goj_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","जब उ लीख्यी लेन लग्यो, ते एक झनो ओका जसो लायो गयो जो करोड सिक्का को कर्जदार थो. ");
INSERT INTO goj_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","जब की चुकान खे ओका पास कुछ नी थो, ते ओका स्वामी ने बोल्यो, की यो अरु येकी लुगेन अरु ओका बाल-बच्चा अरु जो कुछ येको हइ सब कुछ बेची जाह्ये अरु उ करजो चुकय दियो जाये. ");
INSERT INTO goj_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","येका पर उ सेवक ने ओका पाय पर गिरी खे ओखे प्रणाम कऱ्यो, अरु बोल्यो, हे स्वामी तुम धीरज धर मी सब कुछ भरी दुयु. ");
INSERT INTO goj_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","तब उ सेवक का स्वामी ने दया खय खे ओखे छोडी दियो, अरु ओको करजो माफ कऱ्यो. ");
INSERT INTO goj_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“पन जब उ सेवक बाहेर नीकल्यो, ते ओका सब, सेवक होन मे से ओखे मील्या, जो ओका सौ सिक्का को कर्जदार थो. ओने ओखे पकड्यो, ‘ओका गलो दबायो अरु बोल्यो, जो कुछ तरा पर कर्जो हइ भरी दे.’ ");
INSERT INTO goj_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","येका पर ओका सात का सेवक होन ओका पाय पर गिरी खे, अरु ओकासे प्रार्थना करण लग्यो. कि धीरज धर मी सब भरी दुयु. ");
INSERT INTO goj_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","ओने नी मान्यो, पन जय खे ओखे बन्दीगृह मे डाली दियो. कि जब तक कर्जा खे भरी नी दिये तब तक व्हा ऱ्हेये. ");
INSERT INTO goj_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","ओका सात का सेवक यो जो हुयो थो देखी खे उदास हुया, अरु अपना स्वामी खे पुरो हाल बतय दियो. ");
INSERT INTO goj_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","तब ओका स्वामी ने ओखे बुलय खे अरु ओकासे बोल्यो, ‘हे दुष्ट सेवक, तोने जो मरासे प्रार्थना करी, ते मेने उ तरा पुरो कर्जो माफ कऱ्यो. ");
INSERT INTO goj_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","येका लिये जसो मेने तरा पर दया करी, असो ही का तोखे भी अपना सात का सेवक पर दया करणो नी चातो थो?’ ");
INSERT INTO goj_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","अरु ओका स्वामी ने घुस्सा मे अय खे ओखे जाल मे भेजी दियो, कि जब तक उ सब कर्जो भरी नी दिये तब तक व्हा पर ऱ्हीहे.” ");
INSERT INTO goj_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","यो प्रकार अगर तुम मे से हर एक, “अपना भैइ खे मन से माफ नी करस ते मरो बाप जो स्वर्गीय मे हइ, तोखे भी माफ नी कर्‍हे.” ");
INSERT INTO goj_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","जब यीशु ने या बात बोली दी, ते उ गलील से चली गयो. अरु यहूदीया का परदेस मे यरदन नद्दी का पार आयो. ");
INSERT INTO goj_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","अरु बडी गर्दी ओका पुछे हुये ली, अरु ओने उनखे व्हा अच्छो कऱ्यो. ");
INSERT INTO goj_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","तब फरीसी ओकी परीक्षा करण का लिये ओका पास अय खे बोलन लग्या, “का हर एक कोय भी कारण से अपनी लुगेन खे छोडनो अच्छो हइ का?” ");
INSERT INTO goj_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","ओने उन खे उत्तर दियो, “तुम ने शास्त्र मे नी पढ्यो, जेने उनखे बनायो ओने पैयलेसे से अदमी अरु लुगेन बनय, ");
INSERT INTO goj_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","येका करण इन्सान अपना माय बाप से अलग हुइ खे अपनी लुगेन का सात ऱ्हेस अरु वे दो झना एक तन हुये? ");
INSERT INTO goj_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","अत: वे अब दो नी पन एक तन हइ येका लिये जेने परमेश्वर ने जोड्यो हइ, ओखे इन्सानहोन अलग नी करस.” ");
INSERT INTO goj_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","ओने यीशु से बोल्यो, “फिर मूसा ने का यो ठयरायो की फारकती दीखे ओखे छोडी दे?” ");
INSERT INTO goj_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","यीशु ने उनका से बोल्यो, “मूसा ने तुमारा मन की कठुरता करण तोखे अपनी लुगेन खे छोडी देन की अनुमति दी, पन पैयले से पैयले असो नी थो. ");
INSERT INTO goj_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","अरु मी तुम से बोलुस हइ, कि जो कोय व्यभिचार खे छोडी खे अरु कोय करण से अपनी लुगेन खे तरास कर्‍हे ते दुसरी से भ्याव कर्‍हे, उ व्यभिचार करस हइ.” ");
INSERT INTO goj_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","सेवक होन ने ओकासे बोल्यो, “अगर अदमी अरु लुगेन का बिच मे असी बात हइ ते यो अच्छो हइ की भ्याव नी कर्‍हे.” ");
INSERT INTO goj_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","ओने उनका से बोल्यो, “सब भ्याव का बिना नी ऱ्ही सकस, फक्त वे जेखे यो दान दियो गयो हइ. ");
INSERT INTO goj_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","क्युकी कुछ नपुसक असो हइ जो माय का पेट मे से असो जन्म लेस अरु कुछ नपुसक असो हइ, जेखे इन्सान ने नपुसक बनायो: अरु कुछ नपुसक असो हइ, जेने स्वर्ग को राज्य का लिये अपना आप खे नपुसक बनायो हइ, जो येखे अपनायो करी सकस हइ उ अपनास हइ.” ");
INSERT INTO goj_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","तब दुन्याहोन ने बच्चाहोन खे ओका पास लाया, कि उ उन पर हात रखी खे अरु प्रार्थना कर. पर सेवक होन ने उन खे धमकय दियो. ");
INSERT INTO goj_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","यीशु ने बोल्यो, “बच्चाहोन खे मरा पास आन दे, अरु उन खे मना नी करणु क्युकी स्वर्ग को राज्य इनका जसो ही हइ.” ");
INSERT INTO goj_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","अरु उ उन पर हात रखी खे व्हा से चली गयो. ");
INSERT INTO goj_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","अरु एक इन्सान ने ओका पास अय खे ओकासे बोल्यो, “हे गुरु मी कोन सो अच्छो काम करु कि मी अनन्त जिवन मील्हे?” ");
INSERT INTO goj_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","ओने ओकासे बोल्यो, “तू मरा से भलाइ का बारे मे पुछस हइ? अच्छो नी हइ. पर अगर तू जिवन मे प्रवेश करणो चास हइ, ते आज्ञाहोन खे मानीले.” ");
INSERT INTO goj_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","ओने ओकासे बोल्यो, “कोन सी आज्ञा?” यीशु ने बोल्यो, “की कोय खे मारनु नी करणु, अरु व्यभिचार नी करणु, अरु चोरी नी करणु, अरु झुठी गवाही नी देनु. ");
INSERT INTO goj_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","अपना बाप अरु अपनी माय को आदर करणो, अरु अपना घर का बाजु आला से अपना जसो प्रेम रखनो.” ");
INSERT INTO goj_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","उ जवान ने ओकासे बोल्यो, “या सब खे ते मेने मानी ली हइ अब मरा मे अरु कोय बात की कमी नी हइ?” ");
INSERT INTO goj_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","यीशु ने ओकासे बोल्यो, “अगर तु सिध्द होनु चास हइ. ते जा, अपनो सब कुछ बेची खे गरीबहोन खे बाटी दे. अरु तोखे स्वर्ग मे धन मीले. अरु अय खे मरा पीछे हुये ले.” ");
INSERT INTO goj_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","पन उ जवान या बात सुनीखे उदास हुइ खे चली गयो, क्युकी उ भोत धनी थो. ");
INSERT INTO goj_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","तब यीशु ने अपना सेवक होन से बोल्यो, “मी तुम से सच्ची बोलुस हइ, कि धनवान इन्सान खे स्वर्ग का राज्य मे प्रवेश करणो भोत कठीन हइ. ");
INSERT INTO goj_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","फिर मी तुम से बोलुस, कि परमेश्वर को राज्य मे धनवान इन्सान को प्रवेश करणा से उट, सूइ का नाक मे से नीकली खे जानो सहज हइ.” ");
INSERT INTO goj_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","यो सूनी खे, सेवक होन भोत चकीत हूइ खे बोल्यो, “फिर कोय को उध्दार हुइ सकस?” ");
INSERT INTO goj_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","यीशु ने उनका तरप देखी खे बोल्यो, “इन्सानहोन से तो यो नी हुये सकस, पन परमेश्वर से सब कुछ हुये सकस हइ.” ");
INSERT INTO goj_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","येका पर पतरस ने ओकासे बोल्यो, “देख, हमने तो सब कुछ छोडी खे तरा पीछे हुये लिया हइ ते हम खे का मीले?” ");
INSERT INTO goj_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","यीशु ने उनका से बोल्यो, मी तुम से सच्ची बोलुस हइ की नवा जमाना मे जब इन्सान को बेटो अपनी महिमा का सिंहासन पर बठे, ते तुम भी जो मरा पिछे हुये लिया हइ, बारा सिहासनहोन पर बठि खे अरु इस्राएल का बारा कुलहोन को न्यान कर्‍हे. ");
INSERT INTO goj_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","अरु जो कोय ने घरहोन, या भैइ, या भैइन, या बाप, या माय, या बाल-बच्चा, या खेत, खे मरा नाम का लिये छोडी दियो हइ ओखे सौ बुरो मीलस, अरु उ अनन्त जिवन को अधिकार हुये. ");
INSERT INTO goj_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","पन भोत सारा जो पैयले हइ, वे दुसरा हुये. अरु जो दुसरा हइ, वे पैयले हुये. ");
INSERT INTO goj_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","स्वर्ग को राज्य कोय गृहस्थ का जसो हइ, जो फजर खे नीकलस कि अपना अंगूर कि बाडी मे मजुरहोन को लानो. ");
INSERT INTO goj_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","अरु ओने मजुरहोन से एक दिन मजुरी पर ठहरायो, उन खे अपना अंगूर कि बाडी मे भेज्यो. ");
INSERT INTO goj_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","फिर पहर को एक दीन चढ्यो ओने नीकली खे कुछ दुन्या खे बजार मे बेकार खडो देखी खे, ");
INSERT INTO goj_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","अरु उनका से बोल्यो, तुम भी अंगूर की बाडी मे जा, अरु जो कुछ योग्य हइ, तुम खे दियु. तब वे भी गया. ");
INSERT INTO goj_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","फिर ओने दुसरा अरु तीसरा पार का बाहेर नीकली खे असो ही कऱ्यो. ");
INSERT INTO goj_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","अरु संज्जा का पाच बजे फिर उ नीकली खे दुसरा खे खडो देख्यो, अरु ओकासे बोल्यो तुम का ह्या दीन भर बेकार खडा ऱ्हेस? उनने ओकासे बोल्यो, ");
INSERT INTO goj_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","येकालिये कि कोय हमखे काम पर नी लगाय. ओने उनका से बोल्यो, तुम भी अंगूर की बाडी जा. ");
INSERT INTO goj_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“प्रभु ने संज्जा खे अंगूर की बाडी का मालीक ने अपना मुकडदम से बोल्यो, मजुरहोन खे बुलय खे पिछला से लिखे पैयले तक उन खे मजुरी दी दे. ");
INSERT INTO goj_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","जब वे आया, जो पाच बजे ही मजुरी लगय गया था, ते उनखे एक-एक सिक्का मील्या. ");
INSERT INTO goj_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","जो पैयले आया था, उनखे भी समझ मे आयो, की हम खे जादा मील्हे. पन उन खे भी एक एक सिक्का य मील्यो. ");
INSERT INTO goj_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","जब मील्यो, ते उ घर का मालीक पर घुस्सा हुये खे बोलन लग्यो, ");
INSERT INTO goj_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","यो पिछेआला ने एक ही घंटो काम कऱ्यो, अरु तोने उनखे हमारा बरोबर करी दियो, जेने दिन भर भार उठायो अरु घाम खायोस? ");
INSERT INTO goj_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","ओने उनका से एक खे उत्तर दियो, हे दोस्त, मी तरा से कुछ अन्याय नी करुस. का तोने मरासे एक चान्‍दी को सिक्का नी ठहरायो थो? ");
INSERT INTO goj_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","जो तरो हइ, उठ्य ले, अरु चली जा. मरी इच्छा या हइ की जेतनो तोखे, येतनो ही उ दुसरा खे भी दुयु. ");
INSERT INTO goj_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","का यो उचित नी की मी अपना माल से जो चाहु असो ही करु? का तू मरा भला होन का कारण मरा तरप बूरी नजर से देखस हइ का?” ");
INSERT INTO goj_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","उजालो जो अगलो हइ, “यो प्रकार जो आखरी अरु जो पयलो, हइ वे आखरी हुये जाये.” ");
INSERT INTO goj_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","यीशु यरुशलेम खे जास हुये बारा सेवक होन खे एकात जगा मे ली गयो, अरु रस्ता मे उनका से बोलन लग्यो. ");
INSERT INTO goj_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“देख, हम यरुशलेम खे जास हइ. अरु इन्सान को बेटो मुख्य याजकहोन अरु पंडीतहोन का हात पकडि जानो अरु वे ओखे मृत्यु दण्ड का योग्य ठहरास. ");
INSERT INTO goj_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","अरु ओखे गैरयहूदीहोन का हात मे सोपे, कि वे ओखे मजाक मे उडाये जाये, अरु कोडा मारी खे, अरु क्रुस पर चेडाये अरु उ तीसरा दिन जिन्दो कर्ह्यो जाह्ये.” ");
INSERT INTO goj_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","फिर जब्दी का बेटाहोन की माय ने अपना बेटाहोन का सात यीशु का पास अयखे प्रणाम कऱ्यो, अरु ओकासे कुछ मागन लगी. ");
INSERT INTO goj_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","यीशु ने ओकासे पुच्यो, “तु का चास हइ?” वा ओकासे बोली, “यो बोल, कि मरा ह्या दो बेटा तरा राज्य मे एक तरा डाखोऱ्या तरप अरु एक तरा जवना तरप बठ्यो.” ");
INSERT INTO goj_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","यीशु ने उत्तर दियो, “तु नी जानस की का मागुंस हइ. जो कटोरो मी पीना पर हइ, का तू पी सकस हइ?” यीशु ने ओकासे बोल्यो, “हव पी सकस हइ.” ");
INSERT INTO goj_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","ओने ओकासे बोल्यो, “तु मरो कटोरो ते पिये पर अपना डाखोरा अरु जवना कोय खे बठानो मरो काम नी, पर जेका लिये मरो बाप ने तैयार कऱ्यो गयो, उनका लिये हइ.” ");
INSERT INTO goj_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","यो सुनीखे दस सेवक होन ये दो भैइहोन पर घुस्सा हुया. ");
INSERT INTO goj_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","यीशु ने उन खे पास बुयल खे बोल्यो, “तुम जानस हइ, की गैरयहूदीहोन को अधिकारी उन पर प्रभुता करस हइ. अरु जो बडा हइ, वे उन पर अधिकार जतास हइ. ");
INSERT INTO goj_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","पन तुम मे असो नी हुये. पन जो कोय तुम मे बडो होनु चास, उ तुमारो सेवक होन खे बनस. ");
INSERT INTO goj_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","अरु जो तुम मे मुखियो होनु चास उ तुमारो सेवक बनस. ");
INSERT INTO goj_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","जसो की इन्सान को बेटो, उ येकालिये नी आयो की अपनी सेवा करवास, पन येकालिये आयो की सेवा कर्‍हे अरु भोत झना का लिये अपनी जान दिये.” ");
INSERT INTO goj_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","जब यीशु अरु ओका सेवक यरीहो से नीकली रा था, ते एक बडि गर्दी ओका पीछे हुइ ली. ");
INSERT INTO goj_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","अरु दो अंधा, जो सडक का धुरो पर बठ्या था, यो सुनीखे कि यीशु जय रोस हइ, “बुलय खे बोलन लग्या, हे प्रभु, दाउद का बेटा, हम पर दया कर.” ");
INSERT INTO goj_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","दुन्याहोन ने उनखे गाली दी, खे चुप ऱ्हे, ओखे धमकय खे बोलन लग्या, हे प्रभु, दाउद का बेटा, हम पर दया कर. ");
INSERT INTO goj_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","तब यीशु ने खडो हूइ खे, उनखे बुलायो, अरु बोल्यो, “तुम का चास हइ की मी तुमारा लिये का करु?” ");
INSERT INTO goj_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","उनने ओकासे बोल्यो, “हे प्रभु, यो की हमारी आख खुली जाये.” ");
INSERT INTO goj_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","यीशु ने दया खय खे उनकी आखहोन खे पकड्या, अरु वे झल्दी देखन लग्या. अरु ओका पीछे हुइ लिया. ");
INSERT INTO goj_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","जब यीशु ओका सेवक यरुशलेम का नजीक पोच्या अरु जैतून का झाड पर बैतफगे का पास आया, ते यीशु ने दो सेवक होन खे यौ बोलीखे भेज्यो, ");
INSERT INTO goj_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","अपना सामने का गाव मे जा, व्हा पोचते ही एक गधी बाधी हइ, अरु ओका सात बच्चा होन तुम खे मील्हे. उन खे खोली खे, मरा पास लिखे आ. ");
INSERT INTO goj_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","अगर तुम से कोय कुछ बोले, ते ओखे बोल, की प्रभु खे इनकी जरुरत हइ तब उ झल्दी उनखे भेजी दिये. ");
INSERT INTO goj_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","यो येका लिये हुयो, की जो वचन भविष्यव्दक्ता का वजेसे बोल्यो गयो थो का उ पुरो हुये ");
INSERT INTO goj_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“सिय्योन कि बेटी से बोल, देख, तरो राजो तरा पास आस हइ. उ नम्र हइ अरु गधी पर बठ्यो हइ. जब गधी का बच्चा पर”. ");
INSERT INTO goj_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","सेवक होन ने जय खे जसो यीशु ने उनका से बोल्यो थो, असो ही कऱ्यो. ");
INSERT INTO goj_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","अरु गधी अरु बच्चाहोन खे लयखे, उन पर अपना कपडा डाले, अरु यीशु ओका पर बठी गयो. ");
INSERT INTO goj_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","अरु भोत सारा दुन्याहोन ने अपना कपडा खे रस्ता मे बिछायो, अरु दुन्याहोन ने झाड से डग्‍यान तोडी खे रस्ता मे बिछायो. ");
INSERT INTO goj_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","अरु जो गर्दी आगेजानआली अरु पीछे से आनवाली खे बुलय-बुलय खे बोलन लगी, “दाउद का बेटा को जय हुये. धन्य हइ उ जो प्रभु का नाम से आस हइ, बद्दल मे होशन्ना.” ");
INSERT INTO goj_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","जब ओने यरुशलेम मे प्रवेश कऱ्यो, ते सब नगर मे भाग दोड मची गइ. अरु दुन्या बोलन लग्या, “की यो कोन हइ?” ");
INSERT INTO goj_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","“दुन्याहोन ने बोल्यो, यो गलील को नासरत को भविष्यव्दक्ता यीशु हइ” ");
INSERT INTO goj_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","यीशु ने परमेश्वर की मन्‍दिर मे जयखे, उन सब खे, जो मन्‍दिर मे लेनो-देनो करी रा था, नीकली दियो. अरु साफ का मेज अरु कबूतर खे बेचनआला खे चौकी उलटय दी. ");
INSERT INTO goj_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","अरु ओने बोल्यो, “शास्त्र मे लिख्यो हइ, अरु परमेश्वर ने बोल्यो हइ की मरो घर प्रार्थना को घर बोलस हइ. पन तुम येखे लुटेरा को अडो बनास हइ.” ");
INSERT INTO goj_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","अरु अंधा अरु लगडा, मन्‍दिर मे ओका पास आया, अरु ओने उनखे अच्छो कऱ्यो. ");
INSERT INTO goj_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","पन जब प्रधान याजकहोन अरु पंडीतहोन ने यो बडो काम खे, जो ओने कऱ्यो, अरु लगडा खे मन्‍दिर मे दाउद का बेटा खे होशन्ना, बोलते हुये देख्यो, ते वे घुस्सा हुया, ");
INSERT INTO goj_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","अरु ओकासे बोलन लग्या तू सुनस हइ की यो, “बोलस हइ?” यीशु ने उनका से बोल्यो, “हव, तुम ने यो शास्त्र मे कभी पढ्यो नी बालकहोन अरु दूध पीता बच्चाहोन का मुडा से तोने स्तुती सिध्द करी?” ");
INSERT INTO goj_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","तब उ उनखे छोडी खे नगर का बाहेर बैतनीय्याह गाव मे गयो, अरु व्हा रात बितय. ");
INSERT INTO goj_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","दुसरा दिन खे जब उ नगर खे लोटी रो थो, ते ओखे भुख लगी. ");
INSERT INTO goj_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","अरु अंजीर का झाड खे सडक का किनारा पर देखी खे उ ओका पास गयो, अरु पता खे छोडी खे ओमे अरु कुछ नी पय खे ओकासे बोल्यो, “अभी से तरा मे कभी फल नी लगन का,” अरु अंजीर को झाड झल्दी सुखी गो. ");
INSERT INTO goj_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","यो देखी खे सेवक होन ने अचम्बो कऱ्यो अरु बोल्यो, “यो अंजीर को झाड झल्दी कसो सुखी गयो?” ");
INSERT INTO goj_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","यीशु ने उनखे उत्तर दियो, “मी तुम से सच्ची बोलुस हइ. अगर तुम विश्वास रखे ते, अरु दुर नी कर्‍हे. ते फक्त यो कर्‍हे, जो यो अंजीर का झाड से कऱ्यो गयो हइ. पन अगर या टेकडी से भी बोले की उखडी जा अरु समुदर मे जा पड ते यो हुये जाये. ");
INSERT INTO goj_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","अरु जो कुछ तुम प्रार्थना मे विश्वास से मागे उ सब तुम खे मीले.” ");
INSERT INTO goj_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","यीशु मन्‍दिर मे फिर से जयखे शिक्षा करण लग्यो, की प्रधान याजक अरु दुन्याहोन बापदादा ने ओका पास अयखे पुछ्यो, “तू यो काम कोनता अधिकार से करस हइ? अरु तोखे यो अधिकार कोने दियो हइ?” ");
INSERT INTO goj_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","यीशु ने उनखे उत्तर दियो, “मी भी तुम से एक बात पुछस हइ, अगर उ मेखे बताये ते मी भी तुमखे बतायु कि यो काम को का अधिकार से करुस हइ. ");
INSERT INTO goj_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","यहून्ना को बपतिस्मा खा से थो? स्वर्ग का तरप से या इन्सान का तरप से थो?” तब वे आपस मे वाद विवाद करण लग्या, “अगर हम बोले ते स्वर्ग का तरप से ते उ हम से बोले की फिर तुम ने ओको विश्वास क्यु नी कऱ्यो?” ");
INSERT INTO goj_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","“अरु अगर बोले, इन्सान का तरप से, ते हम खे गर्दी को डर हइ, क्युकी वे सब यहून्ना खे भविष्यव्दक्ता मानस हइ.” ");
INSERT INTO goj_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","अत उनने यीशु खे उत्तर दियो, “हम नी जानस.” ओने भी उनका से बोल्यो, ते मी भी तुमखे नी बतवू, कि यो काम कोय अधिकार से करुस हइ. ");
INSERT INTO goj_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“तुम का समझस हइ? कोय इन्सान का दो बेटा था. ओने पैयला का पास जयखे बोल्यो हे बेटा आज अंगूर की बाडी मे काम कर. ");
INSERT INTO goj_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","ओने उत्तर दियो मी नी जउ पन बाद मे ओने अपनो मन बदली दियो अरु चली गयो. ");
INSERT INTO goj_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","फिर दुसरा का पास जयखे असो ही बोल्यो प्रभु ने उत्तर दियो, जी हव, जउस हइ, पन नी गयो. ");
INSERT INTO goj_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","ये दो मे से को ने बाप की इच्छा पुरी करी? “उनने बोल्यो, पैयला ने. यीशु ने उनका से बोल्यो, “मी तुम से सच्ची बोलुस हइ चुंगी लेनवालो अरु वेश्या तुम से पैयले परमेश्वर का राज्य मे प्रवेश करी रास हइ. ");
INSERT INTO goj_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","क्युकी यहून्ना धार्मीकता का रस्ता से तुमारा पास आयो, अरु तुम ने ओका पर विश्वास नी कऱ्यो पर चुंगी लेनवाला अरु वेश्याहोन ने ओका पर विश्वास कऱ्यो अरु तुम देखी खे बाद मे भी नी पछतायो की ओका पर विश्वास करी लेता. ");
INSERT INTO goj_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“एक अरु दृष्‍टान्‍त सुन, एक घर थो, जेने अंगूर की बाडी लगय. अरु ओका चारी तरप बादी बाधी. अरु ओने एक रस को कुवो खोद्यो. अरु मचाग बनय. अरु किसानहोन खे ओको ठेको दिखे उ परदेस चली गयो. ");
INSERT INTO goj_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","जब फल को टेम नजीक आयो, ते ओने अपना सेवक होन खे ओका फल लान का लिये किसानहोन का पास भेज्यो. ");
INSERT INTO goj_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","पर किसानहोन ने ओका सेवक होन खे पकडी खे, कोय खे पीटियो, अरु कोय खे मारी डाल्यो. अरु कोय पत्थर माऱ्यो. ");
INSERT INTO goj_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","फिर ओने अरु सेवक होन खे भेज्यो, जो पैयले से जादा था. अरु उनने उनका से भी असो हि कऱ्यो. ");
INSERT INTO goj_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","अन्नत मे ओने अपना बेटा खे उनका पास यो सोची खे भेज्यो, कि वे मरा बेटा को सम्मान कर्‍हे. ");
INSERT INTO goj_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","पन किसानहोन ने बेटा खे देखी खे आपस मे बोल्यो, यो तो वारिस हइ, ओखे भी मारी डालस हइ अरु ओकी सम्पंत्ती ली लेवास. ");
INSERT INTO goj_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","अरु उनने ओखे पकड्यो अरु अंगूर की बाडी से बाहेर नीकाली खे मारी डाल्यो. ");
INSERT INTO goj_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“यीशु ने पुछ्यो, येका लिये जब अंगूर की बाडी को स्वामी आये, ते ये किसानहोन का सात का कर्‍हे? यीशु खे आते देख्यो. ");
INSERT INTO goj_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","“उनने ओकासे बोल्यो, ‘उ वे बुरा दुन्याहोन खे जरुरत खतम कर्‍हे.’ अरु अंगूर की बाडी को ठेको ‘अरु किसानहोन खे दिये जो टेम’ पर ओका फल दियो कर्‍हे.” ");
INSERT INTO goj_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","यीशु ने उनखे उत्तर दियो, तुम ने कभी पवित्रशास्त्र मे यौ नी पढ्यो? जो पत्थर खे राजमिस्त्रीहोन खे नी बुरो समझ्यो थो. उ कोना का माथा को फत्तर हुइ गयो. यो प्रभु का तरप से हुयो; अरु हमारी नजर मे बडो हइ! ");
INSERT INTO goj_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“येका लिये मी तुम से बोलुस हइ, की परमेश्वर, ‘को राज तुम से ली लियो जाये.’ अरु असी जातहोन को जसो ओको फल लास हइ. ");
INSERT INTO goj_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","‘जो यो पत्थर पर,’ गिरी गयो उ चकनाचुर हुये जाये अरु जेका ‘पर उ गिरे, ओखे पिसी डाले.’” ");
INSERT INTO goj_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","प्रधान याजकहोन अरु फरीसी ओका दृष्‍टान्‍तहोन खे सुनीखे समझी गया, की उ हमारा विषय मे बोलस हइ. ");
INSERT INTO goj_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","अरु उनने ओखे पकडनो चायो, पन वे दुन्याहोन से डरी गया क्युकी वे ओखे भविष्यव्दक्ता जानता था. ");
INSERT INTO goj_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","येका पर यीशु ने फिर उनका से दृष्‍टान्‍त मे बोलन लग्यो. ");
INSERT INTO goj_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","स्वर्ग को राज्य उ राजा का जसो हइ, जेने अपना बेटा को भ्याव कऱ्यो. ");
INSERT INTO goj_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","अरु ओने अपना सेवक होन खे भेज्यो, नीवता दिया हुया दुन्याहोन खे भ्याव का खाना मे बुला. पन उनने आनो नी चायो. ");
INSERT INTO goj_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","फिर ओने अरु सेवक होन खे यो बोली खे भेज्यो नीवता दिया हुया दुन्याहोन से बोल देख कि मी खानो तैयार करी चुक्यो हइ, अरु मरा बैल अरु पाल्या हुया जानवर होन माऱ्या गया हइ, अरु सब कुछ तैयार हइ. भ्याव का खाना मे आ. ");
INSERT INTO goj_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","पन वे नीवता खे दिखे येका पर कोय ने ध्यान नी दियो कोय अपना खेत मे, कोय अपना धदा मे. ");
INSERT INTO goj_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","अरु दुसरा दुन्याहोन ने जो बची रा था ओका सेवक होन खे पकडी खे उनको अपमान करी खे मारी डाल्यो. ");
INSERT INTO goj_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","तब राजा खे घुस्सा अह्ये अरु ओने अपना सेना खे भेजी खे वे खुनी होन खे खतम कऱ्यो, अरु उनका नगर खे फुकी दियो. ");
INSERT INTO goj_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","तब ओने अपना सेवक होन से बोल्यो, भ्याव को खानो तैयार हइ, पन नीवता दिया दुन्याहोन लायक नी रुख्या. ");
INSERT INTO goj_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","येका लिये चौक मे जा, अरु जतना दुन्या तुम खे मीलस, सब खे भ्याव का खाना मे बुलय ला. ");
INSERT INTO goj_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","वे सेवक होन ने सडक पर जय खे का बुरा का भला, जेतना मील्या, सब खे जमा कऱ्या. अरु भ्याव को घर मीजवान होन से भरी गयो. ");
INSERT INTO goj_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“जब राजा मीजवानहोन खे देखन खे अंदर आयो. ते ओने व्हा एक इन्सान खे देख्यो, जो भ्याव का कपडा नी पेन्यो थो. ");
INSERT INTO goj_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","ओने ओकासे पुछ्यो, हे दोस्त. तू भ्याव का कपडा पेने बिना ह्या काय का लिये आयो? अरु उ इन्सान चुप हुय गयो. ");
INSERT INTO goj_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","तब राजा ने सेवकहोन से बोल्यो. येका हात-पाय बाधीखे ओखे बाहेर अंधारा मे डाली दे, उ रोन लग्यो, अरु दात पीसन लग्यो. ");
INSERT INTO goj_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","क्युकी बुलाया हुया ते भोत हइ पन चुन्या हुया जरासा हइ.” ");
INSERT INTO goj_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","तब फरीसीहोन ने जय खे आपस मे बिचार करी, की येखे सवाल पुछी खे कसो फसावा. ");
INSERT INTO goj_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","उनने अपना सेवक होन खे हेरोदिया का सात ओका पास यो बोली खे भेज्यो, “हे गूरु, हम जानस हइ, की सच्ची हइ, अरु परमेश्वर की रस्ता सच्चाइ से सिखस हइ, अरु कोय को भेदभाव नी करस हइ, क्युकी तू इन्सान का मुंडा देखी खे बात नी करस हइ. ");
INSERT INTO goj_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","येका लिये हम खे बता तु का समझस हइ? कैसर खे कर देनो अच्छो हइ, की नी.” ");
INSERT INTO goj_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","यीशु ने उनका दृष्‍टान्‍त जानीखे बोल्यो, “हे कपटिहोन, इन्सान होन मेखे क्यु परखस हइ? ");
INSERT INTO goj_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","कर को सिक्को मेखे बता.” तब वे ओका पास एक सिक्को लीखे आया. ");
INSERT INTO goj_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ओने उनका से पुछ्यो, “यो चित्र अरु नाम कोको हइ?” ");
INSERT INTO goj_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","उनने ओकासे बोल्यो, कैसर को. तब ओने उनका से बोल्यो, “जो कैसर को हइ, उ कैसर खे दे. अरु जो परमेश्वर को हइ, उ परमेश्वर खे दे.” ");
INSERT INTO goj_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","यो सुनीखे उनखे अचम्बो कऱ्यो, अरु ओखे छोडी खे वे चली गया. ");
INSERT INTO goj_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","उ दीन सदूकि जो बोलस हइ की मऱ्या हुया को पुनरुत्थान हइ की नी ओका पास आयो, अरु ओकासे पुछ्यो, ");
INSERT INTO goj_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“हे गुरु, मूसा ने बोल्यो थो, की अगर कोय बिना बेटा को मरी जाये ते ओको भैइ ओकी लुगेन का सात भ्याव करी खे अपना भैइ का लिये कुल पइदा कर्‍हे. ");
INSERT INTO goj_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","अभी हम ह्या सात भैइ था. पयलो भ्याव करीखे मरी गयो. अरु बेटा नी होन का कारण अपनी विधवा लुगेन खे अपना भैइ का लिये छोडी गयो. ");
INSERT INTO goj_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","यो प्रकार दुसरा ने अरु तीसरा ने भी कऱ्यो, अरु सात तक यो चलतो ऱ्हियो. ");
INSERT INTO goj_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","सब का बाद मे वा बय भी मरी गय. ");
INSERT INTO goj_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","जिन्दो उठना पर वा वे सात मे से कोकी लुगेन हुये? क्युकी वा सब की लुगेन हुय चुकी थी.” ");
INSERT INTO goj_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","यीशु ने उनखे उत्तर दियो, “तुम पवित्रशास्त्र अरु परमेश्वर की सामर्थ्य नी जानस. यो कारण बडी भूल मे पडी गो हइ. ");
INSERT INTO goj_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","क्युकी जिन्दी उठना पर भ्याव नी कर्‍हे अरु नी भ्याव मे दियो जाये. पन वे स्वर्ग का दूत का सामने हुये. ");
INSERT INTO goj_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","पन मऱ्या हुया का जिन्दी उठन का विषय मेका तुम ने यो वचन नी पढ्यो जो परमेश्वर ने तुम से बोल्यो: ");
INSERT INTO goj_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","मी अब्राहम को परमेश्वर, अरु इसहाक को परमेश्वर, अरु याकूब को परमेश्वर हइ? उ मऱ्या हुया को नी, पन जिन्दा को परमेश्वर हइ.” ");
INSERT INTO goj_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","जब यो सुनीखे यीशु कि शिक्षा पर दुन्या चकीत हुया. ");
INSERT INTO goj_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","जब फरीसीहोन ने सुनी खे यीशु ने सदूकिहोन को मुंडो बन्द करी दियो. ते वे जमा हुया. ");
INSERT INTO goj_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","अरु ओमे से एक व्यवस्था का मास्तर ने परखन का लिये ओकासे पुछ्यो, ");
INSERT INTO goj_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“हे गुरु, व्यवस्था मे कोन सी सब से आज्ञा बडी हइ?” ");
INSERT INTO goj_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","ओने ओकासे बोल्यो, “तू परमेश्वर अपना जान से अपना सब मन अरु अपनी सब जान अरु अपनी पुरी दिमाक का सात प्रेम रख. ");
INSERT INTO goj_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","बडी अरु मुख्य आज्ञा ते या हइ. ");
INSERT INTO goj_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","असा मे दुसरा सब से बडी आज्ञा हइ, की तू अपना पडोसी से अपना जसो प्रेम रख. ");
INSERT INTO goj_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","ये दो आज्ञा होन सब व्यवस्था अरु भविष्यव्दक्ताहोन को आधार हइ.” ");
INSERT INTO goj_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","जब फरीसी जमा था, ते यीशु ने उनका से पुछ्यो, ");
INSERT INTO goj_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“मसीह का विषय मे तुम खे समझस हइ? उ कोको बेटो हइ?” उनने ओकासे बोल्यो,? “दाउद को.” ");
INSERT INTO goj_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","“ओने उनका, से पुछ्यो,” ते दाउद आत्मा मे “हुइ खे ओखे ‘प्रभु का’? बोलस हइ, ");
INSERT INTO goj_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“ प्रभु ने, मरा प्रभु से बोल्यो, मरा जवना तरप बठ जब तक की मी तरा दुसमन होन खे तरा पाय का नीचे नी करी दियु जब तक मरा पास बठ. ");
INSERT INTO goj_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","जब दाउद ओखे प्रभु बोलस हइ, ते उ दाउद ओको बेटो कसो बन्यो?” ");
INSERT INTO goj_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","ओका उत्तर मे कोय भी एक बात नी बोली सक्यो. पन उ दिन से कोय खे फिर ओका से कुछ पुछन को साहस नी हुयो. ");
INSERT INTO goj_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","तब यीशु ने गर्दी से अरु अपना सेवक होन से बोल्यो, ");
INSERT INTO goj_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“पंडीत अरु फरीसी मूसा कि गद्दी पर बठ्या हुया व्यवस्था को अर्थ बतास हइ. ");
INSERT INTO goj_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","येका लिये वे तुम से जो कुछ बोल्ये उ करणू, अरु माननु, पन ओका जसो काम मत करणु. क्युकी वे बोलस हइ पर कर्हे नी. ");
INSERT INTO goj_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","उ एक असो भारी बोझ खे जेखे उठानो कठीन हइ, बाधीखे उनखे इन्सानहोन का खांदा पर रखस हइ. पन तुम ओखे अपनी उगली से भी सरकानो नी चास. ");
INSERT INTO goj_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","वे अपना सब काम खे दुन्याहोन खे बतान का लिये करस हइ वे अपनी ताबीज खे चौडी करस, अरु अपना कपडा की झालर खे बडास हइ. ");
INSERT INTO goj_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","खाना मे मुख्य-मुख्य जगा, अरु आराधनालयहोन मे मुख्य-मुख्य जगा, ");
INSERT INTO goj_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","अरु बजार मे नमस्कार अरु इन्सान मे गुरु बोलनो उनखे भास हइ. ");
INSERT INTO goj_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","पन तुम गुरु नी बोलस, क्युकी तुमारो एक ही गुरु हइ अरु तुम एक ही भैइ अरु भैइन हुये. ");
INSERT INTO goj_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","अरु पृथ्वी पर कोय खे अपनो बाप नी बोलनु, क्युकी तुम्हारो एक ही बाप हइ, जो स्वर्ग मे हइ. ");
INSERT INTO goj_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","अरु स्वामी भी नी बोलनु, क्युकी तुमारो एक ही मास्तर हइ, यानेकी मसीह. ");
INSERT INTO goj_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","जो तुम मे से बडो हुय खे उ तुमारो सेवक बन्ये. ");
INSERT INTO goj_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","जो कोय अपना आप खे बडो बनाये, उ छोटो कऱ्यो जाये अरु जो कोय अपना आप खे छोटो बनाये, उ बडो कऱ्यो जाये. ");
INSERT INTO goj_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“हे कपटि पंडीतहोन अरु फरीसीहोन तुमारा पर हाय! तुम इन्सानहोन का बदल मे स्वर्ग का राज्य को दरवाजो बन्द करस हइ, नी ते खुद मे ओमे प्रवेश करस हइ अरु नी ओमे प्रवेश करण आला खे प्रवेश करण देस हइ. ");
INSERT INTO goj_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","हे कपटी पंडीतहोन अरु फरीसीहोन, तुम पर हाय! तुम विधवा होन का घर खे जास हइ, अरु बतान का लिये बडि देर तक प्रार्थना करतो ऱ्हेस हइ येका लिये तुमखे जादा दण्ड मील्ये. ");
INSERT INTO goj_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“हे कपटि पंडीतहोन अरु फरीसीहोन तुम पर हाय! तुम एक जन खे अपना मोत मे लान का लिये सब नदी अरु थल मे फिरस; अरु जब उ मोत मे ए जास हइ, ते उ अपना से डबल नरक का लिये बनी जास हइ. ");
INSERT INTO goj_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“हे अंधा सेवकहोन, तुम पर हाय! ‘जो बोलस हइ कि अगर कोय मन्‍दिर की कसम खास ते कुछ नी, पन अगर कोय मन्‍दिर का सोन्ना की कसम खास ते ओकासे बंधय जास.’ ");
INSERT INTO goj_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","हे मुर्ख, अरु अंधो, कोन बडो हइ, सोन्नो या उ मन्‍दिर जेका से सोन्नो पवित्र होस हइ? ");
INSERT INTO goj_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","फिर बोलस हइ कि अगर कोय वेदी कि कसम खाये ते कुछ नी, पन जो दान ओका पर हइ, अगर कोय ओकी कसम खाये ते बंधय जाह्ये. ");
INSERT INTO goj_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","हे अंधा, कोन बडो हइ, दान या वेदी जेका से दान पवित्र होस हइ? ");
INSERT INTO goj_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","येका लिये जो वेदी की कसम खास हइ, उ ओकी, अरु जो कुछ ओका पर हइ, ओकी भी कसम खास हइ. ");
INSERT INTO goj_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","अरु जो मन्‍दिर कि कसम खास हइ, उ ओकी अरु ओमे र्‍हेनआला परमेश्वर की भी कसम खास हइ. ");
INSERT INTO goj_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","अरु जो स्वर्ग कि कसम खास हइ, उ परमेश्वर की राजगद्दी की अरु ओका पर बठनआला की भी कसम खास हइ. ");
INSERT INTO goj_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“हे कपटि पंडीतहोन, अरु फरीसीहोन, तुम पर हाय! तुम पुदीना अरु सौफ अरु जीरा को दसवा भाग देस हइ, पन तुम ने व्यवस्था की गम्भीर बात यानेकी न्याय, अरु दया, अरु विश्वास खे छोडी दियो हइ. चातो थो की या बात खे भी करस ऱ्हेस, अरु वा बात खे भी नी छोडनु. ");
INSERT INTO goj_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","हे अंधा अगुवाहोन, तुम माखा खे ते छानी डालस हइ, पन उट खे गिली लेस हइ. ");
INSERT INTO goj_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“हे कपटि पंडीतहोन, अरु फरीसीहोन, तुम पर हाय! तुम कटोरा अरु ठाटी खे उपर उपर से ते मांजस हइ पन वे अंदर से अंधारा अरु लालच से लुटी हूइ बात से भरी हुइ हइ. ");
INSERT INTO goj_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","हे अंधा फरीसी, पैयले कटोरा अरु ठाटी खे अंदर से मांज कि वे बाहेर से भी अच्छी हुये. ");
INSERT INTO goj_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“हे कपटि पंडीतहोन, अरु फरीसीहोन, तुम पर हाय! तुम चुना से पोती हुइ कब्र का जसा हइ जो उपर से ते अच्छी दिखइ देस हइ, पन अंदर मुर्दा की हड्डीहोन अरु सब प्रकार की गंदकी से भरी हइ. ");
INSERT INTO goj_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","या रिती से तुम भी उपर से इन्सानहोन खे धर्मी दिखइ देस हइ, पन अंदर से कपट अरु बुरा से भऱ्या हुया हइ. ");
INSERT INTO goj_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“हे कपटि पंडीतहोन,अरु फरीसीहोन, तुम पर हाय! तुम भविष्यव्दक्ताहोन कि कब्र बनास हइ अरु धर्मीहोन कि कब्र सजास हइ. ");
INSERT INTO goj_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","अरु बोलस हइ, अगर हम अपना बापदादा का दिन मे होस ते भविष्यव्दक्ताहोन कि खुन मे उनका सात मे नी होस. ");
INSERT INTO goj_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","येका से ते तुम अपना हि खिलाप मे गवइ देस हइ, की तुम भविष्यव्दक्ताहोन खे मारनआलो का बेटा हुये. ");
INSERT INTO goj_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","तुम अपना बापदादा को पाप को घडो भरी दे. ");
INSERT INTO goj_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","हे साप, अरु साप का बच्चाहोन, तुम नरक का दण्ड से कसा बच्ये? ");
INSERT INTO goj_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","येका लिये देख, मी तुमारा पास भविष्यव्दक्ताहोन अरु दिमाकआला अरु शास्त्रिहोन खे भेज्यो हइ. अरु तुम ओमे से कुछ खे मारी डाल्ये, अरु क्रुस पर चेढाये. अरु कुछ खे अपना आराधनालयहोन मे कोडा मार्ये, अरु एक नगर से दुसरा नगर मे भाकता फिरे. ");
INSERT INTO goj_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","जेका से धर्मी हाबिल से लीखे बिरीक्याह को बेटो जकर्याह तक, जेखे तुम ने मन्‍दिर अरु वेदी का बीच मे मारी डाल्यो थो, जेने धर्मीहोन को खुन जमीन पर बोहय गो थो, उ सब तुमारा माथा पर आह्ये. ");
INSERT INTO goj_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","मी तुम से सच्ची बोलुस हइ, या सब बात या कुटुम्ब का दुन्याहोन पर ए गीरे. ");
INSERT INTO goj_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“हे यरुशलेम, हे यरुशलेम! तू जो भविष्यव्दक्ताहोन खे मारी डालस हइ, अरु जो तरा पास भेज्यो गयो, उनखे पत्थराव करस हइ केतना ही बार मेने चायो की जसा मुर्गी अपना बच्चाहोन खे अपना पंख का नीचे जमा करस हइ, असो ही मी भी तरा बच्चाहोन खे जमा करी खे, पन तुम ने नी चायो. ");
INSERT INTO goj_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","देख, तुमारो घर तुमारा लिये उजाड छोड्यो जास हइ. ");
INSERT INTO goj_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","क्युकी मी तुम से बोलुस हइ, की अभी से जब तक तुम नी बोले धन्य हइ उ ‘जो प्रभु नाम से आस हइ तब तक तुम मेखे फिर कभी नी देखनका.’” ");
INSERT INTO goj_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","जब यीशु मन्‍दिर से नीकलीखे जय रो थो, ते ओका सेवक होन ओखे मन्‍दिर की रचना बतान का लिये ओका पास आया. ");
INSERT INTO goj_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","ओने ओकासे बोल्यो, “तुम यो सब नी देखस? मी तुम से सच्ची बोलुस हइ, यो पत्थर पर पत्थर भी नी छोड्यो, जो रख्यो नी जाये.” ");
INSERT INTO goj_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","अरु जब उ जैतून की टेकडी पर बठ्यो थो, ते सेवक होन ने अलग से ओका पास अयखे बोल्यो, “हम से बोल की या बात कब हुये? अरु तरो आन को, अरु जगत को अन्त: को का चिन्ह हुये.” ");
INSERT INTO goj_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","यीशु ने उनखे उत्तर दियो, हुशार ऱ्हे! कोय तुमखे फसय नी पाय. ");
INSERT INTO goj_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","क्युकी भोत सा असा हुये जो मरा नाम से अयखे बोले, मी मसीह हइ ,अरु भोत झना खे बिचकय दिह्ये. ");
INSERT INTO goj_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","तुम झगडाहोन अरु झगडाहोन की बातचीत सुने. देख घबऱ्य नी जानु क्युकी उनको होनो जरुरी हइ, पन उ टेम खतम नी हुये. ");
INSERT INTO goj_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","क्युकी राष्ट्र पर राष्ट्र, अरु राज्य पर राज्य चेढ्या कर्‍हे, अरु जगा-जगा अकाल हुय खे अरु भूकम्प हुये. ");
INSERT INTO goj_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","या बात पीडाहोन का पैयले से हुये. ");
INSERT INTO goj_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","तब वे देन का लिये तुमखे पकड्ये, अरु तुमखे मारी डाल्ये अरु मरा नाम का कारण सब राष्ट्रहोन का दुन्या तुम से बैर रख्ये. ");
INSERT INTO goj_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","तब भोत झना ठोकर खाये, अरु एक दुसरा खे पकड्ये, अरु एक दुसरा से बैर रख्ये. ");
INSERT INTO goj_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","भोत सा झुठा भविष्यव्दक्ता उठी खे खडा हुये खे अरु भोतझना खे बिचकाये. ");
INSERT INTO goj_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","अरु बुरा का बडना से भोतझना को प्रेम ठण्डो हुइ जाये. ");
INSERT INTO goj_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","पन जो अन्नत तक धीरज धरी खे रखे, ओको उध्दार हुये. ");
INSERT INTO goj_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","अरु राज्य को यो सुसमाचार पुरा जगत मे प्रचार कर्‍यो जाये, कि सब राष्ट्रहोन पर गवाही हुये तब खतम हुइ जाये. ");
INSERT INTO goj_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","येका लिये जब तुम उ खतरनाक घुणित चिज खे जेकी बातचीत दानीएल भविष्यव्दक्ता का वजेसे हुइ थी, पवित्र जगा मे खडी हुइ देख, जो पढ, उ समझ. ");
INSERT INTO goj_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","तब जो यहूदीयाहोन मे हुये वे टेकडी पर भागी जा. ");
INSERT INTO goj_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","जो घर पर छपर हुये, उ अपना घर मे से सामन लेन खे नी उतह्ये. ");
INSERT INTO goj_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","अरु जो खेत मे हुये, उ अपना कपडा लेन खे पीछे नी आह्ये. ");
INSERT INTO goj_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","उ दिन मे जो पेट से अरु दूध पिलान आली हुये, उनका लिये दुख को दिन बोल्यो जाये. ");
INSERT INTO goj_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","अरु प्रार्थना कर. की तुमखे ठंडी मे या आराम का दिन भागनो नी पडे. ");
INSERT INTO goj_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","क्युकी उ टेम असो भी क्लेश हुये, जसो जगत का पैयलेसे अभी तक नी हुयो, अरु नी कभी हुये. ");
INSERT INTO goj_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","अरु अगर उ दिन कम नी हुय जाये, ते कोय जनवर नी बचता. पन चुन्या हुया का कारण उ दिन कम नी हुय जाये. ");
INSERT INTO goj_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","उ टेम अगर कोय तुम से बोले, की देख, मसीह यो हइ! या उ हइ! ते विश्वास नी करणु. ");
INSERT INTO goj_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","क्युकी झुठा मसीह अरु झुठा भविष्यव्दक्ता उठीखे खडा हुये, अरु बडो चिन्ह चमत्कार अरु बडो काम बताये, की अगर हुय सकस ते चुन्या हुया खे भी भयकय दे. ");
INSERT INTO goj_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","देख, मेने पैयले से तुम से या सब कुछ बोली दियो हइ. ");
INSERT INTO goj_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","येका लिये अगर वे तुम से बोल्ये देख, उ जंगल मे हइ, ते बाहेर नी नीकली जानु; देख उ खोलीमे हइ. ते विश्वास नी करणु. ");
INSERT INTO goj_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","क्युकी जसी बिजली पुर्व से नीकलीखे पश्चिम तक चमकती जास हइ, असो ही इन्सान का बेटा खे भी आनो हुये. ");
INSERT INTO goj_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","झा लाश हुये, व्हा घुब्बड जमा हुये. ");
INSERT INTO goj_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","उ दिन क्लेश का बाद झल्दी सुरज अंधारो हुय जाये, अरु चांद को ऊजालो जातो ऱ्हीये, अरु तारा बद्दल से गिरी जाये अरु बद्दल की शक्ति हली जाये. ");
INSERT INTO goj_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","तब इन्सान का बेटा को चिन्ह बद्दल मे बतायो जाये अरु तब पृथ्वी का सब कुल का दुन्या छाती पीट्ये; अरु इन्सान का बेटा की बडी सामर्थ्य अरु महिमा का सात बद्दल का बद्दल पर आते देख्ये ");
INSERT INTO goj_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","अरु उ पिपडी का बडा बोल का सात, अपना स्वर्गदूतहोन खे भेजो, अरु वे बद्दल का या पार से वा पार तक, चारी दिशा से ओका चुन्या हुया खे जमा कर्‍हे. ");
INSERT INTO goj_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","अंजीर का झाड से यो दृष्‍टान्‍त सीख जब ओकी डग्‍यान नाजुक हुय जास अरु पत्ता नीकलन लगस हइ, ते तुम जानी लेस हइ, की गर्मी को टेम पास हइ. ");
INSERT INTO goj_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","या रीति से जब तुम या सब बातहोन खे देख, ते जानी लेस, की उ नजीक हइ, पन दरवाजा पर हइ. ");
INSERT INTO goj_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","मी तुम से सच्ची बोलुस हइ, कि जब तक या बात पुरी नी हुइ जाये, तब तक या पीडी को नाश नी हुये. ");
INSERT INTO goj_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","बद्दल अरु पृथ्वी टली जाये, पन मरो बोल कभी नी टले. ");
INSERT INTO goj_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","उ दिन अरु उ टेम का बारे मे कोय नी जानस, नी स्वर्ग का दूतहोन, अरु नी बेटा होन, पन फक्त बाप. ");
INSERT INTO goj_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","जसो नूह को दिन थो, असा मे इन्सान का बेटो को भी आनो हुये. ");
INSERT INTO goj_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","क्युकी जसो पानी-प्रलय से पैयले का दिन मे, जो दिन तक की नूह डोंगा पर नी चढ्यो थो, उ दिन तक दुन्या खाता-पीता था, अरु ओमे भ्याव शादी होस हइ. ");
INSERT INTO goj_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","अरु जब तक जल-प्रलय अयखे वे सब खे बोह्य खे ली गयो, तब तक उनखे कुछ भी मालुम नी थो. असा मे इन्सान का बेटो को भी आनो हुये. ");
INSERT INTO goj_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","उ टेम दो झना खेत मे हुय खे एक खे ली जाये अरु दुसरा खे छोडी दियो जाये. ");
INSERT INTO goj_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","दो बयहोन चक्की पिसती ऱ्ही जाये, एक ली जाये, अरु दुसरी छोडी जाये. ");
INSERT INTO goj_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","येका लिये जागता ऱ्हे, क्युकी तुम नी जानस की तुम्हारो प्रभु कोनता दिन आह्ये. ");
INSERT INTO goj_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","पन यो जानी ले कि अगर घर का स्वामी खे यो मालुम हुये की चोर कोनता टेम आये ते जागतो ऱ्हेस. अरु अपना घर मे चोरी नी होन देस. ");
INSERT INTO goj_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","येका लिये तुम भी तैयार ऱ्हे, क्युकी जो टेम का बारे मे तुम सोचस भी नी, उ टेम इन्सान को बेटो अय जाये. ");
INSERT INTO goj_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“उ विश्वासयोग्य अरु डिमाकआलो सेवक कोन हइ, जेखे स्वामी ने अपना नौकर चाकर पर मुखियो बनायो, की टेम पर उनखे खानो दिये? ");
INSERT INTO goj_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","अच्छो हइ, उ सेवक, जेखे ओको स्वामी अयखे असो ही करतो देखे. ");
INSERT INTO goj_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","मी तुम से सच्ची बोलुस हइ, उ ओखे अपनी पुरी संपत्ती पर अधिकार ठैराये. ");
INSERT INTO goj_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","पन अगर उ दुष्ट सेवक सोचन लग्यो, की मरा स्वामी खे आना मे देर हइ. ");
INSERT INTO goj_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","अरु अपना सात का सेवकहोन खे मारन लग्यो, अरु पीन आला का सात मे खायो-पीयो. ");
INSERT INTO goj_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ते उ सेवक को स्वामी असो दिन अयो, जब उ ओका टुकडा टुकडा कर्‍हे, अरु असो टेम की जेखे उ नी समजस हइ, ");
INSERT INTO goj_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","अरु उ कठोर दण्ड दिये ओको भागी कपटिहोन का सात ठैरायो जाये व्हा रोनो अरु दात पीसनो हुये.” ");
INSERT INTO goj_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","तब स्वर्ग का राज्य वे दस कुव्वारीहोन का जसो हुये जो अपनी मशाल लीखे दुल्हा से मीलन करण का लिये नीकली. ");
INSERT INTO goj_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","ओमे पाच मूर्ख अरु पाच समझदार थी. ");
INSERT INTO goj_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","मूर्खहोन ने अपनी मशाल तो ली, पन अपना सात तेल नी लियो ");
INSERT INTO goj_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","पन समझदारहोन ने अपना मशाल का सात अपनी सीसी मे तेल भी भरी लियो. ");
INSERT INTO goj_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","जब दुल्हा खे आना मे देर हुय, ते वे सब जपन लगी, अरु सोय गय. ");
INSERT INTO goj_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","आधी रात खे धुम मची की देख, दुलो अय रोस हइ, ओकासे दान करण का लिये चल. ");
INSERT INTO goj_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","तब वे सब कुव्वारीहोन उठीखे अपनी मशाल बरोबर करण लगी. ");
INSERT INTO goj_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","अरु मूर्खहोन ने समझदारहोन से बोल्यो. अपना तेल मे से कुछ हमखे भी दे, क्युकी हमारी मशालहोन बुझी ऱ्हीस हइ. ");
INSERT INTO goj_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","पन समझदाहोन ने उत्तर दियो की कही हमारा अरु तुमारा लिये पुरो नी हुये. ते अच्छो तो यो हइ, की तुम बेचनआला का पास जयखे अपना लिये तेल मोल ले. ");
INSERT INTO goj_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","जब वे मोल लेन खे जय ही री थी, ते दुलो ए पोच्यो, अरु जो पाच तैयार थी, वे ओका सात भ्याव का भवन मे चली गय अरु दरवाजो बन्द करी दियो. ");
INSERT INTO goj_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","येका बाद वे दुसरी कुव्वारीहोन भी अयखे बोलन लगी, हे स्वामी, हे स्वामी, हमारा लिये दरवाजो खोली दे. ");
INSERT INTO goj_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","दुल्हा ने उत्तर दियो, की मी तुम से सच्ची बोलुस हइ, मी तुमखे नी पहचानुस हइ. ");
INSERT INTO goj_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“ क्यु कि जागता! ऱ्हे, नी तुम उ दिन खे जानस हइ, नी उ टेम खे. ");
INSERT INTO goj_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“क्युकी यो उ इन्सान का जसी दशा हइ जेने परदेसी खे जाता टेम अपना सेवकहोन खे बुलय खे अपनी पुरी संपत्ती उनखे सोपी दी. ");
INSERT INTO goj_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","ओने एक खे पाच सोन्ना का सिक्का, अरु दुसरा खे दो, अरु तीसरा खे एक, अगर हर एक खे ओकी सामर्थ्य का जसो दियो, अरु तब उ जत्रा पर चली गयो. ");
INSERT INTO goj_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","तब, जेखे पाच सोन्ना का सिक्का मील्या था, ओने झल्दी जयखे ओने लेन-देन कऱ्यो, अरु पाच सोन्ना का सिक्का, अरु कमाया. ");
INSERT INTO goj_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","या रीति से जेखे दो सोन्ना का सिक्का, मील्या था, ओने भी दो अरु कमाया. ");
INSERT INTO goj_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","पन जेखे एक सोन्ना को सिक्का को मील्यो थो, ओने जयखे मट्टी खोदी, अरु अपना स्वामी को धन लुकय दियो. ");
INSERT INTO goj_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“भोत दिन का बाद वे सेवकहोन को स्वामी अयखे उनसे लेखो लेन लग्यो. ");
INSERT INTO goj_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","जेखे पाच सोन्ना का सिक्का मील्या था, ओने पाच सिक्का, अरु लीखे बोल्यो, हे स्वामी का तोने मेखे पाच सोन्ना का सिक्का सोपी दे, देख मेने पाच सोन्ना का सिक्का अरु कमाया हइ. ");
INSERT INTO goj_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","ओका स्वामी ने ओकासे बोल्यो, धन्य हे अच्छो अरु विश्वासयोग्य सेवक का तू जरासा मे विश्वासयोग्य ऱ्हेस. मी तोखे भोत धन पर अधिकार दियु अपना स्वामी का आनन्द मे हिस्सेदार हुये. ");
INSERT INTO goj_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","अरु जेखे दो सोन्ना का सिक्का मील्या था, ओने भी अयखे बोल्यो. हे स्वामी तोने मेखे भी दो सोन्ना का सिक्का खे सोपी दिया था, देख, मेने भी दो सोन्ना का सिक्का, अरु कमाया. ");
INSERT INTO goj_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","ओका स्वामी ने ओकासे बोल्यो, धन्य हइ अच्छो अरु विश्वासयोग्य सेवक का तू जरासा मे विश्वासयोग्य ऱ्हीहे कमी तोखे भोत धन पर अधिकार दियु अपना स्वामी को आनन्द मे हिस्सेदार हुये. ");
INSERT INTO goj_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","तब जेखे एक सोन्ना को सिक्का मील्यो थो, ओने अयखे बोल्यो. हे स्वामी, मी तोखे जानतो थो, की तू अच्छो इन्सान नी हइ. तू झा कही नी बोस व्हा से काटस हइ, अरु झा नी बोयो व्हा से जमा करस हइ. ");
INSERT INTO goj_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","येका लिये मी डरी गयो अरु जयखे तरा सोन्ना का सिक्का खे मट्टी मे लुकय दियो. देख, जो तरो हइ, उ यो हइ. ");
INSERT INTO goj_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","ओका स्वामी ने उनका से बोल्यो, की हे दुष्ट अरु आलसी सेवक. जब तु यो जनतो थो, की झा मेने नी बोयो व्हा से काटुस हइ. अरु झा बीज मेने बोयो नी व्हा से जमा करुस हइ. ");
INSERT INTO goj_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ते तु चातो थो, की मरो धन सफा करी खे दे, तब मी अयखे अपनो धन ब्याज समेत लीयुस. ");
INSERT INTO goj_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","येका लिये उ सोन्ना का सिक्का खे येका से ली ले अरु जेका पास सोन्ना को सिक्का हइ, ओखे दी दे. ");
INSERT INTO goj_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","क्युकी जो कोय का पास हइ, ओखे अरु दियो जाये. अरु ओका पास भोत हुये ते पन जेका पास नी हइ, ओकासे उ भी जो ओका पास हइ ली लियो जाये. ");
INSERT INTO goj_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","अरु यो नीकम्मा सेवक खे बाहेर का अंधारा मे डाली दे, झा रोन अरु दात पीसनो होस. ");
INSERT INTO goj_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“जब इन्सान को बेटो अपनी महिमा मे आये, अरु सब स्वर्गदूत ओका सात आये, ते उ अपनी महिमा की राजगद्दी पर बठयो हुये. ");
INSERT INTO goj_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","अरु सब राष्ट्रहोन खे ओका सामने जमा कऱ्यो जाये. अरु जसो चरानआलो मेंडा खे बकरी से अलग करी देस हइ, असो ही उनखे एक दुसरा से अलग करस. ");
INSERT INTO goj_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","अरु उ मेंडा खे अपना जवना तरप अरु दुसरी बकरीहोन खे डाखोर्‍या तरप खडी करस. ");
INSERT INTO goj_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","तब राजो अपना डाखोर्या का जवना तरप आला से बोल्ये, हे मरा बाप, धन्य दुन्याहोन, आ, उ राज्य को अधिकारी हुये जाये, जो जगत का पैयले से तुमारा लिये तैयार कऱ्यो हुयो हइ. ");
INSERT INTO goj_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","क्युकी मी भुको थो, अरु तुम ने मेखे खान खे दियो. मी प्यासो थो, अरु तुम ने मेखे पानी पिलायो, मी नवाडो थो, तुम ने मेखे अपना घर मे रख्यो. ");
INSERT INTO goj_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","मी नंगो थो, तुम ने मेखे कपडा पेनाया. मी बेमार थो, तुम ने मरी सुदी ली, मी बन्दीगृह मे थो, तुम मरासे मीलन आया. ");
INSERT INTO goj_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","तब धर्मी ने ओखे उत्तर दियो, हे प्रभु, हमने कब तोखे भुखो देख्यो अरु खलायो? या प्यासो देख्यो, अरु पानी पिलायो? ");
INSERT INTO goj_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","हमने कब तोखे नवाडो देख्यो अरु अपना घर मे रख्यो या नंगो देख्यो, अरु कपडा पेनाया? ");
INSERT INTO goj_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","हमने कब तोखे बेमार देख्यो या बन्दीगृह मे देख्यो अरु तरा से मीलन आया? ");
INSERT INTO goj_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","तब राजा ने उनखे उत्तर दियो, मी तुम से सच्ची बोलुस हइ, की तुम ने जो मरा वे छोटा से छोटा भैइहोन मे से कोय एक का सात कऱ्यो, उ मरा ही सात कऱ्यो. ");
INSERT INTO goj_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“तब उ डाखोर्या तरप आला से बोलस, हे श्रापित दुन्याहोन, मरा सामने से उ अनन्त अंगार मे चली जा, जो सैतान अरु ओका दूतहोन का लिये तैयार करी गइ हइ. ");
INSERT INTO goj_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","क्युकी मी भुखो थो, अरु तुम ने मेखे खान खे नी दियो, मी प्यासो थो, अरु तुम ने मेखे पानी नी पिलायो. ");
INSERT INTO goj_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","मी नवाडो थो, अरु तुम ने मेखे अपना घर मे नी रुख्यो. मी नंगो थो, अरु तुम ने मेखे कपडा नी पेनाया. बेमार अरु बन्दीगृह मे थो, अरु तुम ने मरी याद नी करी. ");
INSERT INTO goj_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","तब वे उत्तर दिये, हे प्रभु, ‘हमने तोखे कब भुखो, या प्यासो, या नवाडो, या नंगो, या बेमार, या बन्दीगृह मे देख्यो, अरु तरी सेवा टहल नी करी?’ ");
INSERT INTO goj_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","तब राजो उनखे उत्तर दिये, ‘मी तुम से सच्ची बोलुस हइ की तुम ने जो ये छोटा से छोटाहोन मे से कोय एक का सात नी कऱ्यो, राजो मरा सात भी नी करस.’ ");
INSERT INTO goj_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","अरु ये सब अनन्त दण्ड भोगन का लिये ली जाये पन धर्मी अनन्त जिवन मे प्रवेश कर्‍हे.” ");
INSERT INTO goj_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","जब यीशु या सब बात बोली चुक्यो, ते अपना सेवक होन से बोलन लग्यो. ");
INSERT INTO goj_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“तुम जानस हइ, की दो दिन का बाद मे फसह को तिवार हुये. अरु इन्सान को बेटा क्रुस पर चेडायो जान का लिये पकड्यो जाये.” ");
INSERT INTO goj_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","तब मुखियो याजक अरु दुन्या का बापदादा कैफा नामका महाराजा का अंगन मे जमा हुया. ");
INSERT INTO goj_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","अरु आपस मे बिचार करण लग्या की यीशु खे धोका से पकडि खे मारी डाले. ");
INSERT INTO goj_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","पन वे बोलता था, “की तिवार का टेम मे नी. कही असो नी हुये कि दुन्याहोन मे दंगो मची जाये.” ");
INSERT INTO goj_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","जब यीशु बैतनीय्याह मे शमौन कोढी का घर मे थो. ");
INSERT INTO goj_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ते एक बय संगमरमर का बर्तन मे भोतकिमती अत्रर लीखे ओका पास पिच्छे हुयखे , अरु जब उ खानो खान खे बठ्यो थो, ते ओका माथा पर डाली दियो. ");
INSERT INTO goj_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","यौ देखीखे, ओका सेवक घुस्सा से हूइ खे बोलन लग्या, “येको का सत्यानाश करी दियो? ");
INSERT INTO goj_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","यो ते अच्छा दाम पर बेचीखे सब गरीबहोन खे बाटी जय सकतो थो.” ");
INSERT INTO goj_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","यो जानीखे यीशु ने उनका से बोल्यो, की बय खे काय बर सतास हइ? ओने मरा सात अच्छो काम कऱ्यो हइ. ");
INSERT INTO goj_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","गरीब तुमारा सात हमेशा ऱ्हेस हइ, पन मी तुमारा सात हमेशा नी ऱ्हुयु. ");
INSERT INTO goj_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","ओने मरा आंग पर जो यो अत्रर डाल्यो हइ, उ मरा गाड्यो जान का लिये कऱ्यो हय. ");
INSERT INTO goj_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","मी तुम से सच्ची बोलुस हइ, की सब जगत मे झा कही यो सुसमाचार को प्रचार कऱ्यो जाये, व्हा ओका यो काम को वर्णन भी ओका याद मे कऱ्यो जाये. ");
INSERT INTO goj_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","तब यहूदा इस्करियोती ने, बारा सेवक होन मे से एक थो, मुखियो याजकहोन का पास जयखे बोल्यो, ");
INSERT INTO goj_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","अरु ओने बोल्यो, “अगर मी यीशु खे तुमारा हात मे पकडि खे दियु, ते मेखे का दिये?” ओने ओखे तीस चादी का सिक्का गिनी खे दी दिया. ");
INSERT INTO goj_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","अरु ओखे उ टेम से यीशु खे पकडन को अच्छो मौको ढुढन लग्यो. ");
INSERT INTO goj_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","अखमीरी की रोटी को तीवार का पयला दिन, सेवक यीशु का पास अयखे पुछन लग्या, “तु का चास हइ की हम तरा लिये फसह खाना की तैयारी करस?” ");
INSERT INTO goj_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","ओने बोल्यो, “गाव मे फलाना का पास जयखे ओकासे बोल, की गुरु बोलस हइ, की मरो टेम नजीक हइ, मी अपना सेवक होन का सात तरा ह्या फसह मनाउ.” ");
INSERT INTO goj_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","सेवक होन ने यीशु की आज्ञा मानी, अरु फसह तैयार कऱ्यो. ");
INSERT INTO goj_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","जब संजा हूइ, ते यीशु बारा सेवक होन का सात खानो खान का लिए बठ्या. ");
INSERT INTO goj_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","जब वे खय रा था, ते ओने बोल्यो, “मी तुम से सच्ची बोलुस हइ, कि तुम मे से एक मेखे पकडाये.” ");
INSERT INTO goj_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","येका पर वे भोत उदास हुया, अरु हर एक ओकासे पुछन लग्या, “हे प्रभु, का उ मी हइ?” ");
INSERT INTO goj_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","ओने उत्तर दियो, “जेने मरा सात ठाटी मे हात डाल्यो हइ, उ मेखे पकडाये. ");
INSERT INTO goj_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","इन्सान को बेटा तो जसो ओका बारे मे लिख्यो हइ, जाना मे हइ. पन उ इन्सान का लिये शोक हइ जेका वजेसे इन्सान को बेटो पकडायो जास हइ अगर उ इन्सान को जन्म नौ होस, ते ओका लिये अच्छो हइ.” ");
INSERT INTO goj_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","तब ओका पकडनवाला यहूदा ने बोल्यो, “हे गुरु, का उ मी हइ?” यीशु ओकासे बोल्यो, “तू बोली चुक्यो.” ");
INSERT INTO goj_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","जब वे खय रा था, ते यीशु ने रोटी ली, अरु धन्यवाद मागीखे तोडि, अरु सेवक होन खे दीखे बोल्यो, “ले, खा. यो मरो आंग हइ.” ");
INSERT INTO goj_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","फिर ओने कटोरो लीखे परमेश्वर को धन्यावाद कऱ्यो, अरु उन खे देखी खे बोल्यो, “तुम सब येमे से पीनु, ");
INSERT INTO goj_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","क्युकी यो वचन को मरो उ खुन हइ, जो भोतजन का लिये पाप की माफी का लिये बोहायो जास हइ. ");
INSERT INTO goj_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","मी तुम से बोलुस हइ, की अंगूर को उ रस उ दिन तब कभी नी पीउ, जब तक तुमारा सात अपना बाप का राज्य मे नवो नी पीयु.” ");
INSERT INTO goj_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","फिर वे गानो बोली खे जैतून कि टेकडि पर चली गया. ");
INSERT INTO goj_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","तब यीशु ने उनका से बोल्यो, “तुम सब आज ही रात खे मरा बारे मे ठोकर खाये, क्युकी शास्त्र मे लिख्यो हइ, मी चरवाहोन खे मारी डाल्यु. अरु झुण्ड का मेंडाहोन इदर-उदर हुय जाये. ");
INSERT INTO goj_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","पन मी अपना जिन्दो उठन का बाद तुम से पैयले गलील खे जाउ.” ");
INSERT INTO goj_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","येका पर पतरस ने ओकासे बोल्यो, “अगर सब तरा बारे मे ठोकर खाये ते खाये, पन मी कभी ठोकर नी खाउ.” ");
INSERT INTO goj_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","यीशु ने ओकासे बोल्यो, “मी तरा से सच्ची बोलुस हइ, की आज ही रात मुर्गा का बांग देन का पैयले, तू तीन बार मरा से मुकरी जाये.” ");
INSERT INTO goj_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","पतरस ने ओकासे बोल्यो, “अगर मेखे तरा सात मरनू भी हुये, ते भी, मी तरा से कभी नी घुस्सा हुयु.” अरु असो ही सब सेवक होन ने भी बोल्यो. ");
INSERT INTO goj_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","तब यीशु ने अपना सेवक होन का सात गतसमनी नामका एक जगा मे आया अरु अपना सेवक होन से बोलन लग्यो “ह्या बठ्या ऱ्हे, जब तक की मी व्हा जयखे प्रार्थना करुस.” ");
INSERT INTO goj_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","अरु उ पतरस अरु जब्दी को दो बेटाहोन का सात ली गयो, अरु उदास अरु व्याकुल होन लग्या. ");
INSERT INTO goj_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","तब ओने उनका से बोल्यो, “ मरो मन भोत उदास हइ ह्या तक की मरो जान नीकली जास हइ. तुम ह्या रुख, अरु मरा सात जागता ऱ्हे.” ");
INSERT INTO goj_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","फिर उ जरासा अरु आगे बडिखे मुंडा का बल गिरीगो, अरु या प्रार्थना करण लग्यो, हे मरा बाप, अगर हुइ सखे, ते यो कटोरो मरासे टली जाये, फिर भी जसो मी चास हइ असो नी, पन जसो तु चास हइ असो ही हुये. ");
INSERT INTO goj_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","फिर सेवक होन का पास अयखे उनखे सोते देख्यो, अरु पतरस से बोल्यो, “का तुम मरा सात एक घण्टा भर नी जागी सकस? ");
INSERT INTO goj_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","जागता ऱ्हे, अरु प्रार्थना करता ऱ्हे, की तुम परीक्षा मे नी पडे! आत्मा ते तैयार हइ, पन आंग कमजोर हइ.” ");
INSERT INTO goj_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","फिर ओने दुसरा बार जयखे या प्रार्थना करी, “हे मरा बाप, अगर या मरा पिना का बिना नी हटी सखे ते मरी इच्छा पुरी हुये.” ");
INSERT INTO goj_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","तब ओने अयखे उनखे फिर सोते देख्यो, क्युकी उनकी आख नीद से भरी थी. ");
INSERT INTO goj_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","अरु उनखे छोडी खे फिर चली गयो, अरु वही बात फिर बोलीखे, तीसरी बार प्रार्थना करी. ");
INSERT INTO goj_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","तब ओने सेवक होन का पास अयखे उनका से बोल्यो, “अभी सोते ऱ्हे, अरु आराम कर देख, टेम ए पोच्यो हइ, अरु इन्सान को बेटो पापीहोन का हात मे दियो जाये. ");
INSERT INTO goj_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","उठ, सेवक आ चल देख मरा पकडनवालो नजिक पिच्छे हुयय गो.” ");
INSERT INTO goj_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","उ यो बोली ही रो थो, की यहूदा जो बारा सेवक होन मे से एक थो, आयो, अरु ओका सात मुखियो याजकहोन अरु दुन्याहोन का बापदादा होन का तरप से बडि गर्दी, तलवार अरु लकडिहोन लिखे आया. ");
INSERT INTO goj_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","ओका पकडनवाला ने उनखे यो पतो दियो थो “जेखे मी चुमो लियु उ हइ. ओखे पकडि लेनु.” ");
INSERT INTO goj_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","अरु झल्दी यीशु का पास अयखे बोल्यो, “हे गुरु, नमस्कार!” अरु ओको चुमो लियो. ");
INSERT INTO goj_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","यीशु ने ओकासे बोल्यो, “हे दोस्त, जो काम का लिये तू आयो हइ, ओखे करी ले.” तब ओका पास अयखे यीशु पर हात डाल्यो अरु ओखे पकडि लियो. ");
INSERT INTO goj_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","तब यीशु का साथिहोन मे से एक ने हात बडय खे अपनी तलवार खीची ली अरु महा याजक का एक सेवक पर चलय खे ओको कान काटी दियो. ");
INSERT INTO goj_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","तब यीशु ने ओकासे बोल्यो, “अपनी तलवार खे म्यान मे रखी ले क्युकी जो तलवार चलास हइ, वे सब तलवार से खतम कऱ्या जास. ");
INSERT INTO goj_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","का तु नी समझस, कीमी अपना बाप से प्रार्थना करी सकुस हइ, अरु उ स्वर्गदूतहोन का बारा सेवक होन का सैन्य-दल से जादा मरा पास अभी हजर करी दिये? ");
INSERT INTO goj_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","पन पवित्रशास्त्र की या बात खे असो ही होनो अच्छो हइ, कसी पुरी हुये?” ");
INSERT INTO goj_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","उ टेम यीशु ने गर्दी से बोल्यो, “का तुम तलवार अरु लकडि लीखे मेखे डाकू का जसा पकडन का लिये नीकल्या हइ? मी हर दिन मन्दिर मे बठीखे शिक्षा दियो करतो थो, अरु तुम ने मेखे नी पकड्यो. ");
INSERT INTO goj_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","पन यो सब येकालिये हुयो हइ, की भविष्यव्दक्ताहोन को वचन पुरो हुये.” तब सब सेवक ओखे छोडी खे भागी गया. ");
INSERT INTO goj_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","अरु यीशु खे पकडनवाला खे ओका कैफा नामका महा याजक का पास ली गया, झा पंडीतहोन अरु बापदादाहोन जमा हुया था. ");
INSERT INTO goj_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","अरु पतरस दुर से ओका पीछे-पीछे महायाजक का घर का अंगन तक गयो, अरु अंदर जयखे अन्त देखन का लिये सेवकहोन का सात बठी गयो. ");
INSERT INTO goj_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","मुखियो याजकहोन अरु सब महासभा यीशु खे मारी डालन का लिये ओका विरोध मे झुठी गवाही की खोज मे था. ");
INSERT INTO goj_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","पन भोत सा झुठा गवाह का आना पर भी नी पासयो. आखरी मे दो झना आया, ");
INSERT INTO goj_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","अरु बोल्यो, “येने बोल्यो की मी परमेश्वर की मन्दिर खे तोडि सकुस हइ अरु तीन दिन मे बनय सकुस हइ.” ");
INSERT INTO goj_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","तब महायाजक ने खडो हूयखे ओकासे बोल्यो, “का तु कोय उत्तर नी देस? ये दुन्या तरा विरोध मे का गवाही देस हइ?” ");
INSERT INTO goj_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","पन यीशु चुप ही थो. तब महायाजक ने ओकासे बोल्यो “मी तोखे जिन्दा परमेश्वर की कसम दियुस हइ, कि अगर तु परमेश्वर को बेटो मसीह हइ, ते हम से बोली दे.” ");
INSERT INTO goj_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","यीशु ने ओकासे बोल्यो, “तोने खुद ही बोलि दियो. जब मी तुम से यो भी बोलुस हइ, की अभी से तुम इन्सान का बेटा खे फक्त सर्वशक्तिमान का जवना तरप बठ्यो, अरु आकाश का बद्दलहोन पर आते देखे.” ");
INSERT INTO goj_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","तब महायाजक ने अपना कपडा फाडी खे बोल्यो, “येने परमेश्वर की नीन्दा करी हइ, अभी हम खे गवाहहोन को प्रयोजन? देख, तुम ने अभी या नीन्दा सुनी हइ! ");
INSERT INTO goj_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","तुम का समझस हइ?” ओने उत्तर दियो, यो मरन को दण्ड होन का योग्य हइ. ");
INSERT INTO goj_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","तब उनने ओका मुडा पर थंपड अरु घुसा माऱ्या, दुसरा ने थप्पड माऱ्यो, ");
INSERT INTO goj_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","अरु बोल्यो “हे मसीह, हम से भविष्यवाणी करीखे बोल की कोय ने तोखे माऱ्यो का?” ");
INSERT INTO goj_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","पतरस बाहेर अंगन मे बठ्यो हुयो थो की एक दासी ने ओका पास अयखे बोल्यो, “तू भी यीशु गलीली को साथी थो.” ");
INSERT INTO goj_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","ओने सब का सामने यो बोलीखे इन्कार कऱ्यो अरु बोल्यो, “मी नी जानुस तू का बोली ऱ्हिस हइ.” ");
INSERT INTO goj_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","जब उ बाहेर दरवाजा मे चली गयो, ते दुसरी दासी ने ओखे देखीखे ओने जो वहा थो बोल्यो, “यो भी तो यीशु नासरी का सात थो.” ");
INSERT INTO goj_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","ओने कसम खयखे फिर इन्कार कऱ्यो, “मी उ इन्सान खे नी जानुस.” ");
INSERT INTO goj_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","जरासा देर का बाद मे, जो व्हा खडा था, उनने पतरस का पास अयखे ओकासे बोल्यो, “सच मुच तू भी ओमे से एक हइ. क्युकी तरी बोली तरो भेद खोली देस हइ.” ");
INSERT INTO goj_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","तब उ कोसन अरु कसम खान लग्यो, “मी उ इन्सान खे नी जानु.” अरु झल्दी मुर्गा ने बांग दी. ");
INSERT INTO goj_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","तब पतरस खे यीशु की बोली हुये बात याद अय “अरु मुर्गा का बांग देना से पैयले तू तीन बार मरो इन्कार कर्हे.” अरु उ बाहेर जयखे फुटी-फुटी खे रोन लग्यो. ");
INSERT INTO goj_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","जब फजर हुइ, ते सब प्रधान याजकहोन अरु दुन्याहोन का बापदादा ने यीशु खे मारी डालन की योजना करी. ");
INSERT INTO goj_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","अरु उनने ओखे बांध्यो अरु ली जयखे पिलातुस राज्यपाल का हात मे सोपी दियो. ");
INSERT INTO goj_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","जब ओका पकडनवाला यहूदा ने देख्यो की उ दोषी ठैर्यो गयो हइ ते उ पछतायो अरु वे तीस चादी का सिक्का खे प्राधन याजकहोन अरु बापदादाहोन खे देन गयो. ");
INSERT INTO goj_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","अरु बोल्यो, “मेने नीर्दोष खे मरन का लिये पकडीखे पाप कऱ्यो हइ?” उनने बोल्यो, “हमखे का? तू ही देखी ले.” ");
INSERT INTO goj_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","तब उ वे सिक्काहोन खे मन्‍दिर मे फेकी खे चली गयो, अरु जयखे अपना आप खे फासी दी. ");
INSERT INTO goj_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","प्रधान याजकहोन ने वे सिक्काहोन खे लिखे बोल्यो, “इनखे पेटी मे रखनो अच्छो नी, क्युकी वे खुन को दाम हइ.” ");
INSERT INTO goj_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","आखरी उनने योजना करी खे वे सिक्काहोन से नवाडाहोन खे गाडन का लिये कुमार को खेत मोल लीयो. ");
INSERT INTO goj_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","यो कारण उ खेत आज तक खुन को खेत बोलस हइ. ");
INSERT INTO goj_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","तब जो वचन यिर्मयाह भविष्यव्दक्ता का वजेसे बोल्यो गयो थो उ पुरो हुये “उनने वे तीस सिक्का खे अगर उ ठैरायो हुयो मुल्य खे जो इस्राएल का बेटा मे से कत्ता ने ठेरायो थो ली लीयो. ");
INSERT INTO goj_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","अरु जसो प्रभु ने मेखे आज्ञा दी थी असो ही उनखे कुमार का खेत का लिये दी दियो.” ");
INSERT INTO goj_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","जब यीशु राज्यपाल का सामने खडो थो, ते राज्यपाल ने ओकासे पुछ्यो “तू यहूदीयाहोन को राजो हइ?” यीशु ने ओकासे बोल्यो, “तु खुद ही बोली रोस हइ.” ");
INSERT INTO goj_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","जब प्रधान याजक अरु बापदादा ओका पर दोष लगय रा था, ते ओने कुछ भी उत्तर नी दियो. ");
INSERT INTO goj_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","येका पर पिलातुस ने ओकासे बोल्यो “तु नी सुनस की ये तरा बारे मे केतना गवाही दी रास हइ?” ");
INSERT INTO goj_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","पन यीशु ने पिलातुस खे एक बात को भी उत्तर नी दियो, ह्या तक की राज्यपाल खे बडो आश्चर्य हुयो. ");
INSERT INTO goj_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","अरु रोमी राज्यपाल की या रीति थी, की उ तिवार मे दुन्याहोन का लिये कोय एक बन्दी खे जेखे वे चाता था, ओखे छोड्यो दियो जातो थो. ");
INSERT INTO goj_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","उ टेम मे उनखे बन्दीगृह बरअब्बा नाम को, एक जानो मानो गुना बन्दी थो. ");
INSERT INTO goj_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","अत: जब वे जमा हुया, ते पिलातुस ने उनका से बोल्यो, “तुम कोखे चास हइ, की मी तुमारा लिये छोडी दुयु? बरअब्बा खे, या यीशु खे जो मसीह बोलस हइ?” ");
INSERT INTO goj_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","क्युकी वे जानता था की ओने ओखे धोका से पकड्यो हइ. ");
INSERT INTO goj_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","जब उ न्याय की गद्दी पर बठ्यो हुयो थो ते ओकी लुगेन ने ओखे बुलावो भेज्यो, “तू उ न्यायी का मामला मे हात नी डालनु क्युकी मेने आज दृष्‍टान्‍त मे ओका कारण भोत दुख उठायो हइ.” ");
INSERT INTO goj_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","अगर प्रधान याजकहोन अरु बापदादाहोन ने दुन्याहोन खे उकसा यो की वे बरअब्बा खे मांगी ले, अरु यीशु खे नाश करी सखे . ");
INSERT INTO goj_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","रोमी राज्यपाल ने उनका से पुछ्यो, “ये दो मे से कोखे चास हइ, की तुमारा लिये छोडी दुयु?” उनने बोल्यो, बरअब्बा खे. ");
INSERT INTO goj_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","पिलातुस ने उनका से पुछ्यो, “फिर यीशु खे जो मसीह बुलास हइ का करु?” सब ने ओकासे बोल्यो, “ओखे क्रुस पर चेडायो जाये.” ");
INSERT INTO goj_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","राज्यपाल ने बोल्यो “ओने का बुरोइ करी हइ?” पन वे अरु भी चिलय-चिल्लय खे बोलन लग्या, की ओखे क्रुस पर चेडायो जाये. ");
INSERT INTO goj_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","जब पिलातुस ने देख्यो, की कुछ बनी नी पास पन हूल्लड कि सम्भावना हइ, ते ओने पानी लीखे गर्दी का सामने अपना हात धोया, अरु बोल्यो, मी यो न्यायी का खुन से नीर्दोष हुयु. तुम ही जानी ले. ");
INSERT INTO goj_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","सब दुन्याहोन ने उत्तर दियो, “येको खुन हम पर अरु हमारा बच्चाहोन पर हुये!” ");
INSERT INTO goj_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","येका पर ओने बरअब्बा खे उनका लिये छोडी दियो, अरु यीशु खे कोडा मारी खे सोपी दियो, की क्रुस पर चेडायो जाये. ");
INSERT INTO goj_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","तब राज्यपाल का सिपाहीहोन ने यीशु खे किल्ला मे ली जयखे सब सेवक ओका चारी तरप जमा कऱ्या. ");
INSERT INTO goj_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","अरु ओका कपडा उतारीखे ओखे चमकीला लाल कपडा पेनाया. ");
INSERT INTO goj_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","अरु काटा की टोपी गुथीखे ओका माथा पर रखी. अरु ओका जवना हात मे सरकण्‍डे दियो अरु ओका आगे टोगऱ्या टेकीखे ओकी मजाक उडान लग्या, “हे यहूदीयाहोन का राजा, को जय हुये!” ");
INSERT INTO goj_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","अरु ओका पर थुक्यो. अरु ये सरकण्‍डे ओका माथा पर मारन लग्या. ");
INSERT INTO goj_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","जब वे ओकी मजाक करी चुक्या, ते वे चमकीला कपडा ओका पर से उतारीखे फिर ओका कपडा ओखे पेनाया, अरु क्रुस पर चेडान का लिये ली गया. ");
INSERT INTO goj_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","जब वे बाहेर जाता हुये उनखे एक शमौन नाम को एक कुरेनी इन्सान मील्यो, उनने ओखे बेकार मे पकड्यो कि ओको क्रुस खे उठ्य खे ली चल्या. ");
INSERT INTO goj_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","अरु वा जगा पर जो गुलगुता नाम की जगा अगर खोपडी की जगा बोलता था पोचीखे. ");
INSERT INTO goj_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","उनने कडवो रस मील्यो हुयो अंगूर को रस ओखे पीन खे दियो, पन ओने चाट्यो पीयो नी. ");
INSERT INTO goj_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","तब उनने ओखे क्रुस पर चेडायो. अरु चिट्टी डालीखे ओका कपडा बाटी लिया. ");
INSERT INTO goj_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","अरु व्हा बठीखे ओकी जागल करण लग्या. ");
INSERT INTO goj_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","अरु ओकी दोषचिठ्ठी खे ओका माथा का उपर लगायो, की “यो यहूदीयाहोन को राजो यीशु हइ.” ");
INSERT INTO goj_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","तब ओका सात दो डाकू एक जवनो अरु डाखोऱ्यो बाजू क्रुस पर चेडायो गयो. ");
INSERT INTO goj_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","अरु आन-जानआला दुन्या माथो हलय-हलय खे ओकी नीन्दा करता था. ");
INSERT INTO goj_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","अरु यो बोलता था, “हे मन्‍दिर खे तोडनवाला अरु तीन दिन मे बनानवाला, अपना आपखे ते बचा! अगर तू परमेश्वर को बेटो हइ, ते क्रुस पर से उतरी खे आ.” ");
INSERT INTO goj_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","या रीति से प्रधान याजक भी पडीतहोन अरु बापदादाहोन का साथ मजाक करीखे बोलता था, ");
INSERT INTO goj_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","येने दुसरा खे बचायो, अरु अपना आपखे नी बचय सकस. यो तो इस्राएल को राजो हइ. अब क्रुस पर से उतरी खे आये, ते हम ओका पर विश्वास कर्‍हे. ");
INSERT INTO goj_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","ओने परमेश्वर को भरोसो रख्यो हइ, अगर उ येखे चास हइ, ते अभी येखे छुडाये, क्युकी येने बोल्यो थो, मी परमेश्वर को बेटो हइ. ");
INSERT INTO goj_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","यो प्रकार डाकू भी जो ओका सात क्रुस पर चेडाया गया था ओकी नीन्दा करता था. ");
INSERT INTO goj_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","दुपार से लीखे तिसरा पार तक ओका सब देस मे अंधारो हुइ गयो. ");
INSERT INTO goj_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","तीसरा पहर का नजीक यीशु ने बडो आवाज से पुकारी खे बोल्यो, “एली, एली, लमा शबक्तनी?” अगर “हे मरा परमेश्वर, हे मरा परमेश्वर, तोने मेखे कायबर छोडी दियो?” ");
INSERT INTO goj_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","जो व्हा खडा था, ओमे से केतना ने यो सुनीखे बोल्यो, “यो तो एलिय्याह खे बुलय रोस हइ.” ");
INSERT INTO goj_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","ओमे से एक झल्दी भाग्यो, अरु स्पंज लिखे अंगूर को कडु रस मे डुबय खे, सरकण्‍डे पर रखीखे ओखे पीन खे दियो. ");
INSERT INTO goj_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","भोतझना ने बोल्यो, “ऱ्ही जा, देखस, की एलिय्याह ओखे बचान आस हइ की नी.” ");
INSERT INTO goj_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","तब यीशु ने बडा जोर से चिल्लय खे जान छोडी दियो. ");
INSERT INTO goj_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","तब, मन्‍दिर का परदा उपर से नीचे तक फटी खे दो टुकडा हुय गया अरु जमीन हली गय अरु टेकडी फटी गय. ");
INSERT INTO goj_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","अरु कब्र खुली गय, अरु सोया हुय पवित्र दुन्याहोन खे भोत सा मुर्दो जिन्दा उठ्या. ");
INSERT INTO goj_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","अरु ओका जी उठना का बाद मे वे कब्र मे से नीकलीखे पवित्र गाव यरुशलेम मे गया, अरु भोतझना खे दिखइ दिया. ");
INSERT INTO goj_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","तब सुबेदार अरु जो ओका सात यीशु की चौकीदारी दी रा था, भूकम्प अरु जो कुछ हुयो थो, देखीखे भोत डरी गया, अरु बोल्यो, “सचमुच यो परमेश्वर को बेटो थो!” ");
INSERT INTO goj_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","व्हा भोत सी बयहोन जो गलील से यीशु की सेवा करती हुइ ओका सात मे ए थी, दुर से देखी री थी. ");
INSERT INTO goj_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","ओमे मरियम मगदलीनी अरु याकूब अरु यूसुफ कि माय मरियम अरु जब्दी की लुगेन. ");
INSERT INTO goj_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","जब संजा हुयी ते यूसुफ नाम अरिमतियाह को एक धनी इन्सान जो खुद ही यीशु को चेलो बन्या ");
INSERT INTO goj_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","ओने पिलातुस का पास जयखे यीशु का मुर्दा खे माग्यो. पिलातुस ने यूसुफ खे मुर्दो खे ले जान की आज्ञा दी. ");
INSERT INTO goj_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","यूसुफ ने मुर्दा खे लीखे ओखे सफेद चद्दर मे गुढ्यो. ");
INSERT INTO goj_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","अरु ओने अपनी नवी कब्र मे रख्यो, जो ओने टेकडी मे खोदी थी, अरु कब्र का दरवाजा पर बडो पत्थर लुढकैय खे चली गयो. ");
INSERT INTO goj_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","अरु मरियम मगदलीनी अरु दुसरी मरियम व्हा कब्र का सामने बठी थी. ");
INSERT INTO goj_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","आराम को दिन जो तैयारी का दिन का बाद को दिन थो, प्रधान याजकहोन अरु फरीसीहोन ने पिलातुस का पास जमा हुइखे बोल्यो. ");
INSERT INTO goj_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","हे स्वामी, हमखे याद हइ, की उ भरमानआला ने अपना जीते जी बोल्यो थो, की मी तीन दिन का बाद जिन्दो हुयु. ");
INSERT INTO goj_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","अत: आज्ञा दे की तीसरा दिन तक कब्र की रखवाली करी जाये, असो नी हुये की ओका सेवक होन ओखे चोरी खे ली जाये, अरु दुन्याहोन से बोलन लग्या, की उ मऱ्या हुया मे से जिन्दो उठ्यो हइ, तब अगलो झुठो पैयले से भी बुरो हुये. ");
INSERT INTO goj_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","पिलातुस ने उनका से बोल्यो, “तुमारा पास चोकीदारहोन तो हइ जा, अपनी समझ से क्रब खे सुरक्षित कर.” ");
INSERT INTO goj_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","आखरी मे वे चोकीदारहोन खे सात मे ली गया, अरु पत्थर पर एक नीशान लगयखे कब्र खे पुरी रिती से सुरक्षित बन्य दी. ");
INSERT INTO goj_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","आराम का दिन का बाद हप्ता को पयलो दिन जब फजर हुइ ऱ्ही थी, मरियम मगदलीनी अरु दुसरी मरियम कब्र खे देखन अय. ");
INSERT INTO goj_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","तब एक बडो भुकम्प हुयो, क्युकी परमेश्वर को एक दूत स्वर्ग से उतऱ्यो, अरु पास अयखे ओने पत्थर खे लुडक्य दियो, अरु ओका पर बठी गो. ");
INSERT INTO goj_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","ओको रुप बिजली का जसो अरु ओका कपडा पेन्या बर्फ का जसो उज्जाला था. ");
INSERT INTO goj_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","ओका डर से पहरेदार कब उठ्या, अरु मर्‍या का जसा हुय गया. ");
INSERT INTO goj_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","स्वर्गदूत ने बयहोन से बोल्यो, “मत डर, मी जानुस हइ की तुम यीशु खे जो क्रुस पर चेढायो गयो थो ढुढस हइ. ");
INSERT INTO goj_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","उ ह्या नी हइ, पन अपना वचन का जसो उ जिन्दो उठ्यो हइ. आख या जगा खे देख कि झा प्रभु खे रख्यो गयो थो. ");
INSERT INTO goj_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","अरु झल्दी जयखे ओका सेवक होन से बोल, की उ मऱ्या मे से जिन्दो उठ्यो हइ. अरु देख उ तुम से पैयले गलील खे जास हइ, उ ओको दर्शन पाये, देख का मेने तुमखे बात बोली दी.” ");
INSERT INTO goj_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","अरु वे डर अरु बडा आनन्द का सात कब्र से झल्दी लोटिखे ओका सेवक होन खे समाचार बतान का लिये भागी गय. ");
INSERT INTO goj_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","तब, यीशु उनखे मील्यो अरु बोल्यो, “सुख से ऱ्हे” अरु उनका पास अयखे अरु ओका पाय पकडीखे ओखे प्रणाम कऱ्यो. ");
INSERT INTO goj_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","तब यीशु ने उनका से बोल्यो, मत डर मरा “भैइहोन से जयखे बोल,” “की गलील खे चली जा व्हा मेखे देखे.” ");
INSERT INTO goj_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","वे जय ही री थी, की पहरेदारहोन मे से केतना ने नगर मे अयखे पुरो हाल मुखिया याजकहोन से बोल सुन्यो. ");
INSERT INTO goj_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","तब उनने बापदादाहोन का सात जमा हूयखे योजना करी, अरु सिपहीहोन खे भोत चादी का सिक्काहोन दिया. ");
INSERT INTO goj_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","अरु बोल्यो, “यो बोलनु की रात खे जब हम सोया था, ते ओका सेवक अयखे ओखे चोरी खे गया. ");
INSERT INTO goj_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","अरु अगर या बात राज्यपाल का कान तक पोची जाये, ते हम ओखे समझ्य लीये अरु तुमखे चिंता से आजाद करी दिया.” ");
INSERT INTO goj_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","येका लिये उनने सिक्का लिखे जसो सिखायो गयो तो, असो ही कऱ्यो. अरु या बात आज तक यहूदीयाहोन मे फैली हइ. ");
INSERT INTO goj_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","अरु ग्यारा सेवक गलील मे वा टेकडी पर गया, जो यीशु ने उनखे बतय थी. ");
INSERT INTO goj_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","अरु उनने ओको दर्शन लीयो ओखे प्रणाम कऱ्यो, पर कोय-कोय खे विश्वास नी हुयो. ");
INSERT INTO goj_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","यीशु ने उनका पास अयखे बोल्यो, “की स्वर्ग अरु पृथ्वी को सब अधिकार मेखे दियो गयो हइ. ");
INSERT INTO goj_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","येका लिये तुम जयखे सब राष्ट्रहोन खे दुन्याहोन खे सेवक बन्या. अरु उनखे बाप, अरु बेटा, अरु पवित्र आत्मा का नाम से बपतिस्मा दे, ");
INSERT INTO goj_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","अरु उनखे सब बात जो मेने तुमखे आज्ञा दी हइ, ओको पालन करणो सिखा. अरु देख, मी जगत का आखरी तक हमेशा तुमारा सात ऱ्हीयु.”");
INSERT INTO goj_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","परमेश्वर को बेटो यीशु मसीह को सुसमाचार की सुरुवात. ");
INSERT INTO goj_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","जसो कि यशायाह भविष्यव्दक्ता की किताब मे लिख्यो हइ “परमेश्वर ने बोल्यो, मी तरा आगे अपनो दूत, भेजुस हइ, उ तरा लिये रस्ता तैयार कर्हे. ");
INSERT INTO goj_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","सुनसान जंगल मे एक पुकारनआला को आवाज सुनइ दि रो हइ कि प्रभु कि रस्ता तैयार कर, अरु ओकी रस्ता सीधी करणु!” ");
INSERT INTO goj_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","येका लिये यहून्ना सुनसान जंगल मे बपतिस्मा अरु शिक्षा हुया दुन्याहोन से बोल्यो, अपना पाप से दुर ऱ्हे अरु माफ का लिये. “मन फिराव को बपतिस्मा ले अरु परमेश्वर तुमारा पाप खे माफ कर्हे.” ");
INSERT INTO goj_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","पुरा यहूदीयाहोन प्रदेस, अरु यरुशलेम शहर का सब र्‍हेनआला नीकलीखे यहुन्ना का पास गया, अरु उनने अपना पाप खे मनय खे यरदन नद्दी मे ओकासे बपतिस्मा लियो. ");
INSERT INTO goj_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","यहून्ना उट का बाल का कपडा पेनीखे अरु अपनी कम्मर मे चामडा को पट्टो बाध्यो र्हेतो थो, अरु टोटर अरु जंगल को मोहरुस खातो थो. ");
INSERT INTO goj_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","अरु उ यो प्रचार करतो थो “मरा बाद उ आनआलो हइ, जो मरासे भोत बडो हइ. मी यो योग्य भी नी की झुकी खे ओका जुता की तन्नी खोली सकु. ");
INSERT INTO goj_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","मेने तो तुमखे पानी से बपतिस्मा दियो, पन उ तुमखे पवित्र आत्मा से बपतिस्मा दिये.” ");
INSERT INTO goj_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","उन दिन मे, यीशु ने नासरत नगर से गलील प्रदेस मे अयखे, यरदन नदी मे, यहून्ना से बपतिस्मा लीयो. ");
INSERT INTO goj_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","अरु जब उ पाणी से नीकलीखे उपर आयो ते तुरुत ओने बद्दल खे खुलतो अरु पवित्र आत्मा खे कबूतर का रुप मे अपना उपर उतरता देख्यो. ");
INSERT INTO goj_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","अरु यो स्वर्ग से एक आवाज सुन्यो “तू मरो लाड को बेटो हइ, तरा से मी भोत खुश हइ.” ");
INSERT INTO goj_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","तब पवित्र आत्मा ने ओखे तुरुत सुनसान जगा का तरफ भेज्यो. ");
INSERT INTO goj_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","अरु सुनसान जगा मे चालीस दिन अरु चालीस रात तक सैतान ने ओकी परीक्षा करी. अरु उ जंगली जनवरहोन का साथ र्‍हियो. अरु स्वर्गदूत ओकी सेवा करता र्‍हिया. ");
INSERT INTO goj_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","यहून्ना खे बन्दीघर मे डाल्या जान का बाद यीशु ने गलील प्रदेस मे अयखे परमेश्वर का राज को सुसमाचार प्रचार कर्यो. ");
INSERT INTO goj_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","अरु बोल्यो “टेम पूरो हुयो हइ, अरु परमेश्वर को राज नजीक अय गो हइ, अपना पाप से मन फिरानु अरु सुसमाचार पर विश्वास करणु.” ");
INSERT INTO goj_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","जब यीशु गलील की नदी का किनारा जातो हुये ओने दो भैइ शमौन अरु ओको भैइ अन्द्रियास खे नदी मे जाल डालते देख्यो, क्युकी वे मछिआला था. ");
INSERT INTO goj_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","यीशु ने उनका से बोल्यो, मरा पिछे आ मी तुम खे परमेश्वर का राज मे लानो सीखायु. ");
INSERT INTO goj_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","वे तुरुत जाल, छोडी खे ओका पिछे चली गया ");
INSERT INTO goj_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","अरु कुछ आगे अयखे ओने जब्दी का दो बेटा याकूब, अरु ओको भैइ यहून्ना खे, डोंगा पर जाल खे सुधारते देख्यो. ");
INSERT INTO goj_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","जब यीशु ने उनखे देख्यो, अरु तुरुत उनखे बुलायो वे अपना बाप जब्दी खे मजूरहोन का साथ डोंगा पर छोडी खे यीशु का पिछे चलि गया. ");
INSERT INTO goj_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","यीशु अरु वोका चेला कफरनहूम शहर मे आया, अरु उ अराम का दिन मे यहूदीयाहोन का आराधनालय मे जय खे उपदेस देन लग्यो. ");
INSERT INTO goj_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","अरु दुन्या ओकी शिक्षा से अचम हुया, क्युकी उ उनखे धर्म शास्त्री का जसो नी, पन अधिकार से उपदेस देतो थो. ");
INSERT INTO goj_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","उ टेम मे उनको आराधनालय मे, एक इन्सान थो. जोमे एक बुरी आत्मा थी. ");
INSERT INTO goj_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","ओने चिल्लय खे बोल्यो, हे नासरत नगर को यीशु, हमखे तरा से काम? का तू हम खे खतम करण आयो हइ? मी तोखे जानुस हइ तू कोण हइ, तू परमेश्वर को पवित्र जन हइ. ");
INSERT INTO goj_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","यीशु ने ओखे धमकय खे बोल्यो, चुप र्‍हे अरु ओमे से नीकली जा, ");
INSERT INTO goj_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","तब बुरी आत्मा ओखे मुरगडी खे अरु बडा आवाज से चिल्लय खे ओमे से नीकली गइ. ");
INSERT INTO goj_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","येका पर सब अचम करता हुये आपस मे वाद विवाद करण लग्या, या, बात हइ? यो तो कोय नवो उपदेस हइ,“उ अधिकार का साथ बुरी आत्माहोन खे भी आज्ञा देस हइ, अरु वे ओकी आज्ञा मानस हइ.” ");
INSERT INTO goj_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","यो तरह गलील अरु ओका आस पास का हर सब प्रदेश मे यीशु को नाम जल्दी ही फैली गो. ");
INSERT INTO goj_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","यीशु आराधनालय मे से नीकलीखे याकूब अरु यहून्ना को साथ शमौन अरु अन्द्रियास का घर मे आयो. ");
INSERT INTO goj_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","अरु शमौन की सासु बुखार मे पडी थी, अरु उनने तुरुत ओका बारे मे ओकासे बोल्यो. ");
INSERT INTO goj_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","तब ओने पास जैइखे ओको हात पकडी खे ओखे उठायो. अरु ओको बुखार उतरी गयो, अरु वा उनकी सेवा करण लगी. ");
INSERT INTO goj_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","शाम का टेम जब सुरज डूबी गयो ते दुन्या सब बीमारहोन खे अरु उनमे जोमे बुरीआत्माहोन थी, यीशु का पास लानु. ");
INSERT INTO goj_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","अरु पुरा नगर का सब दुन्या दरवाजा का बाहेर जमा हुया. ");
INSERT INTO goj_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","यीशु ने भोतझण खे अलग प्रकार की बिमार से छुड्या हुया था, उनखे अच्छो कर्यो, अरु भोत सी बुरीआत्माहोन खे नीकाली. अरु बुरीआत्माहोन खे बोलन नी दियो, क्युकी वे ओखे पहचानता था यो कोन आय. ");
INSERT INTO goj_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","फजर खे दिन नीकलना से भोत पैयले यीशु उठीखे नीकली गयो, अरु एक सुनसान जंगल कि जगा मे गयो अरु व्हा प्रार्थना करण लग्यो. ");
INSERT INTO goj_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","तब शमौन अरु ओका साथी ओखे ढुढन लग्या. ");
INSERT INTO goj_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","अरु जब उ मील्यो, ते ओकासे बोल्यो. सब दुन्या तोखे ढूडी रा हइ. ");
INSERT INTO goj_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","पन यीशु ने उनका से बोल्यो, “आ. हम अरु कही आस पास का गाव मे जाये, कि मी व्हा भी प्रचार कर्यु, क्युकी मी येकालिये ही आयो हइ.” ");
INSERT INTO goj_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","अरु उ पुरा गलील मे यहूदीयाहोन का आराधनालय मे जय जैयखे प्रचार करतो अरु बुरीआत्माहोन खे नीकलतो र्‍हियो. ");
INSERT INTO goj_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","अरु एक कोढ को रोगी यीशु का पास अयखे, ओकासे मदत मागी, अरु ओका सामने घुटना टेकीखे, ओकासे बोल्यो, “अगर तू चाह्ये ते मेखे अच्छो करी सकस हइ.” ");
INSERT INTO goj_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","यीशु ने ओका पर दया खैइ खे हात बडायो, अरु ओखे पकडी खे बोल्यो, “मी चाहुस हइ, तू अच्छो हुइ जा.” ");
INSERT INTO goj_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","अरु तुरुत ओकी कोढ सुधरते चली गइ, अरु उ अच्छो हुइ गयो. ");
INSERT INTO goj_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","तब यीशु ने ओखे कडी चेतावनी दिखे तुरुत बिदा कर्यो. ");
INSERT INTO goj_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","अरु ओकासे बोल्यो, “सुन, कोय से मत बोलनु, पन जैइखे अपना आप खे महायाजक खे बता, अरु अपना अच्छो होन का बारे मे जो कुछ मूसा ने ठैरायो हइ ओखे दान चेडा, कि उन पर गवाह हुये.” ");
INSERT INTO goj_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","पन उ इन्सान बाहेर जैइखे या बात को भोत प्रचार करण अरु ह्या तक फैलान लग्यो, कि यीशु फिर खुल्लमखुल्ला नगर मे नी जैइ सक्यो, पर बाहेर सुनसान जगा मे र्‍हियो. अरु चारी तरफ से दुन्या यीशु का पास आता र्‍हिया. ");
INSERT INTO goj_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","थोडा दिन का बाद उ फिर कफरनहूम मे आयो अरु सुन्यो गयो कि उ घर मे हइ. ");
INSERT INTO goj_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","फिर येत्ता दुनिया जमा हुया, कि दरवाजा का पास भी जगा नी मीली. अरु उ उनखे वचन सुनय रो थो. ");
INSERT INTO goj_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","अरु दुन्या एक लखवा का रोगी खे चार इन्सानहोन से उठयखे ओका पास लि गया. ");
INSERT INTO goj_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","पर जब वे गर्दी का कारण ओका पास नी पहुची सक्या, ते उनने उ छत खे जेका नीचे उ थो, खोली दियो अरु जब ओखे लटकै चुक्या ते ओकी खटिया खे जेका पर लखवा को मार्यो हुयो पड्यो थो, उतारी दियो. ");
INSERT INTO goj_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","यीशु ने उनको विश्वास देखीखे ओखे लखवा लग्याआला खे बोल्यो, “हे बेटा तरो पाप माफ हुयो.” ");
INSERT INTO goj_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","तब कोय व्यवस्था का शिक्षक जो व्हा बठ्या था वे अपना अपना मे मन बिचार करण लग्या. ");
INSERT INTO goj_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“यो इन्सान क्यु असो बोलस हइ? यो तो परमेश्वर की मजाक करस हइ, परमेश्वर खे छोड अरु कोन पाप माफ करी सकस हइ?” ");
INSERT INTO goj_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","यीशु ने तुरुत अपनी आत्मा मे जानी लियो, कि वे अपना मन मे असो बिचार करी रा हइ, अरु उनसे बोल्यो “तुम अपना मन मे यो बिचार क्यु करी रा हय?” ");
INSERT INTO goj_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","सरल का हइ? लखवो लगना से यो बोलनो हइ कि तरा पाप माफ हुया, यो बोलनो हइ, कि उट अपनी खटिया उठैइखे चल फिर. ");
INSERT INTO goj_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","पर जेका से तुम जानी ले कि इन्सान का बेटा खे धरती पर पाप माफ करण को अधिकार हइ, ओने उ लखवो लग्या हुया से बोल्यो. ");
INSERT INTO goj_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“मी तोखे बोलुस हइ. उट, अपनी खटिया उठैइखे घर चली जा.” ");
INSERT INTO goj_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","उ उठ्यो, अरु तुरुत खटिया उठैइखे सब का सामने से नीकलीखे चली गयो. येका पर सब अचम हुया, अरु परमेश्वर कि महिमा करीखे बोलन लग्या, हमने असो कभी नी देख्यो. ");
INSERT INTO goj_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","उ फिर नीकलीखे नदी का किनार गयो, अरु पुरी गर्दी ओका पास अय, अरु उ उनखे शिक्षा देन लग्यो. ");
INSERT INTO goj_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","जातो हुये यीशु ने हलफइ को बेटो लेवी खे चुंगी की चौकी पर बठ्यो देख्यो, अरु ओका से बोल्यो, “मरा पिछे आ,” अरु उ उठीखे, ओका पीछे अय गो. ");
INSERT INTO goj_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","अरु यीशु ओका घर खाना का लिये बठौ. अरु भोत सा चुंगी लेनआला अरु पापी भी ओका अरु सेवक होन का साथ खानो खान का लिये बठ्या, क्युकी वे भोत झन था, अरु ओका पिछे अयगा था. ");
INSERT INTO goj_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","अरु व्यवस्था का शिक्षक अरु फरीसीहोन ने यो देखीखे, कि उ तो पापीहोन अरु चुंगी लेनआला का साथ खानो खै रो हइ? ओका सेवक होन से बोल्यो, “उ तो चुंगी लेनआला अरु पापीहोन का साथ खास पीस हइ?” ");
INSERT INTO goj_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","यीशु ने यो सुनीखे, उनसे बोल्यो, भलो अच्छा वैद्य की जरुरत नी, पर बीमारहोन खे हइ. मी धर्मीहोन खे नी, पर पापीहोन खे बुलान खे आयो हइ. ");
INSERT INTO goj_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","यहून्ना को सेवक, अरु फरीसी उपास करता था. अन्नत उनने अय खे ओकासे यो बोल्यो. यहून्ना का सेवक अरु फरीसीहोन का सेवक क्यु उपास रखस हइ, पर तरा सेवक उपास नी रखे. ");
INSERT INTO goj_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","यीशु ने उनसे बोल्यो, “जब तक दुलो बरातहोन का साथ र्‍हेस हइ, उ उपास करी सकस हइ? अन्नत जब तक दुलो उनका साथ हइ, तब तक वे उपास नी करी सक्ये. ");
INSERT INTO goj_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","पर उ दिन आये कि दुलो उनसे अलग कर्यो जाये. उ टेम वे उपास कर्ये. ");
INSERT INTO goj_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“नवा कपडा को थेगडो जुन्ना कपडा पर कोय नी लगाय. नी ते उ थेगडो ओमे से कुछ खीची लिये, अगर नवो को पुराना से अरु उ फटी जाये. ");
INSERT INTO goj_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","नवो अंगूर को रस मडकाहोन मे कोय नी रखस, नी ते अंगूर को रस मडकाहोन खे फोडी दिये, अरु अंगूर को रस अरु मडका खे दोइ भी खतम हुइ जाये. पर अंगूर को नवो रस मडका मे भऱ्यो जास हइ.” अंगूर को रस चमडो का झोला मे ");
INSERT INTO goj_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","अरु असो हुयो की उ आराम का दिन खेतहोन मे से हुइ खे जय रा थो. अरु ओका सेवक चलते हुये भुट्टा तोडन लग्या. ");
INSERT INTO goj_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","तब फरीसीहोन ने ओकासे बोल्यो, “देख, यो आराम का दिन उ काम क्यु करस हइ जो अच्छो नी?” ");
INSERT INTO goj_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","“ओने उनसे बोल्यो का तुम ने कभी नी पढ्यो, कि जब दाउद खे जरुरत हुये अरु जब उ अरु ओका साथ भूखा हुये, तब ओने कऱ्यो थो? ");
INSERT INTO goj_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","ओने काय खे अबियातार महायाजक का टेम मे परमेश्वर का घर मे जय खे, दान कि रोटी खइ जेको खानो याजकहोन खे छोडी अरु कोय को भी अच्छो नी, अरु अपना साथीहोन खे भी दियो” ");
INSERT INTO goj_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","अरु “ओने उनका से बोल्यो, आराम को दिन इन्सान का लिये बनायो गयो हइ न की इन्सान अराम का दिन का लिये. ");
INSERT INTO goj_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","येका लिये इन्सान को बेटो अराम का दिन को भी प्रभु हइ.” ");
INSERT INTO goj_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","अरु उ आराधनालय मे गयो व्हा एक इन्सान थो जेको हात सूखी गयो थो. ");
INSERT INTO goj_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","अरु ओका उपर इलजाम लगाना का लिये ओका हात मे लग्या हुया था, कि देखनु, उ अराम का दिन मे अच्छो करस हइ कि नी. ");
INSERT INTO goj_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","ओने सुख्या हाथआला इन्सान से बोल्यो, “बीच मे खडो हो.” ");
INSERT INTO goj_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","अरु उनसे बोल्यो, अराम का दिन भलो करणो अच्छो नी हइ या बुरो करणो, जान खे बचानु या मरी जानु? पर वे चुप र्‍हिया. ");
INSERT INTO goj_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","अरु यीशु ने मन की करता से उदास हुइ खे, उन खे घुस्सा से चारी तरफ देख्यो, अरु उ इन्सान से बोल्यो “अपनो हात बडा” ओने बडायो, अरु ओको हात अच्छो हुइ गयो. ");
INSERT INTO goj_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","तब फरीसी बाहेर जैइखे तुरुत हेरोदियहोन,का साथ ओका खिलाप मे सम्मती करण लग्या, कि ओखे कोनता वजेसे नाश करणु. ");
INSERT INTO goj_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","अरु यीशु अपना सेवक होन,का साथ नदी का, तरप चली गया, गलील अरु यहूदीया परदेस से बडी गर्दी ओका पिछे नीकल्यो. ");
INSERT INTO goj_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","अरु यहूदीया, अरु यरुशलेम, अरु इदूमीया, अरु यरदन नदी का पार, अरु सूर अरु सैदा का आस पास से एक बडी गर्दी यो सुनीखे कि उ कसो अचमकाम करस हइ ओका पास अय. ");
INSERT INTO goj_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","अरु ओने अपना सेवक होन से बोल्यो गर्दी का कारन एक छोटो डोंगा मरा लिये तैयार रख जब की वे मखे घेरी नी सखे. ");
INSERT INTO goj_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","क्योकी ओने भोत झन खे अच्छो कर्यो थो. येका लिये जेत्ता दुन्या रोग से पिडीत था, ओखे छिन का लिये ओका पर गिरी पड्या था. ");
INSERT INTO goj_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","अरु बुरी आत्मा ओखे देखती थी ते ओका आगे गिरी पडी थी, अरु चिल्लय खे बोलती थी कि “तू परमेश्वर को बेटो हइ.” ");
INSERT INTO goj_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","अरु यीशु ने बुरी आत्मा खे आज्ञा दी कि, व्हा कोय खे भी नी बतानु कि व्हा कोन हइ. ");
INSERT INTO goj_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","तब यीशु एक टेकडा पर चढी गयो, अरु जेखे व्हा चाहतो थो उनखे अपना पास बुलाया. अरु वे ओका पास चली आया. ");
INSERT INTO goj_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","तब ओने उन खे बारा झण, खे नीयुक्त कर्यो, कि वे ओका साथ र्‍हिये, अरु उ उनखे भेज्ये, कि प्रचार कर्ये. ");
INSERT INTO goj_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","अरु बुरीआत्माहोन खे नीकालन को अधिकार दियो. ");
INSERT INTO goj_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","अरु वे ये हइ शमौन जेको नाम ओने पतरस रख्यो. ");
INSERT INTO goj_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","अरु जब्दी को बेटो याकूब, अरु याकूब को भैइ यहून्ना, जेको नाम ओने बुअनरगिस मतलब गर्जन को बेटो रख्यो. ");
INSERT INTO goj_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","अरु अन्द्रियास अरु फिलिप्पुस, अरु बरतुल्मै, अरु मत्ती, अरु थोमा, अरु हलफइस को बेटो याकूब, अरु तद्दै, अरु शमौन कनानी थो. ");
INSERT INTO goj_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","अरु यहूदा इस्करियोती जेने वोखे पकडइ दियो. ");
INSERT INTO goj_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","अरु वु घर मे आयो. अरु फिर एक असी बडी दुन्या होन एक साथ का जमा हुइ गया. की वे रोटी भी नी खय सक्या. ");
INSERT INTO goj_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","जब यीशु का कुटुब परीवार ने यो सुन्यो ते वे ओखे पकडन का लिये नीकल्या क्यु कि उनको बोलनो यो थो की ओको मन जगा पर नी थो. ");
INSERT INTO goj_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","तब शास्त्रिहोन जो यरुशलेम से आया हुया “था, बोली रा था, येमे सैतान समायोस हइ, अरु उ सैतान की बुरी आत्मा को मुखियो की मदत से बुरीआत्माहोन खे नीकालस हइ.” ");
INSERT INTO goj_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","तब वोने उन खे वो का पास बुलयखे अरु उनका से दृष्‍टान्‍त मे बोलन लगी गो, सैतान कसो सैतान खे, नीकाली सकस हइ? ");
INSERT INTO goj_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","आपस मे कोय राज्य मे फुट पडी जाह्ये, ते वू राज्य जगा पर शांत सनी र्‍ही सखे. ");
INSERT INTO goj_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","अगर कोइ घर मे फुट पडी जाह्ये ते, वू घर बन्यो नी र्‍ही सखे. ");
INSERT INTO goj_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","अरु अगर सैतान अपना खिलाफ उठी खे खडो हुये. अरु उनमे फुट पडी जाह्ये, ते वू जगा पर नी र्‍ही सकन को, पन वोको नाश हुये. ");
INSERT INTO goj_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","पन कोइ इन्‍सान से कोइ बलवान इन्सान का घर मे घुसी खे, वोकी संपत्ती नी लुटी सखे, जब तक की वु बलवान इन्सान खे बाधी नी ले. येका बाद मे वु वोका घर खे लुटी सख्ये. ");
INSERT INTO goj_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","मी तुमारा से सच्ची बोलुस हइ, इन्सान का बच्चा का सब पाप अरु नीन्दा जो वे माफ करस हइ, वे माफी मीली जाह्ये. ");
INSERT INTO goj_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","पर जो कोइ पवित्र आत्मा का खिलाप नीन्दा कर्‍हे, ओखे कभी माफ नी कर्ये जाये. पर उ अनन्त पाप को अपराधी ठैरायोस हइ. ");
INSERT INTO goj_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","क्यु की वे यो बोलस हइ की ओमे बुरी आत्मा हइ. ");
INSERT INTO goj_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","अरु वोकी माय अरु वोको भैइ व्‍हा पर पहुच्या, अरु बाहेर खडा हुइ खे खबर भेजी अरु वोखे बुला. ");
INSERT INTO goj_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","अरु गर्दी वोका चारी बाजू मे बठी थी, अरु उनने वोखे बोल्यो, “ देख, तरी माय अरु तरा भैइ अरु भैइन बाहेर तोखे ढुडी रास हइ.” ");
INSERT INTO goj_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","ओने जवाब देते हुये उनखे बोल्यो, कोन मरी माय अरु कोन मरो भैइ? ");
INSERT INTO goj_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","अरु अपना चारी तरफ बठ्या आला दुन्या का तरप नजर घुमइ खे वोने बोल्यो, देख मरी माय अरु भैइ अरु बहीन ये हइ. ");
INSERT INTO goj_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","क्यु कि जो कोइ परमेश्वर की इच्छा पर चल्ये, उ मरो भैइ, अरु मरी भैइन, अरु मरी माय. ");
INSERT INTO goj_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","यीशु फिर नदी का किनारा पर शिक्षा देन लग्यो अरु असी बडी गर्दी ओका पास जमा हुइ गी, की उ नदी मे एक डोंगा पर चेडी खे बठी गयो, अरु सब गर्दी जमीन पर नदी का किनारा पर खडा ऱ्हीगा. ");
INSERT INTO goj_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","अरु उ उनखे दृष्‍टान्‍त मे भोत सारी बात सीखान लग्यो, अरु अपनी शिक्षा मे उन खे बोल्यो. ");
INSERT INTO goj_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","सून अरु देख, एक बोनवालो बीज बोन का लिये नीकल्यो. ");
INSERT INTO goj_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","जब बोन का टेम कुछ बीज रस्ता का किनारा मे गिरीगा, अरु पक्षिहोन ने अयखे चुनी लियो. ");
INSERT INTO goj_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","अरु कुछ बीज पत्थर का जमीन पर गिर्‍या गया उनखे भोत मट्टी नी मीली, अरु भोत मट्टी नी मीलना से वे झल्दी उगी सक्या. ");
INSERT INTO goj_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","अरु जब सुरज नीकल्यो, ते जली गया, अरु जडी नी पकडी ते सुखी गया. ");
INSERT INTO goj_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","अरु कुछ बीज होन झाडि मे गिरी गया, अरु झाडि ने बडीखे ओखे दबय दियो, अरु उ पिक्यो नी. ");
INSERT INTO goj_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","पन कुछ बीज होन अच्छी जमीन पर गिर्‍या, अरु उ उगी गया, अरु बडिखे पकी गया. अरु कोय तीस गुणा, कोय साठ गुणा, अरु कोय सौ गुना पकी गया. ");
INSERT INTO goj_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","अरु उनने बोल्यो, “जेका पास सुनन का लिये कान हुये, उ सूनी ले.” ");
INSERT INTO goj_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","जब यीशु येकलो ऱ्ही गयो, ते ओका सात आलाहोन ने वे बारा समेत ओका से यो दृष्‍टान्‍त का बारे मे पुछ्यो. ");
INSERT INTO goj_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","ओने उनका से बोल्यो, तुम खे तो परमेश्वर का राज्य की भेद की समझ दी गय हइ, पन बाहेर आला का लिये सब बात काहानी मे होस हइ. ");
INSERT INTO goj_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","येकालिये की वे देखेता हुये देखे अरु उनखे देखनु नी पडे अरु सुनते हुये सुने भी अरु नी समझे कि असो नी होनु कि वे फिर, अरु माफ कर्यो जाह्ये. ");
INSERT INTO goj_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","फिर यीशु उनका से बोल्यो “तुम या काहानी नी समझस? ते फिर अरु सब दृष्‍टान्‍त खे कसा समझे? ");
INSERT INTO goj_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","बोन आलो परमेश्वर वचन बोस हइ? ");
INSERT INTO goj_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","जो रस्ता का किनार को हइ झा पर वचन बोयो जास हइ, ये वे हइ, कि जब उनने सुन्यो, ते सैतान झल्दी अयखे वचन खे जो उनने बोयो गयो थो, उठय ली जास हइ. ");
INSERT INTO goj_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","अरु असो ही जो इन्सान फथरेली जमीन पर बोयो जास हइ, ये वे हइ, कि जो वचन खे सुनी खे झल्दी आनन्द से अपनय लेस हइ. ");
INSERT INTO goj_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","पन अपना अंदर कि जडी नी रखन का कारण वे थोडासा दिन का लिये ऱ्हेस हइ, येका बाद वचन का कारण उन पर दुख या उपद्रव होस हइ, ते वे झल्दी ठोकीखे खास हइ. ");
INSERT INTO goj_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","अरु जो झाडिहोन मे बीज बोयो गयो ये वे हइ जेने वचन सुन्यो, ");
INSERT INTO goj_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","अरु जगत की फिकर अरु धन को धोको अरु चीजहोन को लोभ ओमे टेम खे वचन खे दबय देस हइ अरु उ बिना फल को ऱ्हि जास हइ. ");
INSERT INTO goj_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","अरु थोडा दुन्या अच्छी जमीन मे बोयो गयो, ये वे हइ, जो वचन सुनीखे अपनास अरु फल लास हइ, कोय तीस गुणा, कोय साठ गुणा, अरु कोय सौ गुणा.” ");
INSERT INTO goj_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","अरु यीशु ने उन का से बोल्यो, दिवा खे येकालिये लास हइ कि टोपली अरु खटीया का नीच्चे रख्यो जाह्ये? येकालिये नी कि दिव्वो रखन कि जगा पर रख्यो जाह्ये? ");
INSERT INTO goj_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","जो कुछ भी लुक्यो हइ, ओखे बाहेर लायो जाह्ये अरु जो कुछ झाक्योस हइ, ओखे उजागर कर्यो जाह्ये. ");
INSERT INTO goj_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","अगर कोय खे कान हइ ते सुनीले. ");
INSERT INTO goj_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","फेर ओने ओखे बोल्यो, तु जो कुछ सूनन का लिये तैयार र्‍हे. जो माफ से तुम मोजी दिहे ओखे तुमारा लिये मोजी खे दिहे, तुम खे भी जादा देना मे आह्ये. ");
INSERT INTO goj_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","क्‍योकी जो खे हइ, वोखे दियो जाह्ये, अरु जेखे नी हइ, वोखे हूये नी, वे भी उनका पास नीकाली लीयो जाह्ये. ");
INSERT INTO goj_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","यीशु ने बोल्यो, “परमेश्वर को राज्य असो हइ जसो जो इन्सान ने जमीन मे बीज बोयी दियो. ");
INSERT INTO goj_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","अरु रात खे सोयो, अरु दिन मे जाग्या अरु व्हा बीज असो उगायो अरु बड़िगा की व्हा नी मालुम ");
INSERT INTO goj_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","जमीन आपो आप पीक दिहे. पहीली कोम फिर बोन्‍ड अरु भुट्टा मे भर्‍याआला दाना. ");
INSERT INTO goj_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","पर जब दानो पकी जास हइ, तब उ जल्दी दराती से काटस हइ, क्योकी काटन को टेम अय गयोस हइ.” ");
INSERT INTO goj_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","फिर ओने बोल्यो, “हम परमेश्वर का राज्य कि तुलना कोय से करस, अरु कोय दृष्‍टान्‍त से वर्णन करणु. ");
INSERT INTO goj_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","उ रइ को दाना जसो हइ. उ जमीन मे बोन की जगा पर सब दाना मे बारीक हुये. ");
INSERT INTO goj_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","फिर भी बोना का बाद नीकली खे सब बगीचा का रोप मे बडो हूय जास हइ अरु वोमे बडी डग्‍यान नीकलस हइ, जेका से बद्दल मे उडन आली पक्षिहोन भी वोका खोरा मे घोसलो बनास हइ.” ");
INSERT INTO goj_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","उ उनखे असी कयी दृष्‍टान्‍त का वजेसे वचन सूनातो थो, जोत्ता वे समजी सकस हइ ओतो ही ओतो ही बतायो थो, ");
INSERT INTO goj_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","अरु वू दृष्‍टान्‍त का बिना उनका से कुछ नी बोलतो थो. पन एकला मे अपना सेवक होन खे सब कुछ समजातो थो. ");
INSERT INTO goj_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","उ दिन जब संजा हूइ, ते वोने वोका से बोल्‍यो, “आ हम व्हा जाये.” ");
INSERT INTO goj_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","अरु गर्दी खे छोडी खे उनका जसा व्हा पर था, उनखे अपना साथ डोंगा मे लि लीयो अरु व्हा वोका साथ अरु भी डोंगा होन था. ");
INSERT INTO goj_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","जब एक भयानक तूफान आयो अरु लाट डोंगा खे टकरान लगी ह्‍या तक की पाणी डोंगा मे भरन लग्यो. ");
INSERT INTO goj_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","अरु व्हा खूद पिछे का भाग मे उस्तो अरु गद्दा पर सोयो थो अरु सेवक ने ओखे उठायो अरु बोल्यो “हे गुरुजी, तुमखे चिंता नी हइ, की हमारो नाश हूय जाह्ये ते का तोखे?” ");
INSERT INTO goj_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","जब ओने उठीखे जाना का बाद वोने तूफान खे धमकयो, अरु पानी खे बोल्यो, “शान्त र्‍हे, अरु रुखी जा” अरु तूफान रुखी गयो अरु सब कुछ शान्त हूय गयो. ");
INSERT INTO goj_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","ओने उनखे बोल्यो, तुम इत्तो डरस क्यु हइ? या कसी बात हइ की तुमारा मे विश्वास नी हइ. ");
INSERT INTO goj_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","अरु वे एक दम डरी गा अरु आपस मे बोलन लग्‍या, अन्नत : यो कोन आय? की येका बोलना से तूफान अरु पाणी, “लहर भी येकि बात मानस हइ!” ");
INSERT INTO goj_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","फिर वू नद्दी का आगे गेरासेनीयहोन का देश मे पहुच्या, ");
INSERT INTO goj_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","अरु उ डोंगा से उतर्‍यो ते, तुरुत एक इन्‍सान जोमे बुरी आत्मा, थी, कब्र से नीकलीखे ओखे मील्‍यो. ");
INSERT INTO goj_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","उ मरगट मे र्‍हिया करतो थो अरु कोय ओखे साकल से भी नी बाधी सकता था. ");
INSERT INTO goj_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","क्युकी उ बार-बार बेडिहोन अरु साकलहोन से बाध्यो गयो थो, पर ओने साकल खे तोडी दियो, अरु बेडिहोन खे टुकडा-टुकडा करी दिया था, अरु कोय ओखे कब्जा मे नी करी सकता था . ");
INSERT INTO goj_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","उ लगातार रात-दिन मरगट अरु टेकडीहोन मे चिल्लाते अरु पत्थरहोन से अपना आप खे घायल करतो थो. ");
INSERT INTO goj_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","उ दूर से यीशु खे देखीखे दौवड्यो, अरु ओका पाय पर घुटना का बल गिर खे प्रणाम करयो. ");
INSERT INTO goj_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","अरु जोर से चील्लय खे बोल्‍यो, परम प्रधान परमेश्वर को बेटो यीशु, मेखे तरा से काम? मी तोखे परमेश्वर की कसम दिउस मेखे सजा मत दे ");
INSERT INTO goj_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","क्युकी उ ओका से बोली रो थो, “हे बुरी आत्मा, यो इन्‍सान मे से नीकली जा.” ");
INSERT INTO goj_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","यीशु ने ओका से पुच्छो, तरो नाम का हइ? ओने ओकासे बोल्‍यो मरो नाम सेना हइ. क्युकी हम भोत झन हइ. ");
INSERT INTO goj_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","अरु वोने वोका से गिडगीड्य खे प्रार्थना करी की हमखे यो देस का बाहेर नी भेजनू. ");
INSERT INTO goj_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","व्हा पहाड पर एक डुक्कर होन को एक बडो धन चरीरो थो. ");
INSERT INTO goj_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","अरु उनने ओकासे प्रार्थना करते हुयो बोल्‍यो हमखे वे डुक्कर मे भेज की हम मीली जाह्ये. ");
INSERT INTO goj_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","येका लिये ओने उनखे आज्ञा दि. अरु बुरी आत्मा होन ओमे से नीकली खे डुक्करहोन का अंदर गइ. अरु डूक्करहोन को जो बडो झुण्ड जो नजीकपास दो हजार को थो पहाड पर से झील मे गीरी खे डुबीखे मरी गया. ");
INSERT INTO goj_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","उन डुक्करहोन खे चरान आला ने भागी खे नगर मे अरु गाव मे या खबर सुनय, अरु दुन्‍या होन जो कुछ हुयो थो वोखे देखन खे आया. ");
INSERT INTO goj_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","तब वे यीशु का पास आया, अरु जो इन्सान मे जो बुरीआत्मा थी जेमे सेना जमाइ थी, कपडा पेन्‍या अरु अच्छो बठ्यो देखीखे डरी गया. ");
INSERT INTO goj_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","जो इन्सान होन ने यो देख्‍यो थो ओमे बुरीआत्मा लग्‍यो आलो इन्सान अरु डुक्कर का बारे मे सब कुछ हूयो जो, उनखे बतायो. ");
INSERT INTO goj_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","फिर यीशु अरु अपना देस से जान का लिये प्रार्थना करण लग्‍यो. ");
INSERT INTO goj_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","अरु जब वु डोंगा मे चडन लग्यो ते वू इन्सान जो पैयले बुरीआत्मा थी प्रार्थना करण लग्यो कि मेखे भी तरा सात र्‍हेन दे. ");
INSERT INTO goj_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","फिर भी ओने ओखे आन नी दियो अरु वोखे बोल्‍यो, अपना कुटुम होन का पास घर मे जा अरु वुन खे बता की परमेश्वर ने तरा लीये कसो बडो काम कर्‍यो, अरु वोने तरा पर कसी दया करी. ");
INSERT INTO goj_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","व्हा जयखे दिकापुलीस सेवक नगर का बडा देस मे या बात को प्रचार करण लग्या कि यीशु ने मरा लिये कसो बडो काम कर्यो हइ. अरु सब दुन्या अचम्भो करतो थो. ");
INSERT INTO goj_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","जब यीशु डोंगा से वा पार गयो, ते एक भोत बडी वोका चारी तरफ अरु एक जगा जमा हूइ गा, अरु व्हा नद्दी का किनारा पर था. ");
INSERT INTO goj_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","फिर आराधनालय का अधिकार मे से याइर नाम को एक इन्सान आयो अरु वोखे देखी खे वोका पाय पर गीरी गयो, ");
INSERT INTO goj_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","अरु यो बोलिखे ओका से प्रार्थना करिखे बोलन लगी का मरी छोटी बेटी बिमार हइ. तू अयखे ओका पर हात रख कि वा अच्छी हुइ जाय अरु जिन्दी र्‍हे. ");
INSERT INTO goj_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","तब यीशु ओका साथ गयो. अरु बडी गर्दी ओका पिछे चलन लगी, ह्या तक कि इन्सानहोन कि गर्दी ओका पर गिरी पडी थी. ");
INSERT INTO goj_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","एक बय थी जो बारा साल से खुन बगरन की बीमारी थी, ");
INSERT INTO goj_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","अरु जेने भोत से वैद्य से इलाज करायो, अरु अपना सब पैसा खर्च करण पर भी ओखे कुछ लाभ नी मील्यो, पर अरु भी बीमार हुइ गइ थी. ");
INSERT INTO goj_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","ओने यीशु का बारे मे सुनी खे, गर्दी मे ओका पिछे-पिछे अय अरु ओका कपडा खे छि लियो. ");
INSERT INTO goj_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","क्युकी वा बोलती थी कि मी ओका कपडा खे छि लियु ते मी अच्छी हुइ जायु. ");
INSERT INTO goj_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","अरु तुरुत ओको खुन बोहानो बंद हूयगो, अपना आंग मे सोची लियो कि मी बीमारी से अच्छी हुइ गइ. ");
INSERT INTO goj_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","यीशु ने तुरुत अपना मे जानी लियो, कि मरासे सामर्थ्य नीकली हइ, अरु गर्दी मे पीछे फिरी खे पूछ्यो, “मरा कपडा कोने छिया?” ");
INSERT INTO goj_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","ओका सेवक ने ओखे बोल्‍यो, तु तो देखी रो थो की गर्दी तरा पर गिरी पडस अरु तु बोलस, की मेखे हात कोने लगायो? ");
INSERT INTO goj_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","जब ओने वा बय खे जो यो कर्‍यो थो यो देखन खे चारी तरफ देखन लग्यो. ");
INSERT INTO goj_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","फिर भी वा बय जो कुछ वोका सात हूयो थो वु समजी खे डरस अरु कापते हुइ अय वोका सामने गीरी गय, अरु वोने सब कुछ सच्ची सच्ची बतय दियो. ");
INSERT INTO goj_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","वोने ओकासे बोल्‍यो, “बेटी तरा विश्वास ने तोखे अच्छो कर्‍योस. शांती से जा अरु अपनी बीमारी से बची र्‍हे,” ");
INSERT INTO goj_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","उ यो बोली र्‍हो थो,कि आराधनालय का सरादार का घर से दुन्याहोन ने अय खे बोल्यो, “तरी बेटी तो मरी गइ. अब गुरु खे क्यु दुख देस हइ.” ");
INSERT INTO goj_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","फिर यीशु ने वा बात खे सुनी ली अरु आराधनालय का अधिकारी खे बोल्यो, डर मत पन विश्वास रख. ");
INSERT INTO goj_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","अरु वोने पतरस, अरु याकूब, अरु याकूब को भैइ यहून्ना खे छोडी खे, अरु कोय खे अपना साथ आन नी दियो. ");
INSERT INTO goj_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","अरु वे आराधनालय का अधिकारी का घर मे आया, ते दुन्‍या होन खे चिल्लाते अरु जोर से रोते विलापते देख्‍यो. ");
INSERT INTO goj_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","जब वु अंदर जइ खे वोने बोल्यो तुम काय का लिये रोय रा अरु चिल्लय रा? बेटी मरी नी, पन सोय रीस हइ. ");
INSERT INTO goj_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","अरु वे ओकी हसी उडान लग्‍या. पन सब खे बाहेर नीकाली खे बेटी का माय बाप अरु वोका सात आलाखे लीखे वोने उ घर मे झा बठी थी व्हा वे गया. ");
INSERT INTO goj_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","अरु बेटी को हात पकडी खे वोने वोखे बोल्यो, तलीता कुमी! येको मतलब हइ, हे बेटी, मी तोखे बोलुस हइ, उट. ");
INSERT INTO goj_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","अरु बारा साल की वा पोरय तुरुत चलन फिरन लगी, येका पर दुन्याहोन खे खुब अचम्बो हुयो. ");
INSERT INTO goj_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","फिर यीशु ने उनखे चेतावनी का साथ आज्ञा दी कि या बात कोय खे मत बतानु, अरु येखे कुछ खान खे दे. ");
INSERT INTO goj_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","यीशु व्हा से नीकलीखे उ अपना नासरत गाव मे आयो, अरु ओका सेवक ओका पिछे चल्‍या. ");
INSERT INTO goj_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","अरु जब आराम को दिन आयो ते उ आराधनालय मे शिक्षा देन लग्यो, अरु सब सुनन आला अचम हुय गया अरु बोलन लग्या, ये भोत खे या बात खा से अय गी? अरु या कसी बात हइ जो येखे दि, अरु येका हात से कसो चमत्कार को काम हुयो हइ. ");
INSERT INTO goj_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","उ बडाइ नी, जो मरियम को बेटो अरु याकूब, योसेस, यहूदा, अरु शमौन को भैइ हइ, ओकी भैइन ह्या हमारा बीच मे नी र्‍हेस? येका लिये उनने ओखे नी बोली दियो. ");
INSERT INTO goj_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","यीशु ने उनका से बोल्यो, “भविष्यव्दक्ता को अपनो देस, अरु अपना कुटुम, अरु अपना घर खे छोड अरु कही भी अपमान नी होस.” ");
INSERT INTO goj_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","अरु उ व्हा कोय सामर्थ्य को काम नी करी सक्यो फक्त जरासो बिमारहोन पर हात रखीखे उनखे अच्छो कर्यो. ");
INSERT INTO goj_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","अरु ओने उनका अविश्वास पर बडो अचम हुयो, अरु उ चारी तरफ का गावहोन मे उपदेस दी र्‍हो थो. ");
INSERT INTO goj_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","अरु ओने बारा चेला खे अपना पास बुलैइ खे उनखे दो दो करीखे भेजन लग्यो. अरु उनखे बुरी आत्माहोन पर अधिकार दियो. ");
INSERT INTO goj_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","अरु ओने उनखे आदेस दी कि “रस्ता का लिये लकडी छोड अरु कुछ नी लेनु, नी ते रोटी, नी झोरो, नी थैली मे पैसा. ");
INSERT INTO goj_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","पर जूताहोन पेन्नु अरु दो कुर्ता नी पेन्नु.” ");
INSERT INTO goj_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","अरु ओने उनसे बोल्‍यो, झा तुमारो स्वागत हुये उ घर मे उतर्ये ते जब तक व्हा से बिदा नी होनु, तब तक उ घर मे बठ्यो र्‍हेनु. ");
INSERT INTO goj_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","अरु झा तुमखे दुन्या अपनान, नी कर्‍हे या तुमारी बात नी सुने, व्हा से चलते हि अपना तरवाहोन की धूल झाडि डालनु, कि उन पर गवाही हुये. ");
INSERT INTO goj_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","अरु उनने जैइ खे प्रचार कर्‍यो कि अपनो मन फिरानु. ");
INSERT INTO goj_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","अरु वे भोत सी बुरीआत्माहोन खे नीकलते अरु भोत बिमारी पर तेल लगय खे उनखे अच्छो कर्यो. ");
INSERT INTO goj_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","अरु हेरोदेस राजा ने ओकी चर्चा सुनी, क्युकी ओको नाम फैल्यो गयो थो, अरु ओने बोल्यो, कि “यहून्ना बपतिस्मा देनआला मऱ्या हुया मे से जिन्दो उठ्यो हइ, येका लिये यो सामर्थ को काम प्रकट होस हइ.” ");
INSERT INTO goj_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","अरु दुसरा ने बोल्यो “यो एलिय्याह हइ” पर दुसरा ने बोल्यो भविष्यव्दक्ता या भविष्यव्दक्ताहोन मे से एक का जसो हइ. ");
INSERT INTO goj_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","हेरोदेस ने यो सुनीखे बोली, “जो यहून्ना को माथो मेने कटवायो थो, उ जिन्दो उठ्यो हइ. ");
INSERT INTO goj_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","क्योकी हेरोदेस ने खुद अपना भैइ फिलिप्पुस की लुगइ हेरोदेस का कारन जेका से ओने भ्याव कर्यो थो, दुन्या खे भेजीखे यहून्ना खे पकडय खे बन्दीगृह मे डाली दियो थो. ");
INSERT INTO goj_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","क्युकी यहून्ना ने हेरोदेस से बोल्यो थो, की तोखे अपना भैइ की लुगइ खे रखनो अच्छो नी.” ");
INSERT INTO goj_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","येकालिये हेरोदेस ओकासे बैर रकती थी अरु यो चाहती थी की ओखे मारी डाल्ये. पर असो नी हुइ सक्यो. ");
INSERT INTO goj_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","क्योकी हेरोदेस यो समजी खे यहून्ना से डरतो थो कि वु धर्मी अरु पवित्र इन्सान हइ, अरु वोकी रक्षा करस. अरु जब वु वोकि सुनतो थो ते खुप घबरई जातो थो, फिर भी खुशी से सुनतो थो. ");
INSERT INTO goj_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","अरु बरोबर टेम पर जब हेरोदेस ने अपनो जन्मदिन पर प्रधानहोन अरु सेनापतिहोन अरु गलील का बुर्जुक दुन्याहोन का लिये मीजवानी करी. ");
INSERT INTO goj_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","अरु उ हेरोदेस खे अरु ओका साथ बठनआला खे खुस कर्यो. तब राजा ने पोर्येइ से बोल्यो, “तू जो चाह्ये मरासे माग मी तोखे दियू.” ");
INSERT INTO goj_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","अरु ओने कसम खै, “मी अपनो आधो राज तक जो कुछ तू मरासे माग्ये मी तोखे दिह्यू.” ");
INSERT INTO goj_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","ओने बाहेर जइ खे अपनी माय खे पुछो, मी का मागु “अरु वोने बोल्यो,” “यहून्ना बपतिस्मा देन आलो को माथो.” ");
INSERT INTO goj_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","वा तुरुत राजा का पास अंदर अय ओकासे प्रार्थना करी, “मी चाहुस कि तु यहून्ना बपतिस्मा देनआलो को माथो एक ठाटी मे मेखे दे.” ");
INSERT INTO goj_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","तब राजो खुप उदास हुयो, फिर भी अपनी कसम अरु मीजवान होन का वजेसे व्हा वोकी प्रार्थना अपना यो करणो नी चाहतो थो. ");
INSERT INTO goj_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","राजा ने तुरुत एक जल्लाद खे भेज्यो अरु बोल्यो की वोको माथो ली खे आ. ओने जेल मे जइ खे ओको माथो काट्यो, ");
INSERT INTO goj_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","अरु वोखे ठाटी मे रखी खे अरु लय खे पोरय खे दियो अरु पोरय ने अपनी माय खे. ");
INSERT INTO goj_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","जब वोका सेवक होन ने या बात सुनी ते अयखे वोकी लास खे लिखे गया अरु वोखे एक कब्र मे रख्यो. ");
INSERT INTO goj_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","प्रेरित यीशु का पास अयखे जमा हुया अरु जो कुछ वुनने कर्‍यो थो अरु सिकायो थो वोको सब को वर्णन कर्‍यो. ");
INSERT INTO goj_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","वोने वुनखे बोल्‍यो आ अरु सुनसान मे चली खे थोडी देर आराम कर. क्युकी व्हापर भोत झन अय अरु जय रा था, ह्या तक की वुनखे खानो खान को भी अवसर नी मील्यो थो ");
INSERT INTO goj_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","अन्त मे वु एकलो डोंगा मे चडी गो सुनसान जगा मे चली गयो. ");
INSERT INTO goj_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","अरु दुन्‍या होन ने वुनखे जाते देख्यो अरु भोत झन ने उनखे पहीचानी लीयो, अरु सब नगर अरु गाव से दुन्या होन पयदल दौवडी खे ओका पैयले वा जगा पर जइ पहुच्या. ");
INSERT INTO goj_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","अरु डोगापर से उतरी खे वोने एक बडी गर्दी खे देखी अरु वोखे वुनका पर दया अय क्युकी वे मेढा का जसा था जीन को कोय रख आलो नी थो. अरु वू वुनखे भोत बात बतान लग्यो. ");
INSERT INTO goj_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","दिन डुबी गयो ते उ, सेवक वोका पास आया अरु बोलन लग्यो, “या जगा सुनसान हइ दिन पुरो डुबी गो थो. ");
INSERT INTO goj_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","उनखे भेज कि आस पास का खेत मे अरु गाव मे जयखे अरु अपना लिये कुछ खान का लिये मोल ला. ");
INSERT INTO goj_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","“पन यीशु ने उत्तर देते हुये बोल्यो,” कि तु इनखे कुछ खान खे दिदे वुनने वोखे बोल्यो, हम एक झन खे सौ सिक्का, “की मजुरी की रोटी मोल ला अरु वुनखे खान खे दे?” ");
INSERT INTO goj_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","ओने वोखे बोल्यो, तरा पास केतनी रोटी हइ? जय खे देख वोने देखी खे बतायो, पाच रोटी अरु दो मंछी. ");
INSERT INTO goj_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","तब यीशु उनखे आज्ञा दि, कि सब खे हरी घास पर पगत होन मे बठैइ दे. ");
INSERT INTO goj_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","अरु दुन्या पचास पचास अरु सौ सौ की पगत मे बठी गा. ");
INSERT INTO goj_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","वोने पाच रोटी अरु दो मंछी ली अरु स्वर्ग का तरप करी अरु आशिर्वाद माग्यो अरु पाच रोटि तोडी अरु वोने सेवक होन खे देतो गयो की वे उनखे बाटी दे, अरु वोमे दो मंछी खे भी वुन मे बाटी दे. ");
INSERT INTO goj_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","अरु सब ने खायो अरु धन्य हुया. ");
INSERT INTO goj_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","वुनने रोटी का तुकडा अरु मंछी से भरी हुइ बारा टोपली उठइ. ");
INSERT INTO goj_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","अरु खान आला की सख्या मे से सीरीप इन्सान पाच हजार था. ");
INSERT INTO goj_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","तब वोने सेवक होन खे झल्दी डोंगा पर चड अरु अपना से पैयले बैतसैदा की दुसरी तरप जान खे बोल्‍यो, जबकी वु खुद गर्दी खे बिदा करण लग्यो. ");
INSERT INTO goj_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","अरु जब वु वुनखे बिदा करण चुक्यो ते वु पहाड मे प्रार्थना करण गयो. ");
INSERT INTO goj_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","जब सज्जा हुइ ते डोंगा पाणी का बिच मे आयो थो, अरु ऊ येकलो जमीन पर थो. ");
INSERT INTO goj_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","जब वोने उनखे बडी मुसीबत मे देख्यो, क्योकी हवा वुन का तरप फिरी, ते रात का लग भग तिन बज्या, वु वुन का पास पानी पर चलतो हुयो आयो, अरु वोने आगे नीकली जानो चाह्यो. ");
INSERT INTO goj_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","पन जब उनने वोखे पानी पर चलते देख्यो, ते वुनखे लग्यो कि, यो भुत आयो, अरु वे चिल्लन लगया ");
INSERT INTO goj_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","क्युकी सब ने वोखे देख्यो अरु डरीगा था. पन वोने तुरुत उनखे खुद उ उनका से बोल्यो, हिम्मत रख मी आयो, डरनु मत. ");
INSERT INTO goj_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","जब वू उनका सात डोंगा पर चडी गयो,अरु तुफान रुखी गो, ");
INSERT INTO goj_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","क्योकी रोटीहोन कि घटना से कुछ नी समझ्या था, ते उन को मन कठुर हुय गयो थो. ");
INSERT INTO goj_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","अरु उ पार उतरीखे गनेसरत मे पहुच्या अरु डोंगा खे जमीन पर लगायो. ");
INSERT INTO goj_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","अरु जब वू डोंगा पर से उतर्‍यो, ते दुन्या होन ने तुरुत ओखे पइछानी लीयो. ");
INSERT INTO goj_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","झा कही कभी मसीह यीशु होतो थो, अरु दुन्या भागी भागी खे सब रोगीहोन खे खटिया पर रखीखे वो का पास जाता था. ");
INSERT INTO goj_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","अरु गाव, नगर,अरु झा एक भी वु प्रवेश करतो थो, दुन्या बिमार आला खे बजार मे रखी खे वोने प्रार्थना करी रोथो की वु उनखे अपना कपडा खे हात भी लगदे. अरु जोत नाने भी वोखे हात लगायो, ते अच्छा हुय गया. ");
INSERT INTO goj_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","तब फरीसी अरु कुछ शास्त्रिहोन जो यरुशलेम से आया था ओका पास जमा हुया ");
INSERT INTO goj_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","इन्सान ने देख्यो फरीसी कि पडय का जसो हात धोनो थो, पर सेवक का बिना हात धोयो खानो खाते देख्यो. ");
INSERT INTO goj_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","क्योकी फरीसी अरु सब यहूदीया धर्म बापदादा की पुरानी रितीरिवाज को पालन करस हइ अरु विधी का जसो बिना हात धोया खानो नी खाय. ");
INSERT INTO goj_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","अरु बजार से लाये जो कोय चिज अपनी शिक्षा का अनुसार धोइ लिये, तब तक नी खानु जसो कटोरो, कप अरु ताबा, को बर्तन अरु खटीया बिछानो धोना को अलग-अलग तरीको थो. ");
INSERT INTO goj_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","येकालिये वे फरीसीहोन अरु धर्म शास्त्रिहोन ने यीशु से पूछ्यो, “तरा सेवक क्युकी बापदादाहोन की परम्पराहोन पर नी चले आ, अरु बिना हात धोया अरु जिवन कि रोटी खास हइ?” ");
INSERT INTO goj_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","यीशु ने उनसे बोल्यो, यशायाह ने तुम कपटिहोन खे बारे मे अच्छी ही भविष्यवाणी करी! जसो लिख्यो हइ वे दुन्या होठ से ते मरो सम्मान करस हइ, पर उनको मन मरा से दूर रेस हइ ");
INSERT INTO goj_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","वे व्‍यर्थ मरी उपासना करस हइ, क्योकी इन्सानहोन का नीयम खे परमेश्‍वर को नीयम हइ असो करीखे सिखास हइ. ");
INSERT INTO goj_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“क्योकी तुम परमेश्वर की आज्ञा खे टालस हइ अरु इन्सानहोन की शिक्षाहोन को पालन करस हइ.” ");
INSERT INTO goj_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","यीशु ने उनसे बोल्यो, “तुम अपनी शिक्षाहोन खे बनाए रखन का लिये परमेश्वर की आज्ञा खे टालना मे चलाक हुय गया हइ. ");
INSERT INTO goj_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","क्योकी मूसा ने बोल्यो हइ, ‘अपना बाप अरु माय को सम्मान करणु.’ अरु ‘जो कोय बाप या माय खे बुरो बोल्ये, ओखे नीश्चित मारी डाल्यो जाए.’ ");
INSERT INTO goj_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","तुम सिखास हइ कि अगर कोय अपना बाप या माय से बोल्ये, जो कुछ तोखे दान करी रोस हइ, ‘यो कुरबान हइ’ जेखो मतलब हइ, यो परमेश्वर को दान हइ, ");
INSERT INTO goj_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ते असो इन्सान खे अपना बाप या माय की सेवा नी करण को बहानो मीली जास हइ. ");
INSERT INTO goj_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","यो प्रकार से तुम अपना नीयम बनय खे, परमेश्वर का शिक्षाहोन खे टाली देस हइ. अरु येका वजेसे भोत सा काम करस हइ.” ");
INSERT INTO goj_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","फिर यीशु ने इन्सानहोन खे अपना पास बुलैइ खे उनसे बोल्यो, “तुम सब मरी बात सुन्नु, अरु समझनु. ");
INSERT INTO goj_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","असी कोय चिज नी जो इन्सान मे बाहर से अंदर जैइ खे अच्छो नी कर्‍हे. पर जो चिज इन्सान खे अंदर से बाहर नीकालस हइ, वेमे ओखे अशुध्द करस हइ. ");
INSERT INTO goj_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","जेका कान हइ वे सुन लेनु.” ");
INSERT INTO goj_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","जब उ गर्दी का पास से घर मे गयो, ते ओका सेवक होन ने यो दृष्‍टान्‍त का बारे मे समझय खे बोल्यो. ");
INSERT INTO goj_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","ओने उनसे बोल्यो “तुम भी असो ना समझ हुया, तुम नी समझे कि जो चिज बाहर से इन्सान का अंदर जास हइ, उ ओखे अच्छो नी करी सखे? ");
INSERT INTO goj_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","क्युकी यो तुम्‍हारा मन मे नी, पर पेट मे जास हइ, अरु शौच से बाहर नीकली जास हइ?” यो बोलीखे यीशु ने सब खान की चिज खे अच्छी रखिस हइ. ");
INSERT INTO goj_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","तब ओने बोल्यो, “जो बातहोन इन्सान का अंदर से बाहर नीकलस हइ, उ यो इन्सान खे अशुध्द करस हइ. ");
INSERT INTO goj_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","क्युकी अंदर से, अपना दिल से बुरो बिचार का व्यभिचार खे मारनो, ");
INSERT INTO goj_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","व्‍यभिचार, लालची, कपटी, इर्ष्या, घमण्डी, अरु मूर्खता ");
INSERT INTO goj_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","या सब बुरी बात अंदर से ही नीकलस हइ अरु तुमखे अशुध्द करस हइ.” ");
INSERT INTO goj_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","फिर यीशु व्हा से उठीखे सूर अरु सैदा देस मे चली गयो. अरु एक घर मे गयो अरु उ नी चातो थो कि कोय खे मालुम चले,पन उ लुक्यो नी ऱ्ही सक्यो. ");
INSERT INTO goj_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","अरु एक बय जोकी छोटि बेटी मे बुरी आत्मा थी, यीशु कि बात सुनीखे अय, अरु ओका पाय पर गिरी गइ. ");
INSERT INTO goj_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","गैरयहूदिहोन कि बय या सुरुफिनीकी मे पइदा हुइ थी. ओने यीशु से प्रार्थना करी की मरी बेटी मे से बुरी आत्मा खे नीकाली दे. ");
INSERT INTO goj_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","पर यीशु ने बोल्यो, “पैयले बाच्चाहोन खे तृप्त होन दे, क्युकी बच्चा कि रोटि खे लिखे कुत्ताहोन का आगे डालनो अच्छो नी हइ.” ");
INSERT INTO goj_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","ओने ओखे उत्तर दियो, “सच्ची हइ प्रभु. पर टेबल का नीचे कुत्ताहोन भी तो बच्चा का टुकडा टाकडा खे खास हइ.” ");
INSERT INTO goj_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","यीशु ने ओका से बोल्यो, तू जय जा “तुमारा जबाब से. बुरी आत्मा तरी बेटी मे से नीकली गइ हइ!” ");
INSERT INTO goj_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","ओने अपना घर मे अयखे देख्यो कि पोरई खटीया पर सोइ देखी हइ, अरु बुरी आत्मा नीकली गइ हइ. ");
INSERT INTO goj_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","तब सूर अरु सैदा का प्रदेस से नीकलीखे सिदोन का रस्ता से गलील की झील पहुची खे दिकापुलीस ");
INSERT INTO goj_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","तो इन्सानहोन ने एक बहिरा खे जो मुको भी थो, ओका पास लायो अरु ओकासे प्रार्थना करी कि अपना हात ओका पर रखनु. ");
INSERT INTO goj_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","येकालिये उ ओखे गर्दी से अलग ली गयो, अरु अपनी उगली ओका कानहोन मे डाली, अरु थूकी खे ओकी जीभ खे छियो. ");
INSERT INTO goj_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","अरु यीशु स्वर्ग का तरफ देखीखे आह भरी, अरु ओकासे बोल्यो, “इप्फत्तह!” यानेकी खुली जा! ");
INSERT INTO goj_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","अरु इन्सान को कान खुली गया, अरु ओकी जीभ की गाठ भी खुली गइ, अरु उ सफा बोलन लग्यो. ");
INSERT INTO goj_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","तब यीशु ने इन्सानहोन खे आदेस दियो कि उ कोय से नी बोलनु. पर जोत्तो जादा ओने उनखे आदेस दियो, उत्तर मे उन्‍हे यो नी बतायो. ");
INSERT INTO goj_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","वे सुनीखे भोत चकित हुया, “उ खेत्ता अच्छी तरह से सब कुछ करस हइ!” उनने बोल्यो, “उ भैइ अपुन खे सुनन की, अरु गूगाहोन खे बोलन की ताकत देस हइ!” ");
INSERT INTO goj_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","वे दिन मे फिर जब बडि गर्दी एक जगा जमा हूय गी अरु वोका पास खान खे कुछ नी थो, ते वोने अपना सेवक होन खे बुलय खे बोल्यो, ");
INSERT INTO goj_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“मेखे या गर्दी पर दया आस, क्योकी ये तिन दिन से मरा साथ हइ, अरु वोका पास खान खे कुछ भी हय नी. ");
INSERT INTO goj_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","अगर मी उनखे भुको घर मे भेजी दियु, ते वे रस्ता मे गली जाह्ये अरु भोत झन दुर से आया हइ.” ");
INSERT INTO goj_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","वोका सेवकहोन ने उत्तर दियो, इन खे तुप्त करण खे यो जंगल मे कोय येत्ती रोटी खासे लाहे? ");
INSERT INTO goj_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","“वोने ओका से पुछो का तुम्हारा पास केतनी रोटी हइ?” “वुनने बोल्यो,” सात. ");
INSERT INTO goj_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","जब वोने गर्दी खे जमीन मे बठन खे बोल्यो, अरु वे सात रोटी खे ली अरु परमेश्वर को धन्यवाद करी खे तोडि, अरु अपना चेला होन खे देतो गयो कि उनखे बाट अरु उनने दुन्याहोन का सामने बाटी दि. ");
INSERT INTO goj_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","वुनका पास कुछ छोटी मंछी भी थी ओने परमेश्वर को धन्यवाद करी खे उनखे भी दुन्या का सामने बाटन को आदेश दियो. ");
INSERT INTO goj_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","अरु वे खैय खे तुप्त हुय गा, अरु चेलाहोन ने बच्या हुया टुकडाहोन कि सात टोपलीहोन भरी खे उठइ. ");
INSERT INTO goj_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","अरु दुन्या चार हजार का नजीक पास था. तब ओने दुन्याहोन खे बिदा करी दिया, ");
INSERT INTO goj_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","अरु वु तुरुत अपना सेवक होन का साथ डोंगा पर चडी खे दलमनुता प्रदेस मे चली गयो. ");
INSERT INTO goj_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","कुछ फरीसीहोन अय खे यीशु से वाद विवाद करण लग्या, अरु वोकी परिक्षा करण का लिये ओकासे वे दुन्याहोन ने आश्चर्य कर्म करण का लिये बोल्यो कि उ स्वर्ग से परमेश्वर का तरप से कोनतो चिन्ह बताये. ");
INSERT INTO goj_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","यीशु ने आत्मा मे लंबी सास भरी खे बोल्यो, या पीडि का दुन्या क्यु चिन्ह ढुढस हइ? मी तुम से सच्ची बोलुस हइ, या पीडि खे कोय भी चिह्न नी दियो जाये. ");
INSERT INTO goj_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","अरु व्हा उनखे छोडी खे फिर डोंगा पर चेड्यो अरु दुसरा किनारा पर चली गयो. ");
INSERT INTO goj_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","अरु वे रोटी लेनो भुली गया था, डोंगा मे वुन का पास फक्त एक की रोटी थी. ");
INSERT INTO goj_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","वोने वुन खे चेतावनी दी देख फरीसी यों खमीर अरु हेरोदेस का खमीर से हुशार र्‍हेनु. ");
INSERT INTO goj_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","अरु वे आपस मे बात करी खे बोलन लग्या, हमारा पास रोटि नी हइ. ");
INSERT INTO goj_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","यीशु ने यो जानी खे ओखे बोल्यो, तुम आपस मे बात कर रास हइ कि हमारा पास रोटी नी हइ , तुम अभी तक नी जानी सक्या हइ? का तुम्हारो मन कठोर हुइ गयो हइ. ");
INSERT INTO goj_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","का आख ऱ्ही खे भी का तुम नी दिख्या? कान ऱ्ही खे भी नी सुनाये अरु का तुम खे याद नी अय? ");
INSERT INTO goj_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","जब मेने पाच हजार दुन्याहोन का लिये पाच रोटीहोन तोडि, ते तुम ने टुकडाहोन से भरी केतनी टोपली उठैइ थी सेवक होन ने जवाब दियो “बारा” टोपलीहोन. ");
INSERT INTO goj_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","यीशु ने डबल पुछो का तुम खे याद नी जब मेने चार हजार दुन्या का लिये सात रोटिहोन तोडि ते तुम ने तुकडा से भरी खे सात टोपलीहोन उठय थी उनने ओका से बोल्यो सात टोपली. ");
INSERT INTO goj_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","यीशु ने उनखे बोल्यो, का तुम अभी भी नी समज्या? ");
INSERT INTO goj_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","वे बैतसैदा मे आया, अरु दुन्या होन एक अंधा खे ओका पास लिखे आया, अरु वोका से प्रार्थना करण लग्या, की येखे हात लगा. ");
INSERT INTO goj_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","व्हा से अंधा को हात पकड्यो वोखे गाव का बाहेर लि गयो, अरु वोका आख पर थुक्यो अरु वोका पर हात रखी खे ओखे पुच्छो, का तुमखे दिखै दि र्‍हो? ");
INSERT INTO goj_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","ओने आख उठैइ खे बोल्यो, “मी इन्सान खे देखूस हइ क्युकी वे मेखे चलता हुये दिखै देस हइ जसो झाड.” ");
INSERT INTO goj_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","तब वोने फिर वोका आख पर हात रख्यो अरु बडो अच्छो दिखान लग्यो, अरु वोखे दिखान लगी गो. ");
INSERT INTO goj_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","वोने यो बोली खे घर मे भेजो, यो गाव मे पाय भी नी रखनु. ");
INSERT INTO goj_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","अरु यीशु अपना सेवक का सात कैसरीया फिलीप्पी का गाव मे गयो. रस्ता मे वोने अपना सेवक होन से यो पुच्छो मेखे बाता दुन्या मरा बारे मे का बोलस मी कोन आयो. ");
INSERT INTO goj_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","उनने बोल्यो, यहून्ना बपतिस्मा देन आलो, अरु कुछ झन ने बोल्यो एलिय्याह बोलस, अरु कुछ झन बोलस कि भविष्यव्दक्ता आयो. ");
INSERT INTO goj_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","अरु व्हा वोने सवाल पुचते र्‍हियो, पर तुम का बोलस? मी कोन आय? पतरस ने उत्तर दिखे बोल्यो, तु मसीह हइ. ");
INSERT INTO goj_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","तब ओने उनखे धमकय खे बतायो की वे मरा बारे मे कोय से नी बोलनु. ");
INSERT INTO goj_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","अरु व्हा वु उपदेस देन लग्यो कि उ इन्सान को बेटो भोत दुख झेली रो अरु बापदादा महायाजक होन अरु शास्त्रिहोन का वजेसे ठुकरय खे बुरो जयखे मारी दियो जाह्ये अरु तिन दिन बाद फिर से जिन्दो हुय गयो. ");
INSERT INTO goj_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","वु या बात सपा सपा बोली रो थो. येका पर पतरस ओखे अलग लि जय खे धमकान लग्यो, ");
INSERT INTO goj_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","पन वोने पलटी खे अपना सेवक होन का तरफ देख्यो अरु पतरस खे धमकय खे बोल्यो, ये सैतान, मरा आगे से बाजू हुइ जा. क्युकी तु परमेश्वर की बात पर नी पन इन्सान की बात पर मन लगास. ");
INSERT INTO goj_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","वोने गर्दी अरु अपना सेवकहोन खे अपना पास जमा हुइ खे ओकासे बोल्यो, “ जो कोय मरा पिछे आनो चाह्ये, ते वु अपना आप खे त्याग कऱ्हे, अरु अपनो दुख उठय खे अरु मुत्यु का लिये तैयार ऱ्हेस तब उ मरा पीछे चल. ");
INSERT INTO goj_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","क्योकी जो अपनो जान बचानु चास हइ ते वु वोखे गमय दिहे. पन जो कोय मरा तरप सुसमाचार का लीये अपनो जान गमाह्ये, वु वोखे बचाये. ");
INSERT INTO goj_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","क्योकी अगर इन्सान सब जगत खे मील्हे, अरु अपनो जान प्राप्त करन खे उठा ते वोमे का लाभ हुये? ");
INSERT INTO goj_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","अरु इन्सान अपना जान का बदला का दिये ? ");
INSERT INTO goj_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","जो कोय या व्यभिचारी अरु पापी जाती का बीच मे मरासे अरु मरी बात से लजाह्ये,इन्सान को बेटो भी जब उ पवित्र स्वर्गदूतहोन का साथ अपना बाप की महिमा का साथ आह्ये,तब ओकासे भी लजाह्ये.” ");
INSERT INTO goj_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","वोने वोखे बोल्यो, मी तुम खे सच्ची बोलुस, जो ह्या खडा हइ उनमे से कुछ असा हइ कि जब तक परमेश्वर को राज बडो सामर्थ्य का सात आता हुया नी देखी ले तब तक उ नी मरे. ");
INSERT INTO goj_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","यीशु छे दिन का बाद पतरस अरु याकूब अरु यहून्ना खे अपना सात लीखे गयो, एक उची टेकडी पर सुनसान जगा मे गयो, अरु उनका सामने वोको दुसरो रुप आयो. ");
INSERT INTO goj_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","अरु वोका कपडा येतना चमकन लग्या अरु ह्या तक उजालो हुयो कि पृथ्वी पर कोइ भी धोबी असा नी करी सखे. ");
INSERT INTO goj_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","तीन चेलाहोन को मूसा अरु एलिय्याह दिखाइ दियो, अरु यो यीशु का सात बात करतो थो. ");
INSERT INTO goj_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","येका पर पतरस ने यीशु खे बोल्यो, हे गुरु, हमारा लिये ह्या पर र्‍हेनो अच्छो हइ. येका लिये हम तीन मण्डप बनाया एक तरा लीये, एक मूसा का लीये, अरु एक एलिय्याह का लीये. ");
INSERT INTO goj_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","पतरस अरु ओका सात का खुप डरी गया था. की ओखे समझ मे नी अय ऱ्हियो थो की मी का उत्तर दिउ ");
INSERT INTO goj_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","तब एक बदल आयो अरु उनखे झाकी दियो, अरु वु बद्दल मे से आवाज नीकल्यो, यो मरो लाड को बेटो हइ ओकी सुन्नु. ");
INSERT INTO goj_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","तब वुनने एकदम चारी तरप देख्यो, अरु यीशु खे छोडी खे अपना सात अरु कोय खे नी देख्या. ");
INSERT INTO goj_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","जब वे पहाड का नीचे उतरी रा था, ते वोने आवाज दियो, की जब तक इन्सान को बेटो मरी खे जिन्दो नी होय तब तक कोय खे नी बतानु. ");
INSERT INTO goj_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","अरु वे या बात लीखे ओका पर बात चित करण लगीगा, की मरी खे जिन्दो होन को कारण आया. ");
INSERT INTO goj_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","अरु वे वोखे यो बोलि खे पुछन लगीगा, शास्त्रिहोन का बोलस एलिय्याह का पैयले आनो नीश्वित थो. ");
INSERT INTO goj_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","ओने उनखे बोल्यो, एलिय्याह खे पहिले अय खे सब कुछ सुदारनो थो. फिर भी इन्सान का बेटा का बारे मे काय बर लीख्यो हइ की उ भोत दुख झेल्यो अरु उ बेकार गिन्यो जाह्ये. ");
INSERT INTO goj_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","पण मी तुमखे बतवूस की एलिय्याह अभी भी अय चुक्यो हइ, अरु उनका बारे मे जसो धर्मग्रन्‍थ मे लिख्यो हइ, उनने उनका साथ मनमानी व्यव्हार कर्यो. ");
INSERT INTO goj_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","अरु जब वे सेवक का पास आया ते देख्यो की उनका पास चारी तरप घन्नी गर्दी हइ अरु कुछ शास्त्रिहोन ओकासे वाद विवाद करी रा था. ");
INSERT INTO goj_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","पन जब गर्दी ने ओखे देख्यो ते सब झन अचम मे पडी गया, वे दौडी खे उनका पास आया अरु उनखे प्रणाम कर्यो. ");
INSERT INTO goj_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","ओने ओकासे पूछ्यो का तुम ओका साथ वाद विवाद करी र्‍हा हइ? ");
INSERT INTO goj_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","गर्दी मेसे एक ने वोखे उत्तर दियो, हे गुरु तरा पास अपना बेटा खे लायो जोमे असी आत्मा घुसीस जो ओखे मेखे बनय देस. ");
INSERT INTO goj_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","अरु जब कभी वा बूरी आत्मा वोखे पकडस ते जमीन मे पटकी देस अरु वोका मुडा से फेस नीकलस अरु दात कटरन लगी जास अरु आंग कडक करण लगी जास मेने तुम्हारा सेवक खे नीकालन खे बोल्यो पन वे वोखे नी नीकाली सक्या. ");
INSERT INTO goj_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","वोने उत्तर देते हुयो बोल्यो, हे अविश्वासी दुन्याहोन मी कब तक तुमारा साथ हइ? मी कब तक तुम्हारी झेल्यु? वोखे मरा पास ला. ");
INSERT INTO goj_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","वोने पोर्‍या खे वोका पास लायो. अरु जब ओने देख्यो ते तुरुत वा आत्मा ने वोखे घुमय फिरय अरु वु जमीन पर गिरी खे इधर वुधर होन लग्यो. ");
INSERT INTO goj_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","अरु वोने ओका बाप से पुछ्यो, यो कब से असो हुय रोस? वोने उत्तर दियो बचपन से. ");
INSERT INTO goj_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","ओने ओखे खतम करण का लिये कभी अंगार अरु कभी पानी मे गिरायो. पर अगर तू कुछ करी सख्ये ते हमारा पर दया खैइ खे हमारो उपकार कर. ");
INSERT INTO goj_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","यीशु ने ओकासे बोल्यो? अगर तू करी सकस हइ! या बात हइ? विश्वास करण आला को सब कुछ हुइ सकस हइ. ");
INSERT INTO goj_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","पोऱ्या का बाप ने तुरुत लालाभासा करी खे बोल्यो, मी विश्वास करुस, मरो अविश्वास कमजोर हइ मरो विश्वास बडाना मे मरो हात भार लगा. ");
INSERT INTO goj_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","जब यीशु ने देख्यो दुन्या भागी खे गर्दी खुप बडते जय रिथी ते वोने बुरी आत्मा खे यो बोली खे डाट्यो, ये बाहरी गुंगी आत्मा! मी तोखे आदेस देउस हइ येका से नीकली जा अरु फिर कभी येमे घुसनु नी. ");
INSERT INTO goj_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","अरु वा चिल्लय खे अरु घुमय फिरय खे वोका आंग से नीकली गय. अरु वु पोर्‍यो मरीगो जसो हुय गयो अरु भोत झण ने बोल्यो, वु तो मरी गो. ");
INSERT INTO goj_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","पन यीशु ने वोको हात पकडी खे उठायो अरु वू उठि खे खडो हुय गयो. ");
INSERT INTO goj_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","जब वू घर मे आयो, ते वोका सेवक ने एकला मे वोखे पुछन लग्यो “हम वोखे नीकाली सक्या? ");
INSERT INTO goj_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","“वोने वुनखे बोल्यो, या जात बिना प्रार्थना कोय अरू उपाय से निकली नि सक्ये.” ");
INSERT INTO goj_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","फिर वे व्हासे नीकल्या अरु गलील मे से हुय खे जान लगिगा. वु नी चाहतो थो की कोय खे नी मालुम होन खे होनु. ");
INSERT INTO goj_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","क्युकी वु अपना सेवक खे सिखय रो थो अरु उनखे बतय रो थो इन्सान को बेटो दुन्या होन का हात मे पकडय जाह्ये, अरु वे वोखे मारी डाल्ये. पण मारी देन का तीन दिन बाद वु फिर जिन्दो हुय जाह्ये. ");
INSERT INTO goj_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","पन वे या बात खे नी समजी सक्या अरु ओका, से पुछन खे डरता था. ");
INSERT INTO goj_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","फिर वे कफरनहूम मे पहुच्या, अरु जब वे घर मे था ते वोने उनका से पुछो रस्ता मे तुम का बात करी रा था. ");
INSERT INTO goj_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","पन वे चुप ऱ्हीया, क्युकी वे रस्ता मे वाद विवाद करी रा था कि हम मे से बडो कोन हइ. ");
INSERT INTO goj_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","बठना का बाद ओने बारा सेवक होन खे बुलायो अरु उनखे बोल्यो, “अगर कोय बडो होनो चाहस ते सबसे छोटो अरु सबको सेवक बन्नु.” ");
INSERT INTO goj_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","तब ओने एक बच्चा खे लीखे वुनका बीच मे खडो कऱ्यो, अरु वोखे खोरा मे लीखे, वोने बोल्यो, ");
INSERT INTO goj_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“जो कोय मरा नाम से कोय असो बच्चा खे अपनायो हुये ते वु मेखे अपनास, अरु जो मेखे अपनास ते, उ मेखे नी पन वोखे अपनास की जेने मेखे अपनायो हइ.” ");
INSERT INTO goj_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","यहून्ना ने ओखे बोल्यो, हे गुरु हमने एक इन्सान खे तरा नाम से बुरीआत्माहोन नीकलते देख्यो अरु वोखे रोखन का लीये बोल्यो किक्यु की उ हमारा साथ नी थो. ");
INSERT INTO goj_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","पर यीशु ने बोल्यो ओखे रोखे मत, क्युकी असो कोय नी जो मरा नाम से अच्छो काम कर्‍हे अरु वोका तुरुत बाद मे खे बुरो बोल्हे. ");
INSERT INTO goj_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","क्युकी जो हमारा विरुध्द नी पण हमारा साथ हइ. ");
INSERT INTO goj_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","जो कोय तुमखे मरा नाम से मसीह को होन कारण एक गिलास पाणी पिलाह्ये, ते मी तुम खे सच्ची बोलुस हइ की अपनो अच्छो फल कभी भी नी गमान को. ");
INSERT INTO goj_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","अरु जो कोय विश्वास करण आला खे ठोकर खलातो ते अच्छो होतो की वोने गल्ला मे चक्की को भारी पाट ओका गल्ला मे लटकायो जाय अरु उ समुदर मे डाली दियो जाये. ");
INSERT INTO goj_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","अरु तरो हात मेखे ठोकर खलाये का ते ओखे काटी खे फेकी दे. तरा लिये यो अच्छो हइ कि तु अंगहीन हुय खे जिवन मे जय खे यो प्रकार मी तरा से असी इच्छा हइ की तो खे दो हात र्‍हिखे भी तु नरक की अंगार मे डाली दिये जो कभी बुझन वाली नी हइ. ");
INSERT INTO goj_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","अगर तुमारा पाय तुमारा लिये पाप को कारण बनस हइ ते ओखे काट डाल अच्छो यो हइ तुम लंगडा हुइ खे जीवन मे प्रवेश कर्हे किन्तु दो पाय का ऱ्हेते नरक मे नी डाल्यो जाये. ");
INSERT INTO goj_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","अगर तरो पाय तोखे ठोकर खलाये ते तु ओखे काटी दे. लगडो हुइ खे जिवन मे प्रवेश करण खे लिये असो भलो हइ कि दो पाय ऱ्हेता हुया नरक मे नी डाली जाये. ");
INSERT INTO goj_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","अरु अगर तरी आख तोखे ठोकर खलाये ते ओखे नीकाल डाल नी हुइ खे परमेश्वर को राज्य मे प्रवेश करणो तरा लिये येका से अच्छो हइ, कि दो आख र्‍हेता हुये तू नरक मे डाल्यो जाये. ");
INSERT INTO goj_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","अगर ओखे तरो आख तोखे पाप करण का लिये उकसायो ओका बदला मे प्रार्थना हइ ते ओखे नीकाली डाल. तरा लिये बरोबर नी हइ कि एक आख रखनो अरु नरक मे फेकन का बदला सिरीप एक आख से परमेश्वर का राज मे जानु , ");
INSERT INTO goj_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","जहा का किडो कभी नी मरे अरु जहा कि आंगार कभी बुझे नी. ");
INSERT INTO goj_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","हर एक झन खे अंगार से अच्छो कऱ्यो जास. जसो बलिदान नमक से अच्छो कऱ्यो जास हइ ");
INSERT INTO goj_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","नमक अच्छो हइ पन नमक को सवाद का देख्यो हइ ते वोखे फिर से कसो खारो कर्हे? अपना मे मीत्रता को नमक रख अरु आपस मे मेल मीलाप कर्हे अरु एक दुसरा से शांती से ऱ्हे. ");
INSERT INTO goj_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","फिर उ व्हा से उठीखे यहूदीया प्रदेस का पार अरु यरदन नदी का पार आयो, अरु गर्दी ओका पास फिर से जमा हुइ गइ,अरु उ अपना रीति का जसो उनखे सिखान लग्यो. ");
INSERT INTO goj_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","तब फरीसीहोन ने ओका पास अय खे ओकी परीक्षा करण खे ओकासे पूछ्यो, “यो अच्छो नी हइ, कि इन्सान अपनी लुगइ खे छोडी देन कि आज्ञा देस हइ?” ");
INSERT INTO goj_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","यीशु ने उनखे जवाब दियो कि मूसा ने तुमखे, आज्ञा दी हइ. ");
INSERT INTO goj_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","मूसा ने अनुमति दी हइ कि, “छोड चिठ्ठी लिखी खे देनो अरु छोडन की आज्ञा दि.” ");
INSERT INTO goj_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","यीशु ने उनका से बोल्यो, “तुम्हारा मन कि कठुरता का कारण आज्ञा लिखी. ");
INSERT INTO goj_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","पर शास्त्र मे लिख्यो हइ सुष्टि की सुर्वात से परमेश्वर ने नर अरु नारी करीखे बनायो हइ. ");
INSERT INTO goj_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","येका लिये इन्सान अपना माय बाप से अलग हुइ खे अपनी लुगइ का साथ र्‍हिये. ");
INSERT INTO goj_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","अरु वे दो झन एक आंग हुये अरु वे दो नी पर एक आंग हइ. ");
INSERT INTO goj_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","येका लिये परमेश्वर ने जोड्योस ओखे कोय इन्सानहोन अलग नी कर्‍हे.” ");
INSERT INTO goj_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","वे जब घर गया ते सेवकहोन ने येका बारे मे यीशु से पूछ्यो. ");
INSERT INTO goj_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","ओने उनसे बोल्यो, “जो कोय अपनी लुगइ खे छोडी खे दुसरी से भ्याव कऱ्हे ते, उ अपनी पयली लुगय का खीलाप मे बुरो करस हइ. ");
INSERT INTO goj_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","अरु बय भी जो अपनो अदमी खे छोडी खे दुसरा से भ्याव कर्हे ते वा व्यभिचार करस हइ.” ");
INSERT INTO goj_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","तब दुन्या होन बच्चा खे यीशु का पास लान लगीगा कि उ वुनखे हात लगाये, पन सेवक होन ने उनखे धमकयो. ");
INSERT INTO goj_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","यीशु ने जब यो देख्यो ते घुस्सा हुय खे वोने बोल्यो, “बच्चा होन खे मरा पास आन दे, उन खे मना मत करणु क्युकी परमेश्वर को राज्य इन कोय हइ. ");
INSERT INTO goj_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","मी तुम से सच्ची बोलुस हइ जो कोय परमेश्वर का राज खे बच्चा का जसो अपना यो नी कर्‍हे, उ उन मे कभी नी अन्दर करण को.” ");
INSERT INTO goj_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","जब ओने खोरा मे लियो अरु उन पर हात रखी खे आशीर्वाद दियो. ");
INSERT INTO goj_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","जब यीशु व्हा से नीकली खे रस्ता मे जय रोथो, ते एक इन्सान ओका पास दौडते आयो, अरु ओका आगे टोगर्‍या पर हुय खे ओकासे पूछ्यो, “हे अच्छो गुरु, अनन्त जिवन मीलन का लिये मी का करु?” ");
INSERT INTO goj_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","यीशु ने उनका से बोल्योस हइ? परमेश्वर खे छोडी खे कोय. भी अच्छो नी हइ. ");
INSERT INTO goj_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","तु आज्ञा खे तो जानस हइ मारनो नी करणु, व्यभिचार नी करणु, चोरी नी करणु, झुठी गवाही नी देनू, छल नी करणु, अपना बाप अरु अपनी माय को आदर करणु. ");
INSERT INTO goj_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","वोने वोखे बोल्यो, “हे गुरु, मी बचपन से या सब बात को पालन करते आयोस.” ");
INSERT INTO goj_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","वो खे देखी खे यीशु खे प्रेम आयो अरु ओने बोल्यो, “तुम मे अभी भी एक बात की कमी हइ. जा, जो कुछ तरो हइ बेची खे गरीब मे बाटि दे अरु तोखे स्वर्ग मे धन मील्हे, अरु अयखे मरा पिछे चल.” ");
INSERT INTO goj_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","उ इन्सान या बात सुनी खे ओका मुडा पर उदास हुय गयो, अरु उ दुखी हुइ खे चले गयो, क्युकी उ भोत लखपती थो. ");
INSERT INTO goj_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","यीशु ने चारी तरफ देखी खे अपना सेवक खे बोल्यो, “लकपती होन खे परमेश्वर का राज मे जानो कत्तो कठीन हइ!” ");
INSERT INTO goj_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","वे सेवक ओकी बात से अचम हुया. पर यीशु ने उन खे फिर बोल्यो, “हे बेटा ,परमेश्वर का राज मे जानो कसो कठीन हइ. ");
INSERT INTO goj_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","परमेश्वर का राज मे लखपती इन्सान को जाना करण की अपेक्षा उट खे सूइ का छेद से नीकलनो येत्तो सोपो हइ.” ");
INSERT INTO goj_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","सेवक होन भोत हि चकित हुइखे आपस मे बोलन लग्या, “ते फिर को को उध्दारहुयी सकस हइ?” ");
INSERT INTO goj_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","यीशु ने उनका तरप देखी खे बोल्यो, “इन्सान का लिये असम्भव हइ, पर परमेश्वर का लिये सब कुछ सम्भव हइ.” ");
INSERT INTO goj_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","पतरस ओखे बोलन लग्यो, देख, हम सब कुछ छोडी खे तरा पीछे अय गा हइ. ");
INSERT INTO goj_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","यीशु ने बोल्‍यो, “ मी तुम से सच्ची सच्ची बोलुस, असो कोय नी जेने सुसमाचार का लिये घर या भैइ या बय माय अरु बाप या बालबच्चा खे छोडी दियो हइ. ");
INSERT INTO goj_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","अरु वू जगत का टेम मे घर, अरु भैइ, अरु बय, अरु माय, अरु बच्चा, अरु खेत होन खे , पर साथ साथ अरु आन आला जगत मे अनन्त जिवन. ");
INSERT INTO goj_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","पन भोत से जादा हइ, अन्नत हुये अरु जो अन्नत हइ वे पैयले हुये.” ");
INSERT INTO goj_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","वे यरुशलेम जाता हुया रस्ता मे था. अरु यीशु उनका आगे आगे चली र्‍हो थो. वे घबर्‍हाया हुया था, अरु जो इन्सान ओका पिछे पिछे आया था वे डरी गा. वे फिर बारा होन खे अलग लीग्यो अरु जो कुछ वोका साथ घडन आलो थो, वुनखे बतान लग्यो ");
INSERT INTO goj_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“देख हम यरुशलेम मे जइ रास, अरु इन्सान को बेटो महायाजक बडो याजक अरु शास्त्रिहोन का हात मे पकडय जाह्ये. अरु वे वोखे जान से मारन कि सजा दिहे, गैरयहूदीहोन का हात मे करी दिहे. ");
INSERT INTO goj_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","अरु वे वोकी मजा उडयखे अरु वोका पर थुक्हे, अरु वोका पर कोडा मार्‍हे अरु मारी डाल्हे अरु तीन दिन बाद फिर जिन्दो हूये.” ");
INSERT INTO goj_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","फिर जब्दी को दुसरो बेटो, याकूब अरु यहून्ना यीशु का पास आया अरु बोलन लगीगा, “हे गुरु, हम तरा से मागे, उ तू हमारा लीये कर्‍हे.” ");
INSERT INTO goj_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","“अरु यीशु ने बोल्यो?” तुम का चाहस की मी तुमारा लीये करु. ");
INSERT INTO goj_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","वुनने वोखे बोल्यो, “तरी महिमा मे हम मे से एक तरो जवना तरप अरु दुसरो डाखोऱ्या मे बठ्ये.” ");
INSERT INTO goj_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","यीशु ने उनसे बोल्यो, तुम नी जाने की का मागी रास. जो गिल्लास मे पीना का बाद का तुम पी सक्ये अरु जो बपतिस्मा मी लेना पर हइ, तुम लि सक्ये हइ? ");
INSERT INTO goj_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","अरु उनने ओखे बोल्यो, “हम करी सकस.” अरु यीशु ने वुन खे बोल्यो, उ गिल्लास मे पिना पर तुम पिहे? अरु जो बपतिस्मा मेने लेना पर का तुम लिहे. ");
INSERT INTO goj_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","पर मरो अधिकार नी कि मी को खे चुनू कि कोन खा बठ्ये फक्त परमेश्वर ने ओका लिये जगा तैयार कर्ये कि कोन मरा जवना अरु डाखोर्या तरप बठ्यै. ");
INSERT INTO goj_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","यो सुनीखे दस सेवक होन याकूब अरु यहून्ना पर जिकरय गया. ");
INSERT INTO goj_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","अन्नत मे यीशु ने ओखे पास बुलय खे वुनखे बोल्यो, तुम समजस नी की जो गैरयहूदिहोन को अधिकार जानी लेस अरु जगत पर राज करण आलो. अरु उनसे जो बडा हइ उन पर अधिकार जतास. ");
INSERT INTO goj_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","पन तुमारी बात नीराली हइ, तुम्हारा मे जो कोय खे बडो होनो हुये वुनखे तरो सेवक होन खे होनु. ");
INSERT INTO goj_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","अरु तुम मे सबसे बडो होन खे होनु, ओखे तो सबको सेवक बन्नु पडे. ");
INSERT INTO goj_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","क्युकी मी इन्सान को बेटो आयो, अरु इन्सान मरी वा करणु करीखे मी जगत मे नी आयो, ते मरासे दुन्या होन की सेवा होन खे होनु खुप पाप की सजा, लीये मरो जान देन आयो. ");
INSERT INTO goj_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","फिर वे यरीहो मे पहुच्या.अरु जब व्हापर अपना सेवक अरु एक बडी गर्दी का सात यरीहो से बाहेर जइ रा थो ते बरतिमाइ नाम को एक अंधो भिकारी, जो तिमाइ को बेटो थो, सडक का किनारा मे बठ्यो थो. ");
INSERT INTO goj_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","जब उनने सुन्यो की यो नासरी को ऱ्हेन आलो यीशु आयो पुकारी खे बोलन लग्यो, “हे यीशु, दाउद का बेटा मरा पर दया कर!” ");
INSERT INTO goj_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","भोत झण ने ओखे धमकय खे बोल्‍यो कि तु चुप र्‍हे पर वु अरु जादा चील्लान लग्यो, यीशु “दाउद का बेटा मरा पर दया कर” ");
INSERT INTO goj_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","तब यीशु ने रुखी खे बोल्‍यो, “ओखे बुला.” अरु इन्सानहोन ने उ अंधा खे यो बोलीखे बुलायो, “हिम्मत रख, उट! उ तोखे बुलास हइ.” ");
INSERT INTO goj_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","उ अपना कपडा फेकी खे उछल पड्यो अरु यीशु का पास आयो. ");
INSERT INTO goj_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","यीशु ने जवाब देते हुये बोल्यो, “तु, चाहस की मी तरा लीये करु?” अरु अंधा इन्सान ने ओकासे बोल्यो, “हे गुरु यो की मी देखन लग्यु!” ");
INSERT INTO goj_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","यीशु ने ओकासे बोल्यो, “चली जा, तरा विश्वास ने तोखे अच्छो करी दियो.” उ तुरुत देखन लग्यो अरु रस्ता मे ओका पीछे चली गयो. ");
INSERT INTO goj_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","जब वे यरुशलेम का नजीक, जैतून पहाड का किनारा बैतफगे अरु बैतनीय्याह खे पहुच्या ते वोने अपना सेवक मे से दो खे भेजो, ");
INSERT INTO goj_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","अरु वुनखे बोल्यो अपना सामने का गाव मे जा अरु जाते ही तुमखे एक गधी को बच्चा बाध्यो हूयो मील्हे, जेका पर अभी तक कोय बठ्या नी. वोखे खोली खे ली खे आ. ");
INSERT INTO goj_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","अरु तुमखे कोय पुछ्ये, असो काय बर करस? ते तुमने बोलनू, प्रभु खे का जरुरत हइ, अरु उ तुरुत वोखे वाहा से झल्दी ह्या भेजी दिहे. ");
INSERT INTO goj_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","वे गया अरु वुनने बाहेर का गल्ली मे दरवाजा का पास एक गधी का बच्चा खे बाध्यो हुयो पायो, अरु वे वोखे खोलन लग्या. ");
INSERT INTO goj_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","व्हा खडा कुछ दुन्या ने वुनखे बोल्यो, “ये का करी रास गधी का बच्चा खे क्यु खोली रास?” ");
INSERT INTO goj_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","अरु यीशु ने जसो बतायो थो वुनने वोसोय बोली दियो. तब वुनने वोखे लिजान दियो. ");
INSERT INTO goj_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","उ बच्चा खे यीशु का पास लाए अरु उपर अपना कपडा डाली दिया. ");
INSERT INTO goj_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","अरु भोत झन ने अपना कपडा रस्ता पर बिछय दिया, अरु दुसरा दुन्या ने खेत मे डग्यान काटी खे फेकी दी. ");
INSERT INTO goj_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","वे जो ओका आगे आगे जातो अरु पिछे पिछे चलते आता था, फुकारीखे बोली रा था होशन्ना! आशिर्वाद हइ वे जो परमेश्वर का नाम से आस! ");
INSERT INTO goj_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","हमारो बाप दाउद को आन आलो राज आशिर्वाद हइ! बद्दल मे हुये होशन्ना! ");
INSERT INTO goj_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","वु यरुशलेम मे प्रवेश करिखे आराधनालय मे आयो. अरु चारी तरप देखी खे बारा होन का सात बैतनीय्याह खे चली दिया, क्युकी सज्जा हुय गि थी. ");
INSERT INTO goj_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","अरु दुसरा दिन जब वे बैतनीय्याह से नीकल्या ते वोखे भुख लगी. ");
INSERT INTO goj_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","अरु पत्ता से भऱ्यो एक अंजीर को झाड खे दुर से देखी खे, वु वोका पास गयो कि अचानक कुछ मीली जाह्ये. पन व्हा पहुची खे पत्ता का शिवाय कुछ भी नी था. ");
INSERT INTO goj_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","तब वोने झाड खे बोल्यो, “अब से कोय तरो फल कभी खान का नी.” अरु वोको सेवक सूनी रो थो. ");
INSERT INTO goj_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","फिर वे यरुशलेम मे आया अरु वे आराधनालय मे जय खे लेन देन करण आला खे नीकालन लग्या नीष्कलन अरु सोन्नो होन की मेज अरु कबूतर बेचन आला की चौकी उलटय दी. ");
INSERT INTO goj_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","अरु वोने कोय खे भी आराधनालय मे हुय खे बराबर लिजान खे नी बोल्यो थो. ");
INSERT INTO goj_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","अरु वू वुन खे उपदेस देन लग्यो “यो लिख्यो हइ, मरो घर सब राष्ट्रका लीये प्रार्थना को घर बोल्यो जाह्ये? पन तुमने वोखे डाकु जसो बनय खे रख्योस.” ");
INSERT INTO goj_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","अरु महायाजक अरु शास्त्रिहोन ने जब यो सुन्यो ते यीशु खे मारी डालन को बहानो ढुंडन लग्या, क्युकी वे ओकासे डरता था एका लीये सब वो का सीकानासे चकित था. ");
INSERT INTO goj_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","अरु संजा होते ये गाव का बाहेर जाता था. ");
INSERT INTO goj_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","फिर फजर की टेम मे जब वे उदर से जइ रा था, ते उनने वु अंजीर को झाड खे जडी तक सुकते हुयो देख्यो. ");
INSERT INTO goj_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","पतरस ने ध्यान लगय खे बोल्यो गुरु देख, यो अंजीर को झाड जेखे तोने सराप दियो थो सुखी गयो. ");
INSERT INTO goj_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","यीशु ने वोखे बोल्यो, “परमेश्वर पर विश्वास रख. ");
INSERT INTO goj_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","मी तुम से सच्ची बोलुस, जो कोय या पहाड से बोल्हे, उखडी जा अरु समुदर मे जयखे गिरी जा,अरु अपना मन मे दुर नी रखनु पन जो कुछ वुनका से बोल्यो, विश्वास कर की हुय जाह्ये ते वोका लीये हुय जाह्ये.” ");
INSERT INTO goj_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","येका लीये मी तुमखे बोलुस, कि जो कुछ तुम प्रार्थना मे मागस विश्वास कर की वोखे पय लियो, अरु वु तुमखे मीली जाह्ये. ");
INSERT INTO goj_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","अरु जब तुम खडा हुयखे प्रार्थना कर्‍हे ते तुमारा मन मे कोय का भी लिये कुछ बुरो हुये ते वोखे माफ करी देनु, जेमे तुमारो बाप जो स्वर्ग मे हइ तुमारो भी बुरो माफ कर्‍हे. ");
INSERT INTO goj_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","पर अगर तुम माफ नी करण का ते तुमारो बाप भी जो स्वर्ग मे हइ तुमारो गुन्हा खे माफ नी करण को. ");
INSERT INTO goj_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","वे फिर यरुशलेम मे आया. अरु जब वु मन्‍दिर मे घुमी रो थो, ते महायाजक बडो पंडीत ने शास्त्री खे अरु बापदादा वोका पास आया, ");
INSERT INTO goj_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","वे वोखे पुछन लगीगा, “तु यो काम कोन ता अधिकार से करीरोस अरु यो काम का लीये तोखे कोने दियो?” ");
INSERT INTO goj_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","अरु यीशु ने ओखे बोल्यो, “मी तुमखे एक सवाल पुछस. तुम मेखे जवाब दे, फिर मी तुमखे बतायु की यो काम कोन ता अधिकार से करी रोस. ");
INSERT INTO goj_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","यहून्ना खे बपतिस्मा देन को अधिकार परमेश्वर का स्वर्ग तरप से थो की इन्सान का तरप से थो? मेखे जवाब दे.” ");
INSERT INTO goj_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","वे यो बोली खे आपस मे वाद विवाद करण लग्या, अगर हम बोल्हे, स्वर्ग का तरप से, ते वू बोल्हे, तुमने वोको विश्वास क्युव नी कऱ्यो? ");
INSERT INTO goj_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","फिर का हम यो बोला, इन्सान का तरप से वे दुन्या होन से डरता था क्युकी वे सब यो मानता था की यहून्ना सच्ची मे भविष्यव्दक्ता थो. ");
INSERT INTO goj_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","यीशु खे जवाब देतो हुये बोल्यो, “हम खे नी मालुम.” अरु यीशु ने उनखे बोल्यो, “मी भी तुमखे नी बतान को की यो काम कोनता अधिकार से करुस.” ");
INSERT INTO goj_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","फिर व्हा वोने दृष्‍टान्‍त देख्यो बोलन लग्यो एक इन्सान ने अंगुर को खेत लगयो, अरु महिमा चडय खे वोखे घेऱ्‍यो, अरु खेत का बारे मे दृष्‍टान्‍त देख्यो यो अरु अंगूर लगय, वोका आजू बाजू दिवाल बांधी खे अंगूर मडन खे वोको रस नीकाल का लीये एक कुवो खोद्यो अरु एक मचाग भी बनय, अरु कास्ताकार होन खे तिजय से दिखे दुसरा देस मे चली दियो. ");
INSERT INTO goj_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","हगाम की टेम मे वोने एक खास सेवक खे किसानहोन का पास भेजो अरु अंगूर का खेत को अपनो हिस्सो ली खे आ. ");
INSERT INTO goj_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","पन वुनने वोखे पकडि खे पिट्यो अरु वोखे खाली हात भेजी दी यो. ");
INSERT INTO goj_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","वोने उनका पास फिर एक सेवक खे भेज्यो, अरु वुनने वोको माथो फोडि दियो अरु वोको अपमान कऱ्यो. ");
INSERT INTO goj_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","फिर वोने अरु एक झन खे भेज्यो, वुनने वोखे मारी डालस. अरु असो करी खे असो घनय खे भी, कोय खे पिट्यो अरु कोय खे मारी डाल्यो. ");
INSERT INTO goj_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","आब भेजन खे ओका पास एक अरु ऱ्हीगो थो मनजो ओको लाडेलो बेटो थो. यो सोची खे ओने अंत मे ओखे भी भेज्यो की, वे मरा बेटा की इज्जत कऱ्हे. ");
INSERT INTO goj_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","पन कास्ताकार होन ने आपस मे बोल्यो, यो तो वारीस आयो. हम अयखे मारी देस ते यो खेत को मालक अपुन ही हुया. ");
INSERT INTO goj_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","अरु उनने ओखे पकडि खे मारी दियो अरु वोका आंग खे अंगूर का खेत का बाहेर फेकी दियो. ");
INSERT INTO goj_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","यो अंगूर का खेत को स्वामी का कर्‍हे? वु अय खे कास्ताकार होन को नास कऱ्हे अरु अंगूर को खेत दुसरा खे दिहे. ");
INSERT INTO goj_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","का तुमने पवित्रशास्त्र को यो वचन नी पड्यो. जो फतर खे राज मीस्त्री ने बुरो बनय दियो थो, उ कोनाको बडो पत्थर बन्यो. ");
INSERT INTO goj_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","यो प्रभु का तरप से हुयो अरु हमारी नजर मे अद्भुत हइ. ");
INSERT INTO goj_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","वे वोखे पकडनो चाहता था फिर भी दुन्या से डरता था, क्युकी वे समजी गा की वोने यो दृष्‍टान्‍त हमारा खीलाफ मे बोल्योस. एकालिये वे ओखे छोडी खे चली दिया. देख रेख करणआली मचान ");
INSERT INTO goj_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","वुनने कुछ फरीसी या अरु हेरोदिया खे ओका पास भेज्यो की ओकी बात मे ओखे य फसानो. ");
INSERT INTO goj_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","अरु वुनने अय खे बोल्यो, हे गुरु, हम जानस की तू सच्ची आयो, अरु तू कोय का प्रभाव मे नी आयो. तु तो कोय का तरप से भाग नीले, पन परमेश्वर की रस्ता पर सच्ची से सिकास. कैसर को करजो चुकानो अच्छो नी हइ की नी? ");
INSERT INTO goj_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","हम दे या नी दे ओने उनको कपट जानीखे उनसे बोल्यो मेखे क्यु परखस हइ एक सिक्का मरा पास लानु कि मेखे देखनु. ");
INSERT INTO goj_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","वे सिक्का लाया, अरु वुनखे बोल्यो, अरु यो सिक्का पर को को चित्र हइ? उनने बोल्यो कैसर को. ");
INSERT INTO goj_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","अरु यीशु उनखे बोल्यो, “जो कैसर को हइ वू कैसर खे दे, अरु जो परमेश्वर को आयो वू परमेश्वर खे दे.” अरु वे अचम. ");
INSERT INTO goj_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","फिर सदूकिहोन ने भी जो बोलस हइ कि मर्या हुया को जिन्दो हइ ही नी का ओका पास अयखे ओकासे पुच्छो, ");
INSERT INTO goj_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“हे गुरु, हमारा लीये मूसा ने एक व्यवस्था लिखस हइ की कोय को भैइ बीना बाल बच्चा को मरी जाह्ये, अरु अपना पीछे बायको खे छोडी जाह्ये ते ओको भैइ ओकी बायको का साथ भ्याव करी लीहे अरु अपनो भैइ का लीये बच्चा परदा नी कर्‍हे. ");
INSERT INTO goj_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","सात भैइ था. परइलो भैइ भ्याव करीखे बीना बच्चा को मरी गो. ");
INSERT INTO goj_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","तब दुसरो भैइ ने वा बायको से भ्याव कऱ्यो अरु बिना बच्चा को मरी गयो, अरु तिसरा ने भी असो कऱ्यो. ");
INSERT INTO goj_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","अरु सात झन खे कोय बच्चा नी हुया. अरु अन्नत मे वा बायको भी मरी गइ. ");
INSERT INTO goj_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","वा जिन्दी हुइ जाये ते वा को कि बायको हुये? क्युकी वा सात झन की बायको बनी गी थी.” ");
INSERT INTO goj_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","यीशु ने वुनखे बोल्यो, “का तुम यो कारन भुल मे नी पड्या की तुम नीते पवित्रशास्त्र खे समजस हइ अरु नाही परमेश्वर की सामर्थ्य खे? ");
INSERT INTO goj_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","क्युकी जब दुन्या होन मरी खे जिन्दो होस अरु वोने भ्याव करस अरु नी भ्याव मे से दियो जास क्युकी वे स्वर्गदूत का जसा हइ. ");
INSERT INTO goj_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","अरु आप डबल जन्म हुये की नी ये का बारे मे बोल्यो, ते मूसा की किताब मे जलती झाडि की काहानी का बारे मे नी पडो? की परमेश्वर मूसाखे बोल्यो, ‘मी अब्राहम को परमेश्वर आय इसहाक अरु याकूब को परमेश्वर आय.’ ");
INSERT INTO goj_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","वु मुडदा खे पन जिन्दो को परमेश्वर आयो. तुम बडि भुल मे हइ.” ");
INSERT INTO goj_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","शास्त्रिहोन मे से एक ने अय खे ओका से वाद विवाद करते सुन्यो, अरु यो जानीखे भी ओका से खे त्तो अछा से उत्तर दियो, ओका से पुछ्यो, सबसे बडि आज्ञा कोनसी आय? ");
INSERT INTO goj_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","यीशु ने उत्तर दियो, बडि बात या आयो की इस्राएल सुन हमारो परमेश्वर एकी आयो, ");
INSERT INTO goj_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","तु अपनो प्रभु परमेश्वर से अपनी सब मन,अरु अपनो पुरो जानसे अरु अपनी पुरी दिमाक से अरु अपनी सब सकती से प्रेम करणू. ");
INSERT INTO goj_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","अरु दुसरी जरुरती बात या हइ की,तु अपना पडोसी से बराबर प्रेम करणू. येका दो कि बात से बडिखे अरु आज्ञा नी. ");
INSERT INTO goj_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","शास्त्री ने ओखे बोल्यो, “हे धर्म गुरु बिलकुल ठिक हइ, तोने सच्ची बोल्यो की वु एक्की परमेश्वर आयो. अरु वोका सिवाय दुसरो परमेश्वर कोयनी हइ” ");
INSERT INTO goj_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","अरु अपनो सब प्रेम, अरु अपनो पुरो जानसे अरु अपनी पुरी दिमाक से अरु अपनी सब सकती से प्रेम करणू,अरु अपना पडोसी से बराबर प्रेम करणू यो होमबलि से अरु बलिदान कि तुलना मे या दो बात को पालन करणू जरुरती हइ. ");
INSERT INTO goj_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","जब यीशु ने देख्यो की उनखे समजदारी से उत्तर दियो,ते ओखे बोल्यो, तु परमेश्वर का राज से दुर नी हइ, अरु येका बाद कोय खे यीशु से पुछन की हिम्मंत नी हुय. ");
INSERT INTO goj_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","यीशु मन्दिर मे उपदेस दि रोथो ते ओने बोल्यो, शास्त्री कसा बोलस की मसीह दाउद को बेटो हइ? ");
INSERT INTO goj_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","क्युकी दाउद ने खुद हुय खे पवित्र आत्मा मे जयखे बोल्यो, परमेश्वर ने मरो प्रभु खे बोल्यो, मरा उजवा हात तरप बठ जब तक कि मी तरो दुसमन खे तरा पाय का नीच्चे लाह्यू. जो की किम्मत नजीकपास एक पैसा का बराबर होस. ");
INSERT INTO goj_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","यीशु मन्दिर मे उपदेस दि रोथो ते ओने बोल्यो. यीशु मन्दिर मे उपदेस प्रभु दि रोथो ते ओने बोल्यो, शास्त्री कसा बोलस की मसीह दाउद को बेटो हइ? ");
INSERT INTO goj_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","अरु उ अपना उपदेस से बोली रोथो, “शास्त्रिहोन से चेतावनी ऱ्हेनू, जो लंम्बा कपडा पेनीखे घुमनो अरु बजार मे आदर सत्कार अरु नमस्कार करनो, ");
INSERT INTO goj_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","अरु आराधनालय मे बडि जगा अरु खान का लीये टेबल मे मेन जगा पर बठनो पसंद आस. ");
INSERT INTO goj_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","वे आयो जो विधवा का घर खयलेस, अरु दिखान का लिये लंबी लंबी प्रार्थना करस हइ. इन खे बडो दण्ड मील्हे.” ");
INSERT INTO goj_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","वु आराधनालय का खजाना का समने बठी गयो अरु देखन लग्यो कि दुन्या आराधनालय कि दान कि पेटी पैसा डालता हुयो देख्यो; अरु खुब धनवान बडि बडि रक्कम डाली राथा. ");
INSERT INTO goj_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","येत्ता मे एक कंगाल विदवा ने आय खे दो तांबा का छोटा छोटा सिक्का डाल्या जो की किम्मत नजीकपास एक पैसा का बराबर होस. ");
INSERT INTO goj_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","तब यीशु ने अपना सेवक होन खे अपना पास बुलखे बोल्यो, मी तुम खे सच्ची सच्ची बोलुस “की दान की पेटी दालन आला मेसे या कंगाल विधवा ने सबसे बडिखे दाल्योस. ");
INSERT INTO goj_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","क्युकी भोत झन ने अपनी दौलत मे से जरासी दाली, पन येने अपनी गरीबी मेसे जो कुछ ओको थो अगर अपनी जीविका डाली दी.” ");
INSERT INTO goj_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","जब वु दिन यीशु मन्‍दिर का बाहेर नीकली गयो थो ते ओका सेवक मेसे एक ओखे बोल्यो खे “हे गुरु, देख कसो बडो फतर अरु कसो भव्य भवन!” ");
INSERT INTO goj_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","अरु यीशु ने उनखे बोल्यो, “तुम या बडी मन्‍दिर खे देख? एक फतर भी फतर पर छुटी जाह्ये जो लगय नी सकन.” ");
INSERT INTO goj_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","जब आराधनालय, का सामने जैतून की टेकडी पर बैठ्यो थो ते पतरस,याकूब को यहून्ना को अरु अन्द्रियास ने एकला मे ओखे पुछ्यो, ");
INSERT INTO goj_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“हम खे बता की या बात कब हुये अरु जब या सब बात पुरी होना पर येको चिन्ह को हुये?” ");
INSERT INTO goj_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","अरु यीशु उनखे बोलन लग्यो, हुशार ऱ्हे की कोय तुमखे धोको नी दे. ");
INSERT INTO goj_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","यीशु ने बोल्यो कि ओखे मरा नाम से आये, ओखे का खबर तग करी रा? ओने तो मरा साथ अच्छो कऱ्योस. ");
INSERT INTO goj_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","क्युकी कगाली तो सदा तुमारा सात ऱ्हेस, अरु जब तुम चाह्ये तब तुम ओका सात अच्छो करस ते पन मी तुमारा साथ सदा नी रर्हेन को. ");
INSERT INTO goj_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","जेतनो वा करी सकती थी ओने कर्‍यो, ओने मेखे पैयले राज्य पैयले ओने मरा आंग पर अत्रर लगय दियो. ");
INSERT INTO goj_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","मी तुमखे सच्ची बतवूस की पुरा जगत मे झा खैय सुसमाचार को प्रचार हुये खे व्हा या बय काम की चर्चा भी ओका पर गवाही हुइ. ");
INSERT INTO goj_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","अरु यहूदा इस्करियोती जो बारा मे से एक थो महायाजक, पास गयो कि सुसमाचार खे सब जात हात मे पकडय दे. ");
INSERT INTO goj_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","अरु जब उनने यो सुन्यो ते खुस हुया, अरु ओने पैसा देन को पैयले से पवित्र वचन दियो. अन्नत मे वू यो सोचन लगयो की वोखे कसो पकडय दिव. ");
INSERT INTO goj_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","अखमीर रोटी को तीवार, पहीला दिन को जब फसह को बलि दान करता था, वे दिन ओका सेवक होन ओखे बोल्यो का अपुन फसह खानो खाया करीखे हम खा जयखे तैयारी कर असी हमारी इच्छा हइ? ");
INSERT INTO goj_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","फिर मरा नाम ओने अपना सेवक मेसे दो झन भेज ते से बतायो, की नगर मे जा अरु मनजो कोय एक इन्सान पानी को मडको लीखे जाते तुमखे मील्हे,ओका पिछे जा. ");
INSERT INTO goj_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","उ अंदर जाह्ये व्हा को घर घुणित खे असो बता गुरु पुछस की मी मरा सेवक, साथ फसह खानो खान असी मरी उतरन की जगा खा हइ? ");
INSERT INTO goj_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","फिर वू सजी सजयो, अरु तैयार करी हुइ जो अपना घर कि छपर पर हुये, व्हा हमारा लिये तैयार मील्यो. ");
INSERT INTO goj_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","फिर सेवक नीकली खे नगर मे गया, तब वुनखे बतायो बराबर उनने फसह तैयारी करी. ");
INSERT INTO goj_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","फिर सज्जा होना पर वू बारा झन का सात आयो. ");
INSERT INTO goj_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","अरु वे बठी खे खानो खय राथा यीशु ने बोल्यो, मी तुमखे सच्ची बतवूस का तुमारा मेसे एक झन मेखे पकडय दिहे कावु मरा सात खान आलो आय. ");
INSERT INTO goj_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","वे उदास हुय खे एक हुय खे ओखे परमेश्वर से पुछन लग्या खे उ मी आय ");
INSERT INTO goj_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","क्युकी प्रभु झुटो भविष्यव्दक्ता अरु ओने उनखे बोल्यो का वे बारा मेसे एक आय जो मरा कटोरा मे रोटी डुब्य रोस हइ. ");
INSERT INTO goj_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","क्युकी इन्सान को बेटो का जसो ओका बारे मे लीखोस, जास पन जो इन्सान का हात से इन्सान को बेटो पकडय दियो जास, ओकी खे तनी दुर दश्या हुये वु इन्सान जन्म नी लेतो ते अच्छो होतो. ");
INSERT INTO goj_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","क्युकी झुठा मसीह अरु झुठा भविष्यव्दक्ता सेवक, साथ खानो खय राथा, ओने रोटी ली चिन्ह अरु आशिर्वाद मागी खे तोडी अरु उनखे बोल्यो, योले यो मरो आंग आयो. ");
INSERT INTO goj_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","फिर ओने प्यालो लियो अरु धन्यवाद प्रार्थना करी खे उनखे दियो.अरु वे सब झन ओमे से पियो. ");
INSERT INTO goj_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","ओने उनखे बोल्यो, “यो वचन बनन आलो मरो खुन आय यो भोत झन, लीये बोहय दियोस. ");
INSERT INTO goj_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","मे तुमखे सच्ची बोल्यो थो, अंगूर को रस वु दिन तक नी पिह्यु, जब तक परमेश्वर स्वर्ग मे राज मे नवो नी पिनको” ");
INSERT INTO goj_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","जब दुन्या अरु इन्सान का बेटा कि सामर्थ्य अरु महिमा का बाद वे जैतून की टेकडी पर चली दिया. ");
INSERT INTO goj_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","तब स्वर्ग से यीशु ने बोल्यो, अपना स्वर्गदूतहोन खे भेजो, अरु वे बद्दल का या पार से वा पार तक, चारी दिशा से ओका चुन्या हुया खे जमा कर्‍हे. ");
INSERT INTO goj_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","अंजीर को झाड से यो सिखो काहानी जब डग्यान नाजुक हुय जास, अरु पत्ता नीकलन लगस हये; ते तुम समजी लेव कि गर्मी का दिन नजीक हइ. ");
INSERT INTO goj_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","या रीति से जब तुम ओखे बोल्यो, चाह्ये सब छोडी दिहे पन मी नी छोडन को. ");
INSERT INTO goj_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","तब यीशु ने ओखे बोल्यो, मी तुमखे सच्ची बोलुस आज रात खे मुर्गा खे दो बार बांग देना से पैयले तु मेखे खुद इनकार कर्‍हे. ");
INSERT INTO goj_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","बद्दल अरु पृथ्वी खतम हुइ जास पन मरो वचन कभी नी टलस. ");
INSERT INTO goj_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","उ दिन या उ टेम का बारे मे कोय खे कुछ पतो नी, नी स्वर्ग मे दुतहोन खे अरु नी अभी इन्सान का बेटा खे फक्त परम बाप परश्वमेर जानस हइ. ");
INSERT INTO goj_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","सावधान! जागतो ऱ्हे क्युकी तुम नी जानस कि उ टेम कब अय जास. ");
INSERT INTO goj_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","अरु ओने उनखे बोल्यो, “मरो मन खुप सेवक खे अधिकार दे; अरु हर एक खे हइ ह्या तक की मी मरना पर हइ. अरु घर अरु जागते र्‍हे.” ");
INSERT INTO goj_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","तुम नी समजो कि घर को स्वामी फिर वू थोडो आगे गयो कि अरु जमीन पर गिरीखे प्रार्थना करण लगीगो की तकलीप को टेम मरा परसे टली जाह्ये. ");
INSERT INTO goj_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","अरु बोलन लगीगो, “हे पिता हे, बाप तरा से तरा सब कुछ होस हइ.यो कटोरा खे मरा पास से दुर करी ले फिर भी जसो मी चाउस हइ वोसो नी, पर जो तू चाहस हइ वोसो हुये.” ");
INSERT INTO goj_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","अरु ओने अयखे उनखे सोते मील्या अरु पतरस खे बोल्यो, हे शमौन, तू सोय रो हइ? कातू एक टेम भी नी जागी सक्यो? ");
INSERT INTO goj_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","दो दिन का बाद फसह अरु अखमीर रोटी यो तिवार होनआलो थो अरु महायाजक अरु शास्त्री या बात की ढुढना मे था कि ओखे कसा छल से पकडिखे मारी डाल. ");
INSERT INTO goj_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","पर बोलता था, की तिवार का दिन नी, खय असो नी हो कि दुन्या मे दंगो हुय जाह्ये. ");
INSERT INTO goj_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","जब वू बैतनीय्याको शमौन नाम को कोढी का घर मे खानो खान खे बठ्यो थो, ते व्हा एक बय अय अच्छो जटामासी को किमती अत्रर को तेल से भरी वाली कुप्पी लिखे अय; ओने फोडि खे ओका माथा पर अत्रर डाली दियो. ");
INSERT INTO goj_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","पर कुछ इन्सान अपना मन मे कुरकुरकरी खे बोलन लग्या, “यो अत्रर खे सत्यानाश क्यु कर्यो गयो. ");
INSERT INTO goj_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","क्युकी यो अत्रर आलो तेल तिन सौ सिक्का से भी जादा मे बेचीखे वे गरीब मे बाट्यो जयस सकतो थो.” अरु वेवा बय खे डाटन लग्या. ");
INSERT INTO goj_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","यीशु ने बोल्यो, ओखे छोडि दे, ओखे कायबर तंग करी रा? ओने तो मरा साथ अच्छो कऱ्योस. ");
INSERT INTO goj_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","क्युकी कंगाली तो हमेशा तुमारा सात ऱ्हेस, अरु जब तुम चाह्ये तब तुम ओका सात अच्छो करस ते पन मी तुमारा साथ हमेशा नी रर्हेन को. ");
INSERT INTO goj_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","जेतनो वा करी सकती थी ओने कर्‍यो, ओने मेखे गाडन का पैयले ओने मरा आंग पर अत्रर लगय दियो. ");
INSERT INTO goj_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","मी तुमखे सच्ची बतवूस की पुरा जगत मे झा खैय सुसमाचार को प्रचार हुये, व्हा या बय का काम की चर्चा भी ओका याद मे करी जाये. ");
INSERT INTO goj_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","अरु यहूदा इस्करियोती जो बारा मे से एक थो महायाजक का पास गयो कि ओखे उनका हात मे पकडय दे. ");
INSERT INTO goj_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","अरु जब उनने यो सुन्यो ते खुस हुया, अरु ओने पैसा देन को वचन दियो. अन्नत मे वू यो सोचन लगयो की वोखे कसो पकडय दिव. ");
INSERT INTO goj_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","अखमीर रोटी को तीवार का पहिला दिन, जब फसह का बलि दान करता था, वे दिन ओका सेवक होन ओखे बोल्यो, “तु का चाहस हइ की हम जइ के तरा लिये फसह खान की तैयारी कर्ये?” ");
INSERT INTO goj_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","फिर ओने अपना सेवक मेसे दो झन भेज ते से बतायो, की नगर मे जा अरु मनजो कोय एक इन्सान पानी को मडको लीखे जाते तुमखे मील्हे,ओका पिछे जा. ");
INSERT INTO goj_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","उ अंदर जाह्ये व्हा को घर मालक खे असो बता गुरु पुछस की मी मरा सेवक का साथ फसह खानो खान असी मरी उतरन की जगा खा हइ? ");
INSERT INTO goj_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","फिर वू सजी सजयो , अरु तैयार करी हुइ बडो कमरो दिखइ दियो, व्हा हमारा लिये तैयार मील्यो. ");
INSERT INTO goj_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","फिर सेवक नीकली खे नगर मे गया, तब वुनखे बतायो बराबर उनने फसह तैयारी करी. ");
INSERT INTO goj_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","फिर संज्जा होना पर वू बारा झन का सात आयो; ");
INSERT INTO goj_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","अरु वे बठी खे खानो खय राथा यीशु ने बोल्यो, मी तुमखे सच्ची बोलुस, तुमारा मेसे एक झन मेखे पकडय दिहे, वु मरा सात खान आलो आयो. ");
INSERT INTO goj_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","वे उदास हुय खे एक हुय खे ओखे पुछन लग्या, का उ मी आय ");
INSERT INTO goj_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","अरु ओने उनखे बोल्यो, “वे बारा मेसे एक आय जो मरा कटोरा मे रोटी डुब्य रोस हइ. ");
INSERT INTO goj_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","क्युकी इन्सान को बेटो, जसो ओका बारे मे लीखोस, जास पन जो इन्सान का हात से इन्सान को बेटो पकडय दियो जास, ओकी खे तनी दुर दश्या हुये वु इन्सान जन्म नी लेतो ते अच्छो होतो.” ");
INSERT INTO goj_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","सेवक का साथ खानो खय राथा, ओने रोटी ली अरु आशिर्वाद मागी खे. “तोडि अरु उनखे,” बोल्यो “योले यो मरो आंग आयो.” ");
INSERT INTO goj_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","फिर ओने प्यालो लियो अरु धन्यवाद प्रार्थना करी खे उनखे दियो;अरु वे सब झन ओमे से पियो. ");
INSERT INTO goj_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","ओने उनखे बोल्यो, “यो वचन बनान आलो मरो खुन आयो यो भोत झन का लीये बोहय दियोस. ");
INSERT INTO goj_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","मे तुमखे सच्ची बोल्यो थो, अंगूर को रस वु दिन तक नी पिह्यु, जब तक परमेश्वर का राज मे नवो नी पिनको” ");
INSERT INTO goj_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","भजन गान का बाद वे जैतून की टेकडि पर चली दियो. ");
INSERT INTO goj_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","तब यीशु ने बोल्यो, “तुम सब ठोकर खाहे, क्युकी यो लीख्योस, मी चरवाहो ठाट्या खे मार्‍हु, अरु मेढा इधर उदर हुय जाह्ये. ");
INSERT INTO goj_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","पन अपना जिन्दो होन का बाद मी तुम से पैयले गलील मे जाह्ये.” ");
INSERT INTO goj_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","पतरस ने ओखे बोल्यो, चाह्ये सब छोडि दिहे पन मी नी छोडन को. ");
INSERT INTO goj_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","तब यीशु ने ओखे बोल्यो, मी तुमखे सच्ची बोलुस आज रात खे मुर्गा खे दो बार बांग देना से पैयले तु मेखे खुद इनकार कर्‍हे. ");
INSERT INTO goj_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","पन पतरस ने मूर्खता से यो बोलते ऱ्हीयो,क्युकी मेखे तरा सात मरनु पडे ते मी तोखे इनकार नी करन को अरु वे सब यो बोली राथा. ");
INSERT INTO goj_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","अरु वे गतसमनी नाम को जगा मे आया; अरु ओने अपना सेवक खे बोल्यो, “तुम ह्या बठ्या र्‍हे, जब तक मी प्रार्थना कह्यू.” ");
INSERT INTO goj_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","अरु ओने अपना साथ पतरस,याकूब अरु यहून्ना खे सात मे लीयो अरु खुप झन व्याकुल होन लग्या. ");
INSERT INTO goj_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","अरु ओने उनखे बोल्यो, “मरो मन खुप उदास हइ ह्या तक की मी मरना पर हइ.अरु रुख अरु जागते र्‍हे.” ");
INSERT INTO goj_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","फिर वू थोडो आगे गयो, अरु जमीन पर गिरीखे प्रार्थना करन लगीगो की तकलिप को टेम मरा परसे टली जाह्ये. ");
INSERT INTO goj_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","अरु बोलन लगीगो,“हे पिता हे , बाप तरा से तरा सब कुछ होस हइ.यो कटोरा खे मरा पास से दुर करी ले फिर भी जसो मी चाउस हइ वोसो नी, पर जो तू चाहस हइ वोसो हो.” ");
INSERT INTO goj_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","अरु ओने अयखे उनखे सोते मील्या अरु पतरस खे बोल्यो, हे शमौन, तू सोय रो हइ? का तू एक टेम भी नी जागी सक्यो? ");
INSERT INTO goj_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","जागते अरु प्रार्थना करते ऱ्हेव की परीक्षा मेनी फसी जानु. आत्मा तो तैयार हइ पन आंग छोटो हइ. ");
INSERT INTO goj_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","अरु नी ओने जयखे फिर उ शब्द मे प्रार्थना करी. ");
INSERT INTO goj_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","अरु ओने फिर अय खे उनखे सोते मील्या क्युकी उनका आख नीद से भरी थी, अरु वे नी समजता था की ओखे का उत्तर देनु. ");
INSERT INTO goj_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","फिर ओने तिसरी बार अय खे उनखे बोल्यो, का तुम अभी तक सोय रास अरु आराम करी रास? खुप हुयगो टेम अयगी.देख,इन्सान को बेटो पापी का हात मे पकडय जास हइ. ");
INSERT INTO goj_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","उठ, आ चल देख, यो अय रो हइ मेखे धोका से पकडनवालो इन्सान. ");
INSERT INTO goj_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","उ यो बोली मे रो थो यहूदा, जो बारा झन मे से एक थो, अपना साथ, महायाजकहोन अरु शास्त्रिहोन अरु बापदादाहोन का तरफ से एक बडि गर्दी लइ तलवारहोन अरु लकडि होन लिया हुया तुरुत अय, पहुच्यो. ");
INSERT INTO goj_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","ओखे पकडन आला ने ओखे यो बोली खे बतयो दियो थो की जोको मी चुम्मो लीह्यू वोखेय अछा से लीखे जानू. ");
INSERT INTO goj_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","व्हा पोची खे अरु तुरुत ओका पास जयखे, ओने बोल्यो, अरु गुरु असो बोल्यो अरु चुम्मो लीयो. ");
INSERT INTO goj_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","तब उनने ओखे पकडि खे गिरफ्तार बंदी बनइ लीयो. ");
INSERT INTO goj_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","येका पर खडा दुन्या मे से एक ने तलवार खीची खे महायाजक का सेवक पर चलइ अरु ओको कान काटी दियो. ");
INSERT INTO goj_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","यीशु ने उत्तर देते हूये बोल्यो, का तुम दुन्या मखे गुना समझस जो तलवार अरु लकडि लीखे मेखे बंदी बनान का लीए आया. ");
INSERT INTO goj_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","मी तुम्हारा साथ आराधनालय मे दरोज शिक्षा देतो थो अरु तुमने मेखे नी पकड्यो, पर येका लिये हुयो की पवित्रशास्त्र को लिखनो पुरो होनखे होनु. ");
INSERT INTO goj_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","येका पर सब ने ओखे भूलीगा अरु छोडि खे भागीगा. ");
INSERT INTO goj_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","एक जवान ओका पिछे चली रोथो. वू अपना उघाडा आंग पर फक्त मलमल को कपडा को चद्दर होडि खे थो उनने ओखे पकड्यो. ");
INSERT INTO goj_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","पन वू मलमल को चद्दर छोडि खे नंगो भागीगो. ");
INSERT INTO goj_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","वे यीशु खे मुखियो महायाजक का ह्या लि गया, सब बडा याजक का बापदादा अरु शास्त्री व्हा एक साथ जमा हुयगा था. ");
INSERT INTO goj_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","पतरस तो दुरी दुर से महायाजक का अंगन तक ओका पिछे पिछे गयो थो.उ रखवाली का सात व्हा बठी व्हा अंगार सेकन लगीगो. ");
INSERT INTO goj_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","महायाजक अरु सभा यीशु खे मारी डालन का लीये ओका खीलाप गवय ढुढन को कोसीस करी राथा, पन उनने एक भी गवय नी मीली. ");
INSERT INTO goj_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","क्युकी भोत झन ओका खीलाप झुटी गवय दिराथा पन उनकी गवय एक दुसरा से मीली नी री थी. ");
INSERT INTO goj_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","तब ओका खीलाप खडा हुय खे गवय देन लगीगा. ");
INSERT INTO goj_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","हमने ओखे यो बोलते सुन्यो, मी हात से बनय आली मन्दिर खे तोडिखे करी दिह्यू, अरु तीन दिन मे दुसरी खडि करी दि दिह्यू, जो हात से बनय वाली नी हुये. ");
INSERT INTO goj_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","येका पर भी वोकी गवय का जसी थी. ");
INSERT INTO goj_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","फिर महायाजक ने खडो हुय खे ओने अय खे यीशु पुछ्यो, “जो गवय ये तरा खीलाप दि रास का तु उनखे उत्तर नी दे?” ");
INSERT INTO goj_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","पन वू चुप र्‍हियो अरु ओने कोय उत्तर नी दियो. महायाजक ने फिर ओखे पुछ्यो, “तू वू परमधन्य को बेटो आयो मसीह तु आ?” ");
INSERT INTO goj_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","यीशु ने बोल्यो, “मी आयो! अरु तुम इन्सान को बेटा खे सबसे शक्ति मान की डाखोर्या तरप बठाडस अरु स्वर्ग से बदल का सात आते हुयो देख्ये.” ");
INSERT INTO goj_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","येका पर महायाजक ने अपना कपडा फाडि खे बोल्यो, “आब हमसे अरु गवाह की का जरुरत हइ?” ");
INSERT INTO goj_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","तुम यो नीन्दा सुनी लीयो हुये येका पर तुमारो का मतलब हइ. अरु वे सब झन ने ओखे जान से? मारन को दण्ड का योग्य दोषी ठयरय दियो. ");
INSERT INTO goj_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","तब कुछ झन वोका पर थुकन लगीगा, अरु ओका आख मे पट्टी बांधी खे बुक्की मारन लगीगा अरु वोखे बोलन लगीगा भविष्यवाणी कर! अरु रखवाली. ने पकडयो अरु ओका मुडा पर थपड माऱ्यो. ");
INSERT INTO goj_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","जब पतरस अंगन मे थो, महायाजक की दासी होन मेसे एक व्हा अय, ");
INSERT INTO goj_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","अरु पतरस खे अंगार सेकते देख्यो अरु ओका पर नजर रखखे बोलन लगी, “तू भी यीशु नासरी यीशु का साथ थो,” ");
INSERT INTO goj_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","पन ओने नीबोलनो करते हूयो बोली दियो, “मी नाही तो जानूस अरु नाही समजूस की तु का बोलीरीस.” अरु वू बाहेर परमेश्वर का पास गयो, अरु मुर्गा ने बांग दी. ");
INSERT INTO goj_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","ओखे देखी खे पास खडा आला दुन्या से वइ दासी फिर बोलन लगी गय, “यो तो ओमे से एक आयो!” ");
INSERT INTO goj_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","पन ओने नी बोल्यो. थोडि देर बाद जो नजीक खडा था उनने फिर पतरस खे बोल्यो, “जरुर तू उनमे से एक आय, क्युकी तु भी गलील मे हइ!” ");
INSERT INTO goj_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","पन वू धिक्कारन अरु कसम खान लगीगो, “मी यो इन्सान खे जोकी तुम जेकी बात करी रास मी ओखे नी पहीचानू!” ");
INSERT INTO goj_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","अरु तुरुत दूसरा मुर्गा ने बार बांग दी. तब पतरस खे यीशु ने ओखे बोली बात, ओखे समजी गयो, मुर्गा का दो बार बांग देना से पैयले तू तीन बार मरो इनकार कर्‍हे. अरु उ रोन लग्यो. ");
INSERT INTO goj_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","अरु फजर होते मेका तुरुत महायाजक ने बापदादा का शास्त्री अरु सब सबा का सात नीर्णय लियो, अरु यीशु खे बाधीखे लिग्यो, अरु ओखे पिलातुस, हात मे दि दियो. ");
INSERT INTO goj_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","पिलातुस ने ओखे पुछ्यो, तू यहूदीया को राजो आयो ओने उत्तर दियो ओखे बोल्यो, तु खुद मे बोली रोस. ");
INSERT INTO goj_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","अरु महायाजक ओका पर खुप बात की इलजाम लगय रा था. ");
INSERT INTO goj_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","पिलातुस ने ओखे बोलते हूयो पुछो “तू उत्तर नी दे? देख वे तरा खीलाप खेत्ता इलजाम लगय रास.” ");
INSERT INTO goj_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","पन यीशु ने कोय उत्तर नी दियो येका से पिलातुस खे आश्चर्य हुयो. ");
INSERT INTO goj_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","तिवार, दिन दुन्या होन एखादी बन्दी खे ओका तरप छोडी देता था. ");
INSERT INTO goj_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","उ टेम बरअब्बा नाम को इन्सान बन्दीघर मे थो ,उ उन विद्रिहिहोन, साथ गिरफ्तार हुयो थो, जिन्हे राजद्रोह, टेम मारनो करी थी. ");
INSERT INTO goj_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","अरु गर्दी पर जय खे ओकासे प्रार्थना करण लगी गया, की तू जसो करते आयोस तू वसो हमारा लिये कर. ");
INSERT INTO goj_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","अरु पिलातुस ने उनखे उतारी दियो “तु चाहस की मी तुमारा लीये यहूदीया को राजा खे तुमारा लीये छोडी दिव?” ");
INSERT INTO goj_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","क्युकी वू जानतो थो की महायाजक ने ओखे इर्ष्या कुल जबर दस्ती पकडी लीयो थो ");
INSERT INTO goj_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","पन महायाजक ने गर्दी से यो बोलन का लीये उकसायो कऱ्यो वू उनका बदला मे बरअब्बा खे छोडी दे. ");
INSERT INTO goj_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","पिलातुस ने फिर उत्तर दियो, “तब तुम जेखे यहूदीया को राजो बोलस का मी ओखे का करु?” ");
INSERT INTO goj_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","वे फिर चिल्लाना, “ओखे क्रुस पर चडा!” ");
INSERT INTO goj_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","पिलातुस ने ओखे बोल्यो, क्यु? ओने का बुरो कर्‍यो? पन वे भी जोर से चिल्लाना, “ओखे क्रुस पर चडा.” ");
INSERT INTO goj_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","तब पिलातुस ने गर्दी खे शाती रखन की इच्छा से बरअब्बा खे ओका लिये छोडी दियो, यीशु खे मारते मारते क्रुस पर चडा न खे दि दियो. ");
INSERT INTO goj_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","सिपइ ओखे की किल्ला का अंदर का अंगन मे लीगया, अरु व्हा उनने सब रोमी सेना खे बुलय खे एक जगा जमा कऱ्या. ");
INSERT INTO goj_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","उनने ओखे जामडा कपडा परनायो अरु का काटा को मुकुट बाधी खे ओका माथा पर रख्यो. ");
INSERT INTO goj_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","तब वे ओको आदर करण लग्य, “हे यहूदीया को राजा तरी जय हुये!” ");
INSERT INTO goj_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","वे ओका माथा पर सरकण्‍डे से मारता था अरु वे ओका पर थुकता था, अरु घुटना टेकी खे वोखे प्रणाम करी राथा. ");
INSERT INTO goj_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","जब वे ओकी मजाक उडान हुयगो ते ओखे जामडा कपडा उतारीखे ओखे ओका कपडा पेनय दिया.अरु वे ओखे क्रुस पर चडान खे बाहेर लिखे आया. ");
INSERT INTO goj_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","अरु उनने सिकंदर अरु रुफुस को बाप शमौन कुरेनी खे जो गाव से अय रोथो, ते जबर दस्ती पकडि खे यीशु क्रुस उठय खे लिग्यो. ");
INSERT INTO goj_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","अरु वे ओखे गुलगुता नाम, जगा मे लायो, जोको मतलब खोपडी की जगा. ");
INSERT INTO goj_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","अरु उनने मसीह यीशु गधानालो रस मील्यो आलो अंगूर को रस पिन खे देन को कोशीस कर्‍यो. पन ओने नी लियो. ");
INSERT INTO goj_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","तब उनने ओखे क्रुस पर चडायो, अरु ओका कपडा पर चिट्ठिहोन डालीखे, कोखे, मील्यो, उनने बाटी लियो. ");
INSERT INTO goj_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","जब उनने ओखे क्रुस पर चडायो ते वा टेम मे फजर का नउ बजी गा था. ");
INSERT INTO goj_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","अरु वोकी पुरी कागज पर लीखो तो, की यो “यहूदी को राजो.” ");
INSERT INTO goj_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","उनने ओका सात दो डाकू खे भी क्रुस पर चडायी दियो एक खे जवना तरप दुसरा खे डाखोर्या तरप. ");
INSERT INTO goj_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","तब पवित्रशास्त्र को यो वचन पुरो हुयो जोमे बोल्यो गयो थो, वु बुरालोग का सात गिनती मे अय गयो. ");
INSERT INTO goj_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","अरु व्हासे आन जान आला ओकी नीन्दा उडन लगीगा अरु माथो हलाते हलाते बोलन लग्या “अरे! आराधनालय खे तोडन आलो अरु तीन दिन मे बनान वलो, ");
INSERT INTO goj_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","अपना आप खे बचान अरु क्रुस से उतरी जा!” ");
INSERT INTO goj_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","यो तरीका से महायाजक अरु शास्त्री भी साथ मे मीली खे ओकी मजाक उडाते यो बोलीरा था, “ये ने दुसरा खे बचायो पन खुद खे नी बचय सकन को.” ");
INSERT INTO goj_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","इस्राएल को राजो मसीह आब क्रुस पर से उतरी आह्ये कि हम देखीखे विश्वास कर्ये, अरु जो ओका साथ क्रुस पर चडाया गया था वे भी ओकी मजाक करस हइ. ");
INSERT INTO goj_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","जब दुपार का बारा बजी गा ते पुरो देस मे अधारो हुइ गयो अरु दिन का तिन बजो तक अंधारो थो. ");
INSERT INTO goj_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","अरु तिन बझना पर यीशु जोर से चिल्लाखे बोल्यो का “इलोइ, इलोइ, लमा शबक्तनी?” येको मतलब, “हे मरो परमेश्वर हे मरो परमेश्वर तोने मेखे कायबर छोडि दियो?” ");
INSERT INTO goj_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","तब जो ओका नजी खडा था उन मे से कुछ यो सुनीखे बोलन लग्या, देख, उ एलिय्याह खे पुकारी रोस. ");
INSERT INTO goj_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","अरु एक ने दौडि खे खटो रस एक स्पंज का सिरखे मे डुबायो, अरु सरकण्‍डे पर रखीखे ओखे चुसायो, अरु बोल्यो “रुखी जा ; देख एलिय्याह ओखे उतारन का लिये आस हइ कि नी.” ");
INSERT INTO goj_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","तब यीशु ने बडा आवाज से चिल्लैइ खे जान छोडि दियो. ");
INSERT INTO goj_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","अरु आराधनालय का परदा उपर से नीच्चे तक फटी खे दो टुकडा हुइ गया. ");
INSERT INTO goj_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","जब सुबेदार ने जो व्हा सामने खडो थो ओखे असो जान छोडते देख्यो ते बोल्यो “सच्ची यो इन्सान परमेश्वर को बेटो थो!” ");
INSERT INTO goj_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","कुछ बयहोन भी जो दूर से देखी री थी, ओमे मरियम मगदलीनी,छोटो याकूब, अरु योसेस की मरीयम,अरु सलोमी थी. ");
INSERT INTO goj_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","जब वु गलील मे थो ते ये ओका पिछ पिछ चलती अरु ओकी सेवा करती थी; अरु दुसरी खुप बय होन ओका सात यरुशलेम मे अय थी. ");
INSERT INTO goj_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","जब शाम हुइ गइ, जो तैयारी का दिन थो जो आराम दिन का एक दिन पैयले हइ. ");
INSERT INTO goj_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","अरिमतियाह का ऱ्हेन आलो यूसुफ आयो, जो सभाको एक प्रतीष्ठीत थो. उ खुद परमेश्वर का राज्य की रस्ता देखी रोथो ओने हिम्मंत करीखे पिलातुस का आगे जय खे यीशु की लास मागी. ");
INSERT INTO goj_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","पिलातुस खे अच्मबो हुयो की वू येत्ता झल्दी मरी गो, अरु ओने चौकीदार खे बुलैइ खे पुछ्यो “का ओखे मरी खे देर हुइ?” ");
INSERT INTO goj_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","फिर ओने चौकीदार से एक कपडा मे गुडि खे यूसुफ खे लास दि दि. ");
INSERT INTO goj_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","तब यूसुफ ने मलमल को कपडा मोल लियो अरु लास खे उतारी खे ओमे गुंड्यो, अरु पत्थर आली जगा मे एक कब्र खोदी गइ थी, अरु एक कब्र का दरवाजा पर एक पत्थर गन्डलैइ दियो थो. ");
INSERT INTO goj_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","मरियम मगदलीनी अरु योसेस की माय मरीयम देखी रीथी की ओखे खापर रख्योस. ");
INSERT INTO goj_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","जब अराम का दिन जाना पर, मरियम मगदलीनी,अरु याकूब कि माय मरियम अरु सलोमी ने गधानवाली चीज मोल लियो, की अय खे ओखे तेल मल. ");
INSERT INTO goj_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","अरु हप्ता को पहीलो दिन फजर खे , जब सुरज नीकलन का पैयले वे मरगट का पर अय. ");
INSERT INTO goj_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","अरु आपस मे बोलीरी थी, “कोण हमारा लिये मरगट का दरवाजा पर को पत्थर कोन लुन्डका ह्ये?” ");
INSERT INTO goj_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","जब उनोने आख उठइ खे देख्यो , ते पत्थर हट्यो हुयो थो. उ भोत ही बडो हइ ");
INSERT INTO goj_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","वे मरगट मे अंदर गइ अरु यो देखी खे आश्‍चर्य-चकित र्‍हि गइ कि सफेद कपडा पेन्या एक नवो इन्सान दाहिनी तरफ बठौ हुयो हइ. ");
INSERT INTO goj_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","“ओने उनखे बोल्यो,” चकाय मत. तुम यीशु नासरी खे क्रुस पर चडायो गयो थो, ढुंढस हइ उ जिन्दो हुइ गो उ ह्या नी हइ देख या वा जगा आयो झा उनने ओखे रख्यो थो. ");
INSERT INTO goj_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","पर जा अरु, ओका सेवक अरु पतरस खे बोल का वु तुम से पहिले गलील मे जाह्ये अरु तुम ओखे व्हा पर देख्ये. ");
INSERT INTO goj_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","वे मरगट से नीकली अरु व्हा भागी गय, क्युकी थर थरी उनको उध्दार हुये गो थो; अरु उनने कोय खे भी कुछ नी बतायो, क्युकी वे डरी गिथी. ");
INSERT INTO goj_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","हप्ता का पैयले दिन का फजर खे उ जिन्दो हुइ खे सब से पैयले मरियम मगदलीनी खे जोमे से ओने सात बुरीआत्माहोन नीकाली थी वे दिखय दि. ");
INSERT INTO goj_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","ओने जयखे यो बात यीशु का दोस्तहोन खे बतायो, जो शोक मे डुब्या था अरु रोइ र्‍हा था यो समाचार बतायो. ");
INSERT INTO goj_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","अरु ओने यो सुन्यो की यीशु जिन्दो हइ अरु ओखे दिखानो ते उनखे विश्वास नी हुयो. ");
INSERT INTO goj_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","येका बाद व्हा दुसरा रुप मे उनमे से दो खे वे गाव का तरप जइ र्‍हा था, दिखय दियो. ");
INSERT INTO goj_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","उनने जैइखे दुसरा खे समाचार बतायो, पर उनने भी विश्वास नी कऱ्यो. ");
INSERT INTO goj_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","पीछे वे ग्यारा सेवक खे भी जब वे खानो खान खे बठ्या था दिखय दियो अरु अविश्वास,अरु मन की कठुरता पर डाट्यो क्युकी जेने ओखे जिन्दो होना का बाद देख्यो थो इन्हे उनको विश्वास नी कर्यो थो. ");
INSERT INTO goj_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","अरु यीशु ने उनसे बोल्यो,“जगत मे जय खे पूरी सृष्‍टि का इन्सानहोन खे सुसमाचार प्रचार करनु, ");
INSERT INTO goj_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","जो विश्वास कऱ्हे अरु बपतिस्मा लिये ओको उध्दारहुये, पर जो विश्वास नी कर्ये उ दोषी ठैरायो जाये. ");
INSERT INTO goj_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","विश्वास करन आला मे यो चिन्ह हुये कि वे मरा नाम से बुरीआत्माहोन नीकाल्हे अरु नइ भाषा बोल्हे; ");
INSERT INTO goj_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","सापहोन खे उठय, लिये अरु अगर वे जहेर भी पी लिये तब भी उनकी कुछ नुकसान नी हुये; वे बीमारीहोन पर हात रख्ये, अरु वे अच्छा हुइ जाये.” ");
INSERT INTO goj_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","अन्नत मे जब प्रभु यीशु ओका से बात करी चुक्यो, थो वु स्वर्ग मे उठय लियो गयो, अरु परमेश्वर का जवना बाजू बठी गयो. ");
INSERT INTO goj_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","अरु उनने नीकली खे हर जगा मे प्रचार कर्यो, अरु प्रभु उनका साथ काम करतो रीयो अरु उन चिन्ह का वजेसे जो साथ होतो थो, वचन खे मजबुत करतो र्‍हियो. आमेन");
INSERT INTO goj_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","भोत दुन्या ने हमारा बीच मे बीती बात को विवरण जाने खे लिखन को प्रयत्न कर्‍यो. ");
INSERT INTO goj_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","वा या बात वे दुन्या, वजेसे बतायो गयो जो दुन्या ने पैयलेसे कम होते देख्यो, अरु जो खुसखबर को प्रचार करीरा था. ");
INSERT INTO goj_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","हे श्रीमान थियुफिलुस, क्युकी मेने येका लिये एक अच्छो समजी लियो कि मी यो विवरण लिख्यू. ");
INSERT INTO goj_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","मे ने येका लिये आस करी की जो बात ,त्ती सच्ची हइ, तुमखे मालुम हुये. ");
INSERT INTO goj_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","वे दिन जब यहूदीया पर हेरोदेस को राज थो व्हा जकर्याह नाम को एक याजक थो, समेदाय को थो अरु ओकी लुगइ को नाम एलीशिबा तरप व्हा हारुन, परीवार की थी. ");
INSERT INTO goj_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","वे दो परमेश्वर, नजर मे अच्छो जिवन जिन वाला था प्रभु को आज्ञाहोन अरु नीयम को पुरी रीति से नीर्दोष पालन करण आलो थो. ");
INSERT INTO goj_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","उनखे कोय बच्चा नी था.क्युकी एलीशिबा बाझ थी अरु वे दो झन बुड्‍डा था. ");
INSERT INTO goj_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","जब जकर्या, मन्डली कि मदिर मे याजक पद, नीत्य काम बाडी थी अरु एक दिन जब जकर्याह मदिर मे परमेश्वर अपनो याजक भी काम करी रो थो. ");
INSERT INTO goj_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ते याजक की रीति, जसो ओका नाम पर चिट्ठी नीकली. कि प्रभु की मन्‍दिर मे जयखे धूप जला. ");
INSERT INTO goj_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","अरु धूप जलान को टेम आयो ते बाहेर जमा दुन्या प्रार्थना करी रा था. ");
INSERT INTO goj_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","वाइच टेम जकर्याह, सामने खडो कि प्रभु को एक स्वर्गदूत धूप की वेदी, जवना तरप खडो हुयो थो. ");
INSERT INTO goj_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","अरु जकर्याह देखी खे घबरायो अरु ओका पर भोत डरी गो. ");
INSERT INTO goj_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","पन स्वर्गदूत ने ओका से बोल्यो.हे जकर्याह. डरे मत क्युकी तरी प्रार्थना सुनी लीस हइ अरु तरी लुगय एलीशिबा से तरा लिये एक बेटो परदा हुये. अरु तू ओको नाम यहून्ना रखनु. ");
INSERT INTO goj_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","अरु तोखे खुशी अरु हर्ष हुये अरु भोत दुन्या ओका परदा होना से खुश हूये. ");
INSERT INTO goj_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","क्युकी उ प्रभु, नजर मे बडो हूयो. व्हा कभी भी अंगूर को रस अरु मदिरा कभी नी पीह्ये. अरु अपनी माय, पेट मे से पवित्र आत्मा से पुरो हुये जाह्ये. ");
INSERT INTO goj_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","अरु इस्राएल मे से भोतझन खे उनका प्रभु परमेश्वर, तरप फिरा आह्ये. ");
INSERT INTO goj_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","वू भविष्यवक्ता एलिय्याह की आत्मा जसी शक्ती अरु सामर्थ्य, सात प्रभु, आगे आगे चली. अरु बाप अरु बेटो खे फिर से एक सात कर्‍हे. व्हा आदेस नी माननआला दुन्या को असा बिचार रखस. व्हा प्रभु, दुन्या खे प्रभु ,लिये तैयार कऱ्हे. ");
INSERT INTO goj_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","जकर्याह ने स्वर्गदूत से पूछ्यो. मी ह्या कसो समजु? कि यो सच्ची हइ अरु मी तो बुड्ढो आय. अरु मरी बायको भी बुड्ढी हुय गी हइ. ");
INSERT INTO goj_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","ते स्वर्गदूत ने ओखे उत्तर दियो. की मी जिब्राइल आय. जो परमेश्वर, सामने खडी मरियम हइ. अरु मी तरा से बात करण लगीगो अरु तोखे खुसखबर सुनान खे भेज्यो गयो थो. ");
INSERT INTO goj_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","पन मरो खबर जो बरोबर टेम पर सही सिध्द हुयो ओका पर विश्वास नी कर्‍यो, येका लिये तु मेको हुय जाह्येका अरु वु दिन तक नी पोची नी सकन को जो दिन तक पुरो नी होनको. ");
INSERT INTO goj_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","अरु उधर बाहेर दुन्या जकर्याह की रस्ता देखीरा था अरु अचम्बो करण लग्या की ओखे मन्‍दिर मे, करी रोस हइ? ");
INSERT INTO goj_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","जब बाहेर आयो.ते उनका सात बोली नी सक्यो: बाद मे समजी गया, की वोने मन्‍दिर मे कोय दर्शन मील्योस हइ. अरु व्हा उन से हीसारो करते र्हीयो. अरु मेक्को र्हि गो. ");
INSERT INTO goj_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","जब ओका सेवा का दिन पुरा हुय गया. ते वू अपना घर चली दियो. ");
INSERT INTO goj_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","कुछ दिन का बाद ओकी लुगइ एलीशिबा दिन से हुइ. अरु पाच महीना तक वा सब से अल्लग र्‍ही. ");
INSERT INTO goj_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","अरु ओने अपना आप से बोल्यो अब आखरी मे जैख या रीति प्रभु ने मरी मदत करीस हइ, दुन्या, बीच मरी लाज रखन खे मरी याद ली. ");
INSERT INTO goj_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","जिब्राइल छे महीना कि दिन से थी तब परमेश्वर, तरप से गिब्राइल स्वर्गदूत गलील, नासरत नगर मे एक कुव्वारी का पास भेज्यो गयो. ");
INSERT INTO goj_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","एक कुव्वारी का पास भेज्यो गयो.जोकी मगनी यूसुफ नाम दाउद का घराना का एक इन्सान का सात हुय थी वा कुव्वारी को नाम मरियम थो. ");
INSERT INTO goj_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","अरु स्‍वर्गदूत ने ओका पास अंदर अयखे बोल्यो. परमेश्वर कि शांती तरा साथ हइ, अरु परमेश्वर तरा साथ हइ अरु तोखे भोत बडो आशिष दिह्ये. ");
INSERT INTO goj_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","स्वर्गदूत कि खबर सुनीखे डरी गया अरु सोच मे पडी गया कि यो शब्द को का अर्थ हुये? ");
INSERT INTO goj_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","स्वर्गदूत ने ओकासे बोल्यो हे मरियम डरे मत. क्युकी परमेश्वर को अनुग्रह तरा पर हुयोस हइ. ");
INSERT INTO goj_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","अरु देख तू दिन से हुये अरु तरो एक बेटो परदा हुये. तोने ओको नाम यीशु रखनु. ");
INSERT INTO goj_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","वु महान हुये. अरु बडो इन्सान को बेटो बोल्यो जाह्ये अरु प्रभु परमेश्वर ओखे ओका बापदादा को राजो दाउद की राजगद्दी ओखे देस. ");
INSERT INTO goj_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","अरु उ याकूब का घराना पर युगानुयुग राज कर्हे. अरु ओका राज को कभी खत्म नी हुये. ");
INSERT INTO goj_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","मरियम ने स्वर्गदूत बोल्यो. यो यबर करी रोस? मी तो कुव्वारी हइ. ");
INSERT INTO goj_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","स्वर्गदूत ने ओखे उत्तर दियो. कि पवित्र आत्‍मा तरा पर उतरी. अरु परमेश्वर कि सामर्थ्य तरा पर उतऱ्हे, अरु येका कारण पवित्र बच्चा परमेश्वर को बेटो बोल्यो जाह्ये. ");
INSERT INTO goj_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","अरु देख तरा कुटुम वाला एलीशिबा जो दुन्याहोन बाज बोलता था पन वा खुद छे महीना की दिन से थी वा भोत डोकरी थी. ");
INSERT INTO goj_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","परमेश्वर, लिये कुछ भी असम्भाव नी हइ. ");
INSERT INTO goj_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","मरियम ने बोल्यो. जसो तोने मे, बोल्यो की मी परमेश्वर की दासी आय. मे, तरा वचन, जसो हुये जब स्वर्गदूत ओका पास से चली दियो. ");
INSERT INTO goj_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","ओका तुरुत बाद मरियम तैयार हुयखे यहूदा टेकडा देस, एक गाव मे जत्ती लगी. ");
INSERT INTO goj_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","अरु जकर्याह, घर मे पोची अरु वोने एलीशिबा खे नमस्कार कर्यो. ");
INSERT INTO goj_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","जोभी यो हुयो कि एलीशिबा ने मरियम को नमस्कार सुन्यो. तेय बच्चो ओका पेट मे उछल्यो. अरु एलीशिबा पवित्र आत्‍मा से परिपूर्ण हुय गी. ");
INSERT INTO goj_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","अरु वोने बडा जोरसे बोल्यो तु बय होन मे धन्य हय. अरु तरा पेट को फल धन्‍य हइ. ");
INSERT INTO goj_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","येतनी बडि बात मरा सात क्युव हुय, की मरो परमेश्वर की माय मरा से मीलन अय? ");
INSERT INTO goj_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","किक्यु जसो मेने तुम के अभिवाद का बोल सुनायो मरा पेट का बच्चा खुशी से उछल कुद करन लग्या. ");
INSERT INTO goj_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","तु, धन्‍य हइ. वु जेने विश्वास कर्यो कि जो बात परमेश्वर का तरप से ओका से बोली गइ. वा पूरी हुयखे र्हिये. ");
INSERT INTO goj_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","जब मरियम ने बोल्यो. मरो जान परमेश्वर की बडाइ करतो हुये. ");
INSERT INTO goj_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","अरु मरी आत्मा मरो उध्दार करणवालो परमेश्वर से आनद हुये. ");
INSERT INTO goj_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","क्युकी ओने अपनी दासी की दीनता पर नजर बतयस हइ. येका लीये देख. आप से सब जगत, दुन्या मेखे धन्‍य बोल्हे. ");
INSERT INTO goj_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","क्युकी वू शिक्‍तमान ने मरा लिये बडो काम कर्योस अरु ओको नाम पवित्र हइ. ");
INSERT INTO goj_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","अरु ओकी दया उनका पर. जो ओकासे डरस हइ. पीढी से पीढी तक बनी र्हेस हइ. ");
INSERT INTO goj_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","ओने अपनो मेहनत बतय. अरु जो घमण्ड करतो थो. उनखे तित्तर-बित्तर कर्यो. ");
INSERT INTO goj_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","ओने महान राजा खे उनका सिंहासन से गिरय दियो. अरु विनम्र दुन्या खे पलटायो. ");
INSERT INTO goj_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","वो ने भुक खे अच्छो चिजहोन से तृप्त कर्यो. अरु लकपती आला खे खाली हात नीकली दीयो. ");
INSERT INTO goj_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","हमारा बुर्जुक खे दियो गयो दया, जसो व्हा अपना सेवक इस्राएल, सात आह्ये. ");
INSERT INTO goj_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ओखे अब्राहम अरु वोको कुल पर हमेशा दया बतान की र्हिये. ");
INSERT INTO goj_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","मरियम नजीकपास तीन महीना येलि का साथ र्हिखे अपना घर मे वापस गइ. ");
INSERT INTO goj_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","फिर एलीशिबा को बच्चा खे जन्म देन को टेम आयो फिर ओका घर मे एक बेटो पइदा हुयो. ");
INSERT INTO goj_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","ओका बाजुआला अरु कुटुम्ब ने यो सुनी खे कि परमेश्वर ने ओका पर बड़ी दया करीस हइ. ओका सात खुशी मना. ");
INSERT INTO goj_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","अरु असो हुयो की आठवा दिन वे बच्चा को खतनो करण खे व्हा आया वे वोको नाम वोका बाप पर जकर्याह रखन लग्या. ");
INSERT INTO goj_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","पन वोकी माय ने उत्तर दियो नी. वोको नाम यहून्ना रख्यो जाह्ये. ");
INSERT INTO goj_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","अरु उनने ओकासे बोल्यो, “पन तरा परीवार मे कोय को यो नाम नी.” ");
INSERT INTO goj_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","फिर उनने ओका बाप से हीसारो से पुछ्यो कि ओको नाम का रखनो चाहस. ");
INSERT INTO goj_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","अरु येका पर जकर्याह ने लिखन कि पाटी मागीखे लिखी दियो, कि “वोको नाम यहून्ना हइ ओने अचम कर्यो. ");
INSERT INTO goj_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","जब वोका मेडो अरु जीब तुरुत खूली गय. अरु वू बोलन लग्यो अरु परमेश्वर को धन्यवाद करण लग्यो. ");
INSERT INTO goj_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","अरु वोका आस पास का सब झन र्हेन आला पर डर हुय गोथो. अरु वे सब बात की बातचीत यहूदीया टेकडा देस मे फैली गी. ");
INSERT INTO goj_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","अरु सब सुनन आला ने अपना मन मे बिचार करीखे बोल्यो. यो बच्चो कसो हुयगो?” क्युकी परमेश्वर को सामर्थ्य वोका सात थो. ");
INSERT INTO goj_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","अरु वोको बाप जकर्याह पवित्र आत्‍मा से परिपूर्ण हुगयो. अरु भविष्यवाणी करण लग्यो. ");
INSERT INTO goj_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","इस्राएल को प्रभु परमेश्वर धन्‍य हय. कि वोने अपना दुन्या पर नजार करी अरु उनका छुटकारो कर्योस हइ. ");
INSERT INTO goj_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","ओने हमारा लिये अपना सेवक उध्दार दाउद, परीवार से एक रखवालो परदा कर्‍यो. ");
INSERT INTO goj_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","जसो कि वोने भोत पैयले से अपना पवित्र भविष्यव्दक्ता,होन , वजेसे प्रतीज्ञा को वचन दियो थो. ");
INSERT INTO goj_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ओने हमखे हमारा दुशमन से, अरु सब , हात से जो हम घृस्सा करतो थो हमारो छुट,रो को वचन से उध्दार दियो थो. ");
INSERT INTO goj_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","कि हमारा बाप-दादा पर दया बतानो अपनी पवित्र वचन खे याद कर. ");
INSERT INTO goj_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","अरु वा कसम जो उनने हमारा बाप अब्राहम से खाय थी. ");
INSERT INTO goj_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","कि हम दुशमन, हात से छुडाये मेती कर्‍हे. ");
INSERT INTO goj_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","क्युकि अपना जिवन भर हर दिन वोका सामे पवित्रता अरु धर्मी ");
INSERT INTO goj_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","हे बच्चा. बडो प्रधान परमेश्वर , भविष्यव्दक्ता बोल्यो जाह्ये. क्युकी परमेश्वर की रस्ता तैयार करण लीये वोका आगे आगे चल्यो. ");
INSERT INTO goj_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","वोका दुन्या खे उध्दार को ज्ञान दे, जो उनका पाप की माफी से मीलस हइ. ");
INSERT INTO goj_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","यो हमारा परमेश्वर की मन कोमल दया करण एक नवो सबेरे कि पयली किरन आ,स से हमारा पर उतर्‍हे. ");
INSERT INTO goj_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","अरु उनका पर चमकन, लिये जो मरन की छाय मेजिन्दा र्‍हिरास हइ, ताकी हमारा पाय की शांती की रस्ता कि दिशा मील्‍हे. ");
INSERT INTO goj_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","यो प्रकार बच्चो यहून्ना, आंग मे बढते अरु इस्राएल आत्मा मे बढते गयो अरु दृड होते गयोस. ");
INSERT INTO goj_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","वे दिन मे बडो राजो कैसर औगूस्‍तुस का तरप से आज्ञा नीकली, की सब रोमी जगत का दुन्या को नाम लिखायो जाह्ये. ");
INSERT INTO goj_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","जनगनना यो पयली थी, सीरिया को राज्यपाल क्विरिनीयुस थो. ");
INSERT INTO goj_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","अरु सब दुन्या नाम लिखान का लीये अपना अपना गाव मे गया. ");
INSERT INTO goj_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","अरु यूसुफ भी गलील का देस से नासरत नगर से यहूदीया देस को दाउद राज को नगर बैतलहम खे गयो क्युकी व्हा दाउद का धरानो अरु कुल से थो. ");
INSERT INTO goj_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","कि अपनी मगेत्तर मरियम का साथ जो दिन से थी नाम लिखायो. ");
INSERT INTO goj_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","असो हुयो कि जब वे व्हा था तब बच्चा को जन्म देन को टेम अय गयो. ");
INSERT INTO goj_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","अरु व्हा अपनो पहिलो बेटो हुयो अरु ओखे कपडा मे गुड्यो गव्हान मे रख्यो क्युकी वुन, लिये कोय भी जगा नी थी. ");
INSERT INTO goj_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","तब व्हा वा जागा से बाहेर खेत मे थोडा ठाट्या था. जो रात का टेम मे अपनो मेडा झुण्ड कि जागल करी रा था. ");
INSERT INTO goj_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","वा टेम मे परमेश्वर को एक स्वर्गदूत व्हा प्रगट हुयो उनका चारी तरफ प्रभु को तेज चमकी गो अरु वे भोत डरी गया. ");
INSERT INTO goj_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","जब स्वर्गदूत ने वुन, से बोल्यो. मत डर. क्‍युकी देख मी तुमखे खुप खुशी कि खुसखबर सुनउस हइ जो सब दुन्या का लिये हुये. ");
INSERT INTO goj_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","कि आज दाउद का नगर मे तुम्‍हारा लिये एक उद्धारकर्ता पइदा हुयोस. अरु मसीह परमेश्वर हइ. ");
INSERT INTO goj_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","अरु येका तुम्‍हारा लिये यो चिन्ह हइ. कि तुम एक बच्चा खे कपडा मे गुडीरास हुये अरु गव्हान मे सोयो मील्हे. ");
INSERT INTO goj_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","जब येत्ता मे वू स्वर्गदूत, सात स्वर्गदूत को दल परमेश्वर की स्‍तुती करतो हुयो अरु यो बोलते दिखय दियो. ");
INSERT INTO goj_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","आकाश मे परमेश्वर की महिमा अरु जमीन पर वे इन्सान मे जेने वु अनुग्रह हइ शांती हुये. ");
INSERT INTO goj_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","तब स्वर्गदूत उनका पास से स्वर्ग खे जत्ती लग्यो,ते येने आपस मे बोल्यो, आव, हम बैतलहम जयखे या बात जो हुइस हइ, अरु जेखे परमेश्वर ने हमखे बतायोस हइ, देख. ");
INSERT INTO goj_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","अरु उनने तुरुत जयखे मरियम अरु यूसुफ खे अरु गव्हान मे वु बच्चा खे सोयो देख्यो. ");
INSERT INTO goj_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","ठाट्याने जब ओखे देख्यो ते जो यो बच्चा का बारे मे जोन खबर उनखे दि गय थी, ओखे उनने सब खे बतय दियो थो. ");
INSERT INTO goj_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","अरु सब सुननवाला ने वे बात से जो ठाट्या उनका से बोल्यो आश्‍चर्य हुयो. ");
INSERT INTO goj_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","पन मरियम या सब बात अपना मन मे रखी खे सोचती र्हे. ");
INSERT INTO goj_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","अरु उदर वे ठाट्या जसा वुन, से बोल्यो गयो थो. वोसोय सब सुनी खे अरु देखी खे परमेश्वर की महिमा अरु स्‍तुति करते हुयो पलटि गयो. ");
INSERT INTO goj_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","तब आठ दिन पूरा हुया. अरु वोको खतनो को टेम आयो. ते वोको नाम यीशु रखी दियो. जो स्वर्गदूत ने वोका पेट मे आना से पहिले बोल्यो थो. ");
INSERT INTO goj_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","अरु तब मूसा खे नीयम, जसो उन खे अच्छो होन, दिन पूरा हुया तेवे वोखे यरुशलेम मे लिगया. कि परमेश्वर, सामने लायो. ");
INSERT INTO goj_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","जसो कि परमेश्वर की नीयम मे लिख्योस हइ कि हर एक पहिलो परमेश्वर का लिये पवित्र र्हिये. ");
INSERT INTO goj_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","अरु परमेश्वर की नीयम को वचन का जसो, एक जोड. या कबूतर का दो बच्‍चा लय खे बलिदान कर्यो. ");
INSERT INTO goj_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","उ दिन मे यरुशलेम मे शमौन नाम को एक इन्सान थो,अरु वु इन्सान अच्छो अरु परमेश्वर खे डरनआलो थो. अरु इस्राएल की रस्ता देखी रो थो, अरु पवित्र आत्‍मा वोका पर थी. ");
INSERT INTO goj_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","अरु पवित्र आत्‍मा से वोखे चेतावनी हुय थी, कि जब तक तू परमेश्वर को मसीह खे देख न लग्यो, तब तक कोन देखेय. ");
INSERT INTO goj_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","अरु वा आत्मा खे सिखाना से मन्‍दिर मे आयो. अरु जब माय बाप वु बच्चो यीशु का अंदर लायो, कि वुन, लिये वेदी, जसो काम कर्‍हे. ");
INSERT INTO goj_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ते वोने वोखे अपनी खोरा मे लियो अरु परमेश्वर को धन्यवाद करीखे बोल्यो. ");
INSERT INTO goj_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","हे स्वामी. आप तू अपना सेवक खे अपनो वादा, जसो शांती से बिदा करस हइ. ");
INSERT INTO goj_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","क्‍युकि मेने अपना आख से तरा उध्दार खे देख्योस हइ. ");
INSERT INTO goj_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","जेखे तोने सब देस का दुन्या का सामने तैयार करस हइ. ");
INSERT INTO goj_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","कि वु गैरयहूदिहोन खे उजालो देन का लीये दिवो. अरु तरा अपना इस्राएल का दुन्या का लिये महिमा खे आह्ये. ");
INSERT INTO goj_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","अरु वोको बाप अरु वोकी माय या बात से जो वोका बारे मे बोली जाती थी आश्‍चर्य करता था. ");
INSERT INTO goj_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","जब शमौन ने उन खे आशिर्वाद दिखे. वोकी माय मरियम खे बोल्यो. देख. वुतो इस्राएल मे खुप गिरनो. अरु जिन्दो उठन का लिये. अरु एक असो चिन्ह होन का लिये ठहयरायो गयोस हइ. जेका खिलाप मे बात करी जाह्ये ");
INSERT INTO goj_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","वरना तरा जान भी तलवार से पार छेद जाह्ये येका से भोतझन को दिल का बिचार प्रकट हुये. ");
INSERT INTO goj_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","व्हा हन्‍नाह नाम फनूएल की आशेर एक जिन्दो भविष्‍यद्वक्‍तन थी वा खुप बूढी थी, अरु अपनो भ्याव फक्त सात साल तक अपना अदमी, सात र्ही. ");
INSERT INTO goj_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","वा चौर्यासी साल से विधवा थी अरु मन्‍दिर खे नी छोडती थी पर उपास अरु प्रार्थना करी खे रात-दिन परमेश्वर कि उपास करती थी. ");
INSERT INTO goj_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","अरु वु वा टेम मे व्हा अय खे परमेश्वर खे धन्‍यवाद करण लगी. अरु उ सब से जो यरुशलेम को छुटकारो की रस्ता देखेता था. वोका बारे मे बात करण लगी. ");
INSERT INTO goj_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","अरु जब वे परमेश्वर की नीयम, जसो सब कुछ खे वे गलील मे अपना नगर नासरत खे फिर चली गया. ");
INSERT INTO goj_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","अरु बच्चो बढतो. अरु ताकता लो होतो. अरु दिमाक से हुशार हुय गयो. अरु परमेश्वर को अनुग्रह वोक पर थो. ");
INSERT INTO goj_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","वोका माय-बाप हर साल फसह तिवार मे यरुशलेम खे जाता करता था. ");
INSERT INTO goj_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","जब वू बारा साल को हुयो. ते वे तिवार की रीती जसो यरुशलेम मे गया. ");
INSERT INTO goj_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","अरु जब वू वे दिन खे पूरा करीखे पलट्यो. ते वु बेटा यीशु यरुशलेम मे र्हिगो. अरु यो वोकी माय-बाप नी जानता था. ");
INSERT INTO goj_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","वु यो समझी खे. कि वु अरु जान आला, सात हुये. एक दिन, जान आला कासात गइ अरु वोखे अपना कुटुब से अरु जान पहचान मे ढूढन लग्या. ");
INSERT INTO goj_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","पर जब नी मील्यो, ते ढुढते-ढुढते यरुशलेम के फेर पलटी गया. ");
INSERT INTO goj_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","अरु तीन दिन का बाद उनने वा मन्‍दिर मे यहूदीया शिक्षकहोन का बीच मे बठ्या. वो की सुनते अरु उनका से प्रश्‍न करते हुयो देख्यो. ");
INSERT INTO goj_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","अरु जोतना वोकी सुनी राथा. वे सब वोकी समझ अरु वोका उत्तर से चकित था. ");
INSERT INTO goj_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","जब वे वोखे देखी खे चकित हुया अरु वो की माय ने वोखे बोल्यो. हे बेटा. तु हमारा से क्‍यु असो व्‍यव्हार करस? देख. तरो बाप अरु मी मेहनत से तोखे ढूडता था. ");
INSERT INTO goj_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","वोने वुन, से बोल्यो. तुम मेखे क्‍यु ढूडता था? कानी जानता था. कि मेखे अपना बाप, भवन मे र्हेनो जरुरती हइ? ");
INSERT INTO goj_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","पर जो बात वोने ओकासे बोली. उनने वोखे नी समज्या. ");
INSERT INTO goj_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","पर जो उत्तर उनखे दियो,वे अरु व्हा उनका सात गयो. अरु नासरत मे आयो, अरु उनका आज्ञा को पालन करण लग्या. अरु वोकी माय ने या सब बात अपना मन मे रखी. ");
INSERT INTO goj_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","अरु यीशु दिमाक अरु डील डौल मे अरु परमेश्वर अरु इन्सान, अनुग्रह मे बढतो गयो. ");
INSERT INTO goj_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","तिबिरियुस कैसर, राज्य, 15 साल मे जब फिलिप्पुस पिलातुस यहूदीया को थो. अरु गलील मे हेरोदेस नाम चौथाइ को इतूरैया. अरु त्रखोनीतिस मे. ओको भैइ फिलिप्‍पुस. अरु अबिलेने मे लिसानीयास चौथाइ को राजो थो. ");
INSERT INTO goj_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","अरु जब हन्ना अरु कैफा महायाजक था. वा टेममे परमेश्वर को वचन जंगल मे जकर्याह को बेटो यहून्ना को पास पहुच्यो. ");
INSERT INTO goj_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","अरु वू यरदन, आस पास सब देस मे अयखे. पाप की माफी, लिये मन फिराव की बपतिस्मा को प्रचार करण लग्यो. ");
INSERT INTO goj_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","जसो यशायाह भविष्यव्दक्ता, बोल्यो आलो वचन की किताब मे लिख्योस हइ. कि जंगल मे एक फुकारन आला की आवाज अय रिस हइ कि परमेश्वर की रस्ता तैयार करी. की सडक सीधी बना. ");
INSERT INTO goj_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","हर एक खाइ भर दियो जाह्ये. अरु हर एक टेकडा अरु टेकडो सपाट कर्‍यो जाह्ये. अरु जो टेडो हइ सीधो. अरु जो उच्चो आलाखे नीच्चे अरु सीधी रस्ता बनाहे. ");
INSERT INTO goj_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","अरु हर परमेश्वर, उध्दार खे देख्ये. ");
INSERT INTO goj_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","जो बडी गर्दी ओकासे बपतिस्मा लेन खे नीकली खे आती थी. उनसे वु बोलतो थो. हे साप खे बच्‍चा. तुमखे कोने बतय दियो. कि आन आला घुस्सा से भागो. ");
INSERT INTO goj_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","अरु मन फिराव, अच्छो फल लाव अरु अपना स मन मे या नवी सोच. कि हमारो बाप अब्राहम आय. क्‍युकि मी तुमा से बोलुस. कि परमेश्वर यो पत्‍थर से अब्राहम, लिये सन्‍तान परदा करी सकस हइ. ");
INSERT INTO goj_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","अरु आब या कुल्‍हाडी झाड की जडी पर धरीस हइ. येका लीये जो झाड अच्छो फल नी लगे. वु ,ट्यो अरु अंगार मे डाल्यो जाह्ये हइ. ");
INSERT INTO goj_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","अरु दुन्या ने वोखे पूछ्यो. ते हम का करा? ");
INSERT INTO goj_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","वोने ओखे उतर दियो. कि जेका पास दो कुर्ता हइ? व्हा ओका सात जेका पास नी हइ बाटी दे अरु जेका पास खानो हुये. वू भी असो करणु. ");
INSERT INTO goj_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","अरु पैसालेनआलो भी बपतिस्मा लेन आय. अरु ओकासे पूछ्यो. कि हे गुरु. हम का करा? ");
INSERT INTO goj_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","वोने उनका से बोल्यो. जो तुम्‍हारा लिये रोखो गयोस हइ. ओकासे जादा नी लेनु. ");
INSERT INTO goj_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","अरु सैनीक ने भी ओकासे यो पूछ्यो. हम, करा? ओने ओका से बोल्यो. कोय, पर जबरदस्ती नी करणु. अरु ना झूटो दोष लगानु. अरु अपनी मजुरी पर खुश र्हेनु. ");
INSERT INTO goj_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","जब दुन्या आस लगाया हुया था. अरु सब अपना अपना मन मे यहून्ना को बारे मे बिचार करी राथा. कि का यो मसीह तो नी आय. ");
INSERT INTO goj_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","ते यहून्ना ने वे सब को उत्तर मे बोल्यो: कि मी तो तुमखे पानी से बपतिस्मा देस हय. पर वु आनआलो हइ. जो मरा से ताखतआलो हइ. मी तो यो योग्य भी नी. कि वोकी जुता की तन्नी खोली सकू. वु तुमखे पवित्र आत्‍मा अरु अंगार से बपतिस्मा दिह्ये. ");
INSERT INTO goj_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","ओको सुपडो. ओका हात मे हय. अरु वु अपनी अच्छी तराह से सपा कर्हे. अरु गहु खे अपना पोता मे जमा कर्हे. पर भूसो खे वा अंगार मे जो बुझन की नी जलय दिहे. ");
INSERT INTO goj_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","अरु वू खुप सी सजा दि दिखे दुन्या खे खबर सुनातो र्हियो. ");
INSERT INTO goj_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","पर ओने चौथाइ देस को राजो हेरोदेस खे ओको भैइ फिलिप्‍पुस की लुगइ हेरोदियास, बारेमे. अरु सब बुरो काम , बारेमे जो वोने कर्यो थो. दोष दियो. ");
INSERT INTO goj_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","येका लीये हेरोदेस ने वे सब से बडीखे यो बुरोकाम भी कर्यो. कि यहून्ना खे बन्दीगृह मे डाली दियो. ");
INSERT INTO goj_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","जब सब दुन्या ने बपतिस्मा लीयो. अरु यीशु भी बपतिस्मा लीखे प्रार्थना करी राथा. ते बद्दल खुली गयो. ");
INSERT INTO goj_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","अरु पवित्र आत्‍मा आंग रुप मे कबूतर, जसो वोका पर उतरते. अरु या आकाशवाणी हुय. कि तू मरो लाड बेटो आय. मी तरा से प्रसन्‍न हुयो. ");
INSERT INTO goj_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","जब यीशु खुद उपदेस करण लग्यो. ते नजीकपास तीस साल की उमर को थो अरु जसो समझ्यो जातो थो यूसुफ को बेटो थो. अरु एली को. ");
INSERT INTO goj_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","अरु वू मत्तात को, अरु वू लेवी को, अरु वू मलकी को, अरु वु यन्‍नाई को, अरु वु यूसुफ का. ");
INSERT INTO goj_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","अरु वू मत्तित्याह को, अरु वू आमोस एस्ली को, अरु वू नहूम को, अरु वू असल्‍याह को, अरु वू नोग्गइ को, ");
INSERT INTO goj_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","अरु वू मात को, अरु वू मत्तित्‍याह को, अरु वू शिमी को, अरु वू योसेख को, अरु वू योदाह को, ");
INSERT INTO goj_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","अरु वू यूहन्‍ना को अरु वू रेसा को, अरु वू जरुब्बाबेल को, अरु वू शालतीएल को, अरु वू नेरी को, ");
INSERT INTO goj_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","अरु वू मलकी को, अरु वू अद्दी को, अरु वू कोसाम को, अरु वू इलमोदाम को, अरु वू एर को, ");
INSERT INTO goj_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","अरु वू यीशु को, अरु वू इलाजार को, अरु वू योरीम को, अरु वू मत्तात को, अरु वू लेवी को, ");
INSERT INTO goj_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","अरु वू शमौन को, अरु वू यहूदा को, अरु वू यूसुफ को, अरु वू योनान को, अरु वू एलयाकीम को, ");
INSERT INTO goj_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","अरु वू मलेआह को, अरु वू मीन्‍नाह को, अरु वू मत्तात को, अरु वू नातान को, अरु वू दाउद को, ");
INSERT INTO goj_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","अरु वू यिशय को, अरु वू ओबेद को, अरु वू बोआज को, अरु वू सलमोन को, अरु वू नहशोन को, ");
INSERT INTO goj_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","अरु वू अम्‍मीनादाब को, अरु वू अरनी को, अरु वू हिस्रोन को,अरु वू पेरेस को, अरु उ यहूदा को ");
INSERT INTO goj_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","अरु वू याकूब को, अरु वू इसहाक को, अरु वू अब्राहम को, अरु वू तिरह को, अरु वू नाहोर को, ");
INSERT INTO goj_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","अरु वू सरुग को, अरु रऊ को अरु वू पेलेग को, अरु वू एबिर को, अरु वू शिलह को, ");
INSERT INTO goj_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","अरु वू केनान को, वू अरफक्षद को, अरु वू शेम को, वू नूह को, वू लेमेक को, ");
INSERT INTO goj_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","अरु वू मथूशिलह को, अरु वू हनोक को, अरु वू यिरिद को, अरु वू महललेल को, अरु वू केनान को, ");
INSERT INTO goj_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","अरु वू इनोश को, अरु वू शेत को, अरु वू आदम को, अरु वू परमेश्वर को बेटो थो. ");
INSERT INTO goj_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","फिर यीशु पवित्र आत्‍मा से भर्यो हुयो. यरदन मे पलट्यो. अरु चालीस दिन तक आत्मा खे सिखान खे जंगल मे फिरते र्हीयो. ");
INSERT INTO goj_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","अरु चालीस रात तक सैतान ने उनकी परीक्षा करतो र्हेयो वे दिन मे वो ने कुछ नी खायो अरु जब वे दिन पूरा हुय गया. ते ओखे भूख लगी. ");
INSERT INTO goj_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","अरु सैतान ने ओका से बोल्यो. “अगर तू परमेश्वर को बेटो हइ. ते यो फतर से बोल्यो कि रोटी बनी जाह्ये.” ");
INSERT INTO goj_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","यीशु ने वोखे उत्तर दियो. कि लिखस हइ. इन्सान फक्त रोटी से जिन्दो नी र्हेन को. ");
INSERT INTO goj_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","जब सैतान वोखे ली गयो अरु वोखे जरा भर मे जगत का सब राज्य बताह्ये. ");
INSERT INTO goj_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","अरु ओका से बोल्यो. मी यो सब अधिकार. अरु इन को वैभव तोखे दिह्यु. क्‍युकी वु मेखे सोपी दियोस हइ अरु जो चाहुस हइ. ओका दि सकुस हइ. ");
INSERT INTO goj_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","येका लिये. अगर तू मेखे आराधना कर्हे. ते यो सब तरो हुइ जाह्ये. ");
INSERT INTO goj_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","यीशु ने वोखे उत्तर दियो. लिख्यो हइ. कि तू प्रभु अपनो परमेश्वर खे प्रणाम कर. अरु फक्त वो की उपासना कर. ");
INSERT INTO goj_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","जब वोने वोखे यरुशलेम मे ली जय खे मन्‍दिर का छेडा पर खडो कर्या. अरु वोका से बोल्यो. अगर तू परमेश्वर को बेटो आय. ते अपना आप खे ह्या से नीच्चे गिरय दे. ");
INSERT INTO goj_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","क्‍युकी लिख्यो हइ. कि वु तरा बारे मे अपना स्वर्गदूत खे आज्ञा दिह्ये. कि वु तरी रक्षा कर्हे. ");
INSERT INTO goj_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","अरु वु तोखे हातो हात उठय लिहे असो नी होय कि तरा पाय मे फत्तर से ठोकर लग्हे. ");
INSERT INTO goj_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","यीशु ने ओका उत्तर दियो. यो भी बोल्यो गयोस हइ. कि तू प्रभु अपनो परमेश्वर की परिक्षा नी करणू. ");
INSERT INTO goj_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","जब सैतान सब परीक्षा करी चुक्यो. तब कुछ टेम का लिये वोका पास से चली गयो. ");
INSERT INTO goj_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","फिर यीशु आत्मा, सामर्थ्य से भर्‍यो गलील मे पलट्यो. अरु वोकी चर्चा आस पास, सब देस मे फैली गयो. ");
INSERT INTO goj_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","अरु उ वा मन्‍दिर मे शिक्षन करता र्हियो. अरु सब वोकि महिमा करता था. ओने यहूदीया आराधनालय मे उपदेश दिया अरु सब, द्वारा स्तुती हुइ. ");
INSERT INTO goj_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","अरु वू नासरत मे आयो. झा ओको पाल्यो पोसो हुयो थो. अरु अपनी रीति, जसो आराम, दिन आराधनालय मे जय खे पडन, लिये खडो हुयो. ");
INSERT INTO goj_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","यशायाह भविष्यव्दक्ता की किताब वोखे दी गय. अरु वोने किताब खोलीखे. वा जगा नी,ली झा यो लिख्यो थो. ");
INSERT INTO goj_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","कि परमेश्वर कि आत्मा मरा पर हइ. येका लिये कि वोने गरीब खे सुसमाचार सुनान, लिये मरो अभिषेक कर्यो हइ. अरु मेखे येका लिये भेज्यो हइ. कि भैइ को छुटकारा को अरु अन्‍धा खे दिखान , लीये खबर प्रचार कर्हे अरु कुचल्यो आला खे छुडाह्यु. ");
INSERT INTO goj_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","अरु परमेश्वर खे प्रसन्‍न र्हेन को साल खे प्रचार कर्यू. ");
INSERT INTO goj_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","जब वोने किताब बद करीखे सेवक, हात मे दि दि. अरु बठी गयो अरु आराधनालय, सब दुन्या कि नजर वोका पर लगी थी. ");
INSERT INTO goj_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","जब वु वुन से बोलन लग्यो. कि आज हि यो लेख तुमारा सामने पूरो हुयो हइ. ");
INSERT INTO goj_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","अरु सब ने वो खे प्रशसा. अरु जो अनुग्रह की बात वोका मेडा से नीकलती थी. वोका से अचम कर्यो. अरु बोलन लग्यो, यो यूसुफ को बेटो नी? ");
INSERT INTO goj_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","वोने ओकासे बोल्यो. तुम मरा पर यो खावत जरुरत बोल्हे. कि हे डॉक्टर. अपना आप खे अच्छो कर! जो कुछ हमने सुन्योस हइ कि कफरनहूम मे कर्यो गयोस हइ वोखे ह्या अपना देस मे भी कर. ");
INSERT INTO goj_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","अरु वोने बोल्यो. मी तुमारा से सच्ची बोलूस. कोय भविष्यव्दक्ता अपना देस मे मान-सम्‍मान नी मीले. ");
INSERT INTO goj_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","अरु मी तुम से सच्ची बोलूस. कि एलिय्याह, दिन मे जब साडे तीन साल तक बद्दल बद र्हीयो. ह्या तक कि सब देस मे बडो अकाल पड्यो. ते इस्राएल मे भोत विधवानहोन थी. ");
INSERT INTO goj_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","पन एलिय्याह वुन मे से कोय, पास नी भेज्यो गयो. फक्त सैदा, सारफत मे एक विधवा का पास. ");
INSERT INTO goj_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","अरु इलीशा भविष्यव्दक्ता, टेममे इस्राएल मे खुप सा कोढी था. पर नामान सूरयानी खे छोडी उन मे से कोय अच्छो नी कर्यो गयो. ");
INSERT INTO goj_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","ये बात सुनते मे जितने आराधनालय मे थो. सब घुस्सा भरी गया. ");
INSERT INTO goj_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","अरु उठीखे वु नगर से बाहेर नीकल्यो. अरु जो टेकडा पर वुन, नगर बसयो थो. वो की छेडा पर लीखे चल. कि वोखे व्हा से नीचे गिर्य दुव. ");
INSERT INTO goj_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","पन व्हा वुन, बीच मे से नीकलीखे चले गयो. ");
INSERT INTO goj_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","फिर वु गलील, कफरनहूम नगर मे गयो. अरु आराम, दिन दुन्या खे उपदेस दि रो थो. ");
INSERT INTO goj_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","वे वोका उपदेस से चकित हुय गया क्‍युकि वोको वचन अधिकार, सात थो. ");
INSERT INTO goj_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","आराधनालय मे एक इन्सान थो. जो मे बुरीआत्मा थी. ");
INSERT INTO goj_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","वु वुच्चो अवाज से चिल्‍लायो उट. हे यीशु नासरी. हमखे तरा से काम, तू हमारो नाश करण आयो हइ? मी तोखे जानुस तू कोन आय? तू प्रभु को पवित्र इन्सान आय. ");
INSERT INTO goj_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","यीशु ने वोखे धमकय खे बोल्यो. चुप र्हे अरु वोमे से नीकली जा तब बुरीआत्मा वा बीच मे भटकन का बिना कुछ कर्यो वो मे से नीकली गय. ");
INSERT INTO goj_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","येका पर सब खे अचम हुयो. अरु वे आपस मे बात करी खे बोलन लग्या. यो कसो वचन हइ? कि वु अधिकार अरु सामर्थ्य का अच्छा से सात बुरी आत्माहोन खे आज्ञा देस हइ, अरु वे नीकली जास हइ. ");
INSERT INTO goj_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","उ क्षेत्र मे आसपास का हर कोय ओका बारे मे समाचार फेलन लग्यो. ");
INSERT INTO goj_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","वु आराधनालय मे से उठीखे शमौन, घर मे गयो अरु शमौन की सासु खे बुखार चड्यो हुयो थो. अरु उनने वोका लिये वोका से प्रार्थना करी. ");
INSERT INTO goj_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","वोने वोका नजीक खडो र्हिखे बुखार खे डाट्यो अरु वोका पर से उतरी गयो अरु वा तुरुत उठीखे उन की सेवा चाकरी करण लगी. ");
INSERT INTO goj_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","सुरज डूबन, टेममे जेका जेका ह्या दुन्या अलग प्रकार की बीमारी मे पड्या हुया था. वे सब उनखे वोका पास ली आया. अरु वोने एक एक पर हात रखीखे वुनखे अच्छो कर्यो. ");
INSERT INTO goj_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","अरु बुरीआत्मा धमकय खे अरु यो बोलती हुये कि तू परमेश्वर को बेटो आय. खुपझन मे से नीकली गय पन वु वुनखे डाटतो अरु बोल नी देतो थो. क्‍युकी वे ओखे पहचानता था. कि यो मसीह आयो. ");
INSERT INTO goj_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","जब दिन नीकल्यो ते वु नीकली खे एक जंगल जगा मे गयो. अरु गर्दी की गर्दी वोखे ढूडते हुये वोका पास अय. अरु वोखे रोखन लगी. कि हमारा पास से नी जानू. ");
INSERT INTO goj_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","पन वोने उनका से बोल्यो. मेखे अरु नगर मे भी परमेश्वर को राज की सुसमाचार सुनानो जरुरती हइ. क्‍युकि मी येका लिये भेज्यो गयोस. ");
INSERT INTO goj_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","अरु वू गलील की आराधनालय मे प्रचार करते र्हीयो. ");
INSERT INTO goj_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","एक दिन जब गर्दी वोका पर गिर पडती थी. अरु परमेश्वर को वचन सुनती थी. अरु व्हा गनेसरत की नद्दी, किनार पर खडा था. ते असो हुयो. ");
INSERT INTO goj_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","कि वोने नद्दी, किनार दो डोंगा लग्या हुया देख्या. अरु डिम्बर वोका पर से उतरीखे जाल धोय रा था ");
INSERT INTO goj_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","वे डोंगा मे से एक पर जो शमौन की थी. चडी खे. वोने वोका से प्रार्थना करी. कि किनार से थोडो जमीन हटयी ले चल. जब व्हा बठीखे दुन्या खे डोंगा पर से उपदेस देन लग्यो. ");
INSERT INTO goj_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","तब वे बात करी चुक्या ते शमौन से बोल्यो. खोल मे ली चल. अरु मंछी पकडन का लिये अपनी जाल डाल. ");
INSERT INTO goj_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","शमौन ने वोखे उत्तर दियो. कि हे स्वामी. हम ने पुरी रात मेहनत करी अरु कुछ नी पकड्यो. तेभी तरा बोलना से जाल डाल्यु. ");
INSERT INTO goj_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","जब वुनने असो कर्या. ते खुप मंछी घेरी ली. अरु वुन कि जाल फटन लगी गी. ");
INSERT INTO goj_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","येका पर वो ने अपना साथआला खे जो दूसरा डोंगा पर था. हिसारो कर्यो. कि अयखे हमखे सात दे अरु वो ने अयखे. दो डोंगा ह्या तक भरी ली कि वे डूबन लगी. ");
INSERT INTO goj_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","यो देखीखे शमौन पतरस यीशु का पाय पर गिर्यो. अरु बोल्यो. हे परमेश्वर. मरा पास से जा. क्‍युकि मी पापी इन्सान आय. ");
INSERT INTO goj_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","क्‍युकि येत्ती मंछी खे पकड्यो जाना से वोखे अरु वोका साथआला खे खुप अचम हुयो. ");
INSERT INTO goj_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","अरु वसो य जब्दी को बेटो याकूब अरु यहून्ना खे भी. जो शमौन, सात मे था. अचम हुय जब यीशु ने शमौन से बोल्यो. मत डर आब से तू इन्सान खे जिन्दो पकड्‍यो कर्हे. ");
INSERT INTO goj_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","अरु वू डोंगा का किनार पर ली आयो अरु सब जमीन मे कुछ छोडी खे वोका पीछे चलि दियो. ");
INSERT INTO goj_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","जब वू कोय नगर मे थो. ते देख्यो. व्हा कोड से भर्यो हुयो एक इन्सान थो. अरु व्ह यीशु खे देखी खे मेडा, उपर गिर्यो. अरु प्रार्थना करी. कि हे परमेश्वर अगर तू चाह्ये ते मेखे अच्छो करी सकस हइ. ");
INSERT INTO goj_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","वो ने हात सामे करी खे वोखे पकड्यो अरु बोल्यो मी चाहुस की तू अच्छो हुय जा अरु वोको कोढ तुरुत अच्छो हुयो. ");
INSERT INTO goj_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","जब वो ने वोखे बतायो. कि कोय, से नी बोलनू. पर जय खे अपना आप खे याजक खे बता. अरु अपनो अच्छो होन, बारे मे जो कुछ मूसा ने चडावो ठयरायो हइ ओखे चडा. कि वुन पर गवइ हुये. ");
INSERT INTO goj_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","पन वो की चर्चा अरु भी फैलती गय. अरु बडी की गर्दी वो की सुनन, लिये अरु अपनी बिमारी से अच्छो होन, लिये जमा हुया. ");
INSERT INTO goj_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","पन वु जंगल मे अलग जयखे प्रार्थना कर्या करतो थो. ");
INSERT INTO goj_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","अरु एक दिन असो हुयो कि वु उपदेस दि रो थो. अरु फरीसी अरु व्यवस्थापक व्हा बठ्या हुया था. जो गलील अरु यहूदीया, हर एक गाव से. अरु यरुशलेम से आया था. अरु अच्छो करण, लिये परमेश्वर को सामर्थ्य वोका सात थो. ");
INSERT INTO goj_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","अरु देख कोय दुन्या एक इन्सान खे जो बिमारी को मारो हुयो थो. खटीया पर लयो. अरु वे वोखे अंदर ली जान अरु यीशु का सामने रखन को उपाय ढूडता था. ");
INSERT INTO goj_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","अरु तब गर्दीकरण वोखे अंदर नी लीजय सक्यो ते वुनने छपर पर चडी खे अरु कवेली अलग करी खे. वोखे खटीया सहीत बीच मे यीशु का सामने उतारी दियो. ");
INSERT INTO goj_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","वोने वुन को विश्वास देखीखे वोका से बोल्यो. हे इन्सान. तरा पाप माफ हुया. ");
INSERT INTO goj_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","जब शास्त्री अरु फरीसी वाद विवाद करण लग्या. कि यो कोन आय. जो परमेश्वर की नीन्दा करस हइ? परमेश्वर खे छोडी कोन पाप की माफी करी सकस हइ? ");
INSERT INTO goj_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","यीशु ने वुन, मन की बात जानीखे. वुन से बोल्यो कि तुम अपना मन मे, वाद विवाद करी रास हइ? ");
INSERT INTO goj_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","सोपो का हइ? का यो बोलनु. कि तरो पाप माफ हुया. या यो बोलनु कि उट. अरु धुम फिर? ");
INSERT INTO goj_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","पन येका लिये कि तुम जान कि इन्सान को बेटो खे जमीन पर पाप की माफ करण को भी अधिकार हइ वो ने वु बिमार को मारा हुया से बोल्यो. मी तरा से बोलूस. उट अरु अपनी खटीया उठइ खे अपना घर मे जा. ");
INSERT INTO goj_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","वु तुरुत उनका सामने उठा. अरु जोका पर वु पड्यो थो वोखे उठइ खे. प्रभु की महिमा करतो हुयो अपना घर चली गयो. ");
INSERT INTO goj_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","जब सब अचम्भा हुया अरु प्रभु की महिमा करण लग्यो. अरु खुप डरीखे बोलन लग्या. कि आज हम ने नवी बात देखीस हइ. ");
INSERT INTO goj_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","अरु येका बाद व्हा बाहेर गयो. अरु लेवी नाम एक पैसा लेनवालो खे चुगी की चौकी पर बठ्यो देख्यो. अरु वोका से बोल्यो. मरा पीछे चल. ");
INSERT INTO goj_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","जब व्हा सब कुछ छोडी खे उट. अरु वोका पीछे चल दिया. ");
INSERT INTO goj_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","अरु लेवी ने अपना घर मे वोका लिये बडी मेजवानी करी. अरु चुगी लेनआला अरु दुसरा तरप की जो वोका सात खान खे बठ्या था एक बडी गर्दी थी. अरु ओका पिछे अयगा था, ");
INSERT INTO goj_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","अरु फरीसी अरु वु, शास्त्री वुन का सेवक से यो बोलीखे कुरकुर लग्या. कि तु चुगी लेनवाला अरु पापी, सात क्‍यु खास-पीस हइ? ");
INSERT INTO goj_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","यीशु ने वु खे उत्तर दियो. कि डॉक्टर अच्छा कपडा, लिये नी पन बीमार का लिये जरुरती हइ. ");
INSERT INTO goj_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","मी धर्मीहोन खे नी. पन पापी खे मन फिराव का लिये बुलान आयोस. ");
INSERT INTO goj_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","अरु वुन ने वोका से बोल्यो. यहून्ना को सेवक ते बरोबर उपास रखस अरु प्रार्थना कर्या करस हइ. अरु वोसो य फरीसीहोन का भी. पन तरा सेवक तो खास पीस हइ. ");
INSERT INTO goj_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","यीशु ने वु से बोल्यो, तुम बरात से जब तक दुलो वुन, सात र्हेस. उपास करी सकस. ");
INSERT INTO goj_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","पन वे दिन आह्ये. जिन मे दुलो वुन से अलग कर्यो जाह्येय. जब वे वु दिन मे उपास कर्हे. ");
INSERT INTO goj_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","वो ने एक अरु दृष्‍टान्‍त भी वुन से बोल्यो. कि कोय इन्सान नवा कपडा मे से फाडीखे जुनो कपडा मे थेगडो नी लगाय. नी ते नवा फटी जाह्ये अरु व्हा थेगडो जुनो मे, बराबर भी नी खाय. ");
INSERT INTO goj_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","अरु कोय नवा अंगूर को रस जुना मडका मे नी भर्हेते. नी ते नवो अंगूर को रस नवा मडका खे फोडीखे बोहय जाह्ये. अरु मडको भी फुटी जाह्ये. ");
INSERT INTO goj_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","पन नवा अंगूर को रस नवा मडका मे भरनो चाह्ये. ");
INSERT INTO goj_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","कोय इन्सान जुना अंगूर को रस पीखे नवो नी चाहतो क्‍युकि व्हा बोलस हइ. कि जुनो ही अच्छो हइ. ");
INSERT INTO goj_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","फिर आराम का दिन व्हा खेत मे से हुयखे जयरा था. अरु ओका सेवक गहु कि उम्बी तोड तोडी खे. अरु हात से रगडी खे खाते जयरा था. ");
INSERT INTO goj_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","जब फरीसीहोन मे से कोय एक बोलन लग्यो. तुम व्हा काम क्‍यु करस हय जो आराम का दिन करणो अच्छो नी? ");
INSERT INTO goj_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","यीशु ने उन को उत्तर दियो “ का तुम ने यो नी पढ्यो. कि दाउद ने जब व्हा अरु ओका सात भूखा थो ते, कर्यो? ");
INSERT INTO goj_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","व्हा क्‍युकी परमेश्वर का घर मे गयो. अरु मीली की रोटि लिखे खैइ जो खानो याजक खे छोडी अरु कोय खे अच्छो नी अरु अपना सातआला खे भी दी.” ");
INSERT INTO goj_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","अरु वो ने वुन से बोल्यो. इन्सान को बेटो अराम को दिन को भी प्रभु हइ. ");
INSERT INTO goj_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","अरु असो हुयो कि कोय अरु एक दुसरो अराम को दिन खे व्हा आराधनालय मे जयखे उपदेस करण लगयो. अरु व्हा एक इन्सान थो. जोको जवनो हात सूख्यो थो. ");
INSERT INTO goj_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","शास्त्री अरु फरीसी होन पर दोस लगान को अवसर ढुडन का लिये वो की ताक मे था. कि देखे कि व्हा पवित्र का दिन अच्छो करतो हइ कि नी. ");
INSERT INTO goj_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","पन व्हा वुनका बिचार जानतो थो. येका लिये वोने से हाथआला इन्सान से बोल्यो. उट का बीच मे खडो हो व्हा उठी खे खडो हुयो. ");
INSERT INTO goj_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","यीशु ने वुन से बोल्यो. मी तुम से यो पूछुस कि आराम, दिन, अच्छो हइ. अच्छो करणो या बुरो करणो. जान खे बचानो कि नास करणो? ");
INSERT INTO goj_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","अरु वोने चारी तरप वे सब खे देखीखे वु इन्सान से बोल्यो. अपनो हात बडा वो ने असो य कर्यो. अरु ओको हात फिर अच्छो हुइ गयो. ");
INSERT INTO goj_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","पर वे खुद से बाहेर हुयखे आपस मे वाद विवाद करण लग्या कि हम यीशु का सात कर्ये? ");
INSERT INTO goj_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","अरु वे दिन मे एक टेकडा पर चढी खे प्रार्थना करण खे नीकल्यो. अरु प्रभु से प्रार्थना करण मे पुरी रात बिताय. ");
INSERT INTO goj_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","जब दिन नीकल्यो. ते वो ने अपना सेवकहोन खे बुलाय वुन मे से बारा खे चुनी लियो. अरु वुन खे प्रेरित बोल्यो. ");
INSERT INTO goj_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","अरु वे यो हइ शमौन जोको नाम वोने पतरस भी रख्यो. अरु वोको भैइ अन्द्रियास अरु याकूब अरु यहून्ना अरु फिलिप्पुस अरु बरतुल्मै. ");
INSERT INTO goj_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","अरु मत्ती अरु थोमा अरु हलफइस को बेटो याकूब अरु शमौन जो जेलोतेस बोल्‍यो जास. ");
INSERT INTO goj_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","अरु याकूब को बेटो यहूदा अरु यहूदा इस्करियोती. जो वोको पकडवानो बन्हे. ");
INSERT INTO goj_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","जब यीशु टेकडा पर से नीच्चे उतरीखे पिलेन जगा मे खडो हुयो. अरु वो का सेवक की बडी गर्दी. अरु सब यहूदीया अरु यरुशलेम अरु सूर अरु सैदा का समुद्र का किनार से भोत सारा दुन्या. जो वो की सुनन अरु अपनी बीमारी से अछा होन, लिये वोका पास आया थो. व्हा थो. ");
INSERT INTO goj_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","जो उनकी सुनन अरु अपनी बीमारीहोन से अच्छो होन, लिये ओका नजीक आया था, व्हा था अरु जो बुरी आत्मा का सताया हुया दुन्‍या भी अच्छो कर्यो जातो थो. ");
INSERT INTO goj_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","अरु सब वोखे पकडनो चाहता था. क्‍युकि वोमे से सामर्थ्य नीकली खे सब खे अच्छो करतो थो. ");
INSERT INTO goj_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","जब वोने अपना सेवक का तरप देखीखे बोल्यो. धन्‍य हय तुम. जो गरीब हय. क्‍युकि परमेश्वर स्वर्ग को राज तुम्‍हारो हइ. ");
INSERT INTO goj_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","धन्‍य हइ तुम. जो तु भूखो हय. क्‍युकि तृप्‍त कर्यो जाह्ये. धन्‍य हय तुम. जो तु रोवस हय. क्‍युकि हास्ये. ");
INSERT INTO goj_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","धन्‍य हइ तुम. जब इन्सान को बेटा का कारण दुन्या तरो से अलग कर्हे. अरु तुमखे नीकाली दिहे. अरु तरी मजाक कर्हे. अरु तरो नाम बुरो जानीखे काटी दिह्ये. ");
INSERT INTO goj_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","वु दिन खुशी हुय खे उछल्यो. क्‍युकि देख. तरा लिये स्वर्ग मे बडो प्रतीफल हइ वुन को बाप-दादा भविष्यव्दक्ता का सात भी अलग मे कर्यो करतो थो. ");
INSERT INTO goj_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","पर तरा पर. जो लकपती हइ. क्‍युकि तुम अपनी सब सुख मीली हय. ");
INSERT INTO goj_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","हय तुम पर. जो आब तृप्‍त हो. क्‍युकि भूखा हुये हय. तुम पर. जो आब हासस हो. क्‍युकि दुख कर्हे अरु रोहे. ");
INSERT INTO goj_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","तुम खे धिक्कार हय. तुमरी प्रससा हुये क्‍युकि उनका बापदादा ने भी पर जब सब इन्सान तुम खे अच्छो बोल्हे, क्‍युकि वुन, बापदादा झूटो भविष्यव्दक्ता का सात भी असो य कर थो. ");
INSERT INTO goj_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","पन मी तुम सुननवाला से बोलुस हय, कि अपना दुसमन से प्रेम रख. जो तुम से अलग कर्हे. वुन को अच्छो कर. ");
INSERT INTO goj_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","जो तुमखे श्राप दे, वुन खे आशिर्वाद दे जो तुम्‍हारो अपमान कर्हे. वुनका लिये प्रार्थना कर. ");
INSERT INTO goj_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","जो तरा एक गाल पर थप्‍पड मार्हे वोका तरप दूसरो भी पलटय दे. अरु जो तरी डबल छुड ली. वो को कुर्ता लेना से भी नी रोखनु. ");
INSERT INTO goj_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","जो कोय तरा से माग्हे. वोखे दे. अरु तरा से कोय कुछ माह्येका ते वापीस नी मागनू. ");
INSERT INTO goj_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","अरु जसो तुम चाहस हय कि इन्सानहोन तुम्‍हारा सात कर्हे. तुम भी वुन, सात वसो कर. ");
INSERT INTO goj_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","अगर तुम अपना प्रेम रखनवाला, सात प्रेम रख. ते तुम्‍हारी का महिमा? क्‍युकि पापी भी अपना प्रेम रखनवाला का सात प्रेम रखस हइ. ");
INSERT INTO goj_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","अरु अगर तुम अपनो अच्छो करणवालो येका सात अच्छो करस हय. ते तुम्‍हारी का महिमा? क्‍यु पापी भी असो करस हइ. ");
INSERT INTO goj_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","अरु अगर तु वोको उधार दे. जिन से फिर मीलन की आस रखस हय. ते तुम्‍हारी का महिमा? क्‍युकि पापी पापी खे उधार देस हइ. कि ओतनो ही फिर मील्हे. ");
INSERT INTO goj_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","पन अपनो दुशमन से प्रेम रख. अरु अच्छो कर अरु फिर मीलन की आस नी रखनु उधार दे. अरु तुम्‍हारा लिये बडो फल हुये. अरु तुम बडो इन्सान को बेटो रख्यो. क्‍युकि व्हा वुन पर जो धन्‍यवाद नी कर्‍हे अरु बुरो पर भी कृपा हइ. ");
INSERT INTO goj_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","जसो तुम्‍हारो बाप दयावान हइ. वसो य तुम भी दयावान बनू. ");
INSERT INTO goj_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","दोष मत लगा. ते तुम पर भी दोष नी लगाह्ये जाह्ये दोषी ने ठयरायो. ते तुम भी दोषी नी ठयरायो जाह्ये माफ कर. ते तुम्‍हारा भी माफ कर्यो जाह्ये. ");
INSERT INTO goj_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","दिया करणु. ते तुमखे भी दियो जाह्ये दुन्या पूरो माप दबय दबय खे अरु हलय? खे अरु बडते हुये तुम्‍हारा खोरा मे डाल्हे. क्‍युकि जो नाम से तुम मोज्हे हय. वोका से तुम्‍हा लिये भी मोज्यो जाह्ये. ");
INSERT INTO goj_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","फिर वोने वोका से एक दृष्‍टान्‍त बोल्यो, अन्‍धा को अन्‍धा खे रस्ता बतय सकस हइ? का दो गडा मे नी गिर्हे? ");
INSERT INTO goj_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","सेवक अपनो गुरु से बडो नी. पन जो कोय सिद्ध हुये. व्हा अपनो गुरु, बराबर हूये ");
INSERT INTO goj_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","तू अपना भैइ, आख को छोटो कचरो क्‍यु देखस हइ. अरु अपना य आख को लाकडी तोखे नी दिखे? ");
INSERT INTO goj_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","अरु जब तू अपना य आख को लाकडी नी देखस. ते अपनो भैइ से क्‍यु बोली सकस हइ. अरे भैइ. रुखी जा तरा आख से कचरो खे नी,ली दिव? हे कपटि. पहिले अपना आख से लाकडी निकाले. तब जो कचरो तरा भैइ, आख मे हइ. अच्छी तरासे देखीखे नीली सकस. ");
INSERT INTO goj_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","कोय अच्छो झाड नी. जो बुरो फल लाल्हे. अरु नी ते कोय बुरो झाड हइ. जो अच्छो फल लायो. ");
INSERT INTO goj_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","हर एक झाड अपनो फल से पहचान्यो जास हइ. क्‍युकि दुन्या झाड से अंजीर नी तोडनू. अरु नी बोयाबिज बेल से अंगूर. ");
INSERT INTO goj_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","अच्छो इन्सान अपनो मन, भर्यो भण्‍डार से अच्छी बात नी,लस हइ. अरु बुरो इन्सान अपना मन, बुरो भण्‍डार से बुरी बात नीकालस हइ. क्‍युकि जो मन मे भर्यो हइ उ वोका मेडा पर आस हइ. ");
INSERT INTO goj_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","जब तुम मेरो बोलनो नी मानस. तो क्‍यु मेखे हे प्रभु. हे प्रभु. बोलस हय? ");
INSERT INTO goj_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","जो कोय मरा पास आस हइ. अरु मरी बात सुनीखे वोखे मानास हइ. मी तुमखे बतास हइ कि वू कोय, बराबर हइ? ");
INSERT INTO goj_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","व्हा वु इन्सान का समने हइ. जेने घर बनान, टेममे भूय खोल खोदी खे फतर की पय्यो डाली. अरु जब बडो अय तो धार वु घर पर लगी. पन ओखे हलय न सकी. क्‍युकि उ पक्को बन्यो था. ");
INSERT INTO goj_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","पन जो सुनीखे नी बराबर. व्हा वु इन्सान का जसो हइ जेने मट्टी का पय्यो पर घर बनायो. जब वोका पर पाणी लग्यो ते वु तुरुत गिरी पड्यो. अरु गिरीखे सत्‍यानास हुय गयो. ");
INSERT INTO goj_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","जब उ दुन्या से या सब बात बोली चुक्यो. ते कफरनहूम मे आयो. ");
INSERT INTO goj_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","व्हा कोय सुबेदार को एक सेवक जो वोको प्रेम मे थो. बीमारी से मरना पर थो. ");
INSERT INTO goj_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","वोने यीशु की बातचित सुनीखे यहूदीयाहोन का कोय बापदादा इन्सान खे उन से ह्या प्रार्थना करण खे वोका पास भेज्यो. कि अयखे मरा सेवक खे अच्छो कर. ");
INSERT INTO goj_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","वे यीशु का पास आया ओका से बडी प्रार्थना करीखे बोलन लग्यो. कि वु यो योग्य हइ. कि तू वोका लिये ह्या कर्हे. ");
INSERT INTO goj_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","क्‍युकि वु हमारो राष्ट्र से प्रेम रखस हइ. अरु वोनेय हमारी आराधनालय खे बनयस हइ. ");
INSERT INTO goj_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","यीशु ओका सात सात चल पर जब वु घर से दूर नी थो. ते सेनापति ने वोका पास कोय दोस्त का वजेसे बोलन भेज्यो. कि हे प्रभु दुख मत उठा क्‍युकि मी यो योग्य नी. कि तू मरी छाय का तल्ले आह्ये. ");
INSERT INTO goj_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","यो करण मेने अपना आप खे यो योग्य भी नी समझ्यो कि तरा पास अवु. पर वचन मे बोली देस ते मरो सेवक अच्छो हुय जाह्ये. ");
INSERT INTO goj_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","मी भी दुसरा को अधिकार इन्सान आय. अरु सिपय मरा हात मे हइ. अरु जब एक खे बोल्योस. जा. ते व्हा जास हइ. अरु दूसरा से बोलस कि आका तु आस हइ. अरु अपनो कोय सेवक खे कि यो कर. ते व्हा वोखे करस. ");
INSERT INTO goj_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","यो सुनीखे यीशु ने अचम कर्यो. अरु वोने मेडो पलटय खे वु गर्दी से जो वोका पीछे अय री थी बोल्यो. मी तुम से बोलुस. कि मेने इस्राएल मे भी असो विश्वास नी पायो. ");
INSERT INTO goj_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","अरु भेज्यो हुयो दुन्या ने घर पलटी खे. वु सेवक खे अच्छो पायो. ");
INSERT INTO goj_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","थोडा दिन का बाद व्हा नाइन नाम को एक गाव खे गयो. अरु वोको सेवक अरु बडी गर्दी वोका सात जय री थी. ");
INSERT INTO goj_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","तब व्हा गाव कि फाटक का पास पहुचो. ते देख. दुन्या एक मुडदा खे बाहेर लिये जय रो थो. जो अपनी माय को येकलो बेटो थो. अरु वा विदवा थी अरु नगर का खुप दुन्या वोका सात थी. ");
INSERT INTO goj_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","वोखे देखी खे परमेश्वर खे दया अयी. अरु वो ने बोल्यो. मत रोय. ");
INSERT INTO goj_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","जब वो ने पास अयखे. अर्थी खे पकड्यो. अरु उठानआला रुखी गया. जब वो ने बोल्यो. हे जवान. मी तरा से बोल्युस. उट. ");
INSERT INTO goj_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","जब वु मुडदा उठी खे बठ्यो. अरु बोलन लग्यो अरु वो ने वोखे वो की माय खे दि दियो. ");
INSERT INTO goj_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","येमे से सब पर डर छय गयो. अरु वु परमेश्वर की महिमा करीखे बोलन लग्यो कि हमारा बीच मे एक बडो भविष्यव्दक्ता उठ्यो हइ. अरु परमेश्वर ने अपना दुन्या पर कृपा दुष्‍टि करी हइ. ");
INSERT INTO goj_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","अरु वोका बारेमे मे यो बात सब यहूदीया अरु आस पास का सब देस मे फैली गय. ");
INSERT INTO goj_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","अरु यहून्ना खे वोका सेवक ने या सब बात कि खबर दि. ");
INSERT INTO goj_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","जब यूहन्‍ना ने अपना सेवक मे से दो खे बुलखे परमेश्वर का पास यो पुछन का लिये भेज्यो. आनवालो तू मे हइ. या हम कोय अरु दूसरा की रस्ता देखा? ");
INSERT INTO goj_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","वुन ने वोका पास अयखे बोल्यो. यहून्ना बपतिस्मा देनआला ने हम के तरा पास यो पुछन खे भेज्यो हइ. कि का आनवालो तू ही हइ. या हम दूसरा की रस्ता देखा? ");
INSERT INTO goj_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","वाच टेम वो ने भोत बीमार. अरु पीडा. अरु बुरीआत्‍मा से छुडायो. अरु भोत सा अन्‍धा खे आख दीया. ");
INSERT INTO goj_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","अरु वो ने वोका से बोल्यो. जो कुछ तुम ने देख्यो अरु सुन्योस. जयखे यहून्ना खे बोलीदे. कि अंन्धो देखस. लगडो चली फिरी सकस हइ. कोढी अच्छो कयो जास हइ. अरु गरीब खे सुसमाचार सुनायो जास हइ. ");
INSERT INTO goj_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","अरु धन्‍य हइ वु. जो मरा करण ठोकर नी खाय. ");
INSERT INTO goj_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","तब यूहन्‍ना खे भेज्यो हुयो दुन्या चली दिया. ते यीशु यहून्ना को बारे मे दुन्या खे बोलन लग्यो. तुम जंगल मेका देखन गया था? हवा से हलाते हुयो सरकण्‍डे खे? ");
INSERT INTO goj_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","ते तुम फिर, देखन गया था? नाजूक कपडा पेन्यो हुयो इन्सान खे? देख्यो. जो भडकीला कपडा पेन्यो अरु सुख चैन से र्हेस हइ, वे राजभवन मे र्हेस हइ. ");
INSERT INTO goj_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","ते फिर, देखन गयो थो? कोय भविष्यव्दक्ता खे? ह्या. मी तुम से बोलुस. वरन भविष्यव्दक्ता से भी बडा खे. ");
INSERT INTO goj_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","यो उ हइ. जोका बारे मे लिख्योस हइ. कि देख मी अपना दूत खे तरा आगे आगे भेजुस जो तरा आगे रस्ता सीधि कर्हे. ");
INSERT INTO goj_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","मी तुम खे बोलुस कि जो बयहोन से जन्म्यो हइ. उन मे से यहून्ना से बडो कोय नी पर जो परमेश्वर का राज्य मे छोटो से छोटो हइ. व्हा वोका से भी बडो हइ. ");
INSERT INTO goj_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","अरु सब साधारण दुन्या ने सुनीखे अरु चुगी लेनवाला ने भी यहून्ना को बपतिस्मा लिखे परमेश्वर खे सच्छो मानी लियो. ");
INSERT INTO goj_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","पर फरीसीयो अरु व्यवस्थापक ने वो खे बपतिस्मा नी लिखे परमेश्वर की मनसा का अपना बारे मे टाली दियो. ");
INSERT INTO goj_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","अरु मी यो जगत की दुन्या की उपमा कोय से दिव कि कोय का बराबर हइ? ");
INSERT INTO goj_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","वु वे बच्चा का बराबर हइ जो बजार मे बठ्यो हुयो एक दूसरा खे पुकारी खे बोलतो हइ. हम ने तुम्‍हारा लिये बासरी बजय. अरु तुम नी नाच्या. हम ने विलाप कर्यो. अरु तुम नी रोया. ");
INSERT INTO goj_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","क्‍युकि यहून्ना बपतिस्मा देनवालो नी रोटी खाते आयो, नी अंगूर को रस पीते आयो, अरु तुम बोलस हय, वो मे बुरीआत्मा हइ. ");
INSERT INTO goj_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","इन्सान को बेटो खाते पीते आयो हइ, अरु तुम बोलस हय, देख कावरो अरु दारु कुट्यो इन्सान. चुगी लेनवाला का अरु पापी को दोस्त. ");
INSERT INTO goj_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","पर ज्ञान अपना सब बच्चा से सही न्यायी र्ही गयो हइ. ");
INSERT INTO goj_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","फिर कोय फरीसी ने वोका से प्रार्थना करी. कि मरा सात खानो खा. अरु व्हा वो फरीसी का घर मे जयखे खानो खान बठ्यो. ");
INSERT INTO goj_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","अरु देख. वु गाव की एक पापी बय यो जानीखे कि व्हा फरीसी का घर मे खानो खान बठ्योस हइ. सगमरमर का वस्तु मे अत्रर लय. ");
INSERT INTO goj_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","अरु वोका पाय का पास पीछे खडी हुयखे. रोती हुय वोका पाय खे आसु से भिजान अरु अपना माथा खे बाल से पोछन लगी अरु वोक पाय का बार बार चूम्मो लिखे वु कापर अत्रर को तेल मल्यो. ");
INSERT INTO goj_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","यो देखीखे. व्हा फरीसी जेने वोखे बुलायो थो. अपना मन मे सोचन लग्यो. अगर यो भविष्यव्दक्ता होतो ते समजी जातो. कि यो जो वोखे पकडी री हइ. व्हा कोन अरु कसी बय हइ? क्‍युकि व्हा तो पाप नी हइ. ");
INSERT INTO goj_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","यो सुनी यीशु ने वोको उत्तर मे बोल्यो. कि हे शमौन मेखे तोरा से कुछ बोलनो हइ व्हा बोल्यो. हे गुरु बोल. ");
INSERT INTO goj_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","कोय साहुकार का दो कर्जदार थो. एक पाच सौव. अरु दूसरो पचास चादी का सिक्का धारतो थो. ");
INSERT INTO goj_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","तब कि वोका पास पलटान खे कुछ नी र्हियो. ते वो ने दो खे माफ करी दियो, अरु वो मे से कोन वोका से जादा प्रेम रखेय. ");
INSERT INTO goj_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","शमौन ने उत्तर दियो. मरी समज मे व्हा. जेका बडा पैसा माफ करी गयो. “तुमने बरोबर उत्तर दियो.” मसीह यीशु ने बोल्यो. ");
INSERT INTO goj_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","अरु वा बय का तरप फिरीखे वोने शमौन बोल्यो, तू या बय खे देखस हइ? मी तरा घर मे आयो पन तोने मरा पाय धोन, लिये पानी नी दियो. पर ये ने मरा पाय आसु से भिजया. अरु अपना बाल से पोछी दियो. ");
INSERT INTO goj_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","तो ने मेखे चूमो नी दियो. पर जब से मी आयोस तब से ये ने मरा पाय का चूमो नी छोड्यो. ");
INSERT INTO goj_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","तो ने मरा माथा पर तेल नी मल्यो. पर ये ने मरा पाय पर अत्रर मल्यो हइ. ");
INSERT INTO goj_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","येकालिये मी तरा से बोलुस, कि येका पाप जो खुप था, माफ हुया, क्‍युकि ये ने खुप प्रेम कर्यो, पर जोको थोडी माफ हुयोस, व्हा थोडो प्रेम करस हइ. ");
INSERT INTO goj_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","अरु वोने बय से बोल्यो, “तरा पाप माफ हुयो.” ");
INSERT INTO goj_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","जब जो दुन्या वोका सात खानो खान बठ्यो थो, वे अपना अपना मन मे सोचन लग्या, यो कोन आय जो पाप कि भी माफ करस हइ? ");
INSERT INTO goj_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","पर वोने बय से बोल्यो. तरा विश्वास ने तोखे बचय लियो हइ? शांती से जय जा. ");
INSERT INTO goj_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","येका बाद व्हा नगर नगर अरु गाव गाव प्रचार करते हुयो अरु प्रभु को राज की सुसमाचार सुनाते हुयो फिरन लग्यो ");
INSERT INTO goj_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","अरु वे बारा वोका सात था अरु केतनी बयहोन भी जो बुरीआत्माहोन से अरु बीमारीहोन से छुडाये गया थो अरु वे यो हइ मरियम जो मगदलीनी बोली थी जोमे से सात बुरीआत्‍माहोन नीकली थी ");
INSERT INTO goj_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","अरु हेरोदेस, भण्‍डारी खुजा की बायको योहन्‍ना अरु सूसन्‍नाह अरु खुप सी अरु बयहोन ये तो अपनी धन से वो की सेवा करती थी ");
INSERT INTO goj_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","तब बडी गर्दी जमा हुय अरु गाव गाव का दुन्या वोका पास चली आता था, ते वो ने दृष्‍टान्‍त मे बोल्योस: ");
INSERT INTO goj_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","कि एक बोन आलो बीज बोन नीकल्यो भोते हुयो कुछ रस्ता का किनार गिर्यो. अरु खोद्यो गयो. अरु बद्दल का पक्षिहोन ने वोखे चुनी लियो. ");
INSERT INTO goj_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","अरु कुछ फतर पर गिर्यो. अरु वुग्यो. पन पानी नी मीलना से सूखी गया ");
INSERT INTO goj_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","कुछ झाडि का बीच मे गिर्यो. अरु झाडि का सात सात बडीखे वोखे दबय दियो. ");
INSERT INTO goj_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","अरु कुछ अच्छी जमीन पर गिर्यो.अरु वुगी खे सौव गुणा फल आया ह्या बोलीखे वो ने वुचा आवाज से बोल्यो. जेका सुनन खे कान हुये वे सुनी ले. ");
INSERT INTO goj_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","ओका सेवक ने यीशु से “यो दृष्‍टान्‍त को मतलब पुछ्यो का हइ?” ");
INSERT INTO goj_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","यीशु ने बोल्यो, “तुम खे परमेश्वर को राज का रहस्यो को पडय तुम दुन्या खे दि गय हइ. पन दुसरा खे फक्त दृष्‍टान्‍त मील्हे. जोका से वे देखी खे भी नी देख्या अरु नी सुनीखे भी नी समज्या.” ");
INSERT INTO goj_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“दृष्‍टान्‍त को मतलब यो हइ बीज तो परमेश्वर को वचन हइ.” ");
INSERT INTO goj_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","रस्ता का किनार का गिर्या हुया बीज वे दुन्या हइ. जिनने सुन्‍यो. तब सैतान अयखे उनका मन मे से वचन उठय ली जास हय. कि खय असो नी होनु कि वे विश्वास करीखे उध्दार मील्हे. ");
INSERT INTO goj_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","चट्टान पर का वे हइ. कि जब सुनय हइ. ते खुशी से वचन खे स्वीकार करस हइ. पन जडी नी पकडना से वे थोडी देर तक विश्वास रखस हइ. अरु परीक्षा खे टेम भैइकी जास हइ. ");
INSERT INTO goj_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","जो झाडिहोन मे गिर्यो. यो वे हइ. जो सुनस हइ. पर आगे चली खे चिन्ता अरु दौलत अरु जिवन खे सुख-विलास मे फसी जास हइ. अरु उनको फल नी मील्हे. ");
INSERT INTO goj_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","पर अच्छी जमीन मे का वे हइ. जो वचन सुनीखे अच्छो अरु अच्छो मन मे सम्भाल्हे र्‍हेस हइ. अरु रुखी खे फल लास हइ. ");
INSERT INTO goj_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“कोय भी दिवो खे जलय खे नी ते ओखे बर्तन से झाकस हइ अरु नी ओखे खटीया का नीचे रखता आस हय पन ओखे दीव्वा पर रखस हइ कि घर मे आन खेनी पन दुन्या देखी सख्ये.” ");
INSERT INTO goj_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","कुछ लुक्योस नी. जो प्रगट नी होय. अरु नी कुछ लुक्यो हइ. जो जान्यो नी जाह्ये. अरु प्रगट नी होय. ");
INSERT INTO goj_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","येका लिये चतरो र्‍हे कि तुम कोय रीति से सुनस हुये? क्युकी जेका पास हइ. ओखे दियो जाह्ये. अरु जेका पास नी हइ. ओकासे उ भी ली लियो जाह्ये. जेखे उ अपनो समझस हइ. ");
INSERT INTO goj_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","ओकी माय अरु ओको भैइ नजीक आयो. पर गर्दी का कारण ओकासे मीली नी सक्या. ");
INSERT INTO goj_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","अरु ओकासे बोल्यो गयो. “तरी माय अरु तरो भैइ बाहेर खडो हुयो तरा से मीलनो चाहस हइ.” ");
INSERT INTO goj_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","यीशु ने ओखे उत्तर मे उनसे बोल्यो. “मरी माय अरु मरो भैइ ये य हइ. जो परमेश्वर को वचन सुनस अरु मानस हइ.” ");
INSERT INTO goj_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","फिर एक दिन वे अरु ओका सेवक डोंगा पर चेढ्या. अरु ओने उनका से बोल्यो. “आ. नद्दी का पार चल.” येका लिये उनने डोगो खोली दीयो. ");
INSERT INTO goj_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","पर जब डोगो चली रोथो. ते व्हा सोय गयो अरु नद्दी पर आधी अय. अरु डोंगा मे पानी से भरन लग्यो अरु वे आपत मे था. ");
INSERT INTO goj_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","तब उनने नजीक अयखे ओखे जगायो. अरु बोल्यो. “गुरुजी! हम नाश हुया जास हइ.” तब ओने उठीखे आधी खे अरु पानी की लाट खे धमकय अरु वे रुखी गयो. अरु चुप हुय गयो. ");
INSERT INTO goj_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","अरु उनने उनका से बोल्यो. “तुम्हारो विश्वास खा थो?” पर वे डरी गया. अरु अचम्बो हुयखे आपस मे बोलन लग्या. “यो कोन आय. जो आधी अरु पानी खे भी आज्ञा देस हइ. अरु वे ओकी बात मानस हइ?” ");
INSERT INTO goj_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","फिर वे गिरासेनीयहोन का देस मे पहुच्या. जो वा पार गलील का सामने हइ. ");
INSERT INTO goj_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","जब व्हा किनार पर उतर्‍यो ते जमीन उ नगर को एक इन्सान ओखे मील्यो. जोमे बुरीआत्मा थी. अरु भोत दिन से कपडा नी पेनतो थो अरु नी घर मे र्‍हेतो थो क्युकी मरगट मे र्‍हे तो थो. ");
INSERT INTO goj_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","वहा यीशु खे देखी खे चिल्लायो. अरु ओका सामने गिरीखे बडा आवाज से बोल्यो. “हे परमप्रधान परमेश्वर को बेटो यीशु! मेखे तरा से काम? मी तुम्हारा से प्रार्थना करुस हय. मेखे दुख नी देनु.” ");
INSERT INTO goj_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","क्युकी व्हा उस बुरी आत्मा खे उ इन्सान मे से नीकलन की आज्ञा दि रा था. येका लिये कि व्हा ओका पर घडी घडी प्रबल होती थी. अरु अगर दुन्या ओखे हतकडी मे अरु साकल से बाधता था. ते भी व्हा बाधी आला खे को तोडी डालतो थो. अरु बुरीआत्मा ओखे जंगल मे भगायो फिरता था. ");
INSERT INTO goj_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","यीशु ने ओकासे पूछा. “तरो का नाम हइ?” ओने बोल्यो. “सेना.” क्युकी खुप बुरीआत्माहोन ओमे टेम मे गइ थी. ");
INSERT INTO goj_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","अरु उनने ओकासे प्रार्थना की. “हमखे यानेकी गड्डा मे जान की आज्ञा नी दे.” ");
INSERT INTO goj_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","व्हा टेकडा पर डुक्कर को एक बडो धन चरी रोथो. अरु उनने ओकासे प्रार्थना करी. “हमखे उनका सामने दे.” अरु ओने उनखे जान दियो. ");
INSERT INTO goj_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","तब बुरीआत्माहोन उ इन्सान से नीकलीखे डुक्कर मे समा गय अरु उ धन पर से झपटी नद्दी मे जय गिर्‍यो अरु डूबी मर्‍यो. ");
INSERT INTO goj_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","चरानआलो यो जो हुयो थो देखीखे भाग्हे. अरु नगर मे. अरु गावहोन मे जयखे ओको खबर बोल्यो. ");
INSERT INTO goj_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","अरु दुन्या यो जो हुयो थो ओखे देखन खे निकाले. खे अरु यीशु का नजीक अय खे जो इन्सान से बुरीआत्माहोन नीकली थी. ओखे यीशु का पास कपडा पेन्या अरु सचेत बठयो हुयो मील्यो ते वे डरी गया. ");
INSERT INTO goj_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","अरु देखनवाला ने उनखे बतायो. कि व्हा बुरीआत्मा का सताया हुया इन्सान कोय रंग अच्छा हुया. ");
INSERT INTO goj_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","तब गिरासेनीयहोन का नजीक पास का सब दुन्या ने यीशु से प्रार्थना करी. कि हमारा ह्या से जय जा. क्युकी उनका पर बडो डर हुय गयो थो. अरु व्हा डोंगा पर चडीखे वापीस गया. ");
INSERT INTO goj_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","जो इन्सान से बुरीआत्माहोन नीकली थी व्हा ओकासे प्रार्थना करण लग्यो. कि मेखे अपना साथ र्‍हेन दे. पन यीशु ने ओखे बिदा करीखे बोल्यो. ");
INSERT INTO goj_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“अपना घर मे पलटी जा अरु दुन्या से बोली दे. कि परमेश्वर ने तरा लिये कसो बडो-बडो काम कऱ्योस हइ” व्हा सब नगर मे प्रचार करणे लगा. कि यीशु ने मरा लिये कसो बडो-बडो काम कर्‍यो. ");
INSERT INTO goj_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","जब यीशु पलटी रोथो. ते दुन्या ओकासे दुन्या खुसी का साथ मील्हे. क्युकी वे ओका सब उसकी प्रतीक्षा करी राथा. ");
INSERT INTO goj_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","अरु देख. याइर नाम एक इन्सान जो आराधनालय को मुखियो थो. आयो. अरु यीशु का पाय पर गिरीखे ओकासे प्रार्थना करणे लग्या. “मरा घर मे चल.” ");
INSERT INTO goj_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","क्युकी ओका बारा साल की एककुलती बेटी थी. अरु वा मरना पर थी. जब उ जय रो थो. तब दुन्या ओका पर गिरी गा. ");
INSERT INTO goj_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","अरु एक बय ने जेखे बारा साल से खुन बोहान की बिमारी थी अरु जो अपनी सब जिवन डाॅकटर का पीछे खर्चो कर चुक्या था अरु फिर भी कोय का हात से अच्छो नी हुय सकी थी. ");
INSERT INTO goj_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","पीछे से अयखे ओका कपडा को पदर खे छियो. अरु तुरुत ओको खुन बोहानो रुखी गयो. ");
INSERT INTO goj_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","येका पर यीशु ने बोल्यो. “मेखे कोने छियो?” जब सब मुकरण लग्या. ते पतरस अरु ओका सोपती ने बोल्यो. “हे स्वामी. तुमखे तो गर्दी दबय रीस हइ अरु तरा पर गिरी पडस हइ.” ");
INSERT INTO goj_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","पन यीशु ने बोल्यो. “कोय ने मेखे छियो हइ क्युकी मेने जानी लियोस हइ कि मरा मे से सामर्थ्य नीकलस हइ.” ");
INSERT INTO goj_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","जब बय ने देख्यो. कि मी लुकी नी सकु तब कापते हुयो आयो. अरु ओका पाय पर गिरीखे सब दुन्या का सामने बतायो. कि मेने कोय करण से तोखे छियो. अरु कसी तुरुत अच्छी हुय गयो. ");
INSERT INTO goj_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","ओने ओकासे बोल्यो. “बेटी तरो विश्वास ने तोखे अच्छो कर्‍योस हइ. शांती से चली जा.” ");
INSERT INTO goj_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","जब उ बोली रोथो. कि कोय ने आराधनालय को बुजुक का ह्या से अयखे बोल्यो. “तरी बेटी मरी गइ गुरु खे दुःख नी देनु.” ");
INSERT INTO goj_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","यीशु ने सुनीखे ओखे उत्तर दियो. “मत डरे. फक्त विश्वास रख. ते उ बची जाह्ये.” ");
INSERT INTO goj_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","घर मे अयखे ओने पतरस. अरु यहून्ना. अरु याकूब. अरु बेटा का माय बाप खे छोडी खे अरु कोय खे अपना सात अंदर आन नी दियो. ");
INSERT INTO goj_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","अरु सब ओका लिये रोय पीटी रा था. पन ओने बोल्यो. “रोय मत. वा मरी नी पन सोय रीस हइ.” ");
INSERT INTO goj_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","वे यो जानीखे कि मर गय हइ. ओकी हसी उडन लग्या ");
INSERT INTO goj_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","पन ओने ओका हात पकड्यो. अरु फुकारी खे बोल्यो “ओ बेटी उट!” ");
INSERT INTO goj_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","जब ओकि जान पलटी गयो अरु व्हा तुरुत उठी. फिर ओने आज्ञा दी. कि ओखे कुछ खान खे दियो जाह्ये. ");
INSERT INTO goj_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","ओकी माय-बाप चमकिगो हुयो. पन ओने उनने धम नो दी. कि यो जो हुयो हइ. कोय से नी बोल्यो. ");
INSERT INTO goj_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","फिर ओने बारा खे बुलय खे उनखे सब बुरीआत्माहोन अरु बीमारीहोन खे दूर करण की सामर्थ्य अरु अधिकार दियो. ");
INSERT INTO goj_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","अरु उनने परमेश्वर को राज को प्रचार करण. अरु बीमारी खे अच्छो करण का लिये बारा खे भेज्यो. ");
INSERT INTO goj_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","अरु ओने उनका से बोल्यो. “रस्ता, लिये कुछ नी लेनु नी ते लकडी. नी थैली. नी रोटी. नी पैसा अरु नी दो-दो कुर्ता.” ");
INSERT INTO goj_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","अरु जो कोय घर मे तुम उतर्‍यो. व्हा र्‍हेव. अरु व्हा से बिदा हुये. ");
INSERT INTO goj_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","जो कोइ तुमखे स्वीकार नी करण का ओखे उ नगर से नीकलते हुयो अपना पाय की धूलौ झाड डालो. कि उन पर गवाह हुये. ");
INSERT INTO goj_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","अरु वे नीकलीखे गाव-गाव सुसमाचार सुनाते. अरु हर एक दुन्या खे अच्छो करते हुयो फिरतो र्‍हे. ");
INSERT INTO goj_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","अरु देस को चौथोहिस्सो को राजो हेरोदेस यो सब सुनीखे घबरा गयो. क्युकी खे तना ने बोल्यो. कि यहून्ना मऱ्या हुया मे से जिन्दो उठनो हइ. ");
INSERT INTO goj_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","अरु खे तना ने यो. कि एलिय्याह दिखय दियो हइ अरु ने यो. कि जुन्नो भविष्यव्दक्ताहोन मे से कोय जिन्दो होनो हइ. ");
INSERT INTO goj_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","हेरोदेस ने बोल्यो. “यहून्ना खे तो खुद मे ने मार्‍यो थो फिर यो इन्सान कोन आय जोका बारेमे असी बात मी सुनीरोस हय?” अरु ओखे देखन की इच्छा करी. ");
INSERT INTO goj_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","फिर प्रेरितो ने वापीस जो कुछ उनने कर्‍यो थो. ओखे बताय दियो. अरु व्हा उनने अलग करीखे बैतसैदा नामक एक गाव खे लि गयो. ");
INSERT INTO goj_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","यो समजीखे गर्दी ओका पीछे चली दिया. अरु व्हा खुशी, सात ओकासे मील्यो. अरु उनका से परमेश्वर को राज की बात करण लग्या. अरु जो अच्छा होनो चाहतो थो. उनको अच्छो कर्‍हे. ");
INSERT INTO goj_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","जब दिन डुबन लग्यो. ते बारा ने अयखे ओकासे बोल्यो. “गर्दी खे बिदा करी. कि चारी तरप का गाव अरु बस्तिहोन मे जयखे अपना लिये र्‍हेन की जगा. अरु खाना को इनतजाम कर. क्युकी हम ह्या सुनसान जगह मे हइ.” ");
INSERT INTO goj_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","ओने उनका से बोल्यो. “तुम उनखे खान खे दे.” उनने बोल्यो. “दो सौ सिक्का, रोटि अरु दो मंछी खे छोडी खे अरु कुछ नी. पन ह्या. अगर हम जयखे ये सब दुन्या, लिये खानो मोल ली. तो सकस हइ.” ");
INSERT INTO goj_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","क्युकी व्हा पर नजीकपास पाच हजार दुन्या था. अरु उनने अपना सेवक से बोल्यो. उनखे पचास पचास करखे पगत मे बठय दे. ");
INSERT INTO goj_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","उनने असो य कर्यो. अरु सब खे बठय दियो. ");
INSERT INTO goj_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","तब ओने वे पाच रोटि अरु दो मंछी ली. अरु स्वर्ग का तरफ देखीखे धन्यवाद कर्यो. अरु तोडी-तोडीखे सेवक होन खे देते गयो कि दुन्या खे पोरसी दे. ");
INSERT INTO goj_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","अरु सब खाय खे तृप्त हुया. अरु बचा हुया टुकडा से बारा टोपली भरीखे उठइ ली. ");
INSERT INTO goj_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","जब व्हा सुनसान मे प्रार्थना करी रो थो. अरु सेवक ओका सात था. ते ओने उनसे पूछ्यो. “दुन्या मेखे का बोलस हइ?” ");
INSERT INTO goj_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","ओने उत्तर दियो. “यहून्ना बपतिस्मा देनआलो. अरु कोय-कोय एलिय्याह अरु कोय यो कि जुन्नो भविष्यव्दक्ताहोन मे से कोय जिन्दो उठ्यो हइ.” ");
INSERT INTO goj_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","ओने उनका से पूच्छो. “पन तुम मेखे का बोलस हय?” पतरस ने उत्तर दियो “परमेश्वर को मसीह.” ");
INSERT INTO goj_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","तब ओने उन धमकय खे बोल्यो. “यो को, से नी बोलनु.” ");
INSERT INTO goj_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","अरु ओने बोल्यो. “इन्सान को बेटा का लिये जरुरती हइ. कि उ खुप दुःख उठायो. अरु बापदादा अरु बडो याजक अरु शास्त्री ओखे बुरो समझी खे मारी डाल्यो. अरु उ तीसरा दिन जिन्दो उठ्यो.” ");
INSERT INTO goj_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","ओने सबसे बोल्यो. “अगर कोय मरा पीछे आनो चाह्ये. ते अपना आप से नाकारी खे अरु दरोज-दिन अपना क्रुस उठायो हुयो मरा पीछे हुय जा.” ");
INSERT INTO goj_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","क्युकी जो कोय अपनो जान बचानो चाह्ये व्हा ओखे गमाह्ये. पन जो कोय मरा लिये अपनो जान गमाह्ये व्हा ओखे बचाह्ये. क्युकी जो कोय अपनो जान बचानो चाह्ये व्हा ओखे गमाह्ये. पन जो कोय मरा लिये अपनो जान गमाह्ये ओसो ओखे बचाह्ये. ");
INSERT INTO goj_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","अगर इन्सान सब जगत खे मील्हे कर्हे. अरु अपनो जान गमाय दे. अरु ओको नुकसान उठाये. ते ओखे का लाभ हुये? ");
INSERT INTO goj_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","जो कोय मरा से अरु मरी बात से लजाह्ये. इन्सान को बेटो भी जब अपना. अरु अपना बाप. अरु पवित्र स्वर्गदूत की, महिमा सहित आह्ये ते ओकासे लाज्हे. ");
INSERT INTO goj_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","मी तुम से सच्ची बोलुस हय. कि जो यह्या खडो हइ, उन मे से कोय-कोय असा हइ कि जब तक परमेश्वर को राज नी देखी ली तब तक मरन को सवाद नी चखन को. ");
INSERT INTO goj_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","या बात खे कोय आठ दिन बाद व्हा पतरस. अरु यहून्ना अरु याकूब खे सात लीखे प्रार्थना करण खे लिये पहाड पर गयो. ");
INSERT INTO goj_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","जब व्हा प्रार्थना करी रो थो, ते ओको मेडा को रुप बदली गयो, अरु ओका कपडा उजरा हुयखे चमकन लग्यो. ");
INSERT INTO goj_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","तब. मूसा अरु एलिय्याह. यो दो इन्सान उनका सात बात कर राथा. ");
INSERT INTO goj_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ये महिमा सहित दिखाय दियो. अरु ओका मरन की बात करी राथा. जो यरुशलेम मे होन आला थो. ");
INSERT INTO goj_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","पतरस अरु ओका सात वाला नीद से भरी थी. अरु जब अच्छी तरह जागा हुयो. ते ओकी महिमा. अरु वे दो इन्सान खे. जो ओका सात खडा था. देख्या. ");
INSERT INTO goj_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","जब वे ओका पास से जान लग्या. ते पतरस ने यीशु से बोल्यो. “हे स्वामी. हमारा ह्या र्‍हेनो अच्छो हइ अरु हम तीन मण्डप बनायो. एक तरा लिये. एक मूसा, लिये. अरु एक एलिय्याह, लिये.” व्हा समजती नी थी. किका बोली रीस हइ. ");
INSERT INTO goj_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","व्हा बोली रो थो कि एक बद्दल अय खे उनका पर छय गयो अरु बद्दलसे धेर्‍यो जानकर ते वे भोत डर गया. ");
INSERT INTO goj_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","अरु उ बादल मे से या बात नीकली. “यो मरो बेटो अरु मरो चुन्यो हुयो हइ येकी सुन.” ");
INSERT INTO goj_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","या बात होते य यीशु एकलो मीली गयो. अरु वे चुप र्‍हि. अरु जो कुछ देख्यो थो. ओकी कोय बात वे दिन मे कोय खे नी बोलनु. ");
INSERT INTO goj_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","अरु दूसरा दिन जब वे टेकडा से उतार्यो. ते एक बडी गर्दी ओकासे अय खे मीली. ");
INSERT INTO goj_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","तब. गर्दी मे से एक इन्सान ने चिल्लाय खे बोल्यो. “हे गुरु. मी तुम से प्रार्थना करुस हय कि मरो बेटा पर कृपा दृष्‍टि करी. क्युकी व्हा मरो एकलौतो हइ. ");
INSERT INTO goj_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","अरु देख. एक बुरी आत्मा ओखे पकडस हइ, अरु व्हा एका एकी चिल्लय उठ्योस हइ. अरु व्हा ओखे असो मुर्गडस हइ. कि व्हा मुडा मे फेस भरी लास हइ. अरु ओखे कुचलीखे तकलीफ से छोडी देस हइ. ");
INSERT INTO goj_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","अरु मे ने तरा सेवक से प्रार्थना करी. कि ओखे निकाले. पन वे नी नीकली सक्या.” ");
INSERT INTO goj_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","यीशु ने उत्तर दियो. “हे अविश्वासी अरु जिद्दी दुन्या मे कब तक तुमारा सात तुम्हारी सह्यु? अपनो बेटा खे यो ली आयो.” ");
INSERT INTO goj_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","व्हा अय य रा था कि बुरीआत्मा ने ओखे पटकीखे मुर्गड्यो. पन यीशु ने बुरी आत्मा खे धमकय खे अरु बेटा खे अच्छो करीखे ओको बाप खे दि दियो ");
INSERT INTO goj_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","तब सब दुन्या परमेश्वर को महा सामर्थ्य से अचम हुयो. पन जब सब दुन्या वे सब काम से जो उ करतो थो. अचम्बो करी रा था. ते उनने अपना सेवक से बोल्यो. ");
INSERT INTO goj_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“या बात तुम्हारा ,न मे पडी र्‍हे क्युकी इन्सान को बेटो इन्सानहोन का हात मे पकडायो जान खे हइ.” ");
INSERT INTO goj_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","पन वे या बात को न समझनो नी चाहयो नी मील्यो. अरु वे या बात का बारे मे ओकासे पुछ ना से डरता था. ");
INSERT INTO goj_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","फिर उनमे यो विवाद होन लग्यो. कि हम मे से बडो कोन हइ? ");
INSERT INTO goj_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","पर यीशु ने उनका मन को बिचार जानी लियो. अरु एक बच्चा खे लीखे अपना पास खडो कर्‍यो. ");
INSERT INTO goj_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","अरु उनका से बोल्यो. “जो कोय मरा नाम से यो बच्चा खे अपना ह्ये करतो हइ. उ मेखे अपनास हइ. अरु जो कोय मेखे अपना तो हइ. उ मरो भेजनआला खे अपनास हइ. क्युकी जो तुम मे सबसे छोटा से छोटो हइ. उ बडो हइ.” ");
INSERT INTO goj_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","तब यहून्ना ने बोल्यो. “हे स्वामी. हमने एक इन्सान खे तरा नाम से बुरीआत्माहोन खे नीकालते देख्यो. अरु हमने ओखे मना कर्‍यो. क्युकी उ हमारा सात हुइखे तरा पीछे नी हुइ लेतो.” ");
INSERT INTO goj_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","यीशु ने ओकासे बोल्यो. “ओखे मना मत कर्‍हे. क्युकी जो तुम्हारा खीलाप मे नी व्हा तुम्हारा तरप हइ.” ");
INSERT INTO goj_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","जब ओका उपर उठाह्ये जान को दिन पूरा होना पर थो. ते ओने यरुशलेम खे जाने को बिचार पक्को कर्‍यो. ");
INSERT INTO goj_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","अरु ओने अपना आगे दूत भेज्या वे सामरीहोन को एक गाव मे गया. कि ओका लिये जगह तैयार कर. ");
INSERT INTO goj_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","पन वे दुन्या ने ओखे उतरननी दियो. क्युकी व्हा यरुशलेम मे जय रा था. ");
INSERT INTO goj_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","यो देखीखे ओका सेवक याकूब अरु यहून्ना ने बोल्यो. “हे प्रभु, तू चाहस हइ. कि हम आज्ञा दिह्या. कि बद्दल से अंगार गिरीखे उनखे खतम करी दिह्ये?” ");
INSERT INTO goj_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","पन ओने फिरीखे उनखे धमकय अरु बोल्यो. “तुम नी समजो कि तुम कसी आत्मा, हय. क्युकी इन्सान को बेटो दुन्या का जान खे खतम करणो नी क्युकी बचान, लिये आयोस हइ.” ");
INSERT INTO goj_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","अरु वे कोय अरु गाव मे चली दिया. ");
INSERT INTO goj_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","जब वे रस्ता मे चल्यो जातो थो. ते कोय ने ओकासे बोल्यो. “झा-झा तू जाह्ये. मी तरा पीछे हुय जाह्यु.” ");
INSERT INTO goj_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","यीशु ने ओकासे बोल्यो. “लाडग्या को भट अरु बद्दल को पक्षियो को बसेरो होस हइ. पन इन्सान को बेटा को माथो रखन की भी जगा नी.” ");
INSERT INTO goj_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","ओने दूसरा से बोल्यो. “मरा पीछे चल.” ओने बोल्यो. “हे प्रभु. मेखे पैयले जान दे कि अपना बाप खे गाडी दिव.” ");
INSERT INTO goj_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","ओने उनसे बोल्यो. “मर्‍यो हुया खे अपनो मेर्दो गाडन दे. पर तू जयखे परमेश्वर को राज की कथा सुना.” ");
INSERT INTO goj_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","एक अरु ने भी बोल्यो. “हे प्रभु. मी तरा पीछे चल ह्यु. पर पैयले मेखे जान दे कि अपना घर, दुन्या से बिदा हुय आस.” ");
INSERT INTO goj_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","यीशु ने उनसे बोल्यो. “जो कोय अपना हात हल्ली पर रखस पीछे देखस हइ. उ परमेश्वर को राज को लायक नी.” ");
INSERT INTO goj_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","अरु या बात का बाद प्रभु ने बाहत्तर अरु इन्सान चुनीलियो कि अरु जो जो नगर अरु जगा खे व्हा खुद समझना पर था. व्हा उनखे दो-दो करीखे अपना से पैयले उनखे भेज्यो. ");
INSERT INTO goj_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","अरु यीशु ने उनका से बोल्यो. पक्को खेत खुप हइ. पन मजुर थोडा हइ येका लिये खेत को स्वामी से प्रार्थना कर. कि व्हा अपना खेत काटन खे मजुर भेजी दे. ");
INSERT INTO goj_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","जाओ. मी तुमखे लाडग्या का जसो मेढाहोन का बीच मे भेजुस हय. ");
INSERT INTO goj_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","येका लिये बटुवो नी थैली. नी जुता ले. अरु नी रस्ता मे कोय को नमस्कार कर. ");
INSERT INTO goj_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","जो किय घर मे जाव. पैयले बोल. यो घर पर शांती हुये. ");
INSERT INTO goj_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","अगर व्हा कोय शांती को योग्य हुये. ते तुम्हारो शांती ओका पर रुखन को. नी ते तुम्हारा पास वापीस आह्ये. ");
INSERT INTO goj_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","उये घर मे र्‍हेव. अरु जो कुछ उनका से मील्हे. व्हा खाओ-पीओ. क्युकी मजुर खे अपनी मजुरी मीलन खे य होनु. घर-घर नी फिरनू. ");
INSERT INTO goj_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","अरु जो नगर मे जा, अरु वहा का दुन्या तुमके उतारे, ते जो कुछ तुमारा सामने रख्यो जाये उई खा. ");
INSERT INTO goj_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","व्हा की बीमारी खे अच्छो कर अरु उनका से बोल. परमेश्वर को राज तुम्हारा नजीक अय पहुच्योस हइ. ");
INSERT INTO goj_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","पन अगर तुम कोय नगर मे प्रवेश करणु अरु व्हा नगर आलाहोन को दरवाजा अपनायो नी कर्‍यो जातो थो उ नगर की गल्लिहोन मे जाय खे यो घोषणा कर. ");
INSERT INTO goj_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","तुम्हारा नगर को धुलो भी. जो हमारा पाय मे लगस हइ. हम तुम्हारा सामने झाडि देस हइ. फिर भी यो जानी ले. कि परमेश्वर को राज तुम्हारा नजिक आय पहुच्योस हइ. ");
INSERT INTO goj_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","मी तुमारा से बोलुस हय. कि उ दिन उ नगर की दशा से सदोम की दशा सहन योग्य हुये. ");
INSERT INTO goj_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","हाय खुराजीन! हाय बैतसैदा! जो सामर्थ्य काम तुम म कर्यो गयो. अगर वे सूर अरु सैदा मी कर्यो जातो ते ठाटी होडीखे अरु राख मे बठीखे वे कब का मन फिरातो. ");
INSERT INTO goj_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","पन न्याय का दिन तुम्हारी दशा से सूर अरु सैदा की दशा जादा सहन योग्य हुये. ");
INSERT INTO goj_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","अरु हे कफरनहूम, का तू स्वर्ग तक उच्चो कर्‍यो जाह्ये? तू तो अधोलोक तक नीचे जाह्ये. ");
INSERT INTO goj_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","“जो तुम्हारी सुनस हइ. व्हा मरी सुनस हइ. अरु जो तुमखे तुच्छ जानता हइ. व्हा मेखे तुच्छ जानस हइ. अरु जो मेखे तुच्छ जानस हइ. व्हा मरो भेजनआला खे तुच्छ समजस हइ.” ");
INSERT INTO goj_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","वे बाहात्तर चेला खुशी से फिर अयखे बोलन लग्या. “हे प्रभु. तरा नाम से बुरीआत्मा भी हमारा बस मे हइ.” ");
INSERT INTO goj_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","यीशु ने उनका से बोल्यो. “मी सैतान की बिजली का जसो स्वर्ग से गिर्‍यो हुयो देखीरो थो. ");
INSERT INTO goj_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","मेने तुमखे दि दियो साप अरु बिच्छुहोन खे खुदन खे. अरु दुशमन की सब सामर्थ्य पर अधिकार दियो हइ. अरु नी होन को. ");
INSERT INTO goj_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","ते भी येका से खुशी मत होनु. कि आत्मा तुम्हारा बस मे हइ. पन येका से खुशीसे हुय खे कि तुम्हारो नाम स्वर्ग पर लिखयो गयोस हइ.” ");
INSERT INTO goj_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","मसीह यीशु पवित्र आत्मा खे खुशी से भरीखे बोलन लगीया. हे बाप स्वर्ग अरु पृथ्वी को प्रभु. मी तरो धन्यवाद करुस हय. कि तोने या बात खे ज्ञानीहोन अरु समझदार से लुकय रख्यो. अरु बच्चा पर प्रगट कर्‍यो ह्या. हे बाप. क्युकी तोखे यो अच्छो लग्यो. ");
INSERT INTO goj_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","मरा बाप ने मेखे सब कुछ दि दियो हइ. अरु कोय नी समज्हे कि बेटो कोन हइ. फक्त बाप अरु बाप कोन हइ यो भी कोय नी समज्हे. फक्त बेटा, अरु व्हा जेका पर बेटो ओखे प्रकट करणो चाह्यो. ");
INSERT INTO goj_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","अरु सेवक खे तरप पलटी खे एकला मे बोल्यो. “धन्य हइ वे आख. जो तुम या बात जो तुम देखेता हुये देखस हइ. ");
INSERT INTO goj_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","क्युकी मी तुमारा से बोलुस हय. कि बहोत सा भविष्यव्दक्ता अरु राजाहोन ने चाह्यो कि जो बात तुम देखस हय देख अरु जो बात तुम सुनस हय ते सुन. पर नी सुनी.” ");
INSERT INTO goj_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","तब एक व्यवस्थापक उठ्यो. अरु यो बोलीखे ओकी परीक्षा करण लग्यो. हे गुरु. अनन्त जिवन को वारिस होन का लिये मी, करु? ");
INSERT INTO goj_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","यीशु ने उनसे बोल्यो. “व्यवस्था मे का लिख्यो हइ? तू कसो पडस हइ?” ");
INSERT INTO goj_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","यीशु ने उत्तर दियो. “तू प्रभु अपनो परमेश्वर से अपना सब मन अरु अपनो सब जान अरु अपनी सब शक्ति अरु अपनी सब दिमाक का सात प्रेम कर. अरु अपनो पडोसी से अपना जसो प्रेम रख.” ");
INSERT INTO goj_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","यीशु ने उनसे बोल्यो. “तोने ठीक उत्तर दियो. यो कर ते तू जिन्दो र्हिये.” ");
INSERT INTO goj_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","पन यीशु ने अपना आप खे न्याय रुखन की इच्छा से यीशु से पूछ्यो. “ते मरा बाजुआला कोन आय?” ");
INSERT INTO goj_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","यीशु ने उत्तर दियो एक इन्सान यरुशलेम से यरीहो खे जाय राथा. कि डाकुहोन ने घेरीखे ओका कपडा नीकाली लिया. अरु मारी पीटीखे ओखे आधोमर्‍यो छोडी खे चली दिया. ");
INSERT INTO goj_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","अरु असो हुयो कि वय रस्ता से एक याजक जय रो थो. पन ओखे देखीखे कतरीखे चली दियो. ");
INSERT INTO goj_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","या रीति से एक लेवी वा जगा पर आयो. व्हा भी ओखे देखी खे कतरी खे चली गयो. ");
INSERT INTO goj_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","पन एक सामरी इन्सान व्हा आय नीकल्यो. अरु ओखे देखी खे दया खाय. ");
INSERT INTO goj_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","अरु ओका पास अय खे अरु ओको घाव पर तेल अरु अंगूर को रस डालीखे पट्टिहोन बाधी. अरु अपनी सवारी पर चडीखे सराय मे ली गयो. अरु ओकी सेवा चाकरी करी. ");
INSERT INTO goj_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","दूसरा दिन ओने दो चादी का सिक्का, नीकाली खे दानपेटी का मालिक खे दिया. अरु बोल्यो. येकी सेवा चाकरी करनु. अरु जो कुछ तेरा तरप लगेह्ये. व्हा मी वापस आना पर तोखे दि दिह्यु. ");
INSERT INTO goj_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","यीशु ने उनका से बोल्यो. “व्हा जेने ओका पर तरस खायो.” यीशु ने ओका से . “जा तू भी असो य कर.” ");
INSERT INTO goj_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","यीशु ने बोल्यो. “व्हा जेने ओका पर दया कर मरा तरस खायो.” यीशु ने उनसे बोल्यो. “जा. तू भी असो य कर.” ");
INSERT INTO goj_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","फिर जब वे जै रहा था. ते व्हा एक गाव मे गयो. अरु मार्था नाम एक बय ने ओखे अपना घर मे उतार्‍यो. ");
INSERT INTO goj_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","अरु मरियम नामक ओकी एक भैइन थी. वा प्रभु, पाय का पास बठीखे ओको वचन सुनती थी. ");
INSERT INTO goj_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","पन मार्था सेवा करते घबरय गय अरु ओका पास अयखे बोलन लगी. “हे प्रभु, तोखे कुछ भी चिन्ता नी हय कि मरी भैइन ने मेखे सेवा करण, लिये एकली या छोडी दियो हइ? येका लिये ओकासे बोल्यो. मरी मद्दत कर.” ");
INSERT INTO goj_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","प्रभु ने ओखे उत्तर दियो. “मार्था. हे मार्था. तू खुप बात का लिये चिन्ता करस अरु घबरास हइ. ");
INSERT INTO goj_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","पन एक बात जरुरती हइ. अरु वा अच्छो भाग खे मरियम ने चुनी लियो हइ जो ओकासे छुडयो नी जाये.” ");
INSERT INTO goj_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","फिर यीशु कोय जगा प्रार्थना करी रा था. अरु जब व्हा प्रार्थना करी चुक्या.ते ओका सेवक मे से एक ने उनका से बोल्यो. “हे प्रभु. जसो यहून्ना ने अपना सेवक खे प्रार्थना करणो सिखायो वोसो य हमने भी तू सीखय दे.” ");
INSERT INTO goj_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","यीशु ने उनका से बोल्यो. जब तुम प्रार्थना कर. ते बोलो हे बाप. तरो नाम पवित्र मान्यो जाह्ये. तरो राज आह्ये. ");
INSERT INTO goj_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","हमारी दिन भर की रोटी हर दिन हमखे दियो करणू. ");
INSERT INTO goj_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","अरु हमारो पाप की माफी कर. क्युकी हम भी अपनो हर एक अपराध खे माफ करस हइ. अरु हम परीक्षा मे नी ला. ");
INSERT INTO goj_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","अरु यीशु ने ओकासे बोल्यो. “तुम मे से कोन हइ कि ओका एक दोस्त्त हय.” अरु व्हा आधी रात खे ओका पास जयखे ओकासे बोल्यो. हे दोस्त. मेखे तीन रोटिहोन दे. ");
INSERT INTO goj_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","क्युकी एक दोस्त जत्रा मे मरा पास आयोस हइ. अरु ओका आगे रखन, लिये मरा पास कुछ नी हइ. ");
INSERT INTO goj_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","अरु व्हा अंदर से उत्तर देतो. कि मेखे दुखी नी देनु. आप तो दरवाजो बन्द हइ. अरु मरो बच्चा मरा पास बिछानो पर हइ. येका लिये मी उठीखे तोखे दि नी स. ");
INSERT INTO goj_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","मी तुमारा से बोलतो हय. अगर ओको दोस्त होन पर भी ओखे उठखेनी देनू. फिर भी ओकी लाज छोडी खे मागन को करण ओखे जेतनो जरुरती हय ओतनी उठीखे आंग्या. ");
INSERT INTO goj_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","अरु मी तुमारा से बोलुस हय. कि माग. ते तुमखे दियो जाह्ये. ढूढ्ये ते तुम मील्हे. खटखटाह्ये. ते तुम्हारा लिये खोल्यो जाह्ये. ");
INSERT INTO goj_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","क्युकी जो कोय मागस हइ. ओखे मीलस हइ. अरु जो ढुढतो हइ. व्हा मालुम हइ. अरु जो खटखटातो हइ. ओका लिये खोल्यो जाह्ये. ");
INSERT INTO goj_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","तुमारा मे से असो कोन बाप हुये. कि जब ओको बेटो रोटी माह्ये. ते ओखे पत्थर दे अरु मंछी माह्ये ते मंछी का बदला ओखे साप दे? ");
INSERT INTO goj_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","अरु अण्डा माह्ये ते ओखे बिच्छु दे? ");
INSERT INTO goj_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","जब तुम बुरो हुय खे अपना बच्चा खे अच्छी चिज देनो मालुम हय. ते तुम्हारो स्वर्गीय बाप अपनो मागनवालो खे पवित्र आत्मा क्युव नी देनको. ");
INSERT INTO goj_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","फिर ओने एक मेकी बुरीआत्मा खे नीकल्यो. जब बुरीआत्मा नीकली गय. ते मेकी बोलन लगी. अरु दुन्या ने अचम्बो कऱ्यो. ");
INSERT INTO goj_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","पन उनमे से खे तना ने बोल्यो. “ह्या तो बुरीआत्माहोन को बडो मुखियो की सैतान की मदत से बुरीआत्माहोन खे नीकालतो हइ.” ");
INSERT INTO goj_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","दुसरा ने ओकी परीक्षा करण का लिये ओकासे बद्दल को एक चिन्ह माग्यो. ");
INSERT INTO goj_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","पन यीशु ने. उनका मन की बात समजी खे. उनसे बोल्यो. “जो जो राज्य मे फूट होस हइ. व्हा राज्य उजलते जास हइ. अरु जो घर मे फूट होस हइ. व्हा नास हुय जास हइ.” ");
INSERT INTO goj_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","अरु अगर सैतान अपना य खीलाप हुय जाह्ये. तो ओको राज कसो बन्यो र्‍हिये? क्युकी तुम मरा बारे मे तो बोलस हो. कि ह्या सैतान की सहायता से बुरीआत्मा नीकालता हइ. ");
INSERT INTO goj_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","अच्छो. अगर मी सैतान की मदत से बुरीआत्मा नीकाली करुस हय. तब तुम्हारा सेवक उनखे कोय की मदत से नीकल्यो करस हइ? परिणाम स्वरुप तुम्हारो चेलो तुमा पर इलजाम लगाह्ये. ");
INSERT INTO goj_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","पन अगर मी परमेश्वर की सामर्थ्य से बुरीआत्माहोन खे नीकालतो हूये. ते परमेश्वर को राज्य तुम्हारा पास अय पहुच्यो. ");
INSERT INTO goj_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","जब तभ इन्सान हतीयार बाध्यो हुयो अपना घर मे घुसीखे रखवाली करस हइ. ते ओकी धनदौलत बची र्‍हेस हइ. ");
INSERT INTO goj_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","पर जब तक ओमे से बठीखे कोय अरु ताखतआलो चलीखे करीखे ओखे जीत लेस हइ. ते ओको उ हथियार जेका पर ओको भरोसो थो. छुडय लेस हइ अरु ओकी धनदौलत चोरी खे बाटी देस हइ. ");
INSERT INTO goj_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","जो मरा साथ नी व्हा मरा खीलाप मे हइ. अरु जो मरा साथ नी समटस व्हा समटस हइ. ");
INSERT INTO goj_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“जब बुरी आत्मा इन्सान मे से नीकली जास हइ ते सूकी जगा मे अराम ढूढती फिरस हइ. अरु जब नी मील्हे ते बोलस हइ. कि मी अपना उये घर मे झा से नीकली थी पलटी जाह्यु. ");
INSERT INTO goj_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","अरु अयखे ओखे झाड झुडिखे अरु सपा सपा मीलस हइ. ");
INSERT INTO goj_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","तब व्हा अयखे अपना से अरु बुरी सात आत्माहोन खे अपना साथ ली आस हइ. अरु वे ओमे टेम करस हइ. अरु उ इन्सान की जतनी दशा पैयले से भी बुरी होते जास हइ.” ");
INSERT INTO goj_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","जब व्हा या बात बोलीय रहा था ते गर्दी मे से कोय बय ने उच्चा अवाज से बोल्यो. “धन्य हइ व्हा गर्भ जोमे तू र्‍हियो अरु वे स्तन. जो तोने पियो.” ");
INSERT INTO goj_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","ओने बोल्यो. “हव. पन धन्य वे हइ. जो परमेश्वर को वचन सुनतो अरु मानस हइ.” ");
INSERT INTO goj_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","जब बडी गर्दी जमा होती जाती थी ते व्हा बोलन लग्या. “यो जमाना का दुन्या बुरो हइ. वे चिन्ह ढुडस हइ. पर नबी योना को चिन्ह खे छोडी कोय अरु चिन्ह उनखे नी दियो जाह्ये.” ");
INSERT INTO goj_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","जसो योना नीनवे का दुन्या का लिये चिन्ह रोख्यो. वोसोय इन्सान को बेटो भी यो जमाना का दुन्या का लिये रुख्ये. ");
INSERT INTO goj_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","दक्षिण की रानी न्याय को दिन या टेम को इन्सानहोन का साथ उठीखे उनखे दोषी ठयरायो. क्युकी व्हा सुलैमान, ज्ञान सुनन खे पृथ्वी, छेडा से आयो. अरु देख यो उ हइ जो सुलैमान से भी बडो हइ. ");
INSERT INTO goj_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","नीनवे का दुन्या को न्याय का दिन या टेम का दुन्या का साथ खडा हुयखे उनखे दोषी ठहयराह्ये. क्युकी उनने योना को प्रचार सुनीखे मन फिरायो अरु देख. यह्या व्हा हइ. जो योना से भी बडो हइ. ");
INSERT INTO goj_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“कोय इन्सान दिवो जलय खे तलघर मे. या बर्तन खे नीच्चे नी टोपली. पन ओडा पर रखस हइ कि अंदर आनवालो उजारो मील्हे. ");
INSERT INTO goj_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","तरो आंग को दिवो तेरा आख हइ. येका लिए जब तरा आख नीर्मल हइ. ते तरो पुरो आंग भी उजालो हइ. पन जब व्हा बुरी हइ. ते तरो आंग भी अधारो हइ. ");
INSERT INTO goj_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","येका लिए सावधान र्‍हेनु कि जो उजालो तरा मे हइ व्हा अधारो नी हुय जाह्ये. ");
INSERT INTO goj_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","येका लिये अगर तरो पुरो आंग उजालो हूये. अरु ओको कोइ भाग अधारो नी र्‍हिये. ते सब का सब असो उजालो हुये. जसो वा टेम होस हइ. जब दिवो अपनी चमक से तोखे उजालो देस हइ.” ");
INSERT INTO goj_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","जब उ बातहोन करी र्‍हो थो. ते कोय फरीसी ने ओकासे प्रार्थना करी. कि मरा ह्या खानो खा. अरु उ अंदर जैखे खानो खान बैठ्या. ");
INSERT INTO goj_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","फरीसी ने यो देखीखे अचम्बो कर्यो कि ओने खानो खाना से पैयले हात-पाय नी धोया. ");
INSERT INTO goj_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","प्रभु ने ओखे बोल्यो. हे फरीसीहोन. तुम कटोरो अरु ठाटी, उपर उपर तो माजस हइ. पन तुम्हारा अंदर अधारो अरु बुरीआत्मा से भरी हइ. ");
INSERT INTO goj_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","हे बिनादिमाकहोन. जेने बाहेर को भाग बनायो, ओने अंदर को भाग नी बनायो? ");
INSERT INTO goj_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","पन हव. अंदर आली चिजहोन खे दान करी दे. तब सब कुछ तुम्हारा लिये अच्छो हुइ जाये. ");
INSERT INTO goj_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","पर हे फरीसीहोन तुम पर हाय! तुम पुदीना अरु सुदाब का अरु सब जात को बगीचा को रोप का दसवो भाग देस हइ पन न्याय खे अरु परमेश्वर को प्रेम खे टाली देस हइ होनु ते थो कि इनखे भी करता र्‍हेता अरु उन खे भी नी छोडतो. ");
INSERT INTO goj_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","हे फरीसीहोन तुम पर हाय! तुम आराधनालय मे मुख्य-मुख्य आसन अरु बाजरहोन मे नमस्कार चाहस हइ. ");
INSERT INTO goj_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","हाय तुम पर! क्योकि तुम उन लुकी खे कब्र, जसो हय. जिन पर दुन्या चलस हइ पन नी पहीचानस. ");
INSERT INTO goj_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","तब एक व्यवस्थापक ने ओको उत्तर दियो. “हे गुरु या बात खे बोलना से तू हमारी टिगल करस हइ.” ");
INSERT INTO goj_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","ओने बोल्यो. “हे व्यवस्था करणआलो तुम पर भी हाय! तुम असो बोझ जिन खे उठानो कठिन हइ. इन्सानहोन पर लादस हय पन तुम खुद वे बोझा खे अपनी एक उगली से भी नी पकडे.” ");
INSERT INTO goj_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","हाय तुम पर! तुम वे भविष्यव्दक्ताहोन की कब्र बनास हय. जिनने तुम्हारा बापदादा ने मारी डाल्यो थो. ");
INSERT INTO goj_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","अन्नत मे तुम गवाह हुये. अरु अपना बापदादा काम से सहमत हुये. क्युकी उनने तो उन खे मारी डाल्यो अरु तुम उनकी कब्रहोन बनास हय. ");
INSERT INTO goj_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","येका लिये परमेश्वर की दिमाक ने भी बोल्योस हइ कि मी उनका पास भविष्यव्दक्ताहोन अरु प्रेरितहोन खे भेज्हु. अरु वे उन मे से केत्ता खे मारी डाल्हे. अरु खेत्ता खे सताह्ये. ");
INSERT INTO goj_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","जबकी जोत्ताने भविष्यव्दक्ताहोन को खुन जगत की उत्पत्ति से बोहायो गयोस हइ. सब को लेख यो जगत दुन्या से लियो जाह्ये. ");
INSERT INTO goj_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","हाबिल को खुन से लिखी जकर्याह की खुन तक जो वेदी अरु सभा घर का बीच मे मार्‍यो गयो मी तुम से सच्ची बोलुस हय. ओको लिखो गयो टेम खे दुन्या से लियो जाह्ये. ");
INSERT INTO goj_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","हाय तुम व्यवस्थापक पर! कि तुम ने ज्ञान की कुंजी ली तो ली. पन तुम ने खुद अंदर नी कर्‍यो. अरु अंदर करणआलो खे भी रोखी दियो. ");
INSERT INTO goj_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","जब उ व्हा से नीकल्यो. ते शास्त्री अरु फरीसी भोत पीछे पडी गया अरु तरास देन लग्या. कि उ भोत सी बातहोन की चर्चा कर्ये. ");
INSERT INTO goj_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","अरु ओखे मारना मे लगया र्‍हिये. कि ओका मेडा की कोय बात पकडये. ");
INSERT INTO goj_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","येतना मे जब हजार की गर्दी लगी गय. ह्या तक कि एक दूसरा पर गिरी पडतो थो. ते व्हा सबसे पैयले अपना सेवक से बोलन लग्या. “फरीसीहोन को कपटी रुपी खमीर से हुशार र्‍हेनु. ");
INSERT INTO goj_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","कुछ झाक्यो नी. जो खोल्यो नी जाह्ये. अरु नी कुछ लुक्यो हइ. जो समजी नी जाह्ये. ");
INSERT INTO goj_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","येकालिये जो कुछ तुम ने अंधारा मे बोल्योस हइ. व्हा उजाला मे सुन्यो जाह्ये. अरु जो तुम ने अंदर का खोलीमे कानो कान बोल्योस हइ. व्हा छपर पर प्रचार कर्‍यो जाह्ये. ");
INSERT INTO goj_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“पन मी तुम से जो मरा दोस्त हय बोल्यो जास हय. खे जो आंग खे मारी सकस हइ अरु ओकासे ज्यादा अरु कुछ नी करी सकस. उनका से मत डरे. ");
INSERT INTO goj_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","मी तुमखे चेतावनी दिउस हय कि तुम कि कोय से नी डरनु चाह्ये. मारन का बाद जो खे नरक मे डालन को अधिकार हइ. ओका से डर. क्युकी मी तुम से बोलुस हइ ओका से डर. ");
INSERT INTO goj_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","का दो पैसा की पाच कन्डा नी बेचाय? फिर भी परमेश्वर उनमे से एक खे भी नी भूलतो ");
INSERT INTO goj_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","क्युकी तुमारा माथा का सब बाल भी गिन्या हुया हइ. मत डरनु नी. तुम भोत कन्डा बडिखे हय. ");
INSERT INTO goj_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“मी तुम से बोलुस हय जो कोय इन्सान का सामने मेखे मान्ये दुन्या उ इन्सान को बेटो भी परमेश्वर को स्वर्गदूतहोन का सामने मानी लिह्ये. ");
INSERT INTO goj_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","पन जो इन्सान का सामने मेखे मना कर्‍हे ओखे परमेश्वर को स्वर्गदूतहोन का सामने मना कर्‍यो जाह्ये. ");
INSERT INTO goj_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“जो कोय इन्सान को बेटा का खिलाप मे कोय बात कर्‍हे. ओको व्हा गुन्हा माफ कर्‍यो जाह्ये. पन जो पवित्र आत्मा की नीन्दा कर्‍हे. ओका गुन्हा माफ नी कर्‍यो जाह्ये. ");
INSERT INTO goj_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“जब दुन्या तुम आराधनालयहोन अरु अधिकारीहोन अरु अधिकारी होन का सामने ली जाह्ये. ते चिन्ता नी करणु कि हम कोय रीति से अरु का उत्तर दिह्या यो का बोल्हे. ");
INSERT INTO goj_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","क्युकी पवित्र आत्मा वय टेम तुम खे सीखी दिह्ये. कि का बोलनो चाह्ये.” ");
INSERT INTO goj_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","फिर गर्दी मे से एक ने ओकासे बोल्यो. “हे गुरु. मरो भैइ से बोल. कि बाप की दौलत मेखे बाटी दे.” ");
INSERT INTO goj_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","यीशु ने उनका से बोल्यो “हे इन्सान कोय ने मेखे तुम्हारो न्याय या बाटनआलो नीवडि कर्‍यो हइ?” ");
INSERT INTO goj_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","अरु यीशु ने उनका से बोल्यो “हुशार र्‍हेव अरु हर रंग को लोभ से अपना आप खे बचायो रख क्युकी कोय को जिवन ओकी दौलत की भोत से नी होय.” ");
INSERT INTO goj_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","यीशु ने उनका से एक दृष्‍टान्‍त बोल्यो. कोय लकपती की जमीन मे अच्छी फसल हुइ. ");
INSERT INTO goj_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","“तब व्हा अपना मन मे बिचार करण लग्या. कि मी का करु. क्युकी मरा ह्या जगह नी. झा अपनी फसल इत्यादि रखू.” ");
INSERT INTO goj_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","अरु यीशु ने बोल्यो मी ह्या करु ह्यु मी अपनी खेत तोडि खे ओकासे बडि बनाह्यु अरु व्हा अपनो सब अनाज अरु दौलत रखह्यु. ");
INSERT INTO goj_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","अरु अपनी जान से बोल्ह्यु कि जान रता पास खुप साल का लिये खुप दौलत रखी हइ चैन से खास पीस अरु सुखी से र्‍हे. ");
INSERT INTO goj_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","पन परमेश्वर ने लखपती से बोल्यो. हे अनाडि या रात तरी जान तरासे ली लियो जाह्ये. तब जो कुछ ने तो एक जगा कर्‍योस मे व्हा कोय को हुये? ");
INSERT INTO goj_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","असो य उ इन्सान भी हइ जो अपना लिये पैसा जमाकरस हइ पन परमेश्वर की नजर मे पैसा नी. ");
INSERT INTO goj_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","फिर यीशु ने अपना सेवक से बोल्यो. “येकालिये मी तुम से बोलुस हय. अपनो जिवन की चिन्ता मत कर. कि हम का खाह्या. नी अपना आंग की. का पेन्ह्ये” ");
INSERT INTO goj_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","क्युव खाना से जान अरु कपडा से आंग झाकि खे हइ ");
INSERT INTO goj_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","कव्वा पर ध्यान दे वे नी बोस हइ. नी काटस नी उनको खेत अरु नी खेत्ता होस हइ. नी फिर भी परमेश्वर उन खे खलास हइ. तुमारो मोल पक्षिहोन से कोय जादा हइ. फिर मसीह यीशु ने यो दृष्‍टान्‍त भी बोल्यो कोय की अंगूर की बाडी मे एक अंजीर को झाड लग्यो हुयो थो व्हा ओमे फल ढुडन आयो. पन नी मील्यो. ");
INSERT INTO goj_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","जब घर को स्वामी उठीखे दरवाजो बन्द करी चुक्योस हइ अरु तुम बाहेर खडो हुय दरवाजो ठोकिखे बोलन लग्या. हे प्रभु. हमारा लिये खोली दे कि मी तुम नी मालुम. तुम खा, आय? ");
INSERT INTO goj_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","तब तुम बोलन लगीगा. कि हमने तरा सामने खायो पियो अरु तोने हमारा बजार मे उपदेस दियो. ");
INSERT INTO goj_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","फुल पन व्हा बोल्हे. मी तुम बोलुस हय. मी नी समजु तुम खासे हय. हे बुरोकाम करणवाला. तुम सब मरासे दुर हो. ");
INSERT INTO goj_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","व्हा रोनो अरु दात कटरनो हुये. हे अल्पविश्वासिहोन जब तुम अब्राहम अरु इसहाक अरु याकूब अरु सब भविष्यव्दक्ताहोन खे परमेश्वर को राज मे बठी. अरु अपना आप खे बाहेर नीकली हुयो देख्ये. ");
INSERT INTO goj_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","अरु पूर्व अरु पश्चिम. उत्तर अरु दक्षिण से दुन्या अयखे परमेश्वर को राज को खाना मे मी मील्हु हय. ");
INSERT INTO goj_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","क्युकी जगत का अरु सभ दुन्या यो समजी लेव कि गैरयहूदीहोन खे तना पिछे हइ वे पैयले हुये. ते स्वर्ग से बाप अरु खेत्ता जो पैयले हइ पिछे हुये. ");
INSERT INTO goj_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","वय टेम मे खे तना फरीसीहोन ने अयखे यीशु से बोल्यो. “ह्या से नीकलीखे चली जा. क्युकी हेरोदेस का राज्य खे तोखे मारी देनो चाहस हइ.” ");
INSERT INTO goj_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","यीशु ने उकासे बोल्यो. जयखे उ लाडग्या से बोल्यो बाप खे दे. कि देख मी आज अरु कल बुरीआत्माहोन खे नीकालतो अरु बिमारी खे अच्छो करुस हइ राज्य देन को तत्पर हइ अरु तिसरा दिन अपनो काम पुरो कर्‍हु. ");
INSERT INTO goj_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","ते भी मेखे आज अरु कल अरु परसु चलनो जरुरती हइ. क्युकी हुय नी सखे कि कोय आकाशवाणी यरुशलेम का बाहेर धन मार्‍यो जाह्ये. ");
INSERT INTO goj_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","हे यरुशलेम! हे यरुशलेम! तु जो मन भविष्यव्दक्ताहोन खे मारी डालनो हइ. अरु जो तरा पास भेज्यो गयो उनखे फत्तर मारस हइ. खे त्ता बार मेने यो चाह्यो. कि जसी मुर्गी अपना बच्चा खे अपना पख, नीच्चे येकजगा करस हइ. वसो मी भी तरा धन खे जमा करु पर तुम ने यो नी चाह्यो. ");
INSERT INTO goj_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","तुमारो घर बन्धी के र्हिये अरु दिव्वो जलते र्हिये, ");
INSERT INTO goj_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","अरु तुम वे इन्सानहोन का जसा बन. जो अपना स्वामी की आनकी रस्ता देखीरास हय. कि व्हा भ्याव से कब आह्ये कि जब अयखे दरवाजो ठोक्हे ते झल्दी खोल देनू. ");
INSERT INTO goj_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","धन्य हइ वे सेवक . जिनखे स्वामी अयखे जगो मील्हे; मी तुम से सच्ची बोलस हय. कि व्हा कमर बाधी खे उनखे खानो खान खे बठाह्ये. अरु नजीक अयखे उनकी सेवा कर्‍हे. ");
INSERT INTO goj_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","अगर वा रात का दुसरा बारा बजे का बाद अरु तिन बजे का बाद अयखे उनखे जागो मील्यो. ते वे सेवक धन्य हइ. ");
INSERT INTO goj_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","पन तुम ह्या समजी रास. कि अगर घर को स्वामी समजस . कि चोर कोय टेम आह्ये. ते जागते र्‍हियो. अरु अपना घर मे घुसन नी देनको. ");
INSERT INTO goj_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","तुम भी तैयार र्‍हेव; क्युकी जो टेम तुम सोचे भी नी. वा टेम इन्सान को बेटो अय जाह्ये. ");
INSERT INTO goj_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","तब पतरस ने बोल्यो. “हे प्रभु. तुमारा ह्या दृष्‍टान्‍त का जसो हमारा लिये हइ या गर्दी का लिये भी?” ");
INSERT INTO goj_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","प्रभु ने बोल्यो. व्हा विश्वासयोग्य अरु दिमाक से बडो कोन हइ. जिनको स्वामी ओखे नवकर- चाकर पर मुखीयो रख्यो कि उनखे टेम पर खानकि चिजहोन दे. ");
INSERT INTO goj_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","अच्छो हइ उ सेवक जेखे ओको स्वामी वापीस पर ह्या करते हुयो मील्हे. ");
INSERT INTO goj_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","मी तुम से सच्ची बोलुस हय; व्हा ओखे अपनी सब दौलत पर अधिकारी रखे. ");
INSERT INTO goj_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","पन अगर चेलाहोन सोचन लग्या. की मरो स्वामी आना मे देर करी रोस हइ. अरु सेवक होन अरु दासीहोन खे मारन पिटन अरु खान पिन अरु पियक्कड होन लग्या. ");
INSERT INTO goj_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ते सेवक को स्वामी असो दिन. जब उ ओका रस्ता नी करनू करी रास हय. अरु असी टेम जेखे व्हा समजो नी हय. अय गया अरु ओखे भरी दंण्ड दिखे ओको भाग अविश्वासीहोन का सात रोख्यो जाह्ये. ");
INSERT INTO goj_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","अरु व्हा सेवक जो अपनो स्वामी की इच्छा समजतो थो. अरु तैयार नी र्‍हियो अरु नी होनकि इच्छा का अनुसार चल. खुप मार खायो ");
INSERT INTO goj_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","पन जो नी समजीखे मार खानको बरबर काम कर्‍हे व्हा. जरासी मार खाह्ये. येकालिये जेखे भोत दियो गयोस हइ. ओकासे खुप माग्यो जाह्ये; अरु जेखे खुप दि दियो गयोस हइ. ओकासे खुप लियो जह्ये. ");
INSERT INTO goj_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","मी पृथ्वी पर अंगार लगन आयोस हय; अरु का चाहुस हय फक्त ह्या कि अभी चती जस. ");
INSERT INTO goj_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","मेखे तो एक बपतिस्मा लेनो हइ; अरु जब तक व्हा नी हुयु तब तक मी कसी उत्साहीत मे र्‍हिव. ");
INSERT INTO goj_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","का तुम समजस हय कि मी पृथ्वी पर शांती करन आयोस हय? मी तुम से बोलुस हय; नी. क्युकी अल्लग करन आयो हय. ");
INSERT INTO goj_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","क्युकी आब से एक घर मे पाच झन तुमारा से विरुध रखन. तिन दो से दो तीन से. ");
INSERT INTO goj_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","बाप बेटा से. बेटो बाप से खीलाप रखह्ये; माय बेटी से अरु बेटी माय से. सासु भव से अरु भव सासु से खिलाप. ");
INSERT INTO goj_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","अरु यीशु ने गर्दी से भी बोल्यो. “जब बद्दल खे पश्चिम से उठते देखस हय. ते तुरुत बोलस हय. की बारीश हुये; अरु असो य होस हइ. ");
INSERT INTO goj_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","अरु जब दक्षिणी हवा चलती देखस हय ते तुम बोलस हय कि खुप चल्हे. अरु असो होस हइ. ");
INSERT INTO goj_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","हे कपटिहोन. तुम धरती अरु आकाश का रुप मे भेद करी सकस हय. पन यो जगत का बारेमे का भेद करनू नी समज्हे? ");
INSERT INTO goj_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“तुम खुद यो नीर्णय नी करी ले. कि अच्छो हइ? ");
INSERT INTO goj_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","जब तु अपना मुद्दा का सात न्यायाधिश का पास जय रास हइ. ते रस्ता य मी ओकासे छुटन को इजा करी ले असो नी हुये. की व्हा तोखे न्याय का पास खीची ली जाह्ये. अरु न्याय तोखे सिपय खे बन्दीगृह दि दियो अरु सिपय तोखे बंदीघर मे डाली दे. ");
INSERT INTO goj_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","मी तुम से बोलुस हय. की जब तक तु पाइ-पाइ नी चुकय दिह्ये तब तक व्हा से छुटनो नी मील्हे.” ");
INSERT INTO goj_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","वा टेम मे कुछ दुन्या अय पहुच्या. अरु ओकासे वे गलीलहोन की चर्चा करन लग्या. जिनको खुन पिलातुस ने उन मे का बलिदानहोन का सात मील्यो थो. ");
INSERT INTO goj_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","यो सुनीखे यीशु ने उनखे उत्तर मे यो बोल्यो. “का तुम समजस हय. कि यो गलीली बाकी गलीलिहोन से पापी था कि उनका पर असो पीडा मे गिर्‍यो?” ");
INSERT INTO goj_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","मी तुम से बोल्हु . कि नी पन अगर तुम मन नी फिराह्ये ते तुम सब भी या रिती से नास हुये. ");
INSERT INTO goj_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","अरु का तुम समजस हइ की वे अठरा जन जिन पर शीलोह को गुम्मट गिरियो अरु वे दबीखे मरी गया यरुशलेम का अरु सब र्‍हेनवाला से जदा गुना थो? ");
INSERT INTO goj_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","मी तुमारा से बोलुस हय. कि नी; पन अगर तुम मन नी फिराह्ये ते तुम भी सब या रीति से नास हुये ");
INSERT INTO goj_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","फिर मसीह यीशु ने यो दृष्‍टान्‍त भी बोल्यो. कोय की अंगूर की बाडि मे एक अंजीर को झाड लग्यो हुयो थो, व्हा ओमे फल ढुडन आयो. पन नी मील्यो. ");
INSERT INTO goj_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","तब ओने बाडी का रखवाली से बोल्यो. “देख तीन साल से मी यो अंजीर को झाड मे फल ढुडन अउस हइ.पन नी मालुम. येखे काटी डाल कि यो जमीन खे भी कायबर रोखी रा?” ");
INSERT INTO goj_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","ओने ओखे उत्तर दियो. कि हे स्वामी. येखे यो साल तो अरु र्‍हेन दे; कि मी येका चारी तरप खोदीखे खत डाल्हु. ");
INSERT INTO goj_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","अगर आगे फल्हे ते अच्छो. नी ते ओखे काटी देनु. ");
INSERT INTO goj_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","अराम का दिन व्हा एक आराधनालय मे उपदेस दि रोथो. ");
INSERT INTO goj_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","व्हा एक बय थी. जेखे अठरा साल से एक कमजोरी करनआली बुरी आत्मा लगी थी. अरु वा कुबडि हुय गय थी. अरु कोय रीति से सीधी नी हुय सकती थी. ");
INSERT INTO goj_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","यीशु ने ओखे देखीखे बुलायो. अरु बोल्यो. “हे बय. तु अपनी कमजोरी से छुटी गय.” ");
INSERT INTO goj_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","तब यीशु ने ओका पर हात रख्यो. अरु वा तुरुत सीधी हुय गी. अरु परमेश्वर की महिमा करन लगी. ");
INSERT INTO goj_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","येकालिये कि यीशु ने अराम का दिन ओखे अच्छो कर्‍यो थो. आराधनालय को मुखीयो रिसियाकर दुन्या से बोलन लग्यो. “छे दिन बाद हइ . जिनमे काम करनो चाहुस . येकालिये वेय दिन मे अयखे अच्छा हुया; पन अराम का दिन मे नी.” ");
INSERT INTO goj_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","यो सुनी खे प्रभु ने उत्तर दिखे बोल्यो. हे कपटिहोन. का अराम का दिन तुम मे हर एक अपना बैल अरु गधी खे खुटासे खोलीखे पानी पिलान नी लिजाय? ");
INSERT INTO goj_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","“अरु का अच्छो नी थो. कि ह्या बय जो अब्राहम की बेटी हइ. जेखे सैतान ने अठरा साल से बांधी खे रख्यो थो. अराम का दिन या बन्धन से छुटि जास?” ");
INSERT INTO goj_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","जब मसीह यीशु ने या बात बोली ते ओका सब दुसमन लाजवाने हुय गया. अरु सब बडि वा महिमा का काम से जो व्हा करतो थो. खुशी हुय जास हइ. ");
INSERT INTO goj_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","फिर मसीह यीशु ने बोल्यो. “परमेश्वर को राज्य कोय का जसो हइ? अरु मी ओकी तुलना कोकासे दिव? ");
INSERT INTO goj_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","परमेश्वर को राज रइ का दाना का जसो हइ. जेखे की इन्सान ने लिखे अपनी बाडी मे बोयो अरु व्हा बडि खे झाड हुय गयो; अरु बद्दल को पक्षिहोन ने ओकी डग्यान पर बठ्ये कि.” ");
INSERT INTO goj_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","यीशु ने फिर बोल्यो. “मी परमेश्वर को राज कि तुलना कोका से दिव? ");
INSERT INTO goj_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","व्हा खमीर का जसी हइ. जेखे कोय बय ने लिखे तिन माफ आटा मे मीलायो. अरु होते होते सब आटो खमीर हुय गयो.” ");
INSERT INTO goj_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","जब यीशु नगर-नगर. अरु गाव-गाव उपदेस देतो हुयो यरुशलेम का तरप जय रो थो. ");
INSERT INTO goj_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","अरु कोय ने पुच्छयो. “हे प्रभु. का उध्दार मीलन आला जरासा हइ? यीशु ने उनका से बोल्यो.” ");
INSERT INTO goj_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","तुमारी कोसीस या हय की तुम साकल दरवाजो से अंदर कर क्युकी मी बतय रोस हय कि भोत येमे अंदर तो चली दिया. अरु अंदर झना मे मुशकिल थी. ");
INSERT INTO goj_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","जब घर को स्वामी उठीखे दरवाजो बन्द करी चुक्योस हइ अरु तुम बाहेर खडो हुय दरवाजो ठोकिखे बोलन लग्या . हे प्रभु. हमारा लिये खोली दे कि मी तुम नी मालुम. तुम खा का आय? ");
INSERT INTO goj_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","तब तुम बोलन लगीगा. कि हमने तरा सामने खायो पियो अरु तोने हमारा बजार मे उपदेस दियो. ");
INSERT INTO goj_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","पन व्हा बोल्हे. मी तुम बोलुस हय. मी नी समजु तुम खासे हय. हे बुरोकाम करनवाला. तुम सब मरासे दुर हो. ");
INSERT INTO goj_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","व्हा रोनो अरु दात कटरनो हुये. जब तुम अब्राहम अरु इसहाक अरु याकूब अरु सब भविष्यव्दक्ताहोन खे परमेश्वर को राज मे बठी. अरु अपना आप खे बाहेर नीकली हुयो देख्ये. ");
INSERT INTO goj_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","अरु पूर्व अरु पश्चिम; उत्तर अरु दक्षिण से दुन्या अयखे परमेश्वर को राज को खाना मे मी मील्हु हय. ");
INSERT INTO goj_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","यो समजी लेव कि केतना पिछे हइ वे पैयले हुये. अरु केत्ता जो पैयले हइ पिछे हुये. ");
INSERT INTO goj_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","वय टेम मे खेतना फरीसीहोन ने अयखे यीशु से बोल्यो. “ह्या से नीकलीखे चली जा; क्युकी हेरोदेस तोखे मारी देनो चाहस हइ.” ");
INSERT INTO goj_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","यीशु ने ओकासे बोल्यो. “जयखे उ लाडग्या से बोल्यो दे. कि देख मी आज अरु कल बुरीआत्माहोन खे नीकालतो अरु बिमारी खे अच्छो करुस हइ अरु तिसरा दिन अपनो काम पुरो कर्‍हु. ");
INSERT INTO goj_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","ते भी मेखे आज अरु कल अरु परसु चलनो जरुरी हइ. क्युकी हुय नी सखे कि कोय भविष्यव्दक्ता यरुशलेम बाहेर मार्‍यो जाह्ये. ");
INSERT INTO goj_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“हे यरुशलेम! हे यरुशलेम! तु जो भविष्यव्दक्ताहोन खे मारी डालनो हइ. अरु जो तरा पास भेज्यो गयो उनखे फत्तर मारस हइ; केत्ता बार मेने यो चाह्यो. कि जसी मुर्गी अपना बच्चा खे अपना पख का नीच्चे येकजगा करस हइ. वसो मी भी तरा बच्चा खे जमा करु पर तुम ने यो नी चाह्यो. ");
INSERT INTO goj_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","देख तुमारो घर तुमारा लिये उजाड छोड्यो जास हइ. अरु मी तुम से बोलुस हय; जब तक तुम नी बोलस हय. जब तक तुम नी बोल्हे . धन्य हइ व्हा. जो प्रभु का नाम से आस हइ. तब तक तुम मेखे कभी नी देख्ये.” ");
INSERT INTO goj_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","फिर व्हा अराम का दिन फरीसीहोन को मुखियो मेसे कोय का घर मे रोटी खान गयो अरु वे ओखे मारना मे था. ");
INSERT INTO goj_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","व्हा एक इन्सान ओका सामने थो. जेखे जलोदर कि बिमारी थी. ");
INSERT INTO goj_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","येका पर यीशु ने व्यवस्था करण आला खे अरु फरीसी होन से बोल्यो. “आराम को दिन अच्छो करणो अच्छो हइ. कि नी?” ");
INSERT INTO goj_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","पन वे चुप चाप र्‍हिया तब ओने ओखे हात लगय खे अच्छो कर्‍यो. अरु जान दियो. ");
INSERT INTO goj_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","अरु उनका से बोल्यो. “तुम मे से असो कोन हइ. जेको बेटो अरु बैल कुव्वा मे गीरी जाह्ये अरु व्हा अराम का दिन ओखे तुरुत बाहेत नीकाली ले?” ");
INSERT INTO goj_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","वे या बात को कुछ उत्तर नी दि सक्हे. ");
INSERT INTO goj_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","जब ओने देख्यो. कि बुलाय हुया दुन्या कसा बडी बडि जगा चुनी लेस हइ ते एक दृष्‍टान्‍त दिखे उनका से बोल्यो. ");
INSERT INTO goj_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","जब कोय तोखे असो नी हय. कि उनसे तरा से भी कोय बडी खे नीवता दिह्ये. ");
INSERT INTO goj_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","अरु जेने तोखे अरु ओखे दो की नीवता दि हइ. अयखे तरासे बोलस. येखे जगा दे अरु तब तोखे लाजवाने हुयखे सब से नीच्चे जगापर ही बठनो पडे. ");
INSERT INTO goj_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","पर जब तुम बुलाह्ये जाह्ये. ते सबसे नीच्चे जगा जा बठी. कि जब व्हा. जेने तरासे नीवता दिया हइ आ.ते तरासे बोल्यो हे दोस्त.आगे बडीखे बठ. तब तरा सात बठनवालो, सामने तरी आदर हुये. ");
INSERT INTO goj_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","क्युकी जो कोय अपना आप खे बडो बनाह्ये व्हा छोटो कर्‍यो जाह्ये. ");
INSERT INTO goj_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","तब उनका से अपनी नीवता देनआला से भी बोल्हे. “जब तु दिन खे रात खे भेजी खे. ते अपना दोस्त अरु भैइहोन अरु कुटुम अरु दुसराआला बाजुआला खे नी बुला. असो नी तोखे नीवता दि अरु तरा बदला मे हुय जाह्ये. ");
INSERT INTO goj_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","पन जब तुम खाना को इन्तजाम कर्‍हे ते गरीब लुलो. लगडो अरु अंधा खे बुला. ");
INSERT INTO goj_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","तब तु धन्य हुये. क्युकी उनका पास तोखे बदलो देन को कुछ नी. पन तोखे धर्मी होन खे जिन्दो उठना पर येको बदलो मील्हे.” ");
INSERT INTO goj_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","उनका सात खानो खान आला मेसे एक ने या बात सुनीखे उ,से बोली. “धन्य हइ व्हा. जो परमेश्वर को राज्य मे रोटी खयली.” ");
INSERT INTO goj_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","यीशु ने उनका से. बोल्यो “कोय इन्सान ने बडो खानो दियो अरु भोत झन खे बुलायो.” ");
INSERT INTO goj_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","जब खानो तैयार हुय गयो ते सेवक का हात बुलावो दियो दुन्या खे बुलखे भेज्यो आ आब खानो तैयार हइ. ");
INSERT INTO goj_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","पर वे सब का सब माफी मागन लग्या, पैयले नी ओका से बोल्यो मेने खेत मोल लियो हइ, अरु जरुरत हइ कि ओखे देखु मी तरासे प्रार्थना करुस हय, मेखे माफ करी दे. ");
INSERT INTO goj_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","दुसरा ने बोल्यो मेने पाच जोडी बैल मोल लिखे हइ. अरु उनखे पहुचान जयरोस हय. मी तरासे प्रार्थना करुस हय. मेखे माफ करी दे. ");
INSERT INTO goj_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","एक अरु ने बोल्यो. मे ने भ्याव कर्‍योस हइ. येका लिये मी नी अय सकु. ");
INSERT INTO goj_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","उ सेवक ने अयखे अपना स्वामी की या बात बोल सुनीयो. तब घर को स्वामी ने घृस्सा मे अयखे अपनो चेला से बोल. नगर का बजार अरु गल्लिहोन मे तुरुत जयखे गरीब लुला लगडो अरु अंधो खे ह्या ली आ. ");
INSERT INTO goj_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","सेवक ने फिर बोल्यो स्वामी. जसो तोने बोल्यो थो. वोसो य कर्यो गयो हइ. फिर भी जगा हइ. ");
INSERT INTO goj_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","स्वामी ने सेवक से बोल्यो. गाव पर अरु रस्ता का तरप जयखे दुन्या खे अन्दर ली आ जब मरो घर भरी जाह्ये. ");
INSERT INTO goj_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","क्युकी मी तुम से बोलुस हय. कि वे बुलया दुन्या मे से कोय मरो खानो नी खानको. ");
INSERT INTO goj_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","अरु जब बडी गर्दी ओका सात जय री थी. ते ओने पिच्छे फिरी खे ओने बोल्यो. ");
INSERT INTO goj_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","अगर कोय मरा पासाह्ये. अरु अपना अदमी अरु माय अरु लुगइ अरु बच्चा अरु भैइहोन अरु भैइन क्युकी अपनो जीवन तक से मरा से जादा प्रेम रखस हइ. ते उ मरो चेलो नी हुय सखे. ");
INSERT INTO goj_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","अरु जो कोय अपनो क्रुस नी उठाह्ये. अरु मरा पिच्छे नी आयो. व्हा भी मरो चेलो नी हुय सकस. ");
INSERT INTO goj_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“तुम मे से कोन हइ कि मचाग बनानो चाहस हय.अरु पैयले बठीखे खर्चो नी जोडे. कि पुरो करण की सामर्थ मरा पास हइ कि नी? ");
INSERT INTO goj_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","कोय असो नी हुये जब पय्या दालीखे बनय नी सक्या. ते सब देखन आला ह्या बोलीखे ओको उपास कर्‍हे. ");
INSERT INTO goj_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","यो इन्सान बनान तो लग्यो. पन तैयार नी करी सक्यो?” ");
INSERT INTO goj_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","यो कोन असो राजो हइ. कि दुसरा राजा से वाद विवाद करण जास हय. अरु पैयले बठी खे बिचार नी करी लिह्ये कि जो बीस हजार लिखे मरा पर चडीखे आस हइ, मी दस हजार लीखे ओको जसो करी सकुस हय. कि नी? ");
INSERT INTO goj_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","नी ते ओका दुर र्‍हे तेय. व्हा दूत खे भेजी खे शांती करानो चाहस. ");
INSERT INTO goj_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","या रिती से तुम मे से जो कोय अपनो सब कुछ छोडी नी दे ते उ मरो चेलो नी हुय सखे. ");
INSERT INTO goj_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“नोन तो अच्छो हइ. पन अगर नमक को सवाद बीगडी जाह्ये. ते व्हा कोय चिज से खारो कर्‍यो जाह्ये. ");
INSERT INTO goj_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","व्हा नी ते जमीन का अरु नी खेत का लिये काम मे आस हइ. ओखे तो दुन्या बाहेर फेकी देस हइ. जेका सुनन खे कान हुये वे सुनी ले.” ");
INSERT INTO goj_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","सब चुगी लेनवाला अरु पापी दुन्या मसीह यीशु को जब कि वचन सुन्हे. ");
INSERT INTO goj_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","अरु फरीसी अरु नीयम शास्त्री खुसुर मसुर बोलन लग्या. यो तो पापीहोन से मीलस हइ अरु उनका सात खातो भी हइ. ");
INSERT INTO goj_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","तब यीशु ने उनका से यो दृष्‍टान्‍त बोल्यो: ");
INSERT INTO goj_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“तुम मे से कोन हइ जोकी सौव मेडा होन.अरु ओमे से एक गमी जाह्ये ते नन्यानवे खे मैदान मे छोडीखे. वा गमी हुइ खे जब तक मीली नी जाह्ये ढुडते नी र्‍हिया? ");
INSERT INTO goj_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","अरु जब मीली जास ते बडी खुशी से ओखे खादा पर उठय लेस हइ. ");
INSERT INTO goj_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","अरु घर मे अयखे दोस्त अरु बाजुआला खे जमा करीखे बोलस हइ ‘मरा सात खुसी कर. क्युकी मरा गम्या आला मेडा मीली गयस हइ.’ ");
INSERT INTO goj_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","मी तुम खे बोलुस हय. कि या रिती से एक मन फिराव आलो न्यायी, बारे मे भी स्वर्ग मे येत्तोय खुशी हुये. जोतनाकी नव्यानव असो न्यायीहोन, बारे नी होतो. जिनने मन फिरान कि जरुरत नी. ");
INSERT INTO goj_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“या कोन असी एक बय हुये. जेका पास दस चादी, दस सिक्काको हुये अरु ओमेसे एक गमी जाह्ये. ते व्हा दिवो जलय खे अरु घर झाडि झुडुप तक मीली नी जाह्ये. मन लगय खे ढुडती नी र्ही? ");
INSERT INTO goj_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","अरु जब मीली जास हइ. ते व्हा अपना दोस्तहोन अरु बाजु आलाहोन खे जमा करीखे बोलस हइ. कि ‘मरा सात खुशी कर. क्युकी मरो गम्यो आलो सिक्काको मीली गयोस हइ.’ ");
INSERT INTO goj_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","मी तुमसे बोलुस हय. कि या रीति से एक मन फिरानआलो पापी का बारे मे परमेश्वर को स्वर्गदूतहोन, सामने खुशी होस हइ.” ");
INSERT INTO goj_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","फिर ओने बोल्यो. कोय इन्सान, दो बेटा था. ");
INSERT INTO goj_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","उनमे से छोटा ने बाप से बोल्यो हे बाप. दौलत मे से भाग मरो हय. व्हा मेख दे दिदिह्ये. यीशु ने उनखे अपनी दौलत बाटी दी. ");
INSERT INTO goj_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","अरु भोत दिन नी बित्यो थो कि छोटो बेटो सब कुछ जमा करीखे एक दुर देस खे चली दियो अरु व्हा बुरोकरम मे अपनी दौलत उडय दी. ");
INSERT INTO goj_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","जब उ सब कुछ खर्चो करी चुक्यो. ते उ देस मे बडो एकलो हुयगयो. अरु उ गरीब हुय गो. ");
INSERT INTO goj_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","अरु उ देस का र्‍हेनाना मे से एक, ह्या गयो. यीशु ने उनका से अपना खेत मे डुक्कर चरान का लिये भेज्हे. ");
INSERT INTO goj_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","अरु उ चाहतो थो. कि वे फिल्लिहोन से जो डुक्कर खाता था अपनो पेट भर्‍हे. क्युकी ओखे कोय कुछ नी देतो थो. ");
INSERT INTO goj_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","जब व्हा अपना आप मे आयो. तब बोलन लग्या. मरा बाप का केतना य मजूरहोन खे खाना से जादा रोटी मीलस हइ. अरु मी ह्या भुको मरी रोस हय. ");
INSERT INTO goj_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","मी आब उठीखे बाप का पास जाह्यु अरु ओकासे बोल्यु कि बाप जो मे ने स्वर्ग का खीलाप अरु तरा नजर मे पाप कर्योस हइ. ");
INSERT INTO goj_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","आब यो योग्य नी र्‍हियो कि तरो बेटो बोल्यो. मेखे एक का जसो रखीले. ");
INSERT INTO goj_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","तब व्हा उठीखे. अपना बाप खे पास चला उ अभी दुर री थो. कि ओको बाप ने ओखे देखीखे दया खै. अरु भागीखे ओखे गल्ला से लगायो. अरु खुप प्पपी ली. ");
INSERT INTO goj_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","बेटा ने उकासे बोल्यो. दादा. मेने स्वर्ग का खीलाप मे अरु तरी नजर मे पाप कर्‍योस हइ. अरु आब यो योग्य नी र्‍हियो. कि तरो बेटो बोल्हे. ");
INSERT INTO goj_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","पन बाप ने अपना सेवक से बोल्यो. झल्दी से अच्छा कपडा पेनय खे नीकलीखे ओखे. अरु ओका हात मे मुद्दी. अरु पाय मे जुता पेनाव. ");
INSERT INTO goj_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","अरु बडो खानो तय्यार कर जब की हम खाया अरु खुसी मनाव. ");
INSERT INTO goj_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","क्युकी मरो यो बेटो मरी गयो थो. आब मीली गयो हइ. अरु वे खुशी मनान लगीगा. ");
INSERT INTO goj_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","पन ओको बडो बेटो खेत मे थो. अरु जब व्हा आते हुयो घर का नजीक पहुच्यो. ते ओने गानो बजानो अरु नाचन को अवाज सुन्यो. ");
INSERT INTO goj_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","अरु ओने एक सेवक खे बुलय खे पुच्छो. यो का हुय रोस हइ? ");
INSERT INTO goj_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","सेवक ने बडा भैइ बोल्यो. तरो भैइ आयोस हइ. अरु तरा बाप ने अच्छो खानो तैयार कऱ्यो हइ. क्युकी ओखे अच्छो अच्छो दिख्यो हइ. ");
INSERT INTO goj_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","यो सुनीखे उ घुस्सा से भरी गयो अरु अंदर जानो नी चायो पन ओको बाप बाहेर येखे ओखे मनान लग्यो. ");
INSERT INTO goj_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","ओने अपना बाप खे उत्तर दियो. देक. मी येतना साल से तरी सेवा करी रो थो. अरु कभी भी तरी आज्ञा नी टाली. फिर भी तोने मेखे कभी एक बकरी को बच्चो भी नी दियो. की मी अपना दोस्तहोन का सात खुशी करु. ");
INSERT INTO goj_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","पन जब तरो यो बेटो. जेने तरी पुरी दौलत वेश्याहोन मे लुटय दिये हइ. अरु उ घर मे आयो. ते ओका लिये तोने बडो खानो तैयार कऱ्यो हइ. ");
INSERT INTO goj_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","ओने ओकासे बोल्यो बेटा. तू हमेशा मरा सात हइ. अरु जो कुछ मरो हइ उ सब तरो हइ. ");
INSERT INTO goj_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","पन अभी खुशी करणो अरु मगन होनो चास क्युकी यो तरो भैइ मरी गयो थो फिर जिन्दो हुय गयो हइ. फिर उ गमी गयो थो. अभी मीली गयो. ");
INSERT INTO goj_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","फिर मसीह यीशु ने अपना नवकर खे ह्या कोय लकपती को एक दानी थो. अरु दुन्या ने उनका सामने स्वामी पर दोष लगाह्यो कि उ तरी सब दौलत उडय देस हइ. ");
INSERT INTO goj_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","येका लिये स्वामी ने ओखे ओकासे पुछताछ करी तुमारा बारे मे मी या, लिखी दे. क्युकी तु आगे से भण्डारी नी र्‍हि सक्यो. ");
INSERT INTO goj_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","तब भण्डारी सोचन लग्या. अब मी करु? क्युकी मरो स्वामी अब भण्डारी को काम मेरा से छुडान र्‍हियो हइ मरो आंग येतनो बलवान नी की मट्टी खोदी नी जाय अरु भीक मागना से मेखे लाज नी आय. ");
INSERT INTO goj_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","मी समजी गयो कि का करु क्युकी जब मी भण्डारी काम से छुडायो जाह्यु ते दुन्या मेखे अपना घरहोन मे लि ली. ");
INSERT INTO goj_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","अरु ओने अपना स्वामी का देनआला मे से एक एक खे बुलय खे पैयले से पुच्छो. कि तरा पर मरो स्वामी को खेत्तो कर्जा हइ? ");
INSERT INTO goj_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","ओने बोल्यो. सौ मन जैतुन को तेल. तब ओने उनका से बोल्यो. की अपनी खाता किताब ली अरु बठीखे तुरुत पचास लिखी दे. ");
INSERT INTO goj_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","फिर दुसरा से पुछ. तरा पर केतनो कर्जा हइ? ओने बोल्यो सौ मन गहु. तब ओने ओकासे बोल्यो. अपनी खाता किताब लीखे अस्सी लिखी दे. ");
INSERT INTO goj_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","स्वामी ने उ बुरोकाम भण्डारी खे सारा. की ओने चतुरता से काम कऱ्यो हइ. क्युकी यो जगत का दुन्या अपना टेम का दुन्याहोन का सात रीति-व्यव्हारहोन मे उजालो का दुन्याहोन से भोत चतुर हइ. ");
INSERT INTO goj_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","अरु मी तुम से बोलुस हइ. की बुरोकाम का धन से अपना लिये दोस्त बनय ले. ताकी जब उ जातो ऱ्हिहे. ते उ तुमखे अनन्त र्हेनआला मे लीखे जाये. ");
INSERT INTO goj_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","जो जरासा से जरासा मे विश्वासयोग्य हइ. उ भोत मे भी बुरो काम हइ. ");
INSERT INTO goj_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","येका लिये जब तुम जगत की दौलत मे विश्वासयोग्य नी रुख्या. ते सच्ची दौलत कोखे दि दिह्ये? ");
INSERT INTO goj_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","अरु अगर तुम दुसरा की दौलत मे विश्वासयोग्य नी रुख्ये ते जो तुमारो हइ. ओखे तुमखे कोन दिह्ये? ");
INSERT INTO goj_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“कोय सेवक दो स्वामीहोन कि सेवा नी करी सक्हे क्युकी व्हा तो एक से मील्यो र्‍हिये अरु दुसरा खे कमजोर समज्हे तुम परमेश्वर अरु दौलत दो की सेवा नी करी सखे.” ");
INSERT INTO goj_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","फरीसी जो लोभी था. ये सब बात सुनीखे यीशु की हसी उडान लग्या. ");
INSERT INTO goj_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","यीशु ने उनका से बोल्यो. तुम तो इन्सान का सामने अपना आप खे न्यायी ठेरास हय. पन परमेश्वर तुमारा मन खे समजस हइ. क्योकि जो चिज इन्सानहोन कि नजर मे बडी हइ. उ परमेश्वर का नजर मे बुरी हइ. ");
INSERT INTO goj_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","जब तक यहून्ना आयो. तब तक व्यवस्था अरु भविष्यव्दक्ता दबाव मे था. वा टेम से परमेश्वर को राज को सुसमाचार सुनायो जय रोस हइ. अरु हर कोय ओमे प्रबलता से अंदर करस हइ. ");
INSERT INTO goj_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","बद्दल अरु पृथ्वी को खतम होय जान व्यवस्था एक टिम्बो का मीनीट जाना से सहज हइ. ");
INSERT INTO goj_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“जो कोय अपनी लुगइ खे छोडी खे दुसरी का सात भ्याव करस हइ. व्हा व्यभिचार करस हइ. अरु जो कोय असी छोडी वाली हुइ बय से भ्याव करस हइ. व्हा भी व्यभीचार करस हइ.” ");
INSERT INTO goj_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“एक लकपती इन्सान थो जो जामडा कपडा अरु मलमल पेनतो अरु हर एक दिन सुख विलास अरु धुम धाम का सात र्‍हेतो थो. ");
INSERT INTO goj_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","अरु लाजर नाम को एक गरीब घाव से भर्‍यो हुयो ओका दरवाजा पर छोडी दियो जातो थो. ");
INSERT INTO goj_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","अरु उ चाहतो थो. कि लकपती कि टेबल पर कि जुठा से अपनो पेट भर. क्युकी कुत्तो भी अयखे ओका घाव खे चाटतो थो.” ");
INSERT INTO goj_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","अरु असो हुयो कि गरीब मरी गयो. अरु स्वर्गदूतहोन ने ओखे लिखे अब्राहम का खोरा मे पहुचय दियो. अरु व्हा लकपती भी मर्‍यो अरु गाड्यो गयो. ");
INSERT INTO goj_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","अरु दुन्या मे ओने दुख मे पड्या हुयो अपनी आख उठइ. अरु दुर से अब्राहम का खोरा मे लाजर खे देख्यो. ");
INSERT INTO goj_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","अरु ओने फुकारी खे बोल्यो. हे बाप अब्राहम. मरा पर दया करीखे लाजर खे भेजी दे. जब की व्हा अपनी उगली का सिरो पाणी मे भिजय खे मरी जिब खे ठडी कर. क्युकी मी या अंगार मे तडपीरोस हय. ");
INSERT INTO goj_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","पन अब्राहम ने बोल्यो. हे बेटा याद कर. कि तु अपना जिवन काल मे अच्छी चिज मीली गइ हइ. अरु ओसो ही लाजर बुरी चिजहोन पन अब ह्या शांती मीली री हइ. अरु तू तडपी रोस हइ. ");
INSERT INTO goj_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","अरु या बात खे छोडी खे हमारा बिच एक बडी खे रखी गइ हइ कि जो ह्या से वा पार तुमारा पास जानो चाह्ये. वे नी जय सक्या. अरु नी कोय व्हा से या पार हमारा पास अय सक्हे. ");
INSERT INTO goj_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","ओने बोल्यो ते हे बाप मी तरासे प्रार्थना करुस हुइ. कि तु ओखे मरा बाप का घर भेज. ");
INSERT INTO goj_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","क्युकी मरा पाच भैइ हइ. व्हा उनका सामने या बात की गवाही दि. असो नी हुये कि वे भी यो दुख कि जगा मे आये. ");
INSERT INTO goj_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","अब्राहम ने उनका से बोल्यो. उनका पास तो मूसा अरु भविष्यव्दक्ताहोन कि किताब हइ. वे उनकी सुन्हे. ");
INSERT INTO goj_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","ओने बोल्यो. नी. हे बाप अब्राहम. पर अगर कोय मर्‍या हुया मे से उनका पास जाह्या. ते वे मन फिराह्ये. ");
INSERT INTO goj_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","यीशु ने उनका से बोल्यो. जब वे मूसा अरु भविष्यव्दक्ताहोन की नी सुनता. ते अगर मर्‍या हुया मे से कोय भी जिन्दो उठ्यो ते भी ओकी नी मान्हे. ");
INSERT INTO goj_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","फिर यीशु सेवक से बोल्यो. “यो पक्को हइ कि वे बात जो बाप को कारण हइ. पन ह्या. उ इन्सान पर जिनको कारण वे आस हइ.” ");
INSERT INTO goj_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","जो या छोटा मे से कोय एक खे ठोकर खलास हइ. ओका लिये यो अच्छो होस कि चक्की को पाट ओका गल्ला मे लटकायो जास. अरु उ समुद्र मे डाली दियो जास. ");
INSERT INTO goj_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","जागा र्‍हेव. अगर तरो भैइ पाप कर्‍हे ते ओखे धमका अरु अगर पछतावो होस ते ओखे माफ कर. ");
INSERT INTO goj_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","अगर दिन भर मे व्हा सात बार तरो पाप कर्‍हे अरु सात बार तरा पास मेखे बोल्हे. कि मी पछतावो होस हय ते ओखे माफ कर. ");
INSERT INTO goj_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","तब प्रेरितहोन ने प्रभु से बोल्यो. “हमारो विश्वास बडा.” ");
INSERT INTO goj_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","प्रभु ने बोल्यो. अगर तुम खे रइ का दाना का बराबर भि विश्वास हुये ते तुम यो शहतूत का झाड से बोलस की जडी से उखडी खे समुद्र मे लगी जाते व्हा तुमारो मानी जाये. ");
INSERT INTO goj_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“मानलो तुम मे से असो कोन हइ. जोको सेवक नागर जोतस. अरु मेडा खे चरास हइ. अरु जब उ खेत मे आस. ते ओकासे बोलस. झल्दी अयखे खानो खान बठी जा? ");
INSERT INTO goj_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","का उ ओका से नी बोलस. की मरो खानो तैयार कर अरु जब तक मी खाउ पीयु तब तक कमर बाधीखे मरी सेवा कर. येका बाद मे तू भी खा अरु पी ले?” ");
INSERT INTO goj_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","का व्हा ओको सेवक का धन्यवाद मागे. कि ओने यो काम कर्‍यो जोकी आज्ञा दी गय थी? ");
INSERT INTO goj_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","या रीति से तुम भी. जब वे सब काम खे करी चुक्या हुये जिनकी आज्ञा तुमखे दी गइ थी. ते बोल्हे. हम नीकम्मा सेवक हइ. कि जो हमखे करण खे होनु थो उ कर्योस हइ. ");
INSERT INTO goj_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","फिर जब यीशु यरुशलेम जय रो थोते जो सामरिया अरु गलील देस कि सीमा से हुयखे जय रा था. ");
INSERT INTO goj_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","अरु कोय गाव मे घुसनो करतो थो टेम वे दस कोढी मील्हे. ");
INSERT INTO goj_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","अरु उनने दुर खडो हुयखे. उच्चा आवाज से बोल्यो. “हे यीशु. हे स्वामी. हम पर दया कर.” ");
INSERT INTO goj_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","यीशु ने उनखे देखीखे बोल्यो. “जाव. अरु अपना आपखे याजक खे बतायो.” अरु जातेय जाते वे अच्छो हुय गयो. ");
INSERT INTO goj_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","तब उनका मेसे एक ह्या देखीखे कि मी अच्छो हुय गयो हय. उच्चा आवाज से परमेश्वर की महिमा करते हुयो पलट्यो. ");
INSERT INTO goj_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","अरु यीशु का पाय पर मुडा का उप्पर गिरीखे ओको धन्यवाद करण लग्या. अरु व्हा सामरी थो. ");
INSERT INTO goj_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","येका पर यीशु ने बोल्यो. “का दस अच्छो नी हुये. ते फिर वे नौ बोल्या? ");
INSERT INTO goj_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","का या परदेसी खे छोडी कोय अरु नी नीकाली. जो परमेश्वर की महिमा करतो?” ");
INSERT INTO goj_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","तब यीशु ने उनका से बोल्यो. “उठीखे चलते जा. तरो विश्वास अच्छो कर्‍यो हइ.” ");
INSERT INTO goj_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","जब फरीसीहोन ने ओकासे पुच्छो. की परमेश्वर को राज प्रगट रुपी मे नी आतो. ");
INSERT INTO goj_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","अरु दुन्या ह्या नी कर्‍हे. कि देख ह्या हइ. यो व्हा हइ. क्युकी. परमेश्वर को राज तुमारा बिच मे हइ. ");
INSERT INTO goj_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","अरु ओने सेवक होन से बोल्यो. “वे दिन आह्ये जिनमे तुम इन्सान को बेटा का दिन मे से एक दिन खे देखनो चाह्ये, अरु नी देखनो पाये. ");
INSERT INTO goj_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","दुन्या तुम से बोल्हे देख व्हा हइ.” यो देख ह्या हइ. पन तुम चल नी जानो अरु नी उनका पीछे हुये लेनु . ");
INSERT INTO goj_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","क्युकी जसो बिजली बद्दल की दुसरी तरप तक चमकी हइ. वोसो य इन्सान को बेटा भी अपना दिन मे प्रगट हुये. ");
INSERT INTO goj_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","पन पैयले यो जरुरती हइ. कि व्हा खुप तकलीप उठाय अरु यो जमाना का दुन्या ओखे बुरो रुखीजा. ");
INSERT INTO goj_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","जसो नूह का दिन मे हुयो थो. वोसो य इन्सान का बेटो का दिन मे भी हुये. ");
INSERT INTO goj_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","जो दिन तक नूह डोंगा परनी चडी ओका दिन तक दुन्या खाता पीता था. अरु उनमे भ्याव शादी होते थी तब पाणी प्रलय ने अयखे वे सब को नास कर्‍यो. ");
INSERT INTO goj_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","अरु जसो लुत का दिन मे हुयो थो. कि दुन्या खाता पिता लेन देन करता. झाड लगाता अरु घर बनाता था. ");
INSERT INTO goj_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","पर जिस दिन लुत सदोम से नीकल्यो उ दिन अंगार अरु गन्धक बद्दल से बारीश अरु सब खे नाश करी दियो. ");
INSERT INTO goj_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","इन्सान का बेटा को प्रगट होन का दिन भी असो य हुयो. ");
INSERT INTO goj_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“उ दिन जो छपर पर हय. अरु ओका जसो घर मे हय. व्हा ओखे लेन खे नी उतर्‍हो. अरु वोसोय जो खेत मे हय व्हा पीच्छे नी पलट्यो. ");
INSERT INTO goj_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","लुत कि लुगय खे याद रख. ");
INSERT INTO goj_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","जो कोय अपनो जान बचानो चाह्ये व्हा ओखे गमाह्ये. अरु जो कोय ओखे व्हा ओखे बचाह्ये. ");
INSERT INTO goj_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","मी तुमारा से बोलुस वा रात दो इन्सान एक खटीया पर हुये एक लि लियो जाह्ये. अरु दुसरो छोडी दियो जह्ये. ");
INSERT INTO goj_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","दो बय एक सात चक्की पिसती हुये. एक ली ली जाह्ये. अरु दुसरी खे छोडी दिह्ये जाह्ये. ");
INSERT INTO goj_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","दो झन खेत मे हुये एक ली लियो जाह्ये अरु दुसरी छोडी जाह्ये.” ");
INSERT INTO goj_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","ह्या सुन उनने ओकासे पुच्छो. हे प्रभु ह्या खा हुये. यीशु ने उनका से बोल्यो. “झा लास हइ. व्हा घुब्बड जमा हुये.” ");
INSERT INTO goj_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","फिर यीशु ओका बारे मे कि हमेशा प्रार्थना करणु अरु साहस नी छोडनु चाहिये यो दृष्‍टान्‍त बोलीयो. ");
INSERT INTO goj_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","कोइ गाव मे एक न्याय करणआलो रेतोथो. जो नी परमेश्वर से डरतो थो अरु नी कोइ इन्सान की परवाह करतो थो. ");
INSERT INTO goj_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","अरु वु गाव मे एक विधवा भी रहती थी जो ओका पास अय अयखे बोलते र्‍हिथी थी. “मरो न्याय चुकय खे मेखे बदनामी से बचा. ");
INSERT INTO goj_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","ओने खे तना टेम मे तक नी मानीयो पन मे मन मे विचार करीरो थो अगर मे ने परमेश्वर से डरुस अरु न इन्सान की कोइ परवाह करु मी.” ");
INSERT INTO goj_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","फिर भी या विधवा, वजेसे मेखे सताती ऱ्हीहे हइ येका लिये मी ओको न्याय चुकये. कही असो न हो कि घडी घडी अयखे अन्त मे अयखे मरी नाक मे दम कर्हे. ");
INSERT INTO goj_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","प्रभु ने बोलियो. सुनो कि ह्या बुरोकाम न्याय को बोलस हे. ");
INSERT INTO goj_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","आखरी का परमेश्वर अपना चुन्या हुयो, न्याय न चुकय खे जो रात दिन ओकी दुवा देतो रिये अरु का वु ओका विषय मे देर करीये. ");
INSERT INTO goj_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","मी तुम से बतायु की व्हा तुरुत उनको न्याय चुकय खे पर इन्सान को बेटा जब आह्ये. ते कावु पृथ्वी पर विश्वास पाए. ");
INSERT INTO goj_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","अरु ओने ओखे जो अपना उपर भरोसो रखीये ते कि हम धर्मी हइ अरु दुसरा खे तुच्छ जानता हुये दृष्‍टान्‍त बोलीयो. ");
INSERT INTO goj_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","दो इन्सान मन्‍दिर मे प्रार्थना करण का लिये गया एक फरीसी थो अरु दुसरो चुगी लेनवालो. ");
INSERT INTO goj_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","फरीसी खडो हुइखे अपना मन मे प्रार्थना करण लगीयो. हे परमेश्वर मी तरो धन्यवाद करुस कि मी अरु इन्सान का जसो बुरो काम करणआला अन्याय अरु व्यभिचार नी अरु नी यो चुगी लेनवालो का जसो हुये. ");
INSERT INTO goj_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","मी हप्ता मे दो बार उपास करुस हय अरु अपनी सब कमय को दसवो भाग दिवस हय. ");
INSERT INTO goj_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","पन चुगी लेनवाला ने दुर खडो हुयखे. स्वर्ग का तरप आख उठान भी नी चाह्यो. क्युकी अपनी छाती ढुकी खे बोल्यो. हे परमेश्वर मेखे पापी पर दया कर्हे. ");
INSERT INTO goj_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","मी तरा से बोल्यो हय. कि व्हा दुसरो नी. पन ह्या इन्सान धर्मी रखनो अरु अपना घर मे गयो. क्युकी जो कोय अपना आप खे बडो बनी गया. अरु जो अपना आप खे छोटो कर्यो उ बडो कऱ्यो जाये. ");
INSERT INTO goj_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","फिर दुन्या अपना बच्चा खे भी ओका पास लान लग्या कि व्हा उन पर हात रख्ये. अरु सेवक ने देखी खे उन खे धमकय. ");
INSERT INTO goj_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","यीशु बच्चा खे नजीक बुलय खे बोल्यो. बच्चाहोन खे मरा पास आन दे. अरु ओखे मना नी करणु क्युकी परमेश्वर को राज असो येका हइ. ");
INSERT INTO goj_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","मी तरासे सच्ची बोलुस हय. कि जो कोय परमेश्वर का राज खे बच्चा का जसो अपनायो नी कर्‍यो व्हा ओमे कभी अंदर करणो नी मील्यो. ");
INSERT INTO goj_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","कोय ने मुखियो ने ओकासे पुच्छ हे अच्छो गुरु अनन्त जिवन को अधिकार होन का लिये मी, करु? ");
INSERT INTO goj_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","यीशु ने ओकासे बोल्यो. “तू मेखे अच्छो का बोलस हइ? कोय अच्छो नी फक्त एक अगर परमेश्वर. ");
INSERT INTO goj_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","तु आज्ञाहोन खे तो जानस हइ व्यभिचार नी करणो मारनो नी करण को चोरी नी करणु झुटी गवय नी देनु अपनो बाप अरु अपनी माय को सम्मान करणो.” ");
INSERT INTO goj_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","ओने बोल्यो. “मी तो यो सब खे लाड को यो ह्या से समजते हुया हय.” ");
INSERT INTO goj_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","ह्या सुन. “यीशु ने ओकासे बोल्यो. तुम मे आब भी एक बात की कमी हइ. अपनो सब कुछ बेचीखे गरीब खे बाटी दे. अरु तोखे स्वर्ग मे धन मील्हे. अरु अय खे मरा पिच्छे चल.” ");
INSERT INTO goj_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","व्हा यो सुनी खे खुप उदास हुयो. क्युकी व्हा बडो लखपती थो. ");
INSERT INTO goj_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","यीशु ने ओखे देखी खे बोल्यो. “लकपती खे परमेश्वर का राज्य मे जायो करणो खेत्तो कठीन हइ!” ");
INSERT INTO goj_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","परमेश्वर को राज्य मे धनवान खे अंदर करणा से उट कि सुइ का नाक मे से नीकली जानो सहज हइ. ");
INSERT INTO goj_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","अरु सुननवाला ने बोल्यो. “ते फिर कोय को उध्दार हुये सकस हइ?” ");
INSERT INTO goj_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","ओने बोल्यो. “जो इन्सान से नी हुय सकस. व्हा परमेश्वर से हुये सकस हइ.” ");
INSERT INTO goj_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","पतरस ने बोल्यो. “देख.हम तो घर बार छोडी खे तरा पीछे चली दिया हइ.” ");
INSERT INTO goj_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","“ओने,” यीशु से बोल्यो, “मी तुम से सच्ची बोलुस हय कि असो कोय नी जेने परमेश्वर को राज्य का लिये घर को या लुगय का अरु भैइहोन का अरु बच्चा बच्चाहोन खे छोडी दिया हय. ");
INSERT INTO goj_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","अरु या टेम्म कोय जादा नी मील्यो अरु पयलो मे अनन्त जिवन.” ");
INSERT INTO goj_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","फिर ओने बाराहोन खे सात लिखे बोल्यो. हम यरुशलेम खे जास हइ. अरु जास हइ. अरु जेत्ती बात इन्सान को बेटा का लिये भविष्यव्दक्ताहोन का द्वारा लिख्यी गइ वे सब पुरी हुये. ");
INSERT INTO goj_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","ओखे गैरयहूदीहोन खे दि दियो जाये ओको उपहास हुय जाये ओको अपमान हुय जाये ओपर थुकियो जाये. ");
INSERT INTO goj_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ओखे कोडो लगान का बाद उ ओखे मरी डालिये अरु वे तीसरो दिन मरे हुयो मे से जिन्दो हइ जाये. ");
INSERT INTO goj_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","बच्चाहोन खे कुछ भी समज मे नी आयो उनसे एको अर्थ लुकय खे रखियो गयो थो यो विषय मे मसीह यीशु कि कही बात बच्चाहोन की समझ से परे थी. ");
INSERT INTO goj_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","जब मसीह यीशु यरीहो का पास पहुच्या ओखे एक अंन्धो मीलीयो जो रस्ता का किनारा बठ्यो हुयो भिक्षा मागी रो थो. ");
INSERT INTO goj_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","अरु व्हा गर्दी कि चलन की आवाज सुनीखे पुछन लग्यो. “ह्या, हुय रोस हइ?” ");
INSERT INTO goj_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","उनने ओखे बतायो. “यीशु नासरी जय रोस हइ.” ");
INSERT INTO goj_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","तब ओने फुकारी खे बोल्यो. “हे यीशु. दाउद की सन्तान. मरा पर दया कर.” ");
INSERT INTO goj_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","जो आगे आगे जय रा था. वे ओखे धमकान लग्या कि चुप र्‍हे पन व्हा अरु भी चिल्लान लग्या. “हे दाउद कि सन्तान. मरो पर दया कर.” ");
INSERT INTO goj_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","तब यीशु ने खडो हुयखे आज्ञा दी कि ओखे मरा पास लाव. अरु जब व्हा नजीक आयो. ते ओकासे यो पुछ्यो. ");
INSERT INTO goj_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","तु, चाहस हइ. “मी तरा लिये का करु?” ओने बोल्यो. “हे प्रभु. यो कि मी देखन लग्यो.” ");
INSERT INTO goj_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","यीशु ने ओकासे बोल्यो, देखन लग्या. तरो विश्वास ने तोखे अच्छो करी दियोस हइ. ");
INSERT INTO goj_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","अरु उ तुरुत देखन लग्यो अरु परमेश्वर कि महिमा करतो हुयो. ओका पीछे हुयो. ओका पीछे हुय लियो. अरु सब दुन्या ने देखी खे परमेश्वर की महिमा करी. ");
INSERT INTO goj_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","व्हा यरीहो मे घुसी खे जय रो थो. ");
INSERT INTO goj_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","व्हा जक्कइ नाम एक इन्सान थो. जो चुंगी लेनवालो को मुखियो अरु लखपती थो. ");
INSERT INTO goj_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","व्हा यीशु खे देखनो चाहतो थो कि व्हा कोयन सो हइ? पन गर्दी को करण देखी नी सक्यो थो.क्युकी उ ठेगनो थो. ");
INSERT INTO goj_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","तब ओखे देखन का लिये व्हा आगे भागीखे एक गुल्लेर का झाड पर चेडी गयो. क्युकी यीशु ओकी रस्ता से समजनआलो थो. ");
INSERT INTO goj_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","जब यीशु वा जगा पहुच्यो. ते उपर नजर करी खे ओकासे बोल्यो. “हे जक्कइ. झल्दी उतरीखे आ. क्युकी आज मेखे तरा घर मे र्‍हेनो जरुरती हइ.” ");
INSERT INTO goj_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","उ तुरुत उतरीखे खुशी से ओखे अपना घर खे ली गयो. ");
INSERT INTO goj_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","यो देखी खे सब झन खुसुर मसुर बोलन लग्या. “व्हा तो एक पापी इन्सान का ह्या गयो हइ.” ");
INSERT INTO goj_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","जक्कइ ने खडो हुयखे प्रभु से बोल्यो. “हे प्रभु. देख मी अपनी आदी दौलत गरीब खे दिवस हय. अरु अगर कोय को कुछ भी बुरो करण खे ली लियो हइ ते ओखे चार बुरो फेरी देस हय.” ");
INSERT INTO goj_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","तब यीशु ने ओकासे बोल्यो. “आज यो घर मे उध्दार आयो हइ. येका लिये कि ह्या भी अब्राहम को एक बेटो हइ. ");
INSERT INTO goj_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","क्युकी इन्सान को बेटो गमी गोस हय खे ढुडन अरु उनको उध्दार करण आयोस हइ.” ");
INSERT INTO goj_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","जब वे या बात सुनी राथा, ते ओको एक दृष्‍टान्‍त बोल्यो. येका लिये कि व्हा यरुशलेम का नजिक थो, अरु वे समजतो थो. कि परमेश्वर को राज अभी प्रगट होनआलो हइ. ");
INSERT INTO goj_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","अन्नत मे ओने बोल्य. एक लखपती इन्सान दुर देस खे चल्यो जब की राजपद मीली खे पलटी आया. ");
INSERT INTO goj_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","अरु ओने अपना सेवक मे से दस खे बुलखे ओखे दस सिक्का दि दिया. अरु ओने बोल्यो. मरा पलटी के आना तक लेन देन करनु. ");
INSERT INTO goj_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","पन ओका नगर का र्‍हेनवाला ओकासे बुरो करता था. अरु ओकासे पिछे दूत का द्वारा बुलवो भेज्यो. कि नी चाह्यो थो. कि ह्या हम पर राज कर्‍हे. ");
INSERT INTO goj_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“जब व्हा राजपद अपना सेवक खे पलटी खे आयो. ते असो हुयो कि ओने अपना सेवक को जेने पैसा दिया था. अपना पास बुलायो जब मालुम कर्‍यो कि उनने लेन देन से का-का कमायो.” ");
INSERT INTO goj_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","तब पैयला ने अयखे बोल्यो. हे स्वामी. तरा सिक्का से दस अरु सिक्का कमाया हइ. ");
INSERT INTO goj_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","यीशु ने उनका से बोल्यो. हे अच्छो सेवक. तु धन्य हइ. तु खुप हय थोडा मे विश्वासयोग्य नीकल्यो अब दस नगर को अधिकार रख. ");
INSERT INTO goj_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","दुसरा ने अयखे बोल्यो. हे स्वामी. तरा सिक्का से पाच अरु सिक्का कमाया हइ. ");
INSERT INTO goj_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","यीशु ने ओकासे बोल्यो. तु भी पाच नगरहोन पर अधिकार रख. ");
INSERT INTO goj_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","तिसरा ने अयखे बोल्यो. हे स्वामी. देख. तरो सिक्को यो हइ. जेके मेने कपडो मे बाध्यो रख्यो थो. ");
INSERT INTO goj_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","क्युकी मी तरा से डरतो थो. येका लिये कि तु कठुर इन्सान हइ. जो तोने नी रख्यो ओखे उठय लेस हइ. अरु जो तोने नी बोयो. ओखे काटस हइ. ");
INSERT INTO goj_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","स्वामी ने उनका से बोल्यो. ओ बुरो सेवक. मी तरा य मेडासे तोखे दोस्ती रुखस हय. ते मेखे समजतो थो कि कठुर इन्सान हय. जो मेने नी रख्यो ओखे उठय लेतो. अरु जो मेने नी बोयो. ओखे काटस हय. ");
INSERT INTO goj_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","ते तोने मरा पैसा पेटीपर काय बर रख्या, क्युव नी रख्या दिया. कि मी अयखे ब्याज सम्मत ली लेतो? ");
INSERT INTO goj_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","अरु जो दुन्या नजीक खडा था. यीशु ने उनका से बोल्यो. व्हा सिक्का ओकासे ली ले. अरु जेका पास मे दस सिक्का हइ ओखे दि दे. ");
INSERT INTO goj_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","उनने ओकासे बोल्यो. हे स्वामी. ओका पास दस सिक्का तो हइ. ");
INSERT INTO goj_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","मे ने तुम से बोलुस हइ. कि जेका पास हइ ओखे अरु दियो जाह्ये. अरु जिनका पास नी. ओखे व्हा भी जो ओका पास हइ लि लियो जाह्ये. ");
INSERT INTO goj_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","पन मरा वे दुसमनहोन खे जो नी चाहतो थो कि मी उन पर राज कर्‍हयु. उनखे यो लयखे मरा सामने मारी डाल. ");
INSERT INTO goj_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","या बात बोलीखे व्हा यरुशलेम का तरप उनका आगे आगे चल्यो. ");
INSERT INTO goj_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","अरु जब व्हा जैतून नाम टेकडा पर बैतफगे अरु बैतनीय्याह का पास पहुच्या. ते ओने अपना सेवक मे से दो खे यो बोलीखे भेज्यो. ");
INSERT INTO goj_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“सामने का गाव मे जाव अरु ओमे पहुचते य एक गधी को बच्चो जेका पर कभी कोय बठ्यो नी. बाध्यो हुयो मील्हे. ओखे खोली खे लाओ. ");
INSERT INTO goj_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","अगर कोय तुमारा से पुछे कि खबर खोलस हय. ते यो बोली देनू. कि प्रभु खे येकी जरुरत हइ.” ");
INSERT INTO goj_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","जो भेज्या गया था. उनने जेखे जसो यीशु ने उनका से बोल्यो थो. वसो य मील्यो. ");
INSERT INTO goj_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","जब वे गधी का बच्चा खे खोली राथा. ते ओको स्वामी ने उनका से पुछ्य. “यो बच्चा खे क्यु खोलस हइ?” ");
INSERT INTO goj_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","उनने बोल्यो. “प्रभु खे येकी जरुरत हइ.” ");
INSERT INTO goj_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","वे ओखे यीशु का पास ली आया अरु अपना कपडा ओका बच्चा पर डालीखे यीशु खे ओका पर बठाडी दियो. ");
INSERT INTO goj_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","जब व्हा जा र्‍हीयो थो. ते वे अपना कपडा रस्ता मे बिछाता जाता था. ");
INSERT INTO goj_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","अरु नजीक आते हुयो जब व्हा जैतून पहाड की छेडा पर पहुचयो. ते सेवक कि सब मंडली वे सब सामर्थ्य काम को करण जो उनने देख्यो थो. खुशी हुयखे बडो आवाज से परमेश्वर कि स्तुती करण लग्या ");
INSERT INTO goj_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","धन्य हइ उ राजो. जो प्रभु, नाम से आस हइ! बद्दल मे शांती अरु आ,श मे महिमा हुये! ");
INSERT INTO goj_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","तब गर्दी मे से खे तना फरीसी ओकासे बोलन लग्या. “हे गुरु. अपना सेवक खे धमकय.” ");
INSERT INTO goj_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","यीशु उत्तर दिया. “मी तुम मे से बोलुस हय. अगर ये चुप र्‍हिये. ते फत्तर चिल्लाय उठ्ये.” ");
INSERT INTO goj_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","जब उ नजीक आयो ते नगर खे देखीखे ओका पर रोयो. ");
INSERT INTO goj_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","अरु बोल्यो “ का अच्छो होतो. कि तू. हव. तू ही. यो दिन मे शांती कि बात जानस. पन अब वे तरी आख से लुकी गया हइ. ");
INSERT INTO goj_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","क्युकी वे दिन तरा पर आह्ये कि तरा दुशमन तो बांधीखे तोखे घेरी लीह्ये. अरु चारी तरप से तोखे दबाह्ये. ");
INSERT INTO goj_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","अरु तोखे अरु तरा सात तरा बच्चाहोन खे. मट्टी मे मीलाह्ये. अरु तरा मे फत्तर पर फत्तर भी नी छोडह. क्युकी तोने उ अवसर जब तरा पर कृपानजर करी गय नी पहीछान्यो.” ");
INSERT INTO goj_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","तब व्हा आराधनालय मे जयखे बेचनआला खे बाहेर नीकालन लग्या. ");
INSERT INTO goj_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","अरु उनका से बोलन. “लिख्यो हइ. मरो घर प्रार्थना को घर हुये. पन तुम ने गुनडाहोन को घर बनय दिह्ये.” ");
INSERT INTO goj_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","अरु व्हा दरोज आराधनालय मे उपदेस देतो थो अरु प्रधान याजक अरु शास्त्री अरु दुन्या को प्रमुख खे यीशु खे मारी डालन को अवसर ढुढतो थो. ");
INSERT INTO goj_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","पन कोय उपाय नी नीकली सक्योल. कि ह्या कोय रग कर्‍हे. क्युकी सब दुन्या बडी चाह से ओकी सुनता था. ");
INSERT INTO goj_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","एक दिन जब यीशु आराधनालय मे थो अरु दुन्या खे सुसमाचार दिरो थो. तब महान याजक अरु कानून को शिक्षक. बुजरुक नेता का सात मीलीखे आया. ");
INSERT INTO goj_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","उनोने ओकासे पुछो. की “हमखे बताव. तु यो काम कोका अधिकार से करस हइ” अरु उ कोन आय जेने तोखे यो अधिकार दियो थो, ");
INSERT INTO goj_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","यीशु ने उनखे उत्तर दियो. “अब मी एक बात पुछस हय. मेखे बताव. ");
INSERT INTO goj_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","का यहून्ना खे बपतिस्मा देन को अधिकार स्वर्ग से कि इन्सानहोन से थो?” ");
INSERT INTO goj_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","वे आपस मे बात चित करण लग्या. हम का बोल्ह्या? अगर हम बोलस हइ “स्वर्ग का तरप से, उ बोल्हे का तब का तुमने योहन पर विश्वास नी कर्‍यो?” ");
INSERT INTO goj_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","अरु अगर हम बोल्ह्या. इन्सानहोन से. ते या पुरी गर्दी फत्तर मारहस हइ. क्युकी वे सच्ची उनखे भरोसो हइ कि यहून्ना भविष्यव्दक्ता मानस थो. ");
INSERT INTO goj_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","येकालिये यणे उत्तर दियो. “कि हम नी जानस. की उ को का तरप से थो.” ");
INSERT INTO goj_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","यीशु ने उनका से बोल्यो. “ते मी भी तुमखे नी बतउस की मी यो काम कोका अधिकार से करुस हइ.” ");
INSERT INTO goj_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","तब उ दुन्याहोन से यो दृष्‍टान्‍त का बारे मे बोलन लग्यो. की एक इन्सान ने अंगूर की बाडि लगइ. अरु किसानहोन खे ओको ठेको दी दियो अरु भोत दिन का लिये दुसरा देस मे चली गयो. ");
INSERT INTO goj_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","फल का टेम पर ओने किसानहोन का पास अपना एक सेवक खे भेज्यो. की उ अंगूर की बाडि का कुछ फल को भाग ओखे दीदे. पर किसानहोन ने ओखे मारीखे खाली हात भेजी दियो. ");
INSERT INTO goj_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","फिर ओने दुसरा सेवक खे भेज्यो. अरु किसानहोन ने ओखे भी मारीखे अरु ओको अपमान करीखे खाली हात भेजी दियो. ");
INSERT INTO goj_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","फिर ओने तीसरा दास खे भेज्यो. किसानहोन ने ओखे भी घायल करीखे बाहेर नीकाली दियो. ");
INSERT INTO goj_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","तब अंगूर की बाडि को स्वामी ने बोल्यो. “अब मी का करु? मी अपना लाड का बेटा खे उनका पास भेजू. का जाने वे ओको सम्मान कर्‍हे.” ");
INSERT INTO goj_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","जब किसानहोन ने ओखे देख्यो ते आपस मे बिचार बरन लग्या. यो तो वारिस हइ. आ. हम येखे भी मारी डालस. जोकासे या सम्पत्ती हमारी हुये जाये. ");
INSERT INTO goj_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","अरु किसानहोन ने ओखे अंगूर की बाडि से बाहेर नीकाली खे मारी डालयो येकालिये अंगूर का बागीचा को स्वामी उनका साथ का कर्‍हे? ");
INSERT INTO goj_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","व्हा अयखे वे कास्तकार को नास कर्हे. अरु अंगूर की बाडि दुसरा खे दिदियो. यो सुनीखे उनने बोल्यो. “परमेश्वर असो नी करणू.” ");
INSERT INTO goj_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","यीशु ने उनका तरप देखीखे बोल्यो. फिर ह्या का लिख्यो हइ जो फत्तर खे राजमिस्त्रीहोन ने बुरो समज्यो थो. उये कोना को आधार हुय गयो. ");
INSERT INTO goj_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","जो कोय उ पत्थर पर गिरी गयो उ चकनाचुर हुये जाये. अरु जोका पर उ गिर्‍हे. ओखे पिसी डाल्हे. ");
INSERT INTO goj_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","वय टेम शास्त्रिहोन अरु मुखियो याजक ने ओखे पकडनो चाह्यो. क्युकी समजी गया था. कि यीशु ने उनका खीलाप दृष्‍टान्‍त बोल्य. पन वे दुन्या से डर. ");
INSERT INTO goj_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","अरु वे ओकी ताक मे लग्या अरु भेदिया भेज्या. कि धर्मी का भेस पेनीखे ओकी कोय नी कोय बात पकडि. कि ओखे राज्यपालका हात अरु अधिकारी ही दि दे. ");
INSERT INTO goj_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","यीशु ने उनका से पुच्छो “हे गुरु. समजस हइ कि तु बरोबर बोलस. अरु सिकास भी हइ. अरु कोय को पक्षपात नी करतो. क्युकी परमेश्वर कि रस्ता सच्चीइ से बतास हइ. ");
INSERT INTO goj_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","का हम कैसर खे कर देनो अच्छो हइ. कि नी?” ");
INSERT INTO goj_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","यीशु ने उनकी हुशारी खे फसयखे उनका से बोल्यो. ");
INSERT INTO goj_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“एक सिक्का मेखे बताव. येका पर कोकी चित्र अरु नाम हइ?” उनने बोल्यो. “कैसर को.” ");
INSERT INTO goj_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","यीशु ने उनका से बोल्यो. “ते जो कैसर को हइ. व्हा कैसर खे दे अरु जो परमेश्वर को हइ. व्हा परमेश्वर खे दे.” ");
INSERT INTO goj_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","वे दुन्या का सामने वा बात खे पकडि नी सक्या. क्युकी ओका उत्तर से आश्चर्य चकित हुइय खे चुप र्‍हि गया. ");
INSERT INTO goj_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","फिर सदूकि जो बोलस हइ. कि मर्‍या हुया खे जिन्दो उठानो हइ य नी. उनमे से कुछ ने ओका पास अयखे पुछ्यो. ");
INSERT INTO goj_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“हे गुरु. मूसा ने हमारा लिये यो लिख्यो हइ ‘अगर कोय को भैइ ओकी लुगय से भ्याव करी ले. अरु अपना भैइ का लिये वंश परदा कर्‍हे.’ ");
INSERT INTO goj_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","अत: सात भैइ था. पयलो भैइ को भ्याव करीखे बिना बच्चा को मरी गयो. ");
INSERT INTO goj_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","फिर दुसरा ने. ");
INSERT INTO goj_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","अरु तिसरा ने भी वा बय से भ्याव करी लियो. याय रीति से साती भी बिना बच्चा का मरी गया. ");
INSERT INTO goj_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","सब का पिछे वा बय भी मरी गय. ");
INSERT INTO goj_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","येकालिये मरी खे जिन्दी हुय खे कोय की लुगय हुये. क्युकी वा सातजन की लुगय र्‍हिगय थी.” ");
INSERT INTO goj_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","यीशु ने उनका से बोल्यो. “यो जगत का सन्तानहोन मे तो भ्याव होस हइ.” ");
INSERT INTO goj_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","पर जो दुन्या यो योग्य रुखह्ये. की उ जगत खे अरु मर्‍या हुया मे से जिन्दो उठनो मील्यो कर्‍हे. उनमे भ्याव नी हुये. ");
INSERT INTO goj_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","वे फिर मरन का भी नी. क्युकी वे वे स्वर्ग दूतका जसा हुये. अरु जिन्दो हुयो कि सन्तान होना से परमेश्वर का भी सन्तान हुये. ");
INSERT INTO goj_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","पन या बात की मर्या हुया मेसे जिन्दो होस हइ. मूसा ने भी झाडि की कानी मे बतायोस हइ. व्हा प्रभु खे अब्राहम को परमेश्वर. अरु इसहाक को परमेश्वर अरु याकूब को परमेश्वर बोलस हइ. ");
INSERT INTO goj_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","परमेश्वर तो मुडदाको नी पन जिन्दो को परमेश्वर हइ क्युकी उनका नजीक सब जिन्दो हइ. ");
INSERT INTO goj_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","तब यो सुनीखे शास्त्रिहोन मे से खेत्ता ने बोल्यो. “हे गुरु. तोने अच्छो बोल्यो.” ");
INSERT INTO goj_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","अरु उनने फिर ओकासे कुछ पुछन की हिम्मंत नी हुय. ");
INSERT INTO goj_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","फिर यीशु ने उनका से पुछ्यो. “मसीह खे दाउद की सन्तान कसो बोलस हइ? ");
INSERT INTO goj_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","दाउद तुमने भजन सहिता कि किताब मे बोल्योस हइ प्रभु ने मरो प्रभु से बोल. ");
INSERT INTO goj_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","मरा जवना बठ. जब तक कि मी तरा दुसमनहोन खे तरा पाय नीच्चे कि चौकी नी करी दिव. ");
INSERT INTO goj_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","दाउद ते ओखे प्रभु बोलस हइ. ते फिर व्हा ओकी सन्तान कसो रख्यो?” ");
INSERT INTO goj_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","जब सब दुन्या सुनी राथा. ते उने अपना सेवक से बोल्यो. ");
INSERT INTO goj_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","शिक्षकहोन से चेतावनी र्‍हेव. जिन खे लम्बा कपडा पेन्या हुया घुमनो अच्छो लगस हइ. अरु जिन खे बजार मे नमस्कार. अरु आराधनालयहोन मे बडि जगा अरु खान कि जगा मे प्रेम लगस हइ. ");
INSERT INTO goj_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","वे विधवाहोन का घर खै जास हइ. अरु दिखान का लिये घनी टेम तक प्रार्थना करता र्हेस हइ. इन के खुप दण्ड मील्हे! ");
INSERT INTO goj_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","फिर यीशु ने आख उठय खे लकपती खे दुन्या दान कि पेटी मे पैसा डालता हुयो देख्यो. ");
INSERT INTO goj_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","अरु यीशु ने एक कंगाल विदवा खे भी ओमे दो सिक्का, डालते हुये देख्यो. ");
INSERT INTO goj_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","तब यीशु ने बोल्यो. मी तुम से सच्ची बोलुस हय कि या गरीब विधवा ने सबसे बडीखे दाल्योस हइ. ");
INSERT INTO goj_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","क्युकी वे सब ने अपनी अपनी बडती मे से दान मे कुछ डाल्योस हइ. पन येने अपनी कमी मे से अपनी सब जीवी का डाली दी हइ. ");
INSERT INTO goj_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","जब खेत्ता दुन्या मन्‍दिर का बारे मे बोली राथा.कि व्हा कसो अच्छो फत्तर अरु दि वाली चिजहोन से सिगार्‍यो गयोस हइ. ते यीशु ने बोल्यो. ");
INSERT INTO goj_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","वे दिन आह्ये. जिनमे ह्या सब जो तुम देखस हय.उनमे से ह्या कोय फत्तर पर फत्तर भी नी छुटेह्ये. जो गाड्यो नी जानको. ");
INSERT INTO goj_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","उनने उनका से पुछ्यो. “हे गुरु. यो सब कब हुये? अरु या बात जब पुरी होना पर हुये. ते वा टेम मे का का चिन्ह हुये?” ");
INSERT INTO goj_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","यीशु ने बोलयो. “सावधान र्‍हेव. कि फसायो नी जानको. क्युकी खुप मरा नाम से अयखे बोल्हे. कि टेम नजीक अय पहुच्योस हइ तुम उनका पिछे नी चली जानु.” ");
INSERT INTO goj_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","जब वाद विवाद अरु दंगो कि बात सुनी. तब घबरय नी जानु. क्युकी इनका पैयले होनो जरुरती हइ. पन वा टेम तुरुत खत्म नी हुये. ");
INSERT INTO goj_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","तब यीशु ने उनका से बोल्यो. जात पर जात अरु राज्य पर राज्य कर्‍हे. ");
INSERT INTO goj_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","अरु बडा बडा भुकम्प हुये. अरु जगा जगा अकाल अरु माहामारीहोन पडे. अरु बद्दल मे भयकर बात अरु बडा बडा चिन्ह पइदा हुये. ");
INSERT INTO goj_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","पन या सब बात से पैयले वे मरा नामकरण तुमके पकडे. अरु सताया. अरु आराधनालयहोन मे दियो अरु बन्दीगृह मे डाल्हे. अरु राजाहोन अरु राजपल का सामने ली जाह्ये. ");
INSERT INTO goj_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","पर ह्या तुमारी गवाही देन को अवसर हुय जाह्ये. ");
INSERT INTO goj_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","येका लिये अपना अपना मन मे ठानी रख देन को पैयले से उत्तर देन कि चिन्ता नी करण का. ");
INSERT INTO goj_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","क्युकी मी तुमखे असी बात अरु दिमाक दिह्यु. कि तुमारो सब खिलाप सामनो कर खण्डन नी करी सक्हे. ");
INSERT INTO goj_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","अरु तुम्हारा माय बाप अरु भैइ अरु कुटुम. अरु दोस्त्त भी तुम पकडे. ह्या तक कि तुम मे से खेत्ता खे मारी डाल्यो. ");
INSERT INTO goj_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","अरु मरा नामकरण सब दुन्या तरा से बुरो कर्‍हे. ");
INSERT INTO goj_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","पन तुमारा माथा को एक बाल भी बाको नी होनको. ");
INSERT INTO goj_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","अपना धिरज से तुम अपना जान खे बचाह्ये रखह्ये. ");
INSERT INTO goj_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","जब तुम यरुशलेम का सेना होन से घेर्ये हुयो देखे. ते समजी लेनू कि ओको उजड्यो जानो नजीक हइ. ");
INSERT INTO goj_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","तब जो यहूदीया मे हुये व्हा टेकडी पर भाग जाह्ये. अरु जो येरुशलेम का बाहेर नीकली जा. अरु जो गाव मे हुये वे ओमे नी जानु. ");
INSERT INTO goj_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","क्युकी यो बदलो लेन को असो दिन हुये जिनमे लिखी हुये सब बात पुरी हुय जाह्ये. ");
INSERT INTO goj_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","वे दिन मे जो दिन से अरु दुद पिलाती हुये. उनका लिये हय. हाय! क्युकी देस मे बडो दुख अरु ये पृथ्वी पर बडो संकट हुये. ");
INSERT INTO goj_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","वे तलवार से मार्‍यो जाह्ये. अरु सब देस का दुन्या मे भैइ बद हुयखे पहुचायो जाह्ये. अरु जब तक यरुशलेम गैरयहूदीहोन से खुन्द्यो जाह्ये. ");
INSERT INTO goj_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“अरु सुरज अरु चान्द अरु तारा को चिन्ह दिखाह्ये अरु पृथ्वी पर. राष्ट्र-राष्ट्र का दुन्या खे फजित हुये. क्युकी वे समुद्र को गरझनो अरु लहेर को पानी लहेर से घबरय जाह्ये.” ");
INSERT INTO goj_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","अरु डर करण अरु जगत पर आनवाली घटनाहोन कि रस्ता देखेते देखते दुन्या खे जान मे जान नी र्‍हियो क्युकी बद्दल की शक्तीहोन हलय जाह्ये. ");
INSERT INTO goj_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","तब वे इन्सान को बेटा खे सामर्थ्य अरु बडी महिमा का साथ बद्दल पर आते देखे. ");
INSERT INTO goj_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","जब ये बात होन लगी. ते सिधी हुय खे अपनो माथो उप्पर उठानु. क्युकी तुमारो छुटकारो नजीक हुये. ");
INSERT INTO goj_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","फिर यीशु ने उनका से एक दृष्‍टान्‍त भी बोल्य. “अंजीर को झाड अरु सब झाड खे देख. ");
INSERT INTO goj_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","जो मे उनकी डग्यान नीकलस हइ. ते तुम देखी खे खुद मे समजी लेस हय. कि उनाला को टेम्म नजीक हइ. ");
INSERT INTO goj_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","या रीति से जब तुम या बात होते देखे. तब समजी जानु कि परमेश्वर को राज नजिक हइ. ");
INSERT INTO goj_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","मी तुम से सच्ची बोलुस हय. की जब तक या सब बात नी हुये ले. तब तक या पीडी कभी भी खतम नी होन की. ");
INSERT INTO goj_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","बद्दल अरु जमीन टली जाह्ये पन मरी बात कभी नी टलन की. ");
INSERT INTO goj_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“येका लिये हुशार र्‍हेव असो नी हुये कि तुमारा मन नशा अरु मतवालोपन अरु यो जिवन कि चिन्ताहोन से सुस्त हुय जाव अरु उ दिन तुम पर फन्दा का जसा अचानक अय गिरे. ");
INSERT INTO goj_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","क्युकी व्हा सब जमीन का सब रेगनआला पर या रीति अय गिर्‍हे. ");
INSERT INTO goj_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","येका लिये जाते र्‍हेव अरु हर टेम मे प्रार्थना करते र्‍हेव कि तुम या सब आनवाली घटना होन से बचनो. अरु इन्सान का बेटा का सामने खडो होन का योग्य बन.” ");
INSERT INTO goj_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","उन दिन मे उ मन्‍दिर मे उपदेश करता थो अरु रात को जैतून नामक पहाड पर रहता थो. ");
INSERT INTO goj_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","अरु फजर खे सब दुन्या ओकी सुनन का लिये मन्‍दिर मे ओका पास आया करता था. ");
INSERT INTO goj_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","अखमीर रोटी को तिवार जो फसह बोल्यो जास हइ. नजीक थो. ");
INSERT INTO goj_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","अरु बडो याजक अरु शास्त्री या बात की खोज मे था कि ओखे कसो मारी डाल्हे. पर वे दुन्या से डरता था. ");
INSERT INTO goj_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","अरु सैतान यहूदा मे समायो. जो इस्करियोती बोल्यो जास अरु बारा सेवक मे गिन्यो जातो थो. ");
INSERT INTO goj_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","ओने जेखे बडो याजक अरु पुरोहीत को मुखीया का साथ बातचीत की ओखे रिती से उनको हात पकडयो. ");
INSERT INTO goj_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","वे खुशीसे हुया. अरु ओखे पैसा देन को वादो दियो. ");
INSERT INTO goj_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","उनने मानी लियो, अरु बहानो ढुडन लग्या. कि बिना उपद्रो, ओखे उनका हात पकडय दे फसह कि तैयारी. ");
INSERT INTO goj_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","तब अखमीरी रोटी को तीवार को दिन आयो. जो फसह को मेडा कि बलि करणो जरुरती थो. ");
INSERT INTO goj_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","अरु यीशु ने पतरस अरु यहून्ना खे ह्या बोलीखे भेज्यो. “जयखे हमारो खान, लिये फसह तैयारी कर.” ");
INSERT INTO goj_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","उनने उकासे पुच्छो. “तु खा चाहस हइ. की हम तैयार करा?” ");
INSERT INTO goj_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","यीशु ने उनका से बोल्यो. “देख. नगर मे घुसी करीते य इन्सान पानी को मडको उठायो हुयो तोखे मील्हे. जो घर मे व्हा जाह्ये तुम ओका पिच्छे चली जानु. ");
INSERT INTO goj_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","अरु उ घर को प्रभु से बोल. गुरु तुम से बोलस हइ. कि व्हा मीजवान को घर खा हइ जेमे से मी अपना सेवक का सात फसह खव?” ");
INSERT INTO goj_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","फिर वू तोखे एक सजी सवरी बडी कमरो दिखइ दियो. व्हा तैयारी करणा. ");
INSERT INTO goj_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","उनने जैयखे. जसो उनने ओकासे बोल्यो थो. ओसो य मील्यो. अरु फसह तैयारी करी. ");
INSERT INTO goj_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","जब घडी पहुची ते व्हा प्रेरितहोन, सात खानो खान बठ्यो. ");
INSERT INTO goj_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","अरु यीशु ने उनका से बोल्यो. मेखे बडी लालुच थी. कि दुख भोगनासे पैयले यो फसह तुमारा सात खव. ");
INSERT INTO goj_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","क्युकी मी तुम से बोलुस हय. कि जब तक व्हा परमेश्वर का राज मे पुरो नी हुये तब तक मी ओखे कभी नी खाह्यु. ");
INSERT INTO goj_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","तब ओने कटोरो लिखे धन्य वाद कर्यो अरु बोल्यो. “येखे ले अरु आपस मे बाटी ले. ");
INSERT INTO goj_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","क्युकी मी तुमसे बोलुस हय. कि जब तक परमेश्वर को राज्य नी आह्ये तब तक मी अंगूर रस आब से कभी नी पिनको.” ");
INSERT INTO goj_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","फिर ओने रोटी ली अरु धन्य वाद करी खे तोडी. अरु उनखे यो बोलते हुये दी.यो मरो आंग हइ “मरी याद का लिये यो कर्‍यो कर.” ");
INSERT INTO goj_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","याय रीति से उनने खान का बाद कटोरो मरो उ खुन मे जो तुमारा लिये बोहायो जास हइ नवो वचन हइ. ");
INSERT INTO goj_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","पर देख. मेखे पकडानआलो को हात मरा सात टेबल पर हइ. ");
INSERT INTO goj_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","क्युकी इन्सान को बेटो तो जसो की मी ओका लिये रोख्यो गयो. जातो हूये हइ. पर हाय उ इन्सान पर जिन का द्वारा उ पकडायो जास हइ. ");
INSERT INTO goj_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","तब वे आपस मे पुछ ताछ करण लग्या. हम मे से कोन हइ. जो यो काम कर्‍हे? ");
INSERT INTO goj_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","उनमे ह्या वाद विवाद भी हुय. कि हम मे से कोन बडो समझी जास हइ? ");
INSERT INTO goj_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","उनने यीशु से बोल्यो. गैरयहूदिहोन को राजा उन पर प्रभुता करस हइ, अरु जो उन पर अधिकार रखस हइ. वे उपकार बोल्योस हइ. ");
INSERT INTO goj_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","पन तुम असो नी होनु. क्युकी जो तुम मे बडो हइ. व्हा छोटो का जसो अरु जो बडो हइ. व्हा सेवक होन का जसो बन. ");
INSERT INTO goj_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","क्युकी बडो कोन हइ. व्हा जो खाना पर बठ्यो याव्हा जो सेवा करस हइ? व्हा नी जो खाना पर बठ्यो हइ पर मी तुम्हारा बीच मे सेवक का जसो हय. ");
INSERT INTO goj_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“पन तुम व्हा हय. जो मरी परीक्षाहोन मे लगातार मरा सात र्‍हे. ");
INSERT INTO goj_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","अरु जसो मरा बाप ने मरा लिये एक राज्य रोख्योस हइ मी भी तुम्हारा लिये रोख्योस हय. ");
INSERT INTO goj_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","जब की तुम मरो राज्य मे मरी मेज पर खाव पिओ. क्युकी सिंहासन पर बठीखे इस्राएल का बारा गोत को न्याय कर. ");
INSERT INTO goj_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“शमौन. हे शमौन सैतान ने तुम दुन्या खे मागी लियो हइ कि गहु का जसो फटीखे. ");
INSERT INTO goj_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","पन मे ने तरा लिये प्रार्थना करी. कि तरो विश्वास जातो नी र्‍हे अरु जब तू फिर ते अपना भैइहोन खे रोखनु करणु.” ");
INSERT INTO goj_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","यीशु ने उनका से बोल्यो, हे प्रभु मी तरा सात बन्दीगृह जान क्युकी मरन खे भी तैयार हय. ");
INSERT INTO goj_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","ओने बोल्यो हे पतरस मी तरासे बोलुस हय कि आज मुर्गा बांग देना जब तक तु तीन बार मरो इन्कार नी कर लिह्ये कि मी ओखे नी परछानु. ");
INSERT INTO goj_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","अरु यीशु ने उनका से बोल्यो, “जब मे ने तुमखे थैली अरु झोलो. अरु जुता बिना भेज्यो थो. ते का तुमखे कोय बात कि कमी हुय थी?” उनने बोल्यो. कोय चिज की नी. ");
INSERT INTO goj_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","यीशु ने उनका से बोल्यो. पन आब जिन का पास थैली हय व्हा ओखे ले. अरु वसो य झोलो भी. अरु जिनका पास तलवार नी हुये वे अपना कपडा बेचीखे एक मोल लीले. ");
INSERT INTO goj_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","क्युकी तुमसे बोलुस कि यो लिख्यो हइ. “व्हा अपराधी का साथ गिन्यो गयो. ओको मरा मे पुरो होनो जरुरती हइ. क्युकी मरा बारे कि बात पुरी होना पर हइ.” ");
INSERT INTO goj_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","उनने बोल्यो. हे प्रभु. देख. ह्या दो तलवार हइ. यीशु उनसे बोल्यो. “भोत हइ.” ");
INSERT INTO goj_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","तब बाहेर नीकली खे अपनी रीति का जसो जैतून का टेकडा पर गयो. अरु सेवक ओका पिच्छे हुय लिया. ");
INSERT INTO goj_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","वा जगत मे पहुची खे यीशु ने उनका से बोल्यो. “प्रार्थना करणु. कि तुम परीक्षा मे नी गिरन का.” ");
INSERT INTO goj_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","अरु व्हा ओने एक ढेकलो फेकना कि दुर भरी गया. अरु घुटना टेकीखे प्रार्थना करण लग्या. ");
INSERT INTO goj_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“हे बाप अगर तु चाह्ये ते यो कटोरा खे मरा पास से हटयी ले. फिर भी मरी नी पन तरी इच्छा पुरी हुये.” ");
INSERT INTO goj_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","तब स्वर्ग से एक दूत दिखास दियो जो ओखे सामर्थ्य देतो थो. ");
INSERT INTO goj_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","अरु व्हा खुप संकट मरा व्याकुल हुयखे अरु भी हार्दिक तखलीप से प्रार्थना करण लग्यो. अरु ओको पसीनो मानी खुन की बडि बडि थेम का जसो जमीन पर गिरी रा था. ");
INSERT INTO goj_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","तब व्हा प्रार्थना से उठ्यो अरु अपना सेवक का पास अयखे उनखे उदासी का मारे सोते देख्यो. ");
INSERT INTO goj_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","अरु उनका से बोल्यो. “का सोस हय? उट खे प्रार्थना कर कि परीक्षा मे नी पडे.” ");
INSERT INTO goj_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","उ यो बोली य रोथो. कि देख एक गर्दी अय. अरु वे बारा मे एक जोको नाम यहूदा थो उनका आगे आगे अय रो थो. व्हा यीशु का पास आयो. कि ओको चुम्मो ले. ");
INSERT INTO goj_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","यीशु ने उनका से बोल्यो. “हे यहूदा का तु चूमो लिखे इन्सान को बेटा खे पकडास हइ?” ");
INSERT INTO goj_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","यीशु का साथीहोन ने जब देख्यो कि होनआलो हइ. ते बोल्य “हे प्रभु का हम तलवार चलाह्या?” ");
INSERT INTO goj_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","अरु उनमे से एक ने महायाजक सेवक पर तलवार चलखे ओका जवनो टी दियो. ");
INSERT INTO goj_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","येका पर यीशु ने बोल्यो. “अब बस कर.” अरु ओको न छीखे अच्छो कर्‍यो. ");
INSERT INTO goj_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","तब यीशु ने प्रधान याजको अरु मन्‍दिर को बडो अधिकारी अरु बापदादाहोन से. जो उ पर चडीखे आया था. बोल्हे. का “तुम मेखे डाकु समजी खे तलवार अरु लकडि लिखे नीकल्या हय? ");
INSERT INTO goj_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","जब मी मन्‍दिर मे हर दिन तुम्हारा सात थो. ते तुम ने मरा पर हात नी डाल्यो. पर ह्या तुमारी घडी हइ. अरु अंधारा को अधिकार हइ.” ");
INSERT INTO goj_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","फिर वे ओखे पकडीखे ली चल. अरु महा याजक का घर मे लायो अरु पतरस दुर मे दुर ओका पिच्छे चल्यो थो. ");
INSERT INTO goj_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","अरु जब वे अंगन मे अंगार लगय खे येकजगा बठ्या. ते पतरस भी उनका बिच मे बठी गयो. ");
INSERT INTO goj_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","अरु एक दासी ओखे उजार मे बठ्यो देखीखे अरु ओका तरप देखीखे बोलन लगी “यो भी तो उ सात थो.” ");
INSERT INTO goj_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","पन ओने यो बोली खे इनकार कर्‍यो. “हे बय मी ओखे नी परछानु!” ");
INSERT INTO goj_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","थोडा देर बाद कोय दुसरा ने ओखे देखी खे बोल्यो. “तु भी तो उनमे से हइ.” पतरस ने बोल्यो. “हे इन्सान मी नी हय.” ");
INSERT INTO goj_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","नजिक पास एक घन्टा बाद अरु इन्सान हिम्मत से बोलन लग्या. पक्को इरादो यो भी तो ओका सात थो. क्युकी यो गलील हइ ");
INSERT INTO goj_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","पतरस ने बोल्यो. “हे इन्सान मी नी समजुस कि तुम बोलस हइ?” व्हा बोली य राथा कि तुरुत मुर्गा ने बांग देयो. ");
INSERT INTO goj_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","तब प्रभु ने घुमी खे पतरस का तरप देख्यो अरु पतरस खे प्रभु, वा बात याद अय जो यीशु ने बोली थी. “आज मुर्गा की बांग देनासे पइले तू तीन बार मरो इनकार कर्‍हे.” ");
INSERT INTO goj_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","अरु व्हा बाहेर नीकलीखे फुटि फुटि खे रोन लग्यो. ");
INSERT INTO goj_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","जो इन्सान यीशु खे पकड्यो हुयो थो. वे ओको उपहार करण पीटन लग्यो ");
INSERT INTO goj_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","अरु ओकी आख झाकि खे ओकासे पुच्छ. “भविष्यवाणी करीखे बात करी तोखे कोने मार्‍यो.” ");
INSERT INTO goj_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","अरु उनने खुप सी अरु नीन्दा कि बात ओका बारे मे बोली. ");
INSERT INTO goj_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","जब दिन हुयो ते दुन्या का बुजुरुख अरु प्रधान याजक अरु शास्त्री एकजगा जमा हुया. अरु ओखे अपनी महासभा मे लयखे पुच्छो. ");
INSERT INTO goj_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“अगर तु मसीह हइ. ते हम से बोली दे!” यीशु ने उनका से बोल्यो. अगर मी तुम से बोल्हु ते विश्वास नी करण. ");
INSERT INTO goj_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","अरु अगर पुछ ते उत्तर नी दिह्ये. ");
INSERT INTO goj_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","पन आब से इन्सान को बेटो सर्वशक्तिमान परमेश्वर का जवना तरप बठ्यो र्‍हिये. ");
INSERT INTO goj_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","येका पर सब ने बोल्यो. “ते, तु परमेश्वर को बेटो हइ?” यीशु ने उनका से बोल्यो. “तुम खुद मे बोलस. हय. क्युकी मी हय.” ");
INSERT INTO goj_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","तब उनने बोल्यो. “आब हम गवइ कि, जरुरत हइ. क्युकी हमने खुद मे उ, मेडासे सुनी लियो हइ.” ");
INSERT INTO goj_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","तब सब सभा उठीखे ओखे पिलातुस का पास ली गया. ");
INSERT INTO goj_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","अरु वे ह्या बोली खे ओका पर दोस्त्त लगान लग्या. “हमने ये दुन्या खे भैकातो अरु कैसर खे करी देना से मना करते. अरु अपना आप खे मसीह. राजो बोलते हुयो सुन्योस हइ.” ");
INSERT INTO goj_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","पिलातुस ने यीशु से पुछ्यो “तु यहूदीयाहोन को राजो हइ?” यीशु ने उत्तर दियो. तू खुद मे बोली रोस हइ. ");
INSERT INTO goj_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","तब पिलातुस ने प्रधान याजक अरु दुन्या से बोल्यो “मी यो इन्सान मे कुछ दोस्त्त नी देखु.” ");
INSERT INTO goj_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","पर वे अरु भी दृढता से बोलन लग्या. “ह्या गलील से ह्या तक सब यहूदीया मे उपदेस दि दिखे दुन्या खे भडकस हइ.” ");
INSERT INTO goj_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","यो सुनी खे पिलातुस ने पुच्छो “यो इन्सान गलीली हइ?” ");
INSERT INTO goj_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","अरु यो समजी खे कि व्हा हेरोदेस अधिकारी का पास भेजी दियो. क्युकी वे दिन मे व्हा भी यरुशलेम गाव मे था. ");
INSERT INTO goj_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","हेरोदेस यीशु खे देखी खे भोत मे खुश हुयो. क्युकी व्हा भोत दिन से उनखे देखनो चाहस था येका लिये कि उनखे देखनो चाहतो थो. येका लिये कि ओका बारे मे सुन्यो अरु ओको कुछ चिन्ह देखन कि आस रखेतो थो. ");
INSERT INTO goj_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","व्हा ओका से भोत सारी बात पुछतो र्‍हियो. पर यीशु ने ओखे कुछ भी उत्तर नी दियो. ");
INSERT INTO goj_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","अरु प्रधान याजक अरु शास्त्री खडो हुयो तन मन से उस पर दोष लगाते र्‍हियो. ");
INSERT INTO goj_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","तब हेरोदेस ने अपना सिपयहोन का साथ ओको अपमान करी खे उपहास कर्‍यो. अरु चमकदार कपडा पेनीखे ओखे पिलातुस का पास पलट्य दियो. ");
INSERT INTO goj_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","उये दिन पिलातुस अरु हेरोदेस दोस्त्त हुय गयो येका पैयले वे एक दुसरा को दुशमन था. ");
INSERT INTO goj_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","पिलातुस ने प्रधान याजक अरु मुखियो अरु दुन्या खे बुलखे उनसे बोल. ");
INSERT INTO goj_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","“तुम यो इन्सान खे दुन्या, भैइ कानालो रोखीखे मरा पास लास हय. अरु देख. मेने तुमारा सामने ओकि तपासनी करी. पर जो बात का तुम ओका पर दोस्त लगास हय. वा बात, बारे मे मेने ओमे कुछ भी दोस्त नी देख्योस हइ. ");
INSERT INTO goj_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","नी हेरोदेस ने. क्युकी ओने ओखे हमारा पास पलटय दियो हइ अरु देख. ओकसे असो कुछ नी हुयो कि व्हा मृत्यु को दण्ड को योग्य रोख्यो जाह्ये. ");
INSERT INTO goj_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","येका लिये मी ओखे मारी खे छोडी देस हय.” ");
INSERT INTO goj_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","पिलातुस तिवार का टेम उनका लिये एक बन्दी खे छोडना पर विकुल थो. ");
INSERT INTO goj_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","तब सब मीलीखे चिल्लय उठ्यो. “येको काम तमाम कर. अरु हमारा लिये बरअब्बा नाम खे छोडी दे.” ");
INSERT INTO goj_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","व्हा कोय बलवे करण जो नगर मे हुयो थो. अरु मारनो को करण बन्दीगृह मे डाल्यो गयो थो. ");
INSERT INTO goj_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","पर पिलातुस ने यीशु खे छोडन कि इच्छा से दुन्या खे फिर समजायो. ");
INSERT INTO goj_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","पर उनने चिल्लयखे बोल्यो. “ओखे क्रुस पर चडा. क्रुस पर!” ");
INSERT INTO goj_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","यीशु ने तिसरी बार उनका से बोल्यो. “क्यु ओने कोन सी बुरय की हइ? मेने ओमे मृत्यु दण्ड को योग्य कोय बात नी मील्हे! येका लिये मी ओखे मारीखे छोडी दियो हय.” ");
INSERT INTO goj_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","पन वे चिल्लय खे पिछे पडी गयो. कि व्हा क्रुस पर चडयो जाह्ये. अरु उनको चिल्लानो प्रबल हुयो. ");
INSERT INTO goj_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","तब पिलातुस ने आज्ञा दी.कि उनकि बिनती, जसो कर्‍यो जाह्ये. ");
INSERT INTO goj_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","अरु यीशु ने उ इन्सान खे जो विद्रोही अरु मारन करण बन्दीगृह मे डाल्यो गयो थो. अरु जेखे वे मागता था. छोडी दियो. अरु यीशु खे उनकी इच्छा, जसो दि दिह्ये ");
INSERT INTO goj_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","जब वे ओखे लिखे जय रा था. ते उनने शमौन नाम एक कुरेनी खे जो गाव से अय रो थो.पकडीखे ओका पर क्रुस खे लादी दियो कि ओखे यीशु का पीछे पीछे ली चला. ");
INSERT INTO goj_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","अरु दुन्या की बडी गर्दी ओका पिच्छे चली अरु भोत सारी लुगय भी. जो ओका लिये छाती पीटती अरु विलाप करती थी. ");
INSERT INTO goj_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","यीशु ने उनका तरप फिरीखे बोल्यो “हे यरुशलेम. की बेटीहोन मरा लिये मत रोय. पन अपना अरु अपना बच्चा का लिये रो. ");
INSERT INTO goj_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","क्युकी वे दिन आस हइ. जिनमे दुन्या बोल्हे ‘धन्य हइ वे जो बाझ हइ. अरु वे स्तन जिनने दुध नी पिलायो.’ ");
INSERT INTO goj_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","उ टेम ‘वे टेकडा से बोलन लगेह्ये. कि हम पर गिर्‍यो. अरु टीलो से कि हम झाकि ले.’ ");
INSERT INTO goj_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","क्युकी जब वे हरा झाड का सात असो करस हइ. ते सुख का सात का कुछ नी कर्‍यो जाह्ये?” ");
INSERT INTO goj_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","वे अरु दो इन्सान खे भी जो राजद्रोही था ओका साथ मारी डालन खे ली चल्यो. ");
INSERT INTO goj_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","जब वे वा जगा जेखे झोपडि बोलस हइ पहुचे. ते उनने व्हा ओखे अरु वे राजद्रोही खे भी एक खे जवना अरु दुसरा खे डाखोर्‍या अरु क्रुस होन पर चडायो. ");
INSERT INTO goj_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","तब यीशु ने बोल्यो. “हे बाप. इनखे माफ कर. क्युकी ये समजो नी कि का करी रास हइ?” अरु उनने चिट्ठी डालीखे ओका कपडा बाटी लिया. ");
INSERT INTO goj_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","दुन्या खडो खडो देखी रा था. अरु मुखियो भी उपहास करी करीखे बोलता था. “येने दुसरा खे बचायो. अगर ह्या परमेश्वर को मसीह हइ. अरु उनको चुन्यो हुयो हइ. ते अपना आप खे बचय ले.” ");
INSERT INTO goj_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","सिपय भी नजीक अयखे अरु सिर, दिखे ओको उपहास करीखे बोलता था. ");
INSERT INTO goj_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","“अगर तू यहूदीयाहोन को राजो हइ. ते अपना आप खे बचान.” ");
INSERT INTO goj_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","अरु उनका उप्पर एक दोस्त्त चिठ्ठी भी लग्यो थो “ह्या यहूदीयाहोन को राजो हइ.” ");
INSERT INTO goj_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","जो राजद्रोही लटकायो गयो थो. उनमे से एक ने ओकी नीन्दा करीखे बोल्यो “का तू मसीह नी? ते फिर अपना आप खे अरु हमखे बचान.” ");
INSERT INTO goj_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","येका पर दुसरा ने ओखे धमकय खे बोल्हे “तू परमेश्वर से भी नी डरु? तोखे भी तो व्हा दण्ड मीली रोस हइ” ");
INSERT INTO goj_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","अरु हमखे तो न्याय जसो दण्ड मीली रोस हइ. क्युकी हमखे अपना काम खे बरोबर फल मीली रोस हइ. पर इनने कोय बुरो काम नी कर्‍यो. ");
INSERT INTO goj_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","तब उनका से बोल्यो. “हे यीशु. जब तू अपनो राज मे आह्ये. ते मरी याद लेनू.” ");
INSERT INTO goj_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","यीशु ने उनका से बोल्यो. “मी तरासे सच्ची बोलुस हय कि आज हि तू मरा सात स्वर्गलोक मे हुये.” ");
INSERT INTO goj_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","अरु नजीकपास दुपेर से तिसरा पर तक सब देस मे अधारो हुइ गयो. ");
INSERT INTO goj_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","अरु सुरज को प्रकाशन जातो र्‍हियो. अरु मन्‍दिर को परदा का बिच मे से फटी गय. ");
INSERT INTO goj_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","अरु यीशु ने बड अवाज से बुलय खे बोल्यो. “हे बाप मी अपनी आत्मा तरा हात मे दिउस हय.” अरु यो बोलीखे जान छोडी दियो. ");
INSERT INTO goj_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","सुबेदार ने जो कुछ हुयो थो देखीखे परमेश्वर की महिमा करी अरु बोल्यो. “ठानीलियो ह्या इन्सान न्यायी थो.” ");
INSERT INTO goj_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","अरु गर्दी जो ह्या देखन खे जमा हुय थी. या घटना खे देखी खे छाती ठोकते पलटी गया. ");
INSERT INTO goj_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","अरु ओका सब जान्या पहीचान्या. अरु जो बय गलील से उ सात अय थी. दूर खडी हुय ह्या सब देखी थी. ");
INSERT INTO goj_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","अरु व्हा. यूसुफ नाम खे महासभा को एक सदस्य थो. जो अच्छो न्यायी इन्सान थो. ");
INSERT INTO goj_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","अरु उनको बिचार अरु उनको यो काम से खुश नी थो. अरु व्हा यहूदीयाहोन का नगर अरिमतियाह का र्‍हेनवाला अरु परमेश्वर का राज कि प्रतीक्षा करणआलो था. ");
INSERT INTO goj_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","यीशु ने पिलातुस का पास जयखे यीशु कि लास मागी. ");
INSERT INTO goj_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","अरु ओखे उतारीखे मलमल कि चद्दर मे गुड्यो. अरु एक मरगट मे रख्यो. जो चट्ठान मे खोदी हुयी थी. अरु ओमे कोय कभी नी रख्यो जातो थो. ");
INSERT INTO goj_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","यो तैयारी का दिन थो. अरु आराम को दिन सुरवात होना पर थो. ");
INSERT INTO goj_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","अरु वे बयहोन ने जो उनका सात गलील से अय थी पिछे पिछे जयखे वा कब्र खे देख अरु ह्या भी कि ओकी लास कोय रीति से रख्यो गयोस हइ. ");
INSERT INTO goj_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","अरु पलटी खे गधानवाली चिज अरु अत्रर तैयार कर. अरु आराम का दिन तो उनने आज्ञा का जसो अराम कर्‍यो. ");
INSERT INTO goj_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","पन हप्ता का पैयला दिन बडा फजर खे वे उ गधानवाली चिजहोन खे जो उनने तैयार करी थी. लीखे मरगट पर अय. ");
INSERT INTO goj_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","अरु उनने फत्तर खे कब्र का दरवाजा पर से लुडक्यो हुयो लिल्यो. ");
INSERT INTO goj_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","अरु अंदर जैखे प्रभु यीशु की लास नी मीली. ");
INSERT INTO goj_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","जब वे या बात से भौचक्की हुय री थी तब. दो इन्सान चमकता कपडा पेन्या हुया उनका पास अय खडो हुयो. ");
INSERT INTO goj_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","जब वे डरी गय. अरु जमीन का तरप मुडो झुकय री. ते उनने उनसे बोल्यो. “तुम जिन्दो खे मर्‍या हुया मे क्यु ढुडस हय? ");
INSERT INTO goj_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","उ ह्या नी. पन जिन्दो हइ. याद कर कि ओने गलील मे र्‍हेते हुये तुम से बोल्यो थो. ");
INSERT INTO goj_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘यो जरुरी हइ कि इन्सान को बेटो पापीहोन का हात मे पकडायो जाह्ये. अरु क्रुस पर चडायो जाह्ये अरु तीसरा दिन जिन्दो हुये.’” ");
INSERT INTO goj_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","तब ओकि बात ओखे याद अय. ");
INSERT INTO goj_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","अरु कब्र से पलटी खे उनने वे ग्यारा खे अरु दुसरा सब खे या सब बात बोली सुनय. ");
INSERT INTO goj_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","जिनने प्रेरितहोन से या बात बोली वे मरियम मगदलीनी अरु योहन्‍ना अरु याकूब की माय मरीयम अरु उनका सात कि दुसरी बय भी थी. ");
INSERT INTO goj_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","पन उनकी बात उनने कानी का जसी लगी अरु उनने उन पर विश्वास नी कर्‍यो. ");
INSERT INTO goj_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","तब पतरस उठीखे कब्र पर दौडि गयो अरु झुकि खे फक्त कपडा पड्या देख्या अरु जो हुयो थो. ओकासे अचम करते हुय. अपना घर चली गया. ");
INSERT INTO goj_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","उये दिन उनमे से दो झन इम्माउस नाम खे एक गाव खे जय रा था. यरुशलेम नगर से नजीकपास ग्यारा किलो मीटर की दूरी पर थो. ");
INSERT INTO goj_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","अरु वे सब बात पर जो हुय थी. आपस मे बातचीत करते जय रा था. ");
INSERT INTO goj_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","अरु जब वे आपस मे बातचीत अरु पुछ ताछ करी रा था. ते यीशु खुद नजीक अयखे उनका साथ हुय लियो. ");
INSERT INTO goj_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","पन उनकी आख असी बन्द करी दी गय थी. कि ओखे पहीचानी नी सक्या. ");
INSERT INTO goj_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","उनने पुछ्यो. “या का बात हइ. जो तुम चलते चलते आपस मे करस हय?” वे उदासी से खडा र्‍हिया गया. ");
INSERT INTO goj_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","यो सुनीखे. उनमे से क्लियुपास नाम खे एक इन्सान ने बोल्यो. “का तु यरुशलेम मे एकलो परदेसी हइ. जो नी पयछाने. कि यो दिन मे ओमे का का हुयोस हइ?” ");
INSERT INTO goj_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","“यीशु ने उनसे पुछ्यो कोन सी बात?” उनने ओकासे बोल्यो. “यीशु नासरी का बारे मे “जो परमेश्वर अरु सब दुन्या का नजीक काम अरु वचन मे सामर्थ्यी भविष्यव्दक्ता थो.” ");
INSERT INTO goj_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","अरु मुखियो याजक अरु हमारा मुखियो ने ओखे पकडय दिये. कि ओका पर मृत्यु की आज्ञा दी जाह्ये. अरु ओखे क्रुस पर चडय दिह्ये. ");
INSERT INTO goj_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","पन हम आस थी. की ह्या इस्राएल खे छुटकारो दिह्ये. अरु या सब बात का सिवाय या घटना खे हुय तीसरो दिन हइ. ");
INSERT INTO goj_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","अरु हम मे से कोय बय ने भी हम आश्चर्य मे डाली दियोस हइ. जो फजर खे कब्र पर गय थी. ");
INSERT INTO goj_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","अरु जब ओकी लास नी मीली.ते ह्या बोलती हुइ अय. कि हमने स्वर्गदूत को दर्शन मील्यो.जिनने बोल्यो कि व्हा जिन्दो हइ. ");
INSERT INTO goj_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","तब हमारा सातआला मे से कोय एक कब्र पर गयो का अरु जसो बय ने बोल्यो थो. वसो हय का मील्यो पन उनखे नी देख्यो. ");
INSERT INTO goj_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","तब यीशु ने उनसे बोल्यो. “हे बिनादिमाक आला अरु भविष्यव्दक्ता कि सब बात पर विश्वास करणा मे मन्दमति हुये! ");
INSERT INTO goj_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","का जरुरी नी थो. कि मसीह यो दुख उठयखे अपनी महिमा मे अंदर कऱ्हे?” ");
INSERT INTO goj_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","तब ओने मूसा से अरु सब भविष्यव्दक्ताहोन से सुर्वात करीखे सब पवित्रशास्त्र मे से. अपना बारे मे करी बात को अर्थ. उनने समझय दियो. ");
INSERT INTO goj_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","येतना मे उ गाव का पास पहुच्यो. झा वे जय रा था. अरु ओका ढंग से असो जानी पड्यो कि व्हा आगे बडनो चाहस हइ. ");
INSERT INTO goj_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","पन उनने यो बोलीखे ओखे रोख्यो. “हमारा सात र्‍हे. क्युकी संजा हुय चली हइ.” तब व्हा उनका सात र्‍हेन का लिये अंदर गया. ");
INSERT INTO goj_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","जब व्हा उनका साथ खान खे बठ्यो. ते ओने रोटी लिखे धन्यवाद कर्‍यो. अरु ओखे तोडिखे उनखे देन लग्यो. ");
INSERT INTO goj_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","तब उनकी आख खुली गय. अरु उनने ओखे पहीचान लियो. अरु व्हा उनका आख से लुकि गयो. ");
INSERT INTO goj_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","उनने आपस मे बोल्यो. “जब व्हा रस्ता मे हम से बात करता था. अरु पवित्रशास्त्र को अर्थ हम के समझतो थो. ते का हमारा मन मे उत्तेझना नी परदा हुइ?” ");
INSERT INTO goj_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","वे वय टेम उठीखे यरुशलेम खे पलटी गया. अरु उन ग्यारा अरु उनका साथिहोन खे जमा देख्या. ");
INSERT INTO goj_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","वे बोलता था. “प्रभु सच्ची जिन्दो उठ्योस हइ, अरु शमौन खे दिखय दियोस हइ.” ");
INSERT INTO goj_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","तब उनने रस्ता की बात उनने बतय दी अरु ह्या भी कि उनने ओखे रोटी तोडते टेम कसो पैछान्यो. ");
INSERT INTO goj_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","वे या बात बोलीय रो थो. कि व्हा खुद मे उनका बीच मे अय खडो हुयो. अरु ओने बोल्यो. “तुम खे शांती मील्हे.” ");
INSERT INTO goj_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","पन वे घबरय गयो. अरु डरी गयो. अरु समझ्ये. कि हम कोय सैतान खे देखी रास हइ. ");
INSERT INTO goj_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","यीशु ने उनका से बोल्यो. “काय घबरास हय? अरु तुमारा मन मे का संदेह उठस हइ? ");
INSERT INTO goj_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","मरा हात अरु मरा पाय खे देख. कि मी व्हा हय. मेखे छिखे देख. क्युकी आत्मा का हड्डा मास नी होतो जसो मेखे मी देखतो हय.” ");
INSERT INTO goj_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","ह्या बोलीखे यीशु ने उनखे अपनो हात अरु पाय बतायो. ");
INSERT INTO goj_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","जब खुशी का मारे उनको विश्वास नी हुय रो थो. अरु आश्चर्य करता था. ते यीशु ने उनसे पुछ्यो. “का ह्या तुमारा पास कुछ खानो हइ?” ");
INSERT INTO goj_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","उनने ओखे भुजी मंछी को टुकडो दियो. ");
INSERT INTO goj_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","यीशु ने लिखे उनका सामने खायो. ");
INSERT INTO goj_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","फिर यीशु ने उनसे बोल्यो. “या मरी वे बात हइ. जो मेने तुमारा सात र्‍हेते हुयो. तुम से बोली थी. कि जरुरती हइ. कि जोतनी बात मूसा कि व्यवस्था अरु भविष्यव्दक्ताहोन अरु भजन कि किताब मे. मरा बारे मे लीखी हइ. सब पुरी हुये.” ");
INSERT INTO goj_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","तब यीशु ने पवित्रशास्त्र समझन का लिये उनकी समझ खोली दी. ");
INSERT INTO goj_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","अरु उनका से बोल्यो. “यो लिख्योस हइ कि मसीह दुख उठाह्ये. अरु तीसरा दिन मर्‍यो हुया मे से जिन्दो उठ्ये. ");
INSERT INTO goj_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","अरु यरुशलेम से लीखे सब राष्ट्र मे मन फिराव को अरु पाप कि माफि को प्रचार उय नाम से कर्‍यो जाह्ये. ");
INSERT INTO goj_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","तुम या सब बात कि गवाह हय. ");
INSERT INTO goj_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","अरु जिनकी प्रतीज्ञा परम बाप ने करी हइ. मी उनखे तुम पर उतारु हुये अरु जब तक स्वर्ग से सामर्थ्य नी मील्यो. तब तक तुम याय नगर मे रुख्यो.” ");
INSERT INTO goj_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","तब व्हा उनने बैतनीय्याह तक बाहेर ली गयो. अरु अपना हात उठखे उनने आशिर्वाद दीयो. ");
INSERT INTO goj_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","अरु उनने आशिर्वाद देते हुये व्हा से उनका से अल्लग हुय गयो अरु वु स्वर्ग पर उठइ लियो. ");
INSERT INTO goj_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","अरु वे ओखे आराधना करीखे बडि खुशी से यरुशलेम खे पलटी गया. ");
INSERT INTO goj_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","अरु वे घडि घडि मन्दिर मे हाजीर हुयखे परमेश्वर कि स्तुती कर्‍यो करता था.");
INSERT INTO goj_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","सुरु मे शब्द थो, अरु शब्द परमेश्वर का साथ थो, अरु शब्द परमेश्वर थो. ");
INSERT INTO goj_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","यो ही सुरु मे परमेश्वर का साथ थो. ");
INSERT INTO goj_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","सब कुछ ओका वजेसे पइदा हुयो अरु जो कुछ पइदा हुयो हइ ओमे से कोय भी चिज ओका बिना पइदा नी हुया. ");
INSERT INTO goj_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","उ जिवन थो, उ जिवन इन्सानहोन को उजालो थो. ");
INSERT INTO goj_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","अरु उजालो अंधारा मे चमकस हइ. अरु अंधारा ने ओखे कबुल नी कऱ्यो. ");
INSERT INTO goj_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","एक इन्सान परमेश्वर का तरप से आयो उपस्थित हुयो जोको नाम यहून्ना थो. ");
INSERT INTO goj_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","यो गवइ देन आयो, कि उजाला कि गवइ दे, ताकि सब ओका वजेसे विश्वास लाये. ");
INSERT INTO goj_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","उ खुद तो उजालो नी थो, पर उ उजाला का बारेमे गवइ देन का लिये आयो थो. ");
INSERT INTO goj_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","सच्ची उजालो जो हर एक इन्सान खे उजालो करस हइ जगत मे आनआलो थो. ");
INSERT INTO goj_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","उ जगत मे थो, अरु इन्सान ओका वजेसे पइदा हुया, अरु इन्साहोन ने ओखे नी परछान्यो. ");
INSERT INTO goj_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","उ अपना घर मे आयो अरु ओका अपना ने ओखे कबुल नी कर्यो. ");
INSERT INTO goj_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","पर जोत्ता ने ओखे कबुल कर्यो, ओने उनखे परमेश्वर का बच्चा होन को अधिकार दियो, यानेकी उनने जो ओका नाम पर विश्वास रखस हइ. ");
INSERT INTO goj_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","वे नी ते खुन से, नी आंग की इच्छा से, नी इन्सान की इच्छा से, पर परमेश्वर से पइदा हुयो हइ. ");
INSERT INTO goj_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","अरु वचन देहधारी हुयो. अरु अनुग्रह अरु सच्चीइ से परिपूर्ण हुइखे हमारा बीच जियो, अरु हमने ओकी असी महिमा देखी जसी बाप का एकलौता बेटा की महिमा. ");
INSERT INTO goj_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","यहून्ना ने ओका बारे मे गवइ दी, अरु बुलय खे बोल्यो, यो उ हइ, जोको मेने वर्णन कर्यो, कि जो मरा बाद अय रो हइ, उ मरासे बडीखे हइ, क्युकी उ मरासे पइले थो. ");
INSERT INTO goj_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","क्युकि ओकी परिपूर्णता से हम सब ने मील्हे कर्यो मंनजे अनुग्रह पर अनुग्रह. ");
INSERT INTO goj_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","येका लिये कि व्यवस्था तो मूसाक का वजेसे दी गवइ, पर अनुग्रह अरु सच्ची यीशु मसीह का वजेसे पहुची. ");
INSERT INTO goj_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","परमेश्वर खे कोय ने कभी नी देख्यो, एकलोतो बेटो जो बाप का खोरा मे हइ, ओने ओखे प्रगट कर्यो. ");
INSERT INTO goj_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","यहून्ना की गवइ या हइ, कि जब यहूदीयाहोन ने यरुशलेम से याजकहोन अरु लेवीहोन खे ओकासे पुछन का लिये भेज्यो, “तू कोन आय?” ");
INSERT INTO goj_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","ते ओने यो मानी लियो, अरु इनकार नी कर्यो, पर मानी लियो “मी मसीह नी आय.” ");
INSERT INTO goj_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","“तब ओने ओकासे पूछ्यो,” “ते फिर तू कोन आय?” “तू एलिय्याह आय?” ओने बोल्यो, “मी नी आय” का ते तू उ भविष्यव्दक्ता आय? “ओने जवाब दियो नी.” ");
INSERT INTO goj_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","“तब ओने ओका से पूछ्यो का फिर तू हइ कोन ताकि हम अपना भेजन आला खे जवाब दे कि तू अपना बारे मे का बोलस हइ?” ");
INSERT INTO goj_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","ओने बोल्यो, “जसो यशायाह भविष्यव्दक्ता ने बोल्यो हइ मी जंगल मे फुकारनआला को आवाज आय खे तुम प्रभु का लिये रस्ता सीधी करणु.” ");
INSERT INTO goj_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","वे दूत जो फरीसीहोन का तरफ से भेज्या गया था. ");
INSERT INTO goj_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","उनने ओकासे यो सवाल पूछ्यो, “अगर तू नी मसीह हइ, अरु नी एलिय्याह, अरु नी उ भविष्यव्दक्ता आय, ते फिर बपतिस्मा क्यु देस हइ?” ");
INSERT INTO goj_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","यहून्ना ने उनखे जवाब दियो, मी पाणी से बपतिस्मा देउस हइ, पर तुम्हारा बीच मे एक इन्सान खडो हइ, जेखे तुम खे नी मालुम. ");
INSERT INTO goj_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","अगर मरा बाद आनआलो हइ, ओका जुता कि तन्नी मी खोलना का लायक नी. ");
INSERT INTO goj_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","या बातहोन यरदन नद्दी पार बैतनीय्याह मे हुइ खे , जहा यहून्ना बपतिस्मा देतो थो. ");
INSERT INTO goj_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","दूसरा दिन यहून्ना यीशु खे अपना तरफ आते देखी खे बोल्यो, “देखनु, यो परमेश्वर को मेडो हइ जो जगत को पाप उठै ली जास हइ. ");
INSERT INTO goj_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","यो उ आय, जोका बारे मे मेने बोल्यो थो, कि एक इन्सान मरा पीछे आस हइ, जो मरा से बडो हइ, क्युकि उ मरासे पैयले थो. ");
INSERT INTO goj_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","अरु मी तो ओखे परछानतो नी थो, पर येका लिये मी तो पाणी से बपतिस्मा देतो आयो, कि उ इस्राएल पर प्रगट हुइ जाह्ये.” ");
INSERT INTO goj_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","अरु यहून्ना ने या गवइ दी, मेने आत्मा खे कबूतर का रुप मे स्वर्ग से उतरता देख्यो हइ, अरु उ ओ पर ठैरी गयो. ");
INSERT INTO goj_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","अरु मी तो ओखे परछानतो नी थो, पर जो ने मेखे पानी से बपतिस्मा देन खे भेज्यो, ओने मेखे बोल्यो, जोका पर तू आत्मा खे उतरते अरु रोखते देख्यो. उ पवित्र आत्मा से बपतिस्मा देनालो हइ. ");
INSERT INTO goj_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","अरु मेने देख्यो, अरु गवइ दी हइ कि यो मे परमेश्वर को बेटो हइ. ");
INSERT INTO goj_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","दूसरा दिन फिर यहून्ना अरु ओका सेवक मे से दो झन खडा हुया था. ");
INSERT INTO goj_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","अरु ओने यीशु पर जो जै रो थो, नजर करीखे बोल्यो, “देखनु, यो परमेश्वर को मेडो हइ.” ");
INSERT INTO goj_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","तब वे दो सेवक ओकी सुनीखे यीशु का पीछे गया. ");
INSERT INTO goj_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","यीशु ने घुमी खे अरु उनखे पीछे आते देखी खे उनसे बोल्यो, “तुम को की खोज मे हइ?” उनने ओकासे बोल्यो, “हे गुरु, मंनजे हे गुरु, तू खा र्‍हेस हइ?” ");
INSERT INTO goj_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","ओने उनसे बोल्यो, “चल, ते देखी लिये” तब उनने अय, ओकी र्‍हेन कि जगा देखी, अरु उ दिन ओका साथ र्‍हिया. अरु यो दसवा घंटा का नजीकपास थो. ");
INSERT INTO goj_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","वे दोइ मे से, जो यहून्ना की बात सुनीखे यीशु का पीछे चली गया था, एक शमौन पतरस को भैइ अन्द्रियास थो. ");
INSERT INTO goj_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","ओने पैयले अपना सगो भैइ शमौन से मीलीखे ओकासे बोल्यो, “हमखे ख्रिस्त अगर मसीह मीली गयो.” ");
INSERT INTO goj_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","उ ओखे यीशु का पास लायो यीशु ने ओका पर नजर करीखे बोल्यो, “तू यहून्ना को बेटो शमौन हइ, तू कैफा मंनजे पतरस कहलाये.” ");
INSERT INTO goj_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","दूसरा दिन यीशु ने गलील खे जानो चाह्यो, अरु फिलिप्पुस से मीलीखे बोल्यो, “मरा पीछे अय जा.” ");
INSERT INTO goj_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","फिलिप्पुस तो अन्द्रियास अरु पतरस को नगर बैतसैदा को नीवासी थो. ");
INSERT INTO goj_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","फिलिप्पुस ने नतनएल से मीलीखे ओकासे बोल्यो, “जेको वर्णन मूसा ने व्यवस्था मे अरु भविष्यव्दक्ताहोन ने कर्यो हइ, उ हमखे मीली गयो. उ यूसुफ को बेटो, यीशु नासरत हइ.” ");
INSERT INTO goj_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","नतनएल ने ओकासे बोल्यो “कोय अच्छी चिज भी “नासरत से नीकली सकस हइ?” फिलिप्पुस ने ओकासे बोल्यो, “चलीखे देखी ले.” ");
INSERT INTO goj_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","यीशु ने नतनएल खे अपना तरफ आते देखीखे ओका बारे मे बोल्यो, “देखनु, यो सच्ची मे इस्त्राएलि हइ येमे कपट नी.” ");
INSERT INTO goj_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","नतनएल ने ओका से बोल्यो, “तू मेखे कसो जानस हइ?” यीशु ने ओखे जवाब दियो, “येका से पैयले कि फिलिप्पुस ने तोखे बुलायो, जब तू अंजीर का झाड का नीचे थो, तब मेने तोखे देख्यो थो.” ");
INSERT INTO goj_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","नतनएल ने ओखे जवाब दियो, “हे गुरु, तू परमेश्वर को बेटो हइ. तू इस्राएल को महा राजो हइ.” ");
INSERT INTO goj_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","यीशु ने ओखे जवाब दियो “मेने जो तरा से बोल्यो, कि मेने तोखे अंजीर का झाड का नीचे देख्यो, तू येका लिए विश्वास करस हइ? तू येका से भी बडा-बडा काम देख्ये.” ");
INSERT INTO goj_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","फिर ओकासे बोल्यो “मी तुम से सच्ची-सच्ची बोलुस हइ कि तुम स्वर्ग खे खुल्यो हुयो, अरु परमेश्वर का स्वर्गदूतहोन खे इन्सान को बेटा का उपर उतरते अरु उपर जाते देख्ये.” ");
INSERT INTO goj_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","तीसरा दिन गलील का काना मे कोय एक का शहर भ्याव थो, अरु यीशु की माय भी व्हा थी. ");
INSERT INTO goj_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","यीशु अरु ओका सेवक भी उ भ्याव मे बुलाया था. ");
INSERT INTO goj_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","जब अंगूर को रस खत्म हुइ गयो, ते यीशु की माय ने उकासे बोल्यो, “उनका पास अंगुरकोरस नी र्‍हियो.” ");
INSERT INTO goj_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","यीशु ने ओकासे बोल्यो, “हे बय मेखे तरा से का काम? अभी मरो टेम नी आयो.” ");
INSERT INTO goj_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","ओकी माय ने सेवकहोन से बोल्यो, “जो कुछ उ तुम से बोल्ये का उ करणु.” ");
INSERT INTO goj_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","व्हा यहूदीयाहोन खे अच्छो करण का लिये पत्थर का छे मडका रख्या था, जोमे दो दो, तीन-तीन मन समाता था. ");
INSERT INTO goj_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","यीशु ने उनसे बोल्यो, “मडका मे पानी भरी दे” तब उनने उनका मुडा तक भरी दियो. ");
INSERT INTO goj_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","तब ओने उनसे बोल्यो, “अरु नीकालीखे खाना का प्रधान का पास लि जा.” अरु वे लि गए. ");
INSERT INTO goj_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","जब खाना को प्रधान ने उ पानी चख्यो, जो अंगूर को रस बनी गया थो अरु नी जानतो थो कि उ खा से आयो हइ. पर जिन सेवकहोन ने पानी नीकल्या थो वे जानता था, ते खाना को प्रधान ने दूल्हा खे बुल्येइ खे ओकासे बोल्यो. ");
INSERT INTO goj_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“हर एक इन्सान पैयले अच्छो अंगूर को रस देस हइ, अरु जब इन्सान पीखे छकी जास हइ, तब मध्यम देस हइ. पर तोने अच्छो अंगूर को रस अभी तक रख छोड्यो हइ.” ");
INSERT INTO goj_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","यीशु ने गलील का काना मे अपनो पयलो चिन्ह देखीखे अपनी महिमा प्रगट करी अरु ओका सेवक होन ने ओका पर विश्वास कर्यो. ");
INSERT INTO goj_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","येका बाद उ अरु ओकी माय, ओका भैइ, ओका सेवक, कफरनहूम खे गया अरु व्हा कुछ दिन र्‍हिया. ");
INSERT INTO goj_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","यहूदीयाहोन को फसह को त्योहार पास थो, अरु यीशु यरुशलेम खे गयो. ");
INSERT INTO goj_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","अरु ओने मन्‍दिर मे बैल, अरु मेडो अरु कबूतर खे बेचनआला का तरफ सर्राफाहोन खे बठौ हुया पायो. ");
INSERT INTO goj_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","तब ओने दोरकासहोन को कोडो बनैइ खे, सब मेढाहोन अरु बैलहोन खे मन्‍दिर से नीकाली दियो, अरु सर्राफाहोन का पैसा फैलय दिया,अरु मेज उलट्यै दी. ");
INSERT INTO goj_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","अरु कबूतर बेचनआला से बोल्यो, “इनखे ह्या से लि जा, मरा बाप का भवन खे व्यापार को घर मत बनानु.” ");
INSERT INTO goj_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","तब ओका सेवक होन खे, “याद आयो कि लिख्यो हइ, तरी मन्‍दिर की धुन मेखे खैइ जाये.” ");
INSERT INTO goj_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","येका पर यहूदीयाहोन ने ओकासे बोल्यो, “तू जो यो करस हइ ते हमखे कोनतो चिन्ह दिखास हइ?” ");
INSERT INTO goj_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","यीशु ने उनखे जवाब दियो, “या मन्‍दिर खे गिर्यैइ दे, अरु मी येखे तिन दिन मे खडी करी दिह्यु” ");
INSERT INTO goj_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","यहूदीयाहोन ने बोल्यो, “या मन्‍दिर खे बनाना मे छेचालीस साल लग्या हइ, अरु का तू ओखे तीन दिन मे खडी करी दिये?” ");
INSERT INTO goj_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","पर ओने अपनो आंग पर मन्‍दिर का बारे मे बोलतो थो. ");
INSERT INTO goj_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","फिर जब उ मुर्दा मे से जिन्दो उठ्यो फिर ओका चेलाहोन खे याद आयो कि ओने यो बोल्यो थो. अरु उनने पवित्रशास्त्र अरु उ वचन को जो यीशु ने बोल्यो थो, विश्वास कर्यो. ");
INSERT INTO goj_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","जब उ यरुशलेम मे फसह का टेम को त्योहार मे थो, ते भोतझन ने उ चिन्ह खे जो उ दिखातो थो देखीखे ओका नाम पर विश्वास कर्यो. ");
INSERT INTO goj_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","पर यीशु ने अपना आप खे उनका विश्वास पर नी छोडनु, क्युकी उ सब खे जानतो थो. ");
INSERT INTO goj_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","अरु ओखे प्रयोजन नी थो कि इन्सान का बारे मे कोय गवइ दे क्युकी उ खुद जानतो थो कि इन्सान का मन मे का हइ? ");
INSERT INTO goj_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","फरीसीहोन मे से नीकुदेमुस नाम को एक इन्सान थो, जो यहूदीयाहोन को मुखियो थो. ");
INSERT INTO goj_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","ओने रात खे यीशु का पास अयखे ओकासे बोल्यो, “हे गुरु, हम जानस हइ, कि तू परमेश्‍वर का तरफ से गुरु हुइ खे आयो हइ. क्युकी कोय इन चिन्ह खे जो तू दिखास हइ, अगर परमेश्वर ओका साथ नी हइ, ते नी दिखैइ सक्ये” ");
INSERT INTO goj_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","यीशु ने ओखे जवाब दियो, “मी तरा से सच्ची-सच्ची बोलुस हइ, अगर कोय नवा सिरा से नी जन्मे ते परमेश्वर को राज्य देख नी सक्ये.” ");
INSERT INTO goj_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","नीकुदेमुस ने ओकासे बोल्यो, “इन्सान जब बुढो हुइ गयो, ते कसो जन्म लि सकस हइ? उ अपना माय का गर्भ मे दूसरी बार प्रवेश करीखे जन्म लि सकस हइ?” ");
INSERT INTO goj_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","यीशु ने जवाब दियो, “मी तरा से सच्ची-सच्ची बोलुस हइ, जब तक कोय इन्सान पानी अरु आत्मा से नी जन्मे ते उ परमेश्वर को राज्य मे प्रवेश नी करी सक्ये. ");
INSERT INTO goj_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","क्युकी जो आंग से जन्म्यो हइ, वह आंग हइ. अरु जो आत्मा से जन्म्यो हइ, उ आत्मा हइ. ");
INSERT INTO goj_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","अचम्बो नी करणु कि मेने तरा से बोल्यो, ‘तोखे नवा सिरा से जन्म लेनो जरुरी हइ.’ ");
INSERT INTO goj_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","हवा जिधर चलस हइ उधर चलस हइ, अरु तू ओकी अवाज सुनस हइ, पर नी जानु, कि वा खा से आस अरु किधर खे जास हइ? जो कोइ आत्मा से जन्म्यो हइ उ असा मे हइ.” ");
INSERT INTO goj_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","नीकुदेमुस ने ओखे जवाब दियो, “या बातहोन कसी हुइ सकस हइ?” ");
INSERT INTO goj_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","यो सुनीखे यीशु ने ओकासे बोल्यो, “तू इस्राएलिहोन को गुरु हुइखे भी का या बातहोन खे नी समझ्यो?” ");
INSERT INTO goj_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","मी तरा से सच्ची-सच्ची बोलुस हइ कि हम जो जानस हइ, उ बोलस हइ, अरु जेखे हमने देख्यो हइ ओकी गवइ देस हइ, अरु तुम हमारी गवइ स्वीकार नी करस. ");
INSERT INTO goj_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","जब मेने तुम से पृथ्वी की बातहोन बोली, अरु तुम विश्वास नी कर्‍हे, ते अगर मी तुम से स्वर्ग की बातहोन बोलुका ते फिर क्यु विश्वास कर्ये? ");
INSERT INTO goj_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","कोय स्वर्ग पर नी चड्यो, फक्त उ जो स्वर्ग से उतर्यो, अगर इन्सान को बेटो जो स्वर्ग मे हइ. ");
INSERT INTO goj_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","अरु जिस तरह से मूसा ने जंगल मे साप खे उच्चा पर चडायो, चाउ रीति से जरुरती हइ कि इन्सान को बेटो भी उच्चा पर चडायो जाये. ");
INSERT INTO goj_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ताकि जो कोय ओका पर विश्वास कर्ये उ अनन्त जिवन पाये. ");
INSERT INTO goj_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","क्युकी परमेश्वर ने जगत से असो प्रेम रख्यो कि ओने अपनो एकलौतो बेटो दि दियो, ताकि जो कोय ओ पर विश्वास कर्येका उ नाश नी हुइ खे पर अनन्त जिवन पाये. ");
INSERT INTO goj_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","परमेश्वर ने अपना बेटा खे दुन्या मे येका लिये नी भेज्यो, कि जगत पर दण्ड की आज्ञा दे, पर येका लिए कि दुन्या ओका वजेसे उध्दार पाये. ");
INSERT INTO goj_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","जो ओका पर विश्वास करस हइ, ओका पर दण्ड की आज्ञा नी होय, पर जो ओका पर विश्वास नी कर्‍हे, उ दोषी बनायो करी दी चुक्यो हइ. येका लिए कि ओने परमेश्वर का एकलौता बेटा का नाम पर विश्वास नी कर्यो. ");
INSERT INTO goj_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","अरु न्याय की आज्ञा करण यो हइ कि ज्योति जगत मे अय हइ, अरु इन्सानहोन ने अंधारा खे ज्योति से जादा प्रिय जान्यो क्युकी उनको काम बुरो थो. ");
INSERT INTO goj_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","क्युकी जो कोय बुरो करस हइ, उ ज्योति से बैर रखस हइ, अरु ज्योति का पास नी आय, असो नी हो कि ओका काम होन पर इलजाम लगायो जाये. ");
INSERT INTO goj_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","पर जो सच्चीई पर चलस हइ, उ ज्योति का पास आस हइ, ताकि ओका काम मे प्रगट हो कि उ परमेश्वर का तरफ से कर्यो गयो हइ. ");
INSERT INTO goj_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","येका बाद यीशु अरु ओको सेवक यहूदीया देस मे आया. अरु उ व्हा उनका साथ र्‍हिखे बपतिस्मा देन लग्यो. ");
INSERT INTO goj_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","अरु यहून्ना भी सालेम का पास एनोन मे बपतिस्मा देतो थो, क्युकी व्हा भोत पानी थो, अरु इन्सानहोन अय खे बपतिस्मा लेता था. ");
INSERT INTO goj_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","क्युकी यहून्ना वा टेम्म तक जोल खाना मे नी डाल्यो गयो थो. ");
INSERT INTO goj_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","व्हा यहून्ना का सेवकहोन का कोय यहूदीया का साथ अच्छा का बारे मे वाद विवाद हुयो. ");
INSERT INTO goj_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","अरु ओने यहून्ना का पास अयखे ओकासे बोल्यो, “हे गुरु, जो इन्सान यरदन नद्दी का पार तरा साथ था, अरु जोकी तोने गवइ दी हइ. देख, उ बपतिस्मा देस हइ, अरु सब ओका पास आस हइ.” ");
INSERT INTO goj_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","यहून्ना ने जवाब दियो, “जब तक इन्सान खे स्वर्ग से नी दियो जाये तब तक वह कुछ नी मीली सखे . ");
INSERT INTO goj_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","तुम तो आप मे मरा गवइ हइ, कि मेने बोल्यो, कि ‘मी मसीह नी हइ का पन ओका आगे भेजो गयो.’ ");
INSERT INTO goj_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","जोकी दुल्हिन हइ, उ दूलो हइ पर दूला को दोस्त जो खडो हुयो ओकी सुनस हइ, दूला की बात से भोत खुश होस हइ. अब मरी या खुशी पुरी हुइ हइ. ");
INSERT INTO goj_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","जरुरती हइ कि उ बढ़े अरु मी घटू.” ");
INSERT INTO goj_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“जो उपर से आस हइ, उ सबसे अच्छो हइ, जो पृथ्वी से आस पृथ्वी को हइ. अरु पृथ्वी की बातहोन बोलस हइ जो स्वर्ग से आस हइ, उ सब का उपर हइ. ");
INSERT INTO goj_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","जो कुछ ओने देख्यो, अरु सुन्यो हइ, ओकी गवइ देस हइ. अरु कोय ओकी गवइ ग्रहण नी कर्‍हे. ");
INSERT INTO goj_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","जेने ओकी गवइ ग्रहण कर ली ओने या बात पर नीशान दि दी कि परमेश्वर सच्चो हइ. ");
INSERT INTO goj_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","क्युकी जेखे परमेश्वर ने भेज्यो हइ, उ परमेश्वर की बातहोन बोलस हइ क्युकी वा आत्मा नापि खे नी दे. ");
INSERT INTO goj_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","बाप बेटा से प्रेम रखस हइ, अरु ओने सब चिजहोन ओका हात मे दि दी हइ. ");
INSERT INTO goj_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","जो बेटा पर विश्वास करस हइ, अनन्त जिवन ओको हइ. पर जो बेटा की नी माने, उ जिवन खे नी देख्ये पर परमेश्वर की घुस्सा ओका पर र्‍हेस हइ.” ");
INSERT INTO goj_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","फिर जब प्रभु खे मालूम हुयो कि फरीसीहोन ने सुनायो हइ कि यीशु यहून्ना से जादा सेवक बनास अरु उनखे बपतिस्मा देस हइ. ");
INSERT INTO goj_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","अगर यीशु खुद नी क्युकी ओका सेवक बपतिस्मा देता था, ");
INSERT INTO goj_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","तब उ यहूदीयाहोन खे छोडी खे फिर गलील खे चली गयो, ");
INSERT INTO goj_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","अरु ओखे सामरिया से हुइखे जानो जरुरती थो. ");
INSERT INTO goj_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","येकालिये उ सूखार नामक सामरिया का एक नगर तक आयो, जो वा जमीन का पास हइ जेखे याकूब ने अपनो बेटो यूसुफ खे दियो थो. ");
INSERT INTO goj_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","अरु याकूब को कुव्वो भी वहीं थो, यीशु रस्ता को थक्यो हुयो उ कुव्वा पर मे बठी गयो, अरु या बात नजीकपास दुपेर का टेम हुइ. ");
INSERT INTO goj_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","इत्ता मे एक सामरिया बय पानी भरन खे अय, यीशु ने ओकासे बोल्यो, “मेखे पानी पिला.” ");
INSERT INTO goj_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","ओका चेलाहोन तो नगर मे खानो मोल लेन खे गए था. ");
INSERT INTO goj_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","वा सामरी बय ने ओकासे बोल्यो, “तू यहूदी हुइखे मेखे सामरी बय से पानी क्यु मागस हइ?” क्युकी यहूदी सामरिहोन का साथ कोय प्रकार को व्यव्हार नी रखे. ");
INSERT INTO goj_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","यीशु ने जवाब दियो, “अगर तू परमेश्वर को वरदान खे जानती अरु यो भी जानती कि उ कोन हइ जो तरा से बोलस हइ, मेखे पानी पिला का ते तू ओकासे मागती का अरु उ तोखे जिवन को पानी देती.” ");
INSERT INTO goj_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","बय ने ओकासे बोल्यो, “हे स्वामी, तरा पास पानी भरन खे तो कुछ हइ भी नी, अरु कुव्वो खोल हइ. ते फिर उ जिवन को पानी तरा पास खा से आयो? ");
INSERT INTO goj_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","का तू हमारो बाप याकूब से बडो हइ, जेने हमखे यो कुव्वो दियो. अरु खुद ही अपना सन्तान अरु अपना जनवरहोन समेत ओमे से पीयो?” ");
INSERT INTO goj_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","यीशु ने ओखे जवाब दियो, “जो कोय यो पानी पीये उ फिर प्यासो हुये. ");
INSERT INTO goj_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","पर जो कोय उ पानी मे से पीये जो मी ओखे दियु, उ फिर पिडमपिडि तक प्यासो नी हुये. क्युकी जो पानी मी ओखे दियु, उ ओमे एक झरनो बनी जाये, जो अनन्त जिवन का लिये उमडतो र्‍हिये” ");
INSERT INTO goj_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","बय ने ओकासे बोल्यो, “हे प्रभु, उ पानी मेखे दे ताकिस मी प्यासी नी हुयु अरु नी पानी भरन खे इत्ता दूर आयु.” ");
INSERT INTO goj_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","यीशु ने ओकासे बोल्यो, “जा, अपना अदमी खे ह्या बुलैखे ला.” ");
INSERT INTO goj_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","बय ने जवाब दियो, “मी बिना अदमी की हइ,” यीशु ने ओकासे बोल्यो, “तू ठीक बोलस हइ, ‘मी बिना अदमी की हइ.’ ");
INSERT INTO goj_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","क्युकी तू पाच अदमी करी चुकी हइ, अरु जोका पास तू अब हइ उ भी तरो अदमी नी यो तोने सच्ची बोल्यो हइ.” ");
INSERT INTO goj_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","बय ने ओकासे बोल्यो, हे प्रभु, मेखे लगस हइ कि तू भविष्यव्दक्ता हइ. ");
INSERT INTO goj_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","हमारा बाप दादाहोन ने यो टेकडा पर परमेश्वर कि आराधना करी, अरु तुम बोलस हुये कि वा जगा झा आराधना करन खे होनु व्हा यरुशलेम मे हइ.स ");
INSERT INTO goj_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","यीशु ने ओकासे बोल्यो, “हे बय, मरी बात को विश्वास कर कि उ टेम आयो हइ कि तुम नी ते या टेकडि पर बाप को भजन कर्ये, नी यरुशलेम मे. ");
INSERT INTO goj_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","तुम जेखे नी जाने, ओको भजन करस हइ. अरु हम जेखे जानस हइ, ओको भजन करस हइ. क्युकी उध्दार यहूदीहोन मे से हइ. ");
INSERT INTO goj_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","पर उ टेम आयो हइ, क्युकी अब भी हइ, जेमे सच्चो भक्त बाप की आराधना आत्मा अरु सच्चीय से कर्ये, क्युकी बाप अपना लिये असोय भक्तहोन खे ढूढस हइ. ");
INSERT INTO goj_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","परमेश्वर आत्मा हइ, अरु जरुरी हइ कि ओकी आराधना करणआला आत्मा अरु सच्चीइ से आराधना करणु.” ");
INSERT INTO goj_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","बय ने ओकासे बोल्यो, “मी जानुस हइ कि मसीह जो ख्रिस्त बोलस हइ, आनआला हइ. जब उ आह्ये ते हमखे सब बातहोन बतै दिये.” ");
INSERT INTO goj_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","यीशु ने ओकासे बोल्यो, “मी जो तरा से बोली रो हइ , उ हइ.” ");
INSERT INTO goj_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","इत्ता मे ओका सेवक अय गया , अरु अचम्बो करण लग्या कि वा बय से बात करी रो हइ. फिर भी कोय ने नी पूछ्यो, “तू का चाहस हइ?” या “को का लिये ओकासे बात करस हइ?” ");
INSERT INTO goj_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","तब बय अपनो मडका खे छोडी खे नगर मे चली गइ, अरु इन्सानहोन से बोलन लगी, ");
INSERT INTO goj_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“एक इन्सान खे देख्यो, जो ने सब कुछ जो मेने कर्यो मेखे बतय दियो का योही तो मसीह नी हइ?” ");
INSERT INTO goj_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","तब वे नगर से नीकली खे ओका पास आन लग्या. ");
INSERT INTO goj_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","इत्ता मे ओका सेवक यीशु से या प्रार्थना करण लग्या, “हे गुरु, कुछ ले.” ");
INSERT INTO goj_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","पर ओने उनसे बोल्यो, “मरा पास खान का लिये असो खानो हइ जेखे तुम नी जाने.” ");
INSERT INTO goj_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","तब सेवकहोन ने आपस मे बोल्यो, “का कोय ओका लिये कुछ खान खे लायो हइ?” ");
INSERT INTO goj_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","यीशु ने उनसे बोल्यो, “मरो खानो यो हइ, कि अपना भेजनआला की इच्छा का अनुसार चल्यू अरु ओको काम पूरो कर्यु. ");
INSERT INTO goj_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","का तुम नी बोले, ‘पीक काटना मे अब भी चार महीना बाकी हइ’ देखनु, मी तुम से बोलुस हइ, अपनी आखहोन उठैखे खेतहोन पर नजर डालनु, कि वे काटन का लिये पकी चुक्या हइ. ");
INSERT INTO goj_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","अरु काटन आलो मजुरी पास का अरु अनन्त जिवन का लिये फल बटोरस हइ, ताकि बोनआलो अरु काटन आलो दोइ झन मीलीखे खुशी मनाये. ");
INSERT INTO goj_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","क्युकी येका पर या खावत ठीक बठस हइ ‘बोनआलो अरु हइ काटन आलो अरु.’ ");
INSERT INTO goj_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","मेने तुमखे उ खेत काटन का लिये भेज्यो जोमे तुम ने मेहनत नी कर्यो दुसरा ने मेहनत कर्यो अरु तुम उनका मेहनत का फल मे हिस्सेदार हुया.” ");
INSERT INTO goj_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","अरु उ नगर का भोत सा सामरीहोन ने वा बय का बोलना से यीशु पर विश्वास कर्यो. जो ने या गवय दी थी, कि ओने सब कुछ जो मेने कर्यो हइ, मेखे बतै दियो. ");
INSERT INTO goj_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","तब जब या सामरी ओका पास अय, ते ओकासे प्रार्थना करण लगी कि हमारा ह्या र्‍हे, अरु उ व्हा दो दिन तक र्‍हियो. ");
INSERT INTO goj_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","अरु ओका वचन का कारण अरु भी भोतझन ने विश्वास कर्यो. ");
INSERT INTO goj_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","अरु वा बय से बोल्यो, “अब हम तरा बोलना मे से विश्वास नी कर्‍हे. क्युकी हमने खुद ही सुनी लियो, अरु जानस हइ कि यो सच मुच ही जगत को उद्धारकर्ता हइ.” ");
INSERT INTO goj_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","फिर उन दो दिन का बाद उ व्हा से नीकलीखे गलील खे गयो. ");
INSERT INTO goj_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","क्युकी यीशु ने खुद ही गवय दी कि भविष्यव्दक्ता अपना देस मे सम्मान नी पाय. ");
INSERT INTO goj_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","जब उ गलील मे आयो, ते गलीली खुशी का साथ ओकासे मील्या. क्युकी जोत्ता काम ओने यरुशलेम मे त्योहार का टेम मे कर्या था, उनने वे सब खे देख्यो थो , क्युकी वे भी त्योहार मे गया था. ");
INSERT INTO goj_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","तब उ फिर गलील का काना मे आयो, झा ओने पानी खे अंगूर को रस बनायो थो उ राजा को एक कर्मचारी थो जोको बेटो कफरनहूम मे बीमार थो. ");
INSERT INTO goj_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","उ यो सुनीखे कि यीशु यहूदीया से गलील मे अय गयो हइ, ओका पास गयो अरु ओकासे प्रार्थना करण लग्यो कि चलीखे मरा बेटा खे अच्छो करी दे क्युकी उ मरना पर हइ. ");
INSERT INTO goj_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","यीशु ने ओकासे बोल्यो, “जब तक तुम चिन्ह अरु अद्भुत काम नी देख्ये तब तक कभी भी विश्वास नी कर्ये” ");
INSERT INTO goj_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","राजा का कर्मचारी ने ओकासे बोल्यो, “हे प्रभु, मरा बेटा का मरना से पैयले चल.” ");
INSERT INTO goj_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","यीशु ने ओकासे बोल्यो, “जा, तरो बेटो जिन्दो हइ” उ इन्सान ने यीशु की बोली हुइ बात पर विश्वास कर्यो अरु चली गयो. ");
INSERT INTO goj_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","उ रस्ता मे थो, कि ओका सेवक ओकासे अयखे मील्या अरु बोलन लग्या, “तरो बेटो जिन्दो हइ.” ");
INSERT INTO goj_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","ओने उनसे पूछ्यो, “कोय घडी उ अच्छो होन लग्यो?” उनने ओकासे बोल्यो, “कल सातवा घण्टा मे ओको ज्वर उतरी गयो.” ");
INSERT INTO goj_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","तब बाप जानी गयो कि यो उ घडी हुयो जो घडी यीशु ने ओकासे बोल्यो, “तरो बेटो जिन्दो हइ,” अरु ओने अरु ओका पुरा घराना ने विश्वास कर्यो. ");
INSERT INTO goj_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","यो दूसरो चिन्ह थो जो यीशु ने यहूदीया से गलील मे अयखे दिखायो. ");
INSERT INTO goj_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","या बातहोन का बाद यहूदीयाहोन को एक त्योहार हुयो, अरु यीशु यरुशलेम खे गयो. ");
INSERT INTO goj_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","यरुशलेम मे मेडा का फाटक का पास एक कुण्ड हइ, जो इब्रानी भाषा मे बैतहसदा बोलस हइ, अरु ओका पाच ओसरी हइ. ");
INSERT INTO goj_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","येका मे भोत सा बीमार, अंधा, लगडा अरु सूख्या आंग आला पानी का हलान की आस मे पडया र्‍हेता था. ");
INSERT INTO goj_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","क्युकी चुन्या टेम पर परमेश्‍वर का स्वर्गदूत कुण्ड मे उतरीखे पानी खे हलायो करता था पानी हलाते मे जो कोय पैयले उतरतो, उ अच्छो हुइ जातो थो, चाह्ये ओकी कोय बीमारी क्यु नी हो. ");
INSERT INTO goj_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","व्हा एक इन्सान थो, जो अडतीस साल से बीमारी मे पड्यो थो. ");
INSERT INTO goj_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","यीशु ने ओखे पड्यो हुयो देखीखे अरु यो जानीखे कि उ भोत दिनहोन से योही दशा मे पड्यो हइ, ओकासे पूछ्यो “का तू अच्छो होनो चाहस हइ?” ");
INSERT INTO goj_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","उ बीमार ने ओखे जवाब दियो, “हे स्वामी, मरा पास कोय इन्सान नी, कि जब पानी हलायो जाये, ते मेखे कुण्ड मे उतारनु. पर मरा पहुचते-पहुचते दूसरो मरासे पैयले उतरी जास हइ.” ");
INSERT INTO goj_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","यीशु ने ओकासे बोल्यो, “उट, अपनी खटिया उठा अरु चल फिर.” ");
INSERT INTO goj_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","उ इन्सान तुरुत अच्छो हुइ गयो, अरु अपनी खटिया उठैइखे चलन फिरन लग्यो. ");
INSERT INTO goj_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","उ अराम को दिन थो, येका लिए यहूदीया ओकासे जो अच्छो हुयो थो, बोलन लग्यो, “आज तो अराम को दिन हइ, तोखे खटिया उठानो अच्छो नी.” ");
INSERT INTO goj_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","ओने उनखे जवाब दियो, “जेने मेखे अच्छो कर्यो, ओने मरासे बोल्यो, अपनी खटिया उठैइखे चल फिर.” ");
INSERT INTO goj_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","उनने ओकासे पुछ, “उ कोन इन्सान हइ, जो ने तरा से बोल्यो, खटिया उठा अरु चल फिर?” ");
INSERT INTO goj_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","पर जो अच्छो हुइ गयो थो, उ नी जानतो थो कि उ कोन हइ. क्युकी वा जगा मे गर्दी होना कारण यीशु व्हा से हटी गयो थो. ");
INSERT INTO goj_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","या बातहोन का बाद उ यीशु खे मन्‍दिर मे मील्यो, तब ओने ओकासे बोल्यो, “देख, तू तो अच्छो हुइ गयो हइ. फिर से पाप मत करणु, असो नी हुये कि येका से कोय भारी विपत्ति तरा पर अय पड्ये.” ");
INSERT INTO goj_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","उ इन्सान ने जैइखे यहूदीयाहोन से बोली दियो, कि जो ने मेखे अच्छो कर्यो, उ यीशु हइ. ");
INSERT INTO goj_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","यो वजेसे यहूदीया यीशु खे सतान लग्या, क्युकी उ असो-असो काम अराम का दिन करतो थो. ");
INSERT INTO goj_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","येका पर यीशु ने उनसे बोल्यो, “ मरो बाप अब तक काम करस हइ, अरु मी भी काम करुस हइ.” ");
INSERT INTO goj_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","येका वजेसे यहूदीया अरु भी जादा ओखे मारी डालन की कोशीस करण लग्या, कि उ नी फक्त आराम का दिन की विधी खे तोडतो, पर परमेश्वर खे अपनो बाप बोलीखे, अपना आप खे परमेश्वर का बराबर ठहरातो थो. ");
INSERT INTO goj_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","येका पर यीशु ने उनसे बोल्यो, मी तुम से सच्ची-सच्ची बोलुस हइ, बेटो खुद से कुछ नी करी सकतो; फक्त उ जो बाप खे करते देखस हइ, क्युकी जो काम होन खे उ करस हइ, उनखे बेटो भी उ रीति से करस हइ. ");
INSERT INTO goj_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","क्युकी बाप बेटा से प्रेम करस हइ. अरु जो-जो काम उ खुद करस हइ, उ सब ओखे दिखस हइ. अरु उ इनसे भी बडा काम ओखे दिखाये का ताकि तुम अचम्बो करणु. ");
INSERT INTO goj_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","क्युकी जसो बाप मऱ्या हुया खे उठास अरु जिलास हइ, ओसो ही बेटो भी जेखे चाहस हइ, उनखे जिलास हइ. ");
INSERT INTO goj_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","बाप कोय को न्याय भी नी कर्‍हे, पर न्याय करण को सब काम बेटा खे सोपी दियो हइ, ");
INSERT INTO goj_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","येका लिए कि सब इन्सान जसो बाप को सम्मान करस हइ ओसो मे बेटा को भी सम्मान करणु.जो बेटा को सम्मान नी कर्‍हे, उ बाप खे जेने ओखे भेज्यो हइ, सम्मान नी कर्‍हे. ");
INSERT INTO goj_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","मी तुम से सच्ची-सच्ची बोलुस हइ, जो मरो वचन सुनीखे मरा भेजनआला पर विश्वास करस हइ, अनन्त जिवन ओको हइ, अरु ओका पर दण्ड की आज्ञा नी होती पर उ मरना से पार हुइखे जिवन मे प्रवेश करी चुक्यो हइ. ");
INSERT INTO goj_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","“मी तुम से सच्ची-सच्ची बोलुस हइ, उ टेम आस हइ, अरु अब हइ, जेमे मर्यो परमेश्वर का बेटा को शब्द सुन्ये का अरु जो सुन्ये वे जीये. ");
INSERT INTO goj_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","क्युकी जो रीति से बाप अपना आप मे जिवन रखस हइ, उ रीति से ओने बेटा खे भी यो अधिकार दियो हइ कि अपना आप मे जिवन रखनु. ");
INSERT INTO goj_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","अगर ओखे न्याय करण को भी अधिकार दिया हइ, येका लिए कि उ इन्सान को बेटो हइ. ");
INSERT INTO goj_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","येका से अचम्बो मत करणु. क्युकी उ टेम आस हइ, कि जोत्ता कब्रहोन मे हइ, ओको शब्द सुनीखे नीकल्ये. ");
INSERT INTO goj_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","जेने भलाइ करी हइ, वे जिवन का पुनरुत्थान का लिये जी उठ्ये अरु जेने बुरोइ करी हइ, वे दण्ड का पुनरुत्थान का लिये जी उठ्ये. ");
INSERT INTO goj_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“मी अपना आप से कुछ नी करी सकु जसो सुनुस हइ, ओसो न्याय करुस हइ, अरु मरो धर्मी सच्चो हइ. क्युकी मी अपनी इच्छा नी खे पर अपनो भेजन आला की इच्छा चाहुस हइ. ");
INSERT INTO goj_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“अगर मी खुद मे अपनी गवइ दियु. ते मरी गवइ सच्ची नी. ");
INSERT INTO goj_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","एक अरु हइ जो मेरी गवइ देस हइ, अरु मी जानुस हइ कि मरी जो गवइ उ देस हइ, वा सच्ची हइ. ");
INSERT INTO goj_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","तुम ने यहून्ना से पुछ्यो अरु ओने सच्ची की गवइ दी हइ. ");
INSERT INTO goj_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","पर मी अपना बारे मे इन्सान की गवइ नी चाहु. फिर भी मी या बातहोन येका लिये बोलुस हइ, कि तुमखे उध्दार मील्ये. ");
INSERT INTO goj_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","उ तो जलस अरु चमकतो हुयो दिवो थो. अरु तुमखे कुछ देर तक ओका उजाला मे मगन होनो अच्छा लग्यो. ");
INSERT INTO goj_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","पर मरा पास जो गवइ हइ, उ यहून्ना की गवइ से बडी हइ क्युकी जो काम बाप ने मेखे पूरो करण खे सोप्यो हइ अगर योही काम जो मी करुस हइ, वे मरा गवाह हइ, कि बाप ने मेखे भेज्यो हइ. ");
INSERT INTO goj_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","अरु बाप जो ने मेखे भेज्यो हइ, ओ ने मरी गवइ दी हइ तुम ने नी कभी ओकी आवाज सुन्यो, अरु नी ओको रुप देख्यो हइ. ");
INSERT INTO goj_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","अरु ओको वचन खे मन मे स्थिर नी रख्ये क्युकी जेखे ओने भेज्यो तुम ओका पर विश्वास नी कर्‍हे. ");
INSERT INTO goj_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","तुम पवित्रशास्त्र मे ढूडस हइ, क्युकी समझस हइ कि ओमे अनन्त जिवन तुमखे मीलस हइ, अरु यो उ हइ, जो मरी गवइ देस हइ. ");
INSERT INTO goj_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","फिर भी तुम जिवन पान का लिये मरा पास आनो नी चाह्ये. ");
INSERT INTO goj_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“मी इन्सानहोन से सम्मान नी चाहु. ");
INSERT INTO goj_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","पर मी तुमखे जानुस हइ, कि तुम मे परमेश्वर को प्रेम नी. ");
INSERT INTO goj_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","मी अपना बाप को नाम से आयो हइ, अरु तुम मेखे ग्रहण नी कर्‍हे. अगर कोय अरु अपना ही नाम से आयो, ते ओखे ग्रहण करी लिये. ");
INSERT INTO goj_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","तुम जो एक दूसरा से सम्मान चाहस हइ अरु उ सम्मान जो एकमात्र परमेश्वर का तरफ से हइ, नी चाह्ये, कि कोय प्रकार विश्वास करी सकस हइ? ");
INSERT INTO goj_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","यो नी समझनु कि मी बाप का सामने तुम पर दोस लगाह्यु, तुम पर दोस लगानआलो तो हइ, यानेकी मूसा हइ जेका पर तुम ने भरोसो रख्यो हइ. ");
INSERT INTO goj_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","क्युकी अगर तुम मूसा पर विश्वास करस, ते मरा पर भी विश्वास करस, येका लिए कि ओने मरा बारे मे लिख्यो हइ. ");
INSERT INTO goj_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","पर अगर तुम ओकी लिखी हुइ बातहोन पर विश्वास नी कर्‍हे, ते मरी बातहोन पर का विश्वास कर्ये?” ");
INSERT INTO goj_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","या बातहोन का बाद यीशु गलील को तललाव मंनजे तिबिरियुस की तलाव का पार गयो. ");
INSERT INTO goj_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","अरु एक बडी गर्दी ओका पीछे हुइ गइ क्युकी जो आश्चर्य कर्म उ बीमारहोन पर दिखातो थो वे उनखे देखेता था. ");
INSERT INTO goj_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","तब यीशु टेकडी पर चडीखे अपना सेवक होन का साथ व्हा बठ्यो. ");
INSERT INTO goj_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","अरु यहूदीयाहोन को फसह को त्योहार पास थो. ");
INSERT INTO goj_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","तब यीशु ने अपनी आखहोन उठ्यैखे एक बडी गर्दी खे अपना पास आते देख्यो, अरु फिलिप्पुस ने बोल्यो, “ हम इनखे खान का लिये खा से रोटी मोल लाह्या?” ");
INSERT INTO goj_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","पर ओने या बात ओखे परखन का लिये बोली. क्युकी उ खुद जानतो थो कि उ का कर्ये. ");
INSERT INTO goj_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","फिलिप्पुस ने ओखे जवाब दियो, “दो सौ सिक्का की रोटी भी उनका लिये पूरी नी हुये कि उनमे से हर एक खे थोड़ी-थोड़ी मीली जाये.” ");
INSERT INTO goj_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","ओका सेवक होन मे से शमौन पतरस को भैइ अन्द्रियास ने ओकासे बोल्यो , ");
INSERT INTO goj_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“ह्या एक पोर्यो हइ, जोका पास जौ की पाच रोटी अरु दो मच्छीहोन हइ, पर इत्ता दुन्या का लिये वे का हइ.” ");
INSERT INTO goj_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","यीशु ने बोल्यो, “दुन्याहोन कि बठ्यैइ दे” वा जगा भोत घास था, तब वे दुन्या जो गिनती मे नजीकपास पाच हजार था, बठी गा. ");
INSERT INTO goj_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","तब यीशु ने रोटिहोन लीखे अरु धन्यवाद करीखे बठन आलाहोन खे बाटी खे बाटी दी. अरु ओसो मे मच्छीहोन मे से जोतनी वे चाहता था बाटी दि. ");
INSERT INTO goj_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","जब वे खैइ खे मगम हुइ गया, ते ओने अपना सेवक होन से बाटी ले बोलयो, “बच्या हुया टुकडा से बारा टोपली जमा करी ले, कि कुछ फेक्यो नी जाये.” ");
INSERT INTO goj_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","येका लिये उनने जमा हुया, अरु जौ की पाच रोटिहोन का टुकडा जो खानआला से बची र्‍हि थी, उनकी बारह टोपलीहोन भरी. ");
INSERT INTO goj_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","तब जो आश्चर्यकर्म ओने करी दिखायो ओखे वे इन्सान देखी खे बोलन लग्या. कि “उ भविष्यव्दक्ता जो जगत मे आनआलो थो जरुरत योही हइ.” ");
INSERT INTO goj_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","यीशु यो जानीखे कि वे ओखे राजो बनान का लिये अयखे पकडनो चाहस हइ, फिर टेकडी पर अयखेलो चले गयो. ");
INSERT INTO goj_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","फिर जब संज्जा हुइ, ते ओका सेवक होन से झील का किनारा गया, ");
INSERT INTO goj_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","अरु डोंगा पर चडीखे झील का पार कफरनहूम खे बिदा करण लग्यो वा टेम अधारो हुइ गयो थो, अरु यीशु अभी तक उनका पास नी आयो थो. ");
INSERT INTO goj_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","अरु आधी करण झील मे लहरहोन उठन लगी. ");
INSERT INTO goj_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","तब जब वे खेते-खेते तीन चार मील का नजीकपास नीकली गया, ते उनने यीशु खे झील पर चलता, अरु डोगा का पास आते देख्यो, अरु डरी गया. ");
INSERT INTO goj_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","पर ओने उनसे बोल्यो, हिम्मत रख मी आयो, डरनु मत. ");
INSERT INTO goj_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","तब वे ओखे डोंगा पर चडैइ देन का लिये तैयार हुया अरु जल्दी उ डोंगा उ जमीन पर जा पहुच्यो जहा उ जातो थो. ");
INSERT INTO goj_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","दूसरा दिन वा गर्दी ने जो झील का पार खड़ी थी, यो देख्यो, कि यो एक खे छोडी खे अरु कोय छोटा डोंगा नी थो, अरु यीशु अपना सेवक होन का साथ वा डोंगा पर नी चड्यो, पर फक्त ओका सेवक मे गया था. ");
INSERT INTO goj_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","ते भी अरु छोटी डोगाहोन तिबिरियुस से वा जगा पास अय, झा उनने प्रभु खे धन्यवाद करण का बाद रोटी खय थी. ");
INSERT INTO goj_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","जब गर्दी ने देख्यो, कि ह्या नी यीशु हइ, अरु नी ओका सेवक, ते वे भी छोटी-छोटी डोगाहोन पर चडी खे यीशु खे ढुढतो हुया कफरनहूम खे पहुच्या. ");
INSERT INTO goj_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","अरु झील का पार ओकासे मीलीखे बोल्यो, “हे गुरु, तू ह्या कब आयो?” ");
INSERT INTO goj_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","यीशु ने उनखे जवाब दियो, “मी तुम से सच्ची-सच्ची बोलुस हइ, तुम मेखे येका लिए नी ढूढस हइ कि तुम ने चमत्कार काम देख्या, पर येका लिए कि तुम रोटिहोन खैइ खे तृप्त हुया. ");
INSERT INTO goj_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","नाशवान खाना का लिये परिश्रम नी करणु, पर उ खाना का लिये जो अनन्त जिवन तक ठैइरस हइ, जेखे इन्सान को बेटो तुमखे दिये क्युकी बाप खे मंनजे परमेश्वर ने ओका पर नीशान करी दी हइ.” ");
INSERT INTO goj_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","उनने ओकासे बोल्यो, “परमेश्वर काम कारण का लिये हम खे करणु?” ");
INSERT INTO goj_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","यीशु ने उनखे जवाब दियो, “परमेश्वर को काम यो हइ, कि तुम ओका पर जेखे ओने भेज्यो हइ, विश्वास करणु.” ");
INSERT INTO goj_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","तब उनने ओकासे बोल्यो, “फिर तू कोन सो चिन्ह दिखास हइ कि हम ओखे देखीखे तरा पर विश्वास करणु? तू कोन सो काम दिखास हइ? ");
INSERT INTO goj_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","हमारा बुजुरुखहोन ने जंगल मे मेडो खायो. जसो लिख्यो हइ, ‘ओने उनखे खान का लिये स्वर्ग से रोटी दी.’” ");
INSERT INTO goj_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","यीशु ने उनसे बोल्यो, “मी तुम से सच्ची-सच्ची बोलुस हइ कि मूसा ने तुमखे वा रोटी स्वर्ग से नी दी, पर मरो बाप तुमखे सच्ची रोटी स्वर्ग से देस हइ. ");
INSERT INTO goj_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","क्युकी परमेश्वर की रोटी वाइ हइ, जो स्वर्ग से उतरीखे जगत खे जिवन देस हइ.” ");
INSERT INTO goj_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","तब उनने ओकासे बोल्यो, “हे स्वामी, या रोटी हमखे हमेशा दिया करणु.” ");
INSERT INTO goj_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","यीशु ने उनसे बोल्यो, “जिवन की रोटी मी हइ जो मरा पास आह्ये उ कभी भूखो नी हुये अरु जो मरा पर विश्वास कर्ये उ कभी प्यासो नी हुये. ");
INSERT INTO goj_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","पर मेने तुम से बोल्यो, कि तुम ने मेखे देखी भी लियो हइ, ते भी विश्वास नी कर्ये. ");
INSERT INTO goj_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","जो कुछ बाप मेखे देस हइ वे सब मरा पास अह्ये का अरु जो कोय मरा पास आह्ये ओखे मी कभी नी नीकालीयु. ");
INSERT INTO goj_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","क्युकी मी अपनी इच्छा नी क्युकी अपना भेजनआला की इच्छा पूरी करण का लिये स्वर्ग से उतर्यो हइ. ");
INSERT INTO goj_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","अरु मरा भेजनआला की इच्छा या हइ कि जो कुछ ओने मेखे दियो हइ, ओमे से मी कुछ नी खोयु पर ओखे अन्नत दिन फिर जिन्दो उठायु. ");
INSERT INTO goj_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","क्युकी मरा बाप की इच्छा या हइ, कि जो कोय बाप खे देख्ये का अरु बेटा पर विश्वास कर्यु, उ अन्नत जिवन पाये. अरु मी ओखे अनन्त दिन मे फिर जिन्दो उठायु.” ");
INSERT INTO goj_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","तब यहूदीया ओका पर कुरकुर करण लग्या, येका लिए कि ओने बोल्यो थो, “जो रोटी स्वर्ग से उतरी खे वा मी हइ.” ");
INSERT INTO goj_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","अरु उनने बोल्यो “ का यो यूसुफ को बेटो यीशु नी, जोका माय बाप खे हम जानस हइ? ते उ क्यु बोलस हइ कि मी स्वर्ग से उतर्यो हइ?” ");
INSERT INTO goj_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","यीशु ने उनखे जवाब दियो, “आपस मे मत कुरकुरानु. ");
INSERT INTO goj_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","कोय मरा पास नी अय सक्ये का जब तक बाप जेने मेखे भेज्यो हइ, ओखे खीची नी ले. अरु मी ओखे अन्नत दिन फिर जिला उठायु. ");
INSERT INTO goj_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","भविष्यव्दक्ताहोन कि किताबहोन मे यो लिख्यो हइ वे सब परमेश्वर का तरफ से सिखाया हुया हुये खे जेखे कोय ने बाप से सुन्यो अरु सीख्यो हइ, उ मरा पास आस हइ. ");
INSERT INTO goj_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","यो नी, कि कोय ने बाप खे देख्यो हइ पर जो परमेश्वर का तरफ से हइ, फक्त ओ ने बाप खे देख्यो हइ. ");
INSERT INTO goj_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","मी तुम से सच्ची-सच्ची बोलुस हइ, कि जो कोय विश्वास करस हइ, अनन्त जिवन ओ को हइ. ");
INSERT INTO goj_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","जिवन की रोटी मी हइ. ");
INSERT INTO goj_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","तुमारा बुजुरुखहोन ने जंगल मे मन्ना खायो अरु मरी गया. ");
INSERT INTO goj_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","या वा रोटी हइ जो स्वर्ग से उतरस हइ ताकि इन्सान ओमे से खाये अरु नी मर्ये. ");
INSERT INTO goj_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","जिवन की रोटी जो स्वर्ग से उतरी मी आय अगर कोय या रोटी मे से खाये ते कभी भी जीवित र्‍हिये. अरु जो रोटी मी जगत कि जिवन का लिये दिह्यु, उ मरो मास हइ.” ");
INSERT INTO goj_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","येका पर यहूदीया यो बोलीखे आपस मे झगडन लग्या, “यो इन्सान कसो हमखे अपनो मास खान खे दि सकस हइ?” ");
INSERT INTO goj_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","यीशु ने उनसे बोल्यो, “मी तुम से सच्ची-सच्ची बोलुस हइ जब तक इन्सान का बेटा को मास नी खाये, अरु ओको खुन नी पीयेका तुम मे जिवन नी. ");
INSERT INTO goj_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","जो मरो मास खास अरु मरो खुन पीस हइ, अनन्त जिवन ओ को हइ, अरु मी अन्नत दिन फिर ओखे जिन्दो उठाह्ये. ");
INSERT INTO goj_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","क्युकी मरो मास वास्तव मे खान की चिज हइ अरु मरो खुन वास्तव मे पीन की चिज हइ. ");
INSERT INTO goj_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","जो मरो मास खाये अरु मरो खुन पीस हइ, उ मरा मे स्थिर बन्यो र्हेस हइ, अरु मी ओमे. ");
INSERT INTO goj_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","जसो जीन्दा बाप ने मेखे भेज्यो अरु मी बाप का करण जिन्दो हइ ओसा मे उ भी जो मेखे खाये मरा कारण जिन्दो र्‍हिये. ");
INSERT INTO goj_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","जो रोटी स्वर्ग से उतरी या हइ, बुजुरुखहोन का जसा नी कि खायेका अरु मरी गया. जो कोय या रोटी खाये उ कभी भी जिन्दो र्‍हिये.” ");
INSERT INTO goj_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","ये बातहोन ओने कफरनहूम का एक आराधनालय मे उपदेस देता टेम बोली. ");
INSERT INTO goj_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","येका लिये ओका सेवकहोन मे से भोतजन ने यो सुनीखे बोल्यो, “या तो कठोर शिक्षा हइ. येखे कोन मानी सकस हइ?” ");
INSERT INTO goj_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","यीशु ने अपना मन मे यो जानीखे कि मरा सेवक आपस मे या बात पर कुरकुर करीस हइ, उनसे पूछ्यो का “या बात से तुमखे ठोकर लगस हइ? ");
INSERT INTO goj_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","अरु अगर तुम इन्सान का बेटा खे झा उ पैयले थो, व्हा उपर जाता देख्ये का ते हुये? ");
INSERT INTO goj_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","आत्मा तो जिवनदायक हइ, आंग से कुछ लाभ नी जो बातहोन मेने तुम से बोली हइ वे आत्मा हइ, अरु जिवन भी हइ. ");
INSERT INTO goj_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","पर तुम मे से खेताने असो हइ जो विश्वास नी कर्‍हे” क्युकी यीशु तो पैयले मे से जानतो थो कि जो विश्वास नी कर्येका वे कोन हइ. अरु कोन मेखे पकडाये. ");
INSERT INTO goj_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","अरु ओने बोल्यो, “येका लिये मेने तुम से बोल्यो थो कि जब तक कोय खे बाप का तरफ से यो वरदान नी दियो जाये तब तक उ मरा पास नी अय सक्ये.” ");
INSERT INTO goj_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","येका पर ओका सेवक होन मे से भोत सारा उल्टा फिरी गया अरु येका बाद ओका साथ नी चल्यो. ");
INSERT INTO goj_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","तब यीशु ने उन बारा जन से बोल्यो का “तुम भी चली जानु चाहस हइ?” ");
INSERT INTO goj_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","शमौन पतरस ने ओखे जवाब दियो, “हे प्रभु, हम कोका पास जाये? अनन्त जिवन की बातहोन तो तरा ही पास हइ. ");
INSERT INTO goj_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","अरु हमने विश्वास कर्यो, अरु जानी गया हइ, कि परमेश्वर पवित्र जन तू ही हइ.” ");
INSERT INTO goj_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","यीशु ने उनखे जवाब दियो का “मेने तुम बारा झन खे नी चुनी लियो? ते भी तुम मे से एक इन्सान सैतान हइ.” ");
INSERT INTO goj_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","यो ओने शमौन इस्करियोती को बेटो यहूदा का बारे मे बोल्यो, क्युकी योही जो उन बारा जन मे से थो, ओखे पकडान खे थो. ");
INSERT INTO goj_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","या बातहोन का बाद यीशु गलील मे फिरतो र्‍हियो, क्युकी यहूदी ओखे मारी डालन का शाजीस करी र्‍हा था, येकालिये उ यहूदीया मे फिरनो नी चाहतो थो. ");
INSERT INTO goj_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","अरु यहूदीहोन कि एक तिवार झोपडिहोन को तिवार पास थो. ");
INSERT INTO goj_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","येकालिये ओका भैइहोन ने ओकासे बोल्यो, “ह्या से कूच करीखे यहूदीया मे चली जा, कि जो काम तू करस हइ, उनखे तरा सेवक भी देख्ये. ");
INSERT INTO goj_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","क्युकी असो कोइ नी हुये जो प्रसिद्ध होनो चाह्ये, अरु रुखी खे काम कर्ये अगर तू यो काम करस हइ, ते अपना आप खे जगत पर प्रगट कर.” ");
INSERT INTO goj_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","क्युकी ओका भैइ भी ओका पर विश्वास नी करता था. ");
INSERT INTO goj_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","तब यीशु ने उनसे बोल्यो, “मरो टेम अभी नी आयो. पर तुमारा लिये सब टेम हइ. ");
INSERT INTO goj_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","जगत तुम से बैर नी कर सक्ये, पर उ मरासे बैर करस हइ, क्युकी मी ओका विरोध मे या गवय देउस हइ, कि ओको काम बुरो हइ. ");
INSERT INTO goj_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","तुम त्योहार मे जाओ. मी अभी यो त्याहार मे नी जउ, क्युकी अभी तक मरो टेम पूरो नी हुयो.” ");
INSERT INTO goj_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","उ उनसे या बातहोन बोलीखे गलील मे र्ही गयो. ");
INSERT INTO goj_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","पर जब ओका भैइ त्योहार मे चली गया, ते उ खुद मे प्रगट मे नी, पर माननु गुप्त हुइखे गया. ");
INSERT INTO goj_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","यहूदी त्योहार मे ओखे यो बोलीखे ढूढ़न लग्या कि “उ खा हइ?” ");
INSERT INTO goj_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","अरु दुन्या मे ओका बारे चुपखे-चुपखे भोत सी बातहोन हुइ कत्ता बोलता था, “उ अच्छो इन्सान हइ” अरु कत्ता बोलता था, “नी, उ दुन्याहोन खे भरमास हइ.” ");
INSERT INTO goj_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","ते भी यहूदीहोन का डर का मारे कोय इन्सान ओका बारे मे खुली खे नी बोलतो थो. ");
INSERT INTO goj_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","अरु जब त्योहार का आधो दिन बीती गयो. ते यीशु मन्दिर मे जैइखे उपदेस करण लग्यो. ");
INSERT INTO goj_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","तब यहूदीहोन ने अचम्बो करीखे बोल्यो, “येखे बिन पडी शिक्षन कसी अय गइ?” ");
INSERT INTO goj_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","यीशु ने उनखे जवाब दियो, “मरो उपदेस मरो नी, पर मरो भेजनआला को हइ. ");
INSERT INTO goj_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","अगर कोय ओकी इच्छा पर चलनो चाह्ये, ते उ यो उपदेस का बारे मे जानी जाये कि उ परमेश्वर का तरफ से हइ, या मी अपना तरफ से बोलूस हइ. ");
INSERT INTO goj_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","जो अपना तरफ से कुछ बोलस हइ, उ अपनी मे बढ़ाइ चाहस हइ. पर जो अपना भेजनआला की बडाइ उ चाहस हइ उ सच्ची हइ, अरु ओमे बुरोकाम नी. ");
INSERT INTO goj_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","का मूसा ने तुमखे व्यवस्था नी दी? ते भी तुम मे से कोय व्यवस्था पर नी चले, तुम का मेखे मारी डालनो चाहस हइ?” ");
INSERT INTO goj_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","दुन्याहोन ने जवाब दियो “तरा मे बुरीआत्मा हइ! कोन तोखे मारी डालनो चाहस हइ?” ");
INSERT INTO goj_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","यीशु ने उनखे जवाब दियो, “मेने एक काम कर्यो, अरु तुम सब अचम्बो करस हइ. ");
INSERT INTO goj_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","यो कारण मूसा ने तुमखे खतना की आज्ञा दी हइ, यो नी कि उ मूसा का तरफ से हइ पर बुर्जुकहोन से चली अय हइ, अरु तुम अराम का दिन खे इन्सान को खतनो करस हइ. ");
INSERT INTO goj_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","जब अराम का दिन इन्सान को खतनो कर्या जास हइ ताकि मूसा की व्यवस्था की आज्ञा टली नी जाये, ते तुम मरा पर का येकालिये घुस्सा करस हइ, कि मेने अराम का दिन एक इन्सान का पूरी रीति से अच्छो कर्यो. ");
INSERT INTO goj_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","मुडो देखीखे धर्मी नी करणु, पर ठीक-ठीक न्याय करणु.” ");
INSERT INTO goj_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","तब कत्ताने यरुशलेम वासीहोन बोलन लग्या, “का यो उ नी, जेखे मारी डालन की कोशिश कर्यो जय रो हइ? ");
INSERT INTO goj_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","पर देखनु, उ तो खुल्लमखुल्ला बातहोन करस हइ अरु कोय ओकासे कुछ नी बोले. का मुमकीन हइ कि मुखियोहोन ने सच्ची सच्ची जानी लियो हइ. कि योही मसीह हइ? ");
INSERT INTO goj_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","येखे तो हम जानस हइ, कि यो खा को हइ. पर मसीह जब आह्ये, तो कोइ नी जान्ये कि उ खा को हइ.” ");
INSERT INTO goj_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","तब यीशु ने मन्दिर मे उपदेस देते हुये पुकारी खे बोल्यो, “तुम मेखे जानस हइ कि यो भी जानस हइ कि मी खा को हइ, मी तो खुद से नी आयो पर मरो भेजनआलो सच्ची हइ, ओखे तुम नी जाने. ");
INSERT INTO goj_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","मी ओखे जानुस हइ. क्युकी मी ओका तरफ से हइ अरु ओने मेखे भेज्यो हइ.” ");
INSERT INTO goj_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","येका पर उनने ओखे पकडनो चाह्यो ते भी कोय ने ओका पर हात नी डाल्यो, क्युकी ओको टेम अब तक नी आयो थो. ");
INSERT INTO goj_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","अरु गर्दी मे से भोतजन ने ओका पर विश्वास कर्यो, अरु बोलन लग्या, “मसीह जब आह्ये, ते का येकासे जादा चिन्ह खे दिखाये जो येने दिखाया?” ");
INSERT INTO goj_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","फरीसीहोन ने दुन्याहोन खे ओका बारे मे या बातहोन लुकीखे-लुकीखे करता सुन्यो. अरु मुखियो याजकहोन अरु फरीसीहोन ने पकडन खे सेवक भेज्या. ");
INSERT INTO goj_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","येका पर यीशु ने बोल्यो, “मी थोडि देर तक अरु तुमारा साथ हइ. तब अपना भेजनआला का पास चली जायु. ");
INSERT INTO goj_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","तुम मेखे ढूढ्ये का पर नी पाये अरु झा मी हइ, व्हा तुम नी अय सक्ये.” ");
INSERT INTO goj_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","यहूदीहोन ने आपस मे बोल्यो, यो खा जाये कि हम येखे नी पाये? का उ उनका पास जाये जो यूनानीहोन मे तितर-बितर हूइ खे र्‍हेस हइ, अरु यूनानीहोन खे भी उपदेस दिये? ");
INSERT INTO goj_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","या का बात हइ जो उनने बोली कि तुम मेखे ढूढ्ये का पर नी पाये: अरु झा मी हइ, व्हा तुम नी अय सक्ये? ");
INSERT INTO goj_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","फिर त्योहार का अन्नत दिन, जो मुख्य दिन हइ, यीशु खडो हुयो अरु पुकारी खे बोल्यो, “अगर कोइ प्यासो हइ ते मरा पास आनु अरु पीनु. ");
INSERT INTO goj_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","जो मरा पर विश्वास कर्ये, जसो पवित्रशास्त्र मे आयो हइ, ‘ओका अंदर से जिवन कि पानी की नदिहोन बोहय नीकल्ये.’” ");
INSERT INTO goj_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","ओने यो वचन या आत्मा का बारे मे बोल्यो, जो ओका पर विश्वास करण आला पाना पर था. क्युकी आत्मा आब तक नी उतरी थी, क्युकी यीशु आब तक अपनी महिमा खे नी पहुच्यो थो. ");
INSERT INTO goj_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","तब गर्दी मे से कोइ-कोइ ने या बातहोन सुनी खे बोल्यो, “सच मुच योही उ भविष्यव्दक्ता हइ.” ");
INSERT INTO goj_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","दुसराहोन ने बोल्यो, “यो मसीह हइ,” पर कोय ने बोल्यो, “क्यु? का मसीह गलील से आह्ये? ");
INSERT INTO goj_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","का पवित्रशास्त्र मे नी आयो कि मसीह दाउद का वंश से अरु बैतलहम गाव से आह्ये, झा दाउद र्हेतो थो?” ");
INSERT INTO goj_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","अन्नत ओका कारण दुन्याहोन मे फूट पडि. ");
INSERT INTO goj_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","उनमे से कत्ताने ओखे पकडनो चाहता था, पर कोय ने ओका पर हात नी डाल्यो. ");
INSERT INTO goj_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","तब सेवकहोन मुखियो याजकहोन अरु फरीसीहोन का पास आह्ये, अरु उनने उनसे बोल्यो, “तुम ओखे क्यु नी लाये?” ");
INSERT INTO goj_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","सेवकहोन ने जवाब दियो, “कोय इन्सान ने कभी असी बातहोन नी करी.” ");
INSERT INTO goj_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","फरीसीहोन ने उनखे जवाब दियो, “का तुम भी भरमाया गया हइ.” ");
INSERT INTO goj_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","का मुखियोहोन या फरीसीहोन मे से कोय ने भी ओका पर विश्वास कर्यो हइ? ");
INSERT INTO goj_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","पर ये इन्सान जो व्यवस्था नी जाने “का हमारी व्यवस्था कोय इन्सान खे जब तक पैयले ओकी सुनीखे जानी नी ले कि उ का करस हइ. दोषी ठहरास हइ?” ");
INSERT INTO goj_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","नीकुदेमुस ने जो पैयले ओका पास आयो थो अरु उनमे से एक थो, उनसे बोल्यो, ");
INSERT INTO goj_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“का हमारी व्यवस्था कोय इन्सान खे जब तक पैयले ओकी सुनीखे जानी नी ले कि उ का करस हइ; दोषी ठहरास हइ?” ");
INSERT INTO goj_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","उनने ओखे जवाब दियो, “का तू भी गलील को हइ? ढूढ़ अरु देख, कि गलील से कोय भविष्यव्दक्ता प्रगट नी होन को.” ");
INSERT INTO goj_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","तब सब कोय अपना-अपना घर चली गया. ");
INSERT INTO goj_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","पर यीशु जैतून कि टेकडी पर गयो. ");
INSERT INTO goj_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","अरु फजर खे फिर मन्‍दिर मे आयो, अरु सब इन्साहोन ओका पास आया. अरु उ बठीखे उनखे शिक्षन देन लग्यो. ");
INSERT INTO goj_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","तब शास्त्री अरु फरीसी एक बय खे लैइ जो व्यभिचार मे पकडी गइ थी, अरु ओखे बीच मे खडी करीखे यीशु से बोल्यो, ");
INSERT INTO goj_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","“हे गुरु, या बय व्यभिचार करते पकडी गइ हइ. ");
INSERT INTO goj_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","व्यवस्था मे मूसा ने हमखे आज्ञा दी हइ कि असी बयहोन खे पत्थराव करणु. अन्नत तू या बय का बारे मे का बोलस हइ?” ");
INSERT INTO goj_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","उनने ओखे परखनन का लिये या बात बोली ताकि ओका पर इलजम लगान का लिये कोय बात पाये का पर यीशु झुकी खे उंगली से जमीन पर लिखन लग्यो. ");
INSERT INTO goj_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","जब वे ओकासे पुछता र्‍हिया, ते उ सीधो हुइ खे उनसे बोलीखे, “तुम मे जो नीष्पाप हुये उ पैयले ओखे पत्थर मारनु.” ");
INSERT INTO goj_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","अरु फिर झुकी खे जमीन पर उंगली से लिखन लग्यो. ");
INSERT INTO goj_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","पर वे यो सुनी खे बापदादा से लीखे छोटा तक एक-एक करीखे नीकली गया, अरु यीशु अयखेलो र्‍हि गयो, अरु बय व्हा बीच मे खडी ऱ्ही गइ. ");
INSERT INTO goj_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","यीशु ने सीधो हुइ खे ओकासे बोल्यो, “हे बय, वे खा गया? कोय ने तरा पर दण्ड की आज्ञा नी दी?” ");
INSERT INTO goj_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","ओने बोल्यो, “हे प्रभु, कोय ने नी” यीशु ने बोल्यो, “मी भी तरा पर दण्ड की आज्ञा नी देउ. जा अरु फिर पाप नी करणु.” ");
INSERT INTO goj_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","तब यीशु ने फिर दुन्याहोन से बोल्यो, “जगत की ज्योति मी हइ. जो मरा पीछे अह्ये खे उ अंधारा मे नी चल्ये का पर जिवन की ज्योति पाये.” ");
INSERT INTO goj_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","फरीसीहोन ने ओकासे बोल्यो “तू अपनी गवइ खुद देउस हइ. तरी गवइ सच्ची नी.” ");
INSERT INTO goj_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","यीशु ने उनखे जवाब दियो, “अगर मी अपनी गवइ खुद देउस हइ, ते भी मरी गवइ सच्ची हइ, क्युकी मी जानुस हइ, कि मी खा से आयो हइ अरु खा खे जाउस हइ? पर तुम नी जाने कि मी खा से आयो हइ या खा खे जउस हइ. ");
INSERT INTO goj_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","तुम आंग का जसो न्याय करस हइ. मी कोय को न्याय नी करु. ");
INSERT INTO goj_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","अरु अगर मी न्याय कर्हु भी, ते मरो न्याय सच्ची हइ. क्युकी मी अयखेलो नी, पर मी बाप का साथ हइ, जो ने मेखे भेज्यो हइ. ");
INSERT INTO goj_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","अरु तुमारी व्यवस्था मे भी लिख्यो हइ. कि दो जनहोन की गवइ मीलीखे सच्ची होस हइ. ");
INSERT INTO goj_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","एक तो मी खुद अपनी गवइ देउस हइ, अरु दूसरो बाप मरी गवइ देउस हइ जो ने मेखे भेज्यो.” ");
INSERT INTO goj_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","उनने ओकासे बोल्यो, “तरो बाप खा हइ?” यीशु ने जवाब दियो, “नी तुम मेखे जानस हइ, नी मरा बाप खे अगर मेखे जानस, ते मरो बाप खे भी जानता.” ");
INSERT INTO goj_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","ये बातहोन ओने मन्‍दिर मे उपदेस देता हुये दान घर मे बोली, अरु कोय ने ओखे नी पकड्यो. क्युकी ओको टेम अब तक नी आयो थो. ");
INSERT INTO goj_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","ओने फिर उनसे बोल्यो, “मी जउस हइ, अरु तुम मेखे ढूढ्ये अरु अपना पाप मे मर्ये. झा मी जउस हइ, व्हा तुम नी अय सक्ये.” ");
INSERT INTO goj_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","येका पर यहूदीयाहोन ने बोल्यो का उ अपना आप खे मारी डाल्येका जो बोलस हइ, “झा मी जउस हइ व्हा तुम नी अय सक्ये?” ");
INSERT INTO goj_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","ओने उनसे बोल्यो, “तुम नीचे का हइ, मी उपर को हइ. तुम जगत का हइ, मी जगत को नी. ");
INSERT INTO goj_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","येका लिए मेने तुम से बोल्यो, कि तुम अपना पापहोन मे मर्ये. क्युकी अगर तुम विश्वास नी कर्ये कि मी उ हइ, ते अपना पापहोन मे मर्ये.” ");
INSERT INTO goj_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","उनने ओकासे बोल्यो, “तू कोन हइ?” यीशु ने उनसे बोल्यो, “उ हइ जो सुरुवात से तुम से बोलतो आयो हइ. ");
INSERT INTO goj_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","तुमारा बारे मे मेखे भोत कुछ बोलनो अरु नीर्णय करणो हइ पर मरो भेजनआलो सच्ची हइ. अरु जो मेने ओकासे सुन्यो हइ, उ जगत से बोलस हइ” ");
INSERT INTO goj_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","वे नी समझे कि हम बाप का बारे मे बोलस हइ. ");
INSERT INTO goj_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","तब यीशु ने बोल्यो, “जब तुम इन्सान का बेटा खे उच्चा पर चढाये का ते जान्ये कि मी उ हइ, अरु अपना आप से कुछ नी कर्येका पर जसो मरो बाप ने मेखे सिखायो, असो ही या बातहोन बोलुस हइ. ");
INSERT INTO goj_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","अरु मरो भेजनआलो मरा साथ हइ. ओने मेखे एखलो नी छोड्यो. क्युकी मी हमेशा उ काम करुस हइ, जेका से उ प्रसन्‍न होस हइ.” ");
INSERT INTO goj_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","उ या बातहोन बोली र्‍हो थो, कि भोतजन ने ओका पर विश्वास कर्यो. ");
INSERT INTO goj_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","तब यीशु ने वे यहूदीयाहोन से जिन्हे ओका पर विश्वास कर्यो थो, बोल्यो, “अगर तुम मरा वचन मे बन्या र्‍हियेका ते सच मुच मरा सेवक ठैइऱ्यो. ");
INSERT INTO goj_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","अरु सच्चाइ खे जान्येका अरु सच्चाइ तुमखे स्वतत्रता कर्ये.” ");
INSERT INTO goj_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","उनने ओखे जवाब दियो, “हम तो अब्राहम का वंश से हइ, अरु कभी कोय, सेवक नी हुया. फिर तू क्यु बोलस हइ, कि तुम स्वतंत्र हुये जाये?” ");
INSERT INTO goj_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","यीशु ने उनखे जवाब दियो, “मी तुम से सच्ची-सच्ची‍ची बोलुस हइ कि जो कोय पाप करस हइ, उ पाप को सेवक हइ. ");
INSERT INTO goj_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","अरु सेवक कभी भी घर मे नी र्‍हे. बाप हमेशा र्हेस हइ. ");
INSERT INTO goj_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","येका लिए अगर बाप बेटा खे स्वतत्रता कर्हे ते सच्ची मे तुम स्वतत्रता हुइ जाये. ");
INSERT INTO goj_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","मी जानुस हइ कि तुम अब्राहम का वंश से हइ. तो भी मरो वचन तुमारा मन मे जगा नी पाय, येका लिए तुम मेखे मारी डालनो चाहस हइ. ");
INSERT INTO goj_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","मी उ बोलुस हइ, जो अपना बाप खे ह्या देखस हइ. अरु तुम उ करता र्‍हेस हइ जो तुम ने अपना बाप से सुन्यो हइ.” ");
INSERT INTO goj_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","उनने ओखे जवाब दियो, “हमारो बाप तो अब्राहम हइ.” यीशु ने उनसे बोल्यो, “अगर तुम अब्राहम का सन्तान होस, ते अब्राहम का जसो काम करता. ");
INSERT INTO goj_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","पर अब तुम मेखे जसो इन्सान खे मारी डालनो चाहस हइ, जो ने तुमखे उ सच्ची वचन बतायो जो परमेश्वर से सुन्यो, यो ते अब्राहम ने नी कर्यो थो. ");
INSERT INTO goj_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","तुम अपना बाप का जसा काम करस हइ” उनने ओकासे बोल्यो, “हम व्यभिचार से नी जन्मो, हमारो एक बाप हइ यानेकी परमेश्वर.” ");
INSERT INTO goj_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","यीशु ने उनसे बोल्यो, “अगर परमेश्वर तुमारो बाप होतो, ते तुम मरासे प्रेम रखता. क्युकी मी परमेश्वर मे से नीकलीखे आयो हइ. मी खुद से नी आयो, पर ओ ने मेखे भेज्यो. ");
INSERT INTO goj_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","तुम मरी बात क्यु नी समझे? येका लिए कि मरो वचन सुनी नी सक्ये. ");
INSERT INTO goj_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","तुम अपना बाप सैतान से हइ, अरु अपना बाप की लालसाहोन खे पूरो करणो चाहस हइ उ ते सुरुवात से खुनी हइ, अरु सच्चीचाइ पर स्थिर नी र्हे, क्युकी सच्ची ओमे हइ ही नी. जब उ झूठ बोलस, ते अपना स्वभाव मे से बोलस हइ. क्युकी उ झूठो हइ, क्युकी झूठ को बाप हइ. ");
INSERT INTO goj_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","पर मी जो सच्ची बोलस हइ, येका लिए तुम मरो विश्वास नी कर्ये. ");
INSERT INTO goj_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","तुम मे से कोन मेखे पापी ठैइरास हइ? अरु अगर मी सच्ची बोलुस हइ, ते तुम मरो विश्वास क्यु नी कर्ये? ");
INSERT INTO goj_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","जो परमेश्वर से होस हइ, उ परमेश्वर की बातहोन सुनस हइ. अरु तुम येका लिए नी सुनस कि परमेश्वर की तरफ से नी हइ.” ");
INSERT INTO goj_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","यो सुन्यो यहूदीयाहोन ने ओकासे बोल्यो “हम ठीक नी बोले, कि तू सामरी हइ, अरु तुम मे बुरीआत्मा हइ?” ");
INSERT INTO goj_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","“यीशु ने जवाब दियो,” मरा मे बुरीआत्मा नी. पर मी अपना बाप को आदर करुस हइ, अरु तुम मरो नीरादर करुस हइ. ");
INSERT INTO goj_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","पर मी अपनी महिमा नी चाहु का हव, एक हइ जो चाहस हइ, अरु न्याय करस हइ. ");
INSERT INTO goj_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","मी तुम से सच्ची-सच्ची बोलुस हइ कि अगर कोय इन्सान मरा वचन पर चले का ते उ पिडमपिडि तक मरना खे नी देख्ये. ");
INSERT INTO goj_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","यहूदीयाहोन ने ओकासे बोल्यो, “अब हमने जानी लियो कि तरा मे बुरीआत्मा हइ अब्राहम मरी गयो, अरु भविष्यव्दक्ता भी मरी गए हइ अरु तू बोलस हइ, ‘अगर कोय मरो वचन पर चल्ये ते उ पिडमपिडि तक मरना को सवाद नी चख्ये.’ ");
INSERT INTO goj_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","हमारो बाप अब्राहम ते मरी गयो, तू ओकासे बडो हइ? अरु भविष्यव्दक्ता भी मरी गया, तू अपना आप खे ठैइरास हइ?” ");
INSERT INTO goj_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","यीशु ने जवाब दियो, “अगर मी खुद अपनी महिमा करु, ते मरी महीमा कुछ नी, पर मरी महिमा करण आलो मरो बाप हइ, जेखे तुम बोलस हइ, कि उ हमारो परमेश्वर हइ. ");
INSERT INTO goj_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","अरु तुम ने तो ओखे नी जान्यो पर मी ओखे जानुस हइ. अरु अगर बोलु कि मी ओखे नी जानू, ते मी तुमारो जसो झूठा ठैइरायु पर मी जानुस, अरु ओका वचन पर चलुस हइ. ");
INSERT INTO goj_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","तुमारो बाप अब्राहम मरा दिन देखन की आस से भोत मगन थो. अरु ओने देख्यो, अरु खुशी करी.” ");
INSERT INTO goj_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","यहूदीयाहोन ने ओकासे बोल्यो, “अब तक तू पचास साल को नी, फिर भी तोने अब्राहम खे देख्यो हइ?” ");
INSERT INTO goj_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","यीशु ने उनसे बोल्यो, “ मी तुम से सच्ची-सच्ची बोलुस हइ, कि पैयले येका कि अब्राहम पइदा हुयो मी हइ.” ");
INSERT INTO goj_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","तब उनने ओखे मारन का लिये पत्थर उठायो, पर यीशु लुकीखे मन्‍दिर से नीकली गयो. ");
INSERT INTO goj_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","फिर जाता हुया ओने एक इन्सान खे देख्यो, जो जन्म से अंधो थो. ");
INSERT INTO goj_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","अरु ओका सेवक होन ने ओकासे पूछ्यो, “हे गुरु, कोय ने पाप कर्यो थो कि यो अंधो जन्म्यो यो इन्सान ने या ओकी माय बाप ने?” ");
INSERT INTO goj_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","यीशु ने जवाब दियो, “नी ते येने पाप कर्यो थो, नी येका माय बाप ने पर यो येका लिए हुयो, कि परमेश्वर का काम ओमे प्रगट हुये. ");
INSERT INTO goj_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","जो ने मेखे भेज्यो हइ. हमखे ओका मे दिन हीस दिन मे करणो जरुरती हइ वा रात आनआली हइ जोमे कोय काम नी करी सकतो. ");
INSERT INTO goj_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","जब तक मी जगत मे हइ, तब तक जगत को उजालो हइ.” ");
INSERT INTO goj_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","यो बोलीखे ओने जमीन पर थूक्यो अरु उ थूक से मट्टी छासनी, अरु वा मट्टी उ अंधा का आखहोन पर लगैइखे. ");
INSERT INTO goj_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ओकासे बोल्यो, “जा, शीलोह का कुण्ड मे धोइ ले” शीलोह को अर्थ भेज्यो हुयो हइ अन्नत ओने जैइखे ले, अरु देखता हुया लौटी आयो. ");
INSERT INTO goj_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","तब पडोसी अरु जिन्हे पैयले ओखे भीख मागते देख्यो थो, बोलन लग्या “यो उ नी जो बठ्यो भीख माग्या करतो थो?” ");
INSERT INTO goj_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","कुछ दुन्या ने बोल्यो, “यो उ हइ,” दुसरा जन ने बोल्यो नी, पर ओका जसो हइ ओने बोल्यो, “मी उ हइ.” ");
INSERT INTO goj_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","“तब वे ओकासे पूछन लग्या?” तरी आखहोन कसी खुली गइ. ");
INSERT INTO goj_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","ओने जवाब दियो, “यीशु नामको एक इन्सान ने मट्टी छानी, अरु मरा आखहोन पर लगैइखे मरासे बोल्यो, शीलोह मे जैइखे धोइ ले, ते मी गयो, अरु धोइ खे देखन लग्यो.” ");
INSERT INTO goj_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","उनने ओकासे पूछ्यो, “उ खा हइ?” ओने बोल्यो, “मी नी जानु.” ");
INSERT INTO goj_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","इन्सान जो पैयले अंधो थो फरीसीहोन का पास ली गयो. ");
INSERT INTO goj_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","जो दिन यीशु ने मट्टी छानी खे ओकी आखहोन खोली थी उ अराम को दिन थो. ");
INSERT INTO goj_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","फिर फरीसीहोन ने भी ओकासे पूछ्यो. तरी आखहोन कोनता रीति से खुली गइ? ओने उनसे बोल्यो, “ओने मरी आखहोन पर मट्टी लगइ, फिर मेने धोइ लियो, अरु अब देखुस हइ.” ");
INSERT INTO goj_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","येका पर कइ फरीसी बोलन लग्या, “यो इन्सान परमेश्वर का तरफ से नी, क्युकी उ अराम का दिन नी मानतो” दुसरा झन ने बोल्यो, “पापी इन्सान कसो असो चिन्ह दिखैइ सकस हइ?” अन्नत उनमे फूट पिडी. ");
INSERT INTO goj_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","उनने उ अंधा से फिर बोल्यो, “ओने जो तरी आखहोन खोली, तू ओका बारे मे का बोलस हइ?” ओने बोल्यो, “यो भविष्यव्दक्ता हइ.” ");
INSERT INTO goj_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","पर यहूदीयाहोन खे विश्वास नी हुयो कि यो अंधो थो अरु अब देखस हइ जब तक उनने ओका माय बाप खे जोकी आखहोन खुली गइ थी, बुलैइ खे. ");
INSERT INTO goj_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","उनसे पूछ्यो “का यो तुमारो बेटो हइ, जेखे तुम बोलस हइ कि अंधो जन्म्यो थो? फिर अब कसो देखस हइ?” ");
INSERT INTO goj_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","ओका माय-बाप ने जवाब दियो, “हम तो जानस हइ कि यो हमारो बेटो हइ, अरु अंधो जन्म्यो थो. ");
INSERT INTO goj_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","पर हम यो नी जानस हइ कि अब कसो देखस हइ. अरु नी यो जानस हइ, कि कोय ने ओका आखहोन खोली. उ सयानो हइ. ओका से पुछी ले. उ अपना बारे मे बोली दिये.” ");
INSERT INTO goj_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","या बातहोन ओका माय-बाप ने येका लिए बोली क्युकी वे यहूदीयाहोन से डरता था. क्युकी यहूदीया एकमत हुइ चुक्या था, कि अगर कोय बोल्ये कि उ मसीह हइ, ते आराधनालय से नीकाली जाये. ");
INSERT INTO goj_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","यो कारण ओका माय बाप ने बोल्यो, “उ सयानो हइ. ओका से पूछी ले.” ");
INSERT INTO goj_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","तब उनने उ इन्सान खे जो अंधो थो दूसरी बार बुलैइ खे ओकासे बोल्यो, “परमेश्वर की महिमा कर. हम तो जानस हइ कि उ इन्सान पापी हइ.” ");
INSERT INTO goj_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","ओने जवाब दियो, “मी नी जानु कि उ पापी हइ या नी मी एक बात जानूस हइ कि मी अंधो थो अरु अब देखुस हइ.” ");
INSERT INTO goj_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","उनने ओकासे फिर बोल्यो, “ओने तरा साथ का कर्यो? अरु कोनता तरीका से तरी आखहोन खोली?” ");
INSERT INTO goj_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","ओने उनसे बोल्यो, “मी तो तुम से बोली चुक्यो, अरु तुम ने नी सुन्यो. अब दूसरी बार क्यु सुननो चाहस हइ? का तुम भी ओका सेवक होनु चाहस हइ?” ");
INSERT INTO goj_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","तब वे ओखे बुरो-भलो बोलीखे बोल्या, “तू ही ओको चेलो हइ. हम तो मूसा का सेवक हइ. ");
INSERT INTO goj_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","हम जानस हइ कि परमेश्वर ने मूसा से बातहोन बोली. पर यो इन्सान खे नी जाने की खा को हइ.” ");
INSERT INTO goj_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","ओने उन खे जवाब दियो, “यो तो अचम की बात हइ कि तुम नी जाने की खा को हइ तेभी ओने मरी आखहोन खोली दी. ");
INSERT INTO goj_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","हम जानस हइ कि परमेश्वर पापीहोन की नी सुने पर अगर कोय परमेश्वर को भक्त हइ, अरु ओकी इच्छा पर चलस हइ, ते उ ओकी सुनस हइ. ");
INSERT INTO goj_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","जगत कि सुरुवात से यो कभी सुनना मे नी आयो, कि कोय ने भी जन्म का अंधा की आखहोन खोली हो. ");
INSERT INTO goj_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","अगर यो इन्सान परमेश्वर का तरफ से नी होतो, ते कुछ भी नी करी सकतो.” ");
INSERT INTO goj_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","उनने ओखे जवाब दियो, “तू तो बिलकुल पापहोन मे जन्म्यो हइ, तू हम खे का सिखास हइ?” अरु उनने ओखे भइर नीकाली दियो. ");
INSERT INTO goj_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","यीशु ने सुन्यो, कि उनने ओखे बाहेर नीकाली दियो हइ. अरु जब ओकासे मील्यो हुइ ते बोल्यो “तू परमेश्वर का बेटा पर विश्वास करस हइ?” ");
INSERT INTO goj_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","ओने जवाब दियो, “हे प्रभु, उ कोन हइ कि मी ओका पर विश्वास करु?” ");
INSERT INTO goj_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","यीशु ने ओकासे बोल्यो, “तोने ओखे देख्यो भी हइ. अरु जो तरा साथ बातहोन करी र्‍हो हइ उ हइ.” ");
INSERT INTO goj_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","ओने बोल्यो, “हे प्रभु, मी विश्वास करुस हइ” अरु ओखे प्रणाम कर्यो. ");
INSERT INTO goj_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","तब यीशु ने बोल्यो, “मी यो जगत मे न्याय का लिये आयो हइ, ताकि जो नी देखे वे देख्ये का अरु जो देखस हइ वे अंधा हुइ जाये.” ");
INSERT INTO goj_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","जो फरीसी ओका साथ था, उनने या बातहोन सुनी खे ओकासे बोल्यो, “हम भी अंधा हइ?” ");
INSERT INTO goj_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","यीशु ने उनसे बोल्यो, “अगर तुम अंधा होस ते पापी नी ठैरता पर अब बोलुस हइ, कि हम देखस हइ, येका लिए तुमारा पाप बन्यो र्‍हेस हइ. ");
INSERT INTO goj_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“मी तुम से सच्ची सच्ची बोलुस हइ, कि जो कोइ दरवाजा से मेडा कि खोली मे अंदर नी कर्ये का पर अरु कोय दुसरा से चडी जास हइ का उ चोर अरु डाकू हइ. ");
INSERT INTO goj_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","पर जो दरवाजा से अंदर प्रवेश करस हइ उ व्हा मेढाहोन को चरवाहा हइ. ");
INSERT INTO goj_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","येका लिये द्वारपाल दरवाजो खोली देस हइ, अरु मेढाहोन ओकी आवाज शब्द सुनस हइ, अरु उ अपना मेढाहोन का नाम ली लीखे बुलास हइ बाहेर ली जास हइ. ");
INSERT INTO goj_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","अरु जब उ अपनी सब मेढाहोन खे बाहेर नीकाली चुक्यो हइ, ते उनका आगे आगे चलस हइ, अरु मेढाहोन ओका पीछे-पीछे चली जास हइ. क्युकी वे ओकी आवाज पहचानस हइ. ");
INSERT INTO goj_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","पर वे दुसरा का पीछे नी जायेका पर ओकासे भाग्येका क्युकी वे दुसरा को आवाज नी पहचाने.” ");
INSERT INTO goj_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","यीशु ने उनसे यो दृष्टान्त बोल्यो, पर वे नी समझे कि या बातहोन हइ जो वह हम से बोलस हइ. ");
INSERT INTO goj_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","तब यीशु ने उनसे फिर बोल्यो, “मी तुम से सच्ची-सच्ची बोलुस हइ, कि मेढाहोन को दरवाजा मी हइ. ");
INSERT INTO goj_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","जोत्ता मरासे पैयले आया. वे सब चोर अरु डाकू हइ, पर मेढाहोन ने उनकी नी सुनी. ");
INSERT INTO goj_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","दरवाजो मी हइ. अगर कोय मरा वजेसे अंदर प्रवेश कर्ये ते उध्दारपाये अरु अंदर बाहर आह्ये-जाये कर्ये अरु चारो पाये. ");
INSERT INTO goj_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","चोर कोइ अरु काम का लिये नी पर फक्त चोरी करण अरु मारन खे अरु खेत्म खे आस हइ, मी येका लिए आयो कि वे जिवन पायेका अरु भोतायत से पाये. ");
INSERT INTO goj_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“अच्छो चरानआलो मी आय. अच्छो चरानआलो मेडा का लिये अपनो जान देस हइ. ");
INSERT INTO goj_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","मजूर जो नी चरानआलो हइ, अरु नी मेढाहोन को मालिक हइ, लाडगाहोन खे आते हुया देख्यो, मेढाहोन खे छोडी खे भागी जास हइ, अरु लाडगाहोन उनखे पकडस अरु इधर-उधर करी देस हइ. ");
INSERT INTO goj_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","उ येका लिए भागी जास हइ कि उ मजूर हइ, अरु ओखे मेडाहोन की चिन्ता नी ");
INSERT INTO goj_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","अच्छो चरानआलो मी आय. मी अपनी मेडाहोन खे जानुस हइ, अरु मरा मेडाहोन मेखे जानस हइ. ");
INSERT INTO goj_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","जसो बाप मेखे जानस हइ, अरु मी बाप खे जानुस हइ, अरु मी मेडाहोन, लिये अपनो जान देउस हइ. ");
INSERT INTO goj_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","मरा अरु भी मेडा हइ, जो यो मेडा खोली की नी. मेखे उन खे भी लानो जरुरती हइ, वे मरो आवाज सुन्ये. तब एक मे झुण्ड अरु एक मे चरानआलो हुये. ");
INSERT INTO goj_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“बाप येका लिए मरासे प्रेम रखस हइ, कि मी अपनो जान देउस हइ, कि ओखे फिर ली लियु. ");
INSERT INTO goj_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","कोय ओखे मरासे छीने नी, क्युकी मी ओखे खुद मे देउस हइ, मेखे ओखे देन को अधिकार हइ, अरु ओखे फिर लेन को भी अधिकार हइ, या आज्ञा मरो बाप से मेखे मीली हइ.” ");
INSERT INTO goj_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","या बातहोन का कारण यहूदीयाहोन मे फिर फूट पडी. ");
INSERT INTO goj_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","उनमे से भोत जन बोलन लग्या, “ओमे बुरीआत्मा हइ, अरु उ पागल हइ. ओकी क्यु सुनस हइ?” ");
INSERT INTO goj_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","दुसरा ने बोल्यो, “या बातहोन असो इन्सान की नी जोमे बुरीआत्मा हइ, बुरीआत्मा अंधा की आख खोली सकस हइ?” ");
INSERT INTO goj_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","यरुशलेम मे समर्पन त्योहार हुयो, अरु ठड को दिन थो. ");
INSERT INTO goj_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","अरु यीशु मन्‍दिर मे सुलेसमान कि ओसरी मे घुमीरो थो. ");
INSERT INTO goj_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","तब यहूदीयाहोन ने ओखे अय घेर्यो अरु पूछ्यो, “तू हमारा मन खे कब तक तखलीप मे रख्ये? अगर तू मसीह हइ, ते हम से सपा बोली दे.” ");
INSERT INTO goj_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","यीशु ने उनखे जवाब दियो, “मेने तुम से बोली दियो, अरु तुम विश्वास कर्‍हे ही नी, जो काम मी अपना बाप का नाम से करुस हइ वे य मरा गवा हइ. ");
INSERT INTO goj_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","पर तुम येका लिए विश्वास नी कर्‍हे, कि मरा मेडाहोन मे से नी हइ. ");
INSERT INTO goj_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","मरा मेडाहोन मरो आवाज सुनस हइ, अरु मी उनखे जानुस हइ, अरु वे मरा पीछे पीछे चलस हइ. ");
INSERT INTO goj_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","अरु मी उनखे अनन्त जिवन देउस हइ, अरु वे कभी नाश नी हुये कि अरु कोय उनखे मरा हात से छीनी नी लिये. ");
INSERT INTO goj_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","मरो बाप, जो ने उनखे मेखे दियो हइ, सबसे बडो हइ, अरु कोय उनखे बाप का हात से छीनी नी सक्ये. ");
INSERT INTO goj_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","मी अरु बाप एक हइ.” ");
INSERT INTO goj_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","यहूदीयाहोन ने ओखे पत्थराव करण खे फिर पत्थर उठाया. ");
INSERT INTO goj_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","येका पर यीशु ने उनसे बोल्यो, “मेने तुमखे अपना बाप का तरफ से भोत सा भला काम दिखाया हइ, उनमे से कोनता काम का लिये तुम मेखे पत्थराव करस हइ?” ");
INSERT INTO goj_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","यहूदीयाहोन ने ओखे उत्तर दियो, “अच्छो काम का लिये हम तोखे पथर नी मारा, पन परमेश्वर की नीन्दा का कारण अरु येका लिये कि तू इन्सान हुयखे अपना आप खे परमेश्वर बनास हइ.” ");
INSERT INTO goj_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","यीशु ने उनखे जवाब दियो “तुम्हारी व्यवस्था मे नी लिख्यो हइ कि ‘मेने बोल्यो, तु प्रभु हइ?’ ");
INSERT INTO goj_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","अगर ओने उनखे प्रभु बोल्यो जिन का पास परमेश्वर को वचन पहुच्यो अरु पवित्रशास्त्र की बात लुकी नी हुइ सक्ये. ");
INSERT INTO goj_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","ते जेखे बाप ने पवित्र ठैइरी खे जगत मे भेज्यो हइ, तुम ओकासे बोलस हइ, तू नीन्दा करस हइ येका लिए कि मेने बोल्यो, मी परमेश्वर को बेटो हइ? ");
INSERT INTO goj_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","अगर मी अपना बाप को काम नी करु, ते मरो विश्वास नी करणु. ");
INSERT INTO goj_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","पर अगर मी करुस हइ, ते चाह्ये मरो विश्वास नी भी करणु, पर वे काम होन पर विश्वास करणु, ताकि तुम जान्येका अरु समझे, कि बाप मरा मे हइ, अरु मी बाप मे हइ.” ");
INSERT INTO goj_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","तब उनने फिर ओखे पकडन कि कोशीस कर्यो पर उ उनका हात से नीकली गयो ");
INSERT INTO goj_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","फिर उ यरदन नद्दी का पार वा जगा पर चली गयो, झा यहून्ना पैयले बपतिस्मा दिया करतो थो, अरु वही र्‍हियो. ");
INSERT INTO goj_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","अरु भोत सारा ओका पास अयखे बोलता था, “यहून्ना ने ते कोय चिन्ह नी दिखायो, पर जो कुछ यहून्ना ने येका बारे मे बोल्यो थो उ सब सच्ची थो.” ");
INSERT INTO goj_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","अरु उ भोतजन ने ओका पर विश्वास कर्यो. ");
INSERT INTO goj_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","मरियम अरु उसकी भैइन मार्था को गाव बैतनीय्याह को लाजर नाम एक इन्सान बीमार थो. ");
INSERT INTO goj_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","या उ मरियम थी जेने प्रभु पर अत्रर डालीखे ओका पायहोन खे अपना बालहोन से पोछ्यो थो, ओ को भैइ लाजर बीमार थो. ");
INSERT INTO goj_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","तब ओकी भैइनहोन ने ओखे बुलाओ भेज्यो, “हे प्रभु, देख, जोका से तू प्रेम करस हइ, उ बीमार हइ.” ");
INSERT INTO goj_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","यो सुनीखे यीशु ने बोल्यो, “या बीमारी मरन की नी, पर परमेश्वर की महिमा का लिये हइ, कि ओका वजेसे परमेश्वर का बेटा की महिमा हुये.” ");
INSERT INTO goj_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","अरु यीशु, मार्था अरु ओकी भैइन अरु लाजर से प्रेम रखतो थो. ");
INSERT INTO goj_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","जब ओने सुन्यो, कि उ बीमार हइ, ते जो जगा पर उ थो, व्हा दो दिन अरु ठैरी गयो. ");
INSERT INTO goj_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","फिर ओका बाद ओने सेवक होन से बोल्यो, “ओका हम फिर यहूदीया खे चल्हे.” ");
INSERT INTO goj_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","सेवक होन ने ओकासे बोल्यो, “हे गुरु, अभी तो यहूदीया तोखे पत्थराव करणो चाहतो थो, अरु तू फिर भी वही जास हइ?” ");
INSERT INTO goj_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","यीशु ने जवाब दियो “ का दिन बारा घंटा नी होय? अगर कोय दिन मे चल्यो, ते ठोकर नी खाता, क्युकी यो जगत को उजालो देखस हइ. ");
INSERT INTO goj_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","पर अगर कोय रात खे चल्ये का ते ठोकर खास हइ, क्युकी ओमे उजालो नी.” ");
INSERT INTO goj_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","ओने या बातहोन बोली, अरु येका बाद उनसे बोलन लग्यो, “हमारो दोस्त लाजर सोइ गयो हइ, पर मी ओखे जगान जउस हइ.” ");
INSERT INTO goj_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","तब सेवक होन ने ओकासे बोल्यो, “हे प्रभु, अगर उ सोइ गयो हइ, ते बची जाये.” ");
INSERT INTO goj_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","यीशु ने तो ओका मरना का बारे मे बोल्यो थो पर वे समझ्या कि ओने नीद से सोइ जाना का बारे मे बोल्यो. ");
INSERT INTO goj_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","तब यीशु ने उनसे साफ बोली दियो, “लाजर मरी गयो हइ. ");
INSERT INTO goj_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","अरु मी तुमारा कारण खुश हइ कि मी व्हा नी थो जोका से तुम विश्वास करणु. पन अब आ हम ओका पास चले.” ");
INSERT INTO goj_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","तब थोमा ने जो दिदिमुस बोलस हइ, अपना साथ का सेवक होन से बोल्यो, “ओका हम भी ओका साथ मरन खे चल्यो.” ");
INSERT INTO goj_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","फिर यीशु खे अयखे यो मालूम हुयो कि ओखे कब्र मे रख्या चार दिन हुइ चुक्या हइ. ");
INSERT INTO goj_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","बैतनीय्याह यरुशलेम का सामने कोय दो मील की दूरी पर थो. ");
INSERT INTO goj_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","अरु भोत सा यहूदीया मार्था अरु मरियम का पास उनका भैइ का बारे मे शांती देन का लिये आया था. ");
INSERT INTO goj_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","जब मार्था यीशु को आन को समाचार सुनैखे ओकासे मीलन खे गइ, पर मरियम घर मे बठी र्‍हि. ");
INSERT INTO goj_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","मार्था ने यीशु से बोल्यो, “हे प्रभु, अगर तू ह्या होतो, ते मरो भैइ कभी नी मरतो. ");
INSERT INTO goj_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","अरु अब भी मी जानुस हइ, कि जो कुछ तू परमेश्वर से माग्ये परमेश्वर तोखे दिये.” ");
INSERT INTO goj_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","यीशु ने ओकासे बोल्यो, “तरो भैइ जी उठ्यो.” ");
INSERT INTO goj_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","मार्था ने ओकासे बोल्यो, “मी जानूस हइ, अन्नत दिन मे पुनरुत्थान का टेम उ जी उठ्ये.” ");
INSERT INTO goj_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","यीशु ने ओकासे बोल्यो, “पुनरुत्थान अरु जिवन मी आय, जो कोय मरा पर विश्वास करस हइ उ अगर मरी भी जाये ते भी जीये. ");
INSERT INTO goj_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","अरु जो कोइ जिन्दो हइ, अरु मरा पर विश्वास करस हइ, उ पिडमपिडि तक नी मर्येका तू या बात पर विश्वास करस हइ?” ");
INSERT INTO goj_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","ओने ओकासे बोल्यो, “हव, हे प्रभु, मी विश्वास करी चुकी हइ, कि परमेश्वर को बेटो मसीह जो जगत मे आनआलो थो, उ तू हीस हइ.” ");
INSERT INTO goj_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","यो बोलीखे वा चली गइ, अरु अपनी भैइन मरियम खे चुपचाप से बुलैखे बोल्यो, “गुरु ह्यही हइ, अरु तोखे बुलास हइ.” ");
INSERT INTO goj_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","यो सुनते ही जल्दी उठीखे ओका पास अय. ");
INSERT INTO goj_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","यीशु अभी गाव मे नी पहुच्यो थो, पर उ जगा मे थो झा मार्था ने ओकासे दान करी थी. ");
INSERT INTO goj_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","तब जो यहूदीया ओका साथ घर मे था, अरु ओखे शांती दि र्‍हा था, यो देखीखे कि मरियम जल्दी उठीखे बाहेर गइ हइ अरु यो समझी खे कि उ कब्र पर रोन खे जास हइ, ओका पीछे गइ. ");
INSERT INTO goj_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","जब मरियम व्हा पहुची झा यीशु थो, ते ओखे देखता ही ओका पायहोन पर गिरीखे बोल्यो, “हे प्रभु, अगर तू ह्या होतो ते मरो भैइ नी मरतो.” ");
INSERT INTO goj_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","जब यीशु ने ओखे अरु वे यहूदीयाहोन खे जो ओका साथ आया था रोते हुया देख्यो, ते आत्मा मे भोत मे उदास अरु व्याकुल हुयो, ");
INSERT INTO goj_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","अरु बोल्यो, “तुम ने ओखे खाहा रख्यो हइ?” उनने ओकासे बोल्यो, “हे प्रभु, चलीखे देखी ले.” ");
INSERT INTO goj_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","यीशु रोयो ");
INSERT INTO goj_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","तब यहूदीया बोलन लग्या, “देखनु, उ ओकासे कसो प्रेम करतो थो.” ");
INSERT INTO goj_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","पर उनमे से केत्ता ने बोल्यो “का यो जेने अंधा की आखहोन खोली, यो भी नी करी सक्यो कि यो इन्सान नी मरतो?” ");
INSERT INTO goj_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","यीशु मन मे फिर भोत मे उदास हुइखे कब्र पर आयो, वा एक गुफा थी, अरु एक पत्थर ओका पर रख्यो थो. ");
INSERT INTO goj_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","यीशु ने बोल्यो, “पत्थर खे उठाव” उ मर्यो हुया की भैइन मार्था ओकासे बोलन लगी, “हे प्रभु, अब तो ओमे से बास आस हइ, क्युकी ओखे मर्या चार दिन हुइ गया.” ");
INSERT INTO goj_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","यीशु ने ओकासे बोल्यो “का मेने तरा से नी बोल्यो थो कि अगर तू विश्वास कर्येका ते परमेश्वर की महिमा खे देख्ये.” ");
INSERT INTO goj_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","तब उनने उ पत्थर खे हटायो, फिर यीशु ने आखहोन उठैइखे बोल्यो, “हे बाप, मी तरो धन्यवाद करुस हइ कि तोने मरी सुनी ली हइ. ");
INSERT INTO goj_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","अरु मी जानतो थो, कि तू हमेशा मेरी सुनस हइ, पर जो गर्दी आस-पास खड़ी हइ, उनका कारण मेने यो बोल्यो, जोका से कि वे विश्वास कर्येका कि तोने मेखे भेज्यो हइ.” ");
INSERT INTO goj_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","यो बोलीखे ओने बडा आवाज से पु,कार्यो, “हे लाजर, नीकलीखे आ!” ");
INSERT INTO goj_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","जो मरी गयो थो, उ कफन से हात पाय बध्या हुयो नीकलीखे आयो अरु ओको मेडो कपडो से लिपट्यो हुयो थो यीशु ने उनसे बोल्यो, “ओखे खोलीखे अरु जान दे” ");
INSERT INTO goj_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","तब जो यहूदीया मरियम का पास आया था अरु ओको यो काम देख्यो थो, उनमे से भोत जन ने ओका पर विश्वास कर्यो. ");
INSERT INTO goj_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","पर उनमे से खे त्ता ने फरीसीहोन का पास जैइखे यीशु का काम होन को समाचार दियो. ");
INSERT INTO goj_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","येका पर प्रधान याजकहोन अरु फरीसीहोन ने मुख्य सभा का दुन्याहोन खे जमा करीखे बोल्यो, “हम कारस का हइ? यो इन्सान तो भोत चिन्ह बतास हइ. ");
INSERT INTO goj_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","अगर हम ओखे असो मे छोडी दिये, ते सब ओका पर विश्वास ली आह्ये अरु रोमी अयखे हमारी जगा अरु राष्ट्रहोन दोइ पर अधिकार करी लिये.” ");
INSERT INTO goj_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","तब उनमे से कैफा नाम एक इन्सान ने जो उ साल को महायाजक थो, उनसे बोल्यो, “तुम कुछ नी जाने. ");
INSERT INTO goj_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","अरु नी यो सोचस हइ, कि तुमारा लिये यो अच्छो हइ, कि दुन्या का लिये एक इन्सान मर्ये, अरु नी यो कि पुरो जातहोन नाश हुये.” ");
INSERT INTO goj_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","या बात ओने अपना तरफ से नी बोली, पर उ साल को महायाजक हुइखे भविष्यवाणी करीखे कि यीशु वे राष्ट्रहोन का लिये मर्ये. ");
INSERT INTO goj_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","अरु नी फक्त वे राष्ट्रहोन का लिये क्युकी येका लिए भी, कि परमेश्वर की तितर-बितर सन्तानहोन खे एक करी दिये. ");
INSERT INTO goj_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","अन्नत उ दिन से वे ओखे मारी डालन की सम्मति करण लग्या. ");
INSERT INTO goj_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","येका लिए यीशु वा टेम से यहूदीयाहोन मे प्रगट हुइखे नी फिर्यो. पर व्हा से जंगल का नजीक पास परदेस को एप्रैम नाम का एक नगर खे चली गयो. अरु अपना सेवक होन का साथ वही र्‍हेन लग्यो. ");
INSERT INTO goj_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","अरु यहूदीयाहोन को फसह को तीवार पास थो, अरु भोत सारा इन्सान फसह से पैयले दिहात से यरुशलेम खे गया कि अपना आप खे अच्छो करणु. ");
INSERT INTO goj_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","वे यीशु खे ढूढन अरु मन्‍दिर मे खडो हुइखे आपस मे बोलन लग्यो, “तुम का समझस हइ? का उ त्योहार मे नी आह्ये?” ");
INSERT INTO goj_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","अरु प्रधान याजकहोन अरु फरीसीहोन ने भी आज्ञा दि रखी थी, कि अगर कोय यो जाने कि यीशु खा हइ ते बतानु, कि ओखे पकडी ले. ");
INSERT INTO goj_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","फिर यीशु फसह तिवार से छे दिन पैयले बैतनीय्याह मे आयो, झा लाजर थो. जेखे यीशु ने मर्या हुया मे से जिन्दो लायो थो. ");
INSERT INTO goj_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","व्हा उनने ओका लिये खानो तैयार कर्यो, अरु मार्था सेवा करी र्‍हि थी, अरु लाजर उनमे से एक थो, जो ओका साथ खानो खान का लिये बठ्या था. ");
INSERT INTO goj_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","तब मरियम ने जटामासी को आधो सेर बहुमूल्य अत्रर लीखे यीशु का पाय पर डाल्यो, अरु अपना बालहोन से ओका पाय पोछ्या, अरु अत्रर की सुगध से घर सुगन्धित हूइ गयो. ");
INSERT INTO goj_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","पर ओका सेवक होन मे से यहूदा इस्करियोती नाम एक चेलो जो ओखे पकडान पर थो, बोलन लग्यो, ");
INSERT INTO goj_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“यो अत्रर तीन सौ सिक्का, मे बेचीखे गरीबहोन खे क्यु नी दिया गयो?” ");
INSERT INTO goj_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","ओने या बात येका लिए नी बोली, कि ओखे गरीबहोन की चिन्ता थी का पर येका लिए कि उ चोर थो अरु ओका पास उनकी थैली र्‍हेती थी, अरु ओमे जो कुछ डाल्या जातो थो काउ नीकाली लेतो थो. ");
INSERT INTO goj_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","यीशु ने बोल्यो, “ओखे मरा गाड्या जान का दिन का लिये र्‍हेन दे. ");
INSERT INTO goj_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","क्युकी गरीब तो तुमारा साथ हमेशा र्‍हेस हइ, पर मी तुमारा साथ हमेशा नी र्‍हियु.” ");
INSERT INTO goj_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","यहूदीयाहोन मे से साधारण दुन्या जानी गया, कि उ व्हा हइ, अरु वे नी फक्त यीशु का कारण आया पर येका लिए भी कि लाजर खे देख्ये का जेखे ओने मऱ्या हुया मे से जिन्दो थो. ");
INSERT INTO goj_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","तब मुखियो याजकहोन ने लाजर खे भी मारी डालन की सम्मति करी. ");
INSERT INTO goj_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","क्युकी ओका कारण भोत सा यहूदीया चली गया, अरु यीशु पर विश्वास कर्यो. ");
INSERT INTO goj_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","दूसरा दिन भोत सा दुन्याहोन ने जो त्योहार मे आया था, यो सुनीखे, कि यीशु यरुशलेम मे अय र्हो हइ. ");
INSERT INTO goj_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","उनने खारीक की डालिहोन ली, अरु ओकासे मीलन खे नीकल्या, अरु फुकारन लग्या, “होशन्ना! धन्य इस्राएल को राजो, जो प्रभु, नाम से आस हइ.” ");
INSERT INTO goj_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","जब यीशु खे एक गधी को बच्चो मील्यो, ते उ ओका पर बठ्यो, जसो लिख्यो हइ, ");
INSERT INTO goj_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“हे सिय्योन की बेटी, मत डर. देख, तरो राजो गधी का बच्चा पर चड्यो हुयो चल्यो आस हइ.” ");
INSERT INTO goj_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","ओका सेवक या बातहोन पैयले नी समझ्या था. पर जब यीशु की महिमा प्रगट हुइ, ते उनखे याद आयो, कि या बातहोन ओका बारे मे लिखी हुइ थी. अरु दुन्याहोन ने ओकासे यो प्रकार को व्यव्हार कर्यो थो. ");
INSERT INTO goj_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","तब गर्दी का दुन्याहोन ने जो उ टेम ओका साथ था या गवइ दी कि ओने लाजर खे कब्र मे से बुलैइ खे, मऱ्या हुया मे से जिन्दो थो. ");
INSERT INTO goj_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","यो कारण इन्सानहोन ओकासे दान करण खे आया था क्युकी उनने सुन्यो थो, कि ओने यो आश्चर्यकर्म दिखायो हइ. ");
INSERT INTO goj_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","तब फरीसीहोन ने आपस मे बोल्यो, “सोचनु की तुम इन्सान कुछ नी करी र्‍हा हइ. देखनु, जगत ओका पीछे हुइ चल्यो हइ.” ");
INSERT INTO goj_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","जो इन्सान उ त्योहार मे आराधना करण आया था उनमे से कइ यूनानी था. ");
INSERT INTO goj_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","उनने गलील का बैतसैदा का र्‍हेनआला फिलिप्पुस का पास अयखे स्वामी से प्रार्थना करी, “श्रीमान हम यीशु से दान करणो चाहस हइ.” ");
INSERT INTO goj_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","फिलिप्पुस ने अयखे अन्द्रियास से बोल्यो. तब अन्द्रियास अरु फिलिप्पुस ने यीशु से बोल्यो. ");
INSERT INTO goj_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","येका पर यीशु ने उनसे बोल्यो, “ वा टेम अय गइ हइ, कि इन्सान का बेटा कि महिमा हुये. ");
INSERT INTO goj_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","मी तुम से सच्ची-सच्ची बोलुस हइ, कि जब तक गहु का दानो जमीन मे गीरी खे मरी नी जाय, उ एकलो र्‍हेस हइ पर जब मरी जास हइ, ते भोत फल लास हइ. ");
INSERT INTO goj_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","जो अपनो जान खे प्रेम जानस हइ, उ ओखे गमइ देस हइ. अरु जो यो जगत मे अपना जान खे अप्रिय जानस हइ. उ अनन्त जिवन का लिये ओकी रक्षा कर्ये. ");
INSERT INTO goj_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","अगर कोय मरी सेवा कर्ये ते मरा पीछे अय जा. अरु झा मी हइ व्हा मरो सेवक भी हुये. अगर कोय मरी सेवा कर्ये ते बाप ओको आदर कर्ये. ");
INSERT INTO goj_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“अब मरी आत्मा अरु मन से व्याकुल हइ, येका लिए अब मी का बोलु ‘हे बाप का मेखे या टेम से बचा?’ पर मी यो करण से तो मी ह्यातक पहुच्योस हइ. ");
INSERT INTO goj_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","हे बाप अपना नाम की महिमा कर,” तब या आकाशवाणी हुइ, “मेने ओकी महीमा करी हइ, अरु फिर भी कर्‍यु.” ");
INSERT INTO goj_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","तब जो इन्सान खडा हुया सुनी र्‍हा था, उनने बोल्यो. कि बद्दल गरज्यो का दुसरा ने बोल्यो, “कोय स्वर्गदूत ओकासे बोल्हे.” ");
INSERT INTO goj_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","येका पर यीशु ने बोल्यो का “यो आवाज मरा लिये नी पर तुमारा लिये आयो हइ. ");
INSERT INTO goj_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","अब यो जगत को न्याय होस हइ, अब यो जगत को मुखियो नीकाली दियो जाये. ");
INSERT INTO goj_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","अरु मी अगर पृथ्वी पर से उचो पर चढायो जाये ते सब खे अपना पास खीच्यु.” ");
INSERT INTO goj_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","असो बोलीखे ओने यो प्रगट करी दियो, कि उ कसी मृत्यु से मर्ये. ");
INSERT INTO goj_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","येका पर दुन्याहोन ने ओकासे बोल्यो, “हमने व्यवस्था की या बात सुनइ हइ, कि मसीह कभी भी र्‍हिये का फिर तू का बोलस हइ, कि इन्सान का बेटा खे उचा पर चडायो जानो जरुरत हइ? यो इन्सान को बेटो कोन हइ?” ");
INSERT INTO goj_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","यीशु ने उनसे बोल्यो, “ज्योति अब थोड़ी देर तक तुमारा बीच मे हइ, जब तक ज्योति तुमारा साथ हइ तब तक चल्यो चलनु. असो नी हो कि अधारो तुमखे अय घेर्‍यो. जो अंधारा मे चलस हइ उ नी जाने कि किधर जास हइ ");
INSERT INTO goj_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","जब तक ज्योति तुमारा साथ हइ, ज्योति पर विश्वास करणु कि तुम ज्योति का सन्तान बननु” या बातहोन बोलीखे यीशु चली गयो अरु उनसे लुक्यो र्‍हियो. ");
INSERT INTO goj_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","अरु ओने उनका सामने इत्ता चिन्ह दिखाया, ते भी उनने ओका पर विश्वास नी कर्यो. ");
INSERT INTO goj_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ताकि यशायाह भविष्यव्दक्ता को वचन पूरो हुये जो ओने बोल्यो: “हे प्रभु, हमारा समाचार पर कोय ने विश्वास कर्यो हइ? अरु प्रभु को बाहुबल को पर प्रकट हुयो?” ");
INSERT INTO goj_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","यो कारण वे विश्वास नी करी सक्या, क्युकी यशायाह ने यो भी बोल्यो हइ ");
INSERT INTO goj_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“ओने उनकी आख अंधी, अरु उनको मन कठोर कर्यो हइ. कही असो नी हो, कि आखहोन से देख्ये का अरु मन से समझ्येका अरु फिर्ये, अरु मी उनखे अच्छो कर्यु.” ");
INSERT INTO goj_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","यशायाह ने या बातहोन येका लिए बोली, कि ओने ओकी महिमा देखी. अरु ओने ओका बारे मे बातहोन करी. ");
INSERT INTO goj_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","ते भी मुखियोहोन मे से भी भोत जन ने ओका पर विश्वास कर्यो, पर फरीसीहोन का कारण प्रगट मे नी मानता था, असो नी हो कि आराधनालय मे से नीकाली जाये ");
INSERT INTO goj_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","क्युकी इन्सानहोन की प्रशसा उनखे परमेश्वर की प्रशसा से जादा प्रिय लगती थी. ");
INSERT INTO goj_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","यीशु ने पुकारी खे बोल्यो, “जो मरा पर विश्वास करस हइ, उ मरा पर नी, क्युकी मरा भेजनआला पर विश्वास करस हइ. ");
INSERT INTO goj_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","अरु जो मेखे देखस हइ, उ मरा भेजनआला खे देखस हइ. ");
INSERT INTO goj_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","मी जगत मे उजालो हुइखे आयो हइ ताकि जो कोय मरा पर विश्वास कर्येका उ अंधारा मे नी र्‍हे. ");
INSERT INTO goj_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","अगर कोय मरी बातहोन सुनीखे नी माने, ते मी ओखे दोषी नी ठैरास, क्युकी मी जगत खे दोषी ठैरान का लिये नी, पर जगत को उध्दार करण का लिये आयो हइ. ");
INSERT INTO goj_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","जो मेखे तुच्छ जानस हइ अरु मरी बातहोन खे अपनाय नी ओखे दोषी ठैरानआला तो एक हइ यानेकी जो वचन मेने बोल्यो हइ, उ अन्नत दिन मे ओखे दोषी ठैइराये. ");
INSERT INTO goj_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","क्युकी मेने अपना तरफ से बातहोन नी करी, पर बाप जेने मेखे भेज्यो हइ ओ ने मेखे आज्ञा दी हइ, कि का का बोलु अरु का का बतवु? ");
INSERT INTO goj_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","अरु मी जानुस हइ, कि ओकी आज्ञा अनन्त जिवन हइ येका लिए मी जो बोलुस हइ, उ जसो बाप ने मरासे बोल्यो हइ ओसो मी बोलस हइ.” ");
INSERT INTO goj_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","फसह को त्योहार से पैयले जब यीशु ने जानी लियो, कि मरी वा टेम अय पहुची हइ कि जगत छोडी खे बाप का पास जायु ते अपना दुन्याहोन से जो जगत मे था, जसो प्रेम उ रखेतो थो, अन्नत तक ओसो मे प्रेम रखेतो र्‍हिये. ");
INSERT INTO goj_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","अरु जब सैतान शमौन को बेटो यहूदा इस्करियोती का मन मे यो डाली चुक्यो थो, कि ओखे पकडनो हइ ते खाना का टेम मे. ");
INSERT INTO goj_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","यीशु ने यो जानीखे कि बाप ने सब कुछ ओका हात मे करी दियो हइ अरु मी परमेश्वर का पास से आयो हइ, अरु परमेश्‍वर का पास जउस हइ. ");
INSERT INTO goj_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","खाना पर से उठीखे अपना कपडा उतारी दिया, अरु डुप्पटा लीखे अपनी कम्मर बाधी. ");
INSERT INTO goj_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","तब बर्तन मे पानी भरीखे सेवक होन का पाय धोनो अरु जो डुप्पटा से ओकी कम्मर बधी थी ओका से पोछन लग्यो. ");
INSERT INTO goj_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","जब उ शमौन पतरस का पास आयो तब ओने ओकासे बोल्यो, “हे प्रभु, का तू मरा पाय धोस हइ?” ");
INSERT INTO goj_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","यीशु ने ओखे जवाब दियो, “जो मी करुस हइ, तू अभी नी जानु, पर येका बाद समझ्ये.” ");
INSERT INTO goj_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","पतरस ने ओकासे बोल्यो, “तू मरा पाय कभी नी धोय पाये!” यो सुनीखे यीशु ने ओकासे बोल्ये “अगर मी तोखे नी धोयु, ते मरा साथ तरा कुछ भी भाग नी” ");
INSERT INTO goj_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","शमौन पतरस ने ओकासे बोल्यो, “हे प्रभु ते मरा पाय ही नी क्युकी हात अरु माथो भी धोइ दे.” ");
INSERT INTO goj_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","यीशु ने ओकासे बोल्यो, “जो नैइ चुक्यो हइ, ओका पाय सिवा अरु कुछ धोना को प्रयोजन नी. पर उ बिलकुल अच्छो हइ अरु तुम अच्छो हुये. पर सब का सब नी.” ");
INSERT INTO goj_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","उ ते अपना पकडनआला खे जानतो थो येका लिए ओने बोल्यो, “तुम सब का सब अच्छो नी.” ");
INSERT INTO goj_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","जब उ उनका पाय धो चुक्यो अरु अपना कपडा पेनीखे फिर बठी गयो ते उनसे बोलन लग्यो “तुम समझ्या कि मेने तुमारा साथ कर्यो? ");
INSERT INTO goj_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","तुम मेखे गुरु अरु प्रभु बोलस हइ, अरु भलो बोलस हइ, क्युकी मी उ आय. ");
INSERT INTO goj_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","अगर मेने प्रभु अरु गुरु हुइखे तुमारा पाय धोया. ते तुमखे भी एक दूसरा का पाय धोनो होनु. ");
INSERT INTO goj_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","क्युकी मेने तुमखे नमूनो दिखैइ दियो हइ, कि जसो मेने तुमारा साथ कर्यो हइ, तुम भी ओसो ही कर्या करणु. ");
INSERT INTO goj_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","मी तुम से सच्ची-सच्ची बोलुस हइ, सेवक अपना स्वामी से बडो नी. अरु नी भेज्या हुया अपना भेजनआला से. ");
INSERT INTO goj_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","तुम तो या बातहोन जानस हइ, अरु अगर उन पर चलनु, ते धन्य हुये. ");
INSERT INTO goj_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“मी तुम सब काबारे मे नी बोलस जिन खे मेने चुनी लियो हइ, उनखे मी जानस हइ. पर यो येका लिए हइ, कि पवित्रशास्त्र को यो वचन पूरा हुये, ‘जो मरी रोटी खास हइ ओने मरा पर लात उठैइ.’ ");
INSERT INTO goj_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","अब मी ओका होना से पैयले तुमखे बतैइ देउस हइ कि जब हुइ जाये ते तुम विश्वास करणु कि मी उ आय. ");
INSERT INTO goj_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","मी तुम से सच्ची-सच्ची बोलस हय, कि जो मेरा भेजो हुया खे ग्रहण करस हइ, उ मेखे ग्रहण करता हइ, अरु जो मेखे ग्रहण करस हइ, वह मेरे भेजनआला खे ग्रहण करस हइ.” ");
INSERT INTO goj_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","या बातहोन बोलीखे यीशु आत्मा मे व्याकुल हुयो अरु या गवइ दी, “मी तुम से सच्ची-सच्ची बोलुस हइ, कि तुम मे से एक मेखे पकडवाये.” ");
INSERT INTO goj_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","सेवक होन यो संदेह करता हुया, कि उ को का बारे मे बोलस हइ, एक दूसरा का तरफ देखन लग्या. ");
INSERT INTO goj_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","ओका सेवक होन मे से एक जोका से यीशु प्रेम रखेतो थो, यीशु कि छाती का तरफ झुक्यो हुयो बठौ थो. ");
INSERT INTO goj_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","तब शमौन पतरस ने ओका तरफ हिसारो करीखे पूछ्यो, “बता तो, उ को का बारे मे बोलस हइ?” ");
INSERT INTO goj_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","तब ओने वा तरह यीशु की छाती का तरफ झुकीखे पूछ्यो, “हे प्रभु, उ कोन हइ?” यीशु ने जवाब दियो, “जेखे मी या रोटी को टुकडो डुबैइ खे दियु, उ हइ.” ");
INSERT INTO goj_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","यीशु ने उत्तर दियो अरु ओने टुकडो डुबैइ खे शमौन को बेटो यहूदा इस्करियोती खे दियो. ");
INSERT INTO goj_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","अरु टुकडो लेते मे सैतान ओमे समैयी गयो तब यीशु ने ओकासे बोल्यो, “जो तू करणआलो हइ, जल्दी कर.” ");
INSERT INTO goj_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","पर बठनआलाहोन मे से कोय ने नी जान्यो कि ओने या बात ओकासे काय का लिये बोली. ");
INSERT INTO goj_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","यहूदा का पास थैली र्‍हेती थी, येका लिए कोइ-कोय ने समझ्यो, कि यीशु ओकासे बोलस हइ, कि जो कुछ हमखे तिवार का लिये होनु उ मोल ले, या यो कि गरीबहोन खे कुछ दे. ");
INSERT INTO goj_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","तब उ टुकडो लीखे जल्दी बाहेर चली गयो, अरु रात को टेम थो. ");
INSERT INTO goj_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","जब उ बाहेर चली गयो ते यीशु ने बोल्यो, “आब इन्सान का बेटा की महिमा हुइ, अरु परमेश्वर की महिमा ओमे हुय. ");
INSERT INTO goj_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","अरु परमेश्वर भी अपना मे ओकी महिमा कर्ये क्युकी झल्दी कर्ये. ");
INSERT INTO goj_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","हे बच्चाहोन, मी अरु थोड़ी देर तुमारा पास हइ फिर तुम मेखे ढूढ्येका अरु जसो मेने यहूदीयाहोन से बोल्यो, ‘झा मी जउस हइ, व्हा तुम नी अय सक्ये ओसो ही मी अब तुम से भी बोलुस हइ.’ ");
INSERT INTO goj_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","मी तुमखे एक नइ आज्ञा देउस हइ, कि एक दूसरा से प्रेम रखनु जसो मेने तुम से प्रेम रख्यो हइ, ओसो मे तुम भी एक दूसरा से प्रेम रखनु. ");
INSERT INTO goj_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","अगर आपस मे प्रेम रख्ये ते येका से सब जान्ये कि तुम मरा सेवक हइ.” ");
INSERT INTO goj_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","शमौन पतरस ने ओकासे बोल्यो, “हे प्रभु, तू खा जास हइ?” यीशु ने जवाब दियो, “झा मी जउस हइ, व्हा तू अब मरा पीछे अय नी सक्ये. पर येका बाद मरा पीछे आह्ये.” ");
INSERT INTO goj_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","पतरस ने ओकासे बोल्यो, “हे प्रभु, अभी मी तरा पीछे क्यु नी अय सक्ये? मी तरा लिये अपनो जान दियु.” ");
INSERT INTO goj_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","यीशु ने जवाब दियो “तू मरा लिये अपनो जान दिये? मी तरा से सच्ची-सच्ची बोलुस हइ कि मुर्गा बांग नी दिये जब तक तू तीन बार मरो इनकार नी करी लिये. ");
INSERT INTO goj_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“तुम्हारो मन व्याकुल न हुये, तुम परमेश्वर पर विश्वास रखस हइ मरा पर भी विश्वास रखनु. ");
INSERT INTO goj_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","मरा बाप का घर मे भोत सी र्‍हेन कि जगा हइ, अगर नी होती ते मी तुम से बोली देतो क्युकी मी तुमारा लिये जगा तैयार करण जउस हइ. ");
INSERT INTO goj_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","अरु अगर मी जैइखे तुमारा लिये जगा तैयार कर्यु, ते फिर अयखे तुमखे अपना ह्या ली जायू, कि झा मी र्‍हियु व्हा तुम भी र्‍हेनु. ");
INSERT INTO goj_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","अरु झा मी जउस हइ तुम व्हा कि रस्ता जानस हइ.” ");
INSERT INTO goj_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","थोमा ने ओकासे बोल्यो, “हे प्रभु, हम नी जाने कि तू खा जास हइ. ते रस्ता कसा जान्ये?” ");
INSERT INTO goj_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","यीशु ने ओकासे बोल्यो, “रस्ता अरु सच्ची अरु जिवन मी ही हइ. बिना मरा वजेसे कोय बाप का पास नी पहुचे सक्ये. ");
INSERT INTO goj_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","अगर तुम ने मेखे जान्यो होतो, ते मरा बाप खे भी जानता, अरु अब ओखे जानस हइ, अरु ओखे देख्यो भी हइ.” ");
INSERT INTO goj_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","फिलिप्पुस ने ओकासे बोल्यो, “हे प्रभु, बाप खे हमखे दिख्यै दे योही हमारा लिये भोत हइ.” ");
INSERT INTO goj_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","यीशु ने ओकासे बोल्यो, “हे फिलिप्पुस, मी येत्ता दिन से तुमारा साथ हइ, अरु का तू मेखे नी जाने? जे ने मेखे देख्यो हइ ओने बाप खे देख्यो हइ तू का बोलस हइ कि बाप खे हमखे दिखा? ");
INSERT INTO goj_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","का तू विश्वास नी कर्‍हे, कि मी बाप मे हइ, अरु बाप मरा मे हइ? या बातहोन जो मी तुम से बोलस हइ, अपना तरफ से नी बोलु, पर बाप मरा मे र्‍हिखे अपनो काम करस हइ. ");
INSERT INTO goj_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","मरो ही विश्वास करणु, कि मी बाप मे हइ. अरु बाप मरा मे हइ. नी ते कामहोन का कारण मरो विश्वास करणु. ");
INSERT INTO goj_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“मी तुम से सच्ची-सच्ची बोलुस हइ, कि जो मरा पर विश्वास रखस हइ, ये काम जो मी करस हइ उ भी कर्ये, क्युकी इनसे भी बडा काम कर्ये, क्युकी मी बाप का पास जउस हइ. ");
INSERT INTO goj_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","अरु जो कुछ तुम मरा नाम से माग्ये, उ मी कर्यु कि बेटा का वजेसे बाप की महिमा हुये. ");
INSERT INTO goj_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","अगर तुम मरासे मरा नाम से कुछ माग्ये, ते मी ओखे कर्यु. ");
INSERT INTO goj_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“अगर तुम मरासे प्रेम रखस हइ, ते मरी आज्ञाहोन खे मान्ये. ");
INSERT INTO goj_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","अरु मी बाप से प्रार्थना कर्यु, अरु उ तुमखे एक अरु मदत करी दिह्ये, कि उ कभी भी तुमारा साथ र्‍हिये. ");
INSERT INTO goj_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","यानेकी सच्चीइ की आत्मा खे जेखे जगत ग्रहण नी करी सक्ये, क्युकी उ नी ओखे देखस हइ अरु नी ओखे जानस हइ तुम ओखे जानस हइ, क्युकी उ तुमारा साथ र्हेस हइ, अरु उ तुम मे हुये. ");
INSERT INTO goj_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“मी तुमखे अनाथ नी छोड्यु, मी तुमारा पास वापस अउस हइ. ");
INSERT INTO goj_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","अरु थोड़ी देर र्‍हि गइ हइ कि जगत मेखे नी देख्ये, पर तुम मेखे देख्ये, येकालिये कि मी जिन्दो हइ, तुम भी जिन्दो र्हिये. ");
INSERT INTO goj_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","उ दिन तुम जान्ये, कि मी अपना बाप मे हइ, अरु तुम मरा मे, अरु मी तुम मे. ");
INSERT INTO goj_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“जेका पास मरी आज्ञा हइ, अरु उ उनखे मानस हइ, उ मरासे प्रेम रखस हइ, अरु जो मरासे प्रेम रखस हइ, ओकासे मरो बाप प्रेम रख्ये, अरु मी ओकासे प्रेम रख्यु, अरु अपना आप खे ओका पर प्रगट कर्‍यु.” ");
INSERT INTO goj_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","उ यहूदा ने जो इस्करियोती नी थो, ओकासे बोल्यो, “हे प्रभु, का हुयो कि तू अपना आप खे हम पर प्रगट करणो चाहस हइ, अरु जगत पर नी?” ");
INSERT INTO goj_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","यीशु ने ओखे जवाब दियो, “अगर कोय मरासे प्रेम रख्ये, ते उ मरो वचन खे मान्ये, अरु मरो बाप ओकासे प्रेम रख्ये, अरु हम ओका पास आह्ये, अरु ओका साथ वास कर्ये. ");
INSERT INTO goj_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","जो मरासे प्रेम नी रख्ये, उ मरो वचन नी माने, अरु जो वचन तुम सुनस हइ, उ मरो नी क्युकी बाप को हइ, जे ने मेखे भेज्यो. ");
INSERT INTO goj_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“या बातहोन मेने तुमारा साथ र्‍हेता हुये तुम से बोली. ");
INSERT INTO goj_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","पर मदतगार यानेकी पवित्र आत्मा जेखे बाप मरा नाम से भेज्ये, उ तुमखे सब बातहोन सिखाये, अरु जो कुछ मेने तुम से बोल्यो हइ, उ सब तुमखे याद कराये.” ");
INSERT INTO goj_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","मी तुमखे शांती दिखे जउस हइ, अपनी शांती तुमखे देउस हइ. जसो जगत देस हइ, मी तुमखे नी देउ तुमारो मन नी घबराये अरु नी डरनु. ");
INSERT INTO goj_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","तुम ने सुन्यो कि मेने तुम से बोल्यो, मी जउस हइ अरु तुमारा पास फिर अउस हइ. अगर तुम मरासे प्रेम रख्ये. ते या बात से खुश हुये, कि मी बाप का पास जउस हइ क्युकी बाप मरा से बडो हइ. ");
INSERT INTO goj_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","अरु मेने अब येका होना से पैयले तुम से बोली दियो हइ, कि जब उ हुये जाये, ते तुम विश्वास करणू. ");
INSERT INTO goj_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","मी अब से तुमारा साथ अरु भोत बातहोन कर्यु क्युकी यो जगत को मुखियो आस हइ, अरु मरा पर ओको कुछ अधिकार नी. ");
INSERT INTO goj_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","पर यो येकालिये होस हइ कि जगत जान्ये कि मी बाप से प्रेम रखुस हइ, अरु जो तरह बाप ने मेखे आज्ञा दी, मी ओसो ही करुस हइ, उठी खे ह्या से चल. ");
INSERT INTO goj_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","सच्ची अंगूर कि बेल मी हइ. अरु मरो बाप किसान हइ. ");
INSERT INTO goj_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","जो डाली मरा मे हइ, अरु नी फले, ओखे उ काटी डालस हइ, अरु जो फलस हइ, ओखे उ छाटस हइ ताकि जादा फल्ये. ");
INSERT INTO goj_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","तुम तो उ वचनकरण जो मेने तुम से बोल्यो हइ, अच्छो हुये. ");
INSERT INTO goj_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","तुम मरा मे बन्या र्‍हेनु, अरु मी तुम मे जसी डाली अगर अंगूर कि बेल मे बनी नी ऱ्हिये ते अपना आप से नी फली सक्ये ओसो ही तुम भी अगर मरा मे बन्या नी र्‍हिये ते नी फली सक्ये. ");
INSERT INTO goj_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","मी अंगूर कि बेल हइ तुम डालीहोन हइ. जो मरा मे बन्यो र्‍हेस हइ, अरु मी ओमे, उ भोत फल फलस हइ, क्युकी मरासे अलग हुइखे तुम कुछ भी नी करी सक्ये. ");
INSERT INTO goj_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","अगर कोय मरा मे बन्यो नी र्हियेका ते वा डाली का जसा फेकी दियो जास, अरु सूखी जास हइ. अरु इन्सान उनखे बटोरीखे अंगार मे फेकी देस हइ, अरु वे जली जास हइ. ");
INSERT INTO goj_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","अगर तुम मरा मे बन्या र्‍हिये अरु मरी बातहोन तुम मे बनी र्‍हिये ते जो चाह्ये मागनू अरु उ तुमारा लिये हुइ जाये. ");
INSERT INTO goj_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","मरा बाप की महिमा येमे से होस हइ, कि तुम भोत सो फल लानु, तब तुम मरा सेवक ठैइऱ्यो. ");
INSERT INTO goj_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","जसो बाप ने मरासे प्रेम रख्यो, ओसो मेने तुम से प्रेम रख्यो, मरा प्रेम मे बन्या र्‍हिये. ");
INSERT INTO goj_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","अगर तुम मरी आज्ञाहोन खे मान्ये का ते मरा प्रेम मे बन्या र्हिये जसा कि मेने अपना बाप की आज्ञाहोन खे मान्यो हइ, अरु ओका प्रेम मे बन्यो र्‍हेस हइ. ");
INSERT INTO goj_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","मेने या बातहोन तुम से येका लिये बोली हइ, कि मरो आनन्द तुम मे बन्यो र्‍हिये अरु तुमारो आनन्द पूरा हुइ जाये. ");
INSERT INTO goj_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","मरी आज्ञा या हइ, कि जसो मेने तुम से प्रेम रख्यो, ओसो ही तुम भी एक दूसरा से प्रेम रखनु. ");
INSERT INTO goj_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","येका से बडो प्रेम कोय को नी, कि कोय अपना दोस्तहोन का लिये अपनो जान देनु. ");
INSERT INTO goj_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","जो कुछ मी तुमखे आज्ञा देउस हइ, अगर ओखे करणु, ते तुम मरा दोस्त हुये. ");
INSERT INTO goj_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","अब से मी तुमखे दास नी बोल्यु, क्युकी सेवक नी जाने, कि ओको स्वामी का करस हइ पर मेने तुमखे दोस्त बोल्यो हइ, क्युकी मेने जो बातहोन अपना बाप से सुनी, वे सब तुमखे बतैइ दी. ");
INSERT INTO goj_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","तुम ने मेखे नी चुन्यो पर मेने तुमखे चुन्यो हइ अरु तुमखे ठैइरायो ताकि तुम जैइखे फल लानु. अरु तुमारो फल बन्यो र्‍हिये कि तुम मरा नाम से जो कुछ बाप से माग्ये उ तुमखे दिये. ");
INSERT INTO goj_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","या बातहोन की आज्ञा मी तुमखे येका लिये देउस हइ, कि तुम एक दूसरा से प्रेम रखनु. ");
INSERT INTO goj_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“अगर जगत तुम से बैर रखस हइ, ते तुम जानस हइ, कि ओने तुम से पैयले मरासे भी बैर रख्यो. ");
INSERT INTO goj_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","अगर तुम जगत का होस, ते जगत अपना से प्रेम रखेतो, पर यो कारण कि तुम जगत, नी क्युकी मेने तुमखे जगत मे से चुनी लियो हइ. येका लिये जगत तुम से बैर रखस हइ. ");
INSERT INTO goj_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","जो बात मेने तुम से बोली थी, ‘सेवक अपना स्वामी से बडो नी होय.’ ओखे याद रखनु अगर उनने मेखे सतायो, ते तुमखे भी सताये. अगर उनने मरी बात मानी, ते तुमारी भी मान्ये. ");
INSERT INTO goj_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","पर यो सब कुछ वे मरा नामकरण तुमारा साथ कर्ये क्युकी वे मरा भेजनआला खे जाने. ");
INSERT INTO goj_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","अगर मी नी आतो अरु उनसे बातहोन नी करतो, ते वे पापी नी रोखता था पर अब उनके उनका पाप का लिये कोय बहानो नी. ");
INSERT INTO goj_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","जो मरासे बैर रखस हइ, उ मरा बाप से भी बैर रखस हइ. ");
INSERT INTO goj_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","अगर मी उनमे वे काम नी करतो, जो दुसरा कोय ने नी कर्या ते वे पापी नी ठैइरता, पर अब तो उनने मेखे अरु मरा बाप दोइ खे देख्यो, अरु दोइ से बैर कर्यो. ");
INSERT INTO goj_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","अरु येका लिये हुयो, कि उ वचन पूरा हो, जो उनकी व्यवस्था मे लिख्यो हइ, ‘उनने मरासे बेकार बैर कर्यो.’ ");
INSERT INTO goj_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“पर जब उ मदतगार अये जेखे मी तुमारा पास बाप का तरफ से भेजु, मंनजे सच्ची की आत्मा जो बाप, तरफ से नीकलस हइ, ते वा मरी गवइ दिये. ");
INSERT INTO goj_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","अरु तुम भी गवइ होनु क्युकी तुम सुरुवात से मरा साथ हइ. ");
INSERT INTO goj_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“या बातहोन मेने तुम से, येका लिए बोली कि तुम ठोकर नी खानू. ");
INSERT INTO goj_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","वे तुमखे आराधनालयहोन मे से नीकाली दिये क्युकी उ टेम आस हइ, कि जो कोय तुमखे मारी डाल्ये यो समझ्ये कि मी परमेश्वर की सेवा करुस हइ. ");
INSERT INTO goj_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","अरु येका लिए कर्ये कि उनने नी बाप खे जान्यो हइ अरु नी मेखे जानस हइ. ");
INSERT INTO goj_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","पर या बातहोन मेने येका लिए तुम से बोली, कि जब उनखे पूरो होन को टेम आयो ते तुमखे याद अय जाये कि मेने तुम से पैयले ही बोली दियो थो. “मेने सुरुवात मे तुम से या बातहोन येका लिए नी बोली क्युकी मी तुम्हारा साथ थो. ");
INSERT INTO goj_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","अब मी अपना भेजन आला का पास जउस हइ अरु तुम मे से कोय मरासे नी पुछे, तू खा जास हइ? ");
INSERT INTO goj_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","पर मेने जो या बातहोन तुम से बोली हइ, येका लिए तुमारो मन शोक से भरी गयो. ");
INSERT INTO goj_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","फिर भी मी तुम से सच्ची बोलुस हइ, कि मरो जानो तुमारा लिये अच्छा हइ, क्युकी अगर मी नी जाउ, ते उ मदतगार तुमारा पास नी आये का पर अगर मी जाह्यु, ते ओखे तुमारा पास भेजी दिह्यु. ");
INSERT INTO goj_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","अरु उ अय खे जगत खे पाप अरु धार्मीकता अरु न्याय का बारे मे नीरुत्तर कर्ये. ");
INSERT INTO goj_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","पाप का बारे मे येका लिए कि वे मरा पर विश्वास नी कर्ये. ");
INSERT INTO goj_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","अरु धार्मीकता का बारे मे येका लिए कि मी बाप का पास जउस हइ, अरु तुम मेखे फिर नी देख्ये. ");
INSERT INTO goj_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","न्याय का बारे मे येका लिए कि जगत को मुखियो दोषी ठैरायो गयो हइ. ");
INSERT INTO goj_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“मेखे तुम से अरु भी भोत सी बातहोन बोलनो हइ, पर अभी तुम उनखे सै नी सक्ये. ");
INSERT INTO goj_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","पर जब उ मंनजे सचाइ कि आत्मा अये ते तुमखे सब सच्चीइ कि रस्ता बताये क्युकी उ अपना तरफ से नी बोल्ये पर जो कुछ सुन्ये का उ बोल्ये अरु आनआली बातहोन तुमखे बताये. ");
INSERT INTO goj_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","उ मरी महिमा कर्ये क्युकी उ मरी बातहोन मे से लीखे तुमखे बताये. ");
INSERT INTO goj_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","जो कुछ बाप को हइ, उ सब मरो हइ. येका लिए मेने बोल्यो, कि उ मरी बातहोन मे से लीखे तुमखे बताये. ");
INSERT INTO goj_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“थोडी देर मे तुम मेखे नी देख्ये, अरु फिर थोडी देर मे मेखे देख्ये.” ");
INSERT INTO goj_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","तब ओका केत्ता सेवक होन ने आपस मे बोल्यो, यो का हइ, जो उ हम से बोलस हइ, थोडी देर मे तुम मेखे नी देख्ये का अरु फिर थोड़ी देर मे मेखे देख्ये? अरु यो येका लिये कि मी बाप का पास जउस हइ? ");
INSERT INTO goj_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","तब उनने बोल्यो कि यो थोड़ी देर जो उ बोलस हइ का बात हइ? हम नी जाने कि का बोलस हइ. ");
INSERT INTO goj_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","यीशु ने यो जानीखे कि वे मरासे पुछनो चाउस हइ, उनसे बोल्यो तुम आपस मे मरी या बात का बारे मे पुछ-ताछ करस हइ, थोडी देर मे तुम मेखे नी देख्ये का अरु फिर थोड़ी देर मे मेखे देख्ये? ");
INSERT INTO goj_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","मी तुम से सच्ची सच्ची बोलुस हइ. कि तुम रोये अरु विलाप कर्ये पर जगत खुशी कर्ये तुमखे दुख हुये कि पर तुमारो दुख खुशी बनी जाये. ");
INSERT INTO goj_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","जब बय जन्म देस हइ ते ओखे दुख होस हइ, क्युकी ओको दुख की घडी अय पहुची, पर जब उ बच्चा खे जन्म दि चुकी ते या खुशी से कि जगत मे एक इन्सान उत्पन्न हुयो, वा संकट खे फिर याद नी कर्ये. ");
INSERT INTO goj_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","अरु तुमखे भी अब तो दुख हइ, पर मी तुम से फिर मील्यु अरु तुमारा मन मे खुशी हुये. अरु तुमारी खुशी कोय तुम से छुडय नी लीये. ");
INSERT INTO goj_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“उ दिन तुम मरासे कुछ नी पुछ्ये. मी तुम से सच्ची सच्ची बोलुस हइ, अगर बाप से कुछ माग्ये का ते उ मरा नाम से तुमखे दिये. ");
INSERT INTO goj_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","अब तक तुम ने मरा नाम से कुछ नी माग्यो. माग्ये ते मील्हे जब कि तुमारी खुशी पूरी हुइ जाये. ");
INSERT INTO goj_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“मेने या बातहो न तुम से बुरीआत्माहोन मे बोली हइ, पर उ टेम आस हइ, कि मी तुम से बुरीआत्माहोन मे अरु फिर नी कर्यु पर खोलीखे तुमखे बाप का बारे मे बतायु. ");
INSERT INTO goj_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","उ दिन तुम मरा नाम से माग्ये, अरु मी तुम से यो नी बोलु, कि मी तुमारा लिये बाप से प्रार्थना कर्यु. ");
INSERT INTO goj_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","क्युकी बाप तो खुद मे तुम से प्रेम रखस हइ, येका लिए कि तुम ने मरा से प्रेम रख्यो हइ, अरु यो भी विश्वास कर्यो, कि मी बाप का तरफ से आयो. ");
INSERT INTO goj_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","मी बाप का तरफ से जगत मे आयो हइ, फिर जगत खे छोडी खे बाप का पास वापस जउस हइ.” ");
INSERT INTO goj_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","ओका सेवक होन ने बोल्यो, “देख, अब तो तू खुली खे बोलस हइ, कोय दृष्‍टान्‍त नी बोले. ");
INSERT INTO goj_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","आब हम जानी गया, कि तू सब कुछ जानस हइ, अरु जरुरत नी की कोय तरा से सवाल कर्ये येका से हम विश्वास करस हइ, कि तू परमेश्वर का तरफ से आयो हइ” ");
INSERT INTO goj_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","यो सुनी खे यीशु ने उनसे बोल्यो “का तुम आब विश्वास करस हइ? ");
INSERT INTO goj_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","देखनु, वा घडी आस हइ क्युकी अय पहुची कि तुम सब इदर उदर हुइखे अपना-अपना रस्ता लिये अरु मेखे अयखेलो छोड दिये फिर भी मी एकलो नी क्युकी बाप मरा साथ हइ. ");
INSERT INTO goj_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","मेने या बातहोन तुम से येका लिए बोली हइ, कि तुमखे मरा मे शांती मीले. जगत मे तुमखे दुख होस हइ, पर हिम्मत बाधनु, मेने जगत खे जीती लियो हइ.” ");
INSERT INTO goj_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","यीशु ने या बातहोन बोली अरु अपनी आखहोन बद्दल का तरफ उठैइखे बोल्यो, “हे बाप, वा घडी अय पहुची, अपना बेटा की महिमा कर, कि बेटो भी तरी महिमा कर्ये ");
INSERT INTO goj_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","क्युकी तोने ओखे सब जनवरहोन पर अधिकार दियो, कि जिन खे तोने ओखे दियो हइ, उन सब खे उ अनन्त जिवन दे. ");
INSERT INTO goj_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","अरु अनन्त जिवन यो हइ, कि वे तोखे एकी सच्ची परमेश्वर खे अरु यीशु मसीह खे, जेखे तोने भेज्यो हइ, जाने. ");
INSERT INTO goj_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","जो काम तोने मेखे करण खे दियो थो, ओखे पूरो करीखे मेने पृथ्वी पर तरी महिमा करी हइ. ");
INSERT INTO goj_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","अरु अब हे बाप, तू अपना साथ मरी महिमा कर जो जगत की सृष्टि पैयले, मरा तरा साथ थी. ");
INSERT INTO goj_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“मेने तरो नाम वे इन्सानहोन पर प्रगट कर्यो जिन खे तोने जगत मे से मेखे दियो वे तरा था अरु तोने उनने मेखे दियो अरु उनने तरा वचन खे मानी लियो हइ. ");
INSERT INTO goj_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","अब वे जानी गया हइ, कि जो कुछ तोने मेखे दियो हइ, सब तरा तरफ से हइ. ");
INSERT INTO goj_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","क्युकी जो बातहोन तोने मेखे पहुचैइ दी, मेने उनखे पहुचैइ दि अरु उनने उनखे ग्रहण कर्यो अरु सच्ची सच्ची जानी लियो हइ, कि मी तरा तरफ से आयो हइ, अरु यो विश्वास कर्यो हइ की तोने ही मेखे भेज्यो. ");
INSERT INTO goj_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“मी उनका लिये प्रार्थना करुस हइ, जगत का लिये प्रार्थना नी करुस हइ पर उन्ही का लिये जिन खे तोने मेखे दियो हइ, क्युकी वे तरा हइ. ");
INSERT INTO goj_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","अरु जो कुछ मरो हइ उ सब तरो हइ. अरु जो तरो हइ उ मरो हइ. अरु इनसे मरी महिमा प्रगट हुय हइ. ");
INSERT INTO goj_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","मी अब जगत मे नी र्‍हियु, पर ये जगत मे ऱ्‍हियेका अरु मी तरा पास अउस हइ. हे पवित्र बाप, अपना उ नाम से जो तोने मेखे दियो हइ, उनकी रक्षा कर, कि वे हमारा जसो एक समान हो. ");
INSERT INTO goj_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","जब मी उनका साथ थो, ते मेने तरा उ नाम से, जो तोने मेखे दियो हइ, उनकी रक्षा करी मेने उनकी देख-रेख करी अरु विनाश का बेटा खे छोड उनमे से कोय नाश नी हुयो, येका लिए कि पवित्रशास्त्र की बात पूरी हुये. ");
INSERT INTO goj_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","पर आब मी तरा पास अउस हइ, अरु या बातहोन जगत मे बोलुस हइ, कि वे मरी खुशी अपना मे पूरा पाये. ");
INSERT INTO goj_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","मेने तरो वचन उनखे पहुचैइ दियो हइ, अरु जगत ने उनसे बैर कर्यो, क्युकी जसो मी जगत को नी, ओसो ही वे भी जगत का नी. ");
INSERT INTO goj_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","मी या प्रार्थना नी करु, कि तुम उनखे जगत से उठै ले, पर यो कि तुम उनखे उ दुष्ट से बचैइ रख. ");
INSERT INTO goj_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","जसो मी जगत को नी, ओसो ही वे भी जगत नी. ");
INSERT INTO goj_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","सच्चाइ का वजेसे उनखे पवित्र कर तरो वचन सच्ची हइ. ");
INSERT INTO goj_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","जसो तोने जगत मे मेखे भेज्यो, ओसो मे मेने भी उनखे जगत मे भेज्यो. ");
INSERT INTO goj_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","अरु उनका लिये मी अपना आप खे पवित्र करुस हइ ताकि वे भी सच्चाइ का वजेसे पवित्र कर्या जाये. ");
INSERT INTO goj_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“मी फक्त इन का लिये प्रार्थना नी करु, पर उनका लिये भी जो इन, वचन खे वजेसे मरा पर विश्वास कर्ये ");
INSERT INTO goj_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","कि वे सब एक हो. जसो तू हे बाप मरा मे हइ, अरु मी तरा मे हइ, ओसो ही वे भी हम मे हुये खे येका लिए कि जगत विश्वास कर्ये का कि तोने ही ने मेखे भेज्यो. ");
INSERT INTO goj_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","अरु वा महिमा जो तोने मेखे दी, मेने उनखे दी हइ कि वे असो ही एक हो जसा कि हम एक हइ. ");
INSERT INTO goj_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","मी उनमे अरु तू मरा मे कि वे सिद्ध हुइखे एक हुय जाये अरु जगत जान कि तोने मेखे भेज्यो, अरु जसो तोने मरासे प्रेम रख्यो, ओसो ही उनसे प्रेम रख्यो. ");
INSERT INTO goj_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“हे बाप, मी चाहुस हइ कि जिन खे तोने मेखे दियो हइ, झा मी हइ, व्हा वे भी मरा साथ हो कि वे मरी वा महिमा खे देख्ये जो तोने मेखे दी हइ, क्युकी तोने जगत की उत्पत्ति से पैयले मरासे प्रेम रख्यो. ");
INSERT INTO goj_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","हे धर्मी बाप, जगत ने मेखे नी जान्यो, पर मेने तोखे जान्यो अरु येने भी जान्यो कि तोने ही मेखे भेज्यो. ");
INSERT INTO goj_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","अरु मेने तरो नाम उनखे बतायो अरु बतातो र्‍हियु कि जो प्रेम तोखे मरासे थो, उ उनमे र्‍हिये अरु मी उनमे र्‍हियु.” ");
INSERT INTO goj_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","यीशु या बातहोन बोलीखे अपना सेवक होन का साथ किद्रोन का नाला का पार गयो, व्हा एक बारी थी, जोमे उ अरु ओका सेवक गया. ");
INSERT INTO goj_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","अरु ओको पकडनआलो यहूदा भी वा जगा जानतो थो, क्युकी यीशु अपना सेवक होन का साथ व्हा जाया करतो थो. ");
INSERT INTO goj_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","तब यहूदा सैना-दल का अरु प्रधान याजकहोन अरु फरीसीहोन का तरफ से सेवकहोन खे लीखे दीयाहोन अरु मशालहोन अरु हथियारहोन खे लिया हुया व्हा आयो. ");
INSERT INTO goj_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","तब यीशु वे सब बातहोन खे जो ओका पर आनआली थी, जानीखे नीकल्यो, अरु उनसे बोलन लग्यो, “कोखे ढूढस हइ?” ");
INSERT INTO goj_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","उनने ओखे जवाब दियो, “यीशु नासरी खे” यीशु ने उनसे बोल्यो, “मी आय” अरु ओको पकडनआलो यहूदा भी उनका साथ खडो थो. ");
INSERT INTO goj_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","ओखे यो बोलतो ही, “मी आय,” वे पीछे हटीखे जमीन पर गिर पड्या. ");
INSERT INTO goj_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","तब ओने फिर उनसे पूछ्यो, “तुम को खे ढूढस हइ” वे बोल्या, “यीशु नासरी खे.” ");
INSERT INTO goj_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","यीशु ने जवाब दियो, “मी तो तुम से बोल चुक्यो हइ कि मी आय, अगर मेखे ढूढस हइ ते इनखे जान दे.” ");
INSERT INTO goj_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","यो येका लिए हुयो, कि यो वचन पूरो हुये, जो ओने बोल्यो थो “जिन खे तोने मेखे दियो, उनमे से मेने एक खे भी नी खोयो.” ");
INSERT INTO goj_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","शमौन पतरस ने तलवार, जो ओका पास थी, खीची अरु महायाजक का सेवक पर चलखे, ओको दाहिनो कान काटी दियो, उ दास को नाम मलखुस थो. ");
INSERT INTO goj_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","तब यीशु ने पतरस से बोल्यो, “अपनी तलवार मयान मे रख जो कटोरो बाप ने मेखे दियो हइ, का मी ओखे नी पीयु?” ");
INSERT INTO goj_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","तब सेवकहोन अरु उनका सुबेदार अरु यहूदीयाहोन का सेवकहोन ने यीशु खे पकडैखे बाधी लियो, ");
INSERT INTO goj_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","अरु पैयले ओखे हन्ना का पास ली गया क्युकी उ ओखे साल को महायाजक कैफा को सुसरो थो. ");
INSERT INTO goj_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","यो उ कैफा थो, जेने यहूदीयाहोन खे सलाह दी थी कि हमारा दुन्याहोन का लिये एक इन्सान को मरनु अच्छो हइ. ");
INSERT INTO goj_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","शमौन पतरस अरु एक अरु चेलो भी यीशु का पीछे अय गा यो चेलो महायाजक को जाना पैछान्यो थो अरु यीशु का साथ महायाजक का अंगन मे गयो. ");
INSERT INTO goj_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","पर पतरस बाहेर दरवाजा पर खडो र्‍हियो, तब उ दूसरो चेलो जो महायाजक को जान्यो पहचान्यो थो, बाहेर नीकल्यो, अरु चौकीदार से बोलीखे पतरस खे अंदर ली आयो. ");
INSERT INTO goj_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","वा दासी ने जो चौकीदार थी, पतरस से बोल्यो “तू भी यो इन्सान का सेवक होन मे से हइ?” ओने बोल्यो, “मी नी आय.” ");
INSERT INTO goj_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","दास अरु सेवक ठडकारण कोयला जलय खे अंगार तापी र्‍हा था अरु पतरस भी उनका साथ खडो अंगार तापी र्‍हो थो. ");
INSERT INTO goj_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","तब महायाजक ने यीशु से ओका सेवक होन का बारे मे अरु ओका उपदेस का बारे मे पुछयो. ");
INSERT INTO goj_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","यीशु ने ओको जवाब दियो, “मेने जगत से खुली खे बातहोन करी. मेने आराधनालयहोन अरु मन्‍दिर मे झा सब यहूदीया जमा हुया करस हइ सदा उपदेस कर्यो अरु गुप्त मे कुछ भी नी बोल्यो. ");
INSERT INTO goj_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","तू मरासे क्यु पूछस हइ? सुनानवाला से पूछ्यो कि मेने उनसे का बोल्यो? देख वे जानस हइ. कि मेने बोल्यो.” ");
INSERT INTO goj_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","जब ओने यो बोल्यो, तो सेवकहोन मे से एक ने जो पास खडो थो, यीशु खे थप्पड मारीखे बोल्यो, “ का तू महायाजक खे यो प्रकार जवाब देस हइ?” ");
INSERT INTO goj_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","यीशु ने ओखे जवाब दियो, “अगर मेने बुरो बोल्यो तरे वा बुरोइ पर गवइ दे. पर अगर भलो बोल्यो, तो मेखे क्यु मारस हइ?” ");
INSERT INTO goj_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","हन्ना ने ओखे बध्यो हुया कैफा महायाजक खे पास भेजी दियो. ");
INSERT INTO goj_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","शमौन पतरस खडो हुयो अंगार तापी र्‍हो थो तब उनने ओकासे बोल्यो “ का तू भी ओका सेवक होन मे से हइ?” ओने इनकार करीखे बोल्यो, “मी नी आय” ");
INSERT INTO goj_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","महायाजक का सेवकहोन मे से एक जो ओका कुटुब मे से थो, जोको कान पतरस काटी डाल्यो थो, बोल्यो, “ का मेने तोखे ओका साथ बाडी मे नी देख्यो थो?” ");
INSERT INTO goj_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","पतरस फिर इनकार करी गयो अरु जल्दी मुर्गा ने बांग दी. ");
INSERT INTO goj_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","अरु वे यीशु खे कैफा का पास से किल्ला मे खे ली गया अरु फजर को टेम थो, पर वे खुद किल्ला का अंदर नी गयो ताकि अशुद्ध नी हुये पर त्योवार खै सखे. ");
INSERT INTO goj_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","तब पिलातुस उनका पास बाहेर नीकली आयो अरु बोल्यो, “तुम यो इन्सान पर कोनती बात को इलजाम लगास हइ?” ");
INSERT INTO goj_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","उनने ओखे जवाब दियो, “अगर उ कुकर्मी नी होतो ते हम ओखे तरा हात नी सौपता.” ");
INSERT INTO goj_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","पिलातुस ने ओकासे बोल्यो, “तुम मे येखे ली जैइखे अपनी व्यवस्था का जसो ओको न्याय करणु.” यहूदीयाहोन ने ओकासे बोल्यो, “हमखे अधिकार नी कि कोइ कि जान ले.” ");
INSERT INTO goj_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","यो येका लिए हुयो, कि यीशु की वा बात पूरी हो जो ओने यो दर्शाता हुये बोली थी, कि ओको मरनो कसो हुये. ");
INSERT INTO goj_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","तब पिलातुस फिर किल्ला का अंदर गयो अरु यीशु खे बुलैइ खे, ओकासे पूछ्यो “तू यहूदीयाहोन को राजो हइ?” ");
INSERT INTO goj_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","यीशु ने जवाब दियो, “का तू या बात अपना तरफ से बोलस हइ या दुसरा ने मरा बारे मे तरा से बोली?” ");
INSERT INTO goj_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","पिलातुस ने जवाब दियो, “मी यहूदीया आय? तरी मे जाति अरु प्रधान याजकहोन ने तोखे मरा हात दियो तोने का कर्यो हइ?” ");
INSERT INTO goj_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","यीशु ने जवाब दियो, “मरो राज्य यो जगत को नी, अगर मरो राज्य यो जगत को होतो, ते मरा सेवक लडता, कि मी यहूदीयाहोन का हात सोपी नी जातो पर अब मरो राज्य ह्या को नी.” ");
INSERT INTO goj_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","पिलातुस ने ओकासे बोल्यो, “ते का तू राजा हइ?” यीशु ने जवाब दियो, “तू बोलस हइ कि मी राजा आय. मेने येका लिए जन्म लियो, अरु येका लिए जगत मे आयो हइ कि सच्चाइ पर गवइ दे जो कोय सच्चाइ को हइ, उ मरी आवाज सुनस हइ.” 1 यूह. 4:6 ");
INSERT INTO goj_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","पिलातुस ने ओकासे बोल्यो, “सच्चाइ हइ?” अरु यो बोलीखे उ फिर यहूदीयाहोन का पास नीकली गयो अरु उनसे बोल्यो, मी तो ओमे कुछ दोष नी होन. ");
INSERT INTO goj_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","पर तुम्हारी या रीति हइ कि, “मी त्योवारमे तुम्हारा लिये एक इन्सान खे छोडी दियू. ते का तुम चाहस हइ, कि मी तुम्हारा लिये यहूदीयाहोन को राजा का छोडी दियु?” ");
INSERT INTO goj_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","तब उनने फिर चिलैइ खे बोल्यो, “येखे नी पर हमारा लिये बरअब्बा खे छोडी दे.” अरु बरअब्बा डाकू थो. ");
INSERT INTO goj_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","येका पर पिलातुस ने यीशु खे लिखे कोडा लगवाया. ");
INSERT INTO goj_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","अरु सेवकहोन ने काटा को मुकुट गूधिखे ओका माथा रख्यो, अरु ओखे बैगनी कपडा पेनाया, ");
INSERT INTO goj_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","अरु ओका पास अयखे बोलन लग्या, “हे यहूदीयाहोन का राजा खे प्रणाम!” अरु ओखे थप्पड मार्यो. ");
INSERT INTO goj_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","तब पिलातुस ने फिर बाहेर नीकलीखे दुन्याहोन से बोल्यो, “देखनु, मी ओखे तुम्हारा पास फिर बाहेर लउस हइ. ताकि तुम जान्ये कि मी कुछ भी दोष नी मील्हे.” ");
INSERT INTO goj_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","तब यीशु का काटा को मुकुट अरु बैगनी कपडा परन्या हुया बाहेर नीकल्यो अरु पिलातुस ने उनसे बोल्यो, “देखनु यो इन्सान.” ");
INSERT INTO goj_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","जब प्रधान याजकहोन अरु सेवकहोन ने ओखे देख्यो ते चिलैइ खे बोल्यो, “ओखे क्रुस पर चडा, क्रुस पर!” पिलातुस ने उनसे बोल्यो, “तुम मे ओखे लिखे क्रुस पर चडा. क्युकी मी ओका मे दोष नी पायो.” ");
INSERT INTO goj_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","यहूदीयाहोन ने ओखे जवाब दियो, “हमारी भी व्यवस्था हइ अरु व्यवस्था का जसो उ मार्यो जान का योग्य हइ क्युकी ओने अपना आप खे परमेश्वर को बेटो बतायो.” ");
INSERT INTO goj_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","जब पिलातुस ने या बात सुनी ते अरु भी डरी गयो. ");
INSERT INTO goj_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","अरु फिर किल्ला का अंदर गयो अरु यीशु से बोल्यो, “तू खा को हइ?” पर यीशु ने ओखे कुछ भी जवाब नी दियो. ");
INSERT INTO goj_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","पिलातुस ने ओकासे बोल्यो, “मरासे क्यु नी बोले, तू नी जाने कि तोखे छोड़ देन को अधिकार मेखे हइ अरु तोखे क्रुस पर चडान को भी अधिकार हइ.” ");
INSERT INTO goj_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","यीशु ने जवाब दियो, “अगर तोखे उपर से नी दियो जातो, ते तरो मरा पर कुछ अधिकार नी होतो. येका लिए जेने मेखे तरो हात पकडवायो हइ, ओको पाप जादा हइ.” ");
INSERT INTO goj_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","येका से पिलातुस ने ओखे छोड़ देनो चायो, पर यहूदीयाहोन ने चिल्लै चिल्लय खे बोल्यो, “अगर तू येखे छोड़ दिये ते तू कैसर को दोस्त नी. जो कोय अपना आप खे राजो बनास हइ उ कैसर को सामनो करस हइ.” ");
INSERT INTO goj_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","या बातहोन सुनीखे पिलातुस यीशु खे बाहेर लायो अरु वा जगह मे एक चबूत्ररो थो का जो इब्रानी मे “गब्बता” बोलस हइ का अरु न्याय आसन पर बैठ्यो. ");
INSERT INTO goj_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","यो त्योवार को तैयारी को दिन थो अरु छे घंटा का नजीकपास थो तब ओने यहूदीहोन से बोल्यो, “देखनु, योही हइ, तुम्हारो राजो!” ");
INSERT INTO goj_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","पर वे चिल्लाया, ली जा! ली जा! ओखे क्रुस पर चढ़ा! पिलातुस ने उनसे बोल्यो “मी तुम्हारो राजा?” “खे क्रुस पर चढ़ाउ प्रधान याजकहोन ने जवाब दियो.” “कैसर खे छोड़ हमारो अरु कोय राजो नी.” ");
INSERT INTO goj_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","तब ओने ओखे उनका हात सौप दियो ताकि उ क्रुस पर चढायो जाये. ");
INSERT INTO goj_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","तब वे यीशु खे ली गया अरु उ अपनो क्रुस उठायो हुया उ जगा तक बाहेर गयो जो “खोपडी कि जगा” बोलस हइ अरु इब्रानी मे “गुलगुता.” ");
INSERT INTO goj_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","व्हा उनने ओखे अरु उ ओका साथ अरु दो इन्सानहोन खे क्रुस पर चढायो, एक खे इधर अरु एक खे उधर, अरु बीच मे यीशु खे. ");
INSERT INTO goj_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","अरु पिलातुस ने एक दोष चिट्टी लिखीखे क्रुस पर लगै दि अरु ओमे यो लिख्यो हुयो थो, “यीशु नासरी यहूदीयाहोन को राजो.” ");
INSERT INTO goj_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","यो दोष चिट्टी भोत यहूदीयाहोन ने पड्यो क्युकी वा जगा झा यीशु क्रुस पर चढायो गयो थो नगर का पास थी अरु चिट्टी इब्रानी अरु लतीनी अरु यूनानी मे लिखी हुइ थी. ");
INSERT INTO goj_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","तब यहूदीयाहोन को प्रधान याजकहोन ने पिलातुस से बोल्यो, “यहूदीयाहोन को राजो” मत लिख पर यो कि “ओने बोल्यो, मी यहूदीयाहोन को राजो हइ.” ");
INSERT INTO goj_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","पिलातुस ने जवाब दियो, “मेने जो लिखी दियो, उ लिखी दियो.” ");
INSERT INTO goj_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","जब सेवक होन ने यीशु खे क्रुस पर चडा चुक्या, ते ओका कपडा लिखे चार टुकडा कर्या, हर सेवक का लिये एक टुकडो अरु कुर्ता भी लियो, पर कुर्ता बिन सीअन उपर से नीचे तक सियो हुयो थो. ");
INSERT INTO goj_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","येका लिए उनने आपस मे बोल्यो, “हम येखे नी फाड्ये पर येका पर चिट्ठी डाल्ये कि उ कोको हुये” यो येका लिए हुयो, कि पवित्रशास्त्र की बात पूरी हो, “उनने मरा कपडा आपस मे बाटी लिया अरु मरा कपडा पर चिट्ठी डाली.” ");
INSERT INTO goj_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","अन्नत सेवकहोन ने असो मे कर्यो, पर यीशु खे क्रुस का पास ओकी माय अरु ओकी माय की भैइन मरियम, क्लोपास की लुगइ अरु मरियम मगदलीनी खड़ी थी. ");
INSERT INTO goj_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","यीशु ने अपनी माय अरु ओका सेवक खे जोका से उ प्रेम रखेतो थो पास खडा देखीखे अपनी माय से बोल्यो, “हे बय, देख, यो तरो बेटो आय.” ");
INSERT INTO goj_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","तब ओका सेवक से बोल्यो, “या तरी माय आय” अरु उ टेम से उ सेवक ओखे अपना घर ली गया. ");
INSERT INTO goj_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","येका बाद यीशु ने यो जानीखे कि आब सब कुछ हुइ चुक्यो. येका लिए कि पवित्रशास्त्र की बात पूरी हुये बोल्यो, “मी प्यासो हइ.” ");
INSERT INTO goj_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","व्हा एक सिरका से भर्यो हुयो बर्तन धर्यो थो, येका लिए उनने सिरका भिजायो हुया पनसोख्‍ता को जूफा पर रखीखे ओका मुडा से लगायो. ");
INSERT INTO goj_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","जब यीशु ने वह सिरकी लि खे बोल्यो, “पूरो हुय” अरु माथो झुखै खे आत्मा छोडी दियो. ");
INSERT INTO goj_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","अरु येका लिए कि उ तैयारी को दिन थो, यहूदीयाहोन ने पिलातुस से प्रार्थना करीखे कि उनकी टाग तोडी दि जाह्ये अरु वे उतार्ये जाह्ये क्युकी अराम को दिन वे क्रुस पर नी र्‍हिये क्युकी उ अराम को दिन बडो दिन थो. ");
INSERT INTO goj_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","येका लिए सेवक होन ने अयखे पहइले की टागहोन तोडी तब दूसरा की भी, जो ओका साथ क्रुसहोन पर चडाया गया था. ");
INSERT INTO goj_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","पर जब यीशु का पास देख्यो कि उ मरी चुक्यो हइ, ते ओकी टागहोन नी तोडी. ");
INSERT INTO goj_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","पर सेवक होन मे से एक ने ओको पजर बेधा अरु ओमे से जल्दी खुन अरु पानी नीकल्यो. ");
INSERT INTO goj_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","जो ने यो देख्यो, ओ ने गवइ दी हइ, अरु ओकी गवइ सच्ची हइ. अरु उ जानस हइ, कि सच्ची बोलस हइ कि तुम भी विश्वास करणु. ");
INSERT INTO goj_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","ये बातहोन येका लिए हुइ कि पवित्रशास्त्र की या बात पूरी हुये, “ओकी कोय हड्डी तोडी नी जाये.” ");
INSERT INTO goj_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","फिर एक अरु जगा पर यो लिख्यो हइ, “जोका से उनने बेध्यो हइ, ओ पर दृष्टि कर्ये.” ");
INSERT INTO goj_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","या बातहोन का बाद अरिमतियाह का यूसुफ ने, जो यीशु को चेलो थो, पर यहूदीयाहोन का डर से या बात खे लुकायो थो, पिलातुस से प्रार्थना करीखे कि मी यीशु कि लास खे ली जउ, अरु पिलातुस ने ओकी प्रार्थना सुनी, अरु उ अय खे ओको लास ली गयो. ");
INSERT INTO goj_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","नीकुदेमुस भी जो पहइले यीशु का पास रात खे गयो थो पचास सेर का लोबान मील्यो हुयो गन्धरस अरु एलवा ली आयो. ");
INSERT INTO goj_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","तब उनने यीशु को लास खे लियो अरु यहूदीयाहोन का गाडन की रीति का जसो ओखे गधानवाली चिज का साथ कपडा मे गुड्यो. ");
INSERT INTO goj_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","जगा पर झा यीशु क्रुस पर चढायो गयो थो, एक बारी थी. अरु वा बारी मे एक नइ कब्र थी. जोमे कभी कोय नी रख्यो गयो थो. ");
INSERT INTO goj_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","अन्नत यहूदीयाहोन की तैयारी का दिन थो, उनने यीशु खे ओ मे रख्यो, क्युकी वा कब्र पास थी. ");
INSERT INTO goj_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","हप्ता, पैयले दिन मरियम मगदलीनी फजर का अधारो र्‍हेतो मे कब्र पर अय, अरु पत्थर खे कब्र से हट्यो हुयो देख्यो. ");
INSERT INTO goj_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","तब वा दौडी अरु शमौन पतरस अरु उ दूसरा सेवक का पास जोका से यीशु प्रेम रखेतो थो अयखे बोल्यो, “वे प्रभु खे कब्र मे से नीकाली ली गया हइ. अरु हम नी जानती, कि ओखे खा रखी दियो हइ.” ");
INSERT INTO goj_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","तब पतरस अरु उ दूसरो चेलो नीकलीखे कब्र का तरफ चल्यो. ");
INSERT INTO goj_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","अरु दोइ साथ-साथ दौडी र्‍हा था, पर दूसरो चेलो पतरस से आगे बडीखे कब्र पर पहइले पहुच्यो. ");
INSERT INTO goj_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","अरु झुकीखे कपडा पड्या देख्या ते भी उ अंदर नी गयो. ");
INSERT INTO goj_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","तब शमौन पतरस ओका पीछे-पीछे पहुच्यो अरु कब्र का अंदर गयो अरु कपडा पड्या देख्या. ");
INSERT INTO goj_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","अरु उ कपडो जो ओका माथा पर बाध्यो हुयो थो कपडा का साथ पडयो हुयो नी पर अलग एक जगा लपेट्यो हुयो देख्यो. ");
INSERT INTO goj_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","तब दूसरो चेलो भी जो कब्र पर पैयले पहुच्यो थो, अंदर गयो अरु देखीखे विश्वास कर्यो. ");
INSERT INTO goj_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","वे तो अब तक पवित्रशास्त्र की वा बात नी समझता था, कि ओखे मर्या हुया मे से जी उठनो हुये. ");
INSERT INTO goj_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","तब ये सेवक अपना घर लौटी गया. ");
INSERT INTO goj_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","पर मरियम रोती हुइ कब्र का पास मे बाहेर खड़ी थी अरु रोते-रोते कब्र का तरफ झुकीखे, ");
INSERT INTO goj_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","दो स्वर्गदूतहोन खे सफात कपडा पेन्या हुया एक खे सिरहाना अरु दूसरा खे पाय का पास बठ्यो देख्यो, झा यीशु की लास पड्‍यो थो. ");
INSERT INTO goj_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","उनने ओकासे बोल्यो, “हे बय, तू क्यु रोस हइ?” ओने उनसे बोल्यो, “वे मरा प्रभु खे उठै ली गया अरु मी नी जानु कि ओखे खा रख्यो हइ.” ");
INSERT INTO goj_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","यो बोलीखे वा पीछे फिरी अरु यीशु खे खडो देख्यो अरु नी पहचान्यो कि यो यीशु हइ. ");
INSERT INTO goj_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","यीशु ने ओकासे बोल्यो, “हे बय तू क्यु रोस हइ? को खे ढूढस हइ?” ओने माली समझी खे ओकासे बोल्यो, “हे श्रीमान, अगर तोने ओखे उठै लियो हइ ते प्रभु से बोल कि ओखे खा रख्यो हइ अरु मी ओखे ली जायु.” ");
INSERT INTO goj_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","यीशु ने ओकासे बोल्यो, “मरियम!” ओने पीछे फिरीखे ओकासे इब्रानी मे बोल्यो का “रब्बूनी!” मंनजे हे गुरु. ");
INSERT INTO goj_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","यीशु ने ओकासे बोल्यो का “मेखे मत छी क्युकी मी अब तक बाप का पास उपर नी गयो, पर मरा भैइहोन का पास जैइखे उनसे बोली दे कि मी अपना बाप का अरु तुम्हारा बाप का अरु अपना परमेश्वर अरु तुम्हारा परमेश्वर का पास उपर जउस हइ.” ");
INSERT INTO goj_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","मरियम मगदलीनी ने जैइखे सेवक होन खे बतायो, “मेने प्रभु खे देख्यो अरु ओने मरासे बातहोन बोली.” ");
INSERT INTO goj_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","उ दिन जो हप्ता का पहइलो दिन थो, शाम को टेम जब व्हा, दरवाजा झा सेवक था, यहूदीयाहोन का डर का मारे बन्द था, तब यीशु आयो अरु उनका बीच मे खडो हुइखे ओने बोल्यो, “तुम खे शांती मील्ये.” ");
INSERT INTO goj_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","अरु यो बोलीखे ओने अपना हात अरु अपनी हतेली उनखे दिखायो तब सेवक प्रभु खे देखीखे खुश हुया. ");
INSERT INTO goj_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","यीशु ने फिर उनसे बोल्यो, “तुमखे शांती मीले. जसो बाप ने मेखे भेज्यो हइ, वसो मी भी तुमखे भेजुस हइ.” ");
INSERT INTO goj_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","यो बोलीखे ओने उन पर फूक्यो अरु उनसे बोल्यो, “पवित्र आत्मा ले. ");
INSERT INTO goj_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","जिन को पाप तुम माफी करणु वे उनका लिये माफ कर्या गया हइ. जिन खे तुम रख्ये वे रख्या गया हइ.” ");
INSERT INTO goj_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","पर बारा जन मे से एक इन्सान मंनजे थोमा जो दिदिमुस बोलस हइ, जब यीशु आयो ते उनखे साथ नी थो. ");
INSERT INTO goj_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","जब अरु सेवक ओकासे बोलन लग्या, “हमने प्रभु खे देख्यो हइ,” तब ओने उनसे बोल्यो, “जब तक मी ओका हाथहोन मे खीला को छेद नी देखी लूका अरु खीला का छेदहोन मे अपनी उगली नी डाली लूका तब तक मी विश्वास नी कर्यु.” ");
INSERT INTO goj_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","आठ दिन का बाद ओका सेवक फिर घर का अंदर था, अरु थोमा उनका साथ थो, अरु दरवाजो बन्द था, तब यीशु ने अयखे अरु बीच मे खडो हुइखे बोल्यो, “तुम खे शांती मीले.” ");
INSERT INTO goj_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","तब ओने थोमा से बोल्यो, “अपनी उगली ह्या लैइखे मरा हाथहोन खे देख अरु अपनो हात लैइखे मरा हतेली मे डाल अरु अविश्वासी नी पर विश्वासी होनु” ");
INSERT INTO goj_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","यो सुन्यो थोमा ने जवाब दियो, “हे मरा प्रभु, हे मरा परमेश्‍वर!” ");
INSERT INTO goj_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","यीशु ने ओकासे बोल्यो, “तोने तो मरो विश्वास कर्यो हइ? धन्य हइ वे जेने बिन देख्यो विश्वास कर्यो.” ");
INSERT INTO goj_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","यीशु ने अरु भी भोत चिन्ह सेवक होन का सामने दिखायो, जो या किताब मे लिख्यो नी गया. ");
INSERT INTO goj_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","पर ये येका लिए लिख्यो गयो हइ, कि तुम विश्वास करणु, कि यीशु मे परमेश्वर को बेटो मसीह हइ अरु विश्वास करीखे ओका नाम से जिवन पाये. ");
INSERT INTO goj_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","या बातहोन का बाद यीशु ने अपना आप खे तिबिरियुस झील का किनारा सेवक होन पर प्रगट कर्ये अरु या रीति से प्रगट कर्यो. ");
INSERT INTO goj_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","शमौन पतरस अरु थोमा जो दिदिमुस बोलस हइ, अरु गलील का काना नगर का नतनएल अरु जब्दी को बेटो, अरु ओका सेवक होन मे से दो अरु जन जमा था. ");
INSERT INTO goj_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","शमौन पतरस ने उनसे बोल्यो, “मी मछ्छी पकडन जास हइ.” उनने ओकासे बोल्यो, “हम भी तरा साथ चलस हइ.” येका लिए वे नीकलीखे डोंगा पर चड्या, पर उ रात कुछ नी पकड्यो. ");
INSERT INTO goj_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","फजर होते ही यीशु किनार पर खडो हुयो. फिर भी सेवक होन ने नी पहचान्यो कि यो यीशु हइ. ");
INSERT INTO goj_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","तब यीशु ने उनसे बोल्यो, “हे बच्चाहोन, तुम्हारा पास कुछ खान खे हइ?” उनने जवाब दियो, “नी.” ");
INSERT INTO goj_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","ओने उनसे बोल्यो, “डोंगा की दाहिनी तरफ जाल डाल, ते पाये.” तब उनने जाल डाली, अरु अब मच्छीहोन का कारण जाल खीच नी सक्या. ");
INSERT INTO goj_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","येका लिए वा सेवक ने जोका से यीशु प्रेम रकतो थो पतरस से बोल्यो, “यो तो प्रभु हइ” शमौन पतरस ने यो सुनीखे कि प्रभु हइ, कमर मे कपडा खे कसी लियो, क्युकी उ बिना कपडा को थो, अरु झील मे कूद पड्यो. ");
INSERT INTO goj_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","पर अरु सेवक होन डोंगा पर मच्छीहोन से भरी हुइ जाल खीचते हुयो आयो का क्युकी वे किनार से जमीन जादा दूर नी कि कोय दो सौ हात पर थो. ");
INSERT INTO goj_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","जब किनारा पर जमीन पर उतर्या, ते उनने कोयला की आग का अरु ओका पर मच्छी रखी हुइ, अरु रोटी देखी. ");
INSERT INTO goj_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","यीशु ने उनसे बोल्यो, “जो मच्छीहोन तुम ने अभी पकडी हइ, उनमे से कुछ ला.” ");
INSERT INTO goj_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","शमौन पतरस ने डोंगा पर चडीखे एक सौ त्रिरेपन बडी मच्छीहोन से भर्यो हुयो जाल किनारा अरु जमीन पर खीच्यो, अरु इत्ती मच्छीहोन होना पर भी जाल नी फट्यो. ");
INSERT INTO goj_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","यीशु ने उनसे बोल्यो, “आ खानो या.” अरु सेवक होन मे से कोय खे हिम्मत नी हुयो, कि ओकासे पूछे, “तू कोन हइ?” क्युकी वे जानता था कि यो प्रभु हइ. ");
INSERT INTO goj_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","यीशु आयो, अरु रोटी लीखे उनने दी अरु ओसो मे मच्छी भी. ");
INSERT INTO goj_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","या तीसरी बार हइ, कि यीशु ने मऱ्या हुया मे से जिन्दो उठना का बाद सेवक होन खे दर्शन दियो. ");
INSERT INTO goj_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","खानो खाना का बाद यीशु ने शमौन पतरस से बोल्यो, “हे शमौन, यहून्ना को बेटा, खे तू इनसे बडीखे मरासे प्रेम रखस हइ?” ओने ओकासे बोल्यो, “हव प्रभु. तू तो जानस हइ, कि मी तरा से प्रिती रखुस हइ.” ओने ओकासे बोल्यो, “मरा मेडाहोन खे चरा.” ");
INSERT INTO goj_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","ओने फिर दूसरी बार ओकासे बोल्यो, “हे शमौन यहून्ना को बेटा खे तू मरासे प्रेम रखस हइ?” ओने उनसे बोल्यो, “हव, प्रभु तू जानस हइ, कि मी तरा से प्रिती रखुस हइ.” ओने ओकासे बोल्यो, “मरा मेडाहोन की रखवाली कर.” ");
INSERT INTO goj_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","ओने तीसरी बार ओकासे बोल्यो, “हे शमौन, यहून्ना को बेटा खे तू मरासे प्रिती रखस हइ?” पतरस उदास हुयो, कि ओने ओखे तीसरी बार असो बोल्यो, “तू मरासे प्रेम रखस हइ?” अरु ओकासे बोल्यो, “हे प्रभु तू तो सब कुछ जानस हइ तू यो जानस हइ कि मी तरा से प्रिती रखुस हइ” यीशु ने ओकासे बोल्यो, “मरा मेडाहोन खे चरा. ");
INSERT INTO goj_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","मी तरा से सच्ची-सच्ची बोलुस हइ, जब तू जवान थो, ते अपनी कमर बाधीखे झा चाहतो थो, व्हा फिरतो थो. पर जब तू बूढ्ढो हुये ते अपना हात लम्बा कर्येका अरु दूसरो तरी कमर बाधीखे झा तू नी चाह्ये व्हा तोखे ली जाये.” ");
INSERT INTO goj_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","ओने या बातहोन से दर्शायो कि पतरस कसो मरना से परमेश्वर की महिमा कर्ये. अरु यो बोलीखे ओकासे बोल्यो, “मरा पीछे अय जा.” ");
INSERT INTO goj_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","पतरस ने फिरीखे उ सेवक खे पीछे आते देख्यो, जोका से यीशु प्रेम रखेतो थो, अरु जो ने खाना का टेम ओकी छाती का तरफ झुकीखे पूछ्यो “हे प्रभु, तरो पकडनआलो कोन हइ?” ");
INSERT INTO goj_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","ओखे देखीखे पतरस ने यीशु से बोल्यो, “हे प्रभु, येको का हाल हुये?” ");
INSERT INTO goj_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","यीशु ने ओकासे बोल्यो, “अगर मी चाहु कि उ मरा आना तक ठैर्यो र्‍हिये ते तोखे? तू मरा पीछे अय जा.” ");
INSERT INTO goj_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","येका लिए भैइहोन मे या बात फैली गइ, कि उ चेलो नी मर्ये. ते भी यीशु ने ओकासे यो नी बोल्यो, कि यो नी मर्येका पर यो कि “अगर मी चाहु कि यो मरा आना तक ठैर्यो र्‍हिये ते तोखे येका से का?” ");
INSERT INTO goj_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","यो उ चेलो हइ, जो या बातहोन की गवइ देस हइ अरु जो ने या बातहोन खे लिख्यो हइ अरु हम जानस हइ, कि ओकी गवइ सच्ची ची हइ. ");
INSERT INTO goj_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","अरु भी भोत सा काम हइ, जो यीशु ने कर्या. अगर वे एक-एक करीखे लिख्या जास, ते मी समझयुस हइ, कि किताबहोन जो लिखी जास वे जगत मे भी नी समाती.");
INSERT INTO goj_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","प्रिय थियुफिलुस, मेने पयली किताब वे सब बात का बारे मे लिखी जो यीशु सुरवात से करतो अरु सिखातो र्‍हियो. ");
INSERT INTO goj_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","उ दिन तक जब तक उन प्रेरितहोन खे जेने उनके चुन्यो थो पवित्र आत्मा का वजेसे आज्ञा दि, उपर उठायो नी गयो. ");
INSERT INTO goj_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","ओने दुख उठाना का बाद भोत सा पक्को प्रमाणहोन से अपना आप खे उनने जिन्दो दिखायो, अरु चालीस दिन तक उ उनने दिखायो देता र्‍हियो, अरु परमेश्वर का राज्य की बात करतो र्‍हियो. ");
INSERT INTO goj_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","अरु उनसे मीलिखे उनने आज्ञा दी, “यरुशलेम का नी छोडनु, परम बाप की वा प्रतीज्ञा खे पूरो होन की रस्ता देखतो र्‍हियो, जेकी चर्चा तुम मरा से सुन चुक्या हइ. ");
INSERT INTO goj_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","क्युकि यहून्ना ने ते पानी मे बपतिस्मा दियो हइ पन थोडा दिन का बाद तुम पवित्र आत्मा से बपतिस्मा पाये.” ");
INSERT INTO goj_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","आखरी उनने इखठ्ठा हुइखे ओकासे बोल्यो, “हे प्रभु का तू यो टेम इस्राएल को राज्य फेरी दिये?” ");
INSERT INTO goj_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","ओने उनसे बोल्यो, उ टेमहोन या कालहोन खे जाननो, जेका बाप ने अपना ही अधिकार मे रख्यो हइ, तुम्हारो काम नी. ");
INSERT INTO goj_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","पन जब पवित्र आत्मा तुम पर आये तब तुम सामर्थ्य पाये. अरु यरुशलेम अरु पुरा यहूदीया अरु सामरिया मे अरु पृथ्वी का आखरी तक मरा गवा हुये. ");
INSERT INTO goj_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","यो बोलीखे उ उनका देखते उपर उठै लियो गयो, अरु वु बद्दल ने ओखे उनकी आखहोन से लुकै लियो. ");
INSERT INTO goj_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","ओका जाते टेम जब उ बद्दल का तरफ ताकी र्‍हो थो, ते देखनु दो अदमी सफेद कपडा पेन्या हुया उनका पास अय खडो हुया. ");
INSERT INTO goj_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","अरु उनसे बोल्यो, “हे गलीली इन्सानहोन, तुम क्यु खडा बद्दल का तरफ देखी रा हइ? योइ यीशु जो तुम्हारा पास से स्वर्ग पर उठै लियो गयो हइ, जो रीति से तुम ने ओखे स्वर्ग, जाता देख्यो हइ वैइ रीति से उ फिर आये.” ");
INSERT INTO goj_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","तब वे जैतुन नाम की टेकडी पर से जो यरुशलेम का पास एक अराम का दिन का दूरी पर हइ यरुशलेम खे लौट्या. ");
INSERT INTO goj_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","जब वे वहा पहुच्या ते वा अटारी पर गया, जहा पतरस अरु यहून्ना अरु याकूब अरु अन्द्रियास अरु फिलिप्पुस अरु थोमा अरु बरतुल्मै अरु मत्ती अरु हलफइस को बेटो याकूब अरु शमौन जोलोतेस अरु याकूब को बेटो यहूदा र्‍हेतो थो. ");
INSERT INTO goj_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","ये सब बयहोन अरु यीशु की माय मरियम अरु ओका भैइहोन का साथ एक चित हुइ खे प्रार्थना मे लग्या र्‍हिया. ");
INSERT INTO goj_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","अरु एय दिनहोन मे पतरस भैइ भैइन का बिच मे जो एक सौ बीस इन्सान का नजिक पास था, खडा हुइ बोलन लग्यो. ");
INSERT INTO goj_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","हे भैइहोन जरुरी थो कि पवित्रशास्त्र को उ लेख पूरो हुये जो पवित्र आत्मा मे दाउद का मुडा से यहूदा का बारे मे जो यीशु खे पकडन आलो को अगुवा था, पैयले से बोल्यो थो. ");
INSERT INTO goj_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","क्युकि उ तो हम मे गिन्यो गयो, अरु या सेवा मे हिस्सेदार हुयो. ");
INSERT INTO goj_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","ओने अधर्म की कमइ से एक खेत मोल लियो, अरु माथा का बल गिर्यो अरु ओको पेट फटी गयो अरु ओकी सब आतडीहोन नीकली पडी. ");
INSERT INTO goj_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","अरु या बात खे यरुशलेम का सब र्‍हेनआला जानी गया, ह्या तक कि उ खेत को नाम उनकी भाषा मे हकलदमा मंनजे खुन को खेत पडी गयो. ");
INSERT INTO goj_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","क्युकी भजन संहिता मे लिख्यो हइ, ओको घर उजडी जाये अरु ओमे कोय नी बस्ये अरु ओको पद कोय दूसरो लि ले. ");
INSERT INTO goj_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","येकालिये जोत्ता दिन तक प्रभु यीशु हमारा साथ आता जाता र्‍हिये मंनजे यहून्ना को बपतिस्मा से लिखे ओका हमारा पास से उठायो जाना तक जो दुन्या बराबर हमारा साथ र्‍हिये. ");
INSERT INTO goj_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","यहून्ना अच्छो हइ कि उनमे से एक इन्सान हमारा साथ यीशु खे जिन्दो उठन को गवा हुइ जाये. ");
INSERT INTO goj_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","तब उनने दोय खे खडा कर्या, एक यूसुफ खे जो बरसब्बास बोलस हइ जोको उपनाम यूसतुस हइ, दूसरो मत्तियाह के. ");
INSERT INTO goj_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","अरु या प्रार्थना करी “हे प्रभु, तु जो सब को मन जानस हइ, यो प्रकट कर कि ये दो मे से तोने को खे चुन्यो हइ. ");
INSERT INTO goj_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","कि उ या सेवक अरु प्रेरिताइ को पद ले जेखे यहूदा छोडीखे अपना जगा खे चली गयो.” ");
INSERT INTO goj_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","तब उनने उनका बारे मे चिट्ठिहोन डालीखे अरु चिट्ठी मत्तियाह का नाम पर नीकली. आखरी उ उन ग्यारा प्रेरितहोन का साथ गिन्यो गयो. ");
INSERT INTO goj_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","जब पिन्तुकुस्त को दिन आयो, मंनजे ते वे सब एक जगा जमा था. ");
INSERT INTO goj_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","अचानक बद्दल से बडी आधी को जसी संनसनाहट को बोल हुयो, अरु ओका से पूरो घर जहा वे बठ्या था गुजी गयो. ");
INSERT INTO goj_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","अरु उनने अंगार की सी जीभ फुटती हुइ दिखइ दि अरु उनमे से हर एक पर अय ठैरी. ");
INSERT INTO goj_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","वे सब पवित्र आत्मा से भरी गया, अरु जो प्रकार आत्मा ने उनने खे बोलन की सामर्थ्य दी, वे अलग अलग भाषा बोलन लग्या. ");
INSERT INTO goj_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","बद्दल का नीचे की हर एक जात मे से भक्त यहूदीया यरुशलेम मे र्‍हि रा था. ");
INSERT INTO goj_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","जब यो अवाज हुयो ते गर्दी हुय गइ अरु इन्सानहोन चकित हुइ गया क्युकि हर एक खे योइ सुनइ देतो थो कि ये मरा भाषा मे बोली र्‍हा हइ. ");
INSERT INTO goj_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","वे सब चकित अरु अचम्भित हुइ खे बोलन लग्या, देखनु, ये जो बोली र्‍हा हइ सब गलीली नी. ");
INSERT INTO goj_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","ते फिर क्यु हम से हर एक अपनी अपनी जन्म भूय कि भाषा मे उनकी सुनस हइ. ");
INSERT INTO goj_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","हम जो अरु मेदी अरु एलामी अरु मेसोपोटामीया अरु यहूदीया अरु कप्पदुकिया अरु पुन्तुस अरु आसिया, ");
INSERT INTO goj_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","अरु फ्रुगिया अरु पंफूलिया अरु मीस्र अरु लीबिया देश जो कुरेने का आस पास हइ, या सब देशहोन का र्‍हेनआला अरु रोमी प्रवासी. ");
INSERT INTO goj_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","मंनजे यहूदीया अरु यहूदीया मत धारण करणआला, क्रेती अरु भी हइ, पन अपनी अपनी भाषा मे उनसे परमेश्वर का बडा बडा काम होन की चर्चा सुनास हइ. ");
INSERT INTO goj_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","अरु वे सब चकित हुया अरु घबर्ये का एक दूसरा से बोलन लग्या, “यो का हुइ र्‍हो हइ?” ");
INSERT INTO goj_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","पन दूसराहोन ने मजाक करी खे बोल्यो, वे तो पीखे नशा मे चूर हइ. ");
INSERT INTO goj_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","जब पतरस वे ग्यारा का साथ खडो हुयो अरु उचा अवाज से बोलन लग्यो, हे यहूदीयाहोन अरु हे यरुशलेम का सब र्‍हेनआलाहोन, यो जानी लेकी अरु न लगैइ मरी बातहोन सुननु. ");
INSERT INTO goj_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","जसो तुम समझी र्‍हा हइ, ये दुन्या नशा मे नी हइ, क्युकि अभी तो दुपार ही दिन चड्यो हइ. ");
INSERT INTO goj_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","पन या वा बात हइ, जो योएल भविष्यव्दक्ता का वजेसे बोली गइ हइ. ");
INSERT INTO goj_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","परमेश्वर बोलस हइ, कि आखरी का दिनहोन मे असो हुये कि मी अपनी आत्मा सब इन्सानहोन पर दिह्यु अरु तुम्हारो बेटो अरु तुम्हारी बेटीहोन भविष्यव्दाणी कर्ये अरु तुम्हारा जवान दर्शन देख्ये अरु तुम्हारा बापदादा दृष्‍टान्‍त देख्ये. ");
INSERT INTO goj_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","क्युकी मी अपना दासहोन अरु अपनी दासीहोन पर भी उन दिनहोन मे अपना आत्मा मे से दिह्यु अरु वे भविष्यव्दाणी कर्ये. ");
INSERT INTO goj_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","अरु मी उपर बद्दल मे अ‍दभुत काम अरु नीचे धरती पर चिन्ह मंनजे खुन अरु आंग अरु धुवा को बद्दल दिखायु. ");
INSERT INTO goj_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","प्रभु को महान अरु तेजस्वी दिन का आना से पैयले सुरज अधारो अरु चाद खुन सो हुइ जाये. ");
INSERT INTO goj_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","अरु जो कोय प्रभु का नाम लिये उ उध्दार पाये. ");
INSERT INTO goj_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","हे इस्त्राएलिहोन, या बातहोन सुननु यीशु नासरी एक इन्सान थो जोको परमेश्वर का तरफ से होन को प्रमान उन सामर्थ काम होन अरु आश्चर्य का काम होन अरु चिन्ह से प्रगट हइ, जो परमेश्वर ने तुम्हारा बीच ओका वजेसे कर दिखायो जेखे तुम खुद ही जानस हइ. ");
INSERT INTO goj_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","उ यीशु खे जो परमेश्वर की ठैर्यइ हुइ योझना अरु पूर्व ज्ञान का जसो पकड्यो गयो, तुम ने अधर्मी होन का हाथ से क्रुस पर चड्यै खे मारी डाल्यो. ");
INSERT INTO goj_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","पन ओका परमेश्वर ने मरना को बन्धनहोन से छुड्यखे जिन्दो क्युकि यो अनहोनो थो कि उ ओका कब्जा मे र्‍हेस. ");
INSERT INTO goj_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","क्युकि दाउद ओका बारे मे बोलस हइ मी प्रभु, सर्वदा अपना सामने देखतो र्‍हियो क्युकि उ मरा जवना तरफ हइ, ताकि मी डगमग नी होयु. ");
INSERT INTO goj_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","यो करण मरो मन आनन्दित हुयो, अरु मरी जीभ मगन हुइ क्युकी मरो आंग भी आस मे बन्यो र्‍हिये. ");
INSERT INTO goj_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","क्युकि तू मरो जानहोन खे अधोलोक मे नी छोड्यु अरु नी अपना पवित्र झन, सडन ही दिये. ");
INSERT INTO goj_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","तो ने मेखे जिवन को मार्ग बतायो हइ तु मेखे अपनो दर्शन का वजेसे आनन्द से भर दिये. ");
INSERT INTO goj_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","हे भैइहोन, मी हमारा पृर्वज दाउद का बारे मे तुम से हिम्मत का साथ बोली सकुस हइ कि उ तो मरी गयो अरु गाड्यो भी गयो अरु ओकी मरगट आज तक हमारो विध्दमान हइ. ");
INSERT INTO goj_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","उ भविष्यव्दक्ता थो, उ जानतो थो कि परमेश्वर ने मरा से कसम खैइ हइ कि मी तरा बश मे से एक इन्सान का जसी राजगद्दी पर बठाड्यु. ");
INSERT INTO goj_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","ओने होन आली बात खे पैयले ही से देखी खे मसीह का जिन्दो उठना का बारे मे भविष्यव्दाणी करी कि नी ते ओको जान अधोलोक मे छोड्यो गयो अरु नी ओको आंग पायो. ");
INSERT INTO goj_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","यो यीशु, परमेश्वर ने जिन्दो, जेको हम सब गवा हइ. ");
INSERT INTO goj_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","यो प्रकार परमेश्वर का जवना हाथ से अच्छो पद परइ खे अरु बाप से उ पवित्र आत्मा मील्हे करी जोकी प्रतीज्ञा करी गइ थी कि ओने यो पलटय दियो हइ जो तुम देखस अरु सुनस हइ. ");
INSERT INTO goj_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","क्युकि दाउद स्वर्ग पर नी चड्यो; पन उ खुद बोलस हइ, प्रभु ने मरा प्रभु से बोल्यो, मरा जवना बठ. ");
INSERT INTO goj_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","जब तक कि मी तरा दुशमन होन खे तरा पाय नीचे की चौकी नी कर दियु. ");
INSERT INTO goj_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","आखरी अब इस्राएल का पुरा घराना नीश्चित रुप से जानी ले कि परमेश्वर ने उ यीशु खे जेखे तुम ने क्रुस पर चडायो प्रभु भी ठैरायो अरु मसीह भी. ");
INSERT INTO goj_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","तब सुननआला का दिल मे छेद हुइ गोका अरु वे पतरस अरु कुछ प्रेरितहोन से पुछन लग्या, “हे भैइहोन अरु बहीनहोन हम का करणु?” ");
INSERT INTO goj_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","पतरस ने उनसे बोल्यो मन फिरानु, अरु तुम मे से हर एक अपना अपना पापहोन कि माफ का लिये यीशु मसीह का नाम से बपतिस्मा लेनु; ते तुम पवित्र आत्मा को दान पाये. ");
INSERT INTO goj_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","क्युकि यो प्रतीज्ञा तुम, अरु तुम्हारी सन्तानहोन, अरु उन सब दूर का दुन्याहोन का लिये भी हइ जिनको प्रभु हमारो परमेश्वर अपना पास बुलाये. ");
INSERT INTO goj_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","पतरस ने भोत अरु बातहोन से भी गवइ दि दिखे समझायो कि अपना खुद खे या तेडी जात से बचानु. ");
INSERT INTO goj_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","आखरी जेने ओको वचन ग्रहन कर्यो उनने मन से बपतिस्मा लियो. अरु उ दिन तीन हजार इन्सानहोन का नजीकपास उनमे मीली गया. ");
INSERT INTO goj_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","अरु वे प्रेरितहोन से शिक्षा पान अरु संगत रखन को अरु रोटी तोडनो अरु प्रार्थना करणा मे लौलीन र्‍हिया. ");
INSERT INTO goj_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","अरु सब दुन्या का मन पर डर छय गयो, अरु खुब अदभुत काम अरु चिन्ह प्रेरितहोन का वजेसे प्रगट होता था. ");
INSERT INTO goj_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","अरु सब विश्वास करणआला जमा र्‍हेता था, अरु उनकी सब चिजहोन हिस्सा मे थी. ");
INSERT INTO goj_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","वे अपनी अपनी सम्पत्ति अरु सामन बेची खे जसी जोकी जरुरत होती थी बाट दिया करता था. ");
INSERT INTO goj_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","वे हरदिन एक मन हुइखे मन्‍दिर मे जमा होता था, अरु घर घर मे रोटी तोडता हुया आनन्द अरु मन की सीधाइ से भोजन कर्या करता था. ");
INSERT INTO goj_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","अरु परमेश्वर की स्तुती करता था, अरु सब दुन्या उनसे खुश था अरु जो उध्दार पाता था.उनको प्रभु हरदिन उनमे मुल्य देतो थो. ");
INSERT INTO goj_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","एक दिन पतरस अरु यहून्ना तीसरा पार प्रार्थना का टेम मे मन्‍दिर मे जै र्‍हा था. ");
INSERT INTO goj_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","अरु दुन्या एक जन्म का लगडा खे लै र्‍हा था जेखे वे हरदिन मन्‍दिर का उ दरवाजा पर जो सुन्दर बोलस हइ बठै देतो थो कि उ मन्‍दिर मे जानआला से भीक माग्ये. ");
INSERT INTO goj_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","जब ओने पतरस अरु यहून्ना को मन्‍दिर मे जाते देख्यो ते ओने भीक मागी ");
INSERT INTO goj_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","पतरस ने यहून्ना का साथ ओका तरफ ध्यान से देखीखे बोल्यो, हमारा तरफ देख. ");
INSERT INTO goj_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","आखरी उ उनसे कुछ पान की आस रखता हुये उनकी तरफ ताकन लग्या. ");
INSERT INTO goj_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","तब पतरस ने बोल्यो चादी अरु सोन्नो ते मरा पास हइ नीका पन जो मरा पास हइ उ तोखे देस हइ. यीशु मसीह नासरी का नाम से चल फिर. ");
INSERT INTO goj_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","अरु ओने ओको जवनो हाथ पकडी खे ओखे उठायो. अरु जल्दी ओका पायहोन अरु घुटना मे बल अय गयो. ");
INSERT INTO goj_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","उ कुदिखे खडो हुइ गयो अरु चलन फिरन लग्यो अरु चलता, अरु कूदते, अरु परमेश्वर की स्तुती करता हुया उनका साथ मन्‍दिर मे गयो. ");
INSERT INTO goj_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","सब दुन्या ने ओखे चलता फिरता अरु परमेश्वर कि स्तुती करता देखीखे. ");
INSERT INTO goj_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ओखे पैछान लियो कि यो उ हइ जो मन्‍दिर को सुन्दर फाटक पर बठी खे भीक माग्या करतो थो. अरु वा घटना से जो ओका साथ हुइ थी वे भोत अचम्भित अरु चकित हुया. ");
INSERT INTO goj_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","जब उ पतरस अरु यहून्ना खे पकड्या हुया था, ते सब दुन्या भोत अच्मबो करता हुया ओका ओसरी मे जो सुलैमान को बोलस हइ ओका पास दौडी आया. ");
INSERT INTO goj_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","यो देखी खे पतरस ने दुन्या से बोल्यो, “हे इस्त्राएलिहोन खे तुम यो इन्सान पर क्यु अच्मबो करस हुइ कि अरु हमारी तरफ क्यु यो प्रकार देखी र्‍हा हइ कि मानो हम ही ने अपना सामर्थ्य या भक्ति से येखे चलना फिरना योग्य बनइ दियो.” ");
INSERT INTO goj_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","अब्राहम अरु इसहाक अरु याकूब को परमेश्वर हमारा बापदादाहोन को परमेश्वर ने अपना सेवक यीशु की महिमा की जेखे तुम ने पकड्यइ दियो, अरु जब पिलातुस ने ओखे छोड देन को बीचार कर्यो, तब तुम ने ओका सामने ओको इनकार कर्यो. ");
INSERT INTO goj_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","तुम ने उ पवित्र अरु धर्मी को इनकार कर्यो, अरु प्रार्थना करी कि एक हत्यारा, तुम्हारा लिये छोड दिया जाये. ");
INSERT INTO goj_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","अरु तुम ने जिवन को कर्ता खे मारी डाल्यो जो परमेश्वर ने मर्या हुया मे से जिन्दो. अरु या बात कि हम गवा हइ. ");
INSERT INTO goj_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","अरु ओका नाम ने उ विश्वास का वजेसे जो ओका नाम पर हइ, यो इन्सानखे जेखे तुम देखस हइ अरु जानस भी हइ सामर्थ दियो हइ. उ विश्वास ने जो ओका वजेसे हइ, येको तुम सब, सामने बिलकुल भलो अच्छो करी दियो हइ. ");
INSERT INTO goj_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","अब हे भैइहोन अरु बहीनहोन, मी जानुस हइ कि यो काम तुम ने अज्ञानता मे कर्यो, अरु वसो ही तुम्हारा सरदारहोन ने भी कर्यो. ");
INSERT INTO goj_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","पन जो बातहोन खे परमेश्वर ने सब भविष्यव्दक्ताहोन क मेडा से पैयले ही बत्यै दियो थो, कि ओको मसीह दुख उठायेका उनखे, ओने या रीति से पूरो कर्यो. ");
INSERT INTO goj_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","येका लियेका मन फिरानु अरु लौट आनू कि जोकासे का सामने से अराम का दिन आये. ");
INSERT INTO goj_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","अरु उ प्रभु यीशु खे भेज्ये जो तुम्हारा लिये पैयले हि से मसीह ठैरायो गयो हइ. ");
INSERT INTO goj_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","जरुरी हइ कि उ स्वर्ग मे उ टेम तक र्‍हिये जब तक कि उ सब बातहोन, सुधार नी करी ले जोकी बातचीत पुराना काल से परमेश्वर ने अपना पवित्र भविष्यव्दक्ताहोन का मेडा से करी हइ. ");
INSERT INTO goj_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","जसो कि मूसा ने बोल्यो, प्रभु परमेश्वर तुम्हारा भैइहोन अरु बहीनहोन मे से तुम्हारा लिये मरा जसो एक भविष्यव्दक्ता उठायेका जो कुछ उ तुम से बोल्येका ओकी सुन्नु. ");
INSERT INTO goj_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","पन हरेक इन्सान जो उ भविष्यव्दक्ता कि नी सुन्ये का दुन्या का मन मे से खत्म कर्यो जाये. ");
INSERT INTO goj_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","अरु शमूएल से लिखे ओका बाद आनआलो तक जोत्ता भविष्यव्दक्ता बोल्ये उन सब ने इन दिनहोन को सन्देश दियो हइ. ");
INSERT INTO goj_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","तुम भविष्यव्दक्ताहोन की सन्तान अरु वा वाचा को हिस्सेदार हुया, जो परमेश्वर ने तुम्हारा बापदादाहोन से बाधी, जब ओने अब्राहम से बोल्यो, तरा कुल का वजेसे पृथ्वी का पुरा घराना आशिर्वाद मील्ये. ");
INSERT INTO goj_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","परमेश्वर ने अपना सेवक खे उठैखे पैयले तुम्हारा पास भेज्येका कि तुम मे से हर एक खे ओकी बुराइहोन से फेरीखे आशिर्वाद देनु. ");
INSERT INTO goj_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","जब वे दुन्या से यो बोली र्‍हा था, ते याजक अरु मन्‍दिर को सरदार अरु सदूकि उन पर चड आया. ");
INSERT INTO goj_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","क्युकि वे भोत घुस्सा हुया कि वे इन्सानहोन खे सिखाता था अरु यीशु को उदाहरण दि दिखे मर्या हुया खे जिन्दो उठन को प्रचार करता था. ");
INSERT INTO goj_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","उनने उनखे पकडी खे दुसरा दिन तक हआलात मे रख्यो क्युकि संज्जा हुइ गइ थी. ");
INSERT INTO goj_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","पन वचन खे सुननआला मे से भोतझन ने विश्वास कर्यो, अरु उनकी गिनती पाच हजार का नजीकपास हुइ गइ. ");
INSERT INTO goj_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","दूसरा दिन असो हुयो कि उनका सरदार अरु बापदादाहोन अरु शास्त्री. ");
INSERT INTO goj_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","अरु महायाजक हन्ना अरु कैफा अरु यहून्ना अरु सिकन्दर अरु जोत्ता महायाजक का घराना का था, सब यरुशलेम मे जमा हुया. ");
INSERT INTO goj_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","वे उनका बीच मे खडा करीखे पूछन लग्या कि तुम ने यो काम कोका सामर्थ्य से अरु कोका नाम से कर्यो हइ. ");
INSERT INTO goj_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","तब पतरस ने पवित्र आत्मा पुरो पुरो हुइ, उनसे बोल्यो. ");
INSERT INTO goj_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","हे दुन्याहोन को सरदारहोन अरु बापदादाहोन को या दुर्बल इन्सान का साथ जो भलाइ करी गइ हइ, अगर आज हम से उनका बारे मे पूछ ताच करी जास हइ, कि उ कसो अच्छो हुयो. ");
INSERT INTO goj_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ते तुम सब इस्राएल अरु पुरा इस्त्राएली दुन्या जानी ले कि यीशु मसीह नासरी का नाम से जेखे तुम ने क्रुस पर चडायो अरु परमेश्वर ने मर्या हुया मे से जिन्दो कर्यो यो इन्सान तुम्हारा सामने भलो अच्छो हइ. ");
INSERT INTO goj_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","यो उ पत्थर हइ जेखे तुमने राजमिस्त्रीहोन ने तुच्छ जान्यो अरु उ कोना को सिरा को पत्थर हुइ गयो. ");
INSERT INTO goj_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","कोइ दुसरा का वजेसे उध्दार नी. क्युकि स्वर्ग का नीचे इन्सानहोन मे अरु कोइ दुसरो नाम नी दियो गयो जेका वजेसे हम उध्दार पर सक्ये. ");
INSERT INTO goj_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","जब उनने पतरस अरु यहून्ना को हिम्मत देख्यो अरु यो जान्यो कि यो अनाडी अरु साधारन इन्सान हइ ते अच्मबो कर्यो. फिर उनका पैछान्यो कि यो यीशु का साथ र्‍हियो हइ. ");
INSERT INTO goj_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","उ इन्सान खे जो अच्छो हुयो थो, उनका साथ खडो देखी खे वे विरोध मे कुछ नी बोली सक्या. ");
INSERT INTO goj_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","पन उनखे सभा का भैहिर जान कि आज्ञा दिखे वे आपस मे बिचार करण लग्या, ");
INSERT INTO goj_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","हम ये इन्सानहोन का साथ का कर्या? क्युकि यरुशलेम का सब र्‍हेनआला पर प्रगट हइ, कि इन का वजेसे एक प्रसिद्ध चिन्ह दिखायो गयो हइ, अरु हम उनको इनकार नी करी सक्ये. ");
INSERT INTO goj_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","पन येका लिये कि या बात दुन्या मे अरु जादा फैली नी जाये, हम उनका धमकाये, कि वे या नाम से फिर कोय इन्सान से बात नी करणु. ");
INSERT INTO goj_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","तब उनखे बुलायो अरु चेतावनी दिखे बोल्यो, यीशु का नाम से कुछ भी नी बोलनु अरु नी सिखानी. ");
INSERT INTO goj_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","पन पतरस अरु यहून्ना ने उनका जवाब दियो, तुम हि न्याय करण; का यो परमेश्वर का पास भलो हइ कि हम परमेश्वर कि बात से बडीखे तुम्हारी बात मान्ये. ");
INSERT INTO goj_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","क्युकि यो ते हम से हुइ नी सक्ये कि जो हम ने देख्यो अरु सुन्यो हइ, वे नी बोल्ये. ");
INSERT INTO goj_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","तब उनने उनका धमक्यै छोडी दियो, खे क्युकि दुन्या करण उनखे दण्ड देन को दावो नी मील्यो, येका लिये कि जो घटना हुइ थी ओ का कारन सब दुन्या परमेश्वर कि बडैइ करता था ");
INSERT INTO goj_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","उ इन्सान का जेका पर यो अच्छो करण को चिन्ह दिखायो गयो थो, चालीस साल से जादा उम्र को थो. ");
INSERT INTO goj_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","वे छुटीखे अपना साथीहोन का पास आया खे अरु जो प्रधान याजकहोन अरु बापदादाहोन ने उनसे बोल्यो थो, उनका सुन्य दियो. ");
INSERT INTO goj_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","यो सुनी, उनने एक चित्त हुइ, उचो बोल से परमेश्वर से बोल्यो हे स्वामी, तू उ हइ जेने स्वर्ग अरु जमीन अरु समुद्र अरु जो कुछ उनमे हइ बनायो. ");
INSERT INTO goj_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","तोने पवित्र आत्मा का वजेसे अपना सेवक हमारो बाप दाउद का मुडा से बोल्यो. गैरयहूदिहोन ने हुल्लड क्यु मचायो? अरु देश का दुन्या ने बेकार बातहोन सोची ");
INSERT INTO goj_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","प्रभु अरु ओका मसीह का विरोध मे पृथ्वी को राजाहोन खडा हुया, अरु शासक एक साथ जमा हुइ गया. ");
INSERT INTO goj_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","क्युकि सच्चीई तरा पवित्र सेवक यीशु का विरोध मे जेको तो ने अभिषेक कर्यो, हेरोदेस अरु पुन्तियुस पिलातुस भी गैरयहूदिहोन अरु इस्त्राएलिहोन का साथ या नगर मे जमा हुया. ");
INSERT INTO goj_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","कि जो कुछ पैयले से तरी सामर्थ्य अरु मती से ठैरायो थो उ करणु. ");
INSERT INTO goj_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","अब हे प्रभु, उनकी धमकिहोन खे देख. अरु अपना सेवकहोन को वरदान देनु कि तरो वचन बडा हिम्मत से सुनाये. ");
INSERT INTO goj_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","अच्छो करण का लिये तू अपनो हाथ बडा कि चिन्ह अरु अदभुत काम तरा पवित्र सेवक यीशु का नाम से कर्यो जाये. ");
INSERT INTO goj_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","जब वे प्रार्थना करी चुक्या, ते उ जगा जहा वे जमा था हली गया अरु वे सब पवित्र आत्मा से परीपूर्ण हुइ गया, अरु परमेश्वर को वचन हिम्मत से सुनाता र्‍हिये. ");
INSERT INTO goj_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","विश्वास करणआला कि मंडली एक चित्त अरु एक मन कि थी, ह्या तक कि कोइ भी अपनी सम्पत्ती अपनी नी करतो थो, पन सब कुछ हिस्सेदार मे थो. ");
INSERT INTO goj_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","प्रेरित बडो सामर्थ्य से प्रभु यीशु को जिन्दो उठस कि गवा देता र्‍हिये अरु उन सब पर बडो अनुग्रह थो. ");
INSERT INTO goj_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","उनमे कोय भी दरिद्र नी थो क्युकी जिन का पास जमीन या घर था वे उनखे बेची खे बिकी हुइ चिजहोन को दाम लाता, अरु ओका प्रेरितहोन का पायहोन पर रखता था. ");
INSERT INTO goj_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","अरु जसी जोकि जरुरत होती थी, ओका जसो हर एक खे बाटी दिया करता था. ");
INSERT INTO goj_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","यूसुफ नाम साइप्रस को एक लेवी थो जेको नाम प्रेरितहोन ने बरनबास मंनजे शांती को बेटो रख्यो थो. ");
INSERT INTO goj_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","ओकी कुछ जमीन थी जो खे ओने बेच्यो अरु दाम का रुप्या लिखे प्रेरितहोन को पायहोन पर रखी दियो. ");
INSERT INTO goj_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","हनन्याह नाम को एक इन्सान अरु ओकी लुगइ, सफीरा ने कुछ जमीन बेची ");
INSERT INTO goj_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","अरु ओको दाम मे से कुछ रखी छोडो. अरु या बात ओकी लुगइ भी जानती थी, अरु ओको एक भाग लैखे प्रेरितहोन का पायहोन का सामने रखी दियो. ");
INSERT INTO goj_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","पतरस ने बोल्यो, हे हनन्याह! सैतान ने तरा मन मे या बात क्यु डाली कि तु पवित्र आत्मा से झुठ बोल्ये, अरु जमीन का दाम मे से कुछ रखी छोड्यो. ");
INSERT INTO goj_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","जब तक उ तरा पास र्‍हिये, का तरी नी थी? अरु जब बिकी गइ ते का तरा कब्जा मे नी थी? तो ने या बात अपना मन मे क्यु बिचारी तू इन्सान से नी, पन परमेश्वर से झुठ बोल्यो हइ. ");
INSERT INTO goj_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","या बात सुनते ही हनन्याह गिरी पड्यो अरु जान छुड्यी दिये, अरु सब सुननआला पर बडो डर छै गयो. ");
INSERT INTO goj_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","फिर जवानहोन ने उठै खे ओकी अर्थी बनइ अरु भैइर ली जैखे गाड दियो. ");
INSERT INTO goj_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","नजीकपास तीन घंटा का बाद ओकी लुगइ जो कुछ हुयो थो नी जानीखे अंदर अय गइ. ");
INSERT INTO goj_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","तब पतरस ने ओकासे बोल्यो, मेखे बता तुम ने उ जमीन येत्ता ही मे बेची थी? ओने बोल्यो हा येत्ता ही मे. ");
INSERT INTO goj_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","पतरस ने ओकासे बोल्यो, या का बात हइ कि तुम दो ने प्रभु का आत्मा की परीक्षा का लिये येका कर्यो? तरा अदमी का गाडनआला दरवाजो ही पर खडा हइ अरु तोखे भी बाहेर लि जाये. ");
INSERT INTO goj_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","तब उ जल्दी ओका पायहोन पर गिरी पडि अरु जान छोडी दियो अरु जवानहोन ने अंदर अयखे ओखे मर्यो पय्यो अरु बाहेर लि जैखे ओका अदमी का पास गाडी दियो. ");
INSERT INTO goj_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","पुरी मंडली पर अरु या बातहोन खे सुननआला पर बडो डर छै गयो. ");
INSERT INTO goj_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","प्रेरितहोन का हाथहोन से भोत चिन्ह अरु अदभुत काम दुन्या का बीच मे दिखायो जाता था, अरु वे सब एक चित्त हुइखे सुलैमान का ओसरी मे जमा हुया करता था. ");
INSERT INTO goj_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","पन अरु मे से कोय खे यो हिम्मत नी होती थी कि उनमे जय मीले. तेभी दुन्या उनकी बडाइ करता था. ");
INSERT INTO goj_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","विश्वास करणआला भोत सा इन्सान अरु बय प्रभु की मंडली मे बडि संख्या मे मीलते र्‍हिये. ");
INSERT INTO goj_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","ह्या तक कि दुन्या बिमारहोन खे सडकहोन पर लैइ खे खटियाहोन अरु बिछानाहोन पर सोयो देता था कि जब पतरस आये, ते ओकी छाया ही उनमे से कोइ पर पडि जाये. ");
INSERT INTO goj_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","यरुशलेम का आस पास का नगर से भी भोत दुन्या बीमारहोन अरु बुरी आत्मा का सताया हुया खे लैइ लैइखे जमा होता था, अरु सब अच्छो करी दिया जाता था. ");
INSERT INTO goj_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","तब महायाजक अरु ओका सब साथी जो सदूकिहोन का पंथ का था, जलन से भरी उठ्यो. ");
INSERT INTO goj_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","अरु प्रेरितहोन खे पकडिखे बन्दिघर मे बन्द करी दियो. ");
INSERT INTO goj_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","पन रात खे प्रभु का एक स्वर्गदूत ने बन्दीगृह का दरवाजा खोली खे उनखे बाहेर लइखे बोल्यो. ");
INSERT INTO goj_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“जा मन्दिर मे खडा हुइ खे या जिवन की सब बातहोन दुन्या खे सुनानु.” ");
INSERT INTO goj_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","वे यो सुनीखे फजर होते ही मन्दिर मे जैखे उपदेश देन लग्या. तब महायाजक अरु ओका साथिहोन ने अयखे महासभा का अरु इस्त्राएलिहोन का सब बुजुरुखहोन खे जमा कर्यो, अरु बन्दीघर मे बुलाओ भेज्यो कि उनखे लाह्ये. ");
INSERT INTO goj_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","पन अधिकारीहोन ने वहा पहुची खे उनखे बन्दीगृह मे नी पय्यो, अरु पलटि खे संदेश दियो. ");
INSERT INTO goj_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","हम ने बन्दीघर खे बडि चौकसी से बन्द कर्यो हुयो, अरु राखनआलो खे बाहेर दरवाजाहोन पर खडा हुया पाया. पन जब खोल्यो ते अंदर कोइ नी मील्यो. ");
INSERT INTO goj_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","जब मन्दिर का सरदार अरु मुखियो याजकहोन ने या बातहोन सुनी ते उनका बारे मे भारी चिन्ता मे पडि गया कि उनको का हुयो. ");
INSERT INTO goj_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","इत्ता मे कोय ने अयखे उनखे बतायो कि देखनु जिन खे, “तुम ने बन्दीगृह मे बन्द रख्यो थो का वे मनुष्य मन्दिर मे खडा हुया दुन्या खे उपदेश दि र्‍हा हइ.” ");
INSERT INTO goj_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","जब सरदार प्‍यादाहोन का साथ जैखे उनखे लि आया, पन बलपूर्वक नी क्युकि वे दुन्या से डरता था कि हम पर पथराव नी करणु. ");
INSERT INTO goj_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","ओने उनखे लैइखे महासभा का सामने खडा करी दियो. तब महायाजक ने उनसे पूछ्यो. ");
INSERT INTO goj_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","का हम ने तुमखे जत्यै खे आज्ञा नी दी थी कि तुम यो नाम से उपदेश नी करणु? तेभी देखनु, तुम ने पुरा यरुशलेम खे अपना उपदेश से भरी दियो हइ अरु उ इन्सान को खुन हमारा गर्दन पर लानो चाहस हइ. ");
INSERT INTO goj_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","तब पतरस अरु दुसरा प्रेरितहोन ने जवाब दियो, इन्सान कि आज्ञा से बडिखे परमेश्वर कि आज्ञा को पालन करणु ही हमारो काम हइ ");
INSERT INTO goj_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","हमारा बापदादाहोन ने परमेश्वर ने यीशु खे जिन्दो, जोखे तुम ने क्रुस पर लटकै खे मारी डाल्यो थो. ");
INSERT INTO goj_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","ओ खे परमेश्वर ने प्रभु अरु उद्धारकर्ता ठैर्यखे , अपना जवना हाथ पर उचो करी दियो, कि उ इस्त्राएलिहोन खे मन फिराव की शक्ति अरु पापहोन की माफ प्रदान करणु. ");
INSERT INTO goj_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","हम या बात का गवा हइ अरु ओसो हि पवित्र आत्मा भी, जोखे परमेश्वर ने उनखे दियो हइ जो ओकी आज्ञा मानस हइ. ");
INSERT INTO goj_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","यो सुनीखे वे जली गया, अरु उनखे मारी डालनो चायो. ");
INSERT INTO goj_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","पन गमलीएल नाम को एक फरीसी ने जो व्यवस्थापक अरु सब दुन्या मे माननीय थो, कोरट मे खडा हुइखे प्रेरितहोन खे थोडि देर का लिये बाहेर करी देन की आज्ञा दी. ");
INSERT INTO goj_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","तब ओने बोल्यो, हे इस्त्राएलिहोन, तुम जो कुछ ये इन्सानहोन से करणो चाहस हइ सोची समझी खे करणु. ");
INSERT INTO goj_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","क्युकि यो दिनहोन से पैयले थियुदास यो बोलता हुये उठ्यो, कि मी भी कुछ हइ. अरु कोय चार सौ इन्सान ओका साथ हुइ लिया पन उ मार्यो गयो अरु जोत्ता दुन्या ओखे मानता था, सब तितर-बितर हुया अरु मीटि गया. ");
INSERT INTO goj_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","ओका बाद नाम लिखाइ का दिनहोन मे यहुदा गलीली उठ्यो अरु कुछ दुन्या अपना तरफ करी लिया. उ भी खत्म हुइ गया अरु जोत्ता दुन्या ओखे मानता था सब तितर बितर हुइ गया. ");
INSERT INTO goj_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","येकालिये अब मी तुम से बोलुस हइ इन इन्सानहोन से दुर ही र्‍हेनु अरु इन से कुछ काम नी रखनु. क्युकि अगर यो धर्म या काम इन्सानहोन कि तरफ से हुये तब ते मीटी जाये. ");
INSERT INTO goj_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","पन अगर परमेश्वर का तरफ से हइ, ते तुम उनखे कदापि मीटी नी सक्ये. कही असो नी हुये कि तुम परमेश्वर से भी लडनआला ठैर्ये, ");
INSERT INTO goj_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","तब उनने ओकी बात मानी ली. अरु प्रेरितहोन खे बुलैइ खे पिटवायो. अरु यो आदेश दिखे छोड दियो कि यीशु का नाम से फिर कोइ बात नी करणु. ");
INSERT INTO goj_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","वे या बात से खुश हुइखे महासभा का सामने से चली गया, कि हम ओका नाम का लिये अपमान होन का योग्य ठैर्ये. ");
INSERT INTO goj_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","वे हरदिन मन्दिर मे अरु घर मे उपदेश करण, अरु या बात को सुसमाचार सुनाना से कि यीशु हि मसीह हइ नी रुख्या. ");
INSERT INTO goj_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","उन दिनहोन मे जब चेलाहोन की गीनती बडन लगी, तब यूनानी भाषा बोलनआला इब्रानी भाषा बोलनआला पर कुरकुर करण लग्या कि हरदिन कि सेवकाइ मे हमारी विधवाहोन कि याद नी ली जाय. ");
INSERT INTO goj_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","तब उन बाराझन ने चेलाहोन की मन्डली खे अपना पास बुलैइ खे “बोल्यो यो ठीक नी कि हम परमेश्वर को वचन छोडी खे खान पिलान कि सेवा मे र्‍हिये. ");
INSERT INTO goj_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","येका लिये हे भैइहोन अरु भैइनहोन अपना मे से सात सुनाम इन्सानहोन, जो पवित्र आत्मा अरु बुध्दि से परिपूर्ण हइ, चुनी ले, कि हम उनका यो काम पर ठैर्य दे. ");
INSERT INTO goj_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","लेकीन हम तो प्रार्थना मे अरु वचन की सेवा मे लग्या र्‍हिये.” ");
INSERT INTO goj_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","या बात पुरी मंडली खे अच्छी लगी, अरु उनने स्तिफनुस नामको एक इन्सान को जो विश्वास अरु पवित्र आत्मा से परिपूर्ण थो, फिलिप्पुस, अरु पुरखुरुस, अरु नीकानोर अरु तीमोन, अरु परमीनास, अरु अन्ताकियावासी नीकुलास के जो यहूदीया मत मे अय गयो थो, चुनी लियो. ");
INSERT INTO goj_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","इन्हे प्रेरितहोन का सामने खडो कर्यो अरु उनने प्रार्थना करीखे उन पर हाथ रख्यो. ");
INSERT INTO goj_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","परमेश्वर को वचन फैलाता गयो अरु यरुशलेम मे चेलाहोन की गिनती भोत बडी गइ. अरु याजकहोन को बडो समाज यो मत खे माननआला हुइ गया. ");
INSERT INTO goj_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","स्तिफनुस अनुग्रह अरु सामर्थ्य से परिपूर्ण हुइ खे दुन्या मे बडा बडा अदभुत काम अरु चिन्ह दिखायो करतो थो. ");
INSERT INTO goj_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","तब उ आराधनालय मे से दासत्व - मुक्त की कैलाती थी, अरु कुरेनी अरु सिकन्दरिया अरु किलिकिया अरु आसिया का दुन्या मे से कइ एक उठैखे स्तिफनुस से वाद विवाद करण लग्या. ");
INSERT INTO goj_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","पन उ ज्ञान अरु उ आत्मा को जोकासे उ बातहोन करतो थो, वे सामना नी करी सक्ये. ");
INSERT INTO goj_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","येका पर उनने कइ दुन्या खे उभार्यो जो बोलन लग्या, “हम ने येके मूसा अरु परमेश्वर का विरोध मे नीन्दा की बातहोन बोलता सुन्यो हइ.” ");
INSERT INTO goj_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","अरु दुन्या अरु बुजरुक अरु शास्त्रियहोन, भडकी खे चडी आया अरु ओके पकडी खे महासभा मे लि आया. ");
INSERT INTO goj_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","अरु झुठा गवा खडा कर्या जेने बोल्यो. “यो इन्सान या,” पवित्र जगा अरु व्यवस्था का विरोध मे “बोलनु नी छोड्यो. ");
INSERT INTO goj_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","क्युकि हम ने ओका यो बोलता सुन्यो हइ कि योइ यीशु नासरी या जगा खे झाकि दियो, अरु वा रीतिहोन खे बदली डाल्यो जो मूसा ने हम खे दि दियोस हइ.” ");
INSERT INTO goj_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","तब सब दुन्या ने जो सभा मे बैठ्या था ओ पर नजर गडाइ ते ओको मुडो स्वर्गदूत को जसो दिख्यो. ");
INSERT INTO goj_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","तब महायाजक ने बोल्यो, का या बातहोन सच्ची हइ? ");
INSERT INTO goj_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","स्तिफनुस ने बोल्यो हे भैइहोन अरु बापहोन सुन्नु. हमारो बाप अब्राहम हारान मे बसना से पैयले जब मेसोपोटामीया मे थो. तेजमय परमेश्वर ने ओखे दर्शन दियो. ");
INSERT INTO goj_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","अरु ओकसे बोल्यो तू अपना देस अरु अपना कुटुम्ब से नीकलीखे उ देश मे जा, जेखे मेने तोखे दिखायो. ");
INSERT INTO goj_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","तब उ कसदियहोन का देस से नीकलीखे हारान परमेश्वर ने ओखे वहा से या देस मे लैखे बसायो जेमे अब तुम बसस हय. ");
INSERT INTO goj_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","अरु ओखे कुछ मीरास क्युकी पाय रखना भर की भी ओमे जगा नी दी, पन प्रतीज्ञा करी कि मी यो देस तरा अरु बाद तरा वंश का हाथ करी दियु. यध्दपी उ टेम मे ओका कोय बेटो भी नी थो. ");
INSERT INTO goj_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","अरु परमेश्वर ने यो बोल्यो, तरी सन्तान खे दुन्या दुसरा देस मे परदेशी हुये, अरु वे उनका सेवक बनाये अरु चार सौ साल तक दुख दिये. ");
INSERT INTO goj_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","फिर परमेश्वर ने बोल्यो, जो जात का वे दास हुये ओखे नी दण्ड दियु, अरु ओका बाद वे नीकलीखे या जगा मरी सेवा कर्ये. ");
INSERT INTO goj_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","अरु ओने ओकासे खतना कि वाचा बांधी. अरु यो देस मे इसहाक ओकासे पइदा हुयो अरु आठवा दिन ओको खतनो कर्यो गयो. अरु इसहाक से याकूब अरु याकूब से बारा कुलपति पइदा हुयो. ");
INSERT INTO goj_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","कुल पतिहोन ने यूसुफ से जलन करीखे ओखे मीस्र देस जानआला होन का हाथ बेच्यो. पन परमेश्वर ओका साथ थो. ");
INSERT INTO goj_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","अरु ओखे ओका सब क्लेशहोन से छुड्य खे मीस्र को राजा फिरौन की नजर मे अनुग्रह अरु बुध्दि प्रदान करी, अरु ओने ओखे मीस्र पर अरु अपना पुरा घर पर हाकिम नीयुक्त कर्यो. ");
INSERT INTO goj_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","तब मीस्र अरु कनान का पुरा देस मे अकाल पड्यो. जोका से भारी क्लेश हुयो, अरु हमारा बापदादाहोन की अनाज नी मील्यो थो. ");
INSERT INTO goj_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","पन याकूब ने यो सुनीखे खे मीस्र मे अनाज हइ, हमारा बापदादाहोन खे पयली बार भेज्यो. ");
INSERT INTO goj_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","दूसरी बार यूसुफ ने खुद खे अपना भैइहोन पर प्रगट कर्यो अरु यूसुफ की जाति फिरौन खे मालूम हुइ गइ. ");
INSERT INTO goj_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","तब यूसुफ ने अपना बाप याकूब अरु अपना पुरा कुटुम्ब खे जो पचहत्तर इन्सान का मन था, बुलाओ भेज्यो. ");
INSERT INTO goj_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","तब याकूब मीस्र मे गयो. अरु वहा उ अरु हमारा बापदादा मरी गया. ");
INSERT INTO goj_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","उनको शव शकेम मे पहुच्ये जैखे ओखे मरगट मे रख्यो गयो, जेखे अब्राहम ने चादी दिखे हमोर की सन्तान से मोल लियो थो. ");
INSERT INTO goj_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","पन जब वा प्रतीज्ञा का पुरा होन का टेम मे पास आयो जो परमेश्वर ने अब्राहम से करी थी, ते मीस्र मे वे दुन्या बडि गया अरु भोत हुइ गया. ");
INSERT INTO goj_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","तब मीस्र मे दूसरो राजो हुयो जो यूसुफ खे नी जानतो थो. ");
INSERT INTO goj_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","ओने हमारी जाति से चलाकी करीखे हमारा बापदादाहोन का साथ ह्या तक बुरो व्यवहार कर्यो, कि उनने अपना बच्चाहोन खे फेकी देनो पड्यो कि वे जीन्दा नी र्‍हिया. ");
INSERT INTO goj_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","यो टेम मे मूसा पइदा हुयो. उ परमेश्वर की नजर मे भोत ही सुन्दर थो उ तीन महीना तक अपना बाप का घर मे पाल्यो गयो. ");
INSERT INTO goj_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","जब फेकी दियो गयो ते फिरौन की बेटी ने ओखे उठैइ लियो, अरु अपनो बेटो करीखे पाल्यो. ");
INSERT INTO goj_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","मूसा खे मीस्रिहोन की सब विध्या पडैइ गइ, अरु उ वचन अरु कर्म दो मे सामर्थी थो. ");
INSERT INTO goj_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","जब उ चालीस साल को हुयो ते ओका मन मे आयो कि मी अपना इस्त्राएली भैइहोन से भेट कर्यु. ");
INSERT INTO goj_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","ओने एक इन्सान पर अन्याय होते देखीखे ओखे बचायो, अरु मीस्रिहोन खे मारी खे सताया हुया खे बदलो लियो. ");
INSERT INTO goj_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","ओने सोच्यो कि ओका भैइहोन समझ्ये कि परमेश्वर ओका हाथहोन से उनको उध्दार कर्ये, पन उनने नी समझ्यो. ");
INSERT INTO goj_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","दूसरा दिन जब वे आपस मे लडि र्‍हा था ते उ वहा अय नीकल्यो. अरु यो बोलीखे उनने मेल करण का लिये समझायो, हे इन्सानहोन, तुम तो भैइहोन हइ, एक दूसरा पर क्यु अन्याय करस हइ? ");
INSERT INTO goj_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","पन जो अपना बाजुआला पर अन्याय करी र्‍हा था, ओने उनसे यो बोलीखे बाजुकरी दियो तोखे कोने हम पर डाॅकटर अरु न्याय रख्यो हइ? ");
INSERT INTO goj_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","का जो रीति से तो ने कल मीस्रिहोन खे मारी डाल्यो मेखे भी मारी डालनो चाहस हइ? ");
INSERT INTO goj_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","या बात सुनीखे मूसा भाग्यो अरु मीघान देस मे परदेशी हुइखे र्‍हेन लग्यो, अरु वहा ओका दो बेटा पइदा हुया. ");
INSERT INTO goj_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","जब पूरा चालीस साल बीती गया ते एक स्वर्गदूत ने सीनै टेकडी का जंगल मे ओखे जलनआली झाडि की अंगार मे दर्शन दियो. ");
INSERT INTO goj_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","मूसा यो दर्शन देखीखे अचंभ हुय गो, अरु जब देखन का लिये उ पास गयो, ते प्रभु को यो बोल हुयो. ");
INSERT INTO goj_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","मी तरा बापदादाहोन, अब्राहम, इसहाक अरु याकूब को परमेश्वर हइ, तब ते मूसा थर थरानो, ह्या तक कि ओखे देखन को हिम्मत नी र्‍हियो. ");
INSERT INTO goj_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","तब प्रभु ने ओकासे बोल्यो, अपना पायहोन से जुती उतारी ले, क्युकि जो जगा तु खडो हइ, वा पवित्र जमीन हइ. ");
INSERT INTO goj_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","मे ने सचमुच अपना दुन्या की जो मीस्र मे हय कि दुर्दशा खे देख्यो हइ अरु उनकी आह अरु उनको रोनो सुन्यो हइ. येकालिये उनने छुड्य लिये उतार्यो हइ. अब आ, मी तोखे मीस्र मे भेज्यू ");
INSERT INTO goj_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","जो मूसा खे उनने यो बोलीखे नाकार्यो थो तोखे कोइ ने हम पर हाकिम अरु न्याय ठैरायो हइ? ओ खे परमेश्वर ने हाकिम अरु छुडानआलो ठैर्यखे , उ स्वर्गदूत का वजेसे जेने ओखे झाडि मे दर्शन दियो थो, भेज्यो. ");
INSERT INTO goj_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","यो इन्सान मीस्र देस अरु लाल समुंदर अरु जंगल मे चालीस साल तक अदभुत काम अरु चिन्ह दिख्य देखीखे उनखे नीकाली लायो. ");
INSERT INTO goj_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","यो उ मूसा हइ, जेने इस्त्राएलिहोन से बोल्यो, परमेश्वर तुम्हारा भैइहोन मे से तुम्हारा लिये मरा जसो एक भविष्यव्दक्ता उठाये. ");
INSERT INTO goj_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","यो उ हइ, जेने जंगल मे मंडली का बीच उ स्वर्गदूत का साथ सीनै टेकडा पर ओकासे बातहोन करी अरु हमारा बापदादाहोन का साथ थो, ओ खे जिन्दो वचन मील्यो कि हम तक पहुचायो. ");
INSERT INTO goj_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","पन हमारा बापदादाहोन ने ओकी माननो नी चायो, क्युकी ओखे हटैखे अपनो मन मीस्र की तरफ फेर्यो. ");
INSERT INTO goj_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","अरु हारुन से बोल्यो, हमारा लिये असो देवतो बना जो हमारा आगे-आगे चल्ये. क्युकि यो मूसा जो हम खे मीस्र देस से नीकाली लायो, हम नी जाने ओखे का हुयो? ");
INSERT INTO goj_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","उ दिनहोन मे उनने एक बच्चो बनी खे ओकी मुरती का आगे बलि चड्यैइ, अरु अपना हाथहोन का कामहोन मे मगन होन लग्यो. ");
INSERT INTO goj_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","आखरी परमेश्वर ने मुडो मोडिखे उनखे छोडी दियो कि आकाश-गन खे पूज्ये, जसो भविष्य-व्दक्ताहोन की किताब मे लिख्यो हइ, हे इस्राएल का घराना, का तुम जंसगल मे चालीस साल तक जनवर कि बलि अरु अनाज बलि मेखे चडाता र्‍हिये. ");
INSERT INTO goj_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","तुम मोलेक का झोपडि अरु रिफान देवता का तारा का लिये फिरता था, मंनजे उन मूर्तीहोन खे जेने तुम ने प्रणाम करण का लिये बनायो थो. आखरी मे तुमखे बेबीलोन का पार ली जैइ खे बसायु. ");
INSERT INTO goj_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","गवा की झोपडि जंगल मे हमारा बापदादाहोन का बीच मे थी, जसो ओने ठैरायो जेने मूसा से बोल्यो. ");
INSERT INTO goj_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","ओखे झोपडि खे हमारा बापदादाहोन जुन्नो जमाना से परई खे यहोशू का साथ ह्या लि आया जो टेम मे कि उनने उन गैरयहूदीहोन पर अधिकार पायो जेने परमेश्वर ने हमारा बापदादाहोन का सामने से नीकाली दियो, अरु वा झोपडि दाउद का टेम मे तक र्‍हिये. ");
INSERT INTO goj_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","ओका पर परमेश्वर ने अनुग्रह कर्यो. आखरी ओने प्रार्थना करी कि उ याकूब को परमेश्वर का लिये जगा बनानु. ");
INSERT INTO goj_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","पन सुलैमान ने ओका लिये घर बनायो. ");
INSERT INTO goj_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","पन परम प्रधान हात का बनाया घरहोन मे नी र्‍हे, जसो कि भविष्यव्दक्ता ने बोल्यो ");
INSERT INTO goj_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","प्रभु बोलस हइ स्वर्ग मरी राजगद्दी अरु पृथ्वी मरा पाय का नीच्चे की पीडि हइ, मरा लिये तुम कोइ प्रकार को घर बनाये? अरु मरी अराम की कोन सी जगा हुये? ");
INSERT INTO goj_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","का ये सब चिजहोन मरा हाथ की बनइ नी? ");
INSERT INTO goj_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","हे हठेला, अरु मन अरु कान का खतनारहित दुन्या खे तुम हमेशा पवित्र आत्मा का विरोध करस हइ. जसो तुम्हारा बापदादाहोन करता था, ओसो ही तुम भी करस हइ. ");
INSERT INTO goj_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","भविष्य-व्दक्ताहोन मे से कोइ खे तुम्हारा बापदादाहोन ने नी सतायो? उनने उ धर्मी का आगमन का जुन्नो जमाना से सन्देश देनआला खे मारी डाल्यो. अरु अब तुम भी ओखे पकडानआला अरु मारी डालनाला हुये. ");
INSERT INTO goj_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","तुम ने स्वर्गदूत का वजेसे ठैराइ हुइ व्यवस्था खे पाइ, पन ओको पालन नी कर्यो. ");
INSERT INTO goj_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","या बात सुनीखे वे जली गया अरु ओका पर दात पीसन लग्या. ");
INSERT INTO goj_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","पन ओने पवित्र आत्मा से परिपूर्ण हुइखे स्वर्ग कि तरफ देख्यो अरु परमेश्वर की महिमा खे अरु यीशु खे परमेश्वर का जवना तरफ खडो हुयो देख्यो . ");
INSERT INTO goj_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","देखनु मी स्वर्ग खे खुल्यो हुयो, अरु इन्सान का बेटा खे परमेश्वर का जवना तरफ खडो हुयो देखुस हइ. ");
INSERT INTO goj_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","तब उनने बडो बोल से चिल्लय खे कान बन्द करी लिया अरु एक साथ ओ पर झपट्या, ");
INSERT INTO goj_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","अरु उ नगर का बाहेर नीकलीखे ओ पर पथराव करण लग्या. गवा ने अपना कपडा शाउल नामको एक जवान का पायहोन का पास उतारी खे रखी दियो. ");
INSERT INTO goj_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","वे स्तिफनुस पर पथराव करता र्‍हिया, अरु उ यो बोलीखे प्रार्थना करतो र्‍हिये, “हे प्रभु यीशु मरी आत्मा खे अपनइ ले. ");
INSERT INTO goj_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","फिर घुटना टेकिखे उचो बोल से पुकारनु, हे प्रभु यो पाप उन पर मत लगानु.” अरु यो बोलीखे उ सोइ गयो. ");
INSERT INTO goj_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","शाउल उ दिन यरुशलेम की मंडली पर बडो उपद्रव सुरवात हुयो अरु प्रेरितहोन खे छोड सब का सब यहूदीया अरु सामरिया देशहोन मे तितर बितर हुइ गा. ");
INSERT INTO goj_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","कुछ भक्तहोन ने स्तिफनुस खे कब्र मे रख्यो अरु ओका लिये बडो विलाप कर्यो. ");
INSERT INTO goj_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","शाउल मंडली खे उजाडी रो थो. अरु घर घर घुसीखे अदमी अरु बयहोन खे घिसी खे बन्दीगृह मे डालतो थो. ");
INSERT INTO goj_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","जो तितर बितर हुया था, वे सुसमाचार सुनता हुया फिर्या. ");
INSERT INTO goj_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","अरु फिलिप्पुस सामरिया नगर मे जैखे दुन्या मे मसीह को प्रचार करण लग्यो. ");
INSERT INTO goj_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","जो बातहोन फिलिप्पुस ने बोली वे दुन्या ने सुनीखे अरु जो चिन्ह उ दिखातो थो उनके देखी देखी खे एक चित्त हुइ खे मन लगायो. ");
INSERT INTO goj_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","क्युकि खुप मे से बुरी आत्माहोन बडा बोल से चिल्लाते हुयो नीकली गयो, अरु खुप सा लखवा रोगी अरु लगडा भी अच्छो कर्‍यो गयो. ");
INSERT INTO goj_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","अरु उ नगर मे खुशी छै गइ. ");
INSERT INTO goj_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","येका से पैयले उ नगर मे शमौन नाम को एक इन्सान थो, जो जादू टोना करी खे सामरिया का दुन्या खे चकित करतो अरु अपना खुद खे एक बडो इन्सान बतातो थो. ");
INSERT INTO goj_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","छोटा से बडा तक सब ओको सम्मान करणु बोलतो थो, “यो इन्सान परमेश्वर की वा शक्ति हइ ‘जो महान बोल्यो जास हइ.’” ");
INSERT INTO goj_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","ओने भोत दिन से उनका अपना जादू का काम होन से चकित करतो थो. येका लिये वे ओखे भोत मानता था. ");
INSERT INTO goj_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","पन जब उनने फिलिप्पुस को विश्वास कर्यो जो परमेश्वर को राज्य अरु यीशु मसीह का नाम को सुसमाचार सुनातो थो ते दुन्या, का अदमी, का बय, बपतिस्मा लेन लग्या. ");
INSERT INTO goj_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","तब शमौन ने खुद भी विश्वास कर्यो अरु बपतिस्मा लिखे फिलिप्पुस का साथ र्‍हेन लग्यो. उ चिन्ह अरु बडो सामर्थ्य को काम होता देखी खे चकित होतो थो. ");
INSERT INTO goj_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","जब प्रेरितहोन ने जो यरुशलेम मे थो, सुन्यो कि सामरियाहोन ने परमेश्वर को वचन मानी लियो हइ ते पतरस अरु यहून्ना को ओका पास भेज्यो. ");
INSERT INTO goj_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","उनने जयखे उनका लिये प्रार्थना करी कि पवित्र आत्मा पाये. ");
INSERT INTO goj_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","क्युकि उ अब तक उनमे से कोय पर नी उतर्यो थो. उनने ते फक्त प्रभु यीशु का नाम मे बपतिस्मा लियो थो. ");
INSERT INTO goj_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","तब उनने उन पर हाथ रख्यो अरु उनने पवित्र आत्मा पायो. ");
INSERT INTO goj_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","जब शमौन ने देख्यो कि प्रेरितहोन का हाथ रखना से पवित्र आत्मा दियो जास हइ ते उनका पास रुप्या लयखे बोल्यो. ");
INSERT INTO goj_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","यो अधिकार मेखे भी दे, कि जो कोय पर हाथ रख्यु उ पवित्र आत्मा पाये. ");
INSERT INTO goj_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","पतरस ने ओकासे बोल्यो, तरा रुप्या तरा साथ खत्म हुये क्युकि तो ने परमेश्वर को दान रुप्या से मोल लेन को बिचार कर्यो. ");
INSERT INTO goj_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","या बात मे नी तरा हिस्सो हइ नी भाग क्युकि तरो मन परमेश्वर का आगे सीधो नी. ");
INSERT INTO goj_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","येका लिये अपनी या बुराइ से मन फिरानु प्रभु से प्रार्थना करणु ,सम्भव हइ तरो मन को बिचार माफ कर्यो जाये. ");
INSERT INTO goj_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","क्युकि मी देखुस हइ कि तु पित्त की सी कडुपन अरु अधर्म का बन्धन मे पड्यो हइ. ");
INSERT INTO goj_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","शमौन ने जवाब दियो, “तुम मरा लिये प्रभु से प्रार्थना करणु कि जो बातहोन तुम ने बोली, उनमे से कोय मरा पर नी अय पड्या.” ");
INSERT INTO goj_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","आखरी वे गवा दियेका अरु प्रभु को वचन सुनीखे यरुशलेम खे लौटी गया अरु सामरीहोन को भोत सा गावहोन मे सुसमाचार सुनाता गया. ");
INSERT INTO goj_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","फिर प्रभु को एक स्वर्गदूत ने फिलिप्पुस से बोल्यो “उट अरु दक्षिन दिशा का तरफ उ मार्ग पर जा जो यरुशलेम से गाजा खे जास हइ.” ");
INSERT INTO goj_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","उ उठी खे चली दियो, अरु देखनु कि कूश देश को एक इन्सान अय र्‍हो थो जो खोजा अरु कूशियहोन की रानी कन्दाका, को अधिकारी अरु खजाची थो. उ आराधना करण खे यरुशलेम आयो थो. ");
INSERT INTO goj_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","उ अपना रथ पर बठौ हुयो थो, अरु यशायाह भविष्यव्दक्ता की किताब पडते हुयो वापीस जै रो थो. ");
INSERT INTO goj_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","तब आत्मा ने फिलिप्पुस ने बोल्यो का पास “जैइखे या रथ का साथ हुइ ले.” ");
INSERT INTO goj_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","फिलिप्पुस ओका तरफ दौड्यो अरु ओका यशायाह भविष्यव्दक्ता की किताब पडता हुया सुन्यो, अरु पूछ्यो, “तू जो पडी र्‍हो हइ, ओखे समझय भी हइ?” ");
INSERT INTO goj_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","ओने बोल्यो, “जब तक कोय मेखे नी समझाये ते मी कसो समझ्यु?” अरु ओने फिलिप्पुस से प्रार्थना करी कि व्हा चेडी खे ओका पास बठ्यो. ");
INSERT INTO goj_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","पवित्रशास्त्र को जो अध्याय उ पडी र्‍हो थो, उ यो थो उ मेडा का जसो खुन होन खे पहुचायो गयो, अरु जसो मेडो अपना वे कतरन आला को जसो चुपचाप र्‍हेस हइ, वसो ही ओने भी अपना मुडो नी खोल्यो. ");
INSERT INTO goj_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","ओका दीनता मे ओको न्याय नी हुइ पायो. ओका टेम मे दुन्या को वर्णन कोन कर्ये? क्युकि पृथ्वी से ओको जान उठैइ लियो जास हइ. ");
INSERT INTO goj_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","ये पर खोजा ने फिलिप्पुस से पुछ्यो, “मी तरा से प्रार्थना करुस हइ यो बता कि भविष्यव्दक्ता यो बारे मे बोलस हइ, अपना या कोय दुसरा का बारे मे?” ");
INSERT INTO goj_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","तब फिलिप्पुस ने अपनो मुडो खोल्यो, अरु या शास्त्र से सुरवात करीखे ओका यीशु को सुसमाचार सुनायो. ");
INSERT INTO goj_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","रस्ता मे चलते चलते वे कोय पाणी का जगा पहुच्या. तब ढुडन बोल्यो, “देख ह्या पाणी हइ, अब मेखे बपतिस्मा लेना मे कान रोखस हइ.” ");
INSERT INTO goj_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","फिलिप्पुस ने बोल्यो, अगर तू पुरा मन से से विश्वास करस हइ ते लि सकस हइ ओने जवाब दियो, “मी विश्वास करुस हइ कि यीशु मसीह परमेश्वर को बेटो हइ.” ");
INSERT INTO goj_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","तब ओने रथ खडो करण की आज्ञा दी, अरु फिलिप्पुस अरु खोजा दो पाणी मे उतर गया, अरु ओने खोजा खे बपतिस्मा दियो. ");
INSERT INTO goj_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","जब वे पाणी मे से नीकली खे उपर आया, ते प्रभु कि आत्मा फिलिप्पुस खे उठै लि गयो, अरु खोजा ने ओखे फिर नी देख्यो, अरु उ आनन्द करता हुया अपना रस्ता पर चली गयो. ");
INSERT INTO goj_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","फिलिप्पुस अशदोद मे अय नीकल्यो, अरु जब तक कैसरिया मे नी पउच्यो, तब तक नगर नगर सुसमाचार सुनातो गयो. ");
INSERT INTO goj_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","शाउल जो अब तक प्रभु का चेलाहोन खे धमकानो अरु घात करण की धुन मे थो, महायाजक का पास गयो. ");
INSERT INTO goj_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","अरु ओकासे दमीश्क का आराधनालयहोन का नाम पर या अभिप्राय की चिटिहोन मागी कि, का अदमी, का बय, जेने उ या पथ पर पाये उनका बाधीखे यरुशलेम ली आया. ");
INSERT INTO goj_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","पन चलता चलता जब उ दमीश्क का पास पहुच्या, ते एक-एक बद्दल से ओका चारो तरफ ज्योति चमकी. ");
INSERT INTO goj_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","अरु उ जमीन पर गिरी पड्यो अरु यो अवाज सुनी, हे शाउल, हे शाउल, तु मेखे क्यु सतास हइ? ");
INSERT INTO goj_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","“ओने पूछ्यो,” हे प्रभु तू कोन हइ? ओने बोल्यो, “मी यीशु हइ,” जेखे तू सतास हइ. ");
INSERT INTO goj_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","“पन अब उठीखे नगर मे जा, अरु जो तोखे करणो हइ उ तरा से बोल्‍या जाये.” ");
INSERT INTO goj_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","जो इन्सान ओका साथ थो, वे अवाक्य र्‍हि गयो क्युकि बोल ते सुनता था पन कोय, देखतो नी थो. ");
INSERT INTO goj_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","तब शाउल जमीन पर से उठौ, पन जब आखहोन खोल्या ते ओखे कुछ दिखइ नी दियो, अरु वे ओका हाथ पकडी खे दमीश्क मे लि गया. ");
INSERT INTO goj_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","उ तीन दिन तक देखी नी सक्यो, अरु नी खायो अरु नी पीयो. ");
INSERT INTO goj_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","दमीश्क मे हनन्याह नाम को एक चेलो थो का ओकासे प्रभु ने दर्शन मे बोल्यो, हे हनन्याह ओने बोल्यो, का “हा प्रभु.” ");
INSERT INTO goj_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","तब प्रभु ने ओकासे बोल्यो उठीखे , “वा गल्ली मे जा जो सीधी बोलीजास हइ, अरु यहूदा का घर मे शाउल नाम को एक तरसुस वासी खे पूछ्यो. देख उ प्रार्थना करी र्‍हो हइ. ");
INSERT INTO goj_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","अरु ओने हनन्याह नाम को एक इन्सान का अंदर आते अरु अपना उपर हाथ रखता देख्यो हइ. ताकि फिर से नजर पाये.” ");
INSERT INTO goj_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","हनन्याह ने जवाब दियो, “ हे प्रभु मे ने यो इन्सान का बारे मे भोत सो सुन्यो हइ कि येने यरुशलेम मे तरा पवित्र दुन्या का साथ बडी बुराइहोन करी हइ. ");
INSERT INTO goj_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","अरु ह्या भी येका प्रधान याजकहोन का तरफ से अधिकार मील्यो हइ कि जो दुन्या तरो नाम लेस हइ, उन सब खे बाधी ले.” ");
INSERT INTO goj_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","पन प्रभु ने ओकासे बोल्यो, तू चली जा. क्युकि उ ते गैरयहूदिहोन अरु राजाहोन अरु इस्त्राएलिहोन का सामने मरो नाम प्रगट करन का लिये मरो चुन्यो हुयो पात्र हइ. ");
INSERT INTO goj_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","अरु मी ओखे बतायु कि मरा नाम का लिये ओखे कसो कसो दुख उठानु पड्ये. ");
INSERT INTO goj_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","तब हनन्याह उठीखे उ घर मे गयो, अरु ओका पर अपनो हाथ रखी खे बोल्यो हे भैइ शाउल प्रभु मंनजे यीशु जो उ रस्ता मे जेका से तू आयो तोखे दिखइ दियो थो, ओ ने मेखे भेज्यो हइ कि तू फिर नजर पाये अरु पवित्र आत्मा से परिपूर्ण हुइ जाये. ");
INSERT INTO goj_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","अरु जल्दी ओकी आखहोन से छिलका से गिर्या अरु उ देखन लग्यो, अरु उठीखे बपतिस्मा लियो. ");
INSERT INTO goj_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","फिर भोजन करीखे बल पायो. उ कइ दिन वे चेलाहोन का साथ र्‍हियो जो दमीश्क मे थो. ");
INSERT INTO goj_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","अरु उ जल्दी आराधनालयहोन मे यीशु को प्रचार करण लग्या कि उ परमेश्वर को बेटो हइ. ");
INSERT INTO goj_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","सब सुननआला चकित हुइ खे बोलन लग्या, का योही उ इन्सान नी हइ जो यरुशलेम मे उनका जो यो नाम खे लेता था, खत्म करता था. अरु ह्या भी येका लिये आयो थो कि उनका बाधी खे प्रधान याजकहोन का पास लि जाये? ");
INSERT INTO goj_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","पन शाउल अरु भी सामर्थी होतो गयो, अरु या बात को प्रमाण दि दि, कि मसीह योही हइ, दमीश्क का र्‍हेनआला यहूदीयाहोन को मुडो बन्द करतो र्‍हियो. ");
INSERT INTO goj_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","जब भोत दिन बीती गया ते यहूदीयाहोन ने मीलिखे ओका मारी डालन को षड्यन्त्र रच्यो. ");
INSERT INTO goj_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","पन उनको षड्यन्त्र शाउल खे मालुम हुइ गयो. वे तो ओखे मारी डाल्यो का लिये रात दिन फाटकहोन पर घात मे लग्या र्‍हेता था. ");
INSERT INTO goj_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","पन रात खे ओका चेलाहोन ने ओखे टोपला मे बठाड्यो, अरु शहर दिवाल छेद मे से लटकि खे उतारी दियो. ");
INSERT INTO goj_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","यरुशलेम मे पहुची खे ओने चेलाहोन का साथ मीली जान को कोशिश कर्यो. पन सब ओकासे डरता था, क्युकि उनका विश्वास नी होतो थो, कि उ भी चेलो हइ. ");
INSERT INTO goj_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","पन बरनबास ने ओका अपना साथ प्रेरितहोन का पास लि जैइ खे उनखे बतायो कि येने कोय रीति से मार्ग मे प्रभु खे देख्यो, अरु ओने येका से बातहोन करी. फिर दमीश्क मे येने कसो हिम्मत से यीशु का नाम से प्रचार कर्यो. ");
INSERT INTO goj_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","उ प्रभु उनका साथ यरुशलेम मे आता जाते र्‍हियो ");
INSERT INTO goj_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","अरु नी धडक हुइ खे प्रभु का नाम से प्रचार करतो थो. अरु यूनानी भाषा बोलनआला यहूदीयाहोन का साथ बातचित वाद विवाद करतो थो. पन वे ओखे मारी डालन कि कोशिश करण लग्या. ");
INSERT INTO goj_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","यो जानीखे भैइ ओखे कैसरिया लि आयो, अरु तरसुस खे भेजी दियो. ");
INSERT INTO goj_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","यो प्रकार पुरा यहूदीया, अरु गलील, अरु सामरिया मे मंडली खे चैन मील्यो, अरु ओकी उन्नती होती गइ. अरु उ प्रभु को डर अरु पवित्र आत्मा की शांती मे चलती अरु बडती गइ. ");
INSERT INTO goj_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","फिर असो हुयो कि पतरस हर जगा फिरतो हुयो, उन पवित्र दुन्या का पास भी पहुच्या जो लुद्दा मे र्‍हेता था. ");
INSERT INTO goj_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","वहा ओका एनीयास नाम को लखवा को रोगी एक इन्सान मील्यो, जो आठ साल से खटिया पर पड्यो थो. ");
INSERT INTO goj_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","पतरस ने ओकासे बोल्यो, “ हे एनीयास! यीशु मसीह तोखे अच्छो करस हइ. उट अपनो बिछानो बिछा.” तब उ जल्दी उठी खडो हुयो. ");
INSERT INTO goj_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","तब लुद्दा अरु शारोन को सब र्‍हेनआला ओका देखी खे प्रभु की तरफ फिर्या. ");
INSERT INTO goj_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","याफा मे तबीता मंनजे दोरकास नाम की एक विश्वासिनी र्‍हेती थी. वाभोत सा अच्छो अच्छो काम अरु दान कर्या करती थी. ");
INSERT INTO goj_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","उ दिनहोन मे वा बीमार हुइ खे मरी गइ. अरु उनने ओको आंग धोलय खे अटारी पर रखी दियो. ");
INSERT INTO goj_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","येका लिये कि लुद्दा याफा का पास थो, चेलाहोन ने यो सुनी खे कि पतरस वहा हइ, दो इन्सान भेजी खे ओका से प्रार्थना करी खे हमारा पास आना मे देर नी करणु. ");
INSERT INTO goj_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","तब पतरस उठी खे उनका साथ हय लियो, अरु जब उ पहुच्यो ते वे ओका उ अटारी पर लि गया. सब विधवाहोन रोती हुइ ओका पास अय खडी हुइ अरु जो कुर्ता अरु कपडा दोरकास ने उनका साथ र्‍हेता हुया बनायो थो, दिखान लगी. ");
INSERT INTO goj_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","तब पतरस ने सब खे बाहेर करी दियो, अरु घुटना टेकीखे प्रार्थना करी अरु लास का तरफ देखी, बोल्यो, “ हे तबीता, उट” तब ओने अपनी आखहोन खोली दी. अरु पतरस खे देखीखे उठ बठी. ");
INSERT INTO goj_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","ओने हाथ दिखे ओखे उठाय खे अरु पवित्र दुन्या अरु विधवाहोन खे बुलैइ खे ओखे जिन्दो दिखइ दियो. ");
INSERT INTO goj_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","या बात पुरा याफा मे फैली गइ. अरु भोतझन ने प्रभु पर विश्वास कर्यो. ");
INSERT INTO goj_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","अरु पतरस याफा मे शमौन नामको कोय चामडा को धंदो करणआला का ह्या भोत दिन तक र्‍हियो. ");
INSERT INTO goj_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","कैसरिया मे कुरनेलियुस नाम को एक इन्सान थो, जो इतालियानी नामको पलटन को सुबेदार थो. ");
INSERT INTO goj_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","उ भक्त थो, अरु अपना पुरा घराना समेत परमेश्वर से डरतो थो, अरु यहूदी दुन्या खे भोत दान देतो, अरु बराबर परमेश्वर से प्रार्थना करतो थो. ");
INSERT INTO goj_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","ओने दिन का तीसरा पार का पास दर्शन मे स्पष्ट रुप से देख्यो कि परमेश्वर को एक स्वर्गदूत ओका पास अंदर अयखे बोल्यो हइ “हे कुरनेलियुस” ");
INSERT INTO goj_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","ओने ओखे ध्यान से देख्यो अरु डरीखे बोल्यो, “ हे प्रभु का हइ?” ओने ओकासे बोल्यो, “तरी प्रार्थना अरु तरो दान याद का लिये परमेश्वर का सामने पहुच्यो हइ. ");
INSERT INTO goj_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","अरु सब याफा मे इन्सान भेजी खे शमौन खे जो पतरस कैलातो हइ, बुलय ले. ");
INSERT INTO goj_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","उ शमौन, चामडा को धंदो करणआला का ह्या मीजवान हइ, जोको घर समुंदर का किनारा हइ.” ");
INSERT INTO goj_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","जब उ स्वर्गदूत जेने ओकासे बातहोन करी थी चली गयो, ते ओने दो सेवक, अरु जो ओका पास हाजिर र्‍हियो करतो थो उनमे से एक भक्त सिपइ खे बुलायो. ");
INSERT INTO goj_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","अरु उनखे सब बातहोन बतयखे याफा खे भेज्यो. ");
INSERT INTO goj_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","दूसरा दिन जब वे चलते चलते नगर का पास पहुच्या, ते धुपार का पास पतरस छपर पर प्रार्थना करण चड्यो. ");
INSERT INTO goj_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","ओखे भुक लगी अरु कुछ खानो चातो थो, पन जब वे तैयारी करी र्‍हा था ते उ बेसुध हुइ गयो. ");
INSERT INTO goj_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","अरु ओने देख्यो, कि बद्दल खुली गयो. अरु एक पात्र बडि चद्दर का जसो चारी कोना से लटकातो हुयो, पृथ्वी की तरफ उतरी र्‍हो हइ. ");
INSERT INTO goj_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","जे मे पृथ्वी का सब प्रकार का चारपाय अरु रेंगनआला जन्तु अरु बद्दल का पक्षि था. ");
INSERT INTO goj_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","ओखे एक असो बोल सुनइ दियो “हे पतरस उठ मार अरु खा,” ");
INSERT INTO goj_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","पन पतरस ने बोल्यो, “नी प्रभु कभी भी नी क्युकि मेने कभी कोय अपवित्र या अच्छो चिज नी खे हइ.” ");
INSERT INTO goj_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","फिर दूसरी बार ओको बोल सुनइ दियो, जो कुछ परमेश्वर ने अच्छो ठैरायो हइ, ओखे तु अच्छो मत बोल. ");
INSERT INTO goj_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","तीन बार असो ही हुयो. तब जल्दी उ पात्र बद्दल पर उठै लियो गयो. ");
INSERT INTO goj_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","जब पतरस अपना मन मे दुविधा मे थो, कि यो दर्शन जो मे ने देख्यो उ का हुइ सकस हइ, ते देखनु, वे इन्सान जिनखे कुरनेलियुस ने भेज्यो थो, उ शमौन का घर को पतो लगइखे दरवाजा पर अयखे खडा हुया. ");
INSERT INTO goj_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","अरु पुकारी खे पूछन लग्या, का शमौन जो पतरस कैलातो हइ, योही मीजवान हइ? ");
INSERT INTO goj_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","पतरस ते उ दर्शन पर सोची ही र्‍हो थो, कि आत्मा ने ओकासे बोल्यो, “देखनु, तीन इन्सान तरी खोज मे हइ. ");
INSERT INTO goj_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","आखरी उठी खे नीचे जा, अरु नी. संकोच उनका साथ ही ले क्युकि मे ने ही उनखे भेज्यो हइ.” ");
INSERT INTO goj_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","तब पतरस ने उतरीखे उ इन्सान से बोल्यो, देख्यो, जोकी खोज तुम करी र्‍हो हइ, उ मी ही हइ. तुमारा आना को का कारण हइ? ");
INSERT INTO goj_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","उनने बोल्यो, “कुरनेलियुस सुबेदार जो धर्मी अरु परमेश्वर से डरन आलो अरु पुरी यहूदी जात मे सुनाम इन्सान हइ, ओने एक पवित्र स्वर्गदूत से यो नीर्देश पायो हइ कि तोखे अपना घर बुलैइ खे तरा से वचन सुन्ये.” ");
INSERT INTO goj_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","तब ओने उनने अंदर बुलायो उनकी मीजवानी करी. दूसरा दिन उ उनका साथ गयो, अरु याफा का भैइहोन मे से कुछ ओका साथ गया. ");
INSERT INTO goj_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","दूसरा दिन वे कैसरिया पहुच्या, अरु कुरनेलियुस उनकी रस्ता दिखी र्‍हो थो. ");
INSERT INTO goj_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","जब पतरस अंदर अय र्‍हो थो, ते कुरनेलियुस ने ओकासे दान करी खे अरु पायहोन पर गिरी खे ओखे प्रणाम कर्यो. ");
INSERT INTO goj_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","पन पतरस ने ओखे उठयखे बोल्यो, “खडो हो, मी भी तो इन्सान हइ.” ");
INSERT INTO goj_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","अरु ओका साथ बातचीत करता हुया अंदर गया, अरु भोत सा दुन्या खे एकजगा देखीखे ");
INSERT INTO goj_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","उनसे बोल्यो, तुम जानस हइ कि गैरयहूदी की संगत करणो या ओका साथ ह्या जानो यहूदीहोन का लिये अधर्म हइ, पन परमेश्वर ने मेखे बतायो हइ कि कोय इन्सान खे अपवित्र या अच्छो नी बोल्यु. ");
INSERT INTO goj_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","येका लिये मी जब बुलायो गयो ते बिना कुछ बोले चली आयो. अब मी पूछुस हइ कि मेखे कोय काम का लिये बुलायो गयो? ");
INSERT INTO goj_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","हे कुरनेलियुस ने बोल्यो, या घडि खे पूरा चार दिन हुया, मी अपना घर मे तीसरा पार प्रार्थना करी र्‍हो थो. ते देख्यो, एक अदमी चमकीलो कपडा पेन्या हुयो, मरा सामने अय खडो हुयो. ");
INSERT INTO goj_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","अरु बोलन लग्या, हे कुरनेलियुस, तरी प्रार्थना सुनी ली गइ हइ अरु तरो दान परमेश्वर का सामने याद कर्यो गयो हइ. ");
INSERT INTO goj_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","येकालिये कोय खे याफा भेजीखे शमौन खे जो पतरस कैलातो हइ , बुला. उ समुंदर का किनारा शमौन, चामडा को धंदो करणआला का घर मे मीजवान हइ. ");
INSERT INTO goj_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","तब मे ने जल्दी तरा पास दुन्या भेज्ये, अरु तो ने भलो कर्यो जो अय गयो. अब हम सब ह्या परमेश्वर का सामने हइ , ताकि जो कुछ परमेश्वर ने तरा से बोल्यो हइ ओखे सुन्ये. ");
INSERT INTO goj_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","तब पतरस ने बोल्यो, “अब मेखे नीश्चय हुयो कि परमेश्वर कोय को पक्ष नी कर्ये. ");
INSERT INTO goj_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","क्युकी हर जात मे जो ओखे डरतो अरु धर्म को काम करस हइ, उ ओखे भास हइ. ");
INSERT INTO goj_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","जो वचन ओने इस्त्राएलिहोन का पास भेज्यो, जब ओने यीशु मसीह का वजेसे जो सब को प्रभु हइ शांती को सुसमाचार सुनायो. ");
INSERT INTO goj_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","उ वचन तुम जानस हइ जो यहून्ना को बपतिस्मा को प्रचार का बाद गलील से सुरवात हुइखे पुरा यहूदीया मे फैली गयो. ");
INSERT INTO goj_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","परमेश्वर ने कोय रीति से यीशु नासरी खे पवित्र आत्मा अरु सामर्थ्य से अभिषेक कर्यो, उ भलाइ करस अरु सब खे जो सैतान का सताया हुया था अच्छो करतो फिर्यो,क्युकि परमेश्वर ओका साथ थो. ");
INSERT INTO goj_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","हम उन कामहोन को गवा हइ. जो ओने यहूदी को देश अरु यरुशलेम मे भी कर्यो, अरु उनने ओखे काठ पर लटकय खे मारी डाल्यो. ");
INSERT INTO goj_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","ओखे परमेश्वर ने तीसरा दिन जिन्दो, अरु प्रगट भी करी दियो हइ. ");
INSERT INTO goj_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","सब दुन्या पर नी क्युकी उन गवाहोन पर जिन्हे परमेश्वर ने पैयले से चुनी लियो थो, मंनजे हम पर जेने ओका मर्या हुया मे से जिन्दो उठना का बाद ओका साथ खायो पीयो. ");
INSERT INTO goj_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","अरु ओने हमखे आज्ञा दी कि दुन्या मे प्रचार कर अरु गवय दे, कि यो उ हइ जोख परमेश्वर ने जिन्दो अरु मर्या हुयो को न्याय ठैरायो हइ. ");
INSERT INTO goj_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","ओका सब भविष्यव्दक्ता गवय देस हइ कि जो कोय ओ पर विश्वास कर्ये, ओखे ओका नाम का वजेसे पापहोन की माफी मील्ये.” ");
INSERT INTO goj_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","पतरस या बातहोन बोली ही र्‍हो थो कि पवित्र आत्मा वचन खे सब सुननआला पर उतरी आयो. ");
INSERT INTO goj_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","अरु जित्ता खतनो कर्या हुया विश्वासी पतरस का साथ आया था, वे सब चकित हुया कि गैरयहूदीहोन पर भी पवित्र आत्मा को दान दियो गयो हइ. ");
INSERT INTO goj_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","क्युकि उनने उनखे भाती भाती कि भाषा बोलता अरु परमेश्वर की बडाइ करता सुन्यो. ये पर पतरस ने बोल्यो. ");
INSERT INTO goj_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","का कोय पाणी की रोक खे सकस हइ कि यो बपतिस्मा नी पाये जेने हमारा समान पवित्र आत्मा पायो हइ? ");
INSERT INTO goj_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","अरु ओने आज्ञा दी कि उनने यीशु मसीह का नाम मे बपतिस्मा दिये जाये. तब उनने ओकासे प्रार्थना करी कि उ कुछ दिन अरु उनका साथ र्‍हिये. ");
INSERT INTO goj_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","फिर प्रेरितहोन अरु विश्वासी ने जो जो यहूदीया मे थो सुन्यो कि गैरयहूदिहोन ने भी परमेश्वर को वचन मानी लियो हइ. ");
INSERT INTO goj_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","आखरी जब पतरस यरुशलेम मे आयो, ते खतनो कर्यो हुया दुन्या ओकासे वाद विवाद करण लग्या. ");
INSERT INTO goj_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“तो ने खतनारहित दुन्याहोन का ह्या जैइखे ओका साथ खायो.” ");
INSERT INTO goj_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","तब पतरस ने उनका सुरवात से क्रमा नुसार बोल सुनायो. ");
INSERT INTO goj_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“मी याफा नगर मे प्रार्थना करी र्‍हो थो, अरु बेसुद हुइ खे एक दर्शन देख्यो कि एक बर्तन खे बडी चद्दर का समान चार कोना से लटकायो हुयो, बद्दल से उतरी खे मरा पास आयो. ");
INSERT INTO goj_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","जब मे ने ओ पर ध्यान कर्यो, ते ओमे पृथ्वी कि चारपाय अरु जंगल जनवर अरु रेगनआला जन्तु अरु बद्दल का पक्षि देख्यो. ");
INSERT INTO goj_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","अरु यो बोल भी सुन्यो, हे पतरस उट, मार अरु खा. ");
INSERT INTO goj_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","मे ने बोल्यो, नी प्रभु, नी क्युकि कोय अपवित्र या अशुध्द चिज मरा मुडा मे कभी नी गइ. ");
INSERT INTO goj_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","येको जवाब मे बद्दल से दूसरी बार बोल हुयो, जो कुछ परमेश्वर ने अच्छो ठैरायो हइ ओखे अशुध्द मत बोल. ");
INSERT INTO goj_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","तीन बार असो ही हुयो. तब सब कुछ फिर बद्दल पर खीची लियो गयो. ");
INSERT INTO goj_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","अरु देखनु, जल्दी तीन इन्सान जो कैसरिया से मरा पास भेज्यो गयो थो, उ घर पर जोमे हम था, उ अय खडा हुया. ");
INSERT INTO goj_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","तब आत्मा ने मरा से उनका साथ नी.सकोच होन खे बोल्यो, अरु ये छे. भैइ भी मरा साथ हुइ लिया. अरु हम उ इन्सान का घर गया. ");
INSERT INTO goj_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","ओने हम खे बतायो, कि ओने एक स्वर्गदूत खे अपना घर मे खडो देख्यो, जेने ओकासे बोल्यो, याफा मे इन्सान भेजी खे शमौन खे जो पतरस कैलातो हइ, बुलैइ ले. ");
INSERT INTO goj_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","उ तुम से असी बातहोन बोल्ये जिन का वजेसे तू अरु तरो पुरो घरानो उध्दार पाये. ");
INSERT INTO goj_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","जब मी बातहोन करण लग्यो, ते पवित्र आत्मा उन पर उ रीति से उतर्यो जो रीति से सुरवात मे हम पर उतर्यो थो. ");
INSERT INTO goj_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","तब मेखे प्रभु को उ वचन याद आयो. जो ओने बोल्यो थो, यहून्ना ने तो पाणी से बपतिस्मा दियो, पन तुम पवित्र आत्मा से बपतिस्मा पाये. ");
INSERT INTO goj_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","आखरी जब परमेश्वर ने उनखे भी उ दान दियो, जो हम खे प्रभु यीशु मसीह पर विश्वास करणा से मील्यो थो. ते मी कोन थो जो परमेश्वर खे रोकी सकतो?” ");
INSERT INTO goj_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","यो सुनीखे वे चुप र्‍हेका अरु परमेश्वर की बडाइ करी खे बोलन लग्या, तब ते परमेश्वर ने गैरयहूदिहोन खे भी जिवन का लिये मन फिराव को दान दियो हइ. ");
INSERT INTO goj_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","जो दुन्या उ क्लेश का माऱ्यो जो स्तिफनुस करण पड्यो थो, तितर बितर हुइ गया था, वे घुमते घुमते फीनीके अरु साइप्रस अरु अन्ताकिया मे पहुच्या. पन यहूदीयाहोन खे छोड कोय दुसरा को वचन नी सुनता था. ");
INSERT INTO goj_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","पन उनमे से कुछ साइप्रस वासी अरु कुरेनी था, जो अन्ताकिया मे अय खे यूनानीहोन खे भी प्रभु यीशु को सुसमाचार कि बातहोन सुनान लग्या. ");
INSERT INTO goj_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","प्रभु को हाथ उन पर थो, अरु भोत दुन्या विश्वास करी खे प्रभु का तरफ फिर्या. ");
INSERT INTO goj_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","जब उनकी बातचित यरुशलेम की मंडली खे सुनना मे आयो, ते उनने बरनबास खे अन्ताकिया भेज्यो. ");
INSERT INTO goj_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","उ वहा पहुची खे अरु परमेश्वर को अनुग्रह खे देखी खे खुश हुयो, अरु सब खे उपदेश दियो कि तन मन लगयखे प्रभु से लिपट्यो र्‍हियो. ");
INSERT INTO goj_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","उ एक अच्छो इन्सान थो, अरु पवित्र आत्मा अरु विश्वास से परिपूर्ण थो. अरु दुसरा भोत सा दुन्या प्रभु मे अय मील्या. ");
INSERT INTO goj_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","तब उ शाउल खे ढुडन का लिये तरसुस खे चली गयो. ");
INSERT INTO goj_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","जब उ ओकासे मील्यो ते ओखे अन्ताकिया लायो. अरु असो हुयो कि वे एक साल तक मंडली का साथ मीलतो अरु भोत दुन्या खे उपदेश देतो र्‍हिया. अरु चेला सब से पैयले अन्ताकिया ही मे मसीह कैलाये. ");
INSERT INTO goj_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","उय दो मे कइ भविष्यव्दक्ता यरुशलेम से अन्ताकिया आया. ");
INSERT INTO goj_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","उनमे से अगबुस नाम को एक ने खडो हुइ खे आत्मा कि प्रेरणा से या बतायो कि पुरा जगत मे बडो अकाल पड्ये उ अकाल क्लौदियुस का टेम मे पड्यो. ");
INSERT INTO goj_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","तब सेवक होन ने नीर्णय कर्यो कि हर एक अपनी अपनी पुंजी का जसो यहूदीया मे र्‍हेनआला भैइहोन की मदत का लिये कुछ भेजनु. ");
INSERT INTO goj_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","उनने असो हि कर्यो. अरु बरनबास अरु शाउल का हाथ यरुशलेम का बुजरुक का पास पुंजी भेजी दि. ");
INSERT INTO goj_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","उ टेम हेरोदेस राजा ने मंडली का कइ इन्सानहोन का सतान का लिये उन पर हाथ डाल्यो. ");
INSERT INTO goj_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","ओने यहून्ना को भैइ याकूब खे तलवार से मरी डाल्यो. ");
INSERT INTO goj_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","जब ओने देख्यो कि यहूदीया दुन्या येका से आनन्दित होस हइ, ते ओने पतरस खे भी पकडी लियो. वे दिन अखमीरी रोटी को दिन था. ");
INSERT INTO goj_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","ओने ओखे पकडी खे बन्दीगृह मे डाल्यो, अरु चार चार का चार पहरेदारहोन मे रख्यो. या बिचार से कि फसह का बाद ओका दुन्या का सामने लायो. ");
INSERT INTO goj_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","बन्दीगृह मे पतरस बन्द थो. पन मंडली ओका लिये लौ लगैइखे परमेश्वर से प्रार्थना करी र्‍हि थी. ");
INSERT INTO goj_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","जब हेरोदेस पतरस खे इन्सानहोन का सामने एक रात पहइले, दो साकल से बध्यो हुयो दो सिपैइहोन का बीच मे र्‍हियो थो. अरु दरवाजा पर बन्दीगृह की रखवाली करी र्‍हा था. ");
INSERT INTO goj_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","ते देखनु, प्रभु को एक स्वर्गदूत अय खडो हुयो अरु उ कोठरी मे ज्योति चमकी, अरु ओने पतरस पर हाथ मारी खे ओका जगायो अरु बोल्यो, उट जल्दी कर. अरु ओका हाथ से साकल खुली खे गिरी पडी. ");
INSERT INTO goj_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","तब स्वर्गदूत ने ओकसे बोल्यो, कम्मर बाध अरु अपना जूता पेनी ले. ओने वसो ही कर्यो. फिर ओने ओकासे बोल्यो, अपना कपडा पेनीखे मरा पीछे अय जा. ");
INSERT INTO goj_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","उ नीकली खे ओका पीछे अयगो. पन यो नी जानतो थो कि जो कुछ स्वर्गदूत करी र्‍हो हइ उ सच हइ, क्युकी यो समझ्यो कि मी दर्शन देखी र्‍हो हइ. ");
INSERT INTO goj_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","तब वे पैयला अरु दूसरा दुपेर से नीकली खे उ लोहा का फाटक पर पहुचा, जो नगर का तरफ हइ. उ उनका लिये आप से आप खुली गयो, अरु वे नीकली खे एक गल्ली हुइ खे गया, अरु जल्दी ही स्वर्गदूत ओका छोडी खे चली गयो. ");
INSERT INTO goj_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","तब पतरस ने सचेत हुइ खे बोल्यो, “अब मे ने सच जानी लियो हइ कि प्रभु ने अपनो स्वर्गदूत भेजी खे मेखे हेरोदेस का हाथ से छुड्य लियो, अरु यहूदीया होन की पुरी आस तोडी दि हइ.” ");
INSERT INTO goj_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","यो जानी खे उ उस यहून्ना की माय मरियम का घर आयो, जो मरकुस बोल्या जास हइ. वहा भोत सा दुन्या जमा हुइ खे प्रार्थना करी र्‍हा था. ");
INSERT INTO goj_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","जब ओने फाटक की खिडकी ठोकी, ते रुदे नाम की एक दासी देखन अय ");
INSERT INTO goj_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","पतरस को बोल पैछानी खे ओने खुशी का मारे फाटक नी खोल्यो, पन दौडी खे अंदर गइ अरु बतायो कि पतरस दरवाजा पर खडो हइ. ");
INSERT INTO goj_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","उनने ओकासे बोल्यो, तू पागल हइ. पन वा दृढता से बोली कि असो हि हइ. तब उनने बोल्यो कि ओको स्वर्गदूत हुये. ");
INSERT INTO goj_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","पन पतरस खटखटातो ही र्‍हियो. आखरी उनने खिडकी खोली अरु ओखे देखी खे चकित र्‍हि गया. ");
INSERT INTO goj_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","तब ओने उनका हाथ से हुशार करीयो कि चुप र्‍हे. अरु उनखे बतायो कि प्रभु कोय रीति से ओखे बन्दीगृह से नीकाली लायो हइ. फिर बोल्यो, “याकूब अरु भैइहोन के या बात बतै देनु.” तब नीकली खे दूसरा जगा चली गयो. ");
INSERT INTO goj_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","फजर का सिपैइहोन मे बडी हलचल मची गइ कि पतरस को का हुयो. ");
INSERT INTO goj_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","जब हेरोदेस ने ओकी खोज की अरु नी पायो, ते पहरुहोन की परख्ये करी खे आज्ञा दि कि वे मारी डाल्यो जाये. अरु उ यहूदीया खे छोडी खे कैसरिया मे जै खे र्‍हेन लग्यो. ");
INSERT INTO goj_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","हेरोदेस सूर अरु सैदा का दुन्या से भोत थो. येका लिये वे एक चित्त हुइ खे ओका पास आया. अरु बलास्तुस को जो राजा को एक कर्मचासरी थो, मानी खे मेल करणो चायो. क्युकि राजा का देश से उनका देश को पालन पोषण होतो थो. ");
INSERT INTO goj_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","ठैरायो हुया दिन हेरोदेस राज कपडा परनी खे राजगद्दी पर बठौ, अरु उनको व्याख्यान देन लग्यो. ");
INSERT INTO goj_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","तब दुन्या पुकार उठ्यो, यो ते इन्सान को नी इश्वर को बोल हइ. ");
INSERT INTO goj_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","उ टेम प्रभु को एक स्वर्गदूत ने जल्दी ओखे मार्यो, क्युकि ओने परमेश्वर कि महिमा नी दी. अरु उ किडा लगी खे मरी गयो. ");
INSERT INTO goj_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","पन परमेश्वर को वचन बडतो अरु फैलतो गयो. ");
INSERT INTO goj_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","जब बरनबास अरु शाउल अपनी सेवा पूरी करी चुक्या ते यहून्ना को जो मरकुस बोल्या जास हइ, साथ ली खे यरुशलेम से लौट्यो. ");
INSERT INTO goj_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","अन्ताकिया कि मंडली मे कइ भविष्यव्दक्ता अरु उपदेशक था जसा बरनबास अरु शमौन जो नीगर बोलस हइ. अरु लूकियुस कुरेनी, अरु चौथाइ देश को राजो हेरोदेस को दूधभैइ मनाहेम, अरु शाउल. ");
INSERT INTO goj_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","जब वे उपास सहित प्रभु की उपासना करी र्‍हा था ते पवित्र आत्मा ने बोल्यो “मरा लिये बरनबास अरु शाउल खे उ काम का लिये अलग कर्यो जोका लिये मेने उनका बुलायो हइ” ");
INSERT INTO goj_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","जब उनने उपास अरु प्रार्थना करीखे अरु उन पर हाथ रखीखे उनका बिदा दी ");
INSERT INTO goj_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","अत वे पवित्र आत्मा खे भेजा हुया सिलुकिया खे गया अरु वाहा से डोगापर चडिखे साइप्रस खे चले ");
INSERT INTO goj_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","अरु सलमीस मीस्र मे पहुचीखे परमेश्वर को वचन यहूदीया होन खे आराधनालयो मे सुनायो यहून्ना उनका सेवक थो ");
INSERT INTO goj_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","वे उ सारा टापु मे होते हुया पाफुस तक पहुच्या वहा उनने बारा बार यीशु नाम को एक यहूदीया जादुगर अरु झूठा भविष्यव्दक्ता मील्यो. ");
INSERT INTO goj_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","उ हाकिम सिरगियुस पौलुस का साथ थो, जो बुध्दिमान अदमी थो. ओने बरनबास अरु शाउल खे अपना पास बुल्यै खे परमेश्वर को वचन सुननो चाह्यो. ");
INSERT INTO goj_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","पन इलीमास टोन्हे ने, क्युकि योही ओको नाम को अर्थ हइ, उनको विरोध करी खे हाकिम को विश्वास करणा से रोखनो चाह्यो. ");
INSERT INTO goj_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","तब शाउल ने जेको नाम पौलुस भी हइ, पवित्र आत्मा से परिपूर्ण हो ओका तरफ टकटकी लगैइ, देख्यो अरु बोल्यो. ");
INSERT INTO goj_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","हे पुरा दुशमन अरु सब हुशारी से भर्या हुया सैतान कि सन्तान, सब धर्म का बैरी का तु प्रभु कि सीधी रस्ताहोन खे तेडो करणो नी छोड्ये? ");
INSERT INTO goj_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","अब देख, प्रभु को हाथ तरा पर लग्यो हइ. अरु तू कुछ टेम तक अंधो र्‍हिये अरु सूरज खे नी देख्ये. तब तुरन्त अरु अधारो ओ पर छै गयो अरु उ इधर उधर टोटलन लग्यो ताकि कोय ओको हाथ पकडी खे ली चल्ये. ");
INSERT INTO goj_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","तब हाकिम ने जो हुयो थो ओखे देखी खे अरु प्रभु को उपदेश से चकित हुइ खे विश्वास कर्यो. ");
INSERT INTO goj_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","पौलुस अरु ओका साथी पाफुस से डोंगो खोलि खे पंफूलिया का पिरगा मे आया अरु यहून्ना उनखे छोड खे यरुशलेम का लौटी गयो. ");
INSERT INTO goj_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","पिरगा से आगे बडी खे वे पिसिदिया का अन्ताकिया मे पहुच्या अरु अराम का दिन आराधनालय मे जैइ खे बठी गयो. ");
INSERT INTO goj_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","व्यवस्था अरु भविष्यव्दक्ताहोन की किताब से पडन का बाद आराधनालय का सरदारहोन ने उनका पास बुलाओ भेज्यो, हे भैइहोन अगर दुन्या खे उपदेश का लिये तुम्हारो मन मे कोय बात हुइ ते बोलनु. ");
INSERT INTO goj_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","तब पौलुस ने खडो हुइ खे अरु हाथ से इसारो करी खे बोल्यो, हे इस्त्राएलिहोन, अरु परमेश्वर से डरनआला, सुन! ");
INSERT INTO goj_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","ये इस्त्राएली दुन्या का परमेश्वर ने हमारा बापदादाहोन खे चुनी लियो, अरु जब ये दुन्या मीस्र देस मे परदेशी हुइ खे र्‍हेता था, ते उनकी उन्नती करी. अरु बलवन्त भुजा से नीकाली लायो. ");
INSERT INTO goj_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","उ कोय चालीस साल तक जंगल मे उनकी सयतो से र्‍हियो. ");
INSERT INTO goj_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","अरु कनान देश मे सात जातीहोन खे नाश करी खे उनको देस कोय साढे चार सौ साल मे इन का मीरास मे करी दियो. ");
INSERT INTO goj_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","येका बाद ओने शमूएल भविष्यव्दक्ता तक उनमे न्याय ठैराये. ");
INSERT INTO goj_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","ओका बाद उनने एक राजो माग्यो. तब परमेश्वर ने चालीस साल का लिये बिन्यामीन का गोत्र मे से एक इन्सान. मंनजे कीश को बेटो शाउल के उन पर राजो ठैरायो. ");
INSERT INTO goj_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","फिर ओखे अलग करी खे दाउद खे उनको राजो बनायो. जेका बारे मे ओने गवइ दी मेखे एक इन्सान खे यिशय को बेटो दाउद, मरा मन का जसो मीली गयो हइ. उ मरी पुरी इच्छा पूरी कर्ये. ");
INSERT INTO goj_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","ये को कुल मे से परमेश्वर ने अपनी प्रतीज्ञा का जसो इस्राएल का पास एक उद्धारकर्ता, मंनजे यीशु खे भेज्यो. ");
INSERT INTO goj_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","जेका आना से पैयले यहून्ना ने सब इस्त्राएलिहोन मे मन फिराव को बपतिस्मा को प्रचार कर्यो. ");
INSERT INTO goj_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","जब यहून्ना अपनी सेवा पुरी करणा पर थो, ते ओने बोल्यो, तुम मेखे का समझस हुये? मी उ नी! जब देख कामरा बाद एक आनवालो हइ, जेका पाय का जुता भी मी खोलन का योग्य नी. ");
INSERT INTO goj_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","हे भैइ, तुम जो अब्राहम को बेटो हुये. तुम जो परमेश्वर से डरस हुये, तुमारा पास यो उध्दार को वचन भेज्यो गयो हइ. ");
INSERT INTO goj_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","क्युकी यरुशलेम का ऱ्हेनआला अरु उनका सरदार ने, नी ओखे पैछान्यो अरु नी भविष्यव्दक्ताहोन की बात समझी, जो हर अराम का दिन पडी जास हइ येका लिये ओका दोषी ठैर्येके या बात खे पूरी कऱ्यो. ");
INSERT INTO goj_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","उनने मारी डालन का योग्य कोय दोष ओमे नी पायो, तेभी पिलातुस से प्रार्थना करी कि उ मार्ये डाल्ये जाये. ");
INSERT INTO goj_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","जब उनने ओका बारे मे लिखी हुइ सब बातहोन पूरी करी खे ते ओखे क्रुस पर से उतारी खे कब्र मे रख्यो. ");
INSERT INTO goj_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","पन परमेश्वर ने ओखे मर्या हुया मे से जिन्दो. ");
INSERT INTO goj_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","अरु उ उनने जो ओका साथ गलील से यरुशलेम आया था, भोत दिनहोन तक दिखाइ देतो र्‍हियो. ");
INSERT INTO goj_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","हम तुम खे वा प्रतीज्ञ का विषय मे जो बापदादाहोन से करी गइ थी, यो सुसमाचार सुनास हइ. ");
INSERT INTO goj_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","कि परमेश्वर ने यीशु खे जिल्यैइ खे उ प्रतीज्ञा हमारी सन्तान का लिये पूरी करी. जसो दुसरा भजन मे भी लिख्यो हइ, आज मी तरो बाप बन्यो, तू मरो बेटो हइ. ");
INSERT INTO goj_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","अरु ओका या रीति से मर्या हुया मे से जिलाना का बारे मे भी कि उ कभी नी सड्ये ओने यो बोल्यो हइ, मी दाउद पर करी पवित्र अरु अटल कृपा तुम पर कर्यु. ");
INSERT INTO goj_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","येका लिये ओने एक अरु भजन मे भी बोल्यो हइ तू अपना पवित्र जन खे सडन नी दिये. ");
INSERT INTO goj_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","क्युकि दाउद तो परमेश्वर की इच्छा का जसो अपना टेम मे सेवा कर खे सोइ गयो, अरु अपना बापदादाहोन मे जै मील्यो, अरु सडी भी गयो. ");
INSERT INTO goj_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","पन जेखे परमेश्वर ने जिन्दो उ सडी नी पायो. ");
INSERT INTO goj_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","येका लिये हे भैइहोन तुम जानी ले कि मूसा का वजेसे पापहोन कि माफी को समाचार तुम खे दियो जास हइ. ");
INSERT INTO goj_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","अरु जो बातहोन मे तुम मूसा की व्यवस्था का वजेसे नीर्दोष नी ठैरी सकतो थो, उन्ही सब मे हर एक विश्वास करणआला ओका वजेसे नीर्दोष ठैरस हइ. ");
INSERT INTO goj_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","येका लिये चौकस र्‍हेनु, असो नी हुये कि जो भविष्यव्दक्ताहोन की किताब मे आयो हइ, तुम पर अय पड्ये. ");
INSERT INTO goj_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","हे नीन्दा करणआला देखनु, अरु चकित होनु अरु मीटी जानु. क्युकि मी तुम्हारा दिनहोन मे एक काम करुस हइ, असो काम कि अगर कोय तुम से ओकी चर्चा कर्ये, ते तुम कभी विश्वास नी कर्ये. ");
INSERT INTO goj_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","उनका बाहेर निकलता टेम दुन्या उनसे प्रार्थना करण लग्या कि दुसरा आराम का दिन हमके या बातहोन ओका से फिर सुनाइ जाये. ");
INSERT INTO goj_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","जब आराधनालय उठी गइ ते यहूदीया होन अरु यहूदीया मत मे आया हुया भक्तहोन मे से भोत सा पौलुस अरु बरनबास का पीछे हुइ गा अरु उनने उनसे बात करी खे समझायो कि परमेश्वर का अनुग्रह मे बन्या र्‍हेनु. ");
INSERT INTO goj_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","अगलो अराम का दिन नगर का प्राय खे सब दुन्या परमेश्वर को वचन सुनान खे जमा हुइ गया. ");
INSERT INTO goj_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","पन यहूदीया गर्दी खे देखी खे डाह से भरी गया, अरु नीन्दा करते हुये पौलुस की बातहोन को विरोध मे बोलन लग्या. ");
INSERT INTO goj_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","तब पौलुस अरु बरनबास ने नीडर हुइ, बोल्ये का जरुरी थो कि परमेश्वर को वचन पैयले तुम खे सुनायो जास पन जब तुम ओखे दूर अलग हइ, अरु अपना खे अनन्त जिवन का योग्य नी ठैरय ते देखनु हम गैरयहूदिहोन का तरफ फिरस हइ. ");
INSERT INTO goj_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","क्युकि प्रभु ने हम खे या आज्ञा दी हइ मे ने तोखे गैरयहूदिहोन का लिये उजालो ठैरायो हइ, ताकि तू पृथ्वी का छोर तक उध्दार का वजेसे हुये. ");
INSERT INTO goj_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","यो सुनी खे गैरयहूदिहोन खुश हुया अरु परमेश्वर को वचन की बड्यी करण लग्या. अरु जोत्ता अनन्त जिवन का लिये ठैरायो गयो थो, उनने विश्वास कर्यो. ");
INSERT INTO goj_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","तब प्रभु को वचन उ पुरा देश मे फैलन लग्यो. ");
INSERT INTO goj_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","पन यहूदीया होन ने भक्त अरु कुलीन बयहोन खे अरु नगर का प्रमुख दुन्या खे उसकायो, अरु पौलुस अरु बरनबास का विरुध्द उपद्रव कर्हे खे उनने अपनी सीमा से नीकाली दियो. ");
INSERT INTO goj_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","तब वे उनका सामने अपना पायहोन की धूल झाडि खे इकुनीयुम खे चली गया. ");
INSERT INTO goj_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","अरु चेला खुशी से अरु पवित्र आत्मा से परिपूर्ण होता गया. ");
INSERT INTO goj_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","इकुनीयुम मे असो हुयो कि वे यहूदीया होन आराधनालय प्रकार बात करी कि यहूदीयाहोन अरु यूनानीहोन दो मे से भोतझन ने विश्वास कर्यो. ");
INSERT INTO goj_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","पन विश्वास नी करणआला यहूदीयाहोन ने गैरयहूदिहोन का मन भैइहोन का विरोध मे उकसायो अरु कटुरता पइदा करी दी. ");
INSERT INTO goj_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","वे भोत दिन तक वहा र्‍हिया अरु प्रभु का भरोसा पर हिम्मत से बात करता था. अरु उ उनका हाथहोन से चिन्ह अरु अदभुत काम करी खे अपनो अनुग्रह को वचन पर गवइ देतो थो. ");
INSERT INTO goj_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","पन नगर का दुन्या मे फुट पडी गइ थी, उकासे कत्ता तो यहूदीयाहोन की तरफ अरु कात्ता प्रेरितहोनक का तरफ हूइ गया. ");
INSERT INTO goj_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","पन जब गैरयहूदिहोन अरु यहूदीया उनको अपमान अरु उन पर पथराव करण का लिये अपना सरदारहोन समेत उन पर दौड्या. ");
INSERT INTO goj_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","ते वे या बात जानी गया, अरु लुकाउनीया का लुस्त्रा अरु दिरबे नगरहोन मे अरु आस पास का प्रदेशहोन मे भागी गया. ");
INSERT INTO goj_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","अरु वहा सुसमाचार सुनान लग्या. ");
INSERT INTO goj_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","लुस्त्रा मे एक इन्सान बठौ थो, जो पाय को नगडो थो उ जन्म ही से लगडो थो अरु कभी नी चल्यो थो. ");
INSERT INTO goj_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","उ पौलुस खे बात करता सुनी र्‍हो थो. पौलुस ने ओका तरफ टकटकी लगैइ खे देख्यो कि ओखे अच्छो हुइ जान को विश्वास हइ. ");
INSERT INTO goj_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","अरु उचो बोल से बोल्यो, अपना पाय का बल सीधो खडो हो. तब उ उछली खे चलन फिरन लग्यो. ");
INSERT INTO goj_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","दुन्या ने पौलुस को यो काम देखी खे लुका उनीया की भाषा मे उचो बोल से बोल्यो देवता इन्सानहोन का रुप मे हुइ खे हमारा पास उतरी आया हइ. ");
INSERT INTO goj_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","उनने बरनबास खे ज्यूस अरु पौलुस खे हिरमेस बोल्यो क्युकि उ बात करणा मे मुख्य थो. ");
INSERT INTO goj_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","ज्यूस खे वा मदिर को पुजारी जो उनका नगर का सामने थो, बैल अरु फूलहोन को हार फाटकहोन पर लैइ खे दुन्या का साथ बलिदान करणो चाहतो थो. ");
INSERT INTO goj_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","पन बरनबास अरु पौलुस प्रेरितहोन जब यो सुन्यो ते अपना कपडा फाड्या अरु गर्दी मे लुकी खे अरु पुकारी खे बोलन लग्या. ");
INSERT INTO goj_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","हे दुन्या, तुम का करस हइ? हम भी ते तुम्हारा सामन दुख सुख भोग्या इन्सान हइ, अरु तुम खे सुसमाचार सुनास हइ कि तुम इन बेकार चिजहोन से अलग हुइ खे जीवते परमेश्वर का तरफ फिरनु, जेने स्वर्ग अरु पृथ्वी अरु समुदर अरु जो कुछ उनमे हइ बनायो. ");
INSERT INTO goj_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","ओने बीत्या टेमहोन मे सब जातहोन खे अपना अपना मार्गहोन मे चलन दियो. ");
INSERT INTO goj_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","तेभी ओने अपना आप खे बे गवाह नी छोड्यो. किन्तु उ अच्छो करता र्‍हियो, अरु स्वर्ग से बारीश अरु फलवन्त ऋतु दिके तुम्हारा मन को भोजन अरु खुशी से भरता र्‍हियो. ");
INSERT INTO goj_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","यो बोली खे भी उनने दुन्या खे बडी कठनाइ से रोक्यो कि उनका लिये बलिदान नी कर्ये. ");
INSERT INTO goj_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","पन कुछ यहूदीयाहोन ने अन्ताकिया अरु इकुनीयुम से अय खे दुन्या खे अपनी तरफ करी लियो, अरु पौलुस पर पथराव कर्यो, अरु मर्यो समझी खे ओखे नगर का बाहर घसीटी लि गया, ");
INSERT INTO goj_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","पर जब चेला ओका चारी तरफ अय खडा हुया ते उ उठी खे नगर मे गयो अरु दूसरा दिन बरनबास का साथ दिरबे खे चली गयो. ");
INSERT INTO goj_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","वे उ नगर का दुन्या को सुसमाचार सुन्ये का, अरु भोत सा चेला बन्या का लुस्त्रा अरु इकुनीयुम अरु अन्ताकिया खे लौटी आया. ");
INSERT INTO goj_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","अरु चेलाहोन का मन खे स्थिर करता र्‍हेनु अरु यो उपदेश देता था कि विश्वास मे बन्या र्‍हेनु. अरु यो बोलता था हम बडा क्लेश उठैइ खे परमेश्वर का राज्य मे प्रवेश करण खे होनु. ");
INSERT INTO goj_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","अरु उनने हर एक मंडली मे उनका लिये बुजरुक ठैरो, अरु उपास सहित प्रार्थना करी खे उनने प्रभु का हाथ सोप्यो जो पर उनने विश्वास कर्यो थो ");
INSERT INTO goj_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","तब पिसिदिया से होता हुये वे पंफूलिया पहुच्या; ");
INSERT INTO goj_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","फिर पिरगा मे वचन सुन्ये का अत्तलिया मे आया. ");
INSERT INTO goj_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","अरु वहा से वे डोंगा पर अन्ताकिया गया, जहा वे उ काम का लिये जो उनने पूरो कर्यो थो परमेश्वर का अनुग्रह मे सौप्या गया था. ");
INSERT INTO goj_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","वहा पहुची खे उनने मंडली जमा करी अरु बतायो कि परमेश्वर ने उनका साथ हुइ खे कसा बडा बडा काम कर्या अरु गैरयहूदिहोन का लिये विश्वास को दरवाजो खोली दियो. ");
INSERT INTO goj_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","अरु वे चेलाहोन का साथ भोत दिन तक र्‍हिया. ");
INSERT INTO goj_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","फिर कुछ दुन्या यहूदीया से अयखे विश्वासी सीखान लग्या “अगर मूसा कि व्यवस्था पर तुम्हारो खतनो नी होतो तुम उध्दार नी परई सक्ये.” ");
INSERT INTO goj_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","जब पौलुस अरु बरनबास को उनसे भोत वाद विवाद अरु वाद विवाद हुयो ते यो ठैरायो गयो कि पौलुस अरु बरनबास अरु उनमे से कुछ इन्सान या बात का बारे मे प्रेरितहोन अरु बुजरुक का पास यरुशलेम खे जाये. ");
INSERT INTO goj_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","आखरी मंडली ने उनका कुछ दुर तक पहुचायो. अरु वे फीनीके अरु सामरिया से होते हुये गैरयहूदिहोन को मन फिराना को समाचार सुनाता गयो, अरु सब भैइ भोत खुश हुयो. ");
INSERT INTO goj_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","जब वे यरुशलेम पहुच्या, ते मंडली अरु प्रेरित अरु बुजरुक उनसे खुशी का साथ मील्या अरु उनने बतायो कि परमेश्वर ने उनका साथ हुइ, कसा-कसा काम कर्या था. ");
INSERT INTO goj_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","पन फरीसीहोन को पंथ मे से जेने विश्वास कर्यो थो उनमे से कुछ ने उठी खे बोल्यो, “उनने खतना करणो अरु मूसा की व्यवस्था खे मानन की आज्ञा देनो चाह्यो.” ");
INSERT INTO goj_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","तब प्रेरित अरु बुजरुक या बात का बारे मे विचार करण का लिये जमा हुया. ");
INSERT INTO goj_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","तब पतरस ने भोत वाद विवाद हुइ जान का बाद खडा हुइखे उनसे बोल्यो, “हे भैइहोन अरु बहीनहोन तुम जानस हइ कि भोत दिन हुया परमेश्वर ने तुम मे से मेखे चुनी लियो कि मरा मुडा से गैरयहूदिहोन खे सुसमाचार को वचन सुन्यखे विश्वास करणु. ");
INSERT INTO goj_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","मन खे पैछाननआलो परमेश्वर ने उनका भी हमारा समान पवित्र आत्मा दिखे उनकी गवइ दी. ");
INSERT INTO goj_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","अरु विश्वास का वजेसे उनको मन अच्छो करी खे हम मे अरु उन मे कुछ भेद नी रख्यो ");
INSERT INTO goj_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","ते अब तुम का परमेश्वर की परीक्षा करस हइ कि चेलाहोन की गरदन पर असो रखन जेखे नी हमारा बापदादाहोन उठै सक्या था अरु नी हम उठै सकस हइ? ");
INSERT INTO goj_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","हा, हमारा यो नीश्चय हइ कि जो रीति से वे प्रभु यीशु को अनुग्रह से उध्दार पाये; उ रीति से हम भी पाये.” ");
INSERT INTO goj_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","तब सारी सभा चुपचाप बरनबास अरु पौलुस की सुनन लग्या कि परमेश्वर ने उनका वजेसे गैरयहूदिहोन मे कसा बडा बडा चिन्ह, अरु अदभुत काम दिखाया. ");
INSERT INTO goj_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","जब वे चुप हुया ते याकूब बोलन लग्यो हे भैइहोन अरु बहीनहोन मरी सुनो. ");
INSERT INTO goj_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","शमौन ने बतायो कि परमेश्वर ने पैयले गैरयहूदिहोन पर कसी कृपाद्दष्टी करी कि उनमे से अपना नाम का लिये एक दुन्या बनय ले. ");
INSERT INTO goj_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","येमे से भविष्यव्दक्ताहोन की बात भी मीलस हइ, जसो कि लिख्यो हइ. ");
INSERT INTO goj_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","येका बाद मी फिर अयखे दाउद को गिर्यो हुयो डेरो उठास, अरु ओका खडोरख फिर बनायु अरु ओखे खडो कर्यु. ");
INSERT INTO goj_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","येका लिये कि कुछ इन्सान, मनजो सब गैरयहूदीहोन जो मरा नाम खे बोलस हइ, प्रभु खे ढूढ्ये. ");
INSERT INTO goj_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","यो उ प्रभु बोलस हइ जो जगत की उत्पत्ति से इन बातहोन को समाचार देता आयो हइ. ");
INSERT INTO goj_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","येका लिये मरो बिचार यो हइ कि गैरयहूदिहोन मे से जो दुन्या परमेश्वर कि तरफ फिरस हइ, हम उनका दुख नी देनु. ");
INSERT INTO goj_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","पन उनखे लिखीखे भेज्यो कि वे मूर्ती की अशुध्दताहोन अरु व्यभिचार अरु गल्यो घोटे हुया को मास से अरु खुन से दूर र्‍हेनु. ");
INSERT INTO goj_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","क्युकि पुरानाजमान से नगर नगर मूसा की व्यवस्था को प्रचार करणआला होता चल्यो आया हइ, अरु उ हर अराम को दिन आराधनालय मे पडै जास हइ. ");
INSERT INTO goj_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","तब पूरी मंडली सहित प्रेरितहोन अरु बुजरुक खे अच्छो लग्यो कि अपना मे से कुछ इन्सानहोन खे चुन्नु, मंनजे यहूदा जो बरसब्बास बोलस हइ, अरु सीलास, जो भैइहोन अरु बहीनहोन मे मुखीयो थो. अरु उनने पौलुस अरु बरनबास का साथ अन्ताकिया भेजनु. ");
INSERT INTO goj_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","उनने उनका हाथ यो लिख भेज्यो. अन्ताकिया अरु सीरिया अरु मंडलीहोन, र्‍हेनआला भैइहोन अरु बहीनहोन खे जो गैरयहूदिहोन मे से हइ, प्रेरितहोन अरु बुजरुक भैइहोन बहीनहोन को नमस्कार. ");
INSERT INTO goj_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","हमने सुन्यो हइ कि हम मे से कुछ ने वहा जैइखे तुम खे अपनी बातहोन से घबर्‍यै दियो. अरु तुमारा मन उलटी दियो हइ पन हम ने उनका आज्ञा नी दी थी. ");
INSERT INTO goj_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","येका लिये हम ने एक चित्त हुइ, ठीक समझ्यो कि चुन्या हुया इन्सानहोन खे अपना प्रिय बरनबास अरु पौलुस का साथ तुम्हारा पास भेजनु. ");
INSERT INTO goj_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","यो असो इन्सान हइ जिन्हे अपनो जान हमारा प्रभु यीशु मसीह का नाम का लिये जोखिम मे डाल्यो हइ. ");
INSERT INTO goj_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","येका लिये हम ने यहूदा अरु सीलास खे भेज्यो हइ, जो अपना मेडा से भी या बातहोन बोली दिये. ");
INSERT INTO goj_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","पवित्र आत्मा खे अरु हम खे ठीक जानी पड्यो कि या जरुरी बातहोन खे छोड तुम पर अरु बोझ नी डाल्ये. ");
INSERT INTO goj_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","कि तुम मूरतो पर बलि कर्या हुया से अरु खुन से अरु गल्यो घोट्यो हुया को मास से अरु व्यभिचार से दुर र्‍हेनु. येका से दुर र्‍हेनु ते तुम्हारो भलो हुये आगे शुभ. ");
INSERT INTO goj_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","फिर वे बिदा हुइखे अन्ताकिया पहुची खे अरु सभा खे जमा करी का वा चिट्ठी उनखे दी दी. ");
INSERT INTO goj_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","वे चिट्ठी पडीखे वा उपदेश की बात से खुब खुश हुया. ");
INSERT INTO goj_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","यहूदा अरु सीलास भैइहोन अरु बहीनहोन खे उपदेश दिखे स्थिर कर्यो. ");
INSERT INTO goj_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","वे कुछ दिन र्‍हिखे भैइहोन अरु बहीन से शांती का साथ बिदा हुया कि अपना भेजनआला का पास जानु. ");
INSERT INTO goj_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","पन सीलास का वहा र्‍हेनो अच्छो लग्यो ");
INSERT INTO goj_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","पौलुस अरु बरनबास अन्ताकिया मे र्‍हि गया. अरु दुसरा भोत सा दुन्या का साथ प्रभु को वचन को उपदेश करतो अरु सुसमाचार सुनातो र्‍हियो. ");
INSERT INTO goj_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","कुछ दिन बाद पौलुस ने बरनबास से बोल्यो, जो जो नगरहोन मे हम ने प्रभु को वचन सुनायो थो, आओ फिर उनमे चलीखे अपना भैइहोन अरु बहीन खे देख्यो कि वे कसा हइ. ");
INSERT INTO goj_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","तब बरनबास ने यहून्ना को जो मरकुस बोल्या जास हइ, साथ लेन को बिचार कर्यो. ");
INSERT INTO goj_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","पन पौलुस ने ओखे जो पंफूलिया मे उनसे अलग हुइ गयो थो, अरु काम पर उनका साथ नी गयो, साथ लि जानो अच्छो नी समझ्यो. ");
INSERT INTO goj_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","आखरी असो विवाद उठौ कि वे एक दुसरा से अलग हूइ गया. अरु बरनबास, मरकुस खे लिखे डोंगा पर साइप्रस चली गयो. ");
INSERT INTO goj_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","पन पौलुस ने सीलास खे चुनी लियो, अरु भैइहोन अरु बहीन से परमेश्वर को अनुग्रह मे सौप्यो जैइखे वहा से चली गयो. ");
INSERT INTO goj_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","अरु उ मंडलीहोन खे स्थिर करता हुया सीरिया अरु किलिकिया से होता हुया नीकल्यो. ");
INSERT INTO goj_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","14 फिर उ दिरबे अरु लुस्त्रा मे भी गयो, वहा ती तीमुथियुस नाम को मसीह विश्वासी थो ओकी माय यहूदीया विश्वासी थी जबकी ओको बाप यूनानी थो. ");
INSERT INTO goj_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","उ लुस्त्रा अरु इकुनीयुम को भैइहोन अरु बहीन मे सुनाम थो. ");
INSERT INTO goj_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","पौलुस की इच्छा थी कि उ ओका साथ चल्ये. अरु जो यहूदी इन्सान उन जगाहोन मे थो उनकारण ओने ओको खतनो कर्यो, क्युकि वे सब जानता था, कि ओको बाप यूनानी थो. ");
INSERT INTO goj_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","अरु नगर नगर जाता हुया वे उन विधीहोन खे जो यरुशलेम का प्रेरितहोन अरु बुजरुकहोन ने ठैराइ थी मानना का लिये उनने पहुचाता जाता था. ");
INSERT INTO goj_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","यो प्रकार मंडलीहोन विश्वास मे स्थिर होती गइ अरु गिनती मे हरदिन बडती गइ. ");
INSERT INTO goj_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","वे फ्रुगिया अरु गलातिया प्रदेशहोन मे से हुइखे गया, क्युकि पवित्र आत्मा ने उनका आसिया मे वचन सुनाना से मना कर्यो. ");
INSERT INTO goj_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","उनने मूसिया का पास पहुचीखे बिथुनीया मे जान को चायो. पन यीशु का आत्मा ने उनका जान नी दियो. ");
INSERT INTO goj_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","आखीर मे मूसिया से हुइ, त्रोआस मे आया. ");
INSERT INTO goj_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","वहा पौलुस ने रात खे एक दर्शन देख्यो कि एक मकिदुनी इन्सान खडो हुयो, ओकासे प्रार्थना करीखे बोलस हइ, “पार उतरीखे मकिदुनी मे आ अरु हमारी मद्दत कर.” ");
INSERT INTO goj_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","ओको यो दर्शन देखता ही हमने जल्दी मकिदुनीया जानो चायो, यो समझीखे कि परमेश्वर ने हम खे उनको सुसमाचार सुनान का लिये बुलायो हइ. ");
INSERT INTO goj_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","येका लिये त्रोआस से डोंगा खोलीखे हम सीधा सुमात्रा खे अरु दूसरा दिन नीयापुलीस मे आया. ");
INSERT INTO goj_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","वहा से हम फिलिप्पी मे पहुच्या जो मकिदुनी देस को मेख्य नगर मे कुछ दिन तक र्‍हिया. ");
INSERT INTO goj_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","अराम का दिन हम नगर का फाटक का बाहेर नद्दी का किनारा यो समझी खे गया कि वहा प्रार्थना करण कि जगा हुये. अरु बठीखे वे बयहोन से जो जमा हुइ थी, बात करण लग्या. ");
INSERT INTO goj_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","अरु लुदिया नाम थुआतीरा नगर का कबरा कपडा बेचनआली एक बय सुनी र्हि थी.अरु प्रभु ने ओको मन खोल्यो कि जब पौलुस कि बातहोन पर मन लगाये. ");
INSERT INTO goj_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","अरु जब लुदिया ने ओने अपना घराना सहित बपतिस्मा लियो, ते ओने प्रार्थना करी, “अगर तुम मेखे प्रभु कि विश्वासिनी समझस हइ, ते चलिखे मरा घर मे र्‍हे,” अरु वा हम खे मन्य खे लि गइ. ");
INSERT INTO goj_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","एक दिन हम जब प्रार्थना करण कि जगा जैइ र्‍हा था ते हम खे एक जवान दासी मीली, जोमे भविष्य बतान आली अशुध्द आत्मा थी अरु भविष्य बताना से अपना का लिये भोत कुछ कमय खे लाती थी. ");
INSERT INTO goj_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","वा पौलुस का तरफ हमारा पीछे अयखे चिल्लान लगी, “यो इन्सान अच्छो परमेश्वर को सेवक हइ, जो हम खे उध्दार रस्ता कि कथा सुनास हइ.” ");
INSERT INTO goj_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","वा भोत दिन तक असो हि करती रही, पन पौलुस परेशान हुयो अरु पलटी खे वा आत्मा मी तोखे यीशु मसीह का नाम से आज्ञा देउस हइ, कि ओमे से नीकली जा अरु वा उ टेम मे नीकली गइ. ");
INSERT INTO goj_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","जब वा पोर्यइ खे स्वामीहोन ने देख्यो कि हमारी कमइ कि आस जाती र्ही ते पौलुस अरु सीलास खे पकडी खे चौक मे प्रधानहोन का पास खीची खे ली गया. ");
INSERT INTO goj_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","अरु उनखे रोमन अधिकारीहोन का पास लि जैखे बोल्यो, ये दुन्या जो यहूदीया हइ, हमारा नगर मे बडी हलचल मची र्‍हा हइ. ");
INSERT INTO goj_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","अरु असी रीति रीवाज बतैइ र्‍हा हइ, जेखे अपनानो या माननो हम रोमीहोन का लिये ठिक नी. ");
INSERT INTO goj_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","तब गर्दी का दुन्या उनका विरोध मे सीलास अरु पौलुस जमा हुइ, चड आया, तब शासकहोन ने उनका कपडा फाड्या, अरु उनका फटका मारन कि आज्ञा दी. ");
INSERT INTO goj_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","अरु भोत फटका लगैइखे उनने उनका बन्दीगृह मे डाली दियो अरु दरोगा खे आज्ञा दि कि उनका पक्की चैकीदारी मे रख. ");
INSERT INTO goj_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","उनसे असी आज्ञा मीलीखे उनका अंदर कि बन्दीगृह मे रख्यो अरु उनका पाय काटा मे ठोकी दियो. ");
INSERT INTO goj_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","आधी का नजीकपास पौलुस अरु सीलास प्रार्थना करता हुया परमेश्वर को भजन गय र्‍हा था. ");
INSERT INTO goj_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","कि येतना मे अचानक एक भूकम्प हुयो, ह्या तक कि बन्दिघर को पय्यो हली गयो, अरु जल्दी सब दरवाजा खुली गया. अरु सब का बन्धन खुल गया. ");
INSERT INTO goj_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","अरु जेलर जाग उठौ, अरु बन्दीगृह को दरवाजा खुल्या देखीखे समझ्यो कि कैदी भागी गया, आखीर ओने तलवार खीची खे अपना आप खे मारी डालनो चायो. ");
INSERT INTO goj_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","पर पौलुस ने उचो बोल से पुकारी खे बोल्यो, “अपना आप खे कुछ नुकसान मत पहुचा, क्युकि हम सब यही हइ.” ");
INSERT INTO goj_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","तब जेल को जेलर मशाल बनय अरु जल्दी से अंदर गयो अरु डर से कापता हुये पौलुस अरु सीलास जका सामने गिर्यो. ");
INSERT INTO goj_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","अरु उनखे बाहेर लीखे बोल्यो, हे सज्जनहोन को उध्दार मीलन का लिये प्रभु ने बोल्यो मी का करु? ");
INSERT INTO goj_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","उनने बोल्यो, प्रभु यीशु पर विश्वास कर, ते तू अरु तरो घरानो उध्दार पाये. ");
INSERT INTO goj_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","अरु उनने ओखे अरु ओका सब घर का दुन्या, प्रभु को वचन सुनायो. ");
INSERT INTO goj_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","अरु रात खे उ टेम जोलर ने उनखे , ली जैइखे उनका पाय धोया, अरु ओने अपना सब दुन्या समेत जल्दी बपतिस्मा लियो. ");
INSERT INTO goj_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","अरु ओने उनखे अपना घर मे लै जैइखे उनका आगे खानो रख्यो अरु पुरा घराना समेत परमेश्वर पर विश्वास करी खे आनन्द कर्यो. ");
INSERT INTO goj_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","जब दिन हुयो तब रोमन अधिकारी का हात बुलाओ भेज्यो कि वे इन्सानहोन खेछोड दे. ");
INSERT INTO goj_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","जेलर ने या बात पौलुस से बोली, सुनइ, “शासकहोन ने तुमखे छोडी देन कि आज्ञा भेजी दि हइ, येका लिये नीकलिखे आनन्द से चली जा” ");
INSERT INTO goj_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","पर पौलुस ने अधिकारीहोन से बोल्यो, “उनने अधिकारी जो हम रोमी नागरीत्वआला दुन्या हइ, दोषी ठैराया बिना दुन्या का सामने मार्यो अरु बन्दीगृह मे डाल्यो, अरु अब का चुपचाप से नीकाली देस हइ? असो नी पर वे खुद अयखे हमखे बाहेर लि जाये.” ");
INSERT INTO goj_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","सैनीकहोन अधिकारीहोन ने या बातहोन कि जानकारी रोमी अधिकारीहोन खे सुचना दि अरु जब उनने सुन्यो कि पौलुस अरु सीलास रोमन नागरीक हइ, ते वे डरी गया. ");
INSERT INTO goj_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","तब रोमन अधिकारीहोन ने अयखे नगर खेछोडी जानखे बोल्यो अरु बाहेर ली जैइखे प्रार्थना करी कि नगर से चली जा. ");
INSERT INTO goj_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","वे बन्दीगृह से नीकलीखे लुदिया का घर गया, अरु विश्वासी भैइहोन अरु बहीन से मीली खे उनखे दिलासा कि बात बोली अरु चली गया. ");
INSERT INTO goj_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","फिर वे पौलुस अरु सीलास अपुल्लोनीया हुइ थिस्सलुनीखे मे आया, जहा यहूदीयाहोन को एक आराधनालय थो. ");
INSERT INTO goj_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","अरु पौलुस अपना रीति का जसो आराधनालय मे गयो, अरु तीन अराम का दिन पवित्रशास्त्र से उनका साथ वाद विवाद कर्यो. ");
INSERT INTO goj_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","अरु उनको अर्थ सरल भाषा मे खोली-खोलीखे समझातो थो कि मसीह को दुख उठानो, अरु मर्या हुया मे से जी उठनो, जरुरी थो. अरु यो यीशु जोकी मी तुमखे कथा सुनउस हइ, कि मसीह हइ. ");
INSERT INTO goj_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","उनमे से केत्ता ने, अरु भक्त यूनानीहोन मे से भोतझन ने अरु भोत कुलीन बयहोन ने मानी लियो, अरु पौलुस अरु सीलास का साथ मीली गया. ");
INSERT INTO goj_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","पर यहूदीयाहोन ने गुस्सा से भरीखे बजारु दुन्या मे से कुछ आवारो इन्सानहोन खे अपना साथ मे लियो, अरु गर्दी लगैइखे शहर मे हल्लो मचान लग्या, अरु यासोन का घर पर चढाइ करी खे अरु कोशीस करण लग्या पौलुस अरु सीलास खे दुन्या का सामने लानो चायो. ");
INSERT INTO goj_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","अरु उनखे नी मीलीखे वे यो चिल्लाता हुया यासोन अरु कुछ विश्वासी भैइहोन का नगर का हाकिमहोन का सामने खीची खे लाये अरु बोलन लग्या ये दुन्या जेने जगत का मुसीबत पइदा करी दि हइ, ह्या भी आया हइ. ");
INSERT INTO goj_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","अरु यासोन ने उनने अपना घर मे ठैरायो हइ, अरु कैसर राजा की आज्ञाहोन को विरोध करस हइ. ");
INSERT INTO goj_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","जब गर्दी अरु नगर, शासकहोन ने या बातहोन सुनी खे दुन्याहोन खे भड का यो ते वे परेशान हुइ गया. ");
INSERT INTO goj_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","अरु उनने यासोन अरु बाकी दुन्याहोन खे जमानत पर छोडी दियो. ");
INSERT INTO goj_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","विश्वासी भैइहोन ने जल्दी रात हि रात पौलुस अरु सीलास को बिरीया मे भेजी दियो का अरु वे वहा पहुची कि यहूदीयाहोन खे आराधनालय मे गया. ");
INSERT INTO goj_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","ये दुन्या तो थिस्सलुनीखे का दुन्या से जादा अच्छा था अरु उनने बडी लालसा से वचन ग्रहन कर्यो, अरु हरदिन शास्त्र को पड्यैइ करता देख्यो कि जो पौलुस कि पुरी बात सही हइ कि नी. ");
INSERT INTO goj_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","यको परीनाम स्वरुप भोत सा यहूदीया अरु महत्व पुर्ण गैरयहूदिहोन मे से देख्यो थो भोतझन ने, अरु यूनानी कुलीन बयहोन मे से अरु इन्सानहोन मे से भोतझन ने विश्वास कर्यो. ");
INSERT INTO goj_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","पन जब थिस्सलुनीखे का यहूदीया जानी गया कि पौलुस बिरीया मे भी परमेश्वर को वचन सुनास हइ, ते वहा भी अय खे दुन्या खे भडकानो अरु दंगा करवाना मे लग्या. ");
INSERT INTO goj_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","तब विश्वासी भैइहोन ने जल्दी पौलुस कए बिदा कर्यो कि समुद्र का किनार चली जा. पन सीलास अरु तीमुथियुस व्हा र्‍हि गो ");
INSERT INTO goj_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","पौलुस का विश्वासी भैइहोन ने एथेस तक पोचय दियो, अरु सीलास अरु ती तीमुथियुस का लिये यो आज्ञा लिका बिदा हुया कि मरा पास जल्दी भेज्यो. ");
INSERT INTO goj_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","जब पौलुस एथेस अरु सीलास अरु तीमुथियुस का लिये इंतजार करी रा था, ते उ भोत परेशान थो जब ओने देख्यो कि शहर मे मूर्तिहोन से भर्यो देखी खे ओकी आत्मा जल उठ्यो. ");
INSERT INTO goj_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","आखरी उ यहूदीया आराधनालय मे यहूदीयाहोन अरु गैरयहूदिहोन जो परमेश्वर कि उपासना करता था, अरु चौक मे जो दुन्या मीलता था उनसे हर दिन वाद विवाद कर्या करतो थो. ");
INSERT INTO goj_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","तब इपिकुरी अरु स्तोइकी मास्‍तर मे से कुछ ओकासे तर्क करण लग्या, अरु कोय ने बोल्यो, यो काय बलवादी का बोलनो चाहस हइ? पन दुसरा ने बोल्यो का उ दुसरा देवताहोन को प्रचारक मालुम पडस हइ, क्युकि उ यीशु का तरफ पुनरुत्थान को सुसमाचार सुनानो थो. ");
INSERT INTO goj_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","तब वे पौलुस अपना अरियुपगुस नगर का सभा मे लिखे गया अरु पुछ्यो, हम जानी सकस हइ नइ शिक्षा जो बतैइ र्‍हा हइ, का हइ? ");
INSERT INTO goj_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","क्युकि तू अनोखी बातहोन हम खे सुनास हइ, येकालिये हम जाननो चाहस हइ कि इनको मतलब का हइ? ");
INSERT INTO goj_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","येका लिये कि सब एथेस वासी अरु परदेसी जो वहा र्‍हेता था नइ-नइ बातहोन बोलन अरु सुनना का सिवाय अरु कोय काम मे टेम मे नी बिताथा था. ");
INSERT INTO goj_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","तब पौलुस नगर कि सभा का अरियुपगुस का बीच मे खडो हुइ खे बोल्यो का, हे एथेस का दुन्याहोन, मे देखुस हइ कि तुम हर बात मे देवताहोन खे बडा धार्मीक माननआला हुये. ");
INSERT INTO goj_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","क्युकि मी नगर मे फिरते हुये तुम्हारी आराधना करण कि जगा खे देखी र्‍हो थो, ते एक वेदी भी पाइ, जेका पर लिख्यो थो, अनजाना परमेश्वर का लिये येका लिये जेको तुम बिना जाने परमेश्वर कि आराधना करस हइ, ");
INSERT INTO goj_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","जो परमेश्वर ने जगत अरु ओकी सब चिजहोन खे बनायो, उ स्वर्ग अरु धरती को स्वामी हुइ खे हाथ कि बनाया हुया मन्‍दिर मे नी र्‍हे. ");
INSERT INTO goj_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","नी कोय चिज की जरुरत करण इन्सानहोन का हाथहोन कि सेवा लेस हइ, क्युकि उ तो आप ही सब के जिवन अरु सास अरु सब कुछ देस हइ. ");
INSERT INTO goj_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","ओने एक ही इन्सान का वजेसे पुरा इन्सानहोन कि नीर्मीती करी सारी धरती उनखे र्‍हेन का लिये बनइ. अरु ओने दुन्या को टेम ठैर्यो खे दियो अरु उनका जगाहोन खे जहा वे र्‍हेस हइ ओकि सिमाहोन बाधी हइ. ");
INSERT INTO goj_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","यो येका लिये कर्यो कि दुन्या परमेश्वर खे ढुड्ये, अरु हुइ सकस हइ वे ओका तक पहुची खे पैयले लिखे फिर भी उ कोय से दुर नी हइ. ");
INSERT INTO goj_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","क्युकि हम ओमे जीन्दा र्‍हेस, अरु चलता फिरता, अरु स्थिर र्‍हेस हइ अस्तित्व हइ यो प्रकार खुद तुम्हारा कुछ कविहोन ने भी बोल्यो हइ, हम तो ओका कुल भी हइ. ");
INSERT INTO goj_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","आखीर परमेश्वर को कुल हुइ खे हम खे यो समझानो अच्छो नी कि परमेश्वर का सोन्नो या चादी या पत्थर का जसा हइ, जो इन्सान कि कारागीर अरु कल्पना से बनायो गयो हइ. ");
INSERT INTO goj_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","येका लिये जब दुन्या परमेश्वर खे नी समझ सक्ये कि टेम मे होन पर ध्यान नी दिये, पर अब हर जगा सब इन्सानहोन खे मन फिरान की आज्ञा देस हइ. ");
INSERT INTO goj_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","क्युकि परमेश्वर ने एक दिन नीश्चित कर्यो हइ अपनो नीयुक्त कर्या गया एक इन्सान का वजेसे धार्मीकता से जगत को न्याय कर्ये, जेखे ओने ठैरायो हइ अरु ओखे मर्या हुया मे से जिलयखे या बात सब पर प्रमाणित करी दी हइ. ");
INSERT INTO goj_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","मर्या हुया खे पुनरुत्थान कि बात सुन्ये का खे त्ता तो मजाक मजाक उखान लग्या, पन अरु पर दुसरा दुन्या से. “बोल्यो कि या बात फिर से सुन्नु चाहस हइ.” ");
INSERT INTO goj_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","येका पर पौलुस उनका बीच मे से चली गयो. ");
INSERT INTO goj_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","पन कुछ इन्सान ओका साथ मीलि गया, अरु विश्वास कर्यो जेमे दियुनुसियुस जो अरियुपगुस को मुखियो थो, अरु दामरीस नाम की एक बय थी, अरु उनका साथ कुछ दुन्या था. ");
INSERT INTO goj_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","येका बाद पौलुस एथेस खे छोडी खे कुरिन्थुस मे आयो. ");
INSERT INTO goj_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","अरु वहा अक्विला नाम को एक यहूदीया मील्यो, जेको जन्म पुन्तुस मे हुयो थो. अरु अपनी लुगइ प्रिस्किल्ला का साथ इटली से हाल ही मे आयो थो, क्युकि क्लौदियुस ने सब यहूदीयाहोन खे रोम से नीकली जान की आज्ञा दी थी, येका लिये उ उनका ह्या गयो. ");
INSERT INTO goj_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","अरु एक ही साथ र्‍हेतो थो ओको अरु उनको एक ही व्यापर थो. ");
INSERT INTO goj_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","अरु उ हर येक आराम का दिन आराधनालय मे वाद विवाद करी खे यहूदीयाहोन अरु यूनानीहोन खे भी समझातो थो. ");
INSERT INTO goj_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","जब सीलास अरु तीमुथियुस मकिदुनी से आया, ते पौलुस वचन सुनान कि धुन मे लगी खे यहूदीयाहोन खे गवइ देतो थो कि यीशु हि मसीह हइ. ");
INSERT INTO goj_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","पन जब वे विरोध अरु नीन्दा करण लग्या, ते ओने अपना कपडा झटकी खे ओकासे बोल्यो, “तुम्हारो खुन तुम्हारा माथा पर र्‍हिये? मी नीर्दोष हइ, तुम्हारा मरन को कारन तुम ही हइ अरु अब से मी गैरयहूदिहोन का पास जायु.” ");
INSERT INTO goj_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","अरु वहा से चली खे वहा तीतुस यूस्तुस नाम परमेश्वर को एक भक्त का घर मे आया, जोको घर आराधनालय से लग्यो हुयो थो. ");
INSERT INTO goj_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","तब आराधनालय को सरदार क्रिस्पुस ने अपना पुरा घराना समेत प्रभु पर विश्वास कर्यो. अरु भोत से कुरिन्थवासी ने संदेश सुनी खे विश्वास कर्यो अरु बपतिस्मा लियो. ");
INSERT INTO goj_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","अरु प्रभु ने रात खे दर्शन का वजेसे पौलुस से बोल्यो, “मत डर, क्युकी बोल्ये जो अरु चुप मत र्‍हेनु. ");
INSERT INTO goj_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","क्युकि मी तरा साथ हइ, अरु कोय तरा पर चडाइ करी खे तरो नुकसान नी कर्ये. क्युकि यो नगर मे मरा भोत सा दुन्या हइ.” ");
INSERT INTO goj_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","येका लिये उ उनमे परमेश्वर को वचन सिखाता हुया देड साल तक र्‍हियो. ");
INSERT INTO goj_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","जब गल्लिहोन अखाया देश को राज्यपाल थो ते यहूदीया दुन्या एक मत करी खे पौलुस पर चडी आया, अरु ओखे न्याय आसन का सामने लायो, अरु बोलन लग्या, ");
INSERT INTO goj_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","“यो इन्सान दुन्या खे समझास हइ, कि परमेश्वर कि उपासना असा रीति से करणु, जो हमारा व्यवस्था को विपरीत हइ.” ");
INSERT INTO goj_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","जब पौलुस बोलना पर थो, ते गल्लिहोन ने यहूदीयाहोन से बोल्यो, “हे यहूदीयाहोन अगर यो कुछ अन्याय या दुष्टता कि बात होती ते अच्छो थो कि मी तुम्हारी सुनुस. ");
INSERT INTO goj_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","पन अगर यो वाद विवाद शब्दहोन, अरु नामहोन अरु तुम्हारी खुद की व्यवस्था का बारे ते तुम ही जाननु. क्युकि मी या बातहोन को न्यायी बन्नो नी चाहुस,” ");
INSERT INTO goj_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","अरु ओने उनखे न्याय आसन का सामने से नीकाल दियो. ");
INSERT INTO goj_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","तब सब दुन्या ने आराधनालय का सरदार खे सोस्‍थिनेस को न्याय आसन का सामने मार्यो, पन गल्लिहोन ने या बातहोन खे कुछ भी ध्यान नी दियो. ");
INSERT INTO goj_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","आखरी पौलुस भोत दिन तक कुरीन्तु र्‍हियो, फिर भैइहोन से बिदा लिखे डोंगा से सीरिया चल पड्या तब यीशु का साथ प्रिस्किल्ला अरु अक्विला थी पौलुस ने किंख्रिया मे येका लिये माथो मुडायो, क्युकि ओने मन्नत मागी थी. ");
INSERT INTO goj_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","अरु ओने इफिसुस मे पोचिखे उनका वहा छोड्यो, अरु खुद हि आराधनालय मे जैखे यहूदीयाहोन से वाद विवाद करण लग्यो. ");
INSERT INTO goj_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","जब वहा का दुन्या ने ओकासे प्रार्थना करी खे हमारा साथ अरु कुछ दिन र्‍हियो, ते ओने स्वीकार नी कर्यो. ");
INSERT INTO goj_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","पन यो बोलि खे उनसे बिदा हुयो, “अगर परमेश्वर चाह्ये ते मी तुम्हारा पास फिर आयु” तब इफिसुस से डोंगो खो लिखे चली दियो. ");
INSERT INTO goj_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","तब कैसरिया मे उतरी खे यरुशलेम खे गयो अरु मंडली खे नमस्कार करी खे अन्ताकिया मे आयो. ");
INSERT INTO goj_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","फिर कुछ दिन र्‍हि खे वहा से चली गयो, कुछ टेम मे बितै खे गलातिया क्षेत्र अरु फ्रुगिया मे सब चेलाहोन को विश्वास मे स्थिर करतो फिर्यो. ");
INSERT INTO goj_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","अपुल्लोस नामको एक यहूदीया जोको जन्म सिकन्दरिया मे हुयो थो, जो विद्वान इन्सान थो अरु शास्त्रहोन को अच्छी तरह से जानतो थो इफिसुस मे आयो. ");
INSERT INTO goj_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","ओने प्रभु को मार्ग कि शिक्षा पाइ थी, अरु पुरा आत्मा से यीशु का बारे मे अच्छो अच्छो सुनातो अरु सिखातो थो, पन उ फक्त यहून्ना को बपतिस्मा कि बात जानतो थो. ");
INSERT INTO goj_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","उ आराधनालय मे नीडर हुइ खे बडबडान लग्या, पर प्रिस्किल्ला अरु अक्विला उसकी बातहोन सुनी खे ओखे अपना ह्या लि गयो अरु परमेश्वर को रस्ता ओखे अरु भी ठिक रुप से बतायो. ");
INSERT INTO goj_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","येका बाद अपुल्लोस मे आयो, अखाया का पास जान को फैसलो कर्यो, येका लिये इफिसुस का विश्वासीहोन खे लिखी खे उनकी मद्दत करी, जब उ आयो, ते उ वे दुन्या का लिये एक बडो मददतगार थो, जो परमेश्वर कि कृपा से विश्वास करण आला था. ");
INSERT INTO goj_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","अपुल्लोस ने अपनी शक्ति अरु कौशल का साथ यहूदीयाहोन को सार्वजनीक रुप से कर्यो पवित्रशास्त्र से प्रमाण दि दिखे कि यीशु हि मसीह हइ. ");
INSERT INTO goj_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","जब अपुल्लोस कुरिन्थुस मे थो, ते पौलुस उपर का पुरा देश से हुइ खे इफिसुस मे आयो अरु वहा कुछ चेला मील्या. ");
INSERT INTO goj_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","ओने उनसे पुच्छो, तुम ने विश्वास करता टेम मे पवित्र आत्मा पायो उनने ओकासे बोल्यो, “हमने तो पवित्र आत्मा कि बातचित भी नी सुनी.” ");
INSERT INTO goj_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","ओने उनसे बोल्यो “ते फिर तुम ने कोको बपतिस्मा लियो?” उनने बोल्यो, “यहून्ना को बपतिस्मा,” ");
INSERT INTO goj_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","पौलुस ने बोल्यो “यहून्ना ने यो पाप से मन फिराव को बपतिस्मा दियो, कि जो मरा बाद आनआलो हइ, ओ पर मंनजे यीशु पर विश्वास करणु.” ");
INSERT INTO goj_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","यो सुनीखे उनने प्रभु यीशु को नाम को बपतिस्मा लियो. ");
INSERT INTO goj_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","अरु जब पौलुस ने उन पर हाथ रख्यो, ते उन पर पवित्र आत्मा उतर्यो, अरु वे अलग अलग भाषा बोलन अरु भविष्यवाणी करण लग्या. ");
INSERT INTO goj_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","ये सब बारा इन्सानहोन था. ");
INSERT INTO goj_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","अरु पौलुस यहूदीया आराधनालय मे जैखे तीन महीना तक नीडर हुइ खे बोलतो र्‍हियो, अरु परमेश्वर का राज्य का बारे मे वाद विवाद करतो अरु उनने समझातो र्‍हियो. ");
INSERT INTO goj_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","पन जब कुछ दुन्या ने कठोर हुइ खे ओकी नी मानी क्युकी दुन्या का सामने या रस्ता को बुरो बोलन लग्या, ते ओने ओखे छोडी खे चेलाहोन खे अलग करी लियो, अरु हरदिन तुरन्नुस कि यो कुल मे वाद विवाद कर्या करतो थो. ");
INSERT INTO goj_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","दो साल तक यो होतो र्‍हियो, ह्या तक कि आसिया का प्रात मे र्‍हेनआला, यहूदीया का यूनानी सब ने प्रभु को वचन सुनी लियो. ");
INSERT INTO goj_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","अरु परमेश्वर पौलुस का हाथ से सामर्थ का अद्भुत काम दिखातो थो. ");
INSERT INTO goj_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","ह्या तक कि दस्ती अरु डुप्पट्टो ओका आंग से चिपकी खे बीमारहोन पर डालता था, अरु उनकी बीमारीहोन दुर हुइ जाती थी. अरु बुरीआत्‍माहोन उनमे से नीकली जाया करती थी. ");
INSERT INTO goj_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","पन कुछ यहूदीया जो बुरीआत्मा नीकाल न आला फिरता था, यो करण लग्या कि जेका मे बुरीआत्‍मा हुये “उन पर प्रभु यीशु नाम को प्रचार पौलुस करस हइ. कामी तुम खे ओकी कसम देउस हइ.” ");
INSERT INTO goj_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","अरु सिक्का ओका नाम को एक यहूदीया प्रधान याजक को सात बेटा था, वे यइ था. ");
INSERT INTO goj_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","पर बुरीआत्‍मा ने जवाब दियो, “यीशु खे मी जानुस हइ, अरु पौलुस खे भी पहचानस हइ, पर तुम कोन आय?” ");
INSERT INTO goj_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","अरु उ इन्सान ने जोमे बुरीआत्‍मा थी. उन पर झपटी खे अरु उनका मे लि खे उन पर असो उपद्रव कर्यो, कि वे नंगा अरु घायल हुइ खे उ घर से नीकली भाग्या. ");
INSERT INTO goj_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","अरु या बात इफिसुस खे र्‍हेनआला यहूदीया अरु यूनानी भी सब जानी गया, अरु उन सब पर डर छै गयो. अरु प्रभु यीशु, का नाम की बडाइ हुइ. ");
INSERT INTO goj_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","अरु जेने विश्वास कर्यो थो, उनमे से भोतजन ने अय खे अपना-अपना बुरा काम हुइखे मानी लियो अरु प्रगट कर्यो. ");
INSERT INTO goj_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","अरु जादु टोना करणआला होन मे से भोतजन ने अपनी अपनी पोथिहोन जमा करी खे सब का सामने जलै दी. अरु जब उनको दाम जोड्यो गयो, जो पचास हजार चादी, का सिक्का होन का बराबर नीकल्यो. ");
INSERT INTO goj_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","यो प्रकार प्रभु को वचन बल पूर्वक फैलतो गयो अरु मजबुत होतो गयो. ");
INSERT INTO goj_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","जब या बातहोन हुइ चुकी ते पौलुस ने आत्मा मे ठान्यो कि मकिदुनी अरु अखाया से हुइ खे यरुशलेम का जायु, अरु किधर, “वहा जान का बाद मेखे रोम खे भी देखनु जरुरी हइ.” ");
INSERT INTO goj_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","येका लिये अपनी सेवा करणआला होन मे से तीमुथियुस अरु इरास्तुस खे मकिदुनी मे भेजी खे खुद कुछ दिन आसिया मे र्‍हि गयो. ");
INSERT INTO goj_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","उ टेम इफियुस मे प्रभु को रस्ता का बारे मे बडो हंगामो हुयो. ");
INSERT INTO goj_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","उ दिमेत्रियुस नाम को एक सोनार थो जो अरतिमीस चादी को काम करतो थो, अरु कारीगर को भोत फायदो होतो थो. ");
INSERT INTO goj_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","ओने उनका असी चिजहोन का कारीगरहोन खे जमा करीखे बोल्यो, “हे इन्सानहोन खे तुम जानस हइ कि यो काम से खे त्तो धन मीलस हइ. ");
INSERT INTO goj_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","अरु तुम देखस अरु सुनस हइ कि फक्त इफिसुस ही मे नी, क्युकी नजीकपास पुरा आसिया मे यो बोलि बोलिखे पौलुस ने भोत दुन्या खे समझायो अरु भरमायो भी हइ, कि जो हाथ से बनायो गया देवहोन हइ इश्वर नी. ");
INSERT INTO goj_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","अरु अब फक्त योही एक बात को डर नी कि हमारा यो धन्धा कि प्रतीष्ठा जाती र्‍हिये. क्युकी ह्या कि महान देवी अरतिमीस की मन्‍दिर तुच्छ समझे जाये अरु जेखे पुरो आसिया अरु जगत पुजस हइ ओको सम्मान घटतो र्‍हिये.” ");
INSERT INTO goj_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","जब गर्दी ने सुनीखे घुस्सा से भरी गया अरु चिल्य खे बोलन लग्यो, “इफिसिहोन की अरतिमीस की देवी, महान हइ.” ");
INSERT INTO goj_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","अरु पुरा नगर मे बडो हगामो मची गयो अरु दुन्या ने गयुस अरु अरिस्तर्खुस खे मकिदुनी, जो पौलुस का संग यात्री था, पकडी लियो, अरु एक साथ हुइ खे रंगइस्कुल मे दौडी गया. ");
INSERT INTO goj_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","जब पौलुस ने दुन्या का पास अंदर जानो चायो ते चेलाहोन ने ओखे जान नी दियो. ");
INSERT INTO goj_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","आसिया का शासकहोन मे से भी ओको कोय दोस्तहोन ने ओका पास संदेशहोन भेज्यो अरु प्रार्थना करी खे कि रगिस कुल मे जै खे जोखिम नी उठानु. ");
INSERT INTO goj_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","वहा कोय कुछ चिल्लातो थो, अरु कोय कुछ. क्युकि सभा मे बडी गडबडी हुइ र्‍हि थी, अरु भोत सा दुन्या तो यो जानता भी नी था कि वे को, लिये जमा हुया हइ. ");
INSERT INTO goj_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","तब उनने सिकन्दर खे जोख यहूदीयाहोन ने खडो कर्यो थो, गर्दी मे से आगे बडायो, अरु सिकन्दर हाथ से इशारो करी खे दुन्याहोन का सामने जवाब देनो चाहतो थो. ");
INSERT INTO goj_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","पन जब उनने जानी लियो कि उ यहूदीया हइ, ते सब एक शब्द से कोय दो घंटा तक चिल्लाते र्‍हियो, इफिसिहोन कि अरतिमीस देवी, महान हइ. ");
INSERT INTO goj_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","हे इफिसिहोन का दुन्या पुरा जगत मे एक असो इन्सान जो नी जानतो थो कि अरु स्वर्ग से अरतिमीस, “गड्यो हुयो पत्थर हइ ");
INSERT INTO goj_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","आखरी जब कि या बातहोन को खण्डन ही नी हुइ सक्येका ते अच्छो हइ, कि तुम शान्त र्‍हिये. अरु बीना सोचे बिचार कुछ नी करणु. ");
INSERT INTO goj_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","क्युकि तुम इन इन्सानहोन का लाया हइ, जो न मन्‍दिर खे लुटनआला हइ, अरु न हमारी देवी का नीन्दक हइ. ");
INSERT INTO goj_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","अगर दिमेत्रियुस अरु ओका साथी कारीगरहोन का कोय से वाद विवाद हुये ते कचेरी खुली हइ, अरु शासक भी हइ. वे एक दुसरा पर दोष लगाये. ");
INSERT INTO goj_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","पन अगर तुम कोय अरु बात का बारे मे कुछ पूछनो चाहस हइ, ते कानुन की सभा मे फैसलो किये जाये. ");
INSERT INTO goj_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","क्युकि आज का बलवा कारण हम पर दोष लगाया जान, डर से, येका लिये कि येको कोय करण नी, आखरी हम या गर्दी खे जमा होन को कोय उत्तर नी दि सक्ये.” ");
INSERT INTO goj_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","अरु यो बोलि खे ओने सभा खे बिदा कर्यो. ");
INSERT INTO goj_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","जब दंगो थमी गयो ते पौलुस ने विश्वासीहोन खे बुलैइ खे होसलो, बडायो अरु बिदा हुइ खे मकिदुनी का तरफ चली दियो. ");
INSERT INTO goj_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","उ पुरा प्रदेश मे से हुइ खे अरु चेलाहोन खे भोत आनन्द करी खे उ अखाया मे आयो. ");
INSERT INTO goj_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","जब तीन महीना र्‍हि खे उ वहा से डोंगा पर सीरिया का तरफ जाना पर थो, ते यहूदीया दुन्या ओकी विरोध मे शाजिस लगैइ र्‍हा था, येका लिये ओने ठानी लियो कि मकिदुनी हुइ खे लौटी जायु. ");
INSERT INTO goj_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","बिरीया को पुरुर्स इन्सान को बेटो सोपत्रुस अरु थिस्सलुनीखे किहोन मे से अरिस्तर्खुस अरु सिकुन्दुस अरु दिरबे को गयुस, अरु आसिया प्रात को तुखिकुस अरु त्रुफिमुस आसिया तक तीमुथियुस ओका साथ हुइ गा. ");
INSERT INTO goj_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","पर वे आगे जैखे त्रोआस मे हमारी प्रतीक्षा करता र्‍हिये. ");
INSERT INTO goj_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","अरु अखमीरी रोटी का दिन बाद फिलिप्पी से डोगा पर चड खे पाच दिन मे त्रोआस मे उनका पास पहुच्या, अरु सात दिन तक व्हापर र्‍हिया. ");
INSERT INTO goj_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","हप्ता का पैयला दिन जब हम रोटी तोडन का लिये जमा हुया, तो पौलुस ने जो दुसरा दिन चली जाना पर थो, उनसे बातहोन करी खे अरु आधी रात तक शिक्षा देता र्‍हियो. ");
INSERT INTO goj_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","जो उपर की खोली मे हम जमा था, ओमे भोत दिवो जली दिया र्‍हा था. ");
INSERT INTO goj_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","यूतुखुस अरु नाम को खिडकी पर बैठ्यो हुयो गैरी नीद से झुकी र्‍हो थो, अरु जब पौलुस देर तक बातहोन करतो र्‍हियो ते उ नीद का झकोलामे तीसरा माली पर से गिरी पड्यो, अरु मर्यो हुयो उठी गयो. ");
INSERT INTO goj_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","पन पौलुस उतरी खे ओकासे लिपटी गयो, अरु गलो लगी खे बोल्यो, “घबरानु नी. क्युकि ओको जान ओमे हइ.” ");
INSERT INTO goj_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","अरु उपर जैखे रोटी तोडी अरु खैइ खे येत्ती देर तक उनसे बातहोन करतो र्‍हियो कि भोर हुइ गइ. फिर उ चली गयो. ");
INSERT INTO goj_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","अरु वे उ जवान खे जिन्दो ली आयो, अरु भोत शांती पाइ. ");
INSERT INTO goj_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","हम पैयले से डोंगा पर चडी खे अस्सुस को यो बिचार से आगे गया, कि वहा से हम पौलुस खे चड्यै लिये क्युकि ओने यो येकालिए ठैरायो थो, कि खुद ही पइदल जानआला थो. ");
INSERT INTO goj_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","जब उ अस्सुस मे हम खे मील्यो ते हम ओखे चड्यै, मीतुलेने मे आया. ");
INSERT INTO goj_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","अरु वहा से डोंगा खोली खे हम दूसरा दिन खियुस का सामने पहुच्या, अरु दुसरा दिन सामेस मे जा पहुच्या, फिर दूसरा दिन मीलेतुस मे आया. ");
INSERT INTO goj_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","क्युकि पौलुस ने इफिसुस का पास से हुइ खे जाना की ठान्यो थो, कि कही असो नी हुये कि ओखे आसिया मे देर लग्ये. क्युकि उ जल्दी मे थो, कि अगर हुइ सक्येका ते उ पिन्तेकुस्त का दिन यरुशलेम मे र्‍हियो. ");
INSERT INTO goj_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","अरु ओने मीलेतुस से इफिसुस मे बुलाओ भेज्यो, अरु मंडली का बुजरुक खे बुलायो. ");
INSERT INTO goj_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","जब वे ओका पास आया, ते उनसे बोल्यो, तुम जानस हइ, कि पैयला ही दिन से जब मी आसिया मे पहुच्यो, मी हर टेम मे तुम्हारा साथ कोनता प्रकार र्‍हियो. ");
INSERT INTO goj_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","यानी बडी दीनता से, अरु आसू बह्ये-बह्ये खे अरु उ परीक्षाहोन मे जो यहूदीयाहोन कि साजिस करण जो मरा पर अय पडी. मी प्रभु की सेवा करतो ही र्‍हियो. ");
INSERT INTO goj_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","अरु जो-जो बातहोन तुम्हारा लोभ की थी, उनखे बतानु अरु दुन्या का सामने अरु घर-घर सिखाना से कभी नी झिझकनु. ");
INSERT INTO goj_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","क्युकी यहूदीयाहोन अरु यूनानीहोन खे चेतावनी देतो र्‍हियो कि परमेश्‍वर का तरफ मन फिराव, अरु हमारो प्रभु यीशु मसीह पर विश्वास करणु. ");
INSERT INTO goj_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","अरु अब, मी आत्मा मे बध्यो हुयो यरुशलेम का जउस हइ, अरु नी जानतो, कि वहा मरा पर का बीत्ये. ");
INSERT INTO goj_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","फक्त यो कि पवित्र आत्मा हर नगर मे गवाही दि-दि खे मरासे बोलस हइ कि बन्धन अरु क्लेश तरा लिये तैयार हइ. ");
INSERT INTO goj_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","पन मी अपनो जा खे कुछ नी समझु कि ओखे प्रिय जानू, क्युकी यो कि मी अपनी दौड, अरु वा सेवा खे पूरी कर्यु, जो मेने परमेश्‍वर का अनुग्रह को सुसमाचार पर गवाही देन का लिये प्रभु यीशु से पायो हइ. ");
INSERT INTO goj_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","अरु अब मी जानुस हइ, कि तुम सब जेमे मी परमेश्‍व का राज्य को प्रचार करतो फिर्यो, मरो मुडो फिर नी देख्ये. ");
INSERT INTO goj_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","येका लिए मी आज का दिन तुम से गवाही दि खे बोलुस हइ, कि मी सब का खुन से नीर्दोष हइ. ");
INSERT INTO goj_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","क्युकि मी परमेश्वर की पुरी योझना खे तुम्ह खे पूरी रीति से बताना से नी झिझक्यो. ");
INSERT INTO goj_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","येका लिए अपनी अरु पूरा झुण्ड की देख-रेख करणु. जेमे पवित्र आत्मा ने तुम्ह खे मुखियो ठैराया हइ कि तुम परमेश्वर की मंडली की रखवाली करणु, जेका से ओने अपना खुन से मोल लियो हइ. ");
INSERT INTO goj_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","मी जानुस हइ, कि मरा जाना का बाद फाडनआला मेढाहोन तुम मे अयखे जो झुण्ड खे नी छोड्ये. ");
INSERT INTO goj_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","तुम्हारा ही बीच मे से भी असा-असा इन्सान उठ्येका जो चेलाहोन के अपना पीछे खीची लेन कि टेडी-मेडी बातहोन बोल्ये. ");
INSERT INTO goj_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","येका लिए जागते र्‍हेनु, अरु याद करणु कि मेने तीन साल तक रात दिन आसू बोह्ये-बोह्ये खे हर एक खे सिखायो. ");
INSERT INTO goj_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“अरु अब मी तुम्ह खे परमेश्‍वर के अरु ओका अनुग्रह को सोपी देस हइ तुम उन्नती करी सकस हइ अरु तुम परमेश्वर कि दुन्या का साथ पुरी आशिष दिल्ये सकस हइ. ");
INSERT INTO goj_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","मेने कोय खे चादी, सोन्ना या कपडा को लालुच नी कर्यो. ");
INSERT INTO goj_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","तुम खुद ही जानस हइ कि यइ हाथहोन ने मरी अरु मरा साथिहोन की जरुरतहोन पूरी करी. ");
INSERT INTO goj_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","मेने तुम्ह खे सब कुछ करी खे दिखायो, कि या रीति से मेहनत करता हुये नीर्बलहोन खे सम्भालनो, अरु प्रभु यीशु की बातहोन याद रखन जरुरी हइ, कि ओने खुद ही बोल्यो हइ लेना से देनो अच्छो हइ.” ");
INSERT INTO goj_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","यो बोलि ओने घुटना टेक्या अरु उन सब का साथ प्रार्थना करी. ");
INSERT INTO goj_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","तब वे सब भोत अरु पौलुस का गल्लो मिलीखे ओखे चूमन लग्या. ");
INSERT INTO goj_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","वे विशेष करीस या बात को शोक करता था, जो ओने बोली थी कि तुम मरो मुडो फिर नी देख्ये का अरु उनने ओखे डोंगा तक पहुचायो. ");
INSERT INTO goj_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","जब हमने उनसे अलग हुइ खे समुद्री जत्रा सुरवात करी खे ते सीधी रस्ता से कोस मे आया, अरु दूसरा दिन रुदुस मे, अरु व्हा से पतरा मे. ");
INSERT INTO goj_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","अरु एक डोंगा मे फीनीके को जातो हुयो मील्यो, अरु हमने ओ पर चडी खे ओखे खोल दियो. ");
INSERT INTO goj_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","जब साइप्रस दिखाइ दियो, ते हमने ओखे डाखोर्यो हाथ छोड्यो, अरु सीरिया खे चलीखे सूर मे उतर्या. क्युकि वहा डोंगा को बोझ उतारनु थो. ");
INSERT INTO goj_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","अरु चेलाहोन खे पयई खे हम वहा सात दिन तक र्‍हियो. उनने आत्मा खे सिखायो पौलुस से बोल्यो कि यरुशलेम मे पाय नी रखनु. ");
INSERT INTO goj_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","जब वे दिन पूरा हुइ गया, ते हम वहा से चल दिया. अरु सब बयहोन अरु बच्चाहोन समेत हमखे नगर का बाहेर तक पोचाया अरु हमने किनारा पर घुटना टेकी खे प्रार्थना करी. ");
INSERT INTO goj_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","तब एक दूसरा से बिदा हुइखे, हम तो डोंगा पर चड्या, अरु वे अपना-अपना घर लौटी गया. ");
INSERT INTO goj_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","जब हम सूर से पाणी जत्रा पूरी करीखे पतुलिमयिस मे पहुच्या, अरु भैइ होन खे नमस्कार करीखे उनका साथ एक दिन र्‍हिया. ");
INSERT INTO goj_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","दुसरा दिन हम वहा से चलीखे कैसरिया मे आया, अरु फिलिप्पुस सुसमाचार प्रचारक का घर मे जो सातजन मे से एक थो, जैइ खे ओका ह्या ठैइर्या. ");
INSERT INTO goj_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","ओकी चार कुव्वारी बेटीहोन थी. जो भविष्यवाणी करती थी. ");
INSERT INTO goj_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","जब हम वहा भोत दिन र्‍हि चुक्या, ते अगबुस नामको एक भविष्यव्दक्ता यहूदीया से आयो. ");
INSERT INTO goj_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","ओने हमारा पास अयखे पौलुस को कमरबन्द लियो, अरु अपना हाथ पाय बांधीखे बोल्यो, “पवित्र आत्मा यो बोलस हइ, कि जो इन्सान को यो कमरबन्द हइ, ओखे यरुशलेम मे यहूदी या रीति से बाध्ये, अरु गैरयहूदीहोन का हाथ मे सोपि दिये.” ");
INSERT INTO goj_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","जब हमने या बातहोन सुनी, ते हम अरु वहा का दुन्याहोन ने ओका से प्रार्थना करी कि यरुशलेम खे नी जानु. ");
INSERT INTO goj_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","पन पौलुस ने जवाब दियो, “तुम का करस हइ, कि रोइ-रोइखे मरो मन तोडस हइ? मी तो प्रभु यीशु का नाम का लिये यरुशलेम मे नी फक्त बाध्यो जान ही का लिये क्युकी मरन का लिये भी तैयार हइ.” ");
INSERT INTO goj_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","जब ओने नी मान्यो ते हम यो बोलीखे चुप हुइ गया, “प्रभु की इच्छा पूरी हुये.” ");
INSERT INTO goj_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","उ दिनहोन का बाद हमने तैयारी करी अरु यरुशलेम खे चली दिया. ");
INSERT INTO goj_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","कैसरिया का भी कुछ चेला हमारा साथ अयगा, अरु मनासोन नामको साइप्रस का एक पुरानो चेला का साथ ली आया, कि हम ओका ह्या टिक्ये. ");
INSERT INTO goj_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","जब हम यरुशलेम मे पहुच्या, ते भैइ बडि खुशी का साथ हम से मील्यो. ");
INSERT INTO goj_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","दूसरा दिन पौलुस हमखे लीखे याकूब का नजीक गयो, झा सब बापदादा एक जगा था. ");
INSERT INTO goj_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","तब ओने उन्हसे नमस्कार करीखे जो-जो काम परमेश्वर ने ओकी सेवा का द्वारा गैरयहूदीहोन मे कर्या थो, एक-एक करीखे सब बतायो. ");
INSERT INTO goj_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","उनने यो सुनीखे परमेश्वर की महिमा करी, फिर ओकासे बोल्यो, “हे पौलुस भैइ, तू देखस हइ, कि यहूदीहोन मे से कइ हजार ने विश्वास कर्यो हइ. अरु सब व्यवस्था का प्रती उत्साही हइ. ");
INSERT INTO goj_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","अरु उनखे तरा बारे मे सिखायो गयो कि तु गैरयहूदीहोन मे र्‍हेनाला यहूदीहोन खे मूसा से फिर जिवन खे सिखास हइ अरु बोलस हइ, कि नी अपना बच्चाहोन को खतनो करणु अरु नी रीतिहोन पर चलनु. ");
INSERT INTO goj_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","ते फिर का कर्यो जाह्ये दुन्या जरुर सुन्ये कि तु ह्या आयो हइ. ");
INSERT INTO goj_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","येकालिये जो तरा से बोलस हइ, उ कर हमारा ह्या चार इन्सान हइ, जेने मन्नत मानी हइ. ");
INSERT INTO goj_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","उनखे लिखे ओका साथ अपना आप खे अच्छो कर. अरु उनका लिये खर्चा दे, कि वे बाल मुन्डाये तब सब जानी लिये कि जो बातहोन उनने तरा बारे मे सिखी गइ, उनकी कुछ जड नी हइ पन तू खुद भी व्यवस्था खे मानीखे ओका अनुसार चलस हय. ");
INSERT INTO goj_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","पन उन गैरयहूदीहोन का बरे मे जोन्हे विश्वास कर्यो हइ हमने यो सल्लो करीखे लिखी भेज्यो हइ कि वे मुर्तिहोन का सामने बलि कर्यो हुयो मास से अरु खुन से अरु गलो घोट्यो हुयो को मास से अरु पाप से, बच्या र्‍हेनु.” ");
INSERT INTO goj_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","तब पौलुस उन इन्सानहोन खे लिखे अरु दुसरा दिन उनका साथ अच्छो हुइखे मन्दिर मे गयो, अरु वहा बतैइ दियो कि अच्छो होन का दिन अगर उनमे से हर एक का लिये चडाओ चडाय जाना तक को दिन कब पुरा हुये. ");
INSERT INTO goj_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","जब वे सात दिन पूरा होना पर था, ते आसिया का यहूदीहोन ने पौलुस खे मन्दिर मे देखी खे देख सब दुन्याहोन खे भडकायो, अरु यो चिल्लय खे ओखे पकडि लियो. ");
INSERT INTO goj_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","“हे इस्राएलिहोन, मद्दत कर. यो उ इन्सान हइ, जो दुन्या खे , अरु व्यवस्था खे , अरु यो स्थान खे विरोध मे हर जगह सब दुन्या को सिखास है, ह्या तक कि यूनानीहोन को भी मन्दिर मे लयखे ओने यो पवित्र जगत खे अपवित्र कर्यो हइ.” ");
INSERT INTO goj_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","उनने ते येकासे पइले इफिसुस वासी त्रुफिमुस खे ओका साथ नगर मे देख्यो थो, अरु समझतो थो कि पौलुस ओखे मन्दिर मे लि आयो हइ. ");
INSERT INTO goj_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","तब पुरा नगर मे हल्लो मची गयो अरु दुन्या दौडि खे जमा हुया, अरु पौलुस खे पकडिखे मन्दिर का बाहेर घीसी लायो, अरु जल्दी दरवाजा बन्द करी गयो. ");
INSERT INTO goj_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","जब वे ओखे मारी डालनो चाहाता था, ते सैन्य-दल का सरदार खे सन्देशो पहुचा कि पुरा यरुशलेम मे हल्लो मची र्‍हो हइ. ");
INSERT INTO goj_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","तब उ जल्दी सैनीकहोन अरु सुबेदार होन खे लिखे उनका पास नीच्चे दौडि आयो. अरु उनने सैन्य-दल का सरदार खे अरु सैनीकहोन खे देखीखे पौलुस खे मारनो-पीटनो रोखी दियो. ");
INSERT INTO goj_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","तब सैन्य-दल का सरदार ने पास अयखे ओखे पकडि लियो. अरु दो साकलहोन से बाधन की आज्ञा दिखे पूछन लग्यो, “यो कोन हइ, अरु एने का कर्यो हइ?” ");
INSERT INTO goj_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","पन गर्दी मे से कोय कुछ अरु कोय कुछ चिल्लाता र्‍हिया अरु जब हल्ला का मारे ठीक सच्ची नी जानी सक्यो, ते किला मे लि जान की आज्ञा दी. ");
INSERT INTO goj_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","जब उ सीडि पर पहुच्यो, ते असो हुयो कि गर्दी का दबाव का मारे सिपाइहोन खे ओखे उठैइ खे लि जानो पड्यो. ");
INSERT INTO goj_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","क्युकि दुन्या कि गर्दी यो चिल्लाता हुये ओका पीछे पड्या, “ओको अन्त करी दे.” ");
INSERT INTO goj_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","जब वे पौलुस खे किला मे लि जाना पर था, ते ओने सैनीकहोन का सरदार से बोल्यो, “का मेखे आज्ञा हइ कि मी तरा से कुछ बोल्यु?” ओने बोल्यो, “का तू यूनानी जानस हइ?” ");
INSERT INTO goj_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","का तू उ मीस्रिहोन नी, जो ये दिनहोन से पइले विद्रोइ बनीखे चार हजार हथियारबंद कि बडैइ करी र्‍हो थो. ");
INSERT INTO goj_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","पौलुस ने बोल्यो, “मी तो तरसुस को यहूदी इन्सान हइ! किलिकिया को प्रसिद्ध नगर को नीवासी हइ, अरु मी तरासे से प्रार्थना करुस हइ, कि मेखे दुन्या से बातहोन करण दे.” ");
INSERT INTO goj_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","जब ओने आज्ञा दि, ते पौलुस ने सीडि पर खडो हुइखे दुन्या का हाथ से इशारो कर्यो जब वे चुप हुइ गया, ते उ इब्रानी भाषा मे बोलन लग्यो. ");
INSERT INTO goj_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“हे मरा यहूदीया भैइहोन अरु मरी बात सुन्नु क्युकि मी तुम्हारा सामने अपनो बचाव करुस हइ.” ");
INSERT INTO goj_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","वे यो सुनीखे कि उ उनसे इब्रानी भाषा मे बोलस हइ, ते वे चुप हुइ गया. तब ओने बोल्यो: ");
INSERT INTO goj_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","मी तो यहूदीया इन्सान हइ किलिकिया का तरसुस मे जन्म्यो. पन यो यरुशलेम मे पल्यो बड्यो गमलीएल का पाय का पास बठी खे शिक्षा प्राप्त करी खे अरु बुजुरुखहोन की व्यवस्था भी ठीक रीति पर सिखायो गयो. अरु परमेश्वर का प्रती हइ एसी धुन लगायो थो, जसा तुम सब आज हइ. ");
INSERT INTO goj_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","मेने इन्सान अरु बय दोइ खे पकडी खे अरु कैदी बन्य के बन्दीगृह मे डाली खे यो पथ खे ह्या तक सतायो, कि उनखे मारी भी डाल्यो. ");
INSERT INTO goj_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","खुद महा याजक अरु बुजुरुख गवा हइ. कि उनमे से भैइहोन का नाम इन से चिठ्ठी भी लि थी दमीश्क कि जो दुन्या या रस्ता पर चलता उनखे पकडी खे बंदीघर मे ला अरु उनखे दड दिलायु. ");
INSERT INTO goj_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“जब मी जत्रा करी खे दमीश्क का पास पहुच्यो ते असो हुयो कि दुपेर का नजीक पास अचानक एक बडी बिजली बद्दल से मरा चारी तरफ चमकी. ");
INSERT INTO goj_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","अरु मी जमीन पर गिर पड्यो. अरु या वाणी सुनी ‘हे शाउल, हे शाउल, तु मेखे क्यु सतय रो हइ.’ ");
INSERT INTO goj_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","मेने जवाब दियो, ‘हे प्रभु, तु कोन हइ?’ ओने मरासे बोल्यो, ‘मी यीशु नासरी हइ, जेखे तू सतास हइ.’ ");
INSERT INTO goj_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","अरु मरा सोप्तिहोन ने ज्योति तो देखी, पन जो मरासे बोलतो थो ओकी आवाज नी सुनी. ");
INSERT INTO goj_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","तब मेने बोल्यो, ‘हे प्रभु, मी का करु?’ प्रभु ने मरासे बोल्यो, ‘उठी खे दमीश्क मे जा, अरु जो कुछ तरा करण का लिये ठैरयो गयो हइ वहा तोखे सब बतैइ दियो जाह्ये.’ ");
INSERT INTO goj_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","जब वा ज्योती का तेज करण मी अंधो हुइ गयो थो, ते मरा सोप्तिहोन को हाथ पकडी हुया दमीश्क मे आया. ");
INSERT INTO goj_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“तब हनन्याह नाम को व्यवस्था का जसो चलनआलो एक भक्त इन्सान खे जो वहा का र्‍हेनआला सब यहूदीयाहोन को मान रखतो थो, ");
INSERT INTO goj_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","अरु खडो हुइ खे मरासे बोल्यो हे भैइ शाउल, फिर देखन लग्यो, वा घडी मरी आख खुली गइ अरु मेने ओखे देख्यो. ");
INSERT INTO goj_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","तब ओने बोल्यो, हमारा बुजरुक को परमेश्वर ने तोखे येका लिये ठैरायो हइ कि तु ओकी इच्छा खे जान्यो, अरु उ धर्मी खे देख्यो, अरु ओका मुडासे बातहोन सुनी. ");
INSERT INTO goj_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","क्युकि तु ओकी तरफ से सब इन्सानहोन का सामने वा बात होन कि गवा हुये खे जो तोने देखी अरु सुनी हइ. ");
INSERT INTO goj_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","अब क्यु देर करस हइ? उट बपतिस्मा ले, अरु ओको नाम लि खे अपना पाप खे धौइ डाल. ");
INSERT INTO goj_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“जब मी फिर यरुशलेम मे अय खे मन्‍दिर मे प्रार्थना करी र्‍हो थो. मेने दृष्‍टान्‍त देख्यो. ");
INSERT INTO goj_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","अरु प्रभु ने देख्यो कि मरासे बोलस हइ, जल्दी करी खे यरुशलेम से जल्दी नीकली जा. क्युकि वे मरा बारे मे तरी गवइ नी मान्ये. ");
INSERT INTO goj_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","मेने बोल्यो, हे प्रभु वे तो तुम जानस हइ, कि मी तरा पर विश्वास करणआला होन खे बंदीघर मे डालतो अरु जगा-जगा आराधनालय मे जैइ के पिटवातो थो. ");
INSERT INTO goj_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","अरु जब तरो गवा स्तिफनुस को खुन बोहायो जै ऱ्हो थो तब भी मी वहा खडो थो, अरु या बात मे सहमत थो, अरु ओको हत्याराहोन का कपडा कि रखवाली करतो थो. ");
INSERT INTO goj_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","अरु प्रभु ने मरासे बोल्यो, ‘चली जा : क्युकि मी तोखे गैरयहूदिहोन का पास दुर भेज्यु’.” ");
INSERT INTO goj_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","वे या बात तक पौलुस सुनतो र्‍हियो. तब उचो शब्द से चिल्लायो, “असा इन्सान खे जमीन से मीटय दे. ओको जिन्दो र्‍हेनु अच्छो नी. ");
INSERT INTO goj_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","जब वे चिल्लाता अरु कपडा फाडता अरु हवा मे धुल्लो उडाथो था. ");
INSERT INTO goj_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","तो रोमी टुकडी का सेनादल का सुबेदार ने बोल्यो, येखे किल्ला मे लि जाओ अरु कोडा मारी खे जाचनु, कि मी जान्यु कि यहूदीया दुन्या कोय करण ओका विरोध मे असा चिल्लय र्‍हा हइ,” ");
INSERT INTO goj_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","लेकिन जब उनने ओखे कोडा मारन का लिये बांधी दियो ते पौलुस ने वहा खडो अधिकारी से बोल्यो, तुम्हारा लिये रोमी नागरीक खे कोडा मारनो अच्छो हइ, जो कोय को भी अपराध का लिये भी कोशिश नी करी गइ हइ. ");
INSERT INTO goj_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","अधिकारी ने यो सुनी खे सेनापति का सरदार का पास जैइ, बोल्यो “तू ह्या का करस हइ? यो तो रोमी इन्सान हइ.” ");
INSERT INTO goj_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","तब सेनादल का सरदान ने पौलुस का पास अय खे बोल्यो, मेखे बता, तु रोमी हइ? पौलुस ने बोल्यो, “हा.” ");
INSERT INTO goj_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","यो सुनी खे सेनादल को सरदार ने बोल्यो, “मेने रोमी होन को पद भोत रुपीया मे दिखे मील्यो हइ.” पन पौलुस ने बोल्यो, “मी तो जन्म से रोमी हइ.” ");
INSERT INTO goj_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","तब जो दुन्या ओखे पुछताच करण आला था, वे जल्दी ओका पास से हटी गया. अरु सेनादल को सरदार भी यो जानी खे कि यो रोमी हइ, अरु ओने ओखे बाध्यो हइ, डरी गया. ");
INSERT INTO goj_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","दूसरा दिन रोमी टुकडी को सेना नायक यो ठीक-ठीक जानन की इच्छा से कि यहूदीया ओ पर दोष लगास हइ, येका लिये ओको बन्दन खोली दियो. अरु प्रधान याजकहोन अरु पुरी महासभा खे इकठ्ठा होन कि आज्ञा दी, अरु पौलुस खे नीच्चे लि जैइ खे उनका सामने खडो करी दियो. ");
INSERT INTO goj_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","पौलुस ने महासभा का तरफ टकटकी लगैइ खे देख्यो, अरु बोल्यो, हे इस्त्राएली भैइहोन, मेने आज तक परमेश्वर का लिये बिलकुल सच्चा विवेक से जिवन बितायो हइ. ");
INSERT INTO goj_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","हनन्याह महायाजक ने, उनका जो ओका पास खडो थो, ओका गाल पर थप्पड मारन कि आज्ञा दी. ");
INSERT INTO goj_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","तब पौलुस ने ओकासे बोल्यो, “ हे चुन्नो फिरी हुइ दिवाल, परमेश्वर तोखे मार्येका तू मूसा का नीयम का जसो मरो न्याय करण का लिये बठ्यो हइ, अरु फिर व्यवस्था का विरुध्द मेखे मारन कि आज्ञा देस हइ?” ");
INSERT INTO goj_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","जो दुन्या पौलुस का पास खडा था, “उनने बोल्यो, तू परमेश्वर को महायाजक खे बुरो-भलो बोलस हइ.” ");
INSERT INTO goj_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","पौलुस ने बोल्यो, “हे इस्त्राएली भैइहोन, मी नी जानतो थो, कि यो महायाजक हइ. क्युकि लिख्यो हइ, अपना दुन्या का प्रधान खे बुरो नी बोलनु.” ");
INSERT INTO goj_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","तब पौलुस ने यो जानी खे कि एक दल सदूकिहोन अरु दूसरा फिरीसिहोन को हइ, महासभा मे पुकारी खे बोल्यो, “हे भैइहोन मी फरीसी अरु फिरीसीहोन को वंश को हइ, मर्या हुया कि आस अरु पुनरुत्थान का बारे मे मरो मेकदमो हुइ र्‍हो हइ.” ");
INSERT INTO goj_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","जब ओने या बात बोली ते फरीसीहोन अरु सदूकिहोन मे वाद विवाद होन लग्यो. अरु सभा मे फुट पडी गइ. ");
INSERT INTO goj_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","क्युकि सदूकि तो यो बोलस हइ, कि नी पुनरुत्थान हइ, नी स्वर्गदूत अरु नी आत्मा हइ. पन फरीसी यो सब खे मानस हइ. ");
INSERT INTO goj_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","तब बडो हल्लो मच्यो अरु कुछ मूसा को नीयम को शिक्षक जो फरीसीहोन को दल को थो, उठी खे यो बोलि खे झगडन लग्या, “हम यो इन्सान मे कुछ बुराइ नी पाय. अरु अगर कोय आत्मा या स्वर्गदूत ओकासे बोल्यो हइ ते फिर का” ");
INSERT INTO goj_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","जब भोत वाद विवाद हुयो, ते सेनादल को सरदार ने या डर से कि वे पौलुस का टुकडा टुकडा नी करी नी डाल्येका सेनादल खे आज्ञा दी कि उतरी खे ओखे उनका बय मे से जबरदस्ती नीकलनु, अरु किल्ला मे लि आनू. ");
INSERT INTO goj_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","उय रात प्रभु ने ओका पास अयखे खडो हुइ खे बोल्यो, “हे पौलुस हिम्मत रख क्युकि जसो तोने यरुशलेम मे मरी गवइ दी, वसो ही तोखे रोम मे भी गवइ देनु पड्ये.” ");
INSERT INTO goj_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","जब दिन हुयो, ते यहूदीयाहोन ने इकठ्ठा हुया अरु साजीस रच्यो, अरु कसम खय कि जब तक हम पौलुस खे मारी नी डाल्ये अगर हम खाया या पीया ते हम पर धिक्कर. ");
INSERT INTO goj_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","जेने या कसम खे खाय थी वे चालीस जन से जादा था. ");
INSERT INTO goj_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","उनने प्रधान याजकहोन का पास अय खे बोल्यो, “हमने यो ठान्यो हइ कि जब तक हम पौलुस खे मारी नी डाल्येका तब तक अगर कुछ भी खाये ते हम पर धिकार हइ. ");
INSERT INTO goj_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","अरु फिर यहूदीया समेत सेनादल का सरदार का समझानु, कि ओखे तुम्हारा पास लि अयखे मानु कि तुम ओका बारे मे अरु ओका पहुचना से पइले हि ओखे मारी डालन का लिये तैयार र्‍हिये.” ");
INSERT INTO goj_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","अरु पौलुस की भैइन ने सुन्यो कि वे ओखे मारी डालन कि ताक मे हइ, ते सैनीकहोन किल्ला मे जैइ खे पौलु खे सन्देशो दियो. ");
INSERT INTO goj_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","पौलुस ने सुबेदार मे से एक, “पलटन को सरदार का पास लि जानु का यो जवान ओका से कुछ बोलनु चाहस हइ.” ");
INSERT INTO goj_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","आखरी. ओने ओखे पलटन का सरदार का पास लि जैइ खे बोल्यो, बन्दी पौलुस ने मेखे बुलैइ, प्रार्थना करी खे की यो जवान खे पलटन का सरदार से कुछ बोलनु चाहस हइ. येखे ओखा पास लि जा. ");
INSERT INTO goj_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","पलटन का सरदार ने ओको हाथ पकडी खे अरु ओखे अलग लि जैइ खे पुच्छो, “तू मरासे का बोलनु चाहस हइ?” ");
INSERT INTO goj_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20",".ओने बोल्यो, “यहूदीयाहोन ने साजिस रची हइ, कि तरासे प्रार्थना करी कि कल पौलुस खे महासभा मे लानु, मानो तू अरु ठीक से ओकी जाच करणु चाहस हइ. ");
INSERT INTO goj_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","पन उनकी नी माननु, क्युकि उनमे से चालीस का उपर इन्सान ओको घात मे हइ, जोन्हे यो ठानी लियो हइ कि जब तक वे पौलुस खे मारी नी डाले, तब तक नी खाये अरु पीये अरु अब वे तैयार हइ अरु तरो बोलन कि रस्ता देखी र्‍हा हइ.” ");
INSERT INTO goj_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","तब पलटन को सरदार ने जवान खे यो बतैइ खे बिदा कर्यो, “कोय से नी बोलनु कि तोने मेखे या बातहोन बतैइ हइ.” ");
INSERT INTO goj_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","फिर ओने तब दो सुबेदार खे बुलैइ खे बोल्यो, “दो सौ सैनीक का सत्तर घोड सवार को अरु दो सौ भालाआला के कैसरिया जान का लिये तैयार करी रख, तू रात खे नउ बजो नीकलनु. ");
INSERT INTO goj_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","अरु पौलुस की सवारी का लिये घोडा तैयार रखनु कि ओखे फेलिक्स राज्यपाल का पास सुरक्षित पहुच्यैइ दे.” ");
INSERT INTO goj_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","सेनापती ने यो प्रकार कि चिठ्ठी भी लिखी. ");
INSERT INTO goj_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“महाप्रतापी फेलिक्स राज्यपाल खे क्लौदियुस लूसियास को नमस्कार. ");
INSERT INTO goj_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","यो इन्सान खे यहूदीयाहोन ने पकडी खे मार डालनो चायो, पन जब मेने जान्यो कि उ रोमी हइ, ते पलटन लिखे छुड्य लायो. ");
INSERT INTO goj_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","अरु मी जाननु चाहतो थो, कि वे ओका पर कोपय करण दोष लगास हइ, येका लिये ओखे नीच्चे उनकी महासभा मे लि गयो. ");
INSERT INTO goj_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","तब मेने जानी लियो, उनकी व्यवस्था को झगडाहोन का बारे मे ओ पर दोष लगास हइ, पन मारी डाल्या जाना या बाधी जान को योग्य ओमे कोय दोष नी. ");
INSERT INTO goj_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","अरु जब मेखे बतायो गयो, कि वे यो इन्सान खे मारना मे लग्या हइ ते मेने जल्दी ओखे तरा पास भेजी दियो. अरु दोश लगान आला खे भी आज्ञा दी, उनका लगाया हुया दोष तरा सामने रखन.” ");
INSERT INTO goj_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","आखरी जसो सैनीकहोन खे आज्ञा दी गइ थी, वसो ही पौलुस खे लि खे रातो-रात अन्तिपत्रिस नजीकपास ओका पास पहुचनु. ");
INSERT INTO goj_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","दुसरा दिन घोडसवारहोन पौलुस का साथ आगे जान, लिये परदल चलन आला सैनीकहोन ने किल्ला मे छोडी दियो. ");
INSERT INTO goj_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","उनने कैसरिया मे पहुची, राज्यपाल खे चिठ्ठी दी. अरु पौलुस खे भी ओका सामने खडो कर्यो. ");
INSERT INTO goj_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","ओने पडी खे पूछो, “यो कोनता देश को हइ?” अरु जब जानी गयो कि किलिकिया को हइ. ");
INSERT INTO goj_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","ओने बोल्यो, जब तरा दोष लगान आला भी अयखे ते मी तरो मुकद्दमो कर्यु, अरु ओने उ हेरोदेस का किल्ला मे, पहरा मे रखन कि आज्ञा दी. ");
INSERT INTO goj_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","पाच दिन का बाद हनन्याह महायाजक भोत बुजरुक अरु तिरतुल्लुस नामको कोय वकील खे साथ लिखे कैसरिया आयो. उनने राज्यपाला का सामने पौलुस पर इलजाम लगायो. ");
INSERT INTO goj_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","जब पौलु खे बुलायो गयो ते तिरतुल्लुस पर इलजाम लगैइ खे बोलन लग्यो, “हे महाप्रतापी, फेलिक्स का साथ मे पेस कर्यो तब थो पुलीस इलजाम लगाता हुये बोल्यो हे महामहिम तुम्हारो अगुवाइ मे काफी टेम से शांती से र्‍हि र्‍हा हइ, अरु तुम्हारा नजर से देश मे भोत जात को अच्छो सुधार हुयो हइ. ");
INSERT INTO goj_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","येके हम हर जगा अरु फेलिक्स हर प्रकार से येको स्वागत करस हइ अरु हम बडी गैराइ से येका लिये धन्यवादीत हइ. ");
INSERT INTO goj_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","पन येका लिये कि तोखे अरु दुख नी देनो चाउ, मी नी चाउ भोत जादा टेम मे तो प्रार्थना करुस हइ कृपया तुम मे हम खे एक दो शब्द मे सुनीले. ");
INSERT INTO goj_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","क्युकि हमने इन्सान खे उपद्रवी अरु जगत का पुरा यहूदीयाहोन मे वाद विवाद पइदा करणआला, अरु नासरीहोन को चालु समे को अध्यक्ष पायो हइ. ");
INSERT INTO goj_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","ओने मन्‍दिर खे अशुध्द करनो चाह्यो, अरु तब हमने ओखे बन्दी बन्ये लियो. ");
INSERT INTO goj_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","पन पलटन का सरदार लूसियास ने अय खे ओखे हिम्मत हमारा हातहोन से छीनी लियो. ");
INSERT INTO goj_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","या सब बातहोन खे जिन का बारे मे हम ओका पर इलजाम लगास हइ, तू खुद ओखे परखी खे जानी लिये.” ");
INSERT INTO goj_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","यहूदीयाहोन ने भी ओको साथ दि खे बोल्या कि यो सब सच्ची थो. ");
INSERT INTO goj_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","जब राज्यपाल ने पौलुस कए बोलन का लिये इशारो कर्यो ते ओने जवाब दियो. मी यो जानी खे कि तु भोत साल से यो राष्ट्र को न्याय करस हइ, मी खुशी का साथ अपनो बचाव पक्ष तुम्हारा सामने जात रखनो चाहुस हइ. ");
INSERT INTO goj_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","तूम पतो करी सकस हइ, कि जब से मी यरुशलेम मे आराधना करण खे आयो, मेखे बारा दिन से जादा दिन नी हुया. ");
INSERT INTO goj_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","यहूदीयाहोन ने मेखे नी ते कोय का साथ बहस करता नी पायो, अरु नी दुन्या कि गर्दी लगाता हुये अरु यहूदीया आराधनालयहोन मे गर्दी नी शहर मे दंगो फैलाते हुये पायो. ");
INSERT INTO goj_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","अरु नी ते वे उन बातहोन खे जिनका बारे मे वे अब मरा पर इलजाम लगास हइ, तरा सामने सच साबित करी सकस हइ. ");
INSERT INTO goj_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","पन यो मी तरा सामने मानी लेउस हइ, कि जो रस्ता खे वे झुठो बोलस हइ, ओका रीति पर मी अपना बुजुरुखहोन को परमेश्वर कि आराधना करुस हइ. पन यो भी विश्वास करुस हइ जो बातहोन मूसा कि व्यवस्था अरु भविष्यव्दक्ताहोन की किताबहोन मे लिखी हइ उन सब पर विश्वास करुस हइ. ");
INSERT INTO goj_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","अरु परमेश्वर पर ओसो ही विश्वास रखस हइ कि अच्छा अरु बुरा दो को ही पुनरुत्थान हुये. ");
INSERT INTO goj_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","येका से मी खुद भी कोशिश करुस हइ, कि परमेश्वर खे अरु इन्सान का तरफ मरो विवेक सदा नीर्दोष र्‍हिये. ");
INSERT INTO goj_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","भोत साल का बाद यरुशलेम मी अपना गरीब दुन्या खे पहचान, अरु दान चडान आयो थो. ");
INSERT INTO goj_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","जब मी यो करी र्‍हो थो, उनने मेखे मन्‍दिर मे पायो, शुध्दिकरण कि विधी पुरी करी र्‍हो थो नी व्हा गर्दी थी अरु नी सोय. ");
INSERT INTO goj_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","व्हा आसिया प्रांत का कुछ यहूदीया था, यो जरुरी था की अगर मरा विरोध मे उनका पास बात थी ते ह्या तरा सामने अय खे मरा पर इलजाम लगास. ");
INSERT INTO goj_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","ह्या यहूदीया दुन्या खुद ही बोल्या, कि जब मी बडी सभा का सामने खडा थो, ते उनने मरा मे कोन तो अपराध पायो? ");
INSERT INTO goj_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","जब मी उनका बीच मे खडो थो, “ तब मे ने उचो आवाज मे बोल्यो थो मर्या हुया मे से जिन्दो उठान का बारे मे मरा विश्वास करनो मरो न्याय हुइ र्‍हो हइ.” ");
INSERT INTO goj_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","फेलिक्स ने जो रीति की बातहोन ठीक-ठीक जानतो थो, यन्हे यो बोली खे टाली दियो, “जब पलटन को सरदार लूसियास आह्ये ते तुम्हारी बात को नीर्णय दियु.” ");
INSERT INTO goj_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","अरु सुबेदार खे आज्ञा दी, कि पौलुस खे कुच छुट दि खे रखवाली करणु, अरु ओका दोस्त मे से कोइ खे भी ओकी सेवा करण से नी रोखनु. ");
INSERT INTO goj_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","कुछ दिन का बाद फेलिक्स अपनी लुगय द्रुसिल्ला जो यहूदीया बय थी, साथ लिखे आयो अरु पौलुस खे बुलैइ खे उ विश्वास का बारे मे जो मसीह यीशु पर हइ, ओने सुन्यो. ");
INSERT INTO goj_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","जब वा अच्छी बातहोन अरु खुद अरु आनआला न्याय का दिन की चर्चा करी र्‍हो थो, ते फेलिक्स ने डरी खे हुइ खे जवाब दियो, “ अभी तो जा. अवसर मीलीखे मी तोखे फिर बुलायू.” ");
INSERT INTO goj_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","ओखे पौलुस से कुछ पैसा मीलन की भी आस थी. येका लिये अरु भी बार-बार बुलैइ खे बातहोन कर्या करतो थो. ");
INSERT INTO goj_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","पन जब दो साल बीती गा, ते पुरकियुस फेस्तुस, फेलिक्स का जगा पर राज्यपाल बनी खे आयो, अरु फेलिक्स यहूदीयाहोन खे खुश करण की इच्छा से पौलुस खे बन्दीघर मे छोडी दियो. ");
INSERT INTO goj_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","फेस्तुस उ देस मे पहुची खे तीन दिन का बाद कैसरिया से यरुशलेम खे गयो. ");
INSERT INTO goj_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","तब व्हा यहूदीयाहोन का प्रधान याजकहोन का प्रमुख दुन्याहोन ने, ओका सामने पौलुस पर इलजाम लगायो. ");
INSERT INTO goj_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","तब यहूदीया याजक वे फेस्तुस से प्रार्थना करी र्‍हा की उ कृपा पौलुस खे यरुशलेम मे बुलानु ताकी वे ओखे रस्ता मे मारी डाली सक्ये. ");
INSERT INTO goj_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","फेस्तुस ने जवाब दियो, पौलुस कैसरिया मे कैद हइ, अरु मी खुद जल्दी वहा जायु. ");
INSERT INTO goj_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","फिर बोल्यो, तुम मे से नेताहोन खे मरा साथ कैसरिया भेजनु, अरु अगर यो इन्सान ने कुछ बुरा काम कर्यो हइ, ते ओ पर इलजाम लगाये. ");
INSERT INTO goj_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","उनका बीच कोय आठ दस दिन र्‍हिखे उ कैसरिया चली गयो. अरु दुसरा दिन न्याय आसन पर बठी खे पौलुस खे लान की आज्ञा दी. ");
INSERT INTO goj_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","जब पौलुस आयो, ते जो यहूदीया अधिकारी यरुशलेम से आया था, उनने आस-पास खडा हुइ खे ओका पर भोत सा गम्भीर इलजाम लगाया, जिनको सबुत वे नी दि सकता था. ");
INSERT INTO goj_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","पन पौलुस ने खुद का बचाव मे बोल्यो, “मेने नी ते यहूदीयाहोन की व्यवस्था का तरफ नी मन्‍दिर का अरु रोमन शासक कैसर का विरुध्द कोय अपराध नी कर्यो हइ.” ");
INSERT INTO goj_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","तब फेस्तुस ने यहूदीयाहोन खे खुश करण की इच्छा से पौलुस खे जबाब दियो “चाहस हइ कि यरुशलेम का जानु. अरु वहा मरा सामने तरो यो मुकद्दमो तय कर्या जाय?” ");
INSERT INTO goj_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","पौलुस ने बोल्यो, मी कैसर का न्याय आसन का सामने खडो हइ. मरो मुकद्दमो को यो फैसलो होन खे होनू, जसो तु अच्छा तरह जानस हइ, यहूदीयाहोन का विरुध्द मे मेने कुछ अपराध नी कर्यो. ");
INSERT INTO goj_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","अगर मी अपराधी हइ अरु मारी डाल नो योग्य कोय काम कर्यो हइ, ते मरन से नी मुकरु. पन जो बातहोन को यो मरा पर इलजाम लगास हइ, अगर उनमे से कोय बात सच्ची नी ठैर्ये ते कोय मेखे उनका हाथ नी सोपी सक्ये, मी कैसर से प्रार्थना करुस हइ. ");
INSERT INTO goj_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","तब फेस्तुस ने मंत्रिहोन की सभा का साथ बिचार करीखे जवाब दियो, “तोने कैसर खे दोहाइ दी हइ, ते कैसर का पास ही जाये.” ");
INSERT INTO goj_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","कुछ दिन बीतना का बाद अग्रिप्पा राजो अरु बिरनी खे कैसरिया मे अय खे फेस्तुस से दान कर्यो. ");
INSERT INTO goj_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","उनका भोत दिन वहा र्‍हेन का बाद फेस्तुस ने पौलुस का बारे मे राजा खे बतायो, “एक इन्सान हइ जेखे फेलिक्स ने बन्दी घर मे ही छोड्या गयो. ");
INSERT INTO goj_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","जब मी यरुशलेम मे गयो थो, ते प्रधान याजकहोन अरु यहूदीयाहोन का बुजरुकहोन ने मी ओ पर दोषी ठैरार्‍ये सक्यु, कि ओका पर दण्ड की आज्ञा दी जाये. ");
INSERT INTO goj_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","लेकिन मेने उनका जवाब दियो, कि रोमीहोन की या रीति नी, कि कोय इन्सान खे दण्ड का लिये सौपी दे, जब तक दोषी खे अपनो दोष लगान आला का सामने दान अरु आरोप का खिलाप खुद को बचाव करण को मौको दियो. ");
INSERT INTO goj_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","आखरी जब वे मरा साथ ह्या अयखे ते मेने कुछ देर नी करी खे पन दुसरा ही दिन न्याय आसन पर बठी खे उ इन्सान खे कोरट मे लान की आज्ञा दी. ");
INSERT INTO goj_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","जब ओको दोष लगान आला खडा हुया, ते उनने असी बुरी बातहोन को दोष नी लगायो, जसो मी समझतो थो वे मी कर्यु. ");
INSERT INTO goj_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","पन अपना मत खे अरु यीशु नामको कोय इन्सान का बारे मे जो मर्या था, अरु पौलुस ओखे जिन्दो बतातो थो, अरु वाद विवाद करता था. ");
INSERT INTO goj_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","अरु मी उलझन मे थो, कि या बातहोन को पतो कसो लगायु? येका लिये मेने पौलुस से पुछ्यो, तु यरुशलेम जायेका कि वहा या बातहोन को फैसलो हुये? ");
INSERT INTO goj_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","पन जब पौलुस ने बिनती, करी मरो मुकद्दमा को फैसलो कैसर का ह्या हुये ते मेने आज्ञा दि, कि जब तक ओखे कैसर का पास नी भेज्यु, ओखे कैद मे रख्या जाये.” ");
INSERT INTO goj_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","जब अग्रिप्पा ने फेस्तुस से बोल्ये “मी भी उ इन्सान कि सुन्नु चाहुस हइ “ओने बोल्यो,” तू सुनी लिये. ");
INSERT INTO goj_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","आखरी दुसरा दिन खे अग्रिप्पा अरु बिरनी खे को बडी धुम धाम से अय खे पलटन का सरदारहोन अरु नगर का प्रमुख खे दुन्याहोन का साथ दरबार मे पहुच्या, तब फेस्तुस ने आज्ञा दी कि वे पौलुस खे लिखे आये. ");
INSERT INTO goj_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","फेस्तुस ने बोल्यो, हे राजा अग्रिप्पा, अरु हे इन्सानहोन जो ह्या हमारा साथ हुये खे तुम यो इन्सानहोन खे देखस हइ, जेका बारे मे पुरा यहूदीयाहोन ने यरुशलेम मे अरु ह्या भी चिल्ले-चिल्लय खे मेखे प्रार्थना करी, कि येको जिन्दो र्‍हेनु अच्छो नी. ");
INSERT INTO goj_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","पन मेने जानी लियो कि ओने असो कुछ नी कर्यो कि मारी डाले जाय, अरु जब कि ओने खुद ही कैसर से प्रार्थना करी, ते मेने ओखे रोम भेजन फैसलो कर्यो. ");
INSERT INTO goj_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","पन मेने प्रभु को बचाव काबा बरे मे कोय ठिक बात नी देख्यो कि कैसर खे लिख भेजु, येका लिये मी ओखे तुम्‍हारा सामने अरु विशेष करी, हे राजा अग्रिप्पा तरा सामने लायो हइ, कि परख्ये का बाद मेखे कुछ तो ओखा बारे मे लिखन खे मील्ये. ");
INSERT INTO goj_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","क्युकि बन्दी खे भेझनो अरु जो इलजाम ओका पर लगाया गया, उनने बतायो कि मेखे व्यर्थ समझ पड्यो हइ. ");
INSERT INTO goj_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","अग्रिप्पा ने पौलुस से बोल्यो, “ तोखे अपना बारे मे बोलन की आज्ञा हइ” तब पौलुस हाथ बड्यैइ खे जवाब देन लग्यो. ");
INSERT INTO goj_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","हे राजा अग्रिप्पा, जोत्ती बातहोन को यहूदीया मरा पर इलजाम लगास हइ, आज तरा सामने उनको जवाब देना मे मी खुद खे धन्य समझुस हइ. ");
INSERT INTO goj_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","विशेष करी खे येका लिये कि यहूदीयाहोन खे सब प्रथाहोन अरु विवादहोन खे जानुस हइ, आखरी मी प्रार्थना करुस हइ, धीरज से मरी सुनी ले. ");
INSERT INTO goj_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","जसो मरो चाल चलन बचपन से अपना जात का बीच अरु यरुशलेम मे जसो थो का यो सब यहूदीया जानस हइ. ");
INSERT INTO goj_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","वे मेखे भोत टेम से जानस हइ अगर वे चाहता ते या बात की गवइ दि सकस हइ की मे ने फरीसी रस्ता खे एक सब से कट्टर जसो एक सदस्य का रुप मे जिवन जीयो. ");
INSERT INTO goj_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","अरु अब वा प्रतीज्ञा कि आसकरण जो परमेश्वर ने हमारा बुर्जुकहोन से करी थी, मरा पर मुकद्दमो चलैइ र्‍हा हइ. ");
INSERT INTO goj_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","वा प्रतीज्ञा को पूरो होना की आस लगाता हुया, हमारा बारा कुल अपना पूरा मन से रात दिन परमेश्वर की सेवा करता आया हइ, हे राजा, या आस का बारे मे यहूदीया मरा पर इलजाम लगास हइ. ");
INSERT INTO goj_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","जब कि परमेश्वर मर्या हुया खे जिन्दो हइ, ते तुम्हारा ह्या या बात क्यु विश्वास का योग्य नी समझी जाय? ");
INSERT INTO goj_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","मेने भी समझो थो कि यीशु नासर का नाम का विरोध मे मी भोत कुछ करु. ");
INSERT INTO goj_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","अरु मेने यरुशलेम मे असो ही कर्यो. अरु प्रधान याजकहोन से अधिकार मीलीखे भोत सा परमेश्वर का दुन्याहोन खे बन्दीगृह मे डाल्यो, अरु जब वे अपनी सम्मती देता था. ");
INSERT INTO goj_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","अरु हर आराधनालय मे मी उनखे सजा दिलै-दिलैइ खे यीशु का विश्वास खे नाकारतो थो, उनका प्रती मरो घुस्सो उनखे नीन्दा का लिये ह्या तक मी विदेशी शहरहोन मे गयो. ");
INSERT INTO goj_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","यो अभिप्राय से मी एक दिन प्रधान याजकहोन से अधिकार अरु आज्ञा-चिठ्ठी लिखे दमीश्क खे जैइ र्‍हो थो. ");
INSERT INTO goj_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","ते हे राजा, रस्ता मे दुपेर का टेम मे मेने स्वर्ग से सुरज को तेज से भी बडी खे एक ज्योत, अपना अरु अपना साथ चलनआला होन का चारी तरफ चमकती हुइ देखी. ");
INSERT INTO goj_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","अरु जब हम जमीन पर गिर पड्या, ते मेने इब्रानी भाषा मे, मरा से बोलता हुये या वाणी सुनी, हे शाउल, हे शाउल का तू मेखे क्यु सतास हइ? पाय पर लाथ मारनो तरा लिये मुस्कील हइ. ");
INSERT INTO goj_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","मेने बोल्यो हे प्रभु, तू कोन हइ? प्रभु ने बोल्यो, मी यीशु हइ जेखे तू सतास हइ. ");
INSERT INTO goj_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","पन तू उटी खे अपना पाय पर खडो हो, क्युकि मेने तोखे येका लिये दर्शन दियो हइ कि तोखे उन बातहोन को भी सेवक अरु गवा ठैरायु जो तोने देखी हइ अरु उनको भी जोका लिये मी तोखे दर्शन दियु. ");
INSERT INTO goj_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","अरु मी तोखे तरा अपना दुन्या यहूदीयाहोन अरु गैरयहूदीहोन से छुड्य खे जेका पास मी अब तोखे भेज्यु. ");
INSERT INTO goj_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","कि तु उनका आखहोन खोल कि वे अंधारा से सैतान को अधिकार उजाला का तरफ फिरनु. ताकी उनका विश्वास का वजेसे जो उन पर हइ वे उनका पापहोन की माफी अरु परमेश्वर खे चुन्या हुया दुन्या का साथ जगा पाये. ");
INSERT INTO goj_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“आखरी हे राजा अग्रिप्पा, मेने उ स्वर्गीय दर्शन की आज्ञा नी टाली. ");
INSERT INTO goj_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","पन पैयले दमीश्क का फिर यरुशलेम का र्‍हेनआला का तब यहूदीयाहोन का पुरा देश मे अरु गैरयहूदिहोन का समझातो र्‍हियो, मन पापहोन से फिरनु अरु परमेश्वर का तरफ मन फिरी खे मन फिराव का बरोबर अच्छो काम कर. ");
INSERT INTO goj_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","या बातहोन का कारण यहूदीया मेखे मन्‍दिर मे पकडी खे मारी डालन कि कोशिश करता था. ");
INSERT INTO goj_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","पन परमेश्वर की मद्दत से मी आज बन्यो हइ अरु छोटा बडा सभी का सामने गवाही देस हइ, अरु वे बातहोन खे छोड कुछ नी बोलतो, जो भविष्यव्दक्ताहोन अरु मूसा ने भी बोल्यो कि होनआली हइ. ");
INSERT INTO goj_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","कि मसीह खे दुख उठानु पड्ये का अरु उ सबसे पैयले मर्या हुया मे से जिन्दो उठस अगर खे हमारा दुन्या मे अरु गैरयहूदिहोन मे ज्योती को प्रचार कर्ये.” ");
INSERT INTO goj_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","जब पौलुस अपना बचाव मे या सब बातहोन खे बोली र्‍हो थो, ते फेस्तुस ने उचो शब्द से बोल्यो, “हे पौलुस,तू पागल हइ, भोत ज्ञान ने तोखे पागल करी दियो हइ.” ");
INSERT INTO goj_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","पौलुस पन ओने बोल्य, “हे महाप्रतापी फेस्तुस, मी पागल नीका सच्ची अरु दिमाक कि बातहोन बोलुस हइ. ");
INSERT INTO goj_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","खुद. राजो अग्रिप्पा इन बातहोन का जानस हइ अरु मी पुरा हिम्मत का साथ या बातहोन उनसे बोली र्‍हो हइ क्युकि मी खुद जानुस ही कि इनमे से कोय भी बात उनखे मालुम नी असो नी हइ असो येका लिये बोली र्‍हो हइ कि या बात कोय कोना मे लुकी नी घटी. ");
INSERT INTO goj_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","हे राजा अग्रिप्पा, तु भविष्यव्दक्ताहोन को विश्वास करुस हइ? हा, मी जानुस हइ, कि तू विश्वास करस हइ.” ");
INSERT INTO goj_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","अब अग्रिप्पा ने पौलुस से बोल्यो “तू यो सोचस हइ की इत्ती सरलता से अरु कम टेम मे तू मेखे मसीह बनी सकस हइ.” ");
INSERT INTO goj_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","पौलुस ने बोल्यो, परमेश्वर से मरी प्रार्थना या हइ कि, थोडा मे का भोत मे, फक्त तू ही नी, पन जेत्ता दुन्या आज मरी सुनस हइ, मरा इन बन्धनहोन खे छोड वे मरा जसा हुइ जा. ");
INSERT INTO goj_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","तब राजो अरु राज्यपाल अरु बिरनी खे, अरु उनका साथ बठनआला उठी खे खडा हुया. ");
INSERT INTO goj_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","अरु अलग जैइखे आपस मे बोलन लग्या, “यो इन्सान असो तो कुछ नी कर्येका जो मरन-दण्ड या बन्दीघर मे डाल्यो जान जसो हो.” ");
INSERT INTO goj_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","अग्रिप्पा ने फेस्तुस से बोल्यो, “अगर यो इन्सान कैसर की दोहाइ नी देतो, ते छुटी सकतो थो.” ");
INSERT INTO goj_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","जब यो नीश्चित हुइ गयो कि हम डोंगा का वजेसे इटली जाये ते उनने पौलुस अरु कुछ दुसरा बन्दिहोन खे भी यूलियुस नामको की सेनादल को एक सुबेदार का हाथ सौपी दियो. ");
INSERT INTO goj_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","हम अद्रमुत्तियुस से एक डोंगा पर सवार हुइखे गया, जो आसिया प्रात का बंदरगाहोन का लिये तीमुथियुस रवाना होन का लिये गया, अरिस्तर्खुस नामको थिस्सलुनीखे का शहर को एक मकिदुनी हमारा साथ थो. ");
INSERT INTO goj_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","दूसरा दिन हम सैदा मे डोंगा से उतर्या, अरु यूलियुस ने पौलुस पर कृपा करी खे ओखे दोस्तहोन खे ह्या जान दियो ताकी, लगन आला जरुरत कि चिज ओखे दि सक्ये. ");
INSERT INTO goj_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","व्हा से हम समुदर रस्ता से फिर चली गया क्युकि हवाहोन हमारा विरुध्द दिशाहोन मे थी हम साइप्रस टापु का आड मे हुइ खे चल्यो. ");
INSERT INTO goj_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","अरु किलिकिया अरु पंफूलिया का पास का समुद्र मे हुइ खे लूसिया मुरा शहर मे उतर्या. ");
INSERT INTO goj_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","वहा सुबेदार खे सिकन्दरिया को एक डोंगा इटली जातो हुयो मील्यो, अरु ओने हम खे ओका पर चड्यै दियो. ");
INSERT INTO goj_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","जब हम भोत दिन तक धीरे-धीरे चली खे मुसकिल से कनीदुस का सामने पहुच्या, ते येका लिये कि हवा हम खे आगे बडन नी देती थी, हम सलमोने टापु का सामने से हुइ, क्रेते टापु का आड मे चल्यो. ");
INSERT INTO goj_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","अरु ओका किनारा मेसकिल से चली का सुरक्षित हुइ खे हारबोर बंदरगा नामको एक जगा पहुच्या का डोंगा से लसाया नगर पास थो. ");
INSERT INTO goj_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","जब हमने भोत दिन बीती गया, अरु पाणी जत्रा मे जोखिम येका लिये हुइ र्‍हा था, कि उपास का दिन अब बीत चुक्या था, ते पौलुस ने उनखे यो बोलि खे चेतावनी देते हुये यो बोल्यो. ");
INSERT INTO goj_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“इन्सान, मी देखी र्‍हो हइ कि ह्या से हमारी जत्रा खतरनाक हुये. मालवाहक अरु डोगा खे भोत नुकसान हुये खे अरु साथ ही जान की नुकसान भी हुये.” ");
INSERT INTO goj_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","पन सुबेदार ने कप्तान अरु डोंगा को मालिक की बातहोन खे पौलुस की बातहोन से बडी खे मान्यो. ");
INSERT INTO goj_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","सुरक्षित हारबोर यो बंदरगा ठडी काटन का लिये उ अच्छो नी थो. येका लिये जादा दुन्या ने फीनीक्स पहुचन को ठान्यो अरु फीनीक्स तक पहुचन कि कोशिश करी र्‍हा था, अगर संभव हुये ते क्रेते वहा सर्दिखे बिताना का लिये फीनीक्स दक्षिण-पश्चिम अरु उत्तर-पश्चिम दो का सामने पडस हइ. ");
INSERT INTO goj_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","जब दक्षिणी हवा आन लगी, ते उनने सोच्यो कि उनखे , जेकी जरुरत थी उ उनका पास थी, येका लिये लगर उठायो अरु क्रेते का किनार का डोंगा खे बडान लग्या. ");
INSERT INTO goj_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","पन थोडी देर मे जमीन का तरफ से एक उत्तर पुर्वी आधी कहलाती थी. ");
INSERT INTO goj_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","जब आधी डोंगा से टकर्यीइ डोंगा आधीकरण हम ने कोशिश करणो छोडी दियो, डोंगा हवा का साथ जिधर जानो चाह्यो उधर जान दियो. ");
INSERT INTO goj_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","तब कौदा नामको एक छोटा सा टापू का आड मे बोहा हम मुसकिल से डोंगा खे कब्जा मे करी सक्या. ");
INSERT INTO goj_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","फिर डोंगा चलान आला ओखे उठैइ खे अनेक उपाय करी खे डोगा का नीच्चे से बाध्यो, अरु सुरतिस का रेती पर टिकी जान, डर से पाल अरु सामन उतारी का बोहाते हुया चली गया. ");
INSERT INTO goj_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","जब डोंगा आधी से भोत हिचकी अरु धक्को खायो, ते दूसरा दिन वे डोगा, कुछ माल फेकन लग्या. ");
INSERT INTO goj_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","अरु तीसरा दिन उनने अपना हाथहोन से डोंगा को उपकरण को सामनहोन भी फेकी दियो. ");
INSERT INTO goj_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","अरु जब भोत दिन मे सुरज देख्यो नी रात मे तारा दिखइ दिया, अरु बडी हवा आंधी चली र्‍हि थी, ते आखरी मे हमारो बचन की पूरी आस जाती र्‍हि. ");
INSERT INTO goj_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","जब वे भोत दिन तक भूखा र्‍हि गया, ते पौलुस ने उनका बीच मे खडा हुइ खे बोल्यो, “ हे दुन्या खे अगर क्रेते से रवाना होन कि सला मरी मानी होती अविनाश अरु नुकसान नी होतो. ");
INSERT INTO goj_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","लेकिन अब मी तुम खे समझउ हइ कि हिम्मत बाधनु, क्युकि तुम मे से कोय कि जान कि नुकसान नी हुये खे पर फक्त डोंगा की. ");
INSERT INTO goj_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","क्युकि बिती हुइ रात जो परमेश्वर को मी हइ, अरु जेकी आराधना करुस हइ, ओको एक स्वर्गदूत मरा पास आयो. ");
INSERT INTO goj_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","‘हे पौलुस, मत डरनु! तोखे कैसर का सामने खडो होनो जरुरी हइ, अरु देख, परमेश्वर ने सब खे जो तरा साथ जत्रा करी र्‍हो हइ, उनको जिवन तरा साथ दियो हइ.’ ");
INSERT INTO goj_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","येका लियेका हे सज्जनहोन, हिम्मत बाधनु. क्युकि मी परमेश्वर पर विश्वास करुस हइ, कि जसो मरासे बोल्यो गयो हइ, वसो ही हुये. ");
INSERT INTO goj_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","पन हम, कोय टापू पर जैखे टिक्यो नी हुये.” ");
INSERT INTO goj_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","जब चौदहवी रात हुइ, अरु हम भुमध्ये समुदर मे भटकी र्‍हा था, ते आधी रात का पास मल्लाहोन अदाजा से जान्यो कि हम कोय किनारा का पास पहुची र्‍हा हइ. ");
INSERT INTO goj_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","येका लिये उनने येका साथ एक रेखा खे गिर्यय दियो अरु पायो कि पानी चालीस मीटर गैयरो थो. थोडी देर बाद उनने उ कर्यो अरु पायो कि यो तीस मीटर गैयरो थो. ");
INSERT INTO goj_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","तब पत्थरीली जगाहोन पर गीरन का डर से उनने डोंगा की पिछे चार लगर डाल्या, अरु फजर होन की काम ना करता र्‍हिया. ");
INSERT INTO goj_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","पन जब मल्लाह डोगापर से भागनो चाहतो थो, अरु से लगइ से डालन का बहानो डोंगा समुदर मे उतारी दियो. ");
INSERT INTO goj_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","पन पौलुस ने सुबेदार अरु सैनीकहोन से बोल्यो, “अगर यो डोगा पर नी र्‍हियो, ते तुम भी नी बची सक्ये.” ");
INSERT INTO goj_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","तब सैनीकहोन ने दोरीकास काटी खे डोंगा समुदर मे गिर्येइ दी. ");
INSERT INTO goj_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","जब फजर होना पर थी, ते पौलुस ने यो बोली खे सब खे भोजन करण की बिनती करुस हइ “आज चौदाह दिन हुया कि तुम आस देखता-देखता भूखा र्‍हिया, अरु कुछ खानो नी खायो. ");
INSERT INTO goj_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","मी तुम से प्रार्थना करुस हइ, फिर कुछ खानु. जिन्दो र्‍हेन का लिये तुम्ह खे येकी जरुरत हइ, अरु तुम्हारा माथा का बाल भी नी हट्ये.” ");
INSERT INTO goj_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","अरु यो बोलि खे ओने रोटी लि खे सब का सामने परमेश्वर को धन्यवाद कर्यो अरु रोटी तोडी खे खान लग्यो. ");
INSERT INTO goj_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","तब वे सब भी हिम्मत बाधी खे भोजन करण लग्या. ");
INSERT INTO goj_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","हम सब मीलि खे डोंगा मे दो सौ छाहत्तर झन था. ");
INSERT INTO goj_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","जब वे खानो खैइ खे तृप्त हुया, ते गहु खे समुदर मे फेकी खे डोंगा हलको लगन लग्यो. ");
INSERT INTO goj_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","जब दिन नीकल्यो, ते उनने उ देस खे नी पैछान्यो, पन एक खाडी देखी जेको चौरस किनारो थो, अरु बिचार कर्यो कि अगर हुइ सक्ये ते ये पर डोगा खे टेक्ये. ");
INSERT INTO goj_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","तब उनने लंगरहोन खे खोलि खे समुदर मे छोडी दियो अरु उ टेम पतवारहोन को बन्धन खोली दिया, अरु हवा का सामने दुसरो पाल चड्यैइ खे किनार का तरफ चलनु. ");
INSERT INTO goj_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","पर दो समुदर को सगम की जगा पडी खे उनने डोंगा खे टिक्यो अरु डोंगा को अलग हिस्सो ते धक्को खैइ खे गडी गइ, अरु हली नी सकी. पर पिछली लहरहोन का बल से टुटन लगी. ");
INSERT INTO goj_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","तब सैनीकहोन को यो बिचार हुयो कि बन्दिहोन खे मारी डाल. असो नी हो कि कोय तिरी खे नीकली भाग्ये. ");
INSERT INTO goj_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","पन सुबेदार ने पौलुस खे बचन की इच्छा से उनको यो बिचार से रोक्यो, अरु यो बोल्यो, उलट या आज्ञा दी जो तैयारी सकस हइ, ते पैयले कुदि खे तिरी खे किनार पर अरु जमीन पर नीकली जानु. ");
INSERT INTO goj_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","अरु बाकी को पालन करणो थो, तख्तो पर या डोंगा का कुछ टुट्या हुया टुकडा खे पकडी खे अरु येका जसो हम सब खे जमीन पर से मील्यो. ");
INSERT INTO goj_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","जब हम किनारा पर सुरक्षित पहुच्या तब मालुम हुयो की माल्टा टापु हइ. ");
INSERT INTO goj_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","अरु वहा का र्‍हेनआलाहोन ने हम पर अनोखी कृपा करी. क्युकि मेंह ओस करण जो बरसी र्‍हियो थो अरु ठडकरण खे उनने अंगार जलैइ खे हम सब खे ठैरायो. ");
INSERT INTO goj_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","जब पौलुस ने लक्कडहोन को गठ्ठो खे अंगार पर रख्यो, ते एक साप ओका पास नीकल्यो अरु ओका हाथ मे गुडय गयो. ");
INSERT INTO goj_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","जब वे र्‍हेनआलाहोन ने साप खे ओका हाथ मे लटक्यो हुयो देख्यो, ते आपस मे बोल्या, “सच्ची यो इन्सान खुनी हइ, कि अगर समुंदर से बची गयो, फिर भी न्याय से बची नी पायो.” ");
INSERT INTO goj_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","तब पौलुस साप खे अंगार मे झटकी दियो, अरु ओखे कुछ नुकसान नी पहुच्यो. ");
INSERT INTO goj_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","पन वे प्रतीक्षा करी र्‍हा था कि उ सुजी जाये या एको-एक गिरी खे मरी जायेका पन जब वे भोत देर तक देखता र्‍हियो, अरु देख्यो कि असाधारन रुप से ओको कुछ भी नी हुयो, ते उनने बिचार बदली खे बोल्यो, यो तो कोइ “परमेश्वर हइ.” ");
INSERT INTO goj_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","वा जगा का आस-पास पुबलियुस नामको उ टापू को प्रधान कि जमीन थी. ओने हम खे अपना घर ली जैइ खे तीन दिन दोस्ती भाव से स्वागत कर्यो. ");
INSERT INTO goj_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","पुबलियुस को बाप तेज बुखार अरु पेचिश से रोगी पड्यो थो, आखरी पौलुस ने ओका पास घर मे जैइ खे प्रार्थना करी खे अरु ओ पर हाथ रखीखे ओखे अच्छो कर्यो. ");
INSERT INTO goj_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","जब असो हुयो, ते उ टापू का बाकी बीमार आया, अरु अच्छो कर्या गया. ");
INSERT INTO goj_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","उनने भोत तरी का से हमारो आदर कर्यो, अरु जब हम चलन लग्या, ते जो कुछ हमारा लिये जरुरी थो, डोगापर रखी दियो. ");
INSERT INTO goj_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","तीन महीना का बाद सिकन्दरिया आया हुया डोगापर चल पड्या अरु यो डोंगा टापू मे ठडी का दिनहोन का कारण रुख्यो हुयो थो उ डोगा को इश्वर बोल्या जातो थो. ");
INSERT INTO goj_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","सुर कूसा शहर मे पहुच्या अरु तीन दिन तक र्‍हिया. ");
INSERT INTO goj_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","वहा से हम घुमी खे रेगीयुम मे आया. अरु दुसरा दिन का बाद दक्षिण हवा चली खे तब दूसरा दिन पुतियुली नगर मे आया. ");
INSERT INTO goj_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","वहा हम खे कुछ विश्वासी भैइ मील्या, अरु उनका बोलना से हम उनका ह्या सात दिन तक र्‍हिया. अरु यो रीति से हम रोम खे चल्यो. ");
INSERT INTO goj_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","जब रोमन का र्‍हेनआला भैइहोन खे हमारी सुचना मीली ते वे अप्पियुस को बजार अरु तीन सराय तक हम खे मीलन आया, जिन खे दिखी खे पौलुस ने परमेश्वर को धन्यवाद कर्यो, अरु हिम्मत बाध्यो. ");
INSERT INTO goj_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","जब हम रोम मे पहुच्या, ते पौलुस खे एक सैनीक का साथ जो ओकी रखवाली करतो थो, एकलो र्‍हेन की आज्ञा मीली गइ. ");
INSERT INTO goj_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","तीन दिन का बाद ओने यहूदीयाहोन का मुखीयाहो खे बुलायो, अरु जब वे जमा हुया ते उनसे बोल्यो, “हे इस्त्राएली भैइहोन, मेने अपना दुन्या खे या बापदादाहोन की रीतिरीवाजहो का खिलाप मे कुछ भी नी कर्यो, फिर भी मेखे बन्दी बनैइ खे यरुशलेम से रोमीहोन का हात मे दि दिये जाये. ");
INSERT INTO goj_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","उनने मेखे परख्ये खे छोडी देनो चाह्यो, क्युकि मरा मे मरन को योग्य कोय दोष नी थो. ");
INSERT INTO goj_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","पन जब यहूदीया येका खिलाप मे बोलन लग्या, फिर मेखे मजबुरी से कैसर से न्याय मागनो पड्यो, येका लिये नी की मे ने अपना दुन्या पर कोय इलजाम लगानु थो. ");
INSERT INTO goj_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","येका लिये मेने तुम खे बुलायो हइ, कि तुम से मील्यु अरु बातचीत कर्यु. क्युकि इस्राएल का दुन्या की आस का लिये मी इन्सान का लिये मी साकल से जकड्यो हुयो हइ.” ");
INSERT INTO goj_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","उनने उनसे बोल्यो, नी हमने तरा बारे मे यहूदीयाहोन से चिठ्ठीहोन पाइ, अरु नी दुन्या ने अय खे तरा बारे मे जानकारी दि, अरु नी बुरो बोल्यो. ");
INSERT INTO goj_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","पन तरो बिचार का हइ? उ हम तरा से सुन्नु चाहस हइ, क्युकि हम जानस हइ ");
INSERT INTO goj_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","तब उनने ओका लिये एक दिन ठैरायो, अरु भोत दुन्या ओका ह्या इकठ्ठा हुया, अरु व्हा परमेश्वर का राज्य की गवइ देते हुये मूसा को नीयम अरु भविष्यव्दक्ताहोन कि किताबहोन से यीशु का बारे मे समझैइ का फजर से संज्जा तक वर्णन करतो र्‍हियो. ");
INSERT INTO goj_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","तब कुछ दुन्या ने वे बातहोन खे मानी लियो, अरु कुछ दुन्या ने विश्वास नी कर्यो. ");
INSERT INTO goj_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","येका लिये वे आपस मे असहमत हुइ गया जब पौलुस ने या बात बोली थी पवित्र आत्मा ने यशायाह भविष्यव्दक्ता का वजेसे पवित्र आत्मा ने बापदादाहोन से कत्ती अच्छी बात बोली थी. ");
INSERT INTO goj_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","जइ खे ये दुन्या से बोल कि सुनता तो र्‍हियेका पन नी समझ्ये का अरु देखता तो र्‍हिये पन तुम खे नी दिखैइ दिये, ");
INSERT INTO goj_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","क्युकि ये दुन्या को मन मोटो, अरु उनका भारी हुइ गया हइ, अरु उनने अपनी आखहोन बन्द करी हइ, असो नी हुये कि वे कभी आखहोन से देख्ये अरु कान होन से सुन्या, अरु मन से समझ्ये अरु मरा तरफ फिर्ये अरु मी उनका अच्छो कर्यु. ");
INSERT INTO goj_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","अरु पौलुस ने या बात से येको समापन कर्यो “की तुम जानी लेनो हुनू की परमेश्वर को यो उध्दार को संदेश गैरयहूदिहोन का पास भेजी दियो या वे येखे सुन्ये.” ");
INSERT INTO goj_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","जब ओने यो बोल्यो ते यहूदीया आपस मे भोत वाद विवाद करण लग्या अरु वहा से चली गया. ");
INSERT INTO goj_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","अरु पौलुस पूरा दो साल अपना किराया का घर मे र्‍हियो अरु जो ओका पास आता था, वे सब को स्वागत करतो थो. ");
INSERT INTO goj_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","अरु पुरा हिम्मत से स्वतत्रता से परमेश्वर को राज्य को प्रचार करतो अरु प्रभु यीशु मसीह का बारे मे सिखातो र्‍हियो.");
INSERT INTO goj_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","पौलुस का तरप से जो यीशु मसीह को सेवक हइ, जो परमेश्वर ने प्रेरीत होन का लिये बुलायो गयो, ताकी अरु जो परमेश्वर को वु सुसमाचार का लिये अलग कऱ्यो गयो. ");
INSERT INTO goj_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","जेखे ओने पैयले ही से अपना भविष्यव्दक्ताहोन का वजेसे पवित्रशास्त्र मे लिख्यो गयो. ");
INSERT INTO goj_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","उ ओने अपनो बेटो हमारो प्रभु यीशु मसीह का बारे मे घोषना करी थी, वह आंग का भाव से ते दाउद को कुल से पइदा हुयो. ");
INSERT INTO goj_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","अरु पवित्र आत्मा का भाव से मर्यो हुयो मे से जिन्दो उठन का कारन सामर्थ का सात परमेश्वर को बेटो बोल्यो गयो हइ उ यीशु मसीह अपनो प्रभु हइ. ");
INSERT INTO goj_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","ओका वजेसे परमेश्वर ने हम खे अनुग्रह दियो अरु ओकी आज्ञा माननु. ताकि सभी गैरयहूदिहोन मे ओको नाम करण विश्वास कर अरु आज्ञा को पालन कर्‍हे. ");
INSERT INTO goj_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","येमे तुम भी शामील हुये जो रोम मे ऱ्हेवस हइ जिन के परमेश्वर ने यीशु मसीह हो का लिये बुलायो गयो हइ. ");
INSERT INTO goj_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","वे दुन्याहोन का लिये मी लिखी रोस हइ जो रोम मे परमेश्वर को प्याऱ्यो हइ अरु पवित्र होन का लिये बुलायो गयो हइ, हमारो बाप परमेश्वर अरु प्रभु यीशु मसीह का तरप से तुमखे अनुग्रह अरु शांती मीलती ऱ्हेस. ");
INSERT INTO goj_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","पैयले मी तुम सब का लिये यीशु मसीह का वजेसे अपना परमेश्वर को धन्यवाद करुस हइ, की तुम्हारो विश्वास कि चर्चा सब जगत मे हुइ ऱ्हीस हइ. ");
INSERT INTO goj_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","परमेश्वर जेकी सेवा मे अपनी आत्मा से ओको बेटा को सुसमाचार का बारे मे करुस हइ, उ मरी गवाह हइ. कि मी तुमखे कोय प्रकार लगातार याद करतो ऱ्हेस हइ, ");
INSERT INTO goj_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","अरु नीत्य अपनी प्रार्थनाहोन मे बिनती करस हुये कि कोय रिती से अब तुम्हारा पास आनवाला की मरी जत्रा परमेश्वर कि इच्छा से सफल हुये. ");
INSERT INTO goj_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","क्युकि मी तुम खे देखन कि भोत इच्छा रखुस हइ ताकी तुम खे आत्मीक शाक्ति बाटी सकु की मी तुम खे जेकासे तुम खे आत्मीक शाक्ति मीले. ");
INSERT INTO goj_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","मनजे यो, कि जब मी तुमारा बिच मे हुइ खे तुमारा सात विश्वास का वजेसे जो मरा मे अरु तरा मे हइ, एक दुसरा कि मदत कर. ");
INSERT INTO goj_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","हे भैइहोन अरु बयहोन, मी बार-बार तुम्हारा पास आनो चउस, कि जसो मेके गैरयहूदिहोन मे नवो विश्वासी को फल मीले, असो हि तुम मे भी मील्हे, पन अब तक रोख्यो गयो. ");
INSERT INTO goj_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","मी सब दुन्याहोन को कर्जदार हइ यूनानीहोन को अरु गैरयहूदीया को अरु बुध्दीमान अरु नीर्बुध्दीहोन को कर्जदार हुये. ");
INSERT INTO goj_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","आखरी मे तुम खे भी जो रोम नगर मे र्हेस हुये खे सुसमाचार सुनान भोत उत्साह से तैयार हइ. ");
INSERT INTO goj_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","क्युकि मी सुसमाचार से नी सरमु येका लिये कि उ हर एक विश्वास करणवाला का लिये पैयले तो यहूदीया फिर यूनानी का लिये क्युकी यो सब का लिये उध्दार लानवालो परमेश्वर कि सामर्थ्य हइ. ");
INSERT INTO goj_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","क्युकि सुसमाचार यो प्रगट करस हइ कि परमेश्वर इन्सान खे अपना प्रती सही कसो बनास हइ यो पैयले से आखरी तक विश्वास का वजेसे से ही हइ. जसो कि शास्त्र मे लिख्यो हइ विश्वास से न्यायी इन्सान जिन्दो ऱ्हीहे. ");
INSERT INTO goj_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","परमेश्वर की घुस्सा ते वे दुन्याहोन को पाप अरु बुराइ पर स्वर्ग से प्रगट होस हइ, जो सत्य को बुराइ से दबय रखस हइ. ");
INSERT INTO goj_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","येका लिये कि परमेश्वर का बारे मे ज्ञान ओका मन मे प्रगट हइ, क्युकी परमेश्वर ने ओका पर प्रगट कऱ्यो हइ. ");
INSERT INTO goj_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","जब से परमेश्वर ने जगत कि रचना करी तब से ओका उद्देश्य विशेशता, मनजे शक्ति अरु ओकि दाइत्व स्वभाव ये दो पुरी रिती से साफ देखायो देस हइ वे उ चिजहोन खे जो परमेश्वर ने रची हइ या फिर उ जानस हइ ते यो फिर येका लिये वे दुन्याहोन का पास कोय बहानो नी हइ. ");
INSERT INTO goj_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","यो करण कि परमेश्वर खे जाना पर भी ओने परमेश्वर को महत्व बडायो अरु धन्यवाद नी कऱ्यो पन व्यर्थ बिचार करण लग्या, यो तक कि वे दिमाक मन अधारो हुये गयो. ");
INSERT INTO goj_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","वे अपना आप खे दिमाकवान समजी खे बदमास बनी गयो. ");
INSERT INTO goj_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","अरु अविनाशी परमेश्वर कि महिमा खे नासमन इनसान अरु पक्षिहोन, अरु चारपाय, अरु लोडनआला जन्तुहोन की चित्र का जसासे मे बदली डाल्यो. ");
INSERT INTO goj_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","येका लिये परमेश्वर ने उनने उनकी मन की वासना का जसो दुराचरण को शिकार होन दियो अरु वे एक दुसरा को आंग के अपवित्र करस हइ. ");
INSERT INTO goj_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","क्युकि उनने परमेश्वर कि सच्चाइ के बदलिके झुटो बन्य दियो, अरु बनायो हुयो चिजहोन कि भक्ति अरु सेवा खे, पन उ बनानवाला कि भक्ति नी करी जो युगानु सृष्टी कि उपासना अरु परमेश्वर का बजाये सुष्टि करी खे जेखे परमेश्वर ने बनायो हइ सुजनहार को जो हमेशा धन्य हइ. आमीन. ");
INSERT INTO goj_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","येका लिये परमेश्वर ने वुनखे नीच कामनाहोन का वस मे छोडी दियो. तक की ओकी बयहोन ने भी बरोबर व्यवहार खे, वोको जो स्वभाव का विरुध्द हइ, बदली डाल्यो. ");
INSERT INTO goj_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","वोसो ही इन्सान भी बयहोन का सात स्वभाविक व्यवहार छोडी खे आपस मे कामातुर हुइ खे जलन लग्या, अरु इन्सान ने इन्सान का साथ नीर्लज काम करी खे अपनो भ्रम को बरोबर फल मील्हे. ");
INSERT INTO goj_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","जब वुनने परमेश्वर खे पचानो नी चायो, ते परमेश्वर भी वुन वोखे बुरा मन पर छोडी दियो. कि वे अच्छो काम कऱ्हे. ");
INSERT INTO goj_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","येका लिये वे सब रगेरंग को अधर्म खे अरु बुरी, अरु लोभी, अरु दुजाभाव से भरी गयो. अरु डाह, अरु मारीडाल, अरु वाद विवाद, अरु छल, अरु इष्यो से भरपुर हुय गयो, अरु चुगली खोर. ");
INSERT INTO goj_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","बदनाम करणवालो, परमेश्वर को बैरी, दुष्ट घमण्डी, अरु डीग मारन आला दुन्या हइ, वे बुराइ करणा मे चतुर हइ, माय बाप की आज्ञा नी माने. ");
INSERT INTO goj_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","बिनाबुध्दी, विश्वासघात, मायारहित अरु नीर्दय हुय गयो. ");
INSERT INTO goj_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","वे तो परमेश्वर कि या विधी जानस हइ, कि असो असो काम करणवालो मृत्यु को दण्ड का योग्य हइ, तेभी नी फक्त आप ही असो काम करस हइ, जब करणवाला से प्रसन्न भी होस हइ. ");
INSERT INTO goj_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","जो तुम दुसरा पर इलजाम लगानआलो, तु कोय क्यु नी हुये. तु अधिकार करस हइ, क्युकि जो बात मे तु दुसरा पर इलजाम लगास हइ, वा बात मी अपना तुमखे भी दोषी ठैरास हइ येकालिये की तु जो इलजाम लगास हइ खुद ही वह का करस हइ. ");
INSERT INTO goj_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","हम जानस हइ, कि असो असो काम करणवाले पर परमेश्वर का तरप‍ से बरोबर दण्ड दराड कि आज्ञा होस हइ. ");
INSERT INTO goj_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","पन हे इन्सान तु जो असो असो काम करणवाला पर इलजाम लगास हइ, अरु आप उ काम करस हइ. का यो समझस हइ, की तू परमेश्वर का दण्ड से बची जाये. ");
INSERT INTO goj_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","का तु वोकी कृपा अरु सहनशीलता, अरु धिरजरुपी धन खे तुच्छ जानस हइ? का यो नी समझस की परमेश्वर कि कृपा मेखे मन फिराव का सीकास हइ. ");
INSERT INTO goj_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","पन तु अपनी हठिला मन का कारण उ दिन जब परमेश्वर की घुस्सा अरु सच्चो न्याय प्रगट हुये, अपना लिये दण्ड तैयार करी रोस हइ. ");
INSERT INTO goj_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","परमेश्वर अपना हर एक खे ओका काम का अनुसार फल दीये. ");
INSERT INTO goj_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","जो दुन्या सुकर्म मे लग्या ऱ्ही खे महिमा, अरु आदर, अरु अमरता खे ढुंड ना मे हइ, उनखे परमेश्वर अनन्त जिवन दिये. ");
INSERT INTO goj_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","पन जो स्वार्थी हइ, अरु सच्चाइ का नकारस हइ फिर बुरोकाम करी सखे असा दुन्याहोन पर परमेश्वर अपनी घुस्सा अरु प्रकोप गिरास हइ. ");
INSERT INTO goj_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","अरु डर अरु संकट हर एक दुन्याहोन का जान पर जो बुरो करस हइ, ओका पर आह्ये, पैयले यहूदी पर फिर यूनानी पर. ");
INSERT INTO goj_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","पर महिमा अरु इज्जत अरु कल्याण हर एक खे मील्हे, जो अच्छो करस हइ, पैयले यहूदी खे फिर यूनानी खे. ");
INSERT INTO goj_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","क्युकि परमेश्वर बिना पक्षपात कि सब को न्याय करस हइ. ");
INSERT INTO goj_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","येकालिये जेने बिना व्यवस्था पास पाप कऱ्यो, वे बिना व्यवस्था को खतना भी हुये. अरु जेने व्यवस्था पइके पाप कऱ्यो, ओको दण्ड व्यवस्था का अनुसार हुये. ");
INSERT INTO goj_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","क्युकि परमेश्वर का यो व्यवस्था का सुननवाला धर्मी नी, पन व्यवस्था पर चलनआला धर्मी रुखी जाह्‍ये. ");
INSERT INTO goj_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","फिर जब गैरयहूदीहोन दुन्या का पास व्यवस्था नी हइ, पन फिर भी वे अपना आप मे व्यवस्था पर चलस हइ, यो वजा से उ अपना आप मे व्यवस्था फिर भी उनका पास मूसा कि व्यवस्था नी हइ. ");
INSERT INTO goj_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","उनको चाल चलन देखस हइ की व्यवस्था उनका दिल मे लीखी गइ हुइ अरु उनको विवेक भी उनखे बोलस हइ, कि यो सही हइ अरु येखे लिखे उनको बिचार उनखे अपराधी अरु नीरदोष समझस हइ ");
INSERT INTO goj_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","उ दिन परमेश्वर जो मे ने प्रचार कऱ्यो हुयो सुसमाचार का अनुसार यीशु मसीह का वजेसे इन्सान न्याय की गुप्त बात को न्‍याय कऱ्हे. ");
INSERT INTO goj_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","अगर तुम अपने आप खे यहूदी बोलस हइ, अरु व्यवस्था पर भरोसो रखस हइ, अरु अपना परमेश्वर को तोखे घमण्ड हइ, ");
INSERT INTO goj_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","अरु तोखे पतो हइ परमेश्वर तरा से का करणो चास हइ अरु अच्छी बात खे सुननो तुमने समज्हे नीयम शास्त्र से सिख्यो हइ. ");
INSERT INTO goj_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","अरु अपना आप पर भरोसो रखस हइ कि मी अंधाहोन को अगुवो, अरु अंधारा मे गिऱ्यो हुयो कि उजालो हइ, ");
INSERT INTO goj_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","अरु बदडिमाक खे सिखान आलो अरु भला दुन्या को मास्तर हइ. अरु तू नीश्चित हइ की जो व्यवस्था तरा पास हइ, ओमे पुरो सत्य अरु ज्ञान को समावेश हइ. ");
INSERT INTO goj_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","आखरी का तु जो दुसरा खे सिकास हइ, अपना आप का लिये लागु नी करस? का तु चोरी नी करण की शिक्षा देस हइ, आप ही चोरी करस हइ? ");
INSERT INTO goj_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","तू जो बोलस हइ, “व्यभिचार नी करणु,” का आप ही व्यभिचार करस हइ? तू जो मूर्ती से घृणा करस हइ, का तुम ही मन्दिरहोन खे लुटस हइ? ");
INSERT INTO goj_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","तुम जो परमेश्वर कि व्यवस्था का बारे मे घमण्ड करस हइ, का वा व्यवस्था नी मानीखे परमेश्वर को अनादर करस हइ? ");
INSERT INTO goj_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","क्युकि तुमारा कारन गैरयहूदीहोन मे परमेश्वर का नाम कि नीन्दा करी जास हइ, जसो शास्त्र मे भी लिख्यो हइ. ");
INSERT INTO goj_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","अगर तु व्यवस्था को पालन करस ते खतना से लाभ हइ, पन अगर तु व्यवस्था के अलग करस हइ ते तरो खतनो बिन खतना को जसो रुखे. ");
INSERT INTO goj_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","अरु अगर गैरयहूदीहोन जेको खतनो नी हुयो हइ फिर भी व्यवस्था को पालन करस हइ, ते का ओकी खतना रहित होन को भी खतना नी गिन्यो जाये? ");
INSERT INTO goj_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","अरु आप यहूदीहोन खे गैरयहूदीहोन का वजेसे दोषी ठैरायो जास जब की तुमारा पास लिखी हूइ व्यवस्था अरु खतना हुयो हइ, पन गैरयहूदीहोन व्यस्था को पालन करस हइ जब की उनका आंग का रुप से खतना नी हुयो हइ? ");
INSERT INTO goj_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","एक सच्च्चो यहूदी कोन हइ जेको वास्तव मे खतनो हुयो हइ उ कोन हइ, सच्चो यहूदी उ नी, जो फक्त बाहरी रुप से यहूदी हइ जेको खतना सिर्फ आंग मे हइ. ");
INSERT INTO goj_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","पन सच्चो यहूदी उ हइ जो अंदर से यहूदी हइ. जेको दिल से खतना हुयो हइ अरु ये परमेश्वर का आत्मा को काम हइ नी की लिखीत व्ययस्था को, असो इन्सान परमेश्वर का तरप से प्रशसा पाये नी की इन्सान का तरप से. ");
INSERT INTO goj_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","येकालिये गैरयहूदी का सामने तुमारो यहूदी होन को का फायदो अरु तुमारा खतना को का लाभ हुये? ");
INSERT INTO goj_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","हर प्रकार से भोत लाभ हइ. पैयले तो यो की परमेश्वर को वचन यहूदीहोन खे दियो गयो ");
INSERT INTO goj_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","अगर कुछ यहूदी विश्वास घाती नीकल्या भी ते का हुयो? का उनको विश्वास घाती होना से परमेश्वर कि सच्ची व्यर्थ रखस? ");
INSERT INTO goj_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","अगर नी! जब परमेश्वर सच्चीइ अरु हर एक इंन्सान झुटो हुइ सकस हइ, जसो शास्त्र मे लिख्यो हइ “जब तु खुद खे बचाना मे बोले ते तु सही ठैरे अरु जब तरो न्याय हुये न्याय करण टेम तू जिती पाये.” ");
INSERT INTO goj_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","येकालिये अगर हमारो गलत काम परमेश्वर कि अधर्म रखी देस हइ, का हम बोली सकस हइ? की जब परमेश्वर हमखे सजा करस हइ ते का उ गलत करस हइ ते मी इंन्सान कि रीति पर बोलस हुये. ");
INSERT INTO goj_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","अगर नी! नी ते परमेश्वर कसो संसार का न्याय करस? ");
INSERT INTO goj_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","अगर मरो झुठ का कारन परमेश्वर कि सच्ची ओकि महिमा का लिये, अधिक करि खे प्रगट हुयो ते फिर का पापी दुन्याहोन का सामने सजा का योग्य रख्यो जास हुये? ");
INSERT INTO goj_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","हम का बुराइ नी कर्हे की “भलाइ निकलस जसो हम पर यो दोष लगास भी जास हइ?” अरु कुछ बोलस हइ कि ओको यो बोलनो हइ. पन असो का दोषी रखस ठीक हइ. ");
INSERT INTO goj_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","ते फिर का हुयो? का हम यहूदीहोन मे से अच्छो हइ कभी नी. किक्यु हम यहूदीयाहोन अरु यूनानीहोन दोय पर यो दोष लगय चुक्या हइ कि वे सब का सब पाप का काबु मे हइ. ");
INSERT INTO goj_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","जसो पवित्रशास्त्र मे लिख्यो हइ: “कोय भी धर्मी नीका एक भी नी. ");
INSERT INTO goj_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","कोय समझदार नी. कोय परमेश्वर का धुडनआलो नी. ");
INSERT INTO goj_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","सब गमी गया हइ का सब का सब नीकम्मा बनी गया हइ. कोय भलाइ करणवाला नी एक भी नी. ");
INSERT INTO goj_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","उनको गंलो खुली हुइ कब्र हइ, उनने अपनी जीभ से छल कऱ्यो हइ उनका होट मे साप को जहर हइ. ");
INSERT INTO goj_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","उनको मुडो श्राप अरु कडुपन से भऱ्यो हइ. ");
INSERT INTO goj_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","ओको पाय खुन बोहान को फुर्तीलो हइ, ");
INSERT INTO goj_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","उनका रस्ता मे नाश अरु दुख हइ, ");
INSERT INTO goj_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","ओने शांती की रस्ता नी जान्यो. ");
INSERT INTO goj_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","ओका आख का सामने परमेश्वर को डर नी.” ");
INSERT INTO goj_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","हम जानस हइ कि व्यवस्था जो कुछ बोलस हइ उन से बोलस हइ, जो व्यवस्था को अधीन हइ येकालिये कि हर एक मुडो बंद कऱ्यो जास अरु सब संसार परमेश्वर का न्याय का योग्य रुखस ");
INSERT INTO goj_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","क्युकी व्यवस्था का काम से कोय इन्सान ओका सामने धर्मी नी रुखे, येकालिये कि व्यवस्था का वजेसे पाप की पहचान होस हइ. ");
INSERT INTO goj_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","पन अब व्यवस्था से अलग परमेश्वर को उ धर्मीकता प्रगट हुयो हइ, जेकी गवय मूसा की व्यवस्था से अलग हइ अरु भविष्यव्दक्ता देस हइ, ");
INSERT INTO goj_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","अगर परमेश्वर कि वा धर्मीकता जो यीशु मसीह पर विश्वास करणा से मीलस हइ सब विश्वास करणआलो का लिये हइ. क्युकी कुछ भेदभाव नी. ");
INSERT INTO goj_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","येकालिये कि सब ने पाप कऱ्यो हइ अरु परमेश्वर कि महिमा से ऱ्हेस हइ, ");
INSERT INTO goj_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","पन ओका अनुग्रह से उ छुटकारा का वजेसे जो मसीह यीशु मे सब का सब हइ, मुक्त धर्मी रख्यो जास हइ ");
INSERT INTO goj_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","यीशु खे परमेश्वर ने ओका खुन का वजेसे एक असो प्राचित बली रख्यो, जो विश्वास करणा से कार्य कारी होस हइ, की जो पाप पैयले कऱ्यो गयो अरु जेका पर परमेश्वर ने अपनी सहनशीलता का कारन जगा नी दियो. ओका बारे मे वो अपनी धर्मीकता प्रगट करस. ");
INSERT INTO goj_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","वरन वोको टेम मे ओकी धर्मीकता प्रगट होस जेका से परमेश्वर आप ही धर्मी रख्यो, अरु जो यीशु पर विश्वास कर ओका भी धर्मी रख्यनआलो होस. ");
INSERT INTO goj_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","तरे घमण्ड करनो बोल्यो ऱ्हेस ओकी तो जगत ही नी. कोनसी व्यवस्था का कारन से? का काम की व्यवस्था से? नी वरन विश्वास की व्यवस्था का कारन. ");
INSERT INTO goj_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","येकालिये हम यो परिणाम पर पोचस हइ कि इंन्सान व्यवस्था का काम से अलग ही, विश्वास का वजेसे धर्मी रखस हइ. ");
INSERT INTO goj_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","का परमेश्वर फक्त गैरयहूदीहोन हि को हइ? का यहूदीहोन को नी? हा सब जात को भी हइ. ");
INSERT INTO goj_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","किक्यु एक ही परमेश्वर हइ, जो खतना आला का विश्वास से अरु खतनो कऱ्हेस खे भी विश्वास का वजेसे रखस. ");
INSERT INTO goj_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","ते का हम व्यवस्था को विश्वास का वजेसे व्यर्थ रखस हइ? अगर नी! वरन व्यवस्था का स्थिर करस हइ. ");
INSERT INTO goj_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","येका लिये हम का बोले हमारो आंग बाप अब्राहम खे मील्हे हुयो? ");
INSERT INTO goj_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","किक्यु अगर अब्राहम काम से धर्मी ठैरायो जास ते ओको घमण्ड करस की जगा होस, पन परमेश्वर का बाहेर नी. ");
INSERT INTO goj_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","पवित्रशास्त्र का बोलस हइ? यो की “अब्राहम ने परमेश्वर पर विश्वास कऱ्यो, अरु यो ओका लिये धार्मीकता गिन्यो गयो.” ");
INSERT INTO goj_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","काम करणवालो की मजुरी देनो दान नी, पन हक्क समझ जास हइ. ");
INSERT INTO goj_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","पन जो काम नी करस जब भक्तिहीन खे धर्मी रखन आलो पर विश्वास करस हइ, ओको विश्वास ओका लिये धार्मीकता गिन्यो जास हइ. ");
INSERT INTO goj_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","जेखे परमेश्वर बिना काम को धर्मी रखस हइ, ओखे खाना पर भी दाउद धन्य करस हइ ");
INSERT INTO goj_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“धन्य हइ वे जेको अधर्म माफ हुयो, अरु जेको पाप झाक्यो गयो. ");
INSERT INTO goj_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","धन्य हइ उ इन्सान जेखे परमेश्वर पापी नी ठहराये.” ");
INSERT INTO goj_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","ते यो धन्य वचन का खतनवालो ही का लिये हइ यो खतना रहीत का लिये भी? हम यो बोलस हइ, “अब्राहम का लिये ओको विश्वास धार्मीकता गिन्यो गयो.” ");
INSERT INTO goj_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","ते वो कसो गिन्यो गयो? खतना का भाग मे या बिना खतना का भाग मे? खतम का भाग मे नी पन बिना खतना का भाग मे. ");
INSERT INTO goj_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","ओने खतना को चिन्ह पाय को उ विश्वास को धार्मीकता प्राप्त हुयो जास जो ओने बिन खतना को भाग मे रख्यो थो, जेका से वो उ सब को बाप रख्यो जो बिन खतना को भाग मे विश्वास करस हइ ताकी वे भी धर्मी रख्यो: ");
INSERT INTO goj_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","अरु उ खतना करणु हुया को बाप हुये जो न कम खतना कऱ्यो हुयो हइ, पन हमारो बाप अब्राहम खे उ विश्वास क लिख पर भी चलास हइ जो ओने बिन खतना को भाग मे कऱ्यो थो. ");
INSERT INTO goj_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","क्युकी यो प्रतीज्ञा करी वो जगत को बेटो हुयो नी अब्राहम को नी ओको वस की व्यवस्था का वजेसे दी गयो थो, पन विश्वास कि धार्मीकता का वजेसे मीलस. ");
INSERT INTO goj_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","क्युकी अगर व्यवस्थावालो वारिस हइ, ते विश्वास व्यर्थ अरु प्रतीज्ञा नीष्फल रख. ");
INSERT INTO goj_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","व्यवस्था ते घुस्सा सबजात हइ, अरु झा व्यवस्था नी वहा ओका उल्लंघन भी नी. ");
INSERT INTO goj_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","वो कारन प्रतीज्ञा विश्वास पर आधारीत हइ की अनुग्रह की रित पर होस, की वह ओका सब कुल का लिये दृढ हुये, नी की फक्त ओका लिये जो व्यवस्थावालो हइ जब ओका लिये भी जो अब्राहम का सामने हइ. वु तो हम सब को बाप हइ, ");
INSERT INTO goj_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","जसो लिख्यो हइ, “मे ने तो भोत सा जातहोन को बाप रख्यो हइ” उ परमेश्वर का सामने जेको पर ओने विश्वास कऱ्यो, अरु जो मऱ्यो हुयो, जिलास हइ अरु जो बात हइ हि नी ओको नाम असो लेस हइ की मान वे हइ. ");
INSERT INTO goj_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","ओने नीरास मे भी आस रखी खे विश्वास कऱ्यो, येका लिये कि उ वचन का जसो की “तरो कुल असो हुये कि” वे भोत सी जातहोन को बाप होस. ");
INSERT INTO goj_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","वो जो एक सौ साल को थो, अपनो मऱ्यो हुया से आंग अरु सारा का गर्भ पर मरी हुइ कि भाग जानीखे भी विश्वास मे नीर्बल नी हुयो, ");
INSERT INTO goj_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","अरु न अविश्वासी हुइखे परमेश्वर कि प्रतीज्ञा पर सदेस कऱ्यो, पर विश्वास मे दृढ हुइ, परमेश्वर की महिमा करी. ");
INSERT INTO goj_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","अरु नीश्चय जास की जो बात कि ओने प्रतीज्ञा करी हइ, उ ओ पुरो करण मे भी समर्थ खे हइ. ");
INSERT INTO goj_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","यो कारन यो ओका लिये धार्मीकता गिन्यो गयो. ");
INSERT INTO goj_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","अरु यो वचन, “विश्वास ओका लिये लिख्यो गयो,” नी फक्त ओका लिये लिख्यो गयो, ");
INSERT INTO goj_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","जब हमारा लिये भी जेका लिये विश्वास धार्मीकता गिन्यो जाए, अगर हमारा लिये जो ओका पर विश्वास करस हइ जेने हमारा प्रभु यीशु खे माऱ्या हुये मे से जिन्दो कऱ्यो. ");
INSERT INTO goj_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","उ हमारो अपराधहोन क लिये पकडनवालो गयो अरु हमारो धर्मी रुखन का लिये जिन्दो भी गयो. ");
INSERT INTO goj_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","अब जो हम अपना विश्वास करण परमेश्वर का सामने धर्मी हुइ गया हइ हमारो प्रभु यीशु मसीह का वजेसे हम खे शांती मीली हइ , ");
INSERT INTO goj_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","अरु अब ओका वजेसे विश्वास करण हम परमेश्वर का अनुग्रह मे जिवन जीस हइ, अरु हम खे परमेश्वर कि महीमा का वजेसे भागीदारी हूइ हइ. ");
INSERT INTO goj_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","येतनो ही नी हम हमारी विपत्तिहोन पर भी घमण्ड करस हइ क्युकी हम खे मालुम हइ की हमारी विपत्ति धीरज खे पइदा करस हइ, ");
INSERT INTO goj_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","अरु धीरज से परख नो हुयो चरीत्र बन्यो हइ अरु परख्यो हुयो चरीत्र से आस पइदा होस हइ. ");
INSERT INTO goj_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","अरु आस से लाज नी होस, क्युकी पवित्र आत्मा जो हमखे दि गय हइ ओका वजेसे परमेश्वर को लाड हमारो मन मे डाल्यो गयो हइ. ");
INSERT INTO goj_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","क्युकी जब हम आशाहिन था ते उचित टेम पर हम भक्तिहीन का लिये मसीह ने अपनो बलिदान दियो. ");
INSERT INTO goj_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","कोय धर्मी जान का लिये कोय मऱ्यो, यो ते दुर्लब हइ. पन हुइ सकस हइ कोय अच्छो इन्सान का लिये कोय मरन को भी साहस कर. ");
INSERT INTO goj_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","पन परमेश्वर हम पर अपनो लाड की अच्छो वोकी रित से प्रगट करस हइ, जब हम पापी हि था तेभी मसीह हमारा लिये मऱ्यो. ");
INSERT INTO goj_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","ते जब कि हम अब ओका खुन का कारन धर्मी रख्या, तो ओका वजेसे परमेश्वर को घुस्सा से नी बच्यो जाये! ");
INSERT INTO goj_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","जब हम परमेश्वर का दुशमन था आ को मरना का वजेसे हमारा सात मेल मीलाप कऱ्यो अरु जब हम परमेश्वर को बेटो हइ ते उ मसीह को जिवन का वजेसे भोत जादा हमारो उध्दार करस ");
INSERT INTO goj_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","फक्त यो नी, पन हम अपनो प्रभु यीशु मसीह का वजेसे, जेका वजेसे हमारो परमेश्वर का सात मेल-मीलाप हुयो हइ. ");
INSERT INTO goj_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","येका लिये जसो एक इन्सान का वजेसे पाप जगत मे आयो, अरु पाप का वजेसे मऱ्यो आयो,अरु येका रीति से मऱ्यो सब इन्सान मे फैली गयो, क्युकी सब ने पाप कऱ्यो. ");
INSERT INTO goj_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","क्युकी व्यवस्था आना से पैयले पाप थो जाना तक जगत मे थो, पन झा व्यवस्था नी उ पाप गिन्यो नी जास. ");
INSERT INTO goj_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","पन आदम से लिखे मूसा ने वे दुन्या पर राज्य कऱ्यो, फिर भी वे दुन्याहोन ने आदम जसो आज्ञा तोडन को मरन पाप नी कऱ्यो थो जेने आदम को आनवाला को नमुनो नी ठैरायो हइ. ");
INSERT INTO goj_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","अरु परमेश्वर को वरदान अरु एक इन्सान को पाप ये दो यीशु मसीह मे फरक हइ, फिर एक पापकरण दोष को कारन सब दुन्या मऱ्या; पन यो इच्छा से बोल्यो जादा महान हइ परमेश्वर कि अनुग्रह पन को न्याय आस एक का वजेसे भोत मीली. ");
INSERT INTO goj_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","अरु परमेश्वर जसो एक इन्सान को पाप करण को फल हुयो वोसो हि दान को भोग नी, क्युकी एक ही कारन दण्ड की आज्ञा को फैसलो हुयो, पन भोत सा अपराधी का कारन असो वरदान पइदा हुयो कि दुन्या धर्मी रख्खा. ");
INSERT INTO goj_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","क्युकी जब एक इन्सान का अपराध का कारन मऱ्यो उ एक ही का वजेसे राज्य कऱ्यो, ते जो दुन्या अनुग्रह अरु धर्मी रुपी वरदान भोतायत से पास हइ वे एक इन्सान खे अगर यीशु मसीह का वजेसे जरुरी हइ अनन्त जिवन मे राज कऱ्यु. ");
INSERT INTO goj_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","येका लिये जसो एक अपराध सब दुन्या का लिये दण्ड कि आज्ञा कारन हुयो ओसो हि एक धर्मीकता को काम भी सब इन्सान का लिये जिवन खे नीमीत धर्मी रख्यो जान का कारन हुयो. ");
INSERT INTO goj_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","क्युकी जसो एक इन्सान का आज्ञा न मारना से भोत दुन्या पापी रखस, उ कारण सब दुन्या धर्मी रुख्या. ");
INSERT INTO goj_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","व्यवस्था को परिचित येका लिये हुया कि अपराध बडो हुयो पन झा पाप भोत हुया वहा परमेश्वर को अनुग्रह भी अधिक हुया, ");
INSERT INTO goj_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","कि जसो पाप ने मऱ्यो फैलास हइ राज कऱ्यो, वोसो हि हमारो प्रभु यीशु मसीह का वजेसे अनुग्रह भी अनन्त जिवन का लिये धर्मी रखस हुये राज कर. ");
INSERT INTO goj_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","ते हम अब का बोले? का हम लगातार पाप करस ऱ्हेस की परमेश्वर को अनुग्रह भोत होस? ");
INSERT INTO goj_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","अगर नी! हम जब पाप का लिये मरी गया ते फिर येका आगे को ओमे कसो जिवन बिताये? ");
INSERT INTO goj_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","का तुम नी जानस की हम सब जेने मसीह यीशु मे बपतिस्मा लियो, ओका मरन का एकता मे बपतिस्मा लियो. ");
INSERT INTO goj_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","येकालिये उ मरन को बपतिस्मा पाना से हम ओका साथ गाड्यो गयो, ताकी जसो मसीह बाप की महिमा का शक्ति का वजेसे मऱ्यो हुयो मे से जिन्दो हुय गयो, वसो हि हम भी नव्या जिवन से चाल चले. ");
INSERT INTO goj_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","क्युकी अगर हम ओको मरन कि समानता मे ओका साथ जुडि गयो हइ, ते नीश्चय ओको जिन्दो उठस को समानता मे भी जुडि जाए. ");
INSERT INTO goj_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","हम जानस हइ की हमारो पुरानो इंन्सान ओका साथ क्रुस पर चेडायो गयो तेभी पाप को आंग व्यर्थ हुइ जास, अरु हम आगे का पाप का दास मे नी ऱ्हेस. ");
INSERT INTO goj_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","क्युकी जो मरी गयो, उ पाप का बन्धन से मुक्त हुइ गो. ");
INSERT INTO goj_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","येकालिये यो हम मसीह का साथ मरी गया, ते हमारो विश्वास यो हइ कि ओका साथ जिये भी. ");
INSERT INTO goj_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","क्युकी यो जानस हइ की मसीह मऱ्यो हुये मे से जिन्दो उठि खे फिर मरन को नी, ओका पर फिर मरन को प्रभु नी होन को. ");
INSERT INTO goj_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","क्युकी उ जो मरी गयो ते पाप का लिये एक ही बार मरी गयो. पन जो जिन्दो हइ ते परमेश्वर का लिये जिन्दो हइ. ");
INSERT INTO goj_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","यो प्रकार तुम भी समझ कि तुम पाप का लिये मरी चुक्या हइ, पन प्रभु मसीह यीशु मे जिन्दो हुये. ");
INSERT INTO goj_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","येकालिये पाप तुमारो नश्वर आंग मे राज नी करस, की तु ओकी इच्छाहोन का अधीन ऱ्हेस. ");
INSERT INTO goj_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","अपनो आंग का आंग खे अधर्म कि सेवा का लिये पाप का हवाले करणू, बल्की मऱ्यो हुयो मे से जी उठन आला का जसो परमेश्वर का हवाले करी दे, अरु अपना आंग खे धर्मीकता कि सेवा का साधन का रुप मे परमेश्वर का हवाले करी दे. ");
INSERT INTO goj_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","तब तुम पर पाप की प्रभुता नी हुये, क्युकी तु व्यवस्था का अधीन नी पन परमेश्वर को अनुग्रह का अधीन हुये. ");
INSERT INTO goj_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","ते का हुयो? का हम पाप कर्‍हे क्युकी हम व्यवस्था का अधीन नी बल्की परमेश्वर का अधीन जीत्या हइ? अनुग्रह ही नी! ");
INSERT INTO goj_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","का तु नी जानस कि जेकी आज्ञा मानन का लिये तु अपना आप खे सेवक का सामने सोपि देता हुये ओको सेवक हुये चाह्ये पाप का, जेको अन्त मरन हइ चाह्ये, आज्ञा मानन खे जेको अन्त न्यायपन हइ? ");
INSERT INTO goj_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","पन परमेश्वर को धन्यवाद हुइ खे तु जो पाप को सेवक थो अब मन से उ उपदेश खे माननआलो हुये गयो, जेखे साच मे डाल्यो गयो थो, ");
INSERT INTO goj_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","अरु पाप से छुडय जानीखे धर्म को सेवक हुये गयो. ");
INSERT INTO goj_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","मी तुमारो उदाहरण दुर्बलता का कारन इंन्सान की रित पर बोलस हइ. जसो तु अपनो आंग खे कुकर्म का लिये अच्छो अरु बुरो काम को सेवक करि खे सोप्यो थो, असो हि अब अपनो आंग का पवित्र का लिये धर्म को दास करी खे सोपी दे. ");
INSERT INTO goj_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","जब तु पाप को सेवक थो, ते धर्म का तरप से स्वतंत्रत थो ");
INSERT INTO goj_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","जो बात से अब तु लज्जित होस हइ, ओने उ टेम तु का फल पातो थो? क्युकी ओका आखरी तो मरन हइ. ");
INSERT INTO goj_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","पन अब पाप से स्वतंत्रता हुइ खे अरु परमेश्वर को सेवक बनीखे ते का फल मील्यो जेकासे पवित्रता मील्हे होस हइ, अरु ओको आखरी जिवन हइ. ");
INSERT INTO goj_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","क्युकी पाप की मजुरी मरनो हइ, पन परमेश्वर को वरदान हमारो प्रभु मसीह यीशु मे आखरी जिवन हइ. ");
INSERT INTO goj_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","हे भैइ, तु नी जानस-मी व्यवस्था को जाननवालो से बोलस हुये-कि जब तक इन्सान जिन्दो ऱ्हेस हइ, तब तक ही ओका पर व्यवस्था को अधिकार ऱ्हेस हइ? ");
INSERT INTO goj_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","क्युकी उदाहरन का लिये एक सादीसुदा बय अपना अदमी का सात व्यवस्था का जसो तब तक बंधी हइ जब तक उ जिन्दो हइ पन अगर अदमी मरी जास हइ ते वा सादी सबधी व्यवस्था से मेत हुइ जास हइ. ");
INSERT INTO goj_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","येका लिये अगर अदमी का जिते जि वा कोय दुसरा अदमी कि हुये जाए, ते व्यभिचारिणी बोलस, पन अगर अदमी मरी जाए, ते वा उ व्यवस्था से छुटी गइ, यो तक की अगर कोइ दुसरो अदमी हुइ जाये तेभी व्यभिचारिणी नी रखस. ");
INSERT INTO goj_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","ओसो ही हे मरा भैइ, तु भी मसीह का आंग का वजेसे व्यवस्था का लिये मरो हुयो बनी गयो, की उ दुसरो हुइ जाए, जो मऱ्यो हुयो मे से जिन्दो उठ्यो ताकी हम परमेश्वर का लिये फल लाए. ");
INSERT INTO goj_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","क्युकी जब हम शारीरिक था, ते पाप की लालसाहोन जो व्यवस्था का वजेसे थी काम को फल उत्पन्न करण का लिये हमारो आंग मे काम करती थी. ");
INSERT INTO goj_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","पन जेका बन्धन मे हम था ओका लिये मरी क अब व्यवस्था से असो छुटी गयो की लेख की पुरानी रीति पर नी जब आत्मा की नवी रीति पर सेवा करस हइ. ");
INSERT INTO goj_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","ते हम का बोले? का व्यवस्था पाप हइ? कभी नी! पन व्यवस्था का बिना मी पाप खे नी पचानू व्यवस्था अगर नी बोलस कि का लालसा मत कर ते मी लालच खे नी जानुस. ");
INSERT INTO goj_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","पन पाप ने अवसर पालस आज्ञा का वजेसे मरा मे सब प्रकार की लालच उत्पन्न कऱ्यो, क्युकी बिन व्यवस्था पाप मुर्दो हइ. ");
INSERT INTO goj_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","मे तो व्यवस्था बिन पैयले जिन्दो थो, पन जब आज्ञा आह्ये ते पाप जी गयो, अरु मी मरी गयो. ");
INSERT INTO goj_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","अरु वो आज्ञा जो जिवन का लिये थो मरा लिये मरन को कारन रख्यो. ");
INSERT INTO goj_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","क्युकि पाप ने अवसर लिखे आज्ञा का वजेसे मेखे बहकायो अरु ओका वजेसे मेखे मरी भी डाल्यो ");
INSERT INTO goj_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","येका लिये व्यवस्था पवित्र हइ अरु आज्ञा भी अच्छी हइ अरु अच्छी हइ. ");
INSERT INTO goj_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","ते का उ जो अच्छो थो मरा लिये मरन रख्यो? अगर नी! पन पाप उ अच्छा चिज का वजेसे मरा लिये मरन को उत्पन्न करणवालो हुयो की ओको पाप होना पर प्रगट हुये अरु आज्ञा का वजेसे पाप भोत हि पापमय रख्यो. ");
INSERT INTO goj_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","हम जानस हइ कि व्यवस्था ते आत्मीक हइ, पन मी आंग का अरु पाप का हात बिक्यो हुयो हइ. ");
INSERT INTO goj_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","जो मी नी करस हुये ओखे नी जानस क्युकी जो मी चास हूये वो नी कऱ्यो करस, पन जेका से मेखे घुसा आस हइ उ करस हुये. ");
INSERT INTO goj_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","अगर जो मी नी चाउस वो करस हइ ते मी मानी लीयुस हुये की व्यवस्था भली हइ. ");
INSERT INTO goj_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","ते असो भाग मे ओको करणवालो मी नी, जब पाप हइ जो मेखे बट्यो हुयो हइ. ");
INSERT INTO goj_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","क्युकी मी जानस हूये की मेखे मी अगर मरो आंग मे कोय अच्छो चिज वास नी करस. इच्छा ते मरा मे हइ, पन अच्छो काम मरा से बनी नी पडस. ");
INSERT INTO goj_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","क्युकी जो अच्छो काम की मी इच्छा करस हुये खे वो ते नी करस, पन जो बोल की इच्छा नी करस, उ ही कऱ्यो करस हइ. ");
INSERT INTO goj_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","अत अगर मी वो करस हुये जेकी इच्छा नी करस, ते ओका करणवालो मी नी ऱ्हु पन पाप जो मरा मे बट्यो हुयो हइ. ");
INSERT INTO goj_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","ते मी यो नीयम बोलुस हइ की जब बुरो करण की मी इच्छा करस हुये ते बुरो मरा पास आस हइ. ");
INSERT INTO goj_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","क्युकी मी अंदर कि आत्मा से ते परमेश्वर कि व्यवस्था से भोत प्रसन्न ऱ्हेस हइ. ");
INSERT INTO goj_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","पन मरा अपना आंग मे दुसरा प्रकार की व्यवस्था देखनु पडस हइ, जो मरी दिमाक की नीयम से लडतो करस हइ अरु मेखे पाप का नीयम का बन्धन मे डालस हइ जो मरा आंग मे हइ. ");
INSERT INTO goj_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","मी कसो अभागो इन्सान हुये! मरा से मरन की आंग से कोन छुडाये? ");
INSERT INTO goj_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","जो हम खे छुटकारो देस हइ उस प्रभु यीशु मसीह का वजेसे मी परमेश्वर को धन्यवाद करस. यो तरह दिमाक से ते परमेश्वर की नीयम को पन आंग से पाप की नीयम को पालन करस हइ. ");
INSERT INTO goj_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","येका लिये अब जो मसीह यीशु मे जिवन जिस हइ, उन पर दोष की आज्ञा नी. ");
INSERT INTO goj_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","क्युकी जिवन को आत्मा की व्यवस्था ने मसीह यीशु मे मेखे पाप कास अरु मरन की व्यवस्था से स्वतत्रता करी दियो. ");
INSERT INTO goj_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","क्युकी जो काम व्यवस्था आंग करन दुर्बल हुइखे नी करी सक्ता ओखे परमेश्वर ने कऱ्यो, अगर अपनो ही बेटा के पापमय आंग को समानता मे अरु पापबली होन का लिये भेजी खे, शरीर मे पाप पर शिक्षा की आज्ञा दि. ");
INSERT INTO goj_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","येका लिये व्यवस्था की विधी हम मे आंग का जसो नी वरन आत्मा का जसो चलस हइ, पुरी करी जा. ");
INSERT INTO goj_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","क्युकी शारीरिक व्यक्ति शरीर की बात पर आत्मा लगास हइ. पन अध्यात्मीक मन की बात पर मन लगास हइ. ");
INSERT INTO goj_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","शरीर पर मन लगानो तो मरन हइ पन आत्मा पर मन लगानो जिवन अरु शांती हइ. ");
INSERT INTO goj_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","क्युकी आत्मा पर मन लगानो ते परमेश्वर से बैर रखनो हइ, क्युकी नी ते परमेश्वर की व्यवस्था का अधीन हइ अरु नी हुये सकस हइ. ");
INSERT INTO goj_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","पन जो मानविक स्वभाव मे जीस हइ, वे परमेश्वर खे प्रसन्न नी करस. ");
INSERT INTO goj_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","पन जब की परमेश्वर कि आत्मा तुम मे बठस हइ, ते तु शारीरिक भाग मे नी पन आत्मीक भाग मे हइ. अगर कोय मे मसीह को मन नी ते उ ओको नी हइ. ");
INSERT INTO goj_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","अगर मसीह तुम मे हइ, ते आंग पाप का कारन मरो हुयो हइ. पन आत्मा धर्म का कारन जिन्दो हइ. ");
INSERT INTO goj_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","अगर ओ की आत्मा जेने यीशु खे मऱ्यो हुयो मे से जिन्दो, तुम मे बट्यो हुयो हइ. ते जेने मसीह खे मऱ्यो हुयो मे से जिन्दो, उ तुमारो नश्वर आंग का भी अपना मन का वजेसे जो तुम मे बट्यो हुयो हइ जिन्दो कर्हे. ");
INSERT INTO goj_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","येका लिये हे मरा भैइ अरु बहन, हम का आंग को कर्जो तो हइ पन असो नी येका जसो जिये, ");
INSERT INTO goj_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","क्युकी अगर तु आंग का जसो दिन काटस ते मरस अगर आत्मा से आंग कि कामहोन खे मरस ते जिन्दो ऱ्हे. ");
INSERT INTO goj_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","येका लिये की जितना दुन्या परमेश्वर का आत्मा को चाल चलस हइ वे हि परमेश्वर का सन्तान हइ. ");
INSERT INTO goj_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","क्युकी तुम खे दासत्व की आत्मा नी मीली खे फिर डरानो हुयो पन परमेश्वर को बेटा कि आत्मा मीलि हइ ,जेका से हम हे अब्बा, हे बाप बोली खे बुलास हइ. ");
INSERT INTO goj_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","आत्मा अपनो हि हमारा आत्म का साथ गवाही देस हइ, की हम परमेश्वर की सन्तान हइ. ");
INSERT INTO goj_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","अरु अगर सन्तान हइ ते वारीस भी, वरन परमेश्वर को वारीस अरु मसीह का साथ वारीस हइ, की जब हम ओका साथ दुख उठाये ते ओका साथ महिमा भी पास. ");
INSERT INTO goj_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","क्युकी मी समझस हुये की उ टेम का दुख अरु क्लेश उ महिमा का सामने, जो हम पर प्रगट होनआली हइ, कुछ भी नी हइ. ");
INSERT INTO goj_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","क्युकी सृष्टी बडी आस भरी दृष्टी से परमेश्वर को बेटा प्रगट होन की रस्ता देखस हइ. ");
INSERT INTO goj_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","क्युकी सृष्टी अपनी इच्छा से नी पर अधीन करणवाला की तरप से व्यर्थ का अधीन या आस से करी गयो ");
INSERT INTO goj_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","की सृष्टी भी तु ही विनास खे दासत्व से छुटकारो पइखे, परमेश्वर की सन्तान की महिमा की स्वतत्रता मली करस. ");
INSERT INTO goj_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","क्युकी हम जानस हइ की सब सृष्टी अभी तक मीली खे बोलस जसा बच्चा कि अरु तकलीप की पीडा मे जन्म लेस हइ. ");
INSERT INTO goj_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","अरु फक्त वो नी पर हम भी जेका पास आत्मा को पयलो फल हइ, तु ही अपना मे बोलस हइ. अरु बेटा होन की, अगर अपनो आंग को छुटकारा की बात करस हइ. ");
INSERT INTO goj_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","या आस का वजेसे हमारो उध्दार हुयो हइ, पन जो सामन की आस करी जास हइ, जब उ देखना मे आये ते फिर आस बोल्यो ऱ्हेस? क्युकी जो सामन खे कोय देखी रो हइ ओकी आस कर्‍हे? ");
INSERT INTO goj_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","पन जो सामन खे हम नी देखस, अगर ओकी आस रखस हइ, ते धीरज से ओकी रस्ता देखस भी हइ. ");
INSERT INTO goj_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","या रिती से आत्मा भी हमारो दुर्बलता मे सायता करस हइ क्युकी हम नी जानस की प्रार्थना कोइ रीति से करणो चाहिए, पन आत्मा तु ही असो आवाज भर भरी खे जो गवा से बाहेर हइ, हमारा लिये विनती करस हइ. ");
INSERT INTO goj_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","परमेश्वर हमारा आत्मा खे जानस हइ अरु आत्मा को बिचार करस ह ? क्युकी उ पवित्र दुन्या का लिये परमेश्वर की का जसो प्रार्थना करस हइ. ");
INSERT INTO goj_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","हम जानस हइ की जो दुन्या परमेश्वर से प्रेम रखस हइ, ओका लिये सब बात मीली खे अच्छो ही उत्पन्न करस हइ, अगर ओका लिये जो ओकी इच्छा का जसो बुलायो हुयो हइ. ");
INSERT INTO goj_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","क्युकि जेने ओने पैयले से जानी लियो हइ उ पैयले से रख्यो भी हइ की ओको बेटा का स्वरुप मे हुयो, जबकी उ भोत भैइहोन मे पहिलौठा रखे. ");
INSERT INTO goj_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","फिर जेने ओने पैयले से ठैरायो, ओने बुलायो भी, अरु जेने बुलायो, ओने धर्मी भी ठैरायो हइ. अरु जेने धर्म ठैरायो, उन्हे महिमा भी दि हइ. ");
INSERT INTO goj_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","ते हम या बात का बारे मे बोले? अगर परमेश्वर हमारा तरप हइ, ते हमारो विरोधी कोन हुइ सकस हइ? ");
INSERT INTO goj_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","जेने अपना नीज बेटा खे भी नी रखी छोड्यो, पन ओको हम सब का लिये दी दियो, उ हम खे पुरा उध्दार से उ हम खे भोत कुछ देस? ");
INSERT INTO goj_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","परमेश्वर का चुन्यो हुया पर दोष कोन लगाए? परमेश्वर उ हइ जो ओको धर्मी रखनवालो हइ. ");
INSERT INTO goj_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","फिर कोन हइ जो परमेश्वर खे दण्ड की आज्ञा दिये? मसीह ही हइ जो मरी गयो जब मुर्दा मे से जिन्दो भी उठ्यो, अरु यीशु का जवना तरप हइ, अरु हमारा लिये नीवेदन भी करस हइ. ");
INSERT INTO goj_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","कोन हम खे मसीह का प्रेम से अलग करस? का कठनाइ, या संकट, या टेम, या सताव, या भुकमारी, या गरीब, या जोखीम, या मरन? ");
INSERT INTO goj_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","जसो शास्त्र मे लिख्यो हइ “तरा लिये हम दिन भर माऱ्या जास हइ. हम वध होनवाला मेडाहोन का समान गिन्या गया हइ.” ");
INSERT INTO goj_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","पन या सब बात मे हम ओका वजेसे जेने हम से प्रेम कऱ्यो हइ, पुरो विजय मील्हे करी रास हइ. ");
INSERT INTO goj_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","क्युकी मी निश्चित जानुस हुये की कोय हम खे ओका प्रेम से अलग नी करी सकस मरन, नी जिवन, नी स्वर्गदूत, नी खराप शासन, नी वर्तमान, नी भविष्य, नी सामर्थ्य, नी उचो, ");
INSERT INTO goj_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","नी पृथ्वी गैरो, अरु नी कोय अरु पृथ्वी कि उचाइ, अरु नी जगत मे असी कोय नी हइ जो हम खे परमेश्वर को प्रेम से अलग करी सकस हइ. ");
INSERT INTO goj_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","मी मसीह मे सच्ची बोलस हय, मी झुटी नी बोली रोस अरु मरो विवेक भी पवित्र आत्मा मे गवय देस हइ ");
INSERT INTO goj_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","की मेखे बडो शोक अरु दर्द हइ, अरु मरो मन कभी भी दुखी रोस हइ, ");
INSERT INTO goj_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","क्युकी मी ह्या तक चातो थो की अपना भैइ का लिये जो आंग का भाव से मरा कुटुम्बी हइ, परमेश्वर से श्रापित अरु मसीह से अलग हुये जाए. ");
INSERT INTO goj_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","वे इस्त्राएलि हइ, अरु परमेश्वर से सन्तान अधिकार अरु महिमा अरु वाचा अरु व्यवस्था अरु उपास अरु प्रतीज्ञा ओने करी हइ. ");
INSERT INTO goj_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","बुजुरुख भी ओका ही हइ, अरु मसीह भी आंग का भाव से ओका मेसे हुयो. सब का उपर परम परमेश्वर राज्य करस पिडमपिडि धन्य होस. आमीन. ");
INSERT INTO goj_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","पन यो नी की परमेश्वर को वचन नीकली गयो, येकालिये की जो इस्राएल का कुल हइ, वे सब इस्राएली नी. ");
INSERT INTO goj_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","अरु नी अब्राहम का कुल होन का कारन सब ओका बेटा रख्यो, “पन लिख्यो हइ इसहाक का वजेसे तरो कुल बोलस.” ");
INSERT INTO goj_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","अगर आंग को बेटो परमेश्वर को बेटो नी पन प्रतीज्ञा को बेटो कुल गिन्यो जास हइ. ");
INSERT INTO goj_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","क्युकि प्रतीज्ञा को वचन यो हइ “मी उचित टेम का अनुसार आयु अरु सारा को बेटो हुयु.” ");
INSERT INTO goj_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","अरु फक्त यो नी, पन जब रिबका भी एक से अगर हमारो बाप इसहाक से दो बेटा हुया, ");
INSERT INTO goj_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","अरु अभी तक नी ते बच्चा पइदा हुयो यो थो, अरु कुच्छ अच्छो या बुरो कर्‍यो थो, येकालिये परमेश्वर की मनसा जो ओका चुनी लेना का अनुसार हइ, करम का कारन नी, पन बुलान वाला पर बनी र्‍हे ");
INSERT INTO goj_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","या बात परमेश्वर ने जन्म से पैयले अरु ओका कुछ भलो बुरो बोलन का पैयले बोली ते परमेश्वर की पसन्द ओकी बुलाहट पर नीर्बल हइ नी की वे दोय ने का कऱ्यो ओका पर ओने बोल्यो, “बडा छोटा को सेवक हुए.” ");
INSERT INTO goj_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","जसो शास्त्र मे लिख्यो हइ, “मे ने याकूब से प्रेम कऱ्यो, पन एसाव खे प्रिय जान्यो हइ.” ");
INSERT INTO goj_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","येकालिये हम का बोला? का परमेश्वर का यो बुरो हइ? कभी नी. ");
INSERT INTO goj_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","क्युकी उ मूसा से बोलस हइ, “अरु जेका पर दया करणो चास ओका पर दया कऱ्यु, अरु जो कोय पर कृपा करणु चास ओका पर कृपा करणु” ");
INSERT INTO goj_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","येकालिये यो नी ते चानआला की, नी मैहनत करणवाला की पन दया करणआलो परमेश्वर पर नीर्भर हइ. ");
INSERT INTO goj_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","क्युकी पवित्रशास्त्र मे फिरौन से बोल्यो गयो, “मे ने तोखे येका लिये खडो कऱ्यो हइ की तरा मे अपनो सामर्थ्य बतायु, अरु मरो नाम को प्रचार सब पृथ्वी पर हुये.” ");
INSERT INTO goj_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","येकालिये उ जेका पर चास हइ ओका पर दया करस हइ, अरु जेखे चास हइ ओको खतना करी देस हइ. ");
INSERT INTO goj_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","आखरी तु मरा से बोल्हे, “परमेश्वर फिर का दोष लगास हइ? कोन ओकि इच्छा को सामनो करस हइ?” ");
INSERT INTO goj_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","हे इंन्सान, अच्छो तू कोन हइ जो परमेश्वर को सामनो करस हइ? का गाड्यो हुयो सामन गडनवाली से बोली सकस हइ, “तो ने मेखे असो का बनायो हइ?” ");
INSERT INTO goj_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","का कुमार खे यो अधिकार नी कि उ मट्टी को एक ही लोंदा से एक बर्तन विशिष्ट प्रयोजन का लिये बनायो अरु दुसरा बर्तन साधाराण प्रयोजन का लिये. ");
INSERT INTO goj_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","कि परमेश्वर ने अपनी घुस्सा बतानो अरु अपनी सामर्थ्य प्रगट करण की इच्छा से घुस्सा का बर्तन पर जो विनाश का लिये तैयार करी गयो थो, बडा धीरज से सही. ");
INSERT INTO goj_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","अरु दया का बर्तन पर जेने ओने महिमा का लिये पैयले से तैयार कऱ्यो, अपनी महिमा को धन खे प्रगट करण की इच्छा करी. ");
INSERT INTO goj_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","अगर हम पर जेने ओने नी फक्त गैरयहूदीहोन मे से, वरन यहूदीहोन मे से भी बुलयो. ");
INSERT INTO goj_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","जसो वावो होशे की किताब मे भी बोलस हइ, जो मरा दुन्या नी था ओखे मी अपना दुन्या बल्यु. अरु जो प्रिय नी थो, उ प्रिय बोल्यु. ");
INSERT INTO goj_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","अरु असो हुये कि जो जगा मे ओखे यो बोली गयो थो की तुम मरा दुन्या नी हुये, उ जगा वे जिवन परमेश्वर का सन्तान बोल्ये. ");
INSERT INTO goj_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","अरु यशायाह इस्राएल का बारे मे बुलैखे बोलुस हइ, “चाये इस्राएल का बेटा का गिनस समुद्र का रेती का बरोबर होस, तेभी ओमे से थोडो ही बच्हे. ");
INSERT INTO goj_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","क्युकी प्रभु अपनो वचन पृथ्वी पर पुरो करीखे, धार्मीकता से झल्दी उ सिध्द कर्‍हे.” ");
INSERT INTO goj_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","जसो यशायाह ने पैयले भी बोलो थो, “अगर सुन्ये प्रभु हमारा लिये कुछ कुल नी छोलस, ते हम सदोम का सामने हुइ जास, अरु गमोरा का जसो ही रखस.” ");
INSERT INTO goj_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","आखरी हम का बोल्हे? यो का गैरयहूदीहोन नी जो धर्मीकता खे ढुडस नी धर्मीकता मील्हे की अगर उ धर्मीकता को जो विश्वास से हइ. ");
INSERT INTO goj_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","पन इस्राएल, जो धर्म कि व्यवस्था खे ढुडस उ व्यवस्था तक नी पोचे. ");
INSERT INTO goj_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","को का लिये? येकालिये कि वे विश्वास से नी, पन मानीखे कामहोन से ओखे ढुडस. करस्या ओने ओखे ठोकर का फत्थर पर ठोकर खइ, ");
INSERT INTO goj_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","जसो लिख्यो हइ, “देख, मी सिय्योन मे एक ठोकर लगन को पत्थर, अरु ठोकर खान की टेकडी रखस हइ, अरु जो ओका पर विश्वास करस उ लाजित नी हुइ.” ");
INSERT INTO goj_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","हे भैइ अरु बहन, मरा मन की अभिलाषा अरु ओका लिये परमेश्वर से मरी प्रार्थना हइ कि वे उध्दार पाए. ");
INSERT INTO goj_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","मी या बात से गवइ दिउस हइ की परमेश्वर कि भक्ति मे का लिये ऱ्हेस हइ पन उनकी भक्ति सच्ची ज्ञान पर नीर्भर नी हइ. ");
INSERT INTO goj_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","क्युकी वे परमेश्वर की धार्मीकता से अजान हुइ, अरु अपनी धार्मीकता स्थापित करण प्रत्यन करी खे परमेश्वर कि धार्मीकता का अधीन नी हुये. ");
INSERT INTO goj_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","मसीह ने व्यवस्था को अन्त पुरो कऱ्यो येका लिये धार्मीकता जो कोय विश्वास रखस हइ उ सही रस्ता मे आस हइ. ");
INSERT INTO goj_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","जो व्यवस्था से मीनल आलो न्यायीपन हइ ओको वर्णन मूसा यो तरहा करस हइ. “जो कोय व्ययवस्था कि आज्ञा मानस हइ उ जिन्दो ऱ्हीहे.” ");
INSERT INTO goj_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","पन जो धार्मीकता विश्वास से हइ, उ यो बोलस हइ, “तु अपना मन मे यो नी बोल्नु की अगर मसीह खे उतारी लान का लिये स्वर्ग पर कोन चेले?” ");
INSERT INTO goj_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","अरु आधा दुन्या मे मसीह खे मऱ्यो हुयो मी से जिन्दो करी खे उपर लान का लिये गड्डा मे उतरे. ");
INSERT INTO goj_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","पन उ बोलस हइ? यो की “वचन तरा बाहेर हइ, तरा मन मे अरु तरा मन मे हइ,” यो उ विश्वास को वचन हइ, जो हम प्रचार करस हइ, ");
INSERT INTO goj_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","की अगर तु अपना मुडा से यीशु खे प्रभु जानी, अंगीकार कर्हे अरु अपना मन से विश्वास कर की परमेश्वर ने उ मरन हुयो मे से जलायो, ते तु स्वतत्रता कर्यो जाये. ");
INSERT INTO goj_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","विश्वास करणा से हम परमेश्वर कि धार्मीकता का सात सही रिस्ता मे से आस हइ अरु उध्दार मुडा से कबुल करणा से मुक्ती पास हइ. ");
INSERT INTO goj_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","क्युकी पवित्रशास्त्र यो बोलस हइ, “जो कोय ओका पर विश्वास करस उ लज्जित नी हुये.” ");
INSERT INTO goj_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","यहूदीहोन अरु यूनानीहोन अरु उ सब को प्रभु हइ जो सब को भोतायत से आषिशीत करस हइ जो ओका बुलास हइ अरु अपना सब नाम लेनवाला का लिये उध्दार हइ. ");
INSERT INTO goj_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","क्युकी “जो कोय प्रभु का नाम लीये व्हा उध्दार मील्हे.” ");
INSERT INTO goj_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","फिर जेका पर ओने विश्वास नी कऱ्यो, पन जेने उनका पर विश्वास नी कऱ्यो उ मदत का लिये कसो बुलाये जेको संदेश सुन्यो नी उ पर कसो विश्वास कर? अरु प्रचार का बिना कसो सुने फिर संदेश सुननवाला भेज्या नी जाये ते कसो सुसमाचार को प्रचार कर्‍हे? ");
INSERT INTO goj_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","अरु अगर संदेश भेजे नी जाए, ते कसो प्रचार कर्‍हे? जसो शास्त्र लिख्यो हइ, “ओका पाय का ही सुवानो हइ, जो अच्छी बात की सुसमाचार सुनस हइ!” ");
INSERT INTO goj_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","पन सब ने उ सुसमाचार पर का नी लगास यशायाह बोलस हइ, “हे प्रभु कोने हमारो समाचार पर विश्वास कऱ्यो हइ?” ");
INSERT INTO goj_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","अरु विश्वास संदेश खे सुन से अरु सुनना से मसीह को वचन से होस हइ. ");
INSERT INTO goj_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","पन मी बोलस हुये खे ओने नी सुन्यो? सुन्यो ते अकुल्य हइ. क्युकी लिख्यो हइ, “ओका शब्द सब पृथ्वी पर, अरु ओका वचन जगत की छोर तक पोच्यो गया हइ.” ");
INSERT INTO goj_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","मी फिर बोलुस हुये खे का इस्राएल नी जानस था? पैयले ते मूसा बोलस हइ, “मी ओका वजेसे जो लोग नी, तुमारो मन मे जलन नीकली जायु. मी एक मुढ लोग का वजेसे तुम खे रिस दियु.” ");
INSERT INTO goj_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","फिर यशायाह बडो सहास का साथ बोलस हइ, “जो मेखे नी ढुँढता था, ओने मरा पर लियो. अरु जो मेखे पुछस भी नी थो, ओका पर मी प्रगट हुइ गयो.” ");
INSERT INTO goj_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","पन इस्राएल का बारे मे वो यो बोलस हइ, “मी सब दिन अपना हात एक आज्ञा नी माननवालो अरु बिदाइ करणवाला दुन्या का तरप पसारे ऱ्हेस.” ");
INSERT INTO goj_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","येकालिये मी बोलुस हुइ, का परमेश्वर ने अपनी दुन्या खे त्याग दियो? अगर नी! मी भी ते इस्राएल हुये. अब्राहम का कुल अरु बिन्यामीन का गोत्र मे से हुये. ");
INSERT INTO goj_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","परमेश्वर ने अपनी उ दुन्या खे नी त्यागा, जेने ओने पैयले हि से चुन्या. का तु नी जानस की पवित्रशास्त्र एलिय्याह का बारे मे का बोलस हइ, जब वो इस्राएल खे विरोध मे परमेश्वर से विनती करुस हइ? ");
INSERT INTO goj_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","“हे प्रभु ओने तरा भविष्यव्दक्ताहोन को घात कऱ्यो, अरु तरी वेदिहोन खे ढाकी दियो हइ. अरु मी ही अखे लो बच्यो हइ, अरु वे मखे मारन का लिये ढुडि रास हइ.” ");
INSERT INTO goj_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","पन परमेश्वर से उ का उतार मील्यो, मे ने अपना लिये सात हजार इंन्सान खे रखी छोड्यो हइ, जेने झुटा बाल भगवान का आगे घुटना नी टेकस हइ. ");
INSERT INTO goj_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","ठिक यो रीति से यो टेम भी, अनुग्रह से चुन्यो हुयो कुछ दुन्या बाकी हइ. ");
INSERT INTO goj_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","अगर यो अनुग्रह से हुयो हइ, ते फिर काम से नी. ते अनुग्रह फिर अनुग्रह नी ऱ्हेस. ");
INSERT INTO goj_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","येकालिये परिणाम का हुयो? यो की इस्राएल जेकी ढुडना मे थो, उ उनखे नी मील्यो. पन चुन्या हुयो खे करी लियो, अरु बाकि दुन्या कठोर खायो गयो. ");
INSERT INTO goj_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","जसो लिख्यो हइ, “परमेश्वर ने उनखे आज का दिन तक भारी नीद मे डालिखे रख्यो हइ, अरु असी आख आत्मा दे जो नी देख्यो अरु असा कान जो नी सुनस.” ");
INSERT INTO goj_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","अरु दाउद बोलस हइ, “ओको खानो ओका लिये जाल अरु फंदो, अरु ठोकर खाय खे अरु दण्ड का कारन हुइ जाए. ");
INSERT INTO goj_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","ओकी आख पर अंधारो छय जाए ताकि नी देखे, अरु तू कभी भी ओका पिंछा झुखे खे रखे.” ");
INSERT INTO goj_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","ते मी बोलुस हुये का ओने येकालिये ठोकर खाइ खे गिऱ्यो पड्यो? अगर नी! पन ओका गिरन का कारन गैरयहूदीहोन को उध्दार मीलस, की वे जलस हुये. ");
INSERT INTO goj_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","येकालिये अगर उनको गिरानो संसार का लिये धन अरु ओकी घटी गैरयहूदीहोन का लिये सम्पति का कारण हुये, ते उनकी भरपुर से खे तनो बडो आर्शिवाद मील्यो. ");
INSERT INTO goj_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","यो अब मी तुम गैरयहूदीहोन से बोली रोस हइ ते मी अपना काम को तु घमण्ड करस हइ. जब की मी विशेष रुप से गैरयहूदीहोन का लिये प्रेरित हुये, ते मी अपनी सेवा की बडोपनो करुस हुय, ");
INSERT INTO goj_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","ताकि कोय रीति से मी अपना कुटुबहोन मे जलन उत्पन्न करी खे ओमे से कोइ एक को उध्दार कऱ्यु. ");
INSERT INTO goj_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","क्युकी परमेश्वर का वजेसे उनको अस्वीकार कऱ्यो जानो संसार परमेश्वर का सात मेल मीलाप होस हइ ते फिर उनखे अपनायो जाना से मऱ्यो हुयो मे से जिन्दो नी हुये? ");
INSERT INTO goj_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","जब भेट को पयलो भाग पवित्र रख्यो, ते पुरो खराब हुयो आटो भी पवित्र हइ. पन जब झाड कि जडी पवित्र रख्यो, ते ओकि शाकाहोन भी पवित्र हइ. ");
INSERT INTO goj_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","अरु अगर कुछ डग्यान तोडि दी गयो, अरु तू जंगली जैतून हुइखे ओका सात हुय गयो, अरु जैतून की जडी खे चिकन कि भागी हुय हइ ");
INSERT INTO goj_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","ते डग्यान पर घमण्ड नी करणु. अरु अगर तू घमण्ड कर्य ते जानी रख की तू जडी खे नी पन जडी तोखे सम्भालती ऱ्हीहे. ");
INSERT INTO goj_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","फिर तू बोलस, “डग्यान येकालिये तोडि गयो की मी कलम करी जायु.” ");
INSERT INTO goj_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","ठिक हइ, वे ते अविश्वास का कारन तोडि गयो पन तू विश्वास से बनी ऱ्हेस हइ येकालिये अभिमानी नी हइ, पन भैइ मान, ");
INSERT INTO goj_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","क्युकी जब परमेश्वर ने स्वाभाविका डाली खे नी छोड्यो ते तोखे भी नी छोड्यो ");
INSERT INTO goj_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","येकालिये परमेश्वर की कृपा अरु कडाइ खे देख जो गिरी गयो उ पर कडाइ पन तरा पर कृपा अगर तु ओमे बनो ऱ्हेस नी ते तोखे भी काटी डाल्यो जाये. ");
INSERT INTO goj_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","अगर वे अविश्वास मे असमर्थ हइ ते झाडसे जोडी दिये. क्युकि परमेश्वर समर्थ हइ जो उ झाडसे जोडि देस. ");
INSERT INTO goj_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","क्युकि अगर गैरयहूदी उ जैतून से जो स्वभाव से जंगली हइ काट्यो गयो अरु स्वभाव को विरुध्द अच्छो जैतून मे जोड्यो जाये, ते ये जो यहूदी डाल्यो हइ अपनो हि जैतून मे का नी छाट्यो जाए. ");
INSERT INTO goj_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","हे भैइ अरु बहन, बोल असो नी हुइ की तुम अपना आप खे बुध्दिमान समझस. येकालिये मी नी चास कि तु ओका भेद से अंजान रिहे की जब तक गैरयहूदीहोन पुरी रीति से प्रवेश नी कर ले जब तक ही इस्राएल का एक भाग असो ही कठोर ऱ्हेस. ");
INSERT INTO goj_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","अरु उ रीति से सारा इस्राएल उध्दार पाए. “जसो शास्त्र मे लिख्यो हइ कि छुडानआलो सिय्योन से आह्ये, अरु अभक्ति का याकूब का कुल से दूर करस. ");
INSERT INTO goj_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","अरु ओका साथ मरी यो वाचा हुये जब की मी ओखे पाप का दुर करी दियु.” ");
INSERT INTO goj_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","सुसमाचार का भाव से ते तुमारा लिये वे परमेश्वर का दुसमन हइ, पन चुनी लिये जान से अरु बापदादाहोन का कारण परमेश्वर प्यारो हइ. ");
INSERT INTO goj_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","क्युकी परमेश्वर अपनो वरदान से पछतानो नी पडे अरु आशिष अटल हइ. ");
INSERT INTO goj_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","क्युकी जसो तुम ने पैयले परमेश्वर को आज्ञा नी मानी पन अभी ओका आज्ञा नी मानन से तुम पर दया हुये. ");
INSERT INTO goj_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","तुम पर जो दया होस हइ ओका कारण यहदि अब परमेश्वर कि आज्ञा नी मानी ऱ्हेस हइ, येकालिये अब तुम पर भी वसी उन पर दया हइ. ");
INSERT INTO goj_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","क्युकी परमेश्वर ने सब खे आज्ञा नी मानन का कारण बन्दी बनय खे रख्यो ताकी वो सब पर दया कर्हे. ");
INSERT INTO goj_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","आहा! परमेश्वर को धन अरु दिमाक अरु ज्ञान का ही महान हइ! ओखे नीर्भय खे कोन स्पष्ट करी सकस हइ अरु ओकि रस्ता कसो सजी सकस हइ! ");
INSERT INTO goj_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","शास्त्र बोलस हइ “प्रभु को मन खे कोन जानी सकस हइ अरु ओखे कोन सला दी सकस हइ? ");
INSERT INTO goj_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","का परमेश्वर खे कोय ने कुछ दियो हइ जेखे उ फिर से वापस कर्‍हे?” ");
INSERT INTO goj_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","क्युकी ओका तरप से, अरु ओका वजेसे, अरु ओ का लिये सब कुछ हइ ओकि महिमा पिडमपिडि होते ऱ्हेस आमीन. ");
INSERT INTO goj_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","येका लिये हे भैइ अरु बहन, मी तुम खे परमेश्वर की दया स्मरण दियुस, प्रार्थना करस हुये की अपना आंग होन खे जिन्दो अरु पवित्र अरु परमेश्वर का भावता हुयो बलिदान करीखे चढायो. यो तुमारो सच्चो उपास हइ. ");
INSERT INTO goj_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","यो जगत को सदृश नी बन्यो. पन तुमारो मन, नी हो जान से तुमारो चाल-चलन भी बदली जाए जेका से तुम परमेश्वर कि भली, अरु भाती अरु साधी इच्छा अनुभव से समज्हे करस ऱ्हेस. ");
INSERT INTO goj_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","क्युकी मी ओका अनुग्रह करण जो मे, मील्यो हइ तुम मे से हर एक से बोलस हय कि जसो समझनो चातो थो ओखे बडि खे कोय भी अपना आप नी समझे. पर जसो परमेश्वर ने हर एक विश्वास परिमाण जसो बैटो दियो हइ, वोसो ही सुबुध्दि का सात अपनो समझस. ");
INSERT INTO goj_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","क्युकी जसो हमारो एक मन मे भोत जसो आंग हइ, अरु सब आंग खे एक ही सो काम नी हइ. ");
INSERT INTO goj_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","वोसो ही हम जो भोत हइ मसीह मे एक मन हुइखे आपस मे एक दुसरा को आंग हइ ");
INSERT INTO goj_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","ताकि उ अनुग्रह का जसो जो दियो गयो हइ मेखे अलक-अलक वरदान मील्यो हइ, ते जेका भविष्यव्दाणी को दान मील्यो हुये उ विश्वास को परिमाण जसो भविष्यव्दाणी कर. ");
INSERT INTO goj_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","अगर सेवा करण का दान मील्यो हुये ते सेवा मे लग्यो ऱ्हेस. अगर कोय सिखानवालो होस,ते सिखान मे लग्यो ऱ्हेस ");
INSERT INTO goj_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","जो उपदेशक देनवालो हइ उपदेश कर्‍हे जो दान देनवालो हइ उ उदाहरता से दे अरु जो अगुवाइ करणवालो हइ उ मगन का सात अगुवाइ कर्‍हे अरु जो दया बतान को दान हइ उ प्रसन्नता से बतास उधारी से दे. जो अगुअय कर, वो उत्साह से कर. जो दया कऱ्यो वो हर्ष से कऱ्यो. ");
INSERT INTO goj_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","प्रेम नीष्कपट होस बुरा से घुणा कर अच्छो मे लग्यो ऱ्हे. ");
INSERT INTO goj_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","भैइचारा का प्रेम से एक दुसरा से स्नेह रख्यो. परस्पर आदर करणा मे एक दुसरा से बडी चल. ");
INSERT INTO goj_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","प्रयत्न करणा मे आलसी नी हुइ आत्मीक मे उत्तसुक भऱ्यो ऱ्हे प्रभु कि सेवा करतो ऱ्हेस. ");
INSERT INTO goj_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","आस मे आनन्दित रहे संकट मे धीरज रख. प्रार्थना मे लग्यो ऱ्हेस. ");
INSERT INTO goj_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","पवित्र दुन्या मे जो कुछ अवश्य हुये खे ओमे ओकि सहायता कर. मीजवान करणा मे लग्यो ऱ्हेस. ");
INSERT INTO goj_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","अपना सतानआला खे आशीष दे.आशीष दे श्राप नी दे. ");
INSERT INTO goj_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","खुशी करणवाला का साथ खुशी कर, अरु रोनवाला का साथ रो ");
INSERT INTO goj_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","आपस मे एक जसो मन रख्यो. अभिमानी नी हुये पन दिन का साथ सगति रख. अपनो दुष्टि मे बुध्दिमान नी हुए. ");
INSERT INTO goj_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","बुराइ खे कोय से बुरो नी करणु. जो बात सब दुन्याहोन का लिये अच्छो हइ, ओकि चिता कऱ्या कर. ");
INSERT INTO goj_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","जहा तक हुए सकस, तुम भरी सब इन्सान का साथ मे शांती मे ऱ्हे. ");
INSERT INTO goj_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","हे प्रिय, बदलो नी लेनु, पन परमेश्वर खे घुस्सा का अवसर दे, क्युकि लिख्यो हइ, “बदलो लेनो मरो काम हइ, प्रभु बोलस हइ मी हि बदली दियु.” ");
INSERT INTO goj_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","पन “अगर तरा बिना भूको हुए ते ओखे खानो खलइ खे अगर दुसरो हुये ते दुशमन खे पानी पिलय सक्यु क्युकि असा करणा से तु ओका माथा पर अगार से अंगारा को ढेर लगास.” ");
INSERT INTO goj_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","बुरा से नी हुया, पन भला से बुरा खे जिती ले. ");
INSERT INTO goj_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","हर एक इन्सान शासकिय अधिकाहोन का अधीन रेस क्युकि अधिकार असो नी जो परमेश्वर का मन का तरप से नी हुये. अरु जो अधिकार हइ वे परमेश्वर खे ठहरायो हुयो हइ. ");
INSERT INTO goj_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","येका लिये जो कोय अधिकार को विरोध करस हइ वो परमेश्वर कि विधी का सामने करस हइ अरु सामनो करणवाला खे दण्ड मीले. ");
INSERT INTO goj_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","क्युकि शासन अच्छो काम खे नी पन बुरो काम का लिये डरी खे करणो हइ आखरी. अगर तू अधिकारी से नीडर ऱ्हेनो चाहिए हइ ते अच्छो काम कर अरु ओका तरप से तरी सरानो हुये. ");
INSERT INTO goj_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","क्युकि उ तरा भला का लिये परमेश्वर को सेवक हइ. पन अगर तु बुरो कर ते डर क्युकी वह तलवार व्यर्थ लिए हुयो नी. अरु परमेश्वर को सेवक हइ की ओकि घुस्सा का जसो बुरो काम करणवाला खे दण्ड दे ");
INSERT INTO goj_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","येका लिये अधीकारीहोन कि आज्ञा मान नी ते फक्त परमेश्वर कि शिक्षा का वजेसे नी लेकीन हमारो विवेक करण भी ");
INSERT INTO goj_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","येका लिये करी भी दे क्युकी शासन करणवाला परमेश्वर को सेवक हइ अरु सदा यो काम मे लग्यो ऱ्हेस हइ. ");
INSERT INTO goj_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","येका लिये हर एक को हक्क चुकयो कर जेका से चाए ओका करी देख जेको चुनी चाए ओखे चुगी दे. जेका से डरनो चाए ओकासे डर. जेको आदर करणो चाए ओको आदर कर. ");
INSERT INTO goj_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","आपस का प्रेम खे छोडी अरु कोय बात मे कोय को कर्जदार नी हुये. क्युकी जो दुसरा से प्रेम रखस हइ, ओ ने व्यवस्था पुरो करी हइ. ");
INSERT INTO goj_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","क्युकी यो की “व्यभिचार नी करणो, मारनो नी करणो, चोरी नी करणो, लालच मत कर,” अरु इनखे छोडीखे अरु कोय भी आज्ञा हुये ते सब का साराश या बात मे पायो जास हइ, “अपना घर का बाजुआला से अपना समान प्रेम रख.” ");
INSERT INTO goj_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","प्रेम घर का बाजुआला कुछ बुरो नी करस येका लिये प्रेम करणु व्यवस्था को पालन करणो हइ. ");
INSERT INTO goj_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","टेम खे पइछान कर असो हि कर, येका लिये की अब तुमारा लिये नीद से जागो उठन की घडी आ पोच्यो हइ. क्युकी जो टेम हम ने विश्वास कऱ्यो थो, उ टेम का बिचार से अब हमारो उध्दार बाहेर हइ. ");
INSERT INTO goj_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","रात भोत बीती गए हइ, अरु दिन निकलना पर हइ. येका लिये हम अंधारा कामहोन खे त्याग खे ज्योति कि हथियार बाधी ले. ");
INSERT INTO goj_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","जसो दिन मे वोसो ही हम सीधो रुप से चाल चले नी की लीला-क्रिडा अरु मे नी व्यभिचार अरु लुचपन मे अरु नी वाद विवाद अरु डाह मे. ");
INSERT INTO goj_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","जब प्रभु यीशु मसीह खे पेनी ले, अरु मानव का आंग की अभिलाषाहोन खे पुरो करणा मे मत लगा र्हे. ");
INSERT INTO goj_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","जो विश्वास मे नीर्बल हइ, ओने अपना सगत मे ली ले, पन ओकी युक्ति बिचार पर विवाद करण का लिये नी. ");
INSERT INTO goj_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","एक को विश्वास हइ कि सब कुछ खानो उचित हइ पन जो विश्वास मे नीर्बल हइ, उ फक्त शाकाहारी खास हइ. ");
INSERT INTO goj_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","अरु खानवाला नी खानवाला को तुच्छ नी जान अरु नी खानवाला पर दोष नी लगानु. किक्यु परमेश्वर ने ओखे ग्रहण कऱ्यो हइ ");
INSERT INTO goj_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","तु कोन हइ जो दुसरा सेवक पर दोष लगास हइ? ओका स्थिर ऱ्हे या गिरी जानो ओको स्वामी ही से सम्बन्ध रखस हइ. जब वो स्थिर ही करी दीयो जाए, क्युकि प्रभु उ स्थिर रखी सकस हइ. ");
INSERT INTO goj_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","का दुन्याहोन थो एक दिन खे दुसरो से बडी खे मानस हइ, अरु कोय भी सब दिन खे एक समान मानस हइ. हर एक अपनी ही मन मे नीश्चित करी ले. ");
INSERT INTO goj_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","जो कोय दि खे मानस हइ उ प्रभु का लिये मानस हइ जो खास हइ उ प्रभु का लिये खास हइ क्युकि वो परमेश्वर को धन्यावाद करस हइ अरु जो नी खास वो प्रभु, लिये नी खास अरु परमेश्वर को धन्यावाद करस हइ. ");
INSERT INTO goj_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","क्युकि हम मे से नी ते कोय अपना लिये जीस हइ अरु नी कोय अपना लिये मरस हइ. ");
INSERT INTO goj_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","अगर हम जिन्दो हइ ते प्रभु का लिये जिन्दो हइ अरु अगर मरस हइ, ते प्रभु का लिये मरस हइ. आखरी मे हम जिन्दो या मऱ्यो, हम प्रभु ही को हइ. ");
INSERT INTO goj_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","क्युकि मसीह येका लिये मऱ्यो अरु जी भी उठ्यो की उ मर हुये अरु जिन्दो दोय को प्रभु हुयो. ");
INSERT INTO goj_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","तु अपना भैइ पर का दोष लगास हइ? या तु फिर का अपना भैइका पास जास हइ? हम सब खे सब परमेश्वर का न्याय राजगद्दी का सामने खडो हुये. ");
INSERT INTO goj_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","क्युकी शास्त्र लिख्यो हइ, प्रभु बोलस हइ, मरा जिवन की सौगन्ध की हर एक घुटना मरा सामने टिक्ये, अरु हर एक जीभ मानी लिये की मी परमेश्वर हइ. ");
INSERT INTO goj_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","येका लिये हम मे से हर एक परमेश्वर खे अपनो अपनो लिख दे . ");
INSERT INTO goj_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","येका लिये हम एक दुसरा पर न्याय करणो बन्द कर्‍हे अरु येका बदला मे नीश्चय कर कि अपना भैइ का सामने ठोकर खे पाप मे पडन का कारन बन. ");
INSERT INTO goj_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","प्रभु यीशु मे एक होन का कारण मी जानुस हइ कि कोय सामन अपना आप से अशुध्द नी पन जो ओखे अशुध्द समझस हइ ओका लिये अशुध्द हइ. ");
INSERT INTO goj_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","अगर तरो भैइ या बहन तरा खान का कारन दुखी होस हइ ते फिर तु प्रेम कि रिती से नी चलस. जेका लिये मसीह मऱ्यो ओखे तु अपना खाना का वजेसे नष्ट नी कर. ");
INSERT INTO goj_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","जेखे तुम भलो मानस हइ ओखे कोय खे बुरो मत बोलन देनु. ");
INSERT INTO goj_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","क्युकि परमेश्वर का राज्य खानो पानी नी, पन धार्मीकता अरु शांती अरु आनन्द हइ जो पवित्र आत्मा देस हइ उ हइ. ");
INSERT INTO goj_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","जो कोय या रीति से मसीह की सेवा करस हइ, उ परमेश्वर खे भास हइ, अरु इन्सान मे ग्रहण योग्य ठैरास हइ. ");
INSERT INTO goj_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","येका लिये हम उ बात मे लग्या ऱ्हेस जेका से मेल मीलाप अरु एक दुसरा की उन्नती हुये. ");
INSERT INTO goj_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","खानो का लिये परमेश्वर ने कऱ्यो उ खतम मत कर्‍हे, सब कुछ शुध्द तो हइ, पन उ इन्सान का लिये बुरो हइ जेखे ओको खाना से ठोकर लगस हइ. ");
INSERT INTO goj_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","अच्छो ते यो हइ कि तु नी मास खाये अरु नी अंगूर को रस पाए, नी अरु कुछ असो कर्‍हे जेका से तरो भैइ या बहन ठोकर खाए. ");
INSERT INTO goj_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","तरो जो विश्वास हुये खे ओको परमेश्वर का सामने अपनो ही मन मे रख. धन्य हइ वो जो उ बात मे जेका उ ठीक समज्हे हइ अपना आप खे दोष नी ठैरास. ");
INSERT INTO goj_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","पन जो सन्देह कर्हे, खास हइ परमेश्वर को दोषी क्युकि उ विश्वास से नी खास. अरु जो कुछ विश्वाससे नी ते उ पाप हइ. ");
INSERT INTO goj_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","आखरी हम बलवान खे चाहस की नीर्बल कि नीर्बलताहोन मे सहायता कर कोनी की अपना आपखे प्रसन्न कर ");
INSERT INTO goj_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","हम से हर एक अपनो घर का बाजु का ओकी भलाइ का लिये प्रसन्न कर की ओकी उन्नती हुये. ");
INSERT INTO goj_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","क्युकि मसीह ने अपना आप खे प्रसन्न नी कऱ्यो पर जसो लिख्यो हइ “तरा नीन्दको की नीन्दा मरा पर अय पड्यो.” ");
INSERT INTO goj_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","जतनी बात पयलो से लिखी गइ वे हमारी ही शिक्षा का लिये लिखी गैय हइ की हम धीरज अरु शांती पवित्रशास्त्र का प्रोत्साहन वजेसे आस कर. ");
INSERT INTO goj_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","धीरज अरु शांती को दातो परमेश्वर तु यो वरदान दे की मसीह यीशु का अनुसार आपस मे एक मन हइ. ");
INSERT INTO goj_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","ताकि तुम एक मन अरु एक अवाज मे हमारो प्रभु यीशु मसीह को बाप परमेश्वर कि महिमा कर. ");
INSERT INTO goj_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","येका लिये जसो मसीह ने परमेश्वर की महिमा का लिये तुम खे ग्रहण कऱ्यो हइ, ओसो ही तुम भी एक दुसरा खे ग्रहण कर. ");
INSERT INTO goj_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","येका लिये मी बोलुस हइ की जो प्रतीज्ञा बापदादा खे दी गए ओने दृढ करणा का लिये मसीह कि परमेश्वर की सच्ची को प्रमाण देन का लिये खतना कऱ्यो हुयो दुन्या को सेवक बन्यो ");
INSERT INTO goj_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","अरु गैरयहूदीहोन भी दया करण परमेश्वर की स्तुती कर का जसो लिख्यो हइ, “येका लिये मी जात जात मे तरी महिमा करीयु का अरु तरो नाम को भजन गायु.” ");
INSERT INTO goj_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","फिर बोल्यो हइ “हे जात जात का सब दुन्या ओका दुन्या का साथ आनन्द कर.” ");
INSERT INTO goj_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","अरु फिर हे जात जात का सब दुन्या प्रभु की स्तुती कर अरु हे राज्य राज्य का सब दुन्या ओकी स्तुति. ");
INSERT INTO goj_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","अरु फिर यशायाह बोलस हइ “यिशय कि एक जडी प्रगट हुये खे अरु गैरयहूदीहोन को हाकीम होन का लिये एक उठाये.” ");
INSERT INTO goj_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","परमेश्वर जो आस को दाता हइ तेका विश्वास करणा मे सब प्रकार को आनन्द अरु शांती से परिपुर्ण कर की पवित्र मन कि सामर्थ्य से तुमारी आस बडी जाए. ");
INSERT INTO goj_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","हे मरा भैइ मी खुद तुमारा विषय मे नीश्चय जानस हइ की तु भी आप ही बुरा से अच्छो अरु इश्वरी ज्ञान से भरपुर होस, अरु एक दुसरा चिन्ता सकस हइ. ");
INSERT INTO goj_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","तेभी मी ने कभी कभी याद देन का लिये तु जो भोत साहस करी खे लिख्यो. यो उ अनुग्रह कारन हुयो जो परमेश्वर ने मेखे दियो हइ, ");
INSERT INTO goj_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","की मी गैरयहूदिहोन का लिये मसीह यीशु को सेवक हुइ खे परमेश्वर को सुसमाचार कि सेवा याजक का सामने क्युकि जेने गैरयहूदिहोन खे मान्यो चेड्यो जाए, पवित्र मन से पवित्र बनी खे ग्रहण करी जाए. ");
INSERT INTO goj_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","येका लिये उ बात का विषय मे जो परमेश्वर से सम्बन्ध रखस हइ मसीह यीशु मे बडो कर सकुस हुये. ");
INSERT INTO goj_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","क्युकि उ बात खे छोडीखे मेखे अरु कोय बात का विषय मे बोलन को साहस नी कऱ्यो जो मसीह ने गैरयहूदिहोन की अधीनता का लिये वचन अरु कर्म, ");
INSERT INTO goj_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","अरु चीता अरु अद्भुत काम को सामर्थ्य से परमेश्वर अरु पवित्र आत्मा का सामर्थ्य से मरा ही वजेसे कर इल्‍लुरिकुम तक की मी ने यरुशलेम से लिखे चोर का तरप तक मसीह को सुसमाचार को पुरो पुरो प्रचार कर. ");
INSERT INTO goj_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","पर मरो मन उमग यो हइ की जो जो मसीह को नाम नी लियो गयो, वो सुसमाचार सुनायु असो नी हुये की दुसरा की पय्या पर घर बनायु. ");
INSERT INTO goj_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","पन जसो लिख्यो हइ वोसो ही होस, “जेने ओका सुसमाचार नी पोच्यो, वे ही देखस अरु जेने नी सुन्यो वे समझस.” ");
INSERT INTO goj_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","येका लिये मी तुमारा पास आना से बार बार रुक्यो ऱ्हेस. ");
INSERT INTO goj_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","पन अब यो देश मे मरा कर्य का लिये अरु जगा नी ऱ्हेस, अरु भोत साल से मे खे तुमारा पास आन की इच्छा हइ. ");
INSERT INTO goj_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","येका लिये जब मी स्पेन खे जाउ ते तुमारा पास होस हुये जाए, क्युकी मेखे आस हइ की वा जत्रा मे तरा से दान हुये खे अरु जब तुमारा संग से मरा कुछ भरी जाए ते तुम मेखे कुछ दुर आगे पोचये दे. ");
INSERT INTO goj_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","पन अभी ते मी पवित्र दुन्या की सेवा करणा का लिये यरुशलेम का जास हुये. ");
INSERT INTO goj_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","क्युकी मकिदुनीया अरु अखाया का दुन्या खे यो अच्छो लग्यो की यरुशलेम का पवित्र दुन्या मे नीर्धनो का लिये कुछ जमा कर. ");
INSERT INTO goj_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","ओखे अच्छो तो लग्यो पन वे ओको कर्जदार भी हइ, क्युकी अगर गैरयहूदिहोन ओकी आत्मीक बात मै हुयो काते ओका भी उचित हइ की आंग बात मे ओकी सेवा कर्‍हे. ");
INSERT INTO goj_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","येका लिये मी यो काम पुरो कर्हे का अरु ओका यो चन्दा सोपी खे तरा पास होस हुये स्पेन खे जायु. ");
INSERT INTO goj_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","अरु मी जानस हइ की जब मी तुमारा पास आयु, ते मसीह की पुरी आशीर्वाद का साथ आयु. ");
INSERT INTO goj_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","हे भैइ हमारो प्रभु यीशु मसीह को अरु पवित्र आत्मा को प्रेम खे स्मरण दिलय खे मी तुम से प्रार्थना करस हइ की मरा लिये परमेश्वर से प्रार्थना करणा मे मरा साथ मीली खे लौलीन र्हेस ");
INSERT INTO goj_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","कि मी यहूदीया का अविश्वासिहोन से बच्यो ऱ्हीयु अरु करणु उ सेवा जो यरुशलेम का लिये हइ, पवित्र दुन्या खे भऱ्यो. ");
INSERT INTO goj_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","अरु मी परमेश्वर की इच्छा से तुमारा पास आनन्द का साथ अयखे तुमारा साथ आराम पाह्यु. ");
INSERT INTO goj_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","शांती को परमेश्वर तुम सब का साथ ऱ्हेस.आमीन. ");
INSERT INTO goj_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","मी तुम से फिबे का लिये जो हमारी भैइन अरु किंख्रिया कि मंडली सेवक हइ, प्रार्थना करस हइ ");
INSERT INTO goj_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","कि तुम, जसो की पवित्र दुन्या खे चास, ओका प्रभु मे ग्रहण कर. अरु जो कोय बात मे ओकी तुमारा आकुल्यकता हुयो, ओकी सायता कर, क्युकि वे भी भोत की जब मरो भी उपकार करणवाली ऱ्हेस हइ. ");
INSERT INTO goj_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","प्रिस्किल्ला का अरु अक्विला की जो मसीह यीशु मे मरो सहकर्मी हइ, नमस्कार. ");
INSERT INTO goj_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","ओने मरी जान का लिये अपनो ही जिवन जोखिम मे डाली दियो थो अरु फक्त मी ही नी जब गैरयहूदीहोन की सब मंडलीहोन भी ओको धन्यवाद करस हइ. ");
INSERT INTO goj_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","मंडली खे भी नमस्कार जो ओका घर मे हइ. मरो प्रिय इपैनीतुस खे जो मसीह का लिये आसिया को पहलो फल हइ,नमस्कार. ");
INSERT INTO goj_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","मरियम खे जेने तुमारा लिये भोत परिश्रम कऱ्यो, नमस्कार. ");
INSERT INTO goj_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","अन्द्रुनीकुस अरु युनीयास खे जो मरो कुटुब हइ, अरु मरा साथ कैद हुइ गो अरु प्रेरित मे नाम हइ,अरु मरा से पयलो मसीह हुयो थो, नमस्कार. ");
INSERT INTO goj_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","जो प्रभु मे मरो प्रिय अमप्‍लियातुस खे नमस्कार. ");
INSERT INTO goj_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","मसीह मे हमारा सहयोगी उरबानुस अरु जो मसीह मे हमारो सहकर्मी हइ अरु मरो प्रिय इसतखुस खे नमस्कार. ");
INSERT INTO goj_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","अपिल्लैस खे जो मसीह मे खरो निकलस का नमस्कार. अरिस्तुबुलु का घरानो को नमस्कार. ");
INSERT INTO goj_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","मरो कुटुब हेरोदियोन खे नमस्कार. नरकिस्सुस का घराना, जो दुन्या प्रभु मे हइ, ओखे नमस्कार. ");
INSERT INTO goj_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","त्रुफेना अरु त्रुफोसा का जो प्रभु मे परिश्रम करस हइ, नमस्कार. प्रिय पिरसिस खे जेने प्रभु मे भोत परिश्रम कऱ्यो, नमस्कार. ");
INSERT INTO goj_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","रुफुस खे जो प्रभु मे चुन्यो हइ अरु ओकी माय, जो मरो भी माय हइ, दो खे नमस्कार. ");
INSERT INTO goj_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","असुक्रितुस अरु फिलगोन अरु हिर्मेस अरु पत्रु बास अरु हिर्मास अरु ओका साथ भैइ खे नमस्कार. ");
INSERT INTO goj_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","फिलुलुगुस अरु युलिया अरु नेर्युस अरु ओकि भैइन, अरु उलुम्पास अरु ओका साथ का सब पवित्र दुन्या खे नमस्कार. ");
INSERT INTO goj_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","आपस मे पवित्र चुमचबन से नमस्कार तुम मसीह की सब मंडलीहोन कि तरप से नमस्कार. ");
INSERT INTO goj_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","अब हे भैइ तुम से प्रार्थना करस हइ, की जो इन्सान उ शिक्षा का विपरित खे जो तुम ने पायो हइ,फुट डालस अरु ठोकर खलान कारन होस हइ, ओने तागी लियो, अरु ओका से दुर रियो. ");
INSERT INTO goj_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","क्युकी असा दुन्या हमारो प्रभु मसीह की नी, पन अपनो पेट की सेवा करस हइ.अरु चिकनी चोपडी बात से सीधो-सादो मन का दुन्या खे भैइ भय देस हइ. ");
INSERT INTO goj_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","तुमारो आज्ञा मानन की चर्चा सब दुन्या मे फैली गय हइ येका लिये मी तुमारो विषय मे आनन्द करुस हइ, पन मी यो चास हइ की तुम अच्छो, लिये बुध्दिमान पन बुरा का लिये भोलो बन्यो ऱ्हेस. ");
INSERT INTO goj_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","शांती को परमेश्वर सैतान खे तुमारा पाच से शीघ्र कुसल देस. हमारो प्रभु यीशु मसीह को अनुग्रह तरा पर होस ऱ्हेस. ");
INSERT INTO goj_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","मरी सहकर्मी तीमुथियुस को, अरु मरो कुटुबहोन लुकियुस अरु यासोन अरु सोसिपत्रुस खे तुम नमस्कार बोलस हइ. ");
INSERT INTO goj_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","मरी चिट्टी खे लिखनवाली तिरतियुस को, प्रभु मे तो, नमस्कार. ");
INSERT INTO goj_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","गयुस जो मरो अरु मंडली की मीजवान करणवाला हइ,ओको इरास्तुस नमस्कार. ");
INSERT INTO goj_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","इरास्तूस जो नगर को भण्डारी हइ, अरु भैइ क्वारतुस को तुखे नमस्कार. ");
INSERT INTO goj_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","अब जो तुम खे मरी सुसमाचार अगर यीशु मसीह को प्रचार का जसो स्थिर करी सकुस हइ,उ भेदको प्रकार का जसो जो सैतान से लुकि खे ऱ्हेस, ");
INSERT INTO goj_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","पन अब प्रगट हुइ खे सतान परमेश्वर की आज्ञा से भविष्यव्दक्ताहोन की किताबहोन का वजेसे सब जातहोन खे बतायो गयो हइ कि वे विश्वास से आज्ञा माननवाला हुये जाए, ");
INSERT INTO goj_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","उ एकमात्र बुध्दिमान परमेश्वर कि यीशु मसीह का वजेसे पिडमपिडि महिमा होस ऱ्हिहे. आमीन.");
INSERT INTO goj_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","पौलुस का तरफ से जो परमेश्वर की इच्छा से यीशु मसीह का प्रेरित होन का लिये बुलायो गया अरु भैइ सोस्थिनेस का तरफ से. ");
INSERT INTO goj_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","परमेश्वर की वा मंडली का नाम जो कुरिन्थुस मे हइ, मनजे उनका नाम जो मसीह यीशु मे पवित्र कर्या गया, अरु पवित्र होन का लिये बुलायो गए हइ; अरु उन सब का नाम भी जो हर जगा हमारा अरु अपना प्रभु यीशु मसीह का नाम से प्रार्थना करस हइ. ");
INSERT INTO goj_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","हमारो बाप परमेश्वर अरु प्रभु यीशु मसीह का तरफ से तुमखे अनुग्रह अरु शांती मीलती र्‍हिये. ");
INSERT INTO goj_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","मी तुमारा बारे मे अपना परमेश्वर खे धन्यवाद हमेशा करुस हइ, येकालिये कि परमेश्वर को यो अनुग्रह तुम पर मसीह यीशु मे हुयो. ");
INSERT INTO goj_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","कि ओमे हुइखे तुम हर बात मे मनजे पुरो वचन अरु पुरा ज्ञान मे धनी कर्या गया. ");
INSERT INTO goj_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","कि मसीह की गवइ तुम मे पक्की नीकल्ये. ");
INSERT INTO goj_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","ह्या तक कि कोय वरदान मे तुमखे कमी नी , अरु तुम हमारा प्रभु यीशु मसीह को प्रगट होन की प्रतीक्षा करता र्‍हेस हइ. ");
INSERT INTO goj_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","उ तुमखे आखरी तक दृढ भी कर्ये, कि तुम हमारा प्रभु यीशु मसीह का दिन मे नीर्दोष ठैरनु ");
INSERT INTO goj_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","परमेश्वर विश्वासयोग्य हइ. जेने तुम खे अपनो बेटो हमारो प्रभु यीशु मसीह की संगत मे बुलायो हइ. ");
INSERT INTO goj_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","हे भैइहोन अरु बहीन, मी तुम से यीशु मसीह जो हमारो प्रभु हइ ओका नाम का द्वारा प्रार्थना करुस हइ, कि तुम सब एक ही बात बोलनु अरु तुम मे फूट नी हो, पर एक ही मन अरु एक ही मत हुइखे मील्या र्‍हेनु. ");
INSERT INTO goj_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","क्युकि हे मरा भैइहोन, खलोए का घराना का इन्सानहोन ने मेखे तुमारा बारे मे बतायो हइ, कि तुम मे झगडा हुइ र्‍हा हइ. ");
INSERT INTO goj_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","मरो बोलन को मतलब यो हइ, कि तुम मे से कोय तो अपना आप खे “पौलुस को,” कोय “अपुल्लोस को,” कोय “कैफा को,” कोय “मसीह को” बोलस हइ. ");
INSERT INTO goj_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","का मसीह बठी गयो? का पौलुस तुमारा लिये क्रुस पर चडायो गयो? या तुमखे पौलुस का नाम पर बपतिस्मा मील्यो? ");
INSERT INTO goj_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","मी परमेश्वर को धन्यवाद करुस हइ, कि क्रिस्पुस अरु गयुस खे छोड़, मेने तुम मे से कोय खे भी बपतिस्मा नी दियो. ");
INSERT INTO goj_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","खय असो नी हो, कि कोय बोल्ये कि तुमखे मरा नाम पर बपतिस्मा मील्यो. ");
INSERT INTO goj_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","अरु मेने स्तिफनास का घराना खे भी बपतिस्मा दियो. इनखे छोडी खे मी नी जानु कि मेने अरु कोय खे बपतिस्मा दियो. ");
INSERT INTO goj_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","क्युकि मसीह ने मेखे बपतिस्मा देन खे नी, क्युकी सुसमाचार सुनान खे भेज्यो हइ, अरु यो भी इन्सानहोन को अवाजहोन को ज्ञान का अनुसार नी असो नी हो कि मसीह को क्रुस बेकार ठैर्ये. ");
INSERT INTO goj_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","क्युकि क्रुस की कथा खत्म होनआला का पास बेवकुप हइ, पर हम उध्दारपानआला का पास परमेश्वर की सामर्थ्य हइ. ");
INSERT INTO goj_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","क्युकि लिख्यो हइ. “मी ज्ञानवान को ज्ञान खे खत्म कर्यु, अरु समझदारहोन खे समझ खे तुच्छ करी दियु.” ");
INSERT INTO goj_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","खा र्‍हियो ज्ञानवान? खा र्‍हियो शास्त्री? खा र्‍हियो यो संसार को विवादी? का परमेश्वर ने संसार का ज्ञान खे बेवकुप नी ठैइरायो? ");
INSERT INTO goj_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","क्युकि जब परमेश्वर का ज्ञान खे अनुसार संसार ने ज्ञान से परमेश्वर खे नी जान्यो ते परमेश्वर खे यो अच्छो लग्यो कि यो प्रचार का बेवकुप का द्वारा विश्वास करणआला खे उध्दारदे. ");
INSERT INTO goj_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","यहूदी तो चिन्ह चाहस हइ, अरु यूनानी ज्ञान का खोज मे हइ, ");
INSERT INTO goj_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","पर हम तो उ क्रुस पर चडाया हुया मसीह को प्रचार करस हइ जो यहूदीहोन का पास ठोकर का कारण अरु गैरयहूदीहोन का पास बेवकुप हइ. ");
INSERT INTO goj_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","पर जो बुलायो हुया हइ का यहूदी, का यूनानी, उनका पास मसीह परमेश्वर को सामर्थ्य, अरु परमेश्वर को ज्ञान हइ. ");
INSERT INTO goj_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","क्युकि परमेश्वर की बेवकुप इन्सानहोन का ज्ञान से ज्ञानवान हइ. अरु परमेश्वर की बिनाताखत आलो इन्सानहोन का बल से भोत बलवान हइ. ");
INSERT INTO goj_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","हे भैइहोन अरु बहिन, अपना बुलायो जाना खे तो सोचनु कि न आंग का अनुसार भोत ज्ञानवान, अरु नी भोत सामर्थ्यी, अरु नी भोत कुलीन बुलायो गया. ");
INSERT INTO goj_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","पर परमेश्वर ने जगत का बेवकुपहोन खे चुनी लियो हइ कि ज्ञानीहोन खे लज्जित करणु. अरु परमेश्वर ने संसार का नीर्बलहोन खे चुनी लियो हइ, कि बलवानहोन खे लज्जित कर्ये. ");
INSERT INTO goj_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","अरु परमेश्वर ने संसार का नीचहोन अरु तुच्छहोन खे क्युकी जो हइ भी नी उनखे भी चुनी लियो, कि उनने जो हइ, बेकार ठैइराये. ");
INSERT INTO goj_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","ताकि कोय जनवर परमेश्वर का सामने घमण्ड नी करी पाये. ");
INSERT INTO goj_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","पर ओ का तरफ से तुम मसीह यीशु मे हुये, जो परमेश्वर का तरफ से हमारा लिये ज्ञान ठैइराये मनजे धर्मीकता, अरु पवित्रता, अरु छुटकारो. ");
INSERT INTO goj_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","ताकि जसो लिख्यो हइ, ओसो ही हो, “जो घमण्ड कर्ये उ प्रभु मे घमण्ड कर्हे .” ");
INSERT INTO goj_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","हे भैइहोन अरु बयहोन, जब मी परमेश्वर को भेद सुनाते हुयो तुमारा पास आयो, ते वचन या ज्ञान कि उत्तमता का साथ नी आयो. ");
INSERT INTO goj_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","क्युकि मेने यो ठानी लियो थो कि तुम्हारा बीच यीशु मसीह, क्युकी क्रुस पर चडाया हुया मसीह खे छोड अरु कोय बात खे नी जान्यू. ");
INSERT INTO goj_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","अरु मी नीर्बलता अरु डर का साथ अरु भोत थरथरातो हुयो तुमारा साथ र्‍हियो. ");
INSERT INTO goj_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","अरु मरा वचन, अरु मरो प्रचार मे ज्ञान, लुभानआली बातहोन नी. पर आत्मा अरु सामर्थ्य को प्रमाण थो. ");
INSERT INTO goj_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","येका लिये कि तुमारा विश्वास इन्सानहोन खे ज्ञान पर नी, पर परमेश्वर को सामर्थ्य पर नीरभर होनु. ");
INSERT INTO goj_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","फिर भी सिद्ध इन्सानहोन मे हम ज्ञान सुनास हइ पर यो जगत को अरु यो जगत को नाश होनआला हाकिमहोन को ज्ञान नी. ");
INSERT INTO goj_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","पर हम परमेश्वर को उ गुप्त ज्ञान खे बतास हइ, जेखे परमेश्वर ने सनातन से हमारी महिमा का लिये ठैइरायो. ");
INSERT INTO goj_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","जेखे यो जगत का हाकिमहोन मे से कोय ने नी जान्यो, क्युकि अगर जानता कि ते तेजोमय प्रभु खे क्रुस पर नी चडाता. ");
INSERT INTO goj_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","पर जसो लिख्यो हइ, “जे आख ने नी देखी, अरु काम न ने नी सुनी, अरु जो बातहोन इन्सान खे चित्ता मे नी चढी वे ही हइ, जो परमेश्वर ने अपनो प्रेम रखनआला, लिये तैयार करी हइ.” ");
INSERT INTO goj_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","पर परमेश्वर ने उनका अपनो आत्मा का वजेसे हम पर प्रगट कर्यो. क्युकि आत्मा सब बातहोन, क्युकी परमेश्वर की रहस्यमय बातहोन भी जाचस हइ. ");
INSERT INTO goj_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","इन्सानहोन मे से कोन कोय इन्सान की बातहोन जानस हइ, फक्त इन्सान की आत्मा जो ओमे हइ? ओसो ही परमेश्वर की बातहोन भी कोय नी जाने कि फक्त परमेश्वर को आत्मा. ");
INSERT INTO goj_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","पन हमने जगत की आत्मा नी मील्यो हइ, जो परमेश्‍वर का तरफ से हइ, कि हम उन बातहोन खे जान्येका जो परमेश्वर ने हम खे दी हइ. ");
INSERT INTO goj_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","जिन, हम इन्सानहोन कि ज्ञान की सिखइ हुइ बातहोन मे नी, पर पवित्र आत्मा की सिखइ हुइ बातहोन मे, आत्मा बात आत्मीक ज्ञान से आत्मीक बातहोन की व्याख्या करस हइ. ");
INSERT INTO goj_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","पर शारीरिक इन्सान परमेश्वर को आत्मा की बातहोन अपनइ नी कर्‍हे, क्युकि वे ओका नजर मे मूर्खता की बातहोन हइ, अरु नी उ उनका जान सकस हइ क्युकि उनकी परख्ये आत्मीक रीति से होस हइ. ");
INSERT INTO goj_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","आत्मीक जन सब कुछ परख्ये हइ, पर उ आप कोय से परख्ये नी जाय. ");
INSERT INTO goj_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","“क्युकि प्रभु को मन कोय ने जान्यो हइ, कि ओखे सिखाये?” पर हम मे मसीह को मन हइ. ");
INSERT INTO goj_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","हे भैइहोन अरु बहिन, मी तुम से या रीति से बातहोन नी करी सक्यो, जसो आत्मीक इन्सानहोन से पर जसो आंग इन्सानहोन से, अरु उनसे जो मसीह मे बच्चा हइ. ");
INSERT INTO goj_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","मेने तुमखे दूध पिलायो, खनो नी खलायो. क्युकि तुम ओखे नी खैइ सक्या था. क्युकी अब तक भी नी खैइ सकस हइ, ");
INSERT INTO goj_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","क्युकि अब तक आंग हुया येकालिये, कि जब तुम मे इर्ष्या अरु वाद विवाद हइ, ते का तुम आंग नी? अरु इन्सान का रीति पर नी चले? ");
INSERT INTO goj_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","येकालिये कि जब एक बोलस हइ, “मी पौलुस को हइ,” अरु दूसरो, “मी अपुल्लोस को हइ” ते का तुम इन्सान नी? ");
INSERT INTO goj_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","अपुल्लोस कोन हइ? अरु पौलुस कोन हइ? फक्त सेवक, जिनका वजेसे तुम इन्सान ने विश्वास कर्यो, जसो हर एक खे प्रभु ने दियो. ");
INSERT INTO goj_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","मेने झाड लगायो, अपुल्लोस ने सीच्यो, पर परमेश्वर ने बडायो. ");
INSERT INTO goj_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","येकालिये नी ते लगानआला कुछ हइ, अरु नी वोलनाला पर परमेश्वर जो बडानआला हइ उ सब कुछ हइ. ");
INSERT INTO goj_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","लगानआला अरु सींचनआला दोइ एक हइ. पर हर एक इन्सान अपना ही मेहनत का अनुसार अपनी ही मजदूरी मील्हे. ");
INSERT INTO goj_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","क्युकि हम परमेश्वर का सहकर्मी हइ. तुम परमेश्वर का खेत अरु परमेश्वर की रचना हइ. ");
INSERT INTO goj_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","परमेश्वर का वा अनुग्रह का अनुसार जो मेखे दिया गयो, मेने बुद्धिमान राजमिस्‍त्री का समान पय्या डाल्यो, अरु दूसरो ओका पर रद्दो रखस हइ पर हर एक इन्सान चौकस र्‍हिये, कि उ ओका पर कसो रद्दो रखस हइ. ");
INSERT INTO goj_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","क्युकि उ पाय्या खे छोड जो पडि हइ, अरु उ यीशु मसीह हइ, कोय दूसरो पय्या नी डाली सकतो. ");
INSERT INTO goj_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","अरु अगर कोय यो पय्या पर सोन्नो या चादी या बहुमूल्य पत्थर या काठ या घास या फूस को रद्दो रख्ये, ");
INSERT INTO goj_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","ते हर एक का काम प्रगट हुइ जाये. क्युकि उ दिन ओखे बताये. येकालिये कि अंगार का साथ प्रगट हुये अरु वा अंगार हर एक का काम समज्हे कि कसो हइ. ");
INSERT INTO goj_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","जेको काम ओका पर बन्यो हुयो स्थिर र्‍हिये, उ मजदूरी मील्हे. ");
INSERT INTO goj_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","अरु अगर कोय का काम जली जाये, ते उ नुकसान उठाये. पर उ खुद बची जाये पर जलते-जलते. ");
INSERT INTO goj_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","का तुम नी जाने कि तुम परमेश्वर कि मन्दिर हइ, अरु परमेश्वर कि आत्मा तुम मे वास करस हइ? ");
INSERT INTO goj_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","अगर कोय परमेश्वर का मन्दिर खे नाश कर्ये ते परमेश्वर ओखे नाश कर्ये. क्युकि परमेश्वर को मन्दिर पवित्र हइ, अरु उ तुम हइ. ");
INSERT INTO goj_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","कोय अपना आप खे धोखा नी दे. अगर तुम मे से कोय यो संसार मे अपना आप खे ज्ञानी समझ्ये, ते बेवकुप बन्ये कि ज्ञानी हुइ जाये. ");
INSERT INTO goj_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","क्युकि यो संसार को ज्ञान परमेश्वर का पास बेवकुप हइ, जसो लिख्यो हइ, “उ ज्ञानीहोन खे उनकी हुशारी मे फसय देस हइ,” ");
INSERT INTO goj_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","अरु फिर, “प्रभु ज्ञानीहोन खे बिचारहोन खे जानस हइ, कि बेकार हइ.” ");
INSERT INTO goj_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","येकालिये इन्सानहोन पर कोइ घमण्ड नी करणु, क्युकि सब कुछ तुमारो हइ. ");
INSERT INTO goj_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","का पौलुस, का अपुल्लोस, का कैफा, का संसार, का जिवन, का मरण, का वर्तमान, का भविष्य, सब कुछ तुमारो हइ, ");
INSERT INTO goj_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","अरु तुम मसीह का हइ, अरु मसीह परमेश्वर को हइ. ");
INSERT INTO goj_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","इन्सान हम मसीह को सेवक अरु परमेश्‍वर को भेदहोन को भण्डारी समझ्ये. ");
INSERT INTO goj_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","फिर ह्या भण्डारी मे या बात देखी जास हइ, कि विश्वासयोग्य नीकल्ये. ");
INSERT INTO goj_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","पर मरी नजर मे या भोत छोटी बात हइ, कि तुम या इन्सानहोन खे कोय न्यायी मेखे परख्ये का क्युकी मी खुद ही अपना आप खे नी पहीछानु. ");
INSERT INTO goj_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","क्युकि मरो मन मेखे कोय बात मे दोषी नी ठैइराय, पर येका से मी नीर्दोष नी ठैइर्‍ये का क्युकि मरो परखनआलो प्रभु हइ. ");
INSERT INTO goj_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","येका लिये जब तक प्रभु नी आय, टेम से पैयले कोय बात को न्याय नी करणु उ तो अंधारा की लुकी बातहोन उजाला मे दिखाये का अरु मनहोन को उद्देश्यहोन खे प्रगट कर्ये का तब परमेश्‍वर का तरफ से हर एक की प्रशसा हुये. ");
INSERT INTO goj_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","हे भैइहोन अरु बहीन, मेने या बातहोन मे तुमारा लिये अपना तरफ अपुल्लोस की चर्चा दृष्‍टान्‍त कि रीति पर करी हइ, येका लिये कि तुम हमारा द्वारा यो सीखनु कि लिख्या हुया से आगे नी बडनु, अरु एक का पक्ष मे अरु दूसरा का विरुध मे गर्व नी करणु. ");
INSERT INTO goj_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","क्युकि तरा मे अरु दूसरा मे कोन भेद करस हइ? अरु तरा पास का हइ जो तोने दूसरा से नी पायो अरु जब कि तोने दूसरा से पायो हइ, ते असो घमण्ड क्यु करस हइ, कि मान्नु नी पायो? ");
INSERT INTO goj_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","तुम तो तृप्त हुइ चुक्या. तुम धनी हुइ चुक्या, तुम ने हमारा बिना राज कर्यो. पर भलो होतो कि तुम राज करता कि हम भी तुमारा साथ राज करता. ");
INSERT INTO goj_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","मरा समझ मे परमेश्वर ने हम प्रेरितहोन का सब का बाद उन इन्सानहोन का समान ठैइरायो हइ, जिनको मरन की आज्ञा हुइ चुकी हइ. क्युकि हम जगत अरु स्वर्गदूतहोन अरु इन्सानहोन का लिये एक तमाशो ठैइऱ्यो हइ. ");
INSERT INTO goj_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","हम मसीह का लिये बेवकुप हइ. पर तुम मसीह मे बुद्धिमान हइ. हम नीर्बल हइ पर तुम बलवान हइ तुम आदर पास हइ, पर हम नीरादर होस हइ. ");
INSERT INTO goj_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","हम या घडी तक भूक-प्यासा अरु बीना कपडा, हइ, अरु घुसो खास हइ अरु मारा-मारा फिरस हइ. ");
INSERT INTO goj_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","अरु अपना ही हाथहोन काम कर्हे का मेहनत करस हइ इन्सान बुरो बोलस हइ, हम आशीष देस हइ. वे सतास हइ, हम सहेस हइ. ");
INSERT INTO goj_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","वे बदनाम करस हइ, हम प्रार्थना करस हइ हम आज तक जगत को कचरा अरु सब चिजहोन की खुर्चन का समान ठैइरा हइ. ");
INSERT INTO goj_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","मी तुम का लज्जित करण का लिये या बातहोन नी लिखतो, पर अपना प्रिय बच्चा जानी खे तुम बतउस हइ. ");
INSERT INTO goj_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","क्युकि अगर मसीह मे तुमारा सिखानआला दस हजार भी होता, ते भी तुमारा बाप भोत सा नी, येका लिये कि मसीह यीशु मे सुसमाचार, द्वारा मी तुमारा बाप हुयो. ");
INSERT INTO goj_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","येकालिये मी तुम से प्रार्थना करुस हइ, अरु मरी जसी चाल चलनु. ");
INSERT INTO goj_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","येकालिये मेने ती तीमुथियुस खे जो प्रभु मे मरो प्रिय अरु विश्वासयोग्य बेटो हइ, तुमारा पास भेज्यो हइ, अरु उ तुम यीशु मसीह मे मरो चरित्र याद कराये खे जसो कि मी हर जगा हर एक मंडली मे उपदेश करुस हइ. ");
INSERT INTO goj_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","खे त्ता तो असा फूली गया हइ, मानो मी तुमारा पास आन ही को नी. ");
INSERT INTO goj_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","पर प्रभु चाह्ये ते मी तुमारा पास जल्दी ही आयु, अरु उन फूल्या हुया की बातहोन खे नी, पर उनकी सामर्थ्य खे जानी लियु. ");
INSERT INTO goj_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","क्युकि परमेश्वर को राज बातहोन मे नी पर सामर्थ्य मे हइ. ");
INSERT INTO goj_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","तुम का चाहस हइ? मी लकडी लिखे तुमारा पास आयु या प्रेम अरु नम्रता की आत्मा का साथ? ");
INSERT INTO goj_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","ह्या तक सुनना मे आयो हइ कि तुम मे व्यभिचार होस हइ, क्युकी असो व्यभिचार जो गैरयहूदीहोन मे भी नी होतो कि एक इन्सान अपना बाप की लुगइ खे रखस हइ. ");
INSERT INTO goj_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","अरु तुम शोक तो नी कर्‍हे, जेका से असो काम कर आला तुमारा बीच मे से नीकल्या जास का पर घमण्ड करस हइ. ");
INSERT INTO goj_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","मी तो आंग को भाव से दूर थो, पर आत्मा को भाव से तुमारा साथ हुये खे मानो उपस्थिति कि दशा मे असो काम करणआला का बारे मे न्याय करी चुक्या हइ. ");
INSERT INTO goj_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","कि जब तुम अरु मरी आत्मा, हमारा प्रभु यीशु की सामर्थ्य, साथ इकठ्ठा हुये खे ते असो इन्सान खे हमारो प्रभु यीशु का नाम से. ");
INSERT INTO goj_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","शरीर को विनाश का लिये सैतान खे दियो जायेका ताकि उसकी आत्मा प्रभु का दिन मे उध्दारपाये. ");
INSERT INTO goj_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","तुमारो घमण्ड करणो अच्छो नी; तुम नी जानता कि थोडो सो खमीर पूरे गुध्या हुया आटा खे खमीर करी देस हइ. ");
INSERT INTO goj_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","पुरानो खमीर नीकाली खे अपना आप खे अच्छो कर्यो कि नवो गूध्या हुया आटो बनी जाये. ताकि तुम अखमीरी हुये खे क्युकि हमारो भी फसह जो मसीह हइ, बलिदान हुयो हइ. ");
INSERT INTO goj_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","येका लिये आनू हम उत्सव मे खुशी मनाये का नी ते पुरानो खमीर से अरु नी बुराइ अरु दुष्टता का खमीर से, पर सिधाइ अरु सच्ची की अखमीरी रोटी से. ");
INSERT INTO goj_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","मेने अपनी चिठ्ठी मे तुम खे लिख्यो हइ, कि व्यभिचारिहोन की सगति नी करणु. ");
INSERT INTO goj_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","यो नी कि तुम बिलकुल या जगत को व्यभिचारिहोन खे या लोभिहोन खे यो अंधारो करणआला काया मूर्तिपूजकहोन को सगत नी करणु; क्युकि या दशा मे ते तुमखे जगत मे से नीकली जानो ही पडस. ");
INSERT INTO goj_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","मरो कहनो यो हइ. कि अगर कोय भैइ अरु बहीन कहलै, व्यभिचारी, या लोभी, या मूर्तिपूजक, या गाली देनआला, या पियक्कड, या अधारो करणआला हुये खे ते ओकी सगत मत करणु. क्युकी असा इन्सान का साथ खानो भी नी खानु. ");
INSERT INTO goj_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","क्युकि मेखे बाहेरआला को न्याय करणा से काम, तुम अंदर आला को न्याय नी कर्‍हे? ");
INSERT INTO goj_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","पर भाहेआला को न्याय परमेश्वर करस हइ येकालिये येखे उ कुकर्मी खे अपना बीच मेसे नीकाली दे. ");
INSERT INTO goj_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","का तुम मेसे कोय खे यो हिम्मत हइ, कि जब दूसरा का साथ वाद विवाद हुये ते फैसला का लिये अधर्मीहोन का पास जाये. अरु पवित्र इन्सानहोन का पास नी जाये? ");
INSERT INTO goj_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","का तुम नी समजे खे कि पवित्र इन्सान संसार को न्याय कर्ये? अरु जब तुमखे संसार को न्याय करणो हइ, ते का तुम छोटा झगडा को भी फैसलो करण का लायक नी? ");
INSERT INTO goj_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","का तुम नी समजे कि हम स्वर्गदूतहोन को न्याय कर्ये? ते का सांसारीक बातहोन को फैसलो नी कर्ये? ");
INSERT INTO goj_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","अगर तुमखे सांसारीक बातहोन को फैसलो करणो हुये, ते का उन खे बठाड्ये जो मंडली मे कुछ नी समझे जास हइ? ");
INSERT INTO goj_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","मी तुमखे लज्जित करण का लिये यो बोलनो हइ का सचमुच तुम मे से एक भी बुद्धिमान नी मीले, जो अपना भैइहोन अरु बहीन को फैसलो करी सक्ये? ");
INSERT INTO goj_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","क्युकी भैइ-भैइ अरु बहीन मे मुकद्दमो होस हइ, अरु उ भी अविश्वासिहोन का सामने. ");
INSERT INTO goj_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","सचमुच तुम मे बडो दोष ते यो हइ, कि आपस मे मुकद्दमो करस हइ क्युकी अन्याय क्यु नी सेहस? अपनो नुकसान क्यु नी सहे? ");
INSERT INTO goj_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","क्युकी अन्याय करस अरु नुकसान पहुचास हइ, अरु उ भी भैइहोन अरु बहीन खे. ");
INSERT INTO goj_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","का तुम नी समजे, कि अन्याय इन्सान परमेश्वर का राज्य का वारिस नी हुये? धोखो नी खानु, नी वेश्यागामी, नी मूर्तिपूजक, नी परस्त्रीगामी, नी लुच्चो, नी इन्सानगमन. ");
INSERT INTO goj_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","नी चोरी, नी लोभी, नी पियक्कड, नी गाली देनआला, नी अंधारो करणआला परमेश्वर का राज का वारिस हुये. ");
INSERT INTO goj_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","अरु तुम मे से केत्ता असा ही था, पर तुम प्रभु यीशु मसीह का नाम से अरु हमारा परमेश्वर का आत्मा से धोया गए अरु पवित्र हुया अरु धर्मी ठैर्या. ");
INSERT INTO goj_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","सब चिजहोन मरा लिये अच्छो तो हइ, पर सब चिजहोन लाभ की नी सब चिजहोन मरा लिये अच्छो हइ, पर मी कोय बात का अधीन नी होयु. ");
INSERT INTO goj_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","खानो पेट का लिये, अरु पेट खाना का लिये हइ, पर परमेश्वर खे अरु येखे दोइ खे नाश कर्ये, पर आंग व्यभिचार का लिये नी, क्युकी प्रभु का लिये. अरु प्रभु आंग का लिये हइ. ");
INSERT INTO goj_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","अरु परमेश्वर ने अपना सामर्थ्य से प्रभु खे जिन्दो, अरु हमखे भी जिन्दो. ");
INSERT INTO goj_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","का तुम नी समजे कि तुमारो आंग मसीह को आंग हइ? ते का मी मसीह को आंग लिखे उनखे वेश्या का आंग बनायु? कभी भी नी. ");
INSERT INTO goj_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","का तुम नी समजे कि जो कोय वेश्या से संगति करस हइ, उ ओका साथ एक तन हुइ जास हइ क्युकि लिख्यो हइ, “वे दोइ एक तन हुये” ");
INSERT INTO goj_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","अरु जो प्रभु की संगति मे र्‍हेस हइ, उ ओका साथ एक आत्मा हुइ जास हइ. ");
INSERT INTO goj_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","व्यभिचार से बच्या र्‍हेनु जित्ता अरु पाप इन्सान करस हइ, वे आंग का बाहेर हइ, पर व्यभिचार करणआला अपना ही आंग का विरुद्ध पाप करस हइ. ");
INSERT INTO goj_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","का तुम नी समजे कि तुमारो आंग पवित्र आत्मा को मन्दिर हइ. जो तुम मे बस्यो हुयो हइ अरु तुमखे परमेश्वर का तरफ से मील्यो हइ, अरु तुम अपना नी हइ? ");
INSERT INTO goj_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","क्युकि दाम दिखे मोल लिया गए हइ, येकालिये अपनो आंग का द्वारा परमेश्वर की महिमा करणु. ");
INSERT INTO goj_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","उन बातहोन का बारे मे जो तुम ने लिखी, यो अच्छो हइ, कि इन्सान बय खे नी छीनु. ");
INSERT INTO goj_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","पर व्यभिचार खे डर से हर एक अदमी की लुगइ, अरु हर एक बय को अदमी होनु. ");
INSERT INTO goj_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","अदमी अपनी लुगइ को हक पूरो करनु; अरु ओसो ही लुगइ भी अपना अदमी को. ");
INSERT INTO goj_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","लुगइ, अपना आंग पर अधिकार नी पर ओका अदमी को अधिकार हइ. ओसो ही अदमी खे भी अपना आंग पर अधिकार नी, पर लुगइ खे हइ. ");
INSERT INTO goj_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","तुम एक दूसरा से अलग नी र्‍हेनु; पर फक्त कुछ टेम तक आपस की सम्मति से करी प्रार्थना का लिये अराम मील्ये का अरु फिर एक साथ र्‍हेनु. असो नी हो कि तुमारो असयम करण सैतान तुम खे समझ्ये. ");
INSERT INTO goj_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","पर मी जो यो बोलुस हइ उ अनुमति हइ नी कि आज्ञा. ");
INSERT INTO goj_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","मी यो चाहुस हइ, कि जसो मी हइ, ओसो ही सब इन्सान हुये पर हर एक को परमेश्‍वर का तरफ से विशेष वरदान मील्यो हइ. कोय को कोय प्रकार को अरु कोय खे अरु प्रकार को. ");
INSERT INTO goj_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","पर मी भ्याव नी हुयाआला अरु विधवाहोन का बारे मे बोलुस हइ, कि उनका लिये असो ही र्‍हेनो अच्छो हइ, जसो मी हइ. ");
INSERT INTO goj_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","पर अगर वे खुद नी करी सक्ता ते भ्याव करणु. क्युकि भ्याव करणो कामातुर र्‍हेना से भलो हइ. ");
INSERT INTO goj_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","जिनको भ्याव हुइ गयो हइ, उनका मी नी, क्युकी प्रभु आज्ञा देस हइ, कि लुगइ अपना अदमी से अलग नी होनु. ");
INSERT INTO goj_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","अरु अगर अलग भी हुइ जायेका ते बिना दूसरो भ्याव कर्या र्‍हेनु. या अपना अदमी से फिर मेल करी ले अरु नी अदमी अपनी लुगइ खे छोडनु. ");
INSERT INTO goj_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","दूसरहोन से प्रभु नी पर मी ही बोलुस हइ, अगर कोय भैइ की लुगइ विश्वास नी रखस हइ, अरु ओका साथ र्‍हेना से खुश हुये खे ते उ ओखे नी छोडनु. ");
INSERT INTO goj_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","अरु जो लुगइ को अदमी विश्वास नी रखस हइ, अरु ओका साथ र्‍हेना से खुश हुये. उ अदमी खे नी छोडनु. ");
INSERT INTO goj_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","क्युकि असो अदमी जो विश्वास नी रखे हइ, वा लुगइ करण अपवित्र ठैइरस हइ, अरु असी लुगइ जो अविश्वासी नी रखे कि इन्सान करण पवित्र ठैइरस हइ. नी ते तुमारा बाल-बच्चा अशुध्द होस कि पर अब तो पवित्र हइ. ");
INSERT INTO goj_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","पर जो इन्सान अविश्वासी नी रखे, अगर उ अलग हुये खे ते अलग होन देनु, असी पाप मे कोय भैइ या बय बन्धन मे नी. पर परमेश्वर ने तो हम खे मेल-मीलाप, लिये बुलायो हइ. ");
INSERT INTO goj_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","क्युकि हे बय, तू का जानस हइ, कि तू अपना अदमी को उध्दारकर्ये लिये? अरु हे इन्सान, तू का जानस हइ कि तू अपनी लुगइ को उध्दारकर्ये लिये? ");
INSERT INTO goj_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","पर जसो प्रभु ने हर एक, बाट्यो हइ, अरु जसो परमेश्वर ने हर एक, बुलायो हइ. ओसो ही उ चल्यो अरु मी सब मंडलीहोन मे असो ही ठैइरस हइ. ");
INSERT INTO goj_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","जो खतना कर्या हुया बुलायो गयो हइ, उ खतनारहित नी बन्नु जो खतनारहित बुलायो गयो हइ, उ खतना नी कराये. ");
INSERT INTO goj_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","नी खतना कुछ हइ, अरु नी खतनारहित पर परमेश्वर की आज्ञाहोन, मान्नु ही सब कुछ हइ. ");
INSERT INTO goj_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","हर एक जन जो दशा मे बुलायो गयो हइ, ओ मे र्‍हिये. ");
INSERT INTO goj_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","अगर तू सेवक की दशा मे बुलायो गयो हइ ते फिकर नी करणु. पर अगर तू स्वतत्रता हुइ सक्येका ते असो ही काम कर. ");
INSERT INTO goj_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","क्युकि जो सेवक की दशा मे प्रभु मे बुलायो गयो हइ, उ प्रभु, स्वतत्रता कर्या हुया हइ अरु ओसो ही जो स्वतत्रता की दशा मे बुलायो गयो हइ, उ मसीह, सेवक हइ. ");
INSERT INTO goj_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","तुम दाम दिखे मोल लिया गया हइ, इन्सानहोन को सेवक नी बन्नु. ");
INSERT INTO goj_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","हे भैइहोन, जो कोय जो दशा मे बुलाया गया हइ, उ ओ मे परमेश्‍वर, साथ र्‍हिये. ");
INSERT INTO goj_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","कुव्वारीहोन का बारे मे प्रभु की कोय आज्ञा मेखे नी मीली, पर विश्वासयोग्य होन का लिये जसी दया प्रभु ने मरा पर करी हइ, ओका जसो सम्मति देउस हइ. ");
INSERT INTO goj_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","येका लिये मरी समझ मे यो अच्छो हइ, कि आज कल क्लेश करण इन्सान जसो हइ, ओसो ही र्‍हेनु. ");
INSERT INTO goj_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","अगर तरी लुगइ हइ, ते ओकासे अलग होन कि कोशिश नी करणु अरु अगर तरी लुगइ नी, ते लुगइ की ढुडनु नी करणु ");
INSERT INTO goj_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","पर अगर तू भ्याव भी कर्ये, ते पाप नी. अरु अगर कुव्वारी भ्याव कर्यो जाये ते कोय पाप नी. पर असा को आंग दुःख हुये खे अरु मी बचानो चाहुस हइ. ");
INSERT INTO goj_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","हे भैइहोन अरु बहीन, मी यो बोलुस हइ, कि टेम कम करी गय हइ, येका लिये हुनु कि जेकी लुगइ हइ, वे असो हुये मानो उनका लुगइ नी. ");
INSERT INTO goj_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","अरु रोनआला असा हये, मान्नु रोय नी. अरु खुशी करणआला असा हुये, मान्नु खुशी नी कर्‍हे. अरु मोल लेनआला असा हुये, कि मान्नु उनका पास कुछ हइ नी. ");
INSERT INTO goj_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","अरु यो जगत का साथ व्यवहार करणआला असा हो, कि जगत ही, नी. क्युकि यो जगत कि रीति अरु व्यवहार बदलता जास हइ. ");
INSERT INTO goj_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","मी यो चाहुस हइ, कि तुम खे फिकर नी हो भ्याव नी हुया इन्सान प्रभु की बातहोन की फिकर मे र्‍हेस हइ, कि प्रभु खे कसो खुश रख्ये. ");
INSERT INTO goj_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","पर भ्यावआलो इन्सान जगत की बातहोन की फिकर मे र्‍हेस हइ, कि अपनी लुगइ खे कोय रीति से खुश रख्ये. ");
INSERT INTO goj_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","भ्यावआलो अरु भ्यावनीआला मे भी भेद हइ भ्यावनीआली प्रभु की फिकर मे र्‍हेस हइ, कि उ आंग अरु आत्मा दोइ मे पवित्र हुये, पर भ्यावआली जगत की फिकर मे र्‍हेस हइ, कि अपना अदमी, खुश रखनु. ");
INSERT INTO goj_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","ह्या बात तुम्हारा ही लाभ का लिये बोलुस हइ, नी कि तुमखे फसान का लियेका क्युकी येका लिये कि जसो अच्छो हइ. ताकि तुम एक चित्त हुइ, प्रभु की सेवा मे लग्या र्‍हेनु. ");
INSERT INTO goj_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","अरु अगर कोय यो समझ्ये का कि मी अपनी वा कुव्वारी को हक मारी र्‍हो हइ, जेकी जवानी जय र्‍हि हइ, अरु प्रयोजन भी हुये खे ते जसो चाह्ये, ओसो कर्येका येमे पाप नी, उ ओको भ्याव होन दे. ");
INSERT INTO goj_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","पर अगर उ मन मे फैसलो करस हइ, अरु कोय भोतजरुरत नी हइ, अरु उ अपनी अभिलाषाहोन खे नीयत्रित करी सकस हइ, ते उ भ्याव नी कर्यो अच्छो करस हइ. ");
INSERT INTO goj_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","ते जो अपनी कुव्वारी को भ्याव करी देस हइ, उ अच्छो करस हइ अरु जो भ्याव नी करी देस, उ अरु भी अच्छो करस हइ. ");
INSERT INTO goj_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","जब तक कोय लुगइ को अदमी जिन्दो र्‍हेस हइ, तब तक उ ओकासे बधी हुयो हइ, पर जब ओको अदमी मरी जायेका ते जेका से चाह्ये भ्याव करी सकस हइ, पर फक्त प्रभु मे. ");
INSERT INTO goj_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","पर जसी हइ अगर ओसी ही र्‍हियेका ते मरा बिचार मे अरु भी धन्य हइ, अरु मी समझुस हइ, कि परमेश्वर को आत्मा मरा मे भी हइ. ");
INSERT INTO goj_vpl VALUES ("C18_1","076_8_1","1CO","8","1","1","अब मूरती का सामने बलि करी हुइ चिजहोन का बारे मे हम जानस हइ, कि हम सब खे ज्ञान हइ ज्ञान घमण्ड परदा करस हइ, पर प्रेम से उन्नती होस हइ. ");
INSERT INTO goj_vpl VALUES ("C18_2","076_8_2","1CO","8","2","2","अगर कोय समझ्ये का कि मी कुछ जानुस हइ, ते जसो जाननो हुनु ओसो अब तक नी जान्यो. ");
INSERT INTO goj_vpl VALUES ("C18_3","076_8_3","1CO","8","3","3","पर अगर कोय परमेश्वर से प्रेम रखस हइ, ते ओखे परमेश्वर पैछानस हइ. ");
INSERT INTO goj_vpl VALUES ("C18_4","076_8_4","1CO","8","4","4","आखरी मूर्ती का सामने बलि दि हुइ चिजहोन, खान का बारे मे हम जानस हइ, कि मूर्ती जगत मे कोय चिज नी, अरु एक खे छोडी खे अरु कोय परमेश्वर नी. ");
INSERT INTO goj_vpl VALUES ("C18_5","076_8_5","1CO","8","5","5","क्युकि आकाश मे अरु पृथ्वी पर भोत सा इश्वर बोलस हइ, जसो कि भोत सा परमेश्वर अरु भोत प्रभु हइ. ");
INSERT INTO goj_vpl VALUES ("C18_6","076_8_6","1CO","8","6","6","ते भी हमारा पास तो एक ही परमेश्वर हइ अगर बाप जेका तरफ से सब चिजहोन हइ, अरु हम ओका लिये हइ, अरु एक ही प्रभु हइ, येकोमलब यीशु मसीह जेका वजेसे सब चिजहोन हुइ, अरु हम भी ओका वजेसे हइ. ");
INSERT INTO goj_vpl VALUES ("C18_7","076_8_7","1CO","8","7","7","पर सब खे या बात की ज्ञान नी. पर कुछ इन्सान होनखे मेर्ती कि येत्ती लत हुइ गइ कि खे त्ताने ते अब तक मूर्ती खे कुछ समझना कारण मूर्ती का सामने बलि दि हुइ कुछ चिज समझीखे खास हइ, अरु उनको विवेक नीर्बल हुये खे बेकार होस हइ. ");
INSERT INTO goj_vpl VALUES ("C18_8","076_8_8","1CO","8","8","8","खानो हमखे परमेश्‍वर का पास नी पहुचे अगर हम नी खायेका ते हमारो कुछ नुकसान नी, अरु अगर खायेका ते कुछ लाभ नी. ");
INSERT INTO goj_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","पर चतरो र्‍हेनु, असो नी हो, कि तुमारी या स्वतत्रता कही नीर्बलहोन का लिये ठोकर को करण हुइ जाये. ");
INSERT INTO goj_vpl VALUES ("C18_10","076_8_10","1CO","8","10","10","क्युकि अगर कोय तोखे ज्ञानी मूर्ती को मन्‍दिर मे खानो खाते देख्यो का अरु उ नीर्बल जन होन, ते का ओका विवेक मे मूर्ती का सामने बलि दि हुइ चिज को खान कि हिम्मत नी हुइ जाये. ");
INSERT INTO goj_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","या रीति से तरा ज्ञान करण उ नीर्बल भैइ जेखे लिये मसीह मर्यो खत्म हुइ जाये. ");
INSERT INTO goj_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","ते भैइहोन अरु बहीन का खिलाप अपराध करण से अरु उनको नीर्बल विवेक, चोट देन से तुम मसीह को अपराध करस हइ. ");
INSERT INTO goj_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","यो करण अगर खानो मरो भैइ अरु बहीन खे ठोकर खलाये का उ पाप मे गिर्येका ते मी कभी कोय रीति से मास नी खायेका नी हो कि मी अपना भैइ अरु बहीन खे ठोकरकरण बन्यु. ");
INSERT INTO goj_vpl VALUES ("C19_1","076_9_1","1CO","9","1","1","की मी स्वतंत्रता नी? की मी प्रेरित नी की मे ने यीशु खे जो हमारो प्रभु हइ नी देख्यो? की तु प्रभु ने मरो बनायो आला नी हय? ");
INSERT INTO goj_vpl VALUES ("C19_2","076_9_2","1CO","9","2","2","अगर मी दूसरा का लिये प्रेरित नी, तेभी तुम्हारा वास्ते ते उ; क्युकी तु प्रभु मी मरो प्रेरिताइ पर चिन्ह्यो हु ");
INSERT INTO goj_vpl VALUES ("C19_3","076_9_3","1CO","9","3","3","जो मेखे परख्ये हइ, वोका लिये यो मरो जवाब हइ. ");
INSERT INTO goj_vpl VALUES ("C19_4","076_9_4","1CO","9","4","4","का हम खान-पीन को अधिकार नी हइ? ");
INSERT INTO goj_vpl VALUES ("C19_5","076_9_5","1CO","9","5","5","का हमखे यो अधिकार नी हइ, की कोय मसीह भैइन का सात भ्याव करीखे साथ लिखे फीरनु, जसो दुसरो प्रेरित अरु प्रभु को भैइ अरु बहीन अरु कैफा करस हइ? ");
INSERT INTO goj_vpl VALUES ("C19_6","076_9_6","1CO","9","6","6","यो फक्त मेखे अरु बरनबास कोय अधिकार नी की काम करणो छोड. ");
INSERT INTO goj_vpl VALUES ("C19_7","076_9_7","1CO","9","7","7","कोन कभी अपना खर्चा से खैइखे काम करस हइ? कोन अंगूर की बाडि लगैखे ओको फल नी खाय? कोन मेडाखे पालीखे ओको दुध नी पी? ");
INSERT INTO goj_vpl VALUES ("C19_8","076_9_8","1CO","9","8","8","का मी या बात इन्सान का रिती पर बोलस हइ? ");
INSERT INTO goj_vpl VALUES ("C19_9","076_9_9","1CO","9","9","9","का व्यवस्था भी ह्या नी करी थी? क्युकी मूसा की व्यवस्था मे लिख्यो हइ, “नांगर का टेम चलाते हुये बैल को मुंडा पर मुचको नी बांधनु.” का परमेश्वर बैलहोन की चिन्ता करस हइ? ");
INSERT INTO goj_vpl VALUES ("C19_10","076_9_10","1CO","9","10","10","यो विशेष करीखे हमारा लिये बोलस हइ ह्या, हमारा लिये ही लिख्यो गयो, क्युकि अच्छो हइ कि जोतन आला आस से जोतस का अरु दावन आला हिस्सो होन का आस से दावन करणु. ");
INSERT INTO goj_vpl VALUES ("C19_11","076_9_11","1CO","9","11","11","अगर हमने तुमारा लिये आत्मीक चिजहोन बोइ, ते का या कोय बडि बात हइ, कि तुमारी आंग चिजहोन की फसल काट्ये. ");
INSERT INTO goj_vpl VALUES ("C19_12","076_9_12","1CO","9","12","12","जब दुसरा को तुम पर यो अधिकार हइ, ते का हमारो येकासे जादा नी हुये? पर हम यो अधिकार काम मे नी लाये. पर सब कुछ सेहस हइ, कि हमारा वजेसे मसीह को सुसमाचार की कोय रोक नी हुये. ");
INSERT INTO goj_vpl VALUES ("C19_13","076_9_13","1CO","9","13","13","का तुम नी जाने कि जो मन्दिर मे सेवा करस हइ, वे मन्दिर मे से खास हइ. अरु जो वेदी की सेवा करस हइ. वे वेदी का साथ हिस्सेदार होस हइ? ");
INSERT INTO goj_vpl VALUES ("C19_14","076_9_14","1CO","9","14","14","यो रीति से प्रभु ने भी ठैइरायो , कि जो दुन्या सुसमाचार सुनस हइ, उनकी जिवन का सुसमाचार से हुये. ");
INSERT INTO goj_vpl VALUES ("C19_15","076_9_15","1CO","9","15","15","पर मी इनमे से कोय भी बात काम मे नी लाये, अरु मेने तो या बातहोन येकालिये नी लिखी कि मरा लिये असो कर्यो जाये, क्युकि येकासे तो मरो मरनो ही भलो हइ. कि कोय मरो घमण्ड बेकार ठैइराये. ");
INSERT INTO goj_vpl VALUES ("C19_16","076_9_16","1CO","9","16","16","अगर मी सुसमाचार सुनायु, ते मरो कुछ घमण्ड नी. क्युकि यो तो मरा लिये जरुरती हइ. अरु अगर मी सुसमाचार नी सुनायु, ते मरा पर हाय! ");
INSERT INTO goj_vpl VALUES ("C19_17","076_9_17","1CO","9","17","17","क्युकि अगर अपनी इच्छा से यो करस हइ, ते मजदूरी खे मीलस हइ, अरु अगर अपनी इच्छा से नी कर्ये, ते भी भण्डारीपन मेखे दियो गयो हइ. ");
INSERT INTO goj_vpl VALUES ("C19_18","076_9_18","1CO","9","18","18","ते फिर मरी कोन सी मजदूरी हइ? यो कि सुसमाचार सुनाना मे मी मसीह को सुसमाचार सेंत-मेत करी दियु ह्या तक कि सुसमाचार मे जो मरो अधिकार हइ, ओखे मी पूरी रीति से काम मे लायु. ");
INSERT INTO goj_vpl VALUES ("C19_19","076_9_19","1CO","9","19","19","क्युकि सब सबसे स्वतंत्रता होना पर भी मेने अपना आप खे सब को सेवक बनैइ दियो हइ. कि जादा इन्सान खे खीची लायु. ");
INSERT INTO goj_vpl VALUES ("C19_20","076_9_20","1CO","9","20","20","मी यहूदीहोन का लिये यहूदी बन्यो कि यहूदीहोन खे खीची खे लायु, जो इन्सान व्यवस्था का अधीन हइ उनका लिये मी व्यवस्था का अधीन नी हुये पर भी व्यवस्था का अधीन बन्ये कि उनखे जो व्यवस्था का अधीन हइ, खीची लायु. ");
INSERT INTO goj_vpl VALUES ("C19_21","076_9_21","1CO","9","21","21","व्यवस्थाहिहोन का लिये मी जो परमेश्वर की व्यवस्था से हीन नी पर मसीह की व्यवस्था का अधीन हइ व्यवस्थाहीन जसो बन्नु कि व्यवस्थाहीनहोन खे खीची लायु. ");
INSERT INTO goj_vpl VALUES ("C19_22","076_9_22","1CO","9","22","22","मी नीर्बलहोन का लिये नीर्बल जसो बन्यो कि नीर्बलहोन खे खीची लायु मी सब इन्सानहोन का लिये सब कुछ बन्यो हइ, कि कोय नी कोय रीति से कोय एक को उध्दार करायु. ");
INSERT INTO goj_vpl VALUES ("C19_23","076_9_23","1CO","9","23","23","अरु मी सब कुछ सुसमाचार का लिये करुस हइ, कि दुसरा का साथ ओको सात हुइ जाये. ");
INSERT INTO goj_vpl VALUES ("C19_24","076_9_24","1CO","9","24","24","का तुम नी जाने कि दौड मे तो दौडस सब ही हइ, पर इनाम एक ही ली जास हइ? तुम असो ही दौडन का कि जीतनु. ");
INSERT INTO goj_vpl VALUES ("C19_25","076_9_25","1CO","9","25","25","अरु हर एक पइलवान सब प्रकार को उछल कुद करस हइ, वे तो एक मुरझानआला मुकुट खे पान का लिये यो सब करस हइ, पर हम तो उ मुकुट का लिये करस हइ, जो मुरझान को नी. ");
INSERT INTO goj_vpl VALUES ("C19_26","076_9_26","1CO","9","26","26","येकालिये मी तो यो रीति से दौडुस हइ, पर बेठिकान नी खे मी भी या रीति से मुक्काहोन से लडुस हइ, पर ओका समान नी जो हवा पीटतो हुयो लडस हइ. ");
INSERT INTO goj_vpl VALUES ("C19_27","076_9_27","1CO","9","27","27","पर मी अपना आंग खे मारता कूटतो का अरु कब्जा मे लउस हइ. असो नी हो कि दुसरा को प्रचार करीखे खे मी खुद ही कोय रीति से नीकम्मो ठैइर्यु. ");
INSERT INTO goj_vpl VALUES ("C110_1","076_10_1","1CO","10","1","1","हे भैइहोन अरु बहीन, मी नी चाहु कि तुम या बात से अनजान र्‍हेनु कि हमारा सब बुजरुक बद्दल का नीच्चे था, अरु सब का सब समुंदर का बीच से पार हुइ गया. ");
INSERT INTO goj_vpl VALUES ("C110_2","076_10_2","1CO","10","2","2","अरु सब ने बद्दल मे, अरु समुंदर मे, मूसा को बपतिस्मा लियो; ");
INSERT INTO goj_vpl VALUES ("C110_3","076_10_3","1CO","10","3","3","अरु सब ने एक ही आत्मीक खानो खायो. ");
INSERT INTO goj_vpl VALUES ("C110_4","076_10_4","1CO","10","4","4","अरु सब ने एक ही आत्मीक पानी पीयो, क्युकि वे उ आत्मीक चट्टान से पीता था, जो उनका साथ-साथ चलती थी. अरु उ चट्टान मसीह थो. ");
INSERT INTO goj_vpl VALUES ("C110_5","076_10_5","1CO","10","5","5","पर परमेश्वर उनमे से भोत जनसे खुश नी थो, येकालिये वे जंगल मे ढेर हुइ गया. ");
INSERT INTO goj_vpl VALUES ("C110_6","076_10_6","1CO","10","6","6","या बातहोन हमारा लिये उदाहरण ठैइरी, कि जसो उनने लालुच कर्यो, ओसो हम बुरी चिजहोन को लालुच नी करणु. ");
INSERT INTO goj_vpl VALUES ("C110_7","076_10_7","1CO","10","7","7","अरु नी तुम मुर्ती पूजनआला बन्नु. जसो कि उनमे से खे त्ता बनी गया था, जसो लिख्यो हइ, “इन्सान खान-पीन बठ्या, अरु खेलन-कूदन उठ्यो.” ");
INSERT INTO goj_vpl VALUES ("C110_8","076_10_8","1CO","10","8","8","अरु नी हम गलत काम करणु. जसो उनमे से केत्ता ने कर्यो अरु एक दिन मे तेवीस हजार मरी गा. ");
INSERT INTO goj_vpl VALUES ("C110_9","076_10_9","1CO","10","9","9","अरु नी हम प्रभु खे पैछान्यो, जसो उनमे से केत्ता ने कर्यो, अरु सापहोन का वजेसे खत्म कर्या गया. ");
INSERT INTO goj_vpl VALUES ("C110_10","076_10_10","1CO","10","10","10","अरु नी तुम कुडकुडनु, जो रीति से उनमे से केत्ता कुडकुडाया अरु खत्म करणआला का वजेसे खत्म कर्या गया. ");
INSERT INTO goj_vpl VALUES ("C110_11","076_10_11","1CO","10","11","11","पर या सब बातहोन खे जो उन पर पडिखे दृष्‍टान्‍त की रीति पर थी. अरु वे हमारी चेतावनी का लिये जो संसार का आखरी टेम टेम मे र्‍हेस हइ लिखी गइ हइ. ");
INSERT INTO goj_vpl VALUES ("C110_12","076_10_12","1CO","10","12","12","येकालिये जो समझस हइ, “मी जगापर हइ,” उ चतरो र्‍हेनु. कि खय गिरी नी पड्ये. ");
INSERT INTO goj_vpl VALUES ("C110_13","076_10_13","1CO","10","13","13","तुम कोय असी परीक्षा मे नी पड्ये जो इन्सान का सहन का बाहेर हइ अरु परमेश्वर विश्वासयोग्य हइ उ तुमखे सामर्थ्य से बाहेर सैतान परीक्षा मे नी पडन दिये का परीक्षा का साथ रस्ता भी कर्ये कि तुम सै सक्या. ");
INSERT INTO goj_vpl VALUES ("C110_14","076_10_14","1CO","10","14","14","यो कारण, हे मरा प्रिय भैइहोन अरु बहीन मूर्ति पूजा से बच्या र्‍हेनु. ");
INSERT INTO goj_vpl VALUES ("C110_15","076_10_15","1CO","10","15","15","मी बुद्धिमान जानीखे तुम से बोलुस हइ जो मी बोलुस हइ, ओखे तुम पैछाननू. ");
INSERT INTO goj_vpl VALUES ("C110_16","076_10_16","1CO","10","16","16","उ धन्यवाद को कटोरो,जेका पर हम धन्यवाद करस हइ, का उ मसीह का खुन को संगत नी? वा रोटी जेखे हम तोडस हइ, का मसीह का आंग को हिस्सेदार नी? ");
INSERT INTO goj_vpl VALUES ("C110_17","076_10_17","1CO","10","17","17","येकालिये, कि एक ही रोटी हइ ते हम भी जो भोत हइ, एक हइ क्युकि हम सब वइ एक रोटी मे हिस्सेदार होस हइ. ");
INSERT INTO goj_vpl VALUES ("C110_18","076_10_18","1CO","10","18","18","जो आंग खे भाव से इस्राएलीहोन हइ, उनखे देखनु का बलिदानहोन का खानआला वेदी का हिस्सेदार नी? ");
INSERT INTO goj_vpl VALUES ("C110_19","076_10_19","1CO","10","19","19","फिर मी का बोलुस हइ? का यो कि मूर्ति को खानो कुछ हइ, या मूर्ती कुछ हइ? ");
INSERT INTO goj_vpl VALUES ("C110_20","076_10_20","1CO","10","20","20","नी, बस यो कि गैरयहूदी जो बलिदान करस हइ, वे परमेश्वर का लिये नी पर बुरीआत्माहोन का लिये बलिदान करस हइ अरु मी नी चउस कि तुम बुरीआत्माहोन का हिस्सेदार हुये. ");
INSERT INTO goj_vpl VALUES ("C110_21","076_10_21","1CO","10","21","21","तुम प्रभु का कटोरो अरु बुरीआत्मा का कटोरो दोइ मे से नी पी सक्ये! तुम प्रभु की मेज अरु बुरीआत्माहोन की मेज दोइ का हिस्सेदार नी हुइ सखे. ");
INSERT INTO goj_vpl VALUES ("C110_22","076_10_22","1CO","10","22","22","का हम प्रभु खे घुस्सा दिलानो चाहस हइ? का हम ओकासे शक्तिमान हइ? ");
INSERT INTO goj_vpl VALUES ("C110_23","076_10_23","1CO","10","23","23","सब चिजहोन मरा लिये अच्छी तो हइ, पर सब लाभ की नी सब चिजहोन मरा लिये अच्छी तो हइ, पर सब चिजहोन से उन्नति नी. ");
INSERT INTO goj_vpl VALUES ("C110_24","076_10_24","1CO","10","24","24","कोय अपनी ही भलाइ खे नी ढूडनु क्युकी दुसरा की. ");
INSERT INTO goj_vpl VALUES ("C110_25","076_10_25","1CO","10","25","25","जो कुछ कस्साइहोन का ह्या बिकस हइ, उ खानु अरु विवेक का कारण कुछ नी पूछनु. ");
INSERT INTO goj_vpl VALUES ("C110_26","076_10_26","1CO","10","26","26","“क्युकि पृथ्वी अरु ओकी पुरीपुरी प्रभु की हइ” ");
INSERT INTO goj_vpl VALUES ("C110_27","076_10_27","1CO","10","27","27","अरु अगर अविश्वासिहोन मे से कोय तुमखे निवतता दिये, अरु तुम जानो चाह्ये, ते जो कुछ तुमारा सामने रख्यो जाये उ खानु अरु विवेक खे कारण कुछ नी पूछनु. ");
INSERT INTO goj_vpl VALUES ("C110_28","076_10_28","1CO","10","28","28","पर अगर कोय तुम से बोल्ये, “यो तो मूर्ती खे बलि करी हुइ चिज हइ,” ते उ बतानआला का कारण, अरु विवेक का कारण नी खानु. ");
INSERT INTO goj_vpl VALUES ("C110_29","076_10_29","1CO","10","29","29","मरो मतलब, तरो विवेक नी, पर उ दूसरा को भलो, मरी स्वतंत्रता दूसरा को बिचार से क्यु परख्ये जाये? ");
INSERT INTO goj_vpl VALUES ("C110_30","076_10_30","1CO","10","30","30","अगर मी धन्यवाद करीखे हिस्सेदार होउस हइ, ते जेका पर मी धन्यवाद करुस हइ, ओका कारण मरी बदनामी क्यु होस हइ? ");
INSERT INTO goj_vpl VALUES ("C110_31","076_10_31","1CO","10","31","31","येकालिये तुम चाह्ये खाओ, चाह्ये पीओ, चाह्ये जो कुछ करणु, सब कुछ परमेश्वर का महिमा का लिये करणु. ");
INSERT INTO goj_vpl VALUES ("C110_32","076_10_32","1CO","10","32","32","तुम नी यहूदीहोन, नी यूनानीहोन, अरु नी परमेश्वर की मंडली का लिये ठोकर को कारण बन्नु. ");
INSERT INTO goj_vpl VALUES ("C110_33","076_10_33","1CO","10","33","33","जसो मी भी सब बातहोन मे सब खे खुश रखुस हइ, अरु अपनो नी पर भोतजन को लाभ ढूढस हइ, कि वे उध्दारपाये. ");
INSERT INTO goj_vpl VALUES ("C111_1","076_11_1","1CO","11","1","1","तुम मरा जसी चाल चलनु जसो मी मसीह का जसी चाल चलुस हइ. ");
INSERT INTO goj_vpl VALUES ("C111_2","076_11_2","1CO","11","2","2","मी तुमारी बडाइ करुस हइ, कि सब बातहोन मे तुम मेखे याद करस हइ. अरु जो वीधी मेने तुमखे दि दियो हइ, रितीरिवाज खे कठोरता से करस हइ. ");
INSERT INTO goj_vpl VALUES ("C111_3","076_11_3","1CO","11","3","3","पर मी चाहुस हइ, कि तुम यो जानी ले, कि हर एक इन्सान को माथो मसीह हइ अरु लुगइ को माथो इन्सान हइ अरु मसीह को माथो परमेश्वर हइ. ");
INSERT INTO goj_vpl VALUES ("C111_4","076_11_4","1CO","11","4","4","जो इन्सान माथो झाक्या हुया प्रार्थना या भविष्यवाणी करस हइ, उ अपनो माथा को अपमान करस हइ. ");
INSERT INTO goj_vpl VALUES ("C111_5","076_11_5","1CO","11","5","5","पर जो बय बिना माथो झाखे प्रार्थना या भविष्यवाणी करस हइ, वा अपना माथा का अपमान करस हइ, क्युकि वा टक्कल होना का बराबर हइ. ");
INSERT INTO goj_vpl VALUES ("C111_6","076_11_6","1CO","11","6","6","अगर बय ओडनी नी ओड्ये, ते बाल भी काटी ले. अगर बय का लिये बाल कटानो या टक्कल सरम की बात हइ, तो ओडनी होडनु. ");
INSERT INTO goj_vpl VALUES ("C111_7","076_11_7","1CO","11","7","7","हा इन्सान खे अपनो माथो झाकनो अच्छो नी, क्युकि उ परमेश्वर को रुप अरु महिमा हइ. रुप पर लुगइ अदमी की शोभा हइ. ");
INSERT INTO goj_vpl VALUES ("C111_8","076_11_8","1CO","11","8","8","क्युकि अदमी लुगइ से नी हुयो, पर लुगइ इन्सान से हुइ हइ. ");
INSERT INTO goj_vpl VALUES ("C111_9","076_11_9","1CO","11","9","9","अरु अदमी लुगय का लिये नी परदा कर्यो गयो, पर लुगय अदमी का लिये करी गय हइ. ");
INSERT INTO goj_vpl VALUES ("C111_10","076_11_10","1CO","11","10","10","येकालिये स्वर्गदूतहोन का कारण लुगइ को अच्छो हइ, कि अधिकार अपना माथा पर रखनु. ");
INSERT INTO goj_vpl VALUES ("C111_11","076_11_11","1CO","11","11","11","ते भी प्रभु मे नी ते लुगइ बिना अदमी अरु नी अदमी बिना लुगइ कि हइ. ");
INSERT INTO goj_vpl VALUES ("C111_12","076_11_12","1CO","11","12","12","क्युकि जसो लुगइ अदमी से हइ, ओसो ही अदमी लुगइ का वजेसे हइ. पर सब चिजहोन परमेश्वर से हइ. ");
INSERT INTO goj_vpl VALUES ("C111_13","076_11_13","1CO","11","13","13","तुम खुद ही बिचार करणु, का बय खे बिना माथो झाखे परमेश्वर से प्रार्थना करणो अच्छो हइ? ");
INSERT INTO goj_vpl VALUES ("C111_14","076_11_14","1CO","11","14","14","का स्वभाविक रीति से भी तुम नी जाने कि अगर अदमी लम्बा बाल रख्ये, ते ओका लिये अपमान हइ. ");
INSERT INTO goj_vpl VALUES ("C111_15","076_11_15","1CO","11","15","15","पर अगर बय लम्बा बाल रखनु. ते ओका लिये शोभा हइ क्युकि बाल ओखे ओडन का खे लिये दिया गया हइ. ");
INSERT INTO goj_vpl VALUES ("C111_16","076_11_16","1CO","11","16","16","पर अगर कोय वाद विवाद करणो चाह्ये, ते यो जान्नु कि नी हमारी अरु नी परमेश्वर की मंडलीहोन की असी रीति हइ. ");
INSERT INTO goj_vpl VALUES ("C111_17","076_11_17","1CO","11","17","17","पर या आज्ञा देता हुये मी तुमारी नी बडैइ, येकालिये कि तुमारा जमा होना से भलाइ नी, पर नुकसान होस हइ. ");
INSERT INTO goj_vpl VALUES ("C111_18","076_11_18","1CO","11","18","18","क्युकि पैयले तो मी यो सुनुस हइ, कि जब तुम मंडली मे जमा होस हइ, ते तुम मे फूट होस हइ अरु मी थोडो-थोडो विश्वास भी करुस हइ. ");
INSERT INTO goj_vpl VALUES ("C111_19","076_11_19","1CO","11","19","19","क्युकि गैरयहूदी भी तुम मे जरुरती हुये, येकालिये कि जो इन्सान तुम मे सच्चा नीकल्या हइ, वे प्रकट हुइ जाये. ");
INSERT INTO goj_vpl VALUES ("C111_20","076_11_20","1CO","11","20","20","जब तुम एक जगह मे जमा हुये ते तुम प्रभु-भोज खानो खान का लिये नी. ");
INSERT INTO goj_vpl VALUES ("C111_21","076_11_21","1CO","11","21","21","क्युकि खान का टेम एक दूसरा से पैयले अपनो खानो खैइ लेस हइ, तब कोय भूखो र्हेस हइ, अरु कोय मतआलो हुइ जास हइ. ");
INSERT INTO goj_vpl VALUES ("C111_22","076_11_22","1CO","11","22","22","का खान-पीन का लिये तुमारा घर नी? या परमेश्वर की मंडली खे बेकार जानस हइ, अरु जिनका पास नी हइ उनखे लज्जित करस हइ? मी तुम से का बोलु? का या बात मे तुमारी बडइ कर्यु? मी बडइ नी करु. ");
INSERT INTO goj_vpl VALUES ("C111_23","076_11_23","1CO","11","23","23","क्युकि या बात मेखे प्रभु से पहुची, अरु मेने तुमखे भी पहुचैइ दी. कि प्रभु यीशु ने जो रात पकडायो गयो रोटी ली, ");
INSERT INTO goj_vpl VALUES ("C111_24","076_11_24","1CO","11","24","24","अरु धन्यवाद करीखे ओखे तोडि खे अरु बोल्यो, “यो मरो आंग हइ, जो तुमारा लिये हइ मरी याद का लिये यो किर्या करणु.” ");
INSERT INTO goj_vpl VALUES ("C111_25","076_11_25","1CO","11","25","25","या रीति से ओने बियारी का बाद कटोरो भी लियो, अरु बोल्यो “यो कटोरो मरा खुन मे नइ वाचा हइ जब कभी पीये, ते मरी याद का लिये यो कर्यो करणु.” ");
INSERT INTO goj_vpl VALUES ("C111_26","076_11_26","1CO","11","26","26","क्युकि जब कभी तुम या रोटी खाये, अरु यो कटोरा मे से पीस हइ, ते प्रभु को मरन खे जब तक उ नी आय, प्रचार करस हइ. ");
INSERT INTO goj_vpl VALUES ("C111_27","076_11_27","1CO","11","27","27","येकालिये जो कोय अच्छा रीति से प्रभु की रोटी खाये या ओका कटोरा मे से पीये, उ प्रभु का आंग अरु खुन को अपराधी ठैइर्ये. ");
INSERT INTO goj_vpl VALUES ("C111_28","076_11_28","1CO","11","28","28","येकालिये इन्सान अपना आप खे समज्हे अरु या रीति से या रोटी मे से खाह्ये, अरु यो कटोरा मे से पीये. ");
INSERT INTO goj_vpl VALUES ("C111_29","076_11_29","1CO","11","29","29","क्युकि जो खाता-पीता टेम प्रभु का आंग खे नी पइछान्ये, उ यो खाना अरु पीना से अपना उपर दण्ड लास हइ. ");
INSERT INTO goj_vpl VALUES ("C111_30","076_11_30","1CO","11","30","30","यो कारण तुम मे भोत सा बिना जोर अरु रोगी हइ, अरु भोत सा सोइ भी गया. ");
INSERT INTO goj_vpl VALUES ("C111_31","076_11_31","1CO","11","31","31","अगर हम अपना आप खे पहिछानता था ते दण्ड नी मील्हे. ");
INSERT INTO goj_vpl VALUES ("C111_32","076_11_32","1CO","11","32","32","पर प्रभु हमखे दण्ड दिखे हमारी ताडनो करस हइ येकालिये कि हम संसार का साथ दोषी नी ठैइर्ये. ");
INSERT INTO goj_vpl VALUES ("C111_33","076_11_33","1CO","11","33","33","येकालिये, हे मरा भैइहोन अरु बहीन, जब तुम खान का लिये जमा होस हइ, ते एक दूसरा का लिये ठैइरा करणु. ");
INSERT INTO goj_vpl VALUES ("C111_34","076_11_34","1CO","11","34","34","अगर कोय भूखो हइ, ते अपना घर मे खलइ ले जिका से तुमारो जमा होनो दण्ड को कारण नी हो, अरु बाकी बातहोन खे मी अयखे ठीक करी दियु. ");
INSERT INTO goj_vpl VALUES ("C112_1","076_12_1","1CO","12","1","1","हे भैइहोन अरुबहीन, मी नी चाहु कि तुम आत्मीक वरदानहोन का बारे मे अनजान र्‍हिया. ");
INSERT INTO goj_vpl VALUES ("C112_2","076_12_2","1CO","12","2","2","तुम समजस हइ, कि जब तुम गैरयहूदीहोन थो, ते मुक्की मूर्ती का पीछे जसो चलायो जातो थो ओसो चलतो थो. ");
INSERT INTO goj_vpl VALUES ("C112_3","076_12_3","1CO","12","3","3","येकालिये मी तुमखे चेतावनी देउस हइ कि जो कोय परमेश्वर की आत्मा की अगुअय से बोलस हइ, उ नी बोलस कि यीशु श्रापित हइ. अरु नी कोय पवित्र आत्मा का बिना बोली सकस हइ कि यीशु प्रभु हइ. ");
INSERT INTO goj_vpl VALUES ("C112_4","076_12_4","1CO","12","4","4","वरदान तो कइ प्रकार को हइ, पर आत्मा एक ही हइ. ");
INSERT INTO goj_vpl VALUES ("C112_5","076_12_5","1CO","12","5","5","अरु सेवा भी कइ प्रकार की हइ , पर प्रभु एक ही हइ. ");
INSERT INTO goj_vpl VALUES ("C112_6","076_12_6","1CO","12","6","6","अरु प्रभावशाली कार्य कइ प्रकार का हइ, पर परमेश्वर एक ही हइ, जो सब मे हर प्रकार को प्रभाव परदा करस हइ. ");
INSERT INTO goj_vpl VALUES ("C112_7","076_12_7","1CO","12","7","7","पन सब खे लाभ पहुचान का लिये हर एक खे आत्मा का उजालो दियो जास हइ. ");
INSERT INTO goj_vpl VALUES ("C112_8","076_12_8","1CO","12","8","8","क्युकि एक खे आत्मा का द्वारा बुद्धि की बातहोन दी जास हइ. अरु दूसरा खे उ आत्मा का अनुसार ज्ञान की बातहोन. ");
INSERT INTO goj_vpl VALUES ("C112_9","076_12_9","1CO","12","9","9","अरु कोय खे उ आत्मा से विश्वास. अरु कोय खे उ एक आत्मा से अच्छो करण को वरदान दियो जास हइ. ");
INSERT INTO goj_vpl VALUES ("C112_10","076_12_10","1CO","12","10","10","फिर कोय खे सामर्थ्य का काम करण की शक्ति. अरु कोय खे भविष्यवाणी की. अरु कोय खे आत्माहोन खे पैछनन खे अरु कोय खे भोत प्रकार की भाषा. अरु कोय खे भाषाहोन को अर्थ बतानो. ");
INSERT INTO goj_vpl VALUES ("C112_11","076_12_11","1CO","12","11","11","पर ये सब प्रभाकुलाली कार्य उ एक आत्मा करवास हइ, अरु जेखे जो चाहस हइ उ बाटी देस हइ. ");
INSERT INTO goj_vpl VALUES ("C112_12","076_12_12","1CO","12","12","12","क्युकि जो प्रकार आंग तो एक हइ अरु ओका हिस्सा भोत हइ, अरु उ एक आंग का सब हिस्सा, भोत होना पर भी सब मीलीखे एक ही आंग हइ, उ प्रकार मसीह भी हइ. ");
INSERT INTO goj_vpl VALUES ("C112_13","076_12_13","1CO","12","13","13","क्युकि हम सब ने का यहूदी हइ, का यूनानी, का सेवक का स्वतंत्रता एक ही आत्मा का वजेसे एक आंग होन का लिये बपतिस्मा लियो, अरु हम सब खे एक ही आत्मा पिलायो गयो. ");
INSERT INTO goj_vpl VALUES ("C112_14","076_12_14","1CO","12","14","14","येकालिये कि आंग मे एक ही हिस्सो नी पर भोत सा हइ. ");
INSERT INTO goj_vpl VALUES ("C112_15","076_12_15","1CO","12","15","15","अगर पाय बोल्ये कि मी हात नी, येकालिये आंग को नी, ते का उ वो कारण आंग को नी? ");
INSERT INTO goj_vpl VALUES ("C112_16","076_12_16","1CO","12","16","16","अरु अगर कान बोल्ये, “मी आख नी, एकालिये आंग को नी,” ते का उ या कारण आंग को नी? ");
INSERT INTO goj_vpl VALUES ("C112_17","076_12_17","1CO","12","17","17","अगर पुरो आंग आख ही होतो ते सुन्नो खा से होतो? अगर पुरो आंग कान ही होतो ते सूघनो खा होतो? ");
INSERT INTO goj_vpl VALUES ("C112_18","076_12_18","1CO","12","18","18","पर सचमुच परमेश्वर ने हिस्साहोन खे अपनी इच्छा का अनुसार एक-एक करीखे आंग मे रख्यो हइ. ");
INSERT INTO goj_vpl VALUES ("C112_19","076_12_19","1CO","12","19","19","अगर वे सब एक ही हिस्सा होता, ते आंग खा होतो? ");
INSERT INTO goj_vpl VALUES ("C112_20","076_12_20","1CO","12","20","20","पर अब हिस्सा तो भोत सा हइ, पर आंग एक ही हइ. ");
INSERT INTO goj_vpl VALUES ("C112_21","076_12_21","1CO","12","21","21","आख हात से नी बोली सखे, “मेखे तरो प्रयोजन नी,” अरु नी माथो पायहोन से बोली सकस हइ, “मेखे तुमारो प्रयोजन नी” ");
INSERT INTO goj_vpl VALUES ("C112_22","076_12_22","1CO","12","22","22","पर आंग का वे हिस्सो जो दुसरा जन से निर्बल देखी पडस हइ, भोत ही जरुरती हइ. ");
INSERT INTO goj_vpl VALUES ("C112_23","076_12_23","1CO","12","23","23","अरु आंग खे जिन हिस्साहोन खे हम कम आदरणीय समझस हइ उन्ही खे हम जादा आदर देस हइ. अरु हमारी शोभाहीन हिस्‍सा अरु भी भोत शोभायमान हुइ जास हइ, ");
INSERT INTO goj_vpl VALUES ("C112_24","076_12_24","1CO","12","24","24","फिर भी हमारो शोभायमान हिस्साहोन खे येको प्रयोजन नी, पर परमेश्वर ने आंग खे असो बनय दियो हइ कि जो हिस्सा खे घटी थी ओ खे अरु भी भोत आदर होनु. ");
INSERT INTO goj_vpl VALUES ("C112_25","076_12_25","1CO","12","25","25","ताकि आंग मे फूट नी पड्ये, पर हिस्सा एक दूसरा की बराबर फिकर कर्ये. ");
INSERT INTO goj_vpl VALUES ("C112_26","076_12_26","1CO","12","26","26","येकालिये अगर एक हिस्सो दुख पास हइ, ते सब हिस्सो ओका साथ दुख पास हइ. अरु अगर एक हिस्सा की बडाइ होस हइ, ते ओका साथ सब हिस्सा खुशी मनसा हइ. ");
INSERT INTO goj_vpl VALUES ("C112_27","076_12_27","1CO","12","27","27","यो प्रकार तुम सब मीलीखे मसीह को आंग हइ, अरु अलग-अलग ओका हिस्सा होनु. ");
INSERT INTO goj_vpl VALUES ("C112_28","076_12_28","1CO","12","28","28","अरु परमेश्वर ने मंडली मे अलग-अलग इन्सान नीयुक्त कर्यो हइ. पयलो प्रेरित, दूसरो भविष्यव्दक्ता तीसरो मास्तर फिर सामर्थ्य का काम करणआलो, फिर अच्छो करणआलो, अरु उपकार करणआलो, अरु मुखियो, अरु अलग प्रकार की भाषा बोलनआला. ");
INSERT INTO goj_vpl VALUES ("C112_29","076_12_29","1CO","12","29","29","का सब प्रेरित हइ? का सब भविष्यव्दक्ता हइ? का सब उपदेशक हइ? का सब सामर्थ्य का काम करणआला हइ? ");
INSERT INTO goj_vpl VALUES ("C112_30","076_12_30","1CO","12","30","30","का सब खे अच्छो करण को वरदान मील्यो हइ? का सब अलग प्रकार की भाषा बोलस हइ? ");
INSERT INTO goj_vpl VALUES ("C112_31","076_12_31","1CO","12","31","31","का सब भाषांतर करस हइ? तुम बडा से बडा वरदानहोन की धुन मे र्‍हेनु! पर मी तुमखे अरु भी सबसे अच्छी रस्ता बतउस हइ. ");
INSERT INTO goj_vpl VALUES ("C113_1","076_13_1","1CO","13","1","1","अगर मी इन्सानहोन खे अरु स्वर्गदूतहोन की बोलिहोन बोल्यु, अरु प्रेम नी रख्यु, ते मी तो हुयो पीतल, अरु झझनाती हुइ झाझ हइ. ");
INSERT INTO goj_vpl VALUES ("C113_2","076_13_2","1CO","13","2","2","अरु अगर मी भविष्यद्वाणी करी सक्यु, अरु सब भेदहोन अरु सब प्रकार को ज्ञान खे समझ्यु, अरु मेखे ह्या तक पूरो विश्वास हइ कि मी टेकडी खे हट्ये दियु, पर प्रेम नी रख्यु, ते मी कुछ भी नी. ");
INSERT INTO goj_vpl VALUES ("C113_3","076_13_3","1CO","13","3","3","अरु अगर मी अपनी पुरी संपत्ती कगालहोन खलय दियु का या अपनी आंग जलान का लिये दि दियु कि अरु प्रेम नी रख्यु कितना मेखे कुछ भी लाभ नी. ");
INSERT INTO goj_vpl VALUES ("C113_4","076_13_4","1CO","13","4","4","प्रेम धीरजवन्त हइ, अरु कृपालु हइ. प्रेम हेवो नी कर्‍हे. प्रेम अपनी बडाइ नी कर्येका अरु फूले नी. ");
INSERT INTO goj_vpl VALUES ("C113_5","076_13_5","1CO","13","5","5","नी शोभनआलो व्यवहार नी कर्येका उ अपनी भलाइ नी चाह्ये, झुझलाय न