﻿USE sofia;
DROP TABLE IF EXISTS sofia.gofl_vpl;
CREATE TABLE gofl_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES gofl_vpl WRITE;
INSERT INTO gofl_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Xoossay koyro salotanne sa7a medhis. ");
INSERT INTO gofl_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","He wode sa7i giigonanne aybika bayna mela de7ees. Dhumi biitta ma77ida wolqaama haathata bolla de7ees. Xoossa Ayyaanay haathaafe bollara qaaxees. ");
INSERT INTO gofl_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Hessafe guye, Xoossay, “Poo7oy hano” yaagin, poo7oy hanis. ");
INSERT INTO gofl_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Poo7oy lo77o gididaysa Xoossay be7is; poo7uwa dhumape shaakis. ");
INSERT INTO gofl_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Xoossay poo7uwa, “Gallas” gidi sunthis; qassi dhumaa “Qamma” gidi sunthis. Sa7i qammis wontis; hessi koyro gallas. ");
INSERT INTO gofl_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Hessafe guye, Xoossay, “Bollara de7iya haatha garsan de7iya haathaafe shaakiya salo gufanthoy hano” yaagin hanis. ");
INSERT INTO gofl_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Xoossay salo gufantho giigisidi, salo gufanthofe bollara de7iya haatha garsan de7iya haathaafe shaakis. ");
INSERT INTO gofl_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Xoossay he gufanthuwa, “Salo” gidi sunthis. Sa7i qammis; wontis; hessi nam7antho gallasa. ");
INSERT INTO gofl_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Hessafe guye, Xoossay, “Mela bessay qoncanaada Salope garsan de7iya haathi ubbay issi bessi shiiqo” yaagin hanis. ");
INSERT INTO gofl_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Xoossay he mela bessaa, “Biitta” gidi sunthis; qassi issi bessan shiiqida haatha, “Abba” gidi sunthis. Yaatidi, Xoossay hessi lo77o gididaysa be7is. ");
INSERT INTO gofl_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Hessafe guye, Xoossay, “Biittay mithi maata doliso; zeretha ayfey de7iya kathinne zeretha ayfey giddon de7iya mithi dolo” yaagis; hessadaka hanis. ");
INSERT INTO gofl_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Biittay mithi maata iya qommon qommon dolisis. Xoossay hessi lo77o gididaysa be7is. ");
INSERT INTO gofl_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Sa7i qammis wontis; hessi heedzantho gallas. ");
INSERT INTO gofl_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Hessafe guye, Xoossay, “Gallasa qammafe shaakanaw poo7oti salon hano. Enti qamanne, gallas, wodenne laythi erisanaw malla gido. ");
INSERT INTO gofl_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Biitta bolla poo7ana mela enti salo gufanthon hano” yaagis; hessadaka hanis. ");
INSERT INTO gofl_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Xoossay nam7u gita poo7ota medhis. Awi gallas, ageeni qamma poo7ana mela oothis. Hessadaka Xoolintota medhis. ");
INSERT INTO gofl_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Xoossay enti ha sa7a bolla poo7ana mela salon wothis. ");
INSERT INTO gofl_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Hessi, gallasinne qamma haarana melanne poo7o dhumape shaakana melasa. Xoossay hessi lo77o gididaysa be7is. ");
INSERT INTO gofl_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Sa7i qammis wontis; hessi oyddantho gallas. ");
INSERT INTO gofl_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Hessafe guye, Xoossay, “De7oy de7iya dumma dumma medhetethati haathan daro; kafotika sa7ape bollara, salo gufanthofe garsan piradho” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Yaatidi Xoossay abban de7iya gita do7ata, haatha giddon woxi qaaxiya medhetethata ubbaanne paalliya kafota ubbaa iya qommon qommon medhis. Xoossay hessi lo77o gididaysa be7is. ");
INSERT INTO gofl_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Xoossay enta, “Yeletite, darite, abba kumite, kafoti biitta bolla daro” yaagidi anjis. ");
INSERT INTO gofl_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Sa7i qammis wontis; hessi ichashantho gallas. ");
INSERT INTO gofl_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Hessafe guye, Xoossay, “De7oy de7iya medhetethati enta qommon qommon, meheta, sa7ara gooshetiya medhetethatanne do7ata enta qommon qommon biittay kesso” yaagin hanis. ");
INSERT INTO gofl_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Hessada oothidi enta ubbaa medhis. Xoossay hessi lo77o gididaysa be7is. ");
INSERT INTO gofl_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Hessafe simmin, Xoossay, “Ase nuna daanisidi ane medhoos. Enti abba moluwa, salo kafota, biitta bolla woxi qaaxiya medhetetha ubbaa haaro” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Hessada Xoossay ase bana daanisidi medhis. I ase Xoosse daanisidi medhis; enta addenne maccas oothidi medhis. ");
INSERT INTO gofl_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Xoossay entana, “Yeletite, darite, sa7a kumite; haarite. Abba molo, salo kafotanne biitta bolla woxi qaaxiya, de7oy de7iya medhetetha ubbaa haarite” yaagidi anjis. ");
INSERT INTO gofl_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Hessafe guye, Xoossay, “Taani biitta ubbaa bolla zeretha ayfey de7iya katha ubbaanne zeretha ayfey giddon de7iya mithi ubbaa hintew immas; hessi hintew kathi gido. ");
INSERT INTO gofl_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Qassika ha sa7an de7iya mehenne do7a ubbaas, salo kafo ubbaasinne sa7ara gooshetiya medhetetha ubbaas miyaba gidana mela, cil7o mithinne maata immas” yaagis; hessadaka hanis. ");
INSERT INTO gofl_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Xoossay ba medhida ubbabaaka xeelliya wode daro lo77o gididaysa be7is. Sa7i qammis; wontis; hessi usupuntho gallas. ");
INSERT INTO gofl_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Salotinne sa7i entan de7iyaba ubbabay haysada medhetidi poletis. ");
INSERT INTO gofl_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Xoossay ba oosuwa polidi, laapuntha gallasan shempis. ");
INSERT INTO gofl_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Xoossay laapuntha gallasan ba oothiya oosuwa ongidi shempida gisho he gallasaa anjis; gallasatape dummayis. ");
INSERT INTO gofl_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Salotinne sa7i hessada hani medhetis. Godaa Xoossay sa7anne salota medhida wode, ");
INSERT INTO gofl_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","sa7a bolla iri bukiboona gishonne oothiya asi bayna gisho mithinne maati dolibeenna; aaciyabayka baawa. ");
INSERT INTO gofl_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Gidoshin, sa7ape haathi pultidi, biitta ubbaa laakisees. ");
INSERT INTO gofl_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Hessafe guye, Godaa Xoossay biitta baanape ase medhidi iya siidhera de7o shempo punnidi gelsis. Yaatin, he addey de7ora de7iya ase gidis. ");
INSERT INTO gofl_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Godaa Xoossay doloha baggara Edene gannate giigisis; yan ba medhida addiya wothis. ");
INSERT INTO gofl_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Godaa Xoossay xeellanaw lo77iya, maanawuka mal7iya ubba qommo mithi biittafe dolisis. Gannate giddon de7o immiyanne lo77onne iita erisiya nam7u mithata wothis. ");
INSERT INTO gofl_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Gannate ushshiya shaafa haathay Edenepe goggees. He shaafay Edenepe keydi oyddu shaafu keyidi shaaketees. ");
INSERT INTO gofl_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Koyro shaafa sunthay Fisoone. Fisooney worqey de7iya Hawila biitta bolla goggees. ");
INSERT INTO gofl_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","He biitta worqey geeshsha worqa. Qassi al7o shittoynne shuchi yan de7ees. ");
INSERT INTO gofl_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Nam7antho shaafa sunthay Giyoone. Giyooney Tophe biitta yuushuwan goggees. ");
INSERT INTO gofl_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Heedzantho shaafa sunthay Xegroosa. Xegroosi Asoorepe doloha baggara goggees. Qassi oyddantho shaafay Efraxiisa. ");
INSERT INTO gofl_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Godaa Xoossay asi Edene Gannate oothana melanne naagana mela iya efidi yan wothis. ");
INSERT INTO gofl_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Godaa Xoossay ase, “Gannate mitha teera ubbaafe neeni maanaw danda7aasa. ");
INSERT INTO gofl_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Shin lo77onne iita erisiya mitha ayfiyape moopa. Ayis giiko, neeni iyape mida gallas tuma hayqana” yaagidi kiittis. ");
INSERT INTO gofl_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Hessafe guye, Godaa Xoossay, “Addey barka de7eysi lo77o gidenna. Taani iya maaddana mela iyaw injetiya lagge medhana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Godaa Xoossay meheta, do7atanne salo kafota ubbaa biittafe medhis. Yaatidi, enta woygidi sunthaneko be7anaw Addaameko ehin, Addaamey de7oy de7iya medhetetha ubbaa sunthida sunthay enta sunthi gididi attis. ");
INSERT INTO gofl_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Hessadaka, Addaamey meheta, salo kafotanne bazzo do7ata ubbaa sunthis. Shin Addaames injetiyanne iya maaddiya laggey bentibeenna. ");
INSERT INTO gofl_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Hessa gisho, Godaa Xoossay Addaame wolqaama dhiskon yeggis. I dhisko hayqidashin iya miye meqethafe issuwa ekidi, he bessaa ashon kunthis. ");
INSERT INTO gofl_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Godaa Xoossay Addaamepe ekida meqetha macca oothidi medhis; yaatidi iyo iyako ehis. ");
INSERT INTO gofl_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Addaamey, “Ha meqethiya ta meqethafe, ha ashshiya ta ashope eketidaro. Iya addefe eketida gisho macca geeteto” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Hessa gisho, asi ba aawanne ba aayiw aggidi, ba machera issife de7ees; nam7ay issi asi gidoosona. ");
INSERT INTO gofl_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Addaameynne Hewaanna nam7ayka xire kallo de7oosona; shin issoy issuwas yeellatokona. ");
INSERT INTO gofl_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Shooshi Godaa Xoossay medhida do7a ubbaafe aadhida genancho. Issi gallas shooshi maccasiw, “Xoossay tuma hintena, ‘Gannatiyan de7iya mitha ayfe ubbaafe moopite’ gidee?” yaagidi oychis. ");
INSERT INTO gofl_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Maccasiya shooshako, “Akay, Xoossay hessada gibeenna; nuuni gannate giddon de7iya mithata ayfe maanaw danda7oos. ");
INSERT INTO gofl_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Shin Xoossay nuna, ‘Gannate giddon de7iya mitha ayfe moopite, bochofite; ixiko hinte hayqana’ gis” yaagasu. ");
INSERT INTO gofl_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Shooshay maccasiw, “Hinte aykoka hayqeketa. ");
INSERT INTO gofl_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Xoossay hessa giday, he mitha ayfiya hinte miiko akeeka demmidi lo77onne iitaa Xoossada hinte eranaysa I, eriya gishosa” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Maccasiya mitha ayfey maanaw mal7eysa, be7anaw lo77eysanne, cincatethi demmanaw amoyaba gideysa be7asu. He mitha ayfiyape ekada masu. Qassi ba azinaska immin ika mis. ");
INSERT INTO gofl_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Enti mi simmidi, nam7ayka akeeka demmidosona. Enti xire kallo de7eysa eridosona. Hessa gisho, balase mitha haythi sikidi dancidosona. ");
INSERT INTO gofl_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Sa7i omarsida wode gannate giddon Godaa Xoossay hemetishin iya girsa Addaameynne iya machiya si7idosona. Enti gannate mitha giddon Godaa Xoossafe qosetidosona. ");
INSERT INTO gofl_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Shin Godaa Xoossay Addaame xeegidi, “Addaame, awun de7ay?” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Addaamey, “Gannate giddon ne girsa si7ada taani kallo de7iya gisho yayyada qosetas” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Godaa Xoossay, “Neeni kallo de7eysa new odiday oonee? Taani nena moopa gida mitha ayfepe madiyee?” yaagidi oychis. ");
INSERT INTO gofl_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Addaamey, “Taara daana mela neeni immida maccasiya he mitha ayfiyape taw immin mas” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Godaa Xoossay, maccasiw, “Neeni hessa ayis oothadii?” yaagidi oychis. Maccasiya, “Tana shooshay cimmin mas” yaagasu. ");
INSERT INTO gofl_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Godaa Xoossay shooshaa, “Neeni haysa oothida gisho, mehepenne do7a ubbaafe aadhada baadetidaba gida. Neeni ne ulon biittara gooshetana; ne de7o laytha ubban baana laaccana. ");
INSERT INTO gofl_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Taani, ne giddoninne maccase giddon, ne sheesha giddoninne I sheesha giddon morketethi wothana. I ne huuphiya qoxana, neka iya gindiya dukana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Maccasiw Godaa Xoossay, “Ne qanthatida ageenan daro un7etana. Neeni wolqaama waayen na7a yelana. Gidoshin, neeni ne azinaara daanaw amottana; I nena haarana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Godaa Xoossay Addaameko, “Neeni ne mache oda si7ida gishonne taani nena moopa gida mitha ayfiyape neeni mida gisho, biittay ne gaason baadetidaysa gido. Neeni ne de7o laytha ubban gita daabursan biitta oothada maana. ");
INSERT INTO gofl_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Biittay new agunthinne harme dolisana; neeni biittafe dolidi kaxiyaba maana. ");
INSERT INTO gofl_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Neeni ne medhetida biitta simmana gakanaw daaburan cawatada oothida ne kathi maana. Neeni biittafe medhetida gisho biitta simmana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Addaamey ba machiw de7oy de7iya asa ubbaas aayo gidiya gisho Hewaanno gidi sunthis. ");
INSERT INTO gofl_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Godaa Xoossay Addaamenne iya machiw ite giigisidi mayzis. ");
INSERT INTO gofl_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Godaa Xoossay, “Hiza asi lo77onne iita eron nuupe issuwada gidis. Enti banta kushiya yeddidi, de7o immiya mitha ayfiyape ekidi moonna melanne merinaw de7on doona mela teqetanaw koshshees” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Hessa gisho, enti banta medhetida biitta oothana mela Godaa Xoossay Edene Gannatepe enta kessis. ");
INSERT INTO gofl_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Yaatidi, de7o immiya mithaako efiya ogiya naagana mela Kirubeela geetetiya de7o medhetethatanne shireti shireti wodhiya tama laco mashshe Edene Gannatepe doloha baggara wothis. ");
INSERT INTO gofl_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Addaamey ba mache Hewaannira aqis. Iya qanthatada adde na7a yelasu. “Goday tana maaddin adde na7a demmas” gada Qaayela gada sunthasu. ");
INSERT INTO gofl_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Iya ishaa Aabela yelasu. Aabeli dorse heemmees qassi Qaayeli biitta oothees. ");
INSERT INTO gofl_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Undenna wodepe guye, Qaayeli ba gaden kaxida kathaafe Godaas yarsho yarshis. ");
INSERT INTO gofl_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Shin Aabeli ba dorsa wudiya giddon bayra yeletidaysa shukidi iya ashuwape modho bagga yarshis. Goday Aabelanne iya yarshuwa ekis. ");
INSERT INTO gofl_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Shin Qaayelanne iya yarshuwa ekibeenna. Hessa gisho, Qaayeli daro yilotis; iya som7oy dhumis. ");
INSERT INTO gofl_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Goday Qaayelako, “Ayis yilotay? Ne som7oy ayis dhumidee? ");
INSERT INTO gofl_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Neeni lo77o oothidaba gidiyako, ne som7oy pashka gidennee? Shin neeni lo77o oothonna ixiko, nagari do7ada ne pengen naagees. I nena haaranaw koyees, shin neeni iya xoonanaw bessees” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Hessafe guye, Qaayeli ba ishaa Aabelako, “Ane demba bessi boos” yaagis. Enti demban de7ishin, Qaayeli ba ishaa Aabela bolla dendidi iya wodhis. ");
INSERT INTO gofl_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Goday Qaayela, “Ne ishay Aabeli awunee?” yaagidi oychis. Qaayeli zaaridi, “Taani erike; ta isha naagey taneyee?” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Goday Qaayela, “Haysa ayis oothadii? Heko, ne ishaa suuthay biittafe taako xillo pirdas waassees. ");
INSERT INTO gofl_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Neeni baadetidaba gidiya gisho biitta zaarada oothanaw danda7aka. Ne ishaa wodhadasa iya suuthaaka biittan gussadasa. ");
INSERT INTO gofl_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Neeni oothinka biittay new ayfena; bete asada neeni sa7a bolla toylattada daaburana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Qaayeli Godaako, “Ne ta bolla pirdida pirday ta wolqafe bolla. ");
INSERT INTO gofl_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Neeni tana hachi biittafe yedethaasa; ne sinthafeka haassasa. Bete asada taani sa7a bolla daaburana; tana demmiya oonika wodhana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Goday iya, “Nena oonika wodhenna; wodhiko, taani laapun toho halo keyana” yaagis. Hessa gisho, iya demmiya oonika wodhonna mela Goday iya bolla naagiso malla wothis. ");
INSERT INTO gofl_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Qaayeli Godaa sinthafe keyidi, Edene baggafe doloha baggan de7iya Nooda, biittan de7is. ");
INSERT INTO gofl_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Qaayeli ba machera aqis; iya qanthatada Heenoke yelasu. He wode Qaayeli katama keexidi, he katama ba na7aa sunthan “Heenoke” gidi sunthis. ");
INSERT INTO gofl_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Heenokey Gayda yelis. Gaydi Ma7eela yelis. Ma7eeli Matusa7eela yelis. Matusa7eeli Laameha yelis. ");
INSERT INTO gofl_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Laamehi Adonne Siilo geetetiya nam7u macho ekis. ");
INSERT INTO gofl_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada Yabaala yelasu. Yaabali mehe haariyanne dunkaanen de7iya asata aawa. ");
INSERT INTO gofl_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Iya ishaa sunthay Yubaala. Yubaali qassi diithi diixeysatanne suusul7e punniya asata ubbaa aawa. ");
INSERT INTO gofl_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Siila qassi Tubalqayna geetetiya na7aa yelasu. Tubalqayni naase biratapenne biratape dumma dumma miisheta qoxeysata aawa. Tubalqayna michiya Na7imo. ");
INSERT INTO gofl_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Issi gallas Laamehi ba macheta, “Ade, Siile, si7ite; ta macheto, taani odiyaba hayzite. Issi pantha addey tana dechidi madunxisida gisho, taani iya wodhas. ");
INSERT INTO gofl_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Qaayela haluwa keyanaw laapun kushe koshshiko, Laameha haluwa keyanaw laapun tammanne laapun kushe koshshees” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Addaame machiya hara adde na7aa yelasu. Yaatada, “Qaayeli wodhida Aabela gisho Xoossay taw hara na7a immis” gada iya Seeta gada sunthasu. ");
INSERT INTO gofl_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Seeti adde na7a yelidi iya “Henoosa” gidi sunthis. Asay Godaa suntha xeegidi goyinno doomiday he wode. ");
INSERT INTO gofl_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Addaame yeletethay haysafe kaallidi xaafetidaysa. Xoossay ase medhida gallas bana daanisidi medhis. ");
INSERT INTO gofl_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","I addenne maccas oothi medhidi enta anjis. Enta medhidi Ase (Addaame) gidi sunthis. ");
INSERT INTO gofl_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Addaamey 130 laythi de7idi, bana daaniya adde na7a yelidi iya “Seeta” gidi sunthis. ");
INSERT INTO gofl_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Addaamey Seeta yelidaape guye 800 laythi de7is. Hara adde naytanne macca nayta yelis. ");
INSERT INTO gofl_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Addaamey 930 laythi de7idi hayqis. ");
INSERT INTO gofl_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Seeti 105 laythi de7idi Henoosa yelis. ");
INSERT INTO gofl_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Seeti Henoosa yelidaape guye, 807 laythi de7is. Hara adde naytanne macca nayta yelis. ");
INSERT INTO gofl_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Seeti 912 laythi de7idi hayqis. ");
INSERT INTO gofl_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Henoosi 90 laythi de7idi, Qaynana yelis. ");
INSERT INTO gofl_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Henoosi Qaynana yelidaape guye, 815 laythi de7is. Hara adde naytanne macca nayta yelis. ");
INSERT INTO gofl_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Henoosi 905 laythi de7idi hayqis. ");
INSERT INTO gofl_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Qaynani 70 laythi de7idi, Malal7eela yelis. ");
INSERT INTO gofl_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Qaynani Malal7eela yelidaape guye, 840 laythi de7is. Hara adde naytanne macca nayta yelis. ");
INSERT INTO gofl_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Qaynani 910 laythi de7idi hayqis. ");
INSERT INTO gofl_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Malal7eeli 65 laythi de7idi, Yaareda yelis. ");
INSERT INTO gofl_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Malal7eeli Yaareda yelidaape guye, 830 laythi de7is. Hara adde naytanne macca nayta yelis. ");
INSERT INTO gofl_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Malal7eeli 895 laythi de7idi hayqis. ");
INSERT INTO gofl_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Yaaredi 162 laythi de7idi, Heenoke yelis. ");
INSERT INTO gofl_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Yaaredi Heenoke yelidaape guye, 800 laythi de7is. Hara adde naytanne macca nayta yelis. ");
INSERT INTO gofl_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Yaaredi 962 laythi de7idi hayqis. ");
INSERT INTO gofl_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Heenokey 65 laythi de7idi, Matusaala yelis. ");
INSERT INTO gofl_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Matusaala yelidaape guye, Heenokey 300 laythi Xoosse ufaysiya de7o de7is. Hara adde naytanne macca nayta yelis. ");
INSERT INTO gofl_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Heenokey 365 laythi de7is. ");
INSERT INTO gofl_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Xoossi iya baako ekida gisho simmidi bentibeenna. ");
INSERT INTO gofl_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Matusaali 187 laythi de7idi, Laameha yelis. ");
INSERT INTO gofl_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Matusaali Laameha yelidaape guye, 782 laythi de7is. Hara adde naytanne macca nayta yelis. ");
INSERT INTO gofl_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Matusaali 969 laythi de7idi hayqis. ");
INSERT INTO gofl_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Laamehi 182 laythi de7idi, adde na7a yelis. ");
INSERT INTO gofl_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Yaatidi, “Ha na7ay Goday baaddida biitta bolla ha daabura ooso ubbaafe nuna shempisana” gidi iya Nohe gidi sunthis. ");
INSERT INTO gofl_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Laamehi Nohe yelidaape guye, 595 laythi de7is. Hara adde naytanne macca nayta yelis. ");
INSERT INTO gofl_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Laamehi 777 laythi de7idi hayqis. ");
INSERT INTO gofl_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Nohey 500 laythi de7i simmidi heedzu adde nayta Seema, Kaamanne Yaafeta yelis. ");
INSERT INTO gofl_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Asay sa7a bolla darida wode entaw macca nayti yeletidosona. ");
INSERT INTO gofl_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","“Xoossaa nayta” geetetiya medhetethati he macca nayti mala lo77o gideysa be7idi entafe bantaw dooridaysata machidosona. ");
INSERT INTO gofl_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Goday, “Asas de7o immiya ta Ayyaanay asan merinaw deenna. Asi hayqeysa gidiya gisho, hizape iya laythay issi xeetanne laatama gidana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","He wodenne hessafe guye, Xoossa nayti asa macca nayta ekin, nayti yeletida wode, wogga adussa asati sa7a bolla de7idosona. Enti beni wode olas minonne eretida asata. ");
INSERT INTO gofl_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Goday he wode sa7a bolla de7iya asa iitatethi daridaysanne enta wozanay ubba wode qopiyabay iita xalaala gididaysa ");
INSERT INTO gofl_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","be7idi, ase ha sa7a bolla medhidaysan azzanis; ba wozanan daro qiirotis. ");
INSERT INTO gofl_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Taani ase ayis medhadina gada qiirotas. Hessa gisho, Goday, “Taani medhida ase, mehe, do7a, sa7ara gooshetiya medhetethatanne salo kafota sa7a bollafe dhaysana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Shin Nohey Godaa sinthan saba demmis. ");
INSERT INTO gofl_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Nohe taarkey haysafe kaallidi xaafetidaysa. Nohey ba wode de7iya asa giddofe Xoossaa ufaysiyanne suure asi. ");
INSERT INTO gofl_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Nohey Seema, Kaamanne Yaafeta geetetiya heedzu adde nayta yelis. ");
INSERT INTO gofl_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","He wode biittay kumethi Xoossa sinthan tunis; biitta ubbay geellatethan kumis. ");
INSERT INTO gofl_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Xoossay ha biitta xeelliya wode sa7an de7iya asa ubbay banta ogiya tunisidi de7eysa be7is. ");
INSERT INTO gofl_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Hessa gisho, Xoossay Nohe haysada yaagidi kiittis; “Taani asa ubbaa dhaysana hanayis. Enta gaason biittay geellatethan kumida gisho, ase biittafe dhaysana. ");
INSERT INTO gofl_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Hessa gisho, mino mithafe new markabe keexa. He markabiya giddon daro qol7ata kessa. Yaatada sooranne karera made melaban meesha. ");
INSERT INTO gofl_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Markabiya haysada yaatada keexa; adussatethaa 300 wadha, gompaa 50 wadha, geesa 30 wadha ootha. ");
INSERT INTO gofl_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Markabiyas kaara medha; kaarapenne godaape giddon issi wadha gidiya bessi dooya agga. Pengiya markabiyas miye baggara kessa; markabiya heedzu pooqe kessada keexa. ");
INSERT INTO gofl_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","“Taani salope garsan shempora de7iya medhetetha ubbaa dhaysanaw dhayo haatha yeddada ha sa7aa bolla de7iyaba ubbaa dhaysana. ");
INSERT INTO gofl_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Shin taani ta caaquwa neera caaqana. Neeni, ne machiw, ne adde naytanne enta macheta ekada markabiya giddo gela. ");
INSERT INTO gofl_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Enti neera de7on daana mela, de7oy de7iya medhetetha ubbaafe qommon qommon addenne macca nam7a nam7a oothada, markabiya giddo gelsa. ");
INSERT INTO gofl_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Dumma dumma qommo kafotape, dumma dumma qommo mehetapenne sa7ara gooshetiya dumma dumma qommo medhetetha ubbaafe nam7a nam7a gididi de7on daana mela neeko yo. ");
INSERT INTO gofl_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Qassi hintenne do7ati maanaw dumma dumma qommo miya kathi efada, markabiya giddon qola” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Nohey ubbabaaka Xoossay kiitidaysada oothis. ");
INSERT INTO gofl_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Hessafe guye, Goday Nohe haysada yaagis; “Neeni ne soo asa ubbaara markabiya giddo gela. Ha wodiya yeletethaa giddon ta sheniya poliday ne xalaala gididaysa be7as. ");
INSERT INTO gofl_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Neeni tuna gidonna mehenne do7a ubbaafe iya qommofe qommofe addenne macca laapun laapun, tuna mehenne do7a ubbaafe iya qommofe qommofe issi addenne issi macca gelsa. ");
INSERT INTO gofl_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Qassi salo kafotape iya qommofe qommofe addenne macca laapun laapun oothada, biitta ubbaa bolla dumma dumma kochay de7on daana mela neera ekada gela. ");
INSERT INTO gofl_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Laapun gallasape guye, taani oytamu gallasinne oytamu qamma ha sa7aa bolla ira bukisana. Yaatada taani medhida medhetetha ubbaa biitta bollafe quchana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Yaatin, Nohey Goday iya kiitida ubbaba oothis. ");
INSERT INTO gofl_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Dhayo haathay ha sa7aa bolla yida wode Nohes laythi usupun xeeta. ");
INSERT INTO gofl_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Nohey, iya adde nayti, iya machiyanne iya nayta macheti dhayo haathaafe attanaw markabiya giddo gelidosona. ");
INSERT INTO gofl_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Tuna gidonna mehepenne do7ape, tuna mehepenne do7ape kafotapenne biittara goosheteyisata ubbaafe ");
INSERT INTO gofl_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","Xoossay Nohe kiitidaysada addenne maccas nam7a nam7a gididi, Noheko markabiya giddo gelidosona. ");
INSERT INTO gofl_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Laapun gallasape guye, dhayo haathay ha sa7a bolla yis. ");
INSERT INTO gofl_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Nohey usupun xeetu laythi de7in, nam7antho ageenan, tammanne laapuntha gallasan, biitta giddon de7iya gita ciimmuwa pulto ubbay dhuuqi aggis. Salon de7iya haatha maskooteti dooyetidosona. ");
INSERT INTO gofl_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Iray ha sa7aa bolla oytamu gallasinne oytamu qamma bukis. ");
INSERT INTO gofl_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Iri buka doomida gallas Noheynne iya machiya, iya adde nayti, Seemi, Kaaminne Yaafeti, iya nayta heedzata macheti issife markabiya giddo gelidosona. ");
INSERT INTO gofl_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Do7a ubbaafe ba qommon qommon, mehe ubbaafe ba qommon qommon, biittara gooshetiya ubbaafe ba qommon qommon, kafo ubbaafe ba qommon qommon entara issife gelidosona. ");
INSERT INTO gofl_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Shempora de7eysati ubbay nam7a nam7a gididi Noheko markabiyan gelidosona. ");
INSERT INTO gofl_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Xoossay Nohe kiitidaysada, medhetetha ubbaafe addenne macca gididi markabiya giddo gelin Nohepe guyera Goday markabiya pengiya gordis. ");
INSERT INTO gofl_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Dhayo haathay oytamu gallas sa7a bolla bukishe de7is. Haathay daridi markabiya biittafe pude denthis. ");
INSERT INTO gofl_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Haathay biitta bolla keehi darin, markabey haatha bolla tooketis. ");
INSERT INTO gofl_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Salope garsan de7iya zumati ubbay mitettana gakanaw haathay sa7a bolla keehi daris. ");
INSERT INTO gofl_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Haathay zumata xeerape aadhidi, tammanne ichashu wadha gakanaw diccis. ");
INSERT INTO gofl_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Yaatin sa7a bolla woxi qaaxiya medhetethati ubbay, kafoti, mehey, do7inne, asi ubbay hayqis. ");
INSERT INTO gofl_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Biitta bolla de7iya ba siidhera de7o shempo shempiya ubbayka hayqis. ");
INSERT INTO gofl_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Sa7a bolla de7oy de7iya ubbay, asay, mehey, do7aynne salo kafoti ubbay sa7ape qushetidosona. Noheynne iyara markabiya giddon de7eyisata xalaali attidosona. ");
INSERT INTO gofl_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","He haathay pacconna xeetanne ishatamu gallas sa7a bolla gam7is. ");
INSERT INTO gofl_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Shin Xoossay Nohe, iyara markabiya giddon de7iya do7a ubbaanne mehe ubbaa qopidi sa7a bolla carko carkisin he haathay wodhi wodhi bis. ");
INSERT INTO gofl_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Qassi biitta giddon de7iya ciimmuwa pultoynne salon de7iya haatha maskooteti gordetidosona; irayka salon teqetis. ");
INSERT INTO gofl_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Yaanin, haathay xeetanne ishatamu gallas gakanaw wodhi wodhi bis. ");
INSERT INTO gofl_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Haathay wodhin laapuntha ageenan, tammanne laapuntha gallasan markabey Araraate zumata bolla uttis. ");
INSERT INTO gofl_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Haathay tammantha ageena gakanaw wodhi wodhi bis. Tammantho ageenas koyro gallas zumata xeerati bentidosona. ");
INSERT INTO gofl_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Oytamu gallasape guye, Nohey ba keexida markabiya maskootiya ");
INSERT INTO gofl_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","dooyidi issi quuro kare yeddin quuroy haathay biitta bollafe melana gakanaw, yaanne haanne piradhishe gam7is. ");
INSERT INTO gofl_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Qassi Nohey haathay biitta bollafe wodhi wuridaako be7anaw issi holle kare yeddis. ");
INSERT INTO gofl_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Shin he holliya haathay biitta ubbaa bolla ha7ika de7iya gisho, shempiya bessi demmabuku. Hessa gisho, simmada, markabiyako yin, Nohey ba kushiya yeddidi, baako markabiya giddo ekis. ");
INSERT INTO gofl_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Hessafe guye, laapun gallas gam7idi, holliw zaaridi yeddis. ");
INSERT INTO gofl_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","He holliya sa7i omarsiya wode iyako simmada yashe shamaho aacape duuthida irxa haythi ba doonan saxa ekada yasu. Yaatin, haathay biitta bollafe wodhidaysa Nohey eris. ");
INSERT INTO gofl_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Qassi Nohey hara laapun gallas gam7idi, he holliw zaaridi yeddis. Shin he holliya iyako simmada yabuuku. ");
INSERT INTO gofl_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Nohey usupun xeetanne issi laythi de7in, koyro ageenan koyro gallas, haathay biitta bollafe xiz7is. Nohey markabiya kamaa qaari xeellidi, biittay xiz7idaysa be7is. ");
INSERT INTO gofl_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Nam7antho ageenan laatamanne laapuntha gallasan, biittay kumethi melis. ");
INSERT INTO gofl_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Xoossay he wode Nohe haysada yaagidi kiittis; ");
INSERT INTO gofl_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Neeni, ne machiw, ne adde naytanne ne nayta macheta ekada markabiya giddofe keya. ");
INSERT INTO gofl_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Enti yeletidi, darana mela de7oy de7iya medhetetha ubbaafe neera de7eyisata kafota, meheta, do7atanne biittara gooshetiya ubbaa neera kessa” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Yaatin Nohey ba adde naytara, ba macheranne ba nayta machetara markabiya giddofe keyis. ");
INSERT INTO gofl_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Yaanin, meheynne do7ay, sa7ara gooshetiya medhetethay, kafoynne sa7a bolla woxi qaaxiyaba ubbay ba qommuwan qommuwan markabiya giddofe keyidosona. ");
INSERT INTO gofl_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Hessafe guye, Nohey Godaas yarsho bessi gimbidi tuna gidonna mehenne do7a ubbaafe, tuna gidonna kafo ubbaafe ekidi, giigisida bessan yarsho oothidi xuuggis. ");
INSERT INTO gofl_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Yaatin, Goday he yarshuwa peenuwa singidi, ba wozanan haysada yaagis; “Na7atethafe doomidi asi wozanan qopiyaba ubbay iita gidikoka taani asa qoho gisho gada nam7antho ha sa7aa baaddike. Qassi taani ha7i oothidaysada de7oy de7iya medhetetha ubbaa nam7antho dhaysike. ");
INSERT INTO gofl_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Ha biittay de7ida wode ubban, zeriya wodeynne cakiya wodey, meegoyinne hombey, boneynne balgoy, gallasinne qammi ubba wode daana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Xoossay Nohenne iya adde nayta haysada yaagidi anjis; “Yeletite, darite, sa7a ubbaa kumite. ");
INSERT INTO gofl_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Sa7aa do7ati, salo kafoti, biittan woxi qaaxiyabaynne abban de7iya moloti ubbay hintew yashshaninne dagaman de7o. Enti hintew haareto. ");
INSERT INTO gofl_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Taani doliya dumma dumma cil7obata hintew immidaysada, de7oy de7iya woxi qaaxiya medhetetha ubbay hintew kathi gidana mela immas. ");
INSERT INTO gofl_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Shin shempoy giddon de7iya gisho suuthi iya giddon de7iya asho moopite. ");
INSERT INTO gofl_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Oonika shempo wodhiday pirdetana. Qassi asa suuthi gussiya do7aka hayqon pirdana. ");
INSERT INTO gofl_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Xoossay ase bana daanisidi medhida gisho, asa suuthi gussiya oona gidikoka iya suuthayka asa kushen gukana. ");
INSERT INTO gofl_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Hinte yeletite, darite, hinte sheeshayka sa7a bolla daro” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Hessafe guye, Xoossay Nohenne iyara de7iya iya adde nayta haysada yaagis; ");
INSERT INTO gofl_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Hiza, taani ta caaquwa hintera, hinte sheesharanne de7oy de7iya medhetetha ubbaara caaqayis. ");
INSERT INTO gofl_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Taani ta caaquwa kafotara, mehiyara, sa7a do7a ubbaaranne, markabiyape hintera keyida, de7oy de7iya medhetetha ubbara caaqayis. ");
INSERT INTO gofl_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Taani hintera caaqidaysa mela hizape de7oy de7iya medhetethati dhayo haathan dhayokona; ha sa7aaka zaari dhayo haathi dhaysena” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Qassika Xoossay, “Taani taapenne hintefe, de7oy de7iya medhetetha ubbaafe giddon caaqiya caaquwa mallay haysa; ");
INSERT INTO gofl_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Taani ta zuulla shaaran essas. I taapenne sa7a bolla de7iya medhetetha giddon de7iya caaquwas malla gidana. ");
INSERT INTO gofl_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Ta saluwa shaara mayzida wodenne shaaran zuulli eqida wode, ");
INSERT INTO gofl_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","taapenne hintefe giddon, de7oy de7iya dumma dumma medhetetha ubbaafe giddon caaqida ta caaquwa akeekana. De7oy de7iya medhetetha ubbaa dhaysanaw hizape guye dhayo haathi yeenna. ");
INSERT INTO gofl_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Zuulli shaaran eqida wode ta iya be7ada taapenne sa7a bolla de7iya dumma dumma medhetetha ubbaafe giddon caaqida merina caaquwa akeekana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Xoossay Nohe, “Taani taapenne sa7a bolla de7oy de7iyaba ubbaafe giddon caaqida caaquwa mallay haysa” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Markabiyape keyida Nohe adde nayti Seema, Kaamanne Yaafeta; Kaami Kanaane aawa. ");
INSERT INTO gofl_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Ha heedzati Nohe nayta; sa7a ubban de7iya asay entafe yeletidosona. ");
INSERT INTO gofl_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nohey goshshancho; I woyne tokethan koyro asi. ");
INSERT INTO gofl_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Issi gallas Nohey he woyniyape uyidi mathotidi ba dunkaaniya giddon xire kallo zin7is. ");
INSERT INTO gofl_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Kanaane aawa Kaami ba aawa kalluwa be7idi, kare keyidi, ba nam7u ishatas odis. ");
INSERT INTO gofl_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Shin Seeminne Yaafeti afila ekidi, nam7ayka banta hashiyara hashiyara gathi oykidi, guye guthu hemeti gelidi, banta aawa kalluwa kammidosona. Enti banta aawa kalluwa be7oona mela banta ayfiya haraso zaaridosona. ");
INSERT INTO gofl_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Nohey mathoy aadhin, barkidi, iya kaalo na7ay oothidaba eris. ");
INSERT INTO gofl_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Nohey iyako, “Kanaaney baadetidaba gido! I ba ishatas wursetha aylle gido” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Qassika Nohey, “Goday, Seema Xoossay galatetto! Kanaaney Seema aylle gido; ");
INSERT INTO gofl_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Xoossay Yaafeta biitta aasso. Yaafeta sheeshay Seema sheeshara wolla de7onna; Kanaaney Yaafeta aylle gido” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Dhayo haathaafe guye, Nohey heedzu xeetanne ishatamu laythi de7is. ");
INSERT INTO gofl_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Nohey uddufun xeetanne ishatamu laythi de7idi hayqis. ");
INSERT INTO gofl_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Nohe nayta, Seema, Kaamanne Yaafeta yeletethay haysafe kaallidi xaafetidaysa. Dhayo haathaafe guye, entaw adde nayti yeletidosona. ");
INSERT INTO gofl_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Yaafeta adde nayti, Gomera, Maagoge, Madaya, Yawaana, Tubaala, Mosahanne Tirasa. ");
INSERT INTO gofl_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Gomera adde nayti, Askanaaza, Irfatanne Togarma. ");
INSERT INTO gofl_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Yawaana adde nayti, Elisha, Tarsesa, Kiximanne Rooda. ");
INSERT INTO gofl_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Haysati Yuushoy abban teqetida biittan de7iya Yaafeta sheeshatas mayzata. Enti banta biittan biittan, banta doonan doonaninne banta kawotethan kawotethan shaaketidi de7iya dereta. ");
INSERT INTO gofl_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Kaama adde nayti, Kuusha, Gibxe, Liibenne Kanaane. ");
INSERT INTO gofl_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kuusha adde nayti, Saaba, Hawila, Saabita, Ra7imanne Sabtaka. Ra7ime adde nayti; Saabanne Dedaana. ");
INSERT INTO gofl_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kuushi Namiruude yelis; Namiruudey ha sa7an koyro wolqaama olancho gidis. ");
INSERT INTO gofl_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Godaa maaden wolqaama shankancho gidis. Asay, “Namiruudeda Goday nena wolqaama shankancho kesso” gidi anjey hessa gishosa. ");
INSERT INTO gofl_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Iya kawotethaas koyro katamati Sana7oora biittan de7iya Babiloone, Ereka, Arkadanne Kaline. ");
INSERT INTO gofl_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","I he biittafe Asoore bidi, Nanawe, Rehobootanne Kalaha keexis. ");
INSERT INTO gofl_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Qassi Nanawepenne Kalaha katamaape giddon Reseena keexis. ");
INSERT INTO gofl_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Mixiraymi, Luudeta, Anamimeta, Lahabeta, Naftuheta, ");
INSERT INTO gofl_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Patroosatanne Filisxeeme kochaa yelida Kasluheematanne Qaftooreta mayza. ");
INSERT INTO gofl_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanaaney ba bayra na7a Sidoonanne Heeta yelis. ");
INSERT INTO gofl_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Qassi Kanaane sheeshati Yaabuseta, Amooreta, Gergeseta, ");
INSERT INTO gofl_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hiweta, Arketa, Siinata, ");
INSERT INTO gofl_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Arwaadeta, Xamaaratanne Hamaatata yelis. Hessafe guye, Kanaane sheeshati dumma dumma bessi laaletidosona. ");
INSERT INTO gofl_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Kanaane biitta zaway Sidoonape doomidi, Garaaranne Gaazara gakidi, Soodomenne Gamoora, Adaamanne Xaboyma bidi, Lasha7a gaki eqis. ");
INSERT INTO gofl_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Haysati Kaama sheeshata; entaw dumma dumma dooni, dumma dumma biittinne dumma dumma kawotethi de7ees. ");
INSERT INTO gofl_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Seemas nayti yeletidosona. I Yaafetas bayra ishanne Eboora nayta ubbaas mayza. ");
INSERT INTO gofl_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Seema adde nayti, Elama, Asoore, Arfakisaade, Luudenne Araame. ");
INSERT INTO gofl_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Araame adde nayti, Uxa, Hula, Geteranne Masheka. ");
INSERT INTO gofl_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arfakisaadi Saala yelis. Saali Eboora yelis. ");
INSERT INTO gofl_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Ebooras nam7u adde nayti yeletidosona. Sa7an de7iya asay iya wode shaaketida gisho issuwa Pelega gidi sunthis. Iya ishaa sunthay Yoqxaana. ");
INSERT INTO gofl_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yoqxaana sheeshati haysata. Entika Almodaada, Salefa, Hasermoota, Yaraha, ");
INSERT INTO gofl_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoraama, Uzaala, Diqila, ");
INSERT INTO gofl_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obaala, Abmaala, Saaba, ");
INSERT INTO gofl_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofira, Hawilanne Yobaaba. Haysati ubbay Yoqxaana sheeshata. ");
INSERT INTO gofl_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Enti de7ida heeray Meesape bidi doloha baggara de7iya derey dariya Safaara biitta gakees. ");
INSERT INTO gofl_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Haysati ubbay Seema sheeshata; entaw dumma dumma dooni, dumma dumma biittinne dumma dumma kawotethi de7ees. ");
INSERT INTO gofl_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Haysati ubbay banta sheeshan sheeshaninne banta kawotethan kawotethan xaafetida Nohe nayta. Dhayo haathaafe guye kawotethati haysatape sa7a ubbaa laaletidosona. ");
INSERT INTO gofl_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Sa7a bolla de7iya asi ubbay koyro issi doonan odetees. ");
INSERT INTO gofl_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Enti doloha baggafe dendidi bida wode Sana7oora biittan demba bessi demmidi yan uttidosona. ");
INSERT INTO gofl_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Enti issoy issuwako, “Haa yiite, xuube medhidi, minnana mela taman xuuggoos” yaagidosona. Enti shucha gisho xuube, urqa gisho made melaba, ");
INSERT INTO gofl_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","ekidi, “Haa yiite, nu sunthaa xeegisanawunne qassi nuuni ha sa7a bolla laaletonna attana mela issi gita katamaanne xeeray salo gakiya pooqe keexoos” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Shin Goday asati keexida gita katamaanne pooqiya be7anaw duge wodhis. ");
INSERT INTO gofl_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Goday haysada yaagis; “Heko, enti issi asi; enti ubbayka issi doonan odetidosona. Enti ha7i haysa oothanaw doomidosona. Enti bantaw oothanaw halchidaba polonna aggokona. ");
INSERT INTO gofl_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Yaaniya gisho, haayite; duge wodhidi enti issoy haasayiya doona issoy eronna mela enta doona dummayos” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Goday enta hessafe sa7a ubbaa bolla laallin, enti katama keexeysa aggaagidosona. ");
INSERT INTO gofl_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Goday sa7an de7iya asa doona yan buqida gisho he katamaa sunthay Babiloone geetetis. Goday enta hessafe sa7a ubbaa bolla laallis. ");
INSERT INTO gofl_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Seema yeletethay haysafe kaallidi xaafetidaysa; dhayo haathaafe guye, nam7u laythi gidin, Seemas laythi xeeta gidida wode, Seemi Arfakisaade yelis. ");
INSERT INTO gofl_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Seemi Arfakisaade yelidaape guye, ichashu xeetu laythi de7is. Hara adde naytanne macca nayta yelis. ");
INSERT INTO gofl_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arfakisaadi 35 laythi de7idi, Salaha yelis. ");
INSERT INTO gofl_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Arfakisaadi Saala yelidaape guye, 403 laythi de7is. Hara adde naytanne macca nayta yelis. ");
INSERT INTO gofl_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Saali 30 laythi de7idi, Eboora yelis. ");
INSERT INTO gofl_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Saali Eboora yelidaape guye, 403 laythi de7is. Hara adde naytanne macca nayta yelis. ");
INSERT INTO gofl_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Eboori 34 laythi de7idi, Pelega yelis. ");
INSERT INTO gofl_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Eboori Pelega yelidaape guye, 430 laythi de7is. Hara adde naytanne macca nayta yelis. ");
INSERT INTO gofl_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Pelegi 30 laythi de7idi, Ra7a yelis. ");
INSERT INTO gofl_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Pelegi Ra7a yelidaape guye 209 laythi de7is. Hara adde naytanne macca nayta yelis. ");
INSERT INTO gofl_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Ra7i 32 laythi de7idi, Saruga yelis. ");
INSERT INTO gofl_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Ra7i Saruga yelidaape guye, 207 laythi de7is. Hara adde naytanne macca nayta yelis. ");
INSERT INTO gofl_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Sarugi 30 laythi de7idi, Nakoora yelis. ");
INSERT INTO gofl_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Sarugi Nakoora yelidaape guye, 200 laythi de7is. Hara adde naytanne macca nayta yelis. ");
INSERT INTO gofl_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nakoori 29 laythi de7idi, Taara yelis. ");
INSERT INTO gofl_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Nakoori Taara yelidaape guye, 119 laythi de7is. Hara adde naytanne macca nayta yelis. ");
INSERT INTO gofl_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Taari 70 laythi de7idi, Abrame, Nakooranne Haarane yelis. ");
INSERT INTO gofl_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Taara yeletethay haysafe kaallidi xaafetidaysa; Taari Abrame, Nakooranne Haarane yelis. Yaatin Haraani Looxe yelis. ");
INSERT INTO gofl_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Haraani ba aaway Taari paxa de7ishin, ba yeletida Kaldaaweta biittan, gita Uure kataman hayqis. ");
INSERT INTO gofl_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abrameynne Naakorey nam7ayka machidosona. Abrame mache sunthay Soora. Qassi Nakoora mache sunthay Milko. Milka Haarana na7iw; Haaraney Milkanne Yosika aawa. ");
INSERT INTO gofl_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Soora maynthi gidida gisho iw na7i baawa. ");
INSERT INTO gofl_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Taari ba na7aa Abrame, ba na7aa Haarane na7aa Looxenne, ba na7aa Abrame machiw Soora ekidi, Kanaane biitta baanaw Kaldaaweta katamaa Uurepe dendis. Shin enti Kaarane katama gakidi yan uttidosona. ");
INSERT INTO gofl_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Taari 205 laythi de7idi Kaaranen hayqis. ");
INSERT INTO gofl_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Goday Abrameko, “Ne biittafe, ne deriyape, ne soo asaape, shaaketada ta nena bessiya biitta ba. ");
INSERT INTO gofl_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Ta nena wolqaama dere oothana, nena ta anjana ne suntha gita kessana; ne haratas anjo gidana. ");
INSERT INTO gofl_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Taani nena anjeyisata anjana; nena baaddeyisata baaddana, biitta bolla de7iya dere ubbay ne gaasora anjetana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Hessa gisho, Abramey Xoossay iya kiitidaysada keyis. Looxey iyara issife bis. Abramey Kaaranepe keyiya wode iyaw laythi laapun tammanne ichasha. ");
INSERT INTO gofl_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Abramey ba machiw Soora, ba isha na7a Looxe, Kaaranen de7ishe shiishida shaluwanne ba aylleta ubba ekidi Kanaane biitta bidi gakidosona. ");
INSERT INTO gofl_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abramey Seekeman de7iya More geetetiya gita mithaako gakanaw kanthidi bis. He wode Kanaane asati he biittan de7oosona. ");
INSERT INTO gofl_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Xoossay Abrames yan qoncidi, “Ha biitta taani ne sheeshas immana” yaagis. Ika ba qoncida Godaas he bessan yarsho bessi giigisis. ");
INSERT INTO gofl_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","He bessaafe dendidi Beetelepe doloha baggara de7iya zumako bis. Yan Beetele wuloha baggan, Gaye doloha baggan aggidi, ba dunkaaniya tokis; yan Godaas yarsho bessi giigisidi Godaa sunthaa xeegis. ");
INSERT INTO gofl_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Hessafe guye, Abramey bessafe besse aadhishe Negebe gakis. ");
INSERT INTO gofl_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","He wode Kanaane biittan koshi keyis. Koshay minnida gisho guutha wode yan daanaw Abramey Gibxe biitta bis. ");
INSERT INTO gofl_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Gibxe gelanaw matiya wode Abramey ba mache Soorako, “Neeni mala lo77o gideysa taani erayis; ");
INSERT INTO gofl_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Gibxe asati nena be7idi, ‘Hanna iya machiw’ yaagidi tana wodhidi nena aggaagana. ");
INSERT INTO gofl_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Hessa gisho, ne gisho gidi taw lo77oba oothana melanne ta shempiya attana mela ‘Ta iyaw micho’ yaaga” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Abramey Gibxe biitta gakida mela Gibxe asati Soora mala lo77o maccasi gidoysa be7idosona. ");
INSERT INTO gofl_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Gibxe Paarona moorinnati iyo be7idi daro nashshidi kawa Faaronas odidosona, iyoka kawa sinthe efidosona. ");
INSERT INTO gofl_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","I gaason kawoy Abrame bonchidi mokis. Gujidika dorsata, miizata, hareta, gimaleta, adde aylletanne macca aylleta iyaw immis. ");
INSERT INTO gofl_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Shin Goday Abrame mache Soora gaason Gibxe kawanne iya keetha gado hargen shocis. ");
INSERT INTO gofl_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Hessafe guye, kawoy Abrame xeegisidi, “Ne ta bolla oothidabay haysi aybee? Iya ne macho gideysa ayis taw odabikii? ");
INSERT INTO gofl_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Ayis ta micho gada wordotadii? Ta iyo macho oothada ekas, shin attis; ne machiya hannashu eka ba” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Hessafe guye, Abramenne iya machiw iyaw de7iyaba ubbara kessi yeddana mela Kawoy ba asata kiittis. ");
INSERT INTO gofl_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Abramey ba machiw Sooranne baw de7iyaba ubba ekidi Gibxefe Negebe mela biitta bis. Looxeyka iyara wolla bis. ");
INSERT INTO gofl_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abramey he wode mehen, biraninne worqan daro duretis. ");
INSERT INTO gofl_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Abramey Nagebepe dendidi bessafe besse aadhishe Beetele gakanaw bis. Beetelepenne Gayepe giddon I koyro dunkaaniya tokida bessaanne ");
INSERT INTO gofl_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Godaas kase yarsho yarshida bessa gakidi, yan Abramey Godaa sunthaa xeegis. ");
INSERT INTO gofl_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Abramera wolla hemetiya Looxesika daro dorsati, deeshati, meheti, soo asatinne aylleti de7oosona. ");
INSERT INTO gofl_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","He wode Abramesinne Looxes daro mehey de7iya gisho enti banta meheta heemmiya bessay xuummis. ");
INSERT INTO gofl_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Hessa gisho, Abrame meheta heemmeyisata giddoninne Looxe meheta heemmeyisata giddon kachi keyis. He wode Kanaane asatinne Parze asati he biittan de7oosona. ");
INSERT INTO gofl_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Hessa gisho, Abramey Looxeko, “Nuuni ishanta gidiya gisho nu giddon woyko nu meheta heemmeyisata giddon kachi daanaw bessena. ");
INSERT INTO gofl_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Biittay dalga gidiya gisho nu wolipe shaaketana. Ne haddirsa bagga biiko taani ushacha bagga baana; neeni ushacha bagga biiko taani haddirsa bagga baana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Looxey biitta yuuyi aadhidi xeelliya wode Yordaanose zangaaray, Godaa gannatiyada woyko Zo7aare baggara de7iya Gibxe biitta mela haathi kumidaysa be7is. Hessika, haniday Goday Soodomenne Gamoora geetetiya katamata dhaysanape sinthe. ");
INSERT INTO gofl_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Hessa gisho, Looxey Yordaanose zangaara ubba baw dooridi doloha bagga bis. Hessada hanidi issoy issuwafe shaaketidosona. ");
INSERT INTO gofl_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abramey Kanaane biittan de7is. Shin Looxey Zangaaran de7iya katamata giddon Soodome matan ba dunkaaniya tokis. ");
INSERT INTO gofl_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","He wode Soodome asay daro iitanne Godaa sinthan nagaranchota. ");
INSERT INTO gofl_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Looxey Abramepe shaaketidaape guye, Goday Abrameko, “Ne de7iya bessaafe pude dhoqu gada pudeha bagganne dugeha bagga, doloha bagganne wuloha bagga yedda xeella. ");
INSERT INTO gofl_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","He neeni be7iya biitta ubba taani merinaw newunne ne sheeshas immana. ");
INSERT INTO gofl_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Taani ne sheesha biitta baanada darsana. Oonika biitta baana taybanaw danda7onaysada ne sheeshayka taybetenna. ");
INSERT INTO gofl_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Taani ha biitta new immana gisho dendada biitta adussatethaninne dalgatethan simereta.” ");
INSERT INTO gofl_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Hessa gisho, Abramey ba dunkaaniya shoddidi Kebroonan de7iya Mamire gita mithata matan de7anaw bis. Yan Godaas yarsho bessi giigisis. ");
INSERT INTO gofl_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Sana7oora kawoy Amrafeeli, Elsaare kawoy Ariyooki, Elama kawoy Kolodogomoorinne Goyma kawoy Tidaley oyddu kawotethati wolla, ");
INSERT INTO gofl_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","ichashu kawotethatara, Soodome kawa Beraara, Gamoora kawa Bersara, Adaama kawa Sen7abera, Xiboyma kawa Sambaranne Zo7aara geetetiya Beella kawuwara oletanaw dendidosona. ");
INSERT INTO gofl_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Ha ichashu kawotethati issife shiiqidi Maxine Abba geetetiya Sidima zangaaran banta toora shiishidosona. ");
INSERT INTO gofl_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Ha kawotethati tammanne nam7u laythi Kolodogomooras haaretidosona shin tammanne heedzantho laythan iyaw kiitetonna ixidosona. ");
INSERT INTO gofl_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Tammanne oyddantho laythan Kolodogomoorinne iyara tobbida kawotethati banta olanchota eki bidi Raafaymeta Astarooten de7iya Qarnayman, Zuzayteta Haaman, Emimeta Sawen de7iya Qiratayman; ");
INSERT INTO gofl_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Qassi Hoora biitta asataka derey dariya Sayre biittan oli xoonidi, mela biitta matan de7iya Elfaraana geetetiya bessa gakanaw goodidosona. ");
INSERT INTO gofl_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Yaape simmidi, Qaadesa geetetiya Ayin Mispata yidosona. Amaaleqata biitta ubbanne Hazazon Tamaaren de7iya Amooreta biitta oli xoonidi oykidosona. ");
INSERT INTO gofl_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Hessafe guye, Soodome kawoy, Gamoora kawoy, Adaama kawoy, Zeboyma kawoy, Zo7aare geetetiya Beella kawoy dendidi Sidima zangaaran olas giigidosona. ");
INSERT INTO gofl_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Ha ichashu kawotethati, Elama kawara, Goyma kawara, Sana7oora kawaranne Elsaare kawara ha oyddu kawotethatara oletidosona. ");
INSERT INTO gofl_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","He wode Sidima zangaaran madeda oykiyabati de7iya ollati de7oosona. Soodome kawoynne Gamoora kawoti olape attanaw baqatishe he ollan wullidosona. Shin hanko heedzu kawotethati zumako baqatidi attidosona. ");
INSERT INTO gofl_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Oyddu kawotethati Soodomeninne Gamooran de7iyaba ubba hari attoshin, enta kathaaka bonqidi efidosona. ");
INSERT INTO gofl_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Abrame isha na7ay Looxey Soodomen de7iya asi gidiya gisho ika baw de7iyaba ubbara di7etis. ");
INSERT INTO gofl_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Hessafe guye, di7eti bida asaape kessi ekida issi asi yidi hanidaba ubba Ibraawe addiya Abrahaames odis. He wode Abramey Amoore addiya Mamire gita mithata matan de7ees. Mamireynne iya ishati Eskolinne Aneeri olaa zaaranaw Abramera caaqidi uttidosona. ");
INSERT INTO gofl_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Abramey ba isha na7ay di7etidaysa si7ida wode ba son yeleti diccidi loohida 318 tooranchota ekidi enta geedo kaallidi Daane katama gakanaw bis. ");
INSERT INTO gofl_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","I baara eki bida tooranchota qamma cugan cugan shaakidi morketa olidi xoonis. Damasqofe pudeha baggara de7iya Hoobe geetetiya bessi gakanaw goodis. ");
INSERT INTO gofl_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Yaatidi de7etidaba ubba, ba isha na7a Looxenne iyaw de7iyaba ubba, maccasaanne hara asata woossis ekis. ");
INSERT INTO gofl_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Abramey Kolodogomoorinne iyara tobbida kawota xoonidi simmiya wode Soodome kawoy, Kawota Zangaara geetetiya Sawe Zangaaran iya mokanaw keyis. ");
INSERT INTO gofl_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Ubbaafe Dhoqa Xoossaa kahiney, Saleema kawoy Malkexaadeqi uythinne woyne ekidi yis. ");
INSERT INTO gofl_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","I haysada Abrame anjis; “Salonne sa7a medhida, Ubbaafe Dhoqa Xoossay nena anjo. ");
INSERT INTO gofl_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Ne morketa ne kushen aathidi immida, Ubbaafe Dhoqa Xoossay galatetto” yaagidi anjis. Abramey ba demmidaba ubbaafe asraata kessidi Malkexaadeqas immis. ");
INSERT INTO gofl_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Soodome kawoy Abrameko, “Shaluwa ne ekada, asaa taw imma” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Shin Abramey Soodome kawako, “Taani Godaas, saluwanne sa7a medhida Ubbaafe Dhoqa Xoossas ta kushiya denthas. ");
INSERT INTO gofl_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Neeni, ‘Abrame dure oothiday tana goonnaada’ hari attoshin kire woyko caamma wodoroka ekike. ");
INSERT INTO gofl_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Ta asati midaysafe attishin ta aybibaaka ekike. Qassi taara bida Aneeri, Askoolinne Mamirey bantana gakiyaba eko” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Hessafe guye, Goday Abrames amuhon qoncidi, “Abrame babofa, taani new gondalle, Ne woytoy gita” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Shin Abramey, “Abeeti Ubba Haariya Godaw, neeni immiya woytoy taw aysee? Taw yeloy baawa; buroo tana laattanay Damasqo Eli7azara gidennee? ");
INSERT INTO gofl_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Abramey, neeni taw yelo immaboonna gisho ta keethan de7iya ta aylley tana laattana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Goday iyako, “Ha aylley nena laattenna, shin ne gulbatape keyana ne na7ay nena laattana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Yaagi simmidi iya kare kessidi, “Pude salo xeella, neeni xoolintota paydanaw danda7iko payda, hiza ne sheeshayka hessada gidana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abramey Godaa ammanis; Goday iyaw hessa xillotethi oothidi ekis. ");
INSERT INTO gofl_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Qassika Goday iyako, “Neeni ha biitta laattana mela Kaldaaweta biittafe Uure katamaape nena kessida Goday tana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Shin Abramey iyako, “Abeeti Ubba Haariya Godaw ha biitta ta laatanaysa aybin ero?” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Goday iyako, “Heedzu laythi gidida issi ussi, issi deeshi, issi dorsenne hessadaka hollenne gorille taw ekada ya” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Abramey hessata ubba Xoossas ehidi kafoti attishin, harata qanxidi nam7u kessi shaakidi issuwa issuwa ginan wothis. ");
INSERT INTO gofl_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Ankoti he ashuwa maanaw bollafe wodhidosona; shin Abramey enta goodis. ");
INSERT INTO gofl_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Awi wullana haniya wode Abrame wolqaama dhiskoy shoci yeggis. Daganthiya wolqaama dhumi iya bolla wodhis. ");
INSERT INTO gofl_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Goday Abrameko, “Ne sheeshay allaga biittan bete asi gididi daanaysa loythada era; enti aylletethan oyddu xeetu laythi naaqeti haaretana. ");
INSERT INTO gofl_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Shin entana aylletethan haariya deriya ta pirdana; enti he biittafe keyishe daro shalo ekidi keyana. ");
INSERT INTO gofl_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Nena gidiko, neeni ne mayzatako sarotethan baana. Neeni daro cimada moogetana. ");
INSERT INTO gofl_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Ne sheeshay buroo oyddantho yeletethan ha biitta simmana. Ayis giiko, Amooreta nagaray pirdetana likiya buroo gakibeenna” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Awi wullin sa7i dhuma linxi gin, cooce tama cuyinne tama lacoy bentidi shaaketida ashuwa giddora aadhis. ");
INSERT INTO gofl_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","He gallas Goday Abrames, “Gibxe shaafape doomidi Efraxiisa shaafa gakanaw de7iya biitta ubbaa taani ne sheeshas immana. ");
INSERT INTO gofl_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","He biittay Qeenata biitta, Qenezata biitta, Qadimooneta biitta, ");
INSERT INTO gofl_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Hiteta biitta, Parzeta biitta, Raafaymeta biitta, ");
INSERT INTO gofl_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amooreta biitta, Kanaaneta biitta, Gergeseta biittanne Yaabuseta biitta” yaagidi caaqis. ");
INSERT INTO gofl_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Abrame machiya Soora iyaw na7a yelabuuku. Shin iw Gibxefe yida Aggaaro geetetiya gadhindoy de7awusu. ");
INSERT INTO gofl_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Soora Abrameko, “Taani na7a yelonna mela Goday tana yelo diggis. Neeni bada ta ayllera aqa; taani I baggara na7a demmanekonne ooni eri” yaagasu. Abramey I qofa ekis. ");
INSERT INTO gofl_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Abramey Kanaane biittan tammu laythi de7idaape guye, iya machiya Soora Gibxefe yida ba aylliw Aggaaro ba azinaas macho oothada immasu. ");
INSERT INTO gofl_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Abramey Aggaaro ekis, iyaka qanthatasu. Iya baw qanthatidaysa erida wode ba godatiw kadhasu. ");
INSERT INTO gofl_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Soora Abrameko, “Ha qohuwas tana gathiday nena; taani ta aylliw new immin, iya qanthatidysa be7ada tana kadhawusu. Nebaanne tabaa Goday pirdo” yaagasu. ");
INSERT INTO gofl_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Abramey Soorako, “Hanno be7a ne aylliw iya ne kushena; nena lo77idaba ootha” yaagis. Hessafe guye, Soora Aggaaro un7ethin yaape keyada baqatasu. ");
INSERT INTO gofl_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Godaa kiitanchoy Aggaaro mela biittan, pulto haatha matan demmis; he pultoy shuura biitta efiya ogiya matan de7ees. ");
INSERT INTO gofl_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Kiitanchoy Aggaaro, “Soora ayllete, Aggaare, awupe yadii? Awu bay?” yaagidi oychis. Aggaara zaarada, “Taani ta godate Soorape baqatas” yaagasu. ");
INSERT INTO gofl_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Godaa kiitanchoy iiko, “Ne godateko simma bada iw haareta” yaagidi odis. ");
INSERT INTO gofl_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Gujidika Godaa kiitanchoy iiko, “Ne yeletetha oonika taybanaw danda7onnaada oothada darsana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Qassika Godaa kiitanchoy iyo, “Heko neeni qanthatadasa, Neeni adde na7a yelana. Xoossay ne waasuwa si7ida gisho Iya neeni Isma7eela gada sunthana ");
INSERT INTO gofl_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","I bazzo hare mela gidana, I ba qesiya asa ubba bolla denthana, Qassi asa ubbayka banta qesiya iya bolla denthana. I ba ishata ubbara ixon de7ana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Aggaara baara odetida Godaa, “Neeni Tana Be7iya Xoossa” yaagada xeegasu. “Taani tana be7eysa be7as” yaagasu. ");
INSERT INTO gofl_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Hessafe dendoysan he pulto haathay, “Tana Be7iya De7o Xoossa Pultuwa” geetetidi xeegetis. He haatha pultoy Qaadesapenne Bareedape giddon de7ees. ");
INSERT INTO gofl_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Aggaara Abrames adde na7a yelasu; Abramey yeletida na7a Isma7eela gidi sunthis. ");
INSERT INTO gofl_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Aggaara Abrames Isma7eela yeliya wode Abrames laythi hospun tammanne usupuna. ");
INSERT INTO gofl_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Abrames laythi uddufun tammanne uddufuna gidiya wode, Goday iyaw qoncidi, “Taani Ubbaa Danda7iya Xoossa, taw kiiteta, ta sinthan polo gida. ");
INSERT INTO gofl_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Ta giddoninne ne giddon de7iya caaquwa ta minthana; ne zeretha ta taybanaw danda7etonada oothana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Abramey ba som7uwara sa7an duge gufannin Xoossay iyako, ");
INSERT INTO gofl_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Heko ta new caaqiya caaqoy haysa; ne daro kawotethatas aawa gidana. ");
INSERT INTO gofl_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Ta nena daro kawotethatas aawa oothana gisho hizape ne sunthay Abrame gidi xeegetenna, shin ne sunthay Abrahaame gidi xeegetana. ");
INSERT INTO gofl_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Taani ne yeletetha darsana, ta nena daro dere kessana, kawoti neepe keyana. ");
INSERT INTO gofl_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Taani newunne neepe guyen ne sheeshas Xoosse gidana mela merina caaquwa ta giddoninne ne giddon, neepe guyera yaa ne sheesha giddon, yeletethafe yeletetha gakanaw ta caaqas. ");
INSERT INTO gofl_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Neeni ha77i bete gidada de7iya Kanaane biitta ubba newunne neepe guyera yaa ne sheeshas merina laata gidana mela new immana; qassi taani enta Xoossa gidana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Qassika Xoossay Abrahaame, “Nena gidiko ta caaquwa naaga; neka neepe guyera yaa ne sheeshati, yeletethafe yeletetha gakanaw naagite. ");
INSERT INTO gofl_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Ta gidduwaninne ne gidduwan, neepe guyera yaa ne sheesha giddon hinte naagana caaqoy haysa; hinte gidduwan de7iya adde ubbay qaxareto. ");
INSERT INTO gofl_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Hinte addetetha koohuwa dookalite; hessi ta giddoninne hinte giddon de7iya caaquwas malla gidana. ");
INSERT INTO gofl_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Hizape yaana yeletethan adde nayti ubbay yeletida hospuntho gallasan qaxareto. Ne son yeletidaysata gidin, woyko allagape miishen shametida aylleta gidin, ne zerethafe gidonayisata dookala. ");
INSERT INTO gofl_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Ne son yeletidaysata gidin woyko miishen shametidaysati qaxaretanaw bessees. Haysan hinte ashuwan de7iya ta caaqoy merina caaqo gidana. ");
INSERT INTO gofl_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Oonika qaxaretona de7iya adde asi ubbay ta caaquwa menthida gisho ba asaape duuxo” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Xoossay Abrahaameko, “Hizape ne mache sunthay Soora gidi xeegetofo; hachife doomidi I sunthay Saara geeteto. ");
INSERT INTO gofl_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Taani iyo anjana; taani iipe new adde na7a immana. Taani iyo anjana gisho iya kawotethatas aayo gidana; deriya kawoti iipe keyana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Abrahaamey ba som7uwara sa7an gufannidi, “Hay asaw, xeetu laytha asi na7a yelanee? Uddufun tammu laythi gidida Saarika na7a yelanee?” yaagidi ba wozanan miicis. ");
INSERT INTO gofl_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Abrahaamey Xoossako, “Isma7eeli tana laattana mela ne iya anjarki” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Shin Xoossay, “Akay, ne machiya Saara new adde na7a yelana, neeni iya Yisaaqa gada sunthana. Taani iyape guyera yaa iya zerethas merina caaqo gidana mela iyara ta caaquwa caaqana. ");
INSERT INTO gofl_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Isma7eelaba ne tana oychida oysha si7as. Taani iyaka anjana. Ta iya ayfisana, iya yeletetha loytha darsana. I tammanne nam7u haareysatas aawa gidana. Taani iya gita kawotethi kessana. ");
INSERT INTO gofl_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Shin ta caaquwa wonto laythi hanoode Saara new yeliya na7a Yisaaqara caaqana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Xoossay Abrahaamera odetidi ongidaape guye iyape shaaketidi pude bis. ");
INSERT INTO gofl_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","He gallas Abrahaamey ba na7a Isma7eela, ba son yeletidaysatanne ba miishen shammidaysata, ba son de7iya adde asa ubba Xoossay iya kiitidaysada qaxaris ");
INSERT INTO gofl_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abrahaamey qaxaretiya wode iyaw laythi uddufun tammanne uddufuna. ");
INSERT INTO gofl_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Iya na7ay Isma7eeli qaxaretiya wode tammanne heedzu laytha na7a. ");
INSERT INTO gofl_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Abrahaameynne iya na7a Isma7eeli nam7atika he gallas qaxaretidosona. ");
INSERT INTO gofl_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Abrahaame son de7iya adde ubbay, iya son yeletidaysatinne miishen shammetidaysati ubbay iyara qaxaretidosona. ");
INSERT INTO gofl_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Abrahaamey Mamire gita mithata garsan ba dunkaaniya pengen seeta gallas uttidashin Goday iyaw qoncis. ");
INSERT INTO gofl_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Abrahaamey dhoqu gidi xeelliya wode iya matan eqida heedzu asata be7is. I enta be7idi entara gahetanaw ba dunkaaniya pengefe dendidi entako woxi bidi enta sinthan ziggis. ");
INSERT INTO gofl_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Yaani simmidi, “Abeeti ta godaw, ta ne sinthan saba demmidaba gidiko tana ne aylliya aggada aadhofa. ");
INSERT INTO gofl_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Guutha haathi yiiko hinte tohoy meecetiko ha mitha kuyan shempi ekite. ");
INSERT INTO gofl_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Hinte taako hinte aylliyako yida gisho xaalidi hinte biya bessi baana mela taani hintew miyaba ehana” yaagis. Entika, “Daro lo77o, ne gidaysada ootha” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Abrahaamey ellesidi Saariko dunkaaniya giddo gelidi, “Ellesada heedzu gabate lo77o dhiille eka munuqada uythu uuka” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Abrahaamey qassi ba meheta giddo woxi bidi lo77o buldubulda mara dooridi ba issi aylliyas immin I ellesidi shukidi giigisis. ");
INSERT INTO gofl_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Yaatidi Abrahaamey meqa maathinne giigisida mara ashuwa imathata sinthe aathis; enti mishin I mitha garsan enta matan eqis. ");
INSERT INTO gofl_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Enti Abrahaameko, “Ne machiya Saara awunee?” yaagidi oychidosona. Ika, “Hini dunkaaniya giddona” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Goday iyako, “Wonto laythi hannoode tuma ta neeko simmana; ne machiya Saara adde na7a yelana” yaagis. Saara he wode iyape guye baggara de7iya dunkaaniya pengen eqada hessa si7awusu. ");
INSERT INTO gofl_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abrahaameynne Saari banta laythan daro cimidosona. Saara na7a yeliya wodepe aadhasu. ");
INSERT INTO gofl_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Hessa gisho, Saara ba wozanan, “Taaninne ta goday nam7ayka cimidaape guye waanidi ha ufaysay hananee?” yaagada miicasu. ");
INSERT INTO gofl_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Goday Abrahaameko, “ ‘Taani cimidaape guye na7a yelane’ gada Saara ayis miicay? ");
INSERT INTO gofl_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Godaas danda7etonabay tuma de7iyee? Ta new gidaysada wonto laythi hannoode ta simmada yaana; he wode Saara adde na7a yelana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Saara yashetida gisho, “Taani miicabike” gada lahasu. Shin I, “Ne tuma miicadasa” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Asati baanaw dendishe Soodome duge xeellidosona. Abrahaamey entana moyzanaw entara keyis. ");
INSERT INTO gofl_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Xoossay iyako, “ta oothanaw haniyaba Abrahaamepe qosaneyee? ");
INSERT INTO gofl_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Abrahaamey tuma gitanne wolqaama kawotethi gidana. Ha biitta kawotethati ubbay iyan anjetana. ");
INSERT INTO gofl_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Xillotethinne suure pirda oothidi Godaa ogiya naagana mela ba naytanne iyape guyera yaa ba soo asaa zorana mela taani iya dooras. Hessika, Xoossay Abrahaames immana gida ufaysa polanaasa” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Goday Abrahaameko, “Soodome bollanne Gamoora bolla waassiya waasoy daris; enta nagarayka daro deexis. ");
INSERT INTO gofl_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Hessa gisho, enta oosoy enta waasuwa meleko be7anaw taani duge wodhana; qassi hessa mela iita gidonaako shaaka erana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Hessafe guye, nam7u asati Soodomeko simmidi bidosona, shin Abrahaamey Godaa sinthan eqidasuwan de7ees. ");
INSERT INTO gofl_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Abrahaamey Godaako shiiqidi, “Tuma neeni xillota iitatara issife dhaysannee? ");
INSERT INTO gofl_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","He katamen ishatamu xillo asati de7iko ne dhaysannee? Yan de7iya ishatamu xillo asata gisho he katama ashshikii? ");
INSERT INTO gofl_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Hessa mela oosoy neepe haako; xilluwa iitaara woli gathada wodheysi, xilluwanne iita issi ayfiyan xeeleysi neepe haako. Ha biitta ubba pirdiya neeni xillo pirdikii?” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Goday, “Ta Soodomen ishatamu xillota demmiyako he bessa ubba enta gisho gada ashshana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Abrahaamey zaaridi, “Taani biittanne bido gidada ta Godaara odetanaw minetakichas; ");
INSERT INTO gofl_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","ishatamu xillotape ichashati pacikochii? Neeni he ichashata gisho gada he katama ubba dhaysaneyee?” yaagis. Goday, “Taani oytamanne ichashu xillota demmiko he katama dhaysike” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Abrahaamey zaaridi, “Yan oytamu xalaali de7ikochii?” yaagis. Ika, “Oytamata gisho gada he katama dhaysike” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Qassika Abrahaamey zaaridi, “Hay ta Godaw, tana hanqetofa, taani gujadaka odetana. Hastamu xalaali de7ikochii?” yaagis. Goday zaaridi, “Taani yan hastamu demmiko dhaysike” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Abrahaamey, “Taani Godaara odetanaw minetakichas; ooni eri yan laatamu xalaali de7ikochi” yaagis. Godayka, “He laatamata gisho gada dhaysike” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Abrahaamey qassika, “Hay ta Godaw, tana hanqetofa ta issi toho odetana, yan tammu xalaala demmikochii?” yaagis. Ika, “Tammata gisho gada taani he katama dhaysike” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Goday Abrahaamera odetidi ongidaape guye bis; Abrahaameyka ba soo simmis. ");
INSERT INTO gofl_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Nam7u kiitanchoti omarsishin Soodome katamaa gakidosona. He wode Looxey he katamaa pengen uttis. Looxey enta be7idi mokanaw dendidi entako bis. Ba som7uwa sa7a gathidi entaw ziggis. ");
INSERT INTO gofl_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","I entako, “Ta godato, hinte aylliya soo gelerketi, hinte tohuwa meecetidi qamma haysan aqite; wonta guura hinte biya bessi biite” yaagis. Enti, “Akay, nuuni ha katamaa dabaaban aqana” yaagidi zaaridosona. ");
INSERT INTO gofl_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Shin I enta minthi woossida gisho bidi iya soo gelidosona. I entaw uythi uukidi aathin midosona. ");
INSERT INTO gofl_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Enti zin7ana hanishin Soodome katama adde asa ubbay na7atethinne dondzi issoyka attona yidi keethaa yuuyi aadhidosona. ");
INSERT INTO gofl_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Enti Looxe xeegidi, “Hachi omarsi ne soo gelida adde asati awun de7oona? Nuuni entara gahetana mela enta nuuko kare kessa” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Yaatin Looxey entara odetanaw kare keyishe pengiya guyera gordidi, ");
INSERT INTO gofl_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","entako, “Ta dabboto, hayyana ha iita oosuwa oothopite. ");
INSERT INTO gofl_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Taw adde eronna nam7u geela7oti de7oosona. Taani enta hintew kare kessiko hinte koydaba oothite. Shin haysati ta imathe gidiya gisho ta kaarape garsan de7oosona; ha asata bolla aybibaaka oothopite” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Asati, “Nu sinthafe gede kicha” yaagidosona. Qassi, “Ha addey baw bete asi shin, nu bolla pirdanaw koyees? Nuuni enta bolla oothanaw koyida iitaape aathidi ne bolla oothana” yaagidosona. Enti Looxe guye sugi yeggidi pengiya menthanaw shiiqidosona. ");
INSERT INTO gofl_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Shin nam7u asati banta kushiya kare yeddidi Looxe soo goochi gelsidi pengiya gordidosona. ");
INSERT INTO gofl_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Hessafe guye, enti keetha pengey de7iyasuwa demmona mela guuthafe gita gakanaw qooqisidosona. ");
INSERT INTO gofl_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","He nam7u asati Looxeko, “New haysan adde na7i woyko macca na7i, ne macca nayta oychiday woyko hara dabboy ha kataman de7ii? De7iko entana haysafe kessa. ");
INSERT INTO gofl_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Ayis giiko, nu ha katama dhaysanaw hanoos. Enta bolla waassiya waasoy Godaa sinthan gita gidiya gisho ha katama dhaysana mela Goday nuna kiittis” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Yaatin Looxey ba macca nayta oychidaysatako bidi, “Goday, ha katama dhaysana haniya gisho ellessidi ha bessaafe keyte” yaagis. Shin iya macca nayta oychidaysati I qelqisees gidi qopidosona. ");
INSERT INTO gofl_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Sa7i wontanaw gontey zo77iya wode he kiitanchoti Looxeko, “Denda, ne machiwnne haysan de7iya ne nam7u nayta ekada ellesada keya. Akay giiko, ha katamay pirdetiya wode neka dhayasa” yaagi dirgisidosona. ");
INSERT INTO gofl_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Shin Looxey keyanaw gam7in, Goday iyaw qadhetida gisho, he kiitanchoti iya kushiya, iya mache kushiyanne nam7u nayta kushiya oykidi he katamaape kessidosona. ");
INSERT INTO gofl_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Kiitanchoti enta kessida mela he kiitanchotape issoy, “Hinte shempuwa ekidi baqatite! Guye xeellofite! Ha heeran awunka eqofite! Hinte dhayona mela zamaako baqatite” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Shin Looxey entako, “Hay ta godato, yaagopite. ");
INSERT INTO gofl_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Taani hinte aylley hinte sinthan saba demmida gisho tana ashshanaw taw daro qadhetideta. Shin taani zumako baqatanaw danda7ike; ha dhayoy gakidi tana dhaysana. ");
INSERT INTO gofl_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Heko, haysan issi katami de7ees; yaa woxidi baanaw matanne guutha katama. Ta shempuwa ashshanaw ta yaa baqato? I daro guutha katama gidennee?” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Kiitanchoy, “Lo77o! Taani ne woosa ekas; he ne odida katamaa dhaysike. ");
INSERT INTO gofl_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","He katamaako ellesada baqata; ne yaa gakanaw ta aybibaaka oothike” yaagis. Hessa gisho, he katamaa sunthay Zo7aare geetetis. ");
INSERT INTO gofl_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Looxey Zo7aare gakiya wode buroo xalqey caares. ");
INSERT INTO gofl_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Goday he wode salope tamanne xuuggiya diine Soodome bollanne Gamoora bolla bukisis. ");
INSERT INTO gofl_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Hessada oothidi Goday he katamata, heera ubba, katamatan de7iyaba ubbaa he biittan de7iya mithaanne maata dhaysis. ");
INSERT INTO gofl_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Shin Looxe machiya guye simma xeellada maxine shuchu gidasu. ");
INSERT INTO gofl_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Wontetha gallas wonta guura Abrahaamey dendidi kase I Godaa sinthan eqida bessaa bis. ");
INSERT INTO gofl_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","I Soodomenne Gamoora, he heeran de7iya biitta ubbaa duge xeelliya wode xuussa tamada cuyay biittafe dendeysa be7is. ");
INSERT INTO gofl_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Xoossay he heeran de7iya katamata dhaysiya wode Abrahaame qopidi, Looxey de7iya katamata dhaysidi, Looxe dhayope ashshis. ");
INSERT INTO gofl_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Looxey Zo7aaren daanaw yashetida gisho, yaape dendidi ba macca nayta nam7atara zuma bolla keyis. Yan gongolo giddon ba nam7u macca naytara de7is. ");
INSERT INTO gofl_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Issi gallas bayra na7iya ba kaalo micheko, “Nu aaway cimis, biitta ubban de7iya wogaatho nuura aqanaw issi addey haysan baawa. ");
INSERT INTO gofl_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Yaaniya gisho, haaya! Nu aawa ushshu ushshidi, iyara aqidi, nu aawape nuus koche ashshos” yaagasu. ");
INSERT INTO gofl_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","He wode qamma banta aawa ushshu ushshidosona. Bayra na7iya gelada iyara aqasu. Iya iyara aqiya wodenne dendiya wode I eribeenna. ");
INSERT INTO gofl_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Wontetha wode bayriya kaaliw, “Zine qamma taani ta aawara aqas; hachi qammaka iya ushshu ushshiko, neka gelada iyara aqa. Yaatidi nuuni nu aawape koche ashshos” yaagasu. ");
INSERT INTO gofl_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","He wode qamma banta aawa ushshu ushshidosona. Kaalo na7iya gelada iyara aqasu. Ha77ika iya iyara aqiya wodenne dendiya wode I eribeenna. ");
INSERT INTO gofl_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Yaatidi Looxe macca nayti nam7ay banta aawape qanthatidosona. ");
INSERT INTO gofl_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Bayriya adde na7a yelasu; iya sunthaa Moo7abe gada sunthasu. I hachi gakanaw Moo7abeta mayza. ");
INSERT INTO gofl_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Kaaliyaka adde na7a yelasu; iya sunthaa Beni7aama gada sunthasu. I hachi gakanaw Amooneta mayza. ");
INSERT INTO gofl_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abrahaamey Mamirepe dendidi Negebe mela biitta heera bidi Qaadesapenne Shura biittatas gidduwan de7is. Geraaranka guutha wode gam7is. ");
INSERT INTO gofl_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Yan de7ishe Abrahaamey ba machiw Saaro, “Iya ta michiw” yaagida gisho, Geraara kawoy Abimelekey kiittidi Saaro baako efis. ");
INSERT INTO gofl_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Shin Xoossay issi qamma amuhon Abimelekeko yidi, “Neeni ehida macaase gaason hayqaasa, iya azinara de7awusu” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Hanoshin, Abimelekey iyo bochibeenna. I, “Godaw, neeni tananne ta derey qohonna de7ishin coo dhaysaneyee? ");
INSERT INTO gofl_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","I, ‘Iya, ta micho’ gibeennee? Qassi iyaka, ‘I, ta isha’ gabikee? Taani ta wozana xillotethaninne ta kushe geeshshatethan haysa oothas” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Xoossay amuhon iyako, “Ee, neeni ne wozana xillotethan oothidaysa ta erayis. Hessa gisho, neeni iyo bochonaadanne ta sinthan nagara oothonnaada nena taani teqas. ");
INSERT INTO gofl_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Ha77i ha addiya machiw zaara. I nabe gidiya gisho, new Xoossa woossiko ne attana. Shin iyo zaarona ixiko, neeninne new de7iyaba ubbay hayqanaysa era” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Abimelekey wontetha gallas daro guura ba moorinnata baako xeegis. He hanidaba ubba entaw odin enti daro babidosona. ");
INSERT INTO gofl_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Yaatin Abimelekey Abrahaame xeegidi, “Neeni aybiba nu bolla oothadii? Ne ta bollanne ta kawotetha bolla haysa mela qoho ehanaw ta new ay iitaba oothadina? Neeni ta bolla oosetanaw bessonnaba oothadasa” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Qassi Abimelekey Abrahaame, “Neeni haysa ayis oothadii?” yaagidi oychis. ");
INSERT INTO gofl_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abrahaamey zaaridi, “ ‘Ha bessan Xoossas yashetiya asi bayna gishonne qassi ta mache gaason enti tana wodhana’ gada qopida gishosa. ");
INSERT INTO gofl_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Hessa bolla iya tumaka ta micho; iya ta aawa na7ape attishin ta aaye na7a giduku, yaaniya gisho, iya ta macho gidasu. ");
INSERT INTO gofl_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Xoossay tana ta aawa keethafe kessida wode taani iiko, ‘Neeni bida biitta ubban ne taw oothana keehatethay haysa; “I ta isha” gada’ oda yaagas” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Hessafe guye, Abimelekey dorse, mehe, macca aylletanne adde aylleta kessidi Abrahaames immis; iya machiw Saaro iyaw zaaris. ");
INSERT INTO gofl_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Abimelekey Abrahaameko, “Heko, ta biittay haysish nena lo77oson de7a” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Saariko, “Taani ne ishas issi mukulu bira santime immayis. Hessi neera de7iya ubba sinthan neeni xillo gideysanne aybi iitabaka oothonaysa eriseysa gido” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Goday Abrahaame mache Saari gaason Abimeleke keetha ubba maynisida gisho Abrahaamey Xoossa woossin, Abimelekey, iya machiyanne iya macca aylleti na7a yelana mela Xoossay enta pathis. ");
INSERT INTO gofl_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Goday ba odidaysada Saaro anjis; ba gelida qaalaka polis. ");
INSERT INTO gofl_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Saara qanthatada Xoossay gida wodey gakin cimida Abrahaames adde na7a yelasu. ");
INSERT INTO gofl_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Abrahaamey Saara yelida na7a suntha Yisaaqa gidi sunthis. ");
INSERT INTO gofl_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Abrahaamey ba na7a Yisaaqa Xoossay kiitidaysada yeletida hospuntho gallasan qaxaris. ");
INSERT INTO gofl_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Iya na7a Yisaaqi yeletiya wode, Abrahaames laythi xeeta. ");
INSERT INTO gofl_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Saara, “Xoossay taw miiche immis; qassi haysa si7iya ubbay taara miicana” yaagasu. ");
INSERT INTO gofl_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Qassika Saara, “Saara Abrahaames na7a yelada dhanthana giday oonee? Gidikoka taani ha7i iyaw I cimida wode na7a yelas” yaagasu. ");
INSERT INTO gofl_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Guutha na7ay diccidi; dhanthi duuthis; Abrahaamey Yisaaqi dhanthi duuthida gallas wolqaama gibira giigisis. ");
INSERT INTO gofl_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Shin Gibxefe yida Aggaara Abrahaames yelida na7ay Yisaaqa toochishin Saara be7asu. ");
INSERT INTO gofl_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Saara Abrahaameko, “Ha aylle na7ay ta na7a Yisaaqara ubbaka laattonna gisho, gadhindiwunne I na7aa kessada goodda” yaagasu. ");
INSERT INTO gofl_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","He oday ba na7a bochiya gisho, Abrahaamey daro metootis. ");
INSERT INTO gofl_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Shin Xoossay Abrahaame, “Ne kochay Yisaaqa baggara xeegetana gisho ne na7aasinne ne ayllees daro metootopa; Saara new odiyaba ubba si7a. ");
INSERT INTO gofl_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Qassi ika ne koche gidiya gisho aylle na7a taani iya gita dere oothana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Wonta guura Abrahaamey dendidi guutha kathinne koddan haathe kunthidi, Aggaaro toossidi, I na7a iyo idinthidi kessi goodis. Iya bada, Barsaabe mela biittan daaburasu. ");
INSERT INTO gofl_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","16","Haathay koddaafe wurida wode iya, “Na7ay hayqishin, uttada be7ike” gada, na7a issi buure garsan yeggada, nam7u xeetu wadha gideysa mela bada utta aggasu. Yan uttada, ba qaala dhoqu oothada yeekasu. ");
INSERT INTO gofl_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Xoossay na7a waasuwa si7is. Xoossa kiitanchoy Aggaaro salope xeegidi, “Aggaare, waanadii? Xoossay na7a yeehuwa si7ida gisho babofa; ");
INSERT INTO gofl_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","danda eqada, na7a denthada ne kushiyan oyka; taani iya gita dere oothana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Xoossay iyo haatha olla bessin, bada koddan haathe kunthada na7aa ushshasu. ");
INSERT INTO gofl_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Na7ay dicciya wode ubban, Xoossay iyara gidis. I mela biittan de7idi, dongen dukiya ase gidis. ");
INSERT INTO gofl_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","I Paarana mela biittan de7ishin, iya aayiya Gibxefe iyaw macho immasu. ");
INSERT INTO gofl_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","He wode, Abimelekey, ba toora mocona Fikoolara Abrahaameko bidi, “Neeni oothiyaba ubban Xoossay neera de7ees. ");
INSERT INTO gofl_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Neeni ta bolla woyko ta nayta bolla woyko ta zeretha bolla cimmada gene oothonna mela, ha7i haysan, Xoossa sinthan taw caaqa. Taani new keehidaysada, neenika taasinne neeni betetethan de7ida ha biittees keeha” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Abrahaamey, “Taani caaqayis” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","He wode, Abrahaamey Abimeleke aylleti ekida haatha ollaba Abimelekes maggannis. ");
INSERT INTO gofl_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Shin Abimelekey, “Hessa ooni oothidaako taani erike. Neenika qassi taw odabaaka; taani hachi gakanaw hessa si7abike” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Hessafe guye, Abrahaamey dorsatanne miizata ehidi, Abimelekes immin, enti nam7ay caaqidosona. ");
INSERT INTO gofl_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Abrahaamey laapun uzzo dorsata wudiyape shaakis; ");
INSERT INTO gofl_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimelekey Abrahaame, “Ha neeni dumma shaaka wothida laapun uzzo dorsata ayis shaakadii?” yaagidi oychis. ");
INSERT INTO gofl_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Abrahaamey, “Taani ha haatha olla bookidaysas marka gidana mela, ha laapun uzzo dorsata taape eka” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Hessan he nam7u asati caaqida gisho, he bessay Barsaabe (Caaqo Haatha Olla woyko Laapun Haatha Olla). ");
INSERT INTO gofl_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Barsaaben caaquwa caaqidaape guye, Abimelekeynne iya toora moconay Fikooli dendidi, Filisxeeme biitta simmidosona. ");
INSERT INTO gofl_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Abrahaamey Barsaaben tamarsiik geetetiya mithi tokis. Hessan Godaa, Merina Xoossa xeegidi iyaw goyinnis. ");
INSERT INTO gofl_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Abrahaamey Filisxeeme biittan daro wode de7is. ");
INSERT INTO gofl_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Hessafe guye, Xoossay Abrahaame paacis; iya, “Abrahaame” yaagidi xeegis. I, “Yee” gidi koyis. ");
INSERT INTO gofl_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Xoossay, “Neeni dosiya ne issi na7a Yisaaqa ekada, Mooriya biitta ba. Yan taani nena bessiya issi dere bolla iya xuussa yarsho oothada taw yarsha” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Wontetha gallas Abrahaamey guura dendidi, ba hariya caanis. Ba aylletape nam7atanne ba na7a Yisaaqa baara ekidi, xuussa yarshuwas gidiya mitha qeri ekidi, Xoossi iya bessiya bessi baanaw dendis. ");
INSERT INTO gofl_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Heedzantho gallas Abrahaamey dhoqu gidi, he bessa haahora be7is. ");
INSERT INTO gofl_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Abrahaamey ba aylleta, “Hinte hariyara haysan de7ishite. Taara ta na7aara ya bidi Xoossas goyinnidi, hinteko simmana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Abrahaamey yarshuwa mitha denthidi, ba na7a Yisaaqa toossis. I baw tamanne mashshe oykis. Enti nam7ay issife bishin; ");
INSERT INTO gofl_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Yisaaqi ba aawa Abrahaame, “Ta aawaw” yaagis. Abrahaamey, “Yee, ta na7aw” yaagis. Yisaaqi, “Tamaynne mithay haysish; shin xuussa yarsho urge dorsay awunee?” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Yaatin Abrahaamey, “Ta na7aw, xuussa yarsho urge dorsa Xoossay baw immana” yaagis. Yaagin enti nam7ay issife bidosona. ");
INSERT INTO gofl_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Enti Xoossay iyaw odida bessa gakida wode, Abrahaamey yan yarsho bessi giigisidi, mithi hiixis. Ba na7a Yisaaqa qachidi, he mitha bolla zin7isis. ");
INSERT INTO gofl_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Abrahaamey ba na7a shukanaw ba kushiya yeddidi mashshe ekis. ");
INSERT INTO gofl_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Shin Godaa Kiitanchoy salope, “Abrahaame, Abrahaame” yaagidi xeegis. I, “Yee” yaagidi koyis. ");
INSERT INTO gofl_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Kiitanchoy, “Na7a bolla ne kushiya wothofa; iya aybibaaka oothofa. Neeni ne issi na7aa tana diggona gisho, neeni Xoossas yayyeysa taani erayis” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Abrahaamey dhoqu gidi xeellis; heko kacey turan qaxetida issi dorsi de7eysa be7is. Abrahaamey bidi he dorsa ekidi, ba na7a bessan xuussa yarsho oothidi yarshis. ");
INSERT INTO gofl_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Hessa gisho, Abrahaamey, “Goday immana” gidi he bessa sunthis. Hachi gakanaw hessi, “Godaa zuma bolla imetana” geetetees. ");
INSERT INTO gofl_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Godaa kiitanchoy saluwape nam7antho Abrahaame xeegidi, ");
INSERT INTO gofl_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“Taani Goday, haysada gada taani ta huuphen new caaqayis; neeni haysa oothida gishonne ne issi na7aa tana diggona gisho, ");
INSERT INTO gofl_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","taani nena tuma anjana. Ne zeretha taani salo xoolinto melanne abba gaxan de7iya shafe mela oothana. Ne zerethati banta morketa katamata laattana. ");
INSERT INTO gofl_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Neeni taw kiitetida gisho, ha sa7a kawotethati ubbay ne zeretha baggara anjetana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Hessafe guye, Abrahaamey ba aylletako guye simmin, enti ubbay issife Barsaabe dendidi bidosona. Abrahaamey Barsaaben de7is. ");
INSERT INTO gofl_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Hessafe guye, Abrahaames, “Milka ne isha Naakoras nayta yelasu; ");
INSERT INTO gofl_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","entika bayray Uxa; Uxa ishati Buza, ");
INSERT INTO gofl_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Araame aawa Qameela, Kesada, Haazo, Pildasha, Yidlaafanne Batu7eela geetetoosona” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Ha hospun nayta Milka Abrahaame isha Naakoras yelasu. Batu7eeli Irbiqa yelis. ");
INSERT INTO gofl_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Re7uma geetetiya iya nam7antho maccasiya qassi Xeba, Gahaama, Tahasanne Maka yelasu. ");
INSERT INTO gofl_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Saara xeetanne laatamanne laapun laythi de7asu. ");
INSERT INTO gofl_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Hessafe guye, iya Kanaane biittan de7iya Qiriyaat-Arba (Kebroona) kataman hayqasu. Abrahaamey Saaris yeekisinne kayotis. ");
INSERT INTO gofl_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Yeeki simmidi, Abrahaamey ba mache aha matape dendidi bidi, Hiteta haysada yaagis; ");
INSERT INTO gofl_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Taani hinte giddon imathe; ta mache aha mooganaw taw hinte gadiyape duufo bessi bayzerketi” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","6","Hiteti Abrahaame, “Godaw, nuuni odeysa si7a; neeni nu giddon wolqaama halaqa; neeni ne mache aha nu duufuwape nena lo77idason mooga; neeni ne mache aha mooganaw ba duufuwa oonika nena diggenna” yaagi zaaridosona. ");
INSERT INTO gofl_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Abrahaamey dendi eqidi, Hiteta sinthan ziggis. ");
INSERT INTO gofl_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","9","I entako, “Hinte tana, ‘Ne mache aha mooga’ giiko, taani giyaba si7ite. Zohaara na7a Efroonas iya gadiya gaxan de7iya Makifeela geetetiya gongoluwa ta duufo oothanaw bayzana mela kumetha gaten nuna zal7iserketi” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Hite addiya Efrooni he wode katama pengen shiiqida ba asa giddon uttis. Hiteti ubbay si7ishin, Abrahaameko yaagis; ");
INSERT INTO gofl_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Hessada gidenna; ta godaw, ta odeysa si7a; taani gadiyaka iya giddon de7iya gongoluwaka new immayis; taani new iya ta asa sinthan immayis; neeni ne mache aha mooga” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Abrahaamey he biitta asa sinthan zaari ziggidi, ");
INSERT INTO gofl_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","asay si7ishin Efroona, “Ta odeysa si7arki! Taani he gadiya gate qanxana; neeni taape ekarki. Hessan taani ta mache aha moogana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","15","Efrooni Abrahaameko zaaridi, “Ta godaw, taani odeysa si7a; gadey oyddu xeetu bira santime kessana; shin hessi ne giddoninne ta giddon aybika gidenna; ne mache aha mooga” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abrahaamey Hiteti si7ishin, Efrooni gida gatiya ekis; he wode miishen oyddu xeetu bira santime Efroonas immis. ");
INSERT INTO gofl_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Yaati simmidi, Mamire katama matan Makifeelan de7iya Efroona gadey, yan de7iya gongoloynne he gadiyan de7iya mitha ubbay, ");
INSERT INTO gofl_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","katama pengen shiiqida Hiteta ubba sinthan wogatho Abrahaame gade gidis. ");
INSERT INTO gofl_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Hessafe guye, Abrahaamey ba machiw Saara Kanaane biittan (Kebroona) geetetiya Mamire katama matan de7iya Makifeela geetetiya gade gongoluwan moogis. ");
INSERT INTO gofl_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Hessa gisho, he gadeynne yan de7iya gongoloy Hiteta sinthan higgiyan Abrahaames duufo gidis. ");
INSERT INTO gofl_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abrahaamey daro cimis. Goday iya ubbabanka anjis. ");
INSERT INTO gofl_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Abrahaamey ba aylliya, ba soo asa ubbaas halaqatiya, ba aqo ubbaa bolla sunthetidaysa haysada yaagis, “Ne kushiyan ta gulbata oyka; ");
INSERT INTO gofl_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","taani enta giddon de7ida Kanaaneta macca naytape ta na7aas macho oychonna mela, Godan, salonne sa7a Xoossa sunthan taani nena caaqisayis; ");
INSERT INTO gofl_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","shin neeni ta yeletida biitta, ta dabbotako bada, ta na7a Yisaaqas macho oycha” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Iya aylley, “He maccasiya taara yaanaw dosona ixiko, ne na7a neeni yida biitta guye efo?” yaagidi oychis. ");
INSERT INTO gofl_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abrahaamey, “Ta na7a ay gaasonka yaa efonnaada nena era! ");
INSERT INTO gofl_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Goday, saluwa Xoossay, tana ta aawa soopenne ta yeletida biittafe kessidaysi taw, ‘Ne zerethas taani ha biitta immana’ yaagidi caaqidaysi, neeni ta na7aas yaape macho demmana mela, I ba kiitanchuwa neepe sinthe kiittana. ");
INSERT INTO gofl_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","He maccasiya neera yaanaw dosona ixiko, ha taani nena caaqisida caaqoy new gome gidenna; shin ta na7a yaa ubbaka efopa” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Aylley ba godaa Abrahaame gulbata oykis; he odaas caaqis. ");
INSERT INTO gofl_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Hessafe guye, aylley ba godaa gimaletape tamma ekidi, ba godaa miishiyapeka muruuta muruuta eki bidi Masephexoome biittan Nakoora katama gakis. ");
INSERT INTO gofl_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Omarsi, maccasi haathe tikanaw yaa wode, katamaape gaxan haatha olla matan ba gimaleta gulbatisis. ");
INSERT INTO gofl_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","I woossishe, “Godaw, ta godaa Abrahaame Xoossaw, hachi taani qopada yidaysa taw giigisa; qassi ta godaa Abrahaames keehaba ootha. ");
INSERT INTO gofl_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Heko, taani ha haatha pultuwa matan eqayis; ha katama macca nayti haatha tikanaw haa yoosona. ");
INSERT INTO gofl_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Taani, ‘Ane otuwa ziqi oothada tana haathe ushsha’ giya wode, iya, ‘Heko uya; qassi ne gimaleta taani ushshana’ giyara, hinna ne aylliya Yisaaqas neeni dooridaro gido; neeni ta godaas keehaba oothidaysa taani hessan erana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Buroo I woosa zaarona de7ishin, Irbiqa haatha oto tookada puttu gasu. Iya Batu7eela na7a, Batu7eeli Milka na7a, Milka Abrahaame isha Nakoora machiw. ");
INSERT INTO gofl_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Irbiqii daro yegelsinne adde eronna geela7o. Pultuwa duge wodhada, ba otuwa kunthada baanaw dendasu. ");
INSERT INTO gofl_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Yaanin, he aylley iiko woxi bidi iyo, “Ne tana guutha haathe ushsharki” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Iya, “Ero ta godaw, uya” yaagasu. Ellesada otuwa ba hashepe wothada, gedi ootha oykada iya ushshasu. ");
INSERT INTO gofl_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Iya ushshidaape guye, “Ne gimaletika alana gakanaw taani entaw haatha duuqana” yaagasu. ");
INSERT INTO gofl_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Attida haatha ellesada gongen tigada, hara haathe duuqanaw olla woxasu; gimaleti ubbay alana gakanaw, haatha ollafe duuqa duuqa ehada gongen tigada ushshasu. ");
INSERT INTO gofl_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","I qopidi yida qofa Goday injeyishe de7iyakonne eranaw addey si77i gidi iyo xeellees. ");
INSERT INTO gofl_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Gimaleti haatha uyi simmin, addey ichashu giraame bagga siidhen aathiya worqa xeetanne tammu giraame gidiya nam7u worqa sagaayota giigisis. ");
INSERT INTO gofl_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Iyo, “Neeni oodde na7ee? Ane taw oda; ne aawa son nuus aqiya bessi daanee?” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Iya, “Taani Batu7eela na7a; Batu7eeli Milka Naakoras yelida na7a. ");
INSERT INTO gofl_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Nu son gidiya kaleynne harqoy de7ees; qassi hinte aqanaw bessi de7ees” yaagasu. ");
INSERT INTO gofl_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Addey gulbatidi Godaa goyinnidi, ");
INSERT INTO gofl_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","haysada yaagis; “Ta godaas keeheysanne ammaneteysa aggiboonna Goday, ta godaa Abrahaame Xoossay galatetto; taani yishin, Goday tana ta godaa dabbota soo kaalethis” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Na7iya woxa bada, ba aaye son de7iya asaas hanidaba odasu. ");
INSERT INTO gofl_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Irbiqas Laaba geetetiya ishay de7ees. Laabi kare keyidi haatha pultuwa matan de7iya addiyako woxis. ");
INSERT INTO gofl_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Siidhe worqanne ba miche kushen de7iya sagaayota be7ida wode Irbiqa addey bana gidoysa odin si7ida wode, keyidi addiyako bis. Addeyka gimaletara pultuwa matan eqidaysa demmis. ");
INSERT INTO gofl_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Iyako, “Goday nena anjidayso, haaya, neeni karen ayis eqadii? Taani new keethenne gimaletaska besse giigisas” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Yaatin addey soo gelis. Laabi gimaleta caana billidi, kalenne dhiille gimaletas immas. Toho meeccanaw iyasinne iyara de7iya asaas haathe ehis. ");
INSERT INTO gofl_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Kathi iya sinthe aadhis. Shin, “Taani tana ehidaba hintew odonna de7ashe kathi miike” yaagis. Laabi, “Yaako oda” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Hessa gisho, I, “Taani Abrahaame aylliya. ");
INSERT INTO gofl_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Goday ta godaa daro anjida gisho I duretis. Dorse, miizi, bira, worqa, adde aylleta, macca aylleta, gimaletanne hareta iyaw immis. ");
INSERT INTO gofl_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Ta godaa machiya Saara ba cimatetha laythan iyaw adde na7a yelasu. Yaatin I baw de7iyaba ubba iyaw immis. ");
INSERT INTO gofl_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Ta goday tana haysada caaqisis, ‘Taani de7iya Kanaane biitta macca naytape ta na7aas macho oychofa. ");
INSERT INTO gofl_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Shin ta aawa asaako, ta dabbotako bada ta na7aas macho oycha’ yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Taani ta godaa, ‘Na7iya taara yaanaw dosona ixikochi?’ yaagada oychas. ");
INSERT INTO gofl_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Ika, taani iya sinthan kiitetida Goday ba kiitanchuwa kiittana; neeni ta na7aas ta aawa asaape, ta kochaafe macho demmana mela, ne beysaka injeyana. ");
INSERT INTO gofl_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Neeni ta kochatako bin, enti new iyo immonna ixiko, he wode new caaqoy gome gidenna” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Taani hachi he pultuwako yaa wode yaagas; ‘Godaw, ta godaa Abrahaame Xoossaw, ne shene gidiko, taani biya allalliya giigisa. ");
INSERT INTO gofl_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Heko, taani ha pultuwa matan eqayis; geela7o issinniya haathe tikanaw yiiko, taani iyo, tana ne otuwape guutha haathe ushsharki’ yaagana. ");
INSERT INTO gofl_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Iya, ‘Ero uya, qassi ne gimaletaska taani haathe duuqana’ giyara, Goday ta godaa na7aas dooridaro gido” yaagas. ");
INSERT INTO gofl_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Taani ta wozanan wooseysa zaarona de7ishin, Irbiqa ba otuwa tookada, puttu gasu; pultuwa duge wodhada haatha duuqasu; taani iyo, ‘Tana haathe ushsharki’ yaagas. ");
INSERT INTO gofl_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","“Yaagin iya ellesada ba hashiyape otuwa wothada, ‘Heko uya; qassi taani ne gimaleta ushshana’ yaagasu. Yaatin taani uyas; qassi ta gimaleta iya ushshasu. ");
INSERT INTO gofl_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","“Taani iyo, ‘Neeni oodde na7ee?’ yaagas. “Iya zaarada, ‘Taani Batu7eela na7aa; Batu7eeli, Milka Naakoras yelida na7a’ yaagasu. Taani worqa I siidhen, sagaayota I kushen aathas. ");
INSERT INTO gofl_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Hessafe guye, taani gulbatada, Godaas goyinnas. Taani Godaa, ta godaa Abrahaame Xoossa, ta godaa isha na7a na7iw iya na7aas ekanaw tana like ogiya kaalethidaysas galatayis. ");
INSERT INTO gofl_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Ha77ika hinte ta godaas keehanabanne ammanetanaba gidiko, taw odite; gidonna ixikoka odite; hessafe guye taani hananaba erana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Laabinne Batu7eeli zaaridi yaagidosona; “Ha oday Godaape yis; nuuni yaa haa gaanaw danda7oko. ");
INSERT INTO gofl_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Irbiqo hanno be7a; ekada ba; Goday gidaysada ne godaa na7aas macho gido” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Abrahaame aylley enti giyaba si7ida wode, sa7an gulbatidi Godaas goyinnis. ");
INSERT INTO gofl_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Aylley bira alleeqo, worqa alleeqo, ma7onne kessidi Irbiqas immis. Qassi al7o miisheta I ishaasinne I aayes immis. ");
INSERT INTO gofl_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Hessafe guye, inne iyara de7eysati midosona uyidosona; yan aqidosona. Enti guura dendin, I, “Tana ta godaako yeddite” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Yaatin I ishaynne I aayiya, “Na7iya issi tammu gallasa mela nuura tako, hessafe guye iya baana” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Shin I, “Goday ta yidaysa injeyin, hinte tana gam7isopite. Taani ta godaako baana mela tana moyzite” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Enti, “Na7iw xeegidi ane iyo oychoos” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Irbiqa xeegidi, “Ha addiyara baanee?” yaagidi oychidosona. Iya, “Ee; taani baana” yaagasu. ");
INSERT INTO gofl_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Yaanin, enti banta michiw Irbiqa, iyo dichidaaro, Abrahaame aylliyanne iya asata moyzidosona. ");
INSERT INTO gofl_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Enti Irbiqa, “Nu miche Irbiqe, mukulupe mukulu gakanaw dara; ne kochay banta morketa katamata laatto” yaagidi anjidosona. ");
INSERT INTO gofl_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Hessafe guye, Irbiqinne I macca aylleti dendidi, gimaleta toggidi, addiyara bidosona. Yaatin aylley Irbiqa ekidi bis. ");
INSERT INTO gofl_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","He wode Yisaaqi, “Tana Be7iya De7o Xoossa Pultuwa” geetetiya pultuwa mata bidi, Negebe mela biittan de7ees. ");
INSERT INTO gofl_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Issi gallas omarsi Yisaaqi ba wozanan qopishe demba keyidi yuuyees; I dhoqu gidi xeelliya wode, gimaleti yeyisata be7is. ");
INSERT INTO gofl_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Irbiqaka dhoqu gada xeelliya wode, Yisaaqa be7asu; gimaletape wodhasu. ");
INSERT INTO gofl_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Abrahaame aylliyako, “Ha nuura gahetanaw dembara yaa addey oonee?” yaagasu. Aylley, “I, ta godaa” yaagis. Iya ba laxana ekada guuluntasu. ");
INSERT INTO gofl_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Qassi aylley ba oothidaba ubba Yisaaqas odis. ");
INSERT INTO gofl_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Yisaaqi Irbiqa ba aaye Saara dunkaaniya giddo efis. Iyo machis; iyaka iyaw macho gidasu. I iyo dosis; ba aaye kayuwa wothis. ");
INSERT INTO gofl_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abrahaamey Keexura geetetiya hara macho ekis. ");
INSERT INTO gofl_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Iya Zimiraana, Yoqsaana, Madaane, Midiyaame, Yasboqanne Siwa iyaw yelasu. ");
INSERT INTO gofl_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yoqsaani Saabanne Dedaana yelis. Dedaani Ashooreta, Lexusetanne Le7umata yelis. ");
INSERT INTO gofl_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Midiyaame nayti Gefera, Efera, Henooha, Abidanne Elda. Haysati ubbay Keexura sheeshata. ");
INSERT INTO gofl_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abrahaamey babaa ubbaa Yisaaqa laatisis. ");
INSERT INTO gofl_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Shin I paxa de7ishe, hara machetape yelida nayta baw de7iyabaape woytis. Ba na7a Yisaaqape enta shaakidi, doloha bagga biitta yeddis. ");
INSERT INTO gofl_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Abrahaamey kumethi issi xeetanne laapun tammanne ichashu laythi de7is. ");
INSERT INTO gofl_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Abrahaamey daro wode de7idi, lo77o cimidi, hayqidi ba mayzatan gahetis. ");
INSERT INTO gofl_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Iya nayti Yisaaqinne Isma7eeli iya Makifeela geetetiya gongolo duufuwan moogidosona; he gongoloy Mamire matan, Hite addiya Xohaara na7a Efroona gadiyan de7ees. ");
INSERT INTO gofl_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Hessi Abrahaamey Hitetape shammida gadiya. Abrahaamey ba machiya Saara moogetida duufuwan moogetis. ");
INSERT INTO gofl_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Abrahaamey hayqidaape guye, Xoossay iya na7a Yisaaqa anjis. He wode Yisaaqi, Beer-lay-ro7i (Tana Be7iya De7o Xoossa Pulto) geetetiya pultuwa matan de7ees. ");
INSERT INTO gofl_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Saara aylliya, Gibxefe yida Aggaara, Abrahaames yelida na7a Isma7eela yeletethay haysafe kaallidi xaafetidaysa. ");
INSERT INTO gofl_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Isma7eela nayti banta sunthaninne banta yeleta maaran haysata; entika, Nabayoota, Qedaare, Adbeela, Mibsaama, ");
INSERT INTO gofl_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misima, Duma, Masa, ");
INSERT INTO gofl_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Kudane, Teema, Ixura, Nafisanne Qedima. ");
INSERT INTO gofl_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Isma7eela nayti haysata; enta sunthay enta moothaninne de7iya bessan haysa. Enti banta yaranka tammanne nam7u halaqata. ");
INSERT INTO gofl_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Isma7eeli kumethi xeetanne hastamanne laapun laythi de7idi, hayqidi ba mayzatan gahetis. ");
INSERT INTO gofl_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Isma7eela kocheti Gibxefe doloha baggan de7iya Hawilapenne Suurape gidduwan, Asoore efiya ogiya matan de7idosona. Enti banta ishata ubbara morketethan de7idosona. ");
INSERT INTO gofl_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Abrahaame na7a Yisaaqa yeletethay haysafe kaallidi xaafetidaysa; Abrahaamey Yisaaqa yelis. ");
INSERT INTO gofl_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Yisaaqas laythi oytama gidin, Irbiqa ekis; iya Masephexoomen de7iya Araame addiya Batu7eela na7iwunne Laaba michiw. ");
INSERT INTO gofl_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Yisaaqi ba machiya maynthi gidida gisho, iw Godaa woossis; Goday iya woosa si7is. Yaatin iya machiya Irbiqa qanthatasu. ");
INSERT INTO gofl_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Shin I ulon de7iya nayti mente gidi uttidi, issoy issuwara sugetidosona; iya, “haysi taw ayis hanii?” yaagasu. Hessa gisho, Godaa oychanaw basu. ");
INSERT INTO gofl_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Goday iyo, “Ne ulon nam7u kawotethi de7ees; qassi ne giddon de7iya nam7u dere asati issoy issuwafe shaaketana; issi dere asati hankotape minnana; qassi bayray kaaluwas kiitetana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Iwu yelo wodey gakin, I uluwan mente adde nayti de7oosona. ");
INSERT INTO gofl_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Koyro yeletidaysi aarise; iya bolla ubba ikisey ma7is; Hessa gisho, enti iya Eesawe (Iksaama) gidi sunthidosona. ");
INSERT INTO gofl_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Hessafe guye, iya ishay yeletis. I ba kushiyan Eesawe gindiya oykidi keyis, Hessa gisho, iya Yayqooba (Ginde Oykeysa) gidi sunthidosona. Irbiqa enta yelida wode Yisaaqas usupun tammu laythi gidis. ");
INSERT INTO gofl_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Nayti diccidosona; Eesawey shanka hiilla eriya bazzo ase gidis. Shin Yayqoobi dunkaanen de7iya wopa ase gidis. ");
INSERT INTO gofl_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Yisaaqi Eesawe dosis; ayis giiko, I shankateysafe maanaw dosees; shin Irbiqa Yayqooba dosawusu. ");
INSERT INTO gofl_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Issi wode Yayqoobi woxe kathishin, Eesawey koshatidi bazzofe yis. ");
INSERT INTO gofl_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Eesawey Yayqooba, “Tana ha zo7o woxiyape muza, tana koshi wodhees” yaagis. (Hessa gisho, qassi iya sunthay Edoome (Zo7o) geetetis). ");
INSERT INTO gofl_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Yayqoobi iya, “Koyro taw ne bayratetha bayza” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Yaatin Eesawey, “Heko, taani hayqana hanayis, ha bayratethay tana ay maaddii?” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Yayqoobi zaaridi, “Ane taw koyro caaqa” yaagis. I caaqis, ba bayratetha Yayqoobas bayzis. ");
INSERT INTO gofl_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Yayqoobi Eesawes uythinne misire woxe immin mis uyis. Hessafe guye dendidi bis. Eesawey ba bayratetha haysada kadhis. ");
INSERT INTO gofl_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","He biittan kase Abrahaame wode keyida koshaape hara koshi keyis. Yaanin, Yisaaqi Filisxeeme kawa Abimelekeko Geraara bis. ");
INSERT INTO gofl_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Goday Yisaaqas qoncidi “Gibxe biitta duge boopa, taani new odida biittan de7a. ");
INSERT INTO gofl_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Ha biittan guutha wodiya gam7aasha, taani neera gidana, nena anjana. Ha biitta ubba taani newunne ne sheeshas immana. Taani ne aawa Abrahaames caaqida caaquwa polana. ");
INSERT INTO gofl_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Ne sheesha salo xoollintoda darsana, ha biitta ubba taani entaw immana. Sa7a kawotethati ubbay ne sheesha baggara anjetana. ");
INSERT INTO gofl_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Hessika, Abrahaamey ta qaala si7idi, ta awaajota, ta kiitatanne ta higgeta naagida gishosa” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Hessa gisho, Yisaaqi Geraaran de7is. ");
INSERT INTO gofl_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","He biitta asay Irbiqaba denthidi, “Hanna new aybee?” gidi Yisaaqa oychidosona. I, “Hanna taw micho” yaagis. Hessa I giday, Irbiqa daro mala lo77o gidiya gisho, “Iya ta macho giiko, ha asay I gaason tana wodhana” yaagi qopidi babis. ");
INSERT INTO gofl_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Yisaaqi yan daro wode de7idaape guye, Filisxeeme kawoy Abimelekey maskootera duge xeelliyade, Yisaaqi ba mache Irbiqara kaa7ishin be7is. ");
INSERT INTO gofl_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Hessa gisho, Abimelekey Yisaaqa xeegisidi, “Heko, iya ne macho; neeni ayis iya ta micho gadii?” gidi oychis. Yisaaqi, “Iya ta macho giiko, asay tana I gaason wodhana gada gas” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Abimelekey, “Haysi neeni nu bolla oothidabay aybee? Ta asaape issi asi ne machera aqis shin atis, neeni nu bolla gome ehadasa” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Hessa gisho, Abimelekey ba asa, “Ha ura woyko iya machiw bochiya oonika tuma hayqana” yaagidi kiittis. ");
INSERT INTO gofl_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Yisaaqi he biittan kathi zeridi, Goday iya anjida gisho he laythan xeetu kushe ekis. ");
INSERT INTO gofl_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","I duretethan eretana gakanaw daro duretishe bis. ");
INSERT INTO gofl_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Yisaaqas dorsa wudey, miiza wudeynne aylleti aadhidi darida gisho, Filisxeeme asati iya qanaatidosona. ");
INSERT INTO gofl_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Hessa gisho, iya aawa Abrahaame wode iya aawa aylleti bookida haatha olla ubba Filisxeemeti biitta ushshidi kunthidosona. ");
INSERT INTO gofl_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","He wode Abimelekey Yisaaqako, “Neeni nuupe aadhada minnida gisho nu matape ba” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Yisaaqi hessafe dendidi, Geraara zangaara bidi dunkaane tokidi yan de7is. ");
INSERT INTO gofl_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Yisaaqi ba aawa Abrahaame wode booketida haatha ollata, Abrahaamey hayqidaape guye, Filisxeemeti kunthidaysata zaari booki kessidi, iya aaway sunthida sunthan xeegis. ");
INSERT INTO gofl_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Yisaaqa aylleti he zangaaran haatha olla bookidi yan lo77o pulto haatha demmidosona. ");
INSERT INTO gofl_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Shin Geraara henthanchoti Yisaaqa henthanchotara, “Haathay nubaa” yaagidi ooyetidosona. Enti palametida gisho, Yisaaqi he haatha olla “Eseeqa” gidi sunthis. ");
INSERT INTO gofl_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Hessafe guye, enti hara haatha olla bookidosona. Shin enti he haatha olla geedonka ooyetidosona. Hessa gisho, Yisaaqi he haatha olla “Siixina” gidi sunthis. ");
INSERT INTO gofl_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Hessafe guuthi sinthe shiiqidi hara haatha olla bookisis. Iya gaason oonika ooyetiboonna gisho, “Xoossay ha7i nuus dalgisis nuuni ha biittan darana” gidi he bessa Rehoboota gidi sunthis. ");
INSERT INTO gofl_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Hessafe dendidi pude Barsaabe keyis. ");
INSERT INTO gofl_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","He bida gallas qamma Goday iyaw qoncidi, “Taani ne aawa Abrahaame Xoossa, taani neera de7iya gisho, babofa. Ta aylliya Abrahaame gisho taani nena anjana, ne sheeshaka darsana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Yisaaqi yan yarsho bessi giigisidi Godaa suntha xeegis. Yan I ba dunkaaniya tokis, iya aylleti yan haatha olla bookidosona. ");
INSERT INTO gofl_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Hessafe guye, Abimelekey bana zoriya Ahuzanne toora mocona Fikoola ekidi, Geraarape Yisaaqako yis. ");
INSERT INTO gofl_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Yisaaqi entako, “Hinte kase tana ixidi, hinte biittafe kessi yeddibeeketii? Ha7i taako ay ekanaw yidetii?” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Enti, “Goday neera de7eysa nuuni geeshshi erida. Hessa gisho, sarotetha caaqoy nu giddoninne ne giddon daanaw koshshees. ");
INSERT INTO gofl_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Nuuni nena bochibooko, new keehatetha xalaala oothidi, nena sarotethan moyzidi yeddida. Hessadaka neeni nu bolla iitaba oothonna mela, ane neera caaqoos. Tumaka ha7i nena Goday anjis” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","He wode Yisaaqi entaw gibira giigisin midosona, uyidosona. ");
INSERT INTO gofl_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Wontetha gallas wonta guura dendidi enti issoy issuwara caaqidosona. Yisaaqi enta moyzin, enti saro shaaketidi bidosona. ");
INSERT INTO gofl_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","He gallas Yisaaqa aylleti yidi, “Nuuni haathe demmida” yaagidi banta bookida haatha ollaba iyaw odidosona. ");
INSERT INTO gofl_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","I he haatha olla Saabe (Caaqo) gidi sunthis. Hessa gisho, he katama sunthay hachi gakanaw Barsaabe (Caaqo haatha olla) geetetees. ");
INSERT INTO gofl_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Eesawes laythi oytama gidida wode Hite addiya Bi7eera na7iw Yooditonne Hite addiya Eloona na7iw Basemaato machis. ");
INSERT INTO gofl_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Enti Yisaaqanne Irbiqa azzanthishe de7idosona. ");
INSERT INTO gofl_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Yisaaqi cimin iya ayfey xeelo ixida wode ba bayra na7a Eesawe xeegidi, “Ta na7aw” yaagis. Ika, “Yee” gidi koyis. ");
INSERT INTO gofl_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Yisaaqi, “Heko, ha7i taani cimas, taani awude hayqaneko erike. ");
INSERT INTO gofl_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Yaaniya gisho, ha7i ne shanka dongiya ekada bazzo bada do7a shankatada asho ekada ya. ");
INSERT INTO gofl_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Mal7o kathi ta doseysatho ootha kathada taw eha. Taani hayqanaape sinthe ma simmada nena anjana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Yisaaqi ba na7a Eesawes odiya wode Irbiqa si7awusu. Eesawey do7a shankatidi ehanaw bazzo bidaape guye, ");
INSERT INTO gofl_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Irbiqa ba na7a Yayqooba, “Ne aaway ne isha Eesawe, ");
INSERT INTO gofl_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Do7a shankata ehada taw mal7o kathi ta maanaw katha. Taani hayqanaape sinthe ma simmada Godaa sinthan nena anjana’ yaagishin taani si7as. ");
INSERT INTO gofl_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Ta na7aw, ha7i taani new odeysa loytha si7a. ");
INSERT INTO gofl_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Wudiya giddo bada nam7u modho deesha marata taw ekada ya. Taani ne aawas mal7o kathi I doseysada oothada kathana. ");
INSERT INTO gofl_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Ne aaway hayqanaape sinthe midi nena anjana mela iyaw aatha” yaagasu. ");
INSERT INTO gofl_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Shin Yayqoobi ba aayiw, “Ta isha Eesawe bolla ikisey de7ees shin ta bollay liiqo. ");
INSERT INTO gofl_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Ta aaway tana oyki be7idi taani iya cimmidaba daaniko, taani anjuwa gisho baadethi ta bolla ehanaysa erikii?” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Iya aayiya, “Ta na7aw, he baadethay tana gako. Taani new odeysa ootha, bada deesha marata taw ekada ya” yaagasu. ");
INSERT INTO gofl_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Ehidi ba aayes immin iya aayiya mal7o kathi iya aaway doseysada oothada kathasu. ");
INSERT INTO gofl_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Hessafe guye, Irbiqa bayra na7a Eesawe ma7o lo77uwa ehada Yayqooba mayzasu. ");
INSERT INTO gofl_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Qassi he deeshata itiya iya kushiyanne iya liiqo qoodhiya mayzasu. ");
INSERT INTO gofl_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Ba kathida mal7o kathaanne uythaa ba na7a Yayqoobas immasu. ");
INSERT INTO gofl_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Yaatin, I ba aawako gelidi, “Ta aawaw” yaagis. Ika, “Yee, ta na7aw, neeni oonee?” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yayqoobi ba aawa, “Taani ne bayra na7a Eesawe. Neeni tana kiitidaysada taani oothas; ha77i denda uttada, taani shankata ehidaysafe mada, tana anja” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Yisaaqi ba na7a, “Ta na7aw, waata ellesada demmadii?” yaagidi oychis. Yayqoobi, “Goday, ne Xoossay taw giigisis” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Yisaaqi Yayqooba, “Ta na7aw, neeni tuma ta na7a Eesaweko ta nena oyka be7ana ane ha shiiqa” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Yayqoobi ba aawako shiiqin oyki be7idi, “Ne qaalay Yayqooba qaala shin kushey Eesawe kushiya daanees” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Iya kushey iya isha Eesawe kushiyada ikisera de7iya gisho, shaakidi eriboona iya anjis. ");
INSERT INTO gofl_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Iya, “Tuma neeni ta na7a Eesawee?” yaagidi zaari oychis. Ika, “Ee, tana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Yaatin I, “Ta na7aw, taani ne shankata ehidabaape mada nena anjana mela ane ha aatha” yaagis. Yayqoobi aathin mis, qassi iyaw woyne ehin uyis. ");
INSERT INTO gofl_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Hessafe guye, iya aawa Yisaaqi, “Ta na7aw, ha shiiqada tana yeera” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Yayqoobi shiiqidi iya yeeris. Yisaaqi iya ma77uwa singi si7idi, “Ta na7a peenoy Goday anjida goshshada sawees. ");
INSERT INTO gofl_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Xoossay salo akanne sa7a shica, kathinne woyne darsidi new immo. ");
INSERT INTO gofl_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Kawotethati new haareto, asay new gulbato. Neeni ne ishatas godaa gida, ne aaye sheeshati new gulbato. Nena baaddeysati baadetidaba gido, nena anjeysati anjetidaba gido” yaagidi anjis. ");
INSERT INTO gofl_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Yisaaqi Yayqooba anjidi ongidaape guye, Yayqoobi ba aawa sinthafe buroo keyiya wode Eesawey shankafe puttu gis. ");
INSERT INTO gofl_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Ika qassi mal7o kathi kathidi ba aawas aathidi, “Ta aawaw, danda uttada ta shankatidabaape ma, yaatada tana anja” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Yisaaqi, “Ne oonee?” yaagidi oychis. Ika, “Taani ne bayra na7a Eesawe” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Yisaaqi dagammidi kokorishe, “Yaatin do7a shankatidaysafe taw aathiday oonee? Taani ha7i neeni yaana sinthan mada, iya anjas. Ika tuma anjetidaysa gidana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Eesawey ba aawa qaala si7ida wode ba qaala dhoqu oothidi, daro iita yeeho yeekishe, “Ta aawaw, tanaka anja” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Shin I, “Ne ishay cimmidi ne anjuwa eki diggis” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Eesawey, “I eridi Yayqooba (Cimmeysa) gidi sunthetis. I tana cimmishin haysi nam7antho, kase ta bayratetha ekis, ha7i qassi ta anjuwa ekis” yaagis. Yaatin, “Neeni taw anjuwafe aykoka ashshabikii?” yaagidi oychis. ");
INSERT INTO gofl_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Yisaaqi Eesawe, “Taani iya new godaa oothas. Iya ishata ubbataka iyaw aylle oothas. Qassi taani kathaninne woynen iya minthas. Yaatin, ta na7aw, new ta ay ootho?” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Eesawey ba aawa, “Ta aawaw, new issi anjo xalaali de7ii? Ta aawaw, tanaka qassi anja” yaagis. Hessafe guye, Eesawey ba qaala dhoqu oothidi yeekis. ");
INSERT INTO gofl_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Iya aawa Yisaaqi zaaridi, “Ne de7iya bessay ha sa7a duretethafe haaho, salo akika new wodhenna. ");
INSERT INTO gofl_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Neeni ne mashshan aqana, ne ishaas haaretana. Shin neeni iyara eqetiya wode iya qambara ne gannaafe holana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Yayqooba iya aaway anjida gisho, Eesawey ba ulon iya morkis. I ba wozanan, “Ta aaway hayqanaw matis. I hayqida mela ta isha Yayqooba wodhana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Shin Irbiqa he ba bayra na7a Eesawe qaala si7ida gisho, ba kaalo na7a Yayqooba xeegisa ehada, “Ne isha Eesawey nena wodhidi haluwa kessanaw halchees. ");
INSERT INTO gofl_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Hayyana ta na7aw, taani new odeysa ootha. Dendada Kaaranen de7iya ta isha Laabako baqata. ");
INSERT INTO gofl_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Ne isha hanqoy irxana gakanaw guutha wode iyara de7aasha. ");
INSERT INTO gofl_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Ne ishaa yiloy wodhiya wodenne neeni iya bolla oothidaba I dogiya wode taani kiittada nena ehana. Taani issi gallas hinte nam7aafeka mela atanaw koyke” yaagasu. ");
INSERT INTO gofl_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Hessafe guye, Irbiqa Yisaaqako, “Eesawey ekida Hiteta macca nayta gaason taani ta de7uwa shaatetas. Qassi Yayqoobika haysatho Hiteta macca naytape macho ekiko, taw hayqoy lo77o” yaagasu. ");
INSERT INTO gofl_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Hessa gisho, Yisaaqi Yayqooba xeegidi, “Kanaane biitta macca naytape macho ekofa. ");
INSERT INTO gofl_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Dendada ne aaye aawa Batu7eelako Masephexoome biitta bada yaape ne aaye isha Laaba macca naytape macho eka. ");
INSERT INTO gofl_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Ubbaa Danda7iya Xoossay nena anjo, I new nayta immo, daro dere gidana gakanaw I nena darso. ");
INSERT INTO gofl_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Neeni ha7i betetethan uttida ha biitta nebaa oothana mela newunne ne sheeshas Xoossay Abrahaame anjuwa immo” yaagi anjidi kiittis. ");
INSERT INTO gofl_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Yaagidi Yisaaqi Yayqooba yeddis. Yayqoobi Masephexoome biitta Laabako bis. Laabi Yayqoobanne Eesawe aaye Irbiqa ishanne Araame addiya Batu7eela na7a. ");
INSERT INTO gofl_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Yisaaqi Yayqooba anjidi Masephexoome biittafe macho ekana mela iya yedidaysa, I Yayqooba anjida wode, “Kanaane maccas ekofa” gidi kiittidaysanne, ");
INSERT INTO gofl_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Yayqoobi ba aawasinne ba aayes kiitetidi Masephexoome biitta bidaysa, Eesawey eris. ");
INSERT INTO gofl_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Eesawey hessan Kanaane biitta maccas ba aawa Yisaaqi ay mela ixiyako eris. ");
INSERT INTO gofl_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Hessa gisho, Eesawey Abrahaame na7a Isma7eelako bidi, iya na7iw Mahlaato, Nebayoota michiw, ba macheta bolla gujidi ekis. ");
INSERT INTO gofl_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yayqoobi Barsaabepe Kaarane baanaw keyis. ");
INSERT INTO gofl_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","I, issi bessi gakiya wode awi wullin, qamma yan aqis. He bessan de7iya shuchatape issuwa borkotidi he bessan dhiskis. ");
INSERT INTO gofl_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","I amuho amuhidi kodo issoy sa7an eqin xeeray salo gakidaysanne, Xoossa kiitanchoti iya bollara pude keyeysatanne duge wodheyisata be7is. ");
INSERT INTO gofl_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","He koduwas xeeran Goday eqidi, “Taani Godaa, ne aawa Abrahaame Xoossa, Yisaaqa Xoossa, ha neeni zin7ida biitta newunne ne sheeshas immana. ");
INSERT INTO gofl_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Ne sheesha sa7a shafeda darsana. Neeni doloha bagga, wuloha bagga, pudeha bagganne dugeha bagga dalgana. Biitta bolla de7iya asa ubbay ne baggaranne ne sheesha baggara anjetana. ");
INSERT INTO gofl_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Taani neera de7ayis. Neeni biya bessa ubban taani nena naagana. Taani nena ha biitta guye zaarada ehana. Taani new oothana gidaysa polana, nena aggike” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Yayqoobi dhiskofe barkidi, “Ta erabikefe attishin, tuma Goday ha bessan de7ees” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","I babidi, “Ha bessay waani yashshi! Ha bessay Xoossa keethife attishin, haraso gidenna. Haysi salo penge” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Wontetha gallas wonta guura Yayqoobi dendidi, Xoossas dummayanaw ba borkotida shucha ekidi tuussatho essidi iya bolla zayte tigis. ");
INSERT INTO gofl_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Yayqoobi he bessa Beetele (Xoossa keethi) gidi xeegis. Shin he katamay hessafe kase Looza geetetees. ");
INSERT INTO gofl_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Yayqoobi, “Ta biya ogiyan ne tana naagiko, taw kathinne ma7o immiko, ");
INSERT INTO gofl_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ne tana ta aawa soo saro zaariko, ne ta Xoossa gidana. ");
INSERT INTO gofl_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Taani dummayanaw tuussatho essida ha shuchay Xoossa keetha gidana. Tuma neeni taw immiyaba ubbaafe tammaafe issuwa new immana” yaagidi Xoossas caaqis. ");
INSERT INTO gofl_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Hessafe guye, Yayqoobi dendidi, bidi doloha bagga asa biitta gakis. ");
INSERT INTO gofl_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Yanka demba bessan haatha olla demmis. Heedzu dorsa wudeti he haatha olla matan de7oosona. Wude ubbay haathe uyey he ollafe. He haatha olla doona gordiya shuchay gita. ");
INSERT INTO gofl_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Dorsa wude ubbay yaa shiiqiko, wudiya heemmeysati haatha olla doonape he shucha gondorsidi wudiya haathe ushshoosona. Ushshi simmidi he shucha olla doonan zaari wothoosona. ");
INSERT INTO gofl_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yayqoobi entako, “Hinte awupe yidetii?” yaagidi oychis. Entika, “Nuuni Kaaranepe yida” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","I, “Nakoora na7a na7aa Laaba ereetii?” yaagidi oychis. “Ee, iya eroos” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Yayqoobi enta, “I lo77o de7ii?” yaagidi oychis. “Ee, lo77o, iya na7iw Raheelo dorsata laaggada yaaro hini be7a” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Yayqoobi entako, “Heko, ha7i awi dhoqan de7ees. Wude mehey soo simmiya wodey buroo gakibeenna, dorsa ushshi efidi heemmite” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Shin enti, “Wude ubbay shiiqin shucha haatha olla doonape gondorsana gakanaw nu ushshanaw danda7oko. Hessafe guye, shucha gondorsidi dorsata ushshana” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","I buroo odishin, Laaba na7iya Raheela dorsata heemmiya gisho, ba aawa dorsata laagga ekada gakasu. ");
INSERT INTO gofl_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Yayqoobi ba aaye isha Laaba na7iw Raheelo Laaba dorsata laaggada yaaro be7ida wode bidi olla doonape shucha gondorsidi dorsata haathe ushshis. ");
INSERT INTO gofl_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Yayqoobi Raheelo yeeridi, ufaysan ba qaala dhoqu oothidi yeekis. ");
INSERT INTO gofl_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Yayqoobi, “Taani ne aawa miche Irbiqa na7a” yaagidi iw odis. Hessa gisho, iya woxa bada ba aawas odasu. ");
INSERT INTO gofl_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Laabi ba miche na7a Yayqooba yuussaa si7ida mela mokanaw woxidi bis. Iya idimi yeeridi ba soo efis. Yan Yayqoobi hanidaba ubba Laabas odis. ");
INSERT INTO gofl_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Laabi iya, “Neeni tuma ta ashonne ta suuthi” yaagis. Yayqoobi iyara issi ageena kumethi uttis. ");
INSERT INTO gofl_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Hessafe guye, Laabi Yayqooba, “Neeni taw dabbo gidida gisho, taw mela coo oothaneyee? Ane ta new ay qanxanaw koshshiyako taw oda” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Laabas nam7u macca nayti de7oosona. Bayre sunthay Liya, kaaliya qassi Raheelo geetetawusu. ");
INSERT INTO gofl_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Liya ayfera cuuca, shin Raheela yegelsinne mala lo77o. ");
INSERT INTO gofl_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yayqoobi Raheelo dosidi, “Taani ne kaalo na7e Raheeli gisho new laapun laythi oothana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laabi, “Iyo hara asas immanaape new imoy lo77o, ne taara haysan de7a” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Hessa gisho, Yayqoobi Raheelo ekanaw laapun laythi oothis. Shin I iyo daro dosiya gisho, iyaw guutha gallas daanis. ");
INSERT INTO gofl_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Hessafe guye, Yayqoobi, “Ta machiw taw imma, ta laythay wuris taani iyo ekanaw koyayis” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Hessa gisho, Laabi asa ubba xeegidi yaagano kessis. ");
INSERT INTO gofl_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Shin sa7i qammin Laabi ba na7iw Liya efidi Yayqoobas immis. Yayqoobi iyo ekis. ");
INSERT INTO gofl_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Qassi Laabi ba aylliw Zalafa ba na7e Liyas aylle oothidi immis. ");
INSERT INTO gofl_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Sa7ay wontin I xeelliya wode, heko, Liya. Yayqoobi Laaba, “Haysi neeni ta bolla oothidaysi aybee? Taani new oothiday Raheeli gishosa gidenneyee? Tana ayis cimmadi” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laabi iyako, “Nu biittan bayriya de7ishin kaaliw azinas immeysi woga gidenna. ");
INSERT INTO gofl_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Mishiratethan iira saaminta ongiko, qassi kaaliwka taani new immana. Hessafe guye, hara laapun laythi taw oothaasa” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yayqoobi oda ma77idi saaminta iira ongis. Hessafe guye, Laabi ba na7iw Raheelo iyaw immis. ");
INSERT INTO gofl_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Qassi Laabi ba aylliw Baalo ba na7e Raheelis aylle oothidi immis. ");
INSERT INTO gofl_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Yayqoobi Raheeloka ekis. Raheelo Liyape aathidi dosis. Hara laapun laythi Laabas oothis. ");
INSERT INTO gofl_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Goday Liya Raheelitho dosetabonaro be7idi, iw yelo uluwa dooyis. Shin Raheela na7a yelonna gam7asu. ");
INSERT INTO gofl_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Liya qanthatada adde na7a yelasu. Iya, “Goday ta metuwa be7is, ha7i tana ta azinay dosana” gada he na7a Robeela gada sunthasu. ");
INSERT INTO gofl_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Iya nam7antho qanthatada adde na7a yelasu. Iya, “Goday taani dosetabonaysa be7ida gisho, taw haysaka gujis” gada Simoona gada sunthasu. ");
INSERT INTO gofl_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Iya heedzantho qanthatada adde na7a yelasu. Iya, “Taani iyaw heedzu adde nayta yelida gisho, ta azinay ha7i taara siiqon waaxetana” gada iya Leewe gada sunthasu. ");
INSERT INTO gofl_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Iya hara qanthatada adde na7a yelasu. Iya, “Ha7i taani Godaa galatana” gada iya suntha Yihuda gada unthasu. Hessafe guye, yelo eqasu. ");
INSERT INTO gofl_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Raheela Yayqoobas nayta yelonnaysa be7ada ba michiw qanaatasu. Hessa gisho, Yayqooba, “Taw na7a imma, ixiko taani hayqana” yaagasu. ");
INSERT INTO gofl_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Yayqoobi Raheelo hanqetidi, “Tana new yelo immanaw woyko digganaw Xoosse gadiyee?” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Iya, “Ta gadhindiw Baalo hinno be7a. Iya ta gisho yelana mela neeni iira aqa, yaaniko, taani I baggara na7a demmana” yaagasu. ");
INSERT INTO gofl_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Ba gadhindiw Baalo macho oothidi ekana mela iyaw immasu. ");
INSERT INTO gofl_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Baala qanthatada adde na7a Yayqoobas yelasu. ");
INSERT INTO gofl_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Yaatin Raheela, “Xoossay taw pirdis, ta woosaka si7idi taw adde na7a immis” yaagada he na7a Daane gada sunthasu. ");
INSERT INTO gofl_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Raheeli gadhindiya Baala qanthatada Yayqoobas nam7antho adde na7a yelasu. ");
INSERT INTO gofl_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Raheela, “Taani ta michera wolqaama baaxe baaxetada xoonas” yaagada he na7a Niftaaleme gada sunthasu. ");
INSERT INTO gofl_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Liya yelo eqidaysa be7ada, ba gadhindiya Zalafa Yayqoobas macho oothada immasu. ");
INSERT INTO gofl_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Liya gadhindiya Zalafa adde na7a Yayqoobas yelasu. ");
INSERT INTO gofl_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Liya, “La haysi aybi lo77o qaade!” yaagada, he na7a Gaade sunthasu. ");
INSERT INTO gofl_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Liya gadhindiya Zalafa Yayqoobas nam7antho adde na7a yelasu. ");
INSERT INTO gofl_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Liya, “Tana daro ufaysees; maccasi ubbay tana ufaytiyaro gaana” gada he na7a Aseera gada sunthasu. ");
INSERT INTO gofl_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Giste cakiya ageenan Robeeli gade bidi inkoya mitha ayfe demmidi ba aaye Liyas ekidi yis. Raheela Liyako, “Ne na7ay ehida enkoya mitha ayfiyape taw imma” yaagasu. ");
INSERT INTO gofl_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Shin Liya, “Ta azinaa neeni wolqan ekidaysi gidonna ixin ha7i qassi ta na7a inkoya mitha ayfiya ekanee?” yaagasu. Raheela, “Ne na7a inkoya ayfiya taw immiko, Yayqoobi hachi qamma neera aqo” yaagasu. ");
INSERT INTO gofl_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","He gallas omarsi Yayqoobi bazzofe yaa wode Liya iya mokanaw keyada, “Neeni taara aqanaw koshshees; taani ta na7a inkoya ayfiyan nena shammas” yaagasu. Hessa gisho, I he qamma iira aqis. ");
INSERT INTO gofl_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Xoossay Liya woosa si7is. Iya qanthatada ichashantho adde na7a Yayqoobas yelasu. ");
INSERT INTO gofl_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Liya, “Taani ta aylliw ta azinas immida gisho, Xoossay hessa taw qanxis” yaagada he na7a Yisakoora gada sunthasu. ");
INSERT INTO gofl_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Liya hara qanthatada usupuntho adde na7a Yayqoobas yelasu. ");
INSERT INTO gofl_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Liya, “Xoossi taw al7o imota immis. Taani ta azinaas usupun adde nayta yelida gisho, ha7i I tana bonchana” yaagada he na7a Zabloona gada sunthasu. ");
INSERT INTO gofl_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Hessafe guye, issi macca na7a yelasu, iyo Diina gada sunthasu. ");
INSERT INTO gofl_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Xoossay Raheelo qopis. I woosa si7idi I yelo uluwa dooyis. ");
INSERT INTO gofl_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Iya qanthatada adde na7a yelasu; “Xoossay ta yeella qaaris. ");
INSERT INTO gofl_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Goday taw hara adde na7aka gujo” yaagada he na7a Yoosefa gada sunthasu. ");
INSERT INTO gofl_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Raheela Yoosefa yelidaape guye, Yayqoobi, “Taani ta aawa biitta simmada bana tana moyza. ");
INSERT INTO gofl_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Taani enta gisho new oothida ta macceetanne ta nayta imma. Taani baana, taani new ay mela ooso oothidaako neeni eraasa” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Shin Laabi iyako, “Taani new issiba odayis, Goday ne gaason tana anjidaysa taani ta Xoossafe eras. ");
INSERT INTO gofl_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Ne damooziya taw oda, taani new qanxana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yayqoobi, “Taani new waata oothidaako, ne mehetika waani yeletidaako neeni eraasa. ");
INSERT INTO gofl_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Taani yaanape kase new de7iya guuthay ha7i loythi daris. Goday nena taani aadhida bessa ubban anjis. Shin ha7i, taani ta soo asaas oothana wode” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Laabi, “Yaatin taani new ay immo?” yaagidi iya oychis. Yayqoobi, “Taw aykoka immofa, neeni taw issiba oothana gidiko, taani ne wudiya ha7ika heemmananne naagana. ");
INSERT INTO gofl_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Taani hachi ne wude ubbaa giddora aadhana. Hessan ne dorsatape wancuwa woyko gazza, kareetha marazeta ubbaa, deeshape gazzanne wanco ubbaa taani shaakana, enti ta damooze gido. ");
INSERT INTO gofl_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Hessa gisho, ta xillotethay ne taw qanxida damooziya be7anaw yaa wode taw markatana. Ta deeshape gazza woyko puncare gidonabay woyko kareethi gidonna ay dorsati ta matan bentiko, kaysotetidaada tayba” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Laabi, “Ero, neeni gidaysada gido” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Shin he gallasan Laabi kalaade woyko gazza gidida kole ubba, wanco woyko gazza gidida macca deesha ubba, bootha wanco deeshatanne kareetha wanco dorsata ubba kessidi ba adde nayta heenthis. ");
INSERT INTO gofl_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Yaatidi he wudiya heedzu gallasa ogiya Yayqoobape haassidi efis. Shin Yayqoobi attida Laaba wudiya heemmis. ");
INSERT INTO gofl_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Yayqoobi ongafirepe, bar7efenne lawuze mithafe xam7a kessidi, poquwa poqidi giddo bootha bagga qaaridi shiloyis. ");
INSERT INTO gofl_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Wudey haathe uyanaw yaa wode gongen wudiya sinthan poqida xam7a wothis. Biraysi keydaysati haathe uyanaw yidi, ");
INSERT INTO gofl_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","he xam7ata sinthan biraysetosona. He biraysidaysati kalaade, wanconne gazza marata yelidosona. ");
INSERT INTO gofl_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Yayqoobi deesha maratanne dorsa wudiyape shaakidi dumma wothis. Attida wudiya kalaadenne kareethi gidiya Laaba mehiyako zaaridi essis. Yaatidi Laaba wudiyara gathonna ba wudiya dummayidi darsis. ");
INSERT INTO gofl_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Wudiyape gooba maccati biraysas keyiya wode he xam7ata matan biraysetana mela Yayqoobi he xam7ata haatha gongen meheta sinthan wothees. ");
INSERT INTO gofl_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Shin meheti laafa gidiko enta sinthan xam7a wothenna. Hessa gisho, laafa meheti Laababa gidin goobati Yayqoobaba gididosona. ");
INSERT INTO gofl_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Hessada oothidi Yayqoobi daro duretidi, daro wudiya, macca aylletanne adde aylleta, daro gimaletanne hareta haaris. ");
INSERT INTO gofl_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Laaba adde nayti, “Yayqoobi nu aawaba ubba ekidigis. Ha shalo ubba nu aawabape demmis” yaagishin Yayqoobi si7is. ");
INSERT INTO gofl_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Yayqoobi Laaba som7oy iyaw kase mela gidonaysa be7is. ");
INSERT INTO gofl_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","He wode Goday Yayqooba, “Neeni ne aawata biitta, ne dabbotako guye simma. Taani neera gidana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Yayqoobi Raheelonne Liya ba wudey heemetiya bessaa yaana mela kiittidi xeegisis. ");
INSERT INTO gofl_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","I entako, “Hinte aawa som7oy taw kase mela gidonaysa taani be7ayis. Shin ta aawa Xoossay taara de7ees. ");
INSERT INTO gofl_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Taani ta kumetha wolqan hinte aawas oothidaysa hinte ereeta. ");
INSERT INTO gofl_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Shin hinte aaway tana cimmidi, ta damooziya tammu toho laammis. Gidikoka Xoossay tana I qohonnaada diggis. ");
INSERT INTO gofl_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","I, ‘Puncareti ne damooze gido’ gin wude ubbay puncare yelis. Qassi I, ‘Kalaadeti ne damooze gido’ gin wude ubbay kalaade yelis. ");
INSERT INTO gofl_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Xoossay hessan hinte aawa mehiya wothi ekidi taw immis. ");
INSERT INTO gofl_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“Meheti biraysas keyiya ageenan taani issi amuho amuhas. He amuhuwan taani xeelliya wode mehiya biraysiya deesha urgeti kalaade, puncarenne gazza. ");
INSERT INTO gofl_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Xoossa kiitanchoy amuhon tana, ‘Yayqooba’ yaagis. Taani, ‘Yee’ gada koyas. ");
INSERT INTO gofl_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Ika, ‘Dhoqu gada mehiya biraysiya deesha urge ubba kalaade, puncarenne gazza be7a. Laabi ne bolla oothiyaba ubba taani be7ida gisho hessa oothas. ");
INSERT INTO gofl_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Neeni essida shucha zayte tiyada taw caaqida Beetele Xoossay tana. Ha7i dendada ha biittafe keya. Guye ne yeletida biitta simma’ gis” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Hessafe guye, Raheeliranne Liyara “Nu aawabape nuna gakiyabay aybee? ");
INSERT INTO gofl_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","I nuna allagada xeellees gidennee? I nuna bayzi ekis. Bayzi ekidaba ubbaa midi dhaysis. ");
INSERT INTO gofl_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Xoossay nu aawape wothi ekida shalo ubbay tumaka nubaanne nu naytabaa. Hessa gisho, Xoossay new odidaba ubba ootha” yaagi zaaridosona. ");
INSERT INTO gofl_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","Yayqoobi Kanaane biittan de7iya ba aawa Yisaaqako baanaw dendis. I ba naytanne ba macheta gimale togisis. Wude ubba laaggidi, Masephexoomen de7ishe shiishida shalo ubba ekidi bis. ");
INSERT INTO gofl_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Laabi ba dorsata ikisiya qanxanaw bidashin, Raheela ba aawa soo eeqa misileta kaysotasu. ");
INSERT INTO gofl_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Qassi Yayqoobi Araame addiya Laabas ba buussaa odonna ixidi cimmis. ");
INSERT INTO gofl_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","I baw de7iyaba ubba ekidi ellesidi Efraxiisa shaafa pinnidi, derey dariya Galada biitta bis. ");
INSERT INTO gofl_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Heedzu gallasape guye, Yayqoobi baqatidi bidaysa Laabi si7is. ");
INSERT INTO gofl_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Ba dabbota baara ekidi, laapun gallasa oge Yayqooba geedo kaalli derey dariya Galada biittan iya gakis. ");
INSERT INTO gofl_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","He wode Xoossay qamma Soore Laabako amuhon qoncidi, “Neeni Yayqooba bolla iitaba gidin lo77oba, aybibaaka odetiko nena era” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Laabi gakiya wode Yayqoobi derey dariya Galada biittan dunkaane tokidi uttis. Laabika dabbotara yan dunkaanidosona. ");
INSERT INTO gofl_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Hessafe guye, Laabi Yayqooba, “Neeni haysada tana ayis cimmadii? Ta macca naytaka olan di7etidabada ayis laagga kessadii? ");
INSERT INTO gofl_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Neeni ayis qosan taape kessa ekada tana cimmadii? Taani nena ufaysaninne yethan, karaaboninne diithan moyzana mela ayis taw odabikii? ");
INSERT INTO gofl_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Neeni hari attoshin, ta nayta naytanne ta macca nayta taani yeera ekona mela diggadasa. Neeni iita oothadasa. ");
INSERT INTO gofl_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Taani nena genanaw taw wolqi de7ees shin ne aawa Xoossay zine qamma tana, ‘Yayqooba bolla iitaba gidin lo77oba aybibaaka odetonaada nena era’ yaagidi taw odis. ");
INSERT INTO gofl_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Ha7i neeni ne aawa soo baanaw daro laamotida gisho keyadasa. Shin ta soo eeqa misileta ayis kaysotadii?” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yayqoobi Laaba, “Neeni ne nayta taape wolqan wosisa ekanekonne gada qopida gisho yayada haysada oothas. ");
INSERT INTO gofl_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Shin ne soo eeqa misileta ekida asi oonaka neeni demmiko, he uray hayqo. Nu dabbota sinthan nebaa gididaba ubba koyada eka” yaagis. Yayqoobi Raheela ba aawa soo eeqa misileta kaysotidaysa eribeenna. ");
INSERT INTO gofl_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Hessa gisho, Laabi Yayqooba dunkaaniya giddo, Liya dunkaaniya giddonne nam7u aylleta dunkaaniya giddo gelidi koyis. Shin aykoka demmibeenna. Liya dunkaaniyape keyidi, Raheeli dunkaaniya gelis. ");
INSERT INTO gofl_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Raheela soo eeqa misileta ekada gimale koora garsan qosada iya bolla uttasu. Laabi dunkaaniyan de7iyaba ubba pilgidi koyis. Shin aykoka demmibeenna. ");
INSERT INTO gofl_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Raheela ba aawa, “Ta godaw, tana hanqetofa. Taani new denda eqanaw danda7ike, ta kushe metora de7ayis” yaagasu. I koyidi soo eeqa misileta demmibeenna. ");
INSERT INTO gofl_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Yayqoobi yilotidi Laabako, “Taani ay iissadina? Haysa neeni tana kaallanaw ta ay qoho oothadina? ");
INSERT INTO gofl_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Ha7i neeni ta miishe ubba pilgada koyadasa. Ne soo eeqa misiletape ay demmadii? Enti nu nam7a giddon pirdana mela ne dabbota sinthaninne ta dabbota sinthan haysan wotha. ");
INSERT INTO gofl_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“Taani neera laatamu laythi kumethi de7as. Ne dorsatinne deeshati awucaybokona woyko ne wudiyape issuwaka qottada mabike. ");
INSERT INTO gofl_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Do7i mida gawuxaka ta new eha erike; taani taape ciggayis. Gallas woyko qamma kaysotetidaysata qanxisaasa. ");
INSERT INTO gofl_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Gallasa suulan, qamma meegon taani qohetas. Maara dhisko dhiska erike. ");
INSERT INTO gofl_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Taani haysada hanada ne son laatamu laythi de7as. Tammanne oyddu laythi ne nam7u macca nayta gisho, usupun laythi ne mehiya gisho new oothas. Shin neeni ta damooziya tammu toho laammadasa. ");
INSERT INTO gofl_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Ta aawa Xoossay, Abrahaame Xoossay, Yisaaqi Xoossay taara gidonaba gidiyako, sidhey bayna neeni tana mela kushe kessa yeddadasa. Shin Xoossay ta metuwanne ta daabursa be7idi zine qamma nena hanqis” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Laabi zaaridi Yayqooba, “Maccasati ta macca nayta, enta nayti ta nayta, ha meheyka ta mehiya, neeni be7iya ubbay taba. Hachi ha macca nayta bollanne enta nayta bolla ay oothanaw danda7ayna? ");
INSERT INTO gofl_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Ane haaya, neeranne taara wolla ane caaqoos. Hessi ne giddoninne ta giddon marka gido” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Hessa gisho, Yayqoobi issi shucha ekidi tuussatho essis. ");
INSERT INTO gofl_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Ba dabbota, “Shucha shiishite” yaagis. Enti shucha shiishidi keelidosona. He keela matan kathi midosona. ");
INSERT INTO gofl_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laabi he keela, Yigar-Sahaduta gidi sunthis. Yayqoobi qassi iya Galada gidi sunthis. ");
INSERT INTO gofl_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Laabi, “Ha keelay neepenne taape giddon hachi marka” yaagis. Hessa gisho, iya sunthay Galada geetetis. ");
INSERT INTO gofl_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Laabi, “Nuuni issoy issuwafe haakidi de7iya bessan Goday nenanne tana naago” gidi he bessa Mixipha gidi sunthis. ");
INSERT INTO gofl_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Laabi, “Neeni ta macca nayta naaqiko, woyko neeni ta macca nayta bolla hara macco ekiko, ta eronna ixikoka ne giddoninne ta giddon Xoossay marka gideysa akeeka” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Laabi qassika, “Keeletida shuchaynne taani ne giddoninne ta giddon essida shucha tuussay haysish. ");
INSERT INTO gofl_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Taani ha keelape nena genanaw neeko kanthonnaada, neka tana genanaw ha keelapenne ha shucha tuussafe haa aadhonada ha keelaynne ha shucha tuussay marka. ");
INSERT INTO gofl_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Abrahaame Xoossay, Nakoora Xoossay, enta aawa Xoossay, nu giddon pirdo” yaagis. Yayqoobi ba aawa Yisaaqa Xoossa sunthan caaqis. ");
INSERT INTO gofl_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Yayqoobi zuma bolla yarsho yarshis. Ba dabbota kathi maanaw xeegis. Enti midi zuma bolla aqidosona. ");
INSERT INTO gofl_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Wontetha gallas guura Laabi dendidi ba nayta naytanne ba macca nayta anjidi, yeeridi ba soo simmis. ");
INSERT INTO gofl_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Yayqoobi dendidi ba ogiya bishin Xoossa kiitanchoti iyara gahetidosona. ");
INSERT INTO gofl_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Yayqoobi enta be7ida wode “Haysati Xoossa olanchota” yaagidi, he bessa Mahanayma (Nam7u guta) gidi sunthis. ");
INSERT INTO gofl_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Yayqoobi Edoome biittan Sayre giya bessan de7iya ba isha Eesaweko kiita baape sinthe kiittis. ");
INSERT INTO gofl_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","I enta, “Hinte ta godaa Eesawes gaanabay haysa, ‘Taani ne aylley Yayqoobi, ha77i gakanaw Laaba matan gam7as. ");
INSERT INTO gofl_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Taw miizi, harey, dorsinne deeshi, adde aylletinne macca aylleti de7oosona. Ha7i taani ha kiita ta godaa sinthan saba demmandinasha gada kiittas yaagis’ yaagite” yaagidi kiittis. ");
INSERT INTO gofl_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Kiitetidaysati Yayqoobako simmidi, “Nuuni ne isha Eesaweko bida. Ika qassi neera gahetanaw yees. Iyara oyddu xeetu asay de7oosona” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Yayqoobi daro babidi baara de7iya asa nam7u cugan shaakis. Ba dorsa, deesha, miizanne gimaleta nam7u cugan shaakis. ");
INSERT INTO gofl_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","I, “Eesawey yidi issi cuga oliyaba gidiko, attida cugay kessi ekana” gidi qopis. ");
INSERT INTO gofl_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","He wode Yayqoobi haysada yaagidi woossis, “Abeeti Godaw, ta aawa Abrahaame Xoossaw, ta aawa Yisaaqa Xoossaw, tana, ‘Ne biitta, ne dabbotako simma, taani new lo77oba oothana gidayso, tana si7arki’, ");
INSERT INTO gofl_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","neeni ne aylliyas keehidabasinne ammanetetha ubbaas taani bessona asi. Taani Yordaanose shaafa pinniya wode taw issi xam7a xalaali de7ees; shin ha7i taani nam7u cuga godaa gidas. ");
INSERT INTO gofl_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Taani nena woossayis ta isha Eesawe kushepe tana ashsha. I yidi, tananne aayeta enta naytara dhaysona aggenna gada yayyayis. ");
INSERT INTO gofl_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Shin neeni tana, ‘Taani new tuma lo77oba oothana. Taani ne sheesha taybanaw danda7etona abba shafeda oothana’ gidaysa qopa” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","He gallas qamma I yan aqis. Baw de7iyaba ubbaafe ba isha Eesawes immanaba qoridi kessis. ");
INSERT INTO gofl_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","15","I, nam7u xeetu macca deeshatanne laatamu deesha marazeta, nam7u xeetu macca dorsatanne laatamu dorsa marazeta, hastamu dhanthiya gimaleta enta maratara, oytamu macca miizata, tammu korma boorata, laatamu macca haretanne tammu adde hareta qoridi kessis. ");
INSERT INTO gofl_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Hessata wuden wuden shaakidi ba aylletas immidi, “Taape sinthe bidi wudiya wudiyape haahon haahon laaggite” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Sinthan kaaletheysa, “Ta ishay Eesawey neera gahetidi, ‘Neeni oodesee? Neeni aw bay? Ne sinthan de7iya mehe ubbay oodebayee?’ yaagidi oychiko, ");
INSERT INTO gofl_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","ne iyako, ‘Haysati ne aylliya Yayqoobasa, I ta godaa Eesawes immanaw yeddidaysata. Ika nuupe guyera yees’ yaaga” yaagidi kiittis. ");
INSERT INTO gofl_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Qassi nam7anthuwa, heedzanthuwanne wudiya kaalliya harata ubbaa, “Hinte Eesawera gahetiya wode haysada geeta; ");
INSERT INTO gofl_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","‘Ne aylliya Yayqoobi nuupe guyera yees’ goonna aggofite” yaagidi kiittis. I, “Taani immanaw sinthe yeddidaysan iya irxisana. Ooni eri hessafe guye taani iyara gahetiya wode I tana moki ekana” yaagidi qopis. ");
INSERT INTO gofl_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Hessa gisho, ba immanaba baape sinthe yeddis. Shin I ba huuphen he gallas qamma yan aqis. ");
INSERT INTO gofl_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","He qamma Yayqoobi dendidi, ba nam7u macheta, ba nam7u aylleta, ba nayta tammanne issota ekidi, Yaaboqa shaafa pinnis. ");
INSERT INTO gofl_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","I enta shaafa pinthi simmidi baw de7iyaba ubbaa pinthidi yeddis. ");
INSERT INTO gofl_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Shin Yayqoobi barka guye attis. He wode issi asi sa7i wontana gakanaw iyara baaxetishe aqis. ");
INSERT INTO gofl_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","He uray iya xoonanaw danda7onaysa be7ida wode Yayqoobas bulxiya bochin, iya bulxey kesuwape keyis. ");
INSERT INTO gofl_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Yaatin uray iya, “Sa7i wontana haniya gisho, tana yedda” yaagis. Shin Yayqoobi, “Neeni tana anjonna nena yeddike” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Uray, “Ne sunthay oonee?” yaagidi oychis. I zaaridi, “Yayqooba” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Uray, “Neeni Xoossaranne asara baaxetada xoonida gisho, hizape ne sunthay Yayqooba geetetofo, Isra7eele (Xoossara baaxetis) geeteto” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Yayqoobi uraa, “Ne sunthay oonee?” yaagidi oychis. Shin uray, “Neeni ta suntha ayis oychay?” yaagidi iya anjis. ");
INSERT INTO gofl_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Hessa gisho, Yayqoobi, “Taani Xoossa som7on be7as shin paxa de7ayis” yaagidi, he bessa Phin7eela (Xoossa som7o) gidi sunthis. ");
INSERT INTO gofl_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","I Phin7eelape dendiya wode iya bolla xalqey dolis. Iya bulxe kessay sakiya gisho dogees. ");
INSERT INTO gofl_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Yayqooba bulxey wodire ashuwa matan boshetida gisho, Isra7eele asay mehes bulxe asho hachi gakanaw mookonna. ");
INSERT INTO gofl_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Yayqoobi dhoqu gidi xeelliya wode Eesawey ba oyddu xeetu asaara yeysa be7is. Hessa gisho, nayta Liyas, Raheelisinne nam7u aylletas shaaki immis. ");
INSERT INTO gofl_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Aylletanne enta nayta sinthan, Liyanne I nayta enta geedon, Raheelonne Yoosefa wursethan wothis. ");
INSERT INTO gofl_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Shin I baw sinthe aadhidi ba ishaako matishe sa7a gaki gaki laapuntoho ziggis. ");
INSERT INTO gofl_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Shin Eesawey iyara gahetanaw woxi yidi iya qoodhiya qoomidi yeeris. Nam7ayka yeekidosona. ");
INSERT INTO gofl_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Eesawey dhoqu gidi xeellidi maccasatanne nayta be7idi, “Ha neera de7eysati oonantee?” yaagidi oychis. Yayqoobi, “Ta godaw, haysati Xoossay ne aylliyas ba keehatethan immida nayta” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Aylleti banta naytara shiiqidi iyaw ziggidosona. ");
INSERT INTO gofl_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Kaallidi Liyaranne I naytara yidi ziggidosona. Wursethan Yoosefaranne Raheelira yidi ziggidosona. ");
INSERT INTO gofl_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Eesawey, “Ha sinthan bishe taara gahetida wudey ubbay aybee?” yaagidi oychis. Yayqoobi, “Ta godaw, hessi taani ne sinthan saba demmanaw yeddidaysata” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Shin Eesawey, “Ta ishaw, taw gidiya shaloy de7ees, nebay new gido” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Yayqoobi, “Hayyana, ha7i taani ne sinthan saba demmidaba gidiko, ha taani immeysa eka. Neeni tana moka ekida gisho, ta ne som7uwa be7eysi Xoossa som7o be7eysa mela. ");
INSERT INTO gofl_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Taani new ehida ha imota eka. Xoossay taw keehi immida gisho kumis” yaagis. Yayqoobi woossidi aggonna ixida gisho, Eesawey iya imota ekis. ");
INSERT INTO gofl_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Eesawey, “Ane yedha, taani neera issife baana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Shin Yayqoobi, “Ta godaw, nayti shugo gideysa eraasa. Qassi taani galo marata dhanthiya dorsatanne miiza naaganaw koshshees. Asay enta hari attoshin, issi gallas minthi laagiko, mehe ubbay hayqana. ");
INSERT INTO gofl_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Hessa gisho, ta godaw, ne aylletape sinthatada ba. Taani Sayren ta godaa gakanaw, ta sinthan de7iya mehiyanne nayta hemethaa mela loddan kaallada ta godaa taani Edoomen gakana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Eesawey, “Yaaniko, taani ta asaape guuthara new asho” yaagis. Shin Yayqoobi, “Koshshenna; taani ta godaa sinthan sabetidaysi taw gidana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Hessa gisho, Eesawey he gallas ogen wodhidi Sayre simmis. ");
INSERT INTO gofl_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Shin Yayqoobi Sukota bis. Yan baw keethe keexis, ba mehetas shaqara shaqaris. Hessa gisho, he bessa Sukota (Kuya woyko Gaabba) gidi sunthis. ");
INSERT INTO gofl_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Yayqoobi Masephexoomepe simmidi Kanaane biittan de7iya Seekema katama saron gakis. I he katamas sintha baggara dunkaane tokidi uttis. ");
INSERT INTO gofl_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Ba dunkaaniya tokidi uttida gadiya Seekema aawa Hamoora naytape issi xeetu bira santimen shammis. ");
INSERT INTO gofl_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Yan yarsho bessi giigisidi, “Godaa, Isra7eele Xoossa” gidi sunthis. ");
INSERT INTO gofl_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Liya Yayqoobas yelida na7iya Diina, he wode Kanaane maccasata be7anaw keyasu. ");
INSERT INTO gofl_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","He biitta haariya Hiwe addiya Hamoora na7a Seekemi iyo be7idi, dafidi iissis. ");
INSERT INTO gofl_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Iya wozanay Yayqooba na7iw Diinas qadhetis. I iw mishetida gisho lo77o qaalara iyo odisis. ");
INSERT INTO gofl_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Seekemi ba aawa Hamoora, “Taw ha na7iw macho oycharki” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Yayqoobi ba na7iw, Diina, azini dafidaysa si7ida wode iya adde nayti mehera bazzon de7oosona. Hessa gisho, enti yaana gakanaw si77i gis. ");
INSERT INTO gofl_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Hessafe guye, Seekema aawa Hamoori Yayqooba odisanaw yis. ");
INSERT INTO gofl_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Yayqooba adde nayti bazzofe yidi hessa si7idosona. Enti Seekemi Yayqooba na7iw dafidi, iissidi Isra7eele yeellayida gisho daro yilotidosona. ");
INSERT INTO gofl_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Shin Hamoori entako, “Ta na7ay Seekemi hinte na7ees daro mishetees, hayyana iyo iyaw macho immerketi. ");
INSERT INTO gofl_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Nuura eketitenne geletite, hinte macca nayta nuus immite, nu macca naytaka hintew ekite. ");
INSERT INTO gofl_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Hinte nu giddon daanaw danda7eeta. Biittay daro dalga, iya oothidi zal7idi hintew aqo demmanaw danda7eeta” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","He wode Seekemi Diina aawanne I ishata, “Taani hinte sinthan sabetiko, hinte koyiyaba aybiba gidikoka immana. ");
INSERT INTO gofl_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Hinte mishira na7ees immanabaanne koyta hinte koyda mela tana oychite. Taani hinte tana oychidaba ubba immana. Shin taani machanaw na7iw taw immerketi” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Banta michiw Diina Seekemi tunisida gisho, Yayqooba adde nayti Seekemasinne iya aawa Hamooras wordotidosona. ");
INSERT INTO gofl_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Entako, “Nuuni hessa mela palabaa oothanaw danda7oko, nuuni nu michiw qaxaretiboona asas immoko, hessi nuna kawushiyaba. ");
INSERT INTO gofl_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Hinte nuus issiba ero giiko nu hintew ero gaana. Hessika, hinte biitta adde asa ubbay qaxaretidi nuuda haniko, ");
INSERT INTO gofl_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","nuuni nu macca nayta hintew immanaw Ero gaana. Hinte macca naytaka nuus ekana. Nuuni hinte giddon de7idi hintera issi ase gidana. ");
INSERT INTO gofl_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Shin hinte qaxaretanaw ero goonna ixiko, nuuni nu michiw eki baana” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Yaatin ha enti gidabay Hamoorasinne iya na7a Seekemas lo77o daanis. ");
INSERT INTO gofl_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","He panthay ba aawa keethan de7iya ubbaafe aadhidi bonchetida gisho koydaba oothanaw iyaw maati de7ees. Yayqooba na7iw daro dosida gisho, enti gidaba oothanaw guye gibeenna. ");
INSERT INTO gofl_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","He wode Hamoorinne iya na7ay Seekemi banta katama dabaaba bidi, banta katama asaas haysada yaagidi odidosona. ");
INSERT INTO gofl_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Ha asati nuura siga de7oosona. Biittay daro dalga gidiya gisho enti ha biittan goyo zal7o. Enta macca naytaka nuuni ekana, entika nu macca nayta ekona. ");
INSERT INTO gofl_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Shin nuura enti issi asada de7anaw nuuni issiba ero gaanaw koshshees. Hessika, enti qaxaretidaysada nu adde asa ubbay qaxaretanaysa. ");
INSERT INTO gofl_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Nuuni hessada oothiko, enta meheynne, enta aqo ubbay nubaa gidennee? Hessa gisho, ane nuuni enti geysa ero goos. Entika nu giddon de7ana” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Katamaa dabaaba shiiqida asati ubbay Hamoorasinne iya na7a Seekemas, “Ero” gidoosona. Yaatin he katama adde asati ubbay qaxaretidosona. ");
INSERT INTO gofl_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Heedzantho gallas, enti ubbay banta qaxara maduntha saketishin, Yayqooba adde naytape nam7ay, Diina ishati, Simoonaranne Leewera banta mashsha ekidi oonika eronna katama gelidi adde asa ubba wodhidosona. ");
INSERT INTO gofl_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Hamooranne iya na7a Seekema mashshan wodhidi, banta michiw Diina Seekema keethafe eki bidosona. ");
INSERT INTO gofl_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Yayqooba hara adde nayti ahata bolla gelidi banta michiw Diina tunisida katama ubbaa bonqidosona. ");
INSERT INTO gofl_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Enta dorsa wudiya, miiza wudiya, hariya, katama giddon de7iyabaanne gaxan de7iyaba ubba ekidosona. ");
INSERT INTO gofl_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Enta keethan de7iya aquwa ubba, enta nayta ubbaanne maccasata ubba di7idosona. ");
INSERT INTO gofl_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Yayqoobi Simoonanne Leewe, “Hinte ta bolla gita meto ehideta. Ha biittan de7iya Kanaanetinne Parzeti tana ixana. Nuuni taybon guutha, enti issife gididi ta bolla dendiko, taaninne ta soo asay dhayana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Shin enti, “Yaatin, I nu michiw layma maccasada oothanaw bessii?” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Hessafe guye Xoossay Yayqooba, “Dendada pude Beetele keyada yan de7a. Neeni ne isha Eesawepe baqatida wode new qoncida Xoossas yan yarsho bessi giigisa” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Hessa gisho, Yayqoobi ba soo asaanne iyara de7eyisata ubba, “Hinte giddon de7iya allaga xoossata diggite. Hintena geeshshite, hinte ma7uwa laammite. ");
INSERT INTO gofl_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Haysafe dendidi pude Beetele boos. Ta metuwa gallas taw si7ida, taani bida bessa ubban taara gidida Xoossas taani yan yarsho bessi giigisana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Enti bantaw de7iya allaga xoossata ubbaanne banta haythan aathida worqa ubba kessidi Yayqoobas immidosona. Yayqoobi hessata Seekeman de7iya wolaa garsan moogis. ");
INSERT INTO gofl_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Hessafe guye, Yayqoobinne iya adde nayti dendidi biyade enta yuushuwan de7iya asa bolla Xoossa yashshay wodhida gisho entana kaallidi oykanaw oonika danda7ibeenna. ");
INSERT INTO gofl_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Yayqoobinne iyara de7iya asa ubbay Kanaane biittan de7iya Beetele geetetiya Looza gakidosona. ");
INSERT INTO gofl_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Yan I yarsho bessi giigisis. I he bessa El-Beetele (Beetele Xoossa) gidi sunthis. I ba ishaape baqatidi biya wode Xoossay iyaw qonciday he bessaana. ");
INSERT INTO gofl_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Irbiqa dichiya Diboora yan hayqasu. Beetelepe garsara de7iya wolaa garsan iya moogetasu. Hessa gisho, he mitha sunthay Alon-Bakute (Yeeho Wola) geetetis. ");
INSERT INTO gofl_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Yayqoobi Masephexoomepe simmidaape guye, Xoossay iyaw zaari qoncidi iya anjis. ");
INSERT INTO gofl_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Xoossay, “Ne sunthay Yayqooba. Shin hizape neeni Yayqooba geetetaka, ne sunthay Isra7eele geetetana” yaagidi iya “Isra7eele” gidi sunthis. ");
INSERT INTO gofl_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Qassi Xoossay Yayqooba, “Taani Ubbaa Danda7iya Xoossa. Neeni yeleta, dara. Dereynne kawotethati neepe keyo. Kawotika ne gulbatape keyo. ");
INSERT INTO gofl_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Taani Abrahaamesinne Yisaaqas immida biitta, new immana. Neepe guye taani ha biitta ne sheeshas immana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Xoossay iyara odetida bessaafe pude keyis. ");
INSERT INTO gofl_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Yayqoobi Xoossay iyara odetida bessan qofisiya shucha mala essidi iya bolla woyniyanne zayte tigis. ");
INSERT INTO gofl_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Yayqoobi Xoossay iyara odetida bessa “Beetele” gidi sunthis. ");
INSERT INTO gofl_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Enti hessafe guye, Beetelepe dendidi bidosona. Enti Efraata gakanaw guuthu attishin, Raheelo iqethi oykin daro waayetasu. ");
INSERT INTO gofl_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Iqethay iyo waaysida wode iyo yelisiyara, “Babofa; haysika adde na7a” yaagasu. ");
INSERT INTO gofl_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Shin iya hayqos matada shempoy keyana hanishin, ba na7a Benoona (Meto na7a) gada sunthasu. Shin iya aaway Biniyaame (Ta ushacha) gidi sunthis. ");
INSERT INTO gofl_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Hessafe guye, Raheela hayqa aggasu. Beeteleme geetetiya Efraata efiya ogiya gaxan moogetasu. ");
INSERT INTO gofl_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Yayqoobi I duufuwa bolla hawulte shucha essis. He hawultey hachu gakanawuka Raheeli duufuwa erisees. ");
INSERT INTO gofl_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Isra7eeley hessafe dendidi Edera gimbiyafe hefinthan ba dunkaaniya tokis. ");
INSERT INTO gofl_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Isra7eeley he biittan de7ishin, Robeeli ba aawas yelida aylle Baalira aqis. Isra7eeley he odaa si7is. Yayqooba adde nayti tammanne nam7a. ");
INSERT INTO gofl_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Liya nayti Yayqooba bayra na7a Robeela, Simoona, Leewe, Yihuda, Yisakooranne Zabloona. ");
INSERT INTO gofl_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Raheeli adde nayti Yoosefanne Biniyaame. ");
INSERT INTO gofl_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Raheeli aylle Baali adde nayti Daanenne Niftaaleme. ");
INSERT INTO gofl_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Liya aylle Zalafa adde nayti Gaadenne Aseera. Ha nayti Yayqoobas Masephexoomen yeletida adde nayta. ");
INSERT INTO gofl_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Yayqoobi Kebroona geetetiya Qiriyaat-Arba matan Mamiren de7iya ba aawa Yisaaqa soo bis. He bessay kase Abrahaameynne Yisaaqi de7ida bessaa. ");
INSERT INTO gofl_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Yisaaqi xeetanne hospun tammu laythi de7is. ");
INSERT INTO gofl_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","I daro wodiya de7idi lo77o cimidi, hayqidi ba mayzatan gahetis. Iya nayti Eesaweynne Yayqoobi iya moogidosona. ");
INSERT INTO gofl_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Edoome geetetiya Eesawe yeletethay haysafe kaallidi xaafetidaysa; ");
INSERT INTO gofl_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Eesawey Kanaane biitta macca naytape baw machota ekis. Entika Hite addiya Eloona na7iw Ado, Hiwe addiya Xiba7oona na7ay Ani yelida Oholbaamonne ");
INSERT INTO gofl_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Isma7eela na7iw, Nebayoota michiw Basemaato. ");
INSERT INTO gofl_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada Eesawes Elfaaza yelasu. Basemaata Ragu7eela yelasu. ");
INSERT INTO gofl_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholbaama Ye7usa, Ya7ilamanne Qore yelasu. Kanaane biittan Eesawes yeletida adde nayti haysata. ");
INSERT INTO gofl_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Eesawey ba macheta, ba adde naytanne macca nayta, ba soo asa ubbaa, ba miizanne ba hara mehe ubbaa Kanaane biittan haaridaba ubbaa ekidi ba isha Yayqoobape haakidi hara biitta bis. ");
INSERT INTO gofl_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Enta shaloy darida gisho, enti issife daanaw danda7ibookona. Enta mehey darida gisho, enti de7iya biittay enta nam7aas gidonna ixis. ");
INSERT INTO gofl_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Yaanin, Edoome geetetiya Eesawey derey dariya Sayre biittan de7is. ");
INSERT INTO gofl_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Derey dariya Sayre biittan de7ida Edoometa mayza Eesawe yeletethay haysafe kaallidi xaafetidaysa; ");
INSERT INTO gofl_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Eesawe adde nayta sunthay, Eesawe mache Adi na7aa Elfaazanne Eesawe mache Basemaati na7a Ragu7eela. ");
INSERT INTO gofl_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Elfaaza nayti Temaana, Omaara, Xafa, Ga7itamanne Qeneza. ");
INSERT INTO gofl_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Qassi Timnaa7a Eesawe na7a Elfaazas aylle. Iya Elfaazas Amaaleqa yelasu. Haysati Eesawe mache Adi na7aa nayta. ");
INSERT INTO gofl_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Ragu7eela adde nayti Nahaata, Zara, Shamanne Miiza. Haysati Eesawe mache Basemaati na7a nayta. ");
INSERT INTO gofl_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Xiba7oona na7ay Ani yelida Oholbaama adde nayti haysata; Entika Ye7usa, Ya7ilamanne Qore. ");
INSERT INTO gofl_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Eesawe yeleta halaqati haysafe kaallidi xaafetidaysata; Eesawes bayra na7a Elfaaza adde nayti, halaqa gididaysati Temaana, Omaara, Xafa, Qanaza, ");
INSERT INTO gofl_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Qore, Ga7itamanne Amaaleqa; Edoome biittan Elfaazi yelida halaqati haysata; hessati ubbay Adi na7aa nayta. ");
INSERT INTO gofl_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Eesawe na7a Ragu7eela adde nayti, halaqa gididaysati Nahaata, Zaraha, Shamanne Miiza; Edoome biittan Ragu7eeli yelida halaqati haysata; enti Eesawe mache Basemaati na7a nayta. ");
INSERT INTO gofl_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Eesawe mache Oholbaami adde nayti, halaqa gididaysati Ye7usa, Ya7ilamanne Qore; enti Ana na7e, Eesawe mache Oholbaamipe yeletida halaqata. ");
INSERT INTO gofl_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Edoome geetetiya Eesawe adde nayti haysata; enta halaqatika haysata. ");
INSERT INTO gofl_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Edoome biittan de7iya Hoora Sayre adde nayti haysafe kaallidi xaafetidaysata; hessatika Loxaana, Shobaala, Xiba7oona, Ana, ");
INSERT INTO gofl_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Disoona, Exeranne Disaana; hessati, Edoome biittan de7iya Sayre adde nayti, Hoorata halaqata. ");
INSERT INTO gofl_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Loxaana adde nayti Hooranne Hemaama; Loxaana michiya Timnaa7o. ");
INSERT INTO gofl_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Sobaala adde nayti Aliwa, Manahoota, Ebaala, Sifanne Onaama. ");
INSERT INTO gofl_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Xiba7oona adde nayti Ayanne Ana; haysi Ani mela biittan ba aawa Xiba7oona hareta heemmishe bilbo haatha pultuwa demmidaysa. ");
INSERT INTO gofl_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Ana na7ay Disoona; na7iya qassi Oholbaamo. ");
INSERT INTO gofl_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Disoona adde nayti Hemdaana, Esbaana, Yitraananne Kaarana. ");
INSERT INTO gofl_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Exera adde nayti Bilihaana, Zawananne Aqana. ");
INSERT INTO gofl_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Disaana adde nayti Uxanne Arana. ");
INSERT INTO gofl_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Hoorata halaqati haysata; Loxaana, Shobaala, Xiba7oona, Ana, ");
INSERT INTO gofl_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Disoona, Exeranne Disaana. Haysati Sayre biittan banta yaran yaran shaaketida Hoorata halaqata. ");
INSERT INTO gofl_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Isra7eelen Kawoy kawotanaape kase Edoome biittan kawotida kawoti haysafe kaallidi xaafetidaysata. ");
INSERT INTO gofl_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bi7oora na7ay Balaaqi Edoomen kawotis; iya katamaa sunthay Dinaaba geetetees. ");
INSERT INTO gofl_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Balaaqi hayqin, Baasora addey Zaara na7ay Yobaabi iya bessan kawotis. ");
INSERT INTO gofl_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Yobaabi hayqin, Temaana addey Husami kawotis. ");
INSERT INTO gofl_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Husami hayqin, Badada na7ay Hadaadi, Midiyaameta Moo7abe biittan xoonidaysi kawotis; iya katamaa sunthay Awiita geetetis. ");
INSERT INTO gofl_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadaadi hayqin, Masreeqa addey Samili kawotis. ");
INSERT INTO gofl_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samili hayqin, shaafa matan de7iya Rehoboota addey Saa7uli kawotis. ");
INSERT INTO gofl_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Saa7uli hayqin, Akboora na7ay Ba7al-Hanani kawotis. ");
INSERT INTO gofl_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Akboora na7a Ba7al-Hanani hayqin, Hadaadi kawotis; iya katamaa sunthay Paa7u geetetees; iya machiya Mezahaaba na7iya Maxireeda yelida Mahexabeelo geetetawusu. ");
INSERT INTO gofl_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Eesawe yeleta halaqati banta yaran yaran, banta bessan bessan banta sunthan sunthan haysata; Timina, Aliwa, Yeteta, ");
INSERT INTO gofl_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oholbaama, Ela, Pinoona, ");
INSERT INTO gofl_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Qanaza, Temaana, Mibsaara, ");
INSERT INTO gofl_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magdelanne Irama. Haysati banta aysiya biittan, banta de7iyasuwan de7iyasuwan Edoome halaqata. Haysi Eesawey, Edoometa aawa. ");
INSERT INTO gofl_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yayqoobi iya aaway Yisaaqi de7ida Kanaane biittan de7is. ");
INSERT INTO gofl_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Yayqooba yeletetha taarikey haysafe kaallidi xaafetidaysa. Yoosefi tammanne laapun laytha na7a gidida wode ba aawa machetape, Baalipenne Zilpafe yeletida ba ishatara mehe heemmees. I ba aawas ba ishati oothida iitabata odees. ");
INSERT INTO gofl_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Isra7eeley Yoosefa cimidi yelida gisho, ba hara adde nayta ubbaafe aathidi dosees. Hessa gisho, iyaw alleeqetida ma7o giigisis. ");
INSERT INTO gofl_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Iya ishati enta aaway iya entafe aathidi doseysa be7ida wode iya ixidosona. Mal7o qaalaka iyako odetanaw danda7ibookona. ");
INSERT INTO gofl_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Issi wode Yoosefi amuho amuhidi, ba ishatas odin enti iya kaseysafe aathidi ixidosona. ");
INSERT INTO gofl_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","I entako, “Taani amuhida amuhuwa si7ite. ");
INSERT INTO gofl_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Nuuni gaden giste mirqishin ta mirqey dendidi luule eqis. Hinte mirqeti yuuyi aadhidi ta mirqiyas ziggidosona” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Iya ishati, “Neeni nu bolla kawotada nuna haaranaw qopay?” yaagidi oychidosona. Enti iya amuhuwa gishonne iya odaa gisho, kaseysafe aathidi ixidosona. ");
INSERT INTO gofl_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Qassika Yoosefi hara amuho amuhidi ba ishatas odis. “Heko, taani hara amuhoka amuhas. He amuhuwan awi, ageeninne tammanne issi xoolintoti taw ziggoosona” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Ba ishatas odida amuhuwa ba aawas odida wode iya aaway, “Haysi waanida amuho? Tuma taani, ne aayanne ne ishati yidi, ne sinthan zigganeyee?” yaagidi hanqetis. ");
INSERT INTO gofl_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Iya ishati iya qanaatidosona, shin iya aaway he odaa ba wozanan wothis. ");
INSERT INTO gofl_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Issi gallas iya ishati Seekeman banta aawa meheta heemmanaw bidosona. ");
INSERT INTO gofl_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Isra7eeley Yoosefa, “Ne ishati Seekeman meheta heemmeysa eraasa. Haaya, taani nena entako kiittana” yaagis. Yoosefika, “Ero” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","I iyako, “Bada ne ishatinne mehey saro gideysa be7ada entaba taw yada oda” yaagidi Yoosefa Kebroona zangaarape kiittis. Yoosefi kiitetidi Seekema bis. ");
INSERT INTO gofl_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Yan demba bessan enta koshshan yaa haa simeretishin, issi asi iya demmidi, “La na7aw, ay koyay?” yaagidi oychis. ");
INSERT INTO gofl_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","I, “Ta ishata koyayis; enti mehiya heemmiya bessaa be7idaako, hayyana taw odarkii” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Uray, “Haysafe bidosona; enti, ‘Nuuni Dootane baana’ gishin si7as” yaagis. Hessa gisho, Yoosefi ba ishata geedo kaalli bidi, enta Dootanen demmis. ");
INSERT INTO gofl_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Shin I haahon de7ishin, enti iya be7idosona. I entako gakonna de7ishin, wodhanaw iya bolla maqetidosona. ");
INSERT INTO gofl_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Enti issoy issuwako, “Hini be7ite, amuhuwa goday yees. ");
INSERT INTO gofl_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Haayite, iya wodhidi, ha ollatape issuwan yeggoos. Hessafe guye, ‘Do7i iya mis’ yaagana. Yaatidi, iya amuhuwa wursethaa be7ana” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Robeeli hessa si7ida wode, enta kushepe iya ashshanaw koydi, “Iya wodhoko; ");
INSERT INTO gofl_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","iya wodhanaape mela biittan de7iya ha ollan yeggite; iya bolla kushe wothofite” yaagis. Robeeli hessa giday, iya enta kushepe ashshidi guye aawako zaaranaasa. ");
INSERT INTO gofl_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Yoosefi ba ishatako gakida wode I ma77ida alleeqetida ma7uwa iyape qaari ekidosona. ");
INSERT INTO gofl_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Iya efidi haathi bayna mela ollan yeggidosona. ");
INSERT INTO gofl_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Enti kathi mishin hassayoona Isma7eela asati Galadape Gibxe bishin, dhoqu gidi be7idosona. Enti banta gimaleta bolla sawuwa, madiyanne karbiya caanidosona. ");
INSERT INTO gofl_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Yihudi ba ishata, “Nuuni nu isha wodhidi, iya suuthaa qottiko nuna ay maaddanee? ");
INSERT INTO gofl_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Haayite, iya Isma7eela asaas bayzoos. I nu isha, nu suuthunne nu asho gidiya gisho iya bolla nu kushiya wothoko” yaagis. Iya ishati iya odaa ma77idosona. ");
INSERT INTO gofl_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Hessa gisho, Midiyaame biitta zal7anchoti yaara aadhishin, iya ishati Yoosefa ollafe kessidi, Isma7eela asatas laatamu bira santimen bayzidosona. Enti Yoosefa Gibxe biitta efidosona. ");
INSERT INTO gofl_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Robeeli ollaako simmidi, Yoosefi yan baynaysa be7ida wode, azzanidi ba ma7uwa daakis. ");
INSERT INTO gofl_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","I guye ba ishatako bidi, “Na7ay yan baawa; hiza, taani ay hanosha?” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Enti Yoosefa ma7uwa ekidi, issi deeshe shukidi, he suuthan naaqidosona. ");
INSERT INTO gofl_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Alleeqetida iya ma7uwa banta aawako efidi “Nuuni haysa demmida; haysi ne na7a ma7uwakonne ane be7a” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Yayqoobi ma7uwa eridi, “Haysi ta na7aa ma7uwa; ta na7aa do7i mis. Yoosefi tumaka zaazetis” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Yayqoobi azzanidi, ba ma7uwa peedhis. Kayo ma7o ma7idi, ba na7aas daro gallas yeekis. ");
INSERT INTO gofl_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Iya adde naytinne macca nayti ubbay iya minthethanaw yidosona. Shin I minettonna ixidi, “Akay, taani yeehoy yeehoshin duufo gelana” yaagidi, Yoosefas yeekis. ");
INSERT INTO gofl_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","He wode Midiyaame biitta asati Yoosefa, Gibxe kawa moorinnatanne kawa naageysata halaqa gidida Phoxfaaras bayzidosona. ");
INSERT INTO gofl_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","He wode Yihudi ba ishatape shaaketidi, Adulaama kataman de7iya Hira geetetiya uraara daanaw bis. ");
INSERT INTO gofl_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Yan Yihudi Shuu7a geetetiya Kanaane ura na7iw machis. ");
INSERT INTO gofl_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Iya Yihudas qanthatada adde na7a yelasu. I he na7a Era gidi sunthis. ");
INSERT INTO gofl_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Qassika qanthatada adde na7a yelasu. Iya he na7a Onaana gada sunthasu. ");
INSERT INTO gofl_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Zaaradaka hara adde na7a yelasu. Iya he na7aa Seela gada sunthasu. He na7ay yeletiya wode Yihudi Akziiba biittana. ");
INSERT INTO gofl_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Yihudi ba bayra na7a Eras Timaaro geetetiya macho immis. ");
INSERT INTO gofl_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Yihuda bayra na7ay, Eri, Godaa sinthan iita asi gidiya gisho, Goday iya wodhis. ");
INSERT INTO gofl_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Yihudi Onaanako, “Wogay nena kiiteysa mela ne ishaa machera aqa. Ne ishaas na7a yelada iya suntha xeegisa” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Shin Onani yeletana nayti iyabaa gidonaysa erida gisho, ba ishaa machera aqiya wode ba ishaas na7i yeletonna mela ba attunta sa7an gussees. ");
INSERT INTO gofl_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","I oothidabay Godaa sinthan iitaba gidida gisho, Goday iyaka wodhis. ");
INSERT INTO gofl_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Hessafe guye, Yihudi ba na7aa machiw Timaaro, “Ta na7ay Seeli diccana gakanaw ne aawa soo bada, am7etethan de7aasha” yaagis. Hessa I giday, ika ba ishatada hayqanekonne gidi hirgida gishosa. Hessa gisho, Timaara bada ba aawa son de7asu. ");
INSERT INTO gofl_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Daro wodepe guye, Yihuda machiya, Shuu7a na7iya hayqasu. Yihudi ba kayo wodiya ongidi, ba dorsata ikisiya meediya asatako Timina geetetiya bessi ba laggiya Adulaama addiya Hirera bis. ");
INSERT INTO gofl_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Asay Timaaro, “Heko, ne azina aaway Yihudi, ba dorsata ikisiya meedanaw Timina bees” yaagidi odidosona. ");
INSERT INTO gofl_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Iya ba am7etetha ma7uwa laammada, bana balethanaw shaashe ekada guuluntasu. Yaatada, Timina efiya ogiya doonan de7iya Enayme katama gaxan uttasu. Hessa iya oothidaysi, Seeli diccidi gakinka iyaw macho gidada imetonaysa iya erida gishosa. ");
INSERT INTO gofl_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Iya ba som7uwa guuluntida gisho, Yihudi iyo be7ida wode, layma maccas gidi qopis. ");
INSERT INTO gofl_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Ba na7aa machiw gideysa eronna de7ishe, ogiya gaxa iiko shiiqidi “Taara aqanee?” yaagidi oychis. Iya, “Taani neera aqiko, ne taw ay immanee?” gada oychasu. ");
INSERT INTO gofl_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","I, “Taani ta mehiyape issi kole new yeddana” yaagis. Iya, “Neeni hessa taw yeddana gakanaw ay oythanee?” yaagasu. ");
INSERT INTO gofl_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","I, “Ay oytho?” yaagis. Iya, “Ne maatamiya iya gooshuwaranne ne kushiyan de7iya xam7a oytha” yaagasu. I hessata immidi, iira aqis; iyaka qanthatasu. ");
INSERT INTO gofl_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Iya hessafe dendada bidaape guye, ba guulunthaa qaarada, ba am7etetha ma7uwa ma7asu. ");
INSERT INTO gofl_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Yihudi ba oythidaba he maccaseepe zaari ekanaw deesha ba laggiya Hira bolla iw yeddis. Shin I iyo demmibeenna. ");
INSERT INTO gofl_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","I he biitta asaako, “Enayme kataman, oge doonan uttida layma maccasiya awunee?” yaagidi oychis. Asay, “Layma maccas haysan ubbaka baawa” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","I Yihudako simmidi, “ ‘Taani iyo demmabike; hessa bollaka he biitta asay, layma maccas haysan ubbaka baawa’ yaagidosona” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Yihudi, “Ba oykidaysa baw eko, atto giiko, asi nuna miicana. Hiza taani iw deeshe yeddas shin neeni iyo demmabaaka” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Heedzu ageena gidishin asay, “Ne na7aa maccasiya Timaara laymatada qanthatasu” yaagidi Yihudas odidosona. Yihudi, “Iyo kare kessidi taman xuuggite” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Iyo kare kessiya wode, “Taani qanthatiday ha miisheta godaasa. Ha maatameynne xam7ay oodebayeko eranaw danda7iko era” gada ba azina aawaka kiittasu. ");
INSERT INTO gofl_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yihudi he miisheta eridi, “Taani ta na7aa Seelas iyo immaboonna gisho, taape iya xillo” yaagis. Hessafe guye, I iira zaaridi aqibeenna. ");
INSERT INTO gofl_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Iwu yelo qammi gakiya wode, I ulon mente nayti de7eysi eretis. ");
INSERT INTO gofl_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Iya maaretishin, entafe issoy ba kushiya kessin yelisiyara, “Haysi koyro keyis” gaanaw zo7o qacina ekada iya kushen qachasu. ");
INSERT INTO gofl_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Shin I ba kushiya guye ekida wode, iya ishay keyin iya, “Neeni waanada porxu gada keyadii?” yaagasu. Hessa gisho, Paaresa (Porxu gis) gada sunthasu. ");
INSERT INTO gofl_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Hessafe guye, iya kushiyan zo7o qacini de7iya iya ishay yeletis. Iya sunthay Zaara (Zo7o) geetetis. ");
INSERT INTO gofl_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Isma7eela asati Yoosefa Gibxe biitta efidosona. Gibxe kawa moorinatape issuwas, kawa naageysata halaqaas Yoosefa bayzidosona. ");
INSERT INTO gofl_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Goday Yoosefara de7iya gisho, I oothiyaba ubbaa iyaw injeyis. Yaatin, ba Gibxe godaa son de7is. ");
INSERT INTO gofl_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Goday iyara de7eysanne I oothiyaba ubbaa iyaw injeyidaysa Phoxfaari be7ida wode, ");
INSERT INTO gofl_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Yoosefa dosis, baw mata oosancho oothis. Phoxfaari iya ba keetha bollanne baw de7iyaba ubbaa bolla shuumis. ");
INSERT INTO gofl_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","He wodepe doomidi, Goday Gibxe ura keetha Yoosefa gisho anjis. Godaa anjoy Phoxfaara sooninne iya gaden de7iyaba ubbaa bolla wodhis. ");
INSERT INTO gofl_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","I miya kathiw eriyaripe attishin, baw de7iya haraba ubbaa Yoosefa kushen sheedhis. Yoosefi yegelsinne mala lo77o asi. ");
INSERT INTO gofl_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Guutha wodepe guye, iya godaa machiya Yoosefa be7ada, “Haaya, taara zin7a” yaagasu. ");
INSERT INTO gofl_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Shin I ixidi, iiko, “Be7a, ta goday, baw de7iyaba ubbaa ta kushen yeggida gisho, ba son de7iyabas aykoka hirgenna. ");
INSERT INTO gofl_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Ha son taape aadhey oonika baawa. Neeni iya macho gidiya gisho, neepe attishin, haraa, I taw immonabay baawa. Yaatin, taani waatada haysa mela daro iitaba hanada Xoossa bolla nagara ootho?” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Iya he odaa wonta wonta Yoosefas odinka, I iira aqonna woyko I mata shiiqona ixis. ");
INSERT INTO gofl_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Shin issi gallas I ba ooso oothanaw soo geliya wode, soo aylletape oonika son baawa. ");
INSERT INTO gofl_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Iya Yoosefa afila oykada, “Taara zin7a” yaagasu. Shin I ba afila I kushiyan yeggi aggidi, soope kare woxi keyis. ");
INSERT INTO gofl_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Yoosefi ba afila I kushiyan yeggi aggidi, soope kare woxi keydaysa iya be7ida wode, ");
INSERT INTO gofl_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","ba soo aylleta xeegada, “Heko, ta azinay ehida ha Ibraawe uray tana kawushshanaw oykis. I tana iissanaw ta de7iyasuwa gelis, shin taani waassas. ");
INSERT INTO gofl_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","I ba afila ta matan yeggi aggidi, soope kare woxidi keyis” yaagasu. ");
INSERT INTO gofl_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","I azinay soo yaana gakanaw iya Yoosefa afila ba matan wothasu. ");
INSERT INTO gofl_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","I yin, iyaw haysada gada odasu; “Haysi ne ehida Ibraawe aylley tana iissanaw taako gelis. ");
INSERT INTO gofl_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Shin taani waassin, ba afila ta matan yeggi aggidi, soope kare woxi keyis” yaagasu. ");
INSERT INTO gofl_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Iya goday hanidaba si7ida wode daro yilotis. ");
INSERT INTO gofl_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Iya goday Yoosefa efidi, kawa qasho asay de7iya qasho keethan yeggis. ");
INSERT INTO gofl_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Shin Yoosefi qasho keethan de7iya wode, Goday iyara de7ees. Ba keehatetha iyaw darsidi, qasho keetha kaapuwa sinthan iyaw saba immis. ");
INSERT INTO gofl_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Yaanin, qasho keetha kaapoy qasho asa ubba Yoosefa kushen yeggis. Yan oosetiyaba ubbaas aawatetha immis. ");
INSERT INTO gofl_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Goday Yoosefara gididi, I oothiyaba ubbaa iyaw injeyida gisho, qasho keethaa kaapoy Yoosefa kushen de7iyabas aykoka hirgenna. ");
INSERT INTO gofl_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Guutha wodepe guye, Gibxe kawa ushsha kaapoynne katha kaapoy banta godaa, Gibxe kawa naaqidosona. ");
INSERT INTO gofl_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Kawoy he nam7u kaapota bolla daro yilotidi, ");
INSERT INTO gofl_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Yoosefi qashetida, qasho keetha naageysata kaapuwa son enta qachis. ");
INSERT INTO gofl_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Naageyseta halaqay enta Yoosefas sheedhis, ika entaw kiitetees. Enti qasho keethan daro wode uttidosona. ");
INSERT INTO gofl_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Gibxe kawa ushsha kaapoynne katha kaapoy, qasho keethan de7ishe nam7ayka issi qamma dumma dumma amuho amuhidosona. He amuhotas dumma dumma birshethay de7ees. ");
INSERT INTO gofl_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Yoosefi wonta entako geliya wode enti azzanidi uttidashin be7is. ");
INSERT INTO gofl_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","I entana, “Hachi hinte som7oy ayis dhumidee?” yaagidi oychis. ");
INSERT INTO gofl_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Enti, “Nu nam7ayka amuho amuhida, shin nuus birshiya asi dhayis” yaagidosona. Yoosefi entako, “Amuho birshiya eratethay Xoossaba gidenneyee? Ane hinte amuhuwa taw odite” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Yaatin ushsha kaapoy ba amuhuwa Yoosefas odis; “Taani ta amuhon issi woyne ta sinthan be7as. ");
INSERT INTO gofl_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","He woyniyas heedzu tasheti de7oosona. I hayxidi, ciiyi simmidi teeris. ");
INSERT INTO gofl_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Kawo wanci ta kushen de7ees. Taani woyne teera ekada iyan gum7ada, he wanca kawa kushen wothas” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Yoosefi, “Ha amuhuwa birshethay haysa; heedzu tasheti heedzu gallasata. ");
INSERT INTO gofl_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Heedzu gallasata giddon Kawoy nena qashope billana. I nena kase shuumatethaako zaarana. Kase neeni ushsha kaapo gidada ootheysada neeni kawa wanca iya kushiyan wothana. ");
INSERT INTO gofl_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Shin new sa7i lo77ida wode tana dogopa; taw keeha. Tabaa kawas odada, ha qasho keethafe tana kesisa. ");
INSERT INTO gofl_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Tana Ibraawe biittafe wolqan ehidosona. Hari attoshin, haysan tana qashos gathiyaba aybibaaka oothabike” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Kathaa kaapoy Yoosefi amuhuwa loythidi birshidaysa be7ida wode Yoosefako, “Taani amuhida amuhoy haysa; ta huuphen heedzu gabate uythi de7ees; ");
INSERT INTO gofl_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","bolla bagga gabatiyan Gibxe kawas dumma dumma katha qommofe uuketida uythay de7ees. Shin kafoti he ta huuphen de7iya gabatiyape moosona” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Yoosefi, “He amuhuwa birshethay haysa; heedzu gabateti heedzu gallasata. ");
INSERT INTO gofl_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Heedzu gallasa giddon Kawoy nena qashope billana. Ne qoodhiya qanxisidi mithan kaqisana; ne ashuwaka kafoy maana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Heedzantho gallasan Gibxe Kawoy ba yeletida gallasan ba moorinnata ubbaas gibira giigisis. Ushsha kaapuwanne katha kaapuwa billi ehidi ba asa sinthan essis. ");
INSERT INTO gofl_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Ushsha kaapuwa iya shuumatethaako zaarin, I kawa kushiyan wanca wothis. ");
INSERT INTO gofl_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Shin Kawoy kathaa kaapuwa kaqisis. Ubbayka Yoosefi enta amuhuwa birshidaysada hanis. ");
INSERT INTO gofl_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Shin ushsha kaapoy Yoosefa hassayonna dogi aggis. ");
INSERT INTO gofl_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Nam7u laythafe guye, Gibxe Kawoy amuho amuhis. He amuhuwan I Nayle Shaafa gaxan eqis. ");
INSERT INTO gofl_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Laapun ordenne modho miizati Nayle Shaafape keyidi, maata mishin be7is. ");
INSERT INTO gofl_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Entafe kaallidi, hara laapun gilqa miizati Nayle Shaafape keyidi, shaafa gaxan de7iya hara miizata matan eqidosona. ");
INSERT INTO gofl_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","He gilqa miizati laapun ordenne modho miizata mittidosona. Hessafe guye, Kawoy barkis. ");
INSERT INTO gofl_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","I zaari dhiskidi, hara amuhoka amuhis. Laapun lo77onne muruuta mor7eti issi maqa bolla keyidosona. ");
INSERT INTO gofl_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Entafe kaallidi, lee7onne doloha bagga carkon shullida hara laapun mor7eti keyidosona. ");
INSERT INTO gofl_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","He lee7ida mor7eti lo77onne muruuta mor7eta mittidosona. Hessafe guye, Kawoy barkidi amuho gideysa eris. ");
INSERT INTO gofl_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Sa7ay wontin dhiskofe I dendiya wode iya wozanay yarkis. Hessa gisho, Gibxen de7iya bitanchotanne eranchota ubbaa kawoy xeegisidi entaw ba amuhuwa odis. Shin iyaw he amuhuwa birshiya asi dhayis. ");
INSERT INTO gofl_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Ushsha kaapoy he wode Gibxe kawako, “Taani ta naaquwa hachi hassayayis. ");
INSERT INTO gofl_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Issi wode Kawoy ba aylleta hanqetidi, tananne kathaa kaapuwa qasho keethan yeggis. ");
INSERT INTO gofl_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Yan de7ishe nu nam7ati amuho amuhida. He amuhotas dumma dumma birshethay de7ees. ");
INSERT INTO gofl_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","He wode naageysata kaapuwa aylley, Ibraawe panthay, nuura qashon de7ees. Nuuni nu amuhuwa iyaw odin, I nuus huuphen huuphen amuhuwa billis. ");
INSERT INTO gofl_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Yaanin, he hanoti I nuus billidaysada hanidosona. Hessi aybe giiko, taani ta shuumatethaako simmas, hankoy kaqetis” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Yaatin, Gibxe Kawoy Yoosefa xeegisis. Enti iya qasho keethafe ellesidi ehidosona. I meedetidi ba ma7uwa laammidi, kawako gelis. ");
INSERT INTO gofl_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Kawoy Yoosefa, “Taani amuho amuhas, shin taw issi asika billanaw danda7ibeenna. Taani, ne amuho billanaw danda7eysa si7as” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Yoosefi, “Taani hessa danda7ike, shin Xoossay kawas lo77onne like birshethi immana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Kawoy, “Taani ta amuhora Nayle Shaafa gaxan eqidashin, ");
INSERT INTO gofl_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","laapun ordenne modho miizati Nayle Shaafape keyidi, maata moosona. ");
INSERT INTO gofl_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Entafe kaallidi, hara laapun gilqanne laafida miizati keyidosona. Taani hessa mela gilqa miizi Gibxe biittan ubbaka be7a erike. ");
INSERT INTO gofl_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","He gilqanne laafida miizati koyro keyida laapun modho miizata mittidosona. ");
INSERT INTO gofl_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Shin enta mittidaape guye kaseysada gilqi uttida gisho, enti mittidaba oonika eranaw danda7ibeenna. Hessafe guye, taani barkas. ");
INSERT INTO gofl_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“Taani ta amuhuwan qassi laapun lo77onne muruuta mor7eti issi maqa bolla keydaysata be7as. ");
INSERT INTO gofl_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Entafe kaallidi, lee7onne doloha bagga carkuwan shullida hara laapun mor7eti keyidosona. ");
INSERT INTO gofl_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","He lee7ida mor7eti laapun lo77o mor7eta midosona. Taani ha amuhuwa bitanchotas odas, shin taw amuhuwa birshiya asi bentibeenna” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Hessafe guye, Yoosefi Gibxe kawako, “kawa amuhota birshethay issino. Xoossay ba oothana haniyaba kawas qoncisis. ");
INSERT INTO gofl_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","He laapun lo77o miizati laapun laythata, qassi laapun lo77o mor7eti laapun laythata, ha amuhota birshethay issino. ");
INSERT INTO gofl_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","He laapun gilqanne laafida miizati laapun laythata, qassi doloha bagga carkuwan shullida, lee7o laapun mor7eti laapun kosha laythata. ");
INSERT INTO gofl_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","“Taani kawas odidaysadaka, Xoossay ba oothana haniyaba kawa bessis. ");
INSERT INTO gofl_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Laapun daro kalo laythati Gibxe biitta ubban yaana. ");
INSERT INTO gofl_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Shin hessafe guye, laapun kosha laythati kaallidi yaana. He wode Gibxe kaaloy ubbay dogetana, koshi biitta caacana. ");
INSERT INTO gofl_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Koshay daro iita gidiya gisho he biitta kaaloy dogetidi attana. ");
INSERT INTO gofl_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Nam7u ogiyan kawas he amuhoy bentiday Xoossay ba qopidaba oothanaw qanxida gishosa. Hessa Xoossay mata woden oothana. ");
INSERT INTO gofl_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Ha7i hiza, neeni eranchonne cinca asi koyada Gibxe biittan shuuma. ");
INSERT INTO gofl_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Laapun kalo laythan kaxiya kathaafe ichashu kushiyape issuwa shiishana asata shuuma. ");
INSERT INTO gofl_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Enti yaa kalo laythan kathaa shiishidi, banta aawatethan kataman kataman minjidi wothana mela kiita. ");
INSERT INTO gofl_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Biittay koshan dhayona mela ha kathay Gibxe biittan laapun laythan dendana koshas minjetidi de7o” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Yaatin he oday Gibxe kawasinne iya moorinnatas lo77o gididi bentis. ");
INSERT INTO gofl_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Hessa gisho, Kawoy entako, “Yoosefape aadhiya hara Xoossa Ayyaanara de7iya asi demmanaw danda7oko” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Hessafe guye Kawoy Yoosefa, “Xoossay haysa ubba nena erisida gisho, ne mela eranchoynne cinca asi oonika baawa. ");
INSERT INTO gofl_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Taani nena ta biittan shuumas. Ta asa ubbay new kiitetana. Taape hari neepe aadhiya oonika baawa. ");
INSERT INTO gofl_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Heko, taani nena Gibxe biitta ubba bolla shuumas” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Hessafe guye, Kawoy ba paramiya migiduwa ba biradhiyafe kessidi, Yoosefa biradhen aathis. Boncho ma7onne qoodhe worqa iya mayzis. ");
INSERT INTO gofl_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Kawoy ba nam7antho para gaariya Yoosefa togisis. Boncho wotaadarey, “Ziggite! Ziggite!” yaagishe iyape sinthara hemetees. Hessada oothidi, kawoy iya Gibxe biitta ubbaa bolla shuumis. ");
INSERT INTO gofl_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Hessafe guye Kawoy Yoosefa, “Taani kawo gidikoka ne kiittonna oonika Gibxe biitta ubban ba kushiya woyko ba tohuwa qaaxofo” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Kawoy Yoosefa, “Xafnaat-Pa7ina” gidi sunthis. I iyaw Ona katama kahiniya Phoxfaara na7iw Asnaato macho immis. Yaanin, Yoosefi Gibxe biitta ubbaa bolla maata ekis. ");
INSERT INTO gofl_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Yoosefi Gibxe kawas ooso oykiya wode, iyaw laythi hastama. Yoosefi kawa sinthafe keyidi, Gibxe biitta ubbaa giddon hemetis. ");
INSERT INTO gofl_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","He laapun kalo laythan biittan daro kathi kaxis. ");
INSERT INTO gofl_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Yoosefi Gibxe biittan he laapun kalo laytha katha ubbaa shiishidi, katamatan minjis. Issi issi katama yuushuwan de7iya gadiyape katha ubbaa he katamatan shiishis. ");
INSERT INTO gofl_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Yoosefi abba shafiya mela daro katha shiishis. Katha darotethaafe dendoysan makanaw danda7etibona gisho, maki maki qoleysa aggaagis. ");
INSERT INTO gofl_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Kosha laythi yaanape sinthe, Ona katama kahine Phoxfaara na7e Asnaatipe Yoosefi nam7u adde nayta yelis. ");
INSERT INTO gofl_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Yoosefi ba bayra na7aa sunthaa, “Xoossay tana ta metuwanne ta aawa soo asa ubbaa dogisis” gidi Minaase gidi sunthis. ");
INSERT INTO gofl_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Nam7antho na7aa sunthaaka, “Xoossay ta metootida biittan taw na7a immis” gidi Efreema gidi sunthis. ");
INSERT INTO gofl_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Gibxe biittan de7iya he laapun kalo laythati aadhidosona. ");
INSERT INTO gofl_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Yoosefi odidaysada laapun kosha laythati kaalli yidosona. Hara biitta ubban koshi keyis, shin Gibxe biitta ubban kathay de7ees. ");
INSERT INTO gofl_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Gibxe biittay ubbay koshatida wode, asay kathas kawako waassidosona. Kawoy Gibxe asa ubba, “Yoosefako bidi, I odeysa oothite” yaagidi kiittis. ");
INSERT INTO gofl_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Koshay Gibxe biitta ubba gakida wode, Yoosefi katha minjida shaaleta ubba dooydi, kathi Gibxe asaas bayzis. ");
INSERT INTO gofl_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Biitta ubban koshi suullida gisho, sa7an de7iya asa ubbay kathi Yoosefape shammanaw Gibxe yidosona. ");
INSERT INTO gofl_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Yayqoobi Gibxen kathi de7eysa si7ida wode ba adde nayta, “Hinte issoy issuwa ayis xeelleetii? ");
INSERT INTO gofl_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Gibxen kathi de7eysa taani si7as; yaa bidi, nuuni hayqonna mela guutha kathi shammite” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Yaatin, Yoosefa ishati tammati kathi shammanaw Gibxe bidosona. ");
INSERT INTO gofl_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Shin Yayqoobi I qohetana gidi hirgida gisho Yoosefa isha Biniyaame iya ishatara yeddibeenna. ");
INSERT INTO gofl_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Kanaane biittan wolqaama koshi de7iya gisho, kathi shammanaw beysatara Isra7eele adde nayti Gibxe gelidosona. ");
INSERT INTO gofl_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","He wode Yoosefi he biitta aysiya gisho biittan de7iya asa ubbaas kathi bayzees. Hessa gisho, Yoosefa ishati yaa gakida wode banta som7uwa sa7a gathidi iyaw ziggidosona. ");
INSERT INTO gofl_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Yoosefi ba ishata be7ida melaka eri aggis. Shin I enta eronna asada hanidi; entako, “Hinte awupe yideti?” yaagidi oychis. Enti, “Kathi shammanaw, Kanaane biittafe yida” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Yoosefi ba ishata eris, shin enti iya eribookona. ");
INSERT INTO gofl_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Yoosefi entaba amuhida ba amuhuwa akeekidi entako, “Hinte wochanaw yida asi, hinte nu biittan naagoy lepiya baggay awuneko be7anaw yideta” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Enti, “Akay, nu godaw, nuuni wochanaw yida asi gidoko. Nuuni ne aylleti kathi shammanaw yida. ");
INSERT INTO gofl_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Nuuni ubbayka issi aawa nayta. Nuuni ne aylleti ammanetiya asi” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Yoosefi entako, “Akay, hinte nu biittan naagoy lepiya baggay awuneko be7anaw yideta” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Shin enti, “Nuuni ne aylleti Kanaane biittan de7iya issi ura nayta; nuuni tammanne nam7u ishanta. Wursetha kaaloy ha7i nu aawara son de7ees, issoy hayqis” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Yoosefi entako, “Taani hintew odidaysada hinte biitta wocheyisata. ");
INSERT INTO gofl_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Hinte paacetanaysi haysana; tuma Kawoy hayqo, hinte wursetha kaalo ishay haysa yoona ixiko, hinte ha bessaafe beeketa. ");
INSERT INTO gofl_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Hinte odeysi tuma gideysa paacanaw, hintefe issuwa kiittite. I hinte isha ekidi yo, attidaysati qasho keethan gam7eeta. Hessi hanona ixiko, Kawoy hayqo, hinte biitta wocheyisata” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Entana heedzu gallas qasho keethan qachis. ");
INSERT INTO gofl_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Heedzantho gallasan Yoosefi entako, “Taani Xoosse yayiya asi. Yaaniya gisho, hinte issiba oothiko hinte shempuwa ashshana. ");
INSERT INTO gofl_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Hinte tumaka ammanetiya ase gidiko, hinte ishatape issoy haysan qasho keethan de7o; attidaysati koshatiya hinte soo asaas kathi efite; ");
INSERT INTO gofl_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Shin hinte wursetha ishaa taako ehiko, hinte qaalay tumatana; hinteka hayqonna attana” yaagis. Entika iya oda ero gidi ekidosona. ");
INSERT INTO gofl_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Enti issoy issuwako, “Tuma nuuni nu ishas oothidabay nuna kaa7ees. I ba shempuwas watwatidi woossiya wode nuuni si7ishe ixida. Hessa gisho, ha waayey nuna gakis” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Robeeli, “Taani hintena, na7aa bolla nagara oothopite gada odas, Shin hinte si7onna ixideta. Ha7i iya suuthay nuna achees” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Yoosefi entara turjumaanen odetiya gisho enti giyaba I ereysa enti akeekibokona; ");
INSERT INTO gofl_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","I entafe haraso bidi yeekis. Shin zaari entako yidi, entaw gujidika odis. I Simoona enta giddofe kessidi enti be7ishin qachis. ");
INSERT INTO gofl_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Yoosefi ba aylleta, “Katha enta ogoruwan kunthite; enta miishiyaka zaaridi, enta ogoruwan ogoruwan yeggite. Entaw oges shinqeka immite” yaagidi kiittis. ");
INSERT INTO gofl_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Enti I gidaysada oothidaape guye, Yoosefa ishati katha banta hareta bolla caanidi bidosona. ");
INSERT INTO gofl_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Enti qamma aqiya bessan entafe issoy ba hariyas kathaafe yegganaw ba ogoruwa billidi, he ogoruwa doonan de7iya ba miishiya demmis. ");
INSERT INTO gofl_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","I ba ishatako, “Ta miishey taw simmis; tuma haysa be7ite; Ta ogoruwan de7ees” yaagis. Enti dagammidi kokorishe, issoy issuwako simmidi, “Xoossay nu bolla oothidabay haysi aybee?” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Enti Kanaane biittan de7iya banta aawa Yayqoobako yidi, bantana gakidaba ubbaa iyaw odidosona. ");
INSERT INTO gofl_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Enti iyako, “He biitta haariya uray, nuna he biitta wochiya asada oothidi nu bolla yilotidi odetis. ");
INSERT INTO gofl_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Shin nuuni iyako, ‘Nuuni ammanetiya asi, biitta wocheyisata gidoko. ");
INSERT INTO gofl_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Nuuni tammanne nam7u ishanti issi aawa nayta. Issoy hayqis; wursetha kaaloy Kanaane biittan ha7i nu aawara de7ees’ yaagida. ");
INSERT INTO gofl_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Yaatin he biitta haariya uray nuna, ‘Hinte ammanetiya ase gideysa taani erana mela hinte ishatape issuwa haysan ta matan aggidi, koshatiya hinte soo asaas kathi ekidi biite. ");
INSERT INTO gofl_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Hinte biitta wocheyisata gidonna, ammanetiya asi gideysa taani erana mela, hinte wursetha isha taako ekidi yiite. Yaatiko, taani han attida hinte ishaa hintew zaarada immana. Hinteka ha biittan de7idi zal7anaw danda7eeta’ ” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Enti banta ogoruwape kathaa qolishe, banta ogoruwan ogoruwan banta miishiya qashuwara uttidaysa demmidosona. Entinne enta aaway he qashuwara de7iya miishiya be7idi yayyidosona. ");
INSERT INTO gofl_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Enta aawa Yayqoobi entako, “Hinte tana ta naytape mela ashshideta. Yoosefi baawa, Simooni baawa, ha7i qassi Biniyaame efanaw koyeeta. Ubbabay taw zoko zaaris” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Hessafe guye Robeeli ba aawako, “Taani Biniyaame new zaarada ehonna ixiko, ta adde nayta nam7aaka wodha. Tana ammanetada iya ta kushen yegga; taani iya zaarada ehana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Shin Yayqoobi entako, “Ta na7ay hintera beenna; iya ishay hayqin, attiday iya xalaala. Hinte efishin, ogen iitabay iya gakiko, hinte ta cimatetha afuthu muzishe ta hayquwa matayeta” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Kanaane biittan koshay ha77ika kaseysafe aadhidi wolqaamis. ");
INSERT INTO gofl_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Yaanin, enti Gibxefe ehida katha ubba midi ongin, enta aaway, “Qassika Gibxe bidi nuus guutha kathi shammite” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Shin Yihudi, “He uray nuna, ‘Hinte ishay hintera yoona ixiko, ta som7uwa zaari be7eketa’ yaagidi minthidi odis. ");
INSERT INTO gofl_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Neeni nu isha nuura yeddiko, nuuni Gibxe bidi new kathi shammana. ");
INSERT INTO gofl_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Shin he uray, ‘Hinte ishay hintera yoona ixiko hinte ta som7uwa zaari be7eketa’ ” yaagida gisho, neeni iya yeddonnaba gidiko nuuni booko. ");
INSERT INTO gofl_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Yaatin Isra7eeley, “Hinte, ‘Nuus hara ishi de7ees’ gidi odidi ha metuwa ta bolla ayis ehidetii?” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Enti zaaridi, “He uray nubaanne nu soo asaaba minthidi oychis. I nuuko, ‘Hinte aaway paxa de7ii? Hintew hara ishi de7ii?’ yaagidi oychis. Nuuni I oychidaysa iyaw zaarida. I nuna, ‘Hinte isha eki yiite’ gaanaba nu awude erido?” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Yihudi ba aawa Isra7eeleko, “Nuuni, neeninne nu nayti koshan hayqanaape na7aa taara yedda, nuuni baana. ");
INSERT INTO gofl_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Na7a ta waasetethan imma; iyabaa tana oycha. Taani iya new saro zaarada ehonna ixiko, ta de7o ubban ne baadethay tana gako. ");
INSERT INTO gofl_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Nu gam7onaba gidiyako, hannoode nam7antho yaa simmana shin” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Enta aaway Isra7eeley, “Hessa gidiko haareysas kushe genthiyaba, ha biittan kaxiyaba ubbaafe lo77oba doorite. Hessika, qibaate, shitto, dumma dumma sawo, eessinne, ocholone hinte ogoruwan yeggidi, ekidi biite. ");
INSERT INTO gofl_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Hinte ogoruwa doonan simmida miishey baletidaba gidanaw danda7iya gisho, miishiya nam7u kushe oothidi eki biite. ");
INSERT INTO gofl_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Hinte ishaa ekidi, he uraako ellesidi guye biite. ");
INSERT INTO gofl_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","I hanko hinte ishaanne Biniyaame hintera yeddana mela Ubbaa Danda7iya Xoossay he uray hintew qadhetanada ootho. Tana gidiko, ta naytape mela attikoka attas” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Hessa gisho, ishanti wolla banta immiyabata, nam7u kushe miishiyanne Biniyaame bantara ekidi bidosona. Enti Gibxe gakidi, Yoosefa sinthe shiiqidosona. ");
INSERT INTO gofl_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Yoosefi Biniyaame entara be7ida wode ba keetha kaapuwako, “Ha asata ta soo ekada ba. Issi mehe shukada giigisa; enti kathi taara maana” yaagidi kiittis. ");
INSERT INTO gofl_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Yaatin kaapoy, Yoosefi kiitidaysada he asata iya soo efis. ");
INSERT INTO gofl_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Enti Yoosefa soo bishe, yayidi, “Enti nuna haysa ehiday koyro nu ogoruwan simmida miishiya gisho gidonna aggenna. Enti nuna qohidi aylletethan haaronnanne nu hareta ekona aggokona” yaagi hirgidosona. ");
INSERT INTO gofl_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Hessa gisho, enti Yoosefa soo penge gakidi, keetha kaapuwa odisidosona. ");
INSERT INTO gofl_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Godaw, nuuni koyro kathi shammanaw haysa yida. ");
INSERT INTO gofl_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Guye simmishe nuuni qamma aqiya bessan ogoruwa billiya wode huuphen huuphen nu miishey paconna nu ogoruwan de7eysa demmida. Heko, nuuni he miishiya guye eki yida. ");
INSERT INTO gofl_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Ha7i nuuni katha shammanaw hara miishe oyki yida. Nu miishiya nu ogoruwan ooni yeggidaako eroko” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","I zaaridi, “Aykoy baawa, yayofite; hinte Xoossay, hinte aawa Xoossay, hinte ogoruwan hintew miishe immis. Taani hinte ciggida miishiya kumethi ekas” yaagis. Hessafe guye, Simoona entako kessis. ");
INSERT INTO gofl_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","He uray he asata Yoosefa soo efidi, enta tohuwas haathe ehin, enti meecetidosona. Enta haretasika miyaba yeggis. ");
INSERT INTO gofl_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Enti Yoosefara kathi maanaysa si7ida gisho banta immanabata Yoosefas giigisidosona. ");
INSERT INTO gofl_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Yoosefi ba soo gelida wode enti ehida banta immiyabata iyaw immidi, iya sinthan sa7a gakidi ziggidosona. ");
INSERT INTO gofl_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","I enta sarotetha oychi simmidi, “Hinte taw odida hinte cimida aaway lo77o de7ii? Ha77ika I paxa de7ii?” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Enti, “Ee, ne aylley, nu aaway paxa de7ees; I lo77o” yaagidi, hokidi iyaw ziggidosona. ");
INSERT INTO gofl_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","I ba aaye na7aa Biniyaame be7ida wode entako, “Hinte odida wursetha hinte ishay haysee?” yaagis. Biniyaame, “Ta na7aw, nena Xoossay anjo” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Yoosefi, iya ishaabay iyaw gompan seellida gisho, ellesidi, qol7a gelidi yan yeekis. ");
INSERT INTO gofl_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","I ba som7uwa meecetidaape guye keyidi bana minthethidi, kathi aathana mela kiittis. ");
INSERT INTO gofl_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Enti Yoosefas dumma, iya ishatas dumma aathidosona. Gibxe asay Ibraawe asatara issife meysi bantana kawushiyaba oothi xeelliya gisho iyara miya Gibxe asatas dumma aathidosona. ");
INSERT INTO gofl_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Enti Yoosefa sinthan bayray ba bayratethan, kaaloy ba kaalotethan maaran uttidosona. Enti issoy issuwa xeellidi, enta waatidi utisidaako be7idi malaaletidosona. ");
INSERT INTO gofl_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Yoosefa gaytape entaw qumi gishetees, shin Biniyaames haratape aathidi ichashu kushe immis. Yaanidi, enti Yoosefara midi uyidi ufaytidosona. ");
INSERT INTO gofl_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Yoosefi ba keetha kaapuwa, “Neeni ha asati tookanaw denda7ida keena enta ogoruwan kathi kuntha. Enta ubbaa miishiya enta ogoruwa doonan doonan yegga. ");
INSERT INTO gofl_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Yaatada wursetha kaaluwa ogoruwa doonan ta bira wancaanne I shammanaw ehida miishiya yegga” yaagidi kiittis. I Yoosefi gidaysada oothis. ");
INSERT INTO gofl_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Sa7i wontin he asati banta hareta ekidi baanaw dendidosona. ");
INSERT INTO gofl_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Enti he katamaape keyidi haaki boonna de7ishin, Yoosefi ba keetha kaapuwako, “Ha asata geedo kaalla. Neeni enta gakida wode entako, ‘Hinte ayis keeha iitan zaaridetii? ");
INSERT INTO gofl_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Haysi ta goday uyeysanne xuuraba demmiya wanca gideysa ereketii? Ayis kaysotidetii? Haysi hinte oothidabay daro iitaba’ yaaga” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Yaatin I enta geedo kaali gakidi, he gidaysadaka entaw odis. ");
INSERT INTO gofl_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Shin enti, “Godaw haysa melaba ayis odetay? Hessa melaba oosoy nuupe ne aylletape haako. ");
INSERT INTO gofl_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Nuuni hari attoshin, nu ogoruwa doonape demmida miishiya Kanaane biittafe guye zaaridi new ehidaysa eraasa. Ne godaa keethaafe nuuni worqa woyko bira waati kaysotanee? ");
INSERT INTO gofl_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Ne aylleta giddon he wancay bentida uray hayqo. Qassi attida nuka nu godaas aylle gidana” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","I entako, “Hessa gidiko lo77o, hinte gidaysada hano. Wanca ekida oonika ta aylle gidana; attidaysati saron beeta” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Hessafe guye, enti ellesidi banta ogoruwa ogoruwa sa7an wothidi billidosona. ");
INSERT INTO gofl_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","He kaapoy ubbaafe bayra ogoruwape doomidi wursetha kaaluwaysa gakanaw koyidi, he wanca Biniyaame ogoruwape demmis. ");
INSERT INTO gofl_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Hessan enti azzanidi, banta ma7uwa peedhidosona. Banta ogoruwa hareta bolla caanidi, guye katama simmidosona. ");
INSERT INTO gofl_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Yihudi ba ishatara Yoosefako geliya wode Yoosefi son de7ees; enti iya sinthan sa7an gufannidosona. ");
INSERT INTO gofl_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Yoosefi entako, “Hinte aybi palaba oothidetii? Ta mela asi xuuraba demmanaw danda7eysa hinte ereketiyee?” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yihudi, “Ta godaas nuuni ay gaanee? Nuuni ay odetiyabay de7ii? Nu xillotetha nuuni waati bessanee? Xoossay ne aylleta naaquwa qoncisis. Hiza nuunika he wancay bentida urayka ta godaas aylle gidida” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Shin Yoosefi, “Hessa melaba oothanaysi taape haako; ta wancay iyape bentida ura xalaali ta aylle gidana. Hanko hinte hinte aawako guye saro simmite” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Yihudi iyako shiiqidi “Ta godaw, neeni kawa mela gidikoka taani neera odetanaw nena woossayis. Tana ne aylliya hanqetofa. ");
INSERT INTO gofl_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Neeni ta goday nuna ne aylleta, ‘Hintew aawi woyko ishi de7ii?’ gada oychadasa. ");
INSERT INTO gofl_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Nuunika, ‘Nuus cimida aaway de7ees. I cimatethan yelida kaalo na7ayka de7ees. He na7aa ishay hayqis, ba Aayen issino, iya aaway iya daro dosees’ yaagida. ");
INSERT INTO gofl_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","“Neeni nuuko, ‘Taani iya be7ana mela taw ehite’ yaagadasa. ");
INSERT INTO gofl_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Yaatin nuuni, ‘He na7ay ba aawape shaaketanaw danda7enna; shaaketiko iya aaway hayqana’ yaagida. ");
INSERT INTO gofl_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Shin neeni, ‘Hinte kaalo ishay hintera yoona ixiko, ta ayfiya zaari be7eketa’ yaagadasa. ");
INSERT INTO gofl_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Nuuni nu aawako simmidi bida wode ne gidaysa iyaw odida. ");
INSERT INTO gofl_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“Nu aaway, ‘Guye bidi guutha kathi shammite’ yaagin, ");
INSERT INTO gofl_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","nuuni iyako, ‘Nu kaalo ishay nuura boonna ixiko, ura ayfiya be7anaw danda7oko. Nu kaalo ishay nuura biyaba gidiko, nuuni yaa baana’ yaagida. ");
INSERT INTO gofl_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“Yaatin nu aaway nuna, ‘Ta machiya Raheela taw nam7u adde nayta yelidaysa hinte ereeta. ");
INSERT INTO gofl_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Entafe issoy taape shaaketidi bin, iya do7i moonna aggenna yaagas. Hachi gakanaw taani iya be7abike. ");
INSERT INTO gofl_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Haysa qassi taape hinte shaaki efin, iitabay iya gakiko, hinte tana ta cimatethan afuthu muzishe ta hayquwa matayeta’ ” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","“Hessa gisho, ha77i taani guye ta aawako biya wode Biniyaamey taara baanaw bessees. Ta aaway na7aa shempofe dosiya gisho, na7ay nuura baynaysa be7iko hayqana. Nuuni ne aylleti nu aawa cimatetha afuthan duufo gelsoos. ");
INSERT INTO gofl_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Taani ne aylley na7aa ta waasetethan ekas. Qassi, ‘Ta aawaw, taani iya new saro zaarada ehonna ixiko ta de7uwa ubban ne baadethay tana gako’ yaagas. ");
INSERT INTO gofl_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","“Yaaniya gisho, taani ne aylley na7aa gisho aylletada haysan attana na7ay ba ishatara guye simmo. ");
INSERT INTO gofl_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Na7ay bayna taani waanada guye ta aawako simmanee? Tana ta aaway seeletana seela bessofo” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","He wode Yoosefi ba aylleta sinthan gencanaw danda7iboona gisho, “Asa ubbaa ta sinthafe kessite” yaagidi waassis. Hessa gisho, Yoosefi ba ishatas bana erisida wode iyara oonika allagi baawa. ");
INSERT INTO gofl_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","I ba qaala dhoqu oothidi, Gibxeti iya si7ana gakanaw yeekis; kawa soo asayka he woriya si7idosona. ");
INSERT INTO gofl_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Yoosefi ba ishatako, “Taani Yoosefabay. Ta aaway hanno gakanaw paxa de7ii?” yaagidi oychis. Shin iya ishati daro dagammida gisho, iyaw aykoka zaaranaw danda7ibookona. ");
INSERT INTO gofl_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Yaanin, Yoosefi ba ishatako, “Taako haa shiiqite” yaagis. Enti iyako shiiqin I enta, “Taani hinte tana Gibxe biitta bayzida hinte ishaa Yoosefa. ");
INSERT INTO gofl_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Ha77i hinte tana bayzida gisho, qiirotofitenne hintena baaddofite. Ayis giiko, Xoossay tana hintefe sinthe kiitiday asa shempo ashshanaasa. ");
INSERT INTO gofl_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Ha biitta koshi gelin haysi nam7antho laythi. Asi goyonna woyko cakonna hara ichashu laythati buroo de7oosona. ");
INSERT INTO gofl_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Shin taani sa7an hinte sheeshanne hintena malaalsiya ogen ashshana mela Xoossay tana hintefe sinthe kiittis. ");
INSERT INTO gofl_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Hessa gisho, tana ha bessa kiittiday Xoossafe attishin, hintena gideketa. I tana Gibxe kawas zoriya aawa, iya aqo ubbaa bolla godanne Gibxe biitta haariya asi oothis. ");
INSERT INTO gofl_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","“Ha77i ellesidi guye ta aawako bidi iyako, ne na7ay Yoosefi haysada yaagees giite; ‘Xoossay tana Gibxe biitta ubbaa bolla godaa kessis; neeni gam7onna taako haaya. ");
INSERT INTO gofl_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Ne nayta, ne nayta nayta, ne dorsaa, ne deesha, ne mehiyanne new de7iyaba ubbaa ekada haaya; ta matan Geesame biittan de7aasa. ");
INSERT INTO gofl_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Buroo ichashu kosha laythati attidosona. Nena, ne soo asaanne ne mehiya koshi qohonna mela taani nena muzana’ ” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Qassika Yoosefi entako, “Hinteka, ta ishaa Biniyaameyka, ha hintera odetey tuma tana Yoosefa gideysa hinte ayfiyan be7ideta. ");
INSERT INTO gofl_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Taw Gibxe biittan de7iya gita bonchuwanne hinte be7idaba ubbaa ta aawas odite. Ta aawaka ellesidi haa ekidi yiite” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Yoosefara Biniyaamera nam7ay wolu qoomidi yeekidosona ");
INSERT INTO gofl_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Yoosefi yeekishe ba ishata ubbaa yeeris. Hessafe guye, iya ishati iyara odetidosona. ");
INSERT INTO gofl_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Yoosefa ishata yuussaa worey kawo keethi gakida wode kawoynne iya moorinnati ufaytidosona. ");
INSERT INTO gofl_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Kawoy Yoosefako, “Neeni ne ishatako yaaga; hinte hareta caanidi, Kanaane biitta simmite. ");
INSERT INTO gofl_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Hinte aawanne hinte soo asa ekidi, guye taako haa yiite. Taani hintew Gibxe biittan ubbaafe lo77iya bessa immiko, he biitta modhuwa hinte kaashana. ");
INSERT INTO gofl_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Qassika, banta nayta, banta machetanne banta aawa ehanaw Gibxefe gita para gaare eki baana mela enta kiita. ");
INSERT INTO gofl_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Gibxe biittan de7iya ubbaafe aadhidi lo77iyabay entassa gidiya gisho, banta aggidi yaa aquwas qoponna mela entaw oda” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Yaatin Isra7eele adde nayti kawoy gidaysada oothidosona. Yoosefi Kawoy kiitidaysada gita para gaaretanne oges shinqeka entaw immis. ");
INSERT INTO gofl_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Enta ubbaas huuphen huuphen ooratha ma7o immis. Shin Biniyaames tammanne usupun kilo giraame deexiya biranne ichashu kumetha ma7o immis. ");
INSERT INTO gofl_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","I ba aawas Gibxen de7iyabaape lo77iyaba ubbaa tammu adde haren caanidi, qassi oges kathi, uythinne hara kathi tammu macca haretan caanidi yeddis. ");
INSERT INTO gofl_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Yaatidi, Yoosefi ba ishata moyzishe, entako, “Ogiyan bishe ooyetofite” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Enti Gibxefe dendidi, Kanaane biittan de7iya banta aawa Yayqoobako simmidosona. ");
INSERT INTO gofl_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Enti Yayqoobako, “Yoosefi paxa de7ees. I hessafe aadhidi Gibxe biitta ubbaa haarees” yaagidosona. Yayqoobi dagammidi, wozana dhayda gisho, enti giyaba ammanibena. ");
INSERT INTO gofl_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Shin enti Yoosefi entaw odidaba ubbaa iyaw odin, qassika iya eki yaana mela I yeddida gita para gaareta I be7in iyaw shempoy simmis. ");
INSERT INTO gofl_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Isra7eeley, “Hiza ta ammanetas. Ta na7aa Yoosefi hanno gakanaw paxa de7ees. Ta hayqanaape sinthe bada iya be7ana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Isra7eeley baw de7iyaba ubbaa ekidi, Barsaabe gakida wode ba aawa Yisaaqa Xoossas yarsho yarshis. ");
INSERT INTO gofl_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Xoossay qamma Isra7eeles qoncidi, “Yayqooba, Yayqooba” yaagis. Ika, “Heko, abe Godaw” gidi koyis. ");
INSERT INTO gofl_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Xoossay iyako, “Taani Xoossaa, ne aawa Xoossa; neeni Gibxe baanaw babofa. Ta ne sheesha yan gita dere kessana. ");
INSERT INTO gofl_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Taani neera issife Gibxe baana; taani ne sheesha yaape kessada haa ehana. Ne hayqiya wode Yoosefi ne ayfiya oykana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Hessafe guye, Yayqoobi Barsaabepe dendis. Isra7eele adde nayti banta aawa Yayqooba, banta naytanne banta macheta Gibxe Kawoy entaw yeddida gita para gaare bolla uttisidi efidosona. ");
INSERT INTO gofl_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Enti Kanaane biittan haarida haaruwanne mehe ubbaa eki bidosona. Yayqoobi ba soo asa ubbaa ekidi Gibxe bis. ");
INSERT INTO gofl_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","I ba soo asa ubbaa; adde naytanne ba adde nayta nayta, ba macca naytanne ba macca nayta nayta, ubbaa baara ekidi Gibxe bis. ");
INSERT INTO gofl_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Isra7eelera Gibxe biitta bida iya nayta sunthay haysafe kaallidi xaafetidaysa. Yayqooba bayra na7ay Robeela; ");
INSERT INTO gofl_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Robeela adde nayti Hanooka, Pala, Hesiroonanne Karma. ");
INSERT INTO gofl_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simoona adde nayti Yamu7eela, Yamina, Ohada, Yakina, Xohaaranne Kanaane maccaseepe yelida Saa7ula. ");
INSERT INTO gofl_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Leewe adde nayti Gedisoona, Qahatanne Meraara. ");
INSERT INTO gofl_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Yihuda adde nayti Era, Onaana, Seela, Paaresanne Zaara. Shin Erinne Onani Kanaane biittan hayqidosona. Paaresa adde nayti Hesiroonanne Hamuula. ");
INSERT INTO gofl_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Yisakoora adde nayti Tola, Puu7a, Yoobanne Shimroona. ");
INSERT INTO gofl_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Zabloona adde nayti Sareda, Eloonanne Yahilaala. ");
INSERT INTO gofl_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Ha adde naytinne macca na7iya Diina, Liya Masephexoome biittan Yayqoobas yelidaysata. Diina gujin iya naytinne nayta nayti kumethi hastamanne heedza. ");
INSERT INTO gofl_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gaade adde nayti Xafoona, Hagge, Shuuna, Exiboona, Eri, Aroodanne Ar7eela. ");
INSERT INTO gofl_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Aseera adde nayti Yimina, Yesuwa, Yisiwanne Beri7a. Enta michiya Saraho. Beri7a adde nayti Hebeeranne Malki7eela. ");
INSERT INTO gofl_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Haysati Laabi ba na7e Liyas immida Zalafa Yayqoobas yelida nayta. Enti kumethi tammanne usupuna. ");
INSERT INTO gofl_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Yayqooba mache Raheeli adde nayti Yoosefanne Biniyaame. ");
INSERT INTO gofl_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Ona katama kahine Phoxfaara na7iya Asnaata Yoosefas Gibxen Minaasenne Efreema yelasu. ");
INSERT INTO gofl_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Biniyaame nayti Beella, Bekera, Asbeela, Geera, Naamane, Eha, Orosha, Mufima, Hufimanne Arada. ");
INSERT INTO gofl_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Haysati Yayqoobas yeletida Raheeli adde nayta. Enti kumethi tammanne oydda. ");
INSERT INTO gofl_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Daane adde na7ay Hushima. ");
INSERT INTO gofl_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Niftaaleme adde nayti Yahixeela, Guna, Yexeranne Shileme. ");
INSERT INTO gofl_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Haysati laapunati Laabi ba na7e Raheelis immida Baali Yayqoobas yelida naytanne nayta nayta. ");
INSERT INTO gofl_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Yayqoobara Gibxe bida, iya gulbatape keyida nayti, iya nayta macheta gujonna usupun tammanne usupuna. ");
INSERT INTO gofl_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Gibxen Yoosefas yeletida nam7u nayta gujiko, Gibxe bida Yayqooba soo asay kumethi laapun tamma. ");
INSERT INTO gofl_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Geesame biittan bantana mokana mela Yayqoobi Yihuda baape sinthe Yoosefako kiittis. Enti yaa gakiya wode, ");
INSERT INTO gofl_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yoosefi ba para gaariya giigisidi, ba aawa Isra7eelera gahetanaw Geesame bis. Yoosefi ba aawa demmida mela iya qoodhiyan xaaxetidi daro wode yeekis. ");
INSERT INTO gofl_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Isra7eeley Yoosefako, “Neeni paxa de7ishin, taani ne ayfiya be7ida gisho, hiza taani hayqikoka aykoy baawa” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Hessafe guye, Yoosefi ba ishatanne ba aawa soo asatako, “Taani Gibxe kawako bada iyako, ‘Kanaane biittan de7iya ta ishatinne ta aawa soo asay taako yidosona. ");
INSERT INTO gofl_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Enti mehe haareyisata, enti bantara banta dorsa, banta deesha, mehiyanne bantaw de7iyaba ubbaa ekidi yidosona’ yaagana. ");
INSERT INTO gofl_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Kawoy hintena xeegisidi, ‘Hinte oosoy aybee?’ gidi oychiko, ");
INSERT INTO gofl_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","hinte iyako, ‘Nuuni ne aylleti na7atethafe doomidi nu aawatada mehe heemmoos’ yaagite. Dorse haariya asi Gibxe asan kadhetidaba gidiya gisho, I hinte Geesame biittan daana mela oothana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","2","Yoosefi ba ishatape ichashata dooridi Gibxe kawako gelidi haysada yaagis; “Ta aawaynne ta ishati, banta dorsa, banta deesha, banta mehiyanne bantaw de7iyaba ubbaa ekidi Kanaane biittafe yidi, ha7i Geesamen de7oosona” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Kawoy he ishatako, “Hinte oosoy aybee?” yaagidi oychis. Enti kawako, “Nuuni ne aylleti nu aawatada dorse haariya asata” yaagidi zaaridosona. ");
INSERT INTO gofl_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Qassika enti iyako, “Kanaane biittan koshi keyida gishonne nu mehiyas miyabay dhayda gisho, nuuni haysan daanaw yida. Hayyana, nuna ne aylleta Geesame biittan de7o garki” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Kawoy Yoosefako, “Ne aawaynne ne ishati neeko yidosona. ");
INSERT INTO gofl_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Hiza Gibxe biittay ne kushena. Ha biittan ubbaafe aadhidi lo77iya bessan ne aawanne ne ishata wotha; enti Geesame biittan de7ona. Enta giddofe dumma qaratethi de7eysati de7iko, hessata ta mehiya bolla shuuma” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Hessafe guye, Yoosefi ba aawa Yayqooba gelsidi, kawa sinthe aathis. Yayqoobi Gibxe kawa anjidaape guye, ");
INSERT INTO gofl_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Kawoy Yayqooba, “New aapun laythee?” yaagidi oychis. ");
INSERT INTO gofl_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yayqoobi kawako, “Taani daabursan de7ida laythay xeetanne hastama. Ta laythay beni ta aawati daabursan de7ida laythafe guuthanne metoy darida laythi” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Hessafe guye, Yayqoobi kawa anjidi, iya sinthafe kare keyis. ");
INSERT INTO gofl_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Yoosefi kawoy kiitidaysada ba aawanne ba ishata Gibxe biittan Ramse katama matan de7iya ubbaafe aadhida arada biittan enta wothis. ");
INSERT INTO gofl_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Yoosefi ba aawas, ba ishatasinne baara de7iya ubbaas enta nayta taybuwada kathi immis. ");
INSERT INTO gofl_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Biitta ubban koshi suullida gisho biittan ubban kathi baawa; Gibxeynne Kanaane biittay qohetidosona. ");
INSERT INTO gofl_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Yoosefi Gibxe katha bayzidi, Gibxeninne Kanaane biittatan de7iya miishiya ubbaa shiishidi Gibxe kawa keetha gelsis. ");
INSERT INTO gofl_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Gibxe miisheynne Kanaane miishey wurida wode Gibxe asa ubbay Yoosefako yidi “Nuus kathi imma. Nu miishey wurida gisho nuuni ne sinthan ayis koshan hayqanee?” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Yoosefi entako, “Hinte mehiya eki yiite. Hinte miishey wuridaba gidiko, taani katha hinte mehiyara laammana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Hessa gisho, enti banta mehiya Yoosefas ehidosona. Yoosefi enta para, dorsa, deesha, miizanne hariya kathara laammis. I he laythi enta mehiya ubbara kathaa laammidi, enta muzidi shaachis. ");
INSERT INTO gofl_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Enti kaalliya laythan iyako yidi “Nuuni nu godaape qosiyabay baawa; nu miishey ubbay wuris. Nu mehiyaka new immi diggida. Nu bollafenne nu gadiyape attishin, nu godaas immanabay harabay baawa. ");
INSERT INTO gofl_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Nuuni ne be7ishin ayis koshan hayqanee? Nu gadeyka ayis dhayii? Nunaka nu gadiyaka shammada nuus kathi imma. Nuuni kawas aylletana, nu gadeyka iyabaa gido. Nuuni hayqonna attana mela nu gadeyka oxonna mela zerethi nuus imma” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Yoosefi Gibxe biitta ubbaa kawas shammis. Koshi suullin, Gibxe asay un7etidi banta gadiya bayzin gadey kawuwaba gidis. ");
INSERT INTO gofl_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Yoosefi asa ubbaa Gibxes ha gaxape hini gaxa gakanaw kawas aylle oothis. ");
INSERT INTO gofl_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Shin kawoy kahinetas kathi immiya gisho Yoosefi enta gadiya shammibeenna. Hessa gisho, banta gadiya bayzibokona. ");
INSERT INTO gofl_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Yoosefi asaako, “Hiza hachi taani hintenanne hinte gadiya kawas shammida gisho, zerethi efidi hinte gaden zerite. ");
INSERT INTO gofl_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Shin kathaa shiishiya wode ayfidabape ichashu kushiyape issi kushiya kawas immite. Attida oyddu kushey hinte gadiyas zerethi, hintewunne hinte soo asaas kathi gido” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Enti, “Neeni nuna ashshadasa. Nu godaa sinthan nuuni sabetiko, nuuni kawas aylletana” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Hessa gisho, Yoosefi Gibxe biittan ayfidabape ichashu kushiyape issuwa kawas immeysa higge kessis. He wogayka hachi gakana eqidi de7ees. Kahineta gadiyape attishin, hari ubbay kawuwaba gidis. ");
INSERT INTO gofl_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Isra7eeleti Gibxe biittan Geesame giya bessan de7idosona. Enti yan duretidosona; yeleti daridosona. ");
INSERT INTO gofl_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yayqoobi Gibxe biittan tammanne laapun laythi de7is. Yayqoobi de7ida laythay xeetanne oytamanne laapuna. ");
INSERT INTO gofl_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Isra7eeles hayqiya wodey matatin, ba na7aa Yoosefa xeegisidi haysada yaagis; “Taani ne sinthan sabetidaba gidiko, ne kushiya ta shempuwa bolla wotha. Neeni taw mishetiyaba gidiko tana Gibxen moogike gada taw caaqa. ");
INSERT INTO gofl_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Shin taani hayqiya wode tana Gibxefe efada, ta mayzati moogetidasuwan mooga” yaagis. Yoosefi, “Taani, nena ne gidaysada oothana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Yayqoobi iyako, “Ane taw caaqa” yaagis. Yoosefi iyaw caaqis. Hessafe guye, Isra7eeley ba guufiya bolla katidi Xoossaa goyinnis. ");
INSERT INTO gofl_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Hessafe guye asay, “Ne aaway saketees” yaagidi Yoosefas odidosona. I ba nam7u adde nayta Minaasenne Efreema ekidi ba aawa be7anaw bis. ");
INSERT INTO gofl_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Yayqoobi, iya na7ay Yoosefi yidaysa si7ida wode, Isra7eeley bana minthethidi hiixan uttis. ");
INSERT INTO gofl_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Yayqoobi Yoosefa, “Ubbaa Danda7iya Xoossay Kanaane biittan Looza kataman taw qoncidi, tana anjis. ");
INSERT INTO gofl_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","I tana, ‘Taani ne yeletetha darsana, nena daro dere oothana. Ha biitta taani neepe guye, ne sheeshas merina laata oothada immana’ ” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","“Hiza, ne nam7u adde nayti, taani neeko haa yaanape sinthe Gibxen new yeletidaysati tabaa. Efreemeynne Minaasey taw Robeela melanne Simoona mela. ");
INSERT INTO gofl_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Entafe guye yeletanaysati nebaa gido. Enti laattana biittay Efreema sunthaninne Minaase sunthan gido. ");
INSERT INTO gofl_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Taani Masephexoomepe simmishin, Efraata gakanaw guuthi attishin, Raheela Kanaane biittan hayqasu. Taani iyo Beeteleme geetetiya Efraata efiya ogiya gaxan moogas” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Isra7eeley Yoosefa adde nayta nam7ata be7ida wode, “Haysati oonantee?” yaagidi oychis. ");
INSERT INTO gofl_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yoosefi ba aawako, “Haysati Xoossay taw ha biittan immida nayta” yaagis. Yaatin Isra7eeley, “Taani enta anjana mela, enta taako haa shiisha” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Isra7eeley cimin iya ayfey ixida gisho, xeellanaw danda7enna. Hessa gisho, Yoosefi ba adde nayta iyako shiishin, Yayqoobi enta idimmidi yeeris. ");
INSERT INTO gofl_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Isra7eeley Yoosefa, “Taani ne ayfiya be7ana gada qopabike, shin Xoossay heko ne naytaka tana bessis” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Yoosefi ba nayta Yayqooba gulbatape denthidi, ba som7uwa sa7a gathidi ziggis. ");
INSERT INTO gofl_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Yoosefi ba nam7u adde nayta, Efreema Isra7eeles haddirsa baggara, Minaase Isra7eeles ushacha baggara essis. ");
INSERT INTO gofl_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Isra7eeley ba kushiya barbaxidi Efreemi kaalo gidikoka, ba ushacha kushiya huuphen wothis. Minaasey bayra gidikoka, Isra7eeley ba haddirsa kushiya Minaase huuphen wothis. ");
INSERT INTO gofl_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Hessafe guye, Yayqoobi Yoosefa haysada yaagidi anjis; “Ta aawati Abrahaameynne Yisaaqi, iya sinthan de7ida Xoossay, ta de7o ubban hachi gakanaw tana heemmida Xoossay nena anjo. ");
INSERT INTO gofl_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Iitaba ubbaafe tana ashshida, iya kiitanchoy, ha nayta naago. Ta sunthaynne, ta aawata Abrahaame Yisaaqa sunthay entan xeegeto. Enti sa7a bolla daro” yaagidi anjis. ");
INSERT INTO gofl_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Yoosefi ba aaway ba ushacha kushiya Efreema huuphen wothidaysa be7ida wode dosibeenna. Hessa gisho, Efreema huuphiyape denthidi, Minaase huuphen wothanaw ba aawa kushiya oykis. ");
INSERT INTO gofl_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Yoosefi, “Ta aawaw, hessa gidenna. Bayray haysa ne ushacha kushiya iya bolla wotha” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Shin iya aaway ixidi, “Ta erayis, ta na7aw, ta erayis. Minaaseyka gita dere gidana, shin iya kaalo ishay iyape aadhidi gitatana. Iya sheeshayka daro gita kawotetha gidana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","I he gallas enta anjishe, “Isra7eeleti anjo anjiya wode, ‘Xoossay hintena Efreemadanne Minaaseda ootho’ yaagidi hinte sunthan anjana” yaagis. Yaatidi Efreema Minaasepe sinthayis. ");
INSERT INTO gofl_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Hessafe guye, Isra7eeley Yoosefa, “Taani hayqanaw matas, shin Xoossay hintera de7ees. I hinte aawata biitta hintena guye zaarana. ");
INSERT INTO gofl_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Taani Amooretape ta mashshaninne ta dongen ekida biitta, ne ishatara ne shaaketada ekiya biitta bolla new gujada immas” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Hessafe guye, Yayqoobi ba adde nayta xeegidi, “Sinthafe hananaba taani hintew odana mela ha shiiqite” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“Hinteno Yayqooba nayto, issife shiiqidi si7ite; hinte aaway Isra7eeley odeysa hayzite. ");
INSERT INTO gofl_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“Robeela, ta bayra na7aw, neeni ta wolqaa; ta minotethas koyruwa; neeni bonchonka wolqanka ubbaafe aadhasa. ");
INSERT INTO gofl_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Neeni haatha mela, eqidason de7aka; ne ishata bolla bayratethi new bessena. Neeni ne aawa hiixan keyadasa; ne aawa arsa tunisadasa. ");
INSERT INTO gofl_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Simooninne Leewey ishata; enti banta mashsha makallatethas denthoosona. ");
INSERT INTO gofl_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Enti banta hanquwan adde wodhidosona, banta amuwa kunthanaw boorata gaadiya qanxidosona. Yaaniya gisho, taani enta zoretan gelike; enta shiiquwanka uttike. ");
INSERT INTO gofl_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Enta wolqaama hanqoy enta wozanaa iitatethay baadetidaba gido. Taani, enta Yayqooba asa giddon laallana. Isra7eele biittan dharcana. ");
INSERT INTO gofl_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Yihuda, ne ishati nena galatana; Ne kushey ne morketa qoodhe oykana; Ne aawa nayti new hokidi ziggana. ");
INSERT INTO gofl_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yihudaa, neeni wodala gaammo; Ta na7aw, neeni shankafe wodhi simmidi, cogotidi zin7ida gaammo mela. Nena bochanaw danda7ey baawa. ");
INSERT INTO gofl_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Merinaw haareysi yaana gakanaw kawotetha xam7ay, Yihuda kushepe keyenna; kawotethati iyaw kiitetana. ");
INSERT INTO gofl_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","I ba hariya woyne bolla, ba hare mara dooretida woyne bolla qachana; I ba ma7uwa suuthi daaniya woyne ushshan meeccana. ");
INSERT INTO gofl_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Iya ayfey woyne ushshafe aadhidi dulkana; iya achay xaamatape aadhidi booxana. ");
INSERT INTO gofl_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Zabloni abba doonan daana; I abba doonan markabeti eqiya bessi gidana; iya zaway Sidoona gakana. ");
INSERT INTO gofl_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“Yisakoori mino hare mela, caanata giddon zin7ees. ");
INSERT INTO gofl_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Shin I ba shempiya bessay lo77o gideysanne ba biittay ufayseysa gideysa be7iya wode, caana tookanaw ba hashiya ziqi oothidi, aylletetha ooso oothana. ");
INSERT INTO gofl_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Daaney Isra7eele zerethafe issuwa gidiya ba asa bolla pirdana. ");
INSERT INTO gofl_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Daaney oge gaxan de7iya shoosha mela, Para shuquliya dukidi, para toggidaysa guye yeggiya gope mela. ");
INSERT INTO gofl_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“Abeeti Godaw, taani ne ashuwa naagayis. ");
INSERT INTO gofl_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“Gaade, bonqeysati qohana; shin I enta geedo kaallidi oykana. ");
INSERT INTO gofl_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“Aseera biittay orde; I kawotas lo77o kathi immana. ");
INSERT INTO gofl_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Niftaalemey qashetonna yeda de7iya, lo77o marata yeliya gen7e mela. ");
INSERT INTO gofl_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Yoosefi haatha matan toketidi, dere bolla zaa7ida, ayfey kumida woyne mela. ");
INSERT INTO gofl_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Dongen dukeysati iya bolla dendana; banta dongiyan dukishe iya gooddana. ");
INSERT INTO gofl_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Shin Yayqooba Xoossa wolqan, Isra7eele henthanchuwa naaguwan, iya dongey mino, iya qesey xaala gidana. ");
INSERT INTO gofl_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Ne aawa Xoossay nena maaddana. Ubbaa Danda7iya Xoossay, Bolla salo anjuwan, Garsa ciimmuwa anjuwan, mehenka yelonka nena anjana. ");
INSERT INTO gofl_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Ne aawa anjoy benipe minnidi de7iya zumata anjuwafeka, merinaw de7iya deretape bentiya ufaysiya anjuwafeka aadhees. Haysi ubbay Yoosefa huuphen, ba ishata giddon kaapo gideysa liiphen shempo. ");
INSERT INTO gofl_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“Biniyaamey bonqiya suudhume; ba olidaaba wonta mees; ba di77idabaa omarsi shaakees” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Haysati tammanne nam7u Isra7eele sheeshata. Enta aaway enta huuphen huuphen entaw bessiya anjuwa anjishe entako gidabay haysa. ");
INSERT INTO gofl_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Hessafe guye, I enta haysada yaagidi kiittis; “Taani ta mayzatan gahetana hanayis. Tana Hite addiya Efroona gaden de7iya gongoluwan ta aawata matan moogite. ");
INSERT INTO gofl_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Hessika, Kanaane biittan, Maammire matan de7iya, Makifeelan de7iya gongoluwa. He gongoloy Abrahaamey moogoos Hite addiya Efroonape iya gadiyara shammida duufuwa. ");
INSERT INTO gofl_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Abrahaameynne iya machiya Saara, Yisaaqinne iya machiya Irbiqa yan moogetidosona. Taani qassi Liyaka yan moogas. ");
INSERT INTO gofl_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","He gadeynne iyan de7iya gongoloy Hitetape shametidaysa. Tana yan moogite” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Yayqoobi, ba nayta kiitaa ongidaape guye ba tohuwa ba hiixan shiishi ekidi, ba mayzatan gahetis. ");
INSERT INTO gofl_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Yoosefi ba aawa aha bolla kundidi, yeerishe iyaw yeekis. ");
INSERT INTO gofl_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Hessafe guye, Yoosefi dhale shiishiya ba oosanchota, ba aawa Isra7eele aha shitto tiyidi melisana mela kiittis. Enti tiyidi melisidosona. ");
INSERT INTO gofl_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Shitto tishsha wogay oytamu gallas kumethi ekees. Gibxe asati iyaw laapun tammu gallas yeekidosona. ");
INSERT INTO gofl_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Yeeho gallasati aadhida wode, Yoosefi Gibxe kawa oosanchota, “Taani hinte sinthan saba demmidaba gidiko, taw kawas haysada yaagidi odite. ");
INSERT INTO gofl_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Ta aaway tana issi caaqo caaqisis. Taani hayqanaw matas. Taani ta huuphen Kanaane biittan bookida gongolo duufuwan tana mooga’ yaagis. Hessa gisho, ‘Ha7i taani yaa bada ta aawa moogada simmana mela tana yeddarki’ yaagite” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Yaatin Kawoy, “I nena caaqisidaysada bada ne aawa mooga” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Yaatin Yoosefi ba aawa mooganaw bis. Kawa moorinnati ubbay, kawa keethaninne Gibxen de7iya gita asati ubbay Yoosefa kaallidi bidosona. ");
INSERT INTO gofl_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Yoosefa soo asa ubbay, iya ishatinne iya aawa soo asati Yoosefara bidosona. Enta yooga nayti, enta dorsati, enta deeshatinne enta miiza wudiya xalaali Geesamen attis. ");
INSERT INTO gofl_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Para gaaretinne togati iyara bidosona. Iya kaallidi bida asay daro. ");
INSERT INTO gofl_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Enti Yordaanose Shaafa matan de7iya Axaade geetetiya wudumma gakidi, banta qaala dhoqu oothidi, zeleelidi yeekidosona. Yan Yoosefi ba aawa yeehuwan laapun gallas uttis. ");
INSERT INTO gofl_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","He biittan de7iya Kanaane asati Axaade wudumman he yeehuwa be7ida wode, “Gibxeti aybi yibbata yeeho yeekona?” yaagidosona. Hessa gisho, Yordaanose matan de7iya he bessay Abeel-Mixraama (Gibxeta Yeeho) geetetis. ");
INSERT INTO gofl_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Yayqooba nayti enta aaway enta kiitidaysada oothidosona. ");
INSERT INTO gofl_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Enti iya aha Kanaane biitta efidi, Mamirepe ushacha baggan de7iya Makifeela gongoluwan moogidosona. Hessika, Abrahaamey Hite addiya Efroonape moogoos shammida gadiya. ");
INSERT INTO gofl_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Yoosefi ba aawa moogidaape guye, ba ishataranne iya aawa mooganaw iyara bida hara asata ubbatara Gibxe simmis. ");
INSERT INTO gofl_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Banta aaway hayqidaape guye, Yoosefa ishati banta giddon, “Nuuni iyaw oothida iitaba ubbaas Yoosefi nuna ba ulon morkidi halo keyanaw koyiko nuuni waananee?” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Hessa gisho, Yoosefako yaagidi kiita kiittidosona; “Ne aaway hayqanaape sinthe nuuko, ");
INSERT INTO gofl_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Neeni, ne ishata nagaraanne enta iita naaquwa hayyana atto yaaga yaagis gidi odite’ yaagis. Hessa gisho, ha7i hayyana, nu nagara, ne aawa Xoossa aylleta naaquwa atto yaaga” yaagidosona. Yoosefi hessa si7idi yeekis. ");
INSERT INTO gofl_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Hessafe guye, iya ishati banta huuphen iyako yidi, iya sinthan gufannidi, “Nuuni, ne aylleta” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Shin Yoosefi entako, “Babofite, Tana hintew Xoossa gidetiyee? ");
INSERT INTO gofl_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Hinte taw iita oothideta, shin ha7i daro asay hayqonna attana mela Xoossay haysa lo77otethas oothis. ");
INSERT INTO gofl_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Hessa gisho, hiza babofite. Taani hintenanne hinte nayta muzana” yaagidi, enta minthethidi lo77o qaala hassayis. ");
INSERT INTO gofl_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Yoosefi, iyaw laythi xeetanne tamma gidana gakanaw ba aawa soo asaara Gibxen de7is. ");
INSERT INTO gofl_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Efreema naytanne, enta nayta nayta be7is. Qassi Minaase na7aa Makira nayta, ba nayta oothis. ");
INSERT INTO gofl_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Hessafe guye Yoosefi ba ishata, “Taani hayqanaw matas, shin Xoossay hintena maaddanaw xomoosana. I hintena ha biittafe kessidi, Abrahaames, Yisaaqasinne Yayqoobas immana gidi caaqida biitta efana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Yoosefi Isra7eele nayta, “Xoossay hintena maaddanaw xomoosiya wode, hinte ta meqetha ha biittafe ekidi biite” yaagidi caaqisis. ");
INSERT INTO gofl_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Yoosefi xeetanne tammu laythi de7idi hayqin, shittuwan iya aha tiyidi melisidaape guye, Gibxe biittan saaxinen wothidosona.");
INSERT INTO gofl_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Banta soo asaa ubba ekidi, Yayqoobara Gibxe bida Isra7eele adde nayta sunthay haysafe kaallidi xaafetidaysa; ");
INSERT INTO gofl_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Entika Robeela, Simoona, Leewe, Yihuda, ");
INSERT INTO gofl_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Yisakoora, Zabloona, Biniyaame, ");
INSERT INTO gofl_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Daane, Niftaaleme, Gaadenne Aseera. ");
INSERT INTO gofl_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Yayqooba sheeshati ubbay laapun tamma. Yoosefi kaseka Gibxen de7ees. ");
INSERT INTO gofl_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Wodepe guyen Yoosefi, iya ishatinne he yeletetha ubbay hayqidosona. ");
INSERT INTO gofl_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Shin Isra7eele sheeshay yeletidi Gibxe biitta kumana gakanaw taybon daridosonanne minnidosona. ");
INSERT INTO gofl_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Hessafe guye, Yoosefa eronna hara kawoy Gibxe biittan kawotis. ");
INSERT INTO gofl_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","He kawoy ba asaa, “Heko, ha Isra7eeleti nuupe aadhidi yeletethaninne wolqan daridosona. ");
INSERT INTO gofl_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Nuuni hiillatonna ixiko enti taybon kaseysafe haa darana. Qoponna oli dendiko enti nu morketara issifidi nuna olidi, biitta yeggidi baanaw danda7oosona” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Hessa gisho, deexo ooson enta un7ethana mela enta bolla iita kaapota wothidosona. Enti Pitoomanne Ramse geetetiya shallo wothiya katamata kawas keexidosona. ");
INSERT INTO gofl_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Shin Gibxeti enta darsi un7ethinka enti haa daridi yeletidosonanne biitta gakidosona. Gibxeti Isra7eeleta ixida gisho yayyidosona. ");
INSERT INTO gofl_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Entana iita ooso oosisidosona. ");
INSERT INTO gofl_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Urqa yedhison, siminton xuube medhon qassi gade oosison enta de7uwa camisidosona. Qadhey bayna deexo ooso ubbaa enta oosisidosona. ");
INSERT INTO gofl_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Gibxe kawoy qantha Ibraawe maccasata ulo pittiya Sipooronne Puuho geetetiya nam7u maccasatako haysada yaagis; ");
INSERT INTO gofl_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“Ibraawe maccasati yeliya wode yeletida na7ay adde gidiko wodhite, shin macca gidiko paxa aggite” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Shin ulo piteysati Xoosse babbidi, Gibxe kawoy kiitidaysada oothibookona. Enti adde nayta paxa aggidosona. ");
INSERT INTO gofl_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Hessafe guye, Gibxe kawoy he ulo pitteyisata xeegidi, “Hinte ayis haysa oothidetii? Adde nayta ayis paxa aggetii?” yaagidi enta oychis. ");
INSERT INTO gofl_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Ulo piteysati zaaridi, “Ibraawe maccasati Gibxe maccasata mela gidokona. Enti mino gidiya gisho ulo piteysati gakanaape sinthatidi yeloosona” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Hessa gisho, Xoossay ulo pitteysatas keehis. Isra7eele asay kaseysafe haa darshenne minnishe bidosona. ");
INSERT INTO gofl_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Qassi ulo piteysati Xoossas yayyida gisho Xoossay entaw enta soo asi immis. ");
INSERT INTO gofl_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Hessafe guye, kawoy ba asaa ubbaako, “Ibraawetape yeletiya adde ubbaa Nayle Shaafan yeggite; shin macca na7i yeletiko paxa aggite” yaagidi kiittis. ");
INSERT INTO gofl_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","He wode Leewe qommo gidida issi uray Leewe maccas issiw ekis. ");
INSERT INTO gofl_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","He maccasiya adde na7a yelasu. Na7ay mala lo77o gideysa be7ada heedzu ageena qosasu. ");
INSERT INTO gofl_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Shin iya hessafe daro qosanaw danda7onnaysa erada, maqafe daacho dadada, made melaba tiyada na7aa iyan wothasu. Yaatada Nayle Shaafa gaxan mayca giddon wothasu. ");
INSERT INTO gofl_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Iya michiya iya gakiyaba be7anaw haahon eqasu. ");
INSERT INTO gofl_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Gibxe kawa na7iya bolla meecetanaw Nayle Shaafa wodhasu. I macca aylleti haatha doonan yaa haa simeretoosona. Iya daacho mayca giddon demmada, ba aylliw bada ehana mela kiittasu. ");
INSERT INTO gofl_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Daacho dooyada he guutha na7aa be7asu. I yeekeysa be7ada qadhetada, “Haysi Ibraaweta guutha naytape issuwa” yaagasu. ");
INSERT INTO gofl_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","He wode iya michiya kawa na7eko, “Ha na7aa dhanthana mela Ibraawe maccas new eho?” yaagada oychasu. ");
INSERT INTO gofl_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Iya, “Ee, eha” yaagasu. Na7iya bada na7aa aayiw ehasu. ");
INSERT INTO gofl_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Kawa na7iya maccasiw, “Ha na7aa efada, taw dhantha; dicha; taani new damooze qanxana” yaagasu. Maccasiya na7aa efada dhanthasu. ");
INSERT INTO gofl_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Na7ay diccin, kawa na7eko ehasu; I iw na7a gidis. “Taani haathaafe iya kessa ekas” gada, iya Muse gada sunthasu. ");
INSERT INTO gofl_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Musey diccidaape guye issi gallas ba asaa be7anaw bidi, enti deexo ooso oothishin enta be7is. Gibxe asi issoy Ibraawetape issuwa ba yara wadhishin be7is. ");
INSERT INTO gofl_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","I yaa haa xeellin, oonika baynaysa be7idi, he Gibxe ura wodhidi shafen qosis. ");
INSERT INTO gofl_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Wontetha gallas keyidi, nam7u Ibraaweti wadhetishin be7is. Qoheysako, “Neeni ne dabbuwa ayis shocay?” yaagidi oychis. ");
INSERT INTO gofl_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","He uray, “Nena nu bolla haareysanne daynna oothiday oonee? Neeni zine Gibxe uraa wodhidaysada, tanaka wodhanaw koyay?” yaagis. Musey he wode, “Taani oothidabay asan eretis” yaagi qopidi yayyis. ");
INSERT INTO gofl_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Kawoy hessa si7ida wode, Muse wodhisanaw koyis. Shin Musey betidi, Midiyaame biittan de7anaw bis. Issi gallas I haatha olla doonan uttis. ");
INSERT INTO gofl_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","He wode Midiyaame kahine issuwas laapun macca nayti de7oosona. Enti banta aawa dorsata gongen haathe duuqi ushshanaw yidosona. ");
INSERT INTO gofl_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Henthanchoti yidi macca nayta goodidosona. Shin Musey enta maaddidi enta dorsata haathe ushshis. ");
INSERT INTO gofl_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Enti banta aawa Yetorako yida wode, “Hachi waani ellesi yidetii?” yaagidi oychis. ");
INSERT INTO gofl_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Enti zaaridi, “Gibxe asi issoy nuna henthanchotape ashshis. Haathe duuqidi dorsata ushshis” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","I ba macca nayta, “Yaatin I awun de7ii? Hinte he ura ayis aggidi yidetii? Nuura kathi maana mela ane iya xeegite” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Musey he addiyara yan de7anaw qofa qachis. Yotori ba na7iw Sipooro Muses macho oothidi immis. ");
INSERT INTO gofl_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Sipoora adde na7a yelin, Musey iya, “Taani ha biittan bete asi” gidi Gersaama gidi sunthis. ");
INSERT INTO gofl_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Daro laythafe guye Gibxe kawoy hayqis. Shin Isra7eeleti banta aylletethan un7etidi waassidosona. Banta aylletethan enti waassida waasoy Xoossaako gakis. ");
INSERT INTO gofl_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Xoossay enta waasuwa si7idi, I Abrahaamera, Yisaaqaranne Yayqoobara caaqida caaquwa hassayis. ");
INSERT INTO gofl_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Xoossay Isra7eeleta aylletetha un7aa be7idi entana qopis. ");
INSERT INTO gofl_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Issi wode Musey Midiyaame biitta kahiniya, ba bolluwa Yotora dorsaanne deesha heemmees. I he wudiya laagi ekidi mela biitta gaxan Xoossa zuma geetetidi xeegetiya Koreeba zuma bolla efis. ");
INSERT INTO gofl_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","He bessan Godaa Kiitanchoy tushiyan eexiya tama lacuwa giddon iyaw bentis. Musey tushey taman oyketinka tamay tushiya moonnaysa be7idi, ");
INSERT INTO gofl_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","“Taani yaa bada, tushey ayis taman meetetonnaako he oorathabaa shiiqada be7ana” gidi qopis. ");
INSERT INTO gofl_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","I be7anaw shiiqidaysa Goday be7idi, tushiya giddofe, “Muse! Muse!” gidi xeegis. Musey, “Heko, abe Godaw” gidi koyis. ");
INSERT INTO gofl_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Xoossay iyako, “Haa shiiqopa. Neeni eqida biittay geeshshi gidiya gisho, ne tohuwan de7iya caammaa kessa” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Goday iyako, “Taani ne aawata, Abrahaame, Yisaaqanne Yayqooba Xoossaa” yaagis. Musey Xoossaa ba7anaw yayyida gisho, ba som7uwa kammis. ");
INSERT INTO gofl_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Goday qassika haysada yaagis; “Taani Gibxen de7iya ta asay ay mela waayako be7as. Enti bantana un7ethidi haareysatape ashshana mela taako waassiya waasuwa si7as. Enta waayaka erayis. ");
INSERT INTO gofl_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Hessa gisho, taani enta Gibxe asaa kushepe ashshanawunne he biittafe enta kessada, ha77i Kanaaneti, Hiteti, Amooreti, Parzeti, Hiwetinne Yaabuseti de7iya biitta, maathinne eessi kumida lo77o biitta ehanaw wodhas. ");
INSERT INTO gofl_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Ta deriya waasoy ha77i tana gakis. Gibxe asati enta qohida qohuwa taani be7as. ");
INSERT INTO gofl_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Hessa gisho, ha77i neeni ta asaa iya biittafe kessana mela Gibxe kawako taani nena kiittayis” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Shin Musey, “Kawako baanawunne Isra7eeleta Gibxefe kessanaw taani oonee?” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Xoossay zaaridi, “Taani neera gidana. Qassi taani nena kiittidaysas mallay haysa; neeni ta asaa Gibxefe kessiya wode ha zuma bolla hinte tana goyinnana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Musey Xoossaako, “Gidoshin, taani Isra7eeletako bada entako, ‘Hinte aawata Xoossay tana hinteko kiittis’ yaagiko, enti tana, ‘Iya sunthay oonee?’ yaagidi oychiko, taani entaw woygada zaaro” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","“Xoossay Museko, ‘De7eysinne daanaysi, Tana’ neeni Isra7eeletako, ‘TAANI TANA GIDIDAYSI’ tana hinteko kiittis yaaga” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Xoossay zaaridi, “Neeni Isra7eeleta Goday hinte aawata, Abrahaame, Yisaaqanne Yayqooba Xoossay, tana hinteko kiittis. Haysi ta merina sunthaa; yaana yeletetha ubbay ha sunthan tana xeegana. ");
INSERT INTO gofl_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","“Bada Isra7eele cimata shiishada, Goday hinte aawata Xoossay, Abrahaame, Yisaaqanne Yayqooba Xoossay new qoncidaysa oda. Gibxen enti waayetiya waayiya taani xomoosada be7idaysa entaw oda. ");
INSERT INTO gofl_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Taani entana Gibxe waayiyape kessada maathinne eessi kumida, Kanaaneta, Hiteta, Amooreta, Parzeta, Hiwetanne Yaabuseta biitta efanaw qaala gelas. ");
INSERT INTO gofl_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“Isra7eele cimati ne giyaba si7ana. Hessafe guye, neeninne Isra7eele cimati Gibxe kawako bidi, ‘Goday, Ibraaweta Xoossay, nuus qoncis. Ha77i nuuni heedzu gallasa oge mela biitta bidi, Godaas, nu Xoossaas yarshsho yarshana mela nuna yedda’ yaagite. ");
INSERT INTO gofl_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Shin wolqan gidonna ixiko, Gibxe kawoy hintena yeddonnaysa taani erayis. ");
INSERT INTO gofl_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Hessa gisho, taani ta wolqan dumma dumma malaatata oothada Gibxeta shocana. Hessafe guye, I hintena yeddana. ");
INSERT INTO gofl_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“Qassi taani Gibxe asaa sinthan teemo hintew immana. Yaaniya gisho hinte keyiya wode mela kushe keyeketa. ");
INSERT INTO gofl_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Ibraawe maccas ubbay ba shooron de7iya Gibxe maccasaakonne ba son de7iya Gibxe maccasaako bidi, bira alleeqo, worqanne ma7o immite gidi oychana. Hinte hessa ekidi hinte nayta mayzana. Hessada oothidi hinte Gibxe shalo ubbaa ekidi baana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Musey, “Enti tana ammanonna ixidi, woyko taani giyaba si7onna ixidi, ‘Goday new qoncibeenna’ giiko woygo?” yaagidi oychis. ");
INSERT INTO gofl_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Goday Museko, “Ne kushiyan de7eysi aybee?” yaagidi oychis. “Xam7a” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Goday iyako, “Ane sa7an yegga” yaagis. Musey he xam7aa sa7an yeggin, shooshi gidin, Musey iyape woxis. ");
INSERT INTO gofl_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Hessafe guye, Goday, “Ne kushiya yeddada iya goyna oyka” yaagis. Musey ba kushiya yeddidi shoosha oyki denthin shooshay iya kushen simmidi, xam7a gidis. ");
INSERT INTO gofl_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Goday, “Ne aawata Xoossay, Abrahaame, Yisaaqanne Yayqooba Xoossay new qoncidaysa enti ammanana mela haysa ootha” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Kaallidi Goday Museko, “Ne kushiya ne shophen naaqa” yaagis. Musey ba kushiya shophen naaqis. I kessiya wode iya kushey baro hargen oyketidaada booxis. ");
INSERT INTO gofl_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Goday iyako, “Ne kushiya ne shophen zaarada naaqa” yaagis. Musey ba kushiya ba shophen zaari naaqidi kessiya wode iya kushey simmidi hanko asatethi mela gidis. ");
INSERT INTO gofl_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Goday, “Enti nena woyko koyro malaata ammanonna ixiko, nam7antho malaata ammanana. ");
INSERT INTO gofl_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Shin enti ha nam7u malaatata ammanonna ixiko, woyko neeni giyaba si7onna ixiko, Nayle Shaafape haathe ekada, mela biitta bolla gussa. He haathay biitta bolla suuthan laametana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Musey Godaako, “Abeeti Godaw, kaseka woyko ha77i ne tana odiso oykidaysafe doomin odidi ammanthoy taw hanenna. Ta geeshshada odetanaw danda7ike; ta inxarsay lufa” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Goday iyako, “Asas doona immiday oonee? Muume woyko tulle oothey oonee? Xeeliseynne qooqisey oonee? Tana Godaa gidikinaayee? ");
INSERT INTO gofl_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Ha77i neeni ba; neeni odetana mela ta nena maadana. Ne gaanaba ta new immana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Shin Musey, “Godaw, hayyana, hara asi kiitta” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Hessafe guye, Goday Muse bolla daro hanqetidi iyako, “Leewe gidida ne ishaa Aaroni baawee? I oda loythidi ereysa ta erayis. Ha77i I neera gahetanaw yishe oge bolla de7ees; I nena be7iya wode wozanape ufaytana. ");
INSERT INTO gofl_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Neeni, ‘Yaaga’, gada iyaw odana. Taani hinte nam7ayka woygi odanekonne waatidi oothaneko hintena tamaarsana. ");
INSERT INTO gofl_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","I ne doona gididi asas ne gisho odana. Neeni Xoossa bessan gidada I gaanaba iyaw odana. ");
INSERT INTO gofl_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Ha xam7a eka bada iyara malaata oothada bessa” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Hessafe guye, Musey ba bolluwa Yotarako simmi bidi, “Hanno gakanaw asay paxa de7iyako be7anaw, taani guye Gibxe ta asaako boo?” yaagis. Yotori Museko, “Ee ba; saro gaka” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Musey Midiyaame biittan de7ishin Goday iyako, “Nena wodhanaw koyida asati ubbay hayqida gisho guye Gibxe simmada ba” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Musey ba machiwunne ba adde nayta hare togisidi guye Gibxe simmis. Musey Xoossaa xam7a ba kushen oykidi bis. ");
INSERT INTO gofl_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Goday Muse, “Neeni Gibxe simmada biya wode, taani new immida wolqan Gibxe kawa sinthan malaatata oothanaysa balopa. Shin hessanka I asaa yeddonna mela taani iya wozanaa muumisana. ");
INSERT INTO gofl_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","He wode taani Goday giyaba kawas hayssada yaagada oda. ‘Isra7eeli ta bayra na7a. ");
INSERT INTO gofl_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","I taw goyinnana mela iya yedda gada taani new odas. Shin neeni yeddonna ixadasa. Hessa gisho, taani ne bayra adde na7aa wodhana’ yaagees gada oda” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Ogen shempo bessan Goday Musera gahetidi iya wodhanaw koyis. ");
INSERT INTO gofl_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Iya machiya Sipoora qara shuchu ekada, ba na7aa qaxarasu. Qaxara shoohuwara Muse tohuwa bochasu. Iya Museko, “Neeni taw tuma suutha medda” yaagasu. ");
INSERT INTO gofl_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Hessa gisho, Goday iya wodhonna aggis. He wode iya Museko, “Ha qaxaruwa gaason neeni attadasa” yaagasu. ");
INSERT INTO gofl_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","He wode Goday Aaronako, “Musera gahetanaw mela biitta ba” yaagis. I bidi, Xoossaa zuma bolla Musera gahetidi iya yeeris. ");
INSERT INTO gofl_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Musey Gibxe bidi gaanabaanne oothana malaatata ubba Goday iya kiitidaysa Aaronas odis. ");
INSERT INTO gofl_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Museranne Aaronara Gibxe bidi, Isra7eele cimata ubbaa shiishidosona. ");
INSERT INTO gofl_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Aaroni Goday Muses odida qaala ubbaa entaw odis. Qassi Musey malaatata he asaa sinthan oothis. ");
INSERT INTO gofl_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Entika ammanidosona. Goday entaw qopidaysanne enta waayiya be7idaysa si7ida wode gufannidi goyinnidosona. ");
INSERT INTO gofl_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Hessafe guye, Museynne Aaroni Gibxe kawako bidi, “Goday, Isra7eele Xoossay, ‘Ta asay tana bonchanaw mela biittan, ba7aale oothana mela enta yedda’ yaagees” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Kawoy, “Taani iyaw kiitetada Isra7eele yeddanaw I, Goday oonee? Taani Godaa erike; Isra7eelaka yeddike” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Enti zaaridi, “Ibraaweta Xoossay nuus qoncis. Ha77i nuuni Godaas, nu Xoossaas, yarsho yarshanaw heedzu gallasa oge mela biitta baana mela nuna yeddarki. Hessa nu oothonna ixiko I nuna hargen woyko olan dhaysana” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Shin Gibxe kawoy, “Muse, Aarona, Asaa ayis ooso diggetii? Guye bidi hinte oosuwa oothite. ");
INSERT INTO gofl_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Heko, ha biittan hinte darideta; qassi hinte asaa ooso diggeta” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Kawoy he gallas Gibxe kaapotanne Isra7eeleta oosiseyisata haysada yaagidi kiittis; ");
INSERT INTO gofl_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Kaseysada xuube oothanaw asaas utulla immofite. Enti utulla bantaw koyidi shiisho. ");
INSERT INTO gofl_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Shin kaseysafe taybuwa guuthonna enti xuube medhidi shiishana mela kiittite; issinnoka pacisopite. Enti, ‘Nuuni nu Xoossaas yarshsho yarshana mela nuna yedda’ yaagidi tana oychey entaw oosoy guuxida gishosa. ");
INSERT INTO gofl_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Enti ooson gundana melanne wordo oda si7onnaw entaw wodey doonna mela ooso deexisite” yaagidi kiittis. ");
INSERT INTO gofl_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Gibxe kaapotinne Isra7eeleta oosiseysati keyidi, asaako, “Kawoy, ‘Taani hintew utulla immike. ");
INSERT INTO gofl_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Hinte bidi awupeka koydi demmite. Shin hinte oothiya xuube taybuwape issoyka pacenna’ yaagis” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Hessa gisho asay utulla koyanaw Gibxe biitta ubban laaletidosona. ");
INSERT INTO gofl_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Gibxe kaapoti entaw utulli imetin enti oothiya xuube taybuwa keena oothidi shiishana mela enta un7ethidosona. ");
INSERT INTO gofl_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Gibxe kaapoti bantafe garsara de7iya Isra7eele kaapota, “Hinte kase oothiya xuube keena ayis oothi shiishibeketii?” yaagidi wadhidosona. ");
INSERT INTO gofl_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Hessafe guye, Isra7eele kaapoti kawako bidi, “Abeeti godaw, neeni ne aylleta haysada ayis oothay? yaagidi maggannidosona. ");
INSERT INTO gofl_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Ne aylletas utulli imetenna, shin xuube oothana mela kiitetida. Hessa bolla nuna wadhosona; shin balay ne asaa bollana” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Shin kawoy, “Hinte ooso dosonna azallata; hinte wora wodhida azallata. Hinte, ‘Nuuni Godaas yarshanaw baana; nuna yedda’ yaagidi zaari zaari tana oychey hessa gishosa. ");
INSERT INTO gofl_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Ha77i guye bidi oothite. Hintew ayba utullika imetenna, shin hinte kaseysa keena xuube oothanaw bessees” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Isra7eele kaapoti, enti kaseysa keena xuube oothana mela kiitetida wode enti meton gelidaysa eridosona. ");
INSERT INTO gofl_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Enti kawa matape keyidi, bantana karen naagiya Musekonne Aaronako bidosona. ");
INSERT INTO gofl_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Enti Musekonne Aaronako, “Hinte nuna kawoynne iya moorinnati ixana melanne wodhana mela hinte oothidaysa Xoossay xeello; I pirdo” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Musey Godaako simmidi, “Godaw, neeni ha asaa bolla meto ayis ehadii? Neeni tana kiittiday hessasee? ");
INSERT INTO gofl_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Taani ne sunthan kawas odanaw bida wodepe doomin I ha asaa bolla meto ha darsis. Qassi neka ne asaa ashshabaaka” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Hessafe guye, Goday Museko, “Taani Gibxe kawa bolla oothanaba ha77i neeni be7ana. I ta deriya yeddana mela taani ta wolqaa iya bessaana. I enta ba biittafe gooddidi kessana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Xoossay Muse, “Taani Godaa. ");
INSERT INTO gofl_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Taani Abrahaames, Yisaaqasinne Yayqoobas Ubbaa Danda7iya Xoossaa gidada qoncas. Shin taani, ‘Godaa’ geetetiya ta sunthan tanatethaa enta erisabike. ");
INSERT INTO gofl_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Qassi taani enti betetethan de7ida Kanaane biitta immana gada entara caaqas. ");
INSERT INTO gofl_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Qassika Gibxe asati aylleyiya Isra7eeleta waasuwa taani si7as; ta caaquwaka qopas. ");
INSERT INTO gofl_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","“Hesaa gisho neeni Isra7eeletako, ‘Taani Godaa. Taani hintena Gibxe aylletethaafe ashshada kessana. Taani enta ta mino axan iita pirdaa pirdada hintena wozana. ");
INSERT INTO gofl_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Taani hintena ta dere oothana; taani hinte Xoossaa gidana. Gibxe aylletethaafe taani hintena kessida wode, taani Godaa hinte Xoossaa gideysa hinte erana. ");
INSERT INTO gofl_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Taani Abrahaames, Yisaaqasinne Yayqoobas immana gada caaqida biitta hintena ehana. He biitta taani hintew laata biitta oothada immana. Taani Godaa’ yaaga” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Musey hessa Isra7eeletas odis, shin enti aylletetha un7afe dendoysan ufaysi qanxida gisho I giyaba si7ibookona. ");
INSERT INTO gofl_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Hessafe guye, Goday Muse, ");
INSERT INTO gofl_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Bada Gibxe kawas, ‘Isra7eeleta ne biittafe yedda’ yaagada oda” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Shin Musey, “Ta inxarsay lufa. Isra7eeleti tana si7ibookona, shin Gibxe kawoy tana waanidi si7anee?” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Goday Musenne Aarona, “Bidi, Isra7eela asaa Gibxefe kessana mela, taani hintena kiitidaysa Isra7eeletasinne Gibxe kawas odite” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Haysafe kaallidi xaafetidaysati enta mayzata; Yayqooba bayra na7aa Robeela adde nayti, Heenoke, Faalu, Esroomenne Karma. Haysati Robeela soo asaas mayzata. ");
INSERT INTO gofl_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Simoona adde nayti, Yamu7eela, Yamina, Ohada, Yakina, Zohaaranne Kanaane biitta maccaseepe yeletida Saa7ula. Haysati Simoona soo asaas mayzata. ");
INSERT INTO gofl_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Leewe adde nayti Gedisoona, Qahaatanne Maraara. Leewey xeetanne hastamanne laapun laythi de7is. ");
INSERT INTO gofl_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Gedisoona adde nayti Libinanne Same7a geetetoosona. Haysati banta soo asaas mayzata. ");
INSERT INTO gofl_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Qahaata adde nayti Amraama, Izara, Kebroonanne Uzi7eela. Qahaati xeetanne hastamanne heedzu laythi de7is. ");
INSERT INTO gofl_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Maraara adde nayti Mahilanne Muse. Banta yeletethaa maaran hayssafe qommon xaafetidaysati Leewe sheeshata. ");
INSERT INTO gofl_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amraami ba aawa michiw Yokebeedo machis. Iya Aaronanne Muse iyaw yelasu. Amraami xeetanne hastamanne laapun laythi de7is. ");
INSERT INTO gofl_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Izarada nayti, Qore, Nefeganne Zikira. ");
INSERT INTO gofl_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Uzi7eela adde nayti, Misa7eela, Elzafaananne Sitira. ");
INSERT INTO gofl_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aaroni Amnadaabe na7iw, Na7asoona michiw Elsebo machis. Iya iyaw Naadabe, Abyooda, Alaazaranne Itamaara yelasu. ");
INSERT INTO gofl_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Qore adde nayti, Asira, Elqaananne Abiyasafa. ");
INSERT INTO gofl_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Aarona na7ay Alaazari Puti7eela naytape issinniw machis. Iya iyaw Pinihaasa yelasu. Haysati Leewe sheeshatanne enta mayzata. ");
INSERT INTO gofl_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Goday, Musenne Aarona Isra7eele asaa yaran yaran enta soo asaara Gibxefe kaalethidi kessana mela kiittis. ");
INSERT INTO gofl_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Isra7eeleta Gibxefe kessi yeddana mela Gibxe kawas odiday enta. ");
INSERT INTO gofl_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Goday Gibxen Muses odida wode, ");
INSERT INTO gofl_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","“Taani Godaa; taani new odiyaba ubbaa Gibxe kawas oda” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Shin Musey, “Ta doonay lufa gideysa ne eraasa, yaatin kawoy taani odiyaba waani si7anee?” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Goday Museko, “Heko taani nena Gibxe kawas Xoossa mela oothas. Ne ishaa Aaroni ne nabe gididi iyaw odana. ");
INSERT INTO gofl_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Taani nena kiitida kiita ubbaa Aaronas oda. I, Isra7eeleta ba biittafe kessi yeddana mela kawas odana. ");
INSERT INTO gofl_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Shin taani kawa wozanaa muumisana. Taani Gibxe biittan malaatatanne malaalsiyabata oothikoka, ");
INSERT INTO gofl_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","I hinte odiyaba si7enna. He wode taani Gibxeta pirdana; ta deriya Isra7eele Gibxefe kessana. ");
INSERT INTO gofl_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Hessi haniya wode taani godaa gididaysa Gibxeti erana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Museynne Aaroni Goday kiitidaysada oothidosona. ");
INSERT INTO gofl_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Enti kawas odiya wode, Muses hospun tammu laythi; Aaronas qassi hospun tammanne heedzu laythi. ");
INSERT INTO gofl_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Goday Musenne Aarona, ");
INSERT INTO gofl_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Kawoy hintena, malaata oothidi tana bessite giiko, Aaroni ba xam7a ekidi kawa sinthan yeggana mela iyaw oda; he xam7ay shooshi gidana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Museynne Aaroni kawako bidi Goday enta kiitidaysada oothidosona. Aaroni ba xam7aa kawa sinthaninne iya moorinnata sinthan yeggin xam7ay shooshu gidis. ");
INSERT INTO gofl_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Hessafe guye, kawoy marotanne bitanchota xeegisis. Entika banta bitan hessada oothidosona. ");
INSERT INTO gofl_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Enti ubbay banta xam7aa sa7an yeggida wode xam7ati shooshi gididosona. Shin Aarona xam7ay enta xam7ata mittis ");
INSERT INTO gofl_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Gidoshin Goday gidaysa mela kawa wozanay muumis. I enti geysa si7onna ixis. ");
INSERT INTO gofl_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Goday Muse, “Kawa wozanay muumis; I asaa yeddonna ixis. ");
INSERT INTO gofl_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Wonto wonta guura shooshi laametida xam7aa ekada, Nayle Shaafa matan eqada, kawuwara gahetanaw naaga. ");
INSERT INTO gofl_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Iyako, ‘Goday, Ibraaweta Xoossay ta asay mela biittan taw goyinnana mela yedda’ yaagidi tana neeko kiittis. Shin neeni hanno gakanaw ixadasa. ");
INSERT INTO gofl_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Goday, I, Godaa gideysa I oothiyaban neeni erana. Taani Nayle Shaafa haatha ta kushen de7iya xam7an shociko haathay suuthi laametana. ");
INSERT INTO gofl_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Nayle Shaafan de7iya moloy hayqana; shaafayka xinqana. Gibxeti he shaafa haatha uyanaw danda7okona” yaagada oda. ");
INSERT INTO gofl_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Goday Museko, “Aaroni Gibxen de7iya haathata bolla, shaafata bolla, zara haathata bolla, teqe haatha bollanne duuqetida haathi ubbaa bolla ba xam7aa denthana mela oda. He wode haatha ubbay suuthi laametana. Hari attoshin Gibxe biittan mithafenne shuchafe oosetida haathe tikiya miishetan de7iya haathay ubbay suuthi laametana yaaga” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Museynne Aaroni Goday kiitidaysada oothidosona. Kawa sinthaninne iya moorinnata sinthan ba xam7aa denthidi, Nayle Shaafa haatha shocis. Haatha ubbay suuthi laametis. ");
INSERT INTO gofl_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","He Shaafa haathan de7iya moloti hayqidosona. Shaafa haathay iita xinqida gisho, Gibxe asay uyanaw danda7ibookona. Gibxe biitta ubban suuthi kumis. ");
INSERT INTO gofl_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Shin Gibxe bitanchoti banta bitan hessada oothidosona. Goday gidaysada kawa wozanay muumin, Museynne Aaroni odidaysa si7onna ixis. ");
INSERT INTO gofl_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Kawoy he hanidaba aybinka taybonna yeggi aggidi ba gadho simmidi bis. ");
INSERT INTO gofl_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Gibxe asay Nayle Shaafa haatha uyanaw danda7iboona gisho, uyiya haathi demmanaw Shaafa gaxan olla bookidosona. ");
INSERT INTO gofl_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Goday haatha shoci simmin laapun gallas gidis. ");
INSERT INTO gofl_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Hessafe guye, Goday Museko, “Gibxe kawako bada, ‘Goday, taw goyinnana mela ta asaa yedda. ");
INSERT INTO gofl_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Neeni enta yeddonna ixiko, ne biitta ubban shodhe gado yeddana. ");
INSERT INTO gofl_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Nayle Shaafan shodhey kumana. Enti yaape keyidi ne kawotetha, ne zin7iya kifiliya, ne hiixa, ne moorinnata keethaanne ne deriya keetha ubban gelana. Hessadaka ne cooceninne munuqa miishe ubban gelana. ");
INSERT INTO gofl_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Shodheti ne bolla, ne asaa bollanne ne shuumata ubbaa bolla gupana yaagees’ yaagada oda” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Goday Museko, “Aaroni Gibxen de7iya haathata bolla, zara haathata bollanne teqe haatha ubbaa bolla ba xam7aa denthana mela oda” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Aaroni Gibxe haathata bolla ba xam7aa denthida wode shodheti keyidi, Gibxe biitta ma7idosona. ");
INSERT INTO gofl_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Shin marotika banta bitan hessada oothidi Gibxe biittan shodhe kesidosona. ");
INSERT INTO gofl_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Kawoy Musenne Aarona xeegisidi, “Ha shodheta taapenne ta asaape diggana mela Godaa hinte woossiko ta hinte asaa Godaas yarsho yarshana mela yeddana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Musey kawako, “Shodheti neepe, ne moorinnatapenne ne asaape kichana mela ta woossanaw qaxaro imma. Hessafe guye, Shaafa shodheti neepenne ne keethaafe kichidi Nayle xalaalan de7ana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Kawoy zaaridi, “Wonto gido” yaagis. Musey, “Nu Godaa Xoossaa meli hari oonika baynaysa neeni erana mela ne gidaysada oothana. ");
INSERT INTO gofl_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Shodheti neepe, ne keethaafenne, ne moorinatape kichidi Nayle Shaafa xalaalan attana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Museynne Aaroni kawa matape keyidi, kawa bolla Goday ehida shodheta diggana mela Musey Godaa woossis. ");
INSERT INTO gofl_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Goday Musey oychidaysada oothin son, kareninne geeshshan de7iya shodheti hayqidosona. ");
INSERT INTO gofl_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Gibxe asay hayqida shodheta shiishidi dooridosona; biitta ubbay xinqis. ");
INSERT INTO gofl_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Shin shodheti hayqidaysa kawoy be7ida wode iya wozanay zaari muumis. Goday gidaysa mela I Musenne Aarona si7onna ixis. ");
INSERT INTO gofl_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Hessafe guye, Goday Museko “Aaroni ba xam7a denthidi biitta baana shocana mela oda. Gibxe biitta ubban de7iya baanay boxe gidana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Enti kiitetidaysada oothidosona. Aaroni xam7ara biitta baana shocis. Gibxen de7iya baana ubbay boxe laametidi mehiyanne asaa ma7is. ");
INSERT INTO gofl_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Marotika banta bitan hessada oothanaw paacidosona, shin xoonetidosona. Boxey asaa bollanne mehiya bolla laaletis. ");
INSERT INTO gofl_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Maroti kawako, “Haysi Xoossaa ooso” yaagidosona. Shin kawa wozanay muumis. Goday gidaysa mela I entana si7onna ixis. ");
INSERT INTO gofl_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Goday Muse, “Guura dendada, kawoy Shaafa bishin iyara gahetada, ‘Goday, tana goyinnana mela ta asaa yedda. ");
INSERT INTO gofl_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Neeni ta asaa yeddona ixiko, taani, ne bolla, ne moorinnata bollanne, ne asaa bolla udunxe gado yeddana. Gibxeta keethaanne enti de7iya biitta ubban udunxey kumana. ");
INSERT INTO gofl_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Shin he gallas ta asay de7iya Geesame biittan udunxey doonada enta teqada ashshana. Taani Goday, He wode ha biittan taani Goday ootheysa neeni erana. ");
INSERT INTO gofl_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Taani, ta asaanne ne asaa shaakana; he gita malaatay wonto hanana’ yaagees gada oda” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Hessafe guye, Goday gidaysada oothis. Kawa gadhonne iya moorinnata soo daro udunxe gado yeddis. Kumetha Gibxe biittay udunxe gadon qohetis. ");
INSERT INTO gofl_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","He wode kawoy Musenne Aarona xeegisidi, “Bidi, ha biittan hinte Xoossaas yarsho yarshite” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Shin Muse zaaridi, “Hessi hanonnaba. Nuuni Godaas, nu Xoossaas yarshiya yarshoy Gibxeta matan ixetiya gisho, hessa oothoko. Nu yarshishin enti be7iko nuna shuchan caddana. ");
INSERT INTO gofl_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Nuna kiitidaysa mela, nuuni Godaas, nu Xoossaas yarsho yarshanaw heedzu gallas oge mela biitta baanaw bessees” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Kawoy zaaridi, “Godaas, hinte Xoossaas mela biitta bidi yarshana mela taani hintena yeddana. Shin hinte haakidi boopite; taw woossite” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Musey zaaridi, “Taani ne matape keyida mela Godaa woossana. Ha udunxey wonto kawuwape, iya moorinnatapenne iya asaape kichana. Shin kawoy asay Godaas goyinnanaysa diggidi zaari nuna cimmofo” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Hessafe guye, Musey kawa matape keyidi, Godaa woossis. ");
INSERT INTO gofl_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Goday Musey oychidaysada oothis. Udunxey kawuwape, iya moorinnatapenne iya asaape issoyka attonna kichis. ");
INSERT INTO gofl_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Shin ha77ika kawa wozanay muumin asaa yeddonna ixis. ");
INSERT INTO gofl_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Goday Museko, “Gibxe kawako bada, Goday, Ibraaweta Xoossay neeko, ‘Enti taw goyinnana mela ta asaa yedda. ");
INSERT INTO gofl_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Neeni enta yeddonna ixiko, ");
INSERT INTO gofl_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","taani ne parata bolla, ne hareta bolla, ne gimaleta bolla, ne mehiya bolla, ne dorsata bollanne ne deeshata bolla iita gado yeggana. ");
INSERT INTO gofl_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Shin taani Goday Isra7eele asaa mehiya giddoninne Gibxe asaa mehiya giddon dummatethi medhana. Isra7eele asaa mehiyape issoyka hayqenna. ");
INSERT INTO gofl_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Wonto taani hessa oothana gidi Goday wode qanxis’ yaaga” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Wontetha gallas Goday gidaysada oothis. Gibxe asaa mehe ubbay hayqis, shin Isra7eele asaa mehiyape issoyka hayqibeenna. ");
INSERT INTO gofl_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Kawoy hanidabaanne Isra7eeleta mehiyape hari attoshin issoyka hayqonaysa ase kiittidi, oychidi eris. Shin ha77ika iya wozanay muumida gisho asaa yeddonna ixis. ");
INSERT INTO gofl_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Hessafe guye, Goday Musenne Aarona, “Coocepe bido kuuci ekidi, kawoy be7ishin bolla dharcite. ");
INSERT INTO gofl_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Hessi Gibxe biitta ubbaa bolla baana gididi laaletana. Gibxe biittan de7iya asaa bollanne mehey bolla kixa gado ehana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Enti coocepe guutha bido ekidi kawa sinthan eqidosona. Musey hessa bolla laallin, asaa bollanne mehiya bolla kixa gadoy wodhi aggis. ");
INSERT INTO gofl_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Gibxe asaa bolla wodhida kixay marota bollaka wodhida gisho Muse sinthan eqanaw danda7ibookona. ");
INSERT INTO gofl_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Shin Goday Muses gidaysa mela, kawoy ba wozana muumisida gisho, Musenne Aarona si7onna ixis. ");
INSERT INTO gofl_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Hessafe guye, Goday Museko, “Kawako guura denda bada, ‘Goday, Ibraaweta Xoossay, taw goyinnana mela ta asaa yedda. ");
INSERT INTO gofl_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Ha77i ne ixas giiko, ne moorinnatanne ne asaa xalaala gidonashin ne bollaka iita gado ehana. He wode alame ubban Godi ta xalaala gideysa neeni erana. ");
INSERT INTO gofl_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Taani ta kushiya denthada nenanne ne asaa gadon shocidaba gidiyako ha77i gakanaw hinte biitta bolla de7eketashin. ");
INSERT INTO gofl_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Shin ta sunthay biitta ubban eretana mela taani ta wolqaa bessanaw nena de7on wothas. ");
INSERT INTO gofl_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Neeni ha77ika otortada ta asaa yeddonna ixadasa. ");
INSERT INTO gofl_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Taani wonto hannoode Gibxe biittay medhotosape hachi gakanaw buki eronna wolqaama shachi bukisana. ");
INSERT INTO gofl_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Ha77i neeni ne mehiyanne karen de7iyaba ubbaa elle soo gelsana mela kiitta. Soo gelonna asaa bollanne mehiya ubbaa bolla shachi bukidi, enta wodhana yaagees’ yaaga” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Kawa moorinatape issoti issoti Goday gidaysa si7idi yayyida gisho, banta aylletanne banta meheta soo gelsidosona. ");
INSERT INTO gofl_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Shin harati Goday gidaysa si7onna ixidi banta aylletanne banta mehiya karen aggaagidosona. ");
INSERT INTO gofl_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Hessafe guye, Goday Museko, “Gibxe biitta ubbaa bolla, asa bolla, mehiya bollanne gaden de7iya katha bolla shachi bukana mela ne kushiya salo dentha” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Musey ba xam7aa salo denthida wode, Goday wolqaama deshonne wol7anthi yeddis. Hessada oothidi Goday Gibxen shachi bukisis. ");
INSERT INTO gofl_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Goday gedera haara wolqaama wol7anthi yeddis. Hessa melabay Gibxe biittan asi doosape hani erenna. ");
INSERT INTO gofl_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","He shachay Gibxen de7iya asaanne mehiya shocis. Gaden de7iyaba, mithinne maata ubbaa dhaysis. ");
INSERT INTO gofl_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Isra7eeleti de7iya Geesame biitta xalaalan shachi bukibeenna. ");
INSERT INTO gofl_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Kawoy Musenne Aarona xeegisidi, “Taani ha77i nagara oothas. Goday tumancho; taaninne ta asay bala. ");
INSERT INTO gofl_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Deshoynne shachay nu bolla daridi un7ethida gisho nuus Godaa woossite. Taani hintena yeddana; hizape hinte haysan gam7eketa” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Musey iyako, “Taani ha katamaape keyida wode ta kushiya denthada Godaa woossana. Deshoynne shachay eqiya wode sa7ay Godaaba gideysa neeni hessan erana. ");
INSERT INTO gofl_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Shin nenne ne moorinnati ha77ika Godaa Xoossa yayyonnaysa taani erayis” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Talbay ciishshe, bangay qorxa gidiya gisho ubbay shachan dhayis. ");
INSERT INTO gofl_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Shin gisteynne murqay gakiboonna gisho shachan dhaybeenna. ");
INSERT INTO gofl_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Musey kawa matape keyidi, katamaape gaxaa bidi ba kushiya denthidi Godaa woossis. Yaatin deshoy, shachaynne iray ellesidi eqi aggis. ");
INSERT INTO gofl_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Shin kawoy he ubbay eqidaysa be7ida wode zaaridi nagara oothis. Iyaranne iya moorinnatara banta wozana gujidi minthidosona. ");
INSERT INTO gofl_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Goday Muse baggara odidaysa mela kawa wozanay muumin, Isra7eeleta yeddonna ixis. ");
INSERT INTO gofl_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Hessafe guye, Goday Museko, “Gibxe kawako ba. Taani ha malaatata enta giddon oothanaw koyada kawa wozanaanne iya moorinnata wozana muumisas. ");
INSERT INTO gofl_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Taani hessa oothiday ta malaatatan waatada Gibxeta seeridaako hinte hinte naytasinne hinte nayta naytas odana mela koyida gishosa. He wode taani Godaa gideysa hinte erana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Museynne Aaroni kawako bidi, “Goday, Ibraaweta Xoossay neeko, ‘Neeni taw kiitetethi ixey awude gakanaasee? Tana goyinnana mela ta asaa yedda. ");
INSERT INTO gofl_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Neeni enta yedo ixiko, wonto ne biitta bolla taani boole yeddana. ");
INSERT INTO gofl_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Booley darotethaafe dendoysan biitta ubba kammana. Enti shacha gaduwape attida guuthabanne mitha haythi ubbaa maana. ");
INSERT INTO gofl_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Ne keethaa, ne moorinnata keethaanne Gibxe asaa ubbaa keethaa enti kumana. Hessi ne mayzati ha biittan de7osape hano gakanaw be7ida iitabaape aadhiyaba gidana’ yaagees” yaagidosona. Hessafe guye, Musey kawa sinthafe keyidi bis. ");
INSERT INTO gofl_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Kawa moorinnati kawako, “Ha uray awude gakanaw nuus xihe gidanee? Asay Godaa, banta Xoossaa goyinnana mela enta yedda. Gibxe biittay dhayeysa neeni akeekikii?” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Kawoy Musenne Aarona guye xeegisidi, “Bidi Godaa, hinte Xoossa goynite, shin beysati oonantee?” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Musey, “Nuuni biya bessan Godaa bonchanaw ba7aale oothana gisho, nuuni nu guutha nayta, nu cimata, nu adde nayta, nu macca nayta, nu dorsatanne nu miizata ekidi issife baana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Kawoy, “Hinte hinte naytanne hinte maccasata eki boonna mela taani Godan caaqisayis. Hinte hinte wozanan iitaba qopidaysi eretees. ");
INSERT INTO gofl_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Hinte, bidi Godaa goyinnanaw koyaba gidiko addeta xalaala eki biite” yaagis. Hessafe guye, Musenne Aarona kawa sinthafe goodetidi keyidosona. ");
INSERT INTO gofl_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Goday Museko, “Booley yidi shacha gaduwape attida ubbaa maana mela ne kushiya Gibxe biitta bolla dentha” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Musey ba xam7aa Gibxe biitta bolla denthida wode, Goday doloha bagga carko he qammanne gallas kumethi biitta bolla carkisis. Wontiya wode he carkoy boole ehis. ");
INSERT INTO gofl_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Booley Gibxe biitta ubbaa gakidi ma7is. Hessa mela boole gadoy he biittan kaseka hanibeenna; sinthafeka hanenna. ");
INSERT INTO gofl_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Biitti dhumana gakanaw booley biitta ubbaa ma7is. He booley shachafe attidi gaden dicciyaba ubbaanne mitha ayfe ubbaa midosona. Gibxe biittan de7iya mitha haythinne cil7oba ubbaa midigis. ");
INSERT INTO gofl_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Kawoy Musenne Aarona ellesi xeegisidi, “Taani Godaa hinte Xoossaanne hintena naaqas. ");
INSERT INTO gofl_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Hiza ta nagara taw issi toho atto giite. Ha dhaysiya gaduwa taape diggana mela Godaa hinte Xoossaa woossite” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Musey kawa matape keyidi Godaa woossis. ");
INSERT INTO gofl_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Goday wuloha wolqaama carkuwa kiittidi booliya biittafe denthidi, Zo7o Abba yeddis. Gibxe biitta ubban issi booleyka hayqibeenna. ");
INSERT INTO gofl_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Shin Goday kawa wozanaa muumisida gisho Isra7eeleta yeddonna ixis. ");
INSERT INTO gofl_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Goday Muse, “Gibxe biittan asi oyki be7iya dhumi dhumana mela ne kushiya salo dentha” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Musey ba kushiya salo denthis. Gibxe biitta ubban heedzu gallas kumethi sakana dhumay dhumis. ");
INSERT INTO gofl_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","He heedzu gallasatan Gibxeti issoy issuwa be7ibookona woyko oonika ba soope keybeenna. Shin Isra7eeleti de7iya Geesamen poo7oy de7ees. ");
INSERT INTO gofl_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Kawoy Muse xeegisidi, “Bidi hinte Godaa goyinnite. Hinte maccasaynne hinte nayti hintera baanaw danda7oosona. Hinte dorsaa wudiyanne hinte miiza wudiya xalaala aggidi biite” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Shin Musey, “Nuuni xuussa yarshonne hara yarsho Godaa Xoossaas yarshana mela mehe neeni nuus immanaw koshshees. ");
INSERT INTO gofl_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Issoyka guye attona nu mehey nuura baanaw koshshees. Godaa, nu Xoossaa goyinnanaw mehiyape dooranaw bessey nuna. Nuuni ya gakonna de7ishe ay mehe yarshaneko eranaw danda7oko” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Shin Goday kawa wozanaa muumisida gisho, I enta yeddanaw koybeenna. ");
INSERT INTO gofl_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Hessafe guye, kawoy Museko, “Ta sinthafe kicha; ta sinthan zaara bentada nena era. Ta ayfiya ne be7ida gallas hayqana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Musey iyako, “Tumaka ne gidaysada neeni ta ayfiya zaarada be7aka” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Goday Museko, “Taani Gibxe kawa bollanne iya asaa bolla issi hara gado yeddana. Hessafe guye, I hintena kessi yeddana. I hintena ubbaa gooddidi kessana. ");
INSERT INTO gofl_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Isra7eele asay, addeynne maccasi banta shoorotape biranne worqa alleeqo oychana mela entaw oda” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Goday Isra7eele asaas Gibxeta sinthan teemo immis. Gibxe kawa moorinnatinne asay Muse daro bonchetida asada xeellidosona. ");
INSERT INTO gofl_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Musey kawako, “Goday haysada yaagees; ‘Qamma bilahe taani Gibxe biitta giddora kanthana. ");
INSERT INTO gofl_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Gibxe biittan de7iya bayra adde na7i ubbay, kawa araata laattanaw de7iya bayra na7aape doomidi, woxan gaaciya macca aylle bayra na7a gakanaw, bayra yeletida mehe ubbay hayqana. ");
INSERT INTO gofl_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Gibxe biitta ubban hessafe kaseka sinthafeka hanonna gita yeehoy yeekeettana. ");
INSERT INTO gofl_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Shin Isra7eele asaa bolla woyko enta mehiya bolla kanika boccenna.’ He wode taani Goday Gibxeta giddoninne Isra7eele giddon dummatethi medheysa neeni erana. ");
INSERT INTO gofl_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Ne moorinnati ubbay yidi ta sinthan gufannana. Ta asaa ekada ha biittafe keyana mela enti tana woossana. Hessafe guye, taani baana” yaagis. Musey shenen xuugetidi kawa sinthafe keyidi bis. ");
INSERT INTO gofl_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Goday muses kase, “Gibxe biittan taani malaalsiyaba darsada oothana gaso kawoy hintena si7enna” yaagidi odi wothis. ");
INSERT INTO gofl_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Museynne Aaroni malaalsiyaba ubbaa kawa sinthan oothidosona. Shin Goday kawa wozanaa muumisida gisho, Isra7eeleta ba biittafe yeddonna ixis. ");
INSERT INTO gofl_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Goday Gibxe biittan Musenne Aarona haysada yaagis; ");
INSERT INTO gofl_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Ha ageenay hintew laythas koyro ageena gido. ");
INSERT INTO gofl_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Isra7eele asa ubbaas ha wogaa odite. Ha ageenay gelida tammantho gallasan, issi asi ba soo asaas issi maraze woyko issi kole eko. ");
INSERT INTO gofl_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","He keetha asaa tayboy he mehiya wursidi maanaw danda7onna ixiko, iyaranne iya mata shooruwara banta soo asaa taybuwa melanne issi issi asi midi wursanaw danda7iya keena ekidi he mehiya shukidi issife mona. ");
INSERT INTO gofl_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Hinte dooriya mehey dorse woyko deeshe gidanaw danda7ees, shin issi laythi kumidaysanne iya bolla borey bayna adde gido. ");
INSERT INTO gofl_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Ha ageenas tammanne oyddantho gallas gakanaw enta heemmite. He gallas omarsi laadiya wode Isra7eele asaa maabara ubbay enta shukanaw bessees. ");
INSERT INTO gofl_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Asay he suuthaafe ekidi enti miya keetha wula garsa, qomuwanne bokoluwa tiyo. ");
INSERT INTO gofl_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Ashuwa he gallas qamma taman caacidi cammiya boncoranne uythara miite. ");
INSERT INTO gofl_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Ashuwa qaye woyko kathidi moopite. Huuphiya, gedatanne ulo ashota ubbaa caacidi miite. ");
INSERT INTO gofl_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","He ashuwape wontana gakanaw aykoka ashshofite. Wontana gakanaw attiko hessa xuuggite. ");
INSERT INTO gofl_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Oges giigiya ma7o ma7idi, hinte caammaa aathidi, hinte xam7aa oykidi eeson miite. Hessi tana Godaa bonchiya Paasika ba7aale hintew gido. ");
INSERT INTO gofl_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“Taani he qamma Gibxera kanthada bayra yeletida ubbaa, asenne mehe wodhana. Gibxe eeqata ubbaa pirdana; taani Godaa. ");
INSERT INTO gofl_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","He suuthay hinte de7iya keethaa erisiya malla gidana. Taani Gibxeta pirdiya wode he suuthaa be7ada hintena qohonna agga aadhana. ");
INSERT INTO gofl_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“Ha gallasay taani Goday hintew oothidaysa laythan laythan qofisiya Godaa bonchiya ba7aale gido” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","“Laapun gallas gakanaw irshoy gelonna uythi miite. Koyro gallas irsho hinte soope diggite. He laapun gallasatan irshoy de7iya uythi miya asi Isra7eele asaa giddofe duuxidi kureto. ");
INSERT INTO gofl_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Koyro gallasaninne laapuntha gallasan goyinnanaw shiiqite. He gallasatan aybi oosoka oothopite, shin kathi kathanaw danda7eeta. ");
INSERT INTO gofl_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","“Taani Isra7eele deriya Gibxefe kessiday he gallas gidiya gisho ha uytha baaliya laythan laythan bonchite. Hessi hintew merina woga gido. ");
INSERT INTO gofl_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Koyro ageenan, tammanne oyddantho gallas omarsafe doomidi, laatamanne issintho gallas omarsi gakanaw irshoy geliboonna uythaa miite. ");
INSERT INTO gofl_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Laapun gallas gakanaw irshoy hinte son bentofo. Irshoy gelidaba miya biitta aawu na7a gidin woyko asa gade asi gidin, he keetha aaway Isra7eele maabara giddofe kureto. ");
INSERT INTO gofl_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Irshoy gelidaba aykoka moopite. Hinte de7iyason awunka irshoy geliboonna uythu miitepe attishin, irshoy gelida uythu moopite” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Musey Isra7eele cimata ubbaa xeegisidi haysada yaagis; “Hinte issoy issoy soo bidi paasika ba7aale bonchanaw maraze woyko kole shukite. ");
INSERT INTO gofl_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Hisoophe mitha haythafe danki ekidi, keren de7iya suuthan yeddi ekidi wula garsa, qomuwanne bokoluwa tiyite. Wontana gakanaw hintefe issoyka ba keethaafe kare keyopo. ");
INSERT INTO gofl_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Goday Gibxe bayrata wodhanaw he biittara kanthiya wode, he suuthaa wula garsa, qomuwaninne bokoluwa bolla be7idi aggidi aadhana. Hayqo ehiya kiitanchoy hinte soo gelidi hintena wodhonna mela diggana. ");
INSERT INTO gofl_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“Hintenne hinte nayti ha kiita merinaw naagite. ");
INSERT INTO gofl_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Goday kase immana gidi qaala gelida biitta hinte geliya wode ha wogaa oothite. ");
INSERT INTO gofl_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Hinte nayti hintena, ‘Ha baaliya nu ayis bonchiw?’ gidi oychiya wode, ");
INSERT INTO gofl_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","hinte entako, ‘Haysi Godaa bonchiya Paasika yarsho. Hessika Goday Gibxe biittan Isra7eele asa keethaa aggidi, aadhidi, Gibxe bayrata wodhidi, nuna ashshida gishosa’ yaagite” yaagis. Hessafe guye, Isra7eeleti gulbatidi goyinnidosona. ");
INSERT INTO gofl_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Isra7eeleti, Goday Musenne Aarona kiitidaysada oothidosona. ");
INSERT INTO gofl_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Giddi bilahe Goday Gibxen bayra yeletida ubbaa, kawa araata laattanaw de7iya bayra na7aape doomidi, qasho keethan de7iya asata bayra nayta gakanawunne bayra yeletida mehe ubbay hayqidosona. ");
INSERT INTO gofl_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Kawoy, iya moorinnatinne Gibxe biitta asa ubbay qamma dendidosona. Gibxe biittan asi hayqiboona issi keethika bayna gisho, asay banta qaala dhoqu oothidi gita yeeho yeekidosona. ");
INSERT INTO gofl_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","He qamma kawoy Musenne Aarona xeegisidi, “Hintenne hinte Isra7eeleti ta biittafe keyidi biite. Hinte tana oychidaysada bidi hinte Godaa goyinnite. ");
INSERT INTO gofl_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Hinte gidaysa mela hinte dorsaanne mehiya wudiya ekidi biite. Qassi hinte Xoossay tana anjana mela woossite” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Gibxe asay, “Isra7eeleti banta biittafe ellesidi keyana mela dirgisidosona. Hinte keyonna ixiko nu ubbay wuroos” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Hessa gisho, Isra7eele asay irshoy geliboonna munaqa keren kunthidi, banta ma7uwan kammidi, banta hashen tookidosona. ");
INSERT INTO gofl_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Isra7eeleti Musey enta kiitidaysada Gibxeta, bira alleeqo, worqa alleeqonne ma7o immana mela oychidosona. ");
INSERT INTO gofl_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Goday, Isra7eeleti Gibxeta sinthan sabetanaada oothin, Gibxeti enti oychidaba ubbaa immidosona. Hessada yaatidi enti Gibxeta shaluwa bonqi ekidi bidosona. ");
INSERT INTO gofl_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Isra7eeleti Ramse katamaape dendidi Sukota geetetiya bessi tohon bidosona. Asaa tayboy naytanne maccasaa gujonna usupun xeetu mukula. ");
INSERT INTO gofl_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Qassi entara hara daro walaka asay, meheynne dorsa deesha wudey laagetidi bis. ");
INSERT INTO gofl_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Gibxefe enti dirgon keyida gisho kathi kathanaw wode dhayidosona. Enti keyishe eki keyida irshoy geliboonna munuqape ekidi uythi uukidosona. ");
INSERT INTO gofl_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Isra7eeleti Gibxe biittan de7ida laythay oyddu xeetanne hastama. ");
INSERT INTO gofl_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Oyddu xeetanne hastamu laythay wuriya he wursetha gallas Godaa asa ubbay Gibxe biittafe keyidosona. ");
INSERT INTO gofl_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Goday ba asaa naagidi, Gibxefe kessida wode sa7i qamma. He qammay yeletethaafe yeletethaa gakanaw Isra7eele asay barkidi naagishe aqiya, Godaas dummatida qamma. ");
INSERT INTO gofl_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Goday Musenne Aarona, “Paasika gallasaa bonchiya wogay haysa yaagis; asa gade asi paasika kathaafe moopo. ");
INSERT INTO gofl_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Hinte hinte miishen shammida aylley qaxaretidaape guye mo. ");
INSERT INTO gofl_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Shin hintera gam7iya imathinne une oothiya asi iyape moopo. ");
INSERT INTO gofl_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“He Paasika kathay kaxida keethan yan miite. He ashuwape aykoka kare kessofite. Meqethatape issuwaka menthofite. ");
INSERT INTO gofl_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Isra7eele maabara ubbay Paasika ba7aale bonchanaw koshshees. ");
INSERT INTO gofl_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","“Asa gade asi gididi hinte giddon de7iya asi Godaa Paasika Ba7aale bonchanaw koyko, iyaranne iya son de7iya adde ubbay qaxareto. Hessafe guye, I biitta aawu na7ada taybetidi Paasika Ba7aale bonchanaw danda7ees. Shin qaxaretiboona asi iyape moopo. ");
INSERT INTO gofl_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Ha wogay biitta aawu naytasinne hara biitta asi gididi hinte giddon de7iya asaas issino” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Isra7eele ubbay, Goday Musenne Aarona kiitidaysada oothidosona. ");
INSERT INTO gofl_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","He gallas Goday Isra7eeleta cugan cugan Gibxe biittafe kessis. ");
INSERT INTO gofl_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Goday Museko, ");
INSERT INTO gofl_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Bayra yeletida adde ubbaa taw dummaya. Isra7eele asaa giddon bayra yeletida ubbay, ase woyko mehe gidin ubbay tabaa” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Hessafe guye, Musey asaako, “Ha gallasay, hinte Gibxe aylletethaafe keyida gallas gidiya gisho iya qopite. Goday ba gita wolqan hintena kessiday he gallasaana gidiya gisho, irshoy gelidaba aykoka moopite. ");
INSERT INTO gofl_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Abiiba ageenan, hachi gallasan hinte Gibxefe keydeta. ");
INSERT INTO gofl_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Goday Kanaaneta, Hiteta, Amooreta, Hiwetanne Yaabuseta biitta hintena laatisanaw hinte mayzatas caaqis. Goday hintena maathinne eessi kumida he biitta gathiya wode laythan laythan ha koyro ageenan ha gallasaa bonchite. ");
INSERT INTO gofl_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Laapun gallas kumethi irshoy geliboonna uythi miite. Laapuntha gallasay Godaa bonchiya ba7aale gidana. ");
INSERT INTO gofl_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","He laapun gallasatan irshoy geliboonna uythi miite. Irshoy woyko irshoy de7iyabay hinte giddoninne hinte zawan bentofo. ");
INSERT INTO gofl_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","He gallas neeni, ‘Taani haysa oothey taani Gibxefe keyiya wode Goday taw oothidaysa qopanaasa’ yaagada ne naytas oda. ");
INSERT INTO gofl_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Ha ba7aaley hinte kushen woyko hinte som7on qashetida malla gididi hintena qofisiyaba gidana. Goday hintena ba gita wolqan Gibxefe kessida gisho, Godaa wogay hinte doonape wodhonna melanne haratas hinte odana mela hintena qofisana. ");
INSERT INTO gofl_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Hessa gisho, hinte ha baaliya laythan laythan ba wodiyan bonchite. ");
INSERT INTO gofl_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“Goday hintewunne hinte mayzatas immana gidi caaqida Kanaaneta biitta gelsidi, he biitta hintew immiya wode, ");
INSERT INTO gofl_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","bayra yeletida ubbaa Godaas imma. Ne mehetan bayra yeletiya adde ubbay Godaasa. ");
INSERT INTO gofl_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Bayra yeletiya hare mari ubbaa dorsa maran woza. Wozonna ixiko iya morgiya mentha. Ne adde nayta giddon bayra yeletida ubbaa woza. ");
INSERT INTO gofl_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Sinthara yaana laythatan ne nayti nena, ‘Haysi aybee?’ gidi oychiko neeni, ‘Goday nuna ba gita wolqan Gibxe aylletethaafe kessis. ");
INSERT INTO gofl_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Gibxe kawoy ba wozana muumisidi nuna yeddonna ixin, Goday Gibxe biittan de7iya asape doomidi mehe gakanaw bayra ubbaa wodhis. Nuuni bayra yeletida mehe adde Godaas yarsheynne bayra adde nayta nuuni wozey hessasa yaaga. ");
INSERT INTO gofl_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Goday nuna ba gita wolqan Gibxefe kessida gisho, ha ba7aaley nu kushen woyko nu som7on qashetida malla gididi nuna qofisiyaba gidana’ yaaga” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Kawoy asaa yeddida wode, Xoossay enta mata gidida Filisxeeme biittara kanthisiya ogiyara kaalethibeenna. Xoossay hessa oothiday, “Asaa oli gakiko, banta qofaa laammidi guye Gibxe simmana” yaagidi qopida gishosa. ");
INSERT INTO gofl_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Hessa gisho, Xoossay asaa mela biitta ogiyara yuushshidi, Zo7o Abbaako kaalethis. Isra7eeleti olas giigidi Gibxe biittafe keyidosona. ");
INSERT INTO gofl_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Yoosefi, “Xoossay tuma hintena ashshanaw yaana. He wode hinte ta meqethaa ha biittafe ekidi biite” yaagidi Isra7eeleta caaqisidi wothida gisho Musey iya meqethaa baara ekidi bis. ");
INSERT INTO gofl_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Enti Sukotape dendidi mela biitta gaxan de7iya Etaaman uttidosona. ");
INSERT INTO gofl_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Enti gallasinne qamma hemetana mela gallas entana kaalethanaw shaara tuussan, qamma poo7isidi enta kaalethanaw tama tuussan enta sinthan bis. ");
INSERT INTO gofl_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Gallas shaara tuussay, qamma tama tuussay asaa sinthafe kichibeenna. ");
INSERT INTO gofl_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Hessafe guye, Goday Museko, ");
INSERT INTO gofl_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Enti guye simmidi Migdoolapenne Zo7o Abbaafe giddon, Pihahiroota sinthan, Ba7aal-Zafoona matan uttana mela oda. ");
INSERT INTO gofl_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Kawoy, ‘Isra7eeleti mela biitta keyanaw oge dhayidi coo toylatoosona’ yaagidi qopana. ");
INSERT INTO gofl_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Taani kawa wozanaa muumisana; I enta gooddana. Taani kawanne iya olanchota ubbaa xoonada bonchetana. He wode Gibxet taani Godaa gideysa erana” yaagis. Hessa gisho, Isra7eeleti I odidaysada oothidosona. ");
INSERT INTO gofl_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Asay kessi ekidaysa Gibxe kawoy si7idi, iyaranne iya moorinnatara banta qofa laammidi, “Nuuni ayis hessa oothido? Nuuni Isra7eeleta yeddidi, nuna haggaaziya asi ayis dhayane” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Hessa gisho, I ba para gaariya kooridi, ba olanchota ekidi dendis. ");
INSERT INTO gofl_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","I usupun xeetu dooretida para gaaretanne Gibxe biittan de7iya hara gaareta ubbaa enta halaqatara ekidi bis. ");
INSERT INTO gofl_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Goday Gibxe biitta kawa wozana muumisida gisho yashshi bayna kessa bolla de7iya Isra7eele asaa yedethis. ");
INSERT INTO gofl_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Gibxe kawa parati, para gaaretinne olanchoti Isra7eeleta kaallidi bidi, Abba doonan Ba7aal-Zafoonanne Pihahiroota matan enti uttidashin demmidosona. ");
INSERT INTO gofl_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Kawoy ba olanchotara yishin Isra7eeleti demmidi yayyidosona; bantana maaddana mela Godaako waassidosona. ");
INSERT INTO gofl_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Enti Museko, “Gibxe biittan nuus duufoy dhayidee? Nuuni mela biitta hayqana mela nuna kessiday hessasee? Nuna Gibxefe ayis ehadii? ");
INSERT INTO gofl_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Gibxen de7ishe haysi hananaysa eridi, ‘Nuna agga nuuni Gibxetas haaretana’ yaagidi new odibooko? Mela biittan hayqanaape entaw haareteysi nuus lo77oshin” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Shin Musey zaaridi, “Yayyofite; minnidi eqite. Goday hachi hintena ashshiya ashuwa hinte be7ana. Hachi hinte be7iya Gibxeta zaari be7eketa. ");
INSERT INTO gofl_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Hinte si77i giite; Goday hinte gisho oletana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Goday Museko, “Neeni ayis taako waassay? Isra7eeleti sinthe hemetana mela oda. ");
INSERT INTO gofl_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Ne xam7a Abbaa bolla dentha; haathay shaaketana. Isra7eeleti mela biittara Abbaa pinnidi baana. ");
INSERT INTO gofl_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Taani Gibxeta wozanaa muumisana; enti hinte geedo kaallidi Abban gelana. Taani kawa, iya olanchota, iya para gaariyanne iya para gaariya laageyisata xoonada bonchetana. ");
INSERT INTO gofl_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Ta enta xoonida wode, taani Godaa gideysa Gibxeti erana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Xoossaa kiitanchoy, Isra7eele olanchotape sinthara hemeteysi entafe guye aadhidi hemetis. Shaara tuussay enta sinthafe guye bagga aadhidi, ");
INSERT INTO gofl_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Gibxetasinne Isra7eeletas giddon eqis. He shaaray Gibxetas dhumisidi, Isra7eeletas poo7isis. Yaatin qamma kumethi Gibxeti Isra7eeletako shiiqibookona. ");
INSERT INTO gofl_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Musey Abba bolla ba kushiya miccis. Goday he qamma wolqaama doloha carko yeddidi mela biitti bentana gaso Abbaa shocis. Haathay shaaketis. ");
INSERT INTO gofl_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Haathay shaaketidi nam7u baggan godada eqin, Isra7eeleti mela biittara hemetidi pinnidosona. ");
INSERT INTO gofl_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Gibxe kawa parati, iya para gaaretinne iya para gaariya laaggeysati entana kaallidi, Abban gelidosona. ");
INSERT INTO gofl_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Sa7i wontana hanishin Goday tamanne shaara tuussan gididi Gibxe olanchota duge xeellidi, entaw hananaba dhaysis. ");
INSERT INTO gofl_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Para gaareta gertoy genderetonna mela Goday enta para gaareta gertuwa sa7ara oythis. Gibxeti, “Goday Isra7eeleta maaddidi nuna oliya gisho, nuuni enta aggidi baqatoos” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Goday Museko, “Haathay Gibxeta bolla, enta para gaareta bollanne enta para gaariya laageyisata bolla guye simmana mela ne kushiya Abbaa bolla micca” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Musey ba kushiya Abbaa bolla miccin, sa7i wontiya wode Abbay ba kase bessaa guye simmis. Gibxeti baqatanaw koydosona, shin Goday enta Abban yeggis. ");
INSERT INTO gofl_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Haathay guye simmidi, Isra7eeleta kaallidi Abban gelida para gaareta, para gaareta laaggeysatanne Gibxe olanchota mittis. Entafe issoyka attibeenna. ");
INSERT INTO gofl_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Shin Isra7eeleti Abbaa giddora mela biittara hemetidi, haathay shaaketidi godada eqidashin pinnidosona. ");
INSERT INTO gofl_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Goday he gallas Isra7eele asaa Gibxeta kushepe ashshis. Isra7eeleti hayqidi zin7ida Gibxeta Abbaa doonan be7idosona. ");
INSERT INTO gofl_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Isra7eeleti Goday Gibxeta bolla bessida gita wolqaa be7ida wode Godaa yayyidosona. Godaanne iya aylliya Muse ammanidosona. ");
INSERT INTO gofl_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","He wode Museynne Isra7eele asay ha mazmuriya Godaas yexidosona. I ba gita xoonuwan bonchetida gisho, taani ta Godaas galata mazmuriya yexana. Paranne para toggeysa Abban yeggis. ");
INSERT INTO gofl_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Goday ta minotethaanne ta mazmuriya gasuwa, I tana ashsheysa. I ta Xoossaa; taani iya sabbana. I ta aawata Xoossaa; taani iya bonchana; galatana. ");
INSERT INTO gofl_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Goday olancho; iya sunthayka Godaa. ");
INSERT INTO gofl_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Gibxe kawa para gaaretanne iya olanchota Abban yeggis. Gibxe kawa, ubbaafe aadho gidida toora moconata, Zo7o Abban mitisis. ");
INSERT INTO gofl_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Entana ciimmo haathay mittis; enti shuchada ciimmon mitetidosona. ");
INSERT INTO gofl_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","“Abeeti Godaw, ne ushacha kushey wolqan gooba; ne kushey morkiya mentherethis. ");
INSERT INTO gofl_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Ne gita xoonuwan, neera eqeteyisata oladasa. Ne sheney tamada eexidi, enta kafleda mis. ");
INSERT INTO gofl_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Ne hanquwan ne Abbaa punnin, haathay godada eqis. Abbaa ciimmoti garsan shuchada minnidosona. ");
INSERT INTO gofl_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","“Morkey, ‘Taani enta yedethada oykana; taani enta shaluwa shaakada, ta koydaba ubbaa ekana. Taani ta mashsha shoddada enta dhaysana’ yaagidi ceeqetis. ");
INSERT INTO gofl_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Shin neeni enta punnin, Abbay enta mittis. Enti Abbaa ciimmuwan biratada mitetidosona. ");
INSERT INTO gofl_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Abeeti Godaw, Xoossata giddon ne mali oonee? Geeshshatethan yashshey ne mali oonee? Bonchoy daggantheynne malaalsiyaba oothey ne mali oonee? ");
INSERT INTO gofl_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Neeni ne ushacha kushiya miccida wode, biittay enta mittis. ");
INSERT INTO gofl_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","“Neeni wozida asaa ne merina siiquwan kaalethadasa. Neeni ne wolqan enta ne geeshsha biitta gelsadasa. ");
INSERT INTO gofl_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Kawotethati hessa si7idi yashshan kokoridosona. Filisxeeme biitta asatika un7etidosona. ");
INSERT INTO gofl_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","He wode Edoome biitta halaqati dagammidosona; Moo7abe biitta haareysati yashshan kokoridosona; Kanaane asati dagaman daaburidosona. ");
INSERT INTO gofl_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Dagaminne yashshi enta oykis. Abeeti Godaw, enti ne wolqaa gitatetha be7idi, ne asay aadhana gakanaw, neeni wozida asay aadhana gakanaw, shuchada toletidi eqidosona. ");
INSERT INTO gofl_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Neeni enta ehada, ne zumaa huuphen tokana. Abeeti Godaw, he bessay neeni new daanaw doorida bessi, neeni ne kushiyan minthada keexida ne keethe. ");
INSERT INTO gofl_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Goday merina gakanaw kawotana” yaagidi yexidosona. ");
INSERT INTO gofl_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Isra7eeleti Abbaa giddora mela biittara pinnin, Gibxe kawa parati, iya para gaaretinne iya para toggeysati Abban gelida wode Goday enta bolla Abbaa haatha zaarin haathay enta mittis. ");
INSERT INTO gofl_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Aarona michiya, nabiya Mayraama karaabo ekasu. Hara maccasati ubbay banta karaabo ekidi baqishenne yexishe iyo kaallidosona. ");
INSERT INTO gofl_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Mayraama, “I ba gita xoonuwan bonchetida gisho, Paranne para toggeyisata I Abban yeggida gisho, Iyaw mazmuriya yexite” yaagada entaw yexasu. ");
INSERT INTO gofl_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Hessafe guye, Musey Zo7o Abbaa matape Isra7eeleta denthidi Shuura mela biitta gakanaw kaalethis. He mela biittan enti heedzu gallas hemetidosona shin haathe demmibookona. ");
INSERT INTO gofl_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Enti Maara geetetiya bessi gakidi haathe demmidosona, shin haathay camo gidiya gisho uyanaw danda7ibookona. Hessa gisho, he bessay Maara geetetis. ");
INSERT INTO gofl_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Asay, “Nuuni ay uyanee?” gidi Muse bolla zuuzumidosona. ");
INSERT INTO gofl_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Yaanin, Musey Godaako waassis; Goday iya issi mithi bessis. Musey he mitha haathan yeggin haathay mal7is. Yan Goday entaw higge immis; yan Goday enta paacis. ");
INSERT INTO gofl_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Musey entako, “Hinte hinte Godaa Xoossaas kiitetite; I koyaba oothite. Hinte taw polo kiitetikonne ta giyaba si7iko Gibxeta bolla ta yeddida hargiyan hintena pirdike. Taani hintena pathiya Godaa” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Hessafe guye, enti Elima bidosona. Yan tammanne nam7u haatha pultotinne laapun tammu zamba mithati de7oosona. Enti yan haatha doonan uttidosona. ");
INSERT INTO gofl_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Gibxefe keyida nam7antho ageenan, tammanne ichashantho gallas Isra7eele asa ubbay Elimape dendidi, Elimapenne Siinape giddon de7iya Siine geetetiya mela biitta yidosona. ");
INSERT INTO gofl_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Isra7eele asa ubbay mela biittan Muse bollanne Aarona bolla zuuzumidosona. ");
INSERT INTO gofl_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Isra7eeleti entako, “Nuuni Gibxe biittan Godaa kushen hayqida gidorkoshin. Hari atto nuuni yan wodhi uttidi ashuwanne hara kathi ubbaa nu koyida mela moos. Shin hinte nuna ubbaa kessidi ha mela biitta koshan wodhiseeta” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Goday Museko, “Taani hintew salope kathi buksana. Asay gallas gallas keyidi, hachis gidiyaba maxanaw koshshees. Asay taw kiitetiyakonne kiitetonaako taani enta hessan paacana. ");
INSERT INTO gofl_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Saamintan saamintan Usupuntho gallas enti kase maxeysas nam7u kushe maxidi katho” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Hesaa gisho Museynne Aaroni Isra7eele asaako, “Hintena Gibxe biittafe kessiday Godaa gideysa omarsi hinte erana. ");
INSERT INTO gofl_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Hinte Godaa bolla zuuzumidaysa I si7ida gisho, wonta Godaa bonchuwa hinte be7ana. Hinte nu bolla zuuzumanaw nuuni oonee?” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Hessafe guye, Musey, “Hinte Godaa bolla zuuzumidaysa I si7ida gisho, I hintew omarsi maanaw asho immeynne wonta maanaw hinte koyiya mela uythu immey Godaa gideysa hinte erana. Hinte nu bolla gidonashin Godaa bolla zuuzumeta” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Musey Aaronako, “Neeni Isra7eele asaa ubbaa, ‘Goday hinte zuuzuntha si7ida gisho, yidi Godaa sinthan eqite’ yaaga” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Aaroni Isra7eele asaa ubbaas odida wode enti mela biitta simmidi, shaara giddora qoncida Godaa bonchuwa be7idosona. ");
INSERT INTO gofl_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","12","Goday Museko, “Taani Isra7eeleta zuuzuntha si7as. Neeni entaw ‘Omarsi asho hinte maana; wonta hinte koyida mela uythu ekana. He wode hinte taani Godaa hinte Xoossaa gideysa erana’ yaagada oda” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","He gallas omarsi kuraachoti yidi, Isra7eele asay de7iya bessaa ma7idosona. Wonta enta heeran aki biitta ma7is. ");
INSERT INTO gofl_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Akay, xiz7ida wode lee7onne laafabay mela biitta bolla bentis. Ika shachada boothi. ");
INSERT INTO gofl_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Isra7eeleti hessa be7ida wode iya eronna gisho, issoy issuwako, “Haysi aybee?” yaagidosona. Yaatin Musey entako, “Hinte maana mela Goday immida kathay haysa. ");
INSERT INTO gofl_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Goday, ‘Asay issoy issoy baw koshsheysa mela shiisho; son de7iya issi issi asi ba huuphen nam7u litiro eko’ yaaga” yaagidi kiittis. ");
INSERT INTO gofl_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Isra7eeleti kiitetidaysada oothidosona; baggay darsidi, baggay guuthidi shiishidosona. ");
INSERT INTO gofl_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Enti shiishidi litiron makiya wode darsi shiishidaysas palahibeenna; guuthu shiishidaysaska pacibeenna. Issoy issoy baw koshsheysa mela shiishis. ");
INSERT INTO gofl_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Musey entako, “Oonika iyape wontas ashshofo” yaagidi kiittis. ");
INSERT INTO gofl_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Shin entafe issoti issoti Musey odidaysa si7onna ixidi wontas minjidosona. Enti minjidaysi guxuntidi xinqis. Hessa gisho, Musey enta bolla hanqetis. ");
INSERT INTO gofl_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Wonta wonta asa ubbay bantaw koshsheysa mela shiishees. Away michiya wode sa7an attidaysi til7ees. ");
INSERT INTO gofl_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Usupuntho gallas enti kase shiishiya nam7u litiruwa bolla iya mela gujidi issi issi asas oyddu litiro shiisho. Yaatin Isra7eele halaqati bidi hessa Muses odidosona. ");
INSERT INTO gofl_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Musey zaaridi, “Wontoy shempo gallas gididi Godaa bonchiya geeshsha Sambaata. Hessa gisho, hinte uukiyaba uukite; doysiyaba doysite. Palahidaysa wontos wothite” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Enti Musey kiitidaysada wontos wothin, xinqibeenna woyko guxuntibeenna. ");
INSERT INTO gofl_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Musey entako, “Haysa hachi miite; hachi Godaa bonchiya shempo Sambaata gidiya gisho, hinte hachi denban demmeketa. ");
INSERT INTO gofl_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Hinte kathaa usupun gallasatan shiishanaw danda7eeta, shin laapuntha gallasay shempo gallas gidiya gisho aybi kathika he wode deenna” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Laapuntha gallasan issi issi asay shiishanaw keyidosona, shin aykoka demmibookona. ");
INSERT INTO gofl_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Yaatin, Goday Museko, “Ta kiitaanne ta higgiya hinte naagonna ixey awude gakanaasee? ");
INSERT INTO gofl_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Taani hintew Sambaata immidaysa akeekite. Usupuntho gallasan I hintew nam7u gallasa kathi immey hessa gishosa. Laapuntha gallasan oonika kare keyonna ba son ba son gam7o” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Hesaa gisho, asay laapuntha gallasan shempis. ");
INSERT INTO gofl_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Isra7eele asay he katha manna gidi xeegidosona. Mannay deebo ayfe mela gididi boothi. I eessara uukida uythada mal7ees. ");
INSERT INTO gofl_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","“Taani hintena Gibxe biittafe kessida wode mela biittan muziday manna gideysa yaana yeletethay be7ana mela iyape nam7u kilo giraame wothite” yaagidi Goday kiitidaysa Musey Isra7eele asaas odis. ");
INSERT INTO gofl_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Musey Aaronako, “Nam7u kilo giraame manna ekada xaaron qolada yaana yeletethaas Goday goyinnetiya bessan wotha” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Goday Muse kiitidaysada, Aaroni manna Godaa sinthan taabotiya giddon wothis. ");
INSERT INTO gofl_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Isra7eeleti banta de7iya Kanaane biitta zawa yidi gakanaw oytamu laythi manna midosona. ");
INSERT INTO gofl_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","He wode asay makiya miishey laatamanne nam7u litiro oykees. ");
INSERT INTO gofl_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Isra7eele asa ubbay Goday kiitidaysada issi bessafe hara bessi yuuyishe, Siin mela biittafe dendidi Rafidima geetetiya bessan uttidosona. Shin enti uyanaw haathi he bessan dhayis. ");
INSERT INTO gofl_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Enti, “Nuus uyanaw haathe imma” yaagidi Musera kacetidosona. Musey zaaridi, “Hinte taara ayis kacceteetii? Godaa ayis paacetii?” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Shin asay yan haatha saamotidi, “Neeni nuna, nu naytanne nu mehiya saamon wodhanaw Gibxefe kessada haysa ayis ehadii?” yaagidi Muse bolla zaari zaari zuuzumidosona. ");
INSERT INTO gofl_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Yaatin Musey, “Taani ha asaa waato? Enti tana shuchan caddana hanoosona” yaagidi Godaa woossis. ");
INSERT INTO gofl_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Goday Museko, “Neeni Isra7eele asaape cimata neera ekada asaape sinthe aadhada hemeta. Qassi Nayle Shaafa shocida xam7aa ne kushen oykada ba. ");
INSERT INTO gofl_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Taani Koreeba zuman zaalla bolla ne sinthan eqana. He zaalla shoca; asay uyana haathay iyape keyana” yaagis. Musey Isra7eele cimata sinthan hessa oothis. ");
INSERT INTO gofl_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Isra7eeleti, “Tuma Goday nuura de7ii?” yaagidi zuuzumida gishonne Godaa paacida gisho he bessa Masahanne Mariba gidi sunthis. ");
INSERT INTO gofl_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Amaaleqati yidi Rafidiman Isra7eeleta olidosona. ");
INSERT INTO gofl_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Muse Iyyasuko, “Neeni wonto Amaaleqata olanaw guutha asi doora. Taani Xoossaa xam7aa oykada zuma huuphen eqana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Musey kiitidaysada Iyyasuy Amaaleqata olis. Musey, Aaroninne Hoori zuma huuphe keyidosona. ");
INSERT INTO gofl_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Musey ba kushiya denthidi gam7iya wode Isra7eeleti xoonosona, shin I ba kushiya wothiya wode Amaaleqati xoonosona. ");
INSERT INTO gofl_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Muse kushey argaacida wode Aaronaranne Huurara shuchi ehidi Muse iya bolla utisidosona. Aaroninne Huuri ushacharanne haddirsara eqidi away wullana gakanaw iya kushiya katisi oykidosona. ");
INSERT INTO gofl_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Hessada oothidi Iyyasuy Amaaleqata mashshan olidi dhaysis. ");
INSERT INTO gofl_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Hessafe guye, Goday Museko, “Haysi ubba wode hassayetana mela ha xoonuwa taarikiya xaafa. Taani Amaaleqata burxora dhaysanaysanne enti dogetanaysa Iyyasus oda” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Musey yarsho bessi giigisidi, “Goday ta xoonuwa bandira” gidi sunthis. ");
INSERT INTO gofl_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","I, “Godaa xoono Bandira dhoqu oothidi oykite. Goday Amaaleqata merinaw olana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Midiyaame biitta kahiney, Muse bolloy Yotori, Goday Musesinne ba asaa Isra7eeletas oothidabaanne entana Gibxefe kessidaba si7is. ");
INSERT INTO gofl_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","He wode Muse bolloy Yotori, iya matan Musey aggidi bida iya machiw Sipooronne, ");
INSERT INTO gofl_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","I nam7u nayta ekidi yis. Musey, “Taani allaga biittan bete asi gidas” gidi bayra na7aa Gersaama gidi sunthis. ");
INSERT INTO gofl_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Kaaluwa qassi, “Ta aawa Xoossay, tana Gibxe kawa mashshafe ashshis” gidi Alaazara gidi sunthis. ");
INSERT INTO gofl_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Muse bolloy Yotori, iya machiwunne I adde nayta baara ekidi, mela biittan, Xoossaa zumaa matan de7iya Museko yis. ");
INSERT INTO gofl_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","I banta yuussaa erisanaw Museko kiittis. ");
INSERT INTO gofl_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Hessa gisho, Musey ba bolluwa mokanaw keyidi, iya ziggi sarothidi iya yeeris. Enti issoy issuwa sarothi simmidi Muse dunkaaniya giddo gelidosona. ");
INSERT INTO gofl_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Goday Isra7eeleta ashshanaw Gibxe asaa bollanne enta kawa bolla oothidaba ubbaanne ogen enta gakida metuwa ubban Goday waati maaddidaako Musey ba bolluwas odis. ");
INSERT INTO gofl_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Yotori Goday Isra7eele asaa Gibxeta kushepe ashshanaw oothida lo77o oosotaba si7idi ufaytis. ");
INSERT INTO gofl_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","I, “Hintena Gibxetape enta kawa kushiyape ashshidi, Gibxe aylletethaafe kessida Goday, I galatetto. ");
INSERT INTO gofl_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Otoron enta bolla iitaba oothida Gibxetape Isra7eeleta ashshanaw hessa oothida gisho, Goday xoossata ubbaafe gita gideysa taani ha77i eras” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Hessafe guye, Yotori, Muse bolloy, xuussa yarshonne hara yarsho Xoossaas yarshis. Aaroninne Isra7eele cimati ubbay Xoossaa sinthan iyara geeshsha katha maanaw yidosona. ");
INSERT INTO gofl_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Wontetha gallas Musey asaas pirdanaw uttis. Asay Muse yuushuwan wontafe omarsi gakanaw eqidi de7ees. ");
INSERT INTO gofl_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Muse bolloy Musey asaas ootheysa ubbaa be7idi, “Neeni ne xalaala haysa ayis oothay? Asay wontafe omarsi gakanaw ne yuushuwan essada ayis nerka oothay?” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Musey ba bolluwako, “Asay Xoossaa sheniya oychanaw koyidi taako yaa gishosa. ");
INSERT INTO gofl_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Enta giddon odi de7iko taako yoosona. Ta enta giddon balinne tumi ooneko shaakayis; Xoossa kiitaanne higgiya entaw odayis” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Muse bolloy, “Haysi ne ootheysi lo77o gidenna. ");
INSERT INTO gofl_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Neka neeko yaa asa ubbay daabureta. Ha oosoy issi asape daro gidiya gisho, neeni nerka oothanaw danda7aka. ");
INSERT INTO gofl_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Ha77i taani nena zoreysa si7a; Xoossay neera gidana. Neeni ha asaa bessan gidada entaba Xoossas oda. ");
INSERT INTO gofl_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Xoossa kiitaanne higgiya enta tamaarsa. Enti waani daanekonne ay oothaneko enta bessa. ");
INSERT INTO gofl_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Qassi asaa giddon oda shaakidi eriya asata, Xoossaa yayyeyisata, ammantheysatanne wodhaafe ekonnaysati doora. Entana asaa bolla shaalaqata, mato halaqata, hamsalaqatanne asiralaqata oothada shuuma. ");
INSERT INTO gofl_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Enti ubba wode kawushsha odata bantaw pirdo, shin deexo odata neeko eho. Hessada ne oothiko toohoy new kawuyana. ");
INSERT INTO gofl_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Ne oothana mela Xoossi koyey hessa. Qassi ne daaburaka ha asa ubbay ba allalley poletin ba soo ba soo simmana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Musey Yotora zoriya si7is; I gidaba ubbaa oothis. ");
INSERT INTO gofl_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Musey Isra7eeleta giddofe oda shaaki eriya asata dooris. Entana asaa bolla shaalaqata, mato halaqata, hamsalaqatanne asiralaqata oothidi shuumis. ");
INSERT INTO gofl_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Shuumati kawusha odata bantaw pirdidosona, shin deexo odata Museko ehoosona. ");
INSERT INTO gofl_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Hessafe guye, Musey ba bolluwa moyzin, I ba biitta simmis. ");
INSERT INTO gofl_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Isra7eele asay Gibxefe keyida heedzantho ageenas koyro gallasan Siina mela biitta gakidosona. ");
INSERT INTO gofl_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Enti Rafidimape dendidi bidi, Siina zuma sinthan de7iya mela biittan uttidosona. ");
INSERT INTO gofl_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Musey Xoossara gahetanaw zuma bolla keyis. Goday zumaa huuphepe iya xeegidi, “Yayqooba sheeshi gidida Isra7eeletas haysada yaaga; ");
INSERT INTO gofl_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘Taani Gibxeta bolla oothidabaanne arganthi ba na7a ba qefiyan tookeysda ta hintena waata tookada taako ehidaako hinte hinte huuphen be7ideta. ");
INSERT INTO gofl_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Ha77i hinte taw kiitetikonne ta caaquwa naagiko, biitta kumethay tabaa gidikoka hinte taw dooretida dere gidana. ");
INSERT INTO gofl_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Hinte taw geeshsha dere gidana; hinte kawotethan kahine gididi tana haggaazana.’ Neeni Isra7eeletas odana qaalay haysa” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Musey guye bidi, zumako cimata xeegi shiishidi, Goday odida qaala ubbaa entaw odis. ");
INSERT INTO gofl_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Enti, “Goday gidaba ubbaa nuuni oothana” yaagidosona. Musey enti gidaysa Godaas odis. ");
INSERT INTO gofl_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Goday Museko “Taani neera haasayishin asay si7anaadanne enti nena ubba wode ammananada taani muumida shaarara neeko yaana” yaagis. Hessafe guye, Musey asay gidaysa Godaas odis. ");
INSERT INTO gofl_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Goday Museko “Neeni asaako bada hachinne wonto taara gahetanaw bantana geeshshana mela entaw oda. Enti banta ma7uwa meeccidi, ");
INSERT INTO gofl_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","heedzantho gallasas giigeto. He gallas asa ubbay tana be7ishin taani Siina zuma bolla wodhana. ");
INSERT INTO gofl_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Neeni ha zuma yuushuwan zawa wotha. Asay zuma bolla keyonna mela woyko zumaa xaphuwa bochonna mela entaw oda. Zumaa bochida oonika hayqana. ");
INSERT INTO gofl_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","He uray shuchan cadetidi woyko dongen duketidi hayqo; iya kushen oonika bochofo. Mehey woyko asi hessada hayqo. Moyzey punetiya wode enti zumaa bolla keyanaw danda7oosona” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Musey zumaa bollafe wodhidi, asay Xoossaa goyinnanaw bantana giigisana mela odis. Entika banta ma7uwa meeccidosona. ");
INSERT INTO gofl_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Musey asaako, “Heedzantho gallasaas giigetite; hinte machetara aqopite” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Heedzantho gallas wonta guura deshoy dechis. Wol7anthinne sakana shaari zumaa ma7idi bentis. Wolqaama moyze waasoy si7etis. Asay dunkaanida bessa ubban yashshan kokoridosona. ");
INSERT INTO gofl_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Hessafe guye, Musey asaa Xoossara gathanaw entana dunkaaniyape kessidi efis; enti zumaa xaphon eqidosona. ");
INSERT INTO gofl_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Goday Siina zumaa bolla tama lacora wodhida gisho Siina derey cuyan kametis. Gita coocepe cuyi keyeysada iyape cuyiya zuley suure keyis. Asa ubbay daro kokoridosona. ");
INSERT INTO gofl_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Moyziya waasoy dari dari bida wode Musey odin, Xoossay deshon iyaw zaaris. ");
INSERT INTO gofl_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Goday Siina zumaa huuphe bolla wodhidi, Muse pude zumaa bolla xeegis. Musey zumaa bolla keyis. ");
INSERT INTO gofl_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Goday iyako, “Neeni duge bada asay tana be7ana gidi, zawa aadhona melanne entafe daroy hayqonna mela entaw oda. ");
INSERT INTO gofl_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Hari atto Godaa mati shiiqiya kahinetika bantana geeshsho. Enti hessa oothonna ixiko ta enta hanqana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Musey Godaako, “Neeni zuma dummayida gishonne zawa immida gisho asay zuma huuphe keyanaw danda7okona” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Goday iyako, “Neeni duge bada Aarona neera ekada ya. Kahinetinne asay zawa kanthidi taako yishe dhayona mela entaw oda” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Hessa gisho, Musey asaako wodhidi Goday gidaysa entaw odis. ");
INSERT INTO gofl_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Xoossay Isra7eele asaako haysada yaagis; ");
INSERT INTO gofl_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Nena Gibxefe aylletethaafe kessida Goday ne Xoossay tana. ");
INSERT INTO gofl_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“Taape attishin, hara xoosse goyinnofa. ");
INSERT INTO gofl_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“Bolla saluwan de7iyaba, woyko garsa sa7an de7iyaba, woyko sa7ape garsan haatha giddon de7iyaba aybaka new goyinniya eeqa daanisada oothofa. ");
INSERT INTO gofl_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Entaw hokofa woyko enta goyinnofa. Ayis giiko, taani, Goday ne Xoossay, ta bonchuwa hara xoossatara koxonna Xoosse. Tana ixiya aawata nagaraa gisho nayta heedzantho woyko oyddantho yeletethi gakanaw hanqana. ");
INSERT INTO gofl_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Shin tana siiqeysatanne ta kiita naageysata sheesha mukulu yeletethi gakanaw keehana. ");
INSERT INTO gofl_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“Xoossaa ne Godaa sunthaa hadan denthofa. Goday ba sunthaa hadan dentheyisata seeronna aggenna. ");
INSERT INTO gofl_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“Sambaata Geeshsha gallas oothada naaga. ");
INSERT INTO gofl_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Neeni ooso oothanaw bessiya usupun gallasati de7oosona. ");
INSERT INTO gofl_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Shin laapuntha gallasay neeni Godaa bonchiya shempo gallas. He gallasan ayba oosoka oothofa. Neeni, woyko ne nayti, woyko ne aylleti, woyko ne mehey, woyko ne biittan de7iya asa gade asati he gallasan ooso oothopite. ");
INSERT INTO gofl_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Usupun gallasa giddon Goday salota, sa7aa, abbanne enta giddon de7iya ubbaa medhis, shin laapuntha gallasan shempis. Hessa gisho, Goday Sambaata gallasaa anjisinne dummayis. ");
INSERT INTO gofl_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“Goday ne Xoossay new immiya biittan ne laythay aduqana mela ne aawanne ne aayiw boncha. ");
INSERT INTO gofl_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“Ase wodhopa. ");
INSERT INTO gofl_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“Laammofa. ");
INSERT INTO gofl_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“Kaysotopa. ");
INSERT INTO gofl_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“Ne laggiya bolla wordo markatofa. ");
INSERT INTO gofl_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“Ne laggiya keethaa amottofa. Ne laggiya machiw, woyko iya aylleta, woyko iya mehiya, woyko iya hariya, woyko iyaw de7iyaba aybaka amottofa” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Asa ubbay deshoy decheysanne moyzey puneteysa si7idi, wol7anthay wol7ameysanne derey cuyeysa be7idi yashshan kokorishe haahon eqidosona. ");
INSERT INTO gofl_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Enti Museko, “Neeni nuus oda; nuuni si7ana. Shin nuuni hayqonna mela Xoossay nuus odopo” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Musey asaako, “Yayyofite; Xoossay hintena paacanawunne hinte iyaw kiitetidi nagara oothonna mela I yis” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Asay banta de7iyasuwan haakidi eqidashin, Xoossay de7iyasuwa muumida shaarako Musey shiiqis. ");
INSERT INTO gofl_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Hessafe guye, Goday Museko “Isra7eele asaas haysada yaagada oda; ‘Salope taani hintew odishin hinte tana hinte huuphen be7ideta. ");
INSERT INTO gofl_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Yaaniya gisho, bira eeqa woyko worqa eeqa hintew oothidi ta bolla gujidi goyinnofite. ");
INSERT INTO gofl_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Neeni taw yarsho bessi urqafe giigisa. Ne dorsatapenne ne booratape ekada xuussa yarshonne issifetetha yarsho iya bolla yarsha. Hinte tana goyinnana mela taani doorida bessa ubban hinteko yada hintena anjana. ");
INSERT INTO gofl_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Neeni taw yarsho bessi shuchafe keexiyaba gidiko masetida shuchafe keexofa. Neeni massiya miishen iya bochiko tunisaasa. ");
INSERT INTO gofl_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Neeni keyashe kallotonna mela taw yarsho bessi kodora keyiya bessan keexofa’ ” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Goday Muse baggara ba deriyas immida wogay haysa; ");
INSERT INTO gofl_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“Ne Ibraawe aylle shammiko, I new usupun laythi ootho, shin laapuntha laythan aykoka qanxonna, aylletethaafe coo yedeto. ");
INSERT INTO gofl_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","I macho ekona shametidaba gidiko, barka yedeto. I machidi, shametidaba gidiko, iya machiyaka iyara yedeto. ");
INSERT INTO gofl_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Iya goday iyaw macho immidaba gidikonne machiya iyaw adde nayta woyko macca nayta yelidaba gidiko, iya machiyanne I nayti iya godaaba gido; addey barka yedeto. ");
INSERT INTO gofl_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Shin aylley, ‘Taani ta godaa, ta machiwnne ta nayta dosayis’ gidi aylletethaafe keyanaw koyonna ixiko, ");
INSERT INTO gofl_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","iya goday, Godaa sinthe iya aatho. Yaatidi, penge woyko penge zizgiya matan iya essidi, iya haythaa goothan luko. Hessafe guye, I ba de7o laytha ubban iyaw aylle gido. ");
INSERT INTO gofl_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“Issi asi ba macca na7iw aylletethas bayziko, adde aylletatho aylletethaafe keyopo. ");
INSERT INTO gofl_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Iyo shammidi machanaw efida goday iyo dosona ixiko, I goday iyo deriyan woziso. I goday I bolla iitabaa oothida gisho, iyo allagas bayzanaw danda7ena. ");
INSERT INTO gofl_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","I iyo ba na7aas immanaw koyiko, ba macca na7atho oothidi eko. ");
INSERT INTO gofl_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","I hara macho I bolla ekiko, koyro machees kathi, ma7onne indas bessiya woga iw pacisopo. ");
INSERT INTO gofl_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","I ha heedzubata iw oothonna ixiko, aybi miisheka qanxonna aylletethaafe keyada boo.” ");
INSERT INTO gofl_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“Ase shocidi wodhiya oonika hayqanaw bessees. ");
INSERT INTO gofl_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","I wodhanaw qoponna iyape hayqiyaba gidiko, I baqatidi attana bessi taani iyaw giigisana. ");
INSERT INTO gofl_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Shin asi qopidi hara asi wodhiko, he uray ta yarsho bessi biiko yaape diggada hara bessan wodha. ");
INSERT INTO gofl_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“Ba aawa woyko ba aayiw dechiya oonika hayqo. ");
INSERT INTO gofl_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“Ase bayzanaw woyko haaranaw wolqan oykiya asi hayqanaw bessees. ");
INSERT INTO gofl_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“Ba aawa woyko ba aayiw cayey hayqo. ");
INSERT INTO gofl_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“Nam7u asati ooyetidi, issoy issuwa shuchan caddidi qoo7iko, woyko zhultiko, he deshetidaysi hayqonna attidi hargidi hiixan pee7iko, ");
INSERT INTO gofl_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","dendidi guufetidi kare heeran hemetiko, he dechidaysi hayqope attees. Gidikoka I iya oosope ashshida gisho, accanawunne paxana gakanaw hargisanaw koshshees. ");
INSERT INTO gofl_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“Issi asi ba adde aylliya woyko macca aylliw xam7an shocidi wodhiko seeretanaw bessees. ");
INSERT INTO gofl_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Shin he aylley issi woyko nam7u gallasa giddon hayqonna ixiko, iya goday seeretofo. He aylley iya shalo gidiya gisho iya hayqoy baw seera. ");
INSERT INTO gofl_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“Nam7u asati issoy issuwara wadhetidi qanxatida maccasiw dechidi, iya boshetana mela oothiko, hara iita qoho gathonna ixiko, he dechida uray, he mache azinay oychiya aca daynnati pirdiko ciggo. ");
INSERT INTO gofl_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Shin he maccase deshethay dariko, shempo gisho shempo, ");
INSERT INTO gofl_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","ayfe gisho ayfe, acha gisho ache, kushe gisho kushe, toho gisho toho, ");
INSERT INTO gofl_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","xuussa gisho xuussi, maduntha gisho madunthi, qoo7o gisho qoo7o ekanaw koshshees. ");
INSERT INTO gofl_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“Issi asi ba adde aylliyas woyko macca ayllees ayfe baqidi toysiko, he ayfiya gisho aylletethafe kessi yeddo. ");
INSERT INTO gofl_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Hessadaka, ba aylliya ache woyko ba aylle ache menthiko, he acha gisho aylletethafe kessi yeddo. ");
INSERT INTO gofl_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“Boori ase qaycidi wodhiko, he booray shuchan caddeti hayqo. Iya ashoy meetetofo, shin boora goday seeretofo. ");
INSERT INTO gofl_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Shin booray kaseka qayciyaba gidikonne koyrottidi boora godaas odetin, I qachonna ixidaba gidiko, he booray ase wodhiko, booraynne boora goday issife shuchan cadetidi hayqo. ");
INSERT INTO gofl_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Shin boora goday aca qanxana mela oyshetiko, enti oychidaba qanxidi ba shempuwa wozo. ");
INSERT INTO gofl_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Booray adde na7a woyko macca na7a qaycidi wodhiko pirday iya mela gido. ");
INSERT INTO gofl_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Booray adde aylle woyko macca aylle qaycidi wodhiko, boora goday aylliya godaas hastamu bira santime qanxo; booray shuchan caddetidi hayqo. ");
INSERT INTO gofl_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“Issi asi olla bookidi kammonna aggiko woyko kamaa denthin boori woyko harey he ollan wulliko, ");
INSERT INTO gofl_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","he ollaa goday mehiya gatiya qanxo. I iya godaas gatiya qanxidi, hayqida mehiya baw eko. ");
INSERT INTO gofl_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“Issi asa boori hara asa boori caddidi wodhiko, paxa boora bayzidi, iya miishiyanne hayqida boora ashuwa nam7ay shaaki eko. ");
INSERT INTO gofl_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Shin he booray kaseka qayciyaba gideysa erishe, iya goday qachonna aggidaba gidiko, he uray iyaw boori qanxo. Yaatidi, he hayqidaysa baw eko.” ");
INSERT INTO gofl_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“Issi asi boori woyko dorse kaysidi shukiko, woyko bayziko, boora gisho ichashu boorata, dorsaa gisho oyddu dorsata ciggo. ");
INSERT INTO gofl_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","“Kaysoy keethe bookishe oyketidi shocetidi hayqiko, shoci wodhidaysi oyshetenna. ");
INSERT INTO gofl_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Shin hessi haniday gallas gidiko, I he gusida suuthaa acuwan oyshetees. Kaysoy ba kaysidaysa zaaro, shin iyaw zaaranabay dhayko ba huuphen aylletethas bayzeto. ");
INSERT INTO gofl_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","I kaysida mehey paxa de7ishe iya kushen bentiko, boori woyko hare woyko dorse gidiko, I kaysidaysas nam7u kushe ciggo. ");
INSERT INTO gofl_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“Issi asi ba mehiya denban woyko woyne gaden heemmishin, mehey hara asa kathi miiko, I ba kathaafe woyko ba woyniyape lo77uwa aca qanxo. ");
INSERT INTO gofl_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“Issi asi ba gaden tama xuuggishin tamay buuriya kanthidi hara asa gaden dicciya kathaanne dooriya miiko, tama oythida uray aco qanxo. ");
INSERT INTO gofl_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“Issi asi bira woyko hara al7o miishe ba shooruwas hadara immin, he shooruwa soope kaysoy he miishiya ekikonne he kaysoy oyketiko, he kaysoy miishiya nam7u kushe ciggo. ");
INSERT INTO gofl_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Shin kaysoy bentonna ixiko, uray Xoossaa sinthe shiiqidi, ba shooruwa miishiya, I ekonnaysa erisanaw caaqo. ");
INSERT INTO gofl_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","“Nam7u asati boora gaason woyko hare gaason woyko dorsa gaason woyko ma7o gaason woyko hara dhaydaba gaason mootetidi, Xoossaa sinthe shiiqiko, Xoossay iya bolla pirdidaysi nam7u kushe ciggo. ");
INSERT INTO gofl_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“Issi asi hare woyko boori woyko dorse woyko hara mehe hadara immidasuwan hayqiko woyko me7iko woyko oonika be77onna kaysotetiko, ");
INSERT INTO gofl_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","hadaro ekidaysi ba laggiya mehiya kaysotonaysa Godaa sinthan caaqo. He mehiya goday caaquwa eko; mehey iyape dhayida uray cigganaw koshshenna. ");
INSERT INTO gofl_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Shin mehey kaysotetidaba gidiko, mehiya godaas ciggo. ");
INSERT INTO gofl_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","He mehiya do7i midaba gidiko, marka gidanaada gawuxaa eho; do7i midaba gidiko iyaw ciggofo. ");
INSERT INTO gofl_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“Asi ba shooruwape mehe woossi ekiko iya goday bayna bessan he mehey deshetiko woyko hayqiko, he mehiyas ciga immo. ");
INSERT INTO gofl_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Shin iya goday iyara de7ishin hessi hanidaba gidiko aca qanxofo. Hashe ekidaba gidiko, he hashe miishey aco gate gido. ");
INSERT INTO gofl_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“Issi asi issi geela7iw cimmidi, iira zin7etiyaba gidiko, iw aca immidi, baw macho ootho. ");
INSERT INTO gofl_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","I aaway iyo iyaw immanaw koyona ixiko, geela7o ekiya uray aca immiya miishe mela I aawas immidi acco. ");
INSERT INTO gofl_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“Bita bitiya maccasi hayqo. ");
INSERT INTO gofl_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“Mehera tuniya oonika hayqo. ");
INSERT INTO gofl_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“Xoossaafe hara godatas yarshiya oonika hayqo. ");
INSERT INTO gofl_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Hinte Gibxe biittan bete asi gididi, de7ida gisho, bete asi qohopite woyko un7ethofite. ");
INSERT INTO gofl_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Am7etanne yi7ota un7ethofite. ");
INSERT INTO gofl_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Hinte enta un7ethiko, enti taako waassana; ");
INSERT INTO gofl_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","taani enta waasuwa si7ana. He wode ta hinte bolla hanqetada hintena olan wursana. Hinte macheti am7o, hinte naytika aawu baynayisata gidana. ");
INSERT INTO gofl_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“Hinte giddon de7iya manqo gidida ta asaape oodeska miishe tal7iko, yelon tal7iya asada yelo oychofite. ");
INSERT INTO gofl_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Neeni issiba gisho, iya ma7uwa oykida asi de7iko, awi wullonna de7ishin iya ma7uwa zaara. ");
INSERT INTO gofl_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","I ma7idi aqey I xalaala. I hara ay ma7idi aqanaw danda7ii? Taani qadhetiya Xoossi gidiya gisho, I taako waassiya wode si7ana. ");
INSERT INTO gofl_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“Xoossaa bolla cashsha qaala haasayopa, woyko ne deriya ayseysa baaddofa. ");
INSERT INTO gofl_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Ne kathaafe, ne woyne ushshafenne ne shamaho zaytiyape taw yarsho yarsha. “Bayra gididi yeletida adde na7aa taw imma. ");
INSERT INTO gofl_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Ne miizapenne ne dorsaafe bayra yeletidaysa taw imma. Enti laapun gallas gakanaw, banta aayetara gam7o; hospuntho gallasan enta taw imma. ");
INSERT INTO gofl_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“Hinte taw geeshsha asi gidanaw koshshees. Hessa gisho, do7i menthidi wodhida mehe asho moopite; hessa kanas yeggite.” ");
INSERT INTO gofl_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“Wordo oda gasethofa; wordo markatada bala asi maaddofa. ");
INSERT INTO gofl_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Iitaba oothanaw daro asaa kaallofa. Pirda wobisanaw daro asaara issifada markatofa. ");
INSERT INTO gofl_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Manqoy pirdas shiiqiya wode iya manqotetha be7ada maaddofa. ");
INSERT INTO gofl_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“Ne morkiya booray woyko harey dhayin demmiko, zaarada iyaw efa. ");
INSERT INTO gofl_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Nena ixiya uraa harey caanara kundin be7ada, uraa maaddada denthona aggada aadhofa. ");
INSERT INTO gofl_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“Pirda dabaaban manqoy pirdas shiiqiya wode iya pirdaa wobbisopa. ");
INSERT INTO gofl_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Oonaka malten mootopa; xilluwa wodhopa. Hessa melaba oothidaysa taani pirdonna aggike. ");
INSERT INTO gofl_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Wodhaafe ekofa; wodhaafey suure xeelliya asa ayfe qooqisees, xillota pirdaa mirqees. ");
INSERT INTO gofl_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“Betanchuwa naaqofa. Hinte Gibxe biittan bete asi gididi de7ida gisho, asa gade asi gidoy ay mela si7etiyako ereeta. ");
INSERT INTO gofl_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“Neeni ne gadiya usupun laythi goyada ma. ");
INSERT INTO gofl_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Laapuntha laythan gadiya goyonna shaacha; iyan dolidi kaxiyaba shiishopa. Ne asaa giddon de7iya manqoti iyape mo; qassi entafe attidaysa do7ati mo. Ne woyne gadiyanne ne shamaho gadiya hessada ootha. ");
INSERT INTO gofl_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“Neeni usupun gallas ooso ootha. Ne booraynne ne harey shempana melanne ne son yeletida aylleynne bete asi shempana mela laapuntha gallasan ooso oothofa. ");
INSERT INTO gofl_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Taani hintew odidaba ubbaa minthidi oothite. Hara xoossata sunthaa xeegidi woossofite; enta sunthaa denthofite. ");
INSERT INTO gofl_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“Tana bonchanaw laythan heedzu ba7aale gallasati hintew de7o. ");
INSERT INTO gofl_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Hinte Gibxefe keyida Abiiba geetetiya ageenan, taani hintena kiitidaysada Uytha Ba7aale bonchite. Laapun gallas irsho yeggidi uukida uythi moopite. Tana goyinnanaw yishe mela kushe yoopite. ");
INSERT INTO gofl_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“Qassi hinte, hinte gaden zerin, koyro gakida kathaa cakiya wode Kathaa Cako Ba7aale bonchite. “Laytha wursethan, woyniyanne hessa mela mithata ayfiya hinte gadepe maxiya wode Shaqara Ba7aale bonchite. ");
INSERT INTO gofl_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Laythan laythan bonchetiya ha heedzu ba7aaletan adde ubbay tana, hinte Godaa goyinnanaw yo. ");
INSERT INTO gofl_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“Neeni taw mehe yarshiya wode irsho yeggidi uukida uythara taw yarshofa. Ba7aale bonchiya gallas yarshetida modhuwafe wontas aybika attofo. ");
INSERT INTO gofl_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Hinte gaden bayra kaxida katha ubbaafe lo77uwa Godaa, hinte Xoossaa soo ehite. Deesha mari woyko dorsa mari iya aaye maathan doysopa. ");
INSERT INTO gofl_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“Ne ogiyan nena naagana malanne taani new giigisida bessaa nena efana mela taani kiitancho ne sinthan kiittana. ");
INSERT INTO gofl_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","I odiyaba si7ada iyaw kiiteta; iya bolla Makallofa. Ta iyaw maata immida gisho, hinte nagara oothiyaba gidiko, hinte nagaraa maarenna. ");
INSERT INTO gofl_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Hinte iyaw kiitetikonne ta kiita ubbaa poliko, hinte morketa ubbaa morkana; hintera eqeteyisata taani olana. ");
INSERT INTO gofl_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Ta kiitanchoy hinte sinthan bidi, hintena Amooreta, Hiteta, Parzeta, Kanaaneta, Hiwetanne Yaabuseta biitta ehana. Taani enta dhaysana. ");
INSERT INTO gofl_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Enta xoossatas ziggofite woyko goyinnofite, woyko enta ammano wogaa kaallopite. Enta xoossata dhaysite, enta eeqa shuchata mentherethite. ");
INSERT INTO gofl_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Godaa, hinte Xoossaa tana, goyinnite. Hessada hinte oothiko, taani hinte kathaanne hinte haatha anjana; hargiyaka hinte giddofe diggana. ");
INSERT INTO gofl_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Hinte biittan maccasay boshetenna; maynnena. Taani hinte laytha adussana. ");
INSERT INTO gofl_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“Taani ne morketa bolla ta yashsha yeddana. Hintera eqetiya kawotethata ubbaa daganthana. Hinte morketi ubbay hintew zoko zaaridi baqatana mela oothana. ");
INSERT INTO gofl_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Taani hinte morketa bolla kazhe yeddada Hiweta, Kanaanetanne Hiteta hinte sinthafe goodda kessana. ");
INSERT INTO gofl_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Shin biittay mela attonaadanne bazzo do7i hintena waaysonaada issi laythan enta goodike. ");
INSERT INTO gofl_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Shin hinte taybon daridi, minnidi, he biitta laattana gakanaw enta guuthara guuthara goodda kessana. ");
INSERT INTO gofl_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Taani hinte zawa Zo7o Abbaafe Filisxeeme Abbaa, mela biittafe bidi Efraxiisa Shaafa gakanaw dalgisana. He biittan de7iya ubbaa taani hinte kushen aathada immana; hinteka enta gooddidi kessana. ");
INSERT INTO gofl_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Entara woyko enta xoossatara caaqo oothopite. ");
INSERT INTO gofl_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Enta hinte biittan wothofite. Hankoode enti hintena ta bolla nagara oosisana. Enta xoossata hinte goyinniko hintew xihe gidana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Goday Museko, “Neeni, Aaroni, Naadabi Abyoodanne Isra7eele cimatape laapun tammu asati taako zuma bolla keyidi, haahon eqidi, gufannidi, taw goyinnite. ");
INSERT INTO gofl_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Shin neeni nerka taako shiiqa; harati ta mati shiiqopo. Qassi asayka neera zuma bolla keyopo” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Musey bidi, Godaa qaalanne woga ubbaa asaas odin, asa ubbay issi qaalan, “Goday gidaba ubbaa nuuni oothana” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Musey Goday odidaba ubbaa xaafis. Wontetha gallas guura dendidi, zumaa garsan yarsho besse giigisis. Tammanne nam7u Isra7eele sheeshata sunthan, tammanne nam7u shucha tuussi essis. ");
INSERT INTO gofl_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Isra7eele panthata I kiittin, enti bidi xuussa yarshuwanne issifetetha yarshuwas kormata shukidi, Godaas yarshidosona. ");
INSERT INTO gofl_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Musey mehiya suuthaafe bagga ekidi keriyan tigis; attida bagga suuthaa yarsho bessan dharcis. ");
INSERT INTO gofl_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Hessafe guye, Caaqo Maxaafa ekidi, asaas nabbabin, enti, “Goday gidaba ubbaa nuuni oothana; nuuni iya kiita polana” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Hessafe guye, Musey he suuthaa ekidi, asaa bolla dharcidi, enta, “Goday hintew ha kiitata immiya wode hintera gelida caaquwa minthiya suuthay haysa” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Musey, Aaroni, Naadabi, Abyoodanne Isra7eele cimatape laapun tammay zumaa bolla keyidi, ");
INSERT INTO gofl_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Isra7eele Xoossaa be7idosona. Iya tohuwape garsan saloda geeyida, sanpare geetetiya shuchafe oosetidaba daaniya demba bessi de7ees. ");
INSERT INTO gofl_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Shin Xoossay Isra7eele asaa halaqata wodhibeenna. Enti Xoossaa be7idosona; iya sinthan midosonanne uyidosona. ");
INSERT INTO gofl_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Goday Museko, “Neeni taako zumaa bolla haa keyada, haysan gam7a. Ta asay taw kiitetana mela nam7u loche shuchata bolla ta kushen ta xaafida higgeta new immana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Museynne iyaw kiitetiya Iyyasuy baanaw dendidosona; Musey Xoossara gahetanaw zumaa bolla keyis. ");
INSERT INTO gofl_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Musey Isra7eele cimatako, “Nuuni hinteko simmana gakanaw haysan gam7ite. Aaroninne Huuri haysan hintera de7oosona; odi de7iya oonika entako boo” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Musey zumaa bolla keyida wode shaaray zumaa ma7is. ");
INSERT INTO gofl_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Godaa bonchoy Siina Zumaa bolla uttis. He shaaray usupun gallas zuma bolla ma7is; laapuntha gallas Goday shaara giddon gididi Muse xeegis. ");
INSERT INTO gofl_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Zumaa bolla qoncida Godaa bonchoy Isra7eeletas tama laco daanidi bentis. ");
INSERT INTO gofl_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Hessafe guye, Musey zumaa huuphiya keyidi shaara giddo gelis; yan oytamu gallasinne oytamu qamma gam7is. ");
INSERT INTO gofl_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Goday Museko haysada yaagis; ");
INSERT INTO gofl_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Taw imota ehana mela Isra7eeletas oda. Iya wozani iya imma imma gidaba immiya imota asa ubbaafe taw eka. ");
INSERT INTO gofl_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Hinte entafe ekana imotay, worqaa, bira, naase birata, ");
INSERT INTO gofl_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","kaalose qacina, ocha teera daaniya qacina, zo7o qacinanne al7o liino, deesha ikise, ");
INSERT INTO gofl_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","haashetidi zo7o qalamen tiyetida dorsa ite, lo77o do7a ite, soqala mithi, ");
INSERT INTO gofl_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","xompes maaddiya shamaho zayte, shuumatetha zayteninne ixaanen guzhetiya sawota, ");
INSERT INTO gofl_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","Kahine halaqay ma7iya efuude geetetiya ma7uwa bollanne iya tiran wosetiya margide geetetiya al7o shuchaanne hara alleeqo shuchata eho. ");
INSERT INTO gofl_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Taani enta giddon daana mela enti tana goyinniya bessi giigiso.” ");
INSERT INTO gofl_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Dunkaaniyanne iya giddon de7iya miisheta ubbaa ta nena bessiya maaran ootha. ");
INSERT INTO gofl_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“Soqala mithafe, adussatethay nam7u wadhanne takadho, gompay issi wadhanne takadho, geesay issi wadhanne takadho gidiya saaxine oothite. ");
INSERT INTO gofl_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Gaathaanne kariya walahi bayna worqan kamma; iya yuushuwaka worqan lanxa. ");
INSERT INTO gofl_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","He Taabotiyas oyddu worqa sagaayota oothada; oyddu gedata bolla issi baggara nam7u sagaayota, qassi hanko baggara nam7u sagaayota aathada gasetha. ");
INSERT INTO gofl_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Taabotiya tookiya kaso mithata soqala mithafe kessada worqan lanxa. ");
INSERT INTO gofl_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Taabotiya tookanaw iya miyen de7iya sagaayotan kaso mithata aatha. ");
INSERT INTO gofl_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Tookiya kaso mithati Taabotiya sagaayota giddon de7o; enti yaape keyopo. ");
INSERT INTO gofl_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Taabotiya giddon taani new immiya, tammu kiitati xaafetida nam7u loche shuchata wotha. ");
INSERT INTO gofl_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“Walahi bayna worqafe adussatethay nam7u wadhanne takadho, gompay issi wadhanne takadho gidiya nagara atotetha kama ootha. ");
INSERT INTO gofl_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Qefera de7iya nam7u kiruubeta worqafe qoxada ootha. ");
INSERT INTO gofl_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Issi kiruubiya issi bagga gaxan, nam7antho kiruubiya hanko bagga gaxan wothada nam7aa Taabotiya guphiyara oythada ootha. ");
INSERT INTO gofl_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Kiruubeti woliko simmi uttidi, banta qefiya denthidi, atotetha kamaa kammo. ");
INSERT INTO gofl_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Taani new immiya loche shucha bolla xaafetida tammu kiitata Taabotiya giddon wotha. Yaatada, guphiya Taabotiya bolla wotha. ");
INSERT INTO gofl_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Taabotiya guphiya bolla de7iya nam7u kiruubetape giddon gidada taani neera gahetana. Isra7eele asaas immiya kiita ubbaa taani yan new immana.” ");
INSERT INTO gofl_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“Soqala mithafe adussatethay nam7u wadha, gompay issi wadha, geesay issi wadhanne takadho gidiya issi xarpheeza ootha. ");
INSERT INTO gofl_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Yaatada, walahi bayna worqan lanxa; iya yuushuwaka worqan lanxa. ");
INSERT INTO gofl_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Hessadaka, gompay takadho gidiya goossa iya bolla yuushsha aatha. Yaatada, iya yuushuwa worqan lanxa. ");
INSERT INTO gofl_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","He xarpheezas oyddu worqa sagaayota oothada, xarpheezaa oyddu tohotara oytha. ");
INSERT INTO gofl_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Xarpheezaa tookanaw kaso mithata aathiya sagaayoti xarpheeza goossaa matan shiiqidi de7o. ");
INSERT INTO gofl_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","He tookiya kasota soqala mithafe kessada, worqan lanxa. ");
INSERT INTO gofl_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Hessadaka, shaatetanne cilpata, woyne yarshuwa duuqiya miishetanne xuu7ata walahi bayna worqafe ootha. ");
INSERT INTO gofl_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Xarpheezay Taabotiyas sintha baggara utto. Ta sinthan uttiya geeshsha uythay ubba wode xarpheezaa bollafe dhayopo.” ");
INSERT INTO gofl_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“Xompe wothiya kocaa walahi bayna worqafe ootha. He kocay eqiya tohuwanne tooma worqafe qoxada ootha. Alleeqos oosetiya wallaxati, gambuthatinne ciishshati ubbay issino gididi oosetanaw bessees. ");
INSERT INTO gofl_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Nam7u baggara, heedzu heedzu tasheta iyaw kessa. ");
INSERT INTO gofl_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Usupun tashetas xeeran xeeran heedzu heedzu alleeqo gambuthatinne ciishshati de7iya lawuze mitha ciishshe daaniyabay de7o. ");
INSERT INTO gofl_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Xompiya wothiya kocaa giddon de7iya tooma xeeran oyddu alleeqo gambuthatinne ciishshati de7iya lawuze mitha ciishshe daaniyabay de7o. ");
INSERT INTO gofl_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Tashetape garsan, nam7u tasheti gahetiya bessan issi issi gambuthi de7o. ");
INSERT INTO gofl_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Gambuthay, tasheynne xompiya wothiya kocay issino gididi, walahi bayna worqafe qoxetidi ooseto. ");
INSERT INTO gofl_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","“Xompe wothiya kocaa bolla laapun xompeta giigisada, enti sinthe poo7ana mela dhoqu oothada wotha. ");
INSERT INTO gofl_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Xompiya naaganaw maaddiya Qaphetanne enta wothiyabata walahi bayna worqafe ootha. ");
INSERT INTO gofl_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Xompe wothiya kocaynne iya miisheti ubbay hastamanne ichashu kilo giraame gidiya walahi bayna worqafe ooseto. ");
INSERT INTO gofl_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Taani nena zumaa bolla bessida leemisuwa kaallada, akeekada ootha.” ");
INSERT INTO gofl_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“Dunkaaniya gaatha baggaas al7o liinope oosetida, tammu geshe giigisa. Enta kaalose, ocha teera daaneysaninne zo7o qacinan daddada kiruubeta misiliyara alleeqisa. ");
INSERT INTO gofl_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Gesheti ubbay issi like gido; adussatethay laatamanne oydda, gompay qassi oyddu wadha gido. ");
INSERT INTO gofl_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Ichashu gesheta issife gathada sika; hanko attida ichashata hessada ootha. ");
INSERT INTO gofl_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Issife gahetidi siketida nam7u geshetas issuwa issuwa gaxan kaalose afilape oosetida sagaayota ootha. ");
INSERT INTO gofl_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Issife siketida koyro magarajuwa bolla koyro maaran kaalose afilape oosetida ishatamu sagaayota ootha; hessadaka nam7antho magarajuwa bolla wursetha gaxan ishatamu sagaayota ootha. ");
INSERT INTO gofl_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Geeshsha Dunkaaney issino gidana mela nam7un shaaketi siketida gesheta woli gathidi oysethanaw, ishatamu worqafe oosetida oykiyabata ootha. ");
INSERT INTO gofl_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“Geeshsha Dunkaaniya bollara kammana mela tammanne issi gesheta deesha ikisepe ootha. ");
INSERT INTO gofl_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Tammanne issi gesheti issi gina gido; issi issi magarajuwa adussatethay hastamu wadha, gompay oyddu wadha gido. ");
INSERT INTO gofl_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Ichashu gesheta issi baggara, usupun gesheta hanko baggara gathada sika. Usupuntho magarajoy dakoyetidi, dunkaaniyas sintha baggara daabuleto. ");
INSERT INTO gofl_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Woli gathi sikida geshetape issi magarajuwas macara bolla ishatamu sagaayota ootha; qassi hanko magarajuwas macara bolla ishatamu sagaayota ootha. ");
INSERT INTO gofl_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Nam7un shaaketi siketida gesheti issi kama gidana mela ishatamu naase biratape oosetida oykiyabata ootha. ");
INSERT INTO gofl_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","He dunkaaniya geshetape palahida baggaa ekada Geeshsha Dunkaaniyas guye baggara kaqa. ");
INSERT INTO gofl_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Dunkaaniya geshetape adusatetha baggara palahida gompay issi issi wadha gidida gesheta Geeshsha Dunkaaniyas nam7u baggara kaqa. ");
INSERT INTO gofl_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","“Dunkaaniyas bolla baggara daabulidi kammanaw zo7o qalamen tiyetida maraze itenne lo77o do7a ite ootha. ");
INSERT INTO gofl_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Geeshsha Dunkaaniya tuuqeta soqala mithafe ootha. ");
INSERT INTO gofl_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Issi issi tuuqiya adussatethay tammu wadha, gompay issi wadhanne bagga gido. ");
INSERT INTO gofl_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Nam7u tuuqeti issife oyketana mela issi issi tuuqiyas oysethiyabay de7o. Geeshsha Dunkaaniya tuuqeta ubbaa hessada ootha. ");
INSERT INTO gofl_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Geeshsha Dunkaaniya wuloha baggara laatamu tuuqeta ootha. ");
INSERT INTO gofl_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Entana essanaw enta garsan bira biratape oosetida oytamu luhoy de7iya tohota ootha. Issi issi tuuqiyas nam7u nam7u toho kessa. ");
INSERT INTO gofl_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Geeshsha Dunkaaniya pudeha baggara laatamu tuuqeta ootha. ");
INSERT INTO gofl_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","Entana essanaw enta garsan bira biratape oosetida oytamu luhoy de7iya tohota ootha. Issi issi tuuqiyas nam7u nam7u toho kessa. ");
INSERT INTO gofl_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Geeshsha Dunkaaniyas guyera wuloha baggara usupun tuuqeta ootha. ");
INSERT INTO gofl_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Guye baggara de7iya maazanetas nam7u tuuqeta ootha. ");
INSERT INTO gofl_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","He maazaniyan de7iya tuuqeti tohope huuphe gakanaw oyketo. Nam7u maazaneta medhiya nam7u tuuqeta hessatho oosetanaw bessees. ");
INSERT INTO gofl_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Hessadaka nam7u nam7u tohoy de7iya hospun tuuqeta oothada, entaw bira biratape oosetida tammanne usupun luhoy de7iya tohota ootha. ");
INSERT INTO gofl_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“Tuuqeta sathidi oythiya soqala mithafe oosetida tammanne ichashu liyoota kessa. Entafe ichashata Geeshsha Dunkaaniyas issi bagga miyen de7iya tuuqetas, ");
INSERT INTO gofl_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","qassi ichashata hanko bagga miyen de7iya tuuqetas, hessadaka attida ichashata wuloha baggan de7iya tuuqetas ootha. ");
INSERT INTO gofl_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Ha gaxa tuuqiyapenne ya gaxa tuuqiyape yaa liyooti giddo tuuqiyara oyketo. ");
INSERT INTO gofl_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Tuuqeta worqan lanxa; liyoota oykanaw maaddiya sagaayota worqafe ootha; qassi liyoota worqan lanxa. ");
INSERT INTO gofl_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Geeshsha Dunkaaniya zumaa bolla ta nena bessidaysada ootha. ");
INSERT INTO gofl_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“Al7o liinope issi magarajo oothada, iya kaalose, ocha teera daaneysaninne zo7o qacinan daddada kiruubeta misilen alleeqisa. ");
INSERT INTO gofl_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Iya soqala mithafe oothada, worqan meeshetida kocataninne bira biratape oosetida oyddu tohoy de7iya tuussata bolla kaqa. ");
INSERT INTO gofl_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","He magarajuwa Geeshsha Dunkaaniyas kaaran de7iya qaphetape garsan kaqa. Yaatada higgey xaafetida nam7u loche shuchata oykida Caaqo Taabotiya magarajuwas guye baggan wotha. He geshey, Geeshsha Bessaanne Ubbaafe Geeshsha Bessaafe shaakees. ");
INSERT INTO gofl_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Nagara atotetha kaman Caaqo Taabotiya kamma. ");
INSERT INTO gofl_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Xarpheezaa, Ubbaafe Geeshsha Bessaafe karera, Geeshsha Dunkaaniyape pudeha baggan wotha; xompe wothiya kocaa dugeha baggara wotha. ");
INSERT INTO gofl_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“Dunkaaniya penge magarajuwa, al7o liinope giigisada, kaalose, ocha teera daaneysaninne zo7o qacinan daddada alleeqisa. ");
INSERT INTO gofl_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Magarajuwas ichashu tuussata soqala mithafe oothada worqan lanxa; kocatika worqafe oosetidaysata gido. Tuussatas naase biratape ichashu tohota giigisa.” ");
INSERT INTO gofl_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“Soqala mithafe yarsho bessi ootha. Adussatethaynne gompay oyddu wadhanne takadho, geesay heedzu wadha gidida oyddu maazanera de7iya yarsho bessi ootha. ");
INSERT INTO gofl_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Oyddu maazaneta bolla kace daaniyaba kessa; kaceti yarsho bessaara issino gididi ooseto. Yaatada, yarsho bessa ubbaa naase biratan laxa. ");
INSERT INTO gofl_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Iyaw go7etiya miisheta; bido kessiya kereta, akaafata, baldeta, asho qaphetanne cooceta ubbaa naase biratape ootha. ");
INSERT INTO gofl_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Yaatada, naase biratape zarzare daaniyaba oothada, iyaw oyddu maazaneta bolla oyddu sagaayota giigisa. ");
INSERT INTO gofl_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","He zarzariya yarsho bessa goossaafe garsan yarsho bessaas bagga zawa gathada wotha. ");
INSERT INTO gofl_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Soqala mithafe yarsho bessa tookiya kaso mithata kessada, naase biratan lanxa. ");
INSERT INTO gofl_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Yarsho bessaa tookiya wode maaddana mela he kaso mithata nam7u miyera de7iya sagaayotan aatha. ");
INSERT INTO gofl_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Taani nena zumaa bolla bessidaysada yarsho bessi xawulape oothada, gidduwa kaysi ootha.” ");
INSERT INTO gofl_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“Geeshsha Dunkaaniya dabaaba gechanaw al7o liinope magarajo giigisa. Geshetas adussatethay dugeha baggara xeetu wadha gido. ");
INSERT INTO gofl_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Iyaw kate gidana mela naase biratape oosetida laatamu tuussatanne laatamu tohota ootha. Enta bolla bira biratape oosetida xam7atanne kaceta ootha. ");
INSERT INTO gofl_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Dabaabas pudeha baggaraka hessada ootha. ");
INSERT INTO gofl_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","“Dabaabas wuloha bagga adussatethay ishatamu wadha gidida gesheti oosetidi, entaw tammu tohoy de7iya tuussati de7o. ");
INSERT INTO gofl_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Geliya wulay de7iya, doloha bagga dabaaba gompay ishatamu wadha gido. ");
INSERT INTO gofl_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Dabaaba pengiyafe issi baggara adussatethay tammanne ichashu wadha gidiya gesheti de7o; entaw heedzu tohoy de7iya heedzu tuussati de7o. ");
INSERT INTO gofl_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Hanko baggara de7iya geshetika hessada ooseto. ");
INSERT INTO gofl_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","“Dabaaba geliya wulaas adussatethay laatamu wadha gidiya, al7o liinope magarajo giigisada, kaalose, ocha teera daaneysaninne zo7o qacinan daddada alleeqisa. Enti iyan zempana mela oyddu tohora de7iya oyddu tuussata giigisa. ");
INSERT INTO gofl_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Dabaaba yuushuwan de7iya tuussati ubbay bira biratape oosetida xam7atan oyketo; enta kaceti bira biratape, enta tohoti naase biratape ooseto. ");
INSERT INTO gofl_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Dabaaba adussatethay xeetu wadha, gompay oytamu wadha, geesay ichashu wadha gido. Magarajoti al7o liinope, enta tohotika naase biratape ooseto. ");
INSERT INTO gofl_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","“Geeshsha Dunkaaniyan go7etiya miishe ubbay, dunkaaniyanne dabaaba dhisheti ubbay naase biratape ooseto. ");
INSERT INTO gofl_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“Xompey qamma poo7ishe aqana mela gum7i xillisida shamaho zayte new ehana mela Isra7eele asaa kiita. ");
INSERT INTO gofl_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Aaroninne iya nayti, poo7oy, Godaa sinthan omarsafe wonta gakanaw poo7ana mela Geeshsha Dunkaaniya giddon, Marka Taabotiya sinthan de7iya magarajuwafe kare baggara eetho. Hessi Isra7eele asaas merina woga gididi de7o. ");
INSERT INTO gofl_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“Ne ishaa Aaronanne iya nayta Nadaaba, Abyooda, Alaazaranne Itamaara neeko xeega. Enti kahine gididi taw haggaazana mela Isra7eele asaa giddofe enta dummaya. ");
INSERT INTO gofl_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Iyaw bonchonne teema immana mela ne ishaa Aaronas boncho ma7ota giigisa. ");
INSERT INTO gofl_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Aaroni kahinetethan dummatidi taw haggaazanaada, taani hiillatethi immida oosanchota ubbaa xeegada, Aaronas ma7ota giigisana mela oda. ");
INSERT INTO gofl_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Enti giigisana ma7otika haysata; tiran ma7etiya ma7o, efuude, adussa qamise, alleeqetidi dadetida shamize, qacenne danco. Ne ishay Aaroninne iya nayti kahine gididi taw haggaazishe ma7ana mela geeshsha ma7ota entaw giigiso. ");
INSERT INTO gofl_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Kushe hiillanchoti he ma7ota worqa cachafe, kaalosepe, ocha teera daaneysafe zo7o qacinapenne al7o liinope giigiso. ");
INSERT INTO gofl_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“Efuude geetetiya ma7uwa worqa cacha qacinape, kaalosepe, ocha teera daaneysafe, zo7o qacinapenne al7o liinope kushe hiillanchoti alleeqisidi giigiso. ");
INSERT INTO gofl_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Nam7u hashiyara wodhidi, nam7u baggaa woli gathidi qachanaw maaddiya qangoti de7o. ");
INSERT INTO gofl_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Efuudey oosetidabaape hiillan oosetida dancoy efuudiyara wolla oosetidaba gididi issife oyketo. ");
INSERT INTO gofl_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Margide geetetiya nam7u shuchata ekada, tammanne nam7u Yayqooba nayta sunthaa enta bolla woocada xaafa. ");
INSERT INTO gofl_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Enta yeleta maarada issi shucha bolla usupun sunthata, hanko shuchaa bolla attida usupun sunthata woocada xaafa. ");
INSERT INTO gofl_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Ha nam7u shuchata bolla tammanne nam7u Yayqooba nayta sunthaa woocadi xaafanaw hiillancho demma; he xaafetida shuchata efuudiya bolla oythanaw iya yuushuwa worqan lanxa. ");
INSERT INTO gofl_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Yaatada tammanne nam7u Isra7eele sheesha qofisiyaba gidana mela ha nam7u shuchata efuudiyara oythada hashiyara aadhiya qanguwa bolla wotha. Taani, Goday, ta asaa ubba wode hassayana mela Aaroni enta sunthaa ba hashiyan tooko. ");
INSERT INTO gofl_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","He shuchata oykeysa worqafe ootha. ");
INSERT INTO gofl_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","Qassi walahi bayna worqafe wodoroda dooqetida nam7u santhalaata hashiyara aadhiya qanguwara oyketana mela ootha. ");
INSERT INTO gofl_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“Godaa sheniya oychidi eranaw, tiran ma7etiya ma7uwa kushe hiillanchon oosisa. He tiran ma7etiya ma7uwa worqa cacha qacinape, kaalosepe, ocha teera daaneysafe, zo7o qacinapenne al7o liinope efuudiyada alleeqisidi giigiso. Kaalosepe oosetidabaape oothada alleeqisa. ");
INSERT INTO gofl_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Iyaw geesaynne gompay issi issi takadho gididi oyddu maazaney de7o. ");
INSERT INTO gofl_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Iyaw oyddu maaran al7o shuchata wotha. Koyro maaran sardiyoone, toophazenne phooliya al7o shuchata wotha. ");
INSERT INTO gofl_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Nam7antho maaran baluure, sanperenne almaaze geetetiya al7o shuchata wotha. ");
INSERT INTO gofl_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Heedzantho maaran yaakinte, kelqedoonenne ametesxinoosa geetetiya al7o shuchata wotha. ");
INSERT INTO gofl_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Oyddantho maaran birelle, margide, yasphide geetetiya al7o shuchata wotha. Haysati ubbay worqa kaquwa bolla woseto. ");
INSERT INTO gofl_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Isra7eele naytas qofiso gidana mela ha tammanne nam7u al7o shuchata, issi issi Yayqooba nayta sunthay, issi issi shucha bolla woocetidi xaafeto. ");
INSERT INTO gofl_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“Tiran ma7etiya ma7uwas walahi bayna worqafe wodoroda dooqada santhalaata ootha. ");
INSERT INTO gofl_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Nam7u worqa migiddota oothada, tiran ma7etiya ma7uwas qommo gaxa maazaniyan gathada oytha. ");
INSERT INTO gofl_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","He nam7u worqa santhalaatata migiddotara gathada oytha. ");
INSERT INTO gofl_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Hanko baggan de7iya nam7u santhalaata gaxa nam7u qangotara gasetha. Hessada oothada sintha baggara, hashiyara wodhiya efuudiya qanguwara gasetha. ");
INSERT INTO gofl_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Qassi nam7u worqa sagaayota oothada, efuudiyape gatha baggara kaallidi de7iya tiran ma7etiya ma7uwas nam7u maazaneta xeeran aatha. ");
INSERT INTO gofl_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Hessadaka, worqafe hara nam7u migiddota oothada, efuudiyas sintha bagga hashiyara wodhiya qanguwas garsa baggara gasetha. Efuudiya sikuwa matan dancuwaafe qommo baggara enta gasethanaw bessees. ");
INSERT INTO gofl_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Tiran ma7etiya ma7uwan de7iya migiddota efuudiyan de7iya migiddotara gathada kaalose qacinan qacha. Hessada oothiko, tiran ma7etiya ma7oy xeessafe qommon de7iya gisho, qashoy dol7enna. ");
INSERT INTO gofl_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“Aaroni Geeshsha bessa geliya wode Isra7eele mayzata sunthaa oykida, tiran ma7etiya ma7uwa ma7o. Yaaniya gisho, taani, Goday ubba wode ta asaa qopana. ");
INSERT INTO gofl_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Qassi saama yeggiya nam7u geeshsha shuchata tiran ma7etiya ma7uwan yegga. Aaroni Geeshsha dunkaaniya geliya wode ba tiran enta tookidi gelo. Ta sheniya Isra7eele asaa erisanaw ta sinthe geliya wode ubban tira kiisiyape dhaysofo. ");
INSERT INTO gofl_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“Efuudiyape bollara ma7iya adussa ma7uwa kumethi kaalose afilape giigisa. ");
INSERT INTO gofl_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","He adusse ma7uwas huuphe aathiya luho medha. He luhoy peedhetonna mela guye qalam7ada yuushsha aathada sika. ");
INSERT INTO gofl_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Adussa ma7uwas duge bagga macara yuushuwan kaalose, ocha teera daaneysaninne zo7o qacinape, oromaane teera misile medha. Yaatada enta giddon aatha aatha worqafe oosetida daalata ootha. ");
INSERT INTO gofl_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Worqa daalatinne oromaane teera misileti he adusse ma7uwas duge bagga macara yuushuwan aadho. ");
INSERT INTO gofl_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Aaroni kahinetethan oothiya wode ha adussa ma7uwa ma7o. Godaa sinthe, Geeshsha Bessaa geliya wodenne keyiya wode, daalay giirana; ika hayqenna. ");
INSERT INTO gofl_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Walahi bayna worqafe issi alleeqo oothada, iya bolla ‘Godaas Dummatis’ yaagada woocada xaafa. ");
INSERT INTO gofl_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Yaatada huuphiya qaciya bolla kaalose qacinara qacha. ");
INSERT INTO gofl_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Aaroni iya ba som7uwan wotho. Hessan Isra7eele asay Godaas imota immishe balidabay de7iko, he balaa Aaroni tookees. Asay ehiyaba Goday ekana mela I hessa ubba wode ba som7uwan wothanaw koshshees. ");
INSERT INTO gofl_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“Aarona shamziyanne qacciya al7o liinope dadda. Qassi dancuwaka al7o liinope daddada alleeqisa. ");
INSERT INTO gofl_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Aarona naytas bonchonne puula immana mela shamizeta, dancotanne huuphen wothiya qoobeta giigisa. ");
INSERT INTO gofl_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Neeni ha ma7ota ne ishaa Aaronanne iya nayta mayza. Enti kahinetethan taw haggaazana mela enta shamaho zayten tiyada taw dummaya. ");
INSERT INTO gofl_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Enta kalloy kametana mela garsan ma7iya ma7uwa xeessafe bidi wodire gakanaw kammiyaba al7o liinope sure giigisa. ");
INSERT INTO gofl_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Aaroninne iya nayti Geeshsha Dunkaaniya geliya wode woyko Geeshsha Bessan kahinetethan haggaazanaw yarsho bessi shiiqiya wode ha ma7ota ma7o. Hessada haniko, enti banta bolla hayqo ehokona. Hessi Aaronasinne iya sheeshatas merinaa woga gido. ");
INSERT INTO gofl_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“Aaroninne iya nayti kahinetethan taw haggaazana mela neeni enta dummayanaw haysada ootha; borey bayna wofaanonne nam7u maraze eka. ");
INSERT INTO gofl_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Geeshsha giste dhiille ekada, irsho yeggonna shamaho zaytera gindada uythu uuka. Qassi zaytey gelonna hara uythu uuka; hessadaka, lee7o uythu uukada zayten tiya. ");
INSERT INTO gofl_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Wofaanuwanne nam7u marazeta yarshiya wode he uytha ubbaa gaytan wothada taw shiisha. ");
INSERT INTO gofl_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","“Yaatada Aaronanne iya nayta Geeshsha Dunkaaniya penge ehada haathan enti meecetana mela oda. ");
INSERT INTO gofl_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Hessafe guye, kahinetetha ma7ota, shamziya, efuudiya, efuudiya bollara ma7iya adussa ma7uwanne tiran ma7etiya ma7uwa Aarona mayza; dancuwaka dancisa. ");
INSERT INTO gofl_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Qacciya qaccisa; iya bolla, ‘Godaas dummatis’ geetetidi xaafetida worqa alleequwa wotha. ");
INSERT INTO gofl_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Tishsha zaytiya ekada iya huuphiyan tigada tiya. ");
INSERT INTO gofl_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Iya nayta ehada shamziya mayza. ");
INSERT INTO gofl_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Enta xeessaa dancisa; enta huuphiyanka qoobe wotha. Aaronanne iya nayta yaatada kahinetethan shuuma. Hessika, entaw merina woga gido. ");
INSERT INTO gofl_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“Wofaanuwa Geeshsha Dunkaaniya sinthe ehada, Aaroninne iya nayti iya huuphiyan banta kushiya wothana mela ootha. ");
INSERT INTO gofl_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Wofaanuwa Geeshsha Dunkaaniya pengiyan Godaa sinthan shuka. ");
INSERT INTO gofl_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Wofaanuwa suuthaafe guuthu ekada ne biradhiyan, yarsho bessa bolla de7iya kaceta tiya. Attidaysa yarsho bessaafe garsan gussa. ");
INSERT INTO gofl_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Hessafe guye, ulo ashuwa kammida modhuwa ubbaa, tiriyaas lo77o baggaa, nam7u kilahotanne enta kammida modhuwa ekada, yarsho bessaa bolla wothada xuugga. ");
INSERT INTO gofl_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Shin wofaanuwa ulo ashuwa, iya galbaanne maraaciya gutaape gaxa kessada xuugga. Hessi kahineta nagaraa quchiya yarsho. ");
INSERT INTO gofl_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“Nam7u marazetape issuwa ekada, Aaroninne iya nayti banta kushiya iya huuphen wothana mela ootha. ");
INSERT INTO gofl_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","He maraziya shukada, suuthaa yarsho bessan oyddu maazanetan wurxa. ");
INSERT INTO gofl_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Iya ashuwa qanxerethada, ulo ashuwanne gedaa meeccada, huuphiya hara qommo ashotara issife yarsho bessan wotha. ");
INSERT INTO gofl_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Hessafe guye, kumetha ashuwa yarsho bessan xuugga. Hessika Godaas xuussa yarsho. He yarshuwa sawoy Godaa ufaysees. ");
INSERT INTO gofl_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“Qassi kahinetetha wogas eketida hanko maraziya ekada Aaroninne iya nayti banta kushiya iya huuphen wothana mela oda. ");
INSERT INTO gofl_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Iya shukada, suuthaafe guuthu ekada, Aaronasinne iya naytas ushacha haythatas gaxaa, enta ushacha kushiyasinne tohuwas wogga biradheta tiya. Attida suuthaa yarsho bessa oyddu maazanetan wurxa. ");
INSERT INTO gofl_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Yarsho bessan de7iya suuthaafenne tiyiya zaytiyape guuthu ekada, Aarona bollanne iya ma7uwa bolla, qassika iya nayta bollanne enta ma7uwa bolla wurxa. Hessan Aaroninne iya nayti banta ma7uwara taw dummatidaysata gidana. ");
INSERT INTO gofl_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“He marazey kahineta shuuma wogaas eketiya gisho, goyna modhuwa, ulo ashuwa kammida modhuwa, tiriya kammida moodhiya, nam7u kilahota, enta kammida moodhiyanne ushacha guye gedaa qanxada shaaka. ");
INSERT INTO gofl_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Godaa sinthan wothida uythatape, zaytey geliboonna uythaa, zaytera uukida uythaanne lee7o uythaafe issuwa eka. ");
INSERT INTO gofl_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Neeni ha katha ubbaa Aarona kushiyaninne iya nayta kushiyan wotha. Enti iya yuusho yarsho oothidi Godaas immiya yarsho oothidi Godaa sinthan shiisho. ");
INSERT INTO gofl_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Hessafe guye, enta kushepe ekada yarsho bessa bolla wotha; xuussa yarshuwara gathada, Godaa sawana mela yarsho bessa bolla taman xuugga. ");
INSERT INTO gofl_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Aaroni kahine gididi shuumetiya wode shukida maraziya angaasuwa ekada, Godaa sinthan yuusho yarsho ootha. Hessi hintena gakiya gisho gidana. ");
INSERT INTO gofl_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","“Kahiney shuumetiya wode, Aaronanne iya nayta kahinetethan shuumanaw eketida angaaysuwanne toho ashuwa taw dummaya. Hessika, kahineta gakiya gisho gido. ");
INSERT INTO gofl_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Isra7eeleti ubbay kahine shuumanaw woyko anjetanaw Godaas Angaasonne guye toho yarsho immiya wode ashoy taw dummatidaysa gido. Shin gishoy Aaronasinne iya naytas gako; he wogay laametofo. ");
INSERT INTO gofl_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“Aaroni hayqida wode iya nayti iya kahinetetha ma7uwa laatto. Enti kahinetethan shuumetidaape guye he ma7uwa ma7o. ");
INSERT INTO gofl_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Iya naytape iya bessan kahine gididi, Geeshsha bessan haggaazanaw Geeshsha Dunkaaniya yaa na7i he ma7uwa laapun gallas ma7o. ");
INSERT INTO gofl_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“Aaroninne iya nayti kahine gididi shuumetiya wode shuketida maraziya ashuwa ekada, geeshsha bessan katha. ");
INSERT INTO gofl_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Aaroninne iya nayti maraziya ashuwa gaytan attida uythaara Geeshsha Dunkaaniya pengen mo. ");
INSERT INTO gofl_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Enti kahine gididi shuumetiya wode nagara atotethas yarshetida he ashuwa mona. Shin he kathay geeshshi gidida gisho, kahineta xalaali mo; hara asi oonika moopo. ");
INSERT INTO gofl_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Ashuwapenne kathaafe mishin attidi aqiko, taman xuugeto; geeshshi gidida gisho meetetofo. ");
INSERT INTO gofl_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“Aaroninne iya nayti kahine gididi shuumetiya wode, ta nena kiitida ubbaa ootha; ba7aaley laapun gallasan poleto. ");
INSERT INTO gofl_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Nagaraa atotethas issi issi gallasan issi wofaano shukada yarsha. Hessi yarsho bessa geeshshees. Yaatada yarsho bessa polo geeshshanaw shamaho zayte tiya. ");
INSERT INTO gofl_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Hessa laapun gallas gakanaw gallas gallas ootha. Yaatiko yarsho bessay polo geeshshi gidana. I polo geeshshi gidida gisho, iya bochiya asi woyko haraba ubbay geeyana. ");
INSERT INTO gofl_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“Laythan laythan yarsho bessan gallas gallas issi laythi gidida nam7u marazeta yarsha. ");
INSERT INTO gofl_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Marazetape issuwa wonta, qassi hankuwa omarsi yarsha. ");
INSERT INTO gofl_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Koyro maraziyara issi kilo giraame gidiya geeshsha lo77o giste dhiille, issi litiro shamaho zaytera gindada yarsha. Issi litiro woyne ushsha yarsho oothada gussa. ");
INSERT INTO gofl_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Hanko maraziya omarsi yarshashe wonta yarshoysa mela dhiille, zaytenne woyne ushsha shiisha. Hessi taw yarshetiya katha yarsho; iya sawoy tana ufayseysa gidana. ");
INSERT INTO gofl_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","“Laythan laythan he xuussa yarshoy Geeshsha Dunkaaniya pengen, Godaa sinthan paci bayna yashetanaw bessees. He bessan taani ta deriyara gahetana; neeraka yan odetana. ");
INSERT INTO gofl_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Yan taani Isra7eeletara gahetana; ta bonchoy he bessa dummayana. ");
INSERT INTO gofl_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Taani Geeshsha Dunkaaniyanne yarsho bessa dummayana; enti taw kahine gididi haggaazana mela Aaronanne iya nayta dummayana. ");
INSERT INTO gofl_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Yaatada, taani Isra7eeleta giddon daana; enta Xoossaa gidana. ");
INSERT INTO gofl_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Enta giddon daanaw Gibxefe enta kessida Goday, enta Xoossay tana gideysa enti erana. Taani Godaa, enta Xoossaa. ");
INSERT INTO gofl_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“Ixaane cuyisiya bessaa soqala mithafe medha. ");
INSERT INTO gofl_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Iyaw oyddu maazaney de7o. Adussatethaynne gompay issi issi wadha, geesay nam7u wadha gido. Oyddu maazaniyan de7iya kaceti iyara oyketidi oosetonna. ");
INSERT INTO gofl_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Iyaw bolla baggaa, iya oyddu maazanetanne iya kaceta walahi bayna worqan lanxa. Iya yuushuwaka worqan lanxa. ");
INSERT INTO gofl_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Nam7u worqa sagaayota oothada, xarpheeza tookanaw maaddiya kaso mithata aathanaw goossaas nam7u baggara oytha. ");
INSERT INTO gofl_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Kaso mithata soqala mithafe kessada, enta worqan lanxa. ");
INSERT INTO gofl_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","He ixaane yarsho xarpheezaa, Caaqo Taabotiya sinthan kaqetida magarajuwafe kare baggara wotha. Yan taani neera gahetana. ");
INSERT INTO gofl_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“Aaroni wonta wonta xompeta giigisanaw yaa wode, sawiya ixaane yarshiya bessan cuyiso. ");
INSERT INTO gofl_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Hessada, Aaroni omarsi xompeta xompiya wodeka ixaane cuyiso. He ixaaniya yarshoy yaana laytha ubban Godaa sinthan cuyo. ");
INSERT INTO gofl_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Ha yarsho bessan hara digetida ixaane, katha yarsho, mehe yarshonne woyne yarsho yarshofa. ");
INSERT INTO gofl_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Aaroni, nagaraa atotethas laythafe issi toho shuketiya mehiya suuthaafe ekidi, he yarsho bessa maazaneta bolla de7iya kaceta wothidi geeshsho wogaa polo. Ha wogay sinthara yaana wode ubban laythan laythan poleto. He yarsho bessay geeshshi gidiya gisho Godaas dummatis” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Hessafe guye, Goday Museko haysada yaagis; ");
INSERT INTO gofl_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Neeni Isra7eele asaa taybiya wode, issi issi asi ba shempuwa wozanaw Godaas miishe qanxo. Yaatiko neeni enta taybiya wode gadoy enta bolla yeenna. ");
INSERT INTO gofl_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Taybon geliya asi oonika huuphen huuphen geeshsha dunkaanen eretida mizaane ginan bira ciggo. Issi issi asi hessa taw yarsho oothidi immo. ");
INSERT INTO gofl_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Taybon geliya asi oonika laythi laatamanne iyape bolla gidida ubbay Godaas hessa eho. ");
INSERT INTO gofl_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Enti banta shempuwa wozanaw Godaas imota immiya wode, dureyka manqoyka issi gina immofe attishin, durey darsidi woyko manqoy guuthidi immofo. ");
INSERT INTO gofl_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","He miishiya Isra7eele asaape ekada, Geeshsha Dunkaaniya naaganaw peeshsha. He miishey enta shempuwa wozanawunne ta enta naagana mela qofisiyaba gidana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Goday Museko haysada yaagis; ");
INSERT INTO gofl_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Meecha keriyanne iya tohuwa naase biratape medha. Iyan haathe tigada Geeshsha Dunkaaniyapenne yarsho bessaafe giddon wotha. ");
INSERT INTO gofl_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Aaroninne iya nayti banta kushiyanne banta tohuwa yan meeceto. ");
INSERT INTO gofl_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Enti Geeshsha Dunkaaniya gelanaapenne yarsho yarshanaape sinthe hessa oothanaw bessees. Hessa enti oothiko hayqope attoosona. ");
INSERT INTO gofl_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Enti hayqonna mela, banta kushiyanne banta tohuwa meecetanaw bessees. Hessi Aaronasinne iya sheeshatas, yaa yeletetha ubbaas merinaa woga gidana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Goday Museko haysada yaagis; ");
INSERT INTO gofl_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Geeshsha sawota, hessatika; usupun kilo giraame gukiya karbe, heedzu kilo giraame sawiya qarafa, heedzu kilo giraame sawiya maata, ");
INSERT INTO gofl_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","usupun kilo giraame burgude eka. He ubbayka geeshsha dunkaanen eretida mizaaniya gina gido. Hessata bolla oyddu litiro zayte guja. ");
INSERT INTO gofl_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Hessata shittoda walakada, sawiya geeshsha zayte oothada, ");
INSERT INTO gofl_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Geeshsha Dunkaaniyanne Caaqo Taabotiya tiya. ");
INSERT INTO gofl_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","Xarpheezanne iya miisheta, xompe wothiya kocaanne iya miisheta, ixaane cuyisiya xarpheezaa, ");
INSERT INTO gofl_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","xuussa yarsho bessinne iyan bolla de7iya miisheta ubba, meecha keriyanne iya tohuwa tiya. ");
INSERT INTO gofl_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Enti polo geeshshi gidana mela enta dummaya. Enta bochiya oonika geeshshi gidana. ");
INSERT INTO gofl_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“Hessafe guye, Aaroninne iya nayti kahine gididi taw haggaazana mela enta tiyada dummaya. ");
INSERT INTO gofl_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Isra7eele asaas, ‘Haysi Geeshsha shuumatetha zaytey yaa yeletethaas tana haggaazanaw maaddiya zayte gido. ");
INSERT INTO gofl_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","He zaytiya coo asa bolla gussofa; qassi ay zayteka iya oothida ogiyan oothofa. Zaytey geeshshi gidida gisho, hinteka iya geeshshatetha erite. ");
INSERT INTO gofl_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","He shittuwa giigisiya asi, woyko kahine gidonna hara asi tiyiya oonika ta asaa giddofe hileto’ yaaga” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Goday Museko haysada yaagis; “Geeshsha sawota, xokiya mitha made, dhaadhe keethan de7iya shitto, sawiya madenne sawiya ixaane eka; enta ubbaa mizaaney issi gina gido. ");
INSERT INTO gofl_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Shittoda walahetida ixaane oothada enta go7eta. Walahi baynanne geeshshi gidana mela iyan maxine yegga. ");
INSERT INTO gofl_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Iyape guuthara ekada liiqisa caddada, taani neera gahetiya Geeshsha Dunkaaniya giddon, Caaqo Taabotiya sinthan wurxa. He ixaaney new polo geeshshi gido. ");
INSERT INTO gofl_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Hintew go7etanaw he ixaaniya ay ogenka giigisopite. Hessi taw dummatidaysa gideysa erite. ");
INSERT INTO gofl_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Hessatho oothidi, iya sawuwa singidi ufaytanaw koyiya oonika, ta asaa giddofe dhayana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Goday Museko haysada yaagis; ");
INSERT INTO gofl_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Taani Yihuda sheeshape gidida Huura na7aa na7aa, Ure na7aa, Basili7eela dooras. ");
INSERT INTO gofl_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Taani iya ta Ayyaanan kunthas; taani hiilla, akeekanne ooso ubbaa oothiya era iyaw immas. ");
INSERT INTO gofl_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","Hessika, hiillan oothana oosota halchidi worqafe, birapenne naase biratape dumma dummaba kessidi oothanaasa. ");
INSERT INTO gofl_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","Hessadaka, al7o shuchu massidi giigiseysa, mithi masseysanne hara ooso ubbaa oothana mela cincatethi immas. ");
INSERT INTO gofl_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Qassi iya maaddana mela Daane sheeshi gidida Ahisamaaka na7aa Eliyaaba dooras. Taani nena kiittidaba ubbaa enti oothana mela kushe hiilla eriya harata ubbaas gita eratethi immas. ");
INSERT INTO gofl_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Enti oothanabati, Geeshsha Dunkaaniya, Caaqo Taabotiya, iya bolla wothiya nagara atotetha kamaa, Dunkaaniya giddon go7etiya miishe ubbaa, ");
INSERT INTO gofl_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","xarpheezanne iya miisheta, walahi bayna worqafe oosetida xompe wothiya kocaanne iya miishe ubbaa, ixaane cuyisiya xarpheezaa, ");
INSERT INTO gofl_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","xuussa yarsho bessinne iya miishe ubbaa, meecha keriyanne iya tohuwa, ");
INSERT INTO gofl_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","Aaroninne iya nayti kahinetethan haggaazishe ma7iya kahinetetha ma7uwa, ");
INSERT INTO gofl_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","shuumatetha zaytiyanne Geeshsha Bessaas haniya sawiya ixaaniya, taani nena kiitidaysada enti oothana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Goday Muse haysada yaagidi kiittis; ");
INSERT INTO gofl_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Isra7eele asaa, ‘Ta Sambaata naagite. Hessi taani, Goday, hintena taw geeshsha dere oothada dooridaysa bessiya malla gididi, yaana yeletetha ubbaas taapenne hintefe giddon de7o. ");
INSERT INTO gofl_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","He gallasay geeshshi gidiya gisho, iya bonchite. Sambaata bonchonaynne he gallasan ooso oothiya oonika ta asaa giddofe dhayo woyko hayqo. ");
INSERT INTO gofl_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Hinte ooso oothanaw bessiya usupun gallasati de7oosona. Shin laapuntha gallasay Godaas dummatida, shempo gallas. Sambaata gallasan ooso oothiya oonika hayqo. ");
INSERT INTO gofl_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Isra7eele yeletetha ubbay ha Sambaata gallasaa merina caaqo malla oothidi boncho. ");
INSERT INTO gofl_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Taani usupun gallasan saluwanne sa7aa medhida gishonne laapuntha gallasan ooso aggada shempida gisho, ta giddoninne Isra7eeleta giddon hessi merinaw eqidi de7iya malla gidana’ yaaga” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Goday Muse Siina zuma bolla odiseysa ongida wode, I ba biradhen xaafida tammu kiitata oykida nam7u loche shuchata Muses immis. ");
INSERT INTO gofl_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Asay, Musey zumaa bollafe wodhanaw gam7idaysa be7ida wode Aaronako yidi, “Nuna kaalethishe naagana xoossata nuus ootha. Gibxe biittafe nuna kessida Musey waanidaako eroko” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Aaroni entako, “Hinte macheta, hinte adde naytanne hinte macca nayta haythan de7iya worqaa kessidi, taw haa ekidi yiite” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Asi ubbay banta haythafe worqaa kessidi, Aaronas ehidosona. ");
INSERT INTO gofl_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","I hessa entafe ekidi, taman sheeshidaape guye, qoxidi, worqa mara misile oothidi medhis. Enti, “Isra7eeleto, nuna Gibxe biittafe kaalethidi kessida nu xoossati haysata” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Aaroni hessa be7ida wode, he maraa sinthan yarsho besse giigisidi, “Wonto Godaa bonchiya ba7aale gallas gidana” yaagidi erisis. ");
INSERT INTO gofl_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Wontetha gallas guura asay dendidi, xuussa yarshonne issifetetha yarsho yarshidosona. Yaatidi, asay maanawunne uyanaw uttidosona. Mi uyi simmidi, duranawunne pokoba hananaw dendidosona. ");
INSERT INTO gofl_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Goday Museko, “Neeni Gibxefe kessada, ehida ne asay nagara oothidi, bantana tunisida gisho ellesada duge wodha. ");
INSERT INTO gofl_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Taani enta kiitida ogiyape enti ellesidi shiretidosona. Worqa sheeshidi mara misile oothidi, bantaw eeqa medhidi iya goyinnidosona. Iyaw yarshidi, ‘Nuna Gibxe biittafe kessida nu xoossay haysa’ yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Goday Museko, ha asay ay mela wozana muumeko ta be7as. ");
INSERT INTO gofl_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Ha77i ta hanqoy enta bolla eexin, taani enta dhaysanaw giigetida gisho, neeni tana diggofa. Yaatada, taani nena gita dere oothana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Shin Musey ba Godaa, Xoossaa haysada yaagidi woossis; “Abeeti Godaw, neeni ne gita wolqaaninne ne mino kushiyan Gibxefe kessada ehida ne asaa bolla ne hanqoy ayis eexii? ");
INSERT INTO gofl_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Ne hessa oothiyaba gidiko, Gibxeti, ‘Goday entana dereta bolla wodhanawunne biittafe pittidi dhaysanaw kessis’ ayis gaanee? Ne yashshiya hanquwafe simma. Ne asaa dhaysanaw qopidaysa agga. ");
INSERT INTO gofl_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Ne aylleta Abrahaame, Yisaaqanne Yayqooba hassaya. Neeni entaw, ‘Taani hinte sheesha salo xoolintoda darsana; taani hintew immana gida ha biitta ubbaa hinte sheeshatas immana; enti he biitta merinaw laattana’ gada ne huuphen ne caaqida caaquwa qopa” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Hessa gisho, Goday ba deriya bolla iitabaa ehanaw qopidaysa aggidi, enta maaris. ");
INSERT INTO gofl_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Musey nam7u baggara xaafetida, tammu kiitati de7iya nam7u loche shuchata ba kushen oykidi, zumaape duge wodhis. ");
INSERT INTO gofl_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","He masetida shuchata giigisiday Xoossaa; shuchata bolla woocidi xaafidayka Xoossaa. ");
INSERT INTO gofl_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Iyyasuy asaa kooshincha si7ida wode, Museko, “Asay siiratida bessan ola waasoy si7etees” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Musey zaaridi, “Haysi xoonida asa ceeqo woyko xoonetida asa yeeho gidonashin, yetha waaso” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Musey gutaako matida wode maranne dursaa be7idi daro hanqetis. He wode ba kushen oykidi yida, masetida shuchata zumaa xaphon holidi mentherethis. ");
INSERT INTO gofl_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Enti medhida maraa ekidi, taman xuuggis. Hessafe guye, liiqana gakanaw gaaccidi haathara maadhidi, Isra7eele asay uyanaada oothis. ");
INSERT INTO gofl_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Musey Aaronako, “Ha asay new ay oothin, enta haysa mela iita nagara banta bolla oothana mela oothadii?” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Aaroni zaaridi, “Ta godaw, tana hanqetofa. Ha asay iitaba oothanaw ay mela koyaako ne eraasa. ");
INSERT INTO gofl_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Enti, ‘Nuna Gibxefe kessidi ehida, Musey waanidaako nu eroko. Hessa gisho, kaalethiya xoossata nuus ootha’ yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Taani entako, ‘Hinte haythan de7iya worqaa kessidi, hammite’ yaagas. Enti taw immida worqaa taani taman yeggin, ha mara misiley keyis” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Aaroni asaa coo yeddi aggin, asay ba morketa sinthan kawuyidi, kadhetidaysa Musey be7is. ");
INSERT INTO gofl_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Hessa gisho, Musey gutaa geliya pengiyan eqidi, “Godaa bagga gidiya asi oonika taako yo” yaagis. He wode Leeweti ubbay iyako shiiqidosona. ");
INSERT INTO gofl_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","I, entako, “Goday, Isra7eele Xoossay, hinte issoy issoy hinte mashshaa shoddidi, gutaas ha pengefe hini penge gakanaw bidi, hinte ishata, hinte laggetanne hinte shoorota wodhite” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Leeweti Musey kiitidaysada oothidi, he gallas heedzu mukulu gidiya asaa wodhidosona. ");
INSERT INTO gofl_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Musey Leewetako, “Hachi hinte, hinte naytanne hinte ishata wodhanaw kiitetidi hintena Godaas dummayideta. Goday hintena anjis” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Wontetha gallas Musey asaako, “Hinte iita nagara oothideta; shin ha77i taani Godaako zuma bolla keyada, ooni eri hinte nagaras atotethi demmonna aggike” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Yaatin Musey Godaako simmidi bidi, “Ha asay iita nagaraa oothidosona; enti bantaw worqafe xoosse medhidosona. ");
INSERT INTO gofl_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Shin hayyana, ha77i enta nagaraa atto yaaga. Hessi hanonnaba giiko, ne asaa ne xaafida mazgabiyape ta sunthaa qucha” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Goday zaaridi Museko, “Taani ta mazgabiyape quchana asaa sunthay, ta bolla nagara oothidaysata sunthaa. ");
INSERT INTO gofl_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Ha77i bada, ha asaa taani new odida bessaa kaaletha. Ta kiitanchoyka nena kaalethanaysa akeeka, shin taani ha asaa enta nagara gisho seerana wodey yaanaysi attenna” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Aaroni worqafe mara misiliya medhanaada oothiday asaa gidiya gisho, Goday asaa bolla wolqaama gado yeddis. ");
INSERT INTO gofl_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Hessafe guye, Goday Museko, “Neeninne ne Gibxefe kessida asay ha bessaafe dendidi, taani Abrahaames, Yisaaqas, Yayqoobasinne enta sheeshatas immana yaagada caaqida biitta biite. ");
INSERT INTO gofl_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Taani hinte sinthan kiitanchuwa kiittana. Kanaaneta, Amooreta, Hiteta, Parzeta, Hiwetanne Yaabuseta taani gooddada kessana. ");
INSERT INTO gofl_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Maathinne eessi goggiya he biitta biite. Shin hinte, wozani muumida asi gidiya gisho ta hintena ogen dhaysona mela hintera biike” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Asay he yashshiya odaa si7idi yeekidosona. He wodepe doomidi ubbay banta alleequwa aathibokona. ");
INSERT INTO gofl_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Goday Museko, Isra7eele asaas haysada yaagada oda yaagis; “Hinte wozana muume asi. Taani hintera hari attoshin guutha wodeska biiko, hinte taape dhayana. Ha77i hinte, hinte alleeqota kessite; taani hinte bolla oothanaba bessaana yaaga” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","He wode Isra7eeleti Koreeba zumaa aggidi bidaape guye, banta alleeqota aathibokona. ");
INSERT INTO gofl_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Isra7eele asay bishe siiratiya guta ubban Musey dunkaaniya gutaape haassidi tokees. He dunkaaney, “Godaara gahetiya Dunkaane” geetetidi xeegetis. Godaa oychanaw koyiya ubbay yaa bees. ");
INSERT INTO gofl_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Musey dunkaaniyako biya wode asa ubbay ba dunkaaniya pengen pengen eqidi, Musey yaa gelana gakanaw iya be7oosona. ");
INSERT INTO gofl_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Musey yaa gelidaape guye, shaara tuussay wodhidi Dunkaaniya pengen eqees. Goday shaara giddon gididi Musera odetees. ");
INSERT INTO gofl_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Asay shaara tuussa Dunkaaniya pengiyan be7ida wode ubban, ba pengen pengen gulbatidi Godaas goyinnoosona. ");
INSERT INTO gofl_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Asi ba laggera odeteysada Goday Musera som7on odetees. Hessafe guye, Musey gutaa simmees. Shin iya maaddiya na7atethay, Nawe na7aa Iyyasuy, Godaara gahetiya Dunkaaniyape shaaketenna. ");
INSERT INTO gofl_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Musey Godaako, “Neeni tana, ha asaa ta gida biitta kaaletha yaagadasa. Shin taara baana mela neeni kiittey ooneko, tana erisabaaka. Neeni, tana ereysanne tanan ufayteysa taw qoncisadasa. ");
INSERT INTO gofl_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Hessi tuma gidiko, ta nena haggaazana melanne guja ufaysana mela ne ogiya tana tamaarsa. Ha asay ne dere gideysa be7a” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Goday zaaridi, “Taani, neera baana melanne new saro immana mela koyay?” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Musey zaaridi, “Neeni nuura boonnaba gidiko, haysafe nuna kessofa. ");
INSERT INTO gofl_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Neeni nuura boonnaba gidiko, tananinne ne asan ne ufaytidaysa asa ubbay waatidi eranee? Biitta ubban de7iya hara asa ubbaafe taaninne ne asay dummatey ne nuura de7eysan gidenneyee?” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Goday Museko, “Taani nena eriya gishonne nenan ufaytida gisho, ne tana oychidaysa ubbaa oothana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Musey Godaako, “Hayyana ne kumetha bonchuwa tana bessa?” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Goday zaaridi, “Taani ta maarotanne ta lo77otetha ubbaa ne sinthara aathana. Ta geeshsha sunthaa ne matan awaajana. Taani Godaa; ta dooridaysata maarananne entaw qadhetana. ");
INSERT INTO gofl_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Shin oonika ta som7uwa be7idi paxa doonna gisho, neeni ta som7uwa be7aka” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Shin, “Neeni zaalla bolla eqanaw haysan ta matan bessi de7ees. ");
INSERT INTO gofl_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Ta bonchoy aadhiya wode taani za77ida zaalla giddon nena wothana. Ta aadhana gakanaw ta kushiyan nena kammana. ");
INSERT INTO gofl_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Hessafe guye, taani ta kushiya denthana; neeni ta zokuwa be7ana, shin ta som7uwa be7aka” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Goday Museko, “Koyroyisata daaniya nam7u loche shuchata massada giigisa. Taani he shuchata bolla kase neeni menthida shuchata bolla de7iya qaalata xaafana. ");
INSERT INTO gofl_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Wonto wonta guura taara gahetanaw Siina Zumaa huuphiya keya. ");
INSERT INTO gofl_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Neera oonika keyopo woyko zumaa bolla awunka bentofo. Hari attoshin dorsa woyko mehe wudey zumaa xaphon heemetofo woyko moopo” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Hessa gisho, Musey koyro shuchata daaniya nam7u shuchata massidi, Goday kiitidaysada, shuchata oykidi wonta guura Siina zuma bola keyis. ");
INSERT INTO gofl_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Goday shaarara wodhidi, iyara yan eqidi, “Taani Godaa” yaagidi ba geeshsha sunthaa awaajis. ");
INSERT INTO gofl_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Goday Muse sinthara aadhishe haysada yaagidi awaajis; “Taani Xoossaa, ta sunthay Godaa. Taani, qadheynne maarotay kumida Xoossaa. Taani danda7aninne merina siiqon kumidaysanne daro ammantheysa. ");
INSERT INTO gofl_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Taani, ta asaas geliya qaala mukulu yeletethi gakanaw naageysanne iitatethaa, makallanne nagaraa atto geysa. Shin heedzanthonne oyddantho yeletethi gakanaw aawata nagara gisho nayta seeronna aggike” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Musey ellesidi biittan gufannidi goyinnis. ");
INSERT INTO gofl_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","I zaaridi, “Abeeti Godaw, neeni tanan ufaytiyaba gidiko, nuura issife yedha. Haysi asay si7onna asi; nu iitatethaanne nu nagaraa atto yaagada, nuna ne ase ootha” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Goday Museko, “Taani Isra7eele asaara caaqana. Haysafe kase biitta bolla awunka hani eronna malaalsiyaba ne asaa sinthan oothana. Taani Goday, ay mela malaalsiyaba oothiyako, neeni enta giddon de7iya asay be7ana. ");
INSERT INTO gofl_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Hachi taani hintena kiittiya kiita naagite. Hinte sinthafe Amooreta, Kanaaneta, Hiteta, Parzeta, Hiwetanne Yaabuseta taani gooddana. ");
INSERT INTO gofl_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Enti hintew xihe gidonna mela hinte geliya biittan de7iya asaara caaqofite. ");
INSERT INTO gofl_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Enta yarsho bessata laallite; goyinno tuussata mentherethite. Asheera geetetiya macca xoosse misile tuussata qanxerethite. ");
INSERT INTO gofl_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Taani Goday, ta bonchuwa hara xoossatara koxonna Xoosse gidiya gisho, taape hara xoossatas goyinnofite. ");
INSERT INTO gofl_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","He biittan de7iya asatara ayba caaqoka caaqofite. Enti banta xoossata goyinniya wodenne entaw yarshiya wode, enti hintena bantara issifana mela oychiko, hinte enti banta xoossatas yarshiya kathaa maanaw paacetidi, taw ammanetona ixana. ");
INSERT INTO gofl_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Qassi hinte enta macca naytape hinte adde naytas immiko, he wode he macca nayti banta xoossata goyinnidi, hinte adde naytika taw ammanetona ixidi, banta xoossata goyinnana mela oothana. ");
INSERT INTO gofl_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“Biratape qoxetidi, medhetida xoossata goyinnofite. ");
INSERT INTO gofl_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Uythaa Ba7aale bonchite. Hinte Gibxefe keyday, Abiiba ageenan gidiya gisho, taani hintena kiitidaysada, he ageenan, laapun gallas gakanaw uythi miite. ");
INSERT INTO gofl_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“Bayra yeletiya adde na7i ubbaynne bayra yeletiya mehe adde ubbay tabaa. ");
INSERT INTO gofl_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Koyro yeletida hare mari dorsa marara laammada woza. Wozonna ixiko, iya morgiya mentha. Bayra yeletida adde na7a ubbaa woza. “Oonika immiyaba oykonna mela kushe ta sinthan shiiqopo. ");
INSERT INTO gofl_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“Usupun gallas oothite, shin laapuntha gallasan shempite. Zeriya wode gidin woyko kathaa cakiya wode laapuntha gallasan shempite. ");
INSERT INTO gofl_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“Koyro hinte gistiya cako doomiya wode, Katha Shiisho Ba7aale bonchite. Qassi laytha wursetha kathaa shiishiya wode, Shaqara Ba7aale bonchite. ");
INSERT INTO gofl_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Laythan heedzu toho Isra7eele adde ubbay medhetetha Godaa, Isra7eele Xoossaa goyinnanaw yo. ");
INSERT INTO gofl_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Kawotethata taani hinte sinthafe yedetha kessada hinte zawa aassana. Hinte tana goyinnanaw laythan heedzu toho yaa wode, oonika hinte biitta olidi ekanaw amottenna. ");
INSERT INTO gofl_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“Hinte taw mehe yarshiya wode, irsho yeggidi uukida uythara shishopitte. Paasika bonchiya gallasas yarshida yarshuwafe wontas aybaka ashshofite. ");
INSERT INTO gofl_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“Hinte gaden bayra kaxida kathaafe koyro ayfiya Godaa hinte Xoossaa keethi ehite. “Deesha mari iya aaye maathan doysopite” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Goday Museko, “Taani neeranne Isra7eele asaara caaqo geley ha qaalatan gidiya gisho, ha qaalata xaafa” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Musey moonnanne uyonna, oytamu gallasinne oytamu qamma Godaara zuma bolla gam7is. I, caaqo qaala gelida tammu kiitata loche shuchatan xaafis. ");
INSERT INTO gofl_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Musey Godaara odetishe gam7idi, tammu kiitata oykida nam7u loche shuchata ekidi Siina Zumaape wodhiya wode iya som7oy phoolees, shin I hessa eribeenna. ");
INSERT INTO gofl_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Aaroninne Isra7eele asa ubbay Muse xeellidi, iya som7oy phooleysa be7idi, iyako shiiqanaw yayyidosona. ");
INSERT INTO gofl_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Shin Musey enta xeegis. Aaroninne Isra7eele halaqati ubbay iyako shiiqin, I enta odisis. ");
INSERT INTO gofl_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Hessafe guye, Isra7eele asa ubbay iyako shiiqin, Goday iyaw Siina zuma bola immida kiita ubbaa I entaw immis. ");
INSERT INTO gofl_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Musey entara odeteysa wursida wode ba som7uwa laxanan kammis. ");
INSERT INTO gofl_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Shin Musey Godaa sinthe, iyara odetanaw geliya wode laxana ba som7uwafe qaarees. Yaape keyiya wode, Goday iya kiittidaba ubbaa Isra7eele asaas odees. ");
INSERT INTO gofl_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","He ubban enti iya som7oy phooleysa be7oosona. Hessa gisho, Musey Godaara odetanaw baana gakanaw, ba som7uwa laxanan kammees. ");
INSERT INTO gofl_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Musey Isra7eele asaa ubbaa xeegidi, “Hinte oothana mela Goday kiittidabay haysa; ");
INSERT INTO gofl_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Saaminta giddon usupun gallasa xalaalan ooso oothite; shin laapuntha gallasay hintew geeshsha gallas; Godaaska dummatida shempo Sambaata. He gallasan ooso oothiya oonika hayqanaw bessees. ");
INSERT INTO gofl_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Sambaata gallas hinte son tama eethofite” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Musey Isra7eele asaako, “Goday haysada yaagidi hintena kiittis; ");
INSERT INTO gofl_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Godaas hinte wozanay immo giyaba immanaw ehite. Hinte immanaw ehiyabati worqaa, bira, naase birata, ");
INSERT INTO gofl_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","kaalose qacina, ocha teera daaniya qacina, zo7o qacinanne al7o liino, deesha ikise, ");
INSERT INTO gofl_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","zo7o qalamen yeggi kessida dorsa ite, lo77o do7a ite, soqala mithi, ");
INSERT INTO gofl_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","xompes shamaho zayte, shuumatetha zayte, iyan yegetiya sawuwanne ixaane sawo, ");
INSERT INTO gofl_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","efuudiyasinne tiran ma7etiya ma7uwas haniya margide geetetiya shuchaanne hara alleeqota eho. ");
INSERT INTO gofl_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“Hinte giddon de7iya kushe hiillancho ubbay yidi, Goday kiitidaysa ubbaa ootho. ");
INSERT INTO gofl_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Geeshsha Dunkaaniya, iya gaatha kamaanne kare kamaa, kaqota, tuuqeta, liyoota, tuussatanne enti eqiya tohota; ");
INSERT INTO gofl_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","Taabotiyanne iya tookiya kaso mithata, nagara atotetha kamaanne Taabotiya genthiya magarajuwa; ");
INSERT INTO gofl_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","xarpheezaa, iya tookiya kaso mithatanne, iya miisheta ubbaanne Godaa sinthan wothiya geeshsha uythaa; ");
INSERT INTO gofl_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","xompe wothiya kocaa, iya miisheta, xompiyanne xompe zaytiya; ");
INSERT INTO gofl_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","ixaane cuyisiya xarpheezanne iya tookiya kasota, shuumatetha zaytiyanne sawiya ixaane, Geeshsha Dunkaaniya penge magarajuwa; ");
INSERT INTO gofl_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","xuussa yarsho bessinne iya naase birata zarzariya, iya tookiya kasotanne iya miisheta ubbaa, naase biratape oosetida meecha keriyanne iya tohuwa; ");
INSERT INTO gofl_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","dabaaba godaa gesheta, tuussatanne enta tohota, dabaaba penge magarajuwa, ");
INSERT INTO gofl_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","Geeshsha Dunkaaniyanne dabaaba dunkaaniya tole dhishetanne enta wodorota; ");
INSERT INTO gofl_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","Aaroninne iya nayti Geeshsha bessan haggaazishe ma7anaw alleeqetidi oosetida boncho ma7ota ootho” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Hessafe guye, Isra7eele asa ubbay Muse sinthafe keyidosona. ");
INSERT INTO gofl_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Asa ubbay ba wozanan immo immo gidaba Geeshsha Dunkaaniyas, iya giddon oosetiya ooso ubbaasinne boncho kahine ma7otas koshshiyaba ubbaa ehidosona. ");
INSERT INTO gofl_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Immanaw koyida macci adde ubbay worqa alleeqota, siidhe worqata, migidota, qoodhe worqa ehidi, Godaas imo oothidi immidosona. ");
INSERT INTO gofl_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Kaalose qacina, ocha teera daaniya qacina, zo7o qacina, al7o liino, woyko deesha ikise, woyko zo7o qalamen yeggi kessida dorsa ite woyko, lo77o do7a itey de7iya asi ubbay ehis. ");
INSERT INTO gofl_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Bira woyko naase birata immanaw danda7iya ubbay banta imota Godaas immidosona. Qassi soqala mithi de7iya asi ubbay dumma dumma oosuwas ehis. ");
INSERT INTO gofl_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Kushe hiilla maccasa ubbay banta kushen suqida kaalose qacina, ocha teera daaniya qacina, zo7o qacinanne al7o liino ehidosona. ");
INSERT INTO gofl_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Qassika imota immanaw koyida maccasa ubbay deesha itepe dooqetida wodoro ehidosona. ");
INSERT INTO gofl_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Halaqati efuudiyasinne tiran ma7etiya ma7uwas haniya margidenne hara lo77o shuchata, ");
INSERT INTO gofl_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","qassika enti ixaanen, shuumatethasinne xompes maaddiya shamaho zayten yegetiya sawo ehidosona. ");
INSERT INTO gofl_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Isra7eele asa ubbay, oothana mela Goday Muse baggara kiitida oosuwas haniya imotata ubbaa banta dosan Godaas ehidosona. ");
INSERT INTO gofl_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Musey Isra7eele asaako haysada yaagis; “Goday Yihuda sheeshape gidida Huura na7aa na7aa, Ure na7aa, Basili7eela dooris. ");
INSERT INTO gofl_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Goday iya ba Ayyaanan, hiillan, akeekaninne ooso ubbaa oothiya eran kunthis. ");
INSERT INTO gofl_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","Hessika, hiillan oothana oosota halchidi worqafe, birapenne naase biratape dumma dummaba kessidi oothanaasa. ");
INSERT INTO gofl_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","Hessadaka, al7o shuchu massidi giigiso, mithi masethinne hara ooso ubbaa oothana mela cincatethi immis. ");
INSERT INTO gofl_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Qassi iyasinne Daane sheeshi gidida Ahisamaaka na7aa Eliyaabas, banta hiilla harata tamaarsana mela eratethi immis ");
INSERT INTO gofl_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Enti dumma dumma ooso oothana mela ooso halcho kessana mela, kaalosen, ocha teera daaneysaninne zo7o suufe qacinan al7o liino alleeqisidi, daddiya hiillatethi immis. Goday enta, eratethan kunthis. Enti ubbay dumma dumma ooson luxida hiillancho gididosona. ");
INSERT INTO gofl_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“Hessa gisho, Basili7eeli, Eliyaabinne Geeshsha Dunkaaniya keexana mela Goday hiillanne eratethi immida asa ubbay, Goday kiitidaysada ubbaba oothana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Musey Basili7eela, Eliyaaba, Goday dumma eratethi immidaysatanne ooso oothanaw koyiya ubbaa xeegidi, oosuwa doomana mela kiittis. ");
INSERT INTO gofl_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Enti, Isra7eele asay Geeshsha Dunkaaniya oothanaw ehida imo ubbaa Muse kushepe ekidosona. Qassi asay ba dosan immiya imota wonta wonta ehuwa aggibokona. ");
INSERT INTO gofl_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Yaatin, Geeshsha Dunkaaniya oothiya hiillanchoti banta oosuwa essidi, museko bidi, ");
INSERT INTO gofl_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","“Asay, Goday kiitida oosuwas koshsheysafe aathidi eho bolla de7oosona” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Musey, “Geeshsha Dunkaaniya keexanaw oonika immiyaba ehopo” yaagidi kiittin, asay eheysa aggaagidosona. ");
INSERT INTO gofl_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Enti ehida imotay ooso ubbaa oothi polanaw gididi palahees. ");
INSERT INTO gofl_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Oosuwa ootheysatape hiillan aadheysati Geeshsha Dunkaaniya oothidosona. Enti iya al7o liinope, kaalosen ocha teera daaneysaninne zo7o qacinan alleeqisidi daddida tammu gesheta giigisidi, iya bolla kiruubeta misiliya sikidosona. ");
INSERT INTO gofl_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Magarajoti ubbay issi gina gididi, adussatethay laatamanne oyddu wadha, gompay oyddu wadha. ");
INSERT INTO gofl_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Ichashu gesheta issife gathidi sikidosona; qassi hanko attida ichashu geshetaka hessada oothidosona. ");
INSERT INTO gofl_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Issife gathidi sikida geshetape issi magarajuwas wursetha gaxan kaalose afilape oosetida sagaayota medhidosona. Qassi issife gathidi sikida hanko geshetape issuwa gaxanka hessada oothidosona. ");
INSERT INTO gofl_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Enti issife siketida koyro magarajuwa bolla koyro maaran kaalose afilape oosetida ishatamu sagaayota, hessadaka nam7antho magarajuwa bolla wursetha maaran, hanko sagaayota ginan, ishatamu sagaayota oothidosona. ");
INSERT INTO gofl_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Enti nam7u baggan de7iya gesheta gasethidi issino oothanaw worqafe ishatamu oykiya bessata medhidosona. ");
INSERT INTO gofl_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Geeshsha Dunkaaniya bollara kammanaw tammanne issi gesheta deesha ikisepe daddidosona. ");
INSERT INTO gofl_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Tammanne issi gesheta adussatethaa laatamanne usupun wadha, gompaa oyddu wadha oothidi medhidosona. ");
INSERT INTO gofl_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Ichashu gesheta issi baggara, qassi usupun gesheta hanko baggara gathidi sikidosona. ");
INSERT INTO gofl_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Woli gathidi sikida geshetape wursetha magarajuwa macaran ishatamu sagaayota, qassi woli gathidi sikida hanko geshetape wursetha magarajuwa macaran ishatamu sagaayota medhidosona. ");
INSERT INTO gofl_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Nam7u baggara de7iya gesheta gasethidi issi kama oothanaw naase biratape ishatamu oykiya bessata medhidosona. ");
INSERT INTO gofl_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Dunkaaniya kammanaw zo7o qalamen yeggi kessida dorsa ite, qassi iya bollara kammanaw lo77o do7a ite giigisidosona. ");
INSERT INTO gofl_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Geeshsha Dunkaaniya tuuqeta soqala mithafe kessidosona. ");
INSERT INTO gofl_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Issi issi tuuqiya adussatethay tammu wadha, gompay issi wadhanne takadho. ");
INSERT INTO gofl_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Issi tuuqiya issuwara gasethanaw nam7u luhoti de7oosona. Geeshsha Dunkaaniya tuuqeta ubbaa hessada oothidosona. ");
INSERT INTO gofl_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Geeshsha Dunkaaniyas dugeha baggara laatamu tuuqeta medhidosona. ");
INSERT INTO gofl_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Issi issi tuuqetas nam7u toho medhidi, he tohota oythanaw oytamu luhota biratape giigisidosona. ");
INSERT INTO gofl_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Geeshsha Dunkaaniyas pudeha baggara laatamu tuuqeta medhidosona. ");
INSERT INTO gofl_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","Issi issi tuuqetas nam7u toho medhidi, he tohota oythanaw oytamu luhota biratape giigisidosona. ");
INSERT INTO gofl_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Geeshsha Dunkaaniyas guye baggan, wuloha baggara usupun tuuqeta medhidosona. ");
INSERT INTO gofl_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Geeshsha Dunkaaniya guye baggan de7iya maazanetas nam7u tuuqeta giigisidosona. ");
INSERT INTO gofl_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","He nam7u maazane tuuqeti xaphope xeera gakanaw oyketi bidosona. Nam7u maazaniyan de7iya nam7u tuuqeti hessada hanidi oosetidosona. ");
INSERT INTO gofl_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Hessa gisho, issi issi tuuqiyas garsan nam7u nam7u tohoti de7oosona. Hospun tuuqetas biratape oosetida tammanne usupun tohoti de7oosona. ");
INSERT INTO gofl_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Qassi enti soqala mithafe tammanne ichashu liyoota kessidosona. Ichashu liyooti Geeshsha Dunkaaniya issi bagga miyen, ");
INSERT INTO gofl_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","qassi ichashu liyoota hanko bagga miyen, hessadaka ichashu liyoota guye baggara wuloha baggan wothidosona. ");
INSERT INTO gofl_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Tuuqetas miye baggara giddon de7iya liyoy, ha gaxape ya gaxa gakanaw kanthi keyana mela oothidosona. ");
INSERT INTO gofl_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Tuuqetanne liyoota worqan lanxidosona. Liyooti enta giddora kanthi aadhana mela worqa sagaayota tuuqetara oysethidosona. ");
INSERT INTO gofl_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Magarajuwa al7o liinope kaalosen, ocha teera daaneysaninne, zo7o qacinan alleeqisidi oothidosona. He magarajuwa bolla kiruube misileta sikidosona. ");
INSERT INTO gofl_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Magarajuwa kaqanaw oyddu tuussata soqala mithafe giigisidi, worqan lanxidosona. Yaatidi worqa sagaayota entas giigisidosona. Qassi tuussata essiya oyddu tohota bira biratape medhidosona. ");
INSERT INTO gofl_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Geeshsha Dunkaaniya pengiyas al7o liinope kaalosen, ocha teera daaneysafenne zo7o qacinan alleeqisid magarajo giigisidosona. ");
INSERT INTO gofl_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Qassi iyaw kocati de7iya ichashu tuussata medhidi, entaw xeeranne tohuwa worqan lanxidosona. Tuussatas naase biratappe oosetidi ichashu tohota giigisidosona. ");
INSERT INTO gofl_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Basili7eeli Taabotiya soqala mithafe giigisis. Taabotiya adussatethay nam7u wadhanne bagga, gompaynne geesay issi wadhanne bagga. ");
INSERT INTO gofl_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Taabotiya giigisidi, gaathaanne kariya walahi bayna worqan lanxis. Iya yuushuwa bollaka worqan lanxis. ");
INSERT INTO gofl_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Oyddu worqa sagaayota Taabotiyas oyddu gedata bolla, issi baggara nam7u sagaayota, qassi hanko baggara nam7u sagaayota aathis. ");
INSERT INTO gofl_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Yaatidi soqala mithafe oosetida kasota kessidi enta worqan lanxis. ");
INSERT INTO gofl_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Taabotiya tookanaw, Taabotiyas miyiyan de7iya sagaayotan kasota aathis. ");
INSERT INTO gofl_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Walahi bayna worqafe, adussatethay nam7u wadhanne bagga, gompay issi wadhanne bagga gidida nagara atotetha kamaa oothis. ");
INSERT INTO gofl_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Qefey de7iya nam7u kiruubeta qoxetida worqafe oothidi, ");
INSERT INTO gofl_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","issi kiruubiya issi baggan, hanko kiruubiya hanko baggan wothidi, atotetha kamuwara issino oothidi medhis. ");
INSERT INTO gofl_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Kiruubeti banta qefiya miccidi, atotetha kamuwa kammidi, issoy issuwa xeelloosona. ");
INSERT INTO gofl_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Adussatethay nam7u wadha, gompay issi wadha, geesay issi wadhanne bagga gidida xarpheezaa soqala mithafe medhis. ");
INSERT INTO gofl_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Walahi bayna worqan iya lanxidi, yuushuwaka worqan lanxis. ");
INSERT INTO gofl_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Hessadaka, gompay takadho gidiya goosse oothidi, iya worqan yuushshi aathidi lanxis. ");
INSERT INTO gofl_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Taabotiya tookanaw maaddiya oyddu worqa sagaayota medhidi, oyddu gedata oyddu maazaneta bolla wothis. ");
INSERT INTO gofl_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Xarpheeza tookanaw kasota aathiya sagaayoti xarpheezaa goossa matan oosetidosona. ");
INSERT INTO gofl_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Xarpheezaa tookiya kaso mithata soqala mithafe kessidi, worqan lanxis. ");
INSERT INTO gofl_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Hessadaka, xarpheezaa bolla wothiya dumma dumma miisheta walahi bayna worqafe medhis. Hessatika saaneta, cilpata, kereta, woyne yarshsho tigiya xuu7ata. ");
INSERT INTO gofl_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Hessafe guye, Basili7eeli xompe wothiya kocaa walahi bayna worqafe oothis. Kocaa essiya tohuwanne tooma qoxetida worqafe giigisis. Alleeqos oosetiya, iya gambuthata, iya wallaxatanne iya ciishshata ubbaa iyara issife oythidi medhis. ");
INSERT INTO gofl_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Issi baggara heedzu tasheti, qassi hanko baggara heedzu tasheti de7iya usupun tasheta iya miyiyan medhis. ");
INSERT INTO gofl_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Usupun tashetas xeeran xeeran heedzu heedzu alleeqo gambuthatinne ciishshati de7iya lawuze mitha ciishshe daaniyaba medhis. ");
INSERT INTO gofl_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Xompe wothiya kocaa giddon de7iya tooma xeeran oyddu alleeqo gambuthatinne ciishshati de7iya lawuze mitha ciishshe daaniyaba medhis. ");
INSERT INTO gofl_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Waathan de7iya heedzu heedzu tashetape garsan issi issi gambuthi oosetis. ");
INSERT INTO gofl_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Gambuthati, tashetinne xompe wothiya kocay issino gididi, walahi bayna worqafe qoxetidi oosetidosona. ");
INSERT INTO gofl_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Xompe wothiya kocaas laapun xompeta, xompe toysiya qaphetanne enta wothiyabata walahi bayna worqafe oothis. ");
INSERT INTO gofl_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Xompe wothiya kocaanne iyaw go7etiya miishe ubbaa oothanaw hastamanne ichashu kilo giraame gidiya, walahi bayna worqa ongis. ");
INSERT INTO gofl_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Basili7eeli ixaane cuyisiya xarpheeza soqala mithafe giigisis. Iyaw oyddu maazaney de7ees. He xarpheezas adussatethaynne gompay issi wadha; qassi geesay nam7u wadha. Oyddu maazaniyan de7iya kaceti iyara issino gidi oyketidi oosetidosona. ");
INSERT INTO gofl_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Iyaw bolla bagga, oyddu miyanne kaceta walahi bayna worqan lanxis, iya yuushuwaka worqan lanxidi yuushshi aathis. ");
INSERT INTO gofl_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Iyaw gaxa bolla tookanaw maaddiya nam7u worqa sagaayota medhidi, nam7u bagga miyiyan wothis. Enti ixaane xarpheezaa tookiya wode kaso mithata aathanaw maaddeyisata. ");
INSERT INTO gofl_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Kaso mithata soqala mithafe kessidi, worqan lanxis. ");
INSERT INTO gofl_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Geeshsha shuumatetha zaytiyanne sawiya lo77o ixaane shittoda walakidi oothis. ");
INSERT INTO gofl_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Soqala mithafe xuussa yarsho bessi oothis. He yarsho bessa adussatethaynne gompay, ichashu ichashu wadha, qassi geesay nam7u wadhanne takadho. Iyaw oyddu maazaney de7ees. ");
INSERT INTO gofl_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Oyddu maazanetara oyketidi oosetida kaceta medhis. Yaatidi, he yarsho bessa naase biratan lanxis. ");
INSERT INTO gofl_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","He yarsho bessan go7etiya miisheta, disteta, baldeta, akaafata, ashuwa qaphiya qaphetanne tama cooceta ubbaa naase biratape medhis. ");
INSERT INTO gofl_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Naase biratape gite daaniya teqe yarsho bessaas giigisidi, yarsho bessaas giddo zawa yuushshi aathidi wothis. ");
INSERT INTO gofl_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Tookanaw maaddiya kasota aathanaw, oyddu sagaayota medhidi, oyddu maazaneta bolla wothis. ");
INSERT INTO gofl_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Soqala mithafe yarsho bessa tookiya kaso mithata kessidi, naase biratan lanxis. ");
INSERT INTO gofl_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Ha kasota nam7u miyen de7iya sagaayotan aathis. Yarsho bessaa xawulape giigisidi, gidduwa kaysi oothis. ");
INSERT INTO gofl_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Naase biratape meecha kerenne iya wothiya toho medhis. He naase biratay, Geeshsha Dunkaaniya pengen oothiya maccasati ehida mastootiyape eketis. ");
INSERT INTO gofl_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Geeshsha Dunkaaniyas dabaaba baggaa gechanaw al7o liinope magarajo oothis. Dugeha bagga geshetas adussatethay xeetu wadha. ");
INSERT INTO gofl_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Geshetas kate gidana mela laatamu tuussatanne enti eqiya tohota naase biratape oothis. Enta xam7atanne kaceta bira biratape oothis. ");
INSERT INTO gofl_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Pudeha bagga dabaabayka hessada hanidi oosetis. ");
INSERT INTO gofl_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Wuloha bagga gesheta adussatethay ishatamu wadha. Entaw tammu tuussatinne tuussati eqiya tammu tohoti de7oosona. Tuussatas bira biratape oosetida xam7atinne kaceti de7oosona. ");
INSERT INTO gofl_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Dabaaba geliya pengey de7iya, doloha bagga magarajuwa gompay ishatamu wadha. ");
INSERT INTO gofl_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Issi baggara de7iya magarajuwa adussatethay tammanne ichashu wadha. Iyaw heedzu tuussatinne tuussati eqiya tohoti de7oosona. ");
INSERT INTO gofl_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Hanko baggara de7iya magarajuwa adussatethay tammanne ichashu wadha. Iyaw heedzu tuussatinne tuussati eqiya tohoti de7oosona. ");
INSERT INTO gofl_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Dabaaba yuushuwan de7iya gesheti ubbay al7o liinope oosetidosona. ");
INSERT INTO gofl_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Tuussati eqiya tohoti naase biratape oosetidosona. Xam7ati, kacetinne tuussata xeera goossati bira biratape oosetidosona. Dabaaba yuushuwan de7iya tuussati ubbay bira xam7atan oyketidosona. ");
INSERT INTO gofl_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Dabaaba pengiyan de7iya magarajuwa al7o liinope oothidi, kaalosen ocha teera daaneysaninne zo7o qacinan daddidi alleeqisis. Iyaw hanko dabaaba geshetada adussatethay laatamu wadha; qassi geesay ichashu wadha. ");
INSERT INTO gofl_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Iya, oyddu tohoti de7iya oyddu tuussata bolla kaqis. Kaceti, xaara kammeysatinne xam7ati bira biratape oosetidosona. ");
INSERT INTO gofl_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Geeshsha Dunkaaniya dhishetinne iya yuushuwan de7iya gesheta dhisheti ubbay naase biratape oosetidosona. ");
INSERT INTO gofl_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Tammu kiitata oykida nam7u loche shuchati de7iya bessan, Geeshsha Dunkaaniyan, go7etiya miisheta mazgabey haysa. He miisheta mazgabana mela kahiniya Aarona na7a Itamaara aawatetha garsan de7iya Leeweta Musey kiittis. ");
INSERT INTO gofl_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Yihuda sheeshape gidida Huura na7aa na7aa, Ure na7aa, Basili7eeli, Goday kiitidaysada ubbaba oothis. ");
INSERT INTO gofl_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Daane sheeshape gidida Ahisamaaka na7aa Eliyaabi, kushe hiillanchoy, oothiyabas koyro halcho kessiya asi; I, kaalose, ocha teera daaneysanne zo7o qacinan al7o liino daddidi alleeqisiya asi. ");
INSERT INTO gofl_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Geeshsha dunkaaniya oosuwas hanana mela Godaas imetida worqay geeshsha dunkaanen eretida mizaanen issi mukulu kilo giraame gidis. ");
INSERT INTO gofl_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Taybon de7iya asaape eketida biray geeshsha dunkaanen eretida mizaanen, heedzu mukulunne oyddu xeetanne hastamu kilo giraame gidis. ");
INSERT INTO gofl_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Hessika, taybon gelida adde asay, issoy issoy geeshsha dunkaanen eretida mizaaniya liken koyetiya ubbaa immidosona. Laatamu laythinne iyape bolla gidida, mazgaben gelida, adde asaa tayboy usupun xeetanne heedzu mukulunne ichashu xeetanne ishatama. ");
INSERT INTO gofl_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Geeshsha Dunkaaniyanne magarajota essanaw maaddiya xeetu tohota oothanaw 3,400 kilo giraame bira birata ekidosona. Hessika, issi issi tohoy hastamanne oyddu kilo giraame bira birata ekis. ");
INSERT INTO gofl_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Basili7eeli, attida hastamu kilo giraame bira biratan xam7ata, kacetanne tuussatas xeera goossata oothis. ");
INSERT INTO gofl_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Asay Godaas immida naase biratay 2,425 kilo giraame. ");
INSERT INTO gofl_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","He naase biratan Geeshsha Dunkaaniya pengiya essiya tohota, gite daaniyabara naase birata yarsho bessaanne iya giddon go7etiya dumma dumma miisheta medhis. ");
INSERT INTO gofl_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","Qassi dabaaba yuushuwan de7iya dirsaa tohotinne pengiya bolla eqida tohoti, Geeshsha Dunkaaneynne iya yuushuwan de7iya dabaaba dirsaa dhisheti ubbay he naase biratape oosetidosona. ");
INSERT INTO gofl_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Kahineti Geeshsha Dunkaaniyan oothiya wode ma7ana boncho ma7ota, kaalosen, ocha teera daaniya qacinapenne zo7o qacinan daddidosona. Aaroni ma7iya kahinetetha ma7uwa Goday Muse kiitidaysada oothidosona. ");
INSERT INTO gofl_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Qassi efuudiya, worqafe, kaalosepe, ocha teera daaniya qacinape, zo7o qacinapenne al7o liinope daddidosona. ");
INSERT INTO gofl_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Enti worqaa qoxidi, lee7isidi, iya qaraaridi, qacinada kessidosona. Yaatidi kaalosen, ocha teera daaneysan, zo7o qacinaninne al7o liinon alleeqisidi daddidosona. ");
INSERT INTO gofl_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Enti nam7u hashiyara wodhidi, nam7u bagga woli gathidi oysethanaw maaddiya qangota efuudiyas oothidosona. ");
INSERT INTO gofl_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Goday Muse kiitidaysada, hiillanchoy alleeqisida dancoyka efuudey oosetidaysatape oosetidi, worqan, kaalosen, ocha teera daaneysan, zo7o qacinaninne al7o liinon dadetis. ");
INSERT INTO gofl_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Enti margide geetetiya shuchata giigisidi, worqafe oosetida kaquwa bolla wothidosona. Maatame bolla woocidi xaafeysada, he shuchata bolla Isra7eele nayta sunthaa woocidi xaafidosona. ");
INSERT INTO gofl_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Goday Muse kiitidaysada, tammanne nam7u Isra7eele nayta qofisiyaba gidana mela enta, efuudiya qangotan wothidosona. ");
INSERT INTO gofl_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Enti, tiran ma7etiya ma7uwa efuudey oosetidaysatape oothidi, efuudiyada alleeqisidosona. ");
INSERT INTO gofl_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Iyaw oyddu maazaneti de7oosona; geesaynne gompay issi issi takadho gididi, dakoyetees. ");
INSERT INTO gofl_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Iya bolla oyddu maaran inqo geetetiya al7o shuchata wothidosona. Koyro maaran sardiyoone, toophazenne phooliya al7o shuchata; ");
INSERT INTO gofl_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","nam7antho maaran baluure, sanparenne almaaze geetetiya al7o shuchata; ");
INSERT INTO gofl_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","heedzantho maaran yaakinte, kelqedoonenne ametesxinoosa geetetiya al7o shuchata; ");
INSERT INTO gofl_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","oyddantho maaran birille, margidenne yasphide geetetiya al7o shuchata wothidosona. Hessata ubbaa worqafe oosetida kaquwa bolla wothidosona. ");
INSERT INTO gofl_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Tammanne nam7u shuchata bolla issi issi Isra7eele nayta sunthay woocetidi xaafetis. ");
INSERT INTO gofl_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Tiran ma7etiya ma7uwas walahi bayna worqafe wodoroda dooqada santhalaata ootha. ");
INSERT INTO gofl_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Nam7u worqa kaqotanne nam7u worqa sagaayota medhidi, nam7u worqa sagaayota tiran ma7etiya ma7uwas qommo baggan de7iya maazanetara gathidi oysethidosona. ");
INSERT INTO gofl_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","He nam7u worqa santhalaatata nam7u worqa sagaayotara gathidi oysethidosona. ");
INSERT INTO gofl_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","He santhalaatata, hanko bagga xeeraa, nam7u kaqotara gasethidosona. Yaatidi, efuudiyas sintha baggara, hashiyara wodhiya qangotara gathidi qachidosona. ");
INSERT INTO gofl_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Qassi nam7u worqa sagaayota medhidi, efuudiyas sintha baggara de7iya tiran ma7etiya ma7uwas, gaatha baggara de7iya nam7u maazaneta xeeran aathidosona. ");
INSERT INTO gofl_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Hessadaka, worqafe hara nam7u migiddota oothada, efuudiyas sintha bagga hashiyara wodhiya qanguwas garsa baggara, sikuwa matan dancuwaafe qommo baggara oysethidosona. ");
INSERT INTO gofl_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Goday Muse kiitidaysada, tiran ma7etiya ma7uwa bolla de7iya migiddota efuudiyan de7iya migiddotara gathidi, kaalose qacina qachidosona. Tiran ma7etiya ma7oy xeessafe qommon pee7iya gisho qashoy dol7enna. ");
INSERT INTO gofl_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Efuudiyape bollara ma7etiya adussa ma7oy kumethi kaalose afilape giigisidosona. ");
INSERT INTO gofl_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","He adussa ma7uwas huuphe aathiya luho medhidi, peedhetonna mela guye qalam7idi, yuushshi aathidi sikidosona. ");
INSERT INTO gofl_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Adussa ma7uwas duge bagga macara yuushuwan kaalosen, ocha teera daaniya zo7o qacinaninne al7o liinon, oromaane teera misileta medhidosona. ");
INSERT INTO gofl_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Enti walahi bayna worqafe daalata medhidi, adussa ma7uwas duge bagga gaxan, oromaane misileta giddon wothidosona. ");
INSERT INTO gofl_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Goday Muse kiitidaysada, oromaane teera misileta, adussa ma7uwas duge bagga macaraa yuushuwan aathidosona. ");
INSERT INTO gofl_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Enti, Goday Muse kiitidaysada, Aaronasinne iya naytas, shamizeta, ");
INSERT INTO gofl_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","huuphe qaceta, uketanne gaatha sureta al7o liinope daddidi giigisidosona. ");
INSERT INTO gofl_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Qassi dancuwa kaalosen, ocha teera daaniya qacinan, zo7o qacinaninne al7o liinon alleeqisidi, giigisidosona. ");
INSERT INTO gofl_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Enti, geeshsha kallacha misiliya walahi bayna worqafe medhidi, iya bolla, “Godaas Dummatis” giya qaala woocidi xaafidosona. ");
INSERT INTO gofl_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Yaatidi, Goday Muse kiitidaysada, huuphe qaciya bolla kaalose qacinara qachidosona. ");
INSERT INTO gofl_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Geeshsha Dunkaaniya ooso ubbay kumethi poletis. Isra7eele asay, Goday Muse kiitidaysada oothidosona. ");
INSERT INTO gofl_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Hessafe guye, enti Geeshsha Dunkaaniyanne iya miisheta Museko ehidosona. Hessatika, kaceta, tuussata, liyoota, tuuqetanne enti eqiya tohota. ");
INSERT INTO gofl_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","Bolla kamaas, zo7o qalamen yeggidi kessida dorsa ite, haashetida do7a ite, magarajuwa, ");
INSERT INTO gofl_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","Tammu kiitata oykida Taabotiya, iya tookiya kaso mithatanne nagara atotetha kamaa, ");
INSERT INTO gofl_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","xarpheezanne iya miisheta ubbaa, Godaa sinthan de7iya geeshsha daabbuwa, ");
INSERT INTO gofl_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","walahi bayna worqafe oosetida xompe wothiya kocaa, iya bolla de7iya xompeta, iya miisheta ubbaanne xompe zayte, ");
INSERT INTO gofl_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","worqafe oosetida yarsho bessi, shuumatetha zayte, sawiya ixaane, Geeshsha Dunkaaniya penge magarajuwa, ");
INSERT INTO gofl_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","naase biratape oosetida yarsho bessi, naase birata teqiya, tooho kaso mithatanne iya miisheta ubbaa, meecha kerenne iya wotheysa, ");
INSERT INTO gofl_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","dabaaba geliya penge magarajuwa, tuussatanne, enti eqiya tohota, dabaaba magarajuwa, tole wodorota, dhisheta, Geeshsha Dunkaaniyan go7etiya miisheta ubbaa, ");
INSERT INTO gofl_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","kahineti Geeshsha bessan ma7iya boncho ma7ota, Aaroninne iya nayti ma7iya kahinetetha ma7ota. ");
INSERT INTO gofl_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Isra7eele asay ooso ubbaa, Goday Muse kiitidaysada oothidosona. ");
INSERT INTO gofl_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Asay, ooso ubbaa, Goday kiitidaysada oothidaysa Musey be7is. Hessa gisho, Musey enta anjis. ");
INSERT INTO gofl_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Goday Museko haysada yaagis; ");
INSERT INTO gofl_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Koyro ageenan, koyro gallasan, Geeshsha Dunkaaniya toka. ");
INSERT INTO gofl_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Tammu kiitata oykida Caaqo Taabotiya iya giddon wothada, iya sinthan magarajuwa kaqa. ");
INSERT INTO gofl_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Xarpheezaa gaathi gelsada, koshshiya miisheta ubbaa iya bolla wotha. Xompe wothiya kocaa gelsada iya bolla xompeta wotha. ");
INSERT INTO gofl_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Ixaane cuyisiya worqa xarpheezaa Caaqo Taabotiya sinthan wotha. Geeshsha Dunkaaniya penge magarajuwa kaqa. ");
INSERT INTO gofl_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Xuugetiya yarsho bessi Geeshsha Dunkaaniya sinthan wotha. ");
INSERT INTO gofl_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Meecha keriya Geeshsha Dunkaaniyapenne yarsho bessaafe giddon wothada, iyan haathe kuntha. ");
INSERT INTO gofl_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Geeshsha Dunkaaniyape karera dabaaba yuushsha aatha giigisada, magarajuwa Dunkaaniya penge bolla kaqa. ");
INSERT INTO gofl_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“Yaatada, geeshsha zaytiya ekada, Geeshsha Dunkaaniyanne iya giddon de7iya ubbaba tiyada, dummaya; I geeshshi gidana. ");
INSERT INTO gofl_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Kaallada, xuussa yarsho bessinne iyan go7etiya miishe ubbaa tiyada, dummaya; I polo geeshshi gidana. ");
INSERT INTO gofl_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Meecha keriyanne iya wothiya miisheta tiyada, dummaya. ");
INSERT INTO gofl_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“Aaronanne iya nayta Geeshsha Dunkaaniya penge ehada haathan enta meecca. ");
INSERT INTO gofl_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Kahine ma7uwa Aarona mayzada, I taw kahinetethan oothana mela iya tiyada, dummaya. ");
INSERT INTO gofl_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Iya adde naytaka ehada shamize mayza. ");
INSERT INTO gofl_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Enti taw kahinetethan oothana mela, enta aaway tiyetidaysada, entaka tiya. He tishsha gaason, yaana laytha ubban, enti taw kahine gididi oothana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Musey, ubbaba Goday kiitidaysada oothis. ");
INSERT INTO gofl_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Hessa gisho, enti Gibxefe keyida nam7antho laythan, koyro ageenan, koyro gallasan Geeshsha Dunkaaniya tokis. ");
INSERT INTO gofl_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Musey, Dunkaaniya tohota essis, tuuqeta, liyootanne tuussata aathis. ");
INSERT INTO gofl_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Goday kiitidaysada, Musey, garsa kamaanne bolla kamaa Dunkaaniya bolla kammis. ");
INSERT INTO gofl_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Yaatidi, tammu kiitata oykida nam7u loche shuchata, Taabotiya giddon wothis. Tooho kaso mithata Taabotiya sagaayotan aathis; nagara atotetha kamaka Taabotiya bolla wothis. ");
INSERT INTO gofl_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Taabotiya Geeshsha Dunkaaniya giddo gelsidi, geshe magarajuwa kaqis. Yaatidi, Goday kiitidaysada, Caaqo Taabotiya kammis. ");
INSERT INTO gofl_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Musey, xarpheezaa Geeshsha Dunkaaniya giddo gelsidi, magarajuwafe karera, pudeha baggan wothis. ");
INSERT INTO gofl_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Goday kiitidaysada, Godaa sinthan wothiya geeshsha daabbuwa iya bolla wothis. ");
INSERT INTO gofl_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Xompe wothiya kocaa, Geeshsha Dunkaaniya giddo gelsidi, xarpheezape sintha baggara Geeshsha Dunkaaniyas dugeha baggan wothis. ");
INSERT INTO gofl_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Goday kiitidaysada, Musey, Godaa sinthan xompeta oythis. ");
INSERT INTO gofl_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Musey, worqa yarsho bessa Geeshsha Dunkaaniya giddo gelsidi, magarajuwafe sintha baggara wothis. ");
INSERT INTO gofl_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Goday kiitidaysada, sawiya ixaane iya bolla cuyisis. ");
INSERT INTO gofl_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Geeshsha Dunkaaniya pengen magarajuwa kaqis. ");
INSERT INTO gofl_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Xuugetiya yarsho bessi, Geeshsha Dunkaaniya penge sinthan wothis. Goday kiitidaysada, iya bolla xuussa yarshonne katha yarsho yarshis. ");
INSERT INTO gofl_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Meecha keriya Geeshsha Dunkaaniyapenne yarsho bessaafe giddon wothidi, iyan haathe kunthis. ");
INSERT INTO gofl_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Musey, Aaroninne iya nayti banta kushiyanne tohuwa iyan meecetidosona. ");
INSERT INTO gofl_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Goday kiitidaysada, enti Geeshsha Dunkaaniya geliya wode woyko yarsho bessi shiiqiya wode hessa oothosona. ");
INSERT INTO gofl_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Geeshsha Dunkaaniyanne yarsho bessa yuushshi aathidi dabaaba giigisidi, he dabaaba pengen magarajo kaqis. Hessada oothidi, Musey oosuwa polis. ");
INSERT INTO gofl_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Hessafe guye, shaaray Geeshsha Dunkaaniya kammis; Godaa bonchoyka iya kumis. ");
INSERT INTO gofl_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Shaaray Geeshsha Dunkaaniya kammida gishonne Godaa bonchoy iyan kumida gisho, Musey iya giddo gelanaw danda7ibeenna. ");
INSERT INTO gofl_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Isra7eeleti banta de7iya bessaa yeddidi, baanaw dendey, he shaaray Dunkaaniyape dendiya wodena. ");
INSERT INTO gofl_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Shin shaaray dendonna ixiko, enti banta de7iya bessaa yeddidi bookona. ");
INSERT INTO gofl_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Godaa shaaray gallas gallas Geeshsha Dunkaaniya kammees, qamma qamma qassi shaara giddon tamay eexees. Isra7eele asay biya wode ubban he shaara be7oosona.");
INSERT INTO gofl_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Godaa Xoossay, Geeshsha Dunkaaniya giddon gididi Muse xeegidi yaagis; ");
INSERT INTO gofl_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","Isra7eele asaas haysada yaagada oda; hintefe oonika Godaas yarsho yarshiya wode ba mehiyape, ba dorsafenne ba deeshape eho. ");
INSERT INTO gofl_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","He yarshoy mehepe xuussa yarshos gidiko borey bayna wofaano gido. Goday he yarshuwa ekana mela Geeshsha Dunkaaniya geliya pengen yarsho. ");
INSERT INTO gofl_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Yarshuwa yarshiya uray xuussa yarshos ehida mehiya huuphen ba kushiya wotho. Hessi iya nagara atotethas Goday ekida yarsho gidana. ");
INSERT INTO gofl_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","I he wofaanuwa Godaa sinthan shuko; kahineti, Aarona nayti he suuthaa ekidi, Geeshsha Dunkaane geliya pengen de7iya yarsho bessa oyddu maazaneta bolla wurxo. ");
INSERT INTO gofl_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","He mehiya galbaa qaaridi, ashuwa qommon qommon kesso. ");
INSERT INTO gofl_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Kahiniya Aarona nayti yarsho bessan mithi wothidi tama eetho. ");
INSERT INTO gofl_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Kahineti, Aarona nayti he kessida ashuwa bolla huuphiyanne modhuwa gujidi, yarsho bessan taman de7iya mithaa bolla maarayidi wotho. ");
INSERT INTO gofl_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Shin he uray ulo ashuwanne gedata haathan meecco. Kahiney he ubbaa yarsho bessan xuuggo; hessi Godaas taman xuugetiya sawo tonku giya yarsho gidana. ");
INSERT INTO gofl_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Xuugetiya yarshos I immiya imoy dorsaafe woyko deeshape gidiko, borey bayna maraze woyko kole gido. ");
INSERT INTO gofl_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","He mehiya yarsho bessaafe pudeha baggara Godaa sinthan shuko. Kahineti, Aarona nayti he suuthaa ekidi yarsho bessa oyddu maazaneta ubbaa bolla wurxo. ");
INSERT INTO gofl_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","He uray ashuwa qommon qommon kesso; kahiney he kessida ashuwa bolla huuphiyanne modhuwa gujidi, yarsho bessan taman de7iya mithaa bolla maarayidi wotho. ");
INSERT INTO gofl_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Shin he uray ulo ashuwanne gedata haathan meecco; kahiney he ubbaa yarsho bessan xuuggo; hessi Godaas taman xuugetiya sawo tonku giya yarsho gidana. ");
INSERT INTO gofl_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Godaas yarshetiya xuussa yarshoy kafo gidiko holle woyko kuraacho gido. ");
INSERT INTO gofl_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Kahiney hessa ekidi qoodhiya kushera duutho; huuphiya yarsho bessa bolla de7iya taman xuuggo. Iya suuthay yarsho bessa miyera guko. ");
INSERT INTO gofl_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Ulo ashuwanne qefiya kessidi, yarsho bessaafe doloha baggara bido qoliya bessan yeggo. ");
INSERT INTO gofl_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","I he kafuwa qefeta oykidi shaako, shin kumethi shaakofo. Kahiney yarsho bessa bolla de7iya taman wothidi xuuggo; hessi Godaas taman xuugetiya sawo tonku giya yarsho gidana. ");
INSERT INTO gofl_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Oonika katha yarsho Godaas yarshiya wode he yarshoy lo77o dhiille gido; iya bolla zaytenne ixaane gujo. ");
INSERT INTO gofl_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Hessa kahine gidida Aarona naytako eho; kahineti he lo77o dhiilliyafe issi kuuca ekidi, zaytenne ixaane ubbaa gujidi yarsho bessa bolla taman xuuggo. Hessi Godaas taman xuugetiya sawo tonku giya qofiso yarsho gidana. ");
INSERT INTO gofl_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Katha yarshuwafe attidaysi Aaronasinne iya naytas gidana. Hessi Godaas taman xuugetida ubbaafe geeshsha yarsho gidana. ");
INSERT INTO gofl_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Yarshetiya uythay coocen kompetida gidiko, zaytera munuqetida lo77o dhiille gido. He uythay irshoy bayna zayten munuqetidaysa woyko lee7on uuketidi zayten tiyetidaysa gido. ");
INSERT INTO gofl_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Yarshetiya uythay beshen uuketidaba gidiko, irshoy bayna zayten munuqetida lo77o dhiille gido. ");
INSERT INTO gofl_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Iya menthada iya bolla zayte tigada katha yarsho oothada yarsha. ");
INSERT INTO gofl_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Ne yarshiya kathay oton kaxidaba gidiko zayten munuqetida lo77o dhiille gido. ");
INSERT INTO gofl_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Hessada hanidi giigida kathaa yarshuwa Godaas ehada kahiniyas imma; kahiney hessa ekidi yarsho bessan yarsho. ");
INSERT INTO gofl_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Kahiney he katha yarshuwa ekidi, yarsho bessan xuussa yarsho oothidi taman xuuggo. Hessi Godaas taman xuugetiya sawo tonku giya qofiso yarsho gidana. ");
INSERT INTO gofl_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Katha yarshuwafe attidaysi Aaronasinne iya naytas gidana. Hessi Godaas taman xuugetida ubbaafe geeshsha yarsho gidana. ");
INSERT INTO gofl_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Neeni irsho woyko eessi Godaas taman xuuggada yarshanaw bessonna gisho Godaas hinte ehiya katha yarshoy irshoy de7iyaba gidopo. ");
INSERT INTO gofl_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Hayisata bayra yarsho oothidi Godaas yarshanaw danda7eeta, shin sawo tonku giya yarsho oothidi Godaas yarsho bessan xuuggofite. ");
INSERT INTO gofl_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Maxiney, neeni ne Xoossara caaqida caaquwas malla gidiya gisho ne katha yarsho ubban maxine yegga. Ne katha yarsho ubbaa maxinen mal7etha. ");
INSERT INTO gofl_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Neeni kathaafe bayra Godaas ehiya wode caacetidi shirketida tiya gidanaw bessees. ");
INSERT INTO gofl_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Hessi katha yarsho gidiya gisho iya bolla zayte tiga; ixaane wotha. ");
INSERT INTO gofl_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Kahiney he caacetidi shirketidanne zaytey tigetida katha yarshuwafe bagga ekidi ixaane ubbaara qofiso yarsho oothidi Godaas taman xuuggo. ");
INSERT INTO gofl_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Issi asi issifetetha yarshos ba mehiyape borey bayna ussi woyko wofaano Godaa sinthe shiisho. ");
INSERT INTO gofl_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Yarshanaw ehida mehiya huuphen ba kushiya wothidi Geeshsha Dunkaaniya pengen shuko. Kahineti, Aarona nayti suuthaa ekidi yarsho bessa oyddu maazaniya bolla wurxo. ");
INSERT INTO gofl_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Issifetetha yarshuwafe xuussa yarsho oothidi Godaas shiisho; hessika ulo ashuwa kammida moodhiya, ");
INSERT INTO gofl_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","nam7u kilahota, enta bolla de7iya moodhiyanne tiriya xeera baggaa eko. ");
INSERT INTO gofl_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Aarona nayti hessa xuussa yarshuwara issife yarsho bessa bolla de7iya mithaa bolla wothidi xuuggo. Hessi Godaas xuugetiya sawo tonku giya yarsho gidana. ");
INSERT INTO gofl_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Issifetetha yarshos shiiqey macca woyko adde dorse gidiko borey baynaba gido. ");
INSERT INTO gofl_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Issi asi dorsa urge yarshiyaba gidiko hessa Godaa sinthan shiisho. ");
INSERT INTO gofl_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","He dorsa urgiya huuphen ba kushiya wothidi Geeshsha Dunkaaniya pengen shuko. Aarona nayti suuthaa ekidi yarsho bessa oyddu maazaniya bolla wurxo. ");
INSERT INTO gofl_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Issifetetha yarshuwafe Godaas xuussa yarsho oothidi yarsho; hessika modhuwa, goynaape bidi zoko meqethaa gakanaw de7iya modhuwa, ulo ashuwa kammida moodhiya, ");
INSERT INTO gofl_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","nam7u kilahota, enta kammida moodhiya tiriya xeera baggaa eko. ");
INSERT INTO gofl_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Kahiney hessa Godaas xuussa yarsho oothidi yarsho bessan xuuggo. ");
INSERT INTO gofl_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","I yarshey deeshe gidiko I hessa Godaa sinthe shiisho. ");
INSERT INTO gofl_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","Iya huuphen ba kushiya wothidi Geeshsha Dunkaaniya sinthan shuko. Aarona nayti suuthaa ekidi yarsho bessa yuushuwa wurxo. ");
INSERT INTO gofl_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","I he yarshuwafe ekidi Godaas xuussa yarsho oothidi yarsho; hessika ulo ashuwa kammida moodhiya ubbaa, ");
INSERT INTO gofl_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","nam7u kilahota, enta kammida moodhiya tiriya xeera baggaa eko. ");
INSERT INTO gofl_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Kahiney hessa Godaas sawo tonku giya yarsho oothidi yarsho bessan xuuggo. Modho ubbay Godaaba. ");
INSERT INTO gofl_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Hinte modhonne suuthi moopite. Hessi hinttesnne yaana yeletethay de7iya bessa awunka naagiya woga gido. ");
INSERT INTO gofl_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Goday Museko haysada yaagis; ");
INSERT INTO gofl_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","Neeni Isra7eele asaas haysada yaagada oda; oonika qoponna nagara oothiko woyko Godaa kiitatape issuwa menthiko, ");
INSERT INTO gofl_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","Dooretida kahiney nagara oothidi asaa gomen gathiko, I ba oothida nagaraa gisho borey bayna wofaano Godaas nagara yarsho oothidi eho. ");
INSERT INTO gofl_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","He wofaanuwa Geeshsha Dunkaaniya penge ehidi, huuphen ba kushiya wothidi Godaa sinthan shuko. ");
INSERT INTO gofl_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Dooretida kahiney wofaanuwa suuthaafe guuthara ekidi Geeshsha Dunkaaniya gelsidi, ");
INSERT INTO gofl_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","ba biradhiya suuthan yeddi ekidi Geeshsha Dunkaaniya magarajuwa sinthan Godaa sinthan laapun toho wurxo. ");
INSERT INTO gofl_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Kahiney guutha suuthi ekidi Geeshsha Dunkaaniyan Godaa sinthan sawiya ixaane cuyisiya bessan de7iya kaceta tiyo. Attida suuthaa Geeshsha Dunkaaniya geliya penge baggara de7iya xuussa yarsho bessa garsan gusso. ");
INSERT INTO gofl_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Nagara yarshos shuketida wofaanuwa modhuwa ubbaa, ulo ashuwa ma7ida modhuwa, ");
INSERT INTO gofl_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","nam7u kilahota, enta kammida moodhiyanne tiriya xeera baggaa eko. ");
INSERT INTO gofl_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","Issifetetha yarshos shuketida wofaanuwa modhuwa kessidaysada iyape modhuwa kesso. Kahiney xuussa yarsho oothidi yarsho bessan xuuggo. ");
INSERT INTO gofl_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Shin wofaanuwa galbaa, iya ashuwa ubbaa, iya huuphiya, iya tohota, ulo ashuwa, tociya, ");
INSERT INTO gofl_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","ashuwape attidaysa ubbaa gutaape kare kessidi bido yeggiya woga mela geeshsha bessi efidi yan taman xuuggo. ");
INSERT INTO gofl_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Isra7eele maabara ubbay qoponna nagara oothikonne Godaa kiitatape issuwa menthiko hessi entafe qosetikoka entaw bala gididi taybetana. ");
INSERT INTO gofl_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Enti oothida nagaraa akeekiya wode nagara yarshos haniya wofaano Geeshsha Dunkaaniya sinthe eho. ");
INSERT INTO gofl_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Maabara cimati banta kushiya wofaanuwa huuphen wothidi Godaa sinthan shuko. ");
INSERT INTO gofl_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Dooretida kahiney wofaanuwa suuthaafe guuthara ekidi Geeshsha Dunkaaniya gido gelo. ");
INSERT INTO gofl_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","I ba biradhiya suuthan yeddi ekidi magarajuwa sintha baggara Godaa sinthan laapun toho wurxo. ");
INSERT INTO gofl_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Qassi guutha suuthi ekidi, Geeshsha Dunkaaniya giddon Godaa sinthan ixaane cuyisiya bessan de7iya kaceta bolla tiyo. Attida suuthaa Geeshsha Dunkaaniya geliya pengiya baggara de7iya xuussa yarsho bessa garsan gusso. ");
INSERT INTO gofl_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Modho ubbaa ekidi yarsho bessan xuuggo. ");
INSERT INTO gofl_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Ha wofaanuwaka nagara yarshos shuketida wofaanuwa mela oothada shiisha. Hessada oothidi, kahiney nagara atotetha wogaa polana; asaa nagaray atto geetetana. ");
INSERT INTO gofl_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Kahiney wofaanuwa gutaape kare kessidi, koyro wofaanoy xuugetidaysada iyaka xuuggo; hessi maabaraas yarshetiya nagara yarsho. ");
INSERT INTO gofl_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Asaa kaalethiya shuumatape issoy qoponna nagara oothikonne Godaa Xoossaa kiitaape issuwa menthiko he uray bala. ");
INSERT INTO gofl_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","I ba oothida nagaraa akeekidaape guye, borey bayna issi kole eho. ");
INSERT INTO gofl_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","He koliya huuphen ba kushiya wothidi xuussa yarshoy yarshetiya bessan Godaa sinthan shuko; hessi nagara yarsho. ");
INSERT INTO gofl_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Kahiney ba biradhiya suuthan yeddi ekidi, xuussa yarsho bessan de7iya kaceta bolla tiyo; attida suuthaa qassi xuussa yarsho bessa garsan gusso. ");
INSERT INTO gofl_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Issifetetha yarshos shiiqida modhuwa ubbaa xuuggidaysada ha koliya modhuwa xuuggo. Hessada oothidi, kahiney he uraa nagara qushisees; he uraa nagaray atto geetetana. ");
INSERT INTO gofl_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Maabaraape issi asi qoponna nagara oothikonne Godaa kiitaape issuwa menthiko he uray bala gidees. ");
INSERT INTO gofl_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","I ba oothida nagaraa akeekidaape guye borey bayna macca deeshi ba nagaraa gisho eho. ");
INSERT INTO gofl_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Ba kushiya he deeshe huuphen wotho; yaatidi xuussa yarsho bessan nagara yarsho oothidi shuko. ");
INSERT INTO gofl_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Hessafe guye, kahiney he deeshe suuthan ba biradhiya yeddi ekidi xuussa yarsho bessan de7iya kaceta bolla tiyo. Attida suutha ubbaa yarsho bessaafe garsan gusso. ");
INSERT INTO gofl_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Issifetetha yarshos shuketida mehiyape modhuwa kessidaysa mela he deeshe modhuwa qaari kessidi, yarsho bessan Godaas sawo tonku giya yarsho oothidi xuuggo. Hessada oothidi, kahiney he uraa nagaraa qushisees; iya nagaray atto geetetana. ");
INSERT INTO gofl_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","He uray ba nagaraa gisho yarshey dorse gidiko, borey bayna macca dorse gido. ");
INSERT INTO gofl_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","I ba kushiya he dorse huuphen wotho; yaatidi, xuussa yarsho mehe shukiya bessan shuko. ");
INSERT INTO gofl_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Hessafe guye, kahiney dorse suuthan ba biradhiya yeddi ekidi xuussa yarshoy yarshetiya bessan de7iya kaceta bolla tiyo. Attida suuthaa yarsho bessaafe garsan gusso. ");
INSERT INTO gofl_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Issifetetha yarshos shuketida mehiyape modhuwa kessidaysada he dorse modhuwa qori kessidi, yarsho bessan Godaas xuussa yarsho oothidi xuuggo. Hessada oothidi, kahiney he uraa nagaraa qushisees; iya nagaray atto geetetana. ");
INSERT INTO gofl_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Issi asi ba be7idaba woyko ba eriyaba markatana mela oyshetidi markatonna ixiko he uray nagara oothida gisho seereto. ");
INSERT INTO gofl_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Issi asi eronna de7ishe tunabaa, hessika, hayqida do7a woyko mehe woyko sa7ara gooshetiya do7ata bochiko, hessi tuna gideysa I eronna ixikoka tuna gidiya gisho bala gidees. ");
INSERT INTO gofl_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Issi asi eronna de7ishe asa asatethafe goggidi tunisiyaba bochiko, hessi tuna gideysa I eronna ixiko, tuna gidiya gisho bala gidees. ");
INSERT INTO gofl_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Issi asi iitaba gidin lo77oba oothanaw eeson caaqikonne ba caaqidaysa dogidi, guyepe I akeekida wodepe doomidi bala gidees. ");
INSERT INTO gofl_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Issi asi ha odetida balatape issuwa oothidaba gidiko ba oothida nagaraa paaxo. ");
INSERT INTO gofl_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","I ba oothida nagaraa gisho Godaas ba mehiya giddofe macca dorse woyko macca deeshe nagaraa yarsho oothidi shiisho. Kahiney ekidi he uraa nagaraa qushethas yarshana. ");
INSERT INTO gofl_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Issi asi ba oothida nagaraa gisho yarshanaw dorse woyko deeshe shammanaw iyaw gatey gakonna ixiko nam7u kuraachota woyko nam7u holleta, issuwa nagara yarshos qassi issuwa xuussa yarshos oothidi Godaas eho. ");
INSERT INTO gofl_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","I enta kahiniyas immo; kahiney nam7u holletape issuwa qoodhiya mirqidi duuthonnashin, nagara yarsho oothidi shiisho. ");
INSERT INTO gofl_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Yaatidi suuthaafe guuthara ekidi, yarsho bessa matan wurxo; attida suuthaa yarsho bessa garsan gusso; hessi nagara yarsho. ");
INSERT INTO gofl_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Hanko holliya qassi higgey kiiteysada xuussa yarsho oothidi xuuggo. Kahiney haysada oothidi, uray oothida nagaraa qushisanaw yarsho yarshees; he uraa nagaray atto geetetana. ");
INSERT INTO gofl_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Shin issi asi nam7u holle woyko nam7u kuraacho ehanaw gatey gakonna ixiko, issi kilo giraame lo77o dhiille ba nagaraa gisho yarsho oothidi eho. He dhiilley nagara yarsho gidiya gisho zaytey woyko ixaaney iya bolla guzhetofo. ");
INSERT INTO gofl_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","I hessa ehidi kahiniyas immo; kahiney he dhiilliyafe issi kuuca ekidi, Godaas shiiqiya katha yarshuwara gathidi, qofiso oothidi yarsho bessan xuuggo; hessi nagara yarsho. ");
INSERT INTO gofl_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Issi asi ha nagaratape issuwa oothiko haysada oothidi iya nagara qushisees; he uraa nagaray atto geetetana. He yarshuwafe attidaysi katha yarshuwada kahiniyas gido. ");
INSERT INTO gofl_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Goday Museko haysada yaagis; ");
INSERT INTO gofl_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","Oonika Godaa naaqikonne geeshsha miisheta tunisidi qoponna nagara oothiko ba naaquwas ba mehiya giddofe borey bayna issi maraze Godaas eho. Iya gatey geeshsha dunkaanen eretida mizaane ginan cigeto; hessi naaqo yarsho. ");
INSERT INTO gofl_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","I geeshsha miisheta bolla nagara oothida gisho koyro cigganaw bessiya gatiya bolla xeetape laatamu kushe gujidi kahiniyas immo. Kahiney hessa maraziyara gathi yarshidi uraa naaquwa qushisees; iya nagaray atto geetetees. ");
INSERT INTO gofl_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Issi asi qoponnashin, Godaa kiitatape issuwa menthidi nagara oothiko I hessa eronna ixikoka bala gidiya gisho ba nagaran seereto. ");
INSERT INTO gofl_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","I ba mehiyape borey baynanne gate kunthiya issi maraze naaqo yarshos kahiniyako eho. Kahiney he maraziya yarshidi uraa naaquwa qushisees; iya naaqoy atto geetetees. ");
INSERT INTO gofl_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","I tumape Godaa naaqida gisho hessi naaqo yarsho. ");
INSERT INTO gofl_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Goday Museko haysada yaagis; ");
INSERT INTO gofl_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","Issi asi hara asi hadara wothidaba woyko tal7idaba lahiko woyko bonqiko woyko cimmiko, ");
INSERT INTO gofl_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","woyko dhayidabaa demmidi ta be7abike gidi wordon caaqikonne asi oothiya haysa melabaape issuwa oothiko, ");
INSERT INTO gofl_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","hessan nagarancho gididi bentiko, kaysidaba woyko bonqidaba woyko hadara ekidaba woyko dhayin demmidaba, ");
INSERT INTO gofl_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","woyko wordon caaqidi ekida kumetha shaluwa godaas zaaro. Qassi ba naaqo yarshuwa yarshiya gallas ba ekidaba bolla xeetape laatamu kushe gujidi shaluwa godaas immo. ");
INSERT INTO gofl_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Qassi ba naaquwa gisho Godaas yarsho yarshiya wode ba mehiya giddofe borey bayna issi maraze kahiniyako eho. He dorsay naaqo yarshos gate kuntheysa gido. ");
INSERT INTO gofl_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Kahiney he dorsaa yarshidi he uraa naaquwa qushisees; he uraa naaqoy atto geetetana. ");
INSERT INTO gofl_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Goday Museko haysada yaagis; ");
INSERT INTO gofl_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","Aaronanne iya adde nayta haysada yaagada kiitta; xuussa yarshuwas de7iya wogay haysa; xuussa yarshoy sa7i wontana gakanaw yarsho bessan de7o. Tamay yarsho bessan qamma kumethi eexishe aqo. ");
INSERT INTO gofl_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Kahiney liinope dadetida qamise ma7idi, sure dancidi, xuussa yarshuwa tamay mida biduwa kaashidi yarsho bessa miyen laallo. ");
INSERT INTO gofl_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Yaatidi ma7uwa qaari wothidi hara ma7o ma7idi he biduwa gutaape gaxa efidi wogaada geeshsha bessan qolo. ");
INSERT INTO gofl_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Yarsho bessaa bolla de7iya tamay to7onna ubba wode eexishe de7o. Kahiney wonta wonta mithi iya bolla gujo. Xoossa yarshuwa mitha bolla maaran wothidi, issifetetha yarshuwa modhuwa iya bolla xuuggo. ");
INSERT INTO gofl_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Tamay yarsho bessa bolla ubba wode eexishe de7o; to7anaw koshshenna. ");
INSERT INTO gofl_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Katha yarshos imetida wogay haysa; kahine gidida Aarona nayti yarsho bessaafe sintha baggara Godaa sinthan yarsho. ");
INSERT INTO gofl_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Kahiney issi kuuca lo77o dhiillenne zayte ekidi katha yarshuwa bolla de7iya ixaaniyara yarsho bessan Godaas sawo tonku giya qofiso yarsho oothidi xuuggo. ");
INSERT INTO gofl_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Iyape attidaysa Aaroninne iya adde nayti uythi uukidi Dunkaaniya dabaaban de7iya geeshsha bessan mo. ");
INSERT INTO gofl_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","He uythay irshoy bayna uuketo. Taman xuussa yarshuwafe hessa taani entaw gisho oothada immas. Nagara yarshuwa melanne naaqo yarshuwa mela I ubbaafe geeshshi. ");
INSERT INTO gofl_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Godaas taman xuussa yarshuwafe enta gakiya gisho gidiya gisho yaa yeletethan Aarona koche gidida addeti ubbay hessa mo. He yarshuwa, geeshshi gidonna oonika bochofo. ");
INSERT INTO gofl_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Goday Museko haysada yaagis; ");
INSERT INTO gofl_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","Aaroninne iya adde nayti kahinetethan tiyetiya wode issi kilo giraame gidiya lo77o dhiille katha yarsho oothidi Godaas eho. Iyape baggaa wonta, baggaa omarsi yarsho. ");
INSERT INTO gofl_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","He dhiilley zaytera walaketidi loythi munuqetidi bashen uuketo; iya menthada yarsho bessan sawo tonku giya katha yarsho oothada Godaas yarsha. ");
INSERT INTO gofl_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Qassi Aarona adde naytape iya kahinetetha laattanaw tiyetiya oonika he wogaa giigisees. Hessi Godaas ubba wode yarshetiya yarsho gidiya gisho kumethi xuugeto. ");
INSERT INTO gofl_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Kahiney katha yarshuwa guye ashshona xuugganaw koshshees; I meetetanaw bessenna. ");
INSERT INTO gofl_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Goday Museko haysada yaagis; ");
INSERT INTO gofl_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","Aaronasinne iya adde naytas haysada yaaga; “Nagara yarsho wogay haysa; nagaras shuketiya yarshoy xuussa yarshoy shuketiya bessan Godaa sinthan shuketto. He yarshoy ubbaafe geeshsha yarsho. ");
INSERT INTO gofl_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","He yarshuwa yarshiya kahiney Dunkaaniya dabaaban de7iya geeshsha bessan mo. ");
INSERT INTO gofl_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","He ashuwa bochiya oonika geeshshi gido; qassi shukishin suuthi ma7uwa bochiko he ma7oy geeshsha bessan meeceto. ");
INSERT INTO gofl_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Ashoy kaxida otoy meqo; birata disten kaxidaba gidiko he miishiya qaacidi haathan meeccanaw koshshees. ");
INSERT INTO gofl_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Kahine kochaafe adde gidida oonika he ashuwa mo; he yarshoy ubbaafe geeshshi. ");
INSERT INTO gofl_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Shin Geeshsha bessan nagara atotethas suuthaa ekidi Dunkaaniya giddo gelidaba gidiko he mehiya ashoy meetetanaw koshshenna; I taman xuugetanaw bessees.” ");
INSERT INTO gofl_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Ubbaafe geeshshi gidiya gisho naaqo yarsho wogay haysa; ");
INSERT INTO gofl_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Xuussa yarsho mehey shuketiya bessan naaqo yarsho mehey shuketto; iya suuthay yarsho bessa oyddu baggan wurxeto. ");
INSERT INTO gofl_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Iya modhuwa ubbaa, hessika goynaape bidi zoko meqethaa gakanaw de7iya modhuwa, ulo ashuwa kammida moodhiya, ");
INSERT INTO gofl_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","nam7u kilahota, enta kammida moodhiyanne tiriya xeera baggaa ekidi yarsho. ");
INSERT INTO gofl_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Kahiney haysata taman xuussa yarsho oothidi Godaas yarsho; hessi naaqo yarsho. ");
INSERT INTO gofl_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Kahine yara gidida adde ubbay he yarsho ashuwa mo. He yarshoy ubbaafe geeshshi gidiya gisho geeshsha bessan meeteto. ");
INSERT INTO gofl_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Naaqo yarshuwanne nagara yarshuwa wogay issinno. He mehiya ashoy nagara atotethas yarshida kahiniyas imetees. ");
INSERT INTO gofl_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Oonika xuussa yarsho mehe ehin ekidi yarshiya kahiney he mehiya galba baw eko. ");
INSERT INTO gofl_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Coocen kompetida woyko oton kaxida woyko bashen uuketida ubbay he yarshuwa yarshida kahiniyas imetees. ");
INSERT INTO gofl_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Qassi zaytera munuqetida woyko munuqetonna katha yarsho ubbay Aarona adde nayta ubbaas issi gina shaaketidi imetees. ");
INSERT INTO gofl_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Issi asi issifetetha yarsho Godaas yarshiya wode iyaw de7iya wogay haysa; ");
INSERT INTO gofl_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","I yarshey galata yarsho gidiko he yarshuwara issife zaytera munuqida uythu, irshoy gelonna uuketidi zayten tiyetida lee7o uythunne lo77o dhiillefe zaytera munuqetida uythu shiisho. ");
INSERT INTO gofl_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","He issifetetha yarshuwara issife irshora uuketida uythaa imota oothidi yarsho. ");
INSERT INTO gofl_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","He issi issi uythaafe issuwa denthidi Godaas yarsho oothidi eho. Hessi issifetetha yarshuwa suuthaa wurxida kahiniyas imeto. ");
INSERT INTO gofl_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","He mehiya ashoy he gallas meeteto; wontas aybika attofo. ");
INSERT INTO gofl_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Shin iya yarshoy gaso yarsho woyko dosa yarsho gidiko he ashoy he yarshetida gallas meeteto; iyape attey de7iko wontetha gallas meeteto. ");
INSERT INTO gofl_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","He ashuwape palahidi heedzantho gallas gakanaw gam7iko hessi taman xuugeto. ");
INSERT INTO gofl_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Issi asi shiishida issifetetha yarsho ashoy heedzantho gallasan meetetiko iya yarshoy eketenna; yarshoy yarshetidada taybetenna. He yarshoy tuna; iyape mida oonika ba nagaran oyshetees. ");
INSERT INTO gofl_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Tunabaa bochida ashoy meetetofo; I taman xuugetanaw koshshees. Hara ashuwa wogan tuna gidonna asi oonika maana giiko mo. ");
INSERT INTO gofl_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Shin issi asi tuna gidi uttidi, Godaas shiiqida issifetetha yarsho ashuwape miyaba gidiko, he uray asaa giddofe kuretto. ");
INSERT INTO gofl_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Issi asi tunaba bochiko, asa tunatethi gidin woyko tuna mehe gidin woyko hara ixetiya tunaba bochidi, Godaas yarshetida issifetetha yarsho ashuwape miiko, he uray ba asaa giddofe kureto. ");
INSERT INTO gofl_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Goday Museko haysada yaagis; ");
INSERT INTO gofl_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","Isra7eele asaas haysada yaagada oda; korma woyko maraze woyko kole modho ashuwa moopite. ");
INSERT INTO gofl_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Hayqida mehe woyko do7i wodhida mehiya modhuwa harabas go7etitepe attishin, iyape aybaka moopite. ");
INSERT INTO gofl_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Godaas taman xuussa yarshos shiiqiya mehiya modho ashuwa miya oonika ba asaa giddofe kuretto. ");
INSERT INTO gofl_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Hinte de7iya bessan awun gidikoka, kafo suuthi woyko mehe suuthi moopite. ");
INSERT INTO gofl_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Suuthi miya oonika ba asaa giddofe kuretto. ");
INSERT INTO gofl_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Goday Museko haysada yaagis; ");
INSERT INTO gofl_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","Isra7eele asaas haysada yaagada oda; Godaas issifetetha yarsho shiishiya oonika he issifetetha yarshuwafe shaakidi ba imota oothidi Godaas dummayidi yarsho. ");
INSERT INTO gofl_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Hessa I Godaas taman xuussa yarsho oothidi, ba kushen ekidi eho. Qassi modhuwa angaasuwara gathi ehidi yuusho yarsho oothidi Godaa sinthan yarsho. ");
INSERT INTO gofl_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Kahiney yarsho bessan modhuwa xuuggo; shin angaasoy Aaronasinne iya adde naytas imeto. ");
INSERT INTO gofl_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Hinte issifetetha yarshuwafe ushacha gedaa imota oothidi kahiniyas immite. ");
INSERT INTO gofl_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","He ushacha geday issifetetha yarshuwa suuthaanne modhuwa yarshiya kahiniya gakiya gisho gido. ");
INSERT INTO gofl_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Taani Isra7eele asaa issifetetha yarshuwafe yuusho angaasuwan shiiqida gedaa Isra7eele asaape ekada, kahiniya Aaronasinne iya adde naytas gisho oothada immas. Hessi enta gakiya enta gisho gidiya gisho Isra7eele asay merinaw hessa entaw immishe daana. ");
INSERT INTO gofl_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Aaroninne iya adde nayti kahine gididi shuumetida gallas Godaas shiiqida xuussa yarshuwafe, hesika entaw gisho gididi imetis. ");
INSERT INTO gofl_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Goday enta kahinetethas tiyida gallas, hessa entaw immana mela Isra7eele asaa kiittis; hessi yaana yeletethan eqidi de7iya woga gidana. ");
INSERT INTO gofl_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Hiza xuussa yarshuwa, katha yarshuwa, nagara yarshuwa, naaqo yarshuwa, kahineti tiyetiya wode yarshetiya yarshuwanne issifetetha yarshuwa wogay haysa. ");
INSERT INTO gofl_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Isra7eele asay Siina mela biittan banta yarshuwa Godaas yarshana mela Goday kiitida gallas, Siina zuma bolla Goday Muse kiitida wogay haysa. ");
INSERT INTO gofl_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Goday Muses haysada yaagidi odis; ");
INSERT INTO gofl_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","Aaronanne iya adde nayta, entara issife kahinetetha ma7uwa, tiyo zaytiya, nagara yarshuwa shuketiya kormaa, nam7u marazetanne, irshoy geliboonna uuketida uythaa wothiya gayta ekada ya. ");
INSERT INTO gofl_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Qassi Isra7eele asa ubbaa xeegada Dunkaaniya penge shiisha. ");
INSERT INTO gofl_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Musey Goday kiitidaysada oothis; asa ubbay dunkaaniya penge shiiqis. ");
INSERT INTO gofl_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Musey asaako, ta oothana mela Goday kiittidaysi haysa. ");
INSERT INTO gofl_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Musey Aaronanne iya adde nayta ehidi haathan meeccis. ");
INSERT INTO gofl_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Aarona ma7uwa mayzidi, danco dancisis; adussa ma7uwa mayzidi iya bolla efuude ma7uwa mayzis. Efuudiya alleeqisidi daddida saqiyan Aarona xeessara gathidi qachis. ");
INSERT INTO gofl_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Efuudiya bolla tira kiise sikidi iyan Uriimenne Tumiime wothis. ");
INSERT INTO gofl_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Aarona huuphen xaatha qace wothis. Goday Muse kiitidaysada xaatha qaciya sintha baggara Geeshsha worqa guche misiliya wothis. ");
INSERT INTO gofl_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Hessafe guye Musey tiyo zaytiya ekidi, Dunkaaniyanne Dunkaaniya giddon de7iya miishe ubbaa tiyidi dummayis. ");
INSERT INTO gofl_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","He zaytiyape ekidi yarsho bessa bolla laapun toho wurxis; iya miisheta, meecha keriyanne iya utuwa dummayanaw he zaytiyara tiyis. ");
INSERT INTO gofl_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","He tiyo zaytiyape guuthara ekidi Aarona huuphen tigidi iya dummayis. ");
INSERT INTO gofl_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Goday Muse kiittidaysada Musey Aarona adde nayta sinthe aathidi ma7o mayzidi danco dancisis. Enta huuphen xaatha qace wothis. ");
INSERT INTO gofl_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Musey nagara yarshos yarshetiya kormaa ehis; Aaroninne iya adde nayti he kormaa huuphen banta kushiya wothidosona. ");
INSERT INTO gofl_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Musey he kormaa shukidi iya suuthan ba biradhiya yeddi ekidi, yarsho bessan de7iya kaceta tiyidi yarsho bessa geeshshis. Attida suuthaa yarsho bessaafe garsan gussis; hessada oothidi yarsho bessa Xoossas dummayidi geeshshis. ");
INSERT INTO gofl_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Musey ulo ashuwa kammida modhuwa ubba, tiriya xeera baggaa, kilahotanne enta kammida modhuwa ekidi, yarsho bessan xuuggis. ");
INSERT INTO gofl_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Shin Goday Muse kiitidaysada korma galbaa, attida ashuwanne tociya gutaape gaxa kessidi xuuggis. ");
INSERT INTO gofl_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Hessafe guye, Musey xuussa yarshos maraze ehis; Aaroninne iya adde nayti he maraziya huuphen banta kushiya wothidosona. ");
INSERT INTO gofl_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Musey he maraziya shukis; iya suuthaa yarsho bessa oyddu maazaneta bolla wurxis. ");
INSERT INTO gofl_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Musey maraziya ashuwa qommon qommon qanxerethis; huuphiya, attida ashuwanne modhuwa xuuggis. ");
INSERT INTO gofl_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Goday Muse kiitidaysada ulo ashuwanne gedata meeccidi, kumetha dorsaa Godaas sawo tonku giya xuussa yarsho oothidi yarsho bessan xuuggis. ");
INSERT INTO gofl_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Kahineti shuumetiya wode shiiqiya nam7antho dorsaa Musey ehis; Aaroninne iya adde nayti he dorsaa huuphen banta kushiya wothidosona. ");
INSERT INTO gofl_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Musey he maraziya shukis; iya suuthaafe ekidi, Aaronas ushacha haythaa, ushacha kushiya wogga biradhiyanne, ushacha tohuwa wogga biradhiya tiyis. ");
INSERT INTO gofl_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Qassi Musey Aarona adde nayta sinthe aathidi, he suuthaafe ekidi, enta ushacha haythaa, ushacha kushiya wogga biradhiyanne ushacha tohuwa wogga biradhiya tiyis. Yaatidi, Musey attida suuthaa yarsho bessa oyddu maazaneta bolla wurxis. ");
INSERT INTO gofl_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Modhdhuwa, goynaape bidi zoko meqethaa gakanaw de7iya modhuwa, tiriya xeera baggaa, kilahotanne enta kammida modhuwanne ushacha gedaa ekis. ");
INSERT INTO gofl_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Godaa sinthan de7iya gaytape irshoy bayna uuketida issi uythaa, uuketidi zayten tiyetida issi uythaanne lee7on uuketida uythaa ekidi modhuwa bollanne ushacha gedaa bolla wothis. ");
INSERT INTO gofl_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","I he katha ubbaa Aarona kusheninne iya adde nayta kushen wothin, Godaa sinthan yuusho yarsho oothidi yarshidosona. ");
INSERT INTO gofl_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Musey he kathaa enta kushepe ekidi, xuussa yarshuwara gathidi, kahineta shuumiya wode Godaas sawo tonku giya yarsho oothidi yarsho bessan xuuggis. ");
INSERT INTO gofl_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Qassi Musey angaasuwa ekidi, yuusho yarsho oothidi Godaa sinthan yarshis. Goday Muse kiitidaysada, kahineta shuumiya wode yarshetiya maraziya ashuwape hessi Muse gakiya gisho. ");
INSERT INTO gofl_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Musey tiyo zaytiyapenne yarsho bessan de7iya suuthaafe ekidi, Aarona bollanne iya ma7uwa bolla, iya adde nayta bollanne, enta ma7uwa bolla wurxis; Aaronanne iya ma7uwa, iya naytanne enta ma7uwa dummayis. ");
INSERT INTO gofl_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Musey Aaronanne iya adde naytako haysada yaagis; ashuwa Dunkaaniya pengen kathite; Aaroninne iya adde nayti ta kiitidaysada gaytan de7iya geeshsha uythaara miite. ");
INSERT INTO gofl_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","He ashuwapenne uythaafe palahiday de7iko taman xuuggite. ");
INSERT INTO gofl_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Kahineta shuumiya wogay laapun gallas ekiya gisho he wogay poletiya laapun gallasay wurana gakanaw Dunkaaniya pengefe kare keyopite. ");
INSERT INTO gofl_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Goday kiittin hachi poletida wogay hinte nagaraa quchanaasa. ");
INSERT INTO gofl_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Dunkaaniya pengen laapun gallas kumethi gallasinne qamma gam7ite; Godaa wogaa naagite; ixiko hinte hayqana. Tana Goday kiittiday haysa. ");
INSERT INTO gofl_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Aaroninne iya adde nayti Goday Muse baggara kiittidaba ubbaa oothidosona. ");
INSERT INTO gofl_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Hospuntha gallas Musey Aarona, iya adde naytanne Isra7eele cimata xeegis. ");
INSERT INTO gofl_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Aaronako haysada yaagis; borey bayna issi korma nagaraa yarshos, qassi issi maraze xuussa yarshos Godaa sinthe shiisha. ");
INSERT INTO gofl_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Borey bayna issi kole nagara yarshos, issi laythi kumida marinne dorsa urge xuussa yarshos bantaw ehana mela Isra7eele asaas oda. ");
INSERT INTO gofl_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Qassi issifetetha yarshos issi korma, issi marazenne katha yarshos zaytera munuqetida dhiille ehana mela entaw oda. Hachi Goday hintew qoncana gisho hessa oothite. ");
INSERT INTO gofl_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Enti Musey kiittidaba ubbaa Geeshsha Dunkaaniya sinthe ehidosona; maabara ubbay shiiqidi Godaa sinthan eqidosona. ");
INSERT INTO gofl_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Musey entako, Godaa bonchoy hintew qoncana mela hinte oothana mela Goday kiittiday haysa. ");
INSERT INTO gofl_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Musey Aaronako haysada yaagis; “Yarsho bessaako shiiqada ne nagaraa gisho nagara yarshonne xuussa yarsho yarsha. Goday kiitidaysada asaa nagaraa atotethas yarsho yarsha.” ");
INSERT INTO gofl_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Aaroni yarsho bessaako yidi, ba nagaraa gisho yarshetiya maraa shukis. ");
INSERT INTO gofl_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Aarona nayti suuthaa ekidi iyaw ehidosona; I, ba biradhiya he suuthan yeddi ekidi, yarsho bessan de7iya kaceta tiyis; attida suuthaa yarsho bessaafe garsan gussis. ");
INSERT INTO gofl_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Goday Muse kiitidaysada, ashuwape modhuwa, kilahotanne tiriya xeera baggaa ekidi yarsho bessan xuuggis. ");
INSERT INTO gofl_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Shin attida ashuwanne galbaa gutaape kare kessidi xuuggis. ");
INSERT INTO gofl_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Aaroni xuussa yarshos shiiqida mehiya shukis; iya nayti suuthaa ekidi iyaw ehidosona. I yarsho bessa oyddu maazaneta bolla wurxis. ");
INSERT INTO gofl_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Enti ashuwa qommon qommon kessidi, huuphiyara wolla iyaw ehidosona; I ekidi yarsho bessan xuuggis. ");
INSERT INTO gofl_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Ulo ashuwanne gedata haathan meeccidi, yarsho bessan de7iya xuussa yarshuwa bolla wothidi xuuggis. ");
INSERT INTO gofl_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Hessafe guye, Aaroni asaa gisho yarsho yarshis. I asaa nagaraa gisho yarshetiya koliya ekidi shukis; I kase ba nagaraa yarshidaysada enta nagaraa gisho yarshis. ");
INSERT INTO gofl_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Wogay kiiteysada xuussa yarshos shiiqiya mehiya ehidi yarshis. ");
INSERT INTO gofl_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Katha yarshuwa ehidi, iyape issi kuuca ekidi, wonta wonta xuussa yarshuwa bolla gujidi yarsho bessan xuuggis. ");
INSERT INTO gofl_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Aaroni kormanne maraziya asaas issifetetha yarsho oothidi shukis; iya adde nayti suuthaa iyaw ehidosona; I he suuthaa ekidi yarsho bessa oyddu maazaneta bolla wurxis. ");
INSERT INTO gofl_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Kormanne maraziya ashuwape modhuwa, goynaape bidi zoko meqethaa gakanaw de7iya modhuwa, ulo ashuwa kammida modhuwa, kilahotanne tiriya xeera baggaa ekidi, ");
INSERT INTO gofl_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","enti angaaysuwa bolla wothin, Aaroni yarsho bessan xuuggis. ");
INSERT INTO gofl_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Goday Muse kiitidaysada, Aaroni angaaysuwanne ushacha gedaa yuusho yarsho oothidi Godaa sinthan yuushshis. ");
INSERT INTO gofl_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Hessafe guye, Aaroni ba kushiya asaako denthidi enta anjis. I nagara yarshuwa, xuussa yarshuwanne issifetetha yarshuwa yarshidaape guye yarsho bessaafe wodhis. ");
INSERT INTO gofl_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Museynne Aaroni Geeshsha Dunkaaniya giddo gelidosona; enti yaape keyidi asaa anjidosona. He wode Godaa bonchoy asa ubbaas qoncis. ");
INSERT INTO gofl_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Godaa matape tami wodhidi, yarsho bessan de7iya xuussa yarshuwanne modhuwa mis. Asa ubbay hessa be7ida wode ililidosona; gufannidi bonchidosona. ");
INSERT INTO gofl_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Aarona adde nayti, Naadabinne Abyoodi, banta ixaane cuyisiya miishe ekidi iya bolla tama wothidosona; iya bolla ixaane gujidosona. Goday enta kiittiboona coo tama Godaa sinthan shiishidosona. ");
INSERT INTO gofl_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Hessa gaason Godaa matape tami yidi enta min, enti Godaa sinthan hayqidosona. ");
INSERT INTO gofl_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Musey Aaronako, Goday, “Taani asaa giddofe taako shiiqeyisata, ta geeshshatetha bessaana. Qassi asa ubbaa sinthan ta bonchetana” gidi odidaysa haysa be7a. Aaroni zaaro immonna si77i gis. ");
INSERT INTO gofl_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Musey Aarona aawa ishaa Uzi7eela adde nayta Misa7eelanne Elzafaana xeegidi, “Haa yidi hinte aawa ishaa nayta aha Geeshsha Dunkaaniya sinthafe denthidi, gutaape gaxa kessite” yaagis. ");
INSERT INTO gofl_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Enti yidi, Musey kiitidaysada enta kahinetetha ma7uwara enta aha tookidi, gutaape gaxa kessidosona. ");
INSERT INTO gofl_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Musey Aaronanne iya adde nayta, Alaazaranne Itamaara haysada yaagis; “Hinte hayqonna melanne Goday ba asaa bolla hanqetonna mela hinte huuphiya meedopite; hinte ma7uwaka daakofite. Shin hinte ishati, Isra7eele asay, Goday ba taman wodhidaysatas yeeko. ");
INSERT INTO gofl_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Godaa tiyo zaytey hinte bolla di7iya gisho Dunkaaniya pengefe kare keyopite; keyiko hinte hayqana” yaagis. Enti Musey gidaysada oothidosona. ");
INSERT INTO gofl_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Goday Aaronako haysada yaagis; ");
INSERT INTO gofl_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","Hinte hayqonna mela Dunkaaniya gido geliya wode nenne ne nayti woyne ushshi woyko hara mathoyiya ushshi uyopite; hessi sinthafe yaana yeletethaas merinaw eqidi de7iya woga gidana. ");
INSERT INTO gofl_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Hinte geeshshabanne geeshshi gidonaba qassi tunabaanne tuna gidonaba shaakidi erite. ");
INSERT INTO gofl_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Goday Muse baggara odida woga ubbaa Isra7eele asaa tamaarsite. ");
INSERT INTO gofl_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Musey Aaronanne attida iya adde nayta Alaazaranne Itamaara haysada yaagis; Godaas xuussa yarshuwafe attida katha yarshuwa ekidi irsho yeggonna uukite. I ubbaafe geeshshi gidiya gisho yarsho bessaa matan miite. ");
INSERT INTO gofl_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Godaas xuussa yarshuwafe hessi nenanne ne adde nayta gakiya gisho gidiya gisho, hessa hinte geeshsha bessan miite; Haysa hinte oothana mela Goday tana kiittis. ");
INSERT INTO gofl_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Shin yuusho yarshos shiiqida angaaysuwanne gedaa neeni, ne adde naytinne ne macca nayti geeshsha bessan miite. Hessi Isra7eele asay shiishiya issifetetha yarshuwafe nenanne ne adde nayta gakiya hinte gisho. ");
INSERT INTO gofl_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Godaas yarshida gedaanne yuusho yarshos shiiqida angaasuwa modhuwara issife gathidi Godaa sinthan yuusho yarsho oothidi yarshanaw shiiqo. Goday kiitidaysada, hessi newunne ne adde naytas merinaw hintena gakiya gisho gidana. ");
INSERT INTO gofl_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Musey nagara yarshos shiiqida deesha enti waatidaako eranaw koyidi oychis; I xuugetidaysa erida wode attida Aarona adde nayta, Alaazaranne Itamaara bolla hanqetis. ");
INSERT INTO gofl_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“Nagaraa yarshos shiiqida ashuwa ayis geeshsha bessan mibeeketii? I ubbaafe geeshshi. Godaa sinthan asaa nagaraa diggidi asaas atotethi immana mela hessi hintew imetis. ");
INSERT INTO gofl_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","He mehiya suuthay geeshsha Dunkaaniya giddo geliboonna gisho, taani hintena kiitidaysada, hinte iya geeshsha bessan maanaw bessees, shin aggideta” yaagis. ");
INSERT INTO gofl_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Aaroni Museko, “Heko, ha asati hachi banta nagaraa yarshuwanne xuussa yarshuwa Godaa sinthe ehidosona. Gidoshin, hessa melabay ta bolla gakis. Taani nagaraa yarshuwa hachi midaba gidiyako, Goday ufaytanashin attidee?” yaagis. ");
INSERT INTO gofl_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Musey hessa si7ida wode iya zaaruwan ufaytis. ");
INSERT INTO gofl_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Goday Musekonne Aaronako, ");
INSERT INTO gofl_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","Isra7eele asaas haysada yaagidi odite; “Biitta bolla de7iya mehetapenne do7atape hinte maanaysati haysata; ");
INSERT INTO gofl_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Shuquley phalqetidaysatanne waammotiya meheta miite. ");
INSERT INTO gofl_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Shin waammotishe shuquley phalqetonaysatanne shuquley phalqethi gididi waammotonayisata moopite. Gimaley waammotees, shin shuquley phalqetonna gisho, hintew tuna gido. ");
INSERT INTO gofl_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Gupalley waammotees, shin shuquley phalqetonna gisho, hintew tuna gido. ");
INSERT INTO gofl_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Eshey waammotees, shin shuquley phalqethi gidonna gisho, hintew tuna gido. ");
INSERT INTO gofl_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Guduntho moopite; iyaw shuquley phalqethi, shin waammotonna gisho, I hintew tuna. ");
INSERT INTO gofl_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Hinte hessata moopite; enta bawuta bochofite; enti hintew tuna. ");
INSERT INTO gofl_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“Haatha giddon de7iya medhetetha ubbaafe hinte maanaysati haysata; Abbaa giddon woyko shaafa haatha giddon de7iya ubbaafe qefeynne poqoy de7iya ubbaa miite. ");
INSERT INTO gofl_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Shin abba giddon woyko goggiya haathan de7iya qefeynne poqoy bayna medhetethati hintew tuna gidiya gisho moopite. ");
INSERT INTO gofl_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Haysati hintew tuna; enta moopite; enta bawuta bochofite. ");
INSERT INTO gofl_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Qefeynne poqoy bayna haatha giddon de7iya medhetethati ubbay hintew tuna. ");
INSERT INTO gofl_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“Kafotape hintew tuna gididaysatinne hinte maanaw bessonnaysati haysata; arganthi, anko, molo kafo, ");
INSERT INTO gofl_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","xilo, phirco qommo ubbaa, ");
INSERT INTO gofl_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","quuro ubbaa ");
INSERT INTO gofl_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","yancho, solo, qoolle, gutto ubbaa, ");
INSERT INTO gofl_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","guutha gutto, hazazo, diidinthe, ");
INSERT INTO gofl_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","haatha kutto, shi7a anko, daare anko, ");
INSERT INTO gofl_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","silaago, saabisanne iya qommo ubba, ayyaana kafonne shirshiqo. ");
INSERT INTO gofl_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“Qefera de7iya oyddu tohon hemetiya laafa medhetethati ubbay hintew tuna. ");
INSERT INTO gofl_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Gidoshin, qefey de7iya oyddu tohon hemeteysatape enta tohuwape bollara gupanaw maaddiya tohoy de7eyisata miite. ");
INSERT INTO gofl_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Hessatika, boole qommo ubbaa, xaqo ubbaanne sere ubbaa. ");
INSERT INTO gofl_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Shin hara qefera de7iya oyddu tohoy de7iya medhetethati ubbay hintew tuna. ");
INSERT INTO gofl_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","“Haysati hintena tunisana; enta bawuta bochiya oonika omarsi gakanaw tuna gidana. ");
INSERT INTO gofl_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Enta bawuta denthiya oonika ba ma7uwa meecco; shin omarsi gakanaw I tuna gido. ");
INSERT INTO gofl_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Shuquley de7ishe phalqethi gidonnaysati woyko waammotonnaysati ubbay hintew tuna; enta bochiya oonika tunees. ");
INSERT INTO gofl_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Oyddu tohotan hemetiya do7a ubbaafe gindera hemeteysati hintew tuna; enta bawuta bochiya oonika omarsi gakanaw tunees. ");
INSERT INTO gofl_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Enta bawuta denthiya oonika ba ma7uwa meecco; shin omarsi gakanaw I tuna. Entika hintew tuna. ");
INSERT INTO gofl_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“Sa7ara hemeteysatape haysati hintew tuna. Entika giro, ecere, dumma dumma koche, ");
INSERT INTO gofl_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","geegge, haylasho, korche, wakallanne shaaqancho. ");
INSERT INTO gofl_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Sa7ara hemetiya ubbaafe haysati hintew tuna; enta bawuta bochiya oonika omarsi gakanaw tuna gidees. ");
INSERT INTO gofl_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Enta bawuta bochiya ay miisheyka tuna gidees; mitha miishey woyko ma7oy woyko galbi woyko ogoroy tuna gidees. Enta bawutay bochida miishe ubbay haathan muuketidi omarsi gakanaw gam7o; hessafe guye geeshshi gidana. ");
INSERT INTO gofl_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Entafe issuwa bawutay oto giddon wodhidi bentiko, iya giddon de7iyaba ubbay tuna; he otuwa menthite. ");
INSERT INTO gofl_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Ay kathi gidin he otuwa giddon de7iya haathaafe xokiko, he kathay tuna gidees; uyetiyaba gidin, he otuwa giddon de7iko tuna gidees. ");
INSERT INTO gofl_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","He bawutape issoy wodhida miishe ubbay tuna; cooce woyko oto gidikoka menthite; enti hintew tuna. ");
INSERT INTO gofl_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","He bawutay bochida ubbay tuna gidikoka pultoynne haatha olli tunenna. ");
INSERT INTO gofl_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Enta bawutape issoy zeretha katha bolla wodhiko, hessi tunenna. ");
INSERT INTO gofl_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Shin he zerethaa bolla haathi gukidi simmin, enta bawutape issoy iya bolla wodhiko, he zerethay hintew tuna. ");
INSERT INTO gofl_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“Meetetiya mehetape issoy bawutiko, iya bawuta bochiya oonika omarsi gakanaw tuna. ");
INSERT INTO gofl_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Oonika he mehiya bawutape miiko, ba ma7uwa meecco; omarsi gakanaw I tuna. Oonika iya bawuta tookidi denthiko, ba ma7uwa meecco; omarsi gakanaw I tuna. ");
INSERT INTO gofl_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“Sa7ara gooshetiya medhetethi ubbay hintew tuna; iya moopite. ");
INSERT INTO gofl_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Ulora gooshetiyaba gidin, oyddu tohora hemetiyaba gidin, daro tohoy de7iyaba gidin, sa7ara gooshetiya medhetethi ubbay hintew tuna gidiya gisho moopite. ");
INSERT INTO gofl_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Ha sa7ara gooshetiya medhetethatan hintena tunisopite; enta gaason hinte asatethaa tunisopite. ");
INSERT INTO gofl_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Taani Godaa, hinte Xoossaa. Taani geeshshi gidiya gisho, hintena dummayidi geeshshi gidite. Sa7ara gooshetiyabatan hinte asatethaa tunisopite. ");
INSERT INTO gofl_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Taani hintew Xoosse gidanaw hintena Gibxe biittafe kessida hinte Godaa. Hesaa gisho, taani geeshshi gidiya gisho, hinteka geeshshi gidite. ");
INSERT INTO gofl_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","“Mehe, kafo, haatha giddon qaaxiya medhetethi ubbaanne sa7ara hemetiya medhetetha ubbaa wogay haysa. ");
INSERT INTO gofl_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Hessan hinte tunanne tuna gidonnayisata giddon, qassi meetetiyanne meetetonna medhetethata giddon de7iya dummatethaa shaakidi erana.” ");
INSERT INTO gofl_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Goday Museko haysada yaagis; ");
INSERT INTO gofl_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","Isra7eele asaas haysada yaagada oda; “Issi maccasi qanthatada adde na7a yeliko, ba kushe metuwa be7iya wode tuna gideysada laapun gallas gakanaw tuna gidana. ");
INSERT INTO gofl_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Hospuntha gallas na7ay qaxaretanaw koshshees. ");
INSERT INTO gofl_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Hessafe guye, maccasiya ba yelo suuthay xiz7ana gakanaw hastamanne heedzu gallas gam7o; qassi ba geeyiya gallasay wurana gakanaw geeshshaba bochofo; Geeshsha Dunkaaniyaka gelopo. ");
INSERT INTO gofl_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","“Shin issi maccasi macca na7a yeliko, ba kushe meto be7ida wode iya tuna gididaysada nam7u saaminta gakanaw iya tuna gidana. Hessafe guye, ba yelo suuthay xiz7ana gakanaw usupun tammanne usupun gallas gam7o. ");
INSERT INTO gofl_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“Maccasiya adde na7a woyko macca na7a yelada ba geeyiya wodiya ongidaape guye, xuussa yarshos issi laytha dorsenne nagara yarshos qassi issi holle woyko issi kuraacho Geeshsha Dunkaaniya pengen de7iya kahiniyako eho. ");
INSERT INTO gofl_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Kahiney hessa ekidi Godaa sinthan I nagaraa atotethas yarshees. Hessafe guye, iya geeyana. Adde na7a woyko macca na7a yeliya maccasas de7iya wogay haysa. ");
INSERT INTO gofl_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","“Shin iya issi laytha dorse ehanaw danda7onna ixiko, nam7u holleta woyko nam7u kuraachota eho. Entafe issoy xuussa yarshos, qassi issoy nagara yarshos gido. Hessada oothidi kahiney I nagaraa atotethas yarshees; iyaka geeshshi gidana.” ");
INSERT INTO gofl_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Goday Musekonne Aaronako haysada yaagis; ");
INSERT INTO gofl_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“Issi asa asatethaa bolla kixi wodhiko woyko shattoy woyko iralley keyiko iya gogay hargen laametiko, he uraa kahiniya Aaronako woyko kahine gidida iya adde naytape issuwako eho. ");
INSERT INTO gofl_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Kahiney iya goga bolla de7iya madunthaa be7o. He madunxida bessan de7iya ikisey booxikonne madunthay ollatiko, hessi goga harge. Kahiney hessa be7idi uray tuna gideysa eriso. ");
INSERT INTO gofl_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Shin iya gogaa bolla de7iya madunthay boothi gididi, gogaape kanthidi ollatiboonaba gidiko he madunthaa bolla de7iya ikisey booxonnaba gidiko, kahiney he uraa dumma keethan laapun gallas gordidi wotho. ");
INSERT INTO gofl_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Laapuntha gallas kahiney iya zaaridi be7o; I be7iya wode madunthay uraa gogaa bolla dalgonna kaseysda de7iko, kahiney he uraa nam7antho dumma keethan laapun gallas gordidi wotho. ");
INSERT INTO gofl_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Qassika laapuntha gallas kahiney iya be7o; I be7iya wode madunthay dalgonna ixidi dhayi dhayi biiko, kahiney I tuna gideysa eriso. Hessi goo7o gideysa eriso; he uray ba ma7uwa meeccidi tuna gidonaysa erisees. ");
INSERT INTO gofl_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Shin I geeyanaw bana kahiniya bessidaape guye, he goo7oy iya gogaa bolla dalgi dalgi biiko I zaaridi bana bessanaw kahiniyako boo. ");
INSERT INTO gofl_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Kahiney iya be7o; he goo7oy uraa gogaa bolla dalgi dalgi biiko, hessi goga harge gidiya gisho kahiney I tuna gideysa eriso. ");
INSERT INTO gofl_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“Oonika goga hargen oyketiko iya kahiniyako eho. ");
INSERT INTO gofl_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Kahiney iya be7iya wode iya gogaa bolla bootha kixi de7iko, ikisey boothi laammikonne he kixa giddon ashoy bentiko, ");
INSERT INTO gofl_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","hessi gogaa bolla gam7ida harge gidiya gisho, kahiney I tuna gideysa eriso. I tuna gideysi eretida gisho, iya dumma keethan gordidi wothanaw koshshenna. ");
INSERT INTO gofl_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Kahiney goga hargey addiya asatethaa bolla dalgiko, huuphepe toho gakanaw ubbaa ma77idaba gidiko be7o. ");
INSERT INTO gofl_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","He goga hargey iya asatethaa ubbaa ma7iko, iya asatethay kumethi laametidi boothi gidida gisho, I tuna gidonaysa kahiney eriso. ");
INSERT INTO gofl_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Shin he maduntha giddora ashoy bentiko I tuna. ");
INSERT INTO gofl_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Kahiney he ashuwa be7idi he uray tuna gideysa eriso. He ashoy goga harge gidiya gisho I tuna. ");
INSERT INTO gofl_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Shin he ashoy qassika laametidi booxiko, he uray kahiniyako bo. ");
INSERT INTO gofl_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Kahiney iya be7o; iya madunthay booxidaba gidiko, he uray tuna gidonaysa kahiney eriso; I tuna gidana. ");
INSERT INTO gofl_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“Issi asa bolla merkoy wodhidi paxidaba gidiko, ");
INSERT INTO gofl_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","iya bessan bootha kixay wodhiko woyko zo77ida iralley keyiko he uray kahiniyako bo. ");
INSERT INTO gofl_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Kahiney iya be7o; he madunthay ollatiko, madunthaa bolla de7iya ikisey laametidi booxiko, he uray tuna gideysa kahiney eriso. Hessi merkoda doomida goga harge. ");
INSERT INTO gofl_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Shin kahiney be7iya wode ikisey booxonnaba gidiko, madunthay gogaa kanthidi ollatiboonaba gidiko, qassi dhayi dhayi biiko, kahiney iya dumma keethan laapun gallas gordidi wotho. ");
INSERT INTO gofl_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Hessi iya gogaa bolla dalgi dalgi biiko, hessi goga harge gidiya gisho he uray tuna gideysa kahiney eriso. ");
INSERT INTO gofl_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Shin he iralley dalgi dalgi boonna issi bessan de7iko, hessi merkoy paxida beeta gidiya gisho, he uray tuna gidonaysa eriso. ");
INSERT INTO gofl_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“Tami issi asi miiko he mida bessan bootha woyko zo7o iralley keyiko, ");
INSERT INTO gofl_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","kahiney he bessa be7o. He bessan de7iya ikisey booxikonne he madunthay ollatiko, hessi goga harge. I tamay mida bessaara keyida gisho kahiney I tuna gideysa eriso. ");
INSERT INTO gofl_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Shin kahiney be7iya wode he madunthaa bolla de7iya ikisey booxonnaba gidiko, madunthay gogaa kanthidi ollatiboonaba gidikonne qassi dhayi dhayi bidaba gidiko, kahiney iya dumma keethan laapun gallas gordidi wotho. ");
INSERT INTO gofl_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Laapuntha gallas kahiney iya be7iya wode he bessay dalgi dalgi biiko, hessi goga harge gidiya gisho I tuna gideysa kahiney eriso. ");
INSERT INTO gofl_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Shin he madunthay gogaa bolla dalgonna aggidi issi bessan uttikonne dhayi dhayi biiko, hessi tamay mida bessan attida beeta gidiya gisho, I tuna gidonaysa kahiney eriso. ");
INSERT INTO gofl_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“Issi addey woyko maccasa huuphen woyko gaco bolla madunthi keyiko, ");
INSERT INTO gofl_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","kahiney he madunthaa be7iya wode madunthay gogaa kanthidi ollatiko iya bolla de7iya ikisey lee7idi galal7o daaniko, hessi huuphen woyko gaco bolla keyiya qaachiya goga harge gidiya gisho, he uray tuna gideysa kahiney eriso. ");
INSERT INTO gofl_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Qassi kahiney he hargiya be7iya wode gogaa kanthidi ollatiboonaba gidiko, kareetha ikisey iya bolla dhayiko, he qaachiya hargey de7iya uraa kahiney dumma keethan laapun gallas gordidi wotho. ");
INSERT INTO gofl_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Laapuntha gallas kahiney he hargiya be7iya wode qaachiya hargey dalgonnaba gidiko, iya bolla galal7o daaniya ikisey baynaba gidikonne gogaa kanthidi ollatiboonaba gidiko, ");
INSERT INTO gofl_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","he ura qaachiya bessan de7iya ikisiya gidonashin, madunthaa yuushon de7iya ikisiya meedo. Kahiney he uraa dumma keethan hara laapun gallas gordidi wotho. ");
INSERT INTO gofl_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Laapuntha gallas kahiney he qaachiya bessaa be7iya wode uraa galbaa bolla dalgonna ixikonne gogaa kanthidi ollatonna ixiko, he uray tuna gidonaysa kahiney eriso. Uray ba ma7uwa meeccidi geeshshi gidana. ");
INSERT INTO gofl_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Shin I geeydaape guye, qaachiya hargey he uraa galba bolla dalgi dalgi biiko, ");
INSERT INTO gofl_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","kahiney iya be7iya wode he qaachiya hargey dalgidaba gidiko, he uray tunida gisho kahiney galal7o daaniya ikisiya koyopo. ");
INSERT INTO gofl_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Shin kahiney be7iya wode he qaachiya bessay dalgonnaba gidikonne kareetha ikisey iya bolla dolidaba gidiko, he qaachiya bessay paxis. He uray tuna gidonna gisho, I geeshshi gideysa kahiney eriso. ");
INSERT INTO gofl_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“Issi adde woyko maccasa goga bolla bootha iralley keyiko, ");
INSERT INTO gofl_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","kahiney be7iya wode enta gogaa bolla de7iya iralley bulla gidiko, hessi gogaa bolla coo keydaba gidiya gisho he uray tuna gidenna. ");
INSERT INTO gofl_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“Issi asas huuphe binaanay qoqofetiko, bo77a gideesipe attishin, I tuna gidenna. ");
INSERT INTO gofl_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Issi asi sinthara bo77atiko, iya tiishshi misipe attishin, I tuna gidenna. ");
INSERT INTO gofl_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Shin iya bo77i woyko tiishshi midaysa bolla zo7o woyko bootha madunthi keyiko, hessi iya bo77an woyko iya tiishsha bolla keyida goga harge. ");
INSERT INTO gofl_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Iya kahiney be7iya wode iya bo77i woyko tiishshi midaysa bolla de7iya madunthay galba bolla keyiya goga harge mela zo7o gidiko, ");
INSERT INTO gofl_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","he uray tuma goga hargen oyketida hargancho. I tuna gidiya gishonne iya hargey iya huuphen de7iya gisho I tuna gideysa kahiney eriso. ");
INSERT INTO gofl_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“Goga hargey oykida asi peedhetida ma7o ma7o; ba huuphiya pixopo; ba doona kammo; ba qaala dhoqu oothidi, ‘Taani tuna, taani tuna!’ yaago. ");
INSERT INTO gofl_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","He hargey iya bolla de7ida wode ubban I tuna. I tuna gidiya gisho, asaape shaaketidi, gutaape karen barka de7o. ");
INSERT INTO gofl_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“Ay ma7o bolla buuqida bessi bentiko, he ma7oy suufe gidin woyko liino gidin, ");
INSERT INTO gofl_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","qacinape woyko shalope dadetida liino woyko suufe gidin, galba woyko galbafe oosetida ma7o gidin, ");
INSERT INTO gofl_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","he ma7uwa bolla bentida buuqay ciliilo woyko zo7o mala bessiko, I qacinape woyko shalope dadetidaba gidin, galba woyko galbafe oosetidaba gidin, hessi asape ase oykiya harge gidiya gisho, hessa kahiney bessanaw koshshees. ");
INSERT INTO gofl_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Kahiney he buuqa be7idi, he buuqida ma7uwa dumma keethan laapun gallas gordidi wotho. ");
INSERT INTO gofl_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Laapuntha gallas kahiney he ma7uwa be7iya wode he ma7uwa bolla de7iya buuqay dalgi dalgi biiko, I qacina woyko shalo gidin, galba woyko galbafe oosetida ma7o gidin, hessi issuwafe issuwa oykiya buuqa harge gidiya gisho he ma7oy tuna. ");
INSERT INTO gofl_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","He ma7oy qacina woyko shalo gidin, liino woyko suufe gidin, galbafe oosetidaba ayba gidin, kahiney iya xuuggo. Hessi issuwafe issuwa oykiya buuqa harge gidiya gisho, I xuugetanaw bessees. ");
INSERT INTO gofl_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“Shin kahiney be7iya wode he buuqa ma7uwa bolla dalgiboonaba gidiko, I qacina woyko shalo woyko galbafe oosetidaba ayba gidin, ");
INSERT INTO gofl_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","he buuqay de7iya ma7uwa meeccana mela kahiney kiitto. Hessafe guye, he ma7uwa dumma keethan hara laapun gallas gordidi wotho. ");
INSERT INTO gofl_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","He ma7oy meecetidaape guye qassika kahiney be7iya wode he buuqay ba malaa laammonnabaa gidikonne dalgi dalgi boonna ixikoka I tuna. He buuqa bessay ma7uwas guye baggara woyko sintha baggara de7ikoka he ma7oy taman xuugetanaw koshshees. ");
INSERT INTO gofl_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Shin he ma7uwa meecci simmin kahiney be7iya wode buuqay dhayi dhayi biiko, I galba gidin, qacina woyko shalo gidin, he buuqay de7iya bessaa kahiney daakidi kesso. ");
INSERT INTO gofl_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Hessafe guye, ma7uwa bolla simmidi keyiko, he ma7oy qacina woyko shalo gidin, galbafe oosetidaba gidin, hessi dalgi dalgi biiko he buuqay de7iya ma7oy taman xuugetanaw bessees. ");
INSERT INTO gofl_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Shin meecetida ma7oy qacina woyko shalo gidin, woyko galbafe oosetidaba ma7o gidin, buuqa malay dhayiko, he ma7oy nam7antho meeceto; Hessafe guye, I geeyees” yaagis. ");
INSERT INTO gofl_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Issi ma7oy suufe woyko liino gidin, qacina woyko shalo gidin, woyko galbafe oosetidaba gidin, he ma7uwa geeshshi woyko tuna yaagisanaw danda7iya wogay haysa. ");
INSERT INTO gofl_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Goday Museko haysada yaagis; ");
INSERT INTO gofl_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","Goga hargey oykida uray geeyiya gallas oothanaw koshshiya wogay haysa. He uraa kahiniyako ehanaw koshshees. ");
INSERT INTO gofl_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Kahiney gutaape gaxaa keyidi iya hargiya be7o. I be7iya wode goga hargey uraa asatethafe dhayidabaa gidiko, ");
INSERT INTO gofl_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","kahiney nam7u tuna gidonna kafota, ziga mitha qanxo, zo7o qacinanne hisoophe bonco he hargiyafe geeyiya uraa gisho ehana mela kiitto. ");
INSERT INTO gofl_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Hessafe guye, kahiney nam7u kafotape issuwa pultofe duuqidi keren qolida haatha bolla shukana mela kiitto. ");
INSERT INTO gofl_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Hanko kafuwa zo7o qacinaranne hisoophe boncora ekidi, keren de7iya pulto haatha bolla shukida kafuwa suuthan naaqo. ");
INSERT INTO gofl_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","He suuthaa, he goga hargiyafe geeyiya uraa bolla laapun toho wurxo; he uray tuna gidonaysa eriso; paxa de7iya kafuwa demba yeddo. ");
INSERT INTO gofl_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","He hargiyafe geeyiya uray ba ma7uwa meecco; ba asatethaa bolla de7iya ikise ubbaa meedeto; ba asatethaa meeceto. Hessafe guye, I geeyidi guta gelo, shin ba dunkaaniya giddo gelonna laapun gallas karen gam7o. ");
INSERT INTO gofl_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Laapuntha gallas ba huuphiya, buuchaa, deemuwanne ba asatethaa bolla de7iya hara ikise ubbaa meedeto; qassi ba ma7uwa meecco; ba asatethaka meeceto; Hessafe guye, I geeshshi gidana. ");
INSERT INTO gofl_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Hospuntha gallasan borey bayna nam7u urge dorsatanne issi laythi gidida issi macca dorse eho. Qassi katha yarshos zaytera munuqetida heedzu kilo giraame lo77o dhiillenne issi litiro zaytepe siko eho. ");
INSERT INTO gofl_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Iya geeshshiya kahiney uraanne I ehida yarshotara issife Geeshsha Dunkaaniya pengen Godaa sinthan shiisho. ");
INSERT INTO gofl_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Kahiney nam7u dorsa urgetape issuwa ekidi, issi litiros siko zaytera issife naaqo yarsho oothidi shiisho; he shiiqida yarshuwa yuusho yarsho oothidi Godaa sinthan shiisho. ");
INSERT INTO gofl_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Yaatidi, I he dorsa urgiya nagara yarshonne xuussa yarsho shukiya geeshsha bessan shuko. Nagara yarshuwa mela naaqo yarshoyka kahiniyas imetees; ika ubbaafe aadhida geeshshi. ");
INSERT INTO gofl_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Kahiney naaqo yarshuwa suuthaafe guuthi ekidi, he geeyiya uraas ushacha bagga haythaa, ushacha kushiya wogga biradhiyanne ushacha tohuwa wogga biradhiya tiyo. ");
INSERT INTO gofl_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Hessafe guye, kahiney zaytiyape guuthara ekidi, ba haddirsa kushiya qaaqan tigo. ");
INSERT INTO gofl_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","He haddirsa kushiya qaaqan de7iya zaytiya ba ushacha kushe biradhiya yeddi yeddi ekidi, Godaa sinthan laapun toho wurxo. ");
INSERT INTO gofl_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Yaatidi, ba kushiya qaaqan de7iya zaytiyape ekidi, geeyiya uraas ushacha haytha, ushacha kushiya wogga biradhiyanne ushacha tohuwa wogga biradhiya kase naaqo yarshuwa suuthaa tiyida bessan tiyo. ");
INSERT INTO gofl_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Qassi ba kushiya qaaqan attida zaytiya kahiney geeyiya uraa huuphen gusso; yaatidi Godaa sinthan he uraa nagaraa atto yaagiso. ");
INSERT INTO gofl_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Hessafe guye kahiney geeyiya uraa nagara atotethas shiiqida yarshuwa yarshees; kallidi qassi xuussa yarshos shiiqida mehiya shukees. ");
INSERT INTO gofl_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Kahiney xuussa yarshuwa katha yarshuwara issife yarsho bessan wothidi xuuggees; yaatidi uraa nagaraa atto yaagisees; he uray geeyees. ");
INSERT INTO gofl_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Shin uray hessa ubbaa ehanaw danda7onna manqo gidiko, Godaa sinthan iya nagaraa atotethas yuushshanaw naaqo yarshos issi dorsa urge eho. Katha yarshos zaytera munuqetida issi kilo giraame lo77o dhiillenne issi litiro zaytepe sikuwa eho. ");
INSERT INTO gofl_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","Baw danda7etida mela nam7u holle woyko nam7u kuraacho issuwa nagaraa yarshos, issuwa xuussa yarshos eho. ");
INSERT INTO gofl_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Hospuntha gallas ba tunatethaafe geeyiya uray Geeshsha Dunkaaniya pengen Godaa sinthe ehidi kahiniyas immo. ");
INSERT INTO gofl_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Kahiney naaqo yarshos yida dorsa urgiyanne zaytiya ekidi, yuusho yarsho oothidi Godaa sinthan yuushsho. ");
INSERT INTO gofl_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Naaqo yarshos yida dorsa urgiya shuko; He urgiya suuthaafe guuthara ekidi, ha geeyiya uraa ushacha haytha, ushacha kushiya wogga biradhiyanne ushacha tohuwa wogga biradhiya tiyo. ");
INSERT INTO gofl_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Kahiney zaytiyape guuthara ba haddirsa kushiya qaaqan tigo. ");
INSERT INTO gofl_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","Haddirsa kushiya qaaqan de7iya zaytiyape ushacha kushiya biradhiya yeddi ekidi, Godaa sinthan laapun toho wurxo. ");
INSERT INTO gofl_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Kahiney ba kushiya qaaqan de7iya zaytiyape guuthara ekidi, geeyiya uraas ushacha haytha, ushacha kushiya wogga biradhiyanne ushacha tohuwa wogga biradhiya kase naaqo yarsho suuthaa tiyida bessan tiyo. ");
INSERT INTO gofl_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Godaa sinthan uraa nagaraa atotethas kahiney ba kushen attida zaytiya geeyiya uraa huuphen tigo. ");
INSERT INTO gofl_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Hessafe guye, geeyiya uray baw danda7etidaysa mela holle woyko kuraacho eho. ");
INSERT INTO gofl_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","Issuwa nagara yarshos nam7anthuwa xuussa yarshos katha yarshuwara issife shiisho. Kahiney geeyiya uraa nagaraa Godaa sinthan iya nagaraa atto yaagiso. ");
INSERT INTO gofl_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Ba asatethaa bolla de7iya goga hargiyafe geeyanaw manqotethi diggida uraas de7iya wogay haysa. ");
INSERT INTO gofl_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Goday Musekonne Aaronako haysada yaagis; ");
INSERT INTO gofl_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“Taani hintew immiya Kanaane biitta hinte geliya wode he biittan de7iya hinte keethafe issuwan taani buuqa yeddiya wode, ");
INSERT INTO gofl_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","he uray kahiniyako bidi, ‘Ta keetha bolla buuqa daaniyabay de7ees’ yaagidi odo. ");
INSERT INTO gofl_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Kahiney soo gelidi buuqa qommuwa be7anaape kasetidi, son de7iyabay ubbay tuna geetetonna mela son de7iyaba ubbaa kare kessana mela kiitto; hessafe guye, kahiney be7anaw soo gelo. ");
INSERT INTO gofl_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","I gelidi be7iya wode buuqay godaa bolla ciliilo woyko zo7o malla bessikonne qassi godaa midi ollayidi giddo geliko, ");
INSERT INTO gofl_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","kahiney kare keyidi, keethaa laapun gallas gakanaw gordo. ");
INSERT INTO gofl_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Laapuntha gallasan kahiney he keethaa zaaridi xeelliya wode he buuqay keetha godaa bolla dalgiko, ");
INSERT INTO gofl_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","buuqay de7iya shucha ubbaa godaape shoddidi, katamaape gaxa kessidi tuna bessan yeggana mela kiitto. ");
INSERT INTO gofl_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Kaallidi godaa meeshida urqa soo baggara bookidi, yuushshi aathidi qoqofana mela ootho; yaatidi he urqa katamaape gaxan de7iya tuna bessan yeggo. ");
INSERT INTO gofl_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Hessafe guye, he shodetida shuchata bessan hara shuchata wotho; hara urqan keethaa meesho. ");
INSERT INTO gofl_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“Shuchay shodetin, urqay qoqofetin, hara urqa meeshi simmin, buuqay keethaa giddon zaari bentiko, ");
INSERT INTO gofl_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","kahiney hessa be7o. I be7iya wode buuqay he keethaa giddon dalgiko, hessi asape ase oykiya buuqa harge gidiya gisho he kathay tuna. ");
INSERT INTO gofl_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Hessa gisho, he keethaa, iya shuchaa, iya mithaanne I meeshetida urqa ubbaa laallidi katamaape gaxa efidi, tuna bessan yeggo. ");
INSERT INTO gofl_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","He keethay gordan gam7iya wode iya gido geliya oonika omarsi gakanaw tuna. ");
INSERT INTO gofl_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","He keethan aqiya woyko kathi miya uray ba ma7uwa meecco. ");
INSERT INTO gofl_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“Shin kahiney yidi xeelliya wode keethay meeshetidi simmin, zaaridi dalgonna ixiko, buuqay dhayida gisho, he keethay tuna gidonaysa kahiney eriso. ");
INSERT INTO gofl_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Keethaa geeshshanaw nam7u kafota, ziga mitha qanxo, zo7o qacinanne hisoophe bonco eho. ");
INSERT INTO gofl_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Kafotape issuwa pultofe duuqidi keren qolida haathan shuko. ");
INSERT INTO gofl_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Hessafe guye, zigaa, hisoophe boncuwa, zo7o qacinanne paxa de7iya kafuwa ekidi, keren de7iya shuketida kafuwa suuthaninne pulto haathan yeddi ekidi laapun toho he keethaa wurxo. ");
INSERT INTO gofl_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Yaatidi, kahiney he keethaa kafuwa suuthan, pulto haathan, paxa de7iya kafuwan, ziga mithan, hisoophe boncuwaninne zo7o qacinan geeshsho. ");
INSERT INTO gofl_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Paxa de7iya kafuwa katamaape gaxa yeddo. Hessada oothidi, keethaa geeshshiya wogaa polees; keethay geeshshi gidees. ");
INSERT INTO gofl_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","“Dumma dumma goga hargeesinne goo7o hargees imetida wogay haysa. ");
INSERT INTO gofl_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","Ma7o bolla woyko keetha bolla keyiya buuqa harge gidin, ");
INSERT INTO gofl_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","kixa gidin, merko gidin, iralle gidin, ");
INSERT INTO gofl_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","issibay tuna gideysanne tuna gidonnaysa erisiya wogay haysa.” ");
INSERT INTO gofl_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Goday Musekonne Aaronako haysada yaagis; ");
INSERT INTO gofl_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","Isra7eele asaas haysada yaagidi odite; “Issi asa asatethafe goggiyabay de7iko hessi tuna. ");
INSERT INTO gofl_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Goggiyabay de7iya uraa tuna oothiya wogay haysa; he goggiyabay aggin, aggonna ixin, he uraa tuna oothees. ");
INSERT INTO gofl_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","“Iya asatethafe goggiyabay de7iya uray zin7iya hiixaynne uttiya oyde ubbay tuna. ");
INSERT INTO gofl_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Iya hiixa bochiya oonika ba ma7uwa meecco; ba asatethaka meeceto; yaatidi omarsi gakanaw tuna gidees. ");
INSERT INTO gofl_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Goggiyabay de7iya uray uttidaba bolla uttiya oonika ba ma7uwa meecco; ba asatethaka meeceto; yaatidi omarsi gakanaw tuna gidees. ");
INSERT INTO gofl_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","“Goggiyabay de7iya uraa asatethaa bochiya oonika ba ma7uwa meecco; ba asatethaa meeceto; yaatidi omarsi gakanaw I tuna gidees. ");
INSERT INTO gofl_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","“Goggiyabay de7iya asi tuna gidonna asa bolla cutiko, he uray ba ma7uwa meecco; ba asatethaka meeceto; yaatidi omarsi gakanaw I tuna gidees. ");
INSERT INTO gofl_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","“Goggiyabay de7iya uray uttiya toga koori tuna. ");
INSERT INTO gofl_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Iyape garsara de7iyaba bochiya oonika omarsi gakanaw tuna gidees; qassi hessa tookiya oonika ba ma7uwa meecco; ba asatetha meeceto; yaatidi omarsi gakanaw I tuna gidees. ");
INSERT INTO gofl_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","“Goggiyabay de7iya asi ba kushiya meecetonna bochiya asi oonika ba ma7uwa meecco; ba asatethaa meeceto; yaatidi omarsi gakanaw tuna gidees. ");
INSERT INTO gofl_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","“Goggiyabay de7iya uray bochiya oto ubbaa menthite; mithafe oosetida miishe ubbay haathan meeceto. ");
INSERT INTO gofl_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“Goggiyabay de7iya asi he gogiyabape geeyida wodepe laapun gallas gam7o. Ba ma7uwa meecco; ba asatethaa pulto haathan meeceto; yaatidi I geeshshi gidees. ");
INSERT INTO gofl_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Hospuntha gallasan nam7u holleta woyko nam7u kuraachota ekidi, Geeshsha Dunkaaniya penge, Godaa sinthe ehidi kahiniyas immo. ");
INSERT INTO gofl_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Kahiney holletape issuwa nagara yarshos, issuwa qassi xuussa yarshos yarshees; yaatidi kahiney uraa asatethafe goggiyaba gisho Godaa sinthan iya nagaraa atto yaagisees. ");
INSERT INTO gofl_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“Issi addefe iya atunthay gukiko, ba kumetha asatethaka meeceto; yaatidi omarsi gakanaw I tuna gidees. ");
INSERT INTO gofl_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Atunthay bochida ma7o ubbay woyko galba ubbay haathan meeceto; yaatidi omarsi gakanaw tuna gidees. ");
INSERT INTO gofl_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Issi addey maccara aqin, iya atunthay gukiko, nam7ayka haathan meeceto; yaatidi omarsi gakanaw enti tuna gidoosona. ");
INSERT INTO gofl_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“Issi maccasi ba kushe meto be7iko, laapun gallas gakanaw iya tuna; iyo bochiya oonika omarsi gakanaw tuna. ");
INSERT INTO gofl_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","“Ba kushe meto wode iya zin7iya hiixaynne iya uttiya oydey ubbay tuna. ");
INSERT INTO gofl_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Iya zin7iya hiixa bochiya ubbay ba ma7uwa meecco; ba asatethaka meeceto; yaatidi omarsi gakanaw tuna gido. ");
INSERT INTO gofl_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Iya uttiyaba bochiya ubbay ba ma7uwa meecco; ba asatethaa meeceto; yaatidi omarsi gakanaw tuna gido. ");
INSERT INTO gofl_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Iya zin7iya hiixa gidin woyko iya uttiyaba bochiya oonika omarsi gakanaw tuna. ");
INSERT INTO gofl_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","“Issi maccasi kushe metora de7iya wode addey iira aqiko, he kushe metuwa I bochiko, laapun gallas gakanaw I tuna gidees; I zin7iya hiixa ubbay tuna gidees. ");
INSERT INTO gofl_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“Issi maccasi, ba kushe meto wodey aadhin, suuthi aggonna goggiko woyko kushe meto wodey ba qammafe aadhidi goggiko, kushe meto wode iya tuna gididaysada suuthay eqana gakanaw iya tuna gidawusu. ");
INSERT INTO gofl_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Suuthi iipe goggiya wode iya zin7iya hiixa ubbay, ba kushe meto be7iya wode iya zin7ida hiixa melanne iya uttiya oydiya mela tuna gidees. ");
INSERT INTO gofl_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","He tunidabata bochiya oonika tuna gidiya gisho I ba ma7uwa meecco; ba asatethaa meeceto; yaatidi omarsi gakanaw tuna gidees. ");
INSERT INTO gofl_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","“Iipe goggiya suuthay eqiko, iya he wodepe doomada laapun gallas gam7o; hessafe guye, iya geeshshi gidana. ");
INSERT INTO gofl_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Hospuntha gallas iya nam7u holleta woyko nam7u kuraachota ehada Geeshsha Dunkaaniya pengen kahiniyas immo. ");
INSERT INTO gofl_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Kahiney holletape issuwa nagaraa yarshos, issuwa xuussa yarshos yarsho. Yaatidi, kahiney iipe goggiya tunatethaa gisho Godaa sinthan I nagaraa atto yaagisees. ");
INSERT INTO gofl_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“Isra7eele asay banta giddon de7iya Geeshsha Dunkaaniya tunisidi, hayqonna mela neeni haysada oothada enti bantana tunisiyabape dummayidi daana mela naaga.” ");
INSERT INTO gofl_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Iya asatethafe goggiyabay de7iya asas, iya atunathay gukin tuniya addes, ");
INSERT INTO gofl_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","ba kushe meto gaason tuniya maccasas, adde gidin macca gidin goggiyabay de7iya asaasinne tunida maccara aqiya addes imetida wogay haysa. ");
INSERT INTO gofl_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Aarona adde nayti nam7ay Godaa sinthe shiiqidi hayqidaape guye, Goday Museko haysada yaagis: ");
INSERT INTO gofl_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Taani Taabotiya nagara atotetha kamaa bolla shaaran gidada qonciya gisho magarajuwafe guyen de7iya Ubbaafe Geeshsha Bessaa ba koyida wode gelidi hayqonna mela ne ishaa Aaronas oda. ");
INSERT INTO gofl_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Aaroni nagaraa yarshos issi wofaano, xuussa yarshos issi maraze ekidi Ubbaafe Geeshsha Bessaa gelo. ");
INSERT INTO gofl_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Aaroni liinope oosetida geeshsha adussa qamisenne garsara ma7etiya ma7o ma7o. Liinope oosetida danco danco; hessada ba huuphen liinope oosetida xaatha qace wotho. He ma7oti geeshshi gidiya gisho, ma7anape sinthe ba asatethaa meeceto. ");
INSERT INTO gofl_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Isra7eele maabaray nagara yarshos nam7u koleta, xuussa yarshos issi maraze Aaronas eho. ");
INSERT INTO gofl_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Aaroni ba nagarasinne ba soo asaa nagaraa atotethas issi wofaano yarsho. ");
INSERT INTO gofl_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Hessafe guye, nam7u koleta Geeshsha Dunkaaniya pengen Godaa sinthe eho. ");
INSERT INTO gofl_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","He nam7u deeshata ekidi issuwa Godaasa, issuwa qassi Azaazelasa gidi enta bolla saama yeggo. ");
INSERT INTO gofl_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Aaroni saaman Godaas gidida deesha ekidi nagara yarsho oothidi yarsho. ");
INSERT INTO gofl_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Shin saaman Azaazelas gidida deesha asa nagaraa atotethas mela biitta yeddanaw paxa de7ishin Godaas shiisho. ");
INSERT INTO gofl_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Aaroni ba nagarasinne ba soo asaa nagaraa atotethas issi wofaano nagaraa yarsho oothidi shiisho. Yaatidi ba nagaraa gisho he wofaanuwa shuko. ");
INSERT INTO gofl_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Godaa sinthan de7iya yarsho bessaafe ixaane cuyisiya miishen bonqo kunthidi, liiqidi gaacetida sawiya ixaane nam7u kuuca ekidi magarajuwa giddo gelo. ");
INSERT INTO gofl_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Godaa sinthan de7iya taman ixaane wotho. I hayqonna mela ixaaniya cuyay Taabotiya bolla de7iya nagara atotetha kamaa kammo. ");
INSERT INTO gofl_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Wofaanuwa suuthaafe guuthara ekidi, ba biradhiya yeddi ekidi atotetha kamaa sintha baggaa wurxo. Nagara atotetha kamaa sintha baggara de7iya bessaa laapun toho wurxo. ");
INSERT INTO gofl_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Hessafe guye, asaa nagaraa gisho gidiya deesha shukidi, iya suuthaa magarajuwa giddo ehidi, wofaanuwa suutha wurxidaysada nagara atotetha kamaanne Taabotiya sinthaa wurxo. ");
INSERT INTO gofl_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Ubbaafe Geeshsha Bessaa Isra7eele asaa tunatethafenne nagarape geeshshees. Enti tunabaa oothishin, enta giddon de7iya Geeshsha Dunkaaniya haysada oothidi geeshsho. ");
INSERT INTO gofl_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Aaroni Ubbaafe Geeshsha Bessaa gelidi, ba nagaraa, ba soo asaa nagaraanne kumetha Isra7eele asaa nagaraa atotethas yarshidi keyana gakanaw, oonika geeshsha Dunkaaniya giddon de7opo. ");
INSERT INTO gofl_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Hessafe guye, Godaa sinthan de7iya yarsho bessa keyidi iya geeshsho. Wofaanuwa suuthaafenne deesha suuthaafe guuthara ekidi, yarsho bessa yuushuwan de7iya kaceta tiyo. ");
INSERT INTO gofl_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","He suuthan ba biradhiya yeddi ekidi laapun toho wurxo; hessada oothidi Isra7eele asaa tunatethaafe he yarsho bessa geeshsho. ");
INSERT INTO gofl_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Aaroni Ubbaafe Geeshsha bessaa, geeshsha Dunkaaniyanne yarsho bessa geeshshiya wogaa polidaape guye, paxa de7iya deesha shiisho. ");
INSERT INTO gofl_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Aaroni ba nam7u kushiya paxa de7iya deesha huuphen wothidi, Isra7eele asaa naaqo ubbaa, enta makalla ubbaa, enta nagara ubbaa paaxo. Yaatidi he deesha huuphen hessa toosso; he deesha efana mela giigisida uraa bolla mela biitta yeddo. ");
INSERT INTO gofl_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Deeshay enta nagara ubbaa tookidi, asi bayna bessi mela biitta bo. ");
INSERT INTO gofl_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Hessafe guye, Aaroni Geeshsha Dunkaaniya bidi Ubbaafe Geeshsha bessaa gelo. Liinope oosetida kase I ma7idi gelida ma7uwa qaaridi yan wotho. ");
INSERT INTO gofl_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Geeshsha bessan ba asatethaa meecetidi, ba kase ma7uwa ma7i keyidi ba nagaraanne asaa nagaraa atotethas xuussa yarsho yarshsho. ");
INSERT INTO gofl_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Nagara yarshuwa modhuwa yarsho bessan xuuggo. ");
INSERT INTO gofl_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Bazzo yedetiya deesha efida uray ba ma7uwa meecco; ba asatethaa meeceto; yaati simmidi guta gelo. ");
INSERT INTO gofl_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Nagara atotethas Aaroni enta suuthaa Ubbaafe Geeshsha bessaa ehida wofaanuwanne deesha galbaa, attida ashuwanne tociya gutaape gaxa kessidi xuuggo. ");
INSERT INTO gofl_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Hessa xuuggida uray ba ma7uwa meecco; ba asatethaa meeceto; hessafe guye, gutaa gelo. ");
INSERT INTO gofl_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Haysi hintew merinaa woga gido; laapuntha ageenay gelida tammantho gallas hintena kawushite; biitta aawu na7a gidin woyko hara biitta asi gidin, ay oosoka oothopite. ");
INSERT INTO gofl_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Ayis giiko he gallasay hinte nagara atotethi demmiya gallas; hinte Godaa sinthan hinte nagara ubbaafe geeyana. ");
INSERT INTO gofl_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Hessi hintew gita Sambaata shempo gallas gidana. He gallas hintena kawushite; hessi hintew merinaa woga gido. ");
INSERT INTO gofl_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Qassi ba aawa bessan kahine gidana mela tiyetiyanne dummatiya kahiney geeshshi gidida liinope oosetida ma7uwa ma7idi, nagaraa atotetha wogaa polo. ");
INSERT INTO gofl_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","I ubbaafe Geeshsha bessaa, Geshsha Dunkaaniya, yarsho bessa, kahinetanne Isra7eele asa ubbaa geeshsho. ");
INSERT INTO gofl_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Isra7eele asa ubbaa nagaraa atotethas laythan laythan issi toho oothanaw haysi hintew merina woga gido. Goday kiitidaysada Musey oothis. ");
INSERT INTO gofl_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Goday Museko haysada yaagis; ");
INSERT INTO gofl_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“Aaronas iya adde naytasinne Isra7eele asa ubbaas haysada yaagada oda; Goday kiittidaysi haysa; ");
INSERT INTO gofl_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Isra7eele asaape oonika boori woyko maraze woyko kole gutan woyko gutaape gaxan shukidi, ");
INSERT INTO gofl_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","Godaas imota oothidi immanaw Geeshsha Dunkaaniya penge Godaa sinthe ehonna ixiko, I he suuthan oyshetees. He uray suuthu gussida gisho ba asaa giddofe kuretto. ");
INSERT INTO gofl_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Hessa gisho, Isra7eele asay yarsho mehe coo denban shukeysa aggidi, Godaa sinthan Geeshsha Dunkaaniya pengen de7iya kahiniyako eho. Kahiney hessa ekidi, Godaas issifetetha yarsho oothidi shuko. ");
INSERT INTO gofl_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Kahiney Geeshsha Dunkaaniya pengen de7iya yarsho bessa bolla he suuthaa wurxo. Modhdhuwa Godaas sawo tonku giya yarsho oothidi xuuggo. ");
INSERT INTO gofl_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Isra7eele asay Godaa aggidi kaallida tuna ayyaanatas zaaridi banta yarshuwa yarshofo. Hessi entawunne yaana yeletethaa ubbaas merinaa woga gido. ");
INSERT INTO gofl_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“Entako haysada yaaga; Isra7eele asaape gidin woyko enta giddon de7iya allaga biitta asape gidin, oonika xuussa yarsho woyko hara yarsho shiishiya wode, ");
INSERT INTO gofl_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","Godaas yarshanaw Geeshsha Dunkaaniya penge ehonna ixiko, he uray ba asaa giddofe kuretto. ");
INSERT INTO gofl_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“Isra7eele asaape woyko enta giddon de7iya allaga biitta asaape oonika suuthu miiko, he suuthaa miya uraa bolla ta zoko zaarana; taani he uraa asaa giddofe kurana. ");
INSERT INTO gofl_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Ayis giiko asho ma7ida ubbaa de7oy iya suuthaa giddon de7ees; suuthi de7oy iya giddon de7iya gisho nagara atto giisees. Hinte nagara atotethas suuthu yarshana mela hintew immas. ");
INSERT INTO gofl_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Taani Isra7eele asaako, hintefe woyko hinte giddon de7iya allaga biitta asaape oonika suuthu moopo yaagiday hessa gishosa. ");
INSERT INTO gofl_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“Isra7eele asaape woyko enta giddon de7iya allaga biitta asaape oonika meetetiya do7a woyko kafo shankatidi wodhiko, iya suuthaa sa7an gussidi biitta kammo. ");
INSERT INTO gofl_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Ayis giiko asho ma7ida ubbaa de7oy iya suutha giddona. Asho ma7ida medhetethata ubbaa de7oy iya suutha giddon de7iya gisho, suuthu moopite; qassi miya oonika ba asaa giddofe kuretto yaagada Isra7eele asaas odas. ");
INSERT INTO gofl_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“Isra7eele asaa gidin woyko enta giddon de7iya allaga biitta asaa gidin, oonika bawuta woyko do7i wodhidaba miiko, ba ma7uwa meecco; ba asatethaa meeceto; yaatidi omarsi gakanaw tuna gidees. Hessafe guye, I geeshshi gidana. ");
INSERT INTO gofl_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Ba ma7uwa meecconna ixiko, ba asatethaa meecetonna aggiko, I ba nagaraa baw tookees.” ");
INSERT INTO gofl_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Goday Museko haysada yaagis; ");
INSERT INTO gofl_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“Isra7eele asaas haysada yaagada oda; taani Godaa, hinte Xoossaa. ");
INSERT INTO gofl_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Hinte kase de7ida Gibxe asay ootheysada oothopite; woyko ha77i taani hintena gelsiya Kanaane biitta asay ootheysada oothopite; enta wogaa kaallopite. ");
INSERT INTO gofl_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Hinte ta kiitta oothite; ta wogaa naagite; taani Godaa, hinte Xoossaa. ");
INSERT INTO gofl_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Ta kiitaanne ta wogaa naagite, hinte hessa oothiko de7on daana. Taani Godaa. ");
INSERT INTO gofl_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“Hintefe oonika ba mata dabbora xaallofo. Taani Godaa. ");
INSERT INTO gofl_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","“Ne aayiw xaallada ne aawa kawushofa. Iya ne aayiw gidiya gisho iyo xaallofa. ");
INSERT INTO gofl_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","“Ne aawa machiw xaallada ne aawa kawushofa. ");
INSERT INTO gofl_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","“Ne michiw xaallofa; son yeletida woyko karen yeletida ne aawa na7iw woyko ne aaye na7iw xaallofa. ");
INSERT INTO gofl_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","“Ne na7aa na7iw woyko ne na7e na7iw xaallada ne nena kawushofa. ");
INSERT INTO gofl_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","“Ne micho gidiya gisho ne aawa mache na7iw xaallofa. ");
INSERT INTO gofl_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","“Ne aawa michiw xaallofa; iya ne aawas mata dabbo. ");
INSERT INTO gofl_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","“Ne aaye michiw xaallofa; iya ne aayes mata dabbo. ");
INSERT INTO gofl_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","“Ne aawa ishaa machiw xaallofa; iya ne aawa ishaa machiw. ");
INSERT INTO gofl_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Ne na7aa machiw xaallofa; iya ne na7aa machiw. ");
INSERT INTO gofl_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","“Ne ishaa machiw xaallada ne ishaa kawushofa. ");
INSERT INTO gofl_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","“Aayiwunne I na7iw xaallofa; I na7e na7iw woyko I na7aa na7iw xaallofa. Enti iw mata dabbo gidiya gisho, hessi iita tuna. ");
INSERT INTO gofl_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","“Ne machiya paxa de7ishin, ne mache michiw dawuthofa. ");
INSERT INTO gofl_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“Kushe metora de7iya maccasi xaallofa. ");
INSERT INTO gofl_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","“Neeni tunonna mela ne shooruwa machiw xaallofa. ");
INSERT INTO gofl_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","“Ne Xoossaa sunthay cayetonna mela ne naytape issuwa taman xuuggada, Moloka giya eeqas yarsho oothada immofa. Taani Godaa. ");
INSERT INTO gofl_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","“Xoossa sinthan ixetidaba gidiya gisho maccasara gaheteysada addera gahetofa. ");
INSERT INTO gofl_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","“Neeni tunonna mela mehera gahetofa; maccasi mehera gahetanaw mehe sinthe aadhofo. Hessi wogan baynaba. ");
INSERT INTO gofl_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“Taani hinte sinthafe yedethiya kawotethati he oosotan tunida gisho, hinte he oosotan enta mela tunopite. ");
INSERT INTO gofl_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Hari attoshin, biittayka tunida gisho, iya nagaraa gisho ta iya seeras. Biittiya banan de7ey asaa cuttasu. ");
INSERT INTO gofl_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Shin hinte ta higgiyanne ta kiita naagite. Hintena gidin woyko hinte giddon de7iya allaga biitta asaa gidin oonika hessa mela tuna ooso oothopite. ");
INSERT INTO gofl_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","“Hintefe kase ha biittan de7ida asay hessa mela tunabaa oothida gisho, biittiya tunasu. ");
INSERT INTO gofl_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Hinte ha biitta tunisiko, hintefe kase de7ida kawotethata ha biittiya cuttidaysada hintenaka cuttonna mela naagetite. ");
INSERT INTO gofl_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Hessata daaniya tuna oosotape issuwaka oothiya asi de7iko, he uray ba asaa giddofe kuretto. ");
INSERT INTO gofl_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Hessa gisho, hintefe kase de7ida asati oothida tuna oosota ubbaa oothidi hinte tunonna mela ta kiitta naagite; taani Godaa, hinte Xoossaa” yaagis. ");
INSERT INTO gofl_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Goday Museko haysada yaagis. ");
INSERT INTO gofl_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","Isra7eele asa ubbaas haysada yaagada oda; “Taani, Goday, hinte Xoossay, geeshshi gidiya gisho, hinteka geeshshi gidite. ");
INSERT INTO gofl_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","“Hintefe issoy issoy ba aawanne ba aayiw boncho; ta Sambaata bonchite. Taani Godaa, hinte Xoossaa. ");
INSERT INTO gofl_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","“Tana aggidi eeqata goyinnofite; woyko biratape oosetida xoossata hintew oothopite. Taani Godaa, hinte Xoossaa. ");
INSERT INTO gofl_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“Hinte issifetetha yarsho Godaas yarshiya wode he yarshoy hinte gisho eketana mela besseysada yarshite. ");
INSERT INTO gofl_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","He yarshoy hinte yarshida gallas woyko wontetha gallas meeteto; heedzantho gallas gakanaw attiday de7iko taman xuugeto. ");
INSERT INTO gofl_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Heedzantho gallas meetetiko, hessi tunisiyaba; taani hessa ekike. ");
INSERT INTO gofl_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Hessa miya oonika Godaas geeshshi gididaba tunisida gisho ba nagaran oyshetana. He uray ba asaa giddofe kuretto. ");
INSERT INTO gofl_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“Hinte gaden kaxida kathaa hinte cakiya wode gadiya gaxaa gakanaw de7eysa cakofite; caki simmin de7iya poshiliya qoropite. ");
INSERT INTO gofl_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Ne woyne ayfiya maxiya wode mithaa bolla qosetidi attidaysa woyko sa7an wodhida woyne ayfiya maxopa. Hessa manqotasinne bete asaas aggaaga. Taani Godaa, hinte Xoossaa. ");
INSERT INTO gofl_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“Kaysotopite. “Wordotopite. “Issoy issuwa cimmofite. ");
INSERT INTO gofl_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","“Ta sunthan wordo caaqofite; hinte Xoossaa sunthaa tunisopite. Taani hinte Godaa. ");
INSERT INTO gofl_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“Ne shooruwa bolla gene oothofa; woyko iya bonqofa. “Une oothiya uraa damooziya diggada, issi qammaka ne matan aysopa. ");
INSERT INTO gofl_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","“Tulliya cayopa; woyko qooqiya sinthan dhube wothofa, shin neeni Xoossas yayya. Taani ne Godaa. ");
INSERT INTO gofl_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“Pirda geellayopite; manquwa iya manqotetha gisho maaddada pirdofa; duriya iya duretetha gisho yayyada aggofa. Shin ne shooruwas suure pirda. ");
INSERT INTO gofl_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","“Ne asaa giddon iita zigirsi ekada yuuyopa. “Ne shooruwa hayqos gathiyaba aykoka oothofa. Taani ne Godaa. ");
INSERT INTO gofl_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“Ne ishaa ne wozanan ixofa. Ne shooruwa gaason ne nagara oothonna mela iya hanqa. ");
INSERT INTO gofl_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","“Halo keyopa; ne asaape issuwa bollaka shifopa. Shin ne shooruwa ne huupheda dosa. Taani ne Godaa. ");
INSERT INTO gofl_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“Ta kiitata naaga. “Issi qommo mehe hara qommo mehera biraysisopa. “Issi shooqan nam7u qommo zerethi zeropa. “Nam7u qommofe oosetida ma7o ma7ofa. ");
INSERT INTO gofl_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“Issi asi azinas oyshetada de7ishin, wozo miishey imetidi wuronnashin woyko la77a keyonnashin, he ayllera aqiko enti seeretanaw bessees, shin enti hayqanaw bessenna. ");
INSERT INTO gofl_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Gidoshin, he uray ba naaqo yarshos gidiya maraze Geeshsha Dunkaaniya pengen Godaa sinthe eho. ");
INSERT INTO gofl_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Kahiney he naaqo yarsho maraziya ekidi, ura nagara atotethas Godaa sinthan yarshees; iya nagaray atto geetetana. ");
INSERT INTO gofl_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“Hinte Kanaane biitta geliya wode ayfe immiya ay qommo mithi tokikoka, he mithaa ayfey meetetonna mela digetidaysa akeekite. Heedzu laythi wurana gakanaw he mithaa ayfey meetetofo. ");
INSERT INTO gofl_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Oyddantho laythan he mithaa ayfey Godaas galatas shiiqiya geeshsha yarsho gidana. ");
INSERT INTO gofl_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Ichashantho laythan he mithaa ayfiya miite. Hinte hessada oothiko, hinte mithaa ayfey darana. Taani Godaa, hinte Xoossaa. ");
INSERT INTO gofl_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“Suuthi iya giddon de7iya asho moopite. Marotopite woyko bitopite. ");
INSERT INTO gofl_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","“Hinte huuphe binaana garsara yuushshi aathidi ciiropite; hinte buuchaa yuushshi aathidi meedopite. ");
INSERT INTO gofl_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","“Hayqida asa gisho hinte asatethaa gaaropite; woyko cacha beeta hinte asatethaa bolla medhofite. Taani ne Godaa. ");
INSERT INTO gofl_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“Biittiya laymatethaninne tunatethan kumonna mela ne macca na7iw laymatethas aatha immada tunisopa. ");
INSERT INTO gofl_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","“Ta Sambaata bonchite; ta goyinnetiya bessaa bonchite. Taani Godaa. ");
INSERT INTO gofl_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“Moytille odisiya asaako woyko marotako boopite; hinte tunonna mela enta koyopite. Taani Godaa, hinte Xoossaa. ");
INSERT INTO gofl_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“Dondza asinne cima asi be7iya wode uttida bessaafe denda eqada enta boncha; ne Xoossaas yayya. Taani Godaa. ");
INSERT INTO gofl_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“Hinte biittan de7iya bete ase sugopite. ");
INSERT INTO gofl_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Hinte biittan de7iya bete asi hinte gade asada xeellite; iya hinte huupheda dosite. Hinte kase Gibxe biittan bete asi gididi de7ideta. Taani Godaa, hinte Xoossaa. ");
INSERT INTO gofl_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“Hinte wadhiyaban, makiyabaninne mizaanen wordotopite. ");
INSERT INTO gofl_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Hinte mizaaney, hinte makiyabaynne wadhiyabay issino gido. Taani hintena Gibxe biittafe kessada ehida Godaa hinte Xoossaa. ");
INSERT INTO gofl_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","“Hinte ta higgiyanne ta kiitaa ubbaa naagitenne oothite. Taani Godaa.” ");
INSERT INTO gofl_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Goday Museko haysada yaagis. ");
INSERT INTO gofl_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","Isra7eele asaas haysada yaagada oda; “Isra7eele asaape gidin, woyko hinte giddon de7iya allaga asaape gidin, oonika ba na7a moloka geetetiya eeqas aathidi immiko, I hayqo; Isra7eele asay iya shuchan caddidi wodho. ");
INSERT INTO gofl_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Ba na7aa moloka geetetiya eeqas immidi ta Dunkaaniya tuniseynne ta geeshsha sunthaa kawushey ta sinthan ixetidaba gidana. Ta asaa giddofe shaakada taani iya dhaysana. ");
INSERT INTO gofl_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Shin he uraa Isra7eele asay be7ishe qelli gidi aadhikonne wodhonna ixiko, ");
INSERT INTO gofl_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","taani he addiyanne iya soo asaa morkana; iyanne Moloka kaallidaysata enta deriya giddofe shaakada dhaysana. ");
INSERT INTO gofl_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“Oonika tana ammanetona ixidi moytille xeegikonne maro soo biiko, taani iyaw morke gidana; asaa giddofe iya dhaysana. ");
INSERT INTO gofl_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","“Taani, Goday, hinte Xoossaa gidiya gisho, hinte hintena dummayite; geeshshi gidite. ");
INSERT INTO gofl_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Ta wogaa naagite; iya polite. Taani hintena geeshshiya, hinte Godaa. ");
INSERT INTO gofl_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“Oonika ba aawa woyko ba aayiw cayiko hayqo. I ba aawa woyko ba aayiw cayida gisho, iya suutha acoy iya bolla gido. ");
INSERT INTO gofl_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“Issi asi ba shooruwa machiw xaalliko, enti nam7ay hayqo. ");
INSERT INTO gofl_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Issi asi ba aawa machiw xaalliko, I ba aawa kawushis; enti nam7ay hayqo. Enta suuthaa acoy enta bolla gido. ");
INSERT INTO gofl_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Issi asi ba na7aa machiw xaalliko, enti nam7ay hayqo. Enti tunabaa oothidosona; enta suuthaa acoy enta bolla gido. ");
INSERT INTO gofl_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","“Issi addey maccasara gaheteysada addera gahetiko, enti nam7ay ixetidaba oothida gisho hayqo. Enta suuthaa acoy enta bolla gido. ");
INSERT INTO gofl_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Issi asi na7iwunne aayiw macho ekiko, hessi tunabaa. Hinte giddon tunatethi doonna mela inne enti taman xuugeto. ");
INSERT INTO gofl_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","“Issi asi mehera gahetiko, I hayqo; he miiziw wodhite. ");
INSERT INTO gofl_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Issi maccasi mehera gahetiko he maccasiyanne he mehey nam7ay hayqo; enta suuthaa acoy enta bolla gido. ");
INSERT INTO gofl_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“Issi asi ba aawa na7iw woyko ba aaye na7iw macho ekiko, hessi tunabaa. Enti banta asaa giddofe shaaketidi hayqo. I ba michiw kawushida gisho, ba nagaran baw oysheto. ");
INSERT INTO gofl_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Issi asi kushe metora de7iya maccasara aqiko, I qetha qaarida gisho, enti nam7ay banta asaa giddofe kuretto. ");
INSERT INTO gofl_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","“Ne aaye michiw woyko ne aawa michiw xaallofa; hessa oothey ba mata dabbotetha kawushshees. Enti nam7ay banta nagaran oysheto. ");
INSERT INTO gofl_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Issi asi ba aawa ishaa machiw xaalliko, I ba aawa ishaa kawushis. Enti banta nagaran bantaw oysheto; enti nam7ay na7a yelonna hayqana. ");
INSERT INTO gofl_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Issi asi ba ishaa machiw ekiko, hessi tuna. I ba ishaa kawushis; enti nam7ay yelo dhayana. ");
INSERT INTO gofl_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“Hinte daana mela ta hintena gelsiya biittay hintena cuttonna mela hinte ta higgiyanne ta kiitaa naagite. ");
INSERT INTO gofl_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Taani hinte sinthafe dhaysiya asaa de7uwa wogaa kaallopite. Enti hessa ubbaa oothida gisho, ta enta ixas. ");
INSERT INTO gofl_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Hinte enta biitta laatana; maathinne eessi goggey biitta hintew immana. Taani hintena hara asaape dummayada kessida, Godaa hinte Xoossaa. ");
INSERT INTO gofl_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","“Hessa gisho, hinte tunanne tuna gidonna mehetanne kafota shaakidi erite. Taani hessati hintew tuna gada wothida meheta, kafotanne biittan qaaxiyabata ubban hintena tunisopite. ");
INSERT INTO gofl_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Taani Goday geeshshi gidiya gishonne hinte tabaa gidana mela hintena hara asaape dummayida gisho, hinteka taw geeshshi gidite. ");
INSERT INTO gofl_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“Addey woyko macci moytillera haasayiko woyko marotiko, enti hayqanaw bessees. Enti shuchan cadetidi hayqo; enta suuthaa acoy enta bolla gido.” ");
INSERT INTO gofl_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Goday Museko, “Kahine gidida Aarona adde naytas haysada yaagada oda. Hintefe oonika ");
INSERT INTO gofl_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","ba mata dabbo, ba aaye, ba aawa, ba adde na7aa, ba macca na7e, ba ishaa, ");
INSERT INTO gofl_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","woyko azina gelonna, iya son de7iya ba miche aha gidonna ixiko, hayqida asa aha bochidi bana tunisopo. ");
INSERT INTO gofl_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Ekoninne gelon dabbotida asa aha bochidi bana tunisopo. ");
INSERT INTO gofl_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“Kahineti kayos banta huuphiyanne banta buuchaa meedopo; woyko banta asatethaa gaaropo. ");
INSERT INTO gofl_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Enti Godaas xuussa yarshonne katha yarsho shiishiya kahineta gidiya gisho banta Xoossaas geeshshi gido; banta Xoossaa sunthaa tunisopo. Hessa gisho, enti geeshshi gidanaw bessees. ");
INSERT INTO gofl_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","“Kahineti banta Xoossaas geeshshi gidiya gisho, kahineti layma maccasi, geela7o gidonna maccasi woyko azini yeddida maccasi ekofo. ");
INSERT INTO gofl_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Kahineti hinte Xoossaas katha yarsho yarsheyisata gidiya gisho, hinte enta geeshshi oothidi ekite. Hintena geeshshiya Goday, taani, geeshshi gidiya gisho, enti geeshshi gido. ");
INSERT INTO gofl_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Kahiniya na7iya laymatada bana tunisiko, iya ba aawa kawushasu; iya taman xuugetada hayqo. ");
INSERT INTO gofl_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“Kahine halaqay, iya huuphen tiyo zaytey gukidaysinne kahinetetha ma7uwa ma7anaw dummatidaysi, ba huuphiyape xaatha qacciya denthofo; ba ma7uwa daakofo. ");
INSERT INTO gofl_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Ahi de7iya soo gelopo; hari attoshin ba aawa woyko ba aaye aha gidikoka, hessa bochidi bana tunisopo. ");
INSERT INTO gofl_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Iya dummayanaw tiyida Xoossaa zaytey iya bolla de7iya gisho, kahiney Geeshsha Dunkaaniyape keyopo; Geeshsha Dunkaaniya tunisopo. Taani Godaa. ");
INSERT INTO gofl_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","“I ekiya machiya geela7o gido. ");
INSERT INTO gofl_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Azini hayqida maccasi woyko azini yeddida maccasi woyko layma maccasi macho ekofo. Shin ba asaa giddofe geela7o macca na7a dooridi macho eko. ");
INSERT INTO gofl_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Hessi hanonna ixiko, ba asaa giddon ba nayta tuna oothees. Taani iya geeshsheysa, iya Godaa.” ");
INSERT INTO gofl_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Goday Museko haysada yaagis. ");
INSERT INTO gofl_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“Neeni Aaronas haysada yaagada oda; ne kochaafe asatethan borey de7iya oonika katha yarsho taw yarshanaw bessenna. ");
INSERT INTO gofl_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Asatethan borey de7iya asi, hessika qooqe woyko wobbe woyko som7oy iitida asi woyko laqoy de7iya asi, ");
INSERT INTO gofl_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","woyko tohoy woyko kushey silida asi, ");
INSERT INTO gofl_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","woyko kuuna asi woyko daro qantha asi woyko ayfe mulca asi woyko puusoy oykida asi woyko iralley de7iya asi woyko shuufa asi taw katha yarsho yarshanaw bessenna. ");
INSERT INTO gofl_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Kahiniya Aarona kochaafe asatethan borey de7iya asi oonika Godaas xuussa yarshonne katha yarsho shiishanaw yarsho bessa yaanaw bessenna. ");
INSERT INTO gofl_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","I geeshsha kathaanne Ubbaafe geeshshi gidida ba Xoossaa kathaa maanaw danda7ees. ");
INSERT INTO gofl_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Shin iya asatethan borey de7iya asi gidiya gisho, I ta Dunkaaniya tunisonna mela magarajuwako woyko yarsho bessaako shiiqopo. Entana geeshshiya Goday tana.” ");
INSERT INTO gofl_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Musey hessa ubbaa Aaronas, iya adde naytasinne Isra7eele asa ubbaas odis. ");
INSERT INTO gofl_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Goday Museko haysada yaagis; ");
INSERT INTO gofl_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","Ta geeshsha sunthaa enti tunisonna mela, Isra7eele asay taw dummayida imotata Aaroninne iya adde nayti bonchon ekidi, geeshshatethan naagana mela entaw oda. Taani Godaa. ");
INSERT INTO gofl_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Entako haysada yaaga; “Yaana yeletetha ubban hinte kochaafe oonika tunidi de7ishe, Isra7eele asay Godaas dummayida geeshsha yarshuwako shiiqiko, he uray ta sinthan bentofo. Taani Godaa. ");
INSERT INTO gofl_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","“Aarona kochaafe goga hargey de7iya, woyko asatethafe goggiyabay de7iya oonika geeyana gakanaw geeshsha yarshuwa moopo. Aha bochidi tunidaba woyko iya atunthay gukida uraa bochiya oonika tuna. ");
INSERT INTO gofl_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","Qassi sa7ara gooshetiya tunisiyabata, woyko aybibanka tuna gididaba bochiya oonika, ");
INSERT INTO gofl_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","woyko hessa melaba bochiya oonika, omarsi gakanaw tuna gidees. I ba asatethaa haathan meecetonna de7ishe, geeshsha yarshuwafe maanaw koshshenna. ");
INSERT INTO gofl_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Awi wulliya wode I geeshshi gidees. Hessafe guye, he geeshsha yarshuwafe bana gakiya gishuwa mo. ");
INSERT INTO gofl_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Hayqidaba woyko do7i wodhida mehe asho moopo; hessi tunisiyaba. Taani Godaa. ");
INSERT INTO gofl_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“Kahineti ta wogaa naago; enti iya naagonna ixidi banta balan hayqana. Enta geeshshiya Goday tana. ");
INSERT INTO gofl_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“He geeshsha yarshuwa kahiniya soo asaape attishin, hara asi moopo. Kahiniya soo yida imathe gidin, qaxaretidi oothiya ase gidin moopo. ");
INSERT INTO gofl_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Shin kahiney ba biran shammida aylley woyko iya son yeletida aylley he kathaa mo. ");
INSERT INTO gofl_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Kahine gidonna asi gelida kahiniya na7iya he geeshsha yarshuwafe moopo. ");
INSERT INTO gofl_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Shin I azinay hayqiko woyko iyo yeddiko qassi iw na7i bayna ixiko, iya kase ba geela7otethan de7idaysada simmada ba aawa son de7iko, iya ba aawa gakeysafe mo. Shin hara asi oonika hessafe moopo. ");
INSERT INTO gofl_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“Issi asi eronna de7ishe geeshsha yarshuwafe miiko, he I mida kathaa gatiya bolla xeetaape laatamu kushe gujidi kahiniyas immo. ");
INSERT INTO gofl_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Isra7eele asay Godaas yarshiya geeshsha yarshuwa kahineti tunisopo. ");
INSERT INTO gofl_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","Enti banta ehida geeshsha yarshuwa bantaw midi nagaran oyshetana mela oothofo. Enta geeshshiya Goday tana.” ");
INSERT INTO gofl_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Goday Museko haysada yaagis; ");
INSERT INTO gofl_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“Aaronas, iya adde naytasinne Isra7eele asa ubbaas haysada yaagada oda; Isra7eele asi gidin woyko enta giddon de7iya bete asi gidin, oonika Godaas xuussa yarsho ba dosan immey woyko ba qangetha gathey, ");
INSERT INTO gofl_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","he yarshoy eketana mela borey bayna wofaano, woyko maraze woyko kole eho. ");
INSERT INTO gofl_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Borey de7iya ay meheyka eketonna gisho hessa shiishopite. ");
INSERT INTO gofl_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","“Issi asi ba qangetha gathanaw issifetetha yarsho Godaas yarshiya wode woyko ba mehiyape dosan imota Godaas shiishiya wode hessi eketana mela he mehey borey baynaba gido. ");
INSERT INTO gofl_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Hinte mehiyape qooqe woyko meqo woyko wobbe woyko giyiya madunthi woyko puusoy woyko shattoy de7iyaba Godaas yarshofite. Taman xuussa yarsho oothidi yarsho bessan Godaas shiishopite. ");
INSERT INTO gofl_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Iya bolla laqoy medheti woyko bolla paci de7iya korma woyko dorse issi asi ba dosan immiya yarsho shiishanaw danda7ees; shin qangetha gasos gidiko hessi eketenna. ");
INSERT INTO gofl_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Sanga woyko madunxidaba Godaas yarshofite. Hinte biittan hessa melaba oothopite. ");
INSERT INTO gofl_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Hinte giddon de7iya allaga asatape ekida hessa mela mehiya hinte Xoossaas katha yarsho oothidi shiishopite. Enta bolla borey de7iya gisho hinte gisho eketokona.” ");
INSERT INTO gofl_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Goday Museko haysada yaagis; ");
INSERT INTO gofl_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“Boora na7i woyko marazey woyko koley yeletiya wode laapun gallas ba aayera gam7o. Hospuntha gallasape doomidi, Godaas xuussa yarsho oothidi shiishanaw danda7etees. ");
INSERT INTO gofl_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Miizi woyko dorse I maraara issi gallas shukofite. ");
INSERT INTO gofl_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","“Hinte galata yarsho Godaas shiishiya wode hinte yarshoy eketana mela yarshite. ");
INSERT INTO gofl_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Yarshoy yarshetida gallas meetetidi wuranaw koshshees; iyape wontos ashshofite. Taani Godaa. ");
INSERT INTO gofl_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“Ta kiitta naagitenne polite. Taani Godaa. ");
INSERT INTO gofl_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Ta geeshsha sunthaa tunisopite. Ta geeshshi gideysi Isra7eele asaa giddon eretanaw bessees. Hintena geeshshiya Goday tana. ");
INSERT INTO gofl_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Hinte Xoosse gidanaw hintena Gibxe biittafe kessiday tana. Taani Godaa.” ");
INSERT INTO gofl_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Goday Museko haysada yaagis; ");
INSERT INTO gofl_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","Isra7eele asaas haysada yaagada oda; Geeshsha shiiqo yaagidi awaajishe, hinte bonchanaw bessiya eretida Godaa ba7aaleti haysata. ");
INSERT INTO gofl_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Hinte usupun gallas ooso ootheeta, shin laapuntha gallasay hinte shempiya Sambaata gallas. He gallas geeshsha shiiqo shiiqite; ay oosoka oothopite; hinte de7iya bessa ubban hessi Godaas Sambaata. ");
INSERT INTO gofl_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Enta woden woden geeshsha shiiqo oothidi hinte bonchanaw bessiya eretida Godaa ba7aaleti haysata; ");
INSERT INTO gofl_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Koyro ageenan tammanne oyddantho gallas sa7i omarsiya wode Godaa Paasikay doomees. ");
INSERT INTO gofl_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","He ageenan tammanne ichashantho gallasan Godaas Uytha Ba7aale gallasay doomees. Hessa gisho, laapun gallasatan irshoy geliboonna uythi miite. ");
INSERT INTO gofl_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","He gallasatape koyro gallas geeshsha shiiqo shiiqite; ooso oothopite. ");
INSERT INTO gofl_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Laapun gallas ubbaa Godaas xuussa yarsho yarshite; laapuntha gallasan geeshsha shiiqo shiiqite; ooso oothopite. ");
INSERT INTO gofl_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Goday Museko haysada yaagis; ");
INSERT INTO gofl_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","Isra7eele asaas haysada yaagada oda; taani hintew immiya biitta gelidi hinte kathi cakiya wode, he kathaa koyro mirqiya kahiniyas ehite. ");
INSERT INTO gofl_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Goday hintebaa ekana mela Sambaata kaalliya wontetha gallas kahiney he mirqiya Godaa sinthan dhoqu oothidi yuushsho. ");
INSERT INTO gofl_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Hinte mirqiya yuushshida he gallas borey bayna issi laytha maraze xuussa yarsho oothidi Godaas shiishite. ");
INSERT INTO gofl_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","He yarshuwara issife shamaho zaytera munuqetida nam7u kilo giraame lo77o dhiille katha yarsho oothidi shiishite. Hessi Godaas sawo tonku giya xussa yarsho gidana; iyara issife issi litiro gidiya woyne ushshi shiishite. ");
INSERT INTO gofl_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Ha yarshuwa hinte, hinte Xoossaas shiishiya gallasay gakanaw, wacha kathaafe qaye woyko caaca woyko uukidi moopite. Hessi hinte de7iya bessa ubban yaana yeletethaas merinaa woga gido. ");
INSERT INTO gofl_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Hinte yuusho yarsho mirqiya ehida Sambaata wontetha gallasaape doomidi, laapun saaminta taybite. ");
INSERT INTO gofl_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Laapuntha Sambaata kaalliya wontetha gallasay gakanaw ishatamu gallas taybite; wacha kathaafe yarsho Godaas shiishite. ");
INSERT INTO gofl_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Hinte de7iya bessaafe nam7u kilo giraame gidiya lo77o dhiilliyan irsho yeggidi uukida nam7u uythi yuusho yarshos ekidi yiite. Hessi wacha kathaafe Godaas shiiqiya yarsho gidees. ");
INSERT INTO gofl_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","He uythaara issife borey bayna issi laythi gidida laapun dorsa urgeta, issi wofaanonne nam7u marazeta shiishite. Enta katha yarshoranne ushsha yarshora issife Godaas xuugetiya sawo tonku giya yarsho oothidi yarshite. ");
INSERT INTO gofl_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Qassi issi kole nagara yarshos, issi laythi gidida nam7u dorsa urgeta issifetetha yarshos shiishite. ");
INSERT INTO gofl_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Kahiney bayra kathaa, uythaanne nam7u dorsa urgeta yuusho yarsho oothidi, Godaa sinthan dhoqu oothidi yuushsho. Hessati Godaas geeshshi; kahinetas qassi gisho. ");
INSERT INTO gofl_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","He gallas hintew geeshsha shiiqo gidana mela awaajite; ooso oothopite. Haysi hinte de7iya bessa ubban yaana yeletethaas merinaa woga gido. ");
INSERT INTO gofl_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Hinte biittan kaxida kathaa cakiya wode gadiya gaxaa gakanaw cakofite; cakishin attida poshiliya qoropite; hessa manqotasinne bete asaas aggaagite. Taani Godaa hinte Xoossaa. ");
INSERT INTO gofl_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Goday Museko haysada yaagis; ");
INSERT INTO gofl_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","Isra7eele asaas haysada yaagada oda; laapuntha ageenan koyro gallasaa shempo gallas oothidi bonchite; hassayiso moyze punnishe geeshsha shiiqo shiiqite. ");
INSERT INTO gofl_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","He gallas Godaas xuussa yarsho shiishitepe attishin, ooso oothopite. ");
INSERT INTO gofl_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Goday Museko haysada yaagis; ");
INSERT INTO gofl_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","Laapuntha ageenan tammantho gallasay nagara atotetha gallas; he gallas geeshsha shiiqo shiiqite. He gallas hintena kawushite; Godaas xuussa yarsho shiishite. ");
INSERT INTO gofl_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","He gallasay Godaa hinte Xoossaa sinthan hinte nagaray qushetana mela hinte nagaraa atotetha gallas gidiya gisho he gallasan ooso oothopite. ");
INSERT INTO gofl_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","He gallas banatetha kawushonna asi oonika ba asaa giddofe kuretto. ");
INSERT INTO gofl_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","He gallas ooso oothiya uraa oonaka taani iya asaa giddofe kurana. ");
INSERT INTO gofl_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","He gallas ooso oothopite. Haysi hinte de7iya bessa ubban yaana yeletethaas merinaa woga gido. ");
INSERT INTO gofl_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Hessi hintew dummatida shempo gallas; he gallas hintenatethaa kawushite. He ageenan uddufuntho gallas omarsafe doomidi, tammantha gallas omarsi gakanaw hinte Sambaata bonchite. ");
INSERT INTO gofl_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Goday Museko haysada yaagis; ");
INSERT INTO gofl_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","Isra7eele asaas haysada yaagada oda; laapuntha ageenan tammanne ichashantho gallasaape doomidi, laapun gallas gakanaw Godaas Shaqara Ba7aale. ");
INSERT INTO gofl_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","He gallasatape koyro gallasan geeshsha shiiqo shiiqite; ooso oothopite. ");
INSERT INTO gofl_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Laapun gallas ubban Godaas xuussa yarsho shiishite; hospuntho gallasan geeshsha shiiqo shiiqite. Godaas xuussa katha yarsho shiishite. He gallasay baaliya wursetha gallas gidiya gisho, ooso oothopite. ");
INSERT INTO gofl_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Xuussa yarsho, katha yarsho, hara yarshotanne ushsha yarsho koshshiya woden Godaas shiishanaw geeshsha shiiqo oothidi awaajana Godaa ba7aaleti haysata. ");
INSERT INTO gofl_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Ha yarshoti Godaa Sambaatatape, Godaas immiya imotatape, qangetha imotatapenne dosan immiya imotatape dumma. ");
INSERT INTO gofl_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Hinte gaden kaxida kathaa shiishidaape guye, tammanne ichashantho gallasaape doomidi laapun gallas gakanaw Godaa ba7aale bonchite. Koyro gallasaynne hospuntho gallasay hintew dumma shempo gallas gidana. ");
INSERT INTO gofl_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Koyro gallas lo77o mitha ayfe, zamba tashe, cil7o mitha haythenne shaafa gaxan dicciya mitha haythi ekidi, Godaa hinte Xoossaa sinthan ufaytishe laapun gallas ba7aale bonchite. ");
INSERT INTO gofl_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","He baaliya laythan laythan laapuntha ageenan laapun gallas Godaa bonchite. Hessi yaana yeletethaas merinaa woga gido. ");
INSERT INTO gofl_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","He laapun gallasaa shaqaran de7ite; Isra7eele asi gidida ubbay he shaqaran de7o. ");
INSERT INTO gofl_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","Taani hintena Gibxe biittafe kessida wode shaqaran daana mela oothidaysa yaana yeletethay erana. Taani Godaa hinte Xoossaa. ");
INSERT INTO gofl_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Hessada oothidi, Musey Godaa ba7aaleta bonchiya wogaa Isra7eele asaas odis. ");
INSERT INTO gofl_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Goday Museko haysada yaagis; ");
INSERT INTO gofl_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","Xompey to7onna eexishe daana mela iyaw koshshiya gum7idi xillisida shamaho zayte new ehana mela Isra7eele asaa kiitta. ");
INSERT INTO gofl_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Geeshsha Dunkaaniya giddon de7iya markatetha magarajuwafe kare baggara omarsafe wonta gakanaw Aaroni Godaa sinthan he xompiya ubba wode eetho. Yaana yeletetha ubbaas hessi merinaa woga gido. ");
INSERT INTO gofl_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Xompe wothiya walahi bayna worqa kocaa bolla de7iya xompeti Godaa sinthan ubba wode eexana mela Aaroni naago. ");
INSERT INTO gofl_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Tammanne nam7u kilo giraame gidiya lo77o dhiille ekada tammanne nam7u uythi uuka. ");
INSERT INTO gofl_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","He uythata usupuna usupuna nam7u maaran Godaa sinthan de7iya walahi bayna worqa xarpheeza bolla wotha. ");
INSERT INTO gofl_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Godaas xuugetanaw shiiqida katha yarsho gideysa erisanaw, nam7u maarata miyen geeshsha ixaane wotha. ");
INSERT INTO gofl_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Ha uythaa Sambaatan Sambaatan ubba wode Aaroni Isra7eele asaa gisho merinaa caaqo oothidi Godaa sinthan wotho. ");
INSERT INTO gofl_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Hessi Aaronanne iya adde nayta gakiya gisho; enti iya geeshsha bessan mo. Hessi Godaas xuussa yarshuwafe wogaada Aaronanne iya nayta gakiya gisho gidiya gisho Ubbaafe Geeshshi. ");
INSERT INTO gofl_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Ba aayen Isra7eele, ba aawan Gibxe asi gidida issi uray de7ees. Issi gallas I hara Isra7eele asara heeran wadhetis. ");
INSERT INTO gofl_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Ba aayen Isra7eele gidida uray Godaa sunthaa cayis; yaatin iya asay Museko ehidosona. He uraa aayiya Daane koche gidida Debira na7a. I sunthay Salomito. ");
INSERT INTO gofl_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","He uraa waataneko Godaa sheney qoncana gakanaw iya naagisidosona. ");
INSERT INTO gofl_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Goday Muse haysada yaagis; ");
INSERT INTO gofl_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","He cayida uraa gutaape gaxa kessa. I cayishin si7ida asa ubbay banta kushiya iya huuphiya bolla wotho; Isra7eele maabara ubbay iya shucha caddidi wodho. ");
INSERT INTO gofl_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Isra7eele asaas haysada yaagada oda; issi asi ba Xoossaa cayiko, I ba nagaran oyshetana. ");
INSERT INTO gofl_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Godaa sunthaa cayiya asi hayqo; Isra7eele maabara ubbay iya shuchan caddo. Bete asi woyko gade asi Godaa sunthaa cayiko hayqo. ");
INSERT INTO gofl_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Ase wodhida asi hayqo. ");
INSERT INTO gofl_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Asa mehe wodhida asi oonika ba wodhida mehiya gisho paxa mehiya qanxo. ");
INSERT INTO gofl_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Issi asi ba shooruwa qohiko, I oothidaysada iya bolla ooseto. ");
INSERT INTO gofl_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Menthiko me77o; ayfe gisho ayfe; acha gisho ache. Asa bolla qoho gathida oonika I gathida qohuwada iya bolla gako. ");
INSERT INTO gofl_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Mehe wodhida asi he mehiya gatiya qanxo; shin ase wodhida asi hayqo. ");
INSERT INTO gofl_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Bete asaasinne Isra7eele asas higgey issino gido. Taani Godaa hinte Xoossaa. ");
INSERT INTO gofl_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Musey hessa Isra7eele asaas odis; enti he cayida uraa gutaape gaxa kessidi, shuchan caddidi wodhidosona. Yaatidi Isra7eele asay Goday Muse kiitidaysada oothidosona. ");
INSERT INTO gofl_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Siina zuma bolla Goday Museko haysada yaagis. ");
INSERT INTO gofl_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","Neeni Isra7eele asaas haysada yaagada oda; taani hintew immiya biitta hinte geliya wode biittiya ba huuphen Godaa Sambaata boncho. ");
INSERT INTO gofl_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Usupun laythi kumethi hinte gaden zerite; usupun laythi kumethi hinte woyne xeera xunqite; iya ayfiya maxite. ");
INSERT INTO gofl_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Shin laapuntha laythay biittas shempo Sambaata; hessi Godaa Sambaata. He laapuntha laythan gaden zeropite; hinte woyne xeeraa xunqofite. ");
INSERT INTO gofl_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Hinte biittan aasebo kaxidaba shiishopite; woyne xeera xunqofite; ayfiya maxopite. He laythay biittas kumethi shempo laythi gido. ");
INSERT INTO gofl_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","He Sambaata laythan biittay oosetonna de7ishin kaxiya kathaa neeni, ne adde aylley, ne macca aylley, ne son une oothey, guutha wodes de7iya bete asi maanaw danda7ees. ");
INSERT INTO gofl_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","Hessadaka, ne mehiyasinne ne biittan de7iya do7atas gidiya kathi demmana; biittan kaxiyaba ubbay meeteto. ");
INSERT INTO gofl_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","Laythatas giddon de7iya laapun Sambaatata tayba; laapun Sambaatatas laytha tayboy laapun toho laapuna; hessika oytamanne uddufun laythi. ");
INSERT INTO gofl_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Laapuntha ageenan, tammantho gallas bonchetiya nagara atotetha gallasan moyze punniya asi biitta ubbaa kiitta. ");
INSERT INTO gofl_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Ishatammantho laytha dummayidi, he biittan de7iya ubbaas la77atethi awaajite. Hessi hintew Ishatammantho Laytha Ba7aale. He wode hinte ubbay hinte gadiyakonne hinte soo asaako simmite. ");
INSERT INTO gofl_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","He laythay hintew Ishatammantho Laytha Ba7aale. He laythan zeropite; aasebo kaxidaba cakofite; xeera xunqonna ayfida woyne ayfiya maxopite. ");
INSERT INTO gofl_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Hessi Ishatammantho Laytha Ba7aale gidiya gisho I hintew geeshshi; goyonna coo denban kaxidaba miite. ");
INSERT INTO gofl_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","He Ishatammantho Laytha Ba7aale wode asi ubbay ba gade simmo. ");
INSERT INTO gofl_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Hinte, hinte shooruwape gade shammiko woyko iyaw bayziko issoy issuwa cimmofite. ");
INSERT INTO gofl_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Hinte Ishatammantho Laytha Baaliyape guye de7iya laythata taybuwan hinte shooruwape shammite. Hinte shooroy gadey kathi immanaw de7iya laythata taybuwada bayzo. ");
INSERT INTO gofl_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Laytha tayboy daro gidiko gatey darees; laythata tayboy guuxiko gatey guuxees. Gadiya lo77otethaada hinte shooroy hintew bayzees. ");
INSERT INTO gofl_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Hinte issoy issuwa cimmofite; shin hinte, hinte Xoossaa yayyite. Taani Godaa, hinte Xoossaa. ");
INSERT INTO gofl_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Hinte ha biittan saro daana mela ta kiitta polite; ta higgiya naagite. ");
INSERT INTO gofl_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Biittay ba ayfiya hintew immin hinte kallana gakanaw maana; he biittan hinte saro daana. ");
INSERT INTO gofl_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Heko, nuuni zeronna aggidi, qassi kathi shiishonna aggidi, laapuntha laythan ay maanee? giiko, ");
INSERT INTO gofl_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","taani usupuntho laythan ta anjuwa hintew kiittana; biittay heedzu laythas gidiya kathi immana. ");
INSERT INTO gofl_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Hospuntha laythan hinte, hinte biittan zeriya wode shaacha kathaa maana. Hinte zeriya kathaa uddufuntho laythan shiishana gakanaw shaacha kathaa maana. ");
INSERT INTO gofl_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Biittay tabaa gidiya gishonne hinte he biittan imathenne bete gididi de7iya gisho biitta simmonnaada oothidi bayzopite. ");
INSERT INTO gofl_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Hinte oykida gadiya godati, wozana maatay Isra7eele ubban naagetanaw bessees. ");
INSERT INTO gofl_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Issi Isra7eele asi manqidi ba gadiyape bayziko, iya mata dabboy he gadiya iyaw wozo. ");
INSERT INTO gofl_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Iyaw he gadiya woziya dabboy dhayiko, I wonto duretidi woziya miishe demmiko zaaridi wozanaw danda7ees. ");
INSERT INTO gofl_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","Ba bayzida wodepe doomidi de7iya laytha taybidi, attida laytha miishiya shammidaysas zaaro; yaatidi I ba gadiya simmo. ");
INSERT INTO gofl_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Shin iyaw he gadiya wozanaw gidiya miishey dhayiko, Ishatammantho Laytha Ba7aaley gakanaw gadey shammida uraa kushen gam7o. Ishatammantho Laytha Ba7aale wode iya gadey iyaw simmo. ");
INSERT INTO gofl_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Issi asi gimbetida katama giddon de7iya keethe bayziko, I bayzida wodiyape bidi issi laythi kumana gakanaw zaaridi wozanaw danda7ees. ");
INSERT INTO gofl_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Shin issi laytha giddon wozanaw danda7etonna ixiko, he gimbetida katamaa giddon de7iya keethay shammida uraasinne iya kochaas gidees. Ishatammantho Laytha Ba7aale wode simmenna. ");
INSERT INTO gofl_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Shin gimbetiboona heeran de7iya keethati gade mela wozetoosona. Ishatammantho Laytha Ba7aale wode bayzidaysas simmoosona. ");
INSERT INTO gofl_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Gidoshin, Leeweti katamatan de7iya banta keethaa banta koyida wode wozanaw danda7oosona. ");
INSERT INTO gofl_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Leewetape issi asi enta katamaa giddon de7iya keethaa bayzidi wozanaw xoonetiko, he enta katamaa giddon de7iya keethay Ishatammantho Laytha Baaliya wode simmees. Leeweta katamaa giddon de7iya keethay Isra7eele asaa giddon Leewetasa. ");
INSERT INTO gofl_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Shin enta katamaa yuushuwan de7iya hentha biittay entaw merinaa aqo gidiya gisho bayzetenna. ");
INSERT INTO gofl_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Issi Isra7eele asi manqidi bana aysanaw xoonetiko, imathada woyko bete asada I neera daana mela maadda. ");
INSERT INTO gofl_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Iya neera wothanaw iyape yelo ekofa woyko wodhe moopa. Shin ne Xoossaa yayya. ");
INSERT INTO gofl_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Ne bira iyaw yelora tal7ofa; ne kathaa iyaw wodhera bayzopa. ");
INSERT INTO gofl_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Hintew Kanaane biitta immanawunne hinte Xoossaa gidanaw, hintena Gibxe biittafe kessida, taani, Godaa hinte Xoossaa. ");
INSERT INTO gofl_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Issi Isra7eele asi manqidi, bana new aylle oothidi bayziko iya aylleda oosisopa. ");
INSERT INTO gofl_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","I bete asada une oothidi Ishatammantho Laytha Ba7aaley gakanaw neera de7o. ");
INSERT INTO gofl_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","He wode I ba naytara issife ne soope keyidi ba soo asaako boo; ba aawa gade simmo. ");
INSERT INTO gofl_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Isra7eele asay taani Gibxe biittafe kessida ta aylle gidiya gisho enti aylletethas bayzetofo. ");
INSERT INTO gofl_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Neeni enta un7ethada haaropa; shin neeni, ne Xoossaa yayya. ");
INSERT INTO gofl_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","New addenne macca aylley daana mela koyiko, ne yuushuwan de7iya kawotethatape shamma. ");
INSERT INTO gofl_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Hinte biittan de7iya bete asaa nayta shammanaw danda7eeta. Hinte biittan de7ishe yeletida enta soo asaape hintew shalo oothanaw danda7eeta. ");
INSERT INTO gofl_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Hintefe guye, hinte nayti enta merinaw laattana mela hinte naytas immite. Hinte enta ubba wode hinte aylle oothanaw danda7eeta; shin Isra7eele asi un7ethidi haaropite. ");
INSERT INTO gofl_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Ne matan de7iya imathi woyko bete asi duretiko, iya matan de7iya Isra7eele uray manqidi, ne matan de7iya imathas woyko bete uraas woyko imatha addiya kochaafe issuwas bana bayziko, ");
INSERT INTO gofl_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","I bayzetidi simmin, iya wozanaw danda7etees; iya dabbotape issoy iya wozo. ");
INSERT INTO gofl_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Iya aawa ishay, woyko iya aawa ishaa na7ay woyko iya yaraape mata dabboy iya wozo; woyko I ba huuphen duretidi bana wozo. ");
INSERT INTO gofl_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","I bana shammida uraara gididi, I bana bayzida laythafe doomidi Ishatammantho Laytha Ba7aaley gakanaw de7iya laythata taybo. Iya la77atetha gatey, he laytha taybuwa keena gido. I bana shammidaysara gam7ida wodiya gatey issi asi une oothidi demmiya miishiyara gina gido. ");
INSERT INTO gofl_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Ishatammantho Laytha Ba7aaley gakanaw daro laythi attidaba gidiko, ba bayzetida gatiyape he laytha taybon bana woziya gatiya qanxo. ");
INSERT INTO gofl_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Ishatammantho Laytha Ba7aaley gakanaw attida laythay guutha gidiko, bana shammidaysara issife taybidi, he laytha taybon bana woziya gatiya qanxo. ");
INSERT INTO gofl_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","I laythan laythan une oothiya asada bana shammidaysara de7o; iya goday iya un7ethidi haaranaw bessenna. ");
INSERT INTO gofl_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Shin I hessa mela hanon wozetonna ixiko, Ishatammantho Laytha Ba7aaley gakiya wode inne iya nayti aylletethafe keyo. ");
INSERT INTO gofl_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Isra7eele asay, ta Gibxe biittafe kessida ta aylle. Taani, Godaa hinte Xoossaa. ");
INSERT INTO gofl_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Goyinnanaw eeqata oothopite; qassi hawulte woyko eeqa tuussu woyko shucha eeqa essofite. Taani Godaa, hinte Xoossaa. ");
INSERT INTO gofl_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Ta Sambaatata naagite; ta goyinno bessaa bonchite. Taani Godaa. ");
INSERT INTO gofl_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Hinte ta higgiya kaallikonne ta kiita naagiko, ");
INSERT INTO gofl_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","taani hintew ira woden woden immana; biittay kathaa darsidi dolisana; gaden de7iya mithay ayfana. ");
INSERT INTO gofl_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Hinte kathaa shiishidi ongonna de7ishin woyne maxiya wodey gakana; woyniya maxidi wursonna kathaa zeriya wodey gakana. Hinte kallana gakanaw kathi maana; hinte, hinte biittan saro daana. ");
INSERT INTO gofl_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Taani biittas sarotethi immana; oonika hintena yashisonna hinte zin7ana. Iita do7ata taani biittafe dhaysana; hinte biittan nam7antho oli dendenna. ");
INSERT INTO gofl_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Hinte morketa hinte yedethana; enti hinte sinthan mashshan hayqana. ");
INSERT INTO gofl_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Hintefe ichashay xeeta yedethana; qassi xeetay tammu mukula yedethana. Hinte morketi hinte sinthan mashshan hayqana. ");
INSERT INTO gofl_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Taani hintena maarota ayfen be7ana; hintena ayfisana; hintena darsana; taani ta caaquwa hintera minthana. ");
INSERT INTO gofl_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Hinte shaacha kathaa midi wursonna de7ishe, wacha kathaa wothanaw, shaacha kathaa diggidi besse giigisana. ");
INSERT INTO gofl_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Taani ta de7iya bessaa hinte giddon oothana; taani hintena ixike. ");
INSERT INTO gofl_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Taani hinte giddon hemetana; hinte Xoossaa gidana; hinte ta ase gidana. ");
INSERT INTO gofl_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Hinte Gibxetas aylle gidonna mela he biittafe hintena kessida Goday, taani hinte Xoossaa. Taani hinte aylletetha qambara menthas; hinte dhoqu gidi hemetana mela oothas. ");
INSERT INTO gofl_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Shin hinte taana si7onna ixikonne, ta kiita polonna ixiko, ");
INSERT INTO gofl_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","ta wogaa kadhiko, ta kiita ubbaa polonna ixidi ta caaquwa menthanaw ta higgiya boriko, ");
INSERT INTO gofl_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","he wode taani hinte bolla haysa oothana; hinte akeekona de7ishin yashshi, gilqatethi, hinte ayfiya teljumisiyanne hinte asatethaa melisiya misha harge hinte bolla yeddana. Hinte morketi maana gisho hinte zeriya zerethay mela gidana. ");
INSERT INTO gofl_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Ta hintena iita ayfen xeellana; hinte morketa sinthan hinte kundana; hintena ixeysati haarana; oonika yedethonna hinte baqatana. ");
INSERT INTO gofl_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Hessa ubbaa oothinka hinte tana si7onna ixiko, taani hinte nagaraa gisho hinte seera laapun dako oothana. ");
INSERT INTO gofl_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Ta hinte otoruwa menthana; saluwa birata; sa7aa naase birata oothana. ");
INSERT INTO gofl_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Hinte biittay kathi, hinte mithay ayfe immonna gisho hinte wolqay coo bessan wurana. ");
INSERT INTO gofl_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Hinte taw ixas giikonne tana si7onna ixiko, hinte nagara mela laapun dako gado taani hinte bolla ehana. ");
INSERT INTO gofl_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Taani hinte bolla bazzo do7ata yeddana; enti hinte nayta bonqana. Hinte meheta dhaysana; hinte taybuwa guuthana; hessa gaason hinte hemetiya ogey husatana. ");
INSERT INTO gofl_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","He seera ubban hinte taako simmonna ixiko, ");
INSERT INTO gofl_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","he wode taka hintew ixas gaana. Hinte nagaraa gisho taani ta huuphen hintena laapun dako seerana. ");
INSERT INTO gofl_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Ta caaquwa hinte menthida gisho, kushe zaaranaw mashsha hinte bolla ehana. Hinte, hinte katamatan shiiqikoka, taani hinte bolla gado yeddana. Hinte, hinte morketa kushen aadhidi imetana. ");
INSERT INTO gofl_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Hinte kathaa taani dhaysiya wode tammu maccasati issi beshen uythu uukana; he uythaa mizaanen shaakidi ekana; hinte hessa maana shin kalleketa. ");
INSERT INTO gofl_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","Ha ubban hinte tana si7onna ixikonne hinte iitatethan gujidi biiko, ");
INSERT INTO gofl_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","ta hinte bolla hanqon dendana. Hinte nagaraa gisho taani hintena laapun dako seerana. ");
INSERT INTO gofl_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Hinte, hinte adde naytanne hinte macca nayta ashuwa maana. ");
INSERT INTO gofl_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Taani, hinte dhoqa goyinno bessata dhaysana; hinte ixaane yarshiya bessaa laallana. Taani hinte aha hinte eeqata aha bolla holana; taani hintena polo ixana. ");
INSERT INTO gofl_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Taani hinte katamata baysa oothana; hinte goyinno bessata dhaysana; hinte sawiya yarshuwa singike. ");
INSERT INTO gofl_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Taani hinte biitta dhaysana; he biittan de7iya morketi hessan malaaletana. ");
INSERT INTO gofl_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Taani hintena kawotethata giddon laallana; hinte bolla ta mashshaa shoddana. Hinte biittay baysatana; hinte katamati laaletana. ");
INSERT INTO gofl_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Hinte morketa biittan de7iya wode, baysa giigidi de7iya hinte biittay ba Sambaata bonchana. He wode hinte biittay shempananne ba Sambaata bonchishe ufaytana. ");
INSERT INTO gofl_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Hinte he biittan de7iya wode Sambaatatan demmiboonna shempuwa ha77i baysa gidida wode demmana. ");
INSERT INTO gofl_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","Hinte di7etidi biya wode guye attida asata wozanan yashshi yeddana; carkoy qaathiya bonco girsay enta daganthana; enti mashshafe baqatiya mela baqatana; enta oonika yedethonna kundana. ");
INSERT INTO gofl_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Oonika yedethonna olape baqatiyada baqatishe, issoy issuwara dhubetidi kundana. Hinte, hinte morketa sinthan eqanaw hintew wolqi dhayana. ");
INSERT INTO gofl_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Kawotethata giddon hinte dhayana; hinte morketa biittan hinte mitetidi dhayana. ");
INSERT INTO gofl_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Morketa biittan attidaysati banta nagaraa gishonne banta aawata nagaraa gisho gilqidi dhayana. ");
INSERT INTO gofl_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","Shin enti banta nagaraanne ta bolla makallidi si7onna ixida banta aawata nagaraa paaxiko, ");
INSERT INTO gofl_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","ta enta ixanaadanne enta morketa biitta yedethannaada oothida banta nagaraa aggikonne enta kiitetonna wozanay simmiko, ");
INSERT INTO gofl_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","Taani Yayqoobara, Yisaaqaranne Abrahaamera caaqida caaquwa hassayana; enta biitta zaara qopana. ");
INSERT INTO gofl_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Enta biittay baysa attana; he enti dhayin baysa gididi de7ida woden biittay Sambaata bonchishe ufaytana. Enti ta kiitaa kadhida gishonne ta wogaa leqida gisho banta nagaraa seera ekana. ");
INSERT INTO gofl_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Gidoshin, enti banta morketa biittan de7ida wode kumethi dhayana gakanaw entara de7iya ta caaquwa menthike; enta yeggike. Taani, Godaa enta Xoossaa. ");
INSERT INTO gofl_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Taani enta Xoossaa gidanaw, kawotethati xeellishin, Gibxe biittafe kessida enta mayzatara taani caaqida caaquwa enta gisho hassayana. Taani Godaa. ");
INSERT INTO gofl_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Goday Siina zuma bolla Muse baggara baapenne Isra7eele asaape giddon wothida wogati kiitatinne higgeti haysata. ");
INSERT INTO gofl_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Goday Museko haysada yaagis. ");
INSERT INTO gofl_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","Isra7eele asaas haysada yaagada oda; issi asi Godaas ase immanaw qangiko, wozo gatiya ne gammatidaysa mela he uraa gisho miishe qanxo. ");
INSERT INTO gofl_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Laatamu laythafe bidi usupun tammu laythi gakanaw de7iya adde gidiko geeshsha dunkaanen eretida mizaanen usupun xeetu bira santime qanxo. ");
INSERT INTO gofl_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Macca gidiko hastamu bira santime qanxo. ");
INSERT INTO gofl_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Ichashu laythafe bidi laatamu laythi gakanaw de7iya adde gidiko laatamu bira santime qanxo; qassi maccas gidiko tammu bira santime qanxo. ");
INSERT INTO gofl_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Issi ageenape bidi ichashu laythi gakanaw de7iya adde gidiko ichashu bira santime qanxo; qassi maccas gidiko heedzu bira santime qanxo. ");
INSERT INTO gofl_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Laythi usupun tammanne iyape bolla gidida adde gidiko, tammanne ichashu bira santime; qassi maccas gidiko tammu bira santime qanxo. ");
INSERT INTO gofl_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Qangida uray neeni gammatidaysa qanxanaw danda7onna manqo gidiko, I ba qangetha gathanaw immida uraa ehidi kahiniya sinthan esso; qangetida uray qanxanaw danda7eysa keena qopidi kahiney gammato. ");
INSERT INTO gofl_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Issi asi Godaas yarsho oothidi immanaw qangiday mehe gidiko Godaas imetiya mehe ubbay geeshshi gidees. ");
INSERT INTO gofl_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","He mehiya gisho hara mehe immofo; woyko iya hara mehera laammofo. Lo77uwa iitaara woyko iitaa lo77uwara laammofo; shin I laammiko, koyro meheynne laame immida mehey nam7ayka geeshshi gido. ");
INSERT INTO gofl_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Issi asi Godaas yarsho oothidi immanaw gepida mehey geeshshi gidonna ixiko, he uray he mehiya kahiniya sinthe eho. ");
INSERT INTO gofl_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Lo77o gidin, iita gidin kahiney he mehiya gammato; kahiney gammatidaysi iyaw gate gido. ");
INSERT INTO gofl_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Shin he mehiya goday zaaridi wozanaw koyiko, he mehiya gatiya bolla xeetape laatamu kushe gujo. ");
INSERT INTO gofl_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Issi asi ba keethaa geeshshi oothidi Godaas dummayiko, lo77o gidin, iita gidin kahiney he keethaa gammato; kahiney gammatidaysi iyaw gate gido. ");
INSERT INTO gofl_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Ba keethaa geeshshi oothidi Godaas dummayida uray zaaridi wozanaw koyiko, he keethaa gatiya bolla xeetape laatamu kushe gujo; simmidi keethay iyabaa gidees. ");
INSERT INTO gofl_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Issi asi ba laata gadiyape shaakidi geeshshi oothidi Godaas dummayiko, he gadiya gatey iyan zeretiya zerethan gammateto. Hessika nam7u xeetanne laatamu kilo giraame banga zeriya gade gidiko, ishatamu saqile qanxo. ");
INSERT INTO gofl_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","I ba gadiya Ishatammantho Laytha Ba7aalepe doomidi geeshshi oothidi Godaas dummayiko, he gadiya kumetha gatiya qanxo. ");
INSERT INTO gofl_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Shin I ba gadiya Ishatammantho Laytha Ba7aaley aadhin, geeshshi oothidi Godaas dummayiko, kaallidi de7iya Ishatammantho Laytha Ba7aaley gakanaw de7iya laythata kahiney taybidi, iya kumetha gatiyape wodho. ");
INSERT INTO gofl_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","He gadiya geeshshi oothidi Godaas dummayida uray zaaridi wozanaw koyiko, gammatetida gatiya bolla xeetape laatamu kushe gujo; simmidi gadey iyabaa gidees. ");
INSERT INTO gofl_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Shin I gadiya zaaridi wozanaape sinthe hara asas bayziko, he gadiya wozanaw danda7enna. ");
INSERT INTO gofl_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Ishatammantho Laytha Ba7aaley gakin gadey yedetiya wode he gadey nam7antho guye simmonna Godaas geeshshi gido; he gadey kahinetaba gidees. ");
INSERT INTO gofl_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Issi asi hara asape shammida gadiya geeshshi oothidi Godaas dummayanaw koyiko, ");
INSERT INTO gofl_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","kaalliya Ishatammantho Laytha Ba7aaley gakanaw de7iya gatiya kahiney gammatiko, uray he gallas gammatida gatiya qanxo; He miishey Godaas dummatida miishe gidana. ");
INSERT INTO gofl_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Ishatammantho Laytha Ba7aaley gakiya wode he gadey koyro laatan ekidi bayzida uraas simmees. ");
INSERT INTO gofl_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Enta gatey geeshsha dunkaaniyan eretida mizaanen gammatetees. (Issi saqiley laatamu Geera gidees). ");
INSERT INTO gofl_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Shin oonika bayra yeletida mehe Godaas dummayidi shiishanaw danda7enna; I kaseka Godaaba. Miizi woyko dorse gidin Godaaba. ");
INSERT INTO gofl_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","He mehey geeshshi gidonna ixiko, I gammatetida gatiya bolla ichashape issi kushe gujidi iya goday zaaridi wozo. I wozonna ixiko, gammatetida gatiyan hara asas bayzeto. ");
INSERT INTO gofl_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Issi asi Godaas dummayidi immidabay ayba gidikoka, ase woyko mehe woyko iya laata gade gidin, bayzetenanne wozetenna. I dummayidaba ubbay Godaas Ubbaafe geeshshi. ");
INSERT INTO gofl_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Asaa giddofe hayqana mela pirdetida asi oonika wozetofo; he uray hayqo. ");
INSERT INTO gofl_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Gaden kaxida kathi woyko mitha ayfe gidin tammaafe issoy Godaaba. Hessi Godaas geeshshi. ");
INSERT INTO gofl_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Issi asi ba asraata wozanaw koyiko, iya gatiya bolla xeetape laatamu kushe gujidi wozo. ");
INSERT INTO gofl_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Miiza asraata woyko dorsa asraata woyko deesha asraata gidin, henthanchuwa xam7afe garsara aadhiya tammaafe issoy Godaas geeshshi. ");
INSERT INTO gofl_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Tammantho mehey iita gidin, lo77o gidin dooropo; woyko iya haraara laammofo. Laammiko, koyroynne laame immida nam7ay Godaas geeshshi gidoosona; zaaridi wozanaw danda7etenna. ");
INSERT INTO gofl_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Siina zuma bolla Goday Muse baggara Isra7eele asaa kiitida kiitay haysa.");
INSERT INTO gofl_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Isra7eele asay Gibxe biittafe keyida nam7antho laythan, nam7antho ageenan, he ageena koyro gallasan, Goday Siina mela biittan Geeshsha Dunkaaniyan Museko haysada yaagis; ");
INSERT INTO gofl_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“Neeranne Aaronara Isra7eele asa ubbaa enta kochan kochan, qassi enta soo asan asan taybadi, adde asaa sunthaa xaafite. ");
INSERT INTO gofl_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Laythi laatamanne iyape bolla gidida, oletanaw danda7iya Isra7eele asa ubbaa taybite. ");
INSERT INTO gofl_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Kochape kochape issi issi asi ba soo asaas halaqa gididi hintena maaddo. ");
INSERT INTO gofl_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Hintena maaddana asaa sunthay haysafe kaallidi xaafetidaysa. Robeelape, Shade7ura na7aa Elixura; ");
INSERT INTO gofl_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","Simoonape Sursadaya na7a Salumi7eela; ");
INSERT INTO gofl_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","Yihudape Amnadaabe na7aa Na7asoona; ");
INSERT INTO gofl_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","Yisakoorape Zu7ara na7aa Natina7eela; ");
INSERT INTO gofl_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Zabloonape Heloona na7aa Eli7aaba; ");
INSERT INTO gofl_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Yoosefa naytape, Efreemape Amhuda na7aa Elishama7a; Minaasepe Padazuura na7aa Gamali7eela; ");
INSERT INTO gofl_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Biniyaamepe Gadiyoona na7aa Abdaana; ");
INSERT INTO gofl_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Daanape Amsadaya na7aa Aki7ezera; ");
INSERT INTO gofl_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","Aseerape Okraana na7aa Pagi7eela; ");
INSERT INTO gofl_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","Gaadape Ragu7eela na7aa Elyaasafa; ");
INSERT INTO gofl_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","Niftaalemepe Enaana na7a Akira; ");
INSERT INTO gofl_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Ha asay banta aawata keethaa asaape kaalethanaw dooretida Isra7eele yarata halaqata” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Yaatin Museynne Aaroni he dooretida asata ekidi, ");
INSERT INTO gofl_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","nam7antho ageenan koyro gallasan kumetha maabara xeegidi shiishidosona. Asay banta kochan kochan, qassi banta soo asan asan laatamu laythinne iyape bolla gidida adde ubbay xaafetis. ");
INSERT INTO gofl_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Goday iya Kiittidaysada Musey enta Siina mela biittan taybis. ");
INSERT INTO gofl_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","21","Oletanaw danda7iya adde ubbay, laatamu laythinne iyape bolla gidida adde ubbay taybetidi huuphen huuphen xaafetidosona. Enti banta kochan kochaaninne banta soo asan shaaketidi haysafe kaallidi de7iya taybo maaran mazgabetidosona. Bayra na7aa Robeelape 46,500 ");
INSERT INTO gofl_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","23","Simoonape 59,300 ");
INSERT INTO gofl_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","25","Gaadape 45,650 ");
INSERT INTO gofl_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","27","Yihudape 74,600 ");
INSERT INTO gofl_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","29","Yisakoorape 54,400 ");
INSERT INTO gofl_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","31","Zabloonape 57,400 ");
INSERT INTO gofl_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","33","Yoosefa na7aa Efreemape 40,500 ");
INSERT INTO gofl_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","35","Yoosefa na7aa Minaasepe 32,200 ");
INSERT INTO gofl_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","37","Biniyaamepe 35,400 ");
INSERT INTO gofl_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","39","Daanepe 62,700 ");
INSERT INTO gofl_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","41","Aseerape 41,500 ");
INSERT INTO gofl_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","43","Niftaalemepe 53,400 ");
INSERT INTO gofl_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Musey, Aaroninne banta soo asaape asaape dooretida tammanne nam7u Isra7eele kochaa halaqati taybida asay haysata. ");
INSERT INTO gofl_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Oletanaw danda7iya adde ubbay, laatamu laythinne iyape bolla gidida asay banta soo asan asan taybetidosona. ");
INSERT INTO gofl_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Kumetha asaa tayboy 603,550. ");
INSERT INTO gofl_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Shin Leewe kochati taybetibookona. ");
INSERT INTO gofl_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Gaasoyka kase Goday Museko haysada yaagis; ");
INSERT INTO gofl_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Leewe kochata taybopa; enta attida Isra7eele asaa taybon gelsofa. ");
INSERT INTO gofl_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Leeweta, Geeshsha Dunkaaniyaninne iyan de7iya miisheta ubbaa bolla halaqa oothada shuuma. Enti Dunkaaniyanne iyan de7iya miisheta tookana; iya giddon oothananne iya yuushon dunkaanana. ");
INSERT INTO gofl_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Geeshsha Dunkaaney shodetiya wode Leeweti shoddo; Geeshsha Dunkaaney eqiya wode Leeweti esso; entafe hari oonika iyako shiiqiko hayqo. ");
INSERT INTO gofl_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Hanko Isra7eele asay banta heeraninne banta cugan cugan shaaketidi, banta dunkaaniya dunkaanona. ");
INSERT INTO gofl_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Shin Godaa hanqoy Isra7eele maabara bolla wodhonna mela Leeweti Dunkaaniya yuushuwan banta dunkaaniya dunkaanidi naago” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Isra7eele asay Goday Muse kiitida ubbaa oothidosona. ");
INSERT INTO gofl_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Goday Musenne Aarona haysada yaagis; ");
INSERT INTO gofl_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","Isra7eele asay banta kochan kochan mallanne banta kocha kocha erisiya bandira kaallidi, Geeshsha Dunkaaniyape guuthi haakidi iya yuushuwan dunkaanona. ");
INSERT INTO gofl_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Doloha baggara Yihuda kochay banta malla kaallidi dunkaanona. Yihuda kochaa kaalethey Amnadaabe na7aa Na7asoona. ");
INSERT INTO gofl_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Iya cugaa tayboy 74,600. ");
INSERT INTO gofl_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Yihuda gakidi dunkaananay Yisakoore kochaa. Yisakoora kochaa kaalethey Zu7ara na7aa Natina7eela. ");
INSERT INTO gofl_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Iya cugaa tayboy 54,400. ");
INSERT INTO gofl_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Iyape kaallidi Zabloona kochay dunkaanees. Zabloona kochaa kaalethey Heloona na7aa Eli7aaba. ");
INSERT INTO gofl_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Iya cugaa tayboy 57,400 ");
INSERT INTO gofl_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Yihuda baggan dunkaanida olanchota tayboy 186,400. Isra7eele asay gutaa yeddidi biya wode koyroti keyey enta. ");
INSERT INTO gofl_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Dugeha baggara Robeela kochay banta malla kaallidi dunkaanona. Enta kaalethey Sadiyoora na7aa Elisuura. ");
INSERT INTO gofl_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Iya cugaa tayboy 46,500. ");
INSERT INTO gofl_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Robeela gakidi dunkaaney Simoona kochaa. Simoona kochaa kaalethey Zurishadaya na7a Salumi7eela. ");
INSERT INTO gofl_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Iya cuga tayboy 59,300. ");
INSERT INTO gofl_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Iyape kaallidi Gaade kochay dunkaanees. Enta kaalethey De7u7eela na7aa Eliyasaafa. ");
INSERT INTO gofl_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Enta cugaa tayboy 45,650. ");
INSERT INTO gofl_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Robeela, baggan dunkaanida olanchota tayboy 151,450. Isra7eele asay gutaa yeddidi biya wode nam7antho keyey enta. ");
INSERT INTO gofl_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Hessafe guye, koyro keyiya Yihuda cugaapenne nam7antho keyiya Robeela cugaape giddon Geeshsha dunkaaniya tookidi Leeweti geloosona. Issi issi kochay banta dunkaanida maaran banta malla oykidi keyo. ");
INSERT INTO gofl_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Wuloha baggara Efreema baggay banta malla kaallidi dunkaanona. Entana kaalethey Amhuda na7aa Elishama7a. ");
INSERT INTO gofl_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Enta cugaa tayboy 40,500. ");
INSERT INTO gofl_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Enta gakidi Minaase kochay dunkaanees. Entana kaalethey Padazuura na7aa Gamali7eela. ");
INSERT INTO gofl_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Enta olanchota tayboy 32,200. ");
INSERT INTO gofl_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Iyape kaallidi dunkaaney Biniyaame kochaa. Biniyaame kochaa kaalethey Gidi7oona na7aa Abdaana. ");
INSERT INTO gofl_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Enta cugaa tayboy 35,400. ");
INSERT INTO gofl_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Efreema baggan dunkaanida olanchota tayboy 108,100. Isra7eele asay gutaa yeddidi biya wode heedzantho keyey enta. ");
INSERT INTO gofl_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Pudeha baggara Daane kochay banta malla kaallidi dunkaanona. Entana kaalethey Amsadaya na7aa Aki7ezera. ");
INSERT INTO gofl_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Enta cugaa tayboy 62,700. ");
INSERT INTO gofl_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Entana gakidi Aseera kochay dunkaanees. Aseera kochaa kaalethey Okraana na7aa Pagi7eela. ");
INSERT INTO gofl_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Enta cugaa tayboy 41,500. ");
INSERT INTO gofl_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Iyape kaallidi Niftaaleme kochay dunkaanees. Niftaaleme kochaa kaalethey Enaana na7aa Akira. ");
INSERT INTO gofl_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Enta cugaa tayboy 53,400 ");
INSERT INTO gofl_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Daane baggan dunkaanida olanchota tayboy 157,600. Isra7eele asay gutaa yeddidi biya wode wursethan keyey enta. ");
INSERT INTO gofl_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Banta kochan kochan shaaketidi taybetida Isra7eele olanchota tayboy 603,550. ");
INSERT INTO gofl_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Shin Goday Muse kiitidaysada, Leeweti hara Isra7eele asaara taybetibookona. ");
INSERT INTO gofl_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Isra7eele asay, Goday Muse Kiittidaba ubbaa oothidosona. Enti banta mala kaallidi dunkaanidosona; qassi banta kochaanne banta soo asaa asaa kaallidi keyoosona. ");
INSERT INTO gofl_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Goday Siina zuma bolla Musera odetiya wode de7iya Aaronanne Muse soo asay haysafe kaallidi xaafetidaysa. ");
INSERT INTO gofl_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Aarona adde nayta sunthay, bayray Nadaaba, kaalley Abyooda, Alaazaranne Itamaara. ");
INSERT INTO gofl_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","He Aarona adde nayti ubbay, kahine gididi oothanaw tiyetidi shuumetidosona. ");
INSERT INTO gofl_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Shin enta giddofe Naadabeynne Abyoodi Siina mela biittan Godaa sinthan geeshshi gidonna taman yarsho yarshidi hayqidosona. Entaw na7i baawa. Hessa gisho, enta aaway Aaroni paxa de7ida laytha ubban Alaazarinne Itamaara xalaali kahine gididi oothidosona. ");
INSERT INTO gofl_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Goday Museko, ");
INSERT INTO gofl_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Leewe kochata ehada kahiniya Aarona maaddana mela enta iya sinthe shiisha. ");
INSERT INTO gofl_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Enti Aaronanne Isra7eele maabara ubbaa Geeshsha Dunkaaniya sinthan dumma dumma ooso oothidi maaddo. ");
INSERT INTO gofl_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Enti Geeshsha Dunkaaniya giddon de7iya miishe ubbaa aawatethan ayso. Isra7eele asaa gisho Geeshsha Dunkaaniya giddon ooso ubbaa enti oothonna. ");
INSERT INTO gofl_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Aaronanne iya adde nayta maadana mela Leeweta shuuma. Enti Isra7eele asaa giddofe shaaketidi Aarona maaddana mela imetidosona. ");
INSERT INTO gofl_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Aaronanne iya adde nayta kahine oothada shuuma. Entafe hara asi oonika Geeshsha dunkaaniyako shiiqiko hayqo” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Qassi Goday Museko, ");
INSERT INTO gofl_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“Taani Isra7eelen yeletiya bayra adde nayta gisho Leeweta ekas. Leeweti tabaa. ");
INSERT INTO gofl_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Ayis giiko, bayra yeletida ubbay tabaa. Ta Gibxe biittan bayra yeletida ubbaa wodhida gallasan, Isra7eelen bayra yeletidaba ubbaa ase gidin, mehe gidin, taw dummayas. Enti tabaa gidana. Taani Godaa” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Qassika Goday Museko Siina mela biittan, ");
INSERT INTO gofl_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“Leeweta enta kochan, qassi enta soo asan asan tayba. Yeletin issi ageenanne iyape bolla gidida adde nayta ubbaa tayba” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Yaatin Goday kiitidaysada Musey enta taybis. ");
INSERT INTO gofl_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Leewe adde nayti Gedisoona, Qahatanne Maraara. ");
INSERT INTO gofl_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Gedisoona adde nayti Libinanne Same7a geetetoosona. ");
INSERT INTO gofl_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Qahaata adde nayti Amraama, Yizihaara, Kebroonanne Uzi7eela. ");
INSERT INTO gofl_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Meraara adde nayti Mahilanne Musa geetetoosona. Leeweta mayzati haysata. ");
INSERT INTO gofl_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Nam7u Gedisoona kochati Libinanne Sim7a. ");
INSERT INTO gofl_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Yeletin issi ageenanne iyape bolla gidida adde nayta tayboy 7,500. ");
INSERT INTO gofl_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Gedisoona kochati Geeshsha Dunkaaniyape guyen wuloha baggan dunkaanidosona. ");
INSERT INTO gofl_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Gedisoona kochaa soo asaa halaqay La7eela na7aa Eliyasaafa. ");
INSERT INTO gofl_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Gedisoona kochaas Geeshsha Dunkaaniya bolla de7iya aawatethay, Dunkaaniya, gaatha kamaa, kare kamaa, wula magarajuwa, ");
INSERT INTO gofl_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","Dunkaaniya yuushon de7iya dabaaba magarajuwa, yarsho bessa magarajuwa, dabaaba wula magarajuwa, wodorotanne iyan go7etiya miisheta ubbaa aawatethan aysoosona. ");
INSERT INTO gofl_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Qahaata kochati Amraama, Yizihaara, Kebroonanne Uzi7eela. ");
INSERT INTO gofl_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Yeletin issi ageenanne iyape bolla gidida adde nayta tayboy 8,600. Qahaata kochati Geeshsha Dunkaaniya aawatethan naagoosona. ");
INSERT INTO gofl_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Qahaata kochati Geeshsha Dunkaaniyape dugeha baggara dunkaanidosona. ");
INSERT INTO gofl_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Qahaata kochaa kaalethey Uzi7eela na7aa Elzafaana. ");
INSERT INTO gofl_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Enti Taabotiya, xarpheeza, xompe wothiya kocaa, yarshsho bessaa, kahineti go7etiya Geeshsha Dunkaaniya miisheta, Ubbaafe Geeshsha Bessaa geliya wula bolla de7iya magarajuwa aawatethan ayso. ");
INSERT INTO gofl_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Leeweta halaqay kahiniya Aarona na7aa Alaazara. I Geeshsha Bessan ootheysatas shuuma. ");
INSERT INTO gofl_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Meraara kochati Mahilanne Musa. ");
INSERT INTO gofl_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Yeletin issi ageenanne iyape bolla gidida adde nayta tayboy 6,200. ");
INSERT INTO gofl_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Meraara kochaa kaalethey Abikaala na7aa Zur7eela. Meraara kochay Geeshsha Dunkaaniyape pudeha baggara dunkaanidosona. ");
INSERT INTO gofl_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Meraara kochay Dunkaaniya tuuqeta, liyoota, tuussatanne tuussati eqiya gedata, hessadaka giddon koshshiya miisheta ubbaa enti aawatethan aysoosona. ");
INSERT INTO gofl_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","Gujidika, Dunkaaniya yuushon de7iya dabaaba tuussatanne enta gedata, dhishetanne wodorota aawatethan aysoosona. ");
INSERT INTO gofl_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Geeshsha Dunkaaniya sinthan doloha baggara Musey, Aaroninne iya adde nayti dunkaanidosona. Geeshsha Dunkaaniya giddon Isra7eela asaa gisho oosetiya ooso ubbaa enti aawatethan aysoosona. Hara asi Geeshsha Dunkaaniyako shiiqiko hayqo. ");
INSERT INTO gofl_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Goday, Musenne Aarona Kiittidaysa mela issi ageenanne iyape bolla gidida Leeweta adde nayta tayboy 22,000. ");
INSERT INTO gofl_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Goday Museko, “Yeletin issi ageenanne iyape bolla gidida Isra7eele bayra adde nayta taybada enta suntha xaafa. ");
INSERT INTO gofl_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Isra7eele bayra adde nayta bessan Leeweta, qassi Isra7eele bayra mehiya bessan Leeweta bayra mehiya taw eka. Taani Godaa” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Goday Muse kiitidaysada Isra7eelen bayra yeletida ubbaa taybis. ");
INSERT INTO gofl_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Yeletin issi ageenanne iyape bolla gidida bayra adde nayta tayboy 22,273. ");
INSERT INTO gofl_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Goday Museko, ");
INSERT INTO gofl_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Isra7eele bayra adde nayta bessan Leeweta taw dummaya. Qassi Isra7eele bayra meheta bessan Leeweta bayra mehiya taw dummaya; taani Godaa. ");
INSERT INTO gofl_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Isra7eele bayra adde nayta tayboy Leeweta bayra adde nayta taybuwape 273 aadhiya gisho he attidaysata taw woza. ");
INSERT INTO gofl_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","Issuwas issuwas geeshsha dunkaanen eretida mizaanen ichashu bira santimen woza. ");
INSERT INTO gofl_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","He wozo miishiya Aaronasinne iya adde naytas imma” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Palahidaysata wozo miishiya Musey shiishis. ");
INSERT INTO gofl_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Geeshsha Dunkaaniya mizaaniya liken Isra7eele bayra adde nayta wozo miishiya 1,365 bira santime ekis. ");
INSERT INTO gofl_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Goday kiitidaysada Musey wozo miishiya Aaronasinne iya adde naytas immis. ");
INSERT INTO gofl_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Goday Musenne Aarona haysada yaagis; ");
INSERT INTO gofl_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Leewe kochatape Qahaata kochatanne enta soo asaa asaa shaakada tayba. ");
INSERT INTO gofl_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Laythi 30-50 gakida adde ubbaa Geeshsha Dunkaaniyan oothanaw danda7eyisata tayba. ");
INSERT INTO gofl_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Qahaata kochati Geeshsha Dunkaaniyan oothana oosoy Dunkaaniyan go7etiya geeshsha miisheta aawatethan naago. ");
INSERT INTO gofl_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","“Asay gutaape baanaw dendiya wode Aaroninne iya adde nayti Geeshsha Dunkaaniya giddo gelidi, Caaqo Taabotiya sinthan de7iya magarajuwa wodhisidi he Caaqo Taabotiya iyara xaaxo. ");
INSERT INTO gofl_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","He kamaa bolla liiqo galba kammo; iya bolla gujidi kaalose carqe kammo; tookiya kasota sagaayotan aatho. ");
INSERT INTO gofl_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","“Godaas shiiqiya uytha wothiya xarpheezaa bolla kaalose carqe kammo. Xarpheeza bolla saaneta, cilpata, xuu7atanne woyne ushsha yarshuwa duuqiya otota wothona. Uythay ubba wode xarpheeza bolla de7o. ");
INSERT INTO gofl_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","He ubbaa bolla zo7o carqe kammidi iya bolla qassi liiqo galba kammo; hessafe kaallidi tookiya kasota sagaayotan aatho. ");
INSERT INTO gofl_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“Kaalose carqe ekidi xompe wothiya kocaa, iya xompetara, iya qaphetara, bido kessiya keretaranne zayte tigiya xaarotara ubbaa kammo. ");
INSERT INTO gofl_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Yaatidi iya miisheta ubbaa liiqo galban kammidi tookiya arsa bolla wothona. ");
INSERT INTO gofl_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","“Kaallidi worqa yarsho saaxiniya kaalose carqen kammo; qassi iya bollara liiqo galba yeggo. Yaatidi tookiya kasota sagaayotan aatho. ");
INSERT INTO gofl_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Hessadaka, Geeshsha Dunkaaniya giddon go7etiya miisheta ubbaa kaalose carqen xaaxo; iya bolla liiqo galba yeggidi, tookiya alga bolla wotho. ");
INSERT INTO gofl_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","“Naase yarsho bessaafe biduwa pitidi iya bolla ocha teera daaniya carqe kammo. ");
INSERT INTO gofl_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Yarsho bessan go7etiya miisheta ubbaa; tama cooceta, asho qapheta, akaafatanne haatha kereta iya bolla wothidi, liiqo galba kammo. Yaatidi tookiya kasota sagaayotan aatho. ");
INSERT INTO gofl_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Aaroninne iya adde nayti, geeshshabatanne iyan go7etiya geeshsha miisheta ubbaa kammidaape guye Isra7eele asay gutaape dendiya wode Qahaata kochay yidi tooko. Shin enti hayqonna mela geeshsha miisheta bochofo. Geeshsha Dunkaaney bessaafe dendiya wode qahaata kochaas de7iya aawatethay haysa. ");
INSERT INTO gofl_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“Kahiniya Aarona na7ay Alaazari xompe zaytiya, sawiya ixaaniya, yarsho kathaanne tiyo zaytiya, hessadaka Geeshsha Dunkaaniyan de7iya dumma dumma geeshsha miisheta ubbaa bolla aawatethi de7ees” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Goday Musekonne Aaronako, ");
INSERT INTO gofl_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Qahaata kochay Leewe kochaa giddofe hayqidi dhayana mela oothopite. ");
INSERT INTO gofl_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Ubbaafe Geeshsha miishiyako shiiqidi hayqonna mela Aaroninne iya adde nayti Geeshsha Dunkaaniya giddo gelidi, Qohaata kochay huuphen huuphen oothana oosuwanne tookana toohuwa shaakidi besso. ");
INSERT INTO gofl_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Qahaata kochay hayqonnaada geeshsha miisheta be7anaw guutha wodeska Dunkaaniya giddo gelopo” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Goday Museko, ");
INSERT INTO gofl_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Leewe kochaafe Gedisoona kochaanne enta soo asaa asaa shaakada tayba. ");
INSERT INTO gofl_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Laythi 30-50 gakida adde ubbaa Geeshsha Dunkaaniya giddon oothanaw danda7eyisata tayba. ");
INSERT INTO gofl_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Gedisoona kochati oothana oosoy haysafe kaallidi de7eysa; ");
INSERT INTO gofl_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","enti Geeshsha Dunkaaniya gaatha kamaa, kare kamaa, bollara yegetiya liiqo do7a galba, geliya wula bolla kaqetiya magarajuwa tooko. ");
INSERT INTO gofl_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","Hessadaka Geeshsha Dunkaaniyanne yarsho bessa yuushuwan de7iya dabaaba magarajota, dabaaba geliya wula bolla de7iya gesheta, wodorotanne iyaw go7etiya miisheta ubbaa tooko. Gedisoona kochay miishetan oothanaw bessiya ooso ubbaa ootho. ");
INSERT INTO gofl_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Tooho gidin, hara ooso gidin, enti oothiya ooso ubbaa Aaroninne iya adde nayti enta kaalli oosiso. Enti tookanaw bessiyabata ubbaa ne aawatethan entaw gisha. ");
INSERT INTO gofl_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Geeshsha Dunkaaniya giddon Gedisoona kochay oothana oosoy haysa. Enta oosuwa kahiniya Aarona na7ay Itamaari kaallidi oosiso. ");
INSERT INTO gofl_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“Leewe kochaafe Meraara kochaanne enta soo asaa asaa shaakada tayba. ");
INSERT INTO gofl_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Laythi 30-50 gakida adde ubbaa Geeshsha Dunkaaniya giddon oothanaw danda7eyisata tayba. ");
INSERT INTO gofl_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","“Enti Dunkaaniya tuuqeta, liyoota, tuussata, Dunkaaniya gedata, ");
INSERT INTO gofl_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","Dunkaaniya yuushon dabaaban eqiya tuussata, he tuussata gedata, dhisheta, wodorotanne iyan koshshiya miisheta ubbaa tooko. Issoy issoy tookanaw bessiya miishiya iya sunthan shaakada gisha. ");
INSERT INTO gofl_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Geeshsha Dunkaaniya giddon Meraara kochay oothana oosoy haysa. Enti oothana ooso ubbaa kahiniya Aarona na7aa Itamaari aawatethan kaallidi oosiso” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Musey, Aaroninne Isra7eele halaqati Qahaata kocha enta soo asan asan shaakidi taybidosona. ");
INSERT INTO gofl_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","Laythi 30-50 gakida adde ubbaa Geeshsha Dunkaaniya giddon oothanaw danda7eyisata taybidosona. ");
INSERT INTO gofl_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","Enta tayboy 2,750. ");
INSERT INTO gofl_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Goday Muse kiitidaysada Geeshsha Dunkaaniya giddon oothana mela Museynne Aaroni taybida Qahaata kochati haysata. ");
INSERT INTO gofl_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Gedisoona kochati banta soo asan asan shaaketidi taybetidosona. ");
INSERT INTO gofl_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","Laythi 30-50 gakida addeti ubbaa Geeshsha Dunkaaniya giddon oothanaw danda7eyisata ");
INSERT INTO gofl_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","tayboy 2,630. ");
INSERT INTO gofl_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Goday Muse kiitidaysada Geeshsha Dunkaaniya giddon oothana mela Museynne Aaroni taybida Gedisoona kochati haysata. ");
INSERT INTO gofl_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Meraara kochati banta soo asan asan shaaketidi taybetidosona. ");
INSERT INTO gofl_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","Laythi 30-50 gakida addeti ubbay, Geeshsha Dunkaaniya giddon oothanaw danda7eyisata ");
INSERT INTO gofl_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","tayboy 3,200. ");
INSERT INTO gofl_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Goday Muse kiitidaysada Geeshsha Dunkaaniya giddon oothana mela Museynne Aaroni taybida Meraara kochati haysata. ");
INSERT INTO gofl_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Musey, Aaroninne Isra7eele halaqati Leeweta ubbaa enta kochaaninne enta soo asan asan shaakidi tayba. ");
INSERT INTO gofl_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","Laythi 30-50 gakida addeti ubbay, Geeshsha Dunkaaniya giddon oothanawnune miisheta tookanaw danda7iya, ");
INSERT INTO gofl_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","Leeweta tayboy 8,580. ");
INSERT INTO gofl_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Goday Muse kiitidaysada, enti huuphen huuphen taybetidosona. Hessadaka Goday Muse kiitidaysada enti oothana oosoynne tookana toohoy imetis. ");
INSERT INTO gofl_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Goday Museko, ");
INSERT INTO gofl_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Isra7eele asay baro hargen oyketida asi woyko asatethafe goggiyabay de7iya asi woyko aha bochidi tunida asi oonaka banta gutaape kessana mela kiita. ");
INSERT INTO gofl_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Ta enta giddon de7iya gutaa tunisonna mela ha geeshshi gidonna asati macca gidin adde enta giddofe kessada goodda” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Goday Muse kiitidaysada Isra7eele asay enta ubbaa gutaape kessidi gooddidosona. ");
INSERT INTO gofl_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Goday Museko, ");
INSERT INTO gofl_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“Neeni Isra7eele asaas haysa oda; adde gidin woyko macci gidin oonika Godaas ammanetona ixidi hara asi naaqiko he uray bala oothis. ");
INSERT INTO gofl_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","I ba nagara paaxo; ba nagara acciya kumetha aca bolla xeetape laatamu kushe gujidi I naaqida uraas ciggo. ");
INSERT INTO gofl_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Shin he naaqetida uray hayqidaba gidiko, aca ekanaw mata dabboy iyaw dhayko, he acay Godaas gididi kahiniyas imeto. He aca bolla gujidi iya nagara atotethas qoho yarshos gidiya maraze dorsi immo. ");
INSERT INTO gofl_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Qassi Isra7eele asay Godaas immiya geeshsha imo ubbay he kahiniyas gido. ");
INSERT INTO gofl_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Issi issi asi immiya geeshsha imotay he uraaba, shin kahiniyas immiko he imotay kahiniyasa” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Goday Museko, ");
INSERT INTO gofl_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“Isra7eele asaas yaagada oda; issi addiya machiya kare hemetada iyaw ammanetona ixiko, ");
INSERT INTO gofl_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","hara addera aqiko, qassi hessa iya ba azinaape qosiko, iya laymatishin be7ida marki baynaba gidiko, ");
INSERT INTO gofl_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","I azinay iyo tunasu gidi sidhiko, woyko iya tunonna de7ishin I ba machiw sidhiko, ");
INSERT INTO gofl_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","he addey ba machiw kahiniyako efo. I gisho yarshanaw issi kilo giraame banga dhiille efo. He addey ba machiw sidhida gisho, I qohuwa qoncisiya katha yarsho gidiya gisho, dhiilliya bolla zayte tigopo; ixaane iya bolla wothofo.” ");
INSERT INTO gofl_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Kahiney he maccasiw Godaa sinthan esso. ");
INSERT INTO gofl_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Geeshsha haathi keren eko. Geeshsha Dunkaaniya wuygiyape biitta ekidi he haathan gujo. ");
INSERT INTO gofl_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","He maccasiw Godaa sinthan esso; he maccase huuphiya billidi sidhida gisho yarshetiya qohuwa qoncisiya katha yarsho I kushen wotho; qassi kahiney ba kushen baadethi ehiya camo haatha keren oyko. ");
INSERT INTO gofl_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Hessafe guye, maccasiw yaagidi caaqiso; “Neeni hara addera aqabonaba gidiko, nenatethaa tunisaboonaba gidiko, baadethi ehiya haathay new gome gidopo. ");
INSERT INTO gofl_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Shin neeni ne azina aggada hara addera aqada tunidaba gidiko, ");
INSERT INTO gofl_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","Goday ne yelo keetha gundisidi, ne uluwa gabbisidi ne asaa sinthan nena baadetidaba ootho. ");
INSERT INTO gofl_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Ha baadethi ehiya haathay ne uluwan gelidi ne uluwa gabbiso; ne yelo keethaa gundiso” yaagidi caaqiso. Maccasiya, “Amin7i, hessi tana gako” yaago. ");
INSERT INTO gofl_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“Haysafe guye, kahiney he baadetha xaafo; he xaafidaysa keriyan de7iya haathan meecco. ");
INSERT INTO gofl_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Qangethi ehiya haatha maccasiw ushshanaape sinthe, ");
INSERT INTO gofl_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","kahiney maccase kushepe yarsho dhiilliya ekidi, dentho yarsho oothidi Godaas yarsho. ");
INSERT INTO gofl_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Kahiney yarsho kathaafe zolle ekidi bala qoncisiya yarsho oothidi yarsho bessan xuuggo. Hessafe guye, maccasiw he haatha ushsho. ");
INSERT INTO gofl_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Iya ba azinaas ammanetona ixada tunidaba gidiko baadetha haathay I uluwan camo saho medho. I uloy gabbana; I yelo keethayka gundana; iya ba asaa giddon baadetidaaro gidana. ");
INSERT INTO gofl_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Iya tunaboonabanne xillo maccas gidiko, iya geeshshi gidana; na7a yelanaw danda7awusu. ");
INSERT INTO gofl_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","30","“Issi asi ba machiw laymatasu gidi sidhiko woyko qaanatiko yarsho bessi ehidi iyo esso. Kahiney he wogaa ubbaa I bolla polo. ");
INSERT INTO gofl_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Azinay, qohoy baynaba gidana, shin macciya ba nagaraa gaason gakiya waaye ubbaa tookana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Goday Museko, ");
INSERT INTO gofl_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“Isra7eele asaa haysada gada kiita; adde gidin woyko macca bana Godaas dummayidi Naazirawe gidanaw qangiko, ");
INSERT INTO gofl_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","woyne woyko hara mathoyiya ushshi uyopo. Caalabanne mathoyaba uyopo; woyne teera, tiyanne mela moopo. ");
INSERT INTO gofl_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","I bana Godaas dummayida wode ubban, woyne ayfiya gidin poquwa gidin woyko kochaa gidin moopo. ");
INSERT INTO gofl_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“I bana Godaas dummayida wode ubban, ba huuphiya meedetofo woyko qanxetofo. I ba huuphe binaana adussidi dicho. I bana Godaas dummayida wodey poletana gakanaw geeshshi gidanaw koshshees. ");
INSERT INTO gofl_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","I bana Godaas dummayida woden ubban ahako shiiqopo. ");
INSERT INTO gofl_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","I bana dummayidaysa erisey iya huuphiya gidiya gisho, iya aaway woyko iya aayiya woyko iya ishay woyko iya michiya hayqiko enta aha bochidi bana tunisopo. ");
INSERT INTO gofl_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","I bana Godaas dummayida wode ubban Godaas geeshshi. ");
INSERT INTO gofl_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“Asi iya matan qoponna hayqiko, Godaas geeshshi gidida ba huuphiya tunisiko laapun gallas gam7idi ba huuphiya meedeto. ");
INSERT INTO gofl_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Hospuntha gallasan nam7u holleta woyko nam7u kuraachota Geeshsha Dunkaaniya pengen de7iya kahiniyas eho. ");
INSERT INTO gofl_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Naazirawey aha bochidi tunida gisho nagarape iya geeshshanaw kahiney holletape issuwa nagara yarsho, hankuwa qassi xuussa yarsho oothidi yarsho. He gallas I ba huuphiya wogaada zaaridi Godaas geeshsho; ");
INSERT INTO gofl_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","I bana zaaridi Godaas dummayo. Yaatidi issi laytha maraze naaqo yarsho oothidi yarsho. I Godaas dummayida huuphey tunida gisho, kase I bana Godaas dummayidi de7ida wodey taybetenna. ");
INSERT INTO gofl_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“Issi naazirawey ba qangetha wodiya ongida wode polana wogay haysa; Geeshsha Dunkaaniya penge bidi; ");
INSERT INTO gofl_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","borey bayna issi laytha dorsa urge xuussa yarshos, issi laytha uzzo dorsi nagara yarshos, issi maraze issifetetha yarshos he bessaa eho. ");
INSERT INTO gofl_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","Qassi katha yarshonne ushsha yarsho entara issife yarshanaw eho. He katha yarshoy irshoy geliboonna lo77o dhiille shamaho zaytera uuketida orde uythinne shamaho zayten tiyetida lee7o gaytan eho. ");
INSERT INTO gofl_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","“Kahiney he ubbaa nagara yarshonne xuussa yarsho oothidi Godaas yarsho. ");
INSERT INTO gofl_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Kahiney maraziya gaytan de7iya uythaara Godaas issifetetha yarsho oothidi yarsho; kaallidi katha yarshuwanne ushsha yarshuwa yarsho. ");
INSERT INTO gofl_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Naazirawey Godaas dummayida ba huuphiya Geeshsha Dunkaaniya pengen meedetidi, binaana issifetetha yarshoy eexiya taman yeggo. ");
INSERT INTO gofl_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","“Naazirawey ba huuphiya meedetidaape guye, kahiney doysetida maraziya gedaa ashuwa gaytan de7iya orde uythaafenne lee7o uythaafe ekidi, Naazirawiya kushen wotho. ");
INSERT INTO gofl_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Yaatidi kahiney he ubbaa yuusho yarsho oothidi, Godaas yarsho. He ubbay kahiniya gisho gidiya angaasuwaranne gedaara kahiniyas geeshsha yarsho gidees. Hessafe Godaas Naazirawey woyne ushsha uyo. ");
INSERT INTO gofl_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Hiza Godaas bana dummayida Naazirawey oothana mela imetida wogay haysa. Shin naazirawey yarshanaw koshshiya yarshotape aathidi immanaw qangidaba gidiko, ba qangetha gathanaw koshshees” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Goday Museko, ");
INSERT INTO gofl_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Aaroninne iya adde nayti Isra7eele asaa anjiya wode haysada yaagidi anjite yaaga; ");
INSERT INTO gofl_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","“ ‘Goday hintena anjo, Goday hintena naago; ");
INSERT INTO gofl_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Goday ba som7uwa hintew poo7iso; I hintew qadheto; ");
INSERT INTO gofl_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Goday ba keeha ayfiyan xeello; I hintew sarotethi immo’ yaagidi anjite” yaaga. ");
INSERT INTO gofl_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","“Enti Isra7eele asaa ta sunthan anjiya wode ta enta anjana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Musey Geeshsha Dunkaaniya tokidi ongida wode he Dunkaaniyanne iya miishiya, yarsho bessaanne iya miishiya ubbaa zayten tiyidi geeshshis. ");
INSERT INTO gofl_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Hessafe guye, Isra7eele asaa kochan kochan taybidi kaalethiya wode halaqa gidida ubbay, ");
INSERT INTO gofl_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Godaas imota shiishidosona. Enti immida imotay nam7u halaqa sunthan issi para gaare, qassi issi issi halaqa sunthan issi issi booru oothidi, usupun gaaretanne tammanne nam7u boorata Geeshsha Dunkaaniya ehidosona. ");
INSERT INTO gofl_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Goday Museko, ");
INSERT INTO gofl_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Geeshsha Dunkaaniya oosuwas go77ana mela neeni he imota entafe ekada, enta oosuwas oosuwas koshsheysada shaakada Leewetas imma” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Hessa gisho, Musey gaaretanne boorata ekidi Leewetas immis. ");
INSERT INTO gofl_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Gedisoona kochaas koshsheysada shaakidi enta oosuwas nam7u gaaretanne oyddu boorata immis. ");
INSERT INTO gofl_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Meraara kochaas koshsheysada shaakidi, enta oosuwas uyddu gaaretanne hospun boorata immis. Enta oosuwa aawatethan kaalethey kahiniya Aarona na7aa Itamaara. ");
INSERT INTO gofl_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Shin Qahaata kochaa oosoy Dunkaaniya geeshsha miisheta hashen toho gidiya gisho Musey entaw para gaarenne booru immibeenna. ");
INSERT INTO gofl_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Musey yarsho bessi Godaas dummayida gallas halaqati yarsho bessa sinthe banta imota ehidosona. ");
INSERT INTO gofl_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Goday Museko, “Issi issi gallas issi issi halaqay yarsho bessi Godaas dummayanaw ba imota immo” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Koyro gallas ba imota ehiday Yihuda kochaafe Amnadaabe na7aa Na7asoona. ");
INSERT INTO gofl_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Na7asooni ehida imotay geeshsha dunkaanen eretida mizaanen 1,500 giraame birape oosetida picca Saane, 800 giraame birape oosetida ollatiya saane, nam7aaka katha yarsho yarshanaw zaytera walaketida lo77o dhiille kumidaysa; ");
INSERT INTO gofl_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","qassi 110 giraame worqafe oosetida ixaaney kumida shaate; ");
INSERT INTO gofl_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","xuussa yarshos, issi wofaano, issi maraze, issi laytha urge dorsi; ");
INSERT INTO gofl_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","nagara yarshos issi kole; ");
INSERT INTO gofl_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","issifetetha yarshos nam7u boorata, ichashu marazeta, ichashu koletanne ichashu urge dorsata ehis. Kaalliya hanko halaqatika Amnadaabe na7ay Na7asooni immidaysada banta imota ehidosona. ");
INSERT INTO gofl_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","23","Nam7antho gallasan Yisakoora kochaafe Zu7ara na7ay Natina7eeli ba imota ehis. ");
INSERT INTO gofl_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","29","Heedzantho gallasan Zabloona kochaafe Heloona na7ay Eli7aabi ba imota ehis. ");
INSERT INTO gofl_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","35","Oyddantho gallasan Robeela, kochaafe Shade7ura na7ay Elizuuri ba imota ehis. ");
INSERT INTO gofl_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","40","Ichashantho gallasan Simoona kochaafe Zurishadaya na7ay Salumi7eeli ba imota ehis. ");
INSERT INTO gofl_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","47","Usupuntho gallasan Gaade kochaafe Ragu7eela na7ay Eliyasaafi ba imota ehis. ");
INSERT INTO gofl_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","53","Laapuntha gallasan Efreema kochaafe Amhuda na7ay Elishama7i ba imota ehis. ");
INSERT INTO gofl_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","59","Hospuntha gallasan Minaase kochaafe Padazuura na7ay Gamali7eeli ba imota ehis. ");
INSERT INTO gofl_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","65","Uddufuntho gallasan Biniyaame kochaafe Gida7oona na7ay Abdaani ba imota ehis. ");
INSERT INTO gofl_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","71","Tammantho gallasan Daane kochaafe Amsadaya na7ay Aki7ezeri ba imota ehis. ");
INSERT INTO gofl_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","77","Tammanne issintho gallasan Aseera kochaafe Okraana na7ay Pagi7eeli ba imota ehis. ");
INSERT INTO gofl_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","83","Tammanne nam7antho gallasan Niftaaleme kochaafe Enaana na7ay Akira ba imota ehis. ");
INSERT INTO gofl_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Yarsho bessay tiyetiya wode Godaas dummayanaw Isra7eele halaqati ehida imotay haysafe kaallidi de7eysa. Birape oosetida tammanne nam7u picca saanetanne ollatiya saaneta; worqafe oosetida tammanne nam7u ixaaney kumida shaateta ehidosona. ");
INSERT INTO gofl_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Issoy issoy 1,500 giraame birape oosetida picca Saane; qassi issoy issoy 800 giraame birape oosetida ollatiya saane, geeshsha dunkaanen eretida mizaanen he ubbaa 28 kilo giraame ehidosona. ");
INSERT INTO gofl_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Ixaaney kumida tammanne nam7u worqa shaateta 1.4 kilo giraame geeshsha dunkaanen eretida mizaanen shiishidosona. ");
INSERT INTO gofl_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Xuussa yarshos shiiqida mehey katha yarshuwara wolla tammanne nam7u wofaanota, tammanne nam7u maraze, tammanne nam7u issi laytha urge dorsinne, tammanne nam7u koleta nagara yarshos shiishidosona. ");
INSERT INTO gofl_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Issifetetha yarshos laatamanne oyddu boorati, usupun tammu marazeta, usupun tammu koleta, usupun tammu issi laytha urge dorsata shiishidosona. Geeshsha Dunkaaniya dummayanaw tiya wode shiiqida yarshoti haysata. ");
INSERT INTO gofl_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Musey Godaara odetanaw Geeshsha Dunkaaniya geliya wode caaqo taabotiya kamaa bolla de7iya nam7u kiruubetape giddon gididi Goday odishin si7is. ");
INSERT INTO gofl_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Goday Museko, ");
INSERT INTO gofl_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Aaroni laapun xompeta kocaa bolla wothiya wode poo7oy sintha baggara de7iya heera poo7isana mela oothidi wotho gada oda” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Goday Muse kiitidaysada, Aaroni xompeta kocaa bolla wothidi sintha baggara de7iya heera poo7isana mela oothis. ");
INSERT INTO gofl_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Xompe wothiya kocay, Goday Muse bessidaysada toomape bidi bolla ciishsha gakanaw qoxetida worqafe oosetis. ");
INSERT INTO gofl_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Goday Museko, ");
INSERT INTO gofl_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Isra7eele asaa giddofe Leeweta shaakada wogaada enta geeshsha. ");
INSERT INTO gofl_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Neeni enta geeshshanaw haysada ootha; geeshshiya haatha ekada enta bolla wurxa; enti banta asatethaa ubbaa meedeto; banta ma7uwa meecco; yaanidi enti wogaada geeshshi gidana. ");
INSERT INTO gofl_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Kaallidi enti issi wofaanonne katha yarshos gidiya zaytera walahetida lo77o dhiille eko; qassi neeni nagara yarshos hara issi wofaano eka. ");
INSERT INTO gofl_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Hessafe guye Isra7eele asa ubbaa shiishada, Leeweta Geeshsha Dunkaaniya sinthe ehada essa. ");
INSERT INTO gofl_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Isra7eele asay enta huuphiya bolla banta kushiya wotho. ");
INSERT INTO gofl_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Leeweti Isra7eele asaa giddofe taw dummatidi oothana mela yuusho yarsho oothidi Aaroni ta sinthe shiisho. ");
INSERT INTO gofl_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Leeweti banta kushiya nam7u wofaanota huuphen wotho. Leeweta nagara atotethas issuwa nagara yarsho, qassi hankuwa xuussa yarsho oothada Godaas yarsha. ");
INSERT INTO gofl_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","“Leeweta shaakada taw dummaya; Aaronanne iya adde nayta enta bolla shuuma. ");
INSERT INTO gofl_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Hessada oothada Leeweta Isra7eele asape taw dummaya; enti tabaa gidana. ");
INSERT INTO gofl_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","“Neeni enta geeshshidaapenne dummayidaape guye Leeweti Geeshsha Dunkaaniyan banta oosuwa oothanaw yo. ");
INSERT INTO gofl_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Isra7eele asaa giddofe kumethi enti taw imetidosona; Isra7eelen bayra yeletida adde nayta bessan Leeweta taw ekas. ");
INSERT INTO gofl_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Isra7eele asaa giddon bayra yeletida ase gidin mehe gidin ubbay tabaa. Taani Gibxe biittan bayra ubbaa wodhida wode enta taw dummayas. ");
INSERT INTO gofl_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Isra7eelen bayra yeletida adde nayta bessan taw Leeweta ekas. ");
INSERT INTO gofl_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Isra7eele asaa giddofe Leeweta Aaronasinne iya adde naytas immas. Isra7eele asay Geeshsha Dunkaaniyako shiiqidi qohetonna mela Leeweti Isra7eele asaa gisho Geeshsha Dunkaaniyan oothanawunne nagara atotethi ehanaw dooretidosona” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Goday Muse kiitidaysada, Musey, Aaroninne Isra7eele asa ubbay Leeweta dummayidosona. ");
INSERT INTO gofl_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Leeweti bantana geeshshidosona; banta ma7uwa meeccidosona. Aaroni enta Godaas dumma imo oothidi shiishis; entaw nagara atotethas yarshidi enta geeshshis. ");
INSERT INTO gofl_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Hessafe guye, Leeweti Aaronanne iya adde nayta aawatetha garsan gididi Geeshsha Dunkaaniya giddon banta oosuwa oothanaw yidosona. Goday Muse Leeweta dummayanaw kiitidaysada enti oothidosona. ");
INSERT INTO gofl_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Goday Museko, ");
INSERT INTO gofl_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“Haysi Leeweti oothana wogaa; laythi laatamanne ichashanne iyape bolla gidida Leewe adde ubbay Geeshsha Dunkaaniyan oothanaw yo. ");
INSERT INTO gofl_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Shin laythi ishatamu gidiya wode banta oosuwape shempo; zaari oothofo. ");
INSERT INTO gofl_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Enti Geeshsha Dunkaaniyan oothiya banta ishata oothi maaddanaw danda7oosona. Shin enti bantaw ay oosoka oothofo. Hiza neeni Leeweta haysada oosisa” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Isra7eele asay Gibxefe keyida nam7antho laythan koyro ageenan Siina mela biittan Goday Museko haysada yaagis; ");
INSERT INTO gofl_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“Isra7eele asay Paasika Ba7aale iya qamman boncho. ");
INSERT INTO gofl_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Ha ageenan tammanne oyddantho gallasan iya qamman omarsi iya woga ubbaadanne iya kiita ubbaada boncho” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Hessa gisho, Musey Isra7eele asay Paasika Ba7aale bonchana mela entaw odis. ");
INSERT INTO gofl_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Goday Muse kiitidaysada, Isra7eele asay koyro ageenan tammanne oyddantho gallasan, omarsi Siina mela biittan Paasika Ba7aale bonchidosona. ");
INSERT INTO gofl_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Shin entafe baggati aha bochidi tunida gisho he gallas Paasika Ba7aale bonchanaw danda7ibookona. Hessa gisho, enti he gallas Musekonne Aaronako yidi, ");
INSERT INTO gofl_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","“Nuuni aha bochida gisho tunida, shin he qamman hara Isra7eele asaara Godaas yarsho yarshonna mela ayis digetido?” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Musey zaaridi, “Goday hintebaa taw odana gakanaw gam7ishite” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Goday Museko, ");
INSERT INTO gofl_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“Isra7eele asaako haysada yaaga; hintefe woyko hinte kochaafe oonika aha bochidi tuniko woyko ogetidabaa gidiko, Paasika Ba7aale bonchanaw danda7ees. ");
INSERT INTO gofl_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Nam7antho ageenan tammanne oyddantho gallas omarsi Paasika Ba7aale boncho. Paasika dorsa uytharanne camo boncora mo. ");
INSERT INTO gofl_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Sa7ay wontana gakanaw dorsa ashuwape aybika attofo; qassi iya meqethafe issuwaka menthofo. Paasika Baaliya woga ubbaa ootho. ");
INSERT INTO gofl_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Shin geeshshinne ogetonna as Paasika bonchona ixiko, I ta asaa giddofe kuretto. Godaa yarshuwa iya qamman yarshiboona gisho ba nagaraa gisho pirda ekees. ");
INSERT INTO gofl_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“Hinte giddon de7iya bete asi Paasika Ba7aale bonchanaw koyko, Paasika wogaada boncho. Betanchoynne biitta aawu na7i ubbay he wogaatho ootho” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Geeshsha Dunkaaney toketida gallas shaaray Geeshsha Dunkaaniya ma7is. Omarsafe doomidi, wonta gakanaw Geeshsha Dunkaaniya bollara de7iya shaaray tama daanees. ");
INSERT INTO gofl_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Hessada gallas gallas shaaray ma77ees; qamma qamma he shaaray tamada poo7ees. ");
INSERT INTO gofl_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","He shaaray Geeshsha Dunkaaniya bollafe dendiya wode ubban Isra7eele asay banta dunkaanida gutaape dendoosona. Qassi he shaaray wodhiya bessan Isra7eele asay dunkaanosona. ");
INSERT INTO gofl_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Isra7eele asay Godaa kiitan gutaape dendoosona; qassi Godaa kiitan dunkaanosona. Shaaray Geeshsha Dunkaaniya bolla gam7iya wode ubban banta dunkaanida gutan gam7oosona. ");
INSERT INTO gofl_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Shaaray Geeshsha Dunkaaniya bolla daro gallas gam7ikoka, Isra7eele asay Godaa kiita naagosonape attishin, awuka bookona. ");
INSERT INTO gofl_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Issi issi toho shaaray Geeshsha Dunkaaniya bolla guutha gallas gam7ees. Gidikoka enti Godaa kiitan dunkaanosona; qassi Godaa kiitan gutaape dendoosona. ");
INSERT INTO gofl_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Issi issi toho shaaray omarsafe wontana gakanaw xalaala gam7ees; shaaray dendiya wode enti dendoosona. Gallas gidin, qamma gidin, shaaray dendiya wode enti dendoosona. ");
INSERT INTO gofl_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Shaaray Geeshsha Dunkaaniya bolla nam7u gallas gidin woyko issi ageena woyko issi laythi gam7in Isra7eele asay banta dunkaanida gutan gam7osonape attishin, bookona. Shin shaaray dendiya wode entika dendoosona. ");
INSERT INTO gofl_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Goday Muse Kiittidaysada enti Godaa kiitan dunkaanosona qassi Godaa kiitan gutaape dendidi boosona. ");
INSERT INTO gofl_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Goday Museko, ");
INSERT INTO gofl_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","asaa shiiqos xeeganawunne dunkaanida gutaape denthanaw maaddiya nam7u moyzeta birape qoxada medha. ");
INSERT INTO gofl_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Ha nam7u moyzeti punetiya wode asa ubbay Geeshsha Dunkaaniya pengen neeko shiiqo. ");
INSERT INTO gofl_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Shin issi moyze xalaali punetiko, Isra7eele kochaa halaqati ne sinthe shiiqo. ");
INSERT INTO gofl_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Moyzey koyro punetiya wode Geeshsha Dunkaaniyape doloha baggan dunkaanida kochay dendo. ");
INSERT INTO gofl_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Moyzey nam7antho punetiya wode dugeha baggan dunkaanida kochay dendo. Moyzey hessatho punetiya wode gutaape dendanaw malla gido. ");
INSERT INTO gofl_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Asa shiishanaw moyze punna, shin hankoysada dumma mallara punnofa. ");
INSERT INTO gofl_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Kahineti, Aarona nayti moyze punno. Haysi newunne yaana yeletetha ubbaas merina woga gido. ");
INSERT INTO gofl_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","“Hinte gadiya bolla ola denthida hinte morkiyara hinte oletanaw keyiya wode he moyzeta goochidi punnite. He wode Goday, hinte Xoossay hintena akeekidi, hinte morketape ashshana. ");
INSERT INTO gofl_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Hinte ufaysa gallasatan hessika ageena xeeron, eretida ba7aaletan, xuussa yarsho wodeninne issifetetha yarsho wode moyze punnite. Hessi Xoossaa sinthan hintena akeekisiyaba gidana. Taani Godaa, hinte Xoossaa” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Asay Gibxefe keyin, nam7antho laythan, nam7antho ageenan, laatamantho gallasan, shaaray Geeshsha Dunkaaniya bollafe dendis. ");
INSERT INTO gofl_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Yaatin asay Siina mela biittafe maaran maaran dendidosona; shaaray Paarana mela biitta gakidi wodhis. ");
INSERT INTO gofl_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Goday Muse kiitidaysada enti baanaw koyro dendidosona. ");
INSERT INTO gofl_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Koyro Yihuda kochaa baggan dunkaanida kochay banta mala ekidi keyidosona. Entana kaalethey Amnadaabe na7aa Na7asoona. ");
INSERT INTO gofl_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Yisakoora kochaa kaalethey Zu7ara na7aa Natina7eela. ");
INSERT INTO gofl_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Zabloona kochaa kaalethey Heloona na7aa Eli7aaba. ");
INSERT INTO gofl_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Yaatin, Geeshsha Dunkaaney shodetin, Gedisoona kochatinne Meraara kochati tookidi dendidosona. ");
INSERT INTO gofl_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Kaallidi Robeela kochaa baggan dunkaanida kochay banta mala oykide keyidosona. Robeela kochaa kaalethey Shade7ura na7aa Elizuura. ");
INSERT INTO gofl_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Simoona kochaa kaalethey Zurishadaya na7aa Salumi7eela. ");
INSERT INTO gofl_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Gaade kochaa kaalethey Ragu7eela na7aa Eliyasaafa. ");
INSERT INTO gofl_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Yaatin Qahaata kochay geeshsha miisheta tookidi dendidosona. Enti kaalliya guta gakanaape sinthe Geeshsha Dunkaaney toketidi uttees. ");
INSERT INTO gofl_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Kaallidi Efreema kochaa baggan dunkaanida kochati banta malla oykidi keyoosona. Efreema kochaa kaalethey Amhuda na7aa Elishama7a. ");
INSERT INTO gofl_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Minaase kochaa kaalethey Padazuura na7aa Gamali7eela. ");
INSERT INTO gofl_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Biniyaame kochaa kaalethey Gadiyoona na7aa Abdaana. ");
INSERT INTO gofl_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Wursethan Daane kochaa baggan dunkaanida kochay, ubbaas guye baggara kate gididi, banta malaoykidi keyidosona. Daane kochaa kaalethey Amsadaya na7aa Aki7ezera. ");
INSERT INTO gofl_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Aseera kochaa kaalethey Okraana na7aa Pagi7eela. ");
INSERT INTO gofl_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Niftaaleme kochaa kaalethey Enaana na7aa Akira. ");
INSERT INTO gofl_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Isra7eele asay banta zerethan zerethan gutaape dendidi biya maaray hessa. ");
INSERT INTO gofl_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Musey Midiyaame addiya Ragu7eela na7aa Hobaabako, “Goday nuus immana gida biitta laattanaw boos; Goday Isra7eele anjana gida gisho nuura yedha; nuuni new lo77oba oothana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Yaatin Hobaabi, “Akay, taani ta biitta ta dabbotako baana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Musey zaaridi, “Hayyana, nuna yeggada boopa. Nu biya mela biittan nuuni dunkaanana bessaa ne eraasa; nu baana ogiya nuna kaalethanaw danda7aasa. ");
INSERT INTO gofl_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Neeni nuura biiko, Goday nuus immiya anjuwa ubbaa Nu new shaakana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Asay Godaa zumaape dendidi, heedzu gallasa oge bidosona. Godaa caaqo Taabotey enti shempana bessi koyishe heedzu gallas entafe sinthe sinthe bis. ");
INSERT INTO gofl_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Enti dunkaanida gutaape dendiya wode ubban Godaa shaaray gallas gallas entafe bollara de7ees. ");
INSERT INTO gofl_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Taabotey dendiya wode ubban Musey, “Abeeti Godaw, denda; ne morketi laaleto; nena ixeysati ne sinthafe baqato” yaagees. ");
INSERT INTO gofl_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Taabotey shempiya wode ubban Musey, “Abeeti Godaw, daro mukulan taybetiya Isra7eele asaako simma” yaagees. ");
INSERT INTO gofl_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Isra7eele asay bantana gakida metuwan Godaa bolla zuuzumidosona. Enta zuuzuntha Goday si7ida wode iya hanqoy eexin, xuuggiya tama enta bolla yeddis; he tamay enti dunkaanida gutaape issi bagga gaxaa mis. ");
INSERT INTO gofl_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Yaatin Musey enta gisho Godaa woossana mela enti Museko yidi yeekidosona. Musey woossin tamay to7is. ");
INSERT INTO gofl_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Godaa tamay enta giddon eexida gisho, he bessay Tabeera geetetidi xeegetis. ");
INSERT INTO gofl_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Isra7eeletara Gibxefe keyida dumma dumma derey hara kathi maanaw daro amotidosona. Enti, “Nu asho awupe demmanee? ");
INSERT INTO gofl_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Nuuni Gibxen de7iya wode miishe qanxonna miya moluwa, leehiya, habaabe, shunkurte, miskati bayna shunkurtenne tuumuwa hassayoos. ");
INSERT INTO gofl_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Shin ha77i nu qoodhey gordetis; nu ayfeyka ha mannafe attishin, haraba aybaka be7enna” yaagidi yeekidosona. ");
INSERT INTO gofl_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Mannay deebbo ayfe daanees; iya malay bootha adil7e ciishshe daanees. ");
INSERT INTO gofl_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Mannay qamma wodhees; asay yuuyidi iya maxidi woxan gaaccidi woyko udulan caddidi kathoosona. Yaatidi uukosona; iya mal7oy shamaho zaytera uuketida uytha mela. ");
INSERT INTO gofl_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Manni qamma enta gutan akara wodhees. ");
INSERT INTO gofl_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Asay banta dunkaaniya pengen pengen eqidi yeekishin Musey si7is. Enti Godaa hanquwa denthethida gisho, Musey un7etis. ");
INSERT INTO gofl_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Musey Godaako, “Ne aylliya, ta bolla ayis ha metuwa ehadii? Ne tanan ayis ufaytabikii? Ne ha asa ubbaa toohuwa ta bolla ayis wothadii? ");
INSERT INTO gofl_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Ha asa ubbaa ta qanthatadinayee? Woyko enta ta yeladinaayee? Ne enta mayzatas, immana gada caaqida biitta gatho gada na7a idimmada dichiya aseeda ta ki7on ayis enta yeggadii? ");
INSERT INTO gofl_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Ha asa ubbaas ta asho awupe ehanee? Enti taako yidi, ‘Maanaw nuus asho imma’ yaagidi yeekosona. ");
INSERT INTO gofl_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Taani ha asa ubbaa tarka tookanaw danda7ike; taw hessi deexo tooho. ");
INSERT INTO gofl_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Hiza neeni tana haysada oothanaape taw qadheta; ha77i tana wodha; ha metuwape ta shempa aggana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Goday Museko, “Asaa kaalethanaw danda7iya Isra7eele halaqatape laapun tammu cimata doora. Enta Geeshsha Dunkaaniyako ehada ne matan essa. ");
INSERT INTO gofl_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Taani wodhada neera yan odetana; ta new immida Ayyaanape shaakada enta bolla wothana. Neeni asaa toohuwa nerka tookonna mela enti nena maaddana. ");
INSERT INTO gofl_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","“Neeni asaako haysada yaaga; ‘Wonto hinte asho maana gisho hintena geeshshite. Nu asho awupe demmanee? Nuus Gibxen sa7i lo77oshin’ yaagidi hinte yeekida yeehuwa Goday si7is. Ha77i Goday asho immana; hinteka maana. ");
INSERT INTO gofl_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Hinte maanay issi gallas woyko nam7u gallas woyko ichashu gallas woyko tammu gallas woyko laatamu gallas xalaala gidenna. ");
INSERT INTO gofl_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","Shin ‘Hinte giddon de7iya Godaa hinte kadhida gishonne Gibxefe keyonna attidaako nuus lo77oshin gida gisho, hintew siidhera keyana gakanawunne hinte saletana gakanaw issi ageena kumethi hinte asho maana’ yaaga” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Shin Musey Godaako, “Heko, ta 600,000 asaa kaalethashe de7ayis. Neeni issi ageena kumethi enti asho maana mela immana gaasa. ");
INSERT INTO gofl_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Miiza wudenne dorsa wude ubbaa shukin entaw gidanee? Abban de7iya molo ubbaa shiishiyako entaw gidanee?” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Yaatin, Goday Museko, “Godaa kushey qantheyee? Taani new odiyabay tumeekonne wordoko neeni ha77i be7ana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Hessa gisho, Musey kare keyidi, Goday gidaysa asaas odis. Isra7eele cimatape laapun tammu asaa shiishidi, Geeshsha Dunkaaniya yuushon essis. ");
INSERT INTO gofl_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Yaatin, Goday shaarara wodhidi iyara odetis; iya bolla de7iya Ayyaanape ekidi, he laapun tammu cimata bolla wothis. Ayyaanay enta bolla shempida wode enti nabeda tinbite odidosona. Shin hessafe guye, zaaridi tinbite odibookona. ");
INSERT INTO gofl_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","He laapun tammu cimatara xaafetida asatape Eldaadanne Modaada geetetiya nam7ati dunkaanida gutan attidi Geeshsha Dunkaaniyako yibookona. Shin enta bollaka Ayyaanay wodhin, dunkaanida gutan tinbite odidosona. ");
INSERT INTO gofl_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Issi pantha addey Museko woxi yidi, “Eldaadinne Modaadi dunkaanida gutan tinbite odoosona” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Yaanin, ba na7atethafe doomidi, Muse maaddiya Nawe na7aa Iyyasuy Museko, “Ta godaw, Muse, enta teqa” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Shin Musey zaaridi, “Ta gisho ne qanaatay? Goday ba asa ubbaa bolla ba ayyaana wothidi nabeda tinbite odisiyaba gidiyako ta ufaytayis” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Yaatidi, Museynne Isra7eele cimati dunkaanida gutaa simmidosona. ");
INSERT INTO gofl_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Qoponna Goday carko denthidi, sa7ape nam7u wadha mela dhoqu gidi piradhiya kuraachota abbafe ehis. Enta dunkaaniya yuushuwan ubba baggara issi gallasa oge mela sa7an wodhidosona. ");
INSERT INTO gofl_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","He gallasinne he qamma ubbaa, qassi wontetha gallasika asay kare keyidi, he kuraachota oykidi shiishidosona. Entafe oonika 10 kilo giraamepe guuthu shiishibenna. Enti dunkaaniya guta yuushon melisanaw miccidosona. ");
INSERT INTO gofl_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Shin ashoy buroo enta doonan de7ishininne meetetidi wuronna de7ishin, Godaa hanqoy asaa bolla eexis; Goday asaa wolqaama boshan shocis. ");
INSERT INTO gofl_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Asho amotidi hayqida asaa enti he bessan moogida gisho he bessay Kebroot-Hataaba geetetidi sunthetis. ");
INSERT INTO gofl_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Asay he bessaafe dendi bidi Haxeroota geetetiya bessan dunkaanidosona. ");
INSERT INTO gofl_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Musey Tophe biitta maccas ekida gisho, Mayraamanne Aaroni Muse yaagidi boridosona. ");
INSERT INTO gofl_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","“Goday Muse baggara xalaala odetidee? I nu baggara odibeennee?” yaagidosona. Goday enti gidaysa si7is. ");
INSERT INTO gofl_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Musey biittan de7iya asa ubbaafe aadhiya aada asi. ");
INSERT INTO gofl_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Qoponna Goday Muse, Aaronanne Mayraamo, “Hinte heedzati Geeshsha Dunkaaniyako keyte” yaagis. Entika keyidosona. ");
INSERT INTO gofl_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Goday shaara tuussara wodhidi Geeshsha Dunkaaniya pengen eqidi, Aarona! Mayraame! yaagidi xeegis. Enti nam7ay iya sinthe shiiqin, ");
INSERT INTO gofl_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Goday, “Ta odeysa si7ite; hinte giddon nabey de7iko, ta iyaw qoncayis; qassi iyaw amuhon odayis. ");
INSERT INTO gofl_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Shin ta aylley Muse hessada gidenna; I ta keetha ubban ammanetidaysa. ");
INSERT INTO gofl_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Taani Musera som7on odetasipe attishin, leemison odike. I ta malaa be7ees. Yaatin, hinte ta aylliya Muse boranaw ayis yayyibeketii?” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Godaa hanqoy enta bolla eexin, I enta aggidi bis. ");
INSERT INTO gofl_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Shaaray Geeshsha Dunkaaniya bollafe dendida wode Mayraama baro hargen milxi gada booxasu. Aaroni iiko simmidi xeelliya wode baro hargen oyketidaaro be7is. ");
INSERT INTO gofl_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Aaroni Museko, “Hay ta godaw, nuuni eeyatethan oothida nagaraas nuna haysada seeropa. ");
INSERT INTO gofl_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Iyo ba aaye ulope keyiya wode I asatethafe baggay meetetin, hayqidi yeletida na7a mela oothofa” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Yaatin, Musey, “Abeeti Godaw, iyo patharki” yaagidi Godaa woossis. ");
INSERT INTO gofl_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Goday Museko, “I aaway I som7on cuttiyaba gidiyako, iya laapun gallas yeellara gam7awusu gidikee? Hessa gisho, laapun gallas dunkaaniya gutaape iyo gaxa kessada dumma bessan wotha; hessafe guye, simmada yo” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Yaatin, Mayraama dunkaaniya gutaape gaxa keyada laapun gallas uttasu. Iya simmana gakanaw asay gutaa aggidi baanaw dendibeenna. ");
INSERT INTO gofl_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Hessafe guye, asay Haxeroota geetetiya bessaafe dendidi, Paarana mela biittan dunkaanidosona. ");
INSERT INTO gofl_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Goday Museko, ");
INSERT INTO gofl_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Taani Isra7eeletas immana Kanaane biitta wochana mela tammanne nam7u Isra7eele kochaafe issi issi asi halaqa oothada kiitta” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Yaatin Musey Goday kiitidaysada Paarana mela biittafe Isra7eele kochaafe tammanne nam7u halaqata kiittis. ");
INSERT INTO gofl_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Enta sunthay haysafe kaallidi xaafetidaysata. Robeela kochaafe Zakura na7aa Samu7a; ");
INSERT INTO gofl_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Simoona kochaafe Hoora na7aa Shaafaxa; ");
INSERT INTO gofl_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Yihuda kochaafe Yoofona na7aa Kaaleba; ");
INSERT INTO gofl_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Yisakoora kochaafe Yoosefa na7aa Yigi7aala; ");
INSERT INTO gofl_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Efreema kochaafe Nawe na7aa Awuse; ");
INSERT INTO gofl_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Biniyaame kochaafe Raafu na7aa Falxa; ");
INSERT INTO gofl_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Zabloona kochaafe Sooda na7aa Gadi7eela; ");
INSERT INTO gofl_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Yoosefa na7aa Minaase kochaafe Suusa na7aa Gaade; ");
INSERT INTO gofl_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Daane kochaafe Gamaala na7aa Ami7eela; ");
INSERT INTO gofl_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Aseera kochaafe Mika7eela na7aa Satura; ");
INSERT INTO gofl_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Niftaaleme kochaafe Waafisa na7aa Nahiba; ");
INSERT INTO gofl_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Gaade kochaafe Maka na7aa Ge7u7eela. ");
INSERT INTO gofl_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","He biitta wochana mela Musey kiitida asata sunthay haysata. Musey Nawe na7aa Awuse sunthaa Iyyasu gidi sunthaa laammis. ");
INSERT INTO gofl_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Musey enta, “Negebe mela biitta kanthidi pude derey dariya biitta keyte. ");
INSERT INTO gofl_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Biittay ay mela biittako, asay ay mela minookonne taybon guutheko daroko be7ite. ");
INSERT INTO gofl_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Enti de7iya biittay lo77oko iiteko, enta katamati diretidaakonne mela de7iyako, ");
INSERT INTO gofl_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","biittay araddeko laddeko, biittay woran kametidaakonne quu7eko be7ite. Minnite; he biittan de7iya katha ayfiyape ekonna yoopite” yaagis. He wodey woyney teeridi maxetiya wode. ");
INSERT INTO gofl_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Enti keyidi Siina mela biittafe doomidi, Lebo-Hamaata matan de7iya Rehooba gakanaw de7iya biitta wochidosona. ");
INSERT INTO gofl_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Negebe mela biitta kanthidi, Kebroona gakidosona. He bessan Akmaana, Sesayanne Talmaya geetetiya Enaaqa kochati de7oosona. Kebrooni Gibxen de7iya Xo7aane katamaape laapun laythi koyrottidi keexetis. ");
INSERT INTO gofl_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Yaara kanthidi, Eshkola Zangaara bidi gakiya wode teera woyne tashiyara qanxidosona. He tashey deexo gidiya gisho nam7u asi kaso aathidi tookidosona. Iya bolla gujidi oromaanenne balase mithaa ayfe ekidi yidosona. ");
INSERT INTO gofl_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Isra7eele asay he bessaafe woyne tashiya qanxida gisho he bessaa Eshkola Zangaara gidi xeegidosona. ");
INSERT INTO gofl_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Enti he biitta oytamu gallas wochidi guye simmidosona. ");
INSERT INTO gofl_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Paarana mela biittan Qaadesan de7iya Museko, Aaronakonne Isra7eele maabara ubbaako yidosona. Enti be7idaba asa ubbaas odidosona; he biittafe ekidi yida ayfiyaka enta bessidosona. ");
INSERT INTO gofl_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Enti Museko, “Neeni nuna yeddida biitta bida; he biittan maathinne eessi goggees; he biitta ayfiyaka haysa be7a. ");
INSERT INTO gofl_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Shin he biittan de7iya asay wolqaama; enta katamatika gimbe dirsan diretidaysatanne gita. Nuuni ubbaafe aathidi Enaaqa kochata yan be7ida. ");
INSERT INTO gofl_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Amaaleqati Negebe mela biittan; Hitetinne, Yaabuseti derey dariya Amooreta biittan; qassi Kanaaneti Medetiraane Abbaa doonaninne Yordaanose shaafa gaxan de7oosona” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Yaatin Kaalebi asaa Muse sinthan si77i oothidi, “Nuuni xoonanaw danda7iya gisho, ha77i keyidi he biitta yegisidi ane oykoos” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Shin Kaalebara bida asati, “He biitta asay nuupe aadhidi minniya gisho, nuuni enta xoonanaw danda7oko” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Enti yuuyidi wochida biittaba Isra7eele asaas haysada yaagidi iita oda odidosona. “Nuuni wochida biittay yan de7iya asaaka miya biitta; yan de7iya asayka daro adusse. ");
INSERT INTO gofl_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Nuuni yan Enaaqa koche gidida Nifilime asata be7ida. Enta be7ida ayfen nuna xeelliya wode nuuni xaqo mela; entika nuna hessada be7oosona” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","He wode qamma maabara ubbay banta qaala dhoqu oothidi yeekidosona. ");
INSERT INTO gofl_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Isra7eele asay Muse bollanne Aarona bolla zuuzumidosona. Kumetha maabaray, “Nuuni Gibxe biittan de7ishe woyko ha mela biittan hayqida gidorko. ");
INSERT INTO gofl_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Nuuni mashshan wurana mela Goday ha biitta nuna ayis ehii? Nu machetinne nu nayti di7etana; hessa hananaape guye Gibxe simoy nuus keehennee?” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Enti issoy issuwako, “Nuna kaalethiya asi dooridi guye Gibxe simmoos” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Yaatin, Museynne Aaroni he bessan shiiqida Isra7eele maabara sinthan som7ora sa7an gufannidosona. ");
INSERT INTO gofl_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Biittaa wochanaw bida asaa giddofe Nawe na7aa Iyyasuynne Yoofona na7aa Kaalebi banta ma7uwa peedhidosona. ");
INSERT INTO gofl_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Isra7eele maabaraako, “Nuuni kanthi keyidi wochida biittay daro lo77o. ");
INSERT INTO gofl_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Goday nunan ufaytiyaba gidiko maathinne eessi goggiya biitta nuna gelsana; he biitta nuus immana. ");
INSERT INTO gofl_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Hessa gisho, Godaa bolla makallofite. He biitta asaas yayyofite; enti nuus oythika gidokona. Entaw eeshoy baawa; Goday nuura de7ees; hinte entaw yayyofite” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Yaatin Isra7eele maabaray enta shuchan caddanaw dendis. He wode Godaa bonchoy Xoossaa Dunkaaniyan Isra7eele asa ubbaas qoncis. ");
INSERT INTO gofl_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Goday Museko, “Ha asay tana kadhey awude gakanaasee? Taani enta giddon oothida malaatata be7ishe, awude gakanaw tanan ammanonna ixanee? ");
INSERT INTO gofl_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Taani enta gadon shocada dhaysana, shin nena entafe dariyanne minniya kawotethas aawa oothana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Musey zaaridi Godaako, “Neeni ne wolqan ha asaa Gibxefe kessidaysa eriya Gibxeti hessa si7iko woyganee? ");
INSERT INTO gofl_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Enti he biittan de7iya asaas hessa odana. Abeeti Godaw, neeni ha asaara de7eysa enti si7idosona. Abeeti Godaw, nuuni nena be7idaysa, ne shaaray nu bolla kuyatidaysanne gallas shaara tuussan, qamma tama tuussan neeni nuna kaalethidaysa enti be7idosona. ");
INSERT INTO gofl_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Yaatin, ha77i neeni ha asa ubbaa issi toho wodha dhaysiyaba gidiko ne kase oothidaysa si7ida kawotethati, ");
INSERT INTO gofl_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘Goday, ha asaas immana gidi caaqida biitta enta gelsanaw danda7iboona gisho mela biittan wodhi dhaysis yaagidi’ odana. ");
INSERT INTO gofl_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","“Hessa gisho, Godaw, ne wolqaa nuna bessa; ne nuus gelida qaala qopa. ");
INSERT INTO gofl_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘Goday elle hanqetenna; maarotinne siiqoy kumidaysa nagaranne geellatethi atto geysa; shin balida uraa seeronna aggenna. Yelidaysata nagaraa gisho heedzanthonne oyddantho yeletethi gakanaw nayta seerana’ yaagadasa. ");
INSERT INTO gofl_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Ha asay Gibxefe keyoosope doomada hachi gakanaw enta maaridaysada ne merinaa siiquwan ha asaa nagaraa atto garki” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Goday zaaridi, “Ne oychidaysada ta enta maarana. ");
INSERT INTO gofl_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Shin ta de7o gideysadanne ta bonchoy sa7a ubbaa kumidaysada, ");
INSERT INTO gofl_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","ha asaape issi asika he biitta be7enna. Gibxe biittaninne mela biittan oothida malaatata ha asati be7idosona; shin enti tammu toho tana paacidi taw kiitetonna ixidosona. ");
INSERT INTO gofl_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","Hessa gisho, ta enta mayzatas immana gada caaqida biitta tana kadhidaysatape issoyka gelenna. ");
INSERT INTO gofl_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Shin ta aylley Kaalebi entafe dummatiya gishonne tana polo wozanape kaallida gisho, I kase wochida biitta iyaw immana; iya zerethayka he biitta laattana. ");
INSERT INTO gofl_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Shin ha77i Amaaleqatinne Kanaaneti zangaaran de7iya gisho, wonto Zo7o Abbaako efiya ogiya oykidi mela biitta guye simmite” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Goday Musekonne Aaronako, ");
INSERT INTO gofl_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“Ha iita asay ta bolla awude gakanaw zuuzumanee? Taani Isra7eele asaa zuuzuntha si7as. ");
INSERT INTO gofl_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Hessa gisho, neeni entaw haysada gada oda; ‘Taani ta de7uwan caaqayis; hinte gidaysada ta hintew oothana.’ Taani, Goday haysa odayis. ");
INSERT INTO gofl_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Asay taybetiya wode laythi laatamanne iyape bolla gidida asi ubbay ta bolla zuuzumida gisho, hinte ahay ha mela biittan kundana. ");
INSERT INTO gofl_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Yoofona na7a Kaalebapenne Nawe na7a Iyyasupe attishin, hintefe oonika ta hintena laatisanaw caaqida biitta gelenna. ");
INSERT INTO gofl_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Hinte, ‘Nu nayti di7eti attana’ gida hinte nayta, he hinte kadhida biitta gelsana; he biittay entaw laata gidana. ");
INSERT INTO gofl_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Shin hinte ahay ha mela biittan kundidi attana. ");
INSERT INTO gofl_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Hinte ammanetibona gisho, hintefe wursetha ahay ha mela biittan kundana gakanaw, hinte nayti ha mela biittan waayetishe oytamu laythi dorse heemmana. ");
INSERT INTO gofl_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Hinte biitta wochida oytamu gallasaa taybon, issi gallasas issi laythi, oytamu laythi hinte nagaraa gisho waayetana; he wode ta hinte bolla ay mela hanqetidaako hinte erana. ");
INSERT INTO gofl_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Issife ta bolla dendida ha iita maabara bolla ta haysada oothana; enti ha mela biittan kundi attana; haysan enti hayqana; ta Goday haysa odayis” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","He biitta wochana mela Musey kiitida asati simmidi, he biittaba iita oda odidi, Muse bolla asay zuuzumana mela oothidaysati, ");
INSERT INTO gofl_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","Godaa sinthan boshan hayqidosona. ");
INSERT INTO gofl_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","He biitta wochanaw bida asaape Yoofona na7ay Kaalebinne Nawe na7ay Iyyasu xalaali attidosona. ");
INSERT INTO gofl_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Musey hessa Isra7eele asaas odida wode asay daro yeekis. ");
INSERT INTO gofl_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Wontetha gallas wonta guura dendidi, gezze biitta keyidi, “Nuuni nagara oothida, shin ha77i Goday nuus immana gida bessaa pude keyana” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Shin Musey entako, “Godaa kiitaa hinte ayis menthetii? Hintew hanenna. ");
INSERT INTO gofl_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Goday hintera doonna gisho, boopite; hinte morketi hintena xoonana. ");
INSERT INTO gofl_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Amaaleqa asaaranne Kanaane asaara hinte oletidi mashshan hayqana. Godaas hinte kiitetonna ixida gisho, Goday hintera deenna” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Shin enti Godaa Caaqo Taaboteynne Musey gutaape dendonna de7ishin, derey dariya biitta baanaw minnidi dendidosona. ");
INSERT INTO gofl_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Yaanin derey dariya biittan de7iya Amaaleqa asaynne Kanaane asay enta ollan xoonidi, Horma gakanaw enta yedethidosona. ");
INSERT INTO gofl_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Goday Museko, ");
INSERT INTO gofl_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“Isra7eele asaa haysada yaaga; hinte daana mela ta hintew immiya biitta geliya wode, ");
INSERT INTO gofl_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","xuussa yarsho gidin woyko gaso yarsho gidin woyko dosan yarshiya yarsho gidin woyko ba7aale gallasa yarsho gidin, mehepe woyko dorsaafe Godaas taman xuugetiya sawiya yarsho yarshite. ");
INSERT INTO gofl_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","Yarshuwa yarshiya uray katha yarshuwas issi kilo giraame lo77o dhiille sayso litiro shamaho zayten munuqetidaysa eho. ");
INSERT INTO gofl_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Qassi xuussa yarshos woyko hara yarshos ehiya issi issi dorsaara sayso litiro woyne ushsha yarsho oothidi giigisite. ");
INSERT INTO gofl_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Maraze yarshiya wode nam7u kilo giraame lo77o dhiille issi litironne bagga shamaho zayten munuqetidaysa ehite. ");
INSERT INTO gofl_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","Ushsha yarshuwas siko litiro woyne ushsha yarshuwas ehite. Hessi Godaas sawiya yarsho gidana. ");
INSERT INTO gofl_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Gaso woyko issifetetha yarshos wofaano xuussa yarsho oothada Godaas yarshiya wode, ");
INSERT INTO gofl_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","wofaanuwara issife heedzu kilo giraame lo77o dhiille, nam7u litiro shamaho zayten munuqetidaysa katha yarsho oothada eha. ");
INSERT INTO gofl_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","Ushsha yarshuwas bagga litiro woyne ushsha ehite. Hessi Godaas sawiya xuussa yarsho gidana. ");
INSERT INTO gofl_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","“Issi issi wofaanoy woyko issi issi marazey woyko issi issi koley yarshetiya wode haysada hanidi ooseto. ");
INSERT INTO gofl_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Daro mehey yarshetiya wode yarshetiya katha yarshoyka hessada daro. ");
INSERT INTO gofl_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Isra7eele asi gidida oonika sawiya xuussa yarsho Godaas yarshiya wode ubban haysada oothanaw koshshees. ");
INSERT INTO gofl_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Yaana yeletethan hinte giddon de7iya bete woyko hara asi oonika sawiya xuussa yarsho Godaas yarshanaw koyiko hessada oothanaw koshshees. ");
INSERT INTO gofl_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Hintewunne hinte giddon de7iya bete asaas he wogay issino; hessi yaana yeletethaaska eqidi daana woga; Hinteka bete asatika Godaa sinthan issino. ");
INSERT INTO gofl_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Hintewunne hinte giddon de7iya bete asaas higgeynne wogay issino” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Goday Museko, ");
INSERT INTO gofl_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“Isra7eele asaas haysada gada oda; taani hintena efiya biitta hinte gelidi, ");
INSERT INTO gofl_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","he biittan kaxiya kathi hinte miya wode he kathaafe xeera kessidi hinte Godaas yarshite. ");
INSERT INTO gofl_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Hessika, bayra kaxida kathaafe uukida koyro uythi, gidishin, kathi bukiya wudumaafe immiya yarsho oothidi yarshite. ");
INSERT INTO gofl_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Yeletetha ubban hinte biittan kaxida kathaafe koyruwa uukidi Godaas yarsho yarshite. ");
INSERT INTO gofl_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“Goday, Muses odida kiitaa hinte eronna ixidi naagonna attiko, ");
INSERT INTO gofl_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","woyko Goday iya baggara immida kiita ubbaa, Goday immida gallasaape doomidi yaana yeletetha gakanaw naagonna ixiko, ");
INSERT INTO gofl_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","qassi hessa Isra7eele maabaray eronna oothidaba gidiko maabara ubbay Godaas issi wofaano sawiya xuussa yarsho oothidi, wogay kiiteysada katha yarshuwaranne ushsha yarshuwara yarsho; qassi nagara yarsho oothidi issi kole yarsho. ");
INSERT INTO gofl_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Kahiney kumetha Isra7eele maabaraas nagara atotetha yarsho shiishees. Enti eronna balida banta naaquwa gisho Godaas xuussa yarshonne nagara yarsho yarshida gisho enta nagaray atto geetetana. ");
INSERT INTO gofl_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Isra7eele maabaraynne enta giddon de7iya bete asay eronna he bala oothida gisho asa ubbaa nagaray atto geetetana. ");
INSERT INTO gofl_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“Issi asi eronna nagara oothiko issi laytha kole nagara yarsho oothidi yarsho. ");
INSERT INTO gofl_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Eronna de7ishe nagara oothida uraas kahiney Godaa sinthan nagara atotetha wogaa polo; iya nagaray atto geetetana. ");
INSERT INTO gofl_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Eronna nagara oothida uraas kahiney Godaa sinthan nagara atotetha wogaa polo; iya nagaray atto geetetana. ");
INSERT INTO gofl_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“Shin Isra7eele asi gidin woyko bete asi gidin erishe otoron nagara oothiya uray Godaa cayees. He uray deriya giddofe dhayo. ");
INSERT INTO gofl_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","He uray Godaa kiitaa erishe kadhida gishonne iya kiitaa kawushida gisho iyaw dhayoy bessees. Iya balay iya bolla gido” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Issi gallas Isra7eele asay mela biittan de7ishin, issi uray Sambaata gallas mithi mixishe oyketis. ");
INSERT INTO gofl_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","He uraa asay Museko, Aaronakonne Isra7eele maabaraako ehidosona. ");
INSERT INTO gofl_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Enti iya bolla oothanaba eriboona gisho qashon gam7isidosona. ");
INSERT INTO gofl_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Hessafe guye, Goday Museko, “Ha uray hayqanaw bessees; Isra7eele maabaray banta gutaape gaxa kessidi shuchan caddidi wodho” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Yaatin Isra7eele maabara ubbay Goday Muse kiitidaysada, gutaape gaxa kessidi shuchan caddidi wodhidosona. ");
INSERT INTO gofl_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Goday Museko, ");
INSERT INTO gofl_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“Isra7eele asaas haysada gada oda; hintenne yaana yeletethay hinte afilaa gaxan macara kessidi he macara gaxan kaalose qacina sikite. ");
INSERT INTO gofl_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","He macaraa hinte be7iya wode ubban ta kiitata, akeekidi poleeta; taape haakidi hinte ayfiya amuwanne hinte wozanaa qofaa kaallidi laameteketa. ");
INSERT INTO gofl_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","He macaraa be7idi hinte ta kiita ubbaa akeekidi polananne Xoossaas dummatidaysata gidana. ");
INSERT INTO gofl_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Taani Godaa, hinte Xoossaa; ta hinte Xoossaa gidanaw hintena Gibxefe kessas. Taani Godaa, hinte Xoossaa yaaga” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Leewe kochaafe Qahaata koche gidida Yisi7ara na7ay Qorey, Robeela kochaafe Eli7aaba nayti Daataneynne Abeeroy qassi Faleta na7ay Oni, ");
INSERT INTO gofl_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","Muse bolla dendidosona. Entara nam7u xeetanne ishatamu asati de7oosona; he asati asan eretidaysatanne maabara kaaletheyisata. ");
INSERT INTO gofl_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Enti Musenne Aarona sinthe shiiqidi, “Hinte darsideta; maabara ubbay geeshshi; Goday entara de7ees. Yaatin, Godaa maabara bolla hintena ayis dhoqu dhoqu oothetii?” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Musey hessa si7ida wode Godaa sinthan gufannis. ");
INSERT INTO gofl_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Qorekonne iya cugaako, “Goday wonto wonta ooni iya baggekonne ooni geeshsheko bessana; he I doorida uraa baako shiishana; he uray iyako shiiqana. ");
INSERT INTO gofl_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Wonto wonta neeranne ne asaara haysa oothite; ixaane cuyisiya miishe ekidi, ");
INSERT INTO gofl_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","bonqo tama iyan wothidi, Godaa sinthan ixaane cuyisite. Goday dooriya uray I geeshshi gidana. Hinte, Leeweti zawape aadhideta.” ");
INSERT INTO gofl_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Qassika Musey Qoreko, “Hinte Leeweti si7ite. ");
INSERT INTO gofl_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Isra7eele Xoossay hintena ba maabara giddofe dummayidi, geeshsha dunkaaniyan oothana melanne ba asaa sinthan eqidi haggaazana mela baako shiishidaysi hintew guuxidee? ");
INSERT INTO gofl_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","I hintenanne hinte ishata Leeweta ubbaa baako shiishis; shin ha77i hinte kahineta bessaa koyeeta. ");
INSERT INTO gofl_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Neeninne ne cuga ubbay Godaa bolla makallidi dendideta; hinte iya bolla zuuzumanaw I Aaroni oonee?” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","“Yaatidi, Musey, Eli7aaba nayta, Daatanenne Abeero xeegisis; shin enti, ‘Nuuni booko’ yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Neeni mela biittan nuna wodhanaw maathinne eessi goggiya biittafe nuna kessidaysi guuxis gada ha77i nu bolla halaqa gidanaw koyay? ");
INSERT INTO gofl_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Neeni nuna maathinne eessi goggiya biitta gelsabaaka; woyko neeni nuus laata oothada goshsha gadenne woyne gade immabaaka; neeni nuna cimmaasa; nuuni booko” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Yaatin, Musey daro hanqetidi, Godaako, “Neeni enta yarshuwa ekofa; ta entafe issuwaka qohabike; qassi hari attoshin issi hareka entafe ekabike” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Qassi Musey Qoreko, “Wonto neeranne ne asaara hessada Aaronika Godaa sinthe shiiqite. ");
INSERT INTO gofl_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Issi issi asi ba ixaane cuyisiya miishiya eko; ixaaneka iyan wotho; ubbay issife nam7u xeetanne ishatamu ixaane cuyisiya miishe gidees; ixaane iyan wothidi Godaa sinthe shiisho. Neeninne Aaroni hinte ixaaniya hessada shiishite” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Yaatin, issi issi asi ba miishen ixaanenne tama bonqo wothidi geeshsha dunkaaniya pengen Museranne Aaronara issife eqidosona. ");
INSERT INTO gofl_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Qorey ba asaara geeshsha dunkaaniya pengen Muse sinthaninne Aarona sinthan eqidosona. He wode Godaa bonchoy kumetha maabaraas qoncis. ");
INSERT INTO gofl_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Goday Musekonne Aaronako, ");
INSERT INTO gofl_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Taani issi toho ha asaa dhaysana gisho, entafe shaaketite” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Shin Museynne Aaroni sa7an gufannidi, “Abeeti Xoossaw, asa shempo ubbaa medhida Xoossaw, issi asi nagara oothiko, neeni kumetha maabara hanqetayee?” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Yaatin, Goday Museko, ");
INSERT INTO gofl_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Asaas ‘Qore, Daatanenne Abeero dunkaaniya matape kichite’ gada oda” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Musey dendidi, Daatanekonne Abeeroko bin, Isra7eele cimati iya kaallidosona. ");
INSERT INTO gofl_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","I Maabaraako, “Ha iita asaa dunkaaniya matape kichite; entaba aybibaaka bochofite. Akay, giiko, enta nagara gaason hinteka pitetidi dhayana” yaagidi minthidi odis. ");
INSERT INTO gofl_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Yaatin asay Qore, Daatanenne Abeero dunkaaniya matape kichidosona. Daataneynne Abeeroy kare keyidi, banta machetaranne banta naytara banta dunkaaneta pengen eqidosona. ");
INSERT INTO gofl_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Musey asaako, “Taani ha ooso ubbaa oothana mela, Goday tana kiittidaysanne taani ta shenen oothonaysa hinte eranay haysana. ");
INSERT INTO gofl_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Ha asati asi hayqeysada hayqiko woyko asa bolla gakiyaba xalaali enta bolla gakiko Goday tana Kiittibeenna. ");
INSERT INTO gofl_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Shin, Goday oorathaba oothidi, biittay dooyetidi entanne entaw de7iyaba ubbaa mittikonne enti paxa de7ishe duufo geliko he wode ha asati Godaa kadhidaysa hinte erana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","I yaagidi ongida wode enti eqida biittay dooyetidi, ");
INSERT INTO gofl_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","entanne enta soo asaa, Qore cuga ubbaanne entaw de7iyaba ubbaa mittis. ");
INSERT INTO gofl_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Yaatin enti bantaw de7iyaba ubbaara paxa de7ishe, duufo gelidosona. Biittay enta bolla gordetis; enti maabara giddofe dhayidosona. ");
INSERT INTO gofl_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Enta waasuwa gaason enta matan de7iya Isra7eele asa ubbay, “Biittay nunaka mittana hanees” yaagidi baqatidosona. ");
INSERT INTO gofl_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Qassi tami Godaa matape yidi ixaane cuyisiya nam7u xeetanne ishatamu asaa mis. ");
INSERT INTO gofl_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Hessafe guye, Goday Museko, ");
INSERT INTO gofl_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“Kahiney, Aarona na7aa Alaazari naase biratape oosetida ixaane cuyisiya miisheta xuugetida asaape ekidi, he miisheti geeshshi gidiya gisho, bonqo tama hara soo efidi laallana mela oda. ");
INSERT INTO gofl_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","He miisheti banta de7uwa dhaysanaw nagara oothida asay ixaane cuyisiya miishe. He miisheti Godaas imetida gishonne geeshshi gidiya gisho lee7isa qoxada yarsho bessa lanxa. Hessi Isra7eele asaas naagiso malla gido” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Yaatin kahiney Alaazari ixaane cuyisiya miisheta ekidi yarsho bessa lanxanaw lee7isidi qoxis. ");
INSERT INTO gofl_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","Goday Muse baggara kiitidaysada, Aarona koche gidonna oonika Godaa sinthan ixaane cuyisanaw shiiqonna mela, ixas giiko, Qore bollanne iya kaalleyisata bolla gakidaysi iya gakonna mela Isra7eele asaa akeekisanaw haysata oothis. ");
INSERT INTO gofl_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Wontetha gallas Isra7eele maabara ubbay, “Godaa asaa hinte wodhideta” yaagidi Muse bollanne Aarona bolla zuuzumidosona. ");
INSERT INTO gofl_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Enti Musenne Aarona bolla dendanaw shiiqidi, enti geeshsha dunkaaniya xeelliya wode shaaray geeshsha dunkaaniya kammin, Godaa bonchoy qoncis. ");
INSERT INTO gofl_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Hessafe guye, Museynne Aaroni geeshsha dunkaaniya sinthe yidi eqidosona. ");
INSERT INTO gofl_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","Yaatin Goday Museko, ");
INSERT INTO gofl_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“Ha asaa giddofe kichite; ta enta issi tohon dhaysana” yaagis. Museynne Aaroni sa7an gufannidosona. ");
INSERT INTO gofl_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Musey Aaronako, “Ixaane cuyisiya ne miishiya ekada yarsho bessaafe bonqo tama ekada iyan wotha; iya bolla ixaane gujada Isra7eele maabaraako efa. Godaa hanqoy iya matape keyi kichis; boshayka doomis” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Yaatin Aaroni, Musey kiitidaysada ba ixaane cuyisiya miishiya ekidi maabara giddo woxidi gelis. Boshay asaa wodho oykis shin, Aaroni ixaane cuyisidi asaas atotethi ehis. ");
INSERT INTO gofl_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Yaatidi, I hayqidaysatanne paxata giddon eqin, boshay aggis. ");
INSERT INTO gofl_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Qore gaason hayqida asay attishin, he boshan hayqida asaa tayboy 14,700. ");
INSERT INTO gofl_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Boshay eqidaape guye, Aaroni geeshsha dunkaaniya pengen de7iya Museko simmis. ");
INSERT INTO gofl_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Goday Museko, ");
INSERT INTO gofl_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Isra7eele asay issi issi kochaa halaqatape issi issi xam7a ekidi tammanne nam7u xam7a new ehana mela entaw oda. He xam7aa bolla issi issi asaa sunthaa xaafa. ");
INSERT INTO gofl_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Issi issi kochaa halaqaas issi xam7a koshshiya gisho, Leewe xam7aa bolla Aarona sunthaa xaafa. ");
INSERT INTO gofl_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","He xam7ata geeshsha dunkaaniya giddon ta neera gahetiya Taabotiya sinthan wotha. ");
INSERT INTO gofl_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Ta dooriya uraa xam7ay aacana; hessada oothada hinte bolla Isra7eele asaa zuuzuntha ta teqana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Hessa Musey Isra7eele asaas odin, tammanne nam7u halaqati huuphen huuphen issi issi xam7a ehidosona. Aarona xam7ayka he xam7ata giddon de7ees. ");
INSERT INTO gofl_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Musey he xam7ata ubbaa geeshsha dunkaaniya giddon Godaa sinthan wothis. ");
INSERT INTO gofl_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Wontetha gallas Musey geeshsha dunkaaniya giddo geliya wode Leewe koche gidida Aarona xam7ay aacidaysa, gambuxidaysa, ciiyidaysanne lawuze mitha ayfe ayfidaysa be7is. ");
INSERT INTO gofl_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Musey xam7a ubbaa Godaa sinthafe ehidi Isra7eele asaa bessis. Enti hanidaba be7idaape guye issi issi halaqay banta xam7aa xam7aa ekidosona. ");
INSERT INTO gofl_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Goday Museko, “Aarona xam7aa Taabotiya sinthan zaarada wotha. Makallida Isra7eele asay ta bolla zuuzuntha aggonna ixiko hayqanaysa entaw malaata oothada wotha” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Musey, Goday kiitidaysada oothis. ");
INSERT INTO gofl_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Isra7eele asay Museko, “Hessa gidiko, nu ubbay hayqana; dhayana. ");
INSERT INTO gofl_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Geeshsha dunkaaniyako shiiqiya ubbay hayqana gidiko, nu ubbayka hayqoos guusseyee?” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Goday Aaronako, “Geeshsha dunkaaniyan oosetiya nagaraas neeni, ne adde naytinne ne aawa soo asay oyshetana; hinte kahinetetha oosuwan poletiya nagaraa nenne ne adde nayta xalaali oyshetana. ");
INSERT INTO gofl_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Neeninne ne adde nayti geeshsha dunkaaniya sinthan oothiya wode hintena oothidi maadana mela Leewe koche gidida ne dabbota eha. ");
INSERT INTO gofl_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Enti hintefe garsan geeshsha dunkaaniya ooso ubbaa oothonna; shin entika hinteka hayqonna mela enti geeshsha dunkaaniya miishiyakonne yarsho bessaako shiiqopo. ");
INSERT INTO gofl_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Enti hintera issife gididi geeshsha Dunkaaniyan de7iya ooso ubbaa ootho. Shin Leewetape attishin, hara asi oonika hinte de7iya bessaa shiiqopo. ");
INSERT INTO gofl_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Zaaridi Isra7eele asaa bolla hanqoy wodhonna mela geeshsha dunkaaniyaninne yarsho bessan oosetiya oosuwa hinte xalaala oothite. ");
INSERT INTO gofl_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Leeweta, hinte dabbota, Isra7eele asaa giddofe ta dooras. Enti geeshsha dunkaaniya oosuwa oothana mela taani enta taw dummayas. ");
INSERT INTO gofl_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Shin yarsho bessaaninne magarajuwafe gaatha baggan de7iya oosuwa nenne ne adde nayta xalaali oothite. Kahinetetha oosuwa taani hintew imota oothada immas; hara asi oonika he bessaa shiiqiko hayqo” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Goday Aaronako, “Isra7eele asay taw immiya geeshsha imota ubbaa ta new immas. Taani newunne ne adde naytas merinaa gisho oothada immas. ");
INSERT INTO gofl_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Taw imetiya daro geeshsha imuwape taman xuugetonna baggay hintebaa gidana. Enti taw immiya geeshsha imo ubbay katha yarsho gidin nagara yarsho gidin naaqo yarsho gidin newunne ne adde naytas gidana. ");
INSERT INTO gofl_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Hinte hessa geeshsha bessan miite; adde ubbay hessa mo; hessi hintew geeshshi gidana. ");
INSERT INTO gofl_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“Qassi Isra7eele asay taw yarshiya yuusho yarsho ubbaa new, ne adde naytasinne ne macca naytas merinaw gisho oothada immas; hinte soo asaa giddon wogada tuna gidonna ubbay hessa mo. ");
INSERT INTO gofl_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","“Isra7eele asay taw bayra oothidi immiya koyro ayfiyape, shamaho zayte ubbaa, yalaga woyne ubbaanne katha ubbaa new immas. ");
INSERT INTO gofl_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Enti Godaas ehiya gaden koyro gakida ayfey hintesa; hinte soo asaa giddon wogaada tuna gidonna ubbay hessa mo. ");
INSERT INTO gofl_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“Isra7eele asaa giddofe Godaas dummatida ubbay hintesa. ");
INSERT INTO gofl_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Bayra yeletida asi woyko mehey Isra7eele asay Godaas immida ubbay hintesa. Shin bayra yeletida adde na7anne bayra yeletida geeshshi gidonna mehe hinte wozanaw bessees. ");
INSERT INTO gofl_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Issi ageena nayta wozanaw geeshsha dunkaanen eretida mizaanen ichashu bira santime wozo gate qanxite. ");
INSERT INTO gofl_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Shin enti geeshshi gidiya gisho mehe, dorsenne deesha bayra hinte wozanaw koshshenna. Enta suutha yarsho bessa bolla gussa; Godaas sawiya xuussa yarsho oothada enta modho ashuwa taman xuugga. ");
INSERT INTO gofl_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Angaasoynne ushacha geday yuusho yarshon nebaa gididaysada enta ashoyka nebaa. ");
INSERT INTO gofl_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Isra7eele asay Godaas immiya geeshsha yarsho ubbaa new, ne adde naytasinne ne macca naytas merinaw gisho oothada immas. Hessi taani neeranne ne kochaara caaqiya merinaa caaquwa.” ");
INSERT INTO gofl_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Qassika Goday Aaronako, “Enta biittafe nena gakiya gishoy woyko laati baawa; Isra7eele asaa giddon ne laataynne nena gakiya gishoy tana.” ");
INSERT INTO gofl_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Goday, “Leeweti geeshsha Dunkaaniyan oothiya oosuwas damooze gidana mela Isra7eele asay taw ehiya asraata ubbaa entaw immas. ");
INSERT INTO gofl_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Hachife doomidi Isra7eele asay banta nagara gaason hayqonna mela geeshsha dunkaaniyako shiiqopo. ");
INSERT INTO gofl_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Geeshsha dunkaaniya giddon ootheysatinne iya giddon poletiya nagaraa tookey Leeweta. Hessi yeletetha ubbaas merinaa woga. Leewetas Isra7eele asaa giddon laati baawa. ");
INSERT INTO gofl_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Hessa gisho, Isra7eele asay Godaas immiya asraata, ta Leewetas immas. Taani, entaw Isra7eele asaa giddon laati baawa giday hessasa” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Qassi Goday Museko, ");
INSERT INTO gofl_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“Neeni Leewetako haysada yaaga; taani hintew laata oothada immida asraata hinte Isra7eele asaape ekiya wode hinte he asraatape asraata Godaas immite. ");
INSERT INTO gofl_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Hinte imoy wudummafe shiiqida kathada woyko gum7iya bessaafe ha77i keyida woyneda hintew taybetana. ");
INSERT INTO gofl_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Hessadaka Isra7eele asaape hinte ekiya asraata ubbaafe dumma imo Godaas immite; hinte asraatape Godaa gisho gidida imota kahiniya Aaronas immite. ");
INSERT INTO gofl_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Hinte ekiya imota ubbaafe lo77uwanne geeshsha Godaas gisho oothidi immanaw bessees. ");
INSERT INTO gofl_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Ubbaafe lo77o imuwa hinte immiya wode attidaysi hintew buketiya wudumma kathaadanne gum7etiya woyniyada taybetana. ");
INSERT INTO gofl_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Attidaysi geeshsha Dunkaaniyan hinte oothiya oosuwas damooze gidiya gisho hintenne hinte soo asay awunka maanaw danda7eeta. ");
INSERT INTO gofl_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Lo77o baggaa Godaas immidaape guye hinte miiko hessi hintew nagara gidenna. Lo77o baggaa kessonna de7ishe he imotape midi hinte Isra7eele asaa imota tunisonna mela naagetite; hessa hinte oothonna ixiko hinte hayqana” yaagada Leewetas oda. ");
INSERT INTO gofl_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Goday Musekonne Aaronako, ");
INSERT INTO gofl_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“Goday higgiyan kiitetida wogay haysa; borsoy bayna, I gannan qambari wodhiboonna zo7o ussu ehana mela Isra7eele asaas odite. ");
INSERT INTO gofl_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Kahiniya Alaazaras iyo immite; gutaape iyo gaxa kessidi kahiniya sinthan shuko. ");
INSERT INTO gofl_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Kahiney Alaazari I suuthaafe guuthara ekidi ba biradhiyan geeshsha dunkaaniyako simmidi laapun toho wurxo. ");
INSERT INTO gofl_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Kahiney be7ishin ussiya xuugeto; galbay, ashoy, suuthaynne tocey xuugeto. ");
INSERT INTO gofl_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Kahiney ziga mithi, hisoophe tashenne zo7o qacina ekidi ussiya eexiya taman yeggo. ");
INSERT INTO gofl_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Hessafe guye, kahiney ba ma7uwanne ba asatethaa meecetidi gutaa gelo; shin omarsi gakanaw wogaada tuna gidana. ");
INSERT INTO gofl_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","He ussiw xuuggidaysi ba ma7uwanne ba asatethaa meeceto; ika omarsi gakanaw wogaada tuna gidana. ");
INSERT INTO gofl_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","“Hessafe guye, hara geeshsha asi ussiya xuugetida biduwa shiishidi gutaape gaxan geeshsha bessan wotho. Isra7eele asay tunatethaafe geeshshiya haathan go7etanaw hessi naagetidi uttana; hessi nagaraape geeshshanaw go77ees. ");
INSERT INTO gofl_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Qassi ussee biduwa shiishida urayka ba ma7uwa meecco; I omarsi gakanaw wogaada tuna gidana. Ha wogay Isra7eele asaasinne enta giddon de7iya hara dere asaas merinaa woga gidana. ");
INSERT INTO gofl_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“Aha bochiya oonika laapun gallas wogaada tuna gidana. ");
INSERT INTO gofl_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Tunatethaafe geeshshiya haathan heedzantho gallasinne laapuntha gallas I bana geeshsho; hessafe guye, I wogaada geeshshi gidana. Shin heedzantho gallasinne laapuntha gallas I bana geeshshona ixiko I geeshshi gidenna. ");
INSERT INTO gofl_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Hayqida asa aha bochiya oonika bana geeshshonna ixiko I Godaa dunkaaniya tunisees; he uray Isra7eele asaa giddofe kuretto. Tunatethaafe geeshshiya haathay iya bolla wurxetiboona gisho I tuna; I tuna gididi gam7ees. ");
INSERT INTO gofl_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“Issi asi dunkaaniya giddon hayqiko oothana wogay haysa; unkaaniya giddo geliya oonika, qassi dunkaaniya giddon de7iya oonika laapun gallas gakanaw tuna gidana. ");
INSERT INTO gofl_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Hessadaka, kamettonna dooya de7iya miishe ubbay tuna gidana. ");
INSERT INTO gofl_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Qassi denban hayqida asa aha woyko hargetidi hayqida asa aha woyko meqethi woyko duufo bochiya oonika laapun gallas gakanaw tuna gidana. ");
INSERT INTO gofl_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“Tunatethaafe geeshshanaw xuugetida ussee biduwape guuthara ekada oton yeggada pulto haathe iya bolla tiga. ");
INSERT INTO gofl_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Geeshsha asi hisoophe wurco ekidi haathan naaqi kessidi, dunkaaniya, iya giddon de7iya miishiyanne asa ubbaa bolla wurxo. Qassi hayqida asa aha woyko meqethi woyko duufo woyko hargeti hayqida asi bochida asa bolla wurxo. ");
INSERT INTO gofl_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Geeyida asi heedzantho gallasinne laapuntha gallas geeyiboonna uraa bolla wurxo. I laapuntha gallas he uraa tunatethaafe geeshsho; he geeyida addey, ba ma7uwanne ba asatethaa meeceto; he gallas omarsi I geeshshi gidana. ");
INSERT INTO gofl_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","“Shin tuna uray bana geeshshonna ixiko, he uray geeshsha dunkaaniya tunisida gisho, Isra7eele asaa giddofe kuretto; tunatethaafe geeshshiya haathay iya bolla wurxetiboona gisho I tuna. ");
INSERT INTO gofl_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Haysi hintew merina woga gidana. Tunatethaafe geeshshiya haatha wurxiya uray ba ma7uwa meecco; qassi tunatethaafe geeshshiya haatha bochiya oonika omarsi gakanaw tuna gidana. ");
INSERT INTO gofl_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Tuna uray bochiya aybibayka tunees; qassi he miishiya bochiya oonika omarsi gakanaw tuna gidees” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Koyro ageenan Isra7eele asa ubbay Siina mela biitta gakidi, Qaadesa geetetiya bessan dunkaanidosona. Mayraama yan hayqada moogetasu. ");
INSERT INTO gofl_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","He bessan asaas haathi dhayin, asay Muse bollanne Aarona bolla dendidosona. ");
INSERT INTO gofl_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Enti, “Nu ishati Godaa sinthan hayqida wode nuka hayqida gidorkoshin. ");
INSERT INTO gofl_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Nunne nu mehey ha mela biittan hayqana mela Godaa maabara ha bessa ayis ehidetii? ");
INSERT INTO gofl_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Gibxefe kessidi ha iita bessaa nuna ayis ehidetii? Haysan kathi woyko balasey woyko woyney woyko oromaaney baawa; hari attoshin uyetiya haathika haysan baawa” yaagidi Musera kacetidosona. ");
INSERT INTO gofl_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Yaatin Museynne Aaroni asaa matape geeshsha dunkaaniya penge bidi sa7an gufannidosona; Godaa bonchoyka entaw qoncis. ");
INSERT INTO gofl_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Goday Museko, ");
INSERT INTO gofl_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Ne xam7a eka; neeranne ne ishaa Aaronara maabara shiishite. Enta sinthan zaallay haathe kessana mela oda. Hinte zaallafe haathe kessidi, entanne enta mehiya ushshana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Goday kiitidaysada Musey Godaa sinthafe xam7aa ekis. ");
INSERT INTO gofl_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Museynne Aaroni maabara zaalla sinthan shiiqana mela oothidi, asaako, “Hinteno geellato, si7ite; ha zaallafe hintew nuuni tuma haathe kessanee?” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Musey ba xam7a denthidi zaalla nam7u toho shocis; haathi dhuuqidi keyin entinne enta meheti uyidosona. ");
INSERT INTO gofl_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Shin Goday Musekonne Aaronako, “Isra7eele asaa sinthan hinte ta geeshshatetha bessanaw ammanetibona gisho ta entaw immiya biitta ha asaa kaalethidi hinte geleketa” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Isra7eele asay Godaara kacetida gishonne Goday ba geeshshatetha enta giddon qoncisida gisho he bessay Mariba haatha geetetis. ");
INSERT INTO gofl_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Edoome kawako Musey Qaadesape haysada yaagidi kiita yeddis. “Ne ishay Isra7eeley haysada yaagees; nuna gakida meto ubbaa ne si7adasa. ");
INSERT INTO gofl_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Nu mayzati duge Gibxe wodhidosona; yan nuuni daro laythi de7ida. Gibxeti nunanne nu aawata un7ethidosona. ");
INSERT INTO gofl_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Nuuni Godaako waassin, I nu waasuwa si7idi, ba kiitanchuwa Kiitidi nuna Gibxefe kessis. Ha77i nuuni ne biitta gaxan de7iya Qaadesa kataman de7oos. ");
INSERT INTO gofl_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Hayyana, nuuni ne biittaara kanthidi aadhana mela ootharki; nuuni ogepe gaxa keyoko; ne goshsha woyko woyne gade giddo geloko; nuuni haatha ollafe haathe uyoko. Nuuni kawo oge oykidi baana; nuuni ne biittara kanthidi aadhana gakanaw haddirsi woyko ushachi gooko” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Shin Edoome asay, “Nu biittaara kanthisoko; hinte haysara kanthanaw qopiko, nuuni dendidi hintena olana” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Yaatin Isra7eele asay, “Nuuni kawo ogiyara baana; nuuni woyko nu mehey hinte haathaafe uyiko, nuuni hessas gate ciggana; nuuni tohora aadhetha xalaala koyoos; haraba aykoka koyoko” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Edoome asay zaaridi, “Hinte haysara aadhanaw danda7eketa” yaagis. Kaallidi, daronne wolqaama olanchota ekidi Isra7eele asaa olanaw keyis. ");
INSERT INTO gofl_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Edoome asay banta biittara Isra7eele asaa aathona ixin, Isra7eele asay simmidi hara ogera bidosona. ");
INSERT INTO gofl_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Isra7eele asa ubbay Qaadesape dendidi Hoora zumako bidosona. ");
INSERT INTO gofl_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Edoome zawan de7iya Hoora zuman, Goday Musekonne Aaronako, ");
INSERT INTO gofl_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“Aaroni ba mayzatan gahetiya wodey gakis. Hinte nam7ay Mariba haatha matan ta kiitaa bolla geellatida gisho Isra7eele asaas ta immiya biitta I gelenna. ");
INSERT INTO gofl_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Aaronanne iya na7aa Alaazara ekada Hoora zuma bolla keya. ");
INSERT INTO gofl_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Aarona kahinetetha ma7uwa qaarada, iya na7aa Alaazara mayza. Aaroni yan hayqana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Goday kiitidaysada Musey oothis; Isra7eele asa ubbay be7ishin, enti Hoora zuma bolla keyidosona. ");
INSERT INTO gofl_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Musey Aarona kahinetetha ma7uwa qaaridi iya na7aa Alaazara mayzis. Aaroni he zuma huuphen hayqis. Museynne Alaazari zumaape wodhidosona. ");
INSERT INTO gofl_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Aaroni hayqidaysa Isra7eele asay erida wode Isra7eele asay Aaronas hastamu gallas yeekidosona. ");
INSERT INTO gofl_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Kanaane biittan, Negebe mela biittan de7iya Arada Kawoy, Isra7eele asay Ataarima efiya ogiyara yeysa si7ida wode Isra7eele asaara oletidi entafe guutha asaa di7idosona. ");
INSERT INTO gofl_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","He wode Isra7eele asay, “Neeni ha asaa nu kushen aathada immiko, nuuni entanne enta katamata kumethi dhaysana” yaagidi Godaas qangidosona. ");
INSERT INTO gofl_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Goday Isra7eele asaa woosa si7idi, Kanaaneta enta kushen aathidi immin, enti Kanaanetanne enta katamata kumethi dhaysidosona. Hessa gisho, he bessay Horma geetetidi sunthetis. ");
INSERT INTO gofl_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Isra7eele asay Hoora zumaape dendidi, Edoome biitta yuushuwara baanaw Zo7o Abbaako efiya ogiyara bidosona; shin oge bolla asaas danda7ay wuris. ");
INSERT INTO gofl_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Asay, “Nuuni mela biitta hayqana mela Gibxefe nuna ayis kessidetii? Kathi baawa; haathi baawa; ha iita kathay nuna shaattis” yaagidi Xoossaa bollanne Muse bolla zuuzumidosona. ");
INSERT INTO gofl_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Yaatin, Goday asaa giddo marzera de7iya shooshi yeddin, Isra7eele asaape daroti duketidi hayqidosona. ");
INSERT INTO gofl_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Asay Museko yidi, “Nuuni Godaa bollanne ne bolla zuuzumidi, nagara oothida. Goday ha shooshata nuupe haassana mela nuus woossarki” yaagidosona. Yaatin, Musey asaa gisho woossis. ");
INSERT INTO gofl_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","He wode Goday Museko, “Naase biratape shooshi medhada, enta sinthan mitha bolla kaqa; shooshan duketida oonika iya be7iko paxana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Yaatin, Musey naase biratape shooshi medhidi, mitha bolla kaqis. Shooshan duketida asa ubbay naase birata shooshaa be7idi paxidosona. ");
INSERT INTO gofl_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Isra7eele asay Hoorape dendidi Obota geetetiya bessan dunkaanidosona. ");
INSERT INTO gofl_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Obotape dendidi, Moo7abepe sintha baggan de7iya mela biittan, doloha baggan Abariiman dunkaanidosona. ");
INSERT INTO gofl_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Yaape dendidi, Zareeda Zangaaran dunkaanidosona. ");
INSERT INTO gofl_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Yaape dendidi, Amooreta biitta gaxa gakanaw de7iya mela biittan Arnoona Shaafape hefinthan dunkaanidosona. Arnoona Shaafay Moo7abe biittasinne Amoore biittas giddon de7iya zawa. ");
INSERT INTO gofl_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Hessa gisho, Godaa ola taarikiya odiya maxaafan, “Suufa heeran de7iya Waaheba katamaanne Arnoona Shaafa zangaara, ");
INSERT INTO gofl_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","Era katamaanne Moo7abe biitta zawa gakanaw de7iya zangaara” yaagetidi xaafetis. ");
INSERT INTO gofl_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Enti yaape dendidi, Goday Museko, “Asaa shiisha; ta entaw haathe immana” yaagidi odida Beera geetetiya haatha ollaako bidosona. ");
INSERT INTO gofl_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","He wode Isra7eele asay ha mazmuriya yexidosona. “Haatha ollaw, pulta; Hinteka yexite. ");
INSERT INTO gofl_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Halaqati bookida haatha ollaas, kaaletheysati kawotetha xam7aninne banta xam7an bookida haatha ollaas yexite” yaagis. Enti he mela biittafe dendidi Mataana geetetiya bessaa bidosona. ");
INSERT INTO gofl_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","Maatanape Nahili7eela, Nahali7eelape Baamota geetetiya bessaa bidosona. ");
INSERT INTO gofl_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","Baamotape dendidi, Moo7aben de7iya zangaara bidosona; he zangaaray Pisga zumaape garsan bazzuwa ginan de7ees. ");
INSERT INTO gofl_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Hessafe guye, Isra7eele asay Amoore kawa Sihooneko haysada yaagidi kiita yeddidosona. ");
INSERT INTO gofl_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“Hayyana, nu ne biittara kanthidi aadhana mela ootharki; nuuni ogepe gaxa keyoko; ne goshsha woyko woyne gade giddo geloko; nuuni haatha ollafe haathe uyoko. Nuuni ne biittara kanthidi aadhana gakanaw haddirsi woyko ushachi gooko” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Sihooney Isra7eele asay ba biittara kanthonna mela diggis. I ba olanchota ubbaa shiishidi, Isra7eele asaa olanaw mela biitta bis; Yahaaxa geetetiya bessaa bidi Isra7eele asaara oletis. ");
INSERT INTO gofl_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Isra7eele asay olan Amooretape darota mashshan wodhidi, Arnoona Shaafape doomidi, Amooneta zawan de7iya Yaaboqa shaafa gakanaw oykis. Amoone asaa biitta zaway gimbetidi de7iya gisho, enti yaa gelibookona. ");
INSERT INTO gofl_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Isra7eele asay Amooreta, Haseboonanne iya yuushuwan de7iya katamata ubbaa xooni ekidi yan uttidosona. ");
INSERT INTO gofl_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Haseboona katamay Amooreta kawa Sihoone uttiya katama. Sihooney kase Moo7abe biitta kawa olidi, Arnoona shaafa gakanaw de7iya biitta ubbaa ekis. ");
INSERT INTO gofl_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Hessa gisho, leemison haysada yaagidosona; “Haseboonako haayite; ha katamay zaaridi keexeto; Sihoone katamay kase ba bessaa simmo. ");
INSERT INTO gofl_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Tami Haseboonape keyis; lacoy Sihoona kataman bentis; Moo7aben de7iya Era dhaysis; Arnoona dhoqa bessata mis. ");
INSERT INTO gofl_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Moo7abe, nena ayye! Kamoosha asay dhayideta. Hinte adde nayti baqatanaada, hinte macca nayti di7etanaada, Amooreta kawa Sihoones immis. ");
INSERT INTO gofl_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Nuuni hinte kochata Haseboonape doomidi, Diboona gakanaw kumethi dhaysida. Medeba matan de7iya Noofa gakanaw de7iya ubbaa tami dhaysis” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Yaatidi, Isra7eele asay Amooreta biittan de7idosona. ");
INSERT INTO gofl_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Qassi Musey wocheyisata Ya7izeera katamaa yeddin, Isra7eele asay he katamaanne iya heeran de7iya guutha katamata oykidi, yan de7iya Amooreta kessidi goodidosona. ");
INSERT INTO gofl_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Hessafe guye, Isra7eele asay simmidi, Baasane efiya ogiyara keyidosona. Baasane kawoy Oogey ba olanchotara Edraa7a kataman entara oletanaw keyis. ");
INSERT INTO gofl_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Shin Goday Museko, “Ha uraas babofa; hiza, kawa Ooge, iya asaanne iya biitta ubbaa ne kushen aathada immas. Haseboonan uttidi haarida Amooreta kawa Sihoone bolla ootheysada neeni iya bolla oothana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Hessa gisho, Isra7eele asay Ooge, iya naytanne iya asa ubbaa issoy attonna wodhidi iya biitta laattidosona. ");
INSERT INTO gofl_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Isra7eele asay dendidi, Iyaarko ginan, Yordaanosepe hefinthan de7iya Moo7abe denban dunkaanidosona. ");
INSERT INTO gofl_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Isra7eele asay Amooreta bolla oothidaysa ubbaa Sifoora na7ay Balaaqi si7is. ");
INSERT INTO gofl_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Isra7eele asay daro gidida gisho, Moo7abeti daro dagammidi yayidosona. ");
INSERT INTO gofl_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Moo7abeti Midiyaame cimatako, “Boori maata pitidi midi dhayseysada ha wude asay nu yuushuwan de7iya ubbaa midi dhaysana” yaagidosona. He wode Moo7abe kawoy, Sifoora na7ay Balaaqi, ");
INSERT INTO gofl_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Amawa biittan, Efraxiisa shaafa matan, Patoora kataman de7iya Bi7oora na7aa Balaamako haysada yaagidi kiittis. “Gibxefe keyida daro asay biitta ubbaa ma7idi, ta matan dunkaanidosona. ");
INSERT INTO gofl_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Enti taape daro wolqaama gidiya gisho, hayyana yada enta baaddarki. Ooni eri, ta enta xoonanawunne biittafe kessanaw danda7ana. Hiza, neeni anjeysi anjeteysa qassi neeni baaddeysi baadetidaba gideysa taani erayis” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Moo7abe cimatinne Midiyaame cimati baadetha miishiya ekidi Balaamako bidi Balaaqi gidaysa iyaw odidosona. ");
INSERT INTO gofl_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Balaami entako, “Hachi qamma haysan aqite; Goday taw odeysa ta hintew odana” yaagis. Yaanin, Moo7abe halaqati Balaamara gam7idosona. ");
INSERT INTO gofl_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Xoossay Balaama, “Haysati neera de7iya asati oonee?” yaagidi oychis. ");
INSERT INTO gofl_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Balaami Xoossaako, “Moo7abe kawoy, Sifoora na7ay Balaaqi, ");
INSERT INTO gofl_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘Gibxefe keyida daro asay, enti biitta ubbaa kumidosona. Neeni yada, enta baaddarki. Ooni eri, ta enta xoonanawunne biittafe kessanaw danda7onna aggike’ yaagidi enta taako Kiittis” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Yaatin Xoossay Balaamako, “Neeni entara boopa; Isra7eele asay anjetida dere gidiya gisho, neeni enta baaddofa” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Wontetha gallas wonta Balaami dendidi, Balaaqa halaqatako, “Taani hintera boonnada Goday diggida gisho, hinte biitta simmite” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Moo7abe halaqati Balaaqako guye simmidi, “Balaami nuura yoonna ixis” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Zaaridi Balaaqi kaseysatape aadho bonchetidanne taybon daro halaqata iyako kiittis. ");
INSERT INTO gofl_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Enti Balaamako bidi, “Sifoora na7ay Balaaqi, ‘Neeni taako yaanaysa nena aybika teqofo. ");
INSERT INTO gofl_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Ta new daro woyto immana; ne oychiyaba ubbaa ta new oothana. Hayyana yada ha asaa baaddarki’ yaagis” yaagidi odidosona. ");
INSERT INTO gofl_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Shin Balaami entako, “Balaaqi hari attoshin ba kawotethan kumida biraanne worqaa taw immiyaba gidikoka Godaa, ta Xoossaa kiitaa menthada aykoka pacisanaw woyko gujanaw danda7ike. ");
INSERT INTO gofl_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Goday taw bessiya harabay de7iko ta erana mela hinteka hachi qamma haysan aqite” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","He qamma Xoossay Balaamako, “Ha asay nena xeeganaw yida gisho, neeni entara ba; shin ta new odeysa xalaala ootha” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Yaatin wontetha gallas Balaami ba hariw kooridi Moo7abe halaqatara bis. ");
INSERT INTO gofl_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Shin I biya gisho Xoossay hanqetis. He wode Balaami ba hariw toggidi, ba nam7u aylletara bishin Godaa kiitanchoy iya teqanaw ogen eqis. ");
INSERT INTO gofl_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Godaa kiitanchoy mashsha shoddidi ogen eqidaysa hariya be7ada, ogiya aggada goshsha giddo gelasu. Balaami hariw ogen zaaranaw shocis. ");
INSERT INTO gofl_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Yaatin, Godaa kiitanchoy nam7u woyne gadetape giddon ya baggaranne ha baggara gimben diretida xuntha ogen eqis. ");
INSERT INTO gofl_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Hariya Godaa kiitanchuwa be7ida wode gimbe dirsaako shiiqida, Balaama tohuwa gimbe dirsara oythasu; yaatin I hariw nam7antho shocis. ");
INSERT INTO gofl_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Hessafe guye, Godaa kiitanchoy sintha aadhidi, haddirsi woyko ushachi simmanaw ogey bayna xuntha bessan eqis. ");
INSERT INTO gofl_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Hariya Godaa kiitanchuwa be7ada, Balaami toggidi de7ishin zin7asu; Balaami daro yilotidi, ba xam7an hariw shocis. ");
INSERT INTO gofl_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Hessafe guye, Goday harey doona dooyin, hariya Balaama, “Ta new ay iissin tana heedzu toho shocadii?” yaagasu. ");
INSERT INTO gofl_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Balaami zaaridi, “Neeni tana yiloyida gishosa; ta kushen mashshi de7iyaba gidiyako ta nena ha77i wodhanashin” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Hariya Balaamako, “Neeni hachi gakanaw toggiya ne hariw gidikina? Taani new haysada hana eriyana?” yaagasu. Balaami zaaridi, “Hana eraka” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","He wode Goday Balaama ayfiya dooyin, Godaa kiitanchoy shodetida mashsha oykidi ogen eqidaysa be7is. I lichi gidi som7ora sa7an gufannis. ");
INSERT INTO gofl_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Godaa kiitanchoy, “Ne hariw heedzu toho ayis shocadii? Ne ogey ta sinthan geella gidiya gisho ta nena teqanaw yas. ");
INSERT INTO gofl_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Hariya tana be7ada ta sinthafe heedzu toho hara soo simmasu. Hariya hara soo simmaboonnaba gidiyako, hannoode ta nena wodhada hariw ashshanashin” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Balaami zaaridi, “Taani nagara oothas; neeni tana teqanaw oge bolla eqidaysa ta erabike. Ne dosonnaba gidiko ta ha77i guye simmana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Shin kiitanchoy Balaamako, “Neeni ha asatara ba; shin ta new odeysa xalaala oda” yaagis. Yaatin, Balaami Balaaqa biitta halaqatara bis. ");
INSERT INTO gofl_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Balaami yeysa Balaaqi si7ida wode Arnoona shaafa gaxan ba biitta zawan de7iya Moo7abeta kataman iya mokanaw bis. ");
INSERT INTO gofl_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Balaaqi Balaamako, “Neeni ellesada yaana mela ta kiittabikina? Neeni ayis taako ellesada yabikii? Taani new kushe zaaranaw danda7ikina?” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Balaami Balaaqako, “Heko, ha77i ta neeko yas; shin ta aykoka taape gaanaw danda7ike. Xoossay tana oda gidaba xalaala odana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Yaatin, Balaami Balaaqara Qiriyat-Haxoota katamaa bis. ");
INSERT INTO gofl_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Yan Balaaqi mehenne dorse yarshidi, ashuwape guuthara Balaamasinne iyara de7iya halaqatas immis. ");
INSERT INTO gofl_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Wontetha gallas Balaaqi Balaama Baamot-Ba7aali geetetiya bessa kessis; Balaami yan eqidi Isra7eele asape baggaa be7is. ");
INSERT INTO gofl_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Balaami Balaaqako, “Haysan taw laapun yarsho bessata gimba; qassi laapun kormatanne laapun marazeta taw giigisa” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balaami gidaysada Balaaqi oothis; enti nam7ay issi issi yarsho bessan issi kormanne issi maraze yarshidosona. ");
INSERT INTO gofl_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Yaatidi, Balaami Balaaqako, “Neeni ne yarshuwa matan de7aasha; taani gede baana. Ooni eri Goday taara gahetanaw yoonna aggenna; I taw qoncisiyaba ubbaa ta new odana” yaagidi issi dere bolla keyis. ");
INSERT INTO gofl_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Yan Xoossay Balaamara gahetin, Balaami, “Taani laapun yarsho bessata giigisas; issi issi yarsho bessan issi kormanne issi maraze yarshas” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Balaami gaanaba Goday iyaw odidi, “Neeni Balaaqako simmada iyaw ha kiita oda” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Balaami simmiya wode Balaaqi Moo7abe halaqata ubbaara ba yarshuwa matan eqis. ");
INSERT INTO gofl_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Balaami haysada yaagidi tinbite odis; “Moo7abe kawoy, Balaaqi, doloha bagga deretape, Soore biittafe tana ehis; ‘Haa ya; Yayqooba taw bada; Isra7eele asaa baadda’ yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Xoossi baaddiboonaysa ta waatada baaddo? Goday, baaddiboonaysa ta waatada baaddo? ");
INSERT INTO gofl_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Ta dhoqa zaalla huuphen eqada enta xeellayis; zumaa bolla eqada enta be7ayis. Enti bantarka de7iya dere; enti hara kawotethatape dumma gideysa eroosona. ");
INSERT INTO gofl_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Yayqooba baana ooni taybi onganee? Isra7eele saysuwa ooni taybi kanthanee? Xillota hayquwa ta hayqarkina; ta wursethay entaysada hano” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Balaaqi Balaamako, “Neeni ta bolla oothiyabay aybee? Taani nena ta morketa baaddana mela ehas, shin neeni enta anjadasa; haraba aykoka oothabaaka” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Balaami zaaridi, “Goday taw odeysafe haraa odoyee?” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Balaaqi Balaamako, “Enta neeni be7anaw danda7iya hara bessi taara yedha; yanka ne entafe guuthara be7aasape attishin, ubbaa be7aka. Neeni yan eqada enta baaddarki” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Pisga deriya huuphen de7iya Xofima demba efis. Yan laapun yarsho bessata gimbidi, issi issi yarsho bessan issi kormanne issi maraze yarshis. ");
INSERT INTO gofl_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Balaami Balaaqako, “Neeni haysan ne yarshuwa matan de7aasha; taani Godaara gahetanaw gede baana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Goday Balaamara gahetidi, “Neeni Balaaqako simmada iyaw ha kiita oda” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Balaami simmidi yaa wode Balaaqi Moo7abe biitta halaqatara yarshuwa matan eqidaysa demmis. Balaaqi iyako, “Goday new ay odidee?” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Balaami haysada yaagidi tinbite odis; “Sifoora na7aw, Balaaqa, denda; ta odeysa loythada si7a. ");
INSERT INTO gofl_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Wordotanaw Xoossay ase gidenna; ba qofaa laammanaw asa na7a gidenna. Odidi, ba odidaysa oothennee? Woyko ba gidaysa polennee? ");
INSERT INTO gofl_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Taani anjanaw kiita ekas; I anjis; ta laammanaw danda7ike. ");
INSERT INTO gofl_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Yayqooba kochaa bolla iitabay yeenna; Isra7eele asaa metoy gakenna. Goday, enta Xoossay entara de7ees; I entaw kawo gideysa awaajosona. ");
INSERT INTO gofl_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Xoossay enta Gibxefe kessis; I mino menthada entaw oletees. ");
INSERT INTO gofl_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Yayqooba kochaa bolla biti oothenna; Isra7eele asaa qohana murunnoy baawa. Heko, Yayqoobasinne Isra7eeles ‘Xoossay oothidaba be7ite’ yaagana. ");
INSERT INTO gofl_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Ha asay macca gaammoda dendees; ba oykidaba maana gakanaw, ba wodhidaysa suuthaa uyana gakanaw, shemponna gaammoda dendoosona” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Yaatin, Balaaqi Balaamako, “Ne enta ubbaka baaddofa; ubbaka anjofa” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Balaami zaaridi, “Taani Goday giyaba xalaala oothana gada new odabikina?” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Balaaqi Balaamako, “Haaya; ta nena hara bessi efana. Ooni eri, hessan Xoossay ufaytidi, neeni yan eqada enta baaddana mela oothanaw danda7ees” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Balaaqi Balaama bazzuwa duge xeelliya Paa7ora zuma bolla efis. ");
INSERT INTO gofl_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Balaami, “Neeni haysan taw laapun yarsho bessata gimba; qassi laapun kormatanne laapun marazeta taw giigisa” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Balaami gidaysada Balaaqi oothis; issi issi yarsho bessan issi kormanne issi maraze yarshis. ");
INSERT INTO gofl_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Balaami Isra7eele anjeysi Godaa ufaysidaysa I be7ida wode kase I ootheysada bita malla koybeenna, shin ba som7uwa mela biittako zaaris. ");
INSERT INTO gofl_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","I dhoqu gidi xeelliya wode Isra7eele asay ba kochan kochan dunkaanidi uttidaysa be7iya wode Xoossaa Ayyaanay iya bolla wodhis. ");
INSERT INTO gofl_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","I haysada yaagidi tinbite odis; “Bi7oora na7aa Balaama tinbitiya; iya ayfey dooyetin xeelliya addiya tinbitiya; ");
INSERT INTO gofl_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","Xoossay giyaba si7eysa tinbitiya; I som7ora gufannin, iya ayfey dooyetidaysi; Ubbaa danda7iya Xoossaa qoncethaa be7ida addiya tinbitey haysa. ");
INSERT INTO gofl_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Yayqooba, ne dunkaaneti, Isra7eele, ne gutati, ayba lo77oona. ");
INSERT INTO gofl_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Enti micetida zangaarada, shaafa gaxan de7iya atakiltiya bessada, Goday tokida godare uuthada, haatha gaxan de7iya ziga mithada hanoosona. ");
INSERT INTO gofl_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Enta xuggay haathan kumana; enta kochay gidiya haathi demmana. Enta kawoy kawa Agaagape aadhana; enta kawotethay bonchetana. ");
INSERT INTO gofl_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Xoossay enta Gibxefe kessis; I mino menthada entaw oletees. Enta morketa mentherethees; enta meqethaa gaaccees; ba dongiyan caddees. ");
INSERT INTO gofl_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Enti gaammoda zin7idosona; macca gaammoda zaqullidosona; enta boshechanaw danda7ey oonee? Enta anjiya ubbay anjetana; enta baaddiya ubbay baadetana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Yaatin, Balaaqi Balaama bolla yilotis. Ba kushiya baqidi Balaamako, “Ta morketa baaddana mela ta nena ehas, shin neeni heedzu toho enta anjadasa. ");
INSERT INTO gofl_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Ha77i ellesada ne soo ba; ta nena darobaa woytana gas, shin neeni woytuwa ekonna mela Goday nena diggis” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Balaami Balaaqako zaaridi, “Neeni taako kiitida asaako, ");
INSERT INTO gofl_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‘Balaaqi hari attoshin ba kawotethan kumida biraanne worqaa taw immiyaba gidikoka Goday odidaysa menthada lo77o woyko iita ta shenen oothanaw danda7ike. Taani Goday giyaba xalaala odana’ gada new odabikinayee?” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Balaami Balaaqako, “Taani ha77i ta asaako bayis; shin ne haaya; Isra7eele asay yaana wodiyan ne asaa oothanaba ta new odana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","I ba tinbitiya haysada yaagidi odis; “Iya ayfey tishshi oothidi xeelliya, Bi7oora na7aa Balaama tinbitey haysa. ");
INSERT INTO gofl_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","Haysi Xoossay giyaba si7eysa tinbitiya, Ubbaa danda7iya Xoossafe gidida eratethi de7iya uray. Lichi gidi som7ora gufannin, iya ayfey dooyetidaysinne Ubbaa Danda7iya Xoossaa qoncethaa be7eysa tinbitey haysa. ");
INSERT INTO gofl_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","“Taani iya be7ayis, shin wodey ha7i gidenna; ta iya xeellayis, shin matan deenna. Yayqooba sheeshape xoolintoy keyana; Isra7eelepe kawotetha xam7ay keyana. Moo7abe asaa som7uwa I gaaccana; Seeta asaa ubbaa huuphiya I tinchana. ");
INSERT INTO gofl_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Edoomey xoonetana; iya morkey Sayrey oyketana; shin Isra7eeley minni minni baana. ");
INSERT INTO gofl_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Yayqoobape haareysi keyana; kataman paxa attidaysata dhaysana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Hessafe guye, Balaami Amaaleqa be7idi haysada yaagidi tinbite odis; “Amaaleqi kawotethata giddon koyro, shin enta wursethay dhayo” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Qassi Balaami Qeena be7idi haysada yaagidi tinbite odis. “Hinte de7iya bessay saro bessi; hinte keethay zaalla bolla keexetis. ");
INSERT INTO gofl_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Shin Asooreti hintena di77iya wode, hinte Qeena asay dhayana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Wursethan Balaami haysada yaagidi tinbite odis; “Xoossay hessa oothiya wode, ooni de7on daanaw danda7ii? ");
INSERT INTO gofl_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Markabeti Qophiroosape yaana; enti Asoorenne Ebeera xoonana; shin entika qassi dhayana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Hessafe guye, Balaami dendidi ba soo simmis; Balaaqika ba ogiya bis. ");
INSERT INTO gofl_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Isra7eele asay Seexima geetetiya bessan dunkaanidi de7ishin, Isra7eele addeti Moo7abe maccatara laymato doomidosona. ");
INSERT INTO gofl_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","He maccasati banta xoossata yarshuwa maana mela xeegidosona. Enti he yarsho kathaa midi enta xoossata goyinnidosona. ");
INSERT INTO gofl_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Isra7eeleti Bi7eel-Fagoora geetetiya eeqa goyinnida gisho Goday enta bolla hanqetis. ");
INSERT INTO gofl_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Yaatin, Goday Museko, “Godaa hanqoy Isra7eelepe simmana mela kaalethiya asa ubbaa efada seeta gallas Godaa sinthan kaqa” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Musey Isra7eele daynnatako, “Hinte issoy issoy Bi7eel-Fagoora geetetiya eeqa goyinnida asa ubbaa wodhite” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Museynne maabaray ubbay geeshsha dunkaaniya pengen yeekishin, Isra7eeletape issoy Midiyaame maccasiw enta sinthara aathidi, ba keetha asaako ehis. ");
INSERT INTO gofl_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Kahiniya Aarona na7aa Alaazara na7ay Pinihaasi hessa be7ida wode maabara giddofe dendidi, toora ekidi, ");
INSERT INTO gofl_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","Isra7eele addiya kaallidi dunkaaniya giddo gelidi, uraanne maccasiw tooran caddidi kanthi kessis. Hessi hanin Isra7eeleta wursiya gadoy eqis. ");
INSERT INTO gofl_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Shin he gadoy laatamanne oyddu mukulu asaa wodhis. ");
INSERT INTO gofl_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Goday Museko, ");
INSERT INTO gofl_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“Kahiniya Aarona na7aa Alaazara na7ay Pinihaasi Isra7eele asaa giddon taani ta bonchuwas misheteysada mishetida gisho, taani hinte bolla hanqetida hanquwa doshisis. Taani ta qaanatiyan enta polo dhaysabike. ");
INSERT INTO gofl_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Hessa gisho, taani ta sarotetha caaquwa iyara caaqanaysa Pinihaasas oda. ");
INSERT INTO gofl_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","I ba Xoossaa bonchuwas mishetida gishonne Isra7eele asaas nagara atotetha ehida gisho, inne iya kochay merinaw kahine gidana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Midiyaame maccaseera hayqida uraa sunthay Saalu na7aa Zimira geetetees. Saalu Simoona kochan issi kochaa halaqa. ");
INSERT INTO gofl_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Hayqida Midiyaame maccase sunthay Kozibo; I aaway Zuri Midiyaameta kochaa halaqa. ");
INSERT INTO gofl_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Goday Museko, ");
INSERT INTO gofl_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“Midiyaame biitta asaa morkidi enta wodhite. ");
INSERT INTO gofl_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","Enti hintena morkidi Paa7oran cimmidosona qassi bosha gallas Paa7oran hayqida Midiyaameta kochaa halaqa na7e Kozibi gaason hintena morkidosona” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Boshaape guye, Goday Musekonne kahiniya Aarona na7aa Alaazarako, ");
INSERT INTO gofl_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“Laythi laatamanne iyape bolla gidida Isra7eeleta, olanaw danda7eyisata ubbaa, enta keethan keethan taybite” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Yaatin, Museynne kahiney Alaazari Yordaanose Shaafape hefinthan, Iyaarko matan, Moo7abe denban asaa shiishidi, ");
INSERT INTO gofl_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“Goday Muse kiitidaysada, laythi laatamanne iyape bolla gidida asaa taybidosona.” Gibxefe keyida Isra7eele asay haysata. ");
INSERT INTO gofl_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Isra7eele bayra na7aa Robeela kochati banta kochan kochan, Hanooka kochaa, Faalu kochaa, ");
INSERT INTO gofl_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","Hesiroona kochaanne Karma kochaa; ");
INSERT INTO gofl_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Haysati Robeela kochata; enta kumetha tayboy 43,730. ");
INSERT INTO gofl_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Faalu na7ay Eli7aaba; ");
INSERT INTO gofl_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","Eli7aaba adde nayti Nemu7eela, Daatanenne Abeero. Daataninne Abeeroy maabaray dooridaysata, shin enti Qorenne iya kaalleysatara tobbidi Godaa bolla makallidi Muse bollanne Aarona bolla dendidosona. ");
INSERT INTO gofl_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Biittay dooyetidi enta Qorera issife mittis; enta kaalliya 250 asaa tami min hayqidosona. Yaatin, harati enta be7idi naagetana mela malla gididosona. ");
INSERT INTO gofl_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Shin Qore adde nayti ubbay hayqidi dhaybookona. ");
INSERT INTO gofl_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Simoona kochati banta kochan kochan, Nemu7eela kochaa, Yamina kochaa, Yakina kochaa, ");
INSERT INTO gofl_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","Zaara kochaanne Saa7ula kochaa. ");
INSERT INTO gofl_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Haysati Simoona kochata; enta kumetha tayboy 22,200. ");
INSERT INTO gofl_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Gaade kochati banta kocha kochan, Xifoona kochaa, Haggi kochaa, Shuuna kochaa, ");
INSERT INTO gofl_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","Esina kochaa, Era kochaa, ");
INSERT INTO gofl_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","Arooda kochaanne Ari7eela kochaa. ");
INSERT INTO gofl_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Haysati Gaade kochata; enta kumetha tayboy 40,500. ");
INSERT INTO gofl_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Yihuda adde nayti Erinne Onani Kanaane biittan hayqidosona. ");
INSERT INTO gofl_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Yihuda kochati banta kochan kochan, Seela kochaa, Faaresa kochaanne Zara kochaa. ");
INSERT INTO gofl_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Faaresa kochay Hesiroonanne Hamuula. ");
INSERT INTO gofl_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Haysati Yihuda kochata; enta kumetha tayboy 76,500. ");
INSERT INTO gofl_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Yisakoora kochati banta kochan kochan, Toolla kochaa, Puu7a kochaa, ");
INSERT INTO gofl_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","Yasuuba kochaanne Shimroona kochaa. ");
INSERT INTO gofl_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Haysati Yisakoora kochata; enta kumetha tayboy 64,300. ");
INSERT INTO gofl_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Zabloona kochati banta kochan kochan, Sareda kochaa, Eloona kochaanne Yahilaala kochaa. ");
INSERT INTO gofl_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Haysati Zabloona kochata; enta kumetha tayboy 60,500. ");
INSERT INTO gofl_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Yoosefa nayta Minaasenne Efreema kochati banta kochan kochan, ");
INSERT INTO gofl_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Minaasey Makira yelis, Makiri Galada yelis. ");
INSERT INTO gofl_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Galada kochati, Izera koche, Kelega koche, ");
INSERT INTO gofl_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","Asir7eela koche, Seekema kochaa, ");
INSERT INTO gofl_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","Shamida kochenne Hefeera koche. ");
INSERT INTO gofl_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Hefeera na7ay Selophaadi macca na7a xalaala yelis; iyaw adde na7i baawa. Selophaada macca nayta sunthay Mahilo, No7o, Hoglo, Milkonne Tirxo. ");
INSERT INTO gofl_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Haysati Minaase kochata; enta kumetha tayboy 52,700. ");
INSERT INTO gofl_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Efreema kochati banta kochan kochan, Shutula kochaa, Bekera kochaa, Tahana kochatanne ");
INSERT INTO gofl_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Shutula na7aa Erana kochata. ");
INSERT INTO gofl_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Haysati Efreema kochata; enta kumetha tayboy 32,500. Yoosefa kochati banta kochan kochan haysata. ");
INSERT INTO gofl_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Biniyaame kochati banta kochan kochan, Beella kochaa, Asbeela kochaa, Akira kochaa, ");
INSERT INTO gofl_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","Shufaama kochaa, Hufama kochaa, ");
INSERT INTO gofl_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Beella na7aa Arada kochaanne Beella na7aa Naamane kochaa. ");
INSERT INTO gofl_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Haysati Biniyaame kochata; enta kumetha tayboy 45,600. ");
INSERT INTO gofl_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Daane kochati Saama kochaa. ");
INSERT INTO gofl_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Shuhaama kochaa kumetha tayboy 64,400. ");
INSERT INTO gofl_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Aseera kochati banta kochan kochan, Yimina kochaa, Yisiwa kochaa, Beri7a kochaa, ");
INSERT INTO gofl_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Beri7a na7a Hebeera kochaanne Beri7a na7aa Malki7eela kochaa. ");
INSERT INTO gofl_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Aseeras Saraho geetetiya macca na7i de7awusu. ");
INSERT INTO gofl_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Haysati Aseera kochata; enta kumetha tayboy 53,400. ");
INSERT INTO gofl_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Niftaaleme kochati banta kochan kochan, Yahixeela kochaa, Guna kochaa, ");
INSERT INTO gofl_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","Yexera kochaanne Shileme kochaa. ");
INSERT INTO gofl_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Haysati Niftaaleme kochata; enta kumetha tayboy 45,400. ");
INSERT INTO gofl_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Taybetida Isra7eele adde asaa tayboy kumethi 601,730. ");
INSERT INTO gofl_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Goday Museko, ");
INSERT INTO gofl_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“Ha kochatas enta sunthaa sunthaa taybuwan biitta shaakada laata oothada entaw imma. ");
INSERT INTO gofl_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Taybon dareysatas darsada qassi taybon guuxeysatas guuthada imma. Ubbayka xaafetida banta taybuwa keena eko. ");
INSERT INTO gofl_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Shin biittay saaman shaaketo; issi issi kochay laata ekey ba kochaa sunthan gido. ");
INSERT INTO gofl_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Issi issi laatay taybon darota giddoninne taybon guuthata giddon saaman shaaketees” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Banta zerthan zerthan taybetida Leewe kochati haysata; Gedisoona kochaa, Qahaata kochaanne Meraara kochaa. ");
INSERT INTO gofl_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Haysatika qassi Leewe kochata; Libina kochaa, Kebroona kochaa, Mohoola kochaa, Muse kochaanne Qore kochaa. Qahaati Amraama yelis. ");
INSERT INTO gofl_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Amraama mache sunthay Yokebeedo; iya Gibxen Leewepe yeletida Leewe na7a. Iya Aarona, Musenne enta michiw Mayraamo yelasu. ");
INSERT INTO gofl_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Aaronas Naadabe, Abyooda, Alaazaranne Itamaara geetetiya oyddu nayti de7oosona. ");
INSERT INTO gofl_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Shin Naadabeynne Abyoodi Godaa sinthan geeshshi gidonna taman yarsho yarshida gisho boshan hayqidosona. ");
INSERT INTO gofl_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Laythi issi ageenanne iyape bolla gidida Leewe adde nayta tayboy laatamanne heedzu mukula. Isra7eele asaa giddon entaw laata biitti imetiboonna gisho enti Isra7eeletara taybetibookona. ");
INSERT INTO gofl_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Yordaanose Shaafape hefinthan, Iyaarko matan, Moo7abe denban Museynne kahiney Alaazari Isra7eele asaa taybida wode taybetida asay haysa. ");
INSERT INTO gofl_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Museynne kahiney Aaroni koyro Siina mela biittan Isra7eele taybida wode taybetida asaape mexi issi asika attibeenna. ");
INSERT INTO gofl_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Goday ha Isra7eeletaba, “Enti ubbay mela biittan hayqana” yaagidi odida gisho, Yoofona na7aa Kaalebapenne Nawe na7aa Iyyasupe attishin, hari issi asika attibeenna. ");
INSERT INTO gofl_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Selophaadi Hefeera na7a; Hefeeri Galada na7a; Galadi Makira na7a; Makiri Minaase na7a; Minaasey Yoosefa na7a. Selophaada macca nayti Mahilo, No7o, Hoglo, Milkonne Tirxo. ");
INSERT INTO gofl_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Ha macca nayti geeshsha dunkaaniya pengen Muse sinthan, kahiniya Alaazara sinthan, halaqata sinthaninne maabara ubbaa sinthan eqidi, ");
INSERT INTO gofl_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“Nu aaway mela biittan hayqis; I ba nagaraa gaason hayqisipe attishin, Godaa bolla dendida Qore kaalleyisata giddon deenna. Iyaw adde na7i baawa. ");
INSERT INTO gofl_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Yaatin, nu aaway adde na7a yeliboona gisho iya sunthay iya kochaa giddofe waanidi dhayii? Nu aawa dabbota giddon nuus laata biitta imma” gidoosona. ");
INSERT INTO gofl_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Yaatin, Musey enta oysha Godaa sinthe shiishis. ");
INSERT INTO gofl_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Goday Museko, ");
INSERT INTO gofl_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“Selophaada macca nayta oyshay like; enta aawa dabbota giddon neeni entaw laata biitta imma; iya gishoy enta laata gido. ");
INSERT INTO gofl_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Qassi Isra7eele asaako, ‘Issi asi adde na7a yelonna hayqiko iya macca nayti laatto. ");
INSERT INTO gofl_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Iyaw macca na7i baynaba gidiko iya ishati laatto. ");
INSERT INTO gofl_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Iyaw ishi baynaba gidiko iya aawa ishati laatto. ");
INSERT INTO gofl_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Iyaw aawa ishi baynaba gidiko iya mata dabboy laatto. Taani Goday nena kiitidaysada haysi Isra7eele asaas woga gido’ ” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Goday Museko, “Abariima Zumaa bolla keyada ta Isra7eele asaas immida biitta be7a. ");
INSERT INTO gofl_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Ne be7idaape guye, ne ishaa Aaronada neka hayqada ne mayzatan gahetana. ");
INSERT INTO gofl_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","Xiina mela biittan, Mariba haatha matan asay ta bolla zuuzumida wode hinte nam7ay enta sinthan tana geeshshi oothidi bonchibeeketa” yaagis. (Mariba haathay Xiina mela biittan, Qaadesa geetetiya bessan de7iya pulto.) ");
INSERT INTO gofl_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Musey Godaako, ");
INSERT INTO gofl_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“Asa ubbaas de7o immiya Godaa Xoossaw, ne asay henthanchoy bayna wude mela gidonnaada, ");
INSERT INTO gofl_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","ha asaa sinthan keyaanne geliya qassi enta kaalethidi kessiyanne gelsiya issi asi ha maabara bolla shuuma” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Goday Museko, “Ayyaanay iyan de7iya Nawe na7aa Iyyasu ekada ne kushiya iya bolla wotha. ");
INSERT INTO gofl_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Iya kahiniya Alaazara sinthaninne maabara ubbaa sinthan essada enti be7ishin shuuma. ");
INSERT INTO gofl_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Isra7eele ubbay iyaw kiitetana mela ne maatape iyaw shaakada imma. ");
INSERT INTO gofl_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Ika Uriimen Godaa sheniya oychidi shaakiya kahiniya Alaazara sinthan eqo. Iyyasuynne Isra7eele maabaray ubbay Alaazara kiitan keyonne gelo” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Musey Goday kiitidaysada oothis; Iyyasu efidi, kahiniya Alaazara sinthaninne maabara ubbaa sinthan essis. ");
INSERT INTO gofl_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Goday kiitidaysada Musey ba kushiya iya bolla wothidi shuumis. ");
INSERT INTO gofl_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Goday Museko, ");
INSERT INTO gofl_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“Isra7eele asaa haysada yaagada kiitta; xuugetiya sawiya katha yarsho woden woden taw yarshite. ");
INSERT INTO gofl_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Godaas taman xuugetidi yarshetiya yarshoy haysa; kumetha bollara de7iya issi laythi kumida nam7u marazeta wonta wonta xuussa yarsho oothidi yarshite. ");
INSERT INTO gofl_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Marazetape issuwa wonta issuwa qassi omarsi yarshite. ");
INSERT INTO gofl_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","Qassi he maraziyara issi litiro shamaho zayten munuqetida issi kilo giraame lo77o giste dhiille katha yarsho yarshite. ");
INSERT INTO gofl_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Haysi Godaa ufaysiya xuussa yarsho. Ika Siina zuma bolla yarshetida koyro xuussa yarsho. ");
INSERT INTO gofl_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Koyro maraziyara issi litiro caala woyne ushsha yarsho oothidi yarsho bessan Godaas gussite. ");
INSERT INTO gofl_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Omarsi nam7antho maraziya yarshiya wode koyroysa mela katha yarshuwanne ushsha yarshuwa gujidi yarshite. Ika Godaa ufaysiya sawo yarsho gidana.” ");
INSERT INTO gofl_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“Sambaata gallas borey bayna issi laythi kumida nam7u marazeta zayten munuqetida nam7u kilo giraame lo77o giste dhiille ekidi katha yarshonne ushsha yarsho oothidi yarshite. ");
INSERT INTO gofl_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Gallas gallas yarshetiya xuussa yarshuwa bolla Sambaatan Sambaatan hinte yarshana xuussa yarshoynne ushsha yarshoy haysa.” ");
INSERT INTO gofl_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“Ageeni xeeriya koyro gallas nam7u wofaanota, issi marazenne issi laythi kumida borey bayna laapun dorsa urgeta xuussa yarsho oothidi Godaas yarshite. ");
INSERT INTO gofl_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","Issi issi wofaanuwara shamaho zayten munuqetida heedzu kilo giraame gidiya lo77o giste dhiillera katha yarsho oothidi yarshite. Qassi shamaho zayten munuqetida nam7u kilo giraame gidiya lo77o giste dhiilliya maraziyara wolla yarsha. ");
INSERT INTO gofl_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","Laapun marazetape issi issi maraze shamaho zayten munuqetida issi kilo giraame lo77o giste dhiillera xuugetiya sawiya katha yarsho oothada Godaas yarishsha. ");
INSERT INTO gofl_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Qassi ushsha yarshuwa issi issi wofaanuwas nam7u litiro woyne, issi maraziyas issi litironne bagga woyne ushshaanne issi issi dorsa urgiyas issi litiro gidiya woyne ushshi shiishite. Haysi laytha giddon ageeni xeeriya koyro gallasan oosetiya xuussa yarsho. ");
INSERT INTO gofl_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Gallas gallas yarshetiya xuussa yarshuwa bollanne ushsha yarshuwa bolla issi kole nagara yarsho oothidi Godaas yarshite.” ");
INSERT INTO gofl_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","“Koyro ageenan tammanne oyddantho gallasay Godaa Paasika bonchiya gallas gido. ");
INSERT INTO gofl_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Qassi he ageenan tammanne ichashantho gallasan Uytha ba7aaley bonchetees; he gallasaape doomidi laapun gallas gakanaw irshoy geliboonna uytha miite. ");
INSERT INTO gofl_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","He gallasatape koyro gallasan goyinnanaw shiiqite; he gallasan ay oosoka oothopite. ");
INSERT INTO gofl_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Borey bayna nam7u wofaanota, issi marazenne issi laythi kumida laapun dorsa urgeta xuussa yarsho oothidi Godaas yarshite. ");
INSERT INTO gofl_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Issi wofaanuwara shamaho zayten munuqetida heedzu kilo giraame lo77o giste dhiille, issi maraziyara nam7u kilo giraame dhiillenne ");
INSERT INTO gofl_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","laapun dorsa urgetape issi issi dorsaara issi kilo giraame dhiille yarshite. ");
INSERT INTO gofl_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Qassi issi deeshi deriya nagaraas atotethi gidana mela nagara yarsho oothidi yarshite. ");
INSERT INTO gofl_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Hessa ubba wode gallas gallas yarshetiya yarshuwa bolla gujidi yarshite. ");
INSERT INTO gofl_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Ubba wode oosetiya xuussa yarshuwa bollanne ushsha yarshuwa bolla gujidi laapun gallasi Godaas sawiya katha yarsho oothidi yarshite. ");
INSERT INTO gofl_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Laapuntha gallasan goyinnoos shiiqite; he gallas ay oosoka oothopite.” ");
INSERT INTO gofl_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","“Katha Shiisho Ba7aale saamintan koyro gallas goyinnoos shiiqiya wode hinte ooratha kathaafe yarsho yarshite; he wode ay oosoka oothopite. ");
INSERT INTO gofl_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Nam7u wofaanota, issi maraziyanne issi laythi kumida laapun dorsa urgeta Godaas sawiya xuussa yarsho oothidi yarshite. ");
INSERT INTO gofl_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","Issi issi wofaanuwara shamaho zayten munuqetida heedzu kilo giraame lo77o giste dhiille, issi dorsa urgiyara nam7u kilo giraame dhiillenne ");
INSERT INTO gofl_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","laapun dorsa urgetape issi issi urgiyara issi kilo giraame giste dhiille ekidi yarshite. ");
INSERT INTO gofl_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Iya bolla gujidi issi kole nagara atothetha yarsho oothidi yarshite. ");
INSERT INTO gofl_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Gallas gallas yarshetiya yarshuwa bollanne ushsha yarshuwa bolla katha yarsho yarshite. Hinte yarshiya meheti borey baynaba gido.” ");
INSERT INTO gofl_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“Laapuntha ageenas koyro gallasan goyinnanaw shiiqite; ay oosoka oothopite; he gallasay moyzey punetiya gallas. ");
INSERT INTO gofl_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Borey bayna issi wofaano, issi marazenne issi laythi kumida laapun dorsa urgeta sawiya xuussa yarsho oothidi Godaas yarshite. ");
INSERT INTO gofl_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","He wofaanuwara shamaho zayten munuqetida heedzu kilo giraame lo77o giste dhiille, issi maraziyara nam7u kilo giraame giste dhiillenne, ");
INSERT INTO gofl_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","laapun dorsa urgetape issi issi urgiyara issi kilo giraame dhiille yarshite. ");
INSERT INTO gofl_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Qassi issi kole hintew nagaraa atotethas yarshite. ");
INSERT INTO gofl_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Wogay kiiteysatho, ageena xeeron yarshetiya xuussa yarsho bolla, katha yarsho bolla, gallas gallas yarshetiya xuussa katha yarsho bollanne ushsha yarsho bolla gujidi yarshite; hessi Godaa sawiya xuussa yarsho. ");
INSERT INTO gofl_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","“Laapuntha ageenan tammantho gallasan ay oosoka oothopite; hintena kawushidi goyinnoos shiiqite. ");
INSERT INTO gofl_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Borey bayna issi wofaano, issi marazenne issi laythi kumida laapun dorsa urgeta sawiya xuussa yarsho oothidi Godaas yarshite. ");
INSERT INTO gofl_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Katha yarsho oothidi issi wofaanora shamaho zayten heedzu kilo giraame lo77o giste dhiille, issi dorsa urgiyara nam7u kilo giraame dhiillenne ");
INSERT INTO gofl_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","laapun dorsa urgetape issi issi urgiyara issi kilo giraame dhiille yarshite. ");
INSERT INTO gofl_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Qassi nagara yarsho oothidi issi kole yarshite. Nagara atothetha yarshuwa bolla, gallas gallas yarshetiya xuussa yarshuwa bolla, katha yarshuwa bollanne ushsha yarshuwa bolla hessa gujidi yarshite. ");
INSERT INTO gofl_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","“Laapuntha ageenan tammanne ichashantho gallasan, deexo ooso oothopite; laapun gallas kumethi Godaa bonchanaw Shaqara Ba7aale bonchite. ");
INSERT INTO gofl_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Borey bayna tammanne heedzu wofaanota, nam7u marazeta, issi laythi kumida tammanne oyddu dorsa urgeta sawiya xuussa yarsho oothidi Godaas yarshite. ");
INSERT INTO gofl_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Katha yarsho gidana mela tammanne heedzu wofaanotape issi issi wofaanuwara shamaho zayten munuqetida heedzu kilo giraame lo77o giste dhiille, nam7u marazetape issi issi urgiyara nam7u kilo giraame dhiillenne ");
INSERT INTO gofl_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","tammanne oyddu dorsa urgetape issi issi urgiyara issi kilo giraame dhiille yarshite. ");
INSERT INTO gofl_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","Qassi nagara yarshuwas issi kole yarshite. Hessi gallas gallas xuussa yarshuwa bolla, katha yarshuwa bollanne ushsha yarsho bolla gujidika yarshite. ");
INSERT INTO gofl_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","“Nam7antho gallasan tammanne nam7u borey bayna wofaanota, nam7u marazetanne issi laythi kumida tammanne oyddu urgeta yarshite. ");
INSERT INTO gofl_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","Wofaanotara, marazetaranne dorsa urgetara katha yarshuwanne ushsha yarshuwa wogay kiitteysa mela enta taybuwada yarshite. ");
INSERT INTO gofl_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","Gallas gallas yarshetiya xuussa yarshuwa bolla, katha yarshuwa bollanne ushsha yarshuwa bolla gujidi nagara yarshuwas issi kole yarshite. ");
INSERT INTO gofl_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","“Heedzantho gallasan borey bayna tammanne issi wofaanota, nam7u marazeta issi laythi kumida tammanne oyddu dorsa urgeta yarshite. ");
INSERT INTO gofl_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","Wofaanotara, marazetaranne dorsa urgetara katha yarshuwanne ushsha yarshuwa wogay kiitteysa mela enta taybuwada yarshite. ");
INSERT INTO gofl_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","Gallas gallas yarshetiya xuussa yarshuwa bolla, katha yarshuwa bollanne ushsha yarshuwa bolla nagara yarshos issi kole gujidi yarshite. ");
INSERT INTO gofl_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","“Oyddantho gallasan borey bayna tammu wofaanota, nam7u marazetanne issi laythi kumida tammanne oyddu dorsa urgeta yarshite. ");
INSERT INTO gofl_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","Wofaanotara, marazetaranne dorsa urgetara katha yarshuwanne ushsha yarshuwa wogay kiitteysa mela enta taybuwada yarshite. ");
INSERT INTO gofl_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","Gallas gallas yarshetiya xuussa yarshuwa bolla, katha yarshuwa bollanne ushsha yarshuwa bolla gujidi nagara yarshos issi kole yarshite. ");
INSERT INTO gofl_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","“Ichashantho gallasan borey bayna uddufun wofaanota, nam7u marazetanne issi laythi kumida tammanne oyddu dorsa urgeta yarshite. ");
INSERT INTO gofl_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","Wofaanotara, Marazetaranne dorsa urgetara katha yarshuwanne ushsha yarshuwa wogay kiiteysada enta taybuwada yarshite. ");
INSERT INTO gofl_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","Gallas gallas yarshetiya xuussa yarshuwa bolla, katha yarshuwa bollanne ushsha yarshuwa bolla gujidi nagara yarshos issi kole yarshite. ");
INSERT INTO gofl_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","“Usupuntho gallasan borey bayna hospun wofaanota, nam7u marazetanne issi laythi kumida tammanne oyddu dorsa urgeta yarshite. ");
INSERT INTO gofl_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","Wofaanotara, Marazetaranne dorsa urgetara katha yarshuwanne ushsha yarshuwa wogay kiitteysa mela enta taybuwada yarshite. ");
INSERT INTO gofl_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","Gallas gallas yarshetiya xuussa yarshuwa bolla, katha yarshuwa bollanne ushsha yarshuwa bolla gujidi nagara yarshos issi kole yarshite. ");
INSERT INTO gofl_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","“Laapuntha gallasan laapun wofaanota, nam7u marazetanne issi laythi kumida tammanne oyddu dorsa urgeta yarshite. ");
INSERT INTO gofl_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","Wofaanotara, Marazetaranne dorsa urgetara katha yarshuwanne ushsha yarshuwa wogay kiitteysa mela enta taybuwada yarshite. ");
INSERT INTO gofl_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","Gallas gallas yarshetiya xuussa yarshuwa bolla, katha yarshuwa bollanne ushsha yarshuwa bolla gujidi nagara yarshos issi kole yarshite. ");
INSERT INTO gofl_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","“Hospuntha gallasan goyinnanaw shiiqite; ay oosoka oothopite. ");
INSERT INTO gofl_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Borey bayna issi wofaano, issi maraze, issi laythi kumida laapun dorsa urgeta sawiya xuussa yarsho oothidi Godaas yarshite. ");
INSERT INTO gofl_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","Wofaanotara, Marazetaranne dorsa urgetara katha yarshuwanne ushsha yarshuwa wogay kiiteysada enta taybuwada yarshite. ");
INSERT INTO gofl_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","Gallas gallas yarshetiya xuussa yarshuwa bolla, katha yarshuwa bollanne ushsha yarshuwa bolla gujidi nagara yarshos issi kole yarshite. ");
INSERT INTO gofl_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","“Hinte gaso yarshuwa bollanne hinte dosa yarshuwa bolla xuussa yarsho, katha yarsho, ushsha yarshonne issifetetha yarsho Baaliya bonchanaw kiitetida wodiyan yarshite” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","Musey, Goday bana kiittidaysa ubbaa Isra7eele asaas odis. ");
INSERT INTO gofl_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Musey Isra7eele zeretha halaqatako, “Godaa kiitay haysa; ");
INSERT INTO gofl_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Issi asi Godaas issiba oothanaw caaqiko woyko issibaape bana naaganaw qangiko guye goonna polo. ");
INSERT INTO gofl_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","“Ba aawa son de7iya geela7iya Godaas issiba oothanaw caaqiko woyko issibaape bana naaganaw qangiko, ");
INSERT INTO gofl_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","I aaway iya caaqidaysa woyko iya qangetidaysa si7idi, iyo diggonna ixiko, iya polanaw koshshees. ");
INSERT INTO gofl_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","Shin I aaway hessa si7idi iyo diggiko I caaqoynne I qangethay attanaw danda7ees. I aaway iyo diggida gisho Goday iw atto gaana. ");
INSERT INTO gofl_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","“Gelonna macca na7iya caaqada de7ashe woyko issibaape bana naaganaw qangetada de7ashe azina geliko, ");
INSERT INTO gofl_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","I azinay hessa si7idi iyo diggonna ixiko iya ba caaquwanne ba qangetha polanaw koshshees. ");
INSERT INTO gofl_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","Shin I azinay hessa si7idi iyo diggiko iya caaqida caaqoy woyko qangetida qangethay iyo gomenna. Hessa Goday iw atto gaana. ");
INSERT INTO gofl_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","“Shin am7iya woyko sayo maccasi caaqida caaquwa woyko qangida qangetha polanaw bessees. ");
INSERT INTO gofl_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","“Azinara de7iya maccasi caaqiko woyko issiba oothanaw qangiko, ");
INSERT INTO gofl_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","I azinay hessa si7idi iyo diggonna ixiko, iya caaqida caaquwanne qangetida qangetha polo. ");
INSERT INTO gofl_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","I azinay hessa si7ida gallas iyo diggiko I caaqoy woyko iya oothanaw qangetida qangethay iyo gomenna. I azinay diggida gisho Goday iw atto gaana. ");
INSERT INTO gofl_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","I azinay iya caaqida caaquwa woyko iya bana kawushanaw qangetida qangetha laallanaw woyko minthanaw danda7ees. ");
INSERT INTO gofl_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Shin I azinay he gallas woyko wontetha gallas aykoka goonna ixiko, I caaquwa woyko I qangetha minthis guussu. I hessa si7idi, si77i giiko I qofaa ma7is guussu. ");
INSERT INTO gofl_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Shin I hessa si7i gam7idi zaari diggiyaba gidiko hessas oyshetey iya” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Hiza haysi azina giddoninne machi giddon, ba aawara son de7iya geela7o giddoninne I aawa giddon de7iya gahetethaba Goday Muses immida wogaa. ");
INSERT INTO gofl_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Goday Museko, ");
INSERT INTO gofl_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“Isra7eele asaa qohida gisho Midiyaame asaa olada halo keya; hessafe guye, neeni hayqada ne mayzata gakana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Hessa gisho, Musey asaako, “Midiyaame asaa olidi Godaa halo keyana mela hinte giddofe guutha asaa olas dancisite. ");
INSERT INTO gofl_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Issi issi Isra7eele kochaafe issi mukulu adde asaa olas yeddite” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Hessa gisho, issi issi Isra7eele kochaafe issi issi mukulu asay keyidi, tammanne nam7u mukulu olanchoti olas giigidosona. ");
INSERT INTO gofl_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Musey kahiniya Alaazara na7aa Pinihaasa aawatethan, issi issi kochaafe issi issi mukulu asi dooridi olas yeddis; Pinihaasi bishe geeshsha miishetanne mallas punniya zaye ekidi bis. ");
INSERT INTO gofl_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Goday Muse kiitidaysada, enti Midiyaame asaa olidi adde ubbaa wodhidosona. ");
INSERT INTO gofl_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Ichashu Midiyaame kawota, Ewa, Reqeema, Zura, Huranne Reeba geetetiya asata wodhidosona; qassi Bi7oora na7aa Balaamaka mashshan wodhidosona. ");
INSERT INTO gofl_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Isra7eele asay Midiyaame maccasaanne nayta di7idosona; enta mehiya, dorsaanne deesha wudiyanne enta miishe ubbaa di7idosona. ");
INSERT INTO gofl_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Enti de7iya katamatanne enta gutata ubbaa xuuggidosona. ");
INSERT INTO gofl_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Asaa mehiyanne de7idaba ubbaa ekidi bidosona. ");
INSERT INTO gofl_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","Enti di7ida asaa, mehiyanne shalo ubbaa Iyaarkofe hefinthan, Yordaanose shaafa matan de7iya Moo7abe denban dunkaanida Museko, kahiniya Alaazarakonne Isra7eele maabaraako ehidosona. ");
INSERT INTO gofl_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Musey, kahiniya Alaazarinne maabara halaqati ubbay dunkaanida gutaape gaxa keyidi entana mokidosona. ");
INSERT INTO gofl_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Musey olape simmida tora moconata, shaalaqatanne mato halaqata bolla hanqetis. ");
INSERT INTO gofl_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Musey entako, “Maccasa ubbaa ayis wodhibeeketii? ");
INSERT INTO gofl_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Enti Balaama zoriya si7idi, Pe7oora geetetiya bessan Isra7eele asay Godaa aggidi, boshan hayqanaada oothiday maccasa gideysa dogidetii? ");
INSERT INTO gofl_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Hessa gisho, ha77i adde naytanne addera aqida maccas ubbaa wodhite. ");
INSERT INTO gofl_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","Shin addera aqiboona macca nayta ubbaa hintew ashshite. ");
INSERT INTO gofl_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","Hinte giddofe ase wodhida asi woyko aha bochida oonika gutaape gaxan laapun gallas utto; heedzantho gallasaninne laapuntha gallasan hintenanne hinte di77ida asaa geeshshite. ");
INSERT INTO gofl_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Hessadaka ma7o ubbaa, galbafe, deesha ikisepenne mithafe oosetidabata ubbaa geeshshite” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Kahiney Alaazari olape simmida olanchotako, “Goday Muses immida higgiya maaray haysa; ");
INSERT INTO gofl_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","Worqa, bira, naase, birata, qorqoro, irsaase, ");
INSERT INTO gofl_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","taman meetetonnabati ubbay taman geeyanaw bessees. Shin taman meetetiyabati geeshsho haathan geeyanaw bessees. ");
INSERT INTO gofl_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Laapuntha gallasan hinte ma7uwa meeccite; hintena geeshshite. Hessafe guye, gutaa gelite” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Goday Museko, ");
INSERT INTO gofl_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“Neera, kahiniya Alaazararanne Isra7eele maabara halaqati di7etida asaanne mehiya taybite. ");
INSERT INTO gofl_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Ola bidaysatasinne boonnaysatas nam7u kessidi shaakite. ");
INSERT INTO gofl_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Ola bidaysata gishuwape ase gidin miizi gidin hare gidin dorse woyko deeshe gidin ichashu xeetape issino Godaas immite. ");
INSERT INTO gofl_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Enta gishuwape ekida Godaa imota kahiniya Alaazaras immite. ");
INSERT INTO gofl_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Hanko Isra7eeleta gakida gishuwape, ase gidin miizi gidin hare gidin dorse woyko deeshe gidin ishatammaafe issino ekidi Godaa Dunkaaniya aawatethan aysiya Leewetas immite” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Museynne kahiney Alaazari Goday kiitidaysada oothidosona. ");
INSERT INTO gofl_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","35","Olanchoti bantaw ekin attida di7oy 675,000 dorsata, 72,000 miizata, 61,000 haretanne 32,000 geela7o macca nayta. ");
INSERT INTO gofl_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Ola bidaysata gakida gishoy 337,500 dorsata; ");
INSERT INTO gofl_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","entafe Godaas imetiday 675. ");
INSERT INTO gofl_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","Miizati 36,000; entafe Godaas imetiday 72. ");
INSERT INTO gofl_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","Hareti 30,500; entafe Godaas imetiday 61. ");
INSERT INTO gofl_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","Maccasati 16,000; entafe Godaas imetiday 32. ");
INSERT INTO gofl_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Goday Muse kiitidaysada Godaa imota kahiniya Alaazaras immis. ");
INSERT INTO gofl_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","46","Ola boonna Isra7eele maabara gakida gishoy ola bida asaa gishuwara issi gina; ika 337,500 dorsata, 36,000 miizata, 30,500 haretanne 16,000 geela7o macca nayta. ");
INSERT INTO gofl_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Isra7eele maabara gakida gishuwape ishatamu asaapenne mehiyape isso isso kessidi Goday iya kiitidaysada geeshsha Dunkaaniya aawatethan aysiya Leewetas immis. ");
INSERT INTO gofl_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Hessafe guye, tora moconati, shaalaqatinne mato halaqati Museko shiiqidi, ");
INSERT INTO gofl_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","“Nuuni ne aylleti nu aawatetha garsan de7iya olanchota taybin issoyka pacibeenna. ");
INSERT INTO gofl_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Goday nu shempuwa ashshida gisho, nu issoy issoy ekida worqa alleeqota, sagaayota, toho albota, migiddota, haytha worqatanne qoodhe worqata Godaas immanaw ekidi yida” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Museynne kahiney Alaazari worqa alleeqota ubbaa entafe ekidosona. ");
INSERT INTO gofl_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Shaalaqatinne mato halaqati Godaas immida worqay nam7u xeetu kilo giraame gidis. ");
INSERT INTO gofl_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Hanko olanchoti ehida di7uwa bantaw ekidosona. ");
INSERT INTO gofl_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Museynne kahiney Alaazari shalaqatapenne mato halaqatape ekida worqa Godaa sinthan Isra7eele asaa hassayisiyaba oothidi geeshsha dunkaaniya giddo ehidosona. ");
INSERT INTO gofl_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Robeelanne Gaade kochaas daro mehey de7ees. Enti Ya7izeera biittaynne Galada biittay mehes inje gideysa, ");
INSERT INTO gofl_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","be7idi Museko, kahiniya Alaazarakonne Isra7eele maabara halaqatako yidi haysada yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","4","“Isra7eele asay laattana mela Goday maaddida biittay, Axaarotey, Dibooni, Ya7izeeri, Nimiri, Hasebooni, Eliyaali, Sebami, Naboynne Ba7ooni mehes inje biitta; nuus hinte aylletas daro mehey de7ees. ");
INSERT INTO gofl_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Nuuni hinte sinthan saba demmidaba gidiko, he biitta nuus hinte aylleta laata oothidi immite; nuna Yordaanose shaafape hefinthi pinthofite” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Musey Gaade kochatakonne Robeela kochatako, “Hinte bagga gidida Isra7eele asay olas biya wode hinte haysan uttanaw koyeetii? ");
INSERT INTO gofl_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Goday entaw immida biitta enti pinnonna mela hinte ayis enta wozanaa shugiseetii? ");
INSERT INTO gofl_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Qaadesa Barnefe ha biitta wochana mela hinte aawata ta yeddida wode entika haysada oothidosona. ");
INSERT INTO gofl_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Enti Eshkola Zangaara gakanaw bidi he biitta be7i simmidi Isra7eeleti Goday entaw immida biitta gelonna mela Isra7eeleta wozanaa shugisidosona. ");
INSERT INTO gofl_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","Goday he gallas daro hanqetidi haysada yaagidi caaqis; ");
INSERT INTO gofl_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‘Banta kumetha wozanaape tana kaalliboonna gisho, Gibxe biittafe keydaysatape laythi laatamanne iyape bolla gidida adde asaape issoyka Abrahaames, Yisaaqasinne Yayqoobas immana gada caaqida biitta gelekona. ");
INSERT INTO gofl_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","Banta kumetha wozanape kaallida gisho, Qeneza Yoofona na7aa Kaalebapenne Nawe na7aa Iyyasupe attishin, hari oonika gelenna’ yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Godaa hanqoy Isra7eele asaa bolla eexida gisho Godaa sinthan iita oothida he yeletetha ubbay dhayana gakanaw mela biittan oytamu laythi toylatidosona. ");
INSERT INTO gofl_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","Hinteno, nagaranchota nayto hinte aawata bessan eqidi Goday Isra7eele asaa bolla gujidi hanqetana mela ootheeta. ");
INSERT INTO gofl_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Hinte Godaa kaallonna ixiko, I qassika ba deriya mela biittan aggana. Entana gakiya dhayuwas hinte oyshetana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Enti Museko shiiqidi, “Nuuni haysan nu mehiyas dara, nu naytasinne nu machetas katama keexanaw koyoos. ");
INSERT INTO gofl_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","Shin Isra7eele asay banta bessaa ekana gakanaw nuuni ola miishe dancidi enta sinthan keyidi oletanaw giigetida. He wode he biittan de7iya asay nu naytanne nu macheta qohonna mela gimbetidi uttida katamatan de7ona. ");
INSERT INTO gofl_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Isra7eele asa ubbay banta laata laata ekana gakanaw, nuuni nu soo simmoko. ");
INSERT INTO gofl_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Nuuni nu laata Yordaanose shaafape hafinthan doloha baggan laattida gisho, Yordaanosepe hefinthan wuloha baggan entara laata ekoko” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Musey entako, “Hinte geysi tuma gidiko haysan Godaa sinthan ola baanaw dancetite. ");
INSERT INTO gofl_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","Goday ba morketa ba sinthafe gooddana gakanaw hinte ola miishiya dancidi, Yordaanose shaafa Godaa sinthan pinniko, ");
INSERT INTO gofl_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","he biitta Goday xoonidaape guye hinte simmanaw danda7eeta. He wode hinte Godaasinne Isra7eele asaas oletidi polideta guussu. Qassi he biittay Godaa sinthan hintew laata gidana. ");
INSERT INTO gofl_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","“Hinte hessa oothonna ixiko Godaa bolla nagara ootheeta; hiza, hinte nagaraa gisho hintena seeri gakanaysa loythi erite. ");
INSERT INTO gofl_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Hinte hintew katamata, hinte mehiyas dara keexite, shin hinte gelida qaala polite” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Gaade kochaynne Robeela, kochay Museko, “Nuuni ne aylleti ne kiitidaysada oothana. ");
INSERT INTO gofl_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Nu nayti, nu macheti, nu dorsatinne nu mehey haysan Galada katamatan de7ishshona. ");
INSERT INTO gofl_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","Shin nuuni ne aylleti, olanchoti ubbay, neeni nu goday gidaysada oletanaw Godaa sinthan Yordaanose shaafa pinnana” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Hessa gisho, Musey kahiniya Alaazara, Nawe na7a Iyyasunne Isra7eele kochata halaqata entaba yaagidi Kiittis. ");
INSERT INTO gofl_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","“Gaade kochaynne Robeela kochay ubbay ola miishiya dancidi, Godaa sinthan hintera Yordaanose shaafa pinnikonne hinte he biitta xooniko, hessafe guye, Galada biitta hinte enta laatisite. ");
INSERT INTO gofl_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","Shin enti ola miishiya dancidi, hintera pinnidi olas boonna ixiko, hinteda entaw Kanaane biittan laati imeto” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Yaatin. Gaade kochaynne Robeela kochay zaaridi, “Nuuni ne aylleti Goday gidaysa oothana. ");
INSERT INTO gofl_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Nuuni ola miishiya dancidi, Godaa sinthan Kanaane biitta gelanaw pinnana; shin nuuni laattiya laatay Yordaanosepe hafintha bagga gido” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Hessa gisho, Musey Gaade kochaas, Robeela kochaasinne Yoosefa na7aa Minaase kochaafe baggaas Amoore kawa Sihoona kawotethaanne Baasane kawa Ooge kawotethaa enta yuushuwan de7iya katamatara immis. ");
INSERT INTO gofl_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Gaade kochay Diboona, Axaarota, Aro7eera ");
INSERT INTO gofl_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","Axiroot-Shafaana, Ya7izeera, Yogiba, ");
INSERT INTO gofl_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","Beet-Nimiranne Beet-Harana geetetiya gimben diretida katamata zaaridi keexidosona; banta mehiyas dara keexidosona. ");
INSERT INTO gofl_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Robeela, kochay Haseboona, Eli7aala, Qiratayma, ");
INSERT INTO gofl_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","Naaba, Ba7aal-Ma7oonanne Sebama geetetiya katamata zaarethi keexidosona; he katamata sunthaa laammidosona. ");
INSERT INTO gofl_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Minaase na7aa Makira kochati Galada biitta oli oykidi yan de7iya Amooreta goodidosona. ");
INSERT INTO gofl_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Hessa gisho, Minaase na7aa Makira kochaas Musey Galada biitta immin enti yan de7idosona. ");
INSERT INTO gofl_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Minaase kochi gidida Ya7iri he si olli oykidi, “Ya7ira katamata” yaagidi sunthis. ");
INSERT INTO gofl_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Nooba Qanaata katamaanne iya yuushuwan de7iya gutata ollan oykide, ba sunthan “Nooba” gidi sunthis. ");
INSERT INTO gofl_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Museynne Aaroni kaalethin, Isra7eele asay, banta cugan cugan Gibxefe keyidi siiratida gutata odiya taarikey haysa. ");
INSERT INTO gofl_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Goday Kiittidaysa mela Musey enti siiratida bessata sunthaa ubbaa kaali kaali xaafis. ");
INSERT INTO gofl_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","Isra7eele asay koyro ageenan, tammanne ichashantho gallasan, Paasika bonchiya nam7antho gallas dendidi, Gibxe asa ubbay be7ishin, yayyonna Ramisepe keyidosona. ");
INSERT INTO gofl_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","He wode Gibxe asay Godaa gadon hayqida banta bayra nayta moogosona. Hessada oothidi, Goday enta xoossata bolla pirda ehis. ");
INSERT INTO gofl_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","Isra7eele asay Ramisepe dendidi Sukota geetetiya bessan dunkaanidosona. ");
INSERT INTO gofl_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","Sukotape dendidi mela biitta gaxan de7iya Etaaman dunkaanidosona. ");
INSERT INTO gofl_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","Etaamape dendidi Ba7ali-Xafoonape doloha baggan de7iya Pihahiroota simmidi Migdoola matan dunkaanidosona. ");
INSERT INTO gofl_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Pihahirootape dendidi, Zo7o Abbaa pinnidi, Suuza mela biitta bidosona. Etaama mela biittan heedzu gallas hemetidi Maaran dunkaanidosona. ");
INSERT INTO gofl_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","Maarape dendidi tammanne nam7u pultotinne laapun tammu zambati de7iya Eliman dunkaanidosona. ");
INSERT INTO gofl_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","Elimape dendidi Zo7o Abbaa matan dunkaanidosona. ");
INSERT INTO gofl_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","Zo7o Abbaa matape dendidi Siina mela biittan dunkaanidosona. ");
INSERT INTO gofl_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","Siina mela biittafe dendidi Rafaqan dunkaanidosona. ");
INSERT INTO gofl_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","Rafaqape dendidi Elusan dunkaanidosona. ");
INSERT INTO gofl_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","Elusape dendidi haathi bayna bessan Rafidiman dunkaanidosona. ");
INSERT INTO gofl_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","Rafidimape dendidi Siina mela biittan dunkaanidosona. ");
INSERT INTO gofl_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","Siina mela biittafe dendidi Kibirooti Hati7awan dunkaanidosona. ");
INSERT INTO gofl_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","Kibirooti Hati7awape dendidi Haxerootan dunkaanidosona. ");
INSERT INTO gofl_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","Haxerootape dendidi Irtiman dunkaanidosona. ");
INSERT INTO gofl_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","Irtimape dendidi Irmoon-Pareezan dunkaanidosona. ");
INSERT INTO gofl_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","Irmoon-Pareezape dendidi Libinan dunkaanidosona. ");
INSERT INTO gofl_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","Libinape dendidi Irisan dunkaanidosona. ");
INSERT INTO gofl_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","Irisape dendidi Qahelatan dunkaanidosona. ");
INSERT INTO gofl_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","Qahelatape dendidi Shefara zuman dunkaanidosona. ");
INSERT INTO gofl_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","Shefara zumaape dendidi Haraadan dunkaanidosona. ");
INSERT INTO gofl_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","Haradape dendidi Maqhelotan dunkaanidosona. ");
INSERT INTO gofl_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","Maqhelotape dendidi Tahatan dunkaanidosona. ");
INSERT INTO gofl_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","Tahatape dendidi Taaran dunkaanidosona. ");
INSERT INTO gofl_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","Taarape dendidi Mitiqan dunkaanidosona. ");
INSERT INTO gofl_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","Mitiqape dendidi Hashimoonan dunkaanidosona. ");
INSERT INTO gofl_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","Hashimoonape dendidi Moserootan dunkaanidosona. ");
INSERT INTO gofl_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","Moserootape dendidi Ben-Ya7iqanan dunkaanidosona. ");
INSERT INTO gofl_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","Ben-Ya7iqanape dendidi Hoor-Hagidigaadan dunkaanidosona. ");
INSERT INTO gofl_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","Hoor-Hagidigadape dendidi Yoxibaatan dunkaanidosona. ");
INSERT INTO gofl_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","Yoxibaatape dendidi Abroonan dunkaanidosona. ");
INSERT INTO gofl_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","Abroonape dendidi Exiyoon-Gabiran dunkaanidosona. ");
INSERT INTO gofl_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","Exiyooni-Gabirape dendidi Siina mela biittan Qaadesan dunkaanidosona. ");
INSERT INTO gofl_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","Qaadesape dendidi Edoome biitta zawan de7iya Hoora zuman dunkaanidosona. ");
INSERT INTO gofl_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","Kahiney Aaroni Godaa kiitan Hoora zuma bolla keyidi, Isra7eele asay Gibxe biittafe keyida oytamantho laythan, ichashantho ageenan, koyro gallasan yan hayqis. ");
INSERT INTO gofl_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","Aaroni Hoora zuma bolla hayqiya wode iyaw laythi xeetanne laatamanne heedza. ");
INSERT INTO gofl_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Negebe mela biittan Kanaanen de7iya Arada Kawoy Isra7eele asaa yuussaa si7is. ");
INSERT INTO gofl_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","Isra7eele asay Hoora zumaape dendidi Xalmoonan dunkaanidosona. ");
INSERT INTO gofl_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","Xalmoonape dendidi Punoonan dunkaanidosona. ");
INSERT INTO gofl_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","Punoonape dendidi Obotan dunkaanidosona. ");
INSERT INTO gofl_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","Obotape dendidi Moo7abe biitta zawan de7iya Abariiman dunkaanidosona. ");
INSERT INTO gofl_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","Abariimape dendidi Diboon-Gaadan dunkaanidosona. ");
INSERT INTO gofl_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","Dibon-Gaadape dendidi Almoon-Dibilatayman dunkaanidosona. ");
INSERT INTO gofl_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","Almoon-Dibilataymape dendidi Nabo zuma sinthan Abariima zumata bolla dunkaanidosona. ");
INSERT INTO gofl_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","Abariima zumatape dendidi Iyaarkofe hefinthan, Yordaanose shaafa matan de7iya Moo7abe denban dunkaanidosona. ");
INSERT INTO gofl_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","Yordaanose shaafa matan de7iya Moo7abe denban, Beet-Yashimootapenne Abeel-Saxima Zangaarape giddon dunkaanidosona. ");
INSERT INTO gofl_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","Iyaarkofe hefinthan, Yordaanose shaafa matan de7iya Moo7abe demban Goday Museko, ");
INSERT INTO gofl_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“Isra7eele asaas yaagada oda; Yordaanose shaafa pinnidi, Kanaane biitta hinte geliya wode ");
INSERT INTO gofl_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","he biittan de7iya asa ubbaa hinte sinthafe yedethite. Shuchafe masetidi oosetida misiletanne sheeshidi medhida eeqata dhaysite. Dhoqa goyinno bessata ubbaa laallite. ");
INSERT INTO gofl_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","He biitta ta hintew immida gisho iya laattidi yan de7ite. ");
INSERT INTO gofl_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","Hinte kochan kochan saama kessidi biitta shaaketite. Taybon dariya kochatas dalga laata immite; taybon guuxiya kochatas guutha laata immite. Saaman enta gakida biittay entaba gidana. Biittaa hinte mayzata kochan kochan shaakidi ekite. ");
INSERT INTO gofl_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","Shin he biittan de7iya asaa hinte yedethonna ixiko, hinte ashshidaysati hinte ayfiyas pinco, hinte miyiyas agunthu gidana; hinte daana biittan ubba wode ola denthidi hintena waaysana. ");
INSERT INTO gofl_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","Hinte enta yedethonna ixiko, ta enta bolla oothanaw halchidaba hinte bolla oothana gada oda” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","Goday Museko, ");
INSERT INTO gofl_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“Isra7eele asaas haysada gada oda; hinte Kanaane geliya wode ta hintew laata oothada immana biitta zaway haysa. ");
INSERT INTO gofl_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","Dugeha bagga zaway Siina mela biittafe dendidi Edoome zawa kanthees. Doloha baggara hinte zaway Maxine Abbaafe duge baggara doomidi, ");
INSERT INTO gofl_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","Aqirabima aadhiya bessaa shaakidi Siina biitta bazzuwa kanthidi dugeha baggara Qaades-Barne gakees. Yaape Hadar-Adaara kanthidi Aximoona gakees. ");
INSERT INTO gofl_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","Aximoonape dendidi Gibxe shaafa guye simmidi Medetiraane Abbaa gakees. ");
INSERT INTO gofl_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","“Wuloha bagga zaway Medetiraane Abbaa gaxa gidana. ");
INSERT INTO gofl_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","“Pudeha bagga zaway Medetiraane Abbaa kaallidi Hoora zuma gakanaw bees. ");
INSERT INTO gofl_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","Hoora zumaape Hamaata geliya bessaa gakanaw bees; he zawa wursethay Xadaada. ");
INSERT INTO gofl_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","Yaape dendidi Zifiroona gakidi, Haxar-Enaanan eqees; pudeha bagga zaway haysa. ");
INSERT INTO gofl_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","“Doloha bagga zaway Haxar-Enaanape Safaama mallaa gakees. ");
INSERT INTO gofl_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","Safaama mallafe dendidi Aynape doloha baggara Irbila duge wodhidi Kenereeta Abbaafe doloha baggara de7iya zumata gakees. ");
INSERT INTO gofl_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","Hessafe hinte zaway duge Yordaanose shaafa wodhi zawaydi Maxine Abbaa gakees. Hinte biitta yuusho zawati haysata” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","Musey Isra7eele asaa haysada yaagidi Kiittis; “Uddufun bagga kochaas hinte saama yeggidi shaakana laata biittay haysa. ");
INSERT INTO gofl_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","Robeela kochay, Gaade kochaynne Minaase kochaafe baggay, ");
INSERT INTO gofl_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","banta laata Iyaarkofe hefinthan, Yordaanose Shaafape doloha baggan ekidosona” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","Goday Museko, ");
INSERT INTO gofl_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“Kahiniya Alaazaranne Nawe na7aa Iyyasuy he biitta asaas shaako. ");
INSERT INTO gofl_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","Qassi biitta shaakanaw maadana mela issi issi kochaafe issi issi halaqa doorite.” ");
INSERT INTO gofl_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","Enta sunthay haysafe kaallidi de7eysa. Yihuda kochaafe Yoofona na7aa Kaaleba; ");
INSERT INTO gofl_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","Simoona kochaafe Amhuda na7aa Salam7eela; ");
INSERT INTO gofl_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","Biniyaame kochaafe Kisiloona na7aa Eldaada; ");
INSERT INTO gofl_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","Daane kochaafe Yogila na7aa Buuqa; ");
INSERT INTO gofl_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","Yoosefa na7aa Minaase kochaafe Sufeeda na7aa Hani7eela; ");
INSERT INTO gofl_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","Yoosefa na7aa Efreema kochaafe Shifixaana na7aa; Qamu7eela; ");
INSERT INTO gofl_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","Zabloona kochaafe Farnaaka na7aa Elsafaana; ");
INSERT INTO gofl_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","Yisakoora kochaafe Hooza na7aa Palxi7eela; ");
INSERT INTO gofl_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","Aseera kochaafe Salooma na7aa Ahuda; ");
INSERT INTO gofl_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","Niftaaleme kochaafe Amhuda na7aa Padahi7eela; ");
INSERT INTO gofl_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","Kanaane biitta Isra7eele asaas laata oothidi shaakidi immana mela Goday kiitida asati haysata” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","Iyaarkofe hefinthan, Yordaanose shaafa matan de7iya Moo7abe denban, Goday Museko haysada yaagis; ");
INSERT INTO gofl_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“Isra7eeleti banta laatape Leeweti daana katamatanne enta yuushuwan hentha biitta immana mela entaw oda. ");
INSERT INTO gofl_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","He katamati entaw duussa bessi gido; hentha biittati enta miizas, enta dorsaasinne enta hara mehetas gido. ");
INSERT INTO gofl_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","Hinte entaw immiya hentha biittay ubba baggara katamaa gimbe dirsaafe issi mukulu wadha gido. ");
INSERT INTO gofl_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","Katamaa giddo oothidi doloha baggara nam7u mukulu wadha, dugeha baggara nam7u mukulu wadha, wuloha baggara nam7u mukulu wadhanne pudeha baggara nam7u mukulu wadha wadhite. Leeweti he heera banta katamaas hentha biitta ootho. ");
INSERT INTO gofl_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","“Leewetas hinte immida katamati, ase wodhida uray baqatidi attiya usupun katamata; hessata bolla gujidika, oytamanne nam7u hara katamata entaw immite. ");
INSERT INTO gofl_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","Oytamanne hospun katamata enta hentha biittara issife Leewetas immite. ");
INSERT INTO gofl_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","Isra7eele asaa laatape enta laata mela daro kochaafe daro katama, guutha kochaafe guutha katama ekidi Leewetas immite” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","Goday Museko, ");
INSERT INTO gofl_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“Isra7eele asaako haysada yaaga; Yordaanose shaafa pinnidi, Kanaane biitta hinte geliya wode, ");
INSERT INTO gofl_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","issi asi qoponna ase wodhidaba gidiko he uray baqatidi attana mela katamata hintew doorite. ");
INSERT INTO gofl_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","Yan suuthu zaaranaw koya hayqida uraa dabbotape I attees. Shempo wodhida deriya sinthan pirdas shiiqonna hayqanaw bessenna. ");
INSERT INTO gofl_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","Ha hinte immiya usupun katamati hinte baqatidi attiya katama gido. ");
INSERT INTO gofl_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","Heedzu katamati Yordaanose shaafape doloha baggan gido; qassi attida heedzati Kanaane biittan gido. ");
INSERT INTO gofl_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","Ha usupun katamati eronna ase wodhida Isra7eele asay, betanchotinne guutha wodes hinte giddon de7iya asati baqatidi attiya bessi gido. ");
INSERT INTO gofl_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","“Issi asi hara asi birata miishen shocidi wodhiko he uray shempo wodhis; I hayqo. ");
INSERT INTO gofl_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","Issi asi wodhanaw danda7iya shuchan hara asi caddidi wodhiko he uray shempo wodhis; I hayqo. ");
INSERT INTO gofl_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","Issi asi wodhanaw danda7iya mitha miishen hara asi shocidi wodhiko he uray shempo wodhis; I hayqo. ");
INSERT INTO gofl_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","Suuthu zaariya mata dabboy he shempo wodhidaysa demmiko wodho. ");
INSERT INTO gofl_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","“Issi asi hara asi ba wozanan morkidi sugi yeggiko woyko hayqo gidi iya bolla issiba holin he uray hayqiko, ");
INSERT INTO gofl_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","woyko morkidi ba kushe cuucummidi dechin he uray hayqiko, I shempo wodhis; I hayqo. Suuthu zaariya mata dabboy shempo wodhidaysa demmiko wodho. ");
INSERT INTO gofl_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","“Shin morketethi baynan, issi asi hara asi akeekona sugidi woyko qoponna iya bolla issiba holiko, ");
INSERT INTO gofl_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","woyko wodhanaw danda7iya shuchu I be7onna iya bolla holin, he uray hayqiko, hessan morketethi bayna gishonne iya qohanaw qopidi dendonna gisho, ");
INSERT INTO gofl_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","duulatay iya giddoninne iya suutha zaaranaw koya uraa giddon pirdiya wogay kaallidi de7iya wogaatho gido. ");
INSERT INTO gofl_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","Eronna wodhidaysa suuthaa zaaranaw koyeysa kushepe he uraa duulatay ashshidi, I baqatidi attiya katamaa zaaro. He wode de7iya zayten tiyetida kahine halaqay hayqana gakanaw I yan de7o. ");
INSERT INTO gofl_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","“Shin eronna wodhidaysi baqatidi attiya katamaa zawape betiko, ");
INSERT INTO gofl_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","hayqida uraa dabboy iya demmidi wodhiko, shempo wodhon oyshetenna. ");
INSERT INTO gofl_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","He wode de7iya kahine halaqay hayqana gakanaw he eronna wodhida uray baqatidi attiya kataman utto. Shin he kahine halaqay hayqidaape guye eronna wodhida uray ba soo simmanaw danda7ees. ");
INSERT INTO gofl_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","“Ha wogaynne higgey hinte de7iya biittan hintewunne hinte zerethaas eqidi de7iya woga gido. ");
INSERT INTO gofl_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","“Ase wodhida oonika I shempo wodhidaysa nam7u woyko heedzu marki markatiko hayqo, shin issi asa markatethan oonika hayqanaw bessenna. ");
INSERT INTO gofl_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","Qassi shempo wodhida asape aca ekofite; I hayqanaw bessees. ");
INSERT INTO gofl_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","Baqatidi attiya katama betida oodefeka kahine halaqay hayqanaape sinthe ba soo simmana mela aca iyape ekofite. ");
INSERT INTO gofl_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","Suuthi biitta tunisiya gisho suuthu gussofite. Suuthu gussida uraa suuthaafe attishin, suuthi gukida biitta hara ogera tunatethaafe geeshshiya wogi baawa. ");
INSERT INTO gofl_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","Taani, Goday Isra7eele asaa giddon de7iya gisho, hinte de7iya biitta, taani aqiya biitta tunisopite” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","Yoosefa kochaafe, Minaase na7aa Makira na7aa Galada kochaa halaqati Musekonne Isra7eele halaqatako yidi ");
INSERT INTO gofl_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","“Nu godaw, Isra7eele asaas laata biitta saaman shaakada immana mela Goday nena kiittis; qassi nu ishaa Selophaada laata iya macca naytas immana mela nena kiittis. ");
INSERT INTO gofl_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","Enti hara koche gidida Isra7eele asi geliko enta laatay nu aawata laatape eketidi enta ekiya zerethas guzhetees. Hessa gisho, nuus saaman imetida laatay guuxees. ");
INSERT INTO gofl_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","Isra7eele asaas Ishatamantho Laytha bonchiya ba7aaley gakiya wode enta laatay enta ekida asaa kochaas guzhetees; hessa gidiko enta laatay nu aawata kochaa laatape eketana” yaagidosona. ");
INSERT INTO gofl_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","Hessa gisho, Musey Godaape ekida kiitaa Isra7eele asaas haysada yaagidi odis; “Yoosefa kochay gidaysi like. ");
INSERT INTO gofl_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","Goday Selophaada macca naytabaa kiittidaysi haysa; enti bantaw dosida azina gelanaw danda7oosona, shin enta kochaafe gidanaw koshshees. ");
INSERT INTO gofl_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","Isra7eele asaa laatay issi kochaafe hara kochaas aadhofo; Isra7eele asay banta kochaa laata biitta minthidi naago. ");
INSERT INTO gofl_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","Isra7eele asa giddon laata biitta ekida maccasi oonika ba aawa koche gidida azina gelanaw koshshees. Hessada oothiko enta kochaa laatay enta kushen gam7ees. ");
INSERT INTO gofl_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","Yaatiko, laatay issi kochaafe hara kochaako aadhenna. Issi issi kochay ba laata biitta oykida mela daana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","Yaatin, Selophaada macca nayti Goday Muse kiitidaysada oothidosona. ");
INSERT INTO gofl_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","Selophaada macca nayti, Mahilo, Tirxo, Hoglo, Milkonne No7o geeteteysati banta aawa ishata nayta gelidosona. ");
INSERT INTO gofl_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","Enti Yoosefa na7aa Minaase nayta kochaafe azina gelidosona; enta laatay enta aawa kochaas gidis. ");
INSERT INTO gofl_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","Iyaarkofe hefinthan, Yordaanose shaafa matan, de7iya Moo7abe Denban Muse baggara, Goday Isra7eele asaas kiitida higgetinne wogati haysata.");
INSERT INTO gofl_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","Ha maxaafan xaafetida qaala ubbay Yordaanose shaafape hefinthan de7iya mela biittan enti de7ishin, Musey Isra7eele asaas odida qaala. He wode enti Suufape sintha baggara Paarana katamaas issi baggara, qassi Tofeela, Laabana, Haxerootanne Dizaaba katamata giddon de7iya Yordaanose zangaaran de7oosona. ");
INSERT INTO gofl_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","Sayre deriya baggara Koreeba zumaape bidi Qaades-Barne gakanaw tohon tammanne issi gallasa oge. ");
INSERT INTO gofl_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","Gibxefe enti keyida oytamantho laythan, tammanne issintho ageenan, koyro gallasan, Goday entaba Muse kiittidaba ubbaa Isra7eele asaas odis. ");
INSERT INTO gofl_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","Hessi haniday Haseboona kataman kawotidi Amooreta haariya Sihoonanne Astarootaninne Edraa7an kawotidi Baasane haariya Ooge, Musey xoonidaape guyena. ");
INSERT INTO gofl_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","Asay Yordaanosepe doloha baggara, Moo7aben de7ishin, Musey ha higgiya haysada yaagidi entaw qoncisethi doomis. ");
INSERT INTO gofl_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","Nuuni Koreeba Zumaa bolla de7ishin, Goday, nu Xoossay nuuko haysada yaagis. “Hinte ha deriya bolla daro gam7ideta. ");
INSERT INTO gofl_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","Dunkaaniya laallite; dendidi derey dariya Amooreta biittanne Araban de7iya enta yuushuwan de7iya biitta ubbaa biite. Hessika Yordaanose zangaara, gezzenne gadha biitta, Negebanne Medetiraane Abbaa gaxa aadhite. Kanaane biitta biite; Libaanose dereta kanthidi, Efraxiisa Shaafa gakanaw biite. ");
INSERT INTO gofl_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","Heko, taani hintew ha biitta immas. Bidi hinte aawatas, Abrahaames, Yisaaqas, Yayqoobasinne enta sheeshas immanaw Goday caaqida biitta laattite” yaagis. ");
INSERT INTO gofl_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","Musey asaako, “He wode taani hintew haysada yaagada odas; taani tarka hintena tookanaw danda7ike. ");
INSERT INTO gofl_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","Goday, hinte Xoossay hinte taybuwa salo xoolintoda darsis. ");
INSERT INTO gofl_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","Goday hinte aawata Xoossay, hintena haysafe aathidi mukulu toho gujidi darsonne I gidaysada hintena anjo. ");
INSERT INTO gofl_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","Shin hinte metuwa, hinte toohuwanne hinte ooshsha ubbaa taani tarka waata tookanaw danda7ayna? ");
INSERT INTO gofl_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","Hinte kochatape cinca, akeekanchonne bonchetida asata doorite; taani hinte bolla enta halaqa oothana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","Hinte zaaridi, “Ne qofay lo77o” yaagideta. ");
INSERT INTO gofl_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","Hessa gisho, taani hinte kochaafe cincanne bonchetida asata ekada, shaalaqa, mato halaqa, hamsalaqanne asiralaqa, hintena ayseysata oothada hinte bolla shuumas. ");
INSERT INTO gofl_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","Taani enta, “Hinte ishata giddon de7iya odaa si7ite; he oday issi Isra7eele asaapenne iya ishaape giddon woyko Isra7eele asaapenne hara dere asape giddon de7iyaba gidikoka, odaa si7idi suure pirdite. ");
INSERT INTO gofl_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","Pirdi Xoossaba gidiya gisho, hinte pirdan issi baggaa maaddofite; gitaa si7eysada guuthaa si7ite; asa som7os yayyofite. Daro deexo gidida odata taako ehite; hessa taani si7ana.” ");
INSERT INTO gofl_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","Hinte oothanaba ubbaa ta he wode hintena kiittana. ");
INSERT INTO gofl_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","Hessafe guye, “Nuuni Koreeba zumaape dendida; Goday nu Xoossay nuna kiittidaysada, derey dariya Amooreta biitta biya ogen de7iya he hinte be7ida gitanne yashshiya mela biitta kanthidi Qaades-Barne gakida. ");
INSERT INTO gofl_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","Goday nu Xoossay nuna laatisiya, derey dariya Amooreta biittay haysa. ");
INSERT INTO gofl_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","Goday hinte Xoossay ha biitta hintew immis. Goday hinte aawata Xoossay hintew odidaysada keyidi, ha biitta laattite; yayofite; ufaysi qanxofite” yaagas. ");
INSERT INTO gofl_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","Hinte ubbay taako yidi, “He biitta xomoosidi, nu baanaw bessiya ogiyabanne gelana katamata hanota new ehiya asata nuupe sinthe yeddoos” yaagideta. ");
INSERT INTO gofl_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","He qofay taw lo77o daanin, hintefe tammanne nam7u asi, kochaafe kochaafe issi asi dooras. ");
INSERT INTO gofl_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","Enti bidi, he derey dariya biitta kanthidi, Eshkola zangaara gakanaw de7iya biitta wochidosona. ");
INSERT INTO gofl_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","He biittan doliyabape guutha ayfe banta kushen oykidi nuuko yidosona. Qassi, “Goday nu Xoossay nuus immiya biittay lo77o biitta” giya wore ekidi yidosona. ");
INSERT INTO gofl_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","Shin hinte Godaa hinte Xoossaa kiitta ixas gidi yaa boonna ixideta. ");
INSERT INTO gofl_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","Hinte dunkaaniya giddon issoy issuwara haysada yaagidi zuuzumideta. “Goday nuna ixida gisho, dhaysanaw Amoore biitta asata kushen aathidi immanaw Gibxe biittafe kessis. ");
INSERT INTO gofl_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","Yaatin yaa ayis baanee? Nu ishati, ‘He biittan de7iya asati nuupe daroosonanne aduqosona. Katamatika gitanne salo gakanaw gimbetidaysata. Hessa bolla qassi Anaaqe geetetiya daro adussa asata yan be7ida’ yaagidi, nu wozana til7isidosona” yaagideta. ");
INSERT INTO gofl_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","Yaatin taani, “Yayyofite woyko dagammofite. ");
INSERT INTO gofl_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","Hinte sinthara biya Goday hinte Xoossay kase Gibxen hinte ayfiya sinthan hintew oothidaysada ha77ika hintew I oletana. ");
INSERT INTO gofl_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","Qassi hinte ha mela biitta gakanaw yida oge ubban asi ba na7a tookeysada Goday hinte Xoossay hintena tookidaysa be7ideta” yaagas. ");
INSERT INTO gofl_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","33","Ha ubbay haninka, hinte dunkaanana bessaanne hinte baana ogiya bessanaw qamma tama tuussan, gallas shaara tuussan hintena kaalethida Godaa hinte Xoossaa ammanibeketa. ");
INSERT INTO gofl_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","“Goday hinte haasaya si7idi hanqetis; haysada yaagidi caaqis; ");
INSERT INTO gofl_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","taani hinte mayzatas immana gada caaqida ha lo77o biitta, ha iita yeletethaafe issoyka be7enna. ");
INSERT INTO gofl_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","Ha biitta be7anay Yoofona na7aa Kaaleba xalaala. I yedhida biitta iyasinne iya kochaas immana; I ba kumetha wozanaape Godaa kaallis” yaagidi caaqis. ");
INSERT INTO gofl_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","Hinte gaason Goday ta bollaka hanqetidi, haysada yaagis; “Hari attoshin, neka he biitta gelaka. ");
INSERT INTO gofl_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","Shin nena maaddiya Nawe na7ay, Iyyasuy he biitta gelana. I Isra7eele asaa he biittaa laatisanaw de7iya gisho neeni iya minthetha. ");
INSERT INTO gofl_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","Hinte, nu nayti di7etana gida guuthati, iitanne keeha shaakidi eronna hinte nayti he biitta gelana. Taani he biitta entaw immana; entika laattana. ");
INSERT INTO gofl_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","Shin hinte guye simmidi, Zo7o Abbaa efiya ogiya oykidi, mela biitta biite” yaagis. ");
INSERT INTO gofl_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","Hinte zaaridi, “Nuuni Godaa bolla nagara oothida; ha77i nuuni Goday nu Xoossay kiiteysada, keyidi oletana” yaagideta. Hinte ubbay ola miishe dancidi, derey dariya biitta keyidi oletanaysa laafaba oothidi qopideta. ");
INSERT INTO gofl_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","Shin Goday taako, “Taani entara doonna gisho, enti keyidi oletona mela oda. Akay, giiko, enta morketi enta xoonana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","Yaagin, taani hintew odas, shin hinte Godaa kiitta ixidetape attishin, ta odeysa si7ibeeketa; yaatidi otoron derey dariya biitta keydeta. ");
INSERT INTO gofl_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","He derey dariya biittan de7iya Amooreti hintera ola gahetidi, hintena mathi gooddeysada gooddidi, Sayre biittafe bidi Horma gakanaw shocidosona. ");
INSERT INTO gofl_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","Hinte guye simmidi, Godaako yeekideta; shin Goday hinte yeehuwa si7ibeenna woyko hayzibeenna. ");
INSERT INTO gofl_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","Hessa gisho, hinte Qaadesan adussa wode gam7ideta. ");
INSERT INTO gofl_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","Hessafe guye, Goday tana kiittidaysada, nuuni Zo7o Abbaa efiya ogiya oykidi guye simmidi mela biitta metootishe, derey dariya Sayre biittan daro gallasa toylatishe yuuyida. ");
INSERT INTO gofl_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","Hessafe guye, Goday taako haysada yaagis. ");
INSERT INTO gofl_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","“Ha derey dariya biitta adussa wode yuuyidaysi hintew gidana; pudeha bagga simmidi biite. ");
INSERT INTO gofl_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","Asaa neeni yaagada kiitta; ‘Sayren de7ey Eesawe nayta hinte ishata gidiya gisho enta biittara hinte kantheeta. Enti hintew yayyana, shin hinte keehi naagetite. ");
INSERT INTO gofl_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","Taani enta biittafe tohoy yedhiya bessa mela hintew immonna gisho entara oletofite. Taani derey dariya Sayre biitta laata oothada Eesawes koyrottada immas. ");
INSERT INTO gofl_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","Hinte miya kathaanne uyaa haatha entafe miishen shammite’ ” yaagada kiitta. ");
INSERT INTO gofl_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","Goday hinte Xoossay hinte oothidaba ubbaa anjis; hinte ha wolqaama mela biittan hemetiya wode hintena naagis. Oytamu laytha ubban Goday hinte Xoossay hintera de7is; hintew aybaaka pacisibeenna. ");
INSERT INTO gofl_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","Hessa gisho, “Nuuni nu ishata gidiya Eesawe nayti de7iya Sayre biittara kanthidi bida. Qassi Elaatanne Exiyoon-Gabira katamatape dendidi, Maxine Abbaako gathiya ogiya aggidi, Moo7abe mela biittara aadhida. ");
INSERT INTO gofl_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","Goday taako, ‘Taani enta biittafe aybaka hintew immonna gisho, Moo7abe asaara kacetofite woyko enta olopite. Era katamaa taani laata oothada Looxe kochaas koyro immas’ ” yaagis. ");
INSERT INTO gofl_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","(He biittan kase minonne daro gidida, qassi Anaaqe kochatada adusse gidida Emimeta geetetiya asati de7idosona. ");
INSERT INTO gofl_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","Enti Anaaqetada Raafaymeta geetetoosona. Shin Moo7abe asay enta Emimeta gidi xeegosona. ");
INSERT INTO gofl_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","Hoora biitta asay kase Sayren de7idosona, shin Isra7eele asay laattana mela Goday entaw immida biittan enti oothidaysada Eesawa kochati Hoorata enta biittafe shoddidosona. Qassi banta sinthafe enta dhaysidi enta bessan uttidosona.) ");
INSERT INTO gofl_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","Goday nuuko, “Ha77i dendite, Zareada Shaafa pinnite” yaagin, nuuni Zareda Shaafa pinnida. ");
INSERT INTO gofl_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","Nuuni Qaades-Barnefe dendidi, Zareda Shaafa pinnana gakanaw hastamanne hospun laythi aadhis. He wode Goday entaw caaqidaysada olas gakida adde ubbay wuris. ");
INSERT INTO gofl_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","Dunkaanida gutaape enti kumethi dhayana gakanaw, Godaa kushey enta bolla deexis. ");
INSERT INTO gofl_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","Olas gakida adde asa ubbay kumethi dhaydaapenne asaa giddofe hayqidi wuridaape guye, ");
INSERT INTO gofl_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","Goday taako, ");
INSERT INTO gofl_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","“Era ogiyara hachi hinte Moo7abe biitta kantheeta. ");
INSERT INTO gofl_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","Hinte Amoone asaa biitta gakiya wode enta bochofite woyko entara ooyetofite. Amoone asata biittafe aybibaaka taani hintew laata oothada immike. Taani he biitta Looxe kochaas laata oothada koyro immas” yaagis. ");
INSERT INTO gofl_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","He biittay kase yan de7iya asay xeegetiya sunthaa Raafaymeta biitta geetetidi xeegetees. Qassi Amooneti enta Zamzumeta gidi xeegosona. ");
INSERT INTO gofl_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","Enti Anaaqetada adusse, minonne daro dere, shin Goday enta dhaysin, Amooneti enta biitta laattidi uttidosona. ");
INSERT INTO gofl_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","Goday Sayren de7iya Eesawe kochaas oothidaysada, enta bolla oothis. Hessika I he biittan de7iya Hoorata dhaysin, Eesawe kochay enta biitta laattidi hachi gakanaw uttidosona. ");
INSERT INTO gofl_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","Gaaza gakanaw de7iya heeran de7iya Aweeti, Kaftoore biittafe yida Kaftooreti enta dhaysidi enta biittan uttidosona. ");
INSERT INTO gofl_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","Qassika Goday nuuko, “Dendite; Arnoona Shaafa pinnite. Heko, Amoore biitta asi gidida Haseboona kawa Sihoonanne iya biitta ta hinte kushen aathada immas; iya olidi iya biitta laattite. ");
INSERT INTO gofl_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","Hachife doomin salope garsan de7iya asa ubbay hintew yayyana mela taani oothana. Enti hintebaa si7iya wode ubban yashshan kokorana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","Hessafe guye, Qidemoota mela biittafe Haseboona kawa Sihoonas kiitanchota bolla haysada yaagada saro qaala kiittas. ");
INSERT INTO gofl_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","“Nuna ne biittara aatharki; nuuni wogga ogiya xalaala oykidi baana; iyape ushachi woyko haddirsi gooko. ");
INSERT INTO gofl_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","Nuuni miya kathasinne uyaa haathas miishe qanxana. Nu koyey ne biittara kanthi aatha xalaala. ");
INSERT INTO gofl_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","Sayren de7iya Eesawe kochatinne, Eran de7iya Moo7abe kochati nuna aathidaysada Goday nu Xoossay, nuus immiya biittas Yordaanose shaafa nuuni pinnana gakanaw yaara nuna aatha” yaagas. ");
INSERT INTO gofl_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","Shin Haseboona kawoy Sihooney nuna aathona ixis. Goday hinte Xoossay ha77i oothidaysada iya hinte kushen aathidi immanaw koyida gisho iya wozanaa muumisisdi, otorancho oothis. ");
INSERT INTO gofl_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","Hessafe guye Goday taako, “Heko, Sihoonanne iya biitta ta new aathada immo doomas; ha77i xoonada iya biitta laatta” yaagis. ");
INSERT INTO gofl_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","Sihooney ba olanchota ubbaa ekidi Yahaaxa geetetiya bessan nuura oletanaw keyis. ");
INSERT INTO gofl_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","Shin Goday nu Xoossay nuus iya aathidi immin, iya, iya adde naytanne iya olanchota ubbaa nuuni wodhida. ");
INSERT INTO gofl_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","He wode nuuni iya katamata ubbaa oykidi, iyan de7iya adde, maccanne na7a ubbaa ashshona dhaysida. ");
INSERT INTO gofl_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","Enta mehiyanne nuuni oykida katamatape di77idaysa xalaala nuus ekida. ");
INSERT INTO gofl_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","Arnoona Zangaara gaxan de7iya Aro7eerapenne he zangaara giddon de7iya katamaape bidi Galada biitta gakanaw nuura eqetida issi katamika deenna. Goday nu Xoossay enta ubbaa nu kushen aathidi immis. ");
INSERT INTO gofl_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","Shin nuuni Amoone biittako, Yaaboqa Shaafa gaxan de7iya biittako, gezze biittan de7iya katamatakonne Goday nu Xoossay nuuni boonna mela diggida bessaa ubbaa shiiqibooko. ");
INSERT INTO gofl_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","Hessafe guye, nuuni simmidi Baasane efiya ogiyara keyida. Baasane kawoy Oogey, ba olanchota ubbaara Edraa7a geetetiya bessan nuura oletanaw keyis. ");
INSERT INTO gofl_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","Shin Goday taako, “Iyaw yayyofa; taani iya, iya olanchotanne iya biitta ubbaa ne kushen aathada immas. Haseboonan uttidi kawotida Amooreta kawa Sihoona bolla oothidaysada neeni iya bolla oothana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","Hessa gisho, Goday nu Xoossay Baasane kawa Oogenne iya asa ubbaa nu kushen aathidi immis; nuuni entafe issuwaka ashshona wursidi wodhida. ");
INSERT INTO gofl_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","He wode nuuni iya katamata ubbaa oykida; nuuni oykiboonna issi katamika deenna; hessika, Baasane kawa Oogey Argoba biittan aysiya usupun tammu katamata ubbaa oykida. ");
INSERT INTO gofl_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","Ha katamati ubbay adussa gimben diretidaysatanne pengeti kobetidaysata. Gimbe dirsi bayna daro gutatika de7oosona. ");
INSERT INTO gofl_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","Haseboona kawa Sihoona bolla oothidaysada nuuni enta kumethi dhaysida. Enta katamatan de7iya adde, maccanne na7a ashshona dhaysida. ");
INSERT INTO gofl_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","Shin mehe ubbaanne katamatape di77idabaa nuus ekida. ");
INSERT INTO gofl_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","He wode nuuni Arnoona zangaarape bidi Armoona zumaa gakanaw de7iya biitta, Yordaanose Shaafape doloha baggara de7iya nam7u Amoore biittata kawotape ekida. ");
INSERT INTO gofl_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","(Sidoona biitta asay Armoona zumaa, Siriyoona gidi xeegiya wode, Amoore biitta asay Sanira gidi xeegosona.) ");
INSERT INTO gofl_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","Nuuni demba biittan de7iya katamata ubbaa, Galada biitta ubbaa, Baasane biitta ubbaanne Baasane biittan Oogey haariya Salakanne Edraa7a katamata gakanaw de7iya bessaa oykida. ");
INSERT INTO gofl_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","(Raafaymetape attiday Baasane kawa Ooge xalaala. Iya arsay birata arsi; he arsay hachi gakanaw Raaba geetetiya Amooneta kataman de7ees; iya adussatethay hospun wadha; gompay oyddu wadha.) ");
INSERT INTO gofl_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","He biitta nuuni laatidaape guye, Arnoona shaafa doonan de7iya Aro7eera katamaape doomidi de7iya bessaanne derey dariya Galada biittafe baggaa gujada iya katamatara Robeelasinne Gaade kochaas taani immas. ");
INSERT INTO gofl_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","Galadape attidaysanne Oogey haariya Baasane biitta ubbaa Minaase kochaa baggaas immas; hessika, Argoba kawotethaa. (He Baasane biittay ubbay Raafaymeta biitta geetetidi xeegetees. ");
INSERT INTO gofl_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","Minaase kochaafe Ya7iri kumetha Argoba biitta laattis; hessika Geeshuretanne Ma7ikata biitta gaxaa gakanaw de7iya Baasane biitta. I he katamata ba sunthan xeegetana mela oothis; hessa gisho, enti hachi gakanaw, Ya7ira katamata geetetidi xeegetoosona.) ");
INSERT INTO gofl_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","Galada biitta Minaase koche gidida Makiras immas. ");
INSERT INTO gofl_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","Robeelanne Gaade kochaas Galadape bidi Arnoona shaafa mata gakanaw de7iya biitta immas. Dugeha baggara Arnoona Shaafape baggay enta zawa; qassi pudeha baggara Amooneta biittas gaxa gidida Yaaboqa shaafay zawa. ");
INSERT INTO gofl_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","Wuloha baggara, enta zaway Araban de7iya Yordaanose shaafa gakees; hessika Galila Abbaafe doomidi Pisga zuma xaphon de7iya Maxine Abbaa (Hayqo Abbaa) gakanaasa. ");
INSERT INTO gofl_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","He wode taani hintena haysada yaagada kiittas. “Goday hinte Xoossay he biitta hinte laattana mela hintew immis. Hiza hintew de7iya tooranchota ubbaa ola miishe dancisidi, hinte ishata gidida Isra7eele asaape sinthe aathite. ");
INSERT INTO gofl_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","Hintew daro mehey de7eysa taani erayis; hessa gisho, hinte macheti, hinte naytinne hinte mehey taani hintew immida katamatan de7ishshona. ");
INSERT INTO gofl_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","Goday hintena shempisidaysada hinte ishata shempisana gakanawunne Yordaanose shaafape hefinthan Goday, hinte Xoossay entaw immiya biitta enti ekana gakanaw entaw oletite. Hessafe guye, taani hintew immida biitta simmeta” yaagis. ");
INSERT INTO gofl_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","Taani he wode Iyyasu haysada yaagada kiittas. “Goday, hinte Xoossay ha nam7u kawota bolla oothidaba ubbaa neeni ne ayfen be7adasa; hinte oykanaw biya kawotethata ubbaa bolla Goday hessada oothana. ");
INSERT INTO gofl_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","Hintew oletey Godaa hinte Xoossaa gidiya gisho, entaw yayyofite” yaagis. ");
INSERT INTO gofl_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","He wode taani haysada yaagada Godaa minthada woossas. ");
INSERT INTO gofl_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","“Ubbaa Haariya Godaw, ne gitatethaanne ne mino kushiya tana, ne aylliya bessanaw doomadasa. Ne oothiya wolqaama oosota oothanaw danda7ey salon gidin sa7an hara xoossi de7ii? ");
INSERT INTO gofl_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","Godaw, taani bada Yordaanose shaafape hefinthan de7iya derey dariya lo77o biittanne Libaanose deriya be7ana mela tana yeddarki” yaagas. ");
INSERT INTO gofl_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","Shin Goday hinte gaason tana hanqetidi si7onnan ixis. Goday taako, “Hiza new gidana; ha odaa nam7antho denthada haasayopa. ");
INSERT INTO gofl_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","Hessa aggada denda; Pisga zuma bolla keya; yan eqada he biitta wuloha bagga, pudeha bagga, dugeha bagganne doloha bagga ne ayfiya dhoqu oothada xeella. Neeni ha Yordaanose shaafa polo pinnaka. ");
INSERT INTO gofl_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","Shin neeni Iyyasu kiitta; iya zoranne minthetha. I ha asaa kaalethidi pinthananne ha neeni be7iya biitta enta laatisana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","Hessa gisho, nuuni Beet-Pa7oora sinthan de7iya zangaaran gam7ida. ");
INSERT INTO gofl_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","Ha77ika Isra7eele asaw, hinte de7on daana melanne Goday, hinte mayzata Xoossay, hintew immiya biitta hinte laattana mela ta hintena tamaarsiya wogaanne higgiya si7itenne oothite. ");
INSERT INTO gofl_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","Ta hintena kiittiya, Godaa hinte Xoossaa kiitta naagitepe attishin, iya bolla aykoka gujofite; iyape aykoka pacisopite. ");
INSERT INTO gofl_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","Bi7eel-Fagoora zuma bolla Goday oothidaba hinte, hinte ayfen be7ideta. Goday, hinte Xoossay Bi7eel-Fagoora eeqa goyinnidaysata ubbaa hinte giddofe dhaysis. ");
INSERT INTO gofl_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","Shin hinte Godaas, hinte Xoossaas ammanetida gisho, hachi gakanaw ubbayka de7on de7eeta. ");
INSERT INTO gofl_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","Heko, hinte laattanaw geliya biittan oothana mela Goday, ta Xoossay tana kiitida wogaanne higgiya ta hintena tamaarsas. ");
INSERT INTO gofl_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","Hinte enta naagitenne oothite. Hinte hessa oothiko, hinte ay mela cinceko hara asay hintena be7ana. Enti ha wogabaa si7iya wode, “Tumaka ha gita kawotethay cincanne akeekancho kawotethi” yaagana. ");
INSERT INTO gofl_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","Nuuni iya xeegiya wode ubban Goday, nu Xoossay nuus mata gideysada xoossi mata gidida hara ay wolqaama kawotethi de7ii? ");
INSERT INTO gofl_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","Taani hachi hinte sinthan wothiya ha higge ubbaa mela xillo gidida woginne higgey de7iya hara ay gita kawotethi de7ii? ");
INSERT INTO gofl_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","Hiza ne de7o laytha ubban ha ne be7idaba ubbaa dogonna melanne ne wozanan wothana mela naageta. Ne naytanne ne nayta nayta tamaarsa. ");
INSERT INTO gofl_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","Koreeba zumaa bolla Godaa, hinte Xoossaa sinthan hinte eqida wode Goday taako, “Ta qaala enti si7idi, banta laytha ubban taw yayyana melanne banta nayta hessa tamaarsana mela asaa taako shiisha” gidaysa akeekite. ");
INSERT INTO gofl_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","He wode hinte shiiqidi zumaa xaphon eqideta; salo gakanaw tami eexis. He zumaa xaphoy sakana dhumaninne shaaran goozetis. ");
INSERT INTO gofl_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","Goday tama giddon gididi hintew odis. Hinte iya girsa si7idetape attishin, iya malaa be7ibeeketa. ");
INSERT INTO gofl_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","Hinte oothana mela I hintena kiitida ba caaquwa hintew odis; hessika Tammu Kiitata. I enta nam7u loche shuchata bolla xaafis. ");
INSERT INTO gofl_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","Hinte laattanaw biya biittan oothana mela wogaanne higgiya hintena tamaarsana mela Goday tana he wode kiittis. ");
INSERT INTO gofl_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","Goday Koreeba zumaa bolla tama giddon gididi hintew odida gallas hinte iya malaa be7iboona gisho loythi naagetite. ");
INSERT INTO gofl_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","Adde woyko macca medhon oosetidaba gidin, ");
INSERT INTO gofl_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","sa7an de7iya do7a ubbaa leemison gidin, salora paalliya kafo ubbaa leemison gidin, ");
INSERT INTO gofl_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","sa7a bolla ulora gooshetiya medhetetha leemison gidin, haatha giddon de7iya molo leemison gidin, hinte tunonna mela hintew xoosse oothidi medhofite. ");
INSERT INTO gofl_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","Salo pude xeellida, Goday ne Xoossay salope garsan de7iya kawotethatas imida awa, ageena, xoolintotanne salo medhetethata ubbaa be7ida, ne entaw goyinnada balonna mela naageta. ");
INSERT INTO gofl_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","Shin Goday hintena hachi hinte hanidaysada baw dummatida ase oothanaw birata seerisiya cooce mela gidida Gibxefe kessidi ehis. ");
INSERT INTO gofl_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","Hinte gaason Goday tana hanqetidi, Yordaanose pinnonna melanne Goday hinte Xoossay, laata oothidi hintew immiya lo77o biitta taani gelonna mela caaqis. ");
INSERT INTO gofl_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","Hessa gisho, taani Yordaanose shaafa pinnonna ha biittan hayqana, shin hinte pinnidi he lo77o biitta laatteeta. ");
INSERT INTO gofl_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","Hiza Goday, hinte Xoossay hintera caaqida caaquwa dogopite. Goday, ne Xoossay nena oothofa gida ay medhon oosetida misile new eeqa oothonna mela naageta. ");
INSERT INTO gofl_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","Goday, ne Xoossay miya tamanne qanaatiya Xoossi. ");
INSERT INTO gofl_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","Ne naytanne, nayta nayta yelada he biittan adussa wode de7iya wode ay medhon oosetida misile goyinnada tuniko, qassi Godaa, ne Xoossa hanqethanaw iya sinthan iitaba oothiko, ");
INSERT INTO gofl_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","hinte Yordaanose shaafa pinnidi laattanaw biya biittafe issoyka attonna elle dhayanaw de7eysas, ta hachi hinte bolla salonne sa7a markayayis. Hinte polo dhayanape attishin, he biittan adussa wode de7eketa. ");
INSERT INTO gofl_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","Goday hintena hara asaa giddon laallana; hintena I laaliya kawotethata giddon hinte tayboy guutha gidana. ");
INSERT INTO gofl_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","Yan hinte mithafenne shuchafe asa kushen giigida be7onna, si7onna, moonnanne singonna xoossata goyinnana. ");
INSERT INTO gofl_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","Shin yan de7ashe ne Godaa, ne Xoossaa koyana; ne iya kumetha wozanapenne kumetha shempofe koyko demmana. ");
INSERT INTO gofl_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","He meto ubbaa giddon ne un7etada de7iya wode wursethan Godaako, ne Xoossaako simmananne iya qaalas kiitetana. ");
INSERT INTO gofl_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","Goday, ne Xoossay maarotethan kumida Xoosse gidiya gisho, I nena aggenna woyko dhaysena; ne mayzatas caaqida caaquwa dogenna. ");
INSERT INTO gofl_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","Goday biittan ase medhida gallasape doomidi, hintefe kase aadhida wodiya ane pilgite; hessa mela gitabay polo hani eriyako woyko si7etidi eriyako saluwas ha gaxape ya gaxaa gakanaw ane oychite. ");
INSERT INTO gofl_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","Tama laco giddon Goday haasayin si7idi, hinte dhayona de7on de7eysada Goday odishin si7idi, de7on de7ida hara asi de7ii? ");
INSERT INTO gofl_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","Woyko Goday, hinte Xoossay hinte xeellishin, Gibxe biittan hintew oothidaysada paacen, malaatan, malaalsiyaban, olan, wolqaama kusheninne micetida qesen, gita yashshan hara kawotetha giddo gelidi, issi kawotethaa baw ekanaw butetida hara xoossi de7ii? ");
INSERT INTO gofl_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","Goday, Xoosse gideysa hinte erana mela hessa I hintena bessis; iyape attishin, hara xoossi baawa. ");
INSERT INTO gofl_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","I hintena tamaarsanaw koyida gisho, ba girsaa salope sissis. Qassi ha sa7an ba gita tama hintena bessis; he tama giddofe hinte iya qaala si7ideta. ");
INSERT INTO gofl_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","I hessa oothiday hinte aawata siiqidi, entafe guye yeletiya enta sheeshata doorida gisho, hintena Gibxefe ba gita wolqan kessis. ");
INSERT INTO gofl_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","Hachi hinte be7eysada, hintena gelsanawunne enta biitta hintew laata oothidi immanaw, hintefe dariyanne wolqaamiya kawotethata hinte sinthafe yedethidi kessis. ");
INSERT INTO gofl_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","Hiza, bolla salon gidin, garsa sa7an gidin, Goday Xoosse gideysa erite; hinte wozanan wothite; hara xoossi baawa. ");
INSERT INTO gofl_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","Hessa gisho, hintewunne hintefe guye hinte naytas ubbabay lo77o gidana mela, qassi Goday hinte Xoossay hintew merinaw immiya biittan hinte laythay aduqana mela, taani hachi hintena kiittiya wogaanne higgiya naagite. ");
INSERT INTO gofl_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","Hessafe guye, Musey Yordaanose hefinthan doloha baggara heedzu katamata dummayis. ");
INSERT INTO gofl_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","Hessa I dummayiday kase morketethi bayna de7ishin, eronna de7ishe ase wodhida asi yaa baqatana melasa. He uray he katamatape issuwau baqatidi ba shempuwa ashshanaw danda7ees. ");
INSERT INTO gofl_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","Hessa gisho, Robeela kochaas gadhan dere bolla de7iya Boosora katamaa, Gaade kochaas Galadan de7iya Ramootanne Minaase kochaas Baasanen de7iya Goolana katamata dummayis. ");
INSERT INTO gofl_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","Musey Isra7eele asaas immida Godaa higgey haysa; ");
INSERT INTO gofl_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","Musey ha wogaa, awaajuwanne higgiya enti Gibxefe keyida wode immis. ");
INSERT INTO gofl_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","Hessi entaw imetiday enti Beet-Pa7oora katamaa sinthan de7iya Yordaanosepe doloha baggara de7iya zangaaran de7ishina. He bessay Museynne Isra7eele asay Gibxefe keyida wode olidi xoonida, Haseboonan uttidi Amoore haariya kawa Sihoona biitta. ");
INSERT INTO gofl_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","He wode enti iya biittanne Baasane kawa Ooge biitta, hessika Yordaanosepe doloha baggan de7iya nam7u Amoore kawota laattidosona. ");
INSERT INTO gofl_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","He biittay Arnoona zangaaran Aro7eera katamaape bidi, Siriyoona deriya gakees; Siriyoona geetetidi xeegetiya derey Armoona zuma. ");
INSERT INTO gofl_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","He biittay Yordaanosepe doloha baggara de7iya Araba biitta ubbaa ekidi bidi, Pisga deriya xaphon de7iya Maxine Abbaa gakees. ");
INSERT INTO gofl_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","Musey Isra7eele asaa ubbaa issife xeegidi, haysada yaagis; “Hinteno, Isra7eele asaw taani hachi hintew odiya wogaanne higgiya si7ite; enta tamaarite; minthidi naagite. ");
INSERT INTO gofl_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","Goday, nu Xoossay Koreeba zumaa bolla nuura caaqis. ");
INSERT INTO gofl_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","Goday he caaquwa caaqiday nu aawata xalaalara gidonashin, hachi de7on de7iya nu ubbaara caaqis. ");
INSERT INTO gofl_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","He zumaa bolla eexiya tama giddon gididi, Goday som7on hintera haasayis. ");
INSERT INTO gofl_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","Taani he wode Goday giyaba hintew odanaw, Godaapenne hintefe giddon eqas. Hinte tamas yayyidi zumaa bolla keyibeketa. Goday haysada yaagis. ");
INSERT INTO gofl_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","“Gibxe biittafe, aylletetha keethaafe nena woziday taani Godaa, ne Xoossaa. ");
INSERT INTO gofl_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","“Taape attishin, hara xoossati new de7opo. ");
INSERT INTO gofl_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","“Bolla salon de7iyaba gidin, garsa sa7an de7iyaba gidin, woyko haatha giddon de7iyaba gidin, ay misile new eeqa oothofa. ");
INSERT INTO gofl_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","Ne iyaw hokofa woyko iyaw goyinnofa. Taani tana ixeyisata aawata nagaraa gisho, nayta heedzanthonne oyddantho yeletaa gakanaw seerayis. Taani, Goday, ne Xoossay qanaatiya Xoossaa. ");
INSERT INTO gofl_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","Shin taani tana siiqeysatanne ta kiita naageysata mukulu yeletaa gakanaw ta merinaa siiquwa bessayis. ");
INSERT INTO gofl_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","“Godaa, ne Xoossaa sunthaa coo xeegopa. Goday ba sunthaa coo xeegiya uraa seeronna aggenna. ");
INSERT INTO gofl_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","“Goday, ne Xoossay nena kiittidaysada Sambaata gallasaa geeshshi oothada naaga. ");
INSERT INTO gofl_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","Neeni ne ooso ubbaa usupun gallasan ootha. ");
INSERT INTO gofl_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","Shin laapuntha gallasay Godaas, ne Xoossaas Sambaata. He gallas ay oosoka oothofa. Neeni woyko ne adde na7ay woyko ne macca na7iya woyko ne oosanchoy woyko ne oosanchiya woyko ne booray woyko ne harey woyko ne hara meheti woyko ne kataman de7iya bete asi he gallas ay oosoka oothopite. Neeni shempeysada ne adde aylleytinne macca aylleti shempo. ");
INSERT INTO gofl_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","Neeni Gibxe biittan aylle gidada de7idaysa dogopa. Goday, ne Xoossay ba wolqaama kushiyaninne ba micetida qesiyan yaape nena kessidaysa dogopa. Goday, ne Xoossay Sambaata gallas neeni naagana mela kiitiday hessa gishosa. ");
INSERT INTO gofl_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","“Goday, ne Xoossay new immiya biittan ne laythay aduqana malanne new lo77ana mela Goday, ne Xoossay nena kiittidaysada ne aawanne ne aayiw boncha. ");
INSERT INTO gofl_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","“Wodhopa. ");
INSERT INTO gofl_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","“Laammofa. ");
INSERT INTO gofl_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","“Kaysotopa. ");
INSERT INTO gofl_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","“Wordo markatofa. ");
INSERT INTO gofl_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","“Hara asa macho amottofa; iya keethaa, iya shooqa, iya adde aylliya woyko iya macca aylliw woyko iya boora woyko iya hariya woyko iyaw de7iyaba aybaka amottofa” yaagis. ");
INSERT INTO gofl_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","Zumaa bolla tama, shaaranne dhumaa giddofe Goday dhoqu gida girsan duulata ubbaas odida qaalati haysata. I enta bolla aybaka gujibeenna; enta nam7u loche shuchata bolla xaafidi taw immis. ");
INSERT INTO gofl_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","Zumay taman xuugetishin, dhumaa giddofe girsaa hinte si7ida wode hinte kochaa halaqatinne cimati taako yidi, ");
INSERT INTO gofl_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","haysada yaagidosona; “Nuuni Godaa, nu Xoossaa girsaa tamaa giddofe si7ida wode Goday, nu Xoossay ba bonchuwanne ba gitatetha nuna bessis. Xoossi asara haasayin si7idi asi de7on daanaw danda7eysa hachi nuuni be7ida. ");
INSERT INTO gofl_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","Shin ha wolqaama tamay nuna dhaysanaw danda7ees; yaatin, nuuni ayis hayqanee? Godaa, nu Xoossaa qaala nuuni nam7antho si7iko hayqana. ");
INSERT INTO gofl_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","Asho ma7ida asan nuuni si7idaysada tama giddon gididi odishin, de7o Xoossaa qaala si7idi de7on de7ida asi oonee? ");
INSERT INTO gofl_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","Hessa gisho, neeni shiiqada Goday, nu Xoossay giyaba ubbaa si7a; Goday, nu Xoossay new odiyaba nuus oda; nuka si7idi kiitetana” yaagideta. ");
INSERT INTO gofl_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","Hinte taw odishin Goday, hinte giyaba si7idi, taako haysada yaagis; “Ha asay new odiyaba ubbaa si7as; enti gidaba ubbay like. ");
INSERT INTO gofl_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","Entawunne enta naytas merinaw ubbabay injetana mela taw yayyanawunne ta kiita naaganaw entaw ubba wode hessa mela wozani de7eerenne. ");
INSERT INTO gofl_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","Ha77i neeni bada enti banta dunkaaniya simmana mela oda. ");
INSERT INTO gofl_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","Shin neeni haysan ta matan gam7a. Enti laattana mela taani entaw immiya biittan enti oothanaba neeni enta tamaarsana ta kiita, ta awaajuwanne ta higgiya ubbaa ta new odana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","Hinteno, Isra7eele asaw, Goday, hinte Xoossay hintena kiittidaba ubbaa oothanaw naagetite; iyape ushachi woyko haddirsi goopite. ");
INSERT INTO gofl_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","Hinte de7on daana mela, ubbay hintew injetana melanne hinte laattiya biittan hinte laythay aduqana mela, Goday hinte Xoossay hintena kiitida kiita naagite. ");
INSERT INTO gofl_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","Hinte laattanaw biya biittan hinte oothana mela ta hintena tamaarsana mela Goday, hinte Xoossay tana kiitida kiitay, awaajoynne higgey haysa. ");
INSERT INTO gofl_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","Ne laythay aduqana mela ne, ne naytinne ne nayta nayite Godaa ne Xoossaa yayya; ta hachi new immiya Godaa awaajiyanne higgiya ne laytha ubban naaga. ");
INSERT INTO gofl_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","Neno, Isra7eele si7a; ubbabay new injetana melanne Goday ne aawata Xoossay, new gidaysada maathinne eessi goggiya biittan ne darana mela ha higgeta si7a; minthada naaga. ");
INSERT INTO gofl_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","Neno, Isra7eele si7a; Goday nu Xoossay issi Xoossi. ");
INSERT INTO gofl_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","Ne Godaa, ne Xoossaa ne kumetha wozanaape, ne kumetha shempuwafenne ne kumetha wolqaafe dosa. ");
INSERT INTO gofl_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","Hachi ta nena kiittiya ha kiitaa ne wozanan wotha. ");
INSERT INTO gofl_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","Enta neeni ne nayta tamaarsa; neeni ne son uttiya wode, oge hemetiya wode, zin7iya wodenne dendiya wode entaba haasaya. ");
INSERT INTO gofl_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","Malla oothada ne kushen enta qacha; qassi ne som7on mallada wotha. ");
INSERT INTO gofl_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","Ne penge zizgeta bollanne ne dirsa pengiya bolla enta xaafa. ");
INSERT INTO gofl_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","Goday, ne Xoossay new immana gidi ne aawatas Abrahaames, Yisaaqasinne Yayqoobas caaqida, ne keexaboonna gitanne lo77o katamati kumida biitta new immana. ");
INSERT INTO gofl_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","Neeni shiishaboona duretethan kumida keethata, ne bookaboona haatha ollata, ne tokaboonna woynenne shamaho new immiya wode, neeni mada kallida wode, ");
INSERT INTO gofl_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","nena Gibxe aylletetha biittafe kessida, Godaa dogonna mela naageta. ");
INSERT INTO gofl_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","Godaa, ne Xoossaa yayya; iya xalaala goyinna; iya sunthan caaqa. ");
INSERT INTO gofl_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","Ne yuushon de7iya asay goyinniya hara xoossata goyinnofa. ");
INSERT INTO gofl_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","Ne giddon de7iya Goday, ne Xoossay qanaatiya Xoossu. Iya hanqoy ne bolla eexana; I nena biitta bollafe pitidi dhaysana. ");
INSERT INTO gofl_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","Masahan hinte iya paacidaysada Godaa hinte Xoossaa paacopite. ");
INSERT INTO gofl_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","Goday, hinte Xoossay hintena kiitida iya kiita, iya wogaanne iya awaajuwa minthidi naagite. ");
INSERT INTO gofl_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","New ubbabay injetana mela Godaa sinthan ne surebaanne lo77oba ootha. Hessa oothiko, new immanaw Goday ne aawatas caaqida, he lo77o biitta ne laattana. ");
INSERT INTO gofl_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","Goday gidaysada neeni, ne morketa ubbaa ne sinthafe gooddana. ");
INSERT INTO gofl_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","Wodepe ne nayti, “Goday, nu Xoossay hintena kiitida ha wogaa, awaajiyanne higgiya birshethay aybee?” yaagidi hintena oychiya wode, ");
INSERT INTO gofl_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","ne entaw haysada yaagada zaarana; “Nuuni Gibxe biittan Gibxe kawa aylleta, shin Goday ba mino kushiyan nuna Gibxefe kessis. ");
INSERT INTO gofl_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","Goday nu xeellishin, Gibxe biitta bolla, Gibxe kawa bollanne iya shuumata ubbaa bolla gitanne yashshiya malaatatanne malaalsiyabata oothis. ");
INSERT INTO gofl_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","Shin I nu mayzas immana gidi caaqida biitta nuus immanaw nuna Gibxefe kessis. ");
INSERT INTO gofl_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","Yaatidi hachi hinte be7eysada nuus ubba wode lo77o gidana melanne nuuni de7on daana mela, Goday, ha awaajota ubbaa nuni naagana melanne Godaas nu Xoossaas yayyana mela kiittis. ");
INSERT INTO gofl_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","I nuna kiittidaysada, Godaa, nu Xoossaa sinthan ha kiita ubbaa minthidi naagiko, hessi nuus xillotethi gidana” yaagite. ");
INSERT INTO gofl_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","Goday, ne Xoossay ne laattanaw biya biitta nena gelsiya wodenne neepe wolqaamanne minniya laapun kawotethata, hessatika Hiteta, Gergeseta, Amooreta, Kanaaneta, Parzeta, Hiwetanne Yaabuseta ne sinthafe gooddiya wode, ");
INSERT INTO gofl_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","Goday ne Xoossay ne kushen aathidi immin, ne enta xooniya wode, enta kumethi dhaysa. Entara aybibaaka caaqofa; entaw qadhetofa. ");
INSERT INTO gofl_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","Entara eketofa; geletofa. Ne macca nayta enta adde naytas immofa woyko enta macca nayta ne adde naytas ekofa. ");
INSERT INTO gofl_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","Enti ne nayta tana kaalleysa aggidi hara eeqata goyinnana mela oothana. He wode Godaa hanqoy ne bolla eexana; nena ellesidi dhaysana. ");
INSERT INTO gofl_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","Hessa gisho, enta yarsho bessa laallite; goyinno shucha eeqata mentherethite. Asheera geetetiya eeqa misiliya tincherethite; kushen oosetida misileta taman xuuggite. ");
INSERT INTO gofl_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","Neeni, ne Godaa Xoossaas geeshsha dere. Goday, ne Xoossay nena baw dumma asi oothidi biitta bolla de7iya asa ubbaafe nena dooris. ");
INSERT INTO gofl_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","Goday hintena dosidaynne dooriday hinte hara asaape taybon darida gisho gidenna. Hinte hara asa ubbaafe taybon guutha. ");
INSERT INTO gofl_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","Shin Goday hintena dosida gishonne hinte mayzatas caaqida caaquwa naagida gisho, I hintena aylletetha biittafe, Gibxe kawa kushepe, ba wolqaama kushiyan kessisinne wozis. ");
INSERT INTO gofl_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","Hessa gisho, Goday, hinte Xoossay Xoosse gideysa erite. I bana doseysatasinne ba kiita naageysatas mukulu yeletethi gakanaw, ba siiquwa naagiya ammanetiya Xoossi. ");
INSERT INTO gofl_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","Shin I bana ixeyisata seeranawunne dhaysanaw guye geenna. ");
INSERT INTO gofl_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","Hessa gisho, taani hachi new immiya kiita, awaajuwanne higgiya naaga. ");
INSERT INTO gofl_vpl VALUES ("DT7_12","006_7_12","DEU","7","12","12","Ne ha kiita sa7ada mintha naagiko, Goday, ne Xoossay hinte mayzatas caaqidaysada ba siiqo caaquwa new naagana. ");
INSERT INTO gofl_vpl VALUES ("DT7_13","006_7_13","DEU","7","13","13","I nena dosana; nena anjana; ne taybuwa darsana. Qassi I new immanaw ne mayzatas caaqida biittan ne ulo ayfiya, biitta ayfiya; kathaa, woyniya, zaytiya, mehe maratanne dorsa marata darsidi nena anjana. ");
INSERT INTO gofl_vpl VALUES ("DT7_14","006_7_14","DEU","7","14","14","Ne hara asaape aadhada anjetidaysa gidana. Addey woyko macci woyko ne mehey maynnena. ");
INSERT INTO gofl_vpl VALUES ("DT7_15","006_7_15","DEU","7","15","15","Goday harge ubbaafe nena naagana. Neeni Gibxe biittan eriya iita hargiya ne bolla ehenna, shin I nena ixiya ubbaa bolla he hargiya ehana. ");
INSERT INTO gofl_vpl VALUES ("DT7_16","006_7_16","DEU","7","16","16","Goday, ne Xoossay new aathidi immiya asa ubbaa qadhetonna dhaysa. Hessi new xihe gidana gisho, enta xoossata goyinnofa. ");
INSERT INTO gofl_vpl VALUES ("DT7_17","006_7_17","DEU","7","17","17","Neeni, ne wozanan, “Ha kawotethati taape minnoosona; yaatin, ta enta waatada gooddada kessanee?” gaanaw danda7aasa. ");
INSERT INTO gofl_vpl VALUES ("DT7_18","006_7_18","DEU","7","18","18","Shin entaw yayyofa. Goday, ne Xoossay, Gibxe kawa bollanne Gibxe biitta ubbaa bolla oothidaysa akeeka. ");
INSERT INTO gofl_vpl VALUES ("DT7_19","006_7_19","DEU","7","19","19","Goday, ne Xoossay nena Gibxefe kessiya wode oothida gita gadota, malaatata, malaalsiyabata, iya wolqaama kushiyanne iya micetida qesiya ne, ne ayfen be7adasa. Hachi ne yayiya asa ubbaa bolla Goday, ne Xoossay hessada oothana. ");
INSERT INTO gofl_vpl VALUES ("DT7_20","006_7_20","DEU","7","20","20","Qassi neepe baqatidi qosetidaysati dhayana gakanaw Goday, ne Xoossay enta giddon kazhe yeddana. ");
INSERT INTO gofl_vpl VALUES ("DT7_21","006_7_21","DEU","7","21","21","Hessa gisho, ne entaw yayyofa; neera de7iya Goday, ne Xoossay, gitanne yashshiya Xoossi. ");
INSERT INTO gofl_vpl VALUES ("DT7_22","006_7_22","DEU","7","22","22","Goday, ne Xoossay he kawotethata guuthara guuthara gooddidi, ne sinthafe dhaysana. Ne enta ubbaa issi toho dhaysaka; hessa ne oothiko, biittan de7iya do7ati daridi nena waaysana. ");
INSERT INTO gofl_vpl VALUES ("DT7_23","006_7_23","DEU","7","23","23","Shin Goday, ne Xoossay enta ne kushen aathidi immana; enti dhayana gakanaw I enta daganthana. ");
INSERT INTO gofl_vpl VALUES ("DT7_24","006_7_24","DEU","7","24","24","Enta kawota ne kushen aathidi immana. Ne enta suntha salope garsan quchada dhaysana. Oonika neera eqetidi danda7enna; ne enta dhaysana. ");
INSERT INTO gofl_vpl VALUES ("DT7_25","006_7_25","DEU","7","25","25","Kushen oosetida enta eeqa misileta taman xuugga. He misileta bolla de7iya bira woyko worqaa amottofite; nebaa oothada ekofa. Hessi Godaas, ne Xoossaas tuna gidiya gisho, iyape ne ekiko new xihe gidana. ");
INSERT INTO gofl_vpl VALUES ("DT7_26","006_7_26","DEU","7","26","26","Enti banta huuphen baadetidaysata gidiya gisho, ne he tuna eeqata ne soo gelsada, enta mela baadetidaysata gidopa. Enta kumethi ixa; shaateta. ");
INSERT INTO gofl_vpl VALUES ("DT8_1","006_8_1","DEU","8","1","1","Hinte de7on daana mela, hinte tayboy darana melanne Goday kase hinte mayzatas immana gidi caaqida biitta gelidi, hinte laattana mela hachi ta hintena kiittiya kiita ubbaa minthidi naagite. ");
INSERT INTO gofl_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","Goday, ne Xoossay new immida kiita ne naagiyakonne naagonnaako, ne wozanaa qofaa eranaw nena paacanawunne nena aada oothanaw oytamu laythi kumethi nena mela biittan waati kaalethidaako akeeka. ");
INSERT INTO gofl_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","Aadatethi erisanaw nena koshaysis; yaatidi ne woyko ne mayzati eronna Manna nena muzis. Hessa I oothiday asi Godaa doonape keyiya qaala ubbaanape attishin, katha xalaalan de7onnaysa nena tamaarsanaasa. ");
INSERT INTO gofl_vpl VALUES ("DT8_4","006_8_4","DEU","8","4","4","Ha oytamu laythata giddon ne ma7ida ma7oy wuribeenna; ne tohoy kixibeenna. ");
INSERT INTO gofl_vpl VALUES ("DT8_5","006_8_5","DEU","8","5","5","Asi ba na7a seereysada Goday, ne Xoossay nena seeroysa akeeka. ");
INSERT INTO gofl_vpl VALUES ("DT8_6","006_8_6","DEU","8","6","6","Iyaw yayyashenne iya bonchashe Godaa ne Xoossaa kiitaa naaga. ");
INSERT INTO gofl_vpl VALUES ("DT8_7","006_8_7","DEU","8","7","7","Goday ne Xoossay nena zangaarapenne deriyape goggiya shaafatinne pultoti de7iya lo77o biitta gelsanaw ehis. ");
INSERT INTO gofl_vpl VALUES ("DT8_8","006_8_8","DEU","8","8","8","He biittay gisteynne bangi, woyneynne balasey, oromaaney, shamaho zayteynne eessi kumida biitta. ");
INSERT INTO gofl_vpl VALUES ("DT8_9","006_8_9","DEU","8","9","9","He biittay aykoyka paconna hinte kallidi miya biitta. He biittay birati shuchada gela gidida biitta. Zumaape madabe birata bookidi ekiya biitta. ");
INSERT INTO gofl_vpl VALUES ("DT8_10","006_8_10","DEU","8","10","10","Ne mada kallida wode new I immida lo77o biitta gisho, Godaa ne Xoossaa galata. ");
INSERT INTO gofl_vpl VALUES ("DT8_11","006_8_11","DEU","8","11","11","Ta hachi nena kiittiya iya kiita, iya higgiyanne iya awaajuwa naagonna ixada, Godaa ne Xoossaa dogonna mela naageta. ");
INSERT INTO gofl_vpl VALUES ("DT8_12","006_8_12","DEU","8","12","12","Ne mada kalliya wode, lo77o keethi keexada iyan de7iya wode, ");
INSERT INTO gofl_vpl VALUES ("DT8_13","006_8_13","DEU","8","13","13","ne meheynne dorsay dariya wode, new birinne worqi dagaayetiya wode, new de7idabay ubbay dariya wode, ");
INSERT INTO gofl_vpl VALUES ("DT8_14","006_8_14","DEU","8","14","14","he wode, ne wozanay otortonna mela, Gibxe aylletetha keethaafe nena wozida Godaa, ne Xoossaa dogonna mela naageta. ");
INSERT INTO gofl_vpl VALUES ("DT8_15","006_8_15","DEU","8","15","15","I nena iita shooshaynne korney kumida, haathi bayna, gitanne yashshiya mela biittara nena kaalethidaysa dogopa. I new mela biittan zaallafe haathe dhuusis. ");
INSERT INTO gofl_vpl VALUES ("DT8_16","006_8_16","DEU","8","16","16","Ne mayzati eronna mannaa I nena mela biittan muzis. Wursethan new ubbabay injetana mela nena aada oothanawunne paacanaw hessa oothis. ");
INSERT INTO gofl_vpl VALUES ("DT8_17","006_8_17","DEU","8","17","17","Neeni, “Ta wolqaynne ta kushe minotethay ha duretetha taw ehis” goonna mela naageta. ");
INSERT INTO gofl_vpl VALUES ("DT8_18","006_8_18","DEU","8","18","18","Shin ne duretana mela new wolqa immiday Godaa, ne Xoossaa gideysa akeeka. I hessa oothiday, hachi ne be7eysada, ne mayzatara caaqida caaquwa minthanaasa. ");
INSERT INTO gofl_vpl VALUES ("DT8_19","006_8_19","DEU","8","19","19","Shin hinte Godaa hinte Xoossaa aggidi, hara xoossata kaalliko, entaw hokikonne goyinniko, hinte tuma dhayanaysa ta hachi markatayis. ");
INSERT INTO gofl_vpl VALUES ("DT8_20","006_8_20","DEU","8","20","20","Goday, hinte Xoossay hara kawotethata hinte sinthafe dhaysidaysada hinte iyaw kiitetonna ixiko hintenaka dhaysana. ");
INSERT INTO gofl_vpl VALUES ("DT9_1","006_9_1","DEU","9","1","1","Neno, Isra7eele si7a; neepe gitatiyanne wolqaamiya kawotethata, gimbey salo gakida gita katamata laattanaw hachi Yordaanose pinnaasa. ");
INSERT INTO gofl_vpl VALUES ("DT9_2","006_9_2","DEU","9","2","2","He biittan de7iya asay minonne adusse. Neeni, “Oonika entara eqetanaw danda7onna Anaaqe kochata” gishin si7adasa. ");
INSERT INTO gofl_vpl VALUES ("DT9_3","006_9_3","DEU","9","3","3","Shin miya tamada neepe sinthara bey Godaa, ne Xoossaa gideysa hachi era. I enta dhaysananne ne sinthan enta kawushana. Goday new gidaysada ne enta gooddada kessananne ellesada dhaysana. ");
INSERT INTO gofl_vpl VALUES ("DT9_4","006_9_4","DEU","9","4","4","Goday, ne Xoossay enta ne sinthafe gooddidaape guye, ne wozanan, “Taani xillo gidiya gisho, ha biitta ta laattana mela Goday tana ehis” goopa. Goday enta ne sinthafe yedethidi kessiday enti iita gidiya gishosa. ");
INSERT INTO gofl_vpl VALUES ("DT9_5","006_9_5","DEU","9","5","5","Ne enta biitta laattanaw yiday ne xillonne suure gidiya gisho gidenna. Shin Goday, ne Xoossay enta ne sinthafe gooddiday ha kawotethati iita gidiya gishonne beni ne mayzatas Abrahaames, Yisaaqasinne Yayqoobas caaqida caaquwa naaganaassa. ");
INSERT INTO gofl_vpl VALUES ("DT9_6","006_9_6","DEU","9","6","6","Hiza ne hessa akeeka. Goday, ne Xoossay ha lo77o biitta nena laatisey ne xillotethaa gishosa gidenna; neeni wozani muumida asi. ");
INSERT INTO gofl_vpl VALUES ("DT9_7","006_9_7","DEU","9","7","7","Godaa, hinte Xoossaa mela biittan waatidi yiloyidaako dogopite. Hinte Gibxe biittafe keyida gallasape doomidi, hachi ha bessaa gakanaw Godaa bolla makallideta. ");
INSERT INTO gofl_vpl VALUES ("DT9_8","006_9_8","DEU","9","8","8","Koreeba zumaa bolla Goday hintena dhaysanaw dendana gakanaw hinte Godaa yiloyideta. ");
INSERT INTO gofl_vpl VALUES ("DT9_9","006_9_9","DEU","9","9","9","Goday hintera caaqida caaqoy xaafetida loche shuchata ekanaw taani zumaa bolla keyida wode, yan kathi moonnanne haathe uyonna oytamu gallasinne oytamu qamma gam7as. ");
INSERT INTO gofl_vpl VALUES ("DT9_10","006_9_10","DEU","9","10","10","Hessafe guye, Xoossa biradhen xaafetida nam7u loche shuchata Goday taw immis. Hinte zumaa xaphon shiiqida wode tama giddon Goday hintew immida kiitati he loche shucha bolla xaafetidi uttidosona. ");
INSERT INTO gofl_vpl VALUES ("DT9_11","006_9_11","DEU","9","11","11","Oytamu gallasapenne qammafe guye, Goday ba caaqo qaalay xaafetida nam7u loche shuchata taw immis. ");
INSERT INTO gofl_vpl VALUES ("DT9_12","006_9_12","DEU","9","12","12","Hessafe guye, Goday taako, “Ellesada haysafe duge wodha; neeni Gibxefe kessida ne asay tunis; enti ta kiitaa eeson aggidi, kushen oosetida eeqa goyinnanaw simmidosona” yaagis. ");
INSERT INTO gofl_vpl VALUES ("DT9_13","006_9_13","DEU","9","13","13","Qassika Goday taako, “Taani ha asaa be7as; enti tuma wozana muume asi. ");
INSERT INTO gofl_vpl VALUES ("DT9_14","006_9_14","DEU","9","14","14","Hiza ta enta dhaysona melanne enta sunthaa biitta bollafe quchonna mela tana diggofa. Ta nena entafe minonne dariya kawotethi kessana” yaagis. ");
INSERT INTO gofl_vpl VALUES ("DT9_15","006_9_15","DEU","9","15","15","Taani caaqo qaalay xaafetida nam7u loche shuchata ta kushen oykada zumaa bollafe wodhas; he wode tama lacoy zumaa bolla bentees. ");
INSERT INTO gofl_vpl VALUES ("DT9_16","006_9_16","DEU","9","16","16","He wode Godaa, hinte Xoossaa bolla hinte nagara oothidaysa be7as. Hinte mara misilen oosetida worqa eeqa giigisideta. Goday, hintena kiitida ogiyape eeson hara soo simmideta. ");
INSERT INTO gofl_vpl VALUES ("DT9_17","006_9_17","DEU","9","17","17","Taani ta kushen oykida nam7u loche shuchata holada hinte be7ishin menthas. ");
INSERT INTO gofl_vpl VALUES ("DT9_18","006_9_18","DEU","9","18","18","Hessafe guye, Godaa yiloyanaw hinte iya sinthan iita ooso oothidi, nagara oothida gisho, kaseysada oytamu gallasinne oytamu qamma Godaa sinthan gufannada gam7as; he wode ta kathi mabike; haathe uyabike. ");
INSERT INTO gofl_vpl VALUES ("DT9_19","006_9_19","DEU","9","19","19","Goday hinte bolla yilotidi dhaysanaw dendida gisho taani yayyas. Shin Goday zaaridi tana si7is. ");
INSERT INTO gofl_vpl VALUES ("DT9_20","006_9_20","DEU","9","20","20","Qassi Goday yilotidi Aaronaka dhaysanaw koyis; shin taani he wode Aaronas woossas. ");
INSERT INTO gofl_vpl VALUES ("DT9_21","006_9_21","DEU","9","21","21","Taani hinte nagaran kumida he mara misiliya ekada, taman xuuggas. Iya tincheretha gaaccada dhiille kessas; he dhiilliya zumaape goggiya haathara yeddas. ");
INSERT INTO gofl_vpl VALUES ("DT9_22","006_9_22","DEU","9","22","22","Qassi hinte Taaberan, Masahaninne Qibiroot-Hatawan Godaa yiloyideta. ");
INSERT INTO gofl_vpl VALUES ("DT9_23","006_9_23","DEU","9","23","23","Goday hinteko, “Bidi, taani hintew immida biitta laattite” yaagidi, Qaades-Barnefe yeddida wodeka hinte Godaa, hinte Xoossaa kiita ixidi makallideta. Iyaw ammanetibeketa woyko iya qaalas kiitetibeketa. ");
INSERT INTO gofl_vpl VALUES ("DT9_24","006_9_24","DEU","9","24","24","Taani hintena erida wodiyape doomidi, hinte Godaas makallideta. ");
INSERT INTO gofl_vpl VALUES ("DT9_25","006_9_25","DEU","9","25","25","Goday hintena dhaysana gida gisho, taani oytamu gallasinne oytamu qamma Godaa sinthan gufannada gam7as. ");
INSERT INTO gofl_vpl VALUES ("DT9_26","006_9_26","DEU","9","26","26","Taani Godaa Xoossaako haysada yaagada woossas; “Abeeti Ubbaa Haariya Godaw, neeni ne gita wolqan wozidanne ne mino kushen Gibxefe kessida, ne laata gidida ne asaa dhaysofa. ");
INSERT INTO gofl_vpl VALUES ("DT9_27","006_9_27","DEU","9","27","27","Ne aylleta, Abrahaame, Yisaaqanne Yayqooba qopa; enta wozanaa minotethaa, enta iitatethaanne enta nagaraa taybopa. ");
INSERT INTO gofl_vpl VALUES ("DT9_28","006_9_28","DEU","9","28","28","Hessi hanonna attiko, neeni nuna yaape kessida Gibxe asay, ‘Goday entaw immana gida biitta gelsanaw danda7iboona gishonne enta ixida gisho, mela biittan wodhanaw enta kessis’ yaagana. ");
INSERT INTO gofl_vpl VALUES ("DT9_29","006_9_29","DEU","9","29","29","Gidoshin, ha asay neeni ne gita wolqaaninne ne micetida qesen Gibxefe kessida ne laata gidida ne asaa” yaagas. ");
INSERT INTO gofl_vpl VALUES ("DT10_1","006_10_1","DEU","10","1","1","He wode Goday taako, “Koyroysa mela nam7u loche shuchata giigisada taako zumaa bolla keya. Qassi iya wothanaw mithafe taabote ootha. ");
INSERT INTO gofl_vpl VALUES ("DT10_2","006_10_2","DEU","10","2","2","Taani kase ne menthida shuchata bolla de7iya qaalata ha shuchata bolla xaafana; ne enta taabotiya giddon wotha” yaagis. ");
INSERT INTO gofl_vpl VALUES ("DT10_3","006_10_3","DEU","10","3","3","Taani soqala mithafe taabote oothas. Kaseysa mela nam7u loche shuchata giigisas; he shuchata ta kushen oykada zumaa bolla keyas. ");
INSERT INTO gofl_vpl VALUES ("DT10_4","006_10_4","DEU","10","4","4","Hinte zumaa xaphon shiiqida gallas, tama giddofe Goday hintew odida qaalata, hessika Tammu Kiitata, kase xaafidaysata he shuchata bolla Goday xaafidi enta taw immis. ");
INSERT INTO gofl_vpl VALUES ("DT10_5","006_10_5","DEU","10","5","5","Hessafe guye, taani zumaa bollafe wodhada, Goday tana kiittidaysada, he shuchata ta oothida Taabotiya giddon wothas; ha77ika enti yan de7oosona. ");
INSERT INTO gofl_vpl VALUES ("DT10_6","006_10_6","DEU","10","6","6","Isra7eele asay Ba7aarota Benyaqanape dendidi, Musera bidosona. Aaroni yan hayqidi moogetis; iya na7ay Alaazari iya laattidi, iya bessan kahine halaqa gidis. ");
INSERT INTO gofl_vpl VALUES ("DT10_7","006_10_7","DEU","10","7","7","Enti yaape Gudgoda geetetiya bessa bidosona; yaape qassi goggiya haathati de7iya Yoxibaata geetetiya bessa bidosona. ");
INSERT INTO gofl_vpl VALUES ("DT10_8","006_10_8","DEU","10","8","8","He wode Godaa caaqo Taabotiya tookana mela, Godaa sinthan eqidi iya haggaazana melanne hachi gakanaw enti ootheysa mela Godaa sunthan anjana mela Leewe kochaa Goday baw dummayis. ");
INSERT INTO gofl_vpl VALUES ("DT10_9","006_10_9","DEU","10","9","9","Hessa gisho, Leewe kochaas enta ishata giddon gishoy woyko laati baawa; Goday, hinte Xoossay entaw gidaysada enta laatay Godaa. ");
INSERT INTO gofl_vpl VALUES ("DT10_10","006_10_10","DEU","10","10","10","Taani kaseysada oytamu gallasinne oytamu qamma zumaa bolla gam7as. Goday zaaridi ta woosa si7idi hintena dhaysanaw koybeenna. ");
INSERT INTO gofl_vpl VALUES ("DT10_11","006_10_11","DEU","10","11","11","Goday taako, “Taani enta aawatas immana gada caaqida biitta enti gelana melanne laattana mela ha asaa kaaletha” yaagis. ");
INSERT INTO gofl_vpl VALUES ("DT10_12","006_10_12","DEU","10","12","12","Neno, Isra7eele, Goday neepe koyey haysa; Godaa, ne Xoossaa yayya; iya ogiya ubban ba; iya dosa; ne kumetha wozanapenne ne kumetha shempuwafe Godaa ne Xoossaas ootha. ");
INSERT INTO gofl_vpl VALUES ("DT10_13","006_10_13","DEU","10","13","13","New injetana mela taani hachi new immiya Godaa kiitatanne awaajota naaga. ");
INSERT INTO gofl_vpl VALUES ("DT10_14","006_10_14","DEU","10","14","14","Saloynne salope bollara de7iya saloti, qassi sa7inne sa7an de7iya ubbay Godaa, ne Xoossaaba gideysi tuma. ");
INSERT INTO gofl_vpl VALUES ("DT10_15","006_10_15","DEU","10","15","15","Gidoshin, Goday hinte mayzatan ufaytidi, enta siiqis; hachi hinte be7eysada entafe guyen enta sheeshi gidida hintena kawotethata ubbaafe aathidi dooris. ");
INSERT INTO gofl_vpl VALUES ("DT10_16","006_10_16","DEU","10","16","16","Hessa gisho, hinte wozanaa qaxarite; hizape hinte wozanaa minthofite. ");
INSERT INTO gofl_vpl VALUES ("DT10_17","006_10_17","DEU","10","17","17","Goday, hinte Xoossay xoossata Xoossinne godata Godaa. I gita Xoossi; I wolqaamanne yashshiya Xoossi. I som7o be7idi pirdenna; wodhaafe ekenna. ");
INSERT INTO gofl_vpl VALUES ("DT10_18","006_10_18","DEU","10","18","18","I yi7otasinne am7etas suure pirdees; betanchuwa siiqidi, iyaw kathinne ma7o immees. ");
INSERT INTO gofl_vpl VALUES ("DT10_19","006_10_19","DEU","10","19","19","Hinteka betanchota siiqite; hinte hinte huuphen bete asi gididi Gibxen de7ideta. ");
INSERT INTO gofl_vpl VALUES ("DT10_20","006_10_20","DEU","10","20","20","Godaa, ne Xoossaa yayya; iyaw ootha; iyara oyketa; iya sunthan caaqa. ");
INSERT INTO gofl_vpl VALUES ("DT10_21","006_10_21","DEU","10","21","21","Neeni ne ayfen be7ida gitanne yashshiya malaalsiyabata new oothiday, I ne galataa; ne Xoossaa. ");
INSERT INTO gofl_vpl VALUES ("DT10_22","006_10_22","DEU","10","22","22","Gibxe biitta wodhida hinte mayzati kumethi laapun tamma; ha77i Goday, hinte Xoossay hintena salo xoolintotada darsis. ");
INSERT INTO gofl_vpl VALUES ("DT11_1","006_11_1","DEU","11","1","1","Hiza Godaa, ne Xoossaa dosa; iya awaajuwa, wogaa, iya higgiyanne iya kiita ubba wode naaga. ");
INSERT INTO gofl_vpl VALUES ("DT11_2","006_11_2","DEU","11","2","2","Hinte nayti be7onnabaanne eronnabaa gidikoka, hinte hachi Godaa seera, iya gitatetha, iya wolqaama kushiyanne micetida qesiya be7idaysa akeekite. ");
INSERT INTO gofl_vpl VALUES ("DT11_3","006_11_3","DEU","11","3","3","Hinte I oothida malaatatanne Gibxe kawa bollanne iya biitta ubbaa bolla oothida malaalsiyabata be7ideta. ");
INSERT INTO gofl_vpl VALUES ("DT11_4","006_11_4","DEU","11","4","4","Enti hintena kaallidi gooddida wode, Goday Gibxe biitta olanchota, enta paratanne para gaareta Zo7o Abban mitisidi, hachi gakanaw enta kumethi dhaysidaysa be7ideta. ");
INSERT INTO gofl_vpl VALUES ("DT11_5","006_11_5","DEU","11","5","5","Hinte ha bessaa gakanaw mela biittan Goday hintew oothidaba hinte ereeta. ");
INSERT INTO gofl_vpl VALUES ("DT11_6","006_11_6","DEU","11","6","6","Robeela kochaafe Eli7aaba nayta gidida Daatane bollanne Abeero bolla Goday oothidaysa akeekite. Isra7eele asa ubbay be7ishin, biittay dooyetidi, enta, enta soo asaa, enta dunkaaniyanne shempora de7iya entaba ubbaa mittis. ");
INSERT INTO gofl_vpl VALUES ("DT11_7","006_11_7","DEU","11","7","7","Goday oothida ha gita oosota ubbaa hinte, hinte ayfen be7ideta. ");
INSERT INTO gofl_vpl VALUES ("DT11_8","006_11_8","DEU","11","8","8","Hiza hinte mino gidana melanne Yordaanose pinnidi hinte ekanaw biya biitta laattana mela taani hachi hintena kiittiya kiita ubbaa naagite. ");
INSERT INTO gofl_vpl VALUES ("DT11_9","006_11_9","DEU","11","9","9","Hinte kiitetiko, Goday hinte mayzatasinne enta kochaas immana gidi caaqida, maathinne eessi goggiya biittan hinte adussa laythi daana. ");
INSERT INTO gofl_vpl VALUES ("DT11_10","006_11_10","DEU","11","10","10","Ne laattanaw biya biittay, ne keyada yida Gibxe biitta mela gidenna. Gibxen ne kathi zerada, goshsha biitta ubbaa atakilte bessada haathe ushshaasa. ");
INSERT INTO gofl_vpl VALUES ("DT11_11","006_11_11","DEU","11","11","11","Shin Yordaanose pinnidi hinte laattanaw biya biittay, dereynne zangaaray de7iya, salo iran aliya biitta. ");
INSERT INTO gofl_vpl VALUES ("DT11_12","006_11_12","DEU","11","12","12","He biittay, Goday ne Xoossay naagiya biitta; laytha doomethaafe bidi laytha wursethaa gakanaw Godaa, ne Xoossaa ayfey iya bolla de7iya biitta. ");
INSERT INTO gofl_vpl VALUES ("DT11_13","006_11_13","DEU","11","13","13","Hessa gisho, Godaa, hinte Xoossaa siiqiko, hinte kumetha wozanapenne hinte kumetha shempuwafe iya goyinniko, taani hachi hintew immiya kiita hinte naagiko, ");
INSERT INTO gofl_vpl VALUES ("DT11_14","006_11_14","DEU","11","14","14","ne kathi, woyney zaytey paconna shiishana mela torchenne sila ira woden woden bukisana. ");
INSERT INTO gofl_vpl VALUES ("DT11_15","006_11_15","DEU","11","15","15","Goday ne mehiyas maata darsana; ne maana; kallana. ");
INSERT INTO gofl_vpl VALUES ("DT11_16","006_11_16","DEU","11","16","16","Hinte wozanaa hara soo zaaridi, hara xoossata goyinnona melanne hokonna mela naagetite. ");
INSERT INTO gofl_vpl VALUES ("DT11_17","006_11_17","DEU","11","17","17","Hessa hinte oothiko, Godaa hanqoy hinte bolla eexana; iray bukonna melanne kathi dolonna mela I saluwa gordana. Hinte Goday hintew immiya lo77o biittafe eeson dhayana. ");
INSERT INTO gofl_vpl VALUES ("DT11_18","006_11_18","DEU","11","18","18","Hiza, ha kiitata hinte wozanaaninne hinte qofan wothite. Mallada enta hinte kushen qachite; qassi hinte som7on qachite. ");
INSERT INTO gofl_vpl VALUES ("DT11_19","006_11_19","DEU","11","19","19","Hinte nayta tamaarsite. Hinte son de7iya wode, ogen hemetiya wode, zin7iya wodenne dendiya wode entaw odite. ");
INSERT INTO gofl_vpl VALUES ("DT11_20","006_11_20","DEU","11","20","20","Hinte penge zizgiya bollanne hinte dirsa pengiya bolla xaafite. ");
INSERT INTO gofl_vpl VALUES ("DT11_21","006_11_21","DEU","11","21","21","Hessa hinte oothiko, Goday hinte mayzatas immana gidi caaqida biittan, hinte laythaynne hinte nayta laythay sa7ape bollara de7iya salo mela gidana. ");
INSERT INTO gofl_vpl VALUES ("DT11_22","006_11_22","DEU","11","22","22","Hinte Godaa, hinte Xoossaa dosiko, iya oge ubban hinte biiko, iyaw ammanetiko, ta hachi hintew immiya kiita hinte minthidi naagiko, ");
INSERT INTO gofl_vpl VALUES ("DT11_23","006_11_23","DEU","11","23","23","Goday ha kawotethata ubbaa hinte sinthafe gooddidi kessana. Hintefe dariyanne wolqaamiya kawotethata biitta yegisidi ekana. ");
INSERT INTO gofl_vpl VALUES ("DT11_24","006_11_24","DEU","11","24","24","Tohon hinte yedhida biitta ubbay hintebaa gidana. Hinte zaway dugeha mela biittafe bidi Libaanose gakanawunne Efraxiisa shaafape bidi Gita Abbaa gakanaw gidana. ");
INSERT INTO gofl_vpl VALUES ("DT11_25","006_11_25","DEU","11","25","25","Hintera ay asika eqetanaw danda7enna; Goday, hinte Xoossay hintew gidaysada hinte biya soo ubban asay hintena be7idi dagammana melanne hintew yayyana mela oothana. ");
INSERT INTO gofl_vpl VALUES ("DT11_26","006_11_26","DEU","11","26","26","Heko, ta hachi hinte sinthan anjonne baadethi wothayis. ");
INSERT INTO gofl_vpl VALUES ("DT11_27","006_11_27","DEU","11","27","27","Ta hachi hintena kiittiya Godaa, hinte Xoossaa kiita naagiko, hinte anjetana. ");
INSERT INTO gofl_vpl VALUES ("DT11_28","006_11_28","DEU","11","28","28","Shin taani hintena hachi kiittiya Godaa, hinte Xoossaa kiita naagonna ixidi, hara xoossata goyinnanaw iya ogiyape deshiko, hinte baadetana. ");
INSERT INTO gofl_vpl VALUES ("DT11_29","006_11_29","DEU","11","29","29","Goday, hinte Xoossay hinte laattanaw biya biitta hintena gelsiya wode, baadetha Garzaana zuma bolla, anjuwa Ebaala zuma bolla awaajite. ");
INSERT INTO gofl_vpl VALUES ("DT11_30","006_11_30","DEU","11","30","30","Ha zumate Yordaanose shaafape hefinthan ogiyape wuloha baggan, Araban de7iya Kanaaneta biittan, Galgala sinthan de7iya Moore mitha matan de7oosona. ");
INSERT INTO gofl_vpl VALUES ("DT11_31","006_11_31","DEU","11","31","31","Hinte ha77i Goday, hinte Xoossay hintew immiya biitta laattanaw Yordaanose shaafa pinnana haneeta. Hinte he biitta ekidi yan de7iya wode, ");
INSERT INTO gofl_vpl VALUES ("DT11_32","006_11_32","DEU","11","32","32","ta hachi hintew immiya awaajotanne higgiya ubbaa minthidi naagite. ");
INSERT INTO gofl_vpl VALUES ("DT12_1","006_12_1","DEU","12","1","1","Hinte laattana mela Goday, hinte aawata Xoossay hintew immida biittan hinte de7ida wode ubban hinte oothanaw bessiya awaajotinne higgeti haysata. ");
INSERT INTO gofl_vpl VALUES ("DT12_2","006_12_2","DEU","12","2","2","Hinte laattiya biittan de7iya kawotethatis deriya bolla, zumaa bollanne issi issi mitha garsan de7iya goyinno bessata dhaysite. ");
INSERT INTO gofl_vpl VALUES ("DT12_3","006_12_3","DEU","12","3","3","Enta yarsho bessata laallite; enta goyinno shucha tuussata mentherethite. Asheera geetetiya enta eeqa misiliya taman xuuggite; kushen oosetida enta xoossata misileta dhaysite; enta sunthata he bessaafe quchite. ");
INSERT INTO gofl_vpl VALUES ("DT12_4","006_12_4","DEU","12","4","4","Godaa, hinte Xoossaa enti banta xoossaa goyinniya ogen goyinnofite. ");
INSERT INTO gofl_vpl VALUES ("DT12_5","006_12_5","DEU","12","5","5","Goday, hinte Xoossay hinte koche ubbaa giddofe ba sunthay yan xeegetana mela doorida bessaa koyte. He bessaa hinte baanaw koshshees. ");
INSERT INTO gofl_vpl VALUES ("DT12_6","006_12_6","DEU","12","6","6","Hinte xuussa yarshuwa, hara yarshuwa, hinte asraata, hinte imuwa, hinte qangetha, hinte dosidi immiya imuwa, hinte mehiyapenne dorsaafe bayraa he bessaa ehite. ");
INSERT INTO gofl_vpl VALUES ("DT12_7","006_12_7","DEU","12","7","7","Goday, hinte Xoossay hintena anjida gisho, hessan, Goday, hinte Xoossay de7iya bessan, hintenne hinte soo asay maana; hinte kushey oothidaba ubban hinte ufaytana. ");
INSERT INTO gofl_vpl VALUES ("DT12_8","006_12_8","DEU","12","8","8","Hachi haysan hinte issoy issoy, dosidaba ootheysada he wode ootheketa. ");
INSERT INTO gofl_vpl VALUES ("DT12_9","006_12_9","DEU","12","9","9","Goday, hinte Xoossay hintew immiya shempo biitta buroo gakibeketa. ");
INSERT INTO gofl_vpl VALUES ("DT12_10","006_12_10","DEU","12","10","10","Shin hinte Yordaanose pinnidi, Goday hinte Xoossay immiya he biitta laattidi yan uttana. Hintena teqida morketape I hintena shempisiya gisho yan wopu gidi hinte daana. ");
INSERT INTO gofl_vpl VALUES ("DT12_11","006_12_11","DEU","12","11","11","He wode Goday, hinte Xoossay ba sunthay hessan xeegetanaw doorida he bessan, ta hintena kiittiyaba ubbaa, xuussa yarshuwa, hara yarshuwa, hinte asraata, hinte imuwanne hinte qangetha ubbaa yaa eheeta. ");
INSERT INTO gofl_vpl VALUES ("DT12_12","006_12_12","DEU","12","12","12","Hinte, hinte adde naytinne hinte macca nayti, hinte adde aylletinne macca aylleti hintera laata ekiboonna hinte kataman de7iya Leewetara issife yan Godaa, hinte Xoossaa sinthan ufaytana. ");
INSERT INTO gofl_vpl VALUES ("DT12_13","006_12_13","DEU","12","13","13","Neeni xuussa yarshuwa ne koyida bessan coo yarshonna mela naageta. ");
INSERT INTO gofl_vpl VALUES ("DT12_14","006_12_14","DEU","12","14","14","Neeni, ne kochaafe issuwan, Goday doorida bessan, ne xuussa yarshuwa yarsha; ta nena kiitida ubbaa yan ootha. ");
INSERT INTO gofl_vpl VALUES ("DT12_15","006_12_15","DEU","12","15","15","Gidoshin ne de7iya bessan awunka ne mehiyape Goday nena anjidaysada shukada ma. Wogaada tuna gidin woyko tuna gidonna asi oonika gaaranne gen7e meysada ne mehiyape shukada ma. ");
INSERT INTO gofl_vpl VALUES ("DT12_16","006_12_16","DEU","12","16","16","Shin suuthi haathada sa7an gussafe attishin, moopa. ");
INSERT INTO gofl_vpl VALUES ("DT12_17","006_12_17","DEU","12","17","17","Ne kathaafe, woyniyapenne zaytiyape immiya asraata, ne mehiyapenne dorsa wudiyape immiya bayraa, Godaas qangidaba ubbaanne ne dosan immiya imuwa ubbaa ne de7iya heeran moopa. ");
INSERT INTO gofl_vpl VALUES ("DT12_18","006_12_18","DEU","12","18","18","Shin neeni, ne adde naytinne ne macca nayti, ne adde aylletinne macca aylleti neera laata ekiboonna ne kataman de7iya Leewetara issife Goday, ne Xoossay doorida bessan, Godaa, ne Xoossaa sinthan, ha yarsho ubbaa ma. Ne daaburada shiishidaban Godaa, ne Xoossaa sinthan ufayta. ");
INSERT INTO gofl_vpl VALUES ("DT12_19","006_12_19","DEU","12","19","19","Ne de7o laytha ubban Leeweta qelli goonna mela naageta. ");
INSERT INTO gofl_vpl VALUES ("DT12_20","006_12_20","DEU","12","20","20","I new gelida qaalada Goday ne Xoossay ne zawa daligisiya wode nena asho maanaw koshshiya wode ne koyida mela ma. ");
INSERT INTO gofl_vpl VALUES ("DT12_21","006_12_21","DEU","12","21","21","Shin Goday, ne Xoossay ba sunthay yan xeegetana mela doorida bessay new haakiko, Goday new immida ne mehe woyko dorsaa wudiyape ta nena kiittidaysada, ne koyida mela ne kataman shukada ma. ");
INSERT INTO gofl_vpl VALUES ("DT12_22","006_12_22","DEU","12","22","22","Wogaada tuna gidin woyko tuna gidonna asi oonika gaara woyko gen7e meysada mo. ");
INSERT INTO gofl_vpl VALUES ("DT12_23","006_12_23","DEU","12","23","23","De7oy suuthan de7iya gisho, suuthi de7iya asho moonna mela naageta; hessa gisho, de7o ashora gathada moopa. ");
INSERT INTO gofl_vpl VALUES ("DT12_24","006_12_24","DEU","12","24","24","Suuthi haathada biittan gussafe attishin, moopa. ");
INSERT INTO gofl_vpl VALUES ("DT12_25","006_12_25","DEU","12","25","25","Newunne neepe guyera yaana ne naytas injetana mela suuthi moopa. Hessa ne oothiko Godaa ufaysaasa. ");
INSERT INTO gofl_vpl VALUES ("DT12_26","006_12_26","DEU","12","26","26","Shin ne Godaas dummayidabaanne iyaw qangidaba ekada, Goday doorida bessaa ba. ");
INSERT INTO gofl_vpl VALUES ("DT12_27","006_12_27","DEU","12","27","27","Xuussa yarsho ashuwanne suuthaa Godaa, ne Xoossaa yarsho bessan yarsha. Hara yarsho suuthaa Godaa, ne Xoossaa yarsho bessa matan gussada ashuwa ma. ");
INSERT INTO gofl_vpl VALUES ("DT12_28","006_12_28","DEU","12","28","28","Newunne ne naytas injetana mela ta nena kiittiya kiitaa minthada naaga. Hessa ne oothiko, Godaa ne Xoossaa ufaysiyabaanne suureba oothaasa. ");
INSERT INTO gofl_vpl VALUES ("DT12_29","006_12_29","DEU","12","29","29","Ne laattanaw biya kawotethaa, Goday ne Xoossay ne sinthafe dhaysiya wodenne ne enta biitta laattiya wode, ");
INSERT INTO gofl_vpl VALUES ("DT12_30","006_12_30","DEU","12","30","30","enti ne sinthafe dhaydaape guye, ne enta xoossata goyinnada, xihen oyketonna mela naageta. Neeni, “Ha kawotethati banta xoossata waatidi goyinnona?” yaagada kaallada oychonna mela naageta. ");
INSERT INTO gofl_vpl VALUES ("DT12_31","006_12_31","DEU","12","31","31","Enti banta xoossata goyinniya wode Goday ixiya ubbaa oothiya gisho, Godaa ne Xoossaa ne hessada goyinnanaw bessenna. Enti hari attoshin, banta adde naytanne macca nayta banta xoossatas yarsho oothidi taman xuuggoosona. ");
INSERT INTO gofl_vpl VALUES ("DT12_32","006_12_32","DEU","12","32","32","Hiza ta nena kiittidaba ubbaa ootha; iya bolla gujofa; iyape pacisopa. ");
INSERT INTO gofl_vpl VALUES ("DT13_1","006_13_1","DEU","13","1","1","Ne giddon tinbite odiya woyko amuho birshiya asi dendidi, malaatanne malaalsiyabata oothiko, ");
INSERT INTO gofl_vpl VALUES ("DT13_2","006_13_2","DEU","13","2","2","I odida malaatay woyko malaalsiyabay tuma gididi poletin, I neeko, “Ane kase ne eronna hara xoossata goyinnoos” yaagiko, ");
INSERT INTO gofl_vpl VALUES ("DT13_3","006_13_3","DEU","13","3","3","ne iya ubbaraka si7opa. Hinte kumetha wozanapenne kumetha shempuwafe Godaa hinte Xoossaa dosiyakonne dosonaako paacanaw hessa oothees. ");
INSERT INTO gofl_vpl VALUES ("DT13_4","006_13_4","DEU","13","4","4","Godaa hinte Xoossaa kaallite; iyaw yayyite; iya kiita naagite; iya qaala si7ite; iyaw goyinnite; iyape duuxofite. ");
INSERT INTO gofl_vpl VALUES ("DT13_5","006_13_5","DEU","13","5","5","Hintena Gibxe aylletethaafe wozida Godaa, hinte Xoossaa bolla hinte makallana mela tamaarsiya nabe woyko amuho birshiya uraa wodhite. Hessa mela asi hinte Godaa, hinte Xoossa kiitaape kare keyana mela oothiya gisho, iya wodhite; iitaa hinte giddofe diggite. ");
INSERT INTO gofl_vpl VALUES ("DT13_6","006_13_6","DEU","13","6","6","Hari attoshin, ne ishay woyko ne adde na7ay woyko ne macca na7iya woyko ne dosiya machiya woyko ne mata laggey, “Kase nenne ne mayzati goyinni eronna xoossata goyinnanaw yedha. ");
INSERT INTO gofl_vpl VALUES ("DT13_7","006_13_7","DEU","13","7","7","Biittaa ha gaxape ya gaxaa gakanaw de7iya, ne yuusho ubban mataninne haahon de7iya asa ubbay goyinniya xoossata goyinnanaw yedha” yaagidi balethiko, ");
INSERT INTO gofl_vpl VALUES ("DT13_8","006_13_8","DEU","13","8","8","iyaw ero goopa; I geysa si7opa. Iyaw qadhetada iya shempuwa ashshofa; ");
INSERT INTO gofl_vpl VALUES ("DT13_9","006_13_9","DEU","13","9","9","iya wodhanaw bessees. Iya wodhanaw koyro ne dooma; hessafe guye, asa ubbay kaallidi wodho. ");
INSERT INTO gofl_vpl VALUES ("DT13_10","006_13_10","DEU","13","10","10","I hayqana gakanaw shuchan cadda; I nena Gibxe biittafe, aylletetha keethaafe kessida Godaa, ne Xoossaafe nena shaakanaw koyees. ");
INSERT INTO gofl_vpl VALUES ("DT13_11","006_13_11","DEU","13","11","11","Isra7eele asay hessa si7idi yayyana; qassi hessa mela iitabaa zaaridi hinte giddon oonika oothenna. ");
INSERT INTO gofl_vpl VALUES ("DT13_12","006_13_12","DEU","13","12","12","Goday, ne Xoossay ne daana mela immida katamaape issuwan ne de7iya wode, ");
INSERT INTO gofl_vpl VALUES ("DT13_13","006_13_13","DEU","13","13","13","ne asaa giddon iitati dendidi, asaako, “Nuuni eronna xoossata goyinnanaw dendite” yaagidi balethishin ne si7iko, ");
INSERT INTO gofl_vpl VALUES ("DT13_14","006_13_14","DEU","13","14","14","he hanota oycha; minthada pilga. He ne giddon oosetida tunabay tuma gideysa shaakada eriko, ");
INSERT INTO gofl_vpl VALUES ("DT13_15","006_13_15","DEU","13","15","15","he kataman de7iya asa ubbaa mashshan wursa; he katamaanne iyan de7iya mehiya ashshona dhaysa. ");
INSERT INTO gofl_vpl VALUES ("DT13_16","006_13_16","DEU","13","16","16","He katamaape ne ekida di7o ubbaa katamaa dabaaba shiishada, he katamaanne iya di7uwa ubbaa Godaas, ne Xoossaas, xuussa yarsho oothada wursada xuugga. I merinaw zaaridi keexetonna laaletha doore gididi attana. ");
INSERT INTO gofl_vpl VALUES ("DT13_17","006_13_17","DEU","13","17","17","Ha digetida miishetape aybika ne kushen bentofo. Goday ba wolqaama hanquwafe simmidi, nena maarana; I new qadhetana. Kase ne mayzatas caaqida caaquwada ne taybuwa darsana. ");
INSERT INTO gofl_vpl VALUES ("DT13_18","006_13_18","DEU","13","18","18","Taani hachi nena kiittiya kiita ubbaa ne naagada, Godaa, ne Xoossaas kiitetiko, Godaa ne Xoossaa ufaysiyabaa oothiko, ha gidabay new poletana. ");
INSERT INTO gofl_vpl VALUES ("DT14_1","006_14_1","DEU","14","1","1","Hinte, Godaa hinte Xoossaa nayta; hayqida asaas hinte asatethaa gaaropite; hinte huuphiya buluusopite. ");
INSERT INTO gofl_vpl VALUES ("DT14_2","006_14_2","DEU","14","2","2","Hinte, Godaa hinte Xoossaas geeshsha dere; Goday hintena ba ase gidana mela biittan de7iya asa ubbaafe baw dooris. ");
INSERT INTO gofl_vpl VALUES ("DT14_3","006_14_3","DEU","14","3","3","Neeni tunaba aybaka moopa. ");
INSERT INTO gofl_vpl VALUES ("DT14_4","006_14_4","DEU","14","4","4","Ne maana mehetinne do7ati haysata; boori, dorse, deeshe, ");
INSERT INTO gofl_vpl VALUES ("DT14_5","006_14_5","DEU","14","5","5","doge, baacho, woshi7e, wora deeshi, waaliya, gaaranne zuma dorse. ");
INSERT INTO gofl_vpl VALUES ("DT14_6","006_14_6","DEU","14","6","6","Shuquley phalqetidaysanne waammotiya mehetanne do7ata ubbaa miite. ");
INSERT INTO gofl_vpl VALUES ("DT14_7","006_14_7","DEU","14","7","7","Shin shuquley phalqetonaysatanne waammotonnayisata moopa; hessika gimale, eshenne gupalle. Haysati waammotoosona, shin enta shuquley phalqetiboona gisho, enti hintew tuna. ");
INSERT INTO gofl_vpl VALUES ("DT14_8","006_14_8","DEU","14","8","8","Gudunthos shuquley phalqethi, shin waammotonna gisho I hintew tuna. Iya ashuwa moopa; iya bawuta bochofite. ");
INSERT INTO gofl_vpl VALUES ("DT14_9","006_14_9","DEU","14","9","9","Haatha giddon de7iya medhetethata giddofe hinte maanaysati haysata; molo mela qefeynne poqoy de7iya ubbaa miite. ");
INSERT INTO gofl_vpl VALUES ("DT14_10","006_14_10","DEU","14","10","10","Shin molo mela qefeynne poqoy baynayisata moopite hessi hintew tuna. ");
INSERT INTO gofl_vpl VALUES ("DT14_11","006_14_11","DEU","14","11","11","Tuna gidonna kafo ubbaa miite. ");
INSERT INTO gofl_vpl VALUES ("DT14_12","006_14_12","DEU","14","12","12","Shin kafotape hinte moonna aggana kafoti haysata; arganthi, bazzo anko, kareetha anko, ");
INSERT INTO gofl_vpl VALUES ("DT14_13","006_14_13","DEU","14","13","13","phirco, xilo koche ubbaa, ");
INSERT INTO gofl_vpl VALUES ("DT14_14","006_14_14","DEU","14","14","14","qoorase koche ubbaa, ");
INSERT INTO gofl_vpl VALUES ("DT14_15","006_14_15","DEU","14","15","15","yancho, haatha kafo, qamma kafo koche ubbaa, ");
INSERT INTO gofl_vpl VALUES ("DT14_16","006_14_16","DEU","14","16","16","laafa gutto, diidinthe, haatha kutto, ");
INSERT INTO gofl_vpl VALUES ("DT14_17","006_14_17","DEU","14","17","17","bazzo gutto, molo kafo, solee, hazazo, ");
INSERT INTO gofl_vpl VALUES ("DT14_18","006_14_18","DEU","14","18","18","saabisa geetetiya kafo koche ubbaa, ayyaana kafonne shirshiqo. ");
INSERT INTO gofl_vpl VALUES ("DT14_19","006_14_19","DEU","14","19","19","Qefera de7iya laafa medhetethati ubbay hintew tuna; enta moopite. ");
INSERT INTO gofl_vpl VALUES ("DT14_20","006_14_20","DEU","14","20","20","Shin qefera de7iyabatape tuna gidonayisata miite. ");
INSERT INTO gofl_vpl VALUES ("DT14_21","006_14_21","DEU","14","21","21","Neeni, Godaa ne Xoossaas geeshsha asi gidiya gisho, bawuta ubbaa moopa. Hessa hinte kataman de7iya bete asay maana mela entaw immanaw danda7eeta; woyko hara biitta asas bayzanaw danda7eeta. Deesha na7a iya aaye maathara kathofa. ");
INSERT INTO gofl_vpl VALUES ("DT14_22","006_14_22","DEU","14","22","22","Ne gaden laythan laythan kaxiya katha ayfe ubbaafe asraata kessa. ");
INSERT INTO gofl_vpl VALUES ("DT14_23","006_14_23","DEU","14","23","23","Ne ubba wode Godaas ne Xoossaas, yashshi tamaarana mela ba sunthay xeegetana mela I doorida bessan, ne kathaa, woyne ushshaanne zaytiya asraata, ne dorsafenne mehiyape bayra yeletidaysa yan, Godaa, ne Xoossaa sinthan ma. ");
INSERT INTO gofl_vpl VALUES ("DT14_24","006_14_24","DEU","14","24","24","Goday ne Xoossay ba sunthay xeegetana mela doorida bessay, ne de7iya bessaafe daro haaho gidiko, Goday nena anjana mela ne asraata yaa efanaw danda7onnaba gidiko, ");
INSERT INTO gofl_vpl VALUES ("DT14_25","006_14_25","DEU","14","25","25","he asraata bayzada miishiya Goday, ne Xoossay doorida bessaa efa. ");
INSERT INTO gofl_vpl VALUES ("DT14_26","006_14_26","DEU","14","26","26","He miishiyan ne koyida miizi woyko dorse woyko woyne ushshi woyko hara mino ushshi woyko hara ne koyiyaba shammada, nenne ne soo asay Godaa, ne Xoossaa sinthan hessa mada ufayta. ");
INSERT INTO gofl_vpl VALUES ("DT14_27","006_14_27","DEU","14","27","27","Enti neera shaaketidi ekida hara laati entaw bayna gisho, hessa ne oothiya wode ne kataman de7iya Leeweta dogopa. ");
INSERT INTO gofl_vpl VALUES ("DT14_28","006_14_28","DEU","14","28","28","Heedzantho laythan laythan ne katha asraata ehada ne kataman shiisha. ");
INSERT INTO gofl_vpl VALUES ("DT14_29","006_14_29","DEU","14","29","29","Hessa ne kataman de7iya, neera shaakitidi ekida hara laati bayna Leeweti, bete asay, yi7o naytinne am7eti yidi mo. Yaatiko, ne oothiya ooso ubban Goday, ne Xoossay nena anjana. ");
INSERT INTO gofl_vpl VALUES ("DT15_1","006_15_1","DEU","15","1","1","“Laapuntha laytha wursethan tal7e aco ubbaa maara. ");
INSERT INTO gofl_vpl VALUES ("DT15_2","006_15_2","DEU","15","2","2","Ne aco maarana wogay haysa; Isra7eele gidida ba ishaas tal7ida oonika he acuwa maaro. Godaa maarotethay awaajetida gisho, Isra7eele gidida ba ishaas tal7ida ba tal7iya oychofo. ");
INSERT INTO gofl_vpl VALUES ("DT15_3","006_15_3","DEU","15","3","3","Hara biitta asas ne tal7ida acuwa ekanaw danda7aasa, shin ne kochaas tal7idaba ubbaa maara. ");
INSERT INTO gofl_vpl VALUES ("DT15_4","006_15_4","DEU","15","4","4","“Ne laattana mela Goday, ne Xoossay new aqo oothidi immiya biittan, Goday nena anjana gisho ne giddon manqoy deenna. ");
INSERT INTO gofl_vpl VALUES ("DT15_5","006_15_5","DEU","15","5","5","Ne Godaas ne Xoossaas kiitetiko, ta hachi nena kiittiya kiita ubbaa naagiko, ne polo anjetana. ");
INSERT INTO gofl_vpl VALUES ("DT15_6","006_15_6","DEU","15","6","6","Goday, ne Xoossay new odidaysada nena anjana; daro kawotethati hintefe tal7ana, shin hinte issuwafeka tal7eketa. Qassi ne kawotethata haarana, shin issoyka nena haarenna. ");
INSERT INTO gofl_vpl VALUES ("DT15_7","006_15_7","DEU","15","7","7","“Goday, ne Xoossay new immiya biittan de7iya katamatape issuwan de7iya Isra7eele asi manqidi bentiko, iyaw ulo minnofa; ne kushiya shiisha ekofa. ");
INSERT INTO gofl_vpl VALUES ("DT15_8","006_15_8","DEU","15","8","8","Ne kushiya iyaw birsha; iya koshshiyaba tal7a. ");
INSERT INTO gofl_vpl VALUES ("DT15_9","006_15_9","DEU","15","9","9","“Aco maariya laapuntha laythi matis” gada, manqo Isra7eele asi tal7e diggofa; hessa mela iita qofi ne wozanan gelopo. Ne iyaw tal7onna ixin, I Xoossako yeekiko, hessi new nagara gidana. ");
INSERT INTO gofl_vpl VALUES ("DT15_10","006_15_10","DEU","15","10","10","Ne iyaw keehatethan imma; ne wozanan ayis immiyana gada uuzettofa. Hessa ne oothiko, Goday ne Xoossay nena oykidaban yedhidaban ubban anjana. ");
INSERT INTO gofl_vpl VALUES ("DT15_11","006_15_11","DEU","15","11","11","Awudeka gidin, biitta bollafe manqoy dhayonna gisho, ne Isra7eeletas, manqotasinne metootanchotas hinte keeha gidana mela kiittayis. ");
INSERT INTO gofl_vpl VALUES ("DT15_12","006_15_12","DEU","15","12","12","Adde gidin macca gidin, Isra7eele asi, aylle oothidi shammiko, I new usupun laythi ootho; laapuntha laythan aylletethafe la77a keyo. ");
INSERT INTO gofl_vpl VALUES ("DT15_13","006_15_13","DEU","15","13","13","Neeni aylletethaafe iya kessa yeddiya wode mela kushe yeddofa. ");
INSERT INTO gofl_vpl VALUES ("DT15_14","006_15_14","DEU","15","14","14","Goday ne Xoossay nena anjidaysa mela ne mehiyape, shaaliyapenne woyne gum7ethaafe entaw keehatethan imma. ");
INSERT INTO gofl_vpl VALUES ("DT15_15","006_15_15","DEU","15","15","15","Neeni kase Gibxe biittan aylle gididaysanne Goday ne Xoossay nena yaape wozidaysa dogopa. Ta hachi ha kiitaa new immey hessasa. ");
INSERT INTO gofl_vpl VALUES ("DT15_16","006_15_16","DEU","15","16","16","Shin ne aylley nenanne ne keetha asaa dosida gishonne neera de7oy iyaw lo77o gidiya gisho, “Taani ne soope biike” yaagiko, ");
INSERT INTO gofl_vpl VALUES ("DT15_17","006_15_17","DEU","15","17","17","iya penge efada, goothi ekada, iya haytha luka. Yaatiko, I new merinaw aylle gidana; qassi macca aylleska hessada ootha. ");
INSERT INTO gofl_vpl VALUES ("DT15_18","006_15_18","DEU","15","18","18","Iya neeni aylletethaafe kessada yeddiya wode neeni qohetas gada qopofa. I ha usupun laythata giddon asi une ootheysafe dako daro new oothis. Hessa gisho, neeni oothiyaba ubban Goday, ne Xoossay nena anjana. ");
INSERT INTO gofl_vpl VALUES ("DT15_19","006_15_19","DEU","15","19","19","Ne mehiyapenne ne dorsaa wudiyape bayra yeletida adde ubbaa Godaas, ne Xoossaas dummaya. Ne dummayida mehiyape bayra yeletida boora goyopa; ne dorsaa wudiyape bayra yeletida dorsaa ikisiya meedopa. ");
INSERT INTO gofl_vpl VALUES ("DT15_20","006_15_20","DEU","15","20","20","Nenne ne soo asay Goday dooriya bessan Godaa, ne Xoossaa sinthan hessata laythan laythan ma. ");
INSERT INTO gofl_vpl VALUES ("DT15_21","006_15_21","DEU","15","21","21","Shin ne yarshiya mehiya bolla borsiyabay bentiko, I wobbe woyko qooqe woyko hara iita borisiyabay iya bolla de7iko, hessa Godaas, ne Xoossaas yarshofa. ");
INSERT INTO gofl_vpl VALUES ("DT15_22","006_15_22","DEU","15","22","22","Hessa ne de7iya ne kataman ma; wogaada tuna gidonna asi gidin woyko tuna asi gidin gaaranne gen7e ashoda mo. ");
INSERT INTO gofl_vpl VALUES ("DT15_23","006_15_23","DEU","15","23","23","Gidoshin, ne iya suuthaa haathada sa7an gussafe attishin, moopa. ");
INSERT INTO gofl_vpl VALUES ("DT16_1","006_16_1","DEU","16","1","1","Abiiba ageenan Godaa, ne Xoossaa Paasika Ba7aale boncha; Goday, ne Xoossay nena Abiiba ageenan qamma Gibxefe kessis. ");
INSERT INTO gofl_vpl VALUES ("DT16_2","006_16_2","DEU","16","2","2","Neeni dorsafenne mehe wudiyape Goday ba sunthay xeegetana mela doorida bessan, Godaas, ne Xoossaas, Paasika yarsha. ");
INSERT INTO gofl_vpl VALUES ("DT16_3","006_16_3","DEU","16","3","3","He yarshuwa ne miya wode irshoy gelida uythara moopa. Neeni Gibxe yeddada eeson keyiya wode oothidaysada irshoy geliboonna meto uythaa laapun gallas kumethi ma. Ne de7o laytha ubban ne Gibxefe keyida gallasaa hassayana. ");
INSERT INTO gofl_vpl VALUES ("DT16_4","006_16_4","DEU","16","4","4","Ne biitta ubban laapun gallassas ayba irshoy bentofo. Qassi ne koyro gallas omarsi yarshida ashuwape wontas aybika attofo. ");
INSERT INTO gofl_vpl VALUES ("DT16_5","006_16_5","DEU","16","5","5","Ne Paasika yarshuwa Goday ne Xoossay new immiya katama awunka coo shukofa. ");
INSERT INTO gofl_vpl VALUES ("DT16_6","006_16_6","DEU","16","6","6","Goday ne Xoossay ba sunthay xeegetana mela dooriya bessan ne Paasika yarshuwa shuka. Qassi awi wulliya wode Gibxefe ne keyida gisho he saatiyan shuka. ");
INSERT INTO gofl_vpl VALUES ("DT16_7","006_16_7","DEU","16","7","7","Goday, ne Xoossay dooriya bessan, yan kathada ma; yaatada sa7i wontiya wode ne soo soo ba. ");
INSERT INTO gofl_vpl VALUES ("DT16_8","006_16_8","DEU","16","8","8","Usupun gallas kumethi irshoy geliboonna uythaa ma; laapuntha gallas Godaa, ne Xoossaa goyinnanaw shiiqa; he gallas ay oosoka oothofa. ");
INSERT INTO gofl_vpl VALUES ("DT16_9","006_16_9","DEU","16","9","9","Ne katha caka oykida koyro wodiyape doomada, laapun saaminta kumethi tayba. ");
INSERT INTO gofl_vpl VALUES ("DT16_10","006_16_10","DEU","16","10","10","Yaatada, Goday, ne Xoossay nena anjidaysa mela ne, ne dosan immiya imuwa ehada, Godaa, ne Xoossaa Saaminta Ba7aale boncha. ");
INSERT INTO gofl_vpl VALUES ("DT16_11","006_16_11","DEU","16","11","11","Hessan neeni, ne adde nayti, ne macca nayti, ne adde aylletinne ne macca aylleti, ne kataman de7iya Leeweti, bete asay, yi7o naytinne ne giddon de7iya am7eti ubbay, Goday, ne Xoossay ba sunthay xeegetana mela dooriya bessan ufaytite. ");
INSERT INTO gofl_vpl VALUES ("DT16_12","006_16_12","DEU","16","12","12","Neeni Gibxe biittan aylle gididaysa hassayada ha wogaa naaga. ");
INSERT INTO gofl_vpl VALUES ("DT16_13","006_16_13","DEU","16","13","13","Ne wudumaafe ne kathaa, woyne yedhiya bessaafe ne woyniya shiishidaape guye, laapun gallas Shaqara Ba7aale boncha. ");
INSERT INTO gofl_vpl VALUES ("DT16_14","006_16_14","DEU","16","14","14","Neeni, ne adde naytinne macca nayti, ne adde aylletinne macca aylleti, ne kataman de7iya Leeweti, bete asay, yi7o naytinne am7eti ubbay he baaliyan ufaytite. ");
INSERT INTO gofl_vpl VALUES ("DT16_15","006_16_15","DEU","16","15","15","Goday dooriya bessan laapun gallas Godaa, ne Xoossaa, Ba7aale boncha. Ne ufaytana mela ne ayfisidabaninne ne kushe ooso ubban Goday, ne Xoossay nena anjana. ");
INSERT INTO gofl_vpl VALUES ("DT16_16","006_16_16","DEU","16","16","16","Hinte biittan de7iya adde ubbay laythan heedzu toho, Uytha Ba7aale wode, Saaminta Ba7aale wodenne Shaqara Ba7aale wode Godaa, hinte Xoossaa sinthan, I dooriya bessan bento. Enti Godaa sinthe yishe, mela kushe yoopo. ");
INSERT INTO gofl_vpl VALUES ("DT16_17","006_16_17","DEU","16","17","17","Goday, ne Xoossay nena anjidaysa mela issoy issoy baw danda7eysa mela immo. ");
INSERT INTO gofl_vpl VALUES ("DT16_18","006_16_18","DEU","16","18","18","Goday, hinte Xoossay immiya katamatan issi issi kochaas daynnanne halaqa hintew shuumite; enti asaas xillo pirda pirdo. ");
INSERT INTO gofl_vpl VALUES ("DT16_19","006_16_19","DEU","16","19","19","Xillo pirdaa wobbisopa; som7o be7ada maaddofa; wodhaafe ekofa. Wodhaafey cincata ayfiya qooqisees, xillota qaala geellayees. ");
INSERT INTO gofl_vpl VALUES ("DT16_20","006_16_20","DEU","16","20","20","Ne de7on daana malanne Goday ne Xoossay new immiya biitta ne laattana mela xillo pirda. ");
INSERT INTO gofl_vpl VALUES ("DT16_21","006_16_21","DEU","16","21","21","Neeni Godaa, Xoossaa yarsho bessa matan Asheera eeqa misiliya essofa. ");
INSERT INTO gofl_vpl VALUES ("DT16_22","006_16_22","DEU","16","22","22","Hinte Goday, Xoossay ixiya goyinno shucha tuussu new essofa. ");
INSERT INTO gofl_vpl VALUES ("DT17_1","006_17_1","DEU","17","1","1","Godaas, ne Xoossaas, borisiyabay de7iya mehe woyko dorse yarsho oothada shiishopa; hessi Xoossa sinthan ixetidaba. ");
INSERT INTO gofl_vpl VALUES ("DT17_2","006_17_2","DEU","17","2","2","Goday, ne Xoossay new immiya katamatape awunka adde woyko macca gidin Godaa, ne Xoossaa sinthan iitaba oothikonne iya caaquwa menthidi bentiko, ");
INSERT INTO gofl_vpl VALUES ("DT17_3","006_17_3","DEU","17","3","3","ta kiita aggidi, hara xoossata, awa woyko ageena woyko salo xoolinto goyinnida asi de7iko, ");
INSERT INTO gofl_vpl VALUES ("DT17_4","006_17_4","DEU","17","4","4","hessa melaba hinte si7iko, he odaa minthidi pilga. Hinte koyin, hessa mela tunabay Isra7eele giddon oosetidaysi tumanne geeshshi gidiko, ");
INSERT INTO gofl_vpl VALUES ("DT17_5","006_17_5","DEU","17","5","5","he iitaa oothida addiya woyko maccasiw ne katamaape gaxa kessada, shuchan caddada wodha. ");
INSERT INTO gofl_vpl VALUES ("DT17_6","006_17_6","DEU","17","6","6","Issi asi nam7u woyko heedzu marki markatonna de7ishin hayqofo; issi asa markan ay asika hayqofo. ");
INSERT INTO gofl_vpl VALUES ("DT17_7","006_17_7","DEU","17","7","7","Iya bolla markatida asati koyro iya shuchan caddo; enta kaallidi hanko asay caddo. Hessada oothada, iitaa ne giddofe digga. ");
INSERT INTO gofl_vpl VALUES ("DT17_8","006_17_8","DEU","17","8","8","Hinte sinthe shiiqiya mootoy deexo gidiko, hessika, shempo wodho, shoche, madunthi, dumma dumma mootota Goday, ne Xoossay doorida bessaa eha. ");
INSERT INTO gofl_vpl VALUES ("DT17_9","006_17_9","DEU","17","9","9","Kahine gidida Leewetakonne daynnatako he mootuwa shiisha; he mootuwa enti pirdo. ");
INSERT INTO gofl_vpl VALUES ("DT17_10","006_17_10","DEU","17","10","10","Goday doorida bessan enti pirdidaysada ootha; ne oothana mela enti kiittiyaba ubba akeekada ootha. ");
INSERT INTO gofl_vpl VALUES ("DT17_11","006_17_11","DEU","17","11","11","Enti nena tamaarsida higgiyadanne enti odida pirdada ootha; enti pirdida pirdaafe ushachi woyko haddirsi goopa. ");
INSERT INTO gofl_vpl VALUES ("DT17_12","006_17_12","DEU","17","12","12","Godaas, ne Xoossaas oothiya daynnas woyko kahiniyas kiitetonna ixiya asi de7iko, he uray hayqo. Hessada oothada, iitaa Isra7eele giddofe digga. ");
INSERT INTO gofl_vpl VALUES ("DT17_13","006_17_13","DEU","17","13","13","Asa ubbay hessa si7idi yayyana; zaaridi hessa mela iita oothiya asi deenna. ");
INSERT INTO gofl_vpl VALUES ("DT17_14","006_17_14","DEU","17","14","14","Goday, ne Xoossay new immiya biitta laattada, yan de7o doomiya wode, ne yuushon de7iya kawotethatada, “Nuka nu bolla kawo kawothana” yaagiko, ");
INSERT INTO gofl_vpl VALUES ("DT17_15","006_17_15","DEU","17","15","15","ne kawothana kawoy Goday, ne Xoossay new dooridaysa gidanaw bessees. Hessika, ne asaa giddofe dooretidaysa gidope attishin, hara biitta asi ne bolla kawothofa. ");
INSERT INTO gofl_vpl VALUES ("DT17_16","006_17_16","DEU","17","16","16","Goday, “He ogiyara Gibxe simmopite” yaagida gisho, he kawoy daro para shiishanaw bessenna; ba asaaka para shammana mela Gibxe yeddofo. ");
INSERT INTO gofl_vpl VALUES ("DT17_17","006_17_17","DEU","17","17","17","Iya wozanaa balethonna mela kawoy daro macco ekofo; daro worqanne bira shiishopo. ");
INSERT INTO gofl_vpl VALUES ("DT17_18","006_17_18","DEU","17","18","18","I ba araatan uttiya wode Leewe koche gidida kahineti naagiya maxaafape ha higgiya duuqidi baw eko. ");
INSERT INTO gofl_vpl VALUES ("DT17_19","006_17_19","DEU","17","19","19","I ha higgiya qaalanne wogaa naagonne polo eridi Godaas, ba Xoossaas, yashshi tamaarana mela, ha maxaafay iyara de7o; ika ha maxaafa ba de7o laytha ubban nabbabo. ");
INSERT INTO gofl_vpl VALUES ("DT17_20","006_17_20","DEU","17","20","20","I ba wozanan, “Taani ta laggetape aadhayis” gidi ba ishata bolla otortenna. Ika Xoossaa higgiyafe haddirsi woyko ushachi geenna. I ba kawotethan adussa laythi kawotana; iya nayti Isra7eele biittan daro laythi kawotana. ");
INSERT INTO gofl_vpl VALUES ("DT18_1","006_18_1","DEU","18","1","1","Leewe koche gidida kahinetasinne attida enta kochaas Isra7eele giddon laata biitti baawa. Asay Godaas shiishiya xuussa yarshoy enta gisho gidiya gisho iya mishe daana. ");
INSERT INTO gofl_vpl VALUES ("DT18_2","006_18_2","DEU","18","2","2","Entaw enta ishata giddon laati deenna; Goday entaw gidaysada I enta laata. ");
INSERT INTO gofl_vpl VALUES ("DT18_3","006_18_3","DEU","18","3","3","Korma woyko dorse asay yarshos shiishidaysafe kahineta gishoy haysa; missay, gacoynne ulo ashoy entaw imeto. ");
INSERT INTO gofl_vpl VALUES ("DT18_4","006_18_4","DEU","18","4","4","Ne kathaafe, woyniyapenne zaytiyape koyro gakida ayfiyanne ne dorsa ikisiyape bayraa kahinetas imma. ");
INSERT INTO gofl_vpl VALUES ("DT18_5","006_18_5","DEU","18","5","5","Leeweti Godaa sunthan merinaw kahine gididi oothana mela ne kochaa giddofe Goday, ne Xoossay enta dooris. ");
INSERT INTO gofl_vpl VALUES ("DT18_6","006_18_6","DEU","18","6","6","Issi Leewey Isra7eele biittan de7iya issi katamaape dendidi, Goday dooriya bessaa baanaw koyiko, ");
INSERT INTO gofl_vpl VALUES ("DT18_7","006_18_7","DEU","18","7","7","I biya bessan de7iya Leeweti Godaa sinthan eqidi ootheysada ika Godaa ba Xoossaa sinthan eqidi ootho. ");
INSERT INTO gofl_vpl VALUES ("DT18_8","006_18_8","DEU","18","8","8","Bana gakiya gishuwa ekidaba gidikoka, kahineti go7etiya ubbaa entara gina shaaketidi eko. ");
INSERT INTO gofl_vpl VALUES ("DT18_9","006_18_9","DEU","18","9","9","Goday ne Xoossay immida biitta ne geliya wode he biittan de7iya asay oothiya ixetida oosota oothofa. ");
INSERT INTO gofl_vpl VALUES ("DT18_10","006_18_10","DEU","18","10","10","Ba adde na7aa woyko macca na7iw yarshos taman xuuggiya oonika ne giddon bentofo. Biti, maraace be7ey, marotey, higishey, ");
INSERT INTO gofl_vpl VALUES ("DT18_11","006_18_11","DEU","18","11","11","moytille be7ey, hayqida asa ayyaana xeegey, woyko hayqida asa ayyaanara odetey ne giddon de7opo. ");
INSERT INTO gofl_vpl VALUES ("DT18_12","006_18_12","DEU","18","12","12","Hessa melaba oothiya oonika Godaa matan ixetida asi. Enti hessa mela tunaa oothiya gisho, Goday ne Xoossay he kawotethata ne sinthafe gooddana. ");
INSERT INTO gofl_vpl VALUES ("DT18_13","006_18_13","DEU","18","13","13","Shin neeni Godaa ne Xoossaa sinthan borey baynaysa gida. ");
INSERT INTO gofl_vpl VALUES ("DT18_14","006_18_14","DEU","18","14","14","Neeni laattanaw biya biittan de7iya kawotethati murunneysatanne biteyisata; shin ne hessa oothonna mela Goday ne Xoossay nena diggis. ");
INSERT INTO gofl_vpl VALUES ("DT18_15","006_18_15","DEU","18","15","15","Goday, ne Xoossay ne kochaa giddofe ta mela nabe new denthana. Ne I geysa si7a. ");
INSERT INTO gofl_vpl VALUES ("DT18_16","006_18_16","DEU","18","16","16","Koreeba zumaa bolla ne shiiqida wode Godaa ne Xoossaa haysada yaagada oychadasa; “Ta hayqonna mela Godaa, ta Xoossaa girsaa zaarada si7ike; ha wolqaama tama zaarada be7ike” yaagadasa. ");
INSERT INTO gofl_vpl VALUES ("DT18_17","006_18_17","DEU","18","17","17","Goday taako, “Enti tuma gidoosona. ");
INSERT INTO gofl_vpl VALUES ("DT18_18","006_18_18","DEU","18","18","18","Ta enta kochaa giddofe ne mela nabe entaw denthana; taani ta qaala iya doonan wothana; i, t