﻿USE sofia;
DROP TABLE IF EXISTS sofia.gofe_vpl;
CREATE TABLE gofe_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES gofe_vpl WRITE;
INSERT INTO gofe_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","ፆሳይ ኮይሮ ሳሎታነ ሳአ መꬍስ። ");
INSERT INTO gofe_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","ሄ ዎደ ሳእ ጊጎናነ አይብካ ባይና መላ ደኤስ። ꬉም ቢታ ማእዳ ዎልቃማ ሃꬃታ ቦላ ደኤስ። ፆሳ አያናይ ሃꬃፈ ቦላራ ቃፄስ። ");
INSERT INTO gofe_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","ሄሳፈ ጉየ፥ ፆሳይ፥ “ፖኦይ ሀኖ” ያግን፥ ፖኦይ ሀንስ። ");
INSERT INTO gofe_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","ፖኦይ ሎኦ ግድዳይሳ ፆሳይ በእስ፤ ፖኡዋ ꬉማፐ ሻክስ። ");
INSERT INTO gofe_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","ፆሳይ ፖኡዋ፥ “ጋላስ” ግድ ሱንꬅስ፤ ቃስ ꬉማ “ቃማ” ግድ ሱንꬅስ። ሳእ ቃምስ ዎንትስ፤ ሄስ ኮይሮ ጋላስ። ");
INSERT INTO gofe_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","ሄሳፈ ጉየ፥ ፆሳይ፥ “ቦላራ ደእያ ሃꬃ ጋርሳን ደእያ ሃꬃፈ ሻክያ ሳሎ ጉፋንꬆይ ሀኖ” ያግን ሀንስ። ");
INSERT INTO gofe_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","ፆሳይ ሳሎ ጉፋንꬆ ጊግስድ፥ ሳሎ ጉፋንꬆፈ ቦላራ ደእያ ሃꬃ ጋርሳን ደእያ ሃꬃፈ ሻክስ። ");
INSERT INTO gofe_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","ፆሳይ ሄ ጉፋንꬁዋ፥ “ሳሎ” ግድ ሱንꬅስ። ሳእ ቃምስ፤ ዎንትስ፤ ሄስ ናምአንꬆ ጋላሳ። ");
INSERT INTO gofe_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","ሄሳፈ ጉየ፥ ፆሳይ፥ “መላ በሳይ ቆንጫናዳ ሳሎፐ ጋርሳን ደእያ ሃꬅ ኡባይ እስ በሲ ሺቆ” ያግን ሀንስ። ");
INSERT INTO gofe_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","ፆሳይ ሄ መላ በሳ፥ “ቢታ” ግድ ሱንꬅስ፤ ቃስ እስ በሳን ሺቅዳ ሃꬃ፥ “አባ” ግድ ሱንꬅስ። ያትድ፥ ፆሳይ ሄስ ሎኦ ግድዳይሳ በእስ። ");
INSERT INTO gofe_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","ሄሳፈ ጉየ፥ ፆሳይ፥ “ቢታይ ምꬅ ማታ ዶልሶ፤ ዘረꬃ አይፈይ ደእያ ካꬅነ ዘረꬃ አይፈይ ግዶን ደእያ ምꬅ ዶሎ” ያግስ፤ ሄሳዳካ ሀንስ። ");
INSERT INTO gofe_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","ቢታይ ምꬅ ማታ እያ ቆሞን ቆሞን ዶልስስ። ፆሳይ ሄስ ሎኦ ግድዳይሳ በእስ። ");
INSERT INTO gofe_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","ሳእ ቃምስ ዎንትስ፤ ሄስ ሄꬓንꬆ ጋላስ። ");
INSERT INTO gofe_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","ሄሳፈ ጉየ፥ ፆሳይ፥ “ጋላሳ ቃማፈ ሻካናዉ ፖኦት ሳሎን ሀኖ። ኤንቲ ቃማ፥ ጋላሳ፥ ዎደነ ላይꬅ ኤርሳናዉ ማላ ግዶ። ");
INSERT INTO gofe_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","ቢታ ቦላ ፖአና መላ ኤንቲ ሳሎ ጉፋንꬆን ሀኖ” ያግስ፤ ሄሳዳካ ሀንስ። ");
INSERT INTO gofe_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","ፆሳይ ናምኡ ግታ ፖኦታ መꬍስ። አዊ ጋላስ፥ አጌን ቃማ ፖአና መላ ኦꬅስ። ሄሳዳካ ፆልንቶታ መꬍስ። ");
INSERT INTO gofe_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","ፆሳይ ኤንቲ ሀ ሳአ ቦላ ፖአና መላ ሳሎን ዎꬅስ። ");
INSERT INTO gofe_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","ሄስ፥ ጋላስነ ቃማ ሃራና መላነ ፖኦ ꬉማፐ ሻካና መላሳ። ፆሳይ ሄስ ሎኦ ግድዳይሳ በእስ። ");
INSERT INTO gofe_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","ሳእ ቃምስ ዎንትስ፤ ሄስ ኦይዳንꬆ ጋላስ። ");
INSERT INTO gofe_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","ሄሳፈ ጉየ፥ ፆሳይ፥ “ደኦይ ደእያ ዱማ ዱማ መተꬃት ሃꬃን ዳሮ፤ ካፎትካ ሳአፐ ቦላራ፥ ሳሎ ጉፋንꬆፈ ጋርሳን ፕራꬎ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","ያትድ ፆሳይ አባን ደእያ ግታ ዶአታ፥ ሃꬃ ግዶን ዎፅ ቃፅያ መተꬃታ ኡባነ ፓልያ ካፎታ ኡባ እያ ቆሞን ቆሞን መꬍስ። ፆሳይ ሄስ ሎኦ ግድዳይሳ በእስ። ");
INSERT INTO gofe_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","ፆሳይ ኤንታ፥ “የለትተ፥ ዳርተ፥ አባ ኩምተ፥ ካፎት ቢታ ቦላ ዳሮ” ያግድ አንጅስ። ");
INSERT INTO gofe_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","ሳእ ቃምስ ዎንትስ፤ ሄስ እቻሻንꬆ ጋላስ። ");
INSERT INTO gofe_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","ሄሳፈ ጉየ፥ ፆሳይ፥ “ደኦይ ደእያ መተꬃት ኤንታ ቆሞን ቆሞን፥ መሄታ፥ ሳአራ ጎሸትያ መተꬃታነ ዶአታ ኤንታ ቆሞን ቆሞን ቢታይ ከሶ” ያግን ሀንስ። ");
INSERT INTO gofe_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","ሄሳዳ ኦꬅድ ኤንታ ኡባ መꬍስ። ፆሳይ ሄስ ሎኦ ግድዳይሳ በእስ። ");
INSERT INTO gofe_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","ሄሳፈ ስምን፥ ፆሳይ፥ “አሰ ኑና ዳንስድ አነ መꬎኦስ። ኤንቲ አባ ሞሉዋ፥ ሳሎ ካፎታ፥ ቢታ ቦላ ዎፅ ቃፅያ መተꬃ ኡባ ሃሮ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","ሄሳዳ ፆሳይ አሰ ባና ዳንስድ መꬍስ። እ አሰ ፆሰ ዳንስድ መꬍስ፤ ኤንታ አደነ ማጫስ ኦꬅድ መꬍስ። ");
INSERT INTO gofe_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","ፆሳይ ኤንታና፥ “የለትተ፥ ዳርተ፥ ሳአ ኩምተ፤ ሃርተ። አባ ሞሎ፥ ሳሎ ካፎታነ ቢታ ቦላ ዎፅ ቃፅያ፥ ደኦይ ደእያ መተꬃ ኡባ ሃርተ” ያግድ አንጅስ። ");
INSERT INTO gofe_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","ሄሳፈ ጉየ፥ ፆሳይ፥ “ታኒ ቢታ ኡባ ቦላ ዘረꬃ አይፈይ ደእያ ካꬃ ኡባነ ዘረꬃ አይፈይ ግዶን ደእያ ምꬅ ኡባ ህንተዉ እማስ፤ ሄስ ህንተዉ ካꬅ ግዶ። ");
INSERT INTO gofe_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","ቃስካ ሀ ሳአን ደእያ መሄነ ዶአ ኡባስ፥ ሳሎ ካፎ ኡባስነ ሳአራ ጎሸትያ መተꬃ ኡባስ ምያባ ግዳና መላ፥ ጭልኦ ምꬅነ ማታ እማስ” ያግስ፤ ሄሳዳካ ሀንስ። ");
INSERT INTO gofe_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","ፆሳይ ባ መꬍዳ ኡባባካ ፄልያ ዎደ ዳሮ ሎኦ ግድዳይሳ በእስ። ሳእ ቃምስ፤ ዎንትስ፤ ሄስ ኡሱፑንꬆ ጋላስ። ");
INSERT INTO gofe_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","ሳሎትነ ሳእ ኤንታን ደእያባ ኡባባይ ሀይሳዳ መትድ ፖለትስ። ");
INSERT INTO gofe_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","ፆሳይ ባ ኦሱዋ ፖልድ፥ ላፑንꬃ ጋላሳን ሸምፕስ። ");
INSERT INTO gofe_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","ፆሳይ ላፑንꬃ ጋላሳን ባ ኦꬅያ ኦሱዋ ኦንግድ ሸምፕዳ ግሾ ሄ ጋላሳ አንጅስ፤ ጋላሳታፐ ዱማይስ። ");
INSERT INTO gofe_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","ሳሎትነ ሳእ ሄሳዳ ሀን መትስ። ጎዳ ፆሳይ ሳአነ ሳሎታ መꬍዳ ዎደ፥ ");
INSERT INTO gofe_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","ሳአ ቦላ እር ቡክቦና ግሾነ ኦꬅያ አስ ባይና ግሾ ምꬅነ ማት ዶልቤና፤ አጭያባይካ ባዋ። ");
INSERT INTO gofe_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","ግዶሽን፥ ሳአፐ ሃꬅ ፑልትድ፥ ቢታ ኡባ ላክሴስ። ");
INSERT INTO gofe_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","ሄሳፈ ጉየ፥ ጎዳ ፆሳይ ቢታ ባናፐ አሰ መꬍድ እያ ሲራ ደኦ ሸምፖ ፑንድ ገልስስ። ያትን፥ ሄ አደይ ደኦራ ደእያ አሰ ግድስ። ");
INSERT INTO gofe_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","ጎዳ ፆሳይ ዶሎሀ ባጋራ ኤደነ ጋናተ ጊግስስ፤ ያን ባ መꬍዳ አድያ ዎꬅስ። ");
INSERT INTO gofe_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","ጎዳ ፆሳይ ፄላናዉ ሎእያ፥ ማናዉካ ማልእያ ኡባ ቆሞ ምꬅ ቢታፈ ዶልስስ። ጋናተ ግዶን ደኦ እምያነ ሎኦነ ኢታ ኤርስያ ናምኡ ምꬃታ ዎꬅስ። ");
INSERT INTO gofe_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","ጋናተ ኡሽያ ሻፋ ሃꬃይ ኤደነፐ ጎጌስ። ሄ ሻፋይ ኤደነፐ ከይድ ኦይዱ ሻፉ ከይድ ሻከቴስ። ");
INSERT INTO gofe_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","ኮይሮ ሻፋ ሱንꬃይ ፍሶነ። ፍሶነይ ዎርቀይ ደእያ ሀውላ ቢታ ቦላ ጎጌስ። ");
INSERT INTO gofe_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","ሄ ቢታ ዎርቀይ ጌሻ ዎርቃ። ቃስ አልኦ ሽቶይነ ሹች ያን ደኤስ። ");
INSERT INTO gofe_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","ናምአንꬆ ሻፋ ሱንꬃይ ግዮነ። ግዮነይ ቶጰ ቢታ ዩሹዋን ጎጌስ። ");
INSERT INTO gofe_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","ሄꬓንꬆ ሻፋ ሱንꬃይ ፀግሮሳ። ፀግሮስ አሶረፐ ዶሎሀ ባጋራ ጎጌስ። ቃስ ኦይዳንꬆ ሻፋይ ኤፍራፂሳ። ");
INSERT INTO gofe_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","ጎዳ ፆሳይ አስ ኤደነ ጋናተ ኦꬃና መላነ ናጋና መላ እያ ኤፍድ ያን ዎꬅስ። ");
INSERT INTO gofe_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","ጎዳ ፆሳይ አሰ፥ “ጋናተ ምꬃ ቴራ ኡባፈ ኔኒ ማናዉ ዳንዳኣሳ። ");
INSERT INTO gofe_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","ሽን ሎኦነ ኢታ ኤርስያ ምꬃ አይፍያፐ ሞፓ። አይስ ጊኮ፥ ኔኒ እያፐ ምዳ ጋላስ ቱማ ሀይቃና” ያግድ ኪትስ። ");
INSERT INTO gofe_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","ሄሳፈ ጉየ፥ ጎዳ ፆሳይ፥ “አደይ ባርካ ደኤይስ ሎኦ ግደና። ታኒ እያ ማዳና መላ እያዉ እንጀትያ ላገ መꬋና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","ጎዳ ፆሳይ መሄታ፥ ዶአታነ ሳሎ ካፎታ ኡባ ቢታፈ መꬍስ። ያትድ፥ ኤንታ ዎይግድ ሱንꬃነኮ በአናዉ አዳመኮ ኤህን፥ አዳመይ ደኦይ ደእያ መተꬃ ኡባ ሱንꬅዳ ሱንꬃይ ኤንታ ሱንꬅ ግድድ አትስ። ");
INSERT INTO gofe_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","ሄሳዳካ፥ አዳመይ መሄታ፥ ሳሎ ካፎታነ ባዞ ዶአታ ኡባ ሱንꬅስ። ሽን አዳመስ እንጀትያነ እያ ማድያ ላገይ በንትቤና። ");
INSERT INTO gofe_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","ሄሳ ግሾ፥ ጎዳ ፆሳይ አዳመ ዎልቃማ ꬍስኮን የግስ። እ ꬍስኮ ሀይቅዳሽን እያ ምየ መቀꬃፈ እሱዋ ኤክድ፥ ሄ በሳ አሾን ኩንꬅስ። ");
INSERT INTO gofe_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","ጎዳ ፆሳይ አዳመፐ ኤክዳ መቀꬃ ማጫ ኦꬅድ መꬍስ፤ ያትድ እዮ እያኮ ኤህስ። ");
INSERT INTO gofe_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","አዳመይ፥ “ሀ መቀꬅያ ታ መቀꬃፈ፥ ሀ አሽያ ታ አሾፐ ኤከትዳሮ። እያ አደፈ ኤከትዳ ግሾ ማጫ ጌተቶ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","ሄሳ ግሾ አስ ባ አዋነ ባ አይዉ አግድ፥ ባ ማቸራ እስፈ ደኤስ፤ ናምአይ እስ አስ ግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","አዳመይነ ሄዋና ናምአይካ ፅረ ካሎ ደኦሶና፤ ሽን እሶይ እሱዋስ ዬላቶኮና። ");
INSERT INTO gofe_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","ሾሽ ጎዳ ፆሳይ መꬍዳ ዶአ ኡባፈ አꬍዳ ገናንቾ። እስ ጋላስ ሾሽ ማጫስዉ፥ “ፆሳይ ቱማ ህንተና፥ ‘ጋናትያን ደእያ ምꬃ አይፈ ኡባፈ ሞፕተ’ ግዴ?” ያግድ ኦይችስ። ");
INSERT INTO gofe_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","ማጫስያ ሾሻኮ፥ “አካይ፥ ፆሳይ ሄሳዳ ግቤና፤ ኑኒ ጋናተ ግዶን ደእያ ምꬃታ አይፈ ማናዉ ዳንዳኦስ። ");
INSERT INTO gofe_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","ሽን ፆሳይ ኑና፥ ‘ጋናተ ግዶን ደእያ ምꬃ አይፈ ሞፕተ፥ ቦቾፍተ፤ እፅኮ ህንተ ሀይቃና’ ግስ” ያጋሱ። ");
INSERT INTO gofe_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","ሾሻይ ማጫስዉ፥ “ህንተ አይኮካ ሀይቀከታ። ");
INSERT INTO gofe_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","ፆሳይ ሄሳ ግዳይ፥ ሄ ምꬃ አይፍያ ህንተ ሚኮ አኬካ ደምድ ሎኦነ ኢታ ፆሳዳ ህንተ ኤራናይሳ እ ኤርያ ግሾሳ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","ማጫስያ ምꬃ አይፈይ ማናዉ ማልኤይሳ፥ በአናዉ ሎኤይሳነ፥ ጭንጫተꬅ ደማናዉ አሞያባ ግደይሳ በአሱ። ሄ ምꬃ አይፍያፐ ኤካዳ ማሱ። ቃስ ባ አዝናስካ እምን እካ ምስ። ");
INSERT INTO gofe_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","ኤንቲ ም ስሚድ፥ ናምአይካ አኬካ ደምዶሶና። ኤንቲ ፅረ ካሎ ደኤይሳ ኤርዶሶና። ሄሳ ግሾ ባላሰ ምꬃ ሀይꬅ ስክድ ዳንጭዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","ሳእ ኦማርስዳ ዎደ ጋናተ ግዶን ጎዳ ፆሳይ ሄመትሽን እያ ግርሳ አዳመይነ እያ ማችያ ስእዶሶና። ኤንቲ ጋናተ ምꬃ ግዶን ጎዳ ፆሳፈ ቆሰትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","ሽን ጎዳ ፆሳይ አዳመ ፄግድ፥ “አዳመ፥ አዉን ደአይ?” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","አዳመይ፥ “ጋናተ ግዶን ነ ግርሳ ስአዳ ታኒ ካሎ ደእያ ግሾ ያያዳ ቆሰታስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","ጎዳ ፆሳይ፥ “ኔኒ ካሎ ደኤይሳ ነዉ ኦድዳይ ኦኔ? ታኒ ነና ሞፓ ግዳ ምꬃ አይፈፐ ማድዬ?” ያግድ ኦይችስ። ");
INSERT INTO gofe_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","አዳመይ፥ “ታራ ዳና መላ ኔኒ እምዳ ማጫስያ ሄ ምꬃ አይፍያፐ ታዉ እምን ማስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","ጎዳ ፆሳይ፥ ማጫስዉ፥ “ኔኒ ሄሳ አይስ ኦꬃዲ?” ያግድ ኦይችስ። ማጫስያ፥ “ታና ሾሻይ ጭምን ማስ” ያጋሱ። ");
INSERT INTO gofe_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","ጎዳ ፆሳይ ሾሻ፥ “ኔኒ ሀይሳ ኦꬅዳ ግሾ፥ መሄፐነ ዶአ ኡባፈ አꬋዳ ባደትዳባ ግዳ። ኔኒ ነ ኡሎን ቢታራ ጎሸታና፤ ነ ደኦ ላይꬃ ኡባን ባና ላጫና። ");
INSERT INTO gofe_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","ታኒ፥ ነ ግዶንነ ማጫሰ ግዶን፥ ነ ሼሻ ግዶንነ እ ሼሻ ግዶን ሞርከተꬅ ዎꬃና። እ ነ ሁጵያ ቆፃና፥ ነካ እያ ግንድያ ዱካና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","ማጫስዉ ጎዳ ፆሳይ፥ “ነ ቃንꬃትዳ አጌናን ዳሮ ኡንኤታና። ኔኒ ዎልቃማ ዋየን ናአ የላና። ግዶሽን፥ ኔኒ ነ አዝናራ ዳናዉ አሞታና፤ እ ነና ሃራና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","ጎዳ ፆሳይ አዳመኮ፥ “ኔኒ ነ ማቸ ኦዳ ስእዳ ግሾነ ታኒ ነና ሞፓ ግዳ ምꬃ አይፍያፐ ኔኒ ምዳ ግሾ፥ ቢታይ ነ ጋሶን ባደትዳይሳ ግዶ። ኔኒ ነ ደኦ ላይꬃ ኡባን ግታ ዳቡርሳን ቢታ ኦꬃዳ ማና። ");
INSERT INTO gofe_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","ቢታይ ነዉ አጉንꬅነ ሀርመ ዶልሳና፤ ኔኒ ቢታፈ ዶልድ ካፅያባ ማና። ");
INSERT INTO gofe_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","ኔኒ ነ መትዳ ቢታ ስማና ጋካናዉ ዳቡራን ጫዋታዳ ኦꬅዳ ነ ካꬅ ማና። ኔኒ ቢታፈ መትዳ ግሾ ቢታ ስማና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","አዳመይ ባ ማችዉ ደኦይ ደእያ አሳ ኡባስ አዮ ግድያ ግሾ ሄዋኖ ግድ ሱንꬅስ። ");
INSERT INTO gofe_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","ጎዳ ፆሳይ አዳመነ እያ ማችዉ እተ ጊግስድ ማይዝስ። ");
INSERT INTO gofe_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","ጎዳ ፆሳይ፥ “ህዛ አስ ሎኦነ ኢታ ኤሮን ኑፐ እሱዋዳ ግድስ። ኤንቲ ባንታ ኩሽያ የድድ፥ ደኦ እምያ ምꬃ አይፍያፐ ኤክድ ሞና መላነ መርናዉ ደኦን ዶና መላ ተቀታናዉ ኮሼስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","ሄሳ ግሾ፥ ኤንቲ ባንታ መትዳ ቢታ ኦꬃና መላ ጎዳ ፆሳይ ኤደነ ጋናተፐ ኤንታ ከስስ። ");
INSERT INTO gofe_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","ያትድ፥ ደኦ እምያ ምꬃኮ ኤፍያ ኦግያ ናጋና መላ ክሩቤላ ጌተትያ ደኦ መተꬃታነ ሽረት ሽረት ዎꬍያ ታማ ላጮ ማሸ ኤደነ ጋናተፐ ዶሎሀ ባጋራ ዎꬅስ። ");
INSERT INTO gofe_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","አዳመይ ባ ማቸ ሄዋንራ አቅስ። እያ ቃንꬃታዳ አደ ናአ የላሱ። “ጎዳይ ታና ማድን አደ ናአ ደማስ” ጋዳ ቃየላ ጋዳ ሱንꬃሱ። ");
INSERT INTO gofe_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","እያ እሻ አበላ የላሱ። አበል ዶርሰ ሄሜስ ቃስ ቃየል ቢታ ኦꬄስ። ");
INSERT INTO gofe_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","ኡንደና ዎደፐ ጉየ፥ ቃየል ባ ጋደን ካፅዳ ካꬃፈ ጎዳስ ያርሾ ያርሽስ። ");
INSERT INTO gofe_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","ሽን አበል ባ ዶርሳ ዉድያ ግዶን ባይራ የለትዳይሳ ሹክድ እያ አሹዋፐ ሞꬎ ባጋ ያርሽስ። ጎዳይ አበላነ እያ ያርሹዋ ኤክስ። ");
INSERT INTO gofe_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","ሽን ቃየላነ እያ ያርሹዋ ኤክቤና። ሄሳ ግሾ፥ ቃየል ዳሮ ይሎትስ፤ እያ ሶምኦይ ꬉምስ። ");
INSERT INTO gofe_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","ጎዳይ ቃየላኮ፥ “አይስ ይሎታይ? ነ ሶምኦይ አይስ ꬉምዴ? ");
INSERT INTO gofe_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","ኔኒ ሎኦ ኦꬅዳባ ግድያኮ፥ ነ ሶምኦይ ፓሽካ ግደኔ? ሽን ኔኒ ሎኦ ኦꬆና እፅኮ፥ ናጋር ዶአዳ ነ ፐንገን ናጌስ። እ ነና ሃራናዉ ኮዬስ፥ ሽን ኔኒ እያ ፆናናዉ በሴስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","ሄሳፈ ጉየ፥ ቃየል ባ እሻ አበላኮ፥ “አነ ደምባ በሲ ቦስ” ያግስ። ኤንቲ ደምባን ደእሽን፥ ቃየል ባ እሻ አበላ ቦላ ደንድድ እያ ዎꬍስ። ");
INSERT INTO gofe_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","ጎዳይ ቃየላ፥ “ነ እሻይ አበል አዉኔ?” ያግድ ኦይችስ። ቃየል ዛሪድ፥ “ታኒ ኤርከ፤ ታ እሻ ናገይ ታነዬ?” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","ጎዳይ ቃየላ፥ “ሀይሳ አይስ ኦꬃዲ? ሄኮ፥ ነ እሻ ሱꬃይ ቢታፈ ታኮ ፅሎ ፕርዳስ ዋሴስ። ");
INSERT INTO gofe_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","ኔኒ ባደትዳባ ግድያ ግሾ ቢታ ዛራዳ ኦꬃናዉ ዳንዳአካ። ነ እሻ ዎꬋዳሳ እያ ሱꬃካ ቢታን ጉሳዳሳ። ");
INSERT INTO gofe_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","ኔኒ ኦꬅንካ ቢታይ ነዉ አይፈና፤ በተ አሳዳ ኔኒ ሳአ ቦላ ቶይላታዳ ዳቡራና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","ቃየል ጎዳኮ፥ “ነ ታ ቦላ ፕርድዳ ፕርዳይ ታ ዎልቃፈ ቦላ። ");
INSERT INTO gofe_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","ኔኒ ታና ሀች ቢታፈ የደꬃሳ፤ ነ ስንꬃፈካ ሃሳሳ። በተ አሳዳ ታኒ ሳአ ቦላ ዳቡራና፤ ታና ደምያ ኦንካ ዎꬋና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","ጎዳይ እያ፥ “ነና ኦንካ ዎና፤ ዎꬍኮ፥ ታኒ ላፑን ቶሆ ሀሎ ከያና” ያግስ። ሄሳ ግሾ፥ እያ ደምያ ኦንካ ዎꬎና መላ ጎዳይ እያ ቦላ ናግሶ ማላ ዎꬅስ። ");
INSERT INTO gofe_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","ቃየል ጎዳ ስንꬃፈ ከይድ፥ ኤደነ ባጋፈ ዶሎሀ ባጋን ደእያ ኖዳ፥ ቢታን ደእስ። ");
INSERT INTO gofe_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","ቃየል ባ ማቸራ አቅስ፤ እያ ቃንꬃታዳ ሄኖከ የላሱ። ሄ ዎደ ቃየል ካታማ ኬፅድ፥ ሄ ካታማ ባ ናኣ ሱንꬃን “ሄኖከ” ግድ ሱንꬅስ። ");
INSERT INTO gofe_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","ሄኖከይ ጋይዳ የልስ። ጋይድ ማኤላ የልስ። ማኤል ማቱሳኤላ የልስ። ማቱሳኤል ላመሀ የልስ። ");
INSERT INTO gofe_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","ላመህ አዶነ ሲሎ ጌተትያ ናምኡ ማቾ ኤክስ። ");
INSERT INTO gofe_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","አዳ ያባላ የላሱ። ያባል መሄ ሃርያነ ዱንካነን ደእያ አሳታ አዋ። ");
INSERT INTO gofe_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","እያ እሻ ሱንꬃይ ዩባላ። ዩባል ቃስ ዲꬅ ዲፀይሳታነ ሱሱልኤ ፑንያ አሳታ ኡባ አዋ። ");
INSERT INTO gofe_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","ሲላ ቃስ ቱባልቃይና ጌተትያ ናኣ የላሱ። ቱባልቃይን ናሰ ብራታፐነ ብራታፐ ዱማ ዱማ ሚሸታ ቆፀይሳታ አዋ። ቱባልቃይና ምችያ ናእሞ። ");
INSERT INTO gofe_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","እስ ጋላስ ላመህ ባ ማቸታ፥ “አደ፥ ሲለ፥ ስእተ፤ ታ ማቸቶ፥ ታኒ ኦድያባ ሀይዝተ። እስ ፓንꬃ አደይ ታና ደችድ ማዱንፅስዳ ግሾ፥ ታኒ እያ ዎꬋስ። ");
INSERT INTO gofe_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","ቃየላ ሃሉዋ ከያናው ላፑን ኩሸ ኮሽኮ፥ ላመሀ ሃሉዋ ከያናው ላፑን ታማነ ላፑን ኩሸ ኮሼስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","አዳመ ማችያ ሀራ አደ ናኣ የላሱ። ያታዳ፥ “ቃየል ዎꬍዳ አበላ ግሾ ፆሳይ ታዉ ሀራ ናአ እሚስ” ጋዳ እያ ሴታ ጋዳ ሱንꬃሱ። ");
INSERT INTO gofe_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","ሴት አደ ናአ የልድ እያ “ሄኖሳ” ግድ ሱንꬅስ። አሳይ ጎዳ ሱንꬃ ፄግድ ጎይኖ ዶምዳይ ሄ ዎደ። ");
INSERT INTO gofe_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","አዳመ የለተꬃይ ሀይሳፈ ካልድ ፃፈትዳይሳ። ፆሳይ አሰ መꬍዳ ጋላስ ባና ዳንስድ መꬍስ። ");
INSERT INTO gofe_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","እ አደነ ማጫስ ኦꬅ መꬍድ ኤንታ አንጅስ። ኤንታ መꬍድ አሰ (አዳመ) ግድ ሱንꬅስ። ");
INSERT INTO gofe_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","አዳመይ 130 ላይꬅ ደእድ፥ ባና ዳንያ አደ ናአ የልድ እያ “ሴታ” ግድ ሱንꬅስ። ");
INSERT INTO gofe_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","አዳመይ ሴታ የልዳፐ ጉየ 800 ላይꬅ ደእስ። ሀራ አደ ናይታነ ማጫ ናይታ የልስ። ");
INSERT INTO gofe_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","አዳመይ 930 ላይꬅ ደእድ ሀይቅስ። ");
INSERT INTO gofe_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","ሴት 105 ላይꬅ ደእድ ሄኖሳ የልስ። ");
INSERT INTO gofe_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","ሴት ሄኖሳ የልዳፐ ጉየ፥ 807 ላይꬅ ደእስ። ሀራ አደ ናይታነ ማጫ ናይታ የልስ። ");
INSERT INTO gofe_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","ሴት 912 ላይꬅ ደእድ ሀይቅስ። ");
INSERT INTO gofe_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","ሄኖስ 90 ላይꬅ ደእድ፥ ቃይናና የልስ። ");
INSERT INTO gofe_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","ሄኖስ ቃይናና የልዳፐ ጉየ፥ 815 ላይꬅ ደእስ። ሀራ አደ ናይታነ ማጫ ናይታ የልስ። ");
INSERT INTO gofe_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","ሄኖስ 905 ላይꬅ ደእድ ሀይቅስ። ");
INSERT INTO gofe_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","ቃይናን 70 ላይꬅ ደእድ፥ ማላልኤላ የልስ። ");
INSERT INTO gofe_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","ቃይናን ማላልኤላ የልዳፐ ጉየ፥ 840 ላይꬅ ደእስ። ሀራ አደ ናይታነ ማጫ ናይታ የልስ። ");
INSERT INTO gofe_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","ቃይናን 910 ላይꬅ ደእድ ሀይቅስ። ");
INSERT INTO gofe_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","ማላልኤል 65 ላይꬅ ደእድ፥ ያረዳ የልስ። ");
INSERT INTO gofe_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","ማላልኤል ያረዳ የልዳፐ ጉየ፥ 830 ላይꬅ ደእስ። ሀራ አደ ናይታነ ማጫ ናይታ የልስ። ");
INSERT INTO gofe_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","ማላልኤል 895 ላይꬅ ደእድ ሀይቅስ። ");
INSERT INTO gofe_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","ያረድ 162 ላይꬅ ደእድ፥ ሄኖከ የልስ። ");
INSERT INTO gofe_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","ያረድ ሄኖከ የልዳፐ ጉየ፥ 800 ላይꬅ ደእስ። ሀራ አደ ናይታነ ማጫ ናይታ የልስ። ");
INSERT INTO gofe_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","ያረድ 962 ላይꬅ ደእድ ሀይቅስ። ");
INSERT INTO gofe_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","ሄኖከይ 65 ላይꬅ ደእድ፥ ማቱሳላ የልስ። ");
INSERT INTO gofe_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","ማቱሳላ የልዳፐ ጉየ፥ ሄኖከይ 300 ላይꬅ ፆሰ ኡፋይስያ ደኦ ደእስ። ሀራ አደ ናይታነ ማጫ ናይታ የልስ። ");
INSERT INTO gofe_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","ሄኖከይ 365 ላይꬅ ደእስ። ");
INSERT INTO gofe_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","ፆሲ እያ ባኮ ኤክዳ ግሾ ስሚድ በንትቤና። ");
INSERT INTO gofe_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","ማቱሳል 187 ላይꬅ ደእድ፥ ላመሀ የልስ። ");
INSERT INTO gofe_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","ማቱሳል ላመሀ የልዳፐ ጉየ፥ 782 ላይꬅ ደእስ። ሀራ አደ ናይታነ ማጫ ናይታ የልስ። ");
INSERT INTO gofe_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","ማቱሳል 969 ላይꬅ ደእድ ሀይቅስ። ");
INSERT INTO gofe_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","ላመህ 182 ላይꬅ ደእድ፥ አደ ናአ የልስ። ");
INSERT INTO gofe_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","ያትድ፥ “ሀ ናአይ ጎዳይ ባድዳ ቢታ ቦላ ሀ ዳቡራ ኦሶ ኡባፈ ኑና ሸምፕሳና” ግድ እያ ኖሄ ግድ ሱንꬅስ። ");
INSERT INTO gofe_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","ላመህ ኖሄ የልዳፐ ጉየ፥ 595 ላይꬅ ደእስ። ሀራ አደ ናይታነ ማጫ ናይታ የልስ። ");
INSERT INTO gofe_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","ላመህ 777 ላይꬅ ደእድ ሀይቅስ። ");
INSERT INTO gofe_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","ኖሄይ 500 ላይꬅ ደእ ስሚድ ሄꬑ አደ ናይታ ሴማ፥ ካማነ ያፈታ የልስ። ");
INSERT INTO gofe_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","አሳይ ሳአ ቦላ ዳርዳ ዎደ ኤንታዉ ማጫ ናይት የለትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","“ፆሳ ናይታ” ጌተትያ መተꬃት ሄ ማጫ ናይት ማላ ሎኦ ግደይሳ በእድ ኤንታፈ ባንታዉ ዶርዳይሳታ ማችዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","ጎዳይ፥ “አሳስ ደኦ እምያ ታ አያናይ አሳን መርናዉ ዴና። አስ ሀይቀይሳ ግድያ ግሾ፥ ህዛፐ እያ ላይꬃይ እስ ፄታነ ላታማ ግዳና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","ሄ ዎደነ ሄሳፈ ጉየ፥ ፆሳ ናይት አሳ ማጫ ናይታ ኤክን፥ ናይት የለትዳ ዎደ፥ ዎጋ አዱሳ አሳት ሳአ ቦላ ደእዶሶና። ኤንቲ በን ዎደ ኦላስ ምኖነ ኤረትዳ አሳታ። ");
INSERT INTO gofe_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","ጎዳይ ሄ ዎደ ሳአ ቦላ ደእያ አሳ ኢታተꬅ ዳርዳይሳነ ኤንታ ዎዛናይ ኡባ ዎደ ቆፕያባይ ኢታ ፃላላ ግድዳይሳ ");
INSERT INTO gofe_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","በእድ፥ አሰ ሀ ሳአ ቦላ መꬍዳይሳን አዛንስ፤ ባ ዎዛናን ዳሮ ቂሮትስ። ");
INSERT INTO gofe_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","ታኒ አሰ አይስ መꬋድና ጋዳ ቂሮታስ። ሄሳ ግሾ፥ ጎዳይ፥ “ታኒ መꬍዳ አሰ፥ መሄ፥ ዶአ፥ ሳአራ ጎሸትያ መተꬃታነ ሳሎ ካፎታ ሳአ ቦላፈ ꬋይሳና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","ሽን ኖሄይ ጎዳ ስንꬃን ሳባ ደምስ። ");
INSERT INTO gofe_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","ኖሄ ታርከይ ሀይሳፈ ካልድ ፃፈትዳይሳ። ኖሄይ ባ ዎደ ደእያ አሳ ግዶፈ ፆሳ ኡፋይስያነ ሱረ አስ። ");
INSERT INTO gofe_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","ኖሄይ ሴማ፥ ካማነ ያፈታ ጌተትያ ሄꬑ አደ ናይታ የልስ። ");
INSERT INTO gofe_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","ሄ ዎደ ቢታይ ኩመꬅ ፆሳ ስንꬃን ቱንስ፤ ቢታ ኡባይ ጌላተꬃን ኩምስ። ");
INSERT INTO gofe_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","ፆሳይ ሀ ቢታ ፄልያ ዎደ ሳአን ደእያ አሳ ኡባይ ባንታ ኦግያ ቱንስድ ደኤይሳ በእስ። ");
INSERT INTO gofe_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","ሄሳ ግሾ፥ ፆሳይ ኖሄ ሀይሳዳ ያግድ ኪትስ፤ “ታኒ አሳ ኡባ ꬋይሳና ሀናይስ። ኤንታ ጋሶን ቢታይ ጌላተꬃን ኩምዳ ግሾ፥ አሰ ቢታፈ ꬋይሳና። ");
INSERT INTO gofe_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","ሄሳ ግሾ፥ ምኖ ምꬃፈ ነዉ ማርካበ ኬፃ። ሄ ማርካብያ ግዶን ዳሮ ቆልአታ ከሳ። ያታዳ ሶራነ ካረራ ማደ መላባን ሜሻ። ");
INSERT INTO gofe_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","ማርካብያ ሀይሳዳ ያታዳ ኬፃ፤ አዱሳተꬃ 300 ዋꬋ፥ ጎምፓ 50 ዋꬋ፥ ጌሳ 30 ዋꬋ ኦꬃ። ");
INSERT INTO gofe_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","ማርካብያስ ካራ መꬋ፤ ካራፐነ ጎዳፐ ግዶን እስ ዋꬋ ግድያ በሲ ዶያ አጋ። ፐንግያ ማርካብያስ ምየ ባጋራ ከሳ፤ ማርካብያ ሄꬑ ፖቀ ከሳዳ ኬፃ። ");
INSERT INTO gofe_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","“ታኒ ሳሎፐ ጋርሳን ሸምፖራ ደእያ መተꬃ ኡባ ꬋይሳናዉ ꬋዮ ሃꬃ የዳዳ ሀ ሳኣ ቦላ ደእያባ ኡባ ꬋይሳና። ");
INSERT INTO gofe_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","ሽን ታኒ ታ ጫቁዋ ኔራ ጫቃና። ኔኒ፥ ነ ማችዉ፥ ነ አደ ናይታነ ኤንታ ማቸታ ኤካዳ ማርካብያ ግዶ ገላ። ");
INSERT INTO gofe_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","ኤንቲ ኔራ ደኦን ዳና መላ፥ ደኦይ ደእያ መተꬃ ኡባፈ ቆሞን ቆሞን አደነ ማጫ ናምአ ናምአ ኦꬃዳ፥ ማርካብያ ግዶ ገልሳ። ");
INSERT INTO gofe_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","ዱማ ዱማ ቆሞ ካፎታፐ፥ ዱማ ዱማ ቆሞ መሄታፐነ ሳአራ ጎሸትያ ዱማ ዱማ ቆሞ መተꬃ ኡባፈ ናምአ ናምአ ግድድ ደኦን ዳና መላ ኔኮ ዮ። ");
INSERT INTO gofe_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","ቃስ ህንተነ ዶአት ማናዉ ዱማ ዱማ ቆሞ ምያ ካꬅ ኤፋዳ፥ ማርካብያ ግዶን ቆላ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","ኖሄይ ኡባባካ ፆሳይ ኪትዳይሳዳ ኦꬅስ። ");
INSERT INTO gofe_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","ሄሳፈ ጉየ ጎዳይ ኖሄ ሀይሳዳ ያግስ፤ “ኔኒ ነ ሶ አሳ ኡባራ ማርካብያ ግዶ ገላ። ሀ ዎድያ የለተꬃ ግዶን ታ ሸንያ ፖልዳይ ነ ፃላላ ግድዳይሳ በአስ። ");
INSERT INTO gofe_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","ኔኒ ቱና ግዶና መሄነ ዶአ ኡባፈ እያ ቆሞፈ ቆሞፈ አደነ ማጫ ላፑን ላፑን፥ ቱና መሄነ ዶአ ኡባፈ እያ ቆሞፈ ቆሞፈ እስ አደነ እስ ማጫ ገልሳ። ");
INSERT INTO gofe_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","ቃስ ሳሎ ካፎታፐ እያ ቆሞፈ ቆሞፈ አደነ ማጫ ላፑን ላፑን ኦꬃዳ፥ ቢታ ኡባ ቦላ ዱማ ዱማ ኮቻይ ደኦን ዳና መላ ኔራ ኤካዳ ገላ። ");
INSERT INTO gofe_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","ላፑን ጋላሳፐ ጉየ፥ ታኒ ኦይታሙ ጋላስነ ኦይታሙ ቃማ ሀ ሳኣ ቦላ እራ ቡክሳና። ያታዳ ታኒ መꬍዳ መተꬃ ኡባ ቢታ ቦላፈ ቁቻና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","ያትን ኖሄይ ጎዳይ እያ ኪትዳ ኡባባ ኦꬅስ። ");
INSERT INTO gofe_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","ꬋዮ ሃꬃይ ሀ ሳኣ ቦላ ይዳ ዎደ ኖሄስ ላይꬅ ኡሱፑን ፄታ። ");
INSERT INTO gofe_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","ኖሄይ፥ እያ አደ ናይት፥ እያ ማችያነ እያ ናይታ ማቸት ꬋዮ ሃꬃፈ አታናዉ ማርካብያ ግዶ ገልዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","ቱና ግዶና መሄፐነ ዶአፐ፥ ቱና መሄፐነ ዶአፐ ካፎታፐነ ቢታራ ጎሸተይሳታ ኡባፈ ");
INSERT INTO gofe_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","ፆሳይ ኖሄ ኪትዳይሳዳ አደነ ማጫስ ናምአ ናምአ ግድድ፥ ኖሄኮ ማርካብያ ግዶ ገልዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","ላፑን ጋላሳፐ ጉየ፥ ꬋዮ ሃꬃይ ሀ ሳአ ቦላ ይስ። ");
INSERT INTO gofe_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","ኖሄይ ኡሱፑን ፄቱ ላይꬅ ደእን፥ ናምአንꬆ አጌናን፥ ታማነ ላፑንꬃ ጋላሳን፥ ቢታ ግዶን ደእያ ግታ ጪሙዋ ፑልቶ ኡባይ ꬉቅ አግስ። ሳሎን ደእያ ሃꬃ ማስኮተት ዶየትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","እራይ ሀ ሳኣ ቦላ ኦይታሙ ጋላስነ ኦይታሙ ቃማ ቡክስ። ");
INSERT INTO gofe_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","እር ቡካ ዶምዳ ጋላስ ኖሄይነ እያ ማችያ፥ እያ አደ ናይት፥ ሴም፥ ካምነ ያፈት፥ እያ ናይታ ሄꬓታ ማቸት እስፈ ማርካብያ ግዶ ገልዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","ዶአ ኡባፈ ባ ቆሞን ቆሞን፥ መሄ ኡባፈ ባ ቆሞን ቆሞን፥ ቢታራ ጎሸትያ ኡባፈ ባ ቆሞን ቆሞን፥ ካፎ ኡባፈ ባ ቆሞን ቆሞን ኤንታራ እስፈ ገልዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","ሸምፖራ ደኤይሳት ኡባይ ናምአ ናምአ ግድድ ኖሄኮ ማርካብያን ገልዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","ፆሳይ ኖሄ ኪትዳይሳዳ፥ መተꬃ ኡባፈ አደነ ማጫ ግድድ ማርካብያ ግዶ ገልን ኖሄፐ ጉየራ ጎዳይ ማርካብያ ፐንግያ ጎርድስ። ");
INSERT INTO gofe_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","ꬋዮ ሃꬃይ ኦይታሙ ጋላስ ሳአ ቦላ ቡክሸ ደእስ። ሃꬃይ ዳርድ ማርካብያ ቢታፈ ፑደ ደንꬅስ። ");
INSERT INTO gofe_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","ሃꬃይ ቢታ ቦላ ኬህ ዳርን፥ ማርካበይ ሃꬃ ቦላ ቶከትስ። ");
INSERT INTO gofe_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","ሳሎፐ ጋርሳን ደእያ ዙማት ኡባይ ምተታና ጋካናስ ሃꬃይ ሳአ ቦላ ኬህ ዳርስ። ");
INSERT INTO gofe_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","ሃꬃይ ዙማታ ፄራፐ አꬍድ፥ ታማነ እቻሹ ዋꬋ ጋካናስ ድጭስ። ");
INSERT INTO gofe_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","ያትን ሳአ ቦላ ዎፅ ቃፅያ መተꬃት ኡባይ፥ ካፎት፥ መሄይ፥ ዶእነ፥ አስ ኡባይ ሀይቅስ። ");
INSERT INTO gofe_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","ቢታ ቦላ ደእያ ባ ሲራ ደኦ ሸምፖ ሸምፕያ ኡባይካ ሀይቅስ። ");
INSERT INTO gofe_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","ሳአ ቦላ ደኦይ ደእያ ኡባይ፥ አሳይ፥ መሄይ፥ ዶአይነ ሳሎ ካፎት ኡባይካ ሳአፐ ቁሸትዶሶና። ኖሄይነ እያራ ማርካብያ ግዶን ደኤይሳታ ፃላል አትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","ሄ ሃꬃይ ፓጮና ፄታነ እሻታሙ ጋላስ ሳአ ቦላ ጋምእስ። ");
INSERT INTO gofe_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","ሽን ፆሳይ ኖሄ፥ እያራ ማርካብያ ግዶን ደእያ ዶአ ኡባነ መሄ ኡባ ቆፕድ ሳአ ቦላ ጫርኮ ጫርክስን ሄ ሃꬃይ ዎꬍ ዎꬍ ብስ። ");
INSERT INTO gofe_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","ቃስ ቢታ ግዶን ደእያ ጪሙዋ ፑልቶይነ ሳሎን ደእያ ሃꬃ ማስኮተት ጎርደትዶሶና፤ እራይካ ሳሎን ተቀትስ። ");
INSERT INTO gofe_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","ያንን፥ ሃꬃይ ፄታነ እሻታሙ ጋላስ ጋካናዉ ዎꬍ ዎꬍ ብስ። ");
INSERT INTO gofe_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","ሃꬃይ ዎꬍን ላፑንꬃ አጌናን፥ ታማነ ላፑንꬃ ጋላሳን ማርካበይ አራራተ ዙማታ ቦላ ኡትስ። ");
INSERT INTO gofe_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","ሃꬃይ ታማንꬃ አጌና ጋካናዉ ዎꬍ ዎꬍ ብስ። ታማንꬆ አጌናስ ኮይሮ ጋላስ ዙማታ ፄራት በንትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","ኦይታሙ ጋላሳፐ ጉየ፥ ኖሄይ ባ ኬፅዳ ማርካብያ ማስኮትያ ");
INSERT INTO gofe_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","ዶይድ እስ ቁሮ ካረ የድን ቁሮይ ሃꬃይ ቢታ ቦላፈ መላና ጋካናስ፥ ያነ ሃነ ፕራꬍሸ ጋምእስ። ");
INSERT INTO gofe_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","ቃስ ኖሄይ ሃꬃይ ቢታ ቦላፈ ዎꬍ ዉርዳኮ በአናዉ እስ ሆለ ካረ የድስ። ");
INSERT INTO gofe_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","ሽን ሄ ሆልያ ሃꬃይ ቢታ ኡባ ቦላ ሀእካ ደእያ ግሾ፥ ሸምፕያ በሲ ደማቡኩ። ሄሳ ግሾ ስማዳ፥ ማርካብያኮ ይን፥ ኖሄይ ባ ኩሽያ የድድ፥ ባኮ ማርካብያ ግዶ ኤክስ። ");
INSERT INTO gofe_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","ሄሳፈ ጉየ፥ ላፑን ጋላስ ጋምእድ፥ ሆልዉ ዛሪድ የድስ። ");
INSERT INTO gofe_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","ሄ ሆልያ ሳእ ኦማርስያ ዎደ እያኮ ስማዳ ያሸ ሻማሆ አጫፐ ዱꬅዳ እርፃ ሀይꬅ ባ ዶናን ሳፃ ኤካዳ ያሱ። ያትን፥ ሃꬃይ ቢታ ቦላፈ ዎꬍዳይሳ ኖሄይ ኤርስ። ");
INSERT INTO gofe_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","ቃስ ኖሄይ ሀራ ላፑን ጋላስ ጋምእድ፥ ሄ ሆልዉ ዛሪድ የድስ። ሽን ሄ ሆልያ እያኮ ስማዳ ያቡኩ። ");
INSERT INTO gofe_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","ኖሄይ ኡሱፑን ፄታነ እስ ላይꬅ ደእን፥ ኮይሮ አጌናን ኮይሮ ጋላስ፥ ሃꬃይ ቢታ ቦላፈ ፅዝእስ። ኖሄይ ማርካብያ ካማ ቃር ፄልድ፥ ቢታይ ፅዝእዳይሳ በእስ። ");
INSERT INTO gofe_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","ናምአንꬆ አጌናን ላታማነ ላፑንꬃ ጋላሳን፥ ቢታይ ኩመꬅ መልስ። ");
INSERT INTO gofe_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","ፆሳይ ሄ ዎደ ኖሄ ሀይሳዳ ያግድ ኪትስ፤ ");
INSERT INTO gofe_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“ኔኒ፥ ነ ማችዉ፥ ነ አደ ናይታነ ነ ናይታ ማቸታ ኤካዳ ማርካብያ ግዶፈ ከያ። ");
INSERT INTO gofe_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","ኤንቲ የለትድ፥ ዳራና መላ ደኦይ ደእያ መተꬃ ኡባፈ ኔራ ደኤይሳታ ካፎታ፥ መሄታ፥ ዶአታነ ቢታራ ጎሸትያ ኡባ ኔራ ከሳ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","ያትን ኖሄይ ባ አደ ናይታራ፥ ባ ማቸራነ ባ ናይታ ማቸታራ ማርካብያ ግዶፈ ከይስ። ");
INSERT INTO gofe_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","ያንን፥ መሄይነ ዶአይ፥ ሳአራ ጎሸትያ መተꬃይ፥ ካፎይነ ሳአ ቦላ ዎፅ ቃፅያባ ኡባይ ባ ቆሙዋን ቆሙዋን ማርካብያ ግዶፈ ከይዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","ሄሳፈ ጉየ፥ ኖሄይ ጎዳስ ያርሾ በሲ ግምብድ ቱና ግዶና መሄነ ዶአ ኡባፈ፥ ቱና ግዶና ካፎ ኡባፈ ኤክድ፥ ጊግስዳ በሳን ያርሾ ኦꬅድ ፁግስ። ");
INSERT INTO gofe_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","ያትን፥ ጎዳይ ሄ ያርሹዋ ፔኑዋ ስንግድ፥ ባ ዎዛናን ሀይሳዳ ያግስ፤ “ናአተꬃፈ ዶምድ አስ ዎዛናን ቆፕያባ ኡባይ ኢታ ግድኮካ ታኒ አሳ ቆሆ ግሾ ጋዳ ናምአንꬆ ሀ ሳኣ ባድከ። ቃስ ታኒ ሀእ ኦꬅዳይሳዳ ደኦይ ደእያ መተꬃ ኡባ ናምአንꬆ ꬋይስከ። ");
INSERT INTO gofe_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","ሀ ቢታይ ደእዳ ዎደ ኡባን፥ ዘርያ ዎደይነ ጫክያ ዎደይ፥ ሜጎይነ ሆምበይ፥ ቦነይነ ባልጎይ፥ ጋላስነ ቃም ኡባ ዎደ ዳና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","ፆሳይ ኖሄነ እያ አደ ናይታ ሀይሳዳ ያግድ አንጅስ፤ “የለትተ፥ ዳርተ፥ ሳአ ኡባ ኩምተ። ");
INSERT INTO gofe_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","ሳኣ ዶአት፥ ሳሎ ካፎት፥ ቢታን ዎፅ ቃፅያባይነ አባን ደእያ ሞሎት ኡባይ ህንተዉ ያሻንነ ዳጋማን ደኦ። ኤንቲ ህንተዉ ሃረቶ። ");
INSERT INTO gofe_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","ታኒ ዶልያ ዱማ ዱማ ጭልኦባታ ህንተዉ እምዳይሳዳ፥ ደኦይ ደእያ ዎፅ ቃፅያ መተꬃ ኡባይ ህንተዉ ካꬅ ግዳና መላ እማስ። ");
INSERT INTO gofe_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","ሽን ሸምፖይ ግዶን ደእያ ግሾ ሱꬅ እያ ግዶን ደእያ አሾ ሞፕተ። ");
INSERT INTO gofe_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","ኦንካ ሸምፖ ዎꬍዳይ ፕርደታና። ቃስ አሳ ሱꬅ ጉስያ ዶአካ ሀይቆን ፕርዳና። ");
INSERT INTO gofe_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","ፆሳይ አሰ ባና ዳንስድ መꬍዳ ግሾ፥ አሳ ሱꬅ ጉስያ ኦና ግድኮካ እያ ሱꬃይካ አሳ ኩሸን ጉካና። ");
INSERT INTO gofe_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","ህንተ የለትተ፥ ዳርተ፥ ህንተ ሼሻይካ ሳአ ቦላ ዳሮ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","ሄሳፈ ጉየ፥ ፆሳይ ኖሄነ እያራ ደእያ እያ አደ ናይታ ሀይሳዳ ያግስ፤ ");
INSERT INTO gofe_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“ህዛ፥ ታኒ ታ ጫቁዋ ህንተራ፥ ህንተ ሼሻራነ ደኦይ ደእያ መተꬃ ኡባራ ጫቃይስ። ");
INSERT INTO gofe_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","ታኒ ታ ጫቁዋ ካፎታራ፥ መህያራ፥ ሳአ ዶአ ኡባራነ፥ ማርካብያፐ ህንተራ ከይዳ፥ ደኦይ ደእያ መተꬃ ኡባራ ጫቃይስ። ");
INSERT INTO gofe_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","ታኒ ህንተራ ጫቅዳይሳ መላ ህዛፐ ደኦይ ደእያ መተꬃት ꬋዮ ሃꬃን ꬋዮኮና፤ ሀ ሳኣካ ዛር ꬋዮ ሃꬅ ꬋይሰና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","ቃስካ ፆሳይ፥ “ታኒ ታፐነ ህንተፈ፥ ደኦይ ደእያ መተꬃ ኡባፈ ግዶን ጫቅያ ጫቁዋ ማላይ ሀይሳ፤ ");
INSERT INTO gofe_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","ታኒ ታ ዙላ ሻራን ኤሳስ። እ ታፐነ ሳአ ቦላ ደእያ መተꬃ ግዶን ደእያ ጫቁዋስ ማላ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","ታ ሳሉዋ ሻራ ማይዝዳ ዎደነ ሻራን ዙል ኤቅዳ ዎደ፥ ");
INSERT INTO gofe_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","ታፐነ ህንተፈ ግዶን፥ ደኦይ ደእያ ዱማ ዱማ መተꬃ ኡባፈ ግዶን ጫቅዳ ታ ጫቁዋ አኬካና። ደኦይ ደእያ መተꬃ ኡባ ꬋይሳናዉ ህዛፐ ጉየ ꬋዮ ሃꬅ ዬና። ");
INSERT INTO gofe_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","ዙል ሻራን ኤቅዳ ዎደ ታ እያ በአዳ ታፐነ ሳአ ቦላ ደእያ ዱማ ዱማ መተꬃ ኡባፈ ግዶን ጫቅዳ መርና ጫቁዋ አኬካና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","ፆሳይ ኖሄ፥ “ታኒ ታፐነ ሳአ ቦላ ደኦይ ደእያባ ኡባፈ ግዶን ጫቅዳ ጫቁዋ ማላይ ሀይሳ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","ማርካብያፐ ከይዳ ኖሄ አደ ናይት ሴማ፥ ካማነ ያፈታ፤ ካም ካናነ አዋ። ");
INSERT INTO gofe_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","ሀ ሄꬓት ኖሄ ናይታ፤ ሳአ ኡባን ደእያ አሳይ ኤንታፈ የለትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","ኖሄይ ጎሻንቾ፤ እ ዎይነ ቶከꬃን ኮይሮ አስ። ");
INSERT INTO gofe_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","እስ ጋላስ ኖሄይ ሄ ዎይንያፐ ኡይድ ማꬆትድ ባ ዱንካንያ ግዶን ፅረ ካሎ ዝንእስ። ");
INSERT INTO gofe_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","ካናነ አዋ ካም ባ አዋ ካሉዋ በእድ፥ ካረ ከይድ፥ ባ ናምኡ እሻታስ ኦድስ። ");
INSERT INTO gofe_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","ሽን ሴምነ ያፈት አፍላ ኤክድ፥ ናምአይካ ባንታ ሀሽያራ ሀሽያራ ጋꬅ ኦይክድ፥ ጉየ ጉꬁ ሄመት ገልድ፥ ባንታ አዋ ካሉዋ ካምዶሶና። ኤንቲ ባንታ አዋ ካሉዋ በኦና መላ ባንታ አይፍያ ሀራሶ ዛርዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","ኖሄይ ማꬆይ አꬍን፥ ባርክድ፥ እያ ካሎ ናአይ ኦꬅዳባ ኤርስ። ");
INSERT INTO gofe_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","ኖሄይ እያኮ፥ “ካናነይ ባደትዳባ ግዶ! እ ባ እሻታስ ዉርሰꬃ አይለ ግዶ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","ቃስካ ኖሄይ፥ “ጎዳይ፥ ሴማ ፆሳይ ጋላተቶ! ካናነይ ሴማ አይለ ግዶ፤ ");
INSERT INTO gofe_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","ፆሳይ ያፈታ ቢታ አሶ። ያፈታ ሼሻይ ሴማ ሼሻራ ዎላ ደኦና፤ ካናነይ ያፈታ አይለ ግዶ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","ꬋዮ ሃꬃፈ ጉየ፥ ኖሄይ ሄꬑ ፄታነ እሻታሙ ላይꬅ ደእስ። ");
INSERT INTO gofe_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","ኖሄይ ኡዱፉን ፄታነ እሻታሙ ላይꬅ ደእድ ሀይቅስ። ");
INSERT INTO gofe_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","ኖሄ ናይታ፥ ሴማ፥ ካማነ ያፈታ የለተꬃይ ሀይሳፈ ካልድ ፃፈትዳይሳ። ꬋዮ ሃꬃፈ ጉየ፥ ኤንታዉ አደ ናይት የለትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","ያፈታ አደ ናይት፥ ጎመራ፥ ማጎገ፥ ማዳያ፥ ያዋና፥ ቱባላ፥ ሞሳሀነ ትራሳ። ");
INSERT INTO gofe_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","ጎመራ አደ ናይት፥ አስካናዛ፥ እርፋታነ ቶጋርማ። ");
INSERT INTO gofe_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","ያዋና አደ ናይት፥ ኤልሻ፥ ታርሰሳ፥ ክፅማነ ሮዳ። ");
INSERT INTO gofe_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","ሀይሳቲ ዩሾይ አባን ተቀትዳ ቢታን ደእያ ያፈታ ሼሻታስ ማይዛታ። ኤንቲ ባንታ ቢታን ቢታን፥ ባንታ ዶናን ዶናንነ ባንታ ካዎተꬃን ካዎተꬃን ሻከትድ ደእያ ደረታ። ");
INSERT INTO gofe_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","ካማ አደ ናይት፥ ኩሻ፥ ግብፀ፥ ሊበነ ካናነ። ");
INSERT INTO gofe_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","ኩሻ አደ ናይት፥ ሳባ፥ ሀውላ፥ ሳብታ፥ ራእማነ ሳብታካ። ራእመ አደ ናይት፤ ሳባነ ደዳና። ");
INSERT INTO gofe_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","ኩሽ ናምሩደ የልስ፤ ናምሩደይ ሀ ሳአን ኮይሮ ዎልቃማ ኦላንቾ ግድስ። ");
INSERT INTO gofe_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","ጎዳ ማደን ዎልቃማ ሻንካንቾ ግድስ። አሳይ፥ “ናምሩደዳ ጎዳይ ነና ዎልቃማ ሻንካንቾ ከሶ” ግድ አንጀይ ሄሳ ግሾሳ። ");
INSERT INTO gofe_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","እያ ካዎተꬃስ ኮይሮ ካታማት ሳናኦራ ቢታን ደእያ ባብሎነ፥ ኤረካ፥ አርካዳነ ካልነ። ");
INSERT INTO gofe_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","እ ሄ ቢታፈ አሶረ ብድ፥ ናናወ፥ ረሆቦታነ ካላሀ ኬፅስ። ");
INSERT INTO gofe_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","ቃስ ናናወፐነ ካላሀ ካታማፐ ግዶን ረሴና ኬፅስ። ");
INSERT INTO gofe_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","ምፅራይም፥ ሉደታ፥ አናምመታ፥ ላሀበታ፥ ናፍቱሄታ፥ ");
INSERT INTO gofe_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","ፓትሮሳታነ ፍልስፄመ ኮቻ የልዳ ካስሉሄማታነ ቃፍቶረታ ማይዛ። ");
INSERT INTO gofe_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","ካናነይ ባ ባይራ ናአ ስዶናነ ሄታ የልስ። ");
INSERT INTO gofe_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","ቃስ ካናነ ሼሻት ያቡሰታ፥ አሞረታ፥ ገርገሰታ፥ ");
INSERT INTO gofe_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","ህወታ፥ አርከታ፥ ሲናታ፥ ");
INSERT INTO gofe_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","አርዋደታ፥ ፃማራታነ ሀማታታ የልስ። ሄሳፈ ጉየ፥ ካናነ ሼሻት ዱማ ዱማ በሲ ላለትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","ካናነ ቢታ ዛዋይ ስዶናፐ ዶምድ፥ ጋራራነ ጋዛራ ጋክድ፥ ሶዶመነ ጋሞራ፥ አዳማነ ፃቦይማ ብድ፥ ላሻአ ጋክ ኤቅስ። ");
INSERT INTO gofe_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","ሀይሳቲ ካማ ሼሻታ፤ ኤንታዉ ዱማ ዱማ ዶን፥ ዱማ ዱማ ቢትነ ዱማ ዱማ ካዎተꬅ ደኤስ። ");
INSERT INTO gofe_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","ሴማስ ናይት የለትዶሶና። እ ያፈታስ ባይራ እሻነ ኤቦራ ናይታ ኡባስ ማይዛ። ");
INSERT INTO gofe_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","ሴማ አደ ናይት፥ ኤላማ፥ አሶረ፥ አርፋክሳደ፥ ሉደነ አራመ። ");
INSERT INTO gofe_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","አራመ አደ ናይት፥ ኡፃ፥ ሁላ፥ ገተራነ ማሸካ። ");
INSERT INTO gofe_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","አርፋክሳድ ሳላ የልስ። ሳል ኤቦራ የልስ። ");
INSERT INTO gofe_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","ኤቦራስ ናምኡ አደ ናይት የለትዶሶና። ሳአን ደእያ አሳይ እያ ዎደ ሻከትዳ ግሾ እሱዋ ፐለጋ ግድ ሱንꬅስ። እያ እሻ ሱንꬃይ ዮቅፃና። ");
INSERT INTO gofe_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","ዮቅፃና ሼሻት ሀይሳታ። ኤንትካ አልሞዳዳ፥ ሳለፋ፥ ሀሰርሞታ፥ ያራሀ፥ ");
INSERT INTO gofe_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","ሀዶራማ፥ ኡዛላ፥ ድቅላ፥ ");
INSERT INTO gofe_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","ኦባላ፥ አብማላ፥ ሳባ፥ ");
INSERT INTO gofe_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ኦፍራ፥ ሀውላነ ዮባባ። ሀይሳቲ ኡባይ ዮቅፃና ሼሻታ። ");
INSERT INTO gofe_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","ኤንቲ ደእዳ ሄራይ ሜሳፐ ብድ ዶሎሀ ባጋራ ደእያ ደረይ ዳርያ ሳፋራ ቢታ ጋኬስ። ");
INSERT INTO gofe_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","ሀይሳቲ ኡባይ ሴማ ሼሻታ፤ ኤንታዉ ዱማ ዱማ ዶን፥ ዱማ ዱማ ቢትነ ዱማ ዱማ ካዎተꬅ ደኤስ። ");
INSERT INTO gofe_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","ሀይሳቲ ኡባይ ባንታ ሼሻን ሼሻንነ ባንታ ካዎተꬃን ካዎተꬃን ፃፈትዳ ኖሄ ናይታ። ꬋዮ ሃꬃፈ ጉየ ካዎተꬃት ሀይሳታፐ ሳአ ኡባ ላለትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","ሳአ ቦላ ደእያ አስ ኡባይ ኮይሮ እስ ዶናን ኦደቴስ። ");
INSERT INTO gofe_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","ኤንቲ ዶሎሀ ባጋፈ ደንድድ ብዳ ዎደ ሳናኦራ ቢታን ደምባ በሲ ደምድ ያን ኡትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","ኤንቲ እሶይ እሱዋኮ፥ “ሃ ዪተ፥ ፁበ መꬍድ፥ ምናና መላ ታማን ፁጎስ” ያግዶሶና። ኤንቲ ሹቻ ግሾ ፁበ፥ ኡርቃ ግሾ ማደ መላባ፥ ");
INSERT INTO gofe_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","ኤክድ፥ “ሃ ዪተ፥ ኑ ሱንꬃ ፄግሳናዉነ ቃስ ኑኒ ሀ ሳአ ቦላ ላለቶና አታና መላ እስ ግታ ካታማነ ፄራይ ሳሎ ጋክያ ፖቀ ኬፆስ” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","ሽን ጎዳይ አሳት ኬፅዳ ግታ ካታማነ ፖቅያ በአናዉ ዱገ ዎꬍስ። ");
INSERT INTO gofe_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","ጎዳይ ሀይሳዳ ያግስ፤ “ሄኮ፥ ኤንቲ እስ አስ፤ ኤንቲ ኡባይካ እስ ዶናን ኦደትዶሶና። ኤንቲ ሀእ ሀይሳ ኦꬃናዉ ዶምዶሶና። ኤንቲ ባንታዉ ኦꬃናዉ ሀልችዳባ ፖሎና አጎኮና። ");
INSERT INTO gofe_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","ያንያ ግሾ፥ ሃይተ፤ ዱገ ዎꬍድ ኤንቲ እሶይ ሃሳይያ ዶና እሶይ ኤሮና መላ ኤንታ ዶና ዱማዮስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","ጎዳይ ኤንታ ሄሳፈ ሳአ ኡባ ቦላ ላልን፥ ኤንቲ ካታማ ኬፀይሳ አጋግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","ጎዳይ ሳአን ደእያ አሳ ዶና ያን ቡቅዳ ግሾ ሄ ካታማ ሱንꬃይ ባብሎነ ጌተትስ። ጎዳይ ኤንታ ሄሳፈ ሳአ ኡባ ቦላ ላልስ። ");
INSERT INTO gofe_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","ሴማ የለተꬃይ ሀይሳፈ ካልድ ፃፈትዳይሳ፤ ꬋዮ ሃꬃፈ ጉየ፥ ናምኡ ላይꬅ ግድን፥ ሴማስ ላይꬅ ፄታ ግድዳ ዎደ፥ ሴም አርፋክሳደ የልስ። ");
INSERT INTO gofe_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","ሴም አርፋክሳደ የልዳፐ ጉየ፥ እቻሹ ፄቱ ላይꬅ ደእስ። ሀራ አደ ናይታነ ማጫ ናይታ የልስ። ");
INSERT INTO gofe_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","አርፋክሳድ 35 ላይꬅ ደእድ፥ ሳላሀ የልስ። ");
INSERT INTO gofe_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","አርፋክሳድ ሳላ የልዳፐ ጉየ፥ 403 ላይꬅ ደእስ። ሀራ አደ ናይታነ ማጫ ናይታ የልስ። ");
INSERT INTO gofe_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","ሳል 30 ላይꬅ ደእድ፥ ኤቦራ የልስ። ");
INSERT INTO gofe_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","ሳል ኤቦራ የልዳፐ ጉየ፥ 403 ላይꬅ ደእስ። ሀራ አደ ናይታነ ማጫ ናይታ የልስ። ");
INSERT INTO gofe_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","ኤቦሪ 34 ላይꬅ ደእድ፥ ፐለጋ የልስ። ");
INSERT INTO gofe_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","ኤቦሪ ፐለጋ የልዳፐ ጉየ፥ 430 ላይꬅ ደእስ። ሀራ አደ ናይታነ ማጫ ናይታ የልስ። ");
INSERT INTO gofe_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","ፐለግ 30 ላይꬅ ደእድ፥ ራአ የልስ። ");
INSERT INTO gofe_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","ፐለግ ራአ የልዳፐ ጉየ 209 ላይꬅ ደእስ። ሀራ አደ ናይታነ ማጫ ናይታ የልስ። ");
INSERT INTO gofe_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","ራእ 32 ላይꬅ ደእድ፥ ሳሩጋ የልስ። ");
INSERT INTO gofe_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","ራእ ሳሩጋ የልዳፐ ጉየ፥ 207 ላይꬅ ደእስ። ሀራ አደ ናይታነ ማጫ ናይታ የልስ። ");
INSERT INTO gofe_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","ሳሩግ 30 ላይꬅ ደእድ፥ ናኮራ የልስ። ");
INSERT INTO gofe_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","ሳሩግ ናኮራ የልዳፐ ጉየ፥ 200 ላይꬅ ደእስ። ሀራ አደ ናይታነ ማጫ ናይታ የልስ። ");
INSERT INTO gofe_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","ናኮር 29 ላይꬅ ደእድ፥ ታራ የልስ። ");
INSERT INTO gofe_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","ናኮር ታራ የልዳፐ ጉየ፥ 119 ላይꬅ ደእስ። ሀራ አደ ናይታነ ማጫ ናይታ የልስ። ");
INSERT INTO gofe_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","ታር 70 ላይꬅ ደእድ፥ አብራመ፥ ናኮራነ ሃራነ የልስ። ");
INSERT INTO gofe_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","ታራ የለተꬃይ ሀይሳፈ ካልድ ፃፈትዳይሳ፤ ታሪ አብራመ፥ ናኮራነ ሃራነ የልስ። ያትን ሀራን ሎፀ የልስ። ");
INSERT INTO gofe_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","ሀራን ባ አዋይ ታሪ ፓፃ ደእሽን፥ ባ የለትዳ ካልዳወታ ቢታን፥ ግታ ኡረ ካታማን ሀይቅስ። ");
INSERT INTO gofe_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","አብራመይነ ናኮረይ ናምአይካ ማችዶሶና። አብራመ ማቸ ሱንꬃይ ሶራ። ቃስ ናኮራ ማቸ ሱንꬃይ ምልኮ። ምልካ ሃራና ናእዉ፤ ሃራነይ ምልካነ ዮስካ አዋ። ");
INSERT INTO gofe_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","ሶራ ማይንꬅ ግድዳ ግሾ እዉ ናእ ባዋ። ");
INSERT INTO gofe_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","ታር ባ ናኣ አብራመ፥ ባ ናኣ ሃራነ ናኣ ሎፀነ፥ ባ ናኣ አብራመ ማችዉ ሶራ ኤክድ፥ ካናነ ቢታ ባናዉ ካልዳወታ ካታማ ኡረፐ ደንድስ። ሽን ኤንቲ ካራነ ካታማ ጋክድ ያን ኡትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","ታር 205 ላይꬅ ደእድ ካራነን ሀይቅስ። ");
INSERT INTO gofe_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","ጎዳይ አብራመኮ፥ “ነ ቢታፈ፥ ነ ደርያፐ፥ ነ ሶ አሳፐ፥ ሻከታዳ ታ ነና በሲያ ቢታ ባ። ");
INSERT INTO gofe_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","ታ ነና ዎልቃማ ደረ ኦꬃና፥ ነና ታ አንጃና ነ ሱንꬃ ግታ ከሳና፤ ነ ሀራታስ አንጆ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","ታኒ ነና አንጀይሳታ አንጃና፤ ነና ባደይሳታ ባዳና፥ ቢታ ቦላ ደእያ ደረ ኡባይ ነ ጋሶራ አንጀታና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","ሄሳ ግሾ፥ አብራመይ ፆሳይ እያ ኪትዳይሳዳ ከይስ። ሎፀይ እያራ እስፈ ብስ። አብራመይ ካራነፐ ከይያ ዎደ እያዉ ላይꬅ ላፑን ታማነ እቻሻ። ");
INSERT INTO gofe_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","አብራመይ ባ ማችዉ ሶራ፥ ባ እሻ ናአ ሎፀ፥ ካራነን ደእሸ ሺሽዳ ሻሉዋነ ባ አይለታ ኡባ ኤክድ ካናነ ቢታ ብድ ጋክዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","አብራመይ ሴከማን ደእያ ሞረ ጌተትያ ግታ ምꬃኮ ጋካናዉ ካንꬅድ ብስ። ሄ ዎደ ካናነ አሳት ሄ ቢታን ደኦሶና። ");
INSERT INTO gofe_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","ፆሳይ አብራመስ ያን ቆንጭድ፥ “ሀ ቢታ ታኒ ነ ሼሻስ እማና” ያግስ። እካ ባ ቆንጭዳ ጎዳስ ሄ በሳን ያርሾ በሲ ጊግስስ። ");
INSERT INTO gofe_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","ሄ በሳፈ ደንድድ ቤተለፐ ዶሎሀ ባጋራ ደእያ ዙማኮ ብስ። ያን ቤተለ ዉሎሀ ባጋን፥ ጋየ ዶሎሀ ባጋን አግድ፥ ባ ዱንካንያ ቶክስ፤ ያን ጎዳስ ያርሾ በሲ ጊግስድ ጎዳ ሱንꬃ ፄግስ። ");
INSERT INTO gofe_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","ሄሳፈ ጉየ፥ አብራመይ በሳፈ በሰ አꬍሸ ነገበ ጋክስ። ");
INSERT INTO gofe_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","ሄ ዎደ ካናነ ቢታን ኮሽ ከይስ። ኮሻይ ምንዳ ግሾ ጉꬃ ዎደ ያን ዳናዉ አብራመይ ግብፀ ቢታ ብስ። ");
INSERT INTO gofe_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","ግብፀ ገላናዉ ማትያ ዎደ አብራመይ ባ ማቸ ሶራኮ፥ “ኔኒ ማላ ሎኦ ግደይሳ ታኒ ኤራይስ፤ ");
INSERT INTO gofe_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","ግብፀ አሳት ነና በእድ፥ ‘ሀና እያ ማችዉ’ ያግድ ታና ዎꬍድ ነና አጋጋና። ");
INSERT INTO gofe_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","ሄሳ ግሾ፥ ነ ግሾ ግድ ታዉ ሎኦባ ኦꬃና መላነ ታ ሸምፕያ አታና መላ ‘ታ እያዉ ምቾ’ ያጋ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","አብራመይ ግብፀ ቢታ ጋክዳ መላ ግብፀ አሳት ሶራ ማላ ሎኦ ማጫስ ግዶይሳ በእዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","ግብፀ ፓሮና ሞርናት እዮ በእድ ዳሮ ናሽድ ካዋ ፋሮናስ ኦድዶሶና፥ እዮካ ካዋ ስን ኤፍዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","እ ጋሶን ካዎይ አብራመ ቦንችድ ሞክስ። ጉጅድካ ዶርሳታ፥ ሚዛታ፥ ሀረታ፥ ግማለታ፥ አደ አይለታነ ማጫ አይለታ እያዉ እሚስ። ");
INSERT INTO gofe_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","ሽን ጎዳይ አብራመ ማቸ ሶራ ጋሶን ግብፀ ካዋነ እያ ኬꬃ ጋዶ ሀርገን ሾጭስ። ");
INSERT INTO gofe_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","ሄሳፈ ጉየ፥ ካዎይ አብራመ ፄግስድ፥ “ነ ታ ቦላ ኦꬅዳባይ ሀይስ አይቤ? እያ ነ ማቾ ግደይሳ አይስ ታዉ ኦዳብኪ? ");
INSERT INTO gofe_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","አይስ ታ ምቾ ጋዳ ዎርዶታዲ? ታ እዮ ማቾ ኦꬃዳ ኤካስ፥ ሽን አትስ፤ ነ ማችያ ሀናሹ ኤካ ባ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","ሄሳፈ ጉየ፥ አብራመነ እያ ማችዉ እያዉ ደእያባ ኡባራ ከስ የዳና መላ ካዎይ ባ አሳታ ኪትስ። ");
INSERT INTO gofe_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","አብራመይ ባአ ማቺው ሶራነ ባዉ ደእያባ ኡባ ኤክድ ግብፀፈ ነገበ መላ ቢታ ብስ። ሎፀይካ እያራ ዎላ ብስ። ");
INSERT INTO gofe_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","አብራመይ ሄ ዎደ መሄን፥ ብራንነ ዎርቃን ዳሮ ዱረትስ። ");
INSERT INTO gofe_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","አብራመይ ናገበፐ ደንድድ በሳፈ በሰ አꬍሸ ቤተለ ጋካናዉ ብስ። ቤተለፐነ ጋየፐ ግዶን እ ኮይሮ ዱንካንያ ቶክዳ በሳነ ");
INSERT INTO gofe_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","ጎዳስ ካሰ ያርሾ ያርሽዳ በሳ ጋክድ፥ ያን አብራመይ ጎዳ ሱንꬃ ፄግስ። ");
INSERT INTO gofe_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","አብራመራ ዎላ ሄመትያ ሎፀስካ ዳሮ ዶርሳት፥ ዴሻት፥ መሄት፥ ሶ አሳትነ አይለት ደኦሶና። ");
INSERT INTO gofe_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","ሄ ዎደ አብራመስነ ሎፀስ ዳሮ መሄይ ደእያ ግሾ ኤንቲ ባንታ መሄታ ሄምያ በሳይ ፁምስ። ");
INSERT INTO gofe_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","ሄሳ ግሾ፥ አብራመ መሄታ ሄመይሳታ ግዶንነ ሎፀ መሄታ ሄመይሳታ ግዶን ካች ከይስ። ሄ ዎደ ካናነ አሳትነ ፓርዘ አሳት ሄ ቢታን ደኦሶና። ");
INSERT INTO gofe_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","ሄሳ ግሾ፥ አብራመይ ሎፀኮ፥ “ኑኒ እሻንታ ግድያ ግሾ ኑ ግዶን ዎይኮ ኑ መሄታ ሄመይሳታ ግዶን ካች ዳናዉ በሰና። ");
INSERT INTO gofe_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","ቢታይ ዳልጋ ግድያ ግሾ ኑ ዎልፐ ሻከታና። ነ ሀድርሳ ባጋ ቢኮ ታኒ ኡሻቻ ባጋ ባና፤ ኔኒ ኡሻቻ ባጋ ቢኮ ታኒ ሀድርሳ ባጋ ባና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","ሎፀይ ቢታ ዩይ አꬍድ ፄልያ ዎደ ዮርዳኖሰ ዛንጋራይ፥ ጎዳ ጋናትያዳ ዎይኮ ዞኣረ ባጋራ ደእያ ግብፀ ቢታ መላ ሃꬅ ኩምዳይሳ በእስ። ሄስካ፥ ሀንዳይ ጎዳይ ሶዶመነ ጋሞራ ጌተትያ ካታማታ ꬋይሳናፐ ስን። ");
INSERT INTO gofe_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","ሄሳ ግሾ፥ ሎፀይ ዮርዳኖሰ ዛንጋራ ኡባ ባዉ ዶርድ ዶሎሀ ባጋ ብስ። ሄሳዳ ሀንድ እሶይ እሱዋፈ ሻከትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","አብራመይ ካናነ ቢታን ደእስ። ሽን ሎፀይ ዛንጋራን ደእያ ካታማታ ግዱዋን ሶዶመ ማታን ባ ዱንካንያ ቶክስ። ");
INSERT INTO gofe_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","ሄ ዎደ ሶዶመ አሳይ ዳሮ ኢታነ ጎዳ ስንꬃን ናጋራንቾታ። ");
INSERT INTO gofe_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","ሎፀይ አብራመፐ ሻከትዳፐ ጉየ፥ ጎዳይ አብራመኮ፥ “ነ ደእያ በሳፈ ፑደ ꬎቁ ጋዳ ፑደሀ ባጋነ ዱገሀ ባጋ፥ ዶሎሀ ባጋነ ዉሎሀ ባጋ የዳ ፄላ። ");
INSERT INTO gofe_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","ሄ ኔኒ በእያ ቢታ ኡባ ታኒ መርናዉ ነዉነ ነ ሼሻስ እማና። ");
INSERT INTO gofe_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","ታኒ ነ ሼሻ ቢታ ባናዳ ዳርሳና። ኦንካ ቢታ ባና ታይባናዉ ዳንዳኦናይሳዳ ነ ሼሻይካ ታይበተና። ");
INSERT INTO gofe_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","ታኒ ሀ ቢታ ነዉ እማና ግሾ ደንዳዳ ቢታ አዱሳተꬃንነ ዳልጋተꬃን ስመረታ።” ");
INSERT INTO gofe_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","ሄሳ ግሾ፥ አብራመይ ባ ዱንካንያ ሾድድ ከብሮናን ደእያ ማምረ ግታ ምꬃታ ማታን ደአናዉ ብስ። ያን ጎዳስ ያርሾ በሲ ጊግስስ። ");
INSERT INTO gofe_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","ሳናኦራ ካዎይ አምራፌል፥ ኤልሳረ ካዎይ አርዮክ፥ ኤላማ ካዎይ ኮሎዶጎሞርነ ጎይማ ካዎይ ትዳለይ ኦይዱ ካዎተꬃት ዎላ፥ ");
INSERT INTO gofe_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","እቻሹ ካዎተꬃታራ፥ ሶዶመ ካዋ በራራ፥ ጋሞራ ካዋ በርሳራ፥ አዳማ ካዋ ሰንአበራ፥ ፅቦይማ ካዋ ሳምባራነ ዞኣራ ጌተትያ ቤላ ካዉዋራ ኦለታናዉ ደንድዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","ሀ እቻሹ ካዎተꬃት እስፈ ሺቅድ ማፅነ አባ ጌተትያ ስድማ ዛንጋራን ባንታ ቶራ ሺሽዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","ሀ ካዎተꬃት ታማነ ናምኡ ላይꬅ ኮሎዶጎሞራስ ሃረትዶሶና ሽን ታማነ ሄꬓንꬆ ላይꬃን እያዉ ኪተቶና እፅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","ታማነ ኦይዳንꬆ ላይꬃን ኮሎዶጎሞርነ እያራ ቶቢዳ ካዎተꬃት ባንታ ኦላንቾታ ኤክ ብድ ራፋይመታ አስታሮተን ደእያ ቃርናይማን፥ ዙዛይተታ ሃማን፥ ኤምመታ ሳወን ደእያ ቅራታይማን፤ ");
INSERT INTO gofe_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","ቃስ ሆራ ቢታ አሳታካ ደረይ ዳርያ ሳይረ ቢታን ኦል ፆንድ፥ መላ ቢታ ማታን ደእያ ኤልፋራና ጌተትያ በሳ ጋካናዉ ጎድዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","ያፐ ስሚድ፥ ቃደሳ ጌተትያ አይን ምስፓታ ይዶሶና። አማለቃታ ቢታ ኡባነ ሀዛዞን ታማረን ደእያ አሞረታ ቢታ ኦል ፆንድ ኦይክዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","ሄሳፈ ጉየ፥ ሶዶመ ካዎይ፥ ጋሞራ ካዎይ፥ አዳማ ካዎይ፥ ዘቦይማ ካዎይ፥ ዞኣረ ጌተትያ ቤላ ካዎይ ደንድድ ስድማ ዛንጋራን ኦላስ ጊግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","ሀ እቻሹ ካዎተꬃት፥ ኤላማ ካዋራ፥ ጎይማ ካዋራ፥ ሳናኦራ ካዋራነ ኤልሳረ ካዋራ ሀ ኦይዱ ካዎተꬃታራ ኦለትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","ሄ ዎደ ስድማ ዛንጋራን ማደዳ ኦይክያባት ደእያ ኦላት ደኦሶና። ሶዶመ ካዎይነ ጋሞራ ካዎት ኦላፐ አታናዉ ባቃትሸ ሄ ኦላን ዉልዶሶና። ሽን ሀንኮ ሄꬑ ካዎተꬃት ዙማኮ ባቃትድ አትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","ኦይዱ ካዎተꬃት ሶዶመንነ ጋሞራን ደእያባ ኡባ ሀር አቶሽን፥ ኤንታ ካꬃካ ቦንቅድ ኤፍዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","አብራመ እሻ ናአይ ሎፀይ ሶዶመን ደእያ አስ ግድያ ግሾ እካ ባዉ ደእያባ ኡባራ ድኤትስ። ");
INSERT INTO gofe_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","ሄሳፈ ጉየ፥ ድኤት ብዳ አሳፐ ከስ ኤክዳ እስ አስ ይድ ሀንዳባ ኡባ እብራወ አድያ አብራሃመስ ኦድስ። ሄ ዎደ አብራመይ አሞረ አድያ ማምረ ግታ ምꬃታ ማታን ደኤስ። ማምረይነ እያ እሻት አስኮልነ አኔር ኦላ ዛራናዉ አብራመራ ጫቅድ ኡትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","አብራመይ ባ እሻ ናአይ ድኤትዳይሳ ስእዳ ዎደ ባ ሶን የለት ድጭድ ሎህዳ 318 ቶራንቾታ ኤክድ ኤንታ ገዶ ካልድ ዳነ ካታማ ጋካናዉ ብስ። ");
INSERT INTO gofe_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","እ ባራ ኤክ ብዳ ቶራንቾታ ቃማ ጩጋን ጩጋን ሻክድ ሞርከታ ኦልድ ፆንስ። ዳማስቆፈ ፑደሀ ባጋራ ደእያ ሆበ ጌተትያ በሲ ጋካናዉ ጎድስ። ");
INSERT INTO gofe_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","ያትድ ደኤትዳባ ኡባ፥ ባ እሻ ናአ ሎፀነ እያዉ ደእያባ ኡባ፥ ማጫሳነ ሀራ አሳታ ዎስስ ኤክስ። ");
INSERT INTO gofe_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","አብራመይ ኮሎዶጎሞርነ እያራ ቶቢዳ ካዎታ ፆንድ ስምያ ዎደ ሶዶመ ካዎይ፥ ካዎታ ዛንጋራ ጌተትያ ሳወ ዛንጋራን እያ ሞካናዉ ከይስ። ");
INSERT INTO gofe_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","ኡባፈ ꬎቃ ፆሳ ካህነይ፥ ሳሌማ ካዎይ ማልከፃደቅ ኡይꬅነ ዎይነ ኤክድ ይስ። ");
INSERT INTO gofe_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","እ ሀይሳዳ አብራመ አንጅስ፤ “ሳሎነ ሳአ መꬍዳ፥ ኡባፈ ꬎቃ ፆሳይ ነና አንጆ። ");
INSERT INTO gofe_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","ነ ሞርከታ ነ ኩሸን አꬅድ እምዳ፥ ኡባፈ ꬎቃ ፆሳይ ጋላተቶ” ያግድ አንጅስ። አብራመይ ባ ደምዳባ ኡባፈ አስራታ ከስድ ማልከፃደቃስ እሚስ። ");
INSERT INTO gofe_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","ሶዶመ ካዎይ አብራመኮ፥ “ሻሉዋ ነ ኤካዳ፥ አሳ ታዉ እማ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","ሽን አብራመይ ሶዶመ ካዋኮ፥ “ታኒ ጎዳስ፥ ሳሉዋነ ሳአ መꬍዳ ኡባፈ ꬎቃ ፆሳስ ታ ኩሽያ ደንꬃስ። ");
INSERT INTO gofe_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","ኔኒ፥ ‘አብራመ ዱረ ኦꬅዳይ ታና ጎናዳ’ ሀር አቶሽን ክረ ዎይኮ ጫማ ዎዶሮካ ኤክከ። ");
INSERT INTO gofe_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","ታ አሳት ምዳይሳፈ አትሽን ታ አይብባካ ኤክከ። ቃስ ታራ ብዳ አኔር፥ አስኮልነ ማምረይ ባንታና ጋክያባ ኤኮ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","ሄሳፈ ጉየ፥ ጎዳይ አብራመስ አሙሆን ቆንጭድ፥ “አብራመ ባቦፋ፥ ታኒ ነዉ ጎንዳለ፥ ነ ዎይቶይ ግታ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","ሽን አብራመይ፥ “አቤት ኡባ ሃርያ ጎዳዉ፥ ኔኒ እምያ ዎይቶይ ታዉ አይሴ? ታዉ የሎይ ባዋ፤ ቡሮ ታና ላታናይ ዳማስቆ ኤልአዛራ ግደኔ? ");
INSERT INTO gofe_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","አብራመይ፥ ኔኒ ታዉ የሎ እማቦና ግሾ ታ ኬꬃን ደእያ ታ አይለይ ታና ላታና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","ጎዳይ እያኮ፥ “ሀ አይለይ ነና ላተና፥ ሽን ነ ጉልባታፐ ከያና ነ ናአይ ነና ላታና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","ያግ ስሚድ እያ ካረ ከስድ፥ “ፑደ ሳሎ ፄላ፥ ኔኒ ፆልንቶታ ፓይዳናዉ ዳንዳእኮ ፓይዳ፥ ህዛ ነ ሼሻይካ ሄሳዳ ግዳና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","አብራመይ ጎዳ አማንስ፤ ጎዳይ እያዉ ሄሳ ፅሎተꬅ ኦꬅድ ኤክስ። ");
INSERT INTO gofe_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","ቃስካ ጎዳይ እያኮ፥ “ኔኒ ሀ ቢታ ላታና መላ ካልዳወታ ቢታፈ ኡረ ካታማፐ ነና ከስዳ ጎዳይ ታና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","ሽን አብራመይ እያኮ፥ “አቤት ኡባ ሃርያ ጎዳዉ ሀ ቢታ ታ ላታናይሳ አይብን ኤሮ?” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","ጎዳይ እያኮ፥ “ሄꬑ ላይꬅ ግድዳ እስ ኡስ፥ እስ ዴሽ፥ እስ ዶርሰነ ሄሳዳካ ሆለነ ጎርለ ታዉ ኤካዳ ያ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","አብራመይ ሄሳታ ኡባ ፆሳስ ኤህድ ካፎት አትሽን፥ ሀራታ ቃንፅድ ናምኡ ከስ ሻክድ እሱዋ እሱዋ ግናን ዎꬅስ። ");
INSERT INTO gofe_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","አንኮት ሄ አሹዋ ማናዉ ቦላፈ ዎꬍዶሶና፤ ሽን አብራመይ ኤንታ ጎድስ። ");
INSERT INTO gofe_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","አው ዉላና ሀንያ ዎደ አብራመ ዎልቃማ ꬍስኮይ ሾጭ የግስ። ዳጋንꬅያ ዎልቃማ ꬉም እያ ቦላ ዎꬍስ። ");
INSERT INTO gofe_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","ጎዳይ አብራመኮ፥ “ነ ሼሻይ አላጋ ቢታን በተ አስ ግድድ ዳናይሳ ሎይꬃዳ ኤራ፤ ኤንቲ አይለተꬃን ኦይዱ ፄቱ ላይꬅ ናቀት ሃረታና። ");
INSERT INTO gofe_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","ሽን ኤንታና አይለተꬃን ሃርያ ደርያ ታ ፕርዳና፤ ኤንቲ ሄ ቢታፈ ከይሸ ዳሮ ሻሎ ኤክድ ከያና። ");
INSERT INTO gofe_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","ነና ግድኮ፥ ኔኒ ነ ማይዛታኮ ሳሮተꬃን ባና። ኔኒ ዳሮ ጭማዳ ሞገታና። ");
INSERT INTO gofe_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","ነ ሼሻይ ቡሮ ኦይዳንꬆ የለተꬃን ሀ ቢታ ስማና። አይስ ጊኮ፥ አሞረታ ናጋራይ ፕርደታና ልክያ ቡሮ ጋክቤና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","አው ዉልን ሳእ ꬉማ ልንፅ ግን፥ ጮጨ ታማ ጩይነ ታማ ላጮይ በንትድ ሻከትዳ አሹዋ ግዶራ አꬍስ። ");
INSERT INTO gofe_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","ሄ ጋላስ ጎዳይ አብራመስ፥ “ግብፀ ሻፋፐ ዶምድ ኤፍራፂሳ ሻፋ ጋካናዉ ደእያ ቢታ ኡባ ታኒ ነ ሼሻስ እማና። ");
INSERT INTO gofe_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","ሄ ቢታይ ቄናታ ቢታ፥ ቀነዛታ ቢታ፥ ቃድሞነታ ቢታ፥ ");
INSERT INTO gofe_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","ህተታ ቢታ፥ ፓርዘታ ቢታ፥ ራፋይመታ ቢታ፥ ");
INSERT INTO gofe_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","አሞረታ ቢታ፥ ካናነታ ቢታ፥ ገርገሰታ ቢታነ ያቡሰታ ቢታ” ያግድ ጫቅስ። ");
INSERT INTO gofe_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","አብራመ ማችያ ሶራ እያዉ ናአ የላቡኩ። ሽን እዉ ግብፀፈ ይዳ አጋሮ ጌተትያ ጋꬍንዶይ ደአዉሱ። ");
INSERT INTO gofe_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","ሶራ አብራመኮ፥ “ታኒ ናአ የሎና መላ ጎዳይ ታና የሎ ድግስ። ኔኒ ባዳ ታ አይለራ አቃ፤ ታኒ እ ባጋራ ናአ ደማነኮነ ኦን ኤር” ያጋሱ። አብራመይ እ ቆፋ ኤክስ። ");
INSERT INTO gofe_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","አብራመይ ካናነ ቢታን ታሙ ላይꬅ ደእዳፐ ጉየ፥ እያ ማችያ ሶራ ግብፀፈ ይዳ ባ አይልዉ አጋሮ ባ አዝናስ ማቾ ኦꬃዳ እማሱ። ");
INSERT INTO gofe_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","አብራመይ አጋሮ ኤክስ፥ እያካ ቃንꬃታሱ። እያ ባዉ ቃንꬃትዳይሳ ኤርዳ ዎደ ባ ጎዳትዉ ካꬋሱ። ");
INSERT INTO gofe_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","ሶራ አብራመኮ፥ “ሀ ቆሁዋስ ታና ጋꬅዳይ ነና፤ ታኒ ታ አይልዉ ነዉ እምን፥ እያ ቃንꬃትድይሳ በአዳ ታና ካꬋዉሱ። ነባነ ታባ ጎዳይ ፕርዶ” ያጋሱ። ");
INSERT INTO gofe_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","አብራመይ ሶራኮ፥ “ሀኖ በአ ነ አይልዉ እያ ነ ኩሸና፤ ነና ሎእዳባ ኦꬃ” ያግስ። ሄሳፈ ጉየ፥ ሶራ አጋሮ ኡንኤꬅን ያፐ ከያዳ ባቃታሱ። ");
INSERT INTO gofe_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","ጎዳ ኪታንቾይ አጋሮ መላ ቢታን፥ ፑልቶ ሃꬃ ማታን ደምስ፤ ሄ ፑልቶይ ሹራ ቢታ ኤፍያ ኦግያ ማታን ደኤስ። ");
INSERT INTO gofe_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","ኪታንቾይ አጋሮ፥ “ሶራ አይለተ፥ አጋረ፥ አዉፐ ያዲ? አዉ ባይ?” ያግድ ኦይችስ። አጋራ ዛራዳ፥ “ታኒ ታ ጎዳተ ሶራፐ ባቃታስ” ያጋሱ። ");
INSERT INTO gofe_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","ጎዳ ኪታንቾይ ኢኮ፥ “ነ ጎዳተኮ ስማ ባዳ እዉ ሃረታ” ያግድ ኦድስ። ");
INSERT INTO gofe_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","ጉጅድካ ጎዳ ኪታንቾይ ኢኮ፥ “ነ የለተꬃ ኦንካ ታይባናዉ ዳንዳኦናዳ ኦꬃዳ ዳርሳና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","ቃስካ ጎዳ ኪታንቾይ እዮ፥ “ሄኮ ኔኒ ቃንꬃታዳሳ፥ ኔኒ አደ ናአ የላና። ፆሳይ ነ ዋሱዋ ስእዳ ግሾ እያ ኔኒ እስማኤላ ጋዳ ሱንꬃና ");
INSERT INTO gofe_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","እ ባዞ ሀረ መላ ግዳና፥ እ ባ ቀስያ አሳ ኡባ ቦላ ደንꬃና፥ ቃስ አሳ ኡባይካ ባንታ ቀስያ እያ ቦላ ደንꬃና። እ ባ እሻታ ኡባራ እፆን ደአና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","አጋራ ባራ ኦደትዳ ጎዳ፥ “ኔኒ ታና በእያ ፆሳ” ያጋዳ ፄጋሱ። “ታኒ ታና በኤይሳ በአስ” ያጋሱ። ");
INSERT INTO gofe_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","ሄሳፈ ደንዶይሳን ሄ ፑልቶ ሃꬃይ፥ “ታና በእያ ደኦ ፆሳ ፑልቱዋ” ጌተትድ ፄገትስ። ሄ ሃꬃ ፑልቶይ ቃደሳፐነ ባሬዳፐ ግዶን ደኤስ። ");
INSERT INTO gofe_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","አጋራ አብራመስ አደ ናአ የላሱ፤ አብራመይ የለትዳ ናአ እስማኤላ ግድ ሱንꬅስ። ");
INSERT INTO gofe_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","አጋራ አብራመስ እስማኤላ የልያ ዎደ አብራመስ ላይꬅ ሆስፑን ታማነ ኡሱፑና። ");
INSERT INTO gofe_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","አብራመስ ላይꬅ ኡዱፉን ታማነ ኡዱፉና ግድያ ዎደ፥ ጎዳይ እያዉ ቆንጭድ፥ “ታኒ ኡባ ዳንዳእያ ፆሳ፥ ታዉ ኪተታ፥ ታ ስንꬃን ፖሎ ግዳ። ");
INSERT INTO gofe_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","ታ ግዶንነ ነ ግዶን ደእያ ጫቁዋ ታ ምንꬃና፤ ታኒ ነ ዘረꬃ ታይባናዉ ዳንዳኤቶናዳ ኦꬃና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","አብራመይ ባ ሶምኡዋራ ሳአን ዱገ ጉፋንን ፆሳይ እያኮ፥ ");
INSERT INTO gofe_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“ሄኮ ታ ነዉ ጫቅያ ጫቆይ ሀይሳ፤ ነ ዳሮ ካዎተꬃታስ አዋ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","ታ ነና ዳሮ ካዎተꬃታስ አዋ ኦꬃና ግሾ ህዛፐ ነ ሱንꬃይ አብራመ ግድ ፄገተና፥ ሽን ነ ሱንꬃይ አብራሃመ ግድ ፄገታና። ");
INSERT INTO gofe_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","ታኒ ነ የለተꬃ ዳርሳና፥ ታ ነና ዳሮ ደረ ከሳና፥ ካዎት ኔፐ ከያና። ");
INSERT INTO gofe_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","ታኒ ነዉነ ኔፐ ጉየን ነ ሼሻስ ፆሰ ግዳና መላ መርና ጫቁዋ ታ ግዶንነ ነ ግዶን፥ ኔፐ ጉየራ ያ ነ ሼሻ ግዱዋን፥ የለተꬃፈ የለተꬃ ጋካናስ ታ ጫቃስ። ");
INSERT INTO gofe_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","ኔኒ ሀእ በተ ግዳዳ ደእያ ካናነ ቢታ ኡባ ነዉነ ኔፐ ጉየራ ያ ነ ሼሻስ መርና ላታ ግዳና መላ ነዉ እማና፤ ቃስ ታኒ ኤንታ ፆሳ ግዳና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","ቃስካ ፆሳይ አብራሃመ፥ “ነና ግድኮ ታ ጫቁዋ ናጋ፤ ነካ ኔፐ ጉየራ ያ ነ ሼሻት፥ የለተꬃፈ የለተꬃ ጋካናዉ ናግተ። ");
INSERT INTO gofe_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","ታ ግዱዋንነ ነ ግዱዋን፥ ኔፐ ጉየራ ያ ነ ሼሻ ግዶን ህንተ ናጋና ጫቆይ ሀይሳ፤ ህንተ ግዱዋን ደእያ አደ ኡባይ ቃፃረቶ። ");
INSERT INTO gofe_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","ህንተ አደተꬃ ኮሁዋ ዶካልተ፤ ሄስ ታ ግዶንነ ህንተ ግዶን ደእያ ጫቁዋስ ማላ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","ህዛፐ ያና የለተꬃን አደ ናይት ኡባይ የለትዳ ሆስፑንꬆ ጋላሳን ቃፃረቶ። ነ ሶን የለትዳይሳታ ግድን፥ ዎይኮ አላጋፐ ሚሸን ሻመትዳ አይለታ ግድን፥ ነ ዘረꬃፈ ግዶናይሳታ ዶካላ። ");
INSERT INTO gofe_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","ነ ሶን የለትዳይሳታ ግድን ዎይኮ ሚሸን ሻመትዳይሳት ቃፃረታናዉ በሴስ። ሀይሳን ህንተ አሹዋን ደእያ ታ ጫቆይ መርና ጫቆ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","ኦንካ ቃፃረቶና ደእያ አደ አስ ኡባይ ታ ጫቁዋ መንꬅዳ ግሾ ባ አሳፐ ዱፆ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","ፆሳይ አብራሃመኮ፥ “ህዛፐ ነ ማቸ ሱንꬃይ ሶራ ግድ ፄገቶፎ፤ ሀችፈ ዶምድ እ ሱንꬃይ ሳራ ጌተቶ። ");
INSERT INTO gofe_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","ታኒ እዮ አንጃና፤ ታኒ ኢፐ ነዉ አደ ናአ እማና። ታኒ እዮ አንጃና ግሾ እያ ካዎተꬃታስ አዮ ግዳና፤ ደርያ ካዎት ኢፐ ከያና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","አብራሃመይ ባ ሶምኡዋራ ሳአን ጉፋንድ፥ “ሀይ አሳዉ፥ ፄቱ ላይꬃ አስ ናአ የላኔ? ኡዱፉን ታሙ ላይꬅ ግድዳ ሳርካ ናአ የላኔ?” ያግድ ባ ዎዛናን ሚጭስ። ");
INSERT INTO gofe_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","አብራሃመይ ፆሳኮ፥ “እስማኤል ታና ላታና መላ ነ እያ አንጃርክ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","ሽን ፆሳይ፥ “አካይ፥ ነ ማችያ ሳራ ነዉ አደ ናአ የላና፥ ኔኒ እያ ይሳቃ ጋዳ ሱንꬃና። ታኒ እያፐ ጉየራ ያ እያ ዘረꬃስ መርና ጫቆ ግዳና መላ እያራ ታ ጫቁዋ ጫቃና። ");
INSERT INTO gofe_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","እስማኤላባ ነ ታና ኦይችዳ ኦይሻ ስአስ። ታኒ እያካ አንጃና። ታ እያ አይፍሳና፥ እያ የለተꬃ ሎይꬃ ዳርሳና። እ ታማነ ናምኡ ሃረይሳታስ አዋ ግዳና። ታኒ እያ ግታ ካዎተꬅ ከሳና። ");
INSERT INTO gofe_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","ሽን ታ ጫቁዋ ዎንቶ ላይꬅ ሀኖደ ሳራ ነዉ የልያ ናአ ይሳቃራ ጫቃና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","ፆሳይ አብራሃመራ ኦደትድ ኦንግዳፐ ጉየ እያፐ ሻከትድ ፑደ ብስ። ");
INSERT INTO gofe_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","ሄ ጋላስ አብራሃመይ ባ ናአ እስማኤላ፥ ባ ሶን የለትዳይሳታነ ባ ሚሸን ሻምዳይሳታ፥ ባ ሶን ደእያ አደ አሳ ኡባ ፆሳይ እያ ኪትዳይሳዳ ቃፃርስ ");
INSERT INTO gofe_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","አብራሃመይ ቃፃረትያ ዎደ እያዉ ላይꬅ ኡዱፉን ታማነ ኡዱፉና። ");
INSERT INTO gofe_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","እያ ናአይ እስማኤል ቃፃረትያ ዎደ ታማነ ሄꬑ ላይꬃ ናአ። ");
INSERT INTO gofe_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","አብራሃመይነ እያ ናአ እስማኤል ናምአትካ ሄ ጋላስ ቃፃረትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","አብራሃመ ሶን ደእያ አደ ኡባይ፥ እያ ሶን የለትዳይሳትነ ሚሸን ሻመትዳይሳት ኡባይ እያራ ቃፃረትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","አብራሃመይ ማምረ ግታ ምꬃታ ጋርሳን ባ ዱንካንያ ፐንገን ሴታ ጋላስ ኡትዳሽን ጎዳይ እያዉ ቆንጭስ። ");
INSERT INTO gofe_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","አብራሃመይ ꬎቁ ግድ ፄልያ ዎደ እያ ማታን ኤቅዳ ሄꬑ አሳታ በእስ። እ ኤንታ በእድ ኤንታራ ጋሄታናዉ ባ ዱንካንያ ፐንገፈ ደንድድ ኤንታኮ ዎፅ ብድ ኤንታ ስንꬃን ዝግስ። ");
INSERT INTO gofe_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","ያን ስሚድ፥ “አቤት ታ ጎዳዉ፥ ታ ነ ስንꬃን ሳባ ደምዳባ ግድኮ ታና ነ አይልያ አጋዳ አꬎፋ። ");
INSERT INTO gofe_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","ጉꬃ ሃꬅ ዪኮ ህንተ ቶሆይ ሜጨትኮ ሀ ምꬃ ኩያን ሸምፕ ኤክተ። ");
INSERT INTO gofe_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","ህንተ ታኮ ህንተ አይልያኮ ይዳ ግሾ ፃልድ ህንተ ብያ በሲ ባና መላ ታኒ ህንተዉ ምያባ ኤሀና” ያግስ። ኤንትካ፥ “ዳሮ ሎኦ፥ ነ ግዳይሳዳ ኦꬃ” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","አብራሃመይ ኤለስድ ሳርኮ ዱንካንያ ግዶ ገልድ፥ “ኤለሳዳ ሄꬑ ጋባተ ሎኦ ꬊለ ኤካ ሙኑቃዳ ኡይꬁ ኡካ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","አብራሃመይ ቃስ ባ መሄታ ግዶ ዎፅ ብድ ሎኦ ቡልዱቡልዳ ማራ ዶርድ ባ እስ አይልያስ እምን እ ኤለስድ ሹክድ ጊግስስ። ");
INSERT INTO gofe_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","ያትድ አብራሃመይ መቃ ማꬅነ ጊግስዳ ማራ አሹዋ እማꬃታ ስን አꬅስ፤ ኤንቲ ምሽን እ ምꬃ ጋርሳን ኤንታ ማታን ኤቅስ። ");
INSERT INTO gofe_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","ኤንቲ አብራሃመኮ፥ “ነ ማችያ ሳራ አዉኔ?” ያግድ ኦይችዶሶና። እካ፥ “ህን ዱንካንያ ግዶና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","ጎዳይ እያኮ፥ “ዎንቶ ላይꬅ ሀኖደ ቱማ ታ ኔኮ ስማና፤ ነ ማችያ ሳራ አደ ናአ የላና” ያግስ። ሳራ ሄ ዎደ እያፐ ጉየ ባጋራ ደእያ ዱንካንያ ፐንገን ኤቃዳ ሄሳ ስአዉሱ። ");
INSERT INTO gofe_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","አብራሃመይነ ሳር ባንታ ላይꬃን ዳሮ ጭምዶሶና። ሳራ ናአ የልያ ዎደፐ አꬋሱ። ");
INSERT INTO gofe_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","ሄሳ ግሾ፥ ሳራ ባ ዎዛናን፥ “ታንነ ታ ጎዳይ ናምአይካ ጭምዳፐ ጉየ ዋንድ ሀ ኡፋይሳይ ሀናኔ?” ያጋዳ ሚጫሱ። ");
INSERT INTO gofe_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","ጎዳይ አብራሃመኮ፥ “ ‘ታኒ ጭምዳፐ ጉየ ናአ የላነ’ ጋዳ ሳራ አይስ ሚጫይ? ");
INSERT INTO gofe_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","ጎዳስ ዳንዳኤቶናባይ ቱማ ደእዬ? ታ ነዉ ግዳይሳዳ ዎንቶ ላይꬅ ሀኖደ ታ ስማዳ ያና፤ ሄ ዎደ ሳራ አደ ናአ የላና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","ሳራ ያሸትዳ ግሾ፥ “ታኒ ሚጫብከ” ጋዳ ላሀሱ። ሽን እ፥ “ነ ቱማ ሚጫዳሳ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","አሳት ባናዉ ደንድሸ ሶዶመ ዱገ ፄልዶሶና። አብራሃመይ ኤንታና ሞይዛናዉ ኤንታራ ከይስ። ");
INSERT INTO gofe_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","ፆሳይ እያኮ፥ “ታ ኦꬃናዉ ሀንያባ አብራሃመፐ ቆሳነዬ? ");
INSERT INTO gofe_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","አብራሃመይ ቱማ ግታነ ዎልቃማ ካዎተꬅ ግዳና። ሀ ቢታ ካዎተꬃት ኡባይ እያን አንጀታና። ");
INSERT INTO gofe_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","ፅሎተꬅነ ሱረ ፕርዳ ኦꬅድ ጎዳ ኦግያ ናጋና መላ ባ ናይታነ እያፐ ጉየራ ያ ባ ሶ አሳ ዞራና መላ ታኒ እያ ዶራስ። ሄስካ፥ ፆሳይ አብራሃመስ እማና ግዳ ኡፋይሳ ፖላናሳ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","ጎዳይ አብራሃመኮ፥ “ሶዶመ ቦላነ ጋሞራ ቦላ ዋስያ ዋሶይ ዳርስ፤ ኤንታ ናጋራይካ ዳሮ ዴፅስ። ");
INSERT INTO gofe_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","ሄሳ ግሾ፥ ኤንታ ኦሶይ ኤንታ ዋሱዋ መለኮ በአናዉ ታኒ ዱገ ዎꬋና፤ ቃስ ሄሳ መላ ኢታ ግዶናኮ ሻካ ኤራና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","ሄሳፈ ጉየ፥ ናምኡ አሳት ሶዶመኮ ስሚድ ብዶሶና፥ ሽን አብራሃመይ ጎዳ ስንꬃን ኤቅዳሱዋን ደኤስ። ");
INSERT INTO gofe_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","አብራሃመይ ጎዳኮ ሺቅድ፥ “ቱማ ኔኒ ፅሎታ ኢታታራ እስፈ ꬋይሳኔ? ");
INSERT INTO gofe_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","ሄ ካታመን እሻታሙ ፅሎ አሳት ደእኮ ነ ꬋይሳኔ? ያን ደእያ እሻታሙ ፅሎ አሳታ ግሾ ሄ ካታማ አሽኪ? ");
INSERT INTO gofe_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","ሄሳ መላ ኦሶይ ኔፐ ሃኮ፤ ፅሉዋ ኢታራ ዎል ጋꬃዳ ዎይስ፥ ፅሉዋነ ኢታ እስ አይፍያን ፄለይስ ኔፐ ሃኮ። ሀ ቢታ ኡባ ፕርድያ ኔኒ ፅሎ ፕርድኪ?” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","ጎዳይ፥ “ታ ሶዶመን እሻታሙ ፅሎታ ደምያኮ ሄ በሳ ኡባ ኤንታ ግሾ ጋዳ አሻና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","አብራሃመይ ዛሪድ፥ “ታኒ ቢታነ ብዶ ግዳዳ ታ ጎዳራ ኦደታናዉ ምነታክቻስ፤ ");
INSERT INTO gofe_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","እሻታሙ ፅሎታፐ እቻሻት ፓጭኮቺ? ኔኒ ሄ እቻሻታ ግሾ ጋዳ ሄ ካታማ ኡባ ꬋይሳነዬ?” ያግስ። ጎዳይ፥ “ታኒ ኦይታማነ እቻሹ ፅሎታ ደምኮ ሄ ካታማ ꬋይስከ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","አብራሃመይ ዛሪድ፥ “ያን ኦይታሙ ፃላል ደእኮቺ?” ያግስ። እካ፥ “ኦይታማታ ግሾ ጋዳ ሄ ካታማ ꬋይስከ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","ቃስካ አብራሃመይ ዛሪድ፥ “ሀይ ታ ጎዳዉ፥ ታና ሀንቀቶፋ፥ ታኒ ጉጃዳካ ኦደታና። ሀስታሙ ፃላል ደእኮቺ?” ያግስ። ጎዳይ ዛሪድ፥ “ታኒ ያን ሀስታሙ ደምኮ ꬋይስከ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","አብራሃመይ፥ “ታኒ ጎዳራ ኦደታናዉ ምነታክቻስ፤ ኦን ኤር ያን ላታሙ ፃላል ደእኮች” ያግስ። ጎዳይካ፥ “ሄ ላታማታ ግሾ ጋዳ ꬋይስከ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","አብራሃመይ ቃስካ፥ “ሀይ ታ ጎዳዉ፥ ታና ሀንቀቶፋ ታ እስ ቶሆ ኦደታና፥ ያን ታሙ ፃላላ ደምኮቺ?” ያግስ። እካ፥ “ታማታ ግሾ ጋዳ ታኒ ሄ ካታማ ꬋይስከ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","ጎዳይ አብራሃመራ ኦደትድ ኦንግዳፐ ጉየ ብስ፤ አብራሃመይካ ባ ሶ ስምስ። ");
INSERT INTO gofe_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","ናምኡ ኪታንቾት ኦማርስሽን ሶዶመ ካታማ ጋክዶሶና። ሄ ዎደ ሎፀይ ሄ ካታማ ፐንገን ኡትስ። ሎፀይ ኤንታ በእድ ሞካናዉ ደንድድ ኤንታኮ ብስ። ባ ሶምኡዋ ሳአ ጋꬅድ ኤንታዉ ዝግስ። ");
INSERT INTO gofe_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","እ ኤንታኮ፥ “ታ ጎዳቶ፥ ህንተ አይልያ ሶ ገለርከት፥ ህንተ ቶሁዋ ሜጨትድ ቃማ ሀይሳን አቅተ፤ ዎንታ ጉራ ህንተ ብያ በሲ ቢተ” ያግስ። ኤንቲ፥ “አካይ፥ ኑኒ ሀ ካታማ ዳባባን አቃና” ያግድ ዛርዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","ሽን እ ኤንታ ምንꬅ ዎስዳ ግሾ ብድ እያ ሶ ገልዶሶና። እ ኤንታዉ ኡይꬅ ኡክድ አꬅን ምዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","ኤንቲ ዝንአና ሀንሽን ሶዶመ ካታማ አደ አሳ ኡባይ ናአተꬅነ ዶንꬒ እሶይካ አቶና ይድ ኬꬃ ዩይ አꬍዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","ኤንቲ ሎፀ ፄግድ፥ “ሀች ኦማርስ ነ ሶ ገልዳ አደ አሳት አዉን ደኦና? ኑኒ ኤንታራ ጋሄታና መላ ኤንታ ኑኮ ካረ ከሳ” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","ያትን ሎፀይ ኤንታራ ኦደታናዉ ካረ ከይሸ ፐንግያ ጉየራ ጎርድድ፥ ");
INSERT INTO gofe_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","ኤንታኮ፥ “ታ ዳቦቶ፥ ሀያና ሀ ኢታ ኦሱዋ ኦꬆፍተ። ");
INSERT INTO gofe_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","ታዉ አደ ኤሮና ናምኡ ጌላኦት ደኦሶና። ታኒ ኤንታ ህንተዉ ካረ ከስኮ ህንተ ኮይዳባ ኦꬅተ። ሽን ሀይሳቲ ታ እማ ግድያ ግሾ ታ ካራፐ ጋርሳን ደኦሶና፤ ሀ አሳታ ቦላ አይብባካ ኦꬆፍተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","አሳት፥ “ኑ ስንꬃፈ ገደ ክቻ” ያግዶሶና። ቃስ፥ “ሀ አደይ ባዉ በተ አስ ሽን፥ ኑ ቦላ ፕርዳናዉ ኮዬስ? ኑኒ ኤንታ ቦላ ኦꬃናዉ ኮይዳ ኢታፐ አꬅድ ነ ቦላ ኦꬃና” ያግዶሶና። ኤንቲ ሎፀ ጉየ ሱግ የግድ ፐንግያ መንꬃናዉ ሺቅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","ሽን ናምኡ አሳት ባንታ ኩሽያ ካረ የድድ ሎፀ ሶ ጎች ገልስድ ፐንግያ ጎርድዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","ሄሳፈ ጉየ፥ ኤንቲ ኬꬃ ፐንገይ ደእያሱዋ ደሞና መላ ጉꬃፈ ግታ ጋካናዉ ቆቅስዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","ሄ ናምኡ አሳት ሎፀኮ፥ “ነዉ ሀይሳን አደ ናእ ዎይኮ ማጫ ናእ፥ ነ ማጫ ናይታ ኦይችዳይ ዎይኮ ሀራ ዳቦይ ሀ ካታማን ደኢ? ደእኮ ኤንታና ሀይሳፈ ከሳ። ");
INSERT INTO gofe_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","አይስ ጊኮ፥ ኑ ሀ ካታማ ꬋይሳናዉ ሀኖስ። ኤንታ ቦላ ዋስያ ዋሶይ ጎዳ ስንꬃን ግታ ግድያ ግሾ ሀ ካታማ ꬋይሳና መላ ጎዳይ ኑና ኪትስ” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","ያትን ሎፀይ ባ ማጫ ናይታ ኦይችዳይሳታኮ ብድ፥ “ጎዳይ፥ ሀ ካታማ ꬋይሳና ሀንያ ግሾ ኤለስድ ሀ በሳፈ ከይተ” ያግስ። ሽን እያ ማጫ ናይታ ኦይችዳይሳት እ ቀልቅሴስ ግድ ቆፕዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","ሳእ ዎንታናዉ ጎንተይ ዞእያ ዎደ ሄ ኪታንቾት ሎፀኮ፥ “ደንዳ፥ ነ ማችዉነ ሀይሳን ደእያ ነ ናምኡ ናይታ ኤካዳ ኤለሳዳ ከያ። አካይ ጊኮ፥ ሀ ካታማይ ፕርደትያ ዎደ ነካ ꬋያሳ” ያግ ድርግስዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","ሽን ሎፀይ ከያናዉ ጋምእን፥ ጎዳይ እያዉ ቃትዳ ግሾ፥ ሄ ኪታንቾት እያ ኩሽያ፥ እያ ማቸ ኩሽያነ ናምኡ ናይታ ኩሽያ ኦይክድ ሄ ካታማፐ ከስዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","ኪታንቾት ኤንታ ከስዳ መላ ሄ ኪታንቾታፐ እሶይ፥ “ህንተ ሸምፑዋ ኤክድ ባቃትተ! ጉየ ፄሎፍተ! ሀ ሄራን አዉንካ ኤቆፍተ! ህንተ ꬋዮና መላ ዙማኮ ባቃትተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","ሽን ሎፀይ ኤንታኮ፥ “ሀይ ታ ጎዳቶ፥ ያጎፕተ። ");
INSERT INTO gofe_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","ታኒ ህንተ አይለይ ህንተ ስንꬃን ሳባ ደምዳ ግሾ ታና አሻናዉ ታዉ ዳሮ ቃትደታ። ሽን ታኒ ዙማኮ ባቃታናዉ ዳንዳእከ፤ ሀ ꬋዮይ ጋክድ ታና ꬋይሳና። ");
INSERT INTO gofe_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","ሄኮ፥ ሀይሳን እስ ካታም ደኤስ፤ ያ ዎፅድ ባናዉ ማታነ ጉꬃ ካታማ። ታ ሸምፑዋ አሻናዉ ታ ያ ባቃቶ? እ ዳሮ ጉꬃ ካታማ ግደኔ?” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","ኪታንቾይ፥ “ሎኦ! ታኒ ነ ዎሳ ኤካስ፤ ሄ ነ ኦድዳ ካታማ ꬋይስከ። ");
INSERT INTO gofe_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","ሄ ካታማኮ ኤለሳዳ ባቃታ፤ ነ ያ ጋካናዉ ታ አይብባካ ኦꬅከ” ያግስ። ሄሳ ግሾ፥ ሄ ካታማ ሱንꬃይ ዞኣረ ጌተትስ። ");
INSERT INTO gofe_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","ሎፀይ ዞኣረ ጋክያ ዎደ ቡሮ ፃልቀይ ጫረስ። ");
INSERT INTO gofe_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","ጎዳይ ሄ ዎደ ሳሎፐ ታማነ ፁግያ ዲነ ሶዶመ ቦላነ ጋሞራ ቦላ ቡክስስ። ");
INSERT INTO gofe_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","ሄሳዳ ኦꬅድ ጎዳይ ሄ ካታማታ፥ ሄራ ኡባ፥ ካታማታን ደእያባ ኡባ ሄ ቢታን ደእያ ምꬃነ ማታ ꬋይስስ። ");
INSERT INTO gofe_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","ሽን ሎፀ ማችያ ጉየ ስማ ፄላዳ ማፅነ ሹቹ ግዳሱ። ");
INSERT INTO gofe_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","ዎንተꬃ ጋላስ ዎንታ ጉራ አብራሃመይ ደንድድ ካሰ እ ጎዳ ስንꬃን ኤቅዳ በሳ ብስ። ");
INSERT INTO gofe_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","እ ሶዶመነ ጋሞራ፥ ሄ ሄራን ደእያ ቢታ ኡባ ዱገ ፄልያ ዎደ ፁሳ ታማዳ ጩያይ ቢታፈ ደንደይሳ በእስ። ");
INSERT INTO gofe_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","ፆሳይ ሄ ሄራን ደእያ ካታማታ ꬋይስያ ዎደ አብራሃመ ቆፕድ፥ ሎፀይ ደእያ ካታማታ ꬋይስድ፥ ሎፀ ꬋዮፐ አሽስ። ");
INSERT INTO gofe_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","ሎፀይ ዞኣረን ዳናዉ ያሸትዳ ግሾ፥ ያፐ ደንድድ ባ ማጫ ናይታ ናምአታራ ዙማ ቦላ ከይስ። ያን ጎንጎሎ ግዶን ባ ናምኡ ማጫ ናይታራ ደእስ። ");
INSERT INTO gofe_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","እስ ጋላስ ባይራ ናእያ ባ ካሎ ምቸኮ፥ “ኑ አዋይ ጭምስ፥ ቢታ ኡባን ደእያ ዎጋꬆ ኑራ አቃናዉ እስ አደይ ሀይሳን ባዋ። ");
INSERT INTO gofe_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","ያንያ ግሾ፥ ሃያ! ኑ አዋ ኡሹ ኡሽድ፥ እያራ አቅድ፥ ኑ አዋፐ ኑስ ኮቸ አሾስ” ያጋሱ። ");
INSERT INTO gofe_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","ሄ ዎደ ቃማ ባንታ አዋ ኡሹ ኡሽዶሶና። ባይራ ናእያ ገላዳ እያራ አቃሱ። እያ እያራ አቅያ ዎደነ ደንድያ ዎደ እ ኤርቤና። ");
INSERT INTO gofe_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","ዎንተꬃ ዎደ ባይርያ ካልዉ፥ “ዝነ ቃማ ታኒ ታ አዋራ አቃስ፤ ሀች ቃማካ እያ ኡሹ ኡሽኮ፥ ነካ ገላዳ እያራ አቃ። ያትድ ኑኒ ኑ አዋፐ ኮቸ አሾስ” ያጋሱ። ");
INSERT INTO gofe_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","ሄ ዎደ ቃማ ባንታ አዋ ኡሹ ኡሽዶሶና። ካሎ ናእያ ገላዳ እያራ አቃሱ። ሀእካ እያ እያራ አቅያ ዎደነ ደንድያ ዎደ እ ኤርቤና። ");
INSERT INTO gofe_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","ያትድ ሎፀ ማጫ ናይት ናምአይ ባንታ አዋፐ ቃንꬃትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","ባይርያ አደ ናአ የላሱ፤ እያ ሱንꬃ ሞአበ ጋዳ ሱንꬃሱ። እ ሀች ጋካናዉ ሞአበታ ማይዛ። ");
INSERT INTO gofe_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","ካልያካ አደ ናአ የላሱ፤ እያ ሱንꬃ በንኣማ ጋዳ ሱንꬃሱ። እ ሀች ጋካናዉ አሞነታ ማይዛ። ");
INSERT INTO gofe_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","አብራሃመይ ማምረፐ ደንድድ ነገበ መላ ቢታ ሄራ ብድ ቃደሳፐነ ሹራ ቢታታስ ግዱዋን ደእስ። ገራራንካ ጉꬃ ዎደ ጋምእስ። ");
INSERT INTO gofe_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","ያን ደእሸ አብራሃመይ ባ ማችዉ ሳሮ፥ “እያ ታ ምችዉ” ያግዳ ግሾ፥ ገራራ ካዎይ አብመለከይ ኪትድ ሳሮ ባኮ ኤፍስ። ");
INSERT INTO gofe_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","ሽን ፆሳይ እስ ቃማ አሙሆን አብመለከኮ ይድ፥ “ኔኒ ኤህዳ ማጫሰ ጋሶን ሀይቃሳ፥ እያ አዝናራ ደአዉሱ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","ሀኖሽን፥ አብመለከይ እዮ ቦችቤና። እ፥ “ጎዳዉ፥ ኔኒ ታናነ ታ ደረይ ቆሆና ደእሽን ጮ ꬋይሳነዬ? ");
INSERT INTO gofe_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","እ፥ ‘እያ፥ ታ ምቾ’ ግቤኔ? ቃስ እያካ፥ ‘እ፥ ታ እሻ’ ጋብኬ? ታኒ ታ ዎዛና ፅሎተꬃንነ ታ ኩሸ ጌሻተꬃን ሀይሳ ኦꬃስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","ፆሳይ አሙሆን እያኮ፥ “ኤ፥ ኔኒ ነ ዎዛና ፅሎተꬃን ኦꬅዳይሳ ታ ኤራይስ። ሄሳ ግሾ፥ ኔኒ እዮ ቦቾናዳነ ታ ስንꬃን ናጋራ ኦꬆናዳ ነና ታኒ ተቃስ። ");
INSERT INTO gofe_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","ሀእ ሀ አድያ ማችዉ ዛራ። እ ናበ ግድያ ግሾ፥ ነዉ ፆሳ ዎስኮ ነ አታና። ሽን እዮ ዛሮና እፅኮ፥ ኔንነ ነዉ ደእያባ ኡባይ ሀይቃናይሳ ኤራ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","አብመለከይ ዎንተꬃ ጋላስ ዳሮ ጉራ ባ ሞርናታ ባኮ ፄግስ። ሄ ሀንዳባ ኡባ ኤንታዉ ኦድን ኤንቲ ዳሮ ባብዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","ያትን አብመለከይ አብራሃመ ፄግድ፥ “ኔኒ አይብባ ኑ ቦላ ኦꬃዲ? ነ ታ ቦላነ ታ ካዎተꬃ ቦላ ሀይሳ መላ ቆሆ ኤሀናዉ ታ ነዉ አይ ኢታባ ኦꬃድና? ኔኒ ታ ቦላ ኦሰታናዉ በሶናባ ኦꬃዳሳ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","ቃስ አብመለከይ አብራሃመ፥ “ኔኒ ሀይሳ አይስ ኦꬃዲ?” ያግድ ኦይችስ። ");
INSERT INTO gofe_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","አብራሃመይ ዛሪድ፥ “ ‘ሀ በሳን ፆሳስ ያሸትያ አስ ባይና ግሾነ ቃስ ታ ማቸ ጋሶን ኤንቲ ታና ዎꬋና’ ጋዳ ቆፕዳ ግሾሳ። ");
INSERT INTO gofe_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","ሄሳ ቦላ እያ ቱማካ ታ ምቾ፤ እያ ታ አዋ ናአፐ አትሽን ታ አየ ናአ ግዱኩ፥ ያንያ ግሾ፥ እያ ታ ማቾ ግዳሱ። ");
INSERT INTO gofe_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","ፆሳይ ታና ታ አዋ ኬꬃፈ ከስዳ ዎደ ታኒ ኢኮ፥ ‘ኔኒ ብዳ ቢታ ኡባን ነ ታዉ ኦꬃና ኬሀተꬃይ ሀይሳ፤ “እ ታ እሻ” ጋዳ’ ኦዳ ያጋስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","ሄሳፈ ጉየ፥ አብመለከይ ዶርሰ፥ መሄ፥ ማጫ አይለታነ አደ አይለታ ከስድ አብራሃመስ እሚስ፤ እያ ማችዉ ሳሮ እያዉ ዛርስ። ");
INSERT INTO gofe_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","አብመለከይ አብራሃመኮ፥ “ሄኮ፥ ታ ቢታይ ሀይስሽ ነና ሎኦሶን ደአ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","ሳርኮ፥ “ታኒ ነ እሻስ እስ ሙኩሉ ብራ ሳንትመ እማይስ። ሄስ ኔራ ደእያ ኡባ ስንꬃን ኔኒ ፅሎ ግደይሳነ አይብ ኢታባካ ኦꬆናይሳ ኤርሰይሳ ግዶ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","ጎዳይ አብራሃመ ማቸ ሳር ጋሶን አብመለከ ኬꬃ ኡባ ማይንስዳ ግሾ አብራሃመይ ፆሳ ዎስን፥ አብመለከይ፥ እያ ማችያነ እያ ማጫ አይለት ናአ የላና መላ ፆሳይ ኤንታ ፓꬅስ። ");
INSERT INTO gofe_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","ጎዳይ ባ ኦድዳይሳዳ ሳሮ አንጅስ፤ ባ ገልዳ ቃላካ ፖልስ። ");
INSERT INTO gofe_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","ሳራ ቃንꬃታዳ ፆሳይ ግዳ ዎደይ ጋክን ጭምዳ አብራሃመስ አደ ናአ የላሱ። ");
INSERT INTO gofe_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","አብራሃመይ ሳራ የልዳ ናአ ሱንꬃ ይሳቃ ግድ ሱንꬅስ። ");
INSERT INTO gofe_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","አብራሃመይ ባ ናአ ይሳቃ ፆሳይ ኪትዳይሳዳ የለትዳ ሆስፑንꬆ ጋላሳን ቃፃርስ። ");
INSERT INTO gofe_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","እያ ናአ ይሳቅ የለትያ ዎደ፥ አብራሃመስ ላይꬅ ፄታ። ");
INSERT INTO gofe_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","ሳራ፥ “ፆሳይ ታዉ ሚቸ እሚስ፤ ቃስ ሀይሳ ስእያ ኡባይ ታራ ሚጫና” ያጋሱ። ");
INSERT INTO gofe_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","ቃስካ ሳራ፥ “ሳራ አብራሃመስ ናአ የላዳ ꬋንꬃና ግዳይ ኦኔ? ግድኮካ ታኒ ሀእ እያዉ እ ጭምዳ ዎደ ናአ የላስ” ያጋሱ። ");
INSERT INTO gofe_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","ጉꬃ ናአይ ድጭድ፤ ꬋንꬅ ዱꬅስ፤ አብራሃመይ ይሳቅ ꬋንꬅ ዱꬅዳ ጋላስ ዎልቃማ ግብራ ጊግስስ። ");
INSERT INTO gofe_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","ሽን ግብፀፈ ይዳ አጋራ አብራሃመስ የልዳ ናአይ ይሳቃ ቶችሽን ሳራ በአሱ። ");
INSERT INTO gofe_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","ሳራ አብራሃመኮ፥ “ሀ አይለ ናአይ ታ ናአ ይሳቃራ ኡባካ ላቶና ግሾ፥ ጋꬍንድዉነ እ ናኣ ከሳዳ ጎዳ” ያጋሱ። ");
INSERT INTO gofe_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","ሄ ኦዳይ ባ ናአ ቦችያ ግሾ፥ አብራሃመይ ዳሮ መቶትስ። ");
INSERT INTO gofe_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","ሽን ፆሳይ አብራሃመ፥ “ነ ኮቻይ ይሳቃ ባጋራ ፄገታና ግሾ ነ ናኣስነ ነ አይሌስ ዳሮ መቶቶፓ፤ ሳራ ነዉ ኦድያባ ኡባ ስአ። ");
INSERT INTO gofe_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","ቃስ እካ ነ ኮቸ ግድያ ግሾ አይለ ናአ ታኒ ግታ ደረ ኦꬃና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","ዎንታ ጉራ አብራሃመይ ደንድድ ጉꬃ ካነ ኮዳን ሃ ኩንꬅድ፥ አጋሮ ቶስድ፥ እ ናአ እዮ እድንꬅድ ከስ ጎድስ። እያ ባዳ፥ በርሳበ መላ ቢታን ዳቡራሱ። ");
INSERT INTO gofe_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","16","ሃꬃይ ኮዳፈ ዉርዳ ዎደ እያ፥ “ናአይ ሀይቅሽን፥ ኡታዳ በእከ” ጋዳ፥ ናአ እስ ቡረ ጋርሳን የጋዳ፥ ናምኡ ፄቱ ዋꬋ ግደይሳ መላ ባዳ ኡታ አጋሱ። ያን ኡታዳ፥ ባ ቃላ ꬎቁ ኦꬃዳ ዬካሱ። ");
INSERT INTO gofe_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","ፆሳይ ናአ ዋሱዋ ስእስ። ፆሳ ኪታንቾይ አጋሮ ሳሎፐ ፄግድ፥ “አጋረ፥ ዋናዲ? ፆሳይ ናአ ዬሁዋ ስእዳ ግሾ ባቦፋ፤ ");
INSERT INTO gofe_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","ዳንዳ ኤቃዳ፥ ናአ ደንꬃዳ ነ ኩሽያን ኦይካ፤ ታኒ እያ ግታ ደረ ኦꬃና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","ፆሳይ እዮ ሃꬃ ኦላ በስን፥ ባዳ ኮዳን ሃ ኩንꬃዳ ናኣ ኡሻሱ። ");
INSERT INTO gofe_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","ናአይ ድጭያ ዎደ ኡባን ፆሳይ እያራ ግድስ። እ መላ ቢታን ደእድ፥ ዶንገን ዱክያ አሰ ግድስ። ");
INSERT INTO gofe_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","እ ፓራና መላ ቢታን ደእሽን፥ እያ አይያ ግብፀፈ እያዉ ማቾ እማሱ። ");
INSERT INTO gofe_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","ሄ ዎደ፥ አብመለከይ፥ ባ ቶራ ሞጮና ፍኮላራ አብራሃመኮ ብድ፥ “ኔኒ ኦꬅያባ ኡባን ፆሳይ ኔራ ደኤስ። ");
INSERT INTO gofe_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","ኔኒ ታ ቦላ ዎይኮ ታ ናይታ ቦላ ዎይኮ ታ ዘረꬃ ቦላ ጭማዳ ገነ ኦꬆና መላ፥ ሀእ ሀይሳን፥ ፆሳ ስንꬃን ታዉ ጫቃ። ታኒ ነዉ ኬህዳይሳዳ፥ ኔንካ ታስነ ኔኒ በተተꬃን ደእዳ ሀ ቢቴስ ኬሀ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","አብራሃመይ፥ “ታኒ ጫቃይስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","ሄ ዎደ፥ አብራሃመይ፥ አብመለከ አይለት ኤክዳ ሃꬃ ኦላባ አብመለከስ ማጋንስ። ");
INSERT INTO gofe_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","ሽን አብመለከይ፥ “ሄሳ ኦን ኦꬅዳኮ ታኒ ኤርከ። ኔንካ ቃስ ታዉ ኦዳባካ፤ ታኒ ሀች ጋካናዉ ሄሳ ስአብከ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","ሄሳፈ ጉየ፥ አብራሃመይ ዶርሳታነ ሚዛታ ኤህድ፥ አብመለከስ እምን፥ ኤንቲ ናምአይ ጫቅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","አብራሃመይ ላፑን ኡዞ ዶርሳታ ዉድያፐ ሻክስ፤ ");
INSERT INTO gofe_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","አብመለከይ አብራሃመ፥ “ሀ ኔኒ ዱማ ሻካ ዎꬅዳ ላፑን ኡዞ ዶርሳታ አይስ ሻካዲ?” ያግድ ኦይችስ። ");
INSERT INTO gofe_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","አብራሃመይ፥ “ታኒ ሀ ሃꬃ ኦላ ቦክዳይሳስ ማርካ ግዳና መላ፥ ሀ ላፑን ኡዞ ዶርሳታ ታፐ ኤካ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","ሄሳን ሄ ናምኡ አሳት ጫቅዳ ግሾ፥ ሄ በሳይ ባርሳበ (ጫቆ ሃꬃ ኦላ ዎይኮ ላፑን ሃꬃ ኦላ)። ");
INSERT INTO gofe_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","በርሳበን ጫቁዋ ጫቅዳፐ ጉየ፥ አብመለከይነ እያ ቶራ ሞጮናይ ፍኮል ደንድድ፥ ፍልስፄመ ቢታ ስምዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","አብራሃመይ ባርሳበን ታማርሲክ ጌተትያ ምꬅ ቶክስ። ሄሳን ጎዳ፥ መርና ፆሳ ፄግድ እያዉ ጎይንስ። ");
INSERT INTO gofe_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","አብራሃመይ ፍልስፄመ ቢታን ዳሮ ዎደ ደእስ። ");
INSERT INTO gofe_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","ሄሳፈ ጉየ፥ ፆሳይ አብራሃመ ፓጭስ፤ እ እያ፥ “አብራሃመ” ያግድ ፄግስ። እ፥ “ዬ” ግድ ኮይስ። ");
INSERT INTO gofe_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","ፆሳይ፥ “ኔኒ ዶስያ ነ እስ ናአ ይሳቃ ኤካዳ፥ ሞርያ ቢታ ባ። ያን ታኒ ነና በሲያ እስ ደረ ቦላ እያ ፁሳ ያርሾ ኦꬃዳ ታዉ ያርሻ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","ዎንተꬃ ጋላስ አብራሃመይ ጉራ ደንድድ፥ ባ ሀርያ ጫንስ። ባ አይለታፐ ናምአታነ ባ ናአ ይሳቃ ባራ ኤክድ፥ ፁሳ ያርሹዋስ ግድያ ምꬃ ቀር ኤክድ፥ ፆሲ እያ በሲያ በሲ ባናዉ ደንድስ። ");
INSERT INTO gofe_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","ሄꬓንꬆ ጋላስ አብራሃመይ ꬎቁ ግድ፥ ሄ በሳ ሃሆራ በእስ። ");
INSERT INTO gofe_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","አብራሃመይ ባ አይለታ፥ “ህንተ ሀርያራ ሀይሳን ደእሽተ። ታራ ታ ናኣራ ያ ብድ ፆሰ ጎይንድ፥ ህንተኮ ስማና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","አብራሃመይ ያርሹዋ ምꬃ ደንꬅድ፥ ባ ናአ ይሳቃ ቶስስ። እ ባዉ ታማነ ማሸ ኦይክስ። ኤንቲ ናምአይ እስፈ ብሽን፤ ");
INSERT INTO gofe_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","ይሳቅ ባ አዋ አብራሃመ፥ “ታ አዋዉ” ያግስ። አብራሃመይ፥ “ዬ፥ ታ ናአዉ” ያግስ። ይሳቅ፥ “ታማይነ ምꬃይ ሀይስሽ፤ ሽን ፁሳ ያርሾ ኡርገ ዶርሳይ አዉኔ?” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","ያትን አብራሃመይ፥ “ታ ናአዉ፥ ፁሳ ያርሾ ኡርገ ዶርሳ ፆሳይ ባዉ እማና” ያግስ። ያግን ኤንቲ ናምአይ እስፈ ብዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","ኤንቲ ፆሳይ እያዉ ኦድዳ በሳ ጋክዳ ዎደ፥ አብራሃመይ ያን ያርሾ በሲ ጊግስድ፥ ምꬅ ሂፅስ። ባ ናአ ይሳቃ ቃችድ፥ ሄ ምꬃ ቦላ ዝንእስስ። ");
INSERT INTO gofe_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","አብራሃመይ ባ ናአ ሹካናዉ ባ ኩሽያ የድድ ማሸ ኤክስ። ");
INSERT INTO gofe_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","ሽን ጎዳ ኪታንቾይ ሳሎፐ፥ “አብራሃመ፥ አብራሃመ” ያግድ ፄግስ። እ፥ “ዬ” ያግድ ኮይስ። ");
INSERT INTO gofe_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","ኪታንቾይ፥ “ናአ ቦላ ነ ኩሽያ ዎꬆፋ፤ እያ አይብባካ ኦꬆፋ። ኔኒ ነ እስ ናኣ ታና ድጎና ግሾ፥ ኔኒ ፆሳስ ያየይሳ ታኒ ኤራይስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","አብራሃመይ ꬎቁ ግድ ፄልስ፤ ሄኮ ካጨይ ቱራን ቃፀትዳ እስ ዶርስ ደኤይሳ በእስ። አብራሃመይ ብድ ሄ ዶርሳ ኤክድ፥ ባ ናአ በሳን ፁሳ ያርሾ ኦꬅድ ያርሽስ። ");
INSERT INTO gofe_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","ሄሳ ግሾ፥ አብራሃመይ፥ “ጎዳይ እማና” ግድ ሄ በሳ ሱንꬅስ። ሀች ጋካናስ ሄስ፥ “ጎዳ ዙማ ቦላ እመታና” ጌተቴስ። ");
INSERT INTO gofe_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","ጎዳ ኪታንቾይ ሳሉዋፐ ናምአንꬆ አብራሃመ ፄግድ፥ ");
INSERT INTO gofe_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“ታኒ ጎዳይ፥ ሀይሳዳ ጋዳ ታኒ ታ ሁጰን ነዉ ጫቃይስ፤ ኔኒ ሀይሳ ኦꬅዳ ግሾነ ነ እስ ናኣ ታና ድጎና ግሾ፥ ");
INSERT INTO gofe_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","ታኒ ነና ቱማ አንጃና። ነ ዘረꬃ ታኒ ሳሎ ፆልንቶ መላነ አባ ጋፃን ደእያ ሻፈ መላ ኦꬃና። ነ ዘረꬃት ባንታ ሞርከታ ካታማታ ላታና። ");
INSERT INTO gofe_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","ኔኒ ታዉ ኪተትዳ ግሾ፥ ሀ ሳአ ካዎተꬃት ኡባይ ነ ዘረꬃ ባጋራ አንጀታና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","ሄሳፈ ጉየ፥ አብራሃመይ ባ አይለታኮ ጉየ ስምን፥ ኤንቲ ኡባይ እስፈ ደንድድ ባርሳበ ብዶሶና። አብራሃመይ ባርሳበን ደእስ። ");
INSERT INTO gofe_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","ሄሳፈ ጉየ፥ አብራሃመስ፥ “ምልካ ነ እሻ ናኮራስ ናይታ የላሱ፤ ");
INSERT INTO gofe_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","ኤንትካ ባይራይ ኡፃ፤ ኡፃ እሻት ቡዛ፥ ");
INSERT INTO gofe_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","አራመ አዋ ቃሜላ፥ ከሳዳ፥ ሃዞ፥ ፕልዳሻ፥ ይድላፋነ ባቱኤላ ጌተቶሶና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","ሀ ሆስፑን ናይታ ምልካ አብራሃመ እሻ ናኮራስ የላሱ። ባቱኤል እርብቃ የልስ። ");
INSERT INTO gofe_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","ረኡማ ጌተትያ እያ ናምአንꬆ ማጫስያ ቃስ ፀባ፥ ጋሃማ፥ ታሀሳነ ማካ የላሱ። ");
INSERT INTO gofe_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","ሳራ ፄታነ ላታማነ ላፑን ላይꬅ ደአሱ። ");
INSERT INTO gofe_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","ሄሳፈ ጉየ፥ እያ ካናነ ቢታን ደእያ ቅርያት-አርባ (ከብሮና) ካታማን ሀይቃሱ። አብራሃመይ ሳርስ ዬክስነ ካዮትስ። ");
INSERT INTO gofe_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","ዬክ ስሚድ፥ አብራሃመይ ባ ማቸ አሀ ማታፐ ደንድድ ብድ፥ ህተታ ሀይሳዳ ያግስ፤ ");
INSERT INTO gofe_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“ታኒ ህንተ ግዶን እማ፤ ታ ማቸ አሀ ሞጋናዉ ታዉ ህንተ ጋድያፐ ዱፎ በሲ ባይዘርከት” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","6","ህተት አብራሃመ፥ “ጎዳዉ፥ ኑኒ ኦደይሳ ስአ፤ ኔኒ ኑ ግዶን ዎልቃማ ሀላቃ፤ ኔኒ ነ ማቸ አሀ ኑ ዱፉዋፐ ነና ሎእዳሶን ሞጋ፤ ኔኒ ነ ማቸ አሀ ሞጋናዉ ባ ዱፉዋ ኦንካ ነና ድገና” ያግ ዛርዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","አብራሃመይ ደንድ ኤቅድ፥ ህተታ ስንꬃን ዝግስ። ");
INSERT INTO gofe_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","9","እ ኤንታኮ፥ “ህንተ ታና፥ ‘ነ ማቸ አሀ ሞጋ’ ጊኮ፥ ታኒ ግያባ ስእተ። ዞሃራ ናአ ኤፍሮናስ እያ ጋድያ ጋፃን ደእያ ማክፌላ ጌተትያ ጎንጎሉዋ ታ ዱፎ ኦꬃናዉ ባይዛና መላ ኩመꬃ ጋተን ኑና ዛልእሰርከት” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","ህተ አድያ ኤፍሮን ሄ ዎደ ካታማ ፐንገን ሺቅዳ ባ አሳ ግዶን ኡትስ። ህተት ኡባይ ስእሽን፥ አብራሃመኮ ያግስ፤ ");
INSERT INTO gofe_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“ሄሳዳ ግደና፤ ታ ጎዳዉ፥ ታ ኦደይሳ ስአ፤ ታኒ ጋድያካ እያ ግዶን ደእያ ጎንጎሉዋካ ነዉ እማይስ፤ ታኒ ነዉ እያ ታ አሳ ስንꬃን እማይስ፤ ኔኒ ነ ማቸ አሀ ሞጋ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","አብራሃመይ ሄ ቢታ አሳ ስንꬃን ዛር ዝግድ፥ ");
INSERT INTO gofe_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","አሳይ ስእሽን ኤፍሮና፥ “ታ ኦደይሳ ስአርክ! ታኒ ሄ ጋድያ ጋተ ቃንፃና፤ ኔኒ ታፐ ኤካርክ። ሄሳን ታኒ ታ ማቸ አሀ ሞጋና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","15","ኤፍሮን አብራሃመኮ ዛሪድ፥ “ታ ጎዳዉ፥ ታኒ ኦደይሳ ስአ፤ ጋደይ ኦይዱ ፄቱ ብራ ሳንትመ ከሳና፤ ሽን ሄስ ነ ግዶንነ ታ ግዶን አይብካ ግደና፤ ነ ማቸ አሀ ሞጋ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","አብራሃመይ ህተት ስእሽን፥ ኤፍሮን ግዳ ጋትያ ኤክስ፤ ሄ ዎደ ሚሸን ኦይዱ ፄቱ ብራ ሳንትመ ኤፍሮናስ እሚስ። ");
INSERT INTO gofe_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","ያት ስሚድ፥ ማምረ ካታማ ማታን ማክፌላን ደእያ ኤፍሮና ጋደይ፥ ያን ደእያ ጎንጎሎይነ ሄ ጋድያን ደእያ ምꬃ ኡባይ፥ ");
INSERT INTO gofe_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","ካታማ ፐንገን ሺቅዳ ህተታ ኡባ ስንꬃን ዎጋꬆ አብራሃመ ጋደ ግድስ። ");
INSERT INTO gofe_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","ሄሳፈ ጉየ፥ አብራሃመይ ባ ማችዉ ሳራ ካናነ ቢታን (ከብሮና) ጌተትያ ማምረ ካታማ ማታን ደእያ ማክፌላ ጌተትያ ጋደ ጎንጎሉዋን ሞግስ። ");
INSERT INTO gofe_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","ሄሳ ግሾ፥ ሄ ጋደይነ ያን ደእያ ጎንጎሎይ ህተታ ስንꬃን ህግያን አብራሃመስ ዱፎ ግድስ። ");
INSERT INTO gofe_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","አብራሃመይ ዳሮ ጭምስ። ጎዳይ እያ ኡባባንካ አንጅስ። ");
INSERT INTO gofe_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","አብራሃመይ ባ አይልያ፥ ባ ሶ አሳ ኡባስ ሀላቃትያ፥ ባ አቆ ኡባ ቦላ ሱንትዳይሳ ሀይሳዳ ያግስ፥ “ነ ኩሽያን ታ ጉልባታ ኦይካ፤ ");
INSERT INTO gofe_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","ታኒ ኤንታ ግዶን ደእዳ ካናነታ ማጫ ናይታፐ ታ ናኣስ ማቾ ኦይቾና መላ፥ ጎዳን፥ ሳሎነ ሳአ ፆሳ ሱንꬃን ታኒ ነና ጫቅሳይስ፤ ");
INSERT INTO gofe_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","ሽን ኔኒ ታ የለትዳ ቢታ፥ ታ ዳቦታኮ ባዳ፥ ታ ናአ ይሳቃስ ማቾ ኦይቻ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","እያ አይለይ፥ “ሄ ማጫስያ ታራ ያናዉ ዶሶና እፅኮ፥ ነ ናአ ኔኒ ይዳ ቢታ ጉየ ኤፎ?” ያግድ ኦይችስ። ");
INSERT INTO gofe_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","አብራሃመይ፥ “ታ ናአ አይ ጋሶንካ ያ ኤፎናዳ ነና ኤራ! ");
INSERT INTO gofe_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","ጎዳይ፥ ሳሉዋ ፆሳይ፥ ታና ታ አዋ ሶፐነ ታ የለትዳ ቢታፈ ከስዳይስ ታዉ፥ ‘ነ ዘረꬃስ ታኒ ሀ ቢታ እማና’ ያግድ ጫቅዳይስ፥ ኔኒ ታ ናኣስ ያፐ ማቾ ደማና መላ፥ እ ባ ኪታንቹዋ ኔፐ ስን ኪታና። ");
INSERT INTO gofe_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","ሄ ማጫስያ ኔራ ያናዉ ዶሶና እፅኮ፥ ሀ ታኒ ነና ጫቅስዳ ጫቆይ ነዉ ጎመ ግደና፤ ሽን ታ ናአ ያ ኡባካ ኤፎፓ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","አይለይ ባ ጎዳ አብራሃመ ጉልባታ ኦይክስ፤ ሄ ኦዳስ ጫቅስ። ");
INSERT INTO gofe_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","ሄሳፈ ጉየ፥ አይለይ ባ ጎዳ ግማለታፐ ታማ ኤክድ፥ ባ ጎዳ ሚሽያፐካ ሙሩታ ሙሩታ ኤክ ብድ ማሰጰፆመ ቢታን ናኮራ ካታማ ጋክስ። ");
INSERT INTO gofe_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","ኦማርስ፥ ማጫስ ሃ ትካናዉ ያ ዎደ፥ ካታማፐ ጋፃን ሃꬃ ኦላ ማታን ባ ግማለታ ጉልባትስስ። ");
INSERT INTO gofe_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","እ ዎስሸ፥ “ጎዳዉ፥ ታ ጎዳ አብራሃመ ፆሳዉ፥ ሀች ታኒ ቆፓዳ ይዳይሳ ታዉ ጊግሳ፤ ቃስ ታ ጎዳ አብራሃመስ ኬሀባ ኦꬃ። ");
INSERT INTO gofe_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","ሄኮ፥ ታኒ ሀ ሃꬃ ፑልቱዋ ማታን ኤቃይስ፤ ሀ ካታማ ማጫ ናይት ሃꬃ ትካናዉ ሃ ዮሶና። ");
INSERT INTO gofe_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","ታኒ፥ ‘አነ ኦቱዋ ዝቅ ኦꬃዳ ታና ሃ ኡሻ’ ግያ ዎደ፥ እያ፥ ‘ሄኮ ኡያ፤ ቃስ ነ ግማለታ ታኒ ኡሻና’ ግያራ፥ ህና ነ አይልያ ይሳቃስ ኔኒ ዶርዳሮ ግዶ፤ ኔኒ ታ ጎዳስ ኬሀባ ኦꬅዳይሳ ታኒ ሄሳን ኤራና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","ቡሮ እ ዎሳ ዛሮና ደእሽን፥ እርብቃ ሃꬃ ኦቶ ቶካዳ ፑቱ ጋሱ። እያ ባቱኤላ ናአ፥ ባቱኤል ምልካ ናአ፥ ምልካ አብራሃመ እሻ ናኮራ ማችዉ። ");
INSERT INTO gofe_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","እርብቂ ዳሮ የገልስን አደ ኤሮና ጌላኦ። ፑልቱዋ ዱገ ዎꬋዳ፥ ባ ኦቱዋ ኩንꬃዳ ባናዉ ደንዳሱ። ");
INSERT INTO gofe_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","ያንን፥ ሄ አይለይ ኢኮ ዎፅ ብድ እዮ፥ “ነ ታና ጉꬃ ሃ ኡሻርክ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","እያ፥ “ኤሮ ታ ጎዳዉ፥ ኡያ” ያጋሱ። ኤለሳዳ ኦቱዋ ባ ሀሸፐ ዎꬃዳ፥ ገድ ኦꬃ ኦይካዳ እያ ኡሻሱ። ");
INSERT INTO gofe_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","እያ ኡሽዳፐ ጉየ፥ “ነ ግማለትካ አላና ጋካናዉ ታኒ ኤንታዉ ሃꬃ ዱቃና” ያጋሱ። ");
INSERT INTO gofe_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","አትዳ ሃꬃ ኤለሳዳ ጎንጌን ትጋዳ፥ ሀራ ሃ ዱቃናዉ ኦላ ዎፃሱ፤ ግማለት ኡባይ አላና ጋካናስ፥ ሃꬃ ኦላፈ ዱቃ ዱቃ ኤሀዳ ጎንገን ትጋዳ ኡሻሱ። ");
INSERT INTO gofe_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","እ ቆፕድ ይዳ ቆፋ ጎዳይ እንጀይሸ ደእያኮነ ኤራናዉ አደይ ስእ ግድ እዮ ፄሌስ። ");
INSERT INTO gofe_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","ግማለት ሃꬃ ኡይ ስምን፥ አደይ እቻሹ ግራመ ባጋ ሲን አꬅያ ዎርቃ ፄታነ ታሙ ግራመ ግድያ ናምኡ ዎርቃ ሳጋዮታ ጊግስስ። ");
INSERT INTO gofe_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","እዮ፥ “ኔኒ ኦደ ናኤ? አነ ታዉ ኦዳ፤ ነ አዋ ሶን ኑስ አቅያ በሲ ዳኔ?” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","እያ፥ “ታኒ ባቱኤላ ናአ፤ ባቱኤል ምልካ ናኮራስ የልዳ ናአ። ");
INSERT INTO gofe_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","ኑ ሶን ግድያ ካለይነ ሀርቆይ ደኤስ፤ ቃስ ህንተ አቃናዉ በሲ ደኤስ” ያጋሱ። ");
INSERT INTO gofe_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","አደይ ጉልባትድ ጎዳ ጎይንድ፥ ");
INSERT INTO gofe_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","ሀይሳዳ ያግስ፤ “ታ ጎዳስ ኬሄይሳነ አማነተይሳ አግቦና ጎዳይ፥ ታ ጎዳ አብራሃመ ፆሳይ ጋላተቶ፤ ታኒ ይሽን፥ ጎዳይ ታና ታ ጎዳ ዳቦታ ሶ ካለꬅስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","ናእያ ዎፃ ባዳ፥ ባ አየ ሶን ደእያ አሳስ ሀንዳባ ኦዳሱ። ");
INSERT INTO gofe_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","እርብቃስ ላባ ጌተትያ እሺ ደኤስ። ላቢ ካረ ከይድ ሃꬃ ፑልቱዋ ማታን ደእያ አድያኮ ዎፅስ። ");
INSERT INTO gofe_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","ሲ ዎርቃነ ባ ምቸ ኩሸን ደእያ ሳጋዮታ በእዳ ዎደ እርብቃ አደይ ባና ግዶይሳ ኦድን ስእዳ ዎደ፥ ከይድ አድያኮ ብስ። አደይካ ግማለታራ ፑልቱዋ ማታን ኤቅዳይሳ ደምስ። ");
INSERT INTO gofe_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","እያኮ፥ “ጎዳይ ነና አንጅዳይሶ፥ ሃያ፥ ኔኒ ካረን አይስ ኤቃዲ? ታኒ ነዉ ኬነ ግማለታስካ በሰ ጊግሳስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","ያትን አደይ ሶ ገልስ። ላቢ ግማለታ ጫና ብልድ፥ ካለነ ꬊለ ግማለታስ እማስ። ቶሆ ሜጫናዉ እያስነ እያራ ደእያ አሳስ ሃ ኤህስ። ");
INSERT INTO gofe_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","ካꬅ እያ ስን አꬍስ። ሽን፥ “ታኒ ታና ኤህዳባ ህንተዉ ኦዶና ደአሸ ካꬅ ሚከ” ያግስ። ላቢ፥ “ያኮ ኦዳ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","ሄሳ ግሾ፥ እ፥ “ታኒ አብራሃመ አይልያ። ");
INSERT INTO gofe_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","ጎዳይ ታ ጎዳ ዳሮ አንጅዳ ግሾ እ ዱረትስ። ዶርሰ፥ ሚዝ፥ ብራ፥ ዎርቃ፥ አደ አይለታ፥ ማጫ አይለታ፥ ግማለታነ ሀረታ እያዉ እሚስ። ");
INSERT INTO gofe_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","ታ ጎዳ ማችያ ሳራ ባ ጭማተꬃ ላይꬃን እያዉ አደ ናአ የላሱ። ያትን እ ባዉ ደእያባ ኡባ እያዉ እሚስ። ");
INSERT INTO gofe_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","ታ ጎዳይ ታና ሀይሳዳ ጫቅስስ፥ ‘ታኒ ደእያ ካናነ ቢታ ማጫ ናይታፐ ታ ናኣስ ማቾ ኦይቾፋ። ");
INSERT INTO gofe_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","ሽን ታ አዋ አሳኮ፥ ታ ዳቦታኮ ባዳ ታ ናኣስ ማቾ ኦይቻ’ ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","ታኒ ታ ጎዳ፥ ‘ናእያ ታራ ያናዉ ዶሶና እፅኮች?’ ያጋዳ ኦይቻስ። ");
INSERT INTO gofe_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","እካ፥ ታኒ እያ ስንꬃን ኪተትዳ ጎዳይ ባ ኪታንቹዋ ኪታና፤ ኔኒ ታ ናኣስ ታ አዋ አሳፐ፥ ታ ኮቻፈ ማቾ ደማና መላ፥ ነ በይሳካ እንጀያና። ");
INSERT INTO gofe_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","ኔኒ ታ ኮቻታኮ ብን፥ ኤንቲ ነዉ እዮ እሞና እፅኮ፥ ሄ ዎደ ነዉ ጫቆይ ጎመ ግደና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“ታኒ ሀች ሄ ፑልቱዋኮ ያ ዎደ ያጋስ፤ ‘ጎዳዉ፥ ታ ጎዳ አብራሃመ ፆሳዉ፥ ነ ሸነ ግድኮ፥ ታኒ ብያ አላልያ ጊግሳ። ");
INSERT INTO gofe_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","ሄኮ፥ ታኒ ሀ ፑልቱዋ ማታን ኤቃይስ፤ ጌላኦ እስንያ ሃ ትካናዉ ዪኮ፥ ታኒ እዮ፥ ታና ነ ኦቱዋፐ ጉꬃ ሃ ኡሻርክ’ ያጋና። ");
INSERT INTO gofe_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","እያ፥ ‘ኤሮ ኡያ፥ ቃስ ነ ግማለታስካ ታኒ ሃ ዱቃና’ ግያራ፥ ጎዳይ ታ ጎዳ ናኣስ ዶርዳሮ ግዶ” ያጋስ። ");
INSERT INTO gofe_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“ታኒ ታ ዎዛናን ዎሰይሳ ዛሮና ደእሽን፥ እርብቃ ባ ኦቱዋ ቶካዳ፥ ፑቱ ጋሱ፤ ፑልቱዋ ዱገ ዎꬋዳ ሃ ዱቃሱ፤ ታኒ እዮ፥ ‘ታና ሃ ኡሻርክ’ ያጋስ። ");
INSERT INTO gofe_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","“ያግን እያ ኤለሳዳ ባ ሀሽያፐ ኦቱዋ ዎꬃዳ፥ ‘ሄኮ ኡያ፤ ቃስ ታኒ ነ ግማለታ ኡሻና’ ያጋሱ። ያትን ታኒ ኡያስ፤ ቃስ ታ ግማለታ እያ ኡሻሱ። ");
INSERT INTO gofe_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","“ታኒ እዮ፥ ‘ኔኒ ኦደ ናኤ?’ ያጋስ። “እያ ዛራዳ፥ ‘ታኒ ባቱኤላ ናኣ፤ ባቱኤል፥ ምልካ ናኮራስ የልዳ ናአ’ ያጋሱ። ታኒ ዎርቃ እ ሲን፥ ሳጋዮታ እ ኩሸን አꬃስ። ");
INSERT INTO gofe_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","ሄሳፈ ጉየ፥ ታኒ ጉልባታዳ፥ ጎዳስ ጎይናስ። ታኒ ጎዳ፥ ታ ጎዳ አብራሃመ ፆሳ፥ ታ ጎዳ እሻ ናአ ናእዉ እያ ናኣስ ኤካናዉ ታና ልከ ኦግያ ካለꬅዳይሳስ ጋላታይስ። ");
INSERT INTO gofe_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","ሀእካ ህንተ ታ ጎዳስ ኬሀናባነ አማነታናባ ግድኮ፥ ታዉ ኦድተ፤ ግዶና እፅኮካ ኦድተ፤ ሄሳፈ ጉየ፥ ታኒ ሀናናባ ኤራና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","ላብነ ባቱኤል ዛሪድ ያግዶሶና፤ “ሀ ኦዳይ ጎዳፐ ይስ፤ ኑኒ ነዉ ያ ሃ ጋናዉ ዳንዳኦኮ። ");
INSERT INTO gofe_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","እርብቆ ሀኖ በአ፤ ኤካዳ ባ፤ ጎዳይ ግዳይሳዳ ነ ጎዳ ናኣስ ማቾ ግዶ” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","አብራሃመ አይለይ ኤንቲ ግያባ ስእዳ ዎደ፥ ሳአን ጉልባትድ ጎዳስ ጎይንስ። ");
INSERT INTO gofe_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","አይለይ ብራ አሌቆ፥ ዎርቃ አሌቆነ ማኦ ከስድ እርብቃስ እሚስ። ቃስ አልኦ ሚሸታ እ እሻስነ እ አየስ እሚስ። ");
INSERT INTO gofe_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","ሄሳፈ ጉየ፥ እነ እያራ ደኤይሳት ምዶሶና ኡይዶሶና፤ ያን አቅዶሶና። ኤንቲ ጉራ ደንድን፥ እ፥ “ታና ታ ጎዳኮ የድተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","ያትን እ እሻይነ እ አይያ፥ “ናእያ እስ ታሙ ጋላሳ መላ ኑራ ታኮ፥ ሄሳፈ ጉየ እያ ባና” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","ሽን እ፥ “ጎዳይ ታ ይዳይሳ እንጀይን፥ ህንተ ታና ጋምእሶፕተ። ታኒ ታ ጎዳኮ ባና መላ ታና ሞይዝተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","ኤንቲ፥ “ናእዉ ፄግድ አነ እዮ ኦይቾስ” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","እርብቃ ፄግድ፥ “ሀ አድያራ ባኔ?” ያግድ ኦይችዶሶና። እያ፥ “ኤ፤ ታኒ ባና” ያጋሱ። ");
INSERT INTO gofe_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","ያንን፥ ኤንቲ ባንታ ምችዉ እርብቃ፥ እዮ ድችዳሮ፥ አብራሃመ አይልያነ እያ አሳታ ሞይዝዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","ኤንቲ እርብቃ፥ “ኑ ምቸ እርብቀ፥ ሙኩሉፐ ሙኩሉ ጋካናዉ ዳራ፤ ነ ኮቻይ ባንታ ሞርከታ ካታማታ ላቶ” ያግድ አንጅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","ሄሳፈ ጉየ፥ እርብቅነ እ ማጫ አይለት ደንድድ፥ ግማለታ ቶግድ፥ አድያራ ብዶሶና። ያትን አይለይ እርብቃ ኤክድ ብስ። ");
INSERT INTO gofe_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","ሄ ዎደ ይሳቅ፥ “ታና በእያ ደኦ ፆሳ ፑልቱዋ” ጌተትያ ፑልቱዋ ማታ ብድ፥ ነገበ መላ ቢታን ደኤስ። ");
INSERT INTO gofe_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","እስ ጋላስ ኦማርስ ይሳቅ ባ ዎዛናን ቆፕሸ ደምባ ከይድ ዩዬስ፤ እ ꬎቁ ግድ ፄልያ ዎደ፥ ግማለት የይሳታ በእስ። ");
INSERT INTO gofe_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","እርብቃካ ꬎቁ ጋዳ ፄልያ ዎደ፥ ይሳቃ በአሱ፤ ግማለታፐ ዎꬋሱ። ");
INSERT INTO gofe_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","አብራሃመ አይልያኮ፥ “ሀ ኑራ ጋሄታናዉ ደምባራ ያ አደይ ኦኔ?” ያጋሱ። አይለይ፥ “እ፥ ታ ጎዳ” ያግስ። እያ ባ ላፃና ኤካዳ ጉሉንታሱ። ");
INSERT INTO gofe_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","ቃስ አይለይ ባ ኦꬅዳባ ኡባ ይሳቃስ ኦድስ። ");
INSERT INTO gofe_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","ይሳቅ እርብቃ ባ አየ ሳራ ዱንካንያ ግዶ ኤፍስ። እዮ ማችስ፤ እያካ እያዉ ማቾ ግዳሱ። እ እዮ ዶስስ፤ ባ አየ ካዩዋ ዎꬅስ። ");
INSERT INTO gofe_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","አብራሃመይ ኬፁራ ጌተትያ ሀራ ማቾ ኤክስ። ");
INSERT INTO gofe_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","እያ ዝምራና፥ ዮቅሳና፥ ማዳነ፥ ምድያመ፥ ያስቦቃነ ስዋ እያዉ የላሱ። ");
INSERT INTO gofe_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","ዮቅሳን ሳባነ ደዳና የልስ። ደዳን አሾረታ፥ ለፁሰታነ ለኡማታ የልስ። ");
INSERT INTO gofe_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","ምድያመ ናይት ገፈራ፥ ኤፈራ፥ ሄኖሀ፥ አብዳነ ኤልዳ። ሀይሳቲ ኡባይ ኬፁራ ሼሻታ። ");
INSERT INTO gofe_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","አብራሃመይ ባባ ኡባ ይሳቃ ላትስስ። ");
INSERT INTO gofe_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","ሽን እ ፓፃ ደእሸ፥ ሀራ ማቸታፐ የልዳ ናይታ ባዉ ደእያባፐ ዎይትስ። ባ ናአ ይሳቃፐ ኤንታ ሻክድ፥ ዶሎሀ ባጋ ቢታ የድስ። ");
INSERT INTO gofe_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","አብራሃመይ ኩመꬅ እስ ፄታነ ላፑን ታማነ እቻሹ ላይꬅ ደእስ። ");
INSERT INTO gofe_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","አብራሃመይ ዳሮ ዎደ ደእድ፥ ሎኦ ጭምድ፥ ሀይቅድ ባ ማይዛታን ጋሄትስ። ");
INSERT INTO gofe_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","እያ ናይት ይሳቅነ እስማኤል እያ ማክፌላ ጌተትያ ጎንጎሎ ዱፉዋን ሞግዶሶና፤ ሄ ጎንጎሎይ ማምረ ማታን፥ ህተ አድያ ፆሃራ ናአ ኤፍሮና ጋድያን ደኤስ። ");
INSERT INTO gofe_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","ሄስ አብራሃመይ ህተታፐ ሻምዳ ጋድያ። አብራሃመይ ባ ማችያ ሳራ ሞገትዳ ዱፉዋን ሞገትስ። ");
INSERT INTO gofe_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","አብራሃመይ ሀይቅዳፐ ጉየ፥ ፆሳይ እያ ናአ ይሳቃ አንጅስ። ሄ ዎደ ይሳቅ፥ ቤር-ላይ-ሮእ (ታና በእያ ደኦ ፆሳ ፑልቶ) ጌተትያ ፑልቱዋ ማታን ደኤስ። ");
INSERT INTO gofe_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","ሳራ አይልያ፥ ግብፀፈ ይዳ አጋራ፥ አብራሃመስ የልዳ ናአ እስማኤላ የለተꬃይ ሀይሳፈ ካልድ ፃፈትዳይሳ። ");
INSERT INTO gofe_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","እስማኤላ ናይት ባንታ ሱንꬃንነ ባንታ የለታ ማራን ሀይሳታ፤ ኤንትካ፥ ናባዮታ፥ ቀዳረ፥ አድቤላ፥ ምብሳማ፥ ");
INSERT INTO gofe_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","ምስማ፥ ዱማ፥ ማሳ፥ ");
INSERT INTO gofe_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","ኩዳነ፥ ቴማ፥ እፁራ፥ ናፍሳነ ቀድማ። ");
INSERT INTO gofe_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","እስማኤላ ናይት ሀይሳታ፤ ኤንታ ሱንꬃይ ኤንታ ሞꬃንነ ደእያ በሳን ሀይሳ። ኤንቲ ባንታ ያራንካ ታማነ ናምኡ ሀላቃታ። ");
INSERT INTO gofe_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","እስማኤል ኩመꬅ ፄታነ ሀስታማነ ላፑን ላይꬅ ደእድ፥ ሀይቅድ ባ ማይዛታን ጋሄትስ። ");
INSERT INTO gofe_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","እስማኤላ ኮቸት ግብፀፈ ዶሎሀ ባጋን ደእያ ሀውላፐነ ሱራፐ ግዱዋን፥ አሶረ ኤፍያ ኦግያ ማታን ደእዶሶና። ኤንቲ ባንታ እሻታ ኡባራ ሞርከተꬃን ደእዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","አብራሃመ ናአ ይሳቃ የለተꬃይ ሀይሳፈ ካልድ ፃፈትዳይሳ፤ አብራሃመይ ይሳቃ የልስ። ");
INSERT INTO gofe_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","ይሳቃስ ላይꬅ ኦይታማ ግድን፥ እርብቃ ኤክስ፤ እያ ማሰጰፆመን ደእያ አራመ አድያ ባቱኤላ ናእዉነ ላባ ምችዉ። ");
INSERT INTO gofe_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","ይሳቅ ባ ማችያ ማይንꬅ ግድዳ ግሾ፥ እዉ ጎዳ ዎስስ፤ ጎዳይ እያ ዎሳ ስእስ። ያትን እያ ማችያ እርብቃ ቃንꬃታሱ። ");
INSERT INTO gofe_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","ሽን እ ኡሎን ደእያ ናይት መንተ ግድ ኡትድ፥ እሶይ እሱዋራ ሱገትዶሶና፤ እያ፥ “ሀይስ ታዉ አይስ ሀኒ?” ያጋሱ። ሄሳ ግሾ፥ ጎዳ ኦይቻናዉ ባሱ። ");
INSERT INTO gofe_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","ጎዳይ እዮ፥ “ነ ኡሎን ናምኡ ካዎተꬅ ደኤስ፤ ቃስ ነ ግዶን ደእያ ናምኡ ደረ አሳት እሶይ እሱዋፈ ሻከታና፤ እስ ደረ አሳት ሀንኮታፐ ምናና፤ ቃስ ባይራይ ካሉዋስ ኪተታና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","እው የሎ ዎደይ ጋክን፥ እ ኡሎን መንተ አደ ናይት ደኦሶና። ");
INSERT INTO gofe_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","ኮይሮ የለትዳይስ አርሰ፤ እያ ቦላ ኡባ እክሰይ ማእስ፤ ሄሳ ግሾ፥ ኤንቲ እያ ኤሳዌ (እክሳማ) ግድ ሱንꬅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","ሄሳፈ ጉየ፥ እያ እሻይ የለትስ። እ ባ ኩሽያን ኤሳዌ ግንድያ ኦይክድ ከይስ፥ ሄሳ ግሾ፥ እያ ያይቆባ (ግንደ ኦይከይሳ) ግድ ሱንꬅዶሶና። እርብቃ ኤንታ የልዳ ዎደ ይሳቃስ ኡሱፑን ታሙ ላይꬅ ግድስ። ");
INSERT INTO gofe_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","ናይት ድጭዶሶና፤ ኤሳዌይ ሻንካ ሂላ ኤርያ ባዞ አሰ ግድስ። ሽን ያይቆብ ዱንካነን ደእያ ዎፓ አሰ ግድስ። ");
INSERT INTO gofe_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","ይሳቅ ኤሳዌ ዶስስ፤ አይስ ጊኮ፥ እ ሻንካተይሳፈ ማናዉ ዶሴስ፤ ሽን እርብቃ ያይቆባ ዶሳዉሱ። ");
INSERT INTO gofe_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","እስ ዎደ ያይቆብ ዎፀ ካꬅሽን፥ ኤሳዌይ ኮሽ ዎꬍን ባዞፈ ይስ። ");
INSERT INTO gofe_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","ኤሳዌይ ያይቆባ፥ “ታና ሀ ዞኦ ዎፅያፐ ሙዛ፥ ታና ኮሽ ዎꬌስ” ያግስ። (ሄሳ ግሾ፥ ቃስ እያ ሱንꬃይ ኤዶመ (ዞኦ) ጌተትስ)። ");
INSERT INTO gofe_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","ያይቆብ እያ፥ “ኮይሮ ታዉ ነ ባይራተꬃ ባይዛ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","ያትን ኤሳዌይ፥ “ሄኮ፥ ታኒ ሀይቃና ሀናይስ፥ ሀ ባይራተꬃይ ታና አይ ማዲ?” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","ያይቆብ ዛሪድ፥ “አነ ታዉ ኮይሮ ጫቃ” ያግስ። እ ጫቅስ፥ ባ ባይራተꬃ ያይቆባስ ባይዝስ። ");
INSERT INTO gofe_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","ያይቆብ ኤሳዌስ ኡይꬅነ ምስረ ዎፀ እምን ምስ ኡይስ። ሄሳፈ ጉየ ደንድድ ብስ። ኤሳዌይ ባ ባይራተꬃ ሀይሳዳ ካꬍስ። ");
INSERT INTO gofe_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","ሄ ቢታን ካሰ አብራሃመ ዎደ ከይዳ ኮሻፐ ሀራ ኮሽ ከይስ። ያንን፥ ይሳቅ ፍልስፄመ ካዋ አብመለከኮ ገራራ ብስ። ");
INSERT INTO gofe_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","ጎዳይ ይሳቃስ ቆንጭድ “ግብፀ ቢታ ዱገ ቦፓ፥ ታኒ ነዉ ኦድዳ ቢታን ደአ። ");
INSERT INTO gofe_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","ሀ ቢታን ጉꬃ ዎድያ ጋምኣሻ፥ ታኒ ኔራ ግዳና፥ ነና አንጃና። ሀ ቢታ ኡባ ታኒ ነዉነ ነ ሼሻስ እማና። ታኒ ነ አዋ አብራሃመስ ጫቅዳ ጫቁዋ ፖላና። ");
INSERT INTO gofe_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","ነ ሼሻ ሳሎ ፆልንቶዳ ዳርሳና፥ ሀ ቢታ ኡባ ታኒ ኤንታዉ እማና። ሳአ ካዎተꬃት ኡባይ ነ ሼሻ ባጋራ አንጀታና። ");
INSERT INTO gofe_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","ሄስካ፥ አብራሃመይ ታ ቃላ ስእድ፥ ታ አዋጆታ፥ ታ ኪታታነ ታ ህገታ ናግዳ ግሾሳ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","ሄሳ ግሾ፥ ይሳቅ ገራራን ደእስ። ");
INSERT INTO gofe_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","ሄ ቢታ አሳይ እርብቃባ ደንꬅድ፥ “ሀና ነዉ አይቤ?” ግድ ይሳቃ ኦይችዶሶና። እ፥ “ሀና ታዉ ምቾ” ያግስ። ሄሳ እ ግዳይ፥ እርብቃ ዳሮ ማላ ሎኦ ግድያ ግሾ፥ “እያ ታ ማቾ ጊኮ፥ ሀ አሳይ እ ጋሶን ታና ዎꬋና” ያግ ቆፕድ ባብስ። ");
INSERT INTO gofe_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","ይሳቅ ያን ዳሮ ዎደ ደእዳፐ ጉየ፥ ፍልስፄመ ካዎይ አብመለከይ ማስኮተራ ዱገ ፄልያደ፥ ይሳቅ ባ ማቸ እርብቃራ ካእሽን በእስ። ");
INSERT INTO gofe_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","ሄሳ ግሾ፥ አብመለከይ ይሳቃ ፄግስድ፥ “ሄኮ፥ እያ ነ ማቾ፤ ኔኒ አይስ እያ ታ ምቾ ጋዲ?” ግድ ኦይችስ። ይሳቅ፥ “እያ ታ ማቾ ጊኮ፥ አሳይ ታና እ ጋሶን ዎꬋና ጋዳ ጋስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","አብመለከይ፥ “ሀይስ ኔኒ ኑ ቦላ ኦꬅዳባይ አይቤ? ታ አሳፐ እስ አስ ነ ማቸራ አቅስ ሽን አትስ፥ ኔኒ ኑ ቦላ ጎመ ኤሀዳሳ ሽን” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","ሄሳ ግሾ፥ አብመለከይ ባ አሳ፥ “ሀ ኡራ ዎይኮ እያ ማችዉ ቦችያ ኦንካ ቱማ ሀይቃና” ያግድ ኪትስ። ");
INSERT INTO gofe_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","ይሳቅ ሄ ቢታን ካꬅ ዘርድ፥ ጎዳይ እያ አንጅዳ ግሾ ሄ ላይꬃን ፄቱ ኩሸ ኤክስ። ");
INSERT INTO gofe_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","እ ዱረተꬃን ኤረታና ጋካናስ ዳሮ ዱረትሸ ብስ። ");
INSERT INTO gofe_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","ይሳቃስ ዶርሳ ዉደይ፥ ሚዛ ዉደይነ አይለት አꬍድ ዳርዳ ግሾ፥ ፍልስፄመ አሳት እያ ቃናትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","ሄሳ ግሾ፥ እያ አዋ አብራሃመ ዎደ እያ አዋ አይለት ቦክዳ ሃꬃ ኦላ ኡባ ፍልስፄመት ቢታ ኡሽድ ኩንꬅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","ሄ ዎደ አብመለከይ ይሳቃኮ፥ “ኔኒ ኑፐ አꬋዳ ምንዳ ግሾ ኑ ማታፐ ባ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","ይሳቅ ሄሳፈ ደንድድ፥ ገራራ ዛንጋራ ብድ ዱንካነ ቶክድ ያን ደእስ። ");
INSERT INTO gofe_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","ይሳቅ ባ አዋ አብራሃመ ዎደ ቦከትዳ ሃꬃ ኦላታ፥ አብራሃመይ ሀይቅዳፐ ጉየ፥ ፍልስፄመት ኩንꬅዳይሳታ ዛር ቦክ ከስድ፥ እያ አዋይ ሱንꬅዳ ሱንꬃን ፄግስ። ");
INSERT INTO gofe_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","ይሳቃ አይለት ሄ ዛንጋራን ሃꬃ ኦላ ቦክድ ያን ሎኦ ፑልቶ ሃꬃ ደምዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","ሽን ገራራ ሄንꬃንቾት ይሳቃ ሄንꬃንቾታራ፥ “ሃꬃይ ኑባ” ያግድ ኦየትዶሶና። ኤንቲ ፓላመትዳ ግሾ፥ ይሳቅ ሄ ሃꬃ ኦላ “ኤሴቃ” ግድ ሱንꬅስ። ");
INSERT INTO gofe_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","ሄሳፈ ጉየ፥ ኤንቲ ሀራ ሃꬃ ኦላ ቦክዶሶና። ሽን ኤንቲ ሄ ሃꬃ ኦላ ጌዶንካ ኦየትዶሶና። ሄሳ ግሾ፥ ይሳቅ ሄ ሃꬃ ኦላ “ሲፅና” ግድ ሱንꬅስ። ");
INSERT INTO gofe_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","ሄሳፈ ጉꬅ ስን ሺቅድ ሀራ ሃꬃ ኦላ ቦክስስ። እያ ጋሶን ኦንካ ኦየትቦና ግሾ፥ “ፆሳይ ሀእ ኑስ ዳልግስስ ኑኒ ሀ ቢታን ዳራና” ግድ ሄ በሳ ረሆቦታ ግድ ሱንꬅስ። ");
INSERT INTO gofe_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","ሄሳፈ ደንድድ ፑደ በርሳበ ከይስ። ");
INSERT INTO gofe_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","ሄ ብዳ ጋላስ ቃማ ጎዳይ እያዉ ቆንጭድ፥ “ታኒ ነ አዋ አብራሃመ ፆሳ፥ ታኒ ኔራ ደእያ ግሾ፥ ባቦፋ። ታ አይልያ አብራሃመ ግሾ ታኒ ነና አንጃና፥ ነ ሼሻካ ዳርሳና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","ይሳቅ ያን ያርሾ በሲ ጊግስድ ጎዳ ሱንꬃ ፄግስ። ያን እ ባ ዱንካንያ ቶክስ፥ እያ አይለት ያን ሃꬃ ኦላ ቦክዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","ሄሳፈ ጉየ፥ አብመለከይ ባና ዞርያ አሁዛነ ቶራ ሞጮና ፍኮላ ኤክድ፥ ገራራፐ ይሳቃኮ ይስ። ");
INSERT INTO gofe_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","ይሳቅ ኤንታኮ፥ “ህንተ ካሰ ታና እፅድ፥ ህንተ ቢታፈ ከስ የድቤከቲ? ሀእ ታኮ አይ ኤካናዉ ይደቲ?” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","ኤንቲ፥ “ጎዳይ ኔራ ደኤይሳ ኑኒ ጌሽ ኤርዳ። ሄሳ ግሾ፥ ሳሮተꬃ ጫቆይ ኑ ግዶንነ ነ ግዶን ዳናዉ ኮሼስ። ");
INSERT INTO gofe_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","ኑኒ ነና ቦችቦኮ፥ ነዉ ኬሀተꬃ ፃላላ ኦꬅድ፥ ነና ሳሮተꬃን ሞይዝድ የድዳ። ሄሳዳካ ኔኒ ኑ ቦላ ኢታባ ኦꬆና መላ፥ አነ ኔራ ጫቆስ። ቱማካ ሀእ ነና ጎዳይ አንጅስ” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","ሄ ዎደ ይሳቅ ኤንታዉ ግብራ ጊግስን ምዶሶና፥ ኡይዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","ዎንተꬃ ጋላስ ዎንታ ጉራ ደንድድ ኤንቲ እሶይ እሱዋራ ጫቅዶሶና። ይሳቅ ኤንታ ሞይዝን፥ ኤንቲ ሳሮ ሻከትድ ብዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","ሄ ጋላስ ይሳቃ አይለት ይድ፥ “ኑኒ ሃ ደምዳ” ያግድ ባንታ ቦክዳ ሃꬃ ኦላባ እያዉ ኦድዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","እ ሄ ሃꬃ ኦላ ሳበ (ጫቆ) ግድ ሱንꬅስ። ሄሳ ግሾ፥ ሄ ካታማ ሱንꬃይ ሀች ጋካናስ በርሳበ (ጫቆ ሃꬃ ኦላ) ጌተቴስ። ");
INSERT INTO gofe_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","ኤሳዌስ ላይꬅ ኦይታማ ግድዳ ዎደ ህተ አድያ ብኤራ ናእዉ ዮድቶነ ህተ አድያ ኤሎና ናእዉ ባሰማቶ ማችስ። ");
INSERT INTO gofe_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","ኤንቲ ይሳቃነ እርብቃ አዛንꬅሸ ደእዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","ይሳቅ ጭምን እያ አይፈይ ፄሎ እፅዳ ዎደ ባ ባይራ ናአ ኤሳዌ ፄግድ፥ “ታ ናአዉ” ያግስ። እካ፥ “ዬ” ግድ ኮይስ። ");
INSERT INTO gofe_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","ይሳቅ፥ “ሄኮ፥ ሀእ ታኒ ጭማስ፥ ታኒ አዉደ ሀይቃነኮ ኤርከ። ");
INSERT INTO gofe_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","ያንያ ግሾ፥ ሀእ ነ ሻንካ ዶንግያ ኤካዳ ባዞ ባዳ ዶአ ሻንካታዳ አሾ ኤካዳ ያ። ");
INSERT INTO gofe_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","ማልኦ ካꬅ ታ ዶሰይሳꬆ ኦꬃ ካꬃዳ ታዉ ኤሀ። ታኒ ሀይቃናፐ ስን ማ ስማዳ ነና አንጃና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","ይሳቅ ባ ናአ ኤሳዌስ ኦድያ ዎደ እርብቃ ስአዉሱ። ኤሳዌይ ዶአ ሻንካትድ ኤሀናዉ ባዞ ብዳፐ ጉየ፥ ");
INSERT INTO gofe_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","እርብቃ ባ ናአ ያይቆባ፥ “ነ አዋይ ነ እሻ ኤሳዌ፥ ");
INSERT INTO gofe_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘ዶአ ሻንካታ ኤሀዳ ታዉ ማልኦ ካꬅ ታ ማናዉ ካꬃ። ታኒ ሀይቃናፐ ስን ማ ስማዳ ጎዳ ስንꬃን ነና አንጃና’ ያግሽን ታኒ ስአስ። ");
INSERT INTO gofe_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","ታ ናአዉ፥ ሀእ ታኒ ነዉ ኦደይሳ ሎይꬃ ስአ። ");
INSERT INTO gofe_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","ዉድያ ግዶ ባዳ ናምኡ ሞꬎ ዴሻ ማራታ ታዉ ኤካዳ ያ። ታኒ ነ አዋስ ማልኦ ካꬅ እ ዶሰይሳዳ ኦꬃዳ ካꬃና። ");
INSERT INTO gofe_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","ነ አዋይ ሀይቃናፐ ስን ምድ ነና አንጃና መላ እያዉ አꬃ” ያጋሱ። ");
INSERT INTO gofe_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","ሽን ያይቆብ ባ አይዉ፥ “ታ እሻ ኤሳዌ ቦላ እክሰይ ደኤስ ሽን ታ ቦላይ ሊቆ። ");
INSERT INTO gofe_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","ታ አዋይ ታና ኦይክ በእድ ታኒ እያ ጭምዳባ ዳንኮ፥ ታኒ አንጁዋ ግሾ ባደꬅ ታ ቦላ ኤሀናይሳ ኤርኪ?” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","እያ አይያ፥ “ታ ናአዉ፥ ሄ ባደꬃይ ታና ጋኮ። ታኒ ነዉ ኦደይሳ ኦꬃ፥ ባዳ ዴሻ ማራታ ታዉ ኤካዳ ያ” ያጋሱ። ");
INSERT INTO gofe_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","ኤህድ ባ አየስ እምን እያ አይያ ማልኦ ካꬅ እያ አዋይ ዶሰይሳዳ ኦꬃዳ ካꬃሱ። ");
INSERT INTO gofe_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","ሄሳፈ ጉየ፥ እርብቃ ባይራ ናአ ኤሳዌ ማኦ ሎኡዋ ኤሀዳ ያይቆባ ማይዛሱ። ");
INSERT INTO gofe_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","ቃስ ሄ ዴሻታ እትያ እያ ኩሽያነ እያ ሊቆ ቆꬍያ ማይዛሱ። ");
INSERT INTO gofe_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","ባ ካꬅዳ ማልኦ ካꬃነ ኡይꬃ ባ ናአ ያይቆባስ እማሱ። ");
INSERT INTO gofe_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","ያትን፥ እ ባ አዋኮ ገልድ፥ “ታ አዋዉ” ያግስ። እካ፥ “ዬ፥ ታ ናአዉ፥ ኔኒ ኦኔ?” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","ያይቆብ ባ አዋ፥ “ታኒ ነ ባይራ ናአ ኤሳዌ። ኔኒ ታና ኪትዳይሳዳ ታኒ ኦꬃስ፤ ሀእ ደንዳ ኡታዳ፥ ታኒ ሻንካታ ኤህዳይሳፈ ማዳ፥ ታና አንጃ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","ይሳቅ ባ ናአ፥ “ታ ናአዉ፥ ዋታ ኤለሳዳ ደማዲ?” ያግድ ኦይችስ። ያይቆብ፥ “ጎዳይ፥ ነ ፆሳይ ታዉ ጊግስስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","ይሳቅ ያይቆባ፥ “ታ ናአዉ፥ ኔኒ ቱማ ታ ናአ ኤሳዌኮ ታ ነና ኦይካ በአና አነ ሀ ሺቃ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","ያይቆብ ባ አዋኮ ሺቅን ኦይክ በእድ፥ “ነ ቃላይ ያይቆባ ቃላ ሽን ኩሸይ ኤሳዌ ኩሽያ ዳኔስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","እያ ኩሸይ እያ እሻ ኤሳዌ ኩሽያዳ እክሰራ ደእያ ግሾ፥ ሻክድ ኤርቦና እያ አንጅስ። ");
INSERT INTO gofe_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","እያ፥ “ቱማ ኔኒ ታ ናአ ኤሳዌ?” ያግድ ዛር ኦይችስ። እካ፥ “ኤ፥ ታና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","ያትን እ፥ “ታ ናአዉ፥ ታኒ ነ ሻንካታ ኤህዳባፐ ማዳ ነና አንጃና መላ አነ ሀ አꬃ” ያግስ። ያይቆብ አꬅን ምስ፥ ቃስ እያዉ ዎይነ ኤህን ኡይስ። ");
INSERT INTO gofe_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","ሄሳፈ ጉየ፥ እያ አዋ ይሳቅ፥ “ታ ናአዉ፥ ሀ ሺቃዳ ታና ዬራ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","ያይቆብ ሺቅድ እያ ዬርስ። ይሳቅ እያ ማኡዋ ስንግ ስእድ፥ “ታ ናአ ፔኖይ ጎዳይ አንጅዳ ጎሻዳ ሳዌስ። ");
INSERT INTO gofe_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","ፆሳይ ሳሎ አካነ ሳአ ሽጫ፥ ካꬅነ ዎይነ ዳርስድ ነዉ እሞ። ");
INSERT INTO gofe_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","ካዎተꬃት ነዉ ሃረቶ፥ አሳይ ነዉ ጉልባቶ። ኔኒ ነ እሻታስ ጎዳ ግዳ፥ ነ አየ ሼሻት ነዉ ጉልባቶ። ነና ባደይሳት ባደትዳባ ግዶ፥ ነና አንጀይሳት አንጀትዳባ ግዶ” ያግድ አንጅስ። ");
INSERT INTO gofe_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","ይሳቅ ያይቆባ አንጅድ ኦንግዳፐ ጉየ፥ ያይቆብ ባ አዋ ስንꬃፈ ቡሮ ከይያ ዎደ ኤሳዌይ ሻንካፈ ፑቱ ግስ። ");
INSERT INTO gofe_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","እካ ቃስ ማልኦ ካꬅ ካꬅድ ባ አዋስ አꬅድ፥ “ታ አዋዉ፥ ዳንዳ ኡታዳ ታ ሻንካትዳባፐ ማ፥ ያታዳ ታና አንጃ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","ይሳቅ፥ “ነ ኦኔ?” ያግድ ኦይችስ። እካ፥ “ታኒ ነ ባይራ ናአ ኤሳዌ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","ይሳቅ ዳጋምድ ኮኮርሸ፥ “ያትን ዶአ ሻንካትዳይሳፈ ታዉ አꬅዳይ ኦኔ? ታኒ ሀእ ኔኒ ያና ስንꬃን ማዳ፥ እያ አንጃስ። እካ ቱማ አንጀትዳይሳ ግዳና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","ኤሳዌይ ባ አዋ ቃላ ስእዳ ዎደ ባ ቃላ ꬎቁ ኦꬅድ፥ ዳሮ ኢታ ዬሆ ዬክሸ፥ “ታ አዋዉ፥ ታናካ አንጃ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","ሽን እ፥ “ነ እሻይ ጭምድ ነ አንጁዋ ኤክ ድግስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","ኤሳዌይ፥ “እ ኤርድ ያይቆባ (ጭመይሳ) ግድ ሱንትስ። እ ታና ጭምሽን ሀይስ ናምአንꬆ፥ ካሰ ታ ባይራተꬃ ኤክስ፥ ሀእ ቃስ ታ አንጁዋ ኤክስ” ያግስ። ያትን፥ “ኔኒ ታዉ አንጁዋፈ አይኮካ አሻብኪ?” ያግድ ኦይችስ። ");
INSERT INTO gofe_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","ይሳቅ ኤሳዌ፥ “ታኒ እያ ነዉ ጎዳ ኦꬃስ። እያ እሻታ ኡባታካ እያዉ አይለ ኦꬃስ። ቃስ ታኒ ካꬃንነ ዎይነን እያ ምንꬃስ። ያትን፥ ታ ናአዉ፥ ነዉ ታ አይ ኦꬆ?” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","ኤሳዌይ ባ አዋ፥ “ታ አዋዉ፥ ነዉ እስ አንጆ ፃላል ደኢ? ታ አዋዉ፥ ታናካ ቃስ አንጃ” ያግስ። ሄሳፈ ጉየ፥ ኤሳዌይ ባ ቃላ ꬎቁ ኦꬅድ ዬክስ። ");
INSERT INTO gofe_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","እያ አዋ ይሳቅ ዛሪድ፥ “ነ ደእያ በሳይ ሀ ሳአ ዱረተꬃፈ ሃሆ፥ ሳሎ አክካ ነዉ ዎና። ");
INSERT INTO gofe_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","ኔኒ ነ ማሻን አቃና፥ ነ እሻስ ሃረታና። ሽን ኔኒ እያራ ኤቀትያ ዎደ እያ ቃምባራ ነ ጋናፈ ሆላና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","ያይቆባ እያ አዋይ አንጅዳ ግሾ፥ ኤሳዌይ ባ ኡሎን እያ ሞርክስ። እ ባ ዎዛናን፥ “ታ አዋይ ሀይቃናዉ ማትስ። እ ሀይቅዳ መላ ታ እሻ ያይቆባ ዎꬋና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","ሽን እርብቃ ሄ ባ ባይራ ናአ ኤሳዌ ቃላ ስእዳ ግሾ፥ ባ ካሎ ናአ ያይቆባ ፄግሳ ኤሀዳ፥ “ነ እሻ ኤሳዌይ ነና ዎꬍድ ሃሉዋ ከሳናዉ ሀልቼስ። ");
INSERT INTO gofe_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","ሀያና ታ ናአዉ፥ ታኒ ነዉ ኦደይሳ ኦꬃ። ደንዳዳ ካራነን ደእያ ታ እሻ ላባኮ ባቃታ። ");
INSERT INTO gofe_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","ነ እሻ ሀንቆይ እርፃና ጋካናዉ ጉꬃ ዎደ እያራ ደኣሻ። ");
INSERT INTO gofe_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","ነ እሻ ይሎይ ዎꬍያ ዎደነ ኔኒ እያ ቦላ ኦꬅዳባ እ ዶግያ ዎደ ታኒ ኪታዳ ነና ኤሀና። ታኒ እስ ጋላስ ህንተ ናምኣፈካ መላ አታናዉ ኮይከ” ያጋሱ። ");
INSERT INTO gofe_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","ሄሳፈ ጉየ፥ እርብቃ ይሳቃኮ፥ “ኤሳዌይ ኤክዳ ህተታ ማጫ ናይታ ጋሶን ታኒ ታ ደኡዋ ሻተታስ። ቃስ ያይቆብካ ሀይሳꬆ ህተታ ማጫ ናይታፐ ማቾ ኤክኮ፥ ታዉ ሀይቆይ ሎኦ” ያጋሱ። ");
INSERT INTO gofe_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","ሄሳ ግሾ፥ ይሳቅ ያይቆባ ፄግድ፥ “ካናነ ቢታ ማጫ ናይታፐ ማቾ ኤኮፋ። ");
INSERT INTO gofe_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","ደንዳዳ ነ አየ አዋ ባቱኤላኮ ማሰጰፆመ ቢታ ባዳ ያፐ ነ አየ እሻ ላባ ማጫ ናይታፐ ማቾ ኤካ። ");
INSERT INTO gofe_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","ኡባ ዳንዳእያ ፆሳይ ነና አንጆ፥ እ ነዉ ናይታ እሞ፥ ዳሮ ደረ ግዳና ጋካናስ እ ነና ዳርሶ። ");
INSERT INTO gofe_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","ኔኒ ሀእ በተተꬃን ኡትዳ ሀ ቢታ ነባ ኦꬃና መላ ነዉነ ነ ሼሻስ ፆሳይ አብራሃመ አንጁዋ እሞ” ያግ አንጅድ ኪትስ። ");
INSERT INTO gofe_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","ያግድ ይሳቅ ያይቆባ የድስ። ያይቆብ ማሰጰፆመ ቢታ ላባኮ ብስ። ላቢ ያይቆባነ ኤሳዌ አየ እርብቃ እሻነ አራመ አድያ ባቱኤላ ናአ። ");
INSERT INTO gofe_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","ይሳቅ ያይቆባ አንጅድ ማሰጰፆመ ቢታፈ ማቾ ኤካና መላ እያ የድዳይሳ፥ እ ያይቆባ አንጅዳ ዎደ፥ “ካናነ ማጫስ ኤኮፋ” ግድ ኪትዳይሳነ፥ ");
INSERT INTO gofe_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","ያይቆብ ባ አዋስነ ባ አየስ ኪተትድ ማሰጰፆመ ቢታ ብዳይሳ፥ ኤሳዌይ ኤርስ። ");
INSERT INTO gofe_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","ኤሳዌይ ሄሳን ካናነ ቢታ ማጫስ ባ አዋ ይሳቅ አይ መላ እፅያኮ ኤርስ። ");
INSERT INTO gofe_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","ሄሳ ግሾ፥ ኤሳዌይ አብራሃመ ናአ እስማኤላኮ ብድ፥ እያ ናእዉ ማህላቶ፥ ነባዮታ ምችዉ፥ ባ ማቸታ ቦላ ጉጅድ ኤክስ። ");
INSERT INTO gofe_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","ያይቆብ በርሳበፐ ካራነ ባናዉ ከይስ። ");
INSERT INTO gofe_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","እ፥ እስ በሲ ጋክያ ዎደ አው ዉልን፥ ቃማ ያን አቅስ። ሄ በሳን ደእያ ሹቻታፐ እሱዋ ቦርኮትድ ሄ በሳን ꬍስክስ። ");
INSERT INTO gofe_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","እ አሙሆ አሙህድ ኮዶ እሶይ ሳአን ኤቅን ፄራይ ሳሎ ጋክዳይሳነ፥ ፆሳ ኪታንቾት እያ ቦላራ ፑደ ከየይሳታነ ዱገ ዎይሳታ በእስ። ");
INSERT INTO gofe_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","ሄ ኮዱዋስ ፄራን ጎዳይ ኤቅድ፥ “ታኒ ጎዳ፥ ነ አዋ አብራሃመ ፆሳ፥ ይሳቃ ፆሳ፥ ሀ ኔኒ ዝንእዳ ቢታ ነዉነ ነ ሼሻስ እማና። ");
INSERT INTO gofe_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","ነ ሼሻ ሳአ ሻፈዳ ዳርሳና። ኔኒ ዶሎሀ ባጋ፥ ዉሎሀ ባጋ፥ ፑደሀ ባጋነ ዱገሀ ባጋ ዳልጋና። ቢታ ቦላ ደእያ አሳ ኡባይ ነ ባጋራነ ነ ሼሻ ባጋራ አንጀታና። ");
INSERT INTO gofe_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","ታኒ ኔራ ደአይስ። ኔኒ ብያ በሳ ኡባን ታኒ ነና ናጋና። ታኒ ነና ሀ ቢታ ጉየ ዛራዳ ኤሀና። ታኒ ነዉ ኦꬃና ግዳይሳ ፖላና፥ ነና አግከ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","ያይቆብ ꬍስኮፈ ባርክድ፥ “ታ ኤራብከፈ አትሽን፥ ቱማ ጎዳይ ሀ በሳን ደኤስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","እ ባብድ፥ “ሀ በሳይ ዋን ያሽ! ሀ በሳይ ፆሳ ኬꬅፈ አትሽን፥ ሀራሶ ግደና። ሀይስ ሳሎ ፐንገ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","ዎንተꬃ ጋላስ ዎንታ ጉራ ያይቆብ ደንድድ፥ ፆሳስ ዱማያናዉ ባ ቦርኮትዳ ሹቻ ኤክድ ቱሳꬆ ኤስድ እያ ቦላ ዛይተ ትግስ። ");
INSERT INTO gofe_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","ያይቆብ ሄ በሳ ቤተለ (ፆሳ ኬꬅ) ግድ ፄግስ። ሽን ሄ ካታማይ ሄሳፈ ካሰ ሎዛ ጌተቴስ። ");
INSERT INTO gofe_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","ያይቆብ፥ “ታ ብያ ኦግያን ነ ታና ናግኮ፥ ታዉ ካꬅነ ማኦ እምኮ፥ ");
INSERT INTO gofe_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ነ ታና ታ አዋ ሶ ሳሮ ዛርኮ፥ ነ ታ ፆሳ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","ታኒ ዱማያናዉ ቱሳꬆ ኤስዳ ሀ ሹቻይ ፆሳ ኬꬃ ግዳና። ቱማ ኔኒ ታዉ እምያባ ኡባፈ ታማፈ እሱዋ ነዉ እማና” ያግድ ፆሳስ ጫቅስ። ");
INSERT INTO gofe_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","ሄሳፈ ጉየ፥ ያይቆብ ደንድድ፥ ብድ ዶሎሀ ባጋ አሳ ቢታ ጋክስ። ");
INSERT INTO gofe_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","ያንካ ደምባ በሳን ሃꬃ ኦላ ደምስ። ሄꬑ ዶርሳ ዉደት ሄ ሃꬃ ኦላ ማታን ደኦሶና። ዉደ ኡባይ ሃ ኡየይ ሄ ኦላፈ። ሄ ሃꬃ ኦላ ዶና ጎርድያ ሹቻይ ግታ። ");
INSERT INTO gofe_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","ዶርሳ ዉደ ኡባይ ያ ሺቅኮ፥ ዉድያ ሄመይሳት ሃꬃ ኦላ ዶናፐ ሄ ሹቻ ጎንዶርስድ ዉድያ ሃ ኡሾሶና። ኡሽ ስሚድ ሄ ሹቻ ኦላ ዶናን ዛር ዎꬆሶና። ");
INSERT INTO gofe_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","ያይቆብ ኤንታኮ፥ “ህንተ አዉፐ ይደቲ?” ያግድ ኦይችስ። ኤንትካ፥ “ኑኒ ካራነፐ ይዳ” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","እ፥ “ናኮራ ናአ ናኣ ላባ ኤሬቲ?” ያግድ ኦይችስ። “ኤ፥ እያ ኤሮስ” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","ያይቆብ ኤንታ፥ “እ ሎኦ ደኢ?” ያግድ ኦይችስ። “ኤ፥ ሎኦ፥ እያ ናእዉ ራሄሎ ዶርሳታ ላጋዳ ያሮ ህን በአ” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","ያይቆብ ኤንታኮ፥ “ሄኮ፥ ሀእ አው ꬎቃን ደኤስ። ዉደ መሄይ ሶ ስምያ ዎደይ ቡሮ ጋክቤና፥ ዶርሳ ኡሽ ኤፍድ ሄምተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","ሽን ኤንቲ፥ “ዉደ ኡባይ ሺቅን ሹቻ ሃꬃ ኦላ ዶናፐ ጎንዶርሳና ጋካናስ ኑ ኡሻናዉ ዳንዳኦኮ። ሄሳፈ ጉየ፥ ሹቻ ጎንዶርስድ ዶርሳታ ኡሻና” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","እ ቡሮ ኦድሽን፥ ላባ ናእያ ራሄላ ዶርሳታ ሄምያ ግሾ፥ ባ አዋ ዶርሳታ ላጋ ኤካዳ ጋካሱ። ");
INSERT INTO gofe_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","ያይቆብ ባ አየ እሻ ላባ ናእዉ ራሄሎ ላባ ዶርሳታ ላጋዳ ያሮ በእዳ ዎደ ብድ ኦላ ዶናፐ ሹቻ ጎንዶርስድ ዶርሳታ ሃ ኡሽስ። ");
INSERT INTO gofe_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","ያይቆብ ራሄሎ ዬርድ፥ ኡፋይሳን ባ ቃላ ꬎቁ ኦꬅድ ዬክስ። ");
INSERT INTO gofe_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","ያይቆብ፥ “ታኒ ነ አዋ ምቸ እርብቃ ናአ” ያግድ እዉ ኦድስ። ሄሳ ግሾ፥ እያ ዎፃ ባዳ ባ አዋስ ኦዳሱ። ");
INSERT INTO gofe_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","ላቢ ባ ምቸ ናአ ያይቆባ ዩሳ ስእዳ መላ ሞካናዉ ዎፅድ ብስ። እያ እድም ዬርድ ባ ሶ ኤፍስ። ያን ያይቆብ ሀንዳባ ኡባ ላባስ ኦድስ። ");
INSERT INTO gofe_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","ላቢ እያ፥ “ኔኒ ቱማ ታ አሾነ ታ ሱꬅ” ያግስ። ያይቆብ እያራ እስ አጌና ኩመꬅ ኡትስ። ");
INSERT INTO gofe_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","ሄሳፈ ጉየ፥ ላቢ ያይቆባ፥ “ኔኒ ታዉ ዳቦ ግድዳ ግሾ፥ ታዉ መላ ጮ ኦꬃነዬ? አነ ታ ነዉ አይ ቃንፃናዉ ኮሽያኮ ታዉ ኦዳ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","ላባስ ናምኡ ማጫ ናይት ደኦሶና። ባይረ ሱንꬃይ ልያ፥ ካልያ ቃስ ራሄሎ ጌተታዉሱ። ");
INSERT INTO gofe_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","ልያ አይፈራ ጩጫ፥ ሽን ራሄላ የገልስነ ማላ ሎኦ። ");
INSERT INTO gofe_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","ያይቆብ ራሄሎ ዶስድ፥ “ታኒ ነ ካሎ ናኤ ራሄል ግሾ ነዉ ላፑን ላይꬅ ኦꬃና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","ላቢ፥ “እዮ ሀራ አሳስ እማናፐ ነዉ እሞይ ሎኦ፥ ነ ታራ ሀይሳን ደአ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","ሄሳ ግሾ፥ ያይቆብ ራሄሎ ኤካናዉ ላፑን ላይꬅ ኦꬅስ። ሽን እ እዮ ዳሮ ዶስያ ግሾ፥ እያዉ ጉꬃ ጋላስ ዳንስ። ");
INSERT INTO gofe_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","ሄሳፈ ጉየ፥ ያይቆብ፥ “ታ ማችዉ ታዉ እማ፥ ታ ላይꬃይ ዉርስ ታኒ እዮ ኤካናዉ ኮያይስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","ሄሳ ግሾ፥ ላቢ አሳ ኡባ ፄግድ ያጋኖ ከስስ። ");
INSERT INTO gofe_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","ሽን ሳእ ቃምን ላቢ ባ ናእዉ ልያ ኤፍድ ያይቆባስ እሚስ። ያይቆብ እዮ ኤክስ። ");
INSERT INTO gofe_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","ቃስ ላቢ ባ አይልዉ ዛላፋ ባ ናኤ ልያስ አይለ ኦꬅድ እሚስ። ");
INSERT INTO gofe_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","ሳእ ዎንትን እ ፄልያ ዎደ ሄኮ ልያ። ያይቆብ፥ “ሀይስ ኔኒ ታ ቦላ ኦꬅዳይስ አይቤ? ታኒ ነዉ ኦꬅዳይ ራሄል ግሾሳ ግደነዬ? ታና አይስ ጭማድ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","ላቢ እያኮ፥ “ኑ ቢታን ባይሪያ ደእሽን ካልዉ አዝናስ እመይስ ዎጋ ግደና። ");
INSERT INTO gofe_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","ምሽራተꬃን ኢራ ሳምንታ ኦንግኮ፥ ቃስ ካልውካ ታኒ ነዉ እማና። ሄሳፈ ጉየ፥ ሀራ ላፑን ላይꬅ ታዉ ኦꬃሳ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","ያይቆብ ኦዳ ማእድ ሳምንታ ኢራ ኦንግስ። ሄሳፈ ጉየ፥ ላቢ ባ ናእዉ ራሄሎ እያዉ እሚስ። ");
INSERT INTO gofe_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","ቃስ ላቢ ባ አይልዉ ባሎ ባ ናኤ ራሄልስ አይለ ኦꬅድ እሚስ። ");
INSERT INTO gofe_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","ያይቆብ ራሄሎካ ኤክስ። ራሄሎ ልያፐ አꬅድ ዶስስ። ሀራ ላፑን ላይꬅ ላባስ ኦꬅስ። ");
INSERT INTO gofe_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","ጎዳይ ልያ ራሄልꬆ ዶሰታቦናሮ በእድ፥ እዉ የሎ ኡሉዋ ዶይስ። ሽን ራሄላ ናአ የሎና ጋምአሱ። ");
INSERT INTO gofe_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","ልያ ቃንꬃታዳ አደ ናአ የላሱ። እያ፥ “ጎዳይ ታ መቱዋ በእስ፥ ሀእ ታና ታ አዝናይ ዶሳና” ጋዳ ሄ ናአ ሮቤላ ጋዳ ሱንꬃሱ። ");
INSERT INTO gofe_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","እያ ናምአንꬆ ቃንꬃታዳ አደ ናአ የላሱ። እያ፥ “ጎዳይ ታኒ ዶሰታቦናይሳ በእዳ ግሾ፥ ታዉ ሀይሳካ ጉጅስ” ጋዳ ስሞና ጋዳ ሱንꬃሱ። ");
INSERT INTO gofe_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","እያ ሄꬓንꬆ ቃንꬃታዳ አደ ናአ የላሱ። እያ፥ “ታኒ እያዉ ሄꬑ አደ ናይታ የልዳ ግሾ፥ ታ አዝናይ ሀእ ታራ ሲቆን ዋፀታና” ጋዳ እያ ሌወ ጋዳ ሱንꬃሱ። ");
INSERT INTO gofe_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","እያ ሀራ ቃንꬃታዳ አደ ናአ የላሱ። እያ፥ “ሀእ ታኒ ጎዳ ጋላታና” ጋዳ እያ ሱንꬃ ይሁዳ ጋዳ ሱንꬃሱ። ሄሳፈ ጉየ፥ የሎ ኤቃሱ። ");
INSERT INTO gofe_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","ራሄላ ያይቆባስ ናይታ የሎናይሳ በአዳ ባ ምችዉ ቃናታሱ። ሄሳ ግሾ፥ ያይቆባ፥ “ታዉ ናአ እማ፥ እፅኮ ታኒ ሀይቃና” ያጋሱ። ");
INSERT INTO gofe_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","ያይቆብ ራሄሎ ሀንቀትድ፥ “ታና ነዉ የሎ እማናዉ ዎይኮ ድጋናዉ ፆሰ ጋድዬ?” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","እያ፥ “ታ ጋꬍንድዉ ባሎ ህኖ በአ። እያ ታ ግሾ የላና መላ ኔኒ ኢራ አቃ፥ ያንኮ፥ ታኒ እ ባጋራ ናአ ደማና” ያጋሱ። ");
INSERT INTO gofe_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","ባ ጋꬍንድዉ ባሎ ማቾ ኦꬅድ ኤካና መላ እያዉ እማሱ። ");
INSERT INTO gofe_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","ባላ ቃንꬃታዳ አደ ናአ ያይቆባስ የላሱ። ");
INSERT INTO gofe_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","ያትን ራሄላ፥ “ፆሳይ ታዉ ፕርድስ፥ ታ ዎሳካ ስእድ ታዉ አደ ናአ እሚስ” ያጋዳ ሄ ናአ ዳነ ጋዳ ሱንꬃሱ። ");
INSERT INTO gofe_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","ራሄል ጋꬍንድያ ባላ ቃንꬃታዳ ያይቆባስ ናምአንꬆ አደ ናአ የላሱ። ");
INSERT INTO gofe_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","ራሄላ፥ “ታኒ ታ ምቸራ ዎልቃማ ባፀ ባፀታዳ ፆናስ” ያጋዳ ሄ ናአ ንፍታለመ ጋዳ ሱንꬃሱ። ");
INSERT INTO gofe_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","ልያ የሎ ኤቅዳይሳ በአዳ፥ ባ ጋꬍንድያ ዛላፋ ያይቆባስ ማቾ ኦꬃዳ እማሱ። ");
INSERT INTO gofe_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","ልያ ጋꬍንድያ ዛላፋ አደ ናአ ያይቆባስ የላሱ። ");
INSERT INTO gofe_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","ልያ፥ “ላ ሀይስ አይብ ሎኦ ቃደ!” ያጋዳ፥ ሄ ናአ ጋደ ጋዳ ሱንꬃሱ። ");
INSERT INTO gofe_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","ልያ ጋꬍንድያ ዛላፋ ያይቆባስ ናምአንꬆ አደ ናአ የላሱ። ");
INSERT INTO gofe_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","ልያ፥ “ታና ዳሮ ኡፋይሴስ፤ ማጫስ ኡባይ ታና ኡፋይትያሮ ጋና” ጋዳ ሄ ናአ አሴራ ጋዳ ሱንꬃሱ። ");
INSERT INTO gofe_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","ግስተ ጫክያ አጌናን ሮቤል ጋደ ብድ እንኮያ ምꬃ አይፈ ደምድ ባ አየ ልያስ ኤክድ ይስ። ራሄላ ልያኮ፥ “ነ ናአይ ኤህዳ እንኮያ ምꬃ አይፍያፐ ታዉ እማ” ያጋሱ። ");
INSERT INTO gofe_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","ሽን ልያ፥ “ታ አዝና ኔኒ ዎልቃን ኤክዳይስ ግዶና እፅን ሀእ ቃስ ታ ናአ እንኮያ ሚꬃ አይፍያ ኤካኔ?” ያጋሱ። ራሄላ፥ “ነ ናአ እንኮያ ታዉ እምኮ፥ ያይቆብ ሀች ቃማ ኔራ አቆ” ያጋሱ። ");
INSERT INTO gofe_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","ሄ ጋላስ ኦማርስ ያይቆብ ባዞፈ ያ ዎደ ልያ እያ ሞካናዉ ከያዳ፥ “ኔኒ ታራ አቃናዉ ኮሼስ፤ ታኒ ታ ናአ እንኮያ አይፈያን ነና ሻማስ” ያጋሱ። ሄሳ ግሾ፥ እ ሄ ቃማ ኢራ አቅስ። ");
INSERT INTO gofe_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","ፆሳይ ልያ ዎሳ ስእስ። እያ ቃንꬃታዳ እቻሻንꬆ አደ ናአ ያይቆባስ የላሱ። ");
INSERT INTO gofe_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","ልያ፥ “ታኒ ታ አይልዉ ታ አዝናስ እምዳ ግሾ፥ ፆሳይ ሄሳ ታዉ ቃንፅስ” ያጋዳ ሄ ናአ ይሳኮራ ጋዳ ሱንꬃሱ። ");
INSERT INTO gofe_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","ልያ ሀራ ቃንꬃታዳ ኡሱፑንꬆ አደ ናአ ያይቆባስ የላሱ። ");
INSERT INTO gofe_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","ልያ፥ “ፆሲ ታዉ አልኦ እሞታ እሚስ። ታኒ ታ አዝናስ ኡሱፑን አደ ናይታ የልዳ ግሾ፥ ሀእ እ ታና ቦንቻና” ያጋዳ ሄ ናአ ዛብሎና ጋዳ ሱንꬃሱ። ");
INSERT INTO gofe_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","ሄሳፈ ጉየ፥ እስ ማጫ ናአ የላሱ፥ እዮ ዲና ጋዳ ሱንꬃሱ። ");
INSERT INTO gofe_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","ፆሳይ ራሄሎ ቆፕስ። እ ዎሳ ስእድ እ የሎ ኡሉዋ ዶይስ። ");
INSERT INTO gofe_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","እያ ቃንꬃታዳ አደ ናአ የላሱ፤ “ፆሳይ ታ ዬላ ቃርስ። ");
INSERT INTO gofe_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","ጎዳይ ታዉ ሀራ አደ ናአካ ጉጆ” ያጋዳ ሄ ናአ ዮሰፋ ጋዳ ሱንꬃሱ። ");
INSERT INTO gofe_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","ራሄላ ዮሰፋ የልዳፐ ጉየ፥ ያይቆብ፥ “ታኒ ታ አዋ ቢታ ስማዳ ባና ታና ሞይዛ። ");
INSERT INTO gofe_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","ታኒ ኤንታ ግሾ ነዉ ኦꬅዳ ታ ማቸታነ ታ ናይታ እማ። ታኒ ባና፥ ታኒ ነዉ አይ መላ ኦሶ ኦꬅዳኮ ኔኒ ኤራሳ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","ሽን ላቢ እያኮ፥ “ታኒ ነዉ እስባ ኦዳይስ፥ ጎዳይ ነ ጋሶን ታና አንጅዳይሳ ታኒ ታ ፆሳፈ ኤራስ። ");
INSERT INTO gofe_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","ነ ዳሞዝያ ታዉ ኦዳ፥ ታኒ ነዉ ቃንፃና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","ያይቆብ፥ “ታኒ ነዉ ዋታ ኦꬅዳኮ፥ ነ መሄትካ ዋን የለትዳኮ ኔኒ ኤራሳ። ");
INSERT INTO gofe_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","ታኒ ያናፐ ካሰ ነዉ ደእያ ጉꬃይ ሀእ ሎይꬅ ዳርስ። ጎዳይ ነና ታኒ አꬍዳ በሳ ኡባን አንጅስ። ሽን ሀእ፥ ታኒ ታ ሶ አሳስ ኦꬃና ዎደ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","ላቢ፥ “ያትን ታኒ ነዉ አይ እሞ?” ያግድ እያ ኦይችስ። ያይቆብ፥ “ታዉ አይኮካ እሞፋ፥ ኔኒ ታዉ እስባ ኦꬃና ግድኮ፥ ታኒ ነ ዉድያ ሀእካ ሄማናነ ናጋና። ");
INSERT INTO gofe_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","ታኒ ሀች ነ ዉደ ኡባ ግዶራ አꬋና። ሄሳን ነ ዶርሳታፐ ዋንጩዋ ዎይኮ ጋዛ፥ ካሬꬃ ማራዘታ ኡባ፥ ዴሻፐ ጋዛነ ዋንጮ ኡባ ታኒ ሻካና፥ ኤንቲ ታ ዳሞዘ ግዶ። ");
INSERT INTO gofe_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","ሄሳ ግሾ፥ ታ ፅሎተꬃይ ነ ታዉ ቃንፅዳ ዳሞዝያ በአናዉ ያ ዎደ ታዉ ማርካታና። ታ ዴሻፐ ጋዛ ዎይኮ ፑንጫረ ግዶናባይ ዎይኮ ካሬꬅ ግዶና አይ ዶርሳት ታ ማታን በንትኮ፥ ካይሶተትዳዳ ታይባ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","ላቢ፥ “ኤሮ፥ ኔኒ ግዳይሳዳ ግዶ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","ሽን ሄ ጋላሳን ላቢ ካላደ ዎይኮ ጋዛ ግድዳ ኮሌ ኡባ፥ ዋንጮ ዎይኮ ጋዛ ግድዳ ማጫ ዴሻ ኡባ፥ ቦꬃ ዋንጮ ዴሻታነ ካሬꬃ ዋንጮ ዶርሳታ ኡባ ከስድ ባ አደ ናይታ ሄንꬅስ። ");
INSERT INTO gofe_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","ያትድ ሄ ዉድያ ሄꬑ ጋላሳ ኦግያ ያይቆባፐ ሃስድ ኤፍስ። ሽን ያይቆብ አትዳ ላባ ዉድያ ሄምስ። ");
INSERT INTO gofe_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","ያይቆብ ኦንጋፍረፐ፥ ባርኤፈኔ ላዉዘ ምꬃፈ ፃምአ ከስድ፥ ፖቁዋ ፖቅድ ግዶ ቦꬃ ባጋ ቃርድ ሽሎይስ። ");
INSERT INTO gofe_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","ዉደይ ሃ ኡያናዉ ያ ዎደ ጎንገን ዉድያ ስንꬃን ፖቅዳ ፃምአ ዎꬅስ። ብራይስ ከይዳይሳት ሃ ኡያናዉ ይድ፥ ");
INSERT INTO gofe_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","ሄ ፃምአታ ስንꬃን ብራይሰቶሶና። ሄ ብራይስዳይሳት ካላደ፥ ዋንጮነ ጋዛ ማራታ የልዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","ያይቆብ ዴሻ ማራታነ ዶርሳ ዉድያፐ ሻክድ ዱማ ዎꬅስ። አትዳ ዉድያ ካላደነ ካሬꬅ ግድያ ላባ መህያኮ ዛሪድ ኤስስ። ያትድ ላባ ዉድያራ ጋꬆና ባ ዉድያ ዱማይድ ዳርስስ። ");
INSERT INTO gofe_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","ዉድያፐ ጎባ ማጫት ብራይሳስ ከይያ ዎደ ሄ ፃምአታ ማታን ብራይሰታና መላ ያይቆብ ሄ ፃምአታ ሃꬃ ጎንገን መሄታ ስንꬃን ዎꬄስ። ");
INSERT INTO gofe_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","ሽን መሄት ላፋ ግድኮ ኤንታ ስንꬃን ፃምአ ዎና። ሄሳ ግሾ፥ ላፋ መሄት ላባባ ግድን ጎባት ያይቆባባ ግድዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","ሄሳዳ ኦꬅድ ያይቆብ ዳሮ ዱረትድ፥ ዳሮ ዉድያ፥ ማጫ አይለታነ አደ አይለታ፥ ዳሮ ግማለታነ ሀረታ ሃርስ። ");
INSERT INTO gofe_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","ላባ አደ ናይት፥ “ያይቆብ ኑ አዋባ ኡባ ኤክድግስ። ሀ ሻሎ ኡባ ኑ አዋባፐ ደምስ” ያግሽን ያይቆብ ስእስ። ");
INSERT INTO gofe_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","ያይቆብ ላባ ሶምኦይ እያዉ ካሰ መላ ግዶናይሳ በእስ። ");
INSERT INTO gofe_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","ሄ ዎደ ጎዳይ ያይቆባ፥ “ኔኒ ነ አዋታ ቢታ፥ ነ ዳቦታኮ ጉየ ስማ። ታኒ ኔራ ግዳና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","ያይቆብ ራሄሎነ ልያ ባ ዉደይ ሄመትያ በሳ ያና መላ ኪትድ ፄግስስ። ");
INSERT INTO gofe_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","እ ኤንታኮ፥ “ህንተ አዋ ሶምኦይ ታዉ ካሰ መላ ግዶናይሳ ታኒ በአይስ። ሽን ታ አዋ ፆሳይ ታራ ደኤስ። ");
INSERT INTO gofe_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","ታኒ ታ ኩመꬃ ዎልቃን ህንተ አዋስ ኦꬅዳይሳ ህንተ ኤሬታ። ");
INSERT INTO gofe_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","ሽን ህንተ አዋይ ታና ጭምድ፥ ታ ዳሞዝያ ታሙ ቶሆ ላምስ። ግድኮካ ፆሳይ ታና እ ቆሆናዳ ድግስ። ");
INSERT INTO gofe_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","እ፥ ‘ፑንጫረት ነ ዳሞዘ ግዶ’ ግን ዉደ ኡባይ ፑንጫረ የልስ። ቃስ እ፥ ‘ካላደት ነ ዳሞዘ ግዶ’ ግን ዉደ ኡባይ ካላደ የልስ። ");
INSERT INTO gofe_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","ፆሳይ ሄሳን ህንተ አዋ መህያ ዎꬅ ኤክድ ታዉ እሚስ። ");
INSERT INTO gofe_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“መሄት ብራይሳስ ከይያ አጌናን ታኒ እስ አሙሆ አሙሀስ። ሄ አሙሁዋን ታኒ ፄልያ ዎደ መህያ ብራይስያ ዴሻ ኡርገት ካላደ፥ ፑንጫረነ ጋዛ። ");
INSERT INTO gofe_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","ፆሳ ኪታንቾይ አሙሆን ታና፥ ‘ያይቆባ’ ያግስ። ታኒ፥ ‘ዬ’ ጋዳ ኮያስ። ");
INSERT INTO gofe_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","እካ፥ ‘ꬎቁ ጋዳ መህያ ብራይስያ ዴሻ ኡርገ ኡባ ካላደ፥ ፑንጫረነ ጋዛ በአ። ላቢ ነ ቦላ ኦꬅያባ ኡባ ታኒ በእዳ ግሾ ሄሳ ኦꬃስ። ");
INSERT INTO gofe_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","ኔኒ ኤስዳ ሹቻ ዛይተ ትያዳ ታዉ ጫቅዳ ቤተለ ፆሳይ ታና። ሀእ ደንዳዳ ሀ ቢታፈ ከያ። ጉየ ነ የለትዳ ቢታ ስማ’ ግስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","ሄሳፈ ጉየ፥ ራሄልራነ ልያራ “ኑ አዋባፐ ኑና ጋክያባይ አይቤ? ");
INSERT INTO gofe_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","እ ኑና አላጋዳ ፄሌስ ግደኔ? እ ኑና ባይዝ ኤክስ። ባይዝ ኤክዳባ ኡባ ምድ ꬋይስስ። ");
INSERT INTO gofe_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","ፆሳይ ኑ አዋፐ ዎꬅ ኤክዳ ሻሎ ኡባይ ቱማካ ኑባነ ኑ ናይታባ። ሄሳ ግሾ፥ ፆሳይ ነዉ ኦድዳባ ኡባ ኦꬃ” ያግ ዛርዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","ያይቆብ ካናነ ቢታን ደእያ ባ አዋ ይሳቃኮ ባናዉ ደንድስ። እ ባ ናይታነ ባ ማቸታ ግማለ ቶግስስ። ዉደ ኡባ ላግድ፥ ማሰጰፆመን ደእሸ ሺሽዳ ሻሎ ኡባ ኤክድ ብስ። ");
INSERT INTO gofe_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","ላቢ ባ ዶርሳታ እክስያ ቃንፃናዉ ብዳሽን፥ ራሄላ ባ አዋ ሶ ኤቃ ምስለታ ካይሶታሱ። ");
INSERT INTO gofe_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","ቃስ ያይቆብ አራመ አድያ ላባስ ባ ቡሳ ኦዶና እፅድ ጭምስ። ");
INSERT INTO gofe_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","እ ባዉ ደእያባ ኡባ ኤክድ ኤለስድ ኤፍራፂሳ ሻፋ ፕንድ፥ ደረይ ዳርያ ጋላዳ ቢታ ብስ። ");
INSERT INTO gofe_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","ሄꬑ ጋላሳፐ ጉየ፥ ያይቆቢ ባቃትድ ብዳይሳ ላቢ ስእስ። ");
INSERT INTO gofe_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","ባ ዳቦታ ባራ ኤክድ፥ ላፑን ጋላሳ ኦገ ያይቆባ ጌዶ ካልድ ደረይ ዳርያ ጋላዳ ቢታን እያ ጋክስ። ");
INSERT INTO gofe_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","ሄ ዎደ ፆሳይ ቃማ ሶረ ላባኮ አሙሆን ቆንጭድ፥ “ኔኒ ያይቆባ ቦላ ኢታባ ግድን ሎኦባ፥ አይብባካ ኦደትኮ ነና ኤራ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","ላቢ ጋክያ ዎደ ያይቆብ ደረይ ዳርያ ጋላዳ ቢታን ዱንካነ ቶክድ ኡትስ። ላብካ ዳቦታራ ያን ዱንካንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","ሄሳፈ ጉየ፥ ላቢ ያይቆባ፥ “ኔኒ ሀይሳዳ ታና አይስ ጭማዲ? ታ ማጫ ናይታካ ኦላን ድኤትዳባዳ አይስ ላጋ ከሳዲ? ");
INSERT INTO gofe_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","ኔኒ አይስ ቆሳን ታፐ ከሳ ኤካዳ ታና ጭማዲ? ታኒ ነና ኡፋይሳንነ የꬃን፥ ካራቦንነ ዲꬃን ሞይዛና መላ አይስ ታዉ ኦዳብኪ? ");
INSERT INTO gofe_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","ኔኒ ሀር አቶሽን፥ ታ ናይታ ናይታነ ታ ማጫ ናይታ ታኒ ዬራ ኤኮና መላ ድጋዳሳ። ኔኒ ኢታ ኦꬃዳሳ። ");
INSERT INTO gofe_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","ታኒ ነና ገናናዉ ታዉ ዎልቅ ደኤስ ሽን ነ አዋ ፆሳይ ዝነ ቃማ ታኮ፥ ‘ያይቆባ ቦላ ኢታባ ግድን ሎኦባ አይብባካ ኦደቶናዳ ነና ኤራ’ ያግድ ታዉ ኦድስ። ");
INSERT INTO gofe_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","ሀእ ኔኒ ነ አዋ ሶ ባናዉ ዳሮ ላሞትዳ ግሾ ከያዳሳ። ሽን ታ ሶ ኤቃ ምስለታ አይስ ካይሶታዲ?” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","ያይቆብ ላባ፥ “ኔኒ ነ ናይታ ታፐ ዎልቃን ዎስሳ ኤካነኮነ ጋዳ ቆፕዳ ግሾ ያያዳ ሀይሳዳ ኦꬃስ። ");
INSERT INTO gofe_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","ሽን ነ ሶ ኤቃ ምስለታ ኤክዳ አስ ኦናካ ኔኒ ደምኮ፥ ሄ ኡራይ ሀይቆ። ኑ ዳቦታ ስንꬃን ነባ ግድዳባ ኡባ ኮያዳ ኤካ” ያግስ። ያይቆብ ራሄላ ባ አዋ ሶ ኤቃ ምስለታ ካይሶትዳይሳ ኤርቤና። ");
INSERT INTO gofe_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","ሄሳ ግሾ፥ ላቢ ያይቆባ ዱንካንያ ግዶ፥ ልያ ዱንካንያ ግዶነ ናምኡ አይለታ ዱንካንያ ግዶ ገልድ ኮይስ። ሽን አይኮካ ደምቤና። ልያ ዱንካንያፐ ከይድ፥ ራሄል ዱንካንያ ገልስ። ");
INSERT INTO gofe_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","ራሄላ ሶ ኤቃ ምስለታ ኤካዳ ግማለ ኮራ ጋርሳን ቆሳዳ እያ ቦላ ኡታሱ። ላቢ ዱንካንያን ደእያባ ኡባ ፕልግድ ኮይስ። ሽን አይኮካ ደምቤና። ");
INSERT INTO gofe_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","ራሄላ ባ አዋ፥ “ታ ጎዳዉ፥ ታና ሀንቀቶፋ። ታኒ ነዉ ደንዳ ኤቃናዉ ዳንዳእከ፥ ታ ኩሸ መቶራ ደአይስ” ያጋሱ። እ ኮይድ ሶ ኤቃ ምስለታ ደምቤና። ");
INSERT INTO gofe_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","ያይቆብ ይሎትድ ላባኮ፥ “ታኒ አይ ኢሳድና? ሀይሳ ኔኒ ታና ካላናዉ ታ አይ ቆሆ ኦꬃድና? ");
INSERT INTO gofe_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","ሀእ ኔኒ ታ ሚሸ ኡባ ፕልጋዳ ኮያዳሳ። ነ ሶ ኤቃ ምስለታፐ አይ ደማዲ? ኤንቲ ኑ ናምአ ግዶን ፕርዳና መላ ነ ዳቦታ ስንꬃንነ ታ ዳቦታ ስንꬃን ሀይሳን ዎꬃ። ");
INSERT INTO gofe_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“ታኒ ኔራ ላታሙ ላይꬅ ኩመꬅ ደአስ። ነ ዶርሳትነ ዴሻት አዉጫይቦኮና ዎይኮ ነ ዉድያፐ እሱዋካ ቆታዳ ማብከ። ");
INSERT INTO gofe_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","ዶእ ምዳ ጋዉፃካ ታ ነዉ ኤሀ ኤርከ፤ ታኒ ታፐ ጭጋይስ። ጋላስ ዎይኮ ቃማ ካይሶተትዳይሳታ ቃንፅሳሳ። ");
INSERT INTO gofe_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","ጋላሳ ሱላን፥ ቃማ ሜጎን ታኒ ቆሄታስ። ማራ ꬍስኮ ꬍስካ ኤርከ። ");
INSERT INTO gofe_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","ታኒ ሀይሳዳ ሀናዳ ነ ሶን ላታሙ ላይꬅ ደአስ። ታማነ ኦይዱ ላይꬅ ነ ናምኡ ማጫ ናይታ ግሾ፥ ኡሱፑን ላይꬅ ነ መህያ ግሾ ነዉ ኦꬃስ። ሽን ኔኒ ታ ዳሞዝያ ታሙ ቶሆ ላማዳሳ። ");
INSERT INTO gofe_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","ታ አዋ ፆሳይ፥ አብራሃመ ፆሳይ፥ ይሳቃ ፆሳይ ታራ ግዶናባ ግድያኮ፥ ስይ ባይና ኔኒ ታና መላ ኩሸ ከሳ የዳዳሳ። ሽን ፆሳይ ታ መቱዋነ ታ ዳቡርሳ በእድ ዝነ ቃማ ነና ሀንቅስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","ላቢ ዛሪድ ያይቆባ፥ “ማጫሳት ታ ማጫ ናይታ፥ ኤንታ ናይት ታ ናይታ፥ ሀ መሄይካ ታ መህያ፥ ኔኒ በእያ ኡባይ ታባ። ሀች ሀ ማጫ ናይታ ቦላነ ኤንታ ናይታ ቦላ አይ ኦꬃናዉ ዳንዳአይና? ");
INSERT INTO gofe_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","አነ ሃያ፥ ኔራነ ታራ ዎላ አነ ጫቆስ። ሄስ ነ ግዶንነ ታ ግዶን ማርካ ግዶ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","ሄሳ ግሾ፥ ያይቆብ እስ ሹቹ ኤክድ ቱሳꬆ ኤስስ። ");
INSERT INTO gofe_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","ባ ዳቦታ፥ “ሹቹ ሺሽተ” ያግስ። ኤንቲ ሹቹ ሺሽድ ኬልዶሶና። ሄ ኬላ ማታን ካꬅ ምዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","ላቢ ሄ ኬላ፥ ይጋር-ሳሀዱታ ግድ ሱንꬅስ። ያይቆብ ቃስ እያ ጋላዳ ግድ ሱንꬅስ። ");
INSERT INTO gofe_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","ላቢ፥ “ሀ ኬላይ ኔፐነ ታፐ ግዶን ሀች ማርካ” ያግስ። ሄሳ ግሾ፥ እያ ሱንꬃይ ጋላዳ ጌተትስ። ");
INSERT INTO gofe_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","ላቢ፥ “ኑኒ እሶይ እሱዋፈ ሃክድ ደእያ በሳን ጎዳይ ነናነ ታና ናጎ” ግድ ሄ በሳ ምፅጳ ግድ ሱንꬅስ። ");
INSERT INTO gofe_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","ላቢ፥ “ኔኒ ታ ማጫ ናይታ ናቅኮ፥ ዎይኮ ኔኒ ታ ማጫ ናይታ ቦላ ሀራ ማቾ ነ ኤክኮ፥ ታ ኤሮና እፅኮካ ነ ግዶንነ ታ ግዶን ፆሳይ ማርካ ግደይሳ አኬካ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","ላቢ ቃስካ፥ “ኬለትዳ ሹቻይነ ታኒ ነ ግዶንነ ታ ግዶን ኤስዳ ሹቻ ቱሳይ ሀይስሽ። ");
INSERT INTO gofe_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","ታኒ ሀ ኬላፐ ነና ገናናዉ ኔኮ ካንꬆናዳ፥ ነካ ታና ገናናዉ ሀ ኬላፐነ ሀ ሹቻ ቱሳፈ ሀ አꬎናዳ ሀ ኬላይነ ሀ ሹቻ ቱሳይ ማርካ። ");
INSERT INTO gofe_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","አብራሃመ ፆሳይ፥ ናኮራ ፆሳይ፥ ኤንታ አዋ ፆሳይ፥ ኑ ግዶን ፕርዶ” ያግስ። ያይቆብ ባ አዋ ይሳቃ ፆሳ ሱንꬃን ጫቅስ። ");
INSERT INTO gofe_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","ያይቆብ ዙማ ቦላ ያርሾ ያርሽስ። ባ ዳቦታ ካꬅ ማናዉ ፄግስ። ኤንቲ ምድ ዙማ ቦላ አቅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","ዎንተꬃ ጋላስ ጉራ ላቢ ደንድድ ባ ናይታ ናይታነ ባ ማጫ ናይታ አንጅድ፥ ዬርድ ባ ሶ ስምስ። ");
INSERT INTO gofe_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","ያይቆብ ደንድድ ባ ኦግያ ብሽን ፆሳ ኪታንቾት እያራ ጋሄትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","ያይቆብ ኤንታ በእዳ ዎደ “ሀይሳቲ ፆሳ ኦላንቾታ” ያግድ፥ ሄ በሳ ማሀናይማ (ናምኡ ጉታ) ግድ ሱንꬅስ። ");
INSERT INTO gofe_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","ያይቆብ ኤዶመ ቢታን ሳይረ ግያ በሳን ደእያ ባ እሻ ኤሳዌኮ ኪታ ባፐ ስን ኪትስ። ");
INSERT INTO gofe_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","እ ኤንታ፥ “ህንተ ታ ጎዳ ኤሳዌስ ጋናባይ ሀይሳ፥ ‘ታኒ ነ አይለይ ያይቆብ ሀእ ጋካናው ላባ ማታን ጋምአስ። ");
INSERT INTO gofe_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","ታዉ ሚዝ፥ ሀረይ፥ ዶርስነ ዴሽ፥ አደ አይለትነ ማጫ አይለት ደኦሶና። ሀእ ታኒ ሀ ኪታ ታ ጎዳ ስንꬃን ሳባ ደማንድናሻ ጋዳ ኪታስ ያግስ’ ያግተ” ያግድ ኪትስ። ");
INSERT INTO gofe_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","ኪተትዳይሳት ያይቆባኮ ስሚድ፥ “ኑኒ ነ እሻ ኤሳዌኮ ብዳ። እካ ቃስ ኔራ ጋሄታናዉ ዬስ። እያራ ኦይዱ ፄቱ አሳይ ደኦሶና” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","ያይቆብ ዳሮ ባብድ ባራ ደእያ አሳ ናምኡ ጩጋን ሻክስ። ባ ዶርሳ፥ ዴሻ፥ ሚዛነ ግማለታ ናምኡ ጩጋን ሻክስ። ");
INSERT INTO gofe_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","እ፥ “ኤሳዌይ ይድ እስ ጩጋ ኦልያባ ግድኮ፥ አትዳ ጩጋይ ከስ ኤካና” ግድ ቆፕስ። ");
INSERT INTO gofe_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","ሄ ዎደ ያይቆብ ሀይሳዳ ያግድ ዎስስ፥ “አቤት ጎዳዉ፥ ታ አዋ አብራሃመ ፆሳዉ፥ ታ አዋ ይሳቃ ፆሳዉ፥ ታና፥ ‘ነ ቢታ፥ ነ ዳቦታኮ ስማ፥ ታኒ ነዉ ሎኦባ ኦꬃና ግዳይሶ፥ ታና ስአርክ’፥ ");
INSERT INTO gofe_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","ኔኒ ነ አይልያስ ኬህዳባስነ አማነተꬃ ኡባስ ታኒ በሶና አስ። ታኒ ዮርዳኖሰ ሻፋ ፕንያ ዎደ ታዉ እስ ፃምአ ፃላል ደኤስ፤ ሽን ሀእ ታኒ ናምኡ ጩጋ ጎዳ ግዳስ። ");
INSERT INTO gofe_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","ታኒ ነና ዎሳይስ ታ እሻ ኤሳዌ ኩሸፐ ታና አሻ። እ ይድ፥ ታናነ አየታ ኤንታ ናይታራ ꬋይሶና አገና ጋዳ ያያይስ። ");
INSERT INTO gofe_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","ሽን ኔኒ ታና፥ ‘ታኒ ነዉ ቱማ ሎኦባ ኦꬃና። ታኒ ነ ሼሻ ታይባናዉ ዳንዳኤቶና አባ ሻፈዳ ኦꬃና’ ግዳይሳ ቆፓ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","ሄ ጋላስ ቃማ እ ያን አቅስ። ባዉ ደእያባ ኡባፈ ባ እሻ ኤሳዌስ እማናባ ቆርድ ከስስ። ");
INSERT INTO gofe_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","15","እ፥ ናምኡ ፄቱ ማጫ ዴሻታነ ላታሙ ዴሻ ማራዘታ፥ ናምኡ ፄቱ ማጫ ዶርሳታነ ላታሙ ዶርሳ ማራዘታ፥ ሀስታሙ ꬋንꬅያ ግማለታ ኤንታ ማራታራ፥ ኦይታሙ ማጫ ሚዛታ፥ ታሙ ኮርማ ቦራታ፥ ላታሙ ማጫ ሀረታነ ታሙ አደ ሀረታ ቆርድ ከስስ። ");
INSERT INTO gofe_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","ሄሳታ ዉደን ዉደን ሻክድ ባ አይለታስ እምድ፥ “ታፐ ስን ብድ ዉድያ ዉድያፐ ሃሆን ሃሆን ላግተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","ስንꬃን ካለይሳ፥ “ታ እሻይ ኤሳዌይ ኔራ ጋሄትድ፥ ‘ኔኒ ኦደሴ? ኔኒ አዉ ባይ? ነ ስንꬃን ደእያ መሄ ኡባይ ኦደባዬ?’ ያግድ ኦይችኮ፥ ");
INSERT INTO gofe_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","ነ እያኮ፥ ‘ሀይሳቲ ነ አይልያ ያይቆባሳ፥ እ ታ ጎዳ ኤሳዌስ እማናዉ የድዳይሳታ። እካ ኑፐ ጉየራ ዬስ’ ያጋ” ያግድ ኪትስ። ");
INSERT INTO gofe_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","ቃስ ናምአንꬁዋ፥ ሄꬓንꬁዋነ ዉድያ ካልያ ሀራታ ኡባ፥ “ህንተ ኤሳዌራ ጋሄትያ ዎደ ሀይሳዳ ጌታ፤ ");
INSERT INTO gofe_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","‘ነ አይልያ ያይቆብ ኑፐ ጉየራ ዬስ’ ጎና አጎፍተ” ያግድ ኪትስ። እ፥ “ታኒ እማናዉ ስን የድዳይሳን እያ እርፅሳና። ኦን ኤር ሄሳፈ ጉየ፥ ታኒ እያራ ጋሄትያ ዎደ እ ታና ሞክ ኤካና” ያግድ ቆፕስ። ");
INSERT INTO gofe_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","ሄሳ ግሾ፥ ባ እማናባ ባፐ ስን የድስ። ሽን እ ባ ሁጰን ሄ ጋላስ ቃማ ያን አቅስ። ");
INSERT INTO gofe_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","ሄ ቃማ ያይቆብ ደንድድ፥ ባ ናምኡ ማቸታ፥ ባ ናምኡ አይለታ፥ ባ ናይታ ታማነ እሶታ ኤክድ፥ ያቦቃ ሻፋ ፕንስ። ");
INSERT INTO gofe_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","እ ኤንታ ሻፋ ፕንꬅ ስሚድ ባዉ ደእያባ ኡባ ፕንꬅድ የድስ። ");
INSERT INTO gofe_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","ሽን ያይቆብ ባርካ ጉየ አትስ። ሄ ዎደ እስ አስ ሳእ ዎንታና ጋካናስ እያራ ባፀትሸ አቅስ። ");
INSERT INTO gofe_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","ሄ ኡራይ እያ ፆናናዉ ዳንዳኦናይሳ በእዳ ዎደ ያይቆባስ ቡልፅያ መቀꬃ ቦችን፥ እያ ቡልፀይ ከሱዋፐ ከይስ። ");
INSERT INTO gofe_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","ያትን ኡራይ እያ፥ “ሳእ ዎንታና ሀንያ ግሾ፥ ታና የዳ” ያግስ። ሽን ያይቆብ፥ “ኔኒ ታና አንጆና ነና የድከ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","ኡራይ፥ “ነ ሱንꬃይ ኦኔ?” ያግድ ኦይችስ። እ ዛሪድ፥ “ያይቆባ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","ኡራይ፥ “ኔኒ ፆሳራነ አሳራ ባፀታዳ ፆንዳ ግሾ፥ ህዛፐ ነ ሱንꬃይ ያይቆባ ጌተቶፎ፥ እስራኤለ (ፆሳራ ባፀትስ) ጌተቶ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","ያይቆብ ኡራ፥ “ነ ሱንꬃይ ኦኔ?” ያግድ ኦይችስ። ሽን ኡራይ፥ “ኔኒ ታ ሱንꬃ አይስ ኦይቻይ?” ያግድ እያ አንጅስ። ");
INSERT INTO gofe_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","ሄሳ ግሾ፥ ያይቆብ፥ “ታኒ ፆሳ ሶምኦን በአስ ሽን ፓፃ ደአይስ” ያግድ፥ ሄ በሳ ጵንኤላ (ፆሳ ሶምኦ) ግድ ሱንꬅስ። ");
INSERT INTO gofe_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","እ ጵንኤላፐ ደንድያ ዎደ እያ ቦላ ፃልቀይ ዶልስ። እያ ቡልፀ ከሳይ ሳክያ ግሾ ዶጌስ። ");
INSERT INTO gofe_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","ያይቆባ ቡልፀይ ዎድረ አሹዋ ማታን ቦሸትዳ ግሾ፥ እስራኤለ አሳይ መሄስ ቡልፀ አሾ ሀች ጋካናዉ ሞኮና። ");
INSERT INTO gofe_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","ያይቆብ ꬎቁ ግድ ፄልያ ዎደ ኤሳዌይ ባ ኦይዱ ፄቱ አሳራ የይሳ በእስ። ሄሳ ግሾ፥ ናይታ ልያስ፥ ራሄልስነ ናምኡ አይለታስ ሻክ እሚስ። ");
INSERT INTO gofe_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","አይለታነ ኤንታ ናይታ ስንꬃን፥ ልያነ እ ናይታ ኤንታ ጌዶን፥ ራሄሎነ ዮሰፋ ዉርሰꬃን ዎꬅስ። ");
INSERT INTO gofe_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","ሽን እ ባዉ ስን አꬍድ ባ እሻኮ ማትሸ ሳአ ጋክ ጋክ ላፑንቶሆ ዝግስ። ");
INSERT INTO gofe_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","ሽን ኤሳዌይ እያራ ጋሄታናዉ ዎፅ ይድ እያ ቆꬍያ ቆምድ ዬርስ። ናምአይካ ዬክዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","ኤሳዌይ ꬎቁ ግድ ፄልድ ማጫሳታነ ናይታ በእድ፥ “ሀ ኔራ ደኤይሳት ኦናንቴ?” ያግድ ኦይችስ። ያይቆብ፥ “ታ ጎዳዉ፥ ሀይሳቲ ፆሳይ ነ አይልያስ ባ ኬሀተꬃን እምዳ ናይታ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","አይለት ባንታ ናይታራ ሺቅድ እያዉ ዝግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","ካልድ ልያራነ እ ናይታራ ይድ ዝግዶሶና። ዉርሰꬃን ዮሰፋራነ ራሄልራ ይድ ዝግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","ኤሳዌይ፥ “ሀ ስንꬃን ብሸ ታራ ጋሄትዳ ዉደይ ኡባይ አይቤ?” ያግድ ኦይችስ። ያይቆብ፥ “ታ ጎዳዉ፥ ሄስ ታኒ ነ ስንꬃን ሳባ ደማናዉ የድዳይሳታ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","ሽን ኤሳዌይ፥ “ታ እሻዉ፥ ታዉ ግድያ ሻሎይ ደኤስ፥ ነባይ ነዉ ግዶ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","ያይቆብ፥ “ሀያና፥ ሀእ ታኒ ነ ስንꬃን ሳባ ደምዳባ ግድኮ፥ ሀ ታኒ እመይሳ ኤካ። ኔኒ ታና ሞካ ኤክዳ ግሾ፥ ታ ነ ሶምኡዋ በኤይስ ፆሳ ሶምኦ በኤይሳ መላ። ");
INSERT INTO gofe_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","ታኒ ነዉ ኤህዳ ሀ እሞታ ኤካ። ፆሳይ ታዉ ኬህ እምዳ ግሾ ኩምስ” ያግስ። ያይቆብ ዎስድ አጎና እፅዳ ግሾ፥ ኤሳዌይ እያ እሞታ ኤክስ። ");
INSERT INTO gofe_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","ኤሳዌይ፥ “አነ የꬋ፥ ታኒ ኔራ እስፈ ባና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","ሽን ያይቆብ፥ “ታ ጎዳዉ፥ ናይት ሹጎ ግደይሳ ኤራሳ። ቃስ ታኒ ጋሎ ማራታ ꬋንꬅያ ዶርሳታነ ሚዛ ናጋናዉ ኮሼስ። አሳይ ኤንታ ሀር አቶሽን፥ እስ ጋላስ ምንꬅ ላግኮ፥ መሄ ኡባይ ሀይቃና። ");
INSERT INTO gofe_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","ሄሳ ግሾ፥ ታ ጎዳዉ፥ ነ አይለታፐ ስንꬃታዳ ባ። ታኒ ሳይረን ታ ጎዳ ጋካናስ፥ ታ ስንꬃን ደእያ መህያነ ናይታ ሄመꬃ መላ ሎዳን ካላዳ ታ ጎዳ ታኒ ኤዶመን ጋካና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","ኤሳዌይ፥ “ያንኮ፥ ታኒ ታ አሳፐ ጉꬃራ ነዉ አሾ” ያግስ። ሽን ያይቆብ፥ “ኮሸና፤ ታኒ ታ ጎዳ ስንꬃን ሳበትዳይስ ታዉ ግዳና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","ሄሳ ግሾ፥ ኤሳዌይ ሄ ጋላስ ኦገን ዎꬍድ ሳይረ ስምስ። ");
INSERT INTO gofe_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","ሽን ያይቆብ ሱኮታ ብስ። ያን ባዉ ኬ ኬፅስ፥ ባ መሄታስ ሻቃራ ሻቃርስ። ሄሳ ግሾ፥ ሄ በሳ ሱኮታ (ኩያ ዎይኮ ጋባ) ግድ ሱንꬅስ። ");
INSERT INTO gofe_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","ያይቆብ ማሰጰፆመፐ ስሚድ ካናነ ቢታን ደእያ ሴከማ ካታማ ሳሮን ጋክስ። እ ሄ ካታማስ ስንꬃ ባጋራ ዱንካነ ቶክድ ኡትስ። ");
INSERT INTO gofe_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","ባ ዱንካንያ ቶክዲ ኡትዳ ጋድያ ሴከማ አዋ ሀሞራ ናይታፐ እስ ፄቱ ብራ ሳንትመን ሻምስ። ");
INSERT INTO gofe_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","ያን ያርሾ በሲ ጊግስድ፥ “ጎዳ፥ እስራኤለ ፆሳ” ግድ ሱንꬅስ። ");
INSERT INTO gofe_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","ልያ ያይቆባስ የልዳ ናእያ ዲና፥ ሄ ዎደ ካናነ ማጫሳታ በአናዉ ከያሱ። ");
INSERT INTO gofe_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","ሄ ቢታ ሃርያ ህወ አድያ ሀሞራ ናአ ሴከም እዮ በእድ፥ ዳፍድ ኢስስ። ");
INSERT INTO gofe_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","እያ ዎዛናይ ያይቆባ ናእዉ ዲናስ ቃትስ። እ እዉ ምሸትዳ ግሾ ሎኦ ቃላራ እዮ ኦድስስ። ");
INSERT INTO gofe_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","ሴከም ባ አዋ ሀሞራ፥ “ታዉ ሀ ናእዉ ማቾ ኦይቻርክ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","ያይቆብ ባ ናእዉ፥ ዲና፥ አዝን ዳፍዳይሳ ስእዳ ዎደ እያ አደ ናይት መሄራ ባዞን ደኦሶና። ሄሳ ግሾ፥ ኤንቲ ያና ጋካናስ ስእ ግስ። ");
INSERT INTO gofe_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","ሄሳፈ ጉየ፥ ሴከማ አዋ ሀሞር ያይቆባ ኦድሳናዉ ይስ። ");
INSERT INTO gofe_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","ያይቆባ አደ ናይት ባዞፈ ይድ ሄሳ ስእዶሶና። ኤንቲ ሴከም ያይቆባ ናእዉ ዳፍድ፥ ኢስድ እስራኤለ ዬላይዳ ግሾ ዳሮ ይሎትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","ሽን ሀሞር ኤንታኮ፥ “ታ ናአይ ሴከም ህንተ ናኤስ ዳሮ ምሸቴስ፥ ሀያና እዮ እያዉ ማቾ እመርከት። ");
INSERT INTO gofe_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","ኑራ ኤከትተነ ገለትተ፥ ህንተ ማጫ ናይታ ኑስ እምተ፥ ኑ ማጫ ናይታካ ህንተዉ ኤክተ። ");
INSERT INTO gofe_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","ህንተ ኑ ግዶን ዳናዉ ዳንዳኤታ። ቢታይ ዳሮ ዳልጋ፥ እያ ኦꬅድ ዛልእድ ህንተዉ አቆ ደማናዉ ዳንዳኤታ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","ሄ ዎደ ሴከም ዲና አዋነ እ እሻታ፥ “ታኒ ህንተ ስንꬃን ሳበትኮ፥ ህንተ ኮይያባ አይብባ ግድኮካ እማና። ");
INSERT INTO gofe_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","ህንተ ምሽራ ናኤስ እሞታነ ኮይታ ህንተ ኮይዳ መላ ታና ኦይችተ። ታኒ ህንተ ታና ኦይችዳባ ኡባ እማና። ሽን ታኒ ማቻናዉ ናእዉ ታዉ እመርከት” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","ባንታ ምችዉ ዲና ሴከም ቱንስዳ ግሾ፥ ያይቆባ አደ ናይት ሴከማስነ እያ አዋ ሀሞራስ ዎርዶትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","ኤንታኮ፥ “ኑኒ ሄሳ መላ ፓላባ ኦꬃናዉ ዳንዳኦኮ፥ ኑኒ ኑ ምችዉ ቃፃረትቦና አሳስ እሞኮ፥ ሄስ ኑና ካዉሽያባ። ");
INSERT INTO gofe_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","ህንተ ኑስ እስባ ኤሮ ጊኮ ኑ ህንተዉ ኤሮ ጋና። ሄስካ፥ ህንተ ቢታ አደ አሳ ኡባይ ቃፃረትድ ኑዳ ሀንኮ፥ ");
INSERT INTO gofe_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","ኑኒ ኑ ማጫ ናይታ ህንተዉ እማናዉ ኤሮ ጋና። ህንተ ማጫ ናይታካ ኑስ ኤካና። ኑኒ ህንተ ግዶን ደእድ ህንተራ እስ አሰ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","ሽን ህንተ ቃፃረታናዉ ኤሮ ጎና እፅኮ፥ ኑኒ ኑ ምችዉ ኤክ ባና” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","ያትን ሀ ኤንቲ ግዳባይ ሀሞራስነ እያ ናአ ሴከማስ ሎኦ ዳንስ። ");
INSERT INTO gofe_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","ሄ ፓንꬃይ ባ አዋ ኬꬃን ደእያ ኡባፈ አꬍድ ቦንቸትዳ ግሾ ኮይዳባ ኦꬃናዉ እያዉ ማት ደኤስ። ያይቆባ ናእዉ ዳሮ ዶስዳ ግሾ፥ ኤንቲ ግዳባ ኦꬃናዉ ጉየ ግቤና። ");
INSERT INTO gofe_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","ሄ ዎደ ሀሞርነ እያ ናአይ ሴከም ባንታ ካታማ ዳባባ ብድ፥ ባንታ ካታማ አሳስ ሀይሳዳ ያግድ ኦድዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“ሀ አሳት ኑራ ስጋ ደኦሶና። ቢታይ ዳሮ ዳልጋ ግድያ ግሾ ኤንቲ ሀ ቢታን ጎዮ ዛልኦ። ኤንታ ማጫ ናይታካ ኑኒ ኤካና፥ ኤንትካ ኑ ማጫ ናይታ ኤኮና። ");
INSERT INTO gofe_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","ሽን ኑራ ኤንቲ እስ አሳዳ ደአናዉ ኑኒ እስባ ኤሮ ጋናዉ ኮሼስ። ሄስካ፥ ኤንቲ ቃፃረትዳይሳዳ ኑ አደ አሳ ኡባይ ቃፃረታናይሳ። ");
INSERT INTO gofe_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","ኑኒ ሄሳዳ ኦꬅኮ፥ ኤንታ መሄይነ፥ ኤንታ አቆ ኡባይ ኑባ ግደኔ? ሄሳ ግሾ፥ አነ ኑኒ ኤንቲ ገይሳ ኤሮ ጎስ። ኤንትካ ኑ ግዶን ደአና” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","ካታማ ዳባባ ሺቅዳ አሳት ኡባይ ሀሞራስነ እያ ናአ ሴከማስ፥ “ኤሮ” ግዶሶና። ያትን ሄ ካታማ አደ አሳት ኡባይ ቃፃረትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","ሄꬓንꬆ ጋላስ፥ ኤንቲ ኡባይ ባንታ ቃፃራ ማዱንꬃ ሳከትሽን፥ ያይቆባ አደ ናይታፐ ናምአይ፥ ዲና እሻት፥ ስሞናራነ ሌወራ ባንታ ማሻ ኤክድ ኦንካ ኤሮና ካታማ ገልድ አደ አሳ ኡባ ዎꬍዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","ሀሞራነ እያ ናአ ሴከማ ማሻን ዎꬍድ፥ ባንታ ምችዉ ዲና ሴከማ ኬꬃፈ ኤክ ብዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","ያይቆባ ሀራ አደ ናይት አሀታ ቦላ ገልድ ባንታ ምችዉ ዲና ቱንስዳ ካታማ ኡባ ቦንቅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","ኤንታ ዶርሳ ዉድያ፥ ሚዛ ዉድያ፥ ሀርያ፥ ካታማ ግዶን ደእያባነ ጋፃን ደእያባ ኡባ ኤክዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","ኤንታ ኬꬃን ደእያ አቁዋ ኡባ፥ ኤንታ ናይታ ኡባነ ማጫሳታ ኡባ ድእዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","ያይቆብ ስሞናነ ሌወ፥ “ህንተ ታ ቦላ ግታ መቶ ኤህደታ። ሀ ቢታን ደእያ ካናነትነ ፓርዘት ታና እፃና። ኑኒ ታይቦን ጉꬃ፥ ኤንቲ እስፈ ግድድ ታ ቦላ ደንድኮ፥ ታንነ ታ ሶ አሳይ ꬋያና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","ሽን ኤንቲ፥ “ያትን፥ እ ኑ ምችዉ ላይማ ማጫሳዳ ኦꬃናዉ በሲ?” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","ሄሳፈ ጉየ፥ ፆሳይ ያይቆባ፥ “ደንዳዳ ፑደ ቤተለ ከያዳ ያን ደአ። ኔኒ ነ እሻ ኤሳዌፐ ባቃትዳ ዎደ ነዉ ቆንጭዳ ፆሳስ ያን ያርሾ በሲ ጊግሳ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","ሄሳ ግሾ፥ ያይቆብ ባ ሶ አሳነ እያራ ደኤይሳታ ኡባ፥ “ህንተ ግዶን ደእያ አላጋ ፆሳታ ድግተ። ህንተና ጌሽተ፥ ህንተ ማኡዋ ላምተ። ");
INSERT INTO gofe_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","ሀይሳፈ ደንድድ ፑደ ቤተለ ቦስ። ታ መቱዋ ጋላስ ታዉ ስእዳ፥ ታኒ ብዳ በሳ ኡባን ታራ ግድዳ ፆሳስ ታኒ ያን ያርሾ በሲ ጊግሳና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","ኤንቲ ባንታዉ ደእያ አላጋ ፆሳታ ኡባነ ባንታ ሀይꬃን አꬅዳ ዎርቃታ ኡባ ከስድ ያይቆባስ እምዶሶና። ያይቆብ ሄሳታ ሴከማን ደእያ ዎላ ጋርሳን ሞግስ። ");
INSERT INTO gofe_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","ሄሳፈ ጉየ፥ ያይቆብነ እያ አደ ናይት ደንድድ ብያደ ኤንታ ዩሹዋን ደእያ አሳ ቦላ ፆሳ ያሻይ ዎꬍዳ ግሾ ኤንታና ካልድ ኦይካናዉ ኦንካ ዳንዳእቤና። ");
INSERT INTO gofe_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","ያይቆብነ እያራ ደእያ አሳ ኡባይ ካናነ ቢታን ደእያ ቤተለ ጌተትያ ሎዛ ጋክዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","ያን እ ያርሾ በሲ ጊግስስ። እ ሄ በሳ ኤል-ቤተለ (ቤተለ ፆሳ) ግድ ሱንꬅስ። እ ባ እሻፐ ባቃትድ ብያ ዎደ ፆሳይ እያዉ ቆንጭዳይ ሄ በሳና። ");
INSERT INTO gofe_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","እርብቃ ድችያ ድቦራ ያን ሀይቃሱ። ቤተለፐ ጋርሳራ ደእያ ዎላ ጋርሳን እያ ሞገታሱ። ሄሳ ግሾ፥ ሄ ምꬃ ሱንꬃይ አሎን-ባኩተ (ዬሆ ዎላ) ጌተትስ። ");
INSERT INTO gofe_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","ያይቆብ ማሰጰፆመፐ ስምዳፐ ጉየ፥ ፆሳይ እያዉ ዛር ቆንጭድ እያ አንጅስ። ");
INSERT INTO gofe_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","ፆሳይ፥ “ነ ሱንꬃይ ያይቆባ። ሽን ህዛፐ ኔኒ ያይቆባ ጌተታካ፥ ነ ሱንꬃይ እስራኤለ ጌተታና” ያግድ እያ “እስራኤለ” ግድ ሱንꬅስ። ");
INSERT INTO gofe_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","ቃስ ፆሳይ ያይቆባ፥ “ታኒ ኡባ ዳንዳእያ ፆሳ። ኔኒ የለታ፥ ዳራ። ደረይነ ካዎተꬃት ኔፐ ከዮ። ካዎትካ ነ ጉልባታፐ ከዮ። ");
INSERT INTO gofe_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","ታኒ አብራሃመስነ ይሳቃስ እምዳ ቢታ፥ ነዉ እማና። ኔፐ ጉየ ታኒ ሀ ቢታ ነ ሼሻስ እማና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","ፆሳይ እያራ ኦደትዳ በሳፈ ፑደ ከይስ። ");
INSERT INTO gofe_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","ያይቆብ ፆሳይ እያራ ኦደትዳ በሳን ቆፍስያ ሹቻ ማላ ኤስድ እያ ቦላ ዎይንያነ ዛይተ ትግስ። ");
INSERT INTO gofe_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","ያይቆብ ፆሳይ እያራ ኦደትዳ በሳ “ቤተለ” ግድ ሱንꬅስ። ");
INSERT INTO gofe_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","ኤንቲ ሄሳፈ ጉየ፥ ቤተለፐ ደንድድ ብዶሶና። ኤንቲ ኤፍራታ ጋካናዉ ጉꬁ አትሽን፥ ራሄሎ እቀꬅ ኦይክን ዳሮ ዋየታሱ። ");
INSERT INTO gofe_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","እቀꬃይ እዮ ዋይስዳ ዎደ እዮ የልስያራ፥ “ባቦፋ፤ ሀይስካ አደ ናአ” ያጋሱ። ");
INSERT INTO gofe_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","ሽን እያ ሀይቆስ ማታዳ ሸምፖይ ከያና ሀንሽን፥ ባ ናአ በኖና (መቶ ናአ) ጋዳ ሱንꬃሱ። ሽን እያ አዋይ ብንያመ (ታ ኡሻቻ) ግድ ሱንꬅስ። ");
INSERT INTO gofe_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","ሄሳፈ ጉየ፥ ራሄላ ሀይቃ አጋሱ። ቤተለመ ጌተትያ ኤፍራታ ኤፍያ ኦግያ ጋፃን ሞገታሱ። ");
INSERT INTO gofe_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","ያይቆብ እ ዱፉዋ ቦላ ሀዉልተ ሹቹ ኤስስ። ሄ ሀዉልተይ ሀች ጋካናዉካ ራሄል ዱፉዋ ኤርሴስ። ");
INSERT INTO gofe_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","እስራኤለይ ሄሳፈ ደንድድ ኤደራ ግምብያፈ ሄፍንꬃን ባ ዱንካንያ ቶክስ። ");
INSERT INTO gofe_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","እስራኤለይ ሄ ቢታን ደእሽን፥ ሮቤል ባ አዋስ የልዳ አይለ ባልራ አቅስ። እስራኤለይ ሄ ኦዳ ስእስ። ያይቆባ አደ ናይት ታማነ ናምአ። ");
INSERT INTO gofe_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","ልያ ናይት ያይቆባ ባይራ ናአ ሮቤላ፥ ስሞና፥ ሌወ፥ ይሁዳ፥ ይሳኮራነ ዛብሎና። ");
INSERT INTO gofe_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","ራሄል አደ ናይት ዮሰፋነ ብንያመ። ");
INSERT INTO gofe_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","ራሄል አይለ ባል አደ ናይት ዳነነ ንፍታለመ። ");
INSERT INTO gofe_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","ልያ አይለ ዛላፋ አደ ናይት ጋደነ አሴራ። ሀ ናይት ያይቆባስ ማሰጰፆመን የለትዳ አደ ናይታ። ");
INSERT INTO gofe_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","ያይቆብ ከብሮና ጌተትያ ቅርያት-አርባ ማታን ማምረን ደእያ ባ አዋ ይሳቃ ሶ ብስ። ሄ በሳይ ካሰ አብራሃመይነ ይሳቅ ደእዳ በሳ። ");
INSERT INTO gofe_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","ይሳቅ ፄታነ ሆስፑን ታሙ ላይꬅ ደእስ። ");
INSERT INTO gofe_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","እ ዳሮ ዎድያ ደእድ ሎኦ ጭምድ፥ ሀይቅድ ባ ማይዛታን ጋሄትስ። እያ ናይት ኤሳዌይነ ያይቆብ እያ ሞግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","ኤዶመ ጌተትያ ኤሳዌ የለተꬃይ ሀይሳፈ ካልድ ፃፈትዳይሳ፤ ");
INSERT INTO gofe_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","ኤሳዌይ ካናነ ቢታ ማጫ ናይታፐ ባዉ ማቾታ ኤክስ። ኤንትካ ህተ አድያ ኤሎና ናእዉ አዶ፥ ህወ አድያ ፅባኦና ናአይ አን የልዳ ኦሆልባሞነ ");
INSERT INTO gofe_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","እስማኤላ ናእዉ፥ ነባዮታ ምችዉ ባሰማቶ። ");
INSERT INTO gofe_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","አዳ ኤሳዌስ ኤልፋዛ የላሱ። ባሰማታ ራጉኤላ የላሱ። ");
INSERT INTO gofe_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","ኦሆልባማ የኡሳ፥ ያእላማነ ቆረ የላሱ። ካናነ ቢታን ኤሳዌስ የለትዳ አደ ናይት ሀይሳታ። ");
INSERT INTO gofe_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","ኤሳዌይ ባ ማቸታ፥ ባ አደ ናይታነ ማጫ ናይታ፥ ባ ሶ አሳ ኡባ፥ ባ ሚዛነ ባ ሀራ መሄ ኡባ ካናነ ቢታን ሃርዳባ ኡባ ኤክድ ባ እሻ ያይቆባፐ ሃክድ ሀራ ቢታ ብስ። ");
INSERT INTO gofe_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","ኤንታ ሻሎይ ዳርዳ ግሾ፥ ኤንቲ እስፈ ዳናዉ ዳንዳእቦኮና። ኤንታ መሄይ ዳርዳ ግሾ፥ ኤንቲ ደእያ ቢታይ ኤንታ ናምኣስ ግዶና እፅስ። ");
INSERT INTO gofe_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","ያንን፥ ኤዶመ ጌተትያ ኤሳዌይ ደረይ ዳርያ ሳይረ ቢታን ደእስ። ");
INSERT INTO gofe_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","ደረይ ዳርያ ሳይረ ቢታን ደእዳ ኤዶመታ ማይዛ ኤሳዌ የለተꬃይ ሀይሳፈ ካልድ ፃፈትዳይሳ፤ ");
INSERT INTO gofe_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","ኤሳዌ አደ ናይታ ሱንꬃይ፥ ኤሳዌ ማቸ አድ ናኣ ኤልፋዛነ ኤሳዌ ማቸ ባሰማት ናአ ራጉኤላ። ");
INSERT INTO gofe_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","ኤልፋዛ ናይት ተማና፥ ኦማራ፥ ፃፋ፥ ጋእታማነ ቀነዛ። ");
INSERT INTO gofe_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","ቃስ ትምናአ ኤሳዌ ናአ ኤልፋዛስ አይለ። እያ ኤልፋዛስ አማለቃ የላሱ። ሀይሳቲ ኤሳዌ ማቸ አድ ናኣ ናይታ። ");
INSERT INTO gofe_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","ራጉኤላ አደ ናይት ናሃታ፥ ዛራ፥ ሻማነ ሚዛ። ሀይሳቲ ኤሳዌ ማቸ ባሰማት ናአ ናይታ። ");
INSERT INTO gofe_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","ፅባኦና ናአይ አን የልዳ ኦሆልባማ አደ ናይት ሀይሳታ፤ ኤንትካ የኡሳ፥ ያእላማነ ቆረ። ");
INSERT INTO gofe_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","ኤሳዌ የለታ ሀላቃት ሀይሳፈ ካልድ ፃፈትዳይሳታ፤ ኤሳዌስ ባይራ ናአ ኤልፋዛ አደ ናይት፥ ሀላቃ ግድዳይሳት ተማና፥ ኦማራ፥ ፃፋ፥ ቃናዛ፥ ");
INSERT INTO gofe_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","ቆረ፥ ጋእታማነ አማለቃ፤ ኤዶመ ቢታን ኤልፋዝ የልዳ ሀላቃት ሀይሳታ፤ ሄሳት ኡባይ አድ ናኣ ናይታ። ");
INSERT INTO gofe_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","ኤሳዌ ናአ ራጉኤላ አደ ናይት፥ ሀላቃ ግድዳይሳት ናሃታ፥ ዛራሀ፥ ሻማነ ሚዛ፤ ኤዶመ ቢታን ራጉኤል የልዳ ሀላቃት ሀይሳታ፤ ኤንቲ ኤሳዌ ማቸ ባሰማት ናአ ናይታ። ");
INSERT INTO gofe_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","ኤሳዌ ማቸ ኦሆልባም አደ ናይት፥ ሀላቃ ግድዳይሳት የኡሳ፥ ያእላማነ ቆረ፤ ኤንቲ አና ናኤ፥ ኤሳዌ ማቸ ኦሆልባምፐ የለትዳ ሀላቃታ። ");
INSERT INTO gofe_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","ኤዶመ ጌተትያ ኤሳዌ አደ ናይት ሀይሳታ፤ ኤንታ ሀላቃትካ ሀይሳታ። ");
INSERT INTO gofe_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","ኤዶመ ቢታን ደእያ ሆራ ሳይረ አደ ናይት ሀይሳፈ ካልድ ፃፈትዳይሳታ፤ ሄሳትካ ሎፃና፥ ሾባላ፥ ፅባኦና፥ አና፥ ");
INSERT INTO gofe_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","ድሶና፥ ኤፀራነ ድሳና፤ ሄሳት፥ ኤዶመ ቢታን ደእያ ሳይረ አደ ናይት፥ ሆራታ ሀላቃታ። ");
INSERT INTO gofe_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","ሎፃና አደ ናይት ሆራነ ሄማማ፤ ሎፃና ምችያ ትምናኦ። ");
INSERT INTO gofe_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","ሶባላ አደ ናይት አልዋ፥ ማናሆታ፥ ኤባላ፥ ስፋነ ኦናማ። ");
INSERT INTO gofe_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","ፅባኦና አደ ናይት አያነ አና፤ ሀይስ አን መላ ቢታን ባ አዋ ፅባኦና ሀረታ ሄምሸ ብልቦ ሃꬃ ፑልቱዋ ደምዳይሳ። ");
INSERT INTO gofe_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","አና ናአይ ድሶና፤ ናእያ ቃስ ኦሆልባሞ። ");
INSERT INTO gofe_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","ድሶና አደ ናይት ሄምዳና፥ ኤስባና፥ ይትራናነ ካራና። ");
INSERT INTO gofe_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","ኤፀራ አደ ናይት ብልሃና፥ ዛዋናነ አቃና። ");
INSERT INTO gofe_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","ድሳና አደ ናይት ኡፃነ አራና። ");
INSERT INTO gofe_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","ሆራታ ሀላቃት ሀይሳታ፤ ሎፃና፥ ሾባላ፥ ፅባኦና፥ አና፥ ");
INSERT INTO gofe_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","ድሶና፥ ኤፀራነ ድሳና። ሀይሳቲ ሳይረ ቢታን ባንታ ያራን ያራን ሻከትዳ ሆራታ ሀላቃታ። ");
INSERT INTO gofe_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","እስራኤለን ካዎይ ካዎታናፐ ካሰ ኤዶመ ቢታን ካዎትዳ ካዎት ሀይሳፈ ካልድ ፃፈትዳይሳታ። ");
INSERT INTO gofe_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","ብኦራ ናአይ ባላቅ ኤዶመን ካዎትስ፤ እያ ካታማ ሱንꬃይ ድናባ ጌተቴስ። ");
INSERT INTO gofe_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","ባላቅ ሀይቅን፥ ባሶራ አደይ ዛራ ናአይ ዮባብ እያ በሳን ካዎትስ። ");
INSERT INTO gofe_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","ዮባብ ሀይቅን፥ ተማና አደይ ሁሳም ካዎትስ። ");
INSERT INTO gofe_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","ሁሳም ሀይቅን፥ ባዳዳ ናአይ ሀዳድ፥ ምድያመታ ሞአበ ቢታን ፆንዳይስ ካዎትስ፤ እያ ካታማ ሱንꬃይ አዊታ ጌተትስ። ");
INSERT INTO gofe_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","ሀዳድ ሀይቅን፥ ማስሬቃ አደይ ሳምል ካዎትስ። ");
INSERT INTO gofe_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","ሳምል ሀይቅን፥ ሻፋ ማታን ደእያ ረሆቦታ አደይ ሳኡሊ ካዎትስ። ");
INSERT INTO gofe_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","ሳኡሊ ሀይቅን፥ አክቦራ ናአይ ባአል-ሀናን ካዎትስ። ");
INSERT INTO gofe_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","አክቦራ ናአ ባአል-ሀናን ሀይቅን፥ ሀዳድ ካዎትስ፤ እያ ካታማ ሱንꬃይ ፓኡ ጌተቴስ፤ እያ ማችያ መዛሃባ ናእያ ማፅሬዳ የልዳ ማሄፃቤሎ ጌተታዉሱ። ");
INSERT INTO gofe_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","ኤሳዌ የለታ ሀላቃት ባንታ ያራን ያራን፥ ባንታ በሳን በሳን ባንታ ሱንꬃን ሱንꬃን ሀይሳታ፤ ትምና፥ አልዋ፥ የተታ፥ ");
INSERT INTO gofe_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","ኦሆልባማ፥ ኤላ፥ ፕኖና፥ ");
INSERT INTO gofe_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","ቃናዛ፥ ተማና፥ ምብሳራ፥ ");
INSERT INTO gofe_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","ማግደላነ እራማ። ሀይሳቲ ባንታ አይስያ ቢታን፥ ባንታ ደእያሱዋን ደእያሱዋን ኤዶመ ሀላቃታ። ሀይስ ኤሳዌይ፥ ኤዶመታ አዋ። ");
INSERT INTO gofe_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","ያይቆብ እያ አዋይ ይሳቅ ደእዳ ካናነ ቢታን ደእስ። ");
INSERT INTO gofe_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","ያይቆባ የለተꬃ ታርከይ ሀይሳፈ ካልድ ፃፈትዳይሳ። ዮሰፍ ታማነ ላፑን ላይꬃ ናአ ግድዳ ዎደ ባ አዋ ማቸታፐ፥ ባልፐነ ዝልፓፈ የለትዳ ባ እሻታራ መሄ ሄሜስ። እ ባ አዋስ ባ እሻት ኦꬅዳ ኢታባታ ኦዴስ። ");
INSERT INTO gofe_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","እስራኤለይ ዮሰፋ ጭምድ የልዳ ግሾ፥ ባ ሀራ አደ ናይታ ኡባፈ አꬅድ ዶሴስ። ሄሳ ግሾ፥ እያዉ አሌቀትዳ ማኦ ጊግስስ። ");
INSERT INTO gofe_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","እያ እሻት ኤንታ አዋይ እያ ኤንታፈ አꬅድ ዶሰይሳ በእዳ ዎደ እያ እፅዶሶና። ማልኦ ቃላካ እያኮ ኦደታናዉ ዳንዳእቦኮና። ");
INSERT INTO gofe_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","እስ ዎደ ዮሰፍ አሙሆ አሙህድ፥ ባ እሻታስ ኦድን ኤንቲ እያ ካሰይሳፈ አꬅድ እፅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","እ ኤንታኮ፥ “ታኒ አሙህዳ አሙሁዋ ስእተ። ");
INSERT INTO gofe_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","ኑኒ ጋደን ግስተ ምርቅሽን ታ ምርቀይ ደንድድ ሉለ ኤቅስ። ህንተ ምርቀት ዩይ አꬍድ ታ ምርቅያስ ዝግዶሶና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","እያ እሻት፥ “ኔኒ ኑ ቦላ ካዎታዳ ኑና ሃራናዉ ቆፓይ?” ያግድ ኦይችዶሶና። ኤንቲ እያ አሙሁዋ ግሾነ እያ ኦዳ ግሾ፥ ካሰይሳፈ አꬅድ እፅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","ቃስካ ዮሰፍ ሀራ አሙሆ አሙህድ ባ እሻታስ ኦድስ። “ሄኮ፥ ታኒ ሀራ አሙሆካ አሙሀስ። ሄ አሙሁዋን አው፥ አጌንነ ታማነ እስ ፆልንቶት ታዉ ዝጎሶና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","ባ እሻታስ ኦድዳ አሙሁዋ ባ አዋስ ኦድዳ ዎደ እያ አዋይ፥ “ሀይስ ዋንዳ አሙሆ? ቱማ ታኒ፥ ነ አያነ ነ እሻት ይድ፥ ነ ስንꬃን ዝጋነዬ?” ያግድ ሀንቀትስ። ");
INSERT INTO gofe_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","እያ እሻት እያ ቃናትዶሶና፥ ሽን እያ አዋይ ሄ ኦዳ ባ ዎዛናን ዎꬅስ። ");
INSERT INTO gofe_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","እስ ጋላስ እያ እሻት ሴከማን ባንታ አዋ መሄታ ሄማናዉ ብዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","እስራኤለይ ዮሰፋ፥ “ነ እሻት ሴከማን መሄታ ሄመይሳ ኤራሳ። ሃያ፥ ታኒ ነና ኤንታኮ ኪታና” ያግስ። ዮሰፍካ፥ “ኤሮ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","እ እያኮ፥ “ባዳ ነ እሻትነ መሄይ ሳሮ ግደይሳ በአዳ ኤንታባ ታዉ ያዳ ኦዳ” ያግድ ዮሰፋ ከብሮና ዛንጋራፐ ኪትስ። ዮሰፍ ኪተትድ ሴከማ ብስ። ");
INSERT INTO gofe_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","ያን ደምባ በሳን ኤንታ ኮሻን ያ ሃ ስመረትሽን፥ እስ አስ እያ ደምድ፥ “ላ ናአዉ፥ አይ ኮያይ?” ያግድ ኦይችስ። ");
INSERT INTO gofe_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","እ፥ “ታ እሻታ ኮያይስ፤ ኤንቲ መህያ ሄምያ በሳ በእዳኮ፥ ሀያና ታዉ ኦዳርኪ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","ኡራይ፥ “ሀይሳፈ ብዶሶና፤ ኤንቲ፥ ‘ኑኒ ዶታነ ባና’ ግሽን ስአስ” ያግስ። ሄሳ ግሾ፥ ዮሰፍ ባ እሻታ ጌዶ ካል ብድ፥ ኤንታ ዶታነን ደምስ። ");
INSERT INTO gofe_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","ሽን እ ሃሆን ደእሽን፥ ኤንቲ እያ በእዶሶና። እ ኤንታኮ ጋኮና ደእሽን፥ ኤንቲ እያ ዎꬋናዉ ማቀትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","ኤንቲ እሶይ እሱዋኮ፥ “ህን በእተ፥ አሙሁዋ ጎዳይ ዬስ። ");
INSERT INTO gofe_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","ሃይተ፥ እያ ዎꬍድ፥ ሀ ኦላታፐ እሱዋን የጎስ። ሄሳፈ ጉየ፥ ‘ዶእ እያ ምስ’ ያጋና። ያትድ፥ እያ አሙሁዋ ዉርሰꬃ በአና” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","ሮቤል ሄሳ ስእዳ ዎደ፥ ኤንታ ኩሸፐ እያ አሻናዉ ኮይድ፥ “እያ ዎꬎኮ፤ ");
INSERT INTO gofe_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","እያ ዎꬋናፐ መላ ቢታን ደእያ ሀ ኦላን የግተ፤ እያ ቦላ ኩሸ ዎꬆፍተ” ያግስ። ሮቤል ሄሳ ግዳይ፥ እያ ኤንታ ኩሸፐ አሽድ ጉየ አዋኮ ዛራናሳ። ");
INSERT INTO gofe_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","ዮሰፍ ባ እሻታኮ ጋክዳ ዎደ እ ማእዳ አሌቀትዳ ማኡዋ እያፐ ቃር ኤክዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","እያ ኤፍድ ሃꬅ ባይና መላ ኦላን የግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","ኤንቲ ካ ምሽን ሀሳዮና እስማኤላ አሳት ጋላዳፐ ግብፀ ብሽን፥ ꬎቁ ግድ በእዶሶና። ኤንቲ ባንታ ግማለታ ቦላ ሳዉዋ፥ ማድያነ ካርብያ ጫንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","ይሁድ ባ እሻታ፥ “ኑኒ ኑ እሻ ዎꬍድ፥ እያ ሱꬃ ቆትኮ ኑና አይ ማዳኔ? ");
INSERT INTO gofe_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","ሃይተ፥ እያ እስማኤላ አሳስ ባይዞስ። እ ኑ እሻ፥ ኑ ሱꬁነ ኑ አሾ ግድያ ግሾ እያ ቦላ ኑ ኩሽያ ዎꬆኮ” ያግስ። እያ እሻት እያ ኦዳ ማእዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","ሄሳ ግሾ፥ ምድያመ ቢታ ዛልአንቾት ያራ አꬍሽን፥ እያ እሻት ዮሰፋ ኦላፈ ከስድ፥ እስማኤላ አሳታስ ላታሙ ብራ ሳንትመን ባይዝዶሶና። ኤንቲ ዮሰፋ ግብፀ ቢታ ኤፍዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","ሮቤል ኦላኮ ስሚድ፥ ዮሰፍ ያን ባይናይሳ በእዳ ዎደ፥ አዛንድ ባ ማኡዋ ዳክስ። ");
INSERT INTO gofe_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","እ ጉየ ባ እሻታኮ ብድ፥ “ናአይ ያን ባዋ፤ ህዛ፥ ታኒ አይ ሀኖሻ?” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","ኤንቲ ዮሰፋ ማኡዋ ኤክድ፥ እስ ዴሸ ሹክድ፥ ሄ ሱꬃን ናቅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","አሌቀትዳ እያ ማኡዋ ባንታ አዋኮ ኤፍድ “ኑኒ ሀይሳ ደምዳ፤ ሀይስ ነ ናአ ማኡዋኮነ አነ በአ” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","ያይቆብ ማኡዋ ኤርድ፥ “ሀይስ ታ ናኣ ማኡዋ፤ ታ ናኣ ዶእ ምስ። ዮሰፍ ቱማካ ዛዘትስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","ያይቆብ አዛንድ፥ ባ ማኡዋ ፔꬍስ። ካዮ ማኦ ማእድ፥ ባ ናኣስ ዳሮ ጋላስ ዬክስ። ");
INSERT INTO gofe_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","እያ አደ ናይትነ ማጫ ናይት ኡባይ እያ ምንꬃናዉ ይዶሶና። ሽን እ ምነቶና እፅድ፥ “አካይ፥ ታኒ ዬሆይ ዬሆሽን ዱፎ ገላና” ያግድ፥ ዮሰፋስ ዬክስ። ");
INSERT INTO gofe_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","ሄ ዎደ ምድያመ ቢታ አሳት ዮሰፋ፥ ግብፀ ካዋ ሞርናታነ ካዋ ናገይሳታ ሀላቃ ግድዳ ጶፅፋራስ ባይዝዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","ሄ ዎደ ይሁድ ባ እሻታፐ ሻከትድ፥ አዱላማ ካታማን ደእያ ህራ ጌተትያ ኡራራ ዳናዉ ብስ። ");
INSERT INTO gofe_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","ያን ይሁድ ሹአ ጌተትያ ካናነ ኡራ ናእዉ ማችስ። ");
INSERT INTO gofe_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","እያ ይሁዳስ ቃንꬃታዳ አደ ናአ የላሱ። እ ሄ ናአ ኤራ ግድ ሱንꬅስ። ");
INSERT INTO gofe_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","ቃስካ ቃንꬃታዳ አደ ናአ የላሱ። እያ ሄ ናአ ኦናና ጋዳ ሱንꬃሱ። ");
INSERT INTO gofe_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","ዛራዳካ ሀራ አደ ናአ የላሱ። እያ ሄ ናኣ ሴላ ጋዳ ሱንꬃሱ። ሄ ናአይ የለትያ ዎደ ይሁድ አክዚባ ቢታና። ");
INSERT INTO gofe_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","ይሁድ ባ ባይራ ናአ ኤራስ ትማሮ ጌተትያ ማቾ እሚስ። ");
INSERT INTO gofe_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","ይሁዳ ባይራ ናአይ፥ ኤር፥ ጎዳ ስንꬃን ኢታ አስ ግድያ ግሾ፥ ጎዳይ እያ ዎꬍስ። ");
INSERT INTO gofe_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","ይሁድ ኦናናኮ፥ “ዎጋይ ነና ኪተይሳ መላ ነ እሻ ማቸራ አቃ። ነ እሻስ ናአ የላዳ እያ ሱንꬃ ፄግሳ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","ሽን ኦናን የለታና ናይት እያባ ግዶናይሳ ኤርዳ ግሾ፥ ባ እሻ ማቸራ አቅያ ዎደ ባ እሻስ ናእ የለቶና መላ ባ አቱንꬃ ሳአን ጉሴስ። ");
INSERT INTO gofe_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","እ ኦꬅዳባይ ጎዳ ስንꬃን ኢታባ ግድዳ ግሾ፥ ጎዳይ እያካ ዎꬍስ። ");
INSERT INTO gofe_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","ሄሳፈ ጉየ፥ ይሁድ ባ ናኣ ማችዉ ትማሮ፥ “ታ ናአይ ሴል ድጫና ጋካናስ ነ አዋ ሶ ባዳ፥ አምኤተꬃን ደኣሻ” ያግስ። ሄሳ እ ግዳይ፥ እካ ባ እሻታዳ ሀይቃነኮነ ግድ ህርግዳ ግሾሳ። ሄሳ ግሾ፥ ትማራ ባዳ ባ አዋ ሶን ደአሱ። ");
INSERT INTO gofe_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","ዳሮ ዎደፐ ጉየ፥ ይሁዳ ማችያ፥ ሹአ ናእያ ሀይቃሱ። ይሁድ ባ ካዮ ዎድያ ኦንግድ፥ ባ ዶርሳታ እክስያ ሜድያ አሳታኮ ትምና ጌተትያ በሲ ባ ላግያ አዱላማ አድያ ህረራ ብስ። ");
INSERT INTO gofe_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","አሳይ ትማሮ፥ “ሄኮ፥ ነ አዝና አዋይ ይሁድ፥ ባ ዶርሳታ እክስያ ሜዳናዉ ትምና ቤስ” ያግድ ኦድዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","እያ ባ አምኤተꬃ ማኡዋ ላማዳ፥ ባና ባለꬃናዉ ሻሸ ኤካዳ ጉሉንታሱ። ያታዳ፥ ትምና ኤፍያ ኦግያ ዶናን ደእያ ኤናይመ ካታማ ጋፃን ኡታሱ። ሄሳ እያ ኦꬅዳይስ፥ ሴል ድጭድ ጋክንካ እያዉ ማቾ ግዳዳ እመቶናይሳ እያ ኤርዳ ግሾሳ። ");
INSERT INTO gofe_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","እያ ባ ሶምኡዋ ጉሉንትዳ ግሾ፥ ይሁድ እዮ በእዳ ዎደ፥ ላይማ ማጫስ ግድ ቆፕስ። ");
INSERT INTO gofe_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","ባ ናኣ ማችዉ ግደይሳ ኤሮና ደእሸ፥ ኦግያ ጋፃ ኢኮ ሺቅድ “ታራ አቃኔ?” ያግድ ኦይችስ። እያ፥ “ታኒ ኔራ አቅኮ፥ ነ ታዉ አይ እማኔ?” ጋዳ ኦይቻሱ። ");
INSERT INTO gofe_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","እ፥ “ታኒ ታ መህያፐ እስ ኮለ ነዉ የዳና” ያግስ። እያ፥ “ኔኒ ሄሳ ታዉ የዳና ጋካናስ አይ ኦይꬃኔ?” ያጋሱ። ");
INSERT INTO gofe_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","እ፥ “አይ ኦይꬆ?” ያግስ። እያ፥ “ነ ማታምያ እያ ጎሹዋራነ ነ ኩሽያን ደእያ ፃምአ ኦይꬃ” ያጋሱ። እ ሄሳታ እምድ፥ ኢራ አቅስ፤ እያካ ቃንꬃታሱ። ");
INSERT INTO gofe_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","እያ ሄሳፈ ደንዳዳ ብዳፐ ጉየ፥ ባ ጉሉንꬃ ቃራዳ፥ ባ አምኤተꬃ ማኡዋ ማአሱ። ");
INSERT INTO gofe_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","ይሁድ ባ ኦይꬅዳባ ሄ ማጫሴፐ ዛር ኤካናዉ ዴሻ ባ ላግያ ህራ ቦላ እዉ የድስ። ሽን እ እዮ ደምቤና። ");
INSERT INTO gofe_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","እ ሄ ቢታ አሳኮ፥ “ኤናይመ ካታማን፥ ኦገ ዶናን ኡትዳ ላይማ ማጫስያ አዉኔ?” ያግድ ኦይችስ። አሳይ፥ “ላይማ ማጫስ ሀይሳን ኡባካ ባዋ” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","እ ይሁዳኮ ስሚድ፥ “ ‘ታኒ እዮ ደማብከ፤ ሄሳ ቦላካ ሄ ቢታ አሳይ፥ ላይማ ማጫስ ሀይሳን ኡባካ ባዋ’ ያግዶሶና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","ይሁድ፥ “ባ ኦይክዳይሳ ባዉ ኤኮ፥ አቶ ጊኮ፥ አስ ኑና ሚጫና። ህዛ ታኒ እዉ ዴሸ የዳስ ሽን ኔኒ እዮ ደማባካ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","ሄꬑ አጌና ግድሽን አሳይ፥ “ነ ናኣ ማጫስያ ትማራ ላይማታዳ ቃንꬃታሱ” ያግድ ይሁዳስ ኦድዶሶና። ይሁድ፥ “እዮ ካረ ከስድ ታማን ፁግተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","እዮ ካረ ከስያ ዎደ፥ “ታኒ ቃንꬃትዳይ ሀ ሚሸታ ጎዳሳ። ሀ ማታመይነ ፃምአይ ኦደባየኮ ኤራናዉ ዳንዳእኮ ኤራ” ጋዳ ባ አዝና አዋካ ኪታሱ። ");
INSERT INTO gofe_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","ይሁድ ሄ ሚሸታ ኤርድ፥ “ታኒ ታ ናኣ ሴላስ እዮ እማቦና ግሾ፥ ታፐ እያ ፅሎ” ያግስ። ሄሳፈ ጉየ፥ እ ኢራ ዛሪድ አቅቤና። ");
INSERT INTO gofe_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","እዉ የሎ ቃም ጋክያ ዎደ፥ እ ኡሎን መንተ ናይት ደኤይስ ኤረትስ። ");
INSERT INTO gofe_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","እያ ማረትሽን፥ ኤንታፈ እሶይ ባ ኩሽያ ከስን የልስያራ፥ “ሀይስ ኮይሮ ከይስ” ጋናዉ ዞኦ ቃጭና ኤካዳ እያ ኩሸን ቃቻሱ። ");
INSERT INTO gofe_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","ሽን እ ባ ኩሽያ ጉየ ኤክዳ ዎደ፥ እያ እሻይ ከይን እያ፥ “ኔኒ ዋናዳ ፖርፁ ጋዳ ከያዲ?” ያጋሱ። ሄሳ ግሾ፥ ፓረሳ (ፖርፁ ግስ) ጋዳ ሱንꬃሱ። ");
INSERT INTO gofe_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","ሄሳፈ ጉየ፥ እያ ኩሸን ዞኦ ቃጭን ደእያ እያ እሻይ የለትስ። እያ ሱንꬃይ ዛራ (ዞኦ) ጌተትስ። ");
INSERT INTO gofe_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","እስማኤላ አሳት ዮሰፋ ግብፀ ቢታ ኤፍዶሶና። ግብፀ ካዋ ሞርናታፐ እሱዋስ፥ ካዋ ናገይሳታ ሀላቃስ ዮሰፋ ባይዝዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","ጎዳይ ዮሰፋራ ደእያ ግሾ፥ እ ኦꬅያባ ኡባ እያዉ እንጀይስ። ያትን፥ ባ ግብፀ ጎዳ ሶን ደእስ። ");
INSERT INTO gofe_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","ጎዳይ እያራ ደኤይሳነ እ ኦꬅያባ ኡባ እያዉ እንጀይዳይሳ ጶፅፋር በእዳ ዎደ፥ ");
INSERT INTO gofe_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","ዮሰፋ ዶስስ፥ ባዉ ማታ ኦሳንቾ ኦꬅስ። ጶፅፋር እያ ባ ኬꬃ ቦላነ ባዉ ደእያባ ኡባ ቦላ ሹምስ። ");
INSERT INTO gofe_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","ሄ ዎደፐ ዶምድ፥ ጎዳይ ግብፀ ኡራ ኬꬃ ዮሰፋ ግሾ አንጅስ። ጎዳ አንጆይ ጶፅፋራ ሶንነ እያ ጋደን ደእያባ ኡባ ቦላ ዎꬍስ። ");
INSERT INTO gofe_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","ሄሳ ግሾ፥ እ ምያ ካꬃፈ አትሽን፥ ባዉ ደእያ ሀራባ ኡባ ዮሰፋ ኩሸን ሼꬍስ። ዮሰፍ የገልስነ ማላ ሎኦ አስ። ");
INSERT INTO gofe_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","ጉꬃ ዎደፐ ጉየ፥ እያ ጎዳ ማችያ ዮሰፋ በአዳ፥ “ሃያ፥ ታራ ዝንአ” ያጋሱ። ");
INSERT INTO gofe_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","ሽን እ እፅድ፥ ኢኮ፥ “በአ፥ ታ ጎዳይ፥ ባዉ ደእያባ ኡባ ታ ኩሸን የግዳ ግሾ፥ ባ ሶን ደእያባስ አይኮካ ህርገና። ");
INSERT INTO gofe_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","ሀ ሶን ታፐ አይ ኦንካ ባዋ። ኔኒ እያ ማቾ ግድያ ግሾ፥ ኔፐ አትሽን፥ ሀራ፥ እ ታዉ እሞናባይ ባዋ። ያትን፥ ታኒ ዋታዳ ሀይሳ መላ ዳሮ ኢታባ ሀናዳ ፆሳ ቦላ ናጋራ ኦꬆ?” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","እያ ሄ ኦዳ ዎንታ ዎንታ ዮሰፋስ ኦድንካ፥ እ ኢራ አቆና ይኮ እ ማታ ሺቆና እፅስ። ");
INSERT INTO gofe_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","ሽን እስ ጋላስ እ ባ ኦሶ ኦꬃናዉ ሶ ገልያ ዎደ፥ ሶ አይለታፐ ኦንካ ሶን ባዋ። ");
INSERT INTO gofe_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","እያ ዮሰፋ አፍላ ኦይካዳ፥ “ታራ ዝንአ” ያጋሱ። ሽን እ ባ አፍላ እ ኩሽያን የግ አግድ፥ ሶፐ ካረ ዎፅ ከይስ። ");
INSERT INTO gofe_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","ዮሰፍ ባ አፍላ እ ኩሽያን የግ አግድ፥ ሶፐ ካረ ዎፅ ከይዳይሳ እያ በእዳ ዎደ፥ ");
INSERT INTO gofe_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","ባ ሶ አይለታ ፄጋዳ፥ “ሄኮ፥ ታ አዝናይ ኤህዳ ሀ እብራወ ኡራይ ታና ካዉሻናዉ ኦይክስ። እ ታና ኢሳናዉ ታ ደእያሱዋ ገልስ፥ ሽን ታኒ ዋሳስ። ");
INSERT INTO gofe_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","ያትን፥ እ ባ አፍላ ታ ማታን የግ አግድ፥ ሶፐ ካረ ዎፅድ ከይስ” ያጋሱ። ");
INSERT INTO gofe_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","እ አዝናይ ሶ ያና ጋካናስ እያ ዮሰፋ አፍላ ባ ማታን ዎꬃሱ። ");
INSERT INTO gofe_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","እ ይን፥ እያዉ ሀይሳዳ ጋዳ ኦዳሱ፤ “ሀይስ ነ ኤህዳ እብራወ አይለይ ታና ኢሳናዉ ታኮ ገልስ። ");
INSERT INTO gofe_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","ሽን ታኒ ዋስን፥ ባ አፍላ ታ ማታን የግ አግድ፥ ሶፐ ካረ ዎፅ ከይስ” ያጋሱ። ");
INSERT INTO gofe_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","እያ ጎዳይ ሀንዳባ ስእዳ ዎደ ዳሮ ይሎትስ። ");
INSERT INTO gofe_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","እያ ጎዳይ ዮሰፋ ኤፍድ፥ ካዋ ቃሾ አሳይ ደእያ ቃሾ ኬꬃን የግስ። ");
INSERT INTO gofe_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","ሽን ዮሰፍ ቃሾ ኬꬃን ደእያ ዎደ፥ ጎዳይ እያራ ደኤስ። ባ ኬሀተꬃ እያዉ ዳርስድ፥ ቃሾ ኬꬃ ካፑዋ ስንꬃን እያዉ ሳባ እሚስ። ");
INSERT INTO gofe_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","ያንን፥ ቃሾ ኬꬃ ካፖይ ቃሾ አሳ ኡባ ዮሰፋ ኩሸን የግስ። ያን ኦሰትያባ ኡባስ አዋተꬃ እሚስ። ");
INSERT INTO gofe_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","ጎዳይ ዮሰፋራ ግድድ፥ እ ኦꬅያባ ኡባ እያዉ እንጀይዳ ግሾ፥ ቃሾ ኬꬃ ካፖይ ዮሰፋ ኩሸን ደእያባስ አይኮካ ህርገና። ");
INSERT INTO gofe_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","ጉꬃ ዎደፐ ጉየ፥ ግብፀ ካዋ ኡሻ ካፖይነ ካꬃ ካፖይ ባንታ ጎዳ፥ ግብፀ ካዋ ናቅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","ካዎይ ሄ ናምኡ ካፖታ ቦላ ዳሮ ይሎትድ፥ ");
INSERT INTO gofe_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","ዮሰፍ ቃሸትዳ፥ ቃሾ ኬꬃ ናገይሳታ ካፑዋ ሶን ኤንታ ቃችስ። ");
INSERT INTO gofe_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","ናገይሰታ ሀላቃይ ኤንታ ዮሰፋስ ሼꬍስ፥ እካ ኤንታዉ ኪተቴስ። ኤንቲ ቃሾ ኬꬃን ዳሮ ዎደ ኡትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","ግብፀ ካዋ ኡሻ ካፖይነ ካꬃ ካፖይ፥ ቃሾ ኬꬃን ደእሸ ናምአይካ እስ ቃማ ዱማ ዱማ አሙሆ አሙህዶሶና። ሄ አሙሆታስ ዱማ ዱማ ብርሸꬃይ ደኤስ። ");
INSERT INTO gofe_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","ዮሰፍ ዎንታ ኤንታኮ ገልያ ዎደ ኤንቲ አዛንድ ኡትዳሽን በእስ። ");
INSERT INTO gofe_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","እ ኤንታና፥ “ሀች ህንተ ሶምኦይ አይስ ꬉምዴ?” ያግድ ኦይችስ። ");
INSERT INTO gofe_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","ኤንቲ፥ “ኑ ናምአይካ አሙሆ አሙህዳ፥ ሽን ኑስ ብርሽያ አስ ꬋይስ” ያግዶሶና። ዮሰፍ ኤንታኮ፥ “አሙሆ ብርሽያ ኤራተꬃይ ፆሳባ ግደነዬ? አነ ህንተ አሙሁዋ ታዉ ኦድተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","ያትን ኡሻ ካፖይ ባ አሙሁዋ ዮሰፋስ ኦድስ፤ “ታኒ ታ አሙሆን እስ ዎይነ ታ ስንꬃን በአስ። ");
INSERT INTO gofe_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","ሄ ዎይንያስ ሄꬑ ታሸት ደኦሶና። እ ሀይፅድ፥ ጪይ ስሚድ ቴርስ። ");
INSERT INTO gofe_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","ካዎ ዋንጭ ታ ኩሸን ደኤስ። ታኒ ዎይነ ቴራ ኤካዳ እያን ጉምአዳ፥ ሄ ዋንጫ ካዋ ኩሸን ዎꬃስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","ዮሰፍ፥ “ሀ አሙሁዋ ብርሸꬃይ ሀይሳ፤ ሄꬑ ታሸት ሄꬑ ጋላሳታ። ");
INSERT INTO gofe_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","ሄꬑ ጋላሳታ ግዶን ካዎይ ነና ቃሾፐ ብላና። እ ነና ካሰ ሹማተꬃኮ ዛራና። ካሰ ኔኒ ኡሻ ካፖ ግዳዳ ኦይሳዳ ኔኒ ካዋ ዋንጫ እያ ኩሽያን ዎꬃና። ");
INSERT INTO gofe_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","ሽን ነዉ ሳእ ሎእዳ ዎደ ታና ዶጎፓ፤ ታዉ ኬሀ። ታባ ካዋስ ኦዳዳ፥ ሀ ቃሾ ኬꬃፈ ታና ከስሳ። ");
INSERT INTO gofe_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","ታና እብራወ ቢታፈ ዎልቃን ኤህዶሶና። ሀር አቶሽን፥ ሀይሳን ታና ቃሾስ ጋꬅያባ አይብባካ ኦꬃብከ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","ካꬃ ካፖይ ዮሰፍ አሙሁዋ ሎይꬅድ ብርሽዳይሳ በእዳ ዎደ ዮሰፋኮ፥ “ታኒ አሙህዳ አሙሆይ ሀይሳ፤ ታ ሁጰን ሄꬑ ጋባተ ኡይꬅ ደኤስ፤ ");
INSERT INTO gofe_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","ቦላ ባጋ ጋባትያን ግብፀ ካዋስ ዱማ ዱማ ካꬃ ቆሞፈ ኡከትዳ ኡይꬃይ ደኤስ። ሽን ካፎት ሄ ታ ሁጰን ደእያ ጋባትያፐ ሞሶና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","ዮሰፍ፥ “ሄ አሙሁዋ ብርሸꬃይ ሀይሳ፤ ሄꬑ ጋባተት ሄꬑ ጋላሳታ። ");
INSERT INTO gofe_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","ሄꬑ ጋላሳ ግዶን ካዎይ ነና ቃሾፐ ብላና። ነ ቆꬍያ ቃንፅስድ ምꬃን ካቅሳና፤ ነ አሹዋካ ካፎይ ማና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","ሄꬓንꬆ ጋላሳን ግብፀ ካዎይ ባ የለትዳ ጋላሳን ባ ሞርናታ ኡባስ ግብራ ጊግስስ። ኡሻ ካፑዋነ ካꬃ ካፑዋ ብል ኤህድ ባ አሳ ስንꬃን ኤስስ። ");
INSERT INTO gofe_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","ኡሻ ካፑዋ እያ ሹማተꬃኮ ዛርን፥ እ ካዋ ኩሽያን ዋንጫ ዎꬅስ። ");
INSERT INTO gofe_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","ሽን ካዎይ ካꬃ ካፑዋ ካቅስስ። ኡባይካ ዮሰፍ ኤንታ አሙሁዋ ብርሽዳይሳዳ ሀንስ። ");
INSERT INTO gofe_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","ሽን ኡሻ ካፖይ ዮሰፋ ሀሳዮና ዶግ አግስ። ");
INSERT INTO gofe_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","ናምኡ ላይꬃፈ ጉየ፥ ግብፀ ካዎይ አሙሆ አሙህስ። ሄ አሙሁዋን እ ናይለ ሻፋ ጋፃን ኤቅስ። ");
INSERT INTO gofe_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","ላፑን ኦርደነ ሞꬎ ሚዛት ናይለ ሻፋፐ ከይድ፥ ማታ ምሽን በእስ። ");
INSERT INTO gofe_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","ኤንታፈ ካልድ፥ ሀራ ላፑን ግልቃ ሚዛት ናይለ ሻፋፐ ከይድ፥ ሻፋ ጋፃን ደእያ ሀራ ሚዛታ ማታን ኤቅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","ሄ ግልቃ ሚዛት ላፑን ኦርደነ ሞꬎ ሚዛታ ምትዶሶና። ሄሳፈ ጉየ፥ ካዎይ ባርክስ። ");
INSERT INTO gofe_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","እ ዛር ꬍስክድ፥ ሀራ አሙሆካ አሙህስ። ላፑን ሎኦነ ሙሩታ ሞርኤት እስ ማቃ ቦላ ከይዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","ኤንታፈ ካልድ፥ ሌኦነ ዶሎሀ ባጋ ጫርኮን ሹልዳ ሀራ ላፑን ሞርኤት ከይዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","ሄ ሌእዳ ሞርኤት ሎኦነ ሙሩታ ሞርኤታ ምትዶሶና። ሄሳፈ ጉየ፥ ካዎይ ባርክድ አሙሆ ግደይሳ ኤርስ። ");
INSERT INTO gofe_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","ሳአይ ዎንትን ꬍስኮፈ እ ደንድያ ዎደ እያ ዎዛናይ ያርክስ። ሄሳ ግሾ፥ ግብፀን ደእያ ብታንቾታነ ኤራንቾታ ኡባ ካዎይ ፄግስድ ኤንታዉ ባ አሙሁዋ ኦድስ። ሽን እያዉ ሄ አሙሁዋ ብርሽያ አስ ꬋይስ። ");
INSERT INTO gofe_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","ኡሻ ካፖይ ሄ ዎደ ግብፀ ካዋኮ፥ “ታኒ ታ ናቁዋ ሀች ሀሳያይስ። ");
INSERT INTO gofe_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","እስ ዎደ ካዎይ ባ አይለታ ሀንቀትድ፥ ታናነ ካꬃ ካፑዋ ቃሾ ኬꬃን የግስ። ");
INSERT INTO gofe_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","ያን ደእሸ ኑ ናምአት አሙሆ አሙህዳ። ሄ አሙሆታስ ዱማ ዱማ ብርሸꬃይ ደኤስ። ");
INSERT INTO gofe_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","ሄ ዎደ ናገይሳታ ካፑዋ አይለይ፥ እብራወ ፓንꬃይ፥ ኑራ ቃሾን ደኤስ። ኑኒ ኑ አሙሁዋ እያዉ ኦድን፥ እ ኑስ ሁጰን ሁጰን አሙሁዋ ብልስ። ");
INSERT INTO gofe_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","ያንን፥ ሄ ሀኖት እ ኑስ ብልዳይሳዳ ሀንዶሶና። ሄስ አይበ ጊኮ፥ ታኒ ታ ሹማተꬃኮ ስማስ፥ ሀንኮይ ካቀትስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","ያትን፥ ግብፀ ካዎይ ዮሰፋ ፄግስስ። ኤንቲ እያ ቃሾ ኬꬃፈ ኤለስድ ኤህዶሶና። እ ሜደትድ ባ ማኡዋ ላምድ፥ ካዋኮ ገልስ። ");
INSERT INTO gofe_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","ካዎይ ዮሰፋ፥ “ታኒ አሙሆ አሙሀስ፥ ሽን ታዉ እስ አስካ ብላናዉ ዳንዳእቤና። ታኒ፥ ነ አሙሆ ብላናዉ ዳንዳኤይሳ ስአስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","ዮሰፍ፥ “ታኒ ሄሳ ዳንዳእከ፥ ሽን ፆሳይ ካዋስ ሎኦነ ልከ ብርሸꬅ እማና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","ካዎይ፥ “ታኒ ታ አሙሆራ ናይለ ሻፋ ጋፃን ኤቅዳሽን፥ ");
INSERT INTO gofe_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","ላፑን ኦርደነ ሞꬎ ሚዛት ናይለ ሻፋፐ ከይድ፥ ማታ ሞሶና። ");
INSERT INTO gofe_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","ኤንታፈ ካልድ፥ ሀራ ላፑን ግልቃነ ላፍዳ ሚዛት ከይዶሶና። ታኒ ሄሳ መላ ግልቃ ሚዝ ግብፀ ቢታን ኡባካ በአ ኤርከ። ");
INSERT INTO gofe_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","ሄ ግልቃነ ላፍዳ ሚዛት ኮይሮ ከይዳ ላፑን ሞꬎ ሚዛታ ምትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","ሽን ኤንታ ምትዳፐ ጉየ ካሰይሳዳ ግልቅ ኡትዳ ግሾ፥ ኤንቲ ምትዳባ ኦንካ ኤራናዉ ዳንዳእቤና። ሄሳፈ ጉየ ታኒ ባርካስ። ");
INSERT INTO gofe_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“ታኒ ታ አሙሁዋን ቃስ ላፑን ሎኦነ ሙሩታ ሞርኤት እስ ማቃ ቦላ ከይዳይሳታ በአስ። ");
INSERT INTO gofe_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","ኤንታፈ ካልድ፥ ሌኦነ ዶሎሀ ባጋ ጫርኩዋን ሹልዳ ሀራ ላፑን ሞርኤት ከይዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","ሄ ሌእዳ ሞርኤት ላፑን ሎኦ ሞርኤታ ምዶሶና። ታኒ ሀ አሙሁዋ ብታንቾታስ ኦዳስ፥ ሽን ታዉ አሙሁዋ ብርሽያ አስ በንትቤና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","ሄሳፈ ጉየ ዮሰፍ ግብፀ ካዋኮ፥ “ካዋ አሙሆታ ብርሸꬃይ እስኖ። ፆሳይ ባ ኦꬃና ሀንያባ ካዋስ ቆንጭስስ። ");
INSERT INTO gofe_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","ሄ ላፑን ሎኦ ሚዛት ላፑን ላይꬃታ፥ ቃስ ላፑን ሎኦ ሞርኤት ላፑን ላይꬃታ፥ ሀ አሙሆታ ብርሸꬃይ እስኖ። ");
INSERT INTO gofe_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","ሄ ላፑን ግልቃነ ላፍዳ ሚዛት ላፑን ላይꬃታ፥ ቃስ ዶሎሀ ባጋ ጫርኩዋን ሹልዳ፥ ሌኦ ላፑን ሞርኤት ላፑን ኮሻ ላይꬃታ። ");
INSERT INTO gofe_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","“ታኒ ካዋስ ኦድዳይሳዳካ፥ ፆሳይ ባ ኦꬃና ሀንያባ ካዋ በስስ። ");
INSERT INTO gofe_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","ላፑን ዳሮ ካሎ ላይꬃት ግብፀ ቢታ ኡባን ያና። ");
INSERT INTO gofe_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","ሽን ሄሳፈ ጉየ፥ ላፑን ኮሻ ላይꬃት ካልድ ያና። ሄ ዎደ ግብፀ ካሎይ ኡባይ ዶገታና፥ ኮሽ ቢታ ጫጫና። ");
INSERT INTO gofe_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","ኮሻይ ዳሮ ኢታ ግድያ ግሾ ሄ ቢታ ካሎይ ዶገትድ አታና። ");
INSERT INTO gofe_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","ናምኡ ኦግያን ካዋስ ሄ አሙሆይ በንትዳይ ፆሳይ ባ ቆፕዳባ ኦꬃናዉ ቃንፅዳ ግሾሳ። ሄሳ ፆሳይ ማታ ዎደን ኦꬃና። ");
INSERT INTO gofe_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“ሀእ ህዛ፥ ኔኒ ኤራንቾነ ጭንጫ አስ ኮያዳ ግብፀ ቢታን ሹማ። ");
INSERT INTO gofe_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","ላፑን ካሎ ላይꬃን ካፅያ ካꬃፈ እቻሹ ኩሽያፐ እሱዋ ሺሻና አሳታ ሹማ። ");
INSERT INTO gofe_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","ኤንቲ ያ ካሎ ላይꬃን ካꬃ ሺሽድ፥ ባንታ አዋተꬃን ካታማን ካታማን ምንጅድ ዎꬃና መላ ኪታ። ");
INSERT INTO gofe_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","ቢታይ ኮሻን ꬋዮና መላ ሀ ካꬃይ ግብፀ ቢታን ላፑን ላይꬃን ደንዳና ኮሻስ ምንጀትድ ደኦ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","ያትን ሄ ኦዳይ ግብፀ ካዋስነ እያ ሞርናታስ ሎኦ ግድድ በንትስ። ");
INSERT INTO gofe_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","ሄሳ ግሾ፥ ካዎይ ኤንታኮ፥ “ዮሰፋፐ አꬍያ ሀራ ፆሳ አያናራ ደእያ አስ ደማናዉ ዳንዳኦኮ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","ሄሳፈ ጉየ፥ ካዎይ ዮሰፋ፥ “ፆሳይ ሀይሳ ኡባ ነና ኤርስዳ ግሾ፥ ነ መላ ኤራንቾይነ ጭንጫ አስ ኦንካ ባዋ። ");
INSERT INTO gofe_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","ታኒ ነና ታ ቢታን ሹማስ። ታ አሳ ኡባይ ነዉ ኪተታና። ታፐ ሀር ኔፐ አꬍያ ኦንካ ባዋ። ");
INSERT INTO gofe_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","ሄኮ፥ ታኒ ነና ግብፀ ቢታ ኡባ ቦላ ሹማስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","ሄሳፈ ጉየ፥ ካዎይ ባ ፓራምያ ምግዱዋ ባ ብራꬍያፈ ከስድ፥ ዮሰፋ ብራን አꬅስ። ቦንቾ ማኦነ ቆ ዎርቃ እያ ማይዝስ። ");
INSERT INTO gofe_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","ካዎይ ባ ናምአንꬆ ፓራ ጋርያ ዮሰፋ ቶግስስ። ቦንቾ ዎታዳረይ፥ “ዝግተ! ዝግተ!” ያግሸ እያፐ ስንꬃራ ሄመቴስ። ሄሳዳ ኦꬅድ፥ ካዎይ እያ ግብፀ ቢታ ኡባ ቦላ ሹምስ። ");
INSERT INTO gofe_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","ሄሳፈ ጉየ፥ ካዎይ ዮሰፋ፥ “ታኒ ካዎ ግድኮካ ነ ኪቶና ኦንካ ግብፀ ቢታ ኡባን ባ ኩሽያ ዎይኮ ባ ቶሁዋ ቃፆፎ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","ካዎይ ዮሰፋ፥ “ፃፍናት-ፓእና” ግድ ሱንꬅስ። እ እያዉ ኦና ካታማ ካህንያ ጶፅፋራ ናእዉ አስናቶ ማቾ እሚስ። ያንን፥ ዮሰፍ ግብፀ ቢታ ኡባ ቦላ ማታ ኤክስ። ");
INSERT INTO gofe_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","ዮሰፍ ግብፀ ካዋስ ኦሶ ኦይክያ ዎደ፥ እያዉ ላይꬅ ሀስታማ። ዮሰፍ ካዋ ስንꬃፈ ከይድ፥ ግብፀ ቢታ ኡባ ግዶን ሄመትስ። ");
INSERT INTO gofe_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","ሄ ላፑን ካሎ ላይꬃን ቢታን ዳሮ ካꬅ ካፅስ። ");
INSERT INTO gofe_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","ዮሰፍ ግብፀ ቢታን ሄ ላፑን ካሎ ላይꬃ ካꬃ ኡባ ሺሽድ፥ ካታማታን ምንጅስ። እስ እስ ካታማ ዩሹዋን ደእያ ጋድያፐ ካꬃ ኡባ ሄ ካታማታን ሺሽስ። ");
INSERT INTO gofe_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","ዮሰፍ አባ ሻፍያ መላ ዳሮ ካꬃ ሺሽስ። ካꬃ ዳሮተꬃፈ ደንዶይሳን ማካናዉ ዳንዳኤትቦና ግሾ፥ ማክ ማክ ቆለይሳ አጋግስ። ");
INSERT INTO gofe_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","ኮሻ ላይꬅ ያናፐ ስን፥ ኦና ካታማ ካህነ ጶፅፋራ ናኤ አስናትፐ ዮሰፍ ናምኡ አደ ናይታ የልስ። ");
INSERT INTO gofe_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","ዮሰፍ ባ ባይራ ናኣ ሱንꬃ፥ “ፆሳይ ታና ታ መቱዋነ ታ አዋ ሶ አሳ ኡባ ዶግስስ” ግድ ምናሰ ግድ ሱንꬅስ። ");
INSERT INTO gofe_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","ናምአንꬆ ናኣ ሱንꬃካ፥ “ፆሳይ ታ መቶትዳ ቢታን ታዉ ናአ እሚስ” ግድ ኤፍሬማ ግድ ሱንꬅስ። ");
INSERT INTO gofe_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","ግብፀ ቢታን ደእያ ሄ ላፑን ካሎ ላይꬃት አꬍዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","ዮሰፍ ኦድዳይሳዳ ላፑን ኮሻ ላይꬃት ካል ይዶሶና። ሀራ ቢታ ኡባን ኮሽ ከይስ፥ ሽን ግብፀ ቢታ ኡባን ካꬃይ ደኤስ። ");
INSERT INTO gofe_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","ግብፀ ቢታይ ኡባይ ኮሻትዳ ዎደ፥ አሳይ ካꬃስ ካዋኮ ዋስዶሶና። ካዎይ ግብፀ አሳ ኡባ፥ “ዮሰፋኮ ብድ፥ እ ኦደይሳ ኦꬅተ” ያግድ ኪትስ። ");
INSERT INTO gofe_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","ኮሻይ ግብፀ ቢታ ኡባ ጋክዳ ዎደ፥ ዮሰፍ ካꬃ ምንጅዳ ሻለታ ኡባ ዶይድ፥ ካꬅ ግብፀ አሳስ ባይዝስ። ");
INSERT INTO gofe_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","ቢታ ኡባን ኮሽ ሱልዳ ግሾ፥ ሳአን ደእያ አሳ ኡባይ ካꬅ ዮሰፋፐ ሻማናዉ ግብፀ ይዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","ያይቆብ ግብፀን ካꬅ ደኤይሳ ስእዳ ዎደ ባ አደ ናይታ፥ “ህንተ እሶይ እሱዋ አይስ ፄሌቲ? ");
INSERT INTO gofe_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","ግብፀን ካꬅ ደኤይሳ ታኒ ስአስ፤ ያ ብድ፥ ኑኒ ሀይቆና መላ ጉꬃ ካꬅ ሻምተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","ያትን፥ ዮሰፋ እሻት ታማት ካꬅ ሻማናዉ ግብፀ ብዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","ሽን ያይቆብ እ ቆሄታና ግድ ህርግዳ ግሾ ዮሰፋ እሻ ብንያመ እያ እሻታራ የድቤና። ");
INSERT INTO gofe_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","ካናነ ቢታን ዎልቃማ ኮሽ ደእያ ግሾ፥ ካꬅ ሻማናዉ በይሳታራ እስራኤለ አደ ናይት ግብፀ ገልዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","ሄ ዎደ ዮሰፍ ሄ ቢታ አይስያ ግሾ ቢታን ደእያ አሳ ኡባስ ካꬅ ባይዜስ። ሄሳ ግሾ፥ ዮሰፋ እሻት ያ ጋክዳ ዎደ ባንታ ሶምኡዋ ሳአ ጋꬅድ እያዉ ዝግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","ዮሰፍ ባ እሻታ በእዳ መላካ ኤር አግስ። ሽን እ ኤንታ ኤሮና አሳዳ ሀንድ፤ ኤንታኮ፥ “ህንተ አዉፐ ይደት?” ያግድ ኦይችስ። ኤንቲ፥ “ካꬅ ሻማናዉ፥ ካናነ ቢታፈ ይዳ” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","ዮሰፍ ባ እሻታ ኤርስ፥ ሽን ኤንቲ እያ ኤርቦኮና። ");
INSERT INTO gofe_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","ዮሰፍ ኤንታባ አሙህዳ ባ አሙሁዋ አኬክድ ኤንታኮ፥ “ህንተ ዎቻናዉ ይዳ አስ፥ ህንተ ኑ ቢታን ናጎይ ለፕያ ባጋይ አዉነኮ በአናዉ ይደታ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","ኤንቲ፥ “አካይ፥ ኑ ጎዳዉ፥ ኑኒ ዎቻናዉ ይዳ አስ ግዶኮ። ኑኒ ነ አይለት ካꬅ ሻማናዉ ይዳ። ");
INSERT INTO gofe_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","ኑኒ ኡባይካ እስ አዋ ናይታ። ኑኒ ነ አይለት አማነትያ አስ” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","ዮሰፍ ኤንታኮ፥ “አካይ፥ ህንተ ኑ ቢታን ናጎይ ለፕያ ባጋይ አዉነኮ በአናዉ ይደታ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","ሽን ኤንቲ፥ “ኑኒ ነ አይለት ካናነ ቢታን ደእያ እስ ኡራ ናይታ፤ ኑኒ ታማነ ናምኡ እሻንታ። ዉርሰꬃ ካሎይ ሀእ ኑ አዋራ ሶን ደኤስ፥ እሶይ ሀይቅስ” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","ዮሰፍ ኤንታኮ፥ “ታኒ ህንተዉ ኦድዳይሳዳ ህንተ ቢታ ዎቸይሳታ። ");
INSERT INTO gofe_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","ህንተ ፓጨታናይስ ሀይሳና፤ ቱማ ካዎይ ሀይቆ፥ ህንተ ዉርሰꬃ ካሎ እሻይ ሀይሳ ዮና እፅኮ፥ ህንተ ሀ በሳፈ ቤከታ። ");
INSERT INTO gofe_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","ህንተ ኦደይስ ቱማ ግደይሳ ፓጫናዉ፥ ህንተፈ እሱዋ ኪትተ። እ ህንተ እሻ ኤክድ ዮ፥ አትዳይሳት ቃሾ ኬꬃን ጋምኤታ። ሄስ ሃኖና፥ ካዎይ ሀይቆ፥ ህንተ ቢታ ዎቸይሳታ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","ኤንታና ሄꬑ ጋላስ ቃሾ ኬꬃን ቃችስ። ");
INSERT INTO gofe_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","ሄꬓንꬆ ጋላሳን ዮሰፍ ኤንታኮ፥ “ታኒ ፆሰ ያይያ አስ። ያንያ ግሾ፥ ህንተ እስባ ኦꬅኮ ህንተ ሸምፑዋ አሻና። ");
INSERT INTO gofe_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","ህንተ ቱማካ አማነትያ አሰ ግድኮ፥ ህንተ እሻታፐ እሶይ ሀይሳን ቃሾ ኬꬃን ደኦ፤ አትዳይሳት ኮሻትያ ህንተ ሶ አሳስ ካꬅ ኤፍተ፤ ");
INSERT INTO gofe_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","ሽን ህንተ ዉርሰꬃ እሻ ታኮ ኤህኮ፥ ህንተ ቃላይ ቱማታና፤ ህንተካ ሀይቆና አታና” ያግስ። ኤንትካ እያ ኦዳ ኤሮ ግድ ኤክዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","ኤንቲ እሶይ እሱዋኮ፥ “ቱማ ኑኒ ኑ እሻስ ኦꬅዳባይ ኑና ካኤስ። እ ባ ሸምፑዋስ ዋትዋትድ ዎስያ ዎደ ኑኒ ስእሸ እፅዳ። ሄሳ ግሾ፥ ሀ ዋየይ ኑና ጋክስ” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","ሮቤል፥ “ታኒ ህንተና፥ ናኣ ቦላ ናጋራ ኦꬆፍተ ጋዳ ኦዳስ፥ ሽን ህንተ ስኦና እፅደታ። ሀእ እያ ሱꬃይ ኑና አቼስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","ዮሰፍ ኤንታራ ቱርጁማነን ኦደትያ ግሾ ኤንቲ ግያባ እ ኤረይሳ ኤንቲ አኬክቦኮና፤ ");
INSERT INTO gofe_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","እ ኤንታፈ ሀራሶ ብድ ዬክስ። ሽን ዛር ኤንታኮ ይድ፥ ኤንታዉ ጉጅድካ ኦድስ። እ ስሞና ኤንታ ግዶፈ ከስድ ኤንቲ በእሽን ቃችስ። ");
INSERT INTO gofe_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","ዮሰፍ ባ አይለታ፥ “ካꬃ ኤንታ ኦጎሩዋን ኩንꬅተ፤ ኤንታ ሚሽያካ ዛሪድ፥ ኤንታ ኦጎሩዋን ኦጎሩዋን የግተ። ኤንታዉ ኦገስ ሽንቀካ እምተ” ያግድ ኪትስ። ");
INSERT INTO gofe_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","ኤንቲ እ ግዳይሳዳ ኦꬅዳፐ ጉየ፥ ዮሰፋ እሻት ካꬃ ባንታ ሀረታ ቦላ ጫንድ ብዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","ኤንቲ ቃማ አቅያ በሳን ኤንታፈ እሶይ ባ ሀርያስ ካꬃፈ የጋናዉ ባ ኦጎሩዋ ብልድ፥ ሄ ኦጎሩዋ ዶናን ደእያ ባ ሚሽያ ደምስ። ");
INSERT INTO gofe_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","እ ባ እሻታኮ፥ “ታ ሚሸይ ታዉ ስምስ፤ ቱማ ሀይሳ በእተ፤ ታ ኦጎሩዋን ደኤስ” ያግስ። ኤንቲ ዳጋምድ ኮኮርሸ፥ እሶይ እሱዋኮ ስሚድ፥ “ፆሳይ ኑ ቦላ ኦꬅዳባይ ሀይስ አይቤ?” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","ኤንቲ ካናነ ቢታን ደእያ ባንታ አዋ ያይቆባኮ ይድ፥ ባንታና ጋክዳባ ኡባ እያዉ ኦድዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","ኤንቲ እያኮ፥ “ሄ ቢታ ሃርያ ኡራይ፥ ኑና ሄ ቢታ ዎችያ አሳዳ ኦꬅድ ኑ ቦላ ይሎትድ ኦደትስ። ");
INSERT INTO gofe_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","ሽን ኑኒ እያኮ፥ ‘ኑኒ አማነትያ አስ፥ ቢታ ዎቸይሳታ ግዶኮ። ");
INSERT INTO gofe_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","ኑኒ ታማነ ናምኡ እሻንት እስ አዋ ናይታ። እሶይ ሀይቅስ፤ ዉርሰꬃ ካሎይ ካናነ ቢታን ሀእ ኑ አዋራ ደኤስ’ ያግዳ። ");
INSERT INTO gofe_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","ያትን ሄ ቢታ ሃርያ ኡራይ ኑና፥ ‘ህንተ አማነትያ አሰ ግደይሳ ታኒ ኤራና መላ ህንተ እሻታፐ እሱዋ ሀይሳን ታ ማታን አግድ፥ ኮሻትያ ህንተ ሶ አሳስ ካꬅ ኤክድ ቢተ። ");
INSERT INTO gofe_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","ህንተ ቢታ ዎቸይሳታ ግዶና፥ አማነትያ አስ ግደይሳ ታኒ ኤራና መላ፥ ህንተ ዉርሰꬃ እሻ ታኮ ኤክድ ዪተ። ያትኮ፥ ታኒ ሀን አትዳ ህንተ እሻ ህንተዉ ዛራዳ እማና። ህንተካ ሀ ቢታን ደእድ ዛልአናዉ ዳንዳኤታ’ ” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","ኤንቲ ባንታ ኦጎሩዋፐ ካꬃ ቆልሸ፥ ባንታ ኦጎሩዋን ኦጎሩዋን ባንታ ሚሽያ ቃሹዋራ ኡትዳይሳ ደምዶሶና። ኤንትነ ኤንታ አዋይ ሄ ቃሹዋራ ደእያ ሚሽያ በእድ ያይዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","ኤንታ አዋ ያይቆብ ኤንታኮ፥ “ህንተ ታና ታ ናይታፐ መላ አሽደታ። ዮሰፍ ባዋ፥ ስሞን ባዋ፥ ሀእ ቃስ ብንያመ ኤፋናዉ ኮዬታ። ኡባባይ ታዉ ዞኮ ዛርስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","ሄሳፈ ጉየ፥ ሮቤል ባ አዋኮ፥ “ታኒ ብንያመ ነዉ ዛራዳ ኤሆና እፅኮ፥ ታ አደ ናይታ ናምኣካ ዎꬋ። ታና አማነታዳ እያ ታ ኩሸን የጋ፤ ታኒ እያ ዛራዳ ኤሀና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","ሽን ያይቆብ ኤንታኮ፥ “ታ ናአይ ህንተራ ቤና፤ እያ እሻይ ሀይቅን፥ አትዳይ እያ ፃላላ። ህንተ ኤፍሽን፥ ኦገን ኢታባይ እያ ጋክኮ፥ ህንተ ታ ጭማተꬃ አፉꬁ ሙዝሸ ታ ሀይቁዋ ማታየታ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","ካናነ ቢታን ኮሻይ ሀእካ ካሰይሳፈ አꬍድ ዎልቃምስ። ");
INSERT INTO gofe_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","ያንን፥ ኤንቲ ግብፀፈ ኤህዳ ካꬃ ኡባ ምድ ኦንግን፥ ኤንታ አዋይ፥ “ቃስካ ግብፀ ብድ ኑስ ጉꬃ ካꬅ ሻምተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","ሽን ይሁድ፥ “ሄ ኡራይ ኑና፥ ‘ህንተ እሻይ ህንተራ ዮና እፅኮ፥ ታ ሶምኡዋ ዛር በኤከታ’ ያግድ ምንꬅድ ኦድስ። ");
INSERT INTO gofe_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","ኔኒ ኑ እሻ ኑራ የድኮ፥ ኑኒ ግብፀ ብድ ነዉ ካꬅ ሻማና። ");
INSERT INTO gofe_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","ሽን ሄ ኡራይ፥ ‘ህንተ እሻይ ህንተራ ዮና እፅኮ ህንተ ታ ሶምኡዋ ዛር በኤከታ’ ” ያግዳ ግሾ፥ ኔኒ እያ የዶናባ ግድኮ ኑኒ ቦኮ። ");
INSERT INTO gofe_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","ያትን እስራኤለይ፥ “ህንተ፥ ‘ኑስ ሀራ እሽ ደኤስ’ ግድ ኦድድ ሀ መቱዋ ታ ቦላ አይስ ኤህደቲ?” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","ኤንቲ ዛሪድ፥ “ሄ ኡራይ ኑባነ ኑ ሶ አሳባ ምንꬅድ ኦይችስ። እ ኑኮ፥ ‘ህንተ አዋይ ፓፃ ደኢ? ህንተዉ ሀራ እሽ ደኢ?’ ያግድ ኦይችስ። ኑኒ እ ኦይችዳይሳ እያዉ ዛርዳ። እ ኑና፥ ‘ህንተ እሻ ኤክ ዪተ’ ጋናባ ኑ አዉደ ኤርዶ?” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","ይሁድ ባ አዋ እስራኤለኮ፥ “ኑኒ፥ ኔንነ ኑ ናይት ኮሻን ሀይቃናፐ ናኣ ታራ የዳ፥ ኑኒ ባና። ");
INSERT INTO gofe_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","ናአ ታ ዋሰተꬃን እማ፤ እያባ ታና ኦይቻ። ታኒ እያ ነዉ ሳሮ ዛራዳ ኤሆና እፅኮ፥ ታ ደኦ ኡባን ነ ባደꬃይ ታና ጋኮ። ");
INSERT INTO gofe_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","ኑ ጋምኦናባ ግድያኮ፥ ሀኖደ ናምአንꬆ ያ ስማና ሽን” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","ኤንታ አዋይ እስራኤለይ፥ “ሄሳ ግድኮ ሃረይሳስ ኩሸ ገንꬅያባ፥ ሀ ቢታን ካፅያባ ኡባፈ ሎኦባ ዶርተ። ሄስካ፥ ቅባተ፥ ሽቶ፥ ዱማ ዱማ ሳዎ፥ ኤስነ፥ ኦቾሎነ ህንተ ኦጎሩዋን የግድ፥ ኤክድ ቢተ። ");
INSERT INTO gofe_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","ህንተ ኦጎሩዋ ዶናን ስምዳ ሚሸይ ባለትዳባ ግዳናዉ ዳንዳእያ ግሾ፥ ሚሽያ ናምኡ ኩሸ ኦꬅድ ኤክ ቢተ። ");
INSERT INTO gofe_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","ህንተ እሻ ኤክድ፥ ሄ ኡራኮ ኤለስድ ጉየ ቢተ። ");
INSERT INTO gofe_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","እ ሀንኮ ህንተ እሻነ ብንያመ ህንተራ የዳና መላ ኡባ ዳንዳእያ ፆሳይ ሄ ኡራይ ህንተዉ ቃታናዳ ኦꬆ። ታና ግድኮ፥ ታ ናይታፐ መላ አትኮካ አታስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","ሄሳ ግሾ፥ እሻንት ዎላ ባንታ እምያባታ፥ ናምኡ ኩሸ ሚሽያነ ብንያመ ባንታራ ኤክድ ብዶሶና። ኤንቲ ግብፀ ጋክድ፥ ዮሰፋ ስን ሺቅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","ዮሰፍ ብንያመ ኤንታራ በእዳ ዎደ ባ ኬꬃ ካፑዋኮ፥ “ሀ አሳታ ታ ሶ ኤካዳ ባ። እስ መሄ ሹካዳ ጊግሳ፤ ኤንቲ ካꬅ ታራ ማና” ያግድ ኪትስ። ");
INSERT INTO gofe_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","ያትን ካፖይ፥ ዮሰፍ ኪትዳይሳዳ ሄ አሳታ እያ ሶ ኤፍስ። ");
INSERT INTO gofe_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","ኤንቲ ዮሰፋ ሶ ብሸ፥ ያይድ፥ “ኤንቲ ኑና ሀይሳ ኤህዳይ ኮይሮ ኑ ኦጎሩዋን ስምዳ ሚሽያ ግሾ ግዶና አገና። ኤንቲ ኑና ቆህድ አይለተꬃን ሃሮናነ ኑ ሀረታ ኤኮና አጎኮና” ያግ ህርግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","ሄሳ ግሾ፥ ኤንቲ ዮሰፋ ሶ ፐንገ ጋክድ፥ ኬꬃ ካፑዋ ኦድስዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“ጎዳዉ፥ ኑኒ ኮይሮ ካꬅ ሻማናዉ ሀይሳ ይዳ። ");
INSERT INTO gofe_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","ጉየ ስምሸ ኑኒ ቃማ አቅያ በሳን ኦጎሩዋ ብልያ ዎደ ሁጰን ሁጰን ኑ ሚሸይ ፓጮና ኑ ኦጎሩዋን ደኤይሳ ደምዳ። ሄኮ፥ ኑኒ ሄ ሚሽያ ጉየ ኤክ ይዳ። ");
INSERT INTO gofe_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","ሀእ ኑኒ ካꬃ ሻማናዉ ሀራ ሚሸ ኦይክ ይዳ። ኑ ሚሽያ ኑ ኦጎሩዋን ኦን የግዳኮ ኤሮኮ” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","እ ዛሪድ፥ “አይኮይ ባዋ፥ ያዮፍተ፤ ህንተ ፆሳይ፥ ህንተ አዋ ፆሳይ፥ ህንተ ኦጎሩዋን ህንተዉ ሚሸ እሚስ። ታኒ ህንተ ጭግዳ ሚሽያ ኩመꬅ ኤካስ” ያግስ። ሄሳፈ ጉየ፥ ስሞና ኤንታኮ ከስስ። ");
INSERT INTO gofe_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","ሄ ኡራይ ሄ አሳታ ዮሰፋ ሶ ኤፍድ፥ ኤንታ ቶሁዋስ ሃ ኤህን፥ ኤንቲ ሜጨትዶሶና። ኤንታ ሀረታስካ ምያባ የግስ። ");
INSERT INTO gofe_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","ኤንቲ ዮሰፋራ ካ ማናይሳ ስእዳ ግሾ ባንታ እማናባታ ዮሰፋስ ጊግስዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","ዮሰፍ ባ ሶ ገልዳ ዎደ ኤንቲ ኤህዳ ባንታ እምያባታ እያዉ እምድ፥ እያ ስንꬃን ሳአ ጋክድ ዝግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","እ ኤንታ ሳሮተꬃ ኦይች ስሚድ፥ “ህንተ ታዉ ኦድዳ ህንተ ጭምዳ አዋይ ሎኦ ደኢ? ሀእካ እ ፓፃ ደኢ?” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","ኤንቲ፥ “ኤ፥ ነ አይለይ፥ ኑ አዋይ ፓፃ ደኤስ፤ እ ሎኦ” ያግድ፥ ሆክድ እያዉ ዝግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","እ ባ አየ ናኣ ብንያመ በእዳ ዎደ ኤንታኮ፥ “ህንተ ኦድዳ ዉርሰꬃ ህንተ እሻይ ሀይሴ?” ያግስ። ብንያመ፥ “ታ ናአዉ፥ ነና ፆሳይ አንጆ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","ዮሰፍ፥ እያ እሻባይ እያዉ ጎምፓን ሴልዳ ግሾ፥ ኤለስድ፥ ቆልአ ገልድ ያን ዬክስ። ");
INSERT INTO gofe_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","እ ባ ሶምኡዋ ሜጨትዳፐ ጉየ ከይድ ባና ምንꬅድ፥ ካꬅ አꬃና መላ ኪትስ። ");
INSERT INTO gofe_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","ኤንቲ ዮሰፋስ ዱማ፥ እያ እሻታስ ዱማ አꬅዶሶና። ግብፀ አሳይ እብራወ አሳታራ እስፈ መይስ ባንታና ካዉሽያባ ኦꬅ ፄልያ ግሾ እያራ ምያ ግብፀ አሳታስ ዱማ አꬅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","ኤንቲ ዮሰፋ ስንꬃን ባይራይ ባ ባይራተꬃን፥ ካሎይ ባ ካሎተꬃን ማራን ኡትዶሶና። ኤንቲ እሶይ እሱዋ ፄልድ፥ ኤንታ ዋትድ ኡትስዳኮ በእድ ማላለትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","ዮሰፋ ጋይታፐ ኤንታዉ ቁም ግሸቴስ፥ ሽን ብንያመስ ሀራታፐ አꬅድ እቻሹ ኩሸ እሚስ። ያንድ፥ ኤንቲ ዮሰፋራ ምድ ኡይድ ኡፋይትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","ዮሰፍ ባ ኬꬃ ካፑዋ፥ “ኔኒ ሀ አሳት ቶካናዉ ደንዳእዳ ኬና ኤንታ ኦጎሩዋን ካꬅ ኩንꬃ። ኤንታ ኡባ ሚሽያ ኤንታ ኦጎሩዋ ዶናን ዶናን የጋ። ");
INSERT INTO gofe_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","ያታዳ ዉርሰꬃ ካሉዋ ኦጎሩዋ ዶናን ታ ብራ ዋንጫነ እ ሻማናዉ ኤህዳ ሚሽያ የጋ” ያግድ ኪትስ። እ ዮሰፍ ግዳይሳዳ ኦꬅስ። ");
INSERT INTO gofe_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","ሳእ ዎንትን ሄ አሳት ባንታ ሀረታ ኤክድ ባናዉ ደንድዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","ኤንቲ ሄ ካታማፐ ከይድ ሃክ ቦና ደእሽን፥ ዮሰፍ ባ ኬꬃ ካፑዋኮ፥ “ሀ አሳታ ጌዶ ካላ። ኔኒ ኤንታ ጋክዳ ዎደ ኤንታኮ፥ ‘ህንተ አይስ ኬሀ ኢታን ዛርደቲ? ");
INSERT INTO gofe_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","ሀይስ ታ ጎዳይ ኡየይሳነ ፁራባ ደምያ ዋንጫ ግደይሳ ኤረከቲ? አይስ ካይሶትደቲ? ሀይስ ህንተ ኦꬅዳባይ ዳሮ ኢታባ’ ያጋ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","ያትን እ ኤንታ ጌዶ ካል ጋክድ፥ ሄ ግዳይሳዳካ ኤንታዉ ኦድስ። ");
INSERT INTO gofe_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","ሽን ኤንቲ፥ “ጎዳዉ ሀይሳ መላባ አይስ ኦደታይ? ሄሳ መላባ ኦሶይ ኑፐ ነ አይለታፐ ሃኮ። ");
INSERT INTO gofe_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","ኑኒ ሀር አቶሽን፥ ኑ ኦጎሩዋ ዶናፐ ደምዳ ሚሽያ ካናነ ቢታፈ ጉየ ዛሪድ ነዉ ኤህዳይሳ ኤራሳ። ነ ጎዳ ኬꬃፈ ኑኒ ዎርቃ ዎይኮ ብራ ዋት ካይሶታኔ? ");
INSERT INTO gofe_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","ነ አይለታ ግዶን ሄ ዋንጫይ በንትዳ ኡራይ ሀይቆ። ቃስ አትዳ ኑካ ኑ ጎዳስ አይለ ግዳና” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","እ ኤንታኮ፥ “ሄሳ ግድኮ ሎኦ፥ ህንተ ግዳይሳዳ ሀኖ። ዋንጫ ኤክዳ ኦንካ ታ አይለ ግዳና፤ አትዳይሳት ሳሮን ቤታ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","ሄሳፈ ጉየ፥ ኤንቲ ኤለስድ ባንታ ኦጎሩዋ ኦጎሩዋ ሳአን ዎꬅድ ብልዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","ሄ ካፖይ ኡባፈ ባይራ ኦጎሩዋፐ ዶምድ ዉርሰꬃ ካሉዋይሳ ጋካናስ ኮይድ፥ ሄ ዋንጫ ብንያመ ኦጎሩዋፐ ደምስ። ");
INSERT INTO gofe_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","ሄሳን ኤንቲ አዛንድ፥ ባንታ ማኡዋ ፔꬍዶሶና። ባንታ ኦጎሩዋ ሀረታ ቦላ ጫንድ፥ ጉየ ካታማ ስምዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","ይሁድ ባ እሻታራ ዮሰፋኮ ገልያ ዎደ ዮሰፍ ሶን ደኤስ፤ ኤንቲ እያ ስንꬃን ሳአን ጉፋንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","ዮሰፍ ኤንታኮ፥ “ህንተ አይብ ፓላባ ኦꬅደቲ? ታ መላ አስ ፁራባ ደማናዉ ዳንዳኤይሳ ህንተ ኤረከትዬ?” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","ይሁድ፥ “ታ ጎዳስ ኑኒ አይ ጋኔ? ኑኒ አይ ኦደትያባይ ደኢ? ኑ ፅሎተꬃ ኑኒ ዋት በሳኔ? ፆሳይ ነ አይለታ ናቁዋ ቆንጭስስ። ህዛ ኑኒካ ሄ ዋንጫይ በንትዳ ኡራይካ ታ ጎዳስ አይለ ግድዳ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","ሽን ዮሰፍ፥ “ሄሳ መላባ ኦꬃናይስ ታፐ ሃኮ፤ ታ ዋንጫይ እያፐ በንትዳ ኡራ ፃላል ታ አይለ ግዳና። ሀንኮ ህንተ ህንተ አዋኮ ጉየ ሳሮ ስምተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","ይሁድ እያኮ ሺቅድ “ታ ጎዳዉ፥ ኔኒ ካዋ መላ ግድኮካ ታኒ ኔራ ኦደታናዉ ነና ዎሳይስ። ታና ነ አይልያ ሀንቀቶፋ። ");
INSERT INTO gofe_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","ኔኒ ታ ጎዳይ ኑና ነ አይለታ፥ ‘ህንተዉ አው ዎይኮ እሽ ደኢ?’ ጋዳ ኦይቻዳሳ። ");
INSERT INTO gofe_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","ኑኒካ፥ ‘ኑስ ጭምዳ አዋይ ደኤስ። እ ጭማተꬃን የልዳ ካሎ ናአይካ ደኤስ። ሄ ናኣ እሻይ ሀይቅስ፥ ባ አየን እስኖ፥ እያ አዋይ እያ ዳሮ ዶሴስ’ ያግዳ። ");
INSERT INTO gofe_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","“ኔኒ ኑኮ፥ ‘ታኒ እያ በአና መላ ታዉ ኤህተ’ ያጋዳሳ። ");
INSERT INTO gofe_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","ያትን ኑኒ፥ ‘ሄ ናአይ ባ አዋፐ ሻከታናዉ ዳንዳኤና፤ ሻከትኮ እያ አዋይ ሀይቃና’ ያግዳ። ");
INSERT INTO gofe_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","ሽን ኔኒ፥ ‘ህንተ ካሎ እሻይ ህንተራ ዮና እፅኮ፥ ታ አይፍያ ዛር በኤከታ’ ያጋዳሳ። ");
INSERT INTO gofe_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","ኑኒ ኑ አዋኮ ስሚድ ብዳ ዎደ ነ ግዳይሳ እያዉ ኦድዳ። ");
INSERT INTO gofe_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“ኑ አዋይ፥ ‘ጉየ ብድ ጉꬃ ካꬅ ሻምተ’ ያግን፥ ");
INSERT INTO gofe_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","ኑኒ እያኮ፥ ‘ኑ ካሎ እሻይ ኑራ ቦና እፅኮ፥ ኡራ አይፍያ በአናዉ ዳንዳኦኮ። ኑ ካሎ እሻይ ኑራ ብያባ ግድኮ፥ ኑኒ ያ ባና’ ያግዳ። ");
INSERT INTO gofe_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“ያትን ኑ አዋይ ኑና፥ ‘ታ ማችያ ራሄላ ታዉ ናምኡ አደ ናይታ የልዳይሳ ህንተ ኤሬታ። ");
INSERT INTO gofe_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","ኤንታፈ እሶይ ታፐ ሻከትድ ብን፥ እያ ዶእ ሞና አገና ያጋስ። ሀች ጋካናዉ ታኒ እያ በአብከ። ");
INSERT INTO gofe_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","ሀይሳ ቃስ ታፐ ህንተ ሻክ ኤፍን፥ ኢታባይ እያ ጋክኮ፥ ህንተ ታና ታ ጭማተꬃን አፉꬁ ሙዝሸ ታ ሀይቁዋ ማታየታ’ ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","“ሄሳ ግሾ፥ ሀእ ታኒ ጉየ ታ አዋኮ ብያ ዎደ ብንያመይ ታራ ባናዉ በሴስ። ታ አዋይ ናኣ ሸምፖፈ ዶስያ ግሾ፥ ናአይ ኑራ ባይናይሳ በእኮ ሀይቃና። ኑኒ ነ አይለት ኑ አዋ ጭማተꬃ አፉꬃን ዱፎ ገልሶስ። ");
INSERT INTO gofe_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","ታኒ ነ አይለይ ናኣ ታ ዋሰተꬃን ኤካስ። ቃስ፥ ‘ታ አዋዉ፥ ታኒ እያ ነዉ ሳሮ ዛራዳ ኤሆና እፅኮ ታ ደኡዋ ኡባን ነ ባደꬃይ ታና ጋኮ’ ያጋስ። ");
INSERT INTO gofe_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","“ያንያ ግሾ፥ ታኒ ነ አይለይ ናኣ ግሾ አይለታዳ ሀይሳን አታና ናአይ ባ እሻታራ ጉየ ስሞ። ");
INSERT INTO gofe_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","ናአይ ባይና ታኒ ዋናዳ ጉየ ታ አዋኮ ስማኔ? ታና ታ አዋይ ሴለታና ሴላ በሶፎ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","ሄ ዎደ ዮሰፍ ባ አይለታ ስንꬃን ገንጫናዉ ዳንዳእቦና ግሾ፥ “አሳ ኡባ ታ ስንꬃፈ ከስተ” ያግድ ዋስስ። ሄሳ ግሾ፥ ዮሰፍ ባ እሻታስ ባና ኤርስዳ ዎደ እያራ ኦንካ አላግ ባዋ። ");
INSERT INTO gofe_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","እ ባ ቃላ ꬎቁ ኦꬅድ፥ ግብፀት እያ ስአና ጋካናዉ ዬክስ፤ ካዋ ሶ አሳይካ ሄ ዎርያ ስእዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","ዮሰፍ ባ እሻታኮ፥ “ታኒ ዮሰፋባይ። ታ አዋይ ሀኖ ጋካናስ ፓፃ ደኢ?” ያግድ ኦይችስ። ሽን እያ እሻት ዳሮ ዳጋምዳ ግሾ፥ እያዉ አይኮካ ዛራናዉ ዳንዳእቦኮና። ");
INSERT INTO gofe_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","ያንን፥ ዮሰፍ ባ እሻታኮ፥ “ታኮ ሃ ሺቅተ” ያግስ። ኤንቲ እያኮ ሺቅን እ ኤንታ፥ “ታኒ ህንተ ታና ግብፀ ቢታ ባይዝዳ ህንተ እሻ ዮሰፋ። ");
INSERT INTO gofe_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","ሀእ ህንተ ታና ባይዝዳ ግሾ፥ ቂሮቶፍተነ ህንተና ባዶፍተ። አይስ ጊኮ፥ ፆሳይ ታና ህንተፈ ስን ኪትዳይ አሳ ሸምፖ አሻናሳ። ");
INSERT INTO gofe_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","ሀ ቢታ ኮሽ ገልን ሀይስ ናምአንꬆ ላይꬅ። አስ ጎዮና ዎይኮ ጫኮና ሀራ እቻሹ ላይꬃት ቡሮ ደኦሶና። ");
INSERT INTO gofe_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","ሽን ታኒ ሳአን ህንተ ሼሻነ ህንተና ማላልስያ ኦገን አሻና መላ ፆሳይ ታና ህንተፈ ስን ኪትስ። ");
INSERT INTO gofe_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","ሄሳ ግሾ፥ ታና ሀ በሳ ኪትዳይ ፆሳፈ አትሽን፥ ህንተና ግደከታ። እ ታና ግብፀ ካዋስ ዞርያ አዋ፥ እያ አቆ ኡባ ቦላ ጎዳነ ግብፀ ቢታ ሃርያ አስ ኦꬅስ። ");
INSERT INTO gofe_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","“ሀእ ኤለስድ ጉየ ታ አዋኮ ብድ እያኮ፥ ነ ናአይ ዮሰፍ ሀይሳዳ ያጌስ ጊተ፤ ‘ፆሳይ ታና ግብፀ ቢታ ኡባ ቦላ ጎዳ ከስስ፤ ኔኒ ጋምኦና ታኮ ሃያ። ");
INSERT INTO gofe_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","ነ ናይታ፥ ነ ናይታ ናይታ፥ ነ ዶርሳ፥ ነ ዴሻ፥ ነ መህያነ ነዉ ደእያባ ኡባ ኤካዳ ሃያ፤ ታ ማታን ጌሳመ ቢታን ደኣሳ። ");
INSERT INTO gofe_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","ቡሮ እቻሹ ኮሻ ላይꬃት አትዶሶና። ነና፥ ነ ሶ አሳነ ነ መህያ ኮሽ ቆሆና መላ ታኒ ነና ሙዛና’ ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","ቃስካ ዮሰፍ ኤንታኮ፥ “ህንተካ፥ ታ እሻ ብንያመይካ፥ ሀ ህንተራ ኦደተይ ቱማ ታና ዮሰፋ ግደይሳ ህንተ አይፍያን በእደታ። ");
INSERT INTO gofe_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","ታዉ ግብፀ ቢታን ደእያ ግታ ቦንቹዋነ ህንተ በእዳባ ኡባ ታ አዋስ ኦድተ። ታ አዋካ ኤለስድ ሃ ኤክድ ዪተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","ዮሰፋራ ብንያመራ ናምአይ ዎሉ ቆምድ ዬክዶሶና ");
INSERT INTO gofe_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","ዮሰፍ ዬክሸ ባ እሻታ ኡባ ዬርስ። ሄሳፈ ጉየ፥ እያ እሻት እያራ ኦደትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","ዮሰፋ እሻታ ዩሳ ዎረይ ካዎ ኬꬅ ጋክዳ ዎደ ካዎይነ እያ ሞርናት ኡፋይትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","ካዎይ ዮሰፋኮ፥ “ኔኒ ነ እሻታኮ ያጋ፤ ህንተ ሀረታ ጫንድ፥ ካናነ ቢታ ስምተ። ");
INSERT INTO gofe_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","ህንተ አዋነ ህንተ ሶ አሳ ኤክድ፥ ጉየ ታኮ ሃ ዪተ። ታኒ ህንተዉ ግብፀ ቢታን ኡባፈ ሎእያ በሳ እምኮ፥ ሄ ቢታ ሞꬉዋ ህንተ ካሻና። ");
INSERT INTO gofe_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","ቃስካ፥ ባንታ ናይታ፥ ባንታ ማቸታነ ባንታ አዋ ኤሀናዉ ግብፀፈ ግታ ፓራ ጋረ ኤክ ባና መላ ኤንታ ኪታ። ");
INSERT INTO gofe_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","ግብፀ ቢታን ደእያ ኡባፈ አꬍድ ሎእያባይ ኤንታሳ ግድያ ግሾ፥ ባንታ አግድ ያ አቁዋስ ቆፖና መላ ኤንታዉ ኦዳ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","ያትን እስራኤለ አደ ናይት ካዎይ ግዳይሳዳ ኦꬅዶሶና። ዮሰፍ ካዎይ ኪትዳይሳዳ ግታ ፓራ ጋረታነ ኦገስ ሽንቀካ ኤንታዉ እሚስ። ");
INSERT INTO gofe_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","ኤንታ ኡባስ ሁጰን ሁጰን ኦራꬃ ማኦ እሚስ። ሽን ብንያመስ ታማነ ኡሱፑን ክሎ ግራመ ዴፅያ ብራነ እቻሹ ኩመꬃ ማኦ እሚስ። ");
INSERT INTO gofe_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","እ ባ አዋስ ግብፀን ደእያባፐ ሎእያባ ኡባ ታሙ አደ ሀረን ጫንድ፥ ቃስ ኦገስ ካꬅ፥ ኡይꬅነ ሀራ ካꬅ ታሙ ማጫ ሀረታን ጫንድ የድስ። ");
INSERT INTO gofe_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","ያትድ፥ ዮሰፍ ባ እሻታ ሞይዝሸ፥ ኤንታኮ፥ “ኦግያን ብሸ ኦየቶፍተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","ኤንቲ ግብፀፈ ደንድድ፥ ካናነ ቢታን ደእያ ባንታ አዋ ያይቆባኮ ስምዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","ኤንቲ ያይቆባኮ፥ “ዮሰፍ ፓፃ ደኤስ። እ ሄሳፈ አꬍድ ግብፀ ቢታ ኡባ ሃሬስ” ያግዶሶና። ያይቆብ ዳጋምድ፥ ዎዛና ꬋይዳ ግሾ፥ ኤንቲ ግያባ አማንበና። ");
INSERT INTO gofe_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","ሽን ኤንቲ ዮሰፍ ኤንታዉ ኦድዳባ ኡባ እያዉ ኦድን፥ ቃስካ እያ ኤክ ያና መላ እ የድዳ ግታ ፓራ ጋረታ እ በእን እያዉ ሸምፖይ ስምስ። ");
INSERT INTO gofe_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","እስራኤለይ፥ “ህዛ ታ አማነታስ። ታ ናኣ ዮሰፍ ሀኖ ጋካናስ ፓፃ ደኤስ። ታ ሀይቃናፐ ስን ባዳ እያ በአና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","እስራኤለይ ባዉ ደእያባ ኡባ ኤክድ፥ በርሳበ ጋክዳ ዎደ ባ አዋ ይሳቃ ፆሳስ ያርሾ ያርሽስ። ");
INSERT INTO gofe_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","ፆሳይ ቃማ እስራኤለስ ቆንጭድ፥ “ያይቆባ፥ ያይቆባ” ያግስ። እካ፥ “ሄኮ፥ አበ ጎዳዉ” ግድ ኮይስ። ");
INSERT INTO gofe_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","ፆሳይ እያኮ፥ “ታኒ ፆሳ፥ ነ አዋ ፆሳ፤ ኔኒ ግብፀ ባናዉ ባቦፋ። ታ ነ ሼሻ ያን ግታ ደረ ከሳና። ");
INSERT INTO gofe_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","ታኒ ኔራ እስፈ ግብፀ ባና፤ ታኒ ነ ሼሻ ያፐ ከሳዳ ሃ ኤሀና። ነ ሀይቅያ ዎደ ዮሰፍ ነ አይፍያ ኦይካና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","ሄሳፈ ጉየ፥ ያይቆብ በርሳበፐ ደንድስ። እስራኤለ አደ ናይት ባንታ አዋ ያይቆባ፥ ባንታ ናይታነ ባንታ ማቸታ ግብፀ ካዎይ ኤንታዉ የድዳ ግታ ፓራ ጋረ ቦላ ኡትስድ ኤፍዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","ኤንቲ ካናነ ቢታን ሃርዳ ሃሩዋነ መሄ ኡባ ኤክ ብዶሶና። ያይቆብ ባ ሶ አሳ ኡባ ኤክድ ግብፀ ብስ። ");
INSERT INTO gofe_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","እ ባ ሶ አሳ ኡባ፤ አደ ናይታነ ባ አደ ናይታ ናይታ፥ ባ ማጫ ናይታነ ባ ማጫ ናይታ ናይታ፥ ኡባ ባራ ኤክድ ግብፀ ብስ። ");
INSERT INTO gofe_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","እስራኤለራ ግብፀ ቢታ ብዳ እያ ናይታ ሱንꬃይ ሀይሳፈ ካልድ ፃፈትዳይሳ። ያይቆባ ባይራ ናአይ ሮቤላ፤ ");
INSERT INTO gofe_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","ሮቤላ አደ ናይት ሀኖካ፥ ፓላ፥ ሄስሮናነ ካርማ። ");
INSERT INTO gofe_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","ስሞና አደ ናይት ያሙኤላ፥ ያምና፥ ኦሀዳ፥ ያክና፥ ፆሃራነ ካናነ ማጫሴፐ የልዳ ሳኡላ። ");
INSERT INTO gofe_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","ሌወ አደ ናይት ገድሶና፥ ቃሀታነ መራራ። ");
INSERT INTO gofe_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","ይሁዳ አደ ናይት ኤራ፥ ኦናና፥ ሴላ፥ ፓረሳነ ዛራ። ሽን ኤርነ ኦናን ካናነ ቢታን ሀይቅዶሶና። ፓረሳ አደ ናይት ሄስሮናነ ሀሙላ። ");
INSERT INTO gofe_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","ይሳኮራ አደ ናይት ቶላ፥ ፑአ፥ ዮባነ ሽምሮና። ");
INSERT INTO gofe_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","ዛብሎና አደ ናይት ሳረዳ፥ ኤሎናነ ያህላላ። ");
INSERT INTO gofe_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","ሀ አደ ናይትነ ማጫ ናእያ ዲና፥ ልያ ማሰጰፆመ ቢታን ያይቆባስ የልዳይሳታ። ዲና ጉጅን እያ ናይትነ ናይታ ናይት ኩመꬅ ሀስታማነ ሄꬓ። ");
INSERT INTO gofe_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","ጋደ አደ ናይት ፃፎና፥ ሀገ፥ ሹና፥ ኤፅቦና፥ ኤር፥ አሮዳነ አርኤላ። ");
INSERT INTO gofe_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","አሴራ አደ ናይት ይምና፥ የሱዋ፥ ይስዋነ በርአ። ኤንታ ምችያ ሳራሆ። በርአ አደ ናይት ሄቤራነ ማልክኤላ። ");
INSERT INTO gofe_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","ሀይሳቲ ላቢ ባ ናኤ ልያስ እምዳ ዛላፋ ያይቆባስ የልዳ ናይታ። ኤንቲ ኩመꬅ ታማነ ኡሱፑና። ");
INSERT INTO gofe_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","ያይቆባ ማቸ ራሄል አደ ናይት ዮሰፋነ ብንያመ። ");
INSERT INTO gofe_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","ኦና ካታማ ካህነ ጶፅፋራ ናእያ አስናታ ዮሰፋስ ግብፀን ምናሰነ ኤፍሬማ የላሱ። ");
INSERT INTO gofe_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","ብንያመ ናይት ቤላ፥ በከራ፥ አስቤላ፥ ጌራ፥ ናማነ፥ ኤሀ፥ ኦሮሻ፥ ሙፍማ፥ ሁፍማነ አራዳ። ");
INSERT INTO gofe_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","ሀይሳቲ ያይቆባስ የለትዳ ራሄል አደ ናይታ። ኤንቲ ኩመꬅ ታማነ ኦይዳ። ");
INSERT INTO gofe_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","ዳነ አደ ናአይ ሁሽማ። ");
INSERT INTO gofe_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","ንፍታለመ አደ ናይት ያህፄላ፥ ጉና፥ የፀራነ ሽለመ። ");
INSERT INTO gofe_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","ሀይሳቲ ላፑናት ላቢ ባ ናኤ ራሄልስ እምዳ ባል ያይቆባስ የልዳ ናይታነ ናይታ ናይታ። ");
INSERT INTO gofe_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","ያይቆባራ ግብፀ ብዳ፥ እያ ጉልባታፐ ከይዳ ናይት፥ እያ ናይታ ማቸታ ጉጆና ኡሱፑን ታማነ ኡሱፑና። ");
INSERT INTO gofe_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","ግብፀን ዮሰፋስ የለትዳ ናምኡ ናይታ ጉጅኮ፥ ግብፀ ብዳ ያይቆባ ሶ አሳይ ኩመꬅ ላፑን ታማ። ");
INSERT INTO gofe_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","ጌሳመ ቢታን ባንታና ሞካና መላ ያይቆብ ይሁዳ ባፐ ስን ዮሰፋኮ ኪትስ። ኤንቲ ያ ጋክያ ዎደ፥ ");
INSERT INTO gofe_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","ዮሰፍ ባ ፓራ ጋርያ ጊግስድ፥ ባ አዋ እስራኤለራ ጋሄታናዉ ጌሳመ ብስ። ዮሰፍ ባ አዋ ደምዳ መላ እያ ቆꬍያን ፃፀትድ ዳሮ ዎደ ዬክስ። ");
INSERT INTO gofe_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","እስራኤለይ ዮሰፋኮ፥ “ኔኒ ፓፃ ደእሽን፥ ታኒ ነ አይፍያ በእዳ ግሾ፥ ህዛ ታኒ ሀይቅኮካ አይኮይ ባዋ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","ሄሳፈ ጉየ፥ ዮሰፍ ባ እሻታነ ባ አዋ ሶ አሳታኮ፥ “ታኒ ግብፀ ካዋኮ ባዳ እያኮ፥ ‘ካናነ ቢታን ደእያ ታ እሻትነ ታ አዋ ሶ አሳይ ታኮ ይዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","ኤንቲ መሄ ሃረይሳታ፥ ኤንቲ ባንታራ ባንታ ዶርሳ፥ ባንታ ዴሻ፥ መህያነ ባንታዉ ደእያባ ኡባ ኤክድ ይዶሶና’ ያጋና። ");
INSERT INTO gofe_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","ካዎይ ህንተና ፄግስድ፥ ‘ህንተ ኦሶይ አይቤ?’ ግድ ኦይችኮ፥ ");
INSERT INTO gofe_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","ህንተ እያኮ፥ ‘ኑኒ ነ አይለት ናአተꬃፈ ዶምድ ኑ አዋታዳ መሄ ሄሞስ’ ያግተ። ዶርሰ ሃርያ አስ ግብፀ አሳን ካትዳባ ግድያ ግሾ፥ እ ህንተ ጌሳመ ቢታን ዳና መላ ኦꬃና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","2","ዮሰፍ ባ እሻታፐ እቻሻታ ዶርድ ግብፀ ካዋኮ ገልድ ሀይሳዳ ያግስ፤ “ታ አዋይነ ታ እሻት፥ ባንታ ዶርሳ፥ ባንታ ዴሻ፥ ባንታ መህያነ ባንታዉ ደእያባ ኡባ ኤክድ ካናነ ቢታፈ ይድ፥ ሀእ ጌሳመን ደኦሶና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","ካዎይ ሄ እሻታኮ፥ “ህንተ ኦሶይ አይቤ?” ያግድ ኦይችስ። ኤንቲ ካዋኮ፥ “ኑኒ ነ አይለት ኑ አዋታዳ ዶርሰ ሃርያ አሳታ” ያግድ ዛርዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","ቃስካ ኤንቲ እያኮ፥ “ካናነ ቢታን ኮሽ ከይዳ ግሾነ ኑ መህያስ ምያባይ ꬋይዳ ግሾ፥ ኑኒ ሀይሳን ዳናዉ ይዳ። ሀያና ኑና ነ አይለታ ጌሳመ ቢታን ደኦ ጋርክ” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","ካዎይ ዮሰፋኮ፥ “ነ አዋይነ ነ እሻት ኔኮ ይዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","ህዛ ግብፀ ቢታይ ነ ኩሸና። ሀ ቢታን ኡባፈ አꬍድ ሎእያ በሳን ነ አዋነ ነ እሻታ ዎꬃ፤ ኤንቲ ጌሳመ ቢታን ደኦና። ኤንታ ግዶፈ ዱማ ቃራተꬅ ደኤይሳት ደእኮ፥ ሄሳታ ታ መህያ ቦላ ሹማ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","ሄሳፈ ጉየ፥ ዮሰፍ ባ አዋ ያይቆባ ገልስድ፥ ካዋ ስን አꬅስ። ያይቆብ ግብፀ ካዋ አንጅዳፐ ጉየ፥ ");
INSERT INTO gofe_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","ካዎይ ያይቆባ፥ “ነዉ አፑን ላይꬄ?” ያግድ ኦይችስ። ");
INSERT INTO gofe_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","ያይቆብ ካዋኮ፥ “ታኒ ዳቡርሳን ደእዳ ላይꬃይ ፄታነ ሀስታማ። ታ ላይꬃይ በን ታ አዋት ዳቡርሳን ደእዳ ላይꬃፈ ጉꬃነ መቶይ ዳርዳ ላይꬅ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","ሄሳፈ ጉየ፥ ያይቆብ ካዋ አንጅድ፥ እያ ስንꬃፈ ካረ ከይስ። ");
INSERT INTO gofe_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","ዮሰፍ ካዎይ ኪትዳይሳዳ ባ አዋነ ባ እሻታ ግብፀ ቢታን ራምሰ ካታማ ማታን ደእያ ኡባፈ አꬍዳ አራዳ ቢታን ኤንታ ዎꬅስ። ");
INSERT INTO gofe_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","ዮሰፍ ባ አዋስ፥ ባ እሻታስነ ባራ ደእያ ኡባስ ኤንታ ናይታ ታይቡዋዳ ካꬅ እሚስ። ");
INSERT INTO gofe_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","ቢታ ኡባን ኮሽ ሱልዳ ግሾ ቢታን ኡባን ካꬅ ባዋ፤ ግብፀይነ ካናነ ቢታይ ቆሄትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","ዮሰፍ ግብፀ ካꬃ ባይዝድ፥ ግብፀንነ ካናነ ቢታታን ደእያ ሚሽያ ኡባ ሺሽድ ግብፀ ካዋ ኬꬃ ገልስስ። ");
INSERT INTO gofe_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","ግብፀ ሚሸይነ ካናነ ሚሸይ ዉርዳ ዎደ ግብፀ አሳ ኡባይ ዮሰፋኮ ይድ “ኑስ ካꬅ እማ። ኑ ሚሸይ ዉርዳ ግሾ ኑኒ ነ ስንꬃን አይስ ኮሻን ሀይቃኔ?” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","ዮሰፍ ኤንታኮ፥ “ህንተ መህያ ኤክ ዪተ። ህንተ ሚሸይ ዉርዳባ ግድኮ፥ ታኒ ካꬃ ህንተ መህያራ ላማና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","ሄሳ ግሾ፥ ኤንቲ ባንታ መህያ ዮሰፋስ ኤህዶሶና። ዮሰፍ ኤንታ ፓራ፥ ዶርሳ፥ ዴሻ፥ ሚዛነ ሀርያ ካꬃራ ላምስ። እ ሄ ላይꬅ ኤንታ መህያ ኡባራ ካꬃ ላምድ፥ ኤንታ ሙዝድ ሻችስ። ");
INSERT INTO gofe_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","ኤንቲ ካልያ ላይꬃን እያኮ ይድ “ኑኒ ኑ ጎዳፐ ቆስያባይ ባዋ፤ ኑ ሚሸይ ኡባይ ዉርስ። ኑ መህያካ ነዉ እም ድግዳ። ኑ ቦላፈነ ኑ ጋድያፐ አትሽን፥ ኑ ጎዳስ እማናባይ ሀራባይ ባዋ። ");
INSERT INTO gofe_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","ኑኒ ነ በእሽን አይስ ኮሻን ሀይቃኔ? ኑ ጋደይካ አይስ ꬋዪ? ኑናካ ኑ ጋድያካ ሻማዳ ኑስ ካꬅ እማ። ኑኒ ካዋስ አይለታና፥ ኑ ጋደይካ እያባ ግዶ። ኑኒ ሀይቆና አታና መላ ኑ ጋደይካ ኦፆና መላ ዘረꬅ ኑስ እማ” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","ዮሰፍ ግብፀ ቢታ ኡባ ካዋስ ሻምስ። ኮሽ ሱልን፥ ግብፀ አሳይ ኡንኤትድ ባንታ ጋድያ ባይዝን ጋደይ ካዉዋባ ግድስ። ");
INSERT INTO gofe_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","ዮሰፍ አሳ ኡባ ግብፀስ ሀ ጋፃፐ ህን ጋፃ ጋካናስ ካዋስ አይለ ኦꬅስ። ");
INSERT INTO gofe_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","ሽን ካዎይ ካህነታስ ካꬅ እምያ ግሾ ዮሰፍ ኤንታ ጋድያ ሻምቤና። ሄሳ ግሾ፥ ባንታ ጋድያ ባይዝቦኮና። ");
INSERT INTO gofe_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","ዮሰፍ አሳኮ፥ “ህዛ ሀች ታኒ ህንተናነ ህንተ ጋድያ ካዋስ ሻምዳ ግሾ፥ ዘረꬅ ኤፍድ ህንተ ጋደን ዘርተ። ");
INSERT INTO gofe_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","ሽን ካꬃ ሺሽያ ዎደ አይፍዳባፐ እቻሹ ኩሽያፐ እስ ኩሽያ ካዋስ እምተ። አትዳ ኦይዱ ኩሸይ ህንተ ጋድያስ ዘረꬅ፥ ህንተዉነ ህንተ ሶ አሳስ ካꬅ ግዶ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","ኤንቲ፥ “ኔኒ ኑና አሻዳሳ። ኑ ጎዳ ስንꬃን ኑኒ ሳበትኮ፥ ኑኒ ካዋስ አይለታና” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","ሄሳ ግሾ፥ ዮሰፍ ግብፀ ቢታን አይፍዳባፐ እቻሹ ኩሽያፐ እሱዋ ካዋስ እመይሳ ህገ ከስስ። ሄ ዎጋይካ ሀች ጋካና ኤቅድ ደኤስ። ካህነታ ጋድያፐ አትሽን፥ ሀር ኡባይ ካዉዋባ ግድስ። ");
INSERT INTO gofe_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","እስራኤለት ግብፀ ቢታን ጌሳመ ግያ በሳን ደእዶሶና። ኤንቲ ያን ዱረትዶሶና፤ የለት ዳርዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","ያይቆብ ግብፀ ቢታን ታማነ ላፑን ላይꬅ ደእስ። ያይቆብ ደእዳ ላይꬃይ ፄታነ ኦይታማነ ላፑና። ");
INSERT INTO gofe_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","እስራኤለስ ሀይቅያ ዎደይ ማታትን፥ ባ ናኣ ዮሰፋ ፄግስድ ሀይሳዳ ያግስ፤ “ታኒ ነ ስንꬃን ሳበትዳባ ግድኮ፥ ነ ኩሽያ ታ ሸምፑዋ ቦላ ዎꬃ። ኔኒ ታዉ ምሸትያባ ግድኮ ታና ግብፀን ሞግከ ጋዳ ታዉ ጫቃ። ");
INSERT INTO gofe_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","ሽን ታኒ ሀይቅያ ዎደ ታና ግብፀፈ ኤፋዳ፥ ታ ማይዛት ሞገትዳሱዋን ሞጋ” ያግስ። ዮሰፍ፥ “ታኒ፥ ነና ነ ግዳይሳዳ ኦꬃና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","ያይቆብ እያኮ፥ “አነ ታዉ ጫቃ” ያግስ። ዮሰፍ እያዉ ጫቅስ። ሄሳፈ ጉየ፥ እስራኤለይ ባ ጉፍያ ቦላ ካትድ ፆሳ ጎይንስ። ");
INSERT INTO gofe_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","ሄሳፈ ጉየ፥ አሳይ፥ “ነ አዋይ ሳከቴስ” ያግድ ዮሰፋስ ኦድዶሶና። እ ባ ናምኡ አደ ናይታ ምናሰነ ኤፍሬማ ኤክድ ባ አዋ በአናዉ ብስ። ");
INSERT INTO gofe_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","ያይቆብ፥ እያ ናአይ ዮሰፍ ይዳይሳ ስእዳ ዎደ፥ እስራኤለይ ባና ምንꬅድ ሂፃን ኡትስ። ");
INSERT INTO gofe_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","ያይቆብ ዮሰፋ፥ “ኡባ ዳንዳእያ ፆሳይ ካናነ ቢታን ሎዛ ካታማን ታዉ ቆንጭድ፥ ታና አንጅስ። ");
INSERT INTO gofe_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","እ ታና፥ ‘ታኒ ነ የለተꬃ ዳርሳና፥ ነና ዳሮ ደረ ኦꬃና። ሀ ቢታ ታኒ ኔፐ ጉየ፥ ነ ሼሻስ መርና ላታ ኦꬃዳ እማና’ ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","“ህዛ፥ ነ ናምኡ አደ ናይት፥ ታኒ ኔኮ ሃ ያናፐ ስን ግብፀን ነዉ የለትዳይሳት ታባ። ኤፍሬመይነ ምናሰይ ታዉ ሮቤላ መላነ ስሞና መላ። ");
INSERT INTO gofe_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","ኤንታፈ ጉየ የለታናይሳት ነባ ግዶ። ኤንቲ ላታና ቢታይ ኤፍሬማ ሱንꬃንነ ምናሰ ሱንꬃን ግዶ። ");
INSERT INTO gofe_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","ታኒ ማሰጰፆመፐ ስምሽን፥ ኤፍራታ ጋካናዉ ጉꬅ አትሽን፥ ራሄላ ካናነ ቢታን ሀይቃሱ። ታኒ እዮ ቤተለመ ጌተትያ ኤፍራታ ኤፍያ ኦግያ ጋፃን ሞጋስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","እስራኤለይ ዮሰፋ አደ ናይታ ናምአታ በእዳ ዎደ፥ “ሀይሳቲ ኦናንቴ?” ያግድ ኦይችስ። ");
INSERT INTO gofe_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","ዮሰፍ ባ አዋኮ፥ “ሀይሳቲ ፆሳይ ታዉ ሀ ቢታን እምዳ ናይታ” ያግስ። ያትን እስራኤለይ፥ “ታኒ ኤንታ አንጃና መላ፥ ኤንታ ታኮ ሃ ሺሻ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","እስራኤለይ ጭምን እያ አይፈይ እፅዳ ግሾ፥ ፄላናዉ ዳንዳኤና። ሄሳ ግሾ፥ ዮሰፍ ባ አደ ናይታ እያኮ ሺሽን፥ ያይቆብ ኤንታ እድምድ ዬርስ። ");
INSERT INTO gofe_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","እስራኤለይ ዮሰፋ፥ “ታኒ ነ አይፍያ በአና ጋዳ ቆፓብከ፥ ሽን ፆሳይ ሄኮ ነ ናይታካ ታና በስስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","ዮሰፍ ባ ናይታ ያይቆባ ጉልባታፐ ደንꬅድ፥ ባ ሶምኡዋ ሳአ ጋꬅድ ዝግስ። ");
INSERT INTO gofe_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","ዮሰፍ ባ ናምኡ አደ ናይታ፥ ኤፍሬማ እስራኤለስ ሀድርሳ ባጋራ፥ ምናሰ እስራኤለስ ኡሻቻ ባጋራ ኤስስ። ");
INSERT INTO gofe_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","እስራኤለይ ባ ኩሽያ ባርባፅድ ኤፍሬም ካሎ ግድኮካ፥ ባ ኡሻቻ ኩሽያ ሁጰን ዎꬅስ። ምናሰይ ባይራ ግድኮካ፥ እስራኤለይ ባ ሀድርሳ ኩሽያ ምናሰ ሁጰን ዎꬅስ። ");
INSERT INTO gofe_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","ሄሳፈ ጉየ፥ ያይቆብ ዮሰፋ ሀይሳዳ ያግድ አንጅስ፤ “ታ አዋት አብራሃመይነ ይሳቅ፥ እያ ስንꬃን ደእዳ ፆሳይ፥ ታ ደኦ ኡባን ሀች ጋካናዉ ታና ሄምዳ ፆሳይ ነና አንጆ። ");
INSERT INTO gofe_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","ኢታባ ኡባፈ ታና አሽዳ፥ እያ ኪታንቾይ፥ ሀ ናይታ ናጎ። ታ ሱንꬃይነ፥ ታ አዋታ አብራሃመ ይሳቃ ሱንꬃይ ኤንታን ፄገቶ። ኤንቲ ሳአ ቦላ ዳሮ” ያግድ አንጅስ። ");
INSERT INTO gofe_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","ዮሰፍ ባ አዋይ ባ ኡሻቻ ኩሽያ ኤፍሬማ ሁጰን ዎꬅዳይሳ በእዳ ዎደ ዶስቤና። ሄሳ ግሾ፥ ኤፍሬማ ሁጵያፐ ደንꬅድ፥ ምናሰ ሁጰን ዎꬃናዉ ባ አዋ ኩሽያ ኦይክስ። ");
INSERT INTO gofe_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","ዮሰፍ፥ “ታ አዋዉ፥ ሄሳ ግደና። ባይራይ ሀይሳ ነ ኡሻቻ ኩሽያ እያ ቦላ ዎꬃ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","ሽን እያ አዋይ እፅድ፥ “ታ ኤራይስ፥ ታ ናአዉ፥ ታ ኤራይስ። ምናሰይካ ግታ ደረ ግዳና፥ ሽን እያ ካሎ እሻይ እያፐ አꬍድ ግታታና። እያ ሼሻይካ ዳሮ ግታ ካዎተꬃ ግዳና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","እ ሄ ጋላስ ኤንታ አንጅሸ፥ “እስራኤለት አንጆ አንጅያ ዎደ፥ ‘ፆሳይ ህንተና ኤፍሬማዳነ ምናሰዳ ኦꬆ’ ያግድ ህንተ ሱንꬃን አንጃና” ያግስ። ያትድ ኤፍሬማ ምናሰፐ ስንꬃይስ። ");
INSERT INTO gofe_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","ሄሳፈ ጉየ፥ እስራኤለይ ዮሰፋ፥ “ታኒ ሀይቃናዉ ማታስ፥ ሽን ፆሳይ ህንተራ ደኤስ። እ ህንተ አዋታ ቢታ ህንተና ጉየ ዛራና። ");
INSERT INTO gofe_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","ታኒ አሞረታፐ ታ ማሻንነ ታ ዶንገን ኤክዳ ቢታ፥ ነ እሻታራ ነ ሻከታዳ ኤክያ ቢታ ቦላ ነዉ ጉጃዳ እማስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","ሄሳፈ ጉየ፥ ያይቆብ ባ አደ ናይታ ፄግድ፥ “ስንꬃፈ ሀናናባ ታኒ ህንተዉ ኦዳና መላ ሀ ሺቅተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“ህንተኖ ያይቆባ ናይቶ፥ እስፈ ሺቅድ ስእተ፤ ህንተ አዋይ እስራኤለይ ኦደይሳ ሀይዝተ። ");
INSERT INTO gofe_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“ሮቤላ፥ ታ ባይራ ናአዉ፥ ኔኒ ታ ዎልቃ፤ ታ ምኖተꬃስ ኮይሩዋ፤ ኔኒ ቦንቾንካ ዎልቃንካ ኡባፈ አꬋሳ። ");
INSERT INTO gofe_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","ኔኒ ሃꬃ መላ፥ ኤቅዳሶን ደአካ፤ ነ እሻታ ቦላ ባይራተꬅ ነዉ በሰና። ኔኒ ነ አዋ ሂፃን ከያዳሳ፤ ነ አዋ አርሳ ቱንሳዳሳ። ");
INSERT INTO gofe_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“ስሞንነ ሌወይ እሻታ፤ ኤንቲ ባንታ ማሻ ማካላተꬃስ ደንꬆሶና። ");
INSERT INTO gofe_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","ኤንቲ ባንታ ሀንቁዋን አደ ዎꬍዶሶና፥ ባንታ አሙዋ ኩንꬃናዉ ቦራታ ጋድያ ቃንፅዶሶና። ያንያ ግሾ፥ ታኒ ኤንታ ዞረታን ገልከ፤ ኤንታ ሺቁዋንካ ኡትከ። ");
INSERT INTO gofe_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","ኤንታ ዎልቃማ ሀንቆይ ኤንታ ዎዛና ኢታተꬃይ ባደትዳባ ግዶ። ታኒ፥ ኤንታ ያይቆባ አሳ ግዶን ላላና። እስራኤለ ቢታን ꬋርጫና። ");
INSERT INTO gofe_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“ይሁዳ፥ ነ እሻት ነና ጋላታና፤ ነ ኩሸይ ነ ሞርከታ ቆ ኦይካና፤ ነ አዋ ናይት ነዉ ሆክድ ዝጋና። ");
INSERT INTO gofe_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","ይሁዳ፥ ኔኒ ዎዳላ ጋሞ፤ ታ ናአዉ፥ ኔኒ ሻንካፈ ዎꬍ ስሚድ፥ ጮጎትድ ዝንእዳ ጋሞ መላ። ነና ቦቻናዉ ዳንዳኤይ ባዋ። ");
INSERT INTO gofe_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","መርናዉ ሃረይስ ያና ጋካናዉ ካዎተꬃ ፃምአይ፥ ይሁዳ ኩሸፐ ከየና፤ ካዎተꬃት እያዉ ኪተታና። ");
INSERT INTO gofe_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","እ ባ ሀርያ ዎይነ ቦላ፥ ባ ሀረ ማራ ዶረትዳ ዎይነ ቦላ ቃቻና፤ እ ባ ማኡዋ ሱꬅ ዳንያ ዎይነ ኡሻን ሜጫና። ");
INSERT INTO gofe_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","እያ አይፈይ ዎይነ ኡሻፈ አꬍድ ዱልካና፤ እያ አቻይ ፃማታፐ አꬍድ ቦፃና። ");
INSERT INTO gofe_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“ዛብሎን አባ ዶናን ዳና፤ እ አባ ዶናን ማርካበት ኤቅያ በሲ ግዳና፤ እያ ዛዋይ ስዶና ጋካና። ");
INSERT INTO gofe_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“ይሳኮር ምኖ ሀረ መላ፥ ጫናታ ግዶን ዝንኤስ። ");
INSERT INTO gofe_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","ሽን እ ባ ሸምፕያ በሳይ ሎኦ ግደይሳነ ባ ቢታይ ኡፋይሰይሳ ግደይሳ በእያ ዎደ፥ ጫና ቶካናዉ ባ ሀሽያ ዝቅ ኦꬅድ፥ አይለተꬃ ኦሶ ኦꬃና። ");
INSERT INTO gofe_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“ዳነይ እስራኤለ ዘረꬃፈ እሱዋ ግድያ ባ አሳ ቦላ ፕርዳና። ");
INSERT INTO gofe_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","ዳነይ ኦገ ጋፃን ደእያ ሾሻ መላ፥ ፓራ ሹቁልያ ዱክድ፥ ፓራ ቶግዳይሳ ጉየ የግያ ጎፐ መላ። ");
INSERT INTO gofe_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“አቤት ጎዳዉ፥ ታኒ ነ አሹዋ ናጋይስ። ");
INSERT INTO gofe_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“ጋደ፥ ቦንቀይሳት ቆሀና፤ ሽን እ ኤንታ ጌዶ ካልድ ኦይካና። ");
INSERT INTO gofe_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“አሴራ ቢታይ ኦርደ፤ እ ካዎታስ ሎኦ ካꬅ እማና። ");
INSERT INTO gofe_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“ንፍታለመይ ቃሸቶና የዳ ደእያ፥ ሎኦ ማራታ የልያ ገንኤ መላ። ");
INSERT INTO gofe_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“ዮሰፍ ሃꬃ ማታን ቶከትድ፥ ደረ ቦላ ዛእዳ፥ አይፈይ ኩምዳ ዎይነ መላ። ");
INSERT INTO gofe_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","ዶንገን ዱከይሳት እያ ቦላ ደንዳና፤ ባንታ ዶንግያን ዱክሸ እያ ጎዳና። ");
INSERT INTO gofe_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","ሽን ያይቆባ ፆሳ ዎልቃን፥ እስራኤለ ሄንꬃንቹዋ ናጉዋን፥ እያ ዶንገይ ምኖ፥ እያ ቀሰይ ፃላ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","ነ አዋ ፆሳይ ነና ማዳና። ኡባ ዳንዳእያ ፆሳይ፥ ቦላ ሳሎ አንጁዋን፥ ጋርሳ ጪሙዋ አንጁዋን፥ መሄንካ የሎንካ ነና አንጃና። ");
INSERT INTO gofe_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","ነ አዋ አንጆይ በንፐ ምንድ ደእያ ዙማታ አንጁዋፈካ፥ መርናዉ ደእያ ደረታፐ በንትያ ኡፋይስያ አንጁዋፈካ አꬌስ። ሀይስ ኡባይ ዮሰፋ ሁጰን፥ ባ እሻታ ግዶን ካፖ ግደይሳ ሊጰን ሸምፖ። ");
INSERT INTO gofe_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“ብንያመይ ቦንቅያ ሱꬉመ፤ ባ ኦልዳባ ዎንታ ሜስ፤ ባ ድእዳባ ኦማርስ ሻኬስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","ሀይሳቲ ታማነ ናምኡ እስራኤለ ሼሻታ። ኤንታ አዋይ ኤንታ ሁጰን ሁጰን ኤንታዉ በሲያ አንጁዋ አንጅሸ ኤንታኮ ግዳባይ ሀይሳ። ");
INSERT INTO gofe_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","ሄሳፈ ጉየ፥ እ ኤንታ ሀይሳዳ ያግድ ኪትስ፤ “ታኒ ታ ማይዛታን ጋሄታና ሀናይስ። ታና ህተ አድያ ኤፍሮና ጋደን ደእያ ጎንጎሉዋን ታ አዋታ ማታን ሞግተ። ");
INSERT INTO gofe_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","ሄስካ፥ ካናነ ቢታን፥ ማምረ ማታን ደእያ፥ ማክፌላን ደእያ ጎንጎሉዋ። ሄ ጎንጎሎይ አብራሃመይ ሞጎስ ህተ አድያ ኤፍሮናፐ እያ ጋድያራ ሻምዳ ዱፉዋ። ");
INSERT INTO gofe_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","አብራሃመይነ እያ ማችያ ሳራ፥ ይሳቅነ እያ ማችያ እርብቃ ያን ሞገትዶሶና። ታኒ ቃስ ልያካ ያን ሞጋስ። ");
INSERT INTO gofe_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","ሄ ጋደይነ እያን ደእያ ጎንጎሎይ ህተታፐ ሻመትዳይሳ። ታና ያን ሞግተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","ያይቆብ፥ ባ ናይታ ኪታ ኦንግዳፐ ጉየ ባ ቶሁዋ ባ ሂፃን ሺሽ ኤክድ፥ ባ ማይዛታን ጋሄትስ። ");
INSERT INTO gofe_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","ዮሰፍ ባ አዋ አሀ ቦላ ኩንድድ፥ ዬርሸ እያዉ ዬክስ። ");
INSERT INTO gofe_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","ሄሳፈ ጉየ፥ ዮሰፍ ꬋለ ሺሽያ ባ ኦሳንቾታ፥ ባ አዋ እስራኤለ አሀ ሽቶ ትይድ መልሳና መላ ኪትስ። ኤንቲ ትይድ መልስዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","ሽቶ ትሻ ዎጋይ ኦይታሙ ጋላስ ኩመꬅ ኤኬስ። ግብፀ አሳት እያዉ ላፑን ታሙ ጋላስ ዬክዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","ዬሆ ጋላሳት አꬍዳ ዎደ፥ ዮሰፍ ግብፀ ካዋ ኦሳንቾታ፥ “ታኒ ህንተ ስንꬃን ሳባ ደምዳባ ግድኮ፥ ታዉ ካዋስ ሀይሳዳ ያግድ ኦድተ። ");
INSERT INTO gofe_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘ታ አዋይ ታና እስ ጫቆ ጫቅስስ። ታኒ ሀይቃናዉ ማታስ። ታኒ ታ ሁጰን ካናነ ቢታን ቦክዳ ጎንጎሎ ዱፉዋን ታና ሞጋ’ ያግስ። ሄሳ ግሾ፥ ‘ሀእ ታኒ ያ ባዳ ታ አዋ ሞጋዳ ስማና መላ ታና የዳርክ’ ያግተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","ያትን ካዎይ፥ “እ ነና ጫቅስዳይሳዳ ባዳ ነ አዋ ሞጋ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","ያትን ዮሰፍ ባ አዋ ሞጋናዉ ብስ። ካዋ ሞርናት ኡባይ፥ ካዋ ኬꬃንነ ግብፀን ደእያ ግታ አሳት ኡባይ ዮሰፋ ካልድ ብዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","ዮሰፋ ሶ አሳ ኡባይ፥ እያ እሻትነ እያ አዋ ሶ አሳት ዮሰፋራ ብዶሶና። ኤንታ ዮጋ ናይት፥ ኤንታ ዶርሳት፥ ኤንታ ዴሻትነ ኤንታ ሚዛ ዉድያ ፃላል ጌሳመን አትስ። ");
INSERT INTO gofe_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","ፓራ ጋረትነ ቶጋት እያራ ብዶሶና። እያ ካልድ ብዳ አሳይ ዳሮ። ");
INSERT INTO gofe_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","ኤንቲ ዮርዳኖሰ ሻፋ ማታን ደእያ አፃደ ጌተትያ ዉዱማ ጋክድ፥ ባንታ ቃላ ꬎቁ ኦꬅድ፥ ዘሌልድ ዬክዶሶና። ያን ዮሰፍ ባ አዋ ዬሁዋን ላፑን ጋላስ ኡትስ። ");
INSERT INTO gofe_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","ሄ ቢታን ደእያ ካናነ አሳት አፃደ ዉዱማን ሄ ዬሁዋ በእዳ ዎደ፥ “ግብፀት አይብ ይባታ ዬሆ ዬኮና?” ያግዶሶና። ሄሳ ግሾ፥ ዮርዳኖሰ ማታን ደእያ ሄ በሳይ አቤል-ምፅራማ (ግብፀታ ዬሆ) ጌተትስ። ");
INSERT INTO gofe_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","ያይቆባ ናይት ኤንታ አዋይ ኤንታ ኪትዳይሳዳ ኦꬅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","ኤንቲ እያ አሀ ካናነ ቢታ ኤፍድ፥ ማምረፐ ኡሻቻ ባጋን ደእያ ማክፌላ ጎንጎሉዋን ሞግዶሶና። ሄስካ፥ አብራሃመይ ህተ አድያ ኤፍሮናፐ ሞጎስ ሻምዳ ጋድያ። ");
INSERT INTO gofe_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","ዮሰፍ ባ አዋ ሞግዳፐ ጉየ፥ ባ እሻታራነ እያ አዋ ሞጋናዉ እያራ ብዳ ሀራ አሳታ ኡባታራ ግብፀ ስምስ። ");
INSERT INTO gofe_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","ባንታ አዋይ ሀይቅዳፐ ጉየ፥ ዮሰፋ እሻት ባንታ ግዶን፥ “ኑኒ እያዉ ኦꬅዳ ኢታባ ኡባስ ዮሰፍ ኑና ባ ኡሎን ሞርክድ ሀሎ ከያናዉ ኮይኮ ኑኒ ዋናኔ?” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","ሄሳ ግሾ፥ ዮሰፋኮ ያግድ ኪታ ኪትዶሶና፤ “ነ አዋይ ሀይቃናፐ ስን ኑኮ፥ ");
INSERT INTO gofe_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘ኔኒ፥ ነ እሻታ ናጋራነ ኤንታ ኢታ ናቁዋ ሀያና አቶ ያጋ ያግስ ግድ ኦድተ’ ያግስ። ሄሳ ግሾ፥ ሀእ ሀያና፥ ኑ ናጋራ፥ ነ አዋ ፆሳ አይለታ ናቁዋ አቶ ያጋ” ያግዶሶና። ዮሰፍ ሄሳ ስእድ ዬክስ። ");
INSERT INTO gofe_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","ሄሳፈ ጉየ፥ እያ እሻት ባንታ ሁጰን እያኮ ይድ፥ እያ ስንꬃን ጉፋንድ፥ “ኑኒ፥ ነ አይለታ” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","ሽን ዮሰፍ ኤንታኮ፥ “ባቦፍተ፥ ታና ህንተዉ ፆሳ ግደትዬ? ");
INSERT INTO gofe_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","ህንተ ታዉ ኢታ ኦꬅደታ፥ ሽን ሀእ ዳሮ አሳይ ሀይቆና አታና መላ ፆሳይ ሀይሳ ሎኦተꬃስ ኦꬅስ። ");
INSERT INTO gofe_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","ሄሳ ግሾ፥ ህዛ ባቦፍተ። ታኒ ህንተናነ ህንተ ናይታ ሙዛና” ያግድ፥ ኤንታ ምንꬅድ ሎኦ ቃላ ሀሳይስ። ");
INSERT INTO gofe_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","ዮሰፍ፥ እያዉ ላይꬅ ፄታነ ታማ ግዳና ጋካናስ ባ አዋ ሶ አሳራ ግብፀን ደእስ። ");
INSERT INTO gofe_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","ኤፍሬማ ናይታነ፥ ኤንታ ናይታ ናይታ በእስ። ቃስ ምናሰ ናኣ ማክራ ናይታ፥ ባ ናይታ ኦꬅስ። ");
INSERT INTO gofe_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","ሄሳፈ ጉየ፥ ዮሰፍ ባ እሻታ፥ “ታኒ ሀይቃናዉ ማታስ፥ ሽን ፆሳይ ህንተና ማዳናዉ ፆሞሳና። እ ህንተና ሀ ቢታፈ ከስድ፥ አብራሃመስ፥ ይሳቃስነ ያይቆባስ እማና ግድ ጫቅዳ ቢታ ኤፋና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","ዮሰፍ እስራኤለ ናይታ፥ “ፆሳይ ህንተና ማዳናዉ ፆሞስያ ዎደ፥ ህንተ ታ መቀꬃ ሀ ቢታፈ ኤክድ ቢተ” ያግድ ጫቅስስ። ");
INSERT INTO gofe_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","ዮሰፍ ፄታነ ታሙ ላይꬅ ደእድ ሀይቅን፥ ሽቱዋን እያ አሀ ትይድ መልስዳፐ ጉየ፥ ግብፀ ቢታን ሳፅነን ዎꬅዶሶና።");
INSERT INTO gofe_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","ባንታ ሶ አሳ ኡባ ኤክድ፥ ያይቆባራ ግብፀ ብዳ እስራኤለ አደ ናይታ ሱንꬃይ ሀይሳፈ ካልድ ፃፈትዳይሳ፤ ");
INSERT INTO gofe_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","ኤንትካ ሮቤላ፥ ስሞና፥ ሌወ፥ ይሁዳ፥ ");
INSERT INTO gofe_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","ይሳኮራ፥ ዛብሎና፥ ብንያመ፥ ");
INSERT INTO gofe_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","ዳነ፥ ንፍታለመ፥ ጋደነ አሴራ። ");
INSERT INTO gofe_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","ያይቆባ ሼሻት ኡባይ ላፑን ታማ። ዮሰፍ ካሰካ ግብፀን ደኤስ። ");
INSERT INTO gofe_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","ዎደፐ ጉየን ዮሰፍ፥ እያ እሻትነ ሄ የለተꬃ ኡባይ ሀይቅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","ሽን እስራኤለ ሼሻይ የለትድ ግብፀ ቢታ ኩማና ጋካናዉ ታይቦን ዳርዶሶናነ ምንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","ሄሳፈ ጉየ፥ ዮሰፋ ኤሮና ሀራ ካዎይ ግብፀ ቢታን ካዎትስ። ");
INSERT INTO gofe_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","ሄ ካዎይ ባ አሳ፥ “ሄኮ፥ ሀ እስራኤለት ኑፐ አꬍድ የለተꬃንነ ዎልቃን ዳርዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","ኑኒ ሂላቶና እፅኮ ኤንቲ ታይቦን ካሰይሳፈ ሃ ዳራና። ቆፖና ኦል ደንድኮ ኤንቲ ኑ ሞርከታራ እስፍድ ኑና ኦልድ፥ ቢታ የግድ ባናዉ ዳንዳኦሶና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","ሄሳ ግሾ ዴፆ ኦሶን ኤንታ ኡንኤꬃና መላ ኤንታ ቦላ ኢታ ካፖታ ዎꬅዶሶና። ኤንቲ ፕቶማነ ራምሰ ጌተትያ ሻሎ ዎꬅያ ካታማታ ካዋስ ኬፅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","ሽን ግብፀት ኤንታ ዳርስ ኡንኤꬅንካ ኤንቲ ሃ ዳርድ የለትዶሶናነ ቢታ ጋክዶሶና። ግብፀት እስራኤለታ እፅዳ ግሾ ያይዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","ኤንታና ኢታ ኦሶ ኦስስዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","ኡርቃ የꬍሶን፥ ስምንቶን ፁበ መꬎን ቃስ ጋደ ኦስሶን ኤንታ ደኡዋ ጫምስዶሶና። ቃይ ባይና ዴፆ ኦሶ ኡባ ኤንታ ኦስስዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","ግብፀ ካዎይ ቃንꬃ እብራወ ማጫሳታ ኡሎ ፕትያ ስፖሮነ ፑሆ ጌተትያ ናምኡ ማጫሳታኮ ሀይሳዳ ያግስ፤ ");
INSERT INTO gofe_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“እብራወ ማጫሳት የልያ ዎደ የለትዳ ናአይ አደ ግድኮ ዎꬍተ፥ ሽን ማጫ ግድኮ ፓፃ አግተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","ሽን ኡሎ ፕተይሳት ፆሰ ባቢድ፥ ግብፀ ካዎይ ኪትዳይሳዳ ኦꬅቦኮና። ኤንቲ አደ ናይታ ፓፃ አግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","ሄሳፈ ጉየ፥ ግብፀ ካዎይ ሄ ኡሎ ፕተይሳታ ፄግድ፥ “ህንተ አይስ ሀይሳ ኦꬅደቲ? አደ ናይታ አይስ ፓፃ አገቲ?” ያግድ ኤንታ ኦይችስ። ");
INSERT INTO gofe_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","ኡሎ ፕተይሳት ዛሪድ፥ “እብራወ ማጫሳት ግብፀ ማጫሳታ መላ ግዶኮና። ኤንቲ ምኖ ግድያ ግሾ ኡሎ ፕተይሳት ጋካናፐ ስንꬃትድ የሎሶና” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","ሄሳ ግሾ ፆሳይ ኡሎ ፕተይሳታስ ኬህስ። እስራኤለ አሳይ ካሰይሳፈ ሃ ዳርሸነ ምንሸ ብዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","ቃስ ኡሎ ፕተይሳት ፆሳስ ያይዳ ግሾ ፆሳይ ኤንታዉ ኤንታ ሶ አስ እሚስ። ");
INSERT INTO gofe_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","ሄሳፈ ጉየ ካዎይ ባ አሳ ኡባኮ፥ “እብራወታፐ የለትያ አደ ኡባ ናይለ ሻፋን የግተ፤ ሽን ማጫ ናእ የለትኮ ፓፃ አግተ” ያግድ ኪትስ። ");
INSERT INTO gofe_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","ሄ ዎደ ሌወ ቆሞ ግድዳ እስ ኡራይ ሌወ ማጫስ እስዉ ኤክስ። ");
INSERT INTO gofe_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","ሄ ማጫስያ አደ ናአ የላሱ። ናአይ ማላ ሎኦ ግደይሳ በአዳ ሄꬑ አጌና ቆሳሱ። ");
INSERT INTO gofe_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","ሽን እያ ሄሳፈ ዳሮ ቆሳናዉ ዳንዳኦናይሳ ኤራዳ፥ ማቃፈ ዳቾ ዳዳዳ፥ ማደ መላባ ትያዳ ናኣ እያን ዎꬃሱ። ያታዳ ናይለ ሻፋ ጋፃን ማይጫ ግዶን ዎꬃሱ። ");
INSERT INTO gofe_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","እያ ምችያ እያ ጋክያባ በአናዉ ሃሆን ኤቃሱ። ");
INSERT INTO gofe_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","ግብፀ ካዉዋ ናእያ ቦላ ሜጨታናዉ ናይለ ሻፋ ዎꬋሱ። እ ማጫ አይለት ሃꬃ ዶናን ይያ ሃ ስመረቶሶና። እያ ዳቾ ማይጫ ግዶን ደማዳ፥ ባ አይልዉ ባዳ ኤሀና መላ ኪታሱ። ");
INSERT INTO gofe_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","ዳቾ ዶያዳ ሄ ጉꬃ ናኣ በአሱ። እ ዬከይሳ በአዳ ቃታዳ፥ “ሀይስ እብራወታ ጉꬃ ናይታፐ እሱዋ” ያጋሱ። ");
INSERT INTO gofe_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","ሄ ዎደ እያ ምችያ ካዉዋ ናኤኮ፥ “ሀ ናኣ ꬋንꬃና መላ እብራወ ማጫስ ነዉ ኤሆ?” ያጋዳ ኦይቻሱ። ");
INSERT INTO gofe_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","እያ፥ “ኤ፥ ኤሀ” ያጋሱ። ናእያ ባዳ ናኣ አይዉ ኤሀሱ። ");
INSERT INTO gofe_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","ካዉዋ ናእያ ማጫስዉ፥ “ሀ ናኣ ኤፋዳ፥ ታዉ ꬋንꬃ፤ ድቻ፤ ታኒ ነዉ ዳሞዘ ቃንፃና” ያጋሱ። ማጫስያ ናኣ ኤፋዳ ꬋንꬃሱ። ");
INSERT INTO gofe_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","ናአይ ድጭን፥ ካዉዋ ናኤኮ ኤሀሱ፤ እ እዉ ናአ ግድስ። “ታኒ ሃꬃፈ እያ ከሳ ኤካስ” ጋዳ፥ እያ ሙሰ ጋዳ ሱንꬃሱ። ");
INSERT INTO gofe_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","ሙሰይ ድጭዳፐ ጉየ እስ ጋላስ ባ አሳ በአናዉ ብድ፥ ኤንቲ ዴፆ ኦሶ ኦꬅሽን ኤንታ በእስ። ግብፀ አስ እሶይ እብራወታፐ እሱዋ ባ ያራ ዋꬍሽን በእስ። ");
INSERT INTO gofe_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","እ ይያ ሃ ፄልን፥ ኦንካ ባይናይሳ በእድ፥ ሄ ግብፀ ኡራ ዎꬍድ ሻፈን ቆስስ። ");
INSERT INTO gofe_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","ዎንተꬃ ጋላስ ከይድ፥ ናምኡ እብራወት ዋትሽን በእስ። ቆሄይሳኮ፥ “ኔኒ ነ ዳቡዋ አይስ ሾጫይ?” ያግድ ኦይችስ። ");
INSERT INTO gofe_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","ሄ ኡራይ፥ “ነና ኑ ቦላ ሃረይሳነ ዳይና ኦꬅዳይ ኦኔ? ኔኒ ዝነ ግብፀ ኡራ ዎꬍዳይሳዳ፥ ታናካ ዎꬋናዉ ኮያይ?” ያግስ። ሙሰይ ሄ ዎደ፥ “ታኒ ኦꬅዳባይ አሳን ኤረትስ” ያግ ቆፕድ ያይስ። ");
INSERT INTO gofe_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","ካዎይ ሄሳ ስእዳ ዎደ፥ ሙሰ ዎꬍሳናዉ ኮይስ። ሽን ሙሰይ በትድ፥ ምድያመ ቢታን ደአናዉ ብስ። እስ ጋላስ እ ሃꬃ ኦላ ዶናን ኡትስ። ");
INSERT INTO gofe_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","ሄ ዎደ ምድያመ ካህነ እሱዋስ ላፑን ማጫ ናይት ደኦሶና። ኤንቲ ባንታ አዋ ዶርሳታ ጎንገን ሃ ዱቅ ኡሻናዉ ይዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","ሄንꬃንቾት ይድ ማጫ ናይታ ጎድዶሶና። ሽን ሙሰይ ኤንታ ማድድ ኤንታ ዶርሳታ ሃ ኡሽስ። ");
INSERT INTO gofe_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","ኤንቲ ባንታ አዋ የቶራኮ ይዳ ዎደ፥ “ሀች ዋን ኤለስ ይደቲ?” ያግድ ኦይችስ። ");
INSERT INTO gofe_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","ኤንቲ ዛሪድ፥ “ግብፀ አስ እሶይ ኑና ሄንꬃንቾታፐ አሽስ። ሃ ዱቅድ ዶርሳታ ኡሽስ” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","እ ባ ማጫ ናይታ፥ “ያትን እ አዉን ደኢ? ህንተ ሄ ኡራ አይስ አግድ ይደቲ? ኑራ ካꬅ ማና መላ አነ እያ ፄግተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","ሙሰይ ሄ አድያራ ያን ደአናዉ ቆፋ ቃችስ። ዮቶር ባ ናእዉ ስፖሮ ሙሰስ ማቾ ኦꬅድ እሚስ። ");
INSERT INTO gofe_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","ስፖራ አደ ናአ የልን፥ ሙሰይ እያ፥ “ታኒ ሀ ቢታን በተ አስ” ግድ ገርሳማ ግድ ሱንꬅስ። ");
INSERT INTO gofe_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","ዳሮ ላይꬃፈ ጉየ ግብፀ ካዎይ ሀይቅስ። ሽን እስራኤለት ባንታ አይለተꬃን ኡንኤትድ ዋስዶሶና። ባንታ አይለተꬃን ኤንቲ ዋስዳ ዋሶይ ፆሳኮ ጋክስ። ");
INSERT INTO gofe_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","ፆሳይ ኤንታ ዋሱዋ ስእድ፥ እ አብራሃመራ፥ ይሳቃራነ ያይቆባራ ጫቅዳ ጫቁዋ ሀሳይስ። ");
INSERT INTO gofe_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","ፆሳይ እስራኤለታ አይለተꬃ ኡንኣ በእድ ኤንታና ቆፕስ። ");
INSERT INTO gofe_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","እስ ዎደ ሙሰይ ምድያመ ቢታ ካህንያ፥ ባ ቦሉዋ ዮቶራ ዶርሳነ ዴሻ ሄሜስ። እ ሄ ዉድያ ላግ ኤክድ መላ ቢታ ጋፃን ፆሳ ዙማ ጌተትድ ፄገትያ ኮሬባ ዙማ ቦላ ኤፍስ። ");
INSERT INTO gofe_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","ሄ በሳን ጎዳ ኪታንቾይ ቱሽያን ኤፅያ ታማ ላጩዋ ግዶን እያዉ በንትስ። ሙሰይ ቱሸይ ታማን ኦይከትንካ ታማይ ቱሽያ ሞናይሳ በእድ፥ ");
INSERT INTO gofe_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","“ታኒ ይያ ባዳ፥ ቱሸይ አይስ ታማን ሜተቶናኮ ሄ ኦራꬃባ ሺቃዳ በአና” ግድ ቆፕስ። ");
INSERT INTO gofe_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","እ በአናዉ ሺቅዳይሳ ጎዳይ በእድ፥ ቱሽያ ግዶፈ፥ “ሙሰ! ሙሰ!” ግድ ፄግስ። ሙሰይ፥ “ሄኮ፥ አበ ጎዳዉ” ግድ ኮይስ። ");
INSERT INTO gofe_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","ፆሳይ እያኮ፥ “ሃ ሺቆፓ። ኔኒ ኤቅዳ ቢታይ ጌሽ ግድያ ግሾ፥ ነ ቶሁዋን ደእያ ጫማ ከሳ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","ጎዳይ እያኮ፥ “ታኒ ነ አዋታ፥ አብራሃመ፥ ይሳቃነ ያይቆባ ፆሳ” ያግስ። ሙሰይ ፆሳ ባአናዉ ያይዳ ግሾ፥ ባ ሶምኡዋ ካምስ። ");
INSERT INTO gofe_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","ጎዳይ ቃስካ ሀይሳዳ ያግስ፤ “ታኒ ግብፀን ደእያ ታ አሳይ አይ መላ ዋያኮ በአስ። ኤንቲ ባንታና ኡንኤꬅድ ሃረይሳታፐ አሻና መላ ታኮ ዋስያ ዋሱዋ ስአስ። ኤንታ ዋያካ ኤራይስ። ");
INSERT INTO gofe_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","ሄሳ ግሾ፥ ታኒ ኤንታ ግብፀ አሳ ኩሸፐ አሻናዉነ ሄ ቢታፈ ኤንታ ከሳዳ፥ ሀእ ካናነት፥ ህተት፥ አሞረት፥ ፓርዘት፥ ህወትነ ያቡሰት ደእያ ቢታ፥ ማꬅነ ኤስ ኩምዳ ሎኦ ቢታ ኤሀናዉ ዎꬋስ። ");
INSERT INTO gofe_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","ታ ደርያ ዋሶይ ሀእ ታና ጋክስ። ግብፀ አሳት ኤንታ ቆህዳ ቆሁዋ ታኒ በአስ። ");
INSERT INTO gofe_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","ሄሳ ግሾ ሀእ ኔኒ ታ አሳ እያ ቢታፈ ከሳና መላ ግብፀ ካዋኮ ታኒ ነና ኪታይስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","ሽን ሙሰይ፥ “ካዋኮ ባናዉነ እስራኤለታ ግብፀፈ ከሳናዉ ታኒ ኦኔ?” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","ፆሳይ ዛሪድ፥ “ታኒ ኔራ ግዳና። ቃስ ታኒ ነና ኪትዳይሳስ ማላይ ሀይሳ፤ ኔኒ ታ አሳ ግብፀፈ ከስያ ዎደ ሀ ዙማ ቦላ ህንተ ታና ጎይናና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","ሙሰይ ፆሳኮ፥ “ግዶሽን፥ ታኒ እስራኤለታኮ ባዳ ኤንታኮ፥ ‘ህንተ አዋታ ፆሳይ ታና ህንተኮ ኪትስ’ ያግኮ፥ ኤንቲ ታና፥ ‘እያ ሱንꬃይ ኦኔ?’ ያግድ ኦይችኮ፥ ታኒ ኤንታዉ ዎይጋዳ ዛሮ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","“ፆሳይ ሙሰኮ፥ ‘ደኤይስነ ዳናይስ፥ ታና’ ኔኒ እስራኤለታኮ፥ ‘ታን ታና ግድዳይስ’ ታና ህንተኮ ክትስ ያጋ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","ፆሳይ ዛሪድ፥ “ኔኒ እስራኤለታ ጎዳይ ህንተ አዋታ፥ አብራሃመ፥ ይሳቃነ ያይቆባ ፆሳይ፥ ታና ህንተኮ ኪትስ። ሀይስ ታ መርና ሱንꬃ፤ ያና የለተꬃ ኡባይ ሀ ሱንꬃን ታና ፄጋና። ");
INSERT INTO gofe_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","“ባዳ እስራኤለ ጭማታ ሺሻዳ፥ ጎዳይ ህንተ አዋታ ፆሳይ፥ አብራሃመ፥ ይሳቃነ ያይቆባ ፆሳይ ነዉ ቆንጭዳይሳ ኦዳ። ግብፀን ኤንቲ ዋየትያ ዋይያ ታኒ ፆሞሳዳ በእዳይሳ ኤንታዉ ኦዳ። ");
INSERT INTO gofe_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","ታኒ ኤንታና ግብፀ ዋያፐ ከሳዳ ማꬅነ ኤስ ኩምዳ፥ ካናነታ፥ ህተታ፥ አሞረታ፥ ፓርዘታ፥ ህወታነ ያቡሰታ ቢታ ኤፋናዉ ቃላ ገላስ። ");
INSERT INTO gofe_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“እስራኤለ ጭማት ነ ግያባ ስአና። ሄሳፈ ጉየ ኔንነ እስራኤለ ጭማት ግብፀ ካዋኮ ብድ፥ ‘ጎዳይ፥ እብራወታ ፆሳይ፥ ኑስ ቆንጭስ። ሀእ ኑኒ ሄꬑ ጋላሳ ኦገ መላ ቢታ ብድ፥ ጎዳስ፥ ኑ ፆሳስ ያርሾ ያርሻና መላ ኑና የዳ’ ያግተ። ");
INSERT INTO gofe_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","ሽን ዎልቃን ግዶና እፅኮ፥ ግብፀ ካዎይ ህንተና የዶናይሳ ታኒ ኤራይስ። ");
INSERT INTO gofe_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","ሄሳ ግሾ ታኒ ታ ዎልቃን ዱማ ዱማ ማላታታ ኦꬃዳ ግብፀታ ሾጫና። ሄሳፈ ጉየ እ ህንተና የዳና። ");
INSERT INTO gofe_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“ቃስ ታኒ ግብፀ አሳ ስንꬃን ቴሞ ህንተዉ እማና። ያንያ ግሾ ህንተ ከይያ ዎደ መላ ኩሸ ከየከታ። ");
INSERT INTO gofe_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","እብራወ ማጫስ ኡባይ ባ ሾሮን ደእያ ግብፀ ማጫሳኮነ ባ ሶን ደእያ ግብፀ ማጫሳኮ ብድ፥ ብራ አሌቆ፥ ዎርቃነ ማኦ እምተ ግድ ኦይቻና። ህንተ ሄሳ ኤክድ ህንተ ናይታ ማይዛና። ሄሳዳ ኦꬅድ ህንተ ግብፀ ሻሎ ኡባ ኤክድ ባና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","ሙሰይ፥ “ኤንቲ ታና አማኖና እፅድ፥ ዎይኮ ታኒ ግያባ ስኦና እፅድ፥ ‘ጎዳይ ነዉ ቆንጭቤና’ ጊኮ ዎይጎ?” ያግድ ኦይችስ። ");
INSERT INTO gofe_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","ጎዳይ ሙሰኮ፥ “ነ ኩሽያን ደኤይስ አይቤ?” ያግድ ኦይችስ። “ፃምአ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","ጎዳይ እያኮ፥ “አነ ሳአን የጋ” ያግስ። ሙሰይ ሄ ፃምኣ ሳአን የግን፥ ሾሽ ግድን፥ ሙሰይ እያፐ ዎፅስ። ");
INSERT INTO gofe_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","ሄሳፈ ጉየ ጎዳይ፥ “ነ ኩሽያ የዳዳ እያ ጎይና ኦይካ” ያግስ። ሙሰይ ባ ኩሽያ የድድ ሾሻ ኦይክ ደንꬅን ሾሻይ እያ ኩሸን ስሚድ፥ ፃምአ ግድስ። ");
INSERT INTO gofe_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","ጎዳይ፥ “ነ አዋታ ፆሳይ፥ አብራሃመ፥ ይሳቃነ ያይቆባ ፆሳይ ነዉ ቆንጭዳይሳ ኤንቲ አማናና መላ ሀይሳ ኦꬃ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","ካልድ ጎዳይ ሙሰኮ፥ “ነ ኩሽያ ነ ሾጰን ናቃ” ያግስ። ሙሰይ ባ ኩሽያ ሾጰን ናቅስ። እ ከስያ ዎደ እያ ኩሸይ ባሮ ሀርገን ኦይከትዳዳ ቦፅስ። ");
INSERT INTO gofe_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","ጎዳይ እያኮ፥ “ነ ኩሽያ ነ ሾጰን ዛራዳ ናቃ” ያግስ። ሙሰይ ባ ኩሽያ ባ ሾጰን ዛር ናቅድ ከስያ ዎደ እያ ኩሸይ ስሚድ ሀንኮ አሳተꬃ መላ ግድስ። ");
INSERT INTO gofe_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","ጎዳይ፥ “ኤንቲ ነና ዎይኮ ኮይሮ ማላታ አማኖና እፅኮ፥ ናምአንꬆ ማላታ አማናና። ");
INSERT INTO gofe_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","ሽን ኤንቲ ሀ ናምኡ ማላታታ አማኖና እፅኮ፥ ዎይኮ ኔኒ ግያባ ስኦና እፅኮ፥ ናይለ ሻፋፐ ሃ ኤካዳ፥ መላ ቢታ ቦላ ጉሳ። ሄ ሃꬃይ ቢታ ቦላ ሱꬃን ላመታና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","ሙሰይ ጎዳኮ፥ “አቤት ጎዳዉ፥ ካሰካ ዎይኮ ሀእ ነ ታና ኦድሶ ኦይክዳይሳፈ ዶምን ኦድድ አማንꬆይ ታዉ ሀነና። ታ ጌሻዳ ኦደታናዉ ዳንዳእከ፤ ታ እንፃርሳይ ሉፋ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","ጎዳይ እያኮ፥ “አሳስ ዶና እምዳይ ኦኔ? ሙመ ዎይኮ ቱለ ኦይ ኦኔ? ፄልሰይነ ቆቅሰይ ኦኔ? ታና ጎዳ ግድክናዬ? ");
INSERT INTO gofe_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","ሀእ ኔኒ ባ፤ ኔኒ ኦደታና መላ ታ ነና ማዳና። ነ ጋናባ ታ ነዉ እማና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","ሽን ሙሰይ፥ “ጎዳዉ፥ ሀያና፥ ሀራ አስ ኪታ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","ሄሳፈ ጉየ ጎዳይ ሙሰ ቦላ ዳሮ ሀንቀትድ እያኮ፥ “ሌወ ግድዳ ነ እሻ አሮን ባዌ? እ ኦዳ ሎይꬅድ ኤረይሳ ታ ኤራይስ። ሀእ እ ኔራ ጋሄታናዉ ይሸ ኦገ ቦላ ደኤስ፤ እ ነና በእያ ዎደ ዎዛናፐ ኡፋይታና። ");
INSERT INTO gofe_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","ኔኒ፥ ‘ያጋ’፥ ጋዳ እያዉ ኦዳና። ታኒ ህንተ ናምአይካ ዎይግ ኦዳነኮነ ዋትድ ኦꬃነኮ ህንተና ታማርሳና። ");
INSERT INTO gofe_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","እ ነ ዶና ግድድ አሳስ ነ ግሾ ኦዳና። ኔኒ ፆሳ በሳን ግዳዳ እ ጋናባ እያዉ ኦዳና። ");
INSERT INTO gofe_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","ሀ ፃምአ ኤካ ባዳ እያራ ማላታ ኦꬃዳ በሳ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","ሄሳፈ ጉየ ሙሰይ ባ ቦሉዋ ዮታራኮ ስም ብድ፥ “ሀኖ ጋካናዉ አሳይ ፓፃ ደእያኮ በአናዉ፥ ታኒ ጉየ ግብፀ ታ አሳኮ ቦ?” ያግስ። ዮቶር ሙሰኮ፥ “ኤ ባ፤ ሳሮ ጋካ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","ሙሰይ ምድያመ ቢታን ደእሽን ጎዳይ እያኮ፥ “ነና ዎꬋናዉ ኮይዳ አሳት ኡባይ ሀይቅዳ ግሾ ጉየ ግብፀ ስማዳ ባ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","ሙሰይ ባ ማችዉነ ባ አደ ናይታ ሀረ ቶግስድ ጉየ ግብፀ ስምስ። ሙሰይ ፆሳ ፃምአ ባ ኩሸን ኦይክድ ብስ። ");
INSERT INTO gofe_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","ጎዳይ ሙሰ፥ “ኔኒ ግብፀ ስማዳ ብያ ዎደ፥ ታኒ ነዉ እምዳ ዎልቃን ግብፀ ካዉዋ ስንꬃን ማላታታ ኦꬃናይሳ ባሎፓ። ሽን ሄሳንካ እ አሳ የዶና መላ ታኒ እያ ዎዛና ሙምሳና። ");
INSERT INTO gofe_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","ሄ ዎደ ታኒ ጎዳይ ግያባ ካዋስ ሀሳዳ ያጋዳ ኦዳ። ‘እስራኤል ታ ባይራ ናአ። ");
INSERT INTO gofe_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","እ ታዉ ጎይናና መላ እያ የዳ ጋዳ ታኒ ነዉ ኦዳስ። ሽን ኔኒ የዶና እፃዳሳ። ሄሳ ግሾ፥ ታኒ ነ ባይራ አደ ናኣ ዎꬋና’ ያጌስ ጋዳ ኦዳ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","ኦገን ሸምፖ በሳን ጎዳይ ሙሰራ ጋሄትድ እያ ዎꬋናዉ ኮይስ። ");
INSERT INTO gofe_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","እያ ማችያ ስፖራ ቃራ ሹቹ ኤካዳ፥ ባ ናኣ ቃፃራሱ። ቃፃራ ሾሁዋራ ሙሰ ቶሁዋ ቦቻሱ። እያ ሙሰኮ፥ “ኔኒ ታዉ ቱማ ሱꬃ መዳ” ያጋሱ። ");
INSERT INTO gofe_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","ሄሳ ግሾ፥ ጎዳይ እያ ዎꬎና አግስ። ሄ ዎደ እያ ሙሰኮ፥ “ሀ ቃፃሩዋ ጋሶን ኔኒ አታዳሳ” ያጋሱ። ");
INSERT INTO gofe_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","ሄ ዎደ ጎዳይ አሮናኮ፥ “ሙሰራ ጋሄታናዉ መላ ቢታ ባ” ያግስ። እ ብድ፥ ፆሳ ዙማ ቦላ ሙሰራ ጋሄትድ እያ ዬርስ። ");
INSERT INTO gofe_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","ሙሰይ ግብፀ ብድ ጋናባነ ኦꬃና ማላታታ ኡባ ጎዳይ እያ ኪትዳይሳ አሮናስ ኦድስ። ");
INSERT INTO gofe_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","ሙሰራነ አሮናራ ግብፀ ብድ፥ እስራኤለ ጭማታ ኡባ ሺሽዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","አሮን ጎዳይ ሙሰስ ኦድዳ ቃላ ኡባ ኤንታዉ ኦድስ። ቃስ ሙሰይ ማላታታ ሄ አሳ ስንꬃን ኦꬅስ። ");
INSERT INTO gofe_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","ኤንትካ አማንዶሶና። ጎዳይ ኤንታዉ ቆፕዳይሳነ ኤንታ ዋይያ በእዳይሳ ስእዳ ዎደ ጉፋንድ ጎይንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","ሄሳፈ ጉየ ሙሰይነ አሮን ግብፀ ካዋኮ ብድ፥ “ጎዳይ፥ እስራኤለ ፆሳይ፥ ‘ታ አሳይ ታና ቦንቻናዉ መላ ቢታን፥ ባኣለ ኦꬃና መላ ኤንታ የዳ’ ያጌስ” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","ካዎይ፥ “ታኒ እያዉ ኪተታዳ እስራኤለ የዳናዉ እ፥ ጎዳይ ኦኔ? ታኒ ጎዳ ኤርከ፤ እስራኤላካ የድከ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","ኤንቲ ዛሪድ፥ “እብራወታ ፆሳይ ኑስ ቆንጭስ። ሀእ ኑኒ ጎዳስ፥ ኑ ፆሳስ፥ ያርሾ ያርሻናዉ ሄꬑ ጋላሳ ኦገ መላ ቢታ ባና መላ ኑና የዳርክ። ሄሳ ኑ ኦꬆና እፅኮ እ ኑና ሀርገን ዎይኮ ኦላን ꬋይሳና” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","ሽን ግብፀ ካዎይ፥ “ሙሰ፥ አሮና፥ አሳ አይስ ኦሶ ድገቲ? ጉየ ብድ ህንተ ኦሱዋ ኦꬅተ። ");
INSERT INTO gofe_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","ሄኮ፥ ሀ ቢታን ህንተ ዳርደታ፤ ቃስ ህንተ አሳ ኦሶ ድገታ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","ካዎይ ሄ ጋላስ ግብፀ ካፖታነ እስራኤለታ ኦስሰይሳታ ሀይሳዳ ያግድ ኪትስ፤ ");
INSERT INTO gofe_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“ካሰይሳዳ ፁበ ኦꬃናው አሳስ ኡቱላ እሞፍተ። ኤንቲ ኡቱላ ባንታዉ ኮይድ ሺሾ። ");
INSERT INTO gofe_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","ሽን ካሰይሳፈ ታይቡዋ ጉꬆና ኤንቲ ፁበ መꬍድ ሺሻና መላ ኪትተ፤ እስኖካ ፓጭሶፕተ። ኤንቲ፥ ‘ኑኒ ኑ ፆሳስ ያርሾ ያርሻና መላ ኑና የዳ’ ያግድ ታና ኦይቸይ ኤንታዉ ኦሶይ ጉፅዳ ግሾሳ። ");
INSERT INTO gofe_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","ኤንቲ ኦሶን ጉንዳና መላነ ዎርዶ ኦዳ ስኦናዉ ኤንታዉ ዎደይ ዶና መላ ኦሶ ዴፅስተ” ያግድ ኪትስ። ");
INSERT INTO gofe_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","ግብፀ ካፖትነ እስራኤለታ ኦስሰይሳት ከይድ፥ አሳኮ፥ “ካዎይ፥ ‘ታኒ ህንተዉ ኡቱላ እምከ። ");
INSERT INTO gofe_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","ህንተ ብድ አዉፐካ ኮይድ ደምተ። ሽን ህንተ ኦꬅያ ፁበ ታይቡዋፐ እሶይካ ፓጨና’ ያግስ” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","ሄሳ ግሾ አሳይ ኡቱላ ኮያናዉ ግብፀ ቢታ ኡባን ላለትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","ግብፀ ካፖት ኤንታዉ ኡቱል እመትን ኤንቲ ኦꬅያ ፁበ ታይቡዋ ኬና ኦꬅድ ሺሻና መላ ኤንታ ኡንኤꬅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","ግብፀ ካፖት ባንታፈ ጋርሳራ ደእያ እስራኤለ ካፖታ፥ “ህንተ ካሰ ኦꬅያ ፁበ ኬና አይስ ኦꬅ ሺሽበከቲ?” ያግድ ዋꬍዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","ሄሳፈ ጉየ እስራኤለ ካፖት ካዋኮ ብድ፥ “አቤት ጎዳዉ፥ ኔኒ ነ አይለታ ሀይሳዳ አይስ ኦꬃይ? ያግድ ማጋንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","ነ አይለታስ ኡቱል እመተና፥ ሽን ፁበ ኦꬃና መላ ኪተትዳ። ሄሳ ቦላ ኑና ዋꬎሶና፤ ሽን ባላይ ነ አሳ ቦላና” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","ሽን ካዎይ፥ “ህንተ ኦሶ ዶሶና አዛላታ፤ ህንተ ዎራ ዎꬍዳ አዛላታ። ህንተ፥ ‘ኑኒ ጎዳስ ያርሻናዉ ባና፤ ኑና የዳ’ ያግድ ዛር ዛር ታና ኦይቸይ ሄሳ ግሾሳ። ");
INSERT INTO gofe_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","ሀእ ጉየ ብድ ኦꬅተ። ህንተዉ አይባ ኡቱልካ እመተና፥ ሽን ህንተ ካሰይሳ ኬና ፁበ ኦꬃናዉ በሴስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","እስራኤለ ካፖት፥ ኤንቲ ካሰይሳ ኬና ፁበ ኦꬃና መላ ኪተትዳ ዎደ ኤንቲ መቶን ገልዳይሳ ኤርዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","ኤንቲ ካዉዋ ማታፐ ከይድ፥ ባንታና ካረን ናግያ ሙሰኮነ አሮናኮ ብዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","ኤንቲ ሙሰኮነ አሮናኮ፥ “ህንተ ኑና ካዎይነ እያ ሞርናት እፃና መላነ ዎꬋና መላ ህንተ ኦꬅዳይሳ ፆሳይ ፄሎ፤ እ ፕርዶ” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","ሙሰይ ጎዳኮ ስሚድ፥ “ጎዳዉ፥ ኔኒ ሀ አሳ ቦላ መቶ አይስ ኤሀዲ? ኔኒ ታና ኪትዳይ ሄሳሴ? ");
INSERT INTO gofe_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","ታኒ ነ ሱንꬃን ካዋስ ኦዳናዉ ብዳ ዎደፐ ዶምን እ ሀ አሳ ቦላ መቶ ሀ ዳርስስ። ቃስ ነካ ነ አሳ አሻባካ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","ሄሳፈ ጉየ ጎዳይ ሙሰኮ፥ “ታኒ ግብፀ ካዉዋ ቦላ ኦꬃናባ ሀእ ኔኒ በአና። እ ታ ደርያ የዳና መላ ታኒ ታ ዎልቃ እያ በሳና። እ ኤንታ ባ ቢታፈ ጎድድ ከሳና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","ፆሳይ ሙሰ፥ “ታኒ ጎዳ። ");
INSERT INTO gofe_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","ታኒ አብራሃመስ፥ ይሳቃስነ ያይቆባስ ኡባ ዳንዳእያ ፆሳ ግዳዳ ቆንጫስ። ሽን ታኒ፥ ‘ጎዳ’ ጌተትያ ታ ሱንꬃን ታናተꬃ ኤንታ ኤርሳብከ። ");
INSERT INTO gofe_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","ቃስ ታኒ ኤንቲ በተተꬃን ደእዳ ካናነ ቢታ እማና ጋዳ ኤንታራ ጫቃስ። ");
INSERT INTO gofe_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","ቃስካ ግብፀ አሳት አይለይያ እስራኤለታ ዋሱዋ ታኒ ስአስ፤ ታ ጫቁዋካ ቆፓስ። ");
INSERT INTO gofe_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","“ሄሳ ግሾ ኔኒ እስራኤለታኮ፥ ‘ታኒ ጎዳ። ታኒ ህንተና ግብፀ አይለተꬃፈ አሻዳ ከሳና። ታኒ ኤንታ ታ ምኖ አፃን ኢታ ፕርዳ ፕርዳዳ ህንተና ዎዛና። ");
INSERT INTO gofe_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","ታኒ ህንተና ታ ደረ ኦꬃና፤ ታኒ ህንተ ፆሳ ግዳና። ግብፀ አይለተꬃፈ ታኒ ህንተና ከስዳ ዎደ፥ ታኒ ጎዳ ህንተ ፆሳ ግደይሳ ህንተ ኤራና። ");
INSERT INTO gofe_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","ታኒ አብራሃመስ፥ ይሳቃስነ ያይቆባስ እማና ጋዳ ጫቅዳ ቢታ ህንተና ኤሀና። ሄ ቢታ ታኒ ህንተዉ ላታ ቢታ ኦꬃዳ እማና። ታኒ ጎዳ’ ያጋ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","ሙሰይ ሄሳ እስራኤለታስ ኦድስ፥ ሽን ኤንቲ አይለተꬃ ኡንአፈ ደንዶይሳን ኡፋይስ ቃንፅዳ ግሾ እ ግያባ ስእቦኮና። ");
INSERT INTO gofe_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","ሄሳፈ ጉየ ጎዳይ ሙሰ፥ ");
INSERT INTO gofe_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“ባዳ ግብፀ ካዋስ፥ ‘እስራኤለታ ነ ቢታፈ የዳ’ ያጋዳ ኦዳ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","ሽን ሙሰይ፥ “ታ እንፃርሳይ ሉፋ። እስራኤለት ታና ስእቦኮና፥ ሽን ግብፀ ካዎይ ታና ዋንድ ስአኔ?” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","ጎዳይ ሙሰነ አሮና፥ “ብድ፥ እስራኤላ አሳ ግብፀፈ ከሳና መላ፥ ታኒ ህንተና ኪትዳይሳ እስራኤለታስነ ግብፀ ካዋስ ኦድተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","ሀይሳፈ ካልድ ፃፈትዳይሳት ኤንታ ማይዛታ፤ ያይቆባ ባይራ ናኣ ሮቤላ አደ ናይት፥ ሄኖከ፥ ፋሉ፥ ኤስሮመነ ካርማ። ሀይሳቲ ሮቤላ ሶ አሳስ ማይዛታ። ");
INSERT INTO gofe_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","ስሞና አደ ናይት፥ ያሙኤላ፥ ያምና፥ ኦሀዳ፥ ያክና፥ ዞሃራነ ካናነ ቢታ ማጫሴፐ የለትዳ ሳኡላ። ሀይሳቲ ስሞና ሶ አሳስ ማይዛታ። ");
INSERT INTO gofe_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","ሌወ አደ ናይት ገድሶና፥ ቃሃታነ ማራራ። ሌወይ ፄታነ ሀስታማነ ላፑን ላይꬅ ደእስ። ");
INSERT INTO gofe_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","ገድሶና አደ ናይት ልብናነ ሳመአ ጌተቶሶና። ሀይሳቲ ባንታ ሶ አሳስ ማይዛታ። ");
INSERT INTO gofe_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","ቃሃታ አደ ናይት አምራማ፥ እዛራ፥ ከብሮናነ ኡዝኤላ። ቃሃት ፄታነ ሀስታማነ ሄꬑ ላይꬅ ደእስ። ");
INSERT INTO gofe_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","ማራራ አደ ናይት ማህላነ ሙሰ። ባንታ የለተꬃ ማራን ሀይሳፈ ቆሞን ፃፈትዳይሳት ሌወ ሼሻታ። ");
INSERT INTO gofe_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","አምራም ባ አዋ ምችዉ ዮከቤዶ ማችስ። እያ አሮናነ ሙሰ እያዉ የላሱ። አምራም ፄታነ ሀስታማነ ላፑን ላይꬅ ደእስ። ");
INSERT INTO gofe_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","እዛራዳ ናይት፥ ቆረ፥ ነፈጋነ ዝክራ። ");
INSERT INTO gofe_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","ኡዝኤላ አደ ናይት፥ ምሳኤላ፥ ኤልዛፋናነ ስትራ። ");
INSERT INTO gofe_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","አሮን አምናዳበ ናእዉ፥ ናአሶና ምችዉ ኤልሰቦ ማችስ። እያ እያዉ ናዳበ፥ አብዮዳ፥ አላዛራነ እታማራ የላሱ። ");
INSERT INTO gofe_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","ቆረ አደ ናይት፥ አስራ፥ ኤልቃናነ አብያሳፋ። ");
INSERT INTO gofe_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","አሮና ናአይ አላዛር ፑትኤላ ናይታፐ እስንዉ ማችስ። እያ እያዉ ፕንሃሳ የላሱ። ሀይሳቲ ሌወ ሼሻታነ ኤንታ ማይዛታ። ");
INSERT INTO gofe_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","ጎዳይ፥ ሙሰነ አሮና እስራኤለ አሳ ያራን ያራን ኤንታ ሶ አሳራ ግብፀፈ ካለꬅድ ከሳና መላ ኪትስ። ");
INSERT INTO gofe_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","እስራኤለታ ግብፀፈ ከስ የዳና መላ ግብፀ ካዋስ ኦድዳይ ኤንታ። ");
INSERT INTO gofe_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","ጎዳይ ግብፀን ሙሰስ ኦድዳ ዎደ፥ ");
INSERT INTO gofe_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","“ታኒ ጎዳ፤ ታኒ ነዉ ኦድያባ ኡባ ግብፀ ካዋስ ኦዳ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","ሽን ሙሰይ፥ “ታ ዶናይ ሉፋ ግደይሳ ነ ኤራሳ፥ ያትን ካዎይ ታኒ ኦድያባ ዋን ስአኔ?” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","ጎዳይ ሙሰኮ፥ “ሄኮ ታኒ ነና ግብፀ ካዋስ ፆሳ መላ ኦꬃስ። ነ እሻ አሮን ነ ናበ ግድድ እያዉ ኦዳና። ");
INSERT INTO gofe_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","ታኒ ነና ኪትዳ ኪታ ኡባ አሮናስ ኦዳ። እ፥ እስራኤለታ ባ ቢታፈ ከስ የዳና መላ ካዋስ ኦዳና። ");
INSERT INTO gofe_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","ሽን ታኒ ካዉዋ ዎዛና ሙምሳና። ታኒ ግብፀ ቢታን ማላታታነ ማላልስያባታ ኦꬅኮካ፥ ");
INSERT INTO gofe_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","እ ህንተ ኦድያባ ስኤና። ሄ ዎደ ታኒ ግብፀታ ፕርዳና፤ ታ ደርያ እስራኤለ ግብፀፈ ከሳና። ");
INSERT INTO gofe_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","ሄስ ሀንያ ዎደ ታኒ ጎዳ ግድዳይሳ ግብፀት ኤራና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","ሙሰይነ አሮን ጎዳይ ኪትዳይሳዳ ኦꬅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","ኤንቲ ካዋስ ኦድያ ዎደ፥ ሙሰስ ሆስፑን ታሙ ላይꬅ፤ አሮናስ ቃስ ሆስፑን ታማነ ሄꬑ ላይꬅ። ");
INSERT INTO gofe_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","ጎዳይ ሙሰነ አሮና፥ ");
INSERT INTO gofe_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“ካዎይ ህንተና፥ ማላታ ኦꬅድ ታና በስተ ጊኮ፥ አሮን ባ ፃምአ ኤክድ ካዉዋ ስንꬃን የጋና መላ እያዉ ኦዳ፤ ሄ ፃምአይ ሾሽ ግዳና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","ሙሰይነ አሮን ካዋኮ ብድ ጎዳይ ኤንታ ኪትዳይሳዳ ኦꬅዶሶና። አሮን ባ ፃምኣ ካዉዋ ስንꬃንነ እያ ሞርናታ ስንꬃን የግን ፃምአይ ሾሹ ግድስ። ");
INSERT INTO gofe_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","ሄሳፈ ጉየ ካዎይ ማሮታነ ብታንቾታ ፄግስስ። ኤንትካ ባንታ ብታን ሄሳዳ ኦꬅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","ኤንቲ ኡባይ ባንታ ፃምኣ ሳአን የግዳ ዎደ ፃምአት ሾሽ ግድዶሶና። ሽን አሮና ፃምአይ ኤንታ ፃምአታ ምትስ ");
INSERT INTO gofe_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","ግዶሽን ጎዳይ ግዳይሳ መላ ካዋ ዎዛናይ ሙምስ። እ ኤንቲ ገይሳ ስኦና እፅስ። ");
INSERT INTO gofe_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","ጎዳይ ሙሰ፥ “ካዋ ዎዛናይ ሙምስ፤ እ አሳ የዶና እፅስ። ");
INSERT INTO gofe_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","ዎንቶ ዎንታ ጉራ ሾሽ ላመትዳ ፃምኣ ኤካዳ፥ ናይለ ሻፋ ማታን ኤቃዳ፥ ካዉዋራ ጋሄታናዉ ናጋ። ");
INSERT INTO gofe_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","እያኮ፥ ‘ጎዳይ፥ እብራወታ ፆሳይ ታ አሳይ መላ ቢታን ታዉ ጎይናና መላ የዳ’ ያግድ ታና ኔኮ ኪትስ። ሽን ኔኒ ሀኖ ጋካናዉ እፃዳሳ። ");
INSERT INTO gofe_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","ጎዳይ፥ እ፥ ጎዳ ግደይሳ እ ኦꬅያባን ኔኒ ኤራና። ታኒ ናይለ ሻፋ ሃꬃ ታ ኩሸን ደእያ ፃምአን ሾጭኮ ሃꬃይ ሱꬅ ላመታና። ");
INSERT INTO gofe_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","ናይለ ሻፋን ደእያ ሞሎይ ሀይቃና፤ ሻፋይካ ፅንቃና። ግብፀት ሄ ሻፋ ሃꬃ ኡያናዉ ዳንዳኦኮና” ያጋዳ ኦዳ። ");
INSERT INTO gofe_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","ጎዳይ ሙሰኮ፥ “አሮን ግብፀን ደእያ ሃꬃታ ቦላ፥ ሻፋታ ቦላ፥ ዛራ ሃꬃታ ቦላ፥ ተቀ ሃꬃ ቦላነ ዱቀትዳ ሃꬅ ኡባ ቦላ ባ ፃምኣ ደንꬃና መላ ኦዳ። ሄ ዎደ ሃꬃ ኡባይ ሱꬅ ላመታና። ሀር አቶሽን ግብፀ ቢታን ምꬃፈነ ሹቻፈ ኦሰትዳ ሃ ትክያ ሚሸታን ደእያ ሃꬃይ ኡባይ ሱꬅ ላመታና ያጋ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","ሙሰይነ አሮን ጎዳይ ኪትዳይሳዳ ኦꬅዶሶና። ካዉዋ ስንꬃንነ እያ ሞርናታ ስንꬃን ባ ፃምኣ ደንꬅድ፥ ናይለ ሻፋ ሃꬃ ሾጭስ። ሃꬃ ኡባይ ሱꬅ ላመትስ። ");
INSERT INTO gofe_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","ሄ ሻፋ ሃꬃን ደእያ ሞሎት ሀይቅዶሶና። ሻፋ ሃꬃይ ኢታ ፅንቅዳ ግሾ፥ ግብፀ አሳይ ኡያናዉ ዳንዳእቦኮና። ግብፀ ቢታ ኡባን ሱꬅ ኩምስ። ");
INSERT INTO gofe_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","ሽን ግብፀ ብታንቾት ባንታ ብታን ሄሳዳ ኦꬅዶሶና። ጎዳይ ግዳይሳዳ ካዉዋ ዎዛናይ ሙምን፥ ሙሰይነ አሮን ኦድዳይሳ ስኦና እፅስ። ");
INSERT INTO gofe_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","ካዎይ ሄ ሀንዳባ አይብንካ ታይቦና የግ አግድ ባ ጋꬎ ስሚድ ብስ። ");
INSERT INTO gofe_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","ግብፀ አሳይ ናይለ ሻፋ ሃꬃ ኡያናዉ ዳንዳእቦና ግሾ፥ ኡይያ ሃꬅ ደማናዉ ሻፋ ጋፃን ኦላ ቦክዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","ጎዳይ ሃꬃ ሾጭ ስምን ላፑን ጋላስ ግድስ። ");
INSERT INTO gofe_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","ሄሳፈ ጉየ ጎዳይ ሙሰኮ፥ “ግብፀ ካዋኮ ባዳ፥ ‘ጎዳይ፥ ታዉ ጎይናና መላ ታ አሳ የዳ። ");
INSERT INTO gofe_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","ኔኒ ኤንታ የዶና እፅኮ፥ ነ ቢታ ኡባን ሾ ጋዶ የዳና። ");
INSERT INTO gofe_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","ናይለ ሻፋን ሾይ ኩማና። ኤንቲ ያፐ ከይድ ነ ካዎተꬃ፥ ነ ዝንእያ ክፍልያ፥ ነ ሂፃ፥ ነ ሞርናታ ኬꬃነ ነ ደርያ ኬꬃ ኡባን ገላና። ሄሳዳካ ነ ጮጨንነ ሙኑቃ ሚሸ ኡባን ገላና። ");
INSERT INTO gofe_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","ሾት ነ ቦላ፥ ነ አሳ ቦላነ ነ ሹማታ ኡባ ቦላ ጉፓና ያጌስ’ ያጋዳ ኦዳ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","ጎዳይ ሙሰኮ፥ “አሮን ግብፀን ደእያ ሃꬃታ ቦላ፥ ዛራ ሃꬃታ ቦላነ ተቀ ሃꬃ ኡባ ቦላ ባ ፃምኣ ደንꬃና መላ ኦዳ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","አሮን ግብፀ ሃꬃታ ቦላ ባ ፃምኣ ደንꬅዳ ዎደ ሾት ከይድ፥ ግብፀ ቢታ ማእዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","ሽን ማሮትካ ባንታ ብታን ሄሳዳ ኦꬅድ ግብፀ ቢታን ሾ ከስዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","ካዎይ ሙሰነ አሮና ፄግስድ፥ “ሀ ሾታ ታፐነ ታ አሳፐ ድጋና መላ ጎዳ ህንተ ዎስኮ ታ ህንተ አሳ ጎዳስ ያርሾ ያርሻና መላ የዳና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","ሙሰይ ካዋኮ፥ “ሾት ኔፐ፥ ነ ሞርናታፐነ ነ አሳፐ ክቻና መላ ታ ዎሳናዉ ቃፃሮ እማ። ሄሳፈ ጉየ ሻፋ ሾት ኔፐነ ነ ኬꬃፈ ክችድ ናይለ ፃላላን ደአና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","ካዎይ ዛሪድ፥ “ዎንቶ ግዶ” ያግስ። ሙሰይ፥ “ኑ ጎዳ ፆሳ መል ሀር ኦንካ ባይናይሳ ኔኒ ኤራና መላ ነ ግዳይሳዳ ኦꬃና። ");
INSERT INTO gofe_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","ሾት ኔፐ፥ ነ ኬꬃፈነ፥ ነ ሞርናታፐ ክችድ ናይለ ሻፋ ፃላላን አታና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","ሙሰይነ አሮን ካዉዋ ማታፐ ከይድ፥ ካዉዋ ቦላ ጎዳይ ኤህዳ ሾታ ድጋና መላ ሙሰይ ጎዳ ዎስስ። ");
INSERT INTO gofe_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","ጎዳይ ሙሰይ ኦይችዳይሳዳ ኦꬅን ሶን፥ ካረንነ ጌሻን ደእያ ሾት ሀይቅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","ግብፀ አሳይ ሀይቅዳ ሾታ ሺሽድ ዶርዶሶና፤ ቢታ ኡባይ ፅንቅስ። ");
INSERT INTO gofe_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","ሽን ሾት ሀይቅዳይሳ ካዎይ በእዳ ዎደ እያ ዎዛናይ ዛር ሙምስ። ጎዳይ ግዳይሳ መላ እ ሙሰነ አሮና ስኦና እፅስ። ");
INSERT INTO gofe_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","ሄሳፈ ጉየ፥ ጎዳይ ሙሰኮ “አሮን ባ ፃምአ ደንꬅድ ቢታ ባና ሾጫና መላ ኦዳ። ግብፀ ቢታ ኡባን ደእያ ባናይ ቦፀ ግዳና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","ኤንቲ ኪተትዳይሳዳ ኦꬅዶሶና። አሮን ፃምአራ ቢታ ባና ሾጭስ። ግብፀን ደእያ ባና ኡባይ ቦፀ ላመትድ መህያነ አሳ ማእስ። ");
INSERT INTO gofe_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","ማሮትካ ባንታ ብታን ሄሳዳ ኦꬃናዉ ፓጭዶሶና፥ ሽን ፆነትዶሶና። ቦፀይ አሳ ቦላነ መህያ ቦላ ላለትስ። ");
INSERT INTO gofe_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","ማሮት ካዋኮ፥ “ሀይስ ፆሳ ኦሶ” ያግዶሶና። ሽን ካዋ ዎዛናይ ሙምስ። ጎዳይ ግዳይሳ መላ እ ኤንታና ስኦና እፅስ። ");
INSERT INTO gofe_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","ጎዳይ ሙሰ፥ “ጉራ ደንዳዳ፥ ካዎይ ሻፋ ብሽን እያራ ጋሄታዳ፥ ‘ጎዳይ፥ ታና ጎይናና መላ ታ አሳ የዳ። ");
INSERT INTO gofe_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","ኔኒ ታ አሳ የዶና እፅኮ፥ ታኒ፥ ነ ቦላ፥ ነ ሞርናታ ቦላነ፥ ነ አሳ ቦላ ኡዱንፀ ጋዶ የዳና። ግብፀታ ኬꬃነ ኤንቲ ደእያ ቢታ ኡባን ኡዱንፀይ ኩማና። ");
INSERT INTO gofe_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","ሽን ሄ ጋላስ ታ አሳይ ደእያ ጌሳመ ቢታን ኡዱንፀይ ዶናዳ ኤንታ ተቃዳ አሻና። ታኒ ጎዳይ፥ ሄ ዎደ ሀ ቢታን ታኒ ጎዳይ ኦይሳ ኔኒ ኤራና። ");
INSERT INTO gofe_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","ታኒ፥ ታ አሳነ ነ አሳ ሻካና፤ ሄ ግታ ማላታይ ዎንቶ ሀናና’ ያጌስ ጋዳ ኦዳ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","ሄሳፈ ጉየ፥ ጎዳይ ግዳይሳዳ ኦꬅስ። ካዉዋ ጋꬎነ እያ ሞርናታ ሶ ዳሮ ኡዱንፀ ጋዶ የድስ። ኩመꬃ ግብፀ ቢታይ ኡዱንፀ ጋዶን ቆሄትስ። ");
INSERT INTO gofe_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","ሄ ዎደ ካዎይ ሙሰነ አሮና ፄግስድ፥ “ብድ፥ ሀ ቢታን ህንተ ፆሳስ ያርሾ ያርሽተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","ሽን ሙሰ ዛሪድ፥ “ሄስ ሀኖናባ። ኑኒ ጎዳስ፥ ኑ ፆሳስ ያርሽያ ያርሾይ ግብፀታ ማታን እፀትያ ግሾ፥ ሄሳ ኦꬆኮ። ኑ ያርሽሽን ኤንቲ በእኮ ኑና ሹቻን ጫዳና። ");
INSERT INTO gofe_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","ኑና ኪትዳይሳ መላ፥ ኑኒ ጎዳስ፥ ኑ ፆሳስ ያርሾ ያርሻናዉ ሄꬑ ጋላስ ኦገ መላ ቢታ ባናዉ በሴስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","ካዎይ ዛሪድ፥ “ጎዳስ፥ ህንተ ፆሳስ መላ ቢታ ብድ ያርሻና መላ ታኒ ህንተና የዳና። ሽን ህንተ ሃክድ ቦፕተ፤ ታዉ ዎስተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","ሙሰይ ዛሪድ፥ “ታኒ ነ ማታፐ ከይዳ መላ ጎዳ ዎሳና። ሀ ኡዱንፀይ ዎንቶ ካዉዋፐ፥ እያ ሞርናታፐነ እያ አሳፐ ክቻና። ሽን ካዎይ አሳይ ጎዳስ ጎይናናይሳ ድግድ ዛር ኑና ጭሞፎ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","ሄሳፈ ጉየ ሙሰይ ካዉዋ ማታፐ ከይድ፥ ጎዳ ዎስስ። ");
INSERT INTO gofe_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","ጎዳይ ሙሰይ ኦይችዳይሳዳ ኦꬅስ። ኡዱንፀይ ካዉዋፐ፥ እያ ሞርናታፐነ እያ አሳፐ እሶይካ አቶና ክችስ። ");
INSERT INTO gofe_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","ሽን ሀእካ ካዉዋ ዎዛናይ ሙምን አሳ የዶና እፅስ። ");
INSERT INTO gofe_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","ጎዳይ ሙሰኮ፥ “ግብፀ ካዋኮ ባዳ፥ ጎዳይ፥ እብራወታ ፆሳይ ኔኮ፥ ‘ኤንቲ ታዉ ጎይናና መላ ታ አሳ የዳ። ");
INSERT INTO gofe_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","ኔኒ የዶና ኤንታ እፅኮ፥ ");
INSERT INTO gofe_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","ታኒ ነ ፓራታ ቦላ፥ ነ ሀረታ ቦላ፥ ነ ግማለታ ቦላ፥ ነ መህያ ቦላ፥ ነ ዶርሳታ ቦላነ ነ ዴሻታ ቦላ ኢታ ጋዶ የጋና። ");
INSERT INTO gofe_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","ሽን ታኒ ጎዳይ እስራኤለ አሳ መህያ ግዶንነ ግብፀ አሳ መህያ ግዶን ዱማተꬅ መꬋና። እስራኤለ አሳ መህያፐ እሶይካ ሀይቀና። ");
INSERT INTO gofe_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","ዎንቶ ታኒ ሄሳ ኦꬃና ግድ ጎዳይ ዎደ ቃንፅስ’ ያጋ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","ዎንተꬃ ጋላስ ጎዳይ ግዳይሳዳ ኦꬅስ። ግብፀ አሳ መሄ ኡባይ ሀይቅስ፥ ሽን እስራኤለ አሳ መህያፐ እሶይካ ሀይቅቤና። ");
INSERT INTO gofe_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","ካዎይ ሀንዳባነ እስራኤለታ መህያፐ ሀር አቶሽን እሶይካ ሀይቆናይሳ አሰ ኪትድ፥ ኦይችድ ኤርስ። ሽን ሀእካ እያ ዎዛናይ ሙምዳ ግሾ አሳ የዶና እፅስ። ");
INSERT INTO gofe_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","ሄሳፈ ጉየ፥ ጎዳይ ሙሰነ አሮና፥ “ጮጨፐ ብዶ ኩጭ ኤክድ፥ ካዎይ በእሽን ቦላ ꬋርጭተ። ");
INSERT INTO gofe_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","ሄስ ግብፀ ቢታ ኡባ ቦላ ባና ግድድ ላለታና። ግብፀ ቢታን ደእያ አሳ ቦላነ መሄይ ቦላ ክፃ ጋዶ ኤሀና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","ኤንቲ ጮጨፐ ጉꬃ ብዶ ኤክድ ካዉዋ ስንꬃን ኤቅዶሶና። ሙሰይ ሄሳ ቦላ ላልን፥ አሳ ቦላነ መህያ ቦላ ክፃ ጋዶይ ዎꬍ አግስ። ");
INSERT INTO gofe_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","ግብፀ አሳ ቦላ ዎꬍዳ ክፃይ ማሮታ ቦላካ ዎꬍዳ ግሾ ሙሰ ስንꬃን ኤቃናዉ ዳንዳእቦኮና። ");
INSERT INTO gofe_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","ሽን ጎዳይ ሙሰስ ግዳይሳ መላ፥ ካዎይ ባ ዎዛና ሙምስዳ ግሾ፥ ሙሰነ አሮና ስኦና እፅስ። ");
INSERT INTO gofe_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","ሄሳፈ ጉየ፥ ጎዳይ ሙሰኮ፥ “ካዋኮ ጉራ ደንዳ ባዳ፥ ‘ጎዳይ፥ እብራወታ ፆሳይ፥ ታዉ ጎይናና መላ ታ አሳ የዳ። ");
INSERT INTO gofe_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","ሀእ ነ እፃስ ጊኮ፥ ነ ሞርናታነ ነ አሳ ፃላላ ግዶናሽን ነ ቦላካ ኢታ ጋዶ ኤሀና። ሄ ዎደ አላመ ኡባን ጎድ ታ ፃላላ ግደይሳ ኔኒ ኤራና። ");
INSERT INTO gofe_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","ታኒ ታ ኩሽያ ደንꬃዳ ነናነ ነ አሳ ጋዶን ሾጭዳባ ግድያኮ ሀእ ጋካናስ ህንተ ቢታ ቦላ ደኤከታሽን። ");
INSERT INTO gofe_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","ሽን ታ ሱንꬃይ ቢታ ኡባን ኤረታና መላ ታኒ ታ ዎልቃ በሳናዉ ነና ደኦን ዎꬃስ። ");
INSERT INTO gofe_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","ኔኒ ሀእካ ኦቶርታዳ ታ አሳ የዶና እፃዳሳ። ");
INSERT INTO gofe_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","ታኒ ዎንቶ ሀኖደ ግብፀ ቢታይ መꬎቶሳፐ ሀች ጋካናዉ ቡክ ኤሮና ዎልቃማ ሻች ቡክሳና። ");
INSERT INTO gofe_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","ሀእ ኔኒ ነ መህያነ ካረን ደእያባ ኡባ ኤለ ሶ ገልሳና መላ ኪታ። ሶ ገሎና አሳ ቦላነ መህያ ኡባ ቦላ ሻች ቡክድ፥ ኤንታ ዎꬋና ያጌስ’ ያጋ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","ካዉዋ ሞርናታፐ እሶት እሶት ጎዳይ ግዳይሳ ስእድ ያይዳ ግሾ፥ ባንታ አይለታነ ባንታ መሄታ ሶ ገልስዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","ሽን ሀራት ጎዳይ ግዳይሳ ስኦና እፅድ ባንታ አይለታነ ባንታ መህያ ካረን አጋግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","ሄሳፈ ጉየ፥ ጎዳይ ሙሰ፥ “ግብፀ ቢታ ኡባ ቦላ፥ አሳ ቦላ፥ መህያ ቦላነ ጋደን ደእያ ካꬃ ቦላ ሻች ቡካና መላ ነ ኩሽያ ሳሎ ደንꬃ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","ሙሰይ ባ ፃምኣ ሳሎ ደንꬅዳ ዎደ፥ ጎዳይ ዎልቃማ ደሾነ ዎልአንꬅ የድስ። ሄሳዳ ኦꬅድ ጎዳይ ግብፀን ሻች ቡክስስ። ");
INSERT INTO gofe_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","ጎዳይ ገደራ ሃራ ዎልቃማ ዎልአንꬅ የድስ። ሄሳ መላባይ ግብፀ ቢታን አስ ዱሱ ኦይኮደፐ ሀን ኤረና። ");
INSERT INTO gofe_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","ሄ ሻቻይ ግብፀን ደእያ አሳነ መህያ ሾጭስ። ጋደን ደእያባ፥ ምꬅነ ማታ ኡባ ꬋይስስ። ");
INSERT INTO gofe_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","እስራኤለት ደእያ ጌሳመ ቢታ ፃላላን ሻች ቡክቤና። ");
INSERT INTO gofe_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","ካዎይ ሙሰነ አሮና ፄግስድ፥ “ታኒ ሀእ ናጋራ ኦꬃስ። ጎዳይ ቱማንቾ፤ ታንነ ታ አሳይ ባላ። ");
INSERT INTO gofe_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","ደሾይነ ሻቻይ ኑ ቦላ ዳርድ ኡንኤꬅዳ ግሾ ኑስ ጎዳ ዎስተ። ታኒ ህንተና የዳና፤ ህዛፐ ህንተ ሀይሳን ጋምኤከታ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","ሙሰይ እያኮ፥ “ታኒ ሀ ካታማፐ ከይዳ ዎደ ታ ኩሽያ ደንꬃዳ ጎዳ ዎሳና። ደሾይነ ሻቻይ ኤቅያ ዎደ ሳአይ ጎዳባ ግደይሳ ኔኒ ሄሳን ኤራና። ");
INSERT INTO gofe_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","ሽን ነነ ነ ሞርናት ሀእካ ጎዳ ፆሳ ያዮናይሳ ታኒ ኤራይስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","ታልባይ ጪሸ፥ ባንጋይ ቆርፃ ግድያ ግሾ ኡባይ ሻቻን ꬋይስ። ");
INSERT INTO gofe_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","ሽን ግስተይነ ሙርቃይ ጋክቦና ግሾ ሻቻን ꬋይቤና። ");
INSERT INTO gofe_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","ሙሰይ ካዉዋ ማታፐ ከይድ፥ ካታማፐ ጋፃ ብድ ባ ኩሽያ ደንꬅድ ጎዳ ዎስስ። ያትን ደሾይ፥ ሻቻይነ እራይ ኤለስድ ኤቅ አግስ። ");
INSERT INTO gofe_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","ሽን ካዎይ ሄ ኡባይ ኤቅዳይሳ በእዳ ዎደ ዛሪድ ናጋራ ኦꬅስ። እያራነ እያ ሞርናታራ ባንታ ዎዛና ጉጅድ ምንꬅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","ጎዳይ ሙሰ ባጋራ ኦድዳይሳ መላ ካዉዋ ዎዛናይ ሙምን፥ እስራኤለታ የዶና እፅስ። ");
INSERT INTO gofe_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","ሄሳፈ ጉየ፥ ጎዳይ ሙሰኮ፥ “ግብፀ ካዋኮ ባ። ታኒ ሀ ማላታታ ኤንታ ግዶን ኦꬃናዉ ኮያዳ ካዉዋ ዎዛናነ እያ ሞርናታ ዎዛና ሙምሳስ። ");
INSERT INTO gofe_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","ታኒ ሄሳ ኦꬅዳይ ታ ማላታታን ዋታዳ ግብፀታ ሴርዳኮ ህንተ ህንተ ናይታስነ ህንተ ናይታ ናይታስ ኦዳና መላ ኮይዳ ግሾሳ። ሄ ዎደ ታኒ ጎዳ ግደይሳ ህንተ ኤራና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","ሙሰይነ አሮን ካዋኮ ብድ፥ “ጎዳይ፥ እብራወታ ፆሳይ ኔኮ፥ ‘ኔኒ ታዉ ኪተተꬅ እፀይ አዉደ ጋካናሴ? ታዉ ጎይናና መላ ታ አሳ የዳ። ");
INSERT INTO gofe_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","ኔኒ ኤንታ የዶ እፅኮ፥ ዎንቶ ነ ቢታ ቦላ ታኒ ቦለ የዳና። ");
INSERT INTO gofe_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","ቦለይ ዳሮተꬃፈ ደንዶይሳን ቢታ ኡባ ካማና። ኤንቲ ሻቻ ጋዱዋፐ አትዳ ጉꬃባነ ምꬃ ሀይꬅ ኡባ ማና። ");
INSERT INTO gofe_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","ነ ኬꬃ፥ ነ ሞርናታ ኬꬃነ ግብፀ አሳ ኡባ ኬꬃ ኤንቲ ኩማና። ሄስ ነ ማይዛት ሀ ቢታን ደኦሳፐ ሀኖ ጋካናዉ በእዳ ኢታባፐ አꬍያባ ግዳና’ ያጌስ” ያግዶሶና። ሄሳፈ ጉየ፥ ሙሰይ ካዉዋ ስንꬃፈ ከይድ ብስ። ");
INSERT INTO gofe_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","ካዋ ሞርናት ካዋኮ፥ “ሀ ኡራይ አዉደ ጋካናዉ ኑስ ፅሄ ግዳኔ? አሳይ ጎዳ፥ ባንታ ፆሳ ጎይናና መላ ኤንታ የዳ። ግብፀ ቢታይ ꬋየይሳ ኔኒ አኬክኪ?” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","ካዎይ ሙሰነ አሮና ጉየ ፄግስድ፥ “ብድ ጎዳ፥ ህንተ ፆሳ ጎይንተ፥ ሽን በይሳት ኦናንቴ?” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","ሙሰይ፥ “ኑኒ ብያ በሳን ጎዳ ቦንቻናዉ ባኣለ ኦꬃና ግሾ፥ ኑኒ ኑ ጉꬃ ናይታ፥ ኑ ጭማታ፥ ኑ አደ ናይታ፥ ኑ ማጫ ናይታ፥ ኑ ዶርሳታነ ኑ ሚዛታ ኤክድ እስፈ ባና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","ካዎይ፥ “ህንተ ህንተ ናይታነ ህንተ ማጫሳታ ኤክ ቦና መላ ታኒ ጎዳን ጫቅሳይስ። ህንተ ህንተ ዎዛናን ኢታባ ቆፕዳይስ ኤረቴስ። ");
INSERT INTO gofe_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","ህንተ፥ ብድ ጎዳ ጎይናናዉ ኮያባ ግድኮ አደታ ፃላላ ኤክ ቢተ” ያግስ። ሄሳፈ ጉየ፥ ሙሰነ አሮና ካዉዋ ስንꬃፈ ጎደትድ ከይዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","ጎዳይ ሙሰኮ፥ “ቦለይ ይድ ሻቻ ጋዱዋፐ አትዳ ኡባ ማና መላ ነ ኩሽያ ግብፀ ቢታ ቦላ ደንꬃ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","ሙሰይ ባ ፃምኣ ግብፀ ቢታ ቦላ ደንꬅዳ ዎደ፥ ጎዳይ ዶሎሀ ባጋ ጫርኮ ሄ ቃማነ ጋላስ ኩመꬅ ቢታ ቦላ ጫርክስስ። ዎንትያ ዎደ ሄ ጫርኮይ ቦለ ኤህስ። ");
INSERT INTO gofe_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","ቦለይ ግብፀ ቢታ ኡባ ጋክድ ማእስ። ሄሳ መላ ቦለ ጋዶይ ሄ ቢታን ካሰካ ሀንቤና፤ ስንꬃፈካ ሀነና። ");
INSERT INTO gofe_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","ቢት ꬉማና ጋካናዉ ቦለይ ቢታ ኡባ ማእስ። ሄ ቦለይ ሻቻፈ አትድ ጋደን ድጭያባ ኡባነ ምꬃ አይፈ ኡባ ምዶሶና። ግብፀ ቢታን ደእያ ምꬃ ሀይꬅነ ጭልኦባ ኡባ ምድግስ። ");
INSERT INTO gofe_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","ካዎይ ሙሰነ አሮና ኤለስ ፄግስድ፥ “ታኒ ጎዳ ህንተ ፆሳነ ህንተና ናቃስ። ");
INSERT INTO gofe_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","ህዛ ታ ናጋራ ታዉ እስ ቶሆ አቶ ጊተ። ሀ ꬋይስያ ጋዱዋ ታፐ ድጋና መላ ጎዳ ህንተ ፆሳ ዎስተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","ሙሰይ ካዉዋ ማታፐ ከይድ ጎዳ ዎስስ። ");
INSERT INTO gofe_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","ጎዳይ ዉሎሀ ዎልቃማ ጫርኩዋ ኪትድ ቦልያ ቢታፈ ደንꬅድ፥ ዞኦ አባ የድስ። ግብፀ ቢታ ኡባን እስ ቦለይካ ሀይቅቤና። ");
INSERT INTO gofe_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","ሽን ጎዳይ ካዉዋ ዎዛና ሙምስዳ ግሾ እስራኤለታ የዶና እፅስ። ");
INSERT INTO gofe_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","ጎዳይ ሙሰ፥ “ግብፀ ቢታን አስ ኦይክ በእያ ꬉም ꬉማና መላ ነ ኩሽያ ሳሎ ደንꬃ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","ሙሰይ ባ ኩሽያ ሳሎ ደንꬅስ። ግብፀ ቢታ ኡባን ሄꬑ ጋላስ ኩመꬅ ሳካና ꬉማይ ꬉምስ። ");
INSERT INTO gofe_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","ሄ ሄꬑ ጋላሳታን ግብፀት እሶይ እሱዋ በእቦኮና ዎይኮ ኦንካ ባ ሶፐ ከይቤና። ሽን እስራኤለት ደእያ ጌሳመን ፖኦይ ደኤስ። ");
INSERT INTO gofe_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","ካዎይ ሙሰ ፄግስድ፥ “ብድ ህንተ ጎዳ ጎይንተ። ህንተ ማጫሳይነ ህንተ ናይት ህንተራ ባናዉ ዳንዳኦሶና። ህንተ ዶርሳ ዉድያነ ህንተ ሚዛ ዉድያ ፃላላ አግድ ቢተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","ሽን ሙሰይ፥ “ኑኒ ፁሳ ያርሾነ ሀራ ያርሾ ጎዳ ፆሳስ ያርሻና መላ መሄ ኔኒ ኑስ እማናዉ ኮሼስ። ");
INSERT INTO gofe_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","እሶይካ ጉየ አቶና ኑ መሄይ ኑራ ባናዉ ኮሼስ። ጎዳ፥ ኑ ፆሳ ጎይናናዉ መህያፐ ዶራናዉ በሰይ ኑና። ኑኒ ያ ጋኮና ደእሸ አይ መሄ ያርሻነኮ ኤራናዉ ዳንዳኦኮ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","ሽን ጎዳይ ካዉዋ ዎዛና ሙምስዳ ግሾ፥ እ ኤንታ የዳናዉ ኮይቤና። ");
INSERT INTO gofe_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","ሄሳፈ ጉየ፥ ካዎይ ሙሰኮ፥ “ታ ስንꬃፈ ክቻ፤ ታ ስንꬃን ዛራ በንታዳ ነና ኤራ። ታ አይፍያ ነ በእዳ ጋላስ ሀይቃና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","ሙሰይ እያኮ፥ “ቱማካ ነ ግዳይሳዳ ኔኒ ታ አይፍያ ዛራዳ በአካ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","ጎዳይ ሙሰኮ፥ “ታኒ ግብፀ ካዉዋ ቦላነ እያ አሳ ቦላ እስ ሀራ ጋዶ የዳና። ሄሳፈ ጉየ፥ እ ህንተና ከስ የዳና። እ ህንተና ኡባ ጎድድ ከሳና። ");
INSERT INTO gofe_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","እስራኤለ አሳይ፥ አደይነ ማጫስ ባንታ ሾሮታፐ ብራነ ዎርቃ አሌቆ ኦይቻና መላ ኤንታዉ ኦዳ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","ጎዳይ እስራኤለ አሳስ ግብፀታ ስንꬃን ቴሞ እሚስ። ግብፀ ካዉዋ ሞርናትነ አሳይ ሙሰ ዳሮ ቦንቸትዳ አሳዳ ፄልዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","ሙሰይ ካዋኮ፥ “ጎዳይ ሀይሳዳ ያጌስ፤ ‘ቃማ ብላሄ ታኒ ግብፀ ቢታ ግዶራ ካንꬃና። ");
INSERT INTO gofe_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","ግብፀ ቢታን ደእያ ባይራ አደ ናእ ኡባይ፥ ካዋ አራታ ላታናዉ ደእያ ባይራ ናኣፐ ዶምድ፥ ዎፃን ጋጭያ ማጫ አይለ ባይራ ናአ ጋካናዉ፥ ባይራ የለትዳ መሄ ኡባይ ሀይቃና። ");
INSERT INTO gofe_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","ግብፀ ቢታ ኡባን ሄሳፈ ካሰካ ስንꬃፈካ ሀኖና ግታ ዬሆይ ዬኬታና። ");
INSERT INTO gofe_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","ሽን እስራኤለ አሳ ቦላ ዎይኮ ኤንታ መህያ ቦላ ካንካ ቦጨና።’ ሄ ዎደ ታኒ ጎዳይ ግብፀታ ግዶንነ እስራኤለ ግዶን ዱማተꬅ መይሳ ኔኒ ኤራና። ");
INSERT INTO gofe_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","ነ ሞርናት ኡባይ ይድ ታ ስንꬃን ጉፋናና። ታ አሳ ኤካዳ ሀ ቢታፈ ከያና መላ ኤንቲ ታና ዎሳና። ሄሳፈ ጉየ፥ ታኒ ባና” ያግስ። ሙሰይ ሸነን ፁገትድ ካዋ ስንꬃፈ ከይድ ብስ። ");
INSERT INTO gofe_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","ጎዳይ ሙሰስ ካሰ፥ “ግብፀ ቢታን ታኒ ማላልስያባ ዳርሳዳ ኦꬃና ጋሶ ካዎይ ህንተና ስኤና” ያግድ ኦድ ዎꬅስ። ");
INSERT INTO gofe_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","ሙሰይነ አሮን ማላልስያባ ኡባ ካዋ ስንꬃን ኦꬅዶሶና። ሽን ጎዳይ ካዉዋ ዎዛና ሙምስዳ ግሾ፥ እስራኤለታ ባ ቢታፈ የዶና እፅስ። ");
INSERT INTO gofe_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","ጎዳይ ግብፀ ቢታን ሙሰነ አሮና ሀይሳዳ ያግስ፤ ");
INSERT INTO gofe_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“ሀ አጌናይ ህንተዉ ላይꬃስ ኮይሮ አጌና ግዶ። ");
INSERT INTO gofe_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","እስራኤለ አሳ ኡባስ ሀ ዎጋ ኦድተ። ሀ አጌናይ ገልዳ ታማንꬆ ጋላሳን፥ እስ አስ ባ ሶ አሳስ እስ ማራዘ ዎይኮ እስ ኮለ ኤኮ። ");
INSERT INTO gofe_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","ሄ ኬꬃ አሳ ታይቦይ ሄ መህያ ዉርስድ ማናዉ ዳንዳኦና እፅኮ፥ እያራነ እያ ማታ ሾሩዋራ ባንታ ሶ አሳ ታይቡዋ መላነ እስ እስ አስ ምድ ዉርሳናዉ ዳንዳእያ ኬና ኤክድ ሄ መህያ ሹክድ እስፈ ሞና። ");
INSERT INTO gofe_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","ህንተ ዶርያ መሄይ ዶርሰ ዎይኮ ዴሸ ግዳናዉ ዳንዳኤስ፥ ሽን እስ ላይꬅ ኩምዳይሳነ እያ ቦላ ቦረይ ባይና አደ ግዶ። ");
INSERT INTO gofe_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","ሀ አጌናስ ታማነ ኦይዳንꬆ ጋላስ ጋካናዉ ኤንታ ሄምተ። ሄ ጋላስ ኦማርስ ላድያ ዎደ እስራኤለ አሳ ማባራ ኡባይ ኤንታ ሹካናዉ በሴስ። ");
INSERT INTO gofe_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","አሳይ ሄ ሱꬃፈ ኤክድ ኤንቲ ምያ ኬꬃ ዉላ ጋርሳ፥ ቆሙዋነ ቦኮሉዋ ትዮ። ");
INSERT INTO gofe_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","አሹዋ ሄ ጋላስ ቃማ ታማን ጫጭድ ጫምያ ቦንጮራነ ኡይꬃራ ሚተ። ");
INSERT INTO gofe_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","አሹዋ ቃየ ዎይኮ ካꬅድ ሞፕተ። ሁጵያ፥ ገዳታነ ኡሎ አሾታ ኡባ ጫጭድ ሚተ። ");
INSERT INTO gofe_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","ሄ አሹዋፐ ዎንታና ጋካናዉ አይኮካ አሾፍተ። ዎንታና ጋካናዉ አትኮ ሄሳ ፁግተ። ");
INSERT INTO gofe_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","ኦገስ ጊግያ ማኦ ማእድ፥ ህንተ ጫማ አꬅድ፥ ህንተ ፃምኣ ኦይክድ ኤሶን ሚተ። ሄስ ታና ጎዳ ቦንችያ ፓስካ ባኣለ ህንተዉ ግዶ። ");
INSERT INTO gofe_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“ታኒ ሄ ቃማ ግብፀራ ካንꬃዳ ባይራ የለትዳ ኡባ፥ አሳነ መህያ ዎꬋና። ግብፀ ኤቃታ ኡባ ፕርዳና፤ ታኒ ጎዳ። ");
INSERT INTO gofe_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","ሄ ሱꬃይ ህንተ ደእያ ኬꬃ ኤርስያ ማላ ግዳና። ታኒ ግብፀታ ፕርድያ ዎደ ሄ ሱꬃ በአዳ ህንተና ቆሆና አጋ አꬋና። ");
INSERT INTO gofe_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“ሀ ጋላሳይ ታኒ ጎዳይ ህንተዉ ኦꬅዳይሳ ላይꬃን ላይꬃን ቆፍስያ ጎዳ ቦንችያ ባኣለ ግዶ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","“ላፑን ጋላስ ጋካናዉ እርሾይ ገሎና ኡይꬅ ሚተ። ኮይሮ ጋላስ እርሾ ህንተ ሶፐ ድግተ። ሄ ላፑን ጋላሳታን እርሾይ ደእያ ኡይꬅ ምያ አስ እስራኤለ አሳ ግዶፈ ዱፅድ ኩረቶ። ");
INSERT INTO gofe_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","ኮይሮ ጋላሳንነ ላፑንꬃ ጋላሳን ጎይናናዉ ሺቅተ። ሄ ጋላሳታን አይብ ኦሶካ ኦꬆፍተ፥ ሽን ካꬅ ካꬃናዉ ዳንዳኤታ። ");
INSERT INTO gofe_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","“ታኒ እስራኤለ ደርያ ግብፀፈ ከስዳይ ሄ ጋላስ ግድያ ግሾ ሀ ኡይꬃ ባልያ ላይꬃን ላይꬃን ቦንችተ። ሄስ ህንተዉ መርና ዎጋ ግዶ። ");
INSERT INTO gofe_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","ኮይሮ አጌናን፥ ታማነ ኦይዳንꬆ ጋላስ ኦማርሳፈ ዶምድ፥ ላታማነ እስንꬆ ጋላስ ኦማርስ ጋካናዉ እርሾይ ገልቦና ኡይꬃ ሚተ። ");
INSERT INTO gofe_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","ላፑን ጋላስ ጋካናዉ እርሾይ ህንተ ሶን በንቶፎ። እርሾይ ገልዳባ ምያ ቢታ አዉ ናአ ግድን ዎይኮ አሳ ጋደ አስ ግድን፥ ሄ ኬꬃ አዋይ እስራኤለ ማባራ ግዶፈ ኩረቶ። ");
INSERT INTO gofe_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","እርሾይ ገልዳባ አይኮካ ሞፕተ። ህንተ ደእያሶን አዉንካ እርሾይ ገልቦና ኡይꬁ ሚተፐ አትሽን፥ እርሾይ ገልዳ ኡይꬁ ሞፕተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","ሙሰይ እስራኤለ ጭማታ ኡባ ፄግስድ ሀይሳዳ ያግስ፤ “ህንተ እሶይ እሶይ ሶ ብድ ፓስካ ባኣለ ቦንቻናዉ ማራዘ ዎይኮ ኮለ ሹክተ። ");
INSERT INTO gofe_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","ህሶጰ ምꬃ ሀይꬃፈ ዳንክ ኤክድ፥ ከረን ደእያ ሱꬃን የድ ኤክድ ዉላ ጋርሳ፥ ቆሙዋነ ቦኮሉዋ ትይተ። ዎንታና ጋካናዉ ህንተፈ እሶይካ ባ ኬꬃፈ ካረ ከዮፖ። ");
INSERT INTO gofe_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","ጎዳይ ግብፀ ባይራታ ዎꬋናዉ ሄ ቢታራ ካንꬅያ ዎደ፥ ሄ ሱꬃ ዉላ ጋርሳ፥ ቆሙዋንነ ቦኮሉዋ ቦላ በእድ አግድ አꬋና። ሀይቆ ኤህያ ኪታንቾይ ህንተ ሶ ገልድ ህንተና ዎꬎና መላ ድጋና። ");
INSERT INTO gofe_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“ህንተነ ህንተ ናይት ሀ ኪታ መርናዉ ናግተ። ");
INSERT INTO gofe_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","ጎዳይ ካሰ እማና ግድ ቃላ ገልዳ ቢታ ህንተ ገልያ ዎደ ሀ ዎጋ ኦꬅተ። ");
INSERT INTO gofe_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","ህንተ ናይት ህንተና፥ ‘ሀ ባልያ ኑ አይስ ቦንችዉ?’ ግድ ኦይችያ ዎደ፥ ");
INSERT INTO gofe_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","ህንተ ኤንታኮ፥ ‘ሀይስ ጎዳ ቦንችያ ፓስካ ያርሾ። ሄስካ ጎዳይ ግብፀ ቢታን እስራኤለ አሳ ኬꬃ አግድ፥ አꬍድ፥ ግብፀ ባይራታ ዎꬍድ፥ ኑና አሽዳ ግሾሳ’ ያግተ” ያግስ። ሄሳፈ ጉየ፥ እስራኤለት ጉልባትድ ጎይንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","እስራኤለት፥ ጎዳይ ሙሰነ አሮና ኪትዳይሳዳ ኦꬅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","ግድ ብላሄ ጎዳይ ግብፀን ባይራ የለትዳ ኡባ፥ ካዉዋ አራታ ላታናዉ ደእያ ባይራ ናኣፐ ዶምድ፥ ቃሾ ኬꬃን ደእያ አሳታ ባይራ ናይታ ጋካናዉነ ባይራ የለትዳ መሄ ኡባይ ሀይቅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","ካዎይ፥ እያ ሞርናትነ ግብፀ ቢታ አሳ ኡባይ ቃማ ደንድዶሶና። ግብፀ ቢታን አስ ሀይቅቦና እስ ኬꬅካ ባይና ግሾ፥ አሳይ ባንታ ቃላ ꬎቁ ኦꬅድ ግታ ዬሆ ዬክዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","ሄ ቃማ ካዎይ ሙሰነ አሮና ፄግስድ፥ “ህንተነ ህንተ እስራኤለት ታ ቢታፈ ከይድ ቢተ። ህንተ ታና ኦይችዳይሳዳ ብድ ህንተ ጎዳ ጎይንተ። ");
INSERT INTO gofe_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","ህንተ ግዳይሳ መላ ህንተ ዶርሳነ መህያ ዉድያ ኤክድ ቢተ። ቃስ ህንተ ፆሳይ ታና አንጃና መላ ዎስተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","ግብፀ አሳይ፥ “እስራኤለት ባንታ ቢታፈ ኤለስድ ከያና መላ ድርግስዶሶና። ህንተ ከዮና እፅኮ ኑ ኡባይ ዉሮስ” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","ሄሳ ግሾ፥ እስራኤለ አሳይ እርሾይ ገልቦና ሙናቃ ከረን ኩንꬅድ፥ ባንታ ማኡዋን ካምድ፥ ባንታ ሀሸን ቶክዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","እስራኤለት ሙሰይ ኤንታ ኪትዳይሳዳ ግብፀታ፥ ብራ አሌቆ፥ ዎርቃ አሌቆነ ማኦ እማና መላ ኦይችዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","ጎዳይ፥ እስራኤለት ግብፀታ ስንꬃን ሳበታናዳ ኦꬅን፥ ግብፀት ኤንቲ ኦይችዳባ ኡባ እምዶሶና። ሄሳዳ ያትድ ኤንቲ ግብፀታ ሻሉዋ ቦንቅ ኤክድ ብዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","እስራኤለት ራምሰ ካታማፐ ደንድድ ሱኮታ ጌተትያ በሲ ቶሆን ብዶሶና። አሳ ታይቦይ ናይታነ ማጫሳ ጉጆና ኡሱፑን ፄቱ ሙኩላ። ");
INSERT INTO gofe_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","ቃስ ኤንታራ ሀራ ዳሮ ዋላካ አሳይ፥ መሄይነ ዶርሳ ዴሻ ዉደይ ላገትድ ብስ። ");
INSERT INTO gofe_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","ግብፀፈ ኤንቲ ድርጎን ከይዳ ግሾ ካꬅ ካꬃናዉ ዎደ ꬋይዶሶና። ኤንቲ ከይሸ ኤክ ከይዳ እርሾይ ገልቦና ሙኑቃፐ ኤክድ ኡይꬅ ኡክዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","እስራኤለት ግብፀ ቢታን ደእዳ ላይꬃይ ኦይዱ ፄታነ ሀስታማ። ");
INSERT INTO gofe_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","ኦይዱ ፄታነ ሀስታሙ ላይꬃይ ዉርያ ሄ ዉርሰꬃ ጋላስ ጎዳ አሳ ኡባይ ግብፀ ቢታፈ ከይዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","ጎዳይ ባ አሳ ናግድ፥ ግብፀፈ ከስዳ ዎደ ሳእ ቃማ። ሄ ቃማይ የለተꬃፈ የለተꬃ ጋካናዉ እስራኤለ አሳይ ባርክድ ናግሸ አቅያ፥ ጎዳስ ዱማትዳ ቃማ። ");
INSERT INTO gofe_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","ጎዳይ ሙሰነ አሮና፥ “ፓስካ ጋላሳ ቦንችያ ዎጋይ ሀይሳ ያግስ፤ አሳ ጋደ አስ ፓስካ ካꬃፈ ሞፖ። ");
INSERT INTO gofe_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","ህንተ ህንተ ሚሸን ሻምዳ አይለይ ቃፃረትዳፐ ጉየ ሞ። ");
INSERT INTO gofe_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","ሽን ህንተራ ጋምእያ እማꬅነ ኡነ ኦꬅያ አስ እያፐ ሞፖ። ");
INSERT INTO gofe_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“ሄ ፓስካ ካꬃይ ካፅዳ ኬꬃን ያን ሚተ። ሄ አሹዋፐ አይኮካ ካረ ከሶፍተ። መቀꬃታፐ እሱዋካ መንꬆፍተ። ");
INSERT INTO gofe_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","እስራኤለ ማባራ ኡባይ ፓስካ ባኣለ ቦንቻናዉ ኮሼስ። ");
INSERT INTO gofe_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","“አሳ ጋደ አስ ግድድ ህንተ ግዶን ደእያ አስ ጎዳ ፓስካ ባኣለ ቦንቻናዉ ኮይኮ፥ እያራነ እያ ሶን ደእያ አደ ኡባይ ቃፃረቶ። ሄሳፈ ጉየ፥ እ ቢታ አዉ ናአዳ ታይበትድ ፓስካ ባኣለ ቦንቻናዉ ዳንዳኤስ። ሽን ቃፃረትቦና አስ እያፐ ሞፖ። ");
INSERT INTO gofe_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","ሀ ዎጋይ ቢታ አዉ ናይታስነ ሀራ ቢታ አስ ግድድ ህንተ ግዶን ደእያ አሳስ እስኖ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","እስራኤለ ኡባይ፥ ጎዳይ ሙሰነ አሮና ኪትዳይሳዳ ኦꬅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","ሄ ጋላስ ጎዳይ እስራኤለታ ጩጋን ጩጋን ግብፀ ቢታፈ ከስስ። ");
INSERT INTO gofe_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","ጎዳይ ሙሰኮ፥ ");
INSERT INTO gofe_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“ባይራ የለትዳ አደ ኡባ ታዉ ዱማያ። እስራኤለ አሳ ግዶን ባይራ የለትዳ ኡባይ፥ አሰ ዎይኮ መሄ ግድን ኡባይ ታባ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","ሄሳፈ ጉየ፥ ሙሰይ አሳኮ፥ “ሀ ጋላሳይ፥ ህንተ ግብፀ አይለተꬃፈ ከይዳ ጋላስ ግድያ ግሾ እያ ቆፕተ። ጎዳይ ባ ግታ ዎልቃን ህንተና ከስዳይ ሄ ጋላሳና ግድያ ግሾ፥ እርሾይ ገልዳባ አይኮካ ሞፕተ። ");
INSERT INTO gofe_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","አቢባ አጌናን፥ ሀች ጋላሳን ህንተ ግብፀፈ ከይደታ። ");
INSERT INTO gofe_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","ጎዳይ ካናነታ፥ ህተታ፥ አሞረታ፥ ህወታነ ያቡሰታ ቢታ ህንተና ላትሳናዉ ህንተ ማይዛታስ ጫቅስ። ጎዳይ ህንተና ማꬅነ ኤስ ኩምዳ ሄ ቢታ ጋꬅያ ዎደ ላይꬃን ላይꬃን ሀ ኮይሮ አጌናን ሀ ጋላሳ ቦንችተ። ");
INSERT INTO gofe_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","ላፑን ጋላስ ኩመꬅ እርሾይ ገልቦና ኡይꬅ ሚተ። ላፑንꬃ ጋላሳይ ጎዳ ቦንችያ ባኣለ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","ሄ ላፑን ጋላሳታን እርሾይ ገልቦና ኡይꬅ ሚተ። እርሾይ ዎይኮ እርሾይ ደእያባይ ህንተ ግዶንነ ህንተ ዛዋን በንቶፎ። ");
INSERT INTO gofe_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","ሄ ጋላስ ኔኒ፥ ‘ታኒ ሀይሳ ኦይ ታኒ ግብፀፈ ከይያ ዎደ ጎዳይ ታዉ ኦꬅዳይሳ ቆፓናሳ’ ያጋዳ ነ ናይታስ ኦዳ። ");
INSERT INTO gofe_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","ሀ ባለይ ህንተ ኩሸን ዎይኮ ህንተ ሶምኦን ቃሸትዳ ማላ ግድድ ህንተና ቆፍስያባ ግዳና። ጎዳይ ህንተና ባ ግታ ዎልቃን ግብፀፈ ከስዳ ግሾ፥ ጎዳ ዎጋይ ህንተ ዶናፐ ዎꬎና መላነ ሀራታስ ህንተ ኦዳና መላ ህንተና ቆፍሳና። ");
INSERT INTO gofe_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","ሄሳ ግሾ፥ ህንተ ሀ ባልያ ላይꬃን ላይꬃን ባ ዎድያን ቦንችተ። ");
INSERT INTO gofe_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“ጎዳይ ህንተዉነ ህንተ ማይዛታስ እማና ግድ ጫቅዳ ካናነታ ቢታ ገልስድ፥ ሄ ቢታ ህንተዉ እምያ ዎደ፥ ");
INSERT INTO gofe_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","ባይራ የለትዳ ኡባ ጎዳስ እማ። ነ መሄታን ባይራ የለትያ አደ ኡባይ ጎዳሳ። ");
INSERT INTO gofe_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","ባይራ የለትያ ሀረ ማር ኡባ ዶርሳ ማራን ዎዛ። ዎዞና እፅኮ እያ ሞርግያ መንꬃ። ነ አደ ናይታ ግዶን ባይራ የለትዳ ኡባ ዎዛ። ");
INSERT INTO gofe_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","ስንꬃራ ያና ላይꬃታን ነ ናይት ነና፥ ‘ሀይስ አይቤ?’ ግድ ኦይችኮ ኔኒ፥ ‘ጎዳይ ኑና ባ ግታ ዎልቃን ግብፀ አይለተꬃፈ ከስስ። ");
INSERT INTO gofe_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","ግብፀ ካዎይ ባ ዎዛና ሙምስድ ኑና የዶና እፅን፥ ጎዳይ ግብፀ ቢታን ደእያ አሳፐ ዶምድ መሄ ጋካናዉ ባይራ ኡባ ዎꬍስ። ኑኒ ባይራ የለትዳ መሄ አደ ጎዳስ ያርሸይነ ባይራ አደ ናይታ ኑኒ ዎዘይ ሄሳሳ ያጋ። ");
INSERT INTO gofe_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","ጎዳይ ኑና ባ ግታ ዎልቃን ግብፀፈ ከስዳ ግሾ፥ ሀ ባለይ ኑ ኩሸን ዎይኮ ኑ ሶምኦን ቃሸትዳ ማላ ግድድ ኑና ቆፍስያባ ግዳና’ ያጋ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","ካዎይ አሳ የድዳ ዎደ፥ ፆሳይ ኤንታ ማታ ግድዳ ፍልስፄመ ቢታራ ካንꬅስያ ኦግያራ ካለꬅቤና። ፆሳይ ሄሳ ኦꬅዳይ፥ “አሳ ኦል ጋክኮ፥ ባንታ ቆፋ ላምድ ጉየ ግብፀ ስማና” ያግድ ቆፕዳ ግሾሳ። ");
INSERT INTO gofe_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","ሄሳ ግሾ፥ ፆሳይ አሳ መላ ቢታ ኦግያራ ዩሽድ፥ ዞኦ አባኮ ካለꬅስ። እስራኤለት ኦላስ ጊግድ ግብፀ ቢታፈ ከይዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","ዮሰፍ፥ “ፆሳይ ቱማ ህንተና አሻናዉ ያና። ሄ ዎደ ህንተ ታ መቀꬃ ሀ ቢታፈ ኤክድ ቢተ” ያግድ እስራኤለታ ጫቅስድ ዎꬅዳ ግሾ ሙሰይ እያ መቀꬃ ባራ ኤክድ ብስ። ");
INSERT INTO gofe_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","ኤንቲ ሱኮታፐ ደንድድ መላ ቢታ ጋፃን ደእያ ኤታማን ኡትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","ኤንቲ ጋላስነ ቃማ ሄመታና መላ ጋላስ ኤንታና ካለꬃናዉ ሻራ ቱሳን፥ ቃማ ፖእስድ ኤንታ ካለꬃናዉ ታማ ቱሳን ኤንታ ስንꬃን ብስ። ");
INSERT INTO gofe_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","ጋላስ ሻራ ቱሳይ፥ ቃማ ታማ ቱሳይ አሳ ስንꬃፈ ክችቤና። ");
INSERT INTO gofe_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","ሄሳፈ ጉየ፥ ጎዳይ ሙሰኮ፥ ");
INSERT INTO gofe_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“ኤንቲ ጉየ ስሚድ ምግዶላፐነ ዞኦ አባፈ ግዶን፥ ፕሀህሮታ ስንꬃን፥ ባኣል-ዛፎና ማታን ኡታና መላ ኦዳ። ");
INSERT INTO gofe_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","ካዎይ፥ ‘እስራኤለት መላ ቢታ ከያናዉ ኦገ ꬋይድ ጮ ቶይላቶሶና’ ያግድ ቆፓና። ");
INSERT INTO gofe_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","ታኒ ካዉዋ ዎዛና ሙምሳና፤ እ ኤንታ ጎዳና። ታኒ ካዋነ እያ ኦላንቾታ ኡባ ፆናዳ ቦንቸታና። ሄ ዎደ ግብፀት ታኒ ጎዳ ግደይሳ ኤራና” ያግስ። ሄሳ ግሾ እስራኤለት እ ኦድዳይሳዳ ኦꬅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","አሳይ ከስ ኤክዳይሳ ግብፀ ካዎይ ስእድ፥ እያራነ እያ ሞርናታራ ባንታ ቆፋ ላምድ፥ “ኑኒ አይስ ሄሳ ኦꬅዶ? ኑኒ እስራኤለታ የድድ፥ ኑና ሀጋዝያ አስ አይስ ꬋያነ” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","ሄሳ ግሾ እ ባ ፓራ ጋርያ ኮርድ፥ ባ ኦላንቾታ ኤክድ ደንድስ። ");
INSERT INTO gofe_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","እ ኡሱፑን ፄቱ ዶረትዳ ፓራ ጋረታነ ግብፀ ቢታን ደእያ ሀራ ጋረታ ኡባ ኤንታ ሀላቃታራ ኤክድ ብስ። ");
INSERT INTO gofe_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","ጎዳይ ግብፀ ቢታ ካዉዋ ዎዛና ሙምስዳ ግሾ ያሽ ባይና ከሳ ቦላ ደእያ እስራኤለ አሳ የደꬅስ። ");
INSERT INTO gofe_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","ግብፀ ካዉዋ ፓራት፥ ፓራ ጋረትነ ኦላንቾት እስራኤለታ ካልድ ብድ፥ አባ ዶናን ባኣል-ዛፎናነ ፕሀህሮታ ማታን ኤንቲ ኡትዳሽን ደምዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","ካዎይ ባ ኦላንቾታራ ይሽን እስራኤለት ደምድ ያይዶሶና፤ ባንታና ማዳና መላ ጎዳኮ ዋስዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","ኤንቲ ሙሰኮ፥ “ግብፀ ቢታን ኑስ ዱፎይ ꬋይዴ? ኑኒ መላ ቢታ ሀይቃና መላ ኑና ከስዳይ ሄሳሴ? ኑና ግብፀፈ አይስ ኤሀዲ? ");
INSERT INTO gofe_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","ግብፀን ደእሸ ሀይስ ሀናናይሳ ኤርድ፥ ‘ኑና አጋ ኑኒ ግብፀታስ ሃረታና’ ያግድ ነዉ ኦድቦኮ? መላ ቢታን ሀይቃናፐ ኤንታዉ ሃረተይስ ኑስ ሎኦሽን” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","ሽን ሙሰይ ዛሪድ፥ “ያዮፍተ፤ ምንድ ኤቅተ። ጎዳይ ሀች ህንተና አሽያ አሹዋ ህንተ በአና። ሀች ህንተ በእያ ግብፀታ ዛር በኤከታ። ");
INSERT INTO gofe_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","ህንተ ስእ ጊተ፤ ጎዳይ ህንተ ግሾ ኦለታና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","ጎዳይ ሙሰኮ፥ “ኔኒ አይስ ታኮ ዋሳይ? እስራኤለት ስን ሄመታና መላ ኦዳ። ");
INSERT INTO gofe_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","ነ ፃምአ አባ ቦላ ደንꬃ፤ ሃꬃይ ሻከታና። እስራኤለት መላ ቢታራ አባ ፕንድ ባና። ");
INSERT INTO gofe_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","ታኒ ግብፀታ ዎዛና ሙምሳና፤ ኤንቲ ህንተ ጌዶ ካልድ አባን ገላና። ታኒ ካዉዋ፥ እያ ኦላንቾታ፥ እያ ፓራ ጋርያነ እያ ፓራ ጋርያ ላገይሳታ ፆናዳ ቦንቸታና። ");
INSERT INTO gofe_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","ታ ኤንታ ፆንዳ ዎደ፥ ታኒ ጎዳ ግደይሳ ግብፀት ኤራና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","ፆሳ ኪታንቾይ፥ እስራኤለ ኦላንቾታፐ ስንꬃራ ሄመተይስ ኤንታፈ ጉየ አꬍድ ሄመትስ። ሻራ ቱሳይ ኤንታ ስንꬃፈ ጉየ ባጋ አꬍድ፥ ");
INSERT INTO gofe_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","ግብፀታስነ እስራኤለታስ ግዶን ኤቅስ። ሄ ሻራይ ግብፀታስ ꬉምስድ፥ እስራኤለታስ ፖእስስ። ያትን ቃማ ኩመꬅ ግብፀት እስራኤለታኮ ሺቅቦኮና። ");
INSERT INTO gofe_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","ሙሰይ አባ ቦላ ባ ኩሽያ ምጭስ። ጎዳይ ሄ ቃማ ዎልቃማ ዶሎሀ ጫርኮ የድድ መላ ቢት በንታና ጋሶ አባ ሾጭስ። ሃꬃይ ሻከትስ። ");
INSERT INTO gofe_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","ሃꬃይ ሻከትድ ናምኡ ባጋን ጎዳዳ ኤቅን፥ እስራኤለት መላ ቢታራ ሄመትድ ፕንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","ግብፀ ካዉዋ ፓራት፥ እያ ፓራ ጋረትነ እያ ፓራ ጋርያ ላገይሳት ኤንታና ካልድ፥ አባን ገልዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","ሳእ ዎንታና ሀንሽን ጎዳይ ታማነ ሻራ ቱሳን ግድድ ግብፀ ኦላንቾታ ዱገ ፄልድ፥ ኤንታዉ ሀናናባ ꬋይስስ። ");
INSERT INTO gofe_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","ፓራ ጋረታ ገርቶይ ገንደረቶና መላ ጎዳይ ኤንታ ፓራ ጋረታ ገርቱዋ ሳአራ ኦይꬅስ። ግብፀት፥ “ጎዳይ እስራኤለታ ማድድ ኑና ኦልያ ግሾ፥ ኑኒ ኤንታ አግድ ባቃቶስ” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","ጎዳይ ሙሰኮ፥ “ሃꬃይ ግብፀታ ቦላ፥ ኤንታ ፓራ ጋረታ ቦላነ ኤንታ ፓራ ጋርያ ላገይሳታ ቦላ ጉየ ስማና መላ ነ ኩሽያ አባ ቦላ ምጫ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","ሙሰይ ባ ኩሽያ አባ ቦላ ምጭን፥ ሳእ ዎንትያ ዎደ አባይ ባ ካሰ በሳ ጉየ ስምስ። ግብፀት ባቃታናዉ ኮይዶሶና፥ ሽን ጎዳይ ኤንታ አባን የግስ። ");
INSERT INTO gofe_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","ሃꬃይ ጉየ ስሚድ፥ እስራኤለታ ካልድ አባን ገልዳ ፓራ ጋረታ፥ ፓራ ጋረታ ላገይሳታነ ግብፀ ኦላንቾታ ምትስ። ኤንታፈ እሶይካ አትቤና። ");
INSERT INTO gofe_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","ሽን እስራኤለት አባ ግዶራ መላ ቢታራ ሄመትድ፥ ሃꬃይ ሻከትድ ጎዳዳ ኤቅዳሽን ፕንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","ጎዳይ ሄ ጋላስ እስራኤለ አሳ ግብፀታ ኩሸፐ አሽስ። እስራኤለት ሀይቅድ ዝንእዳ ግብፀታ አባ ዶናን በእዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","እስራኤለት ጎዳይ ግብፀታ ቦላ በስዳ ግታ ዎልቃ በእዳ ዎደ ጎዳ ያይዶሶና። ጎዳነ እያ አይልያ ሙሰ አማንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","ሄ ዎደ ሙሰይነ እስራኤለ አሳይ ሀ ማዝሙርያ ጎዳስ የፅዶሶና። እ ባ ግታ ፆኑዋን ቦንቸትዳ ግሾ፥ ታኒ ታ ጎዳስ ጋላታ ማዝሙርያ የፃና። ፓራነ ፓራ ቶገይሳ አባን የግስ። ");
INSERT INTO gofe_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","ጎዳይ ታ ምኖተꬃነ ታ ማዝሙርያ ጋሱዋ፥ እ ታና አሸይሳ። እ ታ ፆሳ፤ ታኒ እያ ሳባና። እ ታ አዋታ ፆሳ፤ ታኒ እያ ቦንቻና፤ ጋላታና። ");
INSERT INTO gofe_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","ጎዳይ ኦላንቾ፤ እያ ሱንꬃይካ ጎዳ። ");
INSERT INTO gofe_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","ግብፀ ካዉዋ ፓራ ጋረታነ እያ ኦላንቾታ አባን የግስ። ግብፀ ካዉዋ፥ ኡባፈ አꬎ ግድዳ ቶራ ሞጮናታ፥ ዞኦ አባን ምትስስ። ");
INSERT INTO gofe_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","ኤንታና ጪሞ ሃꬃይ ምትስ፤ ኤንቲ ሹቻዳ ጪሞን ምተትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","“አቤት ጎዳዉ፥ ነ ኡሻቻ ኩሸይ ዎልቃን ጎባ፤ ነ ኩሸይ ሞርክያ መንረꬅስ። ");
INSERT INTO gofe_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","ነ ግታ ፆኑዋን፥ ኔራ ኤቀተይሳታ ኦላዳሳ። ነ ሸነይ ታማዳ ኤፅድ፥ ኤንታ ካፍለዳ ምስ። ");
INSERT INTO gofe_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","ነ ሀንቁዋን ነ አባ ፑንን፥ ሃꬃይ ጎዳዳ ኤቅስ። አባ ጪሞት ጋርሳን ሹቻዳ ምንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","“ሞርከይ፥ ‘ታኒ ኤንታ የደꬃዳ ኦይካና፤ ታኒ ኤንታ ሻሉዋ ሻካዳ፥ ታ ኮይዳባ ኡባ ኤካና። ታኒ ታ ማሻ ሾዳዳ ኤንታ ꬋይሳና’ ያግድ ጬቀትስ። ");
INSERT INTO gofe_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","ሽን ኔኒ ኤንታ ፑንን፥ አባይ ኤንታ ምትስ። ኤንቲ አባ ጪሙዋን ብራታዳ ምተትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","አቤት ጎዳዉ፥ ፆሳታ ግዶን ነ ማል ኦኔ? ጌሻተꬃን ያሸይ ነ ማል ኦኔ? ቦንቾይ ዳጋንይነ ማላልስያባ ኦይ ነ ማል ኦኔ? ");
INSERT INTO gofe_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","ኔኒ ነ ኡሻቻ ኩሽያ ምጭዳ ዎደ፥ ቢታይ ኤንታ ምትስ። ");
INSERT INTO gofe_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","“ኔኒ ዎዝዳ አሳ ነ መርና ሲቁዋን ካለꬃዳሳ። ኔኒ ነ ዎልቃን ኤንታ ነ ጌሻ ቢታ ገልሳዳሳ። ");
INSERT INTO gofe_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","ካዎተꬃት ሄሳ ስእድ ያሻን ኮኮርዶሶና። ፍልስፄመ ቢታ አሳትካ ኡንኤትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","ሄ ዎደ ኤዶመ ቢታ ሀላቃት ዳጋምዶሶና፤ ሞአበ ቢታ ሃረይሳት ያሻን ኮኮርዶሶና፤ ካናነ አሳት ዳጋማን ዳቡርዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","ዳጋምነ ያሽ ኤንታ ኦይክስ። አቤት ጎዳዉ፥ ኤንቲ ነ ዎልቃ ግታተꬃ በእድ፥ ነ አሳይ አꬋና ጋካናዉ፥ ኔኒ ዎዝዳ አሳይ አꬋና ጋካናዉ፥ ሹቻዳ ቶለትድ ኤቅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","ኔኒ ኤንታ ኤሀዳ፥ ነ ዙማ ሁጰን ቶካና። አቤት ጎዳዉ፥ ሄ በሳይ ኔኒ ነዉ ዳናዉ ዶርዳ በሲ፥ ኔኒ ነ ኩሽያን ምንꬃዳ ኬፅዳ ነ ኬ። ");
INSERT INTO gofe_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","ጎዳይ መርና ጋካናዉ ካዎታና” ያግድ የፅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","እስራኤለት አባ ግዶራ መላ ቢታራ ፕንን፥ ግብፀ ካዉዋ ፓራት፥ እያ ፓራ ጋረትነ እያ ፓራ ቶገይሳት አባን ገልዳ ዎደ ጎዳይ ኤንታ ቦላ አባ ሃꬃ ዛርን ሃꬃይ ኤንታ ምትስ። ");
INSERT INTO gofe_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","አሮና ምችያ፥ ናብያ ማይራማ ካራቦ ኤካሱ። ሀራ ማጫሳት ኡባይ ባንታ ካራቦ ኤክድ ባቅሸነ የፅሸ እዮ ካልዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","ማይራማ፥ “እ ባ ግታ ፆኑዋን ቦንቸትዳ ግሾ፥ ፓራነ ፓራ ቶገይሳታ እ አባን የግዳ ግሾ፥ እያዉ ማዝሙርያ የፅተ” ያጋዳ ኤንታዉ የፃሱ። ");
INSERT INTO gofe_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","ሄሳፈ ጉየ፥ ሙሰይ ዞኦ አባ ማታፐ እስራኤለታ ደንꬅድ ሹራ መላ ቢታ ጋካናዉ ካለꬅስ። ሄ መላ ቢታን ኤንቲ ሄꬑ ጋላስ ሄመትዶሶና ሽን ሃ ደምቦኮና። ");
INSERT INTO gofe_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","ኤንቲ ማራ ጌተትያ በሲ ጋክድ ሃ ደምዶሶና፥ ሽን ሃꬃይ ጫሞ ግድያ ግሾ ኡያናዉ ዳንዳእቦኮና። ሄሳ ግሾ ሄ በሳይ ማራ ጌተትስ። ");
INSERT INTO gofe_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","አሳይ፥ “ኑኒ አይ ኡያኔ?” ግድ ሙሰ ቦላ ዙዙምዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","ያንን፥ ሙሰይ ጎዳኮ ዋስስ፤ ጎዳይ እያ እስ ምꬅ በስስ። ሙሰይ ሄ ምꬃ ሃꬃን የግን ሃꬃይ ማልእስ። ያን ጎዳይ ኤንታዉ ህገ እሚስ፤ ያን ጎዳይ ኤንታ ፓጭስ። ");
INSERT INTO gofe_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","ሙሰይ ኤንታኮ፥ “ህንተ ህንተ ጎዳ ፆሳስ ኪተትተ፤ እ ኮያባ ኦꬅተ። ህንተ ታዉ ፖሎ ኪተትኮነ ታ ግያባ ስእኮ ግብፀታ ቦላ ታ የድዳ ሀርግያን ህንተና ፕርድከ። ታኒ ህንተና ፓꬅያ ጎዳ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","ሄሳፈ ጉየ ኤንቲ ኤልማ ብዶሶና። ያን ታማነ ናምኡ ሃꬃ ፑልቶትነ ላፑን ታሙ ዛምባ ምꬃት ደኦሶና። ኤንቲ ያን ሃꬃ ዶናን ኡትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","ግብፀፈ ከይዳ ናምአንꬆ አጌናን፥ ታማነ እቻሻንꬆ ጋላስ እስራኤለ አሳ ኡባይ ኤልማፐ ደንድድ፥ ኤልማፐነ ሲናፐ ግዶን ደእያ ሲነ ጌተትያ መላ ቢታ ይዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","እስራኤለ አሳ ኡባይ መላ ቢታን ሙሰ ቦላነ አሮና ቦላ ዙዙምዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","እስራኤለት ኤንታኮ፥ “ኑኒ ግብፀ ቢታን ጎዳ ኩሸን ሀይቅዳ ግዶርኮሽን። ሀር አቶ ኑኒ ያን ዎꬍ ኡትድ አሹዋነ ሀራ ካꬅ ኡባ ኑ ኮይዳ መላ ሞስ። ሽን ህንተ ኑና ኡባ ከስድ ሀ መላ ቢታ ኮሻን ዎꬍሴታ” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","ጎዳይ ሙሰኮ፥ “ታኒ ህንተዉ ሳሎፐ ካꬅ ቡክሳና። አሳይ ጋላስ ጋላስ ከይድ፥ ሀችስ ግድያባ ማፃናዉ ኮሼስ። አሳይ ታው ኪተትያኮነ ኪተቶናኮ ታኒ ኤንታ ሄሳን ፓጫና። ");
INSERT INTO gofe_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","ሳምንታን ሳምንታን ኡሱፑንꬆ ጋላስ ኤንቲ ካሰ ማፀይሳስ ናምኡ ኩሸ ማፅድ ካꬆ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","ሄሳ ግሾ ሙሰይነ አሮን እስራኤለ አሳኮ፥ “ህንተና ግብፀ ቢታፈ ከስዳይ ጎዳ ግደይሳ ኦማርስ ህንተ ኤራና። ");
INSERT INTO gofe_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","ህንተ ጎዳ ቦላ ዙዙምዳይሳ እ ስእዳ ግሾ፥ ዎንታ ጎዳ ቦንቹዋ ህንተ በአና። ህንተ ኑ ቦላ ዙዙማናዉ ኑኒ ኦኔ?” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","ሄሳፈ ጉየ ሙሰይ፥ “ህንተ ጎዳ ቦላ ዙዙምዳይሳ እ ስእዳ ግሾ፥ እ ህንተዉ ኦማርስ ማናዉ አሾ እመይነ ዎንታ ማናዉ ህንተ ኮይያ መላ ኡይꬁ እመይ ጎዳ ግደይሳ ህንተ ኤራና። ህንተ ኑ ቦላ ግዶናሽን ጎዳ ቦላ ዙዙመታ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","ሙሰይ አሮናኮ፥ “ኔኒ እስራኤለ አሳ ኡባ፥ ‘ጎዳይ ህንተ ዙዙንꬃ ስእዳ ግሾ፥ ይድ ጎዳ ስንꬃን ኤቅተ’ ያጋ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","አሮን እስራኤለ አሳ ኡባስ ኦድዳ ዎደ ኤንቲ መላ ቢታ ስሚድ፥ ሻራ ግዶራ ቆንጭዳ ጎዳ ቦንቹዋ በእዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","12","ጎዳይ ሙሰኮ፥ “ታኒ እስራኤለታ ዙዙንꬃ ስአስ። ኔኒ ኤንታዉ ‘ኦማርስ አሾ ህንተ ማና፤ ዎንታ ህንተ ኮይዳ መላ ኡይꬁ ኤካና። ሄ ዎደ ህንተ ታኒ ጎዳ ህንተ ፆሳ ግደይሳ ኤራና’ ያጋዳ ኦዳ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","ሄ ጋላስ ኦማርስ ኩራቾት ይድ፥ እስራኤለ አሳይ ደእያ በሳ ማእዶሶና። ዎንታ ኤንታ ሄራን አክ ቢታ ማእስ። ");
INSERT INTO gofe_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","አካይ፥ ፅዝእዳ ዎደ ሌኦነ ላፋባይ መላ ቢታ ቦላ በንትስ። እካ ሻቻዳ ቦꬅ። ");
INSERT INTO gofe_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","እስራኤለት ሄሳ በእዳ ዎደ እያ ኤሮና ግሾ፥ እሶይ እሱዋኮ፥ “ሀይስ አይቤ?” ያግዶሶና። ያትን ሙሰይ ኤንታኮ፥ “ህንተ ማና መላ ጎዳይ እምዳ ካꬃይ ሀይሳ። ");
INSERT INTO gofe_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","ጎዳይ፥ ‘አሳይ እሶይ እሶይ ባዉ ኮሸይሳ መላ ሺሾ፤ ሶን ደእያ እስ እስ አስ ባ ሁጰን ናምኡ ልትሮ ኤኮ’ ያጋ” ያግድ ኪትስ። ");
INSERT INTO gofe_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","እስራኤለት ኪተትዳይሳዳ ኦꬅዶሶና፤ ባጋይ ዳርስድ፥ ባጋይ ጉꬅድ ሺሽዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","ኤንቲ ሺሽድ ልትሮን ማክያ ዎደ ዳርስ ሺሽዳይሳስ ፓላህቤና፤ ጉꬁ ሺሽዳይሳስካ ፓጭቤና። እሶይ እሶይ ባዉ ኮሸይሳ መላ ሺሽስ። ");
INSERT INTO gofe_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","ሙሰይ ኤንታኮ፥ “ኦንካ እያፐ ዎንታስ አሾፎ” ያግድ ኪትስ። ");
INSERT INTO gofe_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","ሽን ኤንታፈ እሶት እሶት ሙሰይ ኦድዳይሳ ስኦና እፅድ ዎንታስ ምንጅዶሶና። ኤንቲ ምንጅዳይስ ጉፁንትድ ፅንቅስ። ሄሳ ግሾ ሙሰይ ኤንታ ቦላ ሀንቀትስ። ");
INSERT INTO gofe_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","ዎንታ ዎንታ አሳ ኡባይ ባንታዉ ኮሸይሳ መላ ሺሼስ። አዋይ ምችያ ዎደ ሳአን አትዳይስ ትልኤስ። ");
INSERT INTO gofe_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","ኡሱፑንꬆ ጋላስ ኤንቲ ካሰ ሺሽያ ናምኡ ልትሩዋ ቦላ እያ መላ ጉጅድ እስ እስ አሳስ ኦይዱ ልትሮ ሺሾ። ያትን እስራኤለ ሀላቃት ብድ ሄሳ ሙሰስ ኦድዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","ሙሰይ ዛሪድ፥ “ዎንቶይ ሸምፖ ጋላስ ግድድ ጎዳ ቦንችያ ጌሻ ሳምባታ። ሄሳ ግሾ፥ ህንተ ኡክያባ ኡክተ፤ ዶይስያባ ዶይስተ። ዎንቶስ ዎꬅተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","ኤንቲ ሙሰይ ኪትዳይሳዳ ዎንቶስ ዎꬅን፥ ፅንቅቤና ዎይኮ ጉፁንትቤና። ");
INSERT INTO gofe_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","ሙሰይ ኤንታኮ፥ “ሀይሳ ሀች ሚተ፤ ሀች ጎዳ ቦንችያ ሸምፖ ሳምባታ ግድያ ግሾ፥ ህንተ ሀች ደንባን ደመከታ። ");
INSERT INTO gofe_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","ህንተ ካꬃ ኡሱፑን ጋላሳታን ሺሻናዉ ዳንዳኤታ፥ ሽን ላፑንꬃ ጋላሳይ ሸምፖ ጋላስ ግድያ ግሾ አይብ ካꬅካ ሄ ዎደ ዴና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","ላፑንꬃ ጋላሳን እስ እስ አሳይ ሺሻናዉ ከይዶሶና፥ ሽን አይኮካ ደምቦኮና። ");
INSERT INTO gofe_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","ያትን፥ ጎዳይ ሙሰኮ፥ “ታ ኪታነ ታ ህግያ ህንተ ናጎና እፀይ አዉደ ጋካናሴ? ");
INSERT INTO gofe_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","ታኒ ህንተዉ ሳምባታ እምዳይሳ አኬክተ። ኡሱፑንꬆ ጋላሳን እ ህንተዉ ናምኡ ጋላሳ ካꬅ እመይ ሄሳ ግሾሳ። ላፑንꬃ ጋላሳን ኦንካ ካረ ከዮና ባ ሶን ባ ሶን ጋምኦ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","ሄሳ ግሾ፥ አሳይ ላፑንꬃ ጋላሳን ሸምፕስ። ");
INSERT INTO gofe_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","እስራኤለ አሳይ ሄ ካꬃ ማና ግድ ፄግዶሶና። ማናይ ዴቦ አይፈ መላ ግድድ ቦꬅ። እ ኤሳራ ኡክዳ ኡይꬃዳ ማልኤስ። ");
INSERT INTO gofe_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","“ታኒ ህንተና ግብፀ ቢታፈ ከስዳ ዎደ መላ ቢታን ሙዝዳይ ማና ግደይሳ ያና የለተꬃይ በአና መላ እያፐ ናምኡ ክሎ ግራመ ዎꬅተ” ያግድ ጎዳይ ኪትዳይሳ ሙሰይ እስራኤለ አሳስ ኦድስ። ");
INSERT INTO gofe_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","ሙሰይ አሮናኮ፥ “ናምኡ ክሎ ግራመ ማና ኤካዳ ፃሮን ቆላዳ ያና የለተꬃስ ጎዳይ ጎይነትያ በሳን ዎꬃ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","ጎዳይ ሙሰ ኪትዳይሳዳ፥ አሮን ማና ጎዳ ስንꬃን ታቦትያ ግዶን ዎꬅስ። ");
INSERT INTO gofe_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","እስራኤለት ባንታ ደእያ ካናነ ቢታ ዛዋ ይድ ጋካናዉ ኦይታሙ ላይꬅ ማና ምዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","ሄ ዎደ አሳይ ማክያ ሚሸይ ላታማነ ናምኡ ልትሮ ኦይኬስ። ");
INSERT INTO gofe_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","እስራኤለ አሳ ኡባይ ጎዳይ ኪትዳይሳዳ እስ በሳፈ ሀራ በሲ ዩይሸ፥ ሲን መላ ቢታፈ ደንድድ ራፍድማ ጌተትያ በሳን ኡትዶሶና። ሽን ኤንቲ ኡያናዉ ሃꬅ ሄ በሳን ꬋይስ። ");
INSERT INTO gofe_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","ኤንቲ፥ “ኑስ ኡያናዉ ሃ እማ” ያግድ ሙሰራ ካጨትዶሶና። ሙሰይ ዛሪድ፥ “ህንተ ታራ አይስ ካጨቴቲ? ጎዳ አይስ ፓጨቲ?” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","ሽን አሳይ ያን ሃꬃ ሳሞትድ፥ “ኔኒ ኑና፥ ኑ ናይታነ ኑ መህያ ሳሞን ዎꬋናዉ ግብፀፈ ከሳዳ ሀይሳ አይስ ኤሀዲ?” ያግድ ሙሰ ቦላ ዛር ዛር ዙዙምዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","ያትን ሙሰይ፥ “ታኒ ሀ አሳ ዋቶ? ኤንቲ ታና ሹቻን ጫዳና ሀኖሶና” ያግድ ጎዳ ዎስስ። ");
INSERT INTO gofe_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","ጎዳይ ሙሰኮ፥ “ኔኒ እስራኤለ አሳፐ ጭማታ ኔራ ኤካዳ አሳፐ ስን አꬋዳ ሄመታ። ቃስ ናይለ ሻፋ ሾጭዳ ፃምኣ ነ ኩሸን ኦይካዳ ባ። ");
INSERT INTO gofe_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","ታኒ ኮሬባ ዙማን ዛላ ቦላ ነ ስንꬃን ኤቃና። ሄ ዛላ ሾጫ፤ አሳይ ኡያና ሃꬃይ እያፐ ከያና” ያግስ። ሙሰይ እስራኤለ ጭማታ ስንꬃን ሄሳ ኦꬅስ። ");
INSERT INTO gofe_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","እስራኤለት፥ “ቱማ ጎዳይ ኑራ ደኢ?” ያግድ ዙዙምዳ ግሾነ ጎዳ ፓጭዳ ግሾ ሄ በሳ ማሳሀነ ማርባ ግድ ሱንꬅስ። ");
INSERT INTO gofe_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","አማለቃት ይድ ራፍድማን እስራኤለታ ኦልዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","ሙሰ እያሱኮ፥ “ኔኒ ዎንቶ አማለቃታ ኦላናዉ ጉꬃ አስ ዶራ። ታኒ ፆሳ ፃምኣ ኦይካዳ ዙማ ሁጰን ኤቃና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","ሙሰይ ኪትዳይሳዳ እያሱይ አማለቃታ ኦልስ። ሙሰይ፥ አሮንነ ሆር ዙማ ሁጰ ከይዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","ሙሰይ ባ ኩሽያ ደንꬅድ ጋምእያ ዎደ እስራኤለት ፆኖሶና፥ ሽን እ ባ ኩሽያ ዎꬅያ ዎደ አማለቃት ፆኖሶና። ");
INSERT INTO gofe_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","ሙሰ ኩሸይ አርጋጭዳ ዎደ አሮናራነ ሁራራ ሹች ኤህድ ሙሰ እያ ቦላ ኡትስዶሶና። አሮንነ ሁር ኡሻቻራነ ሀድርሳራ ኤቅድ አዋይ ዉላና ጋካናዉ እያ ኩሽያ ካትስ ኦይክዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","ሄሳዳ ኦꬅድ እያሱይ አማለቃታ ማሻን ኦልድ ꬋይስስ። ");
INSERT INTO gofe_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","ሄሳፈ ጉየ ጎዳይ ሙሰኮ፥ “ሀይስ ኡባ ዎደ ሀሳየታና መላ ሀ ፆኑዋ ታርክያ ፃፋ። ታኒ አማለቃታ ቡርፆራ ꬋይሳናይሳነ ኤንቲ ዶገታናይሳ እያሱስ ኦዳ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","ሙሰይ ያርሾ በሲ ጊግስድ፥ “ጎዳይ ታ ፆኑዋ ባንድራ” ግድ ሱንꬅስ። ");
INSERT INTO gofe_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","እ፥ “ጎዳ ፆኖ ባንድራ ꬎቁ ኦꬅድ ኦይክተ። ጎዳይ አማለቃታ መርናዉ ኦላና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","ምድያመ ቢታ ካህነይ፥ ሙሰ ቦሎይ ዮቶር፥ ጎዳይ ሙሰስነ ባ አሳ እስራኤለታስ ኦꬅዳባነ ኤንታና ግብፀፈ ከስዳባ ስእስ። ");
INSERT INTO gofe_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","ሄ ዎደ ሙሰ ቦሎይ ዮቶር፥ እያ ማታን ሙሰይ አግድ ብዳ እያ ማችዉ ስፖሮነ፥ ");
INSERT INTO gofe_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","እ ናምኡ ናይታ ኤክድ ይስ። ሙሰይ፥ “ታኒ አላጋ ቢታን በተ አስ ግዳስ” ግድ ባይራ ናኣ ገርሳማ ግድ ሱንꬅስ። ");
INSERT INTO gofe_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","ካሉዋ ቃስ፥ “ታ አዋ ፆሳይ፥ ታና ግብፀ ካዉዋ ማሻፈ አሽስ” ግድ አላዛራ ግድ ሱንꬅስ። ");
INSERT INTO gofe_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","ሙሰ ቦሎይ ዮቶር፥ እያ ማችዉነ እ አደ ናይታ ባራ ኤክድ፥ መላ ቢታን፥ ፆሳ ዙማ ማታን ደእያ ሙሰኮ ይስ። ");
INSERT INTO gofe_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","እ ባንታ ዩሳ ኤርሳናዉ ሙሰኮ ኪትስ። ");
INSERT INTO gofe_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","ሄሳ ግሾ፥ ሙሰይ ባ ቦሉዋ ሞካናዉ ከይድ፥ እያ ዝግ ሳሮꬅድ እያ ዬርስ። ኤንቲ እሶይ እሱዋ ሳሮꬅ ስሚድ ሙሰ ዱንካንያ ግዶ ገልዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","ጎዳይ እስራኤለታ አሻናዉ ግብፀ አሳ ቦላነ ኤንታ ካዉዋ ቦላ ኦꬅዳባ ኡባነ ኦገን ኤንታ ጋክዳ መቱዋ ኡባን ጎዳይ ዋት ማድዳኮ ሙሰይ ባ ቦሉዋስ ኦድስ። ");
INSERT INTO gofe_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","ዮቶር ጎዳይ እስራኤለ አሳ ግብፀታ ኩሸፐ አሻናዉ ኦꬅዳ ሎኦ ኦሶታባ ስእድ ኡፋይትስ። ");
INSERT INTO gofe_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","እ፥ “ህንተና ግብፀታፐ ኤንታ ካዉዋ ኩሽያፐ አሽድ፥ ግብፀ አይለተꬃፈ ከስዳ ጎዳይ፥ እ ጋላተቶ። ");
INSERT INTO gofe_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","ኦቶሮን ኤንታ ቦላ ኢታባ ኦꬅዳ ግብፀታፐ እስራኤለታ አሻናዉ ሄሳ ኦꬅዳ ግሾ፥ ጎዳይ ፆሳታ ኡባፈ ግታ ግደይሳ ታኒ ሀእ ኤራስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","ሄሳፈ ጉየ ዮቶር፥ ሙሰ ቦሎይ፥ ፁሳ ያርሾነ ሀራ ያርሾ ፆሳስ ያርሽስ። አሮንነ እስራኤለ ጭማት ኡባይ ፆሳ ስንꬃን እያራ ጌሻ ካꬃ ማናዉ ይዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","ዎንተꬃ ጋላስ ሙሰይ አሳስ ፕርዳናዉ ኡትስ። አሳይ ሙሰ ዩሹዋን ዎንታፈ ኦማርስ ጋካናዉ ኤቅድ ደኤስ። ");
INSERT INTO gofe_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","ሙሰ ቦሎይ ሙሰይ አሳስ ኦይሳ ኡባ በእድ፥ “ኔኒ ነ ፃላላ ሀይሳ አይስ ኦꬃይ? አሳይ ዎንታፈ ኦማርስ ጋካናዉ ነ ዩሹዋን ኤሳዳ አይስ ነርካ ኦꬃይ?” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","ሙሰይ ባ ቦሉዋኮ፥ “አሳይ ፆሳ ሸንያ ኦይቻናዉ ኮይድ ታኮ ይያ ግሾሳ። ");
INSERT INTO gofe_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","ኤንታ ግዶን ኦድ ደእኮ ታኮ ዮሶና። ታ ኤንታ ግዶን ባልነ ቱም ኦነኮ ሻካይስ፤ ፆሳ ኪታነ ህግያ ኤንታዉ ኦዳይስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","ሙሰ ቦሎይ፥ “ሀይስ ነ ኦይስ ሎኦ ግደና። ");
INSERT INTO gofe_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","ነካ ኔኮ ይያ አሳ ኡባይ ዳቡረታ። ሀ ኦሶይ እስ አሳፐ ዳሮ ግድያ ግሾ፥ ኔኒ ነርካ ኦꬃናዉ ዳንዳአካ። ");
INSERT INTO gofe_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","ሀእ ታኒ ነና ዞረይሳ ስአ፤ ፆሳይ ኔራ ግዳና። ኔኒ ሀ አሳ በሳን ግዳዳ ኤንታባ ፆሳስ ኦዳ። ");
INSERT INTO gofe_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","ፆሳ ኪታነ ህግያ ኤንታ ታማርሳ። ኤንቲ ዋን ዳነኮነ አይ ኦꬃነኮ ኤንታ በሳ። ");
INSERT INTO gofe_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","ቃስ አሳ ግዶን ኦዳ ሻክድ ኤርያ አሳታ፥ ፆሳ ያየይሳታ፥ አማንይሳታነ ዎꬋፈ ኤኮናይሳት ዶራ። ኤንታና አሳ ቦላ ሻላቃታ፥ ማቶ ሀላቃታ፥ ሀምሳላቃታነ አስራላቃታ ኦꬃዳ ሹማ። ");
INSERT INTO gofe_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","ኤንቲ ኡባ ዎደ ካዉሻ ኦዳታ ባንታዉ ፕርዶ፥ ሽን ዴፆ ኦዳታ ኔኮ ኤሆ። ሄሳዳ ነ ኦꬅኮ ቶሆይ ነዉ ካዉያና። ");
INSERT INTO gofe_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","ነ ኦꬃና መላ ፆሲ ኮየይ ሄሳ። ቃስ ነ ዳቡራካ ሀ አሳ ኡባይ ባ አላለይ ፖለትን ባ ሶ ባ ሶ ስማና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","ሙሰይ ዮቶራ ዞርያ ስእስ፤ እ ግዳባ ኡባ ኦꬅስ። ");
INSERT INTO gofe_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","ሙሰይ እስራኤለታ ግዶፈ ኦዳ ሻክ ኤርያ አሳታ ዶርስ። ኤንታና አሳ ቦላ ሻላቃታ፥ ማቶ ሀላቃታ፥ ሀምሳላቃታነ አስራላቃታ ኦꬅድ ሹምስ። ");
INSERT INTO gofe_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","ሹማት ካዉሻ ኦዳታ ባንታዉ ፕርድዶሶና፥ ሽን ዴፆ ኦዳታ ሙሰኮ ኤሆሶና። ");
INSERT INTO gofe_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","ሄሳፈ ጉየ ሙሰይ ባ ቦሉዋ ሞይዝን፥ እ ባ ቢታ ስምስ። ");
INSERT INTO gofe_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","እስራኤለ አሳይ ግብፀፈ ከይዳ ሄꬓንꬆ አጌናስ ኮይሮ ጋላሳን ሲና መላ ቢታ ጋክዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","ኤንቲ ራፍድማፐ ደንድድ ብድ፥ ሲና ዙማ ስንꬃን ደእያ መላ ቢታን ኡትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","ሙሰይ ፆሳራ ጋሄታናዉ ዙማ ቦላ ከይስ። ጎዳይ ዙማ ሁጰፐ እያ ፄግድ፥ “ያይቆባ ሼሽ ግድዳ እስራኤለታስ ሀይሳዳ ያጋ፤ ");
INSERT INTO gofe_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘ታኒ ግብፀታ ቦላ ኦꬅዳባነ አርጋንꬅ ባ ናአ ባ ቀፍያን ቶከይስዳ ታ ህንተና ዋታ ቶካዳ ታኮ ኤህዳኮ ህንተ ህንተ ሁጰን በእደታ። ");
INSERT INTO gofe_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","ሀእ ህንተ ታዉ ኪተትኮነ ታ ጫቁዋ ናግኮ፥ ቢታ ኩመꬃይ ታባ ግድኮካ ህንተ ታዉ ዶረትዳ ደረ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","ህንተ ታዉ ጌሻ ደረ ግዳና፤ ህንተ ካዎተꬃን ካህነ ግድድ ታና ሀጋዛና።’ ኔኒ እስራኤለታስ ኦዳና ቃላይ ሀይሳ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","ሙሰይ ጉየ ብድ፥ ዙማኮ ጭማታ ፄግ ሺሽድ፥ ጎዳይ ኦድዳ ቃላ ኡባ ኤንታዉ ኦድስ። ");
INSERT INTO gofe_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","ኤንቲ፥ “ጎዳይ ግዳባ ኡባ ኑኒ ኦꬃና” ያግዶሶና። ሙሰይ ኤንቲ ግዳይሳ ጎዳስ ኦድስ። ");
INSERT INTO gofe_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","ጎዳይ ሙሰኮ “ታኒ ኔራ ሃሳይሽን አሳይ ስአናዳነ ኤንቲ ነና ኡባ ዎደ አማናናዳ ታኒ ሙምዳ ሻራራ ኔኮ ያና” ያግስ። ሄሳፈ ጉየ ሙሰይ አሳይ ግዳይሳ ጎዳስ ኦድስ። ");
INSERT INTO gofe_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","ጎዳይ ሙሰኮ “ኔኒ አሳኮ ባዳ ሀችነ ዎንቶ ታራ ጋሄታናዉ ባንታና ጌሻና መላ ኤንታዉ ኦዳ። ኤንቲ ባንታ ማኡዋ ሜጭድ፥ ");
INSERT INTO gofe_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","ሄꬓንꬆ ጋላሳስ ጊገቶ። ሄ ጋላስ አሳ ኡባይ ታና በእሽን ታኒ ሲና ዙማ ቦላ ዎꬋና። ");
INSERT INTO gofe_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","ኔኒ ሀ ዙማ ዩሹዋን ዛዋ ዎꬃ። አሳይ ዙማ ከዮና ቦላ መላ ዎይኮ ዙማ ፃጱዋ ቦቾና መላ ኤንታዉ ኦዳ። ዙማ ቦችዳ ኦንካ ሀይቃና። ");
INSERT INTO gofe_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","ሄ ኡራይ ሹቻን ጫደትድ ዎይኮ ዶንገን ዱከትድ ሀይቆ፤ እያ ኩሸን ኦንካ ቦቾፎ። መሄይ ዎይኮ አስ ሄሳዳ ሀይቆ። ሞይዘይ ፑነትያ ዎደ ኤንቲ ዙማ ቦላ ከያናዉ ዳንዳኦሶና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","ሙሰይ ዙማ ቦላፈ ዎꬍድ፥ አሳይ ፆሳ ጎይናናዉ ባንታና ጊግሳና መላ ኦድስ። ኤንትካ ባንታ ማኡዋ ሜጭዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","ሙሰይ አሳኮ፥ “ሄꬓንꬆ ጋላሳስ ጊገትተ፤ ህንተ ማቸታራ አቆፕተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","ሄꬓንꬆ ጋላስ ዎንታ ጉራ ደሾይ ደችስ። ዎልአንꬅነ ሳካና ሻር ዙማ ማእድ በንትስ። ዎልቃማ ሞይዘ ዋሶይ ስኤትስ። አሳይ ዱንካንዳ በሳ ኡባን ያሻን ኮኮርዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","ሄሳፈ ጉየ፥ ሙሰይ አሳ ፆሳራ ጋꬃናዉ ኤንታና ዱንካንያፐ ከስድ ኤፍስ፤ ኤንቲ ዙማ ፃጶን ኤቅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","ጎዳይ ሲና ዙማ ቦላ ታማ ላጮራ ዎꬍዳ ግሾ ሲና ደረይ ጩያን ካመትስ። ግታ ጮጨፐ ጩይ ከየይሳዳ እያፐ ጩይያ ዙለይ ሱረ ከይስ። አሳ ኡባይ ዳሮ ኮኮርዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","ሞይዝያ ዋሶይ ዳር ዳር ብዳ ዎደ ሙሰይ ኦድን፥ ፆሳይ ደሾን እያዉ ዛርስ። ");
INSERT INTO gofe_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","ጎዳይ ሲና ዙማ ሁጰ ቦላ ዎꬍድ፥ ሙሰ ፑደ ዙማ ቦላ ፄግስ። ሙሰይ ዙማ ቦላ ከይስ። ");
INSERT INTO gofe_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","ጎዳይ እያኮ፥ “ኔኒ ዱገ ባዳ አሳይ ታና በአና ግድ፥ ዛዋ አꬎና መላነ ኤንታፈ ዳሮይ ሀይቆና መላ ኤንታዉ ኦዳ። ");
INSERT INTO gofe_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","ሀር አቶ ጎዳ ማት ሺቅያ ካህነትካ ባንታና ጌሾ። ኤንቲ ሄሳ ኦꬆና እꬅኮ ታ ኤንታ ሀንቃና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","ሙሰይ ጎዳኮ፥ “ኔኒ ዙማ ዱማይዳ ግሾነ ዛዋ እምዳ ግሾ አሳይ ዙማ ሁጰ ከያናዉ ዳንዳኦኮና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","ጎዳይ እያኮ፥ “ኔኒ ዱገ ባዳ አሮና ኔራ ኤካዳ ያ። ካህነትነ አሳይ ዛዋ ካንꬅድ ታኮ ይሸ ꬋዮና መላ ኤንታዉ ኦዳ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","ሄሳ ግሾ ሙሰይ አሳኮ ዎꬍድ ጎዳይ ግዳይሳ ኤንታዉ ኦድስ። ");
INSERT INTO gofe_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","ፆሳይ እስራኤለ አሳኮ ሀይሳዳ ያግስ፤ ");
INSERT INTO gofe_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“ነና ግብፀፈ አይለተꬃፈ ከስዳ ጎዳይ ነ ፆሳይ ታና። ");
INSERT INTO gofe_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“ታፐ አትሽን፥ ሀራ ፆሰ ጎይኖፋ። ");
INSERT INTO gofe_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“ቦላ ሳሉዋን ደእያባ፥ ዎይኮ ጋርሳ ሳአን ደእያባ፥ ዎይኮ ሳአፐ ጋርሳን ሃꬃ ግዶን ደእያባ አይባካ ነዉ ጎይንያ ኤቃ ዳንሳዳ ኦꬆፋ። ");
INSERT INTO gofe_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","ኤንታዉ ሆኮፋ ዎይኮ ኤንታ ጎይኖፋ። አይስ ጊኮ፥ ታኒ፥ ጎዳይ ነ ፆሳይ፥ ታ ቦንቹዋ ሀራ ፆሳታራ ኮፆና ፆሰ። ታና እፅያ አዋታ ናጋራ ግሾ ናይታ ሄꬓንꬆ ዎይኮ ኦይዳንꬆ የለተꬅ ጋካናዉ ሀንቃና። ");
INSERT INTO gofe_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","ሽን ታና ሲቀይሳታነ ታ ኪታ ናገይሳታ ሼሻ ሙኩሉ የለተꬅ ጋካናዉ ኬሀና። ");
INSERT INTO gofe_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“ፆሳ ነ ጎዳ ሱንꬃ ሀዳን ደንꬆፋ። ጎዳይ ባ ሱንꬃ ሀዳን ደንይሳታ ሴሮና አገና። ");
INSERT INTO gofe_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“ሳምባታ ጌሻ ጋላስ ኦꬃዳ ናጋ። ");
INSERT INTO gofe_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","ኔኒ ኦሶ ኦꬃናዉ በሲያ ኡሱፑን ጋላሳት ደኦሶና። ");
INSERT INTO gofe_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","ሽን ላፑንꬃ ጋላሳይ ኔኒ ጎዳ ቦንችያ ሸምፖ ጋላስ። ሄ ጋላሳን አይባ ኦሶካ ኦꬆፋ። ኔኒ፥ ዎይኮ ነ ናይት፥ ዎይኮ ነ አይለት፥ ዎይኮ ነ መሄይ፥ ዎይኮ ነ ቢታን ደእያ አሳ ጋደ አሳት ሄ ጋላሳን ኦሶ ኦꬆፍተ። ");
INSERT INTO gofe_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","ኡሱፑን ጋላሳ ግዶን ጎዳይ ሳሎታ፥ ሳኣ፥ አባነ ኤንታ ግዶን ደእያ ኡባ መꬍስ፥ ሽን ላፑንꬃ ጋላሳን ሸምፕስ። ሄሳ ግሾ ጎዳይ ሳምባታ ጋላሳ አንጅስነ ዱማይስ። ");
INSERT INTO gofe_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“ጎዳይ ነ ፆሳይ ነዉ እምያ ቢታን ነ ላይꬃይ አዱቃና መላ ነ አዋነ ነ አይዉ ቦንቻ። ");
INSERT INTO gofe_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“አሳ ዎꬎፓ። ");
INSERT INTO gofe_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“ላሞፋ። ");
INSERT INTO gofe_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“ካይሶቶፓ። ");
INSERT INTO gofe_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“ነ ላግያ ቦላ ዎርዶ ማርካቶፋ። ");
INSERT INTO gofe_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“ነ ላግያ ኬꬃ አሞቶፋ። ነ ላግያ ማችዉ፥ ዎይኮ እያ አይለታ፥ ዎይኮ እያ መህያ፥ ዎይኮ እያ ሀርያ፥ ዎይኮ እያዉ ደእያባ አይባካ አሞቶፋ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","አሳ ኡባይ ደሾይ ደቸይሳነ ሞይዘይ ፑነተይሳ ስእድ፥ ዎልአንꬃይ ዎልአመይሳነ ደረይ ጩየይሳ በእድ ያሻን ኮኮርሸ ሃሆን ኤቅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","ኤንቲ ሙሰኮ፥ “ኔኒ ኑስ ኦዳ፤ ኑኒ ስአና። ሽን ኑኒ ሀይቆና መላ ፆሳይ ኑስ ኦዶፖ” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","ሙሰይ አሳኮ፥ “ያዮፍተ፤ ፆሳይ ህንተና ፓጫናዉነ ህንተ እያዉ ኪተትድ ናጋራ ኦꬆና መላ እ ይስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","አሳይ ባንታ ደእያሱዋን ሃክድ ኤቅዳሽን፥ ፆሳይ ደእያሱዋ ሙምዳ ሻራኮ ሙሰይ ሺቅስ። ");
INSERT INTO gofe_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","ሄሳፈ ጉየ፥ ጎዳይ ሙሰኮ “እስራኤለ አሳስ ሀይሳዳ ያጋዳ ኦዳ፤ ‘ሳሎፐ ታኒ ህንተዉ ኦድሽን ህንተ ታና ህንተ ሁጰን በእደታ። ");
INSERT INTO gofe_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","ያንያ ግሾ፥ ብራ ኤቃ ዎይኮ ዎርቃ ኤቃ ህንተዉ ኦꬅድ ታ ቦላ ጉጅድ ጎይኖፍተ። ");
INSERT INTO gofe_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","ነን ታዉ ያርሾ በሲ ኡርቃፈ ጊግሳ። ነ ዶርሳታፐነ ነ ቦራታፐ ኤካዳ ፁሳ ያርሾነ እስፈተꬃ ያርሾ እያ ቦላ ያርሻ። ህንተ ታና ጎይናና መላ ታኒ ዶርዳ በሳ ኡባን ህንተኮ ያዳ ህንተና አንጃና። ");
INSERT INTO gofe_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","ህንተ ታዉ ያርሾ በሲ ሹቻፈ ኬፅያባ ግድኮ ማሰትዳ ሹቻፈ ኬፆፋ። ኔኒ ማስያ ሚሸን እያ ቦችኮ ቱንሳሳ። ");
INSERT INTO gofe_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","ህንተ ከይሸ ካሎቶና መላ ታዉ ያርሾ በሲ ኮዶራ ከይያ በሳን ኬፆፋ’ ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","ጎዳይ ሙሰ ባጋራ ባ ደርያስ እምዳ ዎጋይ ሀይሳ፤ ");
INSERT INTO gofe_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“ነ እብራወ አይለ ሻምኮ፥ እ ነዉ ኡሱፑን ላይꬅ ኦꬆ፥ ሽን ላፑንꬃ ላይꬃን አይኮካ ቃንፆና፥ አይለተꬃፈ ጮ የደቶ። ");
INSERT INTO gofe_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","እ ማቾ ኤኮና ሻመትዳባ ግድኮ፥ ባርካ የደቶ። እ ማችድ፥ ሻመትዳባ ግድኮ፥ እያ ማችያካ እያራ የደቶ። ");
INSERT INTO gofe_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","እያ ጎዳይ እያዉ ማቾ እምዳባ ግድኮነ ማችያ እያዉ አደ ናይታ ዎይኮ ማጫ ናይታ የልዳባ ግድኮ፥ እያ ማችያነ እ ናይት እያ ጎዳባ ግዶ፤ አደይ ባርካ የደቶ። ");
INSERT INTO gofe_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","ሽን አይለይ፥ ‘ታኒ ታ ጎዳ፥ ታ ማችዉነ ታ ናይታ ዶሳይስ’ ግድ አይለተꬃፈ ከያናዉ ኮዮና እፅኮ፥ ");
INSERT INTO gofe_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","እያ ጎዳይ፥ ጎዳ ስን እያ አꬆ። ያትድ፥ ፐንገ ዎይኮ ፐንገ ዝዝግያ ማታን እያ ኤስድ፥ እያ ሀይꬃ ጎꬃን ሉኮ። ሄሳፈ ጉየ፥ እ ባ ደኦ ላይꬃ ኡባን እያዉ አይለ ግዶ። ");
INSERT INTO gofe_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“እስ አስ ባ ማጫ ናእዉ አይለተꬃስ ባይዝኮ፥ አደ አይለታꬆ አይለተꬃፈ ከዮፖ። ");
INSERT INTO gofe_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","እዮ ሻምድ ማቻናዉ ኤፍዳ ጎዳይ እዮ ዶሶና እፅኮ፥ እ ጎዳይ እዮ ደርያን ዎዝሶ። እ ጎዳይ እ ቦላ ኢታባ ኦꬅዳ ግሾ፥ እዮ አላጋስ ባይዛናዉ ዳንዳኤና። ");
INSERT INTO gofe_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","እ እዮ ባ ናኣስ እማናዉ ኮይኮ፥ ባ ማጫ ናአꬆ ኦꬅድ ኤኮ። ");
INSERT INTO gofe_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","እ ሀራ ማቾ እ ቦላ ኤክኮ፥ ኮይሮ ማቼስ ካꬅ፥ ማኦነ እንዳስ በሲያ ዎጋ እዉ ፓጭሶፖ። ");
INSERT INTO gofe_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","እ ሀ ሄꬑባታ እዉ ኦꬆና እፅኮ፥ አይብ ሚሸካ ቃንፆና አይለተꬃፈ ከያዳ ቦ።” ");
INSERT INTO gofe_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“አሰ ሾጭድ ዎꬍያ ኦንካ ሀይቃናዉ በሴስ። ");
INSERT INTO gofe_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","እ ዎꬋናዉ ቆፖና እያፐ ሀይቅያባ ግድኮ፥ እ ባቃትድ አታና በሲ ታኒ እያዉ ጊግሳና። ");
INSERT INTO gofe_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","ሽን አስ ቆፕድ ሀራ አስ ዎꬍኮ፥ ሄ ኡራይ ታ ያርሾ በሲ ቢኮ ያፐ ድጋዳ ሀራ በሳን ዎꬋ። ");
INSERT INTO gofe_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“ባ አዋ ዎይኮ ባ አይዉ ደችያ ኦንካ ሀይቆ። ");
INSERT INTO gofe_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“አሰ ባይዛናዉ ዎይኮ ሃራናዉ ዎልቃን ኦይክያ አስ ሀይቃናዉ በሴስ። ");
INSERT INTO gofe_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“ባ አዋ ዎይኮ ባ አይዉ ጫየይ ሀይቆ። ");
INSERT INTO gofe_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“ናምኡ አሳት ኦየትድ፥ እሶይ እሱዋ ሹቻን ጫድድ ቆእኮ፥ ዎይኮ ዡልትኮ፥ ሄ ደሸትዳይስ ሀይቆና አትድ ሀርግድ ሂፃን ፔእኮ፥ ");
INSERT INTO gofe_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","ደንድድ ጉፈትድ ካረ ሄራን ሄመትኮ፥ ሄ ደችዳይስ ሀይቆፐ አቴስ። ግድኮካ እ እያ ኦሶፐ አሽዳ ግሾ፥ አጫናዉነ ፓፃና ጋካናዉ ሀርግሳናዉ ኮሼስ። ");
INSERT INTO gofe_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“እስ አስ ባ አደ አይልያ ዎይኮ ማጫ አይልዉ ፃምአን ሾጭድ ዎꬍኮ ሴረታናዉ በሴስ። ");
INSERT INTO gofe_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","ሽን ሄ አይለይ እስ ዎይኮ ናምኡ ጋላሳ ግዶን ሀይቆና እፅኮ፥ እያ ጎዳይ ሴረቶፎ። ሄ አይለይ እያ ሻሎ ግድያ ግሾ እያ ሀይቆይ ባዉ ሴራ። ");
INSERT INTO gofe_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“ናምኡ አሳት እሶይ እሱዋራ ዋትድ ቃንፃትዳ ማጫስዉ ደችድ፥ እያ ቦሸታና መላ ኦꬅኮ፥ ሀራ ኢታ ቆሆ ጋꬆና እፅኮ፥ ሄ ደችዳ ኡራይ፥ ሄ ማቸ አዝናይ ኦይችያ አጫ ዳይናት ፕርድኮ ጭጎ። ");
INSERT INTO gofe_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","ሽን ሄ ማጫሰ ደሸꬃይ ዳርኮ፥ ሸምፖ ግሾ ሸምፖ፥ ");
INSERT INTO gofe_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","አይፈ ግሾ አይፈ፥ አቻ ግሾ አቸ፥ ኩሸ ግሾ ኩሸ፥ ቶሆ ግሾ ቶሆ፥ ");
INSERT INTO gofe_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","ፁሳ ግሾ ፁስ፥ ማዱንꬃ ግሾ ማዱንꬅ፥ ቆኦ ግሾ ቆኦ ኤካናዉ ኮሼስ። ");
INSERT INTO gofe_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“እስ አስ ባ አደ አይልያስ ዎይኮ ማጫ አይሌስ አይፈ ባቅድ ቶይስኮ፥ ሄ አይፍያ ግሾ አይለተꬃፈ ከስ የዶ። ");
INSERT INTO gofe_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","ሄሳዳካ፥ ባ አይልያ አቸ ዎይኮ ባ አይለ አቸ መንꬅኮ፥ ሄ አቻ ግሾ አይለተꬃፈ ከስ የዶ። ");
INSERT INTO gofe_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“ቦር አሰ ቃይጭድ ዎꬍኮ፥ ሄ ቦራይ ሹቻን ጫደት ሀይቆ። እያ አሾይ ሜተቶፎ፥ ሽን ቦራ ጎዳይ ሴረቶፎ። ");
INSERT INTO gofe_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","ሽን ቦራይ ካሰካ ቃይጭያባ ግድኮነ ኮይሮትድ ቦራ ጎዳስ ኦደትን፥ እ ቃቾና እፅዳባ ግድኮ፥ ሄ ቦራይ አሰ ዎꬍኮ፥ ቦራይነ ቦራ ጎዳይ እስፈ ሹቻን ጫደትድ ሀይቆ። ");
INSERT INTO gofe_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","ሽን ቦራ ጎዳይ አጫ ቃንፃና መላ ኦይሸትኮ፥ ኤንቲ ኦይችዳባ ቃንፅድ ባ ሸምፑዋ ዎዞ። ");
INSERT INTO gofe_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","ቦራይ አደ ናአ ዎይኮ ማጫ ናአ ቃይጭድ ዎꬍኮ ፕርዳይ እያ መላ ግዶ። ");
INSERT INTO gofe_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","ቦራይ አደ አይለ ዎይኮ ማጫ አይለ ቃይጭድ ዎꬍኮ፥ ቦራ ጎዳይ አይልያ ጎዳስ ሀስታሙ ብራ ሳንትመ ቃንፆ፤ ቦራይ ሹቻን ጫደትድ ሀይቆ። ");
INSERT INTO gofe_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“እስ አስ ኦላ ቦክድ ካሞና አግኮ ዎይኮ ካማ ደንꬅን ቦር ዎይኮ ሀረይ ሄ ኦላን ዉልኮ፥ ");
INSERT INTO gofe_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","ሄ ኦላ ጎዳይ መህያ ጋትያ ቃንፆ። እ እያ ጎዳስ ጋትያ ቃንፅድ፥ ሀይቅዳ መህያ ባዉ ኤኮ። ");
INSERT INTO gofe_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“እስ አሳ ቦር ሀራ አሳ ቦር ጫድድ ዎꬍኮ፥ ፓፃ ቦራ ባይዝድ፥ እያ ሚሽያነ ሀይቅዳ ቦራ አሹዋ ናምአይ ሻክ ኤኮ። ");
INSERT INTO gofe_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","ሽን ሄ ቦራይ ካሰካ ቃይጭያባ ግደይሳ ኤርሸ፥ እያ ጎዳይ ቃቾና አግዳባ ግድኮ፥ ሄ ኡራይ እያዉ ቦር ቃንፆ። ያትድ፥ ሄ ሀይቅዳይሳ ባዉ ኤኮ።” ");
INSERT INTO gofe_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“እስ አስ ቦር ዎይኮ ዶርሰ ካይስድ ሹክኮ፥ ዎይኮ ባይዝኮ፥ ቦራ ግሾ እቻሹ ቦራታ፥ ዶርሳ ግሾ ኦይዱ ዶርሳታ ጭጎ። ");
INSERT INTO gofe_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","“ካይሶይ ኬ ቦክሸ ኦይከትድ ሾጨትድ ሀይቅኮ፥ ሾጭ ዎꬍዳይስ ኦይሸተና። ");
INSERT INTO gofe_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","ሽን ሄስ ሀንዳይ ጋላስ ግድኮ፥ እ ሄ ጉስዳ ሱꬃ አጩዋን ኦይሸቴስ። ካይሶይ ባ ካይስዳይሳ ዛሮ፥ ሽን እያዉ ዛራናባይ ꬋይኮ ባ ሁጰን አይለተꬃስ ባይዘቶ። ");
INSERT INTO gofe_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","እ ካይስዳ መሄይ ፓፃ ደእሸ እያ ኩሸን በንትኮ፥ ቦር ዎይኮ ሀረ ዎይኮ ዶርሰ ግድኮ፥ እ ካይስዳይሳስ ናምኡ ኩሸ ጭጎ። ");
INSERT INTO gofe_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“እስ አስ ባ መህያ ደንባን ዎይኮ ዎይነ ጋደን ሄምሽን፥ መሄይ ሀራ አሳ ካꬅ ሚኮ፥ እ ባ ካꬃፈ ዎይኮ ባ ዎይንያፐ ሎኡዋ አጫ ቃንፆ። ");
INSERT INTO gofe_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“እስ አስ ባ ጋደን ታማ ፁግሽን ታማይ ቡርያ ካንꬅድ ሀራ አሳ ጋደን ድጭያ ካꬃነ ዶርያ ሚኮ፥ ታማ ኦይꬅዳ ኡራይ አጮ ቃንፆ። ");
INSERT INTO gofe_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“እስ አስ ብራ ዎይኮ ሀራ አልኦ ሚሸ ባ ሾሩዋስ ሀዳራ እምን፥ ሄ ሾሩዋ ሶፐ ካይሶይ ሄ ሚሽያ ኤክኮነ ሄ ካይሶይ ኦይከትኮ፥ ሄ ካይሶይ ሚሽያ ናምኡ ኩሸ ጭጎ። ");
INSERT INTO gofe_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","ሽን ካይሶይ በንቶና እፅኮ፥ ኡራይ ፆሳ ስን ሺቅድ፥ ባ ሾሩዋ ሚሽያ፥ እ ኤኮናይሳ ኤርሳናዉ ጫቆ። ");
INSERT INTO gofe_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","“ናምኡ አሳት ቦራ ጋሶን ዎይኮ ሀረ ጋሶን ዎይኮ ዶርሳ ጋሶን ዎይኮ ማኦ ጋሶን ዎይኮ ሀራ ꬋይዳባ ጋሶን ሞተትድ፥ ፆሳ ስን ሺቅኮ፥ ፆሳይ እያ ቦላ ፕርድዳይስ ናምኡ ኩሸ ጭጎ። ");
INSERT INTO gofe_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“እስ አስ ሀረ ዎይኮ ቦር ዎይኮ ዶርሰ ዎይኮ ሀራ መሄ ሀዳራ እምዳሱዋን ሀይቅኮ ዎይኮ መእኮ ዎይኮ ኦንካ በኦና ካይሶተትኮ፥ ");
INSERT INTO gofe_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","ሀዳራ ኤክዳይስ ባ ላግያ መህያ ካይሶቶናይሳ ጎዳ ስንꬃን ጫቆ። ሄ መህያ ጎዳይ ጫቁዋ ኤኮ፤ መሄይ እያፐ ꬋይዳ ኡራይ ጭጋናዉ ኮሸና። ");
INSERT INTO gofe_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","ሽን መሄይ ካይሶተትዳባ ግድኮ፥ መህያ ጎዳስ ጭጎ። ");
INSERT INTO gofe_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","ሄ መህያ ዶእ ምዳባ ግድኮ፥ ማርካ ግዳናዳ ጋዉፃ ኤሆ፤ ዶእ ምዳባ ግድኮ እያዉ ጭጎፎ። ");
INSERT INTO gofe_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“አስ ባ ሾሩዋፐ መሄ ዎስ ኤክኮ እያ ጎዳይ ባይና በሳን ሄ መሄይ ደሸትኮ ዎይኮ ሀይቅኮ፥ ሄ መህያስ ጭጋ እሞ። ");
INSERT INTO gofe_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","ሽን እያ ጎዳይ እያራ ደእሽን ሄስ ሀንዳባ ግድኮ አጫ ቃንፆፎ። ሀሸ ኤክዳባ ግድኮ፥ ሄ ሀሸ ሚሸይ አጮ ጋተ ግዶ። ");
INSERT INTO gofe_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“እስ አስ እስ ጌላእዉ ጭምድ፥ ኢራ ዝንኤትያባ ግድኮ፥ እዉ አጫ እምድ፥ ባዉ ማቾ ኦꬆ። ");
INSERT INTO gofe_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","እ አዋይ እዮ እያዉ እማናዉ ኮዮና እፅኮ፥ ጌላኦ ኤክያ ኡራይ አጫ እምያ ሚሸ መላ እ አዋስ እምድ አጮ። ");
INSERT INTO gofe_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“ብታ ብትያ ማጫስ ሀይቆ። ");
INSERT INTO gofe_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“መሄራ ቱንያ ኦንካ ሀይቆ። ");
INSERT INTO gofe_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“ፆሳፈ ሀራ ጎዳታስ ያርሽያ ኦንካ ሀይቆ። ");
INSERT INTO gofe_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","ህንተ ግብፀ ቢታን በተ አስ ግድድ፥ ደእዳ ግሾ፥ በተ አስ ቆሆፕተ ዎይኮ ኡንኤꬆፍተ። ");
INSERT INTO gofe_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","አምኤታነ ይኦታ ኡንኤꬆፍተ። ");
INSERT INTO gofe_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","ህንተ ኤንታ ኡንኤꬅኮ፥ ኤንቲ ታኮ ዋሳና፤ ");
INSERT INTO gofe_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","ታኒ ኤንታ ዋሱዋ ስአና። ሄ ዎደ ታ ህንተ ቦላ ሀንቀታዳ ህንተና ኦላን ዉርሳና። ህንተ ማቸት አምኦ፥ ህንተ ናይትካ አዉ ባይናይሳታ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“ህንተ ግዶን ደእያ ማንቆ ግድዳ ታ አሳፐ ኦደስካ ሚሸ ታልእኮ፥ የሎን ታልእያ አሳዳ የሎ ኦይቾፍተ። ");
INSERT INTO gofe_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","ኔኒ እስባ ግሾ፥ እያ ማኡዋ ኦይክዳ አስ ደእኮ፥ አው ዉሎና ደእሽን እያ ማኡዋ ዛራ። ");
INSERT INTO gofe_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","እ ማእድ አቀይ እ ፃላላ። እ ሀራ አይ ማእድ አቃናዉ ዳንዳኢ? ታኒ ቃትያ ፆሲ ግድያ ግሾ፥ እ ታኮ ዋስያ ዎደ ስአና። ");
INSERT INTO gofe_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“ፆሳ ቦላ ጫሻ ቃላ ሃሳዮፓ፥ ዎይኮ ነ ደርያ አይሰይሳ ባዶፋ። ");
INSERT INTO gofe_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","ነ ካꬃፈ፥ ነ ዎይነ ኡሻፈነ ነ ሻማሆ ዛይትያፐ ታዉ ያርሾ ያርሻ። “ባይራ ግድድ የለትዳ አደ ናኣ ታዉ እማ። ");
INSERT INTO gofe_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","ነ ሚዛፐነ ነ ዶርሳፈ ባይራ የለትዳይሳ ታዉ እማ። ኤንቲ ላፑን ጋላስ ጋካናዉ፥ ባንታ አየታራ ጋምኦ፤ ሆስፑንꬆ ጋላሳን ኤንታ ታዉ እማ። ");
INSERT INTO gofe_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“ህንተ ታዉ ጌሻ አስ ግዳናዉ ኮሼስ። ሄሳ ግሾ፥ ዶእ መንꬅድ ዎꬍዳ መሄ አሾ ሞፕተ፤ ሄሳ ካናስ የግተ።” ");
INSERT INTO gofe_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“ዎርዶ ኦዳ ጋሰꬆፋ፤ ዎርዶ ማርካታዳ ባላ አስ ማዶፋ። ");
INSERT INTO gofe_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","ኢታባ ኦꬃናዉ ዳሮ አሳ ካሎፋ። ፕርዳ ዎብሳናዉ ዳሮ አሳራ እስፋዳ ማርካቶፋ። ");
INSERT INTO gofe_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","ማንቆይ ፕርዳስ ሺቅያ ዎደ እያ ማንቆተꬃ በአዳ ማዶፋ። ");
INSERT INTO gofe_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“ነ ሞርክያ ቦራይ ዎይኮ ሀረይ ꬋይን ደምኮ፥ ዛራዳ እያዉ ኤፋ። ");
INSERT INTO gofe_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","ነና እፅያ ኡራ ሀረይ ጫናራ ኩንድን በአዳ፥ ኡራ ማዳዳ ደንꬆና አጋዳ አꬎፋ። ");
INSERT INTO gofe_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“ፕርዳ ዳባባን ማንቆይ ፕርዳስ ሺቅያ ዎደ እያ ፕርዳ ዎቢሶፓ። ");
INSERT INTO gofe_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","ኦናካ ማልተን ሞቶፓ፤ ፅሉዋ ዎꬎፓ። ሄሳ መላባ ኦꬅዳይሳ ታኒ ፕርዶና አግከ። ");
INSERT INTO gofe_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","ዎꬋፈ ኤኮፋ፤ ዎꬋፈይ ሱረ ፄልያ አሳ አይፈ ቆቅሴስ፥ ፅሎታ ፕርዳ ምርቄስ። ");
INSERT INTO gofe_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“በታንቹዋ ናቆፋ። ህንተ ግብፀ ቢታን በተ አስ ግድድ ደእዳ ግሾ፥ አሳ ጋደ አስ ግዶይ አይ መላ ስኤትያኮ ኤሬታ። ");
INSERT INTO gofe_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“ኔኒ ነ ጋድያ ኡሱፑን ላይꬅ ጎያዳ ማ። ");
INSERT INTO gofe_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","ላፑንꬃ ላይꬃን ጋድያ ጎዮና ሻቻ፤ እያን ዶልድ ካፅያባ ሺሾፓ። ነ አሳ ግዶን ደእያ ማንቆት እያፐ ሞ፤ ቃስ ኤንታፈ አትዳይሳ ዶአት ሞ። ነ ዎይነ ጋድያነ ነ ሻማሆ ጋድያ ሄሳዳ ኦꬃ። ");
INSERT INTO gofe_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“ኔኒ ኡሱፑን ጋላስ ኦሶ ኦꬃ። ነ ቦራይነ ነ ሀረይ ሸምፓና መላነ ነ ሶን የለትዳ አይለይነ በተ አስ ሸምፓና መላ ላፑንꬃ ጋላሳን ኦሶ ኦꬆፋ። ");
INSERT INTO gofe_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","ታኒ ህንተዉ ኦድዳባ ኡባ ምንꬅድ ኦꬅተ። ሀራ ፆሳታ ሱንꬃ ፄግድ ዎሶፍተ፤ ኤንታ ሱንꬃ ደንꬆፍተ። ");
INSERT INTO gofe_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“ታና ቦንቻናዉ ላይꬃን ሄꬑ ባኣለ ጋላሳት ህንተዉ ደኦ። ");
INSERT INTO gofe_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","ህንተ ግብፀፈ ከይዳ አቢባ ጌተትያ አጌናን፥ ታኒ ህንተና ኪትዳይሳዳ ኡይꬃ ባኣለ ቦንችተ። ላፑን ጋላስ እርሾ የግድ ኡክዳ ኡይꬅ ሞፕተ። ታና ጎይናናዉ ይሸ መላ ኩሸ ዮፕተ። ");
INSERT INTO gofe_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“ቃስ ህንተ፥ ህንተ ጋደን ዘርን፥ ኮይሮ ጋክዳ ካꬃ ጫክያ ዎደ ካꬃ ጫኮ ባኣለ ቦንችተ። “ላይꬃ ዉርሰꬃን፥ ዎይንያነ ሄሳ መላ ምꬃታ አይፍያ ህንተ ጋደፐ ማፅያ ዎደ ሻቃራ ባኣለ ቦንችተ። ");
INSERT INTO gofe_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","ላይꬃን ላይꬃን ቦንቸትያ ሀ ሄꬑ ባለታን አደ ኡባይ ታና፥ ህንተ ጎዳ ጎይናናዉ ዮ። ");
INSERT INTO gofe_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“ኔኒ ታዉ መሄ ያርሽያ ዎደ እርሾ የግድ ኡክዳ ኡይꬃራ ታዉ ያርሾፋ። ባኣለ ቦንችያ ጋላስ ያርሸትዳ ሞꬉዋፈ ዎንታስ አይብካ አቶፎ። ");
INSERT INTO gofe_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","ህንተ ጋደን ባይራ ካፅዳ ካꬃ ኡባፈ ሎኡዋ ጎዳ፥ ህንተ ፆሳ ሶ ኤህተ። ዴሻ ማር ዎይኮ ዶርሳ ማር እያ አየ ማꬃን ዶይሶፓ። ");
INSERT INTO gofe_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“ነ ኦግያን ነና ናጋና ማላነ ታኒ ነዉ ጊግስዳ በሳ ነና ኤፋና መላ ታኒ ኪታንቾ ነ ስንꬃን ኪታና። ");
INSERT INTO gofe_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","እ ኦድያባ ስአዳ እያዉ ኪተታ፤ እያ ቦላ ማካሎፋ። ታ እያዉ ማታ እምዳ ግሾ፥ ህንተ ናጋራ ኦꬅያባ ግድኮ፥ ህንተ ናጋራ ማረና። ");
INSERT INTO gofe_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","ህንተ እያዉ ኪተትኮነ ታ ኪታ ኡባ ፖልኮ፥ ህንተ ሞርከታ ኡባ ሞርካና፤ ህንተራ ኤቀተይሳታ ታኒ ኦላና። ");
INSERT INTO gofe_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","ታ ኪታንቾይ ህንተ ስንꬃን ብድ፥ ህንተና አሞረታ፥ ህተታ፥ ፓርዘታ፥ ካናነታ፥ ህወታነ ያቡሰታ ቢታ ኤሀና። ታኒ ኤንታ ꬋይሳና። ");
INSERT INTO gofe_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","ኤንታ ፆሳታስ ዝጎፍተ ዎይኮ ጎይኖፍተ፥ ዎይኮ ኤንታ አማኖ ዎጋ ካሎፍተ። ኤንታ ፆሳታ ꬋይስተ፥ ኤንታ ኤቃ ሹቻታ መንረꬅተ። ");
INSERT INTO gofe_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","ጎዳ፥ ህንተ ፆሳ ታና፥ ጎይንተ። ሄሳዳ ህንተ ኦꬅኮ፥ ታኒ ህንተ ካꬃነ ህንተ ሃꬃ አንጃና፤ ሀርግያካ ህንተ ግዶፈ ድጋና። ");
INSERT INTO gofe_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","ህንተ ቢታን ማጫሳይ ቦሸተና፤ ማይነና። ታኒ ህንተ ላይꬃ አዱሳና። ");
INSERT INTO gofe_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“ታኒ ነ ሞርከታ ቦላ ታ ያሻ የዳና። ህንተራ ኤቀትያ ካዎተꬃታ ኡባ ዳጋንꬃና። ህንተ ሞርከት ኡባይ ህንተዉ ዞኮ ዛሪድ ባቃታና መላ ኦꬃና። ");
INSERT INTO gofe_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","ታኒ ህንተ ሞርከታ ቦላ ካዠ የዳዳ ህወታ፥ ካናነታነ ህተታ ህንተ ስንꬃፈ ጎዳ ከሳና። ");
INSERT INTO gofe_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","ሽን ቢታይ መላ አቶናዳነ ባዞ ዶእ ህንተና ዋይሶናዳ እስ ላይꬃን ኤንታ ጎድከ። ");
INSERT INTO gofe_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","ሽን ህንተ ታይቦን ዳርድ፥ ምንድ፥ ሄ ቢታ ላታና ጋካናዉ ኤንታ ጉꬃራ ጉꬃራ ጎዳ ከሳና። ");
INSERT INTO gofe_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","ታኒ ህንተ ዛዋ ዞኦ አባፈ ፍልስፄመ አባ፥ መላ ቢታፈ ብድ ኤፍራፂሳ ሻፋ ጋካናዉ ዳልግሳና። ሄ ቢታን ደእያ ኡባ ታኒ ህንተ ኩሸን አꬃዳ እማና፤ ህንተካ ኤንታ ጎድድ ከሳና። ");
INSERT INTO gofe_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","ኤንታራ ዎይኮ ኤንታ ፆሳታራ ጫቆ ኦꬆፍተ። ");
INSERT INTO gofe_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","ኤንታ ህንተ ቢታን ዎꬆፍተ። ሀንኮደ ኤንቲ ህንተና ታ ቦላ ናጋራ ኦስሳና። ኤንታ ፆሳታ ህንተ ጎይንኮ ህንተዉ ፅሄ ግዳና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","ጎዳይ ሙሰኮ፥ “ኔኒ፥ አሮን፥ ናዳብ አብዮዳነ እስራኤለ ጭማታፐ ላፑን ታሙ አሳት ታኮ ዙማ ቦላ ከይድ፥ ሃሆን ኤቅድ፥ ጉፋንድ፥ ታዉ ጎይንተ። ");
INSERT INTO gofe_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","ሽን ኔኒ ነርካ ታኮ ሺቃ፤ ሀራት ታ ማት ሺቆፖ። ቃስ አሳይካ ኔራ ዙማ ቦላ ከዮፖ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","ሙሰይ ብድ፥ ጎዳ ቃላነ ዎጋ ኡባ አሳስ ኦድን፥ አሳ ኡባይ እስ ቃላን፥ “ጎዳይ ግዳባ ኡባ ኑኒ ኦꬃና” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","ሙሰይ ጎዳይ ኦድዳባ ኡባ ፃፍስ። ዎንተꬃ ጋላስ ጉራ ደንድድ፥ ዙማ ጋርሳን ያርሾ በሰ ጊግስስ። ታማነ ናምኡ እስራኤለ ሼሻታ ሱንꬃን፥ ታማነ ናምኡ ሹቻ ቱስ ኤስስ። ");
INSERT INTO gofe_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","እስራኤለ ፓንꬃታ እ ኪትን፥ ኤንቲ ብድ ፁሳ ያርሹዋነ እስፈተꬃ ያርሹዋስ ኮርማታ ሹክድ፥ ጎዳስ ያርሽዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","ሙሰይ መህያ ሱꬃፈ ባጋ ኤክድ ከርያን ትግስ፤ አትዳ ባጋ ሱꬃ ያርሾ በሳን ꬋርጭስ። ");
INSERT INTO gofe_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","ሄሳፈ ጉየ ጫቆ ማፃፋ ኤክድ፥ አሳስ ናባብን፥ ኤንቲ፥ “ጎዳይ ግዳባ ኡባ ኑኒ ኦꬃና፤ ኑኒ እያ ኪታ ፖላና” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","ሄሳፈ ጉየ፥ ሙሰይ ሄ ሱꬃ ኤክድ፥ አሳ ቦላ ꬋርጭድ፥ ኤንታ፥ “ጎዳይ ህንተዉ ሀ ኪታታ እምያ ዎደ ህንተራ ገልዳ ጫቁዋ ምንꬅያ ሱꬃይ ሀይሳ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","ሙሰይ፥ አሮን፥ ናዳብ፥ አብዮዳነ እስራኤለ ጭማታፐ ላፑን ታማይ ዙማ ቦላ ከይድ፥ ");
INSERT INTO gofe_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","እስራኤለ ፆሳ በእዶሶና። እያ ቶሁዋፐ ጋርሳን ሳሎዳ ጌይዳ፥ ሳንፓረ ጌተትያ ሹቻፈ ኦሰትዳባ ዳንያ ደምባ በሲ ደኤስ። ");
INSERT INTO gofe_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","ሽን ፆሳይ እስራኤለ አሳ ሀላቃታ ዎꬍቤና። ኤንቲ ፆሳ በእዶሶና፤ እያ ስንꬃን ምዶሶናነ ኡይዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","ጎዳይ ሙሰኮ፥ “ኔኒ ታኮ ዙማ ቦላ ሃ ከያዳ፥ ሀይሳን ጋምአ። ታ አሳይ ታዉ ኪተታና መላ ናምኡ ሎቸ ሹቻታ ቦላ ታ ኩሸን ታ ፃፍዳ ህገታ ነዉ እማና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","ሙሰይነ እያዉ ኪተትያ እያሱይ ባናዉ ደንድዶሶና፤ ሙሰይ ፆሳራ ጋሄታናዉ ዙማ ቦላ ከይስ። ");
INSERT INTO gofe_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","ሙሰይ እስራኤለ ጭማታኮ፥ “ኑኒ ህንተኮ ስማና ጋካናዉ ሀይሳን ጋምእተ። አሮንነ ሁር ሀይሳን ህንተራ ደኦሶና፤ ኦድ ደእያ ኦንካ ኤንታኮ ቦ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","ሙሰይ ዙማ ቦላ ከይዳ ዎደ ሻራይ ዙማ ማእስ። ");
INSERT INTO gofe_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","ጎዳ ቦንቾይ ሲና ዙማ ቦላ ኡትስ። ሄ ሻራይ ኡሱፑን ጋላስ ዙማ ቦላ ማእስ፤ ላፑንꬃ ጋላስ ጎዳይ ሻራ ግዶን ግድድ ሙሰ ፄግስ። ");
INSERT INTO gofe_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","ዙማ ቦላ ቆንጭዳ ጎዳ ቦንቾይ እስራኤለታስ ታማ ላጮ ዳንድ በንትስ። ");
INSERT INTO gofe_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","ሄሳፈ ጉየ፥ ሙሰይ ዙማ ሁጵያ ከይድ ሻራ ግዶ ገልስ፤ ያን ኦይታሙ ጋላስነ ኦይታሙ ቃማ ጋምእስ። ");
INSERT INTO gofe_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","ጎዳይ ሙሰኮ ሀይሳዳ ያግስ፤ ");
INSERT INTO gofe_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“ታዉ እሞታ ኤሀና መላ እስራኤለታስ ኦዳ። እያ ዎዛን እያ እማ እማ ግዳባ እምያ እሞታ አሳ ኡባፈ ታዉ ኤካ። ");
INSERT INTO gofe_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","ህንተ ኤንታፈ ኤካና እሞታይ፥ ዎርቃ፥ ብራ፥ ናሰ ብራታ፥ ");
INSERT INTO gofe_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","ካሎሰ ቃጭና፥ ኦቻ ቴራ ዳንያ ቃጭና፥ ዞኦ ቃጭናነ አልኦ ሊኖ፥ ዴሻ እክሰ፥ ");
INSERT INTO gofe_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","ሃሸትድ ዞኦ ቃላመን ትየትዳ ዶርሳ እተ፥ ሎኦ ዶአ እተ፥ ሶቃላ ምꬅ፥ ");
INSERT INTO gofe_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","ፆምፐስ ማድያ ሻማሆ ዛይተ፥ ሹማተꬃ ዛይትያንነ እፃንያን ጉዠትያ ሳዎታ፥ ");
INSERT INTO gofe_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","ካህነ ሀላቃይ ማእያ ኤፉደ ጌተትያ ማኡዋ ቦላነ እያ ትራን ዎሰትያ ማርግደ ጌተትያ አልኦ ሹቻነ ሀራ አሌቆ ሹቻታ ኤሆ። ");
INSERT INTO gofe_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","ታኒ ኤንታ ግዶን ዳና መላ ኤንቲ ታና ጎይንያ በሲ ጊግሶ።” ");
INSERT INTO gofe_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","ዱንካንያነ እያ ግዶን ደእያ ሚሸታ ኡባ ታ ነና በሲያ ማራን ኦꬃ። ");
INSERT INTO gofe_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“ሶቃላ ምꬃፈ፥ አዱሳተꬃይ ናምኡ ዋꬋነ ታካꬎ፥ ጎምፓይ እስ ዋꬋነ ታካꬎ፥ ጌሳይ እስ ዋꬋነ ታካꬎ ግድያ ሳፅነ ኦꬅተ። ");
INSERT INTO gofe_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","ጋꬃነ ካርያ ዋላህ ባይና ዎርቃን ካማ፤ እያ ዩሹዋካ ዎርቃን ላንፃ። ");
INSERT INTO gofe_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","ሄ ታቦትያስ ኦይዱ ዎርቃ ሳጋዮታ ኦꬃዳ፤ ኦይዱ ገዳታ ቦላ እስ ባጋራ ናምኡ ሳጋዮታ፥ ቃስ ሀንኮ ባጋራ ናምኡ ሳጋዮታ አꬃዳ ጋሰꬃ። ");
INSERT INTO gofe_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","ታቦትያ ቶክያ ካሶ ምꬃታ ሶቃላ ምꬃፈ ከሳዳ ዎርቃን ላንፃ። ");
INSERT INTO gofe_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","ታቦትያ ቶካናዉ እያ ምየን ደእያ ሳጋዮታን ካሶ ምꬃታ አꬃ። ");
INSERT INTO gofe_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","ቶክያ ካሶ ምꬃት ታቦትያ ሳጋዮታ ግዶን ደኦ፤ ኤንቲ ያፐ ከዮፖ። ");
INSERT INTO gofe_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","ታቦትያ ግዶን ታኒ ነዉ እምያ፥ ታሙ ኪታት ፃፈትዳ ናምኡ ሎቸ ሹቻታ ዎꬃ። ");
INSERT INTO gofe_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“ዋላህ ባይና ዎርቃፈ አዱሳተꬃይ ናምኡ ዋꬋነ ታካꬎ፥ ጎምፓይ እስ ዋꬋነ ታካꬎ ግድያ ናጋራ አቶተꬃ ካማ ኦꬃ። ");
INSERT INTO gofe_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","ቀፈራ ደእያ ናምኡ ክሩበታ ዎርቃፈ ቆፃዳ ኦꬃ። ");
INSERT INTO gofe_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","እስ ክሩብያ እስ ባጋ ጋፃን፥ ናምአንꬆ ክሩብያ ሀንኮ ባጋ ጋፃን ዎꬃዳ ናምኣ ታቦትያ ጉጵያራ ኦይꬃዳ ኦꬃ። ");
INSERT INTO gofe_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","ክሩበት ዎልኮ ስም ኡትድ፥ ባንታ ቀፍያ ደንꬅድ፥ አቶተꬃ ካማ ካሞ። ");
INSERT INTO gofe_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","ታኒ ነዉ እምያ ሎቸ ሹቻ ቦላ ፃፈትዳ ታሙ ኪታታ ታቦትያ ግዶን ዎꬃ። ያታዳ፥ ጉጵያ ታቦትያ ቦላ ዎꬃ። ");
INSERT INTO gofe_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","ታቦትያ ጉጵያ ቦላ ደእያ ናምኡ ክሩበታፐ ግዶን ግዳዳ ታኒ ኔራ ጋሄታና። እስራኤለ አሳስ እምያ ኪታ ኡባ ታኒ ያን ነዉ እማና።” ");
INSERT INTO gofe_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“ሶቃላ ምꬃፈ አዱሳተꬃይ ናምኡ ዋꬋ፥ ጎምፓይ እስ ዋꬋ፥ ጌሳይ እስ ዋꬋነ ታካꬎ ግድያ እስ ፃርጴዛ ኦꬃ። ");
INSERT INTO gofe_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","ያታዳ፥ ዋላህ ባይና ዎርቃን ላንፃ፤ እያ ዩሹዋካ ዎርቃን ላንፃ። ");
INSERT INTO gofe_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","ሄሳዳካ፥ ጎምፓይ ታካꬎ ግድያ ጎሳ እያ ቦላ ዩሻ አꬃ። ያታዳ፥ እያ ዩሹዋ ዎርቃን ላንፃ። ");
INSERT INTO gofe_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","ሄ ፃርጴዛስ ኦይዱ ዎርቃ ሳጋዮታ ኦꬃዳ፥ ፃርጴዛ ኦይዱ ቶሆታራ ኦይꬃ። ");
INSERT INTO gofe_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","ፃርጴዛ ቶካናዉ ካሶ ምꬃታ አꬅያ ሳጋዮት ፃርጴዛ ጎሳ ማታን ሺቅድ ደኦ። ");
INSERT INTO gofe_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","ሄ ቶክያ ካሶታ ሶቃላ ምꬃፈ ከሳዳ፥ ዎርቃን ላንፃ። ");
INSERT INTO gofe_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","ሄሳዳካ፥ ሻተታነ ጭልፓታ፥ ዎይነ ያርሹዋ ዱቅያ ሚሸታነ ፁአታ ዋላህ ባይና ዎርቃፈ ኦꬃ። ");
INSERT INTO gofe_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","ፃርጴዛይ ታቦትያስ ስንꬃ ባጋራ ኡቶ። ታ ስንꬃን ኡትያ ጌሻ ኡይꬃይ ኡባ ዎደ ፃርጴዛ ቦላፈ ꬋዮፖ።” ");
INSERT INTO gofe_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“ፆምፐ ዎꬅያ ኮጫ ዋላህ ባይና ዎርቃፈ ኦꬃ። ሄ ኮጫይ ኤቅያ ቶሁዋነ ቶማ ዎርቃፈ ቆፃዳ ኦꬃ። አሌቆስ ኦሰትያ ዋላፃት፥ ጋምቡꬃትነ ጪሻት ኡባይ እስኖ ግድድ ኦሰታናዉ በሴስ። ");
INSERT INTO gofe_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","ናምኡ ባጋራ፥ ሄꬑ ሄꬑ ታሸታ እያዉ ከሳ። ");
INSERT INTO gofe_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","ኡሱፑን ታሸታስ ፄራን ፄራን ሄꬑ ሄꬑ አሌቆ ጋምቡꬃትነ ጪሻት ደእያ ላውዘ ምꬃ ጪሸ ዳንያባይ ደኦ። ");
INSERT INTO gofe_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","ፆምፕያ ዎꬅያ ኮጫ ግዶን ደእያ ቶማ ፄራን ኦይዱ አሌቆ ጋምቡꬃትነ ጪሻት ደእያ ላዉዘ ምꬃ ጪሸ ዳንያባይ ደኦ። ");
INSERT INTO gofe_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","ታሸታፐ ጋርሳን፥ ናምኡ ታሸት ጋሄትያ በሳን እስ እስ ጋምቡꬅ ደኦ። ");
INSERT INTO gofe_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","ጋምቡꬃይ፥ ታሸይነ ፆምፕያ ዎꬅያ ኮጫይ እስኖ ግድድ፥ ዋላህ ባይና ዎርቃፈ ቆፀትድ ኦሰቶ። ");
INSERT INTO gofe_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","“ፆምፐ ዎꬅያ ኮጫ ቦላ ላፑን ፆምፐታ ጊግሳዳ፥ ኤንቲ ስን ፖአና መላ ꬎቁ ኦꬃዳ ዎꬃ። ");
INSERT INTO gofe_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","ፆምፕያ ናጋናዉ ማድያ ቃጰታነ ኤንታ ዎꬅያባታ ዋላህ ባይና ዎርቃፈ ኦꬃ። ");
INSERT INTO gofe_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","ፆምፐ ዎꬅያ ኮጫይነ እያ ሚሸት ኡባይ ሀስታማነ እቻሹ ክሎ ግራመ ግድያ ዋላህ ባይና ዎርቃፈ ኦሰቶ። ");
INSERT INTO gofe_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","ታኒ ነና ዙማ ቦላ በስዳ ሌምሱዋ ካላዳ፥ አኬካዳ ኦꬃ።” ");
INSERT INTO gofe_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“ዱንካንያ ጋꬃ ባጋስ አልኦ ሊኖፐ ኦሰትዳ፥ ታሙ ገሸ ጊግሳ። ኤንታ ካሎሰ፥ ኦቻ ቴራ ዳነይሳንነ ዞኦ ቃጭናን ዳዳዳ ክሩበታ ምስልያራ አሌቅሳ። ");
INSERT INTO gofe_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","ገሸት ኡባይ እስ ልከ ግዶ፤ አዱሳተꬃይ ላታማነ ኦይዳ፥ ጎምፓይ ቃስ ኦይዱ ዋꬋ ግዶ። ");
INSERT INTO gofe_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","እቻሹ ገሸታ እስፈ ጋꬃዳ ስካ፤ ሀንኮ አትዳ እቻሻታ ሄሳዳ ኦꬃ። ");
INSERT INTO gofe_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","እስፈ ጋሄትድ ስከትዳ ናምኡ ገሸታስ እሱዋ እሱዋ ጋፃን ካሎሰ አፍላፐ ኦሰትዳ ሳጋዮታ ኦꬃ። ");
INSERT INTO gofe_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","እስፈ ስከትዳ ኮይሮ ማጋራጁዋ ቦላ ኮይሮ ማራን ካሎሰ አፍላፐ ኦሰትዳ እሻታሙ ሳጋዮታ ኦꬃ፤ ሄሳዳካ ናምአንꬆ ማጋራጁዋ ቦላ ዉርሰꬃ ጋፃን እሻታሙ ሳጋዮታ ኦꬃ። ");
INSERT INTO gofe_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","ጌሻ ዱንካነይ እስኖ ግዳና መላ ናምኡን ሻከት ስከትዳ ገሸታ ዎል ጋꬅድ ኦይሰꬃናዉ፥ እሻታሙ ዎርቃፈ ኦሰትዳ ኦይክያባታ ኦꬃ። ");
INSERT INTO gofe_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“ጌሻ ዱንካንያ ቦላራ ካማና መላ ታማነ እስ ገሸታ ዴሻ እክሰፐ ኦꬃ። ");
INSERT INTO gofe_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","ታማነ እስ ገሸት እስ ግና ግዶ፤ እስ እስ ማጋራጁዋ አዱሳተꬃይ ሀስታሙ ዋꬋ፥ ጎምፓይ ኦይዱ ዋꬋ ግዶ። ");
INSERT INTO gofe_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","እቻሹ ገሸታ እስ ባጋራ፥ ኡሱፑን ገሸታ ሀንኮ ባጋራ ጋꬃዳ ስካ። ኡሱፑንꬆ ማጋራጆይ ዳኮየትድ፥ ዱንካንያስ ስንꬃ ባጋራ ዳቡለቶ። ");
INSERT INTO gofe_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","ዎል ጋꬅ ስክዳ ገሸታፐ እስ ማጋራጁዋስ ማጫራ ቦላ እሻታሙ ሳጋዮታ ኦꬃ፤ ቃስ ሀንኮ ማጋራጁዋስ ማጫራ ቦላ እሻታሙ ሳጋዮታ ኦꬃ። ");
INSERT INTO gofe_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","ናምኡን ሻከት ስከትዳ ገሸት እስ ካማ ግዳና መላ እሻታሙ ናሰ ብራታፐ ኦሰትዳ ኦይክያባታ ኦꬃ። ");
INSERT INTO gofe_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","ሄ ዱንካንያ ገሸታፐ ፓላህዳ ባጋ ኤካዳ ጌሻ ዱንካንያስ ጉየ ባጋራ ካቃ። ");
INSERT INTO gofe_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","ዱንካንያ ገሸታፐ አዱሳተꬃ ባጋራ ፓላህዳ ጎምፓይ እስ እስ ዋꬋ ግድዳ ገሸታ ጌሻ ዱንካንያስ ናምኡ ባጋራ ካቃ። ");
INSERT INTO gofe_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","“ዱንካንያስ ቦላ ባጋራ ዳቡልድ ካማናዉ ዞኦ ቃላመን ትየትዳ ማራዘ እተነ ሎኦ ዶአ እተ ኦꬃ። ");
INSERT INTO gofe_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","ጌሻ ዱንካንያ ቱቀታ ሶቃላ ምꬃፈ ኦꬃ። ");
INSERT INTO gofe_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","እስ እስ ቱቅያ አዱሳተꬃይ ታሙ ዋꬋ፥ ጎምፓይ እስ ዋꬋነ ባጋ ግዶ። ");
INSERT INTO gofe_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","ናምኡ ቱቀት እስፈ ኦይከታና መላ እስ እስ ቱቅያስ ኦይሰꬅያባይ ደኦ። ጌሻ ዱንካንያ ቱቀታ ኡባ ሄሳዳ ኦꬃ። ");
INSERT INTO gofe_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","ጌሻ ዱንካንያ ዉሎሀ ባጋራ ላታሙ ቱቀታ ኦꬃ። ");
INSERT INTO gofe_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","ኤንታና ኤሳናዉ ኤንታ ጋርሳን ብራ ብራታፐ ኦሰትዳ ኦይታሙ ሉሆይ ደእያ ቶሆታ ኦꬃ። እስ እስ ቱቅያስ ናምኡ ናምኡ ቶሆ ከሳ። ");
INSERT INTO gofe_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","ጌሻ ዱንካንያ ፑደሀ ባጋራ ላታሙ ቱቀታ ኦꬃ። ");
INSERT INTO gofe_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","ኤንታና ኤሳናዉ ኤንታ ጋርሳን ብራ ብራታፐ ኦሰትዳ ኦይታሙ ሉሆይ ደእያ ቶሆታ ኦꬃ። እስ እስ ቱቅያስ ናምኡ ናምኡ ቶሆ ከሳ። ");
INSERT INTO gofe_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","ጌሻ ዱንካንያስ ጉየራ ዉሎሀ ባጋራ ኡሱፑን ቱቀታ ኦꬃ። ");
INSERT INTO gofe_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","ጉየ ባጋራ ደእያ ማዛነታስ ናምኡ ቱቀታ ኦꬃ። ");
INSERT INTO gofe_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","ሄ ማዛንያን ደእያ ቱቀት ቶሆፐ ሁጰ ጋካናዉ ኦይከቶ። ናምኡ ማዛነታ መꬍያ ናምኡ ቱቀታ ሄሳꬆ ኦሰታናዉ በሴስ። ");
INSERT INTO gofe_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","ሄሳዳካ ናምኡ ናምኡ ቶሆይ ደእያ ሆስፑን ቱቀታ ኦꬃዳ፥ ኤንታዉ ብራ ብራታፐ ኦሰትዳ ታማነ ኡሱፑን ሉሆይ ደእያ ቶሆታ ኦꬃ። ");
INSERT INTO gofe_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“ቱኡቀታ ሳꬅድ ኦይꬅያ ሶቃላ ምꬃፈ ኦሰትዳ ታማነ እቻሹ ልዮታ ከሳ። ኤንታፈ እቻሻታ ጌሻ ዱንካንያስ እስ ባጋ ምየን ደእያ ቱቀታስ፥ ");
INSERT INTO gofe_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","ቃስ እቻሻታ ሀንኮ ባጋ ምየን ደእያ ቱቀታስ፥ ሄሳዳካ አትዳ እቻሻታ ዉሎሀ ባጋን ደእያ ቱቀታስ ኦꬃ። ");
INSERT INTO gofe_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","ሀ ጋፃ ቱቅያፐነ ያ ጋፃ ቱቅያፐ ይያ ልዮት ግዶ ቱቅያራ ኦይከቶ። ");
INSERT INTO gofe_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","ቱኡቀታ ዎርቃን ላንፃ፤ ልዮታ ኦይካናዉ ማድያ ሳጋዮታ ዎርቃፈ ኦꬃ፤ ቃስ ልዮታ ዎርቃን ላንፃ። ");
INSERT INTO gofe_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","ጌሻ ዱንካንያ ዙማ ቦላ ታ ነና በስዳይሳዳ ኦꬃ። ");
INSERT INTO gofe_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“አልኦ ሊኖፐ እስ ማጋራጆ ኦꬃዳ፥ እያ ካሎሰ፥ ኦቻ ቴራ ዳነይሳንነ ዞኦ ቃጭናን ዳዳዳ ክሩበታ ምስለን አሌቅሳ። ");
INSERT INTO gofe_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","እያ ሶቃላ ምꬃፈ ኦꬃዳ፥ ዎርቃን ሜሸትዳ ኮጫታንነ ብራ ብራታፐ ኦሰትዳ ኦይዱ ቶሆይ ደእያ ቱሳታ ቦላ ካቃ። ");
INSERT INTO gofe_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","ሄ ማጋራጁዋ ጌሻ ዱንካንያስ ካራን ደእያ ቃጰታፐ ጋርሳን ካቃ። ያታዳ ህገይ ፃፈትዳ ናምኡ ሎቸ ሹቻታ ኦይክዳ ጫቆ ታቦትያ ማጋራጁዋስ ጉየ ባጋን ዎꬃ። ሄ ገሸይ፥ ጌሻ በሳነ ኡባፈ ጌሻ በሳፈ ሻኬስ። ");
INSERT INTO gofe_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","ናጋራ አቶተꬃ ካማን ጫቆ ታቦትያ ካማ። ");
INSERT INTO gofe_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","ፃርጴዛ፥ ኡባፈ ጌሻ በሳፈ ካረራ፥ ጌሻ ዱንካንያፐ ፑደሀ ባጋን ዎꬃ፤ ፆምፐ ዎꬅያ ኮጫ ዱገሀ ባጋራ ዎꬃ። ");
INSERT INTO gofe_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“ዱንካንያ ፐንገ ማጋራጁዋ፥ አልኦ ሊኖፐ ጊግሳዳ፥ ካሎሰ፥ ኦቻ ቴራ ዳነይሳንነ ዞኦ ቃጭናን ዳዳዳ አሌቅሳ። ");
INSERT INTO gofe_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","ማጋራጁዋስ እቻሹ ቱሳታ ሶቃላ ምꬃፈ ኦꬃዳ ዎርቃን ላንፃ፤ ኮጫትካ ዎርቃፈ ኦሰትዳይሳታ ግዶ። ቱሳታስ ናሰ ብራታፐ እቻሹ ቶሆታ ጊግሳ።” ");
INSERT INTO gofe_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“ሶቃላ ምꬃፈ ያርሾ በሲ ኦꬃ። አዱሳተꬃይነ ጎምፓይ ኦይዱ ዋꬋነ ታካꬎ፥ ጌሳይ ሄꬑ ዋꬋ ግድዳ ኦይዱ ማዛነራ ደእያ ያርሾ በሲ ኦꬃ። ");
INSERT INTO gofe_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","ኦይዱ ማዛነታ ቦላ ካጨ ዳንያባ ከሳ፤ ካጨት ያርሾ በሳራ እስኖ ግድድ ኦሰቶ። ያታዳ፥ ያርሾ በሳ ኡባ ናሰ ብራታን ላፃ። ");
INSERT INTO gofe_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","እያዉ ጎኤትያ ሚሸታ፤ ብዶ ከስያ ከረታ፥ አካፋታ፥ ባልደታ፥ አሾ ቃጰታነ ጮጨታ ኡባ ናሰ ብራታፐ ኦꬃ። ");
INSERT INTO gofe_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","ያታዳ፥ ናሰ ብራታፐ ዛርዛረ ዳንያባ ኦꬃዳ፥ እያዉ ኦይዱ ማዛነታ ቦላ ኦይዱ ሳጋዮታ ጊግሳ። ");
INSERT INTO gofe_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","ሄ ዛርዛርያ ያርሾ በሳ ጎሳፈ ጋርሳን ያርሾ በሳስ ባጋ ዛዋ ጋꬃዳ ዎꬃ። ");
INSERT INTO gofe_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","ሶቃላ ምꬃፈ ያርሾ በሳ ቶክያ ካሶ ምꬃታ ከሳዳ፥ ናሰ ብራታን ላንፃ። ");
INSERT INTO gofe_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","ያርሾ በሳ ቶክያ ዎደ ማዳና መላ ሄ ካሶ ምꬃታ ናምኡ ምየራ ደእያ ሳጋዮታን አꬃ። ");
INSERT INTO gofe_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","ታኒ ነና ዙማ ቦላ በስዳይሳዳ ያርሾ በሲ ፃዉላፐ ኦꬃዳ፥ ግዱዋ ካይስ ኦꬃ።” ");
INSERT INTO gofe_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“ጌሻ ዱንካንያ ዳባባ ገቻናዉ አልኦ ሊኖፐ ማጋራጆ ጊግሳ። ገሸታስ አዱሳተꬃይ ዱገሀ ባጋራ ፄቱ ዋꬋ ግዶ። ");
INSERT INTO gofe_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","እያዉ ካተ ግዳና መላ ናሰ ብራታፐ ኦሰትዳ ላታሙ ቱሳታነ ላታሙ ቶሆታ ኦꬃ። ኤንታ ቦላ ብራ ብራታፐ ኦሰትዳ ፃምአታነ ካጨታ ኦꬃ። ");
INSERT INTO gofe_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","ዳባባስ ፑደሀ ባጋራካ ሄሳዳ ኦꬃ። ");
INSERT INTO gofe_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","“ዳባባስ ዉሎሀ ባጋ አዱሳተꬃይ እሻታሙ ዋꬋ ግድዳ ገሸት ኦሰትድ፥ ኤንታዉ ታሙ ቶሆይ ደእያ ቱሳት ደኦ። ");
INSERT INTO gofe_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","ገልያ ዉላይ ደእያ፥ ዶሎሀ ባጋ ዳባባ ጎምፓይ እሻታሙ ዋꬋ ግዶ። ");
INSERT INTO gofe_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","ዳባባ ፐንግያፈ እስ ባጋራ አዱሳተꬃይ ታማነ እቻሹ ዋꬋ ግድያ ገሸት ደኦ፤ ኤንታዉ ሄꬑ ቶሆይ ደእያ ሄꬑ ቱሳት ደኦ። ");
INSERT INTO gofe_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","ሀንኮ ባጋራ ደእያ ገሸትካ ሄሳዳ ኦሰቶ። ");
INSERT INTO gofe_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","“ዳባባ ገልያ ዉላስ አዱሳተꬃይ ላታሙ ዋꬋ ግድያ፥ አልኦ ሊኖፐ ማጋራጆ ጊግሳዳ፥ ካሎሰ፥ ኦቻ ቴራ ዳነይሳንነ ዞኦ ቃጭናን ዳዳዳ አሌቅሳ። ኤንቲ እያን ዘምፓና መላ ኦይዱ ቶሆራ ደእያ ኦይዱ ቱሳታ ጊግሳ። ");
INSERT INTO gofe_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","ዳባባ ዩሹዋን ደእያ ቱሳት ኡባይ ብራ ብራታፐ ኦሰትዳ ፃምአታን ኦይከቶ፤ ኤንታ ካጨት ብራ ብራታፐ፥ ኤንታ ቶሆት ናሰ ብራታፐ ኦሰቶ። ");
INSERT INTO gofe_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","ዳባባ አዱሳተꬃይ ፄቱ ዋꬋ፥ ጎምፓይ ኦይታሙ ዋꬋ፥ ጌሳይ እቻሹ ዋꬋ ግዶ። ማጋራጆት አልኦ ሊኖፐ፥ ኤንታ ቶሆትካ ናሰ ብራታፐ ኦሰቶ። ");
INSERT INTO gofe_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","“ጌሻ ዱንካንያን ጎኤትያ ሚሸ ኡባይ፥ ዱንካንያነ ዳባባ ꬍሸት ኡባይ ናሰ ብራታፐ ኦሰቶ። ");
INSERT INTO gofe_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“ፆምፐይ ቃማ ፖእሸ አቃና መላ ጉምእ ፅልስዳ ሻማሆ ዛይተ ነዉ ኤሀና መላ እስራኤለ አሳ ኪታ። ");
INSERT INTO gofe_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","አሮንነ እያ ናይት፥ ፖኦይ፥ ጎዳ ስንꬃን ኦማርሳፈ ዎንታ ጋካናዉ ፖአና መላ ጌሻ ዱንካንያ ግዶን፥ ማርካ ታቦትያ ስንꬃን ደእያ ማጋራጁዋፈ ካረ ባጋራ ኤꬆ። ሄስ እስራኤለ አሳስ መርና ዎጋ ግድድ ደኦ። ");
INSERT INTO gofe_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“ነ እሻ አሮናነ እያ ናይታ ናዳባ፥ አብዮዳ፥ አላዛራነ እታማራ ኔኮ ፄጋ። ኤንቲ ካህነ ግድድ ታዉ ሀጋዛና መላ እስራኤለ አሳ ግዶፈ ኤንታ ዱማያ። ");
INSERT INTO gofe_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","እያዉ ቦንቾነ ቴማ እማና መላ ነ እሻ አሮናስ ቦንቾ ማኦታ ጊግሳ። ");
INSERT INTO gofe_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","አሮን ካህነተꬃን ዱማትድ ታዉ ሀጋዛናዳ፥ ታኒ ሂላተꬅ እምዳ ኦሳንቾታ ኡባ ፄጋዳ፥ አሮናስ ማኦታ ጊግሳና መላ ኦዳ። ");
INSERT INTO gofe_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","ኤንቲ ጊግሳና ማኦትካ ሀይሳታ፤ ትራን ማኤትያ ማኦ፥ ኤፉደ፥ አዱሳ ቃምሰ፥ አሌቀትድ ዳደትዳ ሻምዘ፥ ቃጨነ ዳንጮ። ነ እሻይ አሮንነ እያ ናይት ካህነ ግድድ ታዉ ሀጋዝሸ ማአና መላ ጌሻ ማኦታ ኤንታዉ ጊግሶ። ");
INSERT INTO gofe_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","ኩሸ ሂላንቾት ሄ ማኦታ ዎርቃ ጫቻፈ፥ ካሎሰፐ፥ ኦቻ ቴራ ዳነይሳፈ ዞኦ ቃጭናፐነ አልኦ ሊኖፐ ጊግሶ። ");
INSERT INTO gofe_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“ኤፉደ ጌተትያ ማኡዋ ዎርቃ ጫቻ ቃጭናፐ፥ ካሎሰፐ፥ ኦቻ ቴራ ዳነይሳፈ፥ ዞኦ ቃጭናፐነ አልኦ ሊኖፐ ኩሸ ሂላንቾት አሌቅስድ ጊግሶ። ");
INSERT INTO gofe_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","ናምኡ ሀሽያራ ዎꬍድ፥ ናምኡ ባጋ ዎል ጋꬅድ ቃቻናዉ ማድያ ቃንጎት ደኦ። ");
INSERT INTO gofe_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","ኤፉደይ ኦሰትዳባፐ ሂላን ኦሰትዳ ዳንጮይ ኤፉድያራ ዎላ ኦሰትዳባ ግድድ እስፈ ኦይከቶ። ");
INSERT INTO gofe_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","ማርግደ ጌተትያ ናምኡ ሹቻታ ኤካዳ፥ ታማነ ናምኡ ያይቆባ ናይታ ሱንꬃ ኤንታ ቦላ ዎጫዳ ፃፋ። ");
INSERT INTO gofe_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","ኤንታ የለታ ማራዳ እስ ሹቻ ቦላ ኡሱፑን ሱንꬃታ፥ ሀንኮ ሹቻ ቦላ አትዳ ኡሱፑን ሱንꬃታ ዎጫዳ ፃፋ። ");
INSERT INTO gofe_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","ሀ ናምኡ ሹቻታ ቦላ ታማነ ናምኡ ያይቆባ ናይታ ሱንꬃ ዎጫድ ፃፋናዉ ሂላንቾ ደማ፤ ሄ ፃፈትዳ ሹቻታ ኤፉድያ ቦላ ኦይꬃናዉ እያ ዩሹዋ ዎርቃን ላንፃ። ");
INSERT INTO gofe_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","ያታዳ ታማነ ናምኡ እስራኤለ ሼሻ ቆፍስያባ ግዳና መላ ሀ ናምኡ ሹቻታ ኤፉድያራ ኦይꬃዳ ሀሽያራ አꬍያ ቃንጉዋ ቦላ ዎꬃ። ታኒ፥ ጎዳይ፥ ታ አሳ ኡባ ዎደ ሀሳያና መላ አሮን ኤንታ ሱንꬃ ባ ሀሽያን ቶኮ። ");
INSERT INTO gofe_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","ሄ ሹቻታ ኦይከይሳ ዎርቃፈ ኦꬃ። ");
INSERT INTO gofe_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","ቃስ ዋላህ ባይና ዎርቃፈ ዎዶሮዳ ዶቀትዳ ናምኡ ሳንꬃላታ ሀሽያራ አꬍያ ቃንጉዋራ ኦይከታና መላ ኦꬃ። ");
INSERT INTO gofe_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“ጎዳ ሸንያ ኦይችድ ኤራናዉ፥ ትራን ማኤትያ ማኡዋ ኩሸ ሂላንቾን ኦስሳ። ሄ ትራን ማኤትያ ማኡዋ ዎርቃ ጫቻ ቃጭናፐ፥ ካሎሰፐ፥ ኦቻ ቴራ ዳነይሳፈ፥ ዞኦ ቃጭናፐነ አልኦ ሊኖፐ ኤፉድያዳ አሌቅስድ ጊግሶ። ካሎሰፐ ኦሰትዳባፐ ኦꬃዳ አሌቅሳ። ");
INSERT INTO gofe_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","እያዉ ጌሳይነ ጎምፓይ እስ እስ ታካꬎ ግድድ ኦይዱ ማዛነይ ደኦ። ");
INSERT INTO gofe_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","እያዉ ኦይዱ ማራን አልኦ ሹቻታ ዎꬃ። ኮይሮ ማራን ሳርድዮነ፥ ቶጳዘነ ጶልያ አልኦ ሹቻታ ዎꬃ። ");
INSERT INTO gofe_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","ናምአንꬆ ማራን ባሉረ፥ ሳንፐረነ አልማዘ ጌተትያ አልኦ ሹቻታ ዎꬃ። ");
INSERT INTO gofe_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","ሄꬓንꬆ ማራን ያክንተ፥ ከልቀዶነነ አመተስፅኖሳ ጌተትያ አልኦ ሹቻታ ዎꬃ። ");
INSERT INTO gofe_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","ኦይዳንꬆ ማራን ብረለ፥ ማርግደ፥ ያስጵደ ጌተትያ አልኦ ሹቻታ ዎꬃ። ሀይሳቲ ኡባይ ዎርቃ ካቁዋ ቦላ ዎሰቶ። ");
INSERT INTO gofe_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","እስራኤለ ናይታስ ቆፍሶ ግዳና መላ ሀ ታማነ ናምኡ አልኦ ሹቻታ፥ እስ እስ ያይቆባ ናይታ ሱንꬃይ፥ እስ እስ ሹቻ ቦላ ዎጨትድ ፃፈቶ። ");
INSERT INTO gofe_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“ትራን ማኤትያ ማኡዋስ ዋላህ ባይና ዎርቃፈ ዎዶሮዳ ዶቃዳ ሳንꬃላታ ኦꬃ። ");
INSERT INTO gofe_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","ናምኡ ዎርቃ ምግዶታ ኦꬃዳ፥ ትራን ማኤትያ ማኡዋስ ቆሞ ጋፃ ማዛንያን ጋꬃዳ ኦይꬃ። ");
INSERT INTO gofe_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","ሄ ናምኡ ዎርቃ ሳንꬃላታታ ምግዶታራ ጋꬃዳ ኦይꬃ። ");
INSERT INTO gofe_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","ሀንኮ ባጋን ደእያ ናምኡ ሳንꬃላታ ጋፃ ናምኡ ቃንጎታራ ጋሰꬃ። ሄሳዳ ኦꬃዳ ስንꬃ ባጋራ፥ ሀሽያራ ዎꬍያ ኤፉድያ ቃንጉዋራ ጋሰꬃ። ");
INSERT INTO gofe_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","ቃስ ናምኡ ዎርቃ ሳጋዮታ ኦꬃዳ፥ ኤፉድያፐ ጋꬃ ባጋራ ካልድ ደእያ ትራን ማኤትያ ማኡዋስ ናምኡ ማዛነታ ፄራን አꬃ። ");
INSERT INTO gofe_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","ሄሳዳካ፥ ዎርቃፈ ሀራ ናምኡ ምግዶታ ኦꬃዳ፥ ኤፉድያስ ስንꬃ ባጋ ሀሽያራ ዎꬍያ ቃንጉዋስ ጋርሳ ባጋራ ጋሰꬃ። ኤፉድያ ስኩዋ ማታን ዳንጩዋፈ ቆሞ ባጋራ ኤንታ ጋሰꬃናዉ በሴስ። ");
INSERT INTO gofe_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","ትራን ማኤትያ ማኡዋን ደእያ ምግዶታ ኤፉድያን ደእያ ምግዶታራ ጋꬃዳ ካሎሰ ቃጭናን ቃቻ። ሄሳዳ ኦꬅኮ፥ ትራን ማኤትያ ማኦይ ፄሳፈ ቆሞን ደእያ ግሾ፥ ቃሾይ ዶልኤና። ");
INSERT INTO gofe_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“አሮን ጌሻ በሳ ገልያ ዎደ እስራኤለ ማይዛታ ሱንꬃ ኦይክዳ፥ ትራን ማኤትያ ማኡዋ ማኦ። ያንያ ግሾ፥ ታኒ፥ ጎዳይ ኡባ ዎደ ታ አሳ ቆፓና። ");
INSERT INTO gofe_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","ቃስ ሳማ የግያ ናምኡ ጌሻ ሹቻታ ትራን ማኤትያ ማኡዋን የጋ። አሮን ጌሻ ዱንካንያ ገልያ ዎደ ባ ትራን ኤንታ ቶክድ ገሎ። ታ ሸንያ እስራኤለ አሳ ኤርሳናዉ ታ ስን ገልያ ዎደ ኡባን ትራ ኪስያፐ ꬋይሶፎ። ");
INSERT INTO gofe_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“ኤፉድያፐ ቦላራ ማእያ አዱሳ ማኡዋ ኩመꬅ ካሎሰ አፍላፐ ጊግሳ። ");
INSERT INTO gofe_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","ሄ አዱሰ ማኡዋስ ሁጰ አꬅያ ሉሆ መꬋ። ሄ ሉሆይ ፔቶና መላ ጉየ ቃላምአዳ ዩሻ አꬃዳ ስካ። ");
INSERT INTO gofe_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","አዱሳ ማኡዋስ ዱገ ባጋ ማጫራ ዩሹዋን ካሎሰ፥ ኦቻ ቴራ ዳነይሳንነ ዞኦ ቃጭናፐ፥ ኦሮማነ ቴራ ምስለ መꬋ። ያታዳ ኤንታ ግዶን አꬃ አꬃ ዎርቃፈ ኦሰትዳ ዳላታ ኦꬃ። ");
INSERT INTO gofe_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","ዎርቃ ዳላትነ ኦሮማነ ቴራ ምስለት ሄ አዱሰ ማኡዋስ ዱገ ባጋ ማጫራ ዩሹዋን አꬎ። ");
INSERT INTO gofe_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","አሮን ካህነተꬃን ኦꬅያ ዎደ ሀ አዱሳ ማኡዋ ማኦ። ጎዳ ስን፥ ጌሻ በሳ ገልያ ዎደነ ከይያ ዎደ፥ ዳላይ ጊራና፤ እካ ሀይቀና። ");
INSERT INTO gofe_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","ዋላህ ባይና ዎርቃፈ እስ አሌቆ ኦꬃዳ፥ እያ ቦላ ‘ጎዳስ ዱማትስ’ ያጋዳ ዎጫዳ ፃፋ። ");
INSERT INTO gofe_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","ያታዳ ሁጵያ ቃጭያ ቦላ ካሎሰ ቃጭናራ ቃቻ። ");
INSERT INTO gofe_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","አሮን እያ ባ ሶምኡዋን ዎꬆ። ሄሳን እስራኤለ አሳይ ጎዳስ እሞታ እምሸ ባልዳባይ ደእኮ፥ ሄ ባላ አሮን ቶኬስ። አሳይ ኤህያባ ጎዳይ ኤካና መላ እ ሄሳ ኡባ ዎደ ባ ሶምኡዋን ዎꬃናዉ ኮሼስ። ");
INSERT INTO gofe_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“አሮና ሻምዝያነ ቃጭያ አልኦ ሊኖፐ ዳዳ። ቃስ ዳንጩዋካ አልኦ ሊኖፐ ዳዳዳ አሌቅሳ። ");
INSERT INTO gofe_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","አሮና ናይታስ ቦንቾነ ፑላ እማና መላ ሻምዘታ፥ ዳንጮታነ ሁጰን ዎꬅያ ቆበታ ጊግሳ። ");
INSERT INTO gofe_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","ኔኒ ሀ ማኦታ ነ እሻ አሮናነ እያ ናይታ ማይዛ። ኤንቲ ካህነተꬃን ታዉ ሀጋዛና መላ ኤንታ ሻማሆ ዛይተን ትያዳ ታዉ ዱማያ። ");
INSERT INTO gofe_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","ኤንታ ካሎይ ካመታና መላ ጋርሳን ማእያ ማኡዋ ፄሳፈ ብድ ዎድረ ጋካናዉ ካምያባ አልኦ ሊኖፐ ጫርቀፈ ሱረ ጊግሳ። ");
INSERT INTO gofe_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","አሮንነ እያ ናይት ጌሻ ዱንካንያ ገልያ ዎደ ዎይኮ ጌሻ በሳን ካህነተꬃን ሀጋዛናዉ ያርሾ በሲ ሺቅያ ዎደ ሀ ማኦታ ማኦ። ሄሳዳ ሀንኮ፥ ኤንቲ ባንታ ቦላ ሀይቆ ኤሆኮና። ሄስ አሮናስነ እያ ሼሻታስ መርና ዎጋ ግዶ። ");
INSERT INTO gofe_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“አሮንነ እያ ናይት ካህነተꬃን ታዉ ሀጋዛና መላ ኔኒ ኤንታ ዱማያናዉ ሀይሳዳ ኦꬃ፤ ቦረይ ባይና ዎፋኖነ ናምኡ ማራዘ ኤካ። ");
INSERT INTO gofe_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","ጌሻ ግስተ ꬊለ ኤካዳ፥ እርሾ የጎና ሻማሆ ዛይተራ ግንዳዳ ኡይꬁ ኡካ። ቃስ ዛይተይ ገሎና ሀራ ኡይꬁ ኡካ፤ ሄሳዳካ፥ ሌኦ ኡይꬁ ኡካዳ ዛይተን ትያ። ");
INSERT INTO gofe_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","ዎፋኑዋነ ናምኡ ማራዘታ ያርሽያ ዎደ ሄ ኡይꬃ ኡባ ጋይታን ዎꬃዳ ታዉ ሺሻ። ");
INSERT INTO gofe_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","“ያታዳ አሮናነ እያ ናይታ ጌሻ ዱንካንያ ፐንገ ኤሀዳ ሃꬃን ኤንቲ ሜጨታና መላ ኦዳ። ");
INSERT INTO gofe_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","ሄሳፈ ጉየ፥ ካህነተꬃ ማኦታ፥ ሻምዝያ፥ ኤፉድያ፥ ኤፉድያ ቦላራ ማእያ አዱሳ ማኡዋነ ትራን ማኤትያ ማኡዋ አሮና ማይዛ፤ ዳንጩዋካ ዳንጭሳ። ");
INSERT INTO gofe_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","ቃጭያ ቃጭሳ፤ እያ ቦላ፥ ‘ጎዳስ ዱማትስ’ ጌተትድ ፃፈትዳ ዎርቃ አሌቁዋ ዎꬃ። ");
INSERT INTO gofe_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","ትሻ ዛይትያ ኤካዳ እያ ሁጵያን ትጋዳ ትያ። ");
INSERT INTO gofe_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","እያ ናይታ ኤሀዳ ሻምዝያ ማይዛ። ");
INSERT INTO gofe_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","ኤንታ ፄሳ ዳንጭሳ፤ ኤንታ ሁጵያንካ ቆበ ዎꬃ። አሮናነ እያ ናይታ ያታዳ ካህነተꬃን ሹማ። ሄስካ፥ ኤንታዉ መርና ዎጋ ግዶ። ");
INSERT INTO gofe_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“ዎፋኑዋ ጌሻ ዱንካንያ ስን ኤሀዳ፥ አሮንነ እያ ናይት እያ ሁጵያን ባንታ ኩሽያ ዎꬃና መላ ኦꬃ። ");
INSERT INTO gofe_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","ዎፋኑዋ ጌሻ ዱንካንያ ፐንግያን ጎዳ ስንꬃን ሹካ። ");
INSERT INTO gofe_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","ዎፋኑዋ ሱꬃፈ ጉꬁ ኤካዳ ነ ብራꬍያን፥ ያርሾ በሳ ቦላ ደእያ ካጨታ ትያ። አትዳይሳ ያርሾ በሳፈ ጋርሳን ጉሳ። ");
INSERT INTO gofe_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","ሄሳፈ ጉየ፥ ኡሎ አሹዋ ካምዳ ሞꬉዋ ኡባ፥ ትርያስ ሎኦ ባጋ፥ ናምኡ ክላሆታነ ኤንታ ካምዳ ሞꬉዋ ኤካዳ፥ ያርሾ በሳ ቦላ ዎꬃዳ ፁጋ። ");
INSERT INTO gofe_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","ሽን ዎፋኑዋ ኡሎ አሹዋ፥ እያ ጋልባነ ማራጭያ ጉታፐ ጋፃ ከሳዳ ፁጋ። ሄስ ካህነታ ናጋራ ቁችያ ያርሾ። ");
INSERT INTO gofe_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“ናምኡ ማራዘታፐ እሱዋ ኤካዳ፥ አሮንነ እያ ናይት ባንታ ኩሽያ እያ ሁጰን ዎꬃና መላ ኦꬃ። ");
INSERT INTO gofe_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","ሄ ማራዝያ ሹካዳ፥ ሱꬃ ያርሾ በሳን ኦይዱ ማዛነታን ዉርፃ። ");
INSERT INTO gofe_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","እያ አሹዋ ቃንፀረꬃዳ፥ ኡሎ አሹዋነ ገዳ ሜጫዳ፥ ሁጵያ ሀራ ቆሞ አሾታራ እስፈ ያርሾ በሳን ዎꬃ። ");
INSERT INTO gofe_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","ሄሳፈ ጉየ፥ ኩመꬃ አሹዋ ያርሾ በሳን ፁጋ። ሄስካ ጎዳስ ፁሳ ያርሾ። ሄ ያርሹዋ ሳዎይ ጎዳ ኡፋይሴስ። ");
INSERT INTO gofe_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“ቃስ ካህነተꬃ ዎጋስ ኤከትዳ ሀንኮ ማራዝያ ኤካዳ አሮንነ እያ ናይት ባንታ ኩሽያ እያ ሁጰን ዎꬃና መላ ኦዳ። ");
INSERT INTO gofe_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","እያ ሹካዳ፥ ሱꬃፈ ጉꬁ ኤካዳ፥ አሮናስነ እያ ናይታስ ኡሻቻ ሀይꬃታስ ጋፃ፥ ኤንታ ኡሻቻ ኩሽያስነ ቶሁዋስ ዎጋ ብራታ ትያ። አትዳ ሱꬃ ያርሾ በሳ ኦይዱ ማዛነታን ዉርፃ። ");
INSERT INTO gofe_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","ያርሾ በሳን ደእያ ሱꬃፈነ ትይያ ዛይትያፐ ጉꬁ ኤካዳ፥ አሮና ቦላነ እያ ማኡዋ ቦላ፥ ቃስካ እያ ናይታ ቦላነ ኤንታ ማኡዋ ቦላ ዉርፃ። ሄሳን አሮንነ እያ ናይት ባንታ ማኡዋራ ታዉ ዱማትዳይሳታ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“ሄ ማራዘይ ካህነታ ሹማ ዎጋስ ኤከትያ ግሾ፥ ጎይና ሞꬉዋ፥ ኡሎ አሹዋ ካምዳ ሞꬉዋ፥ ትርያ ካምዳ ሞꬍያ፥ ናምኡ ክላሆታ፥ ኤንታ ካምዳ ሞꬍያነ ኡሻቻ ጉየ ገዳ ቃንፃዳ ሻካ። ");
INSERT INTO gofe_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","ጎዳ ስንꬃን ዎꬅዳ ኡይꬃታፐ፥ ዛይተይ ገልቦና ኡይꬃ፥ ዛይተራ ኡክዳ ኡይꬃነ ሌኦ ኡይꬃፈ እሱዋ ኤካ። ");
INSERT INTO gofe_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","ኔኒ ሀ ካꬃ ኡባ አሮና ኩሽያንነ እያ ናይታ ኩሽያን ዎꬃ። ኤንቲ እያ ዩሾ ያርሾ ኦꬅድ ጎዳስ እምያ ያርሾ ኦꬅድ ጎዳ ስንꬃን ሺሾ። ");
INSERT INTO gofe_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","ሄሳፈ ጉየ፥ ኤንታ ኩሸፐ ኤካዳ ያርሾ በሳ ቦላ ዎꬃ፤ ፁሳ ያርሹዋራ ጋꬃዳ፥ ጎዳ ሳዋና መላ ያርሾ በሳ ቦላ ታማን ፁጋ። ");
INSERT INTO gofe_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","አሮን ካህነ ግድድ ሹመትያ ዎደ ሹክዳ ማራዝያ አንጋሱዋ ኤካዳ፥ ጎዳ ስንꬃን ዩሾ ያርሾ ኦꬃ። ሄስ ህንተና ጋክያ ግሾ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","“ካህነይ ሹመትያ ዎደ፥ አሮናነ እያ ናይታ ካህነተꬃን ሹማናዉ ኤከትዳ አንጋሱዋነ ቶሆ አሹዋ ታዉ ዱማያ። ሄስካ፥ ካህነታ ጋክያ ግሾ ግዶ። ");
INSERT INTO gofe_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","እስራኤለት ኡባይ ካህነ ሹማናዉ ዎይኮ አንጀታናዉ ጎዳስ አንጋሶነ ጉየ ቶሆ ያርሾ እምያ ዎደ አሾይ ታዉ ዱማትዳይሳ ግዶ። ሽን ግሾይ አሮናስነ እያ ናይታስ ጋኮ፤ ሄ ዎጋይ ላመቶፎ። ");
INSERT INTO gofe_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“አሮን ሀይቅዳ ዎደ እያ ናይት እያ ካህነተꬃ ማኡዋ ላቶ። ኤንቲ ካህነተꬃን ሹመትዳፐ ጉየ ሄ ማኡዋ ማኦ። ");
INSERT INTO gofe_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","እያ ናይታፐ እያ በሳን ካህነ ግድድ፥ ጌሻ በሳን ሀጋዛናዉ ጌሻ ዱንካንያ ይያ ናእ ሄ ማኡዋ ላፑን ጋላስ ማኦ። ");
INSERT INTO gofe_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“አሮንነ እያ ናይት ካህነ ግድድ ሹመትያ ዎደ ሹከትዳ ማራዝያ አሹዋ ኤካዳ፥ ጌሻ በሳን ካꬃ። ");
INSERT INTO gofe_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","አሮንነ እያ ናይት ማራዝያ አሹዋ ጋይታን አትዳ ኡይꬃራ ጌሻ ዱንካንያ ፐንገን ሞ። ");
INSERT INTO gofe_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","ኤንቲ ካህነ ግድድ ሹመትያ ዎደ ናጋራ አቶተꬃስ ያርሸትዳ ሄ አሹዋ ሞና። ሽን ሄ ካꬃይ ጌሽ ግድዳ ግሾ፥ ካህነታ ፃላል ሞ፤ ሀራ አስ ኦንካ ሞፖ። ");
INSERT INTO gofe_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","አሹዋፐነ ካꬃፈ ምሽን አትድ አቅኮ፥ ታማን ፁገቶ፤ ጌሽ ግድዳ ግሾ ሜተቶፎ። ");
INSERT INTO gofe_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“አሮንነ እያ ናይት ካህነ ግድድ ሹመትያ ዎደ፥ ታ ነና ኪትዳ ኡባ ኦꬃ፤ ባለይ ላፑን ጋላሳን ፖለቶ። ");
INSERT INTO gofe_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","ናጋራ አቶተꬃስ እስ እስ ጋላሳን እስ ዎፋኖ ሹካዳ ያርሻ። ሄስ ያርሾ በሳ ጌሼስ። ያታዳ ያርሾ በሳ ፖሎ ጌሻናዉ ሻማሆ ዛይተ ትያ። ");
INSERT INTO gofe_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","ሄሳ ላፑን ጋላስ ጋካናዉ ጋላስ ጋላስ ኦꬃ። ያትኮ ያርሾ በሳይ ፖሎ ጌሽ ግዳና። እ ፖሎ ጌሽ ግድዳ ግሾ፥ እያ ቦችያ አስ ዎይኮ ሀራባ ኡባይ ጌያና። ");
INSERT INTO gofe_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“ላይꬃን ላይꬃን ያርሾ በሳን ጋላስ ጋላስ እስ ላይꬅ ግድዳ ናምኡ ማራዘታ ያርሻ። ");
INSERT INTO gofe_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","ማራዘታፐ እሱዋ ዎንታ፥ ቃስ ሀንኩዋ ኦማርስ ያርሻ። ");
INSERT INTO gofe_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","ኮይሮ ማራዝያራ እስ ክሎ ግራመ ግድያ ጌሻ ሎኦ ግስተ ꬊለ፥ እስ ልትሮ ሻማሆ ዛይተራ ግንዳዳ ያርሻ። እስ ልትሮ ዎይነ ኡሻ ያርሾ ኦꬃዳ ጉሳ። ");
INSERT INTO gofe_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","ሀንኮ ማራዝያ ኦማርስ ያርሻሸ ዎንታ ያርሾይሳ መላ ꬊለ፥ ዛይተነ ዎይነ ኡሻ ሺሻ። ሄስ ታዉ ያርሸትያ ካꬃ ያርሾ፤ እያ ሳዎይ ታና ኡፋይሰይሳ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","“ላይꬃን ላይꬃን ሄ ፁሳ ያርሾይ ጌሻ ዱንካንያ ፐንገን፥ ጎዳ ስንꬃን ፓጭ ባይና ያሸታናዉ በሴስ። ሄ በሳን ታኒ ታ ደርያራ ጋሄታና፤ ኔራካ ያን ኦደታና። ");
INSERT INTO gofe_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","ያን ታኒ እስራኤለታራ ጋሄታና፤ ታ ቦንቾይ ሄ በሳ ዱማያና። ");
INSERT INTO gofe_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","ታኒ ጌሻ ዱንካንያነ ያርሾ በሳ ዱማያና፤ ኤንቲ ታዉ ካህነ ግድድ ሀጋዛና መላ አሮናነ እያ ናይታ ዱማያና። ");
INSERT INTO gofe_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","ያታዳ፥ ታኒ እስራኤለታ ግዶን ዳና፤ ኤንታ ፆሳ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","ኤንታ ግዶን ዳናዉ ግብፀፈ ኤንታ ከስዳ ጎዳይ፥ ኤንታ ፆሳይ ታና ግደይሳ ኤንቲ ኤራና። ታኒ ጎዳ፥ ኤንታ ፆሳ። ");
INSERT INTO gofe_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“እፃነ ጩይስያ በሳ ሶቃላ ምꬃፈ መꬋ። ");
INSERT INTO gofe_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","እያዉ ኦይዱ ማዛነይ ደኦ። አዱሳተꬃይነ ጎምፓይ እስ እስ ዋꬋ፥ ጌሳይ ናምኡ ዋꬋ ግዶ። ኦይዱ ማዛንያን ደእያ ካጨት እያራ ኦይከትድ ኦሰቶና። ");
INSERT INTO gofe_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","እያዉ ቦላ ባጋ፥ እያ ኦይዱ ማዛነታነ እያ ካጨታ ዋላህ ባይና ዎርቃን ላንፃ። እያ ዩሹዋካ ዎርቃን ላንፃ። ");
INSERT INTO gofe_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","ናምኡ ዎርቃ ሳጋዮታ ኦꬃዳ፥ ፃርጴዛ ቶካናዉ ማድያ ካሶ ምꬃታ አꬃናዉ ጎሳስ ናምኡ ባጋራ ኦይꬃ። ");
INSERT INTO gofe_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","ካሶ ምꬃታ ሶቃላ ምꬃፈ ከሳዳ፥ ኤንታ ዎርቃን ላንፃ። ");
INSERT INTO gofe_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","ሄ እፃነ ያርሾ ፃርጴዛ፥ ጫቆ ታቦትያ ስንꬃን ካቀትዳ ማጋራጁዋፈ ካረ ባጋራ ዎꬃ። ያን ታኒ ኔራ ጋሄታና። ");
INSERT INTO gofe_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“አሮን ዎንታ ዎንታ ፆምፐታ ጊግሳናዉ ይያ ዎደ፥ ሳውያ እፃነ ያርሽያ በሳን ጩይሶ። ");
INSERT INTO gofe_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","ሄሳዳ፥ አሮን ኦማርስ ፆምፐታ ፆምፕያ ዎደካ እፃነ ጩይሶ። ሄ እፃንያ ያርሾይ ያና ላይꬃ ኡባን ጎዳ ስንꬃን ጩዮ። ");
INSERT INTO gofe_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","ሀ ያርሾ በሳን ሀራ ድገትዳ እፃነ፥ ካꬃ ያርሾ፥ መሄ ያርሾነ ዎይነ ያርሾ ያርሾፋ። ");
INSERT INTO gofe_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","አሮን፥ ናጋራ አቶተꬃስ ላይꬃፈ እስ ቶሆ ሹከትያ መህያ ሱꬃፈ ኤክድ፥ ሄ ያርሾ በሳ ማዛነታ ቦላ ደእያ ካጨታ ዎꬅድ ጌሾ ዎጋ ፖሎ። ሀ ዎጋይ ስንꬃራ ያና ዎደ ኡባን ላይꬃን ላይꬃን ፖለቶ። ሄ ያርሾ በሳይ ጌሽ ግድያ ግሾ ጎዳስ ዱማትስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","ሄሳፈ ጉየ፥ ጎዳይ ሙሰኮ ሀይሳዳ ያግስ፤ ");
INSERT INTO gofe_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“ኔኒ እስራኤለ አሳ ታይብያ ዎደ፥ እስ እስ አስ ባ ሸምፑዋ ዎዛናዉ ጎዳስ ሚሸ ቃንፆ። ያትኮ ኔኒ ኤንታ ታይብያ ዎደ ጋዶይ ኤንታ ቦላ ዬና። ");
INSERT INTO gofe_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","ታይቦን ገልያ አስ ኦንካ ሁጰን ሁጰን ጌሻ ዱንካነን ኤረትዳ ምዛነ ግናን ብራ ጭጎ። እስ እስ አስ ሄሳ ታዉ ያርሾ ኦꬅድ እሞ። ");
INSERT INTO gofe_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","ታይቦን ገልያ አስ ኦንካ ላይꬅ ላታማነ እያፐ ቦላ ግድዳ ኡባይ ጎዳስ ሄሳ ኤሆ። ");
INSERT INTO gofe_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","ኤንቲ ባንታ ሸምፑዋ ዎዛናዉ ጎዳስ እሞታ እምያ ዎደ፥ ዱረይካ ማንቆይካ እስ ግና እሞፈ አትሽን፥ ዱረይ ዳርስድ ዎይኮ ማንቆይ ጉꬅድ እሞፎ። ");
INSERT INTO gofe_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","ሄ ሚሽያ እስራኤለ አሳፐ ኤካዳ፥ ጌሻ ዱንካንያ ናጋናዉ ፔሻ። ሄ ሚሸይ ኤንታ ሸምፑዋ ዎዛናዉነ ታ ኤንታ ናጋና መላ ቆፍስያባ ግዳና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","ጎዳይ ሙሰኮ ሀይሳዳ ያግስ፤ ");
INSERT INTO gofe_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“ሜቻ ከርያነ እያ ቶሁዋ ናሰ ብራታፐ መꬋ። እያን ሃ ትጋዳ ጌሻ ዱንካንያፐነ ያርሾ በሳፈ ግዶን ዎꬃ። ");
INSERT INTO gofe_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","አሮንነ እያ ናይት ባንታ ኩሽያነ ባንታ ቶሁዋ ያን ሜጨቶ። ");
INSERT INTO gofe_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","ኤንቲ ጌሻ ዱንካንያ ገላናፐነ ያርሾ ያርሻናፐ ስን ሄሳ ኦꬃናዉ በሴስ። ሄሳ ኤንቲ ኦꬅኮ ሀይቆፐ አቶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","ኤንቲ ሀይቆና መላ፥ ባንታ ኩሽያነ ባንታ ቶሁዋ ሜጨታናዉ በሴስ። ሄስ አሮናስነ እያ ሼሻታስ፥ ይያ የለተꬃ ኡባስ መርና ዎጋ ግዳና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","ጎዳይ ሙሰኮ ሀይሳዳ ያግስ፤ ");
INSERT INTO gofe_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“ጌሻ ሳዎታ፥ ሄሳትካ፤ ኡሱፑን ክሎ ግራመ ጉክያ ካርበ፥ ሄꬑ ክሎ ግራመ ሳውያ ቃራፋ፥ ሄꬑ ክሎ ግራመ ሳውያ ማታ፥ ");
INSERT INTO gofe_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","ኡሱፑን ክሎ ግራመ ቡርጉደ ኤካ። ሄ ኡባይካ ጌሻ ዱንካነን ኤረትዳ ምዛንያ ግና ግዶ። ሄሳታ ቦላ ኦይዱ ልትሮ ዛይተ ጉጃ። ");
INSERT INTO gofe_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","ሄሳታ ሽቶዳ ዋላካዳ፥ ሳውያ ጌሻ ዛይተ ኦꬃዳ፥ ");
INSERT INTO gofe_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","ጌሻ ዱንካንያነ ጫቆ ታቦትያ ትያ። ");
INSERT INTO gofe_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","ፃርጴዛነ እያ ሚሸታ፥ ፆምፐ ዎꬅያ ኮጫነ እያ ሚሸታ፥ እፃነ ጩይስያ ፃርጴዛ፥ ");
INSERT INTO gofe_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","ፁሳ ያርሾ በስነ እያን ቦላ ደእያ ሚሸታ ኡባ፥ ሜቻ ከርያነ እያ ቶሁዋ ትያ። ");
INSERT INTO gofe_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","ኤንቲ ፖሎ ጌሽ ግዳና መላ ኤንታ ዱማያ። ኤንታ ቦችያ ኦንካ ጌሽ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“ሄሳፈ ጉየ፥ አሮንነ እያ ናይት ካህነ ግድድ ታዉ ሀጋዛና መላ ኤንታ ትያዳ ዱማያ። ");
INSERT INTO gofe_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","እስራኤለ አሳስ፥ ‘ሀይስ ጌሻ ሹማተꬃ ዛይተይ ይያ የለተꬃስ ታና ሀጋዛናዉ ማድያ ዛይተ ግዶ። ");
INSERT INTO gofe_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","ሄ ዛይትያ ጮ አሳ ቦላ ጉሶፋ፤ ቃስ አይ ዛይተካ እያ ኦꬅዳ ኦግያን ኦꬆፋ። ዛይተይ ጌሽ ግድዳ ግሾ፥ ህንተካ እያ ጌሻተꬃ ኤርተ። ");
INSERT INTO gofe_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","ሄ ሽቱዋ ጊግስያ አስ፥ ዎይኮ ካህነ ግዶና ሀራ አስ ትይያ ኦንካ ታ አሳ ግዶፈ ህለቶ’ ያጋ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","ጎዳይ ሙሰኮ ሀይሳዳ ያግስ፤ “ጌሻ ሳዎታ፥ ፆክያ ምꬃ ማደ፥ ꬋ ኬꬃን ደእያ ሽቶ፥ ሳውያ ማደነ ሳውያ እፃነ ኤካ፤ ኤንታ ኡባ ምዛነይ እስ ግና ግዶ። ");
INSERT INTO gofe_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","ሽቶዳ ዋላሄትዳ እፃነ ኦꬃዳ ኤንታ ጎኤታ። ዋላህ ባይናነ ጌሽ ግዳና መላ እያን ማፅነ የጋ። ");
INSERT INTO gofe_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","እያፐ ጉꬃራ ኤካዳ ሊቅሳ ጫዳዳ፥ ታኒ ኔራ ጋሄትያ ጌሻ ዱንካንያ ግዶን፥ ጫቆ ታቦትያ ስንꬃን ዉርፃ። ሄ እፃነይ ነዉ ፖሎ ጌሽ ግዶ። ");
INSERT INTO gofe_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","ህንተዉ ጎኤታናዉ ሄ እፃንያ አይ ኦገንካ ጊግሶፕተ። ሄስ ታዉ ዱማትዳይሳ ግደይሳ ኤርተ። ");
INSERT INTO gofe_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","ሄሳꬆ ኦꬅድ፥ እያ ሳዉዋ ስንግድ ኡፋይታናዉ ኮይያ ኦንካ፥ ታ አሳ ግዶፈ ꬋያና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","ጎዳይ ሙሰኮ ሀይሳዳ ያግስ፤ ");
INSERT INTO gofe_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“ታኒ ይሁዳ ሼሻፐ ግድዳ ሁራ ናኣ ናኣ፥ ኡረ ናኣ፥ ባስልኤላ ዶራስ። ");
INSERT INTO gofe_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","ታኒ እያ ታ አያናን ኩንꬃስ፤ ታኒ ሂላ፥ አኬካነ ኦሶ ኡባ ኦꬅያ ኤራ እያዉ እማስ። ");
INSERT INTO gofe_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","ሄስካ፥ ሂላን ኦꬃና ኦሶታ ሀልችድ ዎርቃፈ፥ ብራፐነ ናሰ ብራታፐ ዱማ ዱማባ ከስድ ኦꬃናሳ። ");
INSERT INTO gofe_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","ሄሳዳካ፥ አልኦ ሹቹ ማስድ ጊግሰይሳ፥ ምꬅ ማሰይሳነ ሀራ ኦሶ ኡባ ኦꬃና መላ ጭንጫተꬅ እማስ። ");
INSERT INTO gofe_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","ቃስ እያ ማዳና መላ ዳነ ሼሽ ግድዳ አህሳማካ ናኣ ኤልያባ ዶራስ። ታኒ ነና ኪትዳባ ኡባ ኤንቲ ኦꬃና መላ ኩሸ ሂላ ኤርያ ሀራታ ኡባስ ግታ ኤራተꬅ እማስ። ");
INSERT INTO gofe_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","ኤንቲ ኦꬃናባት፥ ጌሻ ዱንካንያ፥ ጫቆ ታቦትያ፥ እያ ቦላ ዎꬅያ ናጋራ አቶተꬃ ካማ፥ ዱንካንያ ግዶን ጎኤትያ ሚሸ ኡባ፥ ");
INSERT INTO gofe_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","ፃርጴዛነ እያ ሚሸታ፥ ዋላህ ባይና ዎርቃፈ ኦሰትዳ ፆምፐ ዎꬅያ ኮጫነ እያ ሚሸ ኡባ፥ እፃነ ጩይስያ ፃርጴዛ፥ ");
INSERT INTO gofe_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","ፁሳ ያርሾ በስነ እያ ሚሸ ኡባ፥ ሜቻ ከርያነ እያ ቶሁዋ፥ ");
INSERT INTO gofe_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","አሮንነ እያ ናይት ካህነተꬃን ሀጋዝሸ ማእያ ካህነተꬃ ማኡዋ፥ ");
INSERT INTO gofe_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","ሹማተꬃ ዛይትያነ ጌሻ በሳስ ሀንያ ሳውያ እፃንያ፥ ታኒ ነና ኪትዳይሳዳ ኤንቲ ኦꬃና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","ጎዳይ ሙሰ ሀይሳዳ ያግድ ኪትስ፤ ");
INSERT INTO gofe_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“እስራኤለ አሳ፥ ‘ታ ሳምባታ ናግተ። ሄስ ታኒ፥ ጎዳይ፥ ህንተና ታዉ ጌሻ ደረ ኦꬃዳ ዶርዳይሳ በሲያ ማላ ግድድ፥ ያና የለተꬃ ኡባስ ታፐነ ህንተፈ ግዶን ደኦ። ");
INSERT INTO gofe_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","ሄ ጋላሳይ ጌሽ ግድያ ግሾ፥ እያ ቦንችተ። ሳምባታ ቦንቾናይነ ሄ ጋላሳን ኦሶ ኦꬅያ ኦንካ ታ አሳ ግዶፈ ꬋዮ ዎይኮ ሀይቆ። ");
INSERT INTO gofe_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","ህንተ ኦሶ ኦꬃናዉ በሲያ ኡሱፑን ጋላሳት ደኦሶና። ሽን ላፑንꬃ ጋላሳይ ጎዳስ ዱማትዳ፥ ሸምፖ ጋላስ። ሳምባታ ጋላሳን ኦሶ ኦꬅያ ኦንካ ሀይቆ። ");
INSERT INTO gofe_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","እስራኤለ የለተꬃ ኡባይ ሀ ሳምባታ ጋላሳ መርና ጫቆ ማላ ኦꬅድ ቦንቾ። ");
INSERT INTO gofe_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","ታኒ ኡሱፑን ጋላሳን ሳሉዋነ ሳኣ መꬍዳ ግሾነ ላፑንꬃ ጋላሳን ኦሶ አጋዳ ሸምፕዳ ግሾ፥ ታ ግዶንነ እስራኤለታ ግዶን ሄስ መርናዉ ኤቅድ ደእያ ማላ ግዳና’ ያጋ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","ጎዳይ ሙሰ ሲና ዙማ ቦላ ኦድሰይሳ ኦንግዳ ዎደ፥ እ ባ ብራን ፃፍዳ ታሙ ኪታታ ኦይክዳ ናምኡ ሎቸ ሹቻታ ሙሰስ እሚስ። ");
INSERT INTO gofe_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","አሳይ፥ ሙሰይ ዙማ ቦላፈ ዎꬋናዉ ጋምእዳይሳ በእዳ ዎደ አሮናኮ ይድ፥ “ኑና ካለꬅሸ ናጋና ፆሳታ ኑስ ኦꬃ። ግብፀ ቢታፈ ኑና ከስዳ ሙሰይ ዋንዳኮ ኤሮኮ” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","አሮን ኤንታኮ፥ “ህንተ ማቸታ፥ ህንተ አደ ናይታነ ህንተ ማጫ ናይታ ሀይꬃን ደእያ ዎርቃ ከስድ፥ ታዉ ሃ ኤክድ ዪተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","አሳ ኡባይ ባንታ ሀይꬃ ዎርቃ ከስድ፥ አሮናስ ኤህዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","እ ሄሳ ኤንታፈ ኤክድ፥ ታማን ሼሽዳፐ ጉየ፥ ቆፅድ፥ ዎርቃ ማራ ምስለ ኦꬅድ መꬍስ። ኤንቲ፥ “እስራኤለቶ፥ ኑና ግብፀ ቢታፈ ካለꬅድ ከስዳ ኑ ፆሳት ሀይሳታ” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","አሮን ሄሳ በእዳ ዎደ፥ ሄ ማራ ስንꬃን ያርሾ በሰ ጊግስድ፥ “ዎንቶ ጎዳ ቦንችያ ባኣለ ጋላስ ግዳና” ያግድ ኤርስስ። ");
INSERT INTO gofe_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","ዎንተꬃ ጋላስ ጉራ አሳይ ደንድድ፥ ፁሳ ያርሾነ እስፈተꬃ ያርሾ ያርሽዶሶና። ያትድ፥ አሳይ ማናዉነ ኡያናዉ ኡትዶሶና። ም ኡይ ስሚድ፥ ዱራናዉነ ፖኮባ ሀናናዉ ደንድዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","ጎዳይ ሙሰኮ፥ “ኔኒ ግብፀፈ ከሳዳ፥ ኤህዳ ነ አሳይ ናጋራ ኦꬅድ፥ ባንታና ቱንስዳ ግሾ ኤለሳዳ ዱገ ዎꬋ። ");
INSERT INTO gofe_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","ታኒ ኤንታ ኪትዳ ኦግያፐ ኤንቲ ኤለስድ ሽረትዶሶና። ዎርቃ ሼሽድ ማራ ምስለ ኦꬅድ፥ ባንታዉ ኤቃ መꬍድ እያ ጎይንዶሶና። እያዉ ያርሽድ፥ ‘ኑና ግብፀ ቢታፈ ከስዳ ኑ ፆሳይ ሀይሳ’ ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","ጎዳይ ሙሰኮ፥ ሀ አሳይ አይ መላ ዎዛና ሙመኮ ታ በአስ። ");
INSERT INTO gofe_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","ሀእ ታ ሀንቆይ ኤንታ ቦላ ኤፅን፥ ታኒ ኤንታ ꬋይሳናዉ ጊገትዳ ግሾ፥ ኔኒ ታና ድጎፋ። ያታዳ፥ ታኒ ነና ግታ ደረ ኦꬃና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","ሽን ሙሰይ ባ ጎዳ፥ ፆሳ ሀይሳዳ ያግድ ዎስስ፤ “አቤት ጎዳዉ፥ ኔኒ ነ ግታ ዎልቃንነ ነ ምኖ ኩሽያን ግብፀፈ ከሳዳ ኤህዳ ነ አሳ ቦላ ነ ሀንቆይ አይስ ኤፂ? ");
INSERT INTO gofe_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","ነ ሄሳ ኦꬅያባ ግድኮ፥ ግብፀት፥ ‘ጎዳይ ኤንታና ደረታ ቦላ ዎꬋናዉነ ቢታፈ ፕትድ ꬋይሳናዉ ከስስ’ አይስ ጋኔ? ነ ያሽያ ሀንቁዋፈ ስማ። ነ አሳ ꬋይሳናዉ ቆፕዳይሳ አጋ። ");
INSERT INTO gofe_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","ነ አይለታ አብራሃመ፥ ይሳቃነ ያይቆባ ሀሳያ። ኔኒ ኤንታዉ፥ ‘ታኒ ህንተ ሼሻ ሳሎ ፆልንቶዳ ዳርሳና፤ ታኒ ህንተዉ እማና ግዳ ሀ ቢታ ኡባ ህንተ ሼሻታስ እማና፤ ኤንቲ ሄ ቢታ መርናዉ ላታና’ ጋዳ ነ ሁጰን ነ ጫቅዳ ጫቁዋ ቆፓ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","ሄሳ ግሾ፥ ጎዳይ ባ ደርያ ቦላ ኢታባ ኤሀናዉ ቆፕዳይሳ አግድ፥ ኤንታ ማርስ። ");
INSERT INTO gofe_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","ሙሰይ ናምኡ ባጋራ ፃፈትዳ፥ ታሙ ኪታት ደእያ ናምኡ ሎቸ ሹቻታ ባ ኩሸን ኦይክድ፥ ዙማፐ ዱገ ዎꬍስ። ");
INSERT INTO gofe_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","ሄ ማሰትዳ ሹቻታ ጊግስዳይ ፆሳ፤ ሹቻታ ቦላ ዎጭድ ፃፍዳይካ ፆሳ። ");
INSERT INTO gofe_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","እያሱይ አሳ ኮሽንቻ ስእዳ ዎደ፥ ሙሰኮ፥ “አሳይ ሲራትዳ በሳን ኦላ ዋሶይ ስኤቴስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","ሙሰይ ዛሪድ፥ “ሀይስ ፆንዳ አሳ ጬቆ ዎይኮ ፆነትዳ አሳ ዬሆ ግዶናሽን፥ የꬃ ዋሶ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","ሙሰይ ጉታኮ ማትዳ ዎደ ማራነ ዱርሳ በእድ ዳሮ ሀንቀትስ። ሄ ዎደ ባ ኩሸን ኦይክድ ይዳ፥ ማሰትዳ ሹቻታ ዙማ ፃጶን ሆልድ መንረꬅስ። ");
INSERT INTO gofe_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","ኤንቲ መꬍዳ ማራ ኤክድ፥ ታማን ፁግስ። ሄሳፈ ጉየ፥ ሊቃና ጋካናዉ ጋጭድ ሃꬃራ ማꬍድ፥ እስራኤለ አሳይ ኡያናዳ ኦꬅስ። ");
INSERT INTO gofe_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","ሙሰይ አሮናኮ፥ “ሀ አሳይ ነዉ አይ ኦꬅን፥ ኤንታ ሀይሳ መላ ኢታ ናጋራ ባንታ ቦላ ኦꬃና መላ ኦꬃዲ?” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","አሮን ዛሪድ፥ “ታ ጎዳዉ፥ ታና ሀንቀቶፋ። ሀ አሳይ ኢታባ ኦꬃናዉ አይ መላ ኮያኮ ነ ኤራሳ። ");
INSERT INTO gofe_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","ኤንቲ፥ ‘ኑና ግብፀፈ ከስድ ኤህዳ፥ ሙሰይ ዋንዳኮ ኑ ኤሮኮ። ሄሳ ግሾ፥ ካለꬅያ ፆሳታ ኑስ ኦꬃ’ ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","ታኒ ኤንታኮ፥ ‘ህንተ ሀይꬃን ደእያ ዎርቃ ከስድ፥ ሀምተ’ ያጋስ። ኤንቲ ታዉ እምዳ ዎርቃ ታኒ ታማን የግን፥ ሀ ማራ ምስለይ ከይስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","አሮን አሳ ጮ የድ አግን፥ አሳይ ባ ሞርከታ ስንꬃን ካዉይድ፥ ካትዳይሳ ሙሰይ በእስ። ");
INSERT INTO gofe_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","ሄሳ ግሾ፥ ሙሰይ ጉታ ገልያ ፐንግያን ኤቅድ፥ “ጎዳ ባጋ ግድያ አስ ኦንካ ታኮ ዮ” ያግስ። ሄ ዎደ ሌወት ኡባይ እያኮ ሺቅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","እ፥ ኤንታኮ፥ “ጎዳይ፥ እስራኤለ ፆሳይ፥ ህንተ እሶይ እሶይ ህንተ ማሻ ሾድድ፥ ጉታስ ሀ ፐንገፈ ህን ፐንገ ጋካናዉ ብድ፥ ህንተ እሻታ፥ ህንተ ላገታነ ህንተ ሾሮታ ዎꬍተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","ሌወት ሙሰይ ኪትዳይሳዳ ኦꬅድ፥ ሄ ጋላስ ሄꬑ ሙኩሉ ግድያ አሳ ዎꬍዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","ሙሰይ ሌወታኮ፥ “ሀች ህንተ፥ ህንተ ናይታነ ህንተ እሻታ ዎꬋናዉ ኪተትድ ህንተና ጎዳስ ዱማይደታ። ጎዳይ ህንተና አንጅስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","ዎንተꬃ ጋላስ ሙሰይ አሳኮ፥ “ህንተ ኢታ ናጋራ ኦꬅደታ፤ ሽን ሀእ ታኒ ጎዳኮ ዙማ ቦላ ከያዳ፥ ኦን ኤር ህንተ ናጋራስ አቶተꬅ ደሞና አግከ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","ያትን ሙሰይ ጎዳኮ ስሚድ ብድ፥ “ሀ አሳይ ኢታ ናጋራ ኦꬅዶሶና፤ ኤንቲ ባንታዉ ዎርቃፈ ፆሰ መꬍዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","ሽን ሀያና፥ ሀእ ኤንታ ናጋራ አቶ ያጋ። ሄስ ሀኖናባ ጊኮ፥ ነ አሳ ነ ፃፍዳ ማዝጋብያፐ ታ ሱንꬃ ቁቻ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","ጎዳይ ዛሪድ ሙሰኮ፥ “ታኒ ታ ማዝጋብያፐ ቁቻና አሳ ሱንꬃይ፥ ታ ቦላ ናጋራ ኦꬅዳይሳታ ሱንꬃ። ");
INSERT INTO gofe_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","ሀእ ባዳ፥ ሀ አሳ ታኒ ነዉ ኦድዳ በሳ ካለꬃ። ታ ኪታንቾይካ ነና ካለꬃናይሳ አኬካ፥ ሽን ታኒ ሀ አሳ ኤንታ ናጋራ ግሾ ሴራና ዎደይ ያናይስ አተና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","አሮን ዎርቃፈ ማራ ምስልያ መꬋናዳ ኦꬅዳይ አሳ ግድያ ግሾ፥ ጎዳይ አሳ ቦላ ዎልቃማ ጋዶ የድስ። ");
INSERT INTO gofe_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","ሄሳፈ ጉየ፥ ጎዳይ ሙሰኮ፥ “ኔንነ ነ ግብፀፈ ከስዳ አሳይ ሀ በሳፈ ደንድድ፥ ታኒ አብራሃመስ፥ ይሳቃስ፥ ያይቆባስነ ኤንታ ሼሻታስ እማና ያጋዳ ጫቅዳ ቢታ ቢተ። ");
INSERT INTO gofe_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","ታኒ ህንተ ስንꬃን ኪታንቹዋ ኪታና። ካናነታ፥ አሞረታ፥ ህተታ፥ ፓርዘታ፥ ህወታነ ያቡሰታ ታኒ ጎዳዳ ከሳና። ");
INSERT INTO gofe_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","ማꬅነ ኤስ ጎግያ ሄ ቢታ ቢተ። ሽን ህንተ፥ ዎዛን ሙምዳ አስ ግድያ ግሾ ታ ህንተና ኦገን ꬋይሶና መላ ህንተራ ቢከ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","አሳይ ሄ ያሽያ ኦዳ ስእድ ዬክዶሶና። ሄ ዎደፐ ዶምድ ኡባይ ባንታ አሌቁዋ አꬅቦኮና። ");
INSERT INTO gofe_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","ጎዳይ ሙሰኮ፥ እስራኤለ አሳስ ሀይሳዳ ያጋዳ ኦዳ ያግስ፤ “ህንተ ዎዛና ሙመ አስ። ታኒ ህንተራ ሀር አቶሽን ጉꬃ ዎደስካ ቢኮ፥ ህንተ ታፐ ꬋያና። ሀእ ህንተ፥ ህንተ አሌቆታ ከስተ፤ ታኒ ህንተ ቦላ ኦꬃናባ በሳና ያጋ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","ሄ ዎደ እስራኤለት ኮሬባ ዙማ አግድ ብዳፐ ጉየ፥ ባንታ አሌቆታ አꬅቦኮና። ");
INSERT INTO gofe_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","እስራኤለ አሳይ ብሸ ሲራትያ ጉታ ኡባን ሙሰይ ዱንካንያ ጉታፐ ሃስድ ቶኬስ። ሄ ዱንካነይ፥ “ጎዳራ ጋሄትያ ዱንካነ” ጌተትድ ፄገትስ። ጎዳ ኦይቻናዉ ኮይያ ኡባይ ይያ ቤስ። ");
INSERT INTO gofe_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","ሙሰይ ዱንካንያኮ ብያ ዎደ አሳ ኡባይ ባ ዱንካንያ ፐንገን ፐንገን ኤቅድ፥ ሙሰይ ይያ ገላና ጋካናዉ እያ በኦሶና። ");
INSERT INTO gofe_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","ሙሰይ ይያ ገልዳፐ ጉየ፥ ሻራ ቱሳይ ዎꬍድ ዱንካንያ ፐንገን ኤቄስ። ጎዳይ ሻራ ግዶን ግድድ ሙሰራ ኦደቴስ። ");
INSERT INTO gofe_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","አሳይ ሻራ ቱሳ ዱንካንያ ፐንግያን በእዳ ዎደ ኡባን፥ ባ ፐንገን ፐንገን ጉልባትድ ጎዳስ ጎይኖሶና። ");
INSERT INTO gofe_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","አስ ባ ላገራ ኦደተይሳዳ ጎዳይ ሙሰራ ሶምኦን ኦደቴስ። ሄሳፈ ጉየ፥ ሙሰይ ጉታ ስሜስ። ሽን እያ ማድያ ናአተꬃይ፥ ናወ ናኣ እያሱይ፥ ጎዳራ ጋሄትያ ዱንካንያፐ ሻከተና። ");
INSERT INTO gofe_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","ሙሰይ ጎዳኮ፥ “ኔኒ ታና፥ ሀ አሳ ታ ግዳ ቢታ ካለꬃ ያጋዳሳ። ሽን ታራ ባና መላ ኔኒ ኪተይ ኦነኮ፥ ታና ኤርሳባካ። ኔኒ፥ ታና ኤረይሳነ ታናን ኡፋይተይሳ ታዉ ቆንጭሳዳሳ። ");
INSERT INTO gofe_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","ሄስ ቱማ ግድኮ፥ ታ ነና ሀጋዛና መላነ ጉጃ ኡፋይሳና መላ ነ ኦግያ ታና ታማርሳ። ሀ አሳይ ነ ደረ ግደይሳ በአ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","ጎዳይ ዛሪድ፥ “ታኒ፥ ኔራ ባና መላነ ነዉ ሳሮ እማና መላ ኮያይ?” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","ሙሰይ ዛሪድ፥ “ኔኒ ኑራ ቦናባ ግድኮ፥ ሀይሳፈ ኑና ከሶፋ። ");
INSERT INTO gofe_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","ኔኒ ኑራ ቦናባ ግድኮ፥ ታናንነ ነ አሳን ነ ኡፋይትዳይሳ አሳ ኡባይ ዋትድ ኤራኔ? ቢታ ኡባን ደእያ ሀራ አሳ ኡባፈ ታንነ ነ አሳይ ዱማተይ ነ ኑራ ደኤይሳን ግደነዬ?” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","ጎዳይ ሙሰኮ፥ “ታኒ ነና ኤርያ ግሾነ ነናን ኡፋይትዳ ግሾ፥ ነ ታና ኦይችዳይሳ ኡባ ኦꬃና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","ሙሰይ ጎዳኮ፥ “ሀያና ነ ኩመꬃ ቦንቹዋ ታና በሳ?” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","ጎዳይ ዛሪድ፥ “ታኒ ታ ማሮታነ ታ ሎኦተꬃ ኡባ ነ ስንꬃራ አꬃና። ታ ጌሻ ሱንꬃ ነ ማታን አዋጃና። ታኒ ጎዳ፤ ታ ዶርዳይሳታ ማራናነ ኤንታዉ ቃታና። ");
INSERT INTO gofe_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","ሽን ኦንካ ታ ሶምኡዋ በእድ ፓፃ ዶና ግሾ፥ ኔኒ ታ ሶምኡዋ በአካ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","ሽን፥ “ኔኒ ዛላ ቦላ ኤቃናዉ ሀይሳን ታ ማታን በሲ ደኤስ። ");
INSERT INTO gofe_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","ታ ቦንቾይ አꬍያ ዎደ ታኒ ዛእዳ ዛላ ግዶን ነና ዎꬃና። ታ አꬋና ጋካናዉ ታ ኩሽያን ነና ካማና። ");
INSERT INTO gofe_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","ሄሳፈ ጉየ፥ ታኒ ታ ኩሽያ ደንꬃና፤ ኔኒ ታ ዞኩዋ በአና፥ ሽን ታ ሶምኡዋ በአካ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","ጎዳይ ሙሰኮ፥ “ኮይሮይሳታ ዳንያ ናምኡ ሎቸ ሹቻታ ማሳዳ ጊግሳ። ታኒ ሄ ሹቻታ ቦላ ካሰ ኔኒ መንꬅዳ ሹቻታ ቦላ ደእያ ቃላታ ፃፋና። ");
INSERT INTO gofe_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","ዎንቶ ዎንታ ጉራ ታራ ጋሄታናዉ ሲና ዙማ ሁጵያ ከያ። ");
INSERT INTO gofe_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","ኔራ ኦንካ ከዮፖ ዎይኮ ዙማ ቦላ አዉንካ በንቶፎ። ሀር አቶሽን ዶርሳ ዎይኮ መሄ ዉደይ ዙማ ፃጶን ሄመቶፎ ዎይኮ ሞፖ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","ሄሳ ግሾ፥ ሙሰይ ኮይሮ ሹቻታ ዳንያ ናምኡ ሹቻታ ማስድ፥ ጎዳይ ኪትዳይሳዳ፥ ሹቻታ ኦይክድ ዎንታ ጉራ ሲና ዙማ ቦላ ከይስ። ");
INSERT INTO gofe_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","ጎዳይ ሻራራ ዎꬍድ፥ እያራ ያን ኤቅድ፥ “ታኒ ጎዳ” ያግድ ባ ጌሻ ሱንꬃ አዋጅስ። ");
INSERT INTO gofe_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","ጎዳይ ሙሰ ስንꬃራ አꬍሸ ሀይሳዳ ያግድ አዋጅስ፤ “ታኒ ፆሳ፥ ታ ሱንꬃይ ጎዳ። ታኒ፥ ቃይነ ማሮታይ ኩምዳ ፆሳ። ታኒ ዳንዳአንነ መርና ሲቆን ኩምዳይሳነ ዳሮ አማንይሳ። ");
INSERT INTO gofe_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","ታኒ፥ ታ አሳስ ገልያ ቃላ ሙኩሉ የለተꬅ ጋካናዉ ናገይሳነ ኢታተꬃ፥ ማካላነ ናጋራ አቶ ገይሳ። ሽን ሄꬓንꬆነ ኦይዳንꬆ የለተꬅ ጋካናዉ አዋታ ናጋራ ግሾ ናይታ ሴሮና አግከ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","ሙሰይ ኤለስድ ቢታን ጉፋንድ ጎይንስ። ");
INSERT INTO gofe_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","እ ዛሪድ፥ “አቤት ጎዳዉ፥ ኔኒ ታናን ኡፋይትያባ ግድኮ፥ ኑራ እስፈ የꬋ። ሀይስ አሳይ ስኦና አስ፤ ኑ ኢታተꬃነ ኑ ናጋራ አቶ ያጋዳ፥ ኑና ነ አሰ ኦꬃ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","ጎዳይ ሙሰኮ፥ “ታኒ እስራኤለ አሳራ ጫቃና። ሀይሳፈ ካሰ ቢታ ቦላ አዉንካ ሀን ኤሮና ማላልስያባ ነ አሳ ስንꬃን ኦꬃና። ታኒ ጎዳይ፥ አይ መላ ማላልስያባ ኦꬅያኮ፥ ኔኒ ኤንታ ግዶን ደእያ አሳይ በአና። ");
INSERT INTO gofe_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","ሀች ታኒ ህንተና ኪትያ ኪታ ናግተ። ህንተ ስንꬃፈ አሞረታ፥ ካናነታ፥ ህተታ፥ ፓርዘታ፥ ህወታነ ያቡሰታ ታኒ ጎዳና። ");
INSERT INTO gofe_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","ኤንቲ ህንተዉ ፅሄ ግዶና መላ ህንተ ገልያ ቢታን ደእያ አሳራ ጫቆፍተ። ");
INSERT INTO gofe_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","ኤንታ ያርሾ በሳታ ላልተ፤ ጎይኖ ቱሳታ መንረꬅተ። አሼራ ጌተትያ ማጫ ፆሰ ምስለ ቱሳታ ቃንፀረꬅተ። ");
INSERT INTO gofe_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","ታኒ ጎዳይ፥ ታ ቦንቹዋ ሀራ ፆሳታራ ኮፆና ፆሰ ግድያ ግሾ፥ ታፐ ሀራ ፆሳታስ ጎይኖፍተ። ");
INSERT INTO gofe_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","ሄ ቢታን ደእያ አሳታራ አይባ ጫቆካ ጫቆፍተ። ኤንቲ ባንታ ፆሳታ ጎይንያ ዎደነ ኤንታዉ ያርሽያ ዎደ፥ ኤንቲ ህንተና ባንታራ እስፋና መላ ኦይችኮ፥ ህንተ ኤንቲ ባንታ ፆሳታስ ያርሽያ ካꬃ ማናዉ ፓጨትድ፥ ታዉ አማነቶና እፃና። ");
INSERT INTO gofe_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","ቃስ ህንተ ኤንታ ማጫ ናይታፐ ህንተ አደ ናይታስ እምኮ፥ ሄ ዎደ ሄ ማጫ ናይት ባንታ ፆሳታ ጎይንድ፥ ህንተ አደ ናይትካ ታዉ አማነቶና እፅድ፥ ባንታ ፆሳታ ጎይናና መላ ኦꬃና። ");
INSERT INTO gofe_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“ብራታፐ ቆፀትድ፥ መትዳ ፆሳታ ጎይኖፍተ። ");
INSERT INTO gofe_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“ኡይꬃ ባኣለ ቦንችተ። ህንተ ግብፀፈ ከይዳይ፥ አቢባ አጌናን ግድያ ግሾ፥ ታኒ ህንተና ኪትዳይሳዳ፥ ሄ አጌናን፥ ላፑን ጋላስ ጋካናዉ ኡይꬅ ሚተ። ");
INSERT INTO gofe_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“ባይራ የለትያ አደ ናእ ኡባይነ ባይራ የለትያ መሄ አደ ኡባይ ታባ። ");
INSERT INTO gofe_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","ኮይሮ የለትዳ ሀረ ማር ዶርሳ ማራራ ላማዳ ዎዛ። ዎዞና እፅኮ፥ እያ ሞርግያ መንꬃ። ባይራ የለትዳ አደ ናአ ኡባ ዎዛ። “ኦንካ እምያባ ኦይኮና መላ ኩሸ ታ ስንꬃን ሺቆፖ። ");
INSERT INTO gofe_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“ኡሱፑን ጋላስ ኦꬅተ፥ ሽን ላፑንꬃ ጋላሳን ሸምፕተ። ዘርያ ዎደ ግድን ዎይኮ ካꬃ ጫክያ ዎደ ላፑንꬃ ጋላሳን ሸምፕተ። ");
INSERT INTO gofe_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“ኮይሮ ህንተ ግስትያ ጫኮ ዶምያ ዎደ፥ ካꬃ ሺሾ ባኣለ ቦንችተ። ቃስ ላይꬃ ዉርሰꬃ ካꬃ ሺሽያ ዎደ፥ ሻቃራ ባኣለ ቦንችተ። ");
INSERT INTO gofe_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","ላይꬃን ሄꬑ ቶሆ እስራኤለ አደ ኡባይ መተꬃ ጎዳ፥ እስራኤለ ፆሳ ጎይናናዉ ዮ። ");
INSERT INTO gofe_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","ካዎተꬃታ ታኒ ህንተ ስንꬃፈ የደꬃ ከሳዳ ህንተ ዛዋ አሳና። ህንተ ታና ጎይናናዉ ላይꬃን ሄꬑ ቶሆ ይያ ዎደ፥ ኦንካ ህንተ ቢታ ኦልድ ኤካናዉ አሞተና። ");
INSERT INTO gofe_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“ህንተ ታዉ መሄ ያርሽያ ዎደ፥ እርሾ የግድ ኡክዳ ኡይꬃራ ሽሾፕተ። ፓስካ ቦንችያ ጋላሳስ ያርሽዳ ያርሹዋፈ ዎንታስ አይባካ አሾፍተ። ");
INSERT INTO gofe_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“ህንተ ጋደን ባይራ ካፅዳ ካꬃፈ ኮይሮ አይፍያ ጎዳ ህንተ ፆሳ ኬꬅ ኤህተ። “ዴሻ ማር እያ አየ ማꬃን ዶይሶፕተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","ጎዳይ ሙሰኮ፥ “ታኒ ኔራነ እስራኤለ አሳራ ጫቆ ገለይ ሀ ቃላታን ግድያ ግሾ፥ ሀ ቃላታ ፃፋ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","ሙሰይ ሞናነ ኡዮና፥ ኦይታሙ ጋላስነ ኦይታሙ ቃማ ጎዳራ ዙማ ቦላ ጋምእስ። እ፥ ጫቆ ቃላ ገልዳ ታሙ ኪታታ ሎቸ ሹቻታን ፃፍስ። ");
INSERT INTO gofe_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","ሙሰይ ጎዳራ ኦደትሸ ጋምእድ፥ ታሙ ኪታታ ኦይክዳ ናምኡ ሎቸ ሹቻታ ኤክድ ሲና ዙማፐ ዎꬍያ ዎደ እያ ሶምኦይ ጶሌስ፥ ሽን እ ሄሳ ኤርቤና። ");
INSERT INTO gofe_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","አሮንነ እስራኤለ አሳ ኡባይ ሙሰ ፄልድ፥ እያ ሶምኦይ ጶለይሳ በእድ፥ እያኮ ሺቃናዉ ያይዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","ሽን ሙሰይ ኤንታ ፄግስ። አሮንነ እስራኤለ ሀላቃት ኡባይ እያኮ ሺቅን፥ እ ኤንታ ኦድስስ። ");
INSERT INTO gofe_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","ሄሳፈ ጉየ፥ እስራኤለ አሳ ኡባይ እያኮ ሺቅን፥ ጎዳይ እያዉ ሲና ዙማ ቦላ እምዳ ኪታ ኡባ እ ኤንታዉ እሚስ። ");
INSERT INTO gofe_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","ሙሰይ ኤንታራ ኦደተይሳ ዉርስዳ ዎደ ባ ሶምኡዋ ላፃናን ካምስ። ");
INSERT INTO gofe_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","ሽን ሙሰይ ጎዳ ስን፥ እያራ ኦደታናዉ ገልያ ዎደ ላፃና ባ ሶምኡዋፈ ቃሬስ። ያፐ ከይያ ዎደ፥ ጎዳይ እያ ኪትዳባ ኡባ እስራኤለ አሳስ ኦዴስ። ");
INSERT INTO gofe_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","ሄ ኡባን ኤንቲ እያ ሶምኦይ ጶለይሳ በኦሶና። ሄሳ ግሾ፥ ሙሰይ ጎዳራ ኦደታናዉ ባና ጋካናዉ፥ ባ ሶምኡዋ ላፃናን ካሜስ። ");
INSERT INTO gofe_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","ሙሰይ እስራኤለ አሳ ኡባ ፄግድ፥ “ህንተ ኦꬃና መላ ጎዳይ ኪትዳባይ ሀይሳ፤ ");
INSERT INTO gofe_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","ሳምንታ ግዶን ኡሱፑን ጋላሳ ፃላላን ኦሶ ኦꬅተ፤ ሽን ላፑንꬃ ጋላሳይ ህንተዉ ጌሻ ጋላስ፤ ጎዳስካ ዱማትዳ ሸምፖ ሳምባታ። ሄ ጋላሳን ኦሶ ኦꬅያ ኦንካ ሀይቃናዉ በሴስ። ");
INSERT INTO gofe_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","ሳምባታ ጋላስ ህንተ ሶን ታማ ኤꬆፍተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","ሙሰይ እስራኤለ አሳኮ፥ “ጎዳይ ሀይሳዳ ያግድ ህንተና ኪትስ፤ ");
INSERT INTO gofe_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","ጎዳስ ህንተ ዎዛናይ እሞ ግያባ እማናዉ ኤህተ። ህንተ እማናዉ ኤህያባት ዎርቃ፥ ብራ፥ ናሰ ብራታ፥ ");
INSERT INTO gofe_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","ካሎሰ ቃጭና፥ ኦቻ ቴራ ዳንያ ቃጭና፥ ዞኦ ቃጭናነ አልኦ ሊኖ፥ ዴሻ እክሰ፥ ");
INSERT INTO gofe_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","ዞኦ ቃላመን የግ ከስዳ ዶርሳ እተ፥ ሎኦ ዶአ እተ፥ ሶቃላ ምꬅ፥ ");
INSERT INTO gofe_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","ፆምፐስ ሻማሆ ዛይተ፥ ሹማተꬃ ዛይተ፥ እያን የገትያ ሳዋነ እፃነ ሳዎ፥ ");
INSERT INTO gofe_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","ኤፉድያስነ ትራን ማኤትያ ማኡዋስ ሀንያ ማርግደ ጌተትያ ሹቻነ ሀራ አሌቆታ ኤሆ። ");
INSERT INTO gofe_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“ህንተ ግዶን ደእያ ኩሸ ሂላንቾ ኡባይ ይድ፥ ጎዳይ ኪትዳይሳ ኡባ ኦꬆ። ");
INSERT INTO gofe_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","ጌሻ ዱንካንያ፥ እያ ጋꬃ ካማነ ካረ ካማ፥ ካቆታ፥ ቱቀታ፥ ልዮታ፥ ቱሳታነ ኤንቲ ኤቅያ ቶሆታ፤ ");
INSERT INTO gofe_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","ታቦትያነ እያ ቶክያ ካሶ ምꬃታ፥ ናጋራ አቶተꬃ ካማነ ታቦትያ ገንꬅያ ማጋራጁዋ፤ ");
INSERT INTO gofe_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","ፃርጴዛ፥ እያ ቶክያ ካሶ ምꬃታነ፥ እያ ሚሸታ ኡባነ ጎዳ ስንꬃን ዎꬅያ ጌሻ ኡይꬃ፤ ");
INSERT INTO gofe_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","ፆምፐ ዎꬅያ ኮጫ፥ እያ ሚሸታ፥ ፆምፕያነ ፆምፐ ዛይትያ፤ ");
INSERT INTO gofe_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","እፃነ ጩይስያ ፃርጴዛነ እያ ቶክያ ካሶታ፥ ሹማተꬃ ዛይትያነ ሳውያ እፃነ፥ ጌሻ ዱንካንያ ፐንገ ማጋራጁዋ፤ ");
INSERT INTO gofe_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","ፁሳ ያርሾ በስነ እያ ናሰ ብራታ ዛርዛርያ፥ እያ ቶክያ ካሶታነ እያ ሚሸታ ኡባ፥ ናሰ ብራታፐ ኦሰትዳ ሜቻ ከርያነ እያ ቶሁዋ፤ ");
INSERT INTO gofe_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","ዳባባ ጎዳ ገሸታ፥ ቱሳታነ ኤንታ ቶሆታ፥ ዳባባ ፐንገ ማጋራጁዋ፥ ");
INSERT INTO gofe_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","ጌሻ ዱንካንያነ ዳባባ ዱንካንያ ቶለ ꬍሸታነ ኤንታ ዎዶሮታ፤ ");
INSERT INTO gofe_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","አሮንነ እያ ናይት ጌሻ በሳን ሀጋዝሸ ማአናዉ አሌቀትድ ኦሰትዳ ቦንቾ ማኦታ ኦꬆ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","ሄሳፈ ጉየ፥ እስራኤለ አሳ ኡባይ ሙሰ ስንꬃፈ ከይዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","አሳ ኡባይ ባ ዎዛናን እሞ እሞ ግዳባ ጌሻ ዱንካንያስ፥ እያ ግዶን ኦሰትያ ኦሶ ኡባስነ ቦንቾ ካህነ ማኦታስ ኮሽያባ ኡባ ኤህዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","እማናዉ ኮይዳ ማጭ አደ ኡባይ ዎርቃ አሌቆታ፥ ሲ ዎርቃታ፥ ምግዶታ፥ ቆ ዎርቃ ኤህድ፥ ጎዳስ እሞ ኦꬅድ እምዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","ካሎሰ ቃጭና፥ ኦቻ ቴራ ዳንያ ቃጭና፥ ዞኦ ቃጭና፥ አልኦ ሊኖ፥ ዎይኮ ዴሻ እክሰ፥ ዎይኮ ዞኦ ቃላመን የግ ከስዳ ዶርሳ እተ ዎይኮ፥ ሎኦ ዶአ እተይ ደእያ አስ ኡባይ ኤህስ። ");
INSERT INTO gofe_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","ብራ ዎይኮ ናሰ ብራታ እማናዉ ዳንዳእያ ኡባይ ባንታ እሞታ ጎዳስ እምዶሶና። ቃስ ሶቃላ ምꬅ ደእያ አስ ኡባይ ዱማ ዱማ ኦሱዋስ ኤህስ። ");
INSERT INTO gofe_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","ኩሸ ሂላ ማጫሳ ኡባይ ባንታ ኩሸን ሱቅዳ ካሎሰ ቃጭና፥ ኦቻ ቴራ ዳንያ ቃጭና፥ ዞኦ ቃጭናነ አልኦ ሊኖ ኤህዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","ቃስካ እሞታ እማናዉ ኮይዳ ማጫሳ ኡባይ ዴሻ እተፐ ዶቀትዳ ዎዶሮ ኤህዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","ሀላቃት ኤፉድያስነ ትራን ማኤትያ ማኡዋስ ሀንያ ማርግደነ ሀራ ሎኦ ሹቻታ፥ ");
INSERT INTO gofe_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","ቃስካ ኤንቲ እፃነን፥ ሹማተꬃስነ ፆምፐስ ማድያ ሻማሆ ዛይተን የገትያ ሳዎ ኤህዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","እስራኤለ አሳ ኡባይ፥ ኦꬃና መላ ጎዳይ ሙሰ ባጋራ ኪትዳ ኦሱዋስ ሀንያ እሞታታ ኡባ ባንታ ዶሳን ጎዳስ ኤህዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","ሙሰይ እስራኤለ አሳኮ ሀይሳዳ ያግስ፤ “ጎዳይ ይሁዳ ሼሻፐ ግድዳ ሁራ ናኣ ናኣ፥ ኡረ ናኣ፥ ባስልኤላ ዶርስ። ");
INSERT INTO gofe_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","ጎዳይ እያ ባ አያናን፥ ሂላን፥ አኬካንነ ኦሶ ኡባ ኦꬅያ ኤራን ኩንꬅስ። ");
INSERT INTO gofe_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","ሄስካ፥ ሂላን ኦꬃና ኦሶታ ሀልችድ ዎርቃፈ፥ ብራፐነ ናሰ ብራታፐ ዱማ ዱማባ ከስድ ኦꬃናሳ። ");
INSERT INTO gofe_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","ሄሳዳካ፥ አልኦ ሹቹ ማስድ ጊግሶ፥ ምꬅ ማሰꬅነ ሀራ ኦሶ ኡባ ኦꬃና መላ ጭንጫተꬅ እሚስ። ");
INSERT INTO gofe_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","ቃስ እያስነ ዳነ ሼሽ ግድዳ አህሳማካ ናኣ ኤልያባስ፥ ባንታ ሂላ ሀራታ ታማርሳና መላ ኤራተꬅ እሚስ ");
INSERT INTO gofe_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","ኤንቲ ዱማ ዱማ ኦሶ ኦꬃና መላ ኦሶ ሀልቾ ከሳና መላ፥ ካሎሰን፥ ኦቻ ቴራ ዳነይሳንነ ዞኦ ሱፈ ቃጭናን አልኦ ሊኖ አሌቅስድ፥ ዳድያ ሂላተꬅ እሚስ። ጎዳይ ኤንታ፥ ኤራተꬃን ኩንꬅስ። ኤንቲ ኡባይ ዱማ ዱማ ኦሶን ሉፅዳ ሂላንቾ ግድዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“ሄሳ ግሾ፥ ባስልኤል፥ ኤልያብነ ጌሻ ዱንካንያ ኬፃና መላ ጎዳይ ሂላነ ኤራተꬅ እምዳ አሳ ኡባይ፥ ጎዳይ ኪትዳይሳዳ ኡባባ ኦꬃና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","ሙሰይ ባስልኤላ፥ ኤልያባ፥ ጎዳይ ዱማ ኤራተꬅ እምዳይሳታነ ኦሶ ኦꬃናዉ ኮይያ ኡባ ፄግድ፥ ኦሱዋ ዶማና መላ ኪትስ። ");
INSERT INTO gofe_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","ኤንቲ፥ እስራኤለ አሳይ ጌሻ ዱንካንያ ኦꬃናዉ ኤህዳ እሞ ኡባ ሙሰ ኩሸፐ ኤክዶሶና። ቃስ አሳይ ባ ዶሳን እምያ እሞታ ዎንታ ዎንታ ኤሁዋ አግቦኮና። ");
INSERT INTO gofe_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","ያትን፥ ጌሻ ዱንካንያ ኦꬅያ ሂላንቾት ባንታ ኦሱዋ ኤስድ፥ ሙሰኮ ብድ፥ ");
INSERT INTO gofe_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","“አሳይ፥ ጎዳይ ኪትዳ ኦሱዋስ ኮሸይሳፈ አꬅድ ኤሆ ቦላ ደኦሶና” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","ሙሰይ፥ “ጌሻ ዱንካንያ ኬፃናዉ ኦንካ እምያባ ኤሆፖ” ያግድ ኪትን፥ አሳይ ኤሄይሳ አጋግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","ኤንቲ ኤህዳ እሞታይ ኦሶ ኡባ ኦꬅ ፖላናዉ ግድድ ፓላሄስ። ");
INSERT INTO gofe_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","ኦሱዋ ኦይሳታፐ ሂላን አይሳት ጌሻ ዱንካንያ ኦꬅዶሶና። ኤንቲ እያ አልኦ ሊኖፐ፥ ካሎሰን ኦቻ ቴራ ዳነይሳንነ ዞኦ ቃጭናን አሌቅስድ ዳድዳ ታሙ ገሸታ ጊግስድ፥ እያ ቦላ ክሩበታ ምስልያ ስክዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","ማጋራጆት ኡባይ እስ ግና ግድድ፥ አዱሳተꬃይ ላታማነ ኦይዱ ዋꬋ፥ ጎምፓይ ኦይዱ ዋꬋ። ");
INSERT INTO gofe_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","እቻሹ ገሸታ እስፈ ጋꬅድ ስክዶሶና፤ ቃስ ሀንኮ አትዳ እቻሹ ገሸታካ ሄሳዳ ኦꬅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","እስፈ ጋꬅድ ስክዳ ገሸታፐ እስ ማጋራጁዋስ ዉርሰꬃ ጋፃን ካሎሰ አፍላፐ ኦሰትዳ ሳጋዮታ መꬍዶሶና። ቃስ እስፈ ጋꬅድ ስክዳ ሀንኮ ገሸታፐ እሱዋ ጋፃንካ ሄሳዳ ኦꬅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","ኤንቲ እስፈ ስከትዳ ኮይሮ ማጋራጁዋ ቦላ ኮይሮ ማራን ካሎሰ አፍላፐ ኦሰትዳ እሻታሙ ሳጋዮታ፥ ሄሳዳካ ናምአንꬆ ማጋራጁዋ ቦላ ዉርሰꬃ ማራን፥ ሀንኮ ሳጋዮታ ግናን፥ እሻታሙ ሳጋዮታ ኦꬅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","ኤንቲ ናምኡ ባጋን ደእያ ገሸታ ጋሰꬅድ እስኖ ኦꬃናዉ ዎርቃፈ እሻታሙ ኦይክያ በሳታ መꬍዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","ጌሻ ዱንካንያ ቦላራ ካማናዉ ታማነ እስ ገሸታ ዴሻ እክሰፐ ዳድዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","ታማነ እስ ገሸታ አዱሳተꬃ ላታማነ ኡሱፑን ዋꬋ፥ ጎምፓ ኦይዱ ዋꬋ ኦꬅድ መꬍዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","እቻሹ ገሸታ እስ ባጋራ፥ ቃስ ኡሱፑን ገሸታ ሀንኮ ባጋራ ጋꬅድ ስክዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","ዎል ጋꬅድ ስክዳ ገሸታፐ ዉርሰꬃ ማጋራጁዋ ማጫራን እሻታሙ ሳጋዮታ፥ ቃስ ዎል ጋꬅድ ስክዳ ሀንኮ ገሸታፐ ዉርሰꬃ ማጋራጁዋ ማጫራን እሻታሙ ሳጋዮታ መꬍዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","ናምኡ ባጋራ ደእያ ገሸታ ጋሰꬅድ እስ ካማ ኦꬃናዉ ናሰ ብራታፐ እሻታሙ ኦይክያ በሳታ መꬍዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","ዱንካንያ ካማናዉ ዞኦ ቃላመን የግ ከስዳ ዶርሳ እተ፥ ቃስ እያ ቦላራ ካማናዉ ሎኦ ዶአ እተ ጊግስዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","ጌሻ ዱንካንያ ቱቀታ ሶቃላ ምꬃፈ ከስዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","እስ እስ ቱቅያ አዱሳተꬃይ ታሙ ዋꬋ፥ ጎምፓይ እስ ዋꬋነ ታካꬎ። ");
INSERT INTO gofe_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","እስ ቱቅያ እሱዋራ ጋሰꬃናዉ ናምኡ ሉሆት ደኦሶና። ጌሻ ዱንካንያ ቱቀታ ኡባ ሄሳዳ ኦꬅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","ጌሻ ዱንካንያስ ዱገሀ ባጋራ ላታሙ ቱቀታ መꬍዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","እስ እስ ቱቀታስ ናምኡ ቶሆ መꬍድ፥ ሄ ቶሆታ ኦይꬃናዉ ኦይታሙ ሉሆታ ብራታፐ ጊግስዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","ጌሻ ዱንካንያስ ፑደሀ ባጋራ ላታሙ ቱቀታ መꬍዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","እስ እስ ቱቀታስ ናምኡ ቶሆ መꬍድ፥ ሄ ቶሆታ ኦይꬃናዉ ኦይታሙ ሉሆታ ብራታፐ ጊግስዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","ጌሻ ዱንካንያስ ጉየ ባጋን፥ ዉሎሀ ባጋራ ኡሱፑን ቱቀታ መꬍዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","ጌሻ ዱንካንያ ጉየ ባጋን ደእያ ማዛነታስ ናምኡ ቱቀታ ጊግስዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","ሄ ናምኡ ማዛነ ቱቀት ፃጶፐ ፄራ ጋካናዉ ኦይከት ብዶሶና። ናምኡ ማዛንያን ደእያ ናምኡ ቱቀት ሄሳዳ ሀንድ ኦሰትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","ሄሳ ግሾ፥ እስ እስ ቱቅያስ ጋርሳን ናምኡ ናምኡ ቶሆት ደኦሶና። ሆስፑን ቱቀታስ ብራታፐ ኦሰትዳ ታማነ ኡሱፑን ቶሆት ደኦሶና። ");
INSERT INTO gofe_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","ቃስ ኤንቲ ሶቃላ ምꬃፈ ታማነ እቻሹ ልዮታ ከስዶሶና። እቻሹ ልዮት ጌሻ ዱንካንያ እስ ባጋ ምየን፥ ");
INSERT INTO gofe_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","ቃስ እቻሹ ልዮታ ሀንኮ ባጋ ምየን፥ ሄሳዳካ እቻሹ ልዮታ ጉየ ባጋራ ዉሎሀ ባጋን ዎꬅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","ቱኡቀታስ ምየ ባጋራ ግዶን ደእያ ልዮይ፥ ሀ ጋፃፐ ያ ጋፃ ጋካናዉ ካንꬅ ከያና መላ ኦꬅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","ቱኡቀታነ ልዮታ ዎርቃን ላንፅዶሶና። ልዮት ኤንታ ግዶራ ካንꬅ አꬋና መላ ዎርቃ ሳጋዮታ ቱቀታራ ኦይሰꬅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","ማጋራጁዋ አልኦ ሊኖፐ ካሎሰን፥ ኦቻ ቴራ ዳነይሳንነ፥ ዞኦ ቃጭናን አሌቅስድ ኦꬅዶሶና። ሄ ማጋራጁዋ ቦላ ክሩበ ምስለታ ስክዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","ማጋራጁዋ ካቃናዉ ኦይዱ ቱሳታ ሶቃላ ምꬃፈ ጊግስድ፥ ዎርቃን ላንፅዶሶና። ያትድ ዎርቃ ሳጋዮታ ኤንታስ ጊግስዶሶና። ቃስ ቱሳታ ኤስያ ኦይዱ ቶሆታ ብራ ብራታፐ መꬍዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","ጌሻ ዱንካንያ ፐንግያስ አልኦ ሊኖፐ ካሎሰን፥ ኦቻ ቴራ ዳነይሳፈነ ዞኦ ቃጭናን አሌቅስድ ማጋራጆ ጊግስዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","ቃስ እያዉ ኮጫት ደእያ እቻሹ ቱሳታ መꬍድ፥ ኤንታዉ ፄራነ ቶሁዋ ዎርቃን ላንፅዶሶና። ቱሳታስ ናሰ ብራታፐ ኦሰትዳ እቻሹ ቶሆታ ጊግስዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","ባስልኤል ታቦትያ ሶቃላ ምꬃፈ ጊግስስ። ታቦትያ አዱሳተꬃይ ናምኡ ዋꬋነ ባጋ፥ ጎምፓይነ ጌሳይ እስ ዋꬋነ ባጋ። ");
INSERT INTO gofe_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","ታቦትያ ጊግስድ፥ ጋꬃነ ካርያ ዋላህ ባይና ዎርቃን ላንፅስ። እያ ዩሹዋ ቦላካ ዎርቃን ላንፅስ። ");
INSERT INTO gofe_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","ኦይዱ ዎርቃ ሳጋዮታ ታቦትያስ ኦይዱ ገዳታ ቦላ፥ እስ ባጋራ ናምኡ ሳጋዮታ፥ ቃስ ሀንኮ ባጋራ ናምኡ ሳጋዮታ አꬅስ። ");
INSERT INTO gofe_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","ያትድ ሶቃላ ምꬃፈ ኦሰትዳ ካሶታ ከስድ ኤንታ ዎርቃን ላንፅስ። ");
INSERT INTO gofe_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","ታቦትያ ቶካናዉ፥ ታቦትያስ ምይያን ደእያ ሳጋዮታን ካሶታ አꬅስ። ");
INSERT INTO gofe_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","ዋላህ ባይና ዎርቃፈ፥ አዱሳተꬃይ ናምኡ ዋꬋነ ባጋ፥ ጎምፓይ እስ ዋꬋነ ባጋ ግድዳ ናጋራ አቶተꬃ ካማ ኦꬅስ። ");
INSERT INTO gofe_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","ቀፈይ ደእያ ናምኡ ክሩበታ ቆፀትዳ ዎርቃፈ ኦꬅድ፥ ");
INSERT INTO gofe_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","እስ ክሩብያ እስ ባጋን፥ ሀንኮ ክሩብያ ሀንኮ ባጋን ዎꬅድ፥ አቶተꬃ ካሙዋራ እስኖ ኦꬅድ መꬍስ። ");
INSERT INTO gofe_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","ክሩበት ባንታ ቀፍያ ምጭድ፥ አቶተꬃ ካሙዋ ካምድ፥ እሶይ እሱዋ ፄሎሶና። ");
INSERT INTO gofe_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","አዱሳተꬃይ ናምኡ ዋꬋ፥ ጎምፓይ እስ ዋꬋ፥ ጌሳይ እስ ዋꬋነ ባጋ ግድዳ ፃርጴዛ ሶቃላ ምꬃፈ መꬍስ። ");
INSERT INTO gofe_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","ዋላህ ባይና ዎርቃን እያ ላንፅድ፥ ዩሹዋካ ዎርቃን ላንፅስ። ");
INSERT INTO gofe_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","ሄሳዳካ፥ ጎምፓይ ታካꬎ ግድያ ጎሰ ኦꬅድ፥ እያ ዎርቃን ዩሽ አꬅድ ላንፅስ። ");
INSERT INTO gofe_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","ታቦትያ ቶካናዉ ማድያ ኦይዱ ዎርቃ ሳጋዮታ መꬍድ፥ ኦይዱ ገዳታ ኦይዱ ማዛነታ ቦላ ዎꬅስ። ");
INSERT INTO gofe_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","ፃርጴዛ ቶካናዉ ካሶታ አꬅያ ሳጋዮት ፃርጴዛ ጎሳ ማታን ኦሰትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","ፃርጴዛ ቶክያ ካሶ ምꬃታ ሶቃላ ምꬃፈ ከስድ፥ ዎርቃን ላንፅስ። ");
INSERT INTO gofe_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","ሄሳዳካ፥ ፃርጴዛ ቦላ ዎꬅያ ዱማ ዱማ ሚሸታ ዋላህ ባይና ዎርቃፈ መꬍስ። ሄሳትካ ሳነታ፥ ጭልፓታ፥ ከረታ፥ ዎይነ ያርሾ ትግያ ፁአታ። ");
INSERT INTO gofe_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","ሄሳፈ ጉየ፥ ባስልኤል ፆምፐ ዎꬅያ ኮጫ ዋላህ ባይና ዎርቃፈ ኦꬅስ። ኮጫ ኤስያ ቶሁዋነ ቶማ ቆፀትዳ ዎርቃፈ ጊግስስ። አሌቆስ ኦሰትያ፥ እያ ጋምቡꬃታ፥ እያ ዋላፃታነ እያ ጪሻታ ኡባ እያራ እስፈ ኦይꬅድ መꬍስ። ");
INSERT INTO gofe_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","እስ ባጋራ ሄꬑ ታሸት፥ ቃስ ሀንኮ ባጋራ ሄꬑ ታሸት ደእያ ኡሱፑን ታሸታ እያ ምይያን መꬍስ። ");
INSERT INTO gofe_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","ኡሱፑን ታሸታስ ፄራን ፄራን ሄꬑ ሄꬑ አሌቆ ጋምቡꬃትነ ጪሻት ደእያ ላዉዘ ምꬃ ጪሸ ዳንያባ መꬍስ። ");
INSERT INTO gofe_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","ፆምፐ ዎꬅያ ኮጫ ግዶን ደእያ ቶማ ፄራን ኦይዱ አሌቆ ጋምቡꬃትነ ጪሻት ደእያ ላዉዘ ምꬃ ጪሸ ዳንያባ መꬍስ። ");
INSERT INTO gofe_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","ዋꬃን ደእያ ሄꬑ ሄꬑ ታሸታፐ ጋርሳን እስ እስ ጋምቡꬅ ኦሰትስ። ");
INSERT INTO gofe_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","ጋምቡꬃት፥ ታሸትነ ፆምፐ ዎꬅያ ኮጫይ እስኖ ግድድ፥ ዋላህ ባይና ዎርቃፈ ቆፀትድ ኦሰትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","ፆምፐ ዎꬅያ ኮጫስ ላፑን ፆምፐታ፥ ፆምፐ ቶይስያ ቃጰታነ ኤንታ ዎꬅያባታ ዋላህ ባይና ዎርቃፈ ኦꬅስ። ");
INSERT INTO gofe_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","ፆምፐ ዎꬅያ ኮጫነ እያዉ ጎኤትያ ሚሸ ኡባ ኦꬃናዉ ሀስታማነ እቻሹ ክሎ ግራመ ግድያ፥ ዋላህ ባይና ዎርቃ ኦንግስ። ");
INSERT INTO gofe_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","ባስልኤል እፃነ ጩይስያ ፃርጴዛ ሶቃላ ምꬃፈ ጊግስስ። እያዉ ኦይዱ ማዛነይ ደኤስ። ሄ ፃርጴዛስ አዱሳተꬃይነ ጎምፓይ እስ ዋꬋ፤ ቃስ ጌሳይ ናምኡ ዋꬋ። ኦይዱ ማዛንያን ደእያ ካጨት እያራ እስኖ ግድ ኦይከትድ ኦሰትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","እያዉ ቦላ ባጋ፥ ኦይዱ ምያነ ካጨታ ዋላህ ባይና ዎርቃን ላንፅስ፥ እያ ዩሹዋካ ዎርቃን ላንፅድ ዩሽ አꬅስ። ");
INSERT INTO gofe_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","እያዉ ጋፃ ቦላ ቶካናዉ ማድያ ናምኡ ዎርቃ ሳጋዮታ መꬍድ፥ ናምኡ ባጋ ምይያን ዎꬅስ። ኤንቲ እፃነ ፃርጴዛ ቶክያ ዎደ ካሶ ምꬃታ አꬃናዉ ማደይሳታ። ");
INSERT INTO gofe_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","ካሶ ምꬃታ ሶቃላ ምꬃፈ ከስድ፥ ዎርቃን ላንፅስ። ");
INSERT INTO gofe_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","ጌሻ ሹማተꬃ ዛይትያነ ሳውያ ሎኦ እፃነ ሽቶዳ ዋላክድ ኦꬅስ። ");
INSERT INTO gofe_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","ሶቃላ ምꬃፈ ፁሳ ያርሾ በሲ ኦꬅስ። ሄ ያርሾ በሳ አዱሳተꬃይነ ጎምፓይ፥ እቻሹ እቻሹ ዋꬋ፥ ቃስ ጌሳይ ናምኡ ዋꬋነ ታካꬎ። እያዉ ኦይዱ ማዛነይ ደኤስ። ");
INSERT INTO gofe_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","ኦይዱ ማዛነታራ ኦይከትድ ኦሰትዳ ካጨታ መꬍስ። ያትድ፥ ሄ ያርሾ በሳ ናሰ ብራታን ላንፅስ። ");
INSERT INTO gofe_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","ሄ ያርሾ በሳን ጎኤትያ ሚሸታ፥ ድስተታ፥ ባልደታ፥ አካፋታ፥ አሹዋ ቃጵያ ቃጰታነ ታማ ጮጨታ ኡባ ናሰ ብራታፐ መꬍስ። ");
INSERT INTO gofe_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","ናሰ ብራታፐ ግተ ዳንያ ተቀ ያርሾ በሳስ ጊግስድ፥ ያርሾ በሳስ ግዶ ዛዋ ዩሽ አꬅድ ዎꬅስ። ");
INSERT INTO gofe_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","ቶካናዉ ማድያ ካሶታ አꬃናዉ፥ ኦይዱ ሳጋዮታ መꬍድ፥ ኦይዱ ማዛነታ ቦላ ዎꬅስ። ");
INSERT INTO gofe_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","ሶቃላ ምꬃፈ ያርሾ በሳ ቶክያ ካሶ ምꬃታ ከስድ፥ ናሰ ብራታን ላንፅስ። ");
INSERT INTO gofe_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","ሀ ካሶታ ናምኡ ምየን ደእያ ሳጋዮታን አꬅስ። ያርሾ በሳ ፃዉላፐ ጊግስድ፥ ግዱዋ ካይስ ኦꬅስ። ");
INSERT INTO gofe_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","ናሰ ብራታፐ ሜቻ ከረነ እያ ዎꬅያ ቶሆ መꬍስ። ሄ ናሰ ብራታይ፥ ጌሻ ዱንካንያ ፐንገን ኦꬅያ ማጫሳት ኤህዳ ማስቶትያፐ ኤከትስ። ");
INSERT INTO gofe_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","ጌሻ ዱንካንያስ ዳባባ ባጋ ገቻናዉ አልኦ ሊኖፐ ማጋራጆ ኦꬅስ። ዱገሀ ባጋ ገሸታስ አዱሳተꬃይ ፄቱ ዋꬋ። ");
INSERT INTO gofe_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","ገሸታስ ካተ ግዳና መላ ላታሙ ቱሳታነ ኤንቲ ኤቅያ ቶሆታ ናሰ ብራታፐ ኦꬅስ። ኤንታ ፃምአታነ ካጨታ ብራ ብራታፐ ኦꬅስ። ");
INSERT INTO gofe_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","ፑደሀ ባጋ ዳባባይካ ሄሳዳ ሀንድ ኦሰትስ። ");
INSERT INTO gofe_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","ዉሎሀ ባጋ ገሸታ አዱሳተꬃይ እሻታሙ ዋꬋ። ኤንታዉ ታሙ ቱሳትነ ቱሳት ኤቅያ ታሙ ቶሆት ደኦሶና። ቱሳታስ ብራ ብራታፐ ኦሰትዳ ፃምአትነ ካጨት ደኦሶና። ");
INSERT INTO gofe_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","ዳባባ ገልያ ፐንገይ ደእያ፥ ዶሎሀ ባጋ ማጋራጁዋ ጎምፓይ እሻታሙ ዋꬋ። ");
INSERT INTO gofe_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","እስ ባጋራ ደእያ ማጋራጁዋ አዱሳተꬃይ ታማነ እቻሹ ዋꬋ። እያዉ ሄꬑ ቱሳትነ ቱሳት ኤቅያ ቶሆት ደኦሶና። ");
INSERT INTO gofe_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","ሀንኮ ባጋራ ደእያ ማጋራጁዋ አዱሳተꬃይ ታማነ እቻሹ ዋꬋ። እያዉ ሄꬑ ቱሳትነ ቱሳት ኤቅያ ቶሆት ደኦሶና። ");
INSERT INTO gofe_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","ዳባባ ዩሹዋን ደእያ ገሸት ኡባይ አልኦ ሊኖፐ ኦሰትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","ቱኡሳት ኤቅያ ቶሆት ናሰ ብራታፐ ኦሰትዶሶና። ፃምአት፥ ካጨትነ ቱሳታ ፄራ ጎሳት ብራ ብራታፐ ኦሰትዶሶና። ዳባባ ዩሹዋን ደእያ ቱሳት ኡባይ ብራ ፃምአታን ኦይከትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","ዳባባ ፐንግያን ደእያ ማጋራጁዋ አልኦ ሊኖፐ ኦꬅድ፥ ካሎሰን ኦቻ ቴራ ዳነይሳንነ ዞኦ ቃጭናን ዳድድ አሌቅስስ። እያዉ ሀንኮ ዳባባ ገሸታዳ አዱሳተꬃይ ላታሙ ዋꬋ፤ ቃስ ጌሳይ እቻሹ ዋꬋ። ");
INSERT INTO gofe_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","እያ፥ ኦይዱ ቶሆት ደእያ ኦይዱ ቱሳታ ቦላ ካቅስ። ካጨት፥ ፃራ ካመይሳትነ ፃምአት ብራ ብራታፐ ኦሰትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","ጌሻ ዱንካንያ ꬍሸትነ እያ ዩሹዋን ደእያ ገሸታ ꬍሸት ኡባይ ናሰ ብራታፐ ኦሰትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","ታሙ ኪታታ ኦይክዳ ናምኡ ሎቸ ሹቻት ደእያ በሳን፥ ጌሻ ዱንካንያን፥ ጎኤትያ ሚሸታ ማዝጋበይ ሀይሳ። ሄ ሚሸታ ማዝጋባና መላ ካህንያ አሮና ናአ እታማራ አዋተꬃ ጋርሳን ደእያ ሌወታ ሙሰይ ኪትስ። ");
INSERT INTO gofe_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","ይሁዳ ሼሻፐ ግድዳ ሁራ ናኣ ናኣ፥ ኡረ ናኣ፥ ባስልኤል፥ ጎዳይ ኪትዳይሳዳ ኡባባ ኦꬅስ። ");
INSERT INTO gofe_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","ዳነ ሼሻፐ ግድዳ አህሳማካ ናኣ ኤልያብ፥ ኩሸ ሂላንቾይ፥ ኦꬅያባስ ኮይሮ ሀልቾ ከስያ አስ፤ እ፥ ካሎሰ፥ ኦቻ ቴራ ዳነይሳነ ዞኦ ቃጭናን አልኦ ሊኖ ዳድድ አሌቅስያ አስ። ");
INSERT INTO gofe_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","ጌሻ ዱንካንያ ኦሱዋስ ሀናና መላ ጎዳስ እመትዳ ዎርቃይ ጌሻ ዱንካነን ኤረትዳ ምዛነን እስ ሙኩሉ ክሎ ግራመ ግድስ። ");
INSERT INTO gofe_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","ታይቦን ደእያ አሳፐ ኤከትዳ ብራይ ጌሻ ዱንካነን ኤረትዳ ምዛነን፥ ሄꬑ ሙኩሉነ ኦይዱ ፄታነ ሀስታሙ ክሎ ግራመ ግድስ። ");
INSERT INTO gofe_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","ሄስካ፥ ታይቦን ገልዳ አደ አሳይ፥ እሶይ እሶይ ጌሻ ዱንካነን ኤረትዳ ምዛንያ ልከን ኮየትያ ኡባ እምዶሶና። ላታሙ ላይꬅነ እያፐ ቦላ ግድዳ፥ ማዝጋበን ገልዳ፥ አደ አሳ ታይቦይ ኡሱፑን ፄታነ ሄꬑ ሙኩሉነ እቻሹ ፄታነ እሻታማ። ");
INSERT INTO gofe_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","ጌሻ ዱንካንያነ ማጋራጆታ ኤሳናዉ ማድያ ፄቱ ቶሆታ ኦꬃናዉ 3,400 ክሎ ግራመ ብራ ብራታ ኤክዶሶና። ሄስካ፥ እስ እስ ቶሆይ ሀስታማነ ኦይዱ ክሎ ግራመ ብራ ብራታ ኤክስ። ");
INSERT INTO gofe_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","ባስልኤል፥ አትዳ ሀስታሙ ክሎ ግራመ ብራ ብራታን ፃምአታ፥ ካጨታነ ቱሳታስ ፄራ ጎሳታ ኦꬅስ። ");
INSERT INTO gofe_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","አሳይ ጎዳስ እምዳ ናሰ ብራታይ 2,425 ክሎ ግራመ። ");
INSERT INTO gofe_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","ሄ ናሰ ብራታን ጌሻ ዱንካንያ ፐንግያ ኤስያ ቶሆታ፥ ግተ ዳንያባራ ናሰ ብራታ ያርሾ በሳነ እያ ግዶን ጎኤትያ ዱማ ዱማ ሚሸታ መꬍስ። ");
INSERT INTO gofe_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","ቃስ ዳባባ ዩሹዋን ደእያ ድርሳ ቶሆትነ ፐንግያ ቦላ ኤቅዳ ቶሆት፥ ጌሻ ዱንካነይነ እያ ዩሹዋን ደእያ ዳባባ ድርሳ ꬍሸት ኡባይ ሄ ናሰ ብራታፐ ኦሰትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","ካህነት ጌሻ ዱንካንያን ኦꬅያ ዎደ ማአና ቦንቾ ማኦታ፥ ካሎሰን፥ ኦቻ ቴራ ዳንያ ቃጭናፐነ ዞኦ ቃጭናን ዳድዶሶና። አሮን ማእያ ካህነተꬃ ማኡዋ ጎዳይ ሙሰ ኪትዳይሳዳ ኦꬅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","ቃስ ኤፉድያ፥ ዎርቃፈ፥ ካሎሰፐ፥ ኦቻ ቴራ ዳንያ ቃጭናፐ፥ ዞኦ ቃጭናፐነ አልኦ ሊኖፐ ዳድዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","ኤንቲ ዎርቃ ቆፅድ፥ ሌእስድ፥ እያ ቃራርድ፥ ቃጭናዳ ከስዶሶና። ያትድ ካሎሰን፥ ኦቻ ቴራ ዳነይሳን፥ ዞኦ ቃጭናንነ አልኦ ሊኖን አሌቅስድ ዳድዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","ኤንቲ ናምኡ ሀሽያራ ዎꬍድ፥ ናምኡ ባጋ ዎል ጋꬅድ ኦይሰꬃናዉ ማድያ ቃንጎታ ኤፉድያስ ኦꬅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","ጎዳይ ሙሰ ኪትዳይሳዳ፥ ሂላንቾይ አሌቅስዳ ዳንጮይካ ኤፉደይ ኦሰትዳይሳታፐ ኦሰትድ፥ ዎርቃን፥ ካሎሰን፥ ኦቻ ቴራ ዳነይሳን፥ ዞኦ ቃጭናንነ አልኦ ሊኖን ዳደትስ። ");
INSERT INTO gofe_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","ኤንቲ ማርግደ ጌተትያ ሹቻታ ጊግስድ፥ ዎርቃፈ ኦሰትዳ ካቁዋ ቦላ ዎꬅዶሶና። ማታመ ቦላ ዎጭድ ፃፈይሳዳ፥ ሄ ሹቻታ ቦላ እስራኤለ ናይታ ሱንꬃ ዎጭድ ፃፍዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","ጎዳይ ሙሰ ኪትዳይሳዳ፥ ታማነ ናምኡ እስራኤለ ናይታ ቆፍስያባ ግዳና መላ ኤንታ፥ ኤፉድያ ቃንጎታን ዎꬅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","ኤንቲ፥ ትራን ማኤትያ ማኡዋ ኤፉደይ ኦሰትዳይሳታፐ ኦꬅድ፥ ኤፉድያዳ አሌቅስዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","እያዉ ኦይዱ ማዛነት ደኦሶና፤ ጌሳይነ ጎምፓይ እስ እስ ታካꬎ ግድድ፥ ዳኮየቴስ። ");
INSERT INTO gofe_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","እያ ቦላ ኦይዱ ማራን እንቆ ጌተትያ አልኦ ሹቻታ ዎꬅዶሶና። ኮይሮ ማራን ሳርድዮነ፥ ቶጳዘነ ጶልያ አልኦ ሹቻታ፤ ");
INSERT INTO gofe_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","ናምአንꬆ ማራን ባሉረ፥ ሳንፓረነ አልማዘ ጌተትያ አልኦ ሹቻታ፤ ");
INSERT INTO gofe_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","ሄꬓንꬆ ማራን ያክንተ፥ ከልቀዶነነ አመተስፅኖሳ ጌተትያ አልኦ ሹቻታ፤ ");
INSERT INTO gofe_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","ኦይዳንꬆ ማራን ብርለ፥ ማርግደነ ያስጵደ ጌተትያ አልኦ ሹቻታ ዎꬅዶሶና። ሄሳታ ኡባ ዎርቃፈ ኦሰትዳ ካቁዋ ቦላ ዎꬅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","ታማነ ናምኡ ሹቻታ ቦላ እስ እስ እስራኤለ ናይታ ሱንꬃይ ዎጨትድ ፃፈትስ። ");
INSERT INTO gofe_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","ትራን ማኤትያ ማኡዋስ ዋላህ ባይና ዎርቃፈ ዎዶሮዳ ዶቃዳ ሳንꬃላታ ኦꬃ። ");
INSERT INTO gofe_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","ናምኡ ዎርቃ ካቆታነ ናምኡ ዎርቃ ሳጋዮታ መꬍድ፥ ናምኡ ዎርቃ ሳጋዮታ ትራን ማኤትያ ማኡዋስ ቆሞ ባጋን ደእያ ማዛነታራ ጋꬅድ ኦይሰꬅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","ሄ ናምኡ ዎርቃ ሳንꬃላታታ ናምኡ ዎርቃ ሳጋዮታራ ጋꬅድ ኦይሰꬅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","ሄ ሳንꬃላታታ፥ ሀንኮ ባጋ ፄራ፥ ናምኡ ካቆታራ ጋሰꬅዶሶና። ያትድ፥ ኤፉድያስ ስንꬃ ባጋራ፥ ሀሽያራ ዎꬍያ ቃንጎታራ ጋꬅድ ቃችዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","ቃስ ናምኡ ዎርቃ ሳጋዮታ መꬍድ፥ ኤፉድያስ ስንꬃ ባጋራ ደእያ ትራን ማኤትያ ማኡዋስ፥ ጋꬃ ባጋራ ደእያ ናምኡ ማዛነታ ፄራን አꬅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","ሄሳዳካ፥ ዎርቃፈ ሀራ ናምኡ ምግዶታ ኦꬃዳ፥ ኤፉድያስ ስንꬃ ባጋ ሀሽያራ ዎꬍያ ቃንጉዋስ ጋርሳ ባጋራ፥ ስኩዋ ማታን ዳንጩዋፈ ቆሞ ባጋራ ኦይሰꬅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","ጎዳይ ሙሰ ኪትዳይሳዳ፥ ትራን ማኤትያ ማኡዋ ቦላ ደእያ ምግዶታ ኤፉድያን ደእያ ምግዶታራ ጋꬅድ፥ ካሎሰ ቃጭና ቃችዶሶና። ትራን ማኤትያ ማኦይ ፄሳፈ ቆሞን ፔእያ ግሾ ቃሾይ ዶልኤና። ");
INSERT INTO gofe_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","ኤፉድያፐ ቦላራ ማኤትያ አዱሳ ማኦይ ኩመꬅ ካሎሰ አፍላፐ ጊግስዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","ሄ አዱሳ ማኡዋስ ሁጰ አꬅያ ሉሆ መꬍድ፥ ፔቶና መላ ጉየ ቃላምእድ፥ ዩሽ አꬅድ ስክዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","አዱሳ ማኡዋስ ዱገ ባጋ ማጫራ ዩሹዋን ካሎሰን፥ ኦቻ ቴራ ዳንያ ዞኦ ቃጭናንነ አልኦ ሊኖን፥ ኦሮማነ ቴራ ምስለታ መꬍዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","ኤንቲ ዋላህ ባይና ዎርቃፈ ዳላታ መꬍድ፥ አዱሳ ማኡዋስ ዱገ ባጋ ጋፃን፥ ኦሮማነ ምስለታ ግዶን ዎꬅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","ጎዳይ ሙሰ ኪትዳይሳዳ፥ ኦሮማነ ቴራ ምስለታ፥ አዱሳ ማኡዋስ ዱገ ባጋ ማጫራ ዩሹዋን አꬅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","ኤንቲ፥ ጎዳይ ሙሰ ኪትዳይሳዳ፥ አሮናስነ እያ ናይታስ፥ ሻምዘታ፥ ");
INSERT INTO gofe_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","ሁጰ ቃጨታ፥ ኡከታነ ጋꬃ ሱረታ አልኦ ሊኖፐ ዳድድ ጊግስዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","ቃስ ዳንጩዋ ካሎሰን፥ ኦቻ ቴራ ዳንያ ቃጭናን፥ ዞኦ ቃጭናንነ አልኦ ሊኖን አሌቅስድ፥ ጊግስዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","ኤንቲ፥ ጌሻ ካላቻ ምስልያ ዋላህ ባይና ዎርቃፈ መꬍድ፥ እያ ቦላ፥ “ጎዳስ ዱማትስ” ግያ ቃላ ዎጭድ ፃፍዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","ያትድ፥ ጎዳይ ሙሰ ኪትዳይሳዳ፥ ሁጰ ቃጭያ ቦላ ካሎሰ ቃጭናራ ቃችዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","ጌሻ ዱንካንያ ኦሶ ኡባይ ኩመꬅ ፖለትስ። እስራኤለ አሳይ፥ ጎዳይ ሙሰ ኪትዳይሳዳ ኦꬅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","ሄሳፈ ጉየ፥ ኤንቲ ጌሻ ዱንካንያነ እያ ሚሸታ ሙሰኮ ኤህዶሶና። ሄሳትካ፥ ካጨታ፥ ቱሳታ፥ ልዮታ፥ ቱቀታነ ኤንቲ ኤቅያ ቶሆታ። ");
INSERT INTO gofe_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","ቦላ ካማስ፥ ዞኦ ቃላመን የግድ ከስዳ ዶርሳ እተ፥ ሃሸትዳ ዶአ እተ፥ ማጋራጁዋ፥ ");
INSERT INTO gofe_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","ታሙ ኪታታ ኦይክዳ ታቦትያ፥ እያ ቶክያ ካሶ ምꬃታነ ናጋራ አቶተꬃ ካማ፥ ");
INSERT INTO gofe_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","ፃርጴዛነ እያ ሚሸታ ኡባ፥ ጎዳ ስንꬃን ደእያ ጌሻ ዳቡዋ፥ ");
INSERT INTO gofe_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","ዋላህ ባይና ዎርቃፈ ኦሰትዳ ፆምፐ ዎꬅያ ኮጫ፥ እያ ቦላ ደእያ ፆምፐታ፥ እያ ሚሸታ ኡባነ ፆምፐ ዛይተ፥ ");
INSERT INTO gofe_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","ዎርቃፈ ኦሰትዳ ያርሾ በሲ፥ ሹማተꬃ ዛይተ፥ ሳውያ እፃነ፥ ጌሻ ዱንካንያ ፐንገ ማጋራጁዋ፥ ");
INSERT INTO gofe_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","ናሰ ብራታፐ ኦሰትዳ ያርሾ በሲ፥ ናሰ ብራታ ተቅያ፥ ቶሆ ካሶ ምꬃታነ እያ ሚሸታ ኡባ፥ ሜቻ ከረነ እያ ዎይሳ፥ ");
INSERT INTO gofe_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","ዳባባ ገልያ ፐንገ ማጋራጁዋ፥ ቱሳታነ፥ ኤንቲ ኤቅያ ቶሆታ፥ ዳባባ ማጋራጁዋ፥ ቶለ ዎዶሮታ፥ ꬍሸታ፥ ጌሻ ዱንካንያን ጎኤትያ ሚሸታ ኡባ፥ ");
INSERT INTO gofe_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","ካህነት ጌሻ በሳን ማእያ ቦንቾ ማኦታ፥ አሮንነ እያ ናይት ማእያ ካህነተꬃ ማኦታ። ");
INSERT INTO gofe_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","እስራኤለ አሳይ ኦሶ ኡባ፥ ጎዳይ ሙሰ ኪትዳይሳዳ ኦꬅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","አሳይ፥ ኦሶ ኡባ፥ ጎዳይ ኪትዳይሳዳ ኦꬅዳይሳ ሙሰይ በእስ። ሄሳ ግሾ፥ ሙሰይ ኤንታ አንጅስ። ");
INSERT INTO gofe_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","ጎዳይ ሙሰኮ ሀይሳዳ ያግስ፤ ");
INSERT INTO gofe_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“ኮይሮ አጌናን፥ ኮይሮ ጋላሳን፥ ጌሻ ዱንካንያ ቶካ። ");
INSERT INTO gofe_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","ታሙ ኪታታ ኦይክዳ ጫቆ ታቦትያ እያ ግዶን ዎꬃዳ፥ እያ ስንꬃን ማጋራጁዋ ካቃ። ");
INSERT INTO gofe_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","ፃርጴዛ ጋꬅ ገልሳዳ፥ ኮሽያ ሚሸታ ኡባ እያ ቦላ ዎꬃ። ፆምፐ ዎꬅያ ኮጫ ገልሳዳ እያ ቦላ ፆምፐታ ዎꬃ። ");
INSERT INTO gofe_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","እፃነ ጩይስያ ዎርቃ ፃርጴዛ ጫቆ ታቦትያ ስንꬃን ዎꬃ። ጌሻ ዱንካንያ ፐንገ ማጋራጁዋ ካቃ። ");
INSERT INTO gofe_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","ፁሳ ያርሾ በሲ ጌሻ ዱንካንያ ስንꬃን ዎꬃ። ");
INSERT INTO gofe_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","ሜቻ ከርያ ጌሻ ዱንካንያፐነ ያርሾ በሳፈ ግዶን ዎꬃዳ፥ እያን ሃ ኩንꬃ። ");
INSERT INTO gofe_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","ጌሻ ዱንካንያፐ ካረራ ዳባባ ዩሻ አꬃ ጊግሳዳ፥ ማጋራጁዋ ዱንካንያ ፐንገ ቦላ ካቃ። ");
INSERT INTO gofe_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“ያታዳ፥ ጌሻ ዛይትያ ኤካዳ፥ ጌሻ ዱንካንያነ እያ ግዶን ደእያ ኡባባ ትያዳ፥ ዱማያ፤ እ ጌሽ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","ካላዳ፥ ፁሳ ያርሾ በስነ እያን ጎኤትያ ሚሸ ኡባ ትያዳ፥ ዱማያ፤ እ ፖሎ ጌሽ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","ሜቻ ከርያነ እያ ዎꬅያ ሚሸታ ትያዳ፥ ዱማያ። ");
INSERT INTO gofe_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“አሮናነ እያ ናይታ ጌሻ ዱንካንያ ፐንገ ኤሀዳ ሃꬃን ኤንታ ሜጫ። ");
INSERT INTO gofe_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","ካህነ ማኡዋ አሮና ማይዛዳ፥ እ ታዉ ካህነተꬃን ኦꬃና መላ እያ ትያዳ፥ ዱማያ። ");
INSERT INTO gofe_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","እያ አደ ናይታካ ኤሀዳ ሻምዘ ማይዛ። ");
INSERT INTO gofe_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","ኤንቲ ታዉ ካህነተꬃን ኦꬃና መላ፥ ኤንታ አዋይ ትየትዳይሳዳ፥ ኤንታካ ትያ። ሄ ትሻ ጋሶን፥ ያና ላይꬃ ኡባን፥ ኤንቲ ታዉ ካህነ ግድድ ኦꬃና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","ሙሰይ፥ ኡባባ ጎዳይ ኪትዳይሳዳ ኦꬅስ። ");
INSERT INTO gofe_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","ሄሳ ግሾ፥ ኤንቲ ግብፀፈ ከይዳ ናምአንꬆ ላይꬃን፥ ኮይሮ አጌናን፥ ኮይሮ ጋላሳን ጌሻ ዱንካንያ ቶክስ። ");
INSERT INTO gofe_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","ሙሰይ፥ ዱንካንያ ቶሆታ ኤስስ፥ ቱቀታ፥ ልዮታነ ቱሳታ አꬅስ። ");
INSERT INTO gofe_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","ጎዳይ ኪትዳይሳዳ፥ ሙሰይ፥ ጋርሳ ካማነ ቦላ ካማ ዱንካንያ ቦላ ካምስ። ");
INSERT INTO gofe_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","ያትድ፥ ታሙ ኪታታ ኦይክዳ ናምኡ ሎቸ ሹቻታ፥ ታቦትያ ግዶን ዎꬅስ። ቶሆ ካሶ ምꬃታ ታቦትያ ሳጋዮታን አꬅስ፤ ናጋራ አቶተꬃ ካማካ ታቦትያ ቦላ ዎꬅስ። ");
INSERT INTO gofe_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","ታቦትያ ጌሻ ዱንካንያ ግዶ ገልስድ፥ ገሸ ማጋራጁዋ ካቅስ። ያትድ፥ ጎዳይ ኪትዳይሳዳ፥ ጫቆ ታቦትያ ካምስ። ");
INSERT INTO gofe_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","ሙሰይ፥ ፃርጴዛ ጌሻ ዱንካንያ ግዶ ገልስድ፥ ማጋራጁዋፈ ካረራ፥ ፑደሀ ባጋን ዎꬅስ። ");
INSERT INTO gofe_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","ጎዳይ ኪትዳይሳዳ፥ ጎዳ ስንꬃን ዎꬅያ ጌሻ ዳቡዋ እያ ቦላ ዎꬅስ። ");
INSERT INTO gofe_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","ፆምፐ ዎꬅያ ኮጫ፥ ጌሻ ዱንካንያ ግዶ ገልስድ፥ ፃርጴዛፐ ስንꬃ ባጋራ ጌሻ ዱንካንያስ ዱገሀ ባጋን ዎꬅስ። ");
INSERT INTO gofe_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","ጎዳይ ኪትዳይሳዳ፥ ሙሰይ፥ ጎዳ ስንꬃን ፆምፐታ ኦይꬅስ። ");
INSERT INTO gofe_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","ሙሰይ፥ ዎርቃ ያርሾ በሳ ጌሻ ዱንካንያ ግዶ ገልስድ፥ ማጋራጁዋፈ ስንꬃ ባጋራ ዎꬅስ። ");
INSERT INTO gofe_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","ጎዳይ ኪትዳይሳዳ፥ ሳውያ እፃነ እያ ቦላ ጩይስስ። ");
INSERT INTO gofe_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","ጌሻ ዱንካንያ ፐንገን ማጋራጁዋ ካቅስ። ");
INSERT INTO gofe_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","ፁሳ ያርሾ በሲ፥ ጌሻ ዱንካንያ ፐንገ ስንꬃን ዎꬅስ። ጎዳይ ኪትዳይሳዳ፥ እያ ቦላ ፁሳ ያርሾነ ካꬃ ያርሾ ያርሽስ። ");
INSERT INTO gofe_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","ሜቻ ከርያ ጌሻ ዱንካንያፐነ ያርሾ በሳፈ ግዶን ዎꬅድ፥ እያን ሃ ኩንꬅስ። ");
INSERT INTO gofe_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","ሙሰይ፥ አሮንነ እያ ናይት ባንታ ኩሽያነ ቶሁዋ እያን ሜጨትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","ጎዳይ ኪትዳይሳዳ፥ ኤንቲ ጌሻ ዱንካንያ ገልያ ዎደ ዎይኮ ያርሾ በሲ ሺቅያ ዎደ ሄሳ ኦꬆሶና። ");
INSERT INTO gofe_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","ጌሻ ዱንካንያነ ያርሾ በሳ ዩሽ አꬅድ ዳባባ ጊግስድ፥ ሄ ዳባባ ፐንገን ማጋራጆ ካቅስ። ሄሳዳ ኦꬅድ፥ ሙሰይ ኦሱዋ ፖልስ። ");
INSERT INTO gofe_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","ሄሳፈ ጉየ፥ ሻራይ ጌሻ ዱንካንያ ካምስ፤ ጎዳ ቦንቾይካ እያ ኩምስ። ");
INSERT INTO gofe_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","ሻራይ ጌሻ ዱንካንያ ካምዳ ግሾነ ጎዳ ቦንቾይ እያን ኩምዳ ግሾ፥ ሙሰይ እያ ግዶ ገላናዉ ዳንዳእቤና። ");
INSERT INTO gofe_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","እስራኤለት ባንታ ደእያ በሳ የድድ፥ ባናዉ ደንደይ፥ ሄ ሻራይ ዱንካንያፐ ደንድያ ዎደና። ");
INSERT INTO gofe_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","ሽን ሻራይ ደንዶና እፅኮ፥ ኤንቲ ባንታ ደእያ በሳ የድድ ቦኮና። ");
INSERT INTO gofe_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","ጎዳ ሻራይ ጋላስ ጋላስ ጌሻ ዱንካንያ ካሜስ፥ ቃማ ቃማ ቃስ ሻራ ግዶን ታማይ ኤፄስ። እስራኤለ አሳይ ብያ ዎደ ኡባን ሄ ሻራ በኦሶና። ");
INSERT INTO gofe_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","ጎዳ ፆሳይ፥ ጌሻ ዱንካንያ ግዶን ግድድ ሙሰ ፄግድ ያግስ፤ ");
INSERT INTO gofe_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","እስራኤለ አሳስ ሀይሳዳ ያጋዳ ኦዳ፤ ህንተፈ ኦንካ ጎዳስ ያርሾ ያርሽያ ዎደ ባ መህያፐ፥ ባ ዶርሳፈነ ባ ዴሻፐ ኤሆ። ");
INSERT INTO gofe_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","ሄ ያርሾይ መሄፐ ፁሳ ያርሾስ ግድኮ ቦረይ ባይና ዎፋኖ ግዶ። ጎዳይ ሄ ያርሹዋ ኤካና መላ ጌሻ ዱንካንያ ገልያ ፐንገን ያርሾ። ");
INSERT INTO gofe_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","ያርሹዋ ያርሽያ ኡራይ ፁሳ ያርሾስ ኤህዳ መህያ ሁጰን ባ ኩሽያ ዎꬆ። ሄስ እያ ናጋራ አቶተꬃስ ጎዳይ ኤክዳ ያርሾ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","እ ሄ ዎፋኑዋ ጎዳ ስንꬃን ሹኮ፤ ካህነት፥ አሮና ናይት ሄ ሱꬃ ኤክድ፥ ጌሻ ዱንካነ ገልያ ፐንገን ደእያ ያርሾ በሳ ኦይዱ ማዛነታ ቦላ ዉርፆ። ");
INSERT INTO gofe_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","ሄ መህያ ጋልባ ቃርድ፥ አሹዋ ቆሞን ቆሞን ከሶ። ");
INSERT INTO gofe_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","ካህንያ አሮና ናይት ያርሾ በሳን ምꬅ ዎꬅድ ታማ ኤꬆ። ");
INSERT INTO gofe_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","ካህነት፥ አሮና ናይት ሄ ከስዳ አሹዋ ቦላ ሁጵያነ ሞꬉዋ ጉጅድ፥ ያርሾ በሳን ታማን ደእያ ምꬃ ቦላ ማራይድ ዎꬆ። ");
INSERT INTO gofe_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","ሽን ሄ ኡራይ ኡሎ አሹዋነ ገዳታ ሃꬃን ሜጮ። ካህነይ ሄ ኡባ ያርሾ በሳን ፁጎ፤ ሄስ ጎዳስ ታማን ፁገትያ ሳዎ ቶንኩ ግያ ያርሾ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","ፁገትያ ያርሾስ እ እምያ እሞይ ዶርሳፈ ዎይኮ ዴሻፐ ግድኮ፥ ቦረይ ባይና ማራዘ ዎይኮ ኮለ ግዶ። ");
INSERT INTO gofe_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","ሄ መህያ ያርሾ በሳፈ ፑደሀ ባጋራ ጎዳ ስንꬃን ሹኮ። ካህነት፥ አሮና ናይት ሄ ሱꬃ ኤክድ ያርሾ በሳ ኦይዱ ማዛነታ ኡባ ቦላ ዉርፆ። ");
INSERT INTO gofe_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","ሄ ኡራይ አሹዋ ቆሞን ቆሞን ከሶ፤ ካህነይ ሄ ከስዳ አሹዋ ቦላ ሁጵያነ ሞꬉዋ ጉጅድ፥ ያርሾ በሳን ታማን ደእያ ምꬃ ቦላ ማራይድ ዎꬆ። ");
INSERT INTO gofe_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","ሽን ሄ ኡራይ ኡሎ አሹዋነ ገዳታ ሃꬃን ሜጮ፤ ካህነይ ሄ ኡባ ያርሾ በሳን ፁጎ፤ ሄስ ጎዳስ ታማን ፁገትያ ሳዎ ቶንኩ ግያ ያርሾ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","ጎዳስ ያርሸትያ ፁሳ ያርሾይ ካፎ ግድኮ ሆለ ዎይኮ ኩራቾ ግዶ። ");
INSERT INTO gofe_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","ካህነይ ሄሳ ኤክድ ቆꬍያ ኩሸራ ዱꬆ፤ ሁጵያ ያርሾ በሳ ቦላ ደእያ ታማን ፁጎ። እያ ሱꬃይ ያርሾ በሳ ምየራ ጉኮ። ");
INSERT INTO gofe_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","ኡሎ አሹዋነ ቀፍያ ከስድ፥ ያርሾ በሳፈ ዶሎሀ ባጋራ ብዶ ቆልያ በሳን የጎ። ");
INSERT INTO gofe_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","እ ሄ ካፉዋ ቀፈታ ኦይክድ ሻኮ፥ ሽን ኩመꬅ ሻኮፎ። ካህነይ ያርሾ በሳ ቦላ ደእያ ታማን ዎꬅድ ፁጎ፤ ሄስ ጎዳስ ታማን ፁገትያ ሳዎ ቶንኩ ግያ ያርሾ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","ኦንካ ካꬃ ያርሾ ጎዳስ ያርሽያ ዎደ ሄ ያርሾይ ሎኦ ꬊለ ግዶ፤ እያ ቦላ ዛይተነ እፃነ ጉጆ። ");
INSERT INTO gofe_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","ሄሳ ካህነ ግድዳ አሮና ናይታኮ ኤሆ፤ ካህነት ሄ ሎኦ ꬊልያፈ እስ ኩጫ ኤክድ፥ ዛይተነ እፃነ ኡባ ጉጅድ ያርሾ በሳ ቦላ ታማን ፁጎ። ሄስ ጎዳስ ታማን ፁገትያ ሳዎ ቶንኩ ግያ ቆፍሶ ያርሾ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","ካꬃ ያርሹዋፈ አትዳይስ አሮናስነ እያ ናይታስ ግዳና። ሄስ ጎዳስ ታማን ፁገትዳ ኡባፈ ጌሻ ያርሾ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","ያርሸትያ ኡይꬃይ ጮጨን ኮምፐትዳ ግድኮ፥ ዛይተራ ሙኑቀትዳ ሎኦ ꬊለ ግዶ። ሄ ኡይꬃይ እርሾይ ባይና ዛይተን ሙኑቀትዳይሳ ዎይኮ ሌኦን ኡከትድ ዛይተን ትየትዳይሳ ግዶ። ");
INSERT INTO gofe_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","ያርሸትያ ኡይꬃይ በሸን ኡከትዳባ ግድኮ፥ እርሾይ ባይና ዛይተን ሙኑቀትዳ ሎኦ ꬊለ ግዶ። ");
INSERT INTO gofe_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","እያ መንꬃዳ እያ ቦላ ዛይተ ትጋዳ ካꬃ ያርሾ ኦꬃዳ ያርሻ። ");
INSERT INTO gofe_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","ነ ያርሽያ ካꬃይ ኦቶን ካፅዳባ ግድኮ ዛይተን ሙኑቀትዳ ሎኦ ꬊለ ግዶ። ");
INSERT INTO gofe_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","ሄሳዳ ሀንድ ጊግዳ ካꬃ ያርሹዋ ጎዳስ ኤሀዳ ካህንያስ እማ፤ ካህነይ ሄሳ ኤክድ ያርሾ በሳን ያርሾ። ");
INSERT INTO gofe_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","ካህነይ ሄ ካꬃ ያርሹዋ ኤክድ፥ ያርሾ በሳን ፁሳ ያርሾ ኦꬅድ ታማን ፁጎ። ሄስ ጎዳስ ታማን ፁገትያ ሳዎ ቶንኩ ግያ ቆፍሶ ያርሾ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","ካꬃ ያርሹዋፈ አትዳይስ አሮናስነ እያ ናይታስ ግዳና። ሄስ ጎዳስ ታማን ፁገትዳ ኡባፈ ጌሻ ያርሾ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","ኔኒ እርሾ ዎይኮ ኤስ ጎዳስ ታማን ፁጋዳ ያርሻናዉ በሶና ግሾ ጎዳስ ህንተ ኤህያ ካꬃ ያርሾይ እርሾይ ደእያባ ግዶፖ። ");
INSERT INTO gofe_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","ሀይሳታ ባይራ ያርሾ ኦꬅድ ጎዳስ ያርሻናዉ ዳንዳኤታ፥ ሽን ሳዎ ቶንኩ ግያ ያርሾ ኦꬅድ ጎዳስ ያርሾ በሳን ፁጎፍተ። ");
INSERT INTO gofe_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","ማፅነይ፥ ኔኒ ነ ፆሳራ ጫቅዳ ጫቁዋስ ማላ ግድያ ግሾ ነ ካꬃ ያርሾ ኡባን ማፅነ የጋ። ነ ካꬃ ያርሾ ኡባ ማፅነን ማልኤꬃ። ");
INSERT INTO gofe_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","ኔኒ ካꬃፈ ባይራ ጎዳስ ኤህያ ዎደ ጫጨትድ ሽርከትዳ ትያ ግዳናዉ በሴስ። ");
INSERT INTO gofe_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","ሄስ ካꬃ ያርሾ ግድያ ግሾ እያ ቦላ ዛይተ ትጋ፤ እፃነ ዎꬃ። ");
INSERT INTO gofe_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","ካህነይ ሄ ጫጨትድ ሽርከትዳነ ዛይተይ ትገትዳ ካꬃ ያርሹዋፈ ባጋ ኤክድ እፃነ ኡባራ ቆፍሶ ያርሾ ኦꬅድ ጎዳስ ታማን ፁጎ። ");
INSERT INTO gofe_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","እስ አስ እስፈተꬃ ያርሾስ ባ መህያፐ ቦረይ ባይና ኡስ ዎይኮ ዎፋኖ ጎዳ ስን ሺሾ። ");
INSERT INTO gofe_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","ያርሻናዉ ኤህዳ መህያ ሁጰን ባ ኩሽያ ዎꬅድ ጌሻ ዱንካንያ ፐንገን ሹኮ። ካህነት፥ አሮና ናይት ሱꬃ ኤክድ ያርሾ በሳ ኦይዱ ማዛንያ ቦላ ዉርፆ። ");
INSERT INTO gofe_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","እስፈተꬃ ያርሹዋፈ ፁሳ ያርሾ ኦꬅድ ጎዳስ ሺሾ፤ ሄስካ ኡሎ አሹዋ ካምዳ ሞꬍያ፥ ");
INSERT INTO gofe_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","ናምኡ ክላሆታ፥ ኤንታ ቦላ ደእያ ሞꬍያነ ትርያ ፄራ ባጋ ኤኮ። ");
INSERT INTO gofe_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","አሮና ናይት ሄሳ ፁሳ ያርሹዋራ እስፈ ያርሾ በሳ ቦላ ደእያ ምꬃ ቦላ ዎꬅድ ፁጎ። ሄስ ጎዳስ ፁገትያ ሳዎ ቶንኩ ግያ ያርሾ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","እስፈተꬃ ያርሾስ ሺቀይ ማጫ ዎይኮ አደ ዶርሰ ግድኮ ቦረይ ባይናባ ግዶ። ");
INSERT INTO gofe_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","እስ አስ ዶርሳ ኡርገ ያርሽያባ ግድኮ ሄሳ ጎዳ ስንꬃን ሺሾ። ");
INSERT INTO gofe_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","ሄ ዶርሳ ኡርግያ ሁጰን ባ ኩሽያ ዎꬅድ ጌሻ ዱንካንያ ፐንገን ሹኮ። አሮና ናይት ሱꬃ ኤክድ ያርሾ በሳ ኦይዱ ማዛንያ ቦላ ዉርፆ። ");
INSERT INTO gofe_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","እስፈተꬃ ያርሹዋፈ ጎዳስ ፁሳ ያርሾ ኦꬅድ ያርሾ፤ ሄስካ ሞꬉዋ፥ ጎይናፐ ብድ ዞኮ መቀꬃ ጋካናዉ ደእያ ሞꬉዋ፥ ኡሎ አሹዋ ካምዳ ሞꬍያ፥ ");
INSERT INTO gofe_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","ናምኡ ክላሆታ፥ ኤንታ ካምዳ ሞꬍያ ትርያ ፄራ ባጋ ኤኮ። ");
INSERT INTO gofe_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","ካህነይ ሄሳ ጎዳስ ፁሳ ያርሾ ኦꬅድ ያርሾ በሳን ፁጎ። ");
INSERT INTO gofe_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","እ ያርሸይ ዴሸ ግድኮ እ ሄሳ ጎዳ ስን ሺሾ። ");
INSERT INTO gofe_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","እያ ሁጰን ባ ኩሽያ ዎꬅድ ጌሻ ዱንካንያ ስንꬃን ሹኮ። አሮና ናይት ሱꬃ ኤክድ ያርሾ በሳ ዩሹዋ ዉርፆ። ");
INSERT INTO gofe_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","እ ሄ ያርሹዋፈ ኤክድ ጎዳስ ፁሳ ያርሾ ኦꬅድ ያርሾ፤ ሄስካ ኡሎ አሹዋ ካምዳ ሞꬍያ ኡባ፥ ");
INSERT INTO gofe_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","ናምኡ ክላሆታ፥ ኤንታ ካምዳ ሞꬍያ ትርያ ፄራ ባጋ ኤኮ። ");
INSERT INTO gofe_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","ካህነይ ሄሳ ጎዳስ ሳዎ ቶንኩ ግያ ያርሾ ኦꬅድ ያርሾ በሳን ፁጎ። ሞꬎ ኡባይ ጎዳባ። ");
INSERT INTO gofe_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","ህንተ ሞꬎነ ሱꬅ ሞፕተ። ሄስ ህንተስነ ያና የለተꬃይ ደእያ በሳ አዉንካ ናግያ ዎጋ ግዶ። ");
INSERT INTO gofe_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","ጎዳይ ሙሰኮ ሀይሳዳ ያግስ፤ ");
INSERT INTO gofe_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","ኔኒ እስራኤለ አሳስ ሀይሳዳ ያጋዳ ኦዳ፤ ኦንካ ቆፖና ናጋራ ኦꬅኮ ዎይኮ ጎዳ ኪታታፐ እሱዋ መንꬅኮ፥ ");
INSERT INTO gofe_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","ዶረትዳ ካህነይ ናጋራ ኦꬅድ አሳ ጎመን ጋꬅኮ፥ እ ባ ኦꬅዳ ናጋራ ግሾ ቦረይ ባይና ዎፋኖ ጎዳስ ናጋራ ያርሾ ኦꬅድ ኤሆ። ");
INSERT INTO gofe_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","ሄ ዎፋኑዋ ጌሻ ዱንካንያ ፐንገ ኤህድ፥ ሁጰን ባ ኩሽያ ዎꬅድ ጎዳ ስንꬃን ሹኮ። ");
INSERT INTO gofe_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","ዶረትዳ ካህነይ ዎፋኑዋ ሱꬃፈ ጉꬃራ ኤክድ ጌሻ ዱንካንያ ገልስድ፥ ");
INSERT INTO gofe_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","ባ ብራꬍያ ሱꬃን የድ ኤክድ ጌሻ ዱንካንያ ማጋራጁዋ ስንꬃን ጎዳ ስንꬃን ላፑን ቶሆ ዉርፆ። ");
INSERT INTO gofe_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","ካህነይ ጉꬃ ሱꬅ ኤክድ ጌሻ ዱንካንያን ጎዳ ስንꬃን ሳውያ እፃነ ጩይስያ በሳን ደእያ ካጨታ ትዮ። አትዳ ሱꬃ ጌሻ ዱንካንያ ገልያ ፐንገ ባጋራ ደእያ ፁሳ ያርሾ በሳ ጋርሳን ጉሶ። ");
INSERT INTO gofe_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","ናጋራ ያርሾስ ሹከትዳ ዎፋኑዋ ሞꬉዋ ኡባ፥ ኡሎ አሹዋ ማእዳ ሞꬉዋ፥ ");
INSERT INTO gofe_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","ናምኡ ክላሆታ፥ ኤንታ ካምዳ ሞꬍያነ ትርያ ፄራ ባጋ ኤኮ። ");
INSERT INTO gofe_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","እስፈተꬃ ያርሾስ ሹከትዳ ዎፋኑዋ ሞꬉዋ ከስዳይሳዳ እያፐ ሞꬉዋ ከሶ። ካህነይ ፁሳ ያርሾ ኦꬅድ ያርሾ በሳን ፁጎ። ");
INSERT INTO gofe_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","ሽን ዎፋኑዋ ጋልባ፥ እያ አሹዋ ኡባ፥ እያ ሁጵያ፥ እያ ቶሆታ፥ ኡሎ አሹዋ፥ ቶጭያ፥ ");
INSERT INTO gofe_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","አሹዋፐ አትዳይሳ ኡባ ጉታፐ ካረ ከስድ ብዶ የግያ ዎጋ መላ ጌሻ በሲ ኤፍድ ያን ታማን ፁጎ። ");
INSERT INTO gofe_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","እስራኤለ ማባራ ኡባይ ቆፖና ናጋራ ኦꬅኮነ ጎዳ ኪታታፐ እሱዋ መንꬅኮ ሄስ ኤንታፈ ቆሰትኮካ ኤንታዉ ባላ ግድድ ታይበታና። ");
INSERT INTO gofe_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","ኤንቲ ኦꬅዳ ናጋራ አኬክያ ዎደ ናጋራ ያርሾስ ሀንያ ዎፋኖ ጌሻ ዱንካንያ ስን ኤሆ። ");
INSERT INTO gofe_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","ማባራ ጭማት ባንታ ኩሽያ ዎፋኑዋ ሁጰን ዎꬅድ ጎዳ ስንꬃን ሹኮ። ");
INSERT INTO gofe_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","ዶረትዳ ካህነይ ዎፋኑዋ ሱꬃፈ ጉꬃራ ኤክድ ጌሻ ዱንካንያ ግዶ ገሎ። ");
INSERT INTO gofe_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","እ ባ ብራꬍያ ሱꬃን የድ ኤክድ ማጋራጁዋ ስንꬃ ባጋራ ጎዳ ስንꬃን ላፑን ቶሆ ዉርፆ። ");
INSERT INTO gofe_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","ቃስ ጉꬃ ሱꬅ ኤክድ፥ ጌሻ ዱንካንያ ግዶን ጎዳ ስንꬃን እፃነ ጩይስያ በሳን ደእያ ካጨታ ቦላ ትዮ። አትዳ ሱꬃ ጌሻ ዱንካንያ ገልያ ፐንግያ ባጋራ ደእያ ፁሳ ያርሾ በሳ ጋርሳን ጉሶ። ");
INSERT INTO gofe_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","ሞꬎ ኡባ ኤክድ ያርሾ በሳን ፁጎ። ");
INSERT INTO gofe_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","ሀ ዎፋኑዋካ ናጋራ ያርሾስ ሹከትዳ ዎፋኑዋ መላ ኦꬃዳ ሺሻ። ሄሳዳ ኦꬅድ፥ ካህነይ ናጋራ አቶተꬃ ዎጋ ፖላና፤ አሳ ናጋራይ አቶ ጌተታና። ");
INSERT INTO gofe_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","ካህነይ ዎፋኑዋ ጉታፐ ካረ ከስድ፥ ኮይሮ ዎፋኖይ ፁገትዳይሳዳ እያካ ፁጎ፤ ሄስ ማባራስ ያርሸትያ ናጋራ ያርሾ። ");
INSERT INTO gofe_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","አሳ ካለꬅያ ሹማታፐ እሶይ ቆፖና ናጋራ ኦꬅኮነ ጎዳ ፆሳ ኪታፐ እሱዋ መንꬅኮ ሄ ኡራይ ባላ። ");
INSERT INTO gofe_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","እ ባ ኦꬅዳ ናጋራ አኬክዳፐ ጉየ፥ ቦረይ ባይና እስ ኮለ ኤሆ። ");
INSERT INTO gofe_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","ሄ ኮልያ ሁጰን ባ ኩሽያ ዎꬅድ ፁሳ ያርሾይ ያርሸትያ በሳን ጎዳ ስንꬃን ሹኮ፤ ሄስ ናጋራ ያርሾ። ");
INSERT INTO gofe_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","ካህነይ ባ ብራꬍያ ሱꬃን የድ ኤክድ፥ ፁሳ ያርሾ በሳን ደእያ ካጨታ ቦላ ትዮ፤ አትዳ ሱꬃ ቃስ ፁሳ ያርሾ በሳ ጋርሳን ጉሶ። ");
INSERT INTO gofe_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","እስፈተꬃ ያርሾስ ሺቅዳ ሞꬉዋ ኡባ ፁግዳይሳዳ ሀ ኮልያ ሞꬉዋ ፁጎ። ሄሳዳ ኦꬅድ፥ ካህነይ ሄ ኡራ ናጋራ ቁሽሴስ፤ ሄ ኡራ ናጋራይ አቶ ጌተታና። ");
INSERT INTO gofe_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","ማባራፐ እስ አስ ቆፖና ናጋራ ኦꬅኮነ ጎዳ ኪታፐ እሱዋ መንꬅኮ ሄ ኡራይ ባላ ግዴስ። ");
INSERT INTO gofe_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","እ ባ ኦꬅዳ ናጋራ አኬክዳፐ ጉየ ቦረይ ባይና ማጫ ዴሽ ባ ናጋራ ግሾ ኤሆ። ");
INSERT INTO gofe_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","ባ ኩሽያ ሄ ዴሸ ሁጰን ዎꬆ፤ ያትድ ፁሳ ያርሾ በሳን ናጋራ ያርሾ ኦꬅድ ሹኮ። ");
INSERT INTO gofe_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","ሄሳፈ ጉየ፥ ካህነይ ሄ ዴሸ ሱꬃን ባ ብራꬍያ የድ ኤክድ ፁሳ ያርሾ በሳን ደእያ ካጨታ ቦላ ትዮ። አትዳ ሱꬃ ኡባ ያርሾ በሳፈ ጋርሳን ጉሶ። ");
INSERT INTO gofe_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","እስፈተꬃ ያርሾስ ሹከትዳ መህያፐ ሞꬉዋ ከስዳይሳ መላ ሄ ዴሸ ሞꬉዋ ቃር ከስድ፥ ያርሾ በሳን ጎዳስ ሳዎ ቶንኩ ግያ ያርሾ ኦꬅድ ፁጎ። ሄሳዳ ኦꬅድ፥ ካህነይ ሄ ኡራ ናጋራ ቁሽሴስ፤ እያ ናጋራይ አቶ ጌተታና። ");
INSERT INTO gofe_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","ሄ ኡራይ ባ ናጋራ ግሾ ያርሸይ ዶርሰ ግድኮ፥ ቦረይ ባይና ማጫ ዶርሰ ግዶ። ");
INSERT INTO gofe_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","እ ባ ኩሽያ ሄ ዶርሰ ሁጰን ዎꬆ፤ ያትድ፥ ፁሳ ያርሾ መሄ ሹክያ በሳን ሹኮ። ");
INSERT INTO gofe_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","ሄሳፈ ጉየ፥ ካህነይ ዶርሰ ሱꬃን ባ ብራꬍያ የድ ኤክድ ፁሳ ያርሾይ ያርሸትያ በሳን ደእያ ካጨታ ቦላ ትዮ። አትዳ ሱꬃ ያርሾ በሳፈ ጋርሳን ጉሶ። ");
INSERT INTO gofe_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","እስፈተꬃ ያርሾስ ሹከትዳ መህያፐ ሞꬉዋ ከስዳይሳዳ ሄ ዶርሰ ሞꬉዋ ቆር ከስድ፥ ያርሾ በሳን ጎዳስ ፁሳ ያርሾ ኦꬅድ ፁጎ። ሄሳዳ ኦꬅድ፥ ካህነይ ሄ ኡራ ናጋራ ቁሽሴስ፤ እያ ናጋራይ አቶ ጌተታና። ");
INSERT INTO gofe_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","እስ አስ ባ በእዳባ ዎይኮ ባ ኤርያባ ማርካታና መላ ኦይሸትድ ማርካቶና እፅኮ ሄ ኡራይ ናጋራ ኦꬅዳ ግሾ ሴረቶ። ");
INSERT INTO gofe_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","እስ አስ ኤሮና ደእሸ ቱናባ፥ ሄስካ፥ ሀይቅዳ ዶአ ዎይኮ መሄ ዎይኮ ሳአራ ጎሸትያ ዶአታ ቦችኮ፥ ሄስ ቱና ግደይሳ እ ኤሮና እፅኮካ ቱና ግድያ ግሾ ባላ ግዴስ። ");
INSERT INTO gofe_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","እስ አስ ኤሮና ደእሸ አሳ አሳተꬃፈ ጎግድ ቱንስያባ ቦችኮ፥ ሄስ ቱና ግደይሳ እ ኤሮና እፅኮ፥ ቱና ግድያ ግሾ ባላ ግዴስ። ");
INSERT INTO gofe_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","እስ አስ ኢታባ ግድን ሎኦባ ኦꬃናዉ ኤሶን ጫቅኮነ ባ ጫቅዳይሳ ዶግድ፥ ጉየፐ እ አኬክዳ ዎደፐ ዶምድ ባላ ግዴስ። ");
INSERT INTO gofe_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","እስ አስ ሀ ኦደትዳ ባላታፐ እሱዋ ኦꬅዳባ ግድኮ ባ ኦꬅዳ ናጋራ ፓፆ። ");
INSERT INTO gofe_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","እ ባ ኦꬅዳ ናጋራ ግሾ ጎዳስ ባ መህያ ግዶፈ ማጫ ዶርሰ ዎይኮ ማጫ ዴሸ ናጋራ ያርሾ ኦꬅድ ሺሾ። ካህነይ ኤክድ ሄ ኡራ ናጋራ ቁሸꬃስ ያርሻና። ");
INSERT INTO gofe_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","እስ አስ ባ ኦꬅዳ ናጋራ ግሾ ያርሻናዉ ዶርሰ ዎይኮ ዴሸ ሻማናዉ እያዉ ጋተይ ጋኮና እፅኮ ናምኡ ኩራቾታ ዎይኮ ናምኡ ሆለታ፥ እሱዋ ናጋራ ያርሾስ ቃስ እሱዋ ፁሳ ያርሾስ ኦꬅድ ጎዳስ ኤሆ። ");
INSERT INTO gofe_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","እ ኤንታ ካህንያስ እሞ፤ ካህነይ ናምኡ ሆለታፐ እሱዋ ቆꬍያ ምርቅድ ዱꬆናሽን፥ ናጋራ ያርሾ ኦꬅድ ሺሾ። ");
INSERT INTO gofe_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","ያትድ ሱꬃፈ ጉꬃራ ኤክድ፥ ያርሾ በሳ ማታን ዉርፆ፤ አትዳ ሱꬃ ያርሾ በሳ ጋርሳን ጉሶ፤ ሄስ ናጋራ ያርሾ። ");
INSERT INTO gofe_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","ሀንኮ ሆልያ ቃስ ህገይ ኪተይሳዳ ፁሳ ያርሾ ኦꬅድ ፁጎ። ካህነይ ሀይሳዳ ኦꬅድ፥ ኡራይ ኦꬅዳ ናጋራ ቁሽሳናዉ ያርሾ ያርሼስ፤ ሄ ኡራ ናጋራይ አቶ ጌተታና። ");
INSERT INTO gofe_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","ሽን እስ አስ ናምኡ ሆለ ዎይኮ ናምኡ ኩራቾ ኤሀናዉ ጋተይ ጋኮና እፅኮ፥ እስ ክሎ ግራመ ሎኦ ꬊለ ባ ናጋራ ግሾ ያርሾ ኦꬅድ ኤሆ። ሄ ꬊለይ ናጋራ ያርሾ ግድያ ግሾ ዛይተይ ዎይኮ እፃነይ እያ ቦላ ጉዠቶፎ። ");
INSERT INTO gofe_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","እ ሄሳ ኤህድ ካህንያስ እሞ፤ ካህነይ ሄ ꬊልያፈ እስ ኩጫ ኤክድ፥ ጎዳስ ሺቅያ ካꬃ ያርሹዋራ ጋꬅድ፥ ቆፍሶ ኦꬅድ ያርሾ በሳን ፁጎ፤ ሄስ ናጋራ ያርሾ። ");
INSERT INTO gofe_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","እስ አስ ሀ ናጋራታፐ እሱዋ ኦꬅኮ ሀይሳዳ ኦꬅድ እያ ናጋራ ቁሽሴስ፤ ሄ ኡራ ናጋራይ አቶ ጌተታና። ሄ ያርሹዋፈ አትዳይስ ካꬃ ያርሹዋዳ ካህንያስ ግዶ። ");
INSERT INTO gofe_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","ጎዳይ ሙሰኮ ሀይሳዳ ያግስ፤ ");
INSERT INTO gofe_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","ኦንካ ጎዳ ናቅኮነ ጌሻ ሚሸታ ቱንስድ ቆፖና ናጋራ ኦꬅኮ ባ ናቁዋስ ባ መህያ ግዶፈ ቦረይ ባይና እስ ማራዘ ጎዳስ ኤሆ። እያ ጋተይ ጌሻ ዱንካነን ኤረትዳ ምዛነ ግናን ጭገቶ፤ ሄስ ናቆ ያርሾ። ");
INSERT INTO gofe_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","እ ጌሻ ሚሸታ ቦላ ናጋራ ኦꬅዳ ግሾ ኮይሮ ጭጋናዉ በሲያ ጋትያ ቦላ ፄታፐ ላታሙ ኩሸ ጉጅድ ካህንያስ እሞ። ካህነይ ሄሳ ማራዝያራ ጋꬅ ያርሽድ ኡራ ናቁዋ ቁሽሴስ፤ እያ ናጋራይ አቶ ጌተቴስ። ");
INSERT INTO gofe_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","እስ አስ ቆፖናሽን፥ ጎዳ ኪታታፐ እሱዋ መንꬅድ ናጋራ ኦꬅኮ እ ሄሳ ኤሮና እፅኮካ ባላ ግድያ ግሾ ባ ናጋራን ሴረቶ። ");
INSERT INTO gofe_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","እ ባ መህያፐ ቦረይ ባይናነ ጋተ ኩንꬅያ እስ ማራዘ ናቆ ያርሾስ ካህንያኮ ኤሆ። ካህነይ ሄ ማራዝያ ያርሽድ ኡራ ናቁዋ ቁሽሴስ፤ እያ ናቆይ አቶ ጌተቴስ። ");
INSERT INTO gofe_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","እ ቱማፐ ጎዳ ናቅዳ ግሾ ሄስ ናቆ ያርሾ። ");
INSERT INTO gofe_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","ጎዳይ ሙሰኮ ሀይሳዳ ያግስ፤ ");
INSERT INTO gofe_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","እስ አስ ሀራ አስ ሀዳራ ዎꬅዳባ ዎይኮ ታልእዳባ ላህኮ ዎይኮ ቦንቅኮ ዎይኮ ጭምኮ፥ ");
INSERT INTO gofe_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","ዎይኮ ꬋይዳባ ደምድ ታ በአብከ ግድ ዎርዶን ጫቅኮነ አስ ኦꬅያ ሀይሳ መላባፐ እሱዋ ኦꬅኮ፥ ");
INSERT INTO gofe_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","ሄሳን ናጋራንቾ ግድድ በንትኮ፥ ካይስዳባ ዎይኮ ቦንቅዳባ ዎይኮ ሀዳራ ኤክዳባ ዎይኮ ꬋይን ደምዳባ፥ ");
INSERT INTO gofe_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","ዎይኮ ዎርዶን ጫቅድ ኤክዳ ኩመꬃ ሻሉዋ ጎዳስ ዛሮ። ቃስ ባ ናቆ ያርሹዋ ያርሽያ ጋላስ ባ ኤክዳባ ቦላ ፄታፐ ላታሙ ኩሸ ጉጅድ ሻሉዋ ጎዳስ እሞ። ");
INSERT INTO gofe_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","ቃስ ባ ናቁዋ ግሾ ጎዳስ ያርሾ ያርሽያ ዎደ ባ መህያ ግዶፈ ቦረይ ባይና እስ ማራዘ ካህንያኮ ኤሆ። ሄ ዶርሳይ ናቆ ያርሾስ ጋተ ኩንይሳ ግዶ። ");
INSERT INTO gofe_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","ካህነይ ሄ ዶርሳ ያርሽድ ሄ ኡራ ናቁዋ ቁሽሴስ፤ ሄ ኡራ ናቆይ አቶ ጌተታና። ");
INSERT INTO gofe_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","ጎዳይ ሙሰኮ ሀይሳዳ ያግስ፤ ");
INSERT INTO gofe_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","አሮናነ እያ አደ ናይታ ሀይሳዳ ያጋዳ ኪታ፤ ፁሳ ያርሹዋስ ደእያ ዎጋይ ሀይሳ፤ ፁሳ ያርሾይ ሳእ ዎንታና ጋካናዉ ያርሾ በሳን ደኦ። ታማይ ያርሾ በሳን ቃማ ኩመꬅ ኤፅሸ አቆ። ");
INSERT INTO gofe_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","ካህነይ ሊኖፐ ዳደትዳ ቃምሰ ማእድ፥ ሱረ ዳንጭድ፥ ፁሳ ያርሹዋ ታማይ ምዳ ብዱዋ ካሽድ ያርሾ በሳ ምየን ላሎ። ");
INSERT INTO gofe_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","ያትድ ማኡዋ ቃር ዎꬅድ ሀራ ማኦ ማእድ ሄ ብዱዋ ጉታፐ ጋፃ ኤፍድ ዎጋዳ ጌሻ በሳን ቆሎ። ");
INSERT INTO gofe_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","ያርሾ በሳ ቦላ ደእያ ታማይ ቶኦና ኡባ ዎደ ኤፅሸ ደኦ። ካህነይ ዎንታ ዎንታ ምꬅ እያ ቦላ ጉጆ። ፆሳ ያርሹዋ ምꬃ ቦላ ማራን ዎꬅድ፥ እስፈተꬃ ያርሹዋ ሞꬉዋ እያ ቦላ ፁጎ። ");
INSERT INTO gofe_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","ታማይ ያርሾ በሳ ቦላ ኡባ ዎደ ኤፅሸ ደኦ፤ ቶአናዉ ኮሸና። ");
INSERT INTO gofe_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","ካꬃ ያርሾስ እመትዳ ዎጋይ ሀይሳ፤ ካህነ ግድዳ አሮና ናይት ያርሾ በሳፈ ስንꬃ ባጋራ ጎዳ ስንꬃን ያርሾ። ");
INSERT INTO gofe_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","ካህነይ እስ ኩጫ ሎኦ ꬊለነ ዛይተ ኤክድ ካꬃ ያርሹዋ ቦላ ደእያ እፃንያራ ያርሾ በሳን ጎዳስ ሳዎ ቶንኩ ግያ ቆፍሶ ያርሾ ኦꬅድ ፁጎ። ");
INSERT INTO gofe_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","እያፐ አትዳይሳ አሮንነ እያ አደ ናይት ኡይꬅ ኡክድ ዱንካንያ ዳባባን ደእያ ጌሻ በሳን ሞ። ");
INSERT INTO gofe_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","ሄ ኡይꬃይ እርሾይ ባይና ኡከቶ። ታማን ፁሳ ያርሹዋፈ ሄሳ ታኒ ኤንታዉ ግሾ ኦꬃዳ እማስ። ናጋራ ያርሹዋ መላነ ናቆ ያርሹዋ መላ እ ኡባፈ ጌሽ። ");
INSERT INTO gofe_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","ጎዳስ ታማን ፁሳ ያርሹዋፈ ኤንታ ጋክያ ግሾ ግድያ ግሾ ያ የለተꬃን አሮና ኮቸ ግድዳ አደት ኡባይ ሄሳ ሞ። ሄ ያርሹዋ፥ ጌሽ ግዶና ኦንካ ቦቾፎ። ");
INSERT INTO gofe_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","ጎዳይ ሙሰኮ ሀይሳዳ ያግስ፤ ");
INSERT INTO gofe_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","አሮንነ እያ አደ ናይት ካህነተꬃን ትየትያ ዎደ እስ ክሎ ግራመ ግድያ ሎኦ ꬊለ ካꬃ ያርሾ ኦꬅድ ጎዳስ ኤሆ። እያፐ ባጋ ዎንታ፥ ባጋ ኦማርስ ያርሾ። ");
INSERT INTO gofe_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","ሄ ꬊለይ ዛይተራ ዋላከትድ ሎይꬅ ሙኑቀትድ ባሸን ኡከቶ፤ እያ መንꬃዳ ያርሾ በሳን ሳዎ ቶንኩ ግያ ካꬃ ያርሾ ኦꬃዳ ጎዳስ ያርሻ። ");
INSERT INTO gofe_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","ቃስ አሮና አደ ናይታፐ እያ ካህነተꬃ ላታናዉ ትየትያ ኦንካ ሄ ዎጋ ጊግሴስ። ሄስ ጎዳስ ኡባ ዎደ ያርሸትያ ያርሾ ግድያ ግሾ ኩመꬅ ፁገቶ። ");
INSERT INTO gofe_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","ካህነይ ካꬃ ያርሹዋ ጉየ አሾና ፁጋናዉ ኮሼስ፤ እ ሜተታናዉ በሰና። ");
INSERT INTO gofe_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","ጎዳይ ሙሰኮ ሀይሳዳ ያግስ፤ ");
INSERT INTO gofe_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","አሮናስነ እያ አደ ናይታስ ሀይሳዳ ያጋ፤ “ናጋራ ያርሾ ዎጋይ ሀይሳ፤ ናጋራስ ሹከትያ ያርሾይ ፁሳ ያርሾይ ሹከትያ በሳን ጎዳ ስንꬃን ሹከቶ። ሄ ያርሾይ ኡባፈ ጌሻ ያርሾ። ");
INSERT INTO gofe_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","ሄ ያርሹዋ ያርሽያ ካህነይ ዱንካንያ ዳባባን ደእያ ጌሻ በሳን ሞ። ");
INSERT INTO gofe_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","ሄ አሹዋ ቦችያ ኦንካ ጌሽ ግዶ፤ ቃስ ሹክሽን ሱꬅ ማኡዋ ቦችኮ ሄ ማኦይ ጌሻ በሳን ሜጨቶ። ");
INSERT INTO gofe_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","አሾይ ካፅዳ ኦቶይ መቆ፤ ብራታ ድስተን ካፅዳባ ግድኮ ሄ ሚሽያ ቃጭድ ሃꬃን ሜጫናዉ ኮሼስ። ");
INSERT INTO gofe_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","ካህነ ኮቻፈ አደ ግድዳ ኦንካ ሄ አሹዋ ሞ፤ ሄ ያርሾይ ኡባፈ ጌሽ። ");
INSERT INTO gofe_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","ሽን ጌሻ በሳን ናጋራ አቶተꬃስ ሱꬃ ኤክድ ዱንካንያ ግዶ ገልዳባ ግድኮ ሄ መህያ አሾይ ሜተታናዉ ኮሸና፤ እ ታማን ፁገታናዉ በሴስ።” ");
INSERT INTO gofe_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","ኡባፈ ጌሽ ግድያ ግሾ ናቆ ያርሾ ዎጋይ ሀይሳ፤ ");
INSERT INTO gofe_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","ፁሳ ያርሾ መሄይ ሹከትያ በሳን ናቆ ያርሾ መሄይ ሹከቶ፤ እያ ሱꬃይ ያርሾ በሳ ኦይዱ ባጋን ዉርፀቶ። ");
INSERT INTO gofe_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","እያ ሞꬉዋ ኡባ፥ ሄስካ ጎይናፐ ብድ ዞኮ መቀꬃ ጋካናዉ ደእያ ሞꬉዋ፥ ኡሎ አሹዋ ካምዳ ሞꬍያ፥ ");
INSERT INTO gofe_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","ናምኡ ክላሆታ፥ ኤንታ ካምዳ ሞꬍያነ ትርያ ፄራ ባጋ ኤክድ ያርሾ። ");
INSERT INTO gofe_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","ካህነይ ሀይሳታ ታማን ፁሳ ያርሾ ኦꬅድ ጎዳስ ያርሾ፤ ሄስ ናቆ ያርሾ። ");
INSERT INTO gofe_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","ካህነ ያራ ግድዳ አደ ኡባይ ሄ ያርሾ አሹዋ ሞ። ሄ ያርሾይ ኡባፈ ጌሽ ግድያ ግሾ ጌሻ በሳን ሜተቶ። ");
INSERT INTO gofe_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","ናቆ ያርሹዋነ ናጋራ ያርሹዋ ዎጋይ እስኖ። ሄ መህያ አሾይ ናጋራ አቶተꬃስ ያርሽዳ ካህንያስ እመቴስ። ");
INSERT INTO gofe_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","ኦንካ ፁሳ ያርሾ መሄ ኤህን ኤክድ ያርሽያ ካህነይ ሄ መህያ ጋልባ ባዉ ኤኮ። ");
INSERT INTO gofe_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","ጮጨን ኮምፐትዳ ዎይኮ ኦቶን ካፅዳ ዎይኮ ባሸን ኡከትዳ ኡባይ ሄ ያርሹዋ ያርሽዳ ካህንያስ እመቴስ። ");
INSERT INTO gofe_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","ቃስ ዛይተራ ሙኑቀትዳ ዎይኮ ሙኑቀቶና ካꬃ ያርሾ ኡባይ አሮና አደ ናይታ ኡባስ እስ ግና ሻከትድ እመቴስ። ");
INSERT INTO gofe_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","እስ አስ እስፈተꬃ ያርሾ ጎዳስ ያርሽያ ዎደ እያዉ ደእያ ዎጋይ ሀይሳ፤ ");
INSERT INTO gofe_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","እ ያርሸይ ጋላታ ያርሾ ግድኮ ሄ ያርሹዋራ እስፈ ዛይተራ ሙኑቅዳ ኡይꬁ፥ እርሾይ ገሎና ኡከትድ ዛይተን ትየትዳ ሌኦ ኡይꬁነ ሎኦ ꬊለፈ ዛይተራ ሙኑቀትዳ ኡይꬁ ሺሾ። ");
INSERT INTO gofe_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","ሄ እስፈተꬃ ያርሹዋራ እስፈ እርሾራ ኡከትዳ ኡይꬃ እሞታ ኦꬅድ ያርሾ። ");
INSERT INTO gofe_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","ሄ እስ እስ ኡይꬃፈ እሱዋ ደንꬅድ ጎዳስ ያርሾ ኦꬅድ ኤሆ። ሄስ እስፈተꬃ ያርሹዋ ሱꬃ ዉርፅዳ ካህንያስ እመቶ። ");
INSERT INTO gofe_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","ሄ መህያ አሾይ ሄ ጋላስ ሜተቶ፤ ዎንታስ አይብካ አቶፎ። ");
INSERT INTO gofe_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","ሽን እያ ያርሾይ ጋሶ ያርሾ ዎይኮ ዶሳ ያርሾ ግድኮ ሄ አሾይ ሄ ያርሸትዳ ጋላስ ሜተቶ፤ እያፐ አተይ ደእኮ ዎንተꬃ ጋላስ ሜተቶ። ");
INSERT INTO gofe_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","ሄ አሹዋፐ ፓላህድ ሄꬓንꬆ ጋላስ ጋካናዉ ጋምእኮ ሄስ ታማን ፁገቶ። ");
INSERT INTO gofe_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","እስ አስ ሺሽዳ እስፈተꬃ ያርሾ አሾይ ሄꬓንꬆ ጋላሳን ሜተትኮ እያ ያርሾይ ኤከተና፤ ያርሾይ ያርሸትዳዳ ታይበተና። ሄ ያርሾይ ቱና፤ እያፐ ምዳ ኦንካ ባ ናጋራን ኦይሸቴስ። ");
INSERT INTO gofe_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","ቱናባ ቦችዳ አሾይ ሜተቶፎ፤ እ ታማን ፁገታናዉ ኮሼስ። ሀራ አሹዋ ዎጋን ቱና ግዶና አስ ኦንካ ማና ጊኮ ሞ። ");
INSERT INTO gofe_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","ሽን እስ አስ ቱና ግድ ኡትድ፥ ጎዳስ ሺቅዳ እስፈተꬃ ያርሾ አሹዋፐ ምያባ ግድኮ፥ ሄ ኡራይ አሳ ግዶፈ ኩረቶ። ");
INSERT INTO gofe_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","እስ አስ ቱናባ ቦችኮ፥ አሳ ቱናተꬅ ግድን ዎይኮ ቱና መሄ ግድን ዎይኮ ሀራ እፀትያ ቱናባ ቦችድ፥ ጎዳስ ያርሸትዳ እስፈተꬃ ያርሾ አሹዋፐ ሚኮ፥ ሄ ኡራይ ባ አሳ ግዶፈ ኩረቶ። ");
INSERT INTO gofe_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","ጎዳይ ሙሰኮ ሀይሳዳ ያግስ፤ ");
INSERT INTO gofe_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","እስራኤለ አሳስ ሀይሳዳ ያጋዳ ኦዳ፤ ኮርማ ዎይኮ ማራዘ ዎይኮ ኮለ ሞꬎ አሹዋ ሞፕተ። ");
INSERT INTO gofe_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","ሀይቅዳ መሄ ዎይኮ ዶእ ዎꬍዳ መህያ ሞꬉዋ ሀራባስ ጎኤትተፐ አትን፥ እያፐ አይባካ ሞፕተ። ");
INSERT INTO gofe_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","ጎዳስ ታማን ፁሳ ያርሾስ ሺቅያ መህያ ሞꬎ አሹዋ ምያ ኦንካ ባ አሳ ግዶፈ ኩረቶ። ");
INSERT INTO gofe_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","ህንተ ደእያ በሳን አዉን ግድኮካ፥ ካፎ ሱꬅ ዎይኮ መሄ ሱꬅ ሞፕተ። ");
INSERT INTO gofe_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","ሱꬅ ምያ ኦንካ ባ አሳ ግዶፈ ኩረቶ። ");
INSERT INTO gofe_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","ጎዳይ ሙሰኮ ሀይሳዳ ያግስ፤ ");
INSERT INTO gofe_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","እስራኤለ አሳስ ሀይሳዳ ያጋዳ ኦዳ፤ ጎዳስ እስፈተꬃ ያርሾ ሺሽያ ኦንካ ሄ እስፈተꬃ ያርሹዋፈ ሻክድ ባ እሞታ ኦꬅድ ጎዳስ ዱማይድ ያርሾ። ");
INSERT INTO gofe_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","ሄሳ እ ጎዳስ ታማን ፁሳ ያርሾ ኦꬅድ፥ ባ ኩሸን ኤክድ ኤሆ። ቃስ ሞꬉዋ አንጋሱዋራ ጋꬅ ኤህድ ዩሾ ያርሾ ኦꬅድ ጎዳ ስንꬃን ያርሾ። ");
INSERT INTO gofe_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","ካህነይ ያርሾ በሳን ሞꬉዋ ፁጎ፤ ሽን አንጋሶይ አሮናስነ እያ አደ ናይታስ እመቶ። ");
INSERT INTO gofe_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","ህንተ እስፈተꬃ ያርሹዋፈ ኡሻቻ ገዳ እሞታ ኦꬅድ ካህንያስ እምተ። ");
INSERT INTO gofe_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","ሄ ኡሻቻ ገዳይ እስፈተꬃ ያርሹዋ ሱꬃነ ሞꬉዋ ያርሽያ ካህንያ ጋክያ ግሾ ግዶ። ");
INSERT INTO gofe_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","ታኒ እስራኤለ አሳ እስፈተꬃ ያርሹዋፈ ዩሾ አንጋሱዋን ሺቅዳ ገዳ እስራኤለ አሳፐ ኤካዳ፥ ካህንያ አሮናስነ እያ አደ ናይታስ ግሾ ኦꬃዳ እማስ። ሄስ ኤንታ ጋክያ ኤንታ ግሾ ግድያ ግሾ እስራኤለ አሳይ መርናዉ ሄሳ ኤንታዉ እምሸ ዳና። ");
INSERT INTO gofe_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","አሮንነ እያ አደ ናይት ካህነ ግድድ ሹመትዳ ጋላስ ጎዳስ ሺቅዳ ፁሳ ያርሹዋፈ፥ ሄስካ ኤንታዉ ግሾ ግድድ እመትስ። ");
INSERT INTO gofe_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","ጎዳይ ኤንታ ካህነተꬃስ ትይዳ ጋላስ፥ ሄሳ ኤንታዉ እማና መላ እስራኤለ አሳ ኪትስ፤ ሄስ ያና የለተꬃን ኤቅድ ደእያ ዎጋ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","ህዛ ፁሳ ያርሹዋ፥ ካꬃ ያርሹዋ፥ ናጋራ ያርሹዋ፥ ናቆ ያርሹዋ፥ ካህነት ትየትያ ዎደ ያርሸትያ ያርሹዋነ እስፈተꬃ ያርሹዋ ዎጋይ ሀይሳ። ");
INSERT INTO gofe_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","እስራኤለ አሳይ ሲና መላ ቢታን ባንታ ያርሹዋ ጎዳስ ያርሻና መላ ጎዳይ ኪትዳ ጋላስ፥ ሲና ዙማ ቦላ ጎዳይ ሙሰ ኪትዳ ዎጋይ ሀይሳ። ");
INSERT INTO gofe_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","ጎዳይ ሙሰስ ሀይሳዳ ያግድ ኦድስ፤ ");
INSERT INTO gofe_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","አሮናነ እያ አደ ናይታ፥ ኤንታራ እስፈ ካህነተꬃ ማኡዋ፥ ትዮ ዛይትያ፥ ናጋራ ያርሹዋ ሹከትያ ኮርማ፥ ናምኡ ማራዘታነ፥ እርሾይ ገልቦና ኡከትዳ ኡይꬃ ዎꬅያ ጋይታ ኤካዳ ያ። ");
INSERT INTO gofe_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","ቃስ እስራኤለ አሳ ኡባ ፄጋዳ ዱንካንያ ፐንገ ሺሻ። ");
INSERT INTO gofe_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","ሙሰይ ጎዳይ ኪትዳይሳዳ ኦꬅስ፤ አሳ ኡባይ ዱንካንያ ፐንገ ሺቅስ። ");
INSERT INTO gofe_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","ሙሰይ አሳኮ፥ ታ ኦꬃና መላ ጎዳይ ኪትዳይስ ሀይሳ። ");
INSERT INTO gofe_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","ሙሰይ አሮናነ እያ አደ ናይታ ኤህድ ሃꬃን ሜጭስ። ");
INSERT INTO gofe_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","አሮና ማኡዋ ማይዝድ፥ ዳንጮ ዳንጭስስ፤ አዱሳ ማኡዋ ማይዝድ እያ ቦላ ኤፉደ ማኡዋ ማይዝስ። ኤፉድያ አሌቅስድ ዳድዳ ሳቅያን አሮና ፄሳራ ጋꬅድ ቃችስ። ");
INSERT INTO gofe_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","ኤፉድያ ቦላ ትራ ኪሰ ስክድ እያን ኡሪመነ ቱሚመ ዎꬅስ። ");
INSERT INTO gofe_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","አሮና ሁጰን ፃꬃ ቃጨ ዎꬅስ። ጎዳይ ሙሰ ኪትዳይሳዳ ፃꬃ ቃጭያ ስንꬃ ባጋራ ጌሻ ዎርቃ ጉቸ ምስልያ ዎꬅስ። ");
INSERT INTO gofe_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","ሄሳፈ ጉየ ሙሰይ ትዮ ዛይትያ ኤክድ፥ ዱንካንያነ ዱንካንያ ግዶን ደእያ ሚሸ ኡባ ትይድ ዱማይስ። ");
INSERT INTO gofe_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","ሄ ዛይትያፐ ኤክድ ያርሾ በሳ ቦላ ላፑን ቶሆ ዉርፅስ፤ እያ ሚሸታ፥ ሜቻ ከርያነ እያ ኡቱዋ ዱማያናዉ ሄ ዛይትያራ ትይስ። ");
INSERT INTO gofe_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","ሄ ትዮ ዛይትያፐ ጉꬃራ ኤክድ አሮና ሁጰን ትግድ እያ ዱማይስ። ");
INSERT INTO gofe_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","ጎዳይ ሙሰ ኪትዳይሳዳ ሙሰይ አሮና አደ ናይታ ስን አꬅድ ማኦ ማይዝድ ዳንጮ ዳንጭስስ። ኤንታ ሁጰን ፃꬃ ቃጨ ዎꬅስ። ");
INSERT INTO gofe_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","ሙሰይ ናጋራ ያርሾስ ያርሸትያ ኮርማ ኤህስ፤ አሮንነ እያ አደ ናይት ሄ ኮርማ ሁጰን ባንታ ኩሽያ ዎꬅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","ሙሰይ ሄ ኮርማ ሹክድ እያ ሱꬃን ባ ብራꬍያ የድ ኤክድ፥ ያርሾ በሳን ደእያ ካጨታ ትይድ ያርሾ በሳ ጌሽስ። አትዳ ሱꬃ ያርሾ በሳፈ ጋርሳን ጉስስ፤ ሄሳዳ ኦꬅድ ያርሾ በሳ ፆሳስ ዱማይድ ጌሽስ። ");
INSERT INTO gofe_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","ሙሰይ ኡሎ አሹዋ ካምዳ ሞꬉዋ ኡባ፥ ትርያ ፄራ ባጋ፥ ክላሆታነ ኤንታ ካምዳ ሞꬉዋ ኤክድ፥ ያርሾ በሳን ፁግስ። ");
INSERT INTO gofe_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","ሽን ጎዳይ ሙሰ ኪትዳይሳዳ ኮርማ ጋልባ፥ አትዳ አሹዋነ ቶጭያ ጉታፐ ጋፃ ከስድ ፁግስ። ");
INSERT INTO gofe_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","ሄሳፈ ጉየ ሙሰይ ፁሳ ያርሾስ ማራዘ ኤህስ፤ አሮንነ እያ አደ ናይት ሄ ማራዝያ ሁጰን ባንታ ኩሽያ ዎꬅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","ሙሰይ ሄ ማራዝያ ሹክስ፤ እያ ሱꬃ ያርሾ በሳ ኦይዱ ማዛነታ ቦላ ዉርፅስ። ");
INSERT INTO gofe_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","ሙሰይ ማራዝያ አሹዋ ቆሞን ቆሞን ቃንፀረꬅስ፤ ሁጵያ፥ አትዳ አሹዋነ ሞꬉዋ ፁግስ። ");
INSERT INTO gofe_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","ጎዳይ ሙሰ ኪትዳይሳዳ ኡሎ አሹዋነ ገዳታ ሜጭድ፥ ኩመꬃ ዶርሳ ጎዳስ ሳዎ ቶንኩ ግያ ፁሳ ያርሾ ኦꬅድ ያርሾ በሳን ፁግስ። ");
INSERT INTO gofe_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","ካህነት ሹመትያ ዎደ ሺቅያ ናምአንꬆ ዶርሳ ሙሰይ ኤህስ፤ አሮንነ እያ አደ ናይት ሄ ዶርሳ ሁጰን ባንታ ኩሽያ ዎꬅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","ሙሰይ ሄ ማራዝያ ሹክስ፤ እያ ሱꬃፈ ኤክድ፥ አሮናስ ኡሻቻ ሀይꬃ፥ ኡሻቻ ኩሽያ ዎጋ ብራꬍያነ፥ ኡሻቻ ቶሁዋ ዎጋ ብራꬍያ ትይስ። ");
INSERT INTO gofe_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","ቃስ ሙሰይ አሮና አደ ናይታ ስን አꬅድ፥ ሄ ሱꬃፈ ኤክድ፥ ኤንታ ኡሻቻ ሀይꬃ፥ ኡሻቻ ኩሽያ ዎጋ ብራꬍያነ ኡሻቻ ቶሁዋ ዎጋ ብራꬍያ ትይስ። ያትድ፥ ሙሰይ አትዳ ሱꬃ ያርሾ በሳ ኦይዱ ማዛነታ ቦላ ዉርፅስ። ");
INSERT INTO gofe_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","ሞꬉዋ፥ ጎይናፐ ብድ ዞኮ መቀꬃ ጋካናዉ ደእያ ሞꬉዋ፥ ትርያ ፄራ ባጋ፥ ክላሆታነ ኤንታ ካምዳ ሞꬉዋነ ኡሻቻ ገዳ ኤክስ። ");
INSERT INTO gofe_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","ጎዳ ስንꬃን ደእያ ጋይታፐ እርሾይ ባይና ኡከትዳ እስ ኡይꬃ፥ ኡከትድ ዛይተን ትየትዳ እስ ኡይꬃነ ሌኦን ኡከትዳ ኡይꬃ ኤክድ ሞꬉዋ ቦላነ ኡሻቻ ገዳ ቦላ ዎꬅስ። ");
INSERT INTO gofe_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","እ ሄ ካꬃ ኡባ አሮና ኩሸንነ እያ አደ ናይታ ኩሸን ዎꬅን፥ ጎዳ ስንꬃን ዩሾ ያርሾ ኦꬅድ ያርሽዶሶና። ");
INSERT INTO gofe_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","ሙሰይ ሄ ካꬃ ኤንታ ኩሸፐ ኤክድ፥ ፁሳ ያርሹዋራ ጋꬅድ፥ ካህነታ ሹምያ ዎደ ጎዳስ ሳዎ ቶንኩ ግያ ያርሾ ኦꬅድ ያርሾ በሳን ፁግስ። ");
INSERT INTO gofe_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","ቃስ ሙሰይ አንጋሱዋ ኤክድ፥ ዩሾ ያርሾ ኦꬅድ ጎዳ ስንꬃን ያርሽስ። ጎዳይ ሙሰ ኪትዳይሳዳ፥ ካህነታ ሹምያ ዎደ ያርሸትያ ማራዝያ አሹዋፐ ሄስ ሙሰ ጋክያ ግሾ። ");
INSERT INTO gofe_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","ሙሰይ ትዮ ዛይትያፐነ ያርሾ በሳን ደእያ ሱꬃፈ ኤክድ፥ አሮና ቦላነ እያ ማኡዋ ቦላ፥ እያ አደ ናይታ ቦላነ፥ ኤንታ ማኡዋ ቦላ ዉርፅስ፤ አሮናነ እያ ማኡዋ፥ እያ ናይታነ ኤንታ ማኡዋ ዱማይስ። ");
INSERT INTO gofe_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","ሙሰይ አሮናነ እያ አደ ናይታኮ ሀይሳዳ ያግስ፤ አሹዋ ዱንካንያ ፐንገን ካꬅተ፤ አሮንነ እያ አደ ናይት ታ ኪትዳይሳዳ ጋይታን ደእያ ጌሻ ኡይꬃራ ሚተ። ");
INSERT INTO gofe_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","ሄ አሹዋፐነ ኡይꬃፈ ፓላህዳይ ደእኮ ታማን ፁግተ። ");
INSERT INTO gofe_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","ካህነታ ሹምያ ዎጋይ ላፑን ጋላስ ኤክያ ግሾ ሄ ዎጋይ ፖለትያ ላፑን ጋላሳይ ዉራና ጋካናዉ ዱንካንያ ፐንገፈ ካረ ከዮፕተ። ");
INSERT INTO gofe_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","ጎዳይ ኪትን ሀች ፖለትዳ ዎጋይ ህንተ ናጋራ ቁቻናሳ። ");
INSERT INTO gofe_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","ዱንካንያ ፐንገን ላፑን ጋላስ ኩመꬅ ጋላስነ ቃማ ጋምእተ፤ ጎዳ ዎጋ ናግተ፤ እፅኮ ህንተ ሀይቃና። ታና ጎዳይ ኪትዳይ ሀይሳ። ");
INSERT INTO gofe_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","አሮንነ እያ አደ ናይት ጎዳይ ሙሰ ባጋራ ኪትዳባ ኡባ ኦꬅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","ሆስፑንꬃ ጋላስ ሙሰይ አሮና፥ እያ አደ ናይታነ እስራኤለ ጭማታ ፄግስ። ");
INSERT INTO gofe_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","አሮናኮ ሀይሳዳ ያግስ፤ ቦረይ ባይና እስ ኮርማ ናጋራ ያርሾስ፥ ቃስ እስ ማራዘ ፁሳ ያርሾስ ጎዳ ስን ሺሻ። ");
INSERT INTO gofe_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","ቦረይ ባይና እስ ኮለ ናጋራ ያርሾስ፥ እስ ላይꬅ ኩምዳ ማርነ ዶርሳ ኡርገ ፁሳ ያርሾስ ባንታዉ ኤሀና መላ እስራኤለ አሳስ ኦዳ። ");
INSERT INTO gofe_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","ቃስ እስፈተꬃ ያርሾስ እስ ኮርማ፥ እስ ማራዘነ ካꬃ ያርሾስ ዛይተራ ሙኑቀትዳ ꬊለ ኤሀና መላ ኤንታዉ ኦዳ። ሀች ጎዳይ ህንተዉ ቆንጫና ግሾ ሄሳ ኦꬅተ። ");
INSERT INTO gofe_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","ኤንቲ ሙሰይ ኪትዳባ ኡባ ጌሻ ዱንካንያ ስን ኤህዶሶና፤ ማባራ ኡባይ ሺቅድ ጎዳ ስንꬃን ኤቅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","ሙሰይ ኤንታኮ፥ ጎዳ ቦንቾይ ህንተዉ ቆንጫና መላ ህንተ ኦꬃና መላ ጎዳይ ኪትዳይ ሀይሳ። ");
INSERT INTO gofe_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","ሙሰይ አሮናኮ ሀይሳዳ ያግስ፤ “ያርሾ በሳኮ ሺቃዳ ነ ናጋራ ግሾ ናጋራ ያርሾነ ፁሳ ያርሾ ያርሻ። ጎዳይ ኪትዳይሳዳ አሳ ናጋራ አቶተꬃስ ያርሾ ያርሻ።” ");
INSERT INTO gofe_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","አሮን ያርሾ በሳኮ ይድ፥ ባ ናጋራ ግሾ ያርሸትያ ማራ ሹክስ። ");
INSERT INTO gofe_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","አሮና ናይት ሱꬃ ኤክድ እያዉ ኤህዶሶና፤ እ፥ ባ ብራꬍያ ሄ ሱꬃን የድ ኤክድ፥ ያርሾ በሳን ደእያ ካጨታ ትይስ፤ አትዳ ሱꬃ ያርሾ በሳፈ ጋርሳን ጉስስ። ");
INSERT INTO gofe_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","ጎዳይ ሙሰ ኪትዳይሳዳ፥ አሹዋፐ ሞꬉዋ፥ ክላሆታነ ትርያ ፄራ ባጋ ኤክድ ያርሾ በሳን ፁግስ። ");
INSERT INTO gofe_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","ሽን አትዳ አሹዋነ ጋልባ ጉታፐ ካረ ከስድ ፁግስ። ");
INSERT INTO gofe_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","አሮን ፁሳ ያርሾስ ሺቅዳ መህያ ሹክስ፤ እያ ናይት ሱꬃ ኤክድ እያዉ ኤህዶሶና። እ ያርሾ በሳ ኦይዱ ማዛነታ ቦላ ዉርፅስ። ");
INSERT INTO gofe_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","ኤንቲ አሹዋ ቆሞን ቆሞን ከስድ፥ ሁጵያራ ዎላ እያዉ ኤህዶሶና፤ እ ኤክድ ያርሾ በሳን ፁግስ። ");
INSERT INTO gofe_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","ኡሎ አሹዋነ ገዳታ ሃꬃን ሜጭድ፥ ያርሾ በሳን ደእያ ፁሳ ያርሹዋ ቦላ ዎꬅድ ፁግስ። ");
INSERT INTO gofe_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","ሄሳፈ ጉየ፥ አሮን አሳ ግሾ ያርሾ ያርሽስ። እ አሳ ናጋራ ግሾ ያርሸትያ ኮልያ ኤክድ ሹክስ፤ እ ካሰ ባ ናጋራ ያርሽዳይሳዳ ኤንታ ናጋራ ግሾ ያርሽስ። ");
INSERT INTO gofe_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","ዎጋይ ኪተይሳዳ ፁሳ ያርሾስ ሺቅያ መህያ ኤህድ ያርሽስ። ");
INSERT INTO gofe_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","ካꬃ ያርሹዋ ኤህድ፥ እያፐ እስ ኩጫ ኤክድ፥ ዎንታ ዎንታ ፁሳ ያርሹዋ ቦላ ጉጅድ ያርሾ በሳን ፁግስ። ");
INSERT INTO gofe_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","አሮን ኮርማነ ማራዝያ አሳስ እስፈተꬃ ያርሾ ኦꬅድ ሹክስ፤ እያ አደ ናይት ሱꬃ እያዉ ኤህዶሶና፤ እ ሄ ሱꬃ ኤክድ ያርሾ በሳ ኦይዱ ማዛነታ ቦላ ዉርፅስ። ");
INSERT INTO gofe_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","ኮርማነ ማራዝያ አሹዋፐ ሞꬉዋ፥ ጎይናፐ ብድ ዞኮ መቀꬃ ጋካናዉ ደእያ ሞꬉዋ፥ ኡሎ አሹዋ ካምዳ ሞꬉዋ፥ ክላሆታነ ትርያ ፄራ ባጋ ኤክድ፥ ");
INSERT INTO gofe_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","ኤንቲ አንጋይሱዋ ቦላ ዎꬅን፥ አሮን ያርሾ በሳን ፁግስ። ");
INSERT INTO gofe_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","ጎዳይ ሙሰ ኪትዳይሳዳ፥ አሮን አንጋይሱዋነ ኡሻቻ ገዳ ዩሾ ያርሾ ኦꬅድ ጎዳ ስንꬃን ዩሽስ። ");
INSERT INTO gofe_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","ሄሳፈ ጉየ፥ አሮን ባ ኩሽያ አሳኮ ደንꬅድ ኤንታ አንጅስ። እ ናጋራ ያርሹዋ፥ ፁሳ ያርሹዋነ እስፈተꬃ ያርሹዋ ያርሽዳፐ ጉየ ያርሾ በሳፈ ዎꬍስ። ");
INSERT INTO gofe_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","ሙሰይነ አሮን ጌሻ ዱንካንያ ግዶ ገልዶሶና፤ ኤንቲ ያፐ ከይድ አሳ አንጅዶሶና። ሄ ዎደ ጎዳ ቦንቾይ አሳ ኡባስ ቆንጭስ። ");
INSERT INTO gofe_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","ጎዳ ማታፐ ታም ዎꬍድ፥ ያርሾ በሳን ደእያ ፁሳ ያርሹዋነ ሞꬉዋ ምስ። አሳ ኡባይ ሄሳ በእዳ ዎደ እልልዶሶና፤ ጉፋንድ ቦንችዶሶና። ");
INSERT INTO gofe_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","አሮና አደ ናይት፥ ናዳብነ አብዮድ፥ ባንታ እፃነ ጩይስያ ሚሸ ኤክድ እያ ቦላ ታማ ዎꬅዶሶና፤ እያ ቦላ እፃነ ጉጅዶሶና። ጎዳይ ኤንታ ኪትቦና ጮ ታማ ጎዳ ስንꬃን ሺሽዶሶና። ");
INSERT INTO gofe_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","ሄሳ ጋሶን ጎዳ ማታፐ ታም ይድ ኤንታ ምን፥ ኤንቲ ጎዳ ስንꬃን ሀይቅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","ሙሰይ አሮናኮ፥ ጎዳይ፥ “ታኒ አሳ ግዶፈ ታኮ ሺቀይሳታ፥ ታ ጌሻተꬃ በሳና። ቃስ አሳ ኡባ ስንꬃን ታ ቦንቸታና” ግድ ኦድዳይሳ ሀይሳ በአ። አሮን ዛሮ እሞና ስእ ግስ። ");
INSERT INTO gofe_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","ሙሰይ አሮና አዋ እሻ ኡዝኤላ አደ ናይታ ምሳኤላነ ኤልዛፋና ፄግድ፥ “ሃ ይድ ህንተ አዋ እሻ ናይታ አሀ ጌሻ ዱንካንያ ስንꬃፈ ደንꬅድ፥ ጉታፐ ጋፃ ከስተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","ኤንቲ ይድ፥ ሙሰይ ኪትዳይሳዳ ኤንታ ካህነተꬃ ማኡዋራ ኤንታ አሀ ቶክድ፥ ጉታፐ ጋፃ ከስዶሶና። ");
INSERT INTO gofe_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","ሙሰይ አሮናነ እያ አደ ናይታ፥ አላዛራነ እታማራ ሀይሳዳ ያግስ፤ “ህንተ ሀይቆና መላነ ጎዳይ ባ አሳ ቦላ ሀንቀቶና መላ ህንተ ሁጵያ ሜዶፕተ፤ ህንተ ማኡዋካ ዳኮፍተ። ሽን ህንተ እሻት፥ እስራኤለ አሳይ፥ ጎዳይ ባ ታማን ዎꬍዳይሳታስ ዬኮ። ");
INSERT INTO gofe_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","ጎዳ ትዮ ዛይተይ ህንተ ቦላ ድእያ ግሾ ዱንካንያ ፐንገፈ ካረ ከዮፕተ፤ ከይኮ ህንተ ሀይቃና” ያግስ። ኤንቲ ሙሰይ ግዳይሳዳ ኦꬅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","ጎዳይ አሮናኮ ሀይሳዳ ያግስ፤ ");
INSERT INTO gofe_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","ህንተ ሀይቆና መላ ዱንካንያ ግዶ ገልያ ዎደ ነነ ነ ናይት ዎይነ ኡሽ ዎይኮ ሀራ ማꬆይያ ኡሽ ኡዮፕተ፤ ሄስ ስንꬃፈ ያና የለተꬃስ መርናዉ ኤቅድ ደእያ ዎጋ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","ህንተ ጌሻባነ ጌሽ ግዶናባ ቃስ ቱናባነ ቱና ግዶናባ ሻክድ ኤርተ። ");
INSERT INTO gofe_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","ጎዳይ ሙሰ ባጋራ ኦድዳ ዎጋ ኡባ እስራኤለ አሳ ታማርስተ። ");
INSERT INTO gofe_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","ሙሰይ አሮናነ አትዳ እያ አደ ናይታ አላዛራነ እታማራ ሀይሳዳ ያግስ፤ ጎዳስ ፁሳ ያርሹዋፈ አትዳ ካꬃ ያርሹዋ ኤክድ እርሾ የጎና ኡክተ። እ ኡባፈ ጌሽ ግድያ ግሾ ያርሾ በሳ ማታን ሚተ። ");
INSERT INTO gofe_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","ጎዳስ ፁሳ ያርሹዋፈ ሄስ ነናነ ነ አደ ናይታ ጋክያ ግሾ ግድያ ግሾ፥ ሄሳ ህንተ ጌሻ በሳን ሚተ፤ ሀይሳ ህንተ ኦꬃና መላ ጎዳይ ታና ኪትስ። ");
INSERT INTO gofe_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","ሽን ዩሾ ያርሾስ ሺቅዳ አንጋሱዋነ ገዳ ኔኒ፥ ነ አደ ናይትነ ነ ማጫ ናይት ጌሻ በሳን ሚተ። ሄስ እስራኤለ አሳይ ሺሽያ እስፈተꬃ ያርሹዋፈ ነናነ ነ አደ ናይታ ጋክያ ህንተ ግሾ። ");
INSERT INTO gofe_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","ጎዳስ ያርሽዳ ገዳነ ዩሾ ያርሾስ ሺቅዳ አንጋሱዋ ሞꬉዋራ እስፈ ጋꬅድ ጎዳ ስንꬃን ዩሾ ያርሾ ኦꬅድ ያርሻናዉ ሺቆ። ጎዳይ ኪትዳይሳዳ፥ ሄስ ነዉነ ነ አደ ናይታስ መርናዉ ህንተና ጋክያ ግሾ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","ሙሰይ ናጋራ ያርሾስ ሺቅዳ ዴሻ ኤንቲ ዋትዳኮ ኤራናዉ ኮይድ ኦይችስ፤ እ ፁገትዳይሳ ኤርዳ ዎደ አትዳ አሮና አደ ናይታ፥ አላዛራነ እታማራ ቦላ ሀንቀትስ። ");
INSERT INTO gofe_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“ናጋራ ያርሾስ ሺቅዳ አሹዋ አይስ ጌሻ በሳን ምቤከቲ? እ ኡባፈ ጌሽ። ጎዳ ስንꬃን አሳ ናጋራ ድግድ አሳስ አቶተꬅ እማና መላ ሄስ ህንተዉ እመትስ። ");
INSERT INTO gofe_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","ሄ መህያ ሱꬃይ ጌሻ ዱንካንያ ግዶ ገልቦና ግሾ፥ ታኒ ህንተና ኪትዳይሳዳ፥ ህንተ እያ ጌሻ በሳን ማናዉ በሴስ፥ ሽን አግደታ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","አሮን ሙሰኮ፥ “ሄኮ፥ ሀ አሳት ሀች ባንታ ናጋራ ያርሹዋነ ፁሳ ያርሹዋ ጎዳ ስን ኤህዶሶና። ግዶሽን፥ ሄሳ መላባይ ታ ቦላ ጋክስ። ታኒ ናጋራ ያርሹዋ ሀች ምዳባ ግድያኮ፥ ጎዳይ ኡፋይታናሽን አትዴ?” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","ሙሰይ ሄሳ ስእዳ ዎደ እያ ዛሩዋን ኡፋይትስ። ");
INSERT INTO gofe_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","ጎዳይ ሙሰኮነ አሮናኮ፥ ");
INSERT INTO gofe_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","እስራኤለ አሳስ ሀይሳዳ ያግድ ኦድተ፤ “ቢታ ቦላ ደእያ መሄታፐነ ዶአታፐ ህንተ ማናይሳት ሀይሳታ፤ ");
INSERT INTO gofe_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","ሹቁለይ ጳልቀትዳይሳታነ ዋሞትያ መሄታ ሚተ። ");
INSERT INTO gofe_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","ሽን ዋሞትሸ ሹቁለይ ጳልቀቶናይሳታነ ሹቁለይ ጳልቀꬅ ግድድ ዋሞቶናይሳታ ሞፕተ። ግማለይ ዋሞቴስ፥ ሽን ሹቁለይ ጳልቀቶና ግሾ፥ ህንተዉ ቱና ግዶ። ");
INSERT INTO gofe_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","ጉፓለይ ዋሞቴስ፥ ሽን ሹቁለይ ጳልቀቶና ግሾ፥ ህንተዉ ቱና ግዶ። ");
INSERT INTO gofe_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","ኤሸይ ዋሞቴስ፥ ሽን ሹቁለይ ጳልቀꬅ ግዶና ግሾ፥ ህንተዉ ቱና ግዶ። ");
INSERT INTO gofe_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","ጉዱንꬆ ሞፕተ፤ እያዉ ሹቁለይ ጳልቀꬅ፥ ሽን ዋሞቶና ግሾ፥ እ ህንተዉ ቱና። ");
INSERT INTO gofe_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","ህንተ ሄሳታ ሞፕተ፤ ኤንታ ባዉታ ቦቾፍተ፤ ኤንቲ ህንተዉ ቱና። ");
INSERT INTO gofe_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“ሃꬃ ግዶን ደእያ መተꬃ ኡባፈ ህንተ ማናይሳት ሀይሳታ፤ አባ ግዶን ዎይኮ ሻፋ ሃꬃ ግዶን ደእያ ኡባፈ ቀፈይነ ፖቆይ ደእያ ኡባ ሚተ። ");
INSERT INTO gofe_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","ሽን አባ ግዶን ዎይኮ ጎግያ ሃꬃን ደእያ ቀፈይነ ፖቆይ ባይና መተꬃት ህንተዉ ቱና ግድያ ግሾ ሞፕተ። ");
INSERT INTO gofe_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","ሀይሳቲ ህንተዉ ቱና፤ ኤንታ ሞፕተ፤ ኤንታ ባዉታ ቦቾፍተ። ");
INSERT INTO gofe_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","ቀፈይነ ፖቆይ ባይና ሃꬃ ግዶን ደእያ መተꬃት ኡባይ ህንተዉ ቱና። ");
INSERT INTO gofe_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“ካፎታፐ ህንተዉ ቱና ግድዳይሳትነ ህንተ ማናዉ በሶናይሳት ሀይሳታ፤ አርጋንꬅ፥ አንኮ፥ ሞሎ ካፎ፥ ");
INSERT INTO gofe_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","ፅሎ፥ ጵርጮ ቆሞ ኡባ፥ ");
INSERT INTO gofe_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","ቁሮ ኡባ ");
INSERT INTO gofe_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","ያንቾ፥ ሶሎ፥ ቆለ፥ ጉቶ ኡባ፥ ");
INSERT INTO gofe_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","ጉꬃ ጉቶ፥ ሀዛዞ፥ ዲድን፥ ");
INSERT INTO gofe_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","ሃꬃ ኩቶ፥ ሽአ አንኮ፥ ዳረ አንኮ፥ ");
INSERT INTO gofe_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","ስላጎ፥ ሳብሳነ እያ ቆሞ ኡባ፥ አያና ካፎነ ሽርሽቆ። ");
INSERT INTO gofe_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“ቀፈራ ደእያ ኦይዱ ቶሆን ሄመትያ ላፋ መተꬃት ኡባይ ህንተዉ ቱና። ");
INSERT INTO gofe_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","ግዶሽን፥ ቀፈይ ደእያ ኦይዱ ቶሆን ሄመተይሳታፐ ኤንታ ቶሁዋፐ ቦላራ ጉፓናዉ ማድያ ቶሆይ ደኤይሳታ ሚተ። ");
INSERT INTO gofe_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","ሄሳትካ፥ ቦለ ቆሞ ኡባ፥ ፃቆ ኡባነ ሰረ ኡባ። ");
INSERT INTO gofe_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","ሽን ሀራ ቀፈራ ደእያ ኦይዱ ቶሆይ ደእያ መተꬃት ኡባይ ህንተዉ ቱና። ");
INSERT INTO gofe_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","“ሀይሳቲ ህንተና ቱንሳና፤ ኤንታ ባዉታ ቦችያ ኦንካ ኦማርስ ጋካናዉ ቱና ግዳና። ");
INSERT INTO gofe_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","ኤንታ ባዉታ ደንꬅያ ኦንካ ባ ማኡዋ ሜጮ፤ ሽን ኦማርስ ጋካናዉ እ ቱና ግዶ። ");
INSERT INTO gofe_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","ሹቁለይ ደእሸ ጳልቀꬅ ግዶናይሳት ዎይኮ ዋሞቶናይሳት ኡባይ ህንተዉ ቱና፤ ኤንታ ቦችያ ኦንካ ቱኔስ። ");
INSERT INTO gofe_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","ኦይዱ ቶሆታን ሄመትያ ዶአ ኡባፈ ግንደራ ሄመተይሳት ህንተዉ ቱና፤ ኤንታ ባዉታ ቦችያ ኦንካ ኦማርስ ጋካናዉ ቱኔስ። ");
INSERT INTO gofe_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","ኤንታ ባዉታ ደንꬅያ ኦንካ ባ ማኡዋ ሜጮ፤ ሽን ኦማርስ ጋካናዉ እ ቱና። ኤንትካ ህንተዉ ቱና። ");
INSERT INTO gofe_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“ሳአራ ሄመተይሳታፐ ሀይሳቲ ህንተዉ ቱና። ኤንትካ ግሮ፥ ኤጨረ፥ ዱማ ዱማ ኮቸ፥ ");
INSERT INTO gofe_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","ጌገ፥ ሀይላሾ፥ ኮርቸ፥ ዋካላነ ሻቃንቾ። ");
INSERT INTO gofe_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","ሳአራ ሄመትያ ኡባፈ ሀይሳቲ ህንተዉ ቱና፤ ኤንታ ባዉታ ቦችያ ኦንካ ኦማርስ ጋካናዉ ቱና ግዴስ። ");
INSERT INTO gofe_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","ኤንታ ባዉታ ቦችያ አይ ሚሸይካ ቱና ግዴስ፤ ምꬃ ሚሸይ ዎይኮ ማኦይ ዎይኮ ጋልብ ዎይኮ ኦጎሮይ ቱና ግዴስ። ኤንታ ባዉታይ ቦችዳ ሚሸ ኡባይ ሃꬃን ሙከትድ ኦማርስ ጋካናዉ ጋምኦ፤ ሄሳፈ ጉየ ጌሽ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","ኤንታፈ እሱዋ ባዉታይ ኦቶ ግዶን ዎꬍድ በንትኮ፥ እያ ግዶን ደእያባ ኡባይ ቱና፤ ሄ ኦቱዋ መንꬅተ። ");
INSERT INTO gofe_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","አይ ካꬅ ግድን ሄ ኦቱዋ ግዶን ደእያ ሃꬃፈ ፆክኮ፥ ሄ ካꬃይ ቱና ግዴስ፤ ኡየትያባ ግድን፥ ሄ ኦቱዋ ግዶን ደእኮ ቱና ግዴስ። ");
INSERT INTO gofe_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","ሄ ባዉታፐ እሶይ ዎꬍዳ ሚሸ ኡባይ ቱና፤ ጮጨ ዎይኮ ኦቶ ግድኮካ መንꬅተ፤ ኤንቲ ህንተዉ ቱና። ");
INSERT INTO gofe_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","ሄ ባዉታይ ቦችዳ ኡባይ ቱና ግድኮካ ፑልቶይነ ሃꬃ ኦል ቱነና። ");
INSERT INTO gofe_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","ኤንታ ባዉታፐ እሶይ ዘረꬃ ካꬃ ቦላ ዎꬍኮ፥ ሄስ ቱነና። ");
INSERT INTO gofe_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","ሽን ሄ ዘረꬃ ቦላ ሃꬅ ጉክድ ስምን፥ ኤንታ ባዉታፐ እሶይ እያ ቦላ ዎꬍኮ፥ ሄ ዘረꬃይ ህንተዉ ቱና። ");
INSERT INTO gofe_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“ሜተትያ መሄታፐ እሶይ ባዉትኮ፥ እያ ባዉታ ቦችያ ኦንካ ኦማርስ ጋካናዉ ቱና። ");
INSERT INTO gofe_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","ኦንካ ሄ መህያ ባዉታፐ ሚኮ፥ ባ ማኡዋ ሜጮ፤ ኦማርስ ጋካናዉ እ ቱና። ኦንካ እያ ባዉታ ቶክድ ደንꬅኮ፥ ባ ማኡዋ ሜጮ፤ ኦማርስ ጋካናዉ እ ቱና። ");
INSERT INTO gofe_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“ሳአራ ጎሸትያ መተꬅ ኡባይ ህንተዉ ቱና፤ እያ ሞፕተ። ");
INSERT INTO gofe_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","ኡሎራ ጎሸትያባ ግድን፥ ኦይዱ ቶሆራ ሄመትያባ ግድን፥ ዳሮ ቶሆይ ደእያባ ግድን፥ ሳአራ ጎሸትያ መተꬅ ኡባይ ህንተዉ ቱና ግድያ ግሾ ሞፕተ። ");
INSERT INTO gofe_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","ሀ ሳአራ ጎሸትያ መተꬃታን ህንተና ቱንሶፕተ፤ ኤንታ ጋሶን ህንተ አሳተꬃ ቱንሶፕተ። ");
INSERT INTO gofe_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","ታኒ ጎዳ፥ ህንተ ፆሳ። ታኒ ጌሽ ግድያ ግሾ፥ ህንተና ዱማይድ ጌሽ ግድተ። ሳአራ ጎሸትያባታን ህንተ አሳተꬃ ቱንሶፕተ። ");
INSERT INTO gofe_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","ታኒ ህንተዉ ፆሰ ግዳናዉ ህንተና ግብፀ ቢታፈ ከስዳ ህንተ ጎዳ። ሄሳ ግሾ፥ ታኒ ጌሽ ግድያ ግሾ፥ ህንተካ ጌሽ ግድተ። ");
INSERT INTO gofe_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","“መሄ፥ ካፎ፥ ሃꬃ ግዶን ቃፅያ መተꬅ ኡባነ ሳአራ ሄመትያ መተꬃ ኡባ ዎጋይ ሀይሳ። ");
INSERT INTO gofe_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","ሄሳን ህንተ ቱናነ ቱና ግዶናይሳታ ግዶን፥ ቃስ ሜተትያነ ሜተቶና መተꬃታ ግዶን ደእያ ዱማተꬃ ሻክድ ኤራና።” ");
INSERT INTO gofe_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","ጎዳይ ሙሰኮ ሀይሳዳ ያግስ፤ ");
INSERT INTO gofe_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","እስራኤለ አሳስ ሀይሳዳ ያጋዳ ኦዳ፤ “እስ ማጫስ ቃንꬃታዳ አደ ናአ የልኮ፥ ባ ኩሸ መቱዋ በእያ ዎደ ቱና ግደይሳዳ ላፑን ጋላስ ጋካናዉ ቱና ግዳና። ");
INSERT INTO gofe_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","ሆስፑንꬃ ጋላስ ናአይ ቃፃረታናዉ ኮሼስ። ");
INSERT INTO gofe_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","ሄሳፈ ጉየ፥ ማጫስያ ባ የሎ ሱꬃይ ፅዝአና ጋካናዉ ሀስታማነ ሄꬑ ጋላስ ጋምኦ፤ ቃስ ባ ጌይያ ጋላሳይ ዉራና ጋካናዉ ጌሻባ ቦቾፎ፤ ጌሻ ዱንካንያካ ገሎፖ። ");
INSERT INTO gofe_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","“ሽን እስ ማጫስ ማጫ ናአ የልኮ፥ ባ ኩሸ መቶ በእዳ ዎደ እያ ቱና ግድዳይሳዳ ናምኡ ሳምንታ ጋካናዉ እያ ቱና ግዳና። ሄሳፈ ጉየ፥ ባ የሎ ሱꬃይ ፅዝአና ጋካናዉ ኡሱፑን ታማነ ኡሱፑን ጋላስ ጋምኦ። ");
INSERT INTO gofe_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“ማጫስያ አደ ናአ ዎይኮ ማጫ ናአ የላዳ ባ ጌይያ ዎድያ ኦንግዳፐ ጉየ፥ ፁሳ ያርሾስ እስ ላይꬃ ዶርሰነ ናጋራ ያርሾስ ቃስ እስ ሆለ ዎይኮ እስ ኩራቾ ጌሻ ዱንካንያ ፐንገን ደእያ ካህንያኮ ኤሆ። ");
INSERT INTO gofe_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","ካህነይ ሄሳ ኤክድ ጎዳ ስንꬃን እ ናጋራ አቶተꬃስ ያርሼስ። ሄሳፈ ጉየ፥ እያ ጌያና። አደ ናአ ዎይኮ ማጫ ናአ የልያ ማጫሳስ ደእያ ዎጋይ ሀይሳ። ");
INSERT INTO gofe_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","“ሽን እያ እስ ላይꬃ ዶርሰ ኤሀናዉ ዳንዳኦና እፅኮ፥ ናምኡ ሆለታ ዎይኮ ናምኡ ኩራቾታ ኤሆ። ኤንታፈ እሶይ ፁሳ ያርሾስ፥ ቃስ እሶይ ናጋራ ያርሾስ ግዶ። ሄሳዳ ኦꬅድ ካህነይ እ ናጋራ አቶተꬃስ ያርሼስ፤ እያካ ጌሽ ግዳና።” ");
INSERT INTO gofe_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","ጎዳይ ሙሰኮነ አሮናኮ ሀይሳዳ ያግስ፤ ");
INSERT INTO gofe_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“እስ አሳ አሳተꬃ ቦላ ክፅ ዎꬍኮ ዎይኮ ሻቶይ ዎይኮ እራለይ ከይኮ እያ ጎጋይ ሀርገን ላመትኮ፥ ሄ ኡራ ካህንያ አሮናኮ ዎይኮ ካህነ ግድዳ እያ አደ ናይታፐ እሱዋኮ ኤሆ። ");
INSERT INTO gofe_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","ካህነይ እያ ጎጋ ቦላ ደእያ ማዱንꬃ በኦ። ሄ ማዱንፅዳ በሳን ደእያ እክሰይ ቦፅኮነ ማዱንꬃይ ኦላትኮ፥ ሄስ ጎጋ ሀርገ። ካህነይ ሄሳ በእድ ኡራይ ቱና ግደይሳ ኤርሶ። ");
INSERT INTO gofe_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","ሽን እያ ጎጋ ቦላ ደእያ ማዱንꬃይ ቦꬅ ግድድ፥ ጎጋፐ ካንꬅድ ኦላትቦናባ ግድኮ ሄ ማዱንꬃ ቦላ ደእያ እክሰይ ቦፆናባ ግድኮ፥ ካህነይ ሄ ኡራ ዱማ ኬꬃን ላፑን ጋላስ ጎርድድ ዎꬆ። ");
INSERT INTO gofe_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","ላፑንꬃ ጋላስ ካህነይ እያ ዛሪድ በኦ፤ እ በእያ ዎደ ማዱንꬃይ ኡራ ጎጋ ቦላ ዳልጎና ካሰይስዳ ደእኮ፥ ካህነይ ሄ ኡራ ናምአንꬆ ዱማ ኬꬃን ላፑን ጋላስ ጎርድድ ዎꬆ። ");
INSERT INTO gofe_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","ቃስካ ላፑንꬃ ጋላስ ካህነይ እያ በኦ፤ እ በእያ ዎደ ማዱንꬃይ ዳልጎና እፅድ ꬋይ ꬋይ ቢኮ፥ ካህነይ እ ቱና ግደይሳ ኤርሶ። ሄስ ጎኦ ግደይሳ ኤርሶ፤ ሄ ኡራይ ባ ማኡዋ ሜጭድ ቱና ግዶናይሳ ኤርሴስ። ");
INSERT INTO gofe_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","ሽን እ ጌያናዉ ባና ካህንያ በስዳፐ ጉየ፥ ሄ ጎኦይ እያ ጎጋ ቦላ ዳልግ ዳልግ ቢኮ እ ዛሪድ ባና በሳናዉ ካህንያኮ ቦ። ");
INSERT INTO gofe_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","ካህነይ እያ በኦ፤ ሄ ጎኦይ ኡራ ጎጋ ቦላ ዳልግ ዳልግ ቢኮ፥ ሄስ ጎጋ ሀርገ ግድያ ግሾ ካህነይ እ ቱና ግደይሳ ኤርሶ። ");
INSERT INTO gofe_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“ኦንካ ጎጋ ሀርገን ኦይከትኮ እያ ካህንያኮ ኤሆ። ");
INSERT INTO gofe_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","ካህነይ እያ በእያ ዎደ እያ ጎጋ ቦላ ቦꬃ ክፅ ደእኮ፥ እክሰይ ቦꬅ ላምኮነ ሄ ክፃ ግዶን አሾይ በንትኮ፥ ");
INSERT INTO gofe_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","ሄስ ጎጋ ቦላ ጋምእዳ ሀርገ ግድያ ግሾ፥ ካህነይ እ ቱና ግደይሳ ኤርሶ። እ ቱና ግደይስ ኤረትዳ ግሾ፥ እያ ዱማ ኬꬃን ጎርድድ ዎꬃናዉ ኮሸና። ");
INSERT INTO gofe_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","ካህነይ ጎጋ ሀርገይ አድያ አሳተꬃ ቦላ ዳልግኮ፥ ሁጰፐ ቶሆ ጋካናዉ ኡባ ማእዳባ ግድኮ በኦ። ");
INSERT INTO gofe_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","ሄ ጎጋ ሀርገይ እያ አሳተꬃ ኡባ ማእኮ፥ እያ አሳተꬃይ ኩመꬅ ላመትድ ቦꬅ ግድዳ ግሾ፥ እ ቱና ግዶናይሳ ካህነይ ኤርሶ። ");
INSERT INTO gofe_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","ሽን ሄ ማዱንꬃ ግዶራ አሾይ በንትኮ እ ቱና። ");
INSERT INTO gofe_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","ካህነይ ሄ አሹዋ በእድ ሄ ኡራይ ቱና ግደይሳ ኤርሶ። ሄ አሾይ ጎጋ ሀርገ ግድያ ግሾ እ ቱና። ");
INSERT INTO gofe_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","ሽን ሄ አሾይ ቃስካ ላመትድ ቦፅኮ፥ ሄ ኡራይ ካህንያኮ ቦ። ");
INSERT INTO gofe_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","ካህነይ እያ በኦ፤ እያ ማዱንꬃይ ቦፅዳባ ግድኮ፥ ሄ ኡራይ ቱና ግዶናይሳ ካህነይ ኤርሶ፤ እ ቱና ግዳና። ");
INSERT INTO gofe_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“እስ አሳ ቦላ መርኮይ ዎꬍድ ፓፅዳባ ግድኮ፥ ");
INSERT INTO gofe_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","እያ በሳን ቦꬃ ክፃይ ዎꬍኮ ዎይኮ ዞእዳ እራለይ ከይኮ ሄ ኡራይ ካህንያኮ ቦ። ");
INSERT INTO gofe_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","ካህነይ እያ በኦ፤ ሄ ማዱንꬃይ ኦላትኮ፥ ማዱንꬃ ቦላ ደእያ እክሰይ ላመትድ ቦፅኮ፥ ሄ ኡራይ ቱና ግደይሳ ካህነይ ኤርሶ። ሄስ መርኮዳ ዶምዳ ጎጋ ሀርገ። ");
INSERT INTO gofe_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","ሽን ካህነይ በእያ ዎደ እክሰይ ቦፆናባ ግድኮ፥ ማዱንꬃይ ጎጋ ካንꬅድ ኦላትቦናባ ግድኮ፥ ቃስ ꬋይ ꬋይ ቢኮ፥ ካህነይ እያ ዱማ ኬꬃን ላፑን ጋላስ ጎርድድ ዎꬆ። ");
INSERT INTO gofe_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","ሄስ እያ ጎጋ ቦላ ዳልግ ዳልግ ቢኮ፥ ሄስ ጎጋ ሀርገ ግድያ ግሾ ሄ ኡራይ ቱና ግደይሳ ካህነይ ኤርሶ። ");
INSERT INTO gofe_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","ሽን ሄ እራለይ ዳልግ ዳልግ ቦና እስ በሳን ደእኮ፥ ሄስ መርኮይ ፓፅዳ ቤታ ግድያ ግሾ፥ ሄ ኡራይ ቱና ግዶናይሳ ኤርሶ። ");
INSERT INTO gofe_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“ታም እስ አስ ሚኮ ሄ ምዳ በሳን ቦꬃ ዎይኮ ዞኦ እራለይ ከይኮ፥ ");
INSERT INTO gofe_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","ካህነይ ሄ በሳ በኦ። ሄ በሳን ደእያ እክሰይ ቦፅኮነ ሄ ማዱንꬃይ ኦላትኮ፥ ሄስ ጎጋ ሀርገ። እ ታማይ ምዳ በሳራ ከይዳ ግሾ ካህነይ እ ቱና ግደይሳ ኤርሶ። ");
INSERT INTO gofe_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","ሽን ካህነይ በእያ ዎደ ሄ ማዱንꬃ ቦላ ደእያ እክሰይ ቦፆናባ ግድኮ፥ ማዱንꬃይ ጎጋ ካንꬅድ ኦላትቦናባ ግድኮነ ቃስ ꬋይ ꬋይ ብዳባ ግድኮ፥ ካህነይ እያ ዱማ ኬꬃን ላፑን ጋላስ ጎርድድ ዎꬆ። ");
INSERT INTO gofe_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","ላፑንꬃ ጋላስ ካህነይ እያ በእያ ዎደ ሄ በሳይ ዳልግ ዳልግ ቢኮ፥ ሄስ ጎጋ ሀርገ ግድያ ግሾ እ ቱና ግደይሳ ካህነይ ኤርሶ። ");
INSERT INTO gofe_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","ሽን ሄ ማዱንꬃይ ጎጋ ቦላ ዳልጎና አግድ እስ በሳን ኡትኮነ ꬋይ ꬋይ ቢኮ፥ ሄስ ታማይ ምዳ በሳን አትዳ ቤታ ግድያ ግሾ፥ እ ቱና ግዶናይሳ ካህነይ ኤርሶ። ");
INSERT INTO gofe_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“እስ አደይ ዎይኮ ማጫሳ ሁጰን ዎይኮ ጋጮ ቦላ ማዱንꬅ ከይኮ፥ ");
INSERT INTO gofe_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","ካህነይ ሄ ማዱንꬃ በእያ ዎደ ማዱንꬃይ ጎጋ ካንꬅድ ኦላትኮ እያ ቦላ ደእያ እክሰይ ሌእድ ጋላልኦ ዳንኮ፥ ሄስ ሁጰን ዎይኮ ጋጮ ቦላ ከይያ ቃችያ ጎጋ ሀርገ ግድያ ግሾ፥ ሄ ኡራይ ቱና ግደይሳ ካህነይ ኤርሶ። ");
INSERT INTO gofe_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","ቃስ ካህነይ ሄ ሀርግያ በእያ ዎደ ጎጋ ካንꬅድ ኦላትቦናባ ግድኮ፥ ካሬꬃ እክሰይ እያ ቦላ ꬋይኮ፥ ሄ ቃችያ ሀርገይ ደእያ ኡራ ካህነይ ዱማ ኬꬃን ላፑን ጋላስ ጎርድድ ዎꬆ። ");
INSERT INTO gofe_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","ላፑንꬃ ጋላስ ካህነይ ሄ ሀርግያ በእያ ዎደ ቃችያ ሀርገይ ዳልጎናባ ግድኮ፥ እያ ቦላ ጋላልኦ ዳንያ እክሰይ ባይናባ ግድኮነ ጎጋ ካንꬅድ ኦላትቦናባ ግድኮ፥ ");
INSERT INTO gofe_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","ሄ ኡራ ቃችያ በሳን ደእያ እክስያ ግዶናሽን፥ ማዱንꬃ ዩሾን ደእያ እክስያ ሜዶ። ካህነይ ሄ ኡራ ዱማ ኬꬃን ሀራ ላፑን ጋላስ ጎርድድ ዎꬆ። ");
INSERT INTO gofe_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","ላፑንꬃ ጋላስ ካህነይ ሄ ቃችያ በሳ በእያ ዎደ ኡራ ጋልባ ቦላ ዳልጎና እፅኮነ ጎጋ ካንꬅድ ኦላቶና እፅኮ፥ ሄ ኡራይ ቱና ግዶናይሳ ካህነይ ኤርሶ። ኡራይ ባ ማኡዋ ሜጭድ ጌሽ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","ሽን እ ጌይዳፐ ጉየ፥ ቃችያ ሀርገይ ሄ ኡራ ጋልባ ቦላ ዳልግ ዳልግ ቢኮ፥ ");
INSERT INTO gofe_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","ካህነይ እያ በእያ ዎደ ሄ ቃችያ ሀርገይ ዳልግዳባ ግድኮ፥ ሄ ኡራይ ቱንዳ ግሾ ካህነይ ጋላልኦ ዳንያ እክስያ ኮዮፖ። ");
INSERT INTO gofe_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","ሽን ካህነይ በእያ ዎደ ሄ ቃችያ በሳይ ዳልጎናባ ግድኮነ ካሬꬃ እክሰይ እያ ቦላ ዶልዳባ ግድኮ፥ ሄ ቃችያ በሳይ ፓፅስ። ሄ ኡራይ ቱና ግዶና ግሾ፥ እ ጌሽ ግደይሳ ካህነይ ኤርሶ። ");
INSERT INTO gofe_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“እስ አደ ዎይኮ ማጫሳ ጎጋ ቦላ ቦꬃ እራለይ ከይኮ፥ ");
INSERT INTO gofe_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","ካህነይ በእያ ዎደ ኤንታ ጎጋ ቦላ ደእያ እራለይ ቡላ ግድኮ፥ ሄስ ጎጋ ቦላ ጮ ከይዳባ ግድያ ግሾ ሄ ኡራይ ቱና ግደና። ");
INSERT INTO gofe_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“እስ አሳስ ሁጰ ብናናይ ቆቆፈትኮ፥ ቦአ ግዴስፐ አትሽን፥ እ ቱና ግደና። ");
INSERT INTO gofe_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","እስ አስ ስንꬃራ ቦአትኮ፥ እያ ቲሽ ምስፐ አትሽን፥ እ ቱና ግደና። ");
INSERT INTO gofe_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","ሽን እያ ቦእ ዎይኮ ቲሽ ምዳይሳ ቦላ ዞኦ ዎይኮ ቦꬃ ማዱንꬅ ከይኮ፥ ሄስ እያ ቦአን ዎይኮ እያ ቲሻ ቦላ ከይዳ ጎጋ ሀርገ። ");
INSERT INTO gofe_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","እያ ካህነይ በእያ ዎደ እያ ቦእ ዎይኮ ቲሽ ምዳይሳ ቦላ ደእያ ማዱንꬃይ ጋልባ ቦላ ከይያ ጎጋ ሀርገ መላ ዞኦ ግድኮ፥ ");
INSERT INTO gofe_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","ሄ ኡራይ ቱማ ጎጋ ሀርገን ኦይከትዳ ሀርጋንቾ። እ ቱና ግድያ ግሾነ እያ ሀርገይ እያ ሁጰን ደእያ ግሾ እ ቱና ግደይሳ ካህነይ ኤርሶ። ");
INSERT INTO gofe_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“ጎጋ ሀርገይ ኦይክዳ አስ ፔትዳ ማኦ ማኦ፤ ባ ሁጵያ ፕፆፖ፤ ባ ዶና ካሞ፤ ባ ቃላ ꬎቁ ኦꬅድ፥ ‘ታኒ ቱና፥ ታኒ ቱና!’ ያጎ። ");
INSERT INTO gofe_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","ሄ ሀርገይ እያ ቦላ ደእዳ ዎደ ኡባን እ ቱና። እ ቱና ግድያ ግሾ፥ አሳፐ ሻከትድ፥ ጉታፐ ካረን ባርካ ደኦ። ");
INSERT INTO gofe_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“አይ ማኦ ቦላ ቡቅዳ በሲ በንትኮ፥ ሄ ማኦይ ሱፈ ግድን ዎይኮ ሊኖ ግድን፥ ");
INSERT INTO gofe_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","ቃጭናፐ ዎይኮ ሻሎፐ ዳደትዳ ሊኖ ዎይኮ ሱፈ ግድን፥ ጋልባ ዎይኮ ጋልባፈ ኦሰትዳ ማኦ ግድን፥ ");
INSERT INTO gofe_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","ሄ ማኡዋ ቦላ በንትዳ ቡቃይ ጭሊሎ ዎይኮ ዞኦ ማላ በስኮ፥ እ ቃጭናፐ ዎይኮ ሻሎፐ ዳደትዳባ ግድን፥ ጋልባ ዎይኮ ጋልባፈ ኦሰትዳባ ግድን፥ ሄስ አሳፐ አሰ ኦይክያ ሀርገ ግድያ ግሾ፥ ሄሳ ካህነይ በሳናዉ ኮሼስ። ");
INSERT INTO gofe_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","ካህነይ ሄ ቡቃ በእድ፥ ሄ ቡቅዳ ማኡዋ ዱማ ኬꬃን ላፑን ጋላስ ጎርድድ ዎꬆ። ");
INSERT INTO gofe_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","ላፑንꬃ ጋላስ ካህነይ ሄ ማኡዋ በእያ ዎደ ሄ ማኡዋ ቦላ ደእያ ቡቃይ ዳልግ ዳልግ ቢኮ፥ እ ቃጭና ዎይኮ ሻሎ ግድን፥ ጋልባ ዎይኮ ጋልባፈ ኦሰትዳ ማኦ ግድን፥ ሄስ እሱዋፈ እሱዋ ኦይክያ ቡቃ ሀርገ ግድያ ግሾ ሄ ማኦይ ቱና። ");
INSERT INTO gofe_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","ሄ ማኦይ ቃጭና ዎይኮ ሻሎ ግድን፥ ሊኖ ዎይኮ ሱፈ ግድን፥ ጋልባፈ ኦሰትዳባ አይባ ግድን፥ ካህነይ እያ ፁጎ። ሄስ እሱዋፈ እሱዋ ኦይክያ ቡቃ ሀርገ ግድያ ግሾ፥ እ ፁገታናዉ በሴስ። ");
INSERT INTO gofe_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“ሽን ካህነይ በእያ ዎደ ሄ ቡቃ ማኡዋ ቦላ ዳልግቦናባ ግድኮ፥ እ ቃጭና ዎይኮ ሻሎ ዎይኮ ጋልባፈ ኦሰትዳባ አይባ ግድን፥ ");
INSERT INTO gofe_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","ሄ ቡቃይ ደእያ ማኡዋ ሜጫና መላ ካህነይ ኪቶ። ሄሳፈ ጉየ፥ ሄ ማኡዋ ዱማ ኬꬃን ሀራ ላፑን ጋላስ ጎርድድ ዎꬆ። ");
INSERT INTO gofe_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","ሄ ማኦይ ሜጨትዳፐ ጉየ ቃስካ ካህነይ በእያ ዎደ ሄ ቡቃይ ባ ማላ ላሞናባ ግድኮነ ዳልግ ዳልግ ቦና እፅኮካ እ ቱና። ሄ ቡቃ በሳይ ማኡዋስ ጉየ ባጋራ ዎይኮ ስንꬃ ባጋራ ደእኮካ ሄ ማኦይ ታማን ፁገታናዉ ኮሼስ። ");
INSERT INTO gofe_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","ሽን ሄ ማኡዋ ሜጭ ስምን ካህነይ በእያ ዎደ ቡቃይ ꬋይ ꬋይ ቢኮ፥ እ ጋልባ ግድን፥ ቃጭና ዎይኮ ሻሎ ግድን፥ ሄ ቡቃይ ደእያ በሳ ካህነይ ዳክድ ከሶ። ");
INSERT INTO gofe_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","ሄሳፈ ጉየ፥ ማኡዋ ቦላ ስሚድ ከይኮ፥ ሄ ማኦይ ቃጭና ዎይኮ ሻሎ ግድን፥ ጋልባፈ ኦሰትዳባ ግድን፥ ሄስ ዳልግ ዳልግ ቢኮ ሄ ቡቃይ ደእያ ማኦይ ታማን ፁገታናዉ በሴስ። ");
INSERT INTO gofe_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","ሽን ሜጨትዳ ማኦይ ቃጭና ዎይኮ ሻሎ ግድን፥ ዎይኮ ጋልባፈ ኦሰትዳባ ማኦ ግድን፥ ቡቃ ማላይ ꬋይኮ፥ ሄ ማኦይ ናምአንꬆ ሜጨቶ፤ ሄሳፈ ጉየ፥ እ ጌዬስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","እስ ማኦይ ሱፈ ዎይኮ ሊኖ ግድን፥ ቃጭና ዎይኮ ሻሎ ግድን፥ ዎይኮ ጋልባፈ ኦሰትዳባ ግድን፥ ሄ ማኡዋ ጌሽ ዎይኮ ቱና ያግሳናዉ ዳንዳእያ ዎጋይ ሀይሳ። ");
INSERT INTO gofe_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","ጎዳይ ሙሰኮ ሀይሳዳ ያግስ፤ ");
INSERT INTO gofe_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","ጎጋ ሀርገይ ኦይክዳ ኡራይ ጌይያ ጋላስ ኦꬃናዉ ኮሽያ ዎጋይ ሀይሳ። ሄ ኡራ ካህንያኮ ኤሀናዉ ኮሼስ። ");
INSERT INTO gofe_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","ካህነይ ጉታፐ ጋፃ ከይድ እያ ሀርግያ በኦ። እ በእያ ዎደ ጎጋ ሀርገይ ኡራ አሳተꬃፈ ꬋይዳባ ግድኮ፥ ");
INSERT INTO gofe_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","ካህነይ ናምኡ ቱና ግዶና ካፎታ፥ ዝጋ ምꬃ ቃንፆ፥ ዞኦ ቃጭናነ ህሶጰ ቦንጮ ሄ ሀርግያፈ ጌይያ ኡራ ግሾ ኤሀና መላ ኪቶ። ");
INSERT INTO gofe_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","ሄሳፈ ጉየ፥ ካህነይ ናምኡ ካፎታፐ እሱዋ ፑልቶፈ ዱቅድ ከረን ቆልዳ ሃꬃ ቦላ ሹካና መላ ኪቶ። ");
INSERT INTO gofe_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","ሀንኮ ካፉዋ ዞኦ ቃጭናራነ ህሶጰ ቦንጮራ ኤክድ፥ ከረን ደእያ ፑልቶ ሃꬃ ቦላ ሹክዳ ካፉዋ ሱꬃን ናቆ። ");
INSERT INTO gofe_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","ሄ ሱꬃ፥ ሄ ጎጋ ሀርግያፈ ጌይያ ኡራ ቦላ ላፑን ቶሆ ዉርፆ፤ ሄ ኡራይ ቱና ግዶናይሳ ኤርሶ፤ ፓፃ ደእያ ካፉዋ ደምባ የዶ። ");
INSERT INTO gofe_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","ሄ ሀርግያፈ ጌይያ ኡራይ ባ ማኡዋ ሜጮ፤ ባ አሳተꬃ ቦላ ደእያ እክሰ ኡባ ሜደቶ፤ ባ አሳተꬃ ሜጨቶ። ሄሳፈ ጉየ፥ እ ጌይድ ጉታ ገሎ፥ ሽን ባ ዱንካንያ ግዶ ገሎና ላፑን ጋላስ ካረን ጋምኦ። ");
INSERT INTO gofe_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","ላፑንꬃ ጋላስ ባ ሁጵያ፥ ቡቻ፥ ዴሙዋነ ባ አሳተꬃ ቦላ ደእያ ሀራ እክሰ ኡባ ሜደቶ፤ ቃስ ባ ማኡዋ ሜጮ፤ ባ አሳተꬃካ ሜጨቶ፤ ሄሳፈ ጉየ፥ እ ጌሽ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","ሆስፑንꬃ ጋላሳን ቦረይ ባይና ናምኡ ኡርገ ዶርሳታነ እስ ላይꬅ ግድዳ እስ ማጫ ዶርሰ ኤሆ። ቃስ ካꬃ ያርሾስ ዛይተራ ሙኑቀትዳ ሄꬑ ክሎ ግራመ ሎኦ ꬊለነ እስ ልትሮ ዛይተፐ ስኮ ኤሆ። ");
INSERT INTO gofe_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","እያ ጌሽያ ካህነይ ኡራነ እ ኤህዳ ያርሾታራ እስፈ ጌሻ ዱንካንያ ፐንገን ጎዳ ስንꬃን ሺሾ። ");
INSERT INTO gofe_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","ካህነይ ናምኡ ዶርሳ ኡርገታፐ እሱዋ ኤክድ፥ እስ ልትሮስ ስኮ ዛይተራ እስፈ ናቆ ያርሾ ኦꬅድ ሺሾ፤ ሄ ሺቅዳ ያርሹዋ ዩሾ ያርሾ ኦꬅድ ጎዳ ስንꬃን ሺሾ። ");
INSERT INTO gofe_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","ያትድ፥ እ ሄ ዶርሳ ኡርግያ ናጋራ ያርሾነ ፁሳ ያርሾ ሹክያ ጌሻ በሳን ሹኮ። ናጋራ ያርሹዋ መላ ናቆ ያርሾይካ ካህንያስ እመቴስ፤ እካ ኡባፈ አꬍዳ ጌሽ። ");
INSERT INTO gofe_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","ካህነይ ናቆ ያርሹዋ ሱꬃፈ ጉꬅ ኤክድ፥ ሄ ጌይያ ኡራስ ኡሻቻ ባጋ ሀይꬃ፥ ኡሻቻ ኩሽያ ዎጋ ብራꬍያነ ኡሻቻ ቶሁዋ ዎጋ ብራꬍያ ትዮ። ");
INSERT INTO gofe_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","ሄሳፈ ጉየ፥ ካህነይ ዛይትያፐ ጉꬃራ ኤክድ፥ ባ ሀድርሳ ኩሽያ ቃቃን ትጎ። ");
INSERT INTO gofe_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","ሄ ሀድርሳ ኩሽያ ቃቃን ደእያ ዛይትያ ባ ኡሻቻ ኩሸ ብራꬍያ የድ የድ ኤክድ፥ ጎዳ ስንꬃን ላፑን ቶሆ ዉርፆ። ");
INSERT INTO gofe_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","ያትድ፥ ባ ኩሽያ ቃቃን ደእያ ዛይትያፐ ኤክድ፥ ጌይያ ኡራስ ኡሻቻ ሀይꬃ፥ ኡሻቻ ኩሽያ ዎጋ ብራꬍያነ ኡሻቻ ቶሁዋ ዎጋ ብራꬍያ ካሰ ናቆ ያርሹዋ ሱꬃ ትይዳ በሳን ትዮ። ");
INSERT INTO gofe_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","ቃስ ባ ኩሽያ ቃቃን አትዳ ዛይትያ ካህነይ ጌይያ ኡራ ሁጰን ጉሶ፤ ያትድ ጎዳ ስንꬃን ሄ ኡራ ናጋራ አቶ ያግሶ። ");
INSERT INTO gofe_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","ሄሳፈ ጉየ ካህነይ ጌይያ ኡራ ናጋራ አቶተꬃስ ሺቅዳ ያርሹዋ ያርሼስ፤ ካልድ ቃስ ፁሳ ያርሾስ ሺቅዳ መህያ ሹኬስ። ");
INSERT INTO gofe_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","ካህነይ ፁሳ ያርሹዋ ካꬃ ያርሹዋራ እስፈ ያርሾ በሳን ዎꬅድ ፁጌስ፤ ያትድ ኡራ ናጋራ አቶ ያግሴስ፤ ሄ ኡራይ ጌዬስ። ");
INSERT INTO gofe_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","ሽን ኡራይ ሄሳ ኡባ ኤሀናዉ ዳንዳኦና ማንቆ ግድኮ፥ ጎዳ ስንꬃን እያ ናጋራ አቶተꬃስ ዩሻናዉ ናቆ ያርሾስ እስ ዶርሳ ኡርገ ኤሆ። ካꬃ ያርሾስ ዛይተራ ሙኑቀትዳ እስ ክሎ ግራመ ሎኦ ꬊለነ እስ ልትሮ ዛይተፐ ስኩዋ ኤሆ። ");
INSERT INTO gofe_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","ባዉ ዳንዳኤትዳ መላ ናምኡ ሆለ ዎይኮ ናምኡ ኩራቾ እሱዋ ናጋራ ያርሾስ፥ እሱዋ ፁሳ ያርሾስ ኤሆ። ");
INSERT INTO gofe_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","ሆስፑንꬃ ጋላስ ባ ቱናተꬃፈ ጌይያ ኡራይ ጌሻ ዱንካንያ ፐንገን ጎዳ ስን ኤህድ ካህንያስ እሞ። ");
INSERT INTO gofe_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","ካህነይ ናቆ ያርሾስ ይዳ ዶርሳ ኡርግያነ ዛይትያ ኤክድ፥ ዩሾ ያርሾ ኦꬅድ ጎዳ ስንꬃን ዩሾ። ");
INSERT INTO gofe_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","ናቆ ያርሾስ ይዳ ዶርሳ ኡርግያ ሹኮ፤ ሄ ኡርግያ ሱꬃፈ ጉꬃራ ኤክድ፥ ሀ ጌይያ ኡራ ኡሻቻ ሀይꬃ፥ ኡሻቻ ኩሽያ ዎጋ ብራꬍያነ ኡሻቻ ቶሁዋ ዎጋ ብራꬍያ ትዮ። ");
INSERT INTO gofe_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","ካህነይ ዛይትያፐ ጉꬃራ ባ ሀድርሳ ኩሽያ ቃቃን ትጎ። ");
INSERT INTO gofe_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","ሀድርሳ ኩሽያ ቃቃን ደእያ ዛይትያፐ ኡሻቻ ኩሽያ ብራꬍያ የድ ኤክድ፥ ጎዳ ስንꬃን ላፑን ቶሆ ዉርፆ። ");
INSERT INTO gofe_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","ካህነይ ባ ኩሽያ ቃቃን ደእያ ዛይትያፐ ጉꬃራ ኤክድ፥ ጌይያ ኡራስ ኡሻቻ ሀይꬃ፥ ኡሻቻ ኩሽያ ዎጋ ብራꬍያነ ኡሻቻ ቶሁዋ ዎጋ ብራꬍያ ካሰ ናቆ ያርሾ ሱꬃ ትይዳ በሳን ትዮ። ");
INSERT INTO gofe_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","ጎዳ ስንꬃን ኡራ ናጋራ አቶተꬃስ ካህነይ ባ ኩሸን አትዳ ዛይትያ ጌይያ ኡራ ሁጰን ትጎ። ");
INSERT INTO gofe_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","ሄሳፈ ጉየ፥ ጌይያ ኡራይ ባዉ ዳንዳኤትዳይሳ መላ ሆለ ዎይኮ ኩራቾ ኤሆ። ");
INSERT INTO gofe_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","እሱዋ ናጋራ ያርሾስ ናምአንꬁዋ ፁሳ ያርሾስ ካꬃ ያርሹዋራ እስፈ ሺሾ። ካህነይ ጌይያ ኡራ ናጋራ ጎዳ ስንꬃን እያ ናጋራ አቶ ያግሶ። ");
INSERT INTO gofe_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","ባ አሳተꬃ ቦላ ደእያ ጎጋ ሀርግያፈ ጌያናዉ ማንቆተꬅ ድግዳ ኡራስ ደእያ ዎጋይ ሀይሳ። ");
INSERT INTO gofe_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","ጎዳይ ሙሰኮነ አሮናኮ ሀይሳዳ ያግስ፤ ");
INSERT INTO gofe_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“ታኒ ህንተዉ እምያ ካናነ ቢታ ህንተ ገልያ ዎደ ሄ ቢታን ደእያ ህንተ ኬꬃፈ እሱዋን ታኒ ቡቃ የድያ ዎደ፥ ");
INSERT INTO gofe_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","ሄ ኡራይ ካህንያኮ ብድ፥ ‘ታ ኬꬃ ቦላ ቡቃ ዳንያባይ ደኤስ’ ያግድ ኦዶ። ");
INSERT INTO gofe_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","ካህነይ ሶ ገልድ ቡቃ ቆሙዋ በአናፐ ካሰትድ፥ ሶን ደእያባይ ኡባይ ቱና ጌተቶና መላ ሶን ደእያባ ኡባ ካረ ከሳና መላ ኪቶ፤ ሄሳፈ ጉየ፥ ካህነይ በአናዉ ሶ ገሎ። ");
INSERT INTO gofe_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","እ ገልድ በእያ ዎደ ቡቃይ ጎዳ ቦላ ጭሊሎ ዎይኮ ዞኦ ማላ በስኮነ ቃስ ጎዳ ምድ ኦላይድ ግዶ ገልኮ፥ ");
INSERT INTO gofe_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","ካህነይ ካረ ከይድ፥ ኬꬃ ላፑን ጋላስ ጋካናዉ ጎርዶ። ");
INSERT INTO gofe_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","ላፑንꬃ ጋላሳን ካህነይ ሄ ኬꬃ ዛሪድ ፄልያ ዎደ ሄ ቡቃይ ኬꬃ ጎዳ ቦላ ዳልግኮ፥ ");
INSERT INTO gofe_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","ቡቃይ ደእያ ሹቻ ኡባ ጎዳፐ ሾድድ፥ ካታማፐ ጋፃ ከስድ ቱና በሳን የጋና መላ ኪቶ። ");
INSERT INTO gofe_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","ካልድ ጎዳ ሜሽዳ ኡርቃ ሶ ባጋራ ቦክድ፥ ዩሽ አꬅድ ቆቆፋና መላ ኦꬆ፤ ያትድ ሄ ኡርቃ ካታማፐ ጋፃን ደእያ ቱና በሳን የጎ። ");
INSERT INTO gofe_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","ሄሳፈ ጉየ፥ ሄ ሾደትዳ ሹቻታ በሳን ሀራ ሹቻታ ዎꬆ፤ ሀራ ኡርቃን ኬꬃ ሜሾ። ");
INSERT INTO gofe_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“ሹቻይ ሾደትን፥ ኡርቃይ ቆቆፈትን፥ ሀራ ኡርቃ ሜሽ ስምን፥ ቡቃይ ኬꬃ ግዶን ዛር በንትኮ፥ ");
INSERT INTO gofe_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","ካህነይ ሄሳ በኦ። እ በእያ ዎደ ቡቃይ ሄ ኬꬃ ግዶን ዳልግኮ፥ ሄስ አሳፐ አሰ ኦይክያ ቡቃ ሀርገ ግድያ ግሾ ሄ ካꬃይ ቱና። ");
INSERT INTO gofe_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","ሄሳ ግሾ ሄ ኬꬃ፥ እያ ሹቻ፥ እያ ምꬃነ እ ሜሸትዳ ኡርቃ ኡባ ላልድ ካታማፐ ጋፃ ኤፍድ፥ ቱና በሳን የጎ። ");
INSERT INTO gofe_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","ሄ ኬꬃይ ጎርዳን ጋምእያ ዎደ እያ ግዶ ገልያ ኦንካ ኦማርስ ጋካናዉ ቱና። ");
INSERT INTO gofe_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","ሄ ኬꬃን አቅያ ዎይኮ ካꬅ ምያ ኡራይ ባ ማኡዋ ሜጮ። ");
INSERT INTO gofe_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“ሽን ካህነይ ይድ ፄልያ ዎደ ኬꬃይ ሜሸትድ ስምን፥ ዛሪድ ዳልጎና እፅኮ፥ ቡቃይ ꬋይዳ ግሾ፥ ሄ ኬꬃይ ቱና ግዶናይሳ ካህነይ ኤርሶ። ");
INSERT INTO gofe_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","ኬꬃ ጌሻናዉ ናምኡ ካፎታ፥ ዝጋ ምꬃ ቃንፆ፥ ዞኦ ቃጭናነ ህሶጰ ቦንጮ ኤሆ። ");
INSERT INTO gofe_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","ካፎታፐ እሱዋ ፑልቶፈ ዱቅድ ከረን ቆልዳ ሃꬃን ሹኮ። ");
INSERT INTO gofe_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","ሄሳፈ ጉየ፥ ዝጋ፥ ህሶጰ ቦንጩዋ፥ ዞኦ ቃጭናነ ፓፃ ደእያ ካፉዋ ኤክድ፥ ከረን ደእያ ሹከትዳ ካፉዋ ሱꬃንነ ፑልቶ ሃꬃን የድ ኤክድ ላፑን ቶሆ ሄ ኬꬃ ዉርፆ። ");
INSERT INTO gofe_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","ያትድ፥ ካህነይ ሄ ኬꬃ ካፉዋ ሱꬃን፥ ፑልቶ ሃꬃን፥ ፓፃ ደእያ ካፉዋን፥ ዝጋ ምꬃን፥ ህሶጰ ቦንጩዋንነ ዞኦ ቃጭናን ጌሾ። ");
INSERT INTO gofe_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","ፓፃ ደእያ ካፉዋ ካታማፐ ጋፃ የዶ። ሄሳዳ ኦꬅድ፥ ኬꬃ ጌሽያ ዎጋ ፖሌስ፤ ኬꬃይ ጌሽ ግዴስ። ");
INSERT INTO gofe_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","“ዱማ ዱማ ጎጋ ሀርጌስነ ጎኦ ሀርጌስ እመትዳ ዎጋይ ሀይሳ። ");
INSERT INTO gofe_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","ማኦ ቦላ ዎይኮ ኬꬃ ቦላ ከይያ ቡቃ ሀርገ ግድን፥ ");
INSERT INTO gofe_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","ክፃ ግድን፥ መርኮ ግድን፥ እራለ ግድን፥ ");
INSERT INTO gofe_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","እስባይ ቱና ግደይሳነ ቱና ግዶናይሳ ኤርስያ ዎጋይ ሀይሳ።” ");
INSERT INTO gofe_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","ጎዳይ ሙሰኮነ አሮናኮ ሀይሳዳ ያግስ፤ ");
INSERT INTO gofe_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","እስራኤለ አሳስ ሀይሳዳ ያግድ ኦድተ፤ “እስ አሳ አሳተꬃፈ ጎግያባይ ደእኮ ሄስ ቱና። ");
INSERT INTO gofe_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","ጎግያባይ ደእያ ኡራ ቱና ኦꬅያ ዎጋይ ሀይሳ፤ ሄ ጎግያባይ አግን፥ አጎና እፅን፥ ሄ ኡራ ቱና ኦꬄስ። ");
INSERT INTO gofe_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","“እያ አሳተꬃፈ ጎግያባይ ደእያ ኡራይ ዝንእያ ሂፃይነ ኡትያ ኦይደ ኡባይ ቱና። ");
INSERT INTO gofe_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","እያ ሂፃ ቦችያ ኦንካ ባ ማኡዋ ሜጮ፤ ባ አሳተꬃካ ሜጨቶ፤ ያትድ ኦማርስ ጋካናዉ ቱና ግዴስ። ");
INSERT INTO gofe_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","ጎግያባይ ደእያ ኡራይ ኡትዳባ ቦላ ኡትያ ኦንካ ባ ማኡዋ ሜጮ፤ ባ አሳተꬃካ ሜጨቶ፤ ያትድ ኦማርስ ጋካናዉ ቱና ግዴስ። ");
INSERT INTO gofe_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","“ጎግያባይ ደእያ ኡራ አሳተꬃ ቦችያ ኦንካ ባ ማኡዋ ሜጮ፤ ባ አሳተꬃ ሜጨቶ፤ ያትድ ኦማርስ ጋካናዉ እ ቱና ግዴስ። ");
INSERT INTO gofe_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","“ጎግያባይ ደእያ አስ ቱና ግዶና አሳ ቦላ ጩትኮ፥ ሄ ኡራይ ባ ማኡዋ ሜጮ፤ ባ አሳተꬃካ ሜጨቶ፤ ያትድ ኦማርስ ጋካናዉ እ ቱና ግዴስ። ");
INSERT INTO gofe_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","“ጎግያባይ ደእያ ኡራይ ኡትያ ቶጋ ኮር ቱና። ");
INSERT INTO gofe_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","እያፐ ጋርሳራ ደእያባ ቦችያ ኦንካ ኦማርስ ጋካናዉ ቱና ግዴስ፤ ቃስ ሄሳ ቶክያ ኦንካ ባ ማኡዋ ሜጮ፤ ባ አሳተꬃ ሜጨቶ፤ ያትድ ኦማርስ ጋካናዉ እ ቱና ግዴስ። ");
INSERT INTO gofe_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","“ጎግያባይ ደእያ አስ ባ ኩሽያ ሜጨቶና ቦችያ አስ ኦንካ ባ ማኡዋ ሜጮ፤ ባ አሳተꬃ ሜጨቶ፤ ያትድ ኦማርስ ጋካናዉ ቱና ግዴስ። ");
INSERT INTO gofe_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","“ጎግያባይ ደእያ ኡራይ ቦችያ ኦቶ ኡባ መንꬅተ፤ ምꬃፈ ኦሰትዳ ሚሸ ኡባይ ሃꬃን ሜጨቶ። ");
INSERT INTO gofe_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“ጎግያባይ ደእያ አስ ሄ ጎግያባፐ ጌይዳ ዎደፐ ላፑን ጋላስ ጋምኦ። ባ ማኡዋ ሜጮ፤ ባ አሳተꬃ ፑልቶ ሃꬃን ሜጨቶ፤ ያትድ እ ጌሽ ግዴስ። ");
INSERT INTO gofe_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","ሆስፑንꬃ ጋላሳን ናምኡ ሆለታ ዎይኮ ናምኡ ኩራቾታ ኤክድ፥ ጌሻ ዱንካንያ ፐንገ፥ ጎዳ ስን ኤህድ ካህንያስ እሞ። ");
INSERT INTO gofe_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","ካህነይ ሆለታፐ እሱዋ ናጋራ ያርሾስ፥ እሱዋ ቃስ ፁሳ ያርሾስ ያርሼስ፤ ያትድ ካህነይ ኡራ አሳተꬃፈ ጎግያባ ግሾ ጎዳ ስንꬃን እያ ናጋራ አቶ ያግሴስ። ");
INSERT INTO gofe_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“እስ አደፈ እያ አቱንꬃይ ጉክኮ፥ ባ ኩመꬃ አሳተꬃካ ሜጨቶ፤ ያትድ ኦማርስ ጋካናዉ እ ቱና ግዴስ። ");
INSERT INTO gofe_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","አቱንꬃይ ቦችዳ ማኦ ኡባይ ዎይኮ ጋልባ ኡባይ ሃꬃን ሜጨቶ፤ ያትድ ኦማርስ ጋካናዉ ቱና ግዴስ። ");
INSERT INTO gofe_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","እስ አደይ ማጫራ አቅን፥ እያ አቱንꬃይ ጉክኮ፥ ናምአይካ ሃꬃን ሜጨቶ፤ ያትድ ኦማርስ ጋካናዉ ኤንቲ ቱና ግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“እስ ማጫስ ባ ኩሸ መቶ በእኮ፥ ላፑን ጋላስ ጋካናዉ እያ ቱና፤ እዮ ቦችያ ኦንካ ኦማርስ ጋካናዉ ቱና። ");
INSERT INTO gofe_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","“ባ ኩሸ መቶ ዎደ እያ ዝንእያ ሂፃይነ እያ ኡትያ ኦይደይ ኡባይ ቱና። ");
INSERT INTO gofe_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","እያ ዝንእያ ሂፃ ቦችያ ኡባይ ባ ማኡዋ ሜጮ፤ ባ አሳተꬃካ ሜጨቶ፤ ያትድ ኦማርስ ጋካናዉ ቱና ግዶ። ");
INSERT INTO gofe_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","እያ ኡትያባ ቦችያ ኡባይ ባ ማኡዋ ሜጮ፤ ባ አሳተꬃ ሜጨቶ፤ ያትድ ኦማርስ ጋካናዉ ቱና ግዶ። ");
INSERT INTO gofe_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","እያ ዝንእያ ሂፃ ግድን ዎይኮ እያ ኡትያባ ቦችያ ኦንካ ኦማርስ ጋካናዉ ቱና። ");
INSERT INTO gofe_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","“እስ ማጫስ ኩሸ መቶራ ደእያ ዎደ አደይ ኢራ አቅኮ፥ ሄ ኩሸ መቱዋ እ ቦችኮ፥ ላፑን ጋላስ ጋካናዉ እ ቱና ግዴስ፤ እ ዝንእያ ሂፃ ኡባይ ቱና ግዴስ። ");
INSERT INTO gofe_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“እስ ማጫስ፥ ባ ኩሸ መቶ ዎደይ አꬍን፥ ሱꬅ አጎና ጎግኮ ዎይኮ ኩሸ መቶ ዎደይ ባ ቃማፈ አꬍድ ጎግኮ፥ ኩሸ መቶ ዎደ እያ ቱና ግድዳይሳዳ ሱꬃይ ኤቃና ጋካናዉ እያ ቱና ግዳዉሱ። ");
INSERT INTO gofe_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","ሱꬅ ኢፐ ጎግያ ዎደ እያ ዝንእያ ሂፃ ኡባይ፥ ባ ኩሸ መቶ በእያ ዎደ እያ ዝንእዳ ሂፃ መላነ እያ ኡትያ ኦይድያ መላ ቱና ግዴስ። ");
INSERT INTO gofe_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","ሄ ቱንዳባታ ቦችያ ኦንካ ቱና ግድያ ግሾ እ ባ ማኡዋ ሜጮ፤ ባ አሳተꬃ ሜጨቶ፤ ያትድ ኦማርስ ጋካናዉ ቱና ግዴስ። ");
INSERT INTO gofe_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","“ኢፐ ጎግያ ሱꬃይ ኤቅኮ፥ እያ ሄ ዎደፐ ዶማዳ ላፑን ጋላስ ጋምኦ፤ ሄሳፈ ጉየ፥ እያ ጌሽ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","ሆስፑንꬃ ጋላስ እያ ናምኡ ሆለታ ዎይኮ ናምኡ ኩራቾታ ኤሀዳ ጌሻ ዱንካንያ ፐንገን ካህንያስ እሞ። ");
INSERT INTO gofe_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","ካህነይ ሆለታፐ እሱዋ ናጋራ ያርሾስ፥ እሱዋ ፁሳ ያርሾስ ያርሾ። ያትድ፥ ካህነይ ኢፐ ጎግያ ቱናተꬃ ግሾ ጎዳ ስንꬃን እ ናጋራ አቶ ያግሴስ። ");
INSERT INTO gofe_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“እስራኤለ አሳይ ባንታ ግዶን ደእያ ጌሻ ዱንካንያ ቱንስድ፥ ሀይቆና መላ ኔኒ ሀይሳዳ ኦꬃዳ ኤንቲ ባንታና ቱንስያባፐ ዱማይድ ዳና መላ ናጋ።” ");
INSERT INTO gofe_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","እያ አሳተꬃፈ ጎግያባይ ደእያ አሳስ፥ እያ አቱꬃይ ጉክን ቱንያ አደስ፥ ");
INSERT INTO gofe_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","ባ ኩሸ መቶ ጋሶን ቱንያ ማጫሳስ፥ አደ ግድን ማጫ ግድን ጎግያባይ ደእያ አሳስነ ቱንዳ ማጫራ አቅያ አደስ እመትዳ ዎጋይ ሀይሳ። ");
INSERT INTO gofe_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","አሮና አደ ናይት ናምአይ ጎዳ ስን ሺቅድ ሀይቅዳፐ ጉየ፥ ጎዳይ ሙሰኮ ሀይሳዳ ያግስ፦ ");
INSERT INTO gofe_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","ታኒ ታቦትያ ናጋራ አቶተꬃ ካማ ቦላ ሻራን ግዳዳ ቆንጭያ ግሾ ማጋራጁዋፈ ጉየን ደእያ ኡባፈ ጌሻ በሳ ባ ኮይዳ ዎደ ገልድ ሀይቆና መላ ነ እሻ አሮናስ ኦዳ። ");
INSERT INTO gofe_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","አሮን ናጋራ ያርሾስ እስ ዎፋኖ፥ ፁሳ ያርሾስ እስ ማራዘ ኤክድ ኡባፈ ጌሻ በሳ ገሎ። ");
INSERT INTO gofe_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","አሮን ሊኖፐ ኦሰትዳ ጌሻ አዱሳ ቃምሰነ ጋርሳራ ማኤትያ ማኦ ማኦ። ሊኖፐ ኦሰትዳ ዳንጮ ዳንጮ፤ ሄሳዳ ባ ሁጰን ሊኖፐ ኦሰትዳ ፃꬃ ቃጨ ዎꬆ። ሄ ማኦት ጌሽ ግድያ ግሾ፥ ማአናፐ ስን ባ አሳተꬃ ሜጨቶ። ");
INSERT INTO gofe_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","እስራኤለ ማባራይ ናጋራ ያርሾስ ናምኡ ኮለታ፥ ፁሳ ያርሾስ እስ ማራዘ አሮናስ ኤሆ። ");
INSERT INTO gofe_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","አሮን ባ ናጋራስነ ባ ሶ አሳ ናጋራ አቶተꬃስ እስ ዎፋኖ ያርሾ። ");
INSERT INTO gofe_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","ሄሳፈ ጉየ፥ ናምኡ ኮለታ ጌሻ ዱንካንያ ፐንገን ጎዳ ስን ኤሆ። ");
INSERT INTO gofe_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","ሄ ናምኡ ዴሻታ ኤክድ እሱዋ ጎዳሳ፥ እሱዋ ቃስ አዛዘላሳ ግድ ኤንታ ቦላ ሳማ የጎ። ");
INSERT INTO gofe_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","አሮን ሳማን ጎዳስ ግድዳ ዴሻ ኤክድ ናጋራ ያርሾ ኦꬅድ ያርሾ። ");
INSERT INTO gofe_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","ሽን ሳማን አዛዘላስ ግድዳ ዴሻ አሳ ናጋራ አቶተꬃስ መላ ቢታ የዳናዉ ፓፃ ደእሽን ጎዳስ ሺሾ። ");
INSERT INTO gofe_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","አሮን ባ ናጋራስነ ባ ሶ አሳ ናጋራ አቶተꬃስ እስ ዎፋኖ ናጋራ ያርሾ ኦꬅድ ሺሾ። ያትድ ባ ናጋራ ግሾ ሄ ዎፋኑዋ ሹኮ። ");
INSERT INTO gofe_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","ጎዳ ስንꬃን ደእያ ያርሾ በሳፈ እፃነ ጩይስያ ሚሸን ቦንቆ ኩንꬅድ፥ ሊቅድ ጋጨትዳ ሳውያ እፃነ ናምኡ ኩጫ ኤክድ ማጋራጁዋ ግዶ ገሎ። ");
INSERT INTO gofe_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","ጎዳ ስንꬃን ደእያ ታማን እፃነ ዎꬆ። እ ሀይቆና መላ እፃንያ ጩያይ ታቦትያ ቦላ ደእያ ናጋራ አቶተꬃ ካማ ካሞ። ");
INSERT INTO gofe_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","ዎፋኑዋ ሱꬃፈ ጉꬃራ ኤክድ፥ ባ ብራꬍያ የድ ኤክድ አቶተꬃ ካማ ስንꬃ ባጋ ዉርፆ። ናጋራ አቶተꬃ ካማ ስንꬃ ባጋራ ደእያ በሳ ላፑን ቶሆ ዉርፆ። ");
INSERT INTO gofe_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","ሄሳፈ ጉየ፥ አሳ ናጋራ ግሾ ግድያ ዴሻ ሹክድ፥ እያ ሱꬃ ማጋራጁዋ ግዶ ኤህድ፥ ዎፋኑዋ ሱꬃ ዉርፅዳይሳዳ ናጋራ አቶተꬃ ካማነ ታቦትያ ስንꬃ ዉርፆ። ");
INSERT INTO gofe_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","ኡባፈ ጌሻ በሳ እስራኤለ አሳ ቱናተꬃፈነ ናጋራፐ ጌሼስ። ኤንቲ ቱናባ ኦꬅሽን፥ ኤንታ ግዶን ደእያ ጌሻ ዱንካንያ ሀይሳዳ ኦꬅድ ጌሾ። ");
INSERT INTO gofe_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","አሮን ኡባፈ ጌሻ በሳ ገልድ፥ ባ ናጋራ፥ ባ ሶ አሳ ናጋራነ ኩመꬃ እስራኤለ አሳ ናጋራ አቶተꬃስ ያርሽድ ከያና ጋካናዉ፥ ኦንካ ጌሻ ዱንካንያ ግዶን ደኦፖ። ");
INSERT INTO gofe_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","ሄሳፈ ጉየ፥ ጎዳ ስንꬃን ደእያ ያርሾ በሳ ከይድ እያ ጌሾ። ዎፋኑዋ ሱꬃፈነ ዴሻ ሱꬃፈ ጉꬃራ ኤክድ፥ ያርሾ በሳ ዩሹዋን ደእያ ካጨታ ትዮ። ");
INSERT INTO gofe_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","ሄ ሱꬃን ባ ብራꬍያ የድ ኤክድ ላፑን ቶሆ ዉርፆ፤ ሄሳዳ ኦꬅድ እስራኤለ አሳ ቱናተꬃፈ ሄ ያርሾ በሳ ጌሾ። ");
INSERT INTO gofe_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","አሮን ኡባፈ ጌሻ በሳ፥ ጌሻ ዱንካንያነ ያርሾ በሳ ጌሽያ ዎጋ ፖልዳፐ ጉየ፥ ፓፃ ደእያ ዴሻ ሺሾ። ");
INSERT INTO gofe_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","አሮን ባ ናምኡ ኩሽያ ፓፃ ደእያ ዴሻ ሁጰን ዎꬅድ፥ እስራኤለ አሳ ናቆ ኡባ፥ ኤንታ ማካላ ኡባ፥ ኤንታ ናጋራ ኡባ ፓፆ። ያትድ ሄ ዴሻ ሁጰን ሄሳ ቶሶ፤ ሄ ዴሻ ኤፋና መላ ጊግስዳ ኡራ ቦላ መላ ቢታ የዶ። ");
INSERT INTO gofe_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","ዴሻይ ኤንታ ናጋራ ኡባ ቶክድ፥ አስ ባይና በሲ መላ ቢታ ቦ። ");
INSERT INTO gofe_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","ሄሳፈ ጉየ፥ አሮን ጌሻ ዱንካንያ ብድ ኡባፈ ጌሻ በሳ ገሎ። ሊኖፐ ኦሰትዳ ካሰ እ ማእድ ገልዳ ማኡዋ ቃርድ ያን ዎꬆ። ");
INSERT INTO gofe_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","ጌሻ በሳን ባ አሳተꬃ ሜጨትድ፥ ባ ካሰ ማኡዋ ማእ ከይድ ባ ናጋራነ አሳ ናጋራ አቶተꬃስ ፁሳ ያርሾ ያርሽሶ። ");
INSERT INTO gofe_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","ናጋራ ያርሹዋ ሞꬉዋ ያርሾ በሳን ፁጎ። ");
INSERT INTO gofe_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","ባዞ የደትያ ዴሻ ኤፍዳ ኡራይ ባ ማኡዋ ሜጮ፤ ባ አሳተꬃ ሜጨቶ፤ ያት ስሚድ ጉታ ገሎ። ");
INSERT INTO gofe_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","ናጋራ አቶተꬃስ አሮን ኤንታ ሱꬃ ኡባፈ ጌሻ በሳ ኤህዳ ዎፋኑዋነ ዴሻ ጋልባ፥ አትዳ አሹዋነ ቶጭያ ጉታፐ ጋፃ ከስድ ፁጎ። ");
INSERT INTO gofe_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","ሄሳ ፁግዳ ኡራይ ባ ማኡዋ ሜጮ፤ ባ አሳተꬃ ሜጨቶ፤ ሄሳፈ ጉየ፥ ጉታ ገሎ። ");
INSERT INTO gofe_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","ሀይስ ህንተዉ መርና ዎጋ ግዶ፤ ላፑንꬃ አጌናይ ገልዳ ታማንꬆ ጋላስ ህንተና ካዉሽተ፤ ቢታ አዉ ናአ ግድን ዎይኮ ሀራ ቢታ አስ ግድን፥ አይ ኦሶካ ኦꬆፍተ። ");
INSERT INTO gofe_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","አይስ ጊኮ ሄ ጋላሳይ ህንተ ናጋራ አቶተꬅ ደምያ ጋላስ፤ ህንተ ጎዳ ስንꬃን ህንተ ናጋራ ኡባፈ ጌያና። ");
INSERT INTO gofe_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","ሄስ ህንተዉ ግታ ሳምባታ ሸምፖ ጋላስ ግዳና። ሄ ጋላስ ህንተና ካዉሽተ፤ ሄስ ህንተዉ መርና ዎጋ ግዶ። ");
INSERT INTO gofe_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","ቃስ ባ አዋ በሳን ካህነ ግዳና መላ ትየትያነ ዱማትያ ካህነይ ጌሽ ግድዳ ሊኖፐ ኦሰትዳ ማኡዋ ማእድ፥ ናጋራ አቶተꬃ ዎጋ ፖሎ። ");
INSERT INTO gofe_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","እ ኡባፈ ጌሻ በሳ፥ ገሻ ዱንካንያ፥ ያርሾ በሳ፥ ካህነታነ እስራኤለ አሳ ኡባ ጌሾ። ");
INSERT INTO gofe_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","እስራኤለ አሳ ኡባ ናጋራ አቶተꬃስ ላይꬃን ላይꬃን እስ ቶሆ ኦꬃናዉ ሀይስ ህንተዉ መርና ዎጋ ግዶ። ጎዳይ ኪትዳይሳዳ ሙሰይ ኦꬅስ። ");
INSERT INTO gofe_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","ጎዳይ ሙሰኮ ሀይሳዳ ያግስ፤ ");
INSERT INTO gofe_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“አሮናስ እያ አደ ናይታስነ እስራኤለ አሳ ኡባስ ሀይሳዳ ያጋዳ ኦዳ፤ ጎዳይ ኪትዳይስ ሀይሳ፤ ");
INSERT INTO gofe_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","እስራኤለ አሳፐ ኦንካ ቦር ዎይኮ ማራዘ ዎይኮ ኮለ ጉታን ዎይኮ ጉታፐ ጋፃን ሹክድ፥ ");
INSERT INTO gofe_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","ጎዳስ እሞታ ኦꬅድ እማናዉ ጌሻ ዱንካንያ ፐንገ ጎዳ ስን ኤሆና እፅኮ፥ እ ሄ ሱꬃን ኦይሸቴስ። ሄ ኡራይ ሱꬁ ጉስዳ ግሾ ባ አሳ ግዶፈ ኩረቶ። ");
INSERT INTO gofe_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","ሄሳ ግሾ፥ እስራኤለ አሳይ ያርሾ መሄ ጮ ደንባን ሹከይሳ አግድ፥ ጎዳ ስንꬃን ጌሻ ዱንካንያ ፐንገን ደእያ ካህንያኮ ኤሆ። ካህነይ ሄሳ ኤክድ፥ ጎዳስ እስፈተꬃ ያርሾ ኦꬅድ ሹኮ። ");
INSERT INTO gofe_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","ካህነይ ጌሻ ዱንካንያ ፐንገን ደእያ ያርሾ በሳ ቦላ ሄ ሱꬃ ዉርፆ። ሞꬉዋ ጎዳስ ሳዎ ቶንኩ ግያ ያርሾ ኦꬅድ ፁጎ። ");
INSERT INTO gofe_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","እስራኤለ አሳይ ጎዳ አግድ ካልዳ ቱና አያናታስ ዛሪድ ባንታ ያርሹዋ ያርሾፎ። ሄስ ኤንታዉነ ያና የለተꬃ ኡባስ መርና ዎጋ ግዶ። ");
INSERT INTO gofe_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“ኤንታኮ ሀይሳዳ ያጋ፤ እስራኤለ አሳፐ ግድን ዎይኮ ኤንታ ግዶን ደእያ አላጋ ቢታ አሳፐ ግድን፥ ኦንካ ፁሳ ያርሾ ዎይኮ ሀራ ያርሾ ሺሽያ ዎደ፥ ");
INSERT INTO gofe_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","ጎዳስ ያርሻናዉ ጌሻ ዱንካንያ ፐንገ ኤሆና እፅኮ፥ ሄ ኡራይ ባ አሳ ግዶፈ ኩረቶ። ");
INSERT INTO gofe_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“እስራኤለ አሳፐ ዎይኮ ኤንታ ግዶን ደእያ አላጋ ቢታ አሳፐ ኦንካ ሱꬁ ሚኮ፥ ሄ ሱꬃ ምያ ኡራ ቦላ ታ ዞኮ ዛራና፤ ታኒ ሄ ኡራ አሳ ግዶፈ ኩራና። ");
INSERT INTO gofe_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","አይስ ጊኮ አሾ ማእዳ ኡባ ደኦይ እያ ሱꬃ ግዶን ደኤስ፤ ሱꬅ ደኦይ እያ ግዶን ደእያ ግሾ ናጋራ አቶ ጊሴስ። ህንተ ናጋራ አቶተꬃስ ሱꬁ ያርሻና መላ ህንተዉ እማስ። ");
INSERT INTO gofe_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","ታኒ እስራኤለ አሳኮ፥ ህንተፈ ዎይኮ ህንተ ግዶን ደእያ አላጋ ቢታ አሳፐ ኦንካ ሱꬁ ሞፖ ያግዳይ ሄሳ ግሾሳ። ");
INSERT INTO gofe_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“እስራኤለ አሳፐ ዎይኮ ኤንታ ግዶን ደእያ አላጋ ቢታ አሳፐ ኦንካ ሜተትያ ዶአ ዎይኮ ካፎ ሻንካትድ ዎꬍኮ፥ እያ ሱꬃ ሳአን ጉስድ ቢታ ካሞ። ");
INSERT INTO gofe_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","አይስ ጊኮ አሾ ማእዳ ኡባ ደኦይ እያ ሱꬃ ግዶና። አሾ ማእዳ መተꬃታ ኡባ ደኦይ እያ ሱꬃ ግዶን ደእያ ግሾ፥ ሱꬁ ሞፕተ፤ ቃስ ምያ ኦንካ ባ አሳ ግዶፈ ኩረቶ ያጋዳ እስራኤለ አሳስ ኦዳስ። ");
INSERT INTO gofe_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“እስራኤለ አሳ ግድን ዎይኮ ኤንታ ግዶን ደእያ አላጋ ቢታ አሳ ግድን፥ ኦንካ ባዉታ ዎይኮ ዶእ ዎꬍዳባ ሚኮ፥ ባ ማኡዋ ሜጮ፤ ባ አሳተꬃ ሜጨቶ፤ ያትድ ኦማርስ ጋካናዉ ቱና ግዴስ። ሄሳፈ ጉየ፥ እ ጌሽ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","ባ ማኡዋ ሜጮና እፅኮ፥ ባ አሳተꬃ ሜጨቶና አግኮ፥ እ ባ ናጋራ ባዉ ቶኬስ።” ");
INSERT INTO gofe_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","ጎዳይ ሙሰኮ ሀይሳዳ ያግስ፤ ");
INSERT INTO gofe_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“እስራኤለ አሳስ ሀይሳዳ ያጋዳ ኦዳ፤ ታኒ ጎዳ፥ ህንተ ፆሳ። ");
INSERT INTO gofe_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","ህንተ ካሰ ደእዳ ግብፀ አሳይ ኦይሳዳ ኦꬆፕተ፤ ዎይኮ ሀእ ታኒ ህንተና ገልስያ ካናነ ቢታ አሳይ ኦይሳዳ ኦꬆፕተ፤ ኤንታ ዎጋ ካሎፍተ። ");
INSERT INTO gofe_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","ህንተ ታ ኪታ ኦꬅተ፤ ታ ዎጋ ናግተ፤ ታኒ ጎዳ፥ ህንተ ፆሳ። ");
INSERT INTO gofe_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","ታ ኪታነ ታ ዎጋ ናግተ፥ ህንተ ሄሳ ኦꬅኮ ደኦን ዳና። ታኒ ጎዳ። ");
INSERT INTO gofe_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“ህንተፈ ኦንካ ባ ማታ ዳቦራ ፃሎፎ። ታኒ ጎዳ። ");
INSERT INTO gofe_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","“ነ አይዉ ፃላዳ ነ አዋ ካዉሾፋ። እያ ነ አይዉ ግድያ ግሾ እዮ ፃሎፋ። ");
INSERT INTO gofe_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","“ነ አዋ ማችዉ ፃላዳ ነ አዋ ካዉሾፋ። ");
INSERT INTO gofe_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","“ነ ምችዉ ፃሎፋ፤ ሶን የለትዳ ዎይኮ ካረን የለትዳ ነ አዋ ናእዉ ዎይኮ ነ አየ ናእዉ ፃሎፋ። ");
INSERT INTO gofe_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","“ነ ናኣ ናእዉ ዎይኮ ነ ናኤ ናእዉ ፃላዳ ነ ነና ካዉሾፋ። ");
INSERT INTO gofe_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","“ነ ምቾ ግድያ ግሾ ነ አዋ ማቸ ናእዉ ፃሎፋ። ");
INSERT INTO gofe_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","“ነ አዋ ምችዉ ፃሎፋ፤ እያ ነ አዋስ ማታ ዳቦ። ");
INSERT INTO gofe_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","“ነ አየ ምችዉ ፃሎፋ፤ እያ ነ አየስ ማታ ዳቦ። ");
INSERT INTO gofe_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","“ነ አዋ እሻ ማችዉ ፃሎፋ፤ እያ ነ አዋ እሻ ማችዉ። ");
INSERT INTO gofe_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","ነ ናኣ ማችዉ ፃሎፋ፤ እያ ነ ናኣ ማችዉ። ");
INSERT INTO gofe_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","“ነ እሻ ማችዉ ፃላዳ ነ እሻ ካዉሾፋ። ");
INSERT INTO gofe_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","“አይዉነ እ ናእዉ ፃሎፋ፤ እ ናኤ ናእዉ ዎይኮ እ ናኣ ናእዉ ፃሎፋ። ኤንቲ እዉ ማታ ዳቦ ግድያ ግሾ፥ ሄስ ኢታ ቱና። ");
INSERT INTO gofe_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","“ነ ማችያ ፓፃ ደእሽን፥ ነ ማቸ ምችዉ ዳዉꬆፋ። ");
INSERT INTO gofe_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“ኩሸ መቶራ ደእያ ማጫስ ፃሎፋ። ");
INSERT INTO gofe_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","“ኔኒ ቱኖና መላ ነ ሾሩዋ ማችዉ ፃሎፋ። ");
INSERT INTO gofe_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","“ነ ፆሳ ሱንꬃይ ጫየቶና መላ ነ ናይታፐ እሱዋ ታማን ፁጋዳ፥ ሞሎካ ግያ ኤቃስ ያርሾ ኦꬃዳ እሞፋ። ታኒ ጎዳ። ");
INSERT INTO gofe_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","“ፆሳ ስንꬃን እፀትዳባ ግድያ ግሾ ማጫሳራ ጋሄተይሳዳ አደራ ጋሄቶፋ። ");
INSERT INTO gofe_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","“ኔኒ ቱኖና መላ መሄራ ጋሄቶፋ፤ ማጫስ መሄራ ጋሄታናዉ መሄ ስን አꬎፎ። ሄስ ዎጋን ባይናባ። ");
INSERT INTO gofe_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“ታኒ ህንተ ስንꬃፈ የደꬅያ ካዎተꬃት ሄ ኦሶታን ቱንዳ ግሾ፥ ህንተ ሄ ኦሶታን ኤንታ መላ ቱኖፕተ። ");
INSERT INTO gofe_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","ሀር አቶሽን፥ ቢታይካ ቱንዳ ግሾ፥ እያ ናጋራ ግሾ ታ እያ ሴራስ። ቢትያ ባናን ደኤይ አሳ ጩታሱ። ");
INSERT INTO gofe_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","ሽን ህንተ ታ ህግያነ ታ ኪታ ናግተ። ህንተና ግድን ዎይኮ ህንተ ግዶን ደእያ አላጋ ቢታ አሳ ግድን ኦንካ ሄሳ መላ ቱና ኦሶ ኦꬆፕተ። ");
INSERT INTO gofe_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","“ህንተፈ ካሰ ሀ ቢታን ደእዳ አሳይ ሄሳ መላ ቱናባ ኦꬅዳ ግሾ፥ ቢትያ ቱናሱ። ");
INSERT INTO gofe_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","ህንተ ሀ ቢታ ቱንስኮ፥ ህንተፈ ካሰ ደእዳ ካዎተꬃታ ሀ ቢትያ ጩትዳይሳዳ ህንተናካ ጩቶና መላ ናገትተ። ");
INSERT INTO gofe_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","ሄሳታ ዳንያ ቱና ኦሶታፐ እሱዋካ ኦꬅያ አስ ደእኮ፥ ሄ ኡራይ ባ አሳ ግዶፈ ኩረቶ። ");
INSERT INTO gofe_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","ሄሳ ግሾ፥ ህንተፈ ካሰ ደእዳ አሳት ኦꬅዳ ቱና ኦሶታ ኡባ ኦꬅድ ህንተ ቱኖና መላ ታ ኪታ ናግተ፤ ታኒ ጎዳ፥ ህንተ ፆሳ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","ጎዳይ ሙሰኮ ሀይሳዳ ያግስ። ");
INSERT INTO gofe_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","እስራኤለ አሳ ኡባስ ሀይሳዳ ያጋዳ ኦዳ፤ “ታኒ፥ ጎዳይ፥ ህንተ ፆሳይ፥ ጌሽ ግድያ ግሾ፥ ህንተካ ጌሽ ግድተ። ");
INSERT INTO gofe_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","“ህንተፈ እሶይ እሶይ ባ አዋነ ባ አይዉ ቦንቾ፤ ታ ሳምባታ ቦንችተ። ታኒ ጎዳ፥ ህንተ ፆሳ። ");
INSERT INTO gofe_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","“ታና አግድ ኤቃታ ጎይኖፍተ፤ ዎይኮ ብራታፐ ኦሰትዳ ፆሳታ ህንተዉ ኦꬆፕተ። ታኒ ጎዳ፥ ህንተ ፆሳ። ");
INSERT INTO gofe_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“ህንተ እስፈተꬃ ያርሾ ጎዳስ ያርሽያ ዎደ ሄ ያርሾይ ህንተ ግሾ ኤከታና መላ በሰይሳዳ ያርሽተ። ");
INSERT INTO gofe_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","ሄ ያርሾይ ህንተ ያርሽዳ ጋላስ ዎይኮ ዎንተꬃ ጋላስ ሜተቶ፤ ሄꬓንꬆ ጋላስ ጋካናዉ አትዳይ ደእኮ ታማን ፁገቶ። ");
INSERT INTO gofe_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","ሄꬓንꬆ ጋላስ ሜተትኮ፥ ሄስ ቱንስያባ፤ ታኒ ሄሳ ኤክከ። ");
INSERT INTO gofe_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","ሄሳ ምያ ኦንካ ጎዳስ ጌሽ ግድዳባ ቱንስዳ ግሾ ባ ናጋራን ኦይሸታና። ሄ ኡራይ ባ አሳ ግዶፈ ኩረቶ። ");
INSERT INTO gofe_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“ህንተ ጋደን ካፅዳ ካꬃ ህንተ ጫክያ ዎደ ጋድያ ጋፃ ጋካናዉ ደኤይሳ ጫኮፍተ፤ ጫክ ስምን ደእያ ፖሽልያ ቆሮፕተ። ");
INSERT INTO gofe_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","ነ ዎይነ አይፍያ ማፅያ ዎደ ምꬃ ቦላ ቆሰትድ አትዳይሳ ዎይኮ ሳአን ዎꬍዳ ዎይነ አይፍያ ማፆፓ። ሄሳ ማንቆታስነ በተ አሳስ አጋጋ። ታኒ ጎዳ፥ ህንተ ፆሳ። ");
INSERT INTO gofe_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“ካይሶቶፕተ። “ዎርዶቶፕተ። “እሶይ እሱዋ ጭሞፍተ። ");
INSERT INTO gofe_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","“ታ ሱንꬃን ዎርዶ ጫቆፍተ፤ ህንተ ፆሳ ሱንꬃ ቱንሶፕተ። ታኒ ህንተ ጎዳ። ");
INSERT INTO gofe_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“ነ ሾሩዋ ቦላ ገነ ኦꬆፋ፤ ዎይኮ እያ ቦንቆፋ። “ኡነ ኦꬅያ ኡራ ዳሞዝያ ድጋዳ፥ እስ ቃማካ ነ ማታን አይሶፓ። ");
INSERT INTO gofe_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","“ቱልያ ጫዮፓ፤ ዎይኮ ቆቅያ ስንꬃን ꬉበ ዎꬆፋ፥ ሽን ኔኒ ፆሳስ ያያ። ታኒ ነ ጎዳ። ");
INSERT INTO gofe_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“ፕርዳ ጌላዮፕተ፤ ማንቁዋ እያ ማንቆተꬃ ግሾ ማዳዳ ፕርዶፋ፤ ዱርያ እያ ዱረተꬃ ግሾ ያያዳ አጎፋ። ሽን ነ ሾሩዋስ ሱረ ፕርዳ። ");
INSERT INTO gofe_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","“ነ አሳ ግዶን ኢታ ዝግርስ ኤካዳ ዩዮፓ። “ነ ሾሩዋ ሀይቆስ ጋꬅያባ አይኮካ ኦꬆፋ። ታኒ ነ ጎዳ። ");
INSERT INTO gofe_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“ነ እሻ ነ ዎዛናን እፆፋ። ነ ሾሩዋ ጋሶን ነ ናጋራ ኦꬆና መላ እያ ሀንቃ። ");
INSERT INTO gofe_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","“ሀሎ ከዮፓ፤ ነ አሳፐ እሱዋ ቦላካ ሽፎፓ። ሽን ነ ሾሩዋ ነ ሁጰዳ ዶሳ። ታኒ ነ ጎዳ። ");
INSERT INTO gofe_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“ታ ኪታታ ናጋ። “እስ ቆሞ መሄ ሀራ ቆሞ መሄራ ብራይስሶፓ። “እስ ሾቃን ናምኡ ቆሞ ዘረꬅ ዘሮፓ። “ናምኡ ቆሞፈ ኦሰትዳ ማኦ ማኦፋ። ");
INSERT INTO gofe_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“እስ አስ አዝናስ ኦይሸታዳ ደእሽን፥ ዎዞ ሚሸይ እመትድ ዉሮናሽን ዎይኮ ላአ ከዮናሽን፥ ሄ አይለራ አቅኮ ኤንቲ ሴረታናዉ በሴስ፥ ሽን ኤንቲ ሀይቃናዉ በሰና። ");
INSERT INTO gofe_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","ግዶሽን፥ ሄ ኡራይ ባ ናቆ ያርሾስ ግድያ ማራዘ ጌሻ ዱንካንያ ፐንገን ጎዳ ስን ኤሆ። ");
INSERT INTO gofe_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","ካህነይ ሄ ናቆ ያርሾ ማራዝያ ኤክድ፥ ኡራ ናጋራ አቶተꬃስ ጎዳ ስንꬃን ያርሼስ፤ እያ ናጋራይ አቶ ጌተታና። ");
INSERT INTO gofe_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“ህንተ ካናነ ቢታ ገልያ ዎደ አይፈ እምያ አይ ቆሞ ምꬅ ቶክኮካ፥ ሄ ምꬃ አይፈይ ሜተቶና መላ ድገትዳይሳ አኬክተ። ሄꬑ ላይꬅ ዉራና ጋካናዉ ሄ ምꬃ አይፈይ ሜተቶፎ። ");
INSERT INTO gofe_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","ኦይዳንꬆ ላይꬃን ሄ ምꬃ አይፈይ ጎዳስ ጋላታስ ሺቅያ ጌሻ ያርሾ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","እቻሻንꬆ ላይꬃን ሄ ምꬃ አይፍያ ሚተ። ህንተ ሄሳዳ ኦꬅኮ፥ ህንተ ምꬃ አይፈይ ዳራና። ታኒ ጎዳ፥ ህንተ ፆሳ። ");
INSERT INTO gofe_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“ሱꬅ እያ ግዶን ደእያ አሾ ሞፕተ። ማሮቶፕተ ዎይኮ ብቶፕተ። ");
INSERT INTO gofe_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","“ህንተ ሁጰ ብናና ጋርሳራ ዩሽ አꬅድ ጪሮፕተ፤ ህንተ ቡቻ ዩሽ አꬅድ ሜዶፕተ። ");
INSERT INTO gofe_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","“ሀይቅዳ አሳ ግሾ ህንተ አሳተꬃ ጋሮፕተ፤ ዎይኮ ጫቻ ቤታ ህንተ አሳተꬃ ቦላ መꬎፍተ። ታኒ ነ ጎዳ። ");
INSERT INTO gofe_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“ቢትያ ላይማተꬃንነ ቱናተꬃን ኩሞና መላ ነ ማጫ ናእዉ ላይማተꬃስ አꬃ እማዳ ቱንሶፓ። ");
INSERT INTO gofe_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","“ታ ሳምባታ ቦንችተ፤ ታ ጎይነትያ በሳ ቦንችተ። ታኒ ጎዳ። ");
INSERT INTO gofe_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“ሞይትለ ኦድስያ አሳኮ ዎይኮ ማሮታኮ ቦፕተ፤ ህንተ ቱኖና መላ ኤንታ ኮዮፕተ። ታኒ ጎዳ፥ ህንተ ፆሳ። ");
INSERT INTO gofe_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“ዶንꬓ አስነ ጭማ አስ በእያ ዎደ ኡትዳ በሳፈ ደንዳ ኤቃዳ ኤንታ ቦንቻ፤ ነ ፆሳስ ያያ። ታኒ ጎዳ። ");
INSERT INTO gofe_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“ህንተ ቢታን ደእያ በተ አሰ ሱጎፕተ። ");
INSERT INTO gofe_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","ህንተ ቢታን ደእያ በተ አስ ህንተ ጋደ አሳዳ ፄልተ፤ እያ ህንተ ሁጰዳ ዶስተ። ህንተ ካሰ ግብፀ ቢታን በተ አስ ግድድ ደእደታ። ታኒ ጎዳ፥ ህንተ ፆሳ። ");
INSERT INTO gofe_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“ህንተ ዋꬍያባን፥ ማክያባንነ ምዛነን ዎርዶቶፕተ። ");
INSERT INTO gofe_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","ህንተ ምዛነይ፥ ህንተ ማክያባይነ ዋꬍያባይ እስኖ ግዶ። ታኒ ህንተና ግብፀ ቢታፈ ከሳዳ ኤህዳ ጎዳ ህንተ ፆሳ። ");
INSERT INTO gofe_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","“ህንተ ታ ህግያነ ታ ኪታ ኡባ ናግተነ ኦꬅተ። ታኒ ጎዳ።” ");
INSERT INTO gofe_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","ጎዳይ ሙሰኮ ሀይሳዳ ያግስ። ");
INSERT INTO gofe_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","እስራኤለ አሳስ ሀይሳዳ ያጋዳ ኦዳ፤ “እስራኤለ አሳፐ ግድን፥ ዎይኮ ህንተ ግዶን ደእያ አላጋ አሳፐ ግድን፥ ኦንካ ባ ናአ ሞሎካ ጌተትያ ኤቃስ አꬅድ እምኮ፥ እ ሀይቆ፤ እስራኤለ አሳይ እያ ሹቻን ጫድድ ዎꬎ። ");
INSERT INTO gofe_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","ባ ናኣ ሞሎካ ጌተትያ ኤቃስ እምድ ታ ዱንካንያ ቱንሰይነ ታ ጌሻ ሱንꬃ ካዉሸይ ታ ስንꬃን እፀትዳባ ግዳና። ታ አሳ ግዶፈ ሻካዳ ታኒ እያ ꬋይሳና። ");
INSERT INTO gofe_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","ሽን ሄ ኡራ እስራኤለ አሳይ በእሸ ቀል ግድ አꬍኮነ ዎꬎና እፅኮ፥ ");
INSERT INTO gofe_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","ታኒ ሄ አድያነ እያ ሶ አሳ ሞርካና፤ እያነ ሞሎካ ካልዳይሳታ ኤንታ ደርያ ግዶፈ ሻካዳ ꬋይሳና። ");
INSERT INTO gofe_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“ኦንካ ታና አማነቶና እፅድ ሞይትለ ፄግኮነ ማሮ ሶ ቢኮ፥ ታኒ እያዉ ሞርከ ግዳና፤ አሳ ግዶፈ እያ ꬋይሳና። ");
INSERT INTO gofe_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","“ታኒ፥ ጎዳይ፥ ህንተ ፆሳ ግድያ ግሾ፥ ህንተ ህንተና ዱማይተ፤ ጌሽ ግድተ። ");
INSERT INTO gofe_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","ታ ዎጋ ናግተ፤ እያ ፖልተ። ታኒ ህንተና ጌሽያ፥ ህንተ ጎዳ። ");
INSERT INTO gofe_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“ኦንካ ባ አዋ ዎይኮ ባ አይዉ ጫይኮ ሀይቆ። እ ባ አዋ ዎይኮ ባ አይዉ ጫይዳ ግሾ፥ እያ ሱꬃ አጮይ እያ ቦላ ግዶ። ");
INSERT INTO gofe_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“እስ አስ ባ ሾሩዋ ማችዉ ፃልኮ፥ ኤንቲ ናምአይ ሀይቆ። ");
INSERT INTO gofe_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","እስ አስ ባ አዋ ማችዉ ፃልኮ፥ እ ባ አዋ ካዉሽስ፤ ኤንቲ ናምአይ ሀይቆ። ኤንታ ሱꬃ አጮይ ኤንታ ቦላ ግዶ። ");
INSERT INTO gofe_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","እስ አስ ባ ናኣ ማችዉ ፃልኮ፥ ኤንቲ ናምአይ ሀይቆ። ኤንቲ ቱናባ ኦꬅዶሶና፤ ኤንታ ሱꬃ አጮይ ኤንታ ቦላ ግዶ። ");
INSERT INTO gofe_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","“እስ አደይ ማጫሳራ ጋሄተይሳዳ አደራ ጋሄትኮ፥ ኤንቲ ናምአይ እፀትዳባ ኦꬅዳ ግሾ ሀይቆ። ኤንታ ሱꬃ አጮይ ኤንታ ቦላ ግዶ። ");
INSERT INTO gofe_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","እስ አስ ናእዉነ አይዉ ማቾ ኤክኮ፥ ሄስ ቱናባ። ህንተ ግዶን ቱናተꬅ ዶና መላ እነ ኤንቲ ታማን ፁገቶ። ");
INSERT INTO gofe_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","“እስ አስ መሄራ ጋሄትኮ፥ እ ሀይቆ፤ ሄ ሚዝዉ ዎꬍተ። ");
INSERT INTO gofe_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","እስ ማጫስ መሄራ ጋሄትኮ ሄ ማጫስያነ ሄ መሄይ ናምአይ ሀይቆ፤ ኤንታ ሱꬃ አጮይ ኤንታ ቦላ ግዶ። ");
INSERT INTO gofe_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“እስ አስ ባ አዋ ናእዉ ዎይኮ ባ አየ ናእዉ ማቾ ኤክኮ፥ ሄስ ቱናባ። ኤንቲ ባንታ አሳ ግዶፈ ሻከትድ ሀይቆ። እ ባ ምችዉ ካዉሽዳ ግሾ፥ ባ ናጋራን ባዉ ኦይሸቶ። ");
INSERT INTO gofe_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","እስ አስ ኩሸ መቶራ ደእያ ማጫሳራ አቅኮ፥ እ ቀꬃ ቃርዳ ግሾ፥ ኤንቲ ናምአይ ባንታ አሳ ግዶፈ ኩረቶ። ");
INSERT INTO gofe_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","“ነ አየ ምችዉ ዎይኮ ነ አዋ ምችዉ ፃሎፋ፤ ሄሳ ኦይ ባ ማታ ዳቦተꬃ ካዉሼስ። ኤንቲ ናምአይ ባንታ ናጋራን ኦይሸቶ። ");
INSERT INTO gofe_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","እስ አስ ባ አዋ እሻ ማችዉ ፃልኮ፥ እ ባ አዋ እሻ ካዉሽስ። ኤንቲ ባንታ ናጋራን ባንታዉ ኦይሸቶ፤ ኤንቲ ናምአይ ናአ የሎና ሀይቃና። ");
INSERT INTO gofe_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","እስ አስ ባ እሻ ማችዉ ኤክኮ፥ ሄስ ቱና። እ ባ እሻ ካዉሽስ፤ ኤንቲ ናምአይ የሎ ꬋያና። ");
INSERT INTO gofe_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“ህንተ ዳና መላ ታ ህንተና ገልስያ ቢታይ ህንተና ጩቶና መላ ህንተ ታ ህግያነ ታ ኪታ ናግተ። ");
INSERT INTO gofe_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","ታኒ ህንተ ስንꬃፈ ꬋይስያ አሳ ደኡዋ ዎጋ ካሎፍተ። ኤንቲ ሄሳ ኡባ ኦꬅዳ ግሾ፥ ታ ኤንታ እፃስ። ");
INSERT INTO gofe_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","ህንተ ኤንታ ቢታ ላታና፤ ማꬅነ ኤስ ጎገይ ቢታ ህንተዉ እማና። ታኒ ህንተና ሀራ አሳፐ ዱማያዳ ከስዳ፥ ጎዳ ህንተ ፆሳ። ");
INSERT INTO gofe_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","“ሄሳ ግሾ፥ ህንተ ቱናነ ቱና ግዶና መሄታነ ካፎታ ሻክድ ኤርተ። ታኒ ሄሳት ህንተዉ ቱና ጋዳ ዎꬅዳ መሄታ፥ ካፎታነ ቢታን ቃፅያባታ ኡባን ህንተና ቱንሶፕተ። ");
INSERT INTO gofe_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","ታኒ ጎዳይ ጌሽ ግድያ ግሾነ ህንተ ታባ ግዳና መላ ህንተና ሀራ አሳፐ ዱማይዳ ግሾ፥ ህንተካ ታዉ ጌሽ ግድተ። ");
INSERT INTO gofe_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“አደይ ዎይኮ ማጭ ሞይትለራ ሃሳይኮ ዎይኮ ማሮትኮ፥ ኤንቲ ሀይቃናዉ በሴስ። ኤንቲ ሹቻን ጫደትድ ሀይቆ፤ ኤንታ ሱꬃ አጮይ ኤንታ ቦላ ግዶ።” ");
INSERT INTO gofe_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","ጎዳይ ሙሰኮ፥ “ካህነ ግድዳ አሮና አደ ናይታስ ሀይሳዳ ያጋዳ ኦዳ። ህንተፈ ኦንካ ");
INSERT INTO gofe_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","ባ ማታ ዳቦ፥ ባ አየ፥ ባ አዋ፥ ባ አደ ናኣ፥ ባ ማጫ ናኤ፥ ባ እሻ፥ ");
INSERT INTO gofe_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","ዎይኮ አዝና ገሎና፥ እያ ሶን ደእያ ባ ምቸ አሀ ግዶና እፅኮ፥ ሀይቅዳ አሳ አሀ ቦችድ ባና ቱንሶፖ። ");
INSERT INTO gofe_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","ኤኮንነ ገሎን ዳቦትዳ አሳ አሀ ቦችድ ባና ቱንሶፖ። ");
INSERT INTO gofe_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“ካህነት ካዮስ ባንታ ሁጵያነ ባንታ ቡቻ ሜዶፖ፤ ዎይኮ ባንታ አሳተꬃ ጋሮፖ። ");
INSERT INTO gofe_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","ኤንቲ ጎዳስ ፁሳ ያርሾነ ካꬃ ያርሾ ሺሽያ ካህነታ ግድያ ግሾ ባንታ ፆሳስ ጌሽ ግዶ፤ ባንታ ፆሳ ሱንꬃ ቱንሶፖ። ሄሳ ግሾ፥ ኤንቲ ጌሽ ግዳናዉ በሴስ። ");
INSERT INTO gofe_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","“ካህነት ባንታ ፆሳስ ጌሽ ግድያ ግሾ፥ ካህነት ላይማ ማጫስ፥ ጌላኦ ግዶና ማጫስ ዎይኮ አዝን የድዳ ማጫስ ኤኮፎ። ");
INSERT INTO gofe_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","ካህነት ህንተ ፆሳስ ካꬃ ያርሾ ያርሸይሳታ ግድያ ግሾ፥ ህንተ ኤንታ ጌሽ ኦꬅድ ኤክተ። ህንተና ጌሽያ ጎዳይ፥ ታኒ፥ ጌሽ ግድያ ግሾ፥ ኤንቲ ጌሽ ግዶ። ");
INSERT INTO gofe_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","ካህንያ ናእያ ላይማታዳ ባና ቱንስኮ፥ እያ ባ አዋ ካዉሻሱ፤ እያ ታማን ፁገታዳ ሀይቆ። ");
INSERT INTO gofe_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“ካህነ ሀላቃይ፥ እያ ሁጰን ትዮ ዛይተይ ጉክዳይስነ ካህነተꬃ ማኡዋ ማአናዉ ዱማትዳይስ፥ ባ ሁጵያፐ ፃꬃ ቃጭያ ደንꬆፎ፤ ባ ማኡዋ ዳኮፎ። ");
INSERT INTO gofe_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","አህ ደእያ ሶ ገሎፖ፤ ሀር አቶሽን ባ አዋ ዎይኮ ባ አየ አሀ ግድኮካ፥ ሄሳ ቦችድ ባና ቱንሶፖ። ");
INSERT INTO gofe_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","እያ ዱማያናዉ ትይዳ ፆሳ ዛይተይ እያ ቦላ ደእያ ግሾ፥ ካህነይ ጌሻ ዱንካንያፐ ከዮፖ፤ ጌሻ ዱንካንያ ቱንሶፖ። ታኒ ጎዳ። ");
INSERT INTO gofe_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","“እ ኤክያ ማችያ ጌላኦ ግዶ። ");
INSERT INTO gofe_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","አዝን ሀይቅዳ ማጫስ ዎይኮ አዝን የድዳ ማጫስ ዎይኮ ላይማ ማጫስ ማቾ ኤኮፎ። ሽን ባ አሳ ግዶፈ ጌላኦ ማጫ ናአ ዶርድ ማቾ ኤኮ። ");
INSERT INTO gofe_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","ሄስ ሀኖና እፅኮ፥ ባ አሳ ግዶን ባ ናይታ ቱና ኦꬄስ። ታኒ እያ ጌሸይሳ፥ እያ ጎዳ።” ");
INSERT INTO gofe_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","ጎዳይ ሙሰኮ ሀይሳዳ ያግስ። ");
INSERT INTO gofe_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“ኔኒ አሮናስ ሀይሳዳ ያጋዳ ኦዳ፤ ነ ኮቻፈ አሳተꬃን ቦረይ ደእያ ኦንካ ካꬃ ያርሾ ታዉ ያርሻናዉ በሰና። ");
INSERT INTO gofe_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","አሳተꬃን ቦረይ ደእያ አስ፥ ሄስካ ቆቀ ዎይኮ ዎበ ዎይኮ ሶምኦይ ኢትዳ አስ ዎይኮ ላቆይ ደእያ አስ፥ ");
INSERT INTO gofe_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","ዎይኮ ቶሆይ ዎይኮ ኩሸይ ስልዳ አስ፥ ");
INSERT INTO gofe_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","ዎይኮ ኩና አስ ዎይኮ ዳሮ ቃንꬃ አስ ዎይኮ አይፈ ሙልጫ አስ ዎይኮ ፑሶይ ኦይክዳ አስ ዎይኮ እራለይ ደእያ አስ ዎይኮ ሹፋ አስ ታዉ ካꬃ ያርሾ ያርሻናዉ በሰና። ");
INSERT INTO gofe_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","ካህንያ አሮና ኮቻፈ አሳተꬃን ቦረይ ደእያ አስ ኦንካ ጎዳስ ፁሳ ያርሾነ ካꬃ ያርሾ ሺሻናዉ ያርሾ በሳ ያናዉ በሰና። ");
INSERT INTO gofe_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","እ ጌሻ ካꬃነ ኡባፈ ጌሽ ግድዳ ባ ፆሳ ካꬃ ማናዉ ዳንዳኤስ። ");
INSERT INTO gofe_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","ሽን እያ አሳተꬃን ቦረይ ደእያ አስ ግድያ ግሾ፥ እ ታ ዱንካንያ ቱንሶና መላ ማጋራጁዋኮ ዎይኮ ያርሾ በሳኮ ሺቆፖ። ኤንታና ጌሽያ ጎዳይ ታና።” ");
INSERT INTO gofe_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","ሙሰይ ሄሳ ኡባ አሮናስ፥ እያ አደ ናይታስነ እስራኤለ አሳ ኡባስ ኦድስ። ");
INSERT INTO gofe_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","ጎዳይ ሙሰኮ ሀይሳዳ ያግስ፤ ");
INSERT INTO gofe_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","ታ ጌሻ ሱንꬃ ኤንቲ ቱንሶና መላ፥ እስራኤለ አሳይ ታዉ ዱማይዳ እሞታታ አሮንነ እያ አደ ናይት ቦንቾን ኤክድ፥ ጌሻተꬃን ናጋና መላ ኤንታዉ ኦዳ። ታኒ ጎዳ። ");
INSERT INTO gofe_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","ኤንታኮ ሀይሳዳ ያጋ፤ “ያና የለተꬃ ኡባን ህንተ ኮቻፈ ኦንካ ቱንድ ደእሸ፥ እስራኤለ አሳይ ጎዳስ ዱማይዳ ጌሻ ያርሹዋኮ ሺቅኮ፥ ሄ ኡራይ ታ ስንꬃን በንቶፎ። ታኒ ጎዳ። ");
INSERT INTO gofe_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","“አሮና ኮቻፈ ጎጋ ሀርገይ ደእያ፥ ዎይኮ አሳተꬃፈ ጎግያባይ ደእያ ኦንካ ጌያና ጋካናዉ ጌሻ ያርሹዋ ሞፖ። አሀ ቦችድ ቱንዳባ ዎይኮ እያ አቱንꬃይ ጉክዳ ኡራ ቦችያ ኦንካ ቱና። ");
INSERT INTO gofe_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","ቃስ ሳአራ ጎሸትያ ቱንስያባታ፥ ዎይኮ አይብባንካ ቱና ግድዳባ ቦችያ ኦንካ፥ ");
INSERT INTO gofe_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","ዎይኮ ሄሳ መላባ ቦችያ ኦንካ፥ ኦማርስ ጋካናዉ ቱና ግዴስ። እ ባ አሳተꬃ ሃꬃን ሜጨቶና ደእሸ፥ ጌሻ ያርሹዋፈ ማናዉ ኮሸና። ");
INSERT INTO gofe_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","አው ዉልያ ዎደ እ ጌሽ ግዴስ። ሄሳፈ ጉየ፥ ሄ ጌሻ ያርሹዋፈ ባና ጋክያ ግሹዋ ሞ። ");
INSERT INTO gofe_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","ሀይቅዳባ ዎይኮ ዶእ ዎꬍዳ መሄ አሾ ሞፖ፤ ሄስ ቱንስያባ። ታኒ ጎዳ። ");
INSERT INTO gofe_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“ካህነት ታ ዎጋ ናጎ፤ ኤንቲ እያ ናጎና እፅድ ባንታ ባላን ሀይቃና። ኤንታ ጌሽያ ጎዳይ ታና። ");
INSERT INTO gofe_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“ሄ ጌሻ ያርሹዋ ካህንያ ሶ አሳፐ አትሽን፥ ሀራ አስ ሞፖ። ካህንያ ሶ ይዳ እማ ግድን፥ ቃፃረትድ ኦꬅያ አሰ ግድን ሞፖ። ");
INSERT INTO gofe_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","ሽን ካህነይ ባ ብራን ሻምዳ አይለይ ዎይኮ እያ ሶን የለትዳ አይለይ ሄ ካꬃ ሞ። ");
INSERT INTO gofe_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","ካህነ ግዶና አስ ገልዳ ካህንያ ናእያ ሄ ጌሻ ያርሹዋፈ ሞፖ። ");
INSERT INTO gofe_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","ሽን እ አዝናይ ሀይቅኮ ዎይኮ እዮ የድኮ ቃስ እዉ ናእ ባይና እፅኮ፥ እያ ካሰ ባ ጌላኦተꬃን ደእዳይሳዳ ስማዳ ባ አዋ ሶን ደእኮ፥ እያ ባ አዋ ጋከይሳፈ ሞ። ሽን ሀራ አስ ኦንካ ሄሳፈ ሞፖ። ");
INSERT INTO gofe_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“እስ አስ ኤሮና ደእሸ ጌሻ ያርሹዋፈ ሚኮ፥ ሄ እ ምዳ ካꬃ ጋትያ ቦላ ፄታፐ ላታሙ ኩሸ ጉጅድ ካህንያስ እሞ። ");
INSERT INTO gofe_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","እስራኤለ አሳይ ጎዳስ ያርሽያ ጌሻ ያርሹዋ ካህነት ቱንሶፖ። ");
INSERT INTO gofe_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","ኤንቲ ባንታ ኤህዳ ጌሻ ያርሹዋ ባንታዉ ምድ ናጋራን ኦይሸታና መላ ኦꬆፎ። ኤንታ ጌሽያ ጎዳይ ታና።” ");
INSERT INTO gofe_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","ጎዳይ ሙሰኮ ሀይሳዳ ያግስ፤ ");
INSERT INTO gofe_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“አሮናስ፥ እያ አደ ናይታስነ እስራኤለ አሳ ኡባስ ሀይሳዳ ያጋዳ ኦዳ፤ እስራኤለ አስ ግድን ዎይኮ ኤንታ ግዶን ደእያ በተ አስ ግድን፥ ኦንካ ጎዳስ ፁሳ ያርሾ ባ ዶሳን እመይ ዎይኮ ባ ቃንገꬃ ጋይ፥ ");
INSERT INTO gofe_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","ሄ ያርሾይ ኤከታና መላ ቦረይ ባይና ዎፋኖ፥ ዎይኮ ማራዘ ዎይኮ ኮለ ኤሆ። ");
INSERT INTO gofe_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","ቦረይ ደእያ አይ መሄይካ ኤከቶና ግሾ ሄሳ ሺሾፕተ። ");
INSERT INTO gofe_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","“እስ አስ ባ ቃንገꬃ ጋꬃናዉ እስፈተꬃ ያርሾ ጎዳስ ያርሽያ ዎደ ዎይኮ ባ መህያፐ ዶሳን እሞታ ጎዳስ ሺሽያ ዎደ ሄስ ኤከታና መላ ሄ መሄይ ቦረይ ባይናባ ግዶ። ");
INSERT INTO gofe_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","ህንተ መህያፐ ቆቀ ዎይኮ መቆ ዎይኮ ዎበ ዎይኮ ግይያ ማዱንꬅ ዎይኮ ፑሶይ ዎይኮ ሻቶይ ደእያባ ጎዳስ ያርሾፍተ። ታማን ፁሳ ያርሾ ኦꬅድ ያርሾ በሳን ጎዳስ ሺሾፕተ። ");
INSERT INTO gofe_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","እያ ቦላ ላቆይ መት ዎይኮ ቦላ ፓጭ ደእያ ኮርማ ዎይኮ ዶርሰ እስ አስ ባ ዶሳን እምያ ያርሾ ሺሻናዉ ዳንዳኤስ፤ ሽን ቃንገꬃ ጋሶስ ግድኮ ሄስ ኤከተና። ");
INSERT INTO gofe_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","ሳንጋ ዎይኮ ማዱንፅዳባ ጎዳስ ያርሾፍተ። ህንተ ቢታን ሄሳ መላባ ኦꬆፕተ። ");
INSERT INTO gofe_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","ህንተ ግዶን ደእያ አላጋ አሳታፐ ኤክዳ ሄሳ መላ መህያ ህንተ ፆሳስ ካꬃ ያርሾ ኦꬅድ ሺሾፕተ። ኤንታ ቦላ ቦረይ ደእያ ግሾ ህንተ ግሾ ኤከቶኮና።” ");
INSERT INTO gofe_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","ጎዳይ ሙሰኮ ሀይሳዳ ያግስ፤ ");
INSERT INTO gofe_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“ቦራ ናእ ዎይኮ ማራዘይ ዎይኮ ኮለይ የለትያ ዎደ ላፑን ጋላስ ባ አየራ ጋምኦ። ሆስፑንꬃ ጋላሳፐ ዶምድ፥ ጎዳስ ፁሳ ያርሾ ኦꬅድ ሺሻናዉ ዳንዳኤቴስ። ");
INSERT INTO gofe_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","ሚዝ ዎይኮ ዶርሰ እ ማራራ እስ ጋላስ ሹኮፍተ። ");
INSERT INTO gofe_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","“ህንተ ጋላታ ያርሾ ጎዳስ ሺሽያ ዎደ ህንተ ያርሾይ ኤከታና መላ ያርሽተ። ");
INSERT INTO gofe_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","ያርሾይ ያርሸትዳ ጋላስ ሜተትድ ዉራናዉ ኮሼስ፤ እያፐ ዎንቶስ አሾፍተ። ታኒ ጎዳ። ");
INSERT INTO gofe_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“ታ ኪታ ናግተነ ፖልተ። ታኒ ጎዳ። ");
INSERT INTO gofe_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","ታ ጌሻ ሱንꬃ ቱንሶፕተ። ታ ጌሽ ግደይስ እስራኤለ አሳ ግዶን ኤረታናዉ በሴስ። ህንተና ጌሽያ ጎዳይ ታና። ");
INSERT INTO gofe_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","ህንተ ፆሰ ግዳናዉ ህንተና ግብፀ ቢታፈ ከስዳይ ታና። ታኒ ጎዳ።” ");
INSERT INTO gofe_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","ጎዳይ ሙሰኮ ሀይሳዳ ያግስ፤ ");
INSERT INTO gofe_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","እስራኤለ አሳስ ሀይሳዳ ያጋዳ ኦዳ፤ ጌሻ ሺቆ ያግድ አዋጅሸ፥ ህንተ ቦንቻናዉ በሲያ ኤረትዳ ጎዳ ባለት ሀይሳታ። ");
INSERT INTO gofe_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","ህንተ ኡሱፑን ጋላስ ኦሶ ኦꬄታ፥ ሽን ላፑንꬃ ጋላሳይ ህንተ ሸምፕያ ሳምባታ ጋላስ። ሄ ጋላስ ጌሻ ሺቆ ሺቅተ፤ አይ ኦሶካ ኦꬆፕተ፤ ህንተ ደእያ በሳ ኡባን ሄስ ጎዳስ ሳምባታ። ");
INSERT INTO gofe_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","ኤንታ ዎደን ዎደን ጌሻ ሺቆ ኦꬅድ ህንተ ቦንቻናዉ በሲያ ኤረትዳ ጎዳ ባለት ሀይሳታ፤ ");
INSERT INTO gofe_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","ኮይሮ አጌናን ታማነ ኦይዳንꬆ ጋላስ ሳእ ኦማርስያ ዎደ ጎዳ ፓስካይ ዶሜስ። ");
INSERT INTO gofe_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","ሄ አጌናን ታማነ እቻሻንꬆ ጋላሳን ጎዳስ ኡይꬃ ባኣለ ጋላሳይ ዶሜስ። ሄሳ ግሾ ላፑን ጋላሳታን እርሾይ ገልቦና ኡይꬅ ሚተ። ");
INSERT INTO gofe_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","ሄ ጋላሳታፐ ኮይሮ ጋላስ ጌሻ ሺቆ ሺቅተ፤ ኦሶ ኦꬆፕተ። ");
INSERT INTO gofe_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","ላፑን ጋላስ ኡባ ጎዳስ ፁሳ ያርሾ ያርሽተ፤ ላፑንꬃ ጋላሳን ጌሻ ሺቆ ሺቅተ፤ ኦሶ ኦꬆፕተ። ");
INSERT INTO gofe_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","ጎዳይ ሙሰኮ ሀይሳዳ ያግስ፤ ");
INSERT INTO gofe_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","እስራኤለ አሳስ ሀይሳዳ ያጋዳ ኦዳ፤ ታኒ ህንተዉ እምያ ቢታ ገልድ ህንተ ካꬅ ጫክያ ዎደ፥ ሄ ካꬃ ኮይሮ ምርቅያ ካህንያስ ኤህተ። ");
INSERT INTO gofe_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","ጎዳይ ህንተባ ኤካና መላ ሳምባታ ካልያ ዎንተꬃ ጋላስ ካህነይ ሄ ምርቅያ ጎዳ ስንꬃን ꬎቁ ኦꬅድ ዩሾ። ");
INSERT INTO gofe_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","ህንተ ምርቅያ ዩሽዳ ሄ ጋላስ ቦረይ ባይና እስ ላይꬃ ማራዘ ፁሳ ያርሾ ኦꬅድ ጎዳስ ሺሽተ። ");
INSERT INTO gofe_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","ሄ ያርሹዋራ እስፈ ሻማሆ ዛይተራ ሙኑቀትዳ ናምኡ ክሎ ግራመ ሎኦ ꬊለ ካꬃ ያርሾ ኦꬅድ ሺሽተ። ሄስ ጎዳስ ሳዎ ቶንኩ ግያ ፁሳ ያርሾ ግዳና፤ እያራ እስፈ እስ ልትሮ ግድያ ዎይነ ኡሽ ሺሽተ። ");
INSERT INTO gofe_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","ሀ ያርሹዋ ህንተ፥ ህንተ ፆሳስ ሺሽያ ጋላሳይ ጋካናዉ፥ ዋቻ ካꬃፈ ቃየ ዎይኮ ጫጫ ዎይኮ ኡክድ ሞፕተ። ሄስ ህንተ ደእያ በሳ ኡባን ያና የለተꬃስ መርና ዎጋ ግዶ። ");
INSERT INTO gofe_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","ህንተ ዩሾ ያርሾ ምርቅያ ኤህዳ ሳምባታ ዎንተꬃ ጋላሳፐ ዶምድ፥ ላፑን ሳምንታ ታይብተ። ");
INSERT INTO gofe_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","ላፑንꬃ ሳምባታ ካልያ ዎንተꬃ ጋላሳይ ጋካናዉ እሻታሙ ጋላስ ታይብተ፤ ዋቻ ካꬃፈ ያርሾ ጎዳስ ሺሽተ። ");
INSERT INTO gofe_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","ህንተ ደእያ በሳፈ ናምኡ ክሎ ግራመ ግድያ ሎኦ ꬊልያን እርሾ የግድ ኡክዳ ናምኡ ኡይꬅ ዩሾ ያርሾስ ኤክድ ዪተ። ሄስ ዋቻ ካꬃፈ ጎዳስ ሺቅያ ያርሾ ግዴስ። ");
INSERT INTO gofe_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","ሄ ኡይꬃራ እስፈ ቦረይ ባይና እስ ላይꬅ ግድዳ ላፑን ዶርሳ ኡርገታ፥ እስ ዎፋኖነ ናምኡ ማራዘታ ሺሽተ። ኤንታ ካꬃ ያርሾራነ ኡሻ ያርሾራ እስፈ ጎዳስ ፁገትያ ሳዎ ቶንኩ ግያ ያርሾ ኦꬅድ ያርሽተ። ");
INSERT INTO gofe_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","ቃስ እስ ኮለ ናጋራ ያርሾስ፥ እስ ላይꬅ ግድዳ ናምኡ ዶርሳ ኡርገታ እስፈተꬃ ያርሾስ ሺሽተ። ");
INSERT INTO gofe_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","ካህነይ ባይራ ካꬃ፥ ኡይꬃነ ናምኡ ዶርሳ ኡርገታ ዩሾ ያርሾ ኦꬅድ፥ ጎዳ ስንꬃን ꬎቁ ኦꬅድ ዩሾ። ሄሳት ጎዳስ ጌሽ፤ ካህነታስ ቃስ ግሾ። ");
INSERT INTO gofe_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","ሄ ጋላስ ህንተዉ ጌሻ ሺቆ ግዳና መላ አዋጅተ፤ ኦሶ ኦꬆፕተ። ሀይስ ህንተ ደእያ በሳ ኡባን ያና የለተꬃስ መርና ዎጋ ግዶ። ");
INSERT INTO gofe_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","ህንተ ቢታን ካፅዳ ካꬃ ጫክያ ዎደ ጋድያ ጋፃ ጋካናዉ ጫኮፍተ፤ ጫክሽን አትዳ ፖሽልያ ቆሮፕተ፤ ሄሳ ማንቆታስነ በተ አሳስ አጋግተ። ታኒ ጎዳ ህንተ ፆሳ። ");
INSERT INTO gofe_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","ጎዳይ ሙሰኮ ሀይሳዳ ያግስ፤ ");
INSERT INTO gofe_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","እስራኤለ አሳስ ሀይሳዳ ያጋዳ ኦዳ፤ ላፑንꬃ አጌናን ኮይሮ ጋላሳ ሸምፖ ጋላስ ኦꬅድ ቦንችተ፤ ሀሳይሶ ሞይዘ ፑንሸ ጌሻ ሺቆ ሺቅተ። ");
INSERT INTO gofe_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","ሄ ጋላስ ጎዳስ ፁሳ ያርሾ ሺሽተፐ አትሽን፥ ኦሶ ኦꬆፕተ። ");
INSERT INTO gofe_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","ጎዳይ ሙሰኮ ሀይሳዳ ያግስ፤ ");
INSERT INTO gofe_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","ላፑንꬃ አጌናን ታማንꬆ ጋላሳይ ናጋራ አቶተꬃ ጋላስ፤ ሄ ጋላስ ጌሻ ሺቆ ሺቅተ። ሄ ጋላስ ህንተና ካዉሽተ፤ ጎዳስ ፁሳ ያርሾ ሺሽተ። ");
INSERT INTO gofe_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","ሄ ጋላሳይ ጎዳ ህንተ ፆሳ ስንꬃን ህንተ ናጋራይ ቁሸታና መላ ህንተ ናጋራ አቶተꬃ ጋላስ ግድያ ግሾ ሄ ጋላሳን ኦሶ ኦꬆፕተ። ");
INSERT INTO gofe_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","ሄ ጋላስ ባናተꬃ ካዉሾና አስ ኦንካ ባ አሳ ግዶፈ ኩረቶ። ");
INSERT INTO gofe_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","ሄ ጋላስ ኦሶ ኦꬅያ ኡራ ኦናካ ታኒ እያ አሳ ግዶፈ ኩራና። ");
INSERT INTO gofe_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","ሄ ጋላስ ኦሶ ኦꬆፕተ። ሀይስ ህንተ ደእያ በሳ ኡባን ያና የለተꬃስ መርና ዎጋ ግዶ። ");
INSERT INTO gofe_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","ሄስ ህንተዉ ዱማትዳ ሸምፖ ጋላስ፤ ሄ ጋላስ ህንተናተꬃ ካዉሽተ። ሄ አጌናን ኡዱፉንꬆ ጋላስ ኦማርሳፈ ዶምድ፥ ታማንꬃ ጋላስ ኦማርስ ጋካናዉ ህንተ ሳምባታ ቦንችተ። ");
INSERT INTO gofe_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","ጎዳይ ሙሰኮ ሀይሳዳ ያግስ፤ ");
INSERT INTO gofe_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","እስራኤለ አሳስ ሀይሳዳ ያጋዳ ኦዳ፤ ላፑንꬃ አጌናን ታማነ እቻሻንꬆ ጋላሳፐ ዶምድ፥ ላፑን ጋላስ ጋካናዉ ጎዳስ ሻቃራ ባኣለ። ");
INSERT INTO gofe_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","ሄ ጋላሳታፐ ኮይሮ ጋላሳን ጌሻ ሺቆ ሺቅተ፤ ኦሶ ኦꬆፕተ። ");
INSERT INTO gofe_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","ላፑን ጋላስ ኡባን ጎዳስ ፁሳ ያርሾ ሺሽተ፤ ሆስፑንꬆ ጋላሳን ጌሻ ሺቆ ሺቅተ። ጎዳስ ፁሳ ካꬃ ያርሾ ሺሽተ። ሄ ጋላሳይ ባልያ ዉርሰꬃ ጋላስ ግድያ ግሾ፥ ኦሶ ኦꬆፕተ። ");
INSERT INTO gofe_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","ፁሳ ያርሾ፥ ካꬃ ያርሾ፥ ሀራ ያርሾታነ ኡሻ ያርሾ ኮሽያ ዎደን ጎዳስ ሺሻናዉ ጌሻ ሺቆ ኦꬅድ አዋጃና ጎዳ ባለት ሀይሳታ። ");
INSERT INTO gofe_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","ሀ ያርሾት ጎዳ ሳምባታታፐ፥ ጎዳስ እምያ እሞታታፐ፥ ቃንገꬃ እሞታታፐነ ዶሳን እምያ እሞታታፐ ዱማ። ");
INSERT INTO gofe_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","ህንተ ጋደን ካፅዳ ካꬃ ሺሽዳፐ ጉየ፥ ታማነ እቻሻንꬆ ጋላሳፐ ዶምድ ላፑን ጋላስ ጋካናዉ ጎዳ ባኣለ ቦንችተ። ኮይሮ ጋላሳይነ ሆስፑንꬆ ጋላሳይ ህንተዉ ዱማ ሸምፖ ጋላስ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","ኮይሮ ጋላስ ሎኦ ምꬃ አይፈ፥ ዛምባ ታሸ፥ ጭልኦ ምꬃ ሀይነ ሻፋ ጋፃን ድጭያ ምꬃ ሀይꬅ ኤክድ፥ ጎዳ ህንተ ፆሳ ስንꬃን ኡፋይትሸ ላፑን ጋላስ ባኣለ ቦንችተ። ");
INSERT INTO gofe_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","ሄ ባልያ ላይꬃን ላይꬃን ላፑንꬃ አጌናን ላፑን ጋላስ ጎዳ ቦንችተ። ሄስ ያና የለተꬃስ መርና ዎጋ ግዶ። ");
INSERT INTO gofe_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","ሄ ላፑን ጋላሳ ሻቃራን ደእተ፤ እስራኤለ አስ ግድዳ ኡባይ ሄ ሻቃራን ደኦ። ");
INSERT INTO gofe_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","ታኒ ህንተና ግብፀ ቢታፈ ከስዳ ዎደ ሻቃራን ዳና መላ ኦꬅዳይሳ ያና የለተꬃይ ኤራና። ታኒ ጎዳ ህንተ ፆሳ። ");
INSERT INTO gofe_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","ሄሳዳ ኦꬅድ፥ ሙሰይ ጎዳ ባለታ ቦንችያ ዎጋ እስራኤለ አሳስ ኦድስ። ");
INSERT INTO gofe_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","ጎዳይ ሙሰኮ ሀይሳዳ ያግስ፤ ");
INSERT INTO gofe_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","ፆምፐይ ቶኦና ኤፅሸ ዳና መላ እያዉ ኮሽያ ጉምእድ ፅልስዳ ሻማሆ ዛይተ ነዉ ኤሀና መላ እስራኤለ አሳ ኪታ። ");
INSERT INTO gofe_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","ጌሻ ዱንካንያ ግዶን ደእያ ማርካተꬃ ማጋራጁዋፈ ካረ ባጋራ ኦማርሳፈ ዎንታ ጋካናዉ አሮን ጎዳ ስንꬃን ሄ ፆምፕያ ኡባ ዎደ ኤꬆ። ያና የለተꬃ ኡባስ ሄስ መርና ዎጋ ግዶ። ");
INSERT INTO gofe_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","ፆምፐ ዎꬅያ ዋላህ ባይና ዎርቃ ኮጫ ቦላ ደእያ ፆምፐት ጎዳ ስንꬃን ኡባ ዎደ ኤፃና መላ አሮን ናጎ። ");
INSERT INTO gofe_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","ታማነ ናምኡ ክሎ ግራመ ግድያ ሎኦ ꬊለ ኤካዳ ታማነ ናምኡ ኡይꬅ ኡካ። ");
INSERT INTO gofe_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","ሄ ኡይꬃታ ኡሱፑና ኡሱፑና ናምኡ ማራን ጎዳ ስንꬃን ደእያ ዋላህ ባይና ዎርቃ ፃርጴዛ ቦላ ዎꬃ። ");
INSERT INTO gofe_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","ጎዳስ ፁገታናዉ ሺቅዳ ካꬃ ያርሾ ግደይሳ ኤርሳናዉ፥ ናምኡ ማራታ ምየን ጌሻ እፃነ ዎꬃ። ");
INSERT INTO gofe_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","ሀ ኡይꬃ ሳምባታን ሳምባታን ኡባ ዎደ አሮን እስራኤለ አሳ ግሾ መርና ጫቆ ኦꬅድ ጎዳ ስንꬃን ዎꬆ። ");
INSERT INTO gofe_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","ሄስ አሮናነ እያ አደ ናይታ ጋክያ ግሾ፤ ኤንቲ እያ ጌሻ በሳን ሞ። ሄስ ጎዳስ ፁሳ ያርሹዋፈ ዎጋዳ አሮናነ እያ ናይታ ጋክያ ግሾ ግድያ ግሾ ኡባፈ ጌሽ። ");
INSERT INTO gofe_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","ባ አየን እስራኤለ፥ ባ አዋን ግብፀ አስ ግድዳ እስ ኡራይ ደኤስ። እስ ጋላስ እ ሀራ እስራኤለ አሳራ ሄራን ዋትስ። ");
INSERT INTO gofe_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","ባ አየን እስራኤለ ግድዳ ኡራይ ጎዳ ሱንꬃ ጫይስ፤ ያትን እያ አሳይ ሙሰኮ ኤህዶሶና። ሄ ኡራ አይያ ዳነ ኮቸ ግድዳ ደብራ ናአ። እ ሱንꬃይ ሳሎምቶ። ");
INSERT INTO gofe_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","ሄ ኡራ ዋታነኮ ጎዳ ሸነይ ቆንጫና ጋካናዉ እያ ናግስዶሶና። ");
INSERT INTO gofe_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","ጎዳይ ሙሰ ሀይሳዳ ያግስ፤ ");
INSERT INTO gofe_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","ሄ ጫይዳ ኡራ ጉታፐ ጋፃ ከሳ። እ ጫይሽን ስእዳ አሳ ኡባይ ባንታ ኩሽያ እያ ሁጵያ ቦላ ዎꬆ፤ እስራኤለ ማባራ ኡባይ እያ ሹቻ ጫድድ ዎꬎ። ");
INSERT INTO gofe_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","እስራኤለ አሳስ ሀይሳዳ ያጋዳ ኦዳ፤ እስ አስ ባ ፆሳ ጫይኮ፥ እ ባ ናጋራን ኦይሸታና። ");
INSERT INTO gofe_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","ጎዳ ሱንꬃ ጫይያ አስ ሀይቆ፤ እስራኤለ ማባራ ኡባይ እያ ሹቻን ጫዶ። በተ አስ ዎይኮ ጋደ አስ ጎዳ ሱንꬃ ጫይኮ ሀይቆ። ");
INSERT INTO gofe_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","አሰ ዎꬍዳ አስ ሀይቆ። ");
INSERT INTO gofe_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","አሳ መሄ ዎꬍዳ አስ ኦንካ ባ ዎꬍዳ መህያ ግሾ ፓፃ መህያ ቃንፆ። ");
INSERT INTO gofe_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","እስ አስ ባ ሾሩዋ ቆህኮ፥ እ ኦꬅዳይሳዳ እያ ቦላ ኦሰቶ። ");
INSERT INTO gofe_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","መንꬅኮ መኦ፤ አይፈ ግሾ አይፈ፤ አቻ ግሾ አቸ። አሳ ቦላ ቆሆ ጋꬅዳ ኦንካ እ ጋꬅዳ ቆሁዋዳ እያ ቦላ ጋኮ። ");
INSERT INTO gofe_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","መሄ ዎꬍዳ አስ ሄ መህያ ጋትያ ቃንፆ፤ ሽን አሰ ዎꬍዳ አስ ሀይቆ። ");
INSERT INTO gofe_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","በተ አሳስነ እስራኤለ አሳስ ህገይ እስኖ ግዶ። ታኒ ጎዳ ህንተ ፆሳ። ");
INSERT INTO gofe_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","ሙሰይ ሄሳ እስራኤለ አሳስ ኦድስ፤ ኤንቲ ሄ ጫይዳ ኡራ ጉታፐ ጋፃ ከስድ፥ ሹቻን ጫድድ ዎꬍዶሶና። ያትድ እስራኤለ አሳይ ጎዳይ ሙሰ ኪትዳይሳዳ ኦꬅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","ሲና ዙማ ቦላ ጎዳይ ሙሰኮ ሀይሳዳ ያግስ። ");
INSERT INTO gofe_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","ኔኒ እስራኤለ አሳስ ሀይሳዳ ያጋዳ ኦዳ፤ ታኒ ህንተዉ እምያ ቢታ ህንተ ገልያ ዎደ ቢትያ ባ ሁጰን ጎዳ ሳምባታ ቦንቾ። ");
INSERT INTO gofe_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","ኡሱፑን ላይꬅ ኩመꬅ ህንተ ጋደን ዘርተ፤ ኡሱፑን ላይꬅ ኩመꬅ ህንተ ዎይነ ፄራ ፁንቅተ፤ እያ አይፍያ ማፅተ። ");
INSERT INTO gofe_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","ሽን ላፑንꬃ ላይꬃይ ቢታስ ሸምፖ ሳምባታ፤ ሄስ ጎዳ ሳምባታ። ሄ ላፑንꬃ ላይꬃን ጋደን ዘሮፕተ፤ ህንተ ዎይነ ፄራ ፁንቆፍተ። ");
INSERT INTO gofe_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","ህንተ ቢታን አሰቦ ካፅዳባ ሺሾፕተ፤ ዎይነ ፄራ ፁንቆፍተ፤ አይፍያ ማፆፕተ። ሄ ላይꬃይ ቢታስ ኩመꬅ ሸምፖ ላይꬅ ግዶ። ");
INSERT INTO gofe_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","ሄ ሳምባታ ላይꬃን ቢታይ ኦሰቶና ደእሽን ካፅያ ካꬃ ኔኒ፥ ነ አደ አይለይ፥ ነ ማጫ አይለይ፥ ነ ሶን ኡነ ኦይ፥ ጉꬃ ዎደስ ደእያ በተ አስ ማናዉ ዳንዳኤስ። ");
INSERT INTO gofe_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","ሄሳዳካ፥ ነ መህያስነ ነ ቢታን ደእያ ዶአታስ ግድያ ካꬅ ደማና፤ ቢታን ካፅያባ ኡባይ ሜተቶ። ");
INSERT INTO gofe_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","ላይꬃታስ ግዶን ደእያ ላፑን ሳምባታታ ታይባ፤ ላፑን ሳምባታታስ ላይꬃ ታይቦይ ላፑን ቶሆ ላፑና፤ ሄስካ ኦይታማነ ኡዱፉን ላይꬅ። ");
INSERT INTO gofe_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","ላፑንꬃ አጌናን፥ ታማንꬆ ጋላስ ቦንቸትያ ናጋራ አቶተꬃ ጋላሳን ሞይዘ ፑንያ አስ ቢታ ኡባ ኪታ። ");
INSERT INTO gofe_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","እሻታማንꬆ ላይꬃ ዱማይድ፥ ሄ ቢታን ደእያ ኡባስ ላአተꬅ አዋጅተ። ሄስ ህንተዉ እሻታማንꬆ ላይꬃ ባኣለ። ሄ ዎደ ህንተ ኡባይ ህንተ ጋድያኮነ ህንተ ሶ አሳኮ ስምተ። ");
INSERT INTO gofe_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","ሄ ላይꬃይ ህንተዉ እሻታማንꬆ ላይꬃ ባኣለ። ሄ ላይꬃን ዘሮፕተ፤ አሰቦ ካፅዳባ ጫኮፍተ፤ ፄራ ፁንቆና አይፍዳ ዎይነ አይፍያ ማፆፕተ። ");
INSERT INTO gofe_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","ሄስ እሻታማንꬆ ላይꬃ ባኣለ ግድያ ግሾ እ ህንተዉ ጌሽ፤ ጎዮና ጮ ደንባን ካፅዳባ ሚተ። ");
INSERT INTO gofe_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","ሄ እሻታማንꬆ ላይꬃ ባኣለ ዎደ አስ ኡባይ ባ ጋደ ስሞ። ");
INSERT INTO gofe_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","ህንተ፥ ህንተ ሾሩዋፐ ጋደ ሻምኮ ዎይኮ እያዉ ባይዝኮ እሶይ እሱዋ ጭሞፍተ። ");
INSERT INTO gofe_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","ህንተ እሻታማንꬆ ላይꬃ ባልያፐ ጉየ ደእያ ላይꬃታ ታይቡዋን ህንተ ሾሩዋፐ ሻምተ። ህንተ ሾሮይ ጋደይ ካꬅ እማናዉ ደእያ ላይꬃታ ታይቡዋዳ ባይዞ። ");
INSERT INTO gofe_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","ላይꬃ ታይቦይ ዳሮ ግድኮ ጋተይ ዳሬስ፤ ላይꬃታ ታይቦይ ጉፅኮ ጋተይ ጉፄስ። ጋድያ ሎኦተꬃዳ ህንተ ሾሮይ ህንተዉ ባይዜስ። ");
INSERT INTO gofe_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","ህንተ እሶይ እሱዋ ጭሞፍተ፤ ሽን ህንተ፥ ህንተ ፆሳ ያይተ። ታኒ ጎዳ፥ ህንተ ፆሳ። ");
INSERT INTO gofe_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","ህንተ ሀ ቢታን ሳሮ ዳና መላ ታ ኪታ ፖልተ፤ ታ ህግያ ናግተ። ");
INSERT INTO gofe_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","ቢታይ ባ አይፍያ ህንተዉ እምን ህንተ ካላና ጋካናዉ ማና፤ ሄ ቢታን ህንተ ሳሮ ዳና። ");
INSERT INTO gofe_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","ሄኮ፥ ኑኒ ዘሮና አግድ፥ ቃስ ካꬅ ሺሾና አግድ፥ ላፑንꬃ ላይꬃን አይ ማኔ? ጊኮ፥ ");
INSERT INTO gofe_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","ታኒ ኡሱፑንꬆ ላይꬃን ታ አንጁዋ ህንተዉ ኪታና፤ ቢታይ ሄꬑ ላይꬃስ ግድያ ካꬅ እማና። ");
INSERT INTO gofe_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","ሆስፑንꬃ ላይꬃን ህንተ፥ ህንተ ቢታን ዘርያ ዎደ ሻቻ ካꬃ ማና። ህንተ ዘርያ ካꬃ ኡዱፉንꬆ ላይꬃን ሺሻና ጋካናዉ ሻቻ ካꬃ ማና። ");
INSERT INTO gofe_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","ቢታይ ታባ ግድያ ግሾነ ህንተ ሄ ቢታን እማነ በተ ግድድ ደእያ ግሾ ቢታ ስሞናዳ ኦꬅድ ባይዞፕተ። ");
INSERT INTO gofe_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","ህንተ ኦይክዳ ጋድያ ጎዳት፥ ዎዛና ማታይ እስራኤለ ኡባን ናገታናዉ በሴስ። ");
INSERT INTO gofe_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","እስ እስራኤለ አስ ማንቅድ ባ ጋድያፐ ባይዝኮ፥ እያ ማታ ዳቦይ ሄ ጋድያ እያዉ ዎዞ። ");
INSERT INTO gofe_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","እያው ሄ ጋድያ ዎዝያ ዳቦይ ꬋይኮ፥ እ ዎንቶ ዱረትድ ዎዝያ ሚሸ ደምኮ ዛሪድ ዎዛናዉ ዳንዳኤስ። ");
INSERT INTO gofe_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","ባ ባይዝዳ ዎደፐ ዶምድ ደእያ ላይꬃ ታይብድ፥ አትዳ ላይꬃ ሚሽያ ሻምዳይሳስ ዛሮ፤ ያትድ እ ባ ጋድያ ስሞ። ");
INSERT INTO gofe_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","ሽን እያዉ ሄ ጋድያ ዎዛናዉ ግድያ ሚሸይ ꬋይኮ፥ እሻታማንꬆ ላይꬃ ባለይ ጋካናዉ ጋደይ ሻምዳ ኡራ ኩሸን ጋምኦ። እሻታማንꬆ ላይꬃ ባኣለ ዎደ እያ ጋደይ እያዉ ስሞ። ");
INSERT INTO gofe_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","እስ አስ ግምበትዳ ካታማ ግዶን ደእያ ኬ ባይዝኮ፥ እ ባይዝዳ ዎድያፐ ብድ እስ ላይꬅ ኩማና ጋካናዉ ዛሪድ ዎዛናዉ ዳንዳኤስ። ");
INSERT INTO gofe_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","ሽን እስ ላይꬃ ግዶን ዎዛናዉ ዳንዳኤቶና እፅኮ፥ ሄ ግምበትዳ ካታማ ግዶን ደእያ ኬꬃይ ሻምዳ ኡራስነ እያ ኮቻስ ግዴስ። እሻታማንꬆ ላይꬃ ባኣለ ዎደ ስመና። ");
INSERT INTO gofe_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","ሽን ግምበትቦና ሄራን ደእያ ኬꬃት ጋደ መላ ዎዘቶሶና። እሻታማንꬆ ላይꬃ ባኣለ ዎደ ባይዝዳይሳስ ስሞሶና። ");
INSERT INTO gofe_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","ግዶሽን፥ ሌወት ካታማታን ደእያ ባንታ ኬꬃ ባንታ ኮይዳ ዎደ ዎዛናዉ ዳንዳኦሶና። ");
INSERT INTO gofe_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","ሌወታፐ እስ አስ ኤንታ ካታማ ግዶን ደእያ ኬꬃ ባይዝድ ዎዛናዉ ፆነትኮ፥ ሄ ኤንታ ካታማ ግዶን ደእያ ኬꬃይ እሻታማንꬆ ላይꬃ ባልያ ዎደ ስሜስ። ሌወታ ካታማ ግዶን ደእያ ኬꬃይ እስራኤለ አሳ ግዶን ሌወታሳ። ");
INSERT INTO gofe_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","ሽን ኤንታ ካታማ ዩሹዋን ደእያ ሄንꬃ ቢታይ ኤንታዉ መርና አቆ ግድያ ግሾ ባይዘተና። ");
INSERT INTO gofe_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","እስ እስራኤለ አስ ማንቅድ ባና አይሳናዉ ፆነትኮ፥ እማꬃዳ ዎይኮ በተ አሳዳ እ ኔራ ዳና መላ ማዳ። ");
INSERT INTO gofe_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","እያ ኔራ ዎꬃናዉ እያፐ የሎ ኤኮፋ ዎይኮ ዎ ሞፓ። ሽን ነ ፆሳ ያያ። ");
INSERT INTO gofe_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","ነ ብራ እያዉ የሎራ ታልኦፋ፤ ነ ካꬃ እያዉ ዎራ ባይዞፓ። ");
INSERT INTO gofe_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","ህንተዉ ካናነ ቢታ እማናዉነ ህንተ ፆሳ ግዳናዉ፥ ህንተና ግብፀ ቢታፈ ከስዳ፥ ታኒ፥ ጎዳ ህንተ ፆሳ። ");
INSERT INTO gofe_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","እስ እስራኤለ አስ ማንቅድ፥ ባና ነዉ አይለ ኦꬅድ ባይዝኮ እያ አይለዳ ኦስሶፓ። ");
INSERT INTO gofe_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","እ በተ አሳዳ ኡነ ኦꬅድ እሻታማንꬆ ላይꬃ ባለይ ጋካናዉ ኔራ ደኦ። ");
INSERT INTO gofe_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","ሄ ዎደ እ ባ ናይታራ እስፈ ነ ሶፐ ከይድ ባ ሶ አሳኮ ቦ፤ ባ አዋ ጋደ ስሞ። ");
INSERT INTO gofe_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","እስራኤለ አሳይ ታኒ ግብፀ ቢታፈ ከስዳ ታ አይለ ግድያ ግሾ ኤንቲ አይለተꬃስ ባይዘቶፎ። ");
INSERT INTO gofe_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","ኔኒ ኤንታ ኡንኤꬃዳ ሃሮፓ፤ ሽን ኔኒ፥ ነ ፆሳ ያያ። ");
INSERT INTO gofe_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","ነዉ አደነ ማጫ አይለይ ዳና መላ ኮይኮ፥ ነ ዩሹዋን ደእያ ካዎተꬃታፐ ሻማ። ");
INSERT INTO gofe_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","ህንተ ቢታን ደእያ በተ አሳ ናይታ ሻማናዉ ዳንዳኤታ። ህንተ ቢታን ደእሸ የለትዳ ኤንታ ሶ አሳፐ ህንተዉ ሻሎ ኦꬃናዉ ዳንዳኤታ። ");
INSERT INTO gofe_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","ህንተፈ ጉየ፥ ህንተ ናይት ኤንታ መርናዉ ላታና መላ ህንተ ናይታስ እምተ። ህንተ ኤንታ ኡባ ዎደ ህንተ አይለ ኦꬃናዉ ዳንዳኤታ፤ ሽን እስራኤለ አስ ኡንኤꬅድ ሃሮፕተ። ");
INSERT INTO gofe_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","ነ ማታን ደእያ እማꬅ ዎይኮ በተ አስ ዱረትኮ፥ እያ ማታን ደእያ እስራኤለ ኡራይ ማንቅድ፥ ነ ማታን ደእያ እማꬃስ ዎይኮ በተ ኡራስ ዎይኮ እማꬃ አድያ ኮቻፈ እሱዋስ ባና ባይዝኮ፥ ");
INSERT INTO gofe_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","እ ባይዘትድ ስምን፥ እያ ዎዛናዉ ዳንዳኤቴስ፤ እያ ዳቦታፐ እሶይ እያ ዎዞ። ");
INSERT INTO gofe_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","እያ አዋ እሻይ፥ ዎይኮ እያ አዋ እሻ ናአይ ዎይኮ እያ ያራፐ ማታ ዳቦይ እያ ዎዞ፤ ዎይኮ እ ባ ሁጰን ዱረትድ ባና ዎዞ። ");
INSERT INTO gofe_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","እ ባና ሻምዳ ኡራራ ግድድ፥ እ ባና ባይዝዳ ላይꬃፈ ዶምድ እሻታማንꬆ ላይꬃ ባለይ ጋካናዉ ደእያ ላይꬃታ ታይቦ። እያ ላአተꬃ ጋተይ፥ ሄ ላይꬃ ታይቡዋ ኬና ግዶ። እ ባና ሻምዳይሳራ ጋምእዳ ዎድያ ጋተይ እስ አስ ኡነ ኦꬅድ ደምያ ሚሽያራ ግና ግዶ። ");
INSERT INTO gofe_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","እሻታማንꬆ ላይꬃ ባለይ ጋካናዉ ዳሮ ላይꬅ አትዳባ ግድኮ፥ ባ ባይዘትዳ ጋትያፐ ሄ ላይꬃ ታይቦን ባና ዎዝያ ጋትያ ቃንፆ። ");
INSERT INTO gofe_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","እሻታማንꬆ ላይꬃ ባለይ ጋካናዉ አትዳ ላይꬃይ ጉꬃ ግድኮ፥ ባና ሻምዳይሳራ እስፈ ታይብድ፥ ሄ ላይꬃ ታይቦን ባና ዎዝያ ጋትያ ቃንፆ። ");
INSERT INTO gofe_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","እ ላይꬃን ላይꬃን ኡነ ኦꬅያ አሳዳ ባና ሻምዳይሳራ ደኦ፤ እያ ጎዳይ እያ ኡንኤꬅድ ሃራናዉ በሰና። ");
INSERT INTO gofe_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","ሽን እ ሄሳ መላ ሀኖን ዎዘቶና እፅኮ፥ እሻታማንꬆ ላይꬃ ባለይ ጋክያ ዎደ እነ እያ ናይት አይለተꬃፈ ከዮ። ");
INSERT INTO gofe_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","እስራኤለ አሳይ፥ ታ ግብፀ ቢታፈ ከስዳ ታ አይለ። ታኒ፥ ጎዳ ህንተ ፆሳ። ");
INSERT INTO gofe_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","ጎይናናዉ ኤቃታ ኦꬆፍተ፤ ቃስ ሀዉልተ ዎይኮ ኤቃ ቱሱ ዎይኮ ሹቻ ኤቃ ኤሶፍተ። ታኒ ጎዳ፥ ህንተ ፆሳ። ");
INSERT INTO gofe_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","ታ ሳምባታታ ናግተ፤ ታ ጎይኖ በሳ ቦንችተ። ታኒ ጎዳ። ");
INSERT INTO gofe_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","ህንተ ታ ህግያ ካልኮነ ታ ኪታ ናግኮ፥ ");
INSERT INTO gofe_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","ታኒ ህንተዉ እራ ዎደን ዎደን እማና፤ ቢታይ ካꬃ ዳርስድ ዶልሳና፤ ጋደን ደእያ ምꬃይ አይፋና። ");
INSERT INTO gofe_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","ህንተ ካꬃ ሺሽድ ኦንጎና ደእሽን ዎይነ ማፅያ ዎደይ ጋካና፤ ዎይንያ ማፅድ ዉርሶና ካꬃ ዘርያ ዎደይ ጋካና። ህንተ ካላና ጋካናዉ ካꬅ ማና፤ ህንተ፥ ህንተ ቢታን ሳሮ ዳና። ");
INSERT INTO gofe_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","ታኒ ቢታስ ሳሮተꬅ እማና፤ ኦንካ ህንተና ያሽሶና ህንተ ዝንአና። ኢታ ዶአታ ታኒ ቢታፈ ꬋይሳና፤ ህንተ ቢታን ናምአንꬆ ኦል ደንደና። ");
INSERT INTO gofe_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","ህንተ ሞርከታ ህንተ የደꬃና፤ ኤንቲ ህንተ ስንꬃን ማሻን ሀይቃና። ");
INSERT INTO gofe_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","ህንተፈ እቻሻይ ፄታ የደꬃና፤ ቃስ ፄታይ ታሙ ሙኩላ የደꬃና። ህንተ ሞርከት ህንተ ስንꬃን ማሻን ሀይቃና። ");
INSERT INTO gofe_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","ታኒ ህንተና ማሮታ አይፈን በአና፤ ህንተና አይፍሳና፤ ህንተና ዳርሳና፤ ታኒ ታ ጫቁዋ ህንተራ ምንꬃና። ");
INSERT INTO gofe_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","ህንተ ሻቻ ካꬃ ምድ ዉርሶና ደእሸ፥ ዋቻ ካꬃ ዎꬃናዉ፥ ሻቻ ካꬃ ድግድ በሰ ጊግሳና። ");
INSERT INTO gofe_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","ታኒ ታ ደእያ በሳ ህንተ ግዶን ኦꬃና፤ ታኒ ህንተና እፅከ። ");
INSERT INTO gofe_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","ታኒ ህንተ ግዶን ሄመታና፤ ህንተ ፆሳ ግዳና፤ ህንተ ታ አሰ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","ህንተ ግብፀታስ አይለ ግዶና መላ ሄ ቢታፈ ህንተና ከስዳ ጎዳይ፥ ታኒ ህንተ ፆሳ። ታኒ ህንተ አይለተꬃ ቃምባራ መንꬃስ፤ ህንተ ꬎቁ ግድ ሄመታና መላ ኦꬃስ። ");
INSERT INTO gofe_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","ሽን ህንተ ታና ስኦና እፅኮነ፥ ታ ኪታ ፖሎና እፅኮ፥ ");
INSERT INTO gofe_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","ታ ዎጋ ካꬍኮ፥ ታ ኪታ ኡባ ፖሎና እፅድ ታ ጫቁዋ መንꬃናዉ ታ ህግያ ቦርኮ፥ ");
INSERT INTO gofe_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","ሄ ዎደ ታኒ ህንተ ቦላ ሀይሳ ኦꬃና፤ ህንተ አኬኮና ደእሽን ያሽ፥ ግልቃተꬅ፥ ህንተ አይፍያ ተልጁምስያነ ህንተ አሳተꬃ መልስያ ምሻ ሀርገ ህንተ ቦላ የዳና። ህንተ ሞርከት ማና ግሾ ህንተ ዘርያ ዘረꬃይ መላ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","ታ ህንተና ኢታ አይፈን ፄላና፤ ህንተ ሞርከታ ስንꬃን ህንተ ኩንዳና፤ ህንተና እፀይሳት ሃራና፤ ኦንካ የደꬆና ህንተ ባቃታና። ");
INSERT INTO gofe_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","ሄሳ ኡባ ኦꬅንካ ህንተ ታና ስኦና እፅኮ፥ ታኒ ህንተ ናጋራ ግሾ ህንተ ሴራ ላፑን ዳኮ ኦꬃና። ");
INSERT INTO gofe_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","ታ ህንተ ኦቶሩዋ መንꬃና፤ ሳሉዋ ብራታ፤ ሳአ ናሰ ብራታ ኦꬃና። ");
INSERT INTO gofe_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","ህንተ ቢታይ ካꬅ፥ ህንተ ምꬃይ አይፈ እሞና ግሾ ህንተ ዎልቃይ ጮ በሳን ዉራና። ");
INSERT INTO gofe_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","ህንተ ታዉ እፃስ ጊኮነ ታና ስኦና እፅኮ፥ ህንተ ናጋራ መላ ላፑን ዳኮ ጋዶ ታኒ ህንተ ቦላ ኤሀና። ");
INSERT INTO gofe_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","ታኒ ህንተ ቦላ ባዞ ዶአታ የዳና፤ ኤንቲ ህንተ ናይታ ቦንቃና። ህንተ መሄታ ꬋይሳና፤ ህንተ ታይቡዋ ጉꬃና፤ ሄሳ ጋሶን ህንተ ሄመትያ ኦገይ ሁሳታና። ");
INSERT INTO gofe_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","ሄ ሴራ ኡባን ህንተ ታኮ ስሞና እፅኮ፥ ");
INSERT INTO gofe_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","ሄ ዎደ ታካ ህንተዉ እፃስ ጋና። ህንተ ናጋራ ግሾ ታኒ ታ ሁጰን ህንተና ላፑን ዳኮ ሴራና። ");
INSERT INTO gofe_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","ታ ጫቁዋ ህንተ መንꬅዳ ግሾ፥ ኩሸ ዛራናዉ ማሻ ህንተ ቦላ ኤሀና። ህንተ፥ ህንተ ካታማታን ሺቅኮካ፥ ታኒ ህንተ ቦላ ጋዶ የዳና። ህንተ፥ ህንተ ሞርከታ ኩሸን አꬍድ እመታና። ");
INSERT INTO gofe_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","ህንተ ካꬃ ታኒ ꬋይስያ ዎደ ታሙ ማጫሳት እስ በሸን ኡይꬁ ኡካና፤ ሄ ኡይꬃ ምዛነን ሻክድ ኤካና፤ ህንተ ሄሳ ማና ሽን ካለከታ። ");
INSERT INTO gofe_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","ሀ ኡባን ህንተ ታና ስኦና እፅኮነ ህንተ ኢታተꬃን ጉጅድ ቢኮ፥ ");
INSERT INTO gofe_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","ታ ህንተ ቦላ ሀንቆን ደንዳና። ህንተ ናጋራ ግሾ ታኒ ህንተና ላፑን ዳኮ ሴራና። ");
INSERT INTO gofe_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","ህንተ፥ ህንተ አደ ናይታነ ህንተ ማጫ ናይታ አሹዋ ማና። ");
INSERT INTO gofe_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","ታኒ፥ ህንተ ꬎቃ ጎይኖ በሳታ ꬋይሳና፤ ህንተ እፃነ ያርሽያ በሳ ላላና። ታኒ ህንተ አሀ ህንተ ኤቃታ አሀ ቦላ ሆላና፤ ታኒ ህንተና ፖሎ እፃና። ");
INSERT INTO gofe_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","ታኒ ህንተ ካታማታ ባይሳ ኦꬃና፤ ህንተ ጎይኖ በሳታ ꬋይሳና፤ ህንተ ሳውያ ያርሹዋ ስንግከ። ");
INSERT INTO gofe_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","ታኒ ህንተ ቢታ ꬋይሳና፤ ሄ ቢታን ደእያ ሞርከት ሄሳን ማላለታና። ");
INSERT INTO gofe_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","ታኒ ህንተና ካዎተꬃታ ግዶን ላላና፤ ህንተ ቦላ ታ ማሻ ሾዳና። ህንተ ቢታይ ባይሳታና፤ ህንተ ካታማት ላለታና። ");
INSERT INTO gofe_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","ህንተ ሞርከታ ቢታን ደእያ ዎደ፥ ባይሳ ጊግድ ደእያ ህንተ ቢታይ ባ ሳምባታ ቦንቻና። ሄ ዎደ ህንተ ቢታይ ሸምፓናነ ባ ሳምባታ ቦንችሸ ኡፋይታና። ");
INSERT INTO gofe_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","ህንተ ሄ ቢታን ደእያ ዎደ ሳምባታታን ደምቦና ሸምፑዋ ሀእ ባይሳ ግድዳ ዎደ ደማና። ");
INSERT INTO gofe_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","ህንተ ድኤትድ ብያ ዎደ ጉየ አትዳ አሳታ ዎዛናን ያሽ የዳና፤ ጫርኮይ ቃꬅያ ቦንጮ ግርሳይ ኤንታ ዳጋንꬃና፤ ኤንቲ ማሻፈ ባቃትያ መላ ባቃታና፤ ኤንታ ኦንካ የደꬆና ኩንዳና። ");
INSERT INTO gofe_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","ኦንካ የደꬆና ኦላፐ ባቃትያዳ ባቃትሸ፥ እሶይ እሱዋራ ꬉበትድ ኩንዳና። ህንተ፥ ህንተ ሞርከታ ስንꬃን ኤቃናዉ ህንተዉ ዎልቅ ꬋያና። ");
INSERT INTO gofe_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","ካዎተꬃታ ግዶን ህንተ ꬋያና፤ ህንተ ሞርከታ ቢታን ህንተ ምተትድ ꬋያና። ");
INSERT INTO gofe_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","ሞርከታ ቢታን አትዳይሳት ባንታ ናጋራ ግሾነ ባንታ አዋታ ናጋራ ግሾ ግልቅድ ꬋያና። ");
INSERT INTO gofe_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","ሽን ኤንቲ ባንታ ናጋራነ ታ ቦላ ማካልድ ስኦና እፅዳ ባንታ አዋታ ናጋራ ፓፅኮ፥ ");
INSERT INTO gofe_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","ታ ኤንታ እፃናዳነ ኤንታ ሞርከታ ቢታ የደꬃናዳ ኦꬅዳ ባንታ ናጋራ አግኮነ ኤንታ ኪተቶና ዎዛናይ ስምኮ፥ ");
INSERT INTO gofe_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","ታኒ ያይቆባራ፥ ይሳቃራነ አብራሃመራ ጫቅዳ ጫቁዋ ሀሳያና፤ ኤንታ ቢታ ዛራ ቆፓና። ");
INSERT INTO gofe_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","ኤንታ ቢታይ ባይሳ አታና፤ ሄ ኤንቲ ꬋይን ባይሳ ግድድ ደእዳ ዎደን ቢታይ ሳምባታ ቦንችሸ ኡፋይታና። ኤንቲ ታ ኪታ ካꬍዳ ግሾነ ታ ዎጋ ለቅዳ ግሾ ባንታ ናጋራ ሴራ ኤካና። ");
INSERT INTO gofe_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","ግዶሽን፥ ኤንቲ ባንታ ሞርከታ ቢታን ደእዳ ዎደ ኩመꬅ ꬋያና ጋካናዉ ኤንታራ ደእያ ታ ጫቁዋ መንꬅከ፤ ኤንታ የግከ። ታኒ፥ ጎዳ ኤንታ ፆሳ። ");
INSERT INTO gofe_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","ታኒ ኤንታ ፆሳ ግዳናዉ፥ ካዎተꬃት ፄልሽን፥ ግብፀ ቢታፈ ከስዳ ኤንታ ማይዛታራ ታኒ ጫቅዳ ጫቁዋ ኤንታ ግሾ ሀሳያና። ታኒ ጎዳ። ");
INSERT INTO gofe_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","ጎዳይ ሲና ዙማ ቦላ ሙሰ ባጋራ ባፐነ እስራኤለ አሳፐ ግዶን ዎꬅዳ ዎጋት ኪታትነ ህገት ሀይሳታ። ");
INSERT INTO gofe_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","ጎዳይ ሙሰኮ ሀይሳዳ ያግስ። ");
INSERT INTO gofe_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","እስራኤለ አሳስ ሀይሳዳ ያጋዳ ኦዳ፤ እስ አስ ጎዳስ አሰ እማናዉ ቃንግኮ፥ ዎዞ ጋትያ ነ ጋማትዳይሳ መላ ሄ ኡራ ግሾ ሚሸ ቃንፆ። ");
INSERT INTO gofe_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","ላታሙ ላይꬃፈ ብድ ኡሱፑን ታሙ ላይꬅ ጋካናዉ ደእያ አደ ግድኮ ጌሻ ዱንካነን ኤረትዳ ምዛነን ኡሱፑን ፄቱ ብራ ሳንትመ ቃንፆ። ");
INSERT INTO gofe_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","ማጫ ግድኮ ሀስታሙ ብራ ሳንትመ ቃንፆ። ");
INSERT INTO gofe_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","እቻሹ ላይꬃፈ ብድ ላታሙ ላይꬅ ጋካናዉ ደእያ አደ ግድኮ ላታሙ ብራ ሳንትመ ቃንፆ፤ ቃስ ማጫስ ግድኮ ታሙ ብራ ሳንትመ ቃንፆ። ");
INSERT INTO gofe_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","እስ አጌናፐ ብድ እቻሹ ላይꬅ ጋካናዉ ደእያ አደ ግድኮ እቻሹ ብራ ሳንትመ ቃንፆ፤ ቃስ ማጫስ ግድኮ ሄꬑ ብራ ሳንትመ ቃንፆ። ");
INSERT INTO gofe_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","ላይꬅ ኡሱፑን ታማነ እያፐ ቦላ ግድዳ አደ ግድኮ፥ ታማነ እቻሹ ብራ ሳንትመ፤ ቃስ ማጫስ ግድኮ ታሙ ብራ ሳንትመ ቃንፆ። ");
INSERT INTO gofe_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","ቃንግዳ ኡራይ ኔኒ ጋማትዳይሳ ቃንፃናዉ ዳንዳኦና ማንቆ ግድኮ፥ እ ባ ቃንገꬃ ጋꬃናዉ እምዳ ኡራ ኤህድ ካህንያ ስንꬃን ኤሶ፤ ቃንገትዳ ኡራይ ቃንፃናዉ ዳንዳኤይሳ ኬና ቆፕድ ካህነይ ጋማቶ። ");
INSERT INTO gofe_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","እስ አስ ጎዳስ ያርሾ ኦꬅድ እማናዉ ቃንግዳይ መሄ ግድኮ ጎዳስ እመትያ መሄ ኡባይ ጌሽ ግዴስ። ");
INSERT INTO gofe_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","ሄ መህያ ግሾ ሀራ መሄ እሞፎ፤ ዎይኮ እያ ሀራ መሄራ ላሞፎ። ሎኡዋ ኢታራ ዎይኮ ኢታ ሎኡዋራ ላሞፎ፤ ሽን እ ላምኮ፥ ኮይሮ መሄይነ ላመ እምዳ መሄይ ናምአይካ ጌሽ ግዶ። ");
INSERT INTO gofe_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","እስ አስ ጎዳስ ያርሾ ኦꬅድ እማናዉ ገፕዳ መሄይ ጌሽ ግዶና እፅኮ፥ ሄ ኡራይ ሄ መህያ ካህንያ ስን ኤሆ። ");
INSERT INTO gofe_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","ሎኦ ግድን፥ ኢታ ግድን ካህነይ ሄ መህያ ጋማቶ፤ ካህነይ ጋማትዳይስ እያዉ ጋተ ግዶ። ");
INSERT INTO gofe_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","ሽን ሄ መህያ ጎዳይ ዛሪድ ዎዛናዉ ኮይኮ፥ ሄ መህያ ጋትያ ቦላ ፄታፐ ላታሙ ኩሸ ጉጆ። ");
INSERT INTO gofe_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","እስ አስ ባ ኬꬃ ጌሽ ኦꬅድ ጎዳስ ዱማይኮ፥ ሎኦ ግድን፥ ኢታ ግድን ካህነይ ሄ ኬꬃ ጋማቶ፤ ካህነይ ጋማትዳይስ እያዉ ጋተ ግዶ። ");
INSERT INTO gofe_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","ባ ኬꬃ ጌሽ ኦꬅድ ጎዳስ ዱማይዳ ኡራይ ዛሪድ ዎዛናዉ ኮይኮ፥ ሄ ኬꬃ ጋትያ ቦላ ፄታፐ ላታሙ ኩሸ ጉጆ፤ ስሚድ ኬꬃይ እያባ ግዴስ። ");
INSERT INTO gofe_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","እስ አስ ባ ላታ ጋድያፐ ሻክድ ጌሽ ኦꬅድ ጎዳስ ዱማይኮ፥ ሄ ጋድያ ጋተይ እያን ዘረትያ ዘረꬃን ጋማተቶ። ሄስካ ናምኡ ፄታነ ላታሙ ክሎ ግራመ ባንጋ ዘርያ ጋደ ግድኮ፥ እሻታሙ ሳቅለ ቃንፆ። ");
INSERT INTO gofe_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","እ ባ ጋድያ እሻታማንꬆ ላይꬃ ባለፐ ዶምድ ጌሽ ኦꬅድ ጎዳስ ዱማይኮ፥ ሄ ጋድያ ኩመꬃ ጋትያ ቃንፆ። ");
INSERT INTO gofe_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","ሽን እ ባ ጋድያ እሻታማንꬆ ላይꬃ ባለይ አꬍን፥ ጌሽ ኦꬅድ ጎዳስ ዱማይኮ፥ ካልድ ደእያ እሻታማንꬆ ላይꬃ ባለይ ጋካናዉ ደእያ ላይꬃታ ካህነይ ታይብድ፥ እያ ኩመꬃ ጋትያፐ ዎꬎ። ");
INSERT INTO gofe_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","ሄ ጋድያ ጌሽ ኦꬅድ ጎዳስ ዱማይዳ ኡራይ ዛሪድ ዎዛናዉ ኮይኮ፥ ጋማተትዳ ጋትያ ቦላ ፄታፐ ላታሙ ኩሸ ጉጆ፤ ስሚድ ጋደይ እያባ ግዴስ። ");
INSERT INTO gofe_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","ሽን እ ጋድያ ዛሪድ ዎዛናፐ ስን ሀራ አሳስ ባይዝኮ፥ ሄ ጋድያ ዎዛናዉ ዳንዳኤና። ");
INSERT INTO gofe_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","እሻታማንꬆ ላይꬃ ባለይ ጋክን ጋደይ የደትያ ዎደ ሄ ጋደይ ናምአንꬆ ጉየ ስሞና ጎዳስ ጌሽ ግዶ፤ ሄ ጋደይ ካህነታባ ግዴስ። ");
INSERT INTO gofe_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","እስ አስ ሀራ አሳፐ ሻምዳ ጋድያ ጌሽ ኦꬅድ ጎዳስ ዱማያናዉ ኮይኮ፥ ");
INSERT INTO gofe_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","ካልያ እሻታማንꬆ ላይꬃ ባለይ ጋካናዉ ደእያ ጋትያ ካህነይ ጋማትኮ፥ ኡራይ ሄ ጋላስ ጋማትዳ ጋትያ ቃንፆ፤ ሄ ሚሸይ ጎዳስ ዱማትዳ ሚሸ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","እሻታማንꬆ ላይꬃ ባለይ ጋክያ ዎደ ሄ ጋደይ ኮይሮ ላታን ኤክድ ባይዝዳ ኡራስ ስሜስ። ");
INSERT INTO gofe_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","ኤንታ ጋተይ ጌሻ ዱንካንያን ኤረትዳ ምዛነን ጋማተቴስ። (እስ ሳቅለይ ላታሙ ጌራ ግዴስ)። ");
INSERT INTO gofe_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","ሽን ኦንካ ባይራ የለትዳ መሄ ጎዳስ ዱማይድ ሺሻናዉ ዳንዳኤና፤ እ ካሰካ ጎዳባ። ሚዝ ዎይኮ ዶርሰ ግድን ጎዳባ። ");
INSERT INTO gofe_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","ሄ መሄይ ጌሽ ግዶና እፅኮ፥ እ ጋማተትዳ ጋትያ ቦላ እቻሻፐ እስ ኩሸ ጉጅድ እያ ጎዳይ ዛሪድ ዎዞ። እ ዎዞና እፅኮ፥ ጋማተትዳ ጋትያን ሀራ አሳስ ባይዘቶ። ");
INSERT INTO gofe_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","እስ አስ ጎዳስ ዱማይድ እምዳባይ አይባ ግድኮካ፥ አሰ ዎይኮ መሄ ዎይኮ እያ ላታ ጋደ ግድን፥ ባይዘተናነ ዎዘተና። እ ዱማይዳባ ኡባይ ጎዳስ ኡባፈ ጌሽ። ");
INSERT INTO gofe_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","አሳ ግዶፈ ሀይቃና መላ ፕርደትዳ አስ ኦንካ ዎዘቶፎ፤ ሄ ኡራይ ሀይቆ። ");
INSERT INTO gofe_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","ጋደን ካፅዳ ካꬅ ዎይኮ ምꬃ አይፈ ግድን ታማፈ እሶይ ጎዳባ። ሄስ ጎዳስ ጌሽ። ");
INSERT INTO gofe_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","እስ አስ ባ አስራታ ዎዛናዉ ኮይኮ፥ እያ ጋትያ ቦላ ፄታፐ ላታሙ ኩሸ ጉጅድ ዎዞ። ");
INSERT INTO gofe_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","ሚዛ አስራታ ዎይኮ ዶርሳ አስራታ ዎይኮ ዴሻ አስራታ ግድን፥ ሄንꬃንቹዋ ፃምአፈ ጋርሳራ አꬍያ ታማፈ እሶይ ጎዳስ ጌሽ። ");
INSERT INTO gofe_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","ታማንꬆ መሄይ ኢታ ግድን፥ ሎኦ ግድን ዶሮፖ፤ ዎይኮ እያ ሀራራ ላሞፎ። ላምኮ፥ ኮይሮይነ ላመ እምዳ ናምአይ ጎዳስ ጌሽ ግዶሶና፤ ዛሪድ ዎዛናዉ ዳንዳኤተና። ");
INSERT INTO gofe_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","ሲና ዙማ ቦላ ጎዳይ ሙሰ ባጋራ እስራኤለ አሳ ኪትዳ ኪታይ ሀይሳ። ");
INSERT INTO gofe_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","እስራኤለ አሳይ ግብፀ ቢታፈ ከይዳ ናምአንꬆ ላይꬃን፥ ናምአንꬆ አጌናን፥ ሄ አጌና ኮይሮ ጋላሳን፥ ጎዳይ ሲና መላ ቢታን ጌሻ ዱንካንያን ሙሰኮ ሀይሳዳ ያግስ፤ ");
INSERT INTO gofe_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“ኔራነ አሮናራ እስራኤለ አሳ ኡባ ኤንታ ኮቻን ኮቻን፥ ቃስ ኤንታ ሶ አሳን አሳን ታይባድ፥ አደ አሳ ሱንꬃ ፃፍተ። ");
INSERT INTO gofe_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","ላይꬅ ላታማነ እያፐ ቦላ ግድዳ፥ ኦለታናዉ ዳንዳእያ እስራኤለ አሳ ኡባ ታይብተ። ");
INSERT INTO gofe_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","ኮቻፐ ኮቻፐ እስ እስ አስ ባ ሶ አሳስ ሀላቃ ግድድ ህንተና ማዶ። ");
INSERT INTO gofe_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","ህንተና ማዳና አሳ ሱንꬃይ ሀይሳፈ ካልድ ፃፈትዳይሳ። ሮቤላፐ፥ ሻደኡራ ናኣ ኤልፁራ፤ ");
INSERT INTO gofe_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","ስሞናፐ ሱርሳዳያ ናአ ሳሉምኤላ፤ ");
INSERT INTO gofe_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","ይሁዳፐ አምናዳበ ናኣ ናአሶና፤ ");
INSERT INTO gofe_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","ይሳኮራፐ ዙአራ ናኣ ናትናኤላ፤ ");
INSERT INTO gofe_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","ዛብሎናፐ ሄሎና ናኣ ኤልኣባ፤ ");
INSERT INTO gofe_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","ዮሰፋ ናይታፐ፥ ኤፍሬማፐ አምሁዳ ናኣ ኤልሻማአ፤ ምናሰፐ ፓዳዙራ ናኣ ጋማልኤላ፤ ");
INSERT INTO gofe_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","ብንያመፐ ጋድዮና ናኣ አብዳና፤ ");
INSERT INTO gofe_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","ዳናፐ አምሳዳያ ናኣ አክኤዘራ፤ ");
INSERT INTO gofe_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","አሴራፐ ኦክራና ናኣ ፓግኤላ፤ ");
INSERT INTO gofe_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","ጋዳፐ ራጉኤላ ናኣ ኤልያሳፋ፤ ");
INSERT INTO gofe_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","ንፍታለመፐ ኤናና ናአ አክራ፤ ");
INSERT INTO gofe_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","ሀ አሳይ ባንታ አዋታ ኬꬃ አሳፐ ካለꬃናዉ ዶረትዳ እስራኤለ ያራታ ሀላቃታ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","ያትን ሙሰይነ አሮን ሄ ዶረትዳ አሳታ ኤክድ፥ ");
INSERT INTO gofe_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","ናምአንꬆ አጌናን ኮይሮ ጋላሳን ኩመꬃ ማባራ ፄግድ ሺሽዶሶና። አሳይ ባንታ ኮቻን ኮቻን፥ ቃስ ባንታ ሶ አሳን አሳን ላታሙ ላይꬅነ እያፐ ቦላ ግድዳ አደ ኡባይ ፃፈትስ። ");
INSERT INTO gofe_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","ጎዳይ እያ ኪትዳይሳዳ ሙሰይ ኤንታ ሲና መላ ቢታን ታይብስ። ");
INSERT INTO gofe_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","21","ኦለታናዉ ዳንዳእያ አደ ኡባይ፥ ላታሙ ላይꬅነ እያፐ ቦላ ግድዳ አደ ኡባይ ታይበትድ ሁጰን ሁጰን ፃፈትዶሶና። ኤንቲ ባንታ ኮቻን ኮቻንነ ባንታ ሶ አሳን ሻከትድ ሀይሳፈ ካልድ ደእያ ታይቦ ማራን ማዝጋበትዶሶና። ባይራ ናኣ ሮቤላፐ 46,500 ");
INSERT INTO gofe_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","23","ስሞናፐ 59,300 ");
INSERT INTO gofe_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","25","ጋዳፐ 45,650 ");
INSERT INTO gofe_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","27","ይሁዳፐ 74,600 ");
INSERT INTO gofe_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","29","ይሳኮራፐ 54,400 ");
INSERT INTO gofe_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","31","ዛብሎናፐ 57,400 ");
INSERT INTO gofe_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","33","ዮሰፋ ናኣ ኤፍሬማፐ 40,500 ");
INSERT INTO gofe_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","35","ዮሰፋ ናኣ ምናሰፐ 32,200 ");
INSERT INTO gofe_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","37","ብንያመፐ 35,400 ");
INSERT INTO gofe_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","39","ዳነፐ 62,700 ");
INSERT INTO gofe_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","41","አሴራፐ 41,500 ");
INSERT INTO gofe_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","43","ንፍታለመፐ 53,400 ");
INSERT INTO gofe_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","ሙሰይ፥ አሮንነ ባንታ ሶ አሳፐ አሳፐ ዶረትዳ ታማነ ናምኡ እስራኤለ ኮቻ ሀላቃት ታይብዳ አሳይ ሀይሳታ። ");
INSERT INTO gofe_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","ኦለታናዉ ዳንዳእያ አደ ኡባይ፥ ላታሙ ላይꬅነ እያፐ ቦላ ግድዳ አሳይ ባንታ ሶ አሳን አሳን ታይበትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","ኩመꬃ አሳ ታይቦይ 603,550. ");
INSERT INTO gofe_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","ሽን ሌወ ኮቻት ታይበትቦኮና። ");
INSERT INTO gofe_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","ጋሶይካ ካሰ ጎዳይ ሙሰኮ ሀይሳዳ ያግስ፤ ");
INSERT INTO gofe_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“ሌወ ኮቻታ ታይቦፓ፤ ኤንታ አትዳ እስራኤለ አሳ ታይቦን ገልሶፋ። ");
INSERT INTO gofe_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","ሌወታ፥ ጌሻ ዱንካንያንነ እያን ደእያ ሚሸታ ኡባ ቦላ ሀላቃ ኦꬃዳ ሹማ። ኤንቲ ዱንካንያነ እያን ደእያ ሚሸታ ቶካና፤ እያ ግዶን ኦꬃናነ እያ ዩሾን ዱንካናና። ");
INSERT INTO gofe_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","ጌሻ ዱንካነይ ሾደትያ ዎደ ሌወት ሾዶ፤ ጌሻ ዱንካነይ ኤቅያ ዎደ ሌወት ኤሶ፤ ኤንታፈ ሀር ኦንካ እያኮ ሺቅኮ ሀይቆ። ");
INSERT INTO gofe_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","ሀንኮ እስራኤለ አሳይ ባንታ ሄራንነ ባንታ ጩጋን ጩጋን ሻከትድ፥ ባንታ ዱንካንያ ዱንካኖና። ");
INSERT INTO gofe_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","ሽን ጎዳ ሀንቆይ እስራኤለ ማባራ ቦላ ዎꬎና መላ ሌወት ዱንካንያ ዩሹዋን ባንታ ዱንካንያ ዱንካንድ ናጎ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","እስራኤለ አሳይ ጎዳይ ሙሰ ኪትዳ ኡባ ኦꬅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","ጎዳይ ሙሰነ አሮና ሀይሳዳ ያግስ፤ ");
INSERT INTO gofe_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","እስራኤለ አሳይ ባንታ ኮቻን ኮቻን ማላነ ባንታ ኮቻ ኮቻ ኤርስያ ባንድራ ካልድ፥ ጌሻ ዱንካንያፐ ጉꬅ ሃክድ እያ ዩሹዋን ዱንካኖና። ");
INSERT INTO gofe_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","ዶሎሀ ባጋራ ይሁዳ ኮቻይ ባንታ ማላ ካልድ ዱንካኖና። ይሁዳ ኮቻ ካለይ አምናዳበ ናኣ ናአሶና። ");
INSERT INTO gofe_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","እያ ጩጋ ታይቦይ 74,600. ");
INSERT INTO gofe_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","ይሁዳ ጋክድ ዱንካናናይ ይሳኮረ ኮቻ። ይሳኮራ ኮቻ ካለይ ዙአራ ናኣ ናትናኤላ። ");
INSERT INTO gofe_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","እያ ጩጋ ታይቦይ 54,400. ");
INSERT INTO gofe_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","እያፐ ካልድ ዛብሎና ኮቻይ ዱንካኔስ። ዛብሎና ኮቻ ካለይ ሄሎና ናኣ ኤልኣባ። ");
INSERT INTO gofe_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","እያ ጩጋ ታይቦይ 57,400 ");
INSERT INTO gofe_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","ይሁዳ ባጋን ዱንካንዳ ኦላንቾታ ታይቦይ 186,400. እስራኤለ አሳይ ጉታ የድድ ብያ ዎደ ኮይሮት ከየይ ኤንታ። ");
INSERT INTO gofe_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","ዱገሀ ባጋራ ሮቤላ ኮቻይ ባንታ ማላ ካልድ ዱንካኖና። ኤንታ ካለይ ሳድዮራ ናኣ ኤልሱራ። ");
INSERT INTO gofe_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","እያ ጩጋ ታይቦይ 46,500. ");
INSERT INTO gofe_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","ሮቤላ ጋክድ ዱንካነይ ስሞና ኮቻ። ስሞና ኮቻ ካለይ ዙርሻዳያ ናአ ሳሉምኤላ። ");
INSERT INTO gofe_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","እያ ጩጋ ታይቦይ 59,300. ");
INSERT INTO gofe_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","እያፐ ካልድ ጋደ ኮቻይ ዱንካኔስ። ኤንታ ካለይ ደኡኤላ ናኣ ኤልያሳፋ። ");
INSERT INTO gofe_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","ኤንታ ጩጋ ታይቦይ 45,650. ");
INSERT INTO gofe_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","ሮቤላ፥ ባጋን ዱንካንዳ ኦላንቾታ ታይቦይ 151,450. እስራኤለ አሳይ ጉታ የድድ ብያ ዎደ ናምአንꬆ ከየይ ኤንታ። ");
INSERT INTO gofe_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","ሄሳፈ ጉየ ኮይሮ ከይያ ይሁዳ ጩጋፐነ ናምአንꬆ ከይያ ሮቤላ ጩጋፐ ግዶን ጌሻ ዱንካንያ ቶክድ ሌወት ገሎሶና። እስ እስ ኮቻይ ባንታ ዱንካንዳ ማራን ባንታ ማላ ኦይክድ ከዮ። ");
INSERT INTO gofe_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","ዉሎሀ ባጋራ ኤፍሬማ ባጋይ ባንታ ማላ ካልድ ዱንካኖና። ኤንታና ካለይ አምሁዳ ናኣ ኤልሻማአ። ");
INSERT INTO gofe_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","ኤንታ ጩጋ ታይቦይ 40,500. ");
INSERT INTO gofe_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","ኤንታ ጋክድ ምናሰ ኮቻይ ዱንካኔስ። ኤንታና ካለይ ፓዳዙራ ናኣ ጋማልኤላ። ");
INSERT INTO gofe_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","ኤንታ ኦላንቾታ ታይቦይ 32,200. ");
INSERT INTO gofe_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","እያፐ ካልድ ዱንካነይ ብንያመ ኮቻ። ብንያመ ኮቻ ካለይ ግድኦና ናኣ አብዳና። ");
INSERT INTO gofe_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","ኤንታ ጩጋ ታይቦይ 35,400. ");
INSERT INTO gofe_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","ኤፍሬማ ባጋን ዱንካንዳ ኦላንቾታ ታይቦይ 108,100. እስራኤለ አሳይ ጉታ የድድ ብያ ዎደ ሄꬓንꬆ ከየይ ኤንታ። ");
INSERT INTO gofe_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","ፑደሀ ባጋራ ዳነ ኮቻይ ባንታ ማላ ካልድ ዱንካኖና። ኤንታና ካለይ አምሳዳያ ናኣ አክኤዘራ። ");
INSERT INTO gofe_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","ኤንታ ጩጋ ታይቦይ 62,700. ");
INSERT INTO gofe_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","ኤንታና ጋክድ አሴራ ኮቻይ ዱንካኔስ። አሴራ ኮቻ ካለይ ኦክራና ናኣ ፓግኤላ። ");
INSERT INTO gofe_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","ኤንታ ጩጋ ታይቦይ 41,500. ");
INSERT INTO gofe_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","እያፐ ካልድ ንፍታለመ ኮቻይ ዱንካኔስ። ንፍታለመ ኮቻ ካለይ ኤናና ናኣ አክራ። ");
INSERT INTO gofe_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","ኤንታ ጩጋ ታይቦይ 53,400 ");
INSERT INTO gofe_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","ዳነ ባጋን ዱንካንዳ ኦላንቾታ ታይቦይ 157,600. እስራኤለ አሳይ ጉታ የድድ ብያ ዎደ ዉርሰꬃን ከየይ ኤንታ። ");
INSERT INTO gofe_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","ባንታ ኮቻን ኮቻን ሻከትድ ታይበትዳ እስራኤለ ኦላንቾታ ታይቦይ 603,550. ");
INSERT INTO gofe_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","ሽን ጎዳይ ሙሰ ኪትዳይሳዳ፥ ሌወት ሀራ እስራኤለ አሳራ ታይበትቦኮና። ");
INSERT INTO gofe_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","እስራኤለ አሳይ፥ ጎዳይ ሙሰ ኪትዳባ ኡባ ኦꬅዶሶና። ኤንቲ ባንታ ማላ ካልድ ዱንካንዶሶና፤ ቃስ ባንታ ኮቻነ ባንታ ሶ አሳ አሳ ካልድ ከዮሶና። ");
INSERT INTO gofe_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","ጎዳይ ሲና ዙማ ቦላ ሙሰራ ኦደትያ ዎደ ደእያ አሮናነ ሙሰ ሶ አሳይ ሀይሳፈ ካልድ ፃፈትዳይሳ። ");
INSERT INTO gofe_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","አሮና አደ ናይታ ሱንꬃይ፥ ባይራይ ናዳባ፥ ካለይ አብዮዳ፥ አላዛራነ እታማራ። ");
INSERT INTO gofe_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","ሄ አሮና አደ ናይት ኡባይ፥ ካህነ ግድድ ኦꬃናዉ ትየትድ ሹመትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","ሽን ኤንታ ግዶፈ ናዳበይነ አብዮድ ሲና መላ ቢታን ጎዳ ስንꬃን ጌሽ ግዶና ታማን ያርሾ ያርሽድ ሀይቅዶሶና። ኤንታዉ ናእ ባዋ። ሄሳ ግሾ፥ ኤንታ አዋይ አሮን ፓፃ ደእዳ ላይꬃ ኡባን አላዛርነ እታማራ ፃላል ካህነ ግድድ ኦꬅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","ጎዳይ ሙሰኮ፥ ");
INSERT INTO gofe_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“ሌወ ኮቻታ ኤሀዳ ካህንያ አሮና ማዳና መላ ኤንታ እያ ስን ሺሻ። ");
INSERT INTO gofe_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","ኤንቲ አሮናነ እስራኤለ ማባራ ኡባ ጌሻ ዱንካንያ ስንꬃን ዱማ ዱማ ኦሶ ኦꬅድ ማዶ። ");
INSERT INTO gofe_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","ኤንቲ ጌሻ ዱንካንያ ግዶን ደእያ ሚሸ ኡባ አዋተꬃን አይሶ። እስራኤለ አሳ ግሾ ጌሻ ዱንካንያ ግዶን ኦሶ ኡባ ኤንቲ ኦꬆና። ");
INSERT INTO gofe_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","አሮናነ እያ አደ ናይታ ማዳና መላ ሌወታ ሹማ። ኤንቲ እስራኤለ አሳ ግዶፈ ሻከትድ አሮና ማዳና መላ እመትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","አሮናነ እያ አደ ናይታ ካህነ ኦꬃዳ ሹማ። ኤንታፈ ሀራ አስ ኦንካ ጌሻ ዱንካንያኮ ሺቅኮ ሀይቆ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","ቃስ ጎዳይ ሙሰኮ፥ ");
INSERT INTO gofe_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“ታኒ እስራኤለን የለትያ ባይራ አደ ናይታ ግሾ ሌወታ ኤካስ። ሌወት ታባ። ");
INSERT INTO gofe_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","አይስ ጊኮ፥ ባይራ የለትዳ ኡባይ ታባ። ታ ግብፀ ቢታን ባይራ የለትዳ ኡባ ዎꬍዳ ጋላሳን፥ እስራኤለን ባይራ የለትዳባ ኡባ አሰ ግድን፥ መሄ ግድን፥ ታዉ ዱማያስ። ኤንቲ ታባ ግዳና። ታኒ ጎዳ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","ቃስካ ጎዳይ ሙሰኮ ሲና መላ ቢታን፥ ");
INSERT INTO gofe_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“ሌወታ ኤንታ ኮቻን፥ ቃስ ኤንታ ሶ አሳን አሳን ታይባ። የለትን እስ አጌናነ እያፐ ቦላ ግድዳ አደ ናይታ ኡባ ታይባ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","ያትን ጎዳይ ኪትዳይሳዳ ሙሰይ ኤንታ ታይብስ። ");
INSERT INTO gofe_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","ሌወ አደ ናይት ገድሶና፥ ቃሀታ ማራራ። ");
INSERT INTO gofe_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","ገድሶና አደ ናይት ልብናነ ሳመአ ጌተቶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","ቃሃታ አደ ናይት አምራማ፥ ይዝሃራ፥ ከብሮናነ ኡዝኤላ። ");
INSERT INTO gofe_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","መራራ አደ ናይት ማህላነ ሙሳ ጌተቶሶና። ሌወታ ማይዛት ሀይሳታ። ");
INSERT INTO gofe_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","ናምኡ ገድሶና ኮቻት ልብናነ ስምአ። ");
INSERT INTO gofe_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","የለትን እስ አጌናነ እያፐ ቦላ ግድዳ አደ ናይታ ታይቦይ 7,500. ");
INSERT INTO gofe_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","ገድሶና ኮቻት ጌሻ ዱንካንያፐ ጉየን ዉሎሀ ባጋን ዱንካንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","ገድሶና ኮቻ ሶ አሳ ሀላቃይ ላኤላ ናኣ ኤልያሳፋ። ");
INSERT INTO gofe_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","ገድሶና ኮቻስ ጌሻ ዱንካንያ ቦላ ደእያ አዋተꬃይ፥ ዱንካንያ፥ ጋꬃ ካማ፥ ካረ ካማ፥ ዉላ ማጋራጁዋ፥ ");
INSERT INTO gofe_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","ዱንካንያ ዩሾን ደእያ ዳባባ ማጋራጁዋ፥ ያርሾ በሳ ማጋራጁዋ፥ ዳባባ ዉላ ማጋራጁዋ፥ ዎዶሮታነ እያን ጎኤትያ ሚሸታ ኡባ አዋተꬃን አይሶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","ቃሃታ ኮቻት አምራማ፥ ይዝሃራ፥ ከብሮናነ ኡዝኤላ። ");
INSERT INTO gofe_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","የለትን እስ አጌናነ እያፐ ቦላ ግድዳ አደ ናይታ ታይቦይ 8,600. ቃሃታ ኮቻት ጌሻ ዱንካንያ አዋተꬃን ናጎሶና። ");
INSERT INTO gofe_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","ቃሃታ ኮቻት ጌሻ ዱንካንያፐ ዱገሀ ባጋራ ዱንካንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","ቃሃታ ኮቻ ካለይ ኡዝኤላ ናኣ ኤልዛፋና። ");
INSERT INTO gofe_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","ኤንቲ ታቦትያ፥ ፃርጴዛ፥ ፆምፐ ዎꬅያ ኮጫ፥ ያርሽሶ በሳ፥ ካህነት ጎኤትያ ጌሻ ዱንካንያ ሚሸታ፥ ኡባፈ ጌሻ በሳ ገልያ ዉላ ቦላ ደእያ ማጋራጁዋ አዋተꬃን አይሶ። ");
INSERT INTO gofe_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","ሌወታ ሀላቃይ ካህንያ አሮና ናኣ አላዛራ። እ ጌሻ በሳን ኦይሳታስ ሹማ። ");
INSERT INTO gofe_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","መራራ ኮቻት ማህላነ ሙሳ። ");
INSERT INTO gofe_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","የለትን እስ አጌናነ እያፐ ቦላ ግድዳ አደ ናይታ ታይቦይ 6,200. ");
INSERT INTO gofe_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","መራራ ኮቻ ካለይ አብካላ ናኣ ዙርኤላ። መራራ ኮቻይ ጌሻ ዱንካንያፐ ፑደሀ ባጋራ ዱንካንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","መራራ ኮቻይ ዱንካንያ ቱቀታ፥ ልዮታ፥ ቱሳታነ ቱሳት ኤቅያ ገዳታ፥ ሄሳዳካ ግዶን ኮሽያ ሚሸታ ኡባ ኤንቲ አዋተꬃን አይሶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","ጉጅድካ፥ ዱንካንያ ዩሾን ደእያ ዳባባ ቱሳታነ ኤንታ ገዳታ፥ ꬍሸታነ ዎዶሮታ አዋተꬃን አይሶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","ጌሻ ዱንካንያ ስንꬃን ዶሎሀ ባጋራ ሙሰይ፥ አሮንነ እያ አደ ናይት ዱንካንዶሶና። ጌሻ ዱንካንያ ግዶን እስራኤላ አሳ ግሾ ኦሰትያ ኦሶ ኡባ ኤንቲ አዋተꬃን አይሶሶና። ሀራ አስ ጌሻ ዱንካንያኮ ሺቅኮ ሀይቆ። ");
INSERT INTO gofe_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","ጎዳይ፥ ሙሰነ አሮና ኪትዳይሳ መላ እስ አጌናነ እያፐ ቦላ ግድዳ ሌወታ አደ ናይታ ታይቦይ 22,000. ");
INSERT INTO gofe_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","ጎዳይ ሙሰኮ፥ “የለትን እስ አጌናነ እያፐ ቦላ ግድዳ እስራኤለ ባይራ አደ ናይታ ታይባዳ ኤንታ ሱንꬃ ፃፋ። ");
INSERT INTO gofe_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","እስራኤለ ባይራ አደ ናይታ በሳን ሌወታ፥ ቃስ እስራኤለ ባይራ መህያ በሳን ሌወታ ባይራ መህያ ታዉ ኤካ። ታኒ ጎዳ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","ጎዳይ ሙሰ ኪትዳይሳዳ እስራኤለን ባይራ የለትዳ ኡባ ታይብስ። ");
INSERT INTO gofe_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","የለትን እስ አጌናነ እያፐ ቦላ ግድዳ ባይራ አደ ናይታ ታይቦይ 22,273. ");
INSERT INTO gofe_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","ጎዳይ ሙሰኮ፥ ");
INSERT INTO gofe_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“እስራኤለ ባይራ አደ ናይታ በሳን ሌወታ ታዉ ዱማያ። ቃስ እስራኤለ ባይራ መሄታ በሳን ሌወታ ባይራ መህያ ታዉ ዱማያ፤ ታኒ ጎዳ። ");
INSERT INTO gofe_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","እስራኤለ ባይራ አደ ናይታ ታይቦይ ሌወታ ባይራ አደ ናይታ ታይቡዋፐ 273 አꬍያ ግሾ ሄ አትዳይሳታ ታዉ ዎዛ። ");
INSERT INTO gofe_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","እሱዋስ እሱዋስ ጌሻ ዱንካነን ኤረትዳ ምዛነን እቻሹ ብራ ሳንትመን ዎዛ። ");
INSERT INTO gofe_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","ሄ ዎዞ ሚሽያ አሮናስነ እያ አደ ናይታስ እማ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","ፓላህዳይሳታ ዎዞ ሚሽያ ሙሰይ ሺሽስ። ");
INSERT INTO gofe_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","ጌሻ ዱንካንያ ምዛንያ ልከን እስራኤለ ባይራ አደ ናይታ ዎዞ ሚሽያ 1,365 ብራ ሳንትመ ኤክስ። ");
INSERT INTO gofe_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","ጎዳይ ኪትዳይሳዳ ሙሰይ ዎዞ ሚሽያ አሮናስነ እያ አደ ናይታስ እሚስ። ");
INSERT INTO gofe_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","ጎዳይ ሙሰነ አሮና ሀይሳዳ ያግስ፤ ");
INSERT INTO gofe_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“ሌወ ኮቻታፐ ቃሃታ ኮቻታነ ኤንታ ሶ አሳ አሳ ሻካዳ ታይባ። ");
INSERT INTO gofe_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","ላይꬅ 30-50 ጋክዳ አደ ኡባ ጌሻ ዱንካንያን ኦꬃናዉ ዳንዳኤይሳታ ታይባ። ");
INSERT INTO gofe_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","ቃሃታ ኮቻት ጌሻ ዱንካንያን ኦꬃና ኦሶይ ዱንካንያን ጎኤትያ ጌሻ ሚሸታ አዋተꬃን ናጎ። ");
INSERT INTO gofe_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","“አሳይ ጉታፐ ባናዉ ደንድያ ዎደ አሮንነ እያ አደ ናይት ጌሻ ዱንካንያ ግዶ ገልድ፥ ጫቆ ታቦትያ ስንꬃን ደእያ ማጋራጁዋ ዎꬍስድ ሄ ጫቆ ታቦትያ እያራ ፃፆ። ");
INSERT INTO gofe_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","ሄ ካማ ቦላ ሊቆ ጋልባ ካሞ፤ እያ ቦላ ጉጅድ ካሎሰ ጫርቀ ካሞ፤ ቶክያ ካሶታ ሳጋዮታን አꬆ። ");
INSERT INTO gofe_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","“ጎዳስ ሺቅያ ኡይꬃ ዎꬅያ ፃርጴዛ ቦላ ካሎሰ ጫርቀ ካሞ። ፃርጴዛ ቦላ ሳነታ፥ ጭልፓታ፥ ፁአታነ ዎይነ ኡሻ ያርሹዋ ዱቅያ ኦቶታ ዎꬆና። ኡይꬃይ ኡባ ዎደ ፃርጴዛ ቦላ ደኦ። ");
INSERT INTO gofe_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","ሄ ኡባ ቦላ ዞኦ ጫርቀ ካምድ እያ ቦላ ቃስ ሊቆ ጋልባ ካሞ፤ ሄሳፈ ካልድ ቶክያ ካሶታ ሳጋዮታን አꬆ። ");
INSERT INTO gofe_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“ካሎሰ ጫርቀ ኤክድ ፆምፐ ዎꬅያ ኮጫ፥ እያ ፆምፐታራ፥ እያ ቃጰታራ፥ ብዶ ከስያ ከረታራነ ዛይተ ትግያ ፃሮታራ ኡባ ካሞ። ");
INSERT INTO gofe_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","ያትድ እያ ሚሸታ ኡባ ሊቆ ጋልባን ካምድ ቶክያ አርሳ ቦላ ዎꬆና። ");
INSERT INTO gofe_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","“ካልድ ዎርቃ ያርሾ ሳፅንያ ካሎሰ ጫርቀን ካሞ፤ ቃስ እያ ቦላራ ሊቆ ጋልባ የጎ። ያትድ ቶክያ ካሶታ ሳጋዮታን አꬆ። ");
INSERT INTO gofe_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","ሄሳዳካ፥ ጌሻ ዱንካንያ ግዶን ጎኤትያ ሚሸታ ኡባ ካሎሰ ጫርቀን ፃፆ፤ እያ ቦላ ሊቆ ጋልባ የግድ፥ ቶክያ አልጋ ቦላ ዎꬆ። ");
INSERT INTO gofe_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","“ናሰ ያርሾ በሳፈ ብዱዋ ፕትድ እያ ቦላ ኦቻ ቴራ ዳንያ ጫርቀ ካሞ። ");
INSERT INTO gofe_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","ያርሾ በሳን ጎኤትያ ሚሸታ ኡባ፤ ታማ ጮጨታ፥ አሾ ቃጰታ፥ አካፋታነ ሃꬃ ከረታ እያ ቦላ ዎꬅድ፥ ሊቆ ጋልባ ካሞ። ያትድ ቶክያ ካሶታ ሳጋዮታን አꬆ። ");
INSERT INTO gofe_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","አሮንነ እያ አደ ናይት፥ ጌሻባታነ እያን ጎኤትያ ጌሻ ሚሸታ ኡባ ካምዳፐ ጉየ እስራኤለ አሳይ ጉታፐ ደንድያ ዎደ ቃሃታ ኮቻይ ይድ ቶኮ። ሽን ኤንቲ ሀይቆና መላ ጌሻ ሚሸታ ቦቾፎ። ጌሻ ዱንካነይ በሳፈ ደንድያ ዎደ ቃሃታ ኮቻስ ደእያ አዋተꬃይ ሀይሳ። ");
INSERT INTO gofe_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“ካህንያ አሮና ናአይ አላዛር ፆምፐ ዛይትያ፥ ሳውያ እፃንያ፥ ያርሾ ካꬃነ ትዮ ዛይትያ፥ ሄሳዳካ ጌሻ ዱንካንያን ደእያ ዱማ ዱማ ጌሻ ሚሸታ ኡባ ቦላ አዋተꬅ ደኤስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","ጎዳይ ሙሰኮነ አሮናኮ፥ ");
INSERT INTO gofe_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“ቃሃታ ኮቻይ ሌወ ኮቻ ግዶፈ ሀይቅድ ꬋያና መላ ኦꬆፍተ። ");
INSERT INTO gofe_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","ኡባፈ ጌሻ ሚሽያኮ ሺቅድ ሀይቆና መላ አሮንነ እያ አደ ናይት ጌሻ ዱንካንያ ግዶ ገልድ፥ ቆሃታ ኮቻይ ሁጰን ሁጰን ኦꬃና ኦሱዋነ ቶካና ቶሁዋ ሻክድ በሶ። ");
INSERT INTO gofe_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","ቃሃታ ኮቻይ ሀይቆናዳ ጌሻ ሚሸታ በአናዉ ጉꬃ ዎደስካ ዱንካንያ ግዶ ገሎፖ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","ጎዳይ ሙሰኮ፥ ");
INSERT INTO gofe_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“ሌወ ኮቻፈ ገድሶና ኮቻነ ኤንታ ሶ አሳ አሳ ሻካዳ ታይባ። ");
INSERT INTO gofe_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","ላይꬅ 30-50 ጋክዳ አደ ኡባ ጌሻ ዱንካንያ ግዶን ኦꬃናዉ ዳንዳኤይሳታ ታይባ። ");
INSERT INTO gofe_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","ገድሶና ኮቻት ኦꬃና ኦሶይ ሀይሳፈ ካልድ ደኤይሳ፤ ");
INSERT INTO gofe_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","ኤንቲ ጌሻ ዱንካንያ ጋꬃ ካማ፥ ካረ ካማ፥ ቦላራ የገትያ ሊቆ ዶአ ጋልባ፥ ገልያ ዉላ ቦላ ካቀትያ ማጋራጁዋ ቶኮ። ");
INSERT INTO gofe_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","ሄሳዳካ ጌሻ ዱንካንያነ ያርሾ በሳ ዩሹዋን ደእያ ዳባባ ማጋራጆታ፥ ዳባባ ገልያ ዉላ ቦላ ደእያ ገሸታ፥ ዎዶሮታነ እያዉ ጎኤትያ ሚሸታ ኡባ ቶኮ። ገድሶና ኮቻይ ሚሸታን ኦꬃናዉ በሲያ ኦሶ ኡባ ኦꬆ። ");
INSERT INTO gofe_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","ቶሆ ግድን፥ ሀራ ኦሶ ግድን፥ ኤንቲ ኦꬅያ ኦሶ ኡባ አሮንነ እያ አደ ናይት ኤንታ ካል ኦስሶ። ኤንቲ ቶካናዉ በሲያባታ ኡባ ነ አዋተꬃን ኤንታዉ ግሻ። ");
INSERT INTO gofe_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","ጌሻ ዱንካንያ ግዶን ገድሶና ኮቻይ ኦꬃና ኦሶይ ሀይሳ። ኤንታ ኦሱዋ ካህንያ አሮና ናአይ እታማር ካልድ ኦስሶ። ");
INSERT INTO gofe_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“ሌወ ኮቻፈ መራራ ኮቻነ ኤንታ ሶ አሳ አሳ ሻካዳ ታይባ። ");
INSERT INTO gofe_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","ላይꬅ 30-50 ጋክዳ አደ ኡባ ጌሻ ዱንካንያ ግዶን ኦꬃናዉ ዳንዳኤይሳታ ታይባ። ");
INSERT INTO gofe_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","“ኤንቲ ዱንካንያ ቱቀታ፥ ልዮታ፥ ቱሳታ፥ ዱንካንያ ገዳታ፥ ");
INSERT INTO gofe_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","ዱንካንያ ዩሾን ዳባባን ኤቅያ ቱሳታ፥ ሄ ቱሳታ ገዳታ፥ ꬍሸታ፥ ዎዶሮታነ እያን ኮሽያ ሚሸታ ኡባ ቶኮ። እሶይ እሶይ ቶካናዉ በሲያ ሚሽያ እያ ሱንꬃን ሻካዳ ግሻ። ");
INSERT INTO gofe_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","ጌሻ ዱንካንያ ግዶን መራራ ኮቻይ ኦꬃና ኦሶይ ሀይሳ። ኤንቲ ኦꬃና ኦሶ ኡባ ካህንያ አሮና ናኣ እታማር አዋተꬃን ካልድ ኦስሶ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","ሙሰይ፥ አሮንነ እስራኤለ ሀላቃት ቃሃታ ኮቻ ኤንታ ሶ አሳን አሳን ሻክድ ታይብዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","ላይꬅ 30-50 ጋክዳ አደ ኡባ ጌሻ ዱንካንያ ግዶን ኦꬃናዉ ዳንዳኤይሳታ ታይብዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","ኤንታ ታይቦይ 2,750. ");
INSERT INTO gofe_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","ጎዳይ ሙሰ ኪትዳይሳዳ ጌሻ ዱንካንያ ግዶን ኦꬃና መላ ሙሰይነ አሮን ታይብዳ ቃሃታ ኮቻት ሀይሳታ። ");
INSERT INTO gofe_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","ገድሶና ኮቻት ባንታ ሶ አሳን አሳን ሻከትድ ታይበትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","ላይꬅ 30-50 ጋክዳ አደት ኡባ ጌሻ ዱንካንያ ግዶን ኦꬃናዉ ዳንዳኤይሳታ ");
INSERT INTO gofe_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","ታይቦይ 2,630. ");
INSERT INTO gofe_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","ጎዳይ ሙሰ ኪትዳይሳዳ ጌሻ ዱንካንያ ግዶን ኦꬃና መላ ሙሰይነ አሮን ታይብዳ ገድሶና ኮቻት ሀይሳታ። ");
INSERT INTO gofe_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","መራራ ኮቻት ባንታ ሶ አሳን አሳን ሻከትድ ታይበትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","ላይꬅ 30-50 ጋክዳ አደት ኡባይ፥ ጌሻ ዱንካንያ ግዶን ኦꬃናዉ ዳንዳኤይሳታ ");
INSERT INTO gofe_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","ታይቦይ 3,200. ");
INSERT INTO gofe_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","ጎዳይ ሙሰ ኪትዳይሳዳ ጌሻ ዱንካንያ ግዶን ኦꬃና መላ ሙሰይነ አሮን ታይብዳ መራራ ኮቻት ሀይሳታ። ");
INSERT INTO gofe_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","ሙሰይ፥ አሮንነ እስራኤለ ሀላቃት ሌወታ ኡባ ኤንታ ኮቻንነ ኤንታ ሶ አሳን አሳን ሻክድ ታይባ። ");
INSERT INTO gofe_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","ላይꬅ 30-50 ጋክዳ አደት ኡባይ፥ ጌሻ ዱንካንያ ግዶን ኦꬃናዉኑነ ሚሸታ ቶካናዉ ዳንዳእያ፥ ");
INSERT INTO gofe_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","ሌወታ ታይቦይ 8,580. ");
INSERT INTO gofe_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","ጎዳይ ሙሰ ኪትዳይሳዳ፥ ኤንቲ ሁጰን ሁጰን ታይበትዶሶና። ሄሳዳካ ጎዳይ ሙሰ ኪትዳይሳዳ ኤንቲ ኦꬃና ኦሶይነ ቶካና ቶሆይ እመትስ። ");
INSERT INTO gofe_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","ጎዳይ ሙሰኮ፥ ");
INSERT INTO gofe_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“እስራኤለ አሳይ ባሮ ሀርገን ኦይከትዳ አስ ዎይኮ አሳተꬃፈ ጎግያባይ ደእያ አስ ዎይኮ አሀ ቦችድ ቱንዳ አስ ኦናካ ባንታ ጉታፐ ከሳና መላ ኪታ። ");
INSERT INTO gofe_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","ታ ኤንታ ግዶን ደእያ ጉታ ቱንሶና መላ ሀ ጌሽ ግዶና አሳት ማጫ ግድን አደ ኤንታ ግዶፈ ከሳዳ ጎዳ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","ጎዳይ ሙሰ ኪትዳይሳዳ እስራኤለ አሳይ ኤንታ ኡባ ጉታፐ ከስድ ጎድዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","ጎዳይ ሙሰኮ፥ ");
INSERT INTO gofe_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“ኔኒ እስራኤለ አሳስ ሀይሳ ኦዳ፤ አደ ግድን ዎይኮ ማጭ ግድን ኦንካ ጎዳስ አማነቶና እፅድ ሀራ አስ ናቅኮ ሄ ኡራይ ባላ ኦꬅስ። ");
INSERT INTO gofe_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","እ ባ ናጋራ ፓፆ፤ ባ ናጋራ አጭያ ኩመꬃ አጫ ቦላ ፄታፐ ላታሙ ኩሸ ጉጅድ እ ናቅዳ ኡራስ ጭጎ። ");
INSERT INTO gofe_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","ሽን ሄ ናቀትዳ ኡራይ ሀይቅዳባ ግድኮ፥ አጫ ኤካናዉ ማታ ዳቦይ እያዉ ꬋይኮ፥ ሄ አጫይ ጎዳስ ግድድ ካህንያስ እመቶ። ሄ አጫ ቦላ ጉጅድ እያ ናጋራ አቶተꬃስ ቆሆ ያርሾስ ግድያ ማራዘ ዶርስ እሞ። ");
INSERT INTO gofe_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","ቃስ እስራኤለ አሳይ ጎዳስ እምያ ጌሻ እሞ ኡባይ ሄ ካህንያስ ግዶ። ");
INSERT INTO gofe_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","እስ እስ አስ እምያ ጌሻ እሞታይ ሄ ኡራባ፥ ሽን ካህንያስ እምኮ ሄ እሞታይ ካህንያሳ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","ጎዳይ ሙሰኮ፥ ");
INSERT INTO gofe_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“እስራኤለ አሳስ ያጋዳ ኦዳ፤ እስ አድያ ማችያ ካረ ሄመታዳ እያዉ አማነቶና እፅኮ፥ ");
INSERT INTO gofe_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","ሀራ አደራ አቅኮ፥ ቃስ ሄሳ እያ ባ አዝናፐ ቆስኮ፥ እያ ላይማትሽን በእዳ ማርክ ባይናባ ግድኮ፥ ");
INSERT INTO gofe_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","እ አዝናይ እዮ ቱናሱ ግድ ስꬍኮ፥ ዎይኮ እያ ቱኖና ደእሽን እ ባ ማችዉ ስꬍኮ፥ ");
INSERT INTO gofe_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","ሄ አደይ ባ ማችዉ ካህንያኮ ኤፎ። እ ግሾ ያርሻናዉ እስ ክሎ ግራመ ባንጋ ꬊለ ኤፎ። ሄ አደይ ባ ማችዉ ስꬍዳ ግሾ፥ እ ቆሁዋ ቆንጭስያ ካꬃ ያርሾ ግድያ ግሾ፥ ꬊልያ ቦላ ዛይተ ትጎፖ፤ እፃነ እያ ቦላ ዎꬆፎ።” ");
INSERT INTO gofe_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","ካህነይ ሄ ማጫስዉ ጎዳ ስንꬃን ኤሶ። ");
INSERT INTO gofe_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","ጌሻ ሃꬅ ከረን ኤኮ። ጌሻ ዱንካንያ ዉይግያፐ ቢታ ኤክድ ሄ ሃꬃን ጉጆ። ");
INSERT INTO gofe_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","ሄ ማጫስዉ ጎዳ ስንꬃን ኤሶ፤ ሄ ማጫሰ ሁጵያ ብልድ ስꬍዳ ግሾ ያርሸትያ ቆሁዋ ቆንጭስያ ካꬃ ያርሾ እ ኩሸን ዎꬆ፤ ቃስ ካህነይ ባ ኩሸን ባደꬅ ኤህያ ጫሞ ሃꬃ ከረን ኦይኮ። ");
INSERT INTO gofe_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","ሄሳፈ ጉየ ማጫስዉ ያግድ ጫቅሶ፤ “ኔኒ ሀራ አደራ አቃቦናባ ግድኮ፥ ነናተꬃ ቱንሳቦናባ ግድኮ፥ ባደꬅ ኤህያ ሃꬃይ ነዉ ጎመ ግዶፖ። ");
INSERT INTO gofe_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","ሽን ኔኒ ነ አዝና አጋዳ ሀራ አደራ አቃዳ ቱንዳባ ግድኮ፥ ");
INSERT INTO gofe_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","ጎዳይ ነ የሎ ኬꬃ ጉንድስድ፥ ነ ኡሉዋ ጋቢስድ ነ አሳ ስንꬃን ነና ባደትዳባ ኦꬆ። ");
INSERT INTO gofe_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","ሀ ባደꬅ ኤህያ ሃꬃይ ነ ኡሉዋን ገልድ ነ ኡሉዋ ጋቢሶ፤ ነ የሎ ኬꬃ ጉንድሶ” ያግድ ጫቅሶ። ማጫስያ፥ “አምንእ፥ ሄስ ታና ጋኮ” ያጎ። ");
INSERT INTO gofe_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“ሀይሳፈ ጉየ፥ ካህነይ ሄ ባደꬃ ፃፎ፤ ሄ ፃፍዳይሳ ከርያን ደእያ ሃꬃን ሜጮ። ");
INSERT INTO gofe_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","ቃንገꬅ ኤህያ ሃꬃ ማጫስዉ ኡሻናፐ ስን፥ ");
INSERT INTO gofe_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","ካህነይ ማጫሰ ኩሸፐ ያርሾ ꬊልያ ኤክድ፥ ደንꬆ ያርሾ ኦꬅድ ጎዳስ ያርሾ። ");
INSERT INTO gofe_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","ካህነይ ያርሾ ካꬃፈ ዞለ ኤክድ ባላ ቆንጭስያ ያርሾ ኦꬅድ ያርሾ በሳን ፁጎ። ሄሳፈ ጉየ፥ ማጫስዉ ሄ ሃꬃ ኡሾ። ");
INSERT INTO gofe_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","እያ ባ አዝናስ አማነቶና እፃዳ ቱንዳባ ግድኮ ባደꬃ ሃꬃይ እ ኡሉዋን ጫሞ ሳሆ መꬎ። እ ኡሎይ ጋባና፤ እ የሎ ኬꬃይካ ጉንዳና፤ እያ ባ አሳ ግዶን ባደትዳሮ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","እያ ቱናቦናባነ ፅሎ ማጫስ ግድኮ፥ እያ ጌሽ ግዳና፤ ናአ የላናዉ ዳንዳአዉሱ። ");
INSERT INTO gofe_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","30","“እስ አስ ባ ማችዉ ላይማታሱ ግድ ስꬍኮ ዎይኮ ቃናትኮ ያርሾ በሲ ኤህድ እዮ ኤሶ። ካህነይ ሄ ዎጋ ኡባ እ ቦላ ፖሎ። ");
INSERT INTO gofe_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","አዝናይ፥ ቆሆይ ባይናባ ግዳና፥ ሽን ማችያ ባ ናጋራ ጋሶን ጋክያ ዋየ ኡባ ቶካና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","ጎዳይ ሙሰኮ፥ ");
INSERT INTO gofe_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“እስራኤለ አሳ ሀይሳዳ ጋዳ ኪታ፤ አደ ግድን ዎይኮ ማጫ ባና ጎዳስ ዱማይድ ናዝራወ ግዳናዉ ቃንግኮ፥ ");
INSERT INTO gofe_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","ዎይነ ዎይኮ ሀራ ማꬆይያ ኡሽ ኡዮፖ። ጫላባነ ማꬆያባ ኡዮፖ፤ ዎይነ ቴራ፥ ትያነ መላ ሞፖ። ");
INSERT INTO gofe_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","እ ባና ጎዳስ ዱማይዳ ዎደ ኡባን፥ ዎይነ አይፍያ ግድን ፖቁዋ ግድን ዎይኮ ኮቻ ግድን ሞፖ። ");
INSERT INTO gofe_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“እ ባና ጎዳስ ዱማይዳ ዎደ ኡባን፥ ባ ሁጵያ ሜደቶፎ ዎይኮ ቃንፀቶፎ። እ ባ ሁጰ ብናና አዱስድ ድቾ። እ ባና ጎዳስ ዱማይዳ ዎደይ ፖለታና ጋካናዉ ጌሽ ግዳናዉ ኮሼስ። ");
INSERT INTO gofe_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","እ ባና ጎዳስ ዱማይዳ ዎደን ኡባን አሀኮ ሺቆፖ። ");
INSERT INTO gofe_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","እ ባና ዱማይዳይሳ ኤርሰይ እያ ሁጵያ ግድያ ግሾ፥ እያ አዋይ ዎይኮ እያ አይያ ዎይኮ እያ እሻይ ዎይኮ እያ ምችያ ሀይቅኮ ኤንታ አሀ ቦችድ ባና ቱንሶፖ። ");
INSERT INTO gofe_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","እ ባና ጎዳስ ዱማይዳ ዎደ ኡባን ጎዳስ ጌሽ። ");
INSERT INTO gofe_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“አስ እያ ማታን ቆፖና ሀይቅኮ፥ ጎዳስ ጌሽ ግድዳ ባ ሁጵያ ቱንስኮ ላፑን ጋላስ ጋምእድ ባ ሁጵያ ሜደቶ። ");
INSERT INTO gofe_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","ሆስፑንꬃ ጋላሳን ናምኡ ሆለታ ዎይኮ ናምኡ ኩራቾታ ጌሻ ዱንካንያ ፐንገን ደእያ ካህንያስ ኤሆ። ");
INSERT INTO gofe_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","ናዝራወይ አሀ ቦችድ ቱንዳ ግሾ ናጋራፐ እያ ጌሻናዉ ካህነይ ሆለታፐ እሱዋ ናጋራ ያርሾ፥ ሀንኩዋ ቃስ ፁሳ ያርሾ ኦꬅድ ያርሾ። ሄ ጋላስ እ ባ ሁጵያ ዎጋዳ ዛሪድ ጎዳስ ጌሾ፤ ");
INSERT INTO gofe_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","እ ባና ዛሪድ ጎዳስ ዱማዮ። ያትድ እስ ላይꬃ ማራዘ ናቆ ያርሾ ኦꬅድ ያርሾ። እ ጎዳስ ዱማይዳ ሁጰይ ቱንዳ ግሾ፥ ካሰ እ ባና ጎዳስ ዱማይድ ደእዳ ዎደይ ታይበተና። ");
INSERT INTO gofe_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“እስ ናዝራወይ ባ ቃንገꬃ ዎድያ ኦንግዳ ዎደ ፖላና ዎጋይ ሀይሳ፤ ጌሻ ዱንካንያ ፐንገ ብድ፤ ");
INSERT INTO gofe_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","ቦረይ ባይና እስ ላይꬃ ዶርሳ ኡርገ ፁሳ ያርሾስ፥ እስ ላይꬃ ኡዞ ዶርስ ናጋራ ያርሾስ፥ እስ ማራዘ እስፈተꬃ ያርሾስ ሄ በሳ ኤሆ። ");
INSERT INTO gofe_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","ቃስ ካꬃ ያርሾነ ኡሻ ያርሾ ኤንታራ እስፈ ያርሻናዉ ኤሆ። ሄ ካꬃ ያርሾይ እርሾይ ገልቦና ሎኦ ꬊለ ሻማሆ ዛይተራ ኡከትዳ ኦርደ ኡይꬅነ ሻማሆ ዛይተን ትየትዳ ሌኦ ጋይታን ኤሆ። ");
INSERT INTO gofe_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","“ካህነይ ሄ ኡባ ናጋራ ያርሾነ ፁሳ ያርሾ ኦꬅድ ጎዳስ ያርሾ። ");
INSERT INTO gofe_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","ካህነይ ማራዝያ ጋይታን ደእያ ኡይꬃራ ጎዳስ እስፈተꬃ ያርሾ ኦꬅድ ያርሾ፤ ካልድ ካꬃ ያርሹዋነ ኡሻ ያርሹዋ ያርሾ። ");
INSERT INTO gofe_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","ናዝራወይ ጎዳስ ዱማይዳ ባ ሁጵያ ጌሻ ዱንካንያ ፐንገን ሜደትድ፥ ብናና እስፈተꬃ ያርሾይ ኤፅያ ታማን የጎ። ");
INSERT INTO gofe_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","“ናዝራወይ ባ ሁጵያ ሜደትዳፐ ጉየ፥ ካህነይ ዶይሰትዳ ማራዝያ ገዳ አሹዋ ጋይታን ደእያ ኦርደ ኡይꬃፈነ ሌኦ ኡይꬃፈ ኤክድ፥ ናዝራውያ ኩሸን ዎꬆ። ");
INSERT INTO gofe_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","ያትድ ካህነይ ሄ ኡባ ዩሾ ያርሾ ኦꬅድ፥ ጎዳስ ያርሾ። ሄ ኡባይ ካህንያ ግሾ ግድያ አንጋሱዋራነ ገዳራ ካህንያስ ጌሻ ያርሾ ግዴስ። ሄሳፈ ጎዳስ ናዝራወይ ዎይነ ኡሻ ኡዮ። ");
INSERT INTO gofe_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","ህዛ ጎዳስ ባና ዱማይዳ ናዝራወይ ኦꬃና መላ እመትዳ ዎጋይ ሀይሳ። ሽን ናዝራወይ ያርሻናዉ ኮሽያ ያርሾታፐ አꬅድ እማናዉ ቃንግዳባ ግድኮ፥ ባ ቃንገꬃ ጋꬃናዉ ኮሼስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","ጎዳይ ሙሰኮ፥ ");
INSERT INTO gofe_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“አሮንነ እያ አደ ናይት እስራኤለ አሳ አንጅያ ዎደ ሀይሳዳ ያግድ አንጅተ ያጋ፤ ");
INSERT INTO gofe_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","“ ‘ጎዳይ ህንተና አንጆ፥ ጎዳይ ህንተና ናጎ፤ ");
INSERT INTO gofe_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","ጎዳይ ባ ሶምኡዋ ህንተዉ ፖእሶ፤ እ ህንተዉ ቃቶ፤ ");
INSERT INTO gofe_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","ጎዳይ ባ ኬሀ አይፍያን ፄሎ፤ እ ህንተዉ ሳሮተꬅ እሞ’ ያግድ አንጅተ” ያጋ። ");
INSERT INTO gofe_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","“ኤንቲ እስራኤለ አሳ ታ ሱንꬃን አንጅያ ዎደ ታ ኤንታ አንጃና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","ሙሰይ ጌሻ ዱንካንያ ቶክድ ኦንግዳ ዎደ ሄ ዱንካንያነ እያ ሚሽያ፥ ያርሾ በሳነ እያ ሚሽያ ኡባ ዛይተን ትይድ ጌሽስ። ");
INSERT INTO gofe_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","ሄሳፈ ጉየ፥ እስራኤለ አሳ ኮቻን ኮቻን ታይብድ ካለꬅያ ዎደ ሀላቃ ግድዳ ኡባይ፥ ");
INSERT INTO gofe_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","ጎዳስ እሞታ ሺሽዶሶና። ኤንቲ እምዳ እሞታይ ናምኡ ሀላቃ ሱንꬃን እስ ፓራ ጋረ፥ ቃስ እስ እስ ሀላቃ ሱንꬃን እስ እስ ቦሩ ኦꬅድ፥ ኡሱፑን ጋረታነ ታማነ ናምኡ ቦራታ ጌሻ ዱንካንያ ኤህዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","ጎዳይ ሙሰኮ፥ ");
INSERT INTO gofe_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“ጌሻ ዱንካንያ ኦሱዋስ ጎአና መላ ኔኒ ሄ እሞታ ኤንታፈ ኤካዳ፥ ኤንታ ኦሱዋስ ኦሱዋስ ኮሸይሳዳ ሻካዳ ሌወታስ እማ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","ሄሳ ግሾ፥ ሙሰይ ጋረታነ ቦራታ ኤክድ ሌወታስ እሚስ። ");
INSERT INTO gofe_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","ገድሶና ኮቻስ ኮሸይሳዳ ሻክድ ኤንታ ኦሱዋስ ናምኡ ጋረታነ ኦይዱ ቦራታ እሚስ። ");
INSERT INTO gofe_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","መራራ ኮቻስ ኮሸይሳዳ ሻክድ፥ ኤንታ ኦሱዋስ ኡይዱ ጋረታነ ሆስፑን ቦራታ እሚስ። ኤንታ ኦሱዋ አዋተꬃን ካለይ ካህንያ አሮና ናኣ እታማራ። ");
INSERT INTO gofe_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","ሽን ቃሃታ ኮቻ ኦሶይ ዱንካንያ ጌሻ ሚሸታ ሀሸን ቶሆ ግድያ ግሾ ሙሰይ ኤንታዉ ፓራ ጋረነ ቦሩ እምቤና። ");
INSERT INTO gofe_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","ሙሰይ ያርሾ በሲ ጎዳስ ዱማይዳ ጋላስ ሀላቃት ያርሾ በሳ ስን ባንታ እሞታ ኤህዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","ጎዳይ ሙሰኮ፥ “እስ እስ ጋላስ እስ እስ ሀላቃይ ያርሾ በሲ ጎዳስ ዱማያናዉ ባ እሞታ እሞ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","ኮይሮ ጋላስ ባ እሞታ ኤህዳይ ይሁዳ ኮቻፈ አምናዳበ ናኣ ናአሶና። ");
INSERT INTO gofe_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","ናአሶን ኤህዳ እሞታይ ጌሻ ዱንካነን ኤረትዳ ምዛነን 1,500 ግራመ ብራፐ ኦሰትዳ ፕጫ ሳነ፥ 800 ግራመ ብራፐ ኦሰትዳ ኦላትያ ሳነ፥ ናምኣካ ካꬃ ያርሾ ያርሻናዉ ዛይተራ ዋላከትዳ ሎኦ ꬊለ ኩምዳይሳ፤ ");
INSERT INTO gofe_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","ቃስ 110 ግራመ ዎርቃፈ ኦሰትዳ እፃነይ ኩምዳ ሻተ፤ ");
INSERT INTO gofe_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","ፁሳ ያርሾስ፥ እስ ዎፋኖ፥ እስ ማራዘ፥ እስ ላይꬃ ኡርገ ዶርስ፤ ");
INSERT INTO gofe_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","ናጋራ ያርሾስ እስ ኮለ፤ ");
INSERT INTO gofe_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","እስፈተꬃ ያርሾስ ናምኡ ቦራታ፥ እቻሹ ማራዘታ፥ እቻሹ ኮለታነ እቻሹ ኡርገ ዶርሳታ ኤህስ። ካልያ ሀንኮ ሀላቃትካ አምናዳበ ናአይ ናአሶን እምዳይሳዳ ባንታ እሞታ ኤህዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","23","ናምአንꬆ ጋላሳን ይሳኮራ ኮቻፈ ዙአራ ናአይ ናትናኤል ባ እሞታ ኤህስ። ");
INSERT INTO gofe_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","29","ሄꬓንꬆ ጋላሳን ዛብሎና ኮቻፈ ሄሎና ናአይ ኤልኣብ ባ እሞታ ኤህስ። ");
INSERT INTO gofe_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","35","ኦይዳንꬆ ጋላሳን ሮቤላ፥ ኮቻፈ ሻደኡራ ናአይ ኤልዙር ባ እሞታ ኤህስ። ");
INSERT INTO gofe_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","40","እቻሻንꬆ ጋላሳን ስሞና ኮቻፈ ዙርሻዳያ ናአይ ሳሉምኤል ባ እሞታ ኤህስ። ");
INSERT INTO gofe_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","47","ኡሱፑንꬆ ጋላሳን ጋደ ኮቻፈ ራጉኤላ ናአይ ኤልያሳፍ ባ እሞታ ኤህስ። ");
INSERT INTO gofe_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","53","ላፑንꬃ ጋላሳን ኤፍሬማ ኮቻፈ አምሁዳ ናአይ ኤልሻማእ ባ እሞታ ኤህስ። ");
INSERT INTO gofe_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","59","ሆስፑንꬃ ጋላሳን ምናሰ ኮቻፈ ፓዳዙራ ናአይ ጋማልኤል ባ እሞታ ኤህስ። ");
INSERT INTO gofe_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","65","ኡዱፉንꬆ ጋላሳን ብንያመ ኮቻፈ ግዳኦና ናአይ አብዳን ባ እሞታ ኤህስ። ");
INSERT INTO gofe_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","71","ታማንꬆ ጋላሳን ዳነ ኮቻፈ አምሳዳያ ናአይ አክኤዘር ባ እሞታ ኤህስ። ");
INSERT INTO gofe_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","77","ታማነ እስንꬆ ጋላሳን አሴራ ኮቻፈ ኦክራና ናአይ ፓግኤል ባ እሞታ ኤህስ። ");
INSERT INTO gofe_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","83","ታማነ ናምአንꬆ ጋላሳን ንፍታለመ ኮቻፈ ኤናና ናአይ አክራ ባ እሞታ ኤህስ። ");
INSERT INTO gofe_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","ያርሾ በሳይ ትየትያ ዎደ ጎዳስ ዱማያናዉ እስራኤለ ሀላቃት ኤህዳ እሞታይ ሀይሳፈ ካልድ ደኤይሳ። ብራፐ ኦሰትዳ ታማነ ናምኡ ፕጫ ሳነታነ ኦላትያ ሳነታ፤ ዎርቃፈ ኦሰትዳ ታማነ ናምኡ እፃነይ ኩምዳ ሻተታ ኤህዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","እሶይ እሶይ 1,500 ግራመ ብራፐ ኦሰትዳ ፕጫ ሳነ፤ ቃስ እሶይ እሶይ 800 ግራመ ብራፐ ኦሰትዳ ኦላትያ ሳነ፥ ጌሻ ዱንካነን ኤረትዳ ምዛነን ሄ ኡባ 28 ክሎ ግራመ ኤህዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","እፃነይ ኩምዳ ታማነ ናምኡ ዎርቃ ሻተታ 1.4 ክሎ ግራመ ጌሻ ዱንካነን ኤረትዳ ምዛነን ሺሽዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","ፁሳ ያርሾስ ሺቅዳ መሄይ ካꬃ ያርሹዋራ ዎላ ታማነ ናምኡ ዎፋኖታ፥ ታማነ ናምኡ ማራዘ፥ ታማነ ናምኡ እስ ላይꬃ ኡርገ ዶርስነ፥ ታማነ ናምኡ ኮለታ ናጋራ ያርሾስ ሺሽዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","እስፈተꬃ ያርሾስ ላታማነ ኦይዱ ቦራት፥ ኡሱፑን ታሙ ማራዘታ፥ ኡሱፑን ታሙ ኮለታ፥ ኡሱፑን ታሙ እስ ላይꬃ ኡርገ ዶርሳታ ሺሽዶሶና። ጌሻ ዱንካንያ ዱማያናዉ ትያ ዎደ ሺቅዳ ያርሾት ሀይሳታ። ");
INSERT INTO gofe_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","ሙሰይ ጎዳራ ኦደታናዉ ጌሻ ዱንካንያ ገልያ ዎደ ጫቆ ታቦትያ ካማ ቦላ ደእያ ናምኡ ክሩበታፐ ግዶን ግድድ ጎዳይ ኦድሽን ስእስ። ");
INSERT INTO gofe_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","ጎዳይ ሙሰኮ፥ ");
INSERT INTO gofe_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“አሮን ላፑን ፆምፐታ ኮጫ ቦላ ዎꬅያ ዎደ ፖኦይ ስንꬃ ባጋራ ደእያ ሄራ ፖእሳና መላ ኦꬅድ ዎꬆ ጋዳ ኦዳ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","ጎዳይ ሙሰ ኪትዳይሳዳ፥ አሮን ፆምፐታ ኮጫ ቦላ ዎꬅድ ስንꬃ ባጋራ ደእያ ሄራ ፖእሳና መላ ኦꬅስ። ");
INSERT INTO gofe_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","ፆምፐ ዎꬅያ ኮጫይ፥ ጎዳይ ሙሰ በስዳይሳዳ ቶማፐ ብድ ቦላ ጪሻ ጋካናዉ ቆፀትዳ ዎርቃፈ ኦሰትስ። ");
INSERT INTO gofe_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","ጎዳይ ሙሰኮ፥ ");
INSERT INTO gofe_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“እስራኤለ አሳ ግዶፈ ሌወታ ሻካዳ ዎጋዳ ኤንታ ጌሻ። ");
INSERT INTO gofe_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","ኔኒ ኤንታ ጌሻናዉ ሀይሳዳ ኦꬃ፤ ጌሽያ ሃꬃ ኤካዳ ኤንታ ቦላ ዉርፃ፤ ኤንቲ ባንታ አሳተꬃ ኡባ ሜደቶ፤ ባንታ ማኡዋ ሜጮ፤ ያንድ ኤንቲ ዎጋዳ ጌሽ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","ካልድ ኤንቲ እስ ዎፋኖነ ካꬃ ያርሾስ ግድያ ዛይተራ ዋላሄትዳ ሎኦ ꬊለ ኤኮ፤ ቃስ ኔኒ ናጋራ ያርሾስ ሀራ እስ ዎፋኖ ኤካ። ");
INSERT INTO gofe_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","ሄሳፈ ጉየ እስራኤለ አሳ ኡባ ሺሻዳ፥ ሌወታ ጌሻ ዱንካንያ ስን ኤሀዳ ኤሳ። ");
INSERT INTO gofe_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","እስራኤለ አሳይ ኤንታ ሁጵያ ቦላ ባንታ ኩሽያ ዎꬆ። ");
INSERT INTO gofe_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","ሌወት እስራኤለ አሳ ግዶፈ ታዉ ዱማትድ ኦꬃና መላ ዩሾ ያርሾ ኦꬅድ አሮን ታ ስን ሺሾ። ");
INSERT INTO gofe_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","ሌወት ባንታ ኩሽያ ናምኡ ዎፋኖታ ሁጰን ዎꬆ። ሌወታ ናጋራ አቶተꬃስ እሱዋ ናጋራ ያርሾ፥ ቃስ ሀንኩዋ ፁሳ ያርሾ ኦꬃዳ ጎዳስ ያርሻ። ");
INSERT INTO gofe_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","“ሌወታ ሻካዳ ታዉ ዱማያ፤ አሮናነ እያ አደ ናይታ ኤንታ ቦላ ሹማ። ");
INSERT INTO gofe_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","ሄሳዳ ኦꬃዳ ሌወታ እስራኤለ አሳፐ ታዉ ዱማያ፤ ኤንቲ ታባ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","“ኔኒ ኤንታ ጌሽዳፐነ ዱማይዳፐ ጉየ ሌወት ጌሻ ዱንካንያን ባንታ ኦሱዋ ኦꬃናዉ ዮ። ");
INSERT INTO gofe_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","እስራኤለ አሳ ግዶፈ ኩመꬅ ኤንቲ ታዉ እመትዶሶና፤ እስራኤለን ባይራ የለትዳ አደ ናይታ በሳን ሌወታ ታዉ ኤካስ። ");
INSERT INTO gofe_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","እስራኤለ አሳ ግዶን ባይራ የለትዳ አሰ ግድን መሄ ግድን ኡባይ ታባ። ታኒ ግብፀ ቢታን ባይራ ኡባ ዎꬍዳ ዎደ ኤንታ ታዉ ዱማያስ። ");
INSERT INTO gofe_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","እስራኤለን ባይራ የለትዳ አደ ናይታ በሳን ታዉ ሌወታ ኤካስ። ");
INSERT INTO gofe_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","እስራኤለ አሳ ግዶፈ ሌወታ አሮናስነ እያ አደ ናይታስ እማስ። እስራኤለ አሳይ ጌሻ ዱንካንያኮ ሺቅድ ቆሄቶና መላ ሌወት እስራኤለ አሳ ግሾ ጌሻ ዱንካንያን ኦꬃናዉነ ናጋራ አቶተꬅ ኤሀናዉ ዶረትዶሶና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","ጎዳይ ሙሰ ኪትዳይሳዳ፥ ሙሰይ፥ አሮንነ እስራኤለ አሳ ኡባይ ሌወታ ዱማይዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","ሌወት ባንታና ጌሽዶሶና፤ ባንታ ማኡዋ ሜጭዶሶና። አሮን ኤንታ ጎዳስ ዱማ እሞ ኦꬅድ ሺሽስ፤ ኤንታዉ ናጋራ አቶተꬃስ ያርሽድ ኤንታ ጌሽስ። ");
INSERT INTO gofe_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","ሄሳፈ ጉየ፥ ሌወት አሮናነ እያ አደ ናይታ አዋተꬃ ጋርሳን ግድድ ጌሻ ዱንካንያ ግዶን ባንታ ኦሱዋ ኦꬃናዉ ይዶሶና። ጎዳይ ሙሰ ሌወታ ዱማያናዉ ኪትዳይሳዳ ኤንቲ ኦꬅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","ጎዳይ ሙሰኮ፥ ");
INSERT INTO gofe_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“ሀይስ ሌወት ኦꬃና ዎጋ፤ ላይꬅ ላታማነ እቻሻነ እያፐ ቦላ ግድዳ ሌወ አደ ኡባይ ጌሻ ዱንካንያን ኦꬃናዉ ዮ። ");
INSERT INTO gofe_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","ሽን ላይꬅ እሻታሙ ግድያ ዎደ ባንታ ኦሱዋፐ ሸምፖ፤ ዛር ኦꬆፎ። ");
INSERT INTO gofe_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","ኤንቲ ጌሻ ዱንካንያን ኦꬅያ ባንታ እሻታ ኦꬅ ማዳናዉ ዳንዳኦሶና። ሽን ኤንቲ ባንታዉ አይ ኦሶካ ኦꬆፎ። ህዛ ኔኒ ሌወታ ሀይሳዳ ኦስሳ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","እስራኤለ አሳይ ግብፀፈ ከይዳ ናምአንꬆ ላይꬃን ኮይሮ አጌናን ሲና መላ ቢታን ጎዳይ ሙሰኮ ሀይሳዳ ያግስ፤ ");
INSERT INTO gofe_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“እስራኤለ አሳይ ፓስካ ባኣለ እያ ቃማን ቦንቾ። ");
INSERT INTO gofe_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","ሀ አጌናን ታማነ ኦይዳንꬆ ጋላሳን እያ ቃማን ኦማርስ እያ ዎጋ ኡባዳነ እያ ኪታ ኡባዳ ቦንቾ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","ሄሳ ግሾ፥ ሙሰይ እስራኤለ አሳይ ፓስካ ባኣለ ቦንቻና መላ ኤንታዉ ኦድስ። ");
INSERT INTO gofe_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","ጎዳይ ሙሰ ኪትዳይሳዳ፥ እስራኤለ አሳይ ኮይሮ አጌናን ታማነ ኦይዳንꬆ ጋላሳን፥ ኦማርስ ሲና መላ ቢታን ፓስካ ባኣለ ቦንችዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","ሽን ኤንታፈ ባጋት አሀ ቦችድ ቱንዳ ግሾ ሄ ጋላስ ፓስካ ባኣለ ቦንቻናዉ ዳንዳእቦኮና። ሄሳ ግሾ፥ ኤንቲ ሄ ጋላስ ሙሰኮነ አሮናኮ ይድ፥ ");
INSERT INTO gofe_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","“ኑኒ አሀ ቦችዳ ግሾ ቱንዳ፥ ሽን ሄ ቃማን ሀራ እስራኤለ አሳራ ጎዳስ ያርሾ ያርሾና መላ አይስ ድገትዶ?” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","ሙሰይ ዛሪድ፥ “ጎዳይ ህንተባ ታዉ ኦዳና ጋካናዉ ጋምእሽተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","ጎዳይ ሙሰኮ፥ ");
INSERT INTO gofe_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“እስራኤለ አሳኮ ሀይሳዳ ያጋ፤ ህንተፈ ዎይኮ ህንተ ኮቻፈ ኦንካ አሀ ቦችድ ቱንኮ ዎይኮ ኦገትዳባ ግድኮ፥ ፓስካ ባኣለ ቦንቻናዉ ዳንዳኤስ። ");
INSERT INTO gofe_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","ናምአንꬆ አጌናን ታማነ ኦይዳንꬆ ጋላስ ኦማርስ ፓስካ ባኣለ ቦንቾ። ፓስካ ዶርሳ ኡይꬃራነ ጫሞ ቦንጮራ ሞ። ");
INSERT INTO gofe_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","ሳአይ ዎንታና ጋካናዉ ዶርሳ አሹዋፐ አይብካ አቶፎ፤ ቃስ እያ መቀꬃፈ እሱዋካ መንꬆፎ። ፓስካ ባልያ ዎጋ ኡባ ኦꬆ። ");
INSERT INTO gofe_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","ሽን ጌሽነ ኦገቶና አስ ፓስካ ቦንቾና እፅኮ፥ እ ታ አሳ ግዶፈ ኩረቶ። ጎዳ ያርሹዋ እያ ቃማን ያርሽቦና ግሾ ባ ናጋራ ግሾ ፕርዳ ኤኬስ። ");
INSERT INTO gofe_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“ህንተ ግዶን ደእያ በተ አስ ፓስካ ባኣለ ቦንቻናዉ ኮይኮ፥ ፓስካ ዎጋዳ ቦንቾ። በታንቾይነ ቢታ አዉ ናእ ኡባይ ሄ ዎጋꬆ ኦꬆ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","ጌሻ ዱንካነይ ቶከትዳ ጋላስ ሻራይ ጌሻ ዱንካንያ ማእስ። ኦማርሳፈ ዶምድ፥ ዎንታ ጋካናዉ ጌሻ ዱንካንያ ቦላራ ደእያ ሻራይ ታማ ዳኔስ። ");
INSERT INTO gofe_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","ሄሳዳ ጋላስ ጋላስ ሻራይ ማኤስ፤ ቃማ ቃማ ሄ ሻራይ ታማዳ ፖኤስ። ");
INSERT INTO gofe_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","ሄ ሻራይ ጌሻ ዱንካንያ ቦላፈ ደንድያ ዎደ ኡባን እስራኤለ አሳይ ባንታ ዱንካንዳ ጉታፐ ደንዶሶና። ቃስ ሄ ሻራይ ዎꬍያ በሳን እስራኤለ አሳይ ዱንካኖሶና። ");
INSERT INTO gofe_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","እስራኤለ አሳይ ጎዳ ኪታን ጉታፐ ደንዶሶና፤ ቃስ ጎዳ ኪታን ዱንካኖሶና። ሻራይ ጌሻ ዱንካንያ ቦላ ጋምእያ ዎደ ኡባን ባንታ ዱንካንዳ ጉታን ጋምኦሶና። ");
INSERT INTO gofe_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","ሻራይ ጌሻ ዱንካንያ ቦላ ዳሮ ጋላስ ጋምእኮካ፥ እስራኤለ አሳይ ጎዳ ኪታ ናጎሶናፐ አትሽን፥ አዉካ ቦኮና። ");
INSERT INTO gofe_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","እስ እስ ቶሆ ሻራይ ጌሻ ዱንካንያ ቦላ ጉꬃ ጋላስ ጋምኤስ። ግድኮካ ኤንቲ ጎዳ ኪታን ዱንካኖሶና፤ ቃስ ጎዳ ኪታን ጉታፐ ደንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","እስ እስ ቶሆ ሻራይ ኦማርሳፈ ዎንታና ጋካናዉ ፃላላ ጋምኤስ፤ ሻራይ ደንድያ ዎደ ኤንቲ ደንዶሶና። ጋላስ ግድን፥ ቃማ ግድን፥ ሻራይ ደንድያ ዎደ ኤንቲ ደንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","ሻራይ ጌሻ ዱንካንያ ቦላ ናምኡ ጋላስ ግድን ዎይኮ እስ አጌና ዎይኮ እስ ላይꬅ ጋምእን እስራኤለ አሳይ ባንታ ዱንካንዳ ጉታን ጋምኦሶናፐ አትሽን፥ ቦኮና። ሽን ሻራይ ደንድያ ዎደ ኤንትካ ደንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","ጎዳይ ሙሰ ኪትዳይሳዳ ኤንቲ ጎዳ ኪታን ዱንካኖሶና ቃስ ጎዳ ኪታን ጉታፐ ደንድድ ቦሶና። ");
INSERT INTO gofe_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","ጎዳይ ሙሰኮ፥ ");
INSERT INTO gofe_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","አሳ ሺቆስ ፄጋናዉነ ዱንካንዳ ጉታፐ ደንꬃናዉ ማድያ ናምኡ ሞይዘታ ብራፐ ቆፃዳ መꬋ። ");
INSERT INTO gofe_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","ሀ ናምኡ ሞይዘት ፑነትያ ዎደ አሳ ኡባይ ጌሻ ዱንካንያ ፐንገን ኔኮ ሺቆ። ");
INSERT INTO gofe_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","ሽን እስ ሞይዘ ፃላል ፑነትኮ፥ እስራኤለ ኮቻ ሀላቃት ነ ስን ሺቆ። ");
INSERT INTO gofe_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","ሞይዘይ ኮይሮ ፑነትያ ዎደ ጌሻ ዱንካንያፐ ዶሎሀ ባጋን ዱንካንዳ ኮቻይ ደንዶ። ");
INSERT INTO gofe_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","ሞይዘይ ናምአንꬆ ፑነትያ ዎደ ዱገሀ ባጋን ዱንካንዳ ኮቻይ ደንዶ። ሞይዘይ ሄሳꬆ ፑነትያ ዎደ ጉታፐ ደንዳናዉ ማላ ግዶ። ");
INSERT INTO gofe_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","አሳ ሺሻናዉ ሞይዘ ፑና፥ ሽን ሀንኮይሳዳ ዱማ ማላራ ፑኖፋ። ");
INSERT INTO gofe_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","ካህነት፥ አሮና ናይት ሞይዘ ፑኖ። ሀይስ ነዉነ ያና የለተꬃ ኡባስ መርና ዎጋ ግዶ። ");
INSERT INTO gofe_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","“ህንተ ጋድያ ቦላ ኦላ ደንꬅዳ ህንተ ሞርክያራ ህንተ ኦለታናዉ ከይያ ዎደ ሄ ሞይዘታ ጎችድ ፑንተ። ሄ ዎደ ጎዳይ፥ ህንተ ፆሳይ ህንተና አኬክድ፥ ህንተ ሞርከታፐ አሻና። ");
INSERT INTO gofe_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","ህንተ ኡፋይሳ ጋላሳታን ሄስካ አጌና ፄሮን፥ ኤረትዳ ባለታን፥ ፁሳ ያርሾ ዎደንነ እስፈተꬃ ያርሾ ዎደ ሞይዘ ፑንተ። ሄስ ፆሳ ስንꬃን ህንተና አኬክስያባ ግዳና። ታኒ ጎዳ፥ ህንተ ፆሳ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","አሳይ ግብፀፈ ከይን፥ ናምአንꬆ ላይꬃን፥ ናምአንꬆ አጌናን፥ ላታማንꬆ ጋላሳን፥ ሻራይ ጌሻ ዱንካንያ ቦላፈ ደንድስ። ");
INSERT INTO gofe_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","ያትን አሳይ ሲና መላ ቢታፈ ማራን ማራን ደንድዶሶና፤ ሻራይ ፓራና መላ ቢታ ጋክድ ዎꬍስ። ");
INSERT INTO gofe_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","ጎዳይ ሙሰ ኪትዳይሳዳ ኤንቲ ባናዉ ኮይሮ ደንድዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","ኮይሮ ይሁዳ ኮቻ ባጋን ዱንካንዳ ኮቻይ ባንታ ማላ ኤክድ ከይዶሶና። ኤንታና ካለይ አምናዳበ ናኣ ናአሶና። ");
INSERT INTO gofe_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","ይሳኮራ ኮቻ ካለይ ዙአራ ናኣ ናትናኤላ። ");
INSERT INTO gofe_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","ዛብሎና ኮቻ ካለይ ሄሎና ናኣ ኤልኣባ። ");
INSERT INTO gofe_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","ያትን፥ ጌሻ ዱንካነይ ሾደትን፥ ገድሶና ኮቻትነ መራራ ኮቻት ቶክድ ደንድዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","ካልድ ሮቤላ ኮቻ ባጋን ዱንካንዳ ኮቻይ ባንታ ማላ ኦይክደ ከይዶሶና። ሮቤላ ኮቻ ካለይ ሻደኡራ ናኣ ኤልዙራ። ");
INSERT INTO gofe_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","ስሞና ኮቻ ካለይ ዙርሻዳያ ናኣ ሳሉምኤላ። ");
INSERT INTO gofe_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","ጋደ ኮቻ ካለይ ራጉኤላ ናኣ ኤልያሳፋ። ");
INSERT INTO gofe_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","ያትን ቃሃታ ኮቻይ ጌሻ ሚሸታ ቶክድ ደንድዶሶና። ኤንቲ ካልያ ጉታ ጋካናፐ ስን ጌሻ ዱንካነይ ቶከትድ ኡቴስ። ");
INSERT INTO gofe_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","ካልድ ኤፍሬማ ኮቻ ባጋን ዱንካንዳ ኮቻት ባንታ ማላ ኦይክድ ከዮሶና። ኤፍሬማ ኮቻ ካለይ አምሁዳ ናኣ ኤልሻማአ። ");
INSERT INTO gofe_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","ምናሰ ኮቻ ካለይ ፓዳዙራ ናኣ ጋማልኤላ። ");
INSERT INTO gofe_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","ብንያመ ኮቻ ካለይ ጋድዮና ናኣ አብዳና። ");
INSERT INTO gofe_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","ዉርሰꬃን ዳነ ኮቻ ባጋን ዱንካንዳ ኮቻይ፥ ኡባስ ጉየ ባጋራ ካተ ግድድ፥ ባንታ ማላ ኦይክድ ከይዶሶና። ዳነ ኮቻ ካለይ አምሳዳያ ናኣ አክኤዘራ። ");
INSERT INTO gofe_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","አሴራ ኮቻ ካለይ ኦክራና ናኣ ፓግኤላ። ");
INSERT INTO gofe_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","ንፍታለመ ኮቻ ካለይ ኤናና ናኣ አክራ። ");
INSERT INTO gofe_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","እስራኤለ አሳይ ባንታ ዘረꬃን ዘረꬃን ጉታፐ ደንድድ ብያ ማራይ ሄሳ። ");
INSERT INTO gofe_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","ሙሰይ ምድያመ አድያ ራጉኤላ ናኣ ሆባባኮ፥ “ጎዳይ ኑስ እማና ግዳ ቢታ ላታናዉ ቦስ፤ ጎዳይ እስራኤለ አንጃና ግዳ ግሾ ኑራ የꬋ፤ ኑኒ ነዉ ሎኦባ ኦꬃና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","ያትን ሆባብ፥ “አካይ፥ ታኒ ታ ቢታ ታ ዳቦታኮ ባና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","ሙሰይ ዛሪድ፥ “ሀያና፥ ኑና የጋዳ ቦፓ። ኑ ብያ መላ ቢታን ኑኒ ዱንካናና በሳ ነ ኤራሳ፤ ኑ ባና ኦግያ ኑና ካለꬃናዉ ዳንዳኣሳ። ");
INSERT INTO gofe_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","ኔኒ ኑራ ቢኮ፥ ጎዳይ ኑስ እምያ አንጁዋ ኡባ ኑ ኔው ሻካና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","አሳይ ጎዳ ዙማፐ ደንድድ፥ ሄꬑ ጋላሳ ኦገ ብዶሶና። ጎዳ ጫቆ ታቦተይ ኤንቲ ሸምፓና በሲ ኮይሸ ሄꬑ ጋላስ ኤንታፈ ስን ስን ብስ። ");
INSERT INTO gofe_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","ኤንቲ ዱንካንዳ ጉታፐ ደንድያ ዎደ ኡባን ጎዳ ሻራይ ጋላስ ጋላስ ኤንታፈ ቦላራ ደኤስ። ");
INSERT INTO gofe_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","ታቦተይ ደንድያ ዎደ ኡባን ሙሰይ፥ “አቤት ጎዳዉ፥ ደንዳ፤ ነ ሞርከት ላለቶ፤ ነና እፀይሳት ነ ስንꬃፈ ባቃቶ” ያጌስ። ");
INSERT INTO gofe_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","ታቦተይ ሸምፕያ ዎደ ኡባን ሙሰይ፥ “አቤት ጎዳዉ፥ ዳሮ ሙኩላን ታይበትያ እስራኤለ አሳኮ ስማ” ያጌስ። ");
INSERT INTO gofe_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","እስራኤለ አሳይ ባንታና ጋክዳ መቱዋን ጎዳ ቦላ ዙዙምዶሶና። ኤንታ ዙዙንꬃ ጎዳይ ስእዳ ዎደ እያ ሀንቆይ ኤፅን፥ ፁግያ ታማ ኤንታ ቦላ የድስ፤ ሄ ታማይ ኤንቲ ዱንካንዳ ጉታፐ እስ ባጋ ጋፃ ምስ። ");
INSERT INTO gofe_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","ያትን ሙሰይ ኤንታ ግሾ ጎዳ ዎሳና መላ ኤንቲ ሙሰኮ ይድ ዬክዶሶና። ሙሰይ ዎስን ታማይ ቶእስ። ");
INSERT INTO gofe_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","ጎዳ ታማይ ኤንታ ግዶን ኤፅዳ ግሾ፥ ሄ በሳይ ታቤራ ጌተትድ ፄገትስ። ");
INSERT INTO gofe_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","እስራኤለታራ ግብፀፈ ከይዳ ዱማ ዱማ ደረይ ሀራ ካꬅ ማናዉ ዳሮ አሞትዶሶና። ኤንቲ፥ “ኑ አሾ አዉፐ ደማኔ? ");
INSERT INTO gofe_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","ኑኒ ግብፀን ደእያ ዎደ ሚሸ ቃንፆና ምያ ሞሉዋ፥ ሌህያ፥ ሀባበ፥ ሹንኩርተ፥ ምስካት ባይና ሹንኩርተነ ቱሙዋ ሀሳዮስ። ");
INSERT INTO gofe_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","ሽን ሀእ ኑ ቆይ ጎርደትስ፤ ኑ አይፈይካ ሀ ማናፈ አትሽን፥ ሀራባ አይባካ በኤና” ያግድ ዬክዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","ማናይ ዴቦ አይፈ ዳኔስ፤ እያ ማላይ ቦꬃ አድልኤ ጪሸ ዳኔስ። ");
INSERT INTO gofe_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","ማናይ ቃማ ዎꬌስ፤ አሳይ ዩይድ እያ ማፅድ ዎፃን ጋጭድ ዎይኮ ኡዱላን ጫድድ ካꬆሶና። ያትድ ኡኮሶና፤ እያ ማልኦይ ሻማሆ ዛይተራ ኡከትዳ ኡይꬃ መላ። ");
INSERT INTO gofe_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","ማን ቃማ ኤንታ ጉታን አካራ ዎꬌስ። ");
INSERT INTO gofe_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","አሳይ ባንታ ዱንካንያ ፐንገን ፐንገን ኤቅድ ዬክሽን ሙሰይ ስእስ። ኤንቲ ጎዳ ሀንቁዋ ደንꬅዳ ግሾ፥ ሙሰይ ኡንኤትስ። ");
INSERT INTO gofe_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","ሙሰይ ጎዳኮ፥ “ነ አይልያ፥ ታ ቦላ አይስ ሀ መቱዋ ኤሀዲ? ነ ታናን አይስ ኡፋይታብኪ? ነ ሀ አሳ ኡባ ቶሁዋ ታ ቦላ አይስ ዎꬃዲ? ");
INSERT INTO gofe_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","ሀ አሳ ኡባ ታ ቃንꬃታድናዬ? ዎይኮ ኤንታ ታ የላድናዬ? ነ ኤንታ ማይዛታስ፥ እማና ጋዳ ጫቅዳ ቢታ ጋꬆ ጋዳ ናአ እድማዳ ድችያ አሴዳ ታ ክኦን አይስ ኤንታ የጋዲ? ");
INSERT INTO gofe_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","ሀ አሳ ኡባስ ታ አሾ አዉፐ ኤሀኔ? ኤንቲ ታኮ ይድ፥ ‘ማናዉ ኑስ አሾ እማ’ ያግድ ዬኮሶና። ");
INSERT INTO gofe_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","ታኒ ሀ አሳ ኡባ ታርካ ቶካናዉ ዳንዳእከ፤ ታዉ ሄስ ዴፆ ቶሆ። ");
INSERT INTO gofe_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","ህዛ ኔኒ ታና ሀይሳዳ ኦꬃናፐ ታዉ ቃታ፤ ሀእ ታና ዎꬋ፤ ሀ መቱዋፐ ታ ሸምፓ አጋና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","ጎዳይ ሙሰኮ፥ “አሳ ካለꬃናዉ ዳንዳእያ እስራኤለ ሀላቃታፐ ላፑን ታሙ ጭማታ ዶራ። ኤንታ ጌሻ ዱንካንያኮ ኤሀዳ ነ ማታን ኤሳ። ");
INSERT INTO gofe_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","ታኒ ዎꬋዳ ኔራ ያን ኦደታና፤ ታ ነዉ እምዳ አያናፐ ሻካዳ ኤንታ ቦላ ዎꬃና። ኔኒ አሳ ቶሁዋ ነርካ ቶኮና መላ ኤንቲ ነና ማዳና። ");
INSERT INTO gofe_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","“ኔኒ አሳኮ ሀይሳዳ ያጋ፤ ‘ዎንቶ ህንተ አሾ ማና ግሾ ህንተና ጌሽተ። ኑ አሾ አዉፐ ደማኔ? ኑስ ግብፀን ሳእ ሎኦሽን’ ያግድ ህንተ ዬክዳ ዬሁዋ ጎዳይ ስእስ። ሀእ ጎዳይ አሾ እማና፤ ህንተካ ማና። ");
INSERT INTO gofe_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","ህንተ ማናይ እስ ጋላስ ዎይኮ ናምኡ ጋላስ ዎይኮ እቻሹ ጋላስ ዎይኮ ታሙ ጋላስ ዎይኮ ላታሙ ጋላስ ፃላላ ግደና። ");
INSERT INTO gofe_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","ሽን ‘ህንተ ግዶን ደእያ ጎዳ ህንተ ካꬍዳ ግሾነ ግብፀፈ ከዮና አትዳኮ ኑስ ሎኦሽን ግዳ ግሾ፥ ህንተዉ ሲራ ከያና ጋካናዉነ ህንተ ሳለታና ጋካናዉ እስ አጌና ኩመꬅ ህንተ አሾ ማና’ ያጋ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","ሽን ሙሰይ ጎዳኮ፥ “ሄኮ፥ ታ 600,000 አሳ ካለꬃሸ ደአይስ። ኔኒ እስ አጌና ኩመꬅ ኤንቲ አሾ ማና መላ እማና ጋሳ። ");
INSERT INTO gofe_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","ሚዛ ዉደነ ዶርሳ ዉደ ኡባ ሹክን ኤንታዉ ግዳኔ? አባን ደእያ ሞሎ ኡባ ሺሽያኮ ኤንታዉ ግዳኔ?” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","ያትን፥ ጎዳይ ሙሰኮ፥ “ጎዳ ኩሸይ ቃንዬ? ታኒ ነዉ ኦድያባይ ቱሜኮነ ዎርዶኮ ኔኒ ሀእ በአና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","ሄሳ ግሾ ሙሰይ ካረ ከይድ፥ ጎዳይ ግዳይሳ አሳስ ኦድስ። እስራኤለ ጭማታፐ ላፑን ታሙ አሳ ሺሽድ፥ ጌሻ ዱንካንያ ዩሾን ኤስስ። ");
INSERT INTO gofe_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","ያትን፥ ጎዳይ ሻራራ ዎꬍድ እያራ ኦደትስ፤ እያ ቦላ ደእያ አያናፐ ኤክድ፥ ሄ ላፑን ታሙ ጭማታ ቦላ ዎꬅስ። አያናይ ኤንታ ቦላ ሸምፕዳ ዎደ ኤንቲ ናበዳ ትንብተ ኦድዶሶና። ሽን ሄሳፈ ጉየ ዛሪድ ትንብተ ኦድቦኮና። ");
INSERT INTO gofe_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","ሄ ላፑን ታሙ ጭማታራ ፃፈትዳ አሳታፐ ኤልዳዳነ ሞዳዳ ጌተትያ ናምአት ዱንካንዳ ጉታን አትድ ጌሻ ዱንካንያኮ ይቦኮና። ሽን ኤንታ ቦላካ አያናይ ዎꬍን፥ ዱንካንዳ ጉታን ትንብተ ኦድዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","እስ ፓንꬃ አደይ ሙሰኮ ዎፅ ይድ፥ “ኤልዳድነ ሞዳድ ዱንካንዳ ጉታን ትንብተ ኦዶሶና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","ያንን፥ ባ ናአተꬃፈ ዶምድ፥ ሙሰ ማድያ ናወ ናኣ እያሱይ ሙሰኮ፥ “ታ ጎዳዉ፥ ሙሰ፥ ኤንታ ተቃ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","ሽን ሙሰይ ዛሪድ፥ “ታ ግሾ ነ ቃናታይ? ጎዳይ ባ አሳ ኡባ ቦላ ባ አያና ዎꬅድ ናበዳ ትንብተ ኦድስያባ ግድያኮ ታ ኡፋይታይስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","ያትድ፥ ሙሰይነ እስራኤለ ጭማት ዱንካንዳ ጉታ ስምዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","ቆፖና ጎዳይ ጫርኮ ደንꬅድ፥ ሳአፐ ናምኡ ዋꬋ መላ ꬎቁ ግድ ፕራꬍያ ኩራቾታ አባፈ ኤህስ። ኤንታ ዱንካንያ ዩሹዋን ኡባ ባጋራ እስ ጋላሳ ኦገ መላ ሳአን ዎꬍዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","ሄ ጋላስነ ሄ ቃማ ኡባ፥ ቃስ ዎንተꬃ ጋላስካ አሳይ ካረ ከይድ፥ ሄ ኩራቾታ ኦይክድ ሺሽዶሶና። ኤንታፈ ኦንካ 10 ክሎ ግራመፐ ጉꬁ ሺሽበና። ኤንቲ ዱንካንያ ጉታ ዩሾን መልሳናዉ ምጭዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","ሽን አሾይ ቡሮ ኤንታ ዶናን ደእሽንነ ሜተትድ ዉሮና ደእሽን፥ ጎዳ ሀንቆይ አሳ ቦላ ኤፅስ፤ ጎዳይ አሳ ዎልቃማ ቦሻን ሾጭስ። ");
INSERT INTO gofe_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","አሾ አሞትድ ሀይቅዳ አሳ ኤንቲ ሄ በሳን ሞግዳ ግሾ ሄ በሳይ ከብሮት-ሀታባ ጌተትድ ሱንትስ። ");
INSERT INTO gofe_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","አሳይ ሄ በሳፈ ደንድ ብድ ሀፀሮታ ጌተትያ በሳን ዱንካንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","ሙሰይ ቶጰ ቢታ ማጫስ ኤክዳ ግሾ፥ ማይራማነ አሮን ሙሰ ያግድ ቦርዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","“ጎዳይ ሙሰ ባጋራ ፃላላ ኦደትዴ? እ ኑ ባጋራ ኦድቤኔ?” ያግዶሶና። ጎዳይ ኤንቲ ግዳይሳ ስእስ። ");
INSERT INTO gofe_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","ሙሰይ ቢታን ደእያ አሳ ኡባፈ አꬍያ አዳ አስ። ");
INSERT INTO gofe_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","ቆፖና ጎዳይ ሙሰ፥ አሮናነ ማይራሞ፥ “ህንተ ሄꬓት ጌሻ ዱንካንያኮ ከይተ” ያግስ። ኤንትካ ከይዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","ጎዳይ ሻራ ቱሳራ ዎꬍድ ጌሻ ዱንካንያ ፐንገን ኤቅድ፥ አሮና! ማይራመ! ያግድ ፄግስ። ኤንቲ ናምአይ እያ ስን ሺቅን፥ ");
INSERT INTO gofe_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","ጎዳይ፥ “ታ ኦደይሳ ስእተ፤ ህንተ ግዶን ናበይ ደእኮ፥ ታ እያዉ ቆንጫይስ፤ ቃስ እያዉ አሙሆን ኦዳይስ። ");
INSERT INTO gofe_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","ሽን ታ አይለይ ሙሰ ሄሳዳ ግደና፤ እ ታ ኬꬃ ኡባን አማነትዳይሳ። ");
INSERT INTO gofe_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","ታኒ ሙሰራ ሶምኦን ኦደታስፐ አትሽን፥ ሌምሶን ኦድከ። እ ታ ማላ በኤስ። ያትን፥ ህንተ ታ አይልያ ሙሰ ቦራናዉ አይስ ያይበከቲ?” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","ጎዳ ሀንቆይ ኤንታ ቦላ ኤፅን፥ እ ኤንታ አግድ ብስ። ");
INSERT INTO gofe_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","ሻራይ ጌሻ ዱንካንያ ቦላፈ ደንድዳ ዎደ ማይራማ ባሮ ሀርገን ምልፅ ጋዳ ቦፃሱ። አሮን ኢኮ ስሚድ ፄልያ ዎደ ባሮ ሀርገን ኦይከትዳሮ በእስ። ");
INSERT INTO gofe_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","አሮን ሙሰኮ፥ “ሀይ ታ ጎዳዉ፥ ኑኒ ኤያተꬃን ኦꬅዳ ናጋራስ ኑና ሀይሳዳ ሴሮፓ። ");
INSERT INTO gofe_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","እዮ ባ አየ ኡሎፐ ከይያ ዎደ እ አሳተꬃፈ ባጋይ ሜተትን፥ ሀይቅድ የለትዳ ናአ መላ ኦꬆፋ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","ያትን፥ ሙሰይ፥ “አቤት ጎዳዉ፥ እዮ ፓꬃርክ” ያግድ ጎዳ ዎስስ። ");
INSERT INTO gofe_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","ጎዳይ ሙሰኮ፥ “እ አዋይ እ ሶምኦን ጩትያባ ግድያኮ፥ እያ ላፑን ጋላስ ዬላራ ጋምአዉሱ ግድኬ? ሄሳ ግሾ፥ ላፑን ጋላስ ዱንካንያ ጉታፐ እዮ ጋፃ ከሳዳ ዱማ በሳን ዎꬃ፤ ሄሳፈ ጉየ ስማዳ ዮ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","ያትን፥ ማይራማ ዱንካንያ ጉታፐ ጋፃ ከያዳ ላፑን ጋላስ ኡታሱ። እያ ስማና ጋካናዉ አሳይ ጉታ አግድ ባናዉ ደንድቤና። ");
INSERT INTO gofe_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","ሄሳፈ ጉየ፥ አሳይ ሀፀሮታ ጌተትያ በሳፈ ደንድድ፥ ፓራና መላ ቢታን ዱንካንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","ጎዳይ ሙሰኮ፥ ");
INSERT INTO gofe_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“ታኒ እስራኤለታስ እማና ካናነ ቢታ ዎቻና መላ ታማነ ናምኡ እስራኤለ ኮቻፈ እስ እስ አስ ሀላቃ ኦꬃዳ ኪታ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","ያትን ሙሰይ ጎዳይ ኪትዳይሳዳ ፓራና መላ ቢታፈ እስራኤለ ኮቻፈ ታማነ ናምኡ ሀላቃታ ኪትስ። ");
INSERT INTO gofe_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","ኤንታ ሱንꬃይ ሀይሳፈ ካልድ ፃፈትዳይሳታ። ሮቤላ ኮቻፈ ዛኩራ ናኣ ሳሙአ፤ ");
INSERT INTO gofe_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","ስሞና ኮቻፈ ሆራ ናኣ ሻፋፃ፤ ");
INSERT INTO gofe_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","ይሁዳ ኮቻፈ ዮፎና ናኣ ካለባ፤ ");
INSERT INTO gofe_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","ይሳኮራ ኮቻፈ ዮሰፋ ናኣ ይግኣላ፤ ");
INSERT INTO gofe_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","ኤፍሬማ ኮቻፈ ናወ ናኣ አውሰ፤ ");
INSERT INTO gofe_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","ብንያመ ኮቻፈ ራፉ ናኣ ፋልፃ፤ ");
INSERT INTO gofe_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","ዛብሎና ኮቻፈ ሶዳ ናኣ ጋድኤላ፤ ");
INSERT INTO gofe_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","ዮሰፋ ናኣ ምናሰ ኮቻፈ ሱሳ ናኣ ጋደ፤ ");
INSERT INTO gofe_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","ዳነ ኮቻፈ ጋማላ ናኣ አምኤላ፤ ");
INSERT INTO gofe_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","አሴራ ኮቻፈ ምካኤላ ናኣ ሳቱራ፤ ");
INSERT INTO gofe_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","ንፍታለመ ኮቻፈ ዋፍሳ ናኣ ናህባ፤ ");
INSERT INTO gofe_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","ጋደ ኮቻፈ ማካ ናኣ ገኡኤላ። ");
INSERT INTO gofe_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","ሄ ቢታ ዎቻና መላ ሙሰይ ኪትዳ አሳታ ሱንꬃይ ሀይሳታ። ሙሰይ ናወ ናኣ አውሰ ሱንꬃ እያሱ ግድ ሱንꬃ ላምስ። ");
INSERT INTO gofe_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","ሙሰይ ኤንታ፥ “ነገበ መላ ቢታ ካንꬅድ ፑደ ደረይ ዳርያ ቢታ ከይተ። ");
INSERT INTO gofe_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","ቢታይ አይ መላ ቢታኮ፥ አሳይ አይ መላ ምኖኮነ ታይቦን ጉኮ ዳሮኮ በእተ። ");
INSERT INTO gofe_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","ኤንቲ ደእያ ቢታይ ሎኦኮ ኢተኮ፥ ኤንታ ካታማት ድረትዳኮነ መላ ደእያኮ፥ ");
INSERT INTO gofe_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","ቢታይ አራደኮ ላደኮ፥ ቢታይ ዎራን ካመትዳኮነ ቁኤኮ በእተ። ምንተ፤ ሄ ቢታን ደእያ ካꬃ አይፍያፐ ኤኮና ዮፕተ” ያግስ። ሄ ዎደይ ዎይነይ ቴርድ ማፀትያ ዎደ። ");
INSERT INTO gofe_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","ኤንቲ ከይድ ሲና መላ ቢታፈ ዶምድ፥ ለቦ-ሀማታ ማታን ደእያ ረሆባ ጋካናዉ ደእያ ቢታ ዎችዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","ነገበ መላ ቢታ ካንꬅድ፥ ከብሮና ጋክዶሶና። ሄ በሳን አክማና፥ ሰሳያነ ታልማያ ጌተትያ ኤናቃ ኮቻት ደኦሶና። ከብሮን ግብፀን ደእያ ፆኣነ ካታማፐ ላፑን ላይꬅ ኮይሮትድ ኬፀትስ። ");
INSERT INTO gofe_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","ያራ ካንꬅድ፥ ኤሽኮላ ዛንጋራ ብድ ጋክያ ዎደ ቴራ ዎይነ ታሽያራ ቃንፅዶሶና። ሄ ታሸይ ዴፆ ግድያ ግሾ ናምኡ አስ ካሶ አꬅድ ቶክዶሶና። እያ ቦላ ጉጅድ ኦሮማነነ ባላሰ ምꬃ አይፈ ኤክድ ይዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","እስራኤለ አሳይ ሄ በሳፈ ዎይነ ታሽያ ቃንፅዳ ግሾ ሄ በሳ ኤሽኮላ ዛንጋራ ግድ ፄግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","ኤንቲ ሄ ቢታ ኦይታሙ ጋላስ ዎችድ ጉየ ስምዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","ፓራና መላ ቢታን ቃደሳን ደእያ ሙሰኮ፥ አሮናኮነ እስራኤለ ማባራ ኡባኮ ይዶሶና። ኤንቲ በእዳባ አሳ ኡባስ ኦድዶሶና፤ ሄ ቢታፈ ኤክድ ይዳ አይፍያካ ኤንታ በስዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","ኤንቲ ሙሰኮ፥ “ኔኒ ኑና የድዳ ቢታ ብዳ፤ ሄ ቢታን ማꬅነ ኤስ ጎጌስ፤ ሄ ቢታ አይፍያካ ሀይሳ በአ። ");
INSERT INTO gofe_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","ሽን ሄ ቢታን ደእያ አሳይ ዎልቃማ፤ ኤንታ ካታማትካ ግምበ ድርሳን ድረትዳይሳታነ ግታ። ኑኒ ኡባፈ አꬅድ ኤናቃ ኮቻታ ያን በእዳ። ");
INSERT INTO gofe_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","አማለቃት ነገበ መላ ቢታን፤ ህተትነ፥ ያቡሰት ደረይ ዳርያ አሞረታ ቢታን፤ ቃስ ካናነት መደትራነ አባ ዶናንነ ዮርዳኖሰ ሻፋ ጋፃን ደኦሶና” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","ያትን ካለብ አሳ ሙሰ ስንꬃን ስእ ኦꬅድ፥ “ኑኒ ፆናናዉ ዳንዳእያ ግሾ፥ ሀእ ከይድ ሄ ቢታ የግስድ አነ ኦይኮስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","ሽን ካለባራ ብዳ አሳት፥ “ሄ ቢታ አሳይ ኑፐ አꬍድ ምንያ ግሾ፥ ኑኒ ኤንታ ፆናናዉ ዳንዳኦኮ” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","ኤንቲ ዩይድ ዎችዳ ቢታባ እስራኤለ አሳስ ሀይሳዳ ያግድ ኢታ ኦዳ ኦድዶሶና። “ኑኒ ዎችዳ ቢታይ ያን ደእያ አሳካ ምያ ቢታ፤ ያን ደእያ አሳይካ ዳሮ አዱሰ። ");
INSERT INTO gofe_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","ኑኒ ያን ኤናቃ ኮቸ ግድዳ ንፍልመ አሳታ በእዳ። ኤንታ በእዳ አይፈን ኑና ፄልያ ዎደ ኑኒ ፃቆ መላ፤ ኤንትካ ኑና ሄሳዳ በኦሶና” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","ሄ ዎደ ቃማ ማባራ ኡባይ ባንታ ቃላ ꬎቁ ኦꬅድ ዬክዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","እስራኤለ አሳይ ሙሰ ቦላነ አሮና ቦላ ዙዙምዶሶና። ኩመꬃ ማባራይ፥ “ኑኒ ግብፀ ቢታን ደእሸ ዎይኮ ሀ መላ ቢታን ሀይቅዳ ግዶርኮ። ");
INSERT INTO gofe_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","ኑኒ ማሻን ዉራና መላ ጎዳይ ሀ ቢታ ኑና አይስ ኤሂ? ኑ ማቸትነ ኑ ናይት ድኤታና፤ ሄሳ ሀናናፐ ጉየ ግብፀ ስሞይ ኑስ ኬሄኔ?” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","ኤንቲ እሶይ እሱዋኮ፥ “ኑና ካለꬅያ አስ ዶርድ ጉየ ግብፀ ስሞስ” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","ያትን፥ ሙሰይነ አሮን ሄ በሳን ሺቅዳ እስራኤለ ማባራ ስንꬃን ሶምኦራ ሳአን ጉፋንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","ቢታ ዎቻናዉ ብዳ አሳ ግዶፈ ናወ ናኣ እያሱይነ ዮፎና ናኣ ካለብ ባንታ ማኡዋ ፔꬍዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","እስራኤለ ማባራኮ፥ “ኑኒ ካንꬅ ከይድ ዎችዳ ቢታይ ዳሮ ሎኦ። ");
INSERT INTO gofe_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","ጎዳይ ኑናን ኡፋይትያባ ግድኮ ማꬅነ ኤስ ጎግያ ቢታ ኑና ገልሳና፤ ሄ ቢታ ኑስ እማና። ");
INSERT INTO gofe_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","ሄሳ ግሾ፥ ጎዳ ቦላ ማካሎፍተ። ሄ ቢታ አሳስ ያዮፍተ፤ ኤንቲ ኑስ ኦይꬅካ ግዶኮና። ኤንታዉ ኤሾይ ባዋ፤ ጎዳይ ኑራ ደኤስ፤ ህንተ ኤንታዉ ያዮፍተ” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","ያትን እስራኤለ ማባራይ ኤንታ ሹቻን ጫዳናዉ ደንድስ። ሄ ዎደ ጎዳ ቦንቾይ ፆሳ ዱንካንያን እስራኤለ አሳ ኡባስ ቆንጭስ። ");
INSERT INTO gofe_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","ጎዳይ ሙሰኮ፥ “ሀ አሳይ ታና ካይ አዉደ ጋካናሴ? ታኒ ኤንታ ግዶን ኦꬅዳ ማላታታ በእሸ፥ አዉደ ጋካናዉ ታናን አማኖና እፃኔ? ");
INSERT INTO gofe_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","ታኒ ኤንታ ጋዶን ሾጫዳ ꬋይሳና፥ ሽን ነና ኤንታፈ ዳርያነ ምንያ ካዎተꬃስ አዋ ኦꬃና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","ሙሰይ ዛሪድ ጎዳኮ፥ “ኔኒ ነ ዎልቃን ሀ አሳ ግብፀፈ ከስዳይሳ ኤርያ ግብፀት ሄሳ ስእኮ ዎይጋኔ? ");
INSERT INTO gofe_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","ኤንቲ ሄ ቢታን ደእያ አሳስ ሄሳ ኦዳና። አቤት ጎዳዉ፥ ኔኒ ሀ አሳራ ደኤይሳ ኤንቲ ስእዶሶና። አቤት ጎዳዉ፥ ኑኒ ነና በእዳይሳ፥ ነ ሻራይ ኑ ቦላ ኩያትዳይሳነ ጋላስ ሻራ ቱሳን፥ ቃማ ታማ ቱሳን ኔኒ ኑና ካለꬅዳይሳ ኤንቲ በእዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","ያትን፥ ሀእ ኔኒ ሀ አሳ ኡባ እስ ቶሆ ዎꬋ ꬋይስያባ ግድኮ ነ ካሰ ኦꬅዳይሳ ስእዳ ካዎተꬃት፥ ");
INSERT INTO gofe_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘ጎዳይ፥ ሀ አሳስ እማና ግድ ጫቅዳ ቢታ ኤንታ ገልሳናዉ ዳንዳእቦና ግሾ መላ ቢታን ዎꬍ ꬋይስስ ያግድ’ ኦዳና። ");
INSERT INTO gofe_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","“ሄሳ ግሾ፥ ጎዳዉ፥ ነ ዎልቃ ኑና በሳ፤ ነ ኑስ ገልዳ ቃላ ቆፓ። ");
INSERT INTO gofe_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘ጎዳይ ኤለ ሀንቀተና፤ ማሮትነ ሲቆይ ኩምዳይሳ ናጋራነ ጌላተꬅ አቶ ገይሳ፤ ሽን ባልዳ ኡራ ሴሮና አገና። የልዳይሳታ ናጋራ ግሾ ሄꬓንꬆነ ኦይዳንꬆ የለተꬅ ጋካናዉ ናይታ ሴራና’ ያጋዳሳ። ");
INSERT INTO gofe_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","ሀ አሳይ ግብፀፈ ከዮሶፐ ዶማዳ ሀች ጋካናዉ ኤንታ ማርዳይሳዳ ነ መርና ሲቁዋን ሀ አሳ ናጋራ አቶ ጋርክ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","ጎዳይ ዛሪድ፥ “ነ ኦይችዳይሳዳ ታ ኤንታ ማራና። ");
INSERT INTO gofe_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","ሽን ታ ደኦ ግደይሳዳነ ታ ቦንቾይ ሳአ ኡባ ኩምዳይሳዳ፥ ");
INSERT INTO gofe_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","ሀ አሳፐ እስ አስካ ሄ ቢታ በኤና። ግብፀ ቢታንነ መላ ቢታን ኦꬅዳ ማላታታ ሀ አሳት በእዶሶና፤ ሽን ኤንቲ ታሙ ቶሆ ታና ፓጭድ ታዉ ኪተቶና እፅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","ሄሳ ግሾ፥ ታ ኤንታ ማይዛታስ እማና ጋዳ ጫቅዳ ቢታ ታና ካꬍዳይሳታፐ እሶይካ ገለና። ");
INSERT INTO gofe_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","ሽን ታ አይለይ ካለብ ኤንታፈ ዱማትያ ግሾነ ታና ፖሎ ዎዛናፐ ካልዳ ግሾ፥ እ ካሰ ዎችዳ ቢታ እያዉ እማና፤ እያ ዘረꬃይካ ሄ ቢታ ላታና። ");
INSERT INTO gofe_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","ሽን ሀእ አማለቃትነ ካናነት ዛንጋራን ደእያ ግሾ፥ ዎንቶ ዞኦ አባኮ ኤፍያ ኦግያ ኦይክድ መላ ቢታ ጉየ ስምተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","ጎዳይ ሙሰኮነ አሮናኮ፥ ");
INSERT INTO gofe_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“ሀ ኢታ አሳይ ታ ቦላ አዉደ ጋካናዉ ዙዙማኔ? ታኒ እስራኤለ አሳ ዙዙንꬃ ስአስ። ");
INSERT INTO gofe_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","ሄሳ ግሾ፥ ኔኒ ኤንታዉ ሀይሳዳ ጋዳ ኦዳ፤ ‘ታኒ ታ ደኡዋን ጫቃይስ፤ ህንተ ግዳይሳዳ ታ ህንተዉ ኦꬃና።’ ታኒ፥ ጎዳይ ሀይሳ ኦዳይስ። ");
INSERT INTO gofe_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","አሳይ ታይበትያ ዎደ ላይꬅ ላታማነ እያፐ ቦላ ግድዳ አስ ኡባይ ታ ቦላ ዙዙምዳ ግሾ፥ ህንተ አሀይ ሀ መላ ቢታን ኩንዳና። ");
INSERT INTO gofe_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","ዮፎና ናአ ካለባፐነ ናወ ናአ እያሱፐ አትሽን፥ ህንተፈ ኦንካ ታ ህንተና ላትሳናዉ ጫቅዳ ሄ ቢታ ገለና። ");
INSERT INTO gofe_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","ህንተ፥ ‘ኑ ናይት ድኤት አታና’ ግዳ ህንተ ናይታ፥ ሄ ህንተ ካꬍዳ ቢታ ገልሳና፤ ሄ ቢታይ ኤንታዉ ላታ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","ሽን ህንተ አሀይ ሀ መላ ቢታን ኩንድድ አታና። ");
INSERT INTO gofe_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","ህንተ አማነትቦና ግሾ፥ ህንተፈ ዉርሰꬃ አሀይ ሀ መላ ቢታን ኩንዳና ጋካናዉ፥ ህንተ ናይት ሀ መላ ቢታን ዋየትሸ ኦይታሙ ላይꬅ ዶርሰ ሄማና። ");
INSERT INTO gofe_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","ህንተ ቢታ ዎችዳ ኦይታሙ ጋላሳ ታይቦን፥ እስ ጋላሳስ እስ ላይꬅ፥ ኦይታሙ ላይꬅ ህንተ ናጋራ ግሾ ዋየታና፤ ሄ ዎደ ታ ህንተ ቦላ አይ መላ ሀንቀትዳኮ ህንተ ኤራና። ");
INSERT INTO gofe_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","እስፈ ታ ቦላ ደንድዳ ሀ ኢታ ማባራ ቦላ ታ ሀይሳዳ ኦꬃና፤ ኤንቲ ሀ መላ ቢታን ኩንድ አታና ሀይሳን ኤንቲ ሀይቃና፤ ታ ጎዳይ ሀይሳ ኦዳይስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","ሄ ቢታ ዎቻና መላ ሙሰይ ኪትዳ አሳት ስሚድ፥ ሄ ቢታባ ኢታ ኦዳ ኦድድ፥ ሙሰ ቦላ አሳይ ዙዙማና መላ ኦꬅዳይሳት፥ ");
INSERT INTO gofe_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","ጎዳ ስንꬃን ቦሻን ሀይቅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","ሄ ቢታ ዎቻናዉ ብዳ አሳፐ ዮፎና ናአይ ካለብነ ናወ ናአይ እያሱ ፃላል አትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","ሙሰይ ሄሳ እስራኤለ አሳስ ኦድዳ ዎደ አሳይ ዳሮ ዬክስ። ");
INSERT INTO gofe_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","ዎንተꬃ ጋላስ ዎንታ ጉራ ደንድድ፥ ገዘ ቢታ ከይድ፥ “ኑኒ ናጋራ ኦꬅዳ፥ ሽን ሀእ ጎዳይ ኑስ እማና ግዳ በሳ ፑደ ከያና” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","ሽን ሙሰይ ኤንታኮ፥ “ጎዳ ኪታ ህንተ አይስ መንቲ? ህንተዉ ሀነና። ");
INSERT INTO gofe_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","ጎዳይ ህንተራ ዶና ግሾ፥ ቦፕተ፤ ህንተ ሞርከት ህንተና ፆናና። ");
INSERT INTO gofe_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","አማለቃ አሳራነ ካናነ አሳራ ህንተ ኦለትድ ማሻን ሀይቃና። ጎዳስ ህንተ ኪተቶና እፅዳ ግሾ፥ ጎዳይ ህንተራ ዴና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","ሽን ኤንቲ ጎዳ ጫቆ ታቦተይነ ሙሰይ ጉታፐ ደንዶና ደእሽን፥ ደረይ ዳርያ ቢታ ባናዉ ምንድ ደንድዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","ያንን ደረይ ዳርያ ቢታን ደእያ አማለቃ አሳይነ ካናነ አሳይ ኤንታ ኦላን ፆንድ፥ ሆርማ ጋካናዉ ኤንታ የደꬅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","ጎዳይ ሙሰኮ፥ ");
INSERT INTO gofe_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“እስራኤለ አሳ ሀይሳዳ ያጋ፤ ህንተ ዳና መላ ታ ህንተዉ እምያ ቢታ ገልያ ዎደ፥ ");
INSERT INTO gofe_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","ፁሳ ያርሾ ግድን ዎይኮ ጋሶ ያርሾ ግድን ዎይኮ ዶሳን ያርሽያ ያርሾ ግድን ዎይኮ ባኣለ ጋላሳ ያርሾ ግድን፥ መሄፐ ዎይኮ ዶርሳፈ ጎዳስ ታማን ፁገትያ ሳውያ ያርሾ ያርሽተ። ");
INSERT INTO gofe_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","ያርሹዋ ያርሽያ ኡራይ ካꬃ ያርሹዋስ እስ ክሎ ግራመ ሎኦ ꬊለ ሳይሶ ልትሮ ሻማሆ ዛይተን ሙኑቀትዳይሳ ኤሆ። ");
INSERT INTO gofe_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","ቃስ ፁሳ ያርሾስ ዎይኮ ሀራ ያርሾስ ኤህያ እስ እስ ዶርሳራ ሳይሶ ልትሮ ዎይነ ኡሻ ያርሾ ኦꬅድ ጊግስተ። ");
INSERT INTO gofe_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","ማራዘ ያርሽያ ዎደ ናምኡ ክሎ ግራመ ሎኦ ꬊለ እስ ልትሮነ ባጋ ሻማሆ ዛይተን ሙኑቀትዳይሳ ኤህተ። ");
INSERT INTO gofe_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","ኡሻ ያርሹዋስ ስኮ ልትሮ ዎይነ ኡሻ ያርሹዋስ ኤህተ። ሄስ ጎዳስ ሳውያ ያርሾ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","ጋሶ ዎይኮ እስፈተꬃ ያርሾስ ዎፋኖ ፁሳ ያርሾ ኦꬃዳ ጎዳስ ያርሽያ ዎደ፥ ");
INSERT INTO gofe_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","ዎፋኑዋራ እስፈ ሄꬑ ክሎ ግራመ ሎኦ ꬊለ፥ ናምኡ ልትሮ ሻማሆ ዛይተን ሙኑቀትዳይሳ ካꬃ ያርሾ ኦꬃዳ ኤሀ። ");
INSERT INTO gofe_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","ኡሻ ያርሹዋስ ባጋ ልትሮ ዎይነ ኡሻ ኤህተ። ሄስ ጎዳስ ሳውያ ፁሳ ያርሾ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","“እስ እስ ዎፋኖይ ዎይኮ እስ እስ ማራዘይ ዎይኮ እስ እስ ኮለይ ያርሸትያ ዎደ ሀይሳዳ ሀንድ ኦሰቶ። ");
INSERT INTO gofe_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","ዳሮ መሄይ ያርሸትያ ዎደ ያርሸትያ ካꬃ ያርሾይካ ሄሳዳ ዳሮ። ");
INSERT INTO gofe_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","እስራኤለ አስ ግድዳ ኦንካ ሳውያ ፁሳ ያርሾ ጎዳስ ያርሽያ ዎደ ኡባን ሀይሳዳ ኦꬃናዉ ኮሼስ። ");
INSERT INTO gofe_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","ያና የለተꬃን ህንተ ግዶን ደእያ በተ ዎይኮ ሀራ አስ ኦንካ ሳውያ ፁሳ ያርሾ ጎዳስ ያርሻናዉ ኮይኮ ሄሳዳ ኦꬃናዉ ኮሼስ። ");
INSERT INTO gofe_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","ህንተዉነ ህንተ ግዶን ደእያ በተ አሳስ ሄ ዎጋይ እስኖ፤ ሄስ ያና የለተꬃስካ ኤቅድ ዳና ዎጋ፤ ህንተካ በተ አሳትካ ጎዳ ስንꬃን እስኖ። ");
INSERT INTO gofe_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","ህንተዉነ ህንተ ግዶን ደእያ በተ አሳስ ህገይነ ዎጋይ እስኖ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","ጎዳይ ሙሰኮ፥ ");
INSERT INTO gofe_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“እስራኤለ አሳስ ሀይሳዳ ጋዳ ኦዳ፤ ታኒ ህንተና ኤፍያ ቢታ ህንተ ገልድ፥ ");
INSERT INTO gofe_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","ሄ ቢታን ካፅያ ካꬅ ህንተ ምያ ዎደ ሄ ካꬃፈ ፄራ ከስድ ህንተ ጎዳስ ያርሽተ። ");
INSERT INTO gofe_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","ሄስካ፥ ባይራ ካፅዳ ካꬃፈ ኡክዳ ኮይሮ ኡይꬅ፥ ግድሽን፥ ካꬅ ቡክያ ዉዱማፈ እምያ ያርሾ ኦꬅድ ያርሽተ። ");
INSERT INTO gofe_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","የለተꬃ ኡባን ህንተ ቢታን ካፅዳ ካꬃፈ ኮይሩዋ ኡክድ ጎዳስ ያርሾ ያርሽተ። ");
INSERT INTO gofe_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“ጎዳይ፥ ሙሰስ ኦድዳ ኪታ ህንተ ኤሮና እፅድ ናጎና አትኮ፥ ");
INSERT INTO gofe_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","ዎይኮ ጎዳይ እያ ባጋራ እምዳ ኪታ ኡባ፥ ጎዳይ እምዳ ጋላሳፐ ዶምድ ያና የለተꬃ ጋካናዉ ናጎና እፅኮ፥ ");
INSERT INTO gofe_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","ቃስ ሄሳ እስራኤለ ማባራይ ኤሮና ኦꬅዳባ ግድኮ ማባራ ኡባይ ጎዳስ እስ ዎፋኖ ሳውያ ፁሳ ያርሾ ኦꬅድ፥ ዎጋይ ኪተይሳዳ ካꬃ ያርሹዋራነ ኡሻ ያርሹዋራ ያርሾ፤ ቃስ ናጋራ ያርሾ ኦꬅድ እስ ኮለ ያርሾ። ");
INSERT INTO gofe_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","ካህነይ ኩመꬃ እስራኤለ ማባራስ ናጋራ አቶተꬃ ያርሾ ሺሼስ። ኤንቲ ኤሮና ባልዳ ባንታ ናቁዋ ግሾ ጎዳስ ፁሳ ያርሾነ ናጋራ ያርሾ ያርሽዳ ግሾ ኤንታ ናጋራይ አቶ ጌተታና። ");
INSERT INTO gofe_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","እስራኤለ ማባራይነ ኤንታ ግዶን ደእያ በተ አሳይ ኤሮና ሄ ባላ ኦꬅዳ ግሾ አሳ ኡባ ናጋራይ አቶ ጌተታና። ");
INSERT INTO gofe_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“እስ አስ ኤሮና ናጋራ ኦꬅኮ እስ ላይꬃ ኮለ ናጋራ ያርሾ ኦꬅድ ያርሾ። ");
INSERT INTO gofe_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","ኤሮና ደእሸ ናጋራ ኦꬅዳ ኡራስ ካህነይ ጎዳ ስንꬃን ናጋራ አቶተꬃ ዎጋ ፖሎ፤ እያ ናጋራይ አቶ ጌተታና። ");
INSERT INTO gofe_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","ኤሮና ናጋራ ኦꬅዳ ኡራስ ካህነይ ጎዳ ስንꬃን ናጋራ አቶተꬃ ዎጋ ፖሎ፤ እያ ናጋራይ አቶ ጌተታና። ");
INSERT INTO gofe_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“ሽን እስራኤለ አስ ግድን ዎይኮ በተ አስ ግድን ኤርሸ ኦቶሮን ናጋራ ኦꬅያ ኡራይ ጎዳ ጫዬስ። ሄ ኡራይ ደርያ ግዶፈ ꬋዮ። ");
INSERT INTO gofe_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","ሄ ኡራይ ጎዳ ኪታ ኤርሸ ካꬍዳ ግሾነ እያ ኪታ ካዉሽዳ ግሾ እያዉ ꬋዮይ በሴስ። እያ ባላይ እያ ቦላ ግዶ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","እስ ጋላስ እስራኤለ አሳይ መላ ቢታን ደእሽን፥ እስ ኡራይ ሳምባታ ጋላስ ምꬅ ምፅሸ ኦይከትስ። ");
INSERT INTO gofe_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","ሄ ኡራ አሳይ ሙሰኮ፥ አሮናኮነ እስራኤለ ማባራኮ ኤህዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","ኤንቲ እያ ቦላ ኦꬃናባ ኤርቦና ግሾ ቃሾን ጋምእስዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","ሄሳፈ ጉየ ጎዳይ ሙሰኮ፥ “ሀ ኡራይ ሀይቃናዉ በሴስ፤ እስራኤለ ማባራይ ባንታ ጉታፐ ጋፃ ከስድ ሹቻን ጫድድ ዎꬎ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","ያትን እስራኤለ ማባራ ኡባይ ጎዳይ ሙሰ ኪትዳይሳዳ፥ ጉታፐ ጋፃ ከስድ ሹቻን ጫድድ ዎꬍዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","ጎዳይ ሙሰኮ፥ ");
INSERT INTO gofe_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“እስራኤለ አሳስ ሀይሳዳ ጋዳ ኦዳ፤ ህንተነ ያና የለተꬃይ ህንተ አፍላ ጋፃን ማጫራ ከስድ ሄ ማጫራ ጋፃን ካሎሰ ቃጭና ስክተ። ");
INSERT INTO gofe_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","ሄ ማጫራ ህንተ በእያ ዎደ ኡባን ታ ኪታታ፥ አኬክድ ፖሌታ፤ ታፐ ሃክድ ህንተ አይፍያ አሙዋነ ህንተ ዎዛና ቆፋ ካልድ ላመተከታ። ");
INSERT INTO gofe_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","ሄ ማጫራ በእድ ህንተ ታ ኪታ ኡባ አኬክድ ፖላናነ ፆሳስ ዱማትዳይሳታ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","ታኒ ጎዳ፥ ህንተ ፆሳ፤ ታ ህንተ ፆሳ ግዳናዉ ህንተና ግብፀፈ ከሳስ። ታኒ ጎዳ፥ ህንተ ፆሳ ያጋ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","ሌወ ኮቻፈ ቃሃታ ኮቸ ግድዳ ይስአራ ናአይ ቆረይ፥ ሮቤላ ኮቻፈ ኤልኣባ ናይት ዳታነይነ አቤሮይ ቃስ ፋለታ ናአይ ኦን፥ ");
INSERT INTO gofe_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","ሙሰ ቦላ ደንድዶሶና። ኤንታራ ናምኡ ፄታነ እሻታሙ አሳት ደኦሶና፤ ሄ አሳት አሳን ኤረትዳይሳታነ ማባራ ካለይሳታ። ");
INSERT INTO gofe_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","ኤንቲ ሙሰነ አሮና ስን ሺቅድ፥ “ህንተ ዳርስደታ፤ ማባራ ኡባይ ጌሽ፤ ጎዳይ ኤንታራ ደኤስ። ያትን፥ ጎዳ ማባራ ቦላ ህንተና አይስ ꬎቁ ꬎቁ ኦቲ?” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","ሙሰይ ሄሳ ስእዳ ዎደ ጎዳ ስንꬃን ጉፋንስ። ");
INSERT INTO gofe_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","ቆረኮነ እያ ጩጋኮ፥ “ጎዳይ ዎንቶ ዎንታ ኦን እያ ባገኮነ ኦን ጌሸኮ በሳና፤ ሄ እ ዶርዳ ኡራ ባኮ ሺሻና፤ ሄ ኡራይ እያኮ ሺቃና። ");
INSERT INTO gofe_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","ዎንቶ ዎንታ ኔራነ ነ አሳራ ሀይሳ ኦꬅተ፤ እፃነ ጩይስያ ሚሸ ኤክድ፥ ");
INSERT INTO gofe_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","ቦንቆ ታማ እያን ዎꬅድ፥ ጎዳ ስንꬃን እፃነ ጩይስተ። ጎዳይ ዶርያ ኡራይ እ ጌሽ ግዳና። ህንተ፥ ሌወት ዛዋፐ አꬍደታ።” ");
INSERT INTO gofe_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","ቃስካ ሙሰይ ቆረኮ፥ “ህንተ ሌወት ስእተ። ");
INSERT INTO gofe_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","እስራኤለ ፆሳይ ህንተና ባ ማባራ ግዶፈ ዱማይድ፥ ጌሻ ዱንካንያን ኦꬃና መላነ ባ አሳ ስንꬃን ኤቅድ ሀጋዛና መላ ባኮ ሺሽዳይስ ህንተዉ ጉፅዴ? ");
INSERT INTO gofe_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","እ ህንተናነ ህንተ እሻታ ሌወታ ኡባ ባኮ ሺሽስ፤ ሽን ሀእ ህንተ ካህነታ በሳ ኮዬታ። ");
INSERT INTO gofe_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","ኔንነ ነ ጩጋ ኡባይ ጎዳ ቦላ ማካልድ ደንድደታ፤ ህንተ እያ ቦላ ዙዙማናዉ እ አሮን ኦኔ?” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","“ያትድ፥ ሙሰይ፥ ኤልኣባ ናይታ፥ ዳታነነ አቤሮ ፄግስስ፤ ሽን ኤንቲ፥ ‘ኑኒ ቦኮ’ ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","ኔኒ መላ ቢታን ኑና ዎꬋናዉ ማꬅነ ኤስ ጎግያ ቢታፈ ኑና ከስዳይስ ጉፅስ ጋዳ ሀእ ኑ ቦላ ሀላቃ ግዳናዉ ኮያይ? ");
INSERT INTO gofe_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","ኔኒ ኑና ማꬅነ ኤስ ጎግያ ቢታ ገልሳባካ፤ ዎይኮ ኔኒ ኑስ ላታ ኦꬃዳ ጎሻ ጋደነ ዎይነ ጋደ እማባካ፤ ኔኒ ኑና ጭማሳ፤ ኑኒ ቦኮ” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","ያትን፥ ሙሰይ ዳሮ ሀንቀትድ፥ ጎዳኮ፥ “ኔኒ ኤንታ ያርሹዋ ኤኮፋ፤ ታ ኤንታፈ እሱዋካ ቆሀብከ፤ ቃስ ሀር አቶሽን እስ ሀረካ ኤንታፈ ኤካብከ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","ቃስ ሙሰይ ቆረኮ፥ “ዎንቶ ኔራነ ነ አሳራ ሄሳዳ አሮንካ ጎዳ ስን ሺቅተ። ");
INSERT INTO gofe_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","እስ እስ አስ ባ እፃነ ጩይስያ ሚሽያ ኤኮ፤ እፃነካ እያን ዎꬆ፤ ኡባይ እስፈ ናምኡ ፄታነ እሻታሙ እፃነ ጩይስያ ሚሸ ግዴስ፤ እፃነ እያን ዎꬅድ ጎዳ ስን ሺሾ። ኔኒነ አሮን ህንተ እፃንያ ሄሳዳ ሺሽተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","ያትን፥ እስ እስ አስ ባ ሚሸን እፃነነ ታማ ቦንቆ ዎꬅድ ጌሻ ዱንካንያ ፐንገን ሙሰራነ አሮናራ እስፈ ኤቅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","ቆረይ ባ አሳራ ጌሻ ዱንካንያ ፐንገን ሙሰ ስንꬃንነ አሮና ስንꬃን ኤቅዶሶና። ሄ ዎደ ጎዳ ቦንቾይ ኩመꬃ ማባራስ ቆንጭስ። ");
INSERT INTO gofe_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","ጎዳይ ሙሰኮነ አሮናኮ፥ ");
INSERT INTO gofe_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“ታኒ እስ ቶሆ ሀ አሳ ꬋይሳና ግሾ፥ ኤንታፈ ሻከትተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","ሽን ሙሰይነ አሮን ሳአን ጉፋንድ፥ “አቤት ፆሳዉ፥ አሳ ሸምፖ ኡባ መꬍዳ ፆሳዉ፥ እስ አስ ናጋራ ኦꬅኮ፥ ኔኒ ኩመꬃ ማባራ ሀንቀታዬ?” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","ያትን፥ ጎዳይ ሙሰኮ፥ ");
INSERT INTO gofe_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“አሳስ ‘ቆረ፥ ዳታነነ አቤሮ ዱንካንያ ማታፐ ክችተ’ ጋዳ ኦዳ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","ሙሰይ ደንድድ፥ ዳታነኮነ አቤሮኮ ብን፥ እስራኤለ ጭማት እያ ካልዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","እ ማባራኮ፥ “ሀ ኢታ አሳ ዱንካንያ ማታፐ ክችተ፤ ኤንታባ አይብባካ ቦቾፍተ። አካይ፥ ጊኮ፥ ኤንታ ናጋራ ጋሶን ህንተካ ፕተትድ ꬋያና” ያግድ ምንꬅድ ኦድስ። ");
INSERT INTO gofe_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","ያትን አሳይ ቆረ፥ ዳታነነ አቤሮ ዱንካንያ ማታፐ ክችዶሶና። ዳታነይነ አቤሮይ ካረ ከይድ፥ ባንታ ማቸታራነ ባንታ ናይታራ ባንታ ዱንካነታ ፐንገን ኤቅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","ሙሰይ አሳኮ፥ “ታኒ ሀ ኦሶ ኡባ ኦꬃና መላ፥ ጎዳይ ታና ኪትዳይሳነ ታኒ ታ ሸነን ኦꬆናይሳ ህንተ ኤራናይ ሀይሳና። ");
INSERT INTO gofe_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","ሀ አሳት አስ ሀይቀይሳዳ ሀይቅኮ ዎይኮ አሳ ቦላ ጋክያባ ፃላል ኤንታ ቦላ ጋክኮ ጎዳይ ታና ኪትቤና። ");
INSERT INTO gofe_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","ሽን፥ ጎዳይ ኦራꬃባ ኦꬅድ፥ ቢታይ ዶየትድ ኤንታነ ኤንታዉ ደእያባ ኡባ ምትኮነ ኤንቲ ፓፃ ደእሸ ዱፎ ገልኮ ሄ ዎደ ሀ አሳት ጎዳ ካꬍዳይሳ ህንተ ኤራና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","እ ያግድ ኦንግዳ ዎደ ኤንቲ ኤቅዳ ቢታይ ዶየትድ፥ ");
INSERT INTO gofe_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","ኤንታነ ኤንታ ሶ አሳ፥ ቆረ ጩጋ ኡባነ ኤንታዉ ደእያባ ኡባ ምትስ። ");
INSERT INTO gofe_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","ያትን ኤንቲ ባንታዉ ደእያባ ኡባራ ፓፃ ደእሸ፥ ዱፎ ገልዶሶና። ቢታይ ኤንታ ቦላ ጎርደትስ፤ ኤንቲ ማባራ ግዶፈ ꬋይዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","ኤንታ ዋሱዋ ጋሶን ኤንታ ማታን ደእያ እስራኤለ አሳ ኡባይ፥ “ቢታይ ኑናካ ምታና ሀኔስ” ያግድ ባቃትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","ቃስ ታም ጎዳ ማታፐ ይድ እፃነ ጩይስያ ናምኡ ፄታነ እሻታሙ አሳ ምስ። ");
INSERT INTO gofe_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","ሄሳፈ ጉየ ጎዳይ ሙሰኮ፥ ");
INSERT INTO gofe_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“ካህነይ፥ አሮና ናኣ አላዛር ናሰ ብራታፐ ኦሰትዳ እፃነ ጩይስያ ሚሸታ ፁገትዳ አሳፐ ኤክድ፥ ሄ ሚሸት ጌሽ ግድያ ግሾ፥ ቦንቆ ታማ ሀራ ሶ ኤፍድ ላላና መላ ኦዳ። ");
INSERT INTO gofe_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","ሄ ሚሸት ባንታ ደኡዋ ꬋይሳናዉ ናጋራ ኦꬅዳ አሳይ እፃነ ጩይስያ ሚሸ። ሄ ሚሸት ጎዳስ እመትዳ ግሾነ ጌሽ ግድያ ግሾ ሌእሳ ቆፃዳ ያርሾ በሳ ላንፃ። ሄስ እስራኤለ አሳስ ናግሶ ማላ ግዶ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","ያትን ካህነይ አላዛር እፃነ ጩይስያ ሚሸታ ኤክድ ያርሾ በሳ ላንፃናዉ ሌእስድ ቆፅስ። ");
INSERT INTO gofe_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","ጎዳይ ሙሰ ባጋራ ኪትዳይሳዳ፥ አሮና ኮቸ ግዶና ኦንካ ጎዳ ስንꬃን እፃነ ጩይሳናዉ ሺቆና መላ፥ እፃስ ጊኮ፥ ቆረ ቦላነ እያ ካለይሳታ ቦላ ጋክዳይስ እያ ጋኮና መላ እስራኤለ አሳ አኬክሳናዉ ሀይሳታ ኦꬅስ። ");
INSERT INTO gofe_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","ዎንተꬃ ጋላስ እስራኤለ ማባራ ኡባይ፥ “ጎዳ አሳ ህንተ ዎꬍደታ” ያግድ ሙሰ ቦላነ አሮና ቦላ ዙዙምዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","ኤንቲ ሙሰነ አሮና ቦላ ደንዳናዉ ሺቅድ፥ ኤንቲ ጌሻ ዱንካንያ ፄልያ ዎደ ሻራይ ጌሻ ዱንካንያ ካምን፥ ጎዳ ቦንቾይ ቆንጭስ። ");
INSERT INTO gofe_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","ሄሳፈ ጉየ፥ ሙሰይነ አሮን ጌሻ ዱንካንያ ስን ይድ ኤቅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","ያትን ጎዳይ ሙሰኮ፥ ");
INSERT INTO gofe_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“ሀ አሳ ግዶፈ ክችተ፤ ታ ኤንታ እስ ቶሆን ꬋይሳና” ያግስ። ሙሰይነ አሮን ሳአን ጉፋንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","ሙሰይ አሮናኮ፥ “እፃነ ጩይስያ ነ ሚሽያ ኤካዳ ያርሾ በሳፈ ቦንቆ ታማ ኤካዳ እያን ዎꬃ፤ እያ ቦላ እፃነ ጉጃዳ እስራኤለ ማባራኮ ኤፋ። ጎዳ ሀንቆይ እያ ማታፐ ከይ ክችስ፤ ቦሻይካ ዶምስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","ያትን አሮን፥ ሙሰይ ኪትዳይሳዳ ባ እፃነ ጩይስያ ሚሽያ ኤክድ ማባራ ግዶ ዎፅድ ገልስ። ቦሻይ አሳ ዎꬎ ኦይክስ ሽን፥ አሮን እፃነ ጩይስድ አሳስ አቶተꬅ ኤህስ። ");
INSERT INTO gofe_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","ያትድ፥ እ ሀይቅዳይሳታነ ፓፃታ ግዶን ኤቅን፥ ቦሻይ አግስ። ");
INSERT INTO gofe_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","ቆረ ጋሶን ሀይቅዳ አሳይ አትሽን፥ ሄ ቦሻን ሀይቅዳ አሳ ታይቦይ 14,700. ");
INSERT INTO gofe_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","ቦሻይ ኤቅዳፐ ጉየ፥ አሮን ጌሻ ዱንካንያ ፐንገን ደእያ ሙሰኮ ስምስ። ");
INSERT INTO gofe_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","ጎዳይ ሙሰኮ፥ ");
INSERT INTO gofe_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“እስራኤለ አሳይ እስ እስ ኮቻ ሀላቃታፐ እስ እስ ፃምአ ኤክድ ታማነ ናምኡ ፃምአ ነዉ ኤሀና መላ ኤንታዉ ኦዳ። ሄ ፃምኣ ቦላ እስ እስ አሳ ሱንꬃ ፃፋ። ");
INSERT INTO gofe_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","እስ እስ ኮቻ ሀላቃስ እስ ፃምአ ኮሽያ ግሾ፥ ሌወ ፃምኣ ቦላ አሮና ሱንꬃ ፃፋ። ");
INSERT INTO gofe_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","ሄ ፃምአታ ጌሻ ዱንካንያ ግዶን ታ ኔራ ጋሄትያ ታቦትያ ስንꬃን ዎꬃ። ");
INSERT INTO gofe_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","ታ ዶርያ ኡራ ፃምአይ አጫና፤ ሄሳዳ ኦꬃዳ ህንተ ቦላ እስራኤለ አሳ ዙዙንꬃ ታ ተቃና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","ሄሳ ሙሰይ እስራኤለ አሳስ ኦድን፥ ታማነ ናምኡ ሀላቃት ሁጰን ሁጰን እስ እስ ፃምአ ኤህዶሶና። አሮና ፃምአይካ ሄ ፃምአታ ግዶን ደኤስ። ");
INSERT INTO gofe_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","ሙሰይ ሄ ፃምአታ ኡባ ጌሻ ዱንካንያ ግዶን ጎዳ ስንꬃን ዎꬅስ። ");
INSERT INTO gofe_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","ዎንተꬃ ጋላስ ሙሰይ ጌሻ ዱንካንያ ግዶ ገልያ ዎደ ሌወ ኮቸ ግድዳ አሮና ፃምአይ አጭዳይሳ፥ ጋምቡፅዳይሳ፥ ጪይዳይሳነ ላዉዘ ምꬃ አይፈ አይፍዳይሳ በእስ። ");
INSERT INTO gofe_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","ሙሰይ ፃምአ ኡባ ጎዳ ስንꬃፈ ኤህድ እስራኤለ አሳ በስስ። ኤንቲ ሀንዳባ በእዳፐ ጉየ እስ እስ ሀላቃይ ባንታ ፃምኣ ፃምኣ ኤክዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","ጎዳይ ሙሰኮ፥ “አሮና ፃምኣ ታቦትያ ስንꬃን ዛራዳ ዎꬃ። ማካልዳ እስራኤለ አሳይ ታ ቦላ ዙዙንꬃ አጎና እፅኮ ሀይቃናይሳ ኤንታዉ ማላታ ኦꬃዳ ዎꬃ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","ሙሰይ፥ ጎዳይ ኪትዳይሳዳ ኦꬅስ። ");
INSERT INTO gofe_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","እስራኤለ አሳይ ሙሰኮ፥ “ሄሳ ግድኮ፥ ኑ ኡባይ ሀይቃና፤ ꬋያና። ");
INSERT INTO gofe_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","ጌሻ ዱንካንያኮ ሺቅያ ኡባይ ሀይቃና ግድኮ፥ ኑ ኡባይካ ሀይቆስ ጉሰዬ?” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","ጎዳይ አሮናኮ፥ “ጌሻ ዱንካንያን ኦሰትያ ናጋራስ ኔኒ፥ ነ አደ ናይትነ ነ አዋ ሶ አሳይ ኦይሸታና፤ ህንተ ካህነተꬃ ኦሱዋን ፖለትያ ናጋራ ነነ ነ አደ ናይታ ፃላል ኦይሸታና። ");
INSERT INTO gofe_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","ኔንነ ነ አደ ናይት ጌሻ ዱንካንያ ስንꬃን ኦꬅያ ዎደ ህንተና ኦꬅድ ማዳና መላ ሌወ ኮቸ ግድዳ ነ ዳቦታ ኤሀ። ");
INSERT INTO gofe_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","ኤንቲ ህንተፈ ጋርሳን ጌሻ ዱንካንያ ኦሶ ኡባ ኦꬆና፤ ሽን ኤንትካ ህንተካ ሀይቆና መላ ኤንቲ ጌሻ ዱንካንያ ሚሽያኮነ ያርሾ በሳኮ ሺቆፖ። ");
INSERT INTO gofe_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","ኤንቲ ህንተራ እስፈ ግድድ ጌሻ ዱንካንያን ደእያ ኦሶ ኡባ ኦꬆ። ሽን ሌወታፐ አትሽን፥ ሀራ አስ ኦንካ ህንተ ደእያ በሳ ሺቆፖ። ");
INSERT INTO gofe_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","ዛሪድ እስራኤለ አሳ ቦላ ሀንቆይ ዎꬎና መላ ጌሻ ዱንካንያንነ ያርሾ በሳን ኦሰትያ ኦሱዋ ህንተ ፃላላ ኦꬅተ። ");
INSERT INTO gofe_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","ሌወታ፥ ህንተ ዳቦታ፥ እስራኤለ አሳ ግዶፈ ታ ዶራስ። ኤንቲ ጌሻ ዱንካንያ ኦሱዋ ኦꬃና መላ ታኒ ኤንታ ታዉ ዱማያስ። ");
INSERT INTO gofe_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","ሽን ያርሾ በሳንነ ማጋራጁዋፈ ጋꬃ ባጋን ደእያ ኦሱዋ ነነ ነ አደ ናይታ ፃላል ኦꬅተ። ካህነተꬃ ኦሱዋ ታኒ ህንተዉ እሞታ ኦꬃዳ እማስ፤ ሀራ አስ ኦንካ ሄ በሳ ሺቅኮ ሀይቆ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","ጎዳይ አሮናኮ፥ “እስራኤለ አሳይ ታዉ እምያ ጌሻ እሞታ ኡባ ታ ነዉ እማስ። ታኒ ነዉነ ነ አደ ናይታስ መርና ግሾ ኦꬃዳ እማስ። ");
INSERT INTO gofe_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","ታዉ እመትያ ዳሮ ጌሻ እሙዋፐ ታማን ፁገቶና ባጋይ ህንተባ ግዳና። ኤንቲ ታዉ እምያ ጌሻ እሞ ኡባይ ካꬃ ያርሾ ግድን ናጋራ ያርሾ ግድን ናቆ ያርሾ ግድን ነዉነ ነ አደ ናይታስ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","ህንተ ሄሳ ጌሻ በሳን ሚተ፤ አደ ኡባይ ሄሳ ሞ፤ ሄስ ህንተዉ ጌሽ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“ቃስ እስራኤለ አሳይ ታዉ ያርሽያ ዩሾ ያርሾ ኡባ ነዉ፥ ነ አደ ናይታስነ ነ ማጫ ናይታስ መርናዉ ግሾ ኦꬃዳ እማስ፤ ህንተ ሶ አሳ ግዶን ዎጋዳ ቱና ግዶና ኡባይ ሄሳ ሞ። ");
INSERT INTO gofe_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","“እስራኤለ አሳይ ታዉ ባይራ ኦꬅድ እምያ ኮይሮ አይፍያፐ፥ ሻማሆ ዛይተ ኡባ፥ ያላጋ ዎይነ ኡባነ ካꬃ ኡባ ነዉ እማስ። ");
INSERT INTO gofe_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","ኤንቲ ጎዳስ ኤህያ ጋደን ኮይሮ ጋክዳ አይፈይ ህንተሳ፤ ህንተ ሶ አሳ ግዶን ዎጋዳ ቱና ግዶና ኡባይ ሄሳ ሞ። ");
INSERT INTO gofe_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“እስራኤለ አሳ ግዶፈ ጎዳስ ዱማትዳ ኡባይ ህንተሳ። ");
INSERT INTO gofe_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","ባይራ የለትዳ አስ ዎይኮ መሄይ እስራኤለ አሳይ ጎዳስ እምዳ ኡባይ ህንተሳ። ሽን ባይራ የለትዳ አደ ናአነ ባይራ የለትዳ ጌሽ ግዶና መሄ ህንተ ዎዛናዉ በሴስ። ");
INSERT INTO gofe_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","እስ አጌና ናይታ ዎዛናዉ ጌሻ ዱንካነን ኤረትዳ ምዛነን እቻሹ ብራ ሳንትመ ዎዞ ጋተ ቃንፅተ። ");
INSERT INTO gofe_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","ሽን ኤንቲ ጌሽ ግድያ ግሾ መሄ፥ ዶርሰነ ዴሻ ባይራ ህንተ ዎዛናዉ ኮሸና። ኤንታ ሱꬃ ያርሾ በሳ ቦላ ጉሳ፤ ጎዳስ ሳውያ ፁሳ ያርሾ ኦꬃዳ ኤንታ ሞꬎ አሹዋ ታማን ፁጋ። ");
INSERT INTO gofe_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","አንጋሶይነ ኡሻቻ ገዳይ ዩሾ ያርሾን ነባ ግድዳይሳዳ ኤንታ አሾይካ ነባ። ");
INSERT INTO gofe_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","እስራኤለ አሳይ ጎዳስ እምያ ጌሻ ያርሾ ኡባ ነዉ፥ ነ አደ ናይታስነ ነ ማጫ ናይታስ መርናዉ ግሾ ኦꬃዳ እማስ። ሄስ ታኒ ኔራነ ነ ኮቻራ ጫቅያ መርና ጫቁዋ።” ");
INSERT INTO gofe_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","ቃስካ ጎዳይ አሮናኮ፥ “ኤንታ ቢታፈ ነና ጋክያ ግሾይ ዎይኮ ላት ባዋ፤ እስራኤለ አሳ ግዶን ነ ላታይነ ነና ጋክያ ግሾይ ታና።” ");
INSERT INTO gofe_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","ጎዳይ፥ “ሌወት ጌሻ ዱንካንያን ኦꬅያ ኦሱዋስ ዳሞዘ ግዳና መላ እስራኤለ አሳይ ታዉ ኤህያ አስራታ ኡባ ኤንታዉ እማስ። ");
INSERT INTO gofe_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","ሀችፈ ዶምድ እስራኤለ አሳይ ባንታ ናጋራ ጋሶን ሀይቆና መላ ጌሻ ዱንካንያኮ ሺቆፖ። ");
INSERT INTO gofe_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","ጌሻ ዱንካንያ ግዶን ኦይሳትነ እያ ግዶን ፖለትያ ናጋራ ቶከይ ሌወታ። ሄስ የለተꬃ ኡባስ መርና ዎጋ። ሌወታስ እስራኤለ አሳ ግዶን ላት ባዋ። ");
INSERT INTO gofe_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","ሄሳ ግሾ፥ እስራኤለ አሳይ ጎዳስ እምያ አስራታ፥ ታ ሌወታስ እማስ። ታኒ፥ ኤንታዉ እስራኤለ አሳ ግዶን ላት ባዋ ግዳይ ሄሳሳ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","ቃስ ጎዳይ ሙሰኮ፥ ");
INSERT INTO gofe_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“ኔኒ ሌወታኮ ሀይሳዳ ያጋ፤ ታኒ ህንተዉ ላታ ኦꬃዳ እምዳ አስራታ ህንተ እስራኤለ አሳፐ ኤክያ ዎደ ህንተ ሄ አስራታፐ አስራታ ጎዳስ እምተ። ");
INSERT INTO gofe_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","ህንተ እሞይ ዉዱማፈ ሺቅዳ ካꬃዳ ዎይኮ ጉምእያ በሳፈ ሀእ ከይዳ ዎይነዳ ህንተዉ ታይበታና። ");
INSERT INTO gofe_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","ሄሳዳካ እስራኤለ አሳፐ ህንተ ኤክያ አስራታ ኡባፈ ዱማ እሞ ጎዳስ እምተ፤ ህንተ አስራታፐ ጎዳ ግሾ ግድዳ እሞታ ካህንያ አሮናስ እምተ። ");
INSERT INTO gofe_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","ህንተ ኤክያ እሞታ ኡባፈ ሎኡዋነ ጌሻ ጎዳስ ግሾ ኦꬅድ እማናዉ በሴስ። ");
INSERT INTO gofe_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","ኡባፈ ሎኦ እሙዋ ህንተ እምያ ዎደ አትዳይስ ህንተዉ ቡከትያ ዉዱማ ካꬃዳነ ጉምኤትያ ዎይንያዳ ታይበታና። ");
INSERT INTO gofe_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","አትዳይስ ጌሻ ዱንካንያን ህንተ ኦꬅያ ኦሱዋስ ዳሞዘ ግድያ ግሾ ህንተነ ህንተ ሶ አሳይ አዉንካ ማናዉ ዳንዳኤታ። ");
INSERT INTO gofe_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","ሎኦ ባጋ ጎዳስ እምዳፐ ጉየ ህንተ ሚኮ ሄስ ህንተዉ ናጋራ ግደና። ሎኦ ባጋ ከሶና ደእሸ ሄ እሞታፐ ምድ ህንተ እስራኤለ አሳ እሞታ ቱንሶና መላ ናገትተ፤ ሄሳ ህንተ ኦꬆና እፅኮ ህንተ ሀይቃና” ያጋዳ ሌወታስ ኦዳ። ");
INSERT INTO gofe_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","ጎዳይ ሙሰኮነ አሮናኮ፥ ");
INSERT INTO gofe_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“ጎዳይ ህግያን ኪተትዳ ዎጋይ ሀይሳ፤ ቦርሶይ ባይና፥ እ ጋናን ቃምባር ዎꬍቦና ዞኦ ኡሱ ኤሀና መላ እስራኤለ አሳስ ኦድተ። ");
INSERT INTO gofe_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","ካህንያ አላዛራስ እዮ እምተ፤ ጉታፐ እዮ ጋፃ ከስድ ካህንያ ስንꬃን ሹኮ። ");
INSERT INTO gofe_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","ካህነይ አላዛር እ ሱꬃፈ ጉꬃራ ኤክድ ባ ብራꬍያን ጌሻ ዱንካንያኮ ስሚድ ላፑን ቶሆ ዉርፆ። ");
INSERT INTO gofe_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","ካህነይ በእሽን ኡስያ ፁገቶ፤ ጋልባይ፥ አሾይ፥ ሱꬃይነ ቶጨይ ፁገቶ። ");
INSERT INTO gofe_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","ካህነይ ዝጋ ምꬅ፥ ህሶጰ ታሸነ ዞኦ ቃጭና ኤክድ ኡስያ ኤፅያ ታማን የጎ። ");
INSERT INTO gofe_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","ሄሳፈ ጉየ ካህነይ ባ ማኡዋነ ባ አሳተꬃ ሜጨትድ ጉታ ገሎ፤ ሽን ኦማርስ ጋካናዉ ዎጋዳ ቱና ግዳና። ");
INSERT INTO gofe_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","ሄ ኡስዉ ፁግዳይስ ባ ማኡዋነ ባ አሳተꬃ ሜጨቶ፤ እካ ኦማርስ ጋካናዉ ዎጋዳ ቱና ግዳና። ");
INSERT INTO gofe_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","“ሄሳፈ ጉየ፥ ሀራ ጌሻ አስ ኡስያ ፁገትዳ ብዱዋ ሺሽድ ጉታፐ ጋፃን ጌሻ በሳን ዎꬆ። እስራኤለ አሳይ ቱናተꬃፈ ጌሽያ ሃꬃን ጎኤታናዉ ሄስ ናገትድ ኡታና፤ ሄስ ናጋራፐ ጌሻናዉ ጎኤስ። ");
INSERT INTO gofe_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","ቃስ ኡሴ ብዱዋ ሺሽዳ ኡራይካ ባ ማኡዋ ሜጮ፤ እ ኦማርስ ጋካናዉ ዎጋዳ ቱና ግዳና። ሀ ዎጋይ እስራኤለ አሳስነ ኤንታ ግዶን ደእያ ሀራ ደረ አሳስ መርና ዎጋ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“አሀ ቦችያ ኦንካ ላፑን ጋላስ ዎጋዳ ቱና ግዳና። ");
INSERT INTO gofe_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","ቱናተꬃፈ ጌሽያ ሃꬃን ሄꬓንꬆ ጋላስነ ላፑንꬃ ጋላስ እ ባና ጌሾ፤ ሄሳፈ ጉየ፥ እ ዎጋዳ ጌሽ ግዳና። ሽን ሄꬓንꬆ ጋላስነ ላፑንꬃ ጋላስ እ ባና ጌሾና እፅኮ እ ጌሽ ግደና። ");
INSERT INTO gofe_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","ሀይቅዳ አሳ አሀ ቦችያ ኦንካ ባና ጌሾና እፅኮ እ ጎዳ ዱንካንያ ቱንሴስ፤ ሄ ኡራይ እስራኤለ አሳ ግዶፈ ኩረቶ። ቱናተꬃፈ ጌሽያ ሃꬃይ እያ ቦላ ዉርፀትቦና ግሾ እ ቱና፤ እ ቱና ግድድ ጋምኤስ። ");
INSERT INTO gofe_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“እስ አስ ዱንካንያ ግዶን ሀይቅኮ ኦꬃና ዎጋይ ሀይሳ፤ ዱንካንያ ግዶ ገልያ ኦንካ፥ ቃስ ዱንካንያ ግዶን ደእያ ኦንካ ላፑን ጋላስ ጋካናዉ ቱና ግዳና። ");
INSERT INTO gofe_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","ሄሳዳካ፥ ካመቶና ዶያ ደእያ ሚሸ ኡባይ ቱና ግዳና። ");
INSERT INTO gofe_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","ቃስ ደንባን ሀይቅዳ አሳ አሀ ዎይኮ ሀርገትድ ሀይቅዳ አሳ አሀ ዎይኮ መቀꬅ ዎይኮ ዱፎ ቦችያ ኦንካ ላፑን ጋላስ ጋካናዉ ቱና ግዳና። ");
INSERT INTO gofe_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“ቱናተꬃፈ ጌሻናዉ ፁገትዳ ኡሴ ብዱዋፐ ጉꬃራ ኤካዳ ኦቶን የጋዳ ፑልቶ ሃ እያ ቦላ ትጋ። ");
INSERT INTO gofe_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","ጌሻ አስ ህሶጰ ውርጮ ኤክድ ሃꬃን ናቅ ከስድ፥ ዱንካንያ፥ እያ ግዶን ደእያ ሚሽያነ አሳ ኡባ ቦላ ዉርፆ። ቃስ ሀይቅዳ አሳ አሀ ዎይኮ መቀꬅ ዎይኮ ዱፎ ዎይኮ ሀርገት ሀይቅዳ አስ ቦችዳ አሳ ቦላ ዉርፆ። ");
INSERT INTO gofe_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","ጌይዳ አስ ሄꬓንꬆ ጋላስነ ላፑንꬃ ጋላስ ጌይቦና ኡራ ቦላ ዉርፆ። እ ላፑንꬃ ጋላስ ሄ ኡራ ቱናተꬃፈ ጌሾ፤ ሄ ጌይዳ አደይ፥ ባ ማኡዋነ ባ አሳተꬃ ሜጨቶ፤ ሄ ጋላስ ኦማርስ እ ጌሽ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","“ሽን ቱና ኡራይ ባና ጌሾና እፅኮ፥ ሄ ኡራይ ጌሻ ዱንካንያ ቱንስዳ ግሾ፥ እስራኤለ አሳ ግዶፈ ኩረቶ፤ ቱናተꬃፈ ጌሽያ ሃꬃይ እያ ቦላ ዉርፀትቦና ግሾ እ ቱና። ");
INSERT INTO gofe_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","ሀይስ ህንተዉ መርና ዎጋ ግዳና። ቱናተꬃፈ ጌሽያ ሃꬃ ዉርፅያ ኡራይ ባ ማኡዋ ሜጮ፤ ቃስ ቱናተꬃፈ ጌሽያ ሃꬃ ቦችያ ኦንካ ኦማርስ ጋካናዉ ቱና ግዳና። ");
INSERT INTO gofe_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","ቱና ኡራይ ቦችያ አይብባይካ ቱኔስ፤ ቃስ ሄ ሚሽያ ቦችያ ኦንካ ኦማርስ ጋካናዉ ቱና ግዴስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","ኮይሮ አጌናን እስራኤለ አሳ ኡባይ ሲና መላ ቢታ ጋክድ፥ ቃደሳ ጌተትያ በሳን ዱንካንዶሶና። ማይራማ ያን ሀይቃዳ ሞገታሱ። ");
INSERT INTO gofe_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","ሄ በሳን አሳስ ሃꬅ ꬋይን፥ አሳይ ሙሰ ቦላነ አሮና ቦላ ደንድዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","ኤንቲ፥ “ኑ እሻት ጎዳ ስንꬃን ሀይቅዳ ዎደ ኑካ ሀይቅዳ ግዶርኮሽን። ");
INSERT INTO gofe_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","ኑነ ኑ መሄይ ሀ መላ ቢታን ሀይቃና መላ ጎዳ ማባራ ሀ በሳ አይስ ኤህደቲ? ");
INSERT INTO gofe_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","ግብፀፈ ከስድ ሀ ኢታ በሳ ኑና አይስ ኤህደቲ? ሀይሳን ካꬅ ዎይኮ ባላሰይ ዎይኮ ዎይነይ ዎይኮ ኦሮማነይ ባዋ፤ ሀር አቶሽን ኡየትያ ሃꬅካ ሀይሳን ባዋ” ያግድ ሙሰራ ካጨትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","ያትን ሙሰይነ አሮን አሳ ማታፐ ጌሻ ዱንካንያ ፐንገ ብድ ሳአን ጉፋንዶሶና፤ ጎዳ ቦንቾይካ ኤንታዉ ቆንጭስ። ");
INSERT INTO gofe_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","ጎዳይ ሙሰኮ፥ ");
INSERT INTO gofe_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“ነ ፃምአ ኤካ፤ ኔራነ ነ እሻ አሮናራ ማባራ ሺሽተ። ኤንታ ስንꬃን ዛላይ ሃ ከሳና መላ ኦዳ። ህንተ ዛላፈ ሃ ከስድ፥ ኤንታነ ኤንታ መህያ ኡሻና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","ጎዳይ ኪትዳይሳዳ ሙሰይ ጎዳ ስንꬃፈ ፃምኣ ኤክስ። ");
INSERT INTO gofe_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","ሙሰይነ አሮን ማባራ ዛላ ስንꬃን ሺቃና መላ ኦꬅድ፥ አሳኮ፥ “ህንተኖ ጌላቶ፥ ስእተ፤ ሀ ዛላፈ ህንተዉ ኑኒ ቱማ ሃ ከሳኔ?” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","ሙሰይ ባ ፃምአ ደንꬅድ ዛላ ናምኡ ቶሆ ሾጭስ፤ ሃꬅ ꬉቅድ ከይን ኤንትነ ኤንታ መሄት ኡይዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","ሽን ጎዳይ ሙሰኮነ አሮናኮ፥ “እስራኤለ አሳ ስንꬃን ህንተ ታ ጌሻተꬃ በሳናዉ አማነትቦና ግሾ ታ ኤንታዉ እምያ ቢታ ሀ አሳ ካለꬅድ ህንተ ገለከታ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","እስራኤለ አሳይ ጎዳራ ካጨትዳ ግሾነ ጎዳይ ባ ጌሻተꬃ ኤንታ ግዶን ቆንጭስዳ ግሾ ሄ በሳይ ማርባ ሃꬃ ጌተትስ። ");
INSERT INTO gofe_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","ኤዶመ ካዋኮ ሙሰይ ቃደሳፐ ሀይሳዳ ያግድ ኪታ የድስ። “ነ እሻይ እስራኤለይ ሀይሳዳ ያጌስ፤ ኑና ጋክዳ መቶ ኡባ ነ ስአዳሳ። ");
INSERT INTO gofe_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","ኑ ማይዛት ዱገ ግብፀ ዎꬍዶሶና፤ ያን ኑኒ ዳሮ ላይꬅ ደእዳ። ግብፀት ኑናነ ኑ አዋታ ኡንኤꬅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","ኑኒ ጎዳኮ ዋስን፥ እ ኑ ዋሱዋ ስእድ፥ ባ ኪታንቹዋ ኪትድ ኑና ግብፀፈ ከስስ። ሀእ ኑኒ ነ ቢታ ጋፃን ደእያ ቃደሳ ካታማን ደኦስ። ");
INSERT INTO gofe_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","ሀያና፥ ኑኒ ነ ቢታራ ካንꬅድ አꬋና መላ ኦꬃርክ፤ ኑኒ ኦገፐ ጋፃ ከዮኮ፤ ነ ጎሻ ዎይኮ ዎይነ ጋደ ግዶ ገሎኮ፤ ኑኒ ሃꬃ ኦላፈ ሃ ኡዮኮ። ኑኒ ካዎ ኦገ ኦይክድ ባና፤ ኑኒ ነ ቢታራ ካንꬅድ አꬋና ጋካናዉ ሀድርስ ዎይኮ ኡሻች ጎኮ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","ሽን ኤዶመ አሳይ፥ “ኑ ቢታራ ካንꬅሶኮ፤ ህንተ ሀይሳራ ካንꬃናዉ ቆፕኮ፥ ኑኒ ደንድድ ህንተና ኦላና” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","ያትን እስራኤለ አሳይ፥ “ኑኒ ካዎ ኦግያራ ባና፤ ኑኒ ዎይኮ ኑ መሄይ ህንተ ሃꬃፈ ኡይኮ፥ ኑኒ ሄሳስ ጋተ ጭጋና፤ ኑኒ ቶሆራ አꬃ ፃላላ ኮዮስ፤ ሀራባ አይኮካ ኮዮኮ” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","ኤዶመ አሳይ ዛሪድ፥ “ህንተ ሀይሳራ አꬋናዉ ዳንዳኤከታ” ያግስ። ካልድ፥ ዳሮነ ዎልቃማ ኦላንቾታ ኤክድ እስራኤለ አሳ ኦላናዉ ከይስ። ");
INSERT INTO gofe_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","ኤዶመ አሳይ ባንታ ቢታራ እስራኤለ አሳ አꬆና እፅን፥ እስራኤለ አሳይ ስሚድ ሀራ ኦገራ ብዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","እስራኤለ አሳ ኡባይ ቃደሳፐ ደንድድ ሆራ ዙማኮ ብዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","ኤዶመ ዛዋን ደእያ ሆራ ዙማን፥ ጎዳይ ሙሰኮነ አሮናኮ፥ ");
INSERT INTO gofe_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“አሮን ባ ማይዛታን ጋሄትያ ዎደይ ጋክስ። ህንተ ናምአይ ማርባ ሃꬃ ማታን ታ ኪታ ቦላ ጌላትዳ ግሾ እስራኤለ አሳስ ታ እምያ ቢታ እ ገለና። ");
INSERT INTO gofe_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","አሮናነ እያ ናኣ አላዛራ ኤካዳ ሆራ ዙማ ቦላ ከያ። ");
INSERT INTO gofe_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","አሮና ካህነተꬃ ማኡዋ ቃራዳ፥ እያ ናኣ አላዛራ ማይዛ። አሮን ያን ሀይቃና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","ጎዳይ ኪትዳይሳዳ ሙሰይ ኦꬅስ፤ እስራኤለ አሳ ኡባይ በእሽን፥ ኤንቲ ሆራ ዙማ ቦላ ከይዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","ሙሰይ አሮና ካህነተꬃ ማኡዋ ቃርድ እያ ናኣ አላዛራ ማይዝስ። አሮን ሄ ዙማ ሁጰን ሀይቅስ። ሙሰይነ አላዛር ዙማፐ ዎꬍዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","አሮን ሀይቅዳይሳ እስራኤለ አሳይ ኤርዳ ዎደ እስራኤለ አሳይ አሮናስ ሀስታሙ ጋላስ ዬክዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","ካናነ ቢታን፥ ነገበ መላ ቢታን ደእያ አራዳ ካዎይ፥ እስራኤለ አሳይ አታርማ ኤፍያ ኦግያራ የይሳ ስእዳ ዎደ እስራኤለ አሳራ ኦለትድ ኤንታፈ ጉꬃ አሳ ድእዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","ሄ ዎደ እስራኤለ አሳይ፥ “ኔኒ ሀ አሳ ኑ ኩሸን አꬃዳ እምኮ፥ ኑኒ ኤንታነ ኤንታ ካታማታ ኩመꬅ ꬋይሳና” ያግድ ጎዳስ ቃንግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","ጎዳይ እስራኤለ አሳ ዎሳ ስእድ፥ ካናነታ ኤንታ ኩሸን አꬅድ እምን፥ ኤንቲ ካናነታነ ኤንታ ካታማታ ኩመꬅ ꬋይስዶሶና። ሄሳ ግሾ፥ ሄ በሳይ ሆርማ ጌተትድ ሱንትስ። ");
INSERT INTO gofe_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","እስራኤለ አሳይ ሆራ ዙማፐ ደንድድ፥ ኤዶመ ቢታ ዩሹዋራ ባናዉ ዞኦ አባኮ ኤፍያ ኦግያራ ብዶሶና፤ ሽን ኦገ ቦላ አሳስ ዳንዳአይ ዉርስ። ");
INSERT INTO gofe_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","አሳይ፥ “ኑኒ መላ ቢታ ሀይቃና መላ ግብፀፈ ኑና አይስ ከስደቲ? ካꬅ ባዋ፤ ሃꬅ ባዋ፤ ሀ ኢታ ካꬃይ ኑና ሻትስ” ያግድ ፆሳ ቦላነ ሙሰ ቦላ ዙዙምዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","ያትን፥ ጎዳይ አሳ ግዶ ማርዘራ ደእያ ሾሽ የድን፥ እስራኤለ አሳፐ ዳሮት ዱከትድ ሀይቅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","አሳይ ሙሰኮ ይድ፥ “ኑኒ ጎዳ ቦላነ ነ ቦላ ዙዙምድ፥ ናጋራ ኦꬅዳ። ጎዳይ ሀ ሾሻታ ኑፐ ሃሳና መላ ኑስ ዎሳርክ” ያግዶሶና። ያትን፥ ሙሰይ አሳ ግሾ ዎስስ። ");
INSERT INTO gofe_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","ሄ ዎደ ጎዳይ ሙሰኮ፥ “ናሰ ብራታፐ ሾሽ መꬋዳ፥ ኤንታ ስንꬃን ምꬃ ቦላ ካቃ፤ ሾሻን ዱከትዳ ኦንካ እያ በእኮ ፓፃና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","ያትን፥ ሙሰይ ናሰ ብራታፐ ሾሽ መꬍድ፥ ምꬃ ቦላ ካቅስ። ሾሻን ዱከትዳ አሳ ኡባይ ናሰ ብራታ ሾሻ በእድ ፓፅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","እስራኤለ አሳይ ሆራፐ ደንድድ ኦቦታ ጌተትያ በሳን ዱንካንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","ኦቦታፐ ደንድድ፥ ሞአበፐ ስንꬃ ባጋን ደእያ መላ ቢታን፥ ዶሎሀ ባጋን አባሪማን ዱንካንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","ያፐ ደንድድ፥ ዛሬዳ ዛንጋራን ዱንካንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","ያፐ ደንድድ፥ አሞረታ ቢታ ጋፃ ጋካናዉ ደእያ መላ ቢታን አርኖና ሻፋፐ ሄፍንꬃን ዱንካንዶሶና። አርኖና ሻፋይ ሞአበ ቢታስነ አሞረ ቢታስ ግዶን ደእያ ዛዋ። ");
INSERT INTO gofe_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","ሄሳ ግሾ፥ ጎዳ ኦላ ታርክያ ኦድያ ማፃፋን፥ “ሱፋ ሄራን ደእያ ዋሄባ ካታማነ አርኖና ሻፋ ዛንጋራ፥ ");
INSERT INTO gofe_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","ኤራ ካታማነ ሞአበ ቢታ ዛዋ ጋካናዉ ደእያ ዛንጋራ” ያገትድ ፃፈትስ። ");
INSERT INTO gofe_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","ኤንቲ ያፐ ደንድድ፥ ጎዳይ ሙሰኮ፥ “አሳ ሺሻ፤ ታ ኤንታዉ ሃ እማና” ያግድ ኦድዳ ቤራ ጌተትያ ሃꬃ ኦላኮ ብዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","ሄ ዎደ እስራኤለ አሳይ ሀ ማዝሙርያ የፅዶሶና። “ሃꬃ ኦላዉ፥ ፑልታ፤ ህንተካ የፅተ። ");
INSERT INTO gofe_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","ሀላቃት ቦክዳ ሃꬃ ኦላስ፥ ካለይሳት ካዎተꬃ ፃምአንነ ባንታ ፃምአን ቦክዳ ሃꬃ ኦላስ የፅተ” ያግስ። ኤንቲ ሄ መላ ቢታፈ ደንድድ ማታና ጌተትያ በሳ ብዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","ማታናፐ ናህልኤላ፥ ናሀልኤላፐ ባሞታ ጌተትያ በሳ ብዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","ባሞታፐ ደንድድ፥ ሞአበን ደእያ ዛንጋራ ብዶሶና፤ ሄ ዛንጋራይ ፕስጋ ዙማፐ ጋርሳን ባዙዋ ግናን ደኤስ። ");
INSERT INTO gofe_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","ሄሳፈ ጉየ፥ እስራኤለ አሳይ አሞረ ካዋ ስሆነኮ ሀይሳዳ ያግድ ኪታ የድዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“ሀያና፥ ኑ ነ ቢታራ ካንꬅድ አꬋና መላ ኦꬃርክ፤ ኑኒ ኦገፐ ጋፃ ከዮኮ፤ ነ ጎሻ ዎይኮ ዎይነ ጋደ ግዶ ገሎኮ፤ ኑኒ ሃꬃ ኦላፈ ሃ ኡዮኮ። ኑኒ ነ ቢታራ ካንꬅድ አꬋና ጋካናዉ ሀድርስ ዎይኮ ኡሻች ጎኮ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","ስሆነይ እስራኤለ አሳይ ባ ቢታራ ካንꬆና መላ ድግስ። እ ባ ኦላንቾታ ኡባ ሺሽድ፥ እስራኤለ አሳ ኦላናዉ መላ ቢታ ብስ፤ ያሃፃ ጌተትያ በሳ ብድ እስራኤለ አሳራ ኦለትስ። ");
INSERT INTO gofe_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","እስራኤለ አሳይ ኦላን አሞረታፐ ዳሮታ ማሻን ዎꬍድ፥ አርኖና ሻፋፐ ዶምድ፥ አሞነታ ዛዋን ደእያ ያቦቃ ሻፋ ጋካናዉ ኦይክስ። አሞነ አሳ ቢታ ዛዋይ ግምበትድ ደእያ ግሾ፥ ኤንቲ ያ ገልቦኮና። ");
INSERT INTO gofe_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","እስራኤለ አሳይ አሞረታ፥ ሀሰቦናነ እያ ዩሹዋን ደእያ ካታማታ ኡባ ፆን ኤክድ ያን ኡትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","ሀሰቦና ካታማይ አሞረታ ካዋ ስሆነ ኡትያ ካታማ። ስሆነይ ካሰ ሞአበ ቢታ ካዋ ኦልድ፥ አርኖና ሻፋ ጋካናዉ ደእያ ቢታ ኡባ ኤክስ። ");
INSERT INTO gofe_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","ሄሳ ግሾ፥ ሌምሶን ሀይሳዳ ያግዶሶና፤ “ሀሰቦናኮ ሃይተ፤ ሀ ካታማይ ዛሪድ ኬፀቶ፤ ስሆነ ካታማይ ካሰ ባ በሳ ስሞ። ");
INSERT INTO gofe_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","ታም ሀሰቦናፐ ከይስ፤ ላጮይ ስሆና ካታማን በንትስ፤ ሞአበን ደእያ ኤራ ꬋይስስ፤ አርኖና ꬎቃ በሳታ ምስ። ");
INSERT INTO gofe_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","ሞአበ፥ ነና አየ! ካሞሻ አሳይ ꬋይደታ። ህንተ አደ ናይት ባቃታናዳ፥ ህንተ ማጫ ናይት ድኤታናዳ፥ አሞረታ ካዋ ስሆነስ እሚስ። ");
INSERT INTO gofe_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","ኑኒ ህንተ ኮቻታ ሀሰቦናፐ ዶምድ፥ ድቦና ጋካናዉ ኩመꬅ ꬋይስዳ። መደባ ማታን ደእያ ኖፋ ጋካናዉ ደእያ ኡባ ታም ꬋይስስ” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","ያትድ፥ እስራኤለ አሳይ አሞረታ ቢታን ደእዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","ቃስ ሙሰይ ዎቸይሳታ ያእዜራ ካታማ የድን፥ እስራኤለ አሳይ ሄ ካታማነ እያ ሄራን ደእያ ጉꬃ ካታማታ ኦይክድ፥ ያን ደእያ አሞረታ ከስድ ጎድዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","ሄሳፈ ጉየ፥ እስራኤለ አሳይ ስሚድ፥ ባሳነ ኤፍያ ኦግያራ ከይዶሶና። ባሳነ ካዎይ ኦገይ ባ ኦላንቾታራ ኤድራአ ካታማን ኤንታራ ኦለታናዉ ከይስ። ");
INSERT INTO gofe_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","ሽን ጎዳይ ሙሰኮ፥ “ሀ ኡራስ ባቦፋ፤ ህዛ፥ ካዋ ኦገ፥ እያ አሳነ እያ ቢታ ኡባ ነ ኩሸን አꬃዳ እማስ። ሀሰቦናን ኡትድ ሃርዳ አሞረታ ካዋ ስሆነ ቦላ ኦይሳዳ ኔኒ እያ ቦላ ኦꬃና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","ሄሳ ግሾ፥ እስራኤለ አሳይ ኦገ፥ እያ ናይታነ እያ አሳ ኡባ እሶይ አቶና ዎꬍድ እያ ቢታ ላትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","እስራኤለ አሳይ ደንድድ፥ እያርኮ ግናን፥ ዮርዳኖሰፐ ሄፍንꬃን ደእያ ሞአበ ደንባን ዱንካንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","እስራኤለ አሳይ አሞረታ ቦላ ኦꬅዳይሳ ኡባ ስፎራ ናአይ ባላቅ ስእስ። ");
INSERT INTO gofe_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","እስራኤለ አሳይ ዳሮ ግድዳ ግሾ፥ ሞአበት ዳሮ ዳጋምድ ያይዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","ሞአበት ምድያመ ጭማታኮ፥ “ቦር ማታ ፕትድ ምድ ꬋይሰይሳዳ ሀ ዉደ አሳይ ኑ ዩሹዋን ደእያ ኡባ ምድ ꬋይሳና” ያግዶሶና። ሄ ዎደ ሞአበ ካዎይ፥ ስፎራ ናአይ ባላቅ፥ ");
INSERT INTO gofe_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","አማዋ ቢታን፥ ኤፍራፂሳ ሻፋ ማታን፥ ፓቶራ ካታማን ደእያ ብኦራ ናኣ ባላማኮ ሀይሳዳ ያግድ ኪትስ። “ግብፀፈ ከይዳ ዳሮ አሳይ ቢታ ኡባ ማእድ፥ ታ ማታን ዱንካንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","ኤንቲ ታፐ ዳሮ ዎልቃማ ግድያ ግሾ፥ ሀያና ያዳ ኤንታ ባዳርክ። ኦን ኤር፥ ታ ኤንታ ፆናናዉነ ቢታፈ ከሳናዉ ዳንዳአና። ህዛ፥ ኔኒ አንጀይስ አንጀተይሳ ቃስ ኔኒ ባደይስ ባደትዳባ ግደይሳ ታኒ ኤራይስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","ሞአበ ጭማትነ ምድያመ ጭማት ባደꬃ ሚሽያ ኤክድ ባላማኮ ብድ ባላቅ ግዳይሳ እያዉ ኦድዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","ባላም ኤንታኮ፥ “ሀች ቃማ ሀይሳን አቅተ፤ ጎዳይ ታዉ ኦደይሳ ታ ህንተዉ ኦዳና” ያግስ። ያንን፥ ሞአበ ሀላቃት ባላማራ ጋምእዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","ፆሳይ ባላማ፥ “ሀይሳቲ ኔራ ደእያ አሳት ኦኔ?” ያግድ ኦይችስ። ");
INSERT INTO gofe_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","ባላም ፆሳኮ፥ “ሞአበ ካዎይ፥ ስፎራ ናአይ ባላቅ፥ ");
INSERT INTO gofe_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘ግብፀፈ ከይዳ ዳሮ አሳይ፥ ኤንቲ ቢታ ኡባ ኩምዶሶና። ኔኒ ያዳ፥ ኤንታ ባዳርክ። ኦን ኤር፥ ታ ኤንታ ፆናናዉነ ቢታፈ ከሳናዉ ዳንዳኦና አግከ’ ያግድ ኤንታ ታኮ ኪትስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","ያትን ፆሳይ ባላማኮ፥ “ኔኒ ኤንታራ ቦፓ፤ እስራኤለ አሳይ አንጀትዳ ደረ ግድያ ግሾ፥ ኔኒ ኤንታ ባዶፋ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","ዎንተꬃ ጋላስ ዎንታ ባላም ደንድድ፥ ባላቃ ሀላቃታኮ፥ “ታኒ ህንተራ ቦናዳ ጎዳይ ድግዳ ግሾ፥ ህንተ ቢታ ስምተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","ሞአበ ሀላቃት ባላቃኮ ጉየ ስሚድ፥ “ባላም ኑራ ዮና እፅስ” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","ዛሪድ ባላቅ ካሰይሳታፐ አꬎ ቦንቸትዳነ ታይቦን ዳሮ ሀላቃታ እያኮ ኪትስ። ");
INSERT INTO gofe_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","ኤንቲ ባላማኮ ብድ፥ “ስፎራ ናአይ ባላቅ፥ ‘ኔኒ ታኮ ያናይሳ ነና አይብካ ተቆፎ። ");
INSERT INTO gofe_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","ታ ነዉ ዳሮ ዎይቶ እማና፤ ነ ኦይችያባ ኡባ ታ ነዉ ኦꬃና። ሀያና ያዳ ሀ አሳ ባዳርክ’ ያግስ” ያግድ ኦድዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","ሽን ባላም ኤንታኮ፥ “ባላቅ ሀር አቶሽን ባ ካዎተꬃን ኩምዳ ብራነ ዎርቃ ታዉ እምያባ ግድኮካ ጎዳ፥ ታ ፆሳ ኪታ መንꬃዳ አይኮካ ፓጭሳናዉ ዎይኮ ጉጃናዉ ዳንዳእከ። ");
INSERT INTO gofe_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","ጎዳይ ታዉ በሲያ ሀራባይ ደእኮ ታ ኤራና መላ ህንተካ ሀች ቃማ ሀይሳን አቅተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","ሄ ቃማ ፆሳይ ባላማኮ፥ “ሀ አሳይ ነና ፄጋናዉ ይዳ ግሾ፥ ኔኒ ኤንታራ ባ፤ ሽን ታ ነዉ ኦደይሳ ፃላላ ኦꬃ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","ያትን ዎንተꬃ ጋላስ ባላም ባ ሃሪው ኮርድ ሞአበ ሀላቃታራ ብስ። ");
INSERT INTO gofe_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","ሽን እ ብያ ግሾ ፆሳይ ሀንቀትስ። ሄ ዎደ ባላም ባ ሃሪው ቶግድ፥ ባ ናምኡ አይለታራ ብሽን ጎዳ ኪታንቾይ እያ ተቃናዉ ኦገን ኤቅስ። ");
INSERT INTO gofe_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","ጎዳ ኪታንቾይ ማሻ ሾድድ ኦገን ኤቅዳይሳ ሀሪያ በአዳ፥ ኦግያ አጋዳ ጎሻ ግዶ ገላሱ። ባላም ሀሪው ኦገን ዛራናዉ ሾጭስ። ");
INSERT INTO gofe_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","ያትን፥ ጎዳ ኪታንቾይ ናምኡ ዎይነ ጋደታፐ ግዶን ያ ባጋራነ ሀ ባጋራ ግምበን ድረትዳ ፁንꬃ ኦገን ኤቅስ። ");
INSERT INTO gofe_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","ሀርያ ጎዳ ኪታንቹዋ በእዳ ዎደ ግምበ ድርሳኮ ሺቅዳ፥ ባላማ ቶሁዋ ግምበ ድርሳራ ኦይꬃሱ፤ ያትን እ ሃሪው ናምአንꬆ ሾጭስ። ");
INSERT INTO gofe_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","ሄሳፈ ጉየ፥ ጎዳ ኪታንቾይ ስንꬃ አꬍድ፥ ሀድርስ ዎይኮ ኡሻች ስማናዉ ኦገይ ባይና ፁንꬃ በሳን ኤቅስ። ");
INSERT INTO gofe_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","ሀርያ ጎዳ ኪታንቹዋ በአዳ፥ ባላም ቶግድ ደእሽን ዝንአሱ፤ ባላም ዳሮ ይሎትድ፥ ባ ፃምአን ሃሪው ሾጭስ። ");
INSERT INTO gofe_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","ሄሳፈ ጉየ፥ ጎዳይ ሀረይ ዶና ዶይን፥ ሀርያ ባላማ፥ “ታ ነዉ አይ ኢስን ታና ሄꬑ ቶሆ ሾጫዲ?” ያጋሱ። ");
INSERT INTO gofe_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","ባላም ዛሪድ፥ “ኔኒ ታና ይሎይዳ ግሾሳ፤ ታ ኩሸን ማሽ ደእያባ ግድያኮ ታ ነና ሀእ ዎꬋናሽን” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","ሃሪያ ባላማኮ፥ “ኔኒ ሀች ጋካናዉ ቶግያ ነ ሃሪው ግድክና? ታኒ ነዉ ሀይሳዳ ሀና ኤርያና?” ያጋሱ። ባላም ዛሪድ፥ “ሀና ኤራካ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","ሄ ዎደ ጎዳይ ባላማ አይፍያ ዶይን፥ ጎዳ ኪታንቾይ ሾደትዳ ማሻ ኦይክድ ኦገን ኤቅዳይሳ በእስ። እ ልች ግድ ሶምኦራ ሳአን ጉፋንስ። ");
INSERT INTO gofe_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","ጎዳ ኪታንቾይ፥ “ነ ሃሪው ሄꬑ ቶሆ አይስ ሾጫዲ? ነ ኦገይ ታ ስንꬃን ጌላ ግድያ ግሾ ታ ነና ተቃናዉ ያስ። ");
INSERT INTO gofe_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","ሀርያ ታና በአዳ ታ ስንꬃፈ ሄꬑ ቶሆ ሀራ ሶ ስማሱ። ሀርያ ሀራ ሶ ስማቦናባ ግድያኮ፥ ሀኖደ ታ ነና ዎꬋዳ ሀርው አሻናሽን” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","ባላም ዛሪድ፥ “ታኒ ናጋራ ኦꬃስ፤ ኔኒ ታና ተቃናዉ ኦገ ቦላ ኤቅዳይሳ ታ ኤራብከ። ነ ዶሶናባ ግድኮ ታ ሀእ ጉየ ስማና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","ሽን ኪታንቾይ ባላማኮ፥ “ኔኒ ሀ አሳታራ ባ፤ ሽን ታ ነዉ ኦደይሳ ፃላላ ኦዳ” ያግስ። ያትን፥ ባላም ባላቃ ቢታ ሀላቃታራ ብስ። ");
INSERT INTO gofe_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","ባላም የይሳ ባላቅ ስእዳ ዎደ አርኖና ሻፋ ጋፃን ባ ቢታ ዛዋን ደእያ ሞአበታ ካታማን እያ ሞካናዉ ብስ። ");
INSERT INTO gofe_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","ባላቅ ባላማኮ፥ “ኔኒ ኤለሳዳ ያና መላ ታ ኪታብክና? ኔኒ አይስ ታኮ ኤለሳዳ ያብኪ? ታኒ ነዉ ኩሸ ዛራናዉ ዳንዳእክና?” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","ባላም ባላቃኮ፥ “ሄኮ፥ ሀእ ታ ኔኮ ያስ፤ ሽን ታ አይኮካ ታፐ ጋናዉ ዳንዳእከ። ፆሳይ ታና ኦዳ ግዳባ ፃላላ ኦዳና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","ያትን፥ ባላም ባላቃራ ቅርያት-ሀፆታ ካታማ ብስ። ");
INSERT INTO gofe_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","ያን ባላቅ መሄነ ዶርሰ ያርሽድ፥ አሹዋፐ ጉꬃራ ባላማስነ እያራ ደእያ ሀላቃታስ እሚስ። ");
INSERT INTO gofe_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","ዎንተꬃ ጋላስ ባላቅ ባላማ ባሞት-ባኣል ጌተትያ በሳ ከስስ፤ ባላም ያን ኤቅድ እስራኤለ አሳፐ ባጋ በእስ። ");
INSERT INTO gofe_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","ባላም ባላቃኮ፥ “ሀይሳን ታዉ ላፑን ያርሾ በሳታ ግምባ፤ ቃስ ላፑን ኮርማታነ ላፑን ማራዘታ ታዉ ጊግሳ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","ባላም ግዳይሳዳ ባላቅ ኦꬅስ፤ ኤንቲ ናምአይ እስ እስ ያርሾ በሳን እስ ኮርማነ እስ ማራዘ ያርሽዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","ያትድ፥ ባላም ባላቃኮ፥ “ኔኒ ነ ያርሹዋ ማታን ደኣሻ፤ ታኒ ገደ ባና። ኦን ኤር ጎዳይ ታራ ጋሄታናዉ ዮና አገና፤ እ ታዉ ቆንጭስያባ ኡባ ታ ነዉ ኦዳና” ያግድ እስ ደረ ቦላ ከይስ። ");
INSERT INTO gofe_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","ያን ፆሳይ ባላማራ ጋሄትን፥ ባላም፥ “ታኒ ላፑን ያርሾ በሳታ ጊግሳስ፤ እስ እስ ያርሾ በሳን እስ ኮርማነ እስ ማራዘ ያርሻስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","ባላም ጋናባ ጎዳይ እያዉ ኦድድ፥ “ኔኒ ባላቃኮ ስማዳ እያዉ ሀ ኪታ ኦዳ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","ባላም ስምያ ዎደ ባላቅ ሞአበ ሀላቃታ ኡባራ ባ ያርሹዋ ማታን ኤቅስ። ");
INSERT INTO gofe_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","ባላም ሀይሳዳ ያግድ ትንብተ ኦድስ፤ “ሞአበ ካዎይ፥ ባላቅ፥ ዶሎሀ ባጋ ደረታፐ፥ ሶረ ቢታፈ ታና ኤህስ፤ ‘ሃ ያ፤ ያይቆባ ታዉ ባዳ፤ እስራኤለ አሳ ባዳ’ ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","ፆሲ ባድቦናይሳ ታ ዋታዳ ባዶ? ጎዳይ፥ ባድቦናይሳ ታ ዋታዳ ባዶ? ");
INSERT INTO gofe_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","ታ ꬎቃ ዛላ ሁጰን ኤቃዳ ኤንታ ፄላይስ፤ ዙማ ቦላ ኤቃዳ ኤንታ በአይስ። ኤንቲ ባንታርካ ደእያ ደረ፤ ኤንቲ ሀራ ካዎተꬃታፐ ዱማ ግደይሳ ኤሮሶና። ");
INSERT INTO gofe_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","ያይቆባ ባና ኦን ታይብ ኦንጋኔ? እስራኤለ ሳይሱዋ ኦን ታይብ ካንꬃኔ? ፅሎታ ሀይቁዋ ታ ሀይቃርክና፤ ታ ዉርሰꬃይ ኤንታይሳዳ ሀኖ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","ባላቅ ባላማኮ፥ “ኔኒ ታ ቦላ ኦꬅያባይ አይቤ? ታኒ ነና ታ ሞርከታ ባዳና መላ ኤሀስ፥ ሽን ኔኒ ኤንታ አንጃዳሳ፤ ሀራባ አይኮካ ኦꬃባካ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","ባላም ዛሪድ፥ “ጎዳይ ታዉ ኦደይሳፈ ሀራ ኦዶዬ?” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","ባላቅ ባላማኮ፥ “ኤንታ ኔኒ በአናዉ ዳንዳእያ ሀራ በሲ ታራ የꬋ፤ ያንካ ነ ኤንታፈ ጉꬃራ በኣሳፐ አትሽን፥ ኡባ በአካ። ኔኒ ያን ኤቃዳ ኤንታ ባዳርክ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","ፕስጋ ደርያ ሁጰን ደእያ ፆፍማ ደምባ ኤፍስ። ያን ላፑን ያርሾ በሳታ ግምብድ፥ እስ እስ ያርሾ በሳን እስ ኮርማነ እስ ማራዘ ያርሽስ። ");
INSERT INTO gofe_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","ባላም ባላቃኮ፥ “ኔኒ ሀይሳን ነ ያርሹዋ ማታን ደኣሻ፤ ታኒ ጎዳራ ጋሄታናዉ ገደ ባና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","ጎዳይ ባላማራ ጋሄትድ፥ “ኔኒ ባላቃኮ ስማዳ እያዉ ሀ ኪታ ኦዳ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","ባላም ስሚድ ያ ዎደ ባላቅ ሞአበ ቢታ ሀላቃታራ ያርሹዋ ማታን ኤቅዳይሳ ደምስ። ባላቅ እያኮ፥ “ጎዳይ ነዉ አይ ኦድዴ?” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","ባላም ሀይሳዳ ያግድ ትንብተ ኦድስ፤ “ስፎራ ናአዉ፥ ባላቃ፥ ደንዳ፤ ታ ኦደይሳ ሎይꬃዳ ስአ። ");
INSERT INTO gofe_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","ዎርዶታናዉ ፆሳይ አሰ ግደና፤ ባ ቆፋ ላማናዉ አሳ ናአ ግደና። ኦድድ፥ ባ ኦድዳይሳ ኦኔ? ዎይኮ ባ ግዳይሳ ፖለኔ? ");
INSERT INTO gofe_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","ታኒ አንጃናዉ ኪታ ኤካስ፤ እ አንጅስ፤ ታ ላማናዉ ዳንዳእከ። ");
INSERT INTO gofe_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","ያይቆባ ኮቻ ቦላ ኢታባይ ዬና፤ እስራኤለ አሳ መቶይ ጋከና። ጎዳይ፥ ኤንታ ፆሳይ ኤንታራ ደኤስ፤ እ ኤንታዉ ካዎ ግደይሳ አዋጆሶና። ");
INSERT INTO gofe_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","ፆሳይ ኤንታ ግብፀፈ ከስስ፤ እ ምኖ መንꬃዳ ኤንታዉ ኦለቴስ። ");
INSERT INTO gofe_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","ያይቆባ ኮቻ ቦላ ብት ኦና፤ እስራኤለ አሳ ቆሀና ሙሩኖይ ባዋ። ሄኮ፥ ያይቆባስነ እስራኤለስ ‘ፆሳይ ኦꬅዳባ በእተ’ ያጋና። ");
INSERT INTO gofe_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","ሀ አሳይ ማጫ ጋሞዳ ደንዴስ፤ ባ ኦይክዳባ ማና ጋካናዉ፥ ባ ዎꬍዳይሳ ሱꬃ ኡያና ጋካናዉ፥ ሸምፖና ጋሞዳ ደንዶሶና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","ያትን፥ ባላቅ ባላማኮ፥ “ነ ኤንታ ኡባካ ባዶፋ፤ ኡባካ አንጆፋ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","ባላም ዛሪድ፥ “ታኒ ጎዳይ ግያባ ፃላላ ኦꬃና ጋዳ ነዉ ኦዳብክና?” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","ባላቅ ባላማኮ፥ “ሃያ፤ ታ ነና ሀራ በሲ ኤፋና። ኦን ኤር፥ ሄሳን ፆሳይ ኡፋይትድ፥ ኔኒ ያን ኤቃዳ ኤንታ ባዳና መላ ኦꬃናዉ ዳንዳኤስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","ባላቅ ባላማ ባዙዋ ዱገ ፄልያ ፓኦራ ዙማ ቦላ ኤፍስ። ");
INSERT INTO gofe_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","ባላም፥ “ኔኒ ሀይሳን ታዉ ላፑን ያርሾ በሳታ ግምባ፤ ቃስ ላፑን ኮርማታነ ላፑን ማራዘታ ታዉ ጊግሳ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","ባላም ግዳይሳዳ ባላቅ ኦꬅስ፤ እስ እስ ያርሾ በሳን እስ ኮርማነ እስ ማራዘ ያርሽስ። ");
INSERT INTO gofe_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","ባላም እስራኤለ አንጀይስ ጎዳ ኡፋይስዳይሳ እ በእዳ ዎደ ካሰ እ ኦይሳዳ ብታ ማላ ኮይቤና፥ ሽን ባ ሶምኡዋ መላ ቢታኮ ዛርስ። ");
INSERT INTO gofe_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","እ ꬎቁ ግድ ፄልያ ዎደ እስራኤለ አሳይ ባ ኮቻን ኮቻን ዱንካንድ ኡትዳይሳ በእያ ዎደ ፆሳ አያናይ እያ ቦላ ዎꬍስ። ");
INSERT INTO gofe_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","እ ሀይሳዳ ያግድ ትንብተ ኦድስ፤ “ብኦራ ናኣ ባላማ ትንብትያ፤ እያ አይፈይ ዶየትን ፄልያ አድያ ትንብትያ፤ ");
INSERT INTO gofe_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","ፆሳይ ግያባ ስኤይሳ ትንብትያ፤ እ ሶምኦራ ጉፋንን፥ እያ አይፈይ ዶየትዳይስ፤ ኡባ ዳንዳእያ ፆሳ ቆንጨꬃ በእዳ አድያ ትንብተይ ሀይሳ። ");
INSERT INTO gofe_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","ያይቆባ፥ ነ ዱንካነት፥ እስራኤለ፥ ነ ጉታት፥ አይባ ሎኦና። ");
INSERT INTO gofe_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","ኤንቲ ምጨትዳ ዛንጋራዳ፥ ሻፋ ጋፃን ደእያ አታክልትያ በሳዳ፥ ጎዳይ ቶክዳ ጎዳረ ኡꬃዳ፥ ሃꬃ ጋፃን ደእያ ዝጋ ምꬃዳ ሀኖሶና። ");
INSERT INTO gofe_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","ኤንታ ፁጋይ ሃꬃን ኩማና፤ ኤንታ ኮቻይ ግድያ ሃꬅ ደማና። ኤንታ ካዎይ ካዋ አጋጋፐ አꬋና፤ ኤንታ ካዎተꬃይ ቦንቸታና። ");
INSERT INTO gofe_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","ፆሳይ ኤንታ ግብፀፈ ከስስ፤ እ ምኖ መንꬃዳ ኤንታዉ ኦለቴስ። ኤንታ ሞርከታ መንረꬄስ፤ ኤንታ መቀꬃ ጋጬስ፤ ባ ዶንግያን ጫዴስ። ");
INSERT INTO gofe_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","ኤንቲ ጋሞዳ ዝንእዶሶና፤ ማጫ ጋሞዳ ዛቁልዶሶና፤ ኤንታ ቦሸቻናዉ ዳንዳኤይ ኦኔ? ኤንታ አንጅያ ኡባይ አንጀታና፤ ኤንታ ባድያ ኡባይ ባደታና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","ያትን፥ ባላቅ ባላማ ቦላ ይሎትስ። ባ ኩሽያ ባቅድ ባላማኮ፥ “ታ ሞርከታ ባዳና መላ ታ ነና ኤሀስ፥ ሽን ኔኒ ሄꬑ ቶሆ ኤንታ አንጃዳሳ። ");
INSERT INTO gofe_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","ሀእ ኤለሳዳ ነ ሶ ባ፤ ታ ነና ዳሮባ ዎይታና ጋስ፥ ሽን ኔኒ ዎይቱዋ ኤኮና መላ ጎዳይ ነና ድግስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","ባላም ባላቃኮ ዛሪድ፥ “ኔኒ ታኮ ኪትዳ አሳኮ፥ ");
INSERT INTO gofe_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‘ባላቅ ሀር አቶሽን ባ ካዎተꬃን ኩምዳ ብራነ ዎርቃ ታዉ እምያባ ግድኮካ ጎዳይ ኦድዳይሳ መንꬃዳ ሎኦ ዎይኮ ኢታ ታ ሸነን ኦꬃናዉ ዳንዳእከ። ታኒ ጎዳይ ግያባ ፃላላ ኦዳና’ ጋዳ ነዉ ኦዳብክናዬ?” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","ባላም ባላቃኮ፥ “ታኒ ሀእ ታ አሳኮ ባይስ፤ ሽን ነ ሃያ፤ እስራኤለ አሳይ ያና ዎድያን ነ አሳ ኦꬃናባ ታ ነዉ ኦዳና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","እ ባ ትንብትያ ሀይሳዳ ያግድ ኦድስ፤ “እያ አይፈይ ትሽ ኦꬅድ ፄልያ፥ ብኦራ ናኣ ባላማ ትንብተይ ሀይሳ። ");
INSERT INTO gofe_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","ሀይስ ፆሳይ ግያባ ስኤይሳ ትንብትያ፥ ኡባ ዳንዳእያ ፆሳፈ ግድዳ ኤራተꬅ ደእያ ኡራይ። ልች ግድ ሶምኦራ ጉፋንን፥ እያ አይፈይ ዶየትዳይስነ ኡባ ዳንዳእያ ፆሳ ቆንጨꬃ በኤይሳ ትንብተይ ሀይሳ። ");
INSERT INTO gofe_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","“ታኒ እያ በአይስ፥ ሽን ዎደይ ሀእ ግደና፤ ታ እያ ፄላይስ፥ ሽን ማታን ዴና። ያይቆባ ሼሻፐ ፆልንቶይ ከያና፤ እስራኤለፐ ካዎተꬃ ፃምአይ ከያና። ሞአበ አሳ ሶምኡዋ እ ጋጫና፤ ሴታ አሳ ኡባ ሁጵያ እ ትንቻና። ");
INSERT INTO gofe_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","ኤዶመይ ፆነታና፤ እያ ሞርከይ ሳይረይ ኦይከታና፤ ሽን እስራኤለይ ምን ምን ባና። ");
INSERT INTO gofe_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","ያይቆባፐ ሃረይስ ከያና፤ ካታማን ፓፃ አትዳይሳታ ꬋይሳና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","ሄሳፈ ጉየ፥ ባላም አማለቃ በእድ ሀይሳዳ ያግድ ትንብተ ኦድስ፤ “አማለቅ ካዎተꬃታ ግዶን ኮይሮ፥ ሽን ኤንታ ዉርሰꬃይ ꬋዮ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","ቃስ ባላም ቄና በእድ ሀይሳዳ ያግድ ትንብተ ኦድስ። “ህንተ ደእያ በሳይ ሳሮ በሲ፤ ህንተ ኬꬃይ ዛላ ቦላ ኬፀትስ። ");
INSERT INTO gofe_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","ሽን አሶረት ህንተና ድእያ ዎደ፥ ህንተ ቄና አሳይ ꬋያና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","ዉርሰꬃን ባላም ሀይሳዳ ያግድ ትንብተ ኦድስ፤ “ፆሳይ ሄሳ ኦꬅያ ዎደ፥ ኦን ደኦን ዳናዉ ዳንዳኢ? ");
INSERT INTO gofe_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","ማርካበት ቆጵሮሳፐ ያና፤ ኤንቲ አሶረነ ኤቤራ ፆናና፤ ሽን ኤንትካ ቃስ ꬋያና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","ሄሳፈ ጉየ፥ ባላም ደንድድ ባ ሶ ስምስ፤ ባላቅካ ባ ኦግያ ብስ። ");
INSERT INTO gofe_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","እስራኤለ አሳይ ሴፅማ ጌተትያ በሳን ዱንካንድ ደእሽን፥ እስራኤለ አደት ሞአበ ማጫታራ ላይማቶ ዶምዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","ሄ ማጫሳት ባንታ ፆሳታ ያርሹዋ ማና መላ ፄግዶሶና። ኤንቲ ሄ ያርሾ ካꬃ ምድ ኤንታ ፆሳታ ጎይንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","እስራኤለት ብኤል-ፋጎራ ጌተትያ ኤቃ ጎይንዳ ግሾ ጎዳይ ኤንታ ቦላ ሀንቀትስ። ");
INSERT INTO gofe_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","ያትን፥ ጎዳይ ሙሰኮ፥ “ጎዳ ሀንቆይ እስራኤለፐ ስማና መላ ካለꬅያ አሳ ኡባ ኤፋዳ ሴታ ጋላስ ጎዳ ስንꬃን ካቃ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","ሙሰይ እስራኤለ ዳይናታኮ፥ “ህንተ እሶይ እሶይ ብኤል-ፋጎራ ጌተትያ ኤቃ ጎይንዳ አሳ ኡባ ዎꬍተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","ሙሰይነ ማባራይ ኡባይ ጌሻ ዱንካንያ ፐንገን ዬክሽን፥ እስራኤለታፐ እሶይ ምድያመ ማጫስዉ ኤንታ ስንꬃራ አꬅድ፥ ባ ኬꬃ አሳኮ ኤህስ። ");
INSERT INTO gofe_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","ካህንያ አሮና ናኣ አላዛራ ናአይ ፕንሃስ ሄሳ በእዳ ዎደ ማባራ ግዶፈ ደንድድ፥ ቶራ ኤክድ፥ ");
INSERT INTO gofe_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","እስራኤለ አድያ ካልድ ዱንካንያ ግዶ ገልድ፥ ኡራነ ማጫስዉ ቶራን ጫድድ ካንꬅ ከስስ። ሄስ ሀንን እስራኤለታ ዉርስያ ጋዶይ ኤቅስ። ");
INSERT INTO gofe_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","ሽን ሄ ጋዶይ ላታማነ ኦይዱ ሙኩሉ አሳ ዎꬍስ። ");
INSERT INTO gofe_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","ጎዳይ ሙሰኮ፥ ");
INSERT INTO gofe_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“ካህንያ አሮና ናኣ አላዛራ ናአይ ፕንሃስ እስራኤለ አሳ ግዶን ታኒ ታ ቦንቹዋስ ምሸተይሳዳ ምሸትዳ ግሾ፥ ታኒ ህንተ ቦላ ሀንቀትዳ ሀንቁዋ ዶሽስስ። ታኒ ታ ቃናትያን ኤንታ ፖሎ ꬋይሳብከ። ");
INSERT INTO gofe_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","ሄሳ ግሾ፥ ታኒ ታ ሳሮተꬃ ጫቁዋ እያራ ጫቃናይሳ ፕንሃሳስ ኦዳ። ");
INSERT INTO gofe_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","እ ባ ፆሳ ቦንቹዋስ ምሸትዳ ግሾነ እስራኤለ አሳስ ናጋራ አቶተꬃ ኤህዳ ግሾ፥ እነ እያ ኮቻይ መርናዉ ካህነ ግዳና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","ምድያመ ማጫሴራ ሀይቅዳ ኡራ ሱንꬃይ ሳሉ ናኣ ዝምራ ጌተቴስ። ሳሉ ስሞና ኮቻን እስ ኮቻ ሀላቃ። ");
INSERT INTO gofe_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","ሀይቅዳ ምድያመ ማጫሰ ሱንꬃይ ኮዝቦ፤ እ አዋይ ዙር ምድያመታ ኮቻ ሀላቃ። ");
INSERT INTO gofe_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","ጎዳይ ሙሰኮ፥ ");
INSERT INTO gofe_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“ምድያመ ቢታ አሳ ሞርክድ ኤንታ ዎꬍተ። ");
INSERT INTO gofe_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","ኤንቲ ህንተና ሞርክድ ፓኦራን ጭምዶሶና ቃስ ቦሻ ጋላስ ፓኦራን ሀይቅዳ ምድያመታ ኮቻ ሀላቃ ናኤ ኮዝብ ጋሶን ህንተና ሞርክዶሶና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","ቦሻፐ ጉየ፥ ጎዳይ ሙሰኮነ ካህንያ አሮና ናኣ አላዛራኮ፥ ");
INSERT INTO gofe_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“ላይꬅ ላታማነ እያፐ ቦላ ግድዳ እስራኤለታ፥ ኦላናዉ ዳንዳኤይሳታ ኡባ፥ ኤንታ ኬꬃን ኬꬃን ታይብተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","ያትን፥ ሙሰይነ ካህነይ አላዛር ዮርዳኖሰ ሻፋፐ ሄፍንꬃን፥ እያርኮ ማታን፥ ሞአበ ደንባን አሳ ሺሽድ፥ ");
INSERT INTO gofe_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“ጎዳይ ሙሰ ኪትዳይሳዳ፥ ላይꬅ ላታማነ እያፐ ቦላ አሳ ታይብዶሶና።” ግብፀፈ ከይዳ እስራኤለ አሳይ ሀይሳታ። ");
INSERT INTO gofe_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","እስራኤለ ባይራ ናኣ ሮቤላ ኮቻት ባንታ ኮቻን ኮቻን፥ ሀኖካ ኮቻ፥ ፋሉ ኮቻ፥ ");
INSERT INTO gofe_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","ሄስሮና ኮቻነ ካርማ ኮቻ፤ ");
INSERT INTO gofe_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","ሀይሳቲ ሮቤላ ኮቻታ፤ ኤንታ ኩመꬃ ታይቦይ 43,730. ");
INSERT INTO gofe_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","ፋሉ ናአይ ኤልኣባ፤ ");
INSERT INTO gofe_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","ኤልኣባ አደ ናይት ነሙኤላ፥ ዳታነነ አቤሮ። ዳታንነ አቤሮይ ማባራይ ዶርዳይሳታ፥ ሽን ኤንቲ ቆረነ እያ ካለይሳታራ ቶቢድ ጎዳ ቦላ ማካልድ ሙሰ ቦላነ አሮና ቦላ ደንድዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","ቢታይ ዶየትድ ኤንታ ቆረራ እስፈ ምትስ፤ ኤንታ ካልያ 250 አሳ ታም ምን ሀይቅዶሶና። ያትን፥ ሀራት ኤንታ በእድ ናገታና መላ ማላ ግድዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","ሽን ቆረ አደ ናይት ኡባይ ሀይቅድ ꬋይቦኮና። ");
INSERT INTO gofe_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","ስሞና ዘረꬃይ ባንታ ኮቻን ኮቻን፥ ነሙኤላ ኮቻ፥ ያምና ኮቻ፥ ያክና ኮቻ፥ ");
INSERT INTO gofe_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","ዛራ ኮቻነ ሳኡላ ኮቻ። ");
INSERT INTO gofe_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","ሀይሳቲ ስሞና ኮቻታ፤ ኤንታ ኩመꬃ ታይቦይ 22,200. ");
INSERT INTO gofe_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","ጋደ ዘረꬃይ ባንታ ኮቻ ኮቻን፥ ፅፎና ኮቻ፥ ሀግ ኮቻ፥ ሹና ኮቻ፥ ");
INSERT INTO gofe_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","ኤስና ኮቻ፥ ኤራ ኮቻ፥ ");
INSERT INTO gofe_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","አሮዳ ኮቻነ አርኤላ ኮቻ። ");
INSERT INTO gofe_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","ሀይሳቲ ጋደ ኮቻታ፤ ኤንታ ኩመꬃ ታይቦይ 40,500. ");
INSERT INTO gofe_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","ይሁዳ አደ ናይት ኤርነ ኦናን ካናነ ቢታን ሀይቅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","ይሁዳ ኮቻት ባንታ ኮቻን ኮቻን፥ ሴላ ኮቻ፥ ፋረሳ ኮቻነ ዛራ ኮቻ። ");
INSERT INTO gofe_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","ፋረሳ ኮቻይ ሄስሮናነ ሀሙላ። ");
INSERT INTO gofe_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","ሀይሳቲ ይሁዳ ኮቻታ፤ ኤንታ ኩመꬃ ታይቦይ 76,500. ");
INSERT INTO gofe_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","ይሳኮራ ዘረꬃይ ባንታ ኮቻን ኮቻን፥ ቶላ ኮቻ፥ ፑአ ኮቻ፥ ");
INSERT INTO gofe_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","ያሱባ ኮቻነ ሽምሮና ኮቻ። ");
INSERT INTO gofe_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","ሀይሳቲ ይሳኮራ ኮቻታ፤ ኤንታ ኩመꬃ ታይቦይ 64,300. ");
INSERT INTO gofe_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","ዛብሎና ዘረꬃይ ባንታ ኮቻን ኮቻን፥ ሳረዳ ኮቻ፥ ኤሎና ኮቻነ ያህላላ ኮቻ። ");
INSERT INTO gofe_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","ሀይሳቲ ዛብሎና ኮቻታ፤ ኤንታ ኩመꬃ ታይቦይ 60,500. ");
INSERT INTO gofe_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","ዮሰፋ ናይታ ምናሰነ ኤፍሬማ ኮቻት ባንታ ኮቻን ኮቻን፥ ");
INSERT INTO gofe_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","ምናሰይ ማክራ የልስ፥ ማክር ጋላዳ የልስ። ");
INSERT INTO gofe_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","ጋላዳ ኮቻት፥ እዘራ ኮቸ፥ ከለጋ ኮቸ፥ ");
INSERT INTO gofe_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","አስርኤላ ኮቸ፥ ሴከማ ኮቻ፥ ");
INSERT INTO gofe_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","ሻምዳ ኮቸነ ሄፌራ ኮቸ። ");
INSERT INTO gofe_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","ሄፌራ ናአይ ሰሎጳድ ማጫ ናአ ፃላላ የልስ፤ እያዉ አደ ናእ ባዋ። ሰሎጳዳ ማጫ ናይታ ሱንꬃይ ማህሎ፥ ኖኦ፥ ሆግሎ፥ ምልኮነ ትርፆ። ");
INSERT INTO gofe_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","ሀይሳቲ ምናሰ ኮቻታ፤ ኤንታ ኩመꬃ ታይቦይ 52,700. ");
INSERT INTO gofe_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","ኤፍሬማ ዘረꬃይ ባንታ ኮቻን ኮቻን፥ ሹቱላ ኮቻ፥ በከራ ኮቻ፥ ታሀና ኮቻታነ ");
INSERT INTO gofe_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","ሹቱላ ናኣ ኤራና ኮቻታ። ");
INSERT INTO gofe_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","ሀይሳቲ ኤፍሬማ ኮቻታ፤ ኤንታ ኩመꬃ ታይቦይ 32,500. ዮሰፋ ኮቻት ባንታ ኮቻን ኮቻን ሀይሳታ። ");
INSERT INTO gofe_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","ብንያመ ዘረꬃይ ባንታ ኮቻን ኮቻን፥ ቤላ ኮቻ፥ አስቤላ ኮቻ፥ አክራ ኮቻ፥ ");
INSERT INTO gofe_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","ሹፋማ ኮቻ፥ ሁፋማ ኮቻ፥ ");
INSERT INTO gofe_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","ቤላ ናኣ አራዳ ኮቻነ ቤላ ናኣ ናማነ ኮቻ። ");
INSERT INTO gofe_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","ሀይሳቲ ብንያመ ኮቻታ፤ ኤንታ ኩመꬃ ታይቦይ 45,600. ");
INSERT INTO gofe_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","ዳነ ዘረꬃይ ሳማ ኮቻ። ");
INSERT INTO gofe_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","ሹሃማ ኮቻ ኩመꬃ ታይቦይ 64,400. ");
INSERT INTO gofe_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","አሴራ ዘረꬃይ ባንታ ኮቻን ኮቻን፥ ይምና ኮቻ፥ ይስዋ ኮቻ፥ በርአ ኮቻ፥ ");
INSERT INTO gofe_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","በርአ ናአ ሄቤራ ኮቻነ በርአ ናኣ ማልክኤላ ኮቻ። ");
INSERT INTO gofe_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","አሴራስ ሳራሆ ጌተትያ ማጫ ናእ ደአዉሱ። ");
INSERT INTO gofe_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","ሀይሳቲ አሴራ ኮቻታ፤ ኤንታ ኩመꬃ ታይቦይ 53,400. ");
INSERT INTO gofe_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","ንፍታለመ ዘረꬃይ ባንታ ኮቻን ኮቻን፥ ያህፄላ ኮቻ፥ ጉና ኮቻ፥ ");
INSERT INTO gofe_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","የፀራ ኮቻነ ሽለመ ኮቻ። ");
INSERT INTO gofe_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","ሀይሳቲ ንፍታለመ ኮቻታ፤ ኤንታ ኩመꬃ ታይቦይ 45,400. ");
INSERT INTO gofe_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","ታይበትዳ እስራኤለ አደ አሳ ታይቦይ ኩመꬅ 601,730. ");
INSERT INTO gofe_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","ጎዳይ ሙሰኮ፥ ");
INSERT INTO gofe_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“ሀ ኮቻታስ ኤንታ ሱንꬃ ሱንꬃ ታይቡዋን ቢታ ሻካዳ ላታ ኦꬃዳ ኤንታዉ እማ። ");
INSERT INTO gofe_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","ታይቦን ዳረይሳታስ ዳርሳዳ ቃስ ታይቦን ጉፀይሳታስ ጉꬃዳ እማ። ኡባይካ ፃፈትዳ ባንታ ታይቡዋ ኬና ኤኮ። ");
INSERT INTO gofe_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","ሽን ቢታይ ሳማን ሻከቶ፤ እስ እስ ኮቻይ ላታ ኤከይ ባ ኮቻ ሱንꬃን ግዶ። ");
INSERT INTO gofe_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","እስ እስ ላታይ ታይቦን ዳሮታ ግዶንነ ታይቦን ጉꬃታ ግዶን ሳማን ሻከቴስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","ባንታ ዘረꬃን ዘረꬃን ታይበትዳ ሌወ ኮቻት ሀይሳታ፤ ገድሶና ኮቻ፥ ቃሃታ ኮቻነ መራራ ኮቻ። ");
INSERT INTO gofe_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","ሀይሳቲካ ቃስ ሌወ ኮቻታ፤ ልብና ኮቻ፥ ከብሮና ኮቻ፥ ሞሆላ ኮቻ፥ ሙሰ ኮቻነ ቆረ ኮቻ። ቃሃት አምራማ የልስ። ");
INSERT INTO gofe_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","አምራማ ማቸ ሱንꬃይ ዮከቤዶ፤ እያ ግብፀን ሌወፐ የለትዳ ሌወ ናአ። እያ አሮና፥ ሙሰነ ኤንታ ምችዉ ማይራሞ የላሱ። ");
INSERT INTO gofe_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","አሮናስ ናዳበ፥ አብዮዳ፥ አላዛራነ እታማራ ጌተትያ ኦይዱ ናይት ደኦሶና። ");
INSERT INTO gofe_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","ሽን ናዳበይነ አብዮድ ጎዳ ስንꬃን ጌሽ ግዶና ታማን ያርሾ ያርሽዳ ግሾ ቦሻን ሀይቅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","ላይꬅ እስ አጌናነ እያፐ ቦላ ግድዳ ሌወ አደ ናይታ ታይቦይ ላታማነ ሄꬑ ሙኩላ። እስራኤለ አሳ ግዶን ኤንታዉ ላታ ቢት እመትቦና ግሾ ኤንቲ እስራኤለታራ ታይበትቦኮና። ");
INSERT INTO gofe_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","ዮርዳኖሰ ሻፋፐ ሄፍንꬃን፥ እያርኮ ማታን፥ ሞአበ ደንባን ሙሰይነ ካህነይ አላዛር እስራኤለ አሳ ታይብዳ ዎደ ታይበትዳ አሳይ ሀይሳ። ");
INSERT INTO gofe_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","ሙሰይነ ካህነይ አሮን ኮይሮ ሲና መላ ቢታን እስራኤለ ታይብዳ ዎደ ታይበትዳ አሳፐ መፅ እስ አስካ አትቤና። ");
INSERT INTO gofe_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","ጎዳይ ሀ እስራኤለታባ፥ “ኤንቲ ኡባይ መላ ቢታን ሀይቃና” ያግድ ኦድዳ ግሾ፥ ዮፎና ናኣ ካለባፐነ ናወ ናኣ እያሱፐ አትሽን፥ ሀር እስ አስካ አትቤና። ");
INSERT INTO gofe_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","ሰሎጳድ ሄፌራ ናአ፤ ሄፌር ጋላዳ ናአ፤ ጋላድ ማክራ ናአ፤ ማክር ምናሰ ናአ፤ ምናሰይ ዮሰፋ ናአ። ሰሎጳዳ ማጫ ናይት ማህሎ፥ ኖኦ፥ ሆግሎ፥ ምልኮነ ትርፆ። ");
INSERT INTO gofe_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","ሀ ማጫ ናይት ጌሻ ዱንካንያ ፐንገን ሙሰ ስንꬃን፥ ካህንያ አላዛራ ስንꬃን፥ ሀላቃታ ስንꬃንነ ማባራ ኡባ ስንꬃን ኤቅድ፥ ");
INSERT INTO gofe_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“ኑ አዋይ መላ ቢታን ሀይቅስ፤ እ ባ ናጋራ ጋሶን ሀይቅስፐ አትሽን፥ ጎዳ ቦላ ደንድዳ ቆረ ካለይሳታ ግዶን ዴና። እያዉ አደ ናእ ባዋ። ");
INSERT INTO gofe_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","ያትን፥ ኑ አዋይ አደ ናአ የልቦና ግሾ እያ ሱንꬃይ እያ ኮቻ ግዶፈ ዋንድ ꬋዪ? ኑ አዋ ዳቦታ ግዶን ኑስ ላታ ቢታ እማ” ግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","ያትን፥ ሙሰይ ኤንታ ኦይሻ ጎዳ ስን ሺሽስ። ");
INSERT INTO gofe_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","ጎዳይ ሙሰኮ፥ ");
INSERT INTO gofe_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“ሰሎጳዳ ማጫ ናይታ ኦይሻይ ልከ፤ ኤንታ አዋ ዳቦታ ግዶን ኔኒ ኤንታዉ ላታ ቢታ እማ፤ እያ ግሾይ ኤንታ ላታ ግዶ። ");
INSERT INTO gofe_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","ቃስ እስራኤለ አሳኮ፥ ‘እስ አስ አደ ናአ የሎና ሀይቅኮ እያ ማጫ ናይት ላቶ። ");
INSERT INTO gofe_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","እያዉ ማጫ ናእ ባይናባ ግድኮ እያ እሻት ላቶ። ");
INSERT INTO gofe_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","እያዉ እሽ ባይናባ ግድኮ እያ አዋ እሻት ላቶ። ");
INSERT INTO gofe_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","እያዉ አዋ እሽ ባይናባ ግድኮ እያ ማታ ዳቦይ ላቶ። ታኒ ጎዳይ ነና ኪትዳይሳዳ ሀይስ እስራኤለ አሳስ ዎጋ ግዶ’ ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","ጎዳይ ሙሰኮ፥ “አባሪማ ዙማ ቦላ ከያዳ ታ እስራኤለ አሳስ እምዳ ቢታ በአ። ");
INSERT INTO gofe_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","ነ በእዳፐ ጉየ፥ ነ እሻ አሮናዳ ነካ ሀይቃዳ ነ ማይዛታን ጋሄታና። ");
INSERT INTO gofe_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","ፂና መላ ቢታን፥ ማርባ ሃꬃ ማታን አሳይ ታ ቦላ ዙዙምዳ ዎደ ህንተ ናምአይ ኤንታ ስንꬃን ታና ጌሽ ኦꬅድ ቦንችቤከታ” ያግስ። (ማርባ ሃꬃይ ፂና መላ ቢታን፥ ቃደሳ ጌተትያ በሳን ደእያ ፑልቶ።) ");
INSERT INTO gofe_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","ሙሰይ ጎዳኮ፥ ");
INSERT INTO gofe_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“አሳ ኡባስ ደኦ እምያ ጎዳ ፆሳዉ፥ ነ አሳይ ሄንꬃንቾይ ባይና ዉደ መላ ግዶናዳ፥ ");
INSERT INTO gofe_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","ሀ አሳ ስንꬃን ከያነ ገልያ ቃስ ኤንታ ካለꬅድ ከስያነ ገልስያ እስ አስ ሀ ማባራ ቦላ ሹማ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","ጎዳይ ሙሰኮ፥ “አያናይ እያን ደእያ ናወ ናኣ እያሱ ኤካዳ ነ ኩሽያ እያ ቦላ ዎꬃ። ");
INSERT INTO gofe_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","እያ ካህንያ አላዛራ ስንꬃንነ ማባራ ኡባ ስንꬃን ኤሳዳ ኤንቲ በእሽን ሹማ። ");
INSERT INTO gofe_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","እስራኤለ ኡባይ እያዉ ኪተታና መላ ነ ማታፐ እያዉ ሻካዳ እማ። ");
INSERT INTO gofe_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","እካ ኡሪመን ጎዳ ሸንያ ኦይችድ ሻክያ ካህንያ አላዛራ ስንꬃን ኤቆ። እያሱይነ እስራኤለ ማባራይ ኡባይ አላዛራ ኪታን ከዮነ ገሎ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","ሙሰይ ጎዳይ ኪትዳይሳዳ ኦꬅስ፤ እያሱ ኤፍድ፥ ካህንያ አላዛራ ስንꬃንነ ማባራ ኡባ ስንꬃን ኤስስ። ");
INSERT INTO gofe_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","ጎዳይ ኪትዳይሳዳ ሙሰይ ባ ኩሽያ እያ ቦላ ዎꬅድ ሹምስ። ");
INSERT INTO gofe_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","ጎዳይ ሙሰኮ፥ ");
INSERT INTO gofe_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“እስራኤለ አሳ ሀይሳዳ ያጋዳ ኪታ፤ ፁገትያ ሳውያ ካꬃ ያርሾ ዎደን ዎደን ታዉ ያርሽተ። ");
INSERT INTO gofe_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","ጎዳስ ታማን ፁገትድ ያርሸትያ ያርሾይ ሀይሳ፤ ኩመꬃ ቦላራ ደእያ እስ ላይꬅ ኩምዳ ናምኡ ማራዘታ ዎንታ ዎንታ ፁሳ ያርሾ ኦꬅድ ያርሽተ። ");
INSERT INTO gofe_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","ማራዘታፐ እሱዋ ዎንታ እሱዋ ቃስ ኦማርስ ያርሽተ። ");
INSERT INTO gofe_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","ቃስ ሄ ማራዝያራ እስ ልትሮ ሻማሆ ዛይተን ሙኑቀትዳ እስ ክሎ ግራመ ሎኦ ግስተ ꬊለ ካꬃ ያርሾ ያርሽተ። ");
INSERT INTO gofe_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","ሀይስ ጎዳ ኡፋይስያ ፁሳ ያርሾ። እካ ሲና ዙማ ቦላ ያርሸትዳ ኮይሮ ፁሳ ያርሾ። ");
INSERT INTO gofe_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","ኮይሮ ማራዝያራ እስ ልትሮ ጫላ ዎይነ ኡሻ ያርሾ ኦꬅድ ያርሾ በሳን ጎዳስ ጉስተ። ");
INSERT INTO gofe_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","ኦማርስ ናምአንꬆ ማራዝያ ያርሽያ ዎደ ኮይሮይሳ መላ ካꬃ ያርሹዋነ ኡሻ ያርሹዋ ጉጅድ ያርሽተ። እካ ጎዳ ኡፋይስያ ሳዎ ያርሾ ግዳና።” ");
INSERT INTO gofe_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“ሳምባታ ጋላስ ቦረይ ባይና እስ ላይꬅ ኩምዳ ናምኡ ማራዘታ ዛይተን ሙኑቀትዳ ናምኡ ክሎ ግራመ ሎኦ ግስተ ꬊለ ኤክድ ካꬃ ያርሾነ ኡሻ ያርሾ ኦꬅድ ያርሽተ። ");
INSERT INTO gofe_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","ጋላስ ጋላስ ያርሸትያ ፁሳ ያርሹዋ ቦላ ሳምባታን ሳምባታን ህንተ ያርሻና ፁሳ ያርሾይነ ኡሻ ያርሾይ ሀይሳ።” ");
INSERT INTO gofe_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“አጌን ፄርያ ኮይሮ ጋላስ ናምኡ ዎፋኖታ፥ እስ ማራዘነ እስ ላይꬅ ኩምዳ ቦረይ ባይና ላፑን ዶርሳ ኡርገታ ፁሳ ያርሾ ኦꬅድ ጎዳስ ያርሽተ። ");
INSERT INTO gofe_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","እስ እስ ዎፋኑዋራ ሻማሆ ዛይተን ሙኑቀትዳ ሄꬑ ክሎ ግራመ ግድያ ሎኦ ግስተ ꬊለራ ካꬃ ያርሾ ኦꬅድ ያርሽተ። ቃስ ሻማሆ ዛይተን ሙኑቀትዳ ናምኡ ክሎ ግራመ ግድያ ሎኦ ግስተ ꬊልያ ማራዝያራ ዎላ ያርሻ። ");
INSERT INTO gofe_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","ላፑን ማራዘታፐ እስ እስ ማራዘ ሻማሆ ዛይተን ሙኑቀትዳ እስ ክሎ ግራመ ሎኦ ግስተ ꬊለራ ፁገትያ ሳውያ ካꬃ ያርሾ ኦꬃዳ ጎዳስ ያርሻ። ");
INSERT INTO gofe_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","ቃስ ኡሻ ያርሹዋ እስ እስ ዎፋኑዋስ ናምኡ ልትሮ ዎይነ፥ እስ ማራዝያስ እስ ልትሮነ ባጋ ዎይነ ኡሻነ እስ እስ ዶርሳ ኡርግያስ እስ ልትሮ ግድያ ዎይነ ኡሽ ሺሽተ። ሀይስ ላይꬃ ግዶን አጌን ፄርያ ኮይሮ ጋላሳን ኦሰትያ ፁሳ ያርሾ። ");
INSERT INTO gofe_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","ጋላስ ጋላስ ያርሸትያ ፁሳ ያርሹዋ ቦላነ ኡሻ ያርሹዋ ቦላ እስ ኮለ ናጋራ ያርሾ ኦꬅድ ጎዳስ ያርሽተ።” ");
INSERT INTO gofe_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","“ኮይሮ አጌናን ታማነ ኦይዳንꬆ ጋላሳይ ጎዳ ፓስካ ቦንችያ ጋላስ ግዶ። ");
INSERT INTO gofe_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","ቃስ ሄ አጌናን ታማነ እቻሻንꬆ ጋላሳን ኡይꬃ ባለይ ቦንቸቴስ፤ ሄ ጋላሳፐ ዶምድ ላፑን ጋላስ ጋካናዉ እርሾይ ገልቦና ኡይꬃ ሚተ። ");
INSERT INTO gofe_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","ሄ ጋላሳታፐ ኮይሮ ጋላሳን ጎይናናዉ ሺቅተ፤ ሄ ጋላሳን አይ ኦሶካ ኦꬆፍተ። ");
INSERT INTO gofe_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","ቦረይ ባይና ናምኡ ዎፋኖታ፥ እስ ማራዘነ እስ ላይꬅ ኩምዳ ላፑን ዶርሳ ኡርገታ ፁሳ ያርሾ ኦꬅድ ጎዳስ ያርሽተ። ");
INSERT INTO gofe_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","እስ ዎፋኑዋራ ሻማሆ ዛይተን ሙኑቀትዳ ሄꬑ ክሎ ግራመ ሎኦ ግስተ ꬊለ፥ እስ ማራዝያራ ናምኡ ክሎ ግራመ ꬊለነ ");
INSERT INTO gofe_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","ላፑን ዶርሳ ኡርገታፐ እስ እስ ዶርሳራ እስ ክሎ ግራመ ꬊለ ያርሽተ። ");
INSERT INTO gofe_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","ቃስ እስ ዴሽ ደርያ ናጋራስ አቶተꬅ ግዳና መላ ናጋራ ያርሾ ኦꬅድ ያርሽተ። ");
INSERT INTO gofe_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","ሄሳ ኡባ ዎደ ጋላስ ጋላስ ያርሸትያ ያርሹዋ ቦላ ጉጅድ ያርሽተ። ");
INSERT INTO gofe_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","ኡባ ዎደ ኦሰትያ ፁሳ ያርሹዋ ቦላነ ኡሻ ያርሹዋ ቦላ ጉጅድ ላፑን ጋላስ ጎዳስ ሳውያ ካꬃ ያርሾ ኦꬅድ ያርሽተ። ");
INSERT INTO gofe_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","ላፑንꬃ ጋላሳን ጎይኖስ ሺቅተ፤ ሄ ጋላስ አይ ኦሶካ ኦꬆፍተ።” ");
INSERT INTO gofe_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","“ካꬃ ሺሾ ባኣለ ሳምንታን ኮይሮ ጋላስ ጎይኖስ ሺቅያ ዎደ ህንተ ኦራꬃ ካꬃፈ ያርሾ ያርሽተ፤ ሄ ዎደ አይ ኦሶካ ኦꬆፍተ። ");
INSERT INTO gofe_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","ናምኡ ዎፋኖታ፥ እስ ማራዝያነ እስ ላይꬅ ኩምዳ ላፑን ዶርሳ ኡርገታ ጎዳስ ሳውያ ፁሳ ያርሾ ኦꬅድ ያርሽተ። ");
INSERT INTO gofe_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","እስ እስ ዎፋኑዋራ ሻማሆ ዛይተን ሙኑቀትዳ ሄꬑ ክሎ ግራመ ሎኦ ግስተ ꬊለ፥ እስ ዶርሳ ኡርግያራ ናምኡ ክሎ ግራመ ꬊለነ ");
INSERT INTO gofe_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","ላፑን ዶርሳ ኡርገታፐ እስ እስ ኡርግያራ እስ ክሎ ግራመ ግስተ ꬊለ ኤክድ ያርሽተ። ");
INSERT INTO gofe_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","እያ ቦላ ጉጅድ እስ ኮለ ናጋራ አቶꬃ ያርሾ ኦꬅድ ያርሽተ። ");
INSERT INTO gofe_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","ጋላስ ጋላስ ያርሸትያ ያርሹዋ ቦላነ ኡሻ ያርሹዋ ቦላ ካꬃ ያርሾ ያርሽተ። ህንተ ያርሽያ መሄት ቦረይ ባይናባ ግዶ።” ");
INSERT INTO gofe_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“ላፑንꬃ አጌናስ ኮይሮ ጋላሳን ጎይናናዉ ሺቅተ፤ አይ ኦሶካ ኦꬆፍተ፤ ሄ ጋላሳይ ሞይዘይ ፑነትያ ጋላስ። ");
INSERT INTO gofe_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","ቦረይ ባይና እስ ዎፋኖ፥ እስ ማራዘነ እስ ላይꬅ ኩምዳ ላፑን ዶርሳ ኡርገታ ሳውያ ፁሳ ያርሾ ኦꬅድ ጎዳስ ያርሽተ። ");
INSERT INTO gofe_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","ሄ ዎፋኑዋራ ሻማሆ ዛይተን ሙኑቀትዳ ሄꬑ ክሎ ግራመ ሎኦ ግስተ ꬊለ፥ እስ ማራዝያራ ናምኡ ክሎ ግራመ ግስተ ꬊለነ፥ ");
INSERT INTO gofe_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","ላፑን ዶርሳ ኡርገታፐ እስ እስ ኡርግያራ እስ ክሎ ግራመ ꬊለ ያርሽተ። ");
INSERT INTO gofe_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","ቃስ እስ ኮለ ህንተዉ ናጋራ አቶተꬃስ ያርሽተ። ");
INSERT INTO gofe_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","ዎጋይ ኪተይሳꬆ፥ አጌና ፄሮን ያርሸትያ ፁሳ ያርሾ ቦላ፥ ካꬃ ያርሾ ቦላ፥ ጋላስ ጋላስ ያርሸትያ ፁሳ ካꬃ ያርሾ ቦላነ ኡሻ ያርሾ ቦላ ጉጅድ ያርሽተ፤ ሄስ ጎዳ ሳውያ ፁሳ ያርሾ። ");
INSERT INTO gofe_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","“ላፑንꬃ አጌናን ታማንꬆ ጋላሳን አይ ኦሶካ ኦꬆፍተ፤ ህንተና ካዉሽድ ጎይኖስ ሺቅተ። ");
INSERT INTO gofe_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","ቦረይ ባይና እስ ዎፋኖ፥ እስ ማራዘነ እስ ላይꬅ ኩምዳ ላፑን ዶርሳ ኡርገታ ሳውያ ፁሳ ያርሾ ኦꬅድ ጎዳስ ያርሽተ። ");
INSERT INTO gofe_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","ካꬃ ያርሾ ኦꬅድ እስ ዎፋኖራ ሻማሆ ዛይተን ሄꬑ ክሎ ግራመ ሎኦ ግስተ ꬊለ፥ እስ ዶርሳ ኡርግያራ ናምኡ ክሎ ግራመ ꬊለነ ");
INSERT INTO gofe_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","ላፑን ዶርሳ ኡርገታፐ እስ እስ ኡርግያራ እስ ክሎ ግራመ ꬊለ ያርሽተ። ");
INSERT INTO gofe_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","ቃስ ናጋራ ያርሾ ኦꬅድ እስ ኮለ ያርሽተ። ናጋራ አቶꬃ ያርሹዋ ቦላ፥ ጋላስ ጋላስ ያርሸትያ ፁሳ ያርሹዋ ቦላ፥ ካꬃ ያርሹዋ ቦላነ ኡሻ ያርሹዋ ቦላ ሄሳ ጉጅድ ያርሽተ። ");
INSERT INTO gofe_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","“ላፑንꬃ አጌናን ታማነ እቻሻንꬆ ጋላሳን፥ ዴፆ ኦሶ ኦꬆፍተ፤ ላፑን ጋላስ ኩመꬅ ጎዳ ቦንቻናዉ ሻቃራ ባኣለ ቦንችተ። ");
INSERT INTO gofe_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","ቦረይ ባይና ታማነ ሄꬑ ዎፋኖታ፥ ናምኡ ማራዘታ፥ እስ ላይꬅ ኩምዳ ታማነ ኦይዱ ዶርሳ ኡርገታ ሳውያ ፁሳ ያርሾ ኦꬅድ ጎዳስ ያርሽተ። ");
INSERT INTO gofe_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","ካꬃ ያርሾ ግዳና መላ ታማነ ሄꬑ ዎፋኖታፐ እስ እስ ዎፋኑዋራ ሻማሆ ዛይተን ሙኑቀትዳ ሄꬑ ክሎ ግራመ ሎኦ ግስተ ꬊለ፥ ናምኡ ማራዘታፐ እስ እስ ኡርግያራ ናምኡ ክሎ ግራመ ꬊለነ ");
INSERT INTO gofe_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","ታማነ ኦይዱ ዶርሳ ኡርገታፐ እስ እስ ኡርግያራ እስ ክሎ ግራመ ꬊለ ያርሽተ። ");
INSERT INTO gofe_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","ቃስ ናጋራ ያርሹዋስ እስ ኮለ ያርሽተ። ሄስ ጋላስ ጋላስ ፁሳ ያርሹዋ ቦላ፥ ካꬃ ያርሹዋ ቦላነ ኡሻ ያርሾ ቦላ ጉጅድካ ያርሽተ። ");
INSERT INTO gofe_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","“ናምአንꬆ ጋላሳን ታማነ ናምኡ ቦረይ ባይና ዎፋኖታ፥ ናምኡ ማራዘታነ እስ ላይꬅ ኩምዳ ታማነ ኦይዱ ኡርገታ ያርሽተ። ");
INSERT INTO gofe_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","ዎፋኖታራ፥ ማራዘታራነ ዶርሳ ኡርገታራ ካꬃ ያርሹዋነ ኡሻ ያርሹዋ ዎጋይ ኪተይሳ መላ ኤንታ ታይቡዋዳ ያርሽተ። ");
INSERT INTO gofe_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","ጋላስ ጋላስ ያርሸትያ ፁሳ ያርሹዋ ቦላ፥ ካꬃ ያርሹዋ ቦላነ ኡሻ ያርሹዋ ቦላ ጉጅድ ናጋራ ያርሹዋስ እስ ኮለ ያርሽተ። ");
INSERT INTO gofe_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","“ሄꬓንꬆ ጋላሳን ቦረይ ባይና ታማነ እስ ዎፋኖታ፥ ናምኡ ማራዘታ እስ ላይꬅ ኩምዳ ታማነ ኦይዱ ዶርሳ ኡርገታ ያርሽተ። ");
INSERT INTO gofe_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","ዎፋኖታራ፥ ማራዘታራነ ዶርሳ ኡርገታራ ካꬃ ያርሹዋነ ኡሻ ያርሹዋ ዎጋይ ኪተይሳ መላ ኤንታ ታይቡዋዳ ያርሽተ። ");
INSERT INTO gofe_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","ጋላስ ጋላስ ያርሸትያ ፁሳ ያርሹዋ ቦላ፥ ካꬃ ያርሹዋ ቦላነ ኡሻ ያርሹዋ ቦላ ናጋራ ያርሾስ እስ ኮለ ጉጅድ ያርሽተ። ");
INSERT INTO gofe_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","“ኦይዳንꬆ ጋላሳን ቦረይ ባይና ታሙ ዎፋኖታ፥ ናምኡ ማራዘታነ እስ ላይꬅ ኩምዳ ታማነ ኦይዱ ዶርሳ ኡርገታ ያርሽተ። ");
INSERT INTO gofe_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","ዎፋኖታራ፥ ማራዘታራነ ዶርሳ ኡርገታራ ካꬃ ያርሹዋነ ኡሻ ያርሹዋ ዎጋይ ኪተይሳ መላ ኤንታ ታይቡዋዳ ያርሽተ። ");
INSERT INTO gofe_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","ጋላስ ጋላስ ያርሸትያ ፁሳ ያርሹዋ ቦላ፥ ካꬃ ያርሹዋ ቦላነ ኡሻ ያርሹዋ ቦላ ጉጅድ ናጋራ ያርሾስ እስ ኮለ ያርሽተ። ");
INSERT INTO gofe_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","“እቻሻንꬆ ጋላሳን ቦረይ ባይና ኡዱፉን ዎፋኖታ፥ ናምኡ ማራዘታነ እስ ላይꬅ ኩምዳ ታማነ ኦይዱ ዶርሳ ኡርገታ ያርሽተ። ");
INSERT INTO gofe_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","ዎፋኖታራ፥ ማራዘታራነ ዶርሳ ኡርገታራ ካꬃ ያርሹዋነ ኡሻ ያርሹዋ ዎጋይ ኪተይሳዳ ኤንታ ታይቡዋዳ ያርሽተ። ");
INSERT INTO gofe_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","ጋላስ ጋላስ ያርሸትያ ፁሳ ያርሹዋ ቦላ፥ ካꬃ ያርሹዋ ቦላነ ኡሻ ያርሹዋ ቦላ ጉጅድ ናጋራ ያርሾስ እስ ኮለ ያርሽተ። ");
INSERT INTO gofe_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","“ኡሱፑንꬆ ጋላሳን ቦረይ ባይና ሆስፑን ዎፋኖታ፥ ናምኡ ማራዘታነ እስ ላይꬅ ኩምዳ ታማነ ኦይዱ ዶርሳ ኡርገታ ያርሽተ። ");
INSERT INTO gofe_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","ዎፋኖታራ፥ ማራዘታራነ ዶርሳ ኡርገታራ ካꬃ ያርሹዋነ ኡሻ ያርሹዋ ዎጋይ ኪተይሳ መላ ኤንታ ታይቡዋዳ ያርሽተ። ");
INSERT INTO gofe_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","ጋላስ ጋላስ ያርሸትያ ፁሳ ያርሹዋ ቦላ፥ ካꬃ ያርሹዋ ቦላነ ኡሻ ያርሹዋ ቦላ ጉጅድ ናጋራ ያርሾስ እስ ኮለ ያርሽተ። ");
INSERT INTO gofe_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","“ላፑንꬃ ጋላሳን ላፑን ዎፋኖታ፥ ናምኡ ማራዘታነ እስ ላይꬅ ኩምዳ ታማነ ኦይዱ ዶርሳ ኡርገታ ያርሽተ። ");
INSERT INTO gofe_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","ዎፋኖታራ፥ ማራዘታራነ ዶርሳ ኡርገታራ ካꬃ ያርሹዋነ ኡሻ ያርሹዋ ዎጋይ ኪተይሳ መላ ኤንታ ታይቡዋዳ ያርሽተ። ");
INSERT INTO gofe_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","ጋላስ ጋላስ ያርሸትያ ፁሳ ያርሹዋ ቦላ፥ ካꬃ ያርሹዋ ቦላነ ኡሻ ያርሹዋ ቦላ ጉጅድ ናጋራ ያርሾስ እስ ኮለ ያርሽተ። ");
INSERT INTO gofe_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","“ሆስፑንꬃ ጋላሳን ጎይናናዉ ሺቅተ፤ አይ ኦሶካ ኦꬆፍተ። ");
INSERT INTO gofe_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","ቦረይ ባይና እስ ዎፋኖ፥ እስ ማራዘ፥ እስ ላይꬅ ኩምዳ ላፑን ዶርሳ ኡርገታ ሳውያ ፁሳ ያርሾ ኦꬅድ ጎዳስ ያርሽተ። ");
INSERT INTO gofe_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","ዎፋኖታራ፥ ማራዘታራነ ዶርሳ ኡርገታራ ካꬃ ያርሹዋነ ኡሻ ያርሹዋ ዎጋይ ኪተይሳዳ ኤንታ ታይቡዋዳ ያርሽተ። ");
INSERT INTO gofe_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","ጋላስ ጋላስ ያርሸትያ ፁሳ ያርሹዋ ቦላ፥ ካꬃ ያርሹዋ ቦላነ ኡሻ ያርሹዋ ቦላ ጉጅድ ናጋራ ያርሾስ እስ ኮለ ያርሽተ። ");
INSERT INTO gofe_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","“ህንተ ጋሶ ያርሹዋ ቦላነ ህንተ ዶሳ ያርሹዋ ቦላ ፁሳ ያርሾ፥ ካꬃ ያርሾ፥ ኡሻ ያርሾነ እስፈተꬃ ያርሾ ባልያ ቦንቻናዉ ኪተትዳ ዎድያን ያርሽተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","ሙሰይ፥ ጎዳይ ባና ኪትዳይሳ ኡባ እስራኤለ አሳስ ኦድስ። ");
INSERT INTO gofe_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","ሙሰይ እስራኤለ ዘረꬃ ሀላቃታኮ፥ “ጎዳ ኪታይ ሀይሳ፤ ");
INSERT INTO gofe_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","እስ አስ ጎዳስ እስባ ኦꬃናዉ ጫቅኮ ዎይኮ እስባፐ ባና ናጋናዉ ቃንግኮ ጉየ ጎና ፖሎ። ");
INSERT INTO gofe_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","“ባ አዋ ሶን ደእያ ጌላእያ ጎዳስ እስባ ኦꬃናዉ ጫቅኮ ዎይኮ እስባፐ ባና ናጋናዉ ቃንግኮ፥ ");
INSERT INTO gofe_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","እ አዋይ እያ ጫቅዳይሳ ዎይኮ እያ ቃንገትዳይሳ ስእድ፥ እዮ ድጎና እፅኮ፥ እያ ፖላናዉ ኮሼስ። ");
INSERT INTO gofe_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","ሽን እ አዋይ ሄሳ ስእድ እዮ ድግኮ እ ጫቆይነ እ ቃንገꬃይ አታናዉ ዳንዳኤስ። እ አዋይ እዮ ድግዳ ግሾ ጎዳይ እዉ አቶ ጋና። ");
INSERT INTO gofe_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","“ገሎና ማጫ ናእያ ጫቃዳ ደአሸ ዎይኮ እስባፐ ባና ናጋናዉ ቃንገታዳ ደአሸ አዝና ገልኮ፥ ");
INSERT INTO gofe_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","እ አዝናይ ሄሳ ስእድ እዮ ድጎና እፅኮ እያ ባ ጫቁዋነ ባ ቃንገꬃ ፖላናዉ ኮሼስ። ");
INSERT INTO gofe_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","ሽን እ አዝናይ ሄሳ ስእድ እዮ ድግኮ እያ ጫቅዳ ጫቆይ ዎይኮ ቃንገትዳ ቃንገꬃይ እዮ ጎመና። ሄሳ ጎዳይ እዉ አቶ ጋና። ");
INSERT INTO gofe_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","“ሽን አምእያ ዎይኮ ሳዮ ማጫስ ጫቅዳ ጫቁዋ ዎይኮ ቃንግዳ ቃንገꬃ ፖላናዉ በሴስ። ");
INSERT INTO gofe_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","“አዝናራ ደእያ ማጫስ ጫቅኮ ዎይኮ እስባ ኦꬃናዉ ቃንግኮ፥ ");
INSERT INTO gofe_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","እ አዝናይ ሄሳ ስእድ እዮ ድጎና እፅኮ፥ እያ ጫቅዳ ጫቁዋነ ቃንገትዳ ቃንገꬃ ፖሎ። ");
INSERT INTO gofe_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","እ አዝናይ ሄሳ ስእዳ ጋላስ እዮ ድግኮ እ ጫቆይ ዎይኮ እያ ኦꬃናዉ ቃንገትዳ ቃንገꬃይ እዮ ጎመና። እ አዝናይ ድግዳ ግሾ ጎዳይ እዉ አቶ ጋና። ");
INSERT INTO gofe_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","እ አዝናይ እያ ጫቅዳ ጫቁዋ ዎይኮ እያ ባና ካዉሻናዉ ቃንገትዳ ቃንገꬃ ላላናዉ ዎይኮ ምንꬃናዉ ዳንዳኤስ። ");
INSERT INTO gofe_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","ሽን እ አዝናይ ሄ ጋላስ ዎይኮ ዎንተꬃ ጋላስ አይኮካ ጎና እፅኮ፥ እ ጫቁዋ ዎይኮ እ ቃንገꬃ ምንꬅስ ጉሱ። እ ሄሳ ስእድ፥ ስእ ጊኮ እ ቆፋ ማእስ ጉሱ። ");
INSERT INTO gofe_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","ሽን እ ሄሳ ስእ ጋምእድ ዛር ድግያባ ግድኮ ሄሳስ ኦይሸተይ እያ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","ህዛ ሀይስ አዝና ግዶንነ ማች ግዶን፥ ባ አዋራ ሶን ደእያ ጌላኦ ግዶንነ እ አዋ ግዶን ደእያ ጋሄተꬃባ ጎዳይ ሙሰስ እምዳ ዎጋ። ");
INSERT INTO gofe_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","ጎዳይ ሙሰኮ፥ ");
INSERT INTO gofe_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“እስራኤለ አሳ ቆህዳ ግሾ ምድያመ አሳ ኦላዳ ሀሎ ከያ፤ ሄሳፈ ጉየ፥ ኔኒ ሀይቃዳ ነ ማይዛታ ጋካና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","ሄሳ ግሾ፥ ሙሰይ አሳኮ፥ “ምድያመ አሳ ኦልድ ጎዳ ሀሎ ከያና መላ ህንተ ግዶፈ ጉꬃ አሳ ኦላስ ዳንጭስተ። ");
INSERT INTO gofe_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","እስ እስ እስራኤለ ኮቻፈ እስ ሙኩሉ አደ አሳ ኦላስ የድተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","ሄሳ ግሾ፥ እስ እስ እስራኤለ ኮቻፈ እስ እስ ሙኩሉ አሳይ ከይድ፥ ታማነ ናምኡ ሙኩሉ ኦላንቾት ኦላስ ጊግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","ሙሰይ ካህንያ አላዛራ ናኣ ፕንሃሳ አዋተꬃን፥ እስ እስ ኮቻፈ እስ እስ ሙኩሉ አስ ዶርድ ኦላስ የድስ፤ ፕንሃስ ብሸ ጌሻ ሚሸታነ ማላስ ፑንያ ዛየ ኤክድ ብስ። ");
INSERT INTO gofe_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","ጎዳይ ሙሰ ኪትዳይሳዳ፥ ኤንቲ ምድያመ አሳ ኦልድ አደ ኡባ ዎꬍዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","እቻሹ ምድያመ ካዎታ፥ ኤዋ፥ ረቄማ፥ ዙራ፥ ሁራነ ሬባ ጌተትያ አሳታ ዎꬍዶሶና፤ ቃስ ብኦራ ናኣ ባላማካ ማሻን ዎꬍዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","እስራኤለ አሳይ ምድያመ ማጫሳነ ናይታ ድእዶሶና፤ ኤንታ መህያ፥ ዶርሳነ ዴሻ ዉድያነ ኤንታ ሚሸ ኡባ ድእዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","ኤንቲ ደእያ ካታማታነ ኤንታ ጉታታ ኡባ ፁግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","አሳ መህያነ ደእዳባ ኡባ ኤክድ ብዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","ኤንቲ ድእዳ አሳ፥ መህያነ ሻሎ ኡባ እያርኮፈ ሄፍንꬃን፥ ዮርዳኖሰ ሻፋ ማታን ደእያ ሞአበ ደንባን ዱንካንዳ ሙሰኮ፥ ካህንያ አላዛራኮነ እስራኤለ ማባራኮ ኤህዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","ሙሰይ፥ ካህነያ አላዛርነ ማባራ ሀላቃት ኡባይ ዱንካንዳ ጉታፐ ጋፃ ከይድ ኤንታና ሞክዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","ሙሰይ ኦላፐ ስምዳ ቾራ ሞጮናታ፥ ሻላቃታነ ማቶ ሀላቃታ ቦላ ሀንቀትስ። ");
INSERT INTO gofe_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","ሙሰይ ኤንታኮ፥ “ማጫሳ ኡባ አይስ ዎꬍቤከቲ? ");
INSERT INTO gofe_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","ኤንቲ ባላማ ዞርያ ስእድ፥ ፐኦራ ጌተትያ በሳን እስራኤለ አሳይ ጎዳ አግድ፥ ቦሻን ሀይቃናዳ ኦꬅዳይ ማጫሳ ግደይሳ ዶግደቲ? ");
INSERT INTO gofe_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","ሄሳ ግሾ፥ ሀእ አደ ናይታነ አደራ አቅዳ ማጫስ ኡባ ዎꬍተ። ");
INSERT INTO gofe_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","ሽን አደራ አቅቦና ማጫ ናይታ ኡባ ህንተዉ አሽተ። ");
INSERT INTO gofe_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","ህንተ ግዶፈ አሰ ዎꬍዳ አስ ዎይኮ አሀ ቦችዳ ኦንካ ጉታፐ ጋፃን ላፑን ጋላስ ኡቶ፤ ሄꬓንꬆ ጋላሳንነ ላፑንꬃ ጋላሳን ህንተናነ ህንተ ድእዳ አሳ ጌሽተ። ");
INSERT INTO gofe_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","ሄሳዳካ ማኦ ኡባ፥ ጋልባፈ፥ ዴሻ እክሰፐነ ምꬃፈ ኦሰትዳባታ ኡባ ጌሽተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","ካህነይ አላዛር ኦላፐ ስምዳ ኦላንቾታኮ፥ “ጎዳይ ሙሰስ እምዳ ህግያ ማራይ ሀይሳ፤ ");
INSERT INTO gofe_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","ዎርቃ፥ ብራ፥ ናሰ፥ ብራታ፥ ቆርቆሮ፥ እርሳሰ፥ ");
INSERT INTO gofe_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","ታማን ሜተቶናባት ኡባይ ታማን ጌያናዉ በሴስ። ሽን ታማን ሜተትያባት ጌሾ ሃꬃን ጌያናዉ በሴስ። ");
INSERT INTO gofe_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","ላፑንꬃ ጋላሳን ህንተ ማኡዋ ሜጭተ፤ ህንተና ጌሽተ። ሄሳፈ ጉየ፥ ጉታ ገልተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","ጎዳይ ሙሰኮ፥ ");
INSERT INTO gofe_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“ኔራ፥ ካህንያ አላዛራራነ እስራኤለ ማባራ ሀላቃት ድኤትዳ አሳነ መህያ ታይብተ። ");
INSERT INTO gofe_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","ኦላ ብዳይሳታስነ ቦናይሳታስ ናምኡ ከስድ ሻክተ። ");
INSERT INTO gofe_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","ኦላ ብዳይሳታ ግሹዋፐ አሰ ግድን ሚዝ ግድን ሀረ ግድን ዶርሰ ዎይኮ ዴሸ ግድን እቻሹ ፄታፐ እስኖ ጎዳስ እምተ። ");
INSERT INTO gofe_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","ኤንታ ግሹዋፐ ኤክዳ ጎዳ እሞታ ካህንያ አላዛራስ እምተ። ");
INSERT INTO gofe_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","ሀንኮ እስራኤለታ ጋክዳ ግሹዋፐ፥ አሰ ግድን ሚዝ ግድን ሀረ ግድን ዶርሰ ዎይኮ ዴሸ ግድን እሻታማፈ እስኖ ኤክድ ጎዳ ዱንካንያ አዋተꬃን አይስያ ሌወታስ እምተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","ሙሰይነ ካህነይ አላዛር ጎዳይ ኪትዳይሳዳ ኦꬅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","35","ኦላንቾት ባንታዉ ኤክን አትዳ ድኦይ 675,000 ዶርሳታ፥ 72,000 ሚዛታ፥ 61,000 ሀረታነ 32,000 ጌላኦ ማጫ ናይታ። ");
INSERT INTO gofe_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","ኦላ ብዳይሳታ ጋክዳ ግሾይ 337,500 ዶርሳታ፤ ");
INSERT INTO gofe_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","ኤንታፈ ጎዳስ እመትዳይ 675. ");
INSERT INTO gofe_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","ሚዛት 36,000፤ ኤንታፈ ጎዳስ እመትዳይ 72. ");
INSERT INTO gofe_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","ሀረት 30,500፤ ኤንታፈ ጎዳስ እመትዳይ 61. ");
INSERT INTO gofe_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","ማጫሳት 16,000፤ ኤንታፈ ጎዳስ እመትዳይ 32. ");
INSERT INTO gofe_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","ጎዳይ ሙሰ ኪትዳይሳዳ ጎዳ እሞታ ካህንያ አላዛራስ እሚስ። ");
INSERT INTO gofe_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","46","ኦላ ቦና እስራኤለ ማባራ ጋክዳ ግሾይ ኦላ ብዳ አሳ ግሹዋራ እስ ግና፤ እካ 337,500 ዶርሳታ፥ 36,000 ሚዛታ፥ 30,500 ሀረታነ 16,000 ጌላኦ ማጫ ናይታ። ");
INSERT INTO gofe_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","እስራኤለ ማባራ ጋክዳ ግሹዋፐ እሻታሙ አሳፐነ መህያፐ እሶ እሶ ከስድ ጎዳይ እያ ኪትዳይሳዳ ጌሻ ዱንካንያ አዋተꬃን አይስያ ሌወታስ እሚስ። ");
INSERT INTO gofe_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","ሄሳፈ ጉየ፥ ቶራ ሞጮናት፥ ሻላቃትነ ማቶ ሀላቃት ሙሰኮ ሺቅድ፥ ");
INSERT INTO gofe_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","“ኑኒ ነ አይለት ኑ አዋተꬃ ጋርሳን ደእያ ኦላንቾታ ታይብን እሶይካ ፓጭቤና። ");
INSERT INTO gofe_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","ጎዳይ ኑ ሸምፑዋ አሽዳ ግሾ፥ ኑ እሶይ እሶይ ኤክዳ ዎርቃ አሌቆታ፥ ሳጋዮታ፥ ቶሆ አልቦታ፥ ምግዶታ፥ ሀይꬃ ዎርቃታነ ቆ ዎርቃታ ጎዳስ እማናዉ ኤክድ ይዳ” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","ሙሰይነ ካህነይ አላዛር ዎርቃ አሌቆታ ኡባ ኤንታፈ ኤክዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","ሻላቃትነ ማቶ ሀላቃት ጎዳስ እምዳ ዎርቃይ ናምኡ ፄቱ ክሎ ግራመ ግድስ። ");
INSERT INTO gofe_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","ሀንኮ ኦላንቾት ኤህዳ ድኡዋ ባንታዉ ኤክዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","ሙሰይነ ካህነይ አላዛር ሻላቃታፐነ ማቶ ሀላቃታፐ ኤክዳ ዎርቃ ጎዳ ስንꬃን እስራኤለ አሳ ሀሳይስያባ ኦꬅድ ጌሻ ዱንካንያ ግዶ ኤህዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","ሮቤላነ ጋደ ኮቻስ ዳሮ መሄይ ደኤስ። ኤንቲ ያእዜራ ቢታይነ ጋላዳ ቢታይ መሄስ እንጀ ግደይሳ፥ ");
INSERT INTO gofe_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","በእድ ሙሰኮ፥ ካህንያ አላዛራኮነ እስራኤለ ማባራ ሀላቃታኮ ይድ ሀይሳዳ ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","4","“እስራኤለ አሳይ ላታና መላ ጎዳይ ማድዳ ቢታይ፥ አፃሮተይ፥ ድቦን፥ ያእዜር፥ ንምር፥ ሀሰቦን፥ ኤልያል፥ ሰባም፥ ናቦይነ ባኦን መሄስ እንጀ ቢታ፤ ኑስ ህንተ አይለታስ ዳሮ መሄይ ደኤስ። ");
INSERT INTO gofe_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","ኑኒ ህንተ ስንꬃን ሳባ ደምዳባ ግድኮ፥ ሄ ቢታ ኑስ ህንተ አይለታ ላታ ኦꬅድ እምተ፤ ኑና ዮርዳኖሰ ሻፋፐ ሄፍንꬅ ፕንꬆፍተ” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","ሙሰይ ጋደ ኮቻታኮነ ሮቤላ ኮቻታኮ፥ “ህንተ ባጋ ግድዳ እስራኤለ አሳይ ኦላስ ብያ ዎደ ህንተ ሀይሳን ኡታናዉ ኮዬቲ? ");
INSERT INTO gofe_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","ጎዳይ ኤንታዉ እምዳ ቢታ ኤንቲ ፕኖና መላ ህንተ አይስ ኤንታ ዎዛና ሹግሴቲ? ");
INSERT INTO gofe_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","ቃደሳ ባርነፈ ሀ ቢታ ዎቻና መላ ህንተ አዋታ ታ የድዳ ዎደ ኤንትካ ሀይሳዳ ኦꬅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","ኤንቲ ኤሽኮላ ዛንጋራ ጋካናዉ ብድ ሄ ቢታ በእ ስሚድ እስራኤለት ጎዳይ ኤንታዉ እምዳ ቢታ ገሎና መላ እስራኤለታ ዎዛና ሹግስዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","ጎዳይ ሄ ጋላስ ዳሮ ሀንቀትድ ሀይሳዳ ያግድ ጫቅስ፤ ");
INSERT INTO gofe_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‘ባንታ ኩመꬃ ዎዛናፐ ታና ካልቦና ግሾ፥ ግብፀ ቢታፈ ከይዳይሳታፐ ላይꬅ ላታማነ እያፐ ቦላ ግድዳ አደ አሳፐ እሶይካ አብራሃመስ፥ ይሳቃስነ ያይቆባስ እማና ጋዳ ጫቅዳ ቢታ ገለኮና። ");
INSERT INTO gofe_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","ባንታ ኩመꬃ ዎዛናፐ ካልዳ ግሾ፥ ቀነዛ ዮፎና ናኣ ካለባፐነ ናወ ናኣ እያሱፐ አትሽን፥ ሀር ኦንካ ገለና’ ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","ጎዳ ሀንቆይ እስራኤለ አሳ ቦላ ኤፅዳ ግሾ ጎዳ ስንꬃን ኢታ ኦꬅዳ ሄ የለተꬃ ኡባይ ꬋያና ጋካናዉ መላ ቢታን ኦይታሙ ላይꬅ ቶይላትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","ህንተኖ፥ ናጋራንቾታ ናይቶ ህንተ አዋታ በሳን ኤቅድ ጎዳይ እስራኤለ አሳ ቦላ ጉጅድ ሀንቀታና መላ ኦꬄታ። ");
INSERT INTO gofe_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","ህንተ ጎዳ ካሎና እፅኮ፥ እ ቃስካ ባ ደርያ መላ ቢታን አጋና። ኤንታና ጋክያ ꬋዩዋስ ህንተ ኦይሸታና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","ኤንቲ ሙሰኮ ሺቅድ፥ “ኑኒ ሀይሳን ኑ መህያስ ዳራ፥ ኑ ናይታስነ ኑ ማቸታስ ካታማ ኬፃናዉ ኮዮስ። ");
INSERT INTO gofe_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","ሽን እስራኤለ አሳይ ባንታ በሳ ኤካና ጋካናዉ ኑኒ ኦላ ሚሸ ዳንጭድ ኤንታ ስንꬃን ከይድ ኦለታናዉ ጊገትዳ። ሄ ዎደ ሄ ቢታን ደእያ አሳይ ኑ ናይታነ ኑ ማቸታ ቆሆና መላ ግምበትድ ኡትዳ ካታማታን ደኦና። ");
INSERT INTO gofe_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","እስራኤለ አሳ ኡባይ ባንታ ላታ ላታ ኤካና ጋካናዉ፥ ኑኒ ኑ ሶ ስሞኮ። ");
INSERT INTO gofe_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","ኑኒ ኑ ላታ ዮርዳኖሰ ሻፋፐ ሀፍንꬃን ዶሎሀ ባጋን ላትዳ ግሾ፥ ዮርዳኖሰፐ ሄፍንꬃን ዉሎሀ ባጋን ኤንታራ ላታ ኤኮኮ” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","ሙሰይ ኤንታኮ፥ “ህንተ ገይስ ቱማ ግድኮ ሀይሳን ጎዳ ስንꬃን ኦላ ባናዉ ዳንጨትተ። ");
INSERT INTO gofe_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","ጎዳይ ባ ሞርከታ ባ ስንꬃፈ ጎዳና ጋካናዉ ህንተ ኦላ ሚሽያ ዳንጭድ፥ ዮርዳኖሰ ሻፋ ጎዳ ስንꬃን ፕንኮ፥ ");
INSERT INTO gofe_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","ሄ ቢታ ጎዳይ ፆንዳፐ ጉየ ህንተ ስማናዉ ዳንዳኤታ። ሄ ዎደ ህንተ ጎዳስነ እስራኤለ አሳስ ኦለትድ ፖልደታ ጉሱ። ቃስ ሄ ቢታይ ጎዳ ስንꬃን ህንተዉ ላታ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","“ህንተ ሄሳ ኦꬆና እፅኮ ጎዳ ቦላ ናጋራ ኦꬄታ፤ ህዛ፥ ህንተ ናጋራ ግሾ ህንተና ሴር ጋካናይሳ ሎይꬅ ኤርተ። ");
INSERT INTO gofe_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","ህንተ ህንተዉ ካታማታ፥ ህንተ መህያስ ዳራ ኬፅተ፥ ሽን ህንተ ገልዳ ቃላ ፖልተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","ጋደ ኮቻይነ ሮቤላ፥ ኮቻይ ሙሰኮ፥ “ኑኒ ነ አይለት ነ ኪትዳይሳዳ ኦꬃና። ");
INSERT INTO gofe_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","ኑ ናይት፥ ኑ ማቸት፥ ኑ ዶርሳትነ ኑ መሄይ ሀይሳን ጋላዳ ካታማታን ደእሾና። ");
INSERT INTO gofe_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","ሽን ኑኒ ነ አይለት፥ ኦላንቾት ኡባይ፥ ኔኒ ኑ ጎዳይ ግዳይሳዳ ኦለታናዉ ጎዳ ስንꬃን ዮርዳኖሰ ሻፋ ፕናና” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","ሄሳ ግሾ፥ ሙሰይ ካህንያ አላዛራ፥ ናወ ናአ እያሱነ እስራኤለ ኮቻታ ሀላቃታ ኤንታባ ያግድ ኪትስ። ");
INSERT INTO gofe_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","“ጋደ ኮቻይነ ሮቤላ ኮቻይ ኡባይ ኦላ ሚሽያ ዳንጭድ፥ ጎዳ ስንꬃን ህንተራ ዮርዳኖሰ ሻፋ ፕንኮነ ህንተ ሄ ቢታ ፆንኮ፥ ሄሳፈ ጉየ፥ ጋላዳ ቢታ ህንተ ኤንታ ላትስተ። ");
INSERT INTO gofe_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","ሽን ኤንቲ ኦላ ሚሽያ ዳንጭድ፥ ህንተራ ፕንድ ኦላስ ቦና እፅኮ፥ ህንተዳ ኤንታዉ ካናነ ቢታን ላት እመቶ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","ያትን። ጋደ ኮቻይነ ሮቤላ ኮቻይ ዛሪድ፥ “ኑኒ ነ አይለት ጎዳይ ግዳይሳ ኦꬃና። ");
INSERT INTO gofe_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","ኑኒ ኦላ ሚሽያ ዳንጭድ፥ ጎዳ ስንꬃን ካናነ ቢታ ገላናዉ ፕናና፤ ሽን ኑኒ ላትያ ላታይ ዮርዳኖሰፐ ሀፍንꬃ ባጋ ግዶ” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","ሄሳ ግሾ፥ ሙሰይ ጋደ ኮቻስ፥ ሮቤላ ኮቻስነ ዮሰፋ ናኣ ምናሰ ኮቻፈ ባጋስ አሞረ ካዋ ስሆና ካዎተꬃነ ባሳነ ካዋ ኦገ ካዎተꬃ ኤንታ ዩሹዋን ደእያ ካታማታራ እሚስ። ");
INSERT INTO gofe_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","ጋደ ኮቻይ ድቦና፥ አፃሮታ፥ አሮኤራ ");
INSERT INTO gofe_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","አፅሮት-ሻፋና፥ ያእዜራ፥ ዮግባ፥ ");
INSERT INTO gofe_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","ቤት-ንምራነ ቤት-ሀራና ጌተትያ ግምበን ድረትዳ ካታማታ ዛሪድ ኬፅዶሶና፤ ባንታ መህያስ ዳራ ኬፅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","ሮቤላ፥ ኮቻይ ሀሰቦና፥ ኤልኣላ፥ ቅራታይማ፥ ");
INSERT INTO gofe_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","ናባ፥ ባኣል-ማኦናነ ሰባማ ጌተትያ ካታማታ ዛረꬅ ኬፅዶሶና፤ ሄ ካታማታ ሱንꬃ ላምዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","ምናሰ ናኣ ማክራ ኮቻት ጋላዳ ቢታ ኦል ኦይክድ ያን ደእያ አሞረታ ጎድዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","ሄሳ ግሾ፥ ምናሰ ናኣ ማክራ ኮቻስ ሙሰይ ጋላዳ ቢታ እምን ኤንቲ ያን ደእዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","ምናሰ ኮች ግድዳ ያእር ሄ ካታማታ ኦል ኦይክድ፥ “ያእራ ካታማታ” ያግድ ሱንꬅስ። ");
INSERT INTO gofe_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","ኖባ ቃናታ ካታማነ እያ ዩሹዋን ደእያ ጉታታ ኦላን ኦይክደ፥ ባ ሱንꬃን “ኖባ” ግድ ሱንꬅስ። ");
INSERT INTO gofe_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","ሙሰይነ አሮን ካለꬅን፥ እስራኤለ አሳይ፥ ባንታ ጩጋን ጩጋን ግብፀፈ ከይድ ሲራትዳ ጉታታ ኦድያ ታርከይ ሀይሳ። ");
INSERT INTO gofe_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","ጎዳይ ኪትዳይሳ መላ ሙሰይ ኤንቲ ሲራትዳ በሳታ ሱንꬃ ኡባ ካል ካል ፃፍስ። ");
INSERT INTO gofe_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","እስራኤለ አሳይ ኮይሮ አጌናን፥ ታማነ እቻሻንꬆ ጋላሳን፥ ፓስካ ቦንችያ ናምአንꬆ ጋላስ ደንድድ፥ ግብፀ አሳ ኡባይ በእሽን፥ ያዮና ራምሰፐ ከይዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","ሄ ዎደ ግብፀ አሳይ ጎዳ ጋዶን ሀይቅዳ ባንታ ባይራ ናይታ ሞጎሶና። ሄሳዳ ኦꬅድ፥ ጎዳይ ኤንታ ፆሳታ ቦላ ፕርዳ ኤህስ። ");
INSERT INTO gofe_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","እስራኤለ አሳይ ራምሰፐ ደንድድ ሱኮታ ጌተትያ በሳን ዱንካንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","ሱኮታፐ ደንድድ መላ ቢታ ጋፃን ደእያ ኤታማን ዱንካንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","ኤታማፐ ደንድድ ባአል-ፃፎናፐ ዶሎሀ ባጋን ደእያ ፕሀህሮታ ስሚድ ምግዶላ ማታን ዱንካንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","ፕሀህሮታፐ ደንድድ፥ ዞኦ አባ ፕንድ፥ ሱዛ መላ ቢታ ብዶሶና። ኤታማ መላ ቢታን ሄꬑ ጋላስ ሄመትድ ማራን ዱንካንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","ማራፐ ደንድድ ታማነ ናምኡ ፑልቶትነ ላፑን ታሙ ዛምባት ደእያ ኤልማን ዱንካንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","ኤልማፐ ደንድድ ዞኦ አባ ማታን ዱንካንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","ዞኦ አባ ማታፐ ደንድድ ሲና መላ ቢታን ዱንካንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","ሲና መላ ቢታፈ ደንድድ ራፋቃን ዱንካንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","ራፋቃፐ ደንድድ ኤሉሳን ዱንካንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","ኤሉሳፐ ደንድድ ሃꬅ ባይና በሳን ራፍድማን ዱንካንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","ራፍድማፐ ደንድድ ሲና መላ ቢታን ዱንካንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","ሲና መላ ቢታፈ ደንድድ ክብሮት ሀትአዋን ዱንካንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","ክብሮት ሀትአዋፐ ደንድድ ሀፀሮታን ዱንካንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","ሀፀሮታፐ ደንድድ እርትማን ዱንካንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","እርትማፐ ደንድድ እርሞን-ፓሬዛን ዱንካንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","እርሞን-ፓሬዛፐ ደንድድ ልብናን ዱንካንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","ልብናፐ ደንድድ እርሳን ዱንካንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","እርሳፐ ደንድድ ቃሄላታን ዱንካንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","ቃሄላታፐ ደንድድ ሸፋራ ዙማን ዱንካንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","ሸፋራ ዙማፐ ደንድድ ሀራዳን ዱንካንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","ሀራዳፐ ደንድድ ማቅሄሎታን ዱንካንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","ማቅሄሎታፐ ደንድድ ታሀታን ዱንካንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","ታሀታፐ ደንድድ ታራን ዱንካንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","ታራፐ ደንድድ ምትቃን ዱንካንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","ምትቃፐ ደንድድ ሀሽሞናን ዱንካንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","ሀሽሞናፐ ደንድድ ሞሰሮታን ዱንካንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","ሞሰሮታፐ ደንድድ በን-ያእቃናን ዱንካንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","በን-ያእቃናፐ ደንድድ ሆር-ሀግድጋዳን ዱንካንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","ሆር-ሀግድጋዳፐ ደንድድ ዮፅባታን ዱንካንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","ዮፅባታፐ ደንድድ አብሮናን ዱንካንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","አብሮናፐ ደንድድ ኤፅዮን-ጋብራን ዱንካንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","ኤፅዮን-ጋብራፐ ደንድድ ሲና መላ ቢታን ቃደሳን ዱንካንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","ቃደሳፐ ደንድድ ኤዶመ ቢታ ዛዋን ደእያ ሆራ ዙማን ዱንካንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","ካህነይ አሮን ጎዳ ኪታን ሆራ ዙማ ቦላ ከይድ፥ እስራኤለ አሳይ ግብፀ ቢታፈ ከይዳ ኦይታማንꬆ ላይꬃን፥ እቻሻንꬆ አጌናን፥ ኮይሮ ጋላሳን ያን ሀይቅስ። ");
INSERT INTO gofe_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","አሮን ሆራ ዙማ ቦላ ሀይቅያ ዎደ እያዉ ላይꬅ ፄታነ ላታማነ ሄꬓ። ");
INSERT INTO gofe_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","ነገበ መላ ቢታን ካናነን ደእያ አራዳ ካዎይ እስራኤለ አሳ ዩሳ ስእስ። ");
INSERT INTO gofe_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","እስራኤለ አሳይ ሆራ ዙማፐ ደንድድ ፃልሞናን ዱንካንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","ፃልሞናፐ ደንድድ ፑኖናን ዱንካንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","ፑኖናፐ ደንድድ ኦቦታን ዱንካንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","ኦቦታፐ ደንድድ ሞአበ ቢታ ዛዋን ደእያ አባሪማን ዱንካንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","አባሪማፐ ደንድድ ድቦን-ጋዳን ዱንካንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","ድቦን-ጋዳፐ ደንድድ አልሞን-ድብላታይማን ዱንካንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","አልሞን-ድብላታይማፐ ደንድድ ናቦ ዙማ ስንꬃን አባሪማ ዙማታ ቦላ ዱንካንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","አባሪማ ዙማታፐ ደንድድ እያርኮፈ ሄፍንꬃን፥ ዮርዳኖሰ ሻፋ ማታን ደእያ ሞአበ ደንባን ዱንካንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","ዮርዳኖሰ ሻፋ ማታን ደእያ ሞአበ ደንባን፥ ቤት-ያሽሞታፐነ አቤል-ሳፅማ ዛንጋራፐ ግዶን ዱንካንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","እያርኮፈ ሄፍንꬃን፥ ዮርዳኖሰ ሻፋ ማታን ደእያ ሞአበ ደምባን ጎዳይ ሙሰኮ፥ ");
INSERT INTO gofe_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“እስራኤለ አሳስ ያጋዳ ኦዳ፤ ዮርዳኖሰ ሻፋ ፕንድ፥ ካናነ ቢታ ህንተ ገልያ ዎደ ");
INSERT INTO gofe_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","ሄ ቢታን ደእያ አሳ ኡባ ህንተ ስንꬃፈ የደꬅተ። ሹቻፈ ማሰትድ ኦሰትዳ ምስለታነ ሼሽድ መꬍዳ ኤቃታ ꬋይስተ። ꬎቃ ጎይኖ በሳታ ኡባ ላልተ። ");
INSERT INTO gofe_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","ሄ ቢታ ታ ህንተዉ እምዳ ግሾ እያ ላትድ ያን ደእተ። ");
INSERT INTO gofe_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","ህንተ ኮቻን ኮቻን ሳማ ከስድ ቢታ ሻከትተ። ታይቦን ዳርያ ኮቻታስ ዳልጋ ላታ እምተ፤ ታይቦን ጉፅያ ኮቻታስ ጉꬃ ላታ እምተ። ሳማን ኤንታ ጋክዳ ቢታይ ኤንታባ ግዳና። ቢታ ህንተ ማይዛታ ኮቻን ኮቻን ሻክድ ኤክተ። ");
INSERT INTO gofe_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","ሽን ሄ ቢታን ደእያ አሳ ህንተ የደꬆና እፅኮ፥ ህንተ አሽዳይሳት ህንተ አይፍያስ ፕንጮ፥ ህንተ ምይያስ አጉንꬁ ግዳና፤ ህንተ ዳና ቢታን ኡባ ዎደ ኦላ ደንꬅድ ህንተና ዋይሳና። ");
INSERT INTO gofe_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","ህንተ ኤንታ የደꬆና እፅኮ፥ ታ ኤንታ ቦላ ኦꬃናዉ ሀልችዳባ ህንተ ቦላ ኦꬃና ጋዳ ኦዳ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","ጎዳይ ሙሰኮ፥ ");
INSERT INTO gofe_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“እስራኤለ አሳስ ሀይሳዳ ጋዳ ኦዳ፤ ህንተ ካናነ ገልያ ዎደ ታ ህንተዉ ላታ ኦꬃዳ እማና ቢታ ዛዋይ ሀይሳ። ");
INSERT INTO gofe_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","ዱገሀ ባጋ ዛዋይ ሲና መላ ቢታፈ ደንድድ ኤዶመ ዛዋ ካንꬄስ። ዶሎሀ ባጋራ ህንተ ዛዋይ ማፅነ አባፈ ዱገ ባጋራ ዶምድ፥ ");
INSERT INTO gofe_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","አቅራብማ አꬍያ በሳ ሻክድ ሲና ቢታ ባዙዋ ካንꬅድ ዱገሀ ባጋራ ቃደስ-ባርነ ጋኬስ። ያፐ ሀዳር-አዳራ ካንꬅድ አፅሞና ጋኬስ። ");
INSERT INTO gofe_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","አፅሞናፐ ደንድድ ግብፀ ሻፋ ጉየ ስሚድ መደትራነ አባ ጋኬስ። ");
INSERT INTO gofe_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","“ዉሎሀ ባጋ ዛዋይ መደትራነ አባ ጋፃ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","“ፑደሀ ባጋ ዛዋይ መደትራነ አባ ካልድ ሆራ ዙማ ጋካናዉ ቤስ። ");
INSERT INTO gofe_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","ሆራ ዙማፐ ሀማታ ገልያ በሳ ጋካናዉ ቤስ፤ ሄ ዛዋ ዉርሰꬃይ ፃዳዳ። ");
INSERT INTO gofe_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","ያፐ ደንድድ ዝፍሮና ጋክድ፥ ሀፃር-ኤናናን ኤቄስ፤ ፑደሀ ባጋ ዛዋይ ሀይሳ። ");
INSERT INTO gofe_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","“ዶሎሀ ባጋ ዛዋይ ሀፃር-ኤናናፐ ሳፋማ ማላ ጋኬስ። ");
INSERT INTO gofe_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","ሳፋማ ማላፈ ደንድድ አይናፐ ዶሎሀ ባጋራ እርብላ ዱገ ዎꬍድ ከነሬታ አባፈ ዶሎሀ ባጋራ ደእያ ዙማታ ጋኬስ። ");
INSERT INTO gofe_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","ሄሳፈ ህንተ ዛዋይ ዱገ ዮርዳኖሰ ሻፋ ዎꬍ ዛዋይድ ማፅነ አባ ጋኬስ። ህንተ ቢታ ዩሾ ዛዋት ሀይሳታ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","ሙሰይ እስራኤለ አሳ ሀይሳዳ ያግድ ኪትስ፤ “ኡዱፉን ባጋ ኮቻስ ህንተ ሳማ የግድ ሻካና ላታ ቢታይ ሀይሳ። ");
INSERT INTO gofe_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","ሮቤላ ኮቻይ፥ ጋደ ኮቻይነ ምናሰ ኮቻፈ ባጋይ፥ ");
INSERT INTO gofe_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","ባንታ ላታ እያርኮፈ ሄፍንꬃን፥ ዮርዳኖሰ ሻፋፐ ዶሎሀ ባጋን ኤክዶሶና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","ጎዳይ ሙሰኮ፥ ");
INSERT INTO gofe_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“ካህንያ አላዛራነ ናወ ናኣ እያሱይ ሄ ቢታ አሳስ ሻኮ። ");
INSERT INTO gofe_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","ቃስ ቢታ ሻካናዉ ማዳና መላ እስ እስ ኮቻፈ እስ እስ ሀላቃ ዶርተ። ");
INSERT INTO gofe_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","ኤንታ ሱንꬃይ ሀይሳፈ ካልድ ደኤይሳ። ይሁዳ ኮቻፈ ዮፎና ናኣ ካለባ፤ ");
INSERT INTO gofe_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","ስሞና ኮቻፈ አምሁዳ ናኣ ሳላምኤላ፤ ");
INSERT INTO gofe_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","ብንያመ ኮቻፈ ክስሎና ናኣ ኤልዳዳ፤ ");
INSERT INTO gofe_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","ዳነ ኮቻፈ ዮግላ ናኣ ቡቃ፤ ");
INSERT INTO gofe_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","ዮሰፋ ናኣ ምናሰ ኮቻፈ ሱፌዳ ናኣ ሀንኤላ፤ ");
INSERT INTO gofe_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","ዮሰፋ ናኣ ኤፍሬማ ኮቻፈ ሽፍፃና ናኣ፤ ቃሙኤላ፤ ");
INSERT INTO gofe_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","ዛብሎና ኮቻፈ ፋርናካ ናኣ ኤልሳፋና፤ ");
INSERT INTO gofe_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","ይሳኮራ ኮቻፈ ሆዛ ናኣ ፓልፅኤላ፤ ");
INSERT INTO gofe_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","አሴራ ኮቻፈ ሳሎማ ናኣ አሁዳ፤ ");
INSERT INTO gofe_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","ንፍታለመ ኮቻፈ አምሁዳ ናኣ ፓዳህኤላ፤ ");
INSERT INTO gofe_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","ካናነ ቢታ እስራኤለ አሳስ ላታ ኦꬅድ ሻክድ እማና መላ ጎዳይ ኪትዳ አሳት ሀይሳታ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","እያርኮፈ ሄፍንꬃን፥ ዮርዳኖሰ ሻፋ ማታን ደእያ ሞአበ ደንባን፥ ጎዳይ ሙሰኮ ሀይሳዳ ያግስ፤ ");
INSERT INTO gofe_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“እስራኤለት ባንታ ላታፐ ሌወት ዳና ካታማታነ ኤንታ ዩሹዋን ሄንꬃ ቢታ እማና መላ ኤንታዉ ኦዳ። ");
INSERT INTO gofe_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","ሄ ካታማት ኤንታዉ ዱሳ በሲ ግዶ፤ ሄንꬃ ቢታት ኤንታ ሚዛስ፥ ኤንታ ዶርሳስነ ኤንታ ሀራ መሄታስ ግዶ። ");
INSERT INTO gofe_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","ህንተ ኤንታዉ እምያ ሄንꬃ ቢታይ ኡባ ባጋራ ካታማ ግምበ ድርሳፈ እስ ሙኩሉ ዋꬋ ግዶ። ");
INSERT INTO gofe_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","ካታማ ግዶ ኦꬅድ ዶሎሀ ባጋራ ናምኡ ሙኩሉ ዋꬋ፥ ዱገሀ ባጋራ ናምኡ ሙኩሉ ዋꬋ፥ ዉሎሀ ባጋራ ናምኡ ሙኩሉ ዋꬋነ ፑደሀ ባጋራ ናምኡ ሙኩሉ ዋꬋ ዋꬍተ። ሌወት ሄ ሄራ ባንታ ካታማስ ሄንꬃ ቢታ ኦꬆ። ");
INSERT INTO gofe_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","“ሌወታስ ህንተ እምዳ ካታማት፥ አሰ ዎꬍዳ ኡራይ ባቃትድ አትያ ኡሱፑን ካታማታ፤ ሄሳታ ቦላ ጉጅድካ፥ ኦይታማነ ናምኡ ሀራ ካታማታ ኤንታዉ እምተ። ");
INSERT INTO gofe_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","ኦይታማነ ሆስፑን ካታማታ ኤንታ ሄንꬃ ቢታራ እስፈ ሌወታስ እምተ። ");
INSERT INTO gofe_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","እስራኤለ አሳ ላታፐ ኤንታ ላታ መላ ዳሮ ኮቻፈ ዳሮ ካታማ፥ ጉꬃ ኮቻፈ ጉꬃ ካታማ ኤክድ ሌወታስ እምተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","ጎዳይ ሙሰኮ፥ ");
INSERT INTO gofe_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“እስራኤለ አሳኮ ሀይሳዳ ያጋ፤ ዮርዳኖሰ ሻፋ ፕንድ፥ ካናነ ቢታ ህንተ ገልያ ዎደ፥ ");
INSERT INTO gofe_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","እስ አስ ቆፖና አሰ ዎꬍዳባ ግድኮ ሄ ኡራይ ባቃትድ አታና መላ ካታማታ ህንተዉ ዶርተ። ");
INSERT INTO gofe_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","ያን ሱꬁ ዛራናዉ ኮያ ሀይቅዳ ኡራ ዳቦታፐ እ አቴስ። ሸምፖ ዎꬍዳ ደርያ ስንꬃን ፕርዳስ ሺቆና ሀይቃናዉ በሰና። ");
INSERT INTO gofe_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","ሀ ህንተ እምያ ኡሱፑን ካታማት ህንተ ባቃትድ አትያ ካታማ ግዶ። ");
INSERT INTO gofe_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","ሄꬑ ካታማት ዮርዳኖሰ ሻፋፐ ዶሎሀ ባጋን ግዶ፤ ቃስ አትዳ ሄꬓት ካናነ ቢታን ግዶ። ");
INSERT INTO gofe_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","ሀ ኡሱፑን ካታማት ኤሮና አሰ ዎꬍዳ እስራኤለ አሳይ፥ በታንቾትነ ጉꬃ ዎደስ ህንተ ግዶን ደእያ አሳት ባቃትድ አትያ በሲ ግዶ። ");
INSERT INTO gofe_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","“እስ አስ ሀራ አስ ብራታ ሚሸን ሾጭድ ዎꬍኮ ሄ ኡራይ ሸምፖ ዎꬍስ፤ እ ሀይቆ። ");
INSERT INTO gofe_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","እስ አስ ዎꬋናዉ ዳንዳእያ ሹቻን ሀራ አስ ጫድድ ዎꬍኮ ሄ ኡራይ ሸምፖ ዎꬍስ፤ እ ሀይቆ። ");
INSERT INTO gofe_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","እስ አስ ዎꬋናዉ ዳንዳእያ ምꬃ ሚሸን ሀራ አስ ሾጭድ ዎꬍኮ ሄ ኡራይ ሸምፖ ዎꬍስ፤ እ ሀይቆ። ");
INSERT INTO gofe_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","ሱꬁ ዛርያ ማታ ዳቦይ ሄ ሸምፖ ዎꬍዳይሳ ደምኮ ዎꬎ። ");
INSERT INTO gofe_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","“እስ አስ ሀራ አስ ባ ዎዛናን ሞርክድ ሱግ የግኮ ዎይኮ ሀይቆ ግድ እያ ቦላ እስባ ሆልን ሄ ኡራይ ሀይቅኮ፥ ");
INSERT INTO gofe_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","ዎይኮ ሞርክድ ባ ኩሸ ጩጩምድ ደችን ሄ ኡራይ ሀይቅኮ፥ እ ሸምፖ ዎꬍስ፤ እ ሀይቆ። ሱꬁ ዛርያ ማታ ዳቦይ ሸምፖ ዎꬍዳይሳ ደምኮ ዎꬎ። ");
INSERT INTO gofe_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","“ሽን ሞርከተꬅ ባይናን፥ እስ አስ ሀራ አስ አኬኮና ሱግድ ዎይኮ ቆፖና እያ ቦላ እስባ ሆልኮ፥ ");
INSERT INTO gofe_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","ዎይኮ ዎꬋናዉ ዳንዳእያ ሹቹ እ በኦና እያ ቦላ ሆልን፥ ሄ ኡራይ ሀይቅኮ፥ ሄሳን ሞርከተꬅ ባይና ግሾነ እያ ቆሀናዉ ቆፕድ ደንዶና ግሾ፥ ");
INSERT INTO gofe_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","ዱላታይ እያ ግዶንነ እያ ሱꬃ ዛራናዉ ኮያ ኡራ ግዶን ፕርድያ ዎጋይ ካልድ ደእያ ዎጋꬆ ግዶ። ");
INSERT INTO gofe_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","ኤሮና ዎꬍዳይሳ ሱꬃ ዛራናዉ ኮየይሳ ኩሸፐ ሄ ኡራ ዱላታይ አሽድ፥ እ ባቃትድ አትያ ካታማ ዛሮ። ሄ ዎደ ደእያ ዛይተን ትየትዳ ካህነ ሀላቃይ ሀይቃና ጋካናዉ እ ያን ደኦ። ");
INSERT INTO gofe_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","“ሽን ኤሮና ዎꬍዳይስ ባቃትድ አትያ ካታማ ዛዋፐ በትኮ፥ ");
INSERT INTO gofe_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","ሀይቅዳ ኡራ ዳቦይ እያ ደምድ ዎꬍኮ፥ ሸምፖ ዎꬎን ኦይሸተና። ");
INSERT INTO gofe_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","ሄ ዎደ ደእያ ካህነ ሀላቃይ ሀይቃና ጋካናዉ ሄ ኤሮና ዎꬍዳ ኡራይ ባቃትድ አትያ ካታማን ኡቶ። ሽን ሄ ካህነ ሀላቃይ ሀይቅዳፐ ጉየ ኤሮና ዎꬍዳ ኡራይ ባ ሶ ስማናዉ ዳንዳኤስ። ");
INSERT INTO gofe_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","“ሀ ዎጋይነ ህገይ ህንተ ደእያ ቢታን ህንተዉነ ህንተ ዘረꬃስ ኤቅድ ደእያ ዎጋ ግዶ። ");
INSERT INTO gofe_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","“አሰ ዎꬍዳ ኦንካ እ ሸምፖ ዎꬍዳይሳ ናምኡ ዎይኮ ሄꬑ ማርክ ማርካትኮ ሀይቆ፥ ሽን እስ አሳ ማርካተꬃን ኦንካ ሀይቃናዉ በሰና። ");
INSERT INTO gofe_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","ቃስ ሸምፖ ዎꬍዳ አሳፐ አጫ ኤኮፍተ፤ እ ሀይቃናዉ በሴስ። ");
INSERT INTO gofe_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","ባቃትድ አትያ ካታማ በትዳ ኦደፈካ ካህነ ሀላቃይ ሀይቃናፐ ስን ባ ሶ ስማና መላ አጫ እያፐ ኤኮፍተ። ");
INSERT INTO gofe_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","ሱꬅ ቢታ ቱንስያ ግሾ ሱꬁ ጉሶፍተ። ሱꬁ ጉስዳ ኡራ ሱꬃፈ አትሽን፥ ሱꬅ ጉክዳ ቢታ ሀራ ኦገራ ቱናተꬃፈ ጌሽያ ዎግ ባዋ። ");
INSERT INTO gofe_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","ታኒ፥ ጎዳይ እስራኤለ አሳ ግዶን ደእያ ግሾ፥ ህንተ ደእያ ቢታ፥ ታኒ አቅያ ቢታ ቱንሶፕተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","ዮሰፋ ኮቻፈ፥ ምናሰ ናኣ ማክራ ናኣ ጋላዳ ኮቻ ሀላቃት ሙሰኮነ እስራኤለ ሀላቃታኮ ይድ ");
INSERT INTO gofe_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","“ኑ ጎዳዉ፥ እስራኤለ አሳስ ላታ ቢታ ሳማን ሻካዳ እማና መላ ጎዳይ ነና ኪትስ፤ ቃስ ኑ እሻ ሰሎጳዳ ላታ እያ ማጫ ናይታስ እማና መላ ነና ኪትስ። ");
INSERT INTO gofe_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","ኤንቲ ሀራ ኮቸ ግድዳ እስራኤለ አስ ገልኮ ኤንታ ላታይ ኑ አዋታ ላታፐ ኤከትድ ኤንታ ኤክያ ዘረꬃስ ጉዠቴስ። ሄሳ ግሾ፥ ኑስ ሳማን እመትዳ ላታይ ጉፄስ። ");
INSERT INTO gofe_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","እስራኤለ አሳስ እሻታማንꬆ ላይꬃ ቦንችያ ባለይ ጋክያ ዎደ ኤንታ ላታይ ኤንታ ኤክዳ አሳ ኮቻስ ጉዠቴስ፤ ሄሳ ግድኮ ኤንታ ላታይ ኑ አዋታ ኮቻ ላታፐ ኤከታና” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","ሄሳ ግሾ፥ ሙሰይ ጎዳፐ ኤክዳ ኪታ እስራኤለ አሳስ ሀይሳዳ ያግድ ኦድስ፤ “ዮሰፋ ኮቻይ ግዳይስ ልከ። ");
INSERT INTO gofe_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","ጎዳይ ሰሎጳዳ ማጫ ናይታባ ኪትዳይስ ሀይሳ፤ ኤንቲ ባንታዉ ዶስዳ አዝና ገላናዉ ዳንዳኦሶና፥ ሽን ኤንታ ኮቻፈ ግዳናዉ ኮሼስ። ");
INSERT INTO gofe_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","እስራኤለ አሳ ላታይ እስ ኮቻፈ ሀራ ኮቻስ አꬎፎ፤ እስራኤለ አሳይ ባንታ ኮቻ ላታ ቢታ ምንꬅድ ናጎ። ");
INSERT INTO gofe_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","እስራኤለ አሳ ግዶን ላታ ቢታ ኤክዳ ማጫስ ኦንካ ባ አዋ ኮቸ ግድዳ አዝና ገላናዉ ኮሼስ። ሄሳዳ ኦꬅኮ ኤንታ ኮቻ ላታይ ኤንታ ኩሸን ጋምኤስ። ");
INSERT INTO gofe_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","ያትኮ፥ ላታይ እስ ኮቻፈ ሀራ ኮቻኮ አና። እስ እስ ኮቻይ ባ ላታ ቢታ ኦይክዳ መላ ዳና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","ያትን፥ ሰሎጳዳ ማጫ ናይት ጎዳይ ሙሰ ኪትዳይሳዳ ኦꬅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","ሰሎጳዳ ማጫ ናይት፥ ማህሎ፥ ትርፆ፥ ሆግሎ፥ ምልኮነ ኖኦ ጌተተይሳት ባንታ አዋ እሻታ ናይታ ገልዶሶና። ");
INSERT INTO gofe_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","ኤንቲ ዮሰፋ ናኣ ምናሰ ናይታ ኮቻፈ አዝና ገልዶሶና፤ ኤንታ ላታይ ኤንታ አዋ ኮቻስ ግድስ። ");
INSERT INTO gofe_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","እያርኮፈ ሄፍንꬃን፥ ዮርዳኖሰ ሻፋ ማታን፥ ደእያ ሞአበ ደንባን ሙሰ ባጋራ፥ ጎዳይ እስራኤለ አሳስ ኪትዳ ህገትነ ዎጋት ሀይሳታ። ");
INSERT INTO gofe_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","ሀ ማፃፋን ፃፈትዳ ቃላ ኡባይ ዮርዳኖሰ ሻፋፐ ሄፍንꬃን ደእያ መላ ቢታን ኤንቲ ደእሽን፥ ሙሰይ እስራኤለ አሳስ ኦድዳ ቃላ። ሄ ዎደ ኤንቲ ሱፋፐ ስንꬃ ባጋራ ፓራና ካታማስ እስ ባጋራ፥ ቃስ ቶፌላ፥ ላባና፥ ሀፀሮታነ ድዛባ ካታማታ ግዶን ደእያ ዮርዳኖሰ ዛንጋራን ደኦሶና። ");
INSERT INTO gofe_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","ሳይረ ደርያ ባጋራ ኮሬባ ዙማፐ ብድ ቃደስ-ባርነ ጋካናዉ ቶሆን ታማነ እስ ጋላሳ ኦገ። ");
INSERT INTO gofe_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","ግብፀፈ ኤንቲ ከይዳ ኦይታማንꬆ ላይꬃን፥ ታማነ እስንꬆ አጌናን፥ ኮይሮ ጋላሳን፥ ጎዳይ ኤንታባ ሙሰ ኪትዳባ ኡባ እስራኤለ አሳስ ኦድስ። ");
INSERT INTO gofe_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","ሄስ ሀንዳይ ሀሰቦና ካታማን ካዎትድ አሞረታ ሃርያ ስሆናነ አስታሮታንነ ኤድራአን ካዎትድ ባሳነ ሃርያ ኦገ፥ ሙሰይ ፆንዳፐ ጉየና። ");
INSERT INTO gofe_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","አሳይ ዮርዳኖሰፐ ዶሎሀ ባጋራ፥ ሞአበን ደእሽን፥ ሙሰይ ሀ ህግያ ሀይሳዳ ያግድ ኤንታዉ ቆንጭሰꬅ ዶምስ። ");
INSERT INTO gofe_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","ኑኒ ኮሬባ ዙማ ቦላ ደእሽን፥ ጎዳይ፥ ኑ ፆሳይ ኑኮ ሀይሳዳ ያግስ። “ህንተ ሀ ደርያ ቦላ ዳሮ ጋምእደታ። ");
INSERT INTO gofe_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","ዱንካንያ ላልተ፤ ደንድድ ደረይ ዳርያ አሞረታ ቢታነ አራባን ደእያ ኤንታ ዩሹዋን ደእያ ቢታ ኡባ ቢተ። ሄስካ ዮርዳኖሰ ዛንጋራ፥ ገዘነ ጋꬋ ቢታ፥ ነገባነ መደትራነ አባ ጋፃ አꬍተ። ካናነ ቢታ ቢተ፤ ልባኖሰ ደረታ ካንꬅድ፥ ኤፍራፂሳ ሻፋ ጋካናዉ ቢተ። ");
INSERT INTO gofe_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","ሄኮ፥ ታኒ ህንተዉ ሀ ቢታ እማስ። ብድ ህንተ አዋታስ፥ አብራሃመስ፥ ይሳቃስ፥ ያይቆባስነ ኤንታ ሼሻስ እማናዉ ጎዳይ ጫቅዳ ቢታ ላትተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","ሙሰይ አሳኮ፥ “ሄ ዎደ ታኒ ህንተዉ ሀይሳዳ ያጋዳ ኦዳስ፤ ታኒ ታርካ ህንተና ቶካናዉ ዳንዳእከ። ");
INSERT INTO gofe_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","ጎዳይ፥ ህንተ ፆሳይ ህንተ ታይቡዋ ሳሎ ፆልንቶዳ ዳርስስ። ");
INSERT INTO gofe_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","ጎዳይ ህንተ አዋታ ፆሳይ፥ ህንተና ሀይሳፈ አꬅድ ሙኩሉ ቶሆ ጉጅድ ዳርሶነ እ ግዳይሳዳ ህንተና አንጆ። ");
INSERT INTO gofe_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","ሽን ህንተ መቱዋ፥ ህንተ ቶሁዋነ ህንተ ኦሻ ኡባ ታኒ ታርካ ዋታ ቶካናዉ ዳንዳአይና? ");
INSERT INTO gofe_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","ህንተ ኮቻታፐ ጭንጫ፥ አኬካንቾነ ቦንቸትዳ አሳታ ዶርተ፤ ታኒ ህንተ ቦላ ኤንታ ሀላቃ ኦꬃና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","ህንተ ዛሪድ፥ “ነ ቆፋይ ሎኦ” ያግደታ። ");
INSERT INTO gofe_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","ሄሳ ግሾ፥ ታኒ ህንተ ኮቻፈ ጭንጫነ ቦንቸትዳ አሳታ ኤካዳ፥ ሻላቃ፥ ማቶ ሀላቃ፥ ሀምሳላቃነ አስራላቃ፥ ህንተና አይሰይሳታ ኦꬃዳ ህንተ ቦላ ሹማስ። ");
INSERT INTO gofe_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","ታኒ ኤንታ፥ “ህንተ እሻታ ግዶን ደእያ ኦዳ ስእተ፤ ሄ ኦዳይ እስ እስራኤለ አሳፐነ እያ እሻፐ ግዶን ዎይኮ እስራኤለ አሳፐነ ሀራ ደረ አሳፐ ግዶን ደእያባ ግድኮካ፥ ኦዳ ስእድ ሱረ ፕርድተ። ");
INSERT INTO gofe_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","ፕርድ ፆሳባ ግድያ ግሾ፥ ህንተ ፕርዳን እስ ባጋ ማዶፍተ፤ ግታ ስኤይሳዳ ጉꬃ ስእተ፤ አሳ ሶምኦስ ያዮፍተ። ዳሮ ዴፆ ግድዳ ኦዳታ ታኮ ኤህተ፤ ሄሳ ታኒ ስአና።” ");
INSERT INTO gofe_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","ህንተ ኦꬃናባ ኡባ ታ ሄ ዎደ ህንተና ኪታና። ");
INSERT INTO gofe_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","ሄሳፈ ጉየ፥ “ኑኒ ኮሬባ ዙማፐ ደንድዳ፤ ጎዳይ ኑ ፆሳይ ኑና ኪትዳይሳዳ፥ ደረይ ዳርያ አሞረታ ቢታ ብያ ኦገን ደእያ ሄ ህንተ በእዳ ግታነ ያሽያ መላ ቢታ ካንꬅድ ቃደስ-ባርነ ጋክዳ። ");
INSERT INTO gofe_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","ጎዳይ ኑ ፆሳይ ኑና ላትስያ፥ ደረይ ዳርያ አሞረታ ቢታይ ሀይሳ። ");
INSERT INTO gofe_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","ጎዳይ ህንተ ፆሳይ ሀ ቢታ ህንተዉ እሚስ። ጎዳይ ህንተ አዋታ ፆሳይ ህንተዉ ኦድዳይሳዳ ከይድ፥ ሀ ቢታ ላትተ፤ ያዮፍተ፤ ኡፋይስ ቃንፆፍተ” ያጋስ። ");
INSERT INTO gofe_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","ህንተ ኡባይ ታኮ ይድ፥ “ሄ ቢታ ፆሞስድ፥ ኑ ባናዉ በሲያ ኦግያባነ ገላና ካታማታ ሀኖታ ነዉ ኤህያ አሳታ ኑፐ ስን የዶስ” ያግደታ። ");
INSERT INTO gofe_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","ሄ ቆፋይ ታዉ ሎኦ ዳንን፥ ህንተፈ ታማነ ናምኡ አሳ፥ ኮቻፈ ኮቻፈ እስ አስ ዶራስ። ");
INSERT INTO gofe_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","ኤንቲ ብድ፥ ሄ ደረይ ዳርያ ቢታ ካንꬅድ፥ ኤሽኮላ ዛንጋራ ጋካናዉ ደእያ ቢታ ዎችዶሶና። ");
INSERT INTO gofe_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","ሄ ቢታን ዶልያባፐ ጉꬃ አይፈ ባንታ ኩሸን ኦይክድ ኑኮ ይዶሶና። ቃስ፥ “ጎዳይ ኑ ፆሳይ ኑስ እምያ ቢታይ ሎኦ ቢታ” ግያ ዎረ ኤክድ ይዶሶና። ");
INSERT INTO gofe_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","ሽን ህንተ ጎዳ ህንተ ፆሳ ኪታ እፃስ ግድ ያ ቦና እፅደታ። ");
INSERT INTO gofe_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","ህንተ ዱንካንያ ግዶን እሶይ እሱዋራ ሀይሳዳ ያግድ ዙዙምደታ። “ጎዳይ ኑና እፅዳ ግሾ፥ ꬋይሳናዉ አሞረ ቢታ አሳታ ኩሸን አꬅድ እማናዉ ግብፀ ቢታፈ ከስስ። ");
INSERT INTO gofe_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","ያትን ያ አይስ ባኔ? ኑ እሻት፥ ‘ሄ ቢታን ደእያ አሳት ኑፐ ዳሮሶናነ አዱቆሶና። ካታማትካ ግታነ ሳሎ ጋካናዉ ግምበትዳይሳታ። ሄሳ ቦላ ቃስ አናቀ ጌተትያ ዳሮ አዱሳ አሳታ ያን በእዳ’ ያግድ፥ ኑ ዎዛና ትልእስዶሶና” ያግደታ። ");
INSERT INTO gofe_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","ያትን ታኒ፥ “ያዮፍተ ዎይኮ ዳጋሞፍተ። ");
INSERT INTO gofe_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","ህንተ ስንꬃራ ብያ ጎዳይ ህንተ ፆሳይ ካሰ ግብፀን ህንተ አይፍያ ስንꬃን ህንተዉ ኦꬅዳይሳዳ ሀእካ ህንተዉ እ ኦለታና። ");
INSERT INTO gofe_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","ቃስ ህንተ ሀ መላ ቢታ ጋካናዉ ይዳ ኦገ ኡባን አስ ባ ናአ ቶከይሳዳ ጎዳይ ህንተ ፆሳይ ህንተና ቶክዳይሳ በእደታ” ያጋስ። ");
INSERT INTO gofe_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","33","ሀ ኡባይ ሀንንካ፥ ህንተ ዱንካናና በሳነ ህንተ ባና ኦግያ በሳናዉ ቃማ ታማ ቱሳን፥ ጋላስ ሻራ ቱሳን ህንተና ካለꬅዳ ጎዳ ህንተ ፆሳ አማንበከታ። ");
INSERT INTO gofe_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","“ጎዳይ ህንተ ሃሳያ ስእድ ሀንቀትስ፤ ሀይሳዳ ያግድ ጫቅስ፤ ");
INSERT INTO gofe_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","ታኒ ህንተ ማይዛታስ እማና ጋዳ ጫቅዳ ሀ ሎኦ ቢታ፥ ሀ ኢታ የለተꬃፈ እሶይካ በኤና። ");
INSERT INTO gofe_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","ሀ ቢታ በአናይ ዮፎና ናኣ ካለባ ፃላላ። እ የꬍዳ ቢታ እያስነ እያ ኮቻስ እማና፤ እ ባ ኩመꬃ ዎዛናፐ ጎዳ ካልስ” ያግድ ጫቅስ። ");
INSERT INTO gofe_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","ህንተ ጋሶን ጎዳይ ታ ቦላካ ሀንቀትድ፥ ሀይሳዳ ያግስ፤ “ሀር አቶሽን፥ ነካ ሄ ቢታ ገላካ። ");
INSERT INTO gofe_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","ሽን ነና ማድያ ናወ ናአይ፥ እያሱይ ሄ ቢታ ገላና። እ እስራኤለ አሳ ሄ ቢታ ላትሳናዉ ደእያ ግሾ ኔኒ እያ ምንꬃ። ");
INSERT INTO gofe_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","ህንተ፥ ኑ ናይት ድኤታና ግዳ ጉꬃት፥ ኢታነ ኬሀ ሻክድ ኤሮና ህንተ ናይት ሄ ቢታ ገላና። ታኒ ሄ ቢታ ኤንታዉ እማና፤ ኤንትካ ላታና። ");
INSERT INTO gofe_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","ሽን ህንተ ጉየ ስሚድ፥ ዞኦ አባ ኤፍያ ኦግያ ኦይክድ፥ መላ ቢታ ቢተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","ህንተ ዛሪድ፥ “ኑኒ ጎዳ ቦላ ናጋራ ኦꬅዳ፤ ሀእ ኑኒ ጎዳይ ኑ ፆሳይ ኪተይሳዳ፥ ከይድ ኦለታና” ያግደታ። ህንተ ኡባይ ኦላ ሚሸ ዳንጭድ፥ ደረይ ዳርያ ቢታ ከይድ ኦለታናይሳ ላፋባ ኦꬅድ ቆፕደታ። ");
INSERT INTO gofe_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","ሽን ጎዳይ ታኮ፥ “ታኒ ኤንታራ ዶና ግሾ፥ ኤንቲ ከይድ ኦለቶና መላ ኦዳ። አካይ፥ ጊኮ፥ ኤንታ ሞርከት ኤንታ ፆናና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","ያግን፥ ታኒ ህንተዉ ኦዳስ፥ ሽን ህንተ ጎዳ ኪታ እፅደታፐ አትሽን፥ ታ ኦደይሳ ስእቤከታ፤ ያትድ ኦቶሮን ደረይ ዳርያ ቢታ ከይደታ። ");
INSERT INTO gofe_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","ሄ ደረይ ዳርያ ቢታን ደእያ አሞረት ህንተራ ኦላ ጋሄትድ፥ ህንተና ማꬅ ጎደይሳዳ ጎድድ፥ ሳይረ ቢታፈ ብድ ሆርማ ጋካናዉ ሾጭዶሶና። ");
INSERT INTO gofe_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","ህንተ ጉየ ስሚድ፥ ጎዳኮ ዬክደታ፤ ሽን ጎዳይ ህንተ ዬሁዋ ስእቤና ዎይኮ ሀይዝቤና። ");
INSERT INTO gofe_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","ሄሳ ግሾ፥ ህንተ ቃደሳን አዱሳ ዎደ ጋምእደታ። ");
INSERT INTO gofe_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","ሄሳፈ ጉየ፥ ጎዳይ ታና ኪትዳይሳዳ፥ ኑኒ ዞኦ አባ ኤፍያ ኦግያ ኦይክድ ጉየ ስሚድ መላ ቢታ መቶትሸ፥ ደረይ ዳርያ ሳይረ ቢታን ዳሮ ጋላሳ ቶይላትሸ ዩይዳ። ");
INSERT INTO gofe_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","ሄሳፈ ጉየ፥ ጎዳይ ታኮ ሀይሳዳ ያግስ። ");
INSERT INTO gofe_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","“ሀ ደረይ ዳርያ ቢታ አዱሳ ዎደ ዩይዳይስ ህንተዉ ግዳና፤ ፑደሀ ባጋ ስሚድ ቢተ። ");
INSERT INTO gofe_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","አሳ ኔኒ ያጋዳ ኪታ፤ ‘ሳይረን ደኤይ ኤሳዌ ናይታ ህንተ እሻታ ግድያ ግሾ ኤንታ ቢታራ ህንተ ካንꬄታ። ኤንቲ ህንተዉ ያያና፥ ሽን ህንተ ኬህ ናገትተ። ");
INSERT INTO gofe_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","ታኒ ኤንታ ቢታፈ ቶሆይ የꬍያ በሳ መላ ህንተዉ እሞና ግሾ ኤንታራ ኦለቶፍተ። ታኒ ደረይ ዳርያ ሳይረ ቢታ ላታ ኦꬃዳ ኤሳዌስ ኮይሮታዳ እማስ። ");
INSERT INTO gofe_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","ህንተ ምያ ካꬃነ ኡያ ሃꬃ ኤንታፈ ሚሸን ሻምተ’ ” ያጋዳ ኪታ። ");
INSERT INTO gofe_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","ጎዳይ ህንተ ፆሳይ ህንተ ኦꬅዳባ ኡባ አንጅስ፤ ህንተ ሀ ዎልቃማ መላ ቢታን ሄመትያ ዎደ ህንተና ናግስ። ኦይታሙ ላይꬃ ኡባን ጎዳይ ህንተ ፆሳይ ህንተራ ደእስ፤ ህንተዉ አይባካ ፓጭስቤና። ");
INSERT INTO gofe_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","ሄሳ ግሾ፥ “ኑኒ ኑ እሻታ ግድያ ኤሳዌ ናይት ደእያ ሳይረ ቢታራ ካንꬅድ ብዳ። ቃስ ኤላታነ ኤፅዮን-ጋብራ ካታማታፐ ደንድድ፥ ማፅነ አባኮ ጋꬅያ ኦግያ አግድ፥ ሞአበ መላ ቢታራ አꬍዳ። ");
INSERT INTO gofe_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","ጎዳይ ታኮ፥ ‘ታኒ ኤንታ ቢታፈ አይባካ ህንተዉ እሞና ግሾ፥ ሞአበ አሳራ ካጨቶፍተ ዎይኮ ኤንታ ኦሎፕተ። ኤራ ካታማ ታኒ ላታ ኦꬃዳ ሎፀ ኮቻስ ኮይሮ እማስ’ ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","(ሄ ቢታን ካሰ ምኖነ ዳሮ ግድዳ፥ ቃስ አናቀ ኮቻታዳ አዱሰ ግድዳ ኤምመታ ጌተትያ አሳት ደእዶሶና። ");
INSERT INTO gofe_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","ኤንቲ አናቀታዳ ራፋይመታ ጌተቶሶና። ሽን ሞአበ አሳይ ኤንታ ኤምመታ ግድ ፄጎሶና። ");
INSERT INTO gofe_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","ሆራ ቢታ አሳይ ካሰ ሳይረን ደእዶሶና፥ ሽን እስራኤለ አሳይ ላታና መላ ጎዳይ ኤንታዉ እምዳ ቢታን ኤንቲ ኦꬅዳይሳዳ ኤሳዋ ኮቻት ሆራታ ኤንታ ቢታፈ ሾድዶሶና። ቃስ ባንታ ስንꬃፈ ኤንታ ꬋይስድ ኤንታ በሳን ኡትዶሶና።) ");
INSERT INTO gofe_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","ጎዳይ ኑኮ፥ “ሀእ ደንድተ፥ ዛረአዳ ሻፋ ፕንተ” ያግን፥ ኑኒ ዛረዳ ሻፋ ፕንዳ። ");
INSERT INTO gofe_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","ኑኒ ቃደስ-ባርነፈ ደንድድ፥ ዛረዳ ሻፋ ፕናና ጋካናዉ ሀስታማነ ሆስፑን ላይꬅ አꬍስ። ሄ ዎደ ጎዳይ ኤንታዉ ጫቅዳይሳዳ ኦላስ ጋክዳ አደ ኡባይ ዉርስ። ");
INSERT INTO gofe_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","ዱንካንዳ ጉታፐ ኤንቲ ኩመꬅ ꬋያና ጋካናዉ፥ ጎዳ ኩሸይ ኤንታ ቦላ ዴፅስ። ");
INSERT INTO gofe_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","ኦላስ ጋክዳ አደ አሳ ኡባይ ኩመꬅ ꬋይዳፐነ አሳ ግዶፈ ሀይቅድ ዉርዳፐ ጉየ፥ ");
INSERT INTO gofe_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","ጎዳይ ታኮ፥ ");
INSERT INTO gofe_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","“ኤራ ኦግያራ ሀች ህንተ ሞአበ ቢታ ካንꬄታ። ");
INSERT INTO gofe_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","ህንተ አሞነ አሳ ቢታ ጋክያ ዎደ ኤንታ ቦቾፍተ ዎይኮ ኤንታራ ኦየቶፍተ። አሞነ አሳታ ቢታፈ አይብባካ ታኒ ህንተዉ ላታ ኦꬃዳ እምከ። ታኒ ሄ ቢታ ሎፀ ኮቻስ ላታ ኦꬃዳ ኮይሮ እማስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","ሄ ቢታይ ካሰ ያን ደእያ አሳይ ፄገትያ ሱንꬃ ራፋይመታ ቢታ ጌተትድ ፄገቴስ። ቃስ አሞነት ኤንታ ዛምዙመታ ግድ ፄጎሶና። ");
INSERT INTO gofe_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","ኤንቲ አናቀታዳ አዱሰ፥ ምኖነ ዳሮ ደረ፥ ሽን ጎዳይ ኤንታ ꬋይስን፥ አሞነት ኤንታ ቢታ ላትድ ኡትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","ጎዳይ ሳይረን ደእያ ኤሳዌ ኮቻስ ኦꬅዳይሳዳ፥ ኤንታ ቦላ ኦꬅስ። ሄስካ እ ሄ ቢታን ደእያ ሆራታ ꬋይስን፥ ኤሳዌ ኮቻይ ኤንታ ቢታ ላትድ ሀች ጋካናዉ ኡትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","ጋዛ ጋካናዉ ደእያ ሄራን ደእያ አዌት፥ ካፍቶረ ቢታፈ ይዳ ካፍቶረት ኤንታ ꬋይስድ ኤንታ ቢታን ኡትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","ቃስካ ጎዳይ ኑኮ፥ “ደንድተ፤ አርኖና ሻፋ ፕንተ። ሄኮ፥ አሞረ ቢታ አስ ግድዳ ሀሰቦና ካዋ ስሆናነ እያ ቢታ ታ ህንተ ኩሸን አꬃዳ እማስ፤ እያ ኦልድ እያ ቢታ ላትተ። ");
INSERT INTO gofe_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","ሀችፈ ዶምን ሳሎፐ ጋርሳን ደእያ አሳ ኡባይ ህንተዉ ያያና መላ ታኒ ኦꬃና። ኤንቲ ህንተባ ስእያ ዎደ ኡባን ያሻን ኮኮራና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","ሄሳፈ ጉየ፥ ቅደሞታ መላ ቢታፈ ሀሰቦና ካዋ ስሆናስ ኪታንቾታ ቦላ ሀይሳዳ ያጋዳ ሳሮ ቃላ ኪታስ። ");
INSERT INTO gofe_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","“ኑና ነ ቢታራ አꬃርክ፤ ኑኒ ዎጋ ኦግያ ፃላላ ኦይክድ ባና፤ እያፐ ኡሻች ዎይኮ ሀድርስ ጎኮ። ");
INSERT INTO gofe_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","ኑኒ ምያ ካꬃስነ ኡያ ሃꬃስ ሚሸ ቃንፃና። ኑ ኮየይ ነ ቢታራ ካንꬅ አꬃ ፃላላ። ");
INSERT INTO gofe_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","ሳይረን ደእያ ኤሳዌ ኮቻትነ፥ ኤራን ደእያ ሞአበ ኮቻት ኑና አꬅዳይሳዳ ጎዳይ ኑ ፆሳይ፥ ኑስ እምያ ቢታስ ዮርዳኖሰ ሻፋ ኑኒ ፕናና ጋካናዉ ያራ ኑና አꬃ” ያጋስ። ");
INSERT INTO gofe_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","ሽን ሀሰቦና ካዎይ ስሆነይ ኑና አꬆና እፅስ። ጎዳይ ህንተ ፆሳይ ሀእ ኦꬅዳይሳዳ እያ ህንተ ኩሸን አꬅድ እማናዉ ኮይዳ ግሾ እያ ዎዛና ሙምስስድ፥ ኦቶራንቾ ኦꬅስ። ");
INSERT INTO gofe_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","ሄሳፈ ጉየ ጎዳይ ታኮ፥ “ሄኮ፥ ስሆናነ እያ ቢታ ታ ነዉ አꬃዳ እሞ ዶማስ፤ ሀእ ፆናዳ እያ ቢታ ላታ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","ስሆነይ ባ ኦላንቾታ ኡባ ኤክድ ያሃፃ ጌተትያ በሳን ኑራ ኦለታናዉ ከይስ። ");
INSERT INTO gofe_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","ሽን ጎዳይ ኑ ፆሳይ ኑስ እያ አꬅድ እምን፥ እያ፥ እያ አደ ናይታነ እያ ኦላንቾታ ኡባ ኑኒ ዎꬍዳ። ");
INSERT INTO gofe_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","ሄ ዎደ ኑኒ እያ ካታማታ ኡባ ኦይክድ፥ እያን ደእያ አደ፥ ማጫነ ናአ ኡባ አሾና ꬋይስዳ። ");
INSERT INTO gofe_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","ኤንታ መህያነ ኑኒ ኦይክዳ ካታማታፐ ድእዳይሳ ፃላላ ኑስ ኤክዳ። ");
INSERT INTO gofe_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","አርኖና ዛንጋራ ጋፃን ደእያ አሮኤራፐነ ሄ ዛንጋራ ግዶን ደእያ ካታማፐ ብድ ጋላዳ ቢታ ጋካናዉ ኑራ ኤቀትዳ እስ ካታምካ ዴና። ጎዳይ ኑ ፆሳይ ኤንታ ኡባ ኑ ኩሸን አꬅድ እሚስ። ");
INSERT INTO gofe_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","ሽን ኑኒ አሞነ ቢታኮ፥ ያቦቃ ሻፋ ጋፃን ደእያ ቢታኮ፥ ገዘ ቢታን ደእያ ካታማታኮነ ጎዳይ ኑ ፆሳይ ኑኒ ቦና መላ ድግዳ በሳ ኡባ ሺቅቦኮ። ");
INSERT INTO gofe_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","ሄሳፈ ጉየ፥ ኑኒ ስሚድ ባሳነ ኤፍያ ኦግያራ ከይዳ። ባሳነ ካዎይ ኦገይ፥ ባ ኦላንቾታ ኡባራ ኤድራአ ጌተትያ በሳን ኑራ ኦለታናዉ ከይስ። ");
INSERT INTO gofe_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","ሽን ጎዳይ ታኮ፥ “እያዉ ያዮፋ፤ ታኒ እያ፥ እያ ኦላንቾታነ እያ ቢታ ኡባ ነ ኩሸን አꬃዳ እማስ። ሀሰቦናን ኡትድ ካዎትዳ አሞረታ ካዋ ስሆና ቦላ ኦꬅዳይሳዳ ኔኒ እያ ቦላ ኦꬃና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","ሄሳ ግሾ፥ ጎዳይ ኑ ፆሳይ ባሳነ ካዋ ኦገነ እያ አሳ ኡባ ኑ ኩሸን አꬅድ እሚስ፤ ኑኒ ኤንታፈ እሱዋካ አሾና ዉርስድ ዎꬍዳ። ");
INSERT INTO gofe_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","ሄ ዎደ ኑኒ እያ ካታማታ ኡባ ኦይክዳ፤ ኑኒ ኦይክቦና እስ ካታምካ ዴና፤ ሄስካ፥ ባሳነ ካዋ ኦገይ አርጎባ ቢታን አይስያ ኡሱፑን ታሙ ካታማታ ኡባ ኦይክዳ። ");
INSERT INTO gofe_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","ሀ ካታማት ኡባይ አዱሳ ግምበን ድረትዳይሳታነ ፐንገት ኮበትዳይሳታ። ግምበ ድርስ ባይና ዳሮ ጉታትካ ደኦሶና። ");
INSERT INTO gofe_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","ሀሰቦና ካዋ ስሆና ቦላ ኦꬅዳይሳዳ ኑኒ ኤንታ ኩመꬅ ꬋይስዳ። ኤንታ ካታማታን ደእያ አደ፥ ማጫነ ናአ አሾና ꬋይስዳ። ");
INSERT INTO gofe_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","ሽን መሄ ኡባነ ካታማታፐ ድእዳባ ኑስ ኤክዳ። ");
INSERT INTO gofe_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","ሄ ዎደ ኑኒ አርኖና ዛንጋራፐ ብድ አርሞና ዙማ ጋካናዉ ደእያ ቢታ፥ ዮርዳኖሰ ሻፋፐ ዶሎሀ ባጋራ ደእያ ናምኡ አሞረ ቢታታ ካዎታፐ ኤክዳ። ");
INSERT INTO gofe_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","(ስዶና ቢታ አሳይ አርሞና ዙማ፥ ስርዮና ግድ ፄግያ ዎደ፥ አሞረ ቢታ አሳይ ሳንራ ግድ ፄጎሶና።) ");
INSERT INTO gofe_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","ኑኒ ደምባ ቢታን ደእያ ካታማታ ኡባ፥ ጋላዳ ቢታ ኡባ፥ ባሳነ ቢታ ኡባነ ባሳነ ቢታን ኦገይ ሃርያ ሳላካነ ኤድራአ ካታማታ ጋካናዉ ደእያ በሳ ኦይክዳ። ");
INSERT INTO gofe_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","(ራፋይመታፐ አትዳይ ባሳነ ካዋ ኦገ ፃላላ። እያ አርሳይ ብራታ አርስ፤ ሄ አርሳይ ሀች ጋካናዉ ራባ ጌተትያ አሞነታ ካታማን ደኤስ፤ እያ አዱሳተꬃይ ሆስፑን ዋꬋ፤ ጎምፓይ ኦይዱ ዋꬋ።) ");
INSERT INTO gofe_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","ሄ ቢታ ኑኒ ላትዳፐ ጉየ፥ አርኖና ሻፋ ዶናን ደእያ አሮኤራ ካታማፐ ዶምድ ደእያ በሳነ ደረይ ዳርያ ጋላዳ ቢታፈ ባጋ ጉጃዳ እያ ካታማታራ ሮቤላስነ ጋደ ኮቻስ ታኒ እማስ። ");
INSERT INTO gofe_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","ጋላዳፐ አትዳይሳነ ኦገይ ሃርያ ባሳነ ቢታ ኡባ ምናሰ ኮቻ ባጋስ እማስ፤ ሄስካ፥ አርጎባ ካዎተꬃ። (ሄ ባሳነ ቢታይ ኡባይ ራፋይመታ ቢታ ጌተትድ ፄገቴስ። ");
INSERT INTO gofe_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","ምናሰ ኮቻፈ ያእር ኩመꬃ አርጎባ ቢታ ላትስ፤ ሄስካ ጌሹረታነ ማእካታ ቢታ ጋፃ ጋካናዉ ደእያ ባሳነ ቢታ። እ ሄ ካታማታ ባ ሱንꬃን ፄገታና መላ ኦꬅስ፤ ሄሳ ግሾ፥ ኤንቲ ሀች ጋካናዉ፥ ያእራ ካታማታ ጌተትድ ፄገቶሶና።) ");
INSERT INTO gofe_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","ጋላዳ ቢታ ምናሰ ኮቸ ግድዳ ማክራስ እማስ። ");
INSERT INTO gofe_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","ሮቤላነ ጋደ ኮቻስ ጋላዳፐ ብድ አርኖና ሻፋ ማታ ጋካናዉ ደእያ ቢታ እማስ። ዱገሀ ባጋራ አርኖና ሻፋፐ ባጋይ ኤንታ ዛዋ፤ ቃስ ፑደሀ ባጋራ አሞነታ ቢታስ ጋፃ ግድዳ ያቦቃ ሻፋይ ዛዋ። ");
INSERT INTO gofe_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","ዉሎሀ ባጋራ፥ ኤንታ ዛዋይ አራባን ደእያ ዮርዳኖሰ ሻፋ ጋኬስ፤ ሄስካ ጋልላ አባፈ ዶምድ ፕስጋ ዙማ ፃጶን ደእያ ማፅነ አባ (ሃይቆ አባ) ጋካናሳ። ");
INSERT INTO gofe_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","ሄ ዎደ ታኒ ህንተና ሀይሳዳ ያጋዳ ኪታስ። “ጎዳይ ህንተ ፆሳይ ሄ ቢታ ህንተ ላታና መላ ህንተዉ እሚስ። ህዛ ህንተዉ ደእያ ቶራንቾታ ኡባ ኦላ ሚሸ ዳንጭስድ፥ ህንተ እሻታ ግድዳ እስራኤለ አሳፐ ስን አꬅተ። ");
INSERT INTO gofe_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","ህንተዉ ዳሮ መሄይ ደኤይሳ ታኒ ኤራይስ፤ ሄሳ ግሾ፥ ህንተ ማቸት፥ ህንተ ናይትነ ህንተ መሄይ ታኒ ህንተዉ እምዳ ካታማታን ደእሾና። ");
INSERT INTO gofe_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","ጎዳይ ህንተና ሸምፕስዳይሳዳ ህንተ እሻታ ሸምፕሳና ጋካናዉነ ዮርዳኖሰ ሻፋፐ ሄፍንꬃን ጎዳይ፥ ህንተ ፆሳይ ኤንታዉ እምያ ቢታ ኤንቲ ኤካና ጋካናዉ ኤንታዉ ኦለትተ። ሄሳፈ ጉየ፥ ታኒ ህንተዉ እምዳ ቢታ ስመታ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","ታኒ ሄ ዎደ እያሱ ሀይሳዳ ያጋዳ ኪታስ። “ጎዳይ፥ ህንተ ፆሳይ ሀ ናምኡ ካዎታ ቦላ ኦꬅዳባ ኡባ ኔኒ ነ አይፈን በአዳሳ፤ ህንተ ኦይካናዉ ብያ ካዎተꬃታ ኡባ ቦላ ጎዳይ ሄሳዳ ኦꬃና። ");
INSERT INTO gofe_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","ህንተዉ ኦለተይ ጎዳ ህንተ ፆሳ ግድያ ግሾ፥ ኤንታዉ ያዮፍተ” ያጋስ። ");
INSERT INTO gofe_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","ሄ ዎደ ታኒ ሀይሳዳ ያጋዳ ጎዳ ምንꬃዳ ዎሳስ። ");
INSERT INTO gofe_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","“ኡባ ሃርያ ጎዳዉ፥ ነ ግታተꬃነ ነ ምኖ ኩሽያ ታና፥ ነ አይልያ በሳናዉ ዶማዳሳ። ነ ኦꬅያ ዎልቃማ ኦሶታ ኦꬃናዉ ዳንዳኤይ ሳሎን ግድን ሳአን ሀራ ፆሲ ደኢ? ");
INSERT INTO gofe_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","ጎዳዉ፥ ታኒ ባዳ ዮርዳኖሰ ሻፋፐ ሄፍንꬃን ደእያ ደረይ ዳርያ ሎኦ ቢታነ ልባኖሰ ደርያ በአና መላ ታና የዳርክ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","ሽን ጎዳይ ህንተ ጋሶን ታና ሀንቀትድ ስኦናን እፅስ። ጎዳይ ታኮ፥ “ህዛ ነዉ ግዳና፤ ሀ ኦዳ ናምአንꬆ ደንꬃዳ ሃሳዮፓ። ");
INSERT INTO gofe_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","ሄሳ አጋዳ ደንዳ፤ ፕስጋ ዙማ ቦላ ከያ፤ ያን ኤቃዳ ሄ ቢታ ዉሎሀ ባጋ፥ ፑደሀ ባጋ፥ ዱገሀ ባጋነ ዶሎሀ ባጋ ነ አይፍያ ꬎቁ ኦꬃዳ ፄላ። ኔኒ ሀ ዮርዳኖሰ ሻፋ ፖሎ ፕናካ። ");
INSERT INTO gofe_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","ሽን ኔኒ እያሱ ኪታ፤ እያ ዞራነ ምንꬃ። እ ሀ አሳ ካለꬅድ ፕንꬃናነ ሀ ኔኒ በእያ ቢታ ኤንታ ላትሳና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","ሄሳ ግሾ፥ ኑኒ ቤት-ፓኦራ ስንꬃን ደእያ ዛንጋራን ጋምእዳ። ");
INSERT INTO gofe_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","ሀእካ እስራኤለ አሳዉ፥ ህንተ ደኦን ዳና መላነ ጎዳይ፥ ህንተ ማይዛታ ፆሳይ፥ ህንተዉ እምያ ቢታ ህንተ ላታና መላ ታ ህንተና ታማርስያ ዎጋነ ህግያ ስእተነ ኦꬅተ። ");
INSERT INTO gofe_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","ታ ህንተና ኪትያ፥ ጎዳ ህንተ ፆሳ ኪታ ናግተፐ አትሽን፥ እያ ቦላ አይኮካ ጉጆፍተ፤ እያፐ አይኮካ ፓጭሶፕተ። ");
INSERT INTO gofe_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","ብኤል-ፋጎራ ዙማ ቦላ ጎዳይ ኦꬅዳባ ህንተ፥ ህንተ አይፈን በእደታ። ጎዳይ፥ ህንተ ፆሳይ ብኤል-ፋጎራ ኤቃ ጎይንዳይሳታ ኡባ ህንተ ግዶፈ ꬋይስስ። ");
INSERT INTO gofe_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","ሽን ህንተ ጎዳስ፥ ህንተ ፆሳስ አማነትዳ ግሾ፥ ሀች ጋካናዉ ኡባይካ ደኦን ደኤታ። ");
INSERT INTO gofe_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","ሄኮ፥ ህንተ ላታናዉ ገልያ ቢታን ኦꬃና መላ ጎዳይ፥ ታ ፆሳይ ታና ኪትዳ ዎጋነ ህግያ ታ ህንተና ታማርሳስ። ");
INSERT INTO gofe_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","ህንተ ኤንታ ናግተነ ኦꬅተ። ህንተ ሄሳ ኦꬅኮ፥ ህንተ አይ መላ ጭንጨኮ ሀራ አሳይ ህንተና በአና። ኤንቲ ሀ ዎጋባ ስእያ ዎደ፥ “ቱማካ ሀ ግታ ካዎተꬃይ ጭንጫነ አኬካንቾ ካዎተꬅ” ያጋና። ");
INSERT INTO gofe_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","ኑኒ እያ ፄግያ ዎደ ኡባን ጎዳይ፥ ኑ ፆሳይ ኑስ ማታ ግደይሳዳ ፆሲ ማታ ግድዳ ሀራ አይ ዎልቃማ ካዎተꬅ ደኢ? ");
INSERT INTO gofe_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","ታኒ ሀች ህንተ ስንꬃን ዎꬅያ ሀ ህገ ኡባ መላ ፅሎ ግድዳ ዎግነ ህገይ ደእያ ሀራ አይ ግታ ካዎተꬅ ደኢ? ");
INSERT INTO gofe_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","ህዛ ነ ደኦ ላይꬃ ኡባን ሀ ነ በእዳባ ኡባ ዶጎና መላነ ነ ዎዛናን ዎꬃና መላ ናገታ። ነ ናይታነ ነ ናይታ ናይታ ታማርሳ። ");
INSERT INTO gofe_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","ኮሬባ ዙማ ቦላ ጎዳ፥ ህንተ ፆሳ ስንꬃን ህንተ ኤቅዳ ዎደ ጎዳይ ታኮ፥ “ታ ቃላ ኤንቲ ስእድ፥ ባንታ ላይꬃ ኡባን ታዉ ያያና መላነ ባንታ ናይታ ሄሳ ታማርሳና መላ አሳ ታኮ ሺሻ” ግዳይሳ አኬክተ። ");
INSERT INTO gofe_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","ሄ ዎደ ህንተ ሺቅድ ዙማ ፃጶን ኤቅደታ፤ ሳሎ ጋካናዉ ታም ኤፅስ። ሄ ዙማ ፃጶይ ሳካና ꬉማንነ ሻራን ጎዘትስ። ");
INSERT INTO gofe_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","ጎዳይ ታማ ግዶን ግድድ ህንተዉ ኦድስ። ህንተ እያ ግርሳ ስእደታፐ አትሽን፥ እያ ማላ በእቤከታ። ");
INSERT INTO gofe_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","ህንተ ኦꬃና መላ እ ህንተና ኪትዳ ባ ጫቁዋ ህንተዉ ኦድስ፤ ሄስካ ታሙ ኪታታ። እ ኤንታ ናምኡ ሎቸ ሹቻታ ቦላ ፃፍስ። ");
INSERT INTO gofe_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","ህንተ ላታናዉ ብያ ቢታን ኦꬃና መላ ዎጋነ ህግያ ህንተና ታማርሳና መላ ጎዳይ ታና ሄ ዎደ ኪትስ። ");
INSERT INTO gofe_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","ጎዳይ ኮሬባ ዙማ ቦላ ታማ ግዶን ግድድ ህንተዉ ኦድዳ ጋላስ ህንተ እያ ማላ በእቦና ግሾ ሎይꬅ ናገትተ። ");
INSERT INTO gofe_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","አደ ዎይኮ ማጫ መꬎን ኦሰትዳባ ግድን፥ ");
INSERT INTO gofe_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","ሳአን ደእያ ዶአ ኡባ ሌምሶን ግድን፥ ሳሎራ ፓልያ ካፎ ኡባ ሌምሶን ግድን፥ ");
INSERT INTO gofe_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","ሳአ ቦላ ኡሎራ ጎሸትያ መተꬃ ሌምሶን ግድን፥ ሃꬃ ግዶን ደእያ ሞሎ ሌምሶን ግድን፥ ህንተ ቱኖና መላ ህንተዉ ፆሰ ኦꬅድ መꬎፍተ። ");
INSERT INTO gofe_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","ሳሎ ፑደ ፄልዳ፥ ጎዳይ ነ ፆሳይ ሳሎፐ ጋርሳን ደእያ ካዎተꬃታስ እምዳ አዋ፥ አጌና፥ ፆልንቶታነ ሳሎ መተꬃታ ኡባ በእዳ፥ ነ ኤንታዉ ጎይናዳ ባሎና መላ ናገታ። ");
INSERT INTO gofe_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","ሽን ጎዳይ ህንተና ሀች ህንተ ሀንዳይሳዳ ባዉ ዱማትዳ አሰ ኦꬃናዉ ብራታ ሴርስያ ጮጨ መላ ግድዳ ግብፀፈ ከስድ ኤህስ። ");
INSERT INTO gofe_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","ህንተ ጋሶን ጎዳይ ታና ሀንቀትድ፥ ዮርዳኖሰ ፕኖና መላነ ጎዳይ ህንተ ፆሳይ፥ ላታ ኦꬅድ ህንተዉ እምያ ሎኦ ቢታ ታኒ ገሎና መላ ጫቅስ። ");
INSERT INTO gofe_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","ሄሳ ግሾ፥ ታኒ ዮርዳኖሰ ሻፋ ፕኖና ሀ ቢታን ሀይቃና፥ ሽን ህንተ ፕንድ ሄ ሎኦ ቢታ ላቴታ። ");
INSERT INTO gofe_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","ህዛ ጎዳይ፥ ህንተ ፆሳይ ህንተራ ጫቅዳ ጫቁዋ ዶጎፕተ። ጎዳይ፥ ነ ፆሳይ ነና ኦꬆፋ ግዳ አይ መꬎን ኦሰትዳ ምስለ ነዉ ኤቃ ኦꬆና መላ ናገታ። ");
INSERT INTO gofe_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","ጎዳይ፥ ነ ፆሳይ ምያ ታማነ ቃናትያ ፆሲ። ");
INSERT INTO gofe_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","ነ ናይታነ፥ ናይታ ናይታ የላዳ ሄ ቢታን አዱሳ ዎደ ደእያ ዎደ አይ መꬎን ኦሰትዳ ምስለ ጎይናዳ ቱንኮ፥ ቃስ ጎዳ፥ ነ ፆሳ ሀንቀꬃናዉ እያ ስንꬃን ኢታባ ኦꬅኮ፥ ");
INSERT INTO gofe_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","ህንተ ዮርዳኖሰ ሻፋ ፕንድ ላታናዉ ብያ ቢታፈ እሶይካ አቶና ኤለ ꬋያናዉ ደኤይሳስ፥ ታ ሀች ህንተ ቦላ ሳሎነ ሳአ ማርካያይስ። ህንተ ፖሎ ꬋያናፐ አትሽን፥ ሄ ቢታን አዱሳ ዎደ ደኤከታ። ");
INSERT INTO gofe_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","ጎዳይ ህንተና ሀራ አሳ ግዶን ላላና፤ ህንተና እ ላልያ ካዎተꬃታ ግዶን ህንተ ታይቦይ ጉꬃ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","ያን ህንተ ምꬃፈነ ሹቻፈ አሳ ኩሸን ጊግዳ በኦና፥ ስኦና፥ ሞናነ ስንጎና ፆሳታ ጎይናና። ");
INSERT INTO gofe_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","ሽን ያን ደአሸ ነ ጎዳ፥ ነ ፆሳ ኮያና፤ ነ እያ ኩመꬃ ዎዛናፐነ ኩመꬃ ሸምፖፈ ኮይኮ ደማና። ");
INSERT INTO gofe_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","ሄ መቶ ኡባ ግዶን ነ ኡንኤታዳ ደእያ ዎደ ዉርሰꬃን ጎዳኮ፥ ነ ፆሳኮ ስማናነ እያ ቃላስ ኪተታና። ");
INSERT INTO gofe_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","ጎዳይ፥ ነ ፆሳይ ማሮተꬃን ኩምዳ ፆሰ ግድያ ግሾ፥ እ ነና አገና ዎይኮ ꬋይሰና፤ ነ ማይዛታስ ጫቅዳ ጫቁዋ ዶገና። ");
INSERT INTO gofe_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","ጎዳይ ቢታን አሰ መꬍዳ ጋላሳፐ ዶምድ፥ ህንተፈ ካሰ አꬍዳ ዎድያ አነ ፕልግተ፤ ሄሳ መላ ግታባይ ፖሎ ሀን ኤርያኮ ዎይኮ ስኤትድ ኤርያኮ ሳሉዋስ ሀ ጋፃፐ ያ ጋፃ ጋካናዉ አነ ኦይችተ። ");
INSERT INTO gofe_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","ታማ ላጮ ግዶን ጎዳይ ሃሳይን ስእድ፥ ህንተ ꬋዮና ደኦን ደኤይሳዳ ጎዳይ ኦድሽን ስእድ፥ ደኦን ደእዳ ሀራ አስ ደኢ? ");
INSERT INTO gofe_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","ዎይኮ ጎዳይ፥ ህንተ ፆሳይ ህንተ ፄልሽን፥ ግብፀ ቢታን ህንተዉ ኦꬅዳይሳዳ ፓጨን፥ ማላታን፥ ማላልስያባን፥ ኦላን፥ ዎልቃማ ኩሸንነ ምጨትዳ ቀሰን፥ ግታ ያሻን ሀራ ካዎተꬃ ግዶ ገልድ፥ እስ ካዎተꬃ ባዉ ኤካናዉ ቡተትዳ ሀራ ፆሲ ደኢ? ");
INSERT INTO gofe_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","ጎዳይ፥ ፆሰ ግደይሳ ህንተ ኤራና መላ ሄሳ እ ህንተና በስስ፤ እያፐ አትሽን፥ ሀራ ፆሲ ባዋ። ");
INSERT INTO gofe_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","እ ህንተና ታማርሳናዉ ኮይዳ ግሾ፥ ባ ግርሳ ሳሎፐ ስስስ። ቃስ ሀ ሳአን ባ ግታ ታማ ህንተና በስስ፤ ሄ ታማ ግዶፈ ህንተ እያ ቃላ ስእደታ። ");
INSERT INTO gofe_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","እ ሄሳ ኦꬅዳይ ህንተ አዋታ ሲቅድ፥ ኤንታፈ ጉየ የለትያ ኤንታ ሼሻታ ዶርዳ ግሾ፥ ህንተና ግብፀፈ ባ ግታ ዎልቃን ከስስ። ");
INSERT INTO gofe_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","ሀች ህንተ በኤይሳዳ፥ ህንተና ገልሳናዉነ ኤንታ ቢታ ህንተዉ ላታ ኦꬅድ እማናዉ፥ ህንተፈ ዳርያነ ዎልቃምያ ካዎተꬃታ ህንተ ስንꬃፈ የደꬅድ ከስስ። ");
INSERT INTO gofe_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","ህዛ፥ ቦላ ሳሎን ግድን፥ ጋርሳ ሳአን ግድን፥ ጎዳይ ፆሰ ግደይሳ ኤርተ፤ ህንተ ዎዛናን ዎꬅተ፤ ሀራ ፆሲ ባዋ። ");
INSERT INTO gofe_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","ሄሳ ግሾ፥ ህንተዉነ ህንተፈ ጉየ ህንተ ናይታስ ኡባባይ ሎኦ ግዳና መላ፥ ቃስ ጎዳይ ህንተ ፆሳይ ህንተዉ መርናዉ እምያ ቢታን ህንተ ላይꬃይ አዱቃና መላ፥ ታኒ ሀች ህንተና ኪትያ ዎጋነ ህግያ ናግተ። ");
INSERT INTO gofe_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","ሄሳፈ ጉየ፥ ሙሰይ ዮርዳኖሰ ሄፍንꬃን ዶሎሀ ባጋራ ሄꬑ ካታማታ ዱማይስ። ");
INSERT INTO gofe_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","ሄሳ እ ዱማይዳይ ካሰ ሞርከተꬅ ባይና ደእሽን፥ ኤሮና ደእሸ አሰ ዎꬍዳ አስ ያ ባቃታና መላሳ። ሄ ኡራይ ሄ ካታማታፐ እሱዋኡ ባቃትድ ባ ሸምፑዋ አሻናዉ ዳንዳኤስ። ");
INSERT INTO gofe_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","ሄሳ ግሾ፥ ሮቤላ ኮቻስ ጋꬋን ደረ ቦላ ደእያ ቦሶራ ካታማ፥ ጋደ ኮቻስ ጋላዳን ደእያ ራሞታነ ምናሰ ኮቻስ ባሳነን ደእያ ጎላና ካታማታ ዱማይስ። ");
INSERT INTO gofe_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","ሙሰይ እስራኤለ አሳስ እምዳ ጎዳ ህገይ ሀይሳ፤ ");
INSERT INTO gofe_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","ሙሰይ ሀ ዎጋ፥ አዋጁዋነ ህግያ ኤንቲ ግብፀፈ ከይዳ ዎደ እሚስ። ");
INSERT INTO gofe_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","ሄስ ኤንታዉ እመትዳይ ኤንቲ ቤት-ፓኦራ ካታማ ስንꬃን ደእያ ዮርዳኖሰፐ ዶሎሀ ባጋራ ደእያ ዛንጋራን ደእሽና። ሄ በሳይ ሙሰይነ እስራኤለ አሳይ ግብፀፈ ከይዳ ዎደ ኦልድ ፆንዳ፥ ሀሰቦናን ኡትድ አሞረ ሃርያ ካዋ ስሆና ቢታ። ");
INSERT INTO gofe_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","ሄ ዎደ ኤንቲ እያ ቢታነ ባሳነ ካዋ ኦገ ቢታ፥ ሄስካ ዮርዳኖሰፐ ዶሎሀ ባጋን ደእያ ናምኡ አሞረ ካዎታ ላትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","ሄ ቢታይ አርኖና ዛንጋራን አሮኤራ ካታማፐ ብድ፥ ስርዮና ደርያ ጋኬስ፤ ስርዮና ጌተትድ ፄገትያ ደረይ አርሞና ዙማ። ");
INSERT INTO gofe_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","ሄ ቢታይ ዮርዳኖሰፐ ዶሎሀ ባጋራ ደእያ አራባ ቢታ ኡባ ኤክድ ብድ፥ ፕስጋ ደርያ ፃጶን ደእያ ማፅነ አባ ጋኬስ። ");
INSERT INTO gofe_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","ሙሰይ እስራኤለ አሳ ኡባ እስፈ ፄግድ፥ ሀይሳዳ ያግስ፤ “ህንተኖ፥ እስራኤለ አሳዉ ታኒ ሀች ህንተዉ ኦድያ ዎጋነ ህግያ ስእተ፤ ኤንታ ታማርተ፤ ምንꬅድ ናግተ። ");
INSERT INTO gofe_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","ጎዳይ፥ ኑ ፆሳይ ኮሬባ ዙማ ቦላ ኑራ ጫቅስ። ");
INSERT INTO gofe_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","ጎዳይ ሄ ጫቁዋ ጫቅዳይ ኑ አዋታ ፃላላራ ግዶናሽን፥ ሀች ደኦን ደእያ ኑ ኡባራ ጫቅስ። ");
INSERT INTO gofe_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","ሄ ዙማ ቦላ ኤፅያ ታማ ግዶን ግድድ፥ ጎዳይ ሶምኦን ህንተራ ሃሳይስ። ");
INSERT INTO gofe_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","ታኒ ሄ ዎደ ጎዳይ ግያባ ህንተዉ ኦዳናዉ፥ ጎዳፐነ ህንተፈ ግዶን ኤቃስ። ህንተ ታማስ ያይድ ዙማ ቦላ ከይበከታ። ጎዳይ ሀይሳዳ ያግስ። ");
INSERT INTO gofe_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","“ግብፀ ቢታፈ፥ አይለተꬃ ኬꬃፈ ነና ዎዝዳይ ታኒ ጎዳ፥ ነ ፆሳ። ");
INSERT INTO gofe_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","“ታፐ አትሽን፥ ሀራ ፆሳት ነዉ ደኦፖ። ");
INSERT INTO gofe_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","“ቦላ ሳሎን ደእያባ ግድን፥ ጋርሳ ሳአን ደእያባ ግድን፥ ዎይኮ ሃꬃ ግዶን ደእያባ ግድን፥ አይ ምስለ ነዉ ኤቃ ኦꬆፋ። ");
INSERT INTO gofe_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","ነ እያዉ ሆኮፋ ዎይኮ እያዉ ጎይኖፋ። ታኒ ታና እፀይሳታ አዋታ ናጋራ ግሾ፥ ናይታ ሄꬓንꬆነ ኦይዳንꬆ የለታ ጋካናዉ ሴራይስ። ታኒ፥ ጎዳይ፥ ነ ፆሳይ ቃናትያ ፆሳ። ");
INSERT INTO gofe_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","ሽን ታኒ ታና ሲቀይሳታነ ታ ኪታ ናገይሳታ ሙኩሉ የለታ ጋካናዉ ታ መርና ሲቁዋ በሳይስ። ");
INSERT INTO gofe_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","“ጎዳ፥ ነ ፆሳ ሱንꬃ ጮ ፄጎፓ። ጎዳይ ባ ሱንꬃ ጮ ፄግያ ኡራ ሴሮና አገና። ");
INSERT INTO gofe_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","“ጎዳይ፥ ነ ፆሳይ ነና ኪትዳይሳዳ ሳምባታ ጋላሳ ጌሽ ኦꬃዳ ናጋ። ");
INSERT INTO gofe_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","ኔኒ ነ ኦሶ ኡባ ኡሱፑን ጋላሳን ኦꬃ። ");
INSERT INTO gofe_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","ሽን ላፑንꬃ ጋላሳይ ጎዳስ፥ ነ ፆሳስ ሳምባታ። ሄ ጋላስ አይ ኦሶካ ኦꬆፋ። ኔኒ ዎይኮ ነ አደ ናአይ ዎይኮ ነ ማጫ ናእያ ዎይኮ ነ ኦሳንቾይ ዎይኮ ነ ኦሳንችያ ዎይኮ ነ ቦራይ ዎይኮ ነ ሀረይ ዎይኮ ነ ሀራ መሄት ዎይኮ ነ ካታማን ደእያ በተ አስ ሄ ጋላስ አይ ኦሶካ ኦꬆፕተ። ኔኒ ሸምፐይሳዳ ነ አደ አይለይትነ ማጫ አይለት ሸምፖ። ");
INSERT INTO gofe_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","ኔኒ ግብፀ ቢታን አይለ ግዳዳ ደእዳይሳ ዶጎፓ። ጎዳይ፥ ነ ፆሳይ ባ ዎልቃማ ኩሽያንነ ባ ምጨትዳ ቀስያን ያፐ ነና ከስዳይሳ ዶጎፓ። ጎዳይ፥ ነ ፆሳይ ሳምባታ ጋላስ ኔኒ ናጋና መላ ኪትዳይ ሄሳ ግሾሳ። ");
INSERT INTO gofe_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","“ጎዳይ፥ ነ ፆሳይ ነዉ እምያ ቢታን ነ ላይꬃይ አዱቃና ማላነ ነዉ ሎአና መላ ጎዳይ፥ ነ ፆሳይ ነና ኪትዳይሳዳ ነ አዋነ ነ አይዉ ቦንቻ። ");
INSERT INTO gofe_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","“ዎꬎፓ። ");
INSERT INTO gofe_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","“ላሞፋ። ");
INSERT INTO gofe_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","“ካይሶቶፓ። ");
INSERT INTO gofe_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","“ዎርዶ ማርካቶፋ። ");
INSERT INTO gofe_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","“ሀራ አሳ ማቾ አሞቶፋ፤ እያ ኬꬃ፥ እያ ሾቃ፥ እያ አደ አይልያ ዎይኮ እያ ማጫ አይልዉ ዎይኮ እያ ቦራ ዎይኮ እያ ሀርያ ዎይኮ እያዉ ደእያባ አይባካ አሞቶፋ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","ዙማ ቦላ ታማ፥ ሻራነ ꬉማ ግዶፈ ጎዳይ ꬎቁ ግዳ ግርሳን ዱላታ ኡባስ ኦድዳ ቃላት ሀይሳታ። እ ኤንታ ቦላ አይባካ ጉጅቤና፤ ኤንታ ናምኡ ሎቸ ሹቻታ ቦላ ፃፍድ ታዉ እሚስ። ");
INSERT INTO gofe_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","ዙማይ ታማን ፁገትሽን፥ ꬉማ ግዶፈ ግርሳ ህንተ ስእዳ ዎደ ህንተ ኮቻ ሀላቃትነ ጭማት ታኮ ይድ፥ ");
INSERT INTO gofe_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","ሀይሳዳ ያግዶሶና፤ “ኑኒ ጎዳ፥ ኑ ፆሳ ግርሳ ታማ ግዶፈ ስእዳ ዎደ ጎዳይ፥ ኑ ፆሳይ ባ ቦንቹዋነ ባ ግታተꬃ ኑና በስስ። ፆሲ አሳራ ሃሳይን ስእድ አስ ደኦን ዳናዉ ዳንዳኤይሳ ሀች ኑኒ በእዳ። ");
INSERT INTO gofe_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","ሽን ሀ ዎልቃማ ታማይ ኑና ꬋይሳናዉ ዳንዳኤስ፤ ያትን፥ ኑኒ አይስ ሀይቃኔ? ጎዳ፥ ኑ ፆሳ ቃላ ኑኒ ናምአንꬆ ስእኮ ሀይቃና። ");
INSERT INTO gofe_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","አሾ ማእዳ አሳን ኑኒ ስእዳይሳዳ ታማ ግዶን ግድድ ኦድሽን፥ ደኦ ፆሳ ቃላ ስእድ ደኦን ደእዳ አስ ኦኔ? ");
INSERT INTO gofe_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","ሄሳ ግሾ፥ ኔኒ ሺቃዳ ጎዳይ፥ ኑ ፆሳይ ግያባ ኡባ ስአ፤ ጎዳይ፥ ኑ ፆሳይ ነዉ ኦድያባ ኑስ ኦዳ፤ ኑካ ስእድ ኪተታና” ያግደታ። ");
INSERT INTO gofe_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","ህንተ ታዉ ኦድሽን ጎዳይ፥ ህንተ ግያባ ስእድ፥ ታኮ ሀይሳዳ ያግስ፤ “ሀ አሳይ ነዉ ኦድያባ ኡባ ስአስ፤ ኤንቲ ግዳባ ኡባይ ልከ። ");
INSERT INTO gofe_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","ኤንታዉነ ኤንታ ናይታስ መርናዉ ኡባባይ እንጀታና መላ ታዉ ያያናዉነ ታ ኪታ ናጋናዉ ኤንታዉ ኡባ ዎደ ሄሳ መላ ዎዛን ደኤረነ። ");
INSERT INTO gofe_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","ሀእ ኔኒ ባዳ ኤንቲ ባንታ ዱንካንያ ስማና መላ ኦዳ። ");
INSERT INTO gofe_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","ሽን ኔኒ ሀይሳን ታ ማታን ጋምአ። ኤንቲ ላታና መላ ታኒ ኤንታዉ እምያ ቢታን ኤንቲ ኦꬃናባ ኔኒ ኤንታ ታማርሳና ታ ኪታ፥ ታ አዋጁዋነ ታ ህግያ ኡባ ታ ነዉ ኦዳና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","ህንተኖ፥ እስራኤለ አሳዉ፥ ጎዳይ፥ ህንተ ፆሳይ ህንተና ኪትዳባ ኡባ ኦꬃናዉ ናገትተ፤ እያፐ ኡሻች ዎይኮ ሀድርስ ጎፕተ። ");
INSERT INTO gofe_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","ህንተ ደኦን ዳና መላ፥ ኡባይ ህንተዉ እንጀታና መላነ ህንተ ላትያ ቢታን ህንተ ላይꬃይ አዱቃና መላ፥ ጎዳይ ህንተ ፆሳይ ህንተና ኪትዳ ኪታ ናግተ። ");
INSERT INTO gofe_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","ህንተ ላታናዉ ብያ ቢታን ህንተ ኦꬃና መላ ታ ህንተና ታማርሳና መላ ጎዳይ፥ ህንተ ፆሳይ ታና ኪትዳ ኪታይ፥ አዋጆይነ ህገይ ሀይሳ። ");
INSERT INTO gofe_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","ነ ላይꬃይ አዱቃና መላ ነ፥ ነ ናይትነ ነ ናይታ ናይት ጎዳ ነ ፆሳ ያይተ፤ ታ ሀች ነዉ እምያ ጎዳ አዋጅያነ ህግያ ነ ላይꬃ ኡባን ናጋ። ");
INSERT INTO gofe_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","ነኖ፥ እስራኤለ ስአ፤ ኡባባይ ነዉ እንጀታና መላነ ጎዳይ ነ አዋታ ፆሳይ፥ ነዉ ግዳይሳዳ ማꬅነ ኤስ ጎግያ ቢታን ነ ዳራና መላ ሀ ህገታ ስአ፤ ምንꬃዳ ናጋ። ");
INSERT INTO gofe_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","ነኖ፥ እስራኤለ ስአ፤ ጎዳይ ኑ ፆሳይ እስ ፆሲ። ");
INSERT INTO gofe_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","ነ ጎዳ፥ ነ ፆሳ ነ ኩመꬃ ዎዛናፐ፥ ነ ኩመꬃ ሸምፑዋፈነ ነ ኩመꬃ ዎልቃፈ ዶሳ። ");
INSERT INTO gofe_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","ሀች ታ ነና ኪትያ ሀ ኪታ ነ ዎዛናን ዎꬃ። ");
INSERT INTO gofe_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","ኤንታ ኔኒ ነ ናይታ ታማርሳ፤ ኔኒ ነ ሶን ኡትያ ዎደ፥ ኦገ ሄመትያ ዎደ፥ ዝንእያ ዎደነ ደንድያ ዎደ ኤንታባ ሃሳያ። ");
INSERT INTO gofe_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","ማላ ኦꬃዳ ነ ኩሸን ኤንታ ቃቻ፤ ቃስ ነ ሶምኦን ማላዳ ዎꬃ። ");
INSERT INTO gofe_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","ነ ፐንገ ዝዝገታ ቦላነ ነ ድርሳ ፐንግያ ቦላ ኤንታ ፃፋ። ");
INSERT INTO gofe_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","ጎዳይ፥ ነ ፆሳይ ነዉ እማና ግድ ነ አዋታስ አብራሃመስ፥ ይሳቃስነ ያይቆባስ ጫቅዳ፥ ነ ኬፃቦና ግታነ ሎኦ ካታማት ኩምዳ ቢታ ነዉ እማና። ");
INSERT INTO gofe_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","ኔኒ ሺሻቦና ዱረተꬃን ኩምዳ ኬꬃታ፥ ነ ቦካቦና ሃꬃ ኦላታ፥ ነ ቶካቦና ዎይነነ ሻማሆ ነዉ እምያ ዎደ፥ ኔኒ ማዳ ካልዳ ዎደ፥ ");
INSERT INTO gofe_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","ነና ግብፀ አይለተꬃ ቢታፈ ከስዳ፥ ጎዳ ዶጎና መላ ናገታ። ");
INSERT INTO gofe_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","ጎዳ፥ ነ ፆሳ ያያ፤ እያ ፃላላ ጎይና፤ እያ ሱንꬃን ጫቃ። ");
INSERT INTO gofe_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","ነ ዩሾን ደእያ አሳይ ጎይንያ ሀራ ፆሳታ ጎይኖፋ። ");
INSERT INTO gofe_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","ነ ግዶን ደእያ ጎዳይ፥ ነ ፆሳይ ቃናትያ ፆሱ። እያ ሀንቆይ ነ ቦላ ኤፃና፤ እ ነና ቢታ ቦላፈ ፕትድ ꬋይሳና። ");
INSERT INTO gofe_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","ማሳሀን ህንተ እያ ፓጭዳይሳዳ ጎዳ ህንተ ፆሳ ፓጮፕተ። ");
INSERT INTO gofe_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","ጎዳይ፥ ህንተ ፆሳይ ህንተና ኪትዳ እያ ኪታ፥ እያ ዎጋነ እያ አዋጁዋ ምንꬅድ ናግተ። ");
INSERT INTO gofe_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","ነዉ ኡባባይ እንጀታና መላ ጎዳ ስንꬃን ነ ሱረባነ ሎኦባ ኦꬃ። ሄሳ ኦꬅኮ፥ ነዉ እማናዉ ጎዳይ ነ አዋታስ ጫቅዳ፥ ሄ ሎኦ ቢታ ነ ላታና። ");
INSERT INTO gofe_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","ጎዳይ ግዳይሳዳ ኔኒ፥ ነ ሞርከታ ኡባ ነ ስንꬃፈ ጎዳና። ");
INSERT INTO gofe_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","ዎደፐ ነ ናይት፥ “ጎዳይ፥ ኑ ፆሳይ ህንተና ኪትዳ ሀ ዎጋ፥ አዋጅያነ ህግያ ብርሸꬃይ አይቤ?” ያግድ ህንተና ኦይችያ ዎደ፥ ");
INSERT INTO gofe_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","ነ ኤንታዉ ሀይሳዳ ያጋዳ ዛራና፤ “ኑኒ ግብፀ ቢታን ግብፀ ካዋ አይለታ፥ ሽን ጎዳይ ባ ምኖ ኩሽያን ኑና ግብፀፈ ከስስ። ");
INSERT INTO gofe_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","ጎዳይ ኑ ፄልሽን፥ ግብፀ ቢታ ቦላ፥ ግብፀ ካዋ ቦላነ እያ ሹማታ ኡባ ቦላ ግታነ ያሽያ ማላታታነ ማላልስያባታ ኦꬅስ። ");
INSERT INTO gofe_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","ሽን እ ኑ ማይዛስ እማና ግድ ጫቅዳ ቢታ ኑስ እማናዉ ኑና ግብፀፈ ከስስ። ");
INSERT INTO gofe_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","ያትድ ሀች ህንተ በኤይሳዳ ኑስ ኡባ ዎደ ሎኦ ግዳና መላነ ኑኒ ደኦን ዳና መላ፥ ጎዳይ፥ ሀ አዋጆታ ኡባ ኑን ናጋና መላነ ጎዳስ ኑ ፆሳስ ያያና መላ ኪትስ። ");
INSERT INTO gofe_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","እ ኑና ኪትዳይሳዳ፥ ጎዳ፥ ኑ ፆሳ ስንꬃን ሀ ኪታ ኡባ ምንꬅድ ናግኮ፥ ሄስ ኑስ ፅሎተꬅ ግዳና” ያግተ። ");
INSERT INTO gofe_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","ጎዳይ፥ ነ ፆሳይ ነ ላታናዉ ብያ ቢታ ነና ገልስያ ዎደነ ኔፐ ዎልቃማነ ምንያ ላፑን ካዎተꬃታ፥ ሄሳትካ ህተታ፥ ገርገሰታ፥ አሞረታ፥ ካናነታ፥ ፓርዘታ፥ ህወታነ ያቡሰታ ነ ስንꬃፈ ጎድያ ዎደ፥ ");
INSERT INTO gofe_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","ጎዳይ ነ ፆሳይ ነ ኩሸን አꬅድ እምን፥ ነ ኤንታ ፆንያ ዎደ፥ ኤንታ ኩመꬅ ꬋይሳ። ኤንታራ አይብባካ ጫቆፋ፤ ኤንታዉ ቃቶፋ። ");
INSERT INTO gofe_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","ኤንታራ ኤከቶፋ፤ ገለቶፋ። ነ ማጫ ናይታ ኤንታ አደ ናይታስ እሞፋ ዎይኮ ኤንታ ማጫ ናይታ ነ አደ ናይታስ ኤኮፋ። ");
INSERT INTO gofe_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","ኤንቲ ነ ናይታ ታና ካለይሳ አግድ ሀራ ኤቃታ ጎይናና መላ ኦꬃና። ሄ ዎደ ጎዳ ሀንቆይ ነ ቦላ ኤፃና፤ ነና ኤለስድ ꬋይሳና። ");
INSERT INTO gofe_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","ሄሳ ግሾ፥ ኤንታ ያርሾ በሳ ላልተ፤ ጎይንያ ሹቻ ኤቃታ መንረꬅተ። አሼራ ጌተትያ ኤቃ ምስልያ ትንቸረꬅተ፤ ኩሸን ኦሰትዳ ምስለታ ታማን ፁግተ። ");
INSERT INTO gofe_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","ኔኒ፥ ነ ጎዳ ፆሳስ ጌሻ ደረ። ጎዳይ፥ ነ ፆሳይ ነና ባዉ ዱማ አስ ኦꬅድ ቢታ ቦላ ደእያ አሳ ኡባፈ ነና ዶርስ። ");
INSERT INTO gofe_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","ጎዳይ ህንተና ዶስዳይነ ዶርዳይ ህንተ ሀራ አሳፐ ታይቦን ዳርዳ ግሾ ግደና። ህንተ ሀራ አሳ ኡባፈ ታይቦን ጉꬃ። ");
INSERT INTO gofe_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","ሽን ጎዳይ ህንተና ዶስዳ ግሾነ ህንተ ማይዛታስ ጫቅዳ ጫቁዋ ናግዳ ግሾ፥ እ ህንተና አይለተꬃ ቢታፈ፥ ግብፀ ካዋ ኩሸፐ፥ ባ ዎልቃማ ኩሽያን ከስስነ ዎዝስ። ");
INSERT INTO gofe_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","ሄሳ ግሾ፥ ጎዳይ፥ ህንተ ፆሳይ ፆሴ ግደይሳ ኤርተ። እ ባና ዶሰይሳታስነ ባ ኪታ ናገይሳታስ ሙኩሉ የለተꬅ ጋካናዉ፥ ባ ሲቁዋ ናግያ አማነትያ ፆሲ። ");
INSERT INTO gofe_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","ሽን እ ባና እፀይሳታ ሴራናዉነ ꬋይሳናዉ ጉየ ጌና። ");
INSERT INTO gofe_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","ሄሳ ግሾ፥ ታኒ ሀች ነዉ እምያ ኪታ፥ አዋጁዋነ ህግያ ናጋ። ");
INSERT INTO gofe_vpl VALUES ("DT7_12","006_7_12","DEU","7","12","12","ነ ሀ ኪታ ስአዳ ምንꬅ ናግኮ፥ ጎዳይ፥ ነ ፆሳይ ህንተ ማይዛታስ ጫቅዳይሳዳ ባ ሲቆ ጫቁዋ ነዉ ናጋና። ");
INSERT INTO gofe_vpl VALUES ("DT7_13","006_7_13","DEU","7","13","13","እ ነና ዶሳና፤ ነና አንጃና፤ ነ ታይቡዋ ዳርሳና። ቃስ እ ነዉ እማናዉ ነ ማይዛታስ ጫቅዳ ቢታን ነ ኡሎ አይፍያ፥ ቢታ አይፍያ፤ ካꬃ፥ ዎይንያ፥ ዛይትያ፥ መሄ ማራታነ ዶርሳ ማራታ ዳርስድ ነና አንጃና። ");
INSERT INTO gofe_vpl VALUES ("DT7_14","006_7_14","DEU","7","14","14","ነ ሀራ አሳፐ አꬋዳ አንጀትዳይሳ ግዳና። አደይ ዎይኮ ማጭ ዎይኮ ነ መሄይ ማይነና። ");
INSERT INTO gofe_vpl VALUES ("DT7_15","006_7_15","DEU","7","15","15","ጎዳይ ሀርገ ኡባፈ ነና ናጋና። ነኒ ግብፀ ቢታን ኤርያ ኢታ ሀርግያ ነ ቦላ ኤሄና፥ ሽን እ ነና እፅያ ኡባ ቦላ ሄ ሀርግያ ኤሀና። ");
INSERT INTO gofe_vpl VALUES ("DT7_16","006_7_16","DEU","7","16","16","ጎዳይ፥ ነ ፆሳይ ነዉ አꬅድ እምያ አሳ ኡባ ቃቶና ꬋይሳ። ሄስ ነዉ ፅሄ ግዳና ግሾ፥ ኤንታ ፆሳታ ጎይኖፋ። ");
INSERT INTO gofe_vpl VALUES ("DT7_17","006_7_17","DEU","7","17","17","ኔኒ፥ ነ ዎዛናን፥ “ሀ ካዎተꬃት ታፐ ምኖሶና፤ ያትን፥ ታ ኤንታ ዋታዳ ጎዳዳ ከሳኔ?” ጋናዉ ዳንዳኣሳ። ");
INSERT INTO gofe_vpl VALUES ("DT7_18","006_7_18","DEU","7","18","18","ሽን ኤንታዉ ያዮፋ። ጎዳይ፥ ነ ፆሳይ፥ ግብፀ ካዋ ቦላነ ግብፀ ቢታ ኡባ ቦላ ኦꬅዳይሳ አኬካ። ");
INSERT INTO gofe_vpl VALUES ("DT7_19","006_7_19","DEU","7","19","19","ጎዳይ፥ ነ ፆሳይ ነና ግብፀፈ ከስያ ዎደ ኦꬅዳ ግታ ጋዶታ፥ ማላታታ፥ ማላልስያባታ፥ እያ ዎልቃማ ኩሽያነ እያ ምጨትዳ ቀስያ ነ፥ ነ አይፈን በአዳሳ። ሀች ነ ያይያ አሳ ኡባ ቦላ ጎዳይ፥ ነ ፆሳይ ሄሳዳ ኦꬃና። ");
INSERT INTO gofe_vpl VALUES ("DT7_20","006_7_20","DEU","7","20","20","ቃስ ኔፐ ባቃትድ ቆሰትዳይሳት ꬋያና ጋካናዉ ጎዳይ፥ ነ ፆሳይ ኤንታ ግዶን ካዠ የዳና። ");
INSERT INTO gofe_vpl VALUES ("DT7_21","006_7_21","DEU","7","21","21","ሄሳ ግሾ፥ ነ ኤንታዉ ያዮፋ፤ ኔራ ደእያ ጎዳይ፥ ነ ፆሳይ፥ ግታነ ያሽያ ፆሲ። ");
INSERT INTO gofe_vpl VALUES ("DT7_22","006_7_22","DEU","7","22","22","ጎዳይ፥ ነ ፆሳይ ሄ ካዎተꬃታ ጉꬃራ ጉꬃራ ጎድድ፥ ነ ስንꬃፈ ꬋይሳና። ነ ኤንታ ኡባ እስ ቶሆ ꬋይሳካ፤ ሄሳ ነ ኦꬅኮ፥ ቢታን ደእያ ዶአት ዳርድ ነና ዋይሳና። ");
INSERT INTO gofe_vpl VALUES ("DT7_23","006_7_23","DEU","7","23","23","ሽን ጎዳይ፥ ነ ፆሳይ ኤንታ ነ ኩሸን አꬅድ እማና፤ ኤንቲ ꬋያና ጋካናዉ እ ኤንታ ዳጋንꬃና። ");
INSERT INTO gofe_vpl VALUES ("DT7_24","006_7_24","DEU","7","24","24","ኤንታ ካዎታ ነ ኩሸን አꬅድ እማና። ነ ኤንታ ሱንꬃ ሳሎፐ ጋርሳን ቁቻዳ ꬋይሳና። ኦንካ ኔራ ኤቀትድ ዳንዳኤና፤ ነ ኤንታ ꬋይሳና። ");
INSERT INTO gofe_vpl VALUES ("DT7_25","006_7_25","DEU","7","25","25","ኩሸን ኦሰትዳ ኤንታ ኤቃ ምስለታ ታማን ፁጋ። ሄ ምስለታ ቦላ ደእያ ብራ ዎይኮ ዎርቃ አሞቶፍተ፤ ነባ ኦꬃዳ ኤኮፋ። ሄስ ጎዳስ፥ ነ ፆሳስ ቱና ግድያ ግሾ፥ እያፐ ነ ኤክኮ ነዉ ፅሄ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("DT7_26","006_7_26","DEU","7","26","26","ኤንቲ ባንታ ሁጰን ቃንገትዳይሳታ ግድያ ግሾ፥ ነ ሄ ቱና ኤቃታ ነ ሶ ገልሳዳ፥ ኤንታ መላ ባደትዳይሳታ ግዶፓ። ኤንታ ኩመꬅ እፃ፤ ሻተታ። ");
INSERT INTO gofe_vpl VALUES ("DT8_1","006_8_1","DEU","8","1","1","ህንተ ደኦን ዳና መላ፥ ህንተ ታይቦይ ዳራና መላነ ጎዳይ ካሰ ህንተ ማይዛታስ እማና ግድ ጫቅዳ ቢታ ገልድ፥ ህንተ ላታና መላ ሀች ታ ህንተና ኪትያ ኪታ ኡባ ምንꬅድ ናግተ። ");
INSERT INTO gofe_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","ጎዳይ፥ ነ ፆሳይ ነዉ እምዳ ኪታ ነ ናግያኮነ ናጎናኮ፥ ነ ዎዛና ቆፋ ኤራናዉ ነና ፓጫናዉነ ነና አዳ ኦꬃናዉ ኦይታሙ ላይꬅ ኩመꬅ ነና መላ ቢታን ዋት ካለꬅዳኮ አኬካ። ");
INSERT INTO gofe_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","አዳተꬅ ኤርሳናዉ ነና ኮሻይስስ፤ ያትድ ነ ዎይኮ ነ ማይዛት ኤሮና ማና ነና ሙዝስ። ሄሳ እ ኦꬅዳይ አስ ጎዳ ዶናፐ ከይያ ቃላ ኡባናፐ አትሽን፥ ካꬃ ፃላላን ደኦናይሳ ነና ታማርሳናሳ። ");
INSERT INTO gofe_vpl VALUES ("DT8_4","006_8_4","DEU","8","4","4","ሀ ኦይታሙ ላይꬃታ ግዶን ነ ማእዳ ማኦይ ዉርቤና፤ ነ ቶሆይ ክፅቤና። ");
INSERT INTO gofe_vpl VALUES ("DT8_5","006_8_5","DEU","8","5","5","አስ ባ ናአ ሴረይሳዳ ጎዳይ፥ ነ ፆሳይ ነና ሴሮይሳ አኬካ። ");
INSERT INTO gofe_vpl VALUES ("DT8_6","006_8_6","DEU","8","6","6","እያዉ ያያሸነ እያ ቦንቻሸ ጎዳ ነ ፆሳ ኪታ ናጋ። ");
INSERT INTO gofe_vpl VALUES ("DT8_7","006_8_7","DEU","8","7","7","ጎዳይ ነ ፆሳይ ነና ዛንጋራፐነ ደርያፐ ጎግያ ሻፋትነ ፑልቶት ደእያ ሎኦ ቢታ ገልሳናዉ ኤህስ። ");
INSERT INTO gofe_vpl VALUES ("DT8_8","006_8_8","DEU","8","8","8","ሄ ቢታይ ግስተይነ ባንግ፥ ዎይነይነ ባላሰይ፥ ኦሮማነይ፥ ሻማሆ ዛይተይነ ኤስ ኩምዳ ቢታ። ");
INSERT INTO gofe_vpl VALUES ("DT8_9","006_8_9","DEU","8","9","9","ሄ ቢታይ አይኮይካ ፓጮና ህንተ ካልድ ምያ ቢታ። ሄ ቢታይ ብራት ሹቻዳ ገላ ግድዳ ቢታ። ዙማፐ ማዳበ ብራታ ቦክድ ኤክያ ቢታ። ");
INSERT INTO gofe_vpl VALUES ("DT8_10","006_8_10","DEU","8","10","10","ነ ማዳ ካልዳ ዎደ ነው እ እምዳ ሎኦ ቢታ ግሾ፥ ጎዳ ነ ፆሳ ጋላታ። ");
INSERT INTO gofe_vpl VALUES ("DT8_11","006_8_11","DEU","8","11","11","ታ ሀች ነና ኪትያ እያ ኪታ፥ እያ ህግያነ እያ አዋጁዋ ናጎና እፃዳ፥ ጎዳ ነ ፆሳ ዶጎና መላ ናገታ። ");
INSERT INTO gofe_vpl VALUES ("DT8_12","006_8_12","DEU","8","12","12","ነ ማዳ ካልያ ዎደ፥ ሎኦ ኬꬅ ኬፃዳ እያን ደእያ ዎደ፥ ");
INSERT INTO gofe_vpl VALUES ("DT8_13","006_8_13","DEU","8","13","13","ነ መሄይነ ዶርሳይ ዳርያ ዎደ፥ ነዉ ብርነ ዎርቅ ዳጋየትያ ዎደ፥ ነዉ ደእዳባይ ኡባይ ዳርያ ዎደ፥ ");
INSERT INTO gofe_vpl VALUES ("DT8_14","006_8_14","DEU","8","14","14","ሄ ዎደ፥ ነ ዎዛናይ ኦቶርቶና መላ፥ ግብፀ አይለተꬃ ኬꬃፈ ነና ዎዝዳ ጎዳ፥ ነ ፆሳ ዶጎና መላ ናገታ። ");
INSERT INTO gofe_vpl VALUES ("DT8_15","006_8_15","DEU","8","15","15","እ ነና ኢታ ሾሻይነ ኮርነይ ኩምዳ፥ ሃꬅ ባይና፥ ግታነ ያሽያ መላ ቢታራ ነና ካለꬅዳይሳ ዶጎፓ። እ ነዉ መላ ቢታን ዛላፈ ሃ ꬉስስ። ");
INSERT INTO gofe_vpl VALUES ("DT8_16","006_8_16","DEU","8","16","16","ነ ማይዛት ኤሮና ማና እ ነና መላ ቢታን ሙዝስ። ዉርሰꬃን ነዉ ኡባባይ እንጀታና መላ ነና አዳ ኦꬃናዉነ ፓጫናዉ ሄሳ ኦꬅስ። ");
INSERT INTO gofe_vpl VALUES ("DT8_17","006_8_17","DEU","8","17","17","ኔኒ፥ “ታ ዎልቃይነ ታ ኩሸ ምኖተꬃይ ሀ ዱረተꬃ ታዉ ኤህስ” ጎና መላ ናገታ። ");
INSERT INTO gofe_vpl VALUES ("DT8_18","006_8_18","DEU","8","18","18","ሽን ነ ዱረታና መላ ነዉ ዎልቃ እምዳይ ጎዳ፥ ነ ፆሳ ግደይሳ አኬካ። እ ሄሳ ኦꬅዳይ፥ ሀች ነ በኤይሳዳ፥ ነ ማይዛታራ ጫቅዳ ጫቁዋ ምንꬃናሳ። ");
INSERT INTO gofe_vpl VALUES ("DT8_19","006_8_19","DEU","8","19","19","ሽን ህንተ ጎዳ ህንተ ፆሳ አግድ፥ ሀራ ፆሳታ ካልኮ፥ ኤንታዉ ሆክኮነ ጎይንኮ፥ ህንተ ቱማ ꬋያናይሳ ታ ሀች ማርካታይስ። ");
INSERT INTO gofe_vpl VALUES ("DT8_20","006_8_20","DEU","8","20","20","ጎዳይ፥ ህንተ ፆሳይ ሀራ ካዎተꬃታ ህንተ ስንꬃፈ ꬋይስዳይሳዳ ህንተ እያዉ ኪተቶና እፅኮ ህንተናካ ꬋይሳና። ");
INSERT INTO gofe_vpl VALUES ("DT9_1","006_9_1","DEU","9","1","1","ነኖ፥ እስራኤለ ስአ፤ ኔፐ ግታትያነ ዎልቃምያ ካዎተꬃታ፥ ግምበይ ሳሎ ጋክዳ ግታ ካታማታ ላታናዉ ሀች ዮርዳኖሰ ፕናሳ። ");
INSERT INTO gofe_vpl VALUES ("DT9_2","006_9_2","DEU","9","2","2","ሄ ቢታን ደእያ አሳይ ምኖነ አዱሰ። ኔኒ፥ “ኦንካ ኤንታራ ኤቀታናዉ ዳንዳኦና አናቀ ኮቻታ” ግሽን ስአዳሳ። ");
INSERT INTO gofe_vpl VALUES ("DT9_3","006_9_3","DEU","9","3","3","ሽን ምያ ታማዳ ኔፐ ስንꬃራ በይ ጎዳ፥ ነ ፆሳ ግደይሳ ሀች ኤራ። እ ኤንታ ꬋይሳናነ ነ ስንꬃን ኤንታ ካዉሻና። ጎዳይ ነዉ ግዳይሳዳ ነ ኤንታ ጎዳዳ ከሳናነ ኤለሳዳ ꬋይሳና። ");
INSERT INTO gofe_vpl VALUES ("DT9_4","006_9_4","DEU","9","4","4","ጎዳይ፥ ነ ፆሳይ ኤንታ ነ ስንꬃፈ ጎድዳፐ ጉየ፥ ነ ዎዛናን፥ “ታኒ ፅሎ ግድያ ግሾ፥ ሀ ቢታ ታ ላታና መላ ጎዳይ ታና ኤህስ” ጎፓ። ጎዳይ ኤንታ ነ ስንꬃፈ የደꬅድ ከስዳይ ኤንቲ ኢታ ግድያ ግሾሳ። ");
INSERT INTO gofe_vpl VALUES ("DT9_5","006_9_5","DEU","9","5","5","ነ ኤንታ ቢታ ላታናዉ ይዳይ ነ ፅሎነ ሱረ ግድያ ግሾ ግደና። ሽን ጎዳይ፥ ነ ፆሳይ ኤንታ ነ ስንꬃፈ ጎድዳይ ሀ ካዎተꬃት ኢታ ግድያ ግሾነ በን ነ ማይዛታስ አብራሃመስ፥ ይሳቃስነ ያይቆባስ ጫቅዳ ጫቁዋ ናጋናሳ። ");
INSERT INTO gofe_vpl VALUES ("DT9_6","006_9_6","DEU","9","6","6","ህዛ ነ ሄሳ አኬካ። ጎዳይ፥ ነ ፆሳይ ሀ ሎኦ ቢታ ነና ላትሰይ ነ ፅሎተꬃ ግሾሳ ግደና፤ ነኒ ዎዛን ሙምዳ አስ። ");
INSERT INTO gofe_vpl VALUES ("DT9_7","006_9_7","DEU","9","7","7","ጎዳ፥ ህንተ ፆሳ መላ ቢታን ዋትድ ይሎይዳኮ ዶጎፕተ። ህንተ ግብፀ ቢታፈ ከይዳ ጋላሳፐ ዶምድ፥ ሀች ሀ በሳ ጋካናዉ ጎዳ ቦላ ማካልደታ። ");
INSERT INTO gofe_vpl VALUES ("DT9_8","006_9_8","DEU","9","8","8","ኮሬባ ዙማ ቦላ ጎዳይ ህንተና ꬋይሳናዉ ደንዳና ጋካናዉ ህንተ ጎዳ ይሎይደታ። ");
INSERT INTO gofe_vpl VALUES ("DT9_9","006_9_9","DEU","9","9","9","ጎዳይ ህንተራ ጫቅዳ ጫቆይ ፃፈትዳ ሎቸ ሹቻታ ኤካናዉ ታኒ ዙማ ቦላ ከይዳ ዎደ፥ ያን ካꬅ ሞናነ ሃ ኡዮና ኦይታሙ ጋላስነ ኦይታሙ ቃማ ጋምአስ። ");
INSERT INTO gofe_vpl VALUES ("DT9_10","006_9_10","DEU","9","10","10","ሄሳፈ ጉየ፥ ፆሳ ብራን ፃፈትዳ ናምኡ ሎቸ ሹቻታ ጎዳይ ታዉ እሚስ። ህንተ ዙማ ፃጶን ሺቅዳ ዎደ ታማ ግዶን ጎዳይ ህንተዉ እምዳ ኪታት ሄ ሎቸ ሹቻ ቦላ ፃፈትድ ኡትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("DT9_11","006_9_11","DEU","9","11","11","ኦይታሙ ጋላሳፐነ ቃማፈ ጉየ፥ ጎዳይ ባ ጫቆ ቃላይ ፃፈትዳ ናምኡ ሎቸ ሹቻታ ታዉ እሚስ። ");
INSERT INTO gofe_vpl VALUES ("DT9_12","006_9_12","DEU","9","12","12","ሄሳፈ ጉየ፥ ጎዳይ ታኮ፥ “ኤለሳዳ ሀይሳፈ ዱገ ዎꬋ፤ ኔኒ ግብፀፈ ከስዳ ነ አሳይ ቱንስ፤ ኤንቲ ታ ኪታ ኤሶን አግድ፥ ኩሸን ኦሰትዳ ኤቃ ጎይናናዉ ስምዶሶና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("DT9_13","006_9_13","DEU","9","13","13","ቃስካ ጎዳይ ታኮ፥ “ታኒ ሀ አሳ በአስ፤ ኤንቲ ቱማ ዎዛና ሙመ አስ። ");
INSERT INTO gofe_vpl VALUES ("DT9_14","006_9_14","DEU","9","14","14","ህዛ ታ ኤንታ ꬋይሶና መላነ ኤንታ ሱንꬃ ቢታ ቦላፈ ቁቾና መላ ታና ድጎፋ። ታ ነና ኤንታፈ ምኖነ ዳርያ ካዎተꬅ ከሳና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("DT9_15","006_9_15","DEU","9","15","15","ታኒ ጫቆ ቃላይ ፃፈትዳ ናምኡ ሎቸ ሹቻታ ታ ኩሸን ኦይካዳ ዙማ ቦላፈ ዎꬋስ፤ ሄ ዎደ ታማ ላጮይ ዙማ ቦላ በንቴስ። ");
INSERT INTO gofe_vpl VALUES ("DT9_16","006_9_16","DEU","9","16","16","ሄ ዎደ ጎዳ፥ ህንተ ፆሳ ቦላ ህንተ ናጋራ ኦꬅዳይሳ በአስ። ህንተ ማራ ምስለን ኦሰትዳ ዎርቃ ኤቃ ጊግስደታ። ጎዳይ፥ ህንተና ኪትዳ ኦግያፐ ኤሶን ሀራ ሶ ስምደታ። ");
INSERT INTO gofe_vpl VALUES ("DT9_17","006_9_17","DEU","9","17","17","ታኒ ታ ኩሸን ኦይክዳ ናምኡ ሎቸ ሹቻታ ሆላዳ ህንተ በእሽን መንꬃስ። ");
INSERT INTO gofe_vpl VALUES ("DT9_18","006_9_18","DEU","9","18","18","ሄሳፈ ጉየ፥ ጎዳ ይሎያናዉ ህንተ እያ ስንꬃን ኢታ ኦሶ ኦꬅድ፥ ናጋራ ኦꬅዳ ግሾ፥ ካሰይሳዳ ኦይታሙ ጋላስነ ኦይታሙ ቃማ ጎዳ ስንꬃን ጉፋናዳ ጋምአስ፤ ሄ ዎደ ታ ካꬅ ማብከ፤ ሃ ኡያብከ። ");
INSERT INTO gofe_vpl VALUES ("DT9_19","006_9_19","DEU","9","19","19","ጎዳይ ህንተ ቦላ ይሎትድ ꬋይሳናዉ ደንድዳ ግሾ ታኒ ያያስ። ሽን ጎዳይ ዛሪድ ታና ስእስ። ");
INSERT INTO gofe_vpl VALUES ("DT9_20","006_9_20","DEU","9","20","20","ቃስ ጎዳይ ይሎትድ አሮናካ ꬋይሳናዉ ኮይስ፤ ሽን ታኒ ሄ ዎደ አሮናስ ዎሳስ። ");
INSERT INTO gofe_vpl VALUES ("DT9_21","006_9_21","DEU","9","21","21","ታኒ ህንተ ናጋራን ኩምዳ ሄ ማራ ምስልያ ኤካዳ፥ ታማን ፁጋስ። እያ ትንቸረꬃ ጋጫዳ ꬊለ ከሳስ፤ ሄ ꬊልያ ዙማፐ ጎግያ ሃꬃራ የዳስ። ");
INSERT INTO gofe_vpl VALUES ("DT9_22","006_9_22","DEU","9","22","22","ቃስ ህንተ ታበራን፥ ማሳሀንነ ቅብሮት-ሀታዋን ጎዳ ይሎይደታ። ");
INSERT INTO gofe_vpl VALUES ("DT9_23","006_9_23","DEU","9","23","23","ጎዳይ ህንተኮ፥ “ብድ፥ ታኒ ህንተዉ እምዳ ቢታ ላትተ” ያግድ፥ ቃደስ-ባርነፈ የድዳ ዎደካ ህንተ ጎዳ፥ ህንተ ፆሳ ኪታ እፅድ ማካልደታ። እያዉ አማነትበከታ ዎይኮ እያ ቃላስ ኪተትበከታ። ");
INSERT INTO gofe_vpl VALUES ("DT9_24","006_9_24","DEU","9","24","24","ታኒ ህንተና ኤርዳ ዎድያፐ ዶምድ፥ ህንተ ጎዳስ ማካልደታ። ");
INSERT INTO gofe_vpl VALUES ("DT9_25","006_9_25","DEU","9","25","25","ጎዳይ ህንተና ꬋይሳና ግዳ ግሾ፥ ታኒ ኦይታሙ ጋላስነ ኦይታሙ ቃማ ጎዳ ስንꬃን ጉፋናዳ ጋምአስ። ");
INSERT INTO gofe_vpl VALUES ("DT9_26","006_9_26","DEU","9","26","26","ታኒ ጎዳ ፆሳኮ ሀይሳዳ ያጋዳ ዎሳስ፤ “አቤት ኡባ ሃርያ ጎዳዉ፥ ኔኒ ነ ግታ ዎልቃን ዎዝዳነ ነ ምኖ ኩሸን ግብፀፈ ከስዳ፥ ነ ላታ ግድዳ ነ አሳ ꬋይሶፋ። ");
INSERT INTO gofe_vpl VALUES ("DT9_27","006_9_27","DEU","9","27","27","ነ አይለታ፥ አብራሃመ፥ ይሳቃነ ያይቆባ ቆፓ፤ ኤንታ ዎዛና ምኖተꬃ፥ ኤንታ ኢታተꬃነ ኤንታ ናጋራ ታይቦፓ። ");
INSERT INTO gofe_vpl VALUES ("DT9_28","006_9_28","DEU","9","28","28","ሄስ ሀኖና አትኮ፥ ኔኒ ኑና ያፐ ከስዳ ግብፀ አሳይ፥ ‘ጎዳይ ኤንታዉ እማና ግዳ ቢታ ገልሳናዉ ዳንዳእቦና ግሾነ ኤንታ እፅዳ ግሾ፥ መላ ቢታን ዎꬋናዉ ኤንታ ከስስ’ ያጋና። ");
INSERT INTO gofe_vpl VALUES ("DT9_29","006_9_29","DEU","9","29","29","ግዶሽን፥ ሀ አሳይ ኔኒ ነ ግታ ዎልቃንነ ነ ምጨትዳ ቀሰን ግብፀፈ ከስዳ ነ ላታ ግድዳ ነ አሳ” ያጋስ። ");
INSERT INTO gofe_vpl VALUES ("DT10_1","006_10_1","DEU","10","1","1","ሄ ዎደ ጎዳይ ታኮ፥ “ኮይሮይሳ መላ ናምኡ ሎቸ ሹቻታ ጊግሳዳ ታኮ ዙማ ቦላ ከያ። ቃስ እያ ዎꬃናዉ ምꬃፈ ታቦተ ኦꬃ። ");
INSERT INTO gofe_vpl VALUES ("DT10_2","006_10_2","DEU","10","2","2","ታኒ ካሰ ነ መንꬅዳ ሹቻታ ቦላ ደእያ ቃላታ ሀ ሹቻታ ቦላ ፃፋና፤ ነ ኤንታ ታቦትያ ግዶን ዎꬃ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("DT10_3","006_10_3","DEU","10","3","3","ታኒ ሶቃላ ምꬃፈ ታቦተ ኦꬃስ። ካሰይሳ መላ ናምኡ ሎቸ ሹቻታ ጊግሳስ፤ ሄ ሹቻታ ታ ኩሸን ኦይካዳ ዙማ ቦላ ከያስ። ");
INSERT INTO gofe_vpl VALUES ("DT10_4","006_10_4","DEU","10","4","4","ህንተ ዙማ ፃጶን ሺቅዳ ጋላስ፥ ታማ ግዶፈ ጎዳይ ህንተዉ ኦድዳ ቃላታ፥ ሄስካ ታሙ ኪታታ፥ ካሰ ፃፍዳይሳታ ሄ ሹቻታ ቦላ ጎዳይ ፃፍድ ኤንታ ታዉ እሚስ። ");
INSERT INTO gofe_vpl VALUES ("DT10_5","006_10_5","DEU","10","5","5","ሄሳፈ ጉየ፥ ታኒ ዙማ ቦላፈ ዎꬋዳ፥ ጎዳይ ታና ኪትዳይሳዳ፥ ሄ ሹቻታ ታ ኦꬅዳ ታቦትያ ግዶን ዎꬃስ፤ ሀእካ ኤንቲ ያን ደኦሶና። ");
INSERT INTO gofe_vpl VALUES ("DT10_6","006_10_6","DEU","10","6","6","እስራኤለ አሳይ ባኣሮታ በንያቃናፐ ደንድድ፥ ሙሰራ ብዶሶና። አሮን ያን ሀይቅድ ሞገትስ፤ እያ ናአይ አላዛር እያ ላትድ፥ እያ በሳን ካህነ ሀላቃ ግድስ። ");
INSERT INTO gofe_vpl VALUES ("DT10_7","006_10_7","DEU","10","7","7","ኤንቲ ያፐ ጉድጎዳ ጌተትያ በሳ ብዶሶና፤ ያፐ ቃስ ጎግያ ሃꬃት ደእያ ዮፅባታ ጌተትያ በሳ ብዶሶና። ");
INSERT INTO gofe_vpl VALUES ("DT10_8","006_10_8","DEU","10","8","8","ሄ ዎደ ጎዳ ጫቆ ታቦትያ ቶካና መላ፥ ጎዳ ስንꬃን ኤቅድ እያ ሀጋዛና መላነ ሀች ጋካናዉ ኤንቲ ኦይሳ መላ ጎዳ ሱንꬃን አንጃና መላ ሌወ ኮቻ ጎዳይ ባዉ ዱማይስ። ");
INSERT INTO gofe_vpl VALUES ("DT10_9","006_10_9","DEU","10","9","9","ሄሳ ግሾ፥ ሌወ ኮቻስ ኤንታ እሻታ ግዶን ግሾይ ዎይኮ ላት ባዋ፤ ጎዳይ፥ ህንተ ፆሳይ ኤንታዉ ግዳይሳዳ ኤንታ ላታይ ጎዳ። ");
INSERT INTO gofe_vpl VALUES ("DT10_10","006_10_10","DEU","10","10","10","ታኒ ካሰይሳዳ ኦይታሙ ጋላስነ ኦይታሙ ቃማ ዙማ ቦላ ጋምአስ። ጎዳይ ዛሪድ ታ ዎሳ ስእድ ህንተና ꬋይሳናዉ ኮይቤና። ");
INSERT INTO gofe_vpl VALUES ("DT10_11","006_10_11","DEU","10","11","11","ጎዳይ ታኮ፥ “ታኒ ኤንታ አዋታስ እማና ጋዳ ጫቅዳ ቢታ ኤንቲ ገላና መላነ ላታና መላ ሀ አሳ ካለꬃ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("DT10_12","006_10_12","DEU","10","12","12","ነኖ፥ እስራኤለ፥ ጎዳይ ኔፐ ኮየይ ሀይሳ፤ ጎዳ፥ ነ ፆሳ ያያ፤ እያ ኦግያ ኡባን ባ፤ እያ ዶሳ፤ ነ ኩመꬃ ዎዛናፐነ ነ ኩመꬃ ሸምፑዋፈ ጎዳ ነ ፆሳስ ኦꬃ። ");
INSERT INTO gofe_vpl VALUES ("DT10_13","006_10_13","DEU","10","13","13","ነዉ እንጀታና መላ ታ ሀች ነዉ እምያ ጎዳ ኪታታነ አዋጆታ ናጋ። ");
INSERT INTO gofe_vpl VALUES ("DT10_14","006_10_14","DEU","10","14","14","ሳሎይነ ሳሎፐ ቦላራ ደእያ ሳሎት፥ ቃስ ሳእነ ሳአን ደእያ ኡባይ ጎዳ፥ ነ ፆሳባ ግደይስ ቱማ። ");
INSERT INTO gofe_vpl VALUES ("DT10_15","006_10_15","DEU","10","15","15","ግዶሽን፥ ጎዳይ ህንተ ማይዛታን ኡፋይትድ፥ ኤንታ ሲቅስ፤ ሀች ህንተ በኤይሳዳ ኤንታፈ ጉየን ኤንታ ሼሽ ግድዳ ህንተና ካዎተꬃታ ኡባፈ አꬅድ ዶርስ። ");
INSERT INTO gofe_vpl VALUES ("DT10_16","006_10_16","DEU","10","16","16","ሄሳ ግሾ፥ ህንተ ዎዛና ቃፃርተ፤ ህዛፐ ህንተ ዎዛና ምንꬆፍተ። ");
INSERT INTO gofe_vpl VALUES ("DT10_17","006_10_17","DEU","10","17","17","ጎዳይ፥ ህንተ ፆሳይ ፆሳታ ፆስነ ጎዳታ ጎዳ። እ ግታ ፆሲ፤ እ ዎልቃማነ ያሽያ ፆሲ። እ ሶምኦ በእድ ፕርደና፤ ዎꬋፈ ኤከና። ");
INSERT INTO gofe_vpl VALUES ("DT10_18","006_10_18","DEU","10","18","18","እ ይኦታስነ አምኤታስ ሱረ ፕርዴስ፤ በታንቹዋ ሲቅድ፥ እያዉ ካꬅነ ማኦ እሜስ። ");
INSERT INTO gofe_vpl VALUES ("DT10_19","006_10_19","DEU","10","19","19","ህንተካ በታንቾታ ሲቅተ፤ ህንተ ህንተ ሁጰን በተ አስ ግድድ ግብፀን ደእደታ። ");
INSERT INTO gofe_vpl VALUES ("DT10_20","006_10_20","DEU","10","20","20","ጎዳ፥ ነ ፆሳ ያያ፤ እያዉ ኦꬃ፤ እያራ ኦይከታ፤ እያ ሱንꬃን ጫቃ። ");
INSERT INTO gofe_vpl VALUES ("DT10_21","006_10_21","DEU","10","21","21","ኔኒ ነ አይፈን በእዳ ግታነ ያሽያ ማላልስያባታ ነዉ ኦꬅዳይ፥ እ ነ ጋላታ፤ ነ ፆሳ። ");
INSERT INTO gofe_vpl VALUES ("DT10_22","006_10_22","DEU","10","22","22","ግብፀ ቢታ ዎꬍዳ ህንተ ማይዛት ኩመꬅ ላፑን ታማ፤ ሀእ ጎዳይ፥ ህንተ ፆሳይ ህንተና ሳሎ ፆልንቶታዳ ዳርስስ። ");
INSERT INTO gofe_vpl VALUES ("DT11_1","006_11_1","DEU","11","1","1","ህዛ ጎዳ፥ ነ ፆሳ ዶሳ፤ እያ አዋጁዋ፥ ዎጋ፥ እያ ህግያነ እያ ኪታ ኡባ ዎደ ናጋ። ");
INSERT INTO gofe_vpl VALUES ("DT11_2","006_11_2","DEU","11","2","2","ህንተ ናይት በኦናባነ ኤሮናባ ግድኮካ፥ ህንተ ሀች ጎዳ ሴራ፥ እያ ግታተꬃ፥ እያ ዎልቃማ ኩሽያነ ምጨትዳ ቀስያ በእዳይሳ አኬክተ። ");
INSERT INTO gofe_vpl VALUES ("DT11_3","006_11_3","DEU","11","3","3","ህንተ እ ኦꬅዳ ማላታታነ ግብፀ ካዋ ቦላነ እያ ቢታ ኡባ ቦላ ኦꬅዳ ማላልስያባታ በእደታ። ");
INSERT INTO gofe_vpl VALUES ("DT11_4","006_11_4","DEU","11","4","4","ኤንቲ ህንተና ካልድ ጎድዳ ዎደ፥ ጎዳይ ግብፀ ቢታ ኦላንቾታ፥ ኤንታ ፓራታነ ፓራ ጋረታ ዞኦ አባን ምትስድ፥ ሀች ጋካናዉ ኤንታ ኩመꬅ ꬋይስዳይሳ በእደታ። ");
INSERT INTO gofe_vpl VALUES ("DT11_5","006_11_5","DEU","11","5","5","ህንተ ሀ በሳ ጋካናዉ መላ ቢታን ጎዳይ ህንተዉ ኦꬅዳባ ህንተ ኤሬታ። ");
INSERT INTO gofe_vpl VALUES ("DT11_6","006_11_6","DEU","11","6","6","ሮቤላ ኮቻፈ ኤልኣባ ናይታ ግድዳ ዳታነ ቦላነ አቤሮ ቦላ ጎዳይ ኦꬅዳይሳ አኬክተ። እስራኤለ አሳ ኡባይ በእሽን፥ ቢታይ ዶየትድ፥ ኤንታ፥ ኤንታ ሶ አሳ፥ ኤንታ ዱንካንያነ ሸምፖራ ደእያ ኤንታባ ኡባ ምትስ። ");
INSERT INTO gofe_vpl VALUES ("DT11_7","006_11_7","DEU","11","7","7","ጎዳይ ኦꬅዳ ሀ ግታ ኦሶታ ኡባ ህንተ፥ ህንተ አይፈን በእደታ። ");
INSERT INTO gofe_vpl VALUES ("DT11_8","006_11_8","DEU","11","8","8","ህዛ ህንተ ምኖ ግዳና መላነ ዮርዳኖሰ ፕንድ ህንተ ኤካናዉ ብያ ቢታ ላታና መላ ታኒ ሀች ህንተና ኪትያ ኪታ ኡባ ናግተ። ");
INSERT INTO gofe_vpl VALUES ("DT11_9","006_11_9","DEU","11","9","9","ህንተ ኪተትኮ፥ ጎዳይ ህንተ ማይዛታስነ ኤንታ ኮቻስ እማና ግድ ጫቅዳ፥ ማꬅነ ኤስ ጎግያ ቢታን ህንተ አዱሳ ላይꬅ ዳና። ");
INSERT INTO gofe_vpl VALUES ("DT11_10","006_11_10","DEU","11","10","10","ነ ላታናዉ ብያ ቢታይ፥ ነ ከያዳ ይዳ ግብፀ ቢታ መላ ግደና። ግብፀን ነ ካꬅ ዘራዳ፥ ጎሻ ቢታ ኡባ አታክልተ በሳዳ ሃ ኡሻሳ። ");
INSERT INTO gofe_vpl VALUES ("DT11_11","006_11_11","DEU","11","11","11","ሽን ዮርዳኖሰ ፕንድ ህንተ ላታናዉ ብያ ቢታይ፥ ደረይነ ዛንጋራይ ደእያ፥ ሳሎ እራን አልያ ቢታ። ");
INSERT INTO gofe_vpl VALUES ("DT11_12","006_11_12","DEU","11","12","12","ሄ ቢታይ፥ ጎዳይ ነ ፆሳይ ናግያ ቢታ፤ ላይꬃ ዶመꬃፈ ብድ ላይꬃ ዉርሰꬃ ጋካናዉ ጎዳ፥ ነ ፆሳ አይፈይ እያ ቦላ ደእያ ቢታ። ");
INSERT INTO gofe_vpl VALUES ("DT11_13","006_11_13","DEU","11","13","13","ሄሳ ግሾ፥ ጎዳ፥ ህንተ ፆሳ ሲቅኮ፥ ህንተ ኩመꬃ ዎዛናፐነ ህንተ ኩመꬃ ሸምፑዋፈ እያ ጎይንኮ፥ ታኒ ሀች ህንተዉ እምያ ኪታ ህንተ ናግኮ፥ ");
INSERT INTO gofe_vpl VALUES ("DT11_14","006_11_14","DEU","11","14","14","ነ ካꬅ፥ ዎይነይ ዛይተይ ፓጮና ሺሻና መላ ቶርቸነ ስላ እራ ዎደን ዎደን ቡክሳና። ");
INSERT INTO gofe_vpl VALUES ("DT11_15","006_11_15","DEU","11","15","15","ጎዳይ ነ መህያስ ማታ ዳርሳና፤ ነ ማና፤ ካላና። ");
INSERT INTO gofe_vpl VALUES ("DT11_16","006_11_16","DEU","11","16","16","ህንተ ዎዛና ሀራ ሶ ዛሪድ፥ ሀራ ፆሳታ ጎይኖና መላነ ሆኮና መላ ናገትተ። ");
INSERT INTO gofe_vpl VALUES ("DT11_17","006_11_17","DEU","11","17","17","ሄሳ ህንተ ኦꬅኮ፥ ጎዳ ሀንቆይ ህንተ ቦላ ኤፃና፤ እራይ ቡኮና መላነ ካꬅ ዶሎና መላ እ ሳሉዋ ጎርዳና። ህንተ ጎዳይ ህንተዉ እምያ ሎኦ ቢታፈ ኤሶን ꬋያና። ");
INSERT INTO gofe_vpl VALUES ("DT11_18","006_11_18","DEU","11","18","18","ህዛ፥ ሀ ኪታታ ህንተ ዎዛናንነ ህንተ ቆፋን ዎꬅተ። ማላዳ ኤንታ ህንተ ኩሸን ቃችተ፤ ቃስ ህንተ ሶምኦን ቃችተ። ");
INSERT INTO gofe_vpl VALUES ("DT11_19","006_11_19","DEU","11","19","19","ህንተ ናይታ ታማርስተ። ህንተ ሶን ደእያ ዎደ፥ ኦገን ሄመትያ ዎደ፥ ዝንእያ ዎደነ ደንድያ ዎደ ኤንታዉ ኦድተ። ");
INSERT INTO gofe_vpl VALUES ("DT11_20","006_11_20","DEU","11","20","20","ህንተ ፐንገ ዝዝግያ ቦላነ ህንተ ድርሳ ፐንግያ ቦላ ፃፍተ። ");
INSERT INTO gofe_vpl VALUES ("DT11_21","006_11_21","DEU","11","21","21","ሄሳ ህንተ ኦꬅኮ፥ ጎዳይ ህንተ ማይዛታስ እማና ግድ ጫቅዳ ቢታን፥ ህንተ ላይꬃይነ ህንተ ናይታ ላይꬃይ ሳአፐ ቦላራ ደእያ ሳሎ መላ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("DT11_22","006_11_22","DEU","11","22","22","ህንተ ጎዳ፥ ህንተ ፆሳ ዶስኮ፥ እያ ኦገ ኡባን ህንተ ቢኮ፥ እያዉ አማነትኮ፥ ታ ሀች ህንተዉ እምያ ኪታ ህንተ ምንꬅድ ናግኮ፥ ");
INSERT INTO gofe_vpl VALUES ("DT11_23","006_11_23","DEU","11","23","23","ጎዳይ ሀ ካዎተꬃታ ኡባ ህንተ ስንꬃፈ ጎድድ ከሳና። ህንተፈ ዳርያነ ዎልቃምያ ካዎተꬃታ ቢታ የግስድ ኤካና። ");
INSERT INTO gofe_vpl VALUES ("DT11_24","006_11_24","DEU","11","24","24","ቶሆን ህንተ የꬍዳ ቢታ ኡባይ ህንተባ ግዳና። ህንተ ዛዋይ ዱገሀ መላ ቢታፈ ብድ ልባኖሰ ጋካናዉነ ኤፍራፂሳ ሻፋፐ ብድ ግታ አባ ጋካናዉ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("DT11_25","006_11_25","DEU","11","25","25","ህንተራ አይ አስካ ኤቀታናዉ ዳንዳኤና፤ ጎዳይ፥ ህንተ ፆሳይ ህንተዉ ግዳይሳዳ ህንተ ብያ ሶ ኡባን አሳይ ህንተና በእድ ዳጋማና መላነ ህንተዉ ያያና መላ ኦꬃና። ");
INSERT INTO gofe_vpl VALUES ("DT11_26","006_11_26","DEU","11","26","26","ሄኮ፥ ታ ሀች ህንተ ስንꬃን አንጆነ ባደꬅ ዎꬃይስ። ");
INSERT INTO gofe_vpl VALUES ("DT11_27","006_11_27","DEU","11","27","27","ታ ሀች ህንተና ኪትያ ጎዳ፥ ህንተ ፆሳ ኪታ ናግኮ፥ ህንተ አንጀታና። ");
INSERT INTO gofe_vpl VALUES ("DT11_28","006_11_28","DEU","11","28","28","ሽን ታኒ ህንተና ሀች ኪትያ ጎዳ፥ ህንተ ፆሳ ኪታ ናጎና እፅድ፥ ሀራ ፆሳታ ጎይናናዉ እያ ኦግያፐ ደሽኮ፥ ህንተ ባደታና። ");
INSERT INTO gofe_vpl VALUES ("DT11_29","006_11_29","DEU","11","29","29","ጎዳይ፥ ህንተ ፆሳይ ህንተ ላታናዉ ብያ ቢታ ህንተና ገልስያ ዎደ፥ ባደꬃ ጋርዛና ዙማ ቦላ፥ አንጁዋ ኤባላ ዙማ ቦላ አዋጅተ። ");
INSERT INTO gofe_vpl VALUES ("DT11_30","006_11_30","DEU","11","30","30","ሀ ዙማት ዮርዳኖሰ ሻፋፐ ሄፍንꬃን ኦግያፐ ዉሎሀ ባጋን፥ አራባን ደእያ ካናነታ ቢታን፥ ጋልጋላ ስንꬃን ደእያ ሞረ ምꬃ ማታን ደኦሶና። ");
INSERT INTO gofe_vpl VALUES ("DT11_31","006_11_31","DEU","11","31","31","ህንተ ሀእ ጎዳይ፥ ህንተ ፆሳይ ህንተዉ እምያ ቢታ ላታናዉ ዮርዳኖሰ ሻፋ ፕናና ሀኔታ። ህንተ ሄ ቢታ ኤክድ ያን ደእያ ዎደ፥ ");
INSERT INTO gofe_vpl VALUES ("DT11_32","006_11_32","DEU","11","32","32","ታ ሀች ህንተዉ እምያ አዋጆታነ ህግያ ኡባ ምንꬅድ ናግተ። ");
INSERT INTO gofe_vpl VALUES ("DT12_1","006_12_1","DEU","12","1","1","ህንተ ላታና መላ ጎዳይ፥ ህንተ አዋታ ፆሳይ ህንተዉ እምዳ ቢታን ህንተ ደእዳ ዎደ ኡባን ህንተ ኦꬃናዉ በሲያ አዋጆትነ ህገት ሀይሳታ። ");
INSERT INTO gofe_vpl VALUES ("DT12_2","006_12_2","DEU","12","2","2","ህንተ ላትያ ቢታን ደእያ ካዎተꬃታስ ደርያ ቦላ፥ ዙማ ቦላነ እስ እስ ምꬃ ጋርሳን ደእያ ጎይኖ በሳታ ꬋይስተ። ");
INSERT INTO gofe_vpl VALUES ("DT12_3","006_12_3","DEU","12","3","3","ኤንታ ያርሾ በሳታ ላልተ፤ ኤንታ ጎይኖ ሹቻ ቱሳታ መንረꬅተ። አሼራ ጌተትያ ኤንታ ኤቃ ምስልያ ታማን ፁግተ፤ ኩሸን ኦሰትዳ ኤንታ ፆሳታ ምስለታ ꬋይስተ፤ ኤንታ ሱንꬃታ ሄ በሳፈ ቁችተ። ");
INSERT INTO gofe_vpl VALUES ("DT12_4","006_12_4","DEU","12","4","4","ጎዳ፥ ህንተ ፆሳ ኤንቲ ባንታ ፆሳ ጎይንያ ኦገን ጎይኖፍተ። ");
INSERT INTO gofe_vpl VALUES ("DT12_5","006_12_5","DEU","12","5","5","ጎዳይ፥ ህንተ ፆሳይ ህንተ ኮቸ ኡባ ግዶፈ ባ ሱንꬃይ ያን ፄገታና መላ ዶርዳ በሳ ኮይተ። ሄ በሳ ህንተ ባናዉ ኮሼስ። ");
INSERT INTO gofe_vpl VALUES ("DT12_6","006_12_6","DEU","12","6","6","ህንተ ፁሳ ያርሹዋ፥ ሀራ ያርሹዋ፥ ህንተ አስራታ፥ ህንተ እሙዋ፥ ህንተ ቃንገꬃ፥ ህንተ ዶስድ እምያ እሙዋ፥ ህንተ መህያፐነ ዶርሳፈ ባይራ ሄ በሳ ኤህተ። ");
INSERT INTO gofe_vpl VALUES ("DT12_7","006_12_7","DEU","12","7","7","ጎዳይ፥ ህንተ ፆሳይ ህንተና አንጅዳ ግሾ፥ ሄሳን፥ ጎዳይ፥ ህንተ ፆሳይ ደእያ በሳን፥ ህንተነ ህንተ ሶ አሳይ ማና፤ ህንተ ኩሸይ ኦꬅዳባ ኡባን ህንተ ኡፋይታና። ");
INSERT INTO gofe_vpl VALUES ("DT12_8","006_12_8","DEU","12","8","8","ሀች ሀይሳን ህንተ እሶይ እሶይ፥ ዶስዳባ ኦይሳዳ ሄ ዎደ ኦከታ። ");
INSERT INTO gofe_vpl VALUES ("DT12_9","006_12_9","DEU","12","9","9","ጎዳይ፥ ህንተ ፆሳይ ህንተዉ እምያ ሸምፖ ቢታ ቡሮ ጋክበከታ። ");
INSERT INTO gofe_vpl VALUES ("DT12_10","006_12_10","DEU","12","10","10","ሽን ህንተ ዮርዳኖሰ ፕንድ፥ ጎዳይ ህንተ ፆሳይ እምያ ሄ ቢታ ላትድ ያን ኡታና። ህንተና ተቅዳ ሞርከታፐ እ ህንተና ሸምፕስያ ግሾ ያን ዎፑ ግድ ህንተ ዳና። ");
INSERT INTO gofe_vpl VALUES ("DT12_11","006_12_11","DEU","12","11","11","ሄ ዎደ ጎዳይ፥ ህንተ ፆሳይ ባ ሱንꬃይ ሄሳን ፄገታናዉ ዶርዳ ሄ በሳን፥ ታ ህንተና ኪትያባ ኡባ፥ ፁሳ ያርሹዋ፥ ሀራ ያርሹዋ፥ ህንተ አስራታ፥ ህንተ እሙዋነ ህንተ ቃንገꬃ ኡባ ያ ኤሄታ። ");
INSERT INTO gofe_vpl VALUES ("DT12_12","006_12_12","DEU","12","12","12","ህንተ፥ ህንተ አደ ናይትነ ህንተ ማጫ ናይት፥ ህንተ አደ አይለትነ ማጫ አይለት ህንተራ ላታ ኤክቦና ህንተ ካታማን ደእያ ሌወታራ እስፈ ያን ጎዳ፥ ህንተ ፆሳ ስንꬃን ኡፋይታና። ");
INSERT INTO gofe_vpl VALUES ("DT12_13","006_12_13","DEU","12","13","13","ኔኒ ፁሳ ያርሹዋ ነ ኮይዳ በሳን ጮ ያርሾና መላ ናገታ። ");
INSERT INTO gofe_vpl VALUES ("DT12_14","006_12_14","DEU","12","14","14","ኔኒ፥ ነ ኮቻፈ እሱዋን፥ ጎዳይ ዶርዳ በሳን፥ ነ ፁሳ ያርሹዋ ያርሻ፤ ታ ነና ኪትዳ ኡባ ያን ኦꬃ። ");
INSERT INTO gofe_vpl VALUES ("DT12_15","006_12_15","DEU","12","15","15","ግዶሽን ነ ደእያ በሳን አዉንካ ነ መህያፐ ጎዳይ ነና አንጅዳይሳዳ ሹካዳ ማ። ዎጋዳ ቱና ግድን ዎይኮ ቱና ግዶና አስ ኦንካ ጋራነ ገንኤ መይሳዳ ነ መህያፐ ሹካዳ ማ። ");
INSERT INTO gofe_vpl VALUES ("DT12_16","006_12_16","DEU","12","16","16","ሽን ሱꬅ ሃꬃዳ ሳአን ጉሳፈ አትሽን፥ ሞፓ። ");
INSERT INTO gofe_vpl VALUES ("DT12_17","006_12_17","DEU","12","17","17","ነ ካꬃፈ፥ ዎይንያፐነ ዛይትያፐ እምያ አስራታ፥ ነ መህያፐነ ዶርሳ ዉድያፐ እምያ ባይራ፥ ጎዳስ ቃንግዳባ ኡባነ ነ ዶሳን እምያ እሙዋ ኡባ ነ ደእያ ሄራን ሞፓ። ");
INSERT INTO gofe_vpl VALUES ("DT12_18","006_12_18","DEU","12","18","18","ሽን ነኒ፥ ነ አደ ናይትነ ነ ማጫ ናይት፥ ነ አደ አይለትነ ማጫ አይለት ኔራ ላታ ኤክቦና ነ ካታማን ደእያ ሌወታራ እስፈ ጎዳይ፥ ነ ፆሳይ ዶርዳ በሳን፥ ጎዳ፥ ነ ፆሳ ስንꬃን፥ ሀ ያርሾ ኡባ ማ። ነ ዳቡራዳ ሺሽዳባን ጎዳ፥ ነ ፆሳ ስንꬃን ኡፋይታ። ");
INSERT INTO gofe_vpl VALUES ("DT12_19","006_12_19","DEU","12","19","19","ነ ደኦ ላይꬃ ኡባን ሌወታ ቀል ጎና መላ ናገታ። ");
INSERT INTO gofe_vpl VALUES ("DT12_20","006_12_20","DEU","12","20","20","እ ነዉ ገልዳ ቃላዳ ጎዳይ ነ ፆሳይ ነ ዛዋ ዳልግስያ ዎደ ነና አሾ ማናዉ ኮሽያ ዎደ ነ ኮይዳ መላ ማ። ");
INSERT INTO gofe_vpl VALUES ("DT12_21","006_12_21","DEU","12","21","21","ሽን ጎዳይ፥ ነ ፆሳይ ባ ሱንꬃይ ያን ፄገታና መላ ዶርዳ በሳይ ነዉ ሃክኮ፥ ጎዳይ ነዉ እምዳ ነ መሄ ዎይኮ ዶርሳ ዉድያፐ ታ ነና ኪትዳይሳዳ፥ ነ ኮይዳ መላ ነ ካታማን ሹካዳ ማ። ");
INSERT INTO gofe_vpl VALUES ("DT12_22","006_12_22","DEU","12","22","22","ዎጋዳ ቱና ግድን ዎይኮ ቱና ግዶና አስ ኦንካ ጋራ ዎይኮ ገንኤ መይሳዳ ሞ። ");
INSERT INTO gofe_vpl VALUES ("DT12_23","006_12_23","DEU","12","23","23","ደኦይ ሱꬃን ደእያ ግሾ፥ ሱꬅ ደእያ አሾ ሞና መላ ናገታ፤ ሄሳ ግሾ፥ ደኦ አሾራ ጋꬃዳ ሞፓ። ");
INSERT INTO gofe_vpl VALUES ("DT12_24","006_12_24","DEU","12","24","24","ሱꬅ ሃꬃዳ ቢታን ጉሳፈ አትሽን፥ ሞፓ። ");
INSERT INTO gofe_vpl VALUES ("DT12_25","006_12_25","DEU","12","25","25","ነዉነ ኔፐ ጉየራ ያና ነ ናይታስ እንጀታና መላ ሱꬅ ሞፓ። ሄሳ ነ ኦꬅኮ ጎዳ ኡፋይሳሳ። ");
INSERT INTO gofe_vpl VALUES ("DT12_26","006_12_26","DEU","12","26","26","ሽን ነ ጎዳስ ዱማይዳባነ እያዉ ቃንግዳባ ኤካዳ፥ ጎዳይ ዶርዳ በሳ ባ። ");
INSERT INTO gofe_vpl VALUES ("DT12_27","006_12_27","DEU","12","27","27","ፁሳ ያርሾ አሹዋነ ሱꬃ ጎዳ፥ ነ ፆሳ ያርሾ በሳን ያርሻ። ሀራ ያርሾ ሱꬃ ጎዳ፥ ነ ፆሳ ያርሾ በሳ ማታን ጉሳዳ አሹዋ ማ። ");
INSERT INTO gofe_vpl VALUES ("DT12_28","006_12_28","DEU","12","28","28","ነዉነ ነ ናይታስ እንጀታና መላ ታ ነና ኪትያ ኪታ ምንꬃዳ ናጋ። ሄሳ ነ ኦꬅኮ፥ ጎዳ ነ ፆሳ ኡፋይስያባነ ሱረባ ኦꬃሳ። ");
INSERT INTO gofe_vpl VALUES ("DT12_29","006_12_29","DEU","12","29","29","ነ ላታናዉ ብያ ካዎተꬃ፥ ጎዳይ ነ ፆሳይ ነ ስንꬃፈ ꬋይስያ ዎደነ ነ ኤንታ ቢታ ላትያ ዎደ፥ ");
INSERT INTO gofe_vpl VALUES ("DT12_30","006_12_30","DEU","12","30","30","ኤንቲ ነ ስንꬃፈ ꬋይዳፐ ጉየ፥ ነ ኤንታ ፆሳታ ጎይናዳ፥ ፅሄን ኦይከቶና መላ ናገታ። ኔኒ፥ “ሀ ካዎተꬃት ባንታ ፆሳታ ዋትድ ጎይኖና?” ያጋዳ ካላዳ ኦይቾና መላ ናገታ። ");
INSERT INTO gofe_vpl VALUES ("DT12_31","006_12_31","DEU","12","31","31","ኤንቲ ባንታ ፆሳታ ጎይንያ ዎደ ጎዳይ እፅያ ኡባ ኦꬅያ ግሾ፥ ጎዳ ነ ፆሳ ነ ሄሳዳ ጎይናናዉ በሰና። ኤንቲ ሀር አቶሽን፥ ባንታ አደ ናይታነ ማጫ ናይታ ባንታ ፆሳታስ ያርሾ ኦꬅድ ታማን ፁጎሶና። ");
INSERT INTO gofe_vpl VALUES ("DT12_32","006_12_32","DEU","12","32","32","ህዛ ታ ነና ኪትዳባ ኡባ ኦꬃ፤ እያ ቦላ ጉጆፋ፤ እያፐ ፓጭሶፓ። ");
INSERT INTO gofe_vpl VALUES ("DT13_1","006_13_1","DEU","13","1","1","ነ ግዶን ትንብተ ኦድያ ዎይኮ አሙሆ ብርሽያ አስ ደንድድ፥ ማላታነ ማላልስያባታ ኦꬅኮ፥ ");
INSERT INTO gofe_vpl VALUES ("DT13_2","006_13_2","DEU","13","2","2","እ ኦድዳ ማላታይ ዎይኮ ማላልስያባይ ቱማ ግድድ ፖለትን፥ እ ኔኮ፥ “አነ ካሰ ነ ኤሮና ሀራ ፆሳታ ጎይኖስ” ያግኮ፥ ");
INSERT INTO gofe_vpl VALUES ("DT13_3","006_13_3","DEU","13","3","3","ነ እያ ኡባራካ ስኦፓ። ህንተ ኩመꬃ ዎዛናፐነ ኩመꬃ ሸምፑዋፈ ጎዳ ህንተ ፆሳ ዶስያኮነ ዶሶናኮ ፓጫናዉ ሄሳ ኦꬄስ። ");
INSERT INTO gofe_vpl VALUES ("DT13_4","006_13_4","DEU","13","4","4","ጎዳ ህንተ ፆሳ ካልተ፤ እያዉ ያይተ፤ እያ ኪታ ናግተ፤ እያ ቃላ ስእተ፤ እያዉ ጎይንተ፤ እያፐ ዱፆፍተ። ");
INSERT INTO gofe_vpl VALUES ("DT13_5","006_13_5","DEU","13","5","5","ህንተና ግብፀ አይለተꬃፈ ዎዝዳ ጎዳ፥ ህንተ ፆሳ ቦላ ህንተ ማካላና መላ ታማርስያ ናበ ዎይኮ አሙሆ ብርሽያ ኡራ ዎꬍተ። ሄሳ መላ አስ ህንተ ጎዳ፥ ህንተ ፆሳ ኪታፐ ካረ ከያና መላ ኦꬅያ ግሾ፥ እያ ዎꬍተ፤ ኢታ ህንተ ግዶፈ ድግተ። ");
INSERT INTO gofe_vpl VALUES ("DT13_6","006_13_6","DEU","13","6","6","ሀር አቶሽን፥ ነ እሻይ ዎይኮ ነ አደ ናአይ ዎይኮ ነ ማጫ ናእያ ዎይኮ ነ ዶስያ ማችያ ዎይኮ ነ ማታ ላገይ፥ “ካሰ ነነ ነ ማይዛት ጎይን ኤሮና ፆሳታ ጎይናናዉ የꬋ። ");
INSERT INTO gofe_vpl VALUES ("DT13_7","006_13_7","DEU","13","7","7","ቢታ ሀ ጋፃፐ ያ ጋፃ ጋካናዉ ደእያ፥ ነ ዩሾ ኡባን ማታንነ ሃሆን ደእያ አሳ ኡባይ ጎይንያ ፆሳታ ጎይናናዉ የꬋ” ያግድ ባለꬅኮ፥ ");
INSERT INTO gofe_vpl VALUES ("DT13_8","006_13_8","DEU","13","8","8","እያዉ ኤሮ ጎፓ፤ እ ገይሳ ስኦፓ። እያዉ ቃታዳ እያ ሸምፑዋ አሾፋ፤ ");
INSERT INTO gofe_vpl VALUES ("DT13_9","006_13_9","DEU","13","9","9","እያ ዎꬋናዉ በሴስ። እያ ዎꬋናዉ ኮይሮ ነ ዶማ፤ ሄሳፈ ጉየ፥ አሳ ኡባይ ካልድ ዎꬎ። ");
INSERT INTO gofe_vpl VALUES ("DT13_10","006_13_10","DEU","13","10","10","እ ሀይቃና ጋካናዉ ሹቻን ጫዳ፤ እ ነና ግብፀ ቢታፈ፥ አይለተꬃ ኬꬃፈ ከስዳ ጎዳ፥ ነ ፆሳፈ ነና ሻካናዉ ኮዬስ። ");
INSERT INTO gofe_vpl VALUES ("DT13_11","006_13_11","DEU","13","11","11","እስራኤለ አሳይ ሄሳ ስእድ ያያና፤ ቃስ ሄሳ መላ ኢታባ ዛሪድ ህንተ ግዶን ኦንካ ኦና። ");
INSERT INTO gofe_vpl VALUES ("DT13_12","006_13_12","DEU","13","12","12","ጎዳይ፥ ነ ፆሳይ ነ ዳና መላ እምዳ ካታማፐ እሱዋን ነ ደእያ ዎደ፥ ");
INSERT INTO gofe_vpl VALUES ("DT13_13","006_13_13","DEU","13","13","13","ነ አሳ ግዶን ኢታት ደንድድ፥ አሳኮ፥ “ኑኒ ኤሮና ፆሳታ ጎይናናዉ ደንድተ” ያግድ ባለꬅሽን ነ ስእኮ፥ ");
INSERT INTO gofe_vpl VALUES ("DT13_14","006_13_14","DEU","13","14","14","ሄ ሀኖታ ኦይቻ፤ ምንꬃዳ ፕልጋ። ሄ ነ ግዶን ኦሰትዳ ቱናባይ ቱማ ግደይሳ ሻካዳ ኤርኮ፥ ");
INSERT INTO gofe_vpl VALUES ("DT13_15","006_13_15","DEU","13","15","15","ሄ ካታማን ደእያ አሳ ኡባ ማሻን ዉርሳ፤ ሄ ካታማነ እያን ደእያ መህያ አሾና ꬋይሳ። ");
INSERT INTO gofe_vpl VALUES ("DT13_16","006_13_16","DEU","13","16","16","ሄ ካታማፐ ነ ኤክዳ ድኦ ኡባ ካታማ ዳባባ ሺሻዳ፥ ሄ ካታማነ እያ ድኡዋ ኡባ ጎዳስ፥ ነ ፆሳስ፥ ፁሳ ያርሾ ኦꬃዳ ዉርሳዳ ፁጋ። እ መርናዉ ዛሪድ ኬፀቶና ላለꬃ ዶረ ግድድ አታና። ");
INSERT INTO gofe_vpl VALUES ("DT13_17","006_13_17","DEU","13","17","17","ሀ ድገትዳ ሚሸታፐ አይብካ ነ ኩሸን በንቶፎ። ጎዳይ ባ ዎልቃማ ሀንቁዋፈ ስሚድ፥ ነና ማራና፤ እ ነዉ ቃታና። ካሰ ነ ማይዛታስ ጫቅዳ ጫቁዋዳ ነ ታይቡዋ ዳርሳና። ");
INSERT INTO gofe_vpl VALUES ("DT13_18","006_13_18","DEU","13","18","18","ታኒ ሀች ነና ኪትያ ኪታ ኡባ ነ ናጋዳ፥ ጎዳ፥ ነ ፆሳስ ኪተትኮ፥ ጎዳ ነ ፆሳ ኡፋይስያባ ኦꬅኮ፥ ሀ ግዳባይ ነዉ ፖለታና። ");
INSERT INTO gofe_vpl VALUES ("DT14_1","006_14_1","DEU","14","1","1","ህንተ፥ ጎዳ ህንተ ፆሳ ናይታ፤ ሀይቅዳ አሳስ ህንተ አሳተꬃ ጋሮፕተ፤ ህንተ ሁጵያ ቡሉሶፕተ። ");
INSERT INTO gofe_vpl VALUES ("DT14_2","006_14_2","DEU","14","2","2","ህንተ፥ ጎዳ ህንተ ፆሳስ ጌሻ ደረ፤ ጎዳይ ህንተና ባ አሰ ግዳና መላ ቢታን ደእያ አሳ ኡባፈ ባዉ ዶርስ። ");
INSERT INTO gofe_vpl VALUES ("DT14_3","006_14_3","DEU","14","3","3","ኔኒ ቱናባ አይባካ ሞፓ። ");
INSERT INTO gofe_vpl VALUES ("DT14_4","006_14_4","DEU","14","4","4","ነ ማና መሄትነ ዶአት ሀይሳታ፤ ቦር፥ ዶርሰ፥ ዴሸ፥ ");
INSERT INTO gofe_vpl VALUES ("DT14_5","006_14_5","DEU","14","5","5","ዶገ፥ ባቾ፥ ዎሽኤ፥ ዎራ ዴሽ፥ ዋልያ፥ ጋራነ ዙማ ዶርሰ። ");
INSERT INTO gofe_vpl VALUES ("DT14_6","006_14_6","DEU","14","6","6","ሹቁለይ ጳልቀትዳይሳነ ዋሞትያ መሄታነ ዶአታ ኡባ ሚተ። ");
INSERT INTO gofe_vpl VALUES ("DT14_7","006_14_7","DEU","14","7","7","ሽን ሹቁለይ ጳልቀቶናይሳታነ ዋሞቶናይሳታ ሞፓ፤ ሄስካ ግማለ፥ ኤሸነ ጉፓለ። ሀይሳቲ ዋሞቶሶና፥ ሽን ኤንታ ሹቁለይ ጳልቀትቦና ግሾ፥ ኤንቲ ህንተዉ ቱና። ");
INSERT INTO gofe_vpl VALUES ("DT14_8","006_14_8","DEU","14","8","8","ጉዱንꬆስ ሹቁለይ ጳልቀꬅ፥ ሽን ዋሞቶና ግሾ እ ህንተዉ ቱና። እያ አሹዋ ሞፓ፤ እያ ባዉታ ቦቾፍተ። ");
INSERT INTO gofe_vpl VALUES ("DT14_9","006_14_9","DEU","14","9","9","ሃꬃ ግዶን ደእያ መተꬃታ ግዶፈ ህንተ ማናይሳት ሀይሳታ፤ ሞሎ መላ ቀፈይነ ፖቆይ ደእያ ኡባ ሚተ። ");
INSERT INTO gofe_vpl VALUES ("DT14_10","006_14_10","DEU","14","10","10","ሽን ሞሎ መላ ቀፈይነ ፖቆይ ባይናይሳታ ሞፕተ ሄስ ህንተዉ ቱና። ");
INSERT INTO gofe_vpl VALUES ("DT14_11","006_14_11","DEU","14","11","11","ቱና ግዶና ካፎ ኡባ ሚተ። ");
INSERT INTO gofe_vpl VALUES ("DT14_12","006_14_12","DEU","14","12","12","ሽን ካፎታፐ ህንተ ሞና አጋና ካፎት ሀይሳታ፤ አርጋንꬅ፥ ባዞ አንኮ፥ ካሬꬃ አንኮ፥ ");
INSERT INTO gofe_vpl VALUES ("DT14_13","006_14_13","DEU","14","13","13","ጵርጮ፥ ፅሎ ኮቸ ኡባ፥ ");
INSERT INTO gofe_vpl VALUES ("DT14_14","006_14_14","DEU","14","14","14","ቆራሰ ኮቸ ኡባ፥ ");
INSERT INTO gofe_vpl VALUES ("DT14_15","006_14_15","DEU","14","15","15","ያንቾ፥ ሃꬃ ካፎ፥ ቃማ ካፎ ኮቸ ኡባ፥ ");
INSERT INTO gofe_vpl VALUES ("DT14_16","006_14_16","DEU","14","16","16","ላፋ ጉቶ፥ ዲድን፥ ሃꬃ ኩቶ፥ ");
INSERT INTO gofe_vpl VALUES ("DT14_17","006_14_17","DEU","14","17","17","ባዞ ጉቶ፥ ሞሎ ካፎ፥ ሶሌ፥ ሀዛዞ፥ ");
INSERT INTO gofe_vpl VALUES ("DT14_18","006_14_18","DEU","14","18","18","ሳብሳ ጌተትያ ካፎ ኮቸ ኡባ፥ አያና ካፎነ ሽርሽቆ። ");
INSERT INTO gofe_vpl VALUES ("DT14_19","006_14_19","DEU","14","19","19","ቀፈራ ደእያ ላፋ መተꬃት ኡባይ ህንተዉ ቱና፤ ኤንታ ሞፕተ። ");
INSERT INTO gofe_vpl VALUES ("DT14_20","006_14_20","DEU","14","20","20","ሽን ቀፈራ ደእያባታፐ ቱና ግዶናይሳታ ሚተ። ");
INSERT INTO gofe_vpl VALUES ("DT14_21","006_14_21","DEU","14","21","21","ኔኒ፥ ጎዳ ነ ፆሳስ ጌሻ አስ ግድያ ግሾ፥ ባዉታ ኡባ ሞፓ። ሄሳ ህንተ ካታማን ደእያ በተ አሳይ ማና መላ ኤንታዉ እማናዉ ዳንዳኤታ፤ ዎይኮ ሀራ ቢታ አሳስ ባይዛናዉ ዳንዳኤታ። ዴሻ ናአ እያ አየ ማꬃራ ካꬆፋ። ");
INSERT INTO gofe_vpl VALUES ("DT14_22","006_14_22","DEU","14","22","22","ነ ጋደን ላይꬃን ላይꬃን ካፅያ ካꬃ አይፈ ኡባፈ አስራታ ከሳ። ");
INSERT INTO gofe_vpl VALUES ("DT14_23","006_14_23","DEU","14","23","23","ነ ኡባ ዎደ ጎዳስ ነ ፆሳስ፥ ያሽ ታማራና መላ ባ ሱንꬃይ ፄገታና መላ እ ዶርዳ በሳን፥ ነ ካꬃ፥ ዎይነ ኡሻነ ዛይትያ አስራታ፥ ነ ዶርሳፈነ መህያፐ ባይራ የለትዳይሳ ያን፥ ጎዳ፥ ነ ፆሳ ስንꬃን ማ። ");
INSERT INTO gofe_vpl VALUES ("DT14_24","006_14_24","DEU","14","24","24","ጎዳይ ነ ፆሳይ ባ ሱንꬃይ ፄገታና መላ ዶርዳ በሳይ፥ ነ ደእያ በሳፈ ዳሮ ሃሆ ግድኮ፥ ጎዳይ ነና አንጃና መላ ነ አስራታ ያ ኤፋናዉ ዳንዳኦናባ ግድኮ፥ ");
INSERT INTO gofe_vpl VALUES ("DT14_25","006_14_25","DEU","14","25","25","ሄ አስራታ ባይዛዳ ሚሽያ ጎዳይ፥ ነ ፆሳይ ዶርዳ በሳ ኤፋ። ");
INSERT INTO gofe_vpl VALUES ("DT14_26","006_14_26","DEU","14","26","26","ሄ ሚሽያን ነ ኮይዳ ሚዝ ዎይኮ ዶርሰ ዎይኮ ዎይነ ኡሽ ዎይኮ ሀራ ምኖ ኡሽ ዎይኮ ሀራ ነ ኮይያባ ሻማዳ፥ ነነ ነ ሶ አሳይ ጎዳ፥ ነ ፆሳ ስንꬃን ሄሳ ማዳ ኡፋይታ። ");
INSERT INTO gofe_vpl VALUES ("DT14_27","006_14_27","DEU","14","27","27","ኤንቲ ኔራ ሻከትድ ኤክዳ ሀራ ላት ኤንታዉ ባይና ግሾ፥ ሄሳ ነ ኦꬅያ ዎደ ነ ካታማን ደእያ ሌወታ ዶጎፓ። ");
INSERT INTO gofe_vpl VALUES ("DT14_28","006_14_28","DEU","14","28","28","ሄꬓንꬆ ላይꬃን ላይꬃን ነ ካꬃ አስራታ ኤሀዳ ነ ካታማን ሺሻ። ");
INSERT INTO gofe_vpl VALUES ("DT14_29","006_14_29","DEU","14","29","29","ሄሳ ነ ካታማን ደእያ፥ ኔራ ሻክትድ ኤክዳ ሀራ ላት ባይና ሌወት፥ በተ አሳይ፥ ይኦ ናይትነ አምኤት ይድ ሞ። ያትኮ፥ ነ ኦꬅያ ኦሶ ኡባን ጎዳይ፥ ነ ፆሳይ ነና አንጃና። ");
INSERT INTO gofe_vpl VALUES ("DT15_1","006_15_1","DEU","15","1","1","“ላፑንꬃ ላይꬃ ዉርሰꬃን ታልኤ አጮ ኡባ ማራ። ");
INSERT INTO gofe_vpl VALUES ("DT15_2","006_15_2","DEU","15","2","2","ነ አጮ ማራና ዎጋይ ሀይሳ፤ እስራኤለ ግድዳ ባ እሻስ ታልእዳ ኦንካ ሄ አጩዋ ማሮ። ጎዳ ማሮተꬃይ አዋጀትዳ ግሾ፥ እስራኤለ ግድዳ ባ እሻስ ታልእዳ ባ ታልእያ ኦይቾፎ። ");
INSERT INTO gofe_vpl VALUES ("DT15_3","006_15_3","DEU","15","3","3","ሀራ ቢታ አሳስ ነ ታልእዳ አጩዋ ኤካናዉ ዳንዳኣሳ፥ ሽን ነ ኮቻስ ታልእዳባ ኡባ ማራ። ");
INSERT INTO gofe_vpl VALUES ("DT15_4","006_15_4","DEU","15","4","4","“ነ ላታና መላ ጎዳይ፥ ነ ፆሳይ ነዉ አቆ ኦꬅድ እምያ ቢታን፥ ጎዳይ ነና አንጃና ግሾ ነ ግዶን ማንቆይ ዴና። ");
INSERT INTO gofe_vpl VALUES ("DT15_5","006_15_5","DEU","15","5","5","ነ ጎዳስ ነ ፆሳስ ኪተትኮ፥ ታ ሀች ነና ኪትያ ኪታ ኡባ ናግኮ፥ ነ ፖሎ አንጀታና። ");
INSERT INTO gofe_vpl VALUES ("DT15_6","006_15_6","DEU","15","6","6","ጎዳይ፥ ነ ፆሳይ ነዉ ኦድዳይሳዳ ነና አንጃና፤ ዳሮ ካዎተꬃት ህንተፈ ታልአና፥ ሽን ህንተ እሱዋፈካ ታልኤከታ። ቃስ ነ ካዎተꬃታ ሃራና፥ ሽን እሶይካ ነና ሃረና። ");
INSERT INTO gofe_vpl VALUES ("DT15_7","006_15_7","DEU","15","7","7","“ጎዳይ፥ ነ ፆሳይ ነዉ እምያ ቢታን ደእያ ካታማታፐ እሱዋን ደእያ እስራኤለ አስ ማንቅድ በንትኮ፥ እያዉ ኡሎ ምኖፋ፤ ነ ኩሽያ ሺሻ ኤኮፋ። ");
INSERT INTO gofe_vpl VALUES ("DT15_8","006_15_8","DEU","15","8","8","ነ ኩሽያ እያዉ ብርሻ፤ እያ ኮሽያባ ታልአ። ");
INSERT INTO gofe_vpl VALUES ("DT15_9","006_15_9","DEU","15","9","9","“አጮ ማርያ ላፑንꬃ ላይꬅ ማትስ” ጋዳ፥ ማንቆ እስራኤለ አስ ታልኤ ድጎፋ፤ ሄሳ መላ ኢታ ቆፍ ነ ዎዛናን ገሎፖ። ነ እያዉ ታልኦና እፅን፥ እ ፆሳኮ ዬክኮ፥ ሄስ ነዉ ናጋራ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("DT15_10","006_15_10","DEU","15","10","10","ነ እያዉ ኬሀተꬃን እማ፤ ነ ዎዛናን አይስ እምያና ጋዳ ኡዘቶፋ። ሄሳ ነ ኦꬅኮ፥ ጎዳይ ነ ፆሳይ ነና ኦይክዳባን የꬍዳባን ኡባን አንጃና። ");
INSERT INTO gofe_vpl VALUES ("DT15_11","006_15_11","DEU","15","11","11","አዉደካ ግድን፥ ቢታ ቦላፈ ማንቆይ ꬋዮና ግሾ፥ ነ እስራኤለታስ፥ ማንቆታስነ መቶታንቾታስ ህንተ ኬሀ ግዳና መላ ኪታይስ። ");
INSERT INTO gofe_vpl VALUES ("DT15_12","006_15_12","DEU","15","12","12","አደ ግድን ማጫ ግድን፥ እስራኤለ አስ፥ አይለ ኦꬅድ ሻምኮ፥ እ ነዉ ኡሱፑን ላይꬅ ኦꬆ፤ ላፑንꬃ ላይꬃን አይለተꬃፈ ላአ ከዮ። ");
INSERT INTO gofe_vpl VALUES ("DT15_13","006_15_13","DEU","15","13","13","ነኒ አይለተꬃፈ እያ ከሳ የድያ ዎደ መላ ኩሸ የዶፋ። ");
INSERT INTO gofe_vpl VALUES ("DT15_14","006_15_14","DEU","15","14","14","ጎዳይ ነ ፆሳይ ነና አንጅዳይሳ መላ ነ መህያፐ፥ ሻልያፐነ ዎይነ ጉምኤꬃፈ ኤንታዉ ኬሀተꬃን እማ። ");
INSERT INTO gofe_vpl VALUES ("DT15_15","006_15_15","DEU","15","15","15","ነኒ ካሰ ግብፀ ቢታን አይለ ግድዳይሳነ ጎዳይ ነ ፆሳይ ነና ያፐ ዎዝዳይሳ ዶጎፓ። ታ ሀች ሀ ኪታ ነዉ እመይ ሄሳሳ። ");
INSERT INTO gofe_vpl VALUES ("DT15_16","006_15_16","DEU","15","16","16","ሽን ነ አይለይ ነናነ ነ ኬꬃ አሳ ዶስዳ ግሾነ ኔራ ደኦይ እያዉ ሎኦ ግድያ ግሾ፥ “ታኒ ነ ሶፐ ቢከ” ያግኮ፥ ");
INSERT INTO gofe_vpl VALUES ("DT15_17","006_15_17","DEU","15","17","17","እያ ፐንገ ኤፋዳ፥ ጎꬅ ኤካዳ፥ እያ ሀይꬃ ሉካ። ያትኮ፥ እ ነዉ መርናዉ አይለ ግዳና፤ ቃስ ማጫ አይለስካ ሄሳዳ ኦꬃ። ");
INSERT INTO gofe_vpl VALUES ("DT15_18","006_15_18","DEU","15","18","18","እያ ኔኒ አይለተꬃፈ ከሳዳ የድያ ዎደ ኔኒ ቆሄታስ ጋዳ ቆፖፋ። እ ሀ ኡሱፑን ላይꬃታ ግዶን አስ ኡነ ኦይሳፈ ዳኮ ዳሮ ነዉ ኦꬅስ። ሄሳ ግሾ፥ ኔኒ ኦꬅያባ ኡባን ጎዳይ፥ ነ ፆሳይ ነና አንጃና። ");
INSERT INTO gofe_vpl VALUES ("DT15_19","006_15_19","DEU","15","19","19","ነ መህያፐነ ነ ዶርሳ ዉድያፐ ባይራ የለትዳ አደ ኡባ ጎዳስ፥ ነ ፆሳስ ዱማያ። ነ ዱማይዳ መህያፐ ባይራ የለትዳ ቦራ ጎዮፓ፤ ነ ዶርሳ ዉድያፐ ባይራ የለትዳ ዶርሳ እክስያ ሜዶፓ። ");
INSERT INTO gofe_vpl VALUES ("DT15_20","006_15_20","DEU","15","20","20","ነነ ነ ሶ አሳይ ጎዳይ ዶርያ በሳን ጎዳ፥ ነ ፆሳ ስንꬃን ሄሳታ ላይꬃን ላይꬃን ማ። ");
INSERT INTO gofe_vpl VALUES ("DT15_21","006_15_21","DEU","15","21","21","ሽን ነ ያርሽያ መህያ ቦላ ቦርስያባይ በንትኮ፥ እ ዎበ ዎይኮ ቆቀ ዎይኮ ሀራ ኢታ ቦርስያባይ እያ ቦላ ደእኮ፥ ሄሳ ጎዳስ፥ ነ ፆሳስ ያርሾፋ። ");
INSERT INTO gofe_vpl VALUES ("DT15_22","006_15_22","DEU","15","22","22","ሄሳ ነ ደእያ ነ ካታማን ማ፤ ዎጋዳ ቱና ግዶና አስ ግድን ዎይኮ ቱና አስ ግድን ጋራነ ገንኤ አሾዳ ሞ። ");
INSERT INTO gofe_vpl VALUES ("DT15_23","006_15_23","DEU","15","23","23","ግዶሽን፥ ነ እያ ሱꬃ ሃꬃዳ ሳአን ጉሳፈ አትሽን፥ ሞፓ። ");
INSERT INTO gofe_vpl VALUES ("DT16_1","006_16_1","DEU","16","1","1","አቢባ አጌናን ጎዳ፥ ነ ፆሳ ፓስካ ባኣለ ቦንቻ፤ ጎዳይ፥ ነ ፆሳይ ነና አቢባ አጌናን ቃማ ግብፀፈ ከስስ። ");
INSERT INTO gofe_vpl VALUES ("DT16_2","006_16_2","DEU","16","2","2","ኔኒ ዶርሳፈነ መሄ ዉድያፐ ጎዳይ ባ ሱንꬃይ ፄገታና መላ ዶርዳ በሳን፥ ጎዳስ፥ ነ ፆሳስ፥ ፓስካ ያርሻ። ");
INSERT INTO gofe_vpl VALUES ("DT16_3","006_16_3","DEU","16","3","3","ሄ ያርሹዋ ነ ምያ ዎደ እርሾይ ገልዳ ኡይꬃራ ሞፓ። ኔኒ ግብፀ የዳዳ ኤሶን ከይያ ዎደ ኦꬅዳይሳዳ እርሾይ ገልቦና መቶ ኡይꬃ ላፑን ጋላስ ኩመꬅ ማ። ነ ደኦ ላይꬃ ኡባን ነ ግብፀፈ ከይዳ ጋላሳ ሀሳያና። ");
INSERT INTO gofe_vpl VALUES ("DT16_4","006_16_4","DEU","16","4","4","ነ ቢታ ኡባን ላፑን ጋላሳስ አይባ እርሾይ በንቶፎ። ቃስ ነ ኮይሮ ጋላስ ኦማርስ ያርሽዳ አሹዋፐ ዎንታስ አይብካ አቶፎ። ");
INSERT INTO gofe_vpl VALUES ("DT16_5","006_16_5","DEU","16","5","5","ነ ፓስካ ያርሹዋ ጎዳይ ነ ፆሳይ ነዉ እምያ ካታማ አዉንካ ጮ ሹኮፋ። ");
INSERT INTO gofe_vpl VALUES ("DT16_6","006_16_6","DEU","16","6","6","ጎዳይ ነ ፆሳይ ባ ሱንꬃይ ፄገታና መላ ዶርያ በሳን ነ ፓስካ ያርሹዋ ሹካ። ቃስ አው ዉልያ ዎደ ግብፀፈ ነ ከይዳ ግሾ ሄ ሳትያን ሹካ። ");
INSERT INTO gofe_vpl VALUES ("DT16_7","006_16_7","DEU","16","7","7","ጎዳይ፥ ነ ፆሳይ ዶርያ በሳን፥ ያን ካꬃዳ ማ፤ ያታዳ ሳእ ዎንትያ ዎደ ነ ሶ ሶ ባ። ");
INSERT INTO gofe_vpl VALUES ("DT16_8","006_16_8","DEU","16","8","8","ኡሱፑን ጋላስ ኩመꬅ እርሾይ ገልቦና ኡይꬃ ማ፤ ላፑንꬃ ጋላስ ጎዳ፥ ነ ፆሳ ጎይናናዉ ሺቃ፤ ሄ ጋላስ አይ ኦሶካ ኦꬆፋ። ");
INSERT INTO gofe_vpl VALUES ("DT16_9","006_16_9","DEU","16","9","9","ነ ካꬃ ጫካ ኦይክዳ ኮይሮ ዎድያፐ ዶማዳ፥ ላፑን ሳምንታ ኩመꬅ ታይባ። ");
INSERT INTO gofe_vpl VALUES ("DT16_10","006_16_10","DEU","16","10","10","ያታዳ፥ ጎዳይ፥ ነ ፆሳይ ነና አንጅዳይሳ መላ ነ፥ ነ ዶሳን እምያ እሙዋ ኤሀዳ፥ ጎዳ፥ ነ ፆሳ ሳምንታ ባኣለ ቦንቻ። ");
INSERT INTO gofe_vpl VALUES ("DT16_11","006_16_11","DEU","16","11","11","ሄሳን ኔኒ፥ ነ አደ ናይት፥ ነ ማጫ ናይት፥ ነ አደ አይለትነ ነ ማጫ አይለት፥ ነ ካታማን ደእያ ሌወት፥ በተ አሳይ፥ ይኦ ናይትነ ነ ግዶን ደእያ አምኤት ኡባይ፥ ጎዳይ፥ ነ ፆሳይ ባ ሱንꬃይ ፄገታና መላ ዶርያ በሳን ኡፋይትተ። ");
INSERT INTO gofe_vpl VALUES ("DT16_12","006_16_12","DEU","16","12","12","ኔኒ ግብፀ ቢታን አይለ ግድዳይሳ ሀሳያዳ ሀ ዎጋ ናጋ። ");
INSERT INTO gofe_vpl VALUES ("DT16_13","006_16_13","DEU","16","13","13","ነ ዉዱማፈ ነ ካꬃ፥ ዎይነ የꬍያ በሳፈ ነ ዎይንያ ሺሽዳፐ ጉየ፥ ላፑን ጋላስ ሻቃራ ባኣለ ቦንቻ። ");
INSERT INTO gofe_vpl VALUES ("DT16_14","006_16_14","DEU","16","14","14","ኔኒ፥ ነ አደ ናይትነ ማጫ ናይት፥ ነ አደ አይለትነ ማጫ አይለት፥ ነ ካታማን ደእያ ሌወት፥ በተ አሳይ፥ ይኦ ናይትነ አምኤት ኡባይ ሄ ባልያን ኡፋይትተ። ");
INSERT INTO gofe_vpl VALUES ("DT16_15","006_16_15","DEU","16","15","15","ጎዳይ ዶርያ በሳን ላፑን ጋላስ ጎዳ፥ ነ ፆሳ፥ ባኣለ ቦንቻ። ነ ኡፋይታና መላ ነ አይፍስዳባንነ ነ ኩሸ ኦሶ ኡባን ጎዳይ፥ ነ ፆሳይ ነና አንጃና። ");
INSERT INTO gofe_vpl VALUES ("DT16_16","006_16_16","DEU","16","16","16","ህንተ ቢታን ደእያ አደ ኡባይ ላይꬃን ሄꬑ ቶሆ፥ ኡይꬃ ባኣለ ዎደ፥ ሳምንታ ባኣለ ዎደነ ሻቃራ ባኣለ ዎደ ጎዳ፥ ህንተ ፆሳ ስንꬃን፥ እ ዶርያ በሳን በንቶ። ኤንቲ ጎዳ ስን ይሸ፥ መላ ኩሸ ዮፖ። ");
INSERT INTO gofe_vpl VALUES ("DT16_17","006_16_17","DEU","16","17","17","ጎዳይ፥ ነ ፆሳይ ነና አንጅዳይሳ መላ እሶይ እሶይ ባዉ ዳንዳኤይሳ መላ እሞ። ");
INSERT INTO gofe_vpl VALUES ("DT16_18","006_16_18","DEU","16","18","18","ጎዳይ፥ ህንተ ፆሳይ እምያ ካታማታን እስ እስ ኮቻስ ዳይናነ ሀላቃ ህንተዉ ሹምተ፤ ኤንቲ አሳስ ፅሎ ፕርዳ ፕርዶ። ");
INSERT INTO gofe_vpl VALUES ("DT16_19","006_16_19","DEU","16","19","19","ፅሎ ፕርዳ ዎቢሶፓ፤ ሶምኦ በአዳ ማዶፋ፤ ዎꬋፈ ኤኮፋ። ዎꬋፈይ ጭንጫታ አይፍያ ቆቅሴስ፥ ፅሎታ ቃላ ጌላዬስ። ");
INSERT INTO gofe_vpl VALUES ("DT16_20","006_16_20","DEU","16","20","20","ነ ደኦን ዳና ማላነ ጎዳይ ነ ፆሳይ ነዉ እምያ ቢታ ነ ላታና መላ ፅሎ ፕርዳ። ");
INSERT INTO gofe_vpl VALUES ("DT16_21","006_16_21","DEU","16","21","21","ኔኒ ጎዳ፥ ፆሳ ያርሾ በሳ ማታን አሼራ ኤቃ ምስልያ ኤሶፋ። ");
INSERT INTO gofe_vpl VALUES ("DT16_22","006_16_22","DEU","16","22","22","ህንተ ጎዳይ፥ ፆሳይ እፅያ ጎይኖ ሹቻ ቱሱ ነዉ ኤሶፋ። ");
INSERT INTO gofe_vpl VALUES ("DT17_1","006_17_1","DEU","17","1","1","ጎዳስ፥ ነ ፆሳስ፥ ቦርስያባይ ደእያ መሄ ዎይኮ ዶርሰ ያርሾ ኦꬃዳ ሺሾፓ፤ ሄስ ፆሳ ስንꬃን እፀትዳባ። ");
INSERT INTO gofe_vpl VALUES ("DT17_2","006_17_2","DEU","17","2","2","ጎዳይ፥ ነ ፆሳይ ነዉ እምያ ካታማታፐ አዉንካ አደ ዎይኮ ማጫ ግድን ጎዳ፥ ነ ፆሳ ስንꬃን ኢታባ ኦꬅኮነ እያ ጫቁዋ መንꬅድ በንትኮ፥ ");
INSERT INTO gofe_vpl VALUES ("DT17_3","006_17_3","DEU","17","3","3","ታ ኪታ አግድ፥ ሀራ ፆሳታ፥ አዋ ዎይኮ አጌና ዎይኮ ሳሎ ፆልንቶ ጎይንዳ አስ ደእኮ፥ ");
INSERT INTO gofe_vpl VALUES ("DT17_4","006_17_4","DEU","17","4","4","ሄሳ መላባ ህንተ ስእኮ፥ ሄ ኦዳ ምንꬅድ ፕልጋ። ህንተ ኮይን፥ ሄሳ መላ ቱናባይ እስራኤለ ግዶን ኦሰትዳይስ ቱማነ ጌሽ ግድኮ፥ ");
INSERT INTO gofe_vpl VALUES ("DT17_5","006_17_5","DEU","17","5","5","ሄ ኢታ ኦꬅዳ አድያ ዎይኮ ማጫስዉ ነ ካታማፐ ጋፃ ከሳዳ፥ ሹቻን ጫዳዳ ዎꬋ። ");
INSERT INTO gofe_vpl VALUES ("DT17_6","006_17_6","DEU","17","6","6","እስ አስ ናምኡ ዎይኮ ሄꬑ ማርክ ማርካቶና ደእሽን ሀይቆፎ፤ እስ አሳ ማርካን አይ አስካ ሀይቆፎ። ");
INSERT INTO gofe_vpl VALUES ("DT17_7","006_17_7","DEU","17","7","7","እያ ቦላ ማርካትዳ አሳት ኮይሮ እያ ሹቻን ጫዶ፤ ኤንታ ካልድ ሀንኮ አሳይ ጫዶ። ሄሳዳ ኦꬃዳ፥ ኢታ ነ ግዶፈ ድጋ። ");
INSERT INTO gofe_vpl VALUES ("DT17_8","006_17_8","DEU","17","8","8","ህንተ ስን ሺቅያ ሞቶይ ዴፆ ግድኮ፥ ሄስካ፥ ሸምፖ ዎꬎ፥ ሾቸ፥ ማዱንꬅ፥ ዱማ ዱማ ሞቶታ ጎዳይ፥ ነ ፆሳይ ዶርዳ በሳ ኤሀ። ");
INSERT INTO gofe_vpl VALUES ("DT17_9","006_17_9","DEU","17","9","9","ካህነ ግድዳ ሌወታኮነ ዳይናታኮ ሄ ሞቱዋ ሺሻ፤ ሄ ሞቱዋ ኤንቲ ፕርዶ። ");
INSERT INTO gofe_vpl VALUES ("DT17_10","006_17_10","DEU","17","10","10","ጎዳይ ዶርዳ በሳን ኤንቲ ፕርድዳይሳዳ ኦꬃ፤ ነ ኦꬃና መላ ኤንቲ ኪትያባ ኡባ አኬካዳ ኦꬃ። ");
INSERT INTO gofe_vpl VALUES ("DT17_11","006_17_11","DEU","17","11","11","ኤንቲ ነና ታማርስዳ ህግያዳነ ኤንቲ ኦድዳ ፕርዳዳ ኦꬃ፤ ኤንቲ ፕርድዳ ፕርዳፈ ኡሻች ዎይኮ ሀድርስ ጎፓ። ");
INSERT INTO gofe_vpl VALUES ("DT17_12","006_17_12","DEU","17","12","12","ጎዳስ፥ ነ ፆሳስ ኦꬅያ ዳይናስ ዎይኮ ካህንያስ ኪተቶና እፅያ አስ ደእኮ፥ ሄ ኡራይ ሀይቆ። ሄሳዳ ኦꬃዳ፥ ኢታ እስራኤለ ግዶፈ ድጋ። ");
INSERT INTO gofe_vpl VALUES ("DT17_13","006_17_13","DEU","17","13","13","አሳ ኡባይ ሄሳ ስእድ ያያና፤ ዛሪድ ሄሳ መላ ኢታ ኦꬅያ አስ ዴና። ");
INSERT INTO gofe_vpl VALUES ("DT17_14","006_17_14","DEU","17","14","14","ጎዳይ፥ ነ ፆሳይ ነዉ እምያ ቢታ ላታዳ፥ ያን ደኦ ዶምያ ዎደ፥ ነ ዩሾን ደእያ ካዎተꬃታዳ፥ “ኑካ ኑ ቦላ ካዎ ካዎꬃና” ያግኮ፥ ");
INSERT INTO gofe_vpl VALUES ("DT17_15","006_17_15","DEU","17","15","15","ነ ካዎꬃና ካዎይ ጎዳይ፥ ነ ፆሳይ ነዉ ዶርዳይሳ ግዳናዉ በሴስ። ሄስካ፥ ነ አሳ ግዶፈ ዶረትዳይሳ ግዶፐ አትሽን፥ ሀራ ቢታ አስ ነ ቦላ ካዎꬆፋ። ");
INSERT INTO gofe_vpl VALUES ("DT17_16","006_17_16","DEU","17","16","16","ጎዳይ፥ “ሄ ኦግያራ ግብፀ ስሞፕተ” ያግዳ ግሾ፥ ሄ ካዎይ ዳሮ ፓራ ሺሻናዉ በሰና፤ ባ አሳካ ፓራ ሻማና መላ ግብፀ የዶፎ። ");
INSERT INTO gofe_vpl VALUES ("DT17_17","006_17_17","DEU","17","17","17","እያ ዎዛና ባለꬆና መላ ካዎይ ዳሮ ማቾ ኤኮፎ፤ ዳሮ ዎርቃነ ብራ ሺሾፖ። ");
INSERT INTO gofe_vpl VALUES ("DT17_18","006_17_18","DEU","17","18","18","እ ባ አራታን ኡትያ ዎደ ሌወ ኮቸ ግድዳ ካህነት ናግያ ማፃፋፐ ሀ ህግያ ዱቅድ ባዉ ኤኮ። ");
INSERT INTO gofe_vpl VALUES ("DT17_19","006_17_19","DEU","17","19","19","እ ሀ ህግያ ቃላነ ዎጋ ናጎነ ፖሎ ኤርድ ጎዳስ፥ ባ ፆሳስ፥ ያሽ ታማራና መላ፥ ሀ ማፃፋይ እያራ ደኦ፤ እካ ሀ ማፃፋ ባ ደኦ ላይꬃ ኡባን ናባቦ። ");
INSERT INTO gofe_vpl VALUES ("DT17_20","006_17_20","DEU","17","20","20","እ ባ ዎዛናን፥ “ታኒ ታ ላገታፐ አꬋይስ” ግድ ባ እሻታ ቦላ ኦቶርተና። እካ ፆሳ ህግያፈ ሀድርስ ዎይኮ ኡሻች ጌና። እ ባ ካዎተꬃን አዱሳ ላይꬅ ካዎታና፤ እያ ናይት እስራኤለ ቢታን ዳሮ ላይꬅ ካዎታና። ");
INSERT INTO gofe_vpl VALUES ("DT18_1","006_18_1","DEU","18","1","1","ሌወ ኮቸ ግድዳ ካህነታስነ አትዳ ኤንታ ኮቻስ እስራኤለ ግዶን ላታ ቢት ባዋ። አሳይ ጎዳስ ሺሽያ ፁሳ ያርሾይ ኤንታ ግሾ ግድያ ግሾ እያ ምሸ ዳና። ");
INSERT INTO gofe_vpl VALUES ("DT18_2","006_18_2","DEU","18","2","2","ኤንታዉ ኤንታ እሻታ ግዶን ላት ዴና፤ ጎዳይ ኤንታዉ ግዳይሳዳ እ ኤንታ ላታ። ");
INSERT INTO gofe_vpl VALUES ("DT18_3","006_18_3","DEU","18","3","3","ኮርማ ዎይኮ ዶርሰ አሳይ ያርሾስ ሺሽዳይሳፈ ካህነታ ግሾይ ሀይሳ፤ ምሳይ፥ ጋጮይነ ኡሎ አሾይ ኤንታዉ እመቶ። ");
INSERT INTO gofe_vpl VALUES ("DT18_4","006_18_4","DEU","18","4","4","ነ ካꬃፈ፥ ዎይንያፐነ ዛይትያፐ ኮይሮ ጋክዳ አይፍያነ ነ ዶርሳ እክስያፐ ባይራ ካህነታስ እማ። ");
INSERT INTO gofe_vpl VALUES ("DT18_5","006_18_5","DEU","18","5","5","ሌወት ጎዳ ሱንꬃን መርናዉ ካህነ ግድድ ኦꬃና መላ ነ ኮቻ ግዶፈ ጎዳይ፥ ነ ፆሳይ ኤንታ ዶርስ። ");
INSERT INTO gofe_vpl VALUES ("DT18_6","006_18_6","DEU","18","6","6","እስ ሌወይ እስራኤለ ቢታን ደእያ እስ ካታማፐ ደንድድ፥ ጎዳይ ዶርያ በሳ ባናዉ ኮይኮ፥ ");
INSERT INTO gofe_vpl VALUES ("DT18_7","006_18_7","DEU","18","7","7","እ ብያ በሳን ደእያ ሌወት ጎዳ ስንꬃን ኤቅድ ኦይሳዳ እካ ጎዳ ባ ፆሳ ስንꬃን ኤቅድ ኦꬆ። ");
INSERT INTO gofe_vpl VALUES ("DT18_8","006_18_8","DEU","18","8","8","ባና ጋክያ ግሹዋ ኤክዳባ ግድኮካ፥ ካህነት ጎኤትያ ኡባ ኤንታራ ግና ሻከትድ ኤኮ። ");
INSERT INTO gofe_vpl VALUES ("DT18_9","006_18_9","DEU","18","9","9","ጎዳይ ነ ፆሳይ እምዳ ቢታ ነ ገልያ ዎደ ሄ ቢታን ደእያ አሳይ ኦꬅያ እፀትዳ ኦሶታ ኦꬆፋ። ");
INSERT INTO gofe_vpl VALUES ("DT18_10","006_18_10","DEU","18","10","10","ባ አደ ናኣ ዎይኮ ማጫ ናእዉ ያርሾስ ታማን ፁግያ ኦንካ ነ ግዶን በንቶፎ። ብት፥ ማራጨ በኤይ፥ ማሮተይ፥ ህግሸይ፥ ");
INSERT INTO gofe_vpl VALUES ("DT18_11","006_18_11","DEU","18","11","11","ሞይትለ በኤይ፥ ሀይቅዳ አሳ አያና ፄገይ፥ ዎይኮ ሀይቅዳ አሳ አያናራ ኦደተይ ነ ግዶን ደኦፖ። ");
INSERT INTO gofe_vpl VALUES ("DT18_12","006_18_12","DEU","18","12","12","ሄሳ መላባ ኦꬅያ ኦንካ ጎዳ ማታን እፀትዳ አስ። ኤንቲ ሄሳ መላ ቱና ኦꬅያ ግሾ፥ ጎዳይ ነ ፆሳይ ሄ ካዎተꬃታ ነ ስንꬃፈ ጎዳና። ");
INSERT INTO gofe_vpl VALUES ("DT18_13","006_18_13","DEU","18","13","13","ሽን ነኒ ጎዳ ነ ፆሳ ስንꬃን ቦረይ ባይናይሳ ግዳ። ");
INSERT INTO gofe_vpl VALUES ("DT18_14","006_18_14","DEU","18","14","14","ነኒ ላታናዉ ብያ ቢታን ደእያ ካዎተꬃት ሙሩነይሳታነ ብተይሳታ፤ ሽን ነ ሄሳ ኦꬆና መላ ጎዳይ ነ ፆሳይ ነና ድግስ። ");
INSERT INTO gofe_vpl VALUES ("DT18_15","006_18_15","DEU","18","15","15","ጎዳይ፥ ነ ፆሳይ ነ ኮቻ ግዶፈ ታ መላ ናበ ነዉ ደንꬃና። ነ እ ገይሳ ስአ። ");
INSERT INTO gofe_vpl VALUES ("DT18_16","006_18_16","DEU","18","16","16","ኮሬባ ዙማ ቦላ ነ ሺቅዳ ዎደ ጎዳ ነ ፆሳ ሀይሳዳ ያጋዳ ኦይቻዳሳ፤ “ታ ሀይቆና መላ ጎዳ፥ ታ ፆሳ ግርሳ ዛራዳ ስእከ፤ ሀ ዎልቃማ ታማ ዛራዳ በእከ” ያጋዳሳ። ");
INSERT INTO gofe_vpl VALUES ("DT18_17","006_18_17","DEU","18","17","17","ጎዳይ ታኮ፥ “ኤንቲ ቱማ ግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("DT18_18","006_18_18","DEU","18","18","18","ታ ኤንታ ኮቻ ግዶፈ ነ መላ ናበ ኤንታዉ ደንꬃና፤ ታኒ ታ ቃላ እያ ዶናን ዎꬃና፤ እ፥ ታ ኪትያ ኡባ ኤንታዉ ኦዳና። ");
INSERT INTO gofe_vpl VALUES ("DT18_19","006_18_19","DEU","18","19","19","እ ታ ሱንꬃን ኦድያ ታ ቃላ ስኦና ኦናካ ታ ኦይቻና። ");
INSERT INTO gofe_vpl VALUES ("DT18_20","006_18_20","DEU","18","20","20","ሽን ታ ኪቶናባ ታ ሱንꬃን ኦድያ ዎይኮ ሀራ ፆሳታ ሱንꬃን ኦድያ ሄ ናበይ ሀይቆ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("DT18_21","006_18_21","DEU","18","21","21","ኔኒ፥ “ናበይ ኦድያ ቃላይ ፆሳፈ ግዶናይሳ ታ አይብን ሻካዳ ኤራኔ?” ያግኮ፥ ");
INSERT INTO gofe_vpl VALUES ("DT18_22","006_18_22","DEU","18","22","22","ሄ ናበይ ጎዳ ሱንꬃን ኦድዳ ቃላይ ፖለቶና እፅኮ፥ ሄስ ጎዳይ ኦድቦና ቃላ ግደይሳ ኤራሳ። ሄ ናበይ ኦድያ ቃላይ ዎርዶ ግድዳ ግሾ እያ ያዮፋ። ");
INSERT INTO gofe_vpl VALUES ("DT19_1","006_19_1","DEU","19","1","1","ጎዳይ፥ ነ ፆሳይ ነዉ እምያ ቢታን ደእያ ካዎተꬃታ ꬋይስያ ዎደነ ነ ኤንታ ጎዳዳ፥ ኤንታ ካታማታንነ ኤንታ ኬꬃታን ዱሱ ዶምያ ዎደ፥ ");
INSERT INTO gofe_vpl VALUES ("DT19_2","006_19_2","DEU","19","2","2","ጎዳይ፥ ነ ፆሳይ ላታ ኦꬅድ እምያ ቢታን ደእያ ካታማታፐ ሄꬑ ካታማታ ነዉ ዱማያ። ");
INSERT INTO gofe_vpl VALUES ("DT19_3","006_19_3","DEU","19","3","3","ጎዳይ፥ ነ ፆሳይ ነዉ ላታ ኦꬅድ እምያ ቢታ ሄꬓ ከሳዳ ሻካ። ያታዳ አሰ ዎꬍዳ ኦንካ ሄ ካታማታኮ ኤሶን ባቃትድ አታና መላ ኦገ ጊግሳ። ");
INSERT INTO gofe_vpl VALUES ("DT19_4","006_19_4","DEU","19","4","4","እስ አስ ካሰ ሞርከተꬅ ባይና ደእሽን፥ ኤሮና ባ ላግያ ዎꬍኮ፥ እ ሄ ካታማታፐ እሱዋኮ ባቃትድ ባ ሸምፑዋ አሾ። ");
INSERT INTO gofe_vpl VALUES ("DT19_5","006_19_5","DEU","19","5","5","ናምኡ አሳት ምꬅ ቃንፃናዉ ዎራ ብን፥ እሶይ ምꬃ ቃንፅሽን፥ ምꬃፈ ካልታ አይፈይ ኮለትድ ሀንኩዋ ዎꬍኮ፥ ዎꬍዳ ኡራይ ሀ ሄꬑ ካታማታፐ እሱዋኮ ባቃትድ፥ ባ ሸምፑዋ አሾ። ");
INSERT INTO gofe_vpl VALUES ("DT19_6","006_19_6","DEU","19","6","6","ባቃትድ አትያ ካታማይ እስን ፃላላ ግድኮ፥ ዎꬍዳ ኡራይ ኤሶን ዎፅድ ጋካናዉ ኦገይ አዱሰ ግድኮ፥ ሱꬅ ዛርያ ማታ ዳቦይ ጎድ ጋክድ፥ ይሎን ደንድድ ሀይቃናዉ በሶና ኡራ ዎꬋናዉ ዳንዳኤስ። እ ባ ላግያ ዎꬍዳይ ካሰ ሞርከተꬅ ደእያ ግሾ ግደና። ");
INSERT INTO gofe_vpl VALUES ("DT19_7","006_19_7","DEU","19","7","7","ህንተ ሄꬑ ካታማታ ዱማይ ዎꬃና መላ ታ ነና ኪተይ ሄሳሳ። ");
INSERT INTO gofe_vpl VALUES ("DT19_8","006_19_8","DEU","19","8","8","ጎዳይ፥ ነ ፆሳይ ካሰ ነ ማይዛታስ ጫቅዳይሳዳ ነ ዛዋ ዳልግስኮነ ነ ማይዛታስ እማና ግዳ ቢታ ኡባ ነዉ እምኮ፥ ");
INSERT INTO gofe_vpl VALUES ("DT19_9","006_19_9","DEU","19","9","9","ሀ ሄꬑ ካታማታ ቦላ ሀራ ሄꬑ ካታማታ ጉጃ። ሀች ታ ነና ኪትያ ኡባ ነ ፖልኮ፥ ጎዳ ነ ፆሳ ዶስኮነ እ ነና ታማርስዳ ኦግያን ምናዳ ደእኮ፥ ሀ ቢታይ ነዉ እመታና። ");
INSERT INTO gofe_vpl VALUES ("DT19_10","006_19_10","DEU","19","10","10","ሄሳ ነ ኦꬅኮ፥ ጎዳይ፥ ነ ፆሳይ ላታ ኦꬅድ ነዉ እምያ ቢታን ፅሎ አሳ ሱꬅ ጉከና፤ ነካ ሱꬅ ጉሳዳ ኦይሸታካ። ");
INSERT INTO gofe_vpl VALUES ("DT19_11","006_19_11","DEU","19","11","11","ሽን እስ አስ ባ ሾሩዋ እፅድ፥ ቆሰት ናግድ እያ ዎꬍድ፥ ሀ ካታማታፐ እሱዋኮ ባቃትኮ፥ ");
INSERT INTO gofe_vpl VALUES ("DT19_12","006_19_12","DEU","19","12","12","እ ደእያ ካታማን ደእያ ጭማት እ ባቃትዳ ካታማፐ ኤህስድ፥ ኩሸ ዛራናዉ ኮየይሳስ አꬅድ እሞ። ");
INSERT INTO gofe_vpl VALUES ("DT19_13","006_19_13","DEU","19","13","13","እያዉ አይባካ ቃቶፋ፤ ነዉ ኡባባይ እንጀታና መላ፥ ፅሎ ሱꬅ ጉስዳ ኡራ እስራኤለ ግዶፈ ድጋ። ");
INSERT INTO gofe_vpl VALUES ("DT19_14","006_19_14","DEU","19","14","14","ጎዳይ ነ ፆሳይ ነኒ ላታና መላ እምያ ቢታን፥ በን አሳይ ኤስዳ ጋደ ዛዋ ሾዶፋ። ");
INSERT INTO gofe_vpl VALUES ("DT19_15","006_19_15","DEU","19","15","15","እስ አስ ባላ ኦꬃናዉ እስ ማርካ ፃላል ግደና። ናምኡ ዎይኮ ሄꬑ ማርክ ማርካትን፥ ሄ ሞቶይ ፕርደታናዉ ኮሼስ። ");
INSERT INTO gofe_vpl VALUES ("DT19_16","006_19_16","DEU","19","16","16","እስ አስ ሀራ አስ ዎርዶን ሞትኮ፥ ");
INSERT INTO gofe_vpl VALUES ("DT19_17","006_19_17","DEU","19","17","17","ሞተይስነ ሞተተይስ ናምአይ ጎዳ ስንꬃን፥ ካህነታ ስንꬃንነ ዳይናታ ስንꬃን ኤቆ። ");
INSERT INTO gofe_vpl VALUES ("DT19_18","006_19_18","DEU","19","18","18","ዳይናት ሄ ኦዳ ምንꬅድ ፕልጎ፤ ሄ ኡራይ ባ እሻ ዎርዶን ሞተይስ ቱማ ግድኮ፥ ");
INSERT INTO gofe_vpl VALUES ("DT19_19","006_19_19","DEU","19","19","19","ሄ ሞተተይስ ኤካናዉ ደእያ ሴራ ሞተይስ ሴረቶ። ሄሳዳ ኦꬃዳ፥ ኢታ ኡራ ነ ግዶፈ ድጋ። ");
INSERT INTO gofe_vpl VALUES ("DT19_20","006_19_20","DEU","19","20","20","ሄሳዳ ኦꬅኮ፥ ሀራ አሳይ ሄሳ ስእድ ያያና፤ ሄሳ መላ ኢታ ኦሶይ ዛሪድ ኦሰተና። ");
INSERT INTO gofe_vpl VALUES ("DT19_21","006_19_21","DEU","19","21","21","ሄሳ መላ ኢታ ኦሶ ኦꬅዳይሳስ ቃቶፋ፤ ሸምፖ ግሾ ሸምፖ፤ አይፈ ግሾ አይፈ፤ አቻ ግሾ አቸ፤ ኩሸ ግሾ ኩሸ፤ ገዳ ግሾ ገዳ መንꬃ። ");
INSERT INTO gofe_vpl VALUES ("DT20_1","006_20_1","DEU","20","1","1","ነኒ ሞርከታራ ኦለታናዉ ብያ ዎደ፥ ኤንታ ፓራት፥ ፓራ ጋረትነ ኤንታ ኦላንቾት ኔፐ ዳርን በአዳ፥ ኤንታዉ ያዮፋ፤ ነና ግብፀፈ ከስዳ ጎዳይ፥ ነ ፆሳይ ኔራ ደኤስ። ");
INSERT INTO gofe_vpl VALUES ("DT20_2","006_20_2","DEU","20","2","2","ህንተ ኦላ ዶማናፐ ኮይሮ፥ ካህነይ ኦላንቾታ ስን አꬍድ ሀይሳዳ ያጎ፤ ");
INSERT INTO gofe_vpl VALUES ("DT20_3","006_20_3","DEU","20","3","3","“እስራኤለ አሳዉ፥ ስእተ፤ ሀች ህንተ፥ ህንተ ሞርከታራ ኦለታናዉ ሀኔታ። ህዛ ህንተ ዎዛናይ ዳጋሞፎ፤ ያዮፍተ፤ ኤንታ ስንꬃን ኮኮሮፕተ፤ ህርጎፍተ። ");
INSERT INTO gofe_vpl VALUES ("DT20_4","006_20_4","DEU","20","4","4","ጎዳይ፥ ህንተ ፆሳይ ህንተራ ብያ ግሾ፥ ህንተ ሞርከታ ኦልድ፥ ህንተዉ ፆኖ እማና” ያጎ። ");
INSERT INTO gofe_vpl VALUES ("DT20_5","006_20_5","DEU","20","5","5","ቶራ ሞጮናት ኦላንቾታኮ፥ “ኦራꬃ ኬꬅ ኬፅድ ገልቦና አስ ደእኮ፥ እ ኦላን ሀይቅን፥ ሀራ አስ እያ ኬꬃን ገሎና መላ እ ሶ ስሞ። ");
INSERT INTO gofe_vpl VALUES ("DT20_6","006_20_6","DEU","20","6","6","ዎይኮ ዎይነ ቶክድ፥ አይፈ ሞና አስ ደእኮ፥ እ ኦላን ሀይቅን፥ ሀራ አስ እያ ዎይነ አይፍያ ሞና መላ እ ሶ ስሞ። ");
INSERT INTO gofe_vpl VALUES ("DT20_7","006_20_7","DEU","20","7","7","ማቾ ኦይችድ ኤክቦና አስ ደእኮ፥ እ ኦላን ሀይቅን፥ ሀራ አስ እያ ማችዉ ኤኮና መላ እ ሶ ስሞ” ያጎ። ");
INSERT INTO gofe_vpl VALUES ("DT20_8","006_20_8","DEU","20","8","8","ቶራ ሞጮናት ጉጅድ ሀይሳዳ ያጎ፤ “ሀ አሳ ግዶን ያያነ ህርግያ ኦንካ ደእኮ፥ እ ባ ላገታ ዎዛና ያሻን ትልእሳናፐ ሶ ስሞ” ያጎ። ");
INSERT INTO gofe_vpl VALUES ("DT20_9","006_20_9","DEU","20","9","9","ቶራ ሞጮናት ሄሳ አሳስ ኦድ ዉርስያ ዎደ ጩጋስ ጩጋስ ቶራ ሞጮናታ ዶሮ። ");
INSERT INTO gofe_vpl VALUES ("DT20_10","006_20_10","DEU","20","10","10","እስ ካታማ ኦላናዉ ባዳ ነ እያኮ ማትያ ዎደ፥ ኮይሮትድ ሳሮራ ኤንቲ ኩሸ እማና መላ ኦይቻ። ");
INSERT INTO gofe_vpl VALUES ("DT20_11","006_20_11","DEU","20","11","11","ኤንቲ ሳሮራ ባንታ ኩሽያ እምድ፥ ባንታ ግምበ ፐንግያ ዶይድ ነና ገልስኮ፥ ሄ ካታማን ደእያ አሳ ኡባይ ነዉ ዴፆ ኦሶ ኦꬅድ ሀጋዞ። ");
INSERT INTO gofe_vpl VALUES ("DT20_12","006_20_12","DEU","20","12","12","ሄ ካታማ አሳይ ነዉ ሳሮራ ኩሸ እሞና እፅድ፥ ኦላስ ጊገትኮ፥ ነ ሄ ካታማ ዩሹዋ ተቃ። ");
INSERT INTO gofe_vpl VALUES ("DT20_13","006_20_13","DEU","20","13","13","ጎዳይ፥ ነ ፆሳይ ኤንታ ነዉ አꬅድ እምያ ዎደ ሄ ካታማን ደእያ አደ ኡባ ማሻን ዉርሳ። ");
INSERT INTO gofe_vpl VALUES ("DT20_14","006_20_14","DEU","20","14","14","ግዶሽን፥ ማጫሳ፥ ናይታ፥ መህያነ ካታማን ደእያ ኡባባ ነዉ ድአ። ጎዳይ፥ ነ ፆሳይ ነዉ እምያ ነ ሞርከታ ሻሉዋ ጎኤታ። ");
INSERT INTO gofe_vpl VALUES ("DT20_15","006_20_15","DEU","20","15","15","ነ ደእያ በሳፈ ሃክድ ደእያ ካታማታ ነ ኦይክያ ዎደ ሄሳዳ ኦꬃ። ");
INSERT INTO gofe_vpl VALUES ("DT20_16","006_20_16","DEU","20","16","16","ሽን ጎዳይ፥ ነ ፆሳይ ነዉ ላታ ኦꬅድ እምያ ቢታን ሸምፖራ ደእያባ እሱዋካ አሾና ዎꬋ። ");
INSERT INTO gofe_vpl VALUES ("DT20_17","006_20_17","DEU","20","17","17","ጎዳይ፥ ነ ፆሳይ ኪትዳይሳዳ ህተታ፥ አሞረታ፥ ካናነታ፥ ፓርዘታ፥ ህወታነ ያቡሰታ ዉርሳዳ ዎꬋ። ");
INSERT INTO gofe_vpl VALUES ("DT20_18","006_20_18","DEU","20","18","18","ሄስ ሀኖና እፅኮ፥ ኤንቲ ባንታ ፆሳታ ጎይንሸ ኦꬅያ እፀትዳ ኦሶታ ህንተ ኦꬃና መላ ህንተና ታማርስድ፥ ጎዳ ህንተ ፆሳ ቦላ ህንተ ናጋራ ኦꬃና መላ ደንꬃና። ");
INSERT INTO gofe_vpl VALUES ("DT20_19","006_20_19","DEU","20","19","19","እስ ካታማ ኦይካናዉ ዩሹዋ ነ ተቃዳ፥ ዳሮ ጋላስ ኦለታሸ ጋምእያ ዎደ፥ እያን ደእያ አይፈ እምያ ምꬃ አይፍያ ማፐ አትሽን፥ ቃንፆፋ። ነ ዩሹዋ ተቅድ ኦለይ አሰፐ አትሽን፥ ደንባን ደእያ ምꬃ ግደና። ");
INSERT INTO gofe_vpl VALUES ("DT20_20","006_20_20","DEU","20","20","20","ግዶሽን፥ ነ አይፈ እሞና ሀራ ምꬃታ ቃንፃዳ፥ ኔራ ኦለትያ ካታማይ ኩንዳና ጋካናዉ ያን ሚፃ ኬፃ። ");
INSERT INTO gofe_vpl VALUES ("DT21_1","006_21_1","DEU","21","1","1","ነ ላታና መላ ጎዳይ፥ ነ ፆሳይ ነዉ እምያ ቢታን፥ ኦን ዎꬍዳኮ ኤረቶና አህ ኩንድድ በንትኮ፥ ");
INSERT INTO gofe_vpl VALUES ("DT21_2","006_21_2","DEU","21","2","2","ህንተ ዳይናትነ ጭማት ብድ፥ አሀይ ኩንድዳ በሳፈ ማታ ካታማታ ጋካናዉ ደእያ ሃሆተꬃ ዋꬎ። ");
INSERT INTO gofe_vpl VALUES ("DT21_3","006_21_3","DEU","21","3","3","ሄሳፈ ጉየ፥ አሀይ ኩንድዳ በሳስ ማትያ ካታማ ጭማት፥ ዋታቦናነ ሞርገን ቃምባር ዎꬍቦና ኡስ ኤኮ። ");
INSERT INTO gofe_vpl VALUES ("DT21_4","006_21_4","DEU","21","4","4","እዮ ጎግያ ሃꬅ ደእያ ጎየትድ ኤሮናነ ዘረትድ ኤሮና ዛንጋራ ኤፍድ፥ ሄ ኡሴ ቆꬍያ ምርቅድ መንꬆ። ");
INSERT INTO gofe_vpl VALUES ("DT21_5","006_21_5","DEU","21","5","5","ሄሳ መላ ቆሁዋነ ኦሻ ሻክድ ፕርዳናዉ ጎዳይ፥ ህንተ ፆሳይ ባ ስንꬃን ኦꬃና መላነ ባ ሱንꬃን አንጃና መላ ኤንታ ዶርዳ ግሾ፥ ሌወ ኮቸ ግድዳ ካህነት ሄ በሳ ቦ። ");
INSERT INTO gofe_vpl VALUES ("DT21_6","006_21_6","DEU","21","6","6","ሄሳፈ ጉየ፥ አሀይ ኩንድዳ በሳስ ማትያ ካታማ ጭማት ዛንጋራን ቆ ምርቅድ ዎꬍዳ ኡሴ ቦላ ባንታ ኩሽያ ሜጨትድ፥ ");
INSERT INTO gofe_vpl VALUES ("DT21_7","006_21_7","DEU","21","7","7","“ኑ ኩሸይ ሀ ሱꬃ ጉስቤና፤ ኑ አይፈይ ሄሳ በእቤና። ");
INSERT INTO gofe_vpl VALUES ("DT21_8","006_21_8","DEU","21","8","8","አቤት ጎዳዉ፥ ኔኒ ዎዝዳ ነ አሳ፥ እስራኤለ ማራ፤ ሀ ፅሎ ሱꬃ ነ አሳ ቦላ ናቆ ኦꬃዳ ታይቦፓ። ሀ ፅሎ ሱꬃ ግሾ ኑ ናጋራይ አቶ ጋ” ያጎ። ");
INSERT INTO gofe_vpl VALUES ("DT21_9","006_21_9","DEU","21","9","9","ነኒ ጎዳ አይፍያ ስንꬃን ሄሳዳ ኦꬃዳ፥ ፅሎ ሱꬃይ ጉክዳ ናጋራ ነ ግዶፈ ድጋ። ");
INSERT INTO gofe_vpl VALUES ("DT21_10","006_21_10","DEU","21","10","10","ነ ሞርከታራ ነ ኦለታናዉ ከይን፥ ጎዳይ፥ ነ ፆሳይ ኤንታ ነ ኩሸን አꬅድ እምን፥ ኤንታ ድእያ ዎደ፥ ");
INSERT INTO gofe_vpl VALUES ("DT21_11","006_21_11","DEU","21","11","11","ድኤትዳ አሳ ግዶን እስ ማላ ሎኦ ማጫስ በአዳ፥ እዉ ምሸታዳ ማቻናዉ ኮይኮ፥ ");
INSERT INTO gofe_vpl VALUES ("DT21_12","006_21_12","DEU","21","12","12","እዮ ነ ሶ ኤሀ። እ ሁጵያ ሜዳ፤ እ ፁጉንꬃ ጭጋ፤ ");
INSERT INTO gofe_vpl VALUES ("DT21_13","006_21_13","DEU","21","13","13","ድኤትያ ዎደ ደእያ ማኡዋ ላማዳ፥ እስ አጌና ነ ሶን ኡታዳ፥ ባ አዋስነ ባ አየስ ካዮቶ። ሄሳፈ ጉየ፥ እዮ ማቻ። ");
INSERT INTO gofe_vpl VALUES ("DT21_14","006_21_14","DEU","21","14","14","ያታ ስማዳ፥ ኢራ ዱሳይ ነና ኡፋይሶና እፅኮ፥ እያ ባ ኮይዳ ሶ ባና መላ እዮ የዳ። ኔኒ እዮ ማቾ ኦꬃዳ ኢራ እስፈ አቅዳ ግሾ፥ እዮ ሚሸን ባይዛናዉ ዎይኮ አይለ ኦꬃናዉ በሰና። ");
INSERT INTO gofe_vpl VALUES ("DT21_15","006_21_15","DEU","21","15","15","እስ አሳስ እ ዶስያነ ዶሶና ናምኡ ማቸት ደእኮ፥ ሄ ናምአይካ እያዉ አደ ናአ የልኮ፥ ባይራይ እ ዶሶና ማቸፔ የለትዳባ ግድኮ፥ ");
INSERT INTO gofe_vpl VALUES ("DT21_16","006_21_16","DEU","21","16","16","እ ባ ናይታ ባ ሻሉዋ ላትስያ ዎደ፥ እ ዶሶናርፐ የለትዳ ባይራይ ደእሽን፥ እ ዶስያርፐ የለትዳ ካሉዋ ባይራያናዉ በሰና። ");
INSERT INTO gofe_vpl VALUES ("DT21_17","006_21_17","DEU","21","17","17","ሀራ ናይታስ እመይሳፈ እያዉ ናምኡ ኩሸ አꬅድ እምድ እ ዶሶናር ናአይ ባይራ ግደይሳ ኤርሳናዉ በሴስ። ሄ ናአይ እያዉ ኩሸ ቶሆ ጳልቅዳ ባይራ ግድያ ግሾ፥ ባይራተꬃ እ ኤካናዉ በሴስ። ");
INSERT INTO gofe_vpl VALUES ("DT21_18","006_21_18","DEU","21","18","18","አዋስነ አየስ ኪተቶና እፅዳ፥ ኤንቲ ሴርንካ ስሞና፥ ዎዛና ሙመነ ማካላንቾ ግድዳ ናእ ደእኮ፥ ");
INSERT INTO gofe_vpl VALUES ("DT21_19","006_21_19","DEU","21","19","19","አዋይነ አይያ ሄ ካታማ ፐንገን ደእያ ጭማታኮ እያ ኤሆ። ");
INSERT INTO gofe_vpl VALUES ("DT21_20","006_21_20","DEU","21","20","20","ኤንቲ ጭማታኮ፥ “ሀይስ ኑ ናአይ ዎዛና ሙመነ ማካላንቾ፤ እ ኑስ ኪተተና፤ እ ያራምባነ ኡሻንቾ” ያግድ ኦዶ። ");
INSERT INTO gofe_vpl VALUES ("DT21_21","006_21_21","DEU","21","21","21","ሄሳፈ ጉየ፥ ሄ ካታማን ደእያ አደ ኡባይ እያ ሹቻን ጫድድ ዎꬎ። ሄሳዳ ኦꬅድ ህንተ ግዶፈ ኢታ ኡራ ꬋይስተ፤ እስራኤለ ኡባይ ሄሳ ስእድ ያያና። ");
INSERT INTO gofe_vpl VALUES ("DT21_22","006_21_22","DEU","21","22","22","እስ አስ ሀይቆ ፕርድስያ ባላ ኦꬅኮ፥ ነ እያ ምꬃ ቦላ ካቃዳ ዎꬍኮ፥ ");
INSERT INTO gofe_vpl VALUES ("DT21_23","006_21_23","DEU","21","23","23","ሄ ምꬃ ቦላ እያ አሀይ አቆፖ፤ እያ ሄ ጋላስ ሞጋ። ምꬃ ቦላ ካቀትድ ሀይቅያ ኦንካ ፆሳን ባደትዳይሳ። ጎዳይ፥ ነ ፆሳይ ነዉ ላታ ኦꬅድ እምያ ነ ቢታ ቱንሶፓ። ");
INSERT INTO gofe_vpl VALUES ("DT22_1","006_22_1","DEU","22","1","1","እስራኤለ አሳ ቦር ዎይኮ ዶርስ ꬋይድ ብሽን ደምኮ አጋ አꬎፋ፤ ላጋ ኤሀዳ እያ ጎዳስ እማ። ");
INSERT INTO gofe_vpl VALUES ("DT22_2","006_22_2","DEU","22","2","2","ሄ መህያ ጎዳይ ነ ሄራ አስ ግዶና እፅኮ ዎይኮ እያ ጎዳይ ኦነኮ ነ ኤሮና እፅኮ፥ እያ ጎዳይ ኮይሸ ያና ጋካናዉ ነ ሶ ኤፋ፤ እ ኮይሸ ዪኮ እያዉ እማ። ");
INSERT INTO gofe_vpl VALUES ("DT22_3","006_22_3","DEU","22","3","3","ሄሳዳ ሀረ ዎይኮ ማኦ ዎይኮ አይባካ ꬋይዳባ ደምኮ፥ ሄሳዳ ኦꬃ። ");
INSERT INTO gofe_vpl VALUES ("DT22_4","006_22_4","DEU","22","4","4","እስራኤለ አሳ ሀረይ ዎይኮ ቦር ኦገን ኩንድን በእኮ፥ ማዳዳ ደንꬃፈ አትሽን፥ አጋዳ አꬎፋ። ");
INSERT INTO gofe_vpl VALUES ("DT22_5","006_22_5","DEU","22","5","5","ማጫስ አደ ማኦ ማኦፎ፤ አደይካ ማጫሳ ማኦ ማኦፎ። ሄሳ መላባ ኦꬅያ ኦናካ ጎዳይ፥ ህንተ ፆሳይ እፄስ። ");
INSERT INTO gofe_vpl VALUES ("DT22_6","006_22_6","DEU","22","6","6","ነ ኦገ ብሽን፥ ምꬃ ቦላ ግድን፥ ሳአን ባ ናኣ ዎይኮ ባ ጱጱልያ ሀጵዳ ካፎ ደምኮ፥ እዮ፥ እ ናይታራ ኦይካዳ ነ ሶ ኤፎፓ። ");
INSERT INTO gofe_vpl VALUES ("DT22_7","006_22_7","DEU","22","7","7","ናይታ ኤፋናዉ ዳንዳኣሳ፤ ሽን አይዉ ባና መላ የዳ አጋ። ሄሳዳ ኦꬅኮ፥ ኔኒ ዱረታዳ አዱሳ ላይꬅ ዳና። ");
INSERT INTO gofe_vpl VALUES ("DT22_8","006_22_8","DEU","22","8","8","ኦራꬃ ኬꬅ ኬፅያ ዎደ ካራፐ አስ ኩንድ ሀይቅን ነ ኦይሸቶና መላ ኬꬃ ቦላ ካተ ጊግሳ። ");
INSERT INTO gofe_vpl VALUES ("DT22_9","006_22_9","DEU","22","9","9","ነ ዎይነ ጋደን ናምኡ ቆሞ ካꬅ ዘሮፓ፤ ሄሳዳ ኦꬅኮ፥ ነ ዘርዳ ካꬃይነ ዎይነይ ናምአይካ ኢታና። ");
INSERT INTO gofe_vpl VALUES ("DT22_10","006_22_10","DEU","22","10","10","ቦርነ ሀረ እስፈ ዋፃዳ ጎዮፓ። ");
INSERT INTO gofe_vpl VALUES ("DT22_11","006_22_11","DEU","22","11","11","ሱፈፐነ ሊኖፐ ኦሰትዳ ማኦ ማኦፋ። ");
INSERT INTO gofe_vpl VALUES ("DT22_12","006_22_12","DEU","22","12","12","ነ ማእያ ማኦይ ኦይዱ ባጋራ ማጫር ደእያባ ግዶ። ");
INSERT INTO gofe_vpl VALUES ("DT22_13","006_22_13","DEU","22","13","13","እስ አስ ማቾ ኤክ ስሚድ እዮ ዶሶና እፅድ፥ ");
INSERT INTO gofe_vpl VALUES ("DT22_14","006_22_14","DEU","22","14","14","“ሀ ማችው ታ ኤክያ ዎደ ኩመꬅ ግዱኩ” ያግድ እዮ ኢስድ ኦደትኮ፥ ");
INSERT INTO gofe_vpl VALUES ("DT22_15","006_22_15","DEU","22","15","15","ናኤ አዋይነ ናኤ አይያ እ ጌላኦተꬃ ማላ ኤፍድ፥ ካታማ ፐንገን ደእያ ጭማታ በሶ። ");
INSERT INTO gofe_vpl VALUES ("DT22_16","006_22_16","DEU","22","16","16","ናኤ አዋይ ጭማታስ ሀይሳዳ ያግድ ኦዶ፤ “ታኒ ታ ናእዉ ሀ ኡራስ ማቾ ኦꬃዳ እማስ፥ ሽን እዮ እፅስ። ");
INSERT INTO gofe_vpl VALUES ("DT22_17","006_22_17","DEU","22","17","17","እ፥ ‘ነ ናእያ ኩመꬅ ግዱኩ’ ያግድ እዮ ኢስድ ኦድስ። ግዶሽን፥ ‘ታ ናኤ ጌላኦተꬃ ማላ ሀይሳ በእተ’ ” ያግድ፥ እ ጌላኦተꬃ ኤርስያ ጫርቅያ በሶ። ");
INSERT INTO gofe_vpl VALUES ("DT22_18","006_22_18","DEU","22","18","18","ያትኮ፥ ሄ ካታማ ጭማት እያ ጋራፎ። ");
INSERT INTO gofe_vpl VALUES ("DT22_19","006_22_19","DEU","22","19","19","እ እስራኤለ ጌላኤ ሱንꬃ ኢስዳ ግሾ፥ ጭማት እያ ፄቱ ብራ ሳንትመ አጭስድ፥ ናኤ አዋስ እሞ። ናእያ እያዉ ማቾ ግዳዳ ደኦ፤ ባ ደኦ ላይꬃ ኡባን እዮ የዳናዉ በሰና። ");
INSERT INTO gofe_vpl VALUES ("DT22_20","006_22_20","DEU","22","20","20","እያ ሞቶይ ቱማ ግድድ፥ ናእያ ኩመꬅ ግዶና እፅኮ፥ ");
INSERT INTO gofe_vpl VALUES ("DT22_21","006_22_21","DEU","22","21","21","እያ ባ አዋ ሶን ደአሸ ላይማትዳ ግሾ፥ ናእዉ እ አዋ ካረ ኤህድ፥ ሄ ካታማ አደት እዮ ሹቻን ጫድድ ዎꬎ። እስራኤለ ግዶን እያ ቦርሶባ ኦꬃሱ፤ ሄሳዳ ኦꬃዳ ነ ግዶፈ ኢታ ድጋ። ");
INSERT INTO gofe_vpl VALUES ("DT22_22","006_22_22","DEU","22","22","22","እስ አስ ሀራ አሳ ማችራ ላይማትሸ ኦይከትኮ፥ እነ እያራ ላይማትዳ ማጫስያ ሀይቆ። ሄሳዳ ኦꬃዳ ነ ግዶፈ ኢታ ድጋ። ");
INSERT INTO gofe_vpl VALUES ("DT22_23","006_22_23","DEU","22","23","23","እስ አስ ሀራ አሳስ ኦይሸታ ጊግዳ ጌላእዉ ካታማ ግዶን ደምድ ኢራ ላይማትኮ፥ ");
INSERT INTO gofe_vpl VALUES ("DT22_24","006_22_24","DEU","22","24","24","ኤንታ ናምኣ ካታማፐ ጋፃ ከስድ፥ ሹቻን ጫድድ ዎꬍተ። ናእያ ሀይቀይ፥ ካታማ ግዶን ደአሸ፥ አስ አሻና መላ ዋሳቦና ግሾሳ። ናአይ ሀይቀይ፥ ሀራ አሳስ ጊግዳ ጌላእዉ ኢስዳ ግሾሳ። ሄሳዳ ኦꬃዳ ነ ግዶፈ ኢታ ድጋ። ");
INSERT INTO gofe_vpl VALUES ("DT22_25","006_22_25","DEU","22","25","25","እስ አስ አሳስ ጊግዳ ጌላእዉ አስ ባይና በሳን ዎልቃን ኦይክድ፥ እዮ ኢስኮ፥ እያ ፃላል ሀይቆ። ");
INSERT INTO gofe_vpl VALUES ("DT22_26","006_22_26","DEU","22","26","26","እያ ሀይቆስ ጋꬅያ ናጋራ ኦꬃቦና ግሾ፥ ናኤ ቦላ አይባካ ኦꬆፕተ። ሄስ እስ አስ ጮ ደንድድ ሀራ አስ ዎይሳ መላ። ");
INSERT INTO gofe_vpl VALUES ("DT22_27","006_22_27","DEU","22","27","27","እ እዮ አስ ባይና በሳን ደምድ ኦይክን፥ ሄ ጌላእያ ዋሳሱ፥ ሽን እዮ አሽያ አስ በንትቤና። ");
INSERT INTO gofe_vpl VALUES ("DT22_28","006_22_28","DEU","22","28","28","እስ አስ ኦይሸታቦና ጌላእዉ ኦይክድ፥ እ ጌላኦተꬃ ኤክድ ኦይከተኮ፥ ");
INSERT INTO gofe_vpl VALUES ("DT22_29","006_22_29","DEU","22","29","29","ናኤ አዋ እሻታሙ ብራ ሳንትመ አጮ። ያትድ ናእዉ ባዉ ማቾ ኦꬆ። ባ ደኦ ላይꬃ ኡባን እዮ የዶፎ። ");
INSERT INTO gofe_vpl VALUES ("DT22_30","006_22_30","DEU","22","30","30","እስ አስ ባ አዋ ማችዉ ኤክድ፥ ባ አዋ ካዉሾፎ። ");
INSERT INTO gofe_vpl VALUES ("DT23_1","006_23_1","DEU","23","1","1","ሳንጋትዳ ዎይኮ ቃራተትዳ አደይ ጎዳ ሺቁዋ ገሎፖ። ");
INSERT INTO gofe_vpl VALUES ("DT23_2","006_23_2","DEU","23","2","2","ላይማተꬃን የለትዳ አስ ጎዳ ሺቁዋ ገሎፖ። ሀር አቶሽን ታማንꬆ የለተꬅ ጋካናዉ፥ እያ ኮቻፈ ኦንካ ጎዳ ሺቁዋ ገሎፖ። ");
INSERT INTO gofe_vpl VALUES ("DT23_3","006_23_3","DEU","23","3","3","አሞነ አስ ግድን ዎይኮ ሞአበ አስ ግድን፥ ጎዳ አሳ ሺቁዋ ገሎፖ። ሀር አቶሽን ታማንꬆ የለተꬅ ጋካናዉ ኤንታ አሰ ግድዳ ኦንካ ጎዳ አሳ ሺቁዋ ገሎፖ። ");
INSERT INTO gofe_vpl VALUES ("DT23_4","006_23_4","DEU","23","4","4","ኔኒ ግብፀፈ ከያዳ ብሽን፥ ኤንቲ ካꬃራነ ሃꬃራ ነና ሞክቦኮና። ኤንቲ ማሰጰፆመን ፓቶራ ካታማን ደእያ ብኦራ ናኣ ባላም ነና ባዳና መላ ሻምዶሶና። ");
INSERT INTO gofe_vpl VALUES ("DT23_5","006_23_5","DEU","23","5","5","ጎዳይ፥ ነ ፆሳይ ነና ዶስዳ ግሾ ባላማ ስእቤና፤ እያ ባደꬃ ነዉ አንጆን ላምስ። ");
INSERT INTO gofe_vpl VALUES ("DT23_6","006_23_6","DEU","23","6","6","ነ ደኦ ላይꬃ ኡባን ኤንቲ ሳሮ ዳና መላነ ዱረታና መላ አሞቶፋ። ");
INSERT INTO gofe_vpl VALUES ("DT23_7","006_23_7","DEU","23","7","7","ኤዶመት ነዉ ዳቦ ግድያ ግሾ ኤንታ ካꬎፓ፤ ነ ኤንታ ቢታን በተ አስ ግዳዳ ደእዳ ግሾ ግብፀታ ካꬎፓ። ");
INSERT INTO gofe_vpl VALUES ("DT23_8","006_23_8","DEU","23","8","8","ኤንታ ሄꬓንꬆ የለተꬃይ ጎዳ ሺቁዋ ገላናዉ ዳንዳኦሶና። ");
INSERT INTO gofe_vpl VALUES ("DT23_9","006_23_9","DEU","23","9","9","ነ ሞርከታ ኦላናዉ ከያዳ ዱንካንዳ በሳን ነና ቱናተꬃፈ ናጋ። ");
INSERT INTO gofe_vpl VALUES ("DT23_10","006_23_10","DEU","23","10","10","ቃማ አሙሆን አቱንꬃይ ጉክን፥ እርፃባይ እያ ቦላ ደእያ ኦንካ ጉታፐ ጋፃ ከይድ ያን ጋምኦ። ");
INSERT INTO gofe_vpl VALUES ("DT23_11","006_23_11","DEU","23","11","11","ሳእ ኦማርስያ ዎደ ባ አሳተꬃ ሜጨትድ፥ አው ዉልያ ዎደ ጉታ ስሞ። ");
INSERT INTO gofe_vpl VALUES ("DT23_12","006_23_12","DEU","23","12","12","ነ ዎራ ሼሽ ኡትያ በሲ ጉታፐ ካረን ጊግሳ። ");
INSERT INTO gofe_vpl VALUES ("DT23_13","006_23_13","DEU","23","13","13","ሼሻስ ኡትያ ኦላ ቦክያ ሚሸ ኦላ ሚሸራ ጋꬃዳ ኦይካ፤ ሼሻስ ኡታ ስማዳ ኦላን ቢታ ዛራ። ");
INSERT INTO gofe_vpl VALUES ("DT23_14","006_23_14","DEU","23","14","14","ጎዳይ፥ ነ ፆሳይ ነና ናጋናዉነ ነ ሞርከታ ነ ኩሸን አꬅድ እማናዉ፥ ነ ጉታን ስመረቴስ። እ ያን ሻትያባ በእድ፥ ነና አግድ ስሞና መላ ነ ጉታይ ጌሽ ግዳናዉ ኮሼስ። ");
INSERT INTO gofe_vpl VALUES ("DT23_15","006_23_15","DEU","23","15","15","ባ ጎዳፐ ባቃትድ፥ ኔኮ ይዳ አይልያ ዛራዳ እያ ጎዳስ እሞፋ። ");
INSERT INTO gofe_vpl VALUES ("DT23_16","006_23_16","DEU","23","16","16","እ ነ ካታማታፐ እሱዋን፥ ባ ኮይዳ በሳን ባ ኮይዳ ዎደ ጋካናዉ ደኦ፤ እያ ኡንኤꬆፋ። ");
INSERT INTO gofe_vpl VALUES ("DT23_17","006_23_17","DEU","23","17","17","እስራኤለ አሳፐ ኦንካ አደ ግድን ዎይኮ ማጫ ግድን፥ ኤቃ ጎይንያ አሳይ ኦይሳዳ ላይማቶፖ። ");
INSERT INTO gofe_vpl VALUES ("DT23_18","006_23_18","DEU","23","18","18","አደ ግድን ዎይኮ ማጫስ ግድን፥ ላይማተꬃን ደምዳ ሚሸ ቃንገꬅ ጋꬃናዉ ጎዳ ነ ፆሳ ኬꬅ ኤሆፖ። ኤንታ ናምኣ ጎዳይ ነ ፆሳይ እፄስ። ");
INSERT INTO gofe_vpl VALUES ("DT23_19","006_23_19","DEU","23","19","19","ህንተ ኮቸ ግድዳ እስራኤለ አሳስ ሚሸ ዎይኮ ካꬅ ዎይኮ ሀራባ ታልአዳ የሎ ኤኮፋ። ");
INSERT INTO gofe_vpl VALUES ("DT23_20","006_23_20","DEU","23","20","20","ሀራ ቢታ አሳፐ የሎ ኤካናዉ ዳንዳኣሳ፤ ሽን ኔኒ ላታናዉ ገልያ ቢታን ነ ኦꬅያባ ጎዳይ፥ ነ ፆሳይ አንጃና መላ ነ ኮቸ ግድዳ እስራኤለ አሳስ የሎራ ታልኦፋ። ");
INSERT INTO gofe_vpl VALUES ("DT23_21","006_23_21","DEU","23","21","21","ጎዳስ፥ ነ ፆሳስ፥ እማናዉ ቃንገትዳባ ጋꬃናዉ ጋምኦፋ። ጎዳይ ነ ፆሳይ ነ ቃንግዳይሳ ኩመꬅ ኔፐ ኮይያ ግሾ፥ ፖሎና እፅኮ ነዉ ናጋራ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("DT23_22","006_23_22","DEU","23","22","22","ሽን ነ ቃንጎና አግኮ ሄስ ናጋራ ግደና። ");
INSERT INTO gofe_vpl VALUES ("DT23_23","006_23_23","DEU","23","23","23","ጎዳስ ነ ፆሳስ፥ እማና ግዳ ነ ዶናን ኦደትዳባ ኔኒ ዶሳን እማና ግዳ ግሾ፥ ነ እንፃርሳን ኦደትዳባ ፖላ። ");
INSERT INTO gofe_vpl VALUES ("DT23_24","006_23_24","DEU","23","24","24","ኔኒ እስ አሳ ዎይነ ጋደ ግዶራ አꬍያ ዎደ ዎይንያፐ ኮይዳ መላ ማ፥ ሽን እያፐ አይባካ ነ ኦይክዳ ሚሸን የጎፋ። ");
INSERT INTO gofe_vpl VALUES ("DT23_25","006_23_25","DEU","23","25","25","እስ አሳ ጋደራ ኔኒ አꬍያ ዎደ ሄ ጋድያን ደእያ ትያፐ ዱꬃዳ ማ፤ ሽን ካꬃፈ ጫካዳ ነ ሶ ኤፎፓ። ");
INSERT INTO gofe_vpl VALUES ("DT24_1","006_24_1","DEU","24","1","1","እስ አስ ማቾ ኤክ ስሚድ፥ እስ ኢታባ እ ቦላ ደምድ እዮ እፅድ፥ ፕርማ ዳክድ፥ የድኮ፥ ");
INSERT INTO gofe_vpl VALUES ("DT24_2","006_24_2","DEU","24","2","2","እያ ሶፐ ከያዳ፥ ሀራ አዝና ገልኮ፥ ");
INSERT INTO gofe_vpl VALUES ("DT24_3","006_24_3","DEU","24","3","3","ሄ ናምአንꬆ አዝናይ እዮ ዶሶና እፅድ፥ ፕርማ ዳክድ፥ እዮ ባ ሶፐ ከስድ የድኮ፥ ዎይኮ እዮ ኤክዳ ናምአንꬆ አዝናይ ሀይቅኮ፥ ");
INSERT INTO gofe_vpl VALUES ("DT24_4","006_24_4","DEU","24","4","4","እያ ቱንዳ ግሾ፥ ኮይሮ ኤክዳ አዝናይ፥ ዛሪድ እዮ ኤኮፎ። ሄስ ጎዳ ስንꬃን እፀትዳባ፤ ነ ጎዳይ፥ ነ ፆሳይ ነ እምያ ቢታን ሄሳ መላ ናጋራ ኦꬆፋ። ");
INSERT INTO gofe_vpl VALUES ("DT24_5","006_24_5","DEU","24","5","5","ኦራꬃ ማቾ ኤክዳ አስ ኦላስ ቦፖ፤ ሀራ ዴፆ ኦሶ ኦꬆፎ። እስ ላይꬅ አꬋና ጋካናዉ አዉካ ቦና ባ ማችዉ ኡፋይሶ። ");
INSERT INTO gofe_vpl VALUES ("DT24_6","006_24_6","DEU","24","6","6","እስ አሳ ዎፃ ዎይኮ ማይደ አጮስ ኦይኮፋ፤ ሄስ ኬꬃ አሳይ ምያባ ꬋይድ ሀይቆ ጉሱ። ");
INSERT INTO gofe_vpl VALUES ("DT24_7","006_24_7","DEU","24","7","7","እስ እስራኤለ ግድዳ ባ እሻ ካይሶት ኤፍድ፥ አይለ ከሰይ ዎይኮ ሀራስ ባይዝያ ኡራይ ሀይቆ። ሄሳዳ ኦꬃዳ ኢታ ኡራ ነ ግዶፈ ድጋ። ");
INSERT INTO gofe_vpl VALUES ("DT24_8","006_24_8","DEU","24","8","8","ጎጋ ሀርገፈ ነና ምንꬃዳ ናጋ፤ ሌወ ኮቸ ግድዳ ካህነት ነና ታማርስያ ኡባ ፖላ፤ ታ ኤንታዉ እምዳ ኪታ ናጋ። ");
INSERT INTO gofe_vpl VALUES ("DT24_9","006_24_9","DEU","24","9","9","ኔኒ ግብፀፈ ከያዳ ኦገን ደእሽን፥ ጎዳይ ነ ፆሳይ ማይራም ቦላ ኦꬅዳይሳ አኬካ። ");
INSERT INTO gofe_vpl VALUES ("DT24_10","006_24_10","DEU","24","10","10","እስ አሳስ እስባ ታልአዳ፥ ኦይꬅያባ ኦይቻናዉ እያ ሶ ገሎፓ። ");
INSERT INTO gofe_vpl VALUES ("DT24_11","006_24_11","DEU","24","11","11","ኔኒ ካረን ኤቅዳሽን፥ ነ ታልእዳ ኡራይ ኦꬅያባ ሶፐ ከስድ ነዉ እሞ። ");
INSERT INTO gofe_vpl VALUES ("DT24_12","006_24_12","DEU","24","12","12","እ ማንቆ ግድኮ፥ ኔኒ አጮስ ኦይክዳ እያ ማኡዋ ነ ሶን አይሶፓ። ");
INSERT INTO gofe_vpl VALUES ("DT24_13","006_24_13","DEU","24","13","13","እ ማእድ አቃና መላ ሳእ ኦማርስያ ዎደ እያዉ ጉየ ዛራ፤ እ ነና ጋላታና። ሄስ ጎዳ ነ ፆሳ ስንꬃን ነዉ ፅሎተꬃ ኦሶ ግድድ ታይበታና። ");
INSERT INTO gofe_vpl VALUES ("DT24_14","006_24_14","DEU","24","14","14","ማንቆነ ማደ ኮይድ ዶካለትዳ፥ እስራኤለ ግድዳ ነ እሻ ግድን ዎይኮ ነ ካታማታፐ እሱዋን ደእያ ሀራ ቢታ አስ ናቆፋ። ");
INSERT INTO gofe_vpl VALUES ("DT24_15","006_24_15","DEU","24","15","15","እ ሀች ኦꬅዳይሳ ሀች ኤካናዉ ምንꬅድ ኮይያ ግሾ፥ አው ዉሎና እያዉ ቃንፃ። ሄስ ሀኖና እፅኮ፥ ማንቆይ ጎዳኮ ዋስን ሄስ ነዉ ናጋራ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("DT24_16","006_24_16","DEU","24","16","16","ናይት ኦꬅዳ ናጋራ ግሾ፥ አዋታ ዎꬋናዉ በሰና፤ ቃስ አዋት ኦꬅዳ ናጋራ ግሾ ናይታ ዎꬋናዉ በሰና። ኦንካ ባ ኦꬅዳ ናጋራን ናጋራን ሀይቃናዉ በሴስ። ");
INSERT INTO gofe_vpl VALUES ("DT24_17","006_24_17","DEU","24","17","17","ሀራ ቢታ አሳ ፕርዳነ ይኦ ናይታ ፕርዳ ዎቢሶፓ፤ አምኤ ማኡዋ አጮ ግሾ ኦይኮፋ። ");
INSERT INTO gofe_vpl VALUES ("DT24_18","006_24_18","DEU","24","18","18","ኔኒ ግብፀ ቢታን አይለ ግድዳይሳነ ጎዳይ ነ ፆሳይ ነና ያፐ ዎዝድ ከስዳይሳ አኬካ። ታኒ ነና ኪተይ ሄሳ ግሾሳ። ");
INSERT INTO gofe_vpl VALUES ("DT24_19","006_24_19","DEU","24","19","19","ኔኒ ካꬅ ጫክያ ዎደ ነ ዶግዳ ምርቅያ ኤካናዉ ጉየ ስሞፋ። ጎዳይ፥ ነ ፆሳይ ነ ኩሸ ኦሶ ኡባን ነና አንጃና መላ ሄሳ በተ አሳስ፥ ይኦ ናይታስነ አምኤታስ አጋጋ። ");
INSERT INTO gofe_vpl VALUES ("DT24_20","006_24_20","DEU","24","20","20","ኔኒ ሻማሆ አይፈ ማፅያ ዎደ ዉርሳዳ ማፃናዉ ናምአንꬆ ጉየ ስሞፋ። አትዳይሳ በተ አሳስ፥ ይኦ ናይታስነ አምኤታስ አጋጋ። ");
INSERT INTO gofe_vpl VALUES ("DT24_21","006_24_21","DEU","24","21","21","ኔኒ ዎይነ አይፈ ማፅያ ዎደ ዉርሳዳ ማፃናዉ ናምአንꬆ ጉየ ስሞፋ። አትዳይሳ በተ አሳስ፥ ይኦ ናይታስነ አምኤታስ አጋጋ። ");
INSERT INTO gofe_vpl VALUES ("DT24_22","006_24_22","DEU","24","22","22","ኔኒ ግብፀ ቢታን አይለ ግዳዳ ደእዳይሳ ዶጎፓ። ታኒ ነና ኪተይ ሄሳ ግሾሳ። ");
INSERT INTO gofe_vpl VALUES ("DT25_1","006_25_1","DEU","25","1","1","ናምኡ አሳት ኦየትድ ፕርዳ ኬꬅ ቢኮ፥ ዳይናት ፅሉዋ ነ ልከ ግድ፥ ናቅዳይሳ ነ ባላ ግድ ፕርዶ። ");
INSERT INTO gofe_vpl VALUES ("DT25_2","006_25_2","DEU","25","2","2","ባልዳይሳ ጋራፎ በሲያባ ግድኮ፥ እያ ትራራ ዝንእስድ ዞኮን ሾጫና መላ ዳይናይ ኪቶ። እ ጋራፈተይ ዳይና ስንꬃንነ እ ኦꬅዳ ባላ መላ ግዶ። ");
INSERT INTO gofe_vpl VALUES ("DT25_3","006_25_3","DEU","25","3","3","እ ኦይታሙ ጋካናዉ ጋራፈታናዉ ዳንዳኤስ፥ ሽን ሄሳፈ ዳሮፖ። ሄሳፈ ዳርኮ ነ እሻይ ነ ስንꬃን ካዉያና። ");
INSERT INTO gofe_vpl VALUES ("DT25_4","006_25_4","DEU","25","4","4","ዉዱማን ካꬅ የꬍያ ቦራ ዶና ቃቾፋ። ");
INSERT INTO gofe_vpl VALUES ("DT25_5","006_25_5","DEU","25","5","5","እስፈ ደእያ እሻታፐ እሶይ ናአ የሎና ሀይቅኮ፥ እያ ማችያ ሀራ አስ ገሎፖ። እ አዝና እሻይ እዮ ኤክድ፥ እዉ ኮሽያባ ኩንꬆ። ");
INSERT INTO gofe_vpl VALUES ("DT25_6","006_25_6","DEU","25","6","6","ሀይቅዳ እሻ ሱንꬃይ እስራኤለ አሳ ግዶፈ ቁሸትድ ꬋዮና መላ እያ፥ ኮይሮ የልያ አደ ናአይ ሀይቅዳ እሻ ሱንꬃን ፄገቶ። ");
INSERT INTO gofe_vpl VALUES ("DT25_7","006_25_7","DEU","25","7","7","ግዶሽን፥ እ ባ እሻ ማችዉ ኤካናዉ ኮዮና እፅኮ፥ ማጫስያ ካታማ ፐንገን ደእያ ጭማታኮ ባዳ፥ “ታ አዝና እሻይ ባ እሻ ሱንꬃይ እስራኤለን ዳና መላ ኮይቤና፤ ታና ኤክድ፥ ታዉ ኮሽያባ ኩንꬆና እፅስ” ያጋዳ ኦዶ። ");
INSERT INTO gofe_vpl VALUES ("DT25_8","006_25_8","DEU","25","8","8","ካታማ ጭማት እያ ፄግድ ኦይችን፥ እ ሀእካ፥ “ታኒ እዮ ኤክከ” ጊኮ፥ ");
INSERT INTO gofe_vpl VALUES ("DT25_9","006_25_9","DEU","25","9","9","ማጫስያ ጭማታ ስንꬃን እያኮ ሺቃዳ፥ እያ ጫማፈ እሱዋ ከሳዳ፥ እያ ሶምኦን ጩታዳ፥ “ባ እሻስ ዘረꬅ ዳና መላ ኮዮና አሳ ቦላ ሀይሳ መላ ካዉሽ ጋካናዉ በሴስ” ያጎ። ");
INSERT INTO gofe_vpl VALUES ("DT25_10","006_25_10","DEU","25","10","10","ያትን፥ ሄ ኡራ ሶ አሳይ እስራኤለ ኮቻ ግዶን፥ “ጫማ ከስዳ አሳ ሶ” ጌተትድ ፄገትሸ ዳና። ");
INSERT INTO gofe_vpl VALUES ("DT25_11","006_25_11","DEU","25","11","11","ናምኡ አሳት ዋትሽን፥ እሱዋ ማችያ ያዳ፥ ባ አዝና ሾጨይሳ ኩሸፐ አሻናዉ፥ ባ ኩሽያ የዳዳ ሀንኩዋ አደተꬃ ኦይክኮ፥ ");
INSERT INTO gofe_vpl VALUES ("DT25_12","006_25_12","DEU","25","12","12","እ ኩሸይ ቃይ ባይና ቃንፀቶ። ");
INSERT INTO gofe_vpl VALUES ("DT25_13","006_25_13","DEU","25","13","13","ግታነ ጉꬅ ግድዳ ናምኡ ምዛነ ኦይኮፋ። ");
INSERT INTO gofe_vpl VALUES ("DT25_14","006_25_14","DEU","25","14","14","ዳሮነ ጉꬅ ማክያ ናምኡ ማካ ሚሸይ ነዉ ዶፖ። ");
INSERT INTO gofe_vpl VALUES ("DT25_15","006_25_15","DEU","25","15","15","ጎዳይ፥ ነ ፆሳይ ነዉ እምያ ቢታን አዱሳ ላይꬅ ነ ዳና መላ ልከ ምዛነይነ ማካ ሚሸይ ነዉ ደኦ። ");
INSERT INTO gofe_vpl VALUES ("DT25_16","006_25_16","DEU","25","16","16","ጎዳይ ነ ፆሳይ ሄሳ መላባ ኦꬅድ፥ ባለꬅያ ኦናካ እፄስ። ");
INSERT INTO gofe_vpl VALUES ("DT25_17","006_25_17","DEU","25","17","17","ነ ግብፀፈ ከያዳ ኦገ ቦላ ደእሽን፥ አማለቃት ነ ቦላ ኦꬅዳባ አኬካ። ");
INSERT INTO gofe_vpl VALUES ("DT25_18","006_25_18","DEU","25","18","18","ኤንቲ ፆሰ ያዮና ደረ፤ ነ ኦግያን ኤንቲ ኔራ ኤቀትዶሶና። ነ ብሽን፥ ዳቡርድ ጉየ አትዳ አሳ ኡባ ዎꬍዶሶና። ");
INSERT INTO gofe_vpl VALUES ("DT25_19","006_25_19","DEU","25","19","19","ሄሳ ግሾ፥ ጎዳይ ነ ፆሳይ ነና ሄ ቢታ ላትስድ፥ ነ ዩሹዋን ደእያ ሞርከታፐ ነና ሸምፕስያ ዎደ ሀ ቢታን ኤንታ ሀሳይያ አስ ꬋያና ጋካናዉ አማለቃታ ኡባ ꬋይሳ፤ ሄሳ ኦꬃናይሳ ዶጎፓ። ");
INSERT INTO gofe_vpl VALUES ("DT26_1","006_26_1","DEU","26","1","1","ጎዳይ፥ ነ ፆሳይ ነና ላትስያ ቢታ ገላዳ፥ ዎፑ ጋዳ ዱስ ኦይክያ ዎደ፥ ");
INSERT INTO gofe_vpl VALUES ("DT26_2","006_26_2","DEU","26","2","2","ጎዳይ፥ ነ ፆሳይ ነዉ እምያ ቢታን ሞክዳ ካꬃ ኡባፈ ባይራ፥ ጎዳይ ነ ፆሳይ ባ ሱንꬃይ ፄገታና መላ ዶርዳ በሳ ኤካዳ ባ። ");
INSERT INTO gofe_vpl VALUES ("DT26_3","006_26_3","DEU","26","3","3","ሄ ዎደ አዋትያ ካህንያኮ ባዳ፥ “ጎዳይ ታዉ እማና ግድ ካሰ ኑ ማይዛታስ ጫቅዳ በሳ ኑና ገልስዳ ጎዳስ፥ ኑ ፆሳስ፥ ሀች ማርካታይስ” ያግተ። ");
INSERT INTO gofe_vpl VALUES ("DT26_4","006_26_4","DEU","26","4","4","ካህነይ ካꬃ ነ ኩሸፐ ኤክድ፥ ጎዳ ነ ፆሳ ያርሾ በሳ ስንꬃን ዎꬆ። ");
INSERT INTO gofe_vpl VALUES ("DT26_5","006_26_5","DEU","26","5","5","ሄሳፈ ጉየ፥ ጎዳ ነ ፆሳ ስንꬃን ሀይሳዳ ያጋ፤ “ታ ማይዛይ በሳፈ በሰ ዩይሸ ደእዳ ሶረ ቢታ አስ፤ እ ታይቦን ጉꬃ አሳታራ ግብፀ ዎꬍድ ያን ደእስ። እ ያን ደእሸ ግታ፥ ዎልቃማነ ታይቦን ዳሮ ደረ ግድስ። ");
INSERT INTO gofe_vpl VALUES ("DT26_6","006_26_6","DEU","26","6","6","ሽን ግብፀት ኑኒ አይለ ግድድ ኦꬃና መላ ኡንኤꬅዶሶና፤ ካዉሽዶሶና። ");
INSERT INTO gofe_vpl VALUES ("DT26_7","006_26_7","DEU","26","7","7","ያትን፥ ኑኒ ጎዳኮ፥ ኑ አዋታ ፆሳኮ ዋስዳ። ጎዳይ ኑ ዋሱዋ ስእስ፤ ኑ ዋይያ፥ ኑ ዳቡራነ ኑ ኡንኤተꬃ በእስ። ");
INSERT INTO gofe_vpl VALUES ("DT26_8","006_26_8","DEU","26","8","8","ጎዳይ ባ ዎልቃማ ኩሽያን፥ ባ ምጨትዳ ቀስያን፥ ግታ ዳጋማን፥ ማላታንነ ማላልስያባታን ኑና ግብፀፈ ከስስ። ");
INSERT INTO gofe_vpl VALUES ("DT26_9","006_26_9","DEU","26","9","9","ሀ በሳ ኑና ኤህድ፥ ማꬅነ ኤስ ጎግያ ሀ ቢታ ኑስ እሚስ። ");
INSERT INTO gofe_vpl VALUES ("DT26_10","006_26_10","DEU","26","10","10","ሄኮ፥ ጎዳይ ኑስ እምዳ ቢታ አይፍያፐ ባይራ ኤሀስ” ያጋዳ፥ ካꬃ ጎዳ ነ ፆሳ ስንꬃን ዎꬃዳ፥ እያ ስንꬃን ጉፋና። ");
INSERT INTO gofe_vpl VALUES ("DT26_11","006_26_11","DEU","26","11","11","ነዉነ ነ ሶ አሳስ ጎዳይ፥ ነ ፆሳይ እምዳ ሎኦባ ኡባን ኡፋይታሸ፥ ጎዳ ጋላታ። ሌወትነ ነ ግዶን ደእያ በተ አሳ ኡባይካ ኔራ ኡፋይቶ። ");
INSERT INTO gofe_vpl VALUES ("DT26_12","006_26_12","DEU","26","12","12","አስራታ ከስያ ሄꬓንꬆ ላይꬃን፥ ነ ካꬃፈ አስራታ ከሳ ኦንግዳፐ ጉየ ነ ካታማን ደእያ ሌወታስ፥ በተ አሳስ፥ ይኦታስነ አምኤታስ እማዳ ኤንቲ ካልድ ማና መላ ኦꬃ። ");
INSERT INTO gofe_vpl VALUES ("DT26_13","006_26_13","DEU","26","13","13","ጎዳ፥ ነ ፆሳኮ፥ “ታኒ ታ ሶፐ ዱማትዳ ካꬃ እሞታ ከሳዳ፥ ነ ታና ኪትዳይሳዳ ሌወታስ፥ በተ አሳስ፥ ይኦታስነ አምኤታስ እማስ። ታኒ ነ ኪታፐ እሱዋካ መንꬃብከ፤ እሱዋካ ዶጋ አጋብከ። ");
INSERT INTO gofe_vpl VALUES ("DT26_14","006_26_14","DEU","26","14","14","ታ ካዮትያ ዎደካ፥ ሄ አስራታፐ አይባካ ማብከ፤ ታ ቱንዳ ዎደካ እያ ቦቻብከ፤ ሀይቅዳ አሳስ እያፐ እማብከ። ታኒ ጎዳ፥ ታ ፆሳ ቦንቻስ፤ እ ታና ኪትዳባ ኡባ ፖላስ። ");
INSERT INTO gofe_vpl VALUES ("DT26_15","006_26_15","DEU","26","15","15","ነኒ ደእያ ጌሻ በሳፈ፥ ሳሎፐ ዱገ ፄላ፤ ነ ደርያ እስራኤለ አንጃ፤ ካሰ ኑ ማይዛታስ ነ እማና ጋዳ ጫቅዳ ማꬅነ ኤስ ጎግያ ቢታ ኑስ አንጃ” ያጋ። ");
INSERT INTO gofe_vpl VALUES ("DT26_16","006_26_16","DEU","26","16","16","ነ ሀ አዋጆታነ ዎጋታ ናጋና መላ ጎዳይ ነ ፆሳይ ሀች ነና ኪትስ። ሄሳ ግሾ፥ ነ ኩመꬃ ዎዛናፐነ ኩመꬃ ሸምፑዋፈ ኤንታ ናጋ። ");
INSERT INTO gofe_vpl VALUES ("DT26_17","006_26_17","DEU","26","17","17","ጎዳይ፥ ነው ፆሰ ግደይሳነ ነኒ እያ ኦግያን ባናዉ፥ እያ ዎጋ፥ እያ ኪታነ ህግያ ናጋናይሳ ሀች ኤርሳዳሳ። ");
INSERT INTO gofe_vpl VALUES ("DT26_18","006_26_18","DEU","26","18","18","ጎዳይ ባ ገልዳ ቃላዳ ነኒ እያ ደረ ግደይሳ፥ እያዉ ቡዞ ሚሸ ግደይሳነ እያ ኪታ ኡባ ናገይሳታ ግደይሳ ሀች ነና ኤርስስ። ");
INSERT INTO gofe_vpl VALUES ("DT26_19","006_26_19","DEU","26","19","19","ሄሳ ነኒ ኦꬅኮ፥ እ መꬍዳ ደረ ኡባፈ አꬅድ ነና ጋላታን፥ ሱንꬃንነ ቦንቾን ግታ ደረ ኦꬃና። እ ገልዳ ቃላዳ ነኒ እያዉ ጌሻ ደረ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("DT27_1","006_27_1","DEU","27","1","1","ሄሳፈ ጉየ፥ ሙሰይነ እስራኤለ ጭማት አሳኮ፥ “ታኒ ሀች ህንተና ኪትያ ኪታ ናግተ። ");
INSERT INTO gofe_vpl VALUES ("DT27_2","006_27_2","DEU","27","2","2","ዮርዳኖሰ ሻፋ ፕናዳ፥ ጎዳይ ነ ፆሳይ ነዉ እምያ ቢታ ገልያ ዎደ ግታ ሹቻታ ኤሳዳ ኖራ ትያ። ");
INSERT INTO gofe_vpl VALUES ("DT27_3","006_27_3","DEU","27","3","3","ጎዳይ፥ ነ አዋታ ፆሳይ ነዉ እማና ግዳይሳዳ ማꬅነ ኤስ ጎግያ ቢታ፥ ጎዳይ ነ ፆሳይ ነዉ እምያ ቢታ ነ ፕንያ ዎደ ሀ ህገታ ኡባ ሄ ሹቻታ ቦላ ፃፋ። ");
INSERT INTO gofe_vpl VALUES ("DT27_4","006_27_4","DEU","27","4","4","ኔኒ ዮርዳኖሰ ፕንዳ ዎደ ታ ነና ሀች ኪትዳይሳዳ ሀ ሹቻታ ኤባላ ዙማ ቦላ ኤሳዳ ኤንታ ቦላ ኖራ ትያ። ");
INSERT INTO gofe_vpl VALUES ("DT27_5","006_27_5","DEU","27","5","5","ሄ በሳን ጎዳስ፥ ነ ፆሳስ፥ ብራት ቦቾና ሹቻፈ ያርሾ በሲ ጊግሳ። ");
INSERT INTO gofe_vpl VALUES ("DT27_6","006_27_6","DEU","27","6","6","ጎዳስ፥ ነ ፆሳስ ያርሾ በሲ ማሰትቦና ሹቻፈ ኦꬃ፤ እያ ቦላ ጎዳስ፥ ነ ፆሳስ ፁሳ ያርሾ ያርሻ። ");
INSERT INTO gofe_vpl VALUES ("DT27_7","006_27_7","DEU","27","7","7","እስፈተꬃ ያርሹዋ ሺሻዳ ማሸ ጎዳ፥ ነ ፆሳ ስንꬃን ኡፋይታ። ");
INSERT INTO gofe_vpl VALUES ("DT27_8","006_27_8","DEU","27","8","8","ሀ ህገታ በንታና መላ ኦꬃዳ ሀ ሹቻታ ቦላ ቆንጨን ፃፋ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("DT27_9","006_27_9","DEU","27","9","9","ሙሰይነ ሌወ ግድዳ ካህነት እስፈ አሳኮ፥ “እስራኤለ፥ ስእ ጋዳ ዎዛናፐ ስአ፤ ሀች ነ ጎዳ፥ ነ ፆሳ ደረ ግዳዳሳ። ");
INSERT INTO gofe_vpl VALUES ("DT27_10","006_27_10","DEU","27","10","10","ታ ሀች ነዉ እምያ ጎዳ፥ ነ ፆሳ አዋጆታ ናጋነ ኪተታ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("DT27_11","006_27_11","DEU","27","11","11","ሄ ጋላስ ሙሰይ አሳ ሀይሳዳ ያግድ ኪትስ። ");
INSERT INTO gofe_vpl VALUES ("DT27_12","006_27_12","DEU","27","12","12","“ህንተ ዮርዳኖሰ ፕንዳፐ ጉየ ጋርዛና ዙማ ቦላ ኤቅድ አሳ አንጃናይሳት፥ ስሞና፥ ሌወ፥ ይሁዳ፥ ይሳኮራ፥ ዮሰፋነ ብንያመ ኮቻታ። ");
INSERT INTO gofe_vpl VALUES ("DT27_13","006_27_13","DEU","27","13","13","ቃስ ኤባላ ዙማ ቦላ ኤቅድ አሳ ባዳናይሳት፥ ሮቤላ፥ ጋደ፥ አሴራ፥ ዛብሎና፥ ዳነነ ንፍታለመ ኮቻታ። ");
INSERT INTO gofe_vpl VALUES ("DT27_14","006_27_14","DEU","27","14","14","“ሌወት ባንታ ቃላ ꬎቁ ኦꬅድ፥ እስራኤለ አሳኮ ሀይሳዳ ያጎ። ");
INSERT INTO gofe_vpl VALUES ("DT27_15","006_27_15","DEU","27","15","15","ጎዳ ስንꬃን እፀትዳባ ግድያ ግሾ፥ ኩሸ ሂላንችጮይ ምꬅ ማስድ፥ ብራታ ሼሽድ ዎይኮ ሹች ቆፅድ ኦꬅዳ ኤቃ ጌማን ጎይንያ ኦንካ ባደትዳይሳ ግዶ” ጊኮ፥ ");
INSERT INTO gofe_vpl VALUES ("DT27_16","006_27_16","DEU","27","16","16","“ባ አዋ ዎይኮ ባ አይዉ ካዉሽያ ኦንካ ባደትዳይሳ ግዶ” ጊኮ፥ ");
INSERT INTO gofe_vpl VALUES ("DT27_17","006_27_17","DEU","27","17","17","“ባ ሾሩዋ ዛዋ ሱግያ አስ ባደትዳይሳ ግዶ” ጊኮ፥ ");
INSERT INTO gofe_vpl VALUES ("DT27_18","006_27_18","DEU","27","18","18","“ቆቀይ ባናዉ በሲያ ኦግያፐ ሀራ ሶ ዛርያ አስ ባደትዳይሳ ግዶ” ጊኮ፥ ");
INSERT INTO gofe_vpl VALUES ("DT27_19","006_27_19","DEU","27","19","19","“በተ አሳ፥ ይኦ ናይታነ አምኤታ ፕርዳ ጌላይያ አስ ባደትዳይሳ ግዶ” ያግኮ፥ ");
INSERT INTO gofe_vpl VALUES ("DT27_20","006_27_20","DEU","27","20","20","“ባ አዋ ማችዉ ፃልድ፥ ባ አዋ ቦንቹዋ ቃርያ አስ ባደትዳይሳ ግዶ” ጊኮ፥ ");
INSERT INTO gofe_vpl VALUES ("DT27_21","006_27_21","DEU","27","21","21","“መሄራ ቱንያ አስ ባደትዳይሳ ግዶ” ጊኮ፥ ");
INSERT INTO gofe_vpl VALUES ("DT27_22","006_27_22","DEU","27","22","22","“ባ ምቾ ግድዳ አዋ ዎይኮ አየ ናኤራ ቱንያ አስ ባደትዳይሳ ግዶ” ጊኮ፥ ");
INSERT INTO gofe_vpl VALUES ("DT27_23","006_27_23","DEU","27","23","23","“ባ ማቸ አየራ ቱንያ አስ ባደትዳይሳ ግዶ” ጊኮ፥ ");
INSERT INTO gofe_vpl VALUES ("DT27_24","006_27_24","DEU","27","24","24","“አሰ ጌማን ዎꬍያ አስ ባደትዳይሳ ግዶ” ጊኮ፥ ");
INSERT INTO gofe_vpl VALUES ("DT27_25","006_27_25","DEU","27","25","25","“ሚሸን ሻመትድ፥ ፅሎ አስ ዎꬍያ አስ ባደትዳይሳ ግዶ” ጊኮ፥ ");
INSERT INTO gofe_vpl VALUES ("DT27_26","006_27_26","DEU","27","26","26","“ሀ ህገታ ናጎና አስ ባደትዳይሳ ግዶ” ጊኮ፥ ");
INSERT INTO gofe_vpl VALUES ("DT28_1","006_28_1","DEU","28","1","1","ኔኒ ጎዳ ነ ፆሳስ ፖሎ ኪተትኮ፥ ሀች ታ ነዉ እምያ ኪታ ኡባ ምንꬃዳ ናግኮ፥ ጎዳይ፥ ነ ፆሳይ ቢታን ደእያ ካዎተꬃታ ኡባፈ አꬅድ ነና ꬎቁ ꬎቁ ኦꬃና። ");
INSERT INTO gofe_vpl VALUES ("DT28_2","006_28_2","DEU","28","2","2","ኔኒ ጎዳ፥ ነ ፆሳስ ኪተትኮ፥ ሀይሳፈ ካልድ ደእያ አንጆ ኡባይ ነባ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("DT28_3","006_28_3","DEU","28","3","3","ነ ካታማንነ ነ ጎሻን አንጀትዳይሳ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("DT28_4","006_28_4","DEU","28","4","4","ነ ኡሎ አይፈይ፥ ነ ካꬃይ፥ ነ መሄይ፥ ነ ዶርሳትነ ነ ዴሻት አንጀትዳይሳታ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("DT28_5","006_28_5","DEU","28","5","5","ነ ኬሸይነ ነ ሙናቃ ሚሸይ አንጀትዳይሳ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("DT28_6","006_28_6","DEU","28","6","6","ነ ከሳይነ ነ ገሎይ አንጀትዳይሳ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("DT28_7","006_28_7","DEU","28","7","7","ነ ቦላ ደንድያ ነ ሞርከታ፥ ጎዳይ ነ ስንꬃን ፆነትዳይሳታ ኦꬃና። ኤንቲ ነ ቦላ እስ ኦገራ ያና፥ ሽን ላፑን ኦገራ ነ ስንꬃፈ ባቃታና። ");
INSERT INTO gofe_vpl VALUES ("DT28_8","006_28_8","DEU","28","8","8","ጎዳይ ነ ኩሸይ ኦይክያባነ ነ ሻልያ አንጃና፤ ጎዳይ፥ ነ ፆሳይ ነዉ እምያ ቢታን ነና አንጃና። ");
INSERT INTO gofe_vpl VALUES ("DT28_9","006_28_9","DEU","28","9","9","ኔኒ ጎዳ፥ ነ ፆሳ ኪታ ናግኮነ እያ ኦግያን ቢኮ፥ እ ነዉ ጫቅዳይሳዳ ጎዳይ ነና ባዉ ጌሻ ደረ ኦꬅድ ኤሳና። ");
INSERT INTO gofe_vpl VALUES ("DT28_10","006_28_10","DEU","28","10","10","ሄሳፈ ጉየ፥ ቢታን ደእያ አሳ ኡባይ ጎዳይ ባ ሱንꬃን ነና ፄግዳይሳ በእድ ያያና። ");
INSERT INTO gofe_vpl VALUES ("DT28_11","006_28_11","DEU","28","11","11","ጎዳይ ነዉ እማናዉ ነ ማይዛታስ ጫቅዳ ሄ ቢታን፥ ነ ኡሎ አይፍያ፥ ነ መህያ፥ ነ ጎሻ አይፍያ ዳርስድ አንጃና። ");
INSERT INTO gofe_vpl VALUES ("DT28_12","006_28_12","DEU","28","12","12","ነ ኩሸ ኦሶ ኡባ አንጃናዉነ፥ ጎዳይ ነ ቢታስ እራ ዎደን ዎደን ቡክሳናዉ ባ ምንጃ ኬꬃ፥ ሳሎ ፐንግያ ነዉ ዶያና። ኔኒ ዳሮ ካዎተꬃታስ ገደ ታልአናፐ አትሽን፥ ኦደፈካ ሃ ታልአካ። ");
INSERT INTO gofe_vpl VALUES ("DT28_13","006_28_13","DEU","28","13","13","ጎዳይ ነና ኡባስ ካጨ ከሳናፐ አትሽን፥ ጎይና ከሰና። ሀች ታ ነዉ እምያ፥ ጎዳ፥ ነ ፆሳ ኪታ ስአዳ፥ ምንꬃዳ ናግኮ፥ ነ ቦላ ግዳናፐ አትሽን፥ ጋርሰ ግዳካ። ");
INSERT INTO gofe_vpl VALUES ("DT28_14","006_28_14","DEU","28","14","14","ታ ነዉ ሀች እምዳ ኪታፐ ሀድርስ ዎይኮ ኡሻች ጋዳ፥ ሀራ ፆሳታ ካሎፋ፤ ኤንታ ጎይኖፋ። ");
INSERT INTO gofe_vpl VALUES ("DT28_15","006_28_15","DEU","28","15","15","ሽን ኔኒ ጎዳ፥ ነ ፆሳስ ኪተቶና እፃዳ፥ ሀች ታ ነና ኪትያ ዎጋነ ህግያ ኡባ ናጎና እፅኮ፥ ሀይሳፈ ካልድ ደእያ ባደꬃት ኡባይ ነ ቦላ ያናነ ነና ደማና። ");
INSERT INTO gofe_vpl VALUES ("DT28_16","006_28_16","DEU","28","16","16","ነ ካታማንነ ነ ጎሻን ባደትዳይሳ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("DT28_17","006_28_17","DEU","28","17","17","ነ ኬሸይነ ሙናቃ ሚሸይ ባደትዳይሳ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("DT28_18","006_28_18","DEU","28","18","18","ነ ኡሎ አይፈይ፥ ነ ካꬃ አይፈይ፥ ነ መሄይ፥ ነ ዶርሳይነ ዴሻይ ባደትዳይሳ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("DT28_19","006_28_19","DEU","28","19","19","ነ ከሳይነ ነ ገሎይ ባደትዳይሳ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("DT28_20","006_28_20","DEU","28","20","20","ኔኒ ኢታ ኦሶ ኦꬃዳ ታና አግዳ ግሾ፥ ኔኒ ኤሶን ꬋያና ጋካናዉ ነ ኦꬅያ ኦሶ ኡባን ጎዳይ ባደꬅ፥ ዳጋማነ ካዉሻተꬅ የዳና። ");
INSERT INTO gofe_vpl VALUES ("DT28_21","006_28_21","DEU","28","21","21","ኔኒ ላታናዉ ብያ ቢታፈ ꬋያና ጋካናዉ ጎዳይ፥ ጋዶይ ኔፐ ዱፆና መላ ኦꬃና። ");
INSERT INTO gofe_vpl VALUES ("DT28_22","006_28_22","DEU","28","22","22","ጎዳይ ነና ግልቃተꬃን፥ ምሻን፥ ማዱንꬃን፥ ፁግያ አዋን፥ ኮሻን፥ ዎልኦንነ ካꬅ ꬋይስያ ሀርመን ነ ꬋያና ጋካናዉ ሾጫና። ");
INSERT INTO gofe_vpl VALUES ("DT28_23","006_28_23","DEU","28","23","23","ኔፐ ቦላራ ደእያ ሳሎይ ናሰ ብራታ ግዳና፤ ኔፐ ጋርሳራ ደእያ ቢታይ ብራታ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("DT28_24","006_28_24","DEU","28","24","24","ጎዳይ ነ ቢታን ቡክያ እራ ብዶነ ባና ከሳና፤ ኔኒ ꬋያና ጋካናዉ ሳሎፐ ባን ቡካና። ");
INSERT INTO gofe_vpl VALUES ("DT28_25","006_28_25","DEU","28","25","25","ጎዳይ ነና ነ ሞርከታን ፆንሳና። ነኒ ኤንታ ኦላናዉ እስ ኦገራ ከያና፤ ሽን ላፑን ኦገራ ነ ኤንታ ስንꬃፈ ባቃታና። ቢታን ደእያ ካዎተꬅ ኡባይ ነ ቦላ ጋክዳባ በእድ፥ ያሻን ኮኮራና። ");
INSERT INTO gofe_vpl VALUES ("DT28_26","006_28_26","DEU","28","26","26","ነ አሀይ ሳሎ ካፎታስነ ባዞ ዶአታስ ካꬅ ግዳና፤ ኤንታ የደꬅያ ኦንካ ዴና። ");
INSERT INTO gofe_vpl VALUES ("DT28_27","006_28_27","DEU","28","27","27","ጎዳይ ነና ፓፆይ ባይና ግብፀ ጋዶን፥ ክፃን፥ ማዱንꬃንነ ፑሶ ሄርገን ሾጫና። ");
INSERT INTO gofe_vpl VALUES ("DT28_28","006_28_28","DEU","28","28","28","ጎዳይ ነና ጎሻተꬃን፥ ቆቀተꬃንነ ዳጋማን ሾጫና። ");
INSERT INTO gofe_vpl VALUES ("DT28_29","006_28_29","DEU","28","29","29","ሴታ ጋላስ ኔኒ ቆቀይ ታታፈይሳዳ ታታፋና፤ ነ ኦꬅያባ ኡባይ ነዉ ጊጎና እፃና። ነ ደኦ ላይꬃ ኡባን ነ ኡንኤታናነ ቦንቀታዳ ዳና። ነና ማድያ አስ ደማካ። ");
INSERT INTO gofe_vpl VALUES ("DT28_30","006_28_30","DEU","28","30","30","ነ ማቾ ኦይቻ ጊግሳና፥ ሽን እዮ ሀር ዳፍ ኤክድ ኢሳና። ኔኒ ኬ ኬፃና፥ ሽን እያን ደአካ። ዎይነ ቶካና፥ ሽን እያ አይፍያ ማካ። ");
INSERT INTO gofe_vpl VALUES ("DT28_31","006_28_31","DEU","28","31","31","ነ ቦራይ ነ ስንꬃን ሹከታና፥ ሽን እያ አሹዋ ማካ። ነ ሀረይ ኔፐ ዎልቃን ኤከታና፥ ሽን ነዉ ጉየ ስመና። ነ ዶርሳት ነ ሞርከታስ እመታና፥ ኤንታ አሻናዉ ነና ማድያ አስ ዴና። ");
INSERT INTO gofe_vpl VALUES ("DT28_32","006_28_32","DEU","28","32","32","ነ አይፈይ በእሽን ነ አደ ናይትነ ማጫ ናይት ሀራ ካዎተꬃስ እመታና። ኤንቲ ስምን በአና ጋዳ ፄልሽን፥ ነ አይፈይ ቶሉ ግድ አታና፤ ሄሳ ድጋናዉ ነዉ ዎልቅ ዴና። ");
INSERT INTO gofe_vpl VALUES ("DT28_33","006_28_33","DEU","28","33","33","ነ ቢታ አይፍያነ ነ ጫዋ ኡባ ነ ኤሮና አስ ማና፤ ነ ደኦ ላይꬃ ኡባን ኡንኤትዳይሳነ ናቀትዳይሳ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("DT28_34","006_28_34","DEU","28","34","34","ነ በእያ ኢታት ነና ጎሻና። ");
INSERT INTO gofe_vpl VALUES ("DT28_35","006_28_35","DEU","28","35","35","ጎዳይ ፓፆይ ባይና ኢታ ማዱንꬃን ነ ጉልባታነ ነ ዎድርያ ሀርግሳና፤ ቶሆፐ ሁጰ ጋካናዉ፥ ነና ሄ ማዱንꬃን ሾጫና። ");
INSERT INTO gofe_vpl VALUES ("DT28_36","006_28_36","DEU","28","36","36","ጎዳይ ነናነ ነ ካዋ፥ ነናነ ነ ማይዛታ ኤሮና አሳ ቢታ ኤፋና። ሄሳን ኔኒ ምꬃፈነ ሹቻፈ ኦሰትዳ ሀራ ፆሳታ ጎይናና። ");
INSERT INTO gofe_vpl VALUES ("DT28_37","006_28_37","DEU","28","37","37","ጎዳይ ነና ላልያ ሀራ ካዎተꬃታ ግዶን ኔኒ ሚቻስነ ካሳስ አታና። ");
INSERT INTO gofe_vpl VALUES ("DT28_38","006_28_38","DEU","28","38","38","ኔኒ ዳሮ ካꬅ ነ ጎሻን ዘራና፤ ሽን ቦለይ ምድግን፥ ጉꬃ ካꬅ ሺሻና። ");
INSERT INTO gofe_vpl VALUES ("DT28_39","006_28_39","DEU","28","39","39","ዎይነ ቶካዳ እያ ሀርማና፥ ሽን ጉፁነይ እያ ምድግን፥ እያፐ አይፈ ደማካ ዎይኮ እያፐ ኡያካ። ");
INSERT INTO gofe_vpl VALUES ("DT28_40","006_28_40","DEU","28","40","40","ነ ቢታ ኡባን ሻማሆይ ዶላና፥ ሽን አይፈይ ቆቆፈትድ ዉርያ ግሾ፥ ሻማሆ ዛይተ ደማካ። ");
INSERT INTO gofe_vpl VALUES ("DT28_41","006_28_41","DEU","28","41","41","ነ አደነ ማጫ የላና፥ ሽን ኦል ድእድ ኤፍያ ግሾ ኤንቲ ኔራ ዶኮና። ");
INSERT INTO gofe_vpl VALUES ("DT28_42","006_28_42","DEU","28","42","42","ነ ምꬃነ ነ ቢታ አይፍያ ቦለይ ዉርሳና። ");
INSERT INTO gofe_vpl VALUES ("DT28_43","006_28_43","DEU","28","43","43","ነ ግዶን ደእያ በተ አሳይ ነ ቦላ ꬎቁ ꬎቁ ጋና፥ ሽን ነ ጉየ አታዳ ዝቅ ዝቅ ጋና። ");
INSERT INTO gofe_vpl VALUES ("DT28_44","006_28_44","DEU","28","44","44","እ ነዉ ታልአናፐ አትሽን፥ ነ እያዉ ታልአካ፤ እ ሁጰ ግዳና፤ ኔኒ ጎይና ግዳና። ");
INSERT INTO gofe_vpl VALUES ("DT28_45","006_28_45","DEU","28","45","45","ጎዳ፥ ነ ፆሳ፥ ነ ኪተቶና እፅዳ ግሾነ እያ ዎጋነ ህግያ ናጎና እፅዳ ግሾ፥ ነ ꬋያና ጋካናዉ ሀ ባደꬃት ኡባይ ነ ቦላ ዎꬋና፤ ነና ኤንቲ የደꬃና። ");
INSERT INTO gofe_vpl VALUES ("DT28_46","006_28_46","DEU","28","46","46","ሀ ባደꬃት ነ ቦላነ ነ ኮቻ ቦላ መርናዉ ማላታነ ማላልስያባ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("DT28_47","006_28_47","DEU","28","47","47","ነዉ ሳእ እንጀትዳ ዎደ ጎዳ፥ ነ ፆሳ ኡፋይሳንነ ጋላታን ጎይኖና ግሾ፥ ");
INSERT INTO gofe_vpl VALUES ("DT28_48","006_28_48","DEU","28","48","48","ነና ኮሻን፥ ሳሞን፥ ካሎተꬃንነ መቶን ኡባባ ꬋያዳ፥ ጎዳይ ነ ቦላ የድያ ነ ሞርከታስ ሃረታና። ጎዳይ ነና ꬋይሳና ጋካናዉ ነ ሞርገን ብራታ ቃምባራ ዎꬃና። ");
INSERT INTO gofe_vpl VALUES ("DT28_49","006_28_49","DEU","28","49","49","ጎዳይ ነ ኤንታ ቃላ ኤሮና ካዎተꬃታ፥ ቢታ ጋፃፐ አንኮይ ፕራꬍድ ዎይሳዳ ነ ቦላ ኤሀና። ");
INSERT INTO gofe_vpl VALUES ("DT28_50","006_28_50","DEU","28","50","50","ኤንቲ ዎዛና ምኖታ፤ ጭማ ቦንቾናይሳታ፤ ናይታስ ቃቶናይሳታ። ");
INSERT INTO gofe_vpl VALUES ("DT28_51","006_28_51","DEU","28","51","51","ነ ꬋያና ጋካናዉ ኤንቲ ነ መህያነ ጎሻ አይፍያ ማና። ኔኒ ꬋያና ጋካናዉ ነ ካꬃ፥ ነ ዎይንያ፥ ነ ዛይትያ፥ ነ ሚዛነ ነ ዶርሳ ዉድያ ማሮኮና። ");
INSERT INTO gofe_vpl VALUES ("DT28_52","006_28_52","DEU","28","52","52","ጎዳይ፥ ነ ፆሳይ ነዉ እምያ ቢታን ደእያ ነ አማነትያ አዱሰነ ምኖ ድርሳት ላለታና ጋካናዉ ነ ካታማ ዩሹዋ ተቅድ ነና ኡንኤꬃና። ");
INSERT INTO gofe_vpl VALUES ("DT28_53","006_28_53","DEU","28","53","53","ነ ሞርከት ካታማ ተቅድ ነና ኡንኤꬅያ ዎደ ምያባ ꬋያዳ፥ ጎዳይ ነ ፆሳይ ነዉ እምዳ ነ ኡሎ አይፈ ግድዳ ነ አደ ናይታነ ነ ማጫ ናይታ ማና። ");
INSERT INTO gofe_vpl VALUES ("DT28_54","006_28_54","DEU","28","54","54","ነ ግዶን ሀር አቶሽን ካሰ እንጀን ደእዳ አስካ ባ እሻስ፥ ባ ዶስያ ማቸስነ ባ የልዳ ናይታስ ባ ካꬃፈ ሻከና። ");
INSERT INTO gofe_vpl VALUES ("DT28_55","006_28_55","DEU","28","55","55","ሞርከት ካታማ ተቅድ ኡንኤꬅያ ዎደ ማናባይ ሀር ባይና ግሾ፥ ምያ ባ ናይታ አሹዋፐ ሀራ ኦደስካ እመና። ");
INSERT INTO gofe_vpl VALUES ("DT28_56","006_28_56","DEU","28","56","56","ነ ግዶን ካሰ እንጀን ደእዳ፥ ባ እንጅያፈ ደንዶይሳን ሳአ የꬋናዉ ሻተትያ ማጫስያ፥ ባ ዶስያ አዝናስነ ባ የልዳ ናይታስ ኡዘታና። ");
INSERT INTO gofe_vpl VALUES ("DT28_57","006_28_57","DEU","28","57","57","ሞርከት እያ ደእያ ካታማ ተቅድ እዮ ኡንኤꬅዳ ግሾነ ዋይስዳ ግሾ፥ እዉ ሀር ምያባይ ꬋይን፥ ባ የልዳ ናኣነ ዶኣ ኤንታ ጋꬆና ጌማን ባርካ ማና። ");
INSERT INTO gofe_vpl VALUES ("DT28_58","006_28_58","DEU","28","58","58","ሀ ማፃፋን ፃፈትዳ ህገታ ነ ናጎና እፅኮ፥ ማላልስያነ ያሽያ ጎዳ፥ ነ ፆሳ ሱንꬃ ቦንቾና እፅኮ፥ ");
INSERT INTO gofe_vpl VALUES ("DT28_59","006_28_59","DEU","28","59","59","ነ ቦላነ ነ ኮቻ ቦላ ጎዳይ፥ ያሽያ ጋዶ፥ ዳሮ ዎደ ጋምእያ፥ ፓፆይ ባይና ኢታ ሀርገ የዳና። ");
INSERT INTO gofe_vpl VALUES ("DT28_60","006_28_60","DEU","28","60","60","ካሰ ግብፀ አሳ ቦላ በአዳ፥ ነ ያይዳ ግብፀ ሀርገ ኡባ ዛሪድ ነ ቦላ ኤሀና፤ ሄ ሀርገይ ነና የደና። ");
INSERT INTO gofe_vpl VALUES ("DT28_61","006_28_61","DEU","28","61","61","ጉጅድካ፥ ሀ ህገ ማፃፋን ፃፈትቦና ሀርገታነ ጋዶታ ኡባ ነ ꬋያና ጋካናዉ ጎዳይ ነ ቦላ ኤሀና። ");
INSERT INTO gofe_vpl VALUES ("DT28_62","006_28_62","DEU","28","62","62","ጎዳ፥ ህንተ ፆሳ ህንተ ስኦና እፅዳ ግሾ፥ ሳሎ ፆልንቶዳ ዳርዳ ህንተፈ ጉꬅ አታና። ");
INSERT INTO gofe_vpl VALUES ("DT28_63","006_28_63","DEU","28","63","63","ጎዳይ፥ ህንተዉ ሎኦባ ኦꬅያ ዎደነ ህንተ ታይቦይ ዳርያ ዎደ ኡፋይትዳይሳዳ ሀእ ህንተ ቦላ ጋዶ ኤህያ ዎደነ ህንተና ꬋይስያ ዎደ ኡፋይታና፤ ህንተ ላታናዉ ብያ ቢታፈ ሾደትድ ꬋያና። ");
INSERT INTO gofe_vpl VALUES ("DT28_64","006_28_64","DEU","28","64","64","ጎዳይ ነና ሀ ጋፃፐ ያ ጋፃ ጋካናዉ ካዎተꬃታ ኡባ ግዶን ላላና። ያን ነኒ ዎይኮ ነ ማይዛት ኤሮና ሀራ ምꬅነ ሹቻ ፆሳታ ጎይናና። ");
INSERT INTO gofe_vpl VALUES ("DT28_65","006_28_65","DEU","28","65","65","ሄ ካዎተꬃታ ግዶን ህንተ ሸምፖ ደመከታ፤ ቶሆይ የꬍያ በስካ ነዉ ዴና። ያን ጎዳይ ነዉ ቆፋን ኩምዳ ጉገ፥ አሞን አርጋጭዳ አይፈነ ኡፋይስ ቃንፅዳ ዎዛና እማና። ");
INSERT INTO gofe_vpl VALUES ("DT28_66","006_28_66","DEU","28","66","66","ነ ደኦይ ህርጋን ኩማና፤ ጋላስነ ቃማ ዳጋማንነ ሀይቆ ያሻን ኡንኤታዳ ዳና። ");
INSERT INTO gofe_vpl VALUES ("DT28_67","006_28_67","DEU","28","67","67","ነ ዎዛናን ኩምዳ ያሻፈነ ነ አይፈይ በእያ ፓላባፐ ደንዶይሳን፥ ዎንትያ ዎደ ነኒ፥ “አዉደ ቃማንዴሻ” ቃስ ቃምያ ዎደ፥ “አዉደ ዎንታንደሻ” ያጋና። ");
INSERT INTO gofe_vpl VALUES ("DT28_68","006_28_68","DEU","28","68","68","ታ ነና፥ “ዛራዳ ሀ ኦግያራ ባካ” ግዳ ኦግያራ ጎዳይ ነና ዛሪድ ማርካበን ጉየ ግብፀ የዳና። ያን ነኒ አይለ ግዳናዉ ነ ሞርከታስ ነና ባይዛናዉ ኮያና፥ ሽን ህንተና አይለያናዉ ሻምያ አስ ደመከታ። ");
INSERT INTO gofe_vpl VALUES ("DT29_1","006_29_1","DEU","29","1","1","ጎዳይ ኮሬባ ዙማን፥ እስራኤለ አሳራ ጫቅዳ ጫቁዋ ቦላ ጉጅድ ሞአበን ኤንታራ ጫቃናዉ ሙሰ ኪትዳ ጫቆ ቃላት ሀይሳታ። ");
INSERT INTO gofe_vpl VALUES ("DT29_2","006_29_2","DEU","29","2","2","ሙሰይ እስራኤለ አሳ ኡባ ፄግ ሺሽድ፥ ሀይሳዳ ያግስ። ጎዳይ ግብፀ ካዋ ቦላ፥ እያ ኦላንቾታ ቦላነ እያ ቢታ ኡባ ቦላ ኦꬅዳባነ ጋꬅዳባ ህንተ፥ ህንተ አይፈን በእደታ። ");
INSERT INTO gofe_vpl VALUES ("DT29_3","006_29_3","DEU","29","3","3","ኤንታ ቦላ ጋꬅዳ ኢታ መቶታ፥ ማላልስያባታነ ግታ ማላታታ ህንተ፥ ህንተ አይፈን በእደታ። ");
INSERT INTO gofe_vpl VALUES ("DT29_4","006_29_4","DEU","29","4","4","ሽን ሀች ጋካናዉ ጎዳይ፥ ህንተዉ አኬክያ ዎዛና፥ ፄልያ አይፈነ ስእያ ሀይꬅ እምቤና። ");
INSERT INTO gofe_vpl VALUES ("DT29_5","006_29_5","DEU","29","5","5","ጎዳይ ኦይታሙ ላይꬅ ኩመꬅ ህንተና መላ ቢታን ካለꬅያ ዎደ ህንተ ማኦይ ዉርቤና፥ ህንተ ጫማይ ጭምቤና። ");
INSERT INTO gofe_vpl VALUES ("DT29_6","006_29_6","DEU","29","6","6","ጎዳይ፥ ህንተ ፆሳ ግደይሳ ህንተ ኤራና መላ ኡይꬅ ምቤከታ፤ ዎይነ ዎይኮ ሀራ ማꬆይያ ኡሽ ኡይቤከታ። ");
INSERT INTO gofe_vpl VALUES ("DT29_7","006_29_7","DEU","29","7","7","ኑኒ ሀ በሳ ጋክዳ ዎደ ሀሰቦና ካዎይ ስሆንነ ባሳነ ካዎይ ኦገይ ኑራ ኦለታናዉ ከይዶሶና፥ ሽን ኑኒ ኤንታ ፆንዳ። ");
INSERT INTO gofe_vpl VALUES ("DT29_8","006_29_8","DEU","29","8","8","ኤንታ ቢታ ኤክድ፥ ሮቤላነ ጋደ ኮቻስ፥ ቃስ ምናሰ ኮቻፈ ባጋስ ላታ ኦꬅድ እምዳ። ");
INSERT INTO gofe_vpl VALUES ("DT29_9","006_29_9","DEU","29","9","9","ህንተ ኦይክያባይነ የꬍያባይ ህንተዉ አንጀታና መላ ሀ ጫቆ ቃላታ አማነትድ ናግተ። ");
INSERT INTO gofe_vpl VALUES ("DT29_10","006_29_10","DEU","29","10","10","ሀች ህንተ ኡባይ፥ ኮቻታ ሀላቃት፥ ጭማት፥ ሹማትነ እስራኤለ አሳ ኡባይ ሀይሳን ጎዳ ስንꬃን ኤቅደታ። ");
INSERT INTO gofe_vpl VALUES ("DT29_11","006_29_11","DEU","29","11","11","ህንተ ናይታራ፥ ህንተ ማቸታራ፥ ህንተ ግዶን ደእድ፥ ምꬅ ምፅያነ ሃ ትክያ ሀራ ቢታ አሳራ እስፈ ሀይሳን ኤቅደታ። ");
INSERT INTO gofe_vpl VALUES ("DT29_12","006_29_12","DEU","29","12","12","ጎዳ፥ ህንተ ፆሳራ ቃላ ገላናዉ ሀይሳን ኤቅደታ። ጎዳይ ሀ ቃላ ሀች ህንተራ ጫቆን ምንꬃና። ");
INSERT INTO gofe_vpl VALUES ("DT29_13","006_29_13","DEU","29","13","13","ጎዳይ ህንተና ባ አሰ ኦꬅድ ምንꬃና፤ ህንተዉነ ህንተ ማይዛታስ፥ አብራሃመስ፥ ይሳቃስነ ያይቆባስ ጫቅዳይሳዳ እ ህንተዉ ፆሰ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("DT29_14","006_29_14","DEU","29","14","14","ጎዳይ ሀ ጫቆ ቃላ ኤሰይ ህንተ ፃላላራ ግደና። ");
INSERT INTO gofe_vpl VALUES ("DT29_15","006_29_15","DEU","29","15","15","ሀች ሀይሳን፥ ጎዳ፥ ኑ ፆሳ ስንꬃን ኤቅዳ ኑ ኡባራነ ስንꬃፈ ያና የለታ ኡባራ ኤሴስ። ");
INSERT INTO gofe_vpl VALUES ("DT29_16","006_29_16","DEU","29","16","16","ኑኒ ግብፀን ዋንድ ደእዳኮነ ሀእ ጋካናዉ ኦገን ደእያ ካዎተꬃታ ግዶራ ዋንድ ካንꬅድ ይዳኮ ኤሬታ። ");
INSERT INTO gofe_vpl VALUES ("DT29_17","006_29_17","DEU","29","17","17","ኤንታ ግዶን ደእያ እፀትዳ ምꬃ፥ ሹቻ፥ ብራነ ዎርቃ ኤቃ ምስለታ በእደታ። ");
INSERT INTO gofe_vpl VALUES ("DT29_18","006_29_18","DEU","29","18","18","ሀ ህንተፈ ኦንካ አደ ግድን ማጫ ግድን፥ እስ ሶ አስ ግድን፥ እስ ኮች ግድን ጎዳ፥ ኑ ፆሳፈ፥ ሃክድ ሀራ ካዎተꬃታ ፆሳታ ጎይኖና መላ ናገትተ። ሄሳ መላ ጫምያነ ዎꬍያ አይፈ አይፍያ አስ ህንተ ግዶን ደኦፖ። ");
INSERT INTO gofe_vpl VALUES ("DT29_19","006_29_19","DEU","29","19","19","ሀ ጫቆ ቃላ ስእድ፥ ባ ዎዛናን፥ “ታ ሸነን ታኒ ቢኮካ፥ መቶይ ባዋ” ያግድ ባና ጭምኮ፥ ሄሳ መላ አስ ሎኦታ ቦላነ ኢታታ ቦላ ꬋዮ ኤሄስ። ");
INSERT INTO gofe_vpl VALUES ("DT29_20","006_29_20","DEU","29","20","20","ጎዳ ሀንቆይነ ቃናተይ ሄሳ መላ አሰ ቦላ ኤፅድ ከያና። ሀ ማፃፋን ፃፈትዳ ባደꬅ ኡባይ እያ ቦላ ያና፤ ሳሎፐ ጋርሳን እያ ሱንꬃ ጎዳይ ቁቻና። ");
INSERT INTO gofe_vpl VALUES ("DT29_21","006_29_21","DEU","29","21","21","ጎዳይ ሀ ህገ ማፃፋን ፃፈትዳ ባደꬃ ጫቆ ቃላዳ ሄ ኡራ እስራኤለ ግዶፈ ሻክድ ꬋይሳና። ");
INSERT INTO gofe_vpl VALUES ("DT29_22","006_29_22","DEU","29","22","22","ያና የለተꬃይ፥ ህንተ ሼሻይነ ሃሆ ቢታፈ ያ ሀራ ቢታ አሳይ፥ ጎዳይ ህንተ ቦላ ኤህዳ ጋዱዋነ ሀርግያ በአና። ");
INSERT INTO gofe_vpl VALUES ("DT29_23","006_29_23","DEU","29","23","23","ቢታ ኡባይ ዲነንነ ማፅነን ኩማና፤ ቶከትያባይ ዴና፤ ዶልያባይ በንተና፤ ማትነ ምꬅ ዶለና። ጎዳይ ባ ሀንቆን ꬋይስዳ ሶዶማዳነ ጋሞራዳ፥ አዳማዳነ ፃቦይማ ካታማታዳ ሀናና። ");
INSERT INTO gofe_vpl VALUES ("DT29_24","006_29_24","DEU","29","24","24","ካዎተꬃት፥ “ጎዳይ ሀ ቢታ ቦላ ሀይሳ መላባ አይስ ኦꬅዴ? ሀ ዎልቃማ ሀንቁዋስ ጋሶይ አይቤ?” ያጋና። ");
INSERT INTO gofe_vpl VALUES ("DT29_25","006_29_25","DEU","29","25","25","አሳይ ዛሪድ፥ “ኤንቲ ጎዳይ፥ ኤንታ አዋታ ፆሳይ፥ ኤንታ ግብፀፈ ከስዳ ዎደ ኤንታራ ገልዳ ጫቆ ቃላ መንꬅዳ ግሾሳ። ");
INSERT INTO gofe_vpl VALUES ("DT29_26","006_29_26","DEU","29","26","26","ኤንቲ ኤሮና ፆሳታስነ እ ጎይኖፍተ ግዳ ፆሳታ ጎይንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("DT29_27","006_29_27","DEU","29","27","27","ሄሳ ግሾ፥ ጎዳይ ሀንቀትድ፥ ሀ ማፃፋን ፃፈትዳ ባደꬃታ ኡባ ኤንታ ቦላ ኤህስ። ");
INSERT INTO gofe_vpl VALUES ("DT29_28","006_29_28","DEU","29","28","28","ጎዳይ ዎልቃማ ሀንቆ ሀንቀትድ፥ ኤንታ ቢታፈ ኤንታና ሾድድ ሀራ ቢታ የደꬅስ” ያጋና። ");
INSERT INTO gofe_vpl VALUES ("DT29_29","006_29_29","DEU","29","29","29","ፁራይ ኑ ጎዳ ኑ ፆሳሳ፥ ሽን ኑኒ ሀ ህገ ቃላ ኦꬃና መላ ቆንጭዳይሳት መርናዉ ኑሳነ ኑ ናይታሳ። ");
INSERT INTO gofe_vpl VALUES ("DT30_1","006_30_1","DEU","30","1","1","ሀች ታ ነ ስንꬃን ዎꬅዳ አንጆይነ ባደꬃይ ነ ቦላ ጋክያ ዎደ ጎዳይ፥ ነ ፆሳይ ነና ላልያ ሀራ ካዎተꬃታ ግዶን ደእሸ ሀይሳ ነ አኬክኮ፥ ");
INSERT INTO gofe_vpl VALUES ("DT30_2","006_30_2","DEU","30","2","2","ነነ ነ ናይት ጎዳ፥ ነ ፆሳኮ፥ ስማዳ፥ ነ ኩመꬃ ዎዛናፐነ ነ ኩመꬃ ሸምፑዋፈ ታ ሀች ነና ኪትያ ህግያስ ኪተትኮ፥ ");
INSERT INTO gofe_vpl VALUES ("DT30_3","006_30_3","DEU","30","3","3","ያን ጎዳይ፥ ነ ፆሳይ ነ ድኤትዳ ቢታፈ ነና ዛራና። እ ህንተዉ ቃትድ ህንተና ላልዳ ካዎተꬃታ ኡባ ግዶፈ ዛሪድ ሺሻና። ");
INSERT INTO gofe_vpl VALUES ("DT30_4","006_30_4","DEU","30","4","4","ቢታ ጋፃፐ ጋፃ ጋካናዉ ነ ላለትኮካ፥ ያፐ ጎዳይ፥ ነ ፆሳይ ነና ዛሪድ ሺሻና። ");
INSERT INTO gofe_vpl VALUES ("DT30_5","006_30_5","DEU","30","5","5","ነ አዋት ካሰ ላትዳ ቢታ፥ ነካ ላታና መላ ጎዳይ፥ ነ ፆሳይ ነና ሄ ቢታ ኤሀና። ያን ነና ነ አዋታፐ አꬅድ ዱረያና፤ ነ ታይቡዋ ዳርሳና። ");
INSERT INTO gofe_vpl VALUES ("DT30_6","006_30_6","DEU","30","6","6","ነ ደኦን ዳና መላነ ጎዳ፥ ነ ፆሳ ነ ኩመꬃ ዎዛናፐነ ነ ኩመꬃ ሸምፑዋፈ ዶሳና መላ እ ነዉነ ነ ናይታስ ኪተትያ ዎዛና እማና። ");
INSERT INTO gofe_vpl VALUES ("DT30_7","006_30_7","DEU","30","7","7","ጎዳይ፥ ነ ፆሳይ ሀ ባደꬃታ ኡባ ነ ሞርከታነ ነና ጎደይሳታ ቦላ ኤሀና። ");
INSERT INTO gofe_vpl VALUES ("DT30_8","006_30_8","DEU","30","8","8","ሀች ታ ነና ኪትያ ህግያ ነ ናጋና፤ ዛራዳ ጎዳስ፥ ነ ፆሳስ ኪተታና። ");
INSERT INTO gofe_vpl VALUES ("DT30_9","006_30_9","DEU","30","9","9","ሄ ዎደ ጎዳይ ነ ፆሳይ ነና ነ ኩሸ ኦሶ ኡባን፥ ነ ኡሎ አይፍያን፥ መህያንንነ ነ ጎሻ አይፍያን ነና ዳርስድ አንጃና። ጎዳይ ካሰ ነ አዋታ አንጅድ ኡፋይትዳይሳዳ ነና አንጅድ ኡፋይታና። ");
INSERT INTO gofe_vpl VALUES ("DT30_10","006_30_10","DEU","30","10","10","ሄስ ሀናናይ ሀ ህገ ማፃፋን ፃፈትዳ ጎዳ፥ ነ ፆሳ ህግያነ ዎጋ ናጋዳ፥ ጎዳ፥ ነ ፆሳኮ ነ ኩመꬃ ዎዛናፐነ ነ ኩመꬃ ሸምፑዋፈ ስምኮ። ");
INSERT INTO gofe_vpl VALUES ("DT30_11","006_30_11","DEU","30","11","11","ሀች ታ ነና ኪትያ ኪታት ሄሳ መላ ዴፆ ግዶኮና፤ ኔፐ ሃኮኮና። ");
INSERT INTO gofe_vpl VALUES ("DT30_12","006_30_12","DEU","30","12","12","ኔኒ፥ “ኑኒ ስእድ ኪተታና መላ ሳሎ ከይድ ኑስ ዎꬍሳናይ ኦኔ?” ጎና መላ ሳሎና ግደና። ");
INSERT INTO gofe_vpl VALUES ("DT30_13","006_30_13","DEU","30","13","13","“ኑኒ ስእድ ኪተታና መላ ኑስ አባ ፕንድ ኤሀናይ ኦኔ?” ጎና መላ አባፈ ሄፍንꬃና ግደና። ");
INSERT INTO gofe_vpl VALUES ("DT30_14","006_30_14","DEU","30","14","14","ቃላይ ነዉ ዳሮ ማታን ደኤስ፤ ነ ኦꬃና መላ ቃላይ ነ ዎዛናንነ ነ ዶናን ደኤስ። ");
INSERT INTO gofe_vpl VALUES ("DT30_15","006_30_15","DEU","30","15","15","ሄኮ፥ ታ ሀች ነ ስንꬃን ደኦነ ሎኦተꬅ፥ ሀይቆነ ꬋዮ ዎꬃስ። ");
INSERT INTO gofe_vpl VALUES ("DT30_16","006_30_16","DEU","30","16","16","ነ ጎዳ፥ ነ ፆሳ ዶስኮ፥ እያ ኦግያን ቢኮ፥ እያ ኪታ፥ እያ አዋጁዋነ እያ ህግያ ታግኮ፥ ነ ደኦን ዳናነ ዳራና። ነ ላታናዉ ገልያ ቢታን ጎዳይ፥ ነ ፆሳይ ነና አንጃና። ");
INSERT INTO gofe_vpl VALUES ("DT30_17","006_30_17","DEU","30","17","17","ሽን ነ ዎዛናይ ጎዳፐ ሃክን፥ እያዉ ኪተቶና እፃዳ፥ ሀራ ፆሳታስ ጉፋናዳ ኤንታ ጎይንኮ፥ ");
INSERT INTO gofe_vpl VALUES ("DT30_18","006_30_18","DEU","30","18","18","ህንተ ኡባይ ꬋያናይሳ ታ ሀች ህንተዉ ኦዳይስ። ዮርዳኖሰ ፕንድ ህንተ ላታናዉ ብያ ቢታን ህንተ ላይꬃይ አዱቀና። ");
INSERT INTO gofe_vpl VALUES ("DT30_19","006_30_19","DEU","30","19","19","ታ ህንተ ስንꬃን ደኦነ ሀይቆ፥ አንጆነ ባደꬅ ዎꬅዳይሳስ ሀች ሳሎነ ሳአ ህንተ ቦላ ማርካያና። ህዛ ህንተነ ህንተ ሼሻይ ደኦን ዳና መላ ደኦ ዶርተ። ");
INSERT INTO gofe_vpl VALUES ("DT30_20","006_30_20","DEU","30","20","20","ጎዳ ነ ፆሳ ዶሳ፤ እያ ቃላ ስአ፥ እያዉ ኪተታ፤ እያራ ኦይከታ። ሄሳዳ ሀንኮ፥ ጎዳይ ካሰ ነ ማይዛታስ፥ አብራሃመስ፥ ይሳቃስነ ያይቆባስ እማናዉ ጫቅዳ ቢታን ነነ ነ ሼሻይ አዱሳ ላይꬅ ዳና። ");
INSERT INTO gofe_vpl VALUES ("DT31_1","006_31_1","DEU","31","1","1","ሙሰይ ባ ኦዳ ዉርስዳፐ ጉየ እስራኤለ አሳኮ ሀይሳዳ ያግስ፤ ");
INSERT INTO gofe_vpl VALUES ("DT31_2","006_31_2","DEU","31","2","2","“ሀእ ታዉ ፄታነ ላታሙ ላይꬅ ግድዳ ግሾ፥ ህዛፐ ጉየ ካለꬃናዉ ዳንዳእከ። ጎዳይ ታኮ፥ ‘ነ ዮርዳኖሰ ፕናካ’ ያግስ። ");
INSERT INTO gofe_vpl VALUES ("DT31_3","006_31_3","DEU","31","3","3","ጎዳይ፥ ነ ፆሳይ ነ ስን አꬍድ ነና ካለꬃና። ያን ደእያ ካዎተꬃታ እ ꬋይሳና ግሾ፥ ኤንታ ቢታ ነ ላታና። ጎዳይ ግዳይሳዳ እያሱይ ህንተና ካለꬃና። ");
INSERT INTO gofe_vpl VALUES ("DT31_4","006_31_4","DEU","31","4","4","ጎዳይ አሞረ ካዎታ ስሆናነ ኦገ ፆንድ፥ ኤንታ ቢታ ꬋይስዳይሳዳ ህንተ ሞርከታ ሄሳዳ ኦꬃና። ");
INSERT INTO gofe_vpl VALUES ("DT31_5","006_31_5","DEU","31","5","5","ጎዳይ ኤንታ ህንተዉ አꬅድ እምን፥ ህንተ ኤንታ ቦላ ታ ህንተና ኪትዳይሳዳ ኦꬃና። ");
INSERT INTO gofe_vpl VALUES ("DT31_6","006_31_6","DEU","31","6","6","ምንተ፤ ገንጭተ፤ ያዮፍተ። ኤንታ በእድ ዳጋሞፕተ። ጎዳይ ህንተ ፆሳይ ህንተራ ግዳና፤ እ ህንተና የገና፥ አገና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("DT31_7","006_31_7","DEU","31","7","7","ሙሰይ እያሱ ፄግድ፥ እስራኤለ አሳ ኡባ ስንꬃን ሀይሳዳ ያግስ፤ “ምና፤ ገንጫ። ነ ሀ አሳራ እስፈ ጎዳይ ኤንታ ማይዛታስ እማና ግድ ጫቅዳ ቢታ ገላሳ፤ ሄ ቢታ ኤንታ ላትሳሳ። ");
INSERT INTO gofe_vpl VALUES ("DT31_8","006_31_8","DEU","31","8","8","ጎዳይ፥ እ ባ ሁጰን ኔራ ግድድ ነና ካለꬃና። እ ነና የገና፤ አገና። ሄሳ ግሾ፥ ያዮፋ፤ ኡፋይስ ቃንፆፋ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("DT31_9","006_31_9","DEU","31","9","9","ሙሰይ ሀ ህግያ ፃፍድ፥ ጎዳ ቃላ ጫቆ ታቦትያ ቶክያ ካህነ ግድዳ ሌወ ናይታስነ እስራኤለ ጭማታስ እሚስ። ");
INSERT INTO gofe_vpl VALUES ("DT31_10","006_31_10","DEU","31","10","10","ሙሰይ ኤንታኮ፥ “አጮ ኡባይ አቶ ጌተትያ ላፑንꬃ ላይꬃ ዉርሰꬃን፥ ሻቃራ ባለይ ቦንቸትያ ጋላስ፥ ሀ ህግያ ꬎቁ ኦꬅድ ናባብተ። ");
INSERT INTO gofe_vpl VALUES ("DT31_11","006_31_11","DEU","31","11","11","ጎዳ፥ ህንተ ፆሳ ስንꬃን፥ እ ዶርዳ በሳን፥ እያ ጎይናናዉ እስራኤለ አሳ ኡባይ ሺቅያ ዎደ ኤንታዉ ናባብተ። ");
INSERT INTO gofe_vpl VALUES ("DT31_12","006_31_12","DEU","31","12","12","ኤንቲ ኡባይ ስእድ፥ ጎዳ፥ ህንተ ፆሳስ ያሽ ታማራና መላ ሀ ህገ ቃላ ኡባ ናጋና መላ አደታ፥ ማጫሳታ፥ ናይታነ ህንተ ቢታን ደእያ ሀራ ቢታ አሳ እስፈ ሺሽተ። ");
INSERT INTO gofe_vpl VALUES ("DT31_13","006_31_13","DEU","31","13","13","ሀ ህገ ቃላ ኤሮና ኤንታ ናይትካ ዮርዳኖሰ ፕንድ፥ ህንተ ላታናዉ ብያ ቢታን፥ ህንተ ደእያ ላይꬃ ኡባን ሀ ህግያ ስኦ፤ ጎዳስ፥ ህንተ ፆሳስ፥ ያሽ ታማሮ” ያግድ ኪትስ። ");
INSERT INTO gofe_vpl VALUES ("DT31_14","006_31_14","DEU","31","14","14","ጎዳይ ሙሰኮ፥ “ነ ሀይቅያ ዎደይ ማትስ። እ ካለꬃና ዎጋ ታ እያዉ እማና መላ እያሱ ፄጋዳ፥ እያራ እስፈ ዱንካንያ ፐንገ ሺቅተ” ያግን፥ ሙሰይነ እያሱይ ዱንካንያ ፐንግያኮ ሺቅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("DT31_15","006_31_15","DEU","31","15","15","ጎዳይ ዱንካንያ ፐንገን ኤቅዳ ሻራ ቱሳን ኤንታዉ ቆንጭስ። ");
INSERT INTO gofe_vpl VALUES ("DT31_16","006_31_16","DEU","31","16","16","ጎዳይ ሙሰኮ፥ “ኔኒ ማታ ዎደ ሀይቃዳ ነ አዋታን ጋሄታሳ። ኔፐ ጉየ፥ ሀ አሳይ ታዉ አማነቶናይሳታ ግዳና፤ ታ ኤንታራ ገልዳ ጫቁዋ መንꬃና። ኤንቲ ታና አግድ፥ ባንታ ላትያ ቢታን ደእያ ኤቃታ ካላና። ");
INSERT INTO gofe_vpl VALUES ("DT31_17","006_31_17","DEU","31","17","17","ሄስ ሀንያ ዎደ ታ ሀንቆይ ኤንታ ቦላ ኤፃና፤ ታ ኤንታ አጋጋና፤ ታ ሶምኡዋ ኤንታፈ ሀራ ሶ ዛራና። ኤንቲ ꬋያና፤ ኢታ መቶይነ ꬋዮይ ኤንታ ቦላ ያና። ሄ ዎደ ኤንቲ፥ ‘ቱማ ሀ መቶይ ኑና ጋክዳይ ኑ ፆሳይ ኑ ግዶን ባይና ግሾ ግደኔ?’ ያጋና። ");
INSERT INTO gofe_vpl VALUES ("DT31_18","006_31_18","DEU","31","18","18","ሀራ ፆሳታ ጎይንድ፥ ኤንቲ ኦꬅዳ ኢታ ኦሱዋ ግሾ፥ ታ ሄ ጋላስ ታ ሶምኡዋ ኤንታፈ ሀራ ሶ ዛራና። ");
INSERT INTO gofe_vpl VALUES ("DT31_19","006_31_19","DEU","31","19","19","“ሀእ ሀ ማዝሙርያ ፃፋዳ፥ እስራኤለ አሳ ኡባ ታማርሳ። ሀ ማዝሙረይ ታዉ እስራኤለ አሳ ቦላ ማርካ ግዳና መላ ኤንታ የፅሳ። ");
INSERT INTO gofe_vpl VALUES ("DT31_20","006_31_20","DEU","31","20","20","ኤንታ ማይዛታስ ገልዳ ቃላዳ፥ ማꬅነ ኤስ ጎግያ ቢታ ታ ኤንታ ገልሳ ስምን፥ ኤንቲ ም ካልድ ጎብዳፐ ጉየ፥ ሀራ ፆሳታ ጎይንድ፥ ታና ካꬋና፤ ታ ጫቁዋ መንꬃና። ");
INSERT INTO gofe_vpl VALUES ("DT31_21","006_31_21","DEU","31","21","21","ዳሮ መቶይነ ꬋዮይ ኤንታ ቦላ ጋክዳ ዎደ ሀ ማዝሙረይ ኤንታ ናይታፐ ባለቶና ግሾ፥ ኤንታ ቦላ ማርካ ግዳና። ታኒ ጫቅዳ ቢታ ኤንታ ቡሮ ገልሶና ደእሽን፥ ሃራ ኤንቲ ቆፕያ ቆፋ ታኒ ኤራይስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("DT31_22","006_31_22","DEU","31","22","22","ሙሰይ ሄ ጋላስ ማዝሙርያ ፃፍድ፥ እስራኤለ አሳ ታማርስስ። ");
INSERT INTO gofe_vpl VALUES ("DT31_23","006_31_23","DEU","31","23","23","ሄሳፈ ጉየ፥ ጎዳይ ናወ ናኣ እያሱኮ፥ “ምና፥ ገንጫ፤ ታ ኤንታዉ እማናዉ ቃላ ገልዳ ቢታ እስራኤለ አሳ ኤፋዳ ገልሳ። ታ ኔራ ግዳና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("DT31_24","006_31_24","DEU","31","24","24","ሙሰይ ሀ ህገታ ኮይሮፐ ዉርሰꬅ ጋካናዉ ፃፍድ ዉርስዳፐ ጉየ፥ ");
INSERT INTO gofe_vpl VALUES ("DT31_25","006_31_25","DEU","31","25","25","ጎዳ፥ ቃላ ጫቆ ታቦትያ ቶክያ ሌወታ ሀይሳዳ ያግድ ኪትስ፤ ");
INSERT INTO gofe_vpl VALUES ("DT31_26","006_31_26","DEU","31","26","26","“ጎዳ ህገይ ፃፈትዳ ሀ ማፃፋ ኤፍድ፥ ጎዳ፥ ህንተ ፆሳ ቃላ ጫቆ ታቦትያ ማታን ዎꬅተ። ያን እ ህንተ ቦላ ማርካ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("DT31_27","006_31_27","DEU","31","27","27","ህንተ አይ መላ ጌለኮነ ዎዛና ኢተኮ ታ ኤራይስ። ቱማ፥ ታ ህንተራ ደእዳ ላይꬃ ኡባን ህንተ ጎዳስ ማካላታ፥ ሽን ታ ሀይቅን፥ ኡባ ዋንድ ማካላንደቲ? ");
INSERT INTO gofe_vpl VALUES ("DT31_28","006_31_28","DEU","31","28","28","ሄሳ ግሾ፥ ሀይሳ ኡባ ታ ኤንታዉ ኦዳናዉነ ሳሎነ ሳአ ታ ኤንታ ቦላ ማርካያናዉ ህንተ ኮቻ ሀላቃታነ ደርያ ካለꬅያ አሳ ኡባ ታዉ ሺሽተ። ");
INSERT INTO gofe_vpl VALUES ("DT31_29","006_31_29","DEU","31","29","29","ታ ሀይቅዳፐ ጉየ፥ ህንተ ቱማ ኢታ አሰ ግዳናይሳነ ታኒ ህንተና ታማርስዳ ኪታፐ ሀራ ሶ ስማናይሳ ታኒ ኤራይስ። ህንተ እያ ስንꬃን ኢታባ ኦꬅድ፥ ጎዳ ይሎይያ ግሾ፥ ዎደፐ እ ህንተ ቦላ ኢታ ጋዶ ኤሀና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("DT31_30","006_31_30","DEU","31","30","30","ሄሳፈ ጉየ፥ ሙሰይ ሀ ማዝሙረ ቃላታ ዉራና ጋካናዉ ሺቅዳ እስራኤለ ማባራ ኡባ ናባብድ ስስስ። ");
INSERT INTO gofe_vpl VALUES ("DT32_1","006_32_1","DEU","32","1","1","ሳሎቶ፥ ታኒ ኦደይሳ ስእተ፤ ቢታይ ታ ዶና ቃላ ሀይዞ። ");
INSERT INTO gofe_vpl VALUES ("DT32_2","006_32_2","DEU","32","2","2","ታ ትምርተይ እራ መላ ቡኮ፤ ታ ቃላይ አካዳ ዎꬎ። ማታ ቦላ ዎꬍያ ፃሳዳ ዶላ ቦላ ዎꬍያ ፑሰዳ ዎꬎ። ");
INSERT INTO gofe_vpl VALUES ("DT32_3","006_32_3","DEU","32","3","3","ታኒ ጎዳ ሱንꬃ አዋጃና፤ ግታተꬃ ኑ ፆሳስ እምተ። ");
INSERT INTO gofe_vpl VALUES ("DT32_4","006_32_4","DEU","32","4","4","እ ኑ ዛላ፤ እያ ኦሶይ ፖሎ፤ እያ ኦገይ ሱረ። ፆሳይ አማንይሳ፤ ዎርዶይ ባይናይሳ፤ እ ቱማንቾነ ሱረ። ");
INSERT INTO gofe_vpl VALUES ("DT32_5","006_32_5","DEU","32","5","5","እያ ስንꬃን ባንታ ቱናተꬃ በስዶሶና፤ ኤንቲ እያ ናአ ግዶኮና፤ ኤንቲ ኢታነ ጌላ የለተꬅ። ");
INSERT INTO gofe_vpl VALUES ("DT32_6","006_32_6","DEU","32","6","6","ህንተኖ፥ ኤያነ አኬክ ባይና አሳዉ፥ ህንተ ጎዳስ እምያ ዛሮይ ሀይሴ? እ ህንተና መꬍዳ ህንተ አዋ ግደኔ? ህንተና መꬍድ ምንꬅ ኤስዳይ እያ ግደኔ? ");
INSERT INTO gofe_vpl VALUES ("DT32_7","006_32_7","DEU","32","7","7","በን ዎድያ ቆፓ፤ አꬍዳ የለተꬃ አኬካ። ነ አዋ ኦይቻ፤ እ ነዉ ኦዳና፤ ጭማታ ኦይቻ፤ ኤንቲ ነዉ ቆንጭሳና። ");
INSERT INTO gofe_vpl VALUES ("DT32_8","006_32_8","DEU","32","8","8","ኡባፈ ዎልቃማይ ካዎተꬃታስ ኤንታ ላታ ሻክዳ ዎደ፥ አሳ ዘረꬅካ ዱማይዳ ዎደ፥ እስራኤለ አሳ ታይቡዋ መላ፥ አሳስ ኤንታ ዛዋ ኤስስ። ");
INSERT INTO gofe_vpl VALUES ("DT32_9","006_32_9","DEU","32","9","9","ጎዳ ጋክዳ ግሾይ እስራኤለ፤ ያይቆብ እያ ጋክዳ ላታ። ");
INSERT INTO gofe_vpl VALUES ("DT32_10","006_32_10","DEU","32","10","10","እ ኤንታ መላ ቢታን፥ አይኮይ ባይና መላ ቢታን፥ ጫርኮይ ባቅሽን ደምስ። እያዉ ጎንዳለ ግድስ፥ እያ ናግስ፤ ባ አይፈ ናኤዳ ምንꬅድ ናግስ። ");
INSERT INTO gofe_vpl VALUES ("DT32_11","006_32_11","DEU","32","11","11","አርጋንꬅ ባ ናአ ፓሎ ታማርሰይሳዳ፥ ባ ምጭዳ ቀፍያን ጋክድ አሸይሳዳ፥ ጎዳይ ባ ቀፍያን ሀጵድ ኤንታ አሽስ። ");
INSERT INTO gofe_vpl VALUES ("DT32_12","006_32_12","DEU","32","12","12","ጎዳይ ባ ፃላላ ኤንታ ካለꬅስ፤ ሀራ አላጋ ፆሲ እያራ ባዋ። ");
INSERT INTO gofe_vpl VALUES ("DT32_13","006_32_13","DEU","32","13","13","እ ቢታስ ꬎቃ በሳ ኤንታ ከስስ፤ ጎሻ አይፍያ ኤንታ ሙዝስ። ዛላ ቆጶፐ ኤንታ ኤስ ካልስስ፤ ሹቻ ቢታፈ በንትያ ዛይተ ኡሽስ። ");
INSERT INTO gofe_vpl VALUES ("DT32_14","006_32_14","DEU","32","14","14","ኤንታ መህያፐ ቄሳ ማꬅ፥ ዶርሳፈነ ዴሻፐ ፃማታ ማꬅ፥ ሞꬎ ዶርሰነ ዴሻ አሾ ምዶሶና። ባሳነ ዶርሳነ ዴሻ አሹዋ፥ ሎኦ ግስተ ኡይꬃራ ምዶሶና፤ ሱꬅ ዳንያ ዎይነ ኡሻ ኡይዶሶና። ");
INSERT INTO gofe_vpl VALUES ("DT32_15","006_32_15","DEU","32","15","15","ሽን እስራኤለይ ኦርድስ፤ ማካልስ፤ ምድ ካልድ ሞሎትስ። ባና መꬍዳ ፆሳ አግስ፤ ባ አቶተꬃ ዛላ ካዉሽስ። ");
INSERT INTO gofe_vpl VALUES ("DT32_16","006_32_16","DEU","32","16","16","ኤንቲ አላጋ ፆሳታ ጎይንድ፥ እያ ቃናትስዶሶና። እፀትዳ ባንታ ኤቃታን እያ ሀንቀꬅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("DT32_17","006_32_17","DEU","32","17","17","ፆሰ ግዶናይሳታስ፥ ካሰ ኤንቲ ኤሮና ፆሳታስ፥ ዝነ ደንድዳይሳታስ፥ ኤንታ አዋት ጎይንቦና ፆሳታስ ያርሽዶሶና። ");
INSERT INTO gofe_vpl VALUES ("DT32_18","006_32_18","DEU","32","18","18","ኤንታዉ ደኦ እምያ ዛላ ዶግዶሶና፤ የልድ ድችዳ ፆሳ አግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("DT32_19","006_32_19","DEU","32","19","19","አደ ናይትነ ማጫ ናይት እያ ይሎይዶሶና፤ ጎዳይ ሄሳ በእድ ኤንታ ካꬍስ። ");
INSERT INTO gofe_vpl VALUES ("DT32_20","006_32_20","DEU","32","20","20","እ፥ “ኤንቲ ጌላነ አማነቶና ደረ ግድያ ግሾ፥ ታኒ ታ ሶምኡዋ ኤንታፈ ገንꬃና፤ ኤንታ ዉርሰꬃ ስእ ጋዳ በአና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("DT32_21","006_32_21","DEU","32","21","21","ፆሰ ግዶናይሳታን ታና ቃናትስዶሶና፤ ባንታ ኤቃታን ታና ይሎይዶሶና። ታኒ ኤንታ ካትዳ አሳን ቃናትሳና፤ ኤያ አሳን ኤንታ ይሎያና። ");
INSERT INTO gofe_vpl VALUES ("DT32_22","006_32_22","DEU","32","22","22","ታ ሀንቆይ ታማዳ ኤፃና፤ ስኦለ ጋካናዉ ፁጋና። ቢታን ደእያባ ኡባ ማና፥ ደርያ ባሱዋ ጋካናዉ ፁጋና። ");
INSERT INTO gofe_vpl VALUES ("DT32_23","006_32_23","DEU","32","23","23","“ታኒ ኤንታ ቦላ መቶ ዶራና፤ ታ ዶንግያን ኤንታ ዱካና። ");
INSERT INTO gofe_vpl VALUES ("DT32_24","006_32_24","DEU","32","24","24","ታ ኤንታ ቦላ ኢታ ኮሻ የዳና፤ ኤንቲ ሀርገንነ ጋዶን ዉራና። ኤንታ ቦላ ኢታ ባዞ ዶአታነ ዱክድ ዎꬍያ ኢታ ሾሻታ የዳና። ");
INSERT INTO gofe_vpl VALUES ("DT32_25","006_32_25","DEU","32","25","25","ኤንታ፥ ማሽ ኦገ ቦላ ዉርሳና፤ ኬꬃ ጋርሳን ዳጋም ካዎታና። ናአተꬃ አደትነ ማጫት ዉራና፤ ጉꬃ ናይትነ ጭማት አቶኮና። ");
INSERT INTO gofe_vpl VALUES ("DT32_26","006_32_26","DEU","32","26","26","ታ ኤንታ ꬋይሳናዉነ ኤንታ ሀሳይያ አስ ዶና መላ ኦꬃናዉ ቆፓስ። ");
INSERT INTO gofe_vpl VALUES ("DT32_27","006_32_27","DEU","32","27","27","ሽን ኤንታ ሞርከት፥ ‘ፆንዳይ ኑና፤ ሀ ኡባ ኦꬅዳይ ጎዳ ግደና፤ ያግድ ኦቶሮን ጬቀቶና መላ ጋዳ አጋጋስ’ ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("DT32_28","006_32_28","DEU","32","28","28","እስራኤለ አሳይ ዎዛን ባይና አስ፤ ኤንቲ አኬኮኮና። ");
INSERT INTO gofe_vpl VALUES ("DT32_29","006_32_29","DEU","32","29","29","ኤንቲ ጭንጭድ አኬክዳኮ ሀይሳ ኤራና፥ ባንታ ዉርሰꬃካ ሻካናሽን። ");
INSERT INTO gofe_vpl VALUES ("DT32_30","006_32_30","DEU","32","30","30","ጎዳይ ኤንታ ፆሳይ ኤንታ ባይዞናኮ፥ ኤንታ መꬍዳ ዎልቃማይ አꬅድ እሞናኮ፥ ዋትድ እስ አስ ሙኩሉ አሳ፥ ኑምኡ አስ ታሙ ሙኩሉ አሳ ፆኒ? ");
INSERT INTO gofe_vpl VALUES ("DT32_31","006_32_31","DEU","32","31","31","ኑ ዛላይ ኑ ሞርከታ ዛላ መላ ግዶናይሳ ኤንቲ ኤሮሶና። ");
INSERT INTO gofe_vpl VALUES ("DT32_32","006_32_32","DEU","32","32","32","ኤንታ ዎይነይ ሶዶመ ዎይንያፐ ዬስ፥ ኤንቲ ጋሞራ ጎሻን ዶልዶሶና፤ አይፍያን ማርዘይነ ጫሞይ ኩምስ። ");
INSERT INTO gofe_vpl VALUES ("DT32_33","006_32_33","DEU","32","33","33","ኤንታ ዎይነይ ሾሻ ማርዘ፤ ዎꬍያ ሶጎ። ");
INSERT INTO gofe_vpl VALUES ("DT32_34","006_32_34","DEU","32","34","34","ጎዳይ፥ “ታ ሄሳ ዶጋድና? ታ ማዝጋበን ፃፋብክና? ");
INSERT INTO gofe_vpl VALUES ("DT32_35","006_32_35","DEU","32","35","35","ኤንታዉ ꬋዮ ጋላስ ማትስ፤ ኤንታ ቦላ ጋካናባይ ኤለሴስ። ሄ ዎደ ኤንታ ቶሆይ ꬉበታና፤ ታ ሀሎ ከያናነ ኩሸ ዛራና።” ");
INSERT INTO gofe_vpl VALUES ("DT32_36","006_32_36","DEU","32","36","36","ኤንታ ዎልቃይ ዉርዳይሳነ ኤንታ ማድያ አስ ባይናይሳ በእዳ ዎደ፥ ጎዳይ ባ አሳስ ፕርዳና፤ ባ አይለታስ ቃታና። ");
INSERT INTO gofe_vpl VALUES ("DT32_37","006_32_37","DEU","32","37","37","ፆሳይ ኤንታኮ፥ “ኤንቲ አማነትያ ኤንታ ፆሳት አዉኔ? ኤንቲ ባቃትድ ቆሰትያ ኤንታ ዛላይ አዉኔ?” ያጋና። ");
INSERT INTO gofe_vpl VALUES ("DT32_38","006_32_38","DEU","32","38","38","ኤንታ ሞꬎ ያርሹዋ ምዳይሳት፥ ኤንታ ዎይነ ኡሻ ያርሹዋ ኡይዳይሳት፥ ሀእ ደንድድ ኤንታ ማዶ፤ ኤንታ አሾ። ");
INSERT INTO gofe_vpl VALUES ("DT32_39","006_32_39","DEU","32","39","39","“ቱማ፥ ጎድ ታና፤ ፆሲ ታ ፃላላ፤ ታፐ አትሽን፥ ሀራ ፆሲ ባዋ። ዎይነ ፓይ ታና፤ ታ ማዱንፅሳይስ፤ ታ ፓꬃይስ፤ ታ ኩሸፐ ኦንካ አሸና። ");
INSERT INTO gofe_vpl VALUES ("DT32_40","006_32_40","DEU","32","40","40","ታ ኩሽያ ደንꬃዳ ሀይሳዳ ያጋና፤ ታኒ መርናዉ ደኦ፤ ");
INSERT INTO gofe_vpl VALUES ("DT32_41","006_32_41","DEU","32","41","41","ጶልያ ታ ማሻ ሌፋዳ፥ ፕርዳናዉ ታ ኩሸን ኦይክያ ዎደ፥ ታ ሞርከታ ቦላ ታ ሀሎ ከያና፤ ታና እፀይሳታስ ኩሸ ዛራና። ");
INSERT INTO gofe_vpl VALUES ("DT32_42","006_32_42","DEU","32","42","42","ታ ዶንገይ ኤንታ ሱꬃን ማꬆታና፤ ታ ማሻይ ኤንታ አሹዋ ማና። ታና እፅያ ኡባ ማርከ፤ ማዱንፅዳይሳትነ ድኤትዳይሳት ሀይቃና።” ");
INSERT INTO gofe_vpl VALUES ("DT32_43","006_32_43","DEU","32","43","43","ካዎተꬃቶ፥ ጎዳ አሳራ ኡፋይትተ፤ እ ባ አይለታ ሱꬃ አጫና። ባ ሞርከታ ቦላ ሀሎ ከያና፤ ቢታን ደእያ ባ አሳ ናጋራ አቶ ጋና። ");
INSERT INTO gofe_vpl VALUES ("DT32_44","006_32_44","DEU","32","44","44","ሙሰይነ ናወ ናአይ እያሱይ እስራኤለ አሳ ሺሽድ፥ ሀ ማዝሙርያ ኡባ አሳይ ስእሽን የፅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("DT32_45","006_32_45","DEU","32","45","45","ሙሰይ ሀ ቃላ ኡባ እስራኤለ አሳስ ኦድ ዉርስዳፐ ጉየ፥ ");
INSERT INTO gofe_vpl VALUES ("DT32_46","006_32_46","DEU","32","46","46","ኤንታኮ፥ “ሀ ህገ ቃላ ኡባ ህንተ ናይት ናጋና መላነ ኪተታና መላ ሀች ታ ህንተዉ ማርካ ኦꬃዳ እምያ ቃላ ኡባ ህንተ ዎዛናን ዎꬅተ። ");
INSERT INTO gofe_vpl VALUES ("DT32_47","006_32_47","DEU","32","47","47","ሀ ቃላይ ህንተዉ ደኦፐ አትሽን፥ ጮ ቃላ ግደና። ህንተ ሀ ቃላ ናግኮ፥ ዮርዳኖሰ ፕንድ ላታና ቢታን አዱሳ ላይꬅ ዳና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("DT32_48","006_32_48","DEU","32","48","48","ሄ ጋላስ ጎዳይ ሙሰ ሀይሳዳ ያግስ፤ ");
INSERT INTO gofe_vpl VALUES ("DT32_49","006_32_49","DEU","32","49","49","“ሞአበን፥ እያርኮ ካታማፐ ስንꬃ ባጋራ ደእያ አባሪማ ዙማታፐ እሱዋ ግድዳ ናቦ ዙማ ቦላ ከያ፤ ያን እስራኤለ አሳ ታ ላትሳና፥ ካናነ ቢታ ሃሆን ፄላ። ");
INSERT INTO gofe_vpl VALUES ("DT32_50","006_32_50","DEU","32","50","50","ነ እሻ አሮን ሆራ ዙማ ቦላ ሀይቅድ፥ ባ ማይዛታ ጋክዳይሳዳ ነካ ሀ ዙማ ቦላ ሀይቃዳ ነ ማይዛታ ጋካና። ");
INSERT INTO gofe_vpl VALUES ("DT32_51","006_32_51","DEU","32","51","51","ህንተ ናምአይ እስራኤለ አሳ ስንꬃን ታዉ አማነትበከታ። ሲና መላ ቢታን፥ ቃደሳ ማታን ደእያ ማርባ ሃꬃ ማታን ታ ጌሻተꬃ እስራኤለ አሳ በስበከታ። ");
INSERT INTO gofe_vpl VALUES ("DT32_52","006_32_52","DEU","32","52","52","ሄሳ ግሾ፥ ኔኒ ሄ ቢታ ሃሆን ፄላናፐ አትሽን፥ ታ እስራኤለ አሳ ላትሳና ቢታ ገላካ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("DT33_1","006_33_1","DEU","33","1","1","ፆሳ አስ ግድዳ ሙሰይ ሀይቃናፐ ስን፥ እስራኤለ አሳ አንጅዳ አንጆ ቃላይ ሀይሳ። ");
INSERT INTO gofe_vpl VALUES ("DT33_2","006_33_2","DEU","33","2","2","ሙሰይ፥ “ጎዳይ ሲና ዙማፐ ይስ፤ ሳይረ ዙማፐ ኑ ቦላ ፖእስ። ፓራና ዙማፐ ጶልስ። ሙኩላን ታይበትያ ኪታንቾት እያራ ደኦሶና፤ እያ ኡሻቻን ታማ ላጮይ ደኤስ። ");
INSERT INTO gofe_vpl VALUES ("DT33_3","006_33_3","DEU","33","3","3","ጎዳዉ ኔኒ ነ አሳ ዶሳዳሳ፤ ጌሻት ኡባይ ነ ኩሸን ደኦሶና። ነ ቶሁዋ ጋርሳን ኡባይ ጉልባትድ ጎይኖሶና፤ ኔፐ ኪታ ኤኮሶና። ");
INSERT INTO gofe_vpl VALUES ("DT33_4","006_33_4","DEU","33","4","4","ሙሰይ እምዳ ህግያ እስራኤለ አሳ ላታ ኤኮሶና። ");
INSERT INTO gofe_vpl VALUES ("DT33_5","006_33_5","DEU","33","5","5","እስራኤለ ዘረꬃት ደርያ ሀላቃታራ ሺቅዳ ዎደ፥ ጎዳይ ባ አሳ፥ እስራኤለ ቦላ ካዎትስ። ");
INSERT INTO gofe_vpl VALUES ("DT33_6","006_33_6","DEU","33","6","6","“ሮቤላ ኮቻይ ታይቦን ጉꬃ ግድኮካ፥ እ ሀይቆፎ፤ ፓፃ ደኦ።” ");
INSERT INTO gofe_vpl VALUES ("DT33_7","006_33_7","DEU","33","7","7","ሙሰይ ይሁዳ ኮቻባ፥ “ጎዳዉ፥ ይሁዳ ዋሱዋ ስአ፤ ሀንኮ እያ ያራታራ እያ ቡአ። ኤንታ ኩሽያ ምንꬃ፤ ኤንቲ ባንታ ሞርከታራ ኦለትያ ዎደ ኤንታ ማዳ። ");
INSERT INTO gofe_vpl VALUES ("DT33_8","006_33_8","DEU","33","8","8","ሙሰይ ሌወ ኮቻባ፥ ነ ቱሚመይነ ኡሪመይ፥ ኔኒ ማሳሀን ፓጭዳነ ማርባን ፓላምዳ፥ ነ ጌሻ አሳሳ። ");
INSERT INTO gofe_vpl VALUES ("DT33_9","006_33_9","DEU","33","9","9","ባንታና የልዳይሳታፐ፥ ባንታ እሻታፐነ ባንታ ናይታፐ አꬅድ፥ ኤንቲ ነዉ አማነትዶሶና፤ ነ ጫቆ ቃላ ናግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("DT33_10","006_33_10","DEU","33","10","10","ኤንቲ ነ ዎጋ ያይቆባ፥ ነ ህግያ እስራኤለ ታማርሶሶና። ኤንቲ ነ ስንꬃን እፃነ ጩይሶሶና፤ ያርሾ በሳን ፁሳ ያርሾ ያርሾሶና። ");
INSERT INTO gofe_vpl VALUES ("DT33_11","006_33_11","DEU","33","11","11","አቤት ጎዳዉ፥ ሌወታ አንጃ፤ ኤንታ ኩሸ ኦሱዋን ነ ኡፋይታ። ኤንታ ቦላ ደንድያ ሞርከታ መንረꬃ ዛር ደንዶና መላ ኤንታ ሞርከታ ጫዳ።” ");
INSERT INTO gofe_vpl VALUES ("DT33_12","006_33_12","DEU","33","12","12","ብንያመ ኮቻባ፥ “ጎዳን ዶሰትዳይ እያን አማነትድ ደኤስ፤ ቃማ ጋላስ እ ኤንታ ናጌስ፤ ባ ሀሽያን ቶክድ ሸምፕሴስ።” ");
INSERT INTO gofe_vpl VALUES ("DT33_13","006_33_13","DEU","33","13","13","ዮሰፋ ኮቻባ፥ “ጎዳይ፥ ሳሎፐ እራን፥ ሳአፐ ፑልቶ ሃꬃን ኤንታ ቢታ አንጆ። ");
INSERT INTO gofe_vpl VALUES ("DT33_14","006_33_14","DEU","33","14","14","አዋን ካፅድ ዶረትዳ አይፈንነ ዎደን ዎደን ካፅያ አይፈን አንጀቶ። ");
INSERT INTO gofe_vpl VALUES ("DT33_15","006_33_15","DEU","33","15","15","በንፐ ደእያ ደረትነ ዙማት ሎኦ አይፈን አንጀቶ። ");
INSERT INTO gofe_vpl VALUES ("DT33_16","006_33_16","DEU","33","16","16","ኤንታ ቢታይ ሎኦባይ ኩምዳ ቢታ ግዶ፤ ቱሽያ ግዶን ኤፅያ ታማን ቆንጭዳ ጎዳይ እያ አንጆ። ሀ አንጆት ኡባይ ዮሰፋ ኮቻ ጋኮ፤ እ ባ እሻታ ግዶን ሀላቃ ግዶ። ");
INSERT INTO gofe_vpl VALUES ("DT33_17","006_33_17","DEU","33","17","17","ዮሰፍ ኮይሮ የለትዳ ኮርማዳ ምኖ፤ እያ ካጨት መንꬃ ካጨዳ ምኖ። እያ ካጨት ታሙ ሙኩሉን ታይበትያ ኤፍሬማ ኮቻታ፤ ሙኩላን ታይበትያ ምናሰ ኮቻታ። ሄ ካጨታን እ ካዎተꬃታ ቃይጫና፤ ቢታ ጋፃ ጋካናዉ እ ኤንታ ሱጋና።” ");
INSERT INTO gofe_vpl VALUES ("DT33_18","006_33_18","DEU","33","18","18","ዛብሎና ኮቻባ፥ “ዛብሎና፥ ኔኒ ነ ከሳን ኡፋይታ፤ ይሳኮራ፥ ኔኒ ነ ዱንካንያን ኡፋይታ። ");
INSERT INTO gofe_vpl VALUES ("DT33_19","006_33_19","DEU","33","19","19","ኤንቲ አሳ ባንታ ዙማኮ ፄጋና፤ ያን ኤንቲ ጌሻተꬃ ያርሾ ያርሻና። ባንታ አቁዋነ ባንታ ዱረተꬃ፥ አባፈነ አባ ጋፃን ደእያ ሻፍያፐ ደማና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("DT33_20","006_33_20","DEU","33","20","20","ጋደ ኮቻባ፥ “ኤንታ ቢታ ዳልግስዳ ጎዳይ ጋላተቶ፤ ጋድ ሞርከ ሶምኦ ዎይኮ ቀሰ መንꬃናዉ፥ ጋሞዳ ናጌስ። ");
INSERT INTO gofe_vpl VALUES ("DT33_21","006_33_21","DEU","33","21","21","ኤንቲ ሎኦ ቢታ ባንታዉ ዶርዶሶና፤ ሀላቃታስ ግዳ ቢታ ኤንቲ ኤክዶሶና። እስራኤለ ሀላቃት ሺቅዳ ዎደ፥ ጎዳ ጌሻ ሸንያ ሻክድ ኤርዶሶና እስራኤለስ ሱረ ፕርዳ ፕርድዶሶና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("DT33_22","006_33_22","DEU","33","22","22","ዳነ ኮቻባ፥ “ዳነይ ዎዳላ ጋሞ መላ፤ እ ባሳነፐ ጉፕድ ከያና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("DT33_23","006_33_23","DEU","33","23","23","ንፍታለመ ኮቻባ፥ “ንፍታለመይ ጎዳ አꬎ ኬሀተꬃን፥ እያ አንጁዋን ዱረትስ፤ ኤንታ ቢታይ አባፈ ዱገሀ ባጋ ጋኬስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("DT33_24","006_33_24","DEU","33","24","24","አሴራ ኮቻባ፥ “አሴር ሀራ ኮቻታፐ አꬍድ አንጀትዳይሳ፤ ባ እሻታን ዶሰትዳይሳ ግዶ፤ እያ ቢታይ ሻማሆ ዛይተን ዱረቶ። ");
INSERT INTO gofe_vpl VALUES ("DT33_25","006_33_25","DEU","33","25","25","እያ ካታማት ብራታ ፐንገን ጎርደትድ ናገቶ፤ ባ ላይꬃ ኡባን እ ዎልቃማ ግዶ። ");
INSERT INTO gofe_vpl VALUES ("DT33_26","006_33_26","DEU","33","26","26","እስራኤለ፥ ሳሎፐ ነና ማዳናዉ፥ ባ ግታተꬃን ሻራ ቦላ ሄመትያ፥ ነ ፆሳ መላ ፆሲ ኦኔ? ");
INSERT INTO gofe_vpl VALUES ("DT33_27","006_33_27","DEU","33","27","27","መርና ፆሳይ ነ ደእያ በሲ፤ እያ መርና ኩሸት ኔፐ ጋርሳራ ደኦሶና። እ ነ ሞርከታ ነ ስንꬃፈ ከስድ፥ ‘ኤንታ ꬋይሳ’ ያግስ። ");
INSERT INTO gofe_vpl VALUES ("DT33_28","006_33_28","DEU","33","28","28","ሄሳ ግሾ፥ እስራኤለ ኮቻይ፥ ሳሎ እራይ ቡክያ በሳን፥ ካꬅነ ዎይነይ ኩምዳ ቢታን፥ ህርግ ባይና ሳሮ ዳና። ");
INSERT INTO gofe_vpl VALUES ("DT33_29","006_33_29","DEU","33","29","29","እስራኤለ፥ ነ አንጀታዳይሳ፤ ጎዳይ አሽዳ ነ መል ኦኔ? እ ነዉ ጎንዳለነ ማድያ ማሻ፤ ነ ሞርከት ነ ስንꬃን ጉፋናና፤ ነ ኤንታ ባሱዋ ላላና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("DT34_1","006_34_1","DEU","34","1","1","ሙሰይ ሞአበ ደምባፈ ደንድድ፥ ናቦ ዙማ ሁጵያ፥ ቃስ እያርኮፈ ዶሎሀ ባጋራ ደእያ ፕስጋ ዙማ ሁጵያ ጋክስ። ያን ጎዳይ ዳነ ጋካናዉ ደእያ ጋላዳ ቢታ፥ ");
INSERT INTO gofe_vpl VALUES ("DT34_2","006_34_2","DEU","34","2","2","ንፍታለመ ቢታ ኡባ፥ ኤፍሬመነ ምናሰ ቢታ፥ ዉሎሀ ባጋራ ብድ መደትራነ አባ ጋካናዉ ደእያ ይሁዳ ቢታነ ");
INSERT INTO gofe_vpl VALUES ("DT34_3","006_34_3","DEU","34","3","3","ዱገሀ ባጋራ ዞኣረፐ ደንድድ፥ ዛምብ ደእያ እያርኮ ካታማ፥ ዛንጋራን ደእያ ደምባ ኡባ በስስ። ");
INSERT INTO gofe_vpl VALUES ("DT34_4","006_34_4","DEU","34","4","4","ጎዳይ ሙሰኮ፥ “ታኒ ህንተ ሼሻስ እማና ጋዳ አብራሃመስ፥ ይሳቃስነ ያይቆባስ፥ ጫቅዳ ቢታይ ሀይሳ። ሀእ ኔኒ ነ አይፈን በአና መላ ኦꬃስ፥ ሽን ኔኒ ያ ፕናካ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("DT34_5","006_34_5","DEU","34","5","5","ጎዳ አይለይ፥ ሙሰይ፥ ጎዳይ ግዳይሳዳ፥ ያን ሞአበ ቢታን ሀይቅስ። ");
INSERT INTO gofe_vpl VALUES ("DT34_6","006_34_6","DEU","34","6","6","ጎዳይ ቤት-ፓኦራ ካታማፐ ስንꬃ ባጋን ሞአበ ዛንጋራን እያ ሞግስ። ሽን ሀች ጋካናዉ እ ሞገትዳ ዱፉዋ ኤርያ አስ ባዋ። ");
INSERT INTO gofe_vpl VALUES ("DT34_7","006_34_7","DEU","34","7","7","ሙሰይ ሀይቅያ ዎደ እያዉ ላይꬅ ፄታነ ላታማ፤ ሽን እያ አይፈይ እፅቤና፤ እያ ዎልቃይ ዳቡርቤና። ");
INSERT INTO gofe_vpl VALUES ("DT34_8","006_34_8","DEU","34","8","8","እስራኤለ አሳይ ሞአበ ደንባን ሀስታሙ ጋላስ ሙሰስ ዬክዶሶና። ሄሳፈ ጉየ፥ ባለይ ደንድን፥ ዬሆ ዎደይ ዉርስ። ");
INSERT INTO gofe_vpl VALUES ("DT34_9","006_34_9","DEU","34","9","9","ሙሰይ፥ ባ በሳን ኦꬃና መላ፥ እያ ቦላ ባ ኩሽያ ዎꬅዳ ግሾ፥ ናወ ናአይ እያሱይ ጭንጫተꬃ አያናን ኩምስ። እስራኤለ አሳይ እያሱስ ኪተትዶሶና፤ ጎዳይ ሙሰ ባጋራ እምዳ ኪታ ናግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("DT34_10","006_34_10","DEU","34","10","10","ጎዳ ሶምኦን ኦድስዳ፥ ሙሰ መላ ናበይ፥ እስራኤለ ቢታን ደንድቤና። ");
INSERT INTO gofe_vpl VALUES ("DT34_11","006_34_11","DEU","34","11","11","ጎዳይ ሙሰ ግብፀ ካዋኮ፥ እያራ ኦꬅያ ሞርናታኮነ ኩመꬃ አሳኮ የድድ፥ እያ ባጋራ ማላታታነ ማላልስያባታ ኡባ ኦꬅዳ፥ ሙሰ መላ ሀራ ናበይ ኦንካ ባዋ። ");
INSERT INTO gofe_vpl VALUES ("DT34_12","006_34_12","DEU","34","12","12","እስራኤለ ኡባ ስንꬃን ግታ ዎልቃን ማላልስያባ ኦꬅዳ፥ ሙሰ መላ አስ ኦንካ ባዋ። ");
INSERT INTO gofe_vpl VALUES ("JS1_1","007_1_1","JOS","1","1","1","ጎዳ አይለይ ሙሰይ ሀይቅዳፐ ጉየ፥ ጎዳይ ሙሰ ማድያ ናወ ናኣ እያሱ፥ ሀይሳዳ ያግስ፤ ");
INSERT INTO gofe_vpl VALUES ("JS1_2","007_1_2","JOS","1","2","2","“ታ አይለይ፥ ሙሰይ ሀይቅስ። ሄሳ ግሾ፥ ኔራነ ሀ አሳ ኡባይ ደንድድ፥ ታኒ እስራኤለ አሳስ እማናዉ ደእያ ቢታ ገላናዉ፥ ዮርዳኖሰ ሻፋ ፕንተ። ");
INSERT INTO gofe_vpl VALUES ("JS1_3","007_1_3","JOS","1","3","3","ታኒ ሙሰስ ኦድዳይሳዳ፥ ህንተ ቶሆይ የꬍያሶ ኡባ ህንተዉ እማስ። ");
INSERT INTO gofe_vpl VALUES ("JS1_4","007_1_4","JOS","1","4","4","ህንተ ዛዋይ ዱገሀ ነገበ መላ ቢታፈ ደንድድ፥ ፑደሀን ደእያ ልባኖሰ ዙማ ጋካናሳ። ቃስ ዶሎሃ ባጋን ደእያ ኤፍራፂሳ ዎጋ ሻፋፐ ደንድድ፥ ህተታ ቢታ ኡባ ኤክድ ዉሎሀ ባጋን ደእያ መደትራነ አባ ጋካናሳ። ");
INSERT INTO gofe_vpl VALUES ("JS1_5","007_1_5","JOS","1","5","5","እያሱ፥ ነ ላይꬃ ኡባን ኦንካ ኔራ ኤቀታናዉ ዳንዳኤና። ታኒ ሙሰራ ግድዳይሳዳ፥ ኔራካ ግዳና። ታኒ ነና የግከ፤ አግከ። ");
INSERT INTO gofe_vpl VALUES ("JS1_6","007_1_6","JOS","1","6","6","አይኮይ ባዋ ምና። ታኒ ኤንታ ማይዛታስ እማና ጋዳ ጫቅዳ ቢታ ኔን ሀ አሳ ላትሳና። ");
INSERT INTO gofe_vpl VALUES ("JS1_7","007_1_7","JOS","1","7","7","አይኮይ ባዋ ምና። ታ አይለይ ሙሰይ ነዉ እምዳ ህግያ ኡባ ምንꬃዳ ናጋ። ኔን ብያ በሳ ኡባን ነዉ እንጀታና መላ እያፐ ኡሻች ዎይኮ ሀድርስ ጎፓ። ");
INSERT INTO gofe_vpl VALUES ("JS1_8","007_1_8","JOS","1","8","8","ሀ ህገ ማፃፋይ ነ ዶናፐ ሻከቶፎ። እያን ፃፈትዳባ ኡባ ምንꬃዳ ናጋናዉ ጋላስነ ቃማ እያ ቆፓ። ሄሳ ነ ኦꬅኮ፥ ነዉ ኡባባይ እንጀታናነ ፖለታና። ");
INSERT INTO gofe_vpl VALUES ("JS1_9","007_1_9","JOS","1","9","9","ነ ብያ በሳ ኡባን ታኒ ጎዳይ ነ ፆሳይ ኔራ ደእያ ግሾ፥ ባቦፋ፤ ህርጎፋ፤ ያጋዳ ነዉ ኦዳይስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JS1_10","007_1_10","JOS","1","10","10","ሄሳፈ ጉየ፥ እያሱይ ደርያ ሀላቃታ ሀይሳዳ ያግስ፤ ");
INSERT INTO gofe_vpl VALUES ("JS1_11","007_1_11","JOS","1","11","11","“አሳይ ዱንካንድ ደእያ ጉታ ብድ፥ ሄꬑ ጋላሳ ጋርሳን፥ ‘ጎዳይ፥ ህንተ ፆሳይ፥ ህንተዉ እምያ ቢታ ላታናዉ ዮርዳኖሰ ሻፋ ፕንያ ግሾ፥ ህንተዉ ሽንቀ ጊግስተ’ ያግድ ደርያስ ኦድተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JS1_12","007_1_12","JOS","1","12","12","እያሱይ፥ ሮቤላነ ጋዳ ኮቻታ ቃስ ምናሰ ኮቻታፐ ባጋ ሀይሳዳ ያግስ፤ ");
INSERT INTO gofe_vpl VALUES ("JS1_13","007_1_13","JOS","1","13","13","“ጎዳይ፥ ህንተ ፆሳይ፥ ህንተና ሸምፕሳና፥ ሀ ቢታ ህንተዉ እማና ያግድ፥ ጎዳ አይለይ ሙሰይ ኦድዳይሳ ቆፕተ። ");
INSERT INTO gofe_vpl VALUES ("JS1_14","007_1_14","JOS","1","14","14","ህንተ ማቸት፥ ህንተ ናይትነ ህንተ መሄይ ዮርዳኖሰ ሻፋፐ ሀፍንꬃን ሙሰይ ህንተዉ እምዳ ቢታን ደእሾና። ሽን ህንተ ኦላንቾት ባንታ ኦላ ሚሽያ ኦይክድ፥ ህንተ አሳፐ ስንꬃትድ፥ ኦለታናዉ ዮርዳኖሰ ሻፋ ፕኖና። ");
INSERT INTO gofe_vpl VALUES ("JS1_15","007_1_15","JOS","1","15","15","ጎዳይ ህንተና ሸምፕስዳይሳዳ፥ ኤንታካ ሸምፕሳና ጋካናዉነ ጎዳይ ህንተ ፆሳይ ኤንታዉ እምያ ቢታ ኤንቲ ላታና ጋካናዉ፥ ኤንታ ማድተ፤ ኦለትተ። ያትድ፥ ስም ይድ፥ ዮርዳኖሰ ሻፋፐ ሀፍንꬃን ዶሎሀ ባጋን፥ ጎዳ አይለይ ሙሰይ እምዳ ህንተ ቡዞ ቢታን ደእተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JS1_16","007_1_16","JOS","1","16","16","ኤንቲ ዛሪድ እያሱኮ፥ “ነ ኑና ኪትዳ ኡባ ኑኒ ኦꬃና፤ ነ ኪትያሶ ኡባ ባና። ");
INSERT INTO gofe_vpl VALUES ("JS1_17","007_1_17","JOS","1","17","17","ኑኒ ሙሰስ ኡባባን ኪተትዳይሳዳ፥ ነዉካ ኪተታና። ጎዳይ፥ ነ ፆሳይ ሙሰራ ግድዳይሳዳ፥ ኔራካ ግዶ። ");
INSERT INTO gofe_vpl VALUES ("JS1_18","007_1_18","JOS","1","18","18","ኔራ ኤቀተይነ ነ ኪታ እፅያ ኦንካ ደእኮ፥ ሀይቆ። ግዶሽን ኔን ምና” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS2_1","007_2_1","JOS","2","1","1","ናወ ናአይ እያሱይ፥ ቢታ ዎች በእያ ናምኡ አሳታ ሴፅማ ጌተትያ በሳፈ ቆሳን ኪትሸ፥ “ብድ ቢታ ዎችተ፤ ቃስ እያርኮ ካታማ ዱማይድ ዎችተ” ያግድ ኪትስ። ኤንቲ ብድ፥ ራቦ ጌተትያ ላይማተꬃን አቅያ አሰ ሶ አቃናዉ ገልዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS2_2","007_2_2","JOS","2","2","2","እያርኮ ካዎይ፥ “እስራኤለ አሳፐ ኪተትዳይሳት ሀ ቢታ ዎቻናዉ ሀች ቃማ ይዶሶና” ግያ ኦዳ ስእስ። ");
INSERT INTO gofe_vpl VALUES ("JS2_3","007_2_3","JOS","2","3","3","ያትን፥ እያርኮ ካዎይ ራብኮ፥ “ነ ሶ ገልዳ አሳት ቢታ ዎቻናዉ ይዳ አስ ግድያ ግሾ፥ ኤንታና ከሳዳ እማ” ያግድ ኪትስ። ");
INSERT INTO gofe_vpl VALUES ("JS2_4","007_2_4","JOS","2","4","4","ሽን ማጫስያ ሄ ናምኡ አሳታ ቆታዳ፥ “ኤ አሳት ታኮ ይዶሶና፥ ሽን ኤንቲ አዉፐ ይዳኮ ታ ኤርከ። ");
INSERT INTO gofe_vpl VALUES ("JS2_5","007_2_5","JOS","2","5","5","ኦማርስ ካታማ ፐንግያ ጎርዳና ሀንያ ዎደ፥ ኤንቲ ከይድ ብዶሶና። ኤንቲ አዉ ብዳኮ ታ ኤርከ። ኤለስድ ኤንታ ህንተ ካልኮ፥ ኦይካና” ያጋዳ ኤንታዉ ኦዳሱ። ");
INSERT INTO gofe_vpl VALUES ("JS2_6","007_2_6","JOS","2","6","6","ሽን እያ አሳታ ዳሳ ቦላ ከሳዳ ታልባ ጮይና ግዶን ቆሳሱ። ");
INSERT INTO gofe_vpl VALUES ("JS2_7","007_2_7","JOS","2","7","7","ያትን፥ ካዎይ ኪትዳ አሳት ዎቸይሳታ ኮይሸ፥ ዮርዳኖሰ ሻፋ ፕንꬅያ ኦግያ ጋካናዉ ብዶሶና። ኤንቲ ካታማፐ ቡሮ ከይዳ መላ ካታማ ፐንገይ ጎርደትስ። ");
INSERT INTO gofe_vpl VALUES ("JS2_8","007_2_8","JOS","2","8","8","ዎቸይሳት ꬍስካናፐ ካሰታዳ፥ እያ ኤንታኮ ከያዳ፥ ");
INSERT INTO gofe_vpl VALUES ("JS2_9","007_2_9","JOS","2","9","9","ሀይሳዳ ያጋሱ፤ “ጎዳይ ሀ ቢታ ህንተዉ እምዳይሳ ታ ኤራይስ። ጋሶይካ፥ ህንተፈ ደንድዳይሳን ግታ ያሻን አሳ ኡባይ ትልእስ። ");
INSERT INTO gofe_vpl VALUES ("JS2_10","007_2_10","JOS","2","10","10","ግብፀ ቢታፈ ህንተ ከይዳ ዎደ፥ ጎዳይ ህንተ ስንꬃን ዞኦ አባ ዋት መልስዳኮ ኑ ስእዳ። ቃስ ዮርዳኖሰ ሻፋፐ ዶሎሀ ባጋራ ደእያ አሞረ ካዎታ ናምአታ፥ ስሆናነ ኦገ ህንተ ዋትድ ዎꬍዳኮነ ኤንታ ካታማ ዋትድ ꬋይስዳኮ ኑ ስእዳ። ");
INSERT INTO gofe_vpl VALUES ("JS2_11","007_2_11","JOS","2","11","11","ኑኒ ሄሳ ስእዳ ዎደ፥ ኑ ዎዛናይ ያሻን ትልእስ። ህዛ፥ ህንተ ጎዳይ፥ ፆሳይ ሳሉዋካ ሳኣካ ሃረይስ እያ ግደይሳ ኑ ኤርዳ። ");
INSERT INTO gofe_vpl VALUES ("JS2_12","007_2_12","JOS","2","12","12","ሄሳ ግሾ፥ ታ ህንተዉ ኬህዳይሳዳ ህንተ ታ አዋ ሶ አሳስ ኬሀናዳ ጎዳ ሱንꬃን ጫቅተ። ሄሳስ አማንꬅያ ማላ ታዉ እምተ። ");
INSERT INTO gofe_vpl VALUES ("JS2_13","007_2_13","JOS","2","13","13","ታ አዋነ ታ አይዉ፥ ታ እሻታነ ታ ምቸታ ኤታ ሶ አሳ ኡባ ዎꬎኮ ግድ ጫቅተ” ያጋሱ። ");
INSERT INTO gofe_vpl VALUES ("JS2_14","007_2_14","JOS","2","14","14","ሄ አሳት ዛሪድ፥ “ኑ ነዉ ጫቅዳ ጫቁዋ ፖሎና እፅኮ፥ ፆሳይ ኑና ዎꬎ። ኑ ኦꬅያባ ነ አሳስ ቆንጭሶና እፅኮ፥ ጎዳይ ሀ ቢታ ኑስ እምያ ዎደ፥ ኑኒ ነዉ አማነታናነ ኬሀና” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS2_15","007_2_15","JOS","2","15","15","ራኣብ ኬꬃይ ካታማ ግምበ ድርሳራ ኦይከትድ ኬፀትዳ ግሾ፥ ማስኮትያራ ዎዶሮ ዱገ የዳዳ፥ ኤንታና ዱገ ዎꬍሳሱ። ");
INSERT INTO gofe_vpl VALUES ("JS2_16","007_2_16","JOS","2","16","16","ራኣባ ኤንታኮ፥ “ህንተና ኮየይሳት ደሞና መላ ደርያኮ፥ ብድ ኤንቲ ስማና ጋካናዉ ያን ሄꬑ ጋላስ ቆሰትተ። ያን ስሚድ፥ ህንተ ብያ በሳ ባናዉ ዳንዳኤታ” ያጋሱ። ");
INSERT INTO gofe_vpl VALUES ("JS2_17","007_2_17","JOS","2","17","18","አሳት ዛሪድ፥ “ኑኒ ሀ ቢታ ኦይካናዉ ገልያ ዎደ፥ ሀ ዞኦ ዎዶሩዋ ነ ኑና ዎꬍስዳ ማስኮትያን ቃቾና እፅኮነ ነ አዋ፥ ነ አይዉ፥ ነ እሻታነ ነ ሶ አሳ ኡባ ነ ሶ ሺሾና እፅኮ፥ ነ ኑና ጫቅስዳ ጫቆይ ኑስ ጎመ ግደና። ");
INSERT INTO gofe_vpl VALUES ("JS2_19","007_2_19","JOS","2","19","19","ኦንካ ነ ሶፐ ካረ ከይድ ሀይቅኮ፥ ሄስ እያ ጎመ። ኑኒ ሄሳስ ኦይሸቶኮ። ኔራ ሶን ደእሸ ኦንካ ቆሄትኮ፥ እያ ሱꬃ ጎመይ ኑና ጋኮ። ");
INSERT INTO gofe_vpl VALUES ("JS2_20","007_2_20","JOS","2","20","20","ሽን ኑ ኦꬅያባ ኔን አሳስ ቆንጭስኮ ኔን ኑና ጫቅስዳ ጫቆይ ኑስ ጎመ ግደና” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS2_21","007_2_21","JOS","2","21","21","እያ ዛራዳ፥ “ህንተ ቃላዳ ሀኖ” ጋዳ ኤንታ ሞይዛሱ። ኤንቲ ብዳፐ ጉየ፥ ሄ ዞኦ ዎዶሩዋ ማስኮትያን ቃቻሱ። ");
INSERT INTO gofe_vpl VALUES ("JS2_22","007_2_22","JOS","2","22","22","ኤንቲ ደርያኮ ብድ፥ ኤንታ ኮየይሳት እያርኮ ስማና ጋካናዉ ያን ሄꬑ ጋላስ ቆሰትዶሶና። ኤንታ ኮየይሳት ኦገ ኡባን ኮይዶሶና፥ ሽን ደምቦኮና። ");
INSERT INTO gofe_vpl VALUES ("JS2_23","007_2_23","JOS","2","23","23","ሄሳፈ ጉየ ሄ ናምኡ አሳት ደርያፐ ዎꬍዶሶና። ዮርዳኖሰ ፕንድ፥ ናወ ናኣ እያሱኮ ይድ፥ ባንታና ጋክዳባ ኡባ ኦድዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS2_24","007_2_24","JOS","2","24","24","ኤንቲ እያሱኮ፥ “ጎዳይ ቱማ ሄ ቢትዉ ኑስ አꬅድ እምስ። ቃስ ሄ ቢታን ደእያ አሳ ኡባይ፥ ኑስ ያይድ ትልእዶሶና” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS3_1","007_3_1","JOS","3","1","1","ዎንተꬃ ጋላስ፥ ዎንታ ጉራ እያሱይነ አሳይ ሴፅማ ጌተትያ በሳፈ ደንድድ፥ ዮርዳኖሰ ሻፋ ብድ፥ ፕኖና ያን ዱንካንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS3_2","007_3_2","JOS","3","2","2","ሄꬑ ጋላሳፐ ጉየ፥ ሀላቃት ኤንቲ ዱንካንዳ ጉታ ገልድ፥ ");
INSERT INTO gofe_vpl VALUES ("JS3_3","007_3_3","JOS","3","3","3","“ሌወ ኮቸ ግድዳ ካህነት ቶክዳ፥ ጎዳ፥ ህንተ ፆሳ ጫቆ ታቦትያ ህንተ በእዳ ዎደ ዱንካንዳ ጉታፐ ደንድድ ኤንታ ካልተ። ");
INSERT INTO gofe_vpl VALUES ("JS3_4","007_3_4","JOS","3","4","4","ህንተ ካሰ ሀ ኦግያራ ብድ ኤሮና ግሾ፥ ህንተ ባና ኦግያ ኤንቲ በሳና። ሽን ጫቆ ታቦትያኮ ሺቆፕተ። ህንተ ግዶንነ ጫቆ ታቦትያ ግዶን ናምኡ ሙኩሉ ዋꬋ ግድያ ሃሆተꬅ ደኦ” ያግድ ኦድዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS3_5","007_3_5","JOS","3","5","5","እያሱይ አሳኮ፥ “ጎዳይ ዎንቶ ህንተ ግዶን ማላልስያባ ኦꬃና ግሾ፥ ህንተናተꬃ ጌሽተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JS3_6","007_3_6","JOS","3","6","6","ቃስ ካህነታስ፥ “ጫቆ ታቦትያ ቶክድ፥ አሳፐ ስን አꬍተ” ያግድ ኪትስ። ካህነት ጫቆ ታቦትያ ቶክድ፥ አሳፐ ስን አꬍዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS3_7","007_3_7","JOS","3","7","7","ጎዳይ እያሱኮ፥ “ታኒ ሙሰራ ግድዳይሳዳ፥ ኔራካ ግዳናይሳ አሳ ኡባይ ኤራና መላ ሀች እስራኤለ ኡባ ስንꬃን ነና ꬎቁ ꬎቁ ኦሶ ዶማና። ");
INSERT INTO gofe_vpl VALUES ("JS3_8","007_3_8","JOS","3","8","8","ኔን፥ ጫቆ ታቦትያ ቶክያ ካህነታስ፥ ‘ዮርዳኖሰ ሻፋ ዶና ጋክያ ዎደ ሃꬃ ግዶ ገልድ ኤቅተ’ ጋዳ ኪታ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JS3_9","007_3_9","JOS","3","9","9","እያሱይ እስራኤለ አሳኮ፥ “ሃ ይድ ጎዳ፥ ህንተ ፆሳ ቃላ ስእተ። ");
INSERT INTO gofe_vpl VALUES ("JS3_10","007_3_10","JOS","3","10","10","ደኦ ፆሳይ ህንተ ግዶን ደኤይሳ ህንተ ኤራናይ፥ ካናነታ፥ ህተታ፥ ህወታ፥ ፓርዘታ፥ ገርገሰታ፥ አሞረታነ ያቡሰታ ህንተ ስንꬃፈ እ ጎድድ ከሰይሳና። ");
INSERT INTO gofe_vpl VALUES ("JS3_11","007_3_11","JOS","3","11","11","ቢታ ኡባ ጎዳ ጫቆ ታቦተይ ህንተፈ ስንꬃትድ፥ ዮርዳኖሰ ሻፋ ፕናና። ");
INSERT INTO gofe_vpl VALUES ("JS3_12","007_3_12","JOS","3","12","12","ህዛ ታማነ ናምኡ እስራኤለ ዘረꬃታፐ እስ እስ አስ ዶርተ። ");
INSERT INTO gofe_vpl VALUES ("JS3_13","007_3_13","JOS","3","13","13","ቢታ ኡባ ጎዳ ጫቆ ታቦትያ ቶክዳ ካህነታ ቶሆይ ዮርዳኖሰ ሃꬃ የꬍያ ዎደ ሃꬃይ ኤቃና። ቆሞፈ ዱገ ጎግያ ዮርዳኖሰ ሃꬃይ እስ ቦላ ሺቅድ ዶረታና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JS3_14","007_3_14","JOS","3","14","14","አሳይ ዮርዳኖሰ ሻፋ ፕናናዉ ዱንካንዳ ጉታፐ ደንድያ ዎደ፥ ጫቆ ታቦትያ ቶክዳ ካህነት አሳ ስንꬃን ቦሶና። ");
INSERT INTO gofe_vpl VALUES ("JS3_15","007_3_15","JOS","3","15","15","ካꬅ ሺሽያ ዎደ ዮርዳኖሰ ሻፋይ መꬋይሳዳ ክፅኮካ፥ ጫቆ ታቦትያ ቶክዳ ካህነት ዮርዳኖሰ ሻፋ ጋክድ፥ ኤንታ ቶሆይ ሃꬃ ጋፃ የꬍዳ ዎደ፥ ");
INSERT INTO gofe_vpl VALUES ("JS3_16","007_3_16","JOS","3","16","16","ቆሞፈ ዱገ ጎግያ ሃꬃይ ኤቅስ። ዛርታና ማታን ደእያ አዳማ ካታማ ጋካናዉ ሺቅድ ዶረትስ። ዱገ ማፅነ አባኮ ጎግያ ሃꬃይ ኤቅስ። ያንን፥ አሳይ እያርኮ ካታማ ፕንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS3_17","007_3_17","JOS","3","17","17","እስራኤለ አሳይ መላ ቢታራ ፕንድ ዉራና ጋካናዉ ጎዳ ጫቆ ታቦትያ ቶክዳ ካህነት ዮርዳኖሰ ሻፋ ግዶን መላ ቢታን ኤቅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS4_1","007_4_1","JOS","4","1","1","አሳ ኡባይ ዮርዳኖሰ ፕንዳፐ ጉየ ጎዳይ እያሱኮ፥ ");
INSERT INTO gofe_vpl VALUES ("JS4_2","007_4_2","JOS","4","2","2","“እስ እስ እስራኤለ ኮቻፈ እስ እስ አስ ኤካዳ ታማነ ናምኡ አሳታ ዶራ። ");
INSERT INTO gofe_vpl VALUES ("JS4_3","007_4_3","JOS","4","3","3","ሄ አሳት ዮርዳኖሰ ሻፋ ግዶን ካህነት ኤቅዳ በሳፈ ታማነ ናምኡ ሹቻታ ኤካና መላነ ሄ ሹቻታ ሀች ህንተ ዱንካንድ አቅያ በሳን ዎꬃና መላ ኦዳ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JS4_4","007_4_4","JOS","4","4","4","እያሱይ እስራኤለ ዘረꬃታፐ ዶረትዳ ታማነ ናምኡ አሳታ ፄግስ። ");
INSERT INTO gofe_vpl VALUES ("JS4_5","007_4_5","JOS","4","5","5","ኤንታኮ፥ “ጎዳ ህንተ ፆሳ ጫቆ ታቦተይ ደእያ በሳ ጉየ ዮርዳኖሰ ሻፋ ገልድ፥ እስ እስ እስራኤለ ዘረꬃታ ታይቦን ኡባይ እስ እስ ሹች ህንተ ሀሸን ቶክተ። ");
INSERT INTO gofe_vpl VALUES ("JS4_6","007_4_6","JOS","4","6","6","ሀ ሹቻት፥ ጎዳይ ሀች ኦꬅዳባ ህንተና ቆፍስያ ማላታ ግዳና። ዎንቶ ህንተ ናይት፥ ‘ሀ ሹቻት አይብሴ?’ ያግድ ኦይችያ ዎደ፥ ");
INSERT INTO gofe_vpl VALUES ("JS4_7","007_4_7","JOS","4","7","7","ህንተ ዛሪድ፥ ‘ጎዳ ጫቆ ታቦተይ ፕንያ ዎደ ዮርዳኖሰ ሃꬃይ ጎገꬅ አግስ። ሄሳ ግሾ፥ ሀ ሹቻት ሀ በሳን ሀንዳባ እስራኤለ አሳ ኡባ ዎደ ቆፍስያባ ግዳና’ ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JS4_8","007_4_8","JOS","4","8","8","ሄ አሳት እያሱይ ኪትዳይሳዳ ኦꬅዶሶና። ጎዳይ እያሱስ ኦድዳይሳዳ፥ እስራኤለ ዘረꬃታ ታይቦን ዮርዳኖሰ ሻፋፐ ታማነ ናምኡ ሹቻታ ኤፍድ፥ ኤንቲ አቅያ በሳን ዎꬅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS4_9","007_4_9","JOS","4","9","9","እያሱይ፥ ካህነት ዮርዳኖሰ ሻፋን ጫቆ ታቦትያ ቶክድ፥ ኤቅዳ በሳን ታማነ ናምኡ ሹቻታ ኤስስ። ሄ ሹቻት ሀች ጋካናዉ ያን ደኦሶና። ");
INSERT INTO gofe_vpl VALUES ("JS4_10","007_4_10","JOS","4","10","10","ሙሰይ እያሱ ኪትዳይሳ መላ፥ ጎዳይ እያሱ ኪትዳባ ኡባይ ፖለታና ጋካናዉ፥ ጫቆ ታቦትያ ቶክዳ ካህነት ዮርዳኖሰ ሻፋን ኤቅድ ጋምእዶሶና። አሳይ ኤለስድ ሻፋ ፕንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS4_11","007_4_11","JOS","4","11","11","አሳ ኡባይ፥ ፕንዳፐ ጉየ፥ ጎዳ ጫቆ ታቦትያ ቶክዳ ካህነት አሳፐ ስን አꬍድ ካለꬅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS4_12","007_4_12","JOS","4","12","12","ሙሰይ ኪትዳይሳዳ፥ ሮቤላነ ጋዳ ኮቻት፥ ቃስ ምናሰ ኮቻፈ ባጋይ ኦላስ ዳንጨትድ፥ አሳፐ ስንꬃትድ ፕንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS4_13","007_4_13","JOS","4","13","13","ዳሮተꬃን ኦይታሙ ሙኩሉ ግድያ ኦላንቾት፥ ጎዳ ስንꬃን፥ እያርኮ ማታን ደእያ ደንባን ኦለታናዉ ሺቅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS4_14","007_4_14","JOS","4","14","14","ሄ ጋላስ፥ ጎዳይ እያሱ እስራኤለ አሳ ኡባ ስንꬃን ꬎቁ ꬎቁ ኦꬅስ። ኤንቲ ሙሰ ቦንችዳይሳዳ እያሱካ እያ ደኦ ላይꬃ ኡባን ቦንችዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS4_15","007_4_15","JOS","4","15","15","ጎዳይ እያሱኮ፥ ");
INSERT INTO gofe_vpl VALUES ("JS4_16","007_4_16","JOS","4","16","16","“ጫቆ ታቦትያ ቶክዳ ካህነት ዮርዳኖሰ ሻፋፐ ከያና መላ ኦዳ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JS4_17","007_4_17","JOS","4","17","17","እያሱይ ካህነት ዮርዳኖሰ ሻፋፐ ከያና መላ ኦድስ። ");
INSERT INTO gofe_vpl VALUES ("JS4_18","007_4_18","JOS","4","18","18","ጎዳ ጫቆ ታቦትያ ቶክዳ ካህነት ዮርዳኖሰ ሻፋፐ ከይዶሶና። ኤንታ ቶሆይ መላ ቢታ የꬍዳ ዎደ ኤለስድ፥ ዮርዳኖሰ ሃꬃይ ባ በሳ ስሚድ፥ ካሰ ጎገይሳዳ ጋፃ ጋክድ ጎገꬅ ኦይክስ። ");
INSERT INTO gofe_vpl VALUES ("JS4_19","007_4_19","JOS","4","19","19","አሳይ ኮይሮ አጌናን ታማንꬆ ጋላሳን ዮርዳኖሰ ሻፋ ፕንድ፥ እያርኮስ ዶሎሀ ባጋን ደእያ ጋልጋላን ዱንካንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS4_20","007_4_20","JOS","4","20","20","እያሱይ ዮርዳኖሰ ሻፋፐ ኤከትዳ ታማነ ናምኡ ሹቻታ ጋልጋላን ኤስድ፥ ");
INSERT INTO gofe_vpl VALUES ("JS4_21","007_4_21","JOS","4","21","21","እስራኤለ አሳኮ ሀይሳዳ ያግስ፤ “ዎንቶ ህንተ ናይት፥ ‘ሀ ሹቻት አይብሴ?’ ያግድ ህንተና ኦይችያ ዎደ፥ ");
INSERT INTO gofe_vpl VALUES ("JS4_22","007_4_22","JOS","4","22","22","‘እስራኤለ አሳይ ዮርዳኖሰ ሻፋ መላ ቢታራ የꬍድ ፕንዳይሳ ቆፍስያባ’ ያግድ ኦዴታ። ");
INSERT INTO gofe_vpl VALUES ("JS4_23","007_4_23","JOS","4","23","23","ኑኒ ፕናና ጋካናዉ፥ ጎዳይ፥ ኑ ፆሳይ ዞኦ አባ ካሰ ኑ ስንꬃን መልስዳይሳዳ፥ ህንተካ ፕናና ጋካናስ፥ ጎዳይ፥ ህንተ ፆሳይ ዮርዳኖሰ ሻፋ ህንተ ስንꬃን መልስዳይሳ ኦድተ። ");
INSERT INTO gofe_vpl VALUES ("JS4_24","007_4_24","JOS","4","24","24","ሄሳ ግሾ፥ ቢታን ደእያ አሳ ኡባይ፥ ጎዳ ዎልቃይ አይ መላ ግቴኮ ኤራና፤ ህንተካ ጎዳ፥ ህንተ ፆሳ፥ መርናዉ ቦንቻና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JS5_1","007_5_1","JOS","5","1","1","ዮርዳኖሰ ሻፋፐ ዉሎሀ ባጋን ደእያ አሞረታ ካዎትነ መደትራነ አባ ላንቀን ደእያ ካናነታ ካዎት ኡባይ፥ እስራኤለ አሳይ ፕናና ጋካናስ ዮርዳኖሰ ሻፋ ጎዳይ ዋት መልስዳኮ ስእዳ ዎደ ኤንታ ዎዛናይ ትልእን፥ እስራኤለ አሳራ ኤቀታናዉ ፃላተꬅ ꬋይዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS5_2","007_5_2","JOS","5","2","2","ሄ ዎደ ጎዳይ እያሱኮ፥ “ሳሎ ሹቹ ቃራያዳ እስራኤለ አደ አሳ ናምአንꬆ ቃፃራ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JS5_3","007_5_3","JOS","5","3","3","እያሱይ ቃራ ሳሎ ሹቻ ኤክድ፥ “ቃፃራ ደረ” ጌተትያ በሳን እስራኤለታ ቃፃርስ። ");
INSERT INTO gofe_vpl VALUES ("JS5_4","007_5_4","JOS","5","4","4","እ ሄሳ ኦꬅዳይ፥ ግብፀፈ ከይዳ አደታን ላይꬅ ኦላስ ጋክዳ ኡባይ መላ ቢታን ሀይቅ ዉርዳ ግሾሳ። ");
INSERT INTO gofe_vpl VALUES ("JS5_5","007_5_5","JOS","5","5","5","ግብፀፈ ከይዳ አደ አሳ ኡባይ፥ ቃፃረትዶሶና፥ ሽን ግብፀፈ ብሸ መላ ቢታን የለትዳ አደ ናይት ቃፃረትቦኮና። ");
INSERT INTO gofe_vpl VALUES ("JS5_6","007_5_6","JOS","5","6","6","ግብፀፈ ከይያ ዎደ ላይꬅ ኦላስ ጋክዳ አደ አሳ ኡባይ ጎዳስ ኪተቶና እፅዳ ግሾ፥ ኤንቲ ሀይቅድ ዉራና ጋካናስ እስራኤለት መላ ቢታን ኦይታሙ ላይꬅ ዩይዶሶና። ጎዳይ፥ ኑስ እማና ግድ ኤንታ ማይዛታስ ጫቅዳ ኤስነ ማꬅ ጎግያ አራዳ ቢታ ሀይቅዳ ኤንታ ናይት ላቶና መላ ካሰ ጫቅስ። ");
INSERT INTO gofe_vpl VALUES ("JS5_7","007_5_7","JOS","5","7","7","ሄሳ ግሾ እያሱይ ቃፃርዳይ ጎዳይ ኤንታ በሳን ደንꬅዳ ኤንታ ናይታ። ኤንቲ ኦገ ቦላ የለትዳ ግሾ ቃፃረትቦኮና። ");
INSERT INTO gofe_vpl VALUES ("JS5_8","007_5_8","JOS","5","8","8","አሳ ኡባይ፥ ቃፃረትዳፐ ጉየ፥ ኤንታ ማዱንꬃይ ፓፃና ጋካናዉ ኤንቲ ዱንካንዳ በሳን ጋምእዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS5_9","007_5_9","JOS","5","9","9","ጎዳይ እያሱኮ፥ “ሀች ታኒ ግብፀታ ቦርያ ህንተፈ ድጋስ” ያግስ። ሄሳ ግሾ፥ ሄ በሳ ሱንꬃይ ሀች ጋካናዉ ጋልጋላ ጌተትድ ፄገቴስ። ");
INSERT INTO gofe_vpl VALUES ("JS5_10","007_5_10","JOS","5","10","10","እስራኤለ አሳይ እያርኮ ደንባን ጋልጋላ ጌተትያ በሳን ዱንካንድ፥ ኮይሮ አጌናን ታማነ ኦይዳንꬆ ጋላሳን ኦማርስ ፓስካ ባልያ ቦንችዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS5_11","007_5_11","JOS","5","11","11","ፓስካፐ ጉየ፥ ዎንተꬃ ጋላስ፥ ሄ ጋድያን ዶልዳ ካꬃ አይፍያ፥ ኡይꬁነ ትያ ጫጫ ምዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS5_12","007_5_12","JOS","5","12","12","ሄ ጋድያን ሞክዳ ካꬃ ኤንቲ ምዳ ዎንተꬃ ጋላስ ማናይ ዎይሳ አግስ። ሄ ዎደፐ ዶምድ እስራኤለ አሳይ ማና ደምቦኮና። ሄሳፈ ጉየ ኤንቲ ካናነን ካፅዳ ካꬃ ምድ ደእዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS5_13","007_5_13","JOS","5","13","13","እያሱይ እያርኮ ማታን ደእያ ዎደ ማሻ ኦይክድ ባ ስንꬃን ኤቅዳ እስ አደ በእስ። እያሱይ እያኮ ሺቅድ፥ “ኔን ኑ ባጋየ ዎይኮ ኑ ሞርከታ ባጌ?” ያግድ ኦይችስ። ");
INSERT INTO gofe_vpl VALUES ("JS5_14","007_5_14","JOS","5","14","14","አደይ ዛሪድ፥ “ታኒ ኦደ ባጋካ ግድከ። ሽን ታ ጎዳ ቶራ ሞጮና ግዳዳ ያስ” ያግስ። እያሱይ ሳአን ኩንድ ጎይንድ፥ “ታ ጎዳዉ፥ ታ ኦꬃናባ ታዉ ኦዳ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JS5_15","007_5_15","JOS","5","15","15","ጎዳ ቶራ ሞጮናይ እያሱኮ፥ “ኔን ኤቅዳ በሳይ ጌሽ ግድያ ግሾ፥ ነ ቶሁዋፐ ጫማ ከሳ” ያግስ። ያትን እያሱይ እ ግዳይሳዳ ኦꬅስ። ");
INSERT INTO gofe_vpl VALUES ("JS6_1","007_6_1","JOS","6","1","1","እስራኤለ አሳስ ያይዳ ግሾ፥ እያርኮ ካታማ ግምበ ድርሳ ፐንገት ጎርደትዶሶና። ኦንካ ካታማ ገላናዉነ ከያናዉ ዳንዳኤና። ");
INSERT INTO gofe_vpl VALUES ("JS6_2","007_6_2","JOS","6","2","2","ጎዳይ እያሱኮ፥ “እያርኮ ካታማ እያ ካዉራነ እያ ምኖ ኦላንቾታራ ነ ኩሸን አꬃ እማስ። ");
INSERT INTO gofe_vpl VALUES ("JS6_3","007_6_3","JOS","6","3","3","ኔራነ ነ ኦላንቾታራ ሳልፕድ፥ ጋላሳን እስ ቶሆ ኡሱፑን ጋላስ ጋካናዉ፥ ካታማ ግምበ ድርሳ ዩሹዋ ዩይተ። ");
INSERT INTO gofe_vpl VALUES ("JS6_4","007_6_4","JOS","6","4","4","ላፑን ካህነት እሶይ እሶይ ሞይዘ ኦይክድ፥ ጎዳ ጫቆ ታቦትያ ስንꬃን ቦ። ላፑንꬃ ጋላስ ካህነት ሞይዘ ፑንያ ዎደ ህንተ ካታማ ላፑን ቶሆ ዩይተ። ");
INSERT INTO gofe_vpl VALUES ("JS6_5","007_6_5","JOS","6","5","5","ካህነት ሞይዘ ጎችድ ፑኑዋ ህንተ ስእያ ዎደ፥ አሳ ኡባይ ኤለስድ ባንታ ቃላ ꬎቁ ኦꬅድ ዋሶ። ሄሳፈ ጉየ፥ ካታማ ግምበ ድርሳይ ኩንዳና። ሄ ዎደ አሳ ኡባይ ግዶ ላዉሁ ግድ ገላና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JS6_6","007_6_6","JOS","6","6","6","ናወ ናአ እያሱ ካህነታ ፄግድ፥ “ጎዳ ጫቆ ታቦትያ ቶክተ። ህንተፈ ላፑን ካህነት ሞይዘ ኦይክድ፥ ጫቆ ታቦትያፐ ስን አꬍድ ቦ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JS6_7","007_6_7","JOS","6","7","7","አሳኮ ቃስ፥ “ብድ፥ ካታማ ዩሹዋን ዩይተ፤ ኦላንቾት ጎዳ ጫቆ ታቦትያ ስንꬃን ሄመቶና” ያግድ ኪትስ። ");
INSERT INTO gofe_vpl VALUES ("JS6_8","007_6_8","JOS","6","8","8","እያሱይ ኦድዳይሳዳ፥ ላፑን ካህነት ላፑን ሞይዘ ፑንሸ ጎዳ ስንꬃን ሄመትዶሶና፤ ቃስ ጎዳ ጫቆ ታቦተይ ኤንታ ካልስ። ");
INSERT INTO gofe_vpl VALUES ("JS6_9","007_6_9","JOS","6","9","9","ኦላስ ዳንጭዳይሳት ሞይዘ ፑንያ ካህነታ ስንꬃን ሄመቶሶና። ካህነት ቃንፆና ሞይዘ ፑንያ ዎደ ደረይ ታቦትያፐ ጉየራ ካሌስ። ");
INSERT INTO gofe_vpl VALUES ("JS6_10","007_6_10","JOS","6","10","10","ሽን እያሱይ፥ “ታ ህንተና ዋሶ ጎናሽን ዋሶፍተ ዎይኮ ህንተ ቃላ ስሶፍተ፤ ሀር አቶሽን እስ ቃላካ ኦደቶፍተ። ታ ህንተና ዋሶ ግያ ሄ ጋላስ ዋስተ” ያግድ አሳ ኪትስ። ");
INSERT INTO gofe_vpl VALUES ("JS6_11","007_6_11","JOS","6","11","11","ሄሳ ግሾ፥ ጎዳ ጫቆ ታቦተይ ሄ ካታማ እስ ቶሆ ዩያናዳ ኦꬅስ። ያትድ አሳይ ባንታ ዱንካንዳ ጉታ ስሚድ፥ ያን አቅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS6_12","007_6_12","JOS","6","12","12","ዎንተꬃ ጋላስ እያሱይ ጉርድ ደንድስ፤ ካህነትካ ጎዳ ጫቆ ታቦትያ ቶክዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS6_13","007_6_13","JOS","6","13","13","ላፑን ሞይዘታ ኦይክዳ ላፑን ካህነት ባንታ ሞይዝያ ቃንፆና ፑንሸ ጫቆ ታቦትያ ስንꬃን ቦሶና። ሞይዘይ ቃንፆና ፑነትያ ዎደ ኦላንቾት ካህነታፐ ስንꬃን ቃስ ደረይ ታቦትያፐ ጉየራ ካሌስ። ");
INSERT INTO gofe_vpl VALUES ("JS6_14","007_6_14","JOS","6","14","14","ናምአንꬆ ጋላስ ካታማ እስ ቶሆ ዩይድ፥ ባንታ ዱንካንዳ ጉታ ስምዶሶና። ኡሱፑን ጋላስ ጋካናዉ ሄሳዳ ኦꬅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS6_15","007_6_15","JOS","6","15","15","ላፑንꬃ ጋላስ ጎንተይ ዋꬍሽን ደንድድ፥ ካሰይሳዳ ካታማ ላፑን ቶሆ ዩይዶሶና። ሄ ጋላሳ ፃላላ ካታማ ላፑን ቶሆ ኤንቲ ዩይዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS6_16","007_6_16","JOS","6","16","16","ላፑንꬃ ዩሹዋን፥ ካህነት ሞይዘ ፑንያ ዎደ፥ እያሱይ አሳኮ፥ “ጎዳይ ሀ ካታማ ህንተዉ አꬅድ እምዳ ግሾ፥ ዋስተ” ያግድ ኪትስ። ");
INSERT INTO gofe_vpl VALUES ("JS6_17","007_6_17","JOS","6","17","17","“ካታማይነ እያ ግዶን ደእያባ ኡባይ ጎዳስ ቃንገትዳባ ግድድ ꬋያናዉ በሴስ። ኑኒ ቢታ ፆሞሳና መላ የድዳ አሳታ ቆሳዳ አሽዳ፥ ላይምያ ራባነ እ ሶን ደእያ አሳ ፃላል አታናዉ በሴስ። ");
INSERT INTO gofe_vpl VALUES ("JS6_18","007_6_18","JOS","6","18","18","ሽን ህንተ መቶነ ቆሆ እስራኤለ ጉታ ቦላ ኤሆና መላ ꬋያናዉ በሲያባፐ አይባካ አሞትድ ኤኮናዳ ህንተ ሁጰስ ናገትተ። ");
INSERT INTO gofe_vpl VALUES ("JS6_19","007_6_19","JOS","6","19","19","ብራይነ ዎርቀይ፥ ናሰ ብራታፐ ኦሰትዳ ሚሸት ኡባይ፥ ጎዳስ ዱማትዳባ ግዶ። ኤንቲ ጎዳ ሚሽያ ምንጅያ ሻልያን ደኦ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JS6_20","007_6_20","JOS","6","20","20","ሄሳ ግሾ፥ ሞይዘይ ፑነትስ፤ አሳይ ዋስስ። ደረይ ሞይዘ ፑኑዋ ስእዳ ዎደ ባንታ ቃላ ꬎቁ ኦꬅ ዋስን፥ ካታማ ግምብያ ድርሳይ ኩንድስ። ሄ ሳተን አሳይ ላዉሁ ግድ ገልድ ካታማ ኦይክዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS6_21","007_6_21","JOS","6","21","21","ባንታ ማሻ ደንꬅድ፥ ማጫ አደ፥ ናአ ጭማ፥ መሄ፥ ዶርሰ፥ ሀረነ ካታማን ሸምፖራ ደእያባ ኡባ ዎꬍዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS6_22","007_6_22","JOS","6","22","22","እያሱይ ቢታ ፆሞሳናዉ ኪተትዳ ናምኡ አሳታኮ፥ “ላይመ ራብ ሶ ብድ፥ ካሰ ህንተ እዉ ጫቅዳይሳዳ፥ እዮነ እ ሶ አሳ ኡባ ከስተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JS6_23","007_6_23","JOS","6","23","23","ኤንቲ ብድ፥ ራቦ፥ እ አዋ፥ እ አይዉ፥ እ እሻታነ እ ዳቦታ ኡባ እስራኤለ አሳይ ዱንካንዳ ጉታፐ ጋፃ ከስድ ዎꬅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS6_24","007_6_24","JOS","6","24","24","ያት ስሚድ ካታማነ እያ ግዶን ደእያባ ኡባ ፁግዶሶና። ሽን ብራነ ዎርቃ፥ ናሰ ብራታፐ ኦሰትዳ ሚሸታ ጎዳ ሚሽያ ምንጅያ ሻልያን ዎꬅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS6_25","007_6_25","JOS","6","25","25","ሽን ላይምያ ራባ እያርኮ ፆሞሳና መላ ኪተትዳ አሳታ ቆሳዳ አሽዳ ግሾ፥ እያሱይ እዮ፥ እ አዋ ሶ አሳነ ኢራ ደእያ ዳቦታ ኡባ ሀይቆፐ አሽስ። እ ኮቻት ሀች ጋካናዉ እስራኤለ ቢታን ደኦሶና። ");
INSERT INTO gofe_vpl VALUES ("JS6_26","007_6_26","JOS","6","26","26","ሄ ዎደ እያሱይ፥ “እያርኮ ካታማ ዛር ኬፃናዉ ደንድያ ኦንካ፥ ጎዳ ስንꬃን ባደትዳባ ግዶ። ቡሮ ባስያ ዎደ እያ ባይራ ናአይ ሀይቆ፥ ፐንግያ አꬅያ ዎደ እያ ተሾ ናአይ ሀይቆ” ያግድ ባድስ። ");
INSERT INTO gofe_vpl VALUES ("JS6_27","007_6_27","JOS","6","27","27","ጎዳይ እያሱራ ግድዳ ግሾ፥ እያ ሱንꬃይ ቢታ ኡባ ጋክስ። ");
INSERT INTO gofe_vpl VALUES ("JS7_1","007_7_1","JOS","7","1","1","እስራኤለ አሳይ ድገትዳባ ቦችድ፥ ጎዳስ ኪተቶና እፅዶሶና። ይሁዳ ኮቸ ግድዳ ካርማ ናአይ፥ ዘብዳ ናኣ ናአይ፥ ዛራ ናአይ አካን፥ ድገትዳባታፐ ኤክድ እስራኤለ ቦላ ጎዳ ሀንቁዋ ደንꬅስ። ");
INSERT INTO gofe_vpl VALUES ("JS7_2","007_7_2","JOS","7","2","2","እስራኤለ አሳይ እያርኮ ማታን ዱንካንድ ደእሽን፥ እያሱይ ቤት-አዌና ማታን ቤተለፐ ዶሎሀ ባጋን ደእያ ጋየ ካታማነ እያ ሄራ ፆሞስድ ያና መላ ጉꬃ አሳታ ኪትስ። ኪተትዳ አሳት ብድ፥ ጋየ ካታማ ፆሞስዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS7_3","007_7_3","JOS","7","3","3","ኤንቲ እያሱኮ ስሚድ ይድ፥ “ጋየ ካታማ ኦላናዉ አሳ ኡባይ ባናዉ ኮሸና፤ ናምኡ ዎይኮ ሄꬑ ሙኩሉ ኦላንቾት ቢኮ ግዳና። ያን ጉꬃ አስ ደእያ ግሾ፥ አሳ ኡባይ ዳቡራናዉ በሰና” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS7_4","007_7_4","JOS","7","4","4","ያትን፥ ሄꬑ ሙኩሉ ግድያ አሳት ኦላናዉ ጋየ ካታማ ብዶሶና። ሽን እስራኤለት ጋየ ካታማ አሳ ስንꬃፈ ባቃትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS7_5","007_7_5","JOS","7","5","5","ጋየ ካታማ አሳይ እስራኤለ አሳፐ ሀስታማነ ኡሱፑን አሳ ዎꬍድ፥ ካታማ ድርሳ ፐንግያፈ ዶምድ፥ ሸባርመ ጋካናዉ እስራኤለ አሳ ዎꬍሸ ጎድዶሶና። እስራኤለ አሳ ዎዛናይ ትልእድ፥ ሃ ግድስ። ");
INSERT INTO gofe_vpl VALUES ("JS7_6","007_7_6","JOS","7","6","6","ያንን፥ እያሱይነ እስራኤለ ጭማት አዛንድ፥ ባንታ ማኡዋ ዳክዶሶና። ጎዳ ታቦትያ ስንꬃን ኦማርስ ጋካናዉ ጉፋንዶሶና። ባንታ ሁጰን ብዶ ቆልዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS7_7","007_7_7","JOS","7","7","7","ያትን፥ እያሱይ፥ “ሀይእ ጎዳ ፆሳዉ፥ ዮርዳኖሰ ሻፋ ፕንꬃዳ ነ ኑና ኤህዳይ አሞረታስ ኑና አꬃ እማናሴ? ዮርዳኖሰፐ ሄፍንꬃን ደእዳኮ ኑስ ሎኦሽን። ");
INSERT INTO gofe_vpl VALUES ("JS7_8","007_7_8","JOS","7","8","8","አቤት ጎዳዉ፥ እስራኤለ አሳይ ፆነትድ፥ ባንታ ሞርከታ ስንꬃፈ ባቃትኮ፥ ታ ዎይጎ? ");
INSERT INTO gofe_vpl VALUES ("JS7_9","007_7_9","JOS","7","9","9","ካናነትነ ሀ ቢታን ደእያ አሳ ኡባይ፥ ሄሳ ስእድ፥ ኑና ተቅድ፥ ቢታፈ ꬋይሳና። ያትን፥ ነ ግታ ሱንꬃ ግሾ ነ ኦꬃናይ አይቤ?” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JS7_10","007_7_10","JOS","7","10","10","ጎዳይ እያሱኮ፥ “አይስ ጉፋናዲ? ደንዳ ኤቃ። ");
INSERT INTO gofe_vpl VALUES ("JS7_11","007_7_11","JOS","7","11","11","እስራኤለ አሳይ ቆህዶሶና፤ ታ ኤንታና ኪትዳ ኪታ ናጎና እፅድ፥ ጫቁዋ መንꬅዶሶና። ኤንቲ ድገትዳባፐ ኤክዶሶና፤ ካይሶትዶሶና፤ ዎርዶትዶሶና፤ ቃስ ሄ ሚሽያ ባንታ ሚሽያራ ዋላክዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS7_12","007_7_12","JOS","7","12","12","ሄሳ ግሾ፥ እስራኤለ አሳይ ባንታ ሞርከታ ስንꬃን ኤቃናዉ ዳንዳእቦኮና። ኤንቲ ꬋያናዉ በሲያ ግሾ፥ ባንታ ሞርከታ ስንꬃፈ ጉየ ስሚድ ባቃትዶሶና። ህንተ ግዶፈ ꬋያናዉ በሲያባ ህንተ ꬋይሶና እፅኮ፥ ህዛፐ ታ ህንተራ ግድከ።” ");
INSERT INTO gofe_vpl VALUES ("JS7_13","007_7_13","JOS","7","13","13","ባዳ አሳ ጌሻ። ጎዳይ፥ እስራኤለ ፆሳይ፥ “ህንተ ኤካናዉ በሶናባ ኤክዳ ግሾ፥ ዎንቶስ ህንተናተꬃ ጌሽተ” ያጌስ ጋዳ ኦዳ። እስራኤለ አሳዉ፥ ሄሳ ህንተ ግዶፈ ድጎና እፅኮ፥ ህንተ ሞርከታ ስንꬃን ኤቃናዉ ዳንዳኤከታ። ");
INSERT INTO gofe_vpl VALUES ("JS7_14","007_7_14","JOS","7","14","14","ዎንቶ ዎንታ፥ ህንተ ዛርያን ዛርያን ሺቅተ። ጎዳይ ሻክያ ዛረይ ባ ኮቻን ኮቻን ሺቆ። ጎዳይ ሻክያ ኮቻይ ባ ሶ አሳን አሳን ሺቆ፤ ቃስ ጎዳይ ሻክያ ሶ አሳይ፥ እሶይ እሶይ ባዉ ሺቆ። ");
INSERT INTO gofe_vpl VALUES ("JS7_15","007_7_15","JOS","7","15","15","ድገትዳባ ኤክዳ ኡራይ ጎዳ ጫቁዋ መንꬅዳይነ እስራኤለ አሳ ቆህዳይ እያ ግድያ ግሾ፥ እነ እያዉ ደእያባ ኡባይ ታማን ፁገቶ። ");
INSERT INTO gofe_vpl VALUES ("JS7_16","007_7_16","JOS","7","16","16","እያሱይ ዎንተꬃ ጋላስ ጉራ ደንድድ፥ ኮቻን ኮቻን እስራኤለ አሳ ሺሽን፥ ጎዳይ ይሁዳ ኮቻይ ባላ ግደይሳ በስስ። ");
INSERT INTO gofe_vpl VALUES ("JS7_17","007_7_17","JOS","7","17","17","እያሱይ ይሁዳ ኮቻ ሺሽን፥ ጎዳይ ዛራሀ ኮቻይ ባላ ግደይሳ በስስ። ዛራሀ ኮቻ ሺሽን፥ ጎዳይ ዛብዳ ሶ አሳይ ባላ ግደይሳ በስስ። ");
INSERT INTO gofe_vpl VALUES ("JS7_18","007_7_18","JOS","7","18","18","ዛብዳ ሶ አሳይ እሶይ እሶይ ባዉ ሺቅን፥ ዉርሰꬃን ጎዳይ ዛብዳ ናአ ናኣ፥ ካርማ ናኣ አካን ባላ ግደይሳ ቆንጭስስ። ");
INSERT INTO gofe_vpl VALUES ("JS7_19","007_7_19","JOS","7","19","19","እያሱይ አካናኮ፥ “ታ ናአዉ፥ ጎዳ፥ እስራኤለ ፆሳ ቦንቻ፤ አነ ነ ኦꬅዳባ ታዉ ቆሶና ኦዳ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JS7_20","007_7_20","JOS","7","20","20","አካን ዛሪድ፥ “ኤ ቱማ፥ ታኒ ጎዳ እስራኤለ ፆሳ ናቃስ። ታኒ ኦꬅዳይ ሀይሳ፤ ");
INSERT INTO gofe_vpl VALUES ("JS7_21","007_7_21","JOS","7","21","21","ኑኒ ድእድ ኤክዳ ሚሽያ ግዶፈ እስ ሎኦ ሳናኦራ ቢታ ካባ፥ ናምኡ ክሎ ግድያ ብራታ ብራነ ባጋ ክሎ ግድያ ዎርቃ በአዳ አሞታስ፤ ኤካስ። ያታዳ ታ ዱንካንያ ግዶን ቢታ ቦካዳ ብራ ጋርሳራ ዎꬃዳ ሞጋስ።” ");
INSERT INTO gofe_vpl VALUES ("JS7_22","007_7_22","JOS","7","22","22","ያትን፥ እያሱይ አሰ ኪትስ። ኤንቲ ዎፅ ብድ ዱንካንያ ግዶን ብራ ጋርሳራ ዎꬅድ ሞግዳ ሚሸታ ደምዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS7_23","007_7_23","JOS","7","23","23","ኪተትድ ብዳ አሳት ሄ ሚሸታ ዱንካንያፐ እያሱኮነ እስራኤለ አሳ ኡባኮ ኤህድ፥ ጎዳ ስንꬃን ዎꬅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS7_24","007_7_24","JOS","7","24","24","ያትን እያሱይነ እስራኤለ አሳ ኡባይ፥ አካና፥ ብራ፥ ካባ፥ ዎርቃ፥ እያ አደ ናይታነ እያ ማጫ ናይታ፥ እያ መህያ፥ እያ ሀረታ፥ እያ ዶርሳታ፥ እያ ዱንካንያነ እያዉ ደእያባ ኡባ መቶ ዛንጋራ ጌተትያ በሳ ኤፍዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS7_25","007_7_25","JOS","7","25","25","እያሱይ አካናኮ፥ “ሀ መቱዋ ኑ ቦላ አይስ ኤሀዲ? ጎዳይ ሀች ነ ቦላ መቶ ኤሀና” ያግስ። ያትን እስራኤለ አሳ ኡባይ፥ አካናነ እያ ሶ አሳ ሹቻን ጫድ ዎꬍድ፥ እያዉ ደእያባ ኡባራ ዎል ጋꬅድ ታማን ፁግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS7_26","007_7_26","JOS","7","26","26","ኤንቲ አካና ቦላ ሀች ጋካናዉ በንትያ ዳሮ ሹች ኬልዶሶና። ያትን፥ ጎዳይ ባ ኤፅያ ሀንቁዋፈ ስምስ። ሀች ጋካናዉ ሄ በሳይ መቶ ዛንጋራ ጌተትድ ፄገቴስ። ");
INSERT INTO gofe_vpl VALUES ("JS8_1","007_8_1","JOS","8","1","1","ጎዳይ እያሱኮ፥ “ያዮፋ፤ ህርጎፋ፤ ኦላንቾታ ኡባ ኔራ ኤካዳ፥ ጋየ ካታማ ኦላናዉ ከያ። ጋየ ካዋ፥ እያ አሳ፥ እያ ካታማነ እያ ቢታ ታ ነ ኩሸን አꬃዳ እማስ። ");
INSERT INTO gofe_vpl VALUES ("JS8_2","007_8_2","JOS","8","2","2","ኔን እያርኮ ቦላነ እያ ካዋ ቦላ ኦꬅዳይሳዳ ጋየ ቦላነ እያ ካዋ ቦላ ኦꬃና። ሽን ህንተ ሀእ ኦልድ ድእያ ሻሎነ መሄ ህንተዉ ኤክተ። ካታማፐ ጉየ ባጋራ ቆፖና መንꬃ ገላናዉ ጊገታ።” ");
INSERT INTO gofe_vpl VALUES ("JS8_3","007_8_3","JOS","8","3","3","ሄሳ ግሾ፥ እያሱይነ ኦላንቾት ኡባይ፥ ጋየ ካታማ ኦላናዉ ደንድዶሶና። እያሱይ ባ ኦላንቾታ ግዶፈ ሀስታሙ ሙኩሉ ግድያ ምኖ ኦላንቾታ ዶርድ ቃማ የድሸ፥ ");
INSERT INTO gofe_vpl VALUES ("JS8_4","007_8_4","JOS","8","4","4","ኤንታና ሀይሳዳ ያግድ ኪትስ፤ “ብድ ካታማፐ ጉየ ባጋራ ቆሰትድ ናግተ። ካታማፐ ሃክድ ቦናሽን፥ መንꬅ ገላናዉ ጊግድ ናግተ። ");
INSERT INTO gofe_vpl VALUES ("JS8_5","007_8_5","JOS","8","5","5","ታነ ታራ ደእያ አሳ ኡባይ፥ ካታማኮ ሺቃና። ሄ ዎደ ጋየ ካታማ አሳይ ኑና ኦላናዉ ያ ዎደ ካሰይሳዳ ኑ ኤንታ ስንꬃፈ ጉየ ስሚድ ባቃታና። ");
INSERT INTO gofe_vpl VALUES ("JS8_6","007_8_6","JOS","8","6","6","ኤንቲ ከሰይሳዳ ኑ ኤንታ ስንꬃፈ ባቃትያ ዳንን፥ ኑፐ ባቃቶሶና ግድ፥ ካታማፐ ኑ ኤንታ ሃሳና ጋካናዉ ኑና ካላና። ");
INSERT INTO gofe_vpl VALUES ("JS8_7","007_8_7","JOS","8","7","7","ሄ ዎደ ህንተ ቆሰትዳ በሳፈ ከይድ ካታማ ኦይክተ። ጎዳይ ህንተ ፆሳይ ካታማ ህንተ ኩሸን አꬅድ እማና። ");
INSERT INTO gofe_vpl VALUES ("JS8_8","007_8_8","JOS","8","8","8","ካታማ ኦይክዳፐ ጉየ፥ ጎዳይ ኪትዳይሳ መላ ታማን ፁግተ። ታ ህንተና ኪታስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JS8_9","007_8_9","JOS","8","9","9","ሄሳፈ ጉየ እያሱይ ኦላንቾታ ኪትስ። ኤንቲ ብድ ጋየ ካታማፐ ዉሎሀ ባጋን ቤተለፐነ ጋየፐ ግዶን ቆሰትድ ናግዶሶና። ሽን እያሱይ ሄ ቃማ አሳራ አቅስ። ");
INSERT INTO gofe_vpl VALUES ("JS8_10","007_8_10","JOS","8","10","10","ዎንተꬃ ጋላስ ጉራ እያሱይ ደንድድ፥ ኦላንቾታ ፄግስ። ያትድ፥ እነ እስራኤለ ጭማት ኦላንቾታ ካለꬅድ ጋየ ካታማ ብዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS8_11","007_8_11","JOS","8","11","11","እያራ ደእያ ኦላንቾት ኡባይ፥ ስን ብድ ጋየ ካታማ ማትድ፥ ካታማፐ ፑደሀ ባጋን ዱንካንዶሶና። ኤንታፈነ ጋየ ካታማፐ ግዶን ዛንጋር ደኤስ። ");
INSERT INTO gofe_vpl VALUES ("JS8_12","007_8_12","JOS","8","12","12","እያሱይ እቻሹ ሙኩሉ ኦላንቾታ ዶርድ፥ ካታማፐ ዉሎሀ ባጋራ፥ ቤተለፐነ ጋየፐ ግዶን ቆስድ ዎꬅስ። ");
INSERT INTO gofe_vpl VALUES ("JS8_13","007_8_13","JOS","8","13","13","ኦላንቾታፐ ባጋ ካታማፐ ፑደሀ ባጋራ፥ ቃስ ካታማ መንꬅድ ገላና ኦላንቾታ ዉሎሀ ባጋራ በሰ በሰ ኦይꬅስ። ሄ ቃማ እያሱይ ሄ ዛንጋራን አቅስ። ");
INSERT INTO gofe_vpl VALUES ("JS8_14","007_8_14","JOS","8","14","14","ጋየ ካታማ ካዎይ ሄሳ በእዳ ዎደ፥ ባ ኦላንቾታ ኡባ ኤክድ፥ እስራኤለ አሳራ ኦለታናዉ ደምባ ቢታ ከይዶሶና። ሽን ካዎይ ካታማፐ ጉየ ባጋራ ቆሰት ኡትዳ ኦላንቾት ደኤይሳ ኤርቤና። ");
INSERT INTO gofe_vpl VALUES ("JS8_15","007_8_15","JOS","8","15","15","እያሱይነ እስራኤለ አሳ ኡባይ ፆነትዳባ ዳንድ፥ ኤንታ ስንꬃፈ መላ ቢታ ስሚድ ባቃትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS8_16","007_8_16","JOS","8","16","16","ጋየ ካታማን ደእያ አሳ ኡባይ፥ ኤንታ የደꬃናዉ ፄገረት ከይድ፥ እያሱ ጎድሸ ካታማፐ ሃክድ ብዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS8_17","007_8_17","JOS","8","17","17","ጋየ ዎይኮ ቤተለን ደእያ አሳ ኡባይ፥ እስራኤለ አሳ የደꬃናዉ ካታማ የግድ ከይን ካታማ ፐንገያ ናግያ አስ ꬋይዳ ግሾ፤ ዶያ አትስ። ");
INSERT INTO gofe_vpl VALUES ("JS8_18","007_8_18","JOS","8","18","18","ሄሳፈ ጉየ ጎዳይ እያሱኮ፥ “ነ ቶራ ጋየ ካታማ ቦላ ደንꬃ። ታኒ ጋየ ካታማ ነ ኩሸን አꬃዳ እማና” ያግስ። ያትን እያሱይ ባ ቶራ ካታማ ቦላ ደንꬅስ። ");
INSERT INTO gofe_vpl VALUES ("JS8_19","007_8_19","JOS","8","19","19","እያሱይ ባ ቶራ ደንꬅዳ ዎደ ቆሰትዳ ኦላንቾት ባንታ በሳፈ ደንድድ፥ ካታማ ገል ኦይክድ፥ ኤለስድ ታማን ፁግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS8_20","007_8_20","JOS","8","20","20","ጋየ ካታማ አሳይ ጉየ ስሚድ ፄልያ ዎደ፥ ካታማ ጩያይ ሳሎ ደንድሽን በእዶሶና። መላ ቢታ ባቃትዳ እስራኤለ አሳይ፥ ባንታና የደꬅያ አሳ ቦላ ጉየ ስምዳ ግሾ፥ ኤንቲ አዉ ባጋራካ ከስ ኤካናዉ ዳንዳእቦኮና። ");
INSERT INTO gofe_vpl VALUES ("JS8_21","007_8_21","JOS","8","21","21","እያሱነ እያራ ደእያ አሳ ኡባይ፥ ቆሰት ኡትዳ ኦላንቾት ካታማ ኦይክዳይሳነ ጩያይ ሳሎ ደንድዳይሳ በእዳ ዎደ ጉየ ስሚድ፥ ጋየ ካታማ አሳ ዎꬍዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS8_22","007_8_22","JOS","8","22","22","ካታማ ገልድ ኦይክዳ ኦላንቾትካ ካታማፐ ኤንታ ቦላ ከይዶሶና። ያትን፥ ጋየ አሳይ እስራኤለ ኦላንቾታን ኡባ ባጋራ ተቀትዳ ግሾ፥ እሶይካ አቶና ዎይኮ ከስ ኤኮና ኡባ ዎꬍድ ዉርስዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS8_23","007_8_23","JOS","8","23","23","ሽን ጋየ ካታማ ካዋ ደእድ፥ እያሱኮ ኤህዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS8_24","007_8_24","JOS","8","24","24","እስራኤለ አሳይ ጋየ ካታማ አሳ ኤንታና የደꬅዳ በሳን ማሻን ዎꬍድ ኦንግዳፐ ጉየ፥ ኡባይ ጉየ ካታማ ስሚድ፥ ካታማን አትዳ አሳ ኡባ ማሻን ዎꬍዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS8_25","007_8_25","JOS","8","25","25","ሄ ጋላስ ጋየ ካታማን ሀይቅዳ አደይነ ማጭ ታማነ ናምኡ ሙኩላ። ");
INSERT INTO gofe_vpl VALUES ("JS8_26","007_8_26","JOS","8","26","26","እያሱይ ጋየ ካታማን ደእያባ ኡባ ኦንጋና ጋካናዉ ካታማ ቦላ ደንꬅዳ ቶራ ዱገ ዎꬅቤና። ");
INSERT INTO gofe_vpl VALUES ("JS8_27","007_8_27","JOS","8","27","27","ሽን ጎዳይ እያሱ ኪትዳይሳ መላ እስራኤለ አሳይ ሄ ካታማ መህያነ ሻሉዋ ባንታዉ ድእዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS8_28","007_8_28","JOS","8","28","28","እያሱይ ጋየ ካታማ ፁግስ፤ ሄ ካታማይ ሀች ጋካናዉ ላለꬃ ዶረነ አስ ባይና በሲ ግድድ አትስ። ");
INSERT INTO gofe_vpl VALUES ("JS8_29","007_8_29","JOS","8","29","29","እያሱይ፥ ጋየ ካታማ ካዋ ዎꬍድ ኦማርስ ጋካናዉ ምꬃ ቦላ ካቅስ። አው ዉልያ ዎደ፥ እያ አሀ ካታማ ገልያ ፐንገን የጋና መላ ኦꬅስ። እያ ቦላ ዳሮ ሹቻ ኬልዶሶና፤ ሄ ኬላ ሹቻይ ሀች ጋካናዉ ሄ በሳን ደኤስ። ");
INSERT INTO gofe_vpl VALUES ("JS8_30","007_8_30","JOS","8","30","30","ሄሳፈ ጉየ፥ እያሱይ ኤባላ ደርያ ቦላ ጎዳስ እስራኤለ ፆሳስ ያርሾ በሲ ኬፅስ። ");
INSERT INTO gofe_vpl VALUES ("JS8_31","007_8_31","JOS","8","31","31","ጎዳ አይለይ ሙሰይ እስራኤለ አሳ ኪትዳይሳዳነ ህገ ማፃፋን ፃፈትዳይሳዳ፥ ያርሾ በሳ ማሰትቦናነ ብራት ቦችቦና ሹቻፈ ኬፅድ፥ እያ ቦላ ጎዳስ ፁሳ ያርሾነ እስፈተꬃ ያርሾ ያርሽዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS8_32","007_8_32","JOS","8","32","32","እያሱይ፥ እስራኤለ አሳ ስንꬃን፥ ሙሰ ህግያ ሹቻ ቦላ ዛሪድ ፃፍስ። ");
INSERT INTO gofe_vpl VALUES ("JS8_33","007_8_33","JOS","8","33","33","እስራኤለ አሳ አንጃና መላ ጎዳ አይለይ ሙሰይ ኪትዳይሳዳ እስራኤለ አሳ ኡባይ፥ አሳ ጋደ አሳታ፥ ኤንታ ጭማት፥ ኤንታ ሹማትነ ዳይናት ኡባይ፥ ጎዳ ጫቆ ታቦትያ ቶክዳ ሌወ ኮቸ ግድዳ ካህነታ ስንꬃን ኡሻቻ ባጋንነ ሀድርሳ ባጋን ኤቅዶሶና። ኤንታፈ ባጋይ ጋርዛና ዙማ ስንꬃን፥ ቃስ ባጋይ ኤባላ ደርያ ስንꬃን ኤቅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS8_34","007_8_34","JOS","8","34","34","ህገ ማፃፋን ፃፈትዳይሳዳ፥ እያሱይ ህገ ቃላ ኡባ፥ አንጁዋነ ባደꬃ ናባብስ። ");
INSERT INTO gofe_vpl VALUES ("JS8_35","007_8_35","JOS","8","35","35","ሙሰይ ኪትዳ ህግያ እያሱይ፥ እስራኤለ አሳ ኡባስ፥ ማጫሳስ፥ ናይታስነ፥ አሳ ጋደ አሳስ እስ ቃላካ አሾና ናባብስ። ");
INSERT INTO gofe_vpl VALUES ("JS9_1","007_9_1","JOS","9","1","1","ዮርዳኖሰ ሻፋፐ ዉሎሀ ባጋን ደረይ ዳርያ ቢታንነ ጋꬋን መደትራነ አባፈ ብድ ልባኖሰ ጋካናዉ ደእያ ህተታ፥ አሞረታ፥ ካናነታ፥ ፓርዘታ፥ ህወታነ ያቡሰታ ካዎት ኡባይ፥ ጋየ አሳይ ፆነትዳይሳ ስእዳ ዎደ፥ ");
INSERT INTO gofe_vpl VALUES ("JS9_2","007_9_2","JOS","9","2","2","እያሱነ እስራኤለታ ኦላናዉ እስፈ ሺቅድ ዞረትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS9_3","007_9_3","JOS","9","3","3","ጋባኦና አሳይ እያሱይ እያርኮ ቦላነ ጋየ ካታማ ቦላ ኦꬅዳባ ስእድ፥ ");
INSERT INTO gofe_vpl VALUES ("JS9_4","007_9_4","JOS","9","4","4","እያሱ ጭማናዉ ኮይዶሶና። ኤንቲ ሽንቀ ቃችድ፥ ጭማ ዎይነ ኦጎሮነ ጩርቃ ቃርፂቴ ሀረ ቦላ ጫንድ፥ እያሱኮ አሰ ኪትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS9_5","007_9_5","JOS","9","5","5","ኪተትዳ አሳት ዉርዳ ጫማ አꬅዶሶና፤ ፔትዳ አፍላ ማእዶሶና፤ ኤንቲ ኦይክዳ ሽንቀይካ መልዳባነ መቀርትዳባ። ");
INSERT INTO gofe_vpl VALUES ("JS9_6","007_9_6","JOS","9","6","6","ኤንቲ እስራኤለ አሳይ ዱንካንዳ ጉታ ጋልጋላ ብድ፥ እያሱኮነ እስራኤለ አሳኮ፥ “ኑኒ ሃሆ ጋደፐ ይዳ። ኑ ይዳይ ህንተራ ጫቀትድ ሳሮ ዳናሳ” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS9_7","007_9_7","JOS","9","7","7","ያትን፥ እስራኤለ አሳይ ጋባኦነ አሳኮ፥ “ህንተ ኑ ማታን ደእያ አሰኮሽ? ኑ አይብን ኤርድ ህንተራ ጫቀታኔ?” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS9_8","007_9_8","JOS","9","8","8","ኤንቲ እያሱኮ፥ “ኑ ነ አይለታ” ያግድ ዛርዶሶና። እያሱይ ዛሪድ፥ “ህንተ ኦናንቴ? አዉፐ ይደቲ?” ያግድ ኦይችስ። ");
INSERT INTO gofe_vpl VALUES ("JS9_9","007_9_9","JOS","9","9","9","ኤንቲ ዛሪድ፥ “ኑኒ ነ አይለት ጎዳይ ህንተ ፆሳይ ግብፀን ኦꬅዳይሳ ስእዳ ግሾ፥ ዳሮ ሃሆ ጋደፐ ይዳ። ");
INSERT INTO gofe_vpl VALUES ("JS9_10","007_9_10","JOS","9","10","10","ቃስ ዮርዳኖሰ ሻፋፐ ሄፍንꬃን ዉሎሀ ባጋን ደእያ ናምኡ አሞረ ካዎታ፥ ሀሰቦና ካዋ ስሆናነ አስታሮተን ደእያ ባሳነ ካዋ ኦገ ቦላ እ ኦꬅዳይሳ ኑ ስእዳ። ");
INSERT INTO gofe_vpl VALUES ("JS9_11","007_9_11","JOS","9","11","11","ኑ ቢታ ጭማትነ ኑ ቢታን ደእያ ኡባይ፥ ኦገስ ሽንቀ ጊግስ ኦይክድ ብድ ኤንታራ ጋሄትድ፥ ኤንታኮ፥ ‘ኑ ህንተ አይለታ፤ ኑ ይዳይ ህንተራ ጫቀትድ ሳሮ ዳናሳ’ ያግተ። ");
INSERT INTO gofe_vpl VALUES ("JS9_12","007_9_12","JOS","9","12","12","“ኑ ኦይክዳ ሽንቅያ በእተ። ኑ ሶፐ ኤክድ ከይያ ዎደ ሆኦ፥ ሽን ሀእ መልዳይሳነ ፑሉምዳይሳ በእተ። ");
INSERT INTO gofe_vpl VALUES ("JS9_13","007_9_13","JOS","9","13","13","ሀ ዎይንያ ኦጎሮታን ኑ ኩንꬅያ ዎደ ኦራꬅ፥ ሽን ሀእ ዳከትዳይሳ በእተ። ኦግያ ሃሆተꬃፈ ደንዶይሳን ኑ ማኦይነ ኑ ጫማይ ዉርስ” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS9_14","007_9_14","JOS","9","14","14","ሽን ጎዳ ሸንያ ኦይቾና ደእሸ፥ እስራኤለ አሳይ ኤንታ ሽንቅያፈ ጉꬃራ ኤክዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS9_15","007_9_15","JOS","9","15","15","ያትን፥ እያሱይ ህንተና ዎꬎኮ ግድ ሳሮ ጫቆ ኤንታራ ጫቀትስ። እስራኤለ ጭማትካ ሄ ጫቁዋ መንꬆኮ ግድ ጫቅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS9_16","007_9_16","JOS","9","16","16","ኤንታራ ጫቅዳ ሄꬓንꬆ ጋላሳን ሄ አሳት ኤንታ ቢታን ደኤይሳነ ኤንታዉ ሾሮ ግደይሳ እስራኤለ አሳይ ስእዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS9_17","007_9_17","JOS","9","17","17","እስራኤለ አሳይ ሄꬑ ጋላስ ሄመትድ፥ ሄ አሳት ደእያ ካታማታ ጋክዶሶና። ኤንታ ካታማት ጋባኦና፥ ካፍራ፥ ባሮተነ ቅርያት-ይኣርማ ጌተትድ ፄገቶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS9_18","007_9_18","JOS","9","18","18","ሽን እስራኤለ ጭማት ኤንታዉ ጎዳ፥ እስራኤለ ፆሳ ሱንꬃን ጫቅዳ ግሾ፥ እስራኤለ አሳይ ኤንታ ዎꬍቦኮና። ያትን፥ አሳ ኡባይ ጭማታ ቦላ ዙዙምዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS9_19","007_9_19","JOS","9","19","19","ሽን እስራኤለ ጭማት፥ “ኑ ኤንታዉ ጎዳ እስራኤለ ፆሳ ሱንꬃን ጫቅዳ ግሾ፥ ሀእ ኤንታ ቦቻናዉ ዳንዳኦኮ። ");
INSERT INTO gofe_vpl VALUES ("JS9_20","007_9_20","JOS","9","20","20","ኑኒ ኤንታዉ ሀይሳዳ ኦꬃና፤ ኑኒ ኤንታዉ ጫቅዳ ጫቁዋ መንꬅን ጎዳ ሀንቆይ ኑ ቦላ ዮናዳ ኤንታ ዎꬎኮ። ");
INSERT INTO gofe_vpl VALUES ("JS9_21","007_9_21","JOS","9","21","21","ኤንቲ ደኦ ጊተ። ግዶሽን እስራኤለ አሳ ኡባስ ምꬅነ ሃ ሺሸይሳታ ግዶ” ያግዶሶና። ሄሳ ግሾ፥ ጭማት ባንታ ጫቁዋ ናግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS9_22","007_9_22","JOS","9","22","22","እያሱይ ጋባኦና አሳ ፄግድ፥ “ኑ ማታን ደእሸ፥ ‘ኑኒ ዳሮ ሃሆ ቢታፈ ይዳ’ ግድ፥ ኑና አይስ ጭምደቲ? ");
INSERT INTO gofe_vpl VALUES ("JS9_23","007_9_23","JOS","9","23","23","ህንተ ሄሳ ኦꬅዳ ግሾ፥ ባደትዳይሳታ። ህንተ መርናዉ ታ ፆሳ ኬꬃን ምꬅነ ሃ ሺሽያ አይለ ግዳና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JS9_24","007_9_24","JOS","9","24","24","ኤንቲ ዛሪድ፥ “ኑኒ ነ አይለት፥ ጎዳይ ህንተ ፆሳይ ሀ ቢታን ደእያ አሳ ኡባ ꬋይስድ፥ ቢታ ህንተዉ እማናዉ ባ አይልያ ሙሰስ ኦድዳይሳ ስእዳ። ሄሳ ግሾ፥ ህንተዉ ባብድ ሀይሳ ኦꬅዳ። ");
INSERT INTO gofe_vpl VALUES ("JS9_25","007_9_25","JOS","9","25","25","ሀእ ኑኒ ነ ኩሸን ደኦስ። ነዉ ሎኦነ ሱረ ዳንድ በንትዳባ ኦꬃ” ግድ ዛርዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS9_26","007_9_26","JOS","9","26","26","እያሱይ እስራኤለ አሳይ ኤንታ ዎꬎና መላ አሽስ። ");
INSERT INTO gofe_vpl VALUES ("JS9_27","007_9_27","JOS","9","27","27","ሄ ጋላስ እያሱይ፥ ጋባኦና አሳታ እስራኤለታስነ ጎዳይ ዶርዳ በሳን ደእያ እያ ያርሾ በሳስ ሃነ ምꬅ ሺሽያ አስ ግዳና መላ ኦꬅስ። ጋባኦና አሳት ሀች ጋካናዉ ሄሳ ኦꬆሶና። ");
INSERT INTO gofe_vpl VALUES ("JS10_1","007_10_1","JOS","10","1","1","እያሱይ እያርኮ ካታማ ኦል ꬋይስድ፥ እያ ካዋ ዎꬍዳይሳዳ፥ ጋየ ካታማ ኦል ꬋይስድ፥ እያ ካዋ ዎꬍዳይሳ የሩሳላመ ካዎይ አዶን-ፀደቅ ስእስ። ቃስ ጋባኦና አሳይ እስራኤለ አሳራ ሳሮ ዳናዉ ጫቀትዳይሳ ስእስ። ");
INSERT INTO gofe_vpl VALUES ("JS10_2","007_10_2","JOS","10","2","2","ጋባኦን ሀንኮ ካዎ ካታማታዳ ግታ ካታማ፤ ሄ ካታማይ ጋየ ካታማፐ አꬌስ፤ እያን ደእያ አደትካ ምኖ ኦላንቾ ግደይሳ ኤርያ ግሾ፥ አዶንፀደቅነ እያ አሳይ ዳሮ ያይዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS10_3","007_10_3","JOS","10","3","3","ሄሳ ግሾ፥ የሩሳላመ ካዎይ አዶን-ፀደቅ፥ ከብሮና ካዋ ሆሀማስ፥ ያርሙታ ካዋ ፕራማስ፥ ላክሶ ካዋ ያፍአስነ፥ ኤግሎና ካዋ ዳብራስ ሀይሳዳ ያግድ ኪትስ፤ ");
INSERT INTO gofe_vpl VALUES ("JS10_4","007_10_4","JOS","10","4","4","“ጋባኦና አሳይ እያሱራነ እስራኤለ አሳራ ሳሮ ደአናዉ ጫቅዳ ግሾ፥ ኤንታ ኦላናዉ ይድ ታና ማድተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JS10_5","007_10_5","JOS","10","5","5","ሀ እቻሹ አሞረ ካዎት ባንታ ኦላንቾታ እስፈ ጋꬅድ፥ ጋባኦና ኦልዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS10_6","007_10_6","JOS","10","6","6","ጋባኦና አሳይ ጋልጋላን ዱንካንዳ እያሱኮ፥ “ኑና ነ አይለታ አጎፋ፤ ኤለሳ ያዳ ኑና አሻ። ደረይ ዳርያ ቢታን ደእያ አሞረ ካዎት ኡባይ ኑና ኦላናዉ ባንታ ኦላንቾታ እስኖ ኦꬅዳ ግሾ፥ ነ ኑና ማዳ” ያግድ ኪትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS10_7","007_10_7","JOS","10","7","7","ሄሳ ግሾ፥ እያሱይ፥ ባራ ደእያ ኦላንቾታነ ምኖ አሳታ ኡባ፥ ጋልጋላፐ ኤክድ ብስ። ");
INSERT INTO gofe_vpl VALUES ("JS10_8","007_10_8","JOS","10","8","8","ጎዳይ እያሱኮ፥ “ኤንታዉ ባቦፋ፤ ታኒ ኤንታ ነ ኩሸን አꬃዳ እማስ። ኤንታፈ እስ አስካ ኔራ ኤቀታናዉ ዳንዳኤና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JS10_9","007_10_9","JOS","10","9","9","እያሱይ ጋልጋላፐ ቃማ ኩመꬅ ሄመትሸ አቅድ፥ ጋባኦነ አሳይ ቆፖና ደእሽን ኤንታ ቦላ ኦላ ደንꬅስ። ");
INSERT INTO gofe_vpl VALUES ("JS10_10","007_10_10","JOS","10","10","10","ጎዳይ እስራኤለ አሳ ስንꬃን ኤንታዉ ዎዛና ካሀ ꬋይስስ። እስራኤለ አሳይ ኤንታ ጋባኦናን ዎꬍዶሶና። እስራኤለት ኤንታ ቤት-ሆሮና ኤፍያ ኦግያ ኦይꬅድ ጎድሸ፥ አዜቃነ ማቀዳ ጋካናዉ ጎድዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS10_11","007_10_11","JOS","10","11","11","ኤንቲ ቤት-ሆሮናፐ ዱገ አዜቃ ኤፍያ ኦግያራ እስራኤለ አሳ ስንꬃፈ ባቃትሽን፥ ጎዳይ ግታ ሻቻ ሹቹ ሳሎፐ ኤንታ ቦላ ቡክስስ። እስራኤለ አሳይ ዎꬍዳ አሳፐ፥ ሻቻይ ዎꬍዳ አሳይ ዳሮ። ");
INSERT INTO gofe_vpl VALUES ("JS10_12","007_10_12","JOS","10","12","12","ጎዳይ እስራኤለ አሳስ አሞረታ፥ አꬅድ እምዳ ጋላስ፥ እስራኤለ አሳይ ስእሽን፥ እያሱይ፥ “አዋይ ጋባኦና ቦላ ዉሎና ኤቆ። አጌናይካ ኤሎና ዛንጋራ ቦላ ኤቆ” ያግድ ጎዳ ዎስስ። ");
INSERT INTO gofe_vpl VALUES ("JS10_13","007_10_13","JOS","10","13","13","እስራኤለ አሳይ ባንታ ሞርከታ ፆናና ጋካናዉ፥ አዋይ ዉሎና ኤቅስ፤ አጌናይካ ባ ደእያ በሳፈ ቃፅቤና። ሄስ ያሻራ ማፃፋን ፃፈትስ። አዋይ ሳሎስ ግዶን ቃፆና ኤቅስ፤ እስ ጋላስ ኩመꬅ አዋይ ዉሎና ጋምእስ። ");
INSERT INTO gofe_vpl VALUES ("JS10_14","007_10_14","JOS","10","14","14","ጎዳይ አሳ ቃላ ስእዳ ሄ ጋላሳ መላ ጋላስ ሀይሳፈ ካሰካ ሀይሳፈ ስንꬃንካ ዴና። ቱማካ ጎዳይ እስራኤለ አሳስ ኦለትስ። ");
INSERT INTO gofe_vpl VALUES ("JS10_15","007_10_15","JOS","10","15","15","ሄሳፈ ጉየ፥ እያሱይነ እያ ኦላንቾት ባንታ ዱንካንዳ ጉታ ጋልጋላ ስምዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS10_16","007_10_16","JOS","10","16","16","ሄ እቻሹ አሞረ ካዎት ባቃትድ፥ ማቀዳ ጎንጎሉዋን ቆሰትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS10_17","007_10_17","JOS","10","17","17","እቻሹ ካዎት፥ ማቀዳ ጎንጎሉዋን ቆሰትድ ደእሽን ደምዳይሳ እያሱስ ኦድዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS10_18","007_10_18","JOS","10","18","18","እያሱይ ዛሪድ፥ “ግታ ሹቻታ ጎንዶርስድ፥ ጎንጎሉዋ ዶና ጎርድተ፤ ኤንታ ናጋና መላ አሰ ያን ዎꬅተ። ");
INSERT INTO gofe_vpl VALUES ("JS10_19","007_10_19","JOS","10","19","19","ሽን ህንተ ያን ጋምኦፍተ፤ ኤንቲ ባንታ ካታማ ገልድ አቶና መላ ህንተ ሞርከታ ጎድድ ኤንታ ዎꬍተ። ጎዳይ ህንተ ፆሳይ ኤንታ ህንተ ኩሸን አꬅድ እምስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JS10_20","007_10_20","JOS","10","20","20","ጉꬃ አሳት ባቃትድ ባንታ ግምበትዳ ካታማ ገልድ አትኮካ፥ እያሱይነ እስራኤለ አሳይ አሳ ኡባ ዎꬍዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS10_21","007_10_21","JOS","10","21","21","ሄሳፈ ጉየ፥ እስራኤለ አሳ ኡባይ ሳሮን ስሚድ፥ እያሱይ ዱንካንድ ደእያ ጉታ ማቀዳ ይዶሶና። ሄ ዎደፐ ዶምድ ኦንካ እስራኤለ አሳ ቦላ እስ ቃላካ ኦደታናዉ ፃልዳ አስ ባዋ። ");
INSERT INTO gofe_vpl VALUES ("JS10_22","007_10_22","JOS","10","22","22","ሄሳፈ ጉየ፥ እያሱይ፥ “ጎንጎሉዋ ዶና ዶይድ፥ ሄ እቻሹ ካዎታ ከስድ፥ ታዉ ሀ ኤክድ ዪተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JS10_23","007_10_23","JOS","10","23","23","ጎንጎሉዋ ዶና ዶይድ፥ የሩሳላመ ካዋ፥ ከብሮና ካዋ፥ ያርሙታ ካዋ፥ ላክሶ ካዋነ ኤግሎና ካዋ እያኮ ኤህዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS10_24","007_10_24","JOS","10","24","24","ኤንቲ ሄ ካዎታ እያኮ ኤህዳ ዎደ፥ እያሱይ እስራኤለ አሳ ኡባ ባኮ ፄግድ፥ ባራ ብዳ ቶራ ሞጮናታኮ፥ “ሃ ይድ፥ ህንተ ቶሁዋ ሀ ካዎታ ቆꬍያን ዎꬅተ” ያግስ። ኤንቲ ይድ ኪተትዳይሳዳ ኦꬅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS10_25","007_10_25","JOS","10","25","25","እያሱይ ኤንታኮ፥ “ህንተ ኦለትያ ህንተ ሞርከታ ቦላ ጎዳይ ሀይሳዳ ኦꬃና ግሾ፥ አይኮይ ባዋ ያዮፍተ፤ ምንተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JS10_26","007_10_26","JOS","10","26","26","እያሱይ ሄ እቻሹ ካዎታ ዎꬍድ፥ እቻሹ ምꬃ ቦላ ካቅስ፤ ኤንታ አሀይ ኦማርስ ጋካናዉ ያን ፔእስ። ");
INSERT INTO gofe_vpl VALUES ("JS10_27","007_10_27","JOS","10","27","27","አው ዉልያ ዎደ እያሱይ፥ “አሀ ዎꬍስድ፥ ኤንቲ ካሰ ቆሰትዳ ጎንጎሉዋን ሆልተ። ያትድ፥ ሄ ጎንጎሉዋ ዶና ግታ ሹቻን ጎርድተ” ያግድ ኪትስ። ሄ ሹቻት ሀች ጋካናዉ ያን ደኦሶና። ");
INSERT INTO gofe_vpl VALUES ("JS10_28","007_10_28","JOS","10","28","28","ሄ ጋላስ እያሱይ ማቀዳ ካታማ ኦይክስ፤ ካታማ ካዋካ ዎꬍስ፤ ካታማን ደእያ አሳ ኡባ እስ አስካ አሾና ꬋይስስ። እያርኮ ካታማ ካዋ ቦላ ኦꬅዳይሳዳ፥ ማቀዳ ካታማ ካዋ ቦላ ኦꬅስ። ");
INSERT INTO gofe_vpl VALUES ("JS10_29","007_10_29","JOS","10","29","29","ያፐ ስሚድ፥ እያሱይነ እያ ኦላንቾት ኡባይ ማቀዳፐ ብድ ልብና ካታማ ኦልዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS10_30","007_10_30","JOS","10","30","30","ጎዳይ ሄ ካታማነ ካታማ ካዋ ኤንታ ኩሸን አꬅድ እምስ። እያሱይ ካታማን ደእያ አሳፐ እሱዋካ አሾና ማሻን ዎꬍስ። እያርኮ ካታማ ካዋ ቦላ ኦꬅዳይሳዳ ልብና ካታማ ካዋ ቦላ ኦꬅስ። ");
INSERT INTO gofe_vpl VALUES ("JS10_31","007_10_31","JOS","10","31","31","እያሱይነ እያ ኦላንቾት ልብና ካታማፐ ላክሶ ካታማ ብድ፥ ሄ ካታማ ኦልዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS10_32","007_10_32","JOS","10","32","32","ጎዳይ ላክሶ ካታማ እስራኤለ አሳ ኩሸን አꬅድ እምን፥ እያሱይ ሄ ካታማ ዩሹዋ ተቅድ ናምአንꬆ ጋላሳን ኦይክስ። ልብና ካታማን ኦꬅዳይሳዳ ላክሶ ካታማን ደእያ አሳ ኡባ ማሻን ዎꬍስ። ");
INSERT INTO gofe_vpl VALUES ("JS10_33","007_10_33","JOS","10","33","33","ሄ ዎደ፥ ገዘራ ካዎይ ሆራም፥ ላክሶ ካዋ ማዳናዉ ይስ፥ ሽን እያሱይ እያነ እያ ኦላንቾታ ꬋይስስ፤ ኤንታፈ እስ አስካ አትቤና። ");
INSERT INTO gofe_vpl VALUES ("JS10_34","007_10_34","JOS","10","34","34","ሄሳፈ ስሚድ፥ እያሱይነ እያ ኦላንቾት ኡባይ ላክሶ ካታማፐ ኤግሎና ካታማ ብድ፥ ሄ ካታማ ዩሹዋ ተቅድ ኦልዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS10_35","007_10_35","JOS","10","35","35","ሄ ጋላስ ኤግሎና ካታማ ኦይክድ፥ ላክሶ ካታማን ኦꬅዳይሳዳ ማሻን አሰ ኡባ ዎꬍዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS10_36","007_10_36","JOS","10","36","36","ያት ስሚድ፥ እያሱይነ እያ ኦላንቾት ኤግሎናፐ ከብሮና ብድ፥ ከብሮና ኦልዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS10_37","007_10_37","JOS","10","37","37","ሄ ካታማነ እያ ዩሹዋን ደእያ ጉꬃ ካታማታ ኦይክድ እያን ደእያ አሳነ ካዋ ዎꬍዶሶና። እያሱይ ኤግሎናን ኦꬅዳይሳዳ ሄ ካታማ ቦላካ ኦꬅስ። ");
INSERT INTO gofe_vpl VALUES ("JS10_38","007_10_38","JOS","10","38","38","ሄሳፈ ጉየ፥ እያሱይነ እያራ ደእያ እስራኤለ ኦላንቾት ጉየ ስሚድ ዳብራ ካታማ ኦልዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS10_39","007_10_39","JOS","10","39","39","ሄ ካታማነ እያ ዩሹዋን ደእያ ጉꬃ ጉታታ ኦይክድ፥ እያን ደእያ አሳነ ካዋ ዎꬍዶሶና። እያሱይ ከብሮናነ ልብና ካታማታ ቦላ ኦꬅዳይሳዳ ዳብራ ቦላ ኦꬅስ። ");
INSERT INTO gofe_vpl VALUES ("JS10_40","007_10_40","JOS","10","40","40","እያሱይ ሄ ቢታን ደእያ ካታማታ ኡባ ኦይክስ። ደረይ ዳርያ ቢታን፥ ነገበ ጋꬋን፥ ሎቡዋነ ኤንታ ካዎታ ኡባ ኦይክስ። ጎዳይ እስራኤለ ፆሳይ እያ ኪትዳይሳዳ፥ ቢታ ቦላ ደእያ አስ እሱዋካ አሾና ኡባ ዎꬍድ ꬋይስስ። ");
INSERT INTO gofe_vpl VALUES ("JS10_41","007_10_41","JOS","10","41","41","እያሱይ ቃደስ-ባርነፈ ብድ ጋዛ ጋካናዉ ቃስ ጎሸና ቢታፈ ብድ ጋባኦና ጋካናዉ ደእያ ኡባ ኦልድ ፆንስ። ");
INSERT INTO gofe_vpl VALUES ("JS10_42","007_10_42","JOS","10","42","42","ጎዳይ፥ እስራኤለ ፆሳይ፥ እስራኤለታስ ኦለትዳ ግሾ እያሱይ ሀ ካዎታነ ኤንታ ቢታ ኡባ ኦልድ ኦይክስ። ");
INSERT INTO gofe_vpl VALUES ("JS10_43","007_10_43","JOS","10","43","43","ሄሳፈ ጉየ፥ እያሱይነ እስራኤለ ኦላንቾት ባንታ ዱንካንዳ ጉታ ጋልጋላ ስምዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS11_1","007_11_1","JOS","11","1","1","ሀዞራ ካዎይ ያብን፥ እስራኤለታ ፆኑዋ ስእዳ ዎደ ማዶና ካዋ ዮባባስ፥ ሽምሮና ካዋስ፥ አዝፋ ካዋስ፥ ");
INSERT INTO gofe_vpl VALUES ("JS11_2","007_11_2","JOS","11","2","2","ፑደሀ ገዘን ደእያ ካዎታስ፥ ከነሬታ አባፈ ዱገሀ ባጋን ዮርዳኖሰ ዛንጋራን ደእያ ካዎታስ፥ ናፋት-ዶራፐ ዉሎሀ ባጋራ ጋꬋን ደእያ ካዎታስ ኪታ የድስ። ");
INSERT INTO gofe_vpl VALUES ("JS11_3","007_11_3","JOS","11","3","3","ቃስ ዶሎሀነ ዉሎሀ ባጋን ደእያ ካናነታስ፥ አሞረታስ፥ ህተታስ፥ ፓርዘታስ፥ ደረይ ዳርያ ቢታን ደእያ ያቡሰታስነ ምፅጳን አርሞና ዙማፐ ጋርሳን ደእያ ህወታስ ኪትስ። ");
INSERT INTO gofe_vpl VALUES ("JS11_4","007_11_4","JOS","11","4","4","ኤንቲ ኡባይ፥ ባንታ ኦላንቾታ፥ ፓራታነ ፓራ ጋረታ እስፈ ጋꬅድ ይዶሶና። ኤንታ ታይቦይ አባ ጋፃን ደእያ ሻፈ መላ። ");
INSERT INTO gofe_vpl VALUES ("JS11_5","007_11_5","JOS","11","5","5","ሄ ካዎት ኡባይ ባንታ ዎልቃ እስፈ ጋꬅድ፥ እስራኤለታ ኦላናዉ መሮመ ሃꬃ ማታን ዱንካንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS11_6","007_11_6","JOS","11","6","6","ጎዳይ እያሱኮ፥ “ነ ኤንታዉ ባቦፋ፤ ታኒ ዎንቶ ሀኖደ ኤንታ ኡባ ዎꬋዳ እስራኤለ አሳስ አꬃ እማና። ኔን ኤንታ ፓራታ ጋድያ ቃንፃና፤ ኤንታ ፓራ ጋረታካ ታማን ፁጋና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JS11_7","007_11_7","JOS","11","7","7","እያሱይነ እያ ኦላንቾት ኡባይ ኤንቲ ቆፖና ደእሽን መሮመ ሃꬃ ማታን ኤንታ ቦላ ከይድ ኦልዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS11_8","007_11_8","JOS","11","8","8","ጎዳይ ኤንታና እስራኤለታ ኩሸን አꬅድ እምስ። እስራኤለት ኤንታ ኦልድ፥ ግታ ስዶናነ ማስሮታ ጋካናዉ፥ ቃስ ዶሎሀ ባጋን ደእያ ምፅጳ ዛንጋራ ጋካናዉ ኤንታና የደꬅዶሶና። ኤንታፈ እስ አስካ አሾና ኡባ ዎꬍዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS11_9","007_11_9","JOS","11","9","9","እያሱይ፥ ጎዳይ ኪትዳይሳዳ ኡባ ቦላ ኦꬅስ፤ ኤንታ ፓራታ ጋድያ ቃንፅስ፤ ኤንታ ጋረታ ፁግስ። ");
INSERT INTO gofe_vpl VALUES ("JS11_10","007_11_10","JOS","11","10","10","ያትድ፥ እያሱይ ጉየ ስሚድ፥ ሀዞራ ኦል ኦይክድ፥ ካዉዋካ ማሻን ዎꬍስ። ሄ ዎደ ሀዞራ ካዎተꬃይ ሀራ ካዎተꬃ ኡባስ ሁጰ። ");
INSERT INTO gofe_vpl VALUES ("JS11_11","007_11_11","JOS","11","11","11","እስራኤለ አሳይ ሀዞራን ደእያ አሳ ኡባ ማሻን ዎꬍዳ ግሾ ሸምፖራ አትዳ አስ ባዋ። ሄ ካታማይ ታማን ፁገትስ። ");
INSERT INTO gofe_vpl VALUES ("JS11_12","007_11_12","JOS","11","12","12","ጎዳ አይለይ ሙሰይ ኪትዳይሳዳ፥ እያሱይ ሄ ካታማታነ ኤንታ ካዎታ ኡባ ድእስ። እስ አስካ አሾና አሳ ኡባ ማሻን ዎꬍስ። ");
INSERT INTO gofe_vpl VALUES ("JS11_13","007_11_13","JOS","11","13","13","ግዶሽን፥ እያሱይ ፁግዳ ሀዞራ ካታማፐ አትሽን፥ ዞዘ ቦላ ኬፀትዳ ካታማታ እስራኤለ አሳይ ፁግቦኮና። ");
INSERT INTO gofe_vpl VALUES ("JS11_14","007_11_14","JOS","11","14","14","እስራኤለ አሳይ ሄ ካታማታፐ ቦንቅዳ፥ ሚሽያነ መሄ ኡባ ባንታዉ ኤክዶሶና። እስ አስካ አሾና አሳ ኡባ ማሻን ዎꬍዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS11_15","007_11_15","JOS","11","15","15","ጎዳይ ባ አይልያ ሙሰ ኪትዳይሳዳ፥ ሙሰይ እያሱ ኪትስ፤ እያሱይካ ኪታ ፖልስ። ጎዳይ ሙሰ ኪትዳባፐ እስባካ እያሱይ አሽቤና፤ ኡባ ኦꬅስ። ");
INSERT INTO gofe_vpl VALUES ("JS11_16","007_11_16","JOS","11","16","16","እያሱይነ እያ ኦላንቾት ደረይ ዳርያ ቢታ፥ ነገበ መላ ቢታ፥ ጎሸና ቢታ ኡባ፥ ዉሎሀ ባጋን ደእያ ጋꬋነ ዮርዳኖሰ ዛንጋራ ኦልድ ኦይክስ። ");
INSERT INTO gofe_vpl VALUES ("JS11_17","007_11_17","JOS","11","17","17","እ ሳይረ ካንꬅስያ ሀላቃ ዙማፐ ብድ፥ አርሞና ዙማፐ ጋርሳ ባጋን ደእያ ልባኖሰ ዛንጋራነ ባኣል-ጋደ ጋካናዉ ደእያ ቢታታ ኦይክስ። ኤንታ ካዎታ ኡባ ሾጭስ፤ ድእድ ዎꬍስ። ");
INSERT INTO gofe_vpl VALUES ("JS11_18","007_11_18","JOS","11","18","18","እያሱይ ዳሮ ዎደ ሄ ካዎታ ኡባራ ኦለትስ። ");
INSERT INTO gofe_vpl VALUES ("JS11_19","007_11_19","JOS","11","19","19","ጋባኦናን ደእያ ህወታፐ አትሽን፥ ሀራ ካታም እስራኤለታራ ሳሮ ዳናዉ ጫቅዳይ ባዋ። እስራኤለት ሀራ ካታማታ ኡባ ኦላን ፆንድ ኦይክዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS11_20","007_11_20","JOS","11","20","20","ጎዳይ ሙሰ ኪትዳይሳዳ፥ እያሱይ ኤንታ ማሮት ባይና ኡባ ዎꬋና መላ ጎዳይ ኤንታ ዎዛና ሙምስድ እስራኤለታ ኦላና መላ ደንꬅስ። ");
INSERT INTO gofe_vpl VALUES ("JS11_21","007_11_21","JOS","11","21","21","ሄ ዎደ እያሱይ ብድ ደረይ ዳርያ ከብሮናን፥ ዳብራን፥ አናባን፥ ደረይ ዳርያ ይሁዳንነ እስራኤለን ደእያ አዱሳታ፥ አናቀ ኮቻታ ዎꬍድ ኦንግስ። እያሱይ ኤንታነ ኤንታ ካታማታ ኩመꬅ ꬋይስስ። ");
INSERT INTO gofe_vpl VALUES ("JS11_22","007_11_22","JOS","11","22","22","አናቀ ኮቻታፐ ኦንካ እስራኤለ ቢታን አትቤና፥ ሽን ጋዛን፥ ጋታንነ አሽዶዳን ጉꬃት አትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS11_23","007_11_23","JOS","11","23","23","ጎዳይ ሙሰ ኪትዳይሳዳ እያሱይ ቢታ ኡባ ኦይክድ፥ እስራኤለ አሳ ኮቻን ኮቻን ሻክድ ላትስስ። ሄሳፈ ጉየ ቢታይ ኦላፐ ሸምፕስ። ");
INSERT INTO gofe_vpl VALUES ("JS12_1","007_12_1","JOS","12","1","1","እስራኤለ አሳይ ዮርዳኖሰ ሻፋፐ ዶሎሀ ባጋራ ደእያ አርኖና ዛንጋራፐ ብድ አርሞና ዙማ ጋካናዉ፥ ቃስ ዶሎሀ ባጋራ ዮርዳኖሰ ዛንጋራ ጋካናዉ ደእያ ቢታ ኡባ ኦልድ ኦይክስ። ሄ ፆነትዳ ካዎት ሀይሳፈ ካልድ ፃፈትዳይሳታ፤ ");
INSERT INTO gofe_vpl VALUES ("JS12_2","007_12_2","JOS","12","2","2","ሀሰቦናን ኡትድ ሃርያ አሞረታ ካዋ ስሆና። እ ጋላዳ ቢታስ ባጋ ኤክድ፥ አርኖና ዛንጋራ ማታን ደእያ አሮራፐ ደንድድ፥ አሞነታ ዛዋ ያቦቃ ሻፋ ጋካናዉ ደኤይሳ ሃሬስ። ");
INSERT INTO gofe_vpl VALUES ("JS12_3","007_12_3","JOS","12","3","3","ቃስ ዶሎሀ ባጋራ ዮርዳኖሰ ዛንጋራን ከነሬታ አባፈ ብድ፥ ቤት-ያሽሞታ ባጋራ ማፅነ አባ ካንꬅድ፥ ፕስጋ ደርያፐ ጋርሳ ባጋራ ደእያ ቢታታ ሃሬስ። ");
INSERT INTO gofe_vpl VALUES ("JS12_4","007_12_4","JOS","12","4","4","ሄሳዳካ፥ ራፋይመታ ሼሻፐ ዉርሰꬅ ግድዳ፥ አስታሮተነ ኤድራአ ሃርያ፥ ባሳነ ካዋ ኦገ ፆንስ። ");
INSERT INTO gofe_vpl VALUES ("JS12_5","007_12_5","JOS","12","5","5","ኦገይ፥ ሃርያ ዛዋይ ፑደሀን አርሞና ዙማ፥ ዶሎሀን ሳላካ ካታማ ጋክድ፥ ዉሎሀን ጌሹረታነ ማካታ ዛዋ ጋካናዉ ደእያ ባሳነ ቢታ ኡባ ጋኬስ። ሀሰቦና ካዋ ስሆና ቢታ ጋላዳ ፑደሀ ባጋ ጉጅድ ሃሬስ። ");
INSERT INTO gofe_vpl VALUES ("JS12_6","007_12_6","JOS","12","6","6","ጎዳ አይለይ ሙሰይ ካለꬅን፥ እስራኤለ አሳይ ሀ ካዎታ ፆንዶሶና። ጎዳ አይለይ ሙሰይ ኤንታ ቢታ ሮቤላ ኮቻታስ፥ ጋዳ ኮቻታስነ ምናሰ ኮቻፈ ባጋስ ሻክድ ላትስስ። ");
INSERT INTO gofe_vpl VALUES ("JS12_7","007_12_7","JOS","12","7","7","እያሱይነ እስራኤለ አሳይ ዮርዳኖሰ ሻፋፐ ዉሎሀ ባጋን ደእያ ካዎታ ኡባ ፆንዶሶና። ሄ ቢታይ ልባኖሰ ዛንጋራን ደእያ ባኣል-ጋደፐ ብድ፥ ዱገሀ ባጋራ ሳይረ ማታን ደእያ ሀላቃ ደርያ ጋኬስ። እያሱይ ሄ ቢታ ሻክድ፥ እስራኤለ ኮቻታስ ላታ ቢታ ኦꬅድ እምስ። ");
INSERT INTO gofe_vpl VALUES ("JS12_8","007_12_8","JOS","12","8","8","ሄ እ እምዳ ቢታይ፥ ደረይ ዳርያ ቢታ፥ ዉሎሀ ባጋን ደእያ ጋꬋ፥ ዮርዳኖሰ ዛንጋራ፥ ይሁዳነ ነገበ መላ ቢታ። ሄ ቢታይ ካሰ ህተት፥ አሞረት፥ ካናነት፥ ፓርዘት፥ ህወትነ ያቡሰት ደእያ ቢታ። ");
INSERT INTO gofe_vpl VALUES ("JS12_9","007_12_9","JOS","12","9","9","እስራኤለ አሳይ ፆንዳ ካዎት ሀይሳፈ ካልድ ፃፈትዳይሳታ፤ እያርኮ ካዋ፥ ቤተለ ማታን ደእያ ጋየ ካዋ፥ ");
INSERT INTO gofe_vpl VALUES ("JS12_10","007_12_10","JOS","12","10","10","የሩሳላመ ካዋ፥ ከብሮና ካዋ፥ ");
INSERT INTO gofe_vpl VALUES ("JS12_11","007_12_11","JOS","12","11","11","ያርሙታ ካዋ፥ ላክሶ ካዋ፥ ");
INSERT INTO gofe_vpl VALUES ("JS12_12","007_12_12","JOS","12","12","12","ኤግሎና ካዋ፥ ገዘራ ካዋ፥ ");
INSERT INTO gofe_vpl VALUES ("JS12_13","007_12_13","JOS","12","13","13","ዳብራ ካዋ፥ ገደራ ካዋ፥ ");
INSERT INTO gofe_vpl VALUES ("JS12_14","007_12_14","JOS","12","14","14","ሆርማ ካዋ፥ አራዳ ካዋ፥ ");
INSERT INTO gofe_vpl VALUES ("JS12_15","007_12_15","JOS","12","15","15","ልብና ካዋ፥ አዱላማ ካዋ፥ ");
INSERT INTO gofe_vpl VALUES ("JS12_16","007_12_16","JOS","12","16","16","ማቀዳ ካዋ፥ ቤተለ ካዋ፥ ");
INSERT INTO gofe_vpl VALUES ("JS12_17","007_12_17","JOS","12","17","17","ታፑሀ ካዋ፥ ሄፌራ ካዋ፥ ");
INSERT INTO gofe_vpl VALUES ("JS12_18","007_12_18","JOS","12","18","18","አፌቃ ካዋ፥ ሳሮና ካዋ፥ ");
INSERT INTO gofe_vpl VALUES ("JS12_19","007_12_19","JOS","12","19","19","ማዶና ካዋ፥ ሀዞራ ካዋ፥ ");
INSERT INTO gofe_vpl VALUES ("JS12_20","007_12_20","JOS","12","20","20","ሽምሮን-ማሮና ካዋ፥ አዝፋ ካዋ፥ ");
INSERT INTO gofe_vpl VALUES ("JS12_21","007_12_21","JOS","12","21","21","ታናካ ካዋ፥ ማግዶ ካዋ፥ ");
INSERT INTO gofe_vpl VALUES ("JS12_22","007_12_22","JOS","12","22","22","ቃደሳ ካዋ፥ ቃርመሎሳን ደእያ ዮቅናመ ካዋ፥ ");
INSERT INTO gofe_vpl VALUES ("JS12_23","007_12_23","JOS","12","23","23","ገዘን ደእያ ዶራ ካዋ፥ ጋልጋላን ደእያ ጎይማ ካዋነ ");
INSERT INTO gofe_vpl VALUES ("JS12_24","007_12_24","JOS","12","24","24","ትርሳ ካዋ። ኤንቲ ኩመꬅ ሀስታማነ እስ ካዎታ። ");
INSERT INTO gofe_vpl VALUES ("JS13_1","007_13_1","JOS","13","1","1","እያሱይ ዳሮ ጭምዳ ዎደ ጎዳይ እያኮ፥ “ኔን ጭማዳሳ፤ ነ ላይꬃይካ ሱገትስ፥ ግዶሽን ኦይከቶና አትዳ ዳሮ ቢታት ደኦሶና። ");
INSERT INTO gofe_vpl VALUES ("JS13_2","007_13_2","JOS","13","2","2","ኦይከትቦና ቢታት ሀይሳታ፤ ፍልስፄመታነ ጌሹረታ ቢታ ኡባ። ");
INSERT INTO gofe_vpl VALUES ("JS13_3","007_13_3","JOS","13","3","3","ግብፀፈ ዶሎሀ ባጋን ደእያ ሽሆራ ሻፋፐ ብድ፥ ፑደሀ ባጋን ደእያ ኤክሮና ቢታ ጋካናዉ ደእያ ቢታ ኡባ። ሄ ቢታት ካናነ ቢታ ጌተቶሶና። ኤንትካ እቻሹ ፍልስፄመ ካዎት አይስያ ጋዛ፥ አሽዶዳ፥ አስቀሎና፥ ጋተነ ኤክሮና ጌተትያ ካታማታ። አዌታ ቢታይካ ቡሮ ኦይከትቤና። ");
INSERT INTO gofe_vpl VALUES ("JS13_4","007_13_4","JOS","13","4","4","ዱገሀ ባጋን ደእያ ካናነታ ቢታነ፥ ስዶናታ ቢታ ግድዳ ማራፐ ብድ አሞረታ ዛዋ አፌቃ ጋካናዉ ደእያ ቢታይ ኦይከትቤና። ");
INSERT INTO gofe_vpl VALUES ("JS13_5","007_13_5","JOS","13","5","5","ገባላታ ቢታይነ ባኣል-ጋደፐ ዶሎሀ ባጋን ደእያ አርሞና ዙማፐ ብድ፥ ሀማታ ፕኖ ጋካናዉ ቡሮ ኦይከትቤና። ");
INSERT INTO gofe_vpl VALUES ("JS13_6","007_13_6","JOS","13","6","6","ልባኖሰፐ ብድ ማሰሮና ጋካናዉ ገዘ ቢታን ደእያ ስዶናታ ኡባ ታኒ እስራኤለታ ስንꬃፈ ጎዳ ከሳና። ታኒ ነና ኪትዳይሳዳ ሄ ቢታ እስራኤለ አሳስ ላታ ኦꬃዳ ሻካ። ");
INSERT INTO gofe_vpl VALUES ("JS13_7","007_13_7","JOS","13","7","7","ኔን ሄ ቢታ ኡዱፉን ኮቻታስነ ምናሰ ኮቻፈ ባጋስ ሻካ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JS13_8","007_13_8","JOS","13","8","8","ሮቤላ ኮቻይ፥ ጋዳ ኮቻይነ ምናሰ ኮቻፈ ባጋይ ጎዳ አይለይ ሙሰይ ዮርዳኖሰፐ ሄፍንꬃን፥ ዶሎሀ ባጋን ደእያ ቢታ ካሰ ላታ ኦꬅድ ኤንታዉ እምስ። ");
INSERT INTO gofe_vpl VALUES ("JS13_9","007_13_9","JOS","13","9","9","ኤንታ ቢታይ አርኖና ዛንጋራ ማታን ደእያ አሮኤራፐ ብድ፥ ሄ ዛንጋራን ደእያ ካታማፐ ብድ፥ መደባ ገዝያ ካንꬅድ ድቦና ጋካናሳ። ");
INSERT INTO gofe_vpl VALUES ("JS13_10","007_13_10","JOS","13","10","10","ቃስ ሀሰቦናን ኡትድ አሞነታ ዛዋ ጋካናዉ ሃርያ አሞረታ ካዋ ስሆና ካታማታ ኡባ ጋኬስ። ");
INSERT INTO gofe_vpl VALUES ("JS13_11","007_13_11","JOS","13","11","11","ሄሳዳካ፥ ጋላዳታ፥ ጌሹረታነ ማእካታ ቢታ ኡባ፥ አርሞና ዙማ ኡባነ ሳላካ ጋካናዉ ደእያ ባሳነ ቢታ ኡባ ኦይኬስ። ");
INSERT INTO gofe_vpl VALUES ("JS13_12","007_13_12","JOS","13","12","12","አስታሮተንነ ኤድራአን ኡትድ፥ ሃርዳ ባሳነ ካዋ ኦገ ቢታ ኡባ ኦይኬስ፤ ሄ ቢታይ ካሰ ራፋይመታፐ አትዳ ቢታ። ሙሰይ ኤንታ ፆንድ ቢታፈ ጎድድ ከስስ። ");
INSERT INTO gofe_vpl VALUES ("JS13_13","007_13_13","JOS","13","13","13","ሽን እስራኤለ አሳይ ጌሹረታነ ማእካታ ጎድድ ከስቦኮና። ኤንቲ ሀች ጋካናዉ እስራኤለ አሳ ግዶን ደኦሶና። ");
INSERT INTO gofe_vpl VALUES ("JS13_14","007_13_14","JOS","13","14","14","ሙሰይ ሌወ ኮቻስ ላታ ቢታ እምቤና። ጎዳይ፥ እስራኤለ ፆሳይ፥ ኤንታዉ ኪትዳይሳዳ ታማን ፁሳ ያርሾ ኤንታዉ ላታ ኦꬅድ እምስ። ");
INSERT INTO gofe_vpl VALUES ("JS13_15","007_13_15","JOS","13","15","15","ሙሰይ ሮቤላ ኮቻስ ኤንታ ኮቻን ኮቻን ላታ እምስ። ");
INSERT INTO gofe_vpl VALUES ("JS13_16","007_13_16","JOS","13","16","16","ኤንታ ቢታይ አርኖና ዛንጋራ ማታን ደእያ አሮኤራፐ ብድ፥ ሄ ዛንጋራን ደእያ ካታማ ካንꬅድ ገዘ መደባ ጋኬስ። ");
INSERT INTO gofe_vpl VALUES ("JS13_17","007_13_17","JOS","13","17","17","ሀሰቦና፥ ገዘ ካታማታ፥ ድቦና፥ ባሞት-ባኣላ፥ ቤት-ባል-መኦና፥ ");
INSERT INTO gofe_vpl VALUES ("JS13_18","007_13_18","JOS","13","18","18","ያሃፃ፥ ቀደሞታ፥ መፋታ፥ ");
INSERT INTO gofe_vpl VALUES ("JS13_19","007_13_19","JOS","13","19","19","ቅራታይማ፥ ሰባማ፥ ደረይ ዳርያ ዛንጋራን ደእያ ፀረት-ሻሃረ፥ ");
INSERT INTO gofe_vpl VALUES ("JS13_20","007_13_20","JOS","13","20","20","ቤት-ፓኦራ፥ ፕስጋ ዙማፐ ጋርሳን ደእያ ቢታነ ቤት-ያሽሞታ ጌተትያ ቢታታ ኡባ ጋኬስ። ");
INSERT INTO gofe_vpl VALUES ("JS13_21","007_13_21","JOS","13","21","21","ቃስ ገዘን ደእያ ካታማታነ ሀሰቦናን ኡትድ ሃርዳ አሞረታ ካዋ ስሆና ቢታ ኡባ ጋኬስ። ሙሰይ ካዋ ስሆናነ ምድያመታ ሀላቃታ ኤዋ፥ ረቄማ፥ ፁራ፥ ሁራነ ሬባ ኦልድ ፆንስ። ሀይሳቲ ካዋ ስሆናፐ ጋርሳን ሄ ቢታ ሃረይሳታ። ");
INSERT INTO gofe_vpl VALUES ("JS13_22","007_13_22","JOS","13","22","22","እስራኤለ አሳይ ማሩዋ፥ ብኦራ ናኣ፥ ባላማ ዎꬍዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS13_23","007_13_23","JOS","13","23","23","ሮቤላ ኮቻስ ዉሎሀ ባጋ ዛዋይ ዮርዳኖሰ ሻፋ። ሮቤላ ኮቻስ ኮቻን ኮቻን ላታ ግድድ እመትዳ ካታማትነ ጉታት ሀይሳታ። ");
INSERT INTO gofe_vpl VALUES ("JS13_24","007_13_24","JOS","13","24","24","ሙሰይ ጋዳ ኮቻስ ኤንታ ኮቻን ኮቻን ላታ ቢታ ሻክድ እምስ። ");
INSERT INTO gofe_vpl VALUES ("JS13_25","007_13_25","JOS","13","25","25","ኤንታ ቢታይ ያእዜራ፥ ጋላዳን ደእያ ካታማታ ኡባነ አሞነታ ቢታፈ ባጋ ኤክድ፥ ራባ ዶሎሀ ባጋን ደእያ አሮኤራ ጋኬስ። ");
INSERT INTO gofe_vpl VALUES ("JS13_26","007_13_26","JOS","13","26","26","ሄሳዳካ፥ ሀሰቦናፐ ደንድድ፥ ራሞት-ምፅጳነ በፆንማ ጋኬስ። ቃስ ማህናይማፐ ብድ ዳቤራ ዛዋ ጋኬስ። ");
INSERT INTO gofe_vpl VALUES ("JS13_27","007_13_27","JOS","13","27","27","ቃስ ዮርዳኖሰ ዛንጋራን፥ ሀሰቦና ካዋ ስሆና ካዎተꬃፈ አትዳ፥ ቤት-ሀራመ፥ ቤት-ንምራ፥ ሱኮታነ ፃፎና ጌተትያ ካታማታ ኤኬስ። ኤንታ ዛዋይ ዉሎሀ ባጋን ዮርዳኖሰ ሻፋ፥ ቃስ ፑደሀ ባጋን ከነሬታ አባ ጋኬስ። ");
INSERT INTO gofe_vpl VALUES ("JS13_28","007_13_28","JOS","13","28","28","ጋዳ ኮቻስ ኮቻን ኮቻን ላታ ቢታ ግድድ እመትዳ ካታማትነ ጉታት ሀይሳታ። ");
INSERT INTO gofe_vpl VALUES ("JS13_29","007_13_29","JOS","13","29","29","ሙሰይ ምናሰ ኮቻፈ ባጋስ ኤንታ ኮቻን ኮቻን ላታ ቢታ እምስ። ");
INSERT INTO gofe_vpl VALUES ("JS13_30","007_13_30","JOS","13","30","30","ኤንታ ቢታይ ማህናይማነ ባሳነ ቢታ ኡባ ጋክ ኦይኬስ። ባሳነ ካዋ ኦገ ካዎተꬃ ኡባነ ባሳነን ደእያ ኡሱፑን ታሙ ያእራ ካታማታ ኦይኬስ። ");
INSERT INTO gofe_vpl VALUES ("JS13_31","007_13_31","JOS","13","31","31","ቃስ ጋላዳፐ ባጋነ ባሳነን ኦገ ካዎተꬃስ ዋና ካታማ ግድዳ አስታሮተነ ኤድራአ ጌተትያ ካታማታ ጋኬስ። ሄ ኡባይ ምናሰ ናአ ማክራ ኮቻስ ኤንታ ኮቻን ኮቻን ጋክዳይሳ። ");
INSERT INTO gofe_vpl VALUES ("JS13_32","007_13_32","JOS","13","32","32","ሙሰይ ዮርዳኖሰፐ ሄፍንꬃን፥ እያርኮፈ ዶሎሀ ባጋን ደእያ ሞአበ ደንባን ደእሸ ሻክድ እምዳ ቢታይ ሀይሳ። ");
INSERT INTO gofe_vpl VALUES ("JS13_33","007_13_33","JOS","13","33","33","ሽን ሙሰይ ሌወ ኮቻስ ላታ ቢታ እምቤና። ጎዳይ፥ እስራኤለ ፆሳይ ኤንታ ላታ። ");
INSERT INTO gofe_vpl VALUES ("JS14_1","007_14_1","JOS","14","1","1","ካህነይ አላዛር፥ ናወ ናአይ እያሱይነ እስራኤለ ሶ አሳ ሀላቃት፥ ካናነ ቢታ ኤንታ ኮቻን ኮቻን ሻክን፥ እስራኤለ አሳ ጋክዳ ቢታይ ሀይሳፈ ካልድ ደኤይሳ። ");
INSERT INTO gofe_vpl VALUES ("JS14_2","007_14_2","JOS","14","2","2","ጎዳይ ሙሰ ኪትዳይሳዳ ላታ ቢታይ ኡዱፉናነ ባጋ ኮቻስ ሳማን ሻከትስ። ");
INSERT INTO gofe_vpl VALUES ("JS14_3","007_14_3","JOS","14","3","3","ሙሰይ ካሰ ናምአነ ባጋ ኮቻስ ዮርዳኖሰፐ ዶሎሀ ባጋን ደእያ ቢታ እምስ፥ ሽን ሌወ ኮቻስ ኤንታ ግዶን ላታ ቢታ እምቤና። ");
INSERT INTO gofe_vpl VALUES ("JS14_4","007_14_4","JOS","14","4","4","ዮሰፋ ናይት ምናሰይነ ኤፍሬመይ ናምኡ ኮቸ ግድዶሶና። ሌወ ኮቻስ ዱሳ ካታማታነ መሄ ሄምያ ቢታ እምስፐ አትሽን፥ ላታ ቢታ እምቤና። ");
INSERT INTO gofe_vpl VALUES ("JS14_5","007_14_5","JOS","14","5","5","ጎዳይ ሙሰ ኪትዳይሳዳ እስራኤለ አሳይ ቢታ ሻከትድ ኤክዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS14_6","007_14_6","JOS","14","6","6","እስ ጋላስ ይሁዳ አሳይ እያሱኮ ጋልጋላ ይዶሶና። ኤንታፈ እሶይ፥ ቀነዛ ኮቻይ፥ ዮፎና ናአይ ካለብ እያሱኮ፥ “ኑኒ ቃደስ-ባርነን ደእያ ዎደ ጎዳይ ናብያ ሙሰ ባጋራ ነባነ ታባ ኦድዳይሳ ኤራሳ። ");
INSERT INTO gofe_vpl VALUES ("JS14_7","007_14_7","JOS","14","7","7","ጎዳ አይለይ ሙሰይ ሀ ቢታ ዎቻና መላ ቃደስ-ባርነፈ ታና ኪትያ ዎደ ታዉ ላይꬅ ኦይታማ። ሄ ዎደ ታኒ አማንꬅያ ኦዳ ሙሰስ ኤሀስ። ");
INSERT INTO gofe_vpl VALUES ("JS14_8","007_14_8","JOS","14","8","8","ታራ ብዳ አሳት አሳ ዎዛና ያሻን ትልእስዶሶና፥ ሽን ታኒ ጎዳ፥ ፆሳ ፖሎ ካላስ። ");
INSERT INTO gofe_vpl VALUES ("JS14_9","007_14_9","JOS","14","9","9","ሄ ጋላስ ሙሰይ፥ ‘ኔን፥ ጎዳ፥ ፆሳ ፖሎ ካልዳ ግሾ፥ ነ ቶሆይ የꬍዳ ቢታይ ነዉነ ነ ኮቻስ መርና ላታ ቢታ ግዳና’ ግድ ታዉ ጫቅስ። ");
INSERT INTO gofe_vpl VALUES ("JS14_10","007_14_10","JOS","14","10","10","እያሱ፥ አነ ቆፓ፤ ጎዳይ ሄሳ ሙሰስ ኦድ ስምን ሀች ኦይታማነ እቻሹ ላይꬅ ግድስ። እስራኤለ አሳይ መላ ቢታን ስመረትያ ዎደ ኡባን ሀች ጋꬃናዉ ጎዳይ ታና ፓፃ ዎꬅስ። ሀእ ታዉ ላይꬅ ሆስፑን ታማነ እቻሻ ግድስ። ");
INSERT INTO gofe_vpl VALUES ("JS14_11","007_14_11","JOS","14","11","11","ታዉ ሄ ዎደ ደእያ ምኖተꬃይ ሀችካ ደኤስ። ኦለታናዉ፥ ከያናዉነ ገላናዉ ታዉ ሀእካ ዎልቅነ ፃላተꬅ ደኤስ። ");
INSERT INTO gofe_vpl VALUES ("JS14_12","007_14_12","JOS","14","12","12","ሄ ዎደ ጎዳይ ታዉ እማና ግድ ጫቅዳ ሄ ደረይ ዳርያ ቢታ ታዉ እማ። ሄ ቢታን አናቀት ደኤይሳነ ኤንታ ካታማት ግታነ ግምበትዳ ካታማ ግደይሳ ሄ ዎደ ነ ስአዳሳ። ግድኮካ ጎዳይ ግዳይሳዳ እ ታራ ግድኮ፥ ኤንታ ሄ ቢታፈ ታኒ ጎዳና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JS14_13","007_14_13","JOS","14","13","13","እያሱይ ዮፎና ናአ ካለባ አንጅድ፥ ከብሮና እያዉ ላታ ኦꬅ እምስ። ");
INSERT INTO gofe_vpl VALUES ("JS14_14","007_14_14","JOS","14","14","14","እ ጎዳ፥ እስራኤለ ፆሳ ፖሎ ካልዳ ግሾ፥ ከብሮና ሀች ጋካናዉ ቀነዛ ኮቻ ዮፎና ናኣ ካለባ ኮቻስ ላታ ቢታ ግድስ። ");
INSERT INTO gofe_vpl VALUES ("JS14_15","007_14_15","JOS","14","15","15","ካሰ ከብሮና ሱንꬃይ ቅርያት-አርባ ጌተቴስ። አርብ፥ አናቀታ ግዶን ኤረትዳ ግታ አሰ። ሄሳፈ ጉየ፥ ቢታይ ኦላፐ ሸምፕስ። ");
INSERT INTO gofe_vpl VALUES ("JS15_1","007_15_1","JOS","15","1","1","ይሁዳ ኮቻስ ኤንታ ኮቻን ኮቻን ሻከትዳ ቢታይ ኤዶመን ዛዋትድ፥ ዱገሀ ባጋን ደእያ ፂነ መላ ቢታ ዉርሰꬃ ጋኬስ። ");
INSERT INTO gofe_vpl VALUES ("JS15_2","007_15_2","JOS","15","2","2","ዱገሀ ባጋን ኤንታ ዛዋይ ማፅነ አባፈ ዱገሀ ባጋን ዉርሰꬃ ጋፃ ጋኬስ። ");
INSERT INTO gofe_vpl VALUES ("JS15_3","007_15_3","JOS","15","3","3","አክራብማ ፕኑዋ ካንꬅድ፥ ፂነፐ ብድ፥ ቃደስ-ባርነስ ዱገሀ ባጋ ጋኬስ። ቃስ ሄፅሮና ካንꬅድ፥ አዳረ ከይድ፥ ቃርቃኮ ስሜስ። ");
INSERT INTO gofe_vpl VALUES ("JS15_4","007_15_4","JOS","15","4","4","ሄሳፈ ቃስ አፅሞና ካንꬅድ፥ ግብፀ ሻፋ ጋክድ፥ መደትራነ አባን ዛዋቴስ። ዱገሀ ባጋን ደእያ ይሁዳ ዛዋይ ሄሳ። ");
INSERT INTO gofe_vpl VALUES ("JS15_5","007_15_5","JOS","15","5","5","ዶሎሀ ባጋ ዛዋይ ማፅነ አባ ብድ፥ ዮርዳኖሰ ሻፋ ዉርሰꬃ ጋኬስ። ፑደሀ ባጋ ዛዋይ ቃስ ዮርዳኖሰ ሻፋይ ገልያሱዋፕ ብድ፥ ");
INSERT INTO gofe_vpl VALUES ("JS15_6","007_15_6","JOS","15","6","6","ቤት-ሆግላ ከዬስ። ያፐ ቤት-አራባ ባጋራ ካንꬅድ፥ ሮቤላ ናኣ ቦሃና ቆፍሶ ሹቻን ዛዋቴስ። ");
INSERT INTO gofe_vpl VALUES ("JS15_7","007_15_7","JOS","15","7","7","ያፐ ዛዋይ አኮራ ዛንጋራፐ ዳብራ ከይድ፥ ዛንጋራፐ ዱገሀ ባጋን ደእያ አዱምማ ፕኑዋ ስንꬃ ባጋን አግድ ፑደሀ ባጋራ ጋልጋላ ስሜስ። ሄሳፈ ቃስ ኤንሸመሸ ፑልቱዋ ካንꬅድ፥ ኤንሮጌላን ዛዋቴስ። ");
INSERT INTO gofe_vpl VALUES ("JS15_8","007_15_8","JOS","15","8","8","ሄሳፈ ህኖማ ዛንጋራ ካንꬅድ፥ ያቡሰታ ካታማ ግድዳ የሩሳላመ ዱገሀ ባጋ ጋኬስ። ካልድ ዛዋይ ህኖመ ዛንጋራፐ ዉሎሀ ባጋን ደእያ ዙማ ሁጵያ ከይድ፥ ፑደሀ ባጋን ራፋይመ ዛንጋራ ጋኬስ። ");
INSERT INTO gofe_vpl VALUES ("JS15_9","007_15_9","JOS","15","9","9","ሄ ዙማ ሁጵያፐ ብድ፥ ናፍቶሀ ፑልቱዋ ካንꬅድ፥ ኤፍሮና ዙማ ቦላ ደእያ ካታማታኮ ከዬስ። ሄሳፈ ቃስ ባኣላ ዎይኮ ቅርያት-ይኣርማ ስሜስ። ");
INSERT INTO gofe_vpl VALUES ("JS15_10","007_15_10","JOS","15","10","10","ባላ ፑደሀ ባጋራ ዛዋይድ፥ ሳይረ ዙማኮ ዉሎሀ ባጋ ምርቀትድ፥ ይኣርመ ዎይኮ ክሳሎነ ደርያ ጋክድ፥ እያፐ ዱገ ቤት-ሳሜሳ ዎꬍድ፥ ትምና ፕኔስ። ");
INSERT INTO gofe_vpl VALUES ("JS15_11","007_15_11","JOS","15","11","11","ሄ ዛዋይ ኤቅሮና ፑደሀ ባጋራ ካንꬅድ፥ ሽክሮና ምርቀትድ፥ ባላ ዙማራ ብድ፥ ያብንኤላን ዛዋቴስ። ሄ ዛዋ ዉርሰꬃይ መደትራነ አባ ግድድ፥ ");
INSERT INTO gofe_vpl VALUES ("JS15_12","007_15_12","JOS","15","12","12","ዉሎሀ ባጋ ዛዋይ መደትራነ አባስ ጋፃ ግዴስ። ይሁዳ ኮቻይ ደእዳ ቢታ ዛዋይ ሀይሳ። ");
INSERT INTO gofe_vpl VALUES ("JS15_13","007_15_13","JOS","15","13","13","ጎዳይ ኪትዳይሳዳ፥ እያሱይ፥ ዮፎና ናኣ ካለባ ጋክያ ላታ ይሁዳ ቢታፈ ቅርያት-አርባ ጌተትያ ከብሮና እምስ። አርብ አናቀ አዋ። ");
INSERT INTO gofe_vpl VALUES ("JS15_14","007_15_14","JOS","15","14","14","ካለብ አናቀ ኮቻታ፥ ሰሳያ፥ አክማናነ ታልማያ ጌተትያ ሄꬓታ ከብሮናፐ ከስስ። ");
INSERT INTO gofe_vpl VALUES ("JS15_15","007_15_15","JOS","15","15","15","ሄሳፈ ደንድድ፥ ዳብራን ደእያ አሳ ኦላናዉ ብስ። ዳብራ ካታማይ ካሰ ቅርያት-ሰፈራ ጌተቴስ። ");
INSERT INTO gofe_vpl VALUES ("JS15_16","007_15_16","JOS","15","16","16","ካለብ፥ “ቅርያት-ሰፈራ ኦልድ፥ ኦይክያ አድያስ ታኒ፥ ታ ናእዉ አክሶ እማና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JS15_17","007_15_17","JOS","15","17","17","ያትን፥ ካለባ እሻ ቃናዛ ናአይ፥ ጎቶንያል ሄ ካታማ ኦልድ ኦይክን፥ ካለብ ባ ናእዉ አክሶ እያዉ እምስ። ");
INSERT INTO gofe_vpl VALUES ("JS15_18","007_15_18","JOS","15","18","18","አክሳ ጎቶንያላ ገልያ ዎደ እ አዋይ እዉ ጋደ እማናዳ ዎሳና መላ ጎቶንያል እዮ ዞርስ። እያ ባቁሎ ቦላፈ ዎꬍን፥ ካለብ እዮ፥ “አይ ኮያይ?” ያግድ ኦይችስ። ");
INSERT INTO gofe_vpl VALUES ("JS15_19","007_15_19","JOS","15","19","19","እያ ዛራዳ፥ “ነ ካሰ ታዉ ዎይትዳ ቢታይ መላ ቢታ ግድያ ግሾ፥ ሃꬃ ፑልቶይ ደእያ ቢታ ታዉ ጉጃዳ እማርክ” ያጋሱ። ያትን፥ ካለብ ቆሞንነ ጋርሳን ደእያ ፑልቶ ሃꬃ እዉ እምስ። ");
INSERT INTO gofe_vpl VALUES ("JS15_20","007_15_20","JOS","15","20","20","ይሁዳ ኮቻት ባንታ ኮቻን ኮቻን ኤክዳ ላታይ ሀይሳፈ ካልድ ፃፈትዳይሳ። ");
INSERT INTO gofe_vpl VALUES ("JS15_21","007_15_21","JOS","15","21","21","ዱገሀ ባጋን ኤዶመ ጋፃን ደእያ ይሁዳ ካታማት፥ ቃብዱኤላ፥ ኤደራ፥ ያጉራ፥ ");
INSERT INTO gofe_vpl VALUES ("JS15_22","007_15_22","JOS","15","22","22","ቂና፥ ድሞና፥ አዳዳ፥ ");
INSERT INTO gofe_vpl VALUES ("JS15_23","007_15_23","JOS","15","23","23","ቃደሳ፥ ሀፆራ፥ ይትናና፥ ");
INSERT INTO gofe_vpl VALUES ("JS15_24","007_15_24","JOS","15","24","24","ዚፋ፥ ፀለማ፥ ባሎታ፥ ");
INSERT INTO gofe_vpl VALUES ("JS15_25","007_15_25","JOS","15","25","25","ሀፆር-ሀዳታ፥ ቅርዮት-ሄፅሮና ዎይኮ ሀፆራ፥ ");
INSERT INTO gofe_vpl VALUES ("JS15_26","007_15_26","JOS","15","26","26","አማማ፥ ሻማአ፥ ሞሎዳ፥ ");
INSERT INTO gofe_vpl VALUES ("JS15_27","007_15_27","JOS","15","27","27","ሀፃር-ጋዳ፥ ሄሽሞና፥ ቤት-ፓለፃ፥ ");
INSERT INTO gofe_vpl VALUES ("JS15_28","007_15_28","JOS","15","28","28","ሀፃር-ሹኣላ፥ በርሳበህ፥ ብዝዮታ፥ ");
INSERT INTO gofe_vpl VALUES ("JS15_29","007_15_29","JOS","15","29","29","ባኣላ፥ እዩማ፥ ኤፀማ፥ ");
INSERT INTO gofe_vpl VALUES ("JS15_30","007_15_30","JOS","15","30","30","ኤልቶላዳ፥ ከስላ፥ ሆርማ፥ ");
INSERT INTO gofe_vpl VALUES ("JS15_31","007_15_31","JOS","15","31","31","ፅቅላጋ፥ ማድማና፥ ሳንሳና፥ ");
INSERT INTO gofe_vpl VALUES ("JS15_32","007_15_32","JOS","15","32","32","ለባዎታ፥ ሽልሃማ፥ አይናነ እርሞና። ሀ ካታማት ባንታ ጉታታራ እስፈ ላታማነ ኡዱፉና። ");
INSERT INTO gofe_vpl VALUES ("JS15_33","007_15_33","JOS","15","33","33","ዉሎሀ ባጋን ዙማ ፃጶን ደእያ ካታማት፥ ኤሽታኦላ፥ ፆርአ፥ አሽና፥ ");
INSERT INTO gofe_vpl VALUES ("JS15_34","007_15_34","JOS","15","34","34","ዛኖሀ፥ ኤንጋንማ፥ ታፑሀ፥ ኤናማ፥ ");
INSERT INTO gofe_vpl VALUES ("JS15_35","007_15_35","JOS","15","35","35","ያርሙታ፥ አዱላማ፥ ሶኮ፥ አዜቃ፥ ");
INSERT INTO gofe_vpl VALUES ("JS15_36","007_15_36","JOS","15","36","36","ሻእራይማ፥ አድታይማ፥ ገደራነ ገደሮታይማ። ሀ ካታማት ባንታ ጉታታራ እስፈ ታማነ ኦይዳ። ");
INSERT INTO gofe_vpl VALUES ("JS15_37","007_15_37","JOS","15","37","37","ቃስ ሀራ ካታማት፥ ፅናና፥ ሀዳሻ፥ ምግዳል-ጋዳ፥ ");
INSERT INTO gofe_vpl VALUES ("JS15_38","007_15_38","JOS","15","38","38","ድልአና፥ ምፅጳ፥ ዮቅትኤላ፥ ");
INSERT INTO gofe_vpl VALUES ("JS15_39","007_15_39","JOS","15","39","39","ላክሶ፥ ቦፅቃታ፥ ኤግሎና፥ ");
INSERT INTO gofe_vpl VALUES ("JS15_40","007_15_40","JOS","15","40","40","ካቦና፥ ላህማሳ፥ ክትሊሻ፥ ");
INSERT INTO gofe_vpl VALUES ("JS15_41","007_15_41","JOS","15","41","41","ገደሮታ፥ ቤት-ዳጎና፥ ናእማናነ ማቀዳ። ሀ ካታማት ባንታ ጉታታራ እስፈ ታማነ ኡሱፑና። ");
INSERT INTO gofe_vpl VALUES ("JS15_42","007_15_42","JOS","15","42","42","ቃስ ልብና፥ ኤተራ፥ አሸና፥ ");
INSERT INTO gofe_vpl VALUES ("JS15_43","007_15_43","JOS","15","43","43","ይፍታሄ፥ አሽና፥ ነፅባ፥ ");
INSERT INTO gofe_vpl VALUES ("JS15_44","007_15_44","JOS","15","44","44","ቃእላ፥ አክዚባነ ማሬሳ። ሀ ካታማት ባንታ ጉታታራ እስፈ ኡዱፉና። ");
INSERT INTO gofe_vpl VALUES ("JS15_45","007_15_45","JOS","15","45","45","ሄሳዳካ፥ ኤቅሮና ካታማይ ባ ጉታራ ያን ደኤስ። ");
INSERT INTO gofe_vpl VALUES ("JS15_46","007_15_46","JOS","15","46","46","ኤቅሮናፐ ዉሎሀ ባጋን አሽዶዳ ካታማይነ እያ ጉታት ደኦሶና። ");
INSERT INTO gofe_vpl VALUES ("JS15_47","007_15_47","JOS","15","47","47","ቃስ አሽዶዳነ ጋዛ ካታማት ባንታ ጉታታራ ብድ፥ ግብፀ ሻፋ ዛዋነ መደትራነ አባ ላንቅያ ጋካናዉ ደኦሶና። ");
INSERT INTO gofe_vpl VALUES ("JS15_48","007_15_48","JOS","15","48","48","ደረይ ዳርያ ካታማት፥ ሳምራ፥ ያትራ፥ ሶኮ፥ ");
INSERT INTO gofe_vpl VALUES ("JS15_49","007_15_49","JOS","15","49","49","ዳነ፥ ቅርያት-ሰፈራ ዎይኮ ዳብራ፥ ");
INSERT INTO gofe_vpl VALUES ("JS15_50","007_15_50","JOS","15","50","50","አናባ፥ ኤሽታሞአ፥ አንማ፥ ");
INSERT INTO gofe_vpl VALUES ("JS15_51","007_15_51","JOS","15","51","51","ጎሸና፥ ሆሎናነ ግሎ። ሀ ካታማት ባንታ ጉታታራ እስፈ ታማነ እስኖ። ");
INSERT INTO gofe_vpl VALUES ("JS15_52","007_15_52","JOS","15","52","52","ቃስ አራባ፥ ዱማ፥ ኤሽአና፥ ");
INSERT INTO gofe_vpl VALUES ("JS15_53","007_15_53","JOS","15","53","53","ያንማ፥ ቤት-ታፑሀ፥ አፌቃ፥ ");
INSERT INTO gofe_vpl VALUES ("JS15_54","007_15_54","JOS","15","54","54","ሁምፃ፥ ከብሮና ዎይኮ ቅርያት-አርባነ ፅኦራ። ሀ ካታማት ባንታ ጉታታራ እስፈ ኡዱፉና። ");
INSERT INTO gofe_vpl VALUES ("JS15_55","007_15_55","JOS","15","55","55","ቃስ ማኦና፥ ቃርመሎሳ፥ ዚፋ፥ ዩፃ፥ ");
INSERT INTO gofe_vpl VALUES ("JS15_56","007_15_56","JOS","15","56","56","እዝራኤለ፥ ዮቅድኣማ፥ ዛኖሀ፥ ");
INSERT INTO gofe_vpl VALUES ("JS15_57","007_15_57","JOS","15","57","57","ቃይና፥ ግብአነ ትምና። ሀ ካታማት ባንታ ጉታታራ እስፈ ታማ። ");
INSERT INTO gofe_vpl VALUES ("JS15_58","007_15_58","JOS","15","58","58","ሄሳዳካ ሀልሁላ፥ ቤት-ፁራ፥ ጋዶራ፥ ");
INSERT INTO gofe_vpl VALUES ("JS15_59","007_15_59","JOS","15","59","59","ማእራታ፥ ቤት-አኖታነ ኤልትቆና። ሀ ካታማት ባንታ ጉታታራ እስፈ ኡሱፑና። ");
INSERT INTO gofe_vpl VALUES ("JS15_60","007_15_60","JOS","15","60","60","ቃስ ቅርያት-ባኣለ ዎይኮ ቅርያት-ይኣርማነ ራባ። ሀ ካታማት ባንታ ጉታታራ እስፈ ናምአ። ");
INSERT INTO gofe_vpl VALUES ("JS15_61","007_15_61","JOS","15","61","61","መላ ቢታን ቃስ ቤት-አራባ፥ ምድና፥ ሰካካ፥ ");
INSERT INTO gofe_vpl VALUES ("JS15_62","007_15_62","JOS","15","62","62","ንብሻና፥ ማፅነ ካታማነ ኤንጋደ። ሀ ካታማት ባንታ ጉታታራ እስፈ ኡሱፑና። ");
INSERT INTO gofe_vpl VALUES ("JS15_63","007_15_63","JOS","15","63","63","ግዶሽን፥ ይሁዳ አሳይ የሩሳላመን ደእያ ያቡሰታ ጎድድ ከሳናዉ ዳንዳእቦኮና። ሄሳ ግሾ፥ ያቡሰት ሀች ጋካናዉ የሩሳላመን ይሁዳ አሳራ እስፈ ደኦሶና። ");
INSERT INTO gofe_vpl VALUES ("JS16_1","007_16_1","JOS","16","1","1","ዮሰፋ ኮቻታ ጋክዳ ላታ ቢታይ ዱገሀ ባጋራ እያርኮ ማታን ደእያ ዮርዳኖሰን ዶሜስ። እያርኮ ፑልቱዋስ ዉሎሀ ባጋ ጋፃፐ ብድ፥ መላ ቢታ ካንꬅድ፥ ደረይ ዳርያ ቢታ ኤክድ፥ ቤተለ ጋኬስ። ");
INSERT INTO gofe_vpl VALUES ("JS16_2","007_16_2","JOS","16","2","2","ቤተለፐ ብድ፥ አርከት ደእያ አፃሮት-አዳረ ካንꬅድ፥ ሎዛ ጋኬስ። ");
INSERT INTO gofe_vpl VALUES ("JS16_3","007_16_3","JOS","16","3","3","ሄሳፈ ዉሎሀ ባጋን ደእያ ያፍሌፃታ ቢታ ዱገ ዎꬍድ፥ ጋርሳ ቤት-ሆሮና ጋክድ፥ ያፐ ገዘራ ካንꬅድ፥ መደትራነ አባን ዛዋቴስ። ");
INSERT INTO gofe_vpl VALUES ("JS16_4","007_16_4","JOS","16","4","4","ዮሰፋ ኮቻት፥ ምናሰነ ኤፍሬማ ኮቻት፥ ባንታና ጋክያ ቢታ ላትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS16_5","007_16_5","JOS","16","5","5","ኤፍሬማ ኮቻ ኤንታ ኮቻን ኮቻን ጋክዳ ቢታይ ሀይሳ፤ ኤንታ ዛዋይ ዶሎሀ ባጋራ ደእያ አፃሮት-አዳረፐ ብድ፥ ቆሞ ባጋ ቤት-ሆሮና ከዬስ። ");
INSERT INTO gofe_vpl VALUES ("JS16_6","007_16_6","JOS","16","6","6","ያፐ ካንꬅድ መደትራነ አባን ዛዋቴስ። ቃስ ፑደሀ ባጋራ ደእያ ዛዋይ ምክማታታ። ያፐ ዶሎሀ ባጋራ ደእያ ታናት-ሴሎኮ ምርቀትድ፥ ያኖሀ ጋኬስ። ");
INSERT INTO gofe_vpl VALUES ("JS16_7","007_16_7","JOS","16","7","7","ያኖሃፐ ደንድድ፥ አፃሮተነ ናአራተ ዎꬍድ፥ እያርኮ ጋክድ፥ ዉርሰꬃይ ዮርዳኖሰ ሻፋን ኤቄስ። ");
INSERT INTO gofe_vpl VALUES ("JS16_8","007_16_8","JOS","16","8","8","ጋፃ ዛዋይ ታፑሀፐ ብድ፥ ዉሎሀ ባጋራ ደእያ ቃና ሻፋ ላንቅያ ኦይክድ፥ መደትራነ አባን ኤቄስ። ኤፍሬማ ኮቻይ ባንታ ኮቻን ኮቻን ላትዳ ቢታይ ሀይሳ። ");
INSERT INTO gofe_vpl VALUES ("JS16_9","007_16_9","JOS","16","9","9","ሄስ ምናሰ ኮቻ ላታ ግዶን ኤፍሬማ ኮቻስ እመትዳ ካታማታነ ኤንታ ጉታታ ኡባ ጉጄስ። ");
INSERT INTO gofe_vpl VALUES ("JS16_10","007_16_10","JOS","16","10","10","ግዶሽን፥ ኤፍሬማ ኮቻይ ገዘራን ደእያ ካናነታ ጎድድ ከስቦኮና። ሄሳ ግሾ፥ ካናነት ሀች ጋካናዉ ኤፍሬማ ኮቻ ግዶን ደኦሶና። ሽን ኤፍሬማ ኮቻስ አይለትድ ኦꬆሶና። ");
INSERT INTO gofe_vpl VALUES ("JS17_1","007_17_1","JOS","17","1","1","ዮሰፋ ባይራ ናኣ ምናሰ ኮቻስ እመትዳ ላታ ቢታይ ካልድ ደኤይሳ፤ ጋላዳ አዋይ ማክር ምናሰ ባይራ ናአ። ማክር ምኖ ኦላንቾ ግድዳ ግሾ፥ ጋላዳነ ባሳነ ቢታ ኤክዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS17_2","007_17_2","JOS","17","2","2","ዮርዳኖሰ ሻፋፐ ዉሎሀ ባጋራ ደእያ ቢታይ ሀንኮ አትዳ ምናሰ ኮቻስ፥ አብኤዘራስ፥ ሄለቃስ፥ አስርኤላስ፥ ሴከማስ፥ ሄፌራስነ ሻምዳአስ እመትስ። ሀይሳቲ ዮሰፋ ናኣ ምናሰ ኮቻታ። ");
INSERT INTO gofe_vpl VALUES ("JS17_3","007_17_3","JOS","17","3","3","ሄፌራ ናኣ ሰሎጳዳ፥ ጋላዳ ናኣ ሄፌራ፥ ማክራ ናኣ ጋላዳ፥ ምናሰ ናኣ ማክራ። ሰሎጳዳስ ማጫ ናአፐ አትሽን፥ አደ ናእ ባዋ። ሄ ማጫ ናይታ ሱንꬃይ ማህሎ፥ ኖኦ፥ ሆግሎ፥ ምልኮነ ትርፆ። ");
INSERT INTO gofe_vpl VALUES ("JS17_4","007_17_4","JOS","17","4","4","ኤንቲ ካህንያ አላዛራኮ፥ ናወ ናኣ እያሱኮነ ደርያ ጭማታኮ ብድ፥ “ኑ ዳቦታዳ ኑስካ ላታ ቢታ እማና መላ ጎዳይ ሙሰ ኪትስ” ያግዶሶና። ያትን፥ ጎዳይ ኪትዳይሳዳ ኤንታ ዳቦታዳ ኤንታዉካ ላታ ቢታ እምስ። ");
INSERT INTO gofe_vpl VALUES ("JS17_5","007_17_5","JOS","17","5","5","ምናሰ ኮቻት ዮርዳኖሰ ሻፋፐ ዶሎሀ ባጋን ደእያ ጋላዳነ ባሳነ ቦላ ጉጅድ ታሙ ቢታታ ሳማን ኤክዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS17_6","007_17_6","JOS","17","6","6","ሄሳ ግሾ፥ ምናሰ ኮቻፈ ማጫ ናይት አደ ናይታራ እስፈ ላታ ቢታ ሻከትዶሶና። ጋላዳ ቢታይ አትዳ ምናሰ ኮቻስ ግድስ። ");
INSERT INTO gofe_vpl VALUES ("JS17_7","007_17_7","JOS","17","7","7","ምናሰ ኮቻ ቢታ ዛዋይ አሴራፐ ብድ፥ ሴከማፐ ዶሎሀ ባጋን ደእያ ምክማታታ ጋኬስ። ሄ ዛዋይ ያፐ ካንꬅድ፥ ዱገሀ ባጋን አንታፑሀን ደእያ ደርያ ጉጄስ። ");
INSERT INTO gofe_vpl VALUES ("JS17_8","007_17_8","JOS","17","8","8","ታፑሀ ቢታይ ምናሰ ኮቻሳ፥ ሽን ምናሰ ዛዋን ደእያ ታፑሀ ካታማይ ኤፍሬማ ኮቻሳ። ");
INSERT INTO gofe_vpl VALUES ("JS17_9","007_17_9","JOS","17","9","9","ቃስ ሄ ዛዋይ ያፐ ብድ፥ ቃና ሻፋን ዛዋቴስ። ምናሰ ካታማታ ግዶን ኤፍሬማ ካታማትካ ደኦሶና። ሽን ምናሰ ዛዋይ ቃና ሻፋፐ ፑደሀ ባጋራ ብድ መደትራነ አባን ኤቄስ። ");
INSERT INTO gofe_vpl VALUES ("JS17_10","007_17_10","JOS","17","10","10","ሻፋፐ ዱገሀ ባጋን ደእያ ቢታይ ኤፍሬማሳ፤ ቃስ ፑደሀ ባጋን ደእያ ቢታይ ምናሰሳ። ምናሰ ቢታ ዛዋይ መደትራነ አባ ጋኬስ። እያዉ ፑደሀ ባጋራ አሴር፥ ቃስ ዶሎሀ ባጋራ ይሳኮር ዛዋቴስ። ");
INSERT INTO gofe_vpl VALUES ("JS17_11","007_17_11","JOS","17","11","11","ይሳኮራነ አሴራ ቢታታ ግዶን፥ ቤት-ሳና፥ ይብላማ፥ ዶራ፥ ኤንዶራ፥ ታናካነ ማግዶ ጌተትያ ካታማትነ ጉታት ምናሰሳ። ");
INSERT INTO gofe_vpl VALUES ("JS17_12","007_17_12","JOS","17","12","12","ሽን ምናሰ ኮቻት ሄ ካታማታን ደእያ አሳታ ከስድ ካታማታ ኦይካናዉ ዳንዳእቦኮና። ሄሳ ግሾ፥ ካናነት ያን ዱስ ኦይክዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS17_13","007_17_13","JOS","17","13","13","እስራኤለ አሳይ ዎልቃን ምንኮካ፥ ካናነት ዎልቃ ኦሶ ኦꬃና መላ ኡንኤꬅዶሶናፐ አትሽን፥ ኤንታ ኩመꬅ ጎድድ ከስቦኮና። ");
INSERT INTO gofe_vpl VALUES ("JS17_14","007_17_14","JOS","17","14","14","ዮሰፋ ኮቻይ፥ “ጎዳይ ኑና አንጅድ፥ ዳርስስ፤ ያትን፥ አይስ እስ ሳማ ፃላላ ላታ ቢታ ኑስ እማዲ?” ያግድ እያሱ ኦይችዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS17_15","007_17_15","JOS","17","15","15","እያሱይ ዛሪድ፥ “ህንተ ዳሮ ግድኮ፥ ደረይ ዳርያ ኤፍሬማ ቢታይ ህንተዉ ጉፅዳባ ግድኮ፥ ፓርዘትነ ራፋይመት ደእያ ቢታ ብድ ዎራ ቄፅተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JS17_16","007_17_16","JOS","17","16","16","ዮሰፋ ኮቻይ፥ “ሄ ደረይ ዳርያ ቢታይካ ኑስ ግደና። ቃስ ቤት-ሳና ካታማንነ እያ ጉታን ደኤይሳታስነ እዝራኤለ ዛንጋራን ደእያ ካናነታስ ብራታ ፓራ ጋረት ደኦሶና” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS17_17","007_17_17","JOS","17","17","17","ያትን እያሱይ ዮሰፋ ኮቸ ግድዳ ኤፍሬማነ ምናሰ፥ “ህንተ ዳሮነ ዎልቃማ፤ ህንተዉ እስ ሳማ ፃላላ ግዳናዉ በሰና። ");
INSERT INTO gofe_vpl VALUES ("JS17_18","007_17_18","JOS","17","18","18","ሄሳ ግሾ፥ ደረይ ዳርያ ቢታይ ህንተባ ግዳና። ሄ ገዘይ ዎራ ግድኮካ ቄፅድ፥ ጋፃ ጋካናዉ ህንተባ ኦꬅተ። ካናነታስ ብራታ ፓራ ጋረት ደእኮካ፥ ቃስ ኤንቲ አይ ምኖ ግድኮካ ህንተ ኤንታ ጎድድ ከሳናዉ ዳንዳኤታ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JS18_1","007_18_1","JOS","18","1","1","ቢታ ኦል ፆንድ ኦይክዳፐ ጉየ፥ እስራኤለ አሳ ኡባይ ሴሎን ሺቅድ፥ ጎዳ ጎይኖ ዱንካንያ ያን ኤስዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS18_2","007_18_2","JOS","18","2","2","ሽን እስራኤለ አሳፐ ላታ ቢታ ኤክቦና ላፑን ኮቻት አትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS18_3","007_18_3","JOS","18","3","3","ሄሳ ግሾ፥ እያሱይ እስራኤለ አሳኮ፥ “ጎዳይ ህንተ አዋታ ፆሳይ ህንተዉ እምዳ ቢታ ላቶና አዉደ ጋካናዉ ጋምአኔ? ");
INSERT INTO gofe_vpl VALUES ("JS18_4","007_18_4","JOS","18","4","4","እስ እስ ኮቻፈ ሄꬑ ሄꬑ አሳታ ዶርተ። እስ እስ ኮቻይ ላታና ቢታ ኤንቲ ዩይድ፥ ፆሞስ በእድ፥ ማዝጋብድ ያና መላ ታ ኤንታ ኪታና። ኤንቲ ሄ ቢታባ ፃፍ ኤክድ፥ ስሚድ ታኮ ያና። ");
INSERT INTO gofe_vpl VALUES ("JS18_5","007_18_5","JOS","18","5","5","ሄ ቢታ ላፑን በሳን ሻካና። ይሁዳ ኮቻይ ዱገሀ ባጋን፥ ዮሰፋ ኮቻይ ፑደሀ ባጋን ደእያ ባንታ ቢታ ኦይክዳ መላ ዳና። ");
INSERT INTO gofe_vpl VALUES ("JS18_6","007_18_6","JOS","18","6","6","ሀ ላፑን በሳን ሻከታና ቢታ ቆንጭስ ፃፍድ ኤክ ዪተ። ጎዳ፥ ኑ ፆሳ ስንꬃን ኤንታዉ ሳማ የጋና። ");
INSERT INTO gofe_vpl VALUES ("JS18_7","007_18_7","JOS","18","7","7","ግዶሽን፥ ሌወ ኮቻት ካህነ ግድድ፥ ጎዳስ ኦꬅያ ግሾ፥ ህንተራ ላታ ቢታ ኤኮኮና። ጋዳ ኮቻይ፥ ሮቤላ ኮቻይነ፥ ምናሰ ኮቻፈ ባጋይ ዮርዳኖሰ ሻፋፐ ዶሎሀ ባጋን፥ ጎዳ አይለይ፥ ሙሰይ ኤንታዉ እምዳ ቢታ ኮይሮትድ ላትዶሶና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JS18_8","007_18_8","JOS","18","8","8","ሄ አሳት ቢታ ፆሞስድ፥ ፃፋናዉ ባናፐ ስን፥ እያሱይ፥ “ብድ ቢታ ዩይድ ፆሞስድ ፃፍተ፤ ስሚድ ታኮ ዪተ። ታኒ ሀይሳን፥ ሴሎን፥ ጎዳ ስንꬃን ህንተዉ ሳማ የጋና” ያግድ ኪትስ። ");
INSERT INTO gofe_vpl VALUES ("JS18_9","007_18_9","JOS","18","9","9","አሳት ብድ፥ ቢታ ኡባ ዩይዶሶና። ካታማታ ኡባ ፃፍድ፥ ቢታ ዋት ላፑን በሳን ሻካነኮ ቆንጭስዶሶና። ያት ስሚድ፥ እያሱይ ዱንካንዳ ጉታ፥ ሴሎ ስምዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS18_10","007_18_10","JOS","18","10","10","እያሱይ ጎዳ ስንꬃን፥ ሴሎን ኤንታዉ ሳማ የግስ። አትዳ እስራኤለ ዘረꬃታ ጋክያ ላታ ቢታ ሻክድ እምስ። ");
INSERT INTO gofe_vpl VALUES ("JS18_11","007_18_11","JOS","18","11","11","ኮይሮ ሳማይ ብንያመ ኮቻ ኤንታ ኮቻን ኮቻን ጋክስ። ኤንታ ጋክዳ ቢታይ ይሁዳፐነ ዮሰፋ ኮቻፈ ግዶን ደኤስ። ");
INSERT INTO gofe_vpl VALUES ("JS18_12","007_18_12","JOS","18","12","12","ፑደሀ ባጋራ ኤንታ ዛዋይ ዮርዳኖሰፐ ደንድድ፥ እያርኮ ፑደ ከይድ፥ ዉሎሀ ባጋን ደእያ ደረይ ዳርያ ቢታ ካንꬅድ፥ ቤት-አዌና መላ ቢታን ኤቄስ። ");
INSERT INTO gofe_vpl VALUES ("JS18_13","007_18_13","JOS","18","13","13","ሄ ዛዋይ ዱገሀ ባጋራ ካሰ ሎዛ ጌተትድ ፄገትያ ቤተለ ካንꬅድ፥ ዱገሀ አፃሮት-አዳረ ዎꬍድ፥ ቤት-ሆሮናፐ ዱገሀ ባጋን ደእያ ዙማን ዛዋቴስ። ");
INSERT INTO gofe_vpl VALUES ("JS18_14","007_18_14","JOS","18","14","14","ሄ ዛዋይ ዱገሀ ባጋራ ቤት-ሆሮና ስንꬃን ደእያ ዙማፐ ዉሎሀ ባጋ ፃፀትድ፥ ይሁዳ ኮቻ ካታማ ግድዳ፥ ቅርያት-ባኣለ ዎይኮ ቅርያት-ይኣርማ አꬌስ። ሄስ ዉሎሀ ባጋራ ደእያ ዛዋ። ");
INSERT INTO gofe_vpl VALUES ("JS18_15","007_18_15","JOS","18","15","15","ዱገሀ ባጋ ዛዋይ ዉሎሀ ባጋራ ቅርያት-ይኣርመፐ ደንድድ፥ ናፍቶሀ ፑልቶታን ዛዋቴስ። ");
INSERT INTO gofe_vpl VALUES ("JS18_16","007_18_16","JOS","18","16","16","ሄሳፈ ሄ ዛዋይ ዱገ ብድ ራፋይመ ዛንጋራፐ ፑደሀ ባጋን ደእያ ሄኖማ ዛንጋራፐ ስንꬃ ባጋራ ዱገ ዎꬌስ። ያፐ ያቡሰታ ካታማፐ ዱገሀ ባጋን ደእያ ላንቅያ ኦይክድ፥ ህኖመ ዛንጋራ ዎꬍድ፥ ኤንሮጌላን ዛዋቴስ። ");
INSERT INTO gofe_vpl VALUES ("JS18_17","007_18_17","JOS","18","17","17","ያፐ ፑደሀ ባጋ ምርቀትድ ኤንሸመሸ ባጋራ አዱምማ ዙማ ስንꬃን ደእያ ገልሎታ ጋኬስ። ያፐ ቃስ ሮቤላ ናኣ ቦሃና ሹቻኮ ዱገ ዎꬌስ። ");
INSERT INTO gofe_vpl VALUES ("JS18_18","007_18_18","JOS","18","18","18","ቃስ ቤት-አራባ ፑደሀ ባጋ ላንቅያ ኦይክድ፥ ዱገ ዮርዳኖሰ ዛንጋራ ዎꬌስ። ");
INSERT INTO gofe_vpl VALUES ("JS18_19","007_18_19","JOS","18","19","19","ሄሳፈ ቤት-ሆግላ ፑደሀ ላንቅያ ካንꬅ ብድ፥ ዮርዳኖሰ ሻፋይ ጎግድ ገልያ ማፅነ አባፈ ፑደሀ ባጋ ጋፃ ጋኬስ። ሀይስ ዱገሀ ባጋ ዛዋ። ");
INSERT INTO gofe_vpl VALUES ("JS18_20","007_18_20","JOS","18","20","20","ዶሎሀ ባጋ ዛዋይ ዮርዳኖሰ ሻፋ። ብንያመ ኮቻት ላትዳ ቢታይ ኡባ ባጋራ ዛዋትዳ ዛዋይ ሀይሳ። ");
INSERT INTO gofe_vpl VALUES ("JS18_21","007_18_21","JOS","18","21","21","ብንያመ ኮቻይ ባንታ ኮቻን ኮቻ ላትዳ ካታማት፥ እያርኮ፥ ቤት-ሆግላ፥ ኤመቅ-ቃፅፃ፥ ");
INSERT INTO gofe_vpl VALUES ("JS18_22","007_18_22","JOS","18","22","22","ቤት-አራባ፥ ዛማራይመ፥ ቤተለ፥ ");
INSERT INTO gofe_vpl VALUES ("JS18_23","007_18_23","JOS","18","23","23","አዊመ፥ ፓራ፥ ኦፍራ፥ ");
INSERT INTO gofe_vpl VALUES ("JS18_24","007_18_24","JOS","18","24","24","ከፋር-አሞና፥ ኦፍናነ ግብአ። ኤንቲ ኩመꬅ ታማነ ናምኡ ካታማ። ኤንታ ዩሹዋን ደእያ ጉታትካ ኤንታ ቦላ ጉዠቶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS18_25","007_18_25","JOS","18","25","25","ቃስ ጋባኦና፥ ራማ፥ በኤሮታ፥ ");
INSERT INTO gofe_vpl VALUES ("JS18_26","007_18_26","JOS","18","26","26","ምፅጳ፥ ከፍራ፥ ሞፃ፥ ");
INSERT INTO gofe_vpl VALUES ("JS18_27","007_18_27","JOS","18","27","27","ረቄማ፥ ይርጳኤላ፥ ታራላ፥ ");
INSERT INTO gofe_vpl VALUES ("JS18_28","007_18_28","JOS","18","28","28","ፀላአ፥ ኤለፋ፥ የሩሳላመ ጌተትያ ያቡሰታ ካታማ፥ ግብአነ ቅርያት-ይኣርማ። ኤንቲ ኩመꬅ ታማነ ኦይዱ ካታማ። ኤንታ ዩሹዋን ደእያ ጉታትካ ኤንታ ቦላ ጉዠቶሶና። ብንያመ ኮቻይ ባንታ ኮቻን ላትዳ ቢታይ ሀይሳ። ");
INSERT INTO gofe_vpl VALUES ("JS19_1","007_19_1","JOS","19","1","1","ናምአንꬆ ሳማይ ስሞና ኮቻ ኤንታ ኮቻን ኮቻን ጋክስ። ኤንቲ ላትዳ ቢታይ ይሁዳ ኮቻት ላትዳ ቢታ ግዶን ደኤስ። ");
INSERT INTO gofe_vpl VALUES ("JS19_2","007_19_2","JOS","19","2","2","ኤንቲ ላትዳ ካታማት፥ በርሳበ ዎይኮ ሴባ፥ ሞላዳ፥ ");
INSERT INTO gofe_vpl VALUES ("JS19_3","007_19_3","JOS","19","3","3","ሀፃር-ሹኣላ፥ ባላ፥ ኤፀማ፥ ");
INSERT INTO gofe_vpl VALUES ("JS19_4","007_19_4","JOS","19","4","4","ኤልቶላዳ፥ ባቱላ፥ ሆርማ፥ ");
INSERT INTO gofe_vpl VALUES ("JS19_5","007_19_5","JOS","19","5","5","ፅቅላጋ፥ ቤት-ማርካቦታ፥ ሀፃር-ሱሳ፥ ");
INSERT INTO gofe_vpl VALUES ("JS19_6","007_19_6","JOS","19","6","6","ቤት-ላባኦታነ ሻሩሀ። ኤንቲ ኩመꬅ ታማነ ሄꬓ ካታማ። ኤንታ ዩሹዋን ደእያ ጉታት ኤንታ ቦላ ጉዠቶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS19_7","007_19_7","JOS","19","7","7","ቃስ ሀራ በሳን አይና፥ እርሞና፥ ኤተራነ አሻና ጌተትያ ኦይዱ ካታማታነ ኤንታ ዩሹዋን ደእያ ጉታታ ኦይክዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS19_8","007_19_8","JOS","19","8","8","ስሞና ቢታይ ዱገሀ ባጋን ደእያ ባእላት-ባኤራ ዎይኮ ራማ ካታማታነ ኤንታ ዩሹዋን ደእያ ጉታታ ኡባ ጋኬስ። ስሞና ኮቻይ ባንታ ኮቻን ኮቻን ላትዳ ቢታይ ሀይሳ። ");
INSERT INTO gofe_vpl VALUES ("JS19_9","007_19_9","JOS","19","9","9","ይሁዳ ኮቻታ ጋክዳ ቢታይ ዳልጋ ግድዳ ግሾ፥ እያፐ ሻከትድ፥ ስሞና ኮቻታስ እመትስ። ");
INSERT INTO gofe_vpl VALUES ("JS19_10","007_19_10","JOS","19","10","10","ሄꬓንꬆ ሳማይ ዛብሎና ኮቻ ኤንታ ኮቻን ኮቻን ጋክስ። ኤንቲ ላትዳ ቢታይ ሳርዳ ጋኬስ። ");
INSERT INTO gofe_vpl VALUES ("JS19_11","007_19_11","JOS","19","11","11","ያፐ ደንድድ ዛዋይ ዉሎሀ ባጋን ደእያ ማርአላ ካንꬅድ፥ ዳባሼታ ቦችሸ፥ ዮቅናማ ማታን ደእያ ሃꬃ ጋኬስ። ");
INSERT INTO gofe_vpl VALUES ("JS19_12","007_19_12","JOS","19","12","12","ሳርዳፐ ዶሎሀ ባጋ ምርቀትድ፥ ክስሎት-ታቦራ ካንꬅድ ዳብራታንነ ያፋን ዛዋቴስ። ");
INSERT INTO gofe_vpl VALUES ("JS19_13","007_19_13","JOS","19","13","13","ያፐ ዉሎሀ ባጋራ ካንꬅድ፥ ጋት-ሄፌራነ እት-ቃፅናና ጋክድ፥ እርሞናኮነ ነአኮ ምርቀቴስ። ");
INSERT INTO gofe_vpl VALUES ("JS19_14","007_19_14","JOS","19","14","14","ፑደሀ ባጋ ዛዋይ ሀናቶነ ዩይድ፥ ይፍታሄ ዛንጋራን ዛዋቴስ። ");
INSERT INTO gofe_vpl VALUES ("JS19_15","007_19_15","JOS","19","15","15","ሄ ዛዋይ ቃፃታ፥ ናህላላ፥ ሽምሮና፥ ይዳላነ ቤተለመ ጌተትያ ካታማታ ኦይኬስ። ኤንቲ ኩመꬅ ታማነ ናምኡ ካታማ፤ ኤንታ ዩሹዋን ደእያ ጉታት ኤንታ ቦላ ጉዠቶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS19_16","007_19_16","JOS","19","16","16","ዛብሎና ኮቻት ባንታ ኮቻን ኮቻን ላትዳ ካታማትነ ኤንታ ዩሹዋን ደእያ ጉታት ሀይሳታ። ");
INSERT INTO gofe_vpl VALUES ("JS19_17","007_19_17","JOS","19","17","17","ኦይዳንꬆ ሳማይ ይሳኮራ ኮቻ ኤንታ ኮቻን ኮቻን ጋክስ። ");
INSERT INTO gofe_vpl VALUES ("JS19_18","007_19_18","JOS","19","18","18","ኤንታ ዛዋይ እዝራኤለ፥ ካሱሎታ፥ ሱኔማ፥ ");
INSERT INTO gofe_vpl VALUES ("JS19_19","007_19_19","JOS","19","19","19","ሀፋራይማ፥ ሽኦና፥ አናሃራታ፥ ");
INSERT INTO gofe_vpl VALUES ("JS19_20","007_19_20","JOS","19","20","20","ራብታ፥ ቅሶና፥ አቤፃ፥ ");
INSERT INTO gofe_vpl VALUES ("JS19_21","007_19_21","JOS","19","21","21","ራመታ፥ ኤንጋንማ፥ ኤንሀዳነ ቤት-ጳፀፃ ኦይኬስ። ");
INSERT INTO gofe_vpl VALUES ("JS19_22","007_19_22","JOS","19","22","22","ሄ ቢታ ዛዋይ ታቦረ፥ ሻሀፁማነ ቤት-ሳሜሳ ቦችሸ ብድ፥ ዮርዳኖሰ ሻፋን ዛዋቴስ። ኤንቲ ኩመꬅ ታማነ ኡሱፑን ካታማ፤ ኤንታ ዩሹዋን ደእያ ጉታት ኤንታ ቦላ ጉዠቶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS19_23","007_19_23","JOS","19","23","23","ይሳኮራ ኮቻይ ባንታ ኮቻን ኮቻን ላትዳ ቢታ ግዶን ደእያ ካታማትነ ኤንታ ዩሹዋን ደእያ ጉታት ሀይሳታ። ");
INSERT INTO gofe_vpl VALUES ("JS19_24","007_19_24","JOS","19","24","24","እቻሻንꬆ ሳማይ አሴራ ኮቻ ኤንታ ኮቻን ኮቻን ጋክስ። ");
INSERT INTO gofe_vpl VALUES ("JS19_25","007_19_25","JOS","19","25","25","ኤንታ ቢታ ዛዋይ፥ ሄልቃታ፥ ሀላ፥ በፀና፥ አዝፋ፥ ");
INSERT INTO gofe_vpl VALUES ("JS19_26","007_19_26","JOS","19","26","26","አላመለከ፥ አማዳነ ምሻላ ኤኬስ። ዉሎሀ ባጋራ ቃርመሎሳንነ ስሆር-ልብናታን ዛዋቴስ። ");
INSERT INTO gofe_vpl VALUES ("JS19_27","007_19_27","JOS","19","27","27","ቃስ ዶሎሀ ባጋራ ቤት-ዳጎናኮ ምርቀትድ፥ ዛብሎናነ ይፍታህኤላ ዛንጋራ ቦችሸ ብድ፥ ፑደሀ ባጋራ ቤት-ኤመቃነ ንኤላ ጋኬስ። ቃስ ፑደሀ ባጋራ ካቡላ፥ ");
INSERT INTO gofe_vpl VALUES ("JS19_28","007_19_28","JOS","19","28","28","ኤብሮና፥ ረሆባ፥ ሀሞናነ ቃና ካንꬅድ፥ ስዶናን ዛዋቴስ። ");
INSERT INTO gofe_vpl VALUES ("JS19_29","007_19_29","JOS","19","29","29","ሄ ዛዋይ ራማ ዩይድ፥ ግምበን ድረትዳ ፅሮሳ ካታማ ጋክድ፥ ሆሳኮ ምርቀትድ፥ መደትራነ አባን ዛዋቴስ። ቃስ ማሀላባ፥ አክዚባ፥ ");
INSERT INTO gofe_vpl VALUES ("JS19_30","007_19_30","JOS","19","30","30","ኡማ፥ አፌቃነ ረሆባ ጌተትያ ካታማታ ጋክድ ዛዋቴስ። ኤንቲ ኩመꬅ ላታማነ ናምኡ ካታማ፤ ኤንታ ዩሹዋን ደእያ ጉታት ኤንታ ቦላ ጉዠቶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS19_31","007_19_31","JOS","19","31","31","አሴራ ኮቻይ ባንታ ኮቻን ኮቻን ላትዳ ካታማትነ ኤንታ ዩሹዋን ደእያ ጉታት ሀይሳታ። ");
INSERT INTO gofe_vpl VALUES ("JS19_32","007_19_32","JOS","19","32","32","ኡሱፑንꬆ ሳማይ ንፍታለመ ኮቻ ኤንታ ኮቻን ኮቻን ጋክስ። ");
INSERT INTO gofe_vpl VALUES ("JS19_33","007_19_33","JOS","19","33","33","ኤንታ ዛዋይ ሄለፋፐነ ዛናንመ ዎላፐ ብድ፥ አዳም-ነቀባ፥ ያብንኤላነ ላቁማ ካንꬅድ፥ ዉርሰꬃይ ዮርዳኖሰ ሻፋን ኤቄስ። ");
INSERT INTO gofe_vpl VALUES ("JS19_34","007_19_34","JOS","19","34","34","ቃስ ሄ ዛዋይ ዉሎሀ ባጋራ አዝኖት-ታቦራኮ ምርቀትድ፥ ሁቆቃን ኤቄስ። ሄ ዛዋይ ዱገሀ ባጋን ዛብሎና፥ ዉሎሀ ባጋን አሴራ፥ ዶሎሀ ባጋን ዮርዳኖሰ ሻፋ ካንꬅድ ይሁዳን ጋኬስ። ");
INSERT INTO gofe_vpl VALUES ("JS19_35","007_19_35","JOS","19","35","35","ግምበን ድረትዳ ካታማት፥ ፅድማ፥ ፄራ፥ ሀማታ፥ ራቃታ፥ ከነሬታ አባ፥ ");
INSERT INTO gofe_vpl VALUES ("JS19_36","007_19_36","JOS","19","36","36","አዳማ፥ ራማ፥ ሀፆራ፥ ");
INSERT INTO gofe_vpl VALUES ("JS19_37","007_19_37","JOS","19","37","37","ቄደሻ፥ ኤድራአ፥ ኤንሀፆራ፥ ");
INSERT INTO gofe_vpl VALUES ("JS19_38","007_19_38","JOS","19","38","38","ይርኦና፥ ማግደላ፥ ሆረማ፥ ቤት-አናታነ ቤት-ሳሜሳ ካታማታ ኦይኬስ። ሄ ካታማት ኩመꬅ ታማነ ኡዱፉና፤ ኤንታ ዩሹዋን ደእያ ጉታት ኤንታ ቦላ ጉዠቶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS19_39","007_19_39","JOS","19","39","39","ንፍታለመ ኮቻይ ባንታ ኮቻን ኮቻን ላትዳ ካታማትነ ኤንታ ዩሹዋን ደእያ ጉታት ሀይሳታ። ");
INSERT INTO gofe_vpl VALUES ("JS19_40","007_19_40","JOS","19","40","40","ላፑንꬃ ሳማይ ዳነ ኮቻ ኤንታ ኮቻን ኮቻን ጋክስ። ");
INSERT INTO gofe_vpl VALUES ("JS19_41","007_19_41","JOS","19","41","41","ኤንቲ ላትዳ ካታማት ፆርአ፥ ኤሽታኦላ፥ እርሸመሻ፥ ");
INSERT INTO gofe_vpl VALUES ("JS19_42","007_19_42","JOS","19","42","42","ሻአልብማ፥ ኤሎና፥ ይታላ፥ ");
INSERT INTO gofe_vpl VALUES ("JS19_43","007_19_43","JOS","19","43","43","ኤሎና፥ ትምና፥ ኤቅሮና፥ ");
INSERT INTO gofe_vpl VALUES ("JS19_44","007_19_44","JOS","19","44","44","ኤልታቃ፥ ግብቶና፥ ባላታ፥ ");
INSERT INTO gofe_vpl VALUES ("JS19_45","007_19_45","JOS","19","45","45","የሁዳ፥ በነባራቃ፥ ጋት-ርሞና፥ ");
INSERT INTO gofe_vpl VALUES ("JS19_46","007_19_46","JOS","19","46","46","ማያርቆና፥ ራቆናነ ዮጰ ካታማ ዩሹዋን ደእያ ሄራታ ኦይኬስ። ");
INSERT INTO gofe_vpl VALUES ("JS19_47","007_19_47","JOS","19","47","47","ዳነ ኮቻይ ኤንታ ላታ ቢታይ ኤንታፈ ኤከትን፥ ላሸማ ካታማ ብድ፥ ኦላን ፆንድ፥ ሄ ካታማን ደእያ አሳ ማሻን ዎꬍድ፥ ሄ ቢታ ባንታባ ኦꬅዶሶና። ሄ ካታማ ሱንꬃ ላምድ፥ ባንታ አዋ ዳነ ሱንꬃን ዳነ ግድ ሱንꬅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS19_48","007_19_48","JOS","19","48","48","ዳነ ኮቻት ባንታ ኮቻን ኮቻን ላትዳ ካታማትነ ኤንታ ዩሹዋን ደእያ ጉታት ሀይሳታ። ");
INSERT INTO gofe_vpl VALUES ("JS19_49","007_19_49","JOS","19","49","49","እስራኤለ አሳይ ቢታ ሻሁዋ ኦንግዳ ዎደ፥ ናወ ናኣ እያሱስ ላታ ቢታ እምዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS19_50","007_19_50","JOS","19","50","50","ጎዳይ ካሰ ኪትዳይሳዳ እያሱይ ደረይ ዳርያ ኤፍሬማን ደእያ ትምናት-ሳራ ካታማ እማና መላ ኦይችን፥ እያዉ እምዶሶና። ሄ ካታማ ዛር ጊግስድ፥ ያን ደእስ። ");
INSERT INTO gofe_vpl VALUES ("JS19_51","007_19_51","JOS","19","51","51","ካህነይ አላዛር፥ ናወ ናኣ እያሱይነ እስራኤለ ሶ አሳ ሀላቃት ሴሎን፥ ጎዳ ስንꬃን ፆሳ ዱንካንያ ፐንገን ሳማ የግድ፥ ሻክዳ ላታ ቢታይ ሀይሳ። ኤንቲ ቢታ ያት ሻክድ ኦንግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS20_1","007_20_1","JOS","20","1","1","ሄሳፈ ጉየ ጎዳይ እያሱኮ ሀይሳዳ ያግስ፤ ");
INSERT INTO gofe_vpl VALUES ("JS20_2","007_20_2","JOS","20","2","2","“ታኒ ሙሰ ባጋራ ኪትዳይሳዳ፥ ‘አሳይ ባቃትድ አትያ ካታማታ ዱማያና መላ’ እስራኤለ አሳስ ኦዳ። ");
INSERT INTO gofe_vpl VALUES ("JS20_3","007_20_3","JOS","20","3","3","ኦንካ ቆፖናነ ኤሮና አሰ ዎꬍኮ፥ ያ ባቃትድ ጉክዳ ሱꬃ ግሾ ሱꬅ ዛራናዉ ኮያ ኡራፐ አታና። ");
INSERT INTO gofe_vpl VALUES ("JS20_4","007_20_4","JOS","20","4","4","አሰ ዎꬍዳይስ ሄ ካታማታፐ እሱዋኮ ባቃትድ ብድ፥ ካታማ ፐንገን ኤቅድ፥ ሀንዳባ ኡባ ሄ ካታማ ጭማታስ ኦዶ። ሄሳፈ ጉየ፥ ኤንቲ ባንታ ካታማ ኤፍድ፥ እ ዳና በሲ እምኮ ኤንታራ ያን ደኦ። ");
INSERT INTO gofe_vpl VALUES ("JS20_5","007_20_5","JOS","20","5","5","ሱꬃ ግሾ ሱꬅ ዛራናዉ ኮያ ኡራይ እያ ካልድ ዪኮ፥ እ ባ እሻ ኤርድ፥ ቆሀናዉ ኮይድ ዎꬍቦና ግሾ ሄ ካታማ ጭማት እያ አꬅድ እሞፎ። ");
INSERT INTO gofe_vpl VALUES ("JS20_6","007_20_6","JOS","20","6","6","ሻንጎ ስንꬃን ሺቅድ፥ ፕርደታና ጋካናዉነ ሄ ዎደ ደእያ ካህነ ሀላቃይ ሀይቃና ጋካናዉ ሄ ካታማን ደኦ። ሄሳፈ ጉየ፥ ባቃትድ ከይዳ ካታማ ጉየ ስሚድ ባ ሶ ገሎ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JS20_7","007_20_7","JOS","20","7","7","ያትን እስራኤለ አሳይ ደረይ ዳርያ ንፍታለመን ጋልላን ደእያ ቃደሳ፥ ደረይ ዳርያ ኤፍሬማን ደእያ ሴከማነ ደረይ ዳርያ ይሁዳን ደእያ ቅርያት-አርባ ዎይኮ ከብሮና ዱማይዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS20_8","007_20_8","JOS","20","8","8","ዮርዳኖሰ ሻፋፐ ሄፍንꬃን፥ እያርኮፈ ዶሎሀ ባጋን ꬎቃን፥ መላ ቢታን፥ ሮቤላ፥ ኮቻታ ቢታን ደእያ ቦሶራ፥ ጋዳ ኮቻታ ቢታን፥ ጋላዳን ደእያ ራሞታነ ምናሰ ኮቻታ ቢታን፥ ባሳነን ደእያ ጎላና ዱማይዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS20_9","007_20_9","JOS","20","9","9","እስራኤለ አሳይነ ኤንታ ግዶን ደእያ በታንቾት ባቃትድ አታና መላ ዱማትዳ ካታማት ሀይሳታ። ኦንካ ኤሮና ደእሸ አሰ ዎꬍኮ፥ ሻንጎ ስንꬃን ፕርደቶና ደእሸ፥ ሀይቆና አታናዉ ሀ ካታማታፐ እሱዋኮ ባቃታናዉ ዳንዳኤስ። ");
INSERT INTO gofe_vpl VALUES ("JS21_1","007_21_1","JOS","21","1","2","ሄሳፈ ጉየ፥ እስራኤለ አሳይ ካናነ ቢታን፥ ሴሎን ዱንካንድ ደእሽን፥ ሌወ ሶ አሳ ሀላቃት ካህንያ አላዛራኮ፥ ናወ ናኣ እያሱኮነ እስራኤለ ሀላቃታኮ ይድ፥ “ኑኒ ዳና ካታማታነ መሄ ሄምያ ቢታ ኑስ እማና መላ፥ ጎዳይ ሙሰ ባጋራ ኪትስ” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS21_3","007_21_3","JOS","21","3","3","ሄሳ ግሾ፥ ጎዳይ ኪትዳይሳዳ፥ እስራኤለ አሳይ ሌወታስ ካታማታነ መሄ ሄምያ ቢታ ባንታ ቢታፈ ሻክድ፥ እምዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS21_4","007_21_4","JOS","21","4","4","ኮይሮ ሳማይ ቃሃታ ኮቻስ ከይስ። ካህንያ አሮና ኮቻይ፥ ይሁዳ፥ ስሞናነ ብንያመ ኮቻፈ ታማነ ሄꬑ ካታማታ ሳማን ኤክዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS21_5","007_21_5","JOS","21","5","5","አትዳ ቃሃታ ኮቻይ፥ ኤፍሬማ፥ ዳነነ ዉሎሀ ባጋን ደእያ ምናሰ ኮቻፈ ታሙ ካታማታ ሳማን ኤክዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS21_6","007_21_6","JOS","21","6","6","ገድሶና ኮቻይ፥ ይሳኮራ፥ አሴራ ንፍታለመነ ዶሎሀ ባጋን ደእያ ምናሰ ኮቻፈ ታማነ ሄꬑ ካታማታ ሳማን ኤክዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS21_7","007_21_7","JOS","21","7","7","መራራ ኮቻይ፥ ሮቤላ፥ ጋደነ ዛብሎና ኮቻፈ ታማነ ናምኡ ካታማታ ኤክዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS21_8","007_21_8","JOS","21","8","8","ጎዳይ ሙሰ ባጋራ ኪትዳይሳዳ፥ እስራኤለ አሳይ ሀ ካታማታነ መሄ ሄምያ ቢታ ሌወታስ ሳማን ሻክድ እምዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS21_9","007_21_9","JOS","21","9","9","እስራኤለ አሳይ ይሁዳነ ስሞና ኮቻፈ ካልድ ሱንꬃን ፄገትዳ ካታማታ እምዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS21_10","007_21_10","JOS","21","10","10","ኮይሮ ሳማይ ሌወ ኮቻፈ የለትዳ፥ ቃሃታ ኮቸ ግድዳ አሮና ያራስ ከይን፥ ኤንታዉ እመትዳ ካታማት ሀይሳታ፤ ");
INSERT INTO gofe_vpl VALUES ("JS21_11","007_21_11","JOS","21","11","11","ደረይ ዳርያ ይሁዳን ደእያ ቅርያት-አርባ ዎይኮ ከብሮነነ እያ ዩሹዋን ደእያ ሄንꬃ ቢታታ ኤንታዉ እምዶሶና። (አርብ አናቀ አዋ።) ");
INSERT INTO gofe_vpl VALUES ("JS21_12","007_21_12","JOS","21","12","12","ሽን ኮይሮ ሄ ካታማ ዩሹዋን ደእያ ቢታነ ጉታታ ዮፎና ናኣ ካለባስ ላታ ኦꬅድ እምዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS21_13","007_21_13","JOS","21","13","13","ካህንያ አሮና ያራስ አሰ ዎꬍዳ አስ ባቃትድ አትያ ከብሮነነ ሄንꬃ ቢታ፥ ልብናነ ሄንꬃ ቢታ፥ ");
INSERT INTO gofe_vpl VALUES ("JS21_14","007_21_14","JOS","21","14","14","ያትራነ ሄንꬃ ቢታ፥ ኤሽታሞአነ ሄንꬃ ቢታ፥ ");
INSERT INTO gofe_vpl VALUES ("JS21_15","007_21_15","JOS","21","15","15","ሆሎናነ ሄንꬃ ቢታ፥ ዳብራነ ሄንꬃ ቢታ፥ ");
INSERT INTO gofe_vpl VALUES ("JS21_16","007_21_16","JOS","21","16","16","አይናነ ሄንꬃ ቢታ፥ ዩፃነ ሄንꬃ ቢታ፥ ቤት-ሳሜሳነ ሄንꬃ ቢታ። ሀይሳቲ ይሁዳፐነ ስሞናፐ ኤከትዳ፥ ካታማት ኩመꬅ ኡዱፉና። ");
INSERT INTO gofe_vpl VALUES ("JS21_17","007_21_17","JOS","21","17","17","ብንያመ ኮቻፈ ኤከትዳ ኦይዱ ካታማት፥ ጋባኦናነ ሄንꬃ ቢታ፥ ግብአነ ሄንꬃ ቢታ፥ ");
INSERT INTO gofe_vpl VALUES ("JS21_18","007_21_18","JOS","21","18","18","አናቶተነ ሄንꬃ ቢታ፥ አልሞናነ ሄንꬃ ቢታ። ");
INSERT INTO gofe_vpl VALUES ("JS21_19","007_21_19","JOS","21","19","19","አሮና ኮቸ ግድዳ ካህነታስ እመትዳ ካታማትነ ሄንꬃ ቢታት ታማነ ሄꬓ። ");
INSERT INTO gofe_vpl VALUES ("JS21_20","007_21_20","JOS","21","20","20","ሌወ ኮቸ ግድዳ፥ አትዳ ቃሃታ ኮቻስ፥ ኤፍሬማስ እመትዳ ቢታፈ ሻከትድ እመትስ። ");
INSERT INTO gofe_vpl VALUES ("JS21_21","007_21_21","JOS","21","21","21","ቃስ ኤንታዉ ደረይ ዳርያ ኤፍሬማን፥ አሰ ዎꬍዳ አስ ባቃትድ አትያ ኦይዱ ካታማት ሴከማነ ሄንꬃ ቢታ፥ ገዘራነ ሄንꬃ ቢታ፥ ");
INSERT INTO gofe_vpl VALUES ("JS21_22","007_21_22","JOS","21","22","22","ቅብፃይማነ ሄንꬃ ቢታ፥ ቤት-ሆሮናነ ሄንꬃ ቢታ እምዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS21_23","007_21_23","JOS","21","23","23","ዳነ ኮቻፈ ሻከት እመትዳ ኦይዱ ካታማት፥ ኤልታቃነ ሄንꬃ ቢታ፥ ግበቶናነ ሄንꬃ ቢታ፥ ");
INSERT INTO gofe_vpl VALUES ("JS21_24","007_21_24","JOS","21","24","24","ኤሎናነ ሄንꬃ ቢታ፥ ጋት-ርሞናነ ሄንꬃ ቢታ። ");
INSERT INTO gofe_vpl VALUES ("JS21_25","007_21_25","JOS","21","25","25","ምናሰ ኮቻ ባጋፈ ሻከት እመትዳ ናምኡ ካታማት፥ ታናካነ ሄንꬃ ቢታ፥ ጋት-ርሞናነ ሄንꬃ ቢታ። ");
INSERT INTO gofe_vpl VALUES ("JS21_26","007_21_26","JOS","21","26","26","አትዳ ቃሃታ ኮቻት ሄንꬃ ቢታራ እስፈ ታሙ ካታማ ኤክዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS21_27","007_21_27","JOS","21","27","27","ሀራ ሌወ ኮቸ ግድዳ ገድሶና ኮቻስ እመትዳ ቢታይ፥ ምናሰ ኮቻ ባጋፈ አሰ ዎꬍዳ አስ ባቃትድ አትያ ናምኡ ካታማት፥ ባሳነን ደእያ ጎላናነ ሄንꬃ ቢታ፥ በኤሽትራነ ሄንꬃ ቢታ። ");
INSERT INTO gofe_vpl VALUES ("JS21_28","007_21_28","JOS","21","28","28","ይሳኮራ ኮቻፈ እመትዳ ኦይዱ ካታማት፥ ቅሶናነ ሄንꬃ ቢታ፥ ደብራታነ ሄንꬃ ቢታ። ");
INSERT INTO gofe_vpl VALUES ("JS21_29","007_21_29","JOS","21","29","29","ያርሙታነ ሄንꬃ ቢታ፥ ኤንጋንማነ ሄንꬃ ቢታ። ");
INSERT INTO gofe_vpl VALUES ("JS21_30","007_21_30","JOS","21","30","30","አሴራ ኮቻፈ ሻከት እመትዳ ኦይዱ ካታማት ምሻላነ ሄንꬃ ቢታ፥ አብዶናነ ሄንꬃ ቢታ፥ ");
INSERT INTO gofe_vpl VALUES ("JS21_31","007_21_31","JOS","21","31","31","ሄልቃተነ ሄንꬃ ቢታ፥ ረሆባነ ሄንꬃ ቢታ። ");
INSERT INTO gofe_vpl VALUES ("JS21_32","007_21_32","JOS","21","32","32","ንፍታለመ ኮቻፈ ሻከት እመትዳ ሄꬑ ካታማት፥ አሰ ዎꬍዳ አስ ባቃትድ አትያ፥ ጋልላን ደእያ ቃደሳነ ሄንꬃ ቢታ፥ ሀሞት-ዶራነ ሄንꬃ ቢታ፥ ቃርታናነ ሄንꬃ ቢታ። ");
INSERT INTO gofe_vpl VALUES ("JS21_33","007_21_33","JOS","21","33","33","ገድሶና ኮቻት ሄንꬃ ቢታራ እስፈ ታማነ ሄꬑ ካታማታ ኤክዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS21_34","007_21_34","JOS","21","34","34","ሌወ ኮቸ ግድዳ አትዳ መራራ ኮቻት፥ ዛብሎና ኮቻፈ ሻከት እመትዳ ኦይዱ ካታማት፥ ዮቅናማነ ሄንꬃ ቢታ፥ ቃርታናነ ሄንꬃ ቢታ፥ ");
INSERT INTO gofe_vpl VALUES ("JS21_35","007_21_35","JOS","21","35","35","ድምናነ ሄንꬃ ቢታ፥ ናህላላነ ሄንꬃ ቢታ ኤክዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS21_36","007_21_36","JOS","21","36","36","ሮቤላ፥ ኮቻፈ ሻከትድ እመትዳ ኦይዱ ካታማት፥ ቦሶራነ ሄንꬃ ቢታ፥ ያሃፃነ ሄንꬃ ቢታ፥ ");
INSERT INTO gofe_vpl VALUES ("JS21_37","007_21_37","JOS","21","37","37","ቅደሞታነ ሄንꬃ ቢታ፥ መፋታነ ሄንꬃ ቢታ። ");
INSERT INTO gofe_vpl VALUES ("JS21_38","007_21_38","JOS","21","38","38","ጋዳ ኮቻፈ ሻከትድ እመትዳ ኦይዱ ካታማት፥ ጋላዳን አሰ ዎꬍዳ አስ ባቃትድ አትያ፥ ራሞታነ ሄንꬃ ቢታ፥ ማህናይመ፥ ");
INSERT INTO gofe_vpl VALUES ("JS21_39","007_21_39","JOS","21","39","39","ሀሰቦና፥ ያእዜራ። ");
INSERT INTO gofe_vpl VALUES ("JS21_40","007_21_40","JOS","21","40","40","ሌወ ኮቸ ግድዳ አትዳ መራራ ኮቻይ ኤክዳ ካታማት ታማነ ናምአ። ");
INSERT INTO gofe_vpl VALUES ("JS21_41","007_21_41","JOS","21","41","41","እስራኤለ አሳይ ላትዳ ቢታፈ ሌወ ኮቻስ እመትዳ ካታማት ሄንꬃ ቢታራ እስፈ ኦይታማነ ሆስፑና። ");
INSERT INTO gofe_vpl VALUES ("JS21_42","007_21_42","JOS","21","42","42","ሄ ካታማታ ኡባ ዩሹዋን ሄንꬃ ቢታት ደኦሶና። ");
INSERT INTO gofe_vpl VALUES ("JS21_43","007_21_43","JOS","21","43","43","ጎዳይ ኤንታ አዋታስ እማና ግድ ጫቅዳ ቢታ ኡባ እስራኤለ አሳስ እምስ። ኤንቲ ሄ ቢታ ላትድ፥ ያን ደእዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS21_44","007_21_44","JOS","21","44","44","ጎዳይ ኤንታ አዋታስ ጫቅዳይሳዳ፥ ኤንታ ሳሮን ዎꬅስ። ኤንቲ ኦላስ ከይዳ ዎደ ኡባን ኤንታ ሞርከት ኤንታራ ኤቀታናዉ ዳንዳእቦኮና። ");
INSERT INTO gofe_vpl VALUES ("JS21_45","007_21_45","JOS","21","45","45","ጎዳይ እስራኤለ አሳስ እማና ግድ ጫቅዳ ሎኦባ ኡባ ፖልስፐ አትሽን፥ እሶይካ አትቤና። ");
INSERT INTO gofe_vpl VALUES ("JS22_1","007_22_1","JOS","22","1","1","ሄሳፈ ጉየ፥ እያሱይ ሮቤላ፥ ጋደነ ምናሰ ኮቻፈ ባጋ ፄግድ፥ ");
INSERT INTO gofe_vpl VALUES ("JS22_2","007_22_2","JOS","22","2","2","“ጎዳ አይለይ ሙሰይ ህንተና ኪትዳ ኡባ ፖልደታ፤ ቃስ ታዉ ኪተትደታ። ");
INSERT INTO gofe_vpl VALUES ("JS22_3","007_22_3","JOS","22","3","3","ሄ ኡባን ሀች ጋካናዉ ህንተ እሻታ የግቤከታ። ጎዳ፥ ህንተ ፆሳ ኪታ ኡባ ፖልደታ። ");
INSERT INTO gofe_vpl VALUES ("JS22_4","007_22_4","JOS","22","4","4","ጎዳይ ህንተ ፆሳይ ህንተዉ ጫቅዳ ቃላዳ፥ ህንተ እሻታ ሸምፕስስ። ሄሳ ግሾ፥ ጎዳ አይለይ ሙሰይ ህንተዉ ዮርዳኖሰ ሻፋፐ ዶሎሀ ባጋን እምዳ፥ ላታ ቢታን ደእያ ህንተ ሶ ሶ ስምተ። ");
INSERT INTO gofe_vpl VALUES ("JS22_5","007_22_5","JOS","22","5","5","ጎዳ አይለይ ሙሰይ ህንተና ኪትዳ ህግያ ምንꬅድ ናግተ። ጎዳ ህንተ ፆሳ ሲቅተ። እያ ኦግያፐ ደሾፕተ፤ እያ ኪታ ፖልተ። እያራ ሽጵ ግድ ደእተ፤ ህንተ ኩመꬃ ዎዛናፐነ ኩመꬃ ሸምፑዋፈ እያዉ ኦꬅተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JS22_6","007_22_6","JOS","22","6","6","እያሱይ ኤንታ አንጅድ የድን ኤንቲ ባንታ ሶ ስምዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS22_7","007_22_7","JOS","22","7","7","እያሱይ፥ ምናሰ ኮቻ ባጋስ ባሳነን ላታ ቢታ እምስ። አትዳ ባጋ ኮቻስ ቃስ ዮርዳኖሰፐ ዉሎሀ ባጋን ላታ ቢታ እምስ። እያሱይ ኤንታ አንጅድ ሞይዝሸ፥ ");
INSERT INTO gofe_vpl VALUES ("JS22_8","007_22_8","JOS","22","8","8","ህንተ፥ “ዳሮ መሄ፥ ብራ፥ ዎርቃ፥ ናሰ፥ ብራታነ ዳሮ ማኦ ኤክድ ህንተ ሶ ስማና ሀኔታ። ሄሳ ግሾ፥ ህንተ ሞርከታፐ ድእዳይሳ ህንተ እሻታራ ሻከትተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JS22_9","007_22_9","JOS","22","9","9","ሮቤላ፥ ጋድነ ምናሰ ኮቻ ባጋይ ባንታ ላታ ቢታ ስምዶሶና። ኤንቲ፥ ጎዳይ ሙሰ ባጋራ ኪትን ላትዳ ጋላዳ ቢታ፥ ካናነ ቢታን፥ ሴሎን ደእያ እስራኤለ አሳፐ ሻከትድ ብዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS22_10","007_22_10","JOS","22","10","10","ሮቤላ፥ ጋድነ ምናሰ ኮቻፈ ባጋይ ዮርዳኖሰ ማታን ካናነ ቢታን ደእያ ጋልሎታ ይድ፥ ሻፋ ማታን ማላልስያ ግታ ያርሾ በሲ ኬፅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS22_11","007_22_11","JOS","22","11","11","ሮቤላ፥ ጋድነ ምናሰ ኮቻፈ ባጋይ ዮርዳኖሰ ማታን፥ ጋልሎታን፥ ካናነ ቢታን ያርሾ በሲ ኬፅዳይሳ አትዳ እስራኤለ አሳይ ስእዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS22_12","007_22_12","JOS","22","12","12","እስራኤለ አሳይ ሄሳ ስእድ፥ ኤንታ ኦላናዉ ሴሎን ሺቅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS22_13","007_22_13","JOS","22","13","13","ሄሳፈ ስን እስራኤለ አሳይ፥ ካህንያ አላዛራ ናኣ ፕንሃሳ፥ ጋላዳን ደእያ ሮቤላ፥ ጋደነ ምናሰ ኮቻፈ ባጋታኮ የድዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS22_14","007_22_14","JOS","22","14","14","እስ እስ ኮቻይ ባ ሶ ሀላቃታፐ እስ እስ አሰ ዶርድ፥ ታሙ አስ ፕንሃሳራ የድዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS22_15","007_22_15","JOS","22","15","15","ኤንቲ ሮቤላ፥ ጋድነ ምናሰ ኮቻፈ ባጋይ ጋላዳ ብድ፥ ");
INSERT INTO gofe_vpl VALUES ("JS22_16","007_22_16","JOS","22","16","16","“ጎዳ አሳይ፥ ‘እስራኤለ ፆሳ ቦላ ደእያ ህንተ አማኑዋ አይስ ፓጭሴቲ? ህንተዉ ያርሾ በሲ ኬፅድ፥ ጎዳፐ ሃክደታ። እያ ቦላ አይስ ማካልደቲ? ");
INSERT INTO gofe_vpl VALUES ("JS22_17","007_22_17","JOS","22","17","17","ፐኦራን ኑ ኦꬅዳ ናጋራይ ግደኔ? ጎዳ አሳ ቦላ ቦሽ ዎꬍስ፤ ሀች ጋካናዉ ኑኒ ሄ ናጋራፐ ጌይቦኮ። ");
INSERT INTO gofe_vpl VALUES ("JS22_18","007_22_18","JOS","22","18","18","ጎዳ ቦላ ሀች ህንተ ዞኮ ዛርደታ። ሀች ህንተ እያ ቦላ ዞኮ ዛርኮ ዎንቶ እ ኩመꬃ እስራኤለ አሳ ሀንቃና። ");
INSERT INTO gofe_vpl VALUES ("JS22_19","007_22_19","JOS","22","19","19","ህንተ ደእያ ቢታይ ቱንዳባ ግድኮ፥ ጎዳ ዱንካነይ ደእያ ቢታ፥ ሃ ኑኮ ይድ፥ ኑ ላታ ሻከትተ። ሽን ጎዳ፥ ኑ ፆሳ ያርሾ በሳፈ ሀራ ያርሾ በሲ ኬፅድ ፆሳ ቦላ ዎይኮ ኑ ቦላ ማካሎፍተ። ");
INSERT INTO gofe_vpl VALUES ("JS22_20","007_22_20","JOS","22","20","20","ዛራ ናአይ አካን ድገትዳባ ኤክድ፥ ናጋራ ኦꬅዳ ግሾ፥ ኩመꬃ እስራኤለ አሳ ቦላ ጎዳ ሀንቆይ ዎꬍቤነዬ? እያ ናጋራ ጋሶን ሀይቅዳይ እያ ፃላላ ግደና’ ” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS22_21","007_22_21","JOS","22","21","21","ያትን ሮቤላ፥ ጋደነ ምናሰ ኮቻፈ ባጋይ ሀይሳዳ ያግድ ዛርዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS22_22","007_22_22","JOS","22","22","22","“ጎዳ ፃላል ፆሰ! ጎዳ ፃላል ፆሰ! ኑኒ ሀይሳ አይስ ኦꬅዳኮ እ ኤሬስ፤ ህንተካ ኤራና መላ ኑ ኮዮስ። ኑኒ ጎዳ ቦላ ማካልዳባነ ኪተቶና እፅዳባ ግድኮ፥ ሀች ኑና ፓፃ ዎꬆፍተ። ");
INSERT INTO gofe_vpl VALUES ("JS22_23","007_22_23","JOS","22","23","23","ኑ ጎዳስ ኪተቶና እፅድ፥ ፁሳ ያርሹዋ፥ ካꬃ ያርሹዋነ እስፈተꬃ ያርሹዋ ያርሻናዉ ያርሾ በሲ ኬፅዳባ ግድኮ፥ ጎዳይ ኑና ሀንቆ። ");
INSERT INTO gofe_vpl VALUES ("JS22_24","007_22_24","JOS","22","24","24","ኑ ሄሳ ቆፕድ ኬፅቦኮ። ኑኒ ያርሾ በሲ ኬፅዳይ፥ ዎንቶ ህንተ ናይት፥ ኑ ናይታኮ፥ ‘ህንተዉ ጎዳ፥ እስራኤለ ፆሳራ አይ ጋሄተꬅ ደኢ? ");
INSERT INTO gofe_vpl VALUES ("JS22_25","007_22_25","JOS","22","25","25","ጎዳይ ኑ ግዶንነ ሮቤላነ ጋዳ ኮቻ ግዶን ዮርዳኖሰ ሻፋ ዛዋ ዎꬅስ። ሄሳ ግሾ፥ ጎዳራ ህንተዉ ጋሄተꬅ ባዋ’ ጋንደሻ ግድ ያይዳ ግሾሳ። ቃስ ህንተ ኮቻይ ኑ ኮቻ ጎዳ ጎይኖ ድጎና አጎኮና” ያግድ ቆፕዳ። ");
INSERT INTO gofe_vpl VALUES ("JS22_26","007_22_26","JOS","22","26","26","“ኑ ያርሾ በሲ ኬፅዳይ ሄሳሳ። ፁሳ ዎይኮ ሀራ ያርሾ ያርሻናሳ ግደና። ");
INSERT INTO gofe_vpl VALUES ("JS22_27","007_22_27","JOS","22","27","27","ኑኒ ያርሾ በሲ ኬፅዳይ፥ ፁሳ፥ እስፈተꬃነ ሀራ ያርሹዋ ያርሽሸ ደእዳይሳስነ ጎዳ ዱንካንያ ስንꬃን ጎይንሸ ደእዳይሳስ፥ ኑ ግዶንነ ህንተ ግዶን ቃስ ካልያ የለታ ግዶን ሄስ ማርካ ግዳና መላሳ። ሄስ ህንተ ናይት ኑ ናይታኮ፥ ‘ህንተዉ ጎዳራ አይ ጋሄተꬅካ ባዋ’ ያጎና መላ ማዳና። ");
INSERT INTO gofe_vpl VALUES ("JS22_28","007_22_28","JOS","22","28","28","ኤንቲ ዎደፐ ኑኮ ዎይኮ ኑ ኮቻኮ ሄሳዳ ጊኮ፥ ኑ ናይት ዛሪድ፥ ‘ኑ አዋት ጎዳስ ኬፅዳ ያርሾ በሳ ሌምሱዋ ሀይሳ በእተ። ሄስ ህንተ ግዶንነ ኑ ግዶን ማርካ ግዳና መላሳፈ አትሽን፥ ፁሳ ዎይኮ ሀራ ያርሾ ያርሻናሳ ግደና’ ጋናዉ ዳንዳአና መላሳ። ");
INSERT INTO gofe_vpl VALUES ("JS22_29","007_22_29","JOS","22","29","29","ኑ ጎዳ ቦላ ማካላናይስ ኑፐ ሃኮ። ጎዳ ኑ ፆሳ ዱንካንያ ስንꬃን ደእያ ያርሾ በሳፈ ሀራ ፁሳ፥ ካꬃነ ሀራ ያርሾ በሲ ኬፅድ ፆሳ ጎይኖ አጎኮ” ያግድ ዛርዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS22_30","007_22_30","JOS","22","30","30","ካህነይ ፕንሃስነ እያራ ደእያ እስራኤለ ሀላቃት፥ ሮቤላ፥ ጋደነ ምናሰ ኮቻፈ ባጋይ ኦድዳይሳ ስእድ፥ ኡፋይትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS22_31","007_22_31","JOS","22","31","31","ካህንያ አላዛራ ናአይ ፕንሃስ፥ ሮቤላ፥ ጋደነ ምናሰ ኮቻታኮ፥ “ጎዳይ ኑራ ደኤይሳ ኑ ሀች ኤርዳ። ህንተ ጎዳ ቦላ ማካልቤከታ። ህንተ እስራኤለ አሳ ጎዳ ፕርዳፈ አሽደታ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JS22_32","007_22_32","JOS","22","32","32","ካህንያ አላዛራ ናአይ ፕንሃስነ እያራ ደእያ ሀላቃት ጋላዳን ደእያ ሮቤላነ ጋዳ ኮቻ ማታፐ ካናነን ደእያ እስራኤለ አሳኮ ስሚድ፥ ሀንዳባ ኤንታዉ ኦድዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS22_33","007_22_33","JOS","22","33","33","እስራኤለ አሳይ ኡፋይትድ፥ ፆሳ ጋላትዶሶና። ሄሳፈ ጉየ፥ ሮቤላነ ጋዳ አሳት ደእያ ቢታ ኦልድ ꬋይሳናዉ ኦደትቦኮና። ");
INSERT INTO gofe_vpl VALUES ("JS22_34","007_22_34","JOS","22","34","34","ሮቤላነ ጋዳ ኮቻይ፥ “ሀ ያርሾ በሳይ ጎዳ ፃላል ፆሳ ግደይሳስ ኑስ ማርካ” ያግድ፥ ሄ ያርሾ በሳ “ማርካ” ግድ ሱንꬅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS23_1","007_23_1","JOS","23","1","1","ዳሮ ዎደ ጋካናዉ ጎዳይ እስራኤለ አሳ ኤንታ ዩሹዋን ደእያ ሞርከታፐ ሸምፕስስ። ሄ ዎደ እያሱይ ጭምን፥ ላይꬅ ሱገትስ። ");
INSERT INTO gofe_vpl VALUES ("JS23_2","007_23_2","JOS","23","2","2","እያሱይ፥ እስራኤለ አሳ ኡባ፥ ጭማታ፥ ሀላቃታ፥ ዳይናታነ ቶራ ሞጮናታ እስፈ ፄግድ፥ “ታኒ ሀእ ዳሮ ጭማስ። ");
INSERT INTO gofe_vpl VALUES ("JS23_3","007_23_3","JOS","23","3","3","ጎዳይ፥ ህንተ ፆሳይ ሀ ቢታን ደእያ ካዎተꬃታ ኦል ፆናና መላ ዋትድ ህንተና ማድዳኮ በእደታ። ");
INSERT INTO gofe_vpl VALUES ("JS23_4","007_23_4","JOS","23","4","4","ዶሎሀን ዮርዳኖሰ ሻፋ፥ ዉሎሀን መደትራነ አባ ጋካናዉ ደእያ ኦይከትዳ ቢታነ ኦይከቶና ቢታ ኡባ ህንተ ኮቻስ ሻካ እማስ። ");
INSERT INTO gofe_vpl VALUES ("JS23_5","007_23_5","JOS","23","5","5","ጎዳይ፥ ህንተ ፆሳይ ኤንታ ህንተ ስንꬃፈ ጎድድ ከሳና። ጎዳይ፥ ህንተ ፆሳይ ህንተዉ ጫቅዳይሳዳ ህንተ ኤንታ ቢታ ላታና። ");
INSERT INTO gofe_vpl VALUES ("JS23_6","007_23_6","JOS","23","6","6","“ሙሰ ህገ ማፃፋን ፃፈትዳ ኡባ ምንድ ናግተነ ፖልተ፤ እያፐ ኡሻች ዎይኮ ሀድርስ ጎፕተ። ");
INSERT INTO gofe_vpl VALUES ("JS23_7","007_23_7","JOS","23","7","7","ህንተ ግዶን አትዳ ደርያራ ዋላከቶፍተ። ኤንታ ፆሳታ ሱንꬃ ፄጎፕተ ዎይኮ ኤንታ ሱንꬃን ጫቆፍተ። ኤንታዉ ኦꬆፍተ ዎይኮ ኤንታዉ ጎይኖፍተ። ");
INSERT INTO gofe_vpl VALUES ("JS23_8","007_23_8","JOS","23","8","8","ሽን ሀች ጋካናዉ ህንተ ኦꬅዳይሳዳ ጎዳ ህንተ ፆሳስ አማነትተ። ");
INSERT INTO gofe_vpl VALUES ("JS23_9","007_23_9","JOS","23","9","9","“ጎዳይ፥ ግታነ ምኖ ካዎተꬃታ ህንተ ስንꬃፈ ጎድድ ከስስ። ህንተራ ሀች ጋካናዉ ኦንካ ኤቀታናዉ ዳንዳእቤና። ");
INSERT INTO gofe_vpl VALUES ("JS23_10","007_23_10","JOS","23","10","10","ጎዳይ፥ ህንተ ፆሳይ ህንተዉ ጫቅዳይሳዳ፥ እ ህንተዉ ኦለትያ ግሾ፥ ህንተፈ እስ አስ ሙኩሉ አሳ የደꬃና። ");
INSERT INTO gofe_vpl VALUES ("JS23_11","007_23_11","JOS","23","11","11","ጎዳ፥ ህንተ ፆሳ ኡባ ዎደ ሲቅተ። ");
INSERT INTO gofe_vpl VALUES ("JS23_12","007_23_12","JOS","23","12","12","ሽን ህንተ ጉየ ስሚድ፥ ህንተ ግዶን አትዳ ደርያራ ዋላከትኮ፥ ህንተ ኤንታ ማጫሳ፥ ቃስ ኤንቲ ህንተ ማጫሳ ኤክድ ኤንታራ ቃሸትኮ፥ ");
INSERT INTO gofe_vpl VALUES ("JS23_13","007_23_13","JOS","23","13","13","ጎዳይ፥ ህንተ ፆሳይ ሄ ደርያ ህንተ ስንꬃፈ ጎድድ ከሶናይሳ ኤርተ። ጎዳይ፥ ህንተ ፆሳይ ህንተዉ እምዳ ሀ ሎኦ ቢታፈ ህንተ ꬋያና ጋካናዉ፥ ኤንቲ ህንተዉ ፅሄነ ግተ ግዳና። ኤንቲ ህንተ ዞኩዋስ ልሶ፥ ህንተ አይፍያስ አጉንꬁ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("JS23_14","007_23_14","JOS","23","14","14","“ሀእ ታ ሀይቃናዉ ማታስ። ጎዳይ፥ ህንተ ፆሳይ ህንተዉ እማና ግድ ጫቅዳ ሎኦባ ኡባፈ እሶይካ አትቦናይሳ ህንተ ኡባይ፥ ህንተ ዎዛናንነ ሸምፑዋን ኤሬታ። እ ህንተዉ እማና ግድ ጫቅዳባፐ እሶይካ አቶና ኡባይ ፖለትስ። ");
INSERT INTO gofe_vpl VALUES ("JS23_15","007_23_15","JOS","23","15","15","ጎዳይ፥ ህንተ ፆሳይ ህንተራ ጫቅዳ ጫቁዋ ህንተ መንꬅድ፥ ሀራ ፆሳታስ ኦꬅኮነ ጎይንኮ፥ ጎዳ ሀንቆይ ህንተ ቦላ ኤፃና። ");
INSERT INTO gofe_vpl VALUES ("JS23_16","007_23_16","JOS","23","16","16","ጎዳይ፥ ህንተ ፆሳይ ህንተዉ እማና ግድ ጫቅዳ ሎኦባ ኡባ አሾና ፖልዳይሳዳ፥ እ ህንተዉ እምዳ ሀ ሎኦ ቢታፈ ህንተና ꬋይሳና ጋካናዉ ኢታ ኡባ ህንተ ቦላ ኤሀና። እ ህንተዉ እምዳ ሎኦ ቢታፈ ኤለስድ ህንተ ꬋያና።” ");
INSERT INTO gofe_vpl VALUES ("JS24_1","007_24_1","JOS","24","1","1","እያሱይ እስራኤለ አሳ ኡባ ሴከማን ፄግስ። ጭማታ፥ ሀላቃታ፥ ዳይናታነ ኦላ ሞጮናታ ፄግን፥ ኤንቲ ፆሳ ስንꬃን ሺቅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS24_2","007_24_2","JOS","24","2","2","እያሱይ አሳኮ፥ “ጎዳይ እስራኤለ ፆሳይ ሀይሳዳ ያጌስ፤ ‘በን ህንተ አዋት ኤፍራፂሳ ሻፋፐ ሄፍንꬃን፥ ሀራ ፆሳታስ ጎይንሸ ደእዶሶና። ኤንታፈ እሶይ አብራሃመነ ናኮራ አዋ ታራ። ");
INSERT INTO gofe_vpl VALUES ("JS24_3","007_24_3","JOS","24","3","3","ሽን ህንተ አዋ አብራሃመ፥ ኤፍራፂሳ ሻፋፐ ሄፍንꬃን ደእያ ቢታፈ ፄጋዳ፥ ካናነ ቢታን ካለꬃስ። እያ ኮቻ ዳርሳስ፤ ይሳቃካ እያዉ እማስ። ");
INSERT INTO gofe_vpl VALUES ("JS24_4","007_24_4","JOS","24","4","4","ይሳቃስ ያይቆባነ ኤሳዌ እማስ። ኤሳዌ፥ ደረይ ዳርያ ሳይረ ቢታ ላትሳስ፥ ሽን ያይቆብነ እያ ናይት ግብፀ ብዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS24_5","007_24_5","JOS","24","5","5","“ ‘ጉየፐ ሙሳነ አሮና ኪታዳ ግብፀ ቢታ ጋዶን ሾጫስ፤ ዉርሰꬃን ህንተና ከሳስ። ");
INSERT INTO gofe_vpl VALUES ("JS24_6","007_24_6","JOS","24","6","6","ህንተ አዋታ ግብፀፈ ከስዳ ዎደ ዞኦ አባኮ ብዶሶና። ግብፀት ፓራታንነ ፓራ ጋረታን ህንተ አዋታ ጉየ ዛራናዉ የደꬅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS24_7","007_24_7","JOS","24","7","7","ኤንቲ ታኮ ዋስዳ ዎደ ኤንታ ግዶንነ ግብፀታ ግዶን ꬉማ የጋስ። ያታዳ፥ አባይ ኤንታ ቦላ ስማናዳነ ኤንታ ምታናዳ ኦꬃስ። ታኒ ግብፀታ ቦላ ኦꬅዳባ ህንተ ህንተ አይፈን በእደታ። ህንተ መላ ቢታን ዳሮ ዎደ ደእደታ። ");
INSERT INTO gofe_vpl VALUES ("JS24_8","007_24_8","JOS","24","8","8","ሄሳፈ ጉየ፥ ዮርዳኖሰ ሻፋፐ ዶሎሀ ባጋን ደእያ አሞረታ ቢታ ህንተና ኤሀስ። ኤንቲ ህንተና ኦልዶሶና፥ ሽን ታ ህንተዉ ፆኖ እማስ። ታ ኤንታ ꬋይስን፥ ህንተ ኤንታ ቢታ ላትደታ። ");
INSERT INTO gofe_vpl VALUES ("JS24_9","007_24_9","JOS","24","9","9","ሄሳፈ ጉየ፥ ሞአበ ቢታ ካዎይ፥ ስፎራ ናአይ ባላቅ፥ ደንድድ፥ እስራኤለታራ ኦለትስ። እ ህንተና ባዳና መላ ብኦራ ናኣ፥ ባላማ ፄግስ። ");
INSERT INTO gofe_vpl VALUES ("JS24_10","007_24_10","JOS","24","10","10","ሽን ታ ባላማ ስአብከ፤ እ ህንተና አንጃና መላ ኦꬃዳ፥ ህንተና ባላቃ ኩሽያፐ አሻስ። ");
INSERT INTO gofe_vpl VALUES ("JS24_11","007_24_11","JOS","24","11","11","ህንተ ዮርዳኖሰ ሻፋ ፕንድ፥ እያርኮ ይደታ። እያርኮ አሳይ፥ አሞረት፥ ፓርዘት፥ ካናነት፥ ህተት፥ ገርገሰት፥ ህወትነ ያቡሰት ህንተራ ኦለታናዉ ደንድዶሶና፥ ሽን ታ ህንተና ፆንሳስ። ");
INSERT INTO gofe_vpl VALUES ("JS24_12","007_24_12","JOS","24","12","12","ዮርዳኖሰ ሻፋፐ ዶሎሀ ባጋን ደእያ ናምኡ አሞረ ካዎታ ቦላ ኦꬅዳይሳዳ፥ ካዠ ኪታዳ ኤንታና ህንተ ስንꬃፈ ጎዳ ከሳስ። ሄስ ሀንዳይ፥ ህንተ ማሻና ዎይኮ ህንተ ዶንግያና ግደና። ");
INSERT INTO gofe_vpl VALUES ("JS24_13","007_24_13","JOS","24","13","13","ህንተ ቄፅ ከስቦና ቢታነ ህንተ ኬፅቦና ካታማታ ታኒ ህንተዉ እምን ደኤታ። ሀእ ህንተ ቶክቦና ዎይነ አይፍያነ ሻማሆ አይፍያ ሜታ’ ” ያጌስ። ");
INSERT INTO gofe_vpl VALUES ("JS24_14","007_24_14","JOS","24","14","14","ቃስካ እያሱይ ካልድ፥ “ጎዳ ቦንችተ፤ ፖሎ አማነተꬃንነ ሱረ ዎዛናን እያዉ ኪተትተ። ህንተ ማይዛት ኤፍራፂሳ ሻፋፐ ሄፍንꬃንነ ግብፀን ጎይንዳ ኤቃታ አግድ ጎዳ ጎይንተ። ");
INSERT INTO gofe_vpl VALUES ("JS24_15","007_24_15","JOS","24","15","15","ህንተ ጎዳ ጎይናናዉ ኮዮና እፅኮ፥ ህንተ አዋት ኤፍራፂሳ ሻፋፐ ሄፍንꬃን ደእሸ ጎይንዳ ኤቃታ ግድን፥ ዎይኮ ሀእ ህንተ ደእያ አሞረታ ኤቃታ ግድን፥ ህንተ ጎይናና ፆሳ ሀች ዶርተ። ሽን ታኒ፥ ታ ሶ አሳራ ኑ ጎዳ ጎይናና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JS24_16","007_24_16","JOS","24","16","16","አሳይ ዛሪድ፥ “ጎዳ አግድ፥ ሀራ ኤቃ ፆሳታ ጎይናናይስ ኑፐ ሃኮ። ");
INSERT INTO gofe_vpl VALUES ("JS24_17","007_24_17","JOS","24","17","17","ኑ ጎዳ ፆሳይ ኑናነ ኑ አዋታ ግብፀ አይለተꬃፈ ከስስ፤ እ ኦꬅዳ ግታ ማላታታ በእዳ። ኑ ካንꬅድ አꬍዳ ቢታ ኡባን ጎዳይ ኑና ናግስ። ");
INSERT INTO gofe_vpl VALUES ("JS24_18","007_24_18","JOS","24","18","18","ጎዳይ አሞረታነ ሄ ቢታን ደእያ ሀራ ካዎተꬃታ ኑ ስንꬃፈ ጎድድ ከስስ። ሄሳ ግሾ፥ እ ኑ ፆሳ ግድያ ግሾ ኑ እያ ጎይናና” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS24_19","007_24_19","JOS","24","19","19","እያሱይ ዛሪድ፥ “ጎዳይ ጌሽነ ቃናትያ ፆስ ግድያ ግሾ፥ ህንተ እያ ጎይናናዉ ዳንዳኤከታ። እ ህንተ ናቁዋ ዎይኮ ህንተ ናጋራ አቶ ጌና። ");
INSERT INTO gofe_vpl VALUES ("JS24_20","007_24_20","JOS","24","20","20","ህንተ ጎዳስ ዞኮ ዛሪድ፥ ኤቃ ፆሳታ ጎይንኮ፥ እ ህንተዉ ካሰ ሎኦ ግድኮካ ስሚድ ህንተና ቆሀናነ ꬋይሳና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JS24_21","007_24_21","JOS","24","21","21","አሳይ ዛሪድ፥ “ኑ ሀራ ኤቃ ፆሳታ ጎይኖኮ፤ ኑኒ ጎዳ፥ እያ ፃላላ ጎይናና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JS24_22","007_24_22","JOS","24","22","22","እያሱይ፥ “ህንተ ጎዳ ጎይናና ግዳይሳስ ህንተ፥ ህንተ ሁጰን ማርካ” ያግስ። ኤንትካ፥ “ኤ ኑኒ ማርካ” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS24_23","007_24_23","JOS","24","23","23","እያሱይ ዛሪድ፥ “ህንተ ግዶን ደእያ ኤቃ ፆሳታ ድግተ፤ ህንተ ዎዛና ጎዳኮ፥ እስራኤለ ፆሳኮ ዛርተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JS24_24","007_24_24","JOS","24","24","24","ኤንትካ፥ “ኑኒ ጎዳ፥ ኑ ፆሳ ጎይናና፤ እያ ኪታ ናጋና” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS24_25","007_24_25","JOS","24","25","25","ሄ ጋላስ እያሱይ፥ ሴከማን አሳይ ፆሳራ ጫቃና መላ ኦꬅስ። ኤንቲ ካላና ህግያ ኤንታዉ ጊግስድ፥ ");
INSERT INTO gofe_vpl VALUES ("JS24_26","007_24_26","JOS","24","26","26","ህገ ማፃፋን ፃፍስ። ሄሳፈ ጉየ፥ እስ ግታ ሹች ኤክድ፥ ጎዳ ዱንካንያ ማታን ደእያ ዎላ ጋርሳን ኤስስ። ");
INSERT INTO gofe_vpl VALUES ("JS24_27","007_24_27","JOS","24","27","27","እያሱይ አሳኮ፥ “ሀ ሹቻ በእተ፤ እ ኑ ቦላ ማርካ። ጎዳይ ኑስ ኦድዳባ ኡባ ሀ ሹቻይ ስእስ። ህንተ ፆሳ ቦላ ማካልኮ፥ ሀ ሹቻይ ህንተ ቦላ ማርካ ግዳና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JS24_28","007_24_28","JOS","24","28","28","ያትድ፥ እያሱይ አሳ ኡባ ሞይዝስ። አሳ ኡባይ ባንታ ላታ ቢታ ስሚድ ብዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS24_29","007_24_29","JOS","24","29","29","ጎዳ አይለይ፥ ናወ ናኣ እያሱይ ፄታነ ታሙ ላይꬃን ሀይቅስ። ");
INSERT INTO gofe_vpl VALUES ("JS24_30","007_24_30","JOS","24","30","30","አሳይ እያ ጋኣሳ ዙማፐ ፑደሀ ባጋን፥ ደረይ ዳርያ ኤፍሬማን ደእያ እያ ላታ ቢታን፥ ትምናት-ሳራን እያ ሞግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS24_31","007_24_31","JOS","24","31","31","እያሱይ ፓፃ ደእዳ ዎደ ኡባን እስራኤለ አሳይ ጎዳ ጎይንዶሶና። እያፐ ጉየ፥ ፆሳይ እስራኤለ አሳስ ኦꬅዳ ኦሶ ኡባ ባንታ አይፈን በእዳ ጭማታ ዎደ ኡባን ጎዳ ጎይንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS24_32","007_24_32","JOS","24","32","32","እስራኤለ አሳይ ግብፀ ቢታፈ ኤክ ከይዳ፥ ዮሰፋ መቀꬃ ሴከማን ሞግዶሶና። ሄ በሳ ያይቆብ ሴከማ አዋ ሀሞራ ናይታፐ እስ ፄቱ ብራ ሳንትመን ሻምስ። ሄ ቢታ ጉየፐ ዮሰፋ ኮቻይ ላትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JS24_33","007_24_33","JOS","24","33","33","አሮና ናአይ አላዛር ሀይቅድ፥ እያ ናኣ ፕንሃሳስ እመትዳ ደረይ ዳርያ ኤፍሬማ ቢታን ደእያ ግብአን ሞገትስ። ");
INSERT INTO gofe_vpl VALUES ("JG1_1","008_1_1","JDG","1","1","1","እያሱይ ሀይቅዳፐ ጉየ እስራኤለ አሳይ፥ “ካናነ ቢታ ኦላናዉ ኑ ኮቻታፐ ኮይሮትድ ከያናይ ኦኔ?” ያግድ ጎዳ ኦይችዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG1_2","008_1_2","JDG","1","2","2","ጎዳይ፥ “ይሁዳ ኮቻይ ኮይሮትድ ከዮ። ታኒ ቢታ እያ ኩሸን አꬃዳ እማስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG1_3","008_1_3","JDG","1","3","3","ይሁዳ አሳይ ባንታ እሻታ፥ ስሞና ኮቻታ፥ “ኑኒ ካናነታ ኦላና መላ ኑና ግሾን ጋክዳ ቢታ ኑራ የꬍተ። ኑካ ህንተና ግሾን ጋክዳ ቢታ ህንተራ ባና” ያግስ። ስሞና ኮቻይ ይሁዳ ኮቻራ እስፈ ኦላናዉ ብስ። ");
INSERT INTO gofe_vpl VALUES ("JG1_4","008_1_4","JDG","1","4","4","ጎዳይ ካናነታነ ፓርዘታ ኤንታ ኩሸን አꬅድ እምን፥ ቤዘቃ ካታማን ታሙ ሙኩሉ አሳ ዎꬍዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG1_5","008_1_5","JDG","1","5","5","ቤዘቃ ካታማን ካዋ አዶን-ቤዘቃ ደምድ፥ እያራ ኦለትድ ካናነታነ ፓርዘታ ፆንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG1_6","008_1_6","JDG","1","6","6","አዶን-ቤዘቅ ባቃትያ ዎደ ኤንቲ የደꬅ ኦይክድ፥ እያ ኩሽያነ እያ ቶሁዋ ዎጋ ብራታ ቃንፅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG1_7","008_1_7","JDG","1","7","7","አዶን-ቤዘቅ፥ “ኩሸነ ቶሆ ዎጋ ብራታ ታኒ ቃንፅዳ ላፑን ታሙ ካዎት ታ ጋይታፐ ዎꬍዳ ቲፍያ ማፅድ ሞሶና። ታኒ ኤንታ ቦላ ኦꬅዳይሳዳ ፆሳይ ታ ቦላ ኦꬅስ” ያግስ። እያ የሩሳላመ ኤህን ያን ሀይቅስ። ");
INSERT INTO gofe_vpl VALUES ("JG1_8","008_1_8","JDG","1","8","8","ይሁዳ አሳይ የሩሳላመ ኦል ኦይክድ አሳ ማሻን ዎꬍድ፥ ካታማ ታማን ፁግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG1_9","008_1_9","JDG","1","9","9","ሄሳፈ ጉየ፥ ይሁዳ አሳይ ደረይ ዳርያ ቢታን፥ ነገባ መላ ቢታንነ ጋꬋን ደእያ ካናነታ ኦላናዉ ብዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG1_10","008_1_10","JDG","1","10","10","ካሰ ቅርያት-አርባ ጌተትያ ከብሮና ካታማን ደእያ ካናነታ ኦልድ ሰሳያ፥ አክማናነ ታልማያ ጌተትያ ኮቻታ ፆንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG1_11","008_1_11","JDG","1","11","11","ያፐ ደንድድ ይሁዳ አሳይ ደብራ ካታማን ደእያ አሳ ኦላናዉ ብዶሶና። ደብራ ካታማይ ካሰ ቅርያት-ሰፈራ ጌተቴስ። ");
INSERT INTO gofe_vpl VALUES ("JG1_12","008_1_12","JDG","1","12","12","ካለብ፥ “ቅርያት-ሰፈራ ኦልድ ኦይክያ ኡራስ ታኒ ታ ናእዉ አክሶ እማና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG1_13","008_1_13","JDG","1","13","13","ካለባ ካሎ እሻ ቃናዛ ናአይ ጎቶንያል ሄ ካታማ ኦልድ ኦይክን፥ ካለብ ባ ናእዉ አክሶ እያዉ እሚስ። ");
INSERT INTO gofe_vpl VALUES ("JG1_14","008_1_14","JDG","1","14","14","አክሳ ጎቶንያላ ገልያ ዎደ፥ እ አዋይ እዉ ጋደ እማናዳ ዎሳና መላ ጎቶንያል እዮ ዞርስ። እያ ባቁሎ ቦላፈ ዎꬍሽን ካለብ ታ ናተ፥ “አይ ኮያይ?” ያግድ ኦይችስ። ");
INSERT INTO gofe_vpl VALUES ("JG1_15","008_1_15","JDG","1","15","15","እያ፥ “ታዉ ዎይቶ እማ። ኔኒ ካሰ ታዉ እምዳ ቢታይ ቃኤ ግድዳ ግሾ ሃꬃ ፑልቶታ ታዉ እማርክ” ያጋሱ። ካለብ ቆሞ ፑልቱዋነ ጋርሳ ፑልቱዋ እዉ እሚስ። ");
INSERT INTO gofe_vpl VALUES ("JG1_16","008_1_16","JDG","1","16","16","ሙሰይ ቦሉዋ ቀናት ኮቻት ይሁዳ አሳራ ዛምባ ካታማ ጌተትያ እያርኮ ካታማፐ ደንድድ አራዳ ካታማፐ ዱገሀ ባጋራ፥ ነገባን ደእያ ይሁዳ መላ ቢታ ብድ ያን ደእያ አሳ ግዶን ኡትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG1_17","008_1_17","JDG","1","17","17","ይሁዳ አሳይ ስሞና አሳራ እስፈ ብድ፥ ፃፋታ ካታማን ደእያ ካናነታ ፆንድ ካታማ ኩመꬅ ꬋይስድ፥ ሄ ካታማ ሆርማ ግድ ሱንꬅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG1_18","008_1_18","JDG","1","18","18","ይሁዳ አሳይ ጉጅድ ጋዛ፥ አስቃሎና፥ ኤቅሮናነ ኤንታ ዩሹዋን ደእያ ጉታታ ኦይክዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG1_19","008_1_19","JDG","1","19","19","ጎዳይ ይሁዳ አሳራ ደእያ ግሾ፥ ደረይ ዳርያ ቢታ ላትዶሶና። ሽን ደምባ ቢታን ደእያ አሳታስ ብራታፐ ኦሰትዳ ኦላ ፓራ ጋረት ደእያ ግሾ፥ ይሁዳ አሳይ ኤንታ ጎድድ ከሳናዉ ዳንዳእቦኮና። ");
INSERT INTO gofe_vpl VALUES ("JG1_20","008_1_20","JDG","1","20","20","ሙሰይ ኪትዳይሳዳ፥ ከብሮና ካታማ ካለባስ እምን ካለብ አናቀ ኮቸ ግድዳ ሄꬑ ኮቻታ ጎድድ ከስስ። ");
INSERT INTO gofe_vpl VALUES ("JG1_21","008_1_21","JDG","1","21","21","ሽን ብንያመ ኮቻት የሩሳላመን ደእያ ያቡሰታ ጎድድ ከስቦኮና። ሄ ዎደፐ ዶምን ያቡሰት ብንያመ ኮቻታራ እስፈ የሩሳላመን ደእዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG1_22","008_1_22","JDG","1","22","22","ቃስ ዮሰፋ ኮቻት ቤተለ ካታማ ኦልዶሶና፤ ፆሳይ ኤንታራ ደኤስ። ");
INSERT INTO gofe_vpl VALUES ("JG1_23","008_1_23","JDG","1","23","23","ዮሰፋ ኮቻት ካሰ ሎዛ ጌተትያ ቤተለ ካታማ ዎችያ አሳታ ኪትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG1_24","008_1_24","JDG","1","24","24","ኤንቲ ካታማፐ ከይያ እስ አድያ ደምድ፥ “ካታማ ግዶ ዋንድ ገላናዉ ዳንዳኤትያኮ ኑና በሳ፤ ኑኒ ነዉ ኬሀና” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG1_25","008_1_25","JDG","1","25","25","እ ኤንታ በስን ካታማን ደእያ አሳ ማሻን ቡꬅዶሶና፤ ሽን ሄ አድያነ እያ ሶ አሳ ኡባ አሽዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG1_26","008_1_26","JDG","1","26","26","ጉይፐ ሄ አደይ ህተታ ቢታ ብድ፥ ያን ካታማ ኬፅድ ሎዛ ግድ ሱንꬅስ። ሀች ጋካናዉ ሄ ካታማይ ሄ ሱንꬃን ፄገቴስ። ");
INSERT INTO gofe_vpl VALUES ("JG1_27","008_1_27","JDG","1","27","27","ምናሰ ኮቻት ቤት-ሳና፥ ታናካ፥ ዶራ፥ ይብላማ ማግዶነ ኤንታ ዩሹዋን ደእያ ጉታታን ደእያ አሳታ ጎድድ ከስቦኮና። ያትን፥ ካናነት ያን ዱሱ ኦይክዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG1_28","008_1_28","JDG","1","28","28","እስራኤለ አሳይ ምንዳ ዎደ ካናነታ ባንታዉ ዎልቃን ኦስስዶሶና፤ ሽን ኤንታ ኩመꬅ ቢታፈ ከስድ ጎድቦኮና። ");
INSERT INTO gofe_vpl VALUES ("JG1_29","008_1_29","JDG","1","29","29","ኤፍሬማ ኮቻትካ ገዘራ ካታማን ደእያ ካናነታ ጎድድ ከስቦኮና፤ ያትን፥ ካናነት ያን ኤንታራ ደእዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG1_30","008_1_30","JDG","1","30","30","ዛብሎና ኮቻት ቅትሮናንነ ናህላላን ደእያ አሳታ ጎድድ ከስቦኮና፤ ያትን፥ ካናነት ያን ኤንታራ እስፈ ደእዶሶና። ሽን ዛብሎና ኮቻት ኤንታ ባንታዉ ዎልቃን ኦስስዳሶና። ");
INSERT INTO gofe_vpl VALUES ("JG1_31","008_1_31","JDG","1","31","31","አሴራ ኮቻት አኮን፥ ስዶናን፥ አህላባን፥ አክዚባን፥ ሄልባን፥ አፌቃንነ ረሆባን ደእያ አሳታ ጎድ ከስቦኮና። ");
INSERT INTO gofe_vpl VALUES ("JG1_32","008_1_32","JDG","1","32","32","ካናነት ከዮና አትዳ ግሾ አሴራ ኮቻት ኤንታራ ያን እስፈ ደእዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG1_33","008_1_33","JDG","1","33","33","ንፍታለመ ኮቻት ቤት-ሳሜሳንነ ቤት-አናታን ደእያ አሳታ ጎድ ከስቦኮና፤ ሽን ካናነታራ ያን እስፈ ደእዶሶና። ቤት-ሳሜሳነ ቤት-አናታ አሳታ ባንታዉ ዎልቃን ኦስስዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG1_34","008_1_34","JDG","1","34","34","አሞረት ዳነ ኮቻታ ደረይ ዳርያ ቢታ የደꬅዶሶና፤ ኤንቲ ደምባ ቢታ ዎꬎና መላ ተቅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG1_35","008_1_35","JDG","1","35","35","አሞረት ሄሬሳ ደርያን፥ ኤሎናንነ ሻአልብማን ዱሱ ኦይክዶሶና፤ ሽን ዮሰፋ ኮቻት ምን ምን ብድ ባንታዉ ዎልቃን ኦስስዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG1_36","008_1_36","JDG","1","36","36","አሞረታ ቢታ ዛዋይ ሰላአ ማታን ደእያ አክራብማ ፑደꬃ ከዬስ። ");
INSERT INTO gofe_vpl VALUES ("JG2_1","008_2_1","JDG","2","1","1","ጎዳ ኪታንቾይ ጋልጋላፐ ቦክማ ብድ፥ እስራኤለ አሳኮ ሀይሳዳ ያግስ፤ “ታኒ ህንተና ግብፀፈ ከሳዳ በን ህንተ ማይዛታስ እማና ጋዳ ጫቅዳ ቢታ ህንተና ገልሳዳ፥ ‘ታኒ ህንተራ ጫቅዳ ጫቁዋ መንꬅከ፤ ");
INSERT INTO gofe_vpl VALUES ("JG2_2","008_2_2","JDG","2","2","2","ህንተ ሀ ቢታን ደእያ አሳታራ ጫቆፍተ፤ ኤንታ ያርሾ በሳ ላልተ’ ያጋስ። ሽን ህንተ ታዉ ኪተትበከታ፤ አይስ ሄሳ ሀንደቲ? ");
INSERT INTO gofe_vpl VALUES ("JG2_3","008_2_3","JDG","2","3","3","ሄሳ ግሾ፥ ታኒ ኤንታ ህንተ ስንꬃፈ ጎድከ፤ ኤንቲ ህንተዉ ሞርከ ግዳና፤ ኤንታ ፆሳት ህንተዉ ፅሄ ግዳና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG2_4","008_2_4","JDG","2","4","4","ጎዳ ኪታንቾይ እስራኤለ አሳስ ሄሳ ኦድዳ ዎደ አሳይ ባንታ ቃላ ꬎቁ ኦꬅድ ዬክዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG2_5","008_2_5","JDG","2","5","5","ያትድ ሄ በሳ ቦክማ ያግድ ሱንꬅድ ያን ጎዳስ ያርሽዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG2_6","008_2_6","JDG","2","6","6","እያሱይ እስራኤለ አሳ የድዳፐ ጉየ፥ አሳይ እሶይ እሶይ ባና ጋክዳ ላታ ቢታ ኤካናዉ ብስ። ");
INSERT INTO gofe_vpl VALUES ("JG2_7","008_2_7","JDG","2","7","7","እያሱይ ፓፃ ደእያ ላይꬃንነ ጎዳይ እስራኤለ አሳስ ኦꬅዳ ግታ ኦሶ ኡባ በእዳ ጭማት ደእያ ዎደ አሳይ ጎዳስ ኪተትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG2_8","008_2_8","JDG","2","8","8","ጎዳ አይለይ፥ ናወ ናአይ እያሱይ ላይꬃይ ፄታነ ታማ ግድን ሀይቅስ። ");
INSERT INTO gofe_vpl VALUES ("JG2_9","008_2_9","JDG","2","9","9","ኤንቲ እያ ጋኣሳ ዙማፐ ፑደሀ ባጋን፥ ኤፍሬማ ገዘ ቢታን፥ ትምናት-ሳራሀ ጌተትያ በሳን እያ ላታ ቢታን ሞግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG2_10","008_2_10","JDG","2","10","10","ሄ የለተꬃ ኡባይ ሀይቅድ ባንታ ማይዛታን ጋሄትዶሶና። ሄሳፈ ጉየ ጎዳ ዎይኮ ጎዳይ እስራኤለ አሳስ ኦꬅዳባ ኤሮና ሀራ የለተꬅ ደንድስ። ");
INSERT INTO gofe_vpl VALUES ("JG2_11","008_2_11","JDG","2","11","11","ሄሳፈ ጉየ፥ እስራኤለ አሳይ ጎዳ ስንꬃን ኢታባ ኦꬅዶሶና፤ ባኣለ ኤቃ ምስለታ ጎይንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG2_12","008_2_12","JDG","2","12","12","ግብፀ ቢታፈ ኤንታ ከስዳ ጎዳ፥ ባንታ ማይዛታ ፆሳ አግዶሶና። ኤንታ ዩሹዋን ደእያ አሳ ኤቃታኮ ስሚድ፥ ኤንታዉ ጎይንዶሶና፤ ሄሳን ጎዳ ሀንቀꬅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG2_13","008_2_13","JDG","2","13","13","ቃስ ጎዳ አግድ፥ ባኣለነ አስታሮተ ኤቃ ጎይንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG2_14","008_2_14","JDG","2","14","14","ያትን፥ ጎዳ ሀንቆይ እስራኤለ አሳ ቦላ ኤፅስ፤ ቦንቀይሳት ኤንታ ቦንቃና መላ ኦꬅስ። ኤንታ ዩሹዋን ደእያ ሞርከታስ አꬅድ እሚስ። ያትን፥ ኤንቲ ባንታ ሞርከታራ ኤቀታናዉ ዳንዳእቦኮና። ");
INSERT INTO gofe_vpl VALUES ("JG2_15","008_2_15","JDG","2","15","15","ኤንቲ ኦለታናዉ ከይያ ዎደ ኡባን፥ ጎዳይ ካሰ ኤንታዉ ኦድዳይሳዳነ ጫቅዳይሳዳ ኤንቲ ፆነታና መላ እ ኤንታ ቦላ ደንድስ። ያትን፥ ኤንቲ ዳሮ ኡንኤትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG2_16","008_2_16","JDG","2","16","16","ያትን፥ ጎዳይ አይሰይሳታ ኤንታዉ ደንꬅን፥ ኤንቲ እስራኤለ አሳ ቦንቀይሳታ ኩሸፐ አሽዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG2_17","008_2_17","JDG","2","17","17","ግዶሽን እስራኤለ አሳይ ሃረይሳታስ ኪተትቦኮና፤ ጎዳስ አማነቶና እፅድ ሀራ ፆሳታ ጎይንዶሶና። ኤንታ አዋት ጎዳስ ኪተትድ ሄመትዳ ኦግያ አግድ ሀራ ሶ ስምዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG2_18","008_2_18","JDG","2","18","18","ጎዳይ ኤንታዉ አይሰይሳታ ደንꬅዳ ዎደ ኡባን እ አይሰይሳታራ እስፈ ግድድ ሄ አይሰይስ ፓፃ ደእያ ላይꬃ ኡባን ኤንታ ሞርከታ ኩሸፐ አሽስ። ኤንቲ ኡንአንነ መቶን ግድድ ጎዳኮ ዋስያ ዎደ ኡባን ጎዳይ ኤንታዉ ቃቴስ። ");
INSERT INTO gofe_vpl VALUES ("JG2_19","008_2_19","JDG","2","19","19","ሽን አይሰይስ ሀይቅዳፐ ጉየ፥ አሳይ ጉየ ስሚድ፥ ካሰ ኤንታ አዋት ኦꬅዳ ኢታፐ አꬍዳ ኢታ ኦꬅዶሶና። ኤንቲ ሀራ ፆሳታኮ ስሚድ፥ ኤንታዉ ጎይንዶሶና። ባንታ ኢታ ኦሱዋነ ጌላ ኦግያ አጎና እፅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG2_20","008_2_20","JDG","2","20","20","ጎዳይ እስራኤለ አሳ ቦላ ይሎ ኤፅድ፥ “ሀ አሳይ ታኒ ኤንታ ማይዛታስ ጫቅዳ ጫቁዋ መንꬅዳ ግሾነ ታዉ ኪተቶና እፅዳ ግሾ፥ ");
INSERT INTO gofe_vpl VALUES ("JG2_21","008_2_21","JDG","2","21","21","እያሱይ ሀይቅያ ዎደ ቢታ ቦላ አትዳ ካዎተꬃታፐ እሱዋካ ታኒ ኤንታ ስንꬃፈ ጎዳዳ ከስከ። ");
INSERT INTO gofe_vpl VALUES ("JG2_22","008_2_22","JDG","2","22","22","እስራኤለ አሳይ ካሰ ባንታ ማይዛታዳ ታ ኦግያ ካልያኮነ ካሎናኮ ፓጫናዉ ታኒ ሀ አትዳ ካዎተꬃታ ጎኤታና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG2_23","008_2_23","JDG","2","23","23","ሄሳ ግሾ፥ ጎዳይ ሄ ካዎተꬃት ቢታፈ ጎደቶና ጋምአና መላ ኦꬅስ። እ ኤንታ ኤለስድ ጎድ ከስቤና፤ ኤንታ እያሱስ አꬅድ እምቤና። ");
INSERT INTO gofe_vpl VALUES ("JG3_1","008_3_1","JDG","3","1","1","ካናነን ኦላ ሜዘትቦና እስራኤለ አሳ ፓጫናዉ ጎዳይ ካናነን አሽዳ አሳይ ሀይሳታ። ");
INSERT INTO gofe_vpl VALUES ("JG3_2","008_3_2","JDG","3","2","2","እ ሄሳ ኦꬅዳይ ሀይሳፈ ካሰ ኦላ ሜዘትቦና እስራኤለ የለተꬃ ኦላ ሂላ ታማርሳናሳ። ");
INSERT INTO gofe_vpl VALUES ("JG3_3","008_3_3","JDG","3","3","3","ሄሳትካ እቻሹ ፍልስፄመ ሀላቃታ፥ ካናነታ፥ ስዶናታነ ባኣል-አርሞና ዙማፐ ዶምድ ሀማታ ጋካናዉ ልባኖሰ ዙማ ቦላ ደእያ ህወታ። ");
INSERT INTO gofe_vpl VALUES ("JG3_4","008_3_4","JDG","3","4","4","ጎዳይ ሙሰ ባጋራ ካሰ እስራኤለ ማይዛታስ እምዳ ኪታ ኤንቲ ኪተትያኮነ ኪተቶናኮ ፓጫናዉ ኤንታ ከሶና አግስ። ");
INSERT INTO gofe_vpl VALUES ("JG3_5","008_3_5","JDG","3","5","5","ያትን፥ እስራኤለ አሳይ ካናነታራ፥ ህተታራ፥ አሞረታራ፥ ፓርዘታራ፥ ህወታራነ ያቡሰታራ እስፈ ደእዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG3_6","008_3_6","JDG","3","6","6","ኤንታ ማጫ ናይታ ባንታዉ ኤክዶሶና፤ ባንታ ማጫ ናይታ ኤንታ አደ ናይታስ እምዶሶና። ያትድ ኤንታ ፆሳታ ጎይንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG3_7","008_3_7","JDG","3","7","7","እስራኤለ አሳይ ጎዳ ስንꬃን ኢታባ ኦꬅዶሶና። ኤንቲ ጎዳ ባንታ ፆሳ ዶግድ፥ ባኣለነ አሼራ ጌተትያ ፆሳታ ጎይንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG3_8","008_3_8","JDG","3","8","8","ሄሳ ግሾ፥ ጎዳ ሀንቆይ እስራኤለ አሳ ቦላ ኤፅስ። ጎዳይ ማሰጰፆመ ካዋ ኩሻን-ርሻታይም ኤንታ ሃራና መላ አꬅድ እምን፥ ኤንቲ እያዉ ሆስፑን ላይꬅ ሃረትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG3_9","008_3_9","JDG","3","9","9","ሽን እስራኤለ አሳይ ጎዳኮ ዋስዳ ዎደ ኤንታ አሽያ፥ ካለባ ካሎ እሻ ቃናዘ ናኣ ጎቶንያላ ደንꬅስ። ");
INSERT INTO gofe_vpl VALUES ("JG3_10","008_3_10","JDG","3","10","10","ጎዳ አያናይ እያ ቦላ ዎꬍን፥ እ እስራኤለ ቦላ ፕርደይሳ ግድስ። እ ኦላስ ከይዳ ዎደ ጎዳይ ማሰጰፆመ ካዋ ኩሻን-ርሻታይማ እያዉ አꬅድ እምን ፆንስ። ");
INSERT INTO gofe_vpl VALUES ("JG3_11","008_3_11","JDG","3","11","11","ያትን፥ ቢታይ ኦይታሙ ላይꬅ ዎፑ ግድ ደእስ። ሄሳፈ ጉየ፥ ቃናዘ ናአይ ጎቶንያል ሀይቅስ። ");
INSERT INTO gofe_vpl VALUES ("JG3_12","008_3_12","JDG","3","12","12","እስራኤለ አሳይ ዛሪድ ጎዳ ስንꬃን ኢታባ ኦꬅዶሶና። ሄሳ ግሾ፥ ጎዳይ ሞአበ ካዎይ ኤግሎን እስራኤለ ቦላ ዎልቃታናዳ ኦꬅስ። ");
INSERT INTO gofe_vpl VALUES ("JG3_13","008_3_13","JDG","3","13","13","ኤግሎን አሞነታነ አማለቃታ ሺሽድ እስራኤለ አሳ ኦል ፆንድ፥ ዛምባ ካታማ እያርኮ ኦይክስ። ");
INSERT INTO gofe_vpl VALUES ("JG3_14","008_3_14","JDG","3","14","14","ያትን፥ እስራኤለ አሳይ ሞአበ ካዋ ኤግሎናስ ታማነ ሆስፑን ላይꬅ ሃረትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG3_15","008_3_15","JDG","3","15","15","ሽን እስራኤለ አሳይ ጎዳኮ ዋስዳ ዎደ ኤንታ አሽያ፥ ብንያመ ኮቸ ግድዳ ጌራ ናኣ ናኦዳ፥ ሀድርሳ ኩሸን ኦይሳ ደንꬅስ። እስራኤለ አሳይ ናኦዳ ሞአበ ካዋ ኤግሎናኮ ጊራራ ኪትስ። ");
INSERT INTO gofe_vpl VALUES ("JG3_16","008_3_16","JDG","3","16","16","ናኦድ ናምኡ ባጋራ ቃራትዳ እስ ዋꬋ ማሸ ጊግስድ ኡሻቻ ባጋን ባ ማኡዋ ጋርሳን ዳንጭስ። ");
INSERT INTO gofe_vpl VALUES ("JG3_17","008_3_17","JDG","3","17","17","ሄሳፈ ጉየ፥ ዳሮ ኦርደ ግድዳ ሞአበ ካዋ ኤግሎናስ ጊራ ኤፍድ እሚስ። ");
INSERT INTO gofe_vpl VALUES ("JG3_18","008_3_18","JDG","3","18","18","ናኦድ ጊራ ካዋስ እምዳፐ ጉየ፥ ጊራ ቶክድ ብዳ አሳ ሞይዝስ። ");
INSERT INTO gofe_vpl VALUES ("JG3_19","008_3_19","JDG","3","19","19","ሽን ናኦድ ጋልጋላ ማታን ደእያ ማሰትዳ ሹቻታ ማታፐ ኤግሎናኮ ጉየ ስም ብድ፥ “ካዋዉ፥ ታ ነዉ ኦድያ እስ ፁር ደኤስ” ያግስ። ካዎይ፥ “ስእ ጋ” ያግስ። እያ ናገይሳት ኡባይ ካረ ከይዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG3_20","008_3_20","JDG","3","20","20","ሄ ዎደ ካዎይ ፖቅያ ቦላ እስ ክፍልያን ባርካ ኡትዳሽን፥ ናኦድ እያኮ ሺቅድ፥ “ፆሳይ ነዉ ኪትዳባይ ደኤስ” ያግን፥ ካዎይ ባ ኡትዳ በሳፈ ደንድ ኤቅስ። ");
INSERT INTO gofe_vpl VALUES ("JG3_21","008_3_21","JDG","3","21","21","ናኦድ ባ ሀድርሳ ኩሽያ የድድ፥ ኡሻቻ ባጋ ፄሳን ደእያ ማሻ ሾድድ፥ ካዋ ኡሉዋን ድርግም ኦꬅስ። ");
INSERT INTO gofe_vpl VALUES ("JG3_22","008_3_22","JDG","3","22","22","ማሻ ቱይተይ አቶና ኡሎ ግዶ ገልድ፥ ዞኩዋራ ካንꬅ ከይስ። ሞꬎይ ካምዳ ግሾ ናኦድ ማሻ ካዋ ኡሉዋፐ ሾድቦና። ");
INSERT INTO gofe_vpl VALUES ("JG3_23","008_3_23","JDG","3","23","23","ሄሳፈ ጉየ፥ ናኦድ ካረ ከይድ፥ ክፍልያ ፐንግያ ጎርድድ እያ ቦላ ቁልፕስ። ");
INSERT INTO gofe_vpl VALUES ("JG3_24","008_3_24","JDG","3","24","24","ናኦድ ብዳፐ ጉየ አይለት ይድ፥ ፐንገይ ጎርደትዳይሳ በእድ፥ “ካዎይ ግዶ ክፍልያን ሼሻስ ኡቶና አገና” ያግድ ቆፕዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG3_25","008_3_25","JDG","3","25","25","ኤንቲ ሳለታና ጋካናዉ ናግዶሶና። ሽን ካዎይ ፐንግያ ዶዮና እፅን፥ ቁልፐ ኤክድ ፐንግያ ዶይድ፥ ባንታ ጎዳይ ሀይቅድ፥ ዉይገን ኩንድዳይሳ በእዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG3_26","008_3_26","JDG","3","26","26","ኤንቲ ያን ኤቅድ ናግሽን፥ ናኦድ ከስ ኤክድ ኤቃ ሹቻታ ማታራ አꬍድ ሳኢራ ባቃትስ። ");
INSERT INTO gofe_vpl VALUES ("JG3_27","008_3_27","JDG","3","27","27","እ ብድ ደረይ ዳርያ ኤፍሬማ ቢታ ጋክዳ ዎደ እስራኤለ አሳይ ኦላስ ሺቃና መላ ሞይዘ ፑንን፥ አሳይ እያ ካልድ ዱገ ዎꬍዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG3_28","008_3_28","JDG","3","28","28","እ ኤንታኮ፥ “ታና ካልተ፤ ጎዳይ ህንተ ሞርከታ፥ ሞአበታ ህንተ ኩሸን አꬅድ እሚስ” ያግስ። ኤንቲ እያ ካል ዎꬍድ፥ ዮርዳኖሰ ሻፋ ፕንያ በሳ ኦይክዶሶና። ሞአበ አሳፐ እስ አስካ ያራ አꬎና መላ ተቅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG3_29","008_3_29","JDG","3","29","29","ሄ ዎደ ሞአበ አሳፐ ታሙ ሙኩሉ ግድያ ዶረትዳ ምኖ ኦላንቾታ ዎꬍዶሶና፤ እስ አስካ ከስ ኤክቤና። ");
INSERT INTO gofe_vpl VALUES ("JG3_30","008_3_30","JDG","3","30","30","ሄ ጋላስ እስራኤለ አሳይ ሞአበ አሳ ፆንዶሶና። ቢታይ ሆስፑን ታሙ ላይꬅ ዎፑ ግድ ደእስ። ");
INSERT INTO gofe_vpl VALUES ("JG3_31","008_3_31","JDG","3","31","31","ናኦዳፐ ጉየ፥ አናታ ናአይ ሳምጋር ደንድድ፥ ፍልስፄመ አሳፐ ኡሱፑን ፄቱ አሳ ቦሩ ላግያ ብራታ ፃምአን ዎꬍድ እስራኤለ አሳ አሽስ። ");
INSERT INTO gofe_vpl VALUES ("JG4_1","008_4_1","JDG","4","1","1","ናኦድ ሀይቅዳፐ ጉየ እስራኤለ አሳይ ጎዳ ስንꬃን ዛሪድ ኢታባ ኦꬅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG4_2","008_4_2","JDG","4","2","2","ሄሳ ግሾ፥ ጎዳይ ሀፆራ ካታማን ደእያ ካናነ ካዋ እያብሳስ ኤንታ አꬅድ እሚስ። እያ ቶራ ሞጮናይ ሀሮሴት ሀጎይማ ካታማን ደእያ ስሳራ። ");
INSERT INTO gofe_vpl VALUES ("JG4_3","008_4_3","JDG","4","3","3","እያብሳስ ኡዱፉን ፄቱ ብራታ ፓራ ጋረት ደእያ ግሾነ እ እስራኤለ አሳ ቃይ ባይና ላታሙ ላይꬅ ኡንኤꬅዳ ግሾ ኤንቲ ማዶ ደማናዉ ጎዳኮ ዋስዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG4_4","008_4_4","JDG","4","4","4","ሄ ዎደ ላፍዶታ ማችያ፥ ናብያ ድቦራ እስራኤለ አሳ ካለꬃዉስ። ");
INSERT INTO gofe_vpl VALUES ("JG4_5","008_4_5","JDG","4","5","5","ድቦራ ደረይ ዳርያ ኤፍሬማ ቢታን፥ ራማፐነ ቤተለፐ ግዶን ደእያ ድቦራ ዛምባ ጋርሳን ኡታዳ ፕርዳዉሱ። እስራኤለ አሳይ ፕርዳ ደማናዉ ኢኮ ዮሶና። ");
INSERT INTO gofe_vpl VALUES ("JG4_6","008_4_6","JDG","4","6","6","እስ ጋላስ ድቦራ አብኖማ ናኣ ባራቃ ንፍታለመ ቢታን ደእያ ቃደሳፐ ፄግሳዳ፥ “ጎዳይ እስራኤለ ፆሳይ ነና ሀይሳዳ ያግድ ኪትስ፤ ‘ንፍታለመነ ዛብሎና ዛርያፐ ታሙ ሙኩሉ አሳ ኤካዳ ታቦረ ዙማ ቦላ ከያ። ");
INSERT INTO gofe_vpl VALUES ("JG4_7","008_4_7","JDG","4","7","7","ታኒ ያብና ቶራ ሞጮናታ ስሳር ፓራ ጋረታነ ኦላንቾታ ኤክድ፥ ቅሶና ሻፋን ነና ኦላናዉ ያና መላ ኦꬃና። ያን ታኒ ነዉ እያ አꬃዳ እማና’ ያጌስ” ያጋሱ። ");
INSERT INTO gofe_vpl VALUES ("JG4_8","008_4_8","JDG","4","8","8","ባራቅ፥ “ኔኒ ታራ ቢኮ ታኒ ባና፤ ሽን ኔኒ ታራ ቦና እፅኮ ታኒ ቢከ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG4_9","008_4_9","JDG","4","9","9","እያ ዛራዳ፥ “ኤሮ፥ ታኒ ኔራ ባና፤ ሽን ጎዳይ ስሳራ ማጫሳ ኩሸን አꬅድ እማና ግሾ ታ ቡሳይ ነዉ ቦንቾ ግደና” ያጋሱ። ሄሳ ግሾ ድቦራ ደንዳዳ፥ ባራቃራ ቃደሳ ባሱ። ");
INSERT INTO gofe_vpl VALUES ("JG4_10","008_4_10","JDG","4","10","10","ባራቅ ንፍታለመነ ዛብሎና ኮቻታ ቃደሳ ፄግን፥ ታሙ ሙኩሉ አስ እያ ካልድ ከይስ፤ ድቦራካ እያራ ባሱ። ");
INSERT INTO gofe_vpl VALUES ("JG4_11","008_4_11","JDG","4","11","11","ሄ ዎደ ቄና አስ ግድዳ ሄቤር፥ ሙሰ ቦሎይ፥ ሆባባ ያራይ ሀራ ቄናታፐ ሻከትድ ቃደሳ ማታን ዘናንመን ደእያ ዎላ ማታን ባ ዱንካንያ ቶክስ። ");
INSERT INTO gofe_vpl VALUES ("JG4_12","008_4_12","JDG","4","12","12","አብኖማ ናአይ ባራቅ ታቦረ ዙማ ብዳይሳ ስሳር ስእዳ ዎደ፥ ");
INSERT INTO gofe_vpl VALUES ("JG4_13","008_4_13","JDG","4","13","13","ኡዱፉን ፄቱ ብራታ ፓራ ጋረታነ ባራ ደእያ አሳ ኡባ ፄግስድ፥ ሀሮሴት-ሀጎይማፐ ቅሶና ሻፋ ሺሽስ። ");
INSERT INTO gofe_vpl VALUES ("JG4_14","008_4_14","JDG","4","14","14","ያትን ድቦር ባራቃኮ፥ “ሀች ጎዳይ ስሳራ ነ ኩሸን አꬅድ እምያ ጋላስ ግድያ ግሾ ደንዳ። ሄኮ፥ ጎዳይ ነዉ ስን አꬍስ” ያጋሱ። ባራቅ ታሙ ሙኩሉ ኦላንቾታ ካለꬅድ፥ ታቦረ ዙማፐ ዎꬍስ። ");
INSERT INTO gofe_vpl VALUES ("JG4_15","008_4_15","JDG","4","15","15","ጎዳይ ስሳራ፥ እያ ፓራ ጋረታነ እያ ኦላንቾታ ኡባ ባራቃ ማሻስ አꬅድ እሚስ። ያትን፥ ስሳር ባ ፓራ ጋርያፐ ዎꬍድ ቶሆን ባቃትስ። ");
INSERT INTO gofe_vpl VALUES ("JG4_16","008_4_16","JDG","4","16","16","ባራቅ ፓራ ጋረታነ ኦላንቾታ ሀሮሴት-ሀጎይማ ጋካናዉ የደꬅስ። ስሳራ ኦላንቾት ኡባይ ማሻን ሀይቅዶሶና፤ እስ አስካ አትቤና። ");
INSERT INTO gofe_vpl VALUES ("JG4_17","008_4_17","JDG","4","17","17","ሄ ዎደ ሀፆራ ካዎይ ያብን ሄቤራ ኬꬃ አሳራ ሳሮ ደኤስ። ሄሳ ግሾ፥ ስሳር ቶሆን ባቃትድ፥ ቄና አስ ግድዳ ሄቤራ ማቸ ያኤል ዱንካንያ ጋክስ። ");
INSERT INTO gofe_vpl VALUES ("JG4_18","008_4_18","JDG","4","18","18","ያኤላ ስሳራ ሞካናዉ ከያዳ፥ “ታ ጎዳዉ፥ ገላ፤ ሃ ገላ፤ ያዮፋ” ያጋሱ። እ ዱንካንያ ግዶ ኢኮ ገልን እያ አፍላራ ካማስ። ");
INSERT INTO gofe_vpl VALUES ("JG4_19","008_4_19","JDG","4","19","19","ስሳር፥ “ታና ሳሜስ፤ ሃ ታና ኡሻርክ” ያግስ። እያ ማꬃ ኦጎሮ ዶያዳ ኡሻሱ፤ ያታዳ ዛራዳ ካማሱ። ");
INSERT INTO gofe_vpl VALUES ("JG4_20","008_4_20","JDG","4","20","20","ሄሳፈ ጉየ፥ እ፥ “ዱንካንያ ፐንገን ኤቃ። አይ አስካ ይድ፥ ‘ሀይሳን አስ ደኢ?’ ያግድ ኦይችኮ፥ ‘ባዋ’ ያጋ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG4_21","008_4_21","JDG","4","21","21","ስሳር ዳሮ ዳቡርዳ ግሾ ꬍስኮ ሀይቅ አግስ። ሄቤራ ማችያ ያኤላ ናርቃነ ዱንካነ ꬍሸ ኤካዳ፥ ሎዳራ እያኮ ሺቃዳ ꬍሽያ ሀይꬃ ካረን ꬍሻዳ፥ ሳአራ ኦይꬅን ስሳር ሀይቅስ። ");
INSERT INTO gofe_vpl VALUES ("JG4_22","008_4_22","JDG","4","22","22","ባራቅ ስሳራ ኮይሸ ይን፥ ያኤላ እያ ሞካናዉ ካረ ከያዳ፥ “ሃያ፤ ነ ኮይያ አድያ ታኒ ነና በሳና” ያጋሱ። ሄሳ ግሾ፥ ኢራ ዱንካንያ ግዶ ገልድ፥ ስሳራ ሀይꬃ ካረን ꬍሸይ ገልን እያ አሀይ ሳአን ዝንእዳይሳ በእስ። ");
INSERT INTO gofe_vpl VALUES ("JG4_23","008_4_23","JDG","4","23","23","ሄ ጋላስ ፆሳይ እስራኤለ አሳይ ካናነ ካዋ ያብና ፆናና መላ ኦꬅስ። ");
INSERT INTO gofe_vpl VALUES ("JG4_24","008_4_24","JDG","4","24","24","ያብና ካዋ ꬋይሳና ጋካናዉ እስራኤለ አሳይ እያ ቦላ ምን ምን ብስ። ");
INSERT INTO gofe_vpl VALUES ("JG5_1","008_5_1","JDG","5","1","1","ሄ ጋላስ ድቦራነ አብኖማ ናአይ ባራቅ ሀ ማዝሙርያ የፅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG5_2","008_5_2","JDG","5","2","2","ሀላቃት እስራኤለ አሳ ካለꬅዳ ግሾ፥ አሳይካ ባና አꬅድ እምዳ ግሾ፥ ጎዳ ጋላትተ። ");
INSERT INTO gofe_vpl VALUES ("JG5_3","008_5_3","JDG","5","3","3","ህንተኖ ካዎቶ፥ ስእተ፤ ህንተኖ ሃረይሳቶ፥ ሀይዝተ፤ ታኒ ጎዳስ የፃና። እስራኤለ ፆሳ ጋላታና። ");
INSERT INTO gofe_vpl VALUES ("JG5_4","008_5_4","JDG","5","4","4","አቤት ጎዳዉ፥ ኔኒ ሳይረ ዙማፐ ደንድያ ዎደ፥ ኤዶመ ቢታፈ ነ ከይያ ዎደ፥ ቢት ቃፅስ፤ ሳሎፐ እር ቡክስ፤ ሃꬅ ሻራፐ ጎግስ። ");
INSERT INTO gofe_vpl VALUES ("JG5_5","008_5_5","JDG","5","5","5","ሲና ጎዳ፥ እስራኤለ ፆሳ ስንꬃን፥ ደረት ቃፅዶሶና፤ ");
INSERT INTO gofe_vpl VALUES ("JG5_6","008_5_6","JDG","5","6","6","አናታ ናኣ ሳምጋራ ዎደነ ያኤላ ዎደ ኦገይ ዶገትስ፤ ዛልአንቾት ዩሾ ኦገራ ቦሶና። ");
INSERT INTO gofe_vpl VALUES ("JG5_7","008_5_7","JDG","5","7","7","ድቦር እስራኤለ አሳስ፥ አዮ ግዳዳ ደንዳና ጋካናዉ፥ እስራኤለ ጉታት ባይሳትዶሶና፤ ");
INSERT INTO gofe_vpl VALUES ("JG5_8","008_5_8","JDG","5","8","8","እስራኤለ አሳይ አላጋ ፆሳታ ዶርዳ ዎደ፥ ቢታ ቦላ ኦል ደንድስ። ኦይታሙ ሙኩሉ እስራኤለ ኦላንቾታ ግዶን፥ እስ ጎንዳለይ ዎይኮ እስ ቶር በንትቤና። ");
INSERT INTO gofe_vpl VALUES ("JG5_9","008_5_9","JDG","5","9","9","ታ ዎዛናይ እስራኤለ ቶራ ሞጮናታራ፥ አሳ ግዶፈ ዶሳን ባንታና አꬅድ፥ እምዳይሳታራ ደኤስ። ጎዳ ጋላትተ፤ ");
INSERT INTO gofe_vpl VALUES ("JG5_10","008_5_10","JDG","5","10","10","ህንተኖ፥ ቦꬃ ሀረታ ቶገይሳቶ፥ ሎኦ ግላስያ ቦላ ኡትድ ድንጫከተይሳቶ፥ ኦገ ጋፃራ ሄመተይሳቶ ሀይሳ ስእተ። ");
INSERT INTO gofe_vpl VALUES ("JG5_11","008_5_11","JDG","5","11","11","ሃꬃ ኦላታ ማታን፥ ሺቅዳ አሳ የꬃ ስእተ። ኤንቲ ጎዳ ፆኑዋ የፆሶና፤ እስራኤለ አሳ ፆኑዋ ኦዶሶና። ሄሳፈ ጉየ፥ ጎዳ አሳይ ካታማ ፐንገታኮ ዎꬍዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG5_12","008_5_12","JDG","5","12","12","ድቦራ፥ ደንዳ! ደንዳ! ደንዳ! ደንዳዳ ማዝሙረ የፃ። አብኖማ ናአዉ፥ ባራቃ፥ ደንዳ! ነ ድእዳባ ኤካዳ ያ። ");
INSERT INTO gofe_vpl VALUES ("JG5_13","008_5_13","JDG","5","13","13","ሄሳፈ ጉየ፥ አትዳ አሳት፥ ሀላቃታኮ ዎꬍዶሶና። ጎዳ አሳት ኦለታናዉ ጊግድ ባራቃኮ ይዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG5_14","008_5_14","JDG","5","14","14","አማለቃ ኮቻት በን ደእዳ በሳን ደእያ ኤፍሬማ አሳት ይዶሶና። ብንያመ አሳት ኤንታ ካልዶሶና። ማክራፐ ሀላቃት፥ ዛብሎናፐ ካዎተꬃ ፃምአ ኦይከይሳት ይዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG5_15","008_5_15","JDG","5","15","15","ይሳኮራ ሀላቃት ድቦራራ ደኦሶና፤ ኤ፥ ይሳኮረ አሳይ ባራቃራ ይዶሶና፤ ኤንቲ እያ ካልድ፥ ዛንጋራ ገልዶሶና። ሽን ሮቤላ ኮቻት ቆፋን ሻከትድ፥ ባንታ ዎዛናን ሄትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG5_16","008_5_16","JDG","5","16","16","ኤንቲ አይስ አትዶና? ዶርሳታ ሄማናሰዬ? ሮቤላ ኮቻት ቆፋን ሻከትድ፥ ባንታ ዎዛናን ሄትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG5_17","008_5_17","JDG","5","17","17","ጋደ ኮቻት ዮርዳኖሰ ፕንꬃን አትስ፥ ዳና ኮቻት ማርካበታን አትዶሶና። አሴራ ኮቻት ባንታ ደእያሶን፥ አባ ጋፃን አትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG5_18","008_5_18","JDG","5","18","18","ዛብሎና ኮቻት፥ ባንታና ሀይቆስ አꬅድ እምዶሶና። ንፍታለመ ኮቻት፥ ቶራ ደንባን ባንታና አꬅድ እምዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG5_19","008_5_19","JDG","5","19","19","ማግዶ ፑልቶታ ማታን ታናካን፥ ካዎት ኦለትዶሶና። ካናነ ካዎት ያን ኦለትድ፥ ብራ ዎይኮ ሀራባ ድእቦኮና። ");
INSERT INTO gofe_vpl VALUES ("JG5_20","008_5_20","JDG","5","20","20","ሳሎፐ ፆልንቶት ኦለትዶሶና፤ ባንታ ዩሻን ስሳራ ኦልዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG5_21","008_5_21","JDG","5","21","21","ቅሶና ሻፋይ ኤንታ ኤፍስ፤ በንፐ ደእያ ቅሶን ኤንታ ሾክስ። ታ ሸምፐ፥ ምና፤ ስን ሆርዶፋ። ");
INSERT INTO gofe_vpl VALUES ("JG5_22","008_5_22","JDG","5","22","22","ፓራት አዳርስሸ ይዶሶና፥ ባንታ ቶሁዋን ቢታ ጊርሶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG5_23","008_5_23","JDG","5","23","23","ጎዳ ኪታንቾይ ሀይሳዳ ያግስ፤ “መሮዛ ባድተ! ያን ደእያ አሳ ኢስድ ባድተ! ኤንቲ ጎዳ ማዳናዉ ይቦኮና፤ እያ ዎልቃማ ሞርከታ ኦላናዉ ከይቦኮና።” ");
INSERT INTO gofe_vpl VALUES ("JG5_24","008_5_24","JDG","5","24","24","ቄና አስ ግድዳ ሄቤራ ማችያ፥ ያኤል ማጫሳ ኡባፈ አንጀትዳሮ ግዶ። ዱንካነን ደእያ ማጫሳ ኡባፈ፥ እያ አንጀትዳሮ ግዶ። ");
INSERT INTO gofe_vpl VALUES ("JG5_25","008_5_25","JDG","5","25","25","ስሳር እዮ ሃ ኦይችን ማꬅ እማሱ፤ ሎኦ ኦጎሮን መቅዳ ማꬅ ኤሀሱ። ");
INSERT INTO gofe_vpl VALUES ("JG5_26","008_5_26","JDG","5","26","26","ባ ሀድርሳ ኩሸን ዱንካነ ꬍሸ፥ ባ ኡሻቻ ኩሸን ኦሳንቾታ ናርቃ ኦይካሱ። ስሳራ ሁጰን ꬍሻሱ፤ እያ ሀይꬃ ካረራ ካንꬃ ከሳሱ። ");
INSERT INTO gofe_vpl VALUES ("JG5_27","008_5_27","JDG","5","27","27","እ ቶሁዋ ጋርሳን ኩንድስ፤ እ ቶሁዋ ማታን ዞሄትስ። እ ቶሁዋ ጋርሳን ኩንድስ፤ ሄ ኩንድዳ በሳን ሀይቅስ። ");
INSERT INTO gofe_vpl VALUES ("JG5_28","008_5_28","JDG","5","28","28","ስሳራ አይያ ማስኮተራ ካረ ፄላሱ፤ “ታ ናኣ ፓራ ጋረይ አይስ ጋምእዴ? ፓራት አይስ ኤለስድ ስምቦኮና?” ያጋዳ ባና ኦይቻሱ። ");
INSERT INTO gofe_vpl VALUES ("JG5_29","008_5_29","JDG","5","29","29","እ ጭንጫ ማጫሳት እ ኦይሻ ዛርዶሶና፤ ሽን እያ ባ ቆፋን ዛራ ዛራዳ ያጋሱ። ");
INSERT INTO gofe_vpl VALUES ("JG5_30","008_5_30","JDG","5","30","30","“ኤንቲ ድኦ ደምድ ሻከቶና አጎኮና፤ እስ እስ አደስ ኢስ ገላኦይ ዎይኮ ናምኡ ጌላኦት ጋኮና አገና። ኤንቲ ስሳራስ ሎእያ ማኦ እማና፤ ታዉካ ቆን ማእያ፥ አሌቀትዳ ማኦ ኤሀና” ያጋሱ። ");
INSERT INTO gofe_vpl VALUES ("JG5_31","008_5_31","JDG","5","31","31","አቤት ጎዳዉ፥ ነ ሞርከት ኡባይ ሀይሳዳ ሀይቆ፤ ሽን ነና ዶሰይሳት ዎንታ ፃልቀዳ ጶሎ። ሄሳፈ ጉየ፥ ቢታይ ኦይታሙ ላይꬅ ዎፑ ግድ ደእስ። ");
INSERT INTO gofe_vpl VALUES ("JG6_1","008_6_1","JDG","6","1","1","እስራኤለ አሳይ ጎዳ ስንꬃን ዛሪድ ኢታባ ኦꬅዶሶና። ሄሳ ግሾ፥ ጎዳይ ኤንታ ምድያመ አሳስ አꬅድ እምን ላፑን ላይꬅ ኤንታ ሃርዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG6_2","008_6_2","JDG","6","2","2","ምድያመ አሳይ እስራኤለ አሳ ኡንኤꬅን፥ ኤንታፈ አታናዉ ደረ ቦላ፥ ጎንጎሎንነ ሆምኦን ባንታ ካꬃ ቆስዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG6_3","008_6_3","JDG","6","3","3","እስራኤለ አሳይ ካꬅ ዘርያ ዎደ ኡባን፥ ምድያመ አሳይ አማለቃ አሳራነ ዶሎሀ ባጋ አሳራ ይድ ኤንታ ኦሎሶና። ");
INSERT INTO gofe_vpl VALUES ("JG6_4","008_6_4","JDG","6","4","4","ኤንቲ ሄ ቢታን ዱንካንድ፥ ጋዛ ጋካናዉ፥ ቢታ ቦላ ዶልዳባ ኡባ ꬋይሶሶና። ዶርሰ፥ መሄነ ሀረ ላግድ ኤፍያ ግሾ፥ እስራኤለ አሳስ አይባካ አሾኮና። ");
INSERT INTO gofe_vpl VALUES ("JG6_5","008_6_5","JDG","6","5","5","ባንታ መህያነ ባንታ ዱንካንያ ኤክድ፥ ቦለይ ያዳ ዳርድ ዮሶና። ኤንታነ ኤንታ ግማለታ ታይባናዉ ዳንዳኤተና፤ ኤንቲ ይሸ ቢታ ꬋይሶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG6_6","008_6_6","JDG","6","6","6","እስራኤለ አሳይ ምድያመታ ጋሶን ዳሮ መቶትዶሶና፤ ማደ ደማናዉ ጎዳኮ ዋስዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG6_7","008_6_7","JDG","6","7","7","ምድያመታ ጋሶን እስራኤለ አሳይ ጎዳኮ ዋስዳ ዎደ፥ ");
INSERT INTO gofe_vpl VALUES ("JG6_8","008_6_8","JDG","6","8","8","ጎዳይ ኤንታዉ እስ ናበ ኪትን፥ ናበይ ኤንታኮ፥ “ጎዳይ እስራኤለ ፆሳይ ሀይሳዳ ያጌስ፤ ግብፀፈ፥ አይለተꬃ ቢታፈ ታ ህንተና ከሳስ። ");
INSERT INTO gofe_vpl VALUES ("JG6_9","008_6_9","JDG","6","9","9","ታኒ ህንተና ግብፀ አሳ ኩሸፐነ ኡንኤꬅያ አሳ ኡባ ኩሸፐ አሻስ። ህንተ ስንꬃፈ ኡንኤꬅያ አሳ ጎዳዳ ኤንታ ቢታ ህንተዉ እማስ። ");
INSERT INTO gofe_vpl VALUES ("JG6_10","008_6_10","JDG","6","10","10","ታኒ ህንተና፥ ‘ታኒ ጎዳ ህንተ ፆሳ፤ ህንተ ኤንታ ቢታ ላትዳ አሞረታ ፆሳታ ጎይኖፍተ’ ያጋስ። ሽን ህንተ ታ ቃላ ስኦና እፅደታ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG6_11","008_6_11","JDG","6","11","11","ሄሳፈ ጉየ፥ ጎዳ ኪታንቾይ ኦፍራ ጌተትያ በሳን ደእያ አበዜራ አድያ እዮኣሳ ዎላ ጋርሳን ኡትስ። ሄ ዎደ እዮኣሳ ናአይ ገድዮን ምድያመ አሳፐ ቆሰተድ ዎይነ ጉምእያ በሳን ግስተ ቡኬስ። ");
INSERT INTO gofe_vpl VALUES ("JG6_12","008_6_12","JDG","6","12","12","ያን ጎዳ ኪታንቾይ እያዉ ቆንጭድ፥ “ላ ነኖ፥ ምኖ ኦላንቻዉ፥ ጎዳይ ኔራ ደኤስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG6_13","008_6_13","JDG","6","13","13","ገድዮን፥ “ታ ጎዳዉ፥ ጎዳይ ኑራ ደእያባ ግድኮ ሀ መቶ ኡባይ ኑና አይስ ጋክዴ? ኑ አዋት፥ ‘ጎዳይ ኑና ግብፀ ቢታፈ ከስስ’ ያግድ ኑስ ኦድዳ ማላልስያ እያ ኦሶት ኡባይ አዉን ደኢ? ሽን ሀእ ጎዳይ ኑና ኩመꬅ አግስ፤ ምድያመ አሳስ አꬅድ እሚስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG6_14","008_6_14","JDG","6","14","14","ሄሳፈ ጉየ ጎዳይ እያኮ ስሚድ፥ “ነዉ ደእያ ሀ ዎልቃን ባዳ እስራኤለ አሳ ምድያመ ኩሸፐ አሻ። ነና ኪተይ ታና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG6_15","008_6_15","JDG","6","15","15","ገድዮን ዛሪድ፥ “አቤት ጎዳዉ፥ ታኒ እስራኤለ አሳ ዋታዳ አሾ? ታ ያራይ ምናሰ ኮቻ ኡባፈ አꬍዳ ላፋ፤ ታኒ ታ አዋ ሶ አሳ ኡባፈ ጉꬃ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG6_16","008_6_16","JDG","6","16","16","ጎዳይ፥ “ታኒ ኔራ ግዳና፤ እስ አስ ሾጭያ መላ ኔኒ ምድያመ አሳ ሾጫዳ ፆናና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG6_17","008_6_17","JDG","6","17","17","ገድዮን፥ “ኔኒ ታናን ኡፋይትያባ ግድኮ፥ ቱማ ታራ ኦደተይ ኔኒ ጎዳ ግድኮ፥ ነና ኤርስያ ማላ ታና በሳ። ");
INSERT INTO gofe_vpl VALUES ("JG6_18","008_6_18","JDG","6","18","18","ታኒ ጉየ ስማ ባዳ ታ ያርሹዋ ኤሀና ጋካናዉ ሀያና ሀይሳፈ ቦፓ” ያግስ። ጎዳይ፥ “ኔኒ ስማና ጋካናዉ ታኒ ሀይሳን ናጋና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG6_19","008_6_19","JDG","6","19","19","ገድዮን ሶ ገልድ፥ ኡርገ ዴሽ ሹክድ ካꬅስ፤ ታሙ ክሎ ግራመ ግድያ ꬊለ ኤክድ ኡይꬅ ኡክስ። አሹዋ ጋይታን ዎꬅድ፥ ጫምባ ሻተን ትግድ፥ ዎላ ጋርሳን ኡትዳ ጎዳ ኪታንቹዋስ ሺሽስ። ");
INSERT INTO gofe_vpl VALUES ("JG6_20","008_6_20","JDG","6","20","20","ፆሳ ኪታንቾይ፥ “አሹዋነ ኡይꬃ ሀ ሹቻ ቦላ ዎꬃ፤ ጫምባ እያ ቦላ ትጋ” ያግስ። ገድዮን ኪተትዳይሳዳ ኦꬅስ። ");
INSERT INTO gofe_vpl VALUES ("JG6_21","008_6_21","JDG","6","21","21","ጎዳ ኪታንቾይ ባ ኩሸን ኦይክዳ ፃምኣ ፄራን አሹዋነ ኡይꬃ ቦችን ታም ሹቻ ግዶፈ ከይድ፥ አሹዋነ ኡይꬃ ምስ። ሄሳፈ ጉየ፥ ጎዳ ኪታንቾይ እያ ስንꬃፈ ጌምስ። ");
INSERT INTO gofe_vpl VALUES ("JG6_22","008_6_22","JDG","6","22","22","ገድዮን በእዳይ ጎዳ ኪታንቹዋ ግደይሳ አኬክዳ ዎደ፥ “ጎዳ ፆሳዉ ታና አየ! ታኒ ጎዳ ኪታንቹዋ ታ አይፈን በአስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG6_23","008_6_23","JDG","6","23","23","ሽን ጎዳይ፥ “ሳሮይ ነዉ ግዶ፤ ያዮፋ! ነ ሀይቃካ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG6_24","008_6_24","JDG","6","24","24","ገድዮን ጎዳስ ያርሾ በሲ ያን ጊግስድ፥ “ጎዳይ ሳሮ ፆሲ” ያግድ ፄግስ። ሄ ያርሾ በሳይ አብኤዜራ ኮቻባ ግድዳ ኦፍራን ሀች ጋካናዉ ኤቅድ ደኤስ። ");
INSERT INTO gofe_vpl VALUES ("JG6_25","008_6_25","JDG","6","25","25","ሄ ቃማ ጎዳይ ገድዮናኮ፥ “ነ አዋ ኮርማታፐ ላፑን ላይꬅ ግድዳ ሎኦ ኮርማ ኤካ። ነ አዋይ ባኣለ ኤቃስ ያርሽያ በሳ ላላ፤ እያ ማታን ደእያ አሼራ ኤቃ ምስልያ መንረꬃ የጋ። ");
INSERT INTO gofe_vpl VALUES ("JG6_26","008_6_26","JDG","6","26","26","ሀ ዙማ ሁጰን ጎዳስ ነ ፆሳስ፥ ሹቻን ያርሾ በሲ ሎይꬃዳ ጊግሳ። ሄሳፈ ጉየ፥ ኔኒ መንረꬅዳ አሼራ ኤቃ ምስልያ ቀረꬃ ኤꬃዳ፥ ሄ ኮርማ ፁሳ ያርሾ ኦꬃዳ ያርሻ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG6_27","008_6_27","JDG","6","27","27","ገድዮን ባ ኦሳንቾታፐ ታማታ ኤክድ፥ ጎዳይ እያዉ ኦድዳይሳዳ ኦꬅስ። ሽን እ ባ አዋ ሶ አሳስነ ካታማን ደእያ አሳስ ያይዳ ግሾ ጋላስ ኦꬃናይሳ አግድ ቃማ ኦꬅስ። ");
INSERT INTO gofe_vpl VALUES ("JG6_28","008_6_28","JDG","6","28","28","ዎንታ ጉራ ካታማ አሳይ ደንድያ ዎደ ባኣለ ኤቃ ያርሾ በሳይ ላለትን፥ እያ ማታን ደእያ አሼራ ምስለይ መቅድ ዎꬍዳይሳ በእዶሶና። ቃስ ሄ በሳን ያርሾ በሲ ጊግዳይሳነ እያ ቦላ ኮርማ ያርሽዳይሳ በእዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG6_29","008_6_29","JDG","6","29","29","ኤንቲ እሶይ እሱዋ፥ “ላ ሀይሳ ኦꬅዳይ ኦኔ?” ያግድ ኦይችዶሶና። ኤንቲ ሄሳ ፕልግድ በእዳ ዎደ ሄሳ ኦꬅዳይ እዮኣሳ ናኣ ገድዮና ግደይሳ ኤርዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG6_30","008_6_30","JDG","6","30","30","ሄሳፈ ጉየ፥ ካታማ አሳይ እዮኣሳኮ፥ “ባኣለ ያርሾ በሳ ላልዳ ግሾነ እያ ማታን ደእያ አሼራ ምስልያ መንረꬅድ የግዳ ግሾ ነ ናኣ ሃ ከሳ፤ ኑ እያ ዎꬋና” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG6_31","008_6_31","JDG","6","31","31","ሽን እዮኣስ ባ ቦላ ደንድዳ አሳኮ፥ “ህንተ ባኣለስ ሞተተቲ? ዎይኮ ህንተ እያ አሻናዉ ኮዬቲ? ህንተ ግዶፈ እያዉ ሞተትያ አስ ደእኮ፥ ሳእ ዎንታናዉ እ ሀይቆ። ባኣለይ ፆሰ ግድኮ ባ ያርሾ በሳ ላልዳይሳራ እ ባዉ ሞተቶ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG6_32","008_6_32","JDG","6","32","32","ሄ ጋላስ እዮኣስ፥ “ላለትዳይ እያ ያርሾ በሳ ግድያ ግሾ እያራ ባኣለይ ሞተቶ” ያግድ ገድዮና የሩባኣላ ግድ ሱንꬅስ። ");
INSERT INTO gofe_vpl VALUES ("JG6_33","008_6_33","JDG","6","33","33","ሄሳፈ ጉየ፥ ምድያመ፥ አማለቃነ ዶሎሀ ባጋ ቢታ አሳይ እስፈ ሺቅድ፥ ዮርዳኖሰ ሻፋ ፕንድ እዝራኤላ ዛንጋራን ዱንካንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG6_34","008_6_34","JDG","6","34","34","ጎዳ አያናይ ገድዮና ቦላ ዎꬍን አብኤዘራ ኮች ግድዳ አሳ ኡባይ ባና ካላና መላ ኤንታ ፄጋናዉ ሞይዘ ፑንስ። ");
INSERT INTO gofe_vpl VALUES ("JG6_35","008_6_35","JDG","6","35","35","ምናሰ ኮቻ ኡባስ ኪታ የድድ፥ ባና ካላና መላ ኤንታ ፄግስስ። ቃስ አሴራ፥ ዛብሎናነ ንፍታለመ ኮቻታስ ኪታ የድን፥ ኤንቲ እያራ ኦላስ ባናዉ ከይዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG6_36","008_6_36","JDG","6","36","36","ገድዮን ፆሳኮ፥ “ነ ታዉ ቃላ ገልዳይሳዳ እስራኤለ አሳ አሻናዉ ታና ዶርዳባ ግድኮ፥ ");
INSERT INTO gofe_vpl VALUES ("JG6_37","008_6_37","JDG","6","37","37","ሄኮ፥ ታኒ ግስተ ቡክያ ዉዱማን ፓደትዳ ዶርሰ እክሰ ዎꬃና። ሀራ ቢታ ኡባይ መላ ግድድ ሄ እክስያ ቦላ ፃላላ አክ ዎꬍኮ ነ ኦድዳይሳዳ እስራኤለ አሳ ታ ኩሸን አሻናይሳ ታ ኤራና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG6_38","008_6_38","JDG","6","38","38","እ ግዳይሳዳ ሀንስ። ዎንተꬃ ጋላስ ዎንታ ጉራ ደንድድ፥ ዶርሳ እክስያ ጉምእዳ ዎደ እስ ፃሮ ግድያ ሃꬅ እያፐ ከይስ። ");
INSERT INTO gofe_vpl VALUES ("JG6_39","008_6_39","JDG","6","39","39","ቃስ ገድዮን፥ “ሀያና ሀንቀቶፋ፤ ታኒ ነና ጉጃዳካ ሀራ ኦይሾ ኦይቻና። ዶርሳ እክስያ ቦላ ሀራ ማላ በሳና መላ ኦይቻይስ። ሀእ ዶርሳ እክሰይ መላ ግድን ዩሹዋን ደእያ ቢታይ አካትድ ላካናዳ ኦꬃ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG6_40","008_6_40","JDG","6","40","40","ሄ ቃማ ፆሳይ ሄ ማላ ኦꬅስ። ዎንተꬃ ጋላስ ዶርሳ እክሰይ መላ ግድን ቢታ ኡባይ አካትድ ላክስ። ");
INSERT INTO gofe_vpl VALUES ("JG7_1","008_7_1","JDG","7","1","1","ዎንተꬃ ጋላስ የሩባኣላ ጌተትያ ገድዮንነ እያራ ደእያ አሳ ኡባይ ዎንታ ጉራ ደንድድ ብድ፥ ሀሮዳ ፑልቱዋ ማታን ዱንካንዶሶና። ምድያመ አሳይ ኤንታፈ ፑደሀ ባጋራ ሞረ ዙማ ማታን ደእያ ዛንጋራን ዱንካንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG7_2","008_7_2","JDG","7","2","2","ጎዳይ ገድዮናኮ፥ “ኔራ ደእያ አሳይ ዳሮ ግድያ ግሾነ እስራኤለ አሳይ፥ ‘ኑኒ ኑ ዎልቃን ፆንዳ’ ግድ ታ ቦላ ጬቀቶና መላ ታኒ ምድያመታ ህንተ ኩሸን አꬃዳ እምከ። ");
INSERT INTO gofe_vpl VALUES ("JG7_3","008_7_3","JDG","7","3","3","ሄሳ ግሾ፥ አሳኮ፥ ‘ያይያ አስ ደእኮ ጋላዳ ዙማፐ ስሚድ ጉየ ባ ሶ ሶ ቦ’ ያጋዳ አዋጃ” ያግስ። ያትን፥ ላታማነ ናምኡ ሙኩሉ አሳይ ጉየ ስምን ታሙ ሙኩሉ አስ አትስ። ");
INSERT INTO gofe_vpl VALUES ("JG7_4","008_7_4","JDG","7","4","4","ግዶሽን፥ ጎዳይ ገድዮናኮ፥ “ሀእካ አሳይ ዳሮ። ነ ኤንታ ኤካዳ ዱገ ሻፋ ዎꬋ፤ ታኒ ኤንታ ያን ፓጫና። ታኒ፥ ‘ሀይስ ኔራ ቦ’ ገይስ ኔራ ቦ፤ ታኒ፥ ‘ሀይስ ኔራ ቦፖ’ ገይስ ቦፖ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG7_5","008_7_5","JDG","7","5","5","ገድዮን አሳ ሻፉ ኤክድ ብስ። ጎዳይ እያኮ፥ “ሀ አሳ ግዶፈ ጉልባትድ ሃ ኡየይሳታነ ካናዳ ሃ እንፃርሳን ኡየይሳታ ሻካ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG7_6","008_7_6","JDG","7","6","6","ባንታ ኩሸን ሃ ኡየይሳታ ታይቦይ ሄꬑ ፄታ፤ ሽን አትዳይሳት ኡባይ ሃ ጉልባትድ ኡይዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG7_7","008_7_7","JDG","7","7","7","ጎዳይ ገድዮናኮ፥ “ባንታ ኩሸን ሃ ኮጰትድ ኡይዳ ሄꬑ ፄቱ አሳታን ታኒ ህንተና አሻና፤ ምድያመታ ህንተዉ አꬃዳ እማና። ሽን አትዳ አሳ ኡባይ ባ ሶ ሶ ስሞ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG7_8","008_7_8","JDG","7","8","8","ሄሳ ግሾ፥ ገድዮን አሳታ ሽንቅያነ ኤንታ ሞይዝያ ኤክዳ ሄꬑ ፄቱ አሳታ ባራ አሽድ፥ ሀንኮ አሳ ኡባ ኤንታ ሶ ሶ የድስ። ሀ ኡባይ ሀንያ ዎደ ምድያመ ኦላንቾት ኤንታፈ ጋርሳ ባጋራ ደእያ ዛንጋራን ዱንካንድ ኡትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG7_9","008_7_9","JDG","7","9","9","ሄ ቃማ ጎዳይ ገድዮናኮ፥ “ታኒ ነዉ አꬃዳ እምዳ ግሾ ደንዳዳ ኤንቲ ዱንካንዳ በሳን ደእሽን ኦላ። ");
INSERT INTO gofe_vpl VALUES ("JG7_10","008_7_10","JDG","7","10","10","ኔኒ ኤንታ ኦላናዉ ያይኮ ነ ኦሳንቹዋ ፑራ ኤካዳ ኤንቲ ዱንካንዳ በሳ ዱገ ዎꬋ። ");
INSERT INTO gofe_vpl VALUES ("JG7_11","008_7_11","JDG","7","11","11","ኤንቲ ግያባ ስአ። ሄሳፈ ጉየ፥ ኔኒ ኤንታ ኦላናዉ ምኖተꬅ ደማና” ያግስ። ገድዮንነ እያ አይለይ ፑር፥ ምድያመት ዱንካንዳ በሳ ማታን ናግያ ኦላንቾታኮ ብዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG7_12","008_7_12","JDG","7","12","12","ሄ ዎደ ቦለዳ ዳርዳ ምድያመት፥ አማለቃትነ ዶሎሀ ባጋ አሳ ኡባይ ዛንጋራን ዱንካንድ ኡትዶሶና። ኤንታ ግማለት አባ ጋፃን ደእያ ሻፈ መላ ታይባናዉ ዳንዳኤተና። ");
INSERT INTO gofe_vpl VALUES ("JG7_13","008_7_13","JDG","7","13","13","ገድዮን ያ ጋክያ ዎደ እስ አደይ ባ አሙሁዋ ባ ላግያስ ኦድሽን ስእስ። ሄስካ፥ “እስ ባንጋ ኡይꬅ ኦኮለት ጋክድ ምድያመታ ዱንካንያ ዶምእስ፤ ዱንካነይ ሽረት ዎꬍድ ምጨትስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG7_14","008_7_14","JDG","7","14","14","እያ ላገይ ዛሪድ፥ “ሄስ እስራኤለ አድያ፥ እዮኣሳ ናኣ ገድዮና ማሻፈ አትሽን፥ ሀራባ ግደና። ፆሳይ ምድያመነ ምድያመታራ ደእያ ኦላንቾታ ኡባ ገድዮናስ አꬅድ እሚስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG7_15","008_7_15","JDG","7","15","15","ገድዮን ሄ አሙሁዋነ እያ ብርሸꬃ ስእዳ ዎደ ጉልባትድ ፆሳ ጎይንስ። እስራኤለ አሳይ ዱንካንዳ በሳ ጉየ ስሚድ፥ “ደንድተ፤ ጎዳይ ምድያመ ኦላንቾታ ህንተ ኩሸን አꬅድ እሚስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG7_16","008_7_16","JDG","7","16","16","ሄꬑ ፄቱ አሳታ ሄꬑ ጩጋን ሻክድ ኤንታዉ ሁጰን ሁጰን እስ እስ ሞይዘነ ግዶን ኤፅያ ፆምፐይ ደእያ እስ እስ ፃሮ እሚስ። ");
INSERT INTO gofe_vpl VALUES ("JG7_17","008_7_17","JDG","7","17","17","ገድዮን ኤንታኮ፥ “ታና ፄልተ፤ ታኒ ኤንቲ ዱንካንዳ በሳ ጋክያ ዎደ ኦይሳዳ ህንተካ ኦꬅተ። ");
INSERT INTO gofe_vpl VALUES ("JG7_18","008_7_18","JDG","7","18","18","ታነ ታራ ደኤይሳት ኡባይ ሞይዘ ፑንይ ዎደ ህንተካ ኤንቲ ዱንካንዳ በሳ ዩሹዋን ኤቅድ ሞይዘ ፑንሸ፥ ‘ጎዳሳነ ገድዮናሳ’ ያግድ ዋስተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG7_19","008_7_19","JDG","7","19","19","ግድ ብላሄ ግድያ ዎደ ናገይሳት ላመትዳፐ ጉየ ገድዮንነ እያራ ደእያ ፄቱ አሳት ብድ፥ ምድያመት ዱንካንዳ በሳ ጋክድ ባንታ ሞይዝያ ፑንዶሶና፤ ኦይክዳ ፃሩዋ መንꬅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG7_20","008_7_20","JDG","7","20","20","ሀራ ባጋራ ደእያ ናምኡ ጩጋይ ሄሳዳ ኦꬅዶሶና። ባንታ ሀድርሳ ኩሸን ኤፅያ ፆምፐ፥ ባንታ ኡሻቻ ኩሸን ሞይዘ ኦይክድ፥ “ጎዳነ ገድዮና ማሻ” ያግድ ዋስዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG7_21","008_7_21","JDG","7","21","21","አሳ ኡባይ ምድያመት ዱንካንዳ በሳ ዩሾን ባ በሳን በሳን ኤቅዳሽን፥ ምድያመ ኦላንቾት ኡባይ ዋስሸ ባቃትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG7_22","008_7_22","JDG","7","22","22","ሄꬑ ፄቱ አሳይ ባንታ ሞይዝያ ፑንዳ ዎደ ሞርከ ኦላንቾት ባንታ ማሻ እሶይ እሱዋ ቦላ ደንꬃና መላ ጎዳይ ኦꬅስ። አትዳ ኦላንቾት ፃራራኮ ስሚድ ቤት-ሽፃ ጋካናዉ፥ ያፐ አꬍድ፥ ፃባታ ማታን ደእያ አቤል-ማሆላ ጋካናዉ ባቃትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG7_23","008_7_23","JDG","7","23","23","ሄሳፈ ጉየ ንፍታለመ፥ አሴራነ ምናሰ ኮቻት ፄገትድ፥ ሺቅድ ምድያመታ የደꬅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG7_24","008_7_24","JDG","7","24","24","ደረይ ዳርያ ኤፍሬማ ቢታን ደእያ አሳኮ ገድዮን ኪትድ፥ “ምድያመታ ኦላናዉ ዱገ ዎꬍድ ቤት-ባራ ጋካናዉ ደእያ ዮርዳኖሰን ገልያ ሻፋታ ኤንታፈ ካሰትድ ኦይክተ” ያግስ። ኤፍሬማ አሳ ኡባይ ፄገትድ፥ ሺቅድ ቤት-ባራ ጋካናዉ ዮርዳኖሰን ገልያ ሻፋታ ኦይክዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG7_25","008_7_25","JDG","7","25","25","ኤንቲ ኦሬባነ ዘባ ጌተትያ ናምኡ ምድያመ ሀላቃታ ድእዶሶና። ኦሬባ፥ “ኦሬባ ዛላ” ጌተትያ በሳን፥ ቃስ ዘባ፥ “ዘባ ዎይነ ጉምእያ በሲ” ጌተትያ በሳን ዎꬍዶሶና። ሄሳፈ ጉየ፥ አትዳ ምድያመታ የደꬅድ፥ ኦሬባነ ዘባ ቆꬍያ ቃንፅድ ኤንታ ሁጵያ፥ ዮርዳኖሰ ሻፋፐ ሄፍንꬃን ደእያ ገድዮናኮ ኤህዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG8_1","008_8_1","JDG","8","1","1","ኤፍሬማ አሳይ ገድዮናኮ፥ “ምድያመታ ኦላናዉ ባሸ ኑና አይስ ፄጋብኪ? ኑ ቦላ ሄሳ መላባ አይስ ኦꬃዲ?” ያግድ ይሎትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG8_2","008_8_2","JDG","8","2","2","ሽን ገድዮን፥ “ህንተ ኦꬅዳይስ ታ ኦꬅዳይሳፈ አኔ? ታ ኮቻይ አብኤዘር ሺሽዳ ካꬃፈ ህንተ ኤፍሬማ ኮቻት ቆርዳ ቡይ አኔ? ");
INSERT INTO gofe_vpl VALUES ("JG8_3","008_8_3","JDG","8","3","3","ምድያመ ሀላቃታ፥ ኦሬባነ ዘባ ፆሳይ ህንተ ኩሸን አꬅድ እሚስ። ህንተ ኦꬅዳይሳ መላ ታኒ አይ ኦꬃናዉ ዳንዳእያና?” ያግስ። እ ያግን ኤንቲ ዛርብዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG8_4","008_8_4","JDG","8","4","4","ገድዮንነ እያራ ደእያ ሄꬑ ፄቱ አሳይ ዮርዳኖሰ ሻፋ ፕንዶሶና። ኤንቲ አይ ዳቡርኮካ ባንታ ሞርከታ የደꬆ አግቦኮና። ");
INSERT INTO gofe_vpl VALUES ("JG8_5","008_8_5","JDG","8","5","5","ኤንቲ ሱኮታ ጋክዳ ዎደ ገድዮን ሄ ካታማ አሳኮ፥ “ታ አሳይ ዳቡርዳ ግሾ፥ ሀያና ጉꬃ ካꬅ እመርከት። ታኒ ምድያመ ካዎታ ዘባነ ሳልሞና የደꬃሸ ደአይስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG8_6","008_8_6","JDG","8","6","6","ሱኮታ ካታማ ሀላቃት፥ “ዘባነ ሳልሞና ኔኒ ድአባካሽን ነ ኦላንቾታስ አይስ ካꬅ እማኔ?” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG8_7","008_8_7","JDG","8","7","7","ገድዮን፥ “ሎኦ አይኮይ ባዋ፤ ጎዳይ ዘባነ ሳልሞና ታ ኩሸን አꬅድ እምያ ዎደ ታኒ ባዞ አጉንꬃንነ ፁንዱቀን ህንተና ዋꬋና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG8_8","008_8_8","JDG","8","8","8","ያፐ ደንድድ ፓኑኤላ ብድ፥ ያን ደእያ አሳካ ሄ ኦይሻ ኦይችን፥ ፓኑኤላ አሳይ ሱኮታ አሳይ ዛርዳይሳዳ ዛርዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG8_9","008_8_9","JDG","8","9","9","እ ፓኑኤላ አሳኮ፥ “ታኒ ፆናዳ ሳሮ ስምያ ዎደ ህንተ ካታማ ናግያ ሀ አዱሳ ግምብያ ላላና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG8_10","008_8_10","JDG","8","10","10","ሄ ዎደ ዘብነ ሳልሞን ዶሎሀ ባጋፈ ይዳ ኦላንቾታፐ አትዳ 15,000 ኦላንቾታራ ቃርቆራን ደኦሶና። ኤንታፈ 120,000 ኦላንቾት ኦላን ሀይቅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG8_11","008_8_11","JDG","8","11","11","ገድዮን ኖባፐነ ዮግባፐ ዶሎሀ ባጋን ደእያ ባዞ ኦግያራ ብድ፥ ያን ደእያ ኦላንቾት ቆፖና ደእሽን ኦላ ደንꬅስ። ");
INSERT INTO gofe_vpl VALUES ("JG8_12","008_8_12","JDG","8","12","12","ናምኡ ምድያመ ካዎት ዘብነ ሳልሞን ባቃትዶሶና፤ ሽን ገድዮን ኤንታ የደꬅ ጋክድ ድእስ። ኤንታ ኦላንቾት ኡባይ ዎልቃማ ዳጋማን ኩንድዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG8_13","008_8_13","JDG","8","13","13","እዮኣሳ ናአይ ገድዮን ሄሬሳ ባጋራ ኦላፐ ስምስ። ");
INSERT INTO gofe_vpl VALUES ("JG8_14","008_8_14","JDG","8","14","14","ሱኮታፐ እስ ናአተꬃ ናኣ ኦይክድ ኦይችስ። ሄ ናአይ ላፑን ታማነ ላፑን ሱኮታ ሀላቃታነ ጭማታ ሱንꬃ ፃፍድ እያዉ እሚስ። ");
INSERT INTO gofe_vpl VALUES ("JG8_15","008_8_15","JDG","8","15","15","ሄሳፈ ጉየ፥ ገድዮን ሱኮታ ይድ፥ “ ‘ዘባነ ሳልሞና ኔኒ ድአባካሽን፥ ዳቡርዳ ነ አሳስ አይስ ካꬅ እማኔ?’ ግድ ታ ቦላ ቀልቅስደታ፤ ሽን ዘባነ ሳልሞና ሀይሳ በእተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG8_16","008_8_16","JDG","8","16","16","ገድዮን ባዞ አጉንꬅነ ፁንዱቀ ኤክድ ሱኮታ ሀላቃታ ዋꬍስ። ");
INSERT INTO gofe_vpl VALUES ("JG8_17","008_8_17","JDG","8","17","17","ቃስ ፓኑኤላን ካታማ አዱሳ ግምበ ሻኩዋ ላልድ ካታማን ደእያ አደታ ዎꬍስ። ");
INSERT INTO gofe_vpl VALUES ("JG8_18","008_8_18","JDG","8","18","18","ያትድ ገድዮን ዘባነ ሳልሞና፥ “ህንተ ታቦረን አይ መላ አስ ዎꬍደቲ?” ያግድ ኦይችስ። ኤንቲ፥ “ነ መላ አስ፤ ኤንቲ ካዎ ናአ ዳኖሶና” ያግድ ዛርዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG8_19","008_8_19","JDG","8","19","19","ገድዮን፥ “ኤንቲ ታ እሻታ፤ ኤንቲ ታ አየ ናይታ። ደኦ ፆሲ ኤርያ መላ ኤንታ ህንተ ዎꬎናባ ግድያኮ ታ ህንተና ዎꬍከሽን” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG8_20","008_8_20","JDG","8","20","20","ባ ባይራ ናኣ የተራኮ፥ “ደንዳዳ፥ ሀይሳታ ዎꬋ” ያግስ። የተር ቡሮ ዮጋ ግድያ ግሾ ያይድ ባ ማሻ ሾድቤና። ");
INSERT INTO gofe_vpl VALUES ("JG8_21","008_8_21","JDG","8","21","21","ዘብነ ሳልሞን ገድዮናኮ፥ “ህዛ ነ ኑና ዎꬋ፤ አደ ኦሶ ኦꬃናዉ አደ ኮሼስ” ያግዶሶና። ያትን፥ ገድዮን ኤንታ ዎꬍስ፤ ኤንታ ግማለታ ቆን ደእያ አሌቆ ኡባ ኤክስ። ");
INSERT INTO gofe_vpl VALUES ("JG8_22","008_8_22","JDG","8","22","22","እስራኤለ አሳይ ገድዮናኮ፥ “ኔኒ ኑና ምድያመታፐ አሽዳ ግሾ ኔኒ፥ ነ ናአይነ ነ ናኣ ናአይ ኑና ሃርተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG8_23","008_8_23","JDG","8","23","23","ሽን ገድዮን፥ “ታኒ ህንተና ሃርከ፤ ታ ናአይካ ህንተና ሃረና፤ ጎዳይ ህንተና ሃራና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG8_24","008_8_24","JDG","8","24","24","እ ኤንታኮ፥ “ታ ህንተና እስባ ኦይቻይስ፤ ህንተ ኡባይ ድእድ ኤህዳ ሀይꬃ ዎርቅያፈ ታዉ እምተ” ያግስ። (እስማኤላ አሳስ ሀይꬃን ዎርቃ አሶይ ዎጋ።) ");
INSERT INTO gofe_vpl VALUES ("JG8_25","008_8_25","JDG","8","25","25","እስራኤለ አሳይ ዛሪድ፥ “ኤሮ፥ ኡፋይትድ እማና” ያግዶሶና። አፍላ ሂፅድ፥ አሳ ኡባይ ድእድ ኤህዳ ሀይꬃ ዎርቅያ የግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG8_26","008_8_26","JDG","8","26","26","ገድዮን ኤክዳ ሀይꬃ ዎርቀይ ላታሙ ክሎ ግራመ ዴፄስ። ሄስካ፥ ሀራ አሌቆታ፥ ቆን አꬅያ ጎዝዳታ፥ ምድያመ ካዎት ማእያ ኦቻ ቴራ ዳንያ ማኦታነ ኤንታ ግማለታ ቆꬍያፐ ኤከትዳ አሌቆታ ጉጆናሽና። ");
INSERT INTO gofe_vpl VALUES ("JG8_27","008_8_27","JDG","8","27","27","ገድዮን ዎርቃ ኤቃ ምስልያ ጊግስድ፥ ባ ደእያ ኦፍራ ካታማን ዎꬅስ። እስራኤለ አሳ ኡባይ ጎዳ አግድ ሄ ኤቃ ምስልያ ጎይንዶሶና፤ ሄስ ገድዮናስነ እያ ሶ አሳስ ፅሄ ግድስ። ");
INSERT INTO gofe_vpl VALUES ("JG8_28","008_8_28","JDG","8","28","28","ሄሳዳ ሀንድ፥ ምድያመ አሳይ እስራኤለ አሳስ ሃረትስ፤ ኤንቲ እስራኤለ አሳ ቦላ ናምአንꬆ ደንድቦኮና። ገድዮን ሀይቃና ጋካናዉ ኦይታሙ ላይꬅ ቢታይ ዎፑ ግድ ደእስ። ");
INSERT INTO gofe_vpl VALUES ("JG8_29","008_8_29","JDG","8","29","29","የሩባኣላ ጌተትያ ገድዮን፥ እዮኣሳ ናአይ ባ ሶ ስሚድ ደእስ። ");
INSERT INTO gofe_vpl VALUES ("JG8_30","008_8_30","JDG","8","30","30","ገድዮን ዳሮ ማቾ ኤክዳ ግሾ፥ እያዉ ላፑን ታሙ አደ ናይት የለትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG8_31","008_8_31","JDG","8","31","31","ሴከማን ደእያ ላገꬅያ እያዉ አደ ናኣ የልን፥ እያ ሱንꬃ አብመለከ ያግድ ሱንꬅስ። ");
INSERT INTO gofe_vpl VALUES ("JG8_32","008_8_32","JDG","8","32","32","እዮኣሳ ናአይ ገድዮን ሎኦ ጭምድ ሀይቅስ፤ ባ አዋ እዮኣሳ ዱፎን ሞገትስ። ሄ ዱፎይ አበዜራ ኮቻት ደእያ ኦፍራን ደኤስ። ");
INSERT INTO gofe_vpl VALUES ("JG8_33","008_8_33","JDG","8","33","33","ገድዮን ሀይቅዳፐ ጉየ፥ እስራኤለ አሳይ ጎዳ አግድ ባኣለ ፆሳታ ጎይንዶሶና። ባኣል-ብሪታ ጌተትያ ኤቃ ባንታዉ ፆሰ ኦꬅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG8_34","008_8_34","JDG","8","34","34","እስራኤለ አሳይ ባንታ ዩሹዋን ደእያ ሞርከታ ኡባፈ ኤንታ አሽዳ ጎዳ ባንታ ፆሳ ሀሳይቦኮና። ");
INSERT INTO gofe_vpl VALUES ("JG8_35","008_8_35","JDG","8","35","35","እስራኤለ አሳስ ኦꬅዳ ሎኦ ኦሱዋ ግሾ የሩባኣላ ጌተትያ ገድዮና ሶ አሳስ ሎኦ ኩሸ ዛርቦኮና። ");
INSERT INTO gofe_vpl VALUES ("JG9_1","008_9_1","JDG","9","1","1","ገድዮና ናአይ፥ አብመለከይ ሴከማን ደእያ ባ አየ ዳቦታኮ ብድ፥ ኤንታነ ባ አየ ኮቻታ ሀይሳዳ ያግስ፤ ");
INSERT INTO gofe_vpl VALUES ("JG9_2","008_9_2","JDG","9","2","2","“ሴከማን ደእያ አሳ፥ ‘ገድዮና ላፑን ታሙ ናይት ኡባይ ህንተና ሃርኮ ሎኦዬ? ዎይኮ እስ አስ ሃርኮ ሎኦ?’ ያግድ ኦይችተ። ታኒ ህንተ አሾነ ህንተ መቀꬅ ግደይሳ ዶጎፕተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG9_3","008_9_3","JDG","9","3","3","እያ አየ ዳቦት ሀ ቃላ ኡባ እያ ግሾ ሴከማ አሳስ ኦድን፥ አብመለከይ ኤንታዉ ዳቦ ግድዳ ግሾ ሴከማ አሳይ እያ ካላናዉ ዶስዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG9_4","008_9_4","JDG","9","4","4","ኤንቲ ባኣል-ብሪታ ኤቃ ኬꬃፈ ላፑን ታሙ ብራ ሳንትመ ኤክድ እያዉ እምዶሶና። አብመለከይ ሄ ብራን ኢታ አሳታነ ቦንቀይሳታ ሻምድ ባና ካላናዳ ኦꬅስ። ");
INSERT INTO gofe_vpl VALUES ("JG9_5","008_9_5","JDG","9","5","5","ኦፍራን ደእያ ባ አዋ ሶ ብድ፥ ላፑን ታሙ ባ እሻታ ገድዮና ናይታ፥ እስ ሹቻ ቦላ ጎይርስ። ሽን ገድዮና ናአይ፥ ተሾይ፥ እዮአታም ቆሰትድ ሀይቆና አትስ። ");
INSERT INTO gofe_vpl VALUES ("JG9_6","008_9_6","JDG","9","6","6","ሄሳፈ ጉየ፥ ሴከማ አሳይነ ቤት-ምሎ አሳይ እስፈ ሺቅድ፥ ሴከማን ኤቃ ቱሳ ማታን ደእያ ጎይኖ ዎላኮ ብድ ያን አብመለከ ካዎꬅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG9_7","008_9_7","JDG","9","7","7","እዮአታም ሄሳ ስእዳ ዎደ ጋርዛና ደርያ ቦላ ከይድ ባ ቃላ ꬎቁ ኦꬅድ፥ “ህንተኖ ሴከማ አሳዉ፥ ፆሳይ ህንተና ስአና መላ ታ ኦደይሳ ስእተ። ");
INSERT INTO gofe_vpl VALUES ("JG9_8","008_9_8","JDG","9","8","8","እስ ጋላስ ምꬃት ኡባይ ሺቅድ፥ ባንታ ቦላ ካዎ ካዎꬃናዉ ብድ ሻማሆ፥ ‘ሃያ፥ ኑ ቦላ ካዎታ’ ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG9_9","008_9_9","JDG","9","9","9","ሽን ሻማሆይ፥ ‘ፆሳታነ አሳታ ቦንችስያ ዛይተ እመይሳ አጋዳ ምꬃታ ቦላ ካዎቶ?’ ያግድ ዛርስ። ");
INSERT INTO gofe_vpl VALUES ("JG9_10","008_9_10","JDG","9","10","10","“ያትን፥ ምꬃት ባላሰ ምꬃ፥ ‘ሃያ፥ ኑ ቦላ ካዎታ’ ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG9_11","008_9_11","JDG","9","11","11","ሽን ባላሰይ፥ ‘ማልኦነ ሎኦ ግድዳ አይፈ እመይሳ አጋዳ ምꬃታ ቦላ ካዎታናዉ ቦ?’ ያግድ ዛርስ። ");
INSERT INTO gofe_vpl VALUES ("JG9_12","008_9_12","JDG","9","12","12","“ያትን፥ ምꬃት ዎይነኮ፥ ‘ሃያ፥ ኑ ቦላ ካዎታ’ ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG9_13","008_9_13","JDG","9","13","13","ሽን ዎይነይ፥ ‘ፆሳታነ አሳታ ኡፋይስያ ኡሻ እመይሳ አጋዳ ምꬃታ ቦላ ካዎታናዉ ቦ?’ ያግድ ዛርስ። ");
INSERT INTO gofe_vpl VALUES ("JG9_14","008_9_14","JDG","9","14","14","“ያትን፥ ዉርሰꬃን ምꬃት ኡባይ ፁንዱቀኮ፥ ‘ሃያ፥ ኑ ቦላ ካዎታ’ ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG9_15","008_9_15","JDG","9","15","15","ፁንዱቀይ፥ ‘ህንተ ቱማ ታና ህንተ ቦላ ካዎꬃናዉ ኮይኮ፥ ሃ ይድ ታ ኩያን ሸምፕተ። ሄሳ ህንተ እፅኮ፥ ፁንዱቀ ታሽያፐ ታም ከይድ ልባኖሰ ዝጋ ሞ’ ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG9_16","008_9_16","JDG","9","16","16","“ህንተ አብመለከ ካዎꬅዳይ ቱማተꬃንነ ሱረተꬃኔ? ገድዮን ህንተዉ ኦꬅዳባ አኬክድ እያ ሶ አሳስ ሎኦ ኩሸ ዛርደቲ? ");
INSERT INTO gofe_vpl VALUES ("JG9_17","008_9_17","JDG","9","17","17","ታ አዋይ ህንተዉ ኦለትዳይሳ አኬክተ፤ ምድያመ አሳፐ ህንተና አሻና ያግድ፥ ባና ሀይቆስ አꬅድ እሚስ። ");
INSERT INTO gofe_vpl VALUES ("JG9_18","008_9_18","JDG","9","18","18","ሽን ህንተ ሀች ታ አዋ ሶ አሳ ቦላ ደንድድ፥ እያ ላፑን ታሙ ናይታ እስ ሹቻ ቦላ ጎይርደታ። ገድዮና አይለፈ የለትዳ አብመለከይ ህንተዉ ዳቦ ግድዳ ግሾ ሴከማን ካዎꬅደታ። ");
INSERT INTO gofe_vpl VALUES ("JG9_19","008_9_19","JDG","9","19","19","ሀእ ስሚድ ገድዮናስነ እያ ሶ አሳስ ህንተ ኦꬅዳ ኦሶይ ቱማተꬃንነ ሱረተꬃን ግድኮ አብመለከራ ኡፋይትተ፤ እካ ህንተራ ኡፋይቶ። ");
INSERT INTO gofe_vpl VALUES ("JG9_20","008_9_20","JDG","9","20","20","ሽን ሄስ ሀኖና እፅኮ አብመለከፐ ታም ከይድ ሴከማነ ቤት-ምሎ አሳ ሞ። ቃስ ሴከማ አሳፐነ ቤት-ምሎ አሳፐ ታም ከይድ አብመለከ ሞ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG9_21","008_9_21","JDG","9","21","21","እዮአታም ባ እሻ አብመለከስ ያይዳ ግሾ ባቃትድ ቤራ ብድ ያን ደእስ። ");
INSERT INTO gofe_vpl VALUES ("JG9_22","008_9_22","JDG","9","22","22","አብመለከይ እስራኤለ ቢታን ሄꬑ ላይꬅ ካዎትስ። ");
INSERT INTO gofe_vpl VALUES ("JG9_23","008_9_23","JDG","9","23","23","ሄሳፈ ጉየ፥ ፆሳይ አብመለከ ግዶንነ ሴከማ አሳ ግዶን ኢታ አያና ኪትን ሴከማ አሳይ አብመለከ ቦላ ማካልዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG9_24","008_9_24","JDG","9","24","24","ፆሳይ ሄሳ ኦꬅዳይ፥ አብመለከይ ባ እሻታ ዎꬍዳ ግሾነ ኤንታ ዎꬋና መላ ሴከማ አሳይ እያ ምንꬅዳ ግሾሳ። ");
INSERT INTO gofe_vpl VALUES ("JG9_25","008_9_25","JDG","9","25","25","ሴከማ አሳይ ጉꬃ አስ ዶርድ ደርያ ሁጵያን ኡትድ አብመለከ ቦላ ሞርከተꬃን ደንዳና መላ ኦꬅዶሶና። ኤንቲ ኦገራ አꬍያ አሳ ኡባ ቦንቅዶሶና፤ አብመለከይ ሄሳ ስእስ። ");
INSERT INTO gofe_vpl VALUES ("JG9_26","008_9_26","JDG","9","26","26","ሄ ዎደ ኤቤዳ ናአይ ጋል ባ እሻታራ ሴከማ ይን፥ ሴከማ አሳይ እያን አማነትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG9_27","008_9_27","JDG","9","27","27","ኡባይ ባንታ ጋደ ብድ ዎይነ ማፅዶሶና፤ ዎይንያ አግድ ግታ ግብራ ጊግስዶሶና። ባንታ ኤቃ ኬꬃ ገልድ ያን ምሸነ ኡይሸ አብመለከ ጫይዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG9_28","008_9_28","JDG","9","28","28","ኤቤዳ ናአይ ጋል፥ “ኑኒ ሴከማ አሳይ እያዉ ሃረታናዉ አብመለከይ ኦኔ? እ የሩባኣላ ናኣ ግደኔ? ዛቡል ሀ ካታማ ሃራና መላ አብመለከይ ሹምዳይሳ ግደኔ? ሄሳፈ ሴከማ ሼሽ ግድዳ ሀሞረ አሳስ ሃረታና። ");
INSERT INTO gofe_vpl VALUES ("JG9_29","008_9_29","JDG","9","29","29","ሀ አሳ ካለይ ታና ግድያኮ አብመለከ ድጋናሽን። አብመለከ ፄጋዳ፥ ‘ነ ኦላንቾታ ዳርሳ ኤካዳ ኦለታናዉ ሃያ’ ያጋናሽን” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG9_30","008_9_30","JDG","9","30","30","ኤቤዳ ናአይ ጋል ግዳይሳ ካታማ ሃርያ ዛቡል ስእዳ ዎደ ዳሮ ይሎትስ። ");
INSERT INTO gofe_vpl VALUES ("JG9_31","008_9_31","JDG","9","31","31","ቆሳን አብመለከኮ አሰ ኪትድ፥ “ኤቤዳ ናአይ ጋልነ እያ እሻት ሴከማ ይድ ያን ደእያ አሳ ነ ቦላ ደንꬆሶና። ");
INSERT INTO gofe_vpl VALUES ("JG9_32","008_9_32","JDG","9","32","32","ሄሳ ግሾ፥ ኔንነ ኔራ ደእያ አሳይ ቃማ ደንድድ እስ በሳን ዙግድ ናግተ። ");
INSERT INTO gofe_vpl VALUES ("JG9_33","008_9_33","JDG","9","33","33","ዎንተꬃ ጋላስ አው ዶልያ ዎደ ኤንቲ ቆፖና ካታማ ኦልተ። ጋልነ እያራ ደእያ አሳይ ህንተና ኦላናዉ ከይያ ዎደ ህንተ ኮይዳ መላ ኤንታ ቦላ ኦꬅተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG9_34","008_9_34","JDG","9","34","34","አብመለከይነ እያራ ደእያ አሳ ኡባይ ቃማ ደንድድ ሴከማፐ ካረራ ኦይዱ ጩጋን ሻከትድ ዙግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG9_35","008_9_35","JDG","9","35","35","አብመለከይነ እያራ ደእያ አሳይ ኤቤዳ ናአይ ጋል ከይድ ካታማ ፐንግያን ኤቅዳይሳ በእድ ቆሰትዳ በሳፈ ከይዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG9_36","008_9_36","JDG","9","36","36","ጋል አሳ በእዳ ዎደ ዛቡላኮ፥ “ሄኮ፥ አሳይ ደርያ ሁጵያፐ ዎꬌስ” ያግስ። ዛቡል፥ “ሀይስ ደርያ ኤሾፐ አትሽን፥ አሰ ግደና” ያግድ ዛርስ። ");
INSERT INTO gofe_vpl VALUES ("JG9_37","008_9_37","JDG","9","37","37","ጋል ዛሪድ፥ “ሄኮ፥ አሳይ ደርያስ ግዱዋ ኦይክድ ዎꬌስ፤ ሀራ ጩግ ቃስ ማሮታ ዎላይ ደእያ ኦግያራ ዬስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG9_38","008_9_38","JDG","9","38","38","ዛቡል ጋላኮ፥ “ ‘ኑኒ እያዉ ሃረታናዉ አብመለከይ ኦኔ?’ ያግዳ ነ ዶናይ ሀእ አዉ ብዴ? ሀይሳቲ ኔኒ ካꬍዳ አሳ ግዶኮናዬ? ሀእ ከያዳ ኤንታራ ኦለታ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG9_39","008_9_39","JDG","9","39","39","ጋል ሴከማ አሳ ካለꬅ ከይድ አብመለከራ ኦለትስ። ");
INSERT INTO gofe_vpl VALUES ("JG9_40","008_9_40","JDG","9","40","40","አብመለከይ የደꬅን ጋል ባቃትስ፤ ካታማ ፐንግያ ጋካናዉ ዳሮት ደሸትድ ኩንድዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG9_41","008_9_41","JDG","9","41","41","አብመለከይ አሩማን ደእን፥ ዛቡል ጋላነ እያ እሻታ ሴከማፐ የደꬅድ ከስስ። ");
INSERT INTO gofe_vpl VALUES ("JG9_42","008_9_42","JDG","9","42","42","ዎንተꬃ ጋላስ ሴከማ አሳይ ጎሻስ ብዳይሳ አብመለከይ ስእስ። ");
INSERT INTO gofe_vpl VALUES ("JG9_43","008_9_43","JDG","9","43","43","እ ባ አሳ ኤክድ ሄꬑ ጩጋን ሻክድ፥ እስ በሳን ዙግድ ናጋናዳ ኦꬅስ። አሳይ ካታማፐ ከየይሳ በእዳ ዎደ ኤንታ ዎꬋናዉ ቆሰትዳ በሳፈ ከይስ። ");
INSERT INTO gofe_vpl VALUES ("JG9_44","008_9_44","JDG","9","44","44","አብመለከይነ እያራ ደእያ ጩጋይ ስን ዎፅ ብድ፥ ካታማ ፐንግያን ኤቅዶሶና። አትዳ ናምኡ ጩጋይ ጎሻን ደእያ አሳ ኦልድ ዎꬍዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG9_45","008_9_45","JDG","9","45","45","ጋላስ ኩመꬅ አብመለከይ አሳራ ኦለትድ ኦይክዳፐ ጉየ ካታማን ደእያ አሳ ኡባ ዎꬍስ፤ ካታማ ꬋይስስ፤ ቢታ ቦላ ማፅነ ላልስ። ");
INSERT INTO gofe_vpl VALUES ("JG9_46","008_9_46","JDG","9","46","46","ሴከማ አዱሳ ግምብያ ግዶን ደእያ አሳ ኡባይ ሄሳ ስእዳ ዎደ ባኣል-ባርታ ኤቃ ኬꬃን ደእያ ጎንጎሉዋን ቆሰትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG9_47","008_9_47","JDG","9","47","47","አብመለከይ ኤንቲ ያን ሺቅዳይሳ፥ ");
INSERT INTO gofe_vpl VALUES ("JG9_48","008_9_48","JDG","9","48","48","ስእድ እነ እያራ ደእያ አሳ ኡባይ ሳልሞና ደርያ ከይዶሶና። አብመለከይ ካልታ ኤክድ ምꬃ ታሸ ቃንፅድ፥ ባ ሀሽያን ቶክስ። ባራ ደእያ አሳኮ፥ “ታኒ ኦꬅሽን በእዳይሳዳ ህንተ ኤለስድ ኦꬅተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG9_49","008_9_49","JDG","9","49","49","አሳ ኡባይ ምꬃ ታሸ ቃንፅ ኤክድ፥ አብመለከ ካልስ። ሄ ታሸታ ሳአ ኬꬃ ቦላ ዶርድ አሳይ እያ ግዶን ደእሽን ታማ ኦይꬅዶሶና። እያን ደእያ አሳ ኡባይ ሀይቅዶሶና። ሀይቅዳ አደይነ ማጫሳ ታይቦይ እስ ሙኩሉ ግዳና። ");
INSERT INTO gofe_vpl VALUES ("JG9_50","008_9_50","JDG","9","50","50","አብመለከይ ተሜሳ ብድ ካታማ ተቅድ ኦይክስ። ");
INSERT INTO gofe_vpl VALUES ("JG9_51","008_9_51","JDG","9","51","51","ሄ ካታማ ግዶን እስ ምኖ አዱሳ ግምበይ ደኤስ። ካታማ አሳይ ማጭ፥ አደይ፥ ካለይሳትነ ሀራ አሳ ኡባይ አቶና ዎፅድ አዱሳ ግምብያ ግዶ ገልዶሶና። ፐንግያ ጎርድድ ግምብያ ሁጰ ከይዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG9_52","008_9_52","JDG","9","52","52","አብመለከይ ኦልሸ አዱሳ ግምብያ ጋክድ ታማን ፁጋናዉ ፐንግያኮ ሺቅስ። ");
INSERT INTO gofe_vpl VALUES ("JG9_53","008_9_53","JDG","9","53","53","ሽን እስ ማጫስያ አብመለከ ሁጰን ዎፃ ማይደ ሆላዳ እያ ጉግያ ጳልቃ የጋሱ። ");
INSERT INTO gofe_vpl VALUES ("JG9_54","008_9_54","JDG","9","54","54","እያ ኦላ ሚሽያ ቶክያ ናአተꬃ ኤለስ ፄግድ፥ “አብመለከ ማጫስ ዎꬍስ ጎናዳ ነ ማሻ ሾዳዳ ታና ዎꬋ” ያግስ። ያግን ናአተꬃይ ጫድን እ ሀይቅስ። ");
INSERT INTO gofe_vpl VALUES ("JG9_55","008_9_55","JDG","9","55","55","እስራኤለ አሳ ኡባይ አብመለከይ ሀይቅዳይሳ በእድ ባ ሶ ሶ ብስ። ");
INSERT INTO gofe_vpl VALUES ("JG9_56","008_9_56","JDG","9","56","56","አብመለከይ ላፑን ታሙ ባ እሻታ ዎꬍድ፥ ባ አዋ ቦላ እ ኦꬅዳ ጎምያ ፆሳይ እያ ቦላ ዛርስ። ");
INSERT INTO gofe_vpl VALUES ("JG9_57","008_9_57","JDG","9","57","57","ፆሳይ ሴከማ አሳ ኢታተꬃ ኡባ ኤንታ ቦላ ዛርስ። ሄሳዳ ሀንድ ገድዮና ናአይ እዮአታም ባድዳ ባደꬃይ ኤንታ ጋክስ። ");
INSERT INTO gofe_vpl VALUES ("JG10_1","008_10_1","JDG","10","1","1","አብመለከይ ሀይቅዳፐ ጉየ፥ ይሳኮራ ኮቸ ግድዳ ዶዳ ናኣ፥ ፑሀ ናአይ ቶል፥ እስራኤለ አሳ አሻናዉ ደንድስ። እ ደረይ ዳርያ ኤፍሬማ ቢታን ሳምራን ደእስ። ");
INSERT INTO gofe_vpl VALUES ("JG10_2","008_10_2","JDG","10","2","2","ቶል እስራኤለ አሳ ላታማነ ሄꬑ ላይꬅ አይስስ። ቶል ሀይቅድ፥ ሳምራን ሞገትስ። ");
INSERT INTO gofe_vpl VALUES ("JG10_3","008_10_3","JDG","10","3","3","ቶላፐ ካልድ፥ ጋላዳ አደይ ያእር ደንድስ። እ እስራኤለ አሳ ላታማነ ናምኡ ላይꬅ አይስስ። ");
INSERT INTO gofe_vpl VALUES ("JG10_4","008_10_4","JDG","10","4","4","እያዉ ሀስታሙ ባቁሎ ቶግያ ሀስታሙ አደ ናይት ደኦሶና። ኤንታዉ ጋላዳ ቢታን ሀስታሙ ካታማት ደኦሶና። ሄ ካታማት ሀች ጋካናዉ ያእራ ካታማታ ጌተትድ ፄገቶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG10_5","008_10_5","JDG","10","5","5","ያእር ሀይቅድ ቃሞናን ሞገትስ። ");
INSERT INTO gofe_vpl VALUES ("JG10_6","008_10_6","JDG","10","6","6","ቃስካ እስራኤለ አሳይ ጎዳ ስንꬃን ኢታባ ኦꬅዶሶና። ኤንቲ ባኣለነ አስታሮታ ኤቃታ፥ ሶረ ፆሳታ፥ ስዶና ፆሳታ፥ ሞአበ ፆሳታ፥ አሞነ ፆሳታነ ፍልስፄመ ፆሳታ ጎይንዶሶና። ኤንቲ ጎዳ አጋግዶሶና፤ እያ ጎይንቦኮና። ");
INSERT INTO gofe_vpl VALUES ("JG10_7","008_10_7","JDG","10","7","7","ጎዳይ እስራኤለ አሳ ቦላ ሀንቀትድ፥ ኤንታ ፍልስፄመ አሳስነ አሞነ አሳስ አꬅድ እሚስ። ");
INSERT INTO gofe_vpl VALUES ("JG10_8","008_10_8","JDG","10","8","8","ሄ ላይꬅ ፍልስፄመትነ አሞነት እስራኤለ አሳ ኡንኤꬅዶሶና። ዮርዳኖሰ ሻፋፐ ዶሎሀ ባጋን፥ አሞረት ካሰ ደእዳ ጋላዳ ቢታን ደእያ እስራኤለ አሳ ኤንቲ ታማነ ሆስፑን ላይꬅ ሃርዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG10_9","008_10_9","JDG","10","9","9","ቃስካ አሞነ አሳይ ይሁዳ፥ ብንያመነ ኤፍሬማ ኮቻታ ኦላናዉ ዮርዳኖሰ ሻፋ ፕንዶሶና፤ እስራኤለ አሳይ ዳሮ ኡንኤትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG10_10","008_10_10","JDG","10","10","10","ሄሳፈ ጉየ፥ እስራኤለ አሳይ፥ “ኑኒ ነና ኑ ፆሳ አግድ፥ ባኣለ ጎይንድ፥ ናጋራ ኦꬅዳ” ያግድ ጎዳኮ ዋስዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG10_11","008_10_11","JDG","10","11","11","ጎዳይ ኤንታኮ፥ “ግብፀት፥ አሞረት፥ አሞነት፥ ፍልስፄመት፥ ");
INSERT INTO gofe_vpl VALUES ("JG10_12","008_10_12","JDG","10","12","12","ስዶናት፥ አማለቃትነ ሞኣነት ህንተና ኡንኤꬅን፥ ህንተ ታኮ ዋስን፥ ታኒ ህንተና ኤንታ ኩሸፐ አሻብክና? ");
INSERT INTO gofe_vpl VALUES ("JG10_13","008_10_13","JDG","10","13","13","ሽን ህንተ ታና አግድ ሀራ ፆሳታ ጎይንደታ፤ ህዛፐ ታኒ ህንተና አሽከ። ");
INSERT INTO gofe_vpl VALUES ("JG10_14","008_10_14","JDG","10","14","14","ብድ ህንተ ዶርዳ ፆሳኮ ዋስተ። ህንተና መቶይ ጋክያ ዎደ አነ ኤንቲ አሾ” ያግድ ዛርስ። ");
INSERT INTO gofe_vpl VALUES ("JG10_15","008_10_15","JDG","10","15","15","ሽን እስራኤለ አሳይ ዛሪድ ጎዳኮ፥ “ኑኒ ናጋራ ኦꬅዳ። ነ ኮይዳባ ኑ ቦላ ኦꬃ፤ ሽን ሀያና ሀች ኑና አሻ” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG10_16","008_10_16","JDG","10","16","16","አላጋ ፆሳታ ባንታ ግዶፈ ድግድ፥ ጎዳ ጎይንዶሶና። ጎዳይ እስራኤለ አሳ ኡንኤተꬃ በእድ ምሸትስ። ");
INSERT INTO gofe_vpl VALUES ("JG10_17","008_10_17","JDG","10","17","17","ሄሳፈ ጉየ፥ አሞነ ኦላንቾት ኦላስ ጊግድ፥ ጋላዳን ሺቅዶሶና። እስራኤለ አሳይ እስፈ ሺቅድ ጋላዳን ምፅጳን ዱንካንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG10_18","008_10_18","JDG","10","18","18","ጋላዳ ቢታ ሀላቃት ባንታ ግዶን፥ “አሞነ ኦላንቾታራ ኮይሮትድ ኦላ ጋሄታናይ ኦኔ? ሄ አደይ ጋላዳ ቢታን ደእያ አሳ ኡባስ ሀላቃ ግዳና” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG11_1","008_11_1","JDG","11","1","1","ጋላዳ ቢታን ደእያ ዮፍታሄይ ምኖ ኦላንቾ። እያ አዋ ሱንꬃይ ጋላዳ፤ ሽን እያ አይያ ላይማ ማጫስ። ");
INSERT INTO gofe_vpl VALUES ("JG11_2","008_11_2","JDG","11","2","2","ጋላዳ ማችያ እያዉ አደ ናይታ የላሱ። ኤንቲ ድጭድ ጋክዳ ዎደ ባንታ እሻ ዮፍታሄ፥ “ኔኒ ሀራ ማጫሳፐ የለትዳ ናአ ግድያ ግሾ ኑ አዋ አቁዋፐ አይኮካ ላታካ” ያግድ ሶፐ የደꬅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG11_3","008_11_3","JDG","11","3","3","ያትን፥ ዮፍታሄይ ባ እሻታፐ ባቃትድ፥ ቶባ ቢታን ደእስ። ያን እ ደእሽን ጉꬃ ዎራንꬖት እያኮ ሺቅድ እያ ካልዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG11_4","008_11_4","JDG","11","4","4","ጉꬃ ዎደፐ ጉየ አሞነት እስራኤለታራ ኦለትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG11_5","008_11_5","JDG","11","5","5","አሞነት እስራኤለታራ ኦለትዳ ዎደ ጋላዳ ቢታ ጭማት ቶባፐ ዮፍታሄ ዛሪድ ኤሀናዉ ብዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG11_6","008_11_6","JDG","11","6","6","ኤንቲ እያኮ፥ “አሞነታ ኑኒ ኦላና መላ ያዳ ኑስ ሀላቃ ግዳ” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG11_7","008_11_7","JDG","11","7","7","ሽን ዮፍታሄይ፥ “ታና እፅድ፥ ታ አዋ ኬꬃፈ የደꬅቤከቲ? ሀእ ህንተና መቶይ ጋክን ታኮ አይስ ይደቲ?” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG11_8","008_11_8","JDG","11","8","8","ጋላዳ ጭማት፥ “ግዶሽን ሀእ ኑኒ ኔኮ ስምዳ፤ ኔኒ ኦላ ካለꬃዳ አሞነታ ኑስ ኦላና መላነ ጋላዳ ቢታስ ሀላቃ ግዳና መላ ኮዮስ” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG11_9","008_11_9","JDG","11","9","9","ዮፍታሄይ፥ “አሞነታራ ኦለታና መላ ህንተ ታና ጉየ ዛርን፥ ጎዳይ ኤንታ ታ ኩሸን አꬅድ እምኮ፥ ህንተ ቱማ ታና ሀላቃ ኦꬃኔ?” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG11_10","008_11_10","JDG","11","10","10","ጋላዳ ጭማት፥ “ጎዳይ ኑ ግዶን ማርካ፤ ኔኒ ግያባ ኑ ኦꬃና” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG11_11","008_11_11","JDG","11","11","11","ዮፍታሄይ ጋላዳ ጭማታራ ብስ፤ ኤንቲ እያ ባንታ ሀላቃነ ካለይሳ ኦꬅዶሶና። ዮፍታሄይ ምፅጳን ጎዳ ስንꬃን ዛሪድ ቃላ ገልስ። ");
INSERT INTO gofe_vpl VALUES ("JG11_12","008_11_12","JDG","11","12","12","ዮፍታሄይ አሞነ ካዋኮ አሰ ኪትድ፥ “ኔኒ ኑ ቢታ ኦላና መላ ኑኒ ነዉ አይ ኦꬅዶ?” ያግድ ኦይችስ። ");
INSERT INTO gofe_vpl VALUES ("JG11_13","008_11_13","JDG","11","13","13","አሞነ ካዎይ ዮፍታሄይ ኪትዳ አሳኮ፥ “እስራኤለ አሳይ ግብፀፈ ከይዳ ዎደ አርኖና ሻፋፐነ ያቦቃ ሻፋፐ ግዶን፥ ዮርዳኖሰ ሻፋ ጋካናዉ ደእያ ታ ቢታ ኤክዶሶና። ሀእ ታ ቢታ ታዉ ሳሮን ዛርተ” ያግድ ዛርስ። ");
INSERT INTO gofe_vpl VALUES ("JG11_14","008_11_14","JDG","11","14","14","ዮፍታሄይ ናምአንꬆ አሞነ ካዋኮ አሰ ኪትስ። ");
INSERT INTO gofe_vpl VALUES ("JG11_15","008_11_15","JDG","11","15","15","ኪተትዳ አሳይ፥ “እስራኤለ አሳይ ሞአበ ቢታ ዎይኮ አሞነ ቢታ ኤክቤና። ");
INSERT INTO gofe_vpl VALUES ("JG11_16","008_11_16","JDG","11","16","16","እስራኤለ አሳይ ግብፀፈ ከይዳ ዎደ ባዞ ካንꬅ ብድ፥ ዞኦ አባ ጋክስ፤ ያፐ ቃደሳ ብስ። ");
INSERT INTO gofe_vpl VALUES ("JG11_17","008_11_17","JDG","11","17","17","እስራኤለ አሳይ ኤዶመ ካዋኮ፥ ‘ነ ቢታራ ኑና አꬃርኪ?’ ያግድ አሰ ኪትስ፤ ሽን ኤዶመ ካዎይ አꬆና እፅስ። ሄሳዳካ፥ ሞአበ ካዋኮ ኪትን፥ እካ አꬆና እፅስ፤ ያትን፥ እስራኤለ አሳይ ቃደሳን ጋምእስ። ");
INSERT INTO gofe_vpl VALUES ("JG11_18","008_11_18","JDG","11","18","18","“ዉርሰꬃን ኤንቲ ባዙዋ ካንꬅድ፥ ኤዶመነ ሞአበ ቢታ ጋፃ ኦይክድ፥ ሞአበ ቢታፈ ዶሎሀ ባጋራ ይድ አርኖና ሻፋፐ ሄፍንꬃ ባጋን ዱንካንዶሶና። ሽን አርኖና ሻፋይ ሞአበ ዛዋ ግድዳ ግሾ ሞአበ ባጋ ፕንቦኮና። ");
INSERT INTO gofe_vpl VALUES ("JG11_19","008_11_19","JDG","11","19","19","“ሄሳፈ ጉየ፥ እስራኤለ አሳይ ሀሰቦና ካታማን ደእያ አሞረታ ካዋ ስሆናኮ አሰ ኪትድ፥ ‘ሀያና፥ ነ ቢታራ ኑና አꬃርክ’ ያግድ ኦይችስ። ");
INSERT INTO gofe_vpl VALUES ("JG11_20","008_11_20","JDG","11","20","20","ሽን ስሆነይ እስራኤለ አሳ አማነቶና ግሾ አꬃናዉ ኮይቤና። እ ባ ኦላንቾታ ኤክድ ያሃፃን ዱንካንድ እስራኤለ አሳ ኦልስ። ");
INSERT INTO gofe_vpl VALUES ("JG11_21","008_11_21","JDG","11","21","21","ጎዳይ እስራኤለ ፆሳይ ስሆናነ እያ ኦላንቾታ እስራኤለ አሳ ኩሸን አꬅድ እምን፥ ኤንታ ፆንዶሶና። ያን ደእያ አሞረታ ቢታ ኡባ ላትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG11_22","008_11_22","JDG","11","22","22","አርኖና ሻፋፐ ብድ ያቦቃ ሻፋ ጋካናዉ፥ ባዙዋፈ ብድ ዮርዳኖሰ ሻፋ ጋካናዉ ደእያ አሞረታ ቢታ ኡባ ኤክዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG11_23","008_11_23","JDG","11","23","23","“ሄሳዳ ኦꬅድ ጎዳይ፥ እስራኤለ ፆሳይ ባ አሳ እስራኤለ ስንꬃፈ አሞረታ የደꬅድ ꬋይስስ። ያትን፥ ኔኒ ዛራዳ ነዉ ኤካናዉ ዋታ ቆፓይ? ");
INSERT INTO gofe_vpl VALUES ("JG11_24","008_11_24","JDG","11","24","24","ኔኒ ነ ፆሳይ ካሞሽ ነዉ እመይሳ ኤክኪ? ሽን ኑኒ፥ ጎዳይ ኑ ፆሳይ ኑስ እምዳባ ኡባ ላትድ ዳና። ");
INSERT INTO gofe_vpl VALUES ("JG11_25","008_11_25","JDG","11","25","25","ግዶሽን ኔኒ ስፎራ ናኣ፥ ሞአበ ካዋ ባላቃፐ ምናይ? እ እስራኤለ አሳራ ኦየትደ ዎይኮ ኦለትዴ? ");
INSERT INTO gofe_vpl VALUES ("JG11_26","008_11_26","JDG","11","26","26","እስራኤለ አሳይ ሀሰቦና፥ አሮኤራነ ኤንታ ዩሹዋን ደእያ ጉታታ ኡባ፥ ቃስ አርኖና ሻፋ ማታን ደእያ ካታማታ ኡባ ላትድ ሄꬑ ፄቱ ላይꬅ ደእስ። ያትን፥ ሄ ዎደ አይስ ዎꬃ ኤካብኪ? ");
INSERT INTO gofe_vpl VALUES ("JG11_27","008_11_27","JDG","11","27","27","ታኒ ህንተና አይኮካ ቆሀብከ፤ ሽን ታና ኦላናዉ ደንዳዳ ናቀይ ነና። ፕርድያ ጎዳይ ሀች እስራኤለፐነ አሞነፐ ግዶን ፕርዶ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG11_28","008_11_28","JDG","11","28","28","ሽን ዮፍታሄይ ኪትዳ ኪታ አሞነታ ካዎይ ስኦና እፅስ። ");
INSERT INTO gofe_vpl VALUES ("JG11_29","008_11_29","JDG","11","29","29","ሄ ዎደ ጎዳ አያናይ ዮፍታሄ ቦላ ዎꬍን፥ ጋላዳነ ምናሰ ቢታ ካንꬅ ብድ፥ ጋላዳ ቢታን ደእያ ምፅጳ ስምስ። ያፐ ኦላንቾታ ካለꬅድ አሞነ ቢታ ብስ። ");
INSERT INTO gofe_vpl VALUES ("JG11_30","008_11_30","JDG","11","30","30","ዮፍታሄይ ጎዳስ ቃንገትድ፥ “ኔኒ አሞነታ ታ ኩሸን አꬃዳ እምኮ፥ ");
INSERT INTO gofe_vpl VALUES ("JG11_31","008_11_31","JDG","11","31","31","ታኒ ኦላ ፆናዳ ሶ ስምያ ዎደ ታና ሞካናዉ ታ ሶፐ ከይያ አይብካ ኔሳ፤ ታኒ እያ ፁግያ ያርሾ ኦꬃዳ ነዉ ሺሻና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG11_32","008_11_32","JDG","11","32","32","ሄሳፈ ጉየ፥ ዮፍታሄይ አሞነታ ኦላናዉ ዛዋ ብን፥ ጎዳይ ኤንታ እያ ኩሸን አꬅድ እሚስ። ");
INSERT INTO gofe_vpl VALUES ("JG11_33","008_11_33","JDG","11","33","33","አሮኤራፐ ብድ ምንታነ አቤል-ክራምማ ጋካናዉ ደእያ ላታሙ ካታማታ ኦልድ ꬋይስስ፤ ዳሮ አሳ ዎꬍስ። ሄሳፈ ጉየ፥ አሞነት እስራኤለታስ ሃረትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG11_34","008_11_34","JDG","11","34","34","ዮፍታሄይ ባ ሶ ምፅጳ ስምያ ዎደ እያ ናእያ ካራቦ ኦይካዳ የፃሸነ ዱራሸ እያ ሞካናዉ ከያሱ። እያዉ ኢፐ አትሽን፥ ሀራ ናእ ባዋ። ");
INSERT INTO gofe_vpl VALUES ("JG11_35","008_11_35","JDG","11","35","35","እ እዮ በእዳ ዎደ አዛንድ ባ ማኡዋ ዳክድ፥ “ሀይ ታ ናተ! ታና ካዉሻዳሳ፤ ታና መቶን የጋዳሳ። ታኒ ጎዳስ ቃንጋስ፤ ጋꬆና አጋናዉ ዳንዳእከ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG11_36","008_11_36","JDG","11","36","36","ናእያ፥ “ታ አዋዉ፥ ኔኒ ጎዳስ ቃንግዳባ ግድኮ፥ ጎዳይ ነ ሞርከታ፥ አሞነታ ቦላ ኔኒ ሀሎ ከይዳ ግሾ ነ ቃንግዳባ ታ ቦላ ፖላ” ያጋሱ። ");
INSERT INTO gofe_vpl VALUES ("JG11_37","008_11_37","JDG","11","37","37","ሽን እያ ባ አዋኮ፥ “ታዉ እስባ ኦꬃርክ። ታኒ አዝና ገሎና አትያ ግሾ፥ ታ ላገታራ ባዳ ዙማ ቦላ ታ ጌላኦተꬃስ ዬካና መላ ናምኡ አጌናስ ታና የዳርክ” ያጋዳ ኦይቻሱ። ");
INSERT INTO gofe_vpl VALUES ("JG11_38","008_11_38","JDG","11","38","38","እ፥ “ባ” ያግድ፥ ናምኡ አጌናስ እዮ የድስ። እያ ባ ላገታራ ዙማ ቦላ ከያዳ ባ ጌላኦተꬃስ ኤንታራ ዬካሱ። ");
INSERT INTO gofe_vpl VALUES ("JG11_39","008_11_39","JDG","11","39","39","ናምኡ አጌናፐ ጉየ፥ ባ አዋኮ ስማዳ ያሱ። እ አዋይ ጎዳስ ቃንግዳ ባ ቃንገꬃ ጋꬅስ፤ እያ ጌላኦሽን ሀይቃሱ። ሄ ዎደፐ ዶምድ፥ ");
INSERT INTO gofe_vpl VALUES ("JG11_40","008_11_40","JDG","11","40","40","እስራኤለ ማጫ ናይት ላይꬃን ላይꬃን ኦይዱ ጋላስ ባንታ ሶፐ ሃክ ብድ፥ ጋላዳ አድያ ዮፍታሄ ናኤስ ዬከይስነ ካዮተይስ ሜዘ ግድስ። ");
INSERT INTO gofe_vpl VALUES ("JG12_1","008_12_1","JDG","12","1","1","ኤፍሬማ አሳይ ኦላ ባናዉ ፄገትድ፥ ዮርዳኖሰ ሻፋ ፕንድ፥ ፃፎና ጋክዳ ዎደ ዮፍታሄኮ፥ “አሞነታ ኦላናዉ ዛዋ ፕናዳ ባሸ ኑኒ ኔራ ባና መላ አይስ ፄጋብኪ? ኑኒ ነ ቦላ ጎርድድ ነ ኬꬃን ታማ የዳና” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG12_2","008_12_2","JDG","12","2","2","ዮፍታሄይ ኤንታኮ፥ “ታንነ ታ አሳይ አሞነታራ ዳሮ ባፀን ገልዳ ዎደ ህንተና ፄጋስ፤ ሽን ህንተ ታና ኤንታፈ አሽበከታ። ");
INSERT INTO gofe_vpl VALUES ("JG12_3","008_12_3","JDG","12","3","3","ህንተ ታና አሾናይሳ በእዳ ዎደ ዛዋ ፕናዳ ታ ሸምፑዋስ ቃቶና አሞነታ ኦላናዉ ባስ፤ ጎዳይ ኤንታ ታ ኩሸን አꬅድ እሚስ። ያትን፥ ህንተ ሀች አይስ ታና ኦላናዉ ይደቲ?” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG12_4","008_12_4","JDG","12","4","4","ዮፍታሄይ ጋላዳ አሳ ኡባ ሺሽድ፥ ኤፍሬማ አሳራ ኦለትን ጋላዳ አሳይ ፆንዶሶና። ኤፍሬማ አሳይ ካሰ ኤንታ፥ “ህንተ ጋላዳ አሳይ ካሰ ኤፍሬማነ ምናሰ ኮቻታ ካድድ ይዳይሳታ ግደከቲ?” ያጎሶና። ");
INSERT INTO gofe_vpl VALUES ("JG12_5","008_12_5","JDG","12","5","5","ኤፍሬማ አሳይ ከስ ኤኮናዳ ዮርዳኖሰ ሻፋ ፕኑዋ ኡባ ጋላዳት ኦይክዶሶና። ከስ ኤካናዉ ኮይያ ኤፍሬማ አስ ፕናናዉ ኦይችያ ዎደ ጋላዳት፥ “ኔኒ ኤፍሬማ አሴ?” ያግድ ኦይቾሶና። እ፥ “ግድከ” ጊኮ፥ ");
INSERT INTO gofe_vpl VALUES ("JG12_6","008_12_6","JDG","12","6","6","ኤንቲ፥ “አነ፥ ‘ሽቦሌተ’ ጋ” ያጎሶና። ሽን እ፥ “ሽ” ጌተትያ ፕዳልያ ሎይꬅ ፄጋናዉ ዳንዳኦና ግሾ፥ “ስቦሌተ” ያጌስ። እ ሄሳ ግያ ዎደ ኦይክድ፥ ዮርዳኖሰ ሻፋ ፕንያ በሳን ዎꬎኦሶና። ሄ ዎደ ያን ኤፍሬማ አሳፐ ኦይታማነ ናምኡ ሙኩሉ አሳይ ሀይቅስ። ");
INSERT INTO gofe_vpl VALUES ("JG12_7","008_12_7","JDG","12","7","7","ዮፍታሄይ እስራኤለ አሳ ኡሱፑን ላይꬅ አይስስ። ጋላዳ አደይ ዮፍታሄይ ሀይቅድ ጋላዳን ደእያ እስ ካታማን ሞገትስ። ");
INSERT INTO gofe_vpl VALUES ("JG12_8","008_12_8","JDG","12","8","8","ዮፍታሄፐ ካልድ፥ ቤተለመን እብፃን እስራኤለ አሳ ሃርስ። ");
INSERT INTO gofe_vpl VALUES ("JG12_9","008_12_9","JDG","12","9","9","እብፃናስ ሀስታሙ አደ ናይትነ ሀስታሙ ማጫ ናይት ደኦሶና። እ ባ ማጫ ናይታ ባ ኮቸ ግዶና አደ ናይታስ እሚስ፤ ባ አደ ናይታስ ባ ኮቸ ግዶና ማጫ ናይታ ጊግስድ እሚስ። እብፃን እስራኤለ ላፑን ላይꬅ አይስስ። ");
INSERT INTO gofe_vpl VALUES ("JG12_10","008_12_10","JDG","12","10","10","ሄሳፈ ጉየ፥ እብፃን ሀይቅድ ቤተለመን ሞገትስ። ");
INSERT INTO gofe_vpl VALUES ("JG12_11","008_12_11","JDG","12","11","11","እብፃናፐ ካልድ ዛብሎና ኮቸ ግድዳ ኤሎን እስራኤለ አሳ ታሙ ላይꬅ ሃርስ። ");
INSERT INTO gofe_vpl VALUES ("JG12_12","008_12_12","JDG","12","12","12","ሄሳፈ ጉየ ኤሎን ሀይቅድ ዛብሎና ቢታን ደእያ አያሎናን ሞገትስ። ");
INSERT INTO gofe_vpl VALUES ("JG12_13","008_12_13","JDG","12","13","13","ኤሎናፐ ካልድ፥ ፕራቶና አደይ፥ ህላላ ናአይ አብዶን እስራኤለ አይስስ። ");
INSERT INTO gofe_vpl VALUES ("JG12_14","008_12_14","JDG","12","14","14","አብዶናስ ላፑን ታሙ ባቁሎታ ቶግያ ኦይታሙ አደ ናይትነ ሀስታሙ ናአ ናእ ደኤስ። አብዶን እስራኤለ ሆስፑን ላይꬅ አይስስ። ");
INSERT INTO gofe_vpl VALUES ("JG12_15","008_12_15","JDG","12","15","15","ሄሳፈ ጉየ፥ ህላላ ናአይ አብዶን ሀይቅድ ደረይ ዳርያ አማለቃን፥ ኤፍሬማ ቢታን፥ ፕራቶና ጌተትያ ዱፎን ሞገትስ። ");
INSERT INTO gofe_vpl VALUES ("JG13_1","008_13_1","JDG","13","1","1","እስራኤለ አሳይ ጎዳ ስንꬃን ቃስካ ኢታባ ኦꬅዶሶና። ያትን፥ ጎዳይ ኤንታ ኦይታሙ ላይꬅ ፍልስፄመ አሳ ኩሸን አꬅድ እሚስ። ");
INSERT INTO gofe_vpl VALUES ("JG13_2","008_13_2","JDG","13","2","2","ሄ ዎደ ፆርአ ካታማን ማኑሄ ጌተትያ እስ አደይ ደኤስ። እ ዳነ ኮቸ፤ እያ ማችያ ማይንꬅ ግድዳ ግሾ እያዉ ናአ የላቡኩ። ");
INSERT INTO gofe_vpl VALUES ("JG13_3","008_13_3","JDG","13","3","3","እስ ጋላስ ጎዳ ኪታንቾይ ሄ ማጫሴስ ቆንጭድ፥ “ኔኒ ማይንꬅ፤ ነዉ ናእ ባዋ፤ ሽን ነ ቃንꬃታና፤ አደ ናአካ የላና። ");
INSERT INTO gofe_vpl VALUES ("JG13_4","008_13_4","JDG","13","4","4","ሄሳ ግሾ፥ ዎይነ ዎይኮ ማꬆይያ ኡሽ ኡዮና መላነ ቱናባ አይባካ ሞና መላ ናገታ። ");
INSERT INTO gofe_vpl VALUES ("JG13_5","008_13_5","JDG","13","5","5","ነ ቃንꬃታዳ አደ ናአ የላና። ናአይ የለትዳ ዎድያፐ ዶምድ ፆሳስ ዱማትዳ ናዝራወ ግድያ ግሾ እያ ሁጵያ ሜዶፓ። እ እስራኤለ ፍልስፄመታ ኩሸፐ አሾ ዶማና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG13_6","008_13_6","JDG","13","6","6","ማጫስያ ባዳ፥ ባ አዝናስ ሀይሳዳ ያጋዳ ኦዳሱ፤ “እስ ፆሳ አስ ታኮ ይስ፤ እያ መꬎይ ፆሳ ኪታንቾ መላ ዳሮ ያሼስ። እ አዉፐ ይዳኮ ታኒ እያ ኦይቻብከ፤ እካ ባ ሱንꬃ ታዉ ኦድቤና። ");
INSERT INTO gofe_vpl VALUES ("JG13_7","008_13_7","JDG","13","7","7","ሽን እ ታኮ፥ ‘ነ ቃንꬃታና፤ አደ ናአ የላና። ናአይ የለትዳ ዎደፐ ዶምድ ሀይቃና ጋካናዉ ፆሳስ ዱማትዳ ናዝራወ ግድያ ግሾ ዎይነ ዎይኮ ማꬆይያ ኡሽ ኡዮፓ፤ ቱናባካ ሞፓ’ ያግስ” ያጋሱ። ");
INSERT INTO gofe_vpl VALUES ("JG13_8","008_13_8","JDG","13","8","8","ሄሳፈ ጉየ፥ ማኑሄይ፥ “አቤት ጎዳዉ፥ ናአይ የለትያ ዎደ አይ ኦꬃናዉ ኮሽያኮ ኤርሳና መላ ኔኒ ኪትዳ ፆሳ ኡራይ ኑኮ ስሚድ ያና መላ ኦꬃርክ” ያግድ ጎዳ ዎስስ። ");
INSERT INTO gofe_vpl VALUES ("JG13_9","008_13_9","JDG","13","9","9","ፆሳይ ማኑሄ ዎሳ ስእስ። ማችያ ጋደን ኡትዳሽን ፆሳ ኪታንቾይ ናምአንꬆ ይስ፤ ሽን ሄ ዎደ እ አዝናይ ማኑሄይ ኢራ ዴና። ");
INSERT INTO gofe_vpl VALUES ("JG13_10","008_13_10","JDG","13","10","10","ማችያ ኤለሳዳ ባ አዝናኮ ባዳ፥ “ሄደ ታኮ ይዳ አደይ ሀች ታዉ ቆንጭስ” ያጋሱ። ");
INSERT INTO gofe_vpl VALUES ("JG13_11","008_13_11","JDG","13","11","11","ማኑሄይ ኡትዳ በሳፈ ደንድድ፥ ባ ማችዉ ካል ብድ ኡራኮ፥ “ታ ማቸራ ኦደትዳይ ነኔ?” ያግድ ኦይችስ። ኡራይ፥ “ኤ፥ ታና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG13_12","008_13_12","JDG","13","12","12","ማኑሄይ፥ “ኔኒ ኦድዳ ቃላይ ፖለትያ ዎደ የለታና ናኣ ደኡዋስነ ኦሱዋስ ዎጋይ አይቤ?” ያግድ እያ ኦይችስ። ");
INSERT INTO gofe_vpl VALUES ("JG13_13","008_13_13","JDG","13","13","13","ጎዳ ኪታንቾይ፥ “ነ ማችያ ታኒ ኦድዳ ኡባፈ ናገቶ። ");
INSERT INTO gofe_vpl VALUES ("JG13_14","008_13_14","JDG","13","14","14","ዎይነ ምꬃፈ በንትያባ አይባካ ሞፖ፤ ዎይነ ዎይኮ ማꬆይያ ኡሽ ኡዮፖ፤ ቱና ግድዳባ ሞፖ። ታኒ እዉ ኦድዳ ኡባ ኦꬆ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG13_15","008_13_15","JDG","13","15","15","ማኑሄይ ጎዳ ኪታንቹዋኮ፥ “ኑኒ ነዉ እስ ኡርገ ዴሽ ሹክድ ጊግሳና ጋካናዉ ሀያና ጉꬁ ጋምአርክ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG13_16","008_13_16","JDG","13","16","16","ጎዳ ኪታንቾይ፥ “ታኒ ጋምእያኮካ ነ ካꬃ ሚከ። ሽን ኔኒ ፁሳ ያርሾ ጊግሳናዉ ኮይኮ፥ ጎዳስ ያርሻናዉ ዳንዳኣሳ” ያግስ። እ ጎዳ ኪታንቾ ግደይሳ ማኑሄይ ኤርቤና። ");
INSERT INTO gofe_vpl VALUES ("JG13_17","008_13_17","JDG","13","17","17","ማኑሄይ ጎዳ ኪታንቹዋኮ፥ “ኔኒ ኦድዳ ቃላይ ፖለትያ ዎደ ኑኒ ነና ቦንቻና መላ ነ ሱንꬃይ ኦኔ?” ያግድ ኦይችስ። ");
INSERT INTO gofe_vpl VALUES ("JG13_18","008_13_18","JDG","13","18","18","ጎዳ ኪታንቾይ፥ “ነ ታ ሱንꬃ አይስ ኦይቻይ? ታ ሱንꬃይ ማላልሰይሳ” ያግድ ዛርስ። ");
INSERT INTO gofe_vpl VALUES ("JG13_19","008_13_19","JDG","13","19","19","ማኑሄይ ኡርገ ዴሽነ ካꬃ ያርሹዋ ኤክድ ሹቻ ቦላ ጎዳስ ያርሽስ። ማኑሄይነ እያ ማችያ ፄልሽን፥ ጎዳይ ማላልስያባ ኦꬅስ። ");
INSERT INTO gofe_vpl VALUES ("JG13_20","008_13_20","JDG","13","20","20","ያርሾ በሳፈ ታማ ላጮይ ፑደ ላፅድ ከይሽን፥ ጎዳ ኪታንቾይ ታማ ላጩዋ ግዶራ ሳሎ ከይስ። ማኑሄይነ እያ ማችያ ሄሳ በእድ ሶምኦራ ሳአን ጉፋንዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG13_21","008_13_21","JDG","13","21","21","ጎዳ ኪታንቾይ ማኑሄስነ እያ ማቼስ ዛር በንቶና አግን፥ ማኑሄይ እ ጎዳ ኪታንቾ ግድዳይሳ ሄ ዎደ አኬክስ። ");
INSERT INTO gofe_vpl VALUES ("JG13_22","008_13_22","JDG","13","22","22","ማኑሄይ ባ ማቸኮ፥ “ኑኒ ፆሳ በእዳ ግሾ ሀይቃና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG13_23","008_13_23","JDG","13","23","23","ሽን እያ ማችያ፥ “ጎዳይ ኑና ዎꬋናዉ ኮይዳባ ግድያኮ፥ ፁሳ ያርሹዋነ ካꬃ ያርሹዋ ኑፐ ኤከና ዎይኮ ሀ ኡባ ኑና በሰና ዎይኮ ሀይሳ ኑስ ኦደና” ያጋዳ ዛራሱ። ");
INSERT INTO gofe_vpl VALUES ("JG13_24","008_13_24","JDG","13","24","24","ማችያ አደ ናአ የላሱ፤ እያ ሱንꬃ ሳምሶና ጋዳ ፄጋሱ። ናአይ ድጭስ፤ ጎዳይካ እያ አንጅስ። ");
INSERT INTO gofe_vpl VALUES ("JG13_25","008_13_25","JDG","13","25","25","ናአይ ፆርአፈነ ኤሽታኦላፐ ግዶን ደእያ ዳነ ጉታን ደእሽን ጎዳ አያናይ እያ ደንꬆ ዶምስ። ");
INSERT INTO gofe_vpl VALUES ("JG14_1","008_14_1","JDG","14","1","1","እስ ጋላስ ሳምሶን ትምና ዎꬍስ፤ ያን እስ ፍልስፄመ ጌላእዉ በእስ። ");
INSERT INTO gofe_vpl VALUES ("JG14_2","008_14_2","JDG","14","2","2","እ ሶ ስሚድ ባ አዋነ ባ አይዉ፥ “ታኒ ትምናን እስ ፍልስፄመ ጌላእዉ በአስ፤ ሀእ እዮ ታዉ ኦይችድ እምተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG14_3","008_14_3","JDG","14","3","3","ሽን እያ አዋነ አይያ፥ “ማቾ ኦይቻናዉ ሀ ቃፃረትቦና ፍልስፄመታኮ ባናዉ ነና አይ ኮሽዴ? ኑ ኮቻ ግዶን ዎይኮ ኑ አሳ ኡባ ግዶን ነዉ ሀንያ ማጫ ናአ ደማናዉ ዳንዳአብኪ?” ያግድ ኦይችዶሶና። ሽን ሳምሶን ባ አዋኮ፥ “ታኒ እዮ ዶስዳ ግሾ፥ እዮ ኦይቻዳ ታዉ እማ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG14_4","008_14_4","JDG","14","4","4","ፍልስፄመታ ኦላናዉ ጎዳይ ጋሶ ኮይድ፥ ሄሳ ኤንታ ቦላ ኦይሳ ሳምሶና አዋይነ አይያ ኤርቦኮና። ሄ ዎደ ፍልስፄመት እስራኤለታ ሃሮሶና። ");
INSERT INTO gofe_vpl VALUES ("JG14_5","008_14_5","JDG","14","5","5","ሳምሶን ባ አዋራነ ባ አየራ ትምና ዎꬍስ። ኤንቲ ትምና ዎይነ ጋደ ማታራ ካንꬅድ አꬍያ ዎደ እስ ዎዳላ ጋሞይ ጉድሸ እያ ቦላ ከይስ። ");
INSERT INTO gofe_vpl VALUES ("JG14_6","008_14_6","JDG","14","6","6","ሄ ዎደ ጎዳ አያናይ ሳምሶና ቦላ ዎልቃን ዎꬍስ፤ እ ዴሻ ማር ዱሰረይሳዳ ባ ኩሸን አይኮካ ኦይኮና ጋሙዋ ዱሰረꬅ የግስ። ባ ኦꬅዳይሳ ባ አዋስነ ባ አየስ ኦድቤና። ");
INSERT INTO gofe_vpl VALUES ("JG14_7","008_14_7","JDG","14","7","7","ሄሳፈ ጉየ ብድ ጌላእዉ ኦድስስ፤ እዮ ዶስስ። ");
INSERT INTO gofe_vpl VALUES ("JG14_8","008_14_8","JDG","14","8","8","ጉꬃ ዎደፐ ጉየ እዮ ኤካናዉ ያ ስሚድ ብስ። ኦግያ ብሸ ባ ዎꬍዳ ጋሞ ባዉታ በአናዉ ኦገፐ ጋፃ ከይድ ብያ ዎደ ጋሞ ባዉታ ግዶን ማꬅ ኤስ ኤስዳይሳ በእስ። ");
INSERT INTO gofe_vpl VALUES ("JG14_9","008_14_9","JDG","14","9","9","ሄ ኤሳፈ ጉꬃራ ቃንፅ ኤክድ ምሸ ኦግያ ብስ። ባ አዋነ ባ አይዉ ጋክድ፥ ባ ኦይክዳ ኤሳፈ ጉꬃራ እምን፥ ኤንትካ ምዶሶና። ሽን ሳምሶን ሄ ኤሳ ጋሞ ባዉታ ግዶፈ ኤክዳይሳ ኤንታዉ ኦድቤና። ");
INSERT INTO gofe_vpl VALUES ("JG14_10","008_14_10","JDG","14","10","10","እያ አዋይ ጌላእዉ በአናዉ እ ሶ ብን፥ ሳምሶን ያን ግብራ ጊግስስ። ሄሳ መላ ግብራይ ያጋኖን ናአተꬃት ኦꬅያ ሜዘትዳ ዎጋ። ");
INSERT INTO gofe_vpl VALUES ("JG14_11","008_14_11","JDG","14","11","11","ፍልስፄመ አሳይ እያ በእዳ ዎደ እያራ ጋምአና መላ ሀስታሙ ናአተꬃታ ዶርድ የድዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG14_12","008_14_12","JDG","14","12","12","ሳምሶን ኤንታ፥ “አነ ህንተ ኤርያኮ እስ ቃንእሸ ታ ህንተና ኦይቻና። ያጋኖይ ቦንቸትያ ላፑን ጋላሳ ግዶን ሀ ቃንእሽያ ብርሸꬃ ታዉ ህንተ ኦድያባ ግድኮ ታኒ ህንተዉ ሀስታሙ ሊኖ አፍላነ ሀስታሙ ኩመꬃ ማኦ እማና። ");
INSERT INTO gofe_vpl VALUES ("JG14_13","008_14_13","JDG","14","13","13","ሽን ህንተ ታዉ ብርሸꬃ ኦዳናዉ ዳንዳኦና እፅኮ ህንተ ታዉ ሀስታሙ ሊኖ አፍላነ ሀስታሙ ኩመꬃ ማኦ እሜታ” ያግድ ኦይችስ። ኤንቲ፥ “ኤሮ፥ ነ ቃንእሽያ ኑስ ኦዳ” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG14_14","008_14_14","JDG","14","14","14","እ፥ “መይሳፈ ሜተትያባይ በንትስ፤ ምኑዋ ጋርሳፈ ማልእያባይ ከይስ” ያግስ። ሄꬑ ጋላስ ጋካናዉ ኤንቲ ቃንእሽያ ብርሻናዉ ዳንዳእቦኮና። ");
INSERT INTO gofe_vpl VALUES ("JG14_15","008_14_15","JDG","14","15","15","ኦይዳንꬆ ጋላስ ኤንቲ ሳምሶና ማችዉ፥ “ነ አዝና ጭማዳ ቃንእሽያ ብርሸꬃ እ ኑስ ኦዳና መላ ኦꬃ። ሄስ ሀኖና እፅኮ፥ ኑኒ ነናነ ነ አዋ ኬꬃ ታማን ፁጋና። ህንተ ኑና ፄግዳይ ኑና ማንቅሳናሴ?” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG14_16","008_14_16","JDG","14","16","16","ያትን፥ ሳምሶና ማችያ ዬካሸ እያኮ ሺቃዳ፥ “ኔኒ ታና ዶሳካ፤ ነ ታና ዳሮ እፃሳ። ኔኒ ታ ቢታ አሳ ቃንእሸ ኦይቻዳ ብርሸꬃ ታዉ ኦዳባካ” ያጋሱ። እ ዛሪድ፥ “ሄሳ ታኒ ታ አዋስነ ታ አየስ ኦዳብከ። ያትን፥ ነዉ አይስ ኦዶ?” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG14_17","008_14_17","JDG","14","17","17","ያጋኖይ ቦንቸትያ ላፑን ጋላሳ ኡባን ዬካዳ ሸምፖ ድጋሱ። ላፑንꬃ ጋላስ ቃንእሽያ ብርሸꬃ እዉ ኦድስ፤ እያ ባዳ ባ ቢታ አሳስ ኦዳሱ። ");
INSERT INTO gofe_vpl VALUES ("JG14_18","008_14_18","JDG","14","18","18","ያትን፥ ላፑንꬃ ጋላስ አው ዉላናፐ ስን ካታማ አሳይ፥ “ኤሳፈ አꬍድ ማልእያባይ፥ ጋሞፈ አꬍድ ምንያባይ አይቤ?” ያግድ ቃንእሽያ ብርሸꬃ ኦድዶሶና። ሳምሶን ኤንታኮ፥ “ህንተ ታ ኡሰን ጎዮናባ ግድያኮ፥ ታ ቃንእሽያ ብርሸꬃ ኤረከታሽን” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG14_19","008_14_19","JDG","14","19","19","ሄሳፈ ጉየ፥ ጎዳ አያናይ እያ ቦላ ዎልቃን ዎꬍን፥ አስቃሎና ዎꬍድ፥ ሀስታሙ አስ ዎꬍስ። ኤንታ ማኡዋ ቃር ኤክድ ቃንእሽያ ብርሽዳ አሳስ እሚስ። ሀንዳባ ኡባን ዳሮ ሸነትድ ባ አዋ ሶ ስምስ። ");
INSERT INTO gofe_vpl VALUES ("JG14_20","008_14_20","JDG","14","20","20","ሳምሶና ማችያ ዋና ላዛንꬅ ግድዳ እያ ላግያስ እመታሱ። ");
INSERT INTO gofe_vpl VALUES ("JG15_1","008_15_1","JDG","15","1","1","ጉꬃ ዎደፐ ጉየ፥ ግስተ ጫካ ዎደ ሳምሶን ባ ማችዉ በአናዉ እስ ኡርገ ኮለ ኤክድ ብስ። ናኤ አዋኮ፥ “ታኒ ታ ማችያ ደእያ ክፍልያ ገላናዉ ኮያይስ” ያግስ። ሽን እ አዋይ እ ገሎናዳ ድግስ። ");
INSERT INTO gofe_vpl VALUES ("JG15_2","008_15_2","JDG","15","2","2","እ አዋይ ሳምሶናኮ፥ “ኔኒ እዮ እፅዳባ ዳንን እዮ ነ ላዛንꬃስ እማስ። ሽን እ፥ ካሎ ምችያ ኢፐ አꬋዳ ማላ ሎኦ ግደኬ? እዮ ኤካ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG15_3","008_15_3","JDG","15","3","3","ሳምሶን፥ “ታኒ ሀእ ፍልስፄመ አሳ ቦላ ኢታባ ኦꬅኮ ባላ ግድከ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG15_4","008_15_4","JDG","15","4","4","ሄሳፈ ጉየ፥ ብድ ሄꬑ ፄቱ ዎርካናታ ኦይክድ ናምኣ ናምአ ጎይና እስፈ ጋꬅ ቃችድ ጎይናታፐ ግዶን ፆምፐ ዎꬅድ ቃችስ። ");
INSERT INTO gofe_vpl VALUES ("JG15_5","008_15_5","JDG","15","5","5","ፆምፕያን ታማ ኦይꬅድ ቡሮ ጫከትቦና ፍልስፄመታ ካꬃ ግዶ ዎርካናታ የድስ። ታማይ ጫከትዳ ካꬃ፥ ኤቆን ደእያ ካꬃ፥ ዎይንያነ ሻማሁዋ ምስ። ");
INSERT INTO gofe_vpl VALUES ("JG15_6","008_15_6","JDG","15","6","6","ፍልስፄመት፥ “ሀይሳ ኦꬅዳይ ኦኔ?” ያግድ ኦይችዶሶና። አሳይ፥ “ሄሳ ኦꬅዳይ ሳምሶና። ትምና አስ ግድዳ እያ ቦሎይ፥ እያ ማችዉ እያ ላዛንꬃስ እምዳ ግሾ ሄሳ ኦꬅስ” ያግዶሶና። ፍልስፄመት ብድ እዮነ እ አዋ ታማን ፁግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG15_7","008_15_7","JDG","15","7","7","ሳምሶን ኤንታኮ፥ “ህንተ ሄሳ ኦꬅዳ ግሾ ታ ሀሎ ከዮና አግከ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG15_8","008_15_8","JDG","15","8","8","እ ኤንታ ዎልቃማ ኢታ ሾች ሾጭድ ዳሮታ ዎꬍስ። ሄሳፈ ጉየ ብድ፥ ኤታማ ጎንጎሉዋን ደእስ። ");
INSERT INTO gofe_vpl VALUES ("JG15_9","008_15_9","JDG","15","9","9","ፍልስፄመ አሳይ ይድ ይሁዳን ዱንካንድ ለሀ ካታማ ኦልስ። ");
INSERT INTO gofe_vpl VALUES ("JG15_10","008_15_10","JDG","15","10","10","ይሁዳ አሳይ፥ “አይስ ኑና ኦላናዉ ይደቲ?” ያግድ ኦይችዶሶና። ኤንቲ፥ “ኑኒ ሳምሶና ኦይክድ ቃቻናዉነ እ ኑ ቦላ ኦꬅዳይሳዳ እያ ቦላ ኦꬃናዉ ይዳ” ያግድ ዛርዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG15_11","008_15_11","JDG","15","11","11","ያትን፥ ይሁዳፐ ሄꬑ ሙኩሉ አሳይ ኤታማ ጎንጎሉዋ ብድ፥ ሳምሶና፥ “ኑና ሃረይ ፍልስፄመ ግደይሳ ኤርኪ? ያትን፥ ኑ ቦላ ሀይሳ መላ ፓላባ አይስ ኦꬃይ?” ያግዶሶና። እ ዛሪድ፥ “ኤንቲ ታ ቦላ ኦꬅዳይሳዳ ታንካ ኤንታ ቦላ ኦꬃስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG15_12","008_15_12","JDG","15","12","12","ኤንቲ ዛሪድ፥ “ኑኒ ይዳይ ነና ቃችድ፥ ፍልስፄመታስ አꬅድ እማናሳ” ያግዶሶና። ሳምሶን ዛሪድ፥ “ህንተ ኑ ነና ዎꬎኮ ግድ ታዉ ጫቅተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG15_13","008_15_13","JDG","15","13","13","ኤንቲ፥ “ኤሮ፥ ኑኒ ነና ቃችድ ኤንታዉ አꬅድ እማናፐ አትሽን፥ ዎꬎኮ” ያግድ ዛርዶሶና። ሄሳ ግሾ፥ ናምኡ ኦራꬃ ዎዶሮን ቃችድ ጎንጎሉዋፐ ከስድ ኤፍዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG15_14","008_15_14","JDG","15","14","14","ሳምሶን ለሀ ብዳ ዎደ ፍልስፄመት ቡራቅሸ እያኮ ይዶሶና። ጎዳ አያናይ እያ ቦላ ዎልቃን ዎꬍስ። እያ ኩሸይ ቃሸትዳ ዎዶሮይ ሻሎይ ታማ በእድ ዱፀረተይሳዳ ዱፀረት ዎꬍስ። ");
INSERT INTO gofe_vpl VALUES ("JG15_15","008_15_15","JDG","15","15","15","ማታ ዎደ ሀይቅዳ ሀረ ጋጮ ደምድ፥ እያራ ሙኩሉ አስ ዎꬍስ። ");
INSERT INTO gofe_vpl VALUES ("JG15_16","008_15_16","JDG","15","16","16","ሳምሶን፥ “ሀረ ጋጮን፥ አሀ ቦላ አሀ ዶራስ። ሀረ ጋጮን ሙኩሉ አስ ዎꬋስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG15_17","008_15_17","JDG","15","17","17","ሃሳያ ዉርስዳፐ ጉየ፥ ባ ኦይክዳ ጋጩዋ ሆልድ ሄ በሳ ራማት-ለሀ ያግድ ፄግስ። ");
INSERT INTO gofe_vpl VALUES ("JG15_18","008_15_18","JDG","15","18","18","ሳምሶን ዳሮ ሳሞትድ፥ “ኔኒ ሀይሳ መላ ግታ ፆኖ ታዉ ነ አይልያስ እማዳሳ። ያትን፥ ታኒ ሀእ ሳሞን ሀይቆ? ሀ ቃፃረቶና አሳ ኩሸን ዎꬎ?” ያግድ ፆሳኮ ዋስስ። ");
INSERT INTO gofe_vpl VALUES ("JG15_19","008_15_19","JDG","15","19","19","ፆሳይ ለሀን ደእያ አፎ ካካ ጳልቅን እያፐ ሃꬅ ከይስ። ሳምሶን ሄ ሃꬃ ኡይድ አልዳ ዎደ እያዉ ሸምፖይ ስምስ። ሄሳ ግሾ፥ ሄ በሳ አይን-ሀቆረ ያግድ ፄግስ። ሄ በሳይ ሀች ጋካናዉ ለሀን ደኤስ። ");
INSERT INTO gofe_vpl VALUES ("JG15_20","008_15_20","JDG","15","20","20","ፍልስፄመት ቢታ ሃርያ ዎደ ሳምሶን እስራኤለ ላታሙ ላይꬅ አይስስ። ");
INSERT INTO gofe_vpl VALUES ("JG16_1","008_16_1","JDG","16","1","1","እስ ጋላስ ሳምሶን ፍልስፄመ ካታማ ግድዳ ጋዛ ካታማ ብስ፤ ያን እስ ላይማ ማጫስ በእድ ኢራ አቃናዉ እ ሶ ገልስ። ");
INSERT INTO gofe_vpl VALUES ("JG16_2","008_16_2","JDG","16","2","2","ጋዛ ካታማ አሳይ ሳምሶን ኤንታ ካታማ ይዳይሳ ስእድ ኬꬃ ተቅድ ቃማ ኩመꬅ ናግሸ ካታማ ፐንግያን አቅዶሶና። ሳእ ዎንትኮ ዎꬋና ግድ ናግሸ ዶና ጱቆና አቅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG16_3","008_16_3","JDG","16","3","3","ሽን ሳምሶን ያን ግድ ብላሄ ጋካናዉ ጋምእስ። ብላሄ ደንድድ ካታማ ድርሳ ፐንግያ፥ ፐንግያ ኦይክያ ናምኡ ቱሳታነ ኮበ ብራታታ እስፈ ሾድስ። ሄ ኡባ ሀሸን ቶክድ ከብሮናፐ ስንꬃ ባጋራ ደእያ ዙማ ሁጰ ከስስ። ");
INSERT INTO gofe_vpl VALUES ("JG16_4","008_16_4","JDG","16","4","4","ጉꬃ ዎደፐ ጉየ ሳምሶን ሶረቃ ዛንጋራን ደእያ እስ ዳልሎ ጌተትያ ማጫስዉ ዶስስ። ");
INSERT INTO gofe_vpl VALUES ("JG16_5","008_16_5","JDG","16","5","5","ፍልስፄመ ሀላቃት ኢኮ ብድ፥ “ኔኒ እያ ጭማዳ፥ ሄ ዎልቃ ኡባ እ አዉፐ ደምያኮነ ኑኒ እያ ዋት ፆንድ ቃቻናዉ ዳንዳእያኮ ኦይቻ። ኑኒ እሶይ እሶይ ነዉ ታማነ እስ ክሎ ግራመ ብራ ሳንትመ እማና” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG16_6","008_16_6","JDG","16","6","6","ሄሳ ግሾ ዳልላ ሳምሶናኮ፥ “ሀይሳ መላ ምኖተꬅ ነ አዉፐ ደምዳኮ፥ ሀያና ታዉ ኦዳርኪ። አስ ነና ቃችድ ዋትድ ነ ዎልቃ ዳቡርሳናዉ ዳንዳኢ?” ያጋሱ። ");
INSERT INTO gofe_vpl VALUES ("JG16_7","008_16_7","JDG","16","7","7","ሳምሶን፥ “ታና ላፑን እርፃ ዳፎራ አስ ቃችኮ ዳቡራዳ ሀራ አሳዳ ሀናና” ያግድ ዛርስ። ");
INSERT INTO gofe_vpl VALUES ("JG16_8","008_16_8","JDG","16","8","8","ፍልስፄመ ሀላቃት ዳልላስ ላፑን እርፃ ዳፎታ ኤህን እያ ሳምሶና ቃቻሱ። ");
INSERT INTO gofe_vpl VALUES ("JG16_9","008_16_9","JDG","16","9","9","ቆልአን አሰ ቆታ ዎꬃዳ፥ “ሳምሶና፥ ፍልስፄመት ይዶሶና” ጋዳ ፄጋሱ። ሽን ሻሎይ ታም ኦይክን ዱፀረተይሳዳ ዳፎታ ዱሰረꬅ የግስ። ሀእካ እያ ምኖተꬃ ፁራይ ኤረትቤና። ");
INSERT INTO gofe_vpl VALUES ("JG16_10","008_16_10","JDG","16","10","10","ዳልላ ሳምሶናኮ፥ “ኔኒ ታና ኤያ ኦꬃሳ፤ ነ ታዉ ዎርዶ ኦዳዳሳ። ሀእካ ነና ዋት ቃቻናዉ ዳንዳኤትያኮ ሀያና ታዉ ኦዳ” ያጋሱ። ");
INSERT INTO gofe_vpl VALUES ("JG16_11","008_16_11","JDG","16","11","11","እ ዛሪድ፥ “አስ ጎኤትቦና ኦራꬃ ዎዶሮን ታና ቃችኮ ዳቡራዳ ሀራ አሳዳ ሀናና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG16_12","008_16_12","JDG","16","12","12","ዳልላ ኦራꬃ ዎዶሮ ኤካዳ ሳምሶና ቃቻሱ። ቆልአን አሰ ቆታ ዎꬃዳ፥ “ሳምሶና፥ ፍልስፄመት ይዶሶና” ያጋሱ። ሽን እ ዎዶሩዋ ባ ቀስያፐ ሻሎዳ ዱሰረꬅ የግስ። ");
INSERT INTO gofe_vpl VALUES ("JG16_13","008_16_13","JDG","16","13","13","ዳልላ ሳምሶናኮ፥ “ሀእ ጋካናዉ ነ ታና ጭማሳ፤ ኔኒ ታዉ ዎርዶ ኦዳዳሳ። ሀእካ ነና ዋትድ ቃቻናዉ ዳንዳኤትያኮ ሀያና ታዉ ኦዳ” ያጋሱ። እ ዛሪድ፥ “ታ ሁጵያ ላፑን ብናና ዳꬃታ ቃጭናራ ጋꬃዳ፥ ቁፃራዳ ዳድኮ፥ ታኒ ዳቡራዳ ሀራ አሳዳ ሀናና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG16_14","008_16_14","JDG","16","14","14","ሄሳፈ ጉየ፥ ሳምሶን ꬍስክዳሽን፥ ዳልላ እያ ሁጵያ ላፑን ብናና ዳꬃታ ቃጭናራ ጋꬃዳ ዶቃሱ። ሄሳፈ ጉየ፥ “ሳምሶና፥ ፍልስፄመት ይዶሶና” ያጋሱ። እ ꬍስኮፈ ባርክድ፥ ባ ብናናይ ዶቀትድ ቶለትዳ በሳፈ ሾድ ኤክስ። ");
INSERT INTO gofe_vpl VALUES ("JG16_15","008_16_15","JDG","16","15","15","ያትን እያ፥ “ነ ዎዛናይ ታራ ዴና፥ ‘ዎይጋዳ ታ ነና ዶሳይስ’ ጋይ? ሄꬑ ቶሆ ታና ጭማዳሳ። ኔኒ ሀ ምኖተꬃ አዉፐ ደምያኮ ታዉ ኦዳ” ያጋሱ። ");
INSERT INTO gofe_vpl VALUES ("JG16_16","008_16_16","JDG","16","16","16","ጋላስ ጋላስ ኦይቻዳ እ ሀይቆ አሞታና ጋካናዉ እያ ዋይሳሱ። ");
INSERT INTO gofe_vpl VALUES ("JG16_17","008_16_17","JDG","16","17","17","ዉርሰꬃን ሳምሶን፥ “ታ አየ ኡሎፐ ዶምን ታኒ ፆሳስ ዱማትዳ ናዝራወ ግድዳ ግሾ፥ ታ ሁጰ ብናናይ ሜደትድ ኤረና። ታ ብናናይ ሜደትኮ፥ ታ ዎልቃይ ታፐ ኤከትን፥ ታኒ ዳቡራዳ ሀራ አሳዳ ሀናና” ያግድ፥ ባ ፁራ ኡባ እዉ ኦድስ። ");
INSERT INTO gofe_vpl VALUES ("JG16_18","008_16_18","JDG","16","18","18","ባ ዎዛናን ደእያባ ኡባ እ ኦድዳይሳ ዳልላ በእዳ ዎደ፥ “ባ ዎዛናን ደእያባ ኡባ ታዉ ኦድዳ ግሾ፥ አነ እስ ቶሆ ስሚድ ዪተ” ያጋዳ ፍልስፄመ ሀላቃታስ ኪታ የድን ኤንቲ ብራ ኤክድ ኢኮ ይዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG16_19","008_16_19","JDG","16","19","19","ዳልላ ሳምሶና ባ ዎድረ ቦላ ꬍስክሳዳ እስ አስ ፄግን ይድ፥ እያ ሁጵያ ላፑን ዳꬃ ብናና ሜድን እያ ዎልቃይ እያፐ ꬋይስ። ሄሳፈ ጉየ፥ እያ ዋይሶ ዶማሱ። ");
INSERT INTO gofe_vpl VALUES ("JG16_20","008_16_20","JDG","16","20","20","እያ፥ “ሳምሶና፥ ፍልስፄመት ይዶሶና” ያጋሱ። እ ꬍስኮፈ ባርክድ፥ ካሰይሳዳ ዱሰረꬃዳ ባና ያግድ ቆፕስ፤ ሽን ጎዳይ እያፐ ሻከትዳይሳ ኤርቤና። ");
INSERT INTO gofe_vpl VALUES ("JG16_21","008_16_21","JDG","16","21","21","ፍልስፄመት እያ ኦይክዳፐ ጉየ፥ እያ ናምኡ አይፈታ ዎጭ ከስዶሶና። ጋዛ ካታማ ኤፍድ ናሰ ብራታ ሳንꬃላታን ቃችድ ቃሾ ኬꬃን ካꬅ ጋጭስዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG16_22","008_16_22","JDG","16","22","22","ኤንቲ እያ ሁጵያ ብናና ሜድዳፐ ጉየ፥ ብናናይ ስሚድ ዶሎ ዶምስ። ");
INSERT INTO gofe_vpl VALUES ("JG16_23","008_16_23","JDG","16","23","23","ፍልስፄመ ሀላቃት፥ “ኑ ፆሳይ ኑ ሞርክያ ሳምሶና ኑ ኩሸን አꬅድ እሚስ” ያግድ ባንታ ፆሳ ዳጎናስ ያርሾ ያርሻናዉነ ኡፋይታናዉ እስፈ ሺቅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG16_24","008_16_24","JDG","16","24","24","አስ ኡባይ እያ በእዳ ዎደ፥ “ኑ ቢታ ꬋይስዳነ ኑፐ ዳሮታ ዎꬍዳ ኑ ሞርክያ፥ ኑ ፆሳይ ኑ ኩሸን አꬅድ እሚስ” ያግድ ባንታ ፆሳ ጋላትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG16_25","008_16_25","JDG","16","25","25","ኤንቲ ዳሮ ኡፋይትዳ ግሾ፥ “ዱርድ ኑና ኡፋይሳና መላ ሳምሶና ፄግተ” ያግዶሶና። ሳምሶና ቃሾ ኬꬃፈ ፄግድ ኤህን፥ እ ኤንታ ስንꬃን ዱርዳፐ ጉየ ቱሳታፐ ግዶን ኤስዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG16_26","008_16_26","JDG","16","26","26","ሳምሶን ባ ኩሽያ ኦይክድ ካለꬅያ ናኣኮ፥ “ታኒ ኤንታን ዘምፓዳ ኤቃና መላ ኬꬃ ቶክዳ ቱሳታ ታና ኦይꬃ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG16_27","008_16_27","JDG","16","27","27","ኬꬃ ግዶን አደይነ ማጫስ፥ ሄሳዳካ ፍልስፄመ ሀላቃት ኡባይ ኩምድ ደኦሶና። ሳምሶን ዱርሽን፥ ፖቅያ ቦላ ኡትድ በእያ ሄꬑ ሙኩሉ ግድያ አደይነ ማጫስ በኦሶና። ");
INSERT INTO gofe_vpl VALUES ("JG16_28","008_16_28","JDG","16","28","28","ሄ ዎደ ሳምሶን፥ “አቤት ኡባ ሃርያ ጎዳዉ፥ ታና ቆፓርክ። አቤት ፆሳዉ፥ ፍልስፄመት ታ ናምኡ አይፈታ ከስዳ ግሾ፥ ሀሎ ከያና መላ ታና እስ ቶሆ ምንꬃርክ!” ያግድ ጎዳ ዎስስ። ");
INSERT INTO gofe_vpl VALUES ("JG16_29","008_16_29","JDG","16","29","29","ሳምሶን ኬꬃ ቶክዳ ግዶ ቱሳታ ናምኣካ ኦይክስ። እሱዋ ኡሻቻ ኩሸን፥ እሱዋ፥ ሀድርሳ ኩሸን ኦይክዳፐ ጉየ፥ ");
INSERT INTO gofe_vpl VALUES ("JG16_30","008_16_30","JDG","16","30","30","“ታኒ ፍልስፄመታራ እስፈ ሀይቃና” ያግድ ዋስስ። ባዉ ደእያ ዎልቃ ኡባን ሱግን፥ ኬꬃይ ሀላቃታ ቦላነ ጋርሳን ደእያ አሳ ኡባ ቦላ ኩንድስ። ሳምሶን ፓፃ ደእሸ ዎꬍዳ አሳፐ ሀይቅሸ ዎꬍዳ አሳይ ዳሮ። ");
INSERT INTO gofe_vpl VALUES ("JG16_31","008_16_31","JDG","16","31","31","እያ እሻትነ እያ ዳቦት ኡባይ ይድ፥ እያ አሀ ኤክዶሶና። ፆርአፈነ ኤሽታኦላፐ ግዶን እያ አዋ ማኑሄ ዱፉዋን ሞግዶሶና። ሳምሶን እስራኤለ ላታሙ ላይꬅ አይስስ። ");
INSERT INTO gofe_vpl VALUES ("JG17_1","008_17_1","JDG","17","1","1","ደረይ ዳርያ ኤፍሬማ ቢታን ምካ ጌተትያ እስ አደይ ደኤስ። ");
INSERT INTO gofe_vpl VALUES ("JG17_2","008_17_2","JDG","17","2","2","እስ ጋላስ ሚክ ባ አይዉ፥ “ኔፐ አስ ታማነ እስ ክሎ ግራመ ብራ ሳንትመ ካይስን ኔኒ ሄ ካይስዳ አድያ ባድሽን ታ ስአስ። ሄ ሚሸይ ታ ማታን ደኤስ፤ ታኒ ኤካስ” ያግስ። እያ አይያ፥ “ታ ናአዉ፥ ነና ጎድ አንጆ” ያጋሱ። ");
INSERT INTO gofe_vpl VALUES ("JG17_3","008_17_3","JDG","17","3","3","ናአይ ታማነ እስ ክሎ ግራመ ብራ ሳንትመ አየስ ዛርስ። እያ አይያ፥ “ባደꬃይ ታ ናኣ ጋኮና መላ ታኒ ሀ ሚሽያ ጎዳስ ዱማያና። ብራ ሼሽድ፥ ምꬃፈ ኦሰትዳ ኤቃ ምስልያ ትያናዉ ጎኤታና፤ ብራ ታ ነዉ ዛራና” ያጋሱ። ");
INSERT INTO gofe_vpl VALUES ("JG17_4","008_17_4","JDG","17","4","4","ናአይ ሚሽያ ባ አየስ ዛርን፥ እያ ሄ ብራፐ ናምኡ ፄቱ ብራ ሳንትመ ኤካዳ፥ ምꬅ ማስድ፥ ብራ ሼሽ ትይድ፥ ኤቃ ምስለ መꬍያ፥ እስ ሂላስ እማሱ። እ ኦꬅዳ ምስለይ ምካ ሶን ኡትስ። ");
INSERT INTO gofe_vpl VALUES ("JG17_5","008_17_5","JDG","17","5","5","ምካስ ኤቃ ጎይንያ ኬꬅ ደኤስ። እ ኤፉደነ ሶ ግዶ ኤቃ ምስለታ ጊግስድ፥ ሄ ኬꬃን ባ ናይታፐ እሱዋ ካህነ ኦꬅድ ሹምስ። ");
INSERT INTO gofe_vpl VALUES ("JG17_6","008_17_6","JDG","17","6","6","ሄ ዎደ እስራኤለ ቢታን ካዎይ ባዋ፤ አስ ኡባይ ባዉ ሎኦ ዳንዳባ ኦꬄስ። ");
INSERT INTO gofe_vpl VALUES ("JG17_7","008_17_7","JDG","17","7","7","ሄ ዎደ ይሁዳ ቢታን ቤተለመ ካታማን ሌወ ኮቸ ግድዳ እስ ናአተꬃይ ደኤስ። ");
INSERT INTO gofe_vpl VALUES ("JG17_8","008_17_8","JDG","17","8","8","ሀ አደይ ባዉ ደእያ በሲ ኮያናዉ ቤተለመ ካታማፐ ደንድድ ደረይ ዳርያ ኤፍሬማ ቢታን ደእያ ምካ ሶ ጋክስ። ");
INSERT INTO gofe_vpl VALUES ("JG17_9","008_17_9","JDG","17","9","9","ምክ፥ “አዉፐ ያዲ?” ያግድ ኦይችስ። አደይ፥ “ታኒ ይሁዳ ቢታ ቤተለመ ካታማፐ ያስ፤ ታኒ ሌወ ኮቸ። ሀእ ታኒ ደእያ በሲ ኮያይስ” ያግድ ዛርስ። ");
INSERT INTO gofe_vpl VALUES ("JG17_10","008_17_10","JDG","17","10","10","ሚክ እያኮ፥ “ታራ ደአ፤ ታዉ አዋነ ካህነ ግዳ። ታኒ ነዉ ላይꬃን ላይꬃን ታሙ ብራ ሳንትመ፥ ኩመꬃ አፍላነ ምያባ እማና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG17_11","008_17_11","JDG","17","11","11","ናአተꬃ ሌወይ ምካራ እስፈ ዳናዉ ገልስ፤ ምካስ የልዳ ናአዳ ሀንስ። ");
INSERT INTO gofe_vpl VALUES ("JG17_12","008_17_12","JDG","17","12","12","ሚክ እያ ባ ካህነ ኦꬅድ ሹምን እያ ሶን ደእስ። ");
INSERT INTO gofe_vpl VALUES ("JG17_13","008_17_13","JDG","17","13","13","ሚክ፥ “እስ ሌወይ ታዉ ካህነ ግድዳ ግሾ ጎዳይ ታባ ሎይꬃናይሳ ኤራይስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG18_1","008_18_1","JDG","18","1","1","ሄ ዎደ እስራኤለ ቢታን ካዎይ ባዋ። ሄ ዎደይ ጋካናዉ ዳነ ኮቻት እስራኤለ ኮቻታ ግዶን ላትዳ ቢት ባዋ። ኤንቲ ባንታዉ ደእያ ቢታ ኮይሸ ደኦሶና። ");
INSERT INTO gofe_vpl VALUES ("JG18_2","008_18_2","JDG","18","2","2","ሄሳ ግሾ፥ ዳነ ኮቻት ባንታ ግዶፈ እቻሹ ምኖ ኦላንቾታ ዶርድ ቢታ ዎቻና መላ ፆርአፈነ ኤሽታኦላፐ ኤንታ ኪትዶሶና። ኤንቲ ደረይ ዳርያ ኤፍሬማ ቢታ ጋክድ ምካ ሶን አቅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG18_3","008_18_3","JDG","18","3","3","ኤንቲ ምካ ሶን ደእያ ዎደ ሌወ ኮቸ ግድዳ ናአተꬃ እያ ኦዳን ኤርዶሶና። ኤንቲ እያኮ ሺቅድ፥ “ነና ሀይሳ ኤህዳይ ኦኔ? ሀይሳ አይስ ያዲ?” ያግድ ኦይችዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG18_4","008_18_4","JDG","18","4","4","እ ዛሪድ፥ “ሚክ ታዉ ዳሞዘ ቃንፅን፥ ታኒ እያዉ ካህነ ግዳዳ ኦꬃይስ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG18_5","008_18_5","JDG","18","5","5","ኤንቲ፥ “ኑኒ ብያ ኦገይ ኑስ ሱራነ፥ ሱረነ ሀያና ኑስ ፆሰ ኦይቻ” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG18_6","008_18_6","JDG","18","6","6","ካህነይ፥ “ሳሮ ቢተ፤ ህንተ ብያ ኦግያን ጎዳይ ህንተራ ግዳና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG18_7","008_18_7","JDG","18","7","7","ሄሳፐ ጉየ፥ እቻሹ አሳት ያፐ ደንድድ፥ ላይሻ ካታማ ጋክዶሶና። ያን ደእያ አሳይ ስዶና ቢታ አሳዳ ሳሮን ደኤይሳ በእዶሶና፤ አሳት ኦንካ ስꬎና ዎፑ ግዳ አስ፤ ኤንታዉ አይኮይካ ፓጮና ኡባባይ ኩምዳ አስ። አይ አሳራካ ጋሄቶና ስዶና አሳፐ ሃክድ ባንታዉ ዱማ ደኦሶና። ");
INSERT INTO gofe_vpl VALUES ("JG18_8","008_18_8","JDG","18","8","8","እቻሹ አሳት ፆርአንነ ኤሽታኦላን ደእያ ባንታ እሻታኮ ስምዶሶና፤ ኤንታ እሻት፥ “አይ ዎረ ኤክድ ይደቲ?” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG18_9","008_18_9","JDG","18","9","9","ኤንቲ ዛሪድ፥ “ቢታይ ዳሮ አራዳ ግደይሳ ኑ በእዳ። አነ ደንድድ ላይሻ ኦሎስ። ሀይሳን ኦሶ ꬋይድ ጮ ኡቶፍተ፤ ኤለ ብድ ኦይክተ። ");
INSERT INTO gofe_vpl VALUES ("JG18_10","008_18_10","JDG","18","10","10","ህንተ ያ ብድ፥ ኦናነ ስꬎና ኡትዳ አሳኮ ጋካና። ቢታይ ዳልጋ፤ አሳስ ኮሽያ ኡባባይ ሄ ቢታን ደኤስ። ፆሳይ ሄ ቢታ ህንተዉ እሚስ” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG18_11","008_18_11","JDG","18","11","11","ያትን፥ ዳነ ኮቻፈ ቶራ ዳንጭዳ ኡሱፑን ፄቱ አሳት ፆርአፐነ ኤሽታኦላፐ ደንድድ ብዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG18_12","008_18_12","JDG","18","12","12","ይሁዳ ቢታን ቅርያት-ይኣርማፐ ዉሎሀ ባጋራ ኡትዶሶና። ሄሳ ግሾ፥ ሄ በሳይ ሀች ጋካናዉ ዳነ ጉታ ጌተትድ ፄገቴስ። ");
INSERT INTO gofe_vpl VALUES ("JG18_13","008_18_13","JDG","18","13","13","ያፐ ደንድድ ደረይ ዳርያ ኤፍሬማ ቢታን ደእያ ምካ ሶ ይዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG18_14","008_18_14","JDG","18","14","14","ላይሻ ቢታ ዎቻናዉ ብዳ እቻሹ አሳት ባንታ እሻታኮ፥ “ሀ በሳን፥ ሀ ኬꬃታፐ እሱዋን ኤፉደይ፥ ሶ ግዶ ኤቃ ምስለትነ ምꬃፈ ኦꬅድ ብራ ሼሽድ ትይዳ ምስለይ ደኤይሳ ኤሬቲ? አነ አይ ኦꬃናዉ ኮሽያኮ ቆፕተ” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG18_15","008_18_15","JDG","18","15","15","ኤንቲ ኦግያፐ ስሚድ፥ ሌወ ኮቸ ግድዳ ናአተꬃ ካህነይ ደእያ ምካ ሶ ብድ እያ ሳሮꬅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG18_16","008_18_16","JDG","18","16","16","ሄ ዎደ ኡሱፑን ፄቱ ዳነ ኦላንቾት ኦላ ሚሸ ኦይክድ ፐንገ ቦላ ኤቅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG18_17","008_18_17","JDG","18","17","17","ኤንቲ ሄ ካህንያራ ያን ኤቅዳሽን፥ ቢታ ዎችያ እቻሹ አሳት ምካ ሶ ገልድ፥ ምꬃፈ ኦꬅድ፥ ብራ ሼሽድ፥ ትይዳ ኤቃ ምስልያ፥ ኤፉድያነ ሶ ግዶ ኤቃ ምስለታ ኤክዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG18_18","008_18_18","JDG","18","18","18","ሄ ዎደ ካህነይ ኤንታ፥ “ዋተቲ?” ያግድ ኦይችስ። ");
INSERT INTO gofe_vpl VALUES ("JG18_19","008_18_19","JDG","18","19","19","ኤንቲ እያ፥ “ሀይዛ፥ እስ ቃላካ ፖጎፓ። ኑራ ባዳ ኑስ አዋነ ካህነ ግዳ። እስ ኬꬃ አሳስ ካህነ ግደይሳፈ እስራኤለ ግድያ እስ ኮቻስ ካህነ ግደይስ ነዉ ሎኤኔ?” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG18_20","008_18_20","JDG","18","20","20","ካህነይ ሄሳ ስእድ ኡፋይትድ ኤፉድያ፥ ሶ ግዶ ኤቃ ምስለታነ ምꬃፈ ኦꬅድ ብራ ሼሽድ ትይዳ ምስልያ ኤክድ ኤንታራ ብስ። ");
INSERT INTO gofe_vpl VALUES ("JG18_21","008_18_21","JDG","18","21","21","ያፐ ደንድድ፥ ባንታ ናይታ፥ ባንታ መህያነ ባንታዉ ደእያባ ኡባ ስን አꬅድ ብዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG18_22","008_18_22","JDG","18","22","22","ኤንቲ ምካ ሶፐ ሃክድ ብዳፐ ጉየ፥ ሚክ ባ ሾሮታ ፄግን፥ ዳነ አሳታ ካልድ ጋክዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG18_23","008_18_23","JDG","18","23","23","ኤንታ ጋክድ ዋስን፥ ዳነ አሳት ጉየ ስሚድ፥ “ዋናዲ? ሀ አሳ ኡባ አይስ ሺሻዲ?” ያግድ ምካ ኦይችዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG18_24","008_18_24","JDG","18","24","24","ሚክ ዛሪድ፥ “ታኒ መꬍዳ ታ ፆሳታነ ታዉ ኦꬅያ ካህንያ ቦንቅደታ። ያትን ታዉ አትዳባይ አይቤ? ታና፥ ‘ዎይግድ ዋናድ፥ ጌቲ?’ ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG18_25","008_18_25","JDG","18","25","25","ዳነ አሳት፥ “አነ ዶና ፖጋዳ ነና ኤራ! ሀ ሸነራ ደእያ አሳ ኔኒ ደንꬅኮ፥ ኤንቲ ነ ቦላ ደንዳና፤ ነናነ ሶ አሳ ኡባ ꬋይሳና” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG18_26","008_18_26","JDG","18","26","26","ዳነ አሳት ባንታ ኦግያ ብዶሶና። ምክካ ኤንቲ ባፐ ዳሮ ምኖ ግደይሳ በእድ ባ ሶ ስምስ። ");
INSERT INTO gofe_vpl VALUES ("JG18_27","008_18_27","JDG","18","27","27","ዳነ አሳት ሚክ መꬍዳ ፆሳታነ እያ ካህንያ ኤክድ፥ ሌሳን ኦናካ ስꬎና ሳሮ ደእያ አሳታኮ ብድ፥ አሳ ኡባ ማሻን ዎꬍድ ካታማ ታማን ፁግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG18_28","008_18_28","JDG","18","28","28","ላይሻ ካታማይ ስዶናፐ ሃክድ ደእያ ግሾነ ኤንቲ ሀራ አሳራ ጋሄትድ ኤሮና ግሾ ኤንታ አሻናዉ ኦንካ ዳንዳእቤና። ላይሻ ካታማይ ቤት-ረሆባ ጌተትያ በሳ ማታን ደእያ ዛንጋራን ደኤስ። ዳነ አሳት ካታማ ዛር ኬፅድ ያን ደእዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG18_29","008_18_29","JDG","18","29","29","ካታማ ሱንꬃ በን ባንታ ማይዛ ያይቆባ ናኣ ዳነ ሱንꬃን ላምድ፥ ዳነ ያግድ ሱንꬅዶሶና፤ ሽን ኮይሮ ሄ ካታማይ ላይሻ ጌተቴስ። ");
INSERT INTO gofe_vpl VALUES ("JG18_30","008_18_30","JDG","18","30","30","ዳነ አሳት ባንታዉ ኤቃ ምስልያ ያን ዎꬅድ፥ ሙሰ ናኣ ገድሶናፐ የለትዳ ዮናታና ባንታ ካህነ ኦꬅዶሶና። እያ ኮቻት አሳይ ድኤትድ ብዳ ዎደ ጋካናዉ ያን ካህነ ግድዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG18_31","008_18_31","JDG","18","31","31","ሄሳዳ ሀንድ፥ ጌሻ ዱንካነይ ሴሎን ደእዳ ላይꬃ ኡባን ሚክ ኦꬅዳ ምስለት ያን ጋምእዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG19_1","008_19_1","JDG","19","1","1","እስራኤለ ቢታን ካዎይ ባይና ዎደ ደረይ ዳርያ ኤፍሬማ ቢታን፥ ሃሆ በሳን፥ ሌወ ኮቸ ግድዳ እስ ኡራይ ደኤስ። ሄ ኡራይ ይሁዳ ቢታን፥ ቤተለመ ካታማፐ እስ ላገꬆ ባዉ ኤህስ። ");
INSERT INTO gofe_vpl VALUES ("JG19_2","008_19_2","JDG","19","2","2","ሽን እያራ ኦየታዳ ይሁዳ ቢታን ቤተለመ ካታማን ደእያ ባ አዋ ሶ ባዳ ያን ኦይዱ አጌና ኡታሱ። ");
INSERT INTO gofe_vpl VALUES ("JG19_3","008_19_3","JDG","19","3","3","እ አዝናይ እዮ ጭማትድ ሶ ዛራናዉ ባ አይልያነ ናምኡ ሀረታ ኤክድ ብስ። እ ያ ጋክያ ዎደ እያ ሞካ ኤካዳ ባ አዋ ሶ ገልሳሱ፤ እ አዋይ እያ በእዳ ዎደ ኡፋይትድ ሞክስ። ");
INSERT INTO gofe_vpl VALUES ("JG19_4","008_19_4","JDG","19","4","4","ናኤ አዋይ እያ የዶና እፅን፥ ያን እያራ ምሸነ ኡይሸ ሄꬑ ጋላስ ጋምእስ። ");
INSERT INTO gofe_vpl VALUES ("JG19_5","008_19_5","JDG","19","5","5","ኦይዳንꬆ ጋላስ ዎንታ ጉራ ደንድድ፥ ባናዉ ጊግዶሶና። ሽን ናኤ አዋይ ባ ናኤ አዝናኮ፥ “ጉꬃ ካꬅ ማዳ ጋሽታዳ ባ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG19_6","008_19_6","JDG","19","6","6","ናምኡ አሳት ኡትድ እስፈ ምዶሶናነ ኡይዶሶና። ሄሳፈ ጉየ ናኤ አዋይ እያኮ፥ “ሀያና፥ ሀች ኡፋይታዳ ሀይሳን አቃ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG19_7","008_19_7","JDG","19","7","7","ሌወይ ባናዉ ደንድን፥ ናኤ አዋይ ቦና መላ ዎስን ቃስካ ያን አቅስ። ");
INSERT INTO gofe_vpl VALUES ("JG19_8","008_19_8","JDG","19","8","8","እቻሻንꬆ ጋላስ ዎንታ ጉራ ባናዉ ደንድን፥ ናኤ አዋይ፥ “ሀያና፥ ጉꬃ ካꬅ ማዳ፥ ጋሽታዳ ኦማርስ ባ” ያግስ። ኤንቲ ናምአይካ እስፈ ካꬅ ምዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG19_9","008_19_9","JDG","19","9","9","ሌወይ ባ ላገራነ ባ አይልያራ ባናዉ ከይን፥ ናኤ አዋይ፥ “ሄኮ፥ ሳእ ቃምስ፤ ሀእካ አቅተ፤ ዎንታ ጉራ ደንድድ ህንተ ሶ ቢተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG19_10","008_19_10","JDG","19","10","10","ሽን እ ያን አቃናዉ ኮይቦና ግሾ ባ ላገꬅዉ፥ ባ አይልያነ ናምኡ ጫነትዳ ሀረታ ኤክድ ያቡሰ ጌተትያ የሩሳላመ ካታማ ጋክዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG19_11","008_19_11","JDG","19","11","11","ኤንቲ ያቡሰ ማትያ ዎደ ሳእ ዳሮ ኦማርስን፥ አይለይ፥ “ሀይሳን፥ ያቡሰታ ካታማን አቅኮ ዋናኔ?” ያግድ ባ ጎዳ ኦይችስ። ");
INSERT INTO gofe_vpl VALUES ("JG19_12","008_19_12","JDG","19","12","12","ሽን እያ ጎዳይ፥ “ሀይሳን፥ እስራኤለ አስ ባይና አላጋ ካታማ ቦኮ። ግብአ ካታማ ጋካናዉ ባና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG19_13","008_19_13","JDG","19","13","13","ቃስካ ባ አይልያኮ፥ “ሃያ፥ ኑኒ ግብአን ዎይኮ ራማን አቅያ በሲ ደማና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG19_14","008_19_14","JDG","19","14","14","ሄሳ ግሾ ባንታ ኦግያ ኦይክድ ብዶሶና። ብንያመ ቢታን ግብአ ካታማ ኤንቲ ማትያ ዎደ አው ዉልስ። ");
INSERT INTO gofe_vpl VALUES ("JG19_15","008_19_15","JDG","19","15","15","ኤንቲ ግብአ ካታማ ገልድ አቃናዉ ያ ብዶሶና። ሄ ካታማ አሳይ ዱላታ ኡትያ በሳን ኡትዶሶና፤ ሽን ኤንታ ባ ሶ ኤፍድ አይስያ አስ በንትቤና። ");
INSERT INTO gofe_vpl VALUES ("JG19_16","008_19_16","JDG","19","16","16","ኤንቲ ያን ኡትዳሽን፥ ሳእ ኦማርስን ጋደፐ ባ ሶ ስምያ እስ ጭማ አደይ ኤንታ ማታራ አꬍስ። ሀ አደይ ካሰ ደረይ ዳርያ ኤፍሬማ ቢታፈ ይዳ አስ፤ ሽን ሀእ ግብአ ካታማን ደኤስ። ሄ ቢታን ብንያመ ኮቻፈ የለትዳ አሳይ ደኦሶና። ");
INSERT INTO gofe_vpl VALUES ("JG19_17","008_19_17","JDG","19","17","17","ሄ ጭማ አደይ፥ ካታማ አሳይ ዱላታ ኡትያ በሳን ኡትዳ አድያ በእድ፥ “አዉፐ ያዲ? አዉ ባይ?” ያግድ ኦይችስ። ");
INSERT INTO gofe_vpl VALUES ("JG19_18","008_19_18","JDG","19","18","18","ሌወይ ዛሪድ፥ “ኑኒ ይሁዳ ቢታን ቤተለመ ካታማፐ ይዳ። ሀእ ደረይ ዳርያ ኤፍሬማ ቢታን፥ ሃሆ በሳን ደእያ ፆሳ ኬꬅነ ኑ ሶ ቦስ። ኑና ባ ሶ ኤፍድ አይስያ አስ ደምቦኮ። ");
INSERT INTO gofe_vpl VALUES ("JG19_19","008_19_19","JDG","19","19","19","ኑ ሀረታስ ኡቱልነ ካለይ ደኤስ፤ ታዉ፥ ታ ላገስነ ታ አይልያስ ግድያ ካꬅነ ዎይነ ኡሽ ደኤስ፤ ኑስ ኮሽያባ ኡባ ኦይክዳ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG19_20","008_19_20","JDG","19","20","20","ጭማ አደይ፥ “ሳሮይ ህንተዉ ግዶ፤ ታ ሶ የꬍተ፤ ታ ሶን አቅተ፤ ህንተ ኮያባ ኡባ ታ ህንተዉ እማና። ሀ ካታማ ዳባባን ህንተ አቃናዉ በሰና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG19_21","008_19_21","JDG","19","21","21","ኤንታ ባ ሶ ኤፍስ፤ ኤንታ ሀረታስ ምያባ የግስ። እማꬃት ባንታ ቶሁዋ ሜጨትድ ካሆ ምዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG19_22","008_19_22","JDG","19","22","22","ኤንቲ ኡፋይትሽን፥ ካታማፐ ኢታ አሳት ይድ፥ ኬꬃ ተቅድ፥ ፐንግያ ቆፀꬅ ዶምዶሶና። ኤንቲ ጭማ አድያኮ፥ “ሀ ነ ሶ ገልዳ አድያ ሃ ከሳ፤ ኑኒ እያራ ጋሄታናዉ ኮዮስ” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG19_23","008_19_23","JDG","19","23","23","ሄ ኬꬃ ጎዳይ፥ “ሀነና፤ ታ እሻቶ፥ ሄሳ መላ ፓላባ ኦꬆፕተ፤ ሀ አደይ ታ እማ። ");
INSERT INTO gofe_vpl VALUES ("JG19_24","008_19_24","JDG","19","24","24","ሄኮ፥ ታ ጌላኦ ናእያነ እያ ላገꬅያ ሀይሳን ደኦሶና። ታኒ ኤንታ ህንተዉ ካረ ከሳና፤ ህንተ ኤንታ ቦላ ኮይዳባ ኦꬅተ፤ ሽን ሀ አድያ ቦላ ሄሳ መላ ኢታባ ኦꬆፍተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG19_25","008_19_25","JDG","19","25","25","ሽን አሳት እ ግዳይሳ ስኦና እፅዶሶና። ሌወይ ባ ላገꬅዉ ካረ ሆልስ። ሳእ ዎንታና ጋካናዉ ቃማ ኩመꬅ ታራን ታራን ኢራ ዎልቃን ጋሄትድ፥ እዮ ፓፃ ካእሸ አይስዶሶና፤ ሳእ ዎንታና ሀንሽን እዮ የድ አግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG19_26","008_19_26","JDG","19","26","26","ዎንታናዉ ጎንተይ ዞእያ ዎደ ያዳ፥ እ ጎዳይ አቅዳ ጭማ አድያ ኬꬃ ፐንገን ኩንዳሱ፤ ፃልቀይ ዶላና ጋካናዉ ያን ዝንአሱ። ");
INSERT INTO gofe_vpl VALUES ("JG19_27","008_19_27","JDG","19","27","27","ዎንታ እ ጎዳይ ደንድድ፥ ባ ኦግያ ባናዉ ፐንግያ ዶይድ ከይያ ዎደ እያ ላገꬅያ ኬꬃ ፐንገን ባ ኩሽያ ምጫዳ ጉፋንዳሮ በእስ። ");
INSERT INTO gofe_vpl VALUES ("JG19_28","008_19_28","JDG","19","28","28","እ ጎዳይ፥ “ደንዳ፤ አነ ቦስ” ያግስ። ሽን እያ አይኮካ ዛራቡኩ። ያትን፥ እ አሀ ሀረን ጫንድ ባ ሶ ብስ። ");
INSERT INTO gofe_vpl VALUES ("JG19_29","008_19_29","JDG","19","29","29","እ ባ ሶ ጋክዳ ዎደ ማሻ ኤክድ፥ ባ ላገ አሀ ታማነ ናምኡ በሳን ቃንፀረꬅድ፥ እስ እስ ቃንፁዋ ታማነ ናምኡ እስራኤለ ኮቻታስ የድስ። ");
INSERT INTO gofe_vpl VALUES ("JG19_30","008_19_30","JDG","19","30","30","ሄሳ በእዳ ኡባይ፥ “እስራኤለ አሳይ ግብፀ ቢታፈ ከዮደፐ ሀች ጋካናዉ ሀይሳ መላባይ ሀንቤና፤ ኑካ በእቦኮ። አነ ሀይሳ ቆፕ በእድ፥ አኬካን ዞረትድ፥ አይ ኦꬃነኮ ኑስ ኦድተ” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG20_1","008_20_1","JDG","20","1","1","ዳነፐ በርሳበ ጋካናዉ ጋላዳን ደእያ እስራኤለ አስ ኡባይ እስ አሳዳ ምፅጳን ጎዳ ስንꬃን እስፈ ሺቅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG20_2","008_20_2","JDG","20","2","2","ሄ ሺቅዳ ፆሳ አሳራ፥ እስራኤለ ዛረ ኡባ ሀላቃት ደኦሶና። ኤንታ ግዶን ማሸ ዳንጭድ ኦለታናዉ ዳንዳእያ 400,000 ኦላንቾት ደኦሶና። ");
INSERT INTO gofe_vpl VALUES ("JG20_3","008_20_3","JDG","20","3","3","ሄ ዎደ እስራኤለ አሳይ ምፅጳን ሺቅዳይሳ ብንያመ አሳይ ስእዶሶና። እስራኤለ አሳይ፥ “ሀ ኢታባይ ዋንድ ሀንዳኮ ኑስ ኦድተ” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG20_4","008_20_4","JDG","20","4","4","ሀይቅዳ ላገ አዝናይ፥ ሌወይ፥ ሀይሳዳ ያግድ ዛርስ፤ “ታንነ ታ ላገꬅያ ሳእ ቃምን አቃናዉ ብንያመ ቢታን ደእያ ግብአ ካታማ ይዳ። ");
INSERT INTO gofe_vpl VALUES ("JG20_5","008_20_5","JDG","20","5","5","ግብአ ካታማ አሳት ታና ዎꬋናዉ ይድ፥ ኬꬃ ዩሹዋ ተቅዶሶና። ሽን ጉየፐ ታ ላገራ ዎልቃን፥ ታራን ታራን ጋሄትድ እዮ ዎꬍዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG20_6","008_20_6","JDG","20","6","6","ታኒ እ አሀ ኤካዳ ቃንፀረꬃስ፤ ኤንቲ ሀ ኢታባነ ዬላባ እስራኤለን ኦꬅዳ ግሾ እስራኤለ አሳይ ደእያ ቢታ ኡባ እስ እስ ቃንፆ የዳስ። ");
INSERT INTO gofe_vpl VALUES ("JG20_7","008_20_7","JDG","20","7","7","ህዛ፥ ህንተ ኡባይ እስራኤለ አስ፤ ዞረትድ በሲያ ፕርዳ እምተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG20_8","008_20_8","JDG","20","8","8","አሳ ኡባይ እስፈ ደንድድ፥ “ኑ ግዶፈ ኦንካ ባ ዱንካንያ ዎይኮ ባ ኬꬃ ጉየ ስመና። ");
INSERT INTO gofe_vpl VALUES ("JG20_9","008_20_9","JDG","20","9","9","ኑኒ ግብአ ቦላ ሀይሳ ኦꬃና፤ ሳማ የግድ፥ ግብአ ካታማ ኦላናዉ ባና አሳታ ዶራና። ");
INSERT INTO gofe_vpl VALUES ("JG20_10","008_20_10","JDG","20","10","10","እስራኤለ ዛረ ኡባፈ ኦላ ብያ አሳስ ሽንቀ ጊግሳና መላ ፄታፐ ታማ፥ ሙኩላፐ ፄታ፥ ታሙ ሙኩላፐ እስ ሙኩላ ዶርድ ኤካና። አትዳ ኦላንቾት ብንያመ ቢታን ደእያ ግብአ ብድ፥ እስራኤለ ቦላ ሀይሳ መላ ኢታባ ኦꬅዳ አሳ ቦላ ሀሎ ከያናዉ ቦ” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG20_11","008_20_11","JDG","20","11","11","እስራኤለ አሳ ኡባይ ካታማ ኦላናዉ እስፈ ሺቅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG20_12","008_20_12","JDG","20","12","12","እስራኤለ ኮቻት ብንያመ ኮቻ ኡባስ ሀይሳዳ ያግድ አሰ ኪትዶሶና፤ “ህንተ ግዶን ሀንዳ ሀ ኢታባይ አይቤ? ");
INSERT INTO gofe_vpl VALUES ("JG20_13","008_20_13","JDG","20","13","13","ኑኒ ኤንታ ዎꬍድ፥ እስራኤለፐ ኢታባ ꬋይሳና መላ ግብአን ደእያ ሄ ኢታ አሳታ ከስድ ኑስ እምተ” ያግዶሶና። ሽን ብንያመት እስራኤለ አሳይ ኦድዳይሳ ስኦና እፅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG20_14","008_20_14","JDG","20","14","14","ኤንቲ እስራኤለ አሳራ ኦለታናዉ ባንታ ካታማታፐ ከይድ እስፈ ግብአን ሺቅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG20_15","008_20_15","JDG","20","15","15","ሄ ጋላስ ብንያመ ካታማታፐ ይዳ ማሻን ኦለትያ ላታማነ ኡሱፑን ሙኩሉ ኦላንቾታ ሺሽዶሶና። ሄስካ ግብአን ደእያ አሳ ግዶፈ ዶረትዳ ላፑን ፄቱ አሳፐ ሀራ። ");
INSERT INTO gofe_vpl VALUES ("JG20_16","008_20_16","JDG","20","16","16","ሀ ኦላንቾታ ግዶፈ ላፑን ፄቱ አሳት ሀድርሳ ኩሸን ኦይሳታ፤ ኤንቲ ያምባርሻን ሹቹ ሆልድ፥ ሀር አቶሽን እስ ብናናካ ባሎኮና። ");
INSERT INTO gofe_vpl VALUES ("JG20_17","008_20_17","JDG","20","17","17","ብንያመ አሳ ጉጆና፥ እስራኤለ አሳይ ማሻን ኦለትያ 400,000 ኦላንቾታ ሺሽዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG20_18","008_20_18","JDG","20","18","18","እስራኤለ አሳይ ደንድድ፥ ቤተለ ብድ፥ “ብንያመ አሳ ኦላናዉ ኑፐ ስንꬃትድ ከያናይ ኦኔ?” ያግድ ፆሳ ኦይችዶሶና። ጎዳይ፥ “ይሁዳ ኮቻይ ስንꬃትድ ከዮ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG20_19","008_20_19","JDG","20","19","19","ዎንተꬃ ጋላስ ዎንታ ጉራ እስራኤለ አሳይ ደንድድ ግብአ ካታማ ማታን ሺቅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG20_20","008_20_20","JDG","20","20","20","ሄሳፈ ጉየ እስራኤለ አሳይ ብንያመ አሳ ኦላናዉ ብድ ግብአ ካታማ ማታን ሳልፕዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG20_21","008_20_21","JDG","20","21","21","ሄ ጋላስ ብንያመ አሳይ ግብአፐ ከይድ፥ እስራኤለ አሳፐ 22,000 ኦላንቾታ ዎꬍዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG20_22","008_20_22","JDG","20","22","22","እስራኤለ አሳይ እሶይ እሱዋ ምንꬅን፥ ኮይሮ ጋላስ ኤንቲ ኦላስ ሳልፕዳ በሳን ናምአንꬆ ሳልፕዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG20_23","008_20_23","JDG","20","23","23","እስራኤለ አሳይ ብድ ሳእ ቃማና ጋካናዉ ጎዳ ስንꬃን ዬክዶሶና። ኤንቲ፥ “ኑ እሻታራ፥ ብንያመ አሳታራ ኦለታናዉ ናምአንꬆ ከይኖ?” ያግድ ጎዳ ኦይችዶሶና። ጎዳይ፥ “ኤ፥ ኤንታራ ኦለታናዉ ከይተ” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG20_24","008_20_24","JDG","20","24","24","እስራኤለ አሳይ ብንያመ አሳራ ኦለታናዉ ናምአንꬆ ሺቅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG20_25","008_20_25","JDG","20","25","25","ናምአንꬆ ጋላስካ ብንያመ አሳይ ግብአ ካታማፐ ከይድ፥ እስራኤለ ኦላንቾታፐ ማሻን ኦለትያ 28,000 አሳ ዎꬍዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG20_26","008_20_26","JDG","20","26","26","ሄሳፈ ጉየ፥ እስራኤለት ኡባይ ቤተለ ብድ ዬክዶሶና፤ ያን ፆምሸ ሳእ ቃማና ጋካናዉ፥ ጎዳ ስንꬃን ኡትዶሶና። ጎዳ ስንꬃን ፁሳ ያርሾነ እስፈተꬃ ያርሾ ሺሽዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG20_27","008_20_27","JDG","20","27","27","ሄ ዎደ ፆሳ ጫቆ ታቦተይ ቤተለ ካታማን ደእያ ግሾ እስራኤለ አሳይ ጎዳ ኦይችዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG20_28","008_20_28","JDG","20","28","28","ሄ ዎደ አሮና ናአይ፥ አላዛራ ናአይ ፍንሃስ ካህነተꬃን ኦꬄስ። እስራኤለ አሳይ፥ “ኑ እሻ ግድዳ ብንያመ አሳራ ኦለታናዉ ከይኖየ አትኖ” ያግድ ጎዳ ኦይችዶሶና። ጎዳይ፥ “ብድ ኦለትተ፤ ታኒ ኤንታ ዎንቶ ህንተ ኩሸን አꬃዳ እማና” ያግስ። ");
INSERT INTO gofe_vpl VALUES ("JG20_29","008_20_29","JDG","20","29","29","እስራኤለ አሳይ ጉꬃ ኦላንቾት ግብአ ካታማ ዩሹዋን ዙግድ ናጋና መላ ኦꬅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG20_30","008_20_30","JDG","20","30","30","ሄꬓንꬆ ጋላስ እስራኤለ ኦላንቾት ካሰይሳዳ ብንያመ ኦላንቾታ ኦላናዉ ብድ፥ ግብአ ካታማፐ ስንꬃ ባጋራ ሳልፕዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG20_31","008_20_31","JDG","20","31","31","ብንያመ አሳይ ኤንታራ ኦለታናዉ ካታማፐ ከይድ፥ ኤንታ ካል ከይድ ሃክድ ብዶሶና። ካሰይሳዳ ቤተለነ ግብአ ኤፍያ ዳልጋ ኦገታንነ ደምባታን እስራኤለ አሳፐ ሀስታሙ ግድያ አሳ ዎꬍዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG20_32","008_20_32","JDG","20","32","32","ብንያመ አሳይ፥ “ኑኒ ካሰይሳዳ ኤንታ ፆንዳ!” ያግዶሶና። ሽን እስራኤለ አሳይ፥ “ኤንቲ ካታማፐ ሃክድ፥ ኦግያ ቦላ ከያና መላ አነ ኑኒ ባቃቶስ” ያግድ ዎፅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG20_33","008_20_33","JDG","20","33","33","እስራኤለ አሳ ኡባይ ባንታ በሳፈ ደንድድ፥ ባኣል-ታማራ ጌተትያ በሳን ሳልፕያ ዎደ ግብአ ደንባን ዙግድ ኡትዳ እስራኤለት ከይዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG20_34","008_20_34","JDG","20","34","34","እስራኤለ አሳፐ ዶረትዳ ታሙ ሙኩሉ አሳይ ግብአ ቦላ ኦላ ደንꬅዶሶና፤ ኦላይ ዳሮ ዎልቃምስ። ሄ ኡባይ ሀንያ ዎደ ብንያመ አሳስ ꬋዮይ ማትዳይሳ ኤርቦኮና። ");
INSERT INTO gofe_vpl VALUES ("JG20_35","008_20_35","JDG","20","35","35","እስራኤለት ብንያመ አሳ ቦላ ፆኖ ደማና መላ ጎዳይ ኦꬅስ። ሄ ጋላስ እስራኤለ አሳይ ብንያመ አሳፐ ማሻን ኦለትያ ላታማነ እቻሹ ሙኩሉነ እስ ፄቱ ኦላንቾታ ዎꬍዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG20_36","008_20_36","JDG","20","36","36","ሄሳፈ ጉየ፥ ብንያመ አሳይ ፆነትዳይሳ ኤርዶሶና። እስራኤለ አሳይ ግብአ ካታማ ዩሹዋን ዙግድ ኡትዳ ኦላንቾታን አማነትዳ ግሾ፥ ብንያመ አሳን ፆነትዳባ ዳንድ ጉየ ሺቅዳ ግሾሳ። ");
INSERT INTO gofe_vpl VALUES ("JG20_37","008_20_37","JDG","20","37","37","ቆሰትድ ናግያ ኦላንቾት ግብአ ካታማ ኤለስ ዎፅ ገልድ ካታማ ግዶን ደምዳ ኡባ ዎꬍዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG20_38","008_20_38","JDG","20","38","38","ቆሰትድ ናግያ አሳትነ እስራኤለ አሳይ ጩያ ሻራዳ ደንꬃና መላ ካሰ ዞረት ኡትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG20_39","008_20_39","JDG","20","39","39","ኦላ ደንባን ደእያ እስራኤለ አሳይ ባቃተይሳ አግድ፥ ጉየ ስሚድ፥ ኤንታ ኦልዶሶና። ብንያመ አሳይ እስራኤለ አሳፐ ሀስታሙ ግድያ አሳ ዎꬍድ፥ “ካሰይሳዳ ሀእካ ኑ ኤንታ ፆንዳ” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG20_40","008_20_40","JDG","20","40","40","ሽን ማላ ጩያይ ካታማፐ ፑደ ከስ ዶምስ። ብንያመ አሳይ ጉየ ፄልያ ዎደ ካታማይ ታማን ፁገትን፥ ጩያይ ፑደ ከየይሳ በእዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG20_41","008_20_41","JDG","20","41","41","ሄሳፈ ጉየ፥ እስራኤለት ብንያመ አሳ ቦላ ጉየ ስምዶሶና። ብንያመ አሳይ ዉራና ሀነይሳ ኤርዳ ግሾ ዳጋምዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG20_42","008_20_42","JDG","20","42","42","ሄሳ ግሾ፥ ኤንቲ እስራኤለ አሳ ስንꬃፈ ባዞ ስሚድ ባቃትዶሶና፤ ሽን ከስ ኤካናዉ ዳንዳእቦኮና። ካታማታፐ ከይዳ እስራኤለ ኦላንቾት ግዱዋን ኤንታ ዎꬍ ዉርስዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG20_43","008_20_43","JDG","20","43","43","እስራኤለት ብንያመ አሳ ተቅድ፥ ግብአ ካታማፐ ዶሎሀ ባጋራ ደእያ በሳ ጋካናዉ የደꬅድ ዳሮታ ዎꬍዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG20_44","008_20_44","JDG","20","44","44","ያን ብንያመ አሳፐ ታማነ ሆስፑን ሙኩሉ ምኖ ኦላንቾት ሀይቅዶሶና፤ ");
INSERT INTO gofe_vpl VALUES ("JG20_45","008_20_45","JDG","20","45","45","ኤንታፈ አትዳይሳት ጉየ ስሚድ፥ ባዙዋ ካንꬅድ፥ እርሞና ዛላኮ ባቃትዶሶና። እስራኤለት ኤንታፈ እቻሹ ሙኩሉ አሳ ኦገ ቦላ ዎꬍዶሶና። ኤንታፈ አትዳይሳታ ግዶማ ጋካናዉ የደꬅድ ናምኡ ሙኩሉ አሳ ዎꬍዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG20_46","008_20_46","JDG","20","46","46","ሄ ጋላስ ብንያመ አሳፐ ማሻን ኦለትያ ላታማነ እቻሹ ሙኩሉ ምኖ ኦላንቾት ሀይቅዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG20_47","008_20_47","JDG","20","47","47","ሽን ኡሱፑን ፄቱ አሳት ባዙዋ ካንꬅድ፥ እርሞና ዛላኮ ባቃትድ፥ ያን ኦይዱ አጌና ጋምእዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG20_48","008_20_48","JDG","20","48","48","እስራኤለ አሳይ አትዳ ብንያመ አሳኮ ጉየ ስሚድ፥ አደነ ማጫ፥ ናይታነ መህያ ኡባ ዎꬍዶሶና፤ ሄራን ደእያ ካታማታ ኡባ ታማን ፁግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG21_1","008_21_1","JDG","21","1","1","እስራኤለ አሳይ ምፅጳን ሺቅዳ ዎደ፥ “ኑ ግዶፈ ኦንካ ብንያመ አሳስ ባ ናአ ማቾ እሞፎ” ያግድ ጫቅ ኡትዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG21_2","008_21_2","JDG","21","2","2","እስራኤለት ቤተለ ካታማ ብድ፥ ያን ሳእ ቃማና ጋካናዉ ፆሳ ስንꬃን ኡትድ፥ ባንታ ቃላ ꬎቁ ኦꬅድ ዬክዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG21_3","008_21_3","JDG","21","3","3","ኤንቲ፥ “አቤት ጎዳዉ፥ እስራኤለ ፆሳዉ፥ ሀይስ እስራኤለን አይስ ሀንዴ? ሀች እስራኤለ አሳ ግዶፈ እስ ኮቻይ አይስ ፓጭዴ?” ያግዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG21_4","008_21_4","JDG","21","4","4","ዎንተꬃ ጋላስ ጉራ ደንድድ፥ ያርሾ በስ ጊግስድ፥ ፁሳ ያርሾነ እስፈተꬃ ያርሾ ሺሽዶሶና። ");
INSERT INTO gofe_vpl VALUES ("JG21_5","008_21_5","JDG","21","5","5","እስራኤለት፥ “እስራኤለ ዛረ ኡባፈ ጎዳ ስንꬃን ሺቅያ በሳ ዮና ኮቻይ ኦኔ?” ያግድ ኦይችዶሶና። ኤንቲ ሄሳ ኦይችዳ ጋሶይ፥ “ምፅጳ ካታማን ጎዳ ስንꬃን ሺቃናዉ ይቦና አስ ኦንካ ሀይቆ” ያግድ ካሰ ጫቅዳ ግሾሳ። ");
INSERT INTO gofe_vpl VALUES ("JG21_6","008_21_6","JDG","21","6","6","እስራኤለ አሳይ ባንታ እሻታስ፥ ብንያመ ኮቻታስ ቃትድ፥ “ሀች እስራኤለፐ እስ ኮቻይ ꬋይስ። ");
INSERT INTO gofe_vpl VALUES ("JG21_7","008_21_7","JDG","21","7","7","ኑኒ ኑ ማጫ ናይታ ኤንታዉ እሞና መላ ጎዳን ጫቅዳ ግሾ ሀይቆፐ አትዳ ብንያመ ኮቻት ማቾ 