﻿USE sofia;
DROP TABLE IF EXISTS sofia.gofRNT_vpl;
CREATE TABLE gofRNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES gofRNT_vpl WRITE;
INSERT INTO gofRNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Hayssafe kaallidi xaafettidayssi Dawite na7a Abrahame na7a gidida Yesuus Kiristtoosa yeletethaa. ");
INSERT INTO gofRNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrahamey Yisaaqa yelis; Yisaaqi Yayqooba yelis; Yayqoobi Yihudanne iya ishata yelis; ");
INSERT INTO gofRNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yihudi Ti7imaarippe Faaresenne Zaara yelis; Faaresi Asroome yelis; Asroomey Raame yelis; ");
INSERT INTO gofRNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Raamey Aminaadabe yelis; Aminaadabey Na7asoona yelis; Na7asooney Salmoona yelis; ");
INSERT INTO gofRNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmooney Ra7abippe Boo7eza yelis; Boo7ezi Uruutippe Iyobeede yelis; Iyobeedi Isseyye yelis; ");
INSERT INTO gofRNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isseyyey kawuwa Dawite yelis; Dawitey Ooriyo machcheefe Solomone yelis; ");
INSERT INTO gofRNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomoney Robi7aama yelis; Robi7aamey Abiya yelis; Abiyey Asaafe yelis; ");
INSERT INTO gofRNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asaafi Iyosaafexe yelis; Iyosaafixey Iyoraame yelis; Iyoraamey Ooziyane yelis; ");
INSERT INTO gofRNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ooziyaney Iyo7ataame yelis; Iyo7ataamey Akkaza yelis; Akkazi Hiziqiyasa yelis; ");
INSERT INTO gofRNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hiziqiyasi Minaase yelis; Minaasey Amoona yelis; Amooni Iyosiyaasa yelis; ");
INSERT INTO gofRNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Isra7eele asay di7ettidi Baabiloone biittaa bida wode Iyosiyaasi Ikoniyaananne iya ishata yelis. ");
INSERT INTO gofRNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Baabiloone biitta Isra7eele asay di7ettidi bidaappe guye Ikoniyaani Salatiyaale yelis. Salatiyaaley Zerubaabela yelis; ");
INSERT INTO gofRNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubaabeli Abdiyu yelis; Abdiyuy Eliyaaqeme yelis; Eliyaaqemey Azaara yelis; ");
INSERT INTO gofRNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azaari Sadooqe yelis; Sadooqey Akiime yelis; Akiimey Eliyuuda yelis; ");
INSERT INTO gofRNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliyuudi Alaazara yelis; Alaazari Maatane yelis; Maataney Yayqooba yelis; ");
INSERT INTO gofRNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yayqoobi Yoosefa yelis; Yoosefi Kiristtoosa giya Yesuusa yelida Mayraami azina. ");
INSERT INTO gofRNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Hiza, yeletethay Abrahameppe Dawite gakkanaw tammanne oydda. Dawiteppe bidi Baabiloone di7uwa gakkanaw tammanne oydda. Baabiloone di7uwappe bidi Kiristtoosa gakkanaw tammanne oyddu yeletethi gidees. ");
INSERT INTO gofRNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yesuus Kiristtoosa yeletethaa taarikey hayssafe kaalleyssa. Iya aaya Mayraama Yoosefas oyshetta de7ashe Yoosefara gahettonna Geeshsha Ayyaanaappe qanthatasu. ");
INSERT INTO gofRNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yoosefi Xillo asi gidida gisho iyo asan kessanaw koyibeenna. Yaaniya gisho qosan iyo agganaw qoppis. ");
INSERT INTO gofRNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","I he qofan de7ishin Xoossaa kiitanchchoy amuhon qonccidi, “Dawite na7aw, Yoosefa, Mayraama qanthatiday Geeshsha Ayyaanaappe gidiya gisho iyo ekkanaw yayyofa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Iya adde na7a yelana, I ba deriya entta nagaraappe ashshiya gisho iya sunthaa ne Yesuusa gada xeegana. ");
INSERT INTO gofRNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Goday nabiya Isayaasa doonan, ");
INSERT INTO gofRNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Hekko geela7iya qanthatana; adde na7akka yelana; iya sunthay Ammanu7eela geetettana” goyssi polettana mela ha ubbay hanis. Ammanu7eela geyssas birshshethay “Xoossay nuura de7ees” guussu. ");
INSERT INTO gofRNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yoosefi dhiskkofe barkkidi Godaa kiitanchchoy kiittidayssa mela Mayraamo ba soo efis. ");
INSERT INTO gofRNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Shin ba bayra na7a yelana gakkanaw iyo bochchibeenna; yelettida na7akka Yesuusa gidi xeegis. ");
INSERT INTO gofRNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Kawuwa Heroodisa woden Yesuusi Yihuda biittan Beeteleme kataman yelettidayssafe guye xoolintto taybiya asati dolohappe Yerusalaame yidi, ");
INSERT INTO gofRNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Yelettida Ayhude kawoy awun de7ii? Nuuni doloha baggara keyida iya xoolinttuwa be7idi iyaw goynnanaw yida” yaagidi oychchidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Kawoy Heroodisi hessa si7ida wode dagammis. Yerusalaamen de7iya asay ubbayka dagammidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Heroodisi kahine halaqatanne higge asttamaareta baakko xeegidi, “Kiristtoosi awun yelettanddeshsha?” yaagidi entta oychchis. ");
INSERT INTO gofRNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Enttika, “Yihuda Beetelemena; nabey, ");
INSERT INTO gofRNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Yihudan de7iya Beeteleme, Yihudan de7iya gooba katamatappe, neeni aybinkka guuxaka. Ta deriya Isra7eele aysanayssi, neeppe keyana’ gidi xaafis” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Hessafe guye, Heroodisi dolohappe yida asata geeman xeegidi, xoolinttuwa entti be7ida wodiya enttafe geeshshidi eris. ");
INSERT INTO gofRNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","I enttana Beeteleme yeddishe, “Bidi yelettida na7aa minthidi koyite; iya hintte demmida wode takka bada iyaw goynnana mela simmidi yishe taw odite” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Enttika kawoy Heroodisi gidayssa si7idi bidosona. Entti doloha baggara be7ida xoolinttoy enttana kaalethishe na7ay de7iyasuwa gakkanaw efis. ");
INSERT INTO gofRNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Entti he xoolinttuwa be7ida wode gita ufayssi ufayttidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Soo gelidi na7aa ba aaye Mayraamira de7eyssa be7idosona. Iyaw gulbbatidi goynnidosona. Bantta saaxiniya dooyidi worqqa, ixaanenne karbbe iyaw immidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Entti Heroodisakko guye simmona mela Xoossay amuhon enttaw odin, hara ogera bantta biittaa simmidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Doloha baggafe yida asati bidaappe guye, Godaa kiitanchchoy Yoosefas amuhon qonccidi, “Heroodisi na7aa wodhanaw koyaa gisho dendda; ellesada na7aanne na7aa aayiw ekkada Gibxxe biittaa ba. Ne simmana wodiya ta new odana gakkanaw yan gam77a” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Hessa gisho, Yoosefi he qamman denddidi, na7aanne na7aa aayiw ekkidi Gibxxe bis. ");
INSERT INTO gofRNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Nabiya doonan Xoossay, “Taani, ta na7aa, Gibxxe biittafe xeegas” geetettida qaalay polettana mela Heroodisi hayqqana gakkanaw I yan de7is. ");
INSERT INTO gofRNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Hessafe guye, doloha baggafe yida asati iya cimmidayssa erida wode daro yilotis. I kase enttafe si7idayssada Beetelemeninne he heeran de7iya nam77u laythi kumidayssatanne nam77u laythafe garssan de7iya adde nayta ubbaa ba wotaddareta yeddidi wodhisis. ");
INSERT INTO gofRNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","18","Nabiya Ermmiyasa doonan, “Yeehoynne zeleelssi, Raama kataman si7ettis. Raahela ba naytas yeekkawusu; entti hayqqida gisho minettanaw dandda7abuukku” gidi odidayssi polettis. ");
INSERT INTO gofRNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Heroodisi hayqqidaappe guye Gibxxen Godaa kiitanchchoy Yoosefas amuhon qonccidi, ");
INSERT INTO gofRNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Na7aa wodhanaw koyaa asati hayqqida gisho denddada na7aanne na7aa aayiw ekkada Isra7eele biittaa simma” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Yoosefi denddidi na7aanne na7aa aayiw ekkidi Isra7eele biittaa simmis. ");
INSERT INTO gofRNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Shin Arkkeliyoosi Yihudan ba aawa Heroodisa bessan kawotidayssa si7ida wode yaa baanaw yayyis. Xoossay amuhon iyaw qonccisin Galiila biittaa bis. ");
INSERT INTO gofRNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Nabeta doonan, “Naazirete asi geetettana” gidi odettidayssi polettana mela Naazirete katamaa bidi yan de7is. ");
INSERT INTO gofRNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","2","He wode Xammaqiya Yohaannisi, “Xoossaa kawotethay matattida gisho hintte nagaraappe simmite” yaagidi sabbakishe Yihuda bazzo biittaa bis. ");
INSERT INTO gofRNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Nabiya Isayaasi Yohaannisabaa odidayssa mela, “Bazzo biittan, issoy ba qaala dhoqqu oothidi, ‘Godaa ogiya giigisite. Iya horogaa piddi oothite’ gis” yaagettiday iyassa yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yohaannisi gimale ikiseppe oosettida afila ma77ees. Ba xeessan dafo danccees. I miya kathayka boolenne degera eesi. ");
INSERT INTO gofRNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Asay he wode Yerusalaame katamaappe, Yihuda biitta ubbaafenne Yorddaanose Shaafaa heerappe iyaakko yoosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Bantta nagaraa paaxidi Yorddaanose Shaafan Yohaannisa kushen xammaqettosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Yohaannisi, daro Farisaawetinne Saduqaaweti xammaqettanaw baakko yeyssata be7idi, enttako, “Ha iita shooshatoo, yaana Xoossaa hanquwafe baqatana mela hinttena oone zoriday? ");
INSERT INTO gofRNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Hiza, hinttee, hintte nagaraappe simmidayssa erisiyabaa oothite. ");
INSERT INTO gofRNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Hinttee, hintte wozanan, ‘Abrahamey, nu aaway de7ees’ gidi qoppofite. Loythi si7ite! Xoossay ha shuchchatappe Abrahames na7a kessanaw dandda7ees. ");
INSERT INTO gofRNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Beexey mithaa xaphuwan giigidi uttis; lo77o ayfe ayfonna mitha ubbay qanxettidi taman yegettana. ");
INSERT INTO gofRNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Hinttee, hintte nagaraappe simmidayssa erisanaw taani hinttena haathan xammaqays. Shin taappe guyera yeyssi hinttena Geeshsha Ayyaananinne taman xammaqana. I taappe daro wolqqaamees; taani hari attoshin iya caammaa tookkanawukka bessike. ");
INSERT INTO gofRNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Kathaa geeshshiya pithey iya kushen de7ees. Kathaa loythi geeshshees; gisttiya ba shaaliyan qolana, shin punuwa to7onna taman xuuggana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","He wode Yesuusi Yohaannisa kushen xammaqettanaw Galiilappe Yorddaanose Shaafaa bis. ");
INSERT INTO gofRNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Shin Yohaannisi iya digganaw koyid, “Taani nenan xammaqettanaw koshshishin neeni taakko yay?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Shin Yesuusi zaaridi, “Xoossay nuuppe koyabaa ubbaa nu polanaw bessiya gisho ha77i taw ero ga” yaagis. Yohaannisi iyaw ero gidi ekkis. ");
INSERT INTO gofRNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yesuusi xammaqettida mela haathaafe keyis. Iirakka saloy dooyettin Xoossaa Ayyaanay holleda yishin qassi ba bolla wol77ammidi wodhdhishin be7is. ");
INSERT INTO gofRNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","He wode “Ta dosiya, iyan tana ufayssiya ta na7ay hayssa” yaagiya qaalay saloppe yis. ");
INSERT INTO gofRNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Hessafe guye, Xalahey Yesuusa paaccana mela Geeshsha Ayyaanay Yesuusa bazzo biittaa efis. ");
INSERT INTO gofRNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Oytamu qammanne oytamu gallas xoomidaappe guye koshattis. ");
INSERT INTO gofRNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Xalahey Yesuusakko yidi “Neeni Xoossaa na7a gidikko, ane ha shuchchati uythi gidana mela kiitta” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yesuusi zaaridi, “ ‘Asi Xoossaa doonappe keyaa qaala ubban daanappe attin uytha xalaalan de7enna’ geetettidi Xoossaa qaalan xaafettis” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Kaallidikka, Xalahey Yesuusa geeshsha katamaa efidi, Xoossaa keetha huu7iya kessidi, ");
INSERT INTO gofRNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","“Neeni Xoossaa na7a gidikko, ane duge sa7an kundda. Ays giikko, ‘Ne tohoy shuchchan dhubetti deshettonna mela, bantta kushiyan nena denthana mela, Xoossay ba kiitanchchota ne gisho kiittana’ geetettidi Xoossaa qaalan xaafettis” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesuusi iyaakko, “Qassika, ‘Xoossaa qaalan ne Godaa, ne Xoossaa paaccofa’ yaagettidi xaafettis” gidi zaaris. ");
INSERT INTO gofRNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Wurssethan Xalahey Yesuusa issi wolqqaama deriya huu7e kessidi alamiya kawotethata entta bonchchuwara issife bessidi, ");
INSERT INTO gofRNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","“Ne taw kunddada goynniko ta new ha ubbaa immana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yesuusi zaaridi, “Ha Xalahiyaw, taappe haakka! ‘Ne Godaa, ne Xoossaa goynna, iya xalaala haggaaza’ geetettidi Xoossaa qaalan xaafettis” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Hessafe guye, Xalahey aggidi bis; kiitanchchoti yidi iya haggaazidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yesuusi, Yohaannisi qashettoyssa si7ida wode Galiila biittaa bis. ");
INSERT INTO gofRNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Naazirete katamaa aggidi Zaabiloonaninne Niftaaleme heeran, abbaa matan de7iya Qifirnahoome katamaa bidi yan de7is. ");
INSERT INTO gofRNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Hessi haniday nabiya Isayaasa doonan, ");
INSERT INTO gofRNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Zaabiloone biittan, Niftaaleme biittan, Yorddaanose Shaafappe hefinthan, abbaa ogiya gaxan de7iya, Ayhude gidonna derey de7iya Galiilan, ");
INSERT INTO gofRNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","dhuman de7iya derey, wolqqaama poo7o be7is. Hayqo kuya biittan, de7eyssatas poo7oy keyis” yaagidi odettida qaalay polettana melassa. ");
INSERT INTO gofRNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","He wodeppe doomidi Yesuusi, “Xoossaa kawotethay matattida gisho hintte nagaraappe simmite” yaagidi qaala sabbakees. ");
INSERT INTO gofRNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesuusi Galiila Abbaa matara aadhdhishe nam77u ishata, Phexiroosa geetettiya Simoonanne iya ishaa Inddiriyasa be7is. Entti molo oykkeyssata gidida gisho bantta gitiya abban yeggoosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesuusi enttana, “Haa yiite; tana kaallite! Molo oythi attoshin, ta hinttena ase oythi tamaarssana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Enttika, ellesidi bantta gitiya yeggi aggidi Yesuusa kaallidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Yesuusi yaappe buroo gede sinthe aadhdhishe hara nam77u ishata, Zabdiyoosa nayta, Yayqoobanne Yohaannisa be7is. Bantta aawa Zabdiyoosara issife wogoluwa giddon bantta gitiya giigiseyssata xeegis. ");
INSERT INTO gofRNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Enttika, ellesidi bantta wogoluwanne bantta aawa aggidi Yesuusa kaallidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesuusi Ayhude Woosa Keethatan tamaarssishe, salo kawotethaa Wonggelaa odishenne dumma dumma harggiyafe asaa pathishe Galiila biitta ubban yuuyis. ");
INSERT INTO gofRNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Hessafe denddoyssan iya sunthay Sooriya biitta ubban keyis. Dumma dumma harggen oykettidayssatanne waayetteyssata, tuna ayyaanan oykettidayssata, shoci yeggiya harggen oykettidayssatanne, gunddata iyaakko ehidosona; ikka enttana pathis. ");
INSERT INTO gofRNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Asay Galiilappe, Tammu Katamatappe, Yerusalaameppe, Yihudappenne Yorddaanose Shaafaa hefinthan de7iya biittaafe yida daro asay iya kaallidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Daro derey shiiqidayssa Yesuusi be7ida wode deriya bolla keyidi uttis. Iya tamaareti iyaakko shiiqin, ");
INSERT INTO gofRNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","hayssada yaagidi tamaarssis: ");
INSERT INTO gofRNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Bantta ayyaanan manqoti anjjettidayssata, salo kawotethay enttassa. ");
INSERT INTO gofRNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Yeekkeyssati anjjettidayssata, entti minthetho demmana. ");
INSERT INTO gofRNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Bantta wozanan ashkketi anjjettidayssata, entti sa7aa laattana. ");
INSERT INTO gofRNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Xillobaa oothanaw koshatteyssatinne saamotteyssati anjjettidayssata, entti kallana. ");
INSERT INTO gofRNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Maareyssati anjjettidayssata, entti maarotethi demmana. ");
INSERT INTO gofRNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Wozana geeshshati anjjettidayssata, entti Xoossaa be7ana. ");
INSERT INTO gofRNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Sigetheyssati anjjettidayssata, entti Xoossaa nayta geetetti xeegettana. ");
INSERT INTO gofRNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Xillobaa oothiya gisho gidi, goodetteyssati anjjettidayssata, salo kawotethay enttassa. ");
INSERT INTO gofRNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Asay hinttena ta gisho gidi cayaa wode gooddiya wodenne hintte bolla iitabaa ubbaa worddon odisiya wode hintte anjjettidayssata. ");
INSERT INTO gofRNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Hintte woytoy salon gita gidiya gisho ufayttite, hashshu giite. Hinttefe kase de7iya nabeta hessada goodidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Hinttee biittaas maxine; maxiney ba maxinetethaa aggiko, ba mal77otethaa waati zaari demmanee? Kare holin asan yedhdhettanaappe attin aybiskka maaddenna. ");
INSERT INTO gofRNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Hintte biittaas poo7o; dere bolla de7iya katamiya qosettanaw dandda7ukku. ");
INSERT INTO gofRNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Xomppe oythidi son de7iya asa ubbaas poo7ana mela dhoqqa son wotheesippe attin daallo gidon wothey baawa. ");
INSERT INTO gofRNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Hessa mela asay hintte lo77o oosuwa be7idi, salon de7iya hintte aawa bonchchana mela hintte poo7oy asa sinthan poo7o. ");
INSERT INTO gofRNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Taani Muse higgiyanne nabeta qaala shaaranaw yida hinttew daanoppo. Taani, entti odidayssi tuma gideyssa qonccisanaw yasippe attin shaaranaw yabiikke. ");
INSERT INTO gofRNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ta hinttew tuma odays; saloynne sa7ay aadhdhana gakkanaw higge ubbay polettanaappe attin higgiyafe issi qaalay woykko pidaaley aadhdhenna. ");
INSERT INTO gofRNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Hessa gisho, ha kiitatappe guuxiya issi kiitaa menthiya oonikka qassi harata hessatho oothana mela tamaarssey oonikka salo kawotethan ubbaafe guutha gidana. Shin ha kiitaa poleysinne haratakka polana mela tamaarssey salo kawotethan gita gidana. ");
INSERT INTO gofRNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ta hinttew odays; hintte xillotethay Farisaaweta xillotethaafenne higge asttamaareta xillotethaafe aadhdhonna ixxiko, salo kawotethaa gelekketa. ");
INSERT INTO gofRNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Hintte mayzatas, ‘Wodhoppite; shemppo wodhida oonikka pirddettana’ geetettoyssa si7ideta. ");
INSERT INTO gofRNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Shin ta hinttew odays; ba ishaa hanqettiya ubbay pirddettana. Ba ishaa cayaa oonikka daynna sinthi pirddas shiiqana. Ba ishaakko, ‘Eeyay’ giya oonikka qassi gaanname taman pirddettana. ");
INSERT INTO gofRNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Hessa gisho, neeni ne yarshshuwa yarshshiya wode ne ishaa qohidabay new akeeketiko, ");
INSERT INTO gofRNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ne yarshshuwa he bessan aggada ba; koyrota bada ne ishaara giiga; yaata simmada, ne yarshshuwa Xoossaas yarshsha. ");
INSERT INTO gofRNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Nena mooteyssara pirdda keethi bashe oge bolla iyara giiga. Hessi atto giikko I nena daynna sinthi efana. Daynnay nena qachcheyssas aathi immana; I nena woynen yeggana. ");
INSERT INTO gofRNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ta tuma odays; ne bolla pirddettida accuwa issi santimey attonna cigga onggana gakkanaw qasho keethafe keyakka. ");
INSERT INTO gofRNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Hayssafe kase, ‘Laymatoppite’ geetettoyssa si7ideta. ");
INSERT INTO gofRNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Shin ta hinttew odays, maccas xeellidi, amottida ubbay ba wozanan iira laymatees. ");
INSERT INTO gofRNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ne ushachcha ayfey new nagaras gaaso gidikko, kessa hola. Ne asatethay kumethi gaanname taman wodhdhanaappe ne asatethaafe issoy dhayikko new lo77o. ");
INSERT INTO gofRNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ne ushachcha kushey new nagaras gaaso gidikko, iya qanxa hola. Ne asatethay kumethi gaanname taman wodhdhanaappe ne asatethaafe issoy dhayikko, new lo77o. ");
INSERT INTO gofRNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“ ‘Ba machchiw yeddiya oonikka anjjo warqqatiya immo’ geetettis. ");
INSERT INTO gofRNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Shin ta hinttew odays; ba machchiya laymatonna de7ishin billiya oonikka iya laymatana mela oothees. Hessadakka, anjjettida maccasiw ekkiya ubbay laymatees. ");
INSERT INTO gofRNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Hintte mayzatakko, ‘Worddon caaqqofite; hintte Xoossaa sinthan caaqqidayssa polite’ geetettidayssa si7ideta. ");
INSERT INTO gofRNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Shin ta hinttew odays; ubbarakka caaqqofite. Xoossay uttiya araata gidiya gisho salon caaqqofite. ");
INSERT INTO gofRNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Iya tohoy yedhdhiya soo gidiya gisho sa7ankka caaqqofite. Gita kawuwa katama gidiya gisho Yerusalaamenkka caaqqofite. ");
INSERT INTO gofRNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Hintte binaanappe issuwaka boothi woykko kareethi oothanaw dandda7onna gisho hinttee hintte huu7enkka caaqqofite. ");
INSERT INTO gofRNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Hessa gisho, hintte qaalay, ‘Ee’ woykko ‘Akkay’ gido. Hessafe kare keyey Xalaheppe yees. ");
INSERT INTO gofRNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“ ‘Ayfe gisho ayfe; achcha gisho achche’ geetettidayssa si7ideta. ");
INSERT INTO gofRNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Shin ta hinttew odays; hintte bolla iitabaa oothiya uraara eqettofite. Oonikka ne ushachcha shakalaa baqqiko ne haddirssa shakalaakka bessa. ");
INSERT INTO gofRNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Issi asi ne shaamiziya ekkanaw nena mootikko, ne kootiya gujjada imma. ");
INSERT INTO gofRNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Issi asi nena wolqqan babaa toossidi issi saate oge baara baana mela nena un77ethiko, iyara nam77u saate oge ba. ");
INSERT INTO gofRNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Woossiya ooddeskka imma; neeppe tal77anaw koyaa oonakka diggofa. ");
INSERT INTO gofRNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“ ‘Nena doseyssa dosa; nena ixxeyssa ixxa’ geetettoyssa si7ideta. ");
INSERT INTO gofRNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Shin ta hinttew odays; hintte morkketa dosite; hinttena qoheyssatas woossite. ");
INSERT INTO gofRNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Hessatho hintte oothiko, salon de7iya hintte aawas hintte nayta gidana. I iitatasinne lo77otas awa kessees; xillotasinne nagaranchchotas ba iraa bukisees. ");
INSERT INTO gofRNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Hinttena dosiya asaa xalaala hintte dosikko, hinttew ay woytoy de7ii? Hari attoshin, qaraxa qanxiseyssatikka hessa oothoosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Hinttee, hintte ishata xalaala sarothiko, haratappe ay hara aadhdhiyabaa oothidetii? Hari attoshin, Xoossaa ammanonna asaykka hessa oothoosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Hiza, salon de7iya hintte aaway polo gidoyssada hintteka polo gidite. ");
INSERT INTO gofRNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Asi be7o gidi hintte lo77o oosuwa asa sinthan oothonnaada naagettite. Hessatho hanonna ixxiko salon de7iya hintte Aawappe woyto demmeketa. ");
INSERT INTO gofRNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Hinttee manqotas immiya wode asa sinthan bonchchettanaw gidi cubboti ogiya doonaninne Ayhude Woosa Keethatan ootheyssada asi be7o gidi oothofite. Ta hinttew tuma odays; entti bantta kumetha woytuwa ekkidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Shin hinttee manqotas immiya wode hintte ushachcha kushey ootheyssa hintte haddirssa kushey eroppo; ");
INSERT INTO gofRNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","hintte imoy geeman gido. Geeman ootheyssa be7iya hintte aaway hinttew woytuwa qonccen immana. ");
INSERT INTO gofRNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Woosa woossishe cubbotatho hanoppite. Entti, banttana asi be7o gidi Ayhude Woosa Keethaninne ogiya doonan eqqidi woosseyssa dosoosona. Ta hinttew tuma odays; entti bantta kumetha woytuwa ekkidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Shin neeni woossiya wode ne soo gela, wulaa gorddada geeman de7iya ne Aawakko woossa; geeman oosettidayssa be7iya ne aaway new woytuwa immana. ");
INSERT INTO gofRNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Hintte woossiya wode ammanonna asaatho coo qaala darssidi woossofite. Entti adussi woossin Xoossay si7ees gidi qoppoosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Hessa gisho, enttayssada hanoppite. Ays giikko, hintte aaway hinttew ay koshshiyako hintte woossanaappe sinthattidi erees. ");
INSERT INTO gofRNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Hiza, hintte yaagidi woossite: ‘Salon de7iya nu aawaw, ne geeshsha sunthay anjjetto. ");
INSERT INTO gofRNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ne kawotethay yo, ne sheney salon hanidayssada sa7ankka hano. ");
INSERT INTO gofRNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Gallasa kathaa hachchi hachchi nuus imma. ");
INSERT INTO gofRNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Nuuni nuna qohidayssata, atto geyssada, nuuskka nu qohuwa atto ga. ");
INSERT INTO gofRNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Nuna iitappe ashshafe attin paacen gelssofa. Kawotethay, wolqqaynne bonchchoy merinaw neessa. Amin77i.’ ");
INSERT INTO gofRNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Hintte hinttena qohidayssata atto giikko, salon de7iya hintte Aaway hintte qohuwakka atto gaana. ");
INSERT INTO gofRNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Shin hintte hara asa nagara atto goonna ixxiko hintte Aaway hintte nagara atto geenna. ");
INSERT INTO gofRNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Hintte xoomiya wode cubbotatho kayottofite. Ays giikko, entti xoomeyssa asi erana mela bantta som77uwa qitayoosona. Ta tuma odays; entti bantta woytuwa ekkidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","“Shin neeni xoomiya wode ne som77uwa meecca, ne huu7iya tiyetta. ");
INSERT INTO gofRNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Hessada ne oothiko ne xoomiya xoomay asappe geemmidayssa, shin geeman de7iya ne Aaway eriya xooma gidana. Geeman oosettidayssa be7iya ne Aaway new woytuwa immana. ");
INSERT INTO gofRNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Bili miyason, biraati shi7iyason, kaysoy bookkidi ekkiyason, ha sa7an, hinttew shalo shiishoppite. ");
INSERT INTO gofRNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Shin bili moonason, biraati shi7onnason, kaysoy bookkidi ekkonnason salon hinttew shalo shiishite. ");
INSERT INTO gofRNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ne shaloy de7iyasuwan ne wozanay de7ana. ");
INSERT INTO gofRNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Ayfey asatethaas xomppe. Hessa gisho, ne ayfey paxa gidikko ne kumetha asatethay poo7o gidees. ");
INSERT INTO gofRNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ne ayfey hargganchcho gidikko ne kumetha asatethay dhuma gidees. Hiza, nenan de7iya poo7oy dhuma gidikko, dhumay ay mela aadhdhidi dhumanddeshsha! ");
INSERT INTO gofRNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Issi asi nam77u godas haarettanaw dandda7enna. Issuwa dosikko hankkuwa ixxees; woykko issuwa bonchchiko hankkuwa kadhees. Xoossasinne miishes haarettanaw dandda7ekketa. ");
INSERT INTO gofRNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Hiza, si7ite! Hinttee de7on daanaw, ‘Ay maanee? Ay uyanee? Ay ma77anee?’ gidi un77ettofite; de7oy kathafe woykko ma7oppe aadhdhenee? ");
INSERT INTO gofRNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Salo kafota xeellite; entti zerokkona, buuccokona, shaalen yeggokona, shin hintte salo aaway entta muzees. Hintte enttafe keehi aadhdheketii? ");
INSERT INTO gofRNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Hintte giddofe daro un7ettidi ba laythaa bolla issi gallas gujjanaw dandda7ey de7ii? ");
INSERT INTO gofRNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Qassi hintte ma77iyabaas ays un7ettetii? Ane ciishshata be7ite, ooson daaburokkona woykko suqqokona. ");
INSERT INTO gofRNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Si7ite! Hari attoshin, kawuwa Solomoney ba bonchcho ubban ha ciishshatappe issuwa melakka ma77ibeenna. ");
INSERT INTO gofRNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Hinttenoo, ammanoy paccidayssato, Xoossay hachchi benttidi wontto taman wodhdhanaw de7iya maata yaatidi mayziyabaa gidikko, hinttena enttafe aathidi waati mayzennee? ");
INSERT INTO gofRNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Hessa gisho, ‘Ay maanee? Ay uyanee? Ay ma77anee?’ gidi un77ettofite. ");
INSERT INTO gofRNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","He ubbaa Xoossaa ammanonna asay darssidi demmanaw un77ettoosona. Hintte salo aaway he ubbay hinttew koshsheyssa erees. ");
INSERT INTO gofRNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Shin ubbaafe sinthe Xoossaa kawotethaanne iya xillotethaa koyite; he ubbay hinttew gujji imettana. ");
INSERT INTO gofRNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Hessa gisho, wonttos qoppishe un77ettofite. Wonttoyssi wonttos aqo; issi issi gallasay baw gidiya metora de7ees. ");
INSERT INTO gofRNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Hintte bolla pirddettonna mela harata bolla pirddofite. ");
INSERT INTO gofRNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ays giikko, harata bolla hintte pirddeyssada hintte bolla pirddettana; hintte haratas makkidaban hinttew zaari makettana. ");
INSERT INTO gofRNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ne ayfen de7iya tuussu daaneyssa be7onna ne ishaa ayfen de7iya buuriya ays be7ay? ");
INSERT INTO gofRNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ne ayfen tuussi de7ishin ne ishaa ayfen de7iya buuriya kesso gaanaw waana dandda7ay? ");
INSERT INTO gofRNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Neno cubbuwaw, koyrottada ne ayfen de7iya tuussi daaneyssa kessa. Iyappe guye, ne ishaa ayfen de7iya buuriya kessanaw ne geeshsha xeellana. ");
INSERT INTO gofRNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Guye simmidi hinttena saxxonna mela geeshshabaa kanatas yeggofite. Bantta tohuwan yedhdhidi iissonna mela hintte al77o inquwa gudunthota sinthan yeggofite. ");
INSERT INTO gofRNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Woossite hinttew imettana, koyite hintte demmana, kare yidi xeegite hinttew dooyettana. ");
INSERT INTO gofRNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Woossiya ooddeskka imettana, koyaa ooddeskka benttana, kare yidi xeegiya ooddeskka dooyettana. ");
INSERT INTO gofRNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Hintte giddofe ba na7i uythi woossiko shuchchi immey oonee? ");
INSERT INTO gofRNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Woykko molo woossiko shooshi immey de7ii? ");
INSERT INTO gofRNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Yaatin hintte iita gidishe hintte naytas lo77obaa imo erikko, hintte salo aaway bana woosseyssatas lo77obaa waati darssidi immenee? ");
INSERT INTO gofRNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Harati hinttew oothana mela hintte koyabaa ubbaa hintteka haratas oothite. Ays giikko, Muse higgeynne nabeti tamaarssey hayssa. ");
INSERT INTO gofRNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Xuuntha wulara gelite; ays giikko, dhayos efiya ogey wogga, wulaykka dalgga. Iyara geliya asaykka daro. ");
INSERT INTO gofRNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Shin de7uwakko efiya ogeynne wulay xuunthu; yaa geliya asaykka guutha. ");
INSERT INTO gofRNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Bolla baggara dorsse daanidi bantta gaathan suudhume gididi hintte giddo geliya worddanchcho nabetappe naagettite. ");
INSERT INTO gofRNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Hintte entta, entta ayfiyaappe erana; agunthafe woyney, kinchchoteppe laadey maxettenna. ");
INSERT INTO gofRNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Hessa mela lo77o mithi ubbay lo77o ayfe ayfees; iita mithi iita ayfe ayfees. ");
INSERT INTO gofRNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Lo77o mithi iita ayfe ayfenna, qassi iita mithi lo77o ayfe ayfanaw dandda7enna. ");
INSERT INTO gofRNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Lo77o ayfe ayfonna mithi ubbay qanxettidi taman xuugettana. ");
INSERT INTO gofRNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Hessa gisho, hintte entta, entta ayfiyaan erana. ");
INSERT INTO gofRNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Salon de7iya ta aawa sheniya oothiya uray salo kawotethi gelanaappe attin coo tana ‘Godaw, Godaw’ giya ubbay salo kawotethi gelenna. ");
INSERT INTO gofRNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Pirdda gallas daroti, ‘Godaw, Godaw, ne sunthan tinbbite odibookko? Ne sunthan tuna ayyaanata kessibookko? Ne sunthan malaatata oothibookkoo?’ yaagana. ");
INSERT INTO gofRNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","He wode taani, ‘Ta hinttena ubbarakka erikke, hinttee iita ootheyssati taappe haakkite’ yaagana. ");
INSERT INTO gofRNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Hiza, ha ta qaala si7idi oothiya oonikka ba keethaa shuchcha bolla keexida wozanaama asa mela. ");
INSERT INTO gofRNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Iray bukkis, di7oy di77is, carkkoyka carkkidi he keethaa sugis. Shin keethay shuchcha baaso bolla keexettida gisho kunddibeenna. ");
INSERT INTO gofRNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ha ta qaala si7idi oothonna oonikka ba keethaa shafe bolla keexida eeya uraa mela. ");
INSERT INTO gofRNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Iray bukkidi, di7oy di77idi, carkkoyka carkkidi, he keethaa sugin, he keethay kunddis; iya kunddethaykka wolqqaama” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","Yesuusi ba oda onggida wode iya timirttey higge asttamaareta mela gidonna maatara gidiya gisho asay iya timirttiyan malaalettidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesuusi deriyappe wodhdhiya wode daro asay iya kaallidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Hekko issi baro hargganchchoy iyaakko shiiqidi, iya sinthan gulbbatidi, “Godaw, ne shene gidikko tana geeshshada pathanaw dandda7aasa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesuusi ba kushiya yeddidi iya bochchidi, “Ee, ta shene, paxa” yaagis. Uray iirakka geeyi aggis. ");
INSERT INTO gofRNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yesuusi iyaakko, “Ne paxuwa ooddeskka odoppa. Shin bada ne geeyada paxoyssa kahine bessa. Ne paxuwas markka gidana mela bada Musey kiittida yarshshuwa yarshsha” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesuusi Qifirnahoome katama gakkida wode issi mato halaqay iyaakko shiiqidi, ");
INSERT INTO gofRNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Godaw, ta aylley asatethay gunddin daro harggettidi, son zin77idi de7ees” yaagidi woossis. ");
INSERT INTO gofRNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesuusi zaaridi, “Taani bada iya pathana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Shin mato halaqay zaaridi, “Godaw, ne ta soo gelanaw bessiya asi gidikke, shin ne han uttada qaala xalaala oda, ta aylley paxana. ");
INSERT INTO gofRNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ays giikko, taappe bollara ta kiitettiya asati de7oosona, qassi taappe garssara taw kiitetteyssati de7oosona. Enttafe issuwa, ‘Ba’ giyade bees; hankkuwa qassi ‘Haaya!’ giyade yees. Ta aylliya, ‘Hayssa ootha’ giyade oothees” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesuusi hessa si7ida wode malaalettidi, bana kaalliya asaakko, “Ta hinttew tuma odays; taani hayssa mela ammano Isra7eele asankka be7abiikke. ");
INSERT INTO gofRNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ta hinttew odays; daroti dolohappenne wulohappe yidi, salo kawotethan Abrahamera, Yisaaqaranne Yayqoobara issife imato bolla uttana. ");
INSERT INTO gofRNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Shin salo kawotethaa laattanaw bessishin attidayssati kare dhuman holettana. Yan enttaw yeehonne achcha garccethi gidana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yesuusi mato halaqaakko, “Ne soo ba, ne ammanuwatho new hano” yaagis. Iya aylley sohuwara paxi aggis. ");
INSERT INTO gofRNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesuusi Phexiroosa soo geliya wode Phexiroosa machche aayyaa qoxo misha harggen sakettada zin77idaaro be7is. ");
INSERT INTO gofRNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yesuusi I kushiya bochchida wode qoxoynne mishay aggi aggis. Paxa denddada iya mokkasu. ");
INSERT INTO gofRNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","He wode omarssi tuna ayyaanan oykettida daro asata, asay Yesuusakko ehidosona. Ikka tuna ayyaanata ba qaalan kessis, hargganchchota ubbaa pathis. ");
INSERT INTO gofRNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Hessankka nabiya Isayaasi, “I nu harggiya baw ekkis, i nu harggiya tookkis” gida qaalay polettis. ");
INSERT INTO gofRNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesuusi daro asay iya yuushuwan eqqidayssa be7idi, abbaafe hefinthi pinnana mela ba tamaareta kiittis. ");
INSERT INTO gofRNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Higge asttamaaretappe issoy, “Asttamaariyaw, ne biyaso ubbaa ta kaallana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesuusi iyaakko “Workkanatas olli de7ees, salo kafotas keethi de7ees. Shin Asa Na7aas ba huu7iya shemppisiya bessi baawa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Yesuusa kaalliya asatappe issoy, “Godaw, taani sinthata bada ta aawa moogada yaana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Shin Yesuusi, “Hayqqidayssati bantta hayqota moogo; neeni tana kaalla” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yesuusi baanaw wogoluwan gelida wode iya tamaaretikka iyara baanaw gelidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Entti qopponna de7ishin, wolqqaama hobbey haatha bolla denddin wogoloy mitettanaw gakkis. Shin Yesuusi dhiskkis. ");
INSERT INTO gofRNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Iya tamaareti iyaakko shiiqidi iya barkkethidi, “Godaw, nu dhayos nuna ashsharkkii” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yesuusi enttako, “Hinttenoo, ammanoy paccidayssato, ays yayyetii?” yaagis. Denddidi, hobbiyanne gotiya essis. Ellesidi ubbabay si77i gis. ");
INSERT INTO gofRNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Iya tamaareti malaalettidi, “Hayssi, hari attoshin, hobbeynne gotey kiitetteyssi waanida asee?” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yesuusi abbaafe hefinthan de7iya Gerggesoone giya biittaa gakkida wode tuna ayyaanay oykkida nam77u asati duufoppe keyidi iyara gahettidosona. Entti daro iitanne yashshiya asata gidiya gisho asi he bessaara aadhdhanaw dandda7enna. ");
INSERT INTO gofRNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Enttika, “Xoossaa Na7aw, nunanne nena aybe gathey? Wodey gakkonna de7ishin nuna pirddanaw yadii?” gidi waassidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Enttafe daro haakkonna guduntho wudey heemettes. ");
INSERT INTO gofRNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Tuna ayyaanati Yesuusa, “Ne nuna kessanabaa gidikko, hini guduntho wudiya giddo yeddarkkii” yaagidi woossidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yesuusi, “Biite” yaagis. Tuna ayyaanati asatappe keyidi gudunthotan gelidosona. Gudunthoti ubbay aafo doonara dirggidi bidi abban mitettidi hayqqidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Guduntho wudiya heemmeyssati baqatidi katama bidi, hanidabaanne tuna ayyaanay oykkida asata bolla oosettidaba ubbaa odidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Yaatin, kataman de7iya asa ubbay Yesuusa be7anaw keyidosona. Entti Yesuusa be7ida wode bantta biittaafe keyidi baana mela woossidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Hessafe guye, Yesuusi wogoluwan gelidi, abbaa pinnidi ba katamaa bis. ");
INSERT INTO gofRNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Hanida guutha asati issi gundda uraa alggara tookkidi Yesuusakko ehidosona. Yesuusi entta ammanuwa be7idi, gundda uraa, “Ta na7aw, yayyofa! Ne nagaray atto geetettis” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","He saatiyan, Ayhude higge asttamaaretappe issoti issoti, “Hayssi Xoossaa cashshe gidennee” yaagidi bantta wozanan qoppidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesuusi entta qofaa eridi, “Iitabaa hintte wozanan ays qoppeetii? ");
INSERT INTO gofRNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Hanoshin, ‘Ne nagaray atto geetettis’ geyssafenne ‘Dendda eqqada ba’ geyssafe awussi kawuyii? ");
INSERT INTO gofRNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Shin sa7a bolla nagara atto gaanaw Asa Na7aas maati de7eyssa ta hinttena erisana” yaagidi, gundda addiyako, “Dendda eqqa, ne alggaa tookkada, ne soo ba” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Gundda uray denddidi ba soo bis. ");
INSERT INTO gofRNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Derey hessa be7idi malaalettidosona. Hessa mela maata asas immida Xoossaa galatidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesuusi yaappe denddidi bishe Maatoosa geyssa qaraxa qanxisiya bessan uttidashin be7idi, “Tana kaalla” yaagis. Ikka denddidi kaallis. ");
INSERT INTO gofRNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yesuusi Maatoosa son gayta bolla uttidashin, qaraxa qanxisiya daro asatinne nagaranchchoti yidi iyaranne iya tamaaretara issife maanaw uttidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Issi issi Farisaaweti hessa be7idi, Yesuusa tamaareta, “Hintte asttamaarey qaraxa qanxiseyssataranne nagaranchchotara ays mii?” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesuusi hessa si7idi, “Dhale koshshey haragganchchotassafe attin paxatassa gidenna. ");
INSERT INTO gofRNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Shin hintte bidi, ‘Taani hintte yarshshuwa gidonnashin hintte harata maarana mela koyays’ geetettidi xaafettidayssi woy guusseeko erite. Ays giikko, taani nagaranchchota xeeganaw yasippe attin xillota xeeganaw yabiikke” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","He wode Yohaannisa tamaareti Yesuusakko shiiqidi, “Nunne Farisaaweti xoomos, shin ne tamaareti ays xoomokkonaa?” yaagidi oychchidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesuusi zaaridi enttako, “Mushuray enttara de7ishin xeegettidi yida asay kayottanaw dandda7oona? Mushuray entta matappe ekettana wodey yaana, entti he wode xoomana. ");
INSERT INTO gofRNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Ooratha ma7oppe peedhidi gal77a ma7o bolla sikkey oonikka baawa. Hessatho oothiko oorathay gal77aa peedhees. Peedhethayka gujji dalggees. ");
INSERT INTO gofRNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ooratha woyne gal77a ogoron qoliya oonikka baawa. Hessatho oothiko ooratha woyney gal77a ogoruwa dhusees woyneykka gukkees; ogoroykka nam77antho maaddonnabaa gidees. Shin ooratha woyney ooratha ogoron qoletanaw bessees. Hessatho oosettiko nam77ayka iitonna naagettoosona” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesuusi hessa odo bolla de7ishin, Ayhude halaqatappe issoy iyaakko yidi, iya sinthan gulbbatidi, “Ta na7iya ha77i hayqqasu, shin iya paxana mela neeni yada ne kushiya I bolla wotharkkii” gidi woossis. ");
INSERT INTO gofRNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yesuusi denddidi iyara bis; iya tamaaretikka kaallidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","I bishin tammanne nam77u laythi kumethi suuthi goggidi waaysiya issi maccasiya guyera shiiqada Yesuusa afilaa macaraa bochchasu. ");
INSERT INTO gofRNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Iya ba wozanan, “Ta iya afilaa macaraa xalaala bochchiyakko paxana” yaagada qoppasu. ");
INSERT INTO gofRNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesuusi guye simmi iyo xeellidi, “Ta naatte, yayyofa! Nena ne ammanoy pathis” yaagis. Maccasiya sohuwara paxa aggasu. ");
INSERT INTO gofRNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yesuusi Ayhude halaqaa soo gakkiya wode zaye punneyssatanne yeekkeyssata be7idi, ");
INSERT INTO gofRNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","“Ane kichchite; guutha na7iya dhiskkasuppe attin hayqqabuukku” yaagis. Shin asay iya bolla miicidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Asaa kare kessidaappe guye soo gelidi, na7ee kushiya oykkis, na7iya dendda eqqasu. ");
INSERT INTO gofRNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","He worey he biitta ubbaa gakkis. ");
INSERT INTO gofRNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesuusi yaappe denddidi gede sinthe biya wode nam77u qooqeti bantta qaala dhoqqu oothidi, “Dawite na7aw, nuna maararkii” yaagishe iya kaallidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yesuusi soo gelida wode qooqeti iya kaallidi yidosona. Yesuusi enttako, “Taani hessa oothanaw dandda7eyssa hintte ammaneetii?” yaagis. Enttika, “Ee, Godaw” yaagidi zaaridosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Hessafe guye, Yesuusi entta ayfiyaa bochchidi enttako, “Hinttew, hintte ammanuwatho hano” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Entta ayfeykka dooyettis. Yesuusi enttako, “Hayssa ooddeskka odoppite” yaagidi minthi odis. ");
INSERT INTO gofRNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Shin asati bidi Yesuusabaa he biitta ubban odidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Entti yaappe keyaa wode asay tuna ayyaanay oykkidi muumisida issi asi Yesuusakko ehidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Tuna ayyaanay keyidaappe guye muume uray odettis. Dereykka malaalettidi, “Hayssa mela oorathabay Isra7eele biittan hanibeenna” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Shin Farisaaweti, “Tuna ayyaanata halaqan tuna ayyaanata kessees” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesuusi Ayhude Woosa Keethatan tamaarssishe, salo kawotethaa Wonggelaa sabbakishe, asaa hargge ubbaafe pathishe katamataninne guta ubban yuuyis. ");
INSERT INTO gofRNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Daro derey, heemmiya asi baynna dorssada enttana be7iya asi dhayin un77ettidi de7eyssata be7idi enttaw qadhettis. ");
INSERT INTO gofRNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ba tamaaretakko, “Shiiqana kathay daro, shin kathaa shiishiya asay guutha. ");
INSERT INTO gofRNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Hessa gisho, Goday kathaa shiishiya oosanchchota yeddana mela woossite” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesuusi tammanne nam77u tamaareta baakko xeegidi, tuna ayyaanata kessana melanne hargge ubbaa pathana mela enttaw maata immis. ");
INSERT INTO gofRNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Yesuusi kiittida tammanne nam77u hawaareta sunthay: koyroy Phexiroosa giya Simoonanne iya ishaa Inddiriyasa, Zabdiyoosa na7aa Yayqoobanne iya ishaa Yohaannisa, ");
INSERT INTO gofRNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filphoosanne Bartolomiyoosa, Toomasanne qaraxa qanxisiya Maatoosa, Ilfiyoosa na7aa Yayqooba, Taadiyosa, ");
INSERT INTO gofRNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ba biittaas mishettiya Simoonanne Yesuusa aathi immida Asqoroota Yihuda. ");
INSERT INTO gofRNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","He tammanne nam77ata Yesuusi kiittidi yeddishe, “Ayhude gidonna deriyakko booppite, qassi Samaareta katamakka geloppite. ");
INSERT INTO gofRNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Shin Isra7eele keethaafe gidida hini dhayida dorssatakko biite. ");
INSERT INTO gofRNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Yaa bidi, ‘Salo kawotethay matattis’ gidi odite. ");
INSERT INTO gofRNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Hargganchchota pathite, hayqqidayssata hayqoppe denthite, baro hargganchchota geeshshi pathite, tuna ayyaanata kessite. Hintte coo ekkidayssa coo immite. ");
INSERT INTO gofRNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Hintte kiisen worqqa, woykko bira santime oykkofite. ");
INSERT INTO gofRNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Hintte ogiyas karxiito, nam77u afila, woykko caamma woykko xam77a oykkofite; oosanchchuwas gallasa kathi koshshees. ");
INSERT INTO gofRNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Hintte issi katamaa woykko gutaa geliya wode hinttena mokkidi ekkanaw ufayttiya uraa koyidi iya son shemppite; hintte baana gakkanaw yan gam77ite. ");
INSERT INTO gofRNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Qassi oodde sookka gelishe sarothite. ");
INSERT INTO gofRNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","He keethay hinttena mokkiko hintte sarothida saroy enttana gakko, shin entti mokkonna ixxiko hintte sarothida saroy hinttew guye simmo. ");
INSERT INTO gofRNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Oonikka hinttena mokkonnanne hintte odiyabaa si7onna ixxiko he keethaafe woykko he katamaappe keyishe hintte tohuwan de7iya baana pittidi keyite. ");
INSERT INTO gofRNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ta hinttew tuma odays; Xoossaa pirdda gallasan he katamaappe Soodomesinne Gamoora katamatas pirdday kawuyana. ");
INSERT INTO gofRNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Ta hinttena dorssatada suudhumeta giddo yeddana. Hessa gisho, shooshada cinccata, holleda aadata gidite. ");
INSERT INTO gofRNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Asay hinttena pirdda daynnatas aathi immana, qassi Ayhude Woosa Keethan hinttena garaafana. Hessa gisho, enttafe naagettite. ");
INSERT INTO gofRNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ta gisho gidi hinttena deriya haareyssata sinthenne kawota sinthe efana. Entta sinthaninne Ayhude gidonna deriya sinthan eqqidi hintte tabaa markkattana. ");
INSERT INTO gofRNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Shin hinttena pirddas aathi immiya wode woygidi zaarino gidi un77ettofite; he saatiyan hintte gaanabaa Xoossay hinttew immana. ");
INSERT INTO gofRNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ays giikko, hinttenan haasayey hintte Aawa Geeshsha Ayyaanaappe attin hinttena gidekketa. ");
INSERT INTO gofRNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Ishay ba ishaa, aaway ba na7aa, hayqos aathi immana, nayti banttana yelidayssata bolla denddidi enttana wodhisana. ");
INSERT INTO gofRNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ta gisho gidi asa ubbay hinttena ixxana, shin wurssethi gakkanaw minniday attana. ");
INSERT INTO gofRNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Issi heerappe hinttena entti gooddiko hara katama baqatite. Taani hinttew tuma odays; Asa Na7ay yaana gakkanaw, hintte Isra7eele katama ubbaa kantheketa. ");
INSERT INTO gofRNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Tamaarey ba asttamaariyappe, aylley ba godaappe aadhdhenna. ");
INSERT INTO gofRNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Tamaarey ba asttamaariya, aylley ba godaa daanikko iyaw gidana. Keethaawa Bi7elzebuula giikko iya soo asaa waanidi iissidi xeegenne? ");
INSERT INTO gofRNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Hiza, asas yayyofite. Kamettidabay qoncconna, qosettidabay geeshshi keyonna attenna. ");
INSERT INTO gofRNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Taani hinttew dhuman odiyabaa hintte poo7on odite; ta hinttew haythan kalkkashidabaa dabaaban awaajjite. ");
INSERT INTO gofRNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ashoppe attin shemppo wodhanaw dandda7onnayssatas yayyofite. Shin shemppuwanne ashuwa gaannamen dhayssanaw dandda7iya Xoossaas yayyite. ");
INSERT INTO gofRNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Nam77u buubbeti issi santimen bayzettokonaayye? Hanoppe attin, enttafe issinnaka hintte Xoossay goonna de7ishin sa7an wodhdhuku. ");
INSERT INTO gofRNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Hari attoshin, hintte huu7e binaanaykka paydettidi de7ees. ");
INSERT INTO gofRNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Hiza, daro buubbetappe hintte aadhdhiya gisho yayyofite. ");
INSERT INTO gofRNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Asa sinthan taw markkattiya ubbaas taanikka saluwan de7iya ta aawa sinthan markkattana. ");
INSERT INTO gofRNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Shin asa sinthan tana kaddeyssa taanikka salon de7iya ta aawa sinthan kaddana. ");
INSERT INTO gofRNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Taani sa7an saro ehanaw yida hinttew daanoppo. Taani toorappe attin sarotethi ehanaw yabiikke. ");
INSERT INTO gofRNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Taani yiday, ‘Na7aa aawappe macca na7iw aayeppe na7aa machchiw azina aayeppe shaakkanaassa. ");
INSERT INTO gofRNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Asas morkketi iya soo asata gidana.’ ");
INSERT INTO gofRNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Taappe aathidi ba aawa woykko ba aayiw dosey, tabaa gidanaw bessenna. Ba adde na7a woykko ba macca na7iw taappe aathidi dosey, tabaa gidanaw bessenna. ");
INSERT INTO gofRNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ba masqaliya tookkidi tana kaallonna oonikka tabaa gidanaw bessenna. ");
INSERT INTO gofRNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ba shemppuwa ashshanaw koyey dhayssana, shin ba shemppuwa ta gisho aathi immey ashshana. ");
INSERT INTO gofRNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Hinttena mokkey tana mokkees, tana mokkey qassi tana kiittidayssa mokkees. ");
INSERT INTO gofRNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Nabiya nabe sunthan mokkey, nabiyatho woytettana; qassi xilluwa xillo sunthan mokkey, xilluwatho woytettana. ");
INSERT INTO gofRNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ta hinttew tuma odays; ha ta tamaaretappe guuxiya issuwas tana kaalliya gisho hari attoshin guutha irxxa haathi immiko iya woytoy dhayenna” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesuusi tammanne nam77u tamaareta kiitaa onggidaappe guye yaappe denddidi tamaarssanawunne sabbakanaw Galiila katamata bis. ");
INSERT INTO gofRNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yohaannisi qasho keethan de7ishe Kiristtoosi oothiyabata si7idi, ba tamaaretappe iyaakko kiittidi, ");
INSERT INTO gofRNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Yaana geetettiday neneyye? Woykko nuuni haraa naaginoo?” yaagidi oychchis. ");
INSERT INTO gofRNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesuusi enttako zaaridi, “Bidi hintte si7iyabaanne hintte be7iyabaa Yohaannisas odite. ");
INSERT INTO gofRNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Qooqeti xeellosona, wobbeti hamuttoosona, baro hargganchchoti paxoosona, tulleti si7oosona, hayqqidayssati hayqoppe denddoosona; manqotas Wonggelay sabbakettees. ");
INSERT INTO gofRNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Tanan dhubettonay anjjettidayssa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Yohaannisa tamaareti guye simmidi bin, Yesuusi deriyas Yohaannisabaa odishe, “Ha bazzuwa ay be7anaw keyidetii? Carkkoy qaathiya maqqaa be7anaw yidetiyye? ");
INSERT INTO gofRNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Yaatin, ay be7anaw keyidetii? Kitte ma7o ma77ida ase be7anaaseyye? Kitte ma7o ma77idayssati kawota keethan de7oosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Yaatin, ay be7anaw keyidetii? Nabe be7anaaseyye? Hekko, hintte nabeppekka aadhdheyssa be7eeta. ");
INSERT INTO gofRNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","“Ne ogiya ne sinthan giigisiya ta kiitanchchuwa neeppe sinthe kiittana” geetettidi xaafettiday iyassa. ");
INSERT INTO gofRNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ta hinttew tuma odays; maccasappe yelettidayssata giddofe Yohaannisappe aadhdhey oonikka baawa; salo kawotethan ubbaafe guuxey I, iyappe aadhdhana. ");
INSERT INTO gofRNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Xammaqiya Yohaannisa wodiyappe doomidi hachchi gakkanaw salo kawotethay daro naaqettees, minnida asati wolqqan yaa gelana. ");
INSERT INTO gofRNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Nabeti ubbaynne Muse higgey Yohaannisa wode gakkanaw salo kawotethaabaa tinbbite odidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Hiza, hintte entta kiitaa ammanana gidikko, yaana geetettida Eliyaasi, I Yohaannisa. ");
INSERT INTO gofRNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Hiza, si7iya haythi de7ey si7o. ");
INSERT INTO gofRNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Hiza, ha wodiya yeletethaa aybira daaniso? Giya giddon uttidi woli xeegidi, ");
INSERT INTO gofRNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Nu hinttew suusul77e punnin; hintte yexxeketa. Nu sabbidi zeleelin; hintte yeekkeketa’ yaagiya nayta daanosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Xammaqiya Yohaannisi moonnanne uyonna yin, ‘Tuna ayyaani de7ees’ yaagideta. ");
INSERT INTO gofRNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Asa Na7ay mishenne uyishe yin, ‘Yarambbanne ushshanchcho, qaraxa qanxiseyssatanne nagaaranchchota dabbo’ yaagideta. Hiza, cinccatethaa tumatethay iya oosuwan qonccees” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Hessafe guye, Yesuusi daro malaatata oothida katamatan de7iya asati bantta nagaraappe simmidi maarotan gelonna ixxida gisho enttana, ");
INSERT INTO gofRNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Ayye Koraaziine katamaw, ayye Beetesayda katamaw, ays giikko, hintte giddon oosettida malaatati Xiroosaninne Sidoonan oosettida gidiyakko, entti beni bido tiyettidi, kalle ma77idi bantta nagaraappe simmi aggana. ");
INSERT INTO gofRNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Shin ta hinttew odays; pirdda gallas hinttefe aathidi Xiroosasinne Sidoonas pirdday kawuyana. ");
INSERT INTO gofRNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Qassi, Qifirnahoome, neeni pude salo keyanaw koyay? Hanenna! Neeni Si7oolen yegettana. Ays giikko, ne giddon oosettida malaatati Soodomen oosettidabaa gidiyakko, Soodomey hachchi gakkanaw de7anashin. ");
INSERT INTO gofRNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Shin ta new odays; pirdda gallas neeppe aathidi Soodomes pirdday kawuyana” yaagidi hanqettis. ");
INSERT INTO gofRNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","He wode Yesuusi, “Aawaw, saluwanne sa7aa Godaw, neeni hayssa eranchchotappenne cinccatappe genthada naytas qonccisida gisho nena galatays. ");
INSERT INTO gofRNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ee, ta Aawaw, hayssi ne lo77o sheniyada hanis. ");
INSERT INTO gofRNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Ubbay taw ta Aawappe imettis. Aawappe hari Na7aa erey baawa, Na7aappenne I enttaw qonccisanaw koyeyssatappe hari Aawa eranaw dandda7ey baawa. ");
INSERT INTO gofRNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Hinttenoo, daaburanchchoto, toohoy deexida ubbay taakko haa yiite; taani hinttena shemppisana. ");
INSERT INTO gofRNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Taani ta wozanan ashkkenne aada gidiya gisho ta qambbaran gelite, taappe tamaarite; hinttee, hintte shemppuwas shemppo demmana. ");
INSERT INTO gofRNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ta qambbaray liiqo, qassi ta toohoykka kawushshe” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Hessafe guye, Sambbaata gallas, Yesuusi gade giddora aadhdhees. Yesuusa tamaareti koshattida gisho tiya bangga shirikidi moosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Shin Farisaaweti hessa be7idi Yesuusakko, “Hekko, ne tamaareti Sambbaata gallas oothanaw bessonnabaa oothoosona” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yesuusi enttako zaaridi, “Dawitey koshattida wode Iyara de7eyssatara ay oothidaakko nabbabibeekketii? ");
INSERT INTO gofRNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Dawitey Xoossaa keethi gelidi kahineta xalaalappe attin inne iyara de7eyssatas bessonna geeshsha daabbuwa mis. ");
INSERT INTO gofRNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Woykko kahineti Sambbaata wogaa shaaridi Xoossa Keethan Sambbaata gallas ooso oothiko enttaw bala gidonnayssa Muse higgiyan nabbabibeekketii? ");
INSERT INTO gofRNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Shin si7ite! Xoossa Keethaafe aadhdhey hayssan de7ees. ");
INSERT INTO gofRNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","‘Taani hintte yarshshuwa gidonnashin hintte harata maarana mela koyays’ giya qaalay woy guusseeko hintte eridaakko xillo asa bolla pirddeketa. ");
INSERT INTO gofRNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Asa Na7ay Sambbaata Godaa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesuusi yaappe bidi Ayhude Woosa Keethi gelis. ");
INSERT INTO gofRNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Yan kushey gunddida issi uray de7ees. Yesuusa mootanaw gaaso koyaa asati, “Sambbaata gallas pathanaw bessi bessennee?” yaagidi oychchidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","I enttako, “Hintte giddofe issuwas dorssi Sambbaata gallas aafon wulliko, goochchidi kessonnay oonee? ");
INSERT INTO gofRNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Yaatin asi dorssafe waanidi daro aadhdhenee? Hessa gisho, Sambbaata gallas lo77obaa oosoy bessees” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Hessafe guye, Yesuusi addiyako, “Ne kushiya piddi ootha” yaagin, uray piddi oothis. Iya kushey paxidi hankko kushiyada hanis. ");
INSERT INTO gofRNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Shin Farisaaweti yaappe kare keyidi, Yesuusa waati wodhaneekko maqettidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yesuusi entta qofaa eridi he bessaa aggidi hara soo bis. Daro asay iya kaallidi bidosona, hargganchchota ubbaa pathis. ");
INSERT INTO gofRNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Yesuusi, “Tabaa hara ooddeskka odoppite” yaagidi minthi odis. ");
INSERT INTO gofRNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Hessika nabiya Isayaasi, ");
INSERT INTO gofRNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Hekko ta doorida aylley, ta doseyssi, tana ufaysseyssi, taani ta ayyaanaa, iya bolla shemppisana; I, Ayhude gidonna deriyas suure pirddabaa awaajjana. ");
INSERT INTO gofRNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","I palamenna woykko kaccenna; ba qaalakka denbban coo sissenna. ");
INSERT INTO gofRNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Suure pirddan xoono demmana gakkanaw, dinccettida maqqaa menthenna, cuyiya muqaadaa toysenna. ");
INSERT INTO gofRNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ayhude gidonna derey ubbay iyan ufayssi wothana” yaagidi xaafidayssi polettana melassa. ");
INSERT INTO gofRNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Hessafe guye, tuna ayyaanan oykettida qooqenne muume ase de7eyssa iyaakko ehidosona. Yesuusi uraa pathin, uray be7isinne odettis. ");
INSERT INTO gofRNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Asa ubbay malaalettidi, “Hayssi Dawite Na7aa gidanddeshshaa?” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Shin Farisaaweti hessa si7idi, “Ha uray tuna ayyaanata kessey tuna ayyaanata halaqaa Bi7elzebuula wolqqaana” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesuusi entta qofaa eridi, “Woli giddon shaakettiya kawotetha ubbay kunddana; qassi woli giddon shaakettiya katamay woykko keethay minnidi eqqenna. ");
INSERT INTO gofRNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Xalahey Xalahe kessiyabaa gidikko ba giddon shaakettis guussu. Hessatho haniyabaa gidikko iya kawotethay waanidi minnidi eqqanaw dandda7ii? ");
INSERT INTO gofRNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Taani tuna ayyaanaa kessey Bi7elzebuula wolqqan gidikko hinttena kaalliya asati oodde wolqqan kessannee? Hessa gisho, hinttena kaalliya asati hinttena pirddana. ");
INSERT INTO gofRNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Shin taani tuna ayyaanata kessey Xoossaa Ayyaanan gidikko, Xoossaa kawotethay hintteko yis. ");
INSERT INTO gofRNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Woykko issi asi wolqqaama asa soo gelidi iya shaluwa bonqanaw koykko koyrottidi he uraa qachchonna ixxiko waattidi dandda7ii? Yaatikko iya shaluwa bonqanaw dandda7ees. ");
INSERT INTO gofRNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Taara gidonnay oonikka taara eqettees; qassi taara issife shiishonna ubbay laallees. ");
INSERT INTO gofRNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Hessa gisho, si7ite; asay oothiya ay nagarinne cashsha qaali ubbay atto geetettana, shin Geeshsha Ayyaana cayaa ooddeskka iya nagaray atto geetettenna. ");
INSERT INTO gofRNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Oonikka Asa Na7a bolla iitabaa odettiko iyaw atto geetettana, shin Geeshsha Ayyaana bolla iitabaa odettiya ooddeskka ha sa7an gidin yaana alamiyan iya nagaray atto geetettenna. ");
INSERT INTO gofRNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Lo77o mithay lo77o ayfe ayfees; qassi iita mithay iita ayfees. Hiza, mithay erettey ba ayfiyaana. ");
INSERT INTO gofRNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Hinttenoo, shoosha nayto, hintte iita gidishe waanidi lo77obaa odettanaw dandda7etii? Asi ba wozanan kumidabaappe doonan odettees. ");
INSERT INTO gofRNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Lo77o asi ba wozanan wothida lo77obaappe, lo77obaa kessees; iita asi ba wozanan wothida iitabaappe, iitabaa kessees. ");
INSERT INTO gofRNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Shin si7ite, asay odettiya coo oda ubbaas pirdda gallas zaaro immana. ");
INSERT INTO gofRNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ays giikko, ne odettiya ne qaalan xillana; ne odettiya ne qaalay ne bolla pirddana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Hessafe guye, issi issi Farisaawetinne higge asttamaareti Yesuusakko, “Asttamaariyaw, neeni malaata oothada nuna bessa” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Shin Yesuusi zaaridi, “Ammanettonnanne iita yeletethay malaata koyees. Shin nabiya Yoonasa malaatappe hara malaati iyaw imettena. ");
INSERT INTO gofRNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yoonasi gita molo ulon heedzu gallasinne heedzu qamma gam77idayssa mela Asa Na7ay heedzu gallasinne heedzu qamma biitta garssan gam77ana. ");
INSERT INTO gofRNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Nanawe asay pirdda gallas denddidi ha yeletethaa bolla pirddana; ays giikko, entti Yoonasa sibkkatiya si7idi bantta nagaraappe simmidosona. Hekko, Yoonasappe aadhdheyssi hayssan de7ees. ");
INSERT INTO gofRNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Pirdda gallas dugeha kawiya denddada ha yeletethaa bolla pirddana; ays giikko, iya Solomone cinccatethaa si7anaw biittaa gaxappe yasu. Hekko, Solomoneppe aadhdhey hayssan de7ees. ");
INSERT INTO gofRNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Tuna ayyaanay asappe keyidaappe guye baw shemppiyaso koyidi haathi baynna mela bessan daaburees, shin ba koyaa shemppuwa demmenna. ");
INSERT INTO gofRNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Yaanin, ‘Ta agga keyida keetha simmada baana’ yaagees. I simmiya wode keethay kaysi gideyssanne pitettidi giigi uttidayssa demmees. ");
INSERT INTO gofRNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Hiza, simmi bidi, baappe iitiya hara laappun iita ayyaanata ekkidi yees; enttika uraa giddo gelidi de7oosona. He uraas kaseyssafe guyeyssi daro iitees. Ha iita yeletethaa bolla hessa mela hanana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesuusi deriyas oda bolla de7ishin iya aayyaanne iya ishati iya odisanaw koyidi karen eqqidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Issi asi iyaakko, “Ne aayyaanne ne ishati nena odisanaw koyidi karen eqqidosona” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yesuusi zaaridi, “Ta aayyaa oonee? Ta ishatikka oonantee?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ba kushiyara tamaareta mallishe, “Be7ite, ta aayanne ta ishati hayssata. ");
INSERT INTO gofRNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Salon de7iya ta Aawa sheniya oothiya ubbay ta isha, ta michchonne ta aayo” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","He gallas Yesuusi sooppe keyidi abbaa gaxan uttis. ");
INSERT INTO gofRNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Daro derey iya yuushuwan shiiqin asaa abbaa gaxan aggaagidi wogolon gelidi uttis. ");
INSERT INTO gofRNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Asaas darobaa leemison yaagidi odis: “Issi goshshanchchoy zerethi zeranaw keyis. ");
INSERT INTO gofRNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","I zeriya wode issi issi zerethati oge gaxan wodhdhidosona; enttaka kafoti yidi maxi midosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Issi issi zerethati garssan shaalloy de7iya biitta bolla wodhdhidosona. Daro biitti baynna gisho ellesidi dolis. ");
INSERT INTO gofRNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Shin away keyin shullis; xaphoy baynna gisho melis. ");
INSERT INTO gofRNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Issi issi zerethay aguntha giddon wodhdhis; agunthay diccidi he dolaa cuullis. ");
INSERT INTO gofRNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Harati qassi aradda biitta bolla wodhdhis; dolidi ayfe ayfis. Issoy xeeta, issoy usuppun tamma, issoy qassi hasttama ayfis. ");
INSERT INTO gofRNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Si7iya haythi de7iya uray si7o” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Yesuusa tamaareti iyaakko shiiqidi, “Ays neeni deriyas leemison oday?” yaagidi oychchidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","I zaaridi, “Hinttew salo kawotethaa xuuraa eray imettis, shin enttaw imettibeenna. ");
INSERT INTO gofRNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","De7iya ubbaas guzhettana, iyaw darana, shin baynnayssafe hari attoshin iyaw de7iyarakka ekettana. ");
INSERT INTO gofRNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Hessa gisho, taani entti, xeellishe demmonna mela, si7ishe si7onna mela woykko akeekonna mela enttaw leemison odays. ");
INSERT INTO gofRNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","“Isayaasi ba maxaafan odidayssi entta bolla polettis. I odishe, ‘Hintte sissaa si7eeta, shin akeekekketa; hintte xeelleta, shin be7ekketa. ");
INSERT INTO gofRNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ays giikko, ha asaa wozanay zel77umis; bantta haythaa erishe tullisidosona, bantta ayfiyaa goozidosona. Hessi baynneeko entti bantta ayfiyaan be7idi, bantta haythan si7idi, bantta wozanan akeekidi, taakko simmana, takka entta pathanashin’ yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Shin hintte ayfeti be7iya gishonne hintte haythati si7iya gisho hintte anjjettidayssata. ");
INSERT INTO gofRNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ta hinttew tuma odays; daro nabetinne xillo asati hintte be7eyssa be7anawunne hintte si7eyssa si7anaw amottidosona, shin enttaw hanibeenna. ");
INSERT INTO gofRNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Hiza, ha zerethaa zeriya uraa leemisuwa si7ite. ");
INSERT INTO gofRNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Oge gaxan wodhdhida zerethaa leemisoy hayssa: salo kawotethaa qaala si7idi akeekonna uraa wozanappe Xalahey yidi iya wozanan de7iya zerethaa maxi digees. ");
INSERT INTO gofRNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Shaalloy garssan de7iya biitta bolla zerettidayssi qaala si7idi ellesidi ufaysan ekkeyssata. ");
INSERT INTO gofRNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Shin xapho yeddanaw dandda7onna gisho daro gam77okona. Qaala gaason metoy woykko goodetethi yaa wode ellesi dhubettoosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Aguntha gaathan zerettidayssi qaala si7is, shin ha alamiya duussaa hirggaynne duretetha qofay qaala cuulliya gisho ayfe ayfonna attees. ");
INSERT INTO gofRNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Shin aradda biittan zerettida zerethay akeekan qaala si7iya uraa. I ayfe ayfees; issoy xeeta, issoy usuppun tamma issoy qassi hasttama ayfees” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesuusi enttaw hara leemiso odis, “Xoossaa kawotethay ba goshshan lo77o zerethi zerida uraa daanees. ");
INSERT INTO gofRNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Shin asi ubbay dhiskkin iya morkkey yidi gisttiya giddon leeshsho zeridi bis. ");
INSERT INTO gofRNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Gisttey diccidi ayfiyaa wode leeshshoy iya giddon benttis. ");
INSERT INTO gofRNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Gadiya godaa aylleti godaakko bidi, ‘Godaw, ne goshshan ne lo77o zerethi zerabikkishsho? Yaatin, leeshshoy awuppe yidee?’ yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“I enttako, ‘Hessa morkkey oothis’ yaagis. “Aylleti godaakko, ‘Nu bidi leeshshuwa shoddana mela koyay?’ yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Shin I, ‘Atto bochchofite; hintte leeshshuwa shoddays gishin gisttey shodettana. ");
INSERT INTO gofRNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Bochchofite; caka wodey gakkanaw issife dicco. He wode cakkiya asata leeshshuwa sinthattidi maxidi taman xuugganaw mirqen mirqen qachchite. Shin gisttiya shiishidi ta shaaliyan qolite’ yaagana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Qassi hara leemiso yaagidi odis; “Salo kawotethay issi asi ba goshshan bakkida guutha mithee ayfe daanees. ");
INSERT INTO gofRNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","He mithee ayfey hara mitha ayfetappe guutha, shin iya dolaa diccida hara mithata ubbaafe aadhdha gitatawusu. I tashiyan kafoti keexidi uttana gakkanaw wolqqaama mithi gidawusu” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Kaallidikka, Yesuusi hara leemiso odis; “Salo kawotethay issi maccasi heedzu gabate dhiille ekka munuqada, munuqay denddana mela iyan gujjida irshsho daanees” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesuusi deriyas he leemisuwa ubbaa odis. Leemisoy baynna issibaakka odibeenna. ");
INSERT INTO gofRNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Nabey ba maxaafan, “Taani ta doona, leemison dooyana; saloynne sa7ay medhettosappe, geemmidayssa odays” yaagidi odidayssi hessan polettis. ");
INSERT INTO gofRNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yesuusi deriya moyzidi soo gelis. Iya tamaareti iyaakko shiiqidi, “Goshshan de7iya leeshshuwa birshshethaa nuus oda” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","I zaaridi, “Lo77o zerethaa zeriday Asa Na7a. ");
INSERT INTO gofRNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Goshshay ha alamiya. Lo77o zerethay salo kawotethaa nayta. Leeshshoy Xalahe nayta. ");
INSERT INTO gofRNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Leeshshuwa zeriday morkkiya Xalahe. Caka wodey, wodiya wurssethaa. Cakkeyssati kiitanchchota. ");
INSERT INTO gofRNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Leeshshoy maxettidi taman xuugetteyssa mela wodiya wurssethan hessada hanana. ");
INSERT INTO gofRNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Asa Na7ay ba kiitanchchota kiittana. Entti nagaras gaaso gideyssatanne iita oothiya ubbaa maxidi iya kawotethaafe kessana. ");
INSERT INTO gofRNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Maxi shiishidi yeehoynne achcha garccethi de7iya to7onna taman yeggana. ");
INSERT INTO gofRNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","He wode xilloti bantta Aawa kawotethan awada poo7ana. Si7iya haythi de7ey si7o! ");
INSERT INTO gofRNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Xoossaa kawotethay goshshan moogettida miishe daanees. Issi asi he miishiya demmidi zaari moogis. Daro ufayttidi bidi baw de7iyaba ubbaa bayzidi he goshsha gadiya shammis. ");
INSERT INTO gofRNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Hessadakka, qassi salo kawotethay inqo giya al77o shuchchata koyaa zal77anchcho daanees. ");
INSERT INTO gofRNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Daro al77o inquwa demmidi bidi baw de7iyaba ubbaa bayzidi iya shammis. ");
INSERT INTO gofRNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Qassi Xoossaa kawotethay abban yegettida dumma dumma qommo molo oykkiya gitiya daanees. ");
INSERT INTO gofRNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Molo oykkiya asati moloy gitiyan kumin abbaafe gaxa kessidosona. Yan uttidi lo77uwa qori qori daachchon yeggidosona, shin iita molota wora holidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Wodiya wurssethan hessatho hanana. Kiitanchchoti yidi nagaranchchota xillotappe shaakkidi, ");
INSERT INTO gofRNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","yeehoynne achcha garccethi de7iya to7onna taman yeggana. ");
INSERT INTO gofRNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","“Ha ubbay hinttew gelidee?” yaagidi entta oychchis. Entti zaaridi, “Ee” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Yesuusi, “Hiza, salo kawotethaa eraa ekkidi higgiya tamaarssiya ubbay, ba minjjida shaluwappe oorathaanne gal77a kessiya ase daanees” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesuusi ha leemisuwa odi wurssidaappe guye yaappe denddidi bis. ");
INSERT INTO gofRNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ba yelettida biittaa bidi Ayhude Woosa Keethan deriya tamaarssis. Entti malaalettidi, “Ha uray ha cinccatethaanne ha malaatata oothiya wolqqaa awuppe ekkidee? ");
INSERT INTO gofRNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Hayssi anaaxiya na7aa gidenneyye? Iya aaye sunthay Mayraamo gidennee? Iya ishati Yayqooba, Yoosefa, Simoonanne Yihuda gidokkonaayye? ");
INSERT INTO gofRNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Iya michcheti nuura de7oosona gidokkonaa? Yaatin, ha uray ha ubbaa awuppe ekkidee?” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Hessa gisho, I giyabaa ekkonna ixxidosona. Shin Yesuusi, “Nabey ba yelettida biittaninne ba soo asaa matan bonchchettenna” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Entti ammanonna ixxida gisho daro malaatata he bessan oothibeenna. ");
INSERT INTO gofRNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","He wode Galiila aysiya Heroodisi Yesuusabaa si7is. ");
INSERT INTO gofRNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ba aylletakko, “Hayssi Xammaqiya Yohaannisa; I hayqoppe denddis. Yaanida gisho ha ubbaa malaatata I oothees” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","I hessa giday Heroodisi ba ishaa Filphoosa machche Heroodiyadi gaason Yohaannisa qasho keethi gelssida gishossa. ");
INSERT INTO gofRNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Yohaannisi Heroodisa, “Ne iyo ekkanaw woga gidenna” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Heroodisi Yohaannisa wodhanaw koyis, shin derey Yohaannisa nabe oothidi be7iya gisho yashettis. ");
INSERT INTO gofRNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Heroodisi ba yelettida gallasa bonchchiya wode Heroodiyada na7iya asaa sinthan yethan durada iya ufayssasu. ");
INSERT INTO gofRNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Yaatin, I, “Iya koyaba ubbaa immana gidi” caaqqis. ");
INSERT INTO gofRNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Na7iya ba aaye zoriya si7ada Heroodisakko, “Xammaqiya Yohaannisa huu7iya keren wothada taw imma” yaagasu. ");
INSERT INTO gofRNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Iya yaagin kawoy qiirottis, shin ba caaquwa gishonne baara de7iya imathata gisho gidi I oyshay polettana mela kiittis. ");
INSERT INTO gofRNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Kawoy ase kiittidi Yohaannisi qasho keethan de7ishin iya qoodhiya goyrisis. ");
INSERT INTO gofRNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Huu7iya keren wothi ehidi na7ees immidosona; na7iyakka ekkada ba aayes efasu. ");
INSERT INTO gofRNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Yohaannisa tamaareti yidi iya ahaa efidi moogidosona. Iyappe guye hanidabaa ubbaa bidi Yesuusas odidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesuusi hanidabaa si7ida wode wogoluwan gelidi he bessaafe issi geemmiya soo barkka bis. Asay hessa si7idi katamatappe denddidi tohon iya kaallidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesuusi wogoluwappe wodhdhidi daro asaa be7idi enttaw qadhettis. Entta giddon de7iya hargganchchota pathis. ");
INSERT INTO gofRNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Sa7ay omarssishe biya wode Yesuusa tamaareti iyaakko shiiqidi, “Ha bessay asi baynna bessi, sa7aykka qammis. Yaaniya gisho, heeran de7iya gutata bidi banttaw shammidi maana mela deriya yedda” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Shin Yesuusi enttako, “Derey moonna baanaw koshshenna; entti maanabaa hintte immite” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Entti zaaridi, “Nuus hayssan ichchashu uythaafenne nam77u moloppe hari baawa” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ikka, “Ane entta haa ehite” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Kaallidikka, derey maatan uttana mela odis. Ichchashu uythaanne nam77u molota ekkidi, salo xeellidi galati simmidi, uythaa menthidi ba tamaaretas immis; entti qassi deriyas immidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ubbay midi kallidosona. Yesuusa tamaareti mishin attidayssa tammanne nam77u gayta denthidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Kathaa mida asay maccasaynne nayti attin ichchashu mukulu gidees. ");
INSERT INTO gofRNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Yesuusi ba tamaareti wogoluwan gelidi baappe sinthattidi abbaafe he finthi pinnana mela kiittidi baw deriya moyzanaw guye attis. ");
INSERT INTO gofRNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Deriya moyzi simmidi barkka woossanaw issi deriya bolla keyis. Sa7ay qamminkka I barkka yan gam77is. ");
INSERT INTO gofRNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","He wode wogoloy abbaa bolla bishin sintha baggara carkkoy denddin hobbey wogoluwa un77ethis. ");
INSERT INTO gofRNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Wontimaatha bolla Yesuusi abbaa bolla hamuttishe ba tamaaretakko yis. ");
INSERT INTO gofRNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Iya tamaareti, I abbaa bolla hamuttishe banttako yeyssa be7idi yayyidosona. Enttika, “Hayssi moytille” gidi yayyidi waassidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Shin Yesuusi ellessidi, “Aykkoy baawa! Yayyofite! Tanabay” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Phexiroosi iyaakko, “Godaw, nena gidikko, taani haatha bollara hamuttada neekko baana mela tana kiitta” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yesuusi Phexiroosakko, “Haaya” yaagis. Phexiroosi wogoluwappe wodhdhidi haatha bollara hamuttishe Yesuusakko buussu oykkis. ");
INSERT INTO gofRNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Shin wolqqaama carkkuwa be7idi yayyis. Haathan mitetethi oykkida wode “Godaw, tana ashsharkkii” yaagidi waassis. ");
INSERT INTO gofRNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Yesuusi ellesidi ba kushiya yeddi iya oykkidi, “Neno, ammanoy paccidaysso ays sidhay” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Yesuusaranne Phexiroosara wogoluwan gelida wode carkkoy si77i gis. ");
INSERT INTO gofRNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Wogoluwa giddon de7iya iya tamaareti, “Neeni tumakka Xoossaa Na7a” gidi goynnidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Entti abbaa pinnidi Gensareexe biittaa gakkidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","He biittan de7iya asay Yesuusa erida wode bantta heeran de7iya guta ubbaa kiita yedidosona. Asay hargganchchota ubbaa iyaakko ehidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Hargganchchoti iya afila macaraa xalaala bochchana mela woossidosona. Bochchida ubbayka paxidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Hessafe guye, issi issi Farisaawetinne higge asttamaareti Yerusalaameppe Yesuusakko yidi, ");
INSERT INTO gofRNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Ne tamaareti ays nu aawata wogaa menthonaa? Entti kathi maanappe sinthe bantta kushiya meecettokona” yaagidi oychchidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesuusi zaaridi, “Hinttee, hintte wogaa gisho Xoossaa kiitaa poleyssa ays ixxeeti? ");
INSERT INTO gofRNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ays giikko, Xoossay, ‘Ne aawanne ne aayiw bonchcha. I ba aawa woykko ba aayiw cayeyssi hayqo gibeennee?’ yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Shin hintte, issi asi ba aawa woykko ba aayiw maaddanabay de7ishin, ‘Hayssa ta Xoossas yarshshas giikko, ");
INSERT INTO gofRNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ba aawa woykko ba aayiw bonchchanaw bessenna’ yaageeta. Yaatidi hinttee, hintte wogaa polanaw Xoossaa qaala mentheeta. ");
INSERT INTO gofRNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Hinttenoo, cubboto, Isayaasi hinttebaa likke odis, ");
INSERT INTO gofRNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“ ‘Ha asay tana bantta doonan bonchchees, shin entta wozanay taappe haahon de7ees. ");
INSERT INTO gofRNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Asay tana coo goynnosona; entti asi medhdhida kiitaa Xoossaa higge daanisidi tamaarssoosona’ gis” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yesuusi daro asaa baakko xeegidi, “Si7ite! Akeekite! ");
INSERT INTO gofRNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ase tunisiyabay doonara geliyaba gidonnashin doonappe keyaabaa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Hessafe guye, Yesuusa tamaareti iyaakko yidi, “Farisaaweti neeni gidayssa si7idi dhubettidayssa akeekay?” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Shin Yesuusi enttaw zaaridi, “Saluwan de7iya ta aaway tokkiboonna mithay ubbay shodettana. ");
INSERT INTO gofRNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Enttabaa hirggofite; entti qooqe kaalethiya qooqeta. Qooqey qooqe kaalethiko, nam77ayka ollan kunddana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Phexiroosi zaaridi, “Ha leemisuwa birshshethaa nuus odarkkii” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesuusi enttako, “Hinttewuka ha77i gakkanaw gelibeennee? ");
INSERT INTO gofRNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Doonara geliyabaa ubbay ulo gelidi kare keyeyssa erekketii? ");
INSERT INTO gofRNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Shin doonara keyaabay wozanappe keyees. Ase tunisiyabati hessata. ");
INSERT INTO gofRNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Enttika asa wozana giddofe keyaa iita qofa, wodho, laymatethi, iita ooso, kayso, worddo markkatethi, cashshe. ");
INSERT INTO gofRNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Hessa daaniyabati ase tuniseesippe attin meecettonna kushera meyssi tunisenna” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Hessafe guye, Yesuusi yaappe keyidi Xiroosanne Sidoona katamati de7iya biittaa bis. ");
INSERT INTO gofRNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Issi Kanaane biitta maccas Yesuusakko yada, ba qaalaa dhoqqu oothada, “Godaw, Dawite na7aw, taw qadhettarkii; ta na7iw tuna ayyaanay oykkidi iita waayses” yaagasu. ");
INSERT INTO gofRNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Shin Yesuusi issi qaalakka zaaronna si77i gis. Yesuusa tamaareti iyaakko yidi, “Ha maccasiya nu geedo kaalla kaallada, woossawusu. Hessa gisho, neeni iyo moyzarkkii” yaagidi woossidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yesuusi zaaridi, “Taani wudeppe dhayida dorssada Isra7eele keethaafe dhayida asata xalaalas kiitettas” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Shin iya, iya sinthan kunddada, “Godaw, tana maaddarkii?” yaagasu. ");
INSERT INTO gofRNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","I zaaridi, “Nayta kathi ekkidi kanatas yeggeyssi lo77o gidenna” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Maccasiyakka, “Godaw, hessi tuma, shin hari attoshin kanati bantta godati mishin, gaytappe wodhdhiya tiifiya moosona” yaagasu. ");
INSERT INTO gofRNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yesuusi zaaridi, “Ha maccasete, ne ammanoy gita; ne koyidayssada new hano” yaagis. I na7iya iirakka paxa aggasu. ");
INSERT INTO gofRNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesuusi yaappe denddidi Galiila Abbaa mati bis. Issi dere bolla keyidi, yan uttis. ");
INSERT INTO gofRNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Daro asay banttara, wobbeta, qooqeta, kuunata, doona muumetanne, hara daro hargganchchota ekkidi, iyaakko ehidi iya sinthan wothidosona. Yesuusi enttana pathis. ");
INSERT INTO gofRNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Hessa gisho, muumeti odettishin, kuunati piddi gishin, wobbeti hamuttishin, qooqeti xeellishin asay be7idi malaalettidi, Isra7eele Xoossaa galatidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesuusi ba tamaareta baakko xeegidi, “Ha daro asay taara heedzu gallas gam77ida gishonne enttaw ha77i miyabay baynna gisho taani enttaw qadhettays. Entti ogen daaburidi kunddonna mela aykko muzonna entta mela yeddanaw koyikke” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Iya tamaareti zaaridi, “Nuuni ha bazzuwan hayssa keena asaas gidiya kathi awuppe demmanee?” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesuusi enttako, “Hinttew aappun uythi de7ii?” yaagidi oychchis. Entti zaaridi, “Laappun uythinne laafa molotappe guuthi de7ees” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Yesuusi deriya sa7an uttite yaagidi kiittis. ");
INSERT INTO gofRNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Hessafe guye, he laappun uythaanne moluwa ekkidi Xoossaa galatis. Menthidi ba tamaaretas immis. Iya tamaareti asaas gishidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Asay ubbay midi kallidosona. Iya tamaareti, mishin attida tiifiya laappun gita gayta kumethi denthidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Mida asay maccasinne na7a paydonna adde xalaali oyddu mukulu. ");
INSERT INTO gofRNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yesuusi deriya yeddidaappe guye wogoluwan gelidi Magedoona giya biittaa bis. ");
INSERT INTO gofRNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Farisaawetinne Saduqaaweti Yesuusakko yidosona. Iya paaccanaw koyidi, banttana saloppe malaata besso gidi oychchidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Shin I enttako, “Sa7i omarssiya wode ‘Saloy zo77ida gisho wontto booqallana’ yaageta. ");
INSERT INTO gofRNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Wonttiya wode, ‘Saloy zo77idi shaaratida gisho iray bukkana’ yaageta. Yaatin hintte salo mallaa be7idi ereeta, shin wodiya malla eranaw dandda7ibeekketa. ");
INSERT INTO gofRNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Iitanne ammanonna yeletethay malaata koyees. Shin iyaw Yoonasa malaatappe hara malaati imettenna” yaagis. Hessafe guye, enttana yan aggidi hara soo bis. ");
INSERT INTO gofRNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Entti abbaafe hefinthi pinnida wode daabbo ekkidi yaanayssa dogidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesuusi enttako, “Farisaawetappenne Saduqaaweta irshshuwaafe naagettite” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Enttika bantta garssan, “I hessa giday nu daabbo ekkidi yoonna gishossa gidana” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yesuus entta qofaa eridi, “Hinttenoo, ammanoy paccidayssato! Daabbo ekkonna yida gisho woli gidon ays odetteetii? ");
INSERT INTO gofRNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ha77ika hintte akeeketii? Ichchashu mukulu asaas ichchashu uythaa gishidayssanne entti midi kallin hintte aappun gayta kumethi denthidaakko dogidetii? ");
INSERT INTO gofRNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Hessadakka, laappun uythaa oyddu mukulu asaas gishidayssanne entti midi kallin, hintte aappun gita gayta kumethi denthidaakko akeekekketii? ");
INSERT INTO gofRNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Hiza, taani Farisaawetanne Saduqaaweta irshshuwaafe naagettite gada odeyssi daabbobaa gidonnayssa akeekekketii?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Yaatin, iya tamaareti Yesuusi odey munuqa denthanaw yegettiya irshshobaa gidonnashin Farisaawetanne Saduqaaweta timirttiyafe naagettanayssa gideyssa akeekidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesuusi Qisaariya Filphoosa biittaa gakkida wode ba tamaaretakko, “Asay, Asa Na7aa oona goonaa?” yaagidi oychchis. ");
INSERT INTO gofRNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Enttika, “Issoti issoti Xammaqiya Yohaannisa, harati Eliyaasa qassi hankkoti Ermmiyasa woykko nabetappe issuwa goosona” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yesuusi zaaridi, “Yaatin, hintte tana oona geeti” gidi entta oychchis. ");
INSERT INTO gofRNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simoona Phexiroosi zaaridi, “Neeni Kiristtoosa, de7o Xoossaa na7a” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yesuusi Phexiroosakko, “Yoona na7aa Simoona, neeni anjjettidayssa! Hayssa new qonccisiday saluwan de7iya ta aawappe attin ase gidenna. ");
INSERT INTO gofRNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ta new odays Phexiroosa, neeni zaalla! Taani ha zaalla bolla ta woosa keethaa keexana. Hayqo wolqqatikka iyo xoonokkona. ");
INSERT INTO gofRNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Salo kawotethaa qulppeta ta new immana. Sa7an neeni diggiyabay ubbay salon Xoossaa matan digettidabaa gidana. Sa7an neeni hano giyabay ubbay salon Xoossaa matan hanidabaa gidana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Hessafe guye, I, Kiristtoosa gideyssa ooddeskka odonna mela ba tamaareta minthidi kiittis. ");
INSERT INTO gofRNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","He wodiyappe doomidi Yesuusi ba tamaaretas, “Taani Yerusalaame baanaw bessees. Yan deriya cimatan, kahine halaqatanne higge asttamaareta kushen waaye ekkanaw bessees. Entti tana wodhana, shin taani heedzantho gallas hayqoppe denddana” yaagidi qonccisis. ");
INSERT INTO gofRNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Phexiroosi Yesuusa gaxa kessidi, “Godaw, hessi hanenna! Hessa melabay nena ubbarakka gakkofo!” yaagidi hanqettis. ");
INSERT INTO gofRNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yesuusi Phexiroosakko guye simmidi, “Ha Xalahiyaw, taappe haakka! Neeni asa qofa qoppasappe attin Xoossaa qofa qopponna gisho taw dhube gidaasa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Hessafe guye, Yesuusi ba tamaaretakko, “Oonikka tana kaallanaw koyabaa gidikko bana kaddo, ba masqaliya tookkidi tana kaallo. ");
INSERT INTO gofRNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ba de7uwa ashshanaw koyaa ubbay dhayssees. Shin ba de7uwa ta gisho gidi aathi immeyssi ashshees. ");
INSERT INTO gofRNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Asi alame kumethaa babaa oothidi, gidoshin ba shemppuwa dhayssikko iya ay maaddii? Woykko asi ba shemppuwa laame ay immanaw dandda7ii? ");
INSERT INTO gofRNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Asa na7ay ba aawa bonchchuwan ba kiitanchchotara yaana. He wode issi issi uraas iya oosuwada immana. ");
INSERT INTO gofRNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ta tuma odays; asa Na7ay kawo gididi simmeyssa be7ana gakkanaw hayssan eqqida asaappe hayqqonnayssati de7oosona” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Usuppun gallasappe guye Yesuusi, Phexiroosa, Yayqoobanne iya ishaa Yohaannisa baara ekkidi banttarkka gidanaw deriya bolla keyis. ");
INSERT INTO gofRNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Yan entta sinthan Yesuusa malay kumethi laamettis; iya som77oyka awada xolqqis. Iya ma7oykka daro booxis. ");
INSERT INTO gofRNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Hekko, Museynne Eliyaasi iyara odettishin be7idosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Phexiroosi Yesuusakko, “Nuuni hayssa hashshu yida. Ne koykko issino new, issino Muses, issino Eliyaasas hayssan heedzu shaqara shaqarana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Phexiroosi hessa buroo odishin bootha shaaray enttana kammis. Shaara giddora, “Tana ufayssiya, ta dosiya na7ay hayssa, iya si7ite!” yaagiya qaalay yis. ");
INSERT INTO gofRNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Yesuusa tamaareti hessa si7ida wode dagammidi bantta som77uwara sa7an kunddidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Shin Yesuusi enttako shiiqidi entta bochchidi, “Denddite, yayyofite!” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Entti dhoqqu gidi be7iya wode Yesuusappe hara oonakka be7ibookkona. ");
INSERT INTO gofRNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Entti deriyappe wodhdhishin Yesuusi enttako, “Asa Na7ay hayqoppe denddana gakkanaw ha hintte be7idabaa ooddeskka odoppite” gidi kiittis. ");
INSERT INTO gofRNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Yesuusa tamaareti, “Yaatin, higge asttamaareti Eliyaasi Kiristtoosappe kasetidi yaana giday aybisse?” yaagidi oychchidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesuusi zaaridi, “Ee! Eliyaasi kaseti yidi ubbabaa giigisana. ");
INSERT INTO gofRNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Shin ta hinttew tuma odays; Eliyaasi kasetidi yis. Enttika iya bolla koyidabaa oothidosonappe attin iya shaakki eribookkona. Hessada Asa Na7ay entta kushen waayettana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","He wode Yesuusi giday Xammaqiya Yohaannisabaa gideyssa akeekidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Entti deriyappe asaakko simmiya wode issi asi Yesuusa sinthan gulbbatidi, ");
INSERT INTO gofRNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Godaw, hayyana ta na7as qadhettarkii; iya shocidi yeggiya harggey daro un77ethidi tamaninne haathan yeggees. ");
INSERT INTO gofRNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ne tamaaretakko ehas, shin entti pathanaw dandda7ibookkona” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesuusi zaaridi, “Hinttenoo, ammanonna geella yeletethaw awude gakkanaw ta hinttera daane? Awude gakkanaw ta hinttena dandda7anee? Ane na7aa haa ekki yiite” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yesuusi tuna ayyaanaa hanqqin, tuna ayyaanay na7aappe keyis; he saatenkka na7ay paxis. ");
INSERT INTO gofRNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Hessafe guye, Yesuusa tamaareti banttarkka iyaakko shiiqidi, “Nuuni tuna ayyaanaa kessanaw dandda7iboonnay aybisse?” yaagidi oychchidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","I enttako, “Hinttew ammanoy laafida gishossa. Ta hinttew tuma odays; gaashe ayfe mela ammanoy hinttew de7ikko ‘Ha deriya hayssafe denddada gede aadhdha’ giikko hinttew kiitettana. Hinttew dandda7ettonabay deenna. ");
INSERT INTO gofRNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Shin hessa melay woosappenne xoomappe attin haran keyenna” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Yesuusa tamaareti Galiilan shiiqidi de7ishin Yesuusi enttako, “Asa Na7ay asa kushen aadhdhidi imettana. ");
INSERT INTO gofRNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Entti iya wodhana, shin I heedzantho gallas hayqoppe denddana” yaagis. Iya tamaaretikka daro qiirottidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yesuusaranne iya tamaaretara Qifirnahoome katama gakkida wode Xoossa Keetha giira qanxiseyssati Phexiroosakko yidi, “Hintte asttamaarey Xoossa Keetha giira giirii?” yaagidi oychchidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Phexiroosi zaaridi, “Giirees” yaagis. Phexiroosi soo geliya wode Yesuusi kasetidi, “Phexiroosa, new ay daanii? Ha sa7aa kawotethati qaraxanne giira ooppe ekkonaa? Gade asappeyye woykko asa gade asappe?” yaagidi oychchis. ");
INSERT INTO gofRNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Phexiroosi “Asa gade asappe” gidi zaaris. Yesuusi zaaridi, “Gade asay giira giirokkona guussu. ");
INSERT INTO gofRNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Shin entti dhubettonna mela abbaa bada moluwa oykkiya manxxaqo yegga. Koyro ne oykkiya moluwa doona dooyada giiras gidiya miishiya ne gishonne ta gisho efada giira” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","He wode Yesuusa tamaareti yidi, “Salo kawotethan ubbaafe aadhdhey oonee?” yaagidi oychchidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yesuusi issi guutha na7a xeegidi entta giddon essidi hayssada yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","“Taani hinttew tuma odays; hintte laamettonanne guutha naytada hanonna ixxiko salo kawotethaa ubbarakka gelanaw dandda7ekketa. ");
INSERT INTO gofRNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Hiza, ha guutha na7aada bana kawushshiya oonikka salo kawotethan ubbaafe aadhdheyssa gidana. ");
INSERT INTO gofRNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Hayssa mela na7a ta sunthan mokkiya oonikka tana mokkees. ");
INSERT INTO gofRNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Shin tanan ammaniyaa ha guuthatappe issuwa naagara oothana mela dhube gidiya oonikka gita gaachcha woxa ba qodhen qachchidi ciimmo abban mitettiko iyaw lo77o. ");
INSERT INTO gofRNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Alamen asay nagara oothana mela oothiyabati de7iya gisho alamiya ayye. Hessa melabati yoonna attenna, shin dhubey iya gaason yaa uraa ayye. ");
INSERT INTO gofRNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Ne kushey woykko ne tohoy nena balethikko neeppe qanxa yegga. Neeni nam77u kushera woykko nam77u tohora merinaa taman yeggettanayssafe kushe woykko toho duuxa gidada merinaa de7o demmeyssi new lo77o. ");
INSERT INTO gofRNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Qassi ne ayfey nena balethikko iyo wooca kessada wora hola. Neeni nam77u ayfera gaanname taman yeggetteyssafe issi ayfera merinaa de7uwa geleyssi new lo77o. ");
INSERT INTO gofRNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Ta hinttew odays; salon de7iya entta naagiya kiitanchchoti ubba wode salon de7iya ta Aawa sinthan de7iya gisho hintte ha guuthatappe issuwaka kadhonna mela naagettite. ");
INSERT INTO gofRNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Asa Na7ay dhaydayssata ashshanaw yis” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Qassi Yesuusi, “Hinttew ay daanii? Issi uraas xeetu dorssati de7eyssatappe issoy dhayikko uddufun tammanne uddufunata deriya bolla yeggi aggidi he dhayidayssa koyanaw beenne? ");
INSERT INTO gofRNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ta tuma odays; I demmida wode uddufun tammanne uddufunatappe aathidi dhayidi benttida issi dorssan ufayttees. ");
INSERT INTO gofRNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Hessadakka, salon de7iya hintte aaway ha guuthatappe issoy dhayana mela koyenna. ");
INSERT INTO gofRNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Ne ishay nena qohikko nerkka iyaakko bada iya balaa iyaw oda. I nena si7ikko ne ishaa new isha ootha. ");
INSERT INTO gofRNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Shin I nena si7onna ixxiko, nam77u woykko heedzu asa markkan mootoy lasettiya gisho issi woykko nam77u asi ekkada iyaakko ba. ");
INSERT INTO gofRNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","I enttana si7onna ixxiko, woosa keethas oda. Woosa keethi giyabaa si7onna ixxiko ammanonna asada woykko qaraxa qanxisiya asada iya payda. ");
INSERT INTO gofRNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Ta hinttew tuma odays; sa7an hintte diggiyabati ubbay salon Xoossaa matan digettidaba gidana. Sa7an hintte hano giyabati ubbay salon Xoossaa matan hanidabaa gidana. ");
INSERT INTO gofRNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Qassika ta hinttew odays; sa7an hinttefe nam77ay bantta woossiyabas issi wozanan gididi Xoossaa woossiyabaa gidikko salon de7iya ta Aaway hinttew oothana. ");
INSERT INTO gofRNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Tana kaalleyssatappe nam77a woykko heedza gididi shiiqiya bessan taani entta giddon benttana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","He wode Phexiroosi Yesuusakko yidi, “Godaw, ta ishay tana qohikko aappun toho taani atto gaanaw bessii? Laappun toho gakkanaaseyye?” gidi oychchis. ");
INSERT INTO gofRNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesuusi zaaridi, “Gidenna, laappun tammu toho laappunappe attin laappun toho gidenna. ");
INSERT INTO gofRNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Hessa gisho, Xoossaa kawotethay ba oosanchchotara ba miishey paccidaakkonne palahidaakko be7anaw qoppida kawuwa daanees. ");
INSERT INTO gofRNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","He kawoy miishey paccidaakkonne palahidaakko be7iya wode daro ginddigindda acoy de7iya issi uraa iyaakko ehidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Shin he aylley acuwa qanxanaw xoonettin iyara, iya machcheera, iya naytinne iyaw de7iyabay ubbay bayzettidi acoy cigettana mela iya goday kiittis. ");
INSERT INTO gofRNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Yaatin aylley ba godaa tohuwa bolla gulbbatidi, ‘Ta godaw, hayyana guutha wode takkarkki, ta acuwa ubbaa ta ciggana’ yaagidi woossis. ");
INSERT INTO gofRNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Kawoy iyaw qadhettidi, yeddi aggis; iya acuwa maaris. ");
INSERT INTO gofRNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Shin he aylley keyi bidi ba lagge oosanchchotappe issoy baappe daro guutha miishe tal77idayssa, ‘Ne bolla de7iya ta miishiya taw cigga’ gidi qoodhe oykkis. ");
INSERT INTO gofRNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“He iya lagge aylley iya sinthan gulbbatidi, ‘Hayyana guutha wode takkarkki taani ta acuwa ubbaa ciggana’ yaagidi woossis. ");
INSERT INTO gofRNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Shin ixxidi ekki efidi ba laggey acuwa qanxana gakkanaw qasho keethi gelssis. ");
INSERT INTO gofRNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Hessa gisho, hara lagge oosanchchoti hessa be7ida wode daro yilotidi, bidi bantta godaas I oothidabaa ubbaa odidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Yaatin kawoy he aylliya xeegisidi, ‘Ha iita aylliyaw, neeni tana woossida gisho ta ne acuwa ubbaa new maaras. ");
INSERT INTO gofRNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Yaatin, taani ne acuwa maaridayssada neeni ne lagge aylliya acuwa maaranaw new bessennee?’ yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Hessa gisho, kawoy daro yilotidi, I ba acuwa ubbaa ciggana gakkanaw paxa kaa7ettana mela qasho keethan yeggis. ");
INSERT INTO gofRNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Hessadakka, hintte issoy issoy hintte ishaa wozanappe maaronna ixxiko salon de7iya ta Aaway hinttena hessada oothana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesuusi hessa odi onggidaappe guye Galiilappe denddidi Yorddaanose Shaafappe hefinthan de7iya Yihuda biittaa bis. ");
INSERT INTO gofRNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Daro asay iya kaallidi bin entta giddofe hargganchchota pathis. ");
INSERT INTO gofRNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Farisaaweti iya paaccanaw koyidi iyaakko yidi, “Issi asi ay gaasonkka ba machchiw yeddanaw bessii?” yaagidi oychchidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesuusi zaaridi, “Xoossay koyro addenne maccas oothi medhdhidayssa hintte nabbabibeekketii? ");
INSERT INTO gofRNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","‘Hessa gisho, Issi asi ba aawanne ba aayiw aggidi ba machcheera issino gidees, nam77ayka issi asho gidoosona.’ ");
INSERT INTO gofRNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Hessa gisho, entti issi asho gidoosonappe attin nam77a gidokkona. Hiza, Xoossi qachchidayssa asi shaakkofo” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Farisaaweti, “Yaatin, Musey issi asi anjjo worqqate immidi yeddana mela ays kiittidee?” yaagidi oychchidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesuusi zaaridi, “Hinttee, hintte machcheta yeddana mela Musey hinttena kiittiday, hintte wozanaa minotethaa gishoppe attin koyroppe hessa mela gidenna. ");
INSERT INTO gofRNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ta hinttew odays; ba machchiya laymatonna de7ishin yeddidi hara ekkiya oonikka laammees” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Iya tamaareti iyaakko, “Azinabaynne machchibay hessa mela gidikko ekko geloy attiko lo77o” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yesuusi zaaridi, “Hessa mela timirttey Xoossay dandda7a immidayssatassafe attin asa ubbaassa gidenna. ");
INSERT INTO gofRNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Hiza, yelettishe shuufa gididi yelettidayssati de7oosona, qassi asi qaaratidayssati de7oosona, qassi salo kawotethaa gisho gidi banttana shuufaydayssati de7oosona. Hessa gisho, hayssa ekkanaw dandda7iya oonikka ekko” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Yesuusi ba kushiya guutha nayta bolla wothidi enttaw woossana mela issi issi asay nayta iyaakko ehidosona. Shin iya tamaareti asaa hanqettidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Shin Yesuusi, “Xoossaa kawotethay hayssata melassa gidiya gisho guutha nayti taakko yeyssa diggofite; yo giite” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ba kushiya entta bolla wothidaappe guye he bessaafe aggidi bis. ");
INSERT INTO gofRNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Issi gallas issi uray Yesuusakko yidi, “Asttamaariyaw, taani merinaa de7o demmanaw ay lo77obaa ootho?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesuusi iyaakko, “Lo77obaa ne tana ays oychchay? Issi Xoossaafe attin hari lo77oy baawa. Shin neeni merinaa de7uwa ekkanaw koykko kiitata naaga” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Uray zaaridi, “Awussa kiitata” yaagidi oychchis. Yesuusi zaaridi, “Wodhoppa, laymatoppa, kaysotoppa, worddo markkattofa, ");
INSERT INTO gofRNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ne aawanne ne aayiw bonchcha, ne shooruwa ne huu7iyatho dosa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","He na7atethay, “Taani hayssata ubbaa na7atethafe doomada naagas. Yaatin, hari taw pacciyabay aybee?” yaagidi oychchis. ");
INSERT INTO gofRNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesuusi zaaridi, “Neeni polo gidanaw koykko bada new de7iyabaa bayzada manqotas imma; neeni salon duretana. Yaata simma yada tana kaalla” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Shin he naatetha uray daro dure gidiya gisho hessa si7ida wode azzanishe aggidi bis. ");
INSERT INTO gofRNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Hessafe guye, Yesuusi ba tamaareta, “Taani hinttew tuma odays; durey salo kawotethi gelanayssi daro meto. ");
INSERT INTO gofRNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Dure asi Xoossaa kawotethaa gelanayssafe gimaley marppe luhora aadhdheyssi kawuyees” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Yesuusa tamaareti hessa si7idi malaalettidi, “Yaatin, ooni attanaw dandda7ii?” yaagidi oychchidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesuusi entta caddi xeellidi, “Hayssi asas dandda7ettenna, shin Xoossas ubbay dandda7ettees” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Phexiroosi zaaridi, “Nuuni ubbabaa aggidi nena kaallida. Yaatin, nuuni ay demmanee?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesuusi enttako hayssada yaagis: “Taani hinttew tuma odays; Asa Na7ay yaana alamiyan ba bonchcho araatan uttiya wode hintte tammanne nam77ati, tana kaallidayssati, tammanne nam77u araatan uttidi tammanne nam77u Isra7eele zerethata bolla pirddana. ");
INSERT INTO gofRNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ta sunthaa gisho keethe woykko ishata woykko michcheta woykko aawa woykko aayiw woykko nayta woykko gadiya aggiday oonikka xeetu kushe ekkana. Qassi merinaa de7uwakka ekkana. ");
INSERT INTO gofRNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Shin daroti ha77i dethan sinthe gididayssati guye gidana, qassi guye gididayssati sinthe gidana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Xoossaa kawotethay ba woyniya giddon oosanchchota kera oosisanaw wontta guura keyida keethaawa daanees. ");
INSERT INTO gofRNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","I he oosanchchotas hachchi hachchi issi dinaare qanxanaw enttara giigidi, entta ba woyniya giddo yeddis. ");
INSERT INTO gofRNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Qassi wonttafe heedzu saate gidishin keyidi ooso dhayidi giya bolla eqida hara asata demmis. ");
INSERT INTO gofRNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","I enttako, ‘Hintteka ta woyniya giddo bidi oothite, taani hinttew bessiya gatiya qanxana’ yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Enttika bidosona. Qassika I usuppun saateninne uddufun saaten keyidi hessada oothis. ");
INSERT INTO gofRNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Tammanne issi saate gidishin I keyaa wode harati yan eqqidayssata demmidi, ‘Hintte ooso oothonna gallas kumethi hayssan ays eqqidi pee7idetii?’ yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Entti zaaridi, ‘Nuna kera oosisiya asi dhayida gishossa’ yaagidosona. “Ikka, ‘Hintteka ta woyniya giddo bidi oothite’ yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Sa7i omarssin, woyniya goday oosanchchota halaqaakko, ‘Oosanchchota xeegada wurssethan ooso gelidayssatappe doomada koyro gelidayssata gakkanaw entta gatiya qanxa’ yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Tammanne issi saaten ooso oykkidayssati yidi, huu7en huu7en issi issi dinaare ekkidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Koyro ooso oykkidayssati yidi, banttaw daro imettana gidi qoppidosona. Shin enttika huu7en huu7en issi issi dinaare ekkidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Bantta miishiya ekki simmidi keethaawa bolla zuuzummidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Hayssati guyeppe yidi issi saate xalaala oothidosona. Shin gallas kumethi awa suulan daaburidi pee7ida nuura entti waanidi issino gidoona’ yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Woyniya keethaaway oosanchchotappe issuwako, ‘Ta ishaw, taani nena qohabikke; ne taara giigiday issi dinaaressa gidennee? ");
INSERT INTO gofRNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ne miishiya ekkada ne soo ba. Ta omarssi yidayssaskka neyssa mela immanaw koyays. ");
INSERT INTO gofRNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Taani ta miishiyan koyidabaa oothanaw taw maati baawe? Woykko taani keeha gidida gisho neeni qanaatay?’ yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Hessada ha77i dethan guye gididayssati sinthatana, sinthattidayssati qassi guyetana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesuusi Yerusalaame bishe, tammanne nam77u tamaareta dumma gaxa kessidi enttako yaagis: ");
INSERT INTO gofRNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Hekko, nuuni ha77i Yerusalaame buussa bolla de7oos. Yan Asa Na7ay kahine halaqatasinne higge asttamaaretas aadhdhi imettana. Enttika iya bolla hayqo pirdda pirddana. ");
INSERT INTO gofRNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Iya Ayhude gidonna deriyas aathi immana. Entti iya kawushshana, garaafana, yaatidi iya masqaliya bolla kaqqana. Shin I heedzantho gallas hayqoppe denddana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","He wode Zabdiyoosa machchiya ba nam77u adde naytara Yesuusakko yada, iya sinthan gulbbatada issibaa iya woossasu. ");
INSERT INTO gofRNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesuusi iikko, “Ne ay koyay?” yaagis. Iya zaarada, “Ne kawotethan ha ta nam77u nayti issoy ne ushachchan issoy ne haddirssan utto garkkii!” yaagasu. ");
INSERT INTO gofRNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Shin Yesuusi naytakko zaaridi, “Hintte ay woossiyako erekketa; taani uyanaw de7iya waaye xuu7aa uyanaw dandda7etii?” yaagis. Enttika, “Ee dandda7os” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yesuusi, “Tumakka taani uyanaw de7iya xuu7appe hintte uyana. Shin ta ushachchaninne haddirssan uttanayssata doorey tana gidikke. He bessay imetey, ta aaway immanaw giigisida asatassa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Attida tammu iya tamaareti hessa si7ida wode nam77u ishata bolla hanqettidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Shin Yesuusi entta ubbaa xeegidi hayssada yaagis. “Ayhude gidonna asaa haareyssati bantta asaa bolla godateyssanne entta kaaletheyssati wolqqan haareyssa hintte ereeta. ");
INSERT INTO gofRNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Shin hintte giddon hessada gidoppo. Hinttefe gitatanaw koyaa oonikka hinttew aylle gido. ");
INSERT INTO gofRNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Hintte giddon ubbaafe bolla gidanaw koyaa oonikka hinttew aylle gidanaw bessees. ");
INSERT INTO gofRNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Hessadakka, Asa Na7ay ase haggaazanawunne daro asaa wozanaw ba shemppuwa immanaw yisippe attin asan haggaazetanaw yibeenna” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Hessafe guye, Yesuusi ba tamaaretara Iyaarkkofe keyidi bishin, daro asay enttana kaallidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Oge gaxan uttida nam77u qooqeti Yesuusi yaara aadhdheyssa si7idi, “Godaw, Dawite Na7aw, nuus qadhettarkii” yaagidi waassidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Daro asay enttana, “Hayzite” yaagidi kaccidosona. Shin entti, “Godaw, Dawite na7aw, nuus qadhettarkii” gidi gujji waassidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yesuusi eqqidi, entta xeegidi, “Ta hinttew ay oothana mela koyeetii?” yaagidi oychchis. ");
INSERT INTO gofRNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Enttika, “Godaw, nu ayfey xeellana mela koyoos” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yesuusi enttaw qadhettidi, entta ayfiyaa bochchis. Ellesidi entta ayfey xeellis; entti iya kaallidi bidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesuusaranne iya tamaaretara Yerusalaame matidi, Shamaho Deriya bolla de7iya Beetefaage giya gutaa gakkishe, Yesuusi ba tamaaretappe nam77ata baappe sinthe yaagidi kiittis: ");
INSERT INTO gofRNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“Hinttefe sinthan de7iya guta biite. Yan issi harey qashon de7iyaro I maarara hintte sohuwara demmana. Entta billidi haa ekki yiite. ");
INSERT INTO gofRNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Oonikka hinttena oychchiko, ‘Goday enttana koyees’ yaagite. I enttana iirakka yeddi aggana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Hessika nabey, ");
INSERT INTO gofRNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Xiyoone katamaas, ‘Hekko, ne kawoy ashkke gididi, hare bollanne hare mara bolla uttidi, neekko yees’ yaagite” yaagidi xaafidayssi polettana mela hessi hanis. ");
INSERT INTO gofRNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Iya tamaareti bidi Yesuusi entta kiittidayssada oothidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Hariwunne hare maraa ehidi bollara ma77ida bantta ma7uwa entta zokkon yeggidosona. Yesuusi ma7ota bolla uttis. ");
INSERT INTO gofRNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Daro asay bantta ma7uwa ogiyan hiixidosona. Harati boncco tashidi ogiya bolla yeggidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Yesuusappe sinthara hamutteyssatinne iyappe guyera kaalliya daro asay, “Hosaana! Dawite na7ay galatetto! Godaa sunthan yeyssi anjjettidayssa! Bonchchoy Ubbaafe Dhoqqa Saluwan Xoossaas gido!” yaagidi waassidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesuusi Yerusalaame katamaa gelida wode he kataman de7iya asa ubbay, “Hayssi oonee?” yaagidi yarkkidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Asay, “Hayssi Galiilan de7iya Naazirete katamaappe yida nabiya Yesuusa” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesuusi Xoossa Keethi gelidi, yan bayzeyssatanne shammeyssata ubbaa kare goodis. Miishe laammeyssata xarpheezatanne holleta bayziya oydeta shiri yeggis. ");
INSERT INTO gofRNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ikka enttako, “Xoossaa qaalan, ‘Ta keethay Xoossaa woossiya keethi geetettana’ geetetti xaafettis. Shin hintte panggati qosettiya gonggolo oothideta” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Yesuusi Xoossa Keethan de7ishin qooqetinne gunddati iyaakko yin entta pathis. ");
INSERT INTO gofRNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Shin kahine halaqatinne higge asttamaareti Yesuusi oothida malaalisiyabata be7idayssasinne guutha nayti Xoossa Keethan, “Dawite na7ay, galatetto” yaagidi waasseyssa si7idi hanqettidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Entti Yesuusakko, “Hayssati geyssa ne si7ay?” yaagidosona. Yesuusi, “Ee si7ays, Xoossaa qaalan, ‘Guutha nayta doonaninne dhammiya nayta doonan galata wothadasa’ geetettidi xaafettidayssa hintte nabbabibeekketii?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Enttana yan aggidi Bitaaniya katamaa bidi aqis. ");
INSERT INTO gofRNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Yesuusi wontta guura katama simmidi yishe koshattis. ");
INSERT INTO gofRNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Oge gaxan issi balase mithi be7idi iikko bis. Shin haythafe attin hara aykkoka demmibeenna. Hessa gisho, iyo, “Hizappe nam77antho ayfe ayfoppa!” yaagis. He balase mithiya ellesada mela aggasu. ");
INSERT INTO gofRNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Iya tamaareti hessa be7idi, “Ha balasiya waanada ellesa meladee?” yaagidi malaalettidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesuusi zaaridi, “Taani hinttew tuma odays; hinttew ammanoy de7ikko, qassi hintte sidhonna ixxiko balase bolla taani oothidayssa mela xalaala ootheketa, shin ‘Ha deriya shodettada abban wodhdha’ yaagikko hanana. ");
INSERT INTO gofRNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ammanidi hintte woossiyabaa aybibaa gidikkoka hintte ekkana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesuusi Xoossa Keetha gelidi tamaarssishin, kahine halaqatinne Ayhude cimati iyaakko yidi, “Neeni hayssa oothana mela new ay maati de7ii? New ha maata immiday oonee?” yaagidi oychchidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesuusi enttako, “Taanikka hinttena issibaa oychchays; hintte taw hessa zaarikko, taani ay maatan oothiyako hinttew odana. ");
INSERT INTO gofRNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Yohaannisi xammaqana mela maatay awuppe imettidee? Xoossafeyye asappe?” yaagis. Entti bantta giddon zorettidi, “Nuuni, ‘Xoossafe’ giikko, I nuna, ‘Yaatin ays ammanibeekketii?’ yaagana. ");
INSERT INTO gofRNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Nuuni, ‘Asappe’ giikko, asa ubbay Yohaannisa nabe oothi xeelliya gisho asaa yayyoos” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Hessa gisho, “Nuuni erokko” yaagidi zaaridosona. Ikka, “Hiza, taanikka hayssa ay maatan oothiyako hinttew odikke” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Yesuusi kaallidikka hayssada yaagis: Nam77u adde nayti de7iya issi uray de7ees. He uray bayra na7aakko bidi, ‘Ta na7aw, hachchi woyniya giddo bada ootha’ yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Na7ay zaaridi, ‘Atto biikke’ yaagis. Shin guyeppe ba wozanan qoppi ekkidi oothanaw bis. ");
INSERT INTO gofRNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Aaway ba kaalo na7aakko bidi, ba bayra na7aakko gidayssada kiittis. Ikka, ‘Ero, ta aawaw’ yaagis. Shin bibeennna. ");
INSERT INTO gofRNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ha nam77u naytappe ba aawas kiitettidayssi awussee?” yaagis. Enttika, “Bayra” yaagidosona. Yesuusi enttako, “Ta hinttew tuma odays; qaraxa qanxiseyssatinne laymateysati hinttefe sinthattidi Xoossaa kawotethaa gelana. ");
INSERT INTO gofRNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Xammaqiya Yohaannisi suure ogiya tamaarssishe yin I geyssa ammanibeekketa. Shin qaraxa qanxiseyssatinne laymateysati ammanidosona. Hintte hari attoshin, entta be7idikka hintte nagaraappe simmidi ammanibeekketa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Qassika Yesuusi hayssada yaagis; “Hara leemiso si7ite, woyne tokkida issi uray de7ees. He woyniya yuushuwa diris. Woyniya gum77iya olaaka bookkis. Woyniya naaganaw shakkoka shaakkis. Hessafe guye, gadiya kothe immidi hara biitta bis. ");
INSERT INTO gofRNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Woyne ayfiyaa maxiya wodey gakkin bana gakkiya baggaa ekkidi yaana mela ba aylleta enttako yeddis. ");
INSERT INTO gofRNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Kothe aawati iya aylleta oykkidi issuwa wadhdhidosona, hankuwa wodhidosona qassi attidayssa shuchchan caddidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Woyne atakilttiya goday kaseyssatappe dariya hara aylleta kiittis. Kothe aawati entta bollaka hankkoyssata bolla oothidayssada oothidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Wurssethan I, ‘Ta na7aa entti bonchchana!’ yaagidi ba na7aa enttako kiittis. ");
INSERT INTO gofRNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Shin kothe aawati na7aa be7idi bantta giddon ‘Gadiya laattanayssi hayssa, iya wodhidi gadiya nuuni laattoos!’ yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Na7aa oykkidi woyniya giddofe gaxa kissidi wodhidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Hiza, woyne atakilttiya goday yaa wode he kothe aawata waatanee?” yaagidi oychchis. ");
INSERT INTO gofRNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Entti zaaridi, “I he iita asata iita wodho wodhidi, woyney ayfiyaa wode iya gakkiya baggaa woden woden immiya hara kothe aawatas immana” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yesuusi zaaridi enttako, Xoossaa qaalan, “ ‘Gimbbeyssati boridi ixxida shuchchay, godaa xaphuwa minthiya, ubbaafe aadhdhiya shuchchaa gidis. Hayssi Goday oothidabaa; nu ayfiyaas malaalisiyabaa’ geetettidi xaafettidayssa nabbabibeekketii? ");
INSERT INTO gofRNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Hessa gisho, taani hinttew odays; Xoossaa kawotethay hinttefe ekettidi lo77o ayfe ayfiyaa asatas imettana. ");
INSERT INTO gofRNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ha shuchchaa bolla kunddiya ubbay meqerettana. Qassi he shuchchay iya bolla wodhdhiya uraykka gaacettana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Kahine halaqatinne Farisaaweti Yesuusi odida leemisuwan banttana odidayssa eridosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Entti Yesuusa oykkanaw koyidosona, shin asay Yesuusa nabe oothidi xeelliya gisho asaas yayyidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesuusi asaas zaaridi hayssada yaagidi leemiso odis. ");
INSERT INTO gofRNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Xoossaa kawotethay ba na7aas yaagano giigisida kawuwa daanees. ");
INSERT INTO gofRNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","He kawoy yaagano yaana mela odi wothida asata xeeganaw ba aylleta kiittis. Shin asati yaanaw koyibookkona. ");
INSERT INTO gofRNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Qassi hara aylleta xeegidi, xeegettida asatakko bidi, ‘Taani ta sanggatanne modhdhida gatarmenthota shukkas; ubbabay giigis. Ta yaaganuwa haa yiite yaagite’ yaagidi kiittis. ");
INSERT INTO gofRNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Shin xeegettidayssati xeessaa ixxidi, bantta oosos oosos bidosona. Issoy ba goshshaas, hankkoy ba zal77iyas bis. ");
INSERT INTO gofRNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Harati qassi kawuwa aylleta oykkidi, kawushshi wadhdhidi wodhidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","“Kawoy daro yilottidi, ba wotaaddareta yeddidi shemppo wodhidayssata wodhisis, entta katamakka xuuggis. ");
INSERT INTO gofRNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Hessafe guye, ba aylletakko, ‘Yaaganoy giigis, shin xeegettidayssati yaaganuwas bessiya asi gidokkona. ");
INSERT INTO gofRNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Hessa gisho, wogga ogeta bidi, demmida asi ubbaa yaaganuwa yaana mela xeegite’ yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Aylleti ogiya bolla bidi bantta demmida asi ubbaa lo77otanne iitata ehidi yaagano shaqara gelssidi kunthidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Shin kawoy kathaa maanaw uttida asaa be7anaw gelida wode yaagano ma7o ma77iboonna issi asi demmis. ");
INSERT INTO gofRNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Iyaakko, ‘Laa, ne yaagano ma7o ma77onna waanada hayssa geladii?’ yaagis. Shin uray si77i gis. ");
INSERT INTO gofRNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Kawoy ba aylletakko, ‘Ha uraa kushiyanne tohuwa qachchidi, kare dhumaa kessi yeggite. Yan iyaw yeehonne achcha garccethi gidana’ yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Hessadakka, Xoossaa kawotethaas xeegettidayssati daro shin doorettidayssati guutha” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Hessafe guye, Farisaaweti bidi, Yesuusa waati odan oykkaneekko zorettidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Bantta tamaaretanne Heroodisa baggatappe issota issota kiittidosona. Enttika, “Asttamaariyaw, ne tuma odeyssa nu eroos. Neeni asappe ase shaakkaka, asa woyganddes gada aykkoka oothaka, Xoossaa ogiya tumatethan tamaarssasa. ");
INSERT INTO gofRNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ane nuus oda, nuuni Roome Kawuwas giira giiranaw bessi bessennee?” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Shin Yesuusi entta iita qofaa eridi, “Ha cubboto, tana ays paacetii? ");
INSERT INTO gofRNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Giira giiriya miishiya tana bessite” yaagis. Enttika iyaw santime ehidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","I, “Ha sunthaynne malay ooddebaye?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Entti, “Roome Kawuwayssa” yaagidosona. Yaatin Yesuusi enttako, “Hiza, Kawuwas besseyssa kawuwas, Xoossas besseyssa Xoossas immite” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Entti hessa si7ida wode malaalettidi iya matappe aggidi bidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","He gallas hayqoppe denddoy baawa yaagiya Saduqaaweti Yesuusakko yidi, yaagidi iya oychchidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Asttamaariyaw, ‘Musey, issi asi na7a yelonna hayqqiko, he hayqqidayssa ishay iya machchiw ekkidi, ba ishaas na7a yelo’ yaagidi kiittis. ");
INSERT INTO gofRNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Nu eriya laappun ishati de7oosona. Bayray machcho ekkidi na7a yelonna hayqqis. Iya machchiw iya kaalo ishay ekkis. ");
INSERT INTO gofRNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Hessadakka, he maccasiw ekkida nam77anthoyka, heedzanthoyka, bidi laappunati wurana gakkanaw ubbay hayqqidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ubbaafe guye he maccasiya hayqqasu. ");
INSERT INTO gofRNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Yaatin, laappunati ubbay iyo ekkida gisho hayqoppe denddiya gallas, he maccasiya laappunatappe awussas machcho gidanee?” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesuusi zaaridi, “Hintte Xoossaa qaalay tamaarssiyabaa woykko iya wolqqaa eronna gisho baleeta. ");
INSERT INTO gofRNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Asay hayqoppe denddiya wode salon de7iya kiitanchchota mela gidanaappe attin ekkokona gelokkona. ");
INSERT INTO gofRNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Qassi hayqqida asati hayqoppe denddanabaa Xoossay hinttew odidayssa nabbabibeekketii? ");
INSERT INTO gofRNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Xoossay, ‘Taani Abrahame Xoossaa, Yisaaqa Xoossaa, Yayqooba Xoossaa’ yaagis. Hessa gisho, Xoossay paxa de7eyssata Xoossaafe attin hayqqidayssata Xoossaa gidenna” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Daro asay hessa si7idi, iya timirttiyan malaalettidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Yesuusi Saduqaawetas gaanabaa dhayssidayssa Farisaaweti si7ida wode issife shiiqidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Entta giddofe issi higge asttamaarey Yesuusa paace oysho oychchis. ");
INSERT INTO gofRNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Asttamaariyaw, higge ubbaafe aadhdheyssi awussee?” yaagidi oychchis. ");
INSERT INTO gofRNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesuusi zaaridi, “ ‘Ne Godaa, ne Xoossaa, ne kumetha wozanappe, ne kumetha shemppuwafe, ne kumetha qofaappe dosa. ");
INSERT INTO gofRNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ubbaafe aadhdheyssinne bayra kiitay hayssa. ");
INSERT INTO gofRNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Nam77antho ubbaafe aadhdhiya kiitay, ase ubbaa ne huu7iya ne doseyssada dosa’ yaageyssa. ");
INSERT INTO gofRNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Muse higgeynne nabeta timirttey ubbay ha kiitata bolla katoosona” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Farisaaweti issi bolla shiiqidi de7ishin, Yesuusi enttana, ");
INSERT INTO gofRNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Kiristtoosabaa hintte woygetii? I oodde na7ee?” yaagidi oychchis. Entti, “I Kawuwa Dawite na7a” yaagidi zaaridosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yesuusi enttako, “Yaatin, Dawitey Geeshsha Ayyaanan gididi waattidi Kiristtoosa, ‘Godaa’ gidi xeegii? Dawitey gishe, ");
INSERT INTO gofRNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Godaa Xoossay, ta Godaakko, ne morkketa ne tohoy yedhdhiyaso oothana gakkanaw, hayssan taappe ushachcha baggan utta’ gis. ");
INSERT INTO gofRNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Hiza, Dawitey Kiristtoosa Godaa gidi xeegikko, waanidi Kiristtoosi Dawite na7a gidii?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Yesuusas issi qaala zaaranaw dandda7ida asi oonikka baawa. Qassi he gallasappe doomidi hara oysha oychchanaw oonikka dandda7ibeenna. ");
INSERT INTO gofRNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Hessafe guye, Yesuusi shiiqida asaasinne ba tamaaretas hayssada yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Higge asttamaaretinne Farisaaweti Muse higgiya billanaw maatara de7oosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Hessa gisho, entti hinttena kiittiya ubbaa oothitenne naagite. Shin entti ootheyssada oothofite. Ays giikko, entti ooddeyssada oothokona. ");
INSERT INTO gofRNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Entti tookkanaw dandda7ettona tooho qachchidi asaa toossoosona. Shin banttaw hari attoshin, he toohuwa asay tookkiya wode biradhdhe xeeran bochchanaw koyokkona. ");
INSERT INTO gofRNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Shin entti bantta ooso ubbaa asi be7ana mela oothoosona. Bantta som77oninne qesen qachchiya maxaafaa xiqisey de7iya kitaafe dalggisosona, bantta ma7uwa macaraakka adussoosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Mokettiya bessan bonchcho bessinne Ayhude Woosa Keethatan daro lo77iya oyde dosoosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Asay giyan enttana bonchchon sarothanayssanne ‘Asttamaariyaw’ gidi xeeganayssa koyoosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Shin hintte asttamaarey issuwa xalaala gidida gishonne hintte ubbay ishata gidida gisho ‘Asttamaariyaw’ geetettidi xeegettofite. ");
INSERT INTO gofRNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Hinttew salon issi aawa xalaali de7iya gisho ha sa7an oonakka ‘Aawaw’ gidi xeegoppite. ");
INSERT INTO gofRNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Hinttew issi Goday Kiristtoosa xalaali de7iya gisho ‘Godaw’ geetetti xeegettofite. ");
INSERT INTO gofRNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Hintte giddon bayratey hintte aylle gido. ");
INSERT INTO gofRNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Bana gitayaa oonikka kawuyana; bana kawushshiya oonikka gitatana. ");
INSERT INTO gofRNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Hinttenoo, cubboto, higge asttamaaretonne Farisaaweto, asa sinthan salo kawotethaa gorddeyssato hinttena ayye. Hinttee, hintte huu7en gelekketa qassi haratakka gelssekketa. ");
INSERT INTO gofRNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Hinttenoo cubboto, higge asttamaaretonne, Farisaaweto, am77eta keetha hintte bonqishe, asi be7o gidi woosa adusseeta. Hessa gisho, hinttena ayye. Ubbaafe aadhdhiya pirdday hinttena naagees. ");
INSERT INTO gofRNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Hinttenoo, cubboto, higge asttamaaretonne Farisaaweto, hintte issi uraa ammanthanaw abbaranne sa7ara yuuyeta. Shin hintte iya ammanthida wode he uraa hinttefe aathidi Gaannames giigettidayssa oothiya gisho hinttena ayye. ");
INSERT INTO gofRNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Oonikka Xoossa Keethan caaqqiko aykkoyka baawa. Shin Xoossaa Keethan de7iya worqqan caaqqiko, he caaqoy iya gomana giya qooqeto, hinttew qooqidi harata kaaletheyssato, hinttena ayye. ");
INSERT INTO gofRNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Hinttenoo, eeyato, qooqeto, worqqay aadhdhiyye? Worqqiya Xoossaas dummayaa Xoossa Keethay aadhdhii? ");
INSERT INTO gofRNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Qassi ‘Oonikka yarshsho yarshshiya bessan caaqqiko, aykkoyka baawa. Shin oonikka iya bolla de7iya yarshshuwan caaqqiko, he caaqoy iya gomana’ yaagidi tamaarsseta. ");
INSERT INTO gofRNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Hinttenoo, qooqeto, yarshshoy aadhdhiyye? Yarshshuwa Xoossaas dummayaa bessay aadhdhii? ");
INSERT INTO gofRNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Hessa gisho, yarshsho bessan caaqqiya uray, he yarshsho bessaaninne iya bolla de7iya ubbaban caaqqees. ");
INSERT INTO gofRNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Xoossa Keethan caaqqiya uray, he Xoossa Keethaninne iyan de7iya Xoossan caaqqees. ");
INSERT INTO gofRNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Salon caaqqiya uray Xoossaa araataninne he araata bolla uttiya Xoossan caaqqees. ");
INSERT INTO gofRNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Hinttenoo, cubboto, higge asttamaaretonne Farisaaweto, hinttena ayye. Hintte kareetha sawoppe, naatiroppenne okasheppe asraata kesseta. Shin higgiyan de7iya aadhdhi koshsheyssata aggideta. Hessika suure pirdda, qadhetethinne ubbaban ammanetethi. Haratakka aggonnashin hayssata hintte oothanaw bessees. ");
INSERT INTO gofRNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Hinttew qooqidi hara asi kaaletheyssato, hintte ushshaafe udunxe kessidi gimale mitteeta. ");
INSERT INTO gofRNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Hinttenoo, cubboto, higge asttamaaretonne Farisaaweto, hinttena ayye. Hintte shaatiyasinne keriyas bolla baggaa geeshsheeta. Shin enttaw garssan bonqeynne uuzetethi kumi uttis. ");
INSERT INTO gofRNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Neno qooqe Farisaawiyaw, shaatiyasinne keriyas garssaa kasetada geeshsha. Hessafe guye, bolla baggayka geeshshi gidana. ");
INSERT INTO gofRNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Hinttenoo, cubboto, higge asttamaaretonne Farisaaweto, hinttena ayye. Kare baggara qalame tiyettidi lo77idi, giddon meqethinne wooqidabay kumida duufota daaneta. ");
INSERT INTO gofRNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Hessadakka, bolla baggara asas lo77o daaneta. Shin hintte garssan cubbotethinne iitatethi kumis. ");
INSERT INTO gofRNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Hintteno, cubboto, higge asttamaaretonne Farisaaweto, hinttena ayye. Hintte nabetas duufo keexeta, qassi xillota duufuwakka loytheeta. ");
INSERT INTO gofRNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Qassi hintte, ‘Nuuni beni nu aawata wode de7idabaa gidiyakko, enttara issife nabeta suuthaa guussokoshin’ yaageeta. ");
INSERT INTO gofRNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Hessa gisho, hintte nabeta wodhida asaa nayta gideyssa hinttee hintte huu7en markkatteeta. ");
INSERT INTO gofRNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Hiza, hintte aawati doomidayssa hintte polite. ");
INSERT INTO gofRNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Ha shooshatoo, shoosha nayto, hintte Gaanname pirddaafe waanidi attanee? ");
INSERT INTO gofRNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Hessa gisho, ta odeyssa si7ite; taani nabeta, cincca asatanne asttamaareta hintteko kiittana. Enttafe issota issota hintte wodhananne masqaliya bolla kaqqana. Baggata Ayhude Woosa Keethatan lisson garaafananne katamaappe katama gooddana. ");
INSERT INTO gofRNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Hessa gisho, xilluwaa Aabela wodhida wodiyappe doomidi, Xoossa Keethasinne yarshsho bessaafe giddon hintte wodhida Barakiya na7aa Zakkariyaasa wode gakkanaw hayqqida xillo asa ubbaa gisho hintte seerettana. ");
INSERT INTO gofRNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Taani hinttew tuma odays; hinttenne hintte aawati oothida balaas ha pirdda ubbay ha yeletethaa bolla gakkana. ");
INSERT INTO gofRNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Yerusalaame, Yerusalaame, nabeta wodhiyare! Xoossay neekko kiittidayssata shuchchan caddiyare! Kuttoy ba nayta ba qefen haphpheyssada taani ne asaa ta qesiyan gechchanaw aappun toho koyadina! Shin tana diggadasa. ");
INSERT INTO gofRNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Hiza, hintte Xoossaa keethay kaysi gidana. ");
INSERT INTO gofRNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Taani hinttew odays; ‘Godaa sunthan yeyssi anjjettidayssa’ hintte gaana gakkanaw nam77antho tana be7ekketa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesuusi Xoossa Keethafe keyidi bishin, iya tamaareti iyaakko yidi, malaalettidi Xoossa Keetha gimbbiya bessidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yesuusi enttako zaaridi, “Ee! Hayssa ubbaa be7etii? Taani hinttew tumaa odays; shuchchi shuchcha bolla gimbbettida mela laalettonna attenna” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yesuusi Shamaho Deriya bolla uttidashin, iya tamaareti banttarkka iyaakko yidi, “Hessi awude hananeekko nuus oda. Qassi ne yuussasinne wodiya wurssethaas malaatay aybee?” yaagidi oychchidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesuusi zaaridi, “Hinttena oonikka balethonna mela naagettite! ");
INSERT INTO gofRNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ays giikko, daro asati ta sunthan, ‘Taani Kiristtoosa, Xoossay asaa ashshanaw kiittidayssa’ yaagishe yidi daro asaa balethana. ");
INSERT INTO gofRNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Matan de7iya ola girssaa, haahon de7iya ola wore si7anaw de7eeta. Hessa melabay hananaw bessiya gisho hirggofite. Shin wurssethay buroona. ");
INSERT INTO gofRNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Derey deriyara, issi kawotethay hara kawotethaara olettana. Koshaynne biittaa qaaxoy ubba bessan hanana. ");
INSERT INTO gofRNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Hessi ubbay yelo iqethas zooke mela. ");
INSERT INTO gofRNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“He wode asay hinttena waayes aathi immana, qachchananne wodhana. Ta sunthaa gisho asa ubbay hinttena ixxana. ");
INSERT INTO gofRNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","He wode daroti ammano aggana. Bantta giddon issoy issuwa aathidi immana, issoy issuwa ixxana. ");
INSERT INTO gofRNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Qassi daro worddo nabeti denddidi darota balethana. ");
INSERT INTO gofRNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Geellatethi dariya gisho daro asaa siiqoy irxxana. ");
INSERT INTO gofRNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Shin wurssethi gakkanaw gencciya uray attana. ");
INSERT INTO gofRNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Asa ubbaas markka gidana mela Xoossaa kawotethaa Wonggelay biitta ubban odettana. Hessafe guye, wurssethay yaana. ");
INSERT INTO gofRNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Hessa gisho, nabiya Daaneli odida bashshaa tunatethay geeshsha bessan eqqidayssa hintte be7ana. (Akeekiso: Hessi woy guusseeko nabbabeyssi akeeko!) ");
INSERT INTO gofRNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","He wode Yihuda biittan de7eyssati deriyakko baqato. ");
INSERT INTO gofRNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Keetha huu7en de7iya uray ba son de7iyabaa ekkanaw soo gelonna baqato. ");
INSERT INTO gofRNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Gaden de7eyssi ba ma7uwa ekkanaw guye simmofo. ");
INSERT INTO gofRNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","He wode qantha maccasatasinne dhanthiya maccasatas daro un77a gidana. ");
INSERT INTO gofRNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Balggon woykko Sambbaatan hintte baqatoy gidonna mela Xoossaa woossite. ");
INSERT INTO gofRNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ays giikko, sa7i medhettosappe hachchi gakkanaw hanonnabay, qassi sinthafekka ubbarakka hanonna waayey he wode hanana. ");
INSERT INTO gofRNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Xoossay he gallasata taybuwa guuthonnaako ase gidida oonikka attenna. Shin I ba doorida asata gisho he gallasata taybuwa guuthana. ");
INSERT INTO gofRNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“He wode oonikka hinttena, ‘Hekko, Kiristtoosi hayssan’ woykko ‘Hinin de7ees’ yaagikko ammanoppite. ");
INSERT INTO gofRNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ays giikko, worddo Kiristtoosatinne worddo nabeti denddana. Enttaw dandda7ettiko, hari attoshin Xoossay dooridayssatakka balethanaw gita malaatatanne malaalisiyabata oothana. ");
INSERT INTO gofRNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Akeekite, taani hinttew hayssa kasetada odas. ");
INSERT INTO gofRNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Hessa gisho, asay hintteko, ‘Hekko, Kiristtoosi bazzon de7ees’ giikko, yaa booppite. Woykko hintteko, ‘Hekko, qol77an de7ees’ giikko, enttabaa ammanoppite. ");
INSERT INTO gofRNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ays giikko, wol77anthi salon wol77ammidi, dolohappe wuloha gakkanaw bentteyssada, Asa Na7aa yuussay hessada hanana. ");
INSERT INTO gofRNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Bawuti de7iyson ankkoti shiiqana. ");
INSERT INTO gofRNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“He wode he waaye gallasatappe guye, sohuwara away dhumana, ageenay ba poo7uwa diggana. Xoolinttoti saloppe wodhdhana, qassi salon de7iya wolqqati buqettana. ");
INSERT INTO gofRNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","He wode Asa Na7aa yuussaa mallay saluwa bolla benttana. Sa7an de7iya asi ubbay yeekkana. Qassi Asa Na7ay, wolqqaranne gita bonchchuwara saluwa shaara giddora yishin entti be7ana. ");
INSERT INTO gofRNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","I ba kiitanchchota gita punniya moyzera kiittana. Entti sa7aa oyddu baggaa bidi, ha gaxappe ya gaxa gakkanaw de7iya iyaw doorettidayssata shiishana. ");
INSERT INTO gofRNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Balase mithaafe tamaarite. I aacidi hayxiya wode torchchey matattidayssa hintte ereeta. ");
INSERT INTO gofRNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Hessadakka, hintte ha ubbabaa be7iya wode Yesuusi matidi penggen de7eyssa erite. ");
INSERT INTO gofRNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Taani hinttew tuma odays; ha ubbabay polettana gakkanaw, ha yeletethay aadhdhenna. ");
INSERT INTO gofRNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Saloynne sa7ay aadhdhana, shin ta qaalay ubbaka aadhdhenna. ");
INSERT INTO gofRNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“He gallasaanne he saatiya salon de7iya ta aawappe attin hari salo kiitanchchota gidin woykko Na7aa gidin oonikka erenna. ");
INSERT INTO gofRNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Asa Na7aa yuussay, Nohe wode hanidayssa mela gidana. ");
INSERT INTO gofRNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","He wode dhayo haathay yaanappe sinthe Nohey markkabiyan gelida gallasa gakkanaw, asay mishenne uyishe, ekkishenne gelishe gam77is. ");
INSERT INTO gofRNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Bashsha haathay yidi, entta ubbaa dhayssana gakkanaw akeekibookkona. Asa Na7aa yuussayka hessada hanana. ");
INSERT INTO gofRNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","“He wode nam77u asati gaden oothana. Enttafe issoy ekettana, hankkoy attana. ");
INSERT INTO gofRNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Nam77u maccasati issife gaaccana. Enttafe issiniya ekettana hankkiya attana. ");
INSERT INTO gofRNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Hiza, hintte Goday ay gallas yaanekko hintte eronna gisho minnidi naagite. ");
INSERT INTO gofRNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Shin kaysoy qammafe ay saaten yaanekko keethaaway eriyakko, ba keethay bookettonna mela barkkidi naaganashin. ");
INSERT INTO gofRNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Hessadakka, Asa Na7ay hintte qopponna saaten yaana gisho hintteka giigidi de7ite. ");
INSERT INTO gofRNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Yaatin, ba soo asaas kathaa koshshiya wodiyan immana mela iya goday doorida ammantheysinne wozanaama aylley oonee? ");
INSERT INTO gofRNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","I ba goday kiittidayssa oothishin iya goday yidi demmiya aylley anjjettidayssa. ");
INSERT INTO gofRNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Taani hinttew tuma odays; goday he aylliya babaa ubbaa bolla shuumana. ");
INSERT INTO gofRNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Shin he aylley iita gidikko, ‘Ta goday gam77idi yaana’ yaagidi ba wozanan qoppidi, ");
INSERT INTO gofRNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ba lagge oosanchchota wadho doomikko, mathotteyssatara miikkonne uyikko, ");
INSERT INTO gofRNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","he aylliya goday I qopponna gallasinne I eronna saaten, ");
INSERT INTO gofRNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","yidi iya qanxerethana. Iya qaadaa cubbotara oothana. He bessan iyaw yeehonne achche garccethi gidana. ");
INSERT INTO gofRNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“He wode salo kawotethay bantta kuraaziya oykkidi, machcho ehanaw bida addiya mokkanaw keyida tammu geela7ota daanees. ");
INSERT INTO gofRNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Enttafe ichchashati eeya, qassi ichchashati cincca. ");
INSERT INTO gofRNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Eeyati kuraaze oykkidosona, shin hara lambba oykkibookkona. ");
INSERT INTO gofRNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Shin cinccati bantta kuraaziyanne hara guzha lambba oykkidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Machchiw ekkeyssi gam77in, he geela7oti banttana dhiskkoy oykkin dhiskkidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Giddi bilahe gidiya wode ‘Hekko, machchiw eheyssi gakkis, iya mokkanaw keyite’ yaagiya gita cabboy si7ettis. ");
INSERT INTO gofRNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“He wode he geela7oti ubbay barkkidi, bantta kuraaziya giigisidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Eeyati cinccatakko, ‘Nu kuraazey to7ana haniya gisho hintte lambbaafe nuus immerkketi’ yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Shin cinccati enttako zaaridi, ‘Akkay, nuusinne hinttes gidiya lambbi baawa. Hessa gisho, hinttew bidi shammidi ekkite’ yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Eeya geela7oti lambba shammanaw bin, machchiw ekkeyssi puttu gis. Giigeti uttida ichchashu geela7oti iyara issife yaagano keethaa gelidosona; kareykka gorddetti aggis. ");
INSERT INTO gofRNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Guyeppe hankko geela7oti yidi, ‘Godaw, godaw, nuus dooyarkii’ yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Shin I enttako zaaridi, ‘Taani hinttew tuma odays; ta hinttena erikke!’ ");
INSERT INTO gofRNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Hiza, Asa Na7ay yaana gallasaa woykko saatiya hintte eronna gisho barkkidi naagite. ");
INSERT INTO gofRNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Xoossaa kawotethay ba oosanchchota xeegidi baw de7iyabaa enttaw sheedhdhidi oge baanaw keyida uraa daanees. ");
INSERT INTO gofRNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Enttaw huu7en huu7en entta wolqqaa mela issuwas ichchashu karxiite bira, issuwas nam77u karxiite bira qassi issuwas issi karxiite bira immidi ba ogiya bis. ");
INSERT INTO gofRNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ichchashu karxiite bira ekkida aylley sohuwara bidi zal77idi, hara ichchashu karxiite bira wodhisis. ");
INSERT INTO gofRNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Hessadakka, qassi nam77u karxiite bira ekkida aylley hara nam77u karxiite bira wodhisis. ");
INSERT INTO gofRNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Shin issi karxiite bira ekkidayssi bidi, olla bookkidi, ba godaa miishiya moogis. ");
INSERT INTO gofRNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Daro wodeppe guye he aylleta goday yidi, ba miishiya enttara salla77is. ");
INSERT INTO gofRNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ichchashu karxiite bira ekkida aylley yidi, hara ichchashu karxiite bira ehidi, ‘Ta godaw, neeni taw ichchashu karxiite bira immadasa. Shin taani hara ichchashu karxiite bira wodhisas’ yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Iya goday, ‘Zambboy! Neeni lo77onne ammanthiya aylle; neeni guuthaban ammanettadasa. Taani nena darobaa bolla shuumana; haa gelada ne godaara ufaytta’ yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Qassi nam77u karxiite bira ekkidayssi yidi, ‘Ta godaw, neeni taw nam77u karxiite bira immadasa. Shin taani hara nam77u karxiite bira wodhisas’ yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Iya goday, ‘Zambboy! Neeni lo77onne ammanthiya aylle; neeni guuthaban ammanettadasa. Taani nena darobaa bolla shuumana; haa gelada ne godaara ufaytta’ yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Qassi issi karxiite bira ekkidayssi yidi, ‘Ta godaw, neeni zeronna bessafe cakkeyssanne dharcconna bessafe maxiya iita asi gideyssa taani erays. ");
INSERT INTO gofRNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Hessa gisho, yayyada ne biraa biittan moogas. Ne miishey hayssish’ yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Iya goday zaaridi, ‘Ha iita azalla aylliyaw, taani zeronna bessafe cakkeyssanne dharcconna bessafe maxiya asi gideyssa eradasa. ");
INSERT INTO gofRNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Yaatin, neeni ta miishiya bankken wothidabaa gidiyakko, taani simmiya wode ta miishiya wodhera ekkanayssa diggadasa. ");
INSERT INTO gofRNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Hessa gisho, miishiya iyappe ekkidi, tammu karxiite biri de7eyssas immite. ");
INSERT INTO gofRNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ays giikko, de7iya ubbaas guzhettananne darana. Shin baynnayssafe hari attoshin, he iyaw de7iya guuthiyaka ekettana. ");
INSERT INTO gofRNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ha maaddonna aylliya kare dhumaa kessi yeggite. Yan iyaw yeehonne achche garccethi gidana’ yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Asa Na7ay, kiitanchcho ubbatara, ba bonchchuwara yaa wode I ba bonchcho kawota araata bolla uttana. ");
INSERT INTO gofRNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Biittan de7iya asi ubbay iya sinthe shiiqana. Henthanchchoy dorssata deeshatappe shaakkeyssada I he asaa nam77an shaakkana. ");
INSERT INTO gofRNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Qassi dorssata ushachcha baggara deeshata haddirssa baggara essana. ");
INSERT INTO gofRNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Hessafe guye, kawoy ushachcha baggara de7eyssatakko hayssada yaagana: ‘Ta Aaway anjjidayssato, haa yidi sa7ay medhettiya wode hinttew giigida kawotethaa laattite. ");
INSERT INTO gofRNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ays giikko, taani koshattin muzideta, saamottin ushshideta, erettona imatha asi gidada bin mokkideta, ");
INSERT INTO gofRNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","kallottin mayzideta, harggettin harggisideta, qashettin tana oychchideta’ yaagana. ");
INSERT INTO gofRNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Hessafe guye, xilloti zaaridi, ‘Godaw, neeni koshattin awude be7idi muzidoo? Woykko neeni saamottin awude be7idi ushshidoo? ");
INSERT INTO gofRNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Neeni imathe gidada yin awude be7idi mokkidoo? Woykko neeni kallottin awude mayzidoo? ");
INSERT INTO gofRNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Neeni harggin woykko qashettin neekko bidi nena awude oychchidoo?’ yaagana. ");
INSERT INTO gofRNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Kawoy zaaridi, ‘Taani hinttew tuma odays; hintte tana kaalliya ha ubbaafe guuxeyssas oothidayssa taw oothideta’ yaagana. ");
INSERT INTO gofRNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“He wode haddirssa baggara de7eyssatakko, ‘Ha qanggettidayssato, ta matappe haakkite. Xalahesinne iya kiitanchchotas giigida merinaa taman biite. ");
INSERT INTO gofRNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ays giikko, koshattin tana muzibeekketa; saamottin ushshibeekketa. ");
INSERT INTO gofRNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Taani imathe gidada bin tana mokkibeekketa, kallottin mayzibeekketa, harggininne qashettin tana oychchibeekketa’ yaagana. ");
INSERT INTO gofRNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“He wode entti, ‘Godaw, neeni koshattin woykko saamottin woykko imathe gidada bin woykko kallottin woykko harggin woykko qashettin be7idi nena awude maaddonna ixxido?’ yaagidi zaarana. ");
INSERT INTO gofRNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“He wode kawoy zaaridi enttako, ‘Taani hinttew tuma odays; hintte tana kaalliya ha ubbaafe guuxeyssa maaddonna ixxidayssi, tana maaddonna ixxidayssa’ yaagana. ");
INSERT INTO gofRNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Hessa gisho, he asati merinaa pirddas qassi xilloti merinaa de7uwas baana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesuusi ha timirttiya ubbaa wurssida wode ba tamaaretakko, ");
INSERT INTO gofRNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Nam77u gallasappe guye, Paasika Baale bonchchiya gallas gideyssa ereeta. He gallas Asa Na7ay masqaliya bolla kaqettanaw asa kushen aadhdhi imettana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","He wode kahine halaqatinne cimati, Qayyaafa giya kahine halaqaa keethan shiiqidi, ");
INSERT INTO gofRNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","asi eronna Yesuusa oykkidi, wodhanaw maqettidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Shin entti, “Asay ooshshi kessonna mela gidi, Paasika bonchchiya gallas hessa oothoko” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesuusi Bitaaniya kataman baro harggida Simoona son de7ees. ");
INSERT INTO gofRNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Yesuusi imatuwa bolla de7ishin issi maccasiya albasxiroose philqqaaxe kumetha daro al77o shitto ekka yada Yesuusa huu7en tigasu. ");
INSERT INTO gofRNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Shin Yesuusa tamaareti hessa be7idi hanqettidi, “Ha shittoy coo iitey aybisse? ");
INSERT INTO gofRNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ha shittoy al77o gaten bayzettidi, miishey manqotas imettanaw dandda7ettees” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesuusi entti geyssa eridi, enttako, “Ha maccasiw ays waaysetii? Iya taw lo77obaa oothasu. ");
INSERT INTO gofRNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Manqoti ubba wode hinttera daana. Shin taani hinttera ubba wode de7ikke. ");
INSERT INTO gofRNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Iya ha shittuwa ta bolla tigidayssi tana mooganaw giigisanaassa. ");
INSERT INTO gofRNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Taani hinttew tuma odays; biitta ubban ha Wonggelay sabbakettiya bessan awunkka, asay iyo hassayana mela iya oothidayssi odettana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","He wode tammanne nam77u Yesuusa tamaaretappe issoy, Asqoroota Yihuda geetetteyssi kahine halaqatakko, ");
INSERT INTO gofRNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","bidi, “Taani hinttew Yesuusa aatha immiko, hintte taw ay immanee?” yaagidi entta oychchis. Entti zorettidi hasttamu bira santime immidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Hessafe guye, Yihudi Yesuusa aathidi immanaw injjetiya wode wochchees. ");
INSERT INTO gofRNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Uytha Baale bonchchiya koyro gallas, Yesuusa tamaareti iyaakko yidi, “Paasika bonchchiya gallas neeni maana kathi nuuni awun giigisino?” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yesuusi enttako, “Kataman de7iya addiyako bidi, ‘Asttamaarey, taw wodey gakkida gisho ta tamaaretara Paasika bonchchiya gallasa ne son aathana yaagees’ yaagite” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Iya tamaareti Yesuusi banttana kiittidayssada oothidi, Paasika Baale gallas maana kathaa giigisidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Sa7ay omarssiya wode Yesuusi tammanne nam77u hawaaretara kathi maanaw uttis. ");
INSERT INTO gofRNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Entti miishin, Yesuusi enttako, “Taani hinttew tuma odays; hinttefe issi uray tana aathidi immana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Entti daro dagammidi, huu7en huu7en, “Godaw, tuma taneshsha?” gidi iya oychchidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesuusi zaaridi, “Ba kushiya taara issife shaatiyan yeddeyssi I tana aathidi immana. ");
INSERT INTO gofRNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Asa Na7ay, Xoossaa qaalan iyaw xaafettidayssada hayqqana. Shin Asa Na7aa aathidi immiya uraa ayye; he uray yelettonna attidaakko iyaw lo77oshin” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Iya aathi immanaw de7iya Yihudi zaaridi, “Asttamaariyaw, neeni gey taneyye?” yaagis. Yesuusi zaaridi, “Neeni ne huu7en gadasa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Entti mishin, Yesuusi uythaa ekkidi Xoossaa galatis. He uythaa menthidi ba tamaaretas immidi, “He7ite, miite, hayssi ta ashuwa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Xuu7aa ekkidi, Xoossaa galatis. Enttaw immidi, “Ubbay hayssafe uyite. ");
INSERT INTO gofRNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Hayssi daro asaa nagaray atto geetettana mela gukkiya ta suuthaa. Ha suuthay Xoossay hinttera geliya caaquwa mintheyssa. ");
INSERT INTO gofRNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Shin taani hinttew odays; taani ta Aawa kawotethan ooratha woyne ushshaa hinttera uyana gallasa gakkanaw nam77antho ha woyne ushshaa uyikke” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Galata mazmure yexxidayssafe guye Shamaho Deriya bidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","He wode Yesuusi enttako, “ ‘Xoossay henthanchchuwa shocana dorssatikka laalettana’ geetettidi Xoossa qaalan xaafettidayssa mela hachchi qamma hintte ubbay tana aggidi baqatana. ");
INSERT INTO gofRNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Shin taani hayqoppe denddidaappe guye hinttefe sinthatada Galiila baana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Phexiroosi zaaridi, “Entti ubbay nena aggidi baqatikkoka, taani nena aggike” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesuusi Phexiroosakko, “Taani new tuma odays; hachchi qamma kuttoy waassanaappe sinthe neeni tana heedzu toho kaddana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Phexiroosi zaaridi, “Taani neera issife hayqoppe attin nena ubbaka kaddike” yaagis. Hankko iya tamaareti ubbayka hessada gidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yaatidi, Yesuusi ba tamaaretara Geetesemaane giya bessaa bidi, enttako, “Taani hini bada Xoossaa woossashshana, hintte hayssan uttite” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Phexiroosanne Zabdiyoosa nayta nam77ata baara ekki bidi daro azzanonne un77etethi doomis. ");
INSERT INTO gofRNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Qassika enttako, “Taani hayqos gathiya un77a un77ettas. Hayssan taara gam77itenne minnidi naagite” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Guuthi sinthe bidi biittan gufannidi, “Ta Aawaw, dandda7ettiyaba gidikko ha waaye xuu7aa taappe digga. Shin ne sheney hanoppe attin ta sheney hanoppo” yaagidi Xoossaa woossis. ");
INSERT INTO gofRNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Yesuusi ba tamaaretakko simmi yidi entti dhiskkidashin demmis. Phexiroosakko, “Hintte issi saatekkonne dhiskkonna taara minnanaw dandda7ibeekketii? ");
INSERT INTO gofRNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Paacen hintte gelonna mela barkkidi naagitenne Xoossaa woossite. Hinttew lo77o amoy de7ees, shin hintte daaburanchcho asi” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Yesuusi qassi nam77antho bidi, “Ta Aawaw, taani ha waaye xuu7appe uyonna de7ishe aadhdhanaw dandda7ettonnabaa gidikko ne sheney hano” yaagidi Xoossaa woossis. ");
INSERT INTO gofRNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Qassika simmi yaa wode iya tamaareta ayfiyaa dhiskkoy goozin, zin77idashin demmis. ");
INSERT INTO gofRNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Qassika entta aggi bidi, kase qaalaa zaari heedzantho woossis. ");
INSERT INTO gofRNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Hessafe guye, ba tamaaretakko yidi, “Ha77i gakkanaw dhiskkeetinne shemppetii? Hekko, Asa Na7ay, nagaranchchota kushen aadhdhi imettiya saatey gakkis. ");
INSERT INTO gofRNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Denddidi yedhdhite, tana aathidi immeyssi hayssish gakkis” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesuusi buroo hessa haasayishin, tammanne nam77u tamaaretappe issoy, Yihudi gakki wodhdhis. Kahine halaqatinne deriya cimati kiitida daro asati mashshenne xam77a oykkidi iyara issife yidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yesuusa aathi immiya Yihudi he daro asaakko, “Taani yeereyssi hintte koyeyssi iya, iya oykkite” yaagidi malla immi wothis. ");
INSERT INTO gofRNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Iirakka Yesuusakko shiiqidi, “Asttamaariyaw, saro de7ay” yaagidi iya yeeris. ");
INSERT INTO gofRNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesuusi iyakko, “Ta laggiyaw, neeni oothanabaa ootha agga” yaagis. Hessafe guye, shiiqidi, Yesuusa oykkidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Yesuusara de7eyssatappe issoy ba mashsha shoddidi kahine halaqaa aylliya shocidi, iya haythaa qanxidi yeggis. ");
INSERT INTO gofRNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Shin Yesuusi, “Ne mashshaa guye shoohuwan zaara. Ays giikko, mashsha shoddiya ubbay mashshan hayqqana. ");
INSERT INTO gofRNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ta, ta Aawa woossiyako daro mukulun taybettiya kiitanchchota yeddanaw dandda7onnabaa new daanii? ");
INSERT INTO gofRNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Yaatin, Xoossaa qaalan hessada hananaw bessees geetettidayssi waanidi polettanee?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","He saatiyan, Yesuusi he shiiqida daro asaakko, “Tana pangga oothidi oykkanaw mashshenne xam77a oykkidi yidetii? Taani Xoossa Keethan gallas gallas tamaarssashe hinttera de7iya wode tana oykkibeekketa. ");
INSERT INTO gofRNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Shin hayssi ubbay hanidayssi nabeti Xoossaa qaalan xaafidayssi polettana melassa” yaagis. He wode iya tamaareti ubbay iya aggidi baqatidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Yesuusa oykkidayssati kahine halaqaa Qayyaafakko iya efidosona. Yan higge asttamaaretinne biitta cimati shiiqidi de7oosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Shin Phexiroosi kahine halaqaa zabbaa gakkanaw haahon iya kaallis. Iya wurssethay shaakettana gakkanaw zabbaa gelidi naageyssatara uttis. ");
INSERT INTO gofRNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Kahine halaqatinne shiiqida asa ubbay Yesuusa wodhanaw iya bolla worddo markka koyidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Daroti yidi iya bolla worddo markka markkattidosona, shin aykkoka demmibookkona. Guyeppe nam77u asati yidi, ");
INSERT INTO gofRNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“Ha uray, ‘Taani Xoossa Keetha laallada heedzu gallasan zaara keexanaw dandda7ays’ yaagis” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Kahineta halaqay denddi eqqidi Yesuusakko, “Hayssati nena mootiya mootowas neeni zaariyabay baawe?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Shin Yesuusi si77i gis. Qassika kahine halaqay, “Taani nena de7o Xoossaa sunthan oykkays; neeni Xoossaa Na7aa Kiristtoosa gidikko nuus oda” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesuusi zaaridi, “Neeni ne huu7enkka gadasa. Shin taani hinttew odays; hizappe guye, Asa Na7ay wolqqaama Xoossaa ushachcha baggan uttidashin, qassi salo shaarara yishin hintte be7ana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","He wode kahine halaqay daro yilotidi ba ma7uwa peedhidi, “Hayssa be7ite Xoossaa cayis! Nuna hara markka ay koshshii? I ha77i cayidayssa hintte si7ideta. ");
INSERT INTO gofRNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Hintte qofay aybee?” yaagis. Enttika, “Iyaw hayqo bessees” yaagidi zaaridosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Yaatin, entti iya som77on cuttidi dechchidosona. Harati iya baqqidi, ");
INSERT INTO gofRNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Kiristtoosaa! Nena dechchiday oonee? Ane nuus oda” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Phexiroosi zabban uttidashin, issi aylliya iyaakko yada, “Neenikka Galiila Yesuusara issife de7aasa” yaagasu. ");
INSERT INTO gofRNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Shin I entta ubbaa sinthan he aylleko, “Neeni giyabay aybeekko taani erikke” yaagidi kaddis. ");
INSERT INTO gofRNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Qassi bidi dirssaa penggeko gakkishin hara aylliya iya be7ada, yan de7iya asaakko, “Ha uray Naazirete Yesuusara de7ees” yaagasu. ");
INSERT INTO gofRNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Phexiroosi nam77antho caaqqidi, “Taani he uraa erikke!” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Guuthu gam77ishin, yan eqqida asati Phexiroosakko yidi, “Nekka tuma enttara issife de7aasa; neeni ne haasayan erettasa” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Hessafe guye, Phexiroosi, “Taani he uraa erikke!” yaagidi, bana qanggethinne caaqo doomis. He wode iirakka kuttoy waassi aggis. ");
INSERT INTO gofRNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Yesuusi iyakko, “Neeni kuttoy waassanaappe sinthe tana heedzu toho kaddana” gidayssa Phexiroosi akeekidi, kare keyidi iita yeeho yeekkis. ");
INSERT INTO gofRNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Wontta guura kahine halaqatinne biitta cimati ubbay Yesuusa wodhisanaw maqettidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Entti Yesuusa qachchi efidi deriya haariya Philaaxoosas aathidi immidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","He wode Yesuusa oythida Yihudi, Philaaxoosi Yesuusa bolla pirddidayssa be7idi, qiirottidi, he hasttamu biraa santimiya kahine halaqatasinne deriya cimatas guye zaaris. ");
INSERT INTO gofRNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“Taani xillo asi hayqos aatha immada nagara oothas” yaagis. Shin entti, “Hessi nu meto gidenna ne meto” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yihudi miishiya Xoossaa Keethan yeggi aggidi entta matappe bidi, sulleti hayqqis. ");
INSERT INTO gofRNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Kahine halaqati miishiya ekkidi, “Ha miishey suutha miishe gidiya gisho nuuni Xoossa Keethaa miishiyara gatheyssi woga gidenna” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Hessafe guye, issife zorettidi, bete asi mooganaw mana biitta shammidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Hessa gisho, he gadey hachchi gakkanaw suutha biitta geetetti xeegettees. ");
INSERT INTO gofRNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Nabiya Ermmiyasi, “Isra7eele asay iyaw qanxanaw gammattida hasttamu bira santime ekkidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Goday tana kiittidayssada mana biitta shammanaw immidosona” gidayssi he wode polettis. ");
INSERT INTO gofRNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yesuusi deriya haariya Philaaxoosa sinthe shiiqin, Philaaxoosi iyaakko, “Neeni Ayhude kawo?” yaagidi oychchis. Yesuusi zaaridi, “Ne gadasa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Kahine halaqatinne biitta cimati iya mootiya wode enttaw aybi zaarokka immibeenna. ");
INSERT INTO gofRNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","He wode Philaaxoosi Yesuusakko, “Hayssati nena mootiya mootuwa ubbaa si7ikkii?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Yesuusi hari attoshin, issi qaalakka zaaronna ixxin, deriya haareyssi daro malaalettis. ");
INSERT INTO gofRNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Deriya haareyssi laythan laythan Paasika Baale bonchchiya gallasan, asay koyaa issi asi qashoppe birshshiya wogi de7ees. ");
INSERT INTO gofRNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","He wode issi Barbbaana Yesuusa giya daro erettida iita asi qasho keethan de7ees. ");
INSERT INTO gofRNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Hessa gisho, daro asay shiiqidi de7ishin Philaaxoosi, “Taani hinttew Barbbaana Yesuusa birshshoyye, woykko Yesuusa giya Kiristtoosa birshsho?” yaagidi asaa oychchis. ");
INSERT INTO gofRNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","I hessa giday entti qanaattidi Yesuusa oythidayssa eriya gishossa. ");
INSERT INTO gofRNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Philaaxoosi pirdda keethan uttidashin, iya machchiya, “Taani hachchi qamma amuhon iyabaa daro waayettashe aqida gisho he xillo uraa bolla aybibaakka oothofa” yaagada kiittasu. ");
INSERT INTO gofRNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Shin kahine halaqatinne deriya cimati Philaaxoosi Barbbaana birshshidi, Yesuusa wodhana mela, asay iya woossana mela, asaa cimmidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Philaaxoosi zaaridi enttako, “Taani entta nam77aafe hinttew oona billana mela koyeetii?” yaagidi oychchis. Entti, “Barbbaana billana mela koyoos” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Philaaxoosi, “Yaatin, Yesuusa giya Kiristtoosa waato?” yaagidi entta oychchis. Ubbay zaaridi, “Masqaliya bolla iya kaqqa” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Philaaxoosi asaakko, “Ays? I ay iitabaa oothidee?” yaagidi oychchis. Shin asay kaseyssafe aathidi, “Masqaliya bolla iya kaqqa” gidi waassidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ooshshi denthethofe hara aybibaakka oothanaw dandda7ettonayssa Philaaxoosi be7idi, haathe ekkidi, “Ha uraa hayquwan taani de7ikke. Hessa oothey hinttena” yaagidi asaa sinthan ba kushiya meecettis. ");
INSERT INTO gofRNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Asa ubbay zaaridi, “Iya suuthaa gomey nunanne nu nayta gakko” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Yaatin, Philaaxoosi Barbbaana enttaw billidi, Yesuusa lisson garaafidi, masqaliya bolla kaqettidi hayqqana mela enttaw aathidi immis. ");
INSERT INTO gofRNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Hessafe guye, Philaaxoosa wotaaddareti Yesuusa deriya haareyssa soo ekki efin, wotaaddareti ubbay iya yuushuwan eqqidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Iya afilaa qaari ekkidi zo7o afila mayzidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Qassi aguntha kalachcha giigisidi, iya huu7en wothidosona. Iya ushachcha kushiyan mayre xam77a oythidi, iya sinthan gulbbatidi, “Ayhude kawaw, mukulu laythi kawota!” yaagidi, iya bolla qelqisidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Iya bolla cuttidosona. He mayre xam77aa ekkidi, iya huu7en shocidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Entti iya bolla qelqisidayssafe guye zo7o afilaa iyappe qaari ekkidi, iya afilaa iya mayzidosona. Masqaliya bolla iya kaqqanaw ekki efidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Entti kare keyidi, issi Simoona giya Qereena biitta asi demmidi, Yesuusa masqaliya wolqqan toossidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Golggotta giya bessi gakkidosona. “Golggotta” guussay “Guugge bessi” guussu. ");
INSERT INTO gofRNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Hessan entti ciiye walakettida woyne ushshaa uyo gidi iyaw immidosona. Shin I hessa ganxi ekkidi, uyonna ixxis. ");
INSERT INTO gofRNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Entti masqaliya bolla iya kaqqidayssafe guye iya afilaa shaakkidi, saama yeggidi ekkidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Hessafe guye, yan uttidi iya naagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Qassi, “Hayssi Ayhude Kawuwa Yesuusa” yaagiya mooto xuufiya iya huu7e son wothidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Yesuusara he wode nam77u panggata issuwa iyappe ushachcha baggan, hankkuwa iyappe haddirssa baggara, masqaliya bolla kaqqidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ogiyara aadhdhiya asay Yesuusa boridi, iya bolla cuttishe, ");
INSERT INTO gofRNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Xoossa Keethaa laallada heedzu gallasa giddon keexeysso, nena ashsha. Neeni Xoossaa Na7a gidikko, ane masqaliya bollafe wodhdha” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Hessadakka, kahine halaqati, higge asttamaaretinne biitta cimati issife Yesuusa bolla qelqisidosona. Hayssada yaagidosona: ");
INSERT INTO gofRNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Harata ashshis, shin bana ashshanaw dandda7ibeenna. I Isra7eele kawo gidikko, ane masqaliya bollafe ha77i wodho, nukka iya ammanana. ");
INSERT INTO gofRNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Xoossan I ammanettees, Xoossay iya ashshanaw koykko ane ashsho. Ays giikko, I bana, ‘Taani Xoossaa Na7a’ gees” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Qassi hari attoshin, iyara masqaliya bolla kaqettida panggatika hessada gidi iya bolla qelqisidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Usuppun saateppe bidi, uddufun saate gakkanaw biitta ubbay dhumis. ");
INSERT INTO gofRNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Uddufun saate gidiya wode Yesuusi, “Elohee, Elohee, lama sabaqitani?” gidi gita waaso waassis. “Elohee, Elohee, lama sabaqitani?” geyssa birshshethay “Ta Xoossaw, ta Xoossaw, tana ays aggadi?” guussu. ");
INSERT INTO gofRNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Hessan eqqida asaappe issoti issoti hessa si7idi, “Ha uray Eliyaasa xeegees” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Iira enttafe issoy woxxi bidi, ispponjje ekkidi, caala woyne ushshaa kunthis. Hessa mayre xam77a xeeran wothidi ushshanaw iya doonakko shiishis. ");
INSERT INTO gofRNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Shin hankkoti, “Naaga, Eliyaasi iya ashshanaw yaanekko ane be7oos” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yesuusi nam77antho gita waaso waassidi, hayqqi aggis. ");
INSERT INTO gofRNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","He saaten Xoossa Keethan kaqettida magaraajjoy qommofe duge gakkanaw nam77u keyidi, peedheti wodhdhis. Biittay qaaxxis, zaallayka phalqqettis. ");
INSERT INTO gofRNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Duufoti dooyettin Xoossaa asatappe daroti hayqoppe denddidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Entti duufoppe keyidi, Yesuusi hayqoppe denddidayssafe guye geeshsha katamaa bidosona; yan entti daro asaas benttidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Mato halaqaynne iyara Yesuusa naagiya wotaaddareti biittay qaaxxidayssanne hessan hanidabaa be7ida wode daro yayyidi “Tuma hayssi Xoossaa Na7aa” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Hessan daro maccasati, Galiilappe doomidi Yesuusa haggaazishe kaallidayssati haahon eqqidi xeellosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Entta giddon Magdela Mayraama, Yayqoobanne Yoosefa aayyaa Mayraamanne Zabdiyoosa machchiya de7oosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Sa7ay omarssiya wode Yoosefa giya issi dure uray, Armmatiyasa katamaappe yis. I ba huu7enkka Yesuusa kaalliya asi. ");
INSERT INTO gofRNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Yoosefi Philaaxoosakko bidi, Yesuusa ahaa ekkanaw woossis. Philaaxoosi ahay Yoosefas imettana mela kiittis. ");
INSERT INTO gofRNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yesuusa ahaa ekkidi, geeshsha moogo afilan xaaxis. ");
INSERT INTO gofRNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Baw moogettanaw shuchchafe woocida ooratha gonggolon iya ahaa wothis. Qassi he gonggoluwa doonan gita shuchchaa gonddorssi wothidi aggi bis. ");
INSERT INTO gofRNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Magdela Mayraamanne hankko Mayraama he gonggoluwakko simmidi uttidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Wontethe Sambbaata gallas, kahine halaqatinne Farisaaweti Philaaxoosakko yidi, hayssada yaagidosona: ");
INSERT INTO gofRNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","“Godaw, ha worddanchchoy paxa de7ishe, ‘Taani heedzu gallasappe guye hayqoppe denddana’ yaagidayssi nuus hassayettis. ");
INSERT INTO gofRNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Hessa gisho, I moogettida gonggoluwa heedzu gallas gakkanaw, minthi naagana mela kiittarkki. Hessi hanonna ixxiko, iya tamaareti bidi iya ahaa kaysi dhayssidi, ‘Hayqoppe denddis’ yaagidi asaas odikko nam77antho balesoy koyroyssafe ubba haa iitana” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Philaaxoosi enttako, “Hinttew naageyssati de7oosona; bidi hinttew dandda7ettida mela naagisite” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Hessa gisho, entti bidi duufoy boshettonna mela shuchchaa bolla maatame wothidi wotaaddaretan naagisidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sambbaati aadhdhin Wogga wode wontta guura, Magdela Mayraamanne hankko Mayraama Yesuusi moogettida gonggoluwa be7anaw bidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Qopponna wolqqaama biitta qaaxoy hanis. Godaa kiitanchchoy saloppe wodhdhidi duufuwa doonan de7iya shuchchaa gonddorssidi iya bolla uttis. ");
INSERT INTO gofRNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Iya malay wol77anthi daanees. Iya ma7oykka shachchada boothi. ");
INSERT INTO gofRNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Naageyssati kiitanchchuwa be7idi, yashshan kokkoridi, hayqqida asada hanidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Kiitanchchoy maccasatakko, “Hintte masqaliya bolla kaqettida Yesuusa koyeyssa taani eriya gisho yayyofite. ");
INSERT INTO gofRNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","I kase odidayssa mela hayqoppe denddis; hayssan deenna. Haa yidi iya zin77isida bessaa be7ite. ");
INSERT INTO gofRNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Hintte ha77i ellessi bidi, iya tamaaretas, ‘Yesuusi hayqoppe denddis. Qassi I hinttefe sinthattidi Galiila baana; hintte iya yan be7ana’ yaagidi odite. Taani hinttew hayssa odanaw yas” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Entti yayyishenne daro ufayttishe, duufuwa matappe ellessidi bidi, iya tamaaretas odanaw woxxidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Qopponna Yesuusi enttara gahettidi enttako, “Saroy hinttew gido” yaagis. Entti iyaakko shiiqidi, iya tohuwa oykkidi iyaw goynnidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","He wode Yesuusi enttako, “Yayyofite; bidi ta tamaareti Galiila baana mela enttaw odite. Entti yan tana be7ana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","He maccasati bishin, duufuwa naagiya wotaaddaretappe baggati katamaa bidi, hanidabaa ubbaa kahine halaqatas odidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Kahine halaqatinne cimati shiiqidi zorettidi, wotaaddaretas daro miishe immidi, ");
INSERT INTO gofRNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","“ ‘Nuuni dhiskkidashin iya tamaareti qamma yidi, iya ahaa kaysidosona’ yaagite. ");
INSERT INTO gofRNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ha odaa deriya haareyssi si7ikko, hessi hintte bala gidonnayssa nuuni iya odi ammanthana. Hinttena aybikka hirggisoppo” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Wotaaddareti miishiya ekkidi, kiitettidayssada oothidosona. Ha oday Ayhude matan hachchi gakkanaw odettishe de7ees. ");
INSERT INTO gofRNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Tammanne issi iya tamaareti Yesuusi banttana biite gida Galiilaa Deriya bolla bidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Yan entti iya be7ida wode iyaw goynnidosona, shin enttafe issoti issoti sidhidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesuusi enttako shiiqidi, “Saloninne sa7an maati ubbay taw imettis. ");
INSERT INTO gofRNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Hiza, hintte ubba bessi bidi, Aawa, Na7aa, Geeshsha Ayyaana sunthan ase ubbaa xammaqidi tana kaalleyssata oothite. ");
INSERT INTO gofRNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Taani hinttena kiittidaba ubbaa entti naagana mela entta tamaarssite. Taani wodiya wurssethaa gakkanaw ubba wode hinttera de7ays” yaagis.");
INSERT INTO gofRNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Hayssi Xoossaa Na7aa Yesuus Kiristtoosa Wonggelaa doomethaa. ");
INSERT INTO gofRNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Nabiya Isayaasi xaafida maxaafan Xoossay, “Hekko, taani ta kiitanchchuwa neeppe sinthe yeddana. I ne ogiya giigisana. ");
INSERT INTO gofRNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Issoy bazzo gidon ba qaala dhoqqu oothidi, ‘Godaa ogiya giigisite; I hamuttana horogaa iyaw suurisite gis’ ” yaagees. ");
INSERT INTO gofRNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Xammaqiya Yohaannisi asaa xammaqishe, “Hintte nagaraappe simmidi xammaqetite; Xoossay hintte nagaraa atto gaana” yaagidi qaala odishe bazzo biittafe yis. ");
INSERT INTO gofRNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Yihuda biittan de7iya asay ubbaynne Yerusalaame katamaa asa ubbay Yohaannisakko yoosona. Bantta nagara paaxin, Yohaannisi entta Yorddaanose Shaafan xammaqees. ");
INSERT INTO gofRNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yohaannisi gimale ikiseppe dadettida afila ma77ees. Ba xeessan dafo danccees; qassi boolenne degera eessi mees. ");
INSERT INTO gofRNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Yohaannisi qaala odishe, “Taappe guyera daro minneyssi yees. Hari attoshin, taani iya caammaa wodoruwa hokkada billanaw bessike. ");
INSERT INTO gofRNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Taani hinttena haathan xammaqays, shin I hinttena Geeshsha Ayyaanan xammaqana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Yesuusi he wode Galiila biittan de7iya Naazirete katamaappe yin, Yohaannisi Yorddaanose Shaafan iya xammaqis. ");
INSERT INTO gofRNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Yesuusi haathaafe keyaa wode saloy dooyettin, Geeshsha Ayyaanay ba bolla holeda wodhdhishin be7is. ");
INSERT INTO gofRNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Qassi saloppe, “Taani dosiya ta na7ay nena; ta nenan ufayttays” yaagiya qaalay yis. ");
INSERT INTO gofRNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Iira Geeshsha Ayyaanay Yesuusa bazzo biitta efis. ");
INSERT INTO gofRNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Yesuusi bazzo biittan Xalahen paacettishe oytamu gallas gam77is. Do7atara de7is, shin kiitanchchoti yidi iya maaddidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Yohaannisi qashettidaappe guye Yesuusi Xoossaa kawotethaa Wonggelaa odishe Galiila biittaa bis. ");
INSERT INTO gofRNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Yan, “Wodey gakkis; Xoossaa kawotethay matattis. Hintte nagaraappe simmidi, Wonggelan ammanite” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yesuusi Galiila Abbaa matara aadhdhishe, molo oykkiya, Simoonanne iya ishaa Inddiriyasa, bantta gitiya abban yeggeyssata be7is. ");
INSERT INTO gofRNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Enttako, “Tana kaallite; taani hinttena ase oythu tamaarssana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Entti sohuwara bantta gitiya yeggi aggidi Yesuusa kaallidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Yesuusi guuthi sinthe bidi, nam77u ishata Zabdiyoosa nayta, Yayqoobanne Yohaannisa wogoluwa giddon bantta gitiya giigiseyssata be7is. ");
INSERT INTO gofRNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","I entta be7ida mela xeegis. Entti bantta aawa Zabdiyoosa, iya oosanchchotara wogoluwa giddon yeggi aggidi Yesuusa kaallidi bidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Entti Qifirnahoome katamaa gelidosona. Sambbaati gelida mela Yesuusi ellesidi Ayhude Woosa Keethi gelidi tamaarsso oykkis. ");
INSERT INTO gofRNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Maatara de7iya asada tamaarssesippe attin higge asttamaaretatho tamaarssonna gisho asay iya timirttiyan malaalettidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","He wode tuna ayyaanay oykkida issi uray Ayhude Woosa Keethi gelidi ba qaala dhoqqu oothidi, ");
INSERT INTO gofRNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Naazirete Yesuusa, neeni nuuppe ay koyay? Nuna dhayssanaw yadi? Neeni ooneekko ta erays; neeni Xoossaa Geeshshaa gidikkii?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yesuusi he tuna ayyaanaa, “Hayza, ha addiyafe keya” gidi kiittis. ");
INSERT INTO gofRNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Tuna ayyaanay uraa daferethidi, waassidi iyappe keyis. ");
INSERT INTO gofRNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Asay ubbay malaalettidi, “Hayssi aybee? Ha uray ba maatan hari attoshin tuna ayyaanatakka kiittees. Entti iyaw kiitettosona; hayssi aybi ooratha timirtte?” gidi, bantta giddon issoy issuwa oychchidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Yesuusa sunthay ellesidi Galiila biittan de7iya heera ubban keyis. ");
INSERT INTO gofRNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yesuusi Ayhude Woosa Keethafe keyidi, Yayqoobaranne Yohaannisara Simoona soonne Inddiriyasa soo bis. ");
INSERT INTO gofRNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simoona machche aayyaa qoxo misha harggada zin77idaaro Yesuusi yaa gakkiya wode iyaw odidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","I iikko shiiqidi, I kushiya oykkidi, iyo denthi essis. Qoxoynne mishay aggin iya entta mokkasu. ");
INSERT INTO gofRNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Harggida asa ubbaanne tuna ayyaanati oykkida asa ubbaa omarssi away wullidaappe guye iyaakko ehidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Kataman de7iya asa ubbay he keetha kare shiiqidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yesuusi dumma dumma harggen oykettida daro asaa pathidi, daro tuna ayyaanata kessis. I ooneekko tuna ayyaanati erida gisho entta odisonna diggis. ");
INSERT INTO gofRNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Yesuusi wontta guura denddidi, asi baynna bessi bidi, yan Xoossaa woossis. ");
INSERT INTO gofRNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simooninne iyara de7eyssati iya koyishe bidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Entti iya demmidi, “Asay ubbay nena koyees” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yesuusi qassi entta, “He heeran de7iya hara katamata yedhdhite. Taani yiday Wonggelaa odanaw gidiya gisho yankka qaala odanaw bessees” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ayhude Woosa Keethatan qaala odishenne tuna ayyaanata kessishe, Galiila biitta ubban yuuyis. ");
INSERT INTO gofRNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Baroy oykkida issi uray Yesuusakko yidi, iya sinthan gulbbatidi, “Neeni koykko tana geeshshanaw dandda7aasa” yaagidi woossis. ");
INSERT INTO gofRNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesuusi iyaw qadhettidi, ba kushiya yeddidi iya bochchidi, “Taani koyays, geeya” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Sohuwara baroy uraa yeddin uray paxis. ");
INSERT INTO gofRNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Yesuusi uraa minthi naagisidi kessi yeddis. ");
INSERT INTO gofRNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Yesuusi iya, “Nena era, hayssa ooddeskka odoppa. Shin bada ne asatethaa kahine bessa. Neeni ha77i geeshshi gididayssa asaa erisanaw, Musey kiittida yarshshuwa yarshsha” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Shin uray bidi, guta ubban asa ubbaas odis. Hessa gisho, Yesuusi qoncce keyidi, katama gelanaw dandda7ibeenna. Shin asi baynnason gaxan de7is; qassi asay ubba bessafe iyaakko yoosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Guutha gallasappe guye Yesuusi Qifirnahoome simmidi, son de7ees giya oday si7ettis. ");
INSERT INTO gofRNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Asaa keethay ekkonna ixxin, hari attoshin kareykka xuummana gakkanaw daro asay shiiqin, Yesuusi qaala tamaarssis. ");
INSERT INTO gofRNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Oyddu asati issi gundda uraa tookkidi iyaakko ehidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Asay darida gisho uraa Yesuusakko shiishanaw enttaw dandda7ettona ixxin, Yesuusi de7iya ginaara keetha qaaridi, kaara qawuxidi uraa I zin77ida alggara duge yeddidi Yesuusa sinthan wodhisidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yesuusi entta ammanuwa be7idi, he gundda uraa, “Ta na7aw, ne nagaray atto geetettis” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Higge asttamaaretappe he bessan uttida issoti issoti bantta wozanan, ");
INSERT INTO gofRNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“La ha uray hayssa mela iitabaa Xoossaa bolla ays odetii? Xoossaa xalaalappe attin hari ooni nagara atto gaanaw dandda7ii?” gidi qoppidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Entti bantta wozanan hessada qoppidayssa Yesuusi sohuwara ba ayyaanan eridi, enttako, “Hinttee hintte wozanan ays hessada qoppeetii? ");
INSERT INTO gofRNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Gundda uraa, ‘Ne nagaray atto geetettis’ geyssi mateyye? Woykko, ‘Dendda eqqada ne alggaa tookkada ba’ geyssi matee? ");
INSERT INTO gofRNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Shin taw, Asa Na7aas, sa7a bolla nagara atto gaanaw maati de7eyssa hintte erana mela” gidi he gundda uraakko, ");
INSERT INTO gofRNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Nena gays, dendda eqqada ne alggaa tookkada ne soo ba” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Uray ellesi denddi eqqidi, ba alggaa tookkidi asa ubbay be7ishin bis. Asay ubbay malaalettidi, “Nuuni hayssa mela malaalisiyabaa be7i erokko” yaagidi Xoossaa galatidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesuusi qassi Galiila Abbaa doona simmi bidi, baakko yida asa ubbaa tamaarssis. ");
INSERT INTO gofRNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Yaara aadhdhishe, Ilfiyoosa na7aa Leewe geetetteyssi qaraxa qanxisiya bessan uttidayssa be7idi, “Tana kaalla” yaagis. Leewey denddi eqqidi iya kaallis. ");
INSERT INTO gofRNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Yesuusi kathi maanaw Leewe son uttis. Iya kaalliya asay daro gidiya gisho qaraxa qanxisiya daro asaynne nagaranchchoti iyaranne iya tamaaretara issife uttidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Higge astamaare gidida issi issi Farisaaweti Yesuusi nagaranchchotaranne qaraxa qanxiseyssatara kathi mishin be7idi, “I ays nagaranchchotaranne qaraxa qanxiseyssatara kathi mi?” yaagidi, iya tamaareta oychchidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesuusi entti geyssa si7idi, “Hargganchchotappe attin paxatas aakime koshshenna. Taani nagaranchchota xeeganaw yasippe attin xillota xeeganaw yabiikke” yaagidi enttaw zaaris. ");
INSERT INTO gofRNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Xammaqiya Yohaannisa tamaaretinne Farisaaweti xoomosona. Issi issi asati Yesuusakko yidi, “Yohaannisa tamaaretinne Farisaaweta tamaareti xoomosona, shin ne tamaareti ays xoomokkonaa?” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesuusi enttako, “Yaaganuwa yida asati machchiw ekkeyssi enttara de7ishin, xoomanaw dandda7onnaa? Machchiw ekkeyssi enttara de7ishin, xoomanaw dandda7okkona. ");
INSERT INTO gofRNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Shin machchiw ekkeyssi entta matappe ekettana wodey yaana, entti he wode xoomana. ");
INSERT INTO gofRNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Ceega ma7o bolla ooratha wothidi sikkiya asi baawa. Wothidi sikkiko, oorathay ceega ma7uwa daakkees; daakethaykka kaseyssafe darees. ");
INSERT INTO gofRNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Qassi mal77antto woyne ceega ogoron qoliya asi baawa. Shin qolikko, he woyney ogoruwa daakkees, bawukka gukkees, ogoroykka iitees. Shin mal77antto woyney ooratha ogoron qolettees” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Yesuusi issi Sambbaata gallas bangga gade giddora aadhdhishin, iya tamaareti iyara bishe bangga tiya shirkkidi moosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Farisaaweti Yesuusakko, “Hekko, ne tamaareti Sambbaata gallas woga gidonnabaa ays oothonna?” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yesuusi enttako, “Dawitey koshattidi, miyabaa koyida wode baara de7eyssatara oothidayssa nabbabibeekketii? ");
INSERT INTO gofRNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Abiyaatari kahine halaqa gididi de7iya wode Dawitey Xoossa keethi gelidi, kahineta xalaali maanappe attin oonikka maanaw woga gidonnayssa Godaa sinthan wothida daabbuwa mis, baara de7eysstaskka immis” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Qassika Yesuusi enttako, “Sambbaati asa na7a go77as medhettisippe attin asi Sambbaatas medhettibeenna. ");
INSERT INTO gofRNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Hessa gisho, Asa Na7ay, hari attoshin Sambbaataskka Goda” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yesuusi Ayhude Woosa Keethi simmi gelis. Yan kushey gunddida issi uray de7ees. ");
INSERT INTO gofRNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Issi issi asay Yesuusa mootanaw koyidi, kushey gunddida uraa Sambbaata gallas I pathikonne aggiko be7anaw koyidi minthidi naagoosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesuusi kushey gunddida uraa, “Dendda eqqada haa sinthe ya” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Hessafe guye, asaakko, “Sambbaata gallas lo77obaa ootheyssi wogeyye iitabaa ootheyssi wogee? Asa shemppo ashoyye woykko wodho?” yaagidi oychchis. Shin asay si77i gis. ");
INSERT INTO gofRNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yesuusi hanqettidi, entta yuushshi aathi xeellidi, entti odin si7onnayssata gidiya gisho entta bolla daro azzanis. He addiyako, “Ne kushiya piddi ootha” yaagis. Uray piddi oothin iya kushey paxis. ");
INSERT INTO gofRNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ellesidi Farisaaweti Ayhude Woosa Keethafe kare keyidi, Yesuusa waati wodhanekko maqettanaw Heroodisa baggatara issi soo shiiqidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesuusi ba tamaaretara Galiila Abbaako bis. Galiilappenne Yihudappe yida daro asay iya kaallidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Qassika Yerusalaameppe, Idumiyasappe, Yorddaanose Shaafa pinthafe, Xiroosa katamaappenne Sidoona katamaappe Yesuusi oothidabaa si7idi, daro asay iyaakko yidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Asaa darotethaafe denddoyssan iya un77ethonna mela iya tamaareti wogolo iyaw giigisana mela kiittis. ");
INSERT INTO gofRNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Daro asaa I pathida gisho harggiya asa ubbay iya bochchanaw sugettoosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Tuna ayyaanay oykkida asati iya be7ida wode iya sinthan kunddidi, bantta qaala dhoqqu oothidi, “Neeni Xoossaa Na7aa gidikkii?” yaagosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Yesuusi he tuna ayyaanati banatethaa ooddeskka Qonccisonna mela entta minthidi hanqettis. ");
INSERT INTO gofRNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesuusi deriya bolla keyidi, ba koyida asata baakko xeegis; enttika iyaakko bidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Entti baara daana melanne qaala tamaarssana mela tammanne nam77ata dooridi, entta, “Hawaareta” gidi sunthis. ");
INSERT INTO gofRNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Tuna ayyaanatakka kessana mela enttaw maata immis. ");
INSERT INTO gofRNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","I doorida tammanne nam77ati hayssata: Phexiroosa yaagidi sunthida Simoona, ");
INSERT INTO gofRNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Bo7anergges (Dada daaniya asata) yaagidi sunthidayssata, Zabdiyoosa nayta Yayqoobanne Yayqooba ishaa Yohaannisa, ");
INSERT INTO gofRNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Inddiriyasa, Filphoosa, Bartolomiyoosa, Maatoosa, Toomasa, Ilfiyoosa na7a Yayqooba, Taadiyosa, ba biittaas mishettiya Simoonanne, ");
INSERT INTO gofRNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Yesuusa aathi immida Asqoroota Yihuda. ");
INSERT INTO gofRNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Hessafe guye, Yesuusi soo bis. Qassi daro asay shiiqin, inne iya tamaareti hari attoshin kathi maanawukka dandda7ibookkona. ");
INSERT INTO gofRNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Asay iya, “Gooyees” giya gisho iya dabboti hessa si7idi iya ekkanaw bidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Higge asttamaaretappe issoti issoti Yerusalaameppe yidi, “Iya bolla Bi7elzebuuli de7ees”, I, “Xalahey wolqqan tuna ayyaanata kessees” yaagidi odettidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yesuusi asaa baakko xeegidi leemiso odis. “Xalahey Xalahe waati kessanaw dandda7ii? ");
INSERT INTO gofRNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Issi kawotethay ba giddon shaakettiko he kawotethay eqqanaw dandda7enna. ");
INSERT INTO gofRNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Hessadakka, issi keetha asay bantta giddon shaakettiko dhayanaappe attin daanaw dandda7okkona. ");
INSERT INTO gofRNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Hiza, Xalahey baara kacettidi shaakettiko dhayoppe attin daanaw dandda7enna. ");
INSERT INTO gofRNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Shin koyrottidi wolqqaama uraa qachchonna de7ishe iya keetha gelidi, iya miishiya bonqanaw dandda7iya asi baawa. Qachchi simmidi iya keetha bonqanaw dandda7ees. ");
INSERT INTO gofRNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Taani hinttew tuma odays; Xoossay asa naytas nagara ubbaanne entti cayaa cashshe ubbaa atto gaana. ");
INSERT INTO gofRNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Shin Geeshsha Ayyaana bolla iitabaa odettiya ooddeskka merinaa nagara gidanaappe attin Xoossay ubbarakka iya maarenna” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesuusi hessa giday, issi issi asati, “Iya bolla tuna ayyaanay de7ees” yaagida gishossa. ");
INSERT INTO gofRNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Iya aayyaanne iya ishati yidi karen eqqidi, iyaakko ase kiittidi iya xeegidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Iya matan uttida daro asati, “Hekko, ne aayeranne ne ishatara karen eqqidi nena koyoosona” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yesuusi zaaridi, “Ta aayyaa oonee? Qassi ta ishati oonantee?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ba matan uttida asa yuushshi aathi xeellidi, “Hekko, ta aayyaaanne ta ishati hayssata. ");
INSERT INTO gofRNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Xoossay sheniya oothiya ubbay ta isha, ta michchonne ta aayo” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesuusi zaaridi Galiila Abbaa matan tamaarssees. Daro asay iya yuushuwan shiiqin, abban de7iya wogoluwa giddo gelidi uttis, asa ubbay Abbaa matan de7ees. ");
INSERT INTO gofRNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","I entta darobaa leemison tamaarssis. Tamaarssishe hayssada yaagis: ");
INSERT INTO gofRNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Si7ite! Issi uray zerethi zeranaw keyis. ");
INSERT INTO gofRNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","I zerishin, issi issi zerethay oge gaxan wodhdhis; kafoti yidi midosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Issi issi zerethay garssan shaalloy de7iya biitta bolla wodhdhis. Daro biitti baynna gisho he zerethay ellesidi dolis. ");
INSERT INTO gofRNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Shin awi keyida wode shullis. Loythidi xapho yeddiboonna gisho ellesi melis. ");
INSERT INTO gofRNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Issi issi zerethay aguntha giddon wodhdhis. Dolidayssa agunthay diccidi cuullida gisho ayfe ayfonna attis. ");
INSERT INTO gofRNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Issi issi zerethay aradda biittan wodhdhidi dolis. Diccidi issoy hasttama, issoy usuppun tamma issoy xeeta ayfis” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","“Si7iya haythi de7iya oonikka si7o” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Yesuusi odidayssa si7ida issi issi asatinne tammanne nam77u tamaareti Yesuusi barkka de7ishin, iyaakko shiiqidi he leemisuwa birshshethaa oychchidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Yesuusi enttako hayssada yaagis: “Hinttew Xoossaa kawotethaa xuuraa eroy imettis. Shin haratas kawotethaafe karen de7eyssatas ubbabay leemison odettees. ");
INSERT INTO gofRNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Gaasoykka, ‘Entti xeellosona, shin demmokona. Si7oosona, shin akeekokkona. Entti demmiyakkonne akeekiyakko, Xoossaakko simmana ikka entta maaranashin’ ” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yesuusi enttako, “Ha leemisoy hinttew gelennee? Yaatin, leemiso ubbaa hintte waati akeekanee? ");
INSERT INTO gofRNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Zereyssi Xoossaa qaala zerees. ");
INSERT INTO gofRNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Qaalay zerettiya wode oge gaxan wodhdhidayssati qaala si7idayssata. Shin Xalahey sohuwara yidi, entta wozanan zerettida qaala maxi digees. ");
INSERT INTO gofRNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Hessadakka, garssan shaalloy de7iya biittan zerettidayssi qaala si7idi, ellesidi ufayssan ekkeyssa. ");
INSERT INTO gofRNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Shin enttaw mino xaphoy baynna gisho ha77issafe attin gam77okona. Guutha wodeppe guye qaala gaason waayey woykko goodi gakkiya wode ellesidi dhubettoosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Aguntha giddon zerettidayssi qaala si7eyssata. ");
INSERT INTO gofRNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Shin ha sa7a de7uwas hirggoy, duretethaa dosoynne harabaa amotteyssi iya wozanan gelidi qaala cuulliya gisho ayfe ayfonna attis. ");
INSERT INTO gofRNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Shin aradda biittan zerettidayssati qaala si7idi ekkeyssata. Entti issoy hasttama, issoy usuppun tamma issoy xeeta ayfis” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesuusi gujjidi, “Xomppe ekkidi, daachchofe woykko alggafe garssan wothiya asi de7ii? Dhoqqa bessan wotheneyye? ");
INSERT INTO gofRNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Hiza, qosettidabay ubbay qoncce keyana; geemmidabay ubbay erettonna attenna. ");
INSERT INTO gofRNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Si7iya haythi de7iya oonikka si7o” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Qassi enttako, “Hintte si7iyabaa akeekidi si7ite! Xoossaa qaala hintte si7eyssa mela I hinttew akeeka immana. Ubbaka hinttew darssidi immana. ");
INSERT INTO gofRNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Issibay de7iya uraas gujji imettana, baynnaysafe hari attoshin, iyaw de7iya he guuthiyaka ekettana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesuusi zaaridi, “Xoossaa kawotethay ba gaden zerethi zeriya asa mela. ");
INSERT INTO gofRNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","He uray qamma dhiskkees; wontta denddees. I ba huu7en waaniyakko eronna de7ishin he zerethay doleesinne diccees. ");
INSERT INTO gofRNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Biittay kathi barkka immees. Koyro dolidi diccees, kaallidi ayfanaw gambbuxees, wurssethan kumetha ayfe ayfees. ");
INSERT INTO gofRNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Shin kathay gakkiya wode uray sohuwara baacara geli aggees” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesuusi, “Nuuni Xoossaa kawotethaa ay daanees gaanee? Woykko aybira leemisanee? ");
INSERT INTO gofRNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Xoossaa kawotethay ayfe guutha mithi daanees. He mithaa ayfiyaa zeriya wode sa7an de7iya mitha ayfe ubbaafe guuxees. ");
INSERT INTO gofRNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Zerin dolidi atakiltte ubbaafe gitatees; daro daashshi daayees. Kafoti iya tashiya bolla keexidi uttana gakkanaw dayees” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesuusi hayssa mela daro leemison asay akeekanaw dandda7eyssa mela qaala odis. ");
INSERT INTO gofRNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Asaas leemisoy baynna odenna. Shin Yesuusi ba tamaareta xalaalara de7iya wode enttaw ubbabaa birshshidi odis. ");
INSERT INTO gofRNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","He gallas sa7ay omarssin, Yesuusi ba tamaaretakko, “Abbaafe hefinthi pinnoos” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Iya tamaareti daro asa yeggi aggidi, Yesuusi kase geli uttida wogoluwan gelidi Yesuusa banttara efidosona. Hara wogolotikka yan de7oosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Wolqqaama gotey denddidi, hobbey wogoluwa shocin, kumana gakkanaw wogoluwa giddo haathi gelis. ");
INSERT INTO gofRNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","He wode Yesuusi wogoluwan guye baggara borkkottidi dhiskkis. Iya tamaareti iya denthidi, “Asttamaariyaw, nuuni dhayaa wode ne si77i gada xeellay?” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yaatin, I barkkidi gotiya, “Si7i ga” gidi, abbaaka, “Woppu ga” gis. Goteykka si77i gin ubbabay woppu gis. ");
INSERT INTO gofRNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Yesuusi ba tamaaretakko, “Ays hayssada babbetii? Hinttew ammanoy waanidi dhayide?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Entti daro babbidi bantta giddon, “Hayssi hari attoshin, goteynne abbay kiitetteyssi oonee?” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yesuusinne iya tamaareti abbaa pinnidi, Gerggesoone giya biittaa gakkidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yesuusi wogoluwappe wodhdhiya wode tuna ayyaanay oykkida issi uray duufoppe keyidi iyara gahettis. ");
INSERT INTO gofRNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","He uray duufuwan aqi pee7idi de7ees. Iya oonikka santhalaatan qachchanaw dandda7enna. ");
INSERT INTO gofRNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","I daro toho duthaninne santhalaatan qashettidi de7ees. Shin santhalaata duuserethees, duthaa mentherethees. Iya teqqanaw dandda7iya oonikka baawa. ");
INSERT INTO gofRNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","I qammanne gallas he duufuwaninne dere bolla waasses, ba bollaaka shuchchan gaarees. ");
INSERT INTO gofRNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Yesuusa haahon be7ida wode woxxi bidi iya sinthan gulbbatis. ");
INSERT INTO gofRNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","He uray ba qaala dhoqqu oothidi, “Ubbaafe Bolla Xoossaa Na7aw Yesuusa, nenanne tana aybe gathey? Tana dhayssona mela taani nena Xoossaa sunthan woossays” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","I hessa giday Yesuusi iya, “La ha tuna ayyaanaw, ha addiyafe keya” yaagida gishossa. ");
INSERT INTO gofRNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Yesuusi iyaakko, “Ne sunthay oonee?” yaagidi oychchis. I, “Nuuni daro gidiya gisho ta sunthay Leegiyona” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Tuna ayyaanati bantana he biittaafe kessi yeddonna mela Yesuusa minthidi woossidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","He deriya bolla daro guduntho wudey hamuttees. ");
INSERT INTO gofRNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Tuna ayyaanati Yesuusakko, “Nuna hini guduntho wudiyakko yeddarkki, enttan bidi geloos” yaagidi woossidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yesuusi enttako, “Biite” yaagis. Yaatin tuna ayyaanati addiyafe keyidi gudunthotan gelidosona. Nam77u mukulu gidiya guduntho wudey aafo doonara dirggidi bidi abban gelidi mitettidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Guduntho wudiya heemmeyssati baqati bidi hanidabaa katamaaninne gaxariyan odidosona. Yaatin asay hanidabaa be7anaw keyidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Asay Yesuusakko yaa wode tuna ayyaanan oykettida uraa be7idosona. I ba wozanaakko simmidi, ma7o ma77idi, yan uttidayssa be7ida wode ubbay yayyidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Hessa be7ida asati tuna ayyaanati oykkida uraa bollanne gudunthota bolla hanidabaa ubbaa asaas odidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Hessa gisho, asay bantta biittaafe Yesuusi baana mela woossidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yesuusi wogoluwan geliya wode kase tuna ayyaanay oykkidi yeddida uray, Yesuusa kaallanaw iya woossis. ");
INSERT INTO gofRNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Shin Yesuusi ixxidi iyaakko, “Ne soo simmada, Goday new ay mela gitabaa oothidakkonne new ay mela keehidakko ne soo asaas oda” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Uray bidi Tammu Katamaa giyason yuuyidi, Yesuusi baw ay mela gitabaa oothidaakko odis. I odidayssa si7ida asa ubbay malaalettidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesuusi simmidi, wogoluwan gelidi, abbaa pinnidaappe guye daro asay abbaa gaxan iya yuushuwan shiiqidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Iyaroosa giya Ayhude Woosa Keetha halaqatappe issoy, Yesuusa be7ida wode iyaakko yidi iya tohuwa bolla ");
INSERT INTO gofRNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","kunddidi, “Ta na7iya harggada hayqqana hanawsu. Iya paxada de7ana mela yada ne kushiya I bolla wotharkkii” yaagidi Yesuusa minthidi woossis. ");
INSERT INTO gofRNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yesuusi Iyaroosara bis. I bishin daro asay iya kaallidi un77ethidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Tammanne nam77u laythi I bollaafe suuthi goggiya issi maccasiya de7awusu. ");
INSERT INTO gofRNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Daro aakimeti iyo aakimidosona, shin iya paxa kaa7ettasu. Iya ba miishiya ubbaa wurssinkka iw haa iitisppe attin aykkoka maaddibeenna. ");
INSERT INTO gofRNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","He maccasiya Yesuusabaa si7ada, asaa kanthada Yesuusa guyera yada iya ma7uwa bochchasu. ");
INSERT INTO gofRNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Iya, “Taani hari attoshin iya ma7uwa bochchiyakko paxana” gada qoppasu. ");
INSERT INTO gofRNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Iippe goggiya suuthay sohuwara eqi aggis. Iya ba waayappe paxidayssa ba asatethan erasu. ");
INSERT INTO gofRNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yesuusi baappe wolqqi keyidayssa ba huu7en eridi, ellesidi daro asa giddon guye simmidi, “Ta ma7uwa bochchiday oonee?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Iya tamaareti, “Asay nena sugeyssa be7ashe, ‘Woygada tana oone bochchiday yaagay?’ ” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Yesuusi hessa ooni oothidaakko be7anaw yuushshi aathi xeellis. ");
INSERT INTO gofRNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Shin maccasiya baw hanidabaa erada, yashshan kokkorashe yada Yesuusa sinthan gufannasu; qassi hanidabaa ubbaa tumaa iyaw odasu. ");
INSERT INTO gofRNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yaanin, Yesuusi iikko, “Ta naatte, nena ne ammanoy pathis, saron ba, ne waayappeka paxa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesuusi buroo hessa odishin, Ayhude Woosa Keetha halaqaa sooppe kiitettida asati yidi, “Ne na7iya hayqqasu, asttamaariya ays daaburissay?” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Shin Yesuusi entti geyssa si7idi, Ayhude Woosa Keetha halaqaakko, “Ammano xalaala ammanappe attin babbofa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yesuusi Phexiroosappe, Yayqoobappenne Yayqooba ishaa Yohaannisappe hari oonikka bana kaallonna mela diggis. ");
INSERT INTO gofRNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Entti Ayhude Woosa Keetha halaqaa soo gakkiya wode Yesuusi asay kaha dhayidi yeekkeyssanne zeeleleyssa be7is. ");
INSERT INTO gofRNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Gelidi asaakko, “Ays kaha dhayidi yeekketii? Na7iya dhiskkasuppe attin hayqqabuukku” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Asay iya bolla miiccis. Shin asa ubbaa kare kessidi, na7ee aawa, aayyiwunne heedzu tamaareta baara ekkidi na7iya de7iyasuwa gelis. ");
INSERT INTO gofRNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Yesuusi na7ee kushiya oykkidi, “Xaalita, quumi” (Guutha naatte, nena gays dendda) yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Na7iya sohuwara dendda eqqada hamuttasu. Iya tammanne nam77u laytha na7a. Hessan asay daro malaalettidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yesuusi hessa entti ooddeskka odonna mela entta minthi kiittis. Entti iw miyabaa immana mela odis. ");
INSERT INTO gofRNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesuusi yaappe keyidi, ba tamaareta kaalethidi, ba katama Naazirete bis. ");
INSERT INTO gofRNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sambbaata gallas Ayhude Woosa Keethan tamaarsso oykkis. I tamaarsseyssa si7ida daro asay malaalettidi, “Hayssi ha ubbaa awuppe demmide? Ha cinccatethaa I awuppe ekkidee? Ha malaatata oothiya maata I awuppe demmide? ");
INSERT INTO gofRNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Hayssi anaaxiya gidennee? Mayraami na7a, Yayqooba, Yoosa, Yihudanne Simoona ishaa gidenneyye? Iya michcheti nuura hayssan de7okkonayye?” yaagidi, I giyabaa ekkonna ixxidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yesuusi he asaakko, “Nabey ba biittan, ba dabbotaninne ba soo asan bonchchettennafe attin harata matan bonchchettees” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","I he bessan ba kushiya guutha asaa bolla wothidi pathidayssafe attin hara malaatata oothanaw dandda7ibeenna. ");
INSERT INTO gofRNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Asay ammaniboonna gisho daro malaalettis. Hessafe guye, Yesuusi he heeran de7iya gutatan asaa tamaarssees. ");
INSERT INTO gofRNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Yesuusi tammanne nam77u tamaareta baakko xeegidi, nam77aa nam77aa gathidi kiittis. Enttaw tuna ayyaanata kessiya wolqqaa immis. ");
INSERT INTO gofRNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Entta, “Oge xam77afe attin kathi, karxiita, hintte kiisen miishe aybibaakka oykkofite. ");
INSERT INTO gofRNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Hintte tohuwan caamma aathite, shin nam77u afila oykkofite” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Qassika, “Hinttena asi mokkida soo awunkka gidin he bessaa yeddidi baana gakkanaw he keethan gam77ite. ");
INSERT INTO gofRNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Hinttena asi mokkonnasuwa woykko hintte odiyabaa si7onnasuwa awun gidikkoka, he biittan de7iya asaas hessi naagiso markka gidana mela he bessaafe keyishe, hintte tohuwappe baana pittite” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Tammanne nam77u tamaareti bidi, asay bantta nagaraappe simmanaada qaala odidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Entti asappe daro tuna Ayyaanata kessidosona. Daro hargganchchota zayte tiyidi pathidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Yesuusa sunthay ubba bessan keyida gisho Kawoy Heroodisi iyabaa si7is. Issi issi asay, “Xammaqiya Yohaannisi hayqoppe denddis, hessa gisho ha malaatata oothey iya” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Baggati, “Hayssi Eliyaasa gidennee?” yaagidosona. Harati qassi, “Hayssi beni wode nabetapp issuwa gidonna aggenna” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Shin Heroodisi hessa si7ida wode “Hayssi taani qoodhiya qanxisida Xammaqiya Yohaannisa gidennee? I hayqoppe denddis” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Heroodisi ba ishaa Filphoosa machchiw Heroodiyada ekkida gisho I gaason Yohaannisa oythidi qashisis. ");
INSERT INTO gofRNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Yohaannisi Heroodisa, “Neeni ne ishaa machchiw ekkanaw bessenna” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Heroodiyada Yohaannisa ba ulon morkkada iya wodhisanaw koyasu, shin dandda7abukku. ");
INSERT INTO gofRNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Yohaannisi xillonne geeshsha asi gididayssa Heroodisi erida gisho iyaw babbidi loythi naagisees. Heroodisi Yohaannisi giyabaa si7anaw dosikkoka I giyabaa si7iya wode daro dagammees. ");
INSERT INTO gofRNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Heroodisi ba yelettida gallasa bonchchanaw deriya haareyssatas, shaalaqatasinne Galiilan de7iya gita asaas imato giigisis. Hessi Heroodiyadas injje gallas gidis. ");
INSERT INTO gofRNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Heroodiyada na7iya imathay mokettiya bessaa gela durada, Heroodisanne iya imathata ufayssasu. Kawoy na7iw, “Ne koyabaa aybaa gidikkoka tana oychcha, taani new immana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Qassi iw caaqqidi, “Neeni oychchiyabaa aybaa gidikkoka, taani new immana. Hari attoshin, ta kawotethaa baggaa gidikkoka taani new immana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Na7iya kare keyada ba aayeekko, “Ay imma go?” gada oychchasu. I aayyaa, “Xammaqiya Yohaannisa huu7iya imma ga” yaagasu. ");
INSERT INTO gofRNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Na7iya ellasada kawuwakko bada, “Xammaqiya Yohaannisa huu7iya saanen wothada ha77i taw immana mela koyays” yaagasu. ");
INSERT INTO gofRNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Yaanin Kawoy daro qiirottis, shin ba imathata gisho iw caaqqida ba caaquwa menthanaw koyibeenna. ");
INSERT INTO gofRNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Hessa gisho, ellesidi naageyssa Yohaannisa huu7iya ehana mela kiittis. Naageyssi qasho keethi bidi Yohaannisa qoodhiya qanxis. ");
INSERT INTO gofRNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","He qanxettida huu7iya saanen wothi ehidi na7ees immis. Na7iya qassi ba aayes immasu. ");
INSERT INTO gofRNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Yohaannisa tamaareti hessa si7ida wode bidi iya ahaa ekki efidi moogidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Tammanne nam77u hawaareti simmi yidi entti oothidabaanne tamaarssidabaa ubbaa Yesuusas odidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Enttako yaa asaynne biya asay darida gisho Yesuusaranne iya tamaaretara, hari attoshin kathi maanawukka entta gathonna ixxis. Yaanin, Yesuusi enttako, “Nurkka guuthi shemppi ekkanaw asi baynna bessi yedhdhite” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Hessa gisho, entti banttarkka wogolon gelidi asi baynna bessi bidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Entti bishin daro asay entta be7idi eridosona. Yaatin, katama ubbaafe asay tohora woxxi bidi entti biyasuwa enttafe sinthe gakkidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yesuusi wogoluwappe wodhdhidi daro asaa be7is. Asay heemmiya asi baynna dorssa mela gididayssa be7idi enttaw qadhettidi entta darobaa tamaarssis. ");
INSERT INTO gofRNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Sa7ay omarssiya wode Yesuusa tamaareti iyaakko yidi, “Hayssi bessay asi baynna bessi; ha77i sa7aykka qammis. ");
INSERT INTO gofRNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Asay gutatanne katamata bidi banttaw miyabaa shammana mela asa yedda” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Shin Yesuusi zaaridi enttako, “Asaas miyabaa hintte immite” yaagis. Entti, “Nuuni bidi nam77u xeetu dinaaren uythu shammidi asaa muzana mela koyay?” yaagidi oychchidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yesuusi enttako, “Hinttew aappun uythi de7ii? Ane bidi be7ite” yaagis. Entti be7idi, “Ichchashu uythunne nam77u molo” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Yesuusi ba tamaareta asa ubbaa cugan cugan shaakkidi maatan utisana mela kiittis. ");
INSERT INTO gofRNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Asay baggay xeeta, baggay ishatama gididi cugan cugan shaakettidi uttidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Yesuusi ichchashu uythaanne nam77u molota ekkidi, pude salo xeellidi Xoossaa galatis. Uythaa menthidi asaas gishana mela ba tamaaretas immis. Qassi nam77u molota entta ubbaas shaakkis. ");
INSERT INTO gofRNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Asa ubbay midi kallidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Attida uytha tiifiyanne molota tiifiya, iya tamaareti tammanne nam77u gayta kumethi denthidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Uythaa mida adde asaa tayboy ichchashu mukulu. ");
INSERT INTO gofRNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ellesidi Yesuusi ba tamaareti wogoluwan gelidi, abbaafe hefinthan de7iya Beetesayda baappe sinthattidi baana mela kiittis. Shin baw asaa moyzanaw guye attis. ");
INSERT INTO gofRNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Asaa moyzidaappe guye Xoossaa woossanaw deriya bolla keyis. ");
INSERT INTO gofRNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Sa7ay qammiya wode wogoloy abbaa giddon de7ees, shin Yesuusi abbaafe gaxan barkka de7ees. ");
INSERT INTO gofRNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Carkkoy iya tamaaretakko carkkiya gisho abbaa pidhoy waayseyssa Yesuusi be7is. Wonttimaathe sa7ay geeyana haniya wode I abbaa bolla hamuttishe enttako yidi, entta yeggidi aadhdhanaw koyis. ");
INSERT INTO gofRNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Shin I abbaa bolla hamuttishin, entti be7idi, enttaw moytille daanin waassidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Entti ubbay iya be7idi, yashshan kokkoridosona. Shin Yesuusi ellesidi enttako, “Tana, aykkoy baawa; yayyofite” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Yesuusi wogoluwan gelidi enttara issife uttin carkkoy woppu gis. Entti daro malaalettidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Entta wozanay zel77umida gisho entti uythabaa akeekibookkona. ");
INSERT INTO gofRNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Entti abbaa pinnidi, Gensareexe biittaa gakkidi, wogoluwa gaxa shiishidi qachchidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Entti wogoluwappe wodhdhiya wode asay ellesidi Yesuusa eridosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Entti heeran de7iya biitta ubban woxerettidi hargganchchota halan tookkidi, “Yesuusi de7ees” gin si7ida bessaa ehidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Asay I bida soo ubban, gaxariyan gidin, kataman, de7iya hargganchchota dabaaba efoosona. Hargganchchoti iya afilaa macaraa gidikkoka bochchana mela asay iya woossidosona. Bochchida ubbay paxis. ");
INSERT INTO gofRNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Yerusalaameppe yida guutha Farisaawetinne higge asttamaareti Yesuusa matan shiiqidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Yesuusa tamaaretappe issoti issoti geeyonna kushiyan, hessika kushe meecettonna kathi meyssata be7idosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Farisaawetinne Ayhude asa ubbay bantta aawata wogaatho bantta kushiya meecettonna mokkonna. ");
INSERT INTO gofRNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Hessadakka, entti giyappe shamettidabaa meecconna de7ishe mokkonna. Qassi entti bantta aawatappe ekkida hara daro wogi de7ees: Hessika siniya, keriya, biraata miishetanne arssaa meecciya wogaa naageyssa. ");
INSERT INTO gofRNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Farisaawetinne higge asttamaareti Yesuusa, “Ne tamaareti ays aawata wogaa menthidi bantta kushiya meecettonna kathi moonna?” yaagidi oychchidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesuusi enttako, “Isayaasi hinttena cubbota, ‘Hayssi asay tana ba inxarssa xalaalan bonchchees, shin entta wozanay taappe haahon de7ees. ");
INSERT INTO gofRNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Asi medhdhida wogaa Xoossaa higge daanisidi tamaarssiya gisho entti tana mela goynnosona’ ” gidi xaafidayssi tuma. ");
INSERT INTO gofRNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Hintte Xoossaa kiitaa aggidi asa wogaa minthidi naageeta” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Qassika Yesuusi, “Hinttee hintte wogaa naagidi Xoossaa kiitaa yeggi agganaw lo77o oge demmideta. ");
INSERT INTO gofRNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Musey, ‘Ne aawanne ne aayiw bonchcha’, qassi ‘Ba aawanne ba aayiw cayeyssi hayqqanaw bessees’ yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Shin issi asi ba aawa woykko ba aayiw maaddanayssa aggidi, ‘Hessi Xoossaa yarshsho’ giikko, ");
INSERT INTO gofRNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","I ba aawa woykko ba aayiw maaddonna mela ootheeta. ");
INSERT INTO gofRNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Hessadakka, hintte harata tamaarssida hintte wogan Xoossaa qaala kadhideta. Hessa mela hara darobaa ootheeta” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesuusi daro asaa qassika baakko xeegidi, “Ubbay taani odeyssa si7itenne akeekite. ");
INSERT INTO gofRNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Asa wozanappe keyaabay ase tuniseesippe attin kareppe asa ulo gelidi ase tunisiyabay aybikka baawa. ");
INSERT INTO gofRNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Si7iya haythi de7iya oonikka si7o” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Yesuusi daro asaa yeggi aggidi soo gelin iya tamaareti he leemisuwabaa iya oychchidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","I enttako, “Hinttewuka qassi gelibeennee? Kareppe asa wozanan geliyabay aybikka ase tunisanaw dandda7onnayssa akeeketii? ");
INSERT INTO gofRNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ays giikko, kathi asa ulo giddo gelidi kanthidi aadhdheesippe attin asa wozana giddo gelenna” yaagis. Hessan Yesuusi kathi ubbay geeshshi gideyssa erisis. ");
INSERT INTO gofRNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Kaallidikka, Yesuusi, “Asa tunisiyabay asa wozana giddofe keyaabaa. ");
INSERT INTO gofRNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Asa wozana giddofe keyaabay iita qofa, laymatethi, kayso, ase wodho, laame, ");
INSERT INTO gofRNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","iita amo, iitatethi, gene, qayxe, cimo, qanaate, cashshe, otoronne boozatethi. ");
INSERT INTO gofRNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ha iitabay ubbayka asa wozana giddofe keyidi ase tunisees” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesuusi yaappe keyidi, Xiroosa katama matan de7iya biittaa bis. I issi keethi gelidi yan de7eyssa oonikka erana mela koyibeenna. Shin qosettidi gam77anaw dandda7ibeenna. ");
INSERT INTO gofRNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Shin I guutha na7iw tuna ayyaanay oykkida issi maccasiya Yesuusabaa si7ada ellesa iyaakko yada iya tohuwa bolla kunddasu. ");
INSERT INTO gofRNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Iya Ayhude maccasi gidukku; iya yelettiday Siroofinqe giya biittana. Iya, ba na7eeppe tuna ayyaanaa kessana mela Yesuusa woossasu. ");
INSERT INTO gofRNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Shin Yesuusi zaaridi, “Nayti koyrottidi kathaa kallo; nayta kathaa ekkidi kanatas yeggeyssi lo77o gidenna” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Maccasiya zaarada, “Ta Godaw hessi tuma, shin gaytaa matan de7iya kanati naytappe wodhdhiya tiifiya moosona” yaagasu. ");
INSERT INTO gofRNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yesuusi qassi iikko, “Ha ne qaala gisho ne soo ba; tuna ayyaanay ne na7eeppe keys” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Maccasiya ba soo biya wode tuna ayyaanay iippe keyin hiixan zin77idaaro demmasu. ");
INSERT INTO gofRNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesuusi Xiroosa katamaappe keyidi, Sidoonaranne Tammu Katamata giya biittaara kanthidi Galiila Abbaako bis. ");
INSERT INTO gofRNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Asay tullenne waayidi odettiya asi Yesuusakko ehidi, ba kushiya iya bolla wothana mela iya woossidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yesuusi barkka he uraa daro asappe gaxa kessidi, ba biradhdhiya iya haythan yeddis. Qassi cuchchi cuttidi iya inxarssaa bochchis. ");
INSERT INTO gofRNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Salo pude xeellidi, tooki shemppidi, “Eftah” gis. Birshshethaykka “Dooyetta” guussu. ");
INSERT INTO gofRNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Uraa haythay ellesidi dooyettis, qashettida inxarssaykka birshshettis, uray geeshshidi odettis. ");
INSERT INTO gofRNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yesuusi asaakko, “Hayssa ooddeskka odoppite” yaagis. Shin I daro minthidi odoppite gin, asay odaa yaa darssis. ");
INSERT INTO gofRNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Hessa si7ida asa ubbay daro malaalettidi, “Ubbabaa I loythi oothees. Hari attoshin, tulliya sissees, muumiya odisees” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Guutha wodeppe guye, daro asay Yesuusakko shiiqidosona. Asaas miyabay dhayin Yesuusi ba tamaareta baakko xeegidi, ");
INSERT INTO gofRNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ha asay taara heedzu gallas gakkanaw gam77idi, aykkoka miyabaa demmiboonna gisho tana asay qadhethees. ");
INSERT INTO gofRNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Taani asaa koshara soo yeddiko asay bishe ogen daaburidi kunddana, bagga asay haahosoppe yidosona” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Yesuusa tamaareti zaaridi, “Ha bazzo biittan ha asa ubbaa muzanaw gidiya kathi demmanaw dandda7ey oonee?” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yesuusi enttako, “Hinttew aappun uythi de7ii?” yaagidi oychchis. Entti zaaridi, “Laappun uythi de7ees” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Yesuusi asay sa7an uttana mela kiittis. Yaatidi, laappun uythaa ekkidi Xoossaa galati simmidi he uythaa menthidi, asaas gishana mela ba tamaaretas immis. Iya tamaareti asaas gishidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Enttaw qassi guutha laafa moloti de7oosona. Yesuusi he molota gisho Xoossaa galatidi, asaas gishana mela ba tamaareta kiittis. ");
INSERT INTO gofRNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Asay ubbay midi kallidosona. Iya tamaareti attida tiifiya laappun gayta kumethi denthidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Kathaa mida asaa tayboy oyddu mukulu gidana. Hessafe guye, Yesuusi asa yeddis. ");
INSERT INTO gofRNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","I qassi ba tamaaretara ellesi wogolon gelidi Dalmmanuuta giya biittaa bis. ");
INSERT INTO gofRNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Farisaaweti yidi Yesuusa paaccanaw koyidi, saloppe banttana malaata bessana mela Yesuusara palama oykkidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yesuusi tookki shemppidi, “Ha wodiya asay ays malaata koyii? Taani hinttew tuma odays; ha wodiya asaas ay malaatikka imettenna” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","I entta yan yeggi aggidi zaari wogolon gelidi abbaafe hefinthi pinnis. ");
INSERT INTO gofRNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Iya tamaareti kathi efanayssa dogidosona; enttaw wogoluwa giddon issi uythaafe hari baawa. ");
INSERT INTO gofRNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesuusi enttako, “Hinttena erite. Farisaaweta irshshuwaafenne Heroodisa irshshuwaafe naagettite” yaagidi kiittis. ");
INSERT INTO gofRNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Entti bantta giddon, “I hayssa gey nuus uythi baynna gishossa” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesuusi entti geyssa eridi enttako, “Hinttew uythi baynna gisho ays odetteetii? Ha77ika erekketii? Woykko akeekekketii? Hintte wozanay doccidee? ");
INSERT INTO gofRNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Hinttew ayfey de7ishin be7ekketi? Haythi de7ishin si7ekketii? Hintte akeeketii? ");
INSERT INTO gofRNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Taani ichchashu uythaa ichchashu mukulu asaas bathida wode aappun gayta kumethi tiife denthidetii?” yaagis. Enttika, “Tammanne nam77u gayta kumethi” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Hessadakka, taani laappun uythaa oyddu mukulu asaas bathida wode aappun gayta kumetha tiife denthidetii?” yaagis. Entti, “Laappun gayta kumethi denthida” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Yaatin, “Ha77ika akeekibeekketii?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Entti Beetesayda katamaa bidosona. Guutha asati qooqe uraa Yesuusakko ehidi he uraa bochchana mela iya woossidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesuusi qooqe uraa kushiya oykkidi katamaappe gaxa kessis. Iya ayfiyaan cuttidi ba kushiya iya bolla wothidi, “New aykkoy bentii?” yaagidi oychchis. ");
INSERT INTO gofRNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Uray dhoqqu gidi xeellidi, “Taw asay benttees, shin asay hamuttishe mithi daanees” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Hessafe guye, Yesuusi zaaridi, uraa ayfiyaan ba kushiya wothis. Uray loythi xeellis, iya ayfey paxis, ubbabaa geeshshidi be7is. ");
INSERT INTO gofRNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yesuusi addiyako, “Ne soo ba, shin gutaa geloppa” yaagidi kiittis. ");
INSERT INTO gofRNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesuusi ba tamaaretara Qisaariya Filphoosa matan de7iya gutaa bis. Entti bishin oge bolla Yesuusi, “Tana asay oona goonaa?” yaagidi ba tamaareta oychchis. ");
INSERT INTO gofRNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Iya tamaareti, “Issi issi asay nena, ‘Xammaqiya Yohaannisa’ goosona; harati, ‘Eliyaasa goosona’ qassi harati, ‘Nabetappe issuwa’ goosona” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Yesuusi enttako, “Yaatin hintte tana oona geeti?” yaagidi oychchis. Phexiroosi, “Neeni Kiristtoosa” yaagidi zaaris. ");
INSERT INTO gofRNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yesuusi, “Tabaa ooddeskka odoppite” yaagidi entta kiittis. ");
INSERT INTO gofRNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Yesuusi ba tamaaretakko, “Asa Na7ay, daro meto ekkanaw bessees; cimati, kahine halaqatinne higge asttamaareti iya ixxanaw bessees. Entti iya wodhanawunne heedzu gallasappe guye, I hayqoppe denddanaw bessees” yaagidi entta tamaarssis. ");
INSERT INTO gofRNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","I hessa enttaw geeshshidi odis. Phexiroosi iya issi bagga zaaridi hanqqis. ");
INSERT INTO gofRNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Shin Yesuusi guye simmidi, ba tamaareta xeellidi, Phexiroosa hanqettidi, “Ha Xalahiyaw, taappe haakka. Neeni asi dosiyabaa qoppasappe attin Xoossay dosiyabaa qoppaka” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Qassika Yesuusi daro asaanne ba tamaareta baakko xeegidi, “Tana kaallanaw koyaa oonikka bana kaddo; ba masqaliya tookkidi tana kaalo. ");
INSERT INTO gofRNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ba shemppuwa ashshanaw koyaa uray dhayssana. Shin ta gishonne Wonggelaa gisho ba shemppuwa dhayssiya uray ashshana. ");
INSERT INTO gofRNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Issi asi sa7an de7iya ubbabaa baw shiishidi, ba shemppuwa dhayssikko iya ay maaddanee? ");
INSERT INTO gofRNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Issi asi ba shemppuwa wozanaw ay immanaw dandda7ii? ");
INSERT INTO gofRNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Xoossaa ammanonna ha iita yeletethan, issi asi tananinne ta qaalan yeellatikko, Asa Na7ay, qassi ba Aawa bonchchon geeshsha kiitanchchotara yaa wode iyan yeellatana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesuusi enttako, “Taani hinttew tuma odays; Xoossaa kawotethay wolqqara yeyssa be7onna hayqqonna issi issi asati hayssan de7oosona” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Yesuusi usuppun gallasappe guye, baara Phexiroosa, Yayqoobanne Yohaannisa ekkidi, entta xalaala gita deriya bolla kessidi entta sinthan laamettis. ");
INSERT INTO gofRNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Iya ma7oykka phoolis; sa7an ma7o meecciya oonikka geeshshanaw dandda7onnayssa mela daro booxis. ");
INSERT INTO gofRNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","He heedzu tamaareti, Eliyaasinne Musey Yesuusara odettishin be7idosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Phexiroosi Yesuusa, “Asttamaariyaw, nuuni hayssan de7eyssi nuus lo77o; nu heedzu shaqarata issuwa new, issuwa Muses, qassi issuwa Eliyaasas shaqarana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Iyaranne hankkotara daro yayyida gisho I ay giyakkoka eribeenna. ");
INSERT INTO gofRNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Hessafe guye, shaaray yidi entta kammin shaarappe, “Hayssi ta dosiya, ta Na7aa, I geyssa si7ite” giya qaalay yis. ");
INSERT INTO gofRNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ellesidi entti yuushshi aathi xeelliya wode Yesuusappe attin haraa oonakka bantta matan be7ibookkona. ");
INSERT INTO gofRNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Entti deriyappe wodhdhishin, Yesuusi enttako, “Asa Na7ay, hayqoppe denddana gakkanaw, hintte be7idabaa ooddeskka odoppite” yaagidi kiittis. ");
INSERT INTO gofRNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","I kiittidayssa entti, “Ero” gidi, “Ha hayqoppe denddo geyssi woygusee” gidi, bantta giddon odettidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Entti zaaridi, “Higge asttamaareti, ‘Eliyaasi koyrottidi yaanaw bessees’ ays goonaa?” yaagidi oychchidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesuusi zaaridi “Eliyaasi koyrottidi yidi, ubbabaa giigisees; yaatin, ays Geeshsha Maxaafay, ‘Asa Na7ay daro waayettana ixettana’ yaagi gidi oychchis. ");
INSERT INTO gofRNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Shin taani hinttew odays; Eliyaasi yis; qassi iyabay Geeshsha Maxaafan xaafettidayssada, asay iya bolla bantta koyidabaa oothidosona” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Yesuusi, Phexiroosi, Yayqoobinne Yohaannisi hankko iya tamaaretakko simmidi yaa wode daro asay entta yuushuwan eqqidaysatanne higge asttamaare gidida guutha asati enttara palameyssa be7idosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","He daro asay Yesuusa be7ida wode malaalettidi, ellesidi iyaakko woxxi yidi, iya sarothidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yesuusi ba tamaaretakko, “Enttara ay palameetii?” yaagidi oychchis. ");
INSERT INTO gofRNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","He daro asa giddofe issi uray zaaridi, “Asttamaariyaw, ta na7aa bolla odetethi diggiya tuna ayyaanay de7iya gisho iya neekko ekkada yas. ");
INSERT INTO gofRNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ha tuna ayyaanay iya oykkiya wode ubban, iya shocci yeggees; iya doonara gopponttoy yees; qassi achche garccisees; asatethaaka minnees. Iyappe ha tuna ayyaanaa kessana mela, ne tamaaretas odas, shin kessanaw dandda7ibookkona” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesuusi zaaridi enttako, “Ammanonna ha wodiya asaw! Taani hinttera awude gakkanaw daane? Qassi hinttena awude gakkanaw dandda7anee? Na7aa taakko haa ekki yiite” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Entti na7aa iyaakko ehidosona; he tuna ayyaanay Yesuusa be7ida mela na7aa kokkorssis; na7ay sa7an kunddidi, doonara gopponttoy toofu gishin gonddorettis. ");
INSERT INTO gofRNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesuusi he na7aa aawakko, “Hayssi ne na7aa oykkoossappe ay mela wode gidanee?” yaagidi oychchis. Na7aa aaway, “I guuthan de7ishin oykkis. ");
INSERT INTO gofRNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Iya wodhanaw daro wode tamaninne haathan yeggees, shin ne dandda7ikko, nuus qadhettarkii, nuna maaddarkii” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesuusi iya, “ ‘Neeni dandda7ikko gay?’ Ammaniya ooddeskka ubbabay dandda7ettees” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ellesidi na7aa aaway ba qaala dhoqqu oothidi, “Taani ammanays, shin gujja ammananaada tana maaddarkii” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesuusi asay dari dari beyssa be7idi, tuna ayyaanaa, “Ha tullenne muume ayyaanaw, ha na7aappe keya gada nena ta kiittays; qassi nam77antho iyan geloppa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","He tuna ayyaanay waassidi, na7aa daro kokkorssidi, iyappe keyis. Na7ay hayqqida daanin, daro asay, “Na7ay hayqqis” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Shin Yesuusi na7aa kushiya oykkidi denthin, na7ay denddi eqqis. ");
INSERT INTO gofRNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yesuusi soo gelidayssafe guye iya tamaareti, “Nuuni he tuna ayyaanaa kessanaw ays dandda7ibookko?” yaagidi Yesuusa dumma oychchidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yesuusi zaaridi, “Hessa melay woosappenne xoomappe attin haraban keyanaw dandda7enna” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Entti he bessaafe denddidi, Galiilara aadhdhidi bidosona; Yesuusi ba de7iyasuwa oonikka erana mela koyibeenna. ");
INSERT INTO gofRNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","I ba tamaaretakko, “Asa Na7aa, asi asas aathi immananne wodhana; I heedzu gallasappe guye, hayqoppe denddana” yaagidi tamaarssees. ");
INSERT INTO gofRNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Shin enttaw I geyssi gelibeenna; qassi iya oychchanawukka yayyidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Entti Qifirnahoome katamaa bidi soo gelidayssafe guye Yesuusi enttako, “Ogen ay odetteetii?” yaagidi oychchis. ");
INSERT INTO gofRNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Shin entti, “Nu giddon ubbaafe aadhdhanay oonee?” yaagidi palamida gisho si77i gidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yesuusi uttidi, tammanne nam77u tamaareta xeegidi, “Oonikka sinthe aadhdhanaw koykko, ubbaafe guye aadhdhidi, ubbaas aylle gidanaw bessees” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Issi guutha na7aa ekkidi, entta giddon essis; he guutha na7aa idimmidi enttako, ");
INSERT INTO gofRNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Hayssa mela guutha naytappe issuwa ta sunthan mokkiya oonikka tana mokkees; qassi tana mokkiya oonikka tana kiittidaysaka mokkeesippe attin ta xalaala mokkenna” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yohaannisi, “Asttamaariyaw, issi asi ne sunthan tuna Ayyaanata kessishin nuuni be7idi, nu bagga gidonna gisho iya diggida” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Shin Yesuusi, “Oonikka ta sunthan Xoossay oothiya malaatata oothidi, ellesidi ta bolla iitabaa odettanaw dandda7ey baynna gisho diggofite. ");
INSERT INTO gofRNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Nubaa ixxonna uray nu bagga. ");
INSERT INTO gofRNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Taani hinttew tuma odays; hintte tayssata gidiya gisho oonikka hinttew ta sunthan halo haathi uyanaw immikokka, ba woytuwa ekkana. ");
INSERT INTO gofRNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Tana ammaniyaa ha guuthatappe issuwa balethiya oonikka, gaachcha wogga woxa ba qodhen qachchidi, abban wulliyako iyaw lo77o. ");
INSERT INTO gofRNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Ne kushey nena balethikko, qanxa hola. Neeni nam77u kushera to7onna gaanname taman yegetteyssafe, duuxa kushera de7uwa geloy new lo77o. ");
INSERT INTO gofRNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Ne tohoy nena balethikko, qanxa hola. Neeni nam77u tohuwara gaanname taman yegetteyssafe, wobbe gidada de7uwa geleyssi new lo77o. ");
INSERT INTO gofRNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ne ayfey nena balethikko, wooca kessa hola. Neeni nam77u ayfiyaara gaanname taman yegetteyssafe, issi ayfiyaara Xoossaa kawotethaa geleyssi new lo77o. ");
INSERT INTO gofRNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Yan entta miya guxuney hayqqenna, tamaykka to7enna. ");
INSERT INTO gofRNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Yarshshoy maxinen geeyeyssa mela asi ubbay taman harqettana. ");
INSERT INTO gofRNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Maxiney lo77o, shin I mal77onna ixxiko, zaaridi waati mal77ethanee? Hinttenan maxiney de7o. Yaanidi issoy issuwara sarotethaan de7ite” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesuusi hessafe denddidi, Yihuda biittaa bidi Yorddaanose Shaafaa pinnis. Daro asay zaaridi iyaakko shiiqin, kaseyssadakka he asaa tamaarssis. ");
INSERT INTO gofRNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Issi issi Farisaaweti paaccanaw koyidi Yesuusa, “Issi asi ba machchiw yeddana mela Muse higgey kiitii?” yaagidi iya oychchidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","I zaaridi, “Musey hinttena woygidi kiittidee?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Entti, “Musey, ‘Issi asi ba machchees anjjo worqqate immidi yeddo’ gis” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesuusi zaaridi, entta “Hintte odin si7onnayssata gidiya gisho Musey ha kiitaa hinttew xaafis. ");
INSERT INTO gofRNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Shin Xoossay koyro medhdhiya wode addenne macca oothidi, entta medhdhis. ");
INSERT INTO gofRNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Hessa gisho, issi asi ba aawanne ba aayiw aggidi, ba machcheera issife de7ees. ");
INSERT INTO gofRNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Entti nam77ay issi ase gidoosona; hizappe, entti issi ase gidoosonappe attin nam77u asi gidokkona. ");
INSERT INTO gofRNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Hessa gisho, Xoossay issife qachchidayssa asi shaakkofo” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Entti soo simmida wode iya tamaareti ha odabaa Yesuusa nam77antho oychchidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Yesuusi enttako, “Ba machchiw yeddidi hara ekkiya oonikka laymatees. ");
INSERT INTO gofRNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Qassi maccasiyakka ba azinaappe keyada hara azina gelikko laymatawusu” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Yesuusi guutha nayta bochchana mela, issi issi asay nayta iyaakko ehoosona, shin iya tamaareti he asa hanqettidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesuusi hessa be7idi, ba tamaareta hanqettidi; enttako, “Guutha nayti taakko yeyssa diggofite; Xoossaa kawotethay hayssata melassa. ");
INSERT INTO gofRNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Taani hinttew tuma odays; Xoossaa kawotethaa guutha na7ada ekkonna uray oonikka he kawotethaa ubbarakka gelenna” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Guutha nayta idimmidi, ba kushiya entta issuwa issuwa bolla wothidi anjjis. ");
INSERT INTO gofRNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesuusi baanaw keyida wode issi uray woxxi yidi, iya sinthan gulbbatidi, “Keeha asttamaariyaw, merinaa de7uwa laattanaw taani ay ootho?” yaagidi oychchis. ");
INSERT INTO gofRNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesuusi, “Ays tana keehaw gada xeegay? Xoossaa xalaalappe attin hari keehi oonikka baawa. ");
INSERT INTO gofRNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Xoossaa kiitaa, wodhoppa; laymatoppa; kaysotoppa; worddo markkattofa; inxarssan cimmofa; ne aawanne ne aayiw bonchcha yaageyssa eraasa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Uray, “Asttamaariyaw, taani hessa ubbaa na7atethafe doomada ha77i gakkanaw naagays” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesuusi uraa tishshi oothi xeellidi dosis; “New issibay paccees; bada new de7iyaba ubbaa bayzada, he miishiya manqotas imma; neeni salon duretana. Yaata simmada tana kaalla” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Shin uray hessa si7idi, I daro dure gidiya gisho ba som77uwa kaarethis, ufayttonna aggidi bis. ");
INSERT INTO gofRNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesuusi ba tamaareta yuushshi aathi xeellidi, “Dure asi Xoossaa kawotethaa gelanayssi waanidi metanddeeshsha!” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Iya tamaareti iya timirttiya si7idi malaalettidosona. Shin Yesuusi qassika enttako, “Nayto, Xoossaa kawotethaa gelanayssi waanidi metanddeeshsha! ");
INSERT INTO gofRNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Dure asi Xoossaa kawotethaa gelanayssafe, gimaley narppe luhora aadhdheyssi kawuyees” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Iya tamaareti malaalettidi, “Yaatin, ooni attanee?” yaagidi, issoy issuwa oychchidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesuusi entta tishshi oothi xeellidi, “Hayssi Xoossas dandda7eteesppe attin asas dandda7ettenna; Xoossas ubbabay dandda7ettees” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Phexiroosi Yesuusakko, “Hekko; nuuni nubaa ubbaa aggidi, nena kaallida” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesuusi “Taani hinttew tuma odays; ta gishonne Wonggelaa gisho keetha woykko ishata woykko michcheta woykko aawa woykko aayiw woykko machchiw woykko nayta woykko gadiya aggiday oonikka, ");
INSERT INTO gofRNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ha77i ha wodiyan xeetu kushe keetha, ishata, michcheta, aayeta, nayta, gadiya, goodetethara issife ekkana. Sinthafe yaana wodiyankka merinaa de7uwa ekkana. ");
INSERT INTO gofRNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Shin daroti ha77i dethan sinthe gididayssati guye gidana, qassi daroti ha77i guye gididayssati sinthe gidana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesuusaranne iya tamaaretara Yerusalaame bishin, Yesuusi ba tamaareta sinthan hamuttees. Entti malaalettidosona. Iya kaalleyssatikka yayyidosona. Nam77antho, tammanne nam77u tamaareta gaxa kessidi, bana gakkanabaa dumma enttaw hayssada yaagidi odis. ");
INSERT INTO gofRNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Hekko, nuuni Yerusalaame ha77i keyoos. Yan Asa Na7ay, kahine halaqatasinne higge asttamaaretas aathi imettana. Entti iya bolla hayqo pirddaa pirddana; qassi Ayhude gidonna deriyas iya aathi immana. ");
INSERT INTO gofRNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","He Ayhude gidonna derey iya toochchana, iya bolla cuttana, lisson garaafananne wodhana. I heedzu gallasappe guye, hayqoppe denddana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Zabdiyoosa nayti Yayqoobinne Yohaannisi Yesuusakko yidi, “Asttamaariyaw, nuuni nena woossiya issibaa nuus ootharkkii” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yesuusi enttako, “Taani hinttew ay ootho?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Entti, “Neeni ne bonchcho kawotethan uttiya wode nuuppe issuwa ushachcha baggara qassi issuwa haddirssa baggara uttisarkkii” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Shin Yesuusi enttako, “Hintte ay woossiyako erekketa, ta uyanaw de7iya xuu7aa uyanaw dandda7etii? Qassi taani xammaqettanaw de7iya xinqqatiya xammaqettanaw dandda7etii?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Entti zaaridi, “Ee dandda7os” yaagidosona. Yesuusi qassi, “Tumakka ta uyanaw de7iya xuu7aa hintte uyana, taani xammaqettanaw de7iya xinqqatiya hintte xammaqettana. ");
INSERT INTO gofRNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Shin taappe ushachcha baggaranne haddirssa baggara uttanayssata dooranaw taw maati baawa, shin he bessay Xoossay immanaw giigisi wothidayssatassa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Hankko tammu tamaareti hessa si7ida wode Yayqoobanne Yohaannisa hanqettidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yesuusi entta ubbaa baakko xeegidi, “Ayhude gidonna asaa halaqati deriya haareyssata geetettidi xeegetteyssanne haareyssatas deriya bolla maati de7eyssa hintte ereeta. ");
INSERT INTO gofRNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Shin hintte giddon hessa mela gidenna; hintte giddon gitatanaw koyey oonikka hinttew aylle gidanaw bessees. ");
INSERT INTO gofRNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Qassi hintte giddon ubbaafe bolla gidanaw koyey oonikka hintte ubbaas aylle gidanaw bessees. ");
INSERT INTO gofRNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Hari attoshin, Asa Na7aykka, asaas oothanawunne darota wozanaw ba shemppuwa aathi immanaw yisippe attin asi iyaw oothana mela yibeenna” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Entti Iyaarkko katama bidosona. Yesuusi ba tamaaretaranne daro asaara Iyaarkkofe keyishin, Ximoosa na7ay, qooqey, Barximoosa geetetteyssi, oge gaxan woossishe uttis. ");
INSERT INTO gofRNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Barximoosi, yaara aadhdhey Naazirete Yesuusa gididayssa si7ida wode ba qaala dhoqqu oothidi, “Dawite na7aa Yesuusa, tana maararkii!” yaagusu oykkis. ");
INSERT INTO gofRNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Daro asay iya, “Hayza!” gidi hanqettidosona. Shin, I ba qaala kaseyssafe daro dhoqqu oothidi, “Dawite na7aw, tana maararkii!” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesuusi eqqidi, “Iya haa xeegite” yaagis. Entti qooqiyakko, “Aykkoy baawa, dendda eqqa, nena xeegees” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Qooqey ba ma7uwa holi yeggidi, guppi denddi eqqidi, Yesuusakko bis. ");
INSERT INTO gofRNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesuusi, “Taani new ay oothana mela koyay?” yaagis. Qooqey, “Asttamaariyaw, ta xeellanaw koyays” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesuusi iya, “Ba, ne ammanoy nena pathis” yaagis. Sohuwarakka iya ayfey xeellin, Yesuusa kaallis. ");
INSERT INTO gofRNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Entti Yerusalaame matishe, Shamaho Deriya matan de7iya Beetefaagenne Bitaaniya katamata gakkidosona. Yesuusi ba tamaaretappe nam77ata sinthe kiittidi, ");
INSERT INTO gofRNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“Hinttefe sinthan de7iya gutaa biite; yaa gelida mela oonikka toggiboonna qashon de7iya hare mari hintte demmana, iya billidi, haa ekki yiite. ");
INSERT INTO gofRNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Oonikka hinttena, ‘Hayssa ays ootheetii?’ yaagidi oychchiko, ‘Goday iya koyees, ellesidi haa yeddana’ yaagite” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Entti bidi, hare mari kare bolla oge matan qashettidi de7eyssa demmidi billidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","He bessan eqqida issi issi asati enttako, “Hare maraa waatanaw billeeti?” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Iya tamaareti Yesuusi banttana kiittidayssa odin, asati yeddi aggidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Entti hare maraa Yesuusakko ehidi, bantta ma7uwa iya zokkon hiixin Yesuusi he hare maraa toggis. ");
INSERT INTO gofRNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Daro asay bantta ma7uwa ogiyan hiixidosona; qassi harati mitha tashe tashidi, ogen hiixidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Yesuusappe sinthara hamuttiya asaynne iya kaalliya asay bantta qaala dhoqqu oothidi, “Hosaana! Xoossay galatetto! Godaa sunthan yeyssi anjjettidayssa. ");
INSERT INTO gofRNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Godaa sunthan yaa nu aawa Dawite kawotethay anjjettidayssa. Ubbaafe Bolla Saluwan de7iya Xoossay galatetto” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesuusi Yerusalaame bidi, Xoossaa Keetha gelis. Qassi ubbabaa yuuyi xeellidaappe guye, sa7ay qammiya gisho tammanne nam77u tamaaretara Bitaaniya katama bis. ");
INSERT INTO gofRNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Wonttetha gallas entti Bitaaniyappe keyidi bishin, Yesuusi koshattis. ");
INSERT INTO gofRNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Haahon issi balase mithiw haytha xalaala ma77a uttidaaro be7idi, I bolla ayfey beettiko gidi, be7anaw iikko bis, shin iikko I biya wode haytha xalaalappe attin issi ayfekka demmibeenna; ays giikko, balasey ayfiyaa wodey gakkibeenna. ");
INSERT INTO gofRNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Yesuusi he balasiw, “Hiza, neeppe merinaw asi ayfe mooppo” yaagis. Iya tamaareti I geyssa si7idosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Entti Yerusalaame bidosona; Yesuusi Xoossa Keetha gelidi, yan bayzeyssatanne shammeyssata kare goodo oykkis; qassi miishe laammeyssata xarpheezanne holle bayzeyssata oydiya aathi yeggidi, ");
INSERT INTO gofRNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","asi aybibaakka tookkidi, Xoossa Keetha giddora aadhdhonna mela diggis. ");
INSERT INTO gofRNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Yesuusi asaa hayssada yaagidi tamaarssis: “Geeshsha Maxaafan, ‘Ta keethay asi ubbay Xoossaa woossiya keethi gidana’ geetettidi xaafettis. Shin hintte iya panggati qosettiya gonggolo oothideta” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Kahine halaqatinne higge asttamaareti hessa si7idi, iya wodhanaw oge koshshi oykkidosona. Shin daro asay iya timirttiyan malaalettiya gisho iyaw yayyidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Sa7ay omarssiya wode Yesuusinne iya tamaareti katamaappe gaxa keyidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Entti wonttetha gallas he ogiyara aadhdhishe, he balasiya xaphora melidaaro be7idosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Phexiroosi akeekidi, “Asttamaariyaw, hekko, neeni qanggida balasiya melasu” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesuusi zaaridi, “Xoossaa ammanite. ");
INSERT INTO gofRNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Taani hinttew tuma odays; oonikka ba wozanan sidhonna gidabay hananayssa ammanidi, ha deriya, ‘Denddada abban kundda’ yaagikko iyaw hanana. ");
INSERT INTO gofRNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Hessa gisho, taani hinttew odays; Xoossaa hintte woossiyabaanne oychchiyabaa aybaa gidikkoka ekkidaada ammanite, hintte ekkana. ");
INSERT INTO gofRNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Xoossaa woossanaw hintte eqqiya wode salon de7iya hintte Aaway hintte nagara atto gaana mela, oonikka hinttena naaqidabay de7ikko, iyaw atto giite. ");
INSERT INTO gofRNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Shin asa nagara hintte atto goonna ixxiko, salon de7iya hintte Aawaykka hintte nagaraa hinttew atto geenna” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Entti zaaridi Yerusalaame bidosona. Yesuusi Xoossa Keethan hamuttishin, kahine halaqati, higge asttamaaretinne cimati iyaakko yidi, ");
INSERT INTO gofRNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","“Neeni hayssa oothanaw new ay maati de7ii? Woykko new ha maata immiday oonee?” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesuusi zaaridi enttako, “Ta hinttena issibaa oychchana, taw odite. Ta qassi hayssa ay maatan oothiyako, hinttew odana. ");
INSERT INTO gofRNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Yohaannisa xinqqatey Xoossafeyye woykko asappe? Taw odite” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Entti bantta giddon palama doomidi, “Nuuni, ‘Xoossafe’ giikko, I nuukko, ‘Yaatin, Yohaannisi odidayssa ays ammanibeekketii?’ yaagana. ");
INSERT INTO gofRNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","‘Asappe giikko’ asa ubbay Yohaannisi nabe gideyssa eroosona.” Yaaniya gisho asaas yayyidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Hessa gisho, entti Yesuusakko, “Nuuni erokko” yaagidi zaaridosona; Yesuusi, “Taanikka hayssa ay maatan oothiyako, hinttew odikke” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yesuusi enttaw leemison yaagidi odis; “Issi uray woyne atakiltte tokkidi, yuushshi aathidi dirssi diris. Qassi he woyniya gum77iya olaaka bookkis. Iya naaganaw adussa shakko shakkis. Hessafe guye, kothe oothiya asaas immidi, hara biitta bis. ");
INSERT INTO gofRNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Woyne ayfiyaa maxiya wodey gakkin, bana gakkeyssa ekkidi yaana mela, issi ba aylliya kothe aawatakko kiittis. ");
INSERT INTO gofRNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Kothe aawati iya aylliya oykkidi wadhdhidi, mela kushe yeddidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Nam77antho hara aylle enttako kiittin, entti he aylliyas huu7iya qoo7idi kawushshidi yeddidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Woyne atakilttiya goday qassika hara aylle kiittis. He aylliya wodhidosona, qassi hara darota hessada oothidosona, issota issota wadhdhidi, harata wodhidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Woyne atakilttiya godaas kiittanaw ubbaafe wurssethan I daro dosiya ba na7aa xalaali attis. I, “Entti ta na7aa bonchchonna aggokona” gidi, ba na7aa enttako kiittis. ");
INSERT INTO gofRNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Shin kothe aawati bantta giddon, ‘Laattanayssi hayssa; yedhdhite iya wodhoos; iya laatay nubaa gidana!’ yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Na7aa oykkidi wodhidi, iya ahaa woyne atakilttiya giddofe gaxa kessi holidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Hiza, woyne atakilttiya goday waatanee? Yidi he kothe aawata wodhi onggidi, woyniya kothe oothiya hara asas immana. ");
INSERT INTO gofRNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","11","‘Gimbbeyssati boridi ixxida shuchchay godaa xaphuwa minthiya, ubbaafe aadhdhiya shuchchu gidis. Hayssi Goday oothidabaa; qassi nu ayfiyaaskka malaalisiyabaa’ yaageyssa Geeshsha Maxaafaappe nabbabibeekketii?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Kahine halaqati, higge asttamaaretinne cimati Yesuusi he leemisuwa bantta bolla leemisidayssa erida gisho iya oykkanaw koyidosona, shin asaas yayyidi, aggi bidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Qassi iya odaappe bala demmidi, iya oykkana mela, Farisaawetappenne Heroodisa baggatappe guutha asata iyaakko kiittidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Entti iyaakko yidi, “Asttamaariyaw, neeni tuma odetteyssanne asappe ase shaakkonnayssa nuuni eroos. Neeni ase dummayakka; qassi Xoossaa ogiya tumatethan tamaarssaasa. Nuuni Roome biittaa Kawuwa Qeesares giira giireyssi wogeyye woga gidennee? Giira giiranee agganee?” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Shin entta cubbotethaa Yesuusi eridi, “Tana ays paacetii? Ane issi santime tana bessite” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Entti iyaw ehidosona, “Ha malaynne sunthay ooddeysee?” yaagidi entta oychchis. Entti, “Roome Kawuwa Qeesareyssa” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Yesuusi zaaridi, “Yaatikko, Qeesareyssa Qeesares, Xoossayssa Xoossaas immite” yaagin entti iyabaa malaalettidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Hayqqida asi denddenna giya Saduqaawetappe issi issi asati Yesuusakko yidi, hayssada yaagidi, iya oychchidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Asttamaariyaw, Musey nuus higgiya xaafishe, ‘Machcho ekkida asi na7a yelonna hayqqiko, he hayqqidayssa ishay iya machchiw ekkidi, ba ishaas na7a yelanaw bessees’ yaageyssa xaafis. ");
INSERT INTO gofRNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Beni wode laappun ishati de7eyssatappe bayray machcho ekkidi, na7a yelonna hayqqis. ");
INSERT INTO gofRNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Nam77anthoy iyo ekkis, ikka na7a yelonna hayqqis. Heedzanthoyka hessada hanis. ");
INSERT INTO gofRNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Laappunatikka hessatho iyo ekkidi, na7a yelonna hayqqidosona. Ubbaafe guye, qassi he maccasiya hayqqasu. ");
INSERT INTO gofRNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Yaatin, laappunati iyo ekkida gisho hayqqida asay hayqoppe denddiya gallas, iya enttafe awussas machcho gidanee?” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesuusi zaaridi, “Hintte baley, Geeshsha Maxaafata woykko Xoossaa wolqqaa eronna gishossa! ");
INSERT INTO gofRNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Hayqqida asay hayqoppe denddiya gallas, salon de7iya kiitanchchota mela gidanaappe attin adde asay ekkokona; macca asay gelekkona. ");
INSERT INTO gofRNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Shin hayqqidayssata dendduwabaa gidikko, Muse maxaafan xaafettida xuugettiya buuriyabaa odiya bessan, Xoossay Musekko, ‘Taani, Abrahame Xoossaa, Yisaaqa Xoossaa, Yayqooba Xoossaa’ gidayssa nabbabibeekketii? ");
INSERT INTO gofRNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Hessa gisho, I, paxa de7eyssata Xoossaafe attin hayqqidayssata Xoosse gidenna. Hintte daro balideta” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Higge asttamaaretappe issoy entti palameyssa shiiqidi si7is. Qassi Yesuusi enttaw loythi zaaridayssa si7idi, “Kiita ubbaafe aadhdhiya kiitay awussee?” yaagidi Yesuusa oychchis. ");
INSERT INTO gofRNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesuusi zaaridi, iya hayssada yaagis: “Kiita ubbaafe aadhdhiya kiitaa si7ite; ‘Isra7eele asaw, Goday nu Xoossay issi Godaa. ");
INSERT INTO gofRNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ne Godaa ne Xoossaa ne kumetha wozanappe, ne kumetha shemppuwafe, ne kumetha qofaappe, ne kumetha wolqqaafe dosa’ yaagees. ");
INSERT INTO gofRNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Qassi kiita ubbaafe aadhdhiya nam77antho kiitay hayssa; ‘Ase ubbaa ne huu7iyada dosa’ yaageyssa; hayssatappe aadhdhiya hara kiiti baawa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Higge asttamaarey Yesuusakko, “Asttamaariyaw, tuma gadasa; neeni ‘Xoossay issi Xoossaa xalaala. Iyappe attin hari baawa’ gidayssi tuma. ");
INSERT INTO gofRNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Xoossaa kumetha wozanappe, kumetha qofaappenne kumetha wolqqaafe doseysinne qassi ase ubbaa ba huu7iyada doseyssi, xuuggiya yarshshuwafenne hara yarshsho ubbaafe aadhdhees” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesuusi higge asttamaariya zaaroy aadhdhida eranchcho asa zaaro gididayssa be7idi, “Neeni Xoossaa kawotethaafe haakkabaakka” yaagis; hessafe guye, Yesuusa harabaa oychchanaw oonikka minnibeenna. ");
INSERT INTO gofRNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesuusi Xoossa Keethan tamaarssishe, hayssada yaagis: “Higge asttamaareti Kiristtoosa woygidi Dawite na7a goonaa? ");
INSERT INTO gofRNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Dawitey Geeshsha Ayyaanan kumidi, ‘Goday, ta Godaa, “Taani ne morkketa ne tohoy yedhdhiyaso oothana gakkanaw, hayssan taappe ushachcha baggara utta” gis’ yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dawitey ba huu7en Kiristtoosa, ‘Godaa’ gidi xeegikko, yaatin, Kiristtoosi waanidi, Dawite na7a gidii” yaagis. Daro asay Yesuusi geyssa ufayssan si7idosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yesuusi tamaarssishe, hayssada yaagis: “Higge asttamaaretappe naagettite; entti adussa ma7o ma77idi yuuyeyssanne giyankka asay entta bonchchidi sarotheyssa dosoosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Entti Ayhude Woosa Keethatan daro lo77o oyde dosoosona; qassi asi banttana mokkiya bessan bonchcho bessi dosoosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Entti am77eta keethaa bonqidi, banttaw lo77o daananaw woosa adussoosona; entti ubbaafe aadhdhiya pirddaa ekkana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesuusi Xoossa Keethan muxaata yeggiya saaxiniya matan uttidi, asay ba miishiya he saaxiniyan yeggeyssa be7is; daro dure asay daro miishiya he saaxiniyan yeggoosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Issi manqo am77iya yada, nam77u bakkannata he saaxiniyan yeggasu. ");
INSERT INTO gofRNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yesuusi ba tamaareta xeegidi, “Taani hinttew tuma odays; muxaata saaxiniyan yeggida asa ubbaafe ha manqo am77iya darssada yeggasu. ");
INSERT INTO gofRNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ays giikko, harati ubbay banttaw palahida miishiyappe yeggidosona. Shin iya ba pacciyaafe, baw de7iya aquwaa kumethi immasu” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesuusi Xoossa Keethafe keyishin, iya tamaaretappe issoy, “Asttamaariyaw, ha lo77o shuchchaanne ha lo77o shuchcha keethaa be7ay!” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesuusi zaaridi, “Ha gita shuchcha keethaa be7ay? Ha keethay shuchchi shuchcha bolla gimbbettida mela laalettonna attenna; issi shuchchika attonna ubbay laalettana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesuusi Xoossa keethafe hini baggara Shamaho Deriya bolla uttidashin, Phexiroosi, Yayqoobi, Yohaannisinne Inddiriyasi banttarkka iyaakko yidi, ");
INSERT INTO gofRNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Hayssi awude hananeekko, nuus oda; ha ubbay polettana wodiya erisiya malaatay aybee?” yaagidi oychchidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesuusi qassi enttaw hayssada yaagidi odis: “Hinttena oonikka balethonna mela naagettite. ");
INSERT INTO gofRNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Daro asati ta sunthan, ‘Taani Kiristtoosa’ yaagidi tamaarssishe yidi, daro asaa balethana. ");
INSERT INTO gofRNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Matan de7iya olaanne haahon de7iya ola wore hintte si7iya wode hirggofite. Hessa melabay hananaw bessees, shin wurssethay buroona. ");
INSERT INTO gofRNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Issi biittaa asay hara biitta asaara olettana; qassi issi kawotethay hara kawotethatara olettana; biittaa qaaxoy ubba bessan hanana; koshay daana, shin hessi ubbay yelo iqethas zooke mela. ");
INSERT INTO gofRNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Shin hinttee, hintte huu7en naagettite. Ays giikko, asi hinttena oykkidi, pirdda keethas aathi immana; qassi Ayhude Woosa Keethatankka hinttena lisson garaafana; deriya haareyssata sinthaninne kawota sinthan ta gisho hintte markkattanaw eqqana. ");
INSERT INTO gofRNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Wurssethay gakkanaappe sinthe Wonggelay koyro dere ubbaas odettanaw bessees. ");
INSERT INTO gofRNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Entti hinttena pirdda keethi ehiya wodenne aathi immiya wode woygidi odaneekko koyro hirggofite; he saatiyan Xoossay hinttew immiyabaa odite. Hinttenan Geeshsha Ayyaanay odetteesippe attin hinttena gidekketa. ");
INSERT INTO gofRNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Ishay ba ishaa, aaway ba na7aa wodhisana. Nayti banttana yelidayssata bolla denddidi, entta wodhisana. ");
INSERT INTO gofRNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Asay ubbay hinttena ta sunthaa gisho ixxana, shin wurssethi gakkanaw minniday attana. ");
INSERT INTO gofRNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Shin bashshaa tunatethay eqqanaw bessonna bessan eqqidashin hintte be7ana.” (Akeekiso: Hessi woy guusseeko nabbabeyssi akeeko!) “Yihuda biittan he wode de7eyssati deriyakko baqato. ");
INSERT INTO gofRNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Keetha huu7en de7iya uraykka issibaa ekkanaw duge wodhdhidi, ba soo geloppo. ");
INSERT INTO gofRNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Gaden de7eyssi ba ma7uwa ekkanaw guye simmofo. ");
INSERT INTO gofRNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","He wode qanthatida maccasatasinne dhanthiya maccasatas daro un77a gidana. ");
INSERT INTO gofRNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Shin hayssi ubbay haniya wodey balggo gidonna mela, Xoossaa woossite. ");
INSERT INTO gofRNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ays giikko, Xoossay alamiya medhdhida wodiyappe doomidi, ha77i gakkanaw haniboonna metoynne sinthafekka hanonna metoy asa bolla he wode hanana. ");
INSERT INTO gofRNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Goday he gallasata taybuwa guuthonaako, ase gididay oonikka attenna. Shin I ba doorida asa gisho he gallasata taybuwa guuthees. ");
INSERT INTO gofRNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“He wode oonikka hinttena, ‘Hekko, Kiristtoosi hayssan de7ees woykko Kiristtoosi hinin de7ees’ yaagikko, hessa ammanoppite. ");
INSERT INTO gofRNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Worddanchcho Kiristtoosatinne worddo nabeti denddidi banttaw dandda7ettiko, hari attoshin Xoossay dooridayssatakka balethanaw malaatatanne malaalisiyabata bessana. ");
INSERT INTO gofRNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Shin hintte naagettite; taani hinttew ubbabaa kasetada odas. ");
INSERT INTO gofRNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Shin he wode he waayappe guye, away dhumana; ageenay poo7uwa aggana; ");
INSERT INTO gofRNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","xoolinttoti saloppe kunddana; qassi salon de7iya wolqqatikka qaaxxana. ");
INSERT INTO gofRNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","He wode Asa Na7ay, gita wolqqaranne bonchchuwara shaara giddora yishin entti be7ana. ");
INSERT INTO gofRNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","He wode taani kiitanchchota sa7a oyddu bagga kiittana; sa7a gaxappe saluwa gaxa gakkanaw, Xoossay doorida asaa shiishana. ");
INSERT INTO gofRNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Leemisuwa balase mithaafe akeekite; balasiya aaciya wodenne I haythay cil77iya wode torchchey matattidayssa hintte ereeta. ");
INSERT INTO gofRNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Hessadakka, hintte he ubbabay haneyssa be7iya wode I matidi pengge gakkidayssa erite. ");
INSERT INTO gofRNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Taani hinttew tuma odays; ha ubbabay hanana gakkanaw hayssan de7iya asa ubbay hayqqenna. ");
INSERT INTO gofRNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Saloynne sa7ay aadhdhana, shin ta qaalay ubbarakka aadhdhenna. ");
INSERT INTO gofRNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Shin he gallasaanne he saatiya Aawa xalaalappe attin hari attoshin salon de7iya kiitanchchota gidin woykko Na7aa gidin oonikka erey baawa. ");
INSERT INTO gofRNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","He wodey awude gidaneekko, hintte eronna gisho naagettitenne minnite. ");
INSERT INTO gofRNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ta yuussay ba keetha aggidi, oge biya uraa mela. Uray ba aylleta huu7en huu7en oosuwa immidi entta ba oosuwas aawa oothis; qassi naageysika minthidi naagana mela kiittis. ");
INSERT INTO gofRNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Hessa gisho, minnite. Ays giikko, keethaaway omarssi gidin woykko giddi bilahe gidin woykko kutto waaso gidin woykko wontta guura gidin awude yaanekko, hintte erekketa. ");
INSERT INTO gofRNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Hintte akeekonna I yidi hinttena dhiskkidi de7ishin demmonna mela minnite. ");
INSERT INTO gofRNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Taani hinttew odeyssa asa ubbaas odays; minnite” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Paasika Baale bonchchiya gallasaynne Uytha Baale bonchchiya gallasay gakkanaw nam77u gallasi attis. Kahine halaqatinne higge asttamaareti asi eronna Yesuusa oykkidi wodhdhiya oge koyoosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","“Asay ooshshi kessonna mela Paasika bonchchiya gallasan hessa oothoko” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesuusi Bitaaniya kataman baro hargganchchuwa Simoona son gibira bolla uttidashin, issi maccasiya albasxiroose giya shuchchafe oosettida philqqaaxe kumetha narddoose giya daro al77o shitto ekkada yasu. He philqqaaxiya menthada shittuwa Yesuusa huu7iyan tigasu. ");
INSERT INTO gofRNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","He bessan de7iya asappe issoy issoy hanqettidi, “Ha shittoy mela coo iitey aybisse? ");
INSERT INTO gofRNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ha shittuwa heedzu xeetu dinaaren bayzidi, miishiya manqotas immanaw dandda7ettees” yaagidi bantta giddon odettidosona. Yaatidi, he maccasiw daro boridosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Shin Yesuusi “Ha maccasiw aykkoka gooppite; iyo ays waaysetii? Iya taw lo77obaa oothasu. ");
INSERT INTO gofRNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Manqoti ubba wode hinttera de7oosona. Hintte koyida wode awudekka hintte entta maaddanaw dandda7eeta, shin taani ubba wode hinttera de7ikke. ");
INSERT INTO gofRNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Iya ba dandda7idayssa oothasu; qassi tana moogos giigisanaw kasetada shitto tiyasu. ");
INSERT INTO gofRNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Taani hinttew tuma odays; sa7a ubban Wonggelaa odiyason awunkka, asay iyo akeekana mela ha iya oothidayssi odettana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Tammanne nam77u tamaaretappe issoy Asqoroota Yihuda geetetteyssi Yesuusa kahine halaqatas aathi immanaw enttako bis. ");
INSERT INTO gofRNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Entti hessa si7ida wode ufayttidi, “Nuuni new miishe immana” yaagidosona; Yihudi Yesuusa aathi immanaw injje wode koyees. ");
INSERT INTO gofRNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Uythaa Baaley bonchchettiya koyro gallas, Paasika kathaa maanaw maraze shukkiya wode Yesuusa tamaareti iyakko, “Paasika bonchchiya gallas neeni maana kathaa nuuni aw bidi giigisino?” gidi oychchidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Yesuusi ba tamaaretappe nam77ata hayssada yaagidi kiittis: “Katamaa biite; hintte bishin, otora haathe tookkida issi uray hinttera gahettana; iya kaallite. ");
INSERT INTO gofRNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","I bidi geliya keethaawa, ‘Asttamaarey neekko, “Taani ta tamaaretara Paasika maanaw imatha kifiley awunee?” yaagees’ yaagite. ");
INSERT INTO gofRNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Keethaaway hinttena pooqiya bolla de7iya giigi uttida dalgga kifile bessana; hessan giigisite” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","He nam77u tamaareti keyidi, katama bidosona; Yesuusi enttaw odidayssada demmidi, Paasika kathaa giigisidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Sa7ay omarssiya wode Yesuusi tammanne nam77u tamaaretara yaa bis. ");
INSERT INTO gofRNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Entti uttidi kathi mishin, Yesuusi enttako, “Taani hinttew tuma odays; hinttefe issoy taara meyssi, tana aathi immana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Iya tamaareti dagammidi, bantta huu7en huu7en, “Tuma taneshsha?” yaagidi iya oychchidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesuusi zaaridi, “He uray hintte tammanne nam77atappe issuwa; I taara issife tushanaw ba uythaa shaatiyan yeddeyssa. ");
INSERT INTO gofRNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Asa Na7ay, Geeshsha Maxaafay hayqqana gidayssada hayqqana, shin Asa Na7aa, aathi immiya uraa ayye. He uray yelettonna attidaakko iyaw lo77oshin” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Entti miishin, Yesuusi uythaa ekkidi, Xoossaa galatis; he uythaa menthidi, ba tamaaretas immishe, “He7ite, hayssi ta ashuwa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Xuu7aa ekkidi, Xoossaa galatidi, enttaw immin ubbayka he xuu7appe uyidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Yesuusi, “Hayssi ooratha caaquwan daro asaa gisho gukkiya ta suuthaa. ");
INSERT INTO gofRNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Taani hinttew tuma odays; taani Xoossaa kawotethan ooratha woyniya uyana gallasay gakkanaw zaarada ha woyniyappe uyikke” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Mazmure yexxidaappe guye Shamaho Deriya bolla bidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesuusi enttako, “Hintte ubbay tana yeggi aggidi baqatana; Geeshsha Maxaafay, ‘Xoossay dorssa heemmeyssa wodhana, dorssati ubbay laalettana’ yaagees. ");
INSERT INTO gofRNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Shin taani hayqoppe denddidaappe guye hinttefe kasetada Galiila baana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Phexiroosi zaaridi, “Entti ubbay nena yeggi aggidi baqatikkoka, ta nena aggike” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesuusi Phexiroosakko, “Taani new tuma odays; hachchi qamma kuttoy nam77u toho waassanaappe sinthe neeni tana heedzu toho kaddana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Shin Phexiroosi kaseyssafe minthidi, “Taani hari attoshin, neera issife hayqqiyakokka, nena kaddike” yaagis. Qassi harati ubbatikka hessada gidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Geetesemaane giya bessaa bidosona; Yesuusi ba tamaaretakko, “Taani Xoossaa woossada simmana gakkanaw hintte hayssan uttishite” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Yesuusi Phexiroosa, Yayqoobanne Yohaannisa baara ekkidi bis; daro waayettisinne un77ettis. ");
INSERT INTO gofRNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Qassi enttako, “Taani hayqqana gakkanaw azzanas, hayssan gam77ishite; dhiskkofite” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Guuthi sinthe shiiqidi, sa7an gufannidi, dandda7ettiyabaa gidikko, he waaya saatey baappe aadhdhana mela, Xoossaa woossis. ");
INSERT INTO gofRNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Qassi, “Abbaa, ta Aawaw, ubbabay new dandda7ettees, ha waaye xuu7aa taappe digga. Shin ne sheney hanoppe attin ta sheney hanoppo” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Yesuusi ba tamaaretakko simmi yidi, entti dhiskkidashin demmidi, Phexiroosakko, “Simoonaa, dhiskkadii? Neeni issi saatekka barkkada naaganaw dandda7abiikkii? ");
INSERT INTO gofRNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Paacen hintte gelonna mela barkkidi naagitenne Xoossaa woossite. Hinttew lo77o amoy de7ees, shin hintte daaburanchcho asi” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Qassika bidi kaseyssadakka Xoossaa woossis. ");
INSERT INTO gofRNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ba tamaaretakko guye simmidi yaa wode dhiskkidashin demmis. Entta ayfiyaa dhiskkoy goozi wothida gisho iyaakko ay odettiyakokka erokkona. ");
INSERT INTO gofRNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Heedzantho enttako yidi, “Ha77i gakkanawukka dhiskkeetinne shemppetii? Hiza, gidana; saatey gakkis; be7ite! Asa Na7ay, nagaranchcho asatas aadhdhi imettana wodey gakkis. ");
INSERT INTO gofRNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Denddidi yedhdhite; be7ite, tana aathi immanayssi gakkis” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesuusi hessa buroo odishin, tammanne nam77u iya tamaaretappe issoy, Yihudi, ellesidi gakki wodhdhis. Qassi kahine halaqati, higge asttamaaretinne cimati kiittin, mashshenne xam77a oykkida daro asay iyara issife yidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yesuusa aathi immanayssi he daro asaas, “Taani yeerey iya; iya oykkidi, loythi naagidi, ekki efite” yaagidi malla odi wothis. ");
INSERT INTO gofRNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Yihudi gakki wodhdhida mela Yesuusakko shiiqidi, “Asttamaariyaw” yaagidi Yesuusa yeeri ekkis. ");
INSERT INTO gofRNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","He daro asay Yesuusa oykkidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Shin matan eqqidayssatappe issoy ba mashshaa shoddidi kahine halaqaa aylliya shocidi, iya haytha qanxidi holis. ");
INSERT INTO gofRNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yesuusi zaaridi, he shiiqida daro asaakko, “Tana pangga kessidi, pangga oykkeyssada oykkanaw mashshenne xam77a oykkidi yidetii? ");
INSERT INTO gofRNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Taani Xoossa Keethan tamaarssashe, gallas gallas hinttera de7iya wode tana oykkibeekketa, shin Geeshsha Maxaafay gidayssi polettanaw bessees” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Iya tamaareti ubbay iya yeggi aggidi baqatidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Laxana xalaala ma77ida issi naatetha uray Yesuusa kaalleyssa asay oykkis. ");
INSERT INTO gofRNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Shin he uray laxana yeggi aggidi, xire kallo baqatis. ");
INSERT INTO gofRNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Asay Yesuusa kahine halaqaa soo efidosona. Yan kahine halaqati, cimatinne higge asttamaareti shiiqidi de7oosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Phexiroosi kahine halaqaa zabbaa gakkanaw haahon iya kaalli bidi yan naageyssatara uttidi tama kayees. ");
INSERT INTO gofRNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Kahine halaqatinne shiiqida asa ubbay Yesuusa wodhanaw iya bolla markka koyidosona, shin aykkoka demmibookkona. ");
INSERT INTO gofRNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Daro asati iya bolla worddo markkattidosona, shin entta markkatethay issino gidenna. ");
INSERT INTO gofRNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","58","Issi issi asati denddi eqqidi Yesuusa bolla, “I, ‘Taani asi keexida ha Xoossa Keetha laallada, asa kushen keexettiboonna hara Xoossa Keetha heedzu gallasa giddon keexana’ gishin nuuni si7ida” yaagidi worddo markkattidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Gidoshin, entta markkatethay hessankka issino gidenna. ");
INSERT INTO gofRNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Kahine halaqay asa ubbaa sinthan denddi eqqidi, “Hayssati nena mootiya mootuwas ne zaariyabay baawe?” yaagidi Yesuusa oychchis. ");
INSERT INTO gofRNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Shin Yesuusi si77i gis; aykkoka zaaribeenna. Kahine halaqay, “Anjjettida Xoossaa Na7ay, Kiristtoosi neneyye?” yaagidi zaari oychchis. ");
INSERT INTO gofRNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesuusi zaaridi, “Ee tana, hintte Asa Na7ay, wolqqaama Xoossaafe ushachcha baggara uttidashin qassi saluwa shaarara yishin be7ana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Kahine halaqay ba ma7uwa peedhidi, “Nuna hara markka ay koshshii? ");
INSERT INTO gofRNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Hintte iya cashshaa si7ideta; hintte qofay aybee?” yaagis. Entti ubbay, “I hayqqanaw bessees” yaagidi iya bolla pirddidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Enttafe issoti issoti iya bolla cutethi oykkidosona. Iya ayfiyaa goozidi baqqishe, “Nena dechchiday oonee? Ane nuus oda!” yaagidosona. Naageyssati iya ekki efidi garaafidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Phexiroosi kahine halaqaa zabban garssa baggara de7ishin, kahine halaqaa macca aylletappe issinniya yaa yasu. ");
INSERT INTO gofRNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Phexiroosi tama kayeyssa be7ada, tishshi ootha xeellada, “Neenikka Naazirete Yesuusara de7aasa” yaagasu. ");
INSERT INTO gofRNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Shin Phexiroosi, “Ne geyssi aybeekko ta erikke, taw akeekettenna” yaagidi kaddis. Yaagi simmidi zago keyaa wode sohuwara kuttoy waassis. ");
INSERT INTO gofRNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","He aylliya Phexiroosa be7ada, iya matan eqqida asatakko, “Ha uraykka enttara de7ees” gada zaara odasu. ");
INSERT INTO gofRNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Shin Phexiroosi qassika kaddis. Guuthi gam77ishin, matan eqqida asati nam77antho Phexiroosakko, “Neeni Galiila biitta asi gidiya gisho tuma enttara de7aasa” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Shin Phexiroosi, “Taani hintte giya uraa erikke!” yaagidi bana qanggethinne caaqo oykkis. ");
INSERT INTO gofRNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Sohuwara kuttoy nam77antho waassi aggis. Phexiroosi Yesuusi iyaakko, “Neeni kuttoy nam77u toho waassanaappe sinthe heedzu toho tana kaddana” iyaakko gidayssa akeekidi daro yeekkis. ");
INSERT INTO gofRNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Wontta guura ellesidi kahine halaqati, cimati, higge asttamaaretinne Ayhude shanggoti ubbay shiiqidi maqettidosona. Entti Yesuusa qachchi efidi Philaaxoosas aathi immidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Philaaxoosi iyakko, “Neeni Ayhudeta kawo?” yaagidi oychchis. Yesuusi zaaridi, “Ne gadasa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Kahine halaqati Yesuusa daroban mootidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Shin Philaaxoosi zaaridi Yesuusakko, “New zaariyabay baawe? Entti ne bolla ay mela mootuwa ehiyakko be7ikki?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Shin Yesuusi harabaa zaaronna ixxin, Philaaxoosi malaalettis. ");
INSERT INTO gofRNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Philaaxoosas Paasika Baale bonchchiya gallasan asay koyaa issi uraa qashoppe billiya meezey de7ees. ");
INSERT INTO gofRNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","He wode issi Barbbaana giya uray ooshshu kessidi shemppo wodhida asatara issife qasho keethan de7ees. ");
INSERT INTO gofRNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Shiiqida daro asay Philaaxoosi kaseyssada oothana mela iya oychchidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Philaaxoosi asa zaaridi, “Taani hinttew Ayhudeta kawuwa billanayssa koyeetii?” yaagidi oychchis. ");
INSERT INTO gofRNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Hessa I giday, kahine halaqati Yesuusa qanaattidi aathi immidayssa eriya gishossa. ");
INSERT INTO gofRNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Shin kahine halaqati Yesuusa gisho Barbbaana billanaada, he shiiqida asay Philaaxoosa woossana mela asa maqqidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Philaaxoosi zaaridi, “Yaatin, ha hintte Ayhude kawo geyssa waato?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Asay Philaaxoosa bolla waassidi, “Masqaliya bolla iya kaqqa” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Philaaxoosi asaakko, “Ays? I ay iitabaa oothidee?” yaagis. Shin asay kaseyssafe gujji waassidi, “Masqaliya bolla iya kaqqa” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Philaaxoosi asaa ufayssanaw koyidi, Barbbaana asaas billis; yaatidi lisson Yesuusa garaafidi, masqaliya bolla kaqqana mela enttaw aathi immis. ");
INSERT INTO gofRNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Hessafe guye, wotaaddareti Yesuusa deriya haareyssa ooso keetha ekki efidi, hara wotaaddareta ubbaa issife xeegidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Qassi zo7o afilaa iya mayzidosona; aguntha kalachcha giigisidi, iya huu7en wothidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Hessafe guye, iyakko, “Ayhudeta kawuwaw mirinaw kawota” yaagidi, iyaw ziggidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Iya huu7iya xam77an shoccidosona; qassi iya bolla cuttidosona; gulbbatidi iyaw goynnidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Iya toochchidayssafe guye zo7o afilaa iyappe qaari ekkidi, iya afilaa iya mayzidi masqaliya bolla iya kaqqanaw ekki efidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Entti bishe, Iskkinddirenne Rufoosa aawa, Simoona giya Qereena biitta asi, gaxareppe katama yeyssara gahettidi, Yesuusa masqaliya wolqqan toossidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Yaatidi Golggotta giya bessaa Yesuusa efidosona. “Golggotta” guussay “Huu7e guugge” guussu. ");
INSERT INTO gofRNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Sakoy si7ettonna mela karbbe giya dhaley walakettida woyne uyo gidi iyaw immidosona. Shin I uyonna ixxis. ");
INSERT INTO gofRNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Entti masqaliya bolla iya kaqqidosona. Oona aybi gakkaneekko gidi iya afilaa shaakkidi saama yeggidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Entti masqaliya bolla iya kaqqiya wode wonttafe heedzu saate. ");
INSERT INTO gofRNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Entti, “Ayhudeta kawuwa” yaagidi iya mootiya xuufe xaafidi wothidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Yesuusara nam77u panggata issuwa iyappe ushachcha baggara hankkuwa iyappe haddirssa baggara masqaliya bolla kaqqidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Geeshsha Maxaafay, “Iitabaa oothida asatara I paydettis” geetettidayssi polettis. ");
INSERT INTO gofRNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ogiyara aadhdhiya asay Yesuusa kadhidi, bantta huu7iya qaathiddi cayidosona; “Hekko! Xoossa Keetha laallada heedzu gallasa giddon keexeysso, ne huu7iya ashsha; ");
INSERT INTO gofRNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","ane masqaliya bollafe wodhdha” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Hessadakka, kahine halaqati higgiya tamaarsseyssatara issife Yesuusa toochchidi, “Harata ashshis, shin bana ashshanaw dandda7enna; ");
INSERT INTO gofRNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","nuuni be7idi ammanana mela Kiristtoosi, Isra7eele Kawoy, ane masqaliya bollafe ha77i wodhdho” yaagidosona. Qassi hari attoshin, iyara masqaliya bolla kaqettidayssatikka iya toochchidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Usuppun saateppe doomidi, uddufun saate gakkanaw biitta ubbay dhumis. ");
INSERT INTO gofRNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Uddufun saatiyan Yesuusi ba qaala dhoqqu oothidi, “Elohee, Elohee, laama sabaqitani?” yaagis. Hessa guussay, “Ta Xoossaw, ta Xoossaw, tana ays aggadi?” guussu. ");
INSERT INTO gofRNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Hessan eqqida asappe issoy issoy hessa si7idi, “Hekko, Eliyaasa xeegees” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","He asappe issoy woxxidi, ispponjjen caala woyne kunthis; hessa xam77a xeeran wothidi, “Naagite; Eliyaasi masqaliyappe iya wodhisanaw yaanekko ane be7oos” yaagidi Yesuusa doonaakko ushshanaw shiishis. ");
INSERT INTO gofRNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yesuusi ba qaala dhoqqu oothi waassidi, hayqqis. ");
INSERT INTO gofRNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Xoossa Keethan kaqettida magaraajjoy qommofe duge gakkanaw, nam77u keyidi daaketi wodhdhis. ");
INSERT INTO gofRNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Masqaliyappe sintha baggara yan eqqida issi mato halaqay, Yesuusi waanidi hayqqidaakko be7ida wode “Ha uray tuma Xoossaa Na7a” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Hessa haahon eqqidi be7iya guutha maccasati de7oosona. Entta giddon Magdela Mayraama, kaaluwa Yayqoobanne Yoosa aayyaa Mayraamanne Salooma de7oosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","He macca asati Yesuusi Galiilan de7iya wode iya kaallidayssatanne iya mokkidayssata qassi Yesuusara issife Yerusalaame bida hara daro macca asati yan de7oosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Sa7ay omarssida wode shiiqida asan bonchchettida Ayhude shanggotappe issoy, Yoosefa giya uray, Xoossaa kawotethay yaanayssa naagishe de7eyssi, Armmatiyasa katama asi de7eyssi yis. Wonttethe Sambbaatas giigettiya gallas gidida gisho Yoosefi minnidi Philaaxoosakko bidi, Yesuusa ahaa ekkanaw woossis. ");
INSERT INTO gofRNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Philaaxoosi Yesuusi hayqqidayssa si7ida wode malaalettis; mato halaqaa xeegidi, “I hayqqidi gam77idee?” yaagidi oychchis. ");
INSERT INTO gofRNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Philaaxoosi Yesuusi hayqqidayssa mato halaqaappe si7idi iya ahaa Yoosefas immis. ");
INSERT INTO gofRNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yoosefi moogo afila shammis; Yesuusa ahaa masqaliyappe wothidi, afilan xaaxidi, shuchchafe woocettida duufo giddon iya aha moogis. Qassi he duufuwa doonan gita shuchchu gonddorssidi wothis. ");
INSERT INTO gofRNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Magdela Mayraamanne Yoosa aayyaa Mayraama Yesuusa ahaa entti awun wothiyako be7oosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sambbaatay aadhdhidaappe guye Magdela Mayraama, Yayqooba aayyaa Mayraamanne Salooma bidi, Yesuusa ahaa tiyanaw shitto shammidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Wogga wode wontta daro guura xalqey caarshin, duufuwa bidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Entti bantta giddon issoy issuwara, “Duufuwa doonappe nuus shuchchaa oonee gonddorssidi digganay?” yaagidi odettidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Entti xeelliya wode he daro gita shuchchay gonddorettidi kichchidayssa be7idosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Yesuusi moogettida duufuwa giddo geliya wode issi pantha addey bootha ma7o ma77idi, ushachcha baggara uttidayssa be7idi dagammidosona. ");
INSERT INTO gofRNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Shin I enttako, “Dagammofite; masqaliya bolla kaqettida, Naazirete Yesuusa hintte koyeyssa taani erays. I hayssan deenna, hayqoppe denddis. Entti iya moogida bessaa hayssa be7ite. ");
INSERT INTO gofRNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ha77i bidi Yesuusa tamaaretasinne Phexiroosas, ‘Yesuusi hinttefe sinthattidi Galiila bees. I hinttew odidayssada hintte iya yan be7ana’ yaagidi odite” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Maccasati yashshan kokkorishe duufuwappe keyidi baqatidosona. Qassi entti yayyida gisho hessa ooddeskka aykkoka odibookkona. ");
INSERT INTO gofRNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yesuusi hayqoppe denddidaappe guye wogga gallas wontta, laappun tuna ayyaanata kessida Magdela Mayraamis koyrottidi benttis. ");
INSERT INTO gofRNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Iya bada kase iyara de7eyssatas, entti azzanishenne yeekkishe de7ishin odasu. ");
INSERT INTO gofRNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Shin Yesuusi paxa de7eyssanne iw benttidayssa entti si7ida wode iya geyssa ammanibookkona. ");
INSERT INTO gofRNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Hessafe guye, enttafe nam77ati katamaappe keyidi bishin, oge bolla Yesuusi kaseyssafe dummattidi enttaw benttis. ");
INSERT INTO gofRNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Entti guye simmidi, haratas odidosona, shin haratikka entta odaa tuma gibookkona. ");
INSERT INTO gofRNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Guyeppe tammanne issi iya tamaareti kathi miishin, Yesuusi enttaw benttis. Enttaw ammanoy baynna gishonne hayqoppe I denddidayssa be7ida asay odin entti ammanonna ixxida gisho I entta boris. ");
INSERT INTO gofRNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","I enttako, “Biitta ubbaa bidi asa ubbaas Wonggelaa odite. ");
INSERT INTO gofRNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ammaneynne xammaqetey attana, shin ammanonnay pirddettana. ");
INSERT INTO gofRNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ammaneyssatas ha malaatati imettana. Entti ta sunthan tuna ayyaanata kessana, ooratha doonan odettana. ");
INSERT INTO gofRNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Entti shooshu oykkikokka woykko wodhiyabaa uyikkoka entta qohenna. Qassi entti bantta kushiya hargganchchota bolla wothidi entta pathana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Goday Yesuusi tamaaretara odettidaappe guye pude salo keyis; Xoossaafe ushachcha baggara uttis. ");
INSERT INTO gofRNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Iya tamaareti bidaso ubban qaala odidosona. Godaykka enttara issife oothees. Entti odiya qaalay tuma gididayssa Xoossay enttaw immiya malaatatan erisis.");
INSERT INTO gofRNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Bonchcho Tewofiloosa, nu giddon polettidabas daroti, banttaw dandda7ettida mela xaafidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","He taarikiya entti xaafiday koyroppe doomidi ayfe markkatinne qaala haggaazeyssati nuus odidayssa. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Takka ta baggara koyroppe akeeka xeellidaappe guye he taarikiya hanotaa maarayada new xaafoy taw lo77o gidi benttis. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Hessika, ne tamaaridabay tuma gideyssa erisanaassa. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Yihuda kawuwa Heroodisa wode Abiya yaraappe gidida Zakkariyaasa giya Ayhude kahiney de7ees. Iya machchiyaka Aarona sheeshaappe. I sunthaykka Elssabeexo. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Nam77ayka Godaa wogaanne kiita ubbaa naagidi borey baynna Xoossaa sinthan xillotethan de7idosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Hanoppe attin Elssabeexa maynthi gidida gisho enttaw na7i baawa. Nam77ayka qassi cimidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Issi gallas Zakkariyaasi ba gishuwa maaran Xoossaa sinthan kahinetethan haggaazees. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Kahinetetha wogan Xoossa Keethi gelidi ixaane cuyisanaw iya saami gakkis. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ixaaney cuya wode asay karen woossees. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Godaa kiitanchchoy yarshshuwa yarshshiya bessaafe ushachcha baggara eqqidi benttis. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zakkariyaasi iya be7ida wode dagammidi daro yayyis. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Shin kiitanchchoy iyaakko, “Zakkariyaasa yayyofa; ne woosay si7ettis. Ne machchiya Elssabeexa adde na7a yelana, iya Yohaannisa gada ne sunthana. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","I new injjenne ufayssi gidana; daroti iya yeletethan ufayttana. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Godaa sinthan I gita gidana; woyne ushshaa gidin hara mathoya ushshaa uyenna. Ba aaye ulon de7ishe Geeshsha Ayyaanan kumana. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Isra7eele asatappe darota bantta Godaa, Xoossaakko zaarana. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Aawata wozana naytakko zaarana, kiitettonayssata xillota cinccatethaako zaarana mela, Godaas bessiya dere giigisanaw Eliyaasa ayyaananinne wolqqan Godaa sinthan baana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakkariyaasi kiitanchchuwako, “Ta hessa aybin eranee? Taaranne ta machcheera cimida” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Kiitanchchoy zaaridi, “Taani Xoossaa sinthan eqqiya Gabreele. Ha mishirachchuwa new odanaw Xoossaafe kiitetas. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Hekko, wodiya naagidi polettiya ta qaala ne ammanonna ixxida gisho hayssi polettana gakkanaw neeni muume gidana, odettanawukka dandda7akka” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","He wode Zakkariyaasi Xoossa Keethi gelidi gam77ida gisho aybi hanide gidi asay karen naagishe gam77is. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","I kare keyidi enttana odisanaw dandda7ibeenna. Malli besoppe attin odettanaw dandda7onayssa be7ida wode qonccethi be7idayssa eridosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Zakkariyaasi haggazo wodiya polidi ba soo simmis. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Hessafe guye, iya machchiya Elssabeexa qanthatasu. Ichchashu ageena kumethi bana geenthada gam77asu. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Iya, “Goday ba maarotan ta boriya asaa giddofe digganaw be7idi ha wodiyan hayssa oothis” yaagasu. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elssabeexa qanthatin usuppuntha ageenan, Xoossay kiitanchchuwa Gabreele Galiila biittan de7iya Naazirete katamaa kiittis. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Kawuwa Dawite sheeshaappe gidida Yoosefa giya uraas oyshettida geela7eekko kiittis. He geela7iya Mayraamo geetettawusu. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Kiitanchchoy iikko bidi, “Daro dosettidare, saroy new gido, Xoossay neera de7ees” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mayraama iya odan daro dagammada, “Hayssi aybi sarotho” gada heetasu. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Kiitanchchoy zaaridi, “Mayraame, babbofa; neeni Xoossaa sinthan saba demmadasa. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Hekko neeni qanthatana adde na7a yelana, iya sunthaaka Yesuusa gada sunthana. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","I gita gidana, Ubbaafe Bolla Xoossaa na7aa geetetti xeegettana. Godaa Xoossay iya aawa Dawite araata iyaw immana. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","I Yayqooba sheeshaa bolla merinaw kawotana; iya kawotethaas zawi baawa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mayraama kiitanchchuwako, “Hessi waanidi hananee? Ta adde erikke” yaagasu. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Kiitanchchoy zaaridi, “Geeshsha Ayyaanay ne bolla wodhdhana, Ubbaafe Bolla Xoossaa wolqqay ne bolla kuyattana. Hessa gisho, yelettiya geeshsha na7ay Xoossaa Na7aa geetettana. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Hekko, ne dabbiya Elssabeexa ba cimatetha laythan adde na7a qanthatasu. Iya maynthi geetettidaaro, shin ha77i usuppuntha ageena oykkasu. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Xoossaa xooniyabay baawa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mayraama, “Hekko, taani Godaa aylliw, ne qaalada taw hano” yaagasu. Hessafe guye, kiitanchchoy iippe shaakettis. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Mayraama he saaminttan denddada Yihuda biittan de7iya issi geze katama basu. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Zakkariyaasa soo gelada Elssabeexo sarothasu. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elssabeexa Mayraami sarothuwa si7ida wode I uluwan de7iya na7ay ufayssan guppis. Elssabeexa Geeshsha Ayyaanan kumada, ");
INSERT INTO gofRNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ba qaala dhoqqu oothada, “Neeni maccasaa giddofe anjjettidaaro, ne qanthatida na7aykka anjjettidayssa. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Hanoshin, ta Godaa aaye, neeni taakko yaana mela taani oonee? ");
INSERT INTO gofRNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Hekko ne sarothuwa ta si7ida wode ta uluwan de7iya na7ay ufayssan guppis. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Goday polana gidi immida qaala ammanidaara, iya anjjettidaaro” yaagasu. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mayraama hayssada yaagasu: “Ta shemppiya Godaa bonchchawusu, ");
INSERT INTO gofRNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ta Ayyaanay dhaliya Xoossan ufayttees. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","I ba aylle kawushshatethaa be7is. Hachchife doomidi yeletethi ubbay tana anjjettidaaro gaana. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Ays giikko, wolqqaama gidida I, taw gitabaa oothis. Iya sunthay Geeshshaa. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Iya bonchcheyssata bolla, iya maarotethay merinaappe merinaa gakkanaassa. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ba qesiyan minobaa oothis, bantta wozanan otortteyssata laallis. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Wolqqaama kawota araataappe kawushshis; banttana kawushshidayssata kabboys. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Koshattidayssata lo77oban kalssis, shin dureta mela kushe yeddis. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ba maarota qoppidi, Ba aylliya Isra7eele maaddis. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Hessika nu aawatas odida qaalaa, Abrahamesinne iya sheeshas gidayssa merinaw polanaassa” yaagasu. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mayraama Elssabeexi matan heedzu ageena mela gam77ada ba soo simmasu. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elssabeexis yelo qammay gakkin adde na7a yelasu. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","I shoorotinne I dabboti Goday gita maarota oothidayssa si7idi, iira issife ufayttidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Hosppuntha gallasan yooga na7aa qaxxaranaw yidosona. Iya aawa sunthan Zakkariyaasa gidi sunthanaw koyidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Shin aayyaa, “Akkay, Yohaannisa geetettanaw bessees” yaagasu. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Enttika, “Ne dabbotappe ha sunthan xeegettiday oonikka baawa” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Iya aaway oona gidi sunthaneekko eranaw koyidi iya malla oychchidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","I xaafiyabaa oychchi ekkidi, “Iya sunthay Yohaannisa” gidi xaafis. Ubbay I xaafidayssa be7idi malaalettidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Iira Zakkariyaasa inxarssay bilettis, Xoossaa galatishe odetethi oykkis. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Shooroti ubbay yashshan kumidosona. Ha hanidabay geze Yihuda biittan odettis. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Hessa si7ida ubbay, “Ha na7ay ay hananddeshsha” gidi bantta giddon odettidosona. Godaa kushey iyara de7ees. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Yohaannisa aaway Zakkariyaasi Geeshsha Ayyaanan kumidi hayssada yaagidi tinbbite odis. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Isra7eeliya Goday galatetto, yidi ba asaa wozis. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ba aylliya Dawite keethan atotethaa kaciya denthis. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Hessika beni wode geeshsha nabeta doonan odettidayssa mela, ");
INSERT INTO gofRNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Iya ashoy nu morkketappenne nuura eqettiya ubbaa kushiyappe. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Hessa I oothiday nu aawatas ba maarota bessanaasinne, ba geeshsha caaquwa naaganaassa. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Nu aawa Abrahames caaqqida caaquwa qoppanasinne ");
INSERT INTO gofRNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","nu morkketa kusheppe kessidi yashshi baynna iya haggaazana melassa. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Nu laytha ubban geeshshatethaninne xillotethan ba sinthan nuna essanaassa. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Qassi laa na7aw, neeni Ubbaafe Bolla Xoossaa nabe geetettana. Godaa ogiya loythanaw ne iya sinthan baana. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Entta nagaray qushettin, entti atotethi demmanayssa ne Godaa deriyas odana. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Nu Xoossaa lo77o maarotethaafe denddoyssan wontta xalqey nuus saluwappe keyis. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Hessika dhumaninne, hayqo kuya garssan de7eyssatas poo7isanaassa, nu tohuwakka saro ogiyakko zaaranaassa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Na7ay diccis, Ayyaanan minnis, Isra7eele asaas qonccana gakkanaw bazzo biittan de7is. ");
INSERT INTO gofRNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","He wode Roome biittan de7iya asa ubbay taybettana melanne sunthay xaafettana mela kawoy Awugisxoosi kiittis. ");
INSERT INTO gofRNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Hessika Qerenoosi Soore biittaa aysiya wode oosettida koyro taybuwa. ");
INSERT INTO gofRNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Hessa gisho, issi issi asi ba sunthaa xaafettanaw ba yelettida biittaa bis. ");
INSERT INTO gofRNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yoosefikka Dawite keethaafenne yaraappe gidida gisho Galiila Naazirete katamaappe denddidi Dawite katama gidida Yihuda Beeteleme bis. ");
INSERT INTO gofRNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Bishe, yelanaw wodey wurida I oychchi wothida, Mayraamira wolla xaafettanaw bis. ");
INSERT INTO gofRNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Entti yan de7ishin iw yelo wodey gakkis. ");
INSERT INTO gofRNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ba bayra na7aa yelasu. Curqqara xaaxada imathi aqiyason bessi dhayida gisho daran mehe muziya gonggen zin77isasu. ");
INSERT INTO gofRNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","He gadiyan qamma dorssa wudiya naagishe karen aqiya henthanchchoti de7oosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Godaa kiitanchchoy hassayonna yidi entta matan eqqis. Godaa bonchchoy entta yuushuwan poo7is; enttika wolqqaama yashshi yayyidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Shin kiitanchchoy, “Yayyofite! Hekko, asaa ubbaas gidiya gita ufayssaa mishirachchuwa ekkada yas. ");
INSERT INTO gofRNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Hessika, Dawite kataman ashsheyssi hinttew hachchi yelettis. I Godaa Kiristtoosa. ");
INSERT INTO gofRNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Zoqale na7ay curqqara xaaxettidi gonggen zin77idayssa hintte demmana; hessika hinttew malla gido” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Qopponna daro salo kiitanchchoti kiitanchchuwura issife qonccidi, ");
INSERT INTO gofRNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Bonchchoy Xoossaas dhoqqa saluwan, saroy biitta bolla Xoossay dosiya asaas gido” yaagidi galatidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Kiitanchchoti enttafe shaakettidi saluwa keyidaappe guye henthanchchoti, “Ane Goday nuus qonccisidabaanne hanidabaa be7anaw Beeteleme boos” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Enttika ellesidi bidosona. Mayraamo, Yoosefanne zoqale na7aa gonggen zin77idayssa be7idosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Be7i simmidi na7abaa enttaw odettoyssa, qonccisidi he bessan de7iya asaas markkattidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Hessa si7ida ubbay henthanchchoti odidayssan malaalettidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mayraama hanidabaa ubbaa ba wozanan qoppashe de7asu. ");
INSERT INTO gofRNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Henthanchchoti enttaw odettidayssada hanin be7idosona. Hessa gisho, bantta si7idabaasinne be7idaba ubbaas Xoossaa bonchchishenne galatishe simmidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Hosppuntha qamman, qaxxaro wodey gakkin, I qanthatanaappe sinthe kiitanchchoy wothida sunthan Yesuusa geetettis. ");
INSERT INTO gofRNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Muse woga mela entta geeshshatetha wodey polettidaappe guye Yoosefaranne Mayraamira yooga na7aa bantta Godaas immanaw Yerusalaame bidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Hessika, Godaa wogan, “Adde gidida bayra na7i ubbay Godaas dummattidayssa gido” geetettidi xaafettidayssa polanaassa. ");
INSERT INTO gofRNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Qassi Godaa wogan, nam77u kuraachcho woykko holle yarshshanaw efidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","He wode geeshshinne ammanora mino gidida Simoona geetettiya asi Yerusalaamen de7ees. I Isra7eeleta atotethaa naagishe de7ees. Geeshsha Ayyaanaykka iya bolla de7ees. ");
INSERT INTO gofRNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Qassi Kiristtoosa be7onna hayqqonnayssa Geeshsha Ayyaanay iyaw qonccisin eridi de7ees. ");
INSERT INTO gofRNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","I he gallas Ayyaanay kaalethin Xoossa Keethi bis. Na7aa aayeranne aawara wogaa polanaw yooga na7aa Yesuusa ekkidi gelida wode ");
INSERT INTO gofRNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simooni mokki ekkidi na7aa idimmidi, ");
INSERT INTO gofRNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Godaw ne taw gelida qaala mela, ha77i ne aylliya saron moyza. ");
INSERT INTO gofRNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ta ayfey asaa ubbaa sinthan ne giigisida, ");
INSERT INTO gofRNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ne ashuwa be7is. ");
INSERT INTO gofRNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Hessika kawotethata ubbaas, Xoossaa ogiya qonccisiya poo7o, ne asaa Isra7eeleskka bonchcho” yaagidi Xoossaa galatis. ");
INSERT INTO gofRNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Yoosefaranne Mayraamira iyaw odettidaban malaalettidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simooni entta anjjis. Aaye Mayraamikko, “Hekko daro asaa wozanaa qofay qonccana mela, Isra7eelen de7iya darotas entta kunddethaasinne dendduwas Xoossan doorettis. ");
INSERT INTO gofRNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Qassi eqetteyssatas malla gidana. Ne shemppuwarakka qassi mashshi aadhdhana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Qassi Aseere yaraappe gidida Faanu7ela na7iya Haanna geetettiya nabey de7awusu. Iya daro cimasu; iya ba koyro azinaara laappun laythi de7asu. ");
INSERT INTO gofRNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","I azinay hayqqin hosppun tammanne oyddu laythi gidana gakkanaw qammanne gallas pacey baynna woosaninne xooman Xoossa Keethan haggaazasu. ");
INSERT INTO gofRNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Iya he saatiyan bada Xoossaa galatasu; Yerusalaame wozetethaa naagiya ubbaas yooga na7abaa markkattasu. ");
INSERT INTO gofRNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Yoosefaranne Mayraamira Godaa higgiyan kiitettida woga ubbaa polidaappe guye Galiila biittan de7iya bantta katama Naazirete simmidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Na7ay diccishenne minnishe bis. Cinccatethan kumis; Xoossaa aadho keehatethay iya bolla de7ees. ");
INSERT INTO gofRNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Yoosefaranne Mayraamira Faasikka Baale bonchchanaw laythan laythan Yerusalaame boosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yesuusas tammanne nam77u laythi gidiya wode kase meezetidayssada baaliya bonchchanaw bidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Baaliya bonchchidaappe guye soo simmiya wode na7ay Yesuusi Yerusalaamen attis. Shin Yoosefaranne Mayraamira I Yerusalaamen attoyssa eribookkona. ");
INSERT INTO gofRNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","I soo simmiya asaara wolla de7iya daanin entti issi gallasa oge bidosona. I baynnayssa eridaappe guye bantta dabbotanne laggeta matan koyidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","I yan dhayin koyishe guye Yerusalaame gakkanaw bidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Heedzu gallasappe guye Xoossa Keethan asttamaareta giddon uttidi enttabaa si7ishenne entta oychchishe de7ishin demmidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Iya si7iya ubbay iya akeekaninne zaaruwan malaalettidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Soo asay iya demmida wode malaalettidosona. Iya aayyaakka, “Ta na7aw, ays nuna hayssada oothadii? Ne aawaranne taara nena koyishe un77ettida” yaagasu. ");
INSERT INTO gofRNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Yesuusi enttako, “Tana ays koyeetii? Ta, ta aawa keethan daanaw besseyssa erekketii” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Shin I enttako gidabaa entti akeekibookkona. ");
INSERT INTO gofRNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Hessafe guye, enttara issife Naazirete katama bis. Enttaw kiitettishe de7is. Iya aayyaa he ubbaa ba wozanan wothada naagasu. ");
INSERT INTO gofRNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesuusi, cinccatethan, geesaninne teeman Xoossaa sinthaninne asa sinthan diccis. ");
INSERT INTO gofRNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Kawoy Xibaaryoosi Roome biittan kawotin, tammanne ichchashantho laythan, Phenxe Philaaxoosi Yihuda haariya wode Heroodisi Galiila haariya wode iya ishaa Filphoosi Ixuuriyasanne Xirakkonddoosa haariya wode Lisaniyoosi Ablaanisa haariya wode ");
INSERT INTO gofRNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Haannaranne Qayyaafara kahine halaqa gidi de7ishin, Xoossaa qaalay Zakkariyaasa na7aa Yohaannisakko bazzo biittaa yis. ");
INSERT INTO gofRNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Yohaannisi, “Hintte nagaraappe simmitenne xammaqetite. Xoossay hintte nagaraa atto gaana” yaagidi tamaarssishe Yorddaanose Shaafaa heeran de7iya biitta ubbaa bis. ");
INSERT INTO gofRNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Hessika nabey Isayaasi ba maxaafan, “Bazzo giddon ba qaala dhoqqu oothidi, waassiya uraa qaalay, ‘Godaa ogiya giigisite, horogaakka piddi oothite. ");
INSERT INTO gofRNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Aafo ubbay kumana, zumaynne derey ziqqi gaana. Wobbe ogey luulana, giigonna horogay qinxi gaana. ");
INSERT INTO gofRNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Asho ma77ida ubbay, Xoossaa ashuwa be7ana’ ” gidi xaafidayssada hanis. ");
INSERT INTO gofRNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Yohaannisi, ba kushen xammaqettanaw yida asaakko, “Hinttenoo, shoosha nayto yaanaw de7iya hanquwafe attana mela hinttena zoriday oonee? ");
INSERT INTO gofRNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Hiza, hintte simuwa qonccisiya lo77o ooso oothite, hintte wozanan, ‘Nuus, nu aaway Abrahamey de7ees gidi ceeqettofite.’ Haa si7ite, ha shuchchatappe Xoossay Abrahames na7a kessanaw dandda7ees. ");
INSERT INTO gofRNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Hekko, beexey mithaa xaphon de7ees. Hiza, lo77o ayfe ayfonna mitha ubbay qanxettidi taman yegettana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Asay, “Yaatin nuuni ay oothinoo?” yaagidi oychchidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yohaannisi zaaridi, “Nam77u afili de7iya asi baynnayssas immo. Kathi de7eyssi baynnayssas immo” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Qaraxa qanxiseyssati xammaqettanaw yidi, “Asttamaariyaw, nuuni ay oothinoo?” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","I zaaridi, “Hintte qanxisanaw kiitettoyssafe aathidi ekkofite” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Qassi wotaaddareti yidi, “Nuuni ay oothinoo” yaagidi oychchidosona. Yohaannisi, “Ooddebaakka wolqqan dafidi ekkofite, oonakka worddon mootoppite, hintte damoozey hinttew gido; ufayttidi de7ite” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Asay Kiristtoosa naagishe de7iya gisho Yohaannisa, “I Kiristtoosa gidanddeshshaa?” gidi qoppidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yohaannisi ubbaas zaaridi, “Taani hinttena haathan xammaqays, shin taappe aadhdhidi wolqqaameyssi yaana. Taani iya caammaa wodoruwa billanaw bessonna asi. I hinttena Geeshsha Ayyaananinne taman xammaqana. ");
INSERT INTO gofRNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Wudumman de7iya kathaa polo geeshshanaw pithey iya kushen de7ees. Geeshsha kathaa ba shaaliyan qolana; kaliya dhayonna taman xuuggana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Qassi Yohaannisi asaa daro zore zoridi Wonggelaa odis. ");
INSERT INTO gofRNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Shin Yohaannisi Heroodisi ba ishaa machchiw, Heroodiyada, ekkida gishonne haraa iita oosota gisho kaccida wode ");
INSERT INTO gofRNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Heroodisi kaseyssa bolla haraba ubbaa gujjidi Yohaannisa woyne gelssis. ");
INSERT INTO gofRNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Yohaannisi qashettanaappe sinthe asaa ubbaa xammaqidi simmin, Yesuusikka qassi xammaqettis. I woossishin saloy dooyettis. ");
INSERT INTO gofRNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Geeshsha Ayyaanay holleda benttishe iya bolla uttis. Saloppe “Taani dosiya na7ay nena; ne tana ufayssaasa yaagiya” qaalay yis. ");
INSERT INTO gofRNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesuusi tamaarsso oykkiya wode iyaw hasttamu laythi gidishin, asay iya Yoosefa na7a gidi qoppis. Yoosefi Eele na7a, ");
INSERT INTO gofRNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eeley Maate na7a, Maatey Leewe na7a, Leewey Malkka na7a, Malkkey Yoona na7a, Yooni Yoosefa na7a, ");
INSERT INTO gofRNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yoosefi Mataate na7a, Mataatey Amoxe na7a, Amoxey Nahoome na7a, Nahoomey Asiliime na7a, Asiliimey Naage na7a, ");
INSERT INTO gofRNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Naagey Ma7aate na7a, Ma7aatey Mataatiye na7a, Mataatiyey Samaye na7a, ");
INSERT INTO gofRNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Samayey Yihuda na7a, Yihudi Yoonane na7a, Yoonaney Rase na7a, Rasey Zerubaabela na7a, Zerubaabeley Salatiyaale na7a, Salatiyaaley Neere na7a, ");
INSERT INTO gofRNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neerey Malkka na7a, Malkkey Haade na7a, Haadey Qoosame na7a, Qoosamey Elmodaane na7a, Elmodaaney Eere na7a, ");
INSERT INTO gofRNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Eerey Yoose7e na7a, Yoose7ey Alaazara na7a, Alaazari Yoorame na7a, Yooramey Maate na7a, Maatey Leewe na7a, ");
INSERT INTO gofRNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Leewey Simoona na7a, Simooni Yihuda na7a, Yihudi Yoosefa na7a, Yoosefi Yoonane na7a, Yoonaney Eliyaaqeme na7a, ");
INSERT INTO gofRNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliyaaqemey Maliyye na7a, Maliyyey Maynaane na7a, Maynaaney Maate na7a, Maatey Naatane na7a, Naataney Dawite na7a, ");
INSERT INTO gofRNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dawitey Isseyye na7a, Isseyyey Iyobeede na7a, Iyobeedey Boo7eza na7a, Boo7ezi Salmoona na7a, Salmooney Na7asoona na7a, ");
INSERT INTO gofRNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Na7asooney Aminaadabe na7a, Aminaadabey Raame na7a, Raamey Arnne na7a, Arnney Asroome na7a, ");
INSERT INTO gofRNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Asroomey Faarese na7a, Faaresey Yihuda na7a, Yihudi Yayqooba na7a, Yayqoobi Yisaaqa na7a, Yisaaqi Abrahame na7a, Abrahamey Taara na7a, ");
INSERT INTO gofRNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Taari Naakkore na7a, Naakkorey Saruuge na7a, Saruugey Rehu na7a, Rehuy Faaleqe na7a, Faaleqey Ebeera na7a, Ebeeroy Seela na7a, ");
INSERT INTO gofRNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Seeli Qaynaame na7a, Qaynaamey Arfakisaada na7a, Arfakisaadey Seeme na7a, Seemey Nohe na7a, Nohey Laamehe na7a, ");
INSERT INTO gofRNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Laamehey Matusaala na7a, Matusaali Heenoke na7a, Heenokey Yaarede na7a, Yaaredey Malaal77ela na7a, Malaal77eli Qaynaane na7a, ");
INSERT INTO gofRNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Qaynaaney Heenosa na7a, Heenosey Seeta na7a, Seetey Addaame na7a, Addaamey Xoossaa na7a. ");
INSERT INTO gofRNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesuusi Geeshsha Ayyaanan kumidi Yorddaanose Shaafappe simmida mela Ayyaanay iya bazzo efis. ");
INSERT INTO gofRNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Yan oytamu gallasinne qamma xalahen paacettis. He gallasatan aykkoka moonna gam77ida gisho wurssethan koshattis. ");
INSERT INTO gofRNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Xalahey iyaakko, “Neeni Xoossaa na7a gidikko ane hayssi shuchchay uythu gido gada kiitta” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yesuusi zaaridi, “Asi uytha xalaalan deenna geetettidi xaafettis” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Hessafe guye, Xalahey Yesuusa adussa dere bolla kessidi ha alamiya kawotethata ayfe qiphi zaaranaw bessis. ");
INSERT INTO gofRNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Xalahey, “Ha ubbaas maataynne bonchchoy taw imettis. Taani dosida ooddeskka immiya gisho new immana. ");
INSERT INTO gofRNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Hessa gisho, neeni taw goynniko ubbay new gidana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yesuusi zaaridi, “Ne Godaa, ne Xoossaa, iya xalaala goynna geetettidi xaafettis” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Wurssethan Xalahey Yesuusa Yerusalaame efidi Xoossa Keethas huu7iya bolla essidi, “Neeni Xoossaa na7a gidikko ane duge sa7an nena yegga. ");
INSERT INTO gofRNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Ays giikko, ‘Nena naagiya Kiitanchchota Xoossay ne gisho kiittana. ");
INSERT INTO gofRNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Entti ne tohoy shuchchan dhubettonna mela, bantta kushiyan dhoqqu oothidi nena denthana’ geetettidi xaafettis” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yesuusi zaaridi, “Ne Godaa Xoossaa paaccofa geetettidi xaafettis” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Xalahey Yesuusa paaciya wurssidaappe guye hara injje wode demmana gakkanaw iyappe shaakettis. ");
INSERT INTO gofRNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yesuusi Ayyaana wolqqan kumidi Galiila simmis. Iya sunthay heeran de7iya biitta ubban keyis. ");
INSERT INTO gofRNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","I Ayhude Woosa Keethi gelidi tamaarssis; asa ubbay iya galatidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yaappe I diccida katamaa Naazirete yis. Kase meezetidayssada Sambbaata gallas Ayhude Woosa Keethi gelis. Nabbabanawukka denddi eqqis. ");
INSERT INTO gofRNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Nabiya Isayaasa maxaafay iyaw imettin, dooyidi, hayssada yaagidi xaafettidayssa demmis: ");
INSERT INTO gofRNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Godaa Ayyaanay ta bolla de7ees, manqotas Wonggelaa odana mela Xoossay tana dooris. Qashettidayssatas biletethi, qooqidayssata xeelisanaasinne un77ettidayssata birshshana mela, ");
INSERT INTO gofRNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Xoossay keehanaw qoppida laythaa odana mela tana kiittis” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Hessafe guye, maxaafaa xaaxidi haggaazeyssas immidi tamaarssanaw uttis. Ayhude Woosa Keethan de7iya asati ubbay caddi xeellosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","I, “Hayssi hintte haythan hintte si7iya ha maxaafaa qaalay hachchi polettis” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ubbay iyabaa darssidi odettoosona. Qassi iya doonappe keyaa aadho keehatethan kumida qaalan malaalettishe, “Hayssi Yoosefa na7aa gidenneyye?” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","I, “ ‘Neno dhale aawaw nena ashsha, Qifirnahoomen ne oothidabaa nu si77oyssa qassi hayssan ne kataman ootha’ yaagiya leemisuwan hintte tana gaanayssas sidhey baawa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Qassi, “Tuma odays; nabey ba yelettida biittan bonchchettena. ");
INSERT INTO gofRNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","“Ta hinttew tuma odays; saloy heedzu laythinne bagga gorddettin mino koshi biitta ubban de7iya Eliyaasa wode daro am77eti Isra7eelen de7oosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Eliyaasi enttafe issinnekokka kiitettibeenna. Shin Sarapttan de7iya am77eeko kiitettis. ");
INSERT INTO gofRNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Nabiya Elssa7e wode Isra7eelen daro baro hargganchchoti de7oosona. Shin Soore uraa Ni7imaaneppe attin oonikka paxibeenna” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ayhude Woosa Keethan de7iya asa ubbay hessa si7ida wode daro yilotidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Bantta uttida bessaafe denddidi zuma bolla keexettida katamaappe gaxa kessidi sugi yeddanaw aafo doona efidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Shin I entta giddora kanthidi aadhdhis. ");
INSERT INTO gofRNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Yaappe Galiila biittan de7iya Qifirnahoome katamaa bis. Yan Sambbaata gallas asaa tamaarssis. ");
INSERT INTO gofRNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","I tamaarssey maatara gidiya gisho ubbay iya timirttiyan malaalettidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ayhude Woosa Keethan tuna ayyaanay oykkida uray de7ees. ");
INSERT INTO gofRNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","I, “Naazirete Yesuusa nuna ays waaysay nuuppe haakka; neeni yiday nuna dhayssanaaseyye? Neeni ooneekko taani erays. Neeni Xoossaafe yida Geeshsha” yaagidi waassis. ");
INSERT INTO gofRNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yesuusi tuna ayyaanaakko, “Si7i gada ha uraappe keya” yaagidi hanqis. Tuna ayyaanay uraa asaa ubbaa sinthan holi yeggidi aykkoka qohonna yeddidi keyis. ");
INSERT INTO gofRNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Asa ubbay malaalettidosona. Wolikko, “Hanos, hayssi aybi timirtte? Tuna ayyaanata maataninne wolqqan kiittees; enttika keyosona” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Iya sunthay heera ubban keyis. ");
INSERT INTO gofRNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Hessafe guye, Yesuusi Ayhude Woosa Keethafe keyidi Simoona soo gelis. Simoona machche aayyaa mino qoxo misha harggen sakettasu. Iyo pathana mela Yesuusa woossidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","I hiixaakko shiiqi hokkidi I harggiya hanqis. Mishay aggin ellesa denddada entta mokkasu. ");
INSERT INTO gofRNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Away wullana hanishin dumma dumma harggiyan oykettida asaa iyaakko ehidosona. I issuwa issuwa bolla ba kushiya wothidi pathis. ");
INSERT INTO gofRNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Tuna ayyaanati qassi, “Neeni, Xoossaa na7aa” gidi waassishe daro asaappe keyidosona. Shin I enttana hanqis. I Kiristtoosa gideyssa entti eriya gisho issibaakka odettonna mela diggis. ");
INSERT INTO gofRNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Buroo wonttiya wode Yesuusi issi geema bessi bis. Asay koyishe I de7iya bessaa yidosona. Enttafe I shaakettidi boonna mela butetidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Shin I, “Taani hara katamata bada Xoossaa kawotethaa Wonggelaa markkattanaw bessees. Ta kiitettiday hessassa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Yihuda biittan de7iya Ayhude Woosa Keethan sabbakis. ");
INSERT INTO gofRNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Issi gallas Yesuusi Gensareexe Abbaa matan eqqidashin daro asay iya yuushuwa un77ethidi, I tamaarssiya Xoossaa qaala si7oosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Yan haatha gaxan de7iya nam77u wogolota be7is. Molo oykkiya asati wogolotappe wodhdhidi bantta gitiya meeccosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","He wogolotappe Simoonayssan gelidi biittaafe guuthi giddo shiishana mela oychchis. Yaatidi, he wogoluwa bolla uttidi asaa tamaarssis. ");
INSERT INTO gofRNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ba tamaarssuwa onggidaappe guye Simoonakko, “Gede ciimmuwako shiishada moluwa oykkanaw hintte gitiya yeggite” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simooni zaaridi, “Asttamaariyaw, qamma kumethaa daaburishe aqidi aykkoka oykkibookko, shin ne giikko gitiya yeggana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Entti gitiya yeggida wode gitey daakettana gakkanaw daro molo oykkidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Hara wogoluwan de7iya bantta laggeti yidi, banttana maaddana mela wuttidi xeegidosona. Entti yidi nam77u wogolota, haathan mitettana gakkanaw molon kunthidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simoon Phexiroosi hessa be7ida wode Yesuusa sinthan kunddidi, “Godaw, taani nagaranchcho asi gidiya gisho taappe shaaketta” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Hessa I giday inne iyara de7eyssati oykkida moluwa darotethan malaalettida gishossa. ");
INSERT INTO gofRNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Qassi Simoona lagge gidida Zabdiyoosa nayti Yayqoobaranne Yohaannisara malaalettidosona. Yesuusi Simoonakko, “Babbofa! Hizappe neeni ase oykkiya asi gidana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Entti wogolota gaxa shiishidaappe guye ubbaa aggidi Yesuusa kaallidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yesuusi katamatappe issuwan de7ishin issi baro harggen oykettida asi he kataman de7ees. He uray Yesuusa be7idi iya sinthan gufannidi, “Godaw, ne shene gidikko tana geeshshanaw dandda7aasa” gidi woossis. ");
INSERT INTO gofRNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesuusi ba kushiya yeddi bochchidi, “Ee, ta shene; geeya” yaagis. Iira baro harggey uraappe kichchis. ");
INSERT INTO gofRNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yesuusi, “Hayssa ooddeskka odoppa, shin bada nenatethaa Ayhude kahiniya bessa. Ne geeyidayssas markka gidana mela Musey kiittida yarshshuwa yarshsha” gidi kiittis. ");
INSERT INTO gofRNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Gidoshin, iya sunthay kaseppe aadhdhidi dalggishe bis. Daro asay I odiyabaa si7anawunne bantta harggiyafe paxanaw yoosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Shin Yesuusi daro wode geema bessi bidi woossees. ");
INSERT INTO gofRNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Issi gallas Yesuusi tamaarssishin Galiilappenne Yihuda heera ubbaafe qassi Yerusalaameppekka yida Farisaawetinne higge asttamaareti yan uttidosona. Asaa pathiya Godaa wolqqayka iyara de7ees. ");
INSERT INTO gofRNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","He wode asay issi gundda asi halara tookkidi ehidosona. Soo gelssidi iya sinthan wothanaw qoppidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Shin asaa darotethaafe denddoyssan soo gelssanaw xoonettidi keethaa bolla keyidi, kaara qawuxidi, hargganchchuwa halara asaa shaakkidi Yesuusa sinthan yeggidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesuusi entta ammanuwa be7idi, “La addiyaw, ne nagaray qushettis” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Higge asttamaaretinne Farisaaweti, “Hayssi Xoossaa bolla yaagidi odettey oonee? Issi Xoossaafe attin hari nagara quchchanaw dandda7ey oonee?” yaagidi qoppidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesuusi entta qofaa erida gisho enttako, “Hintte wozanan hessatho ays qoppeetii? ");
INSERT INTO gofRNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","‘Ne nagaray qushettis geyssafenne denddada ba geyssafe awussi kawuyii?’ ");
INSERT INTO gofRNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Shin ta hessa giday Asa Na7ay sa7a bolla nagara quchchanaw maati de7eyssa hintte erana melassa.” Hessafe kaallidi, gundda uraakko, “Dendda; ne alggaa tookkada ne soo ba” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","I ellesi denddidi entta sinthan eqqis; I tookettidi yida alggaa tookkidi Xoossaa galatishe ba soo bis. ");
INSERT INTO gofRNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","He wode ubbayka malaalettidosona. Xoossaa galatishe, “Hachchi gita malaata be7ida” yaagidi yashettidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Hessafe guye, Yesuusi yaappe keyidi bis. Leewe geetettiya issi qaraxa qanxiseyssi qaraxa qanxisiya bessan uttidayssa be7idi, “Tana kaalla” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","I ubbabaa aggi denddidi iya kaallis. ");
INSERT INTO gofRNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","He Leewey ba son gita gibira giigisis. Daro qaraxa qanxiseyssatinne hara asati kathaa maanaw uttidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Farisaawetinne higge asttamaareti, “Qaraxa qanxeyssataranne nagaranchchotara ays meetinne uyeetii?” yaagidi Yesuusa tamaareta bolla zuuzummidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesuusi enttako, “Hargganchchotassafe attin paxatas aakime koshshenna. ");
INSERT INTO gofRNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Taani nagaranchchota maarotaakko zaaranaassafe attin geeshshata xeeganaw yabiikke” yaagidi zaaris. ");
INSERT INTO gofRNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Entti Yesuusakko, “Yohaannisa tamaareti daro wode xoomosona, woossosona; qassi Farisaaweta tamaaretikka hessatho oothoosona. Shin neyssati ubba wode moosonanne uyoosona” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesuusi enttako, “Mushuray enttara de7ishin xeegettida asay xoomana mela oothanaw dandda7etii? ");
INSERT INTO gofRNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Shin mushuray enttafe shaakettana gallasay yaana, he wode entti xoomana.” ");
INSERT INTO gofRNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Qassi yaagidi leemiso odis; “Ooratha ma7oppe peedhidi gal77a ma7o bolla sikkey oonikka baawa. Hessatho oothiko ooratha ma7uwa peedhees, oorathay gal77aas giigenna. ");
INSERT INTO gofRNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Mal77antto woyniya gal77a ogoron qoliya oonikka baawa. Hessa oothiko, ooratha woyney gal77a ogoruwa dhusees; woyney gukkees ogoroykka maaddonabaa gidees. ");
INSERT INTO gofRNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Hessa gisho, ooratha woyney ooratha ogoron qolettanaw bessees. ");
INSERT INTO gofRNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Hiza, caalay lo77o giya gisho caala woyne uyi simmidi mal77antto koyey oonikka baawa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Issi Sambbaata gallas Yesuusi gistte gade giddora aadhdhees. Yesuusa tamaareti tiya bangga duuthidi bantta kushen shirkkidi moosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Shin Farisaaweta giddofe issoti issoti, “Sambbaata gallas oothanaw bessonnabaa ays ootheetii?” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesuusi enttako zaaridi, “Dawitey koshattida wode baara de7eyssatara issife oothoyssa nabbabibeekketii? ");
INSERT INTO gofRNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Xoossa Keethi gelidi Ayhude kahineta xalaalas bessiya daabbuwa mis; baara de7eyssataskka immis” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Qassi Yesuusi, “Asa Na7ay Sambbaata Goda” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Hara Sambbaata gallas Yesuusi Ayhude Woosa Keethi gelidi tamaarssees. He bessan ushachcha kushey gunddida issi asi de7ees. ");
INSERT INTO gofRNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Higge asttamaaretinne Farisaaweti iya mootanaw gaaso koyidi Sambbaata gallas pathiko be7ana gidi naagoosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Shin Yesuusi entta qofaa eridi kushey gunddida uraakko, “Denddada asaa gidduwan eqqa” yaagis. Uraykka denddi eqqis. ");
INSERT INTO gofRNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Yesuusi, “Ane ta hinttena issibaa oychchays; Sambbaata gallas oothanaw bessey lo77obayeyye iitabaye? Shemppo ashoyye woykko dhaysso?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Qassi Yesuusi iya yuushuwan de7iya asaa yuushshi xeellidi uraakko, “Ne kushiya piddi ootha” yaagis. Uraykka I gidayssada oothin kushey paxis. ");
INSERT INTO gofRNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Shin higge asttamaaretinne Farisaaweti daro yilotidosona. Yesuusa bolla ay oothinoo gidi bantta giddon maqettidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","He wode gallasatappe issuwan Yesuusi woossanaw deriya bolla keyis. Qamma kumethaa Xoossaa woossishe aqis. ");
INSERT INTO gofRNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Wonttethe ba tamaareta xeegidi entta giddofe tammanne nam77ata dooridi, enttana, “Hawaareta” gidi sunthis. ");
INSERT INTO gofRNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Enttika, Phexiroosa gidi sunthida Simoona, iya ishaa Inddiriyasa, Yayqooba, Yohaannisa, Filphoosa, Bartolomiyoosa, ");
INSERT INTO gofRNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Maatoosa, Toomasa, Ilfiyoosa na7aa Yayqooba, ba biittaas mishettiya Simoona, ");
INSERT INTO gofRNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yayqooba na7aa Yihudanne Yesuusa aathi immida Asqoroota Yihuda. ");
INSERT INTO gofRNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesuusi enttara issife deriyappe wodhdhidi denbba bessan eqqis. Iya tamaaretappe daroti he bessan de7oosona Yihuda biitta ubbaafe Yerusalaameppe, Xiroosappenne Sidoona abbaa gaxappe yida daro asay de7ees. ");
INSERT INTO gofRNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Entti yiday I tamaarssiyabaa si7anawunne bantta harggiyafe paxanaassa. Tuna ayyaanan waayettiya asatikka paxidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Wolqqay iyappe keyidi asa ubbaa pathiya gisho asay iya bochchanaw koyoosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ba tamaaretakko xeellidi hayssada yaagis: “Hinttenoo, manqoto, hintte anjjettidayssata; Xoossaa kawotethay hinttessa. ");
INSERT INTO gofRNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Hintte ha77i koshatteyssati anjjettidayssata, hintte kallana. Hintte ha77i yeekkeyssati anjjettidayssata hintte miicana. ");
INSERT INTO gofRNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Asay hinttena Asa Na7aa gisho ixxiya wode hinttena hiliya wode hinttena entti toochchiya wodenne, iita sunthi entti hinttew immiya wode hintte anjjettidayssata. ");
INSERT INTO gofRNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Hekko, hintte woytoy salon gita gidiya gisho he wode ufayssan guppite. Ays giikko, beni entta aawati nabeta bolla hessada oothidosona.” ");
INSERT INTO gofRNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Shin dureto hinttena ayye; hintte ha77i lo77o duussaa ekkideta. ");
INSERT INTO gofRNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ha77i kallidayssato hinttena ayye; hintte koshattana. Ha77i miiceyssato hinttenoshsho hintte kayottananne yeekkana. ");
INSERT INTO gofRNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Asi ubbay hintte lo77otethaa xalaala odiya wode hinttena ayye. Entta aawati beni worddanchcho nabeta bolla hessada oothidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Shin tana si7iya hinttes ta odays; hintte morkketa siiqite; hinttena ixxeyssatas lo77obaa oothite. ");
INSERT INTO gofRNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Hinttena qanggeyssata anjjite, hinttena naaqqeyssatas woossite. ");
INSERT INTO gofRNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Issi bagga shakalaa baqqeyssas hankko baggaaka bessa. Ne laxana ekkana geyssas ne shaamiziyakka gujjada imma. ");
INSERT INTO gofRNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Nena woossiya ubbaas imma; neeppe ekkida oonakka zaaro gada oychchofa. ");
INSERT INTO gofRNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Asay hinttew oothana mela hintte koyabaa ubbaa hintteka asaas oothite. ");
INSERT INTO gofRNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Hintte hinttena dosiya asata xalaala dosikko, ay galati hinttew de7ii? Hari attoshin, nagaranchchotikka banttana siiqeyssata siiqoosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Hinttew lo77obaa ootheyssata xalaalas lo77obaa oothiko hinttew ay galati de7ii? Nagaranchchotikka hessada oothoosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Tal77e zaarana asa xalaalas hintte tal77iko ay dumma galatetteetii? Nagaranchchotikka guye zaarana asi be7idi tal77osona.” ");
INSERT INTO gofRNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","“Shin hintte morkketa siiqite; enttaw lo77obaa oothite. Guye ekkanaw qopponna tal77ite. Hessan hintte ekkana woytoy gita gidana. Hintte Ubbaafe Bolla Xoossaa nayta gidana. I bana galatonnayssatasinne iitatas keeha. ");
INSERT INTO gofRNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Hintte aaway keeha gidoyssada hintteka keeha gidite. ");
INSERT INTO gofRNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Asa bolla pirddofite; hintte bolla pirddettenna. Hintte borettonna mela oonakka boroppite. Atto giite; Xoossay hinttew atto gaana. ");
INSERT INTO gofRNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Immite; hinttew imettana. Hintte makkidaban hinttew zaari makettana, ubbarakka lo77o makkiyaban baqqidi, suuddi kunthidi, laalettana gakkanaw hinttew maketi imettana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Qassika Yesuusi yaagidi enttaw leemiso odis; “Qooqey qooqe kaalethanaw dandda7ii? Kaalethiko nam77ayka woli ekkidi aafon wullokonayye? ");
INSERT INTO gofRNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Tamaarey asttamaareppe aadhdhenna. Shin loythi tamaarida uray ba asttamaariyatho hanees. ");
INSERT INTO gofRNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Ne ishaa ayfiyaan de7iya buuriya ays be7ay? Ne ayfiyaan de7iya tuussi daaneyssa ays be7ikki? ");
INSERT INTO gofRNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ne ayfiyaan de7iya tuussi daaneyssa be7onna ne ishaakko, ‘Ta ishaw ne ayfiyaan de7iya buuriya kesso’ gaanaw waana dandda7ay? Neno cubbuwaw, koyrottada ne ayfiyaan de7iya tuussi daaneyssa kessa. Hessafe guye, ne ishaa ayfiyaan de7iya buuriya kessanaw geeshshada xeellana. ");
INSERT INTO gofRNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Lo77o mithi iita ayfe ayfenna; hessadakka iita mithi lo77o ayfe ayfena. ");
INSERT INTO gofRNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ayfe ayfiyaa mithi ubbay ba ayfiyaan erettees. Agunthafe balase mitha ayfey maxettenna qassi laadeppe woyne ayfey maxettenna. ");
INSERT INTO gofRNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Lo77o asi ba wozanan kumida lo77obaappe lo77obaa kessees. Iita asi ba wozanan kumida iitabaappe iitabaa kessees. Asi ba wozanan kumidi palahidabaappe ba doonan haasayees. ");
INSERT INTO gofRNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Ta geyssa ootheketa, shin yaatin ays tana, ‘Godaw, Godaw, geeti?’ ");
INSERT INTO gofRNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Taakko yeynne ta qaala si7idi poliya ubbay oona daaniyakko ta hinttena bessana. ");
INSERT INTO gofRNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","I keethe keexanaw ziqqi oothi, olla bookkidi, garssan de7iya zaalla bolla keethaa essida cincca uraa daanees. Di7oy di77idi he keethaa sugis, shin minthidi keexida gisho qaaxxanaw dandda7ibeenna. ");
INSERT INTO gofRNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Shin ta qaala si7idi oothonay ba keethaa shafe biitta bolla keexida uraa daanees. Di7oy di77idi he keethaa sugida wode ellesidi kunddis. He keethay wolqqaama kunddethi kunddis” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesuusi hessa ubbaa asaa sinthan tamaarssidi onggidaappe guye, Qifirnahoome katamaa bis. ");
INSERT INTO gofRNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","He bessan issi mato halaqay de7ees. I daro dosiya aylley harggettidi hayqos gakkis. ");
INSERT INTO gofRNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","I Yesuusabaa si7ida wode ba aylliya pathana mela iya woosso gidi issi issi Ayhude cimata Yesuusakko kiittis. ");
INSERT INTO gofRNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Kiitettidayssati, Yesuusakko bidi, “Ne iyaw hayssa oothanaw bessees. ");
INSERT INTO gofRNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ays giikko, ha uray nu asaa dosees, Ayhude Woosa Keethaka keexxis” gidi minthi woossidosona ");
INSERT INTO gofRNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Yesuusikka enttara bis. Mato halaqaa sookko matiya wode ba laggeta iyaakko kiittidi, “Godaw, ta kaarappe garssan ne gelanaw ta bessonna gisho daaburoppa. ");
INSERT INTO gofRNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Takka tana ne sinthe shiiqanaw bessiya asi gada qoppike. Shin ne issi qaala oda; ta aylley paxana. ");
INSERT INTO gofRNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Taw taappe bollara halaqay de7ees, taappe garssan ta kiittiya wotaaddareti de7oosona. Issuwa, ‘Ba’ giikko bees, hankkuwa, ‘Haaya’ giikko yees. Ta aylliyakko, ‘Hanno ootha’ giikko oothees” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesuusi hessa si7ida wode malaalettis. Guye simmidi baara yaa asaakko, “Taani hinttew tuma odays; hari attoshin Isra7eelenkka hayssa mela gita ammano demmabiikke” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Kiitettidayssati soo simmiya wode aylley paxin demmidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Guutha wodeppe guye Yesuusi Nayne katamaa bis. Iya tamaaretaranne hara daro asati iyara bidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","I katamaa gelana haniya wode aha tookkida daro asati katamaappe keyosona. Hayqqida na7ay ba aayes issuwa, iyakka am77o gidada da7awusu. Katama asaappe daroti iira de7oosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Goday iyo be7ida wode qadhettidi, “Yeekkofa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Shiiqidi halaa bochchin tookkida asati eqqidosona. Yesuusi, “La, yalagaw dendda” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Hayqqidayssi denddi uttidi oda oykkis. Yesuusi na7aa ekkidi aayes immis. ");
INSERT INTO gofRNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Asa ubbay yashettidi, “Gita nabey nu giddon denddis; Xoossay ba asaa be7is” yaagidi Xoossaa galatidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Iya sunthay Yihudaninne he heeran de7iya biitta ubban si7ettis. ");
INSERT INTO gofRNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Xammaqiya Yohaannisa tamaareti hessa ubbaa Yohaannisas odidosona. I entta giddofe nam77ata xeegidi, ");
INSERT INTO gofRNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","“Yaana geetettiday neneyye? Woykko haraa naaginoo?” yaagidi oychchite gidi Godaakko kiittis. ");
INSERT INTO gofRNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Asati Yesuusakko bidi, Xammaqiya Yohaannisi, “Yaana geetettiday neneyye? Woykko haraa naaginoo?” giite gidi nuna neekko kiittis yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","He saatenkka Yesuusi daro asaa harggiyafe pathis. Tuna ayyaanata kessis, qooqida ayfiyakka xeelisis. ");
INSERT INTO gofRNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Yohaannisa matappe kiitettidi yidayssatakko, “Bidi hintte be7idayssanne si7idayssa Yohaannisas odite. Ayfe qooqeti xeellosona, gunddati birshshettidi hamuttoosona, baro hargganchchoti geeyosona, tulleti si7oosona, hayqqidayssati hayqoppe denddoosona, manqotas Wonggelay sabbakettees. ");
INSERT INTO gofRNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Tanan dhubettonna oonikka anjjettidayssa.” ");
INSERT INTO gofRNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Yohaannisi kiittidayssati bidaappe guye Yesuusi asaas Yohaannisabaa yaagidi odis: “Hintte ay be7anaw bazzo biitta keyidetii? Carkkoy qaathiya maata be7anaaseye? ");
INSERT INTO gofRNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Yaatin, ay be7anaw keyidetii? Koyse ma7o ma77ida asaa be7anaaseyye? Koyse ma7o ma77idayssatinne sa7i injjetida asay kawo keethan de7oosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Yaatin, ay be7anaw keyidetii? Nabiya be7anaaseye? Ee, ta yaagays: hintte be7anaw keyiday nabeppe aadhdheyssa. ");
INSERT INTO gofRNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","‘Ne ogiya ne sinthan giigisiya ta kiitanchchuwa neeppe sinthe ta kiittana’ geetettidi xaafettiday iyassa. ");
INSERT INTO gofRNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ta hinttew odays; maccasappe yelettidayssata giddofe Yohaannisappe aadhdhey baawa. Xoossaa kawotethan ubbaafe guuxeyssi, I ubbaafe gita gidana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Hari attoshin, Yesuusa qaala si7ida qaraxa qanxiseyssati ubbay Yohaannisa kushen xammaqettidi Xoossay xillo gideyssa qonccisidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Shin Farisaawetinne higge asttamaareti Yohaannisa kushen xammaqettonna ixxidi Xoossaa zoriya leqisidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesuusi kaallidi hayssada yaagis: “Hiza, ha wodiya yeletethaa aybira daaniso? Enttika oona daanoona? ");
INSERT INTO gofRNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Giya giddon uttidi woli xeegidi, ‘Nu hinttew suusul77e punnin, hintte yexxeketa. Nu sabbidi zeleelin, hintte yeekkeketa’ yaagiya nayta daanosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Xammaqiya Yohaannisi moonnanne uyonna yin, ‘Iita ayyaanara de7ees gideta.’ ");
INSERT INTO gofRNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Asa Na7ay mishenne uyishe yin, ‘Yarambbanne ushshanchcho, qaraxa qanxiseyssatanne nagaranchchota dabbo’ gideta. ");
INSERT INTO gofRNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Hiza, cinccatethaa tumatethay iya nayta ubbaa matan erettis” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Issi Farisaawey Yesuusa kathi muzanaw ba soo xeegis. I Farisaawiya soo bidi gayta bolla uttis. ");
INSERT INTO gofRNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","He kataman issi nagaranchcho maccasi de7iyara Yesuusi Farisaawiya son gibira bolla de7eyssa si7ida wode daro al77o philqqaaxe shitto ekkada yasu. ");
INSERT INTO gofRNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Yesuusas guye baggara, iya tohuwa matan eqqada yeekkashe iya tohuwa ba afuthaara laakethawsu. Ba binaanara iya tohuwa quchchashenne yeerashe shitto tiyasu. ");
INSERT INTO gofRNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Gibira giigisida Farisaawey hessa be7ida wode ba wozanan, “Hayssi nabe gidiyakko ha maccasiya iya bochchiyara ooneekko qassi iya nagaranchcho gideyssakka I eranashin” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesuusi, “Simoona, ta new odiyabay de7ees” yaagis. I, “Asttamaariyaw, taw oda” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yesuusi iyaakko, “Nam77u asati issi uraappe miishe tal77idosona. Issoy ichchashu xeetu bira hankkoy qassi ishatamu bira tal77idosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Nam77ayka tal77iya cigganaw xoonettin, nam77ataskka tal77iya maaris. Hiza, ha nam77atappe he uraa daro dosanay new awussa daanii” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simooni, “Daro acoy maarettida uray daro dosana daanees” yaagis. Yesuusi, “Ne tuma pirddadasa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Hessafe guye, Yesuusi maccaseekko simmi xeellidi, Simoonakko, “Hanno maccasiw be7ay? Taani ne soo gelin hari attin ne taw toho haathe immabaakka, shin iya ta tohuwa ba afuthan laakothada ba binaanan quchchasu. ");
INSERT INTO gofRNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Neeni tana yeera ekkabaakka, shin iya ta ne soo geloodeppe doomada ta tohuwa yeero aggabukku. ");
INSERT INTO gofRNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Neeni ta huu7iyan zayte tiyabaka, shin iya ta tohuwa shitto tiyawusu. ");
INSERT INTO gofRNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Iya tana daro dosida gisho I daro nagaray atto geetettis. Iya guutha nagaray atto geetettiday guuthara dosees.” ");
INSERT INTO gofRNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Yesuusi maccaseekko, “Ne nagaray atto geetettis” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Iyara issife gaytan uttidi miya imathati, “Nagara atto yaagey, I hayssi oonee?” yaagidi bantta wozanan qoppidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Yesuusi maccaseekko, “Ne ammanoy nena ashshis; saro ba” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Hessafe guye, Yesuusi Xoossaa kawotethaa Wonggelaa sabbakishe katamaaranne gutaara aadhdhis. He wode tammanne nam77u hawaareti iyara de7oosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Qassi tuna ayyaanaappenne dumma dumma harggiyafe paxida issi issi maccasati iyara de7oosona. Enttika, laappun tuna ayyaanati keyida Magdela Mayraamo, ");
INSERT INTO gofRNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Heroodisa shuumaa Kuuza machchiw Yohaanna, Soosinnaranne qassi hara daroti enttana miishen maaddeyssati de7oosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Daro asay dumma dumma katamaappe iyaakko shiiqin leemison enttaw odis. ");
INSERT INTO gofRNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Issi goshshanchchoy zerethi zeranaw keyis. I zerishin issi issi zerethay oge gaxan wodhdhidi yedhdhettis, salo kafoti maxidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Harati shaalloy garssan de7iya biitta bolla wodhdhidosona. Buroo dolida mela biittan laahoy baynna gisho miccidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Hara zerethay qassi aguntha giddon wodhdhis. Agunthaara wolla diccida gisho agunthay cuullidi bessan ashshis. ");
INSERT INTO gofRNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Harati lo77o biitta bolla wodhdhidosona. Dolida wode xeetu kushe ayfidosona.” Hessa odi onggidi, ba qaala dhoqqu oothidi, “Si7iya haythi de7iya ubbay si7o” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Iya tamaareti, “Ha leemisuwa birshshethay aybee?” yaagidi oychchidosona ");
INSERT INTO gofRNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","I, “Xoossaa kawotethaa xuuraa erana mela hinttew imettis. Shin harati be7ishe demmonna mela, si7ishe akeekonna mela leemison odays. ");
INSERT INTO gofRNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Hiza, ha leemisuwa birshshethay hayssa: zerethi yaagettiday Xoossaa qaala. ");
INSERT INTO gofRNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Oge gaxan wodhdhida zerethay qaala si7eyssata. Gidoshin, entti ammanidi attonna mela Xalahey qaala entta wozanaappe maxi digees. ");
INSERT INTO gofRNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Shaalloy garssan de7iya biitta bolla wodhdhida zerethay qaala si7idi ufayssan ekkeyssata. Entti ha77is ammanoosonappe attin xaphoy baynna gisho paacey gakkiya wode ellesidi kaddoosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Aguntha giddon zerettidayssati qaala si7eyssata. Enttika alamiya qofan, duretethaaninne sa7aa duussaa miikkotethan cuulettidi besseyssada ayfibookkona. ");
INSERT INTO gofRNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Lo77o biittan wodhdhida zerethay lo77o wozanan qaala si7idi naageyssatanne dandda7an minnidi ayfe ayfeyssata. ");
INSERT INTO gofRNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Xomppe xomppidi, daachcho kammey woykko arssafe garssan wothey deenna. Geliya asi be7ana mela dhoqqa bessan wothees. ");
INSERT INTO gofRNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Hessa gisho, qoncce keyonna qosettidi attiyaabay, erettonna geemmidi attiyaabay deenna. ");
INSERT INTO gofRNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Hiza, hintte qaala waati si7iyakko akeekite. De7iya ubbaas guzhetidi imettana, baynnayssas hari attoshin iyaw de7iya guuthiyaka iyappe ekettana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Yesuusa aayeranne ishatara iyaakko yidosona. Shin asaa darotethaafe denddoyssan iya demmanaw dandda7ibookkona. ");
INSERT INTO gofRNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Issi asi Yesuusakko, “Ne aayeranne ne ishatara nena koyidi karen naagoosona” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yesuusi zaaridi, “Xoossaa qaala si7idi ooson peeshsheyssati ubbay taw aayonne taw isha” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Issi gallas Yesuusaranne iya tamaaretara issife wogolon gelidi, “Abbaa pinnoos” yaagis. Enttika baanaw denddidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Abbaa bollara entti pinnanaw bishin Yesuusi dhiskkis. Qopponna mino carkkoy abbaa bolla denddis. Haathay wogoluwan gelin wogoloy mitetethi oykkiya wode ubbay babbidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Iya tamaareti iyaakko shiiqidi, “Nu Godaw, nu Godaw, nu dhayos yaagidi” Yesuusa denthidosona. Yesuusi denddidi carkkuwanne gotiya seeris. Ellesidi carkkoynne gotey woppu gis. Sarotethayka simmis. ");
INSERT INTO gofRNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Yesuusi ba tamaaretakko, “Hintte ammanoy awunee” yaagis. Enttika, yayyishenne malaalettishe issoy issuwako, “Carkkoynne haathay kiitetteyssi, I hayssi oonee” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Abbaa pinnidi Galiila baggara de7iya Gerggesoone biittaa gakkidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yesuusi wogoluwappe keyidi sa7an wodhdhishin tuna ayyaanan oykettida uray katamaappe keyidi iyara gahettis. Daro laythi afili ma77onna kallo duufon de7eesippe attin soo gelenna. ");
INSERT INTO gofRNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Yesuusa be7ida wode iya sinthan gufannidi, ba qaala dhoqqu oothidi, “Ubbaafe Bolla Xoossaa na7aw Yesuusa neera taw aybi issifetethi de7ii? Hayyana tana ha77i un77ethofarkkii” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Hessa I giday, tuna ayyaanay uraappe keyana mela Yesuusi hanqettida gishossa. Daro wode tuna ayyaanay iya haarida gisho santhalaataninne toho qachchiya biraatan qashettidi naagettees. Shin qashuwa duuthidi tuna ayyaanan laagettidi bazzo gelis. ");
INSERT INTO gofRNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesuusi, “Ne sunthay oonee” yaagidi oychchis. I, daro tuna ayyaanati iya oykkidi gisho bana, “Leegiyona” gis. ");
INSERT INTO gofRNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Tuna ayyaanati banttana Si7oole kiittonna mela woossidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","He bessan zooze bolla miya guduntho wudey hamuttees. Hini gudunthotan gelino gidi woossidosona, ikka “Gelite” gis. ");
INSERT INTO gofRNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Tuna ayyaanati uraappe keyidi gudunthotan gelidosona. Wudey deriyappe duge gurgguxidi abban gelis. ");
INSERT INTO gofRNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Henthanchchoti hanidayssa be7ida wode woxxi bidi, katamaninne guta ubban odidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Asay hanidabaa be7anaw keyidi Yesuusakko yidosona. Tuna ayyaanay keyida uray ma7o ma77idi, iya wozanay simmin, Yesuusa toho matan uttidayssa demmidi yayyidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Iya be7ida asay tuna ayyaanan oykettida uray waanidi paxidaakko odidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Gerggesoone yuushuwan de7iya asay gita yashshi yashettidi Yesuusi bantta matappe baana mela woossidosona. I wogoluwan gelidi guye simmis. ");
INSERT INTO gofRNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Tuna ayyaanay keyida uray Yesuusara daanaw woossis. ");
INSERT INTO gofRNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Shin Yesuusi iyaakko, “Ne soo simma, Xoossay ay mela gitabaa new oothidaakko oda” yaagidi mooyzis. Uraykka Yesuusi ay mela gitabaa iyaw oothidaakko katama ubban markkattishe bis. ");
INSERT INTO gofRNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Asay naagidi gam77ida gisho Yesuusi simmiya wode mokki ekkidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ayhude Woosa Keetha halaqa gidida Iyaroosa giya uray ba soo yaana mela Yesuusa tohuwa bolla wodhdhidi woossis. ");
INSERT INTO gofRNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Iyaw tammanne nam77u laythi gidida macca na7a de7iyara sakettada hayqos gakkada de7awusu. Yesuusi biya wode asay iya un77ethees. ");
INSERT INTO gofRNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Tammanne nam77u laythi suuthi goggishe gam77ida maccasi de7iyara de7awusu. Iya baw de7iya miishiya aakimetas immada onggasu. Shin paxanaw dandda7abukku. ");
INSERT INTO gofRNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Iya Yesuusas guye baggara shiiqada, iya afilaa macaraa bochchasu, sohuwara goggiya suuthay eqqi aggis. ");
INSERT INTO gofRNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yesuusi, “Tana bochchiday oonee?” yaagis. Ubbay “Nu bochchibookko” yaagin, Phexiroosi, “Asttamaariyaw, daro asay kaallishininne un77ethishin be7ashe waanada, ‘Tana bochchiday oonee?’ gay” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Shin Yesuusi, “Issi asi tana bochchis; ays giikko, wolqqi taappe keyoyssi taw erettis” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Maccasiya, ibay qonccidayssa erida wode kokkorashe yada Yesuusa tohuwa bolla kunddasu. Ays bochchidaakkonne waanada ellesada paxidaakko asaa ubbaa sinthan markkattasu. ");
INSERT INTO gofRNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","I, “Ta naatte, ne ammanoy nena pathis; saron ba” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesuusi oda onggonna de7ishin, Ayhude Woosa Keetha halaqaa, Iyaroosa sooppe issi asi yidi, “Iyaroosa, ne na7iya hayqqasu; asttamaariya mela daaburissofa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Shin Yesuusi hessa si7idi Iyaroosakko, “Babbofa! Ammana, ne na7iya paxana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Yesuusi Iyaroosa soo gakkida wode Phexiroosappe, Yohaannisappe, Yayqoobappe, na7ee aawappenne aayeppe attin hari gelana mela koyibeenna. ");
INSERT INTO gofRNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","He bessan de7iya asa ubbay na7ees mishettidi yeekkishin, Yesuusi, “Yeekkofite! Na7iya dhiskkasuppe attin hayqqabuukku” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Asay na7iya hayqqidayssa eriya gisho iya oda leqqidi miicidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Shin Yesuusi na7ee kushiya oykkidi, “Naatte dendda” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Na7ees shemppoy simmin dendda eqqasu. Yesuusi enttako, “Iwu miyabaa immite” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Na7ee aawaranne aayera malaalettidosona. Shin Yesuusi hayssa, “Ooddeskka odoppite” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesuusi tammanne nam77u hawaareta baakko xeegidi, tuna ayyaanata kessana melanne hargge ubbaa pathana mela wolqqanne maata immis. ");
INSERT INTO gofRNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Xoossaa kawotethaabaa markkattanaadanne hargganchchota pathanaada kiittis. ");
INSERT INTO gofRNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","I enttako, “Xam77a gidin ogoro gidin kathi gidin miishe gidin laammi ma77iya afila gidin oges gidi aykkoka oykkofite. ");
INSERT INTO gofRNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","He katamaappe hintte keyana gakkanaw imathatethan hintte gelidasuwan gam77ite. ");
INSERT INTO gofRNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Oonikka hinttena mokkonna ixxiko he katamaappe keyishe enttaw markka gidana mela hintte tohuwan de7iya baana pittidi keyite.” ");
INSERT INTO gofRNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Enttika kiitettidayssada keyidi Wonggelaa odishenne dumma dumma gutatan hargganchchota pathishe aadhdhidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Galiila biittaa haariya Heroodisi Yesuusi oothidabaa ubbaa si7ida wode dagammis. Ays giikko, issi issi asati Yohaannisi hayqoppe denddonna aggenna yaagosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Baggati, “Eeliyaasi qonccis” goosona; harati qassi, “Beni nabetappe issoy hayqoppe denddis” yaagidi odettoosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Shin Heroodisi, “Yohaannisa qoodhiya ta qanxisada wodhas. Yaatin, hayssatho yaagettidi iyabaa odettey, I oonee?” yaagidi ba ayfen be7anaw koyees. ");
INSERT INTO gofRNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Tammanne nam77u hawaareti guye simmi yidi, entti oothidabaa ubbaa Yesuusas odidosona. I enttana ekkidi Beetesayda katamaappe gaxa efis. ");
INSERT INTO gofRNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Shin daro asay Yesuusa gideyssa eridi iya kaallidosona. I entta mokki ekkidi Xoossaa kawotethaabaa tamaarssis; paxanaw koyeyssatakka pathis. ");
INSERT INTO gofRNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Sa7i omarssiya wode tammanne nam77u hawaareti iyaakko shiiqidi, “Nu de7ey bazzo biitta gidiya gisho asay dumma dumma gutatanne katamata bidi, kathinne aqiyaso koyana mela asaa moyza” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Shin I, “Enttaw miyabaa hintte immite” yaagis. Entti, “Nuus de7ey ichchashu uythinne nam77u molo gidiya gisho ha asaas gidiya kathi nuuni bidi shammonna ixxiko gidenna” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","He bessan ichchashu mukulu gidiya addeti de7oosona. Yesuusi ba tamaaretakko, “Ishataman ishataman shaakki shaakki asaa utisite” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Iya tamaareti, I kiittidayssada asaa utisidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","I ichchashu uythaanne nam77u molota ekkidi, salo xeellidi, Xoossaa galatidi, meenthidi asaa ubbaa gathana mela ba tamaaretas immis. ");
INSERT INTO gofRNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ubbay midi kallidosona. Enttafe attida tiifey tammanne nam77u gayta kumethi gidis. ");
INSERT INTO gofRNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Yesuusi ba xalaala woossishin, iya tamaareti iyaakko yidosona. I, “Asay tana oona goonaa?” gidi oychchis. ");
INSERT INTO gofRNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Entti zaaridi “Issoti issoti, ‘Xammaqiya Yohaannisa, baggati Eliyaasa, harati qassi, beni nabetappe issoy hayqoppe denddis’ yaagosona” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","I zaaridi, “Yaatin hintte tana oona geeti” yaagis. Phexiroosi, “Neeni Xoossaafe kiitettida Kiristtoosa” yaagidi zaaris. ");
INSERT INTO gofRNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yesuusi hayssa ooddeskka odoppite gidi minthidi odis. ");
INSERT INTO gofRNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Qassika Yesuusi, “Asa Na7ay daro metuwa ekkana. Biitta cimatan, kahine halaqatan, higge asttamaaretan aadhdhi imettana. Entti iya wodhana, shin I heedzantho gallas hayqoppe denddana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Yesuusi asaa ubbaako, “Tana kaallanaw koyey oonikka de7ikko bana kaddo, ba masqaliya gallas gallas tookkidi tana kaallo. ");
INSERT INTO gofRNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ba shemppiw ashshanaw koya ubbay iyo dhayssees, ba shemppiw ta gisho gidi dhayssiya oonikka iyo ashshees. ");
INSERT INTO gofRNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Asi alame ubbaa haaridi, gidoshin ba shemppiw dhayssiyabaa woykko qohiyabaa gidikko iya ay maaddii? ");
INSERT INTO gofRNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Oonikka tananinne ta qaalan yeellatikko Asa Na7ay ba bonchchuwara hessadakka aawa bonchchuwaranne Geeshsha kiitanchchota bonchchuwara yaa wode iyan yeellatana. ");
INSERT INTO gofRNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ta hinttew tuma odays; hayssan eqqidayssata giddofe Xoossaa kawotethaa be7onnashin hayqqonna asati de7oosona” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yesuusi he oda odin, hosppun gallasappe guye Phexiroosa, Yayqoobanne Yohaannisa baara ekkidi woossanaw deriya bolla keyis. ");
INSERT INTO gofRNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","I woosa bolla de7ishin iya ayfe karey laamettis; afilaykka awa mela phoolidi booxis. ");
INSERT INTO gofRNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Nam77u asati, enttika Museranne Eliyaasara bonchchon qonccidi, ");
INSERT INTO gofRNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Yerusalaamen polettanaw de7iyabaa, hessika, I ha alamiyappe shaakettanabaa iyara odettoosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Phexiroosanne iyara de7eyssata dhiskkoy efin, entti dhiskkofe barkkiya wode iya bonchchuwanne iyara eqqida nam77u asata be7idosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Asati Yesuusappe shaakettidi baana hanishin, Phexiroosi Yesuusakko, “Godaw, hayssan gideyssi nuus ay mela lo77o! Issino new, issino Muses, issino Eliyaasas oothidi heedzu shaqara shaqaroos” yaagis. Shin I ay gidaakko erenna. ");
INSERT INTO gofRNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","I yaagidi odettishin shaaray yidi enttana kammis. Entti he shaara giddo gelishe babbidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Shaara giddofe, “Ta doorida na7ay hayssa iya si7ite” yaagiya qaalay si7ettis. ");
INSERT INTO gofRNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","He qaalay si7ettidaappe guye Yesuusi barkka de7ishe benttis. He wode entti be7idabaa ooddeskka odonna, bantta wozanan oykkidi si77i gidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Wonttethe entti deriyappe wodhdhiya wode daro asay yidi iyara gahettidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","He wode asaa giddofe issi asi, “Asttamaariyaw, ta issi na7aa yada be7arkki. ");
INSERT INTO gofRNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Tuna ayyaanay qopponna oykkidi waasises; goppontto yegisidi qakerethees, asatethaa qohidi un77ethidi yeddees. ");
INSERT INTO gofRNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ne tamaareti kessana mela woossas, shin entti dandda7ibookkona” yaagidi woossis. ");
INSERT INTO gofRNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesuusi, “Ammanoy baynna geella yeletethato, awude gakkanaw ta hinttera daane, hinttena dandda7anee? Ne na7aa bada haa ekkaya” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Na7aa ekkidi yaa wode tuna ayyaanay sa7an holi yeggidi kokkorssis. Shin Yesuusi tuna ayyaanaa hanqidi na7aappe kessis. Na7aakka na7aa aawas immis. ");
INSERT INTO gofRNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Asay ubbay Xoossaa gita wolqqan malaalettidosona. Entti I oothidaban malaalettishin, Yesuusi ba tamaaretakko, ");
INSERT INTO gofRNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Hayssa ta hinttew odeyssa loythi si7ite; Asa Na7ay morkketa kushen aadhdhi imettana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Shin I gidabay enttafe geemmida gisho akeekibookkona. Hessa gisho, zaaridi oychchanaw babbidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Yesuusa tamaareti, “Nu giddon gita gidanay oonee?” gidi palama oykkidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yesuusi entta wozanaa qofaa eridi yooga na7aa ba matan essidi, ");
INSERT INTO gofRNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","“Ha yooga na7aa ta sunthan mokkiya oonikka tana mokkees, tana mokkey tana kiittidayssa mokkees, hintte ubbaafe guuxeyssi, I gita gidana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yohaannisi, “Godaw, issi asi ne sunthan tuna ayyaanata kessishin be7idi I nuura gidonna gisho diggida” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yesuusi zaaridi, “Hinttera eqettonnayssi, I hintte bagga. Hessa gisho, iya diggofite” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Yesuusi salo biya wodey matattida gisho Yerusalaame baanaw qanxidi denddis. ");
INSERT INTO gofRNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Samaare biittan de7iya issi gutaa bidi, ubbabaa iyaw giigisana mela ase yaa kiittis. ");
INSERT INTO gofRNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Shin I bey Yerusalaame gidiya gisho entti iya mokki ekkibookkona. ");
INSERT INTO gofRNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Yesuusa tamaareti Yayqoobaranne Yohaannisara hessa be7idi, “Godaw, saloppe tami wodhdhidi entta mo gaana mela ne koyay” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Shin Yesuusi guye simmi entta hanqettidi, “Hintte garssan aybi ayyaani de7iyakko hintte erekketa. Asa Na7ay ase ashshanaw yisippe attin dhayssanaassa gidenna” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Yaappe denddidi hara guta bidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Entti ogiyara bishin, issi asi, “Ne biyaso ubbaa ta kaallana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesuusi zaaridi, “Workkanatas olli, salo kafotas keethi de7ees, shin Asa Na7ay ba huu7iya shemppisiyasoy baawa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Hankkuwako, “Neeni tana kaalla” yaagis. Shin uray, “Godaw, koyrottada ta aawa moogada yaana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Shin Yesuusi, “Hayqqidayssati hayqqidayssata moogana mela enttaw aggaaga; neeni bada Xoossaa kawotethaa sabbaka” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Qassi hara asi, “Godaw, ta nena kaallana, shin koyrottada ta soo asa sarothada yaana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yesuusi zaaridi, “Koxe oykkidi guye xeelliya oonikka Xoossaa kawotethaas bessenna” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Hessafe guye, Goday haraa laappun tammanne nam77u asata dooris. I baanaw qoppida katamaanne guta ubbaa sinthattidi baanada nam77a nam77a oothidi kiittis. ");
INSERT INTO gofRNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Yesuusi enttako, “Hekko shiiqana kathay daro shin oosanchchoti guutha. Yaaniya gisho, kathaa goday oosanchchota kiittana mela woossite. ");
INSERT INTO gofRNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Hiza, biite, dorssatada suudhumeta giddo hinttena taani yeddana. ");
INSERT INTO gofRNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Hintte biya ogiyas aykkoka oykkofite, miishe gidin kathi gidin caamma oykkofite. Oge bolla oonakka sarothofite ");
INSERT INTO gofRNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Hintte geliya keethaa ubbaa koyrottidi, ‘Saroy ha keethaas gido’ yaagite. ");
INSERT INTO gofRNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Saro dosiya asi he bessan de7ikko, hintte saroy yan shemppana; ixxas giikko hintte saroy hinttew simmana. ");
INSERT INTO gofRNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Oosanchchos damooze bessiya gisho hintte gelida keethan hinttew shiishidaba ubbaa mishenne uyishe yan gam77ite. Issuwa sooppe issuwa soo yuuyoppite. ");
INSERT INTO gofRNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ay katamakka hintte geliya wode asay hinttena mokkidi, hinttew shiishidaba ubbaa miite. ");
INSERT INTO gofRNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","He kataman de7iya hargganchchota pathishe, ‘Xoossaa kawotethay hintteko matis’ yaagidi odite. ");
INSERT INTO gofRNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Shin issi katamaa geliya wode asay hinttena mokkonna ixxiko dabaaba keyidi hayssada giite: ");
INSERT INTO gofRNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Nu tohuwa bolla de7iya hintte katamaa baana pittoos, shin Xoossaa kawotethay hintteko matattidayssa erite.’ ");
INSERT INTO gofRNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Pirdda gallasan ha katamaappe Soodome katamaas pirdday kawushshe gidanayssa ta hinttew odays” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Kaallidikka, Yesuusi, “Neno Koraaziine, neno Beetesayda, ayye, hinttenan oosettida malaatati Xiroosaninne Sidoonan oosettidaakko yan de7iya asay kalle ma77idi, bidintha bolla uttidi beni maarotan geli agganashin. ");
INSERT INTO gofRNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Hessa gisho, hinttefe aathidi Xiroosasinne Sidoonas Xoossaa pirdday kawuyana. ");
INSERT INTO gofRNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Nekka Qifirnahoome, salo gakkanaw nena dhoqqu oothanaw koyay? Ne duge Si7oole holettana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Qassika Yesuusi ba tamaaretakko, “Hinttena si7ey tana si7ees, hinttena ekkonnay tana ekkena, tana ekkonnay tana kiittidayssa ekkenna” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Laappun tammanne nam77u tamaareti kiitettida bessaafe keehi ufayttishe simmidosona. Yesuusakko shiiqidi, “Godaw, ne sunthan tuna ayyaanatikka nuus kiitettidosona” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yesuusi enttako, “Xalahey saloppe wol77anthada wodhdhishin ta be7as. ");
INSERT INTO gofRNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Hekko, shooshaanne kornne yedhdhana melanne morkkiya wolqqaa zaarana mela maata hinttew immas. Hinttena qohanabay aykkoyka deenna. ");
INSERT INTO gofRNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Gidoshin, hintte sunthay salo mazggaban xaafettida gisho ufayttiteppe attin tuna ayyaanati kiitettida gisho ufayttofite” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","He wode Yesuusi Geeshsha Ayyaanan ufayttidi, “Saluwa sa7aa Godaw, hayssa cinccatappenne eranchchotappe geenthada yalagatas qonccisida gisho galatetta. Ee ta aawaw, hessa ne oothanaw lo77o shene gidis. ");
INSERT INTO gofRNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Ubbabay ta aawappe taw imettis. Na7ay ooneekko aawappe attin hari woykko na7ay qonccisanaw koyeyssafe hari oonikka aawa erey baawa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Kaallidikka, Yesuusi dumma ba tamaaretakko, “Hintte be7eyssa be7eyssati anjjettidayssata. ");
INSERT INTO gofRNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Tuma daro nabetinne kawoti hintte be7eyssanne si7eyssa be7anawunne si7anaw amottidosona, shin be7ibookkona, si7ibookkona” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Hekko, issi gallas Muse wogaa eriya issi uray denddidi Yesuusa yaagidi paace oysho oychchis. “Asttamaariyaw, merinaa de7uwa laattanaw taani ay ootho?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesuusi, “Muse maxaafan xaafettiday woygii? Ne waata nabbabay?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Addey zaaridi, “ ‘Ne Godaa ne Xoossaa, ne kumetha wozanappe, ne kumetha shemppuwafe, ne kumetha wolqqaafenne ne kumetha qofaappe dosa. Qassi ase ne shooruwa ne huu7iyada dosa’ yaagees” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesuusi iyaakko, “Neeni likke zaaradasa, nekka hessada ootha. Neeni merinaw de7on daana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Shin uray bana xillo oothanaw koyidi, “Hanos I ta shooroy oonee?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Iya oyshaas Yesuusi yaagidi zaaro immis, “Issi ase de7eyssi Yerusalaame katamaappe duge Iyaarkko katamaa bishin oge bolla panggati keyidi shocidosona. Iya ma7uwa qaari ekkidi hayqoppenne paxappe giddon yeggidi bidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Guyeppe, Ayhude kahine issoy he ogiyara ba buussu bishe uraa be7idi deshshi gidi aadhdhis. ");
INSERT INTO gofRNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Qassi issi Leewe de7eyssi he bessaa gakkishe uraa be7idi harasoora aadhdhidi bis. ");
INSERT INTO gofRNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Shin, issi Samaare biitta ase de7eyssi he ogiyara yishe uraa be7idi iyaw qadhettis ");
INSERT INTO gofRNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Iyaakko shiiqidi, iya madunthaa bolla zaytenne woyne tigidi qachchis. Ba hariya bolla utisidi imathi aqiya keethi efis. He bessan iyaw koshshiyaba ubbaa oothis. ");
INSERT INTO gofRNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Wonttethe nam77u dinaare kessidi imatha keethaawas immidi, ‘Hayyana ha uraa loytha xeella. Taani new immidayssafe bollara ne kessiyabaa ubbaa ta new ciggana’ yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","“Hiza, ha heedzu asatappe panggati shocida uraas shoorotey new oona daanii?” ");
INSERT INTO gofRNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Uray zaaridi, “Iyaw qadhettidayssaka” yaagis. Yesuusi, “Nekka bada hessada ootha” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesuusi ba tamaaretara oge bishe issi guta gakkis. Yan Martta geetettiya issi maccasiya iya ba son mokkasu. ");
INSERT INTO gofRNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Iwukka Mayraamo giya michchiya de7awusu, Mayraama qaala si7ashe Godaa tohuwa matan uttasu. ");
INSERT INTO gofRNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Shin Martta daro ooson un77ettada Yesuusakko shiiqada, “Godaw, ta michchiya oosuwa ta xalaalas yeggada utta aggin ta daaburiya wode neeni be7ashe si77i gay? Iya tana maaddana mela odikkii” yaagasu. ");
INSERT INTO gofRNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Shin Goday hayssada gidi zaaris, “Martta, Martta, neeni daroban un77ettasaanne metootasa. ");
INSERT INTO gofRNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Gidoshin, koyettey issibaa xalaala. Mayraama lo77obaa doorasu, hessika iippe ekettenna” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Issi gallas Yesuusi issi bessan woossees. Woosaa wurssida wode iya tamaaretappe issoy, “Godaw, Yohaannisi ba tamaareta woosa tamaarssida mela nekka nuna woosa tamaarssa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yesuusi, “Hayssada yaagidi woossite: ‘Saluwan de7iya nu aawaw ne geeshsha sunthay anjjetto; ne kawotethay yo. ");
INSERT INTO gofRNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Nu gallasa kathaa hachchi hachchi nuus imma. ");
INSERT INTO gofRNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Nuna qoheyssata nuuni atto geyssada, nu nagara atto ga; paacen nuna gelssofa’ yaagite” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Kaallidikka, Yesuusi ba tamaaretakko yaagis: “Leemisos hinttefe issuwas laggey de7ees. I giddi bilahe ba laggiya soo bidi, ‘Ta laggiyaw, heedzu soollo taw tal77arkki. ");
INSERT INTO gofRNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Taw lagge gidida issi asi ogeppe yin, iyaw aathiyabaa dhayas’ yaagikko, ");
INSERT INTO gofRNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Iya laggey keethaa giddon gididi, ‘Hayyana tana waaysoppa, wulay gorddettis. Ta naytikka taara arssa bolla zin77idosona. Yaaniya gisho, denddada ne koyabaa immanaw dandda7ikke’ yaagiyye? ");
INSERT INTO gofRNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ta hinttew odays; laggetethaa gisho denddidi immanaw koyonna ixxikokka woosan salethida gisho denddidi koshshiyaba ubbaa immees. ");
INSERT INTO gofRNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Hessa gisho, taani hinttew odays; woossite hinttew imettana; koyite hintte demmana; kare yidi xeegite hinttew dooyettana. ");
INSERT INTO gofRNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Gaasoykka woossiya ubbay ekkees; koyey demmees; kare yidi xeegeyssas dooyettees. ");
INSERT INTO gofRNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Hinttenoo, aawato hintte giddofe na7i uythi woossin shuchchu immey oonee? Molo woossin shooshi immey oonee? ");
INSERT INTO gofRNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Woykko phuuphphulle woossiko kornne immi? ");
INSERT INTO gofRNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Hintte iitata gidishe hintte naytas lo77obaa immo erikko, salon de7iya hintte aaway woosseyssatas Geeshsha Ayyaana waati aathi immenne?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Issi gallas Yesuusi doona muumisida tuna ayyaanaa issi uraappe kessis. Tuna ayyaanay keyida mela muume uray odettis. Asaykka malaalettis. ");
INSERT INTO gofRNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Shin issoti issoti, “Tuna ayyaanaa halaqaa, Bi7elzebuula wolqqan tuna ayyaanata kessees” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Harati qassi paaces saloppe malla bessana mela koyidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Shin Yesuusi entta qofaa eridi enttako, “Woli giddon shaakettiya kawotethi ubbay dhayees; woli giddon shaakettiya keethi kunddees. ");
INSERT INTO gofRNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Xalahey woli giddon shaakettiko iya kawotethay waanidi minnidi eqqanee? Hintte tana, ‘I tuna ayyaanata Bi7elzebuula wolqqan kessees’ yaageta. ");
INSERT INTO gofRNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Hiza, taani tuna ayyaanaa Bi7elzebuula wolqqan kessiyabaa gidikko hintte nayti oodde wolqqan kessonashsha? Hessa gisho, entti hintte bolla pirddeyssata gidana. ");
INSERT INTO gofRNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Shin taani tuna ayyaanata Xoossaa biradhdhen kessiyabaa gidikko hiza Xoossaa kawotethay hintteko matidayssa erite. ");
INSERT INTO gofRNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Mino asi danccettidi ba keethaa naagiyabaa gidikko, iya shaloy boshettenna. ");
INSERT INTO gofRNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Hanoshin, iyappe aadhdhi mino gidida asi yidi, iya qohidi xoonikko ammanettidi danccida danccuwa bilisidi, iya shaluwa bonqqidi haraas shaakkees. ");
INSERT INTO gofRNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Taara gidonnayssi tana ixxees; taara shiishonnaysika laallees. ");
INSERT INTO gofRNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Tuna ayyaanay asappe keyida wode shemppiyaso koyidi haathi baynnasoora yuuyees. Shemppiyaso dhayida wode ‘Ta keyidasuwa simmana’ yaagees. ");
INSERT INTO gofRNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","I simmiya wode keethay pitettidi lo77idi de7ishin demmis. ");
INSERT INTO gofRNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Hessafe guye, bidi iyappe aadhdhidi iitida haraa laappun tuna ayyaanata ekkidi yees. Iyan gelidi duussu oykkees. He uraas koyroyssafe guyeyssi aadhdhidi iita gidees” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesuusi hessa oda bolla de7ishin issi maccasi asaa gaathafe denddada, ba qaala dhoqqu oothada, “Nena tookkida uloynne neeni dhammida dhanthati anjjettidosona” yaagasu. ");
INSERT INTO gofRNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Shin I, “Anjjettidayssati Xoossaa qaala si7idi kiitetteyssata” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Daro asay shiiqida wode Yesuusi, “Ha yeletethay iita; ooratha malla koyees. Shin Yoonasa malaatappe attin hari enttaw imettena. ");
INSERT INTO gofRNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Yoonasi Nanawe asaas malla gidida mela Asa Na7aykka ha yeletethaas malla gidana. ");
INSERT INTO gofRNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Dugeha kawiya pirdda gallas ha yeletethaara denddada pirddana. Gaasoykka, iya Solomone cinccatethaa si7anaw biitta gaxappe denddada yasu. Hekko Solomoneppe aadhdheyssi hayssan de7ees ");
INSERT INTO gofRNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Nanawe asati pirdda gallas ha yeletethaara denddidi entta bolla pirddana. Gaasoykka Yoonasa sibkkatiyan maarota gelidosona. Hekko, Yoonasappe aadhdhey hayssan de7ees” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Xomppe xomppidi qosa bessan woykko oto giddon wothiya asi deenna. Asi poo7uwa be7ana mela dhoqqa bessan wothees. ");
INSERT INTO gofRNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ne asatethaas poo7oy ne ayfiyaa. Ne ayfey lo77o gidikko, ne kumetha asatethay poo7ees. Nena ayfey sakkiko ne asatethay ubbay dhumees. ");
INSERT INTO gofRNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Hessa gisho, ne garssan de7iya poo7oy dhumonna mela naageeta. ");
INSERT INTO gofRNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Hiza, ne kumetha asatethay poo7o gidikko, ne asatethankka hari dhuma bessi dhayikko, ne asatetha kumethay wolile poo7o mela gidees” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesuusi ba oda onggida mela issi Farisaawey baara kathi maana mela xeegis. I iyara issife gelidi gibira bolla uttis. ");
INSERT INTO gofRNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Farisaawey Yesuusi kathi maanappe sinthe kushe meecconayssa be7idi malaalettis. ");
INSERT INTO gofRNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Goday iyaakko, “Hintte Farisaaweti quuliyanne shaatiya bolla bagga meecetta. Shin hintte gaathay uuzetethaninne iitatethan kumis. ");
INSERT INTO gofRNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Hinttenoo, eeyato, kare baggaa medhdhidayssi gaatha medhdhiday iya gidenneyye? ");
INSERT INTO gofRNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Shin quuliyaninne shaatiyan de7eyssa manqotas immite. He wode hinttew ubbabay geeshshi gidana. ");
INSERT INTO gofRNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Farisaaweto hinttena ayye, sawoppe, xalooteppe, hessa melabaappe asraata kesseta. Shin xillotethinne Xoossaa dosoy hinttenan baawa. Harata aggonna hayssatakka oothanaw bessees, shin aggideta. ");
INSERT INTO gofRNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Farisaaweto hinttena ayye, Ayhude Woosa Keethan bonchcho oyde, giya giddon bonchcho sarotho doseeta. ");
INSERT INTO gofRNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Malay dhayin asay eronna bollara biya duufo daaneyssato hinttena ayye” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Higge asttamaarey zaaridi, “Asttamaariyaw, ne hessa gashe nuna cayaasa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesuusi, “Hinttenoo, higge asttamaareto, hinttenakka ayye, asay tookkanaw dandda7onna deexo tooho toosseeta, shin hinttee hintte huu7es hari attoshin biradhdhe xeerankka bochcheketa. ");
INSERT INTO gofRNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Hintte aawati wodhida nabeta duufuwa hintte giigisiya gisho hinttena ayye. ");
INSERT INTO gofRNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Hiza, hintte aawata oosuwa minthanaw entti wodhida nabeta duufuwa hintte loythiya gisho entta iita oosuwas hintte markka. ");
INSERT INTO gofRNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Hessa gisho, Xoossay ba cinccatethan, ‘Nabetanne hawaareta ta hinttew kiittana, shin hintte baggata wodhana; harata gooddana’ yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Hessa gisho, ha yeletethay alamey medhettoosappe hanno gakkanaw gukkida nabeta ubbaa suuthas oyshettana. ");
INSERT INTO gofRNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Aabelappe doomidi yarshsho bessaasinne Xoossa Keethaafe gidduwan gukkida Zakkariyaasa suutha gisho ha yeletethay oyshettana. ");
INSERT INTO gofRNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Higge asttamaareto, hinttena ayye, eratetha qulppiya hintte kushen oykkideta, shin hinttew gelekketa haratakka gelsseketa.” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yesuusi yaappe baanaw keyaa wode higge asttamaaretinne Farisaaweti iyara eqettidi oyshon waaysosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Iya doonappe keyaa qaalan iya oykkanaw koyidi hessa oothidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","He wode daro mukulun taybettiya asay woli bolla yedhdhettana gakkanaw asi asa bolla shiiqidi de7ishin, Yesuusi ba tamaaretakko, “Farisaaweta irshshuwaafe naagettite. Hessika entta cubbotethaa. ");
INSERT INTO gofRNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Qoncconna qosettidi, erettonna geemmidi attiyaabay aykkoyka baawa. ");
INSERT INTO gofRNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Hiza, hintte dhuman odidabay ubbay poo7on si7ettana, qol77a gaathan kalkkashidabay dabaaban odettana. ");
INSERT INTO gofRNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Ta baggato, ta odeyssa si7ite; ashuwa wodhoosonappe attin haraa aykkoka oothanaw dandda7onnayssatas babbofite. ");
INSERT INTO gofRNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Hanoshin, hintte babbanaw besseyssa ta hinttew qonccisana. Hessika wodhidaappe guye Gaannamen yegganaw wolqqay de7eyssas iyaw babbite. Ee, tuma gays; iyaw babbite. ");
INSERT INTO gofRNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ichchashu buubbeti issi santimes bayzettokonaayye? Hanoppe attin enttafe issinnaka Xoossaa sinthan dogetuku. ");
INSERT INTO gofRNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Hari attoshin, hintte huu7e binaanaykka paydettidi de7ees. Hiza, babbofite; daro buubbetappe hintte aadhdheeta. ");
INSERT INTO gofRNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Ta odeyssa si7ite; asa sinthan taw markkattiya ubbaas Asa Na7ay Xoossaa kiitanchchota sinthan markkattana. ");
INSERT INTO gofRNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Asa sinthan tana kaddeyssas Xoossaa kiitanchchota sinthan ta iya kaddana. ");
INSERT INTO gofRNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Asa Na7a bolla kadhe qaala haasayaa ubbay maarota demmana, shin Geeshsha Ayyaana bolla kadhe qaala odetteyssi maaretenna. ");
INSERT INTO gofRNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Asi hinttena oykkidi Ayhude Woosa Keethan, daynnata sinthaninne kawota sinthan gooshechchiya wode ay odaneekkonne woygi zaaraneekko hirggofite. ");
INSERT INTO gofRNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","He wode hintte odanabaa Geeshsha Ayyaanay hinttena tamaarssana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Asaa giddofe issi asi Yesuusakko yidi, “Ta ishay taw nu aawa laatappe shaakkana mela iyaw oda” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yesuusi zaaridi, “La addiyaw, hintte bolla tana daynnanne laata shaakkiya cima oothiday oonee?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Qassika Yesuusi, “Asa de7oy shalo darotethan gidonna gisho yaare aggidi minthidi hinttena naagite” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Kaallidikka leemison, “Gadey daro kathi immiya issi dure uray de7ees. ");
INSERT INTO gofRNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","He uray, ‘Ta kathaa taani shiishanaw bessi guuxida gisho ay ootho?’ yaagidi ba wozanan qoppis. ");
INSERT INTO gofRNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Hizappe yaatana; kase de7iya shaaleta laallada haraa dalgga shaaleta keexana. Kathaanne taw de7iyaba ubbaa iyan yeggana. ");
INSERT INTO gofRNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ba shemppeeko, ‘Ta shemppete, daro laythas new gidiya shalo shiishas. Hiza, shemppada ma, uya, ufaytta’ yaagana. ");
INSERT INTO gofRNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Shin Xoossay, ‘La, eeya addiyaw, hachchi qamma ne shemppiya neeppe ekettawusu. Hiza, ne shiishidabay ooddees gidanee?’ yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Hessa gisho, baw duretethi sa7an shiishiya asas, Xoossaa matan dure gidonna asaas wurssethay ha urayssa mela” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Hessafe guye, Yesuusi ba tamaaretakko, “Hiza, ta odiyabaa si7ite, hintte shemppuwas ay mino hintte bollaas ay ma77ino yaagidi un77ettofite. ");
INSERT INTO gofRNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Shemppoy kathafe bolli afilappe aadhdhees. ");
INSERT INTO gofRNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Kafota be7ite zerokkona, kiishokkona, eleykka shaaleykka baawa. Shin Xoossay enttana muzees. Hintte kafotappe daro aadhdheeta. ");
INSERT INTO gofRNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Hanoshin, hinttefe un77ettidi ba laythaa bolla issi qamma gujjanaw dandda7ey oonee? ");
INSERT INTO gofRNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Hiza, ha guuthabaa oothanaw dandda7onna hintte harabaas ays un77etteetii? ");
INSERT INTO gofRNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ane cishshati waanidi dicciyakko be7ite. Waayokkonanne suqqokona. Hari attoshin, Solomoney ba de7iya bonchcho ubban enttafe issuwa melakka ma77ibeena. ");
INSERT INTO gofRNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Hinttenoo, ammanoy paccidayssato, hiza, Xoossay hachchi benttidi wontto taman yegettana cishshata hayssada mayzikko, hinttena waati aathi mayzennee? ");
INSERT INTO gofRNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Hessa gisho, ay miino woykko ay uyino gidi un77ettofite. ");
INSERT INTO gofRNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","He ubbaas Xoossaa ammanonna asati un77ettoosona. Shin hintte aaway Xoossay hessi ubbay hinttew koshsheyssa erees. ");
INSERT INTO gofRNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ubbaafe aathidi Xoossaa kawotethaa koyite hessi ubbay hinttew gujji imettana. ");
INSERT INTO gofRNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Hinttenoo, guutha deretoo, yayyofite; hintte aawa Xoossay kawotethaa hinttew immanaw ufayttees. ");
INSERT INTO gofRNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Hinttew de7iyabaa bayzidi manqotas immite. Kaysoy ekkonnason, bili moonnason, cimonna karxiitan, wuronna shaluwa saluwan shiishite. ");
INSERT INTO gofRNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Hintte wozanay hintte shaloy de7iyasuwan gidana. ");
INSERT INTO gofRNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Qanthan danccidi giigettite; hintte xomppey poo7idayssa gido. ");
INSERT INTO gofRNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Bantta goday yaaganoppe simmana gakkanaw barkkidi naageyssatada, goday yidi xeegiya wode ellesidi dooyanaw giigida asata daanite. ");
INSERT INTO gofRNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Bantta goday simmiya wode dhiskkonna de7ishe naageyssati anjjettidayssata. Tuma gays; goday qanthan danccidi gayta yuushuwan utisidi mokkees. ");
INSERT INTO gofRNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Goday laade gidin giddi bilahe gidin woykko wonttimaathe gidin yidi, hessa mela dhiskkonna naagishin demmiya he aylleti anjjettidayssata. ");
INSERT INTO gofRNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Shin hayssa erite; kaysoy awude yaanekko keethaaway eriyakko keethay boketiya wode si77i gidi be7enna. ");
INSERT INTO gofRNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Hintteka giigidi naagite; Asa Na7ay hintte qopponna wode yaana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Phexiroosikka, “Godaw ha leemisuwa nu xalaalas odayye woykko asa ubbaasee?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Goday zaaridi, “Hiza, kathaa muzanaw bessiya wodiyan immana mela goday ba aylleta bolla shuumida ammantheysinne wozanaama halaqay oonee? ");
INSERT INTO gofRNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Goday simmiya wode hessa mela oothishe benttiya aylley I anjjettidayssa ");
INSERT INTO gofRNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ta hinttew tuma odays; ba godaas de7iya shalo ubbaa bolla I shuumettana. ");
INSERT INTO gofRNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Shin he aylley, ‘Ta goday elle yeenna’ yaagidi ba wozanan qoppidi, macca aylletanne adde aylleta wadhdhiko, qassi baw koyida mela mishenne uyishe mathottiko, ");
INSERT INTO gofRNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","he aylliya goday I qopponna gallasaninne hirggonna wode yaana. Yidi iya qanxerethidi, iya qaada ammanonna asatara oothana. ");
INSERT INTO gofRNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Godaa sheniyada giigonnayssinne iya goday ay dosiyakko erishe oothonna aylley daro garaafettana. ");
INSERT INTO gofRNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Shin ba godaa sheniya eronna attidi garaafettanaw besseyssa oothiday guuthara garaafettana. Gaasoykka daro imettidayssafe daro koyettees, daro hadara ekkidayssafekka daro immana gidi naagettees. ");
INSERT INTO gofRNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Taani yiday biitta bolla tama oythanaassa. Ha77i tamay oykkiyako tana waati ufayssanddeshsha! ");
INSERT INTO gofRNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Hanoshin, ta ha77i xammaqettiya xinqqatey de7ees. I polettana gakkanaw ta daro un77ettays. ");
INSERT INTO gofRNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Sa7a bolla sarotethi ehanaw yida hinttew daanii? Gidenna, ta yiday shaakkanaassa. ");
INSERT INTO gofRNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ha77ife doomidi woli giddon shaakettida ichchashu keethaa asati issife de7oosona. Nam77ati heedzata bolla, heedzatikka nam77ata bolla, denddidi shaakettoosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Aaway na7aa bolla, na7aykka aawa bolla, aayyaa na7ee bolla, na7iya aaye bolla, azinaa aayyaa na7aa machche bolla, na7aa machchiya azinaa aaye bolla, denddidi shaakettana.” ");
INSERT INTO gofRNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Qassika asaakko, “Wuloha baggara saloy shaaratiya wode be7idi, ellesidi, ‘Iri yaana’ yaageta, hessadakka hanees. ");
INSERT INTO gofRNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Dugeha carkkoy carkkiya wode ‘Sa7ay awana’ yaageta, hessadakka hanees” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Hinttenoo, cubboto, Salobaanne sa7abaa shaakki ereetashin ha wodiya shaakki eroy hinttena waanidi xoonidee? ");
INSERT INTO gofRNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Yaatin, hintte huu7es ays tuma pirddeketii? ");
INSERT INTO gofRNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ne morkkiyara wolla daynna sinthan eqqanaw bashe oge bolla giiganaw koya. Ne giigonna ixxiko gooshechchidi daynna sinthi nena efana. Daynnay nena poolisees aathi immana. I nena woynen yeggana. ");
INSERT INTO gofRNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Si7ite, issi bakkani attonna cigga onggana gakkanaw ne yaappe keyonnayssa era” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","He wode Yesuusakko asay yidi Philaaxoosi wodhidi entta suuthaara entta yarshshuwa walakkida Galiila asaabaa odida asati he bessan de7oosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","I hayssada yaagidi zaaris; “Yaatin he Galiila asati he iita hayqo hayqqida gisho Galiilan de7iya asa ubbaafe aadhdhida nagaranchcho daanoona? ");
INSERT INTO gofRNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Gidenna! Gidoshin, hintteka maarotan simmona ixxiko, ubbay hessada dhayana. ");
INSERT INTO gofRNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Woykko qassi Salihoome giya bessan gimbbey woddidi wodhida tammanne hosppun asay Yerusalaamen de7iya asa ubbaafe aadhdhida nagaranchcho daanoona? ");
INSERT INTO gofRNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Gidenna! Shin hintteka maarotan simmona ixxiko ubbay hessada dhayana.” ");
INSERT INTO gofRNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Qassika Yesuusi hayssada gidi leemiso odis: “Issi uraas woyne gaden tokettida balase mithiya de7awusu. I iippe ayfe koyii yidi aykkoka demmibeenna. ");
INSERT INTO gofRNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Gadiya goday woyne oosanchchuwakko, ‘Ayfe demmanaw koyada heedzu laythi simerettada aykkoka demmabiikke. Hessa gisho, qanxa digga; ays biittaa melisay?’ yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Shin oosanchchoy, ‘Godaw, I yuushuwa oothada osha yeggana gakkanaw ha laythas aggarkii. ");
INSERT INTO gofRNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ha laythi ayfikko lo77o, ixxiko qanxa agga’ ” yaagidi zaaris. ");
INSERT INTO gofRNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Yesuusi Sambbaata gallas Ayhude Woosa Keethan tamaarssees. ");
INSERT INTO gofRNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","He bessan tammanne hosppun laythi tuna ayyaani zokko kuunisida issi maccasiya de7awusu. Iya kuunappe denddoyssan suure eqqanaw dandda7ukku. ");
INSERT INTO gofRNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesuusi iyo be7ida wode xeegidi, “Ha maccasete, ne harggiyafe paxadasa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ba kushiya I bolla wothin, iya sohuwara suurada eqqasu. Xoossaaka galatasu. ");
INSERT INTO gofRNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Shin Ayhude Woosa Keetha halaqay yilotidi asaakko, “Ooso oothiya usuppun gallasati de7oosona. Hessa gisho, he gallasatan yidi paxiteppe attin Sambbaata gallas gidenna” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Goday, “Cubboto, hintte giddofe boori woykko hare Sambbaata gallas zadalope billidi haathe ushshanaw efonnay oonee? ");
INSERT INTO gofRNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Yaatin, ha maccasiya Abrahame na7aa gidashe xalahen qashettada tammanne hosppun laythi kumethi de7idaaris Sambbaata gallas birshshetethi koshshennee?” yaagidi oychchis. ");
INSERT INTO gofRNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","I hessa odida wode eqetteyssati ubbay yeellatidosona. Shin asa ubbay I oothida malaalisiya ooso ubban ufayttidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Hessafe guye, Yesuusi hayssada yaagis, “Xoossaa kawotethay ay daanii? Iya aybira daaniso? ");
INSERT INTO gofRNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Xoossaa kawotethay issi asi ba goshshan tokkida wola ayfe mela. I diccidi mithi gidis. Salo kafoti iya tashiya bolla shemppidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Qassi, “Xoossaa kawotethaa aybira daaniso? ");
INSERT INTO gofRNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Issi maccasiya daro dhiillera walakkada munuqida guutha irshsho daanees” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Hessafe guye, Yesuusi Yerusalaame bishe I kanthiya ogiyan de7iya katamataninne gutatan tamaarssishe aadhdhis. ");
INSERT INTO gofRNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Issi asi Yesuusakko, “Godaw, attanay guutha asa xalaalee?” yaagidi oychchis. Yesuusi enttako, ");
INSERT INTO gofRNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Si7ite, xuuntha wulaara gelanaw baaxetite. Daroti gelanaw koyoosona shin enttaw hanenna. ");
INSERT INTO gofRNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Keethaaway denddidi wulaa gorddidaappe guye ‘Nuus dooyarkii’ yaagishe karen eqqidi xeessi oykkeeta. Shin I, ‘Hintte ooneekkonne awuppe yidaakko ta erikke’ gidi zaarana. ");
INSERT INTO gofRNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","He wode hintte, ‘Neera wolla mida, uyida, nu dabaabankka tamaarssadasa’ yaagana. ");
INSERT INTO gofRNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“I zaaridi, ‘Hintte ooneekkonne awuppe yidaakko erikke. Hinttenoo, geellato taappe haakkite’ yaagana. ");
INSERT INTO gofRNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Abrahame, Yisaaqa, Yayqoobanne nabeta ubbaa Xoossaa kawotethan be7ana, shin hintte karen wodhdhidi attiyaa wode hinttew yeehonne achche garccethi gidana. ");
INSERT INTO gofRNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Asay dolohappe, wulohappe, pudehappenne dugehappe yidi Xoossaa kawotethan gibira bolla uttana. ");
INSERT INTO gofRNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Hessa gisho, ha77i dethan guye gididayssatappe sinthe gidanayssati, sinthe gididayssatappe guye gidanayssati de7oosona” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","He wode Farisaawetappe issoti issoti yidi, “Heroodisi nena wodhanaw koyaa gisho ha bessafe denddada ba gidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","I zaaridi, “Bidi, he workkanaas hekko, ‘Hachchinne wontto tuna ayyaanata kessana, hargganchchota pathana, heedzantho gallasan kuushsha bolla gakkana’ yaagis giite. ");
INSERT INTO gofRNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Hanoppe attin, nabey Yerusalaameppe karen hayqqanaw bessenna. Hessa gisho, hachchi, wonttonne wontti pee7in he bessaa baanaw denddas. ");
INSERT INTO gofRNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Yerusalaame, Yerusalaame, nabeta wodhiyare, neekko kiitettidayssata shuchchan caddiyare, kuttoy ba nayta ba qefiyappe garssan shiishiyada ne nayta ta qesiyappe garssan aappun toho shiishanaw koyadina, shin hintte ixxas gideta. ");
INSERT INTO gofRNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ta hinttew odays; hintte keethay kaysattana. Godaa sunthan yeyssi anjjettidayssa hintte gaana gakkanaw tana demmeketa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Issi Sambbaata gallas Yesuusi issi Farisaaweta halaqaa soo kathi maanaw geliya wode asay caddi xeellosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","He bessan shawuhe harggen waayettiya issi asi iyaw sintha baggara zin77is. ");
INSERT INTO gofRNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesuusi Farisaawetakkonne higge asttamaaretakko, “Sambbaata gallas hargganchcho pasoy wogeyye woga gidennee?” yaagidi oychchis. ");
INSERT INTO gofRNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Entti si77i gidosona. Yesuusi harggettiya uraa bochchi pathidi moyzis. ");
INSERT INTO gofRNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","“Qassika hinttefe issuwas na7i woykko boori Sambbaata gallas aafon wulliko ellesidi kessonnay oonee?” yaagidi oychchis. ");
INSERT INTO gofRNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Entti issibaakka zaaranaw dandda7ibookkona. ");
INSERT INTO gofRNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yesuusi imatuwas xeegettidayssati bonchcho bessi doorishin be7idi, ha leemisuwa odis: ");
INSERT INTO gofRNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Issi asi nena yaagano xeegikko bonchcho bessan uttofa. Neeppe aadhdhi bonchchettiya asi xeegettanaw dandda7ees. ");
INSERT INTO gofRNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Hinttena nam77atakka xeegidayssi yidi, ‘Ne bessaa ha imathaas yedda’ yaagiya wode neeni yeellatashe ziqqa bessi wodhdhaasa. ");
INSERT INTO gofRNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Gidoshin, ne xeegettida wode koyrottada ziqqa bessi be7ada utta. Xeegoyssi yidi, ‘Ta laggiyaw, ha bonchcho bessan utta’ yaagana. He wode neera issife xeegettida asa ubbaa sinthan ne bonchchettana. ");
INSERT INTO gofRNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Bana dhoqqu dhoqqu oothiya ubbay kawuyana; bana ziqqi ziqqi oothiya ubbay dhoqqu dhoqqu gaana.” ");
INSERT INTO gofRNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Qassi Yesuusi iya mokkida keethaa aawakko, “Quma woykko kaho imato xeegiya wode neeni kushe zaaro xeegonna mela ne laggeta woykko ne ishata woykko ne dabbota woykko ne dure shoorota imato xeegoppa. ");
INSERT INTO gofRNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Gidoshin, ne imato giigisida wode manqota, wobbeta, gunddatanne qooqeta xeega; neeni anjjettana. ");
INSERT INTO gofRNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Hayssati kushe zaaranaw dandda7onna gisho kushe zaaroy geeshshata denddo gallasan new simmana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Yesuusara wolla imato bolla uttoyssata giddofe issoy hessa si7idi, “Xoossaa kawotethan imato bolla utteyssi anjjettidayssa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yesuusi, “Issi asi gita imato giigisidi daro asata xeegis. ");
INSERT INTO gofRNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Imatoy mokettiya saatey gakkiya wode xeegettida imathata, ‘Hekko ubbabay giigis, haa yiite’ yaagidi xeeganaada ba aylliya kiittis. ");
INSERT INTO gofRNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Shin ubbayka bantta gaaso gaaso medhdhidosona. Issoy, ‘Ha77i buroo gade shammida gisho bada be7anaw koshshees hayyana tana aggarkii yaaga’ yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Hankkoy, ‘Ichchashu waatha boori shammas enttana waaxa be7ana gisho hayyana tana lanccofa’ yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Qassi haray, ‘Taani buroo meddan de7iya gisho yaanaw dandda7ikke’ yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Aylley simmi yidi he ubbaa ba godaas odis. He wode yaagano aaway hanqettidi aylliyako, ‘Ellesada kataman de7iya wogga ogetanne daggalata bada, manqota, wobbeta, qooqetanne gunddata haa eha’ yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Aylley, ‘Ta godaw, ne kiittidayssi ubbay polettis, shin ha77ika bessi de7ees’ yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Goday aylliyako, ‘Horogata bollanne, gade giddo ogeta keya, ta keethay kumana gakkanaw demmida ubbaa yaana mela ootha. ");
INSERT INTO gofRNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ta hinttew odays; imatotidayssatappe oonikka ta gibiraappe moonnayssa erite’ gis” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Daro asay iyara wolla bishin Yesuusi enttako guye simmidi, ");
INSERT INTO gofRNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Taakko yaa ubbay ba aawanne ba aayiw, ba machchiwunne ba nayta, ba ishatanne ba michcheta, hari attoshin ba de7uwa ixxonnay ta tamaare gidanaw dandda7enna. ");
INSERT INTO gofRNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ba masqaliya tookkidi tana kaallonnay ta tamaare gidanaw dandda7enna. ");
INSERT INTO gofRNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Hinttefe issi asi shuchcha keethi keexanaw koykko, keethaa keexidi ongganaw ay mela miishe koshshiyako koyrottidi eranaw qoppi be7onnay oonee? ");
INSERT INTO gofRNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Hessa gidonna ixxiko, ha uray baaso shuchchaa hiixin qusttethi xoonikko, ");
INSERT INTO gofRNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","be7iya ubbay, ‘Ha uray gimbbethi oykkin qusttanaw iya xoonis’ yaagidi boroosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Woykko issi kawoy hara kawora olettanaw denddishe laatamu mukulu olanchchota ekki yaa kawuwara tammu mukulu olanchchotara eqettanaw dandda7anayssanne dandda7onayssa uttidi zorettonnay oonee? ");
INSERT INTO gofRNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Eqettanaw dandda7ettonaba gidikko, he hara kawuwara haahon de7ishin giiganaw koyrottidi cima yeddidi oychchees. ");
INSERT INTO gofRNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Hessadakka, hinttefe oonikka baw de7iyaba ubbaa aggonna ixxiko ta tamaare gidanaw dandda7enna. ");
INSERT INTO gofRNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Maxiney lo77o, shin maxiney ba mal77uwa aggiko, waanidi maxine geetettanaw dandda7ii? ");
INSERT INTO gofRNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Biittatethaaskka araddatethaaskka maaddonabaa gidiya gisho wora yegettees. Hiza, si7iya haythi de7iya asi si7o” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Issi gallas qaraxa qanxeyssatinne nagaranchchoti Yesuusa timirttiya si7anaw iya yuushuwan shiiqidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Shin Farisaawetinne higge asttamaareti, “Hayssi uray nagaranchchota shiishidi ekkees, enttara issife mees” yaagidi zuuzummidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Yesuusi yaagidi hayssa leemiso enttaw odis: ");
INSERT INTO gofRNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Hintte giddofe issuwas xeetu dorssati de7iyabaa gidikko enttafe issoy dhayikko uddufun tammanne uddufunata bazzon aggidi dhayoyssa demmana gakkanaw koyonnay oonee? ");
INSERT INTO gofRNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Demmida wode ufayttidi ba gannan tookkidi, ");
INSERT INTO gofRNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ba soo simmees. Ba laggettanne shoorota issife xeegidi, ‘Dhayida ta dorssaa demmas, taara issife ufayttite’ yaagees. ");
INSERT INTO gofRNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Hessadakka, maaroti koshshonna uddufun tammanne uddufun xillotappe aathidi maarotan geliya issi nagaranchchuwa gaason salon gita ufayssi gidees. ");
INSERT INTO gofRNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Woykko tammu biri de7iya issi maccasiya tammaafe issiya dhayikko demmana gakkanaw xomppe oythada keethaa pittada mintha koyonnara oonee? ");
INSERT INTO gofRNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Demmida wode ba laggettanne ba shoorota xeegada ‘Dhayida ta issi bira demmida gisho taara ufayttite’ yaagawusu. ");
INSERT INTO gofRNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Si7ite, hessa mela issi maarotethan geliya nagaranchchuwan Xoossaa kiitanchchota sinthan ufayssi gidees” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Zaaridi Yesuusi, “Issi uraas nam77u nayti de7oosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Enttafe kaalo na7ay ba aawakko, ‘Ta aawaw, ne shaluwappe ta gishuwa taw imma’ yaagis. Aaway ba shaluwa ba naytas shaakkis. ");
INSERT INTO gofRNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Guutha gallasappe guye kaalo na7ay ba gishuwa ubbaa qachchi ekkidi haaho biitta bis. Yan alttacan shaluwa toochchidi onggis. ");
INSERT INTO gofRNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","I baw de7iyaba ubbaa wurssidaappe guye he biitta ubban mino koshi keyin metootis. ");
INSERT INTO gofRNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Hessa gisho, he biittaa asaappe issuwa soo gaata gelis. Uray iya guduntho heemmana mela ba moothaa yeddis. ");
INSERT INTO gofRNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Gudunthoti miya harquwafe maanaw amottis, shin iyokka iyaw immiya asi benttibeenna. ");
INSERT INTO gofRNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Wozani simmin, ‘Aappun ta aawa aylletas kathi wora wodhdhin ta hayssan koshara hayqqanaw gakkadina?’ ");
INSERT INTO gofRNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Denddada ta aawakko bada, ‘Ta aawaw, salon Xoossaa, sa7an nena qohas. ");
INSERT INTO gofRNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Hizappe ne na7a geetettada xeegettanaw taw bessonna gisho ne son de7iya aylletappe issuwada tana payda’ yaagana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Hessa gisho, denddidi ba aawakko bis. “Hanoshin, I buroo haahon de7ishin aaway qadhettidi, iyaakko woxxi bidi idimmidi yeeris. ");
INSERT INTO gofRNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Na7aykka, ‘Ta aawaw salon Xoossaa, sa7an nena ta qohas. Hizappe ne na7a geetettada xeegettanaw bessike’ yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Iya aaway aylleta xeegidi, ‘Ellesidi ubbaafe lo77o gidida ma7o ehidi iya mayzite; iya biradhdhen sagaayo, iya tohuwan caamma aathite. ");
INSERT INTO gofRNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Modhdho gatarmentho ehidi shukkite, moos, ufayttoos. ");
INSERT INTO gofRNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ta na7ay hayssi hayqqis, shin ha77i paxis; dhays, shin benttis’ yaagis. Hessafe guye, ufayetethi oykkidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“He wode bayra na7ay goshsha gaden de7ees. Yaappe yishe soo matishin yethinne gufa girssi si7is. ");
INSERT INTO gofRNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","I, aylletappe issuwa xeegidi haniyabay aybeekko eranaw oychchis. ");
INSERT INTO gofRNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Aylley, ‘Ne ishay saro yida gisho ne aaway modhdho gatarmentho iyaw shukkis’ yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Bayra ishay yilotidi soo gelanawukka koyibeenna. Aaway kare keyidi soo gelana mela iya woossis. ");
INSERT INTO gofRNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Shin I ba aawakko, ‘Hekko, hayssa mela laythi ta new aylletada ne kiitaappe issuwaka pacisonna new kiitettin ta ta laggetara ufayttana mela hari attoshin issi laaqa deeshe immabaakka. ");
INSERT INTO gofRNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Hanoshin, hayssi ne na7ay ne shaluwa laymatara doomisidi yin modhdho gatarmentho shukkadasa’ ” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Aawaykka, ‘Ta na7aw, neeni ubba wode taara de7aasa, tabay ubbay neessa. ");
INSERT INTO gofRNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Hayssi ne ishay hayqqis, shin paxis; dhays, shin benttis. Hessa gisho, daro ufayttanaw bessees’ yaagana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesuusi ba tamaaretakko, “Issi dure uraas iyappe garssara issi shuumay de7ees. He shuumay ba godaa shaluwa toochchees yaagiya worey keethaawa gakkis. ");
INSERT INTO gofRNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Keethaaway shuumaa xeegisidi, ‘Taani woygiyabaa si7adinaa? Hizappe neeni ta keethas shuuma gidada oothanaw dandda7onna gisho ta shaluwa taw sheedhdha’ yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“He shuumaykka ba wozanan hayssada yaagidi qoppis. ‘Ta goday tana shuumatethaafe wothana hanees, goya aqanaw wolqqi baawa, woossa maanaw yeellayees; yaatin ta waano? ");
INSERT INTO gofRNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Shuumatethaafe ta wodhdhiya wode asay tana mokkana mela oothanabaa ta erays’ yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Hessa gisho, iya godaa acoy de7iya asaa issuwa issuwa xeegi ehidi koyro uraakko, ‘Ne bolla ta godaa acoy ay meli de7ii?’ yaagidi oychchis. ");
INSERT INTO gofRNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“I, ‘Laatamu barmeele zayte acoy de7ees’ yaagis. “Shuumay, ‘Wule warqattiya he7e, ellesada, tammu barmeele zayte acoy de7ees gada xaafa’ yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Hessafe kaallidi nam77anthuwako, ‘New aappuni de7ii?’ yaagis. “I, ‘370 kunttaale gistte acoy de7ees’ yaagis. “Shuumay, ‘Ne wule warqattiya he7e, ellesada, 296 kunttaale yaagada xaafa’ yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Keethaaway ammanettiboonna shuumaa iya bilaamatethaas nashshis. Ha alamiya nayti ase oythan poo7o naytappe aadhdhida wozanaamata. ");
INSERT INTO gofRNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Hessa gisho, ta hinttew odays; ha alamiya miishey wuriya wode merinaa keethan mokettana mela ha miishiyara hinttew laggeta shammite. ");
INSERT INTO gofRNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ubbaafe guuthaban ammanettiday daroban ammanettidayssa gidees. Qassi ubbaafe guuthaban ammanettonnayssi daroban ammanettenna. ");
INSERT INTO gofRNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Hiza, ha alamiya miishen hintte ammanettonna ixxiko tuma miishe hinttew ooni hadara immanee? ");
INSERT INTO gofRNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Hintte hara asa miishen ammanettonna ixxiko, hintte buzo miishe hinttew ooni immanee? ");
INSERT INTO gofRNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Issi aylley nam77u godatas haarettanaw dandda7enna. Issuwa ixxiko hankkuwa dosees woykko issuwako shiiqikko hankkuwa kadhees. Hessadakka, hintte Xoossasinne miishes haarettanaw dandda7ekketa.” ");
INSERT INTO gofRNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Miishe dosiya Farisaaweti hessa si7ida wode Yesuusa qelqisidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","I, “Hinttee hinttena asa sinthan xilliseeta, shin Xoossay hintte wozanaa erees. Asa sinthan bonchchettidayssi Xoossaa sinthan borettidayssa. ");
INSERT INTO gofRNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Muse higgeynne nabeta kiitay Yohaannisa gakkanaw hinttew odettishe gam77is. Hessafe guye, Xoossaa kawotethaa Wonggelay sabbakettishe gam77is. Asi ubbay yaa gelanaw dafettees. ");
INSERT INTO gofRNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Gidoshin, higgiyafe issi laafa pidaaley attanaappe saloynne sa7ay aadhdheyssi kawuyees. ");
INSERT INTO gofRNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Ba machchiw yeddidi haraa ekkiya ubbay laammees. Ba azinaappe anjjettidaaro ekkeysika laammees” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Al77onne alleeqo afila ma77iya, sa7i injjetin gallas gallas ufayssan de7iya issi dure asi de7ees. ");
INSERT INTO gofRNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Hari qassi asatethay kumethi madunxida issi Alaazara geetettiya manqoy he dure uraa karen yegetidi attidayssi de7ees. ");
INSERT INTO gofRNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Koshappe denddoyssan dure uraa gaytappe wodhdhiya tiifiya maanaw amottishe de7ees. Hari attoshin, kanati yidi iya madunthaa laaccosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“He manqoy hayqqis; kiitanchchoti iya Abrahame ki7uwa efidosona. Qassi dure uraykka hayqqidi moogettis. ");
INSERT INTO gofRNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Si7oolen un77ettidi de7ishe dhoqqu gidi haahon Abrahamenne iya ki7on de7iya Alaazara be7is. ");
INSERT INTO gofRNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","I, ‘Aawaw Abrahame, taw qadhettarkii; ha laco taman un77ettada de7iya gisho Alaazari ba biradhdhiya haathan yeddidi ta inxarssaa laakothana mela hayyana iya yeddarkki’ yaagidi waassis. ");
INSERT INTO gofRNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Shin Abrahamey iyaakko, ‘Ta na7aw, ne sa7an de7iya wode lo77obaata ekkidayssa, qassi Alaazari iitabata ekkidayssa akeeka. Shin ha77i I hayssan ufayttees, qassi neeni waayettashe de7aasa’ yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ha ubbaafe aadhdhidi, ‘Haappe hintteko, hinippe haa nuukko aadhdhanaw koyeyssati pinnonna mela nuusinne hinttes giddon gita aafoy de7ees’ yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Dure uray, ‘Aawaw, yaakko Alaazara ta aawa soo kiittana mela ta nena woossays. ");
INSERT INTO gofRNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Taw ichchashu ishati de7idosona, enttika ha waaye bessaa yoonna mela enttaw bidi markkatto’ yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Shin Abrahamey, ‘Enttaw Museranne nabetara de7oosona; entti odiyabaa si7ona’ yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Dure uray, ‘Aawaw Abrahame, hessatho gidenna; issi asi hayqoppe denddidi biikko entti maarotan gelana’ yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Abrahamey, ‘Musenne nabeta si7onna ixxiko, hari attoshin hayqoppe issi asi denddi odikkoka ammanokkona’ yaagis.” ");
INSERT INTO gofRNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesuusi ba tamaaretakko, “Ase dhubethidi nagaran gelssiyabay yoonna aggenna. Gidoshin, nagaran gelana mela oothiya uraa ayye” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","He uray kaalotappe issuwa balethanaappe woxa ba qoodhen qachchidi abban wulliko iyaw lo77o. ");
INSERT INTO gofRNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Hessa gisho naagettite. “Ne ishay nagara oothiko hanqetta; qiirottidi maarotethan simmiko, iyaw atto yaaga. ");
INSERT INTO gofRNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Issi gallasan laappun toho qohidi, laappun toho, ‘Taani ta balaa eras tana maara’ yaagidi neekko yiikko iyaw atto ga.” ");
INSERT INTO gofRNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Hawaareti Godaakko, “Ammano nuus gujjarkkii” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Goday, “Gaashe ayfe mela ammanoy hinttew de7ikko ‘Hayssa wolaa shodettada abbaa giddon toketta’ yaagikko hinttew kiitettana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Gujjidikka Yesuusi, “Hintte giddofe issuwas goshshanchchoy woykko dorsse heemmiya aylley de7ikko ooso gadeppe woykko wudeppe soo simmiya wode ‘Elle haayada kathi maanaw utta’ yaagey de7ii? ");
INSERT INTO gofRNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Deenna, ‘Taw kaho giigisa; taani mada, uyada aggana gakkanaw eqqada muza. Hessafe guye, neeni qassi maasanne uyaasa’ yaagenneyye? ");
INSERT INTO gofRNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Hiza, goday, aylley kiitaa polida gisho anjjiyye? ");
INSERT INTO gofRNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Hessa gisho, hintteka kiitettoyssa ubbaa polida wode ‘Nu pathonna aylleta; oothanaw bessiya oosuwa polida’ yaagite” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesuusi Yerusalaame bishe Samaarisinne Galiila biittaas giddora kanthidi aadhdhis. ");
INSERT INTO gofRNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Issi gutaa geliya wode baro harggen oykettida tammu asati iya demmidosona. Enttika haahon eqqidi, ");
INSERT INTO gofRNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","“Godaa Yesuusa, nuus qadhettarkii” yaagidi waassidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","I entta be7ida wode “Bidi hinttenatethaa Ayhude kahine bessite” yaagis. Entti ogiya bolla bishe paxidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Enttafe issoy ba paxuwa be7ida wode dhoqqu gida qaalan Xoossaa bonchchishe Yesuusakko simmis. ");
INSERT INTO gofRNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","I Samaare biitta asi, shin Yesuusa tohuwa bolla gufannidi iya galatis. ");
INSERT INTO gofRNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yesuusi, “Paxiday tammu asata gidokkonaayye? Yaatin, uddufunati aw bidonaa? ");
INSERT INTO gofRNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ha allaga uraappe attin hari simmidi Xoossaa galatey deenna guusseyye?” yaagidi oychchis. ");
INSERT INTO gofRNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Uraakko, “Ne ammanoy nena pathis; denddada ba” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Farisaaweti, “Xoossaa kawotethay awude yaanee?” gidi Yesuusa oychchidosona. I, “Xoossaa kawotethay benttiya mallan yeenna. ");
INSERT INTO gofRNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Qassika iyo, ‘Hannina woykko hinina yaaganaw dandda7enna. Ays giikko, Xoossaa kawotethay hintte giddon de7ees’ ” yaagidi zaaris. ");
INSERT INTO gofRNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Yesuusi ba tamaaretakko, “Asa Na7aa gallasatappe issuwa be7anaw hintte amottiya wodey yaana, shin hintte be7ekketa. ");
INSERT INTO gofRNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Asay, ‘I yan de7ees’ woykko, ‘Hayssan de7ees’ yaagana, shin enttana kaallidi booppite. ");
INSERT INTO gofRNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Wol77anthi wol77ammidi saluwa gaxappe gaxa poo7isiya mela Asa Na7aa yuussaa gallasay hessada hanana. ");
INSERT INTO gofRNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Shin hessi hananaappe sinthe Asa Na7ay daro waayanawunne ha yeletethan ixettanaw bessees. ");
INSERT INTO gofRNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Nohe wode hanidayssa mela Asa Na7aa wodiyankka hessada hanana. ");
INSERT INTO gofRNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Nohey Markkabiyan gelida qammaa gakkanaw asay mishenne uyishe, ekkishenne gelishe de7ishin dhayo haathay yidi ubbaa dhayssis. ");
INSERT INTO gofRNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Looxe laythankka hessatho hanis. Asay mishenne uyishe, shammishenne bayzishe, tokkishenne keexishe, gam77idosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Looxey Soodomeppe keyida gallas diinne geetettiya xuuggiyabay saloppe bukkidi ubbaa dhayssis. ");
INSERT INTO gofRNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Asa Na7ay qoncciya wodekka hessada hanana. ");
INSERT INTO gofRNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“He gallasan oonikka karen de7ey keethaa giddon de7iyabaa ekkanaw soo geloppo. Hessadakka, gaden de7iya asi aykkoskka soo simmofo. ");
INSERT INTO gofRNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Looxe machchiw akeekite; ");
INSERT INTO gofRNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","ba shemppiw ashshanaw koyaa asi oonikka dhayssana; ba shemppiw aathi immiya oonikka I ashshana. ");
INSERT INTO gofRNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ta hinttew odays; he gallasan nam77u asati issi arssan zin77ana. Issoy ekettana, hankkoy attana. ");
INSERT INTO gofRNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Nam77u maccasati wolla gaaccishin issiya ekettana, hankkiya attana. ");
INSERT INTO gofRNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Nam77u asati wolla gaden goyeyssatappe issoy ekettana, hankkoy attana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Entti, “Godaw aw ekettanee?” yaagidi oychchidosona. I, “Bawuti de7iya bessan ankkoti shiiqoosona” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yesuusi ba tamaareta azalonna ubba wode woossana mela tamaarssanaw koyidi yaagidi leemiso odis: ");
INSERT INTO gofRNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Issi kataman Xoossaas yashettonna asaskka yeellatonna issi daynni de7ees ");
INSERT INTO gofRNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","He kataman issi am77iya da7awusu. Iyakka, ‘Tawunne ta morkkiyas giddon de7iya mootuwa pirdda’ yaagada ubba wode he daynnaako simerettawusu. ");
INSERT INTO gofRNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Daynnay guutha wodes I odaa si7onna ixxis, shin guyeppe ba wozanan, ‘Taani Xoossaas yayyonna, asas yeellatonna ixxikokka, ");
INSERT INTO gofRNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ha am77iya tana waaysiya gisho iw pirddana; yaatonna ixxiko ubba wode yada tana salethana’ yaagidi qoppis” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Godaykka, “Geella daynnay gidayssa si7ideta; ");
INSERT INTO gofRNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Xoossay qammanne gallas iyaakko waassiya ba dooridayssatas pirddeneyye? Enttana maaddanaw gam77iyye? ");
INSERT INTO gofRNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ta hinttew odeyssa si7ite, ellesidi pirddana. Gidoshin, Asa Na7ay yaa wode sa7a bolla ammano demmanddeshsha?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Qassi zaaridi, Yesuusi, banttana xillo asada oothidi ceeqetteyssatasinne harata kadheyssatas hayssada yaagidi leemiso odis: ");
INSERT INTO gofRNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Nam77u asati woossanaw Xoossa Keethi bidosona. Issoy Farisaawe hankkoy qassi qaraxa qanxisiya asi. ");
INSERT INTO gofRNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Farisaawey eqqidi baw woossishe, ‘Xoossaw taani harata mela bonqanchcho, geellanne laymatiya asi, aadhdhida qassi ha qaraxa qanxisiya uraa mela gidonna gisho nena galatays. ");
INSERT INTO gofRNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Saaminttafe nam77u toho xoomays, ta demmiyaba ubbaafe asiraata kessays’ yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Shin qaraxa qanxiseyssi qassi haahon eqqidi hari attoshin salo dhoqqu gidi xeellanawukka yayyidi ba tiraa iccishe ‘Xoossaw, tana nagaranchchuwa maararkii’ gidi woossis. ");
INSERT INTO gofRNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ta hinttew odeyssa si7ite; Farisaawiyappe hayssi qaraxa qanxiseyssi Xoossaa sinthan xillo gididi ba soo simmis. Ays giikko, bana dhoqqu dhoqqu oothiya asi kawuyana, bana kawushshiya asi dhoqqu dhoqqu gaana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Yesuusi yooga nayta bolla ba kushiya wothidi anjjana mela asay iyaakko ehoosona. Yesuusa tamaareti hessa be7idi ays Yesuusakko eheeti yaagidi kaccidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Shin Yesuusi nayta baakko xeegidi, “Yooga nayti taakko yaanayssa diggofite; yo giite. Ays giikko, Xoossaa kawotethay enttada hanidayssatassa. ");
INSERT INTO gofRNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Taani hinttew tuma odays; Xoossaa kawotethaa yooga naytatho ekkonnay oonikka yaa gelenna” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ayhude halaqatappe issoy, “Keeha asttamaariyaw, merinaa de7uwa demmanaw ay ootho?” yaagidi oychchis. ");
INSERT INTO gofRNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesuusi iyaakko, “Ays tana keehaw yaagada xeegay? Issi Xoossaafe attin hari keehi baawa. ");
INSERT INTO gofRNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Laammofa, wodhoppa, kaysotoppa, worddo markkattofa, ne aawanne ne aayiw bonchcha yaagiya kiitaa eray” yaagidi oychchis. ");
INSERT INTO gofRNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Uraykka, “Hessata ubbaa taani na7atethafe doomada naagashe gam77as” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesuusi hessa si7ida wode “Hiza, new issibay paccees; new de7iyaba ubbaa bayzada manqotas imma; salon nena shaloy naagees. Yaata simmada tana kaalla” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Shin uray hessa si7ida wode iyaw daro shaloy de7iya gisho daro qiirottis. ");
INSERT INTO gofRNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesuusi uraa be7idi, “Dure asas Xoossaa kawotethaa geloy waanidi un77anddeshsha? ");
INSERT INTO gofRNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Durey Xoossaa kawotethaa gelanayssafe gimaley narppe luhora kantheyssi kawuyees” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Hessa si7ida asay, “Hessa gidikko ooni attanee?” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesuusi, “Asas dandda7ettonabay Xoossaas dandda7ettees” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Phexiroosi, “Hekko nuuni nubaa ubbaa aggidi nena kaallida” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","“Yesuusi tuma ta hinttew odays; Xoossaa kawotethaas gidi ba keethaa woykko ba machchiw woykko ba ishata woykko ba aawanne ba aayiw woykko ba nayta aggiday; ");
INSERT INTO gofRNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ha wodiyan dakko daro, yaana alamiyan merinaa de7uwa ekkonnay oonikka baawa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesuusi tammanne nam77ata baakko xeegidi, “Ane Yerusalaame boos, nabeti Asa Na7aabaa xaafidaba ubbay yan polettana. ");
INSERT INTO gofRNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","I Ayhude gidonna asaas aadhdhidi imettana. Entti iya toochchana, cayananne iya bolla cuttana. ");
INSERT INTO gofRNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Iya garaafidaappe guye wodhana, shin heedzantho gallasan I hayqoppe denddana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Shin iya tamaareti hessa ubbaafe issibaakka akeekibookkona. Iya xuuray enttaw qosettida gisho I woygidaakko eribookkona. ");
INSERT INTO gofRNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesuusi Iyaarkko matattiya wode issi qooqe uray oge gaxan uttidi woossees. ");
INSERT INTO gofRNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Qooqe uray asay he bessaara aadhdhishin si7idi, “I aybe?” gidi oychchis. ");
INSERT INTO gofRNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Entti, “Naazirete Yesuusi hayssara aadhdhees” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","I, “Dawite na7aw, Yesuusa, tana maararkii” yaagidi waassis. ");
INSERT INTO gofRNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Sinthe sinthe biya asati, “Si7i ga” gidi hanqettidosona. Shin I, “Dawite na7aw, tana maara” yaagidi darssi waassis. ");
INSERT INTO gofRNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yesuusi eqqidi uraa baakko ehana mela kiittis. Uraykka, iyaakko shiiqin, ");
INSERT INTO gofRNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ta new ay oothana mela koyay?” yaagidi oychchis. Qooqey, “Godaw ta xeellanaw koyays” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesuusi, “Xeella, ne ammanoy nena pathis” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Uray sohuwara xeelli aggis. Xoossaa bonchchishe Yesuusa kaallis. Asa ubbay hessa be7idi Xoossaa galatidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesuusi Iyaarkko gelidi aadhdhees. ");
INSERT INTO gofRNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Yan Zakkiyoosa geetettiya qaraxa qanxiseyssata halaqay de7ees. I daro dure. ");
INSERT INTO gofRNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","I Yesuusi ooneekko be7anaw koyis. I qanthi gidiya gisho asaa darotethaafe denddoyssan Yesuusa be7anaw dandda7ibeenna. ");
INSERT INTO gofRNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Yesuusa be7anaw koyidi I biya ogiyas sinthe woxxi bidi issi boobba mitha bolla keyis. ");
INSERT INTO gofRNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yesuusi he bessaa gakkishe dhoqqu gidi be7idi, “Zakkiyoosa, hachchi ta ne son pee7anaw bessiya gisho elle wodhdha” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","I ellesi wodhdhidi ufayssan Yesuusa mokkis. ");
INSERT INTO gofRNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","He bessan de7iya asaa ubbay hessa be7idi, “Nagaranchchuwa soo gelidi mokettanw hanees” yaagidi zuuzummidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Gidoshin, Zakkiyoosi eqqidi Godaakko, “Godaw, hekko taw de7iya shalo ubbaafe baggaa manqotas immana. Asappe aybaakka worddon balethada ekkidabaa gidikko oyddu kushe zaarana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesuusi qassi, “Ha uray Abrahame na7a gidida gisho hachchi atotethay ha soo yis. ");
INSERT INTO gofRNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Asa Na7ay yiday dhayidayssa koyanasaanne ashshanaassa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Asay hessa si7iya wode Yesuusi Yerusalaame matattida gishonne Xoossaa kawotethay ha77i matara qonccana daanida gisho enttaw leemiso odis. ");
INSERT INTO gofRNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Hessa gisho, Yesuusi, “Issi gita asi de7eyssi baw kawotethi ekkidi yaanaw hara biitta bis. ");
INSERT INTO gofRNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Iyaw oothiya aylletappe tammata xeegidi issuwas issuwas tammu minaane immidi ‘Ta simmada yaana gakkanaw ha miishiyara zal77ite’ yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“He biittaa asay iya ixxiya gisho ha uray nu bolla kawotana mela nu koyokko yaagidi ase iya guyera kiittidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Gidoshin, he uray kawo gididi ba biittaa simmis. He tammu aylleti I immida miishiyan ay mela zal77idi wodhisidaakko eranaw koyidi enttana xeegisis. ");
INSERT INTO gofRNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Koyroyssi yidi, ‘Godaw, ne taw immida miishey haraa tamma wodhdhis’ yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Iya Goday, ‘Neno ammanettida aylliyaw lo77o oothadasa. Neeni guuthaban ammanettida gisho new tammu katamata bolla maata immas’ yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Nam77anthoyka yidi, ‘Godaw, ne taw immida miishey haraa ichchasha wodhdhis’ yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Goday iyaakko, ‘Newukka qassi ichchashu katamata bolla maata immas’ yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Hekko heedzanthoy yidi, ‘Godaw, ta curqqan xaaxada naagida ne miishiya hannashu. ");
INSERT INTO gofRNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ays giikko, neeni nebaa gidonnabaa ekkeyssanne ne zeronnabaa buucciya iita asi gidiya gisho new yayyas’ yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Iya goday zaaridi, ‘Neno iita aylliyaw ne doonatho ta nena pirddana. Ta wothonnabaa ekkeyssanne zeronnabaa buucciya asi gideyssa ne erikko, ");
INSERT INTO gofRNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","ta yada ta miishiya wodhera ekkana mela zal77iya asaas ays immabiikkii?’ ");
INSERT INTO gofRNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Iya goday he bessan eqqidayssatakko, ‘Iyara de7iya miishiya ekkidi tamma wodhisidayssas immite’ yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Entti, ‘Godaw, iyaw kasekka tammu minaaney de7ees’ yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Goday, ta hinttew odays; ‘De7iya ubbaas hari guzhettana, shin baynnayssafe haray atto iyaw de7iyarakka ekettana. ");
INSERT INTO gofRNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Gidoshin, ta entta bolla kawotonna mela koyidayssata he ta morkketa ha ta sinthe ehidi goyrite’ gis” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesuusi hessa odidayssafe guye enttafe sinthe aadhdhi hamuttidi Yerusalaame bis. ");
INSERT INTO gofRNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Shamaho Deriya bolla de7iya Beetefaagenne Bitaaniya matattida wode ba tamaaretappe nam77ata yaagidi kiittis: ");
INSERT INTO gofRNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Hintte sinthan de7iya gutaa biite, hintte yaa gakkiya wode oonikka toggonna qashettidi de7iya hare mari demmana. Iya billidi haa ekki yiite. ");
INSERT INTO gofRNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Oonikka, ‘Ays billeeti?’ gidi oychchiko, ‘Goday iya koyees’ yaagite” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Kiitettidayssati bidi I gidayssada hanin be7idosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Entti hare maraa billishin godati be7idi, “Hare maraa ays billeeti?” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Entti zaaridi, “Goday iya koyees” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Yaappe hare maraa Yesuusakko ehidosona. Bantta ma7uwa hare maraa zokkon yeggidi Yesuusa hare maraa bolla utisidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Asaykka I biya ogiya bolla bantta ma7uwa hiixidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Shamaho Deriya dugethaa wodhisiya ogiyakko matiya wode taybon keehi daro asay entti be7ida malaalisiyaban ufayttidi bantta qaala dhoqqu oothidi, ");
INSERT INTO gofRNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Godaa sunthan yaa kawoy anjjettidayssa saluwan saroy ubbaafe dhoqqa saluwan bonchchoy Xoossaas gido.” yaagidi Xoossaa galatidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Asaa giddofe issi issi Farisaaweti Yesuusakko, “Asttamaariyaw, ne tamaareta hayzite gada hanqetta” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","I enttako, “Entti si77i giikko shuchchati waassana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yesuusi Yerusalaame matishe katamaa be7idi iyaw yeekkis. ");
INSERT INTO gofRNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“New saro gidanayssa hachchi ne eridabaa gidiyakkoshin, ha77i ne ayfiyaappe geemmis. ");
INSERT INTO gofRNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ne morkketi ne yuushuwa diridi dumma dumma ogiyara nena teqqidi un77ethiya wodey yaana. ");
INSERT INTO gofRNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Nenanne ne dirssaa garssan de7iya ne nayta dhayssana. Issi issi shuchchu denthidi laallana, ays giikko Xoossay nena ashshanaw yaa wodiya erabaakka” yaagidi iw yeekkis. ");
INSERT INTO gofRNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Hessafe guye, Yesuusi Xoossa Keethi gelidi zal77eyssata yaappe goodis. ");
INSERT INTO gofRNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Qassi, “ ‘Ta keethay Xoossaa woossiya keethi gidana’ gidi xaafettis, shin hintte ta keethaa panggata gonggolo oothideta” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Gallas gallas Xoossa Keethan tamaarssees. Kahineta halaqati, higge asttamaaretinne deriya cimati iya wodhanaw oge koyoosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Gidoshin, asa ubbay iya timirttiya bantta wozana yeggidi si7iya gisho enttaw oothanabay dhays. ");
INSERT INTO gofRNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Issi gallas Yesuusi Xoossa Keethan asaa tamaarssishininne Wonggelaa markkattishin, kahine halaqati, higge asttamaaretinne deriya cimati issife iyaakko yidi, ");
INSERT INTO gofRNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","“Neeni hayssata aybi maatan oothiyako nuus oda. Ha maata new immiday oonee?” yaagidi oychchidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","I enttako, “Takka hinttena issibaa oychchana, ane taw zaarite. ");
INSERT INTO gofRNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Xammaqiya Yohaannisa xinqqatey Xoossafeyye asappe?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Entti woli giddon yaagidi zorettidosona: “Xoossafe giikko yaatin, ays ammanibeekketii?” yaagana. ");
INSERT INTO gofRNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","“Asappe giikko, asa ubbay Yohaannisi nabe gideyssa ammaniyaa gisho nuna shuchchan caddana.” ");
INSERT INTO gofRNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Yaaniya gisho, “Awuppeeko nu erokko” yaagidi zaaridosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yesuusi zaaridi, “Hiza, takka ay maatan hayssata oothiyako hinttew odikke” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Hessafe guye, Yesuusi yaagidi ha leemisuwa asaas odis: “Issi asi woyne tokkis. Goshshanchchotas kera immidi daro wode gam77idi yaanaw hara biitta bis. ");
INSERT INTO gofRNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Woyne ayfiyaa maxiya wodey gakkin woyniya ayfiyaappe iyaw yeddana mela goshshanchchotakko ba aylliya kiittis. Shin goshshanchchoti he aylliya oykkidi wadhdhidi mela kushe yeddidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Kaallidikka hara aylliya kiittis. Qassi goshshanchchoti iya wadhdhidi, kawushshidi mela kushe yeddidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ha77ika zaaridi heedzantho aylliya kiittis. Goshshanchchoti iyakka madunxisidi woyniya giddofe gaxa kessidi yeggidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Woyniya goday, ‘Yaatin ta ay ootho? Ane qassi ta dosiya ta na7aa yeddana; ooni eri entti iya bonchchonna aggokona’ yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Shin goshshanchchoti uraa na7aa be7ida wode ‘Hayssi iya laatteyssa, haa yiite iya wodhana, yaatikko laatay nuus gidana’ yaagidi zorettidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Woyniya giddofe gaxa kessidi wodhidosona. “Yaatin, woyniya goday he asata waatanee? ");
INSERT INTO gofRNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Yidi he goshshanchchota dhayssana, woyniya bessaa hara asatas immana. Asay hessa si7ida wode ‘Shinchchalle hessa melabaa ehoppo’ yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yesuusi entta caddi xeellidi, “Yaatin ‘Gimbbe keexiya asati borida shuchchay, keethaas malanne minotethi immiya ubbaafe aadhdhiya shuchchi gidis’ geetettidi xaafettidayssa birshshethay aybe? ");
INSERT INTO gofRNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","He shuchchaa bolla kunddiya ubbay qoxettana, shuchchay iya bolla wodhdhiya ubbay liiqana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Higge asttamaaretinne kahine halaqati ha leemisoy odettiday entta bolla gideyssa eridi he wode iya oykkanaw koyidosona, shin asaas babbidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Hessa gisho, Yesuusa deriya haariya Roome kawuwa maatas aathi immanaw koyidi iya doonappe bala qaala naagoosona. Hessa polisanaw xillo daanidi cimmiya asata iyaakko kiittidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Kiitettidi bida asati, “Asttamaariyaw, neeni odeysinne tamaarsseyssi likke gideyssa, qassi Xoossaa ogiya tumatethan tamaarsseyssanne oonakka shaakkonnayssa nu eroos. ");
INSERT INTO gofRNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Hanoshin, Roome kawuwas giira giiranaw bessi bessennee?” yaagidi iya oychchidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Shin I entta wozanaa iitatethaa erida gisho ");
INSERT INTO gofRNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Ane tana issi santime bessite, Iya bolla de7iya misileynne sunthay ooddebaye?” yaagis. Entti zaaridi, “Roome Kawuwa Qeesareyssa” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","I zaaridi, “Yaatikko, Qeesareyssa Qeesares, Xoossayssa Xoossaas immite” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Hessa gisho, I zaarida zaaruwan asaa sinthan bala demmanaw dandda7ibookkona. Iya zaaruwan malaalettidi si77i gidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Hayqoppe denddoy baawa yaagiya Saduqaawetappe issoti issoti Yesuusakko yidi, ");
INSERT INTO gofRNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Asttamaariyaw, issi asi machcho ekkidi na7a yelonna hayqqiko, iya ishay he maccasiw ekkidi nayta yelidi ba ishaas zerethi ashshana mela Musey xaafis. ");
INSERT INTO gofRNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Hekko laappun ishati de7oosona. Koyroyssi machcho ekkidi na7a yelonna hayqqis. ");
INSERT INTO gofRNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Nam77anthoy iyo ekkidi na7a yelonna hayqqis. ");
INSERT INTO gofRNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Heedzanthoyka hessatho hanis. Laappunati ubbay hessada hanidi iyo ekkidosona, shin na7a yelonna hayqqidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Wurssethan maccasiya hayqqasu. ");
INSERT INTO gofRNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Hiza, laappun addey iyo ekkida gisho hayqoppe denddiya wode iya oodde machcho gidanee?” yaagidi oychchidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesuusi zaaridi, “Asay ha wodiyan ekkoosonanne geloosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Shin hayqoppe denddidi yaana alamiyan daanaw besseyssati ekkokonanne gelokkona. ");
INSERT INTO gofRNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Entti kiitanchcho mela gidiya gisho sinthafe hayqqokona. Hayqoppe denddida gisho entti Xoossaa nayta. ");
INSERT INTO gofRNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Musey Godaa, ‘Abrahame Godaa, Yisaaqa Godaa, Yayqooba Godaa’ gidi tushiya giddon xuugettiya tama taarikiya xaafidayssan hayqqida asay denddeyssa bessees. ");
INSERT INTO gofRNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ubbay iyaw de7on de7eyssata gidiya gisho I de7on de7eyssata Godaappe attin hayqqidayssata Goda gidenna” yaagidi zaaris. ");
INSERT INTO gofRNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Higge asttamaaretappe issoti issoti, “Asttamaariyaw, lo77obaa odadasa” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Hessafe guye, hara oysho oychchanaw yayyidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Iyappe kaallidi Yesuusi enttako, “Asay Kiristtoosa waattidi Dawite na7a yaagonaa? ");
INSERT INTO gofRNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Ays giikko, Dawitey ba huu7en ba maxaafan, ‘Xoossay ta Godaakko “Ta ne morkketa ne tohoy yedhdhiyaso oothana gakkanaw taappe ushachcha baggan utta” gis’ yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","“Hiza, Dawitey Kiristtoosa, ‘Godaa gidi xeegishe iyaw na7a waanidi gidi?’ ” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Derey ubbay si7ishin ba tamaaretakko, ");
INSERT INTO gofRNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Adussa ma7o ma77idi yuushshe doseyssatappe, giyan bonchcho sarotho, Ayhude Woosa Keethan bonchcho oyde, mokettiya sonkka bonchcho bessi koyaa higge asttamaaretappe naagettite. ");
INSERT INTO gofRNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Entti am77eta keethaa kalloyoosona, xillo asi daanidi woosa adussoosona. Entti iita pirdda ekkana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Dure asay Xoossa Keethan muxaata saaxiniyan yeggishin Yesuusi dhoqqu gidi asaa be7is. ");
INSERT INTO gofRNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Qassi issi manqo am77iya nam77u sikkina yeggishin be7idi, ");
INSERT INTO gofRNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","“Ta hinttew tuma odays; ha manqo am77iya ubbaafe aathada immasu. ");
INSERT INTO gofRNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ays giikko, ha asa ubbay banttaw de7iyabaappe immidosona, shin iya ba pacciyaappe, baw de7iya aquwaa ubbaa immasu” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Yesuusa tamaaretappe issoti issoti Xoossa Keethay daro lo77iya shuchchaninne asay Xoossaas immida imotan lo77idayssa odettoosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Shin Yesuusi, “Ha hintte be7iyabay ubbay laalettonna, shuchchi shuchcha bolla gimbbettida mela attonna wodey yaana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Enttika, “Asttamaariyaw, ha ubbay hananay awude? Qassi hayssi hananayssas malaatay aybee?” yaagidi oychchidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yesuusi yaagidi enttaw zaaro immis: “Balettonna mela naagettite. Daroti, ‘Taani Kiristtoosa, wodey matattis’ yaagishe ta sunthan yaana, shin hintte entta kaallofite. ");
INSERT INTO gofRNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Hintte olabaanne asaa geellatethaa si7iya wode dagammofite. Hessi sinthattidi hananayssi attonnabaa gidiya gisho wodiya wurssethay ellesidi yeenna” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Kaallidikka, “Derey deriya bolla, kawotethay kawotethaa bolla denddana. ");
INSERT INTO gofRNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Gita biitta qaaxoy hanana, koshaynne gadoy dumma dumma bessan darana, yashshiyabaynne gita malaatati saloppe qonccana. ");
INSERT INTO gofRNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Shin ha ubbay hananaappe sinthe ta sunthaa gisho gidi asay hinttena gooddananne oykkana. Ayhude Woosa Keethaninne qasho keethan hinttena yeggana. Kawota sinthenne deriya haareyssata sinthe hinttena efana. ");
INSERT INTO gofRNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Hessika tabaa hintte enttaw markkattanaw lo77o oge gidana. ");
INSERT INTO gofRNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Hessa gisho, hintte oyshettiya wode woygidi zaaro immanee gidi hintte wozanan un77ettonna mela akeekite. ");
INSERT INTO gofRNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ays giikko, hintte morkketi hinttera eqettanawunne palamanaw dandda7onna doonanne cinccatethi ta hinttew immana. ");
INSERT INTO gofRNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Hari attoshin, hinttena yelidayssati, hintte ishati, hintte dabbotinne laggeti hinttena aathi immana. Hintte giddofe issota issota wodhana. ");
INSERT INTO gofRNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ta sunthaa gisho asa ubbaa sinthan hintte ixettidayssata gidana. ");
INSERT INTO gofRNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Shin hari attoshin, hintte binaanappe issoykka dhayenna. ");
INSERT INTO gofRNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Polo dandda7an hintte, hintte shemppuwa ashshana.” ");
INSERT INTO gofRNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Yerusalaame katamay wotaaddaren direttidi uttidashin hintte be7ikko iyaw dhayoy matattidayssa erite. ");
INSERT INTO gofRNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","He wode Yihudan de7iya ubbay deriyakko baqato, kataman de7eyssati yaappe keyo, gaxariyan de7eyssati katama geloppo. ");
INSERT INTO gofRNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ays giikko, ha xaafettidabay polettana mela hessi Xoossay kushe zaariya wode. ");
INSERT INTO gofRNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Sa7a bolla gita metoy yaana, hessankka asaa bolla Xoossaa hanqoy yaana. Hessa gisho, qanthatidayssatanne dhantheyssata ayye. ");
INSERT INTO gofRNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Entti mashshan hayqqana, asa ubbay allaga biitta di7ettana. Ayhude gidonna asaa wodey polettana gakkanaw Yerusalaamey enttanan yedhettidayssa gidana. ");
INSERT INTO gofRNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Awan, ageenaninne, xoolinttota bolla malaatati hanidi benttana. Abbaafenne zuliya deshuwappe denddoyssan biittan de7iya asay un77ettananne yarkkana. ");
INSERT INTO gofRNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Saluwa wolqqati buqettana gisho asay yashshaninne biitta bolla aybi hananddeshsha gidi naagon banttana balettana. ");
INSERT INTO gofRNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","He wode Asa Na7ay wolqqaninne gita bonchchuwan shaarara yishin entti be7ana. ");
INSERT INTO gofRNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Hintte atotethay matattida gisho ha hanoti poletethi oykkiya wode giigeti eqqite, hintte huu7iya dhoqqu oothidi xeellite” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Kaallidikka, hayssada gidi leemiso odis: “Balase mithaanne hara mithata ubbaa be7ite. ");
INSERT INTO gofRNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Entti aaciya wode torchchey matattidayssa hintte ereeta. ");
INSERT INTO gofRNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Hessada ha hanoti polettishin hintte be7ikko Xoossaa kawotethay matattidayssa erite. ");
INSERT INTO gofRNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Ta hinttew tuma odays; ha ubbay polettana gakkanaw ha yeletethay aadhdhenna. ");
INSERT INTO gofRNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Saloynne sa7ay aadhdhana, shin ta qaalay aadhdhenna. ");
INSERT INTO gofRNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Hiza, dhassi baynna de7on, ushsha daroninne duussabaas un77etethan hintte wozanay oykettonna melanne he qammay akeekonna xiheda hintte bolla gakkonna mela naagettite. ");
INSERT INTO gofRNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","He qammay biitta kumethan de7iya ubbaa bolla gakkana. ");
INSERT INTO gofRNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Hessa gisho, yaa iitaappe attanawunne Asa Na7a sinthan eqqanaw dandda7ana mela ubba wode minnidi woossite” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Gallas gallas Yesuusi Xoossa Keethan tamaarssishe, qamma qamma Shamaho Deriya bolla keyidi aqees. ");
INSERT INTO gofRNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Asay ubbay iya si7anaw wontta guura iyaakko Xoossaa Keethi yoosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","He wode ‘Faasikka’ yaagiya Uytha Baaley matis. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Kahine halaqatinne higge asttamaareti asaas yayyida gisho waattidi Yesuusa bantta giddofe dhayssaneekko oge koyoosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Xalahey tammanne nam77atappe issuwa gidida Asqoroota Yihuda geetetteyssa gido gelis. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yihudi kahine halaqatakkonne Xoossa Keetha naageyssata halaqatakko bidi Yesuusa waati aathi immaneekko enttara maqettis. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Enttika hessan ufayttidi miishe immanaw iyara zorettidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ikka zoretethan giigis. Aathi enttaw immanaw asi baynna injje wode naagishe de7ees. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Hessafe guye, Faasikka dorssay shukettiya Uytha Baaley gakkis. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yesuusi, “Faasikka kahuwa maana mela bidi nuus giigisite” yaagidi Phexiroosanne Yohaannisa kiittis. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Entti, “Nu awun giigisana mela ne koyay” yaagidi oychchidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","I enttako, “Hekko hintte katama gelishin haatha oto tookkida addey hinttera gahettana. I bidi geliya keethaa iya kaallidi gelite. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Keethaawakko asttamaarey, ‘Ta ta tamaaretara wolla Faasikka kahuwa maanaw imatha keethi awunee? yaagis’ giite. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","I pooqiya bolla hiixettidi giigidi de7iya dalgga kifile hinttena bessana, yan giigisite” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Entti bidi Yesuusi gidayssada hanin demmidosona. Faasikka baale kahuwa yan giigisidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Saateykka gakkida wode Yesuusi hawaaretara wolla kahuwa bolla uttis. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","I enttako, “Ta waaye ekkanaappe sinthe ha kahuwa hinttera maanaw daro amottas. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Hiza, si7ite! Xoossaa kawotethan hayssas birshshethay polettana gakkanaw ha kahuwa zaarada miikke” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ushshaa ekkidi galati simmidi, “He7ite hayssa hintte giddon shaakettite. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Si7ite! Xoossaa kawotethay yaana gakkanaw hachchife doomada ha woyne ushshaafe zaarada uyikke” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Uythaa ekkidi, galati simmidi, “Hayssi hinttew imettiya ta ashuwa. Hayssa oothishe tana qoppite” yaagidi meenthidi enttaw immis. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Hessadakka, kahuwappe guye ushshaa ekkidi, “Ha ushshay hinttew gukkida ta suuthan gidiya ooratha caaquwa. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Gidoshin, tana aathi immana uraa kushey taara issife gaytaana. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Asa Na7ay iyaw geetettoyssa mela hayqqanaw de7ees, shin iya aathi immiya uraa ayye” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Entti bantta giddon, “Hayssa ooni oothanee” gidi woli oychchidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Qassi entta giddon gita gidanay oone giya palami medhettis. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yesuusi enttako, “Deriya kawoti bantta asaa wolqqan haarosona; bantta deriya bolla godateyssataskka banttana, ‘Lo77o ootheyssata’ yaagidi xeegosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Shin hintte giddon hessa mela gidoppo. Hintte giddon bayratey kaaloda hano; kaaletheyssi kaalleyssada hano. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Hanoshin, mokkeyssafenne Moketteyssafe awussi aadhdhi? Moketteyssa gidenneyye? Shin taani hintte giddon mokkeyssa mela. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Hintteka ta metuwan taappe shaakettonna taara minnidi eqqidayssata. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","30","Hintte ta gaytappe maana mela, uyana melanne araatata bolla uttidi tammanne nam77u Isra7eele sheeshata bolla pirddana mela ta aaway tana shuumidayssada takka hinttena ta kawotethan shuumana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Kaallidikka Yesuusi, “Simoona, Simoona, Xalahey hinttena gistteda harqqanaw woossis. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Shin taani ne ammanoy dhayonna mela new gaannatas. Nekka simmida wode ne ishata mintha” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Simooni, “Godaw, taani neera qashettanawunne hayqqanaw giigettas” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesuusi Phexiroosakko, “Ta new odays; hachchi kuttoy waassanaappe sinthe ne tana heedzu toho kaddana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Kaallidikka, Yesuusi enttako, “Taani hinttena korojjoy, karxiiteynne caammi baynna kiittida wode hinttew paccidabay de7ii?” yaagidi oychchis. Entti zaaridi, “Aykkoyka paccibeenna” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","I enttako, “Ha77i korojjoynne karxiitey de7ey oykko; mashshi baynnay ba afilaa bayzidi mashsha shammo. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Haa si7ite! ‘Geellatara taybettis’ geetettidi xaafettidayssi tanan polettanaw bessees. Ee, ta gisho xaafettidabay poletteyssi tumattis” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Iya tamaareti, “Godaw hayssan nam77u mashshi de7ees” yaagidosona. I, “Gidana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesuusi kase meezetidayssada denddidi Shamaho Deriya bolla keyis. Iya tamaareti iya kaallidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","He bessaa gakkida wode “Paacen gelonna mela woossite” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Enttafe shuchchi holin gakkiya soo mela haakkidi gulbbatidi woossis. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Ta aawaw, ne shene gidikko ha metuwa taappe aatha. Shin ta shene gidoppo ne sheney hano” yaagidi woossis. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Kiitanchchoy saloppe qonccidi minthis. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Daro un77ettidi minthidi woossees. Iya cawaykka suuthi xokkiyada sa7an xokkees. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Yesuusi woosaa wurssidi ba tamaaretakko yis. Entti, azzaniyappe denddoyssan daaburidi dhiskkidashin demmidi, ");
INSERT INTO gofRNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","“Ays dhiskkeetii? Paacen gelonna mela denddidi woossite” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","I buroo oda bolla de7ishin daro asati yidosona. Tammanne nam77atappe issoy Yihuda geetetteyssi enttana kaalethees. I Yesuusa yeeranaw mati shiiqis. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Shin Yesuusi, “Yihuda, Asa Na7aa yeerada aatha immanee?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Yesuusa tamaareti he hanuwa be7idi, “Godaw mashshan shocino?” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Entta giddofe issoy kahine halaqaa oosanchchuwa shocidi ushachcha haytha qanxidi yeggis. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Shin Yesuusi, “Agga! Diggofite” yaagis. Uraa haythaa bochchidi pathis. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Hessafe guye, Yesuusi bana oykkanaw yida kahine halaqatakko, Xoossa Keetha naageyssata shuumatakkonne cimatakko, “Paanno oykkiya asada mashshenne xam77a oykkidi yidetii? ");
INSERT INTO gofRNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ubba gallas Xoossa Keethan ta hinttera de7iya wode ta bolla kushe wothibeeketa. Shin hayssi dhuma kawotethay haarida wodenne hintte wode” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Hessafe guye, Yesuusa oykkidi kahine halaqaa zabbaa efidosona. Phexiroosi haahon Yesuusa kaallees. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Asati kahine halaqaa zabban tama eethidi wolla uttidashin Phexiroosi enttara issife uttis. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Issi aylliya Phexiroosi tama matan uttidayssa cadda xeellada, “Ha uray iyara de7ees” yaagasu. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Shin Phexiroosi, “Ha maccasete ta he uraa erikke” yaagidi kaddis. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Guutha wodeppe guye issi hara addey iya be7idi, “Nekka enttafe issuwa” yaagis. Shin Phexiroosi, “Ha addiyaw tana gidikke” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Issi saate mela gam77idaappe guye issi hara addey tillisidi, “Ha uray Galiilappe gidiya gisho sidhey baynna iyara de7ees” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Shin Phexiroosi, “Ha addiyaw, ne geyssa ta erikke” yaagis. I he oda onggonna de7ishin kuttoy waassis. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Goday guye simmidi Phexiroosa xeellis. Phexiroosi, “Hachchi kuttoy waassanaappe sinthe ne tana heedzu toho kaddana” yaagidi, Goday odida qaala akeekis. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Phexiroosi kare keyidi daro kokkoridi yeekkis. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Yesuusa naagiya asati iya leqisonne deshethi oykkidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Iya ayfiyaa goozidi “Ane tinbbite oda; nena dechchiday oonee?” yaagidi oychchosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Hara daro cashshe cayidi kawushshosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Sa7i wonttiya wode Ayhude biitta cimati, kahine halaqatinne higge asttamaareti shiiqidi, Yesuusa bantta sinthe shiishidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Entti, “Neeni Kiristtoosee? Ane nuus oda?” yaagidi oychchidosona. Yesuusi, “Ta odiyakko ammanekketa. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ta oychchiyako zaarekketa. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Shin Asa Na7ay hayssafe gede baggan wolqqaama Xoossaa ushachcha baggan uttana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","He wode ubbay, “Yaatin, neeni Xoossaa na7ee?” yaagidosona. I, “Ta Xoossaa na7a gideyssa hintte gideta” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Entti, “Hiza, hara markka ay koshshii? I ba inxarssan odishin nu si7ida” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","He bessan shiiqida shanggoti ubbay denddidi Yesuusa Philaaxoosakko efidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","“Ha uray nu asaa balethishin, kawuwas giira giironna mela diggishininne qassi, ‘Taani Kiristtoosa hintte kawuwa’ yaagishin demmida” yaagidi mootidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Philaaxoosi Yesuusa, “Neeni Ayhudeta kawoyye?” yaagidi oychchis. Yesuusi, “Ee, ne gidayssa mela” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Philaaxoosi kahine halaqatakkonne asaakko, “Ha uraa bolla taani issi balakka demmabiikke” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Shin entti, “Ha uray Galiilappe doomidi hayssa gakkanaw Yihuda kumethaa iitabaas denthethees” yaagidi minthi odidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Philaaxoosi hessa si7ida wode Yesuusi Galiila aseekko eranaw koyidi iya oychchis. ");
INSERT INTO gofRNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Yesuusi Heroodisa biittaafe yida asi gideyssa Philaaxoosi erida wode Heroodisi he wode Yerusalaamen de7iya gisho iyaakko yeddis. ");
INSERT INTO gofRNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Heroodisi Yesuusa be7anaw daro wodeppe koyishe de7iya gisho iya be7ida wode daro ufayttis. Ays giikko, iyabaa si7ida gisho malaalisiyabaa oothin be7anaw amottishe de7ees. ");
INSERT INTO gofRNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Heroodisi Yesuusa daro oyshota oychchis, shin I aykkoka zaaribeenna. ");
INSERT INTO gofRNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Kahineta halaqatinne higge asttamaareti yan eqqidi minthidi iya mootosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Heroodisaranne iya wotaaddaretara Yesuusa kadhidosonanne leqisidosona. Bonchcho afilaa mayzidi Philaaxoosakko zaaridi yeddidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Heroodisaranne Philaaxoosara kase morkkeshin he gallas wolla giigidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Philaaxoosi kahine halaqata, asaa haareyssatanne asaa xeegidi, ");
INSERT INTO gofRNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","“ ‘Ha uray asaa geellatethas denthethees’ gidi taakko ehideta. Takka hintte sinthan pilggada hintte shiishida mootuwas aybi balakka demmabiikke. ");
INSERT INTO gofRNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Heroodisi, hessatho aybi balakka iya bolla demmiboonna gisho nuukko yeddis. Tumakka ha uray hayqos gathiya aybi balakka oothibeenna. ");
INSERT INTO gofRNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Hessa gisho, iya garaafada billa yeddana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Hessa I giday Faasikka Baale wode issi asi enttaw billanayssi iyaw attonnabaa gidiya gishossa. ");
INSERT INTO gofRNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Derey ubbay issi bolla, “Ha uraa gede digga, nuus Barbbaana billa” yaagidi waassidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barbbaani katamaa giddon asaa iitabaas denthethidi ase wodhdhidi qashettida asi. ");
INSERT INTO gofRNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Philaaxoosi Yesuusa billanaw koyidi asaas zaari odis. ");
INSERT INTO gofRNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Gidoshin, asay, “Kaqqa! Kaqqa!” yaagidi waassidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Philaaxoosi heedzantho, “Ha uray qohidabay aybe? Wodhos gathiya bala ta demmabiikke. Hessa gisho, garaafada yedda aggana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Entti bantta qaala dhoqqu oothidi, “Kaqettanaw bessees” gidi minthi waassidosona. Entta waasoykka xoonis. ");
INSERT INTO gofRNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Entta oyshaa gisho gidi Philaaxoosi iya bolla pirddis. ");
INSERT INTO gofRNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Asaa iitabaas denthetheyssanne ase wodhdhidi qashettidayssa billana mela woossida, he uraa enttaw billis. Shin Yesuusa entti koyidabaa oothana mela enttaw aathi immis. ");
INSERT INTO gofRNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Yesuusa oykkidi efishin Simoona giya Qereena biitta addey gaxareppe yishin, demmidi masqaliya toossidi Yesuusa kaallidi baana mela un77ethidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Daro asaynne bantta tiraa iccishe yeekkiya maccasati iya guyiyara kaalloosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Shin Yesuusi enttako guye simmidi, “Hinttenoo, Yerusalaame maccasato, hintte huu7esinne hintte naytas yeekkiteppe attin taw yeekkofite. ");
INSERT INTO gofRNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","‘Hekko maynthati, yelonna ulotinne dhanthonna dhanthati anjjettidosona’ hintte yaagana gallasay yaana. ");
INSERT INTO gofRNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","He wode dereta, ‘Nu bolla kunddite’, zumatakka, ‘Nuna kammite’ yaagana. ");
INSERT INTO gofRNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Hiza, qaye mithaa hessatho oothiko mela mithaa waatanddeshsha?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Iyara wodhanaw hara nam77u worandzota efidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Qeeraniyo geetettiya bessaa gathidi kaqqidosona. Worandzotappe issuwa ushachcha baggara hankkuwa haddirssa baggara kaqqidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yesuusi, “Ta aawaw, entti ay oothiyako eronna gisho neeni enttaw atto yaaga” yaagis. Entti iya afilaa bolla saama yeggidi shaakettidi ekkidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Asay eqqidi xeellosona, shin deriya haareyssati, “Harata ashshis; Xoossay doorida Kiristtoosi iya gidikko ane bana ashsho” yaagidi leqisidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Wotaaddareti iyaakko shiiqidi, caala woyne ushshaa immidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Yaatidi, “Neeni Ayhudeta kawo gidikko ne huu7iya ashsha” yaagidi leqisidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Iyaw huu7e baggara, “Hayssi Ayhudeta kawo” yaagiya xuufey de7ees. ");
INSERT INTO gofRNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Kaqettida worandzotappe issoy cashshe sa7ara goochchishe, “Ane neeni Kiristtoosa gidikko, nenakka nunakka ashsha” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Shin hankko worandzoy, “Neeni hayssa mela pirddan de7ashe hari attoshin, Xoossaas yayyikii? ");
INSERT INTO gofRNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Nuuni nu balaas bessiya pirdda ekkoos, shin ha uray issi iitabaakka oothibeenna” yaagidi hanqettis. ");
INSERT INTO gofRNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Qassika, “Yesuusa, ne ne kawotethaara yaa wode tana qoppa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesuusi, “Ta new tuma odays; hachchi neeni taara gannaten gidana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","He gallas usuppun saateppe bidi uddufun saate gakkanaw away poo7uwa diggida gisho biitta ubbaa bolla dhuma gidis. Xoossa Keetha magaraajjoy daakettidi nam77an shaakettis. ");
INSERT INTO gofRNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yesuusi, qaala dhoqqu oothidi, “Ta aawaw, ta ta shemppiw ne kushen sheedhdhays” yaagidi hayqqis. ");
INSERT INTO gofRNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Mato halaqay, hanidayssa be7idi, “Hayssi uray tumakka xillo” yaagidi Xoossaa galatis. ");
INSERT INTO gofRNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ha haniyabaa be7anaw he bessaa shiiqida asa ubbay hanidabaa be7ida wode bantta tiraa iccishe bantta soo simmidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Gidoshin, Yesuusa matan eriya asa ubbay, hessadakka Galiilappe kaallidi yida maccasati hessa be7ishe haahon eqqidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Ayhude shanggotappe issoy, Yoosefa geetettiya uray de7ees. I Armmatiyasa geetettiya Yihuda katamaappe yis. I lo77onne Xillo asi gidiya gisho Xoossaa kawotethaa yuussaa naagees. Shanggotappe issuwa gidishe entta zoretethaaninne oosuwan deenna. ");
INSERT INTO gofRNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","He uray Philaaxoosakko bidi, Yesuusa ahaa mooganaw taw imma gidi woossis. ");
INSERT INTO gofRNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Philaaxoosi ekka yaagin, Yesuusa ahaa wodhisidi afilara xaaxis. Zaallafe woocidi kessida hara asi moogettonna ooratha duufon wothis. ");
INSERT INTO gofRNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Sambbaati gelana haniya gisho he gallasay giigetetha qamma. ");
INSERT INTO gofRNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Galiilappe denddidi Yesuusa kaallidi yida maccasati Yoosefara bidi iya ahaa waati moogiyakko duufuwa akeekidi be7idosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Yaappe simmidi shittonne qibaatiya giigisidosona. Higgey kiitteyssa mela Sambbaata gallas shemppi pee7idosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Saaminttafe koyro gallas, wogga wode wontta daro guura, maccasati bantta giigisida shittuwa ekkidi duufuwa bidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Entti yaa gakkiya wode duufuwa doonan de7iya shuchchay gondderettidi kichchoyssa demmidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Entti duufuwa gaathi gelidosona, shin Godaa Yesuusa ahaa demmibookkona. ");
INSERT INTO gofRNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Entti yan eqqidi aybi hanidee gidi qoppishin akeekonna daro phooliya afila ma77ida nam77u asati entta matan eqqidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Maccasati yashettidi bantta huu7iya sa7an ziqqi oothidi de7ishin, asati enttako, “De7on de7eyssa hayqota giddon ays koyeetii? ");
INSERT INTO gofRNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","7","I hayssan deenna; hayqoppe denddis, ‘Asa Na7ay nagaranchchota kushen aadhdhi imettana; enttika iya kaqqana. I heedzantho qamman hayqoppe denddana’ yaagidi, I hinttera Galiilan de7ishe hinttew odida qaala qoppite” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Maccasati he wode iya qaala qoppidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Maccasati duufuwappe simmidi hanidabaa ubbaa tammanne issotasinne haratasikka odidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Hessa hawaaretas odiday Magdela Mayraamo, Yohaanna, Yayqooba aayiw Mayraamonne enttara de7iya hara maccasata. ");
INSERT INTO gofRNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Shin enttaw maccasati odidayssi elmmo daanin ammanibookkona. ");
INSERT INTO gofRNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Shin Phexiroosi denddi woxxidi duufo bis. He bessaa gakkidi hokki gaathi xeelliya wode moogo afilaa xalaala be7is. Hanidaban malaalettishe ba soo simmis. ");
INSERT INTO gofRNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","He gallas kaalliya tamaaretappe nam77ati Yerusalaameppe tammanne issi kilo mitire haakkiya Emmahuuse gutaa boosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Entti wolla hanidabaa ubbaa odettoosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Entti he hanotabaa qoppishenne odettishe biya wode Yesuusi ba huu7en shiiqidi enttara bees. ");
INSERT INTO gofRNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Hanoshin, entti iya eronna mela entta ayfey oykettis. ");
INSERT INTO gofRNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","I, “Hintte wolla oge bolla de7ishe odetteyssi aybe?” yaagis. Entti azzanidi si77i gidi eqqidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Enttafe issoy Qeliyoopha geetetteyssi, “Ha qammata giddon Yerusalaamen hanidabaa eronnayssi, ne biittaas imatheyye?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","I zaaridi, “I hanidayssi aybee?” yaagidi oychchis. Entti, “Xoossaa sinthaninne asa sinthan oosoninne odan mino nabe gidida Naazirete Yesuusabaa. ");
INSERT INTO gofRNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Iya kahine halaqatinne nuna haareyssati hayqo pirddas aathi immidi, kaqqidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Nuuni Isra7eele asaa wozande gidi ufayttidi naagidashin hayssi hanin hachchi heedzantho qamma. ");
INSERT INTO gofRNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Qassi nu giddofe issi issi maccasati nuna malaalisidosona. Entti hachchi wontta guura duufuwa bidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Iya ahaa dhayida wode simmi yidi, ‘I paxa de7ees’ yaagiya kiitanchchoti qonccin be7ida yaagidi odidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Nu giddofekka issoti issoti duufuwa bidi maccasati odidayssatho hanin be7idosona, shin iya be7ibookkona” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","I enttako, “Hinttenoo, akeekonna asaw, hintte wozanay nabeti odidabaa ubbaa ammananaw gam77eyssato, ");
INSERT INTO gofRNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Kiristtoosi ha metuwa ekkanawunne ba bonchchuwan gelanaw bessennee?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Museppenne nabeta ubbaafe denddidi Geeshsha Maxaafan iyabay xaafettidayssa ubbaa enttaw qonccisis. ");
INSERT INTO gofRNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Entti biya gutaakko matattida wode Yesuusi aadhdhidi haaho soo biya daanin, ");
INSERT INTO gofRNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Entti, “Sa7ay qammida gisho nuura aqa” yaagidi minthidi woossidosona. Hessa gisho, enttara aqanaw gelis. ");
INSERT INTO gofRNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Enttara issife gayta bolla uttidi, uythaa denthidi, meenthi anjjidi enttaw immis. ");
INSERT INTO gofRNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","He wode entti erana mela entta ayfey dooyettis. Enttika eridosona. Shin I enttafe geemmis. ");
INSERT INTO gofRNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Entti, “Nu ogiya bolla de7ishin I nuus Geeshsha Maxaafaa birshshishininne nuna haasayisishin nu wozanay xuugettibeenne?” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","He wode denddidi guye Yerusalaame yidosona. Tammanne issotinne harati issi bolla shiiqidi de7ishin demmidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Entti, “Goday tuma denddis; Simoonas qonccis” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","He nam77u tamaareti Emmahuuse ogiya bolla de7ishin hanidayssanne uythaa meenthida wode waati iya eridaakko enttaw odidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Nam77u tamaareti hessa oda bolla de7ishin, Yesuusi entta giddon eqqidi, “Saroy hinttew gido” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Gidoshin, entti dagammidi, moytille be7ida daanin yayyidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","I enttako, “Ays babbidetii? Ays sidhey hintte wozanan gelidee? ");
INSERT INTO gofRNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ta kushiyanne ta tohuwa be7ite; taani tana. Qassi oykkidi be7ite; tanan hintte be7eyssada, moytilles ashoynne meqethi baawa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Yaagidi, ba tohuwanne ba kushiya entta bessis. ");
INSERT INTO gofRNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Entti ufayssafe denddoyssan ammanonna malaaletethan de7ishin, Yesuusi enttako, “Hayssan hinttew miyabay de7ii?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Entti issi caacettida molo iyaw immidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","I ekkidi entta sinthan mis. ");
INSERT INTO gofRNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","I, “Ta hinttera gam77ida wode ubban Muse maxaafatan, nabeta maxaafataninne Mazmure maxaafatan, ta gisho xaafettidabay ubbay polettanaw bessees yaagada ta hinttew odida qaalay hayssa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","He wode Geeshsha Maxaafata akeekana mela wozanaa entta dooyis. ");
INSERT INTO gofRNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Hessadakka, “Kiristtoosi waaye ekkana, heedzantho qamman hayqoppe denddana yaagidi xaafettis. ");
INSERT INTO gofRNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Yerusalaameppe denddidi asaa ubbaas nagaraappe maarotethaynne atotethay iya sunthan markkattana. ");
INSERT INTO gofRNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Hintte hessas markkatta. ");
INSERT INTO gofRNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Hekko, takka ta aaway immida ufayssaa hinttew yeddana. Hintte saloppe wolqqa ma77ana gakkanaw Yerusalaame kataman gam77ite” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Hessafe guye, Bitaaniya katamaa enttana ekkidi bis. Ba kushiya denthidi anjjis. ");
INSERT INTO gofRNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Enttana anjjishe enttafe shaakettidi pude salo ekettis. ");
INSERT INTO gofRNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Entti ziggi goynnidi daro ufayssan Yerusalaame simmidosona. ");
INSERT INTO gofRNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Xoossaa ubbaa wode galatishe Xoossa Keethan gam77idosona.");
INSERT INTO gofRNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Qaalay koyro de7ees. Qaalaykka Xoossaara de7ees; he Qaalay Xoossaa. ");
INSERT INTO gofRNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Koyroppe Qaalay Xoossaara de7ees. ");
INSERT INTO gofRNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Xoossay ubbabaa Qaalaa baggara medhdhis. Medhettidabaappe issoykka iya baggara medhettonabay baawa. ");
INSERT INTO gofRNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Iyan de7oy de7ees; he de7oy asaas poo7o. ");
INSERT INTO gofRNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Poo7oy dhuman poo7ees; dhumay poo7uwa xoonibeenna. ");
INSERT INTO gofRNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Xoossay kiittida, issi Yohaannisa giya asi de7ees. ");
INSERT INTO gofRNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Asa ubbay poo7uwan ammanana mela I poo7os markka gididi yis. ");
INSERT INTO gofRNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","I poo7uwabaa markkattanaw yisippe attin ba huu7en poo7o gidenna. ");
INSERT INTO gofRNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Asa ubbaas poo7isiya tuma poo7oy alamiya yees. ");
INSERT INTO gofRNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Qaalay alamen de7is. Xoossay Qaalan alamiya medhdhis, shin alamey iya eribeenna. ");
INSERT INTO gofRNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","I bayssatakko yis, shin iyayssati iya ekkibookkona. ");
INSERT INTO gofRNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Shin I bana ekkidayssatasinne iya sunthan ammanidayssatas Xoossaa nayta gidana mela maata immis. ");
INSERT INTO gofRNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Entti Xoossafe yelettidosonappe attin asi yelettiya wogan woykko adde shenen woykko asa amon yelettibookkona. Xoossay I entta aawa. ");
INSERT INTO gofRNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Qaalay ase gidis; aadho keehatethaanne tumaa kumidi nu giddon de7is. I aawas issi na7aa gididi ekkida iya bonchchuwa nuuni be7ida. ");
INSERT INTO gofRNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yohaannisi iyabaa markkattis. Ba qaalaa dhoqqu oothidi, “Taani, ‘Taappe guyera yeyssi taappe kase de7iya gisho taappe aadhdhees’ gada markkattidayssi hayssa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Nuuni ubbay iya aadho keehatethaa kumethaafe anjjo bolla anjjo ekkida. ");
INSERT INTO gofRNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Xoossay higgiya Muse baggara immis, shin aadho keehatethaynne tumatethay Yesuus Kiristtoosa baggara yis. ");
INSERT INTO gofRNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Xoossaa be7ida asi oonikka baawa; ba Aawa matan de7iya issi Na7aa xalaali baw Xoosse gididayssi iya qonccisis. ");
INSERT INTO gofRNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Yerusalaamen de7iya Ayhude halaqati, kahinetanne Leeweta, “Neeni oonee?” gidi, Yohaannisa oychchana mela iyaakko kiittin, Yohaannisi enttaw markkattida markkatethay hayssa. ");
INSERT INTO gofRNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Yohaannisi, “Taani Kiristtoosa gidikke” yaagidi, geeshshidi markkattisippe attin kaddibeenna. ");
INSERT INTO gofRNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Entti, “Yaatin, neeni oonee? Neeni Eliyaaseyye?” yaagidi oychchidosona. Yohaannisi, “Akkay gidikke” yaagis. Qassi entti, “Neeni yaana geetettida nabiyayye?” yaagidi oychchidosona. Yohaannisi, “Akkay” gidi zaaris. ");
INSERT INTO gofRNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Yaatin, “Neeni oonee? Nuuni nuna kiittidayssatas odana mela neeni nena oona gay?” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yohaannisi zaaridi, “Nabiya Isayaasi gidayssada, ‘Godaa ogiya suurisite!’ gidi bazzo biittan waassiya uraa qaalay tana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Qassi Farisaaweti kiittida asati ");
INSERT INTO gofRNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Yohaannisakko, “Neeni Kiristtoosa woykko Eliyaasa woykko nabe gidonna ixxiko, yaatin ays xammaqay?” gidi oychchidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yohaannisi zaaridi, “Taani haathan xammaqays, shin hintte eronna asi hintte giddon eqqis. ");
INSERT INTO gofRNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","I taappe guyera yees. Taani hari attoshin iya caammaa wodoruwa billanaw bessike” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Hessi ubbay Yorddaanose Shaafappe hefinthan, Bitaaniya kataman, Yohaannisi xammaqiya bessan hanis. ");
INSERT INTO gofRNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Yohaannisi wonttetha gallas Yesuusi baakko yishin be7idi, “Alamiya nagaraa quchchiya Xoossaa Dorssay hayssa! ");
INSERT INTO gofRNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Taani, ‘Taappe guyera issi asi yaana. I taappe kase de7iya gisho taappe aadhdhees’ gada odidayssi hayssa. ");
INSERT INTO gofRNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","I ooneekko taani erikke. Shin Isra7eele asaas iya qonccisanaw haathan xammaqashe yas” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Yohaannisi hayssada yaagidi markkattis: “Geeshsha Ayyaanay saloppe holeda wodhdhishininne iyara de7ishin be7as. ");
INSERT INTO gofRNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Hessi hananaappe kase taani iya erikke. Shin haathan xammaqanaw tana kiittida Xoossay, ‘Geeshsha Ayyaanay wodhdhidi iyara de7ishin neeni be7anaysinne Geeshsha Ayyaanan xammaqanayssi iya’ yaagidi taw odis. ");
INSERT INTO gofRNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Taani hessi hanishin be7ada, I Xoossaa Na7aa gididayssa markkattays” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Qassi wonttetha gallas Yohaannisi ba tamaaretappe nam77atara issife eqqis. ");
INSERT INTO gofRNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Yesuusi aadhdhishin Yohaannisi be7idi, “Xoossaa dorssay haysish!” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Nam77u Yohaannisa tamaareti Yohaannisi geyssa si7idi Yesuusa kaallidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesuusi bana kaalleyssata guye simmi be7idi, “Ay koyeetii?” yaagidi oychchis. Entti zaaridi, “Asttamaariyaw, neeni awun de7ay?” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yesuusi enttako, “Haa yidi be7ite” yaagis. Entti bidi I de7iyasuwa be7idosona. He gallas sa7ay tammu saate heera gidiya gisho iya matan pee7idosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Yohaannisi gidayssa si7idi, Yesuusa kaallida nam77u tamaaretappe issoy, Simoon Phexiroosa ishaa Inddiriyasa. ");
INSERT INTO gofRNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Inddiriyasi koyro ba ishaa Simoonara gahettidi, “Nuuni Kiristtoosa demmida” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Inddiriyasi Simoona Yesuusakko ehis. Yesuusi Simoona be7idi, “Neeni Yoona na7aa Simoona; ne sunthay Keefa gidi xeegettana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Wonttetha gallas Yesuusi Galiila biittaa baanaw qofa qachchis. I Filphoosara gahettidi, “Tana kaalla!” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filphoosi, Inddiriyasinne Phexiroosi de7ida Beetesayda katamaappe yida ase. ");
INSERT INTO gofRNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filphoosi Natina7eelara gahettidi, “Musey higge maxaafan, qassi nabetikka iyabaa xaafida Yoosefa na7aa Naazirete Yesuusa nuuni demmida” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natina7eeli zaaridi, “Naazirete katamaappe lo77obay keyanaw dandda7ii?” yaagis. Filphoosi, “Yada be7a” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Natina7eeli baakko yeyssa Yesuusi be7idi, “Geney baynna tuma Isra7eele asi hayssa!” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natina7eeli Yesuusakko, “Neeni tana awun eray?” yaagis. Yesuusi zaaridi, “Filphoosi nena xeeganaappe sinthe, neeni balase mithaa garssan de7ishin taani nena be7as” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natina7eeli zaaridi, “Asttamaariyaw, neeni Xoossaa Na7aa! Neeni Isra7eele kawo!” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesuusi iyaakko, “Taani nena balase mithaa garssan be7as gida gisho ammanay? Neeni hayssafe aadhdhiyabaa be7ana!” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Qassi Yesuusi, “Taani hinttew tuma odays; saloy dooyettin, Xoossaa kiitanchchoti Asa Na7aa bolla keyishininne wodhdhishin hintte be7ana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Heedzantho gallas Galiila biittan Qaana kataman yaaganoy yaaganettis. Yesuusa aayyaa he yaaganuwan de7awusu. ");
INSERT INTO gofRNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yesuusikka ba tamaaretara issife he yaaganuwa xeegettis. ");
INSERT INTO gofRNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Woyne ushshay wurin, Yesuusa aayyaa Yesuusakko, “Enttaw woyne ushshay wuris” yaagasu. ");
INSERT INTO gofRNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yesuusi zaaridi, “Ta aaye, ne hayssan geloppa? Ta wodey buroo gakkibeenna” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Yesuusa aayyaa oosanchchotakko, “I hinttew odiyabaa aybibaa gidikkoka oothite” yaagasu. ");
INSERT INTO gofRNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ayhudeti bantta geesho wogaas go7ettiya usuppun shuchcha baathati he bessan de7oosona. Issi issi baathay nam77u woykko heedzu xugga oykkees. ");
INSERT INTO gofRNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesuusi oosanchchotakko, “Baathatan haathe kunthite” yaagis. Entti baathatas doona gakkanaw haathe kunthidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Yesuusi enttako, “Ha77i duuqqidi yaaganuwa aawatethan poliseyssas immite” yaagis. Entti iyaw efidi immidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Yaaganuwa aawatethan poliseyssi woyne ushshi laamettida haathaa ganxi ekkidi awuppe yidaakko eribeenna, shin haathaa kunthida oosanchchoti eroosona. Yaaganuwa aawatethan poliseyssi machchiw ekkeyssa xeegidi, ");
INSERT INTO gofRNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“Oonikka lo77o woyne ushshaa asaa koyrottidi ushshees. Yaatidi asay uyi kallidaappe guye qiraariya immees. Shin neeni lo77o woyne ushshaa hanno gakkanaw wotha aggadasa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yesuusi ha koyro malaataa Galiila biittan Qaana kataman oothis; hessan ba gitatethaa bessis. Iya tamaareti iya ammanidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Hessafe guye, Yesuusi ba aayera, ba ishataranne ba tamaaretara issife Qifirnahoome katamaa bidi guutha gallas gam77is. ");
INSERT INTO gofRNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ayhudeti bonchchiya Paasika Baale gallasay matatin Yesuusi Yerusalaame bis. ");
INSERT INTO gofRNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Bidi Xoossa Keethan boorata, miizata, dorssatanne holleta bayzeyssatanne bantta oydiyan uttidi miishe laammeyssata demmis. ");
INSERT INTO gofRNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","I xurqqafe dooqidi asaa ubbaa entta mehetara Xoossa Keethafe gooddidi kare kessis. Miishe laammeyssata xarpheezatakka aathi yeggidi entta miishiya laallis. ");
INSERT INTO gofRNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Holle bayzeyssata, “Ha holleta hayssafe kessite; ta Aawa keetha giya oothofite” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Iya tamaareti Geeshsha Maxaafan, “Taani ne keethas mishettiya mishay tana tamada xuuggees” geetettidi xaafettidayssa akeekidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Hessafe guye, Ayhudeti zaaridi, “Ne hayssa oothanaw new maati de7eyssas nuna ay malaata oothada bessanee?” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesuusi, “Ha Xoossa Keetha laallite; taani heedzu gallasan zaarada keexana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Qassika Ayhudeti, “Ha Xoossa Keetha keexanaw oytamanne usuppun laythi ekkis, shin neeni heedzu gallasan keexanee?” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Shin Yesuusi odiya Xoossa Keethay ba asatethaabaa. ");
INSERT INTO gofRNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Hessa gisho, Yesuusi hayqoppe denddidaappe guye iya tamaareti I hessa gidayssa akeekidosona. Qassi entti Geeshsha maxaafan xaafettidayssanne Yesuusi odidayssa ammanidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Yesuusi Paasika bonchchiya bessan Yerusalaamen de7ishin, I oothida malaatata be7idi daro asay iya ammanidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Shin Yesuusi asaa ubbaa eriya gisho entta ammanibeenna. ");
INSERT INTO gofRNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Asa wozanan de7iyabaa I ba huu7en eriya gisho asabaa oonikka iyaw odana mela koshshibeenna. ");
INSERT INTO gofRNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Farisaaweta yaraappe gidida, Ayhudeta halaqay, Niqodimoosa giya issi addey de7ees. ");
INSERT INTO gofRNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Niqodimoosi qamma Yesuusakko yidi, “Asttamaariyaw, neeni Xoossay kiittida asttamaare gideyssa nuuni eroos. Ays giikko, Xoossay iyara doonna ixxiko ha neeni oothiya malaata oothanaw dandda7iya asi baawa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesuusi zaaridi, “Taani new tuma odays; oonikka zaari yelettonna ixxiko Xoossaa kawotethaa be7anaw dandda7enna” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Niqodimoosi, “Ceega asi waanidi zaari yelettanaw dandda7ii? Ba aaye ulo simmi gelidi zaari yelettanaw dandda7ii?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesuusi zaaridi, “Taani new tuma odays; oonikka haathafenne Geeshsha Ayyaanaappe yelettonna ixxiko, Xoossaa kawotethaa gelanaw dandda7enna. ");
INSERT INTO gofRNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Asho na7atethi aawuppenne aayippe yees; Xoossaa na7atethi Geeshsha Ayyaanaappe imettees. ");
INSERT INTO gofRNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Taani, ‘Hintte zaari yelettanaw bessees’ gada hinttew odida gisho neeni malaalettofa. ");
INSERT INTO gofRNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Carkkoy ba koyida bessi carkkees. Neeni iya kooshinchcha si7asappe attin I awuppe yaakko woykko aw biyakko erakka. Ayyaanaappe yelettida ubbay hessa mela” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Yaatin Niqodimoosi, “Hessi waanidi hananaw dandda7ii?” yaagidi oychchis. ");
INSERT INTO gofRNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesuusi zaaridi, “Neeni Isra7eelata asttamaare gidashe hayssa erikkii? ");
INSERT INTO gofRNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Taani new tuma odays; nu eriyabaa odoosinne be7idabaa markkattoos, shin nu markkatethaa hintte ekkeketa. ");
INSERT INTO gofRNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Taani hinttew sa7abaa odin hintte ammanonnabaa gidikko salobaa odin waati ammananee? ");
INSERT INTO gofRNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Saloppe wodhdhida Asa Na7aappe attin salo keyiday oonikka baawa; salon de7iya Asa Na7ay tana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","15","Musey bazzo biittan biraata shooshi kaqqidayssada tana ammanida ubbay merinaa de7uwa ekkana mela Asa Na7ay dhoqqu gaanaw bessees. ");
INSERT INTO gofRNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Xoossaa Na7aa ammaniyaa ubbay merinaa de7uwa laattanaappe attin dhayonna mela Xoossay ha alamiya daro dosida gisho ba issi Na7aa immis. ");
INSERT INTO gofRNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Xoossay ba Na7aa ha alamiya kiittiday alamiya pirddanaw gidonnashin alamiya iya baggara ashshanaassa. ");
INSERT INTO gofRNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Na7aa ammaniyaa oonikka pirddettenna, shin Na7aa ammanonna oonikka issi Xoossaa Na7aa ammaniboonna gisho ha77i pirddettis. ");
INSERT INTO gofRNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Pirddayka hayssa: poo7oy alamiya yis, shin asaa oosoy iita gidiya gisho asay poo7uwappe aathidi dhumaa dosees. ");
INSERT INTO gofRNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Iitabaa oothiya oonikka poo7o ixxees. Ays giikko, ba oosoy qoncconna mela poo7uwakko yeenna. ");
INSERT INTO gofRNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Shin tuma oothiya oonikka Xoossay kiittidayssada I oothidayssa poo7oy qonccisana mela poo7uwakko yees. ");
INSERT INTO gofRNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Hessafe guye, Yesuusinne iya tamaareti Yihuda biitta bidosona. Yesuusi yan xammaqishe enttara guutha wode uttis. ");
INSERT INTO gofRNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Qassi Yohaannisi Saleeme matan de7iya Henoona giyason gidiya haathi de7iya gisho asaa yan xammaqees. Asaykka yaa bidi xammaqettosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","He wode Yohaannisi buroo qashettibeenna. ");
INSERT INTO gofRNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Hessafe guye, Yohaannisa tamaaretinne issi Ayhude addey geesho wogabaa palamidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Entti Yohaannisakko bidi, “Asttamaariyaw, Yorddaanose Shaafappe hefinthan neera de7eyssi, neeni iyabaa markkattidayssi, hekko xammaqees. Asay ubbayka iyaakko boosona” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yohaannisi zaaridi, “Xoossay immonna asi aybibaakka ekkanaw dandda7enna. ");
INSERT INTO gofRNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","‘Taani Kiristtoosa gidikke, shin iyappe sinthe kiitetas’ gidayssas hinttee, hintte huu7en taw markka. ");
INSERT INTO gofRNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Gelos giigidaara ekkenaw giigidayssassa. Ekkeyssa laggey iya matan eqqidi I geyssa si7iya wode daro ufayttees. Hessa gisho, hayssi ta ufayssay polettis. ");
INSERT INTO gofRNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","I gitatanaw taani guuxanaw bessees” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Bollafe yeyssi ubbaafe bolla. Sa7appe benttidayssi sa7abaa. I sa7abaa odees. Saloppe yeyssi ubbaafe bolla. ");
INSERT INTO gofRNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","I ba be7idabaanne si7idabaa markkattees, shin iya markkatethaa ekkey baawa. ");
INSERT INTO gofRNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Iya markkatethaa ekkiya oonikka Xoossay tuma gideyssa qonccisees. ");
INSERT INTO gofRNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Xoossay ba geeshsha Ayyaana iyaw kumethi immiya gisho Xoossay kiittidayssi Xoossaa qaala odees. ");
INSERT INTO gofRNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Aaway ba Na7aa dosidi ubbabaa iya kushen wothis. ");
INSERT INTO gofRNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Na7aa ammaniyaa uraas merinaa de7oy de7ees. Shin Na7aa ammanonnayssa bolla Xoossaa hanqoy de7eesippe attin I de7o demmenna. ");
INSERT INTO gofRNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Yesuusi Yohaannisayssafe dariya kaalleyssata baakko shiisheyssanne xammaqeyssa Farisaaweti si7idosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Gidikkoka Yesuusa tamaareti xammaqidosonappe attin Yesuusi oonakka xammaqibeena. ");
INSERT INTO gofRNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Yesuusi asay iyabaa geyssa si7ida wode Yihudappe denddidi Galiila bis. ");
INSERT INTO gofRNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Galiila bishe Samaarera aadhdhanayssi iyaw attonnabaa gidis. ");
INSERT INTO gofRNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Hessa gisho, Yayqoobi ba na7aa Yoosefas immida gadiya matan de7iya Sikaare giya Samaare katamaa bis. ");
INSERT INTO gofRNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","He bessan Yayqooba haathaa ollay de7ees. Yesuusi hamuthan daaburidi he haathaa olla matan uttis. He wode sa7ay usuppun saate heera. ");
INSERT INTO gofRNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Issi Samaare katamaa maccas he ollaafe haathe tikkanaw yasu. Yesuusi he maccaseekko, “Tana haathe ushsharkkii” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","He wode Yesuusa tamaareti kathi shammanaw katama bidosonashin. ");
INSERT INTO gofRNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","He maccasiya zaarada, “Neeni Ayhude ase gidashe, Samaare maccas gidiya tana waanada haathe ushsha gay?” yaagasu. Hessa iya giday Ayhudeti Samaaretara gahettonna gishossa. ");
INSERT INTO gofRNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yesuusi zaaridi, “Neeni Xoossaa imotaanne haathe tana ushsha geyssi ooneekko eridabaa gidiyakko iya ne woossana; ikka new de7o immiya haathi immanashin” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Maccasiya zaarada, “Godaw, new duuqqiyabay baawa; ollayka ziqqa. Yaatin, de7o immiya haathi ne awuppe ekkanee? ");
INSERT INTO gofRNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Nuus ha haathaa olla immida nu aawa Yayqoobappe neeni aadhdhay? I, iya naytinne iya mehey ha ollaafe uyidosona” yaagasu. ");
INSERT INTO gofRNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesuusi, “Ha haathaafe uyida oonikka zaari saamottana. ");
INSERT INTO gofRNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Shin taani immana haathaa uyaa oonikka ubbakka saamottenna. Taani immana haathay iya giddon merinaa de7o immiya goggiya pultto gidana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Maccasiya zaarada, “Godaw, taani saamottonna melanne haathe tikkanaw ha bessaa yoonna mela taw he haathaa imma” yaagasu. ");
INSERT INTO gofRNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yesuusi iikko, “Bada ne azinaa xeegada ya” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Maccasiya zaarada, “Taw azini baawa” yaagasu. Yesuusi iikko, “Taw azini baawa guussan balabaakka. ");
INSERT INTO gofRNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","New kase ichchashu azinati de7oosona. Ha77i neera de7iya addey ne azina gidenna. Neeni ha77i tuma odadasa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Maccasiya zaarada, “Godaw, neeni nabe gideyssa taani eras. ");
INSERT INTO gofRNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Nu aawati ha deriya bolla Xoossaa goynnidosona. Shin hintte Ayhudeti asi Xoosse goynnanaw bessiya bessay Yerusalaamena geeta” yaagasu. ");
INSERT INTO gofRNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesuusi, “Ha maccasete tana ammana; ha deriya bolla woykko Yerusalaamen Aawa hintte goynnona wodey yaana. ");
INSERT INTO gofRNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Hintte Samaareti eronnayssa goynneeta. Shin nuuni atotethay Ayhudeppe yaa gisho nu ereyssa goynnos. ");
INSERT INTO gofRNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Shin Aawa tuman goynneyssati Ayyaananinne tumatethan goynnana wodey matattis; ha77ika gakkis. Hiza, Aaway koyey hayssa mela ogiyan goynneyssata. ");
INSERT INTO gofRNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Xoossay Ayyaana; iyaw goynneyssati Ayyaananinne tumatethan goynnanaw bessees” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Maccasiya zaarada, “Kiristtoosi yaanayssa taani erays. I yaa wode nuus ubbabaa odana” yaagasu. ");
INSERT INTO gofRNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yesuusi, “Ha neera odettey taani iya” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Entti odettishin, Yesuusa tamaareti bida bessaafe simmidosona. Yesuusi maccasara odettishin entti be7idi daro malaalettidosona. Shin maccaseekko, “Ay koyay?” Woykko Yesuusakko, “Iira ays odettay?” giday oonikka baawa. ");
INSERT INTO gofRNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Hessafe guye, maccasiya ba haatha otuwa aggada guye katamaa bada asaakko, ");
INSERT INTO gofRNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Taani oothidabaa ubbaa taw odida addiya be7anaw yedhdhite. I Kiristtoosa gidanddeshshaa?” yaagasu. ");
INSERT INTO gofRNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Asay katamaappe keyidi Yesuusakko bidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Hessi hanishin, iya tamaareti Yesuusakko, “Guuthabaa markkii” yaagidi woossidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Shin I, “Taw hintte eronna kathi ta meyssi de7ees” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Hessa gisho, iya tamaareti bantta giddon, “Iyaw miyabaa asi ehonna aggenna?” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yesuusi enttako, “Ta kathay tana kiittidayssa sheniya oothanayssanne iya oosuwa polanayssa. ");
INSERT INTO gofRNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Hintte, ‘Oyddu ageenappe guye kathay cakettana’ geekketiyye? Shin taani hinttew odays; kathay kaxidi shiishoos gakkidayssa loythi xeellite. ");
INSERT INTO gofRNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Zereyssinne cakkeyssi issife ufayttana mela cakkeyssi damooze ekkees qassi kathaa merinaa de7os shiishees. ");
INSERT INTO gofRNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Hiza, ‘Issoy zerees; hankkoy qassi cakkees’ giya oday tuma. ");
INSERT INTO gofRNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Hintte daaburiboonayssa shiishana mela taani hinttena kiittas. Harati oothi daaburidasuwan gelidi hintte entta daaburaa ayfiyaa ekkideta” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Maccasiya, “I, taani oothida ubbabaa odis” gada markkattida gisho he kataman de7iya Samaare asaappe daroti Yesuusa ammanidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Samaare asay Yesuusakko yidi, bantta matan gam77ana mela Yesuusa woossin I yan nam77u gallas uttis. ");
INSERT INTO gofRNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","I odiya qaala gisho kaseyssafe daro asay ammanidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Qassi entti maccaseekko, “Ha77i nu ammaney nu huu7en I geyssa si7ida gishossafe attin neeni markkattida gishossa gidenna. Qassi I tuma ha alamiya ashsheyssa gideyssa nuuni erida” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Nam77u gallasappe guye, Yesuusi yaappe keyidi Galiila biitta bis. ");
INSERT INTO gofRNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Yesuusi ba huu7en, “Nabey ba biittan bonchchettena” yaagidi kasetidi odis. ");
INSERT INTO gofRNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Yesuusi Galiila gakkida wode Galiila asay iya mokkidosona. Ays giikko, Paasika Baale bonchchiya gallas entti Yerusalaamen de7iya gisho I oothidabaa ubbaa be7idosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yesuusi haathaa woyne ushshi laammida bessaa, Galiilan de7iya Qaana katama bis. Qifirnahoomen kawo keethan oothiya issi shuumaas na7ay harggettis. ");
INSERT INTO gofRNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Yesuusi Yihudappe Galiila yidayssa he shuumay si7idi iyaakko yis. Hayqqanaw matida ba na7aa bidi pathana mela Yesuusa woossis. ");
INSERT INTO gofRNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yesuusi shuumakko, “Xoossay oothiya malaatatanne oorathabata be7onna de7ishe hintte ubbarakka ammanekketa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Shuumay zaaridi, “Godaw, ta na7ay hayqqonna de7ishin taara yedhdharkki” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yesuusi, “Ne soo ba; ne na7ay paxana” yaagis. He shuumay Yesuusi gidayssa ammanidi ba soo bis. ");
INSERT INTO gofRNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","I ba soo bishin iya aylleti iyaakko yishe iyara ogen gahettidi, “Ne na7ay paxis” gidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","I ba aylleta ba na7aas ay saaten lo77idaakko oychchis. Entti zaaridi, “Zine laappun saaten mishay aggis” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Na7aa aaway Yesuusi baakko, “Ne na7ay paxana” giday he saatiyan gideyssa akeekis. Hessa gisho, inne iya soo asa ubbay ammanidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Hessi Yesuusi Yihudappe Galiila yidi oothida nam77antho malaataa. ");
INSERT INTO gofRNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Hessafe guye, Yesuusi Ayhudeti bonchchiya baaliyas Yerusalaame bis. ");
INSERT INTO gofRNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Yerusalaamen Dorssa Penggiya matan Ibraysxe doonan Beetesayda giya teqettida haathi de7ees. He teqeti uttida haathaa matan ichchashu shemppiya bessati de7oosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Hessan haathay qaaxxanayssa naagiya daro hargganchchoti, qooqeti, wobbetinne gunddati zin77idosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Ays giikko, issi issi toho Godaa kiitanchchoy teqettida haathan wodhdhidi haathaa qaathees. Haathay qaaxxiya wode koyro gelida uray bana oykkida ay harggefekka paxees. ");
INSERT INTO gofRNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","He bessan hasttamanne hosppun laythi harggettida issi addey de7ees. ");
INSERT INTO gofRNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesuusi yan zin77ida addiya be7idi, qassi daro wode harggettidayssa eridi addiyako, “Paxanaw koyay?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Hargganchoy zaaridi, “Godaw, haathay qaaxxiya wode tana haathan yeggiya asi baawa. Taani gelana haniya wode haray taappe sinthattidi geli kichchees” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yesuusi iyaakko, “Dendda eqqa; ne alggaa tookkada ba” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Addey sohuwarakka paxis; ba alggaa tookkidi bis. Hessi Sambbaata gallasan hanis. ");
INSERT INTO gofRNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Hessa gisho, Ayhudeti paxida addiyako, “Hachchi sa7ay Sambbaata; neeni ne alggaa tookkeyssi woga gidenna” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Shin addey, “Tana pathidayssi, ne alggaa tookkada ba gis” yaagidi zaaris. ");
INSERT INTO gofRNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Entti iyaakko, “Nena, ne alggaa tookkada ba giday I oonee?” yaagidi oychchidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Shin Yesuusi he bessan daro asaa giddora erisonna kanthidi bida gisho addey bana pathiday ooneekko erenna. ");
INSERT INTO gofRNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Yesuusi guyeppe he addiya Xoossa Keethan demmidi, “Hekko, neeni paxadasa; hayssafe iitabay nena gakkonna mela zaarada nagara oothofa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Hessafe guye, addey bidi bana pathidayssi Yesuusa gididayssa Ayhudetas odis. ");
INSERT INTO gofRNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Yesuusi hessa Sambbaata gallas oothida gisho Ayhudeti Yesuusa gooda oykkidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yesuusi zaaridi, “Ta Aaway ubba wode oothees; takka oothanaw bessees” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Yesuusi Sambbaata bonchchonna gisho xalaalas gidonnashin Xoossay ba Aawa gidi bana Xoossara giigisida gisho Ayhudeti iya wodhanaw kaseppe minthidi koyidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yesuusi zaaridi, “Taani hinttew tuma odays; Na7ay barkka aykkoka oothanaw dandda7enna. I ba Aaway oothishin be7oyssa xalaala oothees. Aaway ootheyssa Na7aykka oothees. ");
INSERT INTO gofRNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Aaway ba Na7aa dosiya gisho I oothiya ooso ubbaa ba Na7aa bessees. Hintte malaalettana mela I hayssafe aadhdhiya ooso ba Na7aa bessana. ");
INSERT INTO gofRNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Aaway hayqqidayssata hayqoppe denthidi enttaw de7o immeyssada Na7aykka ba koyeyssatas de7o immees. ");
INSERT INTO gofRNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Aaway Na7aas pirdda maata ubbaa immisppe attin I oonakka pirddenna. ");
INSERT INTO gofRNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Asay ubbay Aawa bonchcheyssada Na7aakka bonchchana. Na7aa bonchchonna oonikka Na7aa kiittida Aawakka bonchchenna. ");
INSERT INTO gofRNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Taani hinttew tuma odays; ta qaala si7eyssasinne tana kiittidayssa ammaneyssas merinaa de7oy de7ees. I hayqoppe de7on pinnida gisho pirddettenna. ");
INSERT INTO gofRNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Taani hinttew tuma odays; hayqqida asay Xoossaa Na7aa qaala si7iya wodey yaana; hessika ha77i. He qaalaa si7ey de7on daana. ");
INSERT INTO gofRNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Aaway de7os pultto gididayssada Na7aakka de7os pultto oothis. ");
INSERT INTO gofRNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Na7ay Asa Na7a gidiya gisho Aaway Na7aas pirdda maata immis. ");
INSERT INTO gofRNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Duufon de7eyssati iya qaala si7idi denddiya wodey yaana gisho hayssan malaalettofite. ");
INSERT INTO gofRNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Lo77o oothidayssati de7on daanaw qassi iita oothidayssati pirdda ekkanaw duufoppe denddana. ");
INSERT INTO gofRNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Taani ta maatan aybibaakka oothanaw dandda7ikke. Xoossay taw odidayssada pirddays. Taani tana kiittidayssi koyabaa oothaysippe attin ta koyabaa oothonna gisho ta pirdday tuma. ");
INSERT INTO gofRNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Taani tabaa markkatiko ta markkatethay tuma gidenna. ");
INSERT INTO gofRNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Tabaa markkattiya hari de7ees; I tabaa markkatteyssi tuma gideyssa taani erays. ");
INSERT INTO gofRNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Hintte Yohaannisakko ase kiittin I tumaas markkattis. ");
INSERT INTO gofRNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Taani hessa hinttew odey, hintte attana mela gadappe attin asa markkatethi taw koshshin gidenna. ");
INSERT INTO gofRNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yohaannisi muqaadada eexishe poo7is. Hintte guutha wode iya poo7uwan ufayttideta. ");
INSERT INTO gofRNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Shin taw Yohaannisappe aadhdhiya markki de7ees. Taani oothana mela ta Aaway taw immida oosoti tabaa markkattosona; Aaway tana kiittidayssa qonccisoosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","“Qassi tana kiittida Aawaykka ba huu7en tabaa markkattees. Hintte iya qaala ubbarakka si7ibeekketa woykko iya malaa be7ibeekketa. ");
INSERT INTO gofRNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","I kiittidayssa hintte ammanonna gisho iya qaalay hintte wozanan baawa. ");
INSERT INTO gofRNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","“Geeshsha Maxaafatappe merinaa de7o demmanabaa hinttew daanin entta pilggeeta; entti tabaa markkattosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Shin hintte de7o demmanaw taakko yaanaw koyekketa. ");
INSERT INTO gofRNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Asappe taani bonchcho koyikke. ");
INSERT INTO gofRNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Shin taani hintte wozanan Xoossaa siiqoy baynnayssa erays. ");
INSERT INTO gofRNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Taani ta Aawa maatan yas, shin tana mokkibeekketa. Haray ba maatan yaa wode iya mokkeeta. ");
INSERT INTO gofRNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Hintte issoy issuwafe bonchcho koyeyssati, issi Xoossaafe yaa galata ekkanaw koyonnayssati, waanidi tana ammananaw dandda7etii? ");
INSERT INTO gofRNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Taani ta Aawa sinthan hinttena mootiyabaa hinttew daanoppo. Hinttena mootanay hintte ufayssan naagiya Muse. ");
INSERT INTO gofRNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Hintte Muse ammanidabaa gidiyakko I tabaa xaafida gisho tanakka ammananashin. ");
INSERT INTO gofRNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Shin hintte I xaafidayssa ammanonna ixxiko ta qaala waattidi ammananee?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Hessafe guye, Yesuusi Xibaaryoosa giya Galiila Abbaafe hefinthi pinnis. ");
INSERT INTO gofRNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","I hargganchchota pason oothida malaata be7ida gisho daro asay iya kaallidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yesuusi deriya bolla keyidi, yan ba tamaaretara issife uttis. ");
INSERT INTO gofRNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ayhudeti bonchchiya Paasika Baale gallasay gakkis. ");
INSERT INTO gofRNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yesuusi daro asay baakko yeyssa be7idi Filphoosakko, “Ha asaa ubbaa muzanaw gidiya kathi awuppe shammanee?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","I hessa Filphoosa paaccanaw gisippe attin I ba huu7en ay oothaneekko erees. ");
INSERT INTO gofRNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filphoosi zaaridi Yesuusakko, “Hari attoshin, Huu7en huu7en, issi issi barssi gathanaw, nam77u xeetu dinaaren uythu shamminkka gidenna” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Qassi Yesuusa tamaaretappe issoy, Simoon Phexiroosa ishay Inddiriyasi, ");
INSERT INTO gofRNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Ichchashu bangga soollonne nam77u molo oykkida issi na7ay hayssan de7ees, shin ha asa ubbaas hessi ay maaddanee?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yesuusi ba tamaaretakko, “Asaa utisite” yaagis. He bessan daro maati de7ees; asa ubbay uttis. Adde asaa tayboy ichchashu mukulu gidana. ");
INSERT INTO gofRNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yesuusi uythaa ekkidi Xoossaa galati simmidi yan uttida asaas gishis. Moluwakka ekkidi hessada oothidi immin, asay ba koyidayssa mela mis. ");
INSERT INTO gofRNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Entti ubbay kallidaappe guye Yesuusi ba tamaaretakko, “Issibaykka iitonna mela attida tiifiya shiishite” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Hessa gisho, entti ubbaa shiishidosona. Asay min attida bangga soollo tiifiya shiishidi tammanne nam77u gayta kunthidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Asay Yesuusi oothida malaatata be7ida wode “Hayssi tuma ha alamiya yaana geetettida nabiya” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yesuusi entti iya oykkidi wolqqan kawo oothanaw haneyssa eridi, barkka deriya bolla zaari keyis. ");
INSERT INTO gofRNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Sa7ay omarssida wode Yesuusa tamaareti abbaako wodhdhidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Sa7ay qammida gishonne Yesuusi buroo enttako yiboonna gisho iya tamaareti wogolon gelidi abbaa pinnidi Qifirnahoome baanaw denddidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Wolqqaama carkkoy carkkida gisho abbay qaaxxees. ");
INSERT INTO gofRNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ichchashu woykko usuppun kilo mitire gideyssa mela entti abbaa pidhidi bidaappe guye Yesuusi abbaa bollara hamuttishe yeyssa be7idi yayyidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Shin I, “Babbofite, tana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Entti ufayttidi iya wogoluwan gelssidosona; iirakka wogoloy entti biya abbaa gaxa gakkis. ");
INSERT INTO gofRNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Wonttetha gallas abbaafe hefinthan attida daro asay issi wogolo xalaali de7eyssa be7idosona. Yesuusi ba tamaaretara wogoluwan gelidi, enttara boonnayssanne entti banttarkka bidayssa akeekidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Shin Xibaaryoosappe hara wogoloti Yesuusi Xoossaa galatin, asay uythaa mida bessaa yidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Asay Yesuusi woykko iya tamaareti yan baynnayssa be7idi, Yesuusa koyanaw wogolotan gelidi Qifirnahoome bidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Asay Yesuusa abbaafe hefinthan demmida wode “Asttamaariyaw, haa awude yadi?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesuusi zaaridi, “Taani hinttew tuma odays; hintte tana koyey uythi midi kallida gishossafe attin malaata be7ida gishossa gidenna. ");
INSERT INTO gofRNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Samiya kathas oothofite, shin merinaa de7o immiya kathas oothite. Xoossaa Aaway I oothana mela iyaw maata immida gisho he kathaa Asa Na7ay hinttew immana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Yaatin entti, “Nuuni Xoossaa oosuwa oothanaw ay oothanee?” yaagidi Yesuusa oychchidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesuusi zaaridi, “Hintte oothana mela Xoossay koyaa oosoy hayssa: I kiittidayssa ammanite” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Entti zaaridi, “Nuuni be7idi, nena ammanana mela ay malaata ne bessanee? Ne ay oothanee? ");
INSERT INTO gofRNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Geeshsha Maxaafan, ‘Entti maana mela uythu saloppe immis’ geetetti xaafettidayssada nu aawati bazzo biittan manna midosona” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yesuusi, “Taani hinttew tuma odays; hinttew saloppe tuma uythaa immiday ta Aawappe attin Muse gidenna. ");
INSERT INTO gofRNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Hiza, Xoossay immiya uythay saloppe wodhdhidayssi alamiyas de7o immeyssa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Entti zaaridi, “Godaw, nuus he uythaa ubba wode imma” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yesuusi, “Taani de7o immiya uythaa; taakko yaa oonikka ubbaraka koshattenna. Qassi tana ammaniyaa uray ubbarakka saamottenna. ");
INSERT INTO gofRNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Shin taani hinttew odas; hintte tana be7ideta, shin ammanekketa. ");
INSERT INTO gofRNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ta Aaway taw immiya ubbay taakko yaana; qassi taakko yaa oonakka kare yeddike. ");
INSERT INTO gofRNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Taani ta koyabaa oothanaw gidonnashin tana kiittidayssi koyabaa oothanaw saloppe yas. ");
INSERT INTO gofRNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Tana kiittidayssi koyey hayssa: taani I taw immida ubbatakka wurssetha gallas hayqoppe denthana melappe attin issuwaka dhayssana mela koyenna. ");
INSERT INTO gofRNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Hiza, ta Aaway koyey hessa: Na7aa be7idi ammaniyaa ubbay merinaa de7uwa ekkana; taani he ubbaa wurssetha gallas merinaa de7os hayqoppe denthana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Yesuusi, “Taani saloppe wodhdhida uythaa” gida gisho Ayhudeti iya bolla zuuzummidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Entti, “Hayssi nuuni iya aawanne iya aayiw eriya Yoosefa Na7aa Yesuusa gidennee? Yaatin, I waanidi, ‘Taani saloppe wodhdhas’ gaanaw dandda7ii?” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yesuusi zaaridi, “Issoy issuwara zuuzummeyssa aggite. ");
INSERT INTO gofRNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Tana kiittida ta Aaway taakko ehiya asappe attin taakko yaanaw dandda7iya oonikka baawa. Taani wurssetha gallas iya merinaa de7os hayqoppe denthana. ");
INSERT INTO gofRNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Nabeti, ‘Xoossay asa ubbaa tamaarssana’ yaagidi xaafidosona. Aawa si7eyssinne iyappe tamaariya oonikka taakko yees. ");
INSERT INTO gofRNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Xoossaa matappe yidayssafe attin Aawa be7iday oonikka baawa; iya xalaali Aawa be7is. ");
INSERT INTO gofRNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","“Taani hinttew tuma odays; tana ammaniyaa ooddeskka merinaa de7oy de7ees. ");
INSERT INTO gofRNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Taani de7o immiya uythaa. ");
INSERT INTO gofRNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Hintte aawati bazzon manna midosona, shin hayqqidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Saloppe yaa uythay hayssa; he uythaa miya oonikka hayqqenna. ");
INSERT INTO gofRNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Saloppe yida de7o uythay tana. Oonikka ha uythaa miikko merinaw daana. Qassi ha alamey de7on daana mela taani hinttew immana uythay ta ashuwa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ayhudeti, “Ha addey ba ashuwa nu maana mela nuus waattidi immanaw dandda7ii?” yaagidi bantta giddon palamidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Hessa gisho, Yesuusi enttako, “Taani hinttew tuma odays; Asa Na7aa ashuwa, hintte moonna ixxiko, qassi iya suuthaa hintte uyonna ixxiko, hinttew de7oy baawa. ");
INSERT INTO gofRNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ta ashuwa miya uraasinne ta suuthaa uyaa uraas merinaa de7oy de7ees. Taani wurssetha gallas iya hayqoppe denthana. ");
INSERT INTO gofRNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ta ashoy tuma kathi; ta suuthaykka tuma ushshu. ");
INSERT INTO gofRNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ta ashuwa miya uraynne ta suuthaa uyaa uray tanan de7ees; takka iyan de7ays. ");
INSERT INTO gofRNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","De7o Aaway tana kiittin, taani iya baggara de7on de7eyssada, tana miya uraykka ta gaason de7on daana. ");
INSERT INTO gofRNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Saloppe wodhdhida uythay hayssa: hintte aawati midi hayqqida manna mela gidenna; ha uythaa miya uray merinaw daana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesuusi Qifirnahoome kataman Ayhude Woosa Keethan hayssa tamaarssis. ");
INSERT INTO gofRNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Yesuusa tamaaretappe dariya baggay hessa si7ida wode “Hayssi gelonna timirtte; hayssi ooddes gelii?” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yesuusi ba tamaareti hessas zuuzummidayssa eridi, “Hayssi hinttena dhubbi? ");
INSERT INTO gofRNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Yaatin, Asa Na7ay kase de7iyasuwa pude keyishin hintte be7idi woyganddetii? ");
INSERT INTO gofRNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Geeshsha Ayyaanay de7o immees; asa wolqqi aykkoka maaddenna. Ta hinttew odiya qaalay de7o immiya Geeshsha Ayyaanaappe yees. ");
INSERT INTO gofRNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Shin hintte giddon ammanonnayssati de7oosona” yaagis. Ammanonnayssati oonanteeko Yesuusi koyroppe doomidi erees. Qassi bana aathi immanay ooneekko erees. ");
INSERT INTO gofRNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Qassika Yesuusi, “Aaway ba goonna oonikka taakko yaanaw dandda7enna gada taani odiday hessa gishossa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Hessa gaason, Yesuusa kaalleyssatappe daroti iya aggidi guye simmidosona; zaari iya kaallibookkona. ");
INSERT INTO gofRNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Yesuusi tammanne nam77u ba tamaareta, “Hintteka aggidi baanaw koyeetii?” yaagidi oychchis. ");
INSERT INTO gofRNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simoon Phexiroosi zaaridi, “Godaw, nuuni ooddeko baanee? New merinaa de7o immiya qaalay de7ees. ");
INSERT INTO gofRNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Neeni Xoossaa Geeshshaa gideyssa nuuni ammanoosinne eroos” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yesuusi enttako, “Taani hinttena tammanne nam77ata doorabiikkinaa? Shin hinttefe issoy Xalahe” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yesuusi hessa giday Simoona Na7aa Asqoroota Yihudasa. Yihudi Yesuusa aathi immanaw de7iya tammanne nam77u tamaaretappe issuwa. ");
INSERT INTO gofRNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Hessafe guye, Ayhudeti Yesuusa wodhanaw koyaa gisho I Yihuda aggidi Galiilan simerettees. ");
INSERT INTO gofRNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ayhudeti bonchchiya Shaqara Baaley bonchchettanaw matis. ");
INSERT INTO gofRNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Hessa gisho, Yesuusa ishati, “Ne tamaareti neeni oothiya malaatata be7ana mela hayssafe denddada Yihuda biittaa ba. ");
INSERT INTO gofRNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Baw erettanaw koya asi oonikka ba oosuwa genthenna. Neeni hayssata oothada nebaa alamiya erisa” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Iya ishati hessa giday iyan ammaniboonna gishossa. ");
INSERT INTO gofRNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yesuusi enttako, “Taw injje wodey gakkibeenna, shin hinttew ubba wodey injjetees. ");
INSERT INTO gofRNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Alamey hinttena ixxanaw dandda7enna, shin taani alamiya oosoy iita gideyssa markkattiya gisho tana ixxees. ");
INSERT INTO gofRNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Hintte baaliya biite; ta wodey gakkiboonna gisho taani baaliya biikke” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","I hessa gidi Galiilan attis. ");
INSERT INTO gofRNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Iya ishati baaliya bonchchanaw bidaappe guye Yesuusi oonakka erisonna qosan he bessaa bis. ");
INSERT INTO gofRNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ayhudeti baaliya bonchchiya bessan, “I awun de7ii?” yaagidi iya koyidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Asay kalkkashidi iyabaa odettoosona. Baggay, “I lo77o asi” giya wode harati qassi, “Akkay, I asaa balethees” yaagosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Shin Ayhude halaqatas yayyida gisho oonikka iyabaa qonccen odettenna. ");
INSERT INTO gofRNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Baaliya bonchchidi giddo gathiya wode Yesuusi Xoossa Keethi bidi tamaarsso oykkis. ");
INSERT INTO gofRNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ayhudeti, “Ha addey timirtte tamaaronna hayssa ubbaa waati eridee?” yaagidi malaalettidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yesuusi zaaridi, “Ta tamaarssiya timirttey tana kiittida Xoossaa matappe yaa timirttefe attin tabaa gidenna. ");
INSERT INTO gofRNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Xoossaa sheniya oothanaw koyaa oonikka ha timirttey Xoossaa matappe yiyaakkonne woykko taani taappe odiyakko erana. ");
INSERT INTO gofRNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Babaa odiya oonikka ba huu7e bonchcho koyees. Shin bana kiittidayssa bonchchuwa koyaa oonikka I tumanchcho; iyan worddoy baawa. ");
INSERT INTO gofRNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Musey hinttew higgiya immis, shin hinttefe oonikka higgiya naagibeenna. Yaatin ays tana wodhanaw koyeetii?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Asay zaaridi, “Nena Xalahey oykkis; nena wodhanaw oonee koyey?” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesuusi, “Taani issi malaata oothin hintte ubbay malaalettideta. ");
INSERT INTO gofRNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Hinttee, hintte nayta qaxxarana mela Musey kiittis. Shin qaxxaro hintte mayzati doomidosonappe attin Muse gidenna. Hessa gisho, hintte Sambbaata gallas adde nayta qaxxareeta. ");
INSERT INTO gofRNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Muse higgey kiittida gisho hintte Sambbaata gallas qaxxariyabaa gidikko, taani issi asa kumetha asatethaa pathida gisho taara ays kacceetii? ");
INSERT INTO gofRNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Tuma pirdda pirdditeppe attin asa som77o be7idi pirddofite” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Yerusalaame asaappe issoti issoti, “Entti wodhanaw koyaa uray hayssa gidennee? ");
INSERT INTO gofRNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Hekko, i qonccen odees; entti iya aykkoka gookkona. I Kiristtoosa gideyssa Ayhude halaqati tuma eridonaashsha? ");
INSERT INTO gofRNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Kiristtoosi yaa wode I awuppe yaakko oonikka erenna, shin i awuppe yidaakko nu eroos” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yesuusi Xoossa Keethan tamaarssishe ba qaala dhoqqu oothidi, “Tuma hintte taani ooneekkonne ta awuppe yidaakko ereetii? Taani ta maatan yabiikke, shin tana kiittidayssi tumanchcho; hintte iya erekketa. ");
INSERT INTO gofRNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Shin taani I kiittin iya matappe yida gisho iya erays” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Hessa gisho, entti iya oykkanaw koyidosona. Shin iya wodey buroo gakkiboonna gisho oonikka iya bolla kushe wothibeenna. ");
INSERT INTO gofRNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Shin daro asay Yesuusa ammanidi, “Kiristtoosi yaa wode ha uray oothida malaatatappe dariya malaata oothaneeyye?” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Farisaaweti daro asay Yesuusabaa kalkkasheyssa si7idosona. Kahine halaqatinne Farisaaweti iya oythidi qashisanaw Xoossa Keethi naageyssata kiittidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yesuusi, “Taani hinttera guutha wode gam77ana; hessafe guye tana kiittidayssako baana. ");
INSERT INTO gofRNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Hintte tana koyana, shin demmeketa. Taani de7iyasuwa hintte yaanaw dandda7ekketa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ayhudeti issoy issuwara, “Hayssi nuuni demmonnaso aw baana hanii? Girike kataman de7iya Ayhudetakko bidi Giriketa tamaarssanaw haniyye? ");
INSERT INTO gofRNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","‘Hintte tana koyana, shin demmeketa’ qassi, ‘Taani de7iyasuwa hintte yaanaw dandda7ekketa’ guussay ay guussee?” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Baaliya bonchchiya gallasatappe wolqqaamanne wurssetha gallasan Yesuusi denddidi, ba qaalaa dhoqqu oothidi, “Saamottida oonikka taakko yidi uyo. ");
INSERT INTO gofRNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Tana ammaniyaa oonikka Geeshsha Maxaafay gidayssada de7o immiya pultto haathay iyappe goggana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","I hessa giday iya ammanidayssati ekkanaw de7iya Geeshsha Ayyaanabaa. Yesuusi buroo bonchchettiboonna gisho he wode Geeshsha Ayyaanay imettibeenna. ");
INSERT INTO gofRNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","He asaappe daroti I geyssa si7idi, “Tuma hayssi nabiya” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Harati qassi, “Hayssi Kiristtoosa” yaagidosona. Shin harati qassi, “Kiristtoosi Galiilappe waanidi keyi? ");
INSERT INTO gofRNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Geeshsha Maxaafay, ‘Kiristtoosi Dawite sheeshaappe Dawitey de7ida Beeteleme katamaappe yaana’ yaagenneyye?” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Hessa gisho, Yesuusa gaason asay bantta giddon shaakettidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","He asaappe issoti issoti iya oykkanaw koyidosona, shin oonikka iya bolla kushe wothibeenna. ");
INSERT INTO gofRNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Xoossa Keetha naageyssati kahine halaqatakkonne Farisaawetakko guye simmi yin entti, “Ays iya ehibeekketii?” yaagidi oychchidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Xoossa Keetha naageyssati enttako, “Ha addey odetteyssatho oonikka odettenna” yaagidi zaaridosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Farisaaweti zaaridi, “I hinttenakka balethidee? ");
INSERT INTO gofRNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ayhude halaqatappe woykko Farisaaweteppe iya ammanida asi de7ii? ");
INSERT INTO gofRNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Muse higgiya eronna ha asay qanggettidabaa” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Farisaawetappe issoy qamma Yesuusakko bida Niqodimoosi enttako, ");
INSERT INTO gofRNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Issi asi giyabaa si7onna woykko I ay oothidaakko eronna de7ishe koyrottidi iya bolla pirddeyssi nu higgiyan de7ii?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Entti zaaridi, “Neenikka qassi Galiila biitta ase? Galiila biittaafe nabey keyonnayssa Geeshsha Maxaafaappe pilggada demma” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Issoy issoy aggidi ba soo ba soo bis, shin Yesuusi Shamaho Deriya bolla bis. ");
INSERT INTO gofRNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Qassi wonttetha gallas guura Xoossa Keethi simmis. Daro asay iyaakko yin uttidi entta tamaarssis. ");
INSERT INTO gofRNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Higge asttamaaretinne Farisaaweti laymatishin oykkida issi maccasiw iyaakko ehidosona. Entti asa ubbaa sinthan iyo essidi, ");
INSERT INTO gofRNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","“Asttamaariyaw, ha maccasiya laymatishin nu oykkida. ");
INSERT INTO gofRNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Muse higgey hanni mela maccas shuchchan cadeetta hayqqana mela kiittees. Yaatin, neeni woygay?” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Entti hessa giday Yesuusa paaccidi iya mootiyabaa demmanaasa. Shin Yesuusi hokkidi ba biradhdhen biitta bolla xaafis. ");
INSERT INTO gofRNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Entti iya zaari zaari oychchidi aggonna ixxin, pude dhoqqu gidi, “Hintte giddon nagara oothiboonna asi koyrottidi iyo shuchchan caddo” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Qassika hokkidi biitta bolla xaafis. ");
INSERT INTO gofRNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Entti hessa si7ida wode cimatappe doomidi issoy issoy keyishe wuridosona. Yesuusa xalaali he bessan eqqida maccaseera attis. ");
INSERT INTO gofRNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","I pude dhoqqu gidi maccaseekko, “Maccasete, asati aw bidonaa? Ne bolla pirddiday oonikka baawee?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Maccasiya, “Godaw, oonikka baawa” yaagasu. Yesuusi zaaridi, “Taanikka ne bolla pirddike. Ba; zaarada nagara oothofa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Qassika Yesuusi asaakko, “Taani alamiyas poo7o. Tana kaalliya oonikka de7o immiya poo7uwa ekkanaappe attin dhuman simerettena” yaagidi odis. ");
INSERT INTO gofRNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Farisaaweti, “Ne nebaa markkattasa, shin ne markkatethay tuma gidenna” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesuusi zaaridi, “Taani tabaa markkattikokka ta markkatethay tuma. Ays giikko, taani awuppe yidaakko qassi aw biyakko erays, shin hintte erekketa. ");
INSERT INTO gofRNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Hintte asa qofan pirddeeta; taani issi asa bollaka pirddike. ");
INSERT INTO gofRNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Taani pirddiyabaa gidikkoka ta pirdday tuma. Ays giikko, tana kiittida ta Aaway taara de7eesippe attin taani tarkka de7ikke. ");
INSERT INTO gofRNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Nam77u asa markkatethi tuma gideyssi hintte higgiyan xaafettis. ");
INSERT INTO gofRNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Taani tabaa ta huu7en markkattays; qassi tana kiittida ta Aawaykka tabaa markkattees” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Entti, “Ne aaway awun de7ii?” yaagidi iya oychchidosona. Yesuusi zaaridi, “Hintte tana woykko ta Aawa erekketa. Tana eridabaa gidiyakko, hintte ta Aawakka eranashin” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesuusi Xoossa Keethan muxaata miishiya yeggiya saaxiney de7iya bessan hessa tamaarssis. Iya qammay buroo gakkiboonna gisho oonikka iya oykkibeenna. ");
INSERT INTO gofRNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Qassika Yesuusi enttako, “Taani baana; hintte tana koyana, shin hintte atotethi demmonna hintte nagaran hayqqana. Taani biyasuwa baanaw hintte dandda7ekketa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ayhude halaqati, “I, ‘Taani biyasuwa hintte baanaw dandda7ekketa’ yaagees. I bana barkka wodhaneyye?” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yesuusi zaaridi, “Hintte garssafe; taani bollafe. Hintte ha alamiyappe, taani ha alamiyappe gidikke. ");
INSERT INTO gofRNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Hintte atotethi demmonna hintte nagaran hayqqana gada taani hinttew odiday hessassa. Taani Tana Gideyssa hintte ammanonna ixxiko hintte atotethi demmonna hintte nagaran hayqqana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Entti, “Neeni oonee?” yaagidi oychchidosona. Yesuusi zaaridi, “Taani, koyroppe hinttew odida tana. ");
INSERT INTO gofRNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Taani hinttebaa odada pirddiyabay darobay de7ees. Shin tana kiittidayssi tumanchcho; qassi taani iyappe si7idayssa xalaala alamiyas odays” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Yesuusi ba Aawabaa odeyssa entti akeekibookkona. ");
INSERT INTO gofRNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Hessa gisho, Yesuusi enttako, “Hintte Asa Na7aa pude dhoqqu oothiya wode Taani Tana Gideyysa hintte erana. Qassika taani ta maatan aykkoka oothonayssanne ta Aaway tana tamaarssidayssa odeyssa hintte erana. ");
INSERT INTO gofRNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Tana kiittidayssi taara de7ees. Taani ubba wode iya ufayssiyabaa oothiya gisho I tana ta xalaala aggibeenna” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Yesuusi hessa odishin si7ida daro asay iya ammanidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yesuusi bana ammanida asatakko, “Hintte ta timirttiyas kiitettiko tuma tana kaalleyssata. ");
INSERT INTO gofRNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Hintte tumaa erana; tumaykka hinttena aylletethafe kessana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Entti zaaridi, “Nuuni Abrahame sheeshi; nuuni ooddeskka aylletibookko. Neeni woygada, ‘Hintte aylletethafe keyana’ gay?” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesuusi zaaridi, “Taani hinttew tuma odays; nagara oothiya oonikka nagara aylle. ");
INSERT INTO gofRNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Aylley merinaw soo asaara deenna, shin na7ay merinaw soo asaara de7ees. ");
INSERT INTO gofRNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Na7ay hinttena aylletethafe kessiko hintte aylletethafe tuma keyana. ");
INSERT INTO gofRNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Hintte Abrahame sheeshi gideyssa taani erays. Shin ta qaalay hintte wozanan baynna gisho tana wodhanaw koyeeta. ");
INSERT INTO gofRNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Taani ta Aaway tana bessidayssa odays, shin hintteka hintte aawappe si7idayssa ootheeta” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Entti zaaridi, “Nu aaway Abrahame” yaagidosona. Yesuusi enttako, “Hintte Abrahame nayta gidiyakko I oothidayssa oothana. ");
INSERT INTO gofRNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Shin Xoossafe si7ida tumaa odida tana hintte wodhanaw koyeeta. Abrahamey hessada oothibeenna. ");
INSERT INTO gofRNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Hinttee, hintte aaway oothidayssa ootheeta” yaagis. Entti zaaridi, “Nuuni tuma Xoossaa nayta; nuus issi Aaway Xoossaa xalaali de7ees” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesuusi enttako, “Xoossay tuma hintte aawa gidiyakko hintte tana dosana; ays giikko, taani Xoossaa matappe yada hayssan de7ays. Tana I kiittisppe attin taani ta maatan yabiikke. ");
INSERT INTO gofRNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Taani geyssa hintte si7anaw koyonna gisho ta giyabay hinttew gelenna. ");
INSERT INTO gofRNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Hinttee, hintte aawa Xalahe nayta. Qassi hinttee, hintte aaway amottiyabaa oothanaw koyeeta. I koyroppe doomidi shemppo wodheyssa. Tumi iyan baynna gisho I tumaa ixxees. Worddoy iyaw medho gidida gishonne I worddo aawa gidiya gisho worddo odettishe baappe odettees. ");
INSERT INTO gofRNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Taani tuma haasayays, shin hintte tana ammanekketa. ");
INSERT INTO gofRNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Hinttefe, ‘Neeni nagara oothishin ta be7as’ gaanaw dandda7ey oonee? Taani tuma odettiyabaa gidikko tana ays ammanekketii? ");
INSERT INTO gofRNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Xoossaa asi Xoossay giyabaa si7ees. Hintte Xoossaa asi gidonna gisho Xoossay giyabaa si7ekketa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ayhudeti zaaridi, “ ‘Neeni Samaare asi; nenan tuna ayyaanay de7ees’ gishe likke gidokko?” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesuusi enttako “Ta bolla tuna ayyaani baawa. Taani ta Aawa bonchchays, shin hintte tana kawushsheta. ");
INSERT INTO gofRNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Taani ta huu7e bonchcho koyikke; taani bonchchettana mela koyeysinne taw pirddeyssi de7ees. ");
INSERT INTO gofRNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Taani hinttew tuma odays; ta qaala naagiya oonikka hayqqenna” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ayhudeti zaaridi, “Ne bolla tuna ayyaanay de7eyssa nuuni ha77i erida. Abrahamey hayqqis; nabetikka hayqqidosona. Shin neeni, ‘Ta qaalaa naagiya oonikka hayqqenna’ yaagasa. ");
INSERT INTO gofRNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Neeni hayqqida nu aawa Abrahameppe aadhdhayye? Nabetikka qassi hayqqidosona. Neeni nena oona gada qoppay?” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesuusi, “Taani tana bonchchiko ta bonchchoy hada. Hintte, ‘Nu Xoossaa’ giya ta Aaway I tana bonchchees. ");
INSERT INTO gofRNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Hintte iya eronna ixxiko taani iya erays. Taani iya erikke giikko hintte mela worddotays. Shin taani iya erays; qassi iya qaalaakka naagays. ");
INSERT INTO gofRNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Hintte aaway Abrahamey ta yuussaa gallasa be7idi ufayttanaw amottis; be7idikka ufayttis” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ayhudeti zaaridi, “Hari attoshin, new ishatamu laythi kumibeennashin waanada Abrahame be7as gay?” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesuusi enttako, “Taani hinttew tuma odays; Abrahamey yelettanaappe kase Taani Tana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Hessa gisho, entti Yesuusa caddanaw shuchchi ekkidosona. Shin Yesuusi enttafe geemmidi Xoossa Keethafe keyidi bis. ");
INSERT INTO gofRNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yesuusi bishe yelettoosappe qooqe gididi de7iya issi addiya be7is. ");
INSERT INTO gofRNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Iya tamaareti, “Asttamaariyaw, ha addey qooqe gididi yelettana mela nagara oothiday oonee? I oothideyye woykko iya yelidayssati oothidonaa?” yaagidi oychchidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesuusi, “Xoossaa oosoy iya bolla qonccana melappe attin I woykko iya yelidayssati nagara oothida gisho gidenna. ");
INSERT INTO gofRNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Sa7i gallas de7ishin tana kiittidayssa oosuwa nu oothanaw bessees. Oonikka oothanaw dandda7onna qammay yees. ");
INSERT INTO gofRNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Taani alamiyan de7ashe alamiyas poo7o” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Yesuusi hessa gidi sa7an cuttis. Ba cuchchan guutha biitta laakothidi he urqqan qooqe addiya ayfiyaa tiyis. ");
INSERT INTO gofRNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Yaatidi, “Bada Salihoome (Salihoome guussay Kiitettidayssa guussu) giya teqettida haathan ne ayfiyaa meecetta” yaagis. Hessa gisho, addey bidi ba ayfiyaa meecettidi xeellishe simmis. ");
INSERT INTO gofRNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Addiya shoorotinne addey kase woossishin be7ida asay, “Hayssi uttidi woossiya addiya gidenneyye?” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Issi issi asay, “Hayssi iya” yaagidosona. Harati qassi, “Akkay, hayssi iya daaneesippe attin iya gidenna” yaagidosona. Shin addey, “Ee, tana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Entti iyaakko, “Yaatin ne ayfey waanidi xeellide?” yaagidi oychchidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","I zaaridi, “Yesuusa giya addey guutha urqqa laakothidi ta ayfiyaa tiyidi, ‘Salihoome bada ne ayfiyaa meecetta’ yaagin, taani bada meecettada xeella aggas” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Entti iyaakko, “I awun de7ii?” yaagidi oychchidosona. Addey, “Taani erikke” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Entti kase qooqe, shin ha77i xeellida addiya Farisaawetakko efidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Yesuusi urqqa laakothidi addiya ayfiyaa pathida gallasay Sambbaata gallas. ");
INSERT INTO gofRNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Hessa gisho, addey waanidi xeellidaakko Farisaaweti iya zaari oychchidosona. Addey enttako, “I ta ayfiyaan guutha urqqa tiyis. Ta ayfiyaa meecettada ha77i xeellays” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Farisaawetappe issoti issoti, “Hayssa oothida addey Sambbaata higgiya naagonna gisho Xoossaa matappe yibeenna” yaagidosona. Shin harati, “Nagaranchcho asi hayssa mela malaata waati oothanaw dandda7ii?” yaagidi bantta giddon shaakettidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Hessa gisho, Farisaaweti addiyako, “I ne ayfiyaa xeelisida gisho ne iyabaa woygay?” yaagidosona. Addey, “I nabe” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ayhude halaqati, iya aayiwunne aawa xeegidi oychchana gakkanaw, addey kase qooqe gididayssanne ha77i I xeelleyssa ammanibookkona. ");
INSERT INTO gofRNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Entti iya aayiwunne iya aawakko, “Hintte ‘Qooqe gididi yelettis’ giya hintte na7ay hayssee? Yaatin, ha77i waanidi xeellide?” yaagidi oychchidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Iya yelidayssati, “Hayssi nu na7aa gididayssanne qooqe gididi I yelettidayssa nu eroos. ");
INSERT INTO gofRNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Shin ha77i I waanidi xeellidaakko qassi iya ayfiyaa ooni pathidaakko nuuni erokko. Iya oychchite. I bana erida asi gidiya gisho babaa odanaw dandda7ees” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Iya yelidayssati hessa giday Ayhudetas yayyida gishossa. Ays giikko, Ayhudeti, Yesuusi I Kiristtoosa yaagidi markkattiya asi de7ikko he uraa Ayhude Woosa Keethafe hilanaw koyrottidi zore qachchidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Iya yelidayssati, “I bana erida asi; iya oychchite” yaagiday hessassa. ");
INSERT INTO gofRNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Hessa gisho, qooqe gididi yelettida addiya entti zaari xeegidi, “Tumaa odanaw Xoossan caaqqa; ha addey nagaranchcho gideyssa nu eroos” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Addey zaaridi, “I nagaranchcho gidin, gidonna ixxin ta erikke. Taani qooqe gideyssanne ha77i xeelleyssa he issibaa erays” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Entti zaaridi, “I new ay oothidee? I ne ayfiyaa waati pathidee?” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","I enttako, “Taani hinttew odas, shin si7ibeekketa. Ays zaari si7anaw koyeetii? Hintteka iya tamaare gidanaw koyeetiyye?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Entti iya cayidi, “Ne he uraa tamaare gida; nuuni Muse tamaare. ");
INSERT INTO gofRNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Xoossay Muses odidayssa nuuni eroos, shin ha uray I awuppe yidaakkoka nu erokko” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Addey enttako, “I awuppe yidaakko hintte eronayssi malaalisiyabaa, shin I ta ayfiyaa pathis. ");
INSERT INTO gofRNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Xoossaa bonchcheyssanne I koyabaa oothiya uraa Xoossay si7eesippe attin nagaranchchota si7enna. ");
INSERT INTO gofRNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Saloy sa7i medhettosappe qooqe gididi yelettida asa ayfe pathiday oonikka baawa. ");
INSERT INTO gofRNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ha addey Xoossafe kiitettiboonnabaa gidiyakko issibaakka oothanaw dandda7enna” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Entti zaaridi, “Neeni nagaran yelettada diccidayssi nuna tamaarssanaw koyay?” yaagidosona. Iya Ayhude Woosa Keethafe hilidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesuusi entti addiya kessidayssa si7ida wode iya demmidi, “Asa Na7aa ammanay?” yaagidi oychchis. ");
INSERT INTO gofRNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Addey Yesuusakko, “Godaw, taani iya ammanana mela I oonee? Taw odarkkii?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yesuusi addiyako, “Neeni iya be7adasa; ha neera odetteyssi iya” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Addey zaaridi, “Godaw, ammanays” yaagidi Yesuusas goynnis. ");
INSERT INTO gofRNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yesuusi, “Qooqeti xeellana melanne xeelleyssati qooqana mela taani pirddanaw ha alamiya yas” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Iyara de7iya guutha Farisaaweti hessa si7idi, “Nu qooqeyye?” yaagidi oychchidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesuusi, “Hintte qooqe gidiyakko hinttew nagara gidenna. Shin ha77i hintte xeellos giya gisho hinttee, hintte nagaran de7eeta” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesuusi, “Taani hinttew tuma odays; dorssa girbbe giddo penggera gidonna harasoora geliya oonikka kaysonne pangga. ");
INSERT INTO gofRNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Shin penggera geleyssi dorssata heemmeyssa. ");
INSERT INTO gofRNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Penggiya naageyssi iyaw penggiya dooyees; dorssatikka iya qaala si7oosona. I ba dorssata entta sunthan sunthan xeegees; entta kaalethidi kare kessees. ");
INSERT INTO gofRNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","I bayssata kare kessidaappe guye entta sinthan hamuttees. Entti iya qaala eriya gisho iya kaalloosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Hara uraa qaala entti eronna gisho iyappe baqatoosonappe attin iya geedo kaallokona” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesuusi enttaw ha leemisuwa odis, shin I ay gidaakko entti akeekibookkona. ");
INSERT INTO gofRNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Zaaridi Yesuusi enttako, “Taani hinttew tuma odays; taani dorssatas pengge. ");
INSERT INTO gofRNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Taappe sinthe yida ubbay kaysonne pangga, shin dorssati entta si7ibookkona. ");
INSERT INTO gofRNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Penggey tana; ta baggara geliya oonikka attana. I ta baggara gelananne keyana; lo77o heemettiya bessi demmana. ");
INSERT INTO gofRNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Kaysoy kaysotanaw, shukkanawunne dhayssanaw yeesippe attin harabaas yeenna. Taani enttaw de7oy daana melanne kumidi palahana mela yas. ");
INSERT INTO gofRNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Taani lo77o henthanchcho; lo77o henthanchchoy ba dorssata gisho ba shemppuwa aathi immees. ");
INSERT INTO gofRNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Kera heemmiya asi dorssata godanne henthanchcho gidonna gisho suudhumey yaa wode be7idi dorssata aggidi bees. Hessa gisho, suudhumey dorssata oykkidi laallees. ");
INSERT INTO gofRNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Kera heemmeyssi miishes heemmiya gishonne dorssatabay iya qofisonna gisho dorssata aggidi baqatees. ");
INSERT INTO gofRNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“Taani lo77o henthanchcho. Ta Aaway tana ereyssada taanikka ta Aawa erays. Hessadakka, taani ta dorssata erays; ta dorssatikka tana eroosona. Taani ta dorssata gisho ta shemppuwa aatha immays. ");
INSERT INTO gofRNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ha wudiyan baynna hara dorssati taw de7oosona. Taani enttaka ehanaw bessees. Entti ta qaala si7ana; entti issi wude gidana; henthanchchoykka issuwa. ");
INSERT INTO gofRNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Taani ta shemppuwa aatha immada zaara ekkiya gisho ta Aaway tana dosees. ");
INSERT INTO gofRNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ta dosada ta shemppuwa aatha immaysippe attin taappe oonikka ekkenna. Ta ta shemppuwa aatha immanawunne zaara ekkanaw maati taw de7ees. Taani oothana mela ta Aaway tana kiittidayssi hayssa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Hessa I gida gisho Ayhudeta giddon qassika shaaketethi medhettis. ");
INSERT INTO gofRNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Enttafe dariya baggay, “Iyan tuna ayyaani de7ees! I gooyees! I giyabaa ays si7eeti?” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Harati qassi, “Xalahey oykkida asi hayssada odettenna. Tuna ayyaani qooqe ayfe xeelisanaw dandda7iyye?” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Yerusalaamen Xoossa Keetha anjjisida gallasata bonchchiya baaley gakkis; he wode sa7i balggo. ");
INSERT INTO gofRNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yesuusi Xoossa Keethan Solomone baaranddan simerettees. ");
INSERT INTO gofRNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ayhudeti Yesuusa yuushon shiiqi eqqidi, “Neeni nuna awude gakkanaw sidhera wothanee? Neeni Kiristtoosa gidikko ane nuus geeshshada oda” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesuusi zaaridi enttako, “Taani hinttew odas; shin tana ammanekketa. Taani ta Aaway taw immida maatan oothiya oosoy tabaa markkattees. ");
INSERT INTO gofRNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Shin taani hinttew odidayssada hintte ta dorsse gidonna gisho ammanekketa. ");
INSERT INTO gofRNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ta dorssati ta qaalaa si7oosona. Taani entta erays; enttika tana kaalloosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Taani enttaw merinaa de7uwa immays; entti ubbarakka dhayokkona. Oonikka ta kusheppe entta bonqi ekkanaw dandda7enna. ");
INSERT INTO gofRNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Entta taw immida ta Aaway ubbaafe aadhdhees Oonikka ta Aawa kusheppe entta bonqi ekkanaw dandda7enna. ");
INSERT INTO gofRNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Tanne ta Aaway issino” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ayhudeti Yesuusa caddanaw qassika shuchchi denthidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yesuusi enttako, “Taani oothana mela ta Aaway taw immida daro lo77o oosota hinttena ootha bessas. Hessatappe awussa gisho tana shuchchan caddanaw koyeetii?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ayhudeti zaaridi, “Nuuni nena ne lo77o ooso gisho shuchchan caddanaw koyokko. Shin neeni Xoossaa cayaa gishonne ase gidashe ne nena Xoosse giya gishossa” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yesuusi zaaridi, “Geeshsha Maxaafan Xoossay, ‘Hintte xoossata’ gidayssi xaafettibeenne? ");
INSERT INTO gofRNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Geeshsha Maxaafay merinaw laamettenna. Xoossay ba qaala immida asata, ‘xoossata’ gidi xeegikko, ");
INSERT INTO gofRNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Aaway dooridi ha alamiya kiittida tana Xoossa Na7aa waattidi ‘Xoossaa cayaasa’ yaageeti? ");
INSERT INTO gofRNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Taani ta Aaway ootheyssa oothonna ixxiko tana ammanoppite. ");
INSERT INTO gofRNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Shin taani oothiyabaa gidikko hintte tana ammanonna ixxikokka, ta Aaway tanan de7eyssanne takka ta Aawan de7eyssa hintte erana mela ta oosuwa ammanite” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Qassika entti iya oykkanaw koyidosona, shin I enttafe kessi ekkis. ");
INSERT INTO gofRNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Yohaannisi kase xammaqiya bessaa, Yorddaanose Shaafappe hefinthi Yesuusi pinnidi yan de7is. ");
INSERT INTO gofRNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Daro asay Yesuusakko yidi, “Yohaannisi malaata oothibeenna, shin I ha addiyabaa odidabay ubbay tuma” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Yan daro asay Yesuusa ammanidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Bitaaniya gutan Alaazara giya issi addey harggettis. Bitaaney Mayraamanne I michchiya Martta de7iya guta. ");
INSERT INTO gofRNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mayraama Godaa tohuwa shitto tiyada ba binaanan iya tohuwa quchchidaaro. Harggettiday I ishaa Alaazara. ");
INSERT INTO gofRNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Hessa gisho, michcheti, “Godaw, ne doseyssi harggettis” gidi Yesuusakko kiittidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yesuusi hessa si7ida wode “Ha harggey, Xoossaynne iya Na7ay bonchchettana melappe attin hayqos gathiya hargge gidenna” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesuusi Martta, I michchiwunne Alaazara dosees. ");
INSERT INTO gofRNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Shin Alaazari harggidayssa Yesuusi si7idi ba de7iya bessan nam77u gallas gam77is. ");
INSERT INTO gofRNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Hessafe guye, Yesuusi ba tamaaretakko, “Zaaridi Yihuda biittaa boos” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Iya tamaareti zaaridi, “Asttamaariyaw, guutha wodeppe kase Ayhudeti nena shuchchan caddidi wodhanaw koyidosona; ha77ika yaa baanee?” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yesuusi, “Issi gallasan tammanne nam77u saatey de7ees gidenneyye? Gallas hamuttiya asi ha alamiya poo7uwa be7iya gisho dhubettenna. ");
INSERT INTO gofRNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Shin qamma hamuttiya oonikka poo7oy baynna gisho dhubettees” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yesuusi hessa gidaappe guye enttako, “Nu dosiya Alaazari dhiskkis, shin iya denthanaw taani baana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Iya tamaareti zaaridi, “Godaw, I dhiskkidabaa gidikko iyaw lo77ana” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yesuusi Alaazari hayqqidayssa odis, shin enttaw coo dhiskko daanis. ");
INSERT INTO gofRNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Hessa gisho, Yesuusi geeshshidi enttako, “Alaazari hayqqis. ");
INSERT INTO gofRNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Hintte ammanana mela taani he bessan de7onnayssas hintte gisho ufayttays. Ane yedhdhite; iyaakko boos” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Hessafe guye, Didimoosa geetettiya Toomasi ba lagge tamaaretakko, “Asttamaariyara hayqqanaw nukka boos” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yesuusi gakkiya wode Alaazari moogettin oyddu gallas gidis. ");
INSERT INTO gofRNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Bitaaney Yerusalaameppe heedzu kilo mitire mela haakkees. ");
INSERT INTO gofRNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Daro Ayhudeti Marttanne Mayraamo entta ishay hayqqidayssas minthethanaw yidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Martta Yesuusi yidayssa si7ada iya mokkanaw keyasu, shin Mayraama son attasu. ");
INSERT INTO gofRNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Martta Yesuusakko, “Godaw, neeni hayssan de7idabaa gidiyakko ta ishay hayqqenna. ");
INSERT INTO gofRNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Shin ha77i gidikkoka neeni woossiyabaa Xoossay new immanayssa taani erays” yaagasu. ");
INSERT INTO gofRNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yesuusi, “Ne ishay hayqoppe denddana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Martta iyaakko, “Wurssetha gallas I hayqoppe denddanayssa erays” yaagasu. ");
INSERT INTO gofRNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yesuusi iikko, “Taani denddonne de7o; tana ammaniya oonikka hayqqikokka de7on daana. ");
INSERT INTO gofRNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Qassi de7on de7eynne tana ammaniyaa oonikka hayqqenna. Hessa neeni ammanay?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Martta zaarada, “Godaw, ee taani ammanays! Neeni Xoossaa Na7aa, alamiya yaanaw de7iya Kiristtoosa gideyssa taani ammanays” yaagasu. ");
INSERT INTO gofRNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Martta hessa gidaappe guye, bada ba michchiw geeman xeegada, “Asttamaarey yidi nena koyees” yaagasu. ");
INSERT INTO gofRNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mayraama hessa si7ida wode ellesa dendda eqqada Yesuusakko basu. ");
INSERT INTO gofRNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","He wode Yesuusi Marttara gahettida bessan de7ees; buroo gutaa gakkibeenna. ");
INSERT INTO gofRNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Mayraamo minthethishe iira son de7iya Ayhudeti, iya dendda eqqada ellesada kare keyidayssa be7idi, duufo bada yeekkanaw haniya daanin iyo kaallidi keyidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mayraama Yesuusi de7iyasuwa bada iya be7ida wode iya tohuwa bolla kunddada, “Godaw, neeni hayssan de7idabaa gidiyakko ta ishay hayqqennashin” yaagasu. ");
INSERT INTO gofRNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yesuusi Mayraamanne iira de7iya, Ayhudeti yeekkeyssa be7idi, ba wozanan daro seelettidi, ");
INSERT INTO gofRNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","“Awun moogidetii?” yaagidi oychchin, “Godaw, yada be7a” yaagidi zaaridosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yesuusi afuxis. ");
INSERT INTO gofRNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Hessa gisho, Ayhudeti, “I Alaazara ay mela dosiyakko be7ite” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Shin enttafe issoti issoti, “Hayssi qooqiya xeelisidayssi ha addey hayqqonna mela oothanaw dandda7eneshin?” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Qassika Yesuusi seelettidi, Alaazari moogettida duufuwa bis. He duufoy shuchchan gorddettida gonggolo. ");
INSERT INTO gofRNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yesuusi, “Shuchchaa denthite” yaagidi kiittis. Martta, “Godaw, I hayqqosappe oyddu gallas gidida gisho ha77i xinqqana” yaagasu. ");
INSERT INTO gofRNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yesuusi Marttako, “Ne ammaniyabaa gidikko Xoossaa bonchchuwa be7anayssa taani new odabiikkinaa?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Entti shuchchaa denthin Yesuusi salo pude xeellidi, “Aawaw, tana ne si7ida gisho nena galatays. ");
INSERT INTO gofRNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ne ubba wode tana si7eyssa taani erays. Shin hayssan eqqida asay neeni tana kiittidayssa ammanana mela taani entta gisho hayssa gays” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Yesuusi hessa gidaappe guye, ba qaala dhoqqu oothidi, “Alaazara, haa keya!” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Hayqqida addey ziidhettida mela kusheynne tohoy shalon qashettidi de7ishin iya ayfe karey goozettida mela duufuwappe keyis. Yesuusi entta, “Birshshite! Bo giite!” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Hessa gisho, Mayraamikko yida Ayhudetappe daroti Yesuusi oothidayssa be7idi iya ammanidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Shin enttafe issoti issoti Farisaawetakko bidi Yesuusi oothidayssa enttaw odidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Hessafe guye, kahine halaqatinne Farisaaweti shangguwa shiishidi, “Ha addey daro malaatata oothiya gisho nu ay oothinoo? ");
INSERT INTO gofRNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nuuni iya si77i gidi aggiko asa ubbay iya ammanana. Qassi Roome biittaa asati yidi nu Xoossa Keethanne nu deriya dhayssana” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Enttafe issoy Qayyaafa geyssi, he laythi kahine halaqa gididayssi, “Hintte aykkoka erekketa! ");
INSERT INTO gofRNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Asay ubbay dhayeyssafe asa ubbaa gisho issi asi hayqqeyssi lo77o gideyssa erekketii?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","I hessa baappe gibeenna. Shin he laythi kahine halaqa gidiya gisho Yesuusi Ayhude asaa gisho hayqqanaw besseyssa tinbbite odis. ");
INSERT INTO gofRNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Qassi Yesuusi Ayhude asaa xalaalas gidonnashin laalettidi de7iya Xoossaa asa ubbaa issife shiishanawunne issi asi oothanaw hayqqana. ");
INSERT INTO gofRNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","He gallasappe doomidi entti iya wodhanaw maqettidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Hessa gisho, Yesuusi Ayhudeta giddon qonccen simerettibeenna. Shin bazzo biitta matan de7iya Efreeme gutaa bis. Ba tamaaretara he bessan gam77is. ");
INSERT INTO gofRNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ayhudeti bonchchiya Paasika gallasay matis. Qassi daro asay banttana geeshshanaw Paasika bonchchiya gallasay gakkanaappe sinthe he biittaafe Yerusalaame bidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Entti Xoossa Keethan eqqidi Yesuusa yuussaa naagiya gisho “Ay qoppeetii? Yesuusi baaliya bonchchanaw yeenne?” yaagidi issoy issuwa oychchidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Kahine halaqatinne Farisaaweti Yesuusa oykkanaw, I de7iyasuwa eriya oonikka banttaw odana mela kiittidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Paasika bonchchiya gallasappe usuppun gallas sinthattidi, Yesuusi hayqoppe denthida Alaazari de7iya gutaa, Bitaaniya bis. ");
INSERT INTO gofRNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","He bessan entti iyaw kaho giigisidosona. Alaazari Yesuusara issife gayta bolla uttidashin Martta enttana mokkawusu. ");
INSERT INTO gofRNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mayraama narddoose giya daro al77o geeshsha shitto ehada Yesuusa tohuwa tiyasu. Ba binaanan iya tohuwa quchchasu; keetha ubbay shitto sawon tongu gis. ");
INSERT INTO gofRNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Shin Yesuusa tamaaretappe issoy, Yesuusa aathi immanayssi, Asqoroota Yihudi, ");
INSERT INTO gofRNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Ays ha shittoy heedzu xeetu dinaaren bayzettidi, miishey manqotas imettenne?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","I kayso gidida gisho hessa gisippe attin manqotas qadhettidi gibeenna. I miishe karxiita oykkeyssa gidiya gisho ubba wode iyappe baw ekkees. ");
INSERT INTO gofRNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yesuusi, “Iya baw de7iyabaa ta moogo gallasaas minjjida gisho iyo aggaagite. ");
INSERT INTO gofRNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Manqoti ubba wode hinttera daana, shin taani ubba wode hinttera de7ikke” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","He wode daro asay Yesuusi Bitaaniyan de7eyssa si7idi yaa bidosona. Entti Yesuusa xalaala gidonnashin I hayqoppe denthida Alaazarakka be7anaw bidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Hessa gisho, kahine halaqati Alaazarakka qassi wodhanaw maqettidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Ays giikko, Alaazara gaason daro Ayhudeti enttana ixxidi Yesuusa ammanoosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Wonttetha gallas Paasika bonchchiya bessaa yida daro asay Yesuusi Yerusalaame beyssa si7idi, ");
INSERT INTO gofRNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Zambba haythi ekkidi iya mokkanaw keyidosona. Bantta qaala dhoqqu oothidi, “Hosaana! Xoossay galatetto! Godaa sunthan yeyssi anjjetto! Xoossay Isra7eele Kawuwa anjjo!” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","15","Geeshsha Maxaafan, “Xiyoone katamaw, babbofa! Hekko, ne Kawoy hare mara bolla uttidi yees” geetettidayssada Yesuusi hare mari demmidi iya toggis. ");
INSERT INTO gofRNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Yesuusa tamaareti hessa kase akeekibookkona. Shin Yesuusi bonchchettidaappe guye entti hessa ubbaa akeekidosona. Hessi ubbay Geeshsha Maxaafay gidayssada hanis. ");
INSERT INTO gofRNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Yesuusi Alaazara duufoppe xeegidi, hayqoppe denthida wode iyara de7iya daro asay Yesuusabaa markkattidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Daro asay iya mokkanaw keyiday, I he malaatata oothidaysssa si7ida gishossa. ");
INSERT INTO gofRNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Hessa gisho, Farisaaweti issoy issuwako, “Nu aykkoka oothanaw dandda7onnayssa be7ite; dere ubbay iya kaallees” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Paasika bonchchiya gallas goynnanaw Yerusalaame bidayssata giddon issi issi Girike asati de7oosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Entti Galiila biittan Beetesayda katamaappe yida Filphoosakko bidi, “Godaw, nuuni Yesuusa be7anaw koyoos” yaagidi woossidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filphoosi bidi Inddiriyasas odin nam77ay bidi, Yesuusas odidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yesuusi enttako, “Asa Na7ay, bonchchettiya wodey gakkis. ");
INSERT INTO gofRNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Taani hinttew tuma odays; issi gistte ayfey biittan wodhdhidi wooqonna ixxiko barkka attees. Shin he gistte ayfey wooqiko daro ayfe ayfees. ");
INSERT INTO gofRNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ba shemppuwa dosiya oonikka dhayssees; ba shemppuwa ha alamiyan ixxiya oonikka merinaa de7os ashshees. ");
INSERT INTO gofRNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Taani de7iyasuwan taara daana mela taw oothanaw koyaa oonikka tana kaallanaw bessees. Taw oothiya oonakka ta Aaway bonchchana. ");
INSERT INTO gofRNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Ha77i ta shemppoy daro un77ettis; yaatin woygo? ‘Ta Aawaw, tana ha saateppe ashsharkkii’ yaago? Akkay, taani yiday waaye ekkanaassa. ");
INSERT INTO gofRNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ta Aawaw, ne sunthaa bonchcha” yaagis. He wode saloppe, “Taani ta sunthaa bonchchas; zaaradakka bonchchana” yaagiya qaalay yis. ");
INSERT INTO gofRNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","He bessan eqqida daro asay he qaala si7idi, “Hessi dada” yaagidosona. Harati qassi, “Kiitanchchoy iyaw odis” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Yesuusi zaaridi enttako, “Ha qaalay hintte gisho yisippe attin ta gisho gidenna. ");
INSERT INTO gofRNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ha alamey pirddettiya wodey ha77i; ha alamiya haareyssi ha77i kare holettana. ");
INSERT INTO gofRNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Qassi taani sa7appe dhoqqu oosettida wode asa ubbaa taakko ehana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","I hessa giday ay mela hayqo hayqqaneekko enttaw qonccisanassa. ");
INSERT INTO gofRNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Daro asay zaaridi, “Nu higgey Kiristtoosi merinaw de7eyssa odees. Yaatin, neeni woygada, ‘Asa Na7ay dhoqqu gaanaw bessees’ gay? ‘I, Asa Na7ay oonee?’ ” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yesuusi, “Poo7oy hinttera guutha wode gam77ana. Hinttew dhumonna mela poo7oy de7ishin, poo7uwan hamuttite. Dhuman hamuttiya asi aw biyakko erenna. ");
INSERT INTO gofRNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Poo7o nayta gidana mela poo7oy de7ishin poo7uwa ammanite” yaagis. Yesuusi hessa odidaappe guye bidi enttafe geemmis. ");
INSERT INTO gofRNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","I hessa mela malaatata entta sinthan oothinkka ammanibookkona. ");
INSERT INTO gofRNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Nabiya Isayaasi, “Godaw, nu markkatethaa ooni ammanidee? Goday ba wolqqaa ooddes qonccisidee?” Gidayssi tuma gidana mela entti iya ammanibookkona. ");
INSERT INTO gofRNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","40","Qassika Isayaasi, “Entta ayfey xeellonna mela, entta wozanay akeekonna mela, entti Xoossaakko simmin, I entta pathonna mela, Xoossay entta ayfiyaa qooqisis. Entta wozanaa minthis” gida gisho entti ammananaw dandda7ibookkona. ");
INSERT INTO gofRNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isayaasi hessa giday, Yesuusa bonchchuwa be7ida gishonne iyabaa odida gishossa. ");
INSERT INTO gofRNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Gidikkoka, Ayhudeta halaqatappekka daroti Yesuusa ammanidosona. Shin Farisaaweti banttana Ayhudeta Woosa Keethafe kessoosona gidi yayyida gisho ammanida gidi qonccen markkattibookkona. ");
INSERT INTO gofRNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Hessa entti oothiday, Xoossan erettanayssafe aathidi asan erettanayssa dosida gishossa. ");
INSERT INTO gofRNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yesuusi ba qaalaa dhoqqu oothidi, “Tana ammaniyaa oonikka tana kiittidaysaka ammaneesppe attin ta xalaala ammanenna. ");
INSERT INTO gofRNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Tana be7iya oonikka tana kiittidaysaka be7ees. ");
INSERT INTO gofRNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Tana ammaniyaa ubbay dhuman doonna mela taani poo7o gidada alamiya yas. ");
INSERT INTO gofRNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ta qaalaa si7idi kiitettonna oonakka taani pirddike. Ays giikko, taani alamiya ashshanaw yasippe attin pirddanaw yabiikke. ");
INSERT INTO gofRNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Tana ixxeyssanne ta qaalaa ekkonna oonakka pirddeyssi de7ees. Taani odida qaalay wurssetha gallas he uraa pirddana. ");
INSERT INTO gofRNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ays giikko, taani hessa taappe odikke, shin tana kiittida ta Aaway taani gaanayssanne odanayssa kiittis. ");
INSERT INTO gofRNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Qassi iya kiitay merinaa de7o gideyssa taani erays. Hessa gisho, taani odeyssi ta Aaway tana oda gidayssa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Paasika bonchchiya gallasay gakkanaappe sinthattidi ha alamiya aggidi Aawakko biya wodey gakkidayssa Yesuusi eris. Ha alamiyan de7iya bayssata ubba wode dosis; wurssethi gakkanawukka entta dosis. ");
INSERT INTO gofRNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Yesuusaranne iya tamaaretara issife kaho moosona. Hessafe kase Xalahey Simoona na7aa Asqoroota Yihudi Yesuusa aathi immanaada iya wozanan iita qofa wothis. ");
INSERT INTO gofRNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesuusi Aaway ubbabaa iya kushen wothidayssa, I Xoossaa matappe yidayssanne simmidi iyaakko baanayssa eris. ");
INSERT INTO gofRNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Yesuusi gaytaa bollafe denddidi bolla bagga ma7uwa qaari wothidi, pooxa ekkidi ba xeessan marxxafis. ");
INSERT INTO gofRNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Hessafe guye, haathe meechcha miishen tigidi, ba tamaareta tohuwa meeccis; qassi ba xeessan danccida pooxan quchchis. ");
INSERT INTO gofRNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Yesuusi Simoon Phexiroosakko yaa wode Phexiroosi, “Godaw, ne ta tohuwa meeccanee?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yesuusi zaaridi iyaakko, “Taani ootheyssa ne ha77i erakka, shin guyeppe akeekana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Yaatin, Phexiroosi, “Ne ta tohuwa ubbarakka meeccaka” yaagis. Yesuusi iyaakko, “Taani ne tohuwa meecconna ixxiko newunne taw issifetethi baawa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Phexiroosi Yesuusakko, “Godaw, yaatikko, ta tohuwa xalaala gidonnashin ta kushiyanne ta huu7iya meecca” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesuusi zaaridi, “Bolla meecettida oonikka tohoppe harabaa meecettanaw koshshenna; iyaw ubbasoy geeshshi. Hintte geeshshi, shin ubbay geeshshi gidekketa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yesuusi bana aathi immana uray ooneekko eriya gisho “Hintte ubbay geeshshi gidekketa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Entta tohuwa meeccidaappe guye Yesuusi ba ma7uwa zaari ma77is. Simmi gaytaa bolla uttidi enttako, “Taani hinttew oothidayssa akeekeetii? ");
INSERT INTO gofRNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Hintte tana asttamaarenne Goda geeta; taani hintte geyssa gidiya gisho lo77o gideta. ");
INSERT INTO gofRNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Taani hinttew Godanne asttamaare gidashe hintte tohuwa meeccikko hintteka issoy issuwas hessada oothanaw bessees. ");
INSERT INTO gofRNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Hiza, taani hinttew oothidayssada hintteka oothana mela hinttew leemiso gidas. ");
INSERT INTO gofRNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Taani hinttew tuma odays; aylley ba godaappe, kiitettidayssi kiittidayssafe aadhdhenna. ");
INSERT INTO gofRNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Hintte hessa eridi oothiyabaa gidikko anjjettidayssata. ");
INSERT INTO gofRNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Taani hinttena ubbaa giikke; taani dooridayssata erays. Shin Geeshsha Maxaafan, ‘Ta barssidayssi ta kushiya saxxis’ geetettidayssi tuma gidanaw bessees. ");
INSERT INTO gofRNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Taani Tana Gideyssa hintte ammanana mela hessi hananaappe sinthatada hinttew odays. ");
INSERT INTO gofRNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Taani hinttew tuma odays; taani kiittida oonakka mokkiya uray tana mokkees. Tana mokkiya oonikka tana kiittidayssa mokkees” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesuusi hessa odidaappe guye ba wozanan daro un77ettidi, “Taani hinttew tuma odays; tana hinttefe issoy aathi immana” gidi qonccisidi odis. ");
INSERT INTO gofRNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","I ooddebaa odiyakko iya tamaaretas erettonna ixxin issoy issuwa xeellidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Iya tamaaretappe issoy, Yesuusi doseyssi, Yesuusa matan uttis. ");
INSERT INTO gofRNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Hessa gisho, Simoon Phexiroosi iya qam77ottidi, “I oona giyakko ane oychcha” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Hessa gisho, he tamaarey Yesuusakko shiiqidi haythan, “Godaw, I oonee?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yesuusi zaaridi, “Taani uythaa woxen tushada barsseyssa” yaagis. Qassi uythaa menthi ekkidi, woxen tushidi, Simoona na7aa Asqoroota Yihuda barssis. ");
INSERT INTO gofRNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Yihudi uythaa baaridaappe guye Xalahey sohuwara Yihudan gelis. Yesuusi iyaakko, “Neeni oothanaw qoppidabaa ellesada ootha” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Shin gaytaa bolla uttidayssatappe oonikka Yesuusi hessa ays iyaakko gidaakko eribeenna. ");
INSERT INTO gofRNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Yihudi miishe oykkiya gisho iya tamaaretappe issoti issoti Yesuusi iya, “Paasika bonchchiya gallasaas banttaw koshshiyabaa shamma woykko manqotas muxaata imma gis” yaagidi qoppidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Yihudi uythaa baarida mela sohuwara kare keyis. He wode sa7i qamma. ");
INSERT INTO gofRNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yihudi kare keyidaappe guye, Yesuusi, “Ha77i Asa Na7ay bonchchettis; Xoossaykka iya baggara bonchchettis. ");
INSERT INTO gofRNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Xoossay iya baggara bonchchetiko I ba huu7en Asa Na7aa bonchchana; qassi I hessa ellesidi oothana. ");
INSERT INTO gofRNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ta nayto, taani hinttera daro wode gam77ike. Hintte tana koyana, shin taani Ayhudetas odidayssa mela, ‘Hintte taani biyasuwa baanaw dandda7ekketa.’ ");
INSERT INTO gofRNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Taani hinttew immiya ooratha kiitay hayssa; issoy issuwa dosite. Taani hinttena dosidayssada hintte issoy issuwa dosanaw bessees. ");
INSERT INTO gofRNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Hintte issoy issuwara dosettiko hintte ta tamaare gideyssa asa ubbay erana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simoon Phexiroosi Yesuusakko, “Godaw, neeni aw bay?” yaagis. Yesuusi zaaridi, “Taani biyasuwa neeni ha77i kaallanaw dandda7akka, shin guyeppe tana kaallana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Phexiroosi, “Godaw, taani nena ha77i kaallanaw ays dandda7ikkinaa? Taani ne gisho hayqqanawukka giiga uttas” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yesuusi zaaridi, “Ta gisho hayqqanaw tuma giiga uttadii? Taani new tuma odays; kuttoy waassanaappe sinthe neeni tana heedzu toho kaddana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yesuusi ba tamaaretakko, “Hintte wozanay un77ettofo, Xoossaa ammanite, tanakka ammanite. ");
INSERT INTO gofRNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ta Aawa keethan daro bessi de7ees. Taani hinttew besse giigisanaw bays. Hessa gidonnaako taani hinttew odikkeshin. ");
INSERT INTO gofRNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Taani bada besse giigisidaappe guye taani de7iyasuwan hintte daana mela simma yada hinttena taakko efana. ");
INSERT INTO gofRNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Hintte taani biyasuwa efiya ogiya ereeta” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Yaatin, Toomasi, “Godaw, neeni biyasuwa nuuni erokko; ogiya waattidi eranaw dandda7anee?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesuusi zaaridi, “Ogey, tumaynne de7oy tana. Ta baggara gidonna ixxiko oonikka ta Aawakko baanaw dandda7enna. ");
INSERT INTO gofRNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Hintte tana eriyabaa gidiyakko, ta Aawakka erana. Shin hizappe doomidi hintte iya ereetanne iya be7ideta” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filphoosi Yesuusakko, “Godaw, Aawa nuna bessa; hessi nuus gidana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yesuusi zaaridi, “Taani hayssa mela wode hinttera de7inkka tana erikkii? Tana be7ida uray Aawakka be7is. Yaatin, neeni woygada, ‘Aawa nuna bessa’ gay? ");
INSERT INTO gofRNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Taani Aawara issino gideyssanne Aawaykka taara issino gideyssa neeni ammanikkiyye? Taani hinttew odiya qaala taani taappe odikke, shin tanan de7iya Aaway ba oosuwa oothees. ");
INSERT INTO gofRNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Taani Aawan de7eyssanne Aawaykka tanan de7eyssa ammanite. Hessa ammanonna ixxiko ta oothiyabatan tana ammanite. ");
INSERT INTO gofRNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“Taani hinttew tuma odays; tana ammaniyaa uray taani oothiya oosuwappe aadhdhiya ooso oothana. Taani Aawakko biya gisho tana ammaniyaa oonikka hayssafe aadhdhiya ooso oothana. ");
INSERT INTO gofRNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Aaway Na7aa baggara bonchchettana mela ta sunthan hintte woossiya ubbaa ta hinttew oothana. ");
INSERT INTO gofRNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ta sunthan aybibaakka hintte oychchiko ta hinttew oothana. ");
INSERT INTO gofRNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Hintte tana dosikko ta kiitaa naagana. ");
INSERT INTO gofRNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Taani Aawa woossana; hinttera merinaw daana mela minthetheyssa hinttew immana. ");
INSERT INTO gofRNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","He Ayyaanay Xoossaa tumaa qonccisees. Ha alamiya asay iya be7onna gishonne eronna gisho iya ekkanaw dandda7okkona. Shin I hinttera de7iya gishonne hintte giddon daana gisho hintte iya ereeta. ");
INSERT INTO gofRNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Taani hinttena aaya aawu baynna na7ada hintte xalaala aggike; simmada hintteko yaana. ");
INSERT INTO gofRNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Guutha wodeppe guye alamey tana zaari be7enna, shin hintte be7ana. Taani de7on de7iya gisho hintteka de7on de7ana. ");
INSERT INTO gofRNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Taani ta Aawan, hintte tanan, qassi taani hinttenan de7eyssa hintte he gallas erana. ");
INSERT INTO gofRNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Ta kiitaa ekkidi naagey tana dosees. Tana doseyssa ta Aawaykka dosees; taanikka iya dosays; taani iyaw qonccana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Asqoroota Yihuda gidonna Yihudi Yesuusakko, “Godaw, neeni waatada alamiyas gidonnashin nuus nena qonccisanee?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yesuusi zaaridi, “Tana dosiya oonikka ta qaalas kiitettana. Ta Aaway iya dosana. Qassi ta Aawaynne taani iyaakko yidi iyara daana. ");
INSERT INTO gofRNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Tana dosonna oonikka ta qaalas kiitettenna. Hintte si7iya qaalay tana kiittida Aawabaape attin tabaa gidenna. ");
INSERT INTO gofRNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Taani hinttera ha77i de7ashe hessa hinttew odas. ");
INSERT INTO gofRNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Shin Aaway ta sunthan kiittana minthethiya Geeshsha Ayyaanay, hinttena ubbabaa tamaarssana. Taani hinttew odida ubbaa I hinttena hassayisana. ");
INSERT INTO gofRNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Sarotethi hinttew immana. Taani ta sarotethaa hinttew immana. Ta immiya sarotethay alamey immiya sarotethaa mela gidenna. Hessa gisho, un77ettofite, yayyofite. ");
INSERT INTO gofRNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","‘Taani baana, shin simmada hintteko yaana’ gidayssa si7ideta. Hintte tana tuma dosiyabaa gidiyakko ta Aaway taappe aadhdhiya gisho taani iyaakko beyssan hintte ufayttana. ");
INSERT INTO gofRNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Hessi haniya wode hintte ammanana mela hessi hanonna de7ishin sinthatada taani hinttew odas. ");
INSERT INTO gofRNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","“Ha alamiya haareyssi yaa gisho hizappe guye hinttera daro odettike. Tana I aykkoka oothanaw dandda7enna. ");
INSERT INTO gofRNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Shin taani Aawa doseyssa alamey erana mela ta Aaway tana kiittidayssa ubbaa oothays. Denddite; hayssafe boos. ");
INSERT INTO gofRNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Taani woyniya tuma ubbaa. Goshshanchchoy ta Aawa. ");
INSERT INTO gofRNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ta bolla de7iya ayfe ayfonna tashiya ubbaa I karees. Ayfiyaa tashiya kaseyssafe aadhdhi ayfana mela he tashiya I giigisana. ");
INSERT INTO gofRNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Taani hinttew odida qaala gisho hintte geeshshi. ");
INSERT INTO gofRNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Tanan de7ite; taanikka hinttenan de7ana. Woyniya tashey ubbaara de7onna ixxiko he tashey barkka ayfe ayfanaw dandda7enna. Hessadakka, hintteka tanan de7onna ixxiko ayfe ayfanaw dandda7ekketa. ");
INSERT INTO gofRNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Taani woyniya ubbaa; hintte tasheta. Tanan de7eysinne taani iyan de7eyssi, I daro ayfe ayfana. Ta baynna hintte xalaala aykkoka oothanaw dandda7ekketa. ");
INSERT INTO gofRNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Tanan doonna uray tasheda karen yegittidi melana. Hessa mela tasheti shiiqidi taman yeggettana, xuugettana. ");
INSERT INTO gofRNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Hintte tanan de7ikko, ta qaalaykka hinttenan de7ikko, hintte koyabay aybaa gidikkoka woossite; hintte ekkana. ");
INSERT INTO gofRNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Hintte daro ayfe ayfiyaa ta tamaare gidikko, hessan ta Aaway bonchchettana. ");
INSERT INTO gofRNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Aaway tana doseyssada taanikka hinttena dosays; ta siiquwan de7ite. ");
INSERT INTO gofRNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Taani ta Aawa kiitaa naagada iya siiquwan de7idayssada hintteka ta kiitaa naagikko ta siiquwan daana. ");
INSERT INTO gofRNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Ta ufayssay hinttenan gidana melanne hintte ufayssay polo gidana mela taani hinttew hessa odas. ");
INSERT INTO gofRNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ta kiitay hayssa; taani hinttena dosidayssada hintteka issoy issuwa dosite. ");
INSERT INTO gofRNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ba shemppuwa ba laggiyas aathidi immeyssafe aadhdhiya gita siiqoy baawa. ");
INSERT INTO gofRNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Taani hinttena kiittidaba ubbaa oothiko hintte dosettidayssata. ");
INSERT INTO gofRNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","“Aylley ba goday oothiyabaa eronna gisho taani hinttena hizappe guye aylleta giikke. Shin ta Aawappe si7ida ubbaa taani hinttew odida gisho hinttena dosettidayssata gas. ");
INSERT INTO gofRNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Taani hinttena doorasippe attin hintte tana dooribeekketa. Hintte bidi dhayonna ayfe ayfana mela taani hinttena shuumas. Yaanikko ta Aaway hintte ta sunthan woossidaba ubbaa immana. ");
INSERT INTO gofRNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ta kiitay hayssa: issoy issuwa dosite. ");
INSERT INTO gofRNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Alamey hinttena ixxiko koyrottidi tana ixxidayssa akeekite. ");
INSERT INTO gofRNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Hintte alamiyabaa gidiyakko alamey babaada hinttena dosana. Shin taani hinttena alameppe doorida gishonne hintte alamiyabaa gidonna gisho alamey hinttena ixxees. ");
INSERT INTO gofRNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","‘Aylley ba godaappe aadhdhenna’ gada taani hinttew odidayssa akeekite. Entti tana gooddidabaa gidikko hinttenakka gooddana. Entti ta qaala naagidabaa gidikko hintte qaalaakka naagana. ");
INSERT INTO gofRNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Shin entti tana kiittidayssa eronna gisho ha ubbaa ta gaason hintte bolla oothana. ");
INSERT INTO gofRNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Taani yada odonnabaa gidiyakko enttaw nagara gidenna. Shin ha77i entti oothida nagaraas gaasoyabay baawa. ");
INSERT INTO gofRNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Tana ixxeyssi ta Aawakka ixxees. ");
INSERT INTO gofRNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Oonikka oothiboonna ooso ta entta giddon oothaboonnabaa gidiyakko enttaw nagara gidonna attana. Shin ha77i entti taani oothida oosuwa be7idi tanakka ta Aawakka ixxidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Shin entta higgiyan, ‘Tana coo ixxidosona’ geetettidi xaafettidayssi polettana mela hessi hanis. ");
INSERT INTO gofRNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Aawappe yaa tumaa qonccisiya Ayyaana ta hinttew kiittana. I hinttena minthethana, tabaa markkattana. ");
INSERT INTO gofRNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Hintteka koyroppe doomidi taara de7iya gisho tabaa markkattana. ");
INSERT INTO gofRNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Taani hessa hintte ammanoy dhayonna mela hinttew odas. ");
INSERT INTO gofRNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Entti hinttena Ayhude Woosa Keethatappe kessi yeddana. Hessadakka, hinttena wodhiya oonikka Xoossi koyabaa oothiya daaniya wodey yaana. ");
INSERT INTO gofRNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Entti hessa hintte bolla oothey tana woykko Aawa eronna gishossa. ");
INSERT INTO gofRNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Shin entti hessa hintte bolla oothiya wodey gakkiya wode taani hinttew odididayssa hintte akeekana mela taani hinttew hayssa odas. “Sinthatada taani hayssa hinttew odonna gam77iday ta hinttera de7iya gishossa. ");
INSERT INTO gofRNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Shin ha77i taani tana kiittidayssako bays; hinttefe oonikka, ‘Awu bay?’ gidi tana oychchey baawa. ");
INSERT INTO gofRNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Shin taani hessa odida gisho hintte wozanan daro azzanoy de7ees. ");
INSERT INTO gofRNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Shin taani hinttew tuma odays; taani biikko hinttew lo77o. Ays giikko, taani boonna ixxiko minthetheyssi hintteko yeenna. Shin taani biikko iya hintteko yeddana. ");
INSERT INTO gofRNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Minthetheyssi yidi, nagarabaa, xillotethabaanne pirddabaa ha alamiya asaa erisana. ");
INSERT INTO gofRNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Nagarabay, asay tana ammanonna gishossa. ");
INSERT INTO gofRNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Xillotethabay, taani Aawakko biya gishonne hintte tana zaari be7onna gishossa. ");
INSERT INTO gofRNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Pirddabay, qassi alamiya haareyssi pirddettida gishossa. ");
INSERT INTO gofRNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Taani hinttew odiyabay darobay de7ees, shin ha77i hinttew gelenna. ");
INSERT INTO gofRNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Tuma Ayyaanay yaa wode hinttena tumatetha ubbaako kaalethana. I si7idabaa odeesippe attin baappe aybibaakka odenna. Qassi sinthafe yaanabaa hinttew I odana. ");
INSERT INTO gofRNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","I taw de7eyssafe ekkidi hinttew odiya gisho I tana bonchchana. ");
INSERT INTO gofRNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Aawas de7iyaba ubbay tabaa; ‘Minthetheyssi taw de7eyssafe ekkidi hinttew odana’ taani giday hessassa. ");
INSERT INTO gofRNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Guutha wodeppe guye tana be7ekketa; qassi guutha wodeppe guye hintte tana be7ana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Iya tamaaretappe issoti issoti bantta giddon, “Guutha wodeppe guye hintte tana be7ekketa; qassi guutha wodeppe guye hintte tana be7ana; qassika taani Aawakko bays guussay woy guussee?” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","“Guutha wodeppe guye geyssi woy guussee? I ay odettiyako nuus erettenna” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Entti bana oychchanaw koyeyssa Yesuusi eridi, “Taani, ‘Guutha wodeppe guye tana be7ekketa; qassi guutha wodeppe guye hintte tana be7ana’ gidayssas hintte issoy issuwa oychcheetii? ");
INSERT INTO gofRNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Taani hinttew tuma odays; hintte yeekkananne afuxana, shin ha alamey ufayttana. Ha77i hintte azzanana, shin hintte azzanoy ufayssan laamettana. ");
INSERT INTO gofRNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Issi maccasiya na7a yelana haniya wode ba yelo wodey gakkida gisho hirggawusu. Shin na7a yelidaappe guye na7i ha alamiyan yelettida ufayssaa gisho ba un77aa dogawusu. ");
INSERT INTO gofRNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Hessadakka, hintteka hintte wozanan azzaneeta, shin taani hinttena zaarada be7ana. Hintte wozanay daro ufayttana; he ufayssaa oonikka hinttefe ekkenna. ");
INSERT INTO gofRNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“He gallas hintte tana aybibaakka woosseketa. Taani hinttew tuma odays; hintte ta sunthan woossiyabaa ubbaa Aaway hinttew immana. ");
INSERT INTO gofRNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ha77i gakkanaw ta sunthan aybibaakka woossibeekketa. Hintte ufayssay polo gidana mela Xoossaa woossite; hintte ekkana. ");
INSERT INTO gofRNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Taani ha77i gakkanaw hinttew leemison odas, hizappe taani leemison odonna wodey yaana. Shin Aawabaa taani hinttew qonccen odana. ");
INSERT INTO gofRNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","He gallas hintte ta sunthan Aawa woossana; hintte gisho taani Aawa woossike. ");
INSERT INTO gofRNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Ays giikko, Aaway ba huu7en hinttena dosees. Hintte tana dosiya gishonne taani Aawa matappe yidayssa ammanida gisho I hinttena dosees. ");
INSERT INTO gofRNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Taani Aawa matappe ha alamiya yas; qassi alamiya aggada Aawakko baana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Iya tamaareti zaaridi, “Hekko, ha77i neeni qonccen odaasa; leemison aykkoka odakka. ");
INSERT INTO gofRNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Neeni ubbabaa ereyssa nuuni ha77i eroos; qassi nena oonikka oychchana mela neeni koyakka. Hessi nuna neeni Xoossafe kiitettidayssa ammanthees” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yaatin, Yesuusi zaaridi enttako, “Ha77i ammaneetii? ");
INSERT INTO gofRNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Hekko, hinttee, hintte soo hintte soo laalettiya wodeynne ta xalaala yeggi aggidi baqatiya wodey yaana; ha77ika yikichchis. Shin Aaway taara de7iya gisho ta ta xalaala gidikke. ");
INSERT INTO gofRNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Hintte taara de7ishe saroy hinttew daana mela taani hessa odas. Alamen de7ishe hintte waayettana. Shin minnite; taani alamiya xoonas” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesuusi hessa odidaappe guye pude salo xeellidi, hayssada yaagis: “Aawaw, saatey gakkis; ne Na7ay nena bonchchana mela neeni ne Na7aa bonchcha. ");
INSERT INTO gofRNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Neeni iyaw immida ubbaas I merinaa de7uwa immana mela asa ubbaa bolla iyaw maata immadasa. ");
INSERT INTO gofRNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Merinaa de7oy, nena, issi tuma Xoossaanne ne kiittida Yesuus Kiristtoosa ero. ");
INSERT INTO gofRNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Neeni ta oothana mela immida oosuwa polada nena sa7an bonchchas. ");
INSERT INTO gofRNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ha77ika, Aawaw, alamey medhettanaappe sinthe ne matan taw de7iya bonchchuwan tana bonchcha. ");
INSERT INTO gofRNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Alamiya asaappe neeni taw immidayssata nena erisas. Entti neyssata; neeni entta taw immadasa. Entti ne qaalaskka kiitettidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Neeni taw immida ubbabay neeppe yidayssa entti ha77i eroosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Neeni taw immida qaala taani enttaw immas; enttika he qaala ekkidosona. Taani ne matappe yidayssi tuma gideyssa eridi neeni tana kiittidaysaka ammanidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Taani enttaw woossays. Entti neyssata gidiya gisho neeni taw immida asaas woossaysippe attin alamiyas woossike. ");
INSERT INTO gofRNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Taw de7iya ubbabay nebaa; new de7iya ubbayka tabaa. Taani entta baggara bonchchettas. ");
INSERT INTO gofRNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Taani hizappe guye alamen de7ikke; entti alamen de7oosona. Taani ha77i neekko bays. Geeshsha Aawaw, ha neeni taw immidayssati neeranne taara issino gididayssada entti issino gidana mela entta ne taw immida ne sunthan naaga. ");
INSERT INTO gofRNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Taani enttara sa7an de7ashe, ne taw immida ne sunthaa wolqqan entta naagas. Geeshsha Maxaafay gidayssi polettana mela dhayoy bessiya uraappe attin enttafe hari oonikka dhayibeenna. ");
INSERT INTO gofRNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Ha77i taani neekko bays. Ta ufayssay entta wozanan polo gidana mela hayssa taani alamen de7ashe odays. ");
INSERT INTO gofRNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Taani enttaw ne qaala immas. Taani alameppe gidonnayssada, enttika alameppe gidonna gisho alamey entta ixxis. ");
INSERT INTO gofRNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Neeni Xalaheppe entta naagana melappe attin alameppe kessana mela woossike. ");
INSERT INTO gofRNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Taani alameppe gidonnayssada enttika alameppe gidokkona. ");
INSERT INTO gofRNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Neeni ne tumatethan entta nebaa ootha; ne qaalaykka tuma. ");
INSERT INTO gofRNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Neeni tana alamiya kiittidayssada taanikka entta alamiya kiittas. ");
INSERT INTO gofRNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Qassi entti tuma nebaa gidana mela entta gisho taani ta huu7iya new immays. ");
INSERT INTO gofRNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Taani entta xalaalas gidonnashin entti qaala odin, tana ammananayssataskka woossays. ");
INSERT INTO gofRNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Entti ubbay issino gidana mela taani woossays. Aawaw, ne tanan de7eyssada, qassi ta nenan de7eyssada entti nunan daana mela woossays. He wode neeni tana kiittidayssa alamey ammanana. ");
INSERT INTO gofRNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Neeninne taani issino gideyssada, entti issino gidana mela, neeni tana bonchchidayssada, taanikka entta bonchchas. ");
INSERT INTO gofRNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Taani enttan, neeni tanan de7eyssada entti polo issino gidana mela nena woossays. Hessika, ne tana kiittidayssanne ne tana dosida dosuwan entta dosidayssa alamey eran melassa. ");
INSERT INTO gofRNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Aawaw, neeni taw immidayssati taani de7iyasuwan taara daana mela koyays. Alamey medhettanaappe sinthe neeni tana dosida gisho taw immida ta bonchchuwa entti be7ana. ");
INSERT INTO gofRNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Geeshsha Aawaw, alamey nena erenna, shin taani erays. Qassi neeni tana kiittidayssa hayssati eroosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Neeni tana siiqida siiqoy enttanan daana mela, qassi taani enttanan gidana mela, taani ne sunthaa entta erisas; sinthaskka erisana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesuusi woossaa onggidaappe guye ba tamaaretara Qediroona zanggaara pinnidi, he bessan de7iya atakilttiya giddo gelidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yesuusi ubba wode ba tamaaretara yan shiiqiya gisho Yesuusa aathi immida Yihudi he bessaa erees. ");
INSERT INTO gofRNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Hessa gisho, Yihudi paanose, xomppe, tooranne gonddalle oykkida daro wotaaddareta, kahine halaqatinne Farisaaweti kiittida Xoossa Keetha naagiya pooliseta kaalethi ekkidi, he bessaa bis. ");
INSERT INTO gofRNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesuusi bana gakkana haniyabaa ubbaa eridi, gaxa keyidi, “Oona koyeetii?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Entti zaaridi, “Naazirete Yesuusa koyoos” yaagidosona. I zaaridi, “Taani Yesuusa” yaagis. Yesuusa aathi immida Yihudi yan enttara eqqis. ");
INSERT INTO gofRNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","I, “Taani Yesuusa” gida wode entti guye shiiqidi, sa7an kunddidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yesuusi qassika, “Oona koyeetii?” yaagidi oychchis. Entti, “Naazirete Yesuusa koyoos” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","I zaaridi, “Taani Yesuusa gideyssa hinttew odas. Hiza, hintte tana koyabaa gidikko hayssata yeddite” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","I hessa giday, “Aawaw, neeni taw immidayssatappe hari attoshin issuwaka dhayssabiikke” gidayssi polettana melassa. ");
INSERT INTO gofRNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simoon Phexiroosas mashshi de7ees. I he mashshaa shoddidi kahine halaqaa aylliyas ushachcha haytha shocidi, qanxi yeggis. He aylliya sunthay Malkkoosa. ");
INSERT INTO gofRNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yesuusi Phexiroosakko, “Ne mashshaa shoohuwan zaara. Ta Aaway taw immida xuu7appe taani uyonnabaa new daanii?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Roome wotaaddaretinne entta halaqay Xoossa Keetha naagiya poolisetara issife Yesuusa oykkidi qachchidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Koyro Yesuusa Haannako efidosona. Haanni he laythi kahine halaqa gidiya Qayyaafa bollo. ");
INSERT INTO gofRNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Qayyaafi, “Asa ubbaa gisho issi asi hayqqiko lo77o” gidi kase Ayhudeta zoridayssa. ");
INSERT INTO gofRNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simoon Phexiroosinne hara issi tamaarey Yesuusa kaallidi bidosona. Kahine halaqay he hara tamaariya loythi erees. Hessa gisho, I Yesuusara kahine halaqaa zabbaa gelis. ");
INSERT INTO gofRNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Shin Phexiroosi karera dirssaa penggen eqqis. Kahine halaqay eriya hara tamaarey kare keyidi, penggiya naagiya na7ees odidi, Phexiroosa gaathi gelssis. ");
INSERT INTO gofRNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Penggiya naagiya na7iya Phexiroosakko, “Neeni, he addiya tamaaretappe issuwa gidikkii?” yaagasu. Phexiroosi zaaridi, “Akkay, taani gidikke” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Sa7ay meeggiya gisho aylletinne naageyssati xiifa tama eethidi, yuuyi aadhdhi eqqidi kayosona. Phexiroosikka enttara eqqidi tama kayees. ");
INSERT INTO gofRNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Kahine halaqay Yesuusa, iya tamaaretabaanne iya timirttiyabaa oychchis. ");
INSERT INTO gofRNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yesuusi zaaridi, “Taani asa ubbaas qonccen odas. Taani Ayhude ubbay shiiqiya Ayhude Woosa Keethaninne Xoossa Keethan ubba wode tamaarssas. Geeman aykkoka odabiikke. ");
INSERT INTO gofRNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Yaatin, neeni tana ays oychchay? Ta odishin si7ida asaa oychcha. He asay taani odididayssa eroosona” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yesuusi hessa gida wode he bessan eqqida wotaaddaretappe issoy Yesuusa baqqidi, “Kahine halaqaas hayssada zaaray?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yesuusi zaaridi, “Taani iitabaa odidabaa gidikko hayssan de7iya asa ubbaa sinthan oda. Shin taani tuma odidabaa gidikko tana ays baqqay?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Hessa gisho, Haanni, Yesuusi qashettida mela kahine halaqaa Qayyaafakko yeddis. ");
INSERT INTO gofRNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Phexiroosi yan eqqidi, tama kayishin, harati iyaakko, “Neeni ha addiya tamaaretappe issuwa gidikkii?” yaagis. Phexiroosi zaaridi, “Akkay, taani gidikke” yaagidi kaddis. ");
INSERT INTO gofRNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Kahine halaqaa aylletappe issoy, Phexiroosi haythaa qanxida addiya dabboy, Phexiroosakko, “Taani nena iyara atakilttiya giddon be7abiikkina?” yaagidi oychchis. ");
INSERT INTO gofRNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Phexiroosi qassika kaddis. Sohuwara kuttoy waassi aggis. ");
INSERT INTO gofRNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Wontta guura, entti Yesuusa Qayyaafa sooppe deriya haareyssa ooso keethi efidosona. Ayhudeti Paasika Baale kathaa maanaw banttana tunisonna mela deriya haareyssa ooso keethaa gelibookkona. ");
INSERT INTO gofRNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Hessa gisho, Philaaxoosi enttako kare keyidi, “Ha addiya ays mooteetii?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Entti, “I iita oothonnabaa gidiyakko nuuni iya neekko ehokko” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Philaaxoosi zaaridi, “Hintte iya ekki efidi, hintte higgey geyssada iya bolla pirddite” yaagis. Ayhudeti, “Oonakka wodhiya maati nuus baawa” yaagidosona; ");
INSERT INTO gofRNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Hessi haniday Yesuusi ay mela hayqo hayqqaneekko erisanaw odidayssi polettanaassa. ");
INSERT INTO gofRNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Philaaxoosi ba ooso keetha zaari gelidi, Yesuusa xeegidi, “Neeni Ayhude kawo?” yaagidi oychchis. ");
INSERT INTO gofRNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesuusi Philaaxoosa, “Ha oysha neeni neeppe oychchayye woykko hara asi new tabaa odidee?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Philaaxoosi zaaridi, “Ta Ayhude asee? Ne asaynne kahine halaqati nena taw aathi immidosona. Ne ay oothadii?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yesuusi, “Ta kawotethay ha alamiyana gidenna. I hayssan gidiyakko ta Ayhudeta halaqatas aadhdha imettonna mela ta aylleti taw olettana. Shin ta kawotethay ha alamiyana gidenna” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Hessa gisho, Philaaxoosi Yesuusakko, “Yaatin, neeni kawoyye?” yaagidi oychchis. Yesuusi zaaridi, “Tuma ta kawo gideyssa ne gadasa. Taani yelettidaynne ha alamiya yiday tumatethaas markkattanassa. Tumaa bagga gidida oonikka taani geyssa si7ees” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Philaaxoosi, “Tumi aybee?” yaagis. Philaaxoosi hessa gidaappe guye Ayhudetakko kare keyidi, “Taani iyappe ay iitakka demmabiikke. ");
INSERT INTO gofRNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Shin Paasika Baale gallas, issi ase hinttew qashoppe billiya meezey de7ees. Taani hinttew Ayhudeta kawuwa billana mela koyeetii?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Entti zaaridi, bantta qaalaa dhoqqu oothidi, “Barbbaana billafe attin iya gidenna” yaagidosona. Shin Barbbaani pangga. ");
INSERT INTO gofRNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Hessafe guye, Philaaxoosi Yesuusa garaafisis. ");
INSERT INTO gofRNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Wotaaddareti aguntha kallachcha medhdhidi iya huu7en wothidosona. Qassi zo7o ma7o iya mayzidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Iyaakko shiiqidi, “Ayhude kawuwaw, merinaw kawota” yaagidi iya baqqidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Philaaxoosi qassika kare keyidi, Ayhudetakko, “Hekko, taani iyappe ay iitakka demmaboonnayssa hintte erana mela iya hintteko kare kessana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Hessafe guye, Yesuusi aguntha kallachcha ba huu7en wothidi, zo7o ma7o ma77idi, kare keyis. Philaaxoosi Ayhudetakko, “Uraa hayssa be7ite” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Kahine halaqatinne Xoossa Keetha naageyssati iya be7ida wode bantta qaala dhoqqu oothidi, “Masqaliya bolla kaqqa! Kaqqa!” yaagidosona. Philaaxoosi enttako, “Hintte iya efidi, masqaliya bolla kaqqite. Taani iyappe ay iitakka demmabiikke” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ayhudeti zaaridi, “Nuus higgey de7ees. I bana Xoossaa na7a oothida gisho nu higgiyatho I hayqqanaw bessees” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Philaaxoosi hessa si7ida wode kaseyssafe daro yayyis. ");
INSERT INTO gofRNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Qassika Philaaxoosi ba ooso keethi simmi gelidi Yesuusakko, “Neeni awuppe yadi?” yaagidi oychchis. Shin Yesuusi iyaw aykkoka zaaribeenna. ");
INSERT INTO gofRNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Hessa gisho, Philaaxoosi, “Taw odikkii? Nena billanaw woykko masqaliya bolla kaqqanaw taw maati de7eyssa erikkii?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yesuusi, “Xoossay new maata immiboonnabaa gidiyakko ta bolla maati new deennashin. Hessa gisho, tana new aathi immidays aadhdhiya nagara oothis” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Philaaxoosi hessa si7ida wode Yesuusa billanaw oge koyis. Shin Ayhudeti bantta qaala dhoqqu oothidi, “Neeni iya billiyabaa gidikko Kawuwa Qeesare bagga gidakka. Bana kawo giya oonikka Qeesare morkke” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Philaaxoosi hessa si7idi Yesuusa kare kessis. Yaatidi, “Lochche Shuchchi” giyason pirdda oydiyan uttis. Ibraysxe qaalan he bessay “Gabata” guussu. ");
INSERT INTO gofRNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","He gallasay Paasika Baale bonchchanaw giigetetha gallas. He wode sa7i usuppun saate heera. Philaaxoosi Ayhudetakko, “Hintte kawuwa hayssa be7ite” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ayhudeti bantta qaala dhoqqu oothidi, “Digga! Digga! Masqaliya bolla kaqqa” yaagidosona. Philaaxoosi zaaridi, “Hintte kawuwa taani masqaliya bolla kaqqanayssa koyeetii?” yaagidi oychchis. Kahine halaqati, “Qeesareppe hara kawoy nuus baawa” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Hessafe guye, entti Yesuusa masqaliya bolla kaqqana mela Philaaxoosi enttaw aathi immis. Entti Yesuusa oykkidi efidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Yesuusi ba masqaliya tookkidi, “Huu7e guugge” giya bessaa bis. “Huu7e guugge” guussay Ibraysxe qaalan “Golggotta” guussu. ");
INSERT INTO gofRNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Entti he bessan masqaliya bolla Yesuusa kaqqidosona. Qassi iyara hara nam77u asata, issuwa ya baggara hankkuwa ha baggara masqaliya bolla kaqqidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Philaaxoosi, “Ayhudeta Kawuwa, Naazirete Yesuusa” yaagiya xuufe xaafidi masqaliya bolla wothis. ");
INSERT INTO gofRNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Yesuusi masqaliya bolla kaqettida bessay katamaas matan de7iya gisho daro Ayhudeti he xuufiya nabbabidosona. Xuufey xaafettiday Ibraysxe doonan, Laatine doonaninne Girike doonana. ");
INSERT INTO gofRNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Hessa gisho, kahine halaqati Philaaxoosakko, “ ‘Ha addey bana Ayhude kawo yaagis’ gada xaafappe attin ‘Ayhude kawo’ gada xaafoppa” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Yaatin, Philaaxoosi, “Ta xaafidayssa xaafas” yaagidi zaaris. ");
INSERT INTO gofRNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Wotaaddareti masqaliya bolla iya kaqqidaappe guye iya ma7uwa ekkidi, oyddu bessan shaakkidi, isso isso ekkidosona. Yeda ma7ettiya iya adussa ma7uwa ekkidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Wotaaddareti, “Oona gakkaneekko, saama yegganaappe attin ma7uwa peedhokko” yaagidosona. Hessi haniday Geeshsha Maxaafan, “Ta ma7uwa shaakki ekkidosona; ta adussa ma7uwa bollaka saama yeggidosona” geetettidayssi polettana melassa. Hessa gisho, wotaaddareti hessa oothidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Shin Yesuusa masqaliya matan iya aayyaa, iya aaye michchiya, Qeliyophe machchiya Mayraamanne Magdela Mayraama eqqidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yesuusi ba aayiwunne I dosiya tamaarey yan eqqidayssata be7idi, ba aayeko, “Ta aaye, ne na7aa hayssa be7a” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Hessafe guye, he tamaariyakko, “Ne aayiw hanno be7a” yaagis. He tamaarey iyo he wodeppe doomidi baara daana mela soo efis. ");
INSERT INTO gofRNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Hessafe guye, Yesuusi ubbay ha77i polettidayssa eridi, Geeshsha Maxaafan xaafettidayssi polettana mela “Tana saamees” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","He bessan issi xugga kumetha caala woyney de7ees. Entti ispponjje he woyniyan yeggidi, hisophe mitha xeeran wothidi, Yesuusa doonaakko shiishidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yesuusi woyniya ganxi be7idi, “Polettis” yaagis. Hessafe guye, ba huu7iya ziqqi oothidi ba shemppuwa immis. ");
INSERT INTO gofRNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","He gallasay giigetetha gallas gidiya gishonne wonttetha gallasay bonchcho Sambbaata gidiya gisho asata ahay masqaliya bolla Sambbaata gallas pee7onna mela entta tohuwa menthidi, masqaliyappe wodhisana mela Ayhudeti Philaaxoosa woossidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Hessa gisho, wotaaddareti bidi, Yesuusara kaqettida nam77u asata tohuwa menthidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Shin Yesuusakko yida wode I hayqqidayssa be7idi, iya tohuwa menthibookkona. ");
INSERT INTO gofRNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Shin wotaaddaretappe issoy iya miya tooran caddin sohuwara suuthinne haathi goggis. ");
INSERT INTO gofRNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Hintte ammanana mela hessa be7idayssi markkattis. Iya markkatethayka tuma. Qassi I odeyssi tuma gideyssa erees. ");
INSERT INTO gofRNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Hessi haniday Geeshsha Maxaafay, “Iya meqethatappe issoykka meqqenna” gidayssi polettana melassa. ");
INSERT INTO gofRNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Qassika Geeshsha Maxaafay hara bessan, “Entti bantta caddidayssa be7ana” yaagees. ");
INSERT INTO gofRNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Hessafe guye, Armmatiyasa katamaappe yida Yoosefi Yesuusa ahaa ekkanaw Philaaxoosa woossis. Yoosefi Ayhudetas yayyida gisho qosan Yesuusa kaalleyssa. Philaaxoosi, “Ekka” yaagis. Hessa gisho, Yoosefi bidi Yesuusa ahaa ekkis. ");
INSERT INTO gofRNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Qassi Niqodimoosi, hayssafe kase Yesuusakko qamma yidayssi, karbbenne godare uuthara walakettida hasttamanne issi kilo giraame gidiya shitto ekkidi Yoosefara yis. ");
INSERT INTO gofRNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","He nam77u asati Yesuusa ahaa ekkidi, Ayhudeti aha xaaxiya maaran, shittora, moogo afilan xaaxidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Yesuusi masqaliya bolla kaqettida bessan daro atakilttey de7ees. He atakilttiya giddon shuchchafe woocettidi oosettida buroo oonikka moogettibonna ooratha duufoy de7ees. ");
INSERT INTO gofRNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","He gonggoloy matan de7iya gishonne Ayhudeti Sambbaatas giigettiya gallas gidiya gisho Yesuusa ahaa yan moogidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Wogga wode wontta buroo geeyonna de7ishin, Magdela Mayraama, Yesuusi moogettida duufuwa bada shuchchay he duufuwa doonappe denddidayssa be7asu. ");
INSERT INTO gofRNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Simoon Phexiroosakkonne Yesuusi dosiya hankko tamaariyakko woxxa bada, “Duufuwappe Godaa efidosona; iya awun wothidaakko nu erokko” yaagasu. ");
INSERT INTO gofRNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Hessa gisho, Phexiroosinne hankko tamaarey keyidi duufuwa bidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Nam77ayka issife woxxidosona, shin hankko tamaarey Phexiroosappe aadhdhidi sinthattidi duufuwa gakkis. ");
INSERT INTO gofRNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","He tamaarey hokkidi, moogo afilaa be7is, shin duufuwan wodhdhibeenna. ");
INSERT INTO gofRNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simoon Phexiroosi iya kaalli yidi, duufuwan wodhdhidi moogo afilay yan de7eyssa be7is. ");
INSERT INTO gofRNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Qassi Yesuusa huu7en xaaxettida afilay xaaxettida mela dumma issi bessan de7eyssa be7is. He afilay dumma de7eesippe attin moogo afilaara issife deenna. ");
INSERT INTO gofRNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","He wode sinthattidi duufuwa gakkida hankko tamaarey geli be7idi ammanis. ");
INSERT INTO gofRNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Yesuusi hayqoppe denddanaw besseyssa odiya Geeshsha maxaafaa qaala entti buroo akeekibookkona. ");
INSERT INTO gofRNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Hessafe guye, iya tamaareti bantta soo simmidi bidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Shin Mayraama he duufuwa doonan eqqada yeekkashe hokkada duufuwa giddo xeellasu. ");
INSERT INTO gofRNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Bootha ma7o ma77ida nam77u kiitanchchoti Yesuusa ahay zin77idasuwan issoy huu7esoora hankkoy tohosoora uttidashin be7asu. ");
INSERT INTO gofRNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Entti ikko, “Maccasete, ays yeekkay?” yaagidi oychchidosona. Iya, “Entti ta Godaa efidosona; entti awun wothidaakko taani erikke” yaagasu. ");
INSERT INTO gofRNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Hessa gidaappe guye, iya guye simma xeelliya wode Yesuusi yan eqqidayssa be7asu. Shin I Yesuusa gididayssa erabuukku. ");
INSERT INTO gofRNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yesuusi iikko, “Maccasete, ays yeekkay? Oona koyay?” yaagidi oychchis. Mayraama atakiltte oosanchchuwa daanin, “Godaw, ne ekkidabaa gidikko, iya awun wothidaakko taw odarkkii. Taani iya ekkana” yaagasu. ");
INSERT INTO gofRNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesuusi iikko, “Mayraame” yaagis. Iya iyaakko simmada, Ibraysxe doonan “Rebuuni” yaagasu. Hessas birshshethay “Asttamaariyaw” guussu. ");
INSERT INTO gofRNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesuusi iikko, “Taani buroo ta Aawakko boonna gisho tana oykkada ashshanaw koyoppa. Shin ta ishatakko bada, ‘Taani ta Aawakkonne hintte Aawakko, ta Xoossaakonne hintte Xoossaako, simmana gis’ gada enttaw oda” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Magdela Mayraama Godaa be7idayssanne iw hessa I odididayssa bada iya tamaaretas odasu. ");
INSERT INTO gofRNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Wogga wode omarssi, iya tamaareti Ayhudetas yayyidi kariya gorddidi shiiqi uttidashin, Yesuusi yidi, entta giddon eqqidi, “Saroy hinttew gido” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Hessa gidi simmidi ba kushiyanne ba miya entta bessis. Iya tamaareti Godaa be7ida wode daro ufayttidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yesuusi zaaridi enttako, “Saroy hinttew gido; ta Aaway tana kiittidayssada taanikka hinttena kiittays” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Hessa gidaappe guye, entta bolla ufu gidi punnis. Qassi, “Geeshsha Ayyaana ekkite. ");
INSERT INTO gofRNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Hintte atto gida asaa nagaray atto geetettana. Hintte atto goonnayssata nagaray atto geetettenna” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Shin tammanne nam77u tamaaretappe issoy, Didimoosa geetettiya Toomasi, Yesuusi yida wode enttara deenna. ");
INSERT INTO gofRNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Hessa gisho, hankko iya tamaareti Toomasakko, “Nuuni Godaa be7ida” yaagidosona. Shin Toomasi enttako, “Misimaren I cadettida iya kushiyan de7iya beeta be7onnanne he beeta ta biradhdhen bochchonna, qassi ta kushiya iya miyan yedda be7onna ammanikke” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Saaminttafe guye, Yesuusa tamaareti qassika son shiiqidi uttidosona; Toomasikka enttara de7ees. Karey gorddettidi de7ishin Yesuusi yidi, entta giddon eqqidi, “Saroy hinttew gido” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Hessafe guye, Yesuusi Toomasakko, “Ta kushiya ne biradhdhiyan bochchada be7a. Qassi ne kushiya ta miyan yeddada be7a; sidhoppa, ammana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Toomasi zaaridi, “Ta Godaw, ta Xoossaw” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yaatin Yesuusi, “Neeni tana be7ida gisho ammanadasa, shin tana be7onna ammanidayssati anjjettidayssata” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesuusi ha maxaafan xaafettiboonna hara daro malaatata ba tamaareta sinthan oothis. ");
INSERT INTO gofRNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Shin Yesuusi I Kiristtoosa, Xoossaa Na7aa gideyssa hintte ammanana melanne ammanidi iya sunthan de7o demmana mela hessi xaafettis. ");
INSERT INTO gofRNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Hessafe guye, Yesuusi Xibaaryoosa Abbaa matan ba tamaaretas zaari qonccis. I enttaw hayssafe kaallidi de7iya hanotan qonccis. ");
INSERT INTO gofRNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simoon Phexiroosi, Mentte geetettiya Toomasi, Qaana Galiilappe yida Natina7eeli, Zabdiyoosa naytinne Yesuusa tamaaretappe hara nam77ati issife de7oosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simoon Phexiroosi enttako, “Taani molo oykkanaw bays” yaagis. Entti, “Nukka neera baana” yaagidi, wogoluwa giddo gelidosona. Shin entti he qamman aybi molokka oykkibookkona. ");
INSERT INTO gofRNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Wontta guura xalqey dolanaappe sinthe, Yesuusi abbaa gaxan eqqis, shin iya tamaareti Yesuusa gididayssa erbookkona. ");
INSERT INTO gofRNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Yesuusi enttako, “Ta laggeto, molo oykkibeekketii?” yaagis. Entti zaaridi, “Aykkoka oykkibookko” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","I zaaridi, “Hintte gitiya wogoluwappe ushachcha baggara yeggite; guutha molo hintte oykkana” yaagis. Hessa gisho, gitiya ushachcha baggara yeggidosona. Moloy darida gisho goochchidi kessanaw xoonettidosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Yesuusi dosiya tamaarey Phexiroosakko, “Hayssi Godaa!” yaagis. Simoon Phexiroosi I Godaa gidayssa si7ida wode kallo de7iya gisho ba ma7uwa ma77idi abbaa giddo guppi gelis. ");
INSERT INTO gofRNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Shin wogoluwan attida hankko tamaareti moloy kumida gitiya goochchidi, abbaafe gaxa keyidosona. Entti abbaafe nam77u xeetu wadha mela haakkoosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Entti abbaafe gaxa keyida wode xiifa bonqon moloy de7eyssanne uythi be7idosona. ");
INSERT INTO gofRNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yesuusi enttako, “Ha77i hintte oykkida moluwappe guuthara hammite” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simoon Phexiroosi wogoluwan gelidi, xeetanne ishatammanne heedzu wogga moloti kumida gitiya goochchidi abbaafe gaxa kessis. Moloy hessa mela daro gidin gitey daakettibeenna. ");
INSERT INTO gofRNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesuusi enttako, “Haa yidi miite” yaagis. I Godaa gideyssa entti erida gisho iya tamaaretappe issoykka, “Neeni oonee?” gidi iya oychchanaw minniday baawa. ");
INSERT INTO gofRNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yesuusi yidi, uythaa ekkidi enttaw immis; moluwakka hessada immis. ");
INSERT INTO gofRNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Yesuusi hayqoppe denddidi ba tamaaretas qonccishin hayssi heedzantho. ");
INSERT INTO gofRNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Entti midaappe guye, Yesuusi Simoon Phexiroosakko, “Yoona na7aw Simoona, tana hayssatappe aathada dosay?” yaagis. Simoon Phexiroosi, “Ee Godaw, taani nena doseyssa ne eraasa” yaagis. Yesuusi iyaakko, “Ta dorssa marata heemma” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yesuusi qassika, “Yoona na7aw Simoona, tana dosay?” yaagis. Simoon Phexiroosi, “Ee Godaw, taani nena doseyssa ne eraasa” yaagis. Yesuusi, “Ta dorssata heemma” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Yesuusi heedzantho, “Yoona na7aw Simoona, tana dosay?” yaagis. Yesuusi heedzantho Simoon Phexiroosakko, “Tana dosay?” yaagidi oychchida gisho Phexiroosi azzanidi, “Godaw, neeni ubbabaa eraasa; taani nena doseyssa ne eraasa” yaagis. Yesuusi, “Ta dorssata heemma. ");
INSERT INTO gofRNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Taani new tuma odays; neeni na7atethan de7iya wode nerkka danccettada, ne koyida soo baasa. Shin ne cimida wode ne kushiya micca bessana. Hari danccisana; ne dosonna soo efana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yesuusi hessa Phexiroosi ay mela hayqo hayqqidi, Xoossaa bonchchisaneekko erisanaw gis. Hessa gidaappe guye, Yesuusi Phexiroosakko, “Tana kaalla” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Phexiroosi guye simmidi, Yesuusi dosiya tamaarey baappe guyera yeyssa be7is. He tamaarey, kaho miyason Yesuusakko shiiqidi, “Godaw, nena aathi immanay oonee?” gidayssa. ");
INSERT INTO gofRNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Phexiroosi he tamaariya be7idi, “Godaw, ha addey qassi waananee?” yaagidi Yesuusa oychchis. ");
INSERT INTO gofRNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesuusi iyaakko, “Taani yaana gakkanaw I daana mela taani koykko, hessi nena ay metidee? Neeni tana kaalla” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Hessa gisho, he tamaarey hayqqenna giya oday ishata ubbaa gakkis. Shin Yesuusi, “Taani yaana gakkanaw, I daana mela taani koykko nena ay metidee?” yaagisippe attin “Hayqqenna” gibeenna. ");
INSERT INTO gofRNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ha odabaa markkattidaynne hayssa xaafiday he tamaariya. Iya markkatethay tuma gideyssa nuuni eroos. ");
INSERT INTO gofRNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yesuusi oothida hara darobay de7ees. Ta qoppin, ubbabay huu7en huu7en xaafettidaakko, xaafettiya maxaafatas kumetha alamey wothanw gidanabaa daanenna.");
INSERT INTO gofRNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Tewofiloosa, Yesuusi ba oosuwa oykkida wodeppe salo bida gallasaa gakkanaw, oothidabaanne tamaarssidabaa ubbaa taani ta koyro maxaafan xaafas. Salo baanappe sinthe I ba doorida hawaareta Geeshsha Ayyaanan kiittis. ");
INSERT INTO gofRNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","I ba waayappe guye hayqoppe denddidayssa sidhey baynna qonccisidi enttaw bana bessis. Oytamu gallas enttaw qonccidi Xoossaa kawotethaabaa entta tamaarssis. ");
INSERT INTO gofRNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Issi wode enttara issife mishe entta hayssada yaagidi kiittis: “Ta hinttew odida, ta Aaway immana gida ufayssaa qaala naagiteppe attin Yerusalaameppe keyoppite. ");
INSERT INTO gofRNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ays giikko, Yohaannisi haathan xammaqis, shin guutha wodeppe guye Geeshsha Ayyaanan hintte xammaqettana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Hawaareti Yesuusara gahettida wode iyaakko, “Godaw, Isra7eeletas ne kawotethaa zaarana wodey hayssee?” yaagidi oychchidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Yesuusi enttako, “Ta Aaway ba maatan oothiya wodiyanne laythaa hintte eranaw dandda7ekketa. ");
INSERT INTO gofRNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Shin Geeshsha Ayyaanay hintte bolla wodhdhiya wode hintte wolqqan kumana. Yaani simmidi, Yerusalaamen, Yihuda biitta ubban, Samaareninne sa7aa gaxa gakkanaw taw markkatta gidana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Hessa gidayssafe guye entti xeellishin, dhoqqu dhoqqu gidi, saluwa bin shaaraykka iya entta ayfiyaappe geenthis. ");
INSERT INTO gofRNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Yesuusi biya wode entti salo tishshi oothidi xeellishin, bootha ma7o ma77ida nam77u asati akeekonna entta matan eqqidi, ");
INSERT INTO gofRNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","“Galiila asaw, salo xeellishe, hintte ays eqqideti? Ha hintte be7ishin salo bida Yesuusi hessadakka simmidi yaana” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Hessafe guye, hawaareti Shamaho Deriyappe Yerusalaame simmidosona. Shamaho Derey Yerusalaames matan de7ees. ");
INSERT INTO gofRNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Entti Yerusalaame gelidi, bantta de7iya bessaa pooqiya bolla keyidosona. Enttika: Phexiroosa, Yohaannisa, Yayqooba, Inddiriyasa, Filphoosa, Toomasa, Bartolomiyoosa, Maatoosa, Ilfiyoosa na7aa Yayqooba, ba biittaas mishettiya Simoonanne Yayqooba na7aa Yihuda. ");
INSERT INTO gofRNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Hayssati ubbay maccasatara, Yesuusa aaye Mayraamiranne Yesuusa ishatara ubbay issi wozanan gididi minthidi woossosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","He wode Phexiroosi xeetanne laatama gidiya ammaniyaa asay shiiqida bessan denddi eqqidi, hayssada yaagis: ");
INSERT INTO gofRNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Asaw, Yesuusa oykkidayssata kaalethida Yihudabaa Geeshsha Ayyaanay kase Dawite doonan odida Xoossaa qaalay polettanaw bessees. ");
INSERT INTO gofRNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yihudi nuura issife ha oosuwa oothanaw doorettida asi.” ");
INSERT INTO gofRNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Shin Yihudi ba iita oosuwan demmida miishen gade shammis. I gufannidi kunddin, iya uloy daakettis; iya maraacey ubbay kare keyis. ");
INSERT INTO gofRNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Yihuda bolla hanidabaa Yerusalaamen de7iya asa ubbay si7is. Hessa gisho, he gadiya bantta qaalan Akelddaama (Suutha gade) gidi xeegidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Hessika mazmure maxaafan, ‘Iya keethay kallo atto; oonikka iyan de7oppo. Qassi iya shuumatethaa hari ekko’ geetetti xaafettis. ");
INSERT INTO gofRNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Hessa gisho, Godaa Yesuusi nu giddon simerettida wode ubban nuura de7eyssatappe, ");
INSERT INTO gofRNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","qassi Xammaqiya Yohaannisa wodiyappe doomidi Godaa Yesuusi salo bida gallas gakkanaw nuura de7eyssatappe issi asi iya dendduwas nuura markka gidanaw bessees” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Hessa gisho, asay dooruwas Yosxoosa giya Barssabaasa geetettiya Yoosefanne Maatiyasa nam77a shiishidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Hessafe guye, Xoossaa woossishe, “Asa ubbaa wozana eriya Godaw, ha nam77atappe ne oona dooridaakko nuna bessa. ");
INSERT INTO gofRNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Yihudi ba bessaa bidi, aggida oosuwanne hawaaretetha oosuwa ekkana mela hayssatappe nuus qonccisa” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Entta bolla saama yeggidosona. Saamay Maatiyasa bolla wodhdhin Maatiyasi tammanne issi hawaareta bolla guzhettis. ");
INSERT INTO gofRNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Phenxeqosxe giya gallasay gakkida wode ammaniyaa asa ubbay issife issi bessan shiiqidi de7oosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Qopponna wolqqaama goteda guummiya guunthay akeekonna saloppe yidi entti de7iya keethaa kumis. ");
INSERT INTO gofRNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Qassi tama laco daaniya inxarssati enttaw benttishe, shaaketti shaaketti entta ubbaa bolla wodhdhidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Entti ubbay Geeshsha Ayyaanan kumidi dumma dumma doonan odettana mela Geeshsha Ayyaanay entta dandda7isin haasaya doomidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","He wode biitta ubbaafe yida Xoossaa yayyaa Ayhudeti Yerusalaamen de7oosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","He guunthaa si7ida wode daro asay shiiqidosona. Ammaniya asay entta qaalan odettishin si7ida gisho ");
INSERT INTO gofRNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","malaalettidi, “Ha odettiya asa ubbay Galiila ase gidokkonaayye? ");
INSERT INTO gofRNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Yaatin, nuuni, nu yelettida biittaa doonan entti odettishin waanidi si7anaw dandda7ido? ");
INSERT INTO gofRNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Nuuni Pharxen, Meedonan, Elaamen, nam77u shaafatappe giddon de7eyssati, Yihudan, Qaphadooqiyan, Phanxoosan, Iisiyan, ");
INSERT INTO gofRNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Phirggen, Phinfilen, Gibxxen, Qaarena matan de7iya Liibiyan de7eyssata. Nuuppe baggatikka Roomeppe yida asata. ");
INSERT INTO gofRNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ayhudetinne Ayhudetetha ammano gelida asati, Qarxeesanne Arabe asati, Xoossay oothida gita oosuwa nu qaalan odettishin si7oos” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ubbay malaalettidi, gaanabaa dhayidi wolikko, “La hayssi ay guussee?” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Shin harati, “Hayssati uyidi mathottidosona” yaagidi qelqisidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Shin Phexiroosi, tammanne issi hawaaretara denddi eqqidi, ba qaala dhoqqu oothidi, enttaw hayssada yaagidi odis: “Ayhudetoo, Yerusalaamen de7iya ubbato, taani odeyssa si7ite. ");
INSERT INTO gofRNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Wonttafe heedzu saate gidiya gisho hintte qoppeyssada ha asati mathottibookkona; hessi hinttew eretto. ");
INSERT INTO gofRNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Shin hayssi haniday nabiya Iyyu7eeli odidayssi polettana melassa. ");
INSERT INTO gofRNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“ ‘Xoossay, wodiya wurssethan hayssada hanana yaagees: taani asa ubbaa bolla ta Ayyaana gussana. Hintte adde naytinne macca nayti, tinbbite odana. Hintte yalagati qonccethi be7ana; hintte cimati amuho amuhana. ");
INSERT INTO gofRNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","He gallasatan tana ammaniyaa adde aylleta bollanne macca aylleta bolla taani ta Ayyaana gussana; entti tinbbite odana. ");
INSERT INTO gofRNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Qassi taani bolla saluwan oorathabaa, garssa sa7ankka malla bessana. Suuthi, taminne wolqqaama caagani benttana. ");
INSERT INTO gofRNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Gitanne bonchcho gidida Godaa gallasay gakkanaappe sinthe away dhumana; ageenaykka suuthi daanana. ");
INSERT INTO gofRNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","He wode hessada hanana; Godaa sunthaa xeegiya oonikka attana’ yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Isra7eele asaw, ha qaala si7ite. Naazirete Yesuusa oonatethay, Xoossay hintte giddon oothida wolqqaama oosuwaninne malaatatan hinttew qonccoyssa hinttee, hintte huu7en ereeta. ");
INSERT INTO gofRNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Xoossaa kase eraninne iya sheniyan Yesuusi hinttew aadhdhi imettis. Hintte iya nagaranchchoti masqaliya bolla kaqqidi wodhana mela aathi immideta. ");
INSERT INTO gofRNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Shin Xoossay hayqo wolqqaa diggidi iya denthis. Hessa gisho, hayqoy iya oykkanaw dandda7ibeenna. ");
INSERT INTO gofRNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Dawitey iyabaa odishe, ‘Taani yarkkonna mela, Goday ta ushachchan de7ees. Godaa ubba wode ta matan be7ays. ");
INSERT INTO gofRNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Hessa gisho, ta wozanay ufayttis; ta inxarssan ufayssi kumis; hayqqiya ta asatethay ufayssan daana. ");
INSERT INTO gofRNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ays giikko, ta shemppuwa Si7oolen aggaka. Qassi ne Geeshsha Na7aa ahaa wooqisakka. ");
INSERT INTO gofRNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Neeni tana de7o ogiya erisadasa. Neeni taara de7eyssan ta ufayssay kumethi gidees’ yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Asaw, nu aawa Dawitebaa ta hinttew geeshshada odana. Dawitey hayqqidi moogettis; iya duufoy hachchi gakkanaw nu matan de7ees. ");
INSERT INTO gofRNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Dawitey nabe gidida gisho Xoossay iya sheeshaappe issuwa iya kawotethaa araata bolla utisanaw iyaw caaqqida caaquwa erees. ");
INSERT INTO gofRNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Hessa gisho, Kiristtoosa dendduwa sinthe xeellidi, ‘Iya shemppoy Si7oolen attibeenna; iya asatethaykka wooqibeenna’ gidi odis. ");
INSERT INTO gofRNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","“Xoossay, ha Yesuusa hayquwappe denthidayssas nuuni ubbay markka. ");
INSERT INTO gofRNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Hessa gisho, Xoossay baara haarana mela baappe ushachcha baggara iya dhoqqu dhoqqu oothidi, iyaw immana geetettida Geeshsha Ayyaana ekkidi, hayssa hintte ha77i be7eyssanne si7eyssa nu bolla gussis. ");
INSERT INTO gofRNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","Gaasoykka, Dawitey ba huu7en salo bibeennashin yaagis: ‘Goday, ta Godaa, “Taani ne morkketa ne tohoy yedhdhiyaso oothana gakkanaw hayssan taappe ushachcha baggan utta” gis’ yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Hessa gisho, ha hintte masqaliya bolla kaqqida Yesuusa, Xoossay Godanne Kiristtoosa oothidayssa Isra7eele asa ubbay tuma ero” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Asay Phexiroosi gidayssa si7ida wode bantta wozanan boshettidi Phexiroosanne hankko hawaaretakko, “Ishato, yaatin nuuni ay oothinoo?” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Phexiroosi enttako, “Hintte nagaray atto geetettana mela nagaraappe simmidi, hintte issoy issoy Yesuus Kiristtoosa sunthan xammaqetite. Xoossay immiya Geeshsha Ayyaana hintte ekkana. ");
INSERT INTO gofRNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Gaasoykka Xoossay immana gida ufayssa qaalay hinttes, hintte naytasinne Goday nu Xoossay baakko xeegiya haahon de7iya ubbaassa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Phexiroosi enttaw hara qaalakka gujji markkattidi, “Ha wodiya geella asaa bolla yaanaw de7iya pirddafe hintte huu7iya ashshite” yaagidi zoris. ");
INSERT INTO gofRNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Phexiroosi odidayssa ekkidayssati xammaqettidosona. He gallas heedzu mukulu gidiya asay ammanidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Entti hawaareta timirttiyan, issifetethan, uythaa muusaninne Xoossaa woosan minnoosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Hawaareta kushen daro oorathabaynne malaati oosettiya gisho asa ubbay yayyidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ammanida ubbay issife de7oosona; banttaw de7iyaba ubbaa issife shaakettoosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Entti banttaw de7iyabaa bayzidi miishiya issuwas issuwas koshshida mela shaakkosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ubba gallas issi wozanan gididi Xoossa Keethan shiiqoosona. Bantta keethan issoy issuwa xeegidi ufayssaninne ashkke wozanan kathaa moosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Xoossaa galatishe asa ubban sabettidosona. Goday atteyssata gallas gallas entta bolla gujjees. ");
INSERT INTO gofRNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Issi gallas Phexiroosinne Yohaannisi Xoossaa woossanaw uddufun saaten Xoossa Keethi bidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Yelettoosoppe doomidi wobbe gidida issi addey Xoossa Keethi geliya asaappe miishe woossana mela ubba wode lo77o giya Xoossa Keethaa penggiyan ehidi wothoosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","He wobbe addey Phexiroosinne Yohaannisi Xoossa Keethi gelana hanishin be7idi entta miishe woossis. ");
INSERT INTO gofRNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Enttika iya caddi xeellidi, “Nuukko haa xeella” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Wobbe addey enttafe aykko ekkana daanin enttako xeellis. ");
INSERT INTO gofRNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Shin Phexiroosi iyaakko, “Taw miishey baawa, shin taw de7iyabaa taani new immana. Naazirete Yesuus Kiristtoosa sunthan denddada hamutta” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Hessafe guye, wobbe addiya ushachcha kushiya oykkidi denthis. Ellesidi iya tohoynne qinccafiley minni aggis. ");
INSERT INTO gofRNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Addey guppidi denddi eqqis. Gedenne ha hamuthi doomis. Hessafe guye, hamuttishe, guppishenne Xoossaa galatishe enttara issife Xoossa Keethi gelis. ");
INSERT INTO gofRNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","I hamuttishininne Xoossaa galatishin asa ubbay iya be7idosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Be7ida ubbay miishe woossanaw lo77o giya Xoossa Keetha penggen uttidayssi iya gididayssa eridosona; I hanidabaa be7idi malaalettidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Addey Phexiroosappenne Yohaannisappe duuxike gidi oykkidi de7ishin asa ubbay malaalettidi, Solomone barandda giyason issife enttako woxxidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Phexiroosi asaa be7ida wode asaakko, “Isra7eele asaw, ays hayssan malaaletteti? Woykko ays nuna caddi xeelletii? Nuuni nu wolqqan woykko nu xillotethan ha addiya hamuthidabaa hinttew daanii? ");
INSERT INTO gofRNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Abrahame, Yisaaqa, Yayqooba Xoossay, nu aawata Xoossay, ba na7aa Yesuusa bonchchis. Shin hintte hayqos aathi immidayssa Philaaxoosi billanaw koyinkka hintte iya sinthan, ‘Nuuni iya erokko’ yaagideta. ");
INSERT INTO gofRNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Hintte geeshshaanne xilluwaa, ‘Nuuni iya erokko’ gidi, shemppo wodhidayssa hinttew billana mela Philaaxoosa woossideta. ");
INSERT INTO gofRNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","De7uwa immeyssa hintte wodhideta, shin Xoossay hayqoppe iya denthis. Hessas nuuni markka. ");
INSERT INTO gofRNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ha hintte be7eysinne eriya addey paxidi minniday Yesuusa sunthan ammanidayssana. Ha hintte ubbaa sinthan iya hayssada pathiday I Yesuusa ammanida gishossa. ");
INSERT INTO gofRNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Ha77ika ta ishato, hintteka hinttena kaaletheyssatada, eronna oothidayssa taani erays. ");
INSERT INTO gofRNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Shin Xoossay beni nabeta ubbaa doonan, ‘Kiristtoosi waaye ekkanaw bessees’ yaagidayssi hayssada polettana mela oothis. ");
INSERT INTO gofRNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Hiza, Xoossay hintte nagara atto gaana mela Godaakko simmite. ");
INSERT INTO gofRNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Godaa matappe minthetho wodey hinttew yaana. Xoossay Kiristtoosa gidana mela sinthattidi doorida Yesuusa hinttew yeddana. ");
INSERT INTO gofRNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Xoossay ba geeshsha nabeta doonan beni odidayssa mela ubbabay ooraxiya wodey gakkanaw Yesuusi salon gam77anaw bessees. ");
INSERT INTO gofRNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Musey, ‘Godaa Xoossay tana denthidayssa mela hintte giddofe hinttew nabe denthana. Hintte I geyssa ubbaa si7ite. ");
INSERT INTO gofRNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","He nabey odeyssa si7onna asi oonikka asaa giddofe shaakettidi dhayo’ yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Qassi Saamu7eelappe doomidi de7iya nabeti ubbay ha wodiyaba odidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Hintte nabeta nayta; qassi Xoossay Abrahames, ‘Sa7an de7iya asa ubbaa taani ne sheeshaa baggara anjjana’ yaagidi nu aawatas gelida qaala laattiya nayta. ");
INSERT INTO gofRNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Xoossay hinttena ubbaa hintte iita ogiyappe zaaridi anjjana mela ba na7aa denthidi hinttew koyro yeddis” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Phexiroosinne Yohaannisi asaas odishin kahine halaqati, Xoossa Keethaa naageyssata halaqaynne Saduqaaweti enttako yidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Entti Yesuusi hayqoppe denddoyssanne iya gaason hayqoppe denddoy de7eyssa asaa tamaarssida gisho yilotidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Hessa gisho, entta oykkidi sa7ay omarssida gisho wonttana gakkanaw qasho keethi gelssidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Shin qaala si7idayssatappe daroti ammanidosona. Ammanida adde asaa tayboy ichchashu mukulukko bis. ");
INSERT INTO gofRNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Wonttetha gallas deriya haareyssati, cimatinne, higge asttamaareti Yerusalaamen shiiqidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","He asa giddon kahine halaqay Haanni, Qayyaafi, Yohaannisi, Iskkinddireynne kahine halaqaa soo asati ubbay de7oosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Hawaareta bantta sinthan essidi, “Aybi wolqqan woykko oodde sunthan hayssa hintte oothidetii?” yaagidi oychchidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","He wode Phexiroosi Geeshsha Ayyaanan kumidi, “Deriya haareyssato, cimatoo, ");
INSERT INTO gofRNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","hachchi ha wobbe addiyaas oosettida lo77o oosuwasinne I waanidi paxidaakko hintte nuna oychchiko, ");
INSERT INTO gofRNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","masqaliya bolla hintte kaqqin, Xoossay hayqoppe denthida Naazirete Yesuus Kiristtoosa sunthan ha addey paxidi hintte sinthan eqqidayssi hinttewunne Isra7eele asa ubbaas eretto. ");
INSERT INTO gofRNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","‘Gimbbeyssati boridi ixxida shuchchay, godaa xaphuwa minthiya, ubbaafe aadhdhiya shuchchu gidis; he shuchchay Yesuusa.’ ");
INSERT INTO gofRNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Hessa gisho, atotethi iya baggarappe attin hara oodde baggarakka baawa. Nuuni iya sunthan attana mela asa ubbaas Xoossay saloppe garssan immida hara sunthi baawa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Shiiqida asay Phexiroosinne Yohaannisi minnida minotethaa be7ida wode entti tamaariboonna coo asi gididayssa akeekidi malaalettidosona; entti Yesuusara de7eyssa eridosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Qassi paxida addey Phexiroosaranne Yohaannisara eqqidayssa asay be7idi giyabaa dhayidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Shin Phexiroosanne Yohaannisa kare keyana mela oothidi bantta giddon, ");
INSERT INTO gofRNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Ha asata nu ay oothinoo? Entta kushen oosettida gita malaatay Yerusalaamen de7iya ubbaas benttees. Nuuni hessa erokko gaanaw dandda7okko. ");
INSERT INTO gofRNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Shin ha oday asaa giddon laalettonna mela hizappe guye ha asati Yesuusa sunthan ooddeskka odonna mela minthidi naagisana” yaagidi zorettidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Entta xeegidi, Yesuusa sunthan hizappe odonna mela woykko tamaarssonna mela kiittidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Shin Phexiroosinne Yohaannisi enttako zaaridi, “Xoossas kiitettanayssafenne hinttew kiitetanayssafe Xoossaa sinthan awussi lo77oko ane hintte pirddite. ");
INSERT INTO gofRNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Nuuni be7idabaanne si7idabaa odonna agganaw dandda7okko” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Biitta cimatinne deriya haareyssati kaseppe minthi naagisidi entta yeddi aggidosona. Asay hanidabaas Xoossaa galatiya gisho entta seeranaw dandda7ibookkona. ");
INSERT INTO gofRNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","He malaatan harggiyafe pathida addiyaas laythay oytamappe aadhdhis. ");
INSERT INTO gofRNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Phexiroosinne Yohaannisi birshshettidi bantta dabbotakko bidi, kahine halaqatinne cimati banttako gidabaa ubbaa enttaw odidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Entti hessa si7ida wode issi wozanan gididi Xoossaa hayssada yaagidi woossidosona: “Ubbaa Haariya Godaw, saluwa, sa7aa, abbaanne entta giddon de7iya ubbabaa medhdhidaysso, ");
INSERT INTO gofRNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Neeni ne aylliya, nu aawa Dawite doonan Geeshsha Ayyaanan, ‘Derey ays yilotidonaa? Asay ays coo maqettidonaa? ");
INSERT INTO gofRNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Sa7aa kawotinne deriya haareyssati issife Godaa bollanne Kiristtoosa bolla denddidosona’ yaagadasa. ");
INSERT INTO gofRNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Tumakka, Heroodisinne Phenxe Philaaxoosi Ayhude gidonna asaaranne Isra7eele asaara ne doorida ne geeshsha Na7aa Yesuusa bolla denddanaw ha kataman shiiqidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Qassi neeni ne wolqqaaninne ne sheniyan oothana gada qoppa uttidabaa ubbaa polidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ha77ika Godaw, entta manddethaa be7a; nuuni ne aylleti ne qaala kumetha wozanan odana mela nuna dandda7isa. ");
INSERT INTO gofRNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ne geeshsha na7aa Yesuusa sunthan hargganchchota pathanaw, oorathabaynne malaatati oosettana mela ne kushiya micca” gidi woossidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Entti Xoossaa woossidaappe guye he entti shiiqidasoy qaaxxis. Entta ubban Geeshsha Ayyaani kumin Xoossaa qaala minotethan odidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ammaneysati ubbay qofaninne wozanan issino gididosona. Entti banttaw de7iyabaa tabaa goonnashin issife shaakettoosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Hawaarti Godaa Yesuusi hayqoppe denddidayssa gita wolqqan markkattosona. Xoossay entta ubbaas aadho keehatethaa darssidi immis. ");
INSERT INTO gofRNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Biitti woykko keethi de7eyssati ubbay bayzi ekkida miishiya ehiya gisho ammaneyssata giddon metootanchchoy issoykka baawa. ");
INSERT INTO gofRNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Miishiya ehidi hawaaretas immoosona; he miishiya issuwas issuwas koshsheyssada shaakki shaakki immees. ");
INSERT INTO gofRNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Qoophiroosa giya bessan yelettida Yoosefa giya Leewe sheeshaappe gidida issoy de7ees. Iya sunthaa hawaareti Barnnabaasa (Minthetho na7a) gidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Barnnabaasi baw de7iya biittaa bayzidi miishiya ehidi hawaaretas immis. ");
INSERT INTO gofRNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Issi Hananiya giya addey ba machche Saphphiirira gade bayzis. ");
INSERT INTO gofRNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","He bayzida miishiyappe ba machchiya erishin baggaa ashshidi, attidayssa ehidi hawaaretas immis. ");
INSERT INTO gofRNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Shin Phexiroosi Hananiyakko, “Neeni Geeshsha Ayyaana cimmana melanne gadiya bayzida miishiyappe shaakkada ashshana mela Xalahey ne wozanan ays gelidee? ");
INSERT INTO gofRNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Neeni bayzanaappe kase gadey nebaa gidenneyye? Qassi neeni bayza simminkka miishey nebaa gidenneyye? Yaatin, hessa melabaa oothanaw ays ne wozanan qoppadii? Neeni Xoossaa bolla worddotadasappe attin asa bolla worddotabaakka” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Hananey he qaala si7ida mela kunddidi hayqqis; hessa si7ida ubbay daro yayyis. ");
INSERT INTO gofRNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Na7atetha asati soo gelidi iya ahaa xaaxidi efidi moogidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Heedzu saateppe guye Hananiya machchiya hessa eronna de7ashe Phexiroosi de7iyasuwa gelasu. ");
INSERT INTO gofRNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Phexiroosi iikko, “Hintte gadiya hayssa mela miishes bayzideti? Ane taw oda” yaagis. Iyakka, “Ee, hayssa mela miishes bayzida” yaagasu. ");
INSERT INTO gofRNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Phexiroosi maccasiw, “Neeranne ne azinaara Godaa Ayyaana paaccanaw ays zorettidetii? Hekko, ne azina moogida asati karen de7oosona; nenakka entti kare kessana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Maccasiya iirakka Phexiroosa tohuwa matan kunddada hayqqa aggasu; na7atethati geliya wode hayqqidaaro demmidi kare kessidi, I azina matan moogidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Kumetha woosa keethaynne hessa si7ida hara asa ubbay daro yayyidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Hawaareti daro malaatatanne oorathabata asaa giddon oothoosona. Ammaniya ubbay Solomone baaranddan issife shiiqosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Hara asappe enttara gahettanaw issi asikka minnibeenna, shin asay entta bonchchees. ");
INSERT INTO gofRNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ammaniya addetanne maccasata tayboy kaseyssafe darishe bis. ");
INSERT INTO gofRNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Hessa gisho, asay hargganchchota halaninne alggan tookkidi Phexiroosi aadhdhiya wode iya kuyay enttafe issota issota bolla shemppana mela oge doonan kessidi wothoosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Qassi daro asay Yerusalaame matan de7iya katamatappe hargganchchotanne tuna ayyaani waaysiya asata ekkidi yoosona; ubbayka paxidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Kahine halaqaynne iyara de7iya Saduqaaweti ubbay qanaaten kumidi hawaareta bolla denddidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Hawaareta oykkidi deriya qasho keethan yeggidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Shin Godaa kiitanchchoy qamma qasho keethaa penggiya dooyidi hawaareta kare kessidi, ");
INSERT INTO gofRNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Bidi, Xoossa Keethan eqqidi ha ooratha de7o qaala asa ubbaas odite” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Hawaareti hessa si7ida wode wontta guura Xoossa Keethi gelidi tamaarsso doomidosona. Kahineta halaqaynne iyara de7eyssati yidi, Isra7eele cimata ubbaa xeegi shiishidi hawaareta bantta sinthe ehana mela wotaaddareta qasho keethi kiittidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Shin wotaaddareti qasho keethi bidi hawaareta demmibookkona. Guye simmi yidi deriyas, ");
INSERT INTO gofRNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Nuuni biya wode qasho keetha penggey minthi gorddettin, naageyssati penggen eqqidayssata demmida. Shin nuuni kariya dooyaa wode giddon hari attoshin issi asikka baawa” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Hessa gisho, Xoossa Keethaa wotaaddareta kiitteysinne kahine halaqati hessa si7ida wode “Hawaareta bolla aybi haanidee?” yaagidi hirggidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","He wode issi addey enttako yidi, “Hekko, qasho keethi hintte gelssida asati Xoossa Keethan eqqidi asaa tamaarssoosona” yaagidi enttaw odis. ");
INSERT INTO gofRNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Xoossa Keethaa wotaaddareta kiitteyssi ba wotaaddaretara bidi hawaareta ehis. Shin entti banttana asay shuchchan caddana gidi yayyida gisho entta aaddashidi ehidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Entti hawaareta ehidi, shiiqida shangguwa sinthan essin kahine halaqay enttako, ");
INSERT INTO gofRNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Hinttena nuuni he uraa sunthan tamaarssonna mela minthidi kiittibookko? Hekko, hintte timirttiya Yerusalaame katamaa ubbaa gathideta. He uraa shemppuwas nuna oythanaw qoppeeti?” yaagidi oychchis. ");
INSERT INTO gofRNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Phexiroosaranne hankko hawaaretara enttaw zaarishe, “Nuuni asas kiitettanaappe Xoossas kiitettanaw bessees. ");
INSERT INTO gofRNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Masqaliya bolla hintte kaqqidi wodhida Yesuusa nu aawata Xoossay hayqoppe denthis. ");
INSERT INTO gofRNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Isra7eeleti nagaraappe simmana melanne entta nagaray atto geetettana mela Xoossay Yesuusa haareyssanne ashsheyssa oothidi bonchchon baappe ushachcha baggan utisis. ");
INSERT INTO gofRNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Hessas nuuni markka; qassi Xoossay bana ammaneyssatas immida Geeshsha Ayyaanaykka markka” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Shiiqida asay hessa si7ida wode daro yilottidi, hawaareta wodhanaw qoppidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Shin asa ubban daro bonchchettida, higge asttamaarey, Gamaaliyale giya issi Farisaawey denddi eqqidi hawaareta guutha wodes kare kessana mela kiittis. ");
INSERT INTO gofRNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Hessafe guye, shiiqida asaakko, “Isra7eele asaw, ha asata bolla hintte oothanaw qoppiyabaappe naagettite. ");
INSERT INTO gofRNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ays giikko, hayssafe kase Tewodaasi bana, ‘Taani gita’ gidi denddin, oyddu xeetu gidiya asati iyara issifidosona. Shin iya wodhin iya kaallida ubbay laalettin pathonna asi gididi attidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Hessafe guye, asay taybettiya wode Galiila Yihudi denddidi daro asa panggayidi kaalethis, shin iyakka wodhin iya kaallida asa ubbay laalettis. ");
INSERT INTO gofRNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ha77ika ta hinttew odays; ha asatappe shaakettite; entta bochchofite. Ays giikko, ha qofaanne ha oosuwa asi oothiyabaa gidikko dhayana. ");
INSERT INTO gofRNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Shin ha qofaynne ha oosoy Xoossafe yidabaa gidikko, hintte entta dhayssanaw dandda7ekketa. Geellada yaanishe hintte Xoossaara kaccettana” yaagidi odis. Hessa gisho, shiiqida asay Gamaaliyale zoriya ekkidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Hawaareta soo xeegidi lisson garaafisis. Hessafe guye, enttako, “Yesuusa sunthaa nam77antho denthofite” gidi birshshi yeddidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Yesuusa sunthaa gisho entti kawuyanayssi bessiyabaa gideyssa erida gisho shangguwa sinthafe ufayttishe keyidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Entti ubba wode Xoossa keethaninne asaa son Yesuusi I Kiristtoosa gideyssa tamaarssonne sabbako aggibookona. ");
INSERT INTO gofRNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","He wode kaalleyssata tayboy dari dari bishin, Girike doona odettiya Ayhudeti Yihudan yelettidi de7iya Ayhudeta bolla zuuzummidosona. Ays giikko, Girike doona odettiya Ayhudeti, “Gallas gallas imettiya kathan nu am77eti naaqettosona” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Tammanne nam77u hawaareti woosa keethaa asa ubbaa xeegidi, “Nuuni Xoossaa qaala odeyssa aggidi kathi gishanaw nuus bessenna. ");
INSERT INTO gofRNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Hiza, ishato, lo77o asata, Geeshsha Ayyaananinne cinccatethan kumida laappun asata hintte giddofe doorite; nuuni entta ha oosuwas shuumana. ");
INSERT INTO gofRNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Shin nuuni, nu kumetha wodiya Xoossaa woosaninne qaala tamaarsson peeshshana” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Hawaareti odida oday asa ubbaa ufayssis. Hessa gisho, ammanoynne Geeshsha Ayyaani kumida Isxifaanose, Filphoosa, Phirokoroosa, Niqaarone, Ximoona, Pharmmeenanne Ayhude ammano geli simmida Anxookiya Niqolawoosa dooridosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Entta hawaareta sinthan essin, hawaareti entta bolla kushe wothidi Xoossaa woossidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Xoossaa qaalay dalggi dalggi bis. Yerusalaamen de7iya ammaneyssata tayboy dari dari bis; daro kahinetikka ammanidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Isxifaanosey aadho keehatethaaninne wolqqan kumidi asaa giddon oorathabatanne malaatata oothees. ");
INSERT INTO gofRNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Aylletethafe keyida Ayhude Woosa Keetha asay Qereenappenne Iskkinddiriyappe Kilqiyafenne Iisiyappe yida issi issi asati denddidi Isxifaanosera palamidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Shin Isxifaanosey Ayyaana wolqqan odettiya cinccatethaa entti eqettanaw dandda7ibookkona. ");
INSERT INTO gofRNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","He wode entti, “Musenne Xoossaa I cayishin si7ida” giya worddo asata shammidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Hessada oothidi biitta cimatanne higge asttamaareta iya bolla denthidosona. Isxifaanose oykkidi Shangguwa sinthe efidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Iya bolla paydida worddo markkati, “Ha uray ha Xoossa Keethanne Muse higgiya zaari zaari cayees. ");
INSERT INTO gofRNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","I, ‘Hayssi Naazirete Yesuusi, ha Xoossa Keethaa laallana; qassi Musey nuus immida higgiya laammana’ yaagishin nuuni si7ida” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Shanggo shiiqon uttida asa ubbay Isxifaanose loythidi xeelliya wode iya som77oy kiitanchcho som77o daanees. ");
INSERT INTO gofRNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Kahineta halaqay Isxifaanosekko, “Hayssi tumee?” yaagidi oychchis. ");
INSERT INTO gofRNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Isxifaanosey, “Ta ishato, ta aawato, si7ite! Nu aawa Abrahamey Kaaranen daanaw baanappe sinthe Masephexoomiyan de7ishin, bonchcho Xoossay iyaw qonccidi, ");
INSERT INTO gofRNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","‘Ne biittaafenne ne dabbotappe shaakettada taani nena bessiya biittaa ba’ yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","He wode Abrahamey Kalddaaweta biittaafe keyidi Kaaranen daanaw bis. Iya aaway hayqqidaappe guye Xoossay iya ha biittaa ha77i hintte de7iya bessaa ehis. ");
INSERT INTO gofRNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","I ha biittaafe hari attoshin tohoy yedhdhiya bessika Abrahames immibeenna. Shin na7i iyaw baynna wode Xoossay ha biittaa iyawunne iya sheeshaas laata oothidi immanayssa qaala gelis. ");
INSERT INTO gofRNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Xoossay Abrahamekko, ‘Ne sheeshay hara biittan imathatethan daana; yan oyddu xeetu laythi entti aylletethan haarettana. ");
INSERT INTO gofRNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Shin taani ne sheeshaa haariya deriya bolla pirddana. Hessafe guye, entti he biittaafe keyidi hayssan taw goynnana’ yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Xoossay Abrahame sheeshay qaxxarettana mela iyara caaqqin, Yisaaqi yelettida hosppuntha gallasan qaxxaris. Yisaaqi Yayqooba qaxxaris; qassi Yayqoobi tammanne nam77u ba nayta, nu aawata mayzata qaxxaris. ");
INSERT INTO gofRNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Yayqooba nayti Yoosefa qanaattidi Gibxxe biittan aylletethas bayzidosona, shin Xoossay iyara de7ees. ");
INSERT INTO gofRNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Iya, iya waaye ubbaafe kessis. Gibxxe kawuwa sinthan sabanne cinccatethi iyaw immis. Gibxxe kawoy Yoosefas Gibxxe biittaanne ba keetha ubbaa aysanaada halaqatethi immis. ");
INSERT INTO gofRNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Gibxxe biittaninne Kanaane biitta ubban koshi gelidi daro asaa un77ethis. He wode nu mayzati kathi demmanaw dandda7ibookkona. ");
INSERT INTO gofRNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Yayqoobi Gibxxe biittan kathi de7eyssa si7idi nu aawata koyro yaa yeddis. ");
INSERT INTO gofRNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Nam77antho buussan Yoosefi ba ishatas banatethaa erisis. Gibxxe kawoykka Yoosefa sheeshaa eris. ");
INSERT INTO gofRNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Yoosefi ba aawa Yayqoobanne ba dabbo ubbaa, laappun tammanne ichchashu asaa baakko yaana mela kiittidi ehisis. ");
INSERT INTO gofRNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Yayqoobi Gibxxe biittaa wodhdhis; inne iya nayti yan hayqqidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Entta ahay he bessaafe Seekeme biittaa tookettidi bidi, yan Abrahamey Hamoore naytappe daro biran shammida duufon moogettis. ");
INSERT INTO gofRNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Shin Xoossay Abrahames immana gidayssa poliya wodey gakkanaw matida wode Gibxxe biittan de7iya nu asay dari dari bis. ");
INSERT INTO gofRNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Hessafe guye, Yoosefa eronna hara kawoy Gibxxe biittan kawotis. ");
INSERT INTO gofRNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","He kawoy nu zerethaa genidi guutha nayti hayqqana mela entta kare kessi yeggana mela nu aawata un77ethis. ");
INSERT INTO gofRNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“He wode Musey yelettis; I Xoossaa sinthan daro lo77o na7a. Ba aawa keethan heedzu ageena gakkanaw diccis. ");
INSERT INTO gofRNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Musey wora holettida wode Gibxxe kawuwa na7iya demma ekkada ba na7a oothada iya dichchasu. ");
INSERT INTO gofRNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Musey Gibxxeta cinccatetha ubbaa tamaaridi odaninne ooson mino asi gidis. ");
INSERT INTO gofRNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Muses laythay oytama kumida wode ba ishata, Isra7eeleta be7anaw ba wozanan qoppis. ");
INSERT INTO gofRNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Isra7eelatappe issuwa Gibxxe issoy qohishin be7idi he Isra7eele uraa maaddidi, he qohida Gibxxe uraa wodhidi kushe zaaris. ");
INSERT INTO gofRNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Musey ba ishata ba baggara Xoossay ashshanaw haneyssa entti akeekana gidi qoppis, shin entti akeekibookkona. ");
INSERT INTO gofRNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","“Wonttetha gallas nam77u Isra7eele asati issoy issuwara wadhettishin demmidi entta sigethanaw koyidi, ‘Asato, hintte ishantta; ays issoy issuwa qohetii?’ yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Shin ba laggiya qoheyssi Musekko, ‘Nena nu bolla haareyssanne daynna oothiday oonee? ");
INSERT INTO gofRNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Neeni zine Gibxxe uraa wodhidayssada tana wodhanaw koyay?’ yaagidi Muse sugi yeddis. ");
INSERT INTO gofRNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Musey hessa si7ida wode Gibxxefe betidi Miidiyaame biittan bete asi gididi de7ishe nam77u adde nayta yelis. ");
INSERT INTO gofRNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Godaa kiitanchchoy oytamu laythafe guye Siina Deriya matan de7iya bazzo tushiya giddon eexiya tama laco giddon Muses benttis. ");
INSERT INTO gofRNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Musey ba be7idayssan malaalettidi, loythi be7anaw tushiya mati shiiqidi de7ishin, Godaa qaalay, ");
INSERT INTO gofRNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Taani ne aawata, Abrahame Xoossaa, Yisaaqa Xoossaa, Yayqooba Xoossaa’ yaagishe Musekko yis. Musey yashshan kokkoridi xeellanaw dandda7ibeenna. ");
INSERT INTO gofRNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Goday Musekko, ‘Neeni eqqida biittay geeshshi gidiya gisho ne tohuwan de7iya caammaa kessa. ");
INSERT INTO gofRNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Taani Gibxxen de7iya ta asaa un77etethaa be7as. Entta waasuwa si7ada entta ashshanaw wodhdhas. Ha77i haaya! Taani nena Gibxxe kiittana’ yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Isra7eeleti Muse, ‘Nena nuna haareyssanne daynna oothiday oonee?’ yaagidi ixxidayssa tushiya giddon iyaw benttida kiitanchchuwa baggara haareyssanne ashsheyssa oothidi Xoossay kiittis. ");
INSERT INTO gofRNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Musey Isra7eeleta Gibxxefe kessidi malaalisiyabatanne oorathabata Gibxxe biittaninne Zo7o Abban oothidi entta oytamu laythi bazzo biittan kaalethis. ");
INSERT INTO gofRNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Isra7eele asaakko, ‘Xoossay tana denthidayssada hintte sheeshaa giddofe ta mela nabe hinttew denthana’ yaagiday he Muse. ");
INSERT INTO gofRNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Bazzo biittan shiiqida Isra7eele asaara de7idayssi, nu aawataranne Siina Deriya bolla iyaw odida kiitanchchuwara de7ida Musey iya. Yaatidi, Xoossaa de7o qaala nuus immanaw ekkis. ");
INSERT INTO gofRNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Shin nu mayzati Muses kiitettanaw dosibookkona; iya ixxidi guye Gibxxe simmanaw amottidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Qassi Aaronakko, ‘Nuna kaalethiya xoossata nuus ootha. Ays giikko, hayssi nuna Gibxxefe ehida Musey, waanidaakko nuuni erokko’ yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","He wode mari daanisidi eeqa oothidosona. He eeqaas yarshsho yarshshidi bantta kushen oothida oosuwan ufayttidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Shin Xoossay enttaw zokko zaaris. Entti salo xoolinttota goynnana mela entta yeggi aggis. Nabeta maxaafan, ‘Isra7eele asaw, oytamu laythi kumethi bazzo biittan shukkida mehiyanne yarshshida yarshshuwa taw yarshshidetii? ");
INSERT INTO gofRNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Hinttee, hinttew goynnanaw kessida eeqaanne Moloke dunkkaaniya Refaana giya hintte xoossaa xoolintto misiliya tookkideta. Taani hinttena Baabilooneppe hini bagga yeddana’ geetettidi xaafettis. ");
INSERT INTO gofRNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Nu aawatas bazzo biittan markka dunkkaaney de7ees. Iyakka Xoossay Muse kiittidayssadanne iya bessidayssada oothis. ");
INSERT INTO gofRNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Qassi nu aawati he dunkkaaniya bantta aawatappe ekkidi Xoossay kase yedethida Ayhude gidonna asaa biittaa oykkida wode Iyyaasura yaa ekkidi gelidosona. He dunkkaaney Dawite wode gakkanawukka he bessan de7is. ");
INSERT INTO gofRNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Dawitey Xoossan sabettis. Qassi Yayqooba Goday de7ana keethaa keexanaw Xoossaa woossis. ");
INSERT INTO gofRNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Shin iyaw keethaa keexiday Solomone. ");
INSERT INTO gofRNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Hanoshin, Ubbaafe Bolla Xoossay asi keexida keethan deenna. Nabey gidayssa mela, ");
INSERT INTO gofRNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Saloy ta araata, sa7aykka ta tohoy yedhdhiyaso. Yaatin, taw hintte ay mela keethi keexanee? Woykko taani shemppiyasoy awunee? ");
INSERT INTO gofRNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ha ubbaa ta kushiyan oothabiikkinaa?’ yaagees Goday. ");
INSERT INTO gofRNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Hintte waanida si7onna asee? Hintte wozanay Xoossaa qaala ekkanaw ays ixxide? Hintte haythay ays tullidee? Hinttee, hintte aawatatho ubba wode Geeshsha Ayyaanaara eqetteeta. ");
INSERT INTO gofRNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Nabeta giddofe hintte aawati gooddonnay oonee? Xoossaa Na7ay, Xilloy yaanayssa kasetidi odidayssata wodhidosona. Ha77i hintte iya aathi immidi wodhideta. ");
INSERT INTO gofRNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Hintte kiitanchchuwa kusheppe Xoossaa higgiya ekkideta, shin kiitettibeekketa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Entti hessa si7ida wode bantta wozanan Isxifaanose bolla daro yilottidi, bantta mettershshaa saxxidi manddidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Shin Isxifaanosey Geeshsha Ayyaanan kumidi, salo pude xeellidi, Xoossaa bonchchuwanne Yesuusa Xoossaa ushachcha baggan eqqidayssa be7is. ");
INSERT INTO gofRNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","“Hekko, taani saloy dooyettin, Asa Na7ay, Xoossaa ushachcha baggan eqqidayssa be7ays” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Qaalaa dhoqqu oothidi waassishe, bantta haythaa oykkidi issife iyaakko woxxidosona ");
INSERT INTO gofRNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Iya katamaappe gaxa kessidi, shuchchan caddidosona. Markkati bantta ma7uwa issi Saa7ola giya na7atethaa matan wothidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Isxifaanosey, “Ta Godaa Yesuusaa, ta shemppuwa ekka” yaagidi xeegishin entti iya shuchchan caddoosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Gulbbatidi, ba qaala dhoqqu oothidi, “Ta Godaw, ha nagaraa enttaw atto ga” yaagis. Hessa yaagidi simmida mela hayqqi aggis. ");
INSERT INTO gofRNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saa7oli Isxifaanose hayquwan ufayttis. He gallas Yerusalaamen de7iya woosa keethan gita goodi denddis. Hawaareti attin ammaneyssati ubbay Yihuda biittaninne Samaare biittan laalettidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Issi issi Xoossaa asati Isxifaanose moogidosona; qassi iyaw daro yeekkidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Shin Saa7oli woosa keethaa dhayssanaw koyees. Soo soo yuuyi gelidi, ammaniyaa addetanne maccasata goochchi goochchi kessidi qasho keethi gelssees. ");
INSERT INTO gofRNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Laalettida ammaneyssati bida bessa ubban qaala odidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filphoosi Samaare katamaa bidi Kiristtoosabaa asaas odis. ");
INSERT INTO gofRNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Daro asay Filphoosi gidayssa si7ida wodenne I oothiya malaatata be7ida wode iya akeekidi si7idosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Tuna ayyaanati waassidi daro asaappe keyidosona; qassi daro gunddatinne wobbeti bilettidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","He kataman de7iya asay daro ufayttidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Shin Simoona giya issi uray he kataman de7ees. I, ‘Bana gita’ gidi Samaare asaa marotethan malaalisishe gam77is. ");
INSERT INTO gofRNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Guuthafe gita gakkanaw de7iya asa ubbay, “Gita Xoossaa wolqqay hayssa” gidi iyabaa si77oosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Daro wodeppe doomidi marotishe Samaare asaa malaalisida gisho asay iyabaa si7oosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Shin Filphoosi Xoossaa kawotethaabaanne Yesuus Kiristtoosa sunthabaa addetasinne maccatas odin, entti iyabaa ammanidi xammaqettidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Qassi Simoonikka ba huu7en ammanidi xammaqettis. Filphoosara issife bida bessa ubban oosettiya gita malaatata be7idi malaalettis. ");
INSERT INTO gofRNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Yerusalaamen de7iya hawaareti Samaare asay Xoossaa qaala ekkidayssa si7ida wode Phexiroosanne Yohaannisa enttako yeddidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Phexiroosinne Yohaannisi bidi, ammaneyssati Geeshsha Ayyaana ekkana mela enttaw Xoossaa woossidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Ays giikko, Samaare asati Godaa Yesuusa sunthaa xalaalan xammaqettidosonappe attin enttafe issuwa bollaka Geeshsha Ayyaani wodhdhibeenna. ");
INSERT INTO gofRNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","He wode Phexiroosinne Yohaannisi bantta kushiya entta bolla wothin, entti Geeshsha Ayyaana ekkidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Hawaareti bantta kushiya entta bolla wothin, enttaw Geeshsha Ayyaanay imettidayssa Simooni be7ida wode Phexiroosasinne Yohaannisas miishe ehidi, ");
INSERT INTO gofRNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Taanikka ta kushiya wothiya ubbay Geeshsha Ayyaana ekkana mela ha maata tawukka immerkketi” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Shin Phexiroosi iyaakko, “Neeni Xoossaa imotaa miishen shammanaw qoppida gisho ne miishey neera dhayo. ");
INSERT INTO gofRNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ne wozanay Xoossaa sinthan suure gidonna gisho new hayssan gishoy woykko qaadi baawa. ");
INSERT INTO gofRNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Hiza, ha ne wozanaa iitatethaa gisho nagaraappe simma. Ne wozanan de7iya iita qofaa Xoossay atto gaana mela Xoossaa woossa. ");
INSERT INTO gofRNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Gaasoykka, neeni iita qanaateninne nagara qashuwan de7eyssa taani be7ays” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simooni zaaridi, “Hintte gidayssafe issoykka tana gakkonna mela taw Xoossaa woossite” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Phexiroosinne Yohaannisi markkattidaappenne Godaa qaala odidaappe guye Yerusalaame simmidosona. Samaaren de7iya daro gutatan Wonggelaa odidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Godaa kiitanchchoy Filphoosakko, “Denddada Yerusalaameppe Gaaza efiya bazzo biitta ogiyakko ba. He ogey dugeha baggara de7ees” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Filphoosi denddidi bis. Hinddeke giya Tophphiya kawees I miishe ubbaa naagiya Tophphiya asi de7ees. Ikka goynnanaw Yerusalaame bis. ");
INSERT INTO gofRNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Para gaariyan uttidi, Yerusalaameppe ba biittaa simmishe nabiya Isayaasa maxaafaa nabbabees. ");
INSERT INTO gofRNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Geeshsha Ayyaanay Filphoosakko, “He gaariyakko bada iya mati shiiqa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Yaatin Filphoosi woxxi bidi gakkiya wode moorinnay nabiya Isayaasa maxaafappe nabbabishin si7idi, “Ne nabbabeyassi new geli?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Moorinnay, “Taw odi gelssiya asi baynna waanidi gelanee?” yaagis. Baara gaariyan keyidi uttana mela Filphoosa woossis. ");
INSERT INTO gofRNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Moorinnay nabbabiya maxaafaa kifiley, “I dorssada shukettanaw laagettis; Dorssa mari ba ikisiya meedeyssata sinthan si77i geyssada, ikka ba doona dooyibeena. ");
INSERT INTO gofRNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","I kawuyis; iyaw xillo pirddi dhays. iya de7oy ha sa7aappe qanxettida gisho iya sheeshaabaa oone odanay?” yaagees. ");
INSERT INTO gofRNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Moorinnay zaaridi Filphoosakko, “Nabey odebaa odi? Babaa odiyye woykko hara asabaa odi? Taw odarkkii” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Filphoosi zaaridi, Xoossaa qaala he bessaafe doomidi, Yesuusabaa odiya Wonggelaa iyaw odis. ");
INSERT INTO gofRNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Entti bishe haathi de7iyaso gakkidosona. Moorinnay, “Haathe hayssa be7a; ta xammaqettonna mela aybi diggii?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filphoosi iyaakko, “Neeni ne kumetha wozanaappe ammanikko dandda7aasa” yaagis. I zaaridi, “Yesuus Kiristtoosi Xoossaa Na7aa gideyssa taani ammanays” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Gaarey eqqana mela moorinnay kiittin, nam77ay wodhdhidi haathan gelidosona; Filphoosi iya xammaqis. ");
INSERT INTO gofRNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Entti haathaafe gaxa keyida wode Godaa ayyaanay Filphoosa qopponna ekkis. Nam77antho moorinnay Filphoosa be7ibeenna, shin ba ogiya ufayttishe bis. ");
INSERT INTO gofRNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filphoosi Azaaxonan bana demmis. Qassi Qisaariya yaana gakkanaw katamatan yuuyidi Wonggelaa markkattis. ");
INSERT INTO gofRNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","He wode Saa7oli Godaa kaalleyssata wodhanaw manddidi kahine halaqaakko bis. ");
INSERT INTO gofRNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Godaa ogiya kaalliya addetanne maccata demmiko, qachchishe Yerusalaame ehanaw, Damasqqon de7iya Ayhude Woosa Keethatas dabddaabbey xaafettana mela iya woossis. ");
INSERT INTO gofRNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","I bidi, Damasqqo katamaa gakkanaw matishin, qopponna saloppe wolqqaama poo7oy iya yuushuwan poo7is. ");
INSERT INTO gofRNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","I sa7an kunddidashin, “Saa7olaa, Saa7olaa, ays tana goodday?” giya qaala si7is. ");
INSERT INTO gofRNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Saa7oli, “Godaw, neeni oonee?” yaagidi oychchis. “Taani, neeni gooddiya Yesuusa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Shin Saa7oli kokkorishenne malaalettishe, “Godaw, taani ay oothana mela koyay?” yaagis. Goday iyaakko, “Denddada katamaa gela; neeni oothanaw bessiyabay yan new odettana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Saa7olara ogiya biya asati aykkoka odettonna eqqi attidosona. Qaalaa si7oosona, shin oonakka be7ibookkona. ");
INSERT INTO gofRNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saa7oli kunddida bessaafe denddidi xeelliya wode iya ayfey demmonna ixxis. Hessa gisho, entti iya kushiya oykkidi kaalethidi Damasqqo gelssidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Heedzu gallas gakkanaw I xeellanaw dandda7ibeenna; aykkoka mibeenna; uyibeenna. ");
INSERT INTO gofRNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damasqqon issi Hananiya giya Yesuusa tamaarey de7ees. Goday qonccethan, “Hananiya” yaagidi xeegis. Hananey zaaridi, “Ta Godaw, hayssan de7ays” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Goday iyaakko, “Denddada Suure geetettiya ogiya bada, Yihuda son Saa7ola giya terseseppe yida uraa koya; Saa7oli woossees. ");
INSERT INTO gofRNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Qassi Hananey gelidi, Saa7oli nam77antho xeellana mela ba kushiya iya bolla wothishin qonccethan be7is” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Hananey zaaridi, “Godaw, Yerusalaamen ne geeshsha asaa bolla he uray ay mela iitabaa oothidaakko taani daro asaappe si7as. ");
INSERT INTO gofRNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Qassi Damasqqon ne sunthaa xeegeyssata ubbaa qachchanaw, kahine halaqati iyaw maata immidosona” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Shin Goday iyaakko, “Saa7oli Ayhude gidonna asaa sinthan, kawota sinthaninne Isra7eele asaa sinthan, ta sunthaa erisanawunne taw oothanaw doorettida miishe gidiya gisho neeni iyaakko ba. ");
INSERT INTO gofRNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ays giikko, ta sunthaa gisho I ay mela waaye ekkanaw bessiyako taani iya bessana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Hananey bidi, soo gelidi, ba kushiya Saa7ola bolla wothidi, “Ta ishaa Saa7ola, neeni yaa ogiyan new benttida Godaa Yesuusi, neeni xeellana melanne Geeshsha Ayyaanan kumana mela tana kiittis” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ellesidi, Saa7ola ayfiyaappe issi poqo melabay wodhdhin, Saa7oli nam77antho xeellis. Qassi denddidi xammaqettis. ");
INSERT INTO gofRNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Kathi midi xaalidi, Damasqqon de7iya ammaneyssatara guutha gallas gam77is. ");
INSERT INTO gofRNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ellesidi Saa7oli, “Yesuusi Xoossaa Na7a” yaagidi Damasqqon de7iya Ayhude Woosa Keethatan qaala tamaarssis. ");
INSERT INTO gofRNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Hessa si7ida ubbay malaalettidi, “Hayssi Yerusalaamen Yesuusa sunthaa xeegeyssata qachcheyssa gidenneyye? Qassi haa yiday entta qachchidi, kahine halaqata sinthe efanaassa gidennee?” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Shin Saa7oli qaala odon minni minni bis. Yesuusi, I Kiristtoosa gideyssa qonccisidi odida gisho Damasqqon de7iya Ayhudeti iyaw zaariyaba dhayidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Daro gallasappe guye Ayhudeti shiiqidi, Saa7ola wodhanaw zorettidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Shin Ayhudeti bana wodhanaw qoppidayssa Saa7oli si7is. Entti iya wodhanaw qammanne gallas katamaa penggiyan naagoosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Shin iya tamaareti iya qamma efidi, gimbbe dirssaa maskkotiyara daachchora wodhisidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Saa7oli Yerusalaame gakkida wode ammaneyssatara gahettanaw koyis. Shin I Kiristtoosa ammanidayssi enttaw tuma daanonna ixxin iyaw yayyidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Shin Barnnabaasi Saa7ola hawaaretakko efis. Ogen Goday waanidi qonccidaakkonne haasayisidaakko, qassi Saa7oli Damasqqon Yesuusa sunthan yayyonna waattidi qaala odidaakko enttaw geeshshidi odis. ");
INSERT INTO gofRNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Saa7oli Yerusalaamen yuuyidi Godaa sunthan yayyonna qaala odishe, hawaaretara issife de7is. ");
INSERT INTO gofRNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Qassi Saa7oli Girike qaala haasayaa Ayhudetara odettishe palamees. Shin entti iya wodhanaw koyidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ammaniya asati hessa si7idi, Saa7ola Qisaariya efidi Terseese yeddidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Yihudan, Galiilaninne Samaare ubban de7iya woosa keethati sarotethaan de7idosona. Qassi minnidosona; Godaas yayyishe Geeshsha Ayyaana minthethuwan dari dari bidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Phexiroosi biitta ubbaa yuuyishe Liidan de7iya ammaniyaa asatakko gakkis. ");
INSERT INTO gofRNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Yan hosppun laythi kumethi gunddidi arssan zin77idi de7iya Eeniya giya addiya demmis. ");
INSERT INTO gofRNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Phexiroosi, “Eeniya, Yesuus Kiristtoosi nena pathana; denddada ne hiixa dentha” yaagis. Ikka ellesidi denddi eqqis. ");
INSERT INTO gofRNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Liidaninne Saaronan de7iya asa ubbay Eeniya be7idi, Godaakko simmidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Yoophe kataman issi Xaabito giya ammaniyaara de7awusu. (Xaabito guussay gen77e guussu) Iya ba de7ida wode ubban lo77obaa oothashenne manqota maaddashe de7asu. ");
INSERT INTO gofRNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","He wode iya harggada hayqqin, asay I ahaa meeccidi, pooqiya bolla kessidi zin77isidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Liidi Yoophes mata. Ammaneyssati Phexiroosi Liidan de7eyssa si7idi, “Hayyana nuukko ellessada ya” yaagiya kiitaa nam77u asata bolla iyaakko kiittidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Hessa gisho, Phexiroosi denddidi, enttara bis. Yaa gakkin, pooqiya bolla de7iya kifiliya iya gelssidosona. Am77eti Phexiroosa yuushuwan eqqidi yeekkishe Dorqqa enttara paxa de7ashe oothida qamisetanne afilata ubbaa Phexiroosa bessidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Phexiroosi entta ubbaa kare kessidi, gulbbatidi Xoossaa woossis. Qassi ahaako simmidi, “Xaabite, dendda” yaagis. Xaabita ba ayfiyaa dooyada Phexiroosa be7ada, dendda uttasu. ");
INSERT INTO gofRNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Phexiroosi iyo ba kushiyan maaddidi denthi essis. Hessafe guye, ammaneyssatanne am77eta xeegidi, denddidaaro entta sinthe shiishis. ");
INSERT INTO gofRNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ha oday Yoophe katama ubbaa gakkis. Daro asay Godaa ammanidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Phexiroosi Yoophen Simoona giya galbba haasheyssa son daro gallas gam77is. ");
INSERT INTO gofRNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Qisaariyan, “Xaale ola asata” geetettiya olanchchota giddon issi Qornneliyoosa geetettiya mato halaqay de7ees. ");
INSERT INTO gofRNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Qornneliyoosi ba soo asaara Xoossaa minthi ammaniyaa asinne Xoossaa goynniya asi. Ayhude manqotakka daro maaddees, qassi Xoossaa ubba wode woossees. ");
INSERT INTO gofRNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Issi gallas uddufun saate heeran Xoossaa kiitanchchoy iyaakko yidi, “Qornneliyoosaa” gidi xeegishin I qonccethan geeshshidi be7is. ");
INSERT INTO gofRNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Qornneliyoosi dagammidi kiitanchchuwa tishshi oothi xeellidi, “Godaw, I aybee?” yaagis. Kiitanchchoy zaaridi, “Ne woosaynne manqota ne maaddeyssi Xoossaa sinthan hassayettis. ");
INSERT INTO gofRNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Ha77i Yoophe ase kiittada, Phexiroosa giya Simoona ehisa. ");
INSERT INTO gofRNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Phexiroosi abbaa doonan galbba haashiya Simoona son imathatethi siiratis” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Qornneliyoosi baw odida kiitanchchoy bin, ba aylletappe nam77atanne Xoossaa goynniya ba mata wotaaddaretappe issuwa xeegidi, ");
INSERT INTO gofRNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","enttaw ubbabaa odidi Yoophe kiittis. ");
INSERT INTO gofRNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Wonttetha gallas entti bidi, Yoophe katama matishin usuppun saate heeran Xoossaa woossanaw Phexiroosi pooqe bolla keys. ");
INSERT INTO gofRNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","I koshattidi kathi maanaw koyis, shin kathi kaxishin I qonccethi be7is. ");
INSERT INTO gofRNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Saloy dooyettin, gita afila daaniyabay oyddu baggara oykettidi wodhdhishin I be7is. ");
INSERT INTO gofRNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Iyan oyddu tohora de7iya meheti, wora do7ati, ulora gooshettiya medhetethatinne salo kafoti ubbay de7ees. ");
INSERT INTO gofRNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","He wode “Phexiroosaa, dendda eqqada shukkada ma” giya qaali iyaakko yis. ");
INSERT INTO gofRNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Shin Phexiroosi, “Godaw, akkay! Ta tunabaa ubbarakka ma erikke” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Qassi, “Xoossay geeshshidayssa neeni tuna gooppa” giya qaali nam77antho iyaakko yis. ");
INSERT INTO gofRNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Hessika, heedzu toho hanidaappe guye he gita afila daaneyssi ellesidi pude salo ekettis. ");
INSERT INTO gofRNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Phexiroosi ba be7ida qonccethaa birshshethay, “Ay gidanddeshsha?” gidi ba wozanan qoppishin, Qornneliyoosi kiittida asati Simoona soo oychchi demmidi karen eqqidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Bantta qaala dhoqqu oothidi, “Phexiroosa giya Simooni imathatethan de7ey hayssanee?” yaagidi oychchidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Phexiroosi qonccethan be7idabaa qofa bolla de7ishin, Geeshsha Ayyaani iyaakko, “Hekko, heedzu asati nena koyoosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Denddada wodhdha, taani entta kiittida gisho sidhonna enttara ba” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Phexiroosi asatakko wodhdhidi, “Hintte koyey tana; ays yidetii?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Entti zaaridi, “Nuna mato halaqay Qornneliyoosi kiittis. I xillo, Xoossaa goynniya asinne Ayhude asa ubban daro bonchchettida asi. Qornneliyoosi, nena ba soo ehisidi qaala neeppe si7ana mela geeshsha kiitanchchoy iyaw odis” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Phexiroosi asata soo gelssidi mokkis. Wonttetha gallas, denddidi enttara bis. Yoophe kataman de7iya ammaneyssatappe issoti issoti iyara issife bidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Wonttetha gallas, Qisaariya gakkidosona. Qornneliyoosi ba dabbotanne ba mata laggeta issife xeegi shiishidi, Phexiroosa naagees. ");
INSERT INTO gofRNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Phexiroosi soo gelana hanishin, Qornneliyoosi iyara gahettidi iya sinthan kunddidi iyaw goynnanaw koyis. ");
INSERT INTO gofRNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Shin Phexiroosi, “Dendda, takka ta huu7en ne mela ase” yaagidi iya denthis. ");
INSERT INTO gofRNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Phexiroosi Qornneliyoosara odettishe soo geliya wode daro asay shiiqidayssa demmis. ");
INSERT INTO gofRNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","I asaakko, “Ayhude asi hara derera issifanaw woykko gahettanaw woga gidonnayssa hintte ereeta. Shin taani oonakka tuna woykko geeshshi gidenna goonna mela Xoossay tana bessis. ");
INSERT INTO gofRNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Hessa gisho, hintte taakko kiittin ixoy baynna yas. Ha77i tana ays xeegisidaakko taw odite” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Qornneliyoosi, “Taani hachchi oyddu gallasappe kase hannoode uddufun saate woosa woossishin, phooliya ma7o ma77ida asi ta sinthan eqqis. ");
INSERT INTO gofRNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","I taakko, ‘Qornneliyoosa, Xoossay ne woosaa si7is, neeni manqota maaddidayssaka hassays. ");
INSERT INTO gofRNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Hiza, ase Yoophe kiittada, Simoon Phexiroosa geyssa xeegisa. I, Simoona giya galbba haashiya uraa son abbaa doonan siiratis’ yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Hessa gisho, taani neekko ellesada kiittas; ne lo77o yadasa. Hiza, Xoossay nena Kiittidaba ubbaa si7anaw ha77i nuuni ubbay hayssan Godaa sinthan de7oos” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Kaallidikka, Phexiroosi, “Xoossay asa som77o be7idi ase asappe shaakkenna. ");
INSERT INTO gofRNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Shin ase ubbaa oona gidikkoka baw yayyeyssanne xillo ooso ootheyssan Xoossay ufaytteyssa taani tuma akeekas. ");
INSERT INTO gofRNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Xoossay, ubbaa Goda gidida Yesuus Kiristtoosa baggara sarotethaa odishe ha Wonggelaa Isra7eele asaas kiittidayssa hintte ereeta. ");
INSERT INTO gofRNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Yohaannisi xinqqatebaa Galiilan sabbakida wodiyappe doomidi Yihuda biitta ubbaa gakkanaw hanidabaa hintte ereeta. ");
INSERT INTO gofRNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Xoossay Naazirete Yesuusas Geeshsha Ayyaananne wolqqaa immis. Xoossay iyara de7iya gisho lo77obaa I oothishe Xalahe kushen haarettida ubbaa pathishe yuuyis. ");
INSERT INTO gofRNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Ayhude biittaninne Yerusalaamen I oothida ubbabaas nuuni markkatta. Entti masqaliya bolla kaqqidi iya wodhidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Shin Xoossay heedzantho gallasan hayqoppe iya denthidi asaas qonccana mela oothis. ");
INSERT INTO gofRNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","He qonccethay Xoossay koyro doorida markkatassafe attin asa ubbaas gidenna. I hayqoppe denddidaappe guye iyara midanne uyida. ");
INSERT INTO gofRNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Nuuni Wonggelaa asaas odana melanne paxa de7eyssata bollanne hayqqidayssata bolla pirddanaw Xoossay shuumiday Yesuusa gideyssa markkattana mela nuna kiittis. ");
INSERT INTO gofRNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Xoossay iya ammaniyaa ubbaa nagaray, iya sunthan atto geetetteyssa nabeti markkattoosona” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Phexiroosi buroo he oda onggonnashin qaala si7iya ubbaa bolla Geeshsha Ayyaani wodhdhis. ");
INSERT INTO gofRNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Phexiroosara Yoophefe yida ammaniyaa qaxxarettida Ayhude ubbay, Ayhude gidonnayssata bolla Geeshsha Ayyaani gukkida gisho malaalettidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Gaasoykka, entti dumma dumma doonan haasayishininne Xoossaa gitatethaa sabbishin si7idosona. He wode Phexiroosi zaaridi, ");
INSERT INTO gofRNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Hayssati qassi nu mela Geeshsha Ayyaana ekkidayssati xammaqettonna mela haathe digganay oonee?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Entti Yesuus Kiristtoosa sunthan xammaqettana mela entta kiittis. Hessafe guye, entti banttara guutha gallas uttana mela Phexiroosa woossidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Hawaaretinne Yihuda ubban de7iya ammaneyssati, Ayhude gidonnayssatikka Xoossaa qaala ekkidayssa si7idosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Phexiroosi Yerusalaame bida wode qaxxarettida ammaneyssati, ");
INSERT INTO gofRNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","iyaakko, “Neeni qaxxarettiboonayssatakko gelada enttara kathi ays madii?” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Shin Phexiroosi hanidabaa koyroppe doomidi maaran maaran odis: ");
INSERT INTO gofRNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Taani Yoophe kataman Xoossaa woossashe qonccethi be7as. Gita afila daaniyabay oyddu baggara oykettidi saloppe wodhdhishe taakko yis. ");
INSERT INTO gofRNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Taani tishshi ootha iya giddo xeelliya wode oyddu tohora de7iya meheta, wora do7ata, ulora gooshettiya medhetethatanne salo kafota be7as. ");
INSERT INTO gofRNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","‘Phexiroosaa, dendda, shukkada ma’ giya qaala si7as. ");
INSERT INTO gofRNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Shin taani, ‘Godaw, akkay, tunabay woykko geeyonnabay ubbaka ta doonaakko shiiqi erenna’ yaagas. ");
INSERT INTO gofRNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“ ‘Xoossay geeshshidayssa neeni tuna gooppa’ yaagiya qaali nam77antho saloppe yis. ");
INSERT INTO gofRNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","“Hessi heedzu toho hanin, wurssethan ubbabay salo pude ekettis. ");
INSERT INTO gofRNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","He saatenkka heedzu asati Qisaariyappe taakko kiitettidi taani de7iya keetha gakki aggidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Sidhonna enttara baana mela Ayyaanai taw odis. Qassi ha usuppun ishati Yoophefe taara Qisaariya bidayssatara Qornneliyoosa soo gelida. ");
INSERT INTO gofRNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Kiitanchchoy iya son eqqidi, ‘Yoophe kiittada Phexiroosa geetettiya Simoona xeegisa. ");
INSERT INTO gofRNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Nenanne ne soo asa ubbaa ashshiya qaala I new odana’ gidayssa Qornneliyoos nuus odis. ");
INSERT INTO gofRNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Taani haasaya doomiya wode Geeshsha Ayyaanay koyro nu bolla wodhdhidayssada entta bollaka wodhdhi aggis. ");
INSERT INTO gofRNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","He wode ‘Yohaannisi haathan xammaqis, shin hintte Geeshsha Ayyaanan xammaqettana’ yaagida Godaa qaalay taw qofettis. ");
INSERT INTO gofRNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Xoossay nuus Godaa Yesuus Kiristtoosa ammanidayssatas immida imotaa Ayhude gidonnayssataska immiko, yaatin Xoossaa digganaw taani oonee?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Entti hessa si7ida wode bantta palamaa aggidi, “Hesaa gidikko, Xoossay Ayhude gidonnayssatikka nagarappe simmidi de7on daanada qaada immis” yaagidi Xoossaa galatidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Isxifaanose hayqos gathida gooda gaason laalettida ammaneyssati qaala Ayhudeta xalaalas odishe Siroofinqe, Qoophiroosanne Anxookiya gakkanaw yuuyidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Shin Qoophiroosappenne Qereenaappe yida issi issi ammaniyaa asati Anxookiya bidi, Godaa Yesuusa Wonggelaa Girike asaaskka odidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Godaa wolqqay enttara de7ees; qassi daro asay ammanidi Godaakko simmidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","He odaa Yerusalaamen de7iya woosa keethay si7ida gisho Barnnabaasa Anxookiya kiittis. ");
INSERT INTO gofRNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Barnnabaasi Anxookiya bida wode Xoossaa aadho keehatethaa oosuwa be7idi ufayttis. Entti ubbay bantta kumetha wozanan Godan minnidi daana mela entta zoris. ");
INSERT INTO gofRNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnnabaasi Geeshsha Ayyaanaynne ammanoy kumida lo77o asi gidiya gisho daro asay Godaa ammanidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Hessafe guye, Barnnabaasi Saa7ola koyanaw Terseese bis. ");
INSERT INTO gofRNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Yan Saa7ola demmida wode Anxookiya ekkidi yis. Barnnabaasinne Saa7oli woosa keetha asaara laythi kumethi uttidi daro asaa tamaarssidosona. Ammaneyssati Anxookiyan “Kiristtaane” geetettidi koyro xeegettidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","He wode issi issi nabeti Yerusalaameppe Anxookiya wodhdhidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Entta giddofe Agaboosa geyssi denddidi biitta ubban gita koshi keyanayssa Ayyaana wolqqan tinbbite odis. Hessi haniday Roome Kawuwa Qalawudiyoosa wodena. ");
INSERT INTO gofRNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ammaneyssati huu7en huu7en bantta wolqqaa mela miishe kessidi Yihudan de7iya ammaneyssatas maade yeddanaw qofa qachchidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Entti hessada oothidi, miishiya Barnnabaasa bollanne Saa7ola bolla woosa keethaa cimatas yeddidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","He wode Kawoy Heroodisi woosa keetha asaappe baggaa gooda doomis. ");
INSERT INTO gofRNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Yohaannisa ishaa Yayqooba mashshan wodhisis. ");
INSERT INTO gofRNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Hessi Ayhudeta ufayssidayssa be7idi, gujjidi Phexiroosakka oythis. Hessi haniday Paasika Baale bonchchiya gallasatana. ");
INSERT INTO gofRNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Phexiroosa oykkidi qachchis. Paasika bonchchiya gallasatappe guye deriya sinthe aathanaw qoppidi, oyddu oyddu wotaaddareti iya naagana mela tammanne usuppun wotaaddaretas aathi immis. ");
INSERT INTO gofRNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Hessa gisho, Phexiroosi qasho keethan naagettees. Shin woosa keetha asay iyaw minthidi Xoossaa woossosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Heroodisi Phexiroosa asaa sinthe shiishanaappe kase qamma Phexiroosi nam77u baggara nam77u wotaaddaretara santhalaatan qashettidi entta giddon dhiskkis. Naageyssati qasho keethaa penggetan eqqidi naagoosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Akeekonna de7ishin Godaa kiitanchchoy qonccis. Qasho keethan poo7oy poo7is. Kiitanchchoy Phexiroosa miyaa bochchi barkkisidi, “Elle dendda” yaagis. Iirakka santhalaatay iya kushiyappe wodhdhi aggis. ");
INSERT INTO gofRNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Kiitanchchoy iyaakko, “Ne ma7uwa ma77a, ne caammaaka aatha” yaagis. Phexiroosi hessada oothis; kiitanchchoy, “Ne laxana ma77ada tana kaalla” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Phexiroosi qasho keethafe keyidi kiitanchchuwa kaallis. Iyaw qonccethi be7iyabaa daanisippe attin kiitanchchoy oothiyabay tuma daanibeenna. ");
INSERT INTO gofRNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Kiitanchchoynne Phexiroosi koyruwanne nam77antho wotaaddariya aadhdhidi katamaa efiya biraata penggiyako gakkidosona. Penggey enttaw barkka dooyetti aggis. Entti keyidi issi ogiyara bishin kiitanchchoy akeekonna Phexiroosappe shaaketti aggis. ");
INSERT INTO gofRNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Phexiroosas wozani simmin, “Tana Goday ba kiitanchchuwa kiittidi, Heroodisa kusheppenne naagidi uttida Ayhude asa ubbaafe ashshidayssa ha77i tuma eras” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","I hessa akeekida wode daro asay issife shiiqidi Xoossaa woossiya bessaa, Marqqoosa giya Yohaannisa aaye Mayraami soo bis. ");
INSERT INTO gofRNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Yan karen eqqidi xeegis. Issi Rooda giya oosanchchiya penggiya dooyanaw yasu. ");
INSERT INTO gofRNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Rooda Phexiroosa qaala gididayssa erida wode ufayssan kumada kariya dooyenna guye woxxa bada, “Phexiroosi karen eqqis” yaagada asaas odasu. ");
INSERT INTO gofRNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Asay iikko, “Neeni gooyay!” yaagidosona. Rooda Phexiroosa gididayssa geeshshada odasu. Entti, “Hessi iya naagiya kiitanchchuwa” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Shin Phexiroosi karen eqqidi xeegidi aggonna ixxin asay kariya dooyidi iya be7idi malaalettidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Shin entti si77i gaana mela Phexiroosi ba kushiyan mallidi Goday qasho keethafe iya waati kessidaakko enttaw qonccisi odidi, “Hayssa Yayqoobasinne ammaniyaa asatas odite” gidi yaappe keyidi harasoo bis. ");
INSERT INTO gofRNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Sa7i wonttiya wode “Phexiroosi aw bide” gidi wotaaddareti woli giddon daro kaccidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Heroodisi Phexiroosa koyisin, I dhayida wode naageyssata qoridi, entta wodhana mela kiittis. Hessafe guye, Heroodisi Yihudappe Qisaariya wodhdhidi yan guutha wode uttis. ");
INSERT INTO gofRNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Heroodisi Xiroosa asaa bollanne Sidoona asaa bolla daro hanqettis. Entta biittay kathi Heroodisa biittaafe demmiya gisho entti issife gididi iya moorinnaa Bilasxoosa banttaw cima oothidi giiganaw Heroodisakko bidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Heroodisi sunthida gallasan ba kawotethaa afilaa ma77idi, araata bolla uttidi asaas odis. ");
INSERT INTO gofRNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Asay, “Hessi Xoossaa qaala, asa qaala gidenna” yaagidi waassidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Heroodisi Xoossaa bonchchiboonna gisho iirakka Godaa kiitanchchoy iya dechchin guxunen meetettidi hayqqis. ");
INSERT INTO gofRNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Shin Xoossaa qaalay diccishenne dalggishe bees. ");
INSERT INTO gofRNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barnnabaasinne Saa7oli bantta oosuwa polidi Marqqoosa giya Yohaannisa banttara ekkidi Yerusalaameppe simmidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Anxookiyan de7iya woosa keethan nabetinne asttamaareti de7oosona. Entti Barnnabaasa, Kareethi geetettiya Simoona, Qereenaappe yida Luukiyosa, Kawuwa Heroodisara diccida Minaahenne Saa7ola. ");
INSERT INTO gofRNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Entti Godaa goynnishininne xoomishin Geeshsha Ayyaanay, “Taani xeegida oosuwas Barnnabaasanne Saa7ola taw dummayite” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Hessa gisho, entti xoomidaappenne woossidaappe guye bantta kushiya entta bolla wothidi yeddidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Hessa gisho, Geeshsha Ayyaani entta kiittis. Selewuqe bidosona; yaappe markkaben gelidi Qoophiroosa haathan teqettida biitta bidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Entti Silmmaana gakkidi Ayhude Woosa Keethatan Xoossaa qaala odidosona. Yohaannisi maaddishe enttara de7ees. ");
INSERT INTO gofRNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Entti Qoophiroosa haathan teqettida biittaa kanthidi Phaafu gakkiya wode issi worddanchcho nabiya Bar-Yesuusa giya Ayhude maruwa demmidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","He maroy deriya aysiya Sarggiyoos Phawuloosa giya akeekanchcho addiyara de7ees. Sarggiyoos Phawuloosi Barnnabaasanne Saa7ola baakko xeegidi Xoossaa qaala si7anaw koyis. ");
INSERT INTO gofRNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Shin Girike doonan maruwa sunthay “Elmmaasa” geetettees. I deriya haareyssi ammanonna mela digganaw koyidi Barnnabaasaranne Phawuloosara eqettis. ");
INSERT INTO gofRNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Shin Phawuloosa giya Saa7oli Geeshsha Ayyaanan kumidi maruwa caddi xeellidi, ");
INSERT INTO gofRNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“La, Xalahe na7aw, iitatethi ubbay kumidaysso, xillotetha ubbaas morkkiyaw, suure Godaa ogiya mirqeyssa aggikii? ");
INSERT INTO gofRNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Hekko, ha77i Godaa kushey ne bolla de7ees. Neeni qooqe gidana; guutha wodes awa poo7o be7akka” yaagis. Iira caaganaynne dhumay iya ayfiyaa goozin, ba kushiya oykkidi kaalethiya asi koyishe yuuyis. ");
INSERT INTO gofRNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Deriya haareyssi hessa be7ida wode Godaaba tamaarsseysan malaalettidi ammanis. ");
INSERT INTO gofRNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Phawuloosinne iyara de7eyssati Phaafuppe denddidi, Phinfiliyan de7iya Phergge markkabera bidosona. Yohaannisi enttafe shaakettidi Yerusalaame simmis. ");
INSERT INTO gofRNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Shin entti Pherggefe aadhdhidi Phisidiyan de7iya Anxookiya gakkidosona. Sambbaata gallas Ayhude Woosa Keethi gelidi uttidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Muse higgeynne nabeta maxaafay nabbabettidaappe guye Ayhude Woosa Keetha halaqati, “Nu ishato, asaa minthethiya qaali hinttew de7iyakko asaas oderkketii” yaagidi enttako kiittidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Phawuloosi denddi eqqidi ba kushe mallidi, “Isra7eele asataw, qassi Xoossaa goynniya Ayhude gidonna asaw, si7ite. ");
INSERT INTO gofRNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Ha Isra7eele asaa Xoossay, nu mayzata dooris. Gibxxe biittan imathatethan entti de7ishin, entta darssidi ba gita wolqqan Gibxxe biittaafe entta kessis. ");
INSERT INTO gofRNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Bazzo biittan oytamu laytha mela entta dandda7is. ");
INSERT INTO gofRNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Kanaane biittan Ayhude gidonna laappun kawotethata diggidi entta biittaa ba asaa laatisis. ");
INSERT INTO gofRNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Hessafe guye, nabiya Saamu7eela wode gakkanaw oyddu xeetanne ishatamu laytha mela aysiya daynnata enttaw immis. ");
INSERT INTO gofRNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Hessafe guye, entti banttaw kawo immana mela woossin, Xoossay Biniyame sheeshaappe Qiise na7aa, Saa7ola oytamu laythi kawotana mela enttaw immis. ");
INSERT INTO gofRNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Xoossay Saa7ola shaaridaappe guye entta bolla Dawite kawothis. Xoossay Dawitebaa markkattishe, ‘Taani koyaa ubbaa ta wozanaa mela oothiya Isseyye na7aa Dawite demmas’ yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Xoossay, ‘Taani Dawite sheeshaappe Isra7eele deriya ashsheyssa ehana’ gidayssa mela Yesuusa ehis. ");
INSERT INTO gofRNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Yesuusi yaanappe sinthe Isra7eele asa ubbay bantta nagaraappe simmidi xammaqettana mela Yohaannisi qaala odis. ");
INSERT INTO gofRNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Qassi Yohaannisi ba oosuwa wurssana hanishe asaakko, ‘Tana oona gidi qoppeetii? Taani hintte naagiya Kiristtoosa gidikke, shin taani iya caammaa birshshanaw taw bessonnayssi taappe guyera yees’ yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Ishato, Abrahame sheeshatoo, qassi hayssan Ayhude gidonnashin Xoossas yayyeyssato, ha atotethaa qaalay nuus kiitettis. ");
INSERT INTO gofRNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Ays giikko, Yerusalaamen de7iya asaynne entta halaqati Yesuusa eribookkona. Sambbaata ubban nabbabettiya nabeta qaala akeekiboonna gisho iya bolla pirddidi nabeti odida qaala polidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Yesuusa wodhisanaw issi gaasoykka dhayin Philaaxoosi iya wodhana mela woossidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Entti Yesuusabay Geeshsha Maxaafan xaafettidaba ubbaa polida wode masqaliyappe iya wodhisidi moogidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Shin Xoossay hayqoppe Yesuusa denthis. ");
INSERT INTO gofRNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Hessafe guye, I baara Galiilappe Yerusalaame yidayssatas daro toho benttis. Entti ha77i iyabaa asaas markkattoosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Xoossay nu aawatas immana gida Wonggelaa nuuni hinttew odoos. ");
INSERT INTO gofRNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Dawitey ba Mazmure Maxaafan nam77antho shemppuwan, ‘Neeni, ta Na7a, taani hachchi nena yelas’ geetettidi xaafettida Yesuusa, Xoossay hayqoppe denthidi nu mayzatas immana gidayssa nuus entta naytas polis. ");
INSERT INTO gofRNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","I wooqonna mela Xoossay hayqoppe iya denthon erisanaw, ‘Taani Dawites immana gida ammanettida geeshsha anjjuwaa hinttew immana’ yaagidi odis. ");
INSERT INTO gofRNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Hessa gisho, Mazmure Maxaafan harason qassi, ‘Ne Geeshsha Na7aa ahaa wooqisakka’ yaagees. ");
INSERT INTO gofRNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Dawitey ba wode Xoossaa qofaa polidaappe guye hayqqidi ba aawatara moogettidi wooqis. ");
INSERT INTO gofRNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Shin Xoossay hayqoppe denthidayssi wooqibeenna. ");
INSERT INTO gofRNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Hessa gisho, ta ishato, nagara atotethay Yesuusa baggara kasetidi hinttew odettidayssa erite. Muse higgey nagarappe xillisanaw dandda7enna. ");
INSERT INTO gofRNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Shin Yesuusa ammaniyaa ubbay nagarappe xillees. ");
INSERT INTO gofRNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Hessa gisho, nabeti gidayssi hintte bolla gakkonna mela naagettite. ");
INSERT INTO gofRNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Xoossay gidabaa leeqiseyssato! Be7ite! Malaalettite! Dhayite! oonikka odin, hintte ammanonna oosuwa taani hintte wodiyan oothana’ ” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Phawuloosinne Barnnabaasi Ayhude Woosa keethafe keyishin, kaalliya Sambbaatan hessa gujjidi odana mela asay enttana woossidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Shiiqoy laalettidaappe guye daro Ayhudetinne Ayhudeta ammanuwan gelidi Xoossaa goynniya daroti Phawuloosanne Barnnabaasa kaallidosona. Ammanidayssati Xoossaa aadho keehatethan minnidi daana mela entta zoridosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Kaalliya Sambbaatan kataman de7iya asaappe daroti Xoossaa qaala si7anaw shiiqidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Shin Ayhudeti daro asaa be7ida wode Phawuloosa qanaattidi iya haasaya ixxidi iya cayidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Phawuloosinne Barnnabaasi yayyonna, “Xoossaa qaalay koyrottidi hinttew odettanaw koshshees. Shin hintte qaala ixxidi merinaa de7uwa ekkanaw nuus bessenna gidi hinttee, hintte huu7en pirddida gisho hiza nuuni Ayhude gidonnayssatakko simmos. ");
INSERT INTO gofRNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Gaasoykka Goday, ‘Alame kumethay ne baggara attana mela, taani nena Ayhude gidonna deriyas poo7o oothas’ yaagidi nuna kiittis” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ayhude gidonnayssati hessa si7ida wode ufayttidi Xoossaa qaala bonchchidosona. Qassi merinaa de7uwas doorettida ubbay ammanidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Godaa qaalay he biitta ubbaa gakkis. ");
INSERT INTO gofRNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Shin Ayhudeti, Ayhude gidonna Xoosse goynniya dure maccasatanne kataman de7iya gita asata Phawuloosa bollanne Barnnabaasa bolla denthethidosona. He asati entta gooda doomidi bantta biittaafe kessidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Shin Phawuloosaranne Barnnabaasara ixxeyssatas malla gidana mela bantta tohuwappe baana pittidi Iqooniyone katama bidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Qassi Anxookiyan de7iya ammaneyssati Geeshsha Ayyaananinne ufayssan kumidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Kaseyssadakka, Phawuloosinne Barnnabaasi Iqooniyonen Ayhudeta woosa keethi gelidi daro Ayhudetinne Ayhude gidonnayssati ammanana gakkanaw qaala odidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Shin ammaniboonna Ayhudeti, Ayhude gidonnayssata wozanaa laammidi ishata bolla denthethidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Hawaareti yan daro wode gam77idosona. Entti yayyonna Godaabaa odidosona. Goday malaatatanne oorathabaa entti oothana mela enttaw maata immidi ba aadho keehatethaa qaalay tuma gideyssa qonccisis. ");
INSERT INTO gofRNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Shin he katamaa asay shaakettidi, baggay Ayhudetara baggay qassi Hawaaretara gidis. ");
INSERT INTO gofRNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Ayhude gidonnayssatinne Ayhudeti bantta halaqatara issife gididi hawaareta qohanawunne shuchchan caddanaw koyidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Hawaareti hessa eridi, Lisxiranne Darbbe giya Liqaa7oniya katamatanne entta heeran de7iya biittaa baqatidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Yan Wonggelaa odidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Yelettoosappe doomidi nam77u tohoy wobbin hamuti eronna issi addey Lisxiran de7ees. ");
INSERT INTO gofRNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","He addey Phawuloosi odishin uttidi si7ees. Phawuloosi iya caddidi xeelliya wode paxanaw iyaw ammanoy de7eyssa be7idi, ");
INSERT INTO gofRNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","ba qaala dhoqqu oothidi, “Sitti gada ne tohuwan eqqa” yaagis. Yaatin, guppi denddi eqqidi hamuthi doomis. ");
INSERT INTO gofRNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Phawuloosi oothidayssa asay be7idi bantta qaala dhoqqu oothidi Liqaa7oniya doonan, “Xoossati ase daanidi nuukko wodhdhidosona” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Barnnabaasa, “Diya” gidi, Phawuloosi haasayan waannatiya gisho iya, “Hermmeesa” gidi sunthidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Katamaappe gaxan de7iya eeqaa Diya keethaa kahineynne asay kormmatanne alleeqo ciishshata hawaaretas yarshshanaw koyidi katamaa pengge ehidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Shin Barnnabaasinne Phawuloosi hessa si7ida wode entti oothanaw qoppidayssa ixxidi bantta ma7uwa peedhidosona. Asaa giddo woxxi gelidi, ");
INSERT INTO gofRNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","bantta qaala dhoqqu oothidi, “Asaw, hayssa ays ootheetii? Nukka hintte mela ase. Ha pathonnabaappe saluwanne sa7aa, abbaanne entta giddon de7iya ubbabaa medhdhida de7o Xoossaakko hintte simmana mela hinttew nuuni Wonggelaa odoos. ");
INSERT INTO gofRNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","I beni asaa bantta ogiya baana mela yeddi aggis. ");
INSERT INTO gofRNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Shin iraa saluwappe bukisis, kathaaka woden woden immis, kathi immidi hinttena daro ufayssis, yaatidi hinttew lo77obaa oothidi baw markka dhayssibeenna” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Hawaareti hessa gidi banttaw asay yarshshonna mela waayidi diggidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Anxookiyappenne Iqooniyoneppe yida Ayhudeti, asaa bantta bagga zaaridi shuchchan Phawuloosa caddidosona. Enttaw I hayqqidabaa daanin katamaappe gaxa goochchi efidi yeggidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Shin ammaneysati yidi, iya yuushuwan eqqidashin I denddidi katamaa gelis. Wonttetha gallas Barnnabaasara issife Darbbe bis. ");
INSERT INTO gofRNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Entti Darbbe kataman Wonggelaa odidi darota ammanthidaappe guye Lisxira, Iqooniyonenne Phisidiya Anxookiya simmidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Yan ammaneyssata minthethishenne entti ammanon minnidi de7ana mela zorishe, “Xoossaa kawotethaa gelanaw nuuni daro waaye ekkanaw bessees” yaagidi tamaarssidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Qassi woosa keethatas huu7en huu7en cimata dooridosona. Xoomidaappenne woossidaappe guye entti ammanida Godaas entta hadara immidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Phisidiya biittaa kanthidi aadhdhidi Phinfiliya bidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Pherggen qaala odidaappe guye Axaaliya bidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Yaappe entti bantta polida oosuwas Xoossaa aadho keehatethaas entta hadara immida Anxookiya markkabera simmidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Anxookiya gakkida wode woosa keethaa asaa shiishidi Xoossay enttara oothida oosuwa ubbaanne Ayhude gidonna asay ammanana mela enttaw waati pengge dooyidaako odidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Hessan ammaneyssatara daro wode gam77idosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Issi issi asati Yihudappe Anxookiya bidi, “Muse wogaatho hintte qaxxarettonna ixxiko attanaw dandda7ekketa” gidi ammaneyssata tamaarsso doomidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Hessi Phawuloosanne Barnnabaasa enttara daro palamanaadanne kaccanaada oothis. Hessa gisho, Anxookiyan de7iya issi issi asati Phawuloosaranne Barnnabaasara Yerusalaame bidi Hawaaretaranne cimatara gahettidi he odaa billana mela qofa qachchidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Woosa keethay entta kiittin bidosona. Entti Siroofinqe Samaarera aadhdhishe Ayhude gidonnayssati Xoossako waanidi simmidaakko odidosona. Hessi ammaneyssata ubbaa daro ufayssis. ");
INSERT INTO gofRNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Entti Yerusalaame gakkida wode woosa keethay, Hawaaretinne cimati entta mokkidosona. Xoossay banttara oothidabaa ubbaa odidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Shin Farisaaweta baggafe ammanida issi issi asati denddi eqqidi, “Ayhude gidonnashin ammanida asati qaxxaretanawunne Muse higgiya naaganaw bessees” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Hawaaretinne cimati hessa zorettanaw shiiqidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Daro haasayidaappe guye, Phexiroosi denddi eqqidi, “Ta ishato, Ayhude gidonnayssati Wonggelaa qaala ta doonappe si7idi ammanana mela kasetidi tana Xoossay hintte giddofe dooridayssa hintte ereeta. ");
INSERT INTO gofRNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Asa wozana eriya Xoossay Geeshsha Ayyaanaa nuus immidayssada enttawuka immidi tumays. ");
INSERT INTO gofRNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Ammanon entta wozanaa geeshshida gisho nu giddoninne entta giddon dummatethi wothibeenna. ");
INSERT INTO gofRNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Hessa gisho, nu aawatinne nuuni tookkanaw dandda7iboonna qambbara ammaneyssata morggen wothidi ha77i ays Xoossaa paacetii? ");
INSERT INTO gofRNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Godaa Yesuus Kiristtoosa aadho keehatethan entti attidayssada nukka attidayssa ammanoos” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Asay si77i gidi, Barnnabaasinne Phawuloosi Ayhude gidonna asaa giddon bantta baggara Xoossay oothida malaatatanne oorathabaa ubbaa odishin si7oosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Entti haasaya onggidaappe guye Yayqoobi, “Ishato, ta geyssa si7ite. ");
INSERT INTO gofRNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Xoossay Ayhude gidonnayssata giddofe ba ase dooranaw koyidi enttana koyro waattidi qoppidaakko Simooni odis. ");
INSERT INTO gofRNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Nabeta qaalay hayssara ginees. Geeshsha Maxaafan, ");
INSERT INTO gofRNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Hayssafe guye, taani simmana, kunddida Dawite kawotethaa denthana. Laalettida keethaaka zaara essana. ");
INSERT INTO gofRNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Attida asa ubbay taakko yaana, taani xeegida Ayhude gidonna asa ubbay tana koyana. ");
INSERT INTO gofRNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Benippe doomada hessi erettana mela oothida Xoossay, taani yaagays’ yaagees. ");
INSERT INTO gofRNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Hessa gisho, ta qofay Xoossako simmiya Ayhude gidonnayssata nuuni waaysonnaako lo77o. ");
INSERT INTO gofRNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Shin entti eeqas yarshshettidi tunidabaa moonna mela, laymatonna mela, bawuta moonna melanne suuthi uyonna mela enttaw nuuni dabddaabbe xaafanaw koshshees. ");
INSERT INTO gofRNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Muse higgey benippe doomidi Sambbaatan Sambbaatan Ayhude Woosa Keethatan nabbabettishe katama ubban sabbakettees” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Hessafe guye, hawaaretinne cimati woosa keethaa asa ubbaara issife bantta giddofe guutha asata dooridi Phawuloosaranne Barnnabaasara Anxookiya yeddanaw qofa qachchidosona. Entti daro bonchchettida nam77u asata Barssabaasa geetettiya Yihudanne Sillaase dooridosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Hayssada geetetti xaafettida dabddaabbiya entta bolla yeddidosona: “Nuuni hawaaretinne cimati hintte ishati, Anxookiyan, Sooriyaninne Kilqiyan de7iya Ayhude gidonna ishatas nu sarothuwa kiittoos. ");
INSERT INTO gofRNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","“Nuuni kiittonna asati nu giddofe bidi, ‘Hintte qaxxarettanawunne higgiya naaganaw bessees’ gidi, hinttena waaysidayssanne yiloyidayssa si7ida. ");
INSERT INTO gofRNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Nuuni dosiya Barnnabaasanne Phawuloosa doorettida asatara issife hintteko kiittanaw issi wozanan nu qofaa qachchida. ");
INSERT INTO gofRNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Entti nu Godaa Yesuus Kiristtoosa gisho bantta de7uwa aathi immidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Hessa gisho, nuuni xaafidayssa entti bantta doonan gujjidi hinttew odana mela Yihudanne Sillaase kiittida. ");
INSERT INTO gofRNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","“Ha koshsheyssatappe attin hara tooho hinttena toossonna mela nunne Geeshsha Ayyaanay oda qachchida. ");
INSERT INTO gofRNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Eeqas yarshshettidi tunidabaa mooppite, suuthu uyoppite, bawuta mooppite, laymatoppite. Ha ubbaafe hinttee, hintte huu7iya naagikko lo77obaa ootheeta” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Hessa gisho, kiitettidayssati moyzettidi Anxookiya bidi ammaniyaa asaa shiishidi, dabddaabbe immidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Entti he minthethiya dabddaabbiya nabbabida wode ufayttidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Qassi Yihudinne Sillaasey bantta huu7en nabe gidiya gisho ammaneyssata loythi zoridi minthethidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Entti Anxookiyan guutha gallas uttidaappe guye ishati lo77ora moyzin banttana kiittidayssatakko simmidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Shin Sillaasey yan attanaw koyis. ");
INSERT INTO gofRNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Qassi Phawuloosinne Barnnabaasi hara daro asatara issife Godaa qaalaa tamaarssishenne Wonggelaa odishe Anxookiyan gam77idosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Guutha gallasappe guye Phawuloosi Barnnabaasako, “Nuuni Godaa qaala odida katama ubban ammaneysati waanidi de7iyakko guye simmishe xomoosana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnnabaasi Marqqoosa geetettiya Yohaannisa banttara efanaw koyis. ");
INSERT INTO gofRNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Shin Phawuloosi Marqqoosa banttara efanaw koyibeenna. Gaasoykka, I Phinfiliyan shaakettidi enttara oothanaw bibeenna. ");
INSERT INTO gofRNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Entta giddon iita ooshshi keyin issoy issuwafe shaakettidosona. Barnnabaasi Marqqoosa ekkidi markkabera Qoophiroosa bis. ");
INSERT INTO gofRNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Shin Phawuloosi Sillaase dooris; ammaneysati Phawuloosa Xoossaa aadho keehatethaas hadara immidaappe guye i keyidi bis. ");
INSERT INTO gofRNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Yaatidi, woosa keethata minthethishe Sooriyaranne Kilqiyara aadhdhis. ");
INSERT INTO gofRNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Phawuloosi Darbbenne Lisxira bis. Yan Ximotiyoosa giya ammaniyaa asi de7ees. Iya aayyaa ammaniyaa Ayhude maccas, iya aaway Girike asi. ");
INSERT INTO gofRNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Lisxiraninne Iqooniyonen de7iya ammaneysati Ximotiyoosabaa loythidi markkattidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Phawuloosi Ximotiyoosa baara efanaw koyidi, iya aaway Girike asi gididayssa he bessan de7iya Ayhude ubbay eriya gisho iya qaxxaris. ");
INSERT INTO gofRNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Entti katamatara bishe Yerusalaamen de7iya hawaaretinne cimati wothida higgiya ammaneyssati naagana mela enttaw odishe aadhdhidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Hessa gisho, woosa keethati ammanon minnishe, taybonkka gallas gallas dari dari bidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Iisiyan qaala odonna mela Geeshsha Ayyaanay entta diggida gisho Phirggeranne Galaatiya biittaara aadhdhidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Entti Miisiya zawaa gakkida wode Bitiiniya baanaw koyidosona. Shin Yesuusa Ayyaanay entta diggis. ");
INSERT INTO gofRNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Hessa gisho, entti Miisiya matara aadhdhishe Xiro7aada wodhdhidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Phawuloosi qamma qonccethan issi Maqedooniya asi baakko, “Maqedooniya pinnada nuna maaddarkii” yaagishe eqqidi woossishin be7is. ");
INSERT INTO gofRNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Qonccethaa I be7idaappe guye ellesidi nuuni Maqedooniya baanaw koyida. Hessika, Wonggelaa yan de7iya asaas odanaw Xoossay nuna xeegidayssa erida gishossa. ");
INSERT INTO gofRNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Xiro7aadappe denddidi markkaben gelidi Samotiraaqe bida, wonttetha gallas Naaphule bida. ");
INSERT INTO gofRNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Yaappe denddidi Maqedooniya biittan de7iya Filphisiyuusa giya koyro katama bida. Qassi Filphisiyuusi Roome asay de7iya katama. Nuuni he kataman guutha gallas uttida. ");
INSERT INTO gofRNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Sambbaata gallas katamaappe gaxan Shaafaa doonan Ayhudeti Xoossaa woossiya bessi de7eyssa eridi yaa bida. He bessan shiiqida maccasaas qaala odida. ");
INSERT INTO gofRNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Nuna si7iya asaappe issi Liidiya geetettiya Tiyatiroona katamaappe yida, Xoossaa ammanida zo7o afila zal77iya, maccasiya de7awusu. Phawuloosi odeyssa iya si7ana mela Xoossay I wozanaa dooyis. ");
INSERT INTO gofRNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Liidiya ba soo asaara issife xammaqettidaappe guye nuukko, “Hintte tana Godaa tuma ammanasu giikko ta soo yedhdhite” gada miinthada woossasu. ");
INSERT INTO gofRNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Nuuni Xoossaa woossiya bessaa bishin iita ayyaani I bolla de7idi kaaysiya issi geela7o aylley nuura gahettasu. Iya kaayada daro miishe ba godatas ehawusu. ");
INSERT INTO gofRNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Phawuloosanne nuna kaallada, “Hayssati Ubbaafe Bolla Xoossaa aylleta! Entti hintte attana ogiya odeyssata” gada waassasu. ");
INSERT INTO gofRNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ubba gallas hessada gawusu. Shin Phawuloosi yilotidi guye simmidi, he ayyaanaa, “Yesuus Kiristtoosa sunthan iippe keya” gidi kiittis. Iirakka iita ayyaanay iippe keyi aggis. ");
INSERT INTO gofRNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Shin I godati banttaw miishe demmiya ogey dhayidayssa be7idi, Phawuloosanne Sillaase oykkidi, dabaaba daynnata sinthe goochchi efidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Daynnata sinthe entta efidi, “Hayssati Ayhude asi gidishe nu katamaa asaa daro waaysosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Nuuni Roome biitta asi gidishe ekkanawunne oothanaw woga gidonnabaa tamaarssosona” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Asay issi bagga gididi, Phawuloosa bollanne Sillaase bolla denddidosona. Daynnati entta ma7uwa qaaridi xam77an entta shocana mela kiittidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Entta daro wadhdhidaappe guye qasho keethi gelssidosona. Qasho keethaa naageysi entta minthi naagana mela kiittidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Qasho keethaa naageyssi he kiitaa ekkidi, Phawuloosanne Sillaase qasho keethas qol77a gelssis. Entta tohuwa duuxis ");
INSERT INTO gofRNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Shin giddi bilahe gidiya wode Phawuloosaranne Sillaasera woossishenne mazmure yexxishe Xoossaa galatoosona. Qasho keethan de7iya hara asatikka entti giyabaa si7oosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Qopponna qasho keethaa baasoy qaaxxana gakkanaw biitta qaaxoy hanis. He saatenkka pengge ubbay dooyetti aggis; qashettida asa ubbaa santhalaatay birshsheti wodhdhis. ");
INSERT INTO gofRNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Qasho keethaa naageyssi dhiskkofe barkida wode qasho keethaa pengge ubbay dooyettidayssa be7idi qasho asay kessi ekki bidabaa daanin bana wodhanaw mashshe ekkis. ");
INSERT INTO gofRNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Shin Phawuloosi qaala dhoqqu oothidi “Nu ubbay hayssan de7iya gisho neeni nena qohoppa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Qasho keethaa naageyssi xomppe woossi ekkidi ellesidi gaathi woxxis. Kokkorishe Phawuloosa sinthaninne Sillaase sinthan gufannis. ");
INSERT INTO gofRNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Entta kare kessidi, “Ta godato, taani attanaw ay oothanaw bessii?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Phawuloosaranne Sillaasera iyaakko, “Godaa Yesuus Kiristtoosa ammana; neeranne ne soo asaara attana” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Entti iyasinne iya son de7iya ubbaas Godaa qaala odidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Qamma he saatenkka qasho keethaa naageyssi entta efidi entta madunthaa meeccis. Ellesidi ba soo asa ubbaara xammaqettis. ");
INSERT INTO gofRNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Phawuloosanne Sillaase ba soo efidi enttaw kathi aathis. I ba soo asa ubbaara Xoossaa ammanida gisho ufayttis. ");
INSERT INTO gofRNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Sa7ay wonttin daynnati, “He asata billa” yaagidi poolise halaqata iyaakko kiittidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Qasho keethaa naageyssi, “Hintte bilettana mela daynnati kiittidosona. Hiza, keyidi saro biite” yaagidi he kiitaa Phawuloosas odis. ");
INSERT INTO gofRNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Shin Phawuloosi he poolise halaqatakko, “Nuuni Roome asi gidishin entti nuna pirddi baynna asaa sinthan wadhdhidi, qasho keethan yeggidosona. Ha77i nuna geeman keyidi bo goonaa? Hanenna, entti bantta huu7en yidi nuna kesso” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Poolise halaqati daynnatas hessa odin, Phawuloosaranne Sillaasera Roome biitta asi gididayssa si7ida wode yayyidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Hessa gisho, daynnati yidi enttako, “Nuuni hinttena qohida” gidosona. Qasho keethafe kare entta kessidi, katamaappe keyidi baana mela woossidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Phawuloosaranne Sillaasera qasho keethafe keyidi Liidiya soo bidosona. Yan ammaneyssatara gahettidi entta minthethidi keyidi bidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Phawuloosaranne Sillaasera Amfipholisaranne Apholoniyara aadhdhidi Teselonqe bidosona. Yan Ayhude Woosa Keethi de7ees. ");
INSERT INTO gofRNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Phawuloosi kaseyssada yaa gelis. Yan heedzu saamintta Xoossaa qaalappe asaas odis. ");
INSERT INTO gofRNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Kiristtoosi waaye ekkanawunne hayqoppe denddanaw besseyssa enttaw qonccisidi odishe, “Yesuusi ha taani hinttew odeyssi Kiristtoosa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Enttafe issoti issoti oday tuma gideyssa ma77idi Phawuloosaranne Sillaasera issifidosona. Hessadakka, Xoossaa goynniya daro Girike asaynne daro bonchchettida maccasatikka enttara issifidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Shin Ayhudeti qanaattidi issi issi oosoy baynna iita asata ogeppe shiishidosona. Kataman buqethi kessidosona; Phawuloosanne Sillaase asaas aathi immanaw koyidi Yaasona keethaa teqqidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Phawuloosinne Sillaasi enttaw benttonna ixxin, Yaasonanne issi issi ammaneyssata katamaa halaqatakko goochchi efidi, “Hayssati biitta ubbaa buqeyssati ha77i nuukko yidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Yaasoni entta ba son wothis. Hayssati, ‘Yesuusa giya hara kawoy de7ees’ gidi Qeesare kiitaa menthosona” yaagidi dhoqqu gida qaalan odidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Shiiqida asaynne katamaa halaqati hessa si7idi hananabaa dhayidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Halaqati Yaasonanne harata waasen birshshidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Ammaneysati Phawuloosanne Sillaase qammara Beeriya yeddidosona. Beeriya gakkidi, Ayhude Woosa Keethi gelidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Beeriya asati Teselonqe asatappe aadhdhida suureta. Entti qaala kumetha wozanaappe ekkidosona; Phawuloosi gidayssi tuma gideyssa shaakki eranaw gallas gallas Geeshsha Maxaafata xanna7oosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Hessa gisho, enttafe daroti, Giriketappeka bonchchettida daro maccasatinne daro addeti ammanidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Shin Teselonqen de7iya Ayhudeti Phawuloosi Xoossaa qaala Beeriyankka odidayssa si7ida wode Beeriyaa yidi asaa buqidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Hessafe guye, ammaneyssati ellesidi Phawuloosa abbaa mati yeddidosona. Shin Sillaaseynne Ximotiyoosi Beeriyan attidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Phawuloosa moyzida asati Ateena gathidosona. He asati Sillaaseynne Ximotiyoosi banttaw dandda7ettida mela ellesidi baakko yaana mela Phawuloosi kiittida kiitaa ekkidi Beeriya simmidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Phawuloosi Ateenan Sillaasenne Ximotiyoosa naagishe, kataman eeqi kumidayssa be7idi yilotis. ");
INSERT INTO gofRNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Hessa gisho, Ayhude Woosa Keethan Ayhudetaranne Xoossaa goynniya Ayhude gidonna asatara qassi baara gahettiya asatara ubba wode palamees. ");
INSERT INTO gofRNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Ephiqoroosanne Isttoyke geetettiya cugatappe issi issi eranchchoti Phawuloosara palamidosona. Enttafe issoti issoti, “Ha yooyamay ay odanaw koyii?” yaagidosona. Harati Phawuloosi Yesuusabaanne hayqoppe I denddidayssa banttaw odida gisho “Ooratha xoossatabaa odiya daanees” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Phawuloosa oykkidi Aryoospaagosa giya shiiqo bessaa efidi, “Ha neeni tamaarssiya oorathabay aybeekko nuna erisikkii? ");
INSERT INTO gofRNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Ays giikko, neeni nuus oorathabaa odaasa; hiza hessi aybeekko nuuni eranaw koyoos” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Ateena asa ubbaynne yan de7iya imathati oorathabaa odettonnanne si7onna pee7okkona. ");
INSERT INTO gofRNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Phawuloosi Aryoospaagosan shiiqida asaa sinthan eqqidi, “Ateena asaw, hintte xoossatas ubbaban daro yayyeyssa taani be7ays. ");
INSERT INTO gofRNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Taani hintte katamaara yuuyashe hintte goynniya bessata be7iya wode ‘Erettonna Xoossas’ geetetti xaafettida yarshsho bessaa demmas. Ha hintte eronnashin goynneyssa taani hinttew odays. ");
INSERT INTO gofRNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Sa7aanne sa7an de7iya ubbabaa medhdhida Xoossay, saluwanne sa7aa Goday, asi keexida keethan deenna. ");
INSERT INTO gofRNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","I de7o, shempponne ubbabaa asa ubbaas immiya gisho paci de7iya asada asa maade koyenna. ");
INSERT INTO gofRNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Xoossay asa zerethi ubbaa issi addiyafe medhdhidi biitta ubban wothis. Yaatidi entti de7ana wodiyasinne bessaas zawa immis. ");
INSERT INTO gofRNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","I hessa oothiday asi iya koyana melanne pilggidi demmana melassa. Hanikkoka I nuuppe geemmibeenna. ");
INSERT INTO gofRNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Hinttefe issi issi yexxeyssati, ‘Nuuni iya nayta’ gidayssada, ‘Nuuni iyan paxa de7oos, qaaxoos.’ ");
INSERT INTO gofRNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Hiza, nuuni Xoossaa nayta gidiya gisho ‘Xoossay asa hiillatethaninne qofan worqqafe woykko birappe woykko shuchchafe oosettidabaa daanees’ yaagidi qoppanaw bessenna. ");
INSERT INTO gofRNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Hessa gisho, Xoossay kase wode asay eronna oothidayssa aggidi aadhdhis, shin ha77i ubbason de7iya asi ubbay nagarappe simmana mela kiittees. ");
INSERT INTO gofRNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Ays giikko, Xoossay ba doorida addiyan sa7an de7iya asa ubbaa bolla xillo pirdda pirddanaw qamma giigisi wothis. Iya hayqoppe denthidi hessa asa ubbaas tumayis” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Enttafe issi issi asati hayqoppe denddobaa Phawuloosappe si7idi, iya bolla qelqisidosona. Shin harati, “Nuuni hessa neeppe gujjidi si7anaw koyoos” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Hessa gisho, Phawuloosi entta giddofe keyis. ");
INSERT INTO gofRNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Shin issi issi addeti Phawuloosara gahettidi ammanidosona. Entta giddofe Aryoospaagosan shiiquwan de7iya Diyonasyoosa giya addey, Damarsso giya issi maccasiyanne harati de7oosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Hessafe guye, Phawuloosi Ateenappe keyidi, Qoronttoosa bis. ");
INSERT INTO gofRNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Yan Aqiila giya Phanxoosan yelettida issi Ayhude asi demmis. Ayhude asa ubbay Roomeppe keyana mela kawoy Qalawudiyoosi kiittida gisho guutha wodeppe kase I ba machche Phirisqilara Xaaleppe yis. Phawuloosi enttara gahettanaw bis. ");
INSERT INTO gofRNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Iya oosoy enttayssada dunkkaane siko gidiya gisho enttara uttidi issife oothis. ");
INSERT INTO gofRNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Phawuloosi Sambbaata ubban Ayhudetanne Giriketa ammanthanaw Ayhude Woosa Keethan palamees. ");
INSERT INTO gofRNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Sillaaseynne Ximotiyoosi Maqedooniyappe yida wode Phawuloosi ba kumetha wodiya immidi Ayhudetas Yesuusi I, Kiristtoosa gidi qaala odis. ");
INSERT INTO gofRNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Shin entti Phawuloosa ixxidi iya cayin Phawuloosi ba ma7uwappe baanaa qoqqofishe, “Hintte gomey hinttena oykko; taani hessan de7ikke. Hizappe guye, taani Ayhude gidonna asaakko bays” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Yaappe keyidi Xoossaa goynniya Titoos Yosxoosa giya uraa soo bis. Yosxoosa keethay Ayhude Woosa Keetha matan de7ees. ");
INSERT INTO gofRNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Ayhude Woosa Keetha halaqay Qarisphoosi ba soo asa ubbaara Godaa ammanis. Qoronttoosa asatappeka daroti Xoossaa qaala si7ida wode ammanidi xammaqettidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Goday issi qamma Phawuloosas qonccidi, “Yayyofa; oda, si77i gooppa. ");
INSERT INTO gofRNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Taani neera de7ays. Taw ha kataman daro asi de7iya gisho nena qohidi iitaban yeggana asi oonikka baawa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Hessa gisho, Phawuloosi Xoossaa qaala asaa tamaarssishe issi laythinne usuppun ageena enttara uttis. ");
INSERT INTO gofRNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Gaaliyoosi Akkaya biittaa aysiya wode Ayhudeti issife Phawuloosa bolla denddidi pirdda keethi iya efidi, ");
INSERT INTO gofRNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","“Ha addey higgiya ixxidi, asay Xoossaa goynnana mela oothees” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Phawuloosi haasayana hanishin, Gaaliyoosi Ayhudetakko, “Ayhudetoo, hessi iita ooso woykko naaqo gidiyakko taani hinttebaa dandda7ada si7anaw bessees. ");
INSERT INTO gofRNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Shin qaalas, sunthasinne hintte higgiyas hintte palamiyabaa gidikko hinttee, hinttew billite; hessa taani pirddike” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Yaatidi, entta pirdda keethafe kare kessis. ");
INSERT INTO gofRNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Hessafe guye, Girike asa ubbay Ayhude Woosa Keetha halaqaa Sostenisa oykkidi pirdda keethaa sinthan wadhdhidosona. Shin Gaaliyoosi hessa paxabaa gibeenna. ");
INSERT INTO gofRNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Phawuloosi daro gallas Qoronttoosan uttidaappe guye ammaniyaa asaa sarothidi, Phirisqiliranne Aqiilara markkabera Sooriya bis. Shin I baanappe sinthe baw gasoy de7iya gisho Kinkkiriya kataman ba huu7iya buluusettis. ");
INSERT INTO gofRNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Entti Efesoona gakkida wode Phawuloosi Phirisqilonne Aqiila yan aggis. Shin baw Ayhude Woosa Keethi gelidi Ayhudetara odettis. ");
INSERT INTO gofRNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Entti banttara daro wode uttana mela Phawuloosa woossidosona shin I ixxis. ");
INSERT INTO gofRNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Enttafe shaakettishe, “Taani yaa baaliya Yerusalaamen bonchchanaw bessees. Shin Xoossi giikko hintteko simmada yaana” yaagidi Efesoonappe markkabera bis. ");
INSERT INTO gofRNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Qisaariya gakkida wode Yerusalaame bidi woosa keethaa asaa sarothidaappe guye Anxookiya bis. ");
INSERT INTO gofRNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Yan guutha wode gam77idaappe guye ammaniyaa asata ubbaa minthethishe Galaatiyaranne Phirggera aadhdhis. ");
INSERT INTO gofRNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Iskkinddiriyan yelettida issi Aphiloosa giya Ayhude asi Efesoona bis. I oda eriya asinne Xoossaa qaala daro eriya asi. ");
INSERT INTO gofRNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","I Godaa ogiya tamaaridi, ayyaanan xuugettidi Yesuusabaa suure tamaarssees. Gidoshin, Yohaannisa xinqqatiya xalaala erees. ");
INSERT INTO gofRNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","I Ayhude Woosa Keethan yayyonna tamaarssees. Phirisqilinne Aqiili I odeyssa si7ida wode iya banttara soo efidi Xoossaa ogiya kaseyssafe geeshshidi iyaw odidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Aphiloosi Akkaya baanaw koyin Efesoonan de7iya ammaniyaa asay iya qofaa ekkidi Akkayan de7iya ammaneysati iya mokkana mela enttaw dabddaabbe xaafidosona. I yaa gakkida wode Xoossaa aadho keehatetha baggara Yesuus Kiristtoosa ammanidayssata daro maaddis. ");
INSERT INTO gofRNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Ays giikko, Yesuusi I Kiristtoosa gideyssa Ayhudetas Xoossaa qaalappe qonccisidi deriya sinthan minthi odidi entta lathis. ");
INSERT INTO gofRNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Aphiloosi Qoronttoosan de7ishin, Phawuloosi qommo baggara aadhdhidi Efesoona bis. Yan issi issi ammaniyaa asata demmis. ");
INSERT INTO gofRNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Enttako, “Hintte ammanida wode Geeshsha Ayyaana ekkideti?” yaagidi oychchis. Entti, “Akkay, ekkibookko; hari attoshin, Geeshsha Ayyaani de7iyabaakka si7ibookko” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Phawuloosi enttako, “Yaatin, aybin xammaqettidetii?” yaagis. Entti, “Nuuni Yohaannisa xinqqatiyan xammaqettida” yaagidi zaaridosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Phawuloosi, “Yohaannisi baappe guyera yaa Yesuus Kiristtoosan asay ammanana mela asaas odishe, nagarappe simo bessiya xinqatiyan xammaqis” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Entti hessa si7ida wode Godaa Yesuus Kiristtoosa tamaare gidanaw xammaqettidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Phawuloosi ba kushiya entta bolla wothida wode Geeshsha Ayyaani entta bolla wodhdhin, dumma dumma doonan odettidosona; qassi tinbbite odidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","He bessan tammanne nam77a gidiya asati de7oosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Phawuloosi Ayhude Woosa Keetha gelidi, Xoossaa kawotethaabaa yayyonna palamishenne loythi qonccisishe enttara heedzu ageena gakkanaw gam77is. ");
INSERT INTO gofRNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Shin enttafe issoti issoti dhube gididi daro asaa sinthan Godaa ogiya cayidi ammanonna ixxidosona. Phawuloosi ammaneyssata enttafe shaakki ekkidi Xiranoosa giya timirtte keethan ubba wode entta tamaarssis. ");
INSERT INTO gofRNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Phawuloosi nam77u laythi gakkanaw qaala odis. Hessa gisho, Iisiyan de7iya asa ubbay, Ayhudetinne Ayhude gidonnayssati Godaa qaala si7idosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Xoossay Phawuloosa kushen wolqqaama malaatata oothis. ");
INSERT INTO gofRNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Hessa gisho, asay iya bollaa bochchida maarabiya woykko ma7uwa hargganchchotas efoosona. Enttika paxoosona; tuna ayyaanatikka enttafe keyoosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Tuna ayyaanata kessishe yuuyaa Ayhudetappe issoti issoti, “Phawuloosi sabbakiya Yesuusa sunthan keyite gidi hinttena kiittoos” yaagidi, tuna ayyaanati oykkida asata bolla Godaa Yesuusa sunthaa xeegidosona ");
INSERT INTO gofRNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Kahine halaqaa Asqeewe giya issi Ayhude addiyaas hessa oothiya laappun nayti de7oosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Shin tuna ayyaanay enttako, “Taani Yesuusakka Phawuloosakka erays, shin hintte oonantee?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Tuna ayyaanay oykkida addey entta bolla guppi wodhdhidi, entta madunxisidi, he keethaafe kallo baqatana gakkanaw wolqqaamis. ");
INSERT INTO gofRNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Efesoonan de7iya Ayhudetinne Ayhude gidonnayssati ubbay hessa si7idi daro yayyidosona. Godaa Yesuusa sunthay daro bonchchettis. ");
INSERT INTO gofRNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Ammaneyssatappe daroti bantta oothida iita oosuwa paaxishenne qonccen odishe yoosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Biteyssatappe daroti bantta maxaafata shiishidi asa ubbaa sinthan xuuggidosona. He maxaafata gatiya qooday ishatamu mukulu bira santime gidis. ");
INSERT INTO gofRNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Hessada hanidi Xoossaa qaalay diccishenne dalggishe bis. ");
INSERT INTO gofRNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Hessi polettidaappe guye Phawuloosi, “Taani Yerusalaame ba simmada Roomekka baanaw bessees” yaagidi Maqedooniyaranne Akkayara aadhdhidi Yerusalaame baanaw qofa qachchis. ");
INSERT INTO gofRNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Qassi bana maaddeyssatappe nam77ata Ximotiyoosanne Erasxoosa Maqedooniya kiittidi, baw Iisiyan guutha wode gam77is. ");
INSERT INTO gofRNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","He wode Godaa ogiya gisho Efesoonan wolqqaama kachchi keyis. ");
INSERT INTO gofRNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Issi biraa oothiya Dimexiroosa giya uray Arxemiisi eeqa keethaa misiliya birappe oothidi daro wodhe demmees. ");
INSERT INTO gofRNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Hessa gisho, hessa mela ooso ootheyssata issife shiishidi, “Asaw, nu duretethay ha oosuwan gideyssa hintte ereeta. ");
INSERT INTO gofRNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Hayssi Phawuloosi, ‘Asa kushen oosettidayssati xoossata gidokkona’ yaagidi, Efesoonaninne guutha biittatappe attin kumetha Iisiya ubban de7iya daro asaa odi ammanthidayssanne balethidayssa hintte be7idetanne si7ideta. ");
INSERT INTO gofRNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Meto gididay, nu oosoy kadhetteyssa xalaala gidonnashin Iisiyaninne biitta ubban de7iya asi goynniya gita xoossee Arxemiisi keethay bonchchettonna atteyssanne I gitatethayka kunddanayssa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Asay hessa si7ida wode shenen xuugettidi, “Efesoona Arxemiisa gita” yaagidi waassidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","He waasoy katama ubbaa gakkis. Phawuloosara hamuttiya Maqedooniya asata, Gaayoosanne Arsxirokoosa oykkidi goochchishe kaassa bessaa woxxidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Phawuloosikka asay shiiqidasuwa gelanaw koyis, shin ammaneysati iya diggidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Iisiya biittaa halaqatappe Phawuloosa lagge gidida issoti issoti Phawuloosakko kiittidi, “Kaassa bessaa qonccen keyada benttofa” gidi iya woossidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Shiiqida asaas hananabay dhays; dariya bagga asay hari attoshin ays shiiqidaakko eronna gisho issoy issibaas waassiya wode hankkoy harabaas waassees. ");
INSERT INTO gofRNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Ayhudeti Iskkinddire giya addiya aathi bessin, issi issi asay I gaanabaa odidi iya sinthe aathidosona. I asay si77i gaana mela ba kushiyan malli bessidi, asaas mootettanaw eqqis. ");
INSERT INTO gofRNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Shin Iskkinddirey Ayhude asi gididayssa asay erida wode nam77u saate gidanayssa mela ubbay issi qaalan, “Efesoona Arxemiisa gita” yaagidi waassidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Wurssethan Katamaa xaafey asaa si77i oothidi, “Efesoona asaw! Efesoona katamay gita Arxemiisi eeqa keethaanne saloppe wodhdhida, I shuchcha misiliya naageyssa gideyssa eronna asi baawa. ");
INSERT INTO gofRNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Hayssa kashi giya asi baynna gisho hintte si77i gaanawunne dirggidi aykko oothonna agganaw bessees. ");
INSERT INTO gofRNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Hintte ha asata, eeqa keetha miishe kaysotiboonnayssatanne nu Xoossata cayboonayssata ehideta. ");
INSERT INTO gofRNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Hessa gisho, Dimexiroosinne iyara de7iya oosanchchoti asaa mootanaw koykko, pirdda keethay dooya de7ees; daynnatikka de7oosona; entti mootanaw dandda7osona. ");
INSERT INTO gofRNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Shin hintte hara oda koykko, Shanggo shiiqon oday be7etto. ");
INSERT INTO gofRNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Hessa gidonna ixxiko hachchi hanidabaas Roome kawotethay nuna oychchana. Ha buqethaas gaasoy baynna gisho nuuni gaaso odanaw dandda7okko” ");
INSERT INTO gofRNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","yaagidi shiiquwa laallis. ");
INSERT INTO gofRNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Waasoy decidaappe guye Phawuloosi ammaniyaa asata xeegisidi entta zoridaappe guye sarothidi Maqedooniya baanaw keyis. ");
INSERT INTO gofRNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","I aadhdhiya biittatan de7iya ammaniya asaa qaala odidi minthethidaappe guye Girike biittaa bis. ");
INSERT INTO gofRNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","I yan heedzu ageena uttidi, markkabera Sooriya baanaw qoppidi de7ishin, Ayhudeti bana wodhanaw koyeyssa eridi Maqedooniyara guye simmanaw koyis. ");
INSERT INTO gofRNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Phawuloosa moyzidayssati Beeriyappe Pharhuusa na7aa Sophaxiroosa, Teselonqefe Arsxirokoosanne Sikondduusa, Derbbefe Gaayoosa, Iisiyappe Tikiqoosa, Xirofimoosanne Ximotiyoosa. ");
INSERT INTO gofRNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Hessati sinthe bidi nuna Xiro7aadan naagoosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Nuuni Uytha Baaliya bonchchidaappe guye Filphisiyuusappe markkabera denddidi, ichchashantho gallasan entta Xiro7aadan gakkidi yan laappun gallas gam77ida. ");
INSERT INTO gofRNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Saaminttafe koyro gallasan nuuni uythaa menthanaw shiiqidi de7ishin, Phawuloosi wonttethe baanaw qoppida gisho enttaw qaala odishe giddi bilahe gakkanaw odaa adussis. ");
INSERT INTO gofRNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Nuuni shiiqidi uttida pooqiyan daro poo7oy de7ees. ");
INSERT INTO gofRNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Ewuxikoosa giya issi na7atethay maskkoote bolla uttidi, baana dogidi dhiskkis. Phawuloosi oda adussida wode Ewuxikoosi dhiskko eeyidi heedzantho pooqiyappe kunddidi hayqqidayssa asay denthis. ");
INSERT INTO gofRNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Shin Phawuloosi wodhdhidi, iya bolla gufannis. Iya idimmidi, “I hayqqibeenna, hirggofite” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Hessafe guye, pude pooqiya bolla keyidi uythaa menthidi mis. Sa7i wonttana gakkanaw asaas odidaappe guye denddidi bis. ");
INSERT INTO gofRNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","He paxida naatethaa soo efidi daro ufayttidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Shin Phawuloosi bana yaappe mokkana mela nuus odida gisho kasetidi markkabiyakko bidi, Asoosa baanaw denddida. Ays giikko, I tohon baanaw qoppida gisho nuna hessatho kiittis. ");
INSERT INTO gofRNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","I nuura Asoosan gahettin markkabiyan iya ekkidi Mixiliine bida. ");
INSERT INTO gofRNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Wonttetha gallas yaappe denddidi markkabera Kiyoosa sinthen de7iya bessaa gakkida; qassi wonttetha gallas Saamosa pinnidi kaalliya gallas Miliixe gakkida. ");
INSERT INTO gofRNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Phawuloosi Iisiyan daro gam77onna Efesoona matara aadhdhanaw qoppis. Baw dandda7ettiko Phenxeqosxe Baaliya gallas Yerusalaame gakkanaw eesotees. ");
INSERT INTO gofRNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Phawuloosi Miliixeppe Efesoona kiittidi woosa keethaa cimata xeegisis. ");
INSERT INTO gofRNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Woosa keetha cimati iyaakko yin, enttako hayssada yaagis: “Taani Iisiya gelida koyro gallasappe doomida hinttera de7ida wode ubban waana de7idaakko hintte ereeta. ");
INSERT INTO gofRNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Ayhudeti duulatidi ta bolla meto gathikokka taani ashkketethaninne daro afuthan Godaas oothas. ");
INSERT INTO gofRNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Dabaabankka hintte keethan keethan hinttena tamaarssishe hinttena maaddiyabaappe issibaakka pacisabiikke. ");
INSERT INTO gofRNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Taani Ayhudetasinne Ayhude gidonnayssatas nagarappe Xoossaako simmana melanne nu Godaa Yesuusa ammanana mela markkattas. ");
INSERT INTO gofRNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","“Yan tana aybi gakkaneekko erikke, shin ha77i taani Geeshsha Ayyaanas kiitettada Yerusalaame bays. ");
INSERT INTO gofRNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Geeshsha Ayyaanay qashoynne waayey tana naageyssa katama ubban taw maarkkattis. ");
INSERT INTO gofRNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Shin ta wothaa polanawunne Godaa Yesuus Kiristtoosappe ekkida oosuwa, Xoossaa aadho keehatethaa Wonggelaa markkatteyssa polanaw ta shemppiw pathonnabaada qoodays. ");
INSERT INTO gofRNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Taani ha77ika Xoossaa kawotethaa markkattashe hintte ubbaa giddon yuuyas. Hizappe guye hinttefe oonikka tana be7onnayssa erays. ");
INSERT INTO gofRNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Hessa gisho, hinttefe issi uray dhayikkoka ta oyshettonayssa hachchi hinttew geeshshada odays. ");
INSERT INTO gofRNT_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Ays giikko, Xoossay oothanaw qoppidabaa ubbaa hinttew aybibaakka ashshonna odas. ");
INSERT INTO gofRNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","“Ba na7aa suuthan wozida Xoossaa woosa keethaa naagite. Geeshsha Ayyaanay hinttena halaqaa oothidi doorida wudiyasinne hintte huu7iyas naagettite. ");
INSERT INTO gofRNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Taani bidaappe guye, wudiyas qadhettonna iita suudhumeti hintte giddo gelanayssa ta erays. ");
INSERT INTO gofRNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Ammaneyssata bantta geedo kaalethanaw worddo tamaarssiya asati hintte giddofe denddana. ");
INSERT INTO gofRNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Hessa gisho, taani heedzu laythi qammanne gallas afuthan hinttena huu7en huu7en minthethidayssa qoppishe naagettite. ");
INSERT INTO gofRNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Ha77ika hinttena minthanawunne geeshsha asaara laatisanaw dandda7iya Xoossaasinne iya aadho keehatetha qaalas hinttena hadara immays. ");
INSERT INTO gofRNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","“Taani ooppekka bira woykko worqqa woykko afila amottabiikke. ");
INSERT INTO gofRNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Taani ta kushen oothada tananne taara de7eyssata koshshidabaa maaddidayssa hinttee, hintte huu7en ereeta. ");
INSERT INTO gofRNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Hintte hayssada daaburidi oothishe daaburanchchota maaddanayssanne Godaa Yesuusi, ‘Ekkeyssafe immeyssi anjjettidayssa’ gida qaala hintte qoppanaw besseyssa taani hinttena ubbaban bessas” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Phawuloosi hessa odi onggidi entta ubbaara gulbbatidi Xoossaa woossis. ");
INSERT INTO gofRNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Entti ubbayka Phawuloosa idimmidi yeekkidi yeeridosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","I Zaaridi, “Tana be7ekketa” yaagida qaalay entta daro azzanthis. Entti markkabiya gakkanaw iya moyzidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Nuuni Efesoona cimatappe shaakettida mela Qoose bida. Wonttetha gallas Rooda gakkidi yaappe Phaxara bida. ");
INSERT INTO gofRNT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Siroofinqe pinniya markkabe demmidi iyan gelidi baanaw denddida. ");
INSERT INTO gofRNT_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Nuuni Qoophiroosa be7anaw dandda7iya soo yidi, Qoophiroosa haddirssa bagga aggidi Sooriya bida. Markkabey ba caanaa yan wothanaw koyida gisho Xiroosa bida. ");
INSERT INTO gofRNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Yan ammaniyaa asata demmidi enttara laappun gallas uttida. Phawuloosi Yerusalaame boonna mela entti iyaw Ayyaanan odidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Nuuni enttara uttiya wodey wurin keyidi bida. Entti ubbay bantta maccasataranne bantta naytara issife katamaappe kare kessidi nuna moyzidosona. Nuuni abbaa doonan gulbbatidi Xoossaa woossida. ");
INSERT INTO gofRNT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Hessafe guye, woli sarothidi nu markkabiyan gelida; entti bantta soo simmidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Nuuni abbaa ogiya onggidi, Xiroosappe Phexelemaysa gakkida. Yan ammaniyaa asata sarothidi, entta matan issi gallas pee7ida. ");
INSERT INTO gofRNT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Wonttetha gallas keyidi, Qisaariya bida. Sabaakiya Filphoosa soo gakkidi iya matan uttida. I Yerusalaamen kase doorettida laappunatappe issuwa. ");
INSERT INTO gofRNT_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Filphoosas nabe gidida oyddu geela7o nayti de7oosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Nuuni unddenna gallas yan uttidi de7ishin Agaboosa giya nabey Yihudappe Qisaariya yis. ");
INSERT INTO gofRNT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Nuukko yidi Phawuloosa saqqiya ekkidi ba kushiyanne ba tohuwa qachchidi, “Geeshsha Ayyaanay ha saqqiya godaa, Yerusalaamen Ayhudeti hayssada qachchidi, Ayhude gidonna asaas aathidi immana yaagees” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Nuuni hessa si7ida wode nunne yan de7iya asati Phawuloosi Yerusalaame boonna mela woossida. ");
INSERT INTO gofRNT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Shin Phawuloosi zaaridi, “Hintte hayssada yeekkishe ays ta wozanaa shugiseeti? Taani, Godaa Yesuusa sunthaa gisho qashetetha xalaala gidonnashin Yerusalaamen hayqqanawukka giigettas” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Nu zoriya I ekkonna ixxin, “Godaa sheney hano” yaagidi si77i gida. ");
INSERT INTO gofRNT_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Yan guutha wode gam77idaappe guye giigettidi Yerusalaame baanaw keyida. ");
INSERT INTO gofRNT_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Qisaariyan de7iya ammaniyaa asatappe guuthati nuura bidosona. Entti nuuni shemppanasuwa Minaasona giya Qoophiroosa addiya soo efidosona. Minaasoni koyro ammanida asaappe issuwa. ");
INSERT INTO gofRNT_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Nuuni Yerusalaame gakkida wode ammaniyaa asati nuna ufayssan mokkidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Wonttetha gallas Phawuloosinne nuuni Yayqoobara gahettanaw bida. Woosa keethaa cimati ubbatikka yan de7oosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Phawuloosi entta sarothidaappe guye Ayhude gidonna asaa giddon ba baggara Xoossay oothidabaa ubbaa enttaw odis. ");
INSERT INTO gofRNT_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Entti hessa si7ida wode Xoossaa galatidi Phawuloosakko hayssada yaagidosona: “Nu ishaw, Ayhudeta giddon aappun mukulati Xoossaa ammanidaakko ne be7aasa; entti ubbayka higgiya minthi naagoosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Neeni Ayhude gidonnayssata biittan de7iya Ayhude ubbay bantta nayta qaxxaronna mela, Ayhudeta wogaa kaallonna melanne Muse higgiya ixxana mela neeni tamaarsseyssa Yerusalaamen de7iya Ayhudeti si7idosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Yaatin aybi lo77o? Neeni yidayssa daroti si7ana. ");
INSERT INTO gofRNT_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","“Hessa gisho, nuuni new odeyssa si7a; gasoy de7iya oyddu asati nu matan de7oosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Entta ekkada enttara geeya; qassi entti bantta huu7iya meedettana mela enttaw miishe imma. Entti kase nebaa si7idayssi tuma gidonnayssanne neeni ne huu7enkka higge naagiya asi gideyssa ubbay erana. ");
INSERT INTO gofRNT_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","“Shin ammanida Ayhude gidonna asata gidikko, entti eeqas yarshshettidabaa moonna mela, suuthu uyonna mela, bawuta moonna melanne laymatonna mela, nuuni oda qachchidi, enttaw dabddaabbe xaafida” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Hessafe guye, Phawuloosi wonttetha gallas asata ekkidi, enttara geeyis. I bantta geeya gallasay awude polettiyakko erisanawunne bantta yarshshuwa awude yarshshaneekko erisanaw Xoossa Keethi gelis. ");
INSERT INTO gofRNT_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Laappun gallasay wurana hanishin, Iisiyappe yida Ayhudeti Xoossa Keethan Phawuloosa be7idi, asa ubbaa denthethidi Phawuloosa oykkidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","“Isra7eele asaw, nuna maaddite; ha uray, nu deriya, nu higgiyanne ha Xoossa Keetha ixxana mela asa ubbaa tamaarssees. Hessika gidonna ixxin Ayhude gidonnayssata Xoossa Keethi gelssidi, ha geeshsha bessaa tunisis” yaagidi waassidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Entti hessa giday kase Efesoona Xirofimoosa Phawuloosara kataman be7ida gisho ha77i Phawuloosi Xoossa keethi iya ekki gelidabaa enttaw daanis. ");
INSERT INTO gofRNT_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Katama ubbay buqettis; asa ubbay shiiqidi Phawuloosa oykkidi Xoossa Keethafe kare goochchidosona. Xoossa Keethaa penggeti ellesidi gorddettidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Asay Phawuloosa wodhana hanishin, “Yerusalaame katamay kumethi buqettis” giya oday Roome shaalaqaakko gakkis. ");
INSERT INTO gofRNT_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Shaalaqay wotaaddaretanne mato halaqata ekkidi woxxishe yis. Asay shaalaqaanne wotaaddareta be7ida wode Phawuloosa wadhdheyssa aggaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","He wode shaalaqay shiiqidi, Phawuloosa oykkidi, nam77u santhalaatan qashettana mela kiittis. Yaatidi, I ooneekkonne ay oothidaakko asaa oychchis. ");
INSERT INTO gofRNT_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Asaappe baggay issibaa gidi waassiya wode harati harabaa gidi waasses. Waasoy darida gisho shaalaqay tumaa shaakkanw dandda7ettonna ixxin, wotaaddareti Phawuloosa bantta de7iyaso efana mela kiittis. ");
INSERT INTO gofRNT_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Phawuloosi yedhdhi keyaa dethaa gakkiya wode asaa sugethaa gisho wotaaddareti iya tookkidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Daro asay, “I hayqqo!” yaagidi waassishe kaalloosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Wotaaddareti Phawuloosa bantta de7iyasuwa gelssana hanishin, Phawuloosi shaalaqaakko, “Taani new issibaa odo?” yaagis. I Phawuloosakko, “Neeni Girike doona eray? ");
INSERT INTO gofRNT_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Neeni hayssafe sinthe buqethi medhdhidi shemppo wodhida oyddu mukulu asata ekkidi bazzo gelida Gibxxe uraa gidikkii?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Shin Phawuloosi, “Taani, Kilqiyan de7iya erettida Terseese kataman yelettida Ayhude asi. Hayyana tana odisarkkii?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Shaalaqay iyaakko, “Oda” yaagin Phawuloosi dethaa bolla eqqidi, asay si77i gaana mela ba kushiyan mallis. Asay si77i gin Ibraysxe doonan hayssada yaagis: ");
INSERT INTO gofRNT_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Ta ishato, ta aawato, taani ha77i hinttew immiya zaaruwa si7ite.” ");
INSERT INTO gofRNT_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Phawuloosi enttaw Ibraysxe doonan odeyssa si7idi kaseyssafe aathidi si77i gidosona. I kaallidi, ");
INSERT INTO gofRNT_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Taani Kilqiyan de7iya Terseesen yelettada ha kataman diccas. Ta asttamaareykka Gamaaliyale; taani nu aawata higgiya mintha tamaarida, hachchi hintte ubbay haneyssada Xoossaas mishettiya Ayhude asi. ");
INSERT INTO gofRNT_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Taani ha ogiya kaalliya maccatanne addeta oykkada qasho keethan yeggashenn entta wodhisana gakkanaw waaye bessida asi. ");
INSERT INTO gofRNT_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Hessadakka, kahine halaqaynne Shanggo ubbay tabaa markkattanaw dandda7ees. Taani Damasqqon de7iya entta ishatas enttafe dabddaabbe ekkada yan de7iya asati qashettidi seerettana mela Yerusalaame entta ehanaw yaa bas. ");
INSERT INTO gofRNT_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Taani bada Damasqqo matida wode seeta gallas qopponna saloppe gita poo7oy ta yuushuwan poo7is. ");
INSERT INTO gofRNT_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Taani sa7an kundda de7ishin, ‘Saa7ola, Saa7ola, tana ays goodday?’ giya qaala si7as. ");
INSERT INTO gofRNT_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Taani zaarada, ‘Godaw, neeni oonee?’ yaagas. I zaaridi, ‘Taani, neeni gooddiya Naazirete Yesuusa’ yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Taara de7eyssati poo7uwa be7idosonappe attin taw odeyssa qaala akeekibookkona. ");
INSERT INTO gofRNT_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","“Taani, ‘Godaw, ta ay ootho?’ yaagas. “Goday taakko, ‘Denddada Damasqqo ba. Neeni oothana mela Xoossay qoppidaba ubbay yan new odettana’ yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","He wolqqaama poo7uwa gaason ta ayfey qooqin, taara de7iya asati ta kushiya oykkidi, tana goochchin Damasqqo gakkas. ");
INSERT INTO gofRNT_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Damasqqon de7iya Ayhude ubbay daro bonchchiya issi Hananiya giya addey, nu higgiya bonchcheysinne Xoossaa minthi woosseyssi de7ees. ");
INSERT INTO gofRNT_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Hananey taakko yidi, ta matan eqqidi, ‘Ta ishaw Saa7olaa, xeella’ yaagis. Ellesada taani iya xeella aggas. ");
INSERT INTO gofRNT_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","“I taakko, ‘Nu aawata Xoossay neeni iya sheniya erana mela, iya xillo Na7aa be7ana melanne iya doonappe qaala si7ana mela kasetidi nena dooris. ");
INSERT INTO gofRNT_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Neeni be7idabaanne si7idabaa asa ubbaa sinthan iyaw markkattana. ");
INSERT INTO gofRNT_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Ha77i ays gam77ay? Denddada xammaqetta; iya sunthaa xeegada ne nagaraappe meecetta’ yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Taani guye Yerusalaame simmada Xoossa Keethan woossishin, taw qonccethi benttis. ");
INSERT INTO gofRNT_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Qonccethan Goday taakko, ‘Ne taw markkattiya markkatethaa asay ekkonna gisho ellesada Yerusalaameppe keya’ yaagishin be7as. ");
INSERT INTO gofRNT_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","“Taani, ‘Godaw, Ayhude Woosa Keetha ubban nena ammaneyssata oykkada wadhdhidayssanne qasho keethan yeggidayssa entti eroosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Entti ne markka Isxifaanose wodhiya wode taani he odan issifas. Qassi entta matan eqqada iya wodheyssata ma7uwa naagays’ yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","“Goday taakko, ‘Taani nena Ayhude gidonna asaakko haahoso kiittiya gisho denddada ba’ ” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Phawuloosi he qaala odidi ongana gakkanaw asay I geyssa si7oosona. Hessafe guye, bantta qaala dhoqqu oothidi, “Hayssa biittafe dhayssa! I daanaw bessenna” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Entti wocamishin, bantta ma7uwa bolla holishininne baana bolla laallishin; ");
INSERT INTO gofRNT_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Shaalaqay be7idi wotaaddareti Phawuloosa bantta de7iyasuwa efana mela kiittis. Qassi asay ays hessada wocamidaakko eranaw koyidi Phawuloosa lisson garaafidi pilggana mela entta kiittis. ");
INSERT INTO gofRNT_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Shin wotaaddareti Phawuloosa dafon minthi qachchidi garaafana haniya wode Phawuloosi ba matan eqqida mato halaqaakko, “Roome asi pirddi baynna garaafeyssi hinttew wogee?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Mato halaqay hessa si7ida wode shaalaqaakko bidi, “Ha addey Roome asi. Neeni ay oothanaw qoppay?” yaagidi oychchis. ");
INSERT INTO gofRNT_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Shaalaqay Phawuloosakko shiiqidi, “Neeni Roome ase? Ane taw oda” yaagis. Phawuloosi, “Ee” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Shaalaqay zaaridi, “Taani ha gadetethaa daro miishen shammas” yaagis. Shin Phawuloosi, “Ta ha gadetethaa yeletethan demma ekkas” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Hessa gisho, Phawuloosa pilgganaw qoppidayssati iira iyappe shaakettidosona. Shaalaqay Roome asi santhalaatan qachchidayssa erida wode yayyis. ");
INSERT INTO gofRNT_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Wonttetha gallas Shaalaqay, Ayhudeti Phawuloosa ays mootidaakko geeshshi eranaw koyis. Kahine halaqatinne shanggo ubbay shiiqana mela kiittis; qassi Phawuloosa qashoppe bilisidi entta sinthan essis. ");
INSERT INTO gofRNT_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Phawuloosi shiiquwa caddi xeellidi, “Ta ishato, taani hachchi gakkanaw Xoossaa sinthan ta de7o ubban lo77o wozanan de7as” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Kahine halaqay Hananey, Phawuloosa doonan baqqana mela iya matan eqqidayssata kiittis. ");
INSERT INTO gofRNT_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","He wode Phawuloosi iyaakko, “La ne booqqinte tiyida goda daaneysso, Xoossay nena baqqana. Neeni ta bolla higgiyatho pirddanaw uttada de7ashe higgey baynna tana baqqana mela kiitay?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Phawuloosa matan eqqidayssati iyaakko, “Ne Xoossaa kahine halaqaa cayay?” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Phawuloosi, “Ta ishato, I kahine halaqa gididayssa taani erabiikke; ays giikko Xoossaa qaalan, ‘Ne deriya ayseyssa bolla iita qaala haasayoppa’ geetetti xaafettis” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Shin Phawuloosi he bessan de7iya asaappe baggati Saduqaaweta, baggati Farisaaweta gideyssa be7idi, “Ta ishato, taani Farisaawenne Farisaawe na7a; ‘Hayqqidayssati hayqoppe denddana’ gada taani ufayssan naagiya gisho entti ta bolla pirddoosona” yaagidi odis. ");
INSERT INTO gofRNT_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Phawuloosi hessa gida wode Farisaaweta giddoninne Saduqaaweta giddon ooshshi keyin shaakettidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Ays giikko, Saduqaaweti, “Hayqqida asi denddenna; kiitanchchoyka ayyaanikka baawa” yaagosona. Shin Farisaaweti nam77ayka de7eyssa ammanoosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Gita kachchi keyis; Farisaaweta bagga gidida higge asttamaareti denddi eqqidi, “Ha uraa bolla aybi balakka demmibookko; iyaw ayyaani woykko kiitanchchoy haasayonna aggenna” yaagidi palamidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Ooshshay darin asay Phawuloosa shaqerethonna mela gidi, shaalaqay ba wotaaddareti wodhdhidi entta giddofe iya ellesi kessidi bantta de7iyasuwa efana mela kiittis. ");
INSERT INTO gofRNT_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","He qamma Goday Phawuloosa matan eqqidi, “Phawloosaa, neeni taw Yerusalaamen markkattidaysada Roomenkka markkattanaw bessees; minna; aykkoy baawa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Wonttetha gallas Ayhudeti, “Phawuloosa wodhonna de7ishe mookko uyokko” gidi caaqqidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Phawuloosa bolla hessa maqettida asati oytamappe daroosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Entti kahine halaqatakkonne deriya cimatakko bidi, “Nuuni Phawuloosa wodhonna de7ishe kathi giyabaa mookko gidi caaqqida. ");
INSERT INTO gofRNT_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Hiza, hinttenne shanggoy iyabaa geeshshidi pilggiyabay de7iya daanisidi, Phawuloosa hintteko ehana mela shaalaqaa oychchite. Nuuni I ha shiiquwa gakkanaappe sinthe iya wodhanaw giigidi uttida” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Shin Phawuloosa michche na7ay he maqquwa si7ida wode bidi wotaaddareti de7iyasuwa gelidi, Phawuloosas odis. ");
INSERT INTO gofRNT_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Phawuloosi mato halaqatappe issuwa xeegidi, “Ha na7ay shaalaqas odiyabay de7iya gisho iya shalaqaakko efa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Mato halaqay na7aa shaalaqaakko efidi, “Qasho keethan de7iya Phawuloosi tana baakko xeegidi, ha na7ay new odiyabay de7iya gisho iya neekko ehana mela tana woossis” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Shaalaqay na7aa kushiya oykkidi, dumma kare kessidi, “Neeni taw odanabay aybe?” yaagidi oychchis. ");
INSERT INTO gofRNT_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Na7ay shaalaqaakko, “Ayhudeti Phawuloosabaa kaseppe minthi pilgganaw koyidabaa daanisidi neeni wontto iya shiiquwa ehana mela nena woossanaw zoretaa qachchidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Shin neeni entti giyabaa si7oppa. Ays giikko, oytamappe dariya asati Phawuloosa wodhonna de7ishe ‘Kathi mookko, haathe uyokko’ gidi caaqqidi, qosettidi iya naagoosona. Ha77i ne giyabaa xalaala si7anaw naagoosona” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Shaalaqay zaaridi, “Ha oda ne taw odidayssa hara ooddeskka odoppa” yaagidi na7aa guye yeddis. ");
INSERT INTO gofRNT_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Shaalaqay mato halaqatappe nam77ata xeegidi, “Qammafe heedzu saaten Qisaariya baanaw, nam77u xeetu wotaaddareta, laappun tammu para asatanne nam77u xeetu tooranchchota giigisite. ");
INSERT INTO gofRNT_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Deriya aysiya Filkkisakko Phawuloosa saro gathanaw toga mehe giigisite” yaagidi entta kiittis. ");
INSERT INTO gofRNT_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Shaalaqay Filkkisas hayssada giya dabddaabbe xaafis: ");
INSERT INTO gofRNT_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Qalawudiyoosa Luusiyosappe deriya aysiya bonchcho Filkkisas, saroy new gido. ");
INSERT INTO gofRNT_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Ayhudeti ha uraa oykkidi wodhana hanishin, I Roome biitta asi gidoyssa erada wotaaddaretara gakkada iya ashshas. ");
INSERT INTO gofRNT_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Entti iya ays mootiyakko eranaw koyada entta shiiquwan iya shiishas. ");
INSERT INTO gofRNT_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Entti bantta higgiyas iya mootidayssafe attin iya wodhisiyabaa woykko qashisiyabaa gidonnayssa ta demmas. ");
INSERT INTO gofRNT_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Entti ha uraa bolla maqettida zigirssay tana gakkin, taani ellesada iya neekko yeddas. Iya mooteyssati ne sinthan bidi mootana mela kiittas” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Hessa gisho, wotaaddareti kiitettidayssada Phawuloosa ekkidi, qamma Antiphaxirisa gathidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Wonttetha gallas para asati iyara baana mela oothidi toho asati guye simmidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Togay Qisaariya gakkidi dabddaabbiya deriya ayseyssas immidi, Phawuloosa iya sinthe aathidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Deriya ayseyssi dabddaabbiya nabbabidaappe guye “Phawuloosa, ne aw awuraajja asee?” gidi iya oychchis. I Kilqiya asi gidoyssa erida wode ");
INSERT INTO gofRNT_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","“Taani nebaa nena mooteyssati yaa wode si7ana” yaagis. Wotaaddareti Phawuloosa Heroodisa keethan naagana mela kiittis. ");
INSERT INTO gofRNT_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Ichchashu gallasappe guye kahine halaqay, Hananey, cimataranne Xerxeluusa giya issi xabaqaara Qisaariya bis. Entti deriya ayseyssa bolla Phawuloosa mootidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Phawuloosi xeegettidi gelida wode Xerxeluusi iya hayssada yaagidi mootis: “Bonchcho Filkkisa, nuuni ne baggara daro sarotethaa demmida, ne lo77o aysuwan nu biittay daro laamettis. ");
INSERT INTO gofRNT_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Bonchcho Filkkisa, nuuni awunkka awude gidin daro galatan hessa ekkoos. ");
INSERT INTO gofRNT_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Taani nena gam77isonnashin neeni ne keehatethan nubaa qanthan si7ana mela nena woossays. ");
INSERT INTO gofRNT_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Ha uray dhube gididi biitta ubban de7iya Ayhudeta giddon buqethi medhdhidi Naaziraweta bagga asaa kaaletheyssa gidoyssa erida. ");
INSERT INTO gofRNT_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Hari attoshin, Xoossa Keetha tunisana hanishin nuuni iya oykkida; nu higgiyada iya bolla pirddanaw qoppida. ");
INSERT INTO gofRNT_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Shin shaalaqaa Luusiyosi yidi, wolqqan nu kusheppe iya wothi ekkis. ");
INSERT INTO gofRNT_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Iya mooteyssatikka neekko yaana mela kiittis. Neeni ne huu7en ha uraa pilggada nuuni iya mootiya mootuwa ubbaa eranaw dandda7aasa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Ayhudetikka, “Ha oday tuma” gidi iya qofaa ma77idosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Deriya ayseyssi Phawuloosa oda gidi mallis. Phawuloosi hayssada gidi zaaris: “Neeni daro wodeppe doomada, ha asaas pirddashe de7eyssa erada ta odas ufayssan zaaro immays. ");
INSERT INTO gofRNT_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Taani goynnanaw Yerusalaame keyin tammanne nam77u gallasappe aadhdhonnayssa neeni ne huu7en eranaw dandda7aasa. ");
INSERT INTO gofRNT_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Ayhudeti tana Xoossa Keethan gidin Ayhude Woosa Keethan gidin kataman gidin oodderakka palamishin woykko ase shiishada maqqishin issi asikka demmibeenna. ");
INSERT INTO gofRNT_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Ha77ika entti tana mootiyabaas markka demmanaw dandda7okkona. ");
INSERT INTO gofRNT_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","“Shin taani issibaa ammanays; taani higgen de7iyabaanne nabeti xaafida ubbabaa ammanada, nu aawata Xoossaa, entti worddo giya ogiyan goynnays. ");
INSERT INTO gofRNT_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Entti bantta huu7en ammaneyssa mela xillotinne nagaranchchoti hayqoppe denddanayssa takka ammanays. ");
INSERT INTO gofRNT_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Hessa gisho, taani Xoossa sinthaninne asa sinthan ubba wode lo77o kahi taw daana mela minnays. ");
INSERT INTO gofRNT_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Taani Yerusalaameppe keyoosappe daro laythafe guye ta biittaa manqotas maade immanawunne yarshsho yarshshanaw Yerusalaame bas. ");
INSERT INTO gofRNT_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Taani Xoossa Keethan hessa oothada geeshsha wogaa pola simmin tana demmidosona. He wode taara asi baawa, ooshshikka keyibeenna. ");
INSERT INTO gofRNT_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Shin Iisiyappe yida issi issi Ayhudeti yan de7oosona; entti ta bolla oda koykko yidi tana ne bolla mootanaw dandda7osona. ");
INSERT INTO gofRNT_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Woykko taani shangguwa sinthe shiiqida wode oothida bali de7ikko hayssati ne sinthan de7eyssati odona. ");
INSERT INTO gofRNT_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Taani entta giddon eqqada, ‘Hayqqidayssati denddana gada waassada odida gisho hachchi hintte sinthan ta bolla pirddoosona’ gas; hessafe harabaa oothabikke” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Shin Filkkisi Xoossaa ogiyabaa geeshshi erida gisho “Taani hintte oda shaalaqaa Luusiyosi yaa wode pirddana” yaagidi moyzis. ");
INSERT INTO gofRNT_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Filkkisi qassi Phawuloosa qachchonna naagana melanne iya dabbotappe oonikka iya oychchanaw yishin diggonna mela mato halaqaas odis. ");
INSERT INTO gofRNT_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Guutha gallasappe guye, Filkkisi Ayhude bagga gidida ba machche Dirusillara yidi Phawuloosa kiitti ehisidi Yesuus Kiristtoosan ammanobaa iyappe si7is. ");
INSERT INTO gofRNT_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Phawuloosi xillotethabaa, ba huu7e haarobaanne yaanaw de7iya pirddabaa odishin, Filkkisi yayyidi, “Neeni ha77is ba; taw injjetida wode nena xeegisana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","He wode Phawuloosappe gubbo ekkanaw qoppidi iya zaari zaari xeegisidi iyara odettees. ");
INSERT INTO gofRNT_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Nam77u laythafe guye, Filkkisa bessaa Phorqiyoos Fisxoosi ekkis. Filkkisi Ayhudeta ufayssanaw koyidi Phawuloosa billonna aggaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Fisxoosi kawotida heedzu gallasappe guye Qisaariyappe Yerusalaame bis. ");
INSERT INTO gofRNT_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Yan kahine halaqatinne Ayhudeta kaaletheyssati Phawuloosa mootidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Phawuloosa Yerusalaame ehishin ogen qosettidi iya wodhanaw enttaw injjetana mela banttana maaddo gidi Fisxoosa woossidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Fisxoosi enttako, “Phawuloosi, Qisaariyan qasho keethan de7ees; taani ta huu7enkka ellesada guye simmana hanays. ");
INSERT INTO gofRNT_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","I balidabay de7ikko hintte giddon aawateyssati taara Qisaariya bidi iya mootona” yaagidi zaaris. ");
INSERT INTO gofRNT_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Fisxoosi entta matan hosppun woykko tammu gallasa mela gam77idaappe guye Qisaariya bis. Wonttetha gallas pirdda oydiyan uttidi Phawuloosa ehana mela kiittis. ");
INSERT INTO gofRNT_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","I yin Yerusalaameppe yida Ayhudeti iya yuushuwan eqqidi entti lathanaw dandda7onna daro deexo mooto iya bolla shiishidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Phawuloosi zaaridi, “Taani Ayhude higgiya gidin Xoossa Keethaa woykko Roome Kawuwa Qeesare naaqqabiikke” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Shin Fisxoosi Ayhudeta ufayssanaw koyidi Phawuloosakko, “Yerusalaame bada ha mootuwabaa yan ta sinthan pirddettanaw koyay?” yaagidi oychchis. ");
INSERT INTO gofRNT_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Shin Phawuloosi, “Taani pirddettanaw bessiya Qeesare pirdda keethan eqqa kichchas. Neeni loytha ereyssada taani Ayhudeta aybinkka naaqqabiikke. ");
INSERT INTO gofRNT_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Hiza, taani naaqqidabay woykko hayqos gathiyaba oothidabaa gidikko hayqoppe tana ashsha giikke. Shin entti tana mootiya mootoy coo gidaappe guye oonikka tana enttaw aathi immanaw dandda7enna. Qeesarey tabaa pirddo gada oychchays” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","He wode Fisxoosi ba zoranchchotara zorettidi, “Neeni Qeesarey tabaa pirddo gada oychchadasa; Qeesarekko baasa” yaagidi zaaris. ");
INSERT INTO gofRNT_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Guutha gallasappe guye Kawoy Agirphinne Barnniiqey Fisxoosa sarothanaw Qisaariya bidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Yan entti daro gallas gam77in, Fisxoosi Kawuwas Phawuloosabaa hayssada yaagidi odis; “Filkkisi billonna aggidi bida issi addey hayssan de7ees. ");
INSERT INTO gofRNT_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Taani Yerusalaame bida wode kahine halaqatinne Ayhude cimati iya bolla pirddana mela tana woossidi iyabaa taw odidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Taani, ‘Mootettida uray bana mooteyssata sinthan eqqidi ba mootidabaas zaaro immonnashin, oona gidikkoka aadhdhidi imetteyssi Roome higge gidenna’ yaagada enttaw zaaras. ");
INSERT INTO gofRNT_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","“Hessa gisho, entti hayssan shiiqida wode taani gam77onna wonttetha gallas pirdda keethaa gelada Phawuloosa ehana mela kiittas. ");
INSERT INTO gofRNT_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Iya mooteyssati iya matan eqqidi, iitaban iya mootonna aggokona gada taani qoppidayssa mela iya mootibookkona. ");
INSERT INTO gofRNT_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Shin entti bantta ammanobaanne Phawuloosi, ‘Paxa de7ees’ giya issi hayqqida Yesuusa geetettiya addiyabaa iyara palamoosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Ha oday tana shaakkanaw metida gisho Phawuloosi Yerusalaame bidi, yan pirddettanaw koyakko gada iya oychchas. ");
INSERT INTO gofRNT_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Shin Phawuloosi ba oda Qeesarey be7ana gakkanaw qasho keethan gam77anaw oychchis. Taani iya Qeesarekko yeddana gakkanaw I qashettana mela kiittas” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Hessa gisho, Agirphi Fisxoosakko, “Taani ta huu7enkka he uray giyabaa si7anaw koyays” yaagis. Fisxoosi iyaakko, “Neeni wontto I giyabaa si7ana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Wonttetha gallas Agirphinne Barnniiqey gita bonchchon shaalaqataranne kataman de7iya gita asatara yidi pirdda keethi gelidosona. Fisxoosi Phawuloosa xeegisidi ehis. ");
INSERT INTO gofRNT_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Fisxoosi, “Kawaw Agirpha, hayssan nuura de7iya asaw, Ayhudeti Yerusalaamenkka hayssankka waassidi, ‘I hizappe guye paxa daanaw bessenna’ yaagidi, tana woossida uraa hayssa be7eeta. ");
INSERT INTO gofRNT_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Shin iya hayqos gathiyabaa aybibaakka taani demmabiikke. I ba huu7en, ‘Qeesarey tabaa pirddo yaagada oychchays’ gida gisho Qeesarekko iya yeddanaw qofa qachchas. ");
INSERT INTO gofRNT_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Taani iyabaa ta godaa Qeesares xaafanaw gidiya gaasoy aybikka baawa. Hessa gisho, iyabaa hintte be7ikko ta xaafiyabay benttaneekko gada hintte sinthe ubbarakka Kawaw, Agirpha, ne sinthe iya ehas. ");
INSERT INTO gofRNT_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Ays giikko, qashettida asi bolla daynnas aathiya wode I ays mootettidaakko Qonccisonna aggeyssi taw eeyatethi daanees” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Agirphi Phawuloosakko, “Neeni nebaa odanaw dandda7aasa” yaagis. He wode Phawuloosi ba kushiya denthidi hayssada yaagis: ");
INSERT INTO gofRNT_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Kawaw, Agirpha, Ayhudeti tana mootidabaas zaaro immanaw hachchi ne sinthan eqqashe ta qaaday lo77o gada qoppays. ");
INSERT INTO gofRNT_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Neeni Ayhude wogaanne palamaa loythada eriya gisho tana salettonna si7ana mela woossays. ");
INSERT INTO gofRNT_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Taani na7atethafe doomada ta asaa giddoninne Yerusalaamen de7ida ta de7uwa Ayhude ubbay eroosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Taani koyroppe doomada, nu ammano higgiya minthidi naagiya Farisaaweta yaraappe gideyssa entti markkattanaw koykko eroosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Ha77ika taani Xoossay nu aawatas immana gida ufayssaa naagiya gisho mootettada hayssan eqqas. ");
INSERT INTO gofRNT_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Qassi tammanne nam77u nu aawata sheeshay Xoossaa qammanne gallas minthidi goynnishe Xoossay immana gidayssa ekkanaw ufayssan naagoosona. Kawaw Agirphaa, Ayhudeti tana mootey taani ufayssan hessa naagiya gishossa. ");
INSERT INTO gofRNT_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Ayhudetoo, Xoossay hayqqidayssata dentheyssa ays ammanekketii? ");
INSERT INTO gofRNT_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Kase taani ta huu7enkka Naazirete Yesuusa sunthaa teqqanaw dandda7ettidaba ubbaa oothanaw bessees gada qoppas. ");
INSERT INTO gofRNT_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Taani Yerusalaamen oothiday hayssa. Kahine halaqatappe maata ekkada Xoossaa asatappe darota qashisas. Entta wodhiya wodekka entta hayquwa dosas. ");
INSERT INTO gofRNT_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Daro wode Ayhude Woosa Keethaa ubban entti seerettana melanne Yesuusa cayidi kaddana mela un77ethas. Taani wogi baynna entta hanqettada hari attoshin, hara biitta katamata gakkanaw entta goodas. ");
INSERT INTO gofRNT_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Taani ha odas kahine halaqatappe maatanne kiitaa ekkada Damasqqo bays. ");
INSERT INTO gofRNT_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Kawaw, taani seeta gallas ogiyan de7ishin awa poo7oppe daro aadhdhiya poo7oy ta yuushuwaninne taara beyssata yuushuwan saloppe poo7is. ");
INSERT INTO gofRNT_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Nuuni ubbayka sa7an kunddida wode Ibraysxe doonan, ‘Saa7ola, Saa7ola, tana ays goodday? Neeni nena caddiya xam77aa qakkiko nena qohaasa’ yaagidi taw odishin si7as. ");
INSERT INTO gofRNT_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","“Taani, ‘Godaw, neeni oonee?’ yaagas. “Goday, ‘Taani, neeni gooddiya Yesuusa; ");
INSERT INTO gofRNT_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","shin dendda eqqa. Hachchi neeni tana be7idayssaninne sinthafe ta nena bessanyssa haratas markkattana mela ta oosanchcho oothada nena shuumanaw new benttas. ");
INSERT INTO gofRNT_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Isra7eele asatappenne taani nena enttako kiittiya Ayhude gidonnayssatappe nena ashshana. ");
INSERT INTO gofRNT_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Neeni entta ayfiyaa dooyana, dhumappe poo7okko, Xalahe kusheppe Xoossako entta zaarana. Entti tanan ammanidi nagara atotethaa ekkana. Xoossay doorida asaa giddon bantta laata demmana’ yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Kawaw Agirphaa, hessa gisho, taw saloppe benttida qonccethas kiitettanayssa ixxabiikke. ");
INSERT INTO gofRNT_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Shin taani koyrottada Damasqqon hessafe guye Yerusalaameninne Yihuda biitta ubban de7eyssatinne Ayhude gidonnayssati bantta nagaraappe Xoossaakko simmana melanne nagaraappe simuwa bessiya ooso oothana mela qaala odas. ");
INSERT INTO gofRNT_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Hessa gisho, Ayhudeti tana Xoossa Keethan oykkidi wodhanaw koyidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Hachchi gakkanaw Xoossaa maadey taappe shaakettibeenna; yaaniya gisho, guuthaasinne gitaas markkattashe hayssan eqqas. Nabetinne Musey hanana gidi odidayssafe haraa issibaakka taani odidabay baawa. ");
INSERT INTO gofRNT_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Hessika, ‘Kiristtoosi waaye ekkanaw bessees; qassi hayqoppe koyro denddidi Ayhudetasinne Ayhude gidonnayssatas atotetha poo7o odanaw bessees’ gidayssa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Phawuloosi hessa yaagidi zaarishin, Fisxoosi ba qaala dhoqqu oothidi, “Phawloosaa, ne gooyadasa; ne daro timirttey nena gooshshas gathis” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Shin Phawuloosi, “Bonchcho Fisxoosaa, taani tumaabanne bessiyabaa odaysippe attin gooyabiikke. ");
INSERT INTO gofRNT_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Taani qonccen odiya odaa Kawoy erees. Ha oday geeman oosettiboonna gisho issoykka iyappe geemmonayssa taani geeshshada erays. ");
INSERT INTO gofRNT_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","“Kawaw Agirphaa, neeni nabeta ammanaasa gidikkii? Neeni ammaneyssa taani erays” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Kawoy Agirphi, Phawuloosakko, “Ha guutha saaten tana ammanthanaw koyay?” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Phawuloosi, “Daro wode gidin guutha wode ne xalaala gidonnashin hachchi taana si7iya ubbay ha qashuwappe attin ta mela gidana mela Xoossaa woossays” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Hessafe guye, Kawoy Fisxoosi, Barnniiqeynne enttara uttida ubbayka denddidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Yaappe keyidi bishe issoy issuwara, “Ha uray hayqos woykko qashos gathiyabaa aykkoka oothibeenna” yaagidi odettidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agirphi Fisxoosakko, “Ha uray ‘Qeesarey tabaa pirddo’ goonnaako bilettanaw dandda7ees, shin attis” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Nuuni markkabera Xaale baanaw qachchida wode Awugisxoosa wotaaddareta geetetteyssatappe issi Yuuliyoosa giya mato halaqaas Phawuloosanne hara guutha qasho asata immidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Iisiya gaxan de7iya biittata biya Adiramixiyoone markkaben gelidi denddida. Maqedooniya asi gidida Teselonqe Arsxirokoosi nuura de7ees. ");
INSERT INTO gofRNT_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Wonttetha gallas nuuni Sidoona gakkishin, Yuuliyoosi Phawuloosas keehidi ba laggetakko bidi koshshiyaban maadettana mela enttako yeddis. ");
INSERT INTO gofRNT_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Yaappe denddidi sinthara nu bolla carkkiya gisho haathan teqettida biittaa, Qoophiroosan zemppidi aadhdhida. ");
INSERT INTO gofRNT_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Kilqiyanne Phinfiliya matan de7iya abbaa pinnidi Liiqiyan de7iya Muura gakkida. ");
INSERT INTO gofRNT_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Yan mato halaqay Xaale biya Iskkinddiriya markkabe demmidi, iyan nuna gelssis. ");
INSERT INTO gofRNT_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Nuuni daro gallas loddara bidi, daro meton Qanddoosa katamaa mata gakkida. Yaara baanaw nuna carkkoy diggin Salmoonara aadhdhidi haathan teqettida biittaa, Qarxeesan zemppidi aadhdhida. ");
INSERT INTO gofRNT_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Daro meton gaxa gaxa oykkidi Laasiya katamaa matan de7iya abbaa doonan “Markkabey Woppu Gidi Shemppiyaso” giya bessaa gakkida. ");
INSERT INTO gofRNT_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Nuuni yan daro wodiya gam77idaappe guye xoomi bilettin, markkabera buussi metiya gisho Phawuloosi entta zoris. ");
INSERT INTO gofRNT_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Asaw, nu buussan gita boshinne daro qohoy de7eyssi taw benttees; qohoy caanaa bollanne markkabiya bolla xalaala gidonnashin nu de7uwa bollaka gakkana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Shin mato halaqay Phawuloosi gidayssafe aathidi markkabiya laaggeysinne markkabiya goday geyssa ammanis. ");
INSERT INTO gofRNT_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","He abbaa doonan de7iya katamay balggo ageena aathanaw enttaw injjetonna gisho dariya asati banttaw dandda7ettiko Finqqe katamaa gakkidi balggo ageena yan aathanaw zorettidosona. Finqqey pudeha-wulohappenne dugeha-wulohappe giddon abbaa doonan de7iya katama. ");
INSERT INTO gofRNT_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Kawushsha dugeha carkkoy loddara carkkida wode bantta qoppidayssada hanidabaa daanin denddidi, markkabey qaaxxonna mela oykkiya biraata pude ekkidi Qarxeesa matara aadhdhidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Shin daro gam77onna “Awuraqiis” giya wolqqaama gotey haathan teqettida biittaafe duge entta bolla denddis. ");
INSERT INTO gofRNT_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","He gotey markkabiya sugidi efonna diggida gisho carkkoy markkabiya ba dosida soo efis. ");
INSERT INTO gofRNT_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Nuuni Qeeda giya haathan teqettida biittaa zemppidi bishe daro metootettidi markkabiya wogoluwa ashshanaw dandda7ida. ");
INSERT INTO gofRNT_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Entti wogoluwa pude kessidaappe guye wodoruwan markkabiya bolla xaaxidi, minthi qachchidosona. Surtiisa giya shafiyan banttana dom77ethana gidi hirggidi, markkabiya sharaa wodhisidi markkabiya coo yeddi aggidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Gotey wolqqaamishe bin wonttetha gallas caanaappe baggaa abban holo oykkidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Heedzantho gallas markkabiya miishiya ekkidi bantta kushen holidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Nuuni daro gallas awa ayfenne xoolintto be7onna gishonne wolqqaama uushoy nu bolla uushida gisho sinthafe shemppora attana gidi qoppibookko. ");
INSERT INTO gofRNT_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","He wode entti daro gallas kathi moonna gam77ida gisho Phawuloosi entta giddon denddi eqqidi, “Asaw, hintte ta zoriya ekkidi Qarxeesappe denddonna aggidaako ha metoynne qohoy nuna gakkenna. ");
INSERT INTO gofRNT_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Shin taani hinttena yayyofite gada zorays; ays giikko, ha markkabey dhayanaappe attin hinttefe issi asa shemppoykka dhayenna. ");
INSERT INTO gofRNT_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Zine qamma ta iyabaa gididayssinne ta goynniya Xoossay kiittida kiitanchchoy ta matan eqqidi, ");
INSERT INTO gofRNT_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","‘Phawuloosa, yayyofa; neeni Roome Kawuwa Qeesare sinthan eqqanaw bessees. Hekko Xoossay ne gisho neera biya asa ubbaa shemppuwa ashshis’ yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Hessa gisho, asaw, yayyofite. He kiitanchchoy taw odidayssi hananayssa taani ammanays. ");
INSERT INTO gofRNT_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Shin carkkoy nuna efidi issi haathan teqettida biittaa gaxan holana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Tammanne oyddantho qamman Meditiraane Abban nuna carkkoy gedenne haa sugishin, gidi bilahe gidiya wode markkabiyan ootheyssatas biittako matidabaa daanis. ");
INSERT INTO gofRNT_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Entti ciimmotethaa eranaw koyidi wodoro xeeran deexiyabaa qachchidi abban yeggin, abbay hosppun tammu wadha gidis. Guuthi gam77idi, zaari yeggin usuppun tammu wadha gidis. ");
INSERT INTO gofRNT_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Entti abbaa gaxan de7iya shuchchan dom77ettona mela yayyidi, markkabey boonna mela oykkiya oyddu biraatata markkabiyappe guyera abban yeggidi, sa7ay wonttana mela Xoossaa woossosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Markkabiyan ootheyssati markkabiyappe baqatanaw koyidi, markkabey boonna mela oykkiya biraatata markkabiyappe sintha baggara abban yeggiya daanin wogoluwa abban yeggidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Phawuloosi mato halaqaakkonne wotaaddaretakko, “Hayssati markkabiyan shemppi uttonna ixxiko hintte attanaw dandda7ekketa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Hessa gisho, wotaaddareti wogoloy qashettida wodoruwa qanxidi yeddi aggidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Sa7i wonttana hanishin ubbay kathi maana mela Phawuloosi asaakko, “Hintte kathi moonna naagishe hachchira tammanne oyddu gallas gam77ideta. ");
INSERT INTO gofRNT_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Hessa gisho, guutha kathi hintte maana mela taani hinttena woossays. Hintte gashttana mela guutha kathi maanaw koshshees; hari attoshin hintte huu7e binaanaappe issoykka dhayenna” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Phawuloosi hessa gidi uythi ekkidi ubbaa sinthan Xoossaa galatis; uythaa menthidi muusu doomis. ");
INSERT INTO gofRNT_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Ubbay minettidi banttaw kathi ekkidi midosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Nuuni markkabiyan de7eyssati nam77u xeetanne laappun tammanne usuppuna. ");
INSERT INTO gofRNT_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Entti midi kallida wode caana gisttiya abban yeggidi markkabiya deexuwa kawushshidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Sa7i wonttida wode markkabiya oosanchchoti aw biitta gakkidaakko eronashin, abbaa gaxan de7iya shafenne silimo be7idosona. Banttaw dandda7ettiko markkabiya he shafiyakko shiishanaw qoppidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Yaatidi, markkabey boonna mela oykkiya biraatata birshshidi abban yeggidosona. He wode laaggiya mithaa qachchiya wodoruwa birshshidosona. Hessafe guye, carkkoy markkabiya sinthe sugana mela markkabiya efiya sharaa sintha baggara dhoqqu oothidi buussu doomidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Shin markkabey shafe dooren dom77ettidi mitettis. Markkabiyas sintha baggay xuggunidi shafiya caddi oykkidi qaaxxonna ixxin, guye baggay zuliya sugethan meqeretethi oykkis. ");
INSERT INTO gofRNT_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Wotaaddareti qasho asaappe issoykka haathaa wadhdhidi kessi ekkonna mela entta wodhanaw zorettidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Shin mato halaqay Phawuloosa ashshanaw koyidi wotaaddareta zoretaa ixxis. Haathe wadho eriya ubbay markkabiyappe haathan guppi guppi wodhdhidi kasetidi gaxa keyana mela kiittis. ");
INSERT INTO gofRNT_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Attidayssati sanqqaa bollanne, markkabiya me7uwa bolla keyana mela kiittis. Hessada hanidi ubbay gaxa sarora keyidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Nuuni gaxa saro keyida wode gakkida haathan teqettida biittay Maltta geetetteyssa erida. ");
INSERT INTO gofRNT_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Maltta asay nuus daro keeha keehidosona. Iri bukkiya gishonne meeggiya gisho tama eethidi nuna ubbaa mokkidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Phawuloosi daro afira shiishidi taman wothishin, shooshi seelaa gisho keyidi iya kushiya bolla xaaxettidi iya dukkis. ");
INSERT INTO gofRNT_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Maltta asay shooshi Phawuloosa kushen xaaxettidayssa be7ida wode issoy issuwako, “Tuma ha uray shemppo wodhida asi; hari attoshin abbaafe I attinkka xoossa pirddafe attidi paxa daanaw dandda7ibeenna” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Shin Phawuloosi ba kushiyappe shooshaa wuxarkkidi, taman yeggis; iya aykkoka qohibeenna. ");
INSERT INTO gofRNT_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Entti, “Iya asatethay kixxees, woykko akeekonna kunddidi hayqqees” gidi naagoosona. Shin daro wode naagidi iya asatethan aybikka dummattidabay dhayin, “Hayssi xoosse” yaagidi bantta qofaa laammidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","He heeran haathan teqettida biittaa halaqaa, Pupliyoosa geyssas gadey de7ees; heedzu gallas gakkanaw i nuna siiqon mokkis. ");
INSERT INTO gofRNT_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Pupliyoosa aaway qoxo, mishanne ulo uttison harggettidi zin77idi de7ees. Phawuloosi iya soo gelidi iyaw Xoossaa woossis; ba kushiya iya bolla wothidi pathis. ");
INSERT INTO gofRNT_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Hessafe guye, Malttan de7iya harggiya hara asatikka yidi paxidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Entti nuna daro bonchchidosona; nuuni markkabera baanaw denddida wode oges koshshiyabaa nuus immidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Heedzu ageenappe guye, Malttan balggo aathidi Iskkinddiriya markkabera baanaw denddida. He markkabiya bolla Diyosqoroosa giya mentte eeqata misiley de7ees. ");
INSERT INTO gofRNT_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Sirakuuse katamaa gelidi yan heedzu gallas uttida. ");
INSERT INTO gofRNT_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Yaappe denddidi Regiyume katamaa gakkida. Issi gallasappe guye, dugeha bagga carkkoy carkkin, wonttetha gallas Putiyoole katamaa gakkida. ");
INSERT INTO gofRNT_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Yan nuuni issi issi ammaniyaa asata demmin, banttara saamintta gam77ana mela nuna woossidosona. Hessafe guye, Roome bida. ");
INSERT INTO gofRNT_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Roomen de7iya ammaniyaa asati nubaa si7idi, Afiyoosa Giyaan, Heedzu Aqiyaso giya bessaa gakkanaw nuna mokkanaw yidosona. Phawuloosi entta be7ida wode Xoossaa galatidi minettis. ");
INSERT INTO gofRNT_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Nuuni Roome gelida wode Phawuloosi bana naagiya wotaaddariyara barkka de7o geetettis. ");
INSERT INTO gofRNT_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Heedzu gallasappe guye, Phawuloosi Ayhudeta halaqata baakko xeegisis. Entti shiiqida wode enttako, “Ta ishato, taani nu asaa woykko nu aawata wogaa bolla aybi qohokka oothabiikke, shin tana Yerusalaamen qachchidi Roome asaas aathidi immidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Entti ta mootuwa be7idi hayqos gathiyabaa ta bolla aybibaakka demmiboonna gisho tana billanaaw qoppidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Shin Ayhudeti hessa ixxida wode ‘Tabaa Qeesarey pirddo’ yaagasippe attin taani ta deriya mootiyabay de7in gidenna. ");
INSERT INTO gofRNT_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Taani hinttena xeegisiday hinttena be7anawunne hinttew hayssa odanaassa. Taani ha santhalaatan qashettiday Isra7eele asay naagiya ufayssaa gishossa” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Ayhude halaqati Phawuloosakko, “Nuus Yihudappe nebaa xaafettida dabddaabbey gakkibeenna. Yaappe yida asatappe issoykka nebaa iita odiday baawa. ");
INSERT INTO gofRNT_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Shin ha ne kaalliya ammanuwa dumma dumma bessan asay ixxeyssa nuuni eriya gisho ne qofaa si7anaw koyoos” yaagidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Entti bantta yaana gallas Phawuloosas qaxaridi, he gallas daridi i de7iyasuwa yidosona. I wonttafe omarssi gakkanaw Xoossaa kawotethaabaa enttaw markkattis. Qassi entti Yesuusabaa ammanana mela Muse higgiyafenne nabeta maxaafappe qonccisidi entta tamaarssis. ");
INSERT INTO gofRNT_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Issoti issoti Phawuloosi gidayssa ammanidosona, shin harati ammanibookkona. ");
INSERT INTO gofRNT_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Entti bantta giddon oda ma77onna ixxida wode Phawuloosi issibaa gidaappe guye bidosona. I hayssada yaagis: “Geeshsha Ayyaanay nu aawatas nabiya Isayaasa doonan odidayssi tuma. ");
INSERT INTO gofRNT_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","‘Neeni he asaakko bada, hintte sissaa si7eeta, shin hinttew gelenna; hintte be7o be7eeta, shin demmeketa. ");
INSERT INTO gofRNT_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Ha asaa wozanay muumis; entta haythay tullis; entta ayfeykka goozettis. Hessi baynneeko, entti bantta ayfiyaan be7idi, bantta haythan si7idi, bantta wozanan akeekidi, entti taakko simmana; takka entta pathanashin’ yaaga” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","“Hiza, hayssi Xoossaa atotethaa kiitay Ayhude gidonnayssatas gideyssa ereeta. Enttika si7ana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Phawuloosi hessa gidaappe guye Ayhudeti bantta giddon daro palamishe keyidi bidosona. ");
INSERT INTO gofRNT_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Phawuloosi kera keethan nam77u laythi kumethi de7is; yan de7ishe baakko yaa ubbaa mokkees. ");
INSERT INTO gofRNT_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Yashshi baynnanne oonikka diggonnashin Xoossaa kawotethaabaa sabbakis; Godaa Yesuus Kiristtoosabaa qonccisidi tamaarssees.");
INSERT INTO gofRNT_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Yesuus Kiristtoosa aylle gidida, hawaare gidana mela xeegettidayssafenne Xoossaa Wonggelaa sabbakana mela doorettida Phawuloosi kiittida kiitaa. ");
INSERT INTO gofRNT_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Xoossay daro wodeppe sinthe ba nabeta baggara immana yaagida Xoossaa Wonggelay Geeshsha Maxaafatan xaafettis. ");
INSERT INTO gofRNT_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","He Wonggelay ashon Dawite sheeshaappe yelettida, Xoossaa Na7aa, nu Godaa Yesuus Kiristtoosabaa. ");
INSERT INTO gofRNT_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Qassi I ba geeshsha Ayyaanan hayqoppe denddidi, Xoossaa Na7aa gideyssa gita wolqqan bessis. ");
INSERT INTO gofRNT_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Iya baggara Ayhude gidonna asa ubbay, ammanidi kiitettana mela Kiristtoosa sunthaa gisho Xoossay aadho keehatethinne hawaaretetha maata nuus immis. ");
INSERT INTO gofRNT_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Yesuus Kiristtoosas gidana mela xeegettida asatappe baggati hinttena. ");
INSERT INTO gofRNT_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Roomen de7iya, Xoossay siiqeyssatasinne iya geeshsha dere gidana mela dooridayssatas. Xoossaa nu Aawappenne Godaa Yesuus Kiristtoosappe aadho keehatethaynne sarotethay hinttew gido. ");
INSERT INTO gofRNT_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Ubbaafe koyrottada, hintte ammanoy biitta ubban si7ettida gisho Yesuus Kiristtoosa baggara hintte gisho ta Xoossaa galatays. ");
INSERT INTO gofRNT_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Taani iya Na7aa wonggelabaa kumetha wozanan odiya Xoossay, taani ta woossan ubba wode hinttena qoppeyssas I markka. ");
INSERT INTO gofRNT_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Wurssethan, Xoossaa shene gidikko, taani hintteko baanaw ogey taw injjetana mela ubba wode woossays. ");
INSERT INTO gofRNT_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Taani hinttew Ayyaana imuwa shaakkanawunne hinttena be7anaw laamotays. ");
INSERT INTO gofRNT_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Hessika, taani hintte ammanuwan, qassi hintte ta ammanuwan minettana melassa. ");
INSERT INTO gofRNT_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Ta ishato, taani Ayhude gidonna asaappe ayfe demmidayssada, hinttefekka ayfe demmanaw hintteko baanaw qoppas, shin digettas. ");
INSERT INTO gofRNT_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Tamaarida asaasinne tamaariboonna asaas qassi cinccatasinne eeyatas taw acoy de7ees. ");
INSERT INTO gofRNT_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Hessa gisho, Roomen de7iya hinttewuka Wonggelaa odanaw amottays. ");
INSERT INTO gofRNT_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Iya ammaniyaa ubbaa, koyrottidi Ayhudeta, kaallidi Ayhude gidonnayssata ashshanaw Wonggelay Xoossaa wolqqaa gidiya gisho ta Wonggelan yeellatikke. ");
INSERT INTO gofRNT_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Xilloy ammanon de7on daana geetettidi Geeshsha Maxaafan xaafettis. Wonggelaan Xoossaa xillotethay qonccis; koyroppe wurssethi gakkanaw asay xilley ammanona. ");
INSERT INTO gofRNT_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Tumay erettonna mela bantta iita ooson kammiya asaa bollanne nagara ubbaa bolla, Xoossaa hanqoy saloppe wodhdhees. ");
INSERT INTO gofRNT_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Xoossay enttaw qonccanaw bessiyabaa qonccisida gisho entti Xoossabaa eroosona. ");
INSERT INTO gofRNT_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Alamey medhettosappe doomidi, asaas benttonna Xoossaa kanddoy, hessika iya merinaa wolqqaynne Xoossatethay iya medhetethan qonccidi de7iya gisho asay bantta iitatethaas gaasoyaabay baawa. ");
INSERT INTO gofRNT_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Entti Xoossaa erishe, iya bonchchibookonanne galatibookkona. Entta qofay maaddonnabaa gidis; entta akeekonna wozanay dhumis. ");
INSERT INTO gofRNT_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Entti banttana cinccata goosona, shin eeyata. ");
INSERT INTO gofRNT_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Entti hayqqonna Xoossaa goynnanayssa aggidi, hayqqiya asa medhon, kafota medhon, do7ata medhoninne ulora gooshettiyabata daanisidi oothida misileta goynnidosona. ");
INSERT INTO gofRNT_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Hessa gisho, entti issoy issuwara borssobaa oothidi, bantta asatethaa kawushshana mela Xoossay entta wozanay amottiya tuna oosos entta yeggi aggis. ");
INSERT INTO gofRNT_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Hessi haniday entti Xoossaa tumaa worddon laammida gishonne medhdhida Xoossaa aggidi, medhetethi goynnida gishossa. Xoossay merinaw galatettidayssa. Amin77i. ");
INSERT INTO gofRNT_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Hessa gisho, Xoossay enttana entta borsso amuwaas yeggi aggis. Entta maccasay banttaw bessiya addera gahetethi aggidi, bessonnabaa hanidi maccasi maccasara gahettidosona. ");
INSERT INTO gofRNT_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Hessadakka, addeti banttaw bessiya maccasara gaytethi aggidi, addey addera gahettidosona. Addeti issoy issuwara amon xuugettidi, borssobaa oothidosona. Bantta oothida balaas bessiya pirddaa ekkidosona. ");
INSERT INTO gofRNT_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Entti Xoossaa erishe, hari attoshin iyabaa qoppanaw koyonna ixxida gisho bessonnabaa oothana mela Xoossay enttana pathonna qofas aathi immis. ");
INSERT INTO gofRNT_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Enttan geellatethi, iitatethi, yiiqey, geney, qanaatey, shemppo wodhoy, palami, cimoynne iita amoy kumis. Entti zigireyssata, ");
INSERT INTO gofRNT_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","asa sunthi iisseyssata, Xoossaa ixxeyssata, cayeyssata, otoreyssata, ceeqetteyssata, iitabaa oothanaw koyeyssatanne bantta aayesinne aawas kiitettonayssata, ");
INSERT INTO gofRNT_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","akeekonnayssata, caaqo mentheyssata, siiqoy baynnayssata, qadhey baynnayssata. ");
INSERT INTO gofRNT_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Hayssata mela ootheyssatas hayqoy bessees giya Xoossaa higgiya erishe, hayssata oothoosona. Entti banttaw ooso xalaala gidonnashin oothiya haratakka nashshoosona. ");
INSERT INTO gofRNT_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Hessa gisho, neno harata bolla pirddeysso, neeni gaasoyaabay baawa. Neeni harata bolla pirddashe, he neeni pirddiya uraa mela oothiko, nee, ne bolla pirddaasa. ");
INSERT INTO gofRNT_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Hessa mela ooso ootheyssata bolla Xoossay xillo pirddaa pirddeyssa nu eroos. ");
INSERT INTO gofRNT_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Neno, hessa mela ooso ootheyssata bolla pirddeysso, entti ootheyssa mela ootheysso, neeni Xoossaa pirddaafe attanabaa daanii? ");
INSERT INTO gofRNT_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Woykko Xoossaa keehatethaa, genccaanne dandda7a darotethaa kadhayye? Xoossay new keehiday nena nagaraappe zaaranaw gideyssa erikkiyye? ");
INSERT INTO gofRNT_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Shin hinttew shuchcha wozaninne si7onna haythi de7ees. Hessa gisho, Xoossaa hanqoynne xillo pirdday qoncciya gallas, ne bolla pirdday darana mela oothaasa. ");
INSERT INTO gofRNT_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Xoossay issuwas issuwas iya oosuwa mela immana. ");
INSERT INTO gofRNT_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Lo77o ooson minnidi, galataa, bonchchonne dhayonna de7uwa koyeyssatas Xoossay merinaa de7uwa immana. ");
INSERT INTO gofRNT_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Shin banttana siiqeyssata, tumaa ixxeyssatanne iitabaa oothanaw koyeyssata bolla Xoossaa hanqoynne pirdday yaana. ");
INSERT INTO gofRNT_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Iitabaa oothiya asa ubbaa, koyrottidi Ayhudeta, kaallidi Ayhude gidonna asaa metoynne waayey gakkana. ");
INSERT INTO gofRNT_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Shin Xoossay lo77o ooso oothiya ubbaas, koyrottidi Ayhudetas, kaallidi Ayhude gidonnayssatas galataa, bonchchonne sarotethaa immana. ");
INSERT INTO gofRNT_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Xoossay som77o be7idi ase shaakkenna. ");
INSERT INTO gofRNT_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Higgey baynna nagara oothida ubbay higgey baynna dhayana. Higgey de7ishin, nagara oothida ubbay higgen pirddettana. ");
INSERT INTO gofRNT_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Xoossaa sinthan xilleyssati higge naageyssatappe attin higge sissa xalaala si7eyssata gidokkona. ");
INSERT INTO gofRNT_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Higgey baynna Ayhude gidonna asay medhon higgey kiitteyssa oothoosona. Enttaw xaafettida higgey baynna ixxikokka entti bantta wozanan higgiya eroosona. ");
INSERT INTO gofRNT_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Entta hanotay, higge kiitay entta wozanan xaafettidayssa bessees. Qassi entta kahay entta bolla markkattees. Entta qofay issi issi toho enttana bala gees; issi issi toho enttana likke gees. ");
INSERT INTO gofRNT_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Ta tamaarssida Wonggelaa mela Xoossay Yesuus Kiristtoosa baggara asa wozanan geemmida qofaa pirddiya wode hessi erettana. ");
INSERT INTO gofRNT_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Shin ne nena Ayhude gaasa; higgen zemppaasa; Xoossan ceeqaasa. ");
INSERT INTO gofRNT_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Ne oothana mela Xoossay koyabay aybeekko eraasa. Higgiya tamaarida gisho tuma gidiyabaa dooranaw eraasa. ");
INSERT INTO gofRNT_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Neeni qooqeta kaaletheyssa, qassi dhuman de7eyssatas poo7o gideyssa shaakka eraasa. ");
INSERT INTO gofRNT_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","Neeni higgiyafe demmida eratethaaninne tumatethan eeyata eriseyssanne yoogata tamaarsseyssa gideyssa eraasa. ");
INSERT INTO gofRNT_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Yaatin, ne harata tamaarsseyssi ne nena ays tamaarssikii? Neeni, “Kaysotoppa” gashe, neeni ne huu7en kaysotayye? ");
INSERT INTO gofRNT_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Neeni, “Laammofa” gashe, neeni ne huu7en laammayye? Neeni eeqa ixxashe, eeqay de7iya keethaa bonqayye? ");
INSERT INTO gofRNT_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Neeni Xoossaa higgiyan ceeqettasa, shin higgiyas kiitettonna ixxada Xoossaa yeellayay? ");
INSERT INTO gofRNT_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Geeshsha Maxaafan, “Hintte gaason Xoossaa sunthay Ayhude gidonna asatan cayettees” geetettidi xaafettis. ");
INSERT INTO gofRNT_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Ne higges kiitettiko, ne qaxxaretethaas maadey de7ees, shin neeni higgiyas kiitettonna ixxiko ne qaxxaretethay qaxxarettiboonna mela gidees. ");
INSERT INTO gofRNT_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Ayhude gidonna asi qaxxarettonna de7ishe, higgiyas kiitettiko, Xoossay iya qaxxarettida mela taybenne? ");
INSERT INTO gofRNT_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Hintte, Ayhude asati, hinttew xaafettida higgeynne qaxxaroy de7ishin, hintte higges kiitettonna ixxiko, Ayhude gidonna asay qaxxarettonna ixxikokka higges kiitettidi, hintte bolla pirddana. ");
INSERT INTO gofRNT_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Hiza, sunthan Ayhude gidida ubbay tuma Ayhude gidenna. Qassi kare asatethaa qaxxaroy tuma qaxxaro gidenna. ");
INSERT INTO gofRNT_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Shin tuma Ayhudetethi gaatha baggan Ayhude gideyssa. Tuma qaxxaretethi Xoossaa Ayyaanan oosettiya wozana qaxxaretethafe attin xaafettida higgiyan oosettiya asatetha qaxxaro gidenna. He uray galataa Xoossafe ekkeesippe attin asappe gidenna. ");
INSERT INTO gofRNT_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Yaatin, Ayhude gidon ay dummatethi de7ii? Woykko qaxxaretethan ay maadey de7ii? ");
INSERT INTO gofRNT_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Tumakka Ayhude gidoy daro ogera maaddees. Ubbaafe sinthe Xoossay ba qaala hadara Ayhudetas immis. ");
INSERT INTO gofRNT_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Yaatin, enttafe issoti issoti qaala ammanonna ixxiko, entta ixoy Xoossaa ammanetethaa diggiyye? ");
INSERT INTO gofRNT_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Diggenna! Asa ubbay worddanchcho gidikkoka Xoossay tuma gido. Geeshsha Maxaafan, “Ne qaalan ne xillasa; nena mooteyssa pirddan lathaasa” geetettidi xaafettis. ");
INSERT INTO gofRNT_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Yaatin, nu nagaray Xoossay xillo gideyssa bessiyabaa gidikko, nu woyganee? Xoossay nu nagaraa gisho nu bolla pirddiko, likke gidenneyye? Hayssa taani asa qofatho gays. ");
INSERT INTO gofRNT_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Hessi ubbarakka hanenna. Hessada hanikko, Xoossay ha alamiya bolla waati pirddanee? ");
INSERT INTO gofRNT_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Shin ta worddotethay Xoossaa tumaa qonccisidi, iya bonchchuwa darssi bessiyabaa gidikko, yaatin, ays ta bolla nagaranchchoda pirddeetii? ");
INSERT INTO gofRNT_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Issi issi asay, “Lo77oy yaana mela iita oothoos” yaagidi tamaarssiyaada oothidi tana mootosona. Hessa mela asaa bolla yaa Xoossaa pirdday likke. ");
INSERT INTO gofRNT_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Yaatin, nuuni woyganee? Nu Ayhudeti, Ayhude gidonnayssatappe aadhdhonaayye? Gidenna! Ayhude gidin, Ayhude gidonna ixxin ubbay nagaranchcho gideyssa taani kasetada hinttew odas. ");
INSERT INTO gofRNT_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Geeshsha Maxaafan, “Xillo asi issoykka baawa. ");
INSERT INTO gofRNT_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Akeekiya asi baawa, Xoossaa koyaa oonikka baawa. ");
INSERT INTO gofRNT_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Asa ubbay Xoossaas zokko zaaridosona; ubbay issife pathonnabaa gididosona. Lo77o oothiya oonikka baawa; issi asikka baawa. ");
INSERT INTO gofRNT_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Entta doonappe keyaa qaalay, dooyettida duufoppe keyaa xinqqo mela; bantta inxarssan cimmoosona. Entta doonappe ase wodhiya, shoosha marzey keyees. ");
INSERT INTO gofRNT_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Entta doonan camo odaynne baadethi kumis. ");
INSERT INTO gofRNT_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Entti suuthi gussanaw ellesoosona. ");
INSERT INTO gofRNT_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Entta ogiyan dhayoynne qohoy de7ees. ");
INSERT INTO gofRNT_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Entti sarotetha ogiya erokkona. ");
INSERT INTO gofRNT_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Bantta de7uwan Xoossaas yayyokona” geetettidi xaafettis. ");
INSERT INTO gofRNT_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Ase ubbaa doona oythanawunne kumetha alamiya Xoossaa pirddaafe garssan shiishanaw, higgey imettiday higgefe garssan aqeyssatas gideyssa nu eroos. ");
INSERT INTO gofRNT_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Hessa gisho, oonikka higges kiitettidi Xoossaa sinthan xillanaw dandda7enna. Higgey asi ubbay nagaranchcho gideyssa bessees. ");
INSERT INTO gofRNT_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Shin ha77i Xoossay asi higgey baynnashin xilliya oge qonccisis. He ogiya Muse higgeynne nabeti markkattidosona. ");
INSERT INTO gofRNT_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Ha xillotethaa, Xoossay Yesuus Kiristtoosa baggara asa ubbaas shaakoy baynna immees. ");
INSERT INTO gofRNT_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Asa ubbay nagara oothidosona; Xoossay enttaw immida bonchchuwafe haakkidi attidosona. ");
INSERT INTO gofRNT_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Shin entti Xoossaa aadho keehatethan, woziya Kiristtoos Yesuusa baggara coo xillidosona. ");
INSERT INTO gofRNT_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Xoossay Yesuus Kiristtoosa yarshsho oothidi immiday, iya ammaniyaa ubbay iya suuthan nagara maarotethi demmana melassa. Xoossay hessa oothiday ba dandda7an kase nagaraa taybonna aggidi, ba xillotethaa bessanaassa. ");
INSERT INTO gofRNT_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Ha77i wodiyan Yesuusa ammaniyaa ubbaa xillisidi, Xoossay ba huu7en xillo gideyssa bessees. ");
INSERT INTO gofRNT_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Yaatin, nu ceeqettiyabay aybi de7ii? Aybikka baawa. Nuuni ceeqettey higges kiitettiya gishoyye? Akkay! Ammano gishossa. ");
INSERT INTO gofRNT_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Xoossay ase xillisey ammanonnappe attin higges kiitetethan gidonnayssa nu akeekos. ");
INSERT INTO gofRNT_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Woykko Xoossay Ayhudeta xalaala Xoosseyye? Ayhude gidonnayssatas Xoosse gidenneyye? Tuma, Ayhude gidonnayssataskka I Xoosse. ");
INSERT INTO gofRNT_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Xoossay isso; Ayhudetanne Ayhude gidonnayssata ammanon xillisey iya. ");
INSERT INTO gofRNT_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Yaatin, nuuni higgiya ammano gisho shaaros guusseyye? Gidenna! Higgiya minthosippe attin. ");
INSERT INTO gofRNT_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Yaatin, nu mayzay Abrahamey ay demmidee? ");
INSERT INTO gofRNT_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Abrahamey ooson xillidabaa gidiyakko, I ceeqettiyabay de7ees, gidoshin, Xoossaa sinthan ceeqettanaw dandda7enna. ");
INSERT INTO gofRNT_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Geeshsha Maxaafay, “Abrahamey Xoossaa ammanis; Xoossay hessa iyaw xillotethi oothidi ekkis” yaagees. ");
INSERT INTO gofRNT_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Oothiya uray ekkiya daamozey, iya ooso wolqqaas cigettiya gateppe attin iyaw imota gidenna. ");
INSERT INTO gofRNT_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Shin ooso oothonna oonikka nagaranchchuwa xillisiya Xoossaa ammanikko, iya ammanoy iyaw xillotethi gididi taybettees. ");
INSERT INTO gofRNT_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Geeshsha Maxaafan Dawitey, oosoy baynna Xoossay xillisiya asati ay mela anjjettidaakko hayssada yaagidi qonccisees: ");
INSERT INTO gofRNT_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“Entta balay atto geetettidayssatinne entta nagaray kamettidayssati anjjettidayssata. ");
INSERT INTO gofRNT_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Goday iya nagaraa taybonna asi anjjettidayssa” yaagees. ");
INSERT INTO gofRNT_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Yaatin, Dawitey odida anjjoy qaxxarettida asaa xalaalaseyye? Woykko qaxxarettiboona asaase? Nuuni, “Geeshsha Maxaafay, ‘Abrahamey Xoossaa ammanis; Xoossay hessa iyaw xillotethi oothidi ekkis’ yaagees” gida. ");
INSERT INTO gofRNT_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Yaatin, hessi awude hanidee? Abrahamey qaxxaretineyye? Woykko qaxxarettonna de7ishinee? Qaxxarettanaappe sinthe hanisippe attin guye gidenna. ");
INSERT INTO gofRNT_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Abrahamey qaxarettanaappe sinthe iya ammanoy iyaw xillotethi gididi taybettidayssa erisanaw, iya qaxxaroy malaata gidis. Hessa gisho, Abrahamey qaxxarettonna ammaneyssatasinne ammanon xilleyssata ubbaas aawa gidis. ");
INSERT INTO gofRNT_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","I qaxxarettidayssataskka aawa. Abrahamey enttaw aawa gididay entti qaxxarettida gisho xalaalas gidonnashin I qaxxaretanaappe sinthe ammanida ammanuwa entti kaallida gishossa. ");
INSERT INTO gofRNT_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Abrahamesinne iya sheeshas, “Alamiya ta hinttew immana” yaagida ufayssay, Abrahamey ammanon xillida gishossafe attin higge naagidi polida gisho gidenna. ");
INSERT INTO gofRNT_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Higges kiitettidayssati Xoossay immana gida ufayssaa laataeyssata gidikko, asaa ammanoy maaddenna; Xoossaa ufayssayka hada gidis. ");
INSERT INTO gofRNT_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Higge menthoy Xoossaa hanqo ehees, shin higgey baynnason higge menthoy baawa. ");
INSERT INTO gofRNT_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Hessa gisho, Xoossay immida ufayssay ammanon ekettees. Ha ufayssay Abrahame sheeshaa ubbaas Xoossaa aadho keehatethaa baggara imettidayssa qonccisees. Hessika higge naageyssata xalaalas gidonnashin Abrahameda ammanida ubbaassa. Abrahamey nu ubbaas aawa. ");
INSERT INTO gofRNT_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Geeshsha Maxaafan, “Ta nena daro kawotethatas aawa oothas” geetettidi Abrahame gisho xaafettis. Ha ufayssay Abrahames imettiday hayqqidayssatas de7o immeysinne oorathabaa oothiya Xoossay iya gideyssa I ammanida gishossa. ");
INSERT INTO gofRNT_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Xoossay Abrahames daro zerethi immanayssa caaqqis. Ufayssi oothanaw aykkoka dandda7ettona wode Abrahamey Xoossan ammanida gishonne ufayssi oothida gisho daro kawotethatas aawa gidis. ");
INSERT INTO gofRNT_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Abrahames xeetu laythi kumana hanikkoka, ba daaburida asatethaanne Saara na7a yelanaw dandda7onnayssa erishe ba ammanuwan daaburibeenna. ");
INSERT INTO gofRNT_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Gidoshin, I ba ammanuwan minnidi Xoossaas bonchcho immisppe attin Xoossay immida ufayssaa ammanonna ixxidi, sidhibeenna. ");
INSERT INTO gofRNT_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Abrahamey, Xoossay caaqqida caaquwa polanayssa ba kumetha wozanan ammanis. ");
INSERT INTO gofRNT_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Hessa gisho, Xoossay iya ammanuwa xillotethan taybis. ");
INSERT INTO gofRNT_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Shin, “Iyaw xillotethan taybis” giya qaalay Abrahame xalaalas xaafettibeenna. ");
INSERT INTO gofRNT_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","He qaalay nu Godaa Yesuusa hayqoppe denthida Xoossaa ammaniyaa nuuskka nu ammanoy xillotethan taybettana mela xaafettis. ");
INSERT INTO gofRNT_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Xoossay iya nu nagara gisho hayqos aathidi immis; I nuna xillisanaw hayqoppe denddis. ");
INSERT INTO gofRNT_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Hiza, nu ammanon xillida gisho nu Godaa Yesuus Kiristtoosa baggara Xoossaara nuus sarotethi de7ees. ");
INSERT INTO gofRNT_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Nuuni iya baggara ha77i nu eqqida aadho keehatethaa giddo ammanon gelida. Hessa gisho, nu Xoossaa bonchchuwa shaaketanaw de7iya ufayssan ceeqettoos. ");
INSERT INTO gofRNT_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Hessa xalaala gidonnashin metoy dandda7a eheyssa nu eriya gisho nu metuwankka ceeqettoos. ");
INSERT INTO gofRNT_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","Qassi dandda7ay genccaa, genccay ufayssi immeyssa nu eroos. ");
INSERT INTO gofRNT_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Nuus immida Geeshsha Ayyaana baggara Xoossay ba siiquwa nu wozanan gussida gisho he ufayssay nuna yeellayenna. ");
INSERT INTO gofRNT_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Nuuni buroo daaburanchchota gididi de7ishin, Xoossaa wodey gakkin, Kiristtoosi nagaranchchota gisho hayqqis. ");
INSERT INTO gofRNT_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Xillo asa gisho hayqqana asi demmanayssi daro meto, shin keeha asa gisho hayqqana asi ooni eri benttonna aggenna. ");
INSERT INTO gofRNT_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Shin nuuni buroo nagaranchcho gididi de7ishin, Kiristtoosi nu gisho hayqqis. Hessi Xoossay nuna ay mela siiqiyakko iya siiquwa bessees. ");
INSERT INTO gofRNT_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Hiza, nuuni Kiristtoosa suuthan xillidabaa gidikko, ubbaafe aathidi iya baggara Xoossaa hanquwafe attana. ");
INSERT INTO gofRNT_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Nuuni Xoossaara kase morkke, shin iya Na7aa hayquwan iyara sigettida. Hessafe aathidi, ha77i nuuni Xoossaara sigettidaappe guye iya na7aa de7uwa gaason nuuni attana. ");
INSERT INTO gofRNT_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Hessa xalaala gidonnashin ha77i nuna Xoossaara sigethida nu Godaa Yesuus Kiristtoosa baggara nu Xoossan ceeqettoos. ");
INSERT INTO gofRNT_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Addaame baggara nagari ha alamiya gelis. He nagaraa baggara hayqoy yis. Asi ubbay nagara oothida gisho hayqoy asa zare ubbaa gakkis. ");
INSERT INTO gofRNT_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Higgey imettanaappe sinthe alamen nagari de7ees, shin higgey baynna wode nagari nagara gididi taybettenna. ");
INSERT INTO gofRNT_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Shin Addaameppe Muse gakkanaw hayqoy asa ubbaa haaris. Hari attoshin, Addaameda higges kiitettonna ixxidi, nagara oothiboonayssata bollaka hayqoy kawotis. Addaamey yaana Yesuusas leemiso. ");
INSERT INTO gofRNT_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Shin Xoossaa aadho keehatethay Addaame nagaraa mela gidenna. Issi asa nagara baggara daro asay hayqqis. Shin Yesuus Kiristtoosa baggara Xoossaa aadho keehatethay asa ubbaas daridi imettis. ");
INSERT INTO gofRNT_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Addaame nagaraa giddoninne Xoossaa imotaa giddon daro dummatethi de7ees. Issi asa nagara gaason Xoossay iya bolla pirddis. Shin asay daro nagara oothinkka Xoossaa aadho keehatethay xillotethaa ehis. ");
INSERT INTO gofRNT_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Issi asa nagara gaason hayqoy asa ubbaa bolla kawotis. Shin Yesuus Kiristtoosa baggara Xoossaa aadho keehatethaanne xillotetha imota ekkiya ubbay, xoono de7on de7oosona. ");
INSERT INTO gofRNT_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Hiza, issi asi nagara oothida gaason asa ubbaa bolla pirddi yidayssada issi asi xillo oothida gaason, Xoossay ase ubbaa xillisidi enttaw de7o immees. ");
INSERT INTO gofRNT_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Issi asi kiitettonna ixxida gaason, daro asay nagaranchcho gididayssada issi asa kiitetethan daro asay xillana. ");
INSERT INTO gofRNT_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Asay nagara wolqqaa erana mela higgey yis, shin nagara wolqqay darida wode Xoossaa aadho keehatethay aadhdhidi daris. ");
INSERT INTO gofRNT_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Nagari hayqo wolqqan kawotidayssa mela Xoossaa aadho keehatethay xillotethaa wolqqan kawotidi, nu Godaa Yesuus Kiristtoosa baggara nuna merinaa de7uwakko kaalethees. ");
INSERT INTO gofRNT_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Yaatin, nuuni woyganee? Xoossaa aadho keehatethay darana mela nagaran minnidi de7ino? ");
INSERT INTO gofRNT_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Akkay, nuuni nagaras hayqqidabaa gidikko, yaatin, nuuni hizappe waanidi nagaran daane? ");
INSERT INTO gofRNT_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Nu ubbay Kiristtoos Yesuusara issifanaw xammaqettida wode iya hayquwan iyara issifanaw xammaqettidayssa erekketiyye? ");
INSERT INTO gofRNT_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Nu xammaqettida wode Kiristtoosara hayqqidanne moogettida. Kiristtoosi Xoossaa Aawa bonchcho wolqqan hayqoppe denddidayssa mela nukka ooratha de7on daana. ");
INSERT INTO gofRNT_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Nu iya hayquwan iyara issino gidikko, hessadakka, iya dendduwan iyara issino gidana. ");
INSERT INTO gofRNT_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Nu hizappe nagaras aylle gidonna melanne nu nagaranchcho asatethaa wolqqay dhayana mela nu cima asatethay Kiristtoosara kaqettidayssa eroos. ");
INSERT INTO gofRNT_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Issi asi Kiristtoosan hayqqidabaa gidikko, I nagara wolqqafe la77a keyis. ");
INSERT INTO gofRNT_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Nuuni Kiristtoosara hayqqiko, iyara de7on daanayssa ammanoos. ");
INSERT INTO gofRNT_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Kiristtoosi hayqoppe denddida gisho zaari I hayqqonnayssanne hayqoy sinthafe iya haaronnayssa nu eroos. ");
INSERT INTO gofRNT_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","I hayqqida wode nagaras issi toho wurssethi gakkanaw hayqqis, shin ha77i de7on Xoossaas de7ees. ");
INSERT INTO gofRNT_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Hessadakka, hintte nagaras hayqqidi, Godaa Kiristtoos Yesuusa baggara Xoossaas de7on de7eyssa qoppite. ");
INSERT INTO gofRNT_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Hessa gisho, hinttee, hintte asatethaa amuwaas kiitettonna mela hayqqiya hintte asatethaa nagari haaroppo. ");
INSERT INTO gofRNT_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Qassi hintte asatethaa nagara oothanaw geellatetha miishe oothidi immofite. Shin hintte hayqoppe denddidi, de7on de7iya asada hintte asatethaa Xoossaas immite. Qassi hintte kumetha asatethaa xillo ooso oothanaw Xoossaas aathi immite. ");
INSERT INTO gofRNT_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Hintte Xoossaa aadho keehatethaa garssan de7eetappe attin higgefe garssan de7onna gisho nagari hinttena haaranaw bessenna. ");
INSERT INTO gofRNT_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Yaatin, nu woyganee? Higgefe garssan gidonnashin Xoossaa aadho keehatethaa garssan de7iya gisho nagara oothaneeyye? Akkay! ");
INSERT INTO gofRNT_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Hintte issi asas kiitettanaw hinttena aylle oothidi immiya wode he hintte kiitetteyssas aylle gideyssa ereeta. Hessadakka, hintte nagaras kiitettiko, hinttew hayqo ehiya nagaraas aylle gideeta. Woykko hintte Xoossas kiitettiko xillotethi ehiya Xoossaas aylle gideeta. ");
INSERT INTO gofRNT_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Kase hintte nagaras aylle, shin ha77i hintte ekkida tuma timirttiyas kumetha wozanappe kiitettida gisho Xoossaas galati gido. ");
INSERT INTO gofRNT_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Hintte nagara aylletethaa qashoppe bilettidi xillotetha aylle gidideta. ");
INSERT INTO gofRNT_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Hinttee hintte qofan daaburanchcho gidiya gisho taani ooddeskka geliya ogen odays. Kase hinttee, hintte asatethaa tunanne iitabaa oothanaw aylle oothidi immidayssa mela ha77i hintte asatethaa geeshshi gidana mela xillotetha aylle oothidi immite. ");
INSERT INTO gofRNT_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Hintte nagaras ayllettidi de7iya wode xillotethas haaretteketa. ");
INSERT INTO gofRNT_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Hinttena ha77i yeellayaa beni hintte iita oosuwappe ay maade demmidetii? He oosota wurssethay hayqo. ");
INSERT INTO gofRNT_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Shin hintte nagara aylletethaa qashoppe bilettidi, Xoossaas aylle gidideta. Hessi hinttena geeshshi oothidi merinaa de7uwakko kaalethees. ");
INSERT INTO gofRNT_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Nagara gatey hayqo. Shin Xoossay, nu Godaa Kiristtoos Yesuusa baggara immiya imotay merinaa de7o. ");
INSERT INTO gofRNT_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Ta ishato, taani odey higge eriya asatassa. Higgey issi asi paxa de7iya wode ubban iya haarees. ");
INSERT INTO gofRNT_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Leemisos, azina gelida maccasiya I azinay paxa de7iya wode higgen iyara qashettasu. Shin I azinay hayqqiko iyara iya caaqqida caaqoy iyo haarenna. ");
INSERT INTO gofRNT_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Hessa gisho, iya ba azinay paxa de7ishin, hara adde gelikko, iya laammidaaro geetettawusu. Shin I azinay hayqqiko, caaqoy iyo haaronna gisho iya hara azina gelikko, iya laammidaaro geetettuku. ");
INSERT INTO gofRNT_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Hessa gisho, ta ishato, hintte Kiristtoosa asatethaa baggara higge wolqqaas hayqqidi, Xoossaas ayfe ayfanaw hayqoppe denddida Kiristtoosas gidideta. ");
INSERT INTO gofRNT_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Nu asho amoy nuna haarin, nu de7iya wode higgey gujji nagara oothana mela nuna denthethees. Nu asatethaa giddon iita amotethi de7iya gisho nuuni hayqo ayfe ayfana mela oothis. ");
INSERT INTO gofRNT_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Shin ha77i nuuni nuna qachchida higgiyas hayqqida gisho nuuni higge qashoppe bilettida. Hessa gisho, Geeshsha Ayyaana ogen Xoossaas kiitettosippe attin xaafettida cima higgiyas kiitettoko. ");
INSERT INTO gofRNT_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Yaatin, nuuni woyganee? Higgey ba huu7en nagaree? Gidenna! Shin higgey nagari aybeekko tana erisis. Higgey, “Amottofa” goonnako, amotethi aybeekko taani erikke. ");
INSERT INTO gofRNT_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Shin ta ubbabaa amottana mela nagari higge baggara tanan oge demmis. Higgey bayneekko nagari hayqqidayssa. ");
INSERT INTO gofRNT_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Kase higgey baynna wode ta paxa, shin higgey imettida wode nagari paxin ta qassi hayqqas. ");
INSERT INTO gofRNT_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","Taani de7on daana mela Xoossay immida higgey taw hayqo ehis. ");
INSERT INTO gofRNT_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Nagari higge baggara tana cimmiya oge demmidi, wodhdhis. ");
INSERT INTO gofRNT_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Hessa gisho, higgey geeshshi; iyan xaafettida kiitaykka geeshshi, xillonne lo77o. ");
INSERT INTO gofRNT_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Yaatin, lo77o gididabay ta bolla hayqo ehideyye? Gidenna! Shin nagari nagara gideyssi qonccana mela lo77oban maaddettidi taw hayqo ehis. Hessa gisho, nagara nagaratethay higge baggara aadhdhidi erettis. ");
INSERT INTO gofRNT_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Nuuni higgey ayyaanabaa gideyssa eroos. Shin taani nagaras bayzettida asho asi. ");
INSERT INTO gofRNT_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Taani oothiyabaa akeekikke; taani dosiyabaa oothanayssa aggada ta ixxiyabaa oothays. ");
INSERT INTO gofRNT_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Taani ixxiyabaa oothiyabaa gidikko, higgey lo77o gideyssa ma77ays. ");
INSERT INTO gofRNT_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Hessa gidikko, he oosuwa tanan de7iya nagaray oothaysippe attin ta oothike. ");
INSERT INTO gofRNT_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Tanan, hessika ta ashuwan lo77obay baynnayssa erays. Lo77obaa oothiya amotethi tanan de7ees, shin lo77obaa oothanaw dandda7ikke. ");
INSERT INTO gofRNT_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Taani ixxiya iitabaa oothaysippe attin ta dosiya lo77obaa oothike. ");
INSERT INTO gofRNT_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Taani ixxiyabaa oothiyabaa gidikko, hessa tanan de7iya nagaray ootheesippe attin oothey tana gidikke. ");
INSERT INTO gofRNT_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Hiza, ta lo77obaa oothanaw dosishin, iitabaa oosoy woga gideyssa demmas. ");
INSERT INTO gofRNT_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Taani ta wozanan Xoossaa higgiyan ufayttays. ");
INSERT INTO gofRNT_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","Shin ta asatethaa giddon de7iya ta qofaa higgiyara olettiya dumma higge be7ays. He higgey ta asatethaa giddon oothiya nagara higgiyas tana aylle oothidi immis. ");
INSERT INTO gofRNT_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Taani waanida yibbata asee? Hayqos efiya ha asatethaafe tana ashshanay oonee? ");
INSERT INTO gofRNT_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Nu Godaa Yesuus Kiristtoosa baggara tana ashshiya Xoossaas galati gido. Hiza, taani ta qofan Xoossaa higgiyas haarettays; shin ta asatethan tana nagara oosisiya higgiyas haarettays. ");
INSERT INTO gofRNT_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Hessa gisho, Kiristtoos Yesuusan de7eyssati ha77i pirddettokona. ");
INSERT INTO gofRNT_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Kiristtoos Yesuusa baggara nuus de7o immiya Geeshsha Ayyaana higgey, tana nagaranne hayqo higge aylletethaafe kessis. ");
INSERT INTO gofRNT_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Nu nagara asatethaa gaason, higgey daaburanchcho gidiya gisho nuna ashshanaw dandda7ibeenna. Xoossay ba na7aa nagaranchcho asa leemison nagaras yarshsho gidana mela kiittidi hessa oothis. Yaatidi, Xoossay Kiristtoosa ashuwa baggara nagara, nagaranchcho asa giddon pirddis. ");
INSERT INTO gofRNT_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Xoossay hessa oothiday, nu asho amoy koyeyssada gidonnashin Geeshsha Ayyaanay koyeyssada de7iya nu bolla higgiya xillo kiitay polettana melassa. ");
INSERT INTO gofRNT_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Bantta asho amuwaa kaallidi de7eyssati banttana ufayssiyabaa qoppoosona. Shin Geeshsha Ayyaana shenen de7eyssati Geeshsha Ayyaana ufayssiyabaa qoppoosona. ");
INSERT INTO gofRNT_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Nu qofay asho amos haarettiko hayqo ehees, shin ayyaana amos haarettiko de7onne sarotethi ehees. ");
INSERT INTO gofRNT_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Asho amos haarettiya asi Xoossaa higgiyas kiitettanaw koyonna gishonne kiitettanaw dandda7onna gisho Xoossaara morkke. ");
INSERT INTO gofRNT_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Bantta asho amuwaas haaretteyssati Xoossaa ufayssanaw dandda7okkona. ");
INSERT INTO gofRNT_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Shin Xoossaa Ayyaanay hinttenan de7ikkonne hinttena haarikko, hintte Ayyaana shenen de7eetappe attin hintte asho amuwaas haaretteketa. Kiristtoosa Ayyaanay baynna oonikka Kiristtoosabaa gidenna. ");
INSERT INTO gofRNT_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Shin Kiristtoosi hinttenan de7ikko, hintte asatethay nagara gaason hayqqidayssa. Shin hintte ayyaanay xillotethaa gaason de7on de7ees. ");
INSERT INTO gofRNT_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Shin Yesuusa hayqoppe denthida Xoossaa Ayyaanay hinttenan de7ikko, Kiristtoosa hayqoppe denthida Xoossay, hinttenan de7iya ba Geeshsha Ayyaanan hayqqiya hintte asatethaas de7o immana. ");
INSERT INTO gofRNT_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Hiza, ta ishato, nuuni nu asho amuwaa kaallidi daanaw bessenna. ");
INSERT INTO gofRNT_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Hinttee, hintte asho amuwaas de7ikko hayqqana, shin Geeshsha Ayyaana wolqqan nagara oosuwa wodhikko hintte de7on daana. ");
INSERT INTO gofRNT_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Xoossaa Ayyaanay kaalethiya ubbay Xoossaa nayta. ");
INSERT INTO gofRNT_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Nuuni, “Abbaa, ta Aawaw” yaagidi xeegiya, Xoossaa nayta oothiya Geeshsha Ayyaana ekkidaappe attin zaaridi yashshan daanaw aylle oothiya ayyaana ekkibookko. ");
INSERT INTO gofRNT_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Xoossaa Ayyaanay nu ayyaanara gididi nuuni Xoossaa nayta gideyssa markkattees. ");
INSERT INTO gofRNT_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Nuuni iya nayta gidikko Xoossaa anjjuwaa laattana; Kiristtoosara wolla he anjjuwaa laattana. Qassi nuuni Kiristtoosara metuwa ekiko iyara wolla iya bonchchuwan shaakettana. ");
INSERT INTO gofRNT_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Nuuni ha77i waayettiya waaya, sinthafe nuus qonccana bonchchuwara gathi be7ikko, ginisanaw dandda7ettenna gada qoppays. ");
INSERT INTO gofRNT_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Medhetetha ubbay Xoossaa nayta qonccethaa daro laamotidi naagoosona. ");
INSERT INTO gofRNT_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Medhetetha ubbay hada gidis; hessika, medhetethaa dooron gidonnashin ufayssan naagana mela oothida Xoossaa shenen hanis. ");
INSERT INTO gofRNT_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","Medhetethay ba huu7en dhayo aylletethaafe wozettidi, Xoossaa naytara wolla bonchcho la77aa shaakettana. ");
INSERT INTO gofRNT_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Medhetethay issife hanno gakkanaw miixoy oykkida maccasada ooleninne un77an de7eyssa nu eroos. ");
INSERT INTO gofRNT_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Qassi hessa medhetethaa xalaala gidonnashin Geeshsha Ayyaanaa bayra imotada ekkida nuuni, nu huu7en nu asatethaas wozo gidida Xoossaa nayta gidana ufayssaa naagishe nu asatethan oolos. ");
INSERT INTO gofRNT_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Ha ufayssan nuuni attida. Shin nuuni ufayssi oothiyabay benttiya gidikko hessa ooni ufayssi oothi? ");
INSERT INTO gofRNT_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Shin nu be7onnabaa demmana gidi ufayssan naagikko hessa dandda7an naagoos. ");
INSERT INTO gofRNT_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Hessada Geeshsha Ayyaanay nu daaburan maaddees. Nuuni Xoossaa waati woossanaw bessiyako erokko, shin Geeshsha Ayyaanay ba huu7en, asi odanaw dandda7ettona qaalan nuus gaannatees. ");
INSERT INTO gofRNT_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Qassi asa wozana eriya Xoossay Geeshsha Ayyaana qofay aybeekko erees. Geeshsha Ayyaanay Xoossaa sheniyada geeshshatas gaannatees. ");
INSERT INTO gofRNT_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Xoossaa siiqeyssatasinne iya sheniyada xeegettidayssatas Xoossay ubbaa lo77os ootheyssa eroos. ");
INSERT INTO gofRNT_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Xoossay koyrottidi eridayssati ba Na7aa daanana melanne na7aykka ammaneyssata giddon bayra gidana mela entta dummayidi wothis. ");
INSERT INTO gofRNT_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Xoossay koyrottidi dummayidayssata xeegis; he xeegidayssata xillisis; he xillisidayssata qassi bonchchis. ");
INSERT INTO gofRNT_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Yaatin, nu ha ubbaas woyganee? Xoossay nu bagga gidikko nuura oone eqettanay? ");
INSERT INTO gofRNT_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","I hari attoshin, ba na7aas qadhettonashin, nu gisho aathi immis. Yaatin, ba na7aa nuus aathi immidayssi waanidi ubbabaa coo immenne? ");
INSERT INTO gofRNT_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Xoossay enttana xillisida gisho I dooridayssata oone mootanay? ");
INSERT INTO gofRNT_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Yaatin, entta bolla pirddanaw dandda7ey oonee? Oonikka baawa. Hayqoppe denddidi Xoossaa ushachchan uttida, Kiristtoos Yesuusi, I nuus gaannatees. ");
INSERT INTO gofRNT_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Hiza, nuna Kiristtoosa siiquwappe shaakkanay oonee? Waayeyye woykko metoyye woykko goodeyye woykko kosheyye woykko kallotetheyye woykko yashsheyye woykko oleyye? ");
INSERT INTO gofRNT_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Geeshsha Maxaafan, “Nuuni ne gisho gallasa kumethaa hayqqoos; shukkas efiya dorssada taybettida” geetettidi xaafettidayssa mela gidis. ");
INSERT INTO gofRNT_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Shin nuuni, nuna siiqida Kiristtoosan ha ubbaa polo xoonos. ");
INSERT INTO gofRNT_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Hessa gisho, hayqo gidin de7o gidin kiitanchchota gidin haareyssata gidin ha77i de7eyssa gidin sinthafe yaanayssa gidin wolqqaamata gidin, ");
INSERT INTO gofRNT_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","salo wolqqaa gidin sa7a wolqqaa gidin ay medhetethi gidin nu Godaa, Kiristtoos Yesuusan de7iya Xoossaa siiquwappe nuna shaakkanaw dandda7onnayssa taani eras. ");
INSERT INTO gofRNT_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Taani Kiristtoosan tuma odays, worddotikke. Geeshsha Ayyaanay kaalethiya ta kahay taani worddotonnayssa taw markkattees. ");
INSERT INTO gofRNT_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","Ta wozanan Isra7eeletas daro qadhettaysinne qamma gallas qoppays. ");
INSERT INTO gofRNT_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Taani, ta ishata gisho Kiristtoosappe shaakettada Xoossaa qanggethafe garssan de7idaakko dosaysishin. ");
INSERT INTO gofRNT_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Entti Isra7eeleta, Xoossay entta ba nayta oothis, ba bonchchuwa enttaw qonccisis. Enttara caaqqis; higgiya enttaw immis. Entti Xoossaa goynnana tuma ogiya bessis; Xoossay ufayssa qaala enttaw immis. ");
INSERT INTO gofRNT_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Entti yeletethan mayzata zare; qassi Kiristtoosi ashon entta zare gididi yis. Ubbaafe bolla gidida Xoossay merinaw galatetto. Amin77i! ");
INSERT INTO gofRNT_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Gidoshin, Xoossay gelida qaalay polettonna attis guussu gidenna. Isra7eele asa ubbay Xoossaa asi gidokkona. ");
INSERT INTO gofRNT_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Qassi Abrahame zare ubbay Abrahame nayta gidokkona. Xoossay Abrahames, “Ne zerethay Yisaaqa baggara xeegettana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Hessa guussay ashon yelettida nayti ubbay Xoossaa nayta gidokkona. Shin tuma Isra7eele nayti Xoossay Abrahames gelida qaalada yelettida nayta. ");
INSERT INTO gofRNT_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Xoossay immana gidi gelida qaalay, “Taani wontto laythi hannoode yaana; Saarakka adde na7a yelana” yaageyssa. ");
INSERT INTO gofRNT_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Hessa xalaala gidonnashin Irbbiqinne Yisaaqi yelida mentte adde naytabaa akeekite. ");
INSERT INTO gofRNT_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","Entti yelettanaappe woykko iita woykko lo77o oothanaappe sinthe Xoossaa dooroy ooson gidonnashin xeessan gideyssa qonccisanaw, ");
INSERT INTO gofRNT_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","“Bayray kaaluwas kiitettana” yaagidi Goday Irbbiqas odis. ");
INSERT INTO gofRNT_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Hessika Geeshsha Maxaafan, “Yayqooba dosas, Eesawe ixxas” geetettidi xaafettis. ");
INSERT INTO gofRNT_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Yaatin, nuuni woyganee? Xoossay ase asappe shaakkiyye? Gidenna. ");
INSERT INTO gofRNT_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Goday Musekko, “Ta maaranaw koyidayssata maarana; ta qadhettanaw koyidayssatas qadhettana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Hiza, Xoossaa dooroy asa shenen woykko ooson gidonnashin iya maarotethaana. ");
INSERT INTO gofRNT_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Geeshsha Maxaafan, Gibxxe kawuwakko, “Taani, ta wolqqaa nenan bessanawunne ta sunthay alame ubban erettana mela hessas nena kawothas” geetettidi xaafettis. ");
INSERT INTO gofRNT_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Hiza, Xoossay maaranaw koyeyssa maarees; wozanaa muumisanaw koyeyssa wozanaa muumisees. ");
INSERT INTO gofRNT_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Hinttefe issoy, “Yaatin, Xoossay ase iita ooso gisho ays borii? Xoossaa sheniya ixxas gaanay oonee?” yaagidi oychchanaw dandda7ees. ");
INSERT INTO gofRNT_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Shin ta ishaw, Xoossaara palamanaw neeni oonee? Urqqafe medhettida miishey bana medhdhidayssa, “Tana hayssada oothada ays medhdhadi?” gidi oychchanaw dandda7ii? ");
INSERT INTO gofRNT_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Woykko urqqa medhdheyssi issi urqqafe issuwa bonchcho miishe, hankkuwa qassi tooshe miishe oothidi medhdhanaw maati baawe? ");
INSERT INTO gofRNT_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Xoossay ba hanquwa bessanawunne ba wolqqaa erisanaw koyidi, pirddas giigida hanqo nayta daro genccan dandda7idaakko ne ay eray? ");
INSERT INTO gofRNT_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","Hessa I oothiday koyrottidi bonchchoos giigisida, ba doorida naytas ba bonchchuwa qonccisanassa. ");
INSERT INTO gofRNT_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","Ayhude gidin, woykko Ayhude gidonna asa ubbay Xoossan doorettida. ");
INSERT INTO gofRNT_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Nabiya Hose7e maxaafan, “Ta ase gidonnayssata, ‘Ta ase’ gada xeegana. Ta siiqaboonna deriya, ‘Siiqetidayssata’ gada xeegana. ");
INSERT INTO gofRNT_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","Entti, ‘Ta ase gidekketa’ geetetti xeegettida bessan, ‘De7o Xoossaa nayta’ geetettidi xeegettana” yaagees. ");
INSERT INTO gofRNT_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Nabiya Isayaasi Isra7eele asaabaa, “Isra7eele asay abbaa gaxan de7iya shafiyada darikkoka, enttafe guutha asa xalaali attana. ");
INSERT INTO gofRNT_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","Goday alamiya ubbaa bolla ellesidi polo pirddaa pirddana.” ");
INSERT INTO gofRNT_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Qassika Isayaasi, “Ubbaafe Wolqqaama Goday nuus guutha zerethi ashshonnabaa gidiyakko, nuuni Soodomenne Gamoora katamaada dhayanashin” yaagidi koyrottidi odis. ");
INSERT INTO gofRNT_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Yaatin, nu woyganee? Xillotethaa koyiboonna Ayhude gidonna asay ammanon xillotethi demmidosona. ");
INSERT INTO gofRNT_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","Shin xillotethako gathiya higgey de7iya Isra7eele asay xillotethi demmibookkona. ");
INSERT INTO gofRNT_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Ays demmibookkonaa? Entti xillotethaa ammanon gidonnashin ooson ekkanaw koyida gishossa. Yaaniya gisho, entti, “Dhubbiya shuchchan” dhubettidosona. ");
INSERT INTO gofRNT_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","Geeshsha Maxaafan, “Taani Xiyoonen dhubbi kunddisiya shuchchaa wothana. Iyan ammaniyaa oonikka yeellatenna” geetettidi xaafettis. ");
INSERT INTO gofRNT_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Ta ishato, ta kumetha wozanan ta amotteynne Xoossaa woossey Isra7eeley attana melassa. ");
INSERT INTO gofRNT_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Entti Xoossaas mishettosonashin, tuma eratethan mishettonnayssa ta markkattays. ");
INSERT INTO gofRNT_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Entti Xoossaa xillotethaa ogiya eronna ixxidi, bantta huu7e xillotethaa kaallidosonappe attin Xoossaa xillotethaa koyibookkona. ");
INSERT INTO gofRNT_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Asi ubbay ammanon xillana mela Kiristtoosi higgiya polis. ");
INSERT INTO gofRNT_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Asi higge naagidi ekkiya xillotethabaa Musey xaafishe, “Higge naagiya oonikka he higgiya naagida mela de7ees” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Shin ammanon ekkiya xillotethabaa geetettiday hayssa: “Ne wozanan, ‘Ooni salo keyanee?’ yaagoppa; hessi Kiristtoosa wodhisanaassa. ");
INSERT INTO gofRNT_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","Woykko, ‘Duge sa7a garssi wodhdhanay oonee?’ gooppa; hessi Kiristtoosa duufoppe kessanaassa. ");
INSERT INTO gofRNT_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Shin yaagidi xaafettis: ‘Xoossaa qaalay ne matana; ne doonaninne ne wozanan de7ees’ Nuuni hinttew odiya ammano qaalay hayssa. ");
INSERT INTO gofRNT_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","“Yesuusi Goda” gada ne doonan markkatikonne Xoossay iya hayqoppe denthidayssa ne wozanan ammanikko, ne attana. ");
INSERT INTO gofRNT_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Asi ba wozanan ammanidi xillees; ba doonan markkattidi attees. ");
INSERT INTO gofRNT_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Geeshsha Maxaafay, “Iyan ammaniyaa oonikka yeellatenna” yaagees. ");
INSERT INTO gofRNT_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Issi Xoossay ubbaa Goda gidiya gisho Ayhudeta giddoninne Ayhude gidonna asaa giddon dummatethi baawa. I bana xeegiya ubbaas daro keeha. ");
INSERT INTO gofRNT_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Geeshsha Maxaafay, “Godaa sunthaa xeegiya oonikka attana” yaagees. ");
INSERT INTO gofRNT_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Yaatin, entti ammanonna de7ishe waanidi iya xeeganaw dandda7onna? Entti iyabaa si7onna de7ishe waattidi iya ammananaw dandda7onaa? Qassi enttaw qaala odiya asi baynna de7ishin, waanidi si7anaw dandda7onaa? ");
INSERT INTO gofRNT_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Kiitettida asi baynna de7ishin, qaalay waanidi odettanaw dandda7ii? Geeshsha Maxaafan, “Ufayssa Wonggelaa odiya asaa tohoti waanidi lo77onaa!” yaagidi xaafettis. ");
INSERT INTO gofRNT_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Shin Isayaasi, “Godaw, nu markkatethaa ooni ammanidee?” yaagidayssada, ubbay Wonggelaa ammanibookkona. ");
INSERT INTO gofRNT_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Hessa gisho, ammanoy sissafe yees; sissi Kiristtoosa qaalappe yees. ");
INSERT INTO gofRNT_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Gidoshin, Isra7eele asay qaala si7ibookkona guusseyye? Akkay si7idosona. Geeshsha Maxaafan, “Entta qaalay biitta ubban si7ettis, entta oday sa7aa gaxa gakkis” yaagettis. ");
INSERT INTO gofRNT_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Shin Isra7eele asay eribookkona guusseyye? Musey kase, “Taani hinttena leqettida asan qiiroysana; qassi eeya asan hinttena yiloyana” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Qassi Isayaasi, “Tana koyiboonna asaas benttas; tana oychchiboonna asaas qonccas” yaagidi yayyonna odis. ");
INSERT INTO gofRNT_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Shin Isayaasi Isra7eeletabaa odishe, “Ubba wode kiitettonna asaasinne tana ixxiya asaas ta kushiya miccas” yaagees. ");
INSERT INTO gofRNT_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Ane ta oychchays: yaatin, Xoossay ba asaa aggideyye? Aggibeenna! Taani ta huu7en Isra7eele; Abrahame sheeshi; Biniyame zare. ");
INSERT INTO gofRNT_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Xoossay koyro doorida ba asata yeggenna. Geeshsha Maxaafan, Eliyaasi Isra7eelata Xoossaa sinthan waati mootidaakko, hintte erekketii? ");
INSERT INTO gofRNT_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","Eliyaasi, “Godaw, entti ne nabeta wodhidosona, ne yarshsho bessaaka laallidosona. Ta tarkka attas; entti tanakka wodhanaw koyoosona” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Xoossay iyaw woygi zaaridee? “Ba7aale eeqas goynniboonna laappun mukulu asaa taw ashshas” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Hessadakka, ha wodiyan Xoossay ba aadho keehatethan doorida guutha Isra7eeleti de7oosona. ");
INSERT INTO gofRNT_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","I entta dooriday ba aadho keehatethaanappe attin entta ooson gidenna. Dooroy ooson gidikko, iya aadho keehatethay tuma aadho keehatethi gidenna. ");
INSERT INTO gofRNT_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Yaatin, waanidee? Isra7eeleti bantta koyabaa demmibookkona, shin Xoossay doorida guuthati demmidosona. Attidayssati bantta wozanaa muumisidosona. ");
INSERT INTO gofRNT_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","Hessika, Geeshsha Maxaafan, “Entti bantta ayfiyaan be7onnaada bantta haythan si7onnaada, hanno gakkanaw enttaw Xoossay azalla ayyaana immis” geetettidi xaafettidayssada hanis. ");
INSERT INTO gofRNT_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Qassi Dawitey, “Entti miya gaytay entta xiheda oykko; entta gufanthiya aafo gido; entta iitatethay entta bolla gakko. ");
INSERT INTO gofRNT_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Entti xeellonnaada entta ayfey goozetto; ubba wode meton entti kuunidi de7o” yaagis. ");
INSERT INTO gofRNT_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Yaatin, Ayhudeti zaari denddonna mela kunddidonayye? Gidenna! Entta kunddethay Ayhude gidonna asay attana mela gaaso gidis. Hessika Ayhudeti entta bolla qanaatanaada oothis. ");
INSERT INTO gofRNT_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Ayhudeta nagaray alamiyas daro anjjo ehis; qassi entta kunddethay Ayhude gidonna asaas daro anjjo gidis. Yaatin, doorettida Ayhudeti kumethi attiyaa wode anjjoy ay mela daranddeshsha! ");
INSERT INTO gofRNT_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Taani, ha77i hinttew Ayhude gidonna asaas odays. Ayhude gidonna asaas hawaare gidada ootheyssan taani daro ceeqettays. ");
INSERT INTO gofRNT_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","Ta hessa oothiday taw ashon zare gidida Isra7eeleta qiiroyada enttafe guuthata ashshanaassa. ");
INSERT INTO gofRNT_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Xoossay entta yeggida wode ha alamey Xoossaara sigettis. Xoossay entta shiishi ekkiya wode hayqqida asi hayqoppe denddida mela gidees. ");
INSERT INTO gofRNT_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Koyro menthida baso uythay Xoossaas yarshshettidi geeshshi gidikko, muume uythayka geeshshi. Mithaas xaphoy geeshshi gidikko, tasheykka geeshshi. ");
INSERT INTO gofRNT_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Gaden tokkida shamaho tashe gidida Ayhudeti karettin, hintte bazzon dolida shamaho tashe gidida Ayhude gidonnayssati entta bessan dhanthettidi entta anjjuwaanne duretethaa shaakettideta. ");
INSERT INTO gofRNT_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","Hiza, hintte tasheda karetti wodhdhida Ayhudeta bolla otorttofite. Hintte otorttiyabaa gidikko, xaphoy hinttena tookkesippe attin hintte xaphuwa tookkonayssa akeekite. ");
INSERT INTO gofRNT_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Neeni, “He tasheti karettiday, ta entta bessan dhanthettana melassa” gaanaw dandda7aasa. ");
INSERT INTO gofRNT_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Hessi tuma. Entti ammaniboonna gisho karettidosona. Neeni ammanida gisho he bessan eqqadasa. Neeni yayyanaw besseesppe attin otoranaw bessenna. ");
INSERT INTO gofRNT_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Xoossay medhon tashe gidida Ayhudetas qadhettonna ixxiko hinttewuka qadhettenna. ");
INSERT INTO gofRNT_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Hiza, Xoossay ay mela keehekonne ay mela yashshiyako be7a. I yashshey kiitettonayssata, qassi I keehey iya ammanidi minnidi eqqidayssatassa. Minnidi eqqonna ixxiko hintteka karettana. ");
INSERT INTO gofRNT_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Ayhudeti ammanikko, kase entti de7iya bessaa simmana. Xoossay entta zaaridi, wothanaw dandda7ees. ");
INSERT INTO gofRNT_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Hinttena bazzon de7iya shamaho gidida Ayhude gidonnayssata qanxidi, gaden tookettida shamahuwa bolla hinttena tokkiko, medhon gade shamaho gidida Ayhudeta bantta koyro bessan zaari tokkanaw waanidi dandda7ettennee? ");
INSERT INTO gofRNT_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Ta ishato, hintte hinttena eranchcho gidi ceeqettofite. Ta hinttew odiya issi xuuri de7ees. Hessika Isra7eeletappe baggay si7onna ixxiday wurssethi gakkanaw gidonnashin attanaw de7iya Ayhude gidonna asay kumethi Xoossako yaana gakkanaassa. ");
INSERT INTO gofRNT_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Hessadakka, Isra7eele asa ubbay attana. Geeshsha Maxaafan, “Nuna ashsheyssi Xiyooneppe yaana; Yayqooba zerethaafe iita ubbaa diggana. ");
INSERT INTO gofRNT_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","Taani entta nagara atto giya wode enttara caaqqana caaqoy hayssa” geetettidi xaafettis. ");
INSERT INTO gofRNT_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Ayhudeti Wonggelaa ekkonna ixxidi, hintte gisho Xoossaara morkke gididosona. Gidoshin, ha77ika entti doorettidayssata, Xoossay entta aawata gisho entta dosees. ");
INSERT INTO gofRNT_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Xoossay ba imuwaninne ba xeessan qiirottenna. ");
INSERT INTO gofRNT_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Hintte Ayhude gidonnayssati kase Xoossaas kiitettibeekketa. Shin ha77i Ayhudeti kiitettonna ixxin, hintte Xoossaa maarotethaa ekkideta. ");
INSERT INTO gofRNT_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","Hessadakka, hintte ekkida maarotethaa Ayhudeti ekkana mela ha77i Xoossaas kiitettonna ixxidosona. ");
INSERT INTO gofRNT_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Xoossay asa ubbaa ba maarotethaa bessanaw koyidi, asi ubbay kiitettonna ixxana mela oothis. ");
INSERT INTO gofRNT_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Xoossaa duretethaa, cinccatethaanne eratethaa akeekidi odanay oonee? Iya pirdday pilggettena, iya ogey erettenna. ");
INSERT INTO gofRNT_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","Geeshsha Maxaafan, “Godaa qofaa erey oonee? Iya zoranaw dandda7ey oonee? ");
INSERT INTO gofRNT_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","Xoossaas tal77eynne tal77iya zaaridi ekkey oonee?” yaagees. ");
INSERT INTO gofRNT_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Ubbaa I medhdhis; ubbay iyan de7ees; ubbay iya bonchchossa. Xoossaas merinaw bonchchoy gido. Amin77i. ");
INSERT INTO gofRNT_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Hiza, ta ishato, hinttee, hintte asatethaa Xoossaa ufayssiya, de7onne geeshsha yarshsho oothidi, immana mela taani hinttena Xoossaa maarotethan woossays. Xoossaa hintte goynnanaw bessiya tuma ogey hessa. ");
INSERT INTO gofRNT_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","Lo77o, ufaysseyssanne polo gidida Xoossaa sheniya hintte shaakki eranaw hintte qofan laamettiteppe attin ha alamiya daanopite. ");
INSERT INTO gofRNT_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Xoossay hintte issuwas issuwas immida ammanuwa mela wozanaama asada qoppite. Qoppanaw besseyssafe aathidi hinttena dummayidi, otoron qoppofite gada taw imettida aadho keehatethan hinttew odays. ");
INSERT INTO gofRNT_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Nu issi asatethaa giddon dumma dumma kifileti de7oosona; he dumma dumma kifiletas dumma dumma oosoy de7ees. ");
INSERT INTO gofRNT_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","Hessada, nuuni daro asi gidikkoka Kiristtoosan issi asatethi gidida. Nuuni issi asatethi gididi dumma dumma kifileti issoy issuwara oykettida. ");
INSERT INTO gofRNT_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Nuus imettida aadho keehatethan dumma dumma imotati de7oosona. Nu imoy tinbbit odo gidikko, nuus de7iya ammanuwa mela odanaw bessees. ");
INSERT INTO gofRNT_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","Nu imoy harata maade gidikko, he oosuwan minnanaw bessees; tamaarsso gidikko, he tamaarssuwan minnanaw bessees. ");
INSERT INTO gofRNT_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","Nu imoy harata minthetho gidikko, minnidi minthethanaw bessees. Nu imoy nuus de7iyabaappe haratas imo gidikko, wozanappe immanaw bessees. Nu imoy ayso gidikko, minnidi aysanaw bessees. Nu imoy haratas keeho gidikko, ufayssan keehanaw bessees. ");
INSERT INTO gofRNT_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Hintte siiqoy qoodheppe qommon gidanaw bessenna. Iitabaa ixxite; lo77obaa minthidi oykkite. ");
INSERT INTO gofRNT_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","Issoy issuwara ishada siiqetite; issoy issuwa bonchchite. ");
INSERT INTO gofRNT_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","Azallofite; hintte ayyaanan minnidi Godaas oothite. ");
INSERT INTO gofRNT_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","Xoossay immida ufayssan ufayttite; metuwa dandda7ite; ubba wode Xoossaa woossite. ");
INSERT INTO gofRNT_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","Ammaniya geeshshata koshshiyaban maaddite; imathata mokkite. ");
INSERT INTO gofRNT_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Hinttena goodeyssata anjjite; anjjiteppe attin baaddofite. ");
INSERT INTO gofRNT_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","Ufayttessatara ufayttite; yeekkeyssatara yeekkite. ");
INSERT INTO gofRNT_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","Issoy issuwara issi qofan de7ite. Otoro qofaa aggidi, hinttena kawushshidi, kawushsha ooso oothite. Hintte hinttena cincca gidi qoppofite. ");
INSERT INTO gofRNT_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","Oonikka hinttew iitabaa oothiko, he uraas iita zaaroppite. Asa ubbaa sinthan nashisiya lo77o ooso oothite. ");
INSERT INTO gofRNT_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","Asa ubbaara saron daanaw hinttew dandda7ettiya ubbaa oothite. ");
INSERT INTO gofRNT_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","Ta ishato, hinttee, hintte huu7en asas halo keyoppite. Xoossay halo keyana mela iyaw aggaagite. Geeshsha Maxaafan, “Taani halo keyana; taani kushe zaarana” yaagees Goday, geetettidi xaafettis. ");
INSERT INTO gofRNT_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","Shin Geeshsha Maxaafan, “Ne morkkey koshattiko muza; I saamotiko ushsha. Neeni hessa oothiko iya huu7en yeella tama bonqqo qolaasa” geetettidi xaafettis. ");
INSERT INTO gofRNT_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Iitaa lo77on xoonappe attin iitaan xoonettofa. ");
INSERT INTO gofRNT_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Xoossaa shene gidonnashin maati imettonna gishonne ha77i de7iya shuumatikka Xoossaa shenen shuumettida gisho asi ubbay deriya ayseyssatas kiitettanaw bessees. ");
INSERT INTO gofRNT_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Hessa gisho, maatara de7eyssatas kiitettonna ixxiya oonikka Xoossaa kiitaa ixxees. Kiitettonna ixxiya oonikka ba bolla pirddaa ehees. ");
INSERT INTO gofRNT_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","Ayseyssati iita ootheyssatappe attin lo77o ootheyssata yashshokona. Ayseyssatas yayyonna agganaw koyay? Yaakko lo77o ootha; entti nena galatana. ");
INSERT INTO gofRNT_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","Entti new lo77obaa oothanaw shuumettida Xoossaa aylle. Shin neeni iitabaa oothiko, entti iitabaa oothidayssa seeriya gisho iyaw yayya. Entti iita ootheyssata seeridi, Xoossaa hanquwa qonccisiya Xoossaa aylle. ");
INSERT INTO gofRNT_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","Hessa gisho, Xoossaa hanquwa xalaalas gidonnashin hintte kahay markkattiya gisho deriya ayseyssatas kiitettanaw bessees. ");
INSERT INTO gofRNT_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","Hintte giira giireykka hessassa. Deriya ayseyssati he oosuwa oothey, entti Xoossaa aylleta gidida gishossa. ");
INSERT INTO gofRNT_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","Issuwas issuwas besseyssa immite. Giira giiranaw besseyssas giirite; qaraxa qanxanaw besseyssas qaraxa qanxite; yayyanaw besseyssas yayyite; bonchchoy besseyssa bonchchite. ");
INSERT INTO gofRNT_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","Issoy issuwara siiqetite. Siiqo acoppe attin hintte bolla hara acoy dooppo. Ase siiqiya oonikka higgey geyssa polis. ");
INSERT INTO gofRNT_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","“Laammofa; wodhoppa; kaysotoppa; amottofa” giya kiitaynne hara kiita ubbay, “Ase ne huu7eda dosa” giya kiitan qashettis. ");
INSERT INTO gofRNT_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","Ase siiqiya oonikka iya bolla iitabaa oothenna. Hessa gisho, ase siiqeyssi higge kiitaa polis. ");
INSERT INTO gofRNT_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","Dhiskkofe hintte barkkiya wodey ha77i gideyssa akeekidi hessa oothite. Nu attana wodey koyro nu ammanida wodiyappe ha77i nuukko matis. ");
INSERT INTO gofRNT_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","Dhuma wodey aadhdhanaw hanees; wonttay matis. Hiza, nuuni dhuma ooso aggidi poo7o ola miishe oykkoos. ");
INSERT INTO gofRNT_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","Ane gallas poo7on de7iya asada maaran de7oos. Mathoninne laymatethara gahettiya dumma dumma tuna oosotan, palamaninne qanaaten gidoppo. ");
INSERT INTO gofRNT_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","Godaa Yesuus Kiristtoosa kandduwa ma77ite; hintte nagaranchcho asatethay ba amuwaa polana mela iyaw qoppofite. ");
INSERT INTO gofRNT_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","Ammanon daaburida oonakka shiishi ekkiteppe attin iya qofaa bolla pirddofite. ");
INSERT INTO gofRNT_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","Leemisos, ammanon minnida issi asi ay kathika maanaw dandda7ees. Shin ammanon daaburiya asi atakiltte xalaala mees. ");
INSERT INTO gofRNT_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","Ubbabaa miya asi moonna uraa kadhoppo. Ubbabaa moonna asi miya uraa bolla pirddofo. Xoossay ubbaa miya uraa shiishi ekkis. ");
INSERT INTO gofRNT_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","Hara asa aylle bolla pirddey neeni oonee? I daaburin woykko minnin ba Godaassa. Goday iya essanaw dandda7iya gisho I minnidi eqqana. ");
INSERT INTO gofRNT_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","Qassi “Issi gallasay hara gallasappe aadhdhees” yaagidi qoppiya asi de7ees. Haray qassi, “Gallasati ubbay issi mela” gidi qoppees. Shin issoy issoy ba qofaa akeekidi qachcho. ");
INSERT INTO gofRNT_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","Issi gallasaa hara gallasatappe aathidi bonchchiya oonikka Godaa bonchchos gidi oothees. Ubba kathi miya asi Godaa bonchchos gidi mees. I miya he kathaa gisho Xoossaa galatees. Ubba kathi moonna asi Godaa bonchchos moonna aggees; qassi moonna agon Xoossaa galatees. ");
INSERT INTO gofRNT_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","Nuuppe oonikka baw deenna; qassi nu giddofe oonikka baw hayqqenna. ");
INSERT INTO gofRNT_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","Nu de7on de7ikko Godaas de7oos; qassi hayqqikokka Godaas hayqqoos. Hiza, nu de7on de7in woykko hayqqin Godaassa. ");
INSERT INTO gofRNT_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","Kiristtoosi hayqqidi hayqoppe denddiday, de7on de7eyssatasinne hayqqidayssatas Goda gidanaassa. ");
INSERT INTO gofRNT_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","Yaatin, neeni ne ishaa bolla ays pirdday? Woykko neeni ne ishaa ays kadhay? Nuuni ubbay Xoossaa pirdda araata sinthan eqqana. ");
INSERT INTO gofRNT_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","Geeshsha Maxaafan Goday, “Taani de7on de7ays; asa ubbay ta sinthan gulbbatana; taani Xoosse gideyssa markkattana” yaagees. ");
INSERT INTO gofRNT_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","Hiza, nu oothidabaas nu huu7en huu7en Xoossaa sinthan shiiqidi zaaro immana. ");
INSERT INTO gofRNT_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","Hessa gisho, nuuni issoy issuwa bolla pirddeyssa aggoos. Shin hintte ishaa dhubsidi woykko qaxxidi nagaran gelssiyaba oothonnaada naagettite. ");
INSERT INTO gofRNT_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","Godaa Yesuusa ammaniyaa asada, ba huu7en tuna gidida kathi baynnayssa taani geeshshada erays. Shin issi asi issibaa tuna gidi qoppiko hessi iyaw tuna gidees. ");
INSERT INTO gofRNT_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","Ne miya katha gisho ne ishaa dhubbiyabaa gidikko, Kiristtoosan de7iya ne ishaa siiqakka. Kiristtoosi iya gisho hayqqida uraa ne miya kathan iya ayyaana de7uwa dhayssofa. ");
INSERT INTO gofRNT_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","Hiza, hinttew de7iya la77atethaa harati borana mela oothofite. ");
INSERT INTO gofRNT_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","Xoossa kawotethay Geeshsha Ayyaanan benttiya xillotethi, sarotethinne tuma ufayssife attin muussabaanne ushshabaa gidenna. ");
INSERT INTO gofRNT_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","Hessada Kiristtoosas oothiya asi Xoossaa ufayssees; asankka anjjettees. ");
INSERT INTO gofRNT_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","Hessa gisho, ane nuuni sarotethi benttiya ogiyanne issuwa issuwa ammanon minthiya ogiya koyoos. ");
INSERT INTO gofRNT_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","Katha gisho gada Xoossaa oosuwa dhaysssofa. Ubba kathi meetetees, shin hara asi nagaran dhubsiya kathi muussi iita. ");
INSERT INTO gofRNT_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","Ne ishay dhubettonna mela asho moonna woykko ushshu uyonna woykko ne ishaa dhubbiya harabaa oothonna agoy lo77o. ");
INSERT INTO gofRNT_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","Hiza, ha ne ammanuwa ne giddoninne ne Xoossaa giddon naaga. Likke gidi qoppidabaa oothiya wode iya kahay mootonna uray anjjettidayssa. ");
INSERT INTO gofRNT_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","Shin sidhishe miya uraas iya muussay ammanon gidonna gisho pirddettees. Ammanoy baynna oosettida ooso ubbay nagara. ");
INSERT INTO gofRNT_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","Nuuni ammanon minnidayssati daaburanchchota toohuwa tookkanaw bessees. Nuuni nuna ufayssanaw bessenna. ");
INSERT INTO gofRNT_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","Nuuni nu ishaa ammanon minthanaw iya maaddanawunne ufayssanaw bessees. ");
INSERT INTO gofRNT_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","Kiristtoosi bana ufayssibeenna. Shin Geeshsha Maxaafan, “Asay nena cayida cashshay tana gakkis” geetetti xaafettidayssada hanis. ");
INSERT INTO gofRNT_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","Geeshsha Maxaafay immiya genccaaninne minthethuwan nu ufayssaa ekkana mela Geeshsha Maxaafan xaafettida ubbay nuna tamaarssanaw xaafettis. ");
INSERT INTO gofRNT_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","Genccaanne minotethi immiya Goday hintte Kiristtoos Yesuusa kaalliya wode issifetethi hinttew immo. ");
INSERT INTO gofRNT_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","Hessika, nu Godaa Yesuus Kiristtoosa Aawa, Xoossaa, issi wozananinne issi qaalan hintte bonchchana melassa. ");
INSERT INTO gofRNT_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","Kiristtoosi hinttena ekkidayssada Xoossaa bonchchos issoy issuwa ekkite. ");
INSERT INTO gofRNT_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","Xoossay beni aawatas immida ufayssay polettana melanne iya tumatethay erettana mela Kiristtoosi Ayhudeta aylle gididi yidayssa ta hinttew odays. ");
INSERT INTO gofRNT_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","Kiristtoosi Ayhudeta aylle gidida hara gaasoy qassi Ayhude gidonna asati Xoossaa iya maarotethaa gisho galatana melassa. Geeshsha Maxaafan, “Ta nena Ayhude gidonna asaa giddon galatana; ne sunthaa sabbana” geetettidi xaafettidayssada hanis. ");
INSERT INTO gofRNT_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","Qassi, “Ayhude gidonna asaw, Xoossaa deriyara ufayttite” yaagettis. ");
INSERT INTO gofRNT_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","Qassi zaaridi, “Ayhude gidonna asaw, Godaa galatite; kawotetha ubbay iya sabbite” yaagettis. ");
INSERT INTO gofRNT_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","Hessada Isayaasi, “Isseyye zareppe yelettiya issoy yaana; I kawotetha ubbaa haarana. Entti bantta ufayssaa iya bolla wothana” yaagees. ");
INSERT INTO gofRNT_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","Geeshsha Ayyaana wolqqan hintte diccana mela ufayssi immiya Xoossay, hintte ammanuwa gaason hinttew ufayssinne sarotethi kumethi immo. ");
INSERT INTO gofRNT_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","Ta ishato, hinttenan lo77otethinne eratethi kumidayssa qassi issoy issuwa zoranaw dandda7eyssa ta geeshshada erays. ");
INSERT INTO gofRNT_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","Taani hinttena issi issibaa gujja akeekisanaw koyada yayyonna ha dabddaabbiya hinttew xaafas. ");
INSERT INTO gofRNT_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","Taani Kiristtoos Yesuusa aylle gidada, Ayhude gidonna asaas kahineda oothada, Wonggelaa odana mela Xoossay taw aadho keehatethaa immis. Ayhude gidonna asay Geeshsha Ayyaanan geeyidi, Xoossaa ufayssiya yarshsho gidana mela Xoossay hessa oothis. ");
INSERT INTO gofRNT_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","Taani Kiristtoos Yesuusan gidada Xoossaas oothiya oosuwan ceeqettays. ");
INSERT INTO gofRNT_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","Ayhude gidonna asay Xoossaas kiitettanaada, Kiristtoosi ta qaalanne ta oosuwa baggara oothida oosuwappe attin hari ta ceeqettiyabay baawa. ");
INSERT INTO gofRNT_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","Xoossay hessa malaataninne Geeshsha Ayyaana wolqqan waati oothidaakko ta hinttew odana. Taani Yerusalaameppe doomada, Iliwarqoone gakkanaw Kiristtoosa Wonggelaa sabbakas. ");
INSERT INTO gofRNT_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","Taani hara asi baasida bessan keexanaw koyikke. Kiristtoosa sunthay xeegettiboonna bessan Wonggelaa odanaw amottays. ");
INSERT INTO gofRNT_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","Geeshsha Maxaafan, “Iyabay odettiboonna asati iya be7ana; iyabaa si7iboonna asati akeekana” geetettidi xaafettis. ");
INSERT INTO gofRNT_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","Hessa gaason, taani hintteko yaanaw dandda7abiikke. ");
INSERT INTO gofRNT_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","Shin taani ha77i ha heeran ta oosuwa onggida gishonne daro laythafe doomada hinttena be7anaw laamotida gisho ");
INSERT INTO gofRNT_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","taani Isppeene bashe hinttena be7anaw qoppas. Qassi guutha wode hinttera ufayttidaappe guye Isppeene biya wode hintte ta ogiyas tana maaddana mela koyays. ");
INSERT INTO gofRNT_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","Shin ha77i taani Xoossaa asata maaddanaw Yerusalaame bays. ");
INSERT INTO gofRNT_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","Maqedooniyanne Akkayan de7iya Xoossaa asati, Yerusalaamen de7iya manqota miishen maaddanaw koyida gishossa. ");
INSERT INTO gofRNT_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","Entti manqota maaddanayssi enttaw attonnabaa gidida gisho bantta huu7en hessa oothanaw qofa qachchidosona. Ayhudeti Ayhude gidonnayssatara ayyaana anjjuwa shaakettiko, entti qassi banttaw de7iyaban Ayhudeta maaddanaw bessees. ");
INSERT INTO gofRNT_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","Hessa gisho, taani he shiiqida miishiya enttaw immidaappe guye Isppeene bashe hintte matara aadhdhana. ");
INSERT INTO gofRNT_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","Taani hintteko biya wode Kiristtoosa anjjuwaan kumada baanayssa erays. ");
INSERT INTO gofRNT_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","Ta ishato, taw Xoossaa woossishe ta baaxiyan taara eqqana mela Godaa Yesuus Kiristtoosaninne Geeshsha Ayyaana siiquwan hinttena woossays. ");
INSERT INTO gofRNT_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","Xoossay tana Yihudan de7iya ammanonna asatappe ashshanaadanne Yerusalaamen ta oothana oosoy Xoossaa asata matan ekettana mela taw woossite. ");
INSERT INTO gofRNT_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","Qassi Xoossi giikko, taani hintteko bada ufayssan hinttera shemppana mela taw woossite. ");
INSERT INTO gofRNT_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","Sarotethaa Xoossay hintte ubbaara gido. Amin77i. ");
INSERT INTO gofRNT_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","Kinkkiriya kataman de7iya woosa keethan oothiya nu michchiya Feeba lo77o maccas gideyssa hintte erana mela koyays. ");
INSERT INTO gofRNT_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","Hintte iyo ammaniyaa asati Godaa sunthan mokkanaw bessiya ammaniyaa asatappe issuwada mokkite. Iya hinttefe koyabaa ubbaa iyo maaddite. Iya ba huu7en daro asaa maaddasu; qassi tana ta huu7enkka daro maaddasu. ");
INSERT INTO gofRNT_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","Kiristtoos Yesuusa oosuwa taara issife oothiya Phirisqilanne Aqiila saro giite. ");
INSERT INTO gofRNT_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","Entti ta gisho bantta shemppuwa aathi immidosona. Ta xalaala gidonnashin Ayhude gidonna asaa woosa keetha ubbay entta galatees. ");
INSERT INTO gofRNT_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","Entta son shiiqiya ammaniyaa asaa saro giite. Iisiya biittan Kiristtoosa koyro ammanida, ta dosiya Ephanexoosas ta sarothuwa odite. ");
INSERT INTO gofRNT_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","Hintte gisho ooson daro daaburida Mayraamo saro giite. ");
INSERT INTO gofRNT_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","Taara qasho keethan aathida ta Ayhude laggeta Anddironiqoosanne Yuuniyasa saro giite. Entti Yesuusa hawaareta giddon erettidayssata. Qassi entti Kiristtoosa taappe sinthe ammanidosona. ");
INSERT INTO gofRNT_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","Godan ammaniyaa ta siiqo laggiya, Amphiliyaxoosa saro giite. ");
INSERT INTO gofRNT_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","Kiristtoosa oosuwa nuura issife oothiya Urbbanoosenne ta dosiya Isttakuusa saro giite. ");
INSERT INTO gofRNT_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","Kiristtoosan ammanthiya aylliya Apheliisas ta sarothuwa odite. Arsxobuloosa soo asaas ta sarothuwa odite. ");
INSERT INTO gofRNT_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","Ta Ayhude laggiya Heroodiyoona saro giite. Narssisanne iya soo asaappe Kiristtoosa ammanidayssata saro giite. ");
INSERT INTO gofRNT_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","Godaa oosuwan daaburiya Tirufaynanne Tirufoosa saro giite. Qassi Godaas daro daaburada oothiya, ta dosiya Phersiiso saro giite. ");
INSERT INTO gofRNT_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","Godaa oosuwan daro erettida Rufoosasinne tana ba na7ada be7iya iya aayes ta sarothuwa odite. ");
INSERT INTO gofRNT_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","Asinikirttoosas, Filegoonas, Hermmeesas, Patirobaasasinne enttara de7iya ammaniyaa ishata ubbaas ta sarothuwa odite. ");
INSERT INTO gofRNT_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","Filoloogusa, Yuuliya, Neeriya, iya michchiw, Olumppoosanne enttara de7iya ammaniyaa asa ubbaa saro giite. ");
INSERT INTO gofRNT_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","Geeshsha yeeretethi yeerettishe, issoy issuwa sarothite. Kiristtoosa woosa keetha ubbay hinttena saro yaagosona. ");
INSERT INTO gofRNT_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","Ta ishato, hintte tamaarida timirttiya ixxidi, hintte giddon shaaketethinne meto medhdhiya asatappe naagettite. Enttafe haakkite. ");
INSERT INTO gofRNT_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","Hessa mela asati banttaw oothosonappe attin nu Godaa Kiristtoosas oothokona. Bantta mal77iya doonaninne saphothiya qaalan aykko eronna asaa wozanaa balethoosona. ");
INSERT INTO gofRNT_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","Wonggelaas hintte kiitettidayssa asa ubbay si7idayssi tana ufayssees. Shin hintte lo77obaa erana melanne iitabaappe haakkana mela ta koyays. ");
INSERT INTO gofRNT_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","Sarotethaa Xoossay Xalahiya hintte tohuwappe garssan gaaci yeggana. Nu Godaa Yesuus Kiristtoosa aadho keehatethay hinttera gido. ");
INSERT INTO gofRNT_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","Taara oothiya Ximotiyoosi hinttena saro yaagees. Hessadakka, ta dabboti Luuqiyosi, Yaasoninne Sosphaxiroosi hinttena saro yaagosona. ");
INSERT INTO gofRNT_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","Ha dabddaabbiya Phawuloosas xaafida taani, Xarxiyoosi, hinttena Godaa sunthan saro yaagays. ");
INSERT INTO gofRNT_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","Tana mokkidaynne woosa keetha ubbay iya son shiiqiya Gaayoosi, hinttena saro yaagees. Katamaa miishiya oykkiya Erasxoosinne nu ishaa Qarxoosi hinttena saro yaagosona.  ");
INSERT INTO gofRNT_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","Nu Godaa Yesuus Kiristtoosa aadho keehatethay hintte ubbaara gido. Amin77i. ");
INSERT INTO gofRNT_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","Xoossas galati gido. Taani, Yesuus Kiristtoosabaa odiya Wonggelaa qaalaninne daro wodeppe qosettidi gam77ida tumatethan, Xoossay hinttena ammanon minthidi essanaw dandda7ees. ");
INSERT INTO gofRNT_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","Shin ha77i he tumay qonccis. Kawotetha ubbay ammanidi kiitettana mela merinaa Xoossaa kiitan nabeti he tumabaa xaafidosona. ");
INSERT INTO gofRNT_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","Yesuus Kiristtoosa baggara cinccatethi iya xalaalas de7iya, issi Xoossaas merinaw bonchchoy gido. Amin77i.");
INSERT INTO gofRNT_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","Xoossaa sheniyan Yesuus Kiristtoosa hawaare gidanaw xeegettida Phawuloosinne, nu ishaa Sostenisi, ");
INSERT INTO gofRNT_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","Qoronttoosan de7iya Xoossaa woosa keethaas, Yesuus Kiristtoosan geeyidayssatasinne geeshshi gidana mela xeegettidayssatas; qassi enttasinne nuus Goda gidiya nu Godaa Yesuus Kiristtoosa sunthaa ubba bessan xeegiya ubbaas; ");
INSERT INTO gofRNT_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","Xoossay, nu Aawaynne Goday Yesuus Kiristtoosi hinttew aadho keehatethaanne sarotethaa immo. ");
INSERT INTO gofRNT_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","Xoossay Kiristtoos Yesuusa baggara hinttew immida aadho keehatethaa gisho taani ubba wode Xoossaa galatays. ");
INSERT INTO gofRNT_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","Iyan odaninne eratetha ubban hintte durettideta. ");
INSERT INTO gofRNT_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","Taani Kiristtoosabaa markkattidayssi tuma gideyssa hessi qonccisees. ");
INSERT INTO gofRNT_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","Hessa gisho, hintte nu Godaa Yesuus Kiristtoosa yuussaa naagishe de7ishin, ay ayyaana imoykka hinttew paccenna. ");
INSERT INTO gofRNT_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","Nu Godaa Yesuus Kiristtoosi simmiya wode hintte borettonnayssata gidana mela I wurssethi gakkanaw hinttena miinthana. ");
INSERT INTO gofRNT_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","Ba Na7aa, nu Godaa Yesuus Kiristtoosara issifetethay daana mela hinttena xeegida Xoossay ammanettidayssa. ");
INSERT INTO gofRNT_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","Ta ishato, hintte gidon shaaketethi doonnaada hintte issi wozananinne issi qofan isso gididi, daana mela nu Godaa Yesuus Kiristtoosa sunthan ta hinttena woossays. ");
INSERT INTO gofRNT_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","Ta ishato, Qelo7e soo asay hintte giddon ooshshi de7eyssa taw odidosona. ");
INSERT INTO gofRNT_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","Hinttefe issoti issoti, “Taani Phawuloosassa; taani Aphiloosassa; taani Phexiroosassa; taani Kiristtoosassa” yaageeta. ");
INSERT INTO gofRNT_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","Kiristtoosi shaakettideyye? Hintte gisho masqaliya bolla kaqettiday Phawulooseyye? Woykko hintte Phawuloosa sunthan xammaqettidetiyye? ");
INSERT INTO gofRNT_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","Taani Qarisphoosinne Gaayoosi attin hinttefe oonakka xammaqaboonna gisho Xoossaa galatays. ");
INSERT INTO gofRNT_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","Hessa gisho, oonikka hinttena ta sunthan xammaqettideta gaanaw dandda7enna.  ");
INSERT INTO gofRNT_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","Qassi Isxifaanose soo asaakka ta xammaqidayssa akeekays, shin haraa oona xammaqidaakko hassayikke. ");
INSERT INTO gofRNT_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","Kiristtoosi tana kiittiday Wonggelaa odana melassafe attin xammaqana mela gidenna. Kiristtoosi masqaliya bolla hayqqidayssi hada gidonna mela taani asa cinccatetha qaalan odikke. ");
INSERT INTO gofRNT_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","Kiristtoosi masqaliya bolla hayqqidayssa odiya qaalay dhayeyssatas eeyatethi, shin nuus atteyssatas Xoossaa wolqqaa. ");
INSERT INTO gofRNT_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","Geeshsha Maxaafan, “Taani cinccata cinccatethaa dhayssana; akeekanchchota akeekaa balethana” yaagees. ");
INSERT INTO gofRNT_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","Yaatin, cincci awun de7ii? Higge asttamaarey awun de7ii? Woykko ha sa7aa eranchchoy awun de7ii? Xoossay ha sa7aa cinccatethaa eeyatethi oothibeennee? ");
INSERT INTO gofRNT_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","Ha sa7aa asay bantta cinccatethan Xoossaa eronna mela ba cinccatethan diggidi, eeyatethan taybettiya, nuuni odiya qaalan ammaneyssata ashshanaw Xoossaa shene gidis. ");
INSERT INTO gofRNT_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","Ayhudeti malaata be7anaw koyoosona; qassi Giriketi cinccatethi koyoosona. ");
INSERT INTO gofRNT_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","Shin nuuni masqaliya bolla kaqettida Kiristtoosa sabbakoos. Hessi Ayhudatas dhube; qassi Giriketas eeyatethi. ");
INSERT INTO gofRNT_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","Shin Xoossay xeegidayssatas, Ayhude gidin, Girike gidin Kiristtoosi Xoossaa wolqqaanne iya cinccatethaa. ");
INSERT INTO gofRNT_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","Xoossaa eeyatethay asa cinccatethafe aadhdhees; qassi Xoossaa daaburay asa minotethafe minnees. ");
INSERT INTO gofRNT_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","Hiza, ta ishato, Xoossay hinttena xeegiya wode hintte ay mela aseekko qoppite. Asa qofan hintte giddon cinccati, wolqqaamatinne dhoqqa zareti dookkona. ");
INSERT INTO gofRNT_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","Shin Xoossay cinccata yeellayanaw alamen de7iya eeyata dooris; qassi minota yeellayanaw alamen de7iya daaburanchchota dooris. ");
INSERT INTO gofRNT_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","Xoossay ha alamiyan gita geetettidabaa dhayssanaw, ha sa7aa kawushshabaa, kadhettidabaanne pathonnabaa dooris. ");
INSERT INTO gofRNT_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","Oonikka Xoossaa sinthan ceeqqettonna mela hessa oothis. ");
INSERT INTO gofRNT_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","Shin Xoossay hinttew Kiristtoos Yesuusara issifetethi daana mela oothis. I nuus Xoossaafe cinccatethi, xillotethi, geeshshatethinne atotethi gidis. ");
INSERT INTO gofRNT_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","Hessa gisho, Geeshsha Maxaafan, “Ceeqettiya oonikka Godan ceeqqo” yaagees. ");
INSERT INTO gofRNT_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","Ta ishato, taani koyro Xoossaa qaala hinttew odashe yida wode doona bilatethaninne cinccatethan yabiikke. ");
INSERT INTO gofRNT_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","Taani hinttera de7iya wode masqaliya bolla kaqettida Yesuus Kiristtoosappe attin harabaa eranaw koyikke gada ta qofa qachchas. ");
INSERT INTO gofRNT_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","Ta hinttera de7iya wode daaburan, yashshaninne daro kokkorssan de7as. ");
INSERT INTO gofRNT_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","Ta kiitaynne ta timirttey doona bilatethaninne cinccatethan gidonnashin Geeshsha Ayyaana wolqqaa qonccisethaana. ");
INSERT INTO gofRNT_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","Hessika, hintte ammanoy Xoossaa wolqqaanappe attin asa cinccatethan zempponna melassa. ");
INSERT INTO gofRNT_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","Ayyaana de7on diccidayssatas nuuni cinccatethaa qaalan odoos. Shin he cinccatethay, ha sa7aa cinccatethaa woykko dhayanaw de7iya ha sa7aa haareyssata cinccatethaa gidenna. ");
INSERT INTO gofRNT_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","Shin nuuni odiya cinccetethay, daro wodeppe sinthe Xoossay nu bonchchuwas giigisidayssanne geemmidi de7iya xuura cinccatethaa. ");
INSERT INTO gofRNT_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","Ha sa7aa haareyssatappe oonikka ha cinccatethaa eribeenna. Entti eridabaa gidiyakko, bonchcho Godaa masqaliya bolla kaqqokona. ");
INSERT INTO gofRNT_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","Shin Geeshsha Maxaafan, “Ayfey be7iboonnabaa, haythi si7iboonnabaa, wozani qoppiboonabaa, Xoossay bana siiqeyssatas giigisis” yaagees. ");
INSERT INTO gofRNT_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","Xoossay ba xuuraa ba Ayyaana baggara nuus qonccisis. Geeshsha Ayyaanay hari attoshin geemmida Xoossaa xuura ubbaa pilggees. ");
INSERT INTO gofRNT_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","Asan de7iya asa ayyaanaappe attin asabaa oonikka erenna. Hessadakka, Xoossabaa Xoossaa Ayyaanaappe attin oonikka erenna. ");
INSERT INTO gofRNT_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","Xoossay nuus coo immidabaa nu erana mela Xoossaa Ayyaanaa ekkidappe attin ha sa7aa ayyaana ekkibookko. ");
INSERT INTO gofRNT_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","Nuuni ayyaanabaa, ayyaana asatas asa cinccatethan gidonnashin Xoossaa Ayyaanay immiya cinccatethan tamaarssos. ");
INSERT INTO gofRNT_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","Shin Geeshsha Ayyaanay baynna asi Xoossaa Ayyaana imotata ekke