﻿USE sofia;
DROP TABLE IF EXISTS sofia.gofENT_vpl;
CREATE TABLE gofENT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES gofENT_vpl WRITE;
INSERT INTO gofENT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","ሃይሳፌ ካሊዲ ፃፌቲዳይሲ ዳዊቴ ናዓ ኣብራሃሜ ናዓ ጊዲዳ ዬሱስ ኪሪስቶሳ ዬሌቴꬃ። ");
INSERT INTO gofENT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","ኣብራሃሜይ ዪሳቃ ዬሊስ፤ ዪሳቂ ያይቆባ ዬሊስ፤ ያይቆቢ ዪሁዳኔ ኢያ ኢሻታ ዬሊስ፤ ");
INSERT INTO gofENT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","ዪሁዲ ቲዒማሪፔ ፋሬሴኔ ዛራ ዬሊስ፤ ፋሬሲ ኣስሮሜ ዬሊስ፤ ኣስሮሜይ ራሜ ዬሊስ፤ ");
INSERT INTO gofENT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","ራሜይ ኣሚናዳቤ ዬሊስ፤ ኣሚናዳቤይ ናዓሶና ዬሊስ፤ ናዓሶኔይ ሳልሞና ዬሊስ፤ ");
INSERT INTO gofENT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","ሳልሞኔይ ራዓቢፔ ቦዔዛ ዬሊስ፤ ቦዔዚ ኡሩቲፔ ኢዮቤዴ ዬሊስ፤ ኢዮቤዲ ኢሴዬ ዬሊስ፤ ");
INSERT INTO gofENT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ኢሴዬይ ካዉዋ ዳዊቴ ዬሊስ፤ ዳዊቴይ ኦሪዮ ማቼፌ ሶሎሞኔ ዬሊስ፤ ");
INSERT INTO gofENT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","ሶሎሞኔይ ሮቢዓማ ዬሊስ፤ ሮቢዓሜይ ኣቢያ ዬሊስ፤ ኣቢዬይ ኣሳፌ ዬሊስ፤ ");
INSERT INTO gofENT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","ኣሳፊ ኢዮሳፌፄ ዬሊስ፤ ኢዮሳፊፄይ ኢዮራሜ ዬሊስ፤ ኢዮራሜይ ኦዚያኔ ዬሊስ፤ ");
INSERT INTO gofENT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","ኦዚያኔይ ኢዮዓታሜ ዬሊስ፤ ኢዮዓታሜይ ኣካዛ ዬሊስ፤ ኣካዚ ሂዚቂያሳ ዬሊስ፤ ");
INSERT INTO gofENT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","ሂዚቂያሲ ሚናሴ ዬሊስ፤ ሚናሴይ ኣሞና ዬሊስ፤ ኣሞኒ ኢዮሲያሳ ዬሊስ፤ ");
INSERT INTO gofENT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","ኢስራዔሌ ኣሳይ ዲዔቲዲ ባቢሎኔ ቢታ ቢዳ ዎዴ ኢዮሲያሲ ኢኮኒያናኔ ኢያ ኢሻታ ዬሊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","ባቢሎኔ ቢታ ኢስራዔሌ ኣሳይ ዲዔቲዲ ቢዳፔ ጉዬ ኢኮኒያኒ ሳላቲያሌ ዬሊስ። ሳላቲያሌይ ዜሩባቤላ ዬሊስ፤ ");
INSERT INTO gofENT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","ዜሩባቤሊ ኣብዲዩ ዬሊስ፤ ኣብዲዩይ ኤሊያቄሜ ዬሊስ፤ ኤሊያቄሜይ ኣዛራ ዬሊስ፤ ");
INSERT INTO gofENT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","ኣዛሪ ሳዶቄ ዬሊስ፤ ሳዶቄይ ኣኪሜ ዬሊስ፤ ኣኪሜይ ኤሊዩዳ ዬሊስ፤ ");
INSERT INTO gofENT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","ኤሊዩዲ ኣላዛራ ዬሊስ፤ ኣላዛሪ ማታኔ ዬሊስ፤ ማታኔይ ያይቆባ ዬሊስ፤ ");
INSERT INTO gofENT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ያይቆቢ ዮሴፋ ዬሊስ፤ ዮሴፊ ኪሪስቶሳ ጊያ ዬሱሳ ዬሊዳ ማይራሚ ኣዚና። ");
INSERT INTO gofENT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","ሂዛ፥ ዬሌቴꬃይ ኣብራሃሜፔ ዳዊቴ ጋካናው ታማኔ ኦይዳ። ዳዊቴፔ ቢዲ ባቢሎኔ ዲዑዋ ጋካናው ታማኔ ኦይዳ። ባቢሎኔ ዲዑዋፔ ቢዲ ኪሪስቶሳ ጋካናው ታማኔ ኦይዱ ዬሌቴꬂ ጊዴስ። ");
INSERT INTO gofENT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","ዬሱስ ኪሪስቶሳ ዬሌቴꬃ ታሪኬይ ሃይሳፌ ካሌይሳ። ኢያ ኣያ ማይራማ ዮሴፋስ ኦይሼታ ዴዓሼ ዮሴፋራ ጋሄቶና ጌሻ ኣያናፔ ቃንꬃታሱ። ");
INSERT INTO gofENT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","ዮሴፊ ፂሎ ኣሲ ጊዲዳ ጊሾ ኢዮ ኣሳን ኬሳናው ኮዪቤና። ያኒያ ጊሾ ቆሳን ኢዮ ኣጋናው ቆፒስ። ");
INSERT INTO gofENT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","ኢ ሄ ቆፋን ዴዒሺን ፆሳ ኪታንቾይ ኣሙሆን ቆንጪዲ፥ «ዳዊቴ ናዓው፥ ዮሴፋ፥ ማይራማ ቃንꬃቲዳይ ጌሻ ኣያናፔ ጊዲያ ጊሾ ኢዮ ኤካናው ያዮፋ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","ኢያ ኣዴ ናዓ ዬላና፥ ኢ ባ ዴሪያ ኤንታ ናጋራፔ ኣሺያ ጊሾ ኢያ ሱንꬃ ኔ ዬሱሳ ጋዳ ፄጋና። ");
INSERT INTO gofENT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","ጎዳይ ናቢያ ኢሳያሳ ዶናን፥ ");
INSERT INTO gofENT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","«ሄኮ ጌላዒያ ቃንꬃታና፤ ኣዴ ናዓካ ዬላና፤ ኢያ ሱንꬃይ ኣማኑዔላ ጌቴታና» ጎይሲ ፖሌታና ሜላ ሃ ኡባይ ሃኒስ። ኣማኑዔላ ጌይሳስ ቢርሼꬃይ «ፆሳይ ኑራ ዴዔስ» ጉሱ። ");
INSERT INTO gofENT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","ዮሴፊ ꬊስኮፌ ባርኪዲ ጎዳ ኪታንቾይ ኪቲዳይሳ ሜላ ማይራሞ ባ ሶ ኤፊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","ሺን ባ ባይራ ናዓ ዬላና ጋካናው ኢዮ ቦቺቤና፤ ዬሌቲዳ ናዓካ ዬሱሳ ጊዲ ፄጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","ካዉዋ ሄሮዲሳ ዎዴን ዬሱሲ ዪሁዳ ቢታን ቤቴሌሜ ካታማን ዬሌቲዳይሳፌ ጉዬ ፆሊንቶ ታይቢያ ኣሳቲ ዶሎሃፔ ዬሩሳላሜ ዪዲ፥ ");
INSERT INTO gofENT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","«ዬሌቲዳ ኣይሁዴ ካዎይ ኣዉን ዴዒ? ኑኒ ዶሎሃ ባጋራ ኬዪዳ ኢያ ፆሊንቱዋ ቤዒዲ ኢያው ጎይናናው ዪዳ» ያጊዲ ኦይቺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","ካዎይ ሄሮዲሲ ሄሳ ሲዒዳ ዎዴ ዳጋሚስ። ዬሩሳላሜን ዴዒያ ኣሳይ ኡባይካ ዳጋሚዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","ሄሮዲሲ ካሂኔ ሃላቃታኔ ሂጌ ኣስታማሬታ ባኮ ፄጊዲ፥ «ኪሪስቶሲ ኣዉን ዬሌታንዴሻ?» ያጊዲ ኤንታ ኦይቺስ። ");
INSERT INTO gofENT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","ኤንቲካ፥ «ዪሁዳ ቤቴሌሜና፤ ናቤይ፥ ");
INSERT INTO gofENT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‹ዪሁዳን ዴዒያ ቤቴሌሜ፥ ዪሁዳን ዴዒያ ጎባ ካታማታፔ፥ ኔኒ ኣይቢንካ ጉፃካ። ታ ዴሪያ ኢስራዔሌ ኣይሳናይሲ፥ ኔፔ ኬያና› ጊዲ ፃፊስ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","ሄሳፌ ጉዬ፥ ሄሮዲሲ ዶሎሃፔ ዪዳ ኣሳታ ጌማን ፄጊዲ፥ ፆሊንቱዋ ኤንቲ ቤዒዳ ዎዲያ ኤንታፌ ጌሺዲ ኤሪስ። ");
INSERT INTO gofENT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","ኢ ኤንታና ቤቴሌሜ ዬዲሼ፥ «ቢዲ ዬሌቲዳ ናዓ ሚንꬂዲ ኮዪቴ፤ ኢያ ሂንቴ ዴሚዳ ዎዴ ታካ ባዳ ኢያው ጎይናና ሜላ ሲሚዲ ዪሼ ታው ኦዲቴ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","ኤንቲካ ካዎይ ሄሮዲሲ ጊዳይሳ ሲዒዲ ቢዶሶና። ኤንቲ ዶሎሃ ባጋራ ቤዒዳ ፆሊንቶይ ኤንታና ካሌꬂሼ ናዓይ ዴዒያሱዋ ጋካናው ኤፊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","ኤንቲ ሄ ፆሊንቱዋ ቤዒዳ ዎዴ ጊታ ኡፋይሲ ኡፋይቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","ሶ ጌሊዲ ናዓ ባ ኣዬ ማይራሚራ ዴዔይሳ ቤዒዶሶና። ኢያው ጉልባቲዲ ጎይኒዶሶና። ባንታ ሳፂኒያ ዶዪዲ ዎርቃ፥ ኢፃኔኔ ካርቤ ኢያው ኢሚዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","ኤንቲ ሄሮዲሳኮ ጉዬ ሲሞና ሜላ ፆሳይ ኣሙሆን ኤንታው ኦዲን፥ ሃራ ኦጌራ ባንታ ቢታ ሲሚዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","ዶሎሃ ባጋፌ ዪዳ ኣሳቲ ቢዳፔ ጉዬ፥ ጎዳ ኪታንቾይ ዮሴፋስ ኣሙሆን ቆንጪዲ፥ «ሄሮዲሲ ናዓ ዎꬋናው ኮያ ጊሾ ዴንዳ፤ ኤሌሳዳ ናዓኔ ናዓ ኣዪው ኤካዳ ጊብፄ ቢታ ባ። ኔ ሲማና ዎዲያ ታ ኔው ኦዳና ጋካናው ያን ጋምዓ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","ሄሳ ጊሾ፥ ዮሴፊ ሄ ቃማን ዴንዲዲ፥ ናዓኔ ናዓ ኣዪው ኤኪዲ ጊብፄ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","ናቢያ ዶናን ፆሳይ፥ «ታኒ፥ ታ ናዓ፥ ጊብፄ ቢታፌ ፄጋስ» ጌቴቲዳ ቃላይ ፖሌታና ሜላ ሄሮዲሲ ሃይቃና ጋካናው ኢ ያን ዴዒስ። ");
INSERT INTO gofENT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","ሄሳፌ ጉዬ፥ ዶሎሃ ባጋፌ ዪዳ ኣሳቲ ኢያ ጪሚዳይሳ ኤሪዳ ዎዴ ዳሮ ዪሎቲስ። ኢ ካሴ ኤንታፌ ሲዒዳይሳዳ ቤቴሌሜኒኔ ሄ ሄራን ዴዒያ ናምዑ ላይꬂ ኩሚዳይሳታኔ ናምዑ ላይꬃፌ ጋርሳን ዴዒያ ኣዴ ናይታ ኡባ ባ ዎታዳሬታ ዬዲዲ ዎꬊሲስ። ");
INSERT INTO gofENT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","18","ናቢያ ኤርሚያሳ ዶናን፥ «ዬሆይኔ ዜሌልሲ፥ ራማ ካታማን ሲዔቲስ። ራሄላ ባ ናይታስ ዬካዉሱ፤ ኤንቲ ሃይቂዳ ጊሾ ሚኔታናው ዳንዳዓቡኩ» ጊዲ ኦዲዳይሲ ፖሌቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","ሄሮዲሲ ሃይቂዳፔ ጉዬ ጊብፄን ጎዳ ኪታንቾይ ዮሴፋስ ኣሙሆን ቆንጪዲ፥ ");
INSERT INTO gofENT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","«ናዓ ዎꬋናው ኮያ ኣሳቲ ሃይቂዳ ጊሾ ዴንዳዳ ናዓኔ ናዓ ኣዪው ኤካዳ ኢስራዔሌ ቢታ ሲማ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","ዮሴፊ ዴንዲዲ ናዓኔ ናዓ ኣዪው ኤኪዲ ኢስራዔሌ ቢታ ሲሚስ። ");
INSERT INTO gofENT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","ሺን ኣርኬሊዮሲ ዪሁዳን ባ ኣዋ ሄሮዲሳ ቤሳን ካዎቲዳይሳ ሲዒዳ ዎዴ ያ ባናው ያዪስ። ፆሳይ ኣሙሆን ኢያው ቆንጪሲን ጋሊላ ቢታ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ናቤታ ዶናን፥ «ናዚሬቴ ኣሲ ጌቴታና» ጊዲ ኦዴቲዳይሲ ፖሌታና ሜላ ናዚሬቴ ካታማ ቢዲ ያን ዴዒስ። ");
INSERT INTO gofENT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","2","ሄ ዎዴ ፃማቂያ ዮሃኒሲ፥ «ፆሳ ካዎቴꬃይ ማታቲዳ ጊሾ ሂንቴ ናጋራፔ ሲሚቴ» ያጊዲ ሳባኪሼ ዪሁዳ ባዞ ቢታ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","ናቢያ ኢሳያሲ ዮሃኒሳባ ኦዲዳይሳ ሜላ፥ «ባዞ ቢታን፥ ኢሶይ ባ ቃላ ꬎቁ ኦꬂዲ፥ ‹ጎዳ ኦጊያ ጊጊሲቴ። ኢያ ሆሮጋ ፒዲ ኦꬂቴ› ጊስ» ያጌቲዳይ ኢያሳ ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","ዮሃኒሲ ጊማሌ ኢኪሴፔ ኦሴቲዳ ኣፊላ ማዔስ። ባ ፄሳን ዳፎ ዳንጬስ። ኢ ሚያ ካꬃይካ ቦሌኔ ዴጌራ ኤሲ። ");
INSERT INTO gofENT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","ኣሳይ ሄ ዎዴ ዬሩሳላሜ ካታማፔ፥ ዪሁዳ ቢታ ኡባፌኔ ዮርዳኖሴ ሻፋ ሄራፔ ኢያኮ ዮሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ባንታ ናጋራ ፓፂዲ ዮርዳኖሴ ሻፋን ዮሃኒሳ ኩሼን ፃማቄቶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","ዮሃኒሲ፥ ዳሮ ፋሪሳዌቲኔ ሳዱቃዌቲ ፃማቄታናው ባኮ ዬይሳታ ቤዒዲ፥ ኤንታኮ፥ «ሃ ኢታ ሾሻቶ፥ ያና ፆሳ ሃንቁዋፌ ባቃታና ሜላ ሂንቴና ኦኔ ዞሪዳይ? ");
INSERT INTO gofENT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","ሂዛ፥ ሂንቴ፥ ሂንቴ ናጋራፔ ሲሚዳይሳ ኤሪሲያባ ኦꬂቴ። ");
INSERT INTO gofENT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","ሂንቴ፥ ሂንቴ ዎዛናን፥ ‹ኣብራሃሜይ፥ ኑ ኣዋይ ዴዔስ› ጊዲ ቆፖፊቴ። ሎይꬂ ሲዒቴ! ፆሳይ ሃ ሹቻታፔ ኣብራሃሜስ ናዓ ኬሳናው ዳንዳዔስ። ");
INSERT INTO gofENT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","ቤፄይ ሚꬃ ፃጱዋን ጊጊዲ ኡቲስ፤ ሎዖ ኣይፌ ኣይፎና ሚꬃ ኡባይ ቃንፄቲዲ ታማን ዬጌታና። ");
INSERT INTO gofENT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","«ሂንቴ፥ ሂንቴ ናጋራፔ ሲሚዳይሳ ኤሪሳናው ታኒ ሂንቴና ሃꬃን ፃማቃይስ። ሺን ታፔ ጉዬራ ዬይሲ ሂንቴና ጌሻ ኣያናኒኔ ታማን ፃማቃና። ኢ ታፔ ዳሮ ዎልቃሜስ፤ ታኒ ሃሪ ኣቶሺን ኢያ ጫማ ቶካናዉካ ቤሲኬ። ");
INSERT INTO gofENT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","ካꬃ ጌሺያ ፒꬄይ ኢያ ኩሼን ዴዔስ። ካꬃ ሎይꬂ ጌሼስ፤ ጊስቲያ ባ ሻሊያን ቆላና፥ ሺን ፑኑዋ ቶዖና ታማን ፁጋና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","ሄ ዎዴ ዬሱሲ ዮሃኒሳ ኩሼን ፃማቄታናው ጋሊላፔ ዮርዳኖሴ ሻፋ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","ሺን ዮሃኒሲ ኢያ ዲጋናው ኮዪድ፥ «ታኒ ኔናን ፃማቄታናው ኮሺሺን ኔኒ ታኮ ያይ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","ሺን ዬሱሲ ዛሪዲ፥ «ፆሳይ ኑፔ ኮያባ ኡባ ኑ ፖላናው ቤሲያ ጊሾ ሃዒ ታው ኤሮ ጋ» ያጊስ። ዮሃኒሲ ኢያው ኤሮ ጊዲ ኤኪስ። ");
INSERT INTO gofENT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","ዬሱሲ ፃማቄቲዳ ሜላ ሃꬃፌ ኬዪስ። ኢራካ ሳሎይ ዶዬቲን ፆሳ ኣያናይ ሆሌዳ ዪሺን ቃሲ ባ ቦላ ዎልዓሚዲ ዎꬊሺን ቤዒስ። ");
INSERT INTO gofENT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","ሄ ዎዴ «ታ ዶሲያ፥ ኢያን ታና ኡፋይሲያ ታ ናዓይ ሃይሳ» ያጊያ ቃላይ ሳሎፔ ዪስ። ");
INSERT INTO gofENT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","ሄሳፌ ጉዬ፥ ፃላሄይ ዬሱሳ ፓጫና ሜላ ጌሻ ኣያናይ ዬሱሳ ባዞ ቢታ ኤፊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","ኦይታሙ ቃማኔ ኦይታሙ ጋላስ ፆሚዳፔ ጉዬ ኮሻቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","ፃላሄይ ዬሱሳኮ ዪዲ «ኔኒ ፆሳ ናዓ ጊዲኮ፥ ኣኔ ሃ ሹቻቲ ኡይꬂ ጊዳና ሜላ ኪታ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","ዬሱሲ ዛሪዲ፥ « ‹ኣሲ ፆሳ ዶናፔ ኬያ ቃላ ኡባን ዳናፔ ኣቲን ኡይꬃ ፃላላን ዴዔና› ጌቴቲዲ ፆሳ ቃላን ፃፌቲስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","ካሊዲካ፥ ፃላሄይ ዬሱሳ ጌሻ ካታማ ኤፊዲ፥ ፆሳ ኬꬃ ሁዒያ ኬሲዲ፥ ");
INSERT INTO gofENT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","«ኔኒ ፆሳ ናዓ ጊዲኮ፥ ኣኔ ዱጌ ሳዓን ኩንዳ። ኣይስ ጊኮ፥ ‹ኔ ቶሆይ ሹቻን ꬉቤቲ ዴሼቶና ሜላ፥ ባንታ ኩሺያን ኔና ዴንꬃና ሜላ፥ ፆሳይ ባ ኪታንቾታ ኔ ጊሾ ኪታና› ጌቴቲዲ ፆሳ ቃላን ፃፌቲስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","ዬሱሲ ኢያኮ፥ «ቃሲካ፥ ‹ፆሳ ቃላን ኔ ጎዳ፥ ኔ ፆሳ ፓጮፋ› ያጌቲዲ ፃፌቲስ» ጊዲ ዛሪስ። ");
INSERT INTO gofENT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","ዉርሴꬃን ፃላሄይ ዬሱሳ ኢሲ ዎልቃማ ዴሪያ ሁዔ ኬሲዲ ኣላሚያ ካዎቴꬃታ ኤንታ ቦንቹዋራ ኢሲፌ ቤሲዲ፥ ");
INSERT INTO gofENT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","«ኔ ታው ኩንዳዳ ጎይኒኮ ታ ኔው ሃ ኡባ ኢማና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","ዬሱሲ ዛሪዲ፥ «ሃ ፃላሂያው፥ ታፔ ሃካ! ‹ኔ ጎዳ፥ ኔ ፆሳ ጎይና፥ ኢያ ፃላላ ሃጋዛ› ጌቴቲዲ ፆሳ ቃላን ፃፌቲስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","ሄሳፌ ጉዬ፥ ፃላሄይ ኣጊዲ ቢስ፤ ኪታንቾቲ ዪዲ ኢያ ሃጋዚዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","ዬሱሲ፥ ዮሃኒሲ ቃሼቶይሳ ሲዒዳ ዎዴ ጋሊላ ቢታ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","ናዚሬቴ ካታማ ኣጊዲ ዛቢሎናኒኔ ኒፍታሌሜ ሄራን፥ ኣባ ማታን ዴዒያ ቂፊርናሆሜ ካታማ ቢዲ ያን ዴዒስ። ");
INSERT INTO gofENT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","ሄሲ ሃኒዳይ ናቢያ ኢሳያሳ ዶናን፥ ");
INSERT INTO gofENT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«ዛቢሎኔ ቢታን፥ ኒፍታሌሜ ቢታን፥ ዮርዳኖሴ ሻፋፔ ሄፊንꬃን፥ ኣባ ኦጊያ ጋፃን ዴዒያ፥ ኣይሁዴ ጊዶና ዴሬይ ዴዒያ ጋሊላን፥ ");
INSERT INTO gofENT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ꬉማን ዴዒያ ዴሬይ፥ ዎልቃማ ፖዖ ቤዒስ። ሃይቆ ኩያ ቢታን፥ ዴዔይሳታስ ፖዖይ ኬዪስ» ያጊዲ ኦዴቲዳ ቃላይ ፖሌታና ሜላሳ። ");
INSERT INTO gofENT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","ሄ ዎዴፔ ዶሚዲ ዬሱሲ፥ «ፆሳ ካዎቴꬃይ ማታቲዳ ጊሾ ሂንቴ ናጋራፔ ሲሚቴ» ያጊዲ ቃላ ሳባኬስ። ");
INSERT INTO gofENT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","ዬሱሲ ጋሊላ ኣባ ማታራ ኣꬊሼ ናምዑ ኢሻታ፥ ጴፂሮሳ ጌቴቲያ ሲሞናኔ ኢያ ኢሻ ኢንዲሪያሳ ቤዒስ። ኤንቲ ሞሎ ኦይኬይሳታ ጊዲዳ ጊሾ ባንታ ጊቲያ ኣባን ዬጎሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","ዬሱሲ ኤንታና፥ «ሃ ዪቴ፤ ታና ካሊቴ! ሞሎ ኦይꬂ ኣቶሺን፥ ታ ሂንቴና ኣሴ ኦይꬂ ታማርሳና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","ኤንቲካ፥ ኤሌሲዲ ባንታ ጊቲያ ዬጊ ኣጊዲ ዬሱሳ ካሊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","ዬሱሲ ያፔ ቡሮ ጌዴ ሲንꬄ ኣꬊሼ ሃራ ናምዑ ኢሻታ፥ ዛብዲዮሳ ናይታ፥ ያይቆባኔ ዮሃኒሳ ቤዒስ። ባንታ ኣዋ ዛብዲዮሳራ ኢሲፌ ዎጎሉዋ ጊዶን ባንታ ጊቲያ ጊጊሴይሳታ ፄጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ኤንቲካ፥ ኤሌሲዲ ባንታ ዎጎሉዋኔ ባንታ ኣዋ ኣጊዲ ዬሱሳ ካሊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","ዬሱሲ ኣይሁዴ ዎሳ ኬꬃታን ታማርሲሼ፥ ሳሎ ካዎቴꬃ ዎንጌላ ኦዲሼኔ ዱማ ዱማ ሃርጊያፌ ኣሳ ፓꬂሼ ጋሊላ ቢታ ኡባን ዩዪስ። ");
INSERT INTO gofENT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","ሄሳፌ ዴንዶይሳን ኢያ ሱንꬃይ ሶሪያ ቢታ ኡባን ኬዪስ። ዱማ ዱማ ሃርጌን ኦይኬቲዳይሳታኔ ዋዬቴይሳታ፥ ቱና ኣያናን ኦይኬቲዳይሳታ፥ ሾጪ ዬጊያ ሃርጌን ኦይኬቲዳይሳታኔ፥ ጉንዳታ ኢያኮ ኤሂዶሶና፤ ኢካ ኤንታና ፓꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","ኣሳይ ጋሊላፔ፥ ታሙ ካታማታፔ፥ ዬሩሳላሜፔ፥ ዪሁዳፔኔ ዮርዳኖሴ ሻፋ ሄፊንꬃን ዴዒያ ቢታፌ ዪዳ ዳሮ ኣሳይ ኢያ ካሊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","ዳሮ ዴሬይ ሺቂዳይሳ ዬሱሲ ቤዒዳ ዎዴ ዴሪያ ቦላ ኬዪዲ ኡቲስ። ኢያ ታማሬቲ ኢያኮ ሺቂን፥ ");
INSERT INTO gofENT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ሃይሳዳ ያጊዲ ታማርሲስ፡ ");
INSERT INTO gofENT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«ባንታ ኣያናን ማንቆቲ ኣንጄቲዳይሳታ፥ ሳሎ ካዎቴꬃይ ኤንታሳ። ");
INSERT INTO gofENT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","ዬኬይሳቲ ኣንጄቲዳይሳታ፥ ኤንቲ ሚንꬄꬆ ዴማና። ");
INSERT INTO gofENT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","ባንታ ዎዛናን ኣሽኬቲ ኣንጄቲዳይሳታ፥ ኤንቲ ሳዓ ላታና። ");
INSERT INTO gofENT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","ፂሎባ ኦꬃናው ኮሻቴይሳቲኔ ሳሞቴይሳቲ ኣንጄቲዳይሳታ፥ ኤንቲ ካላና። ");
INSERT INTO gofENT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","ማሬይሳቲ ኣንጄቲዳይሳታ፥ ኤንቲ ማሮቴꬂ ዴማና። ");
INSERT INTO gofENT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","ዎዛና ጌሻቲ ኣንጄቲዳይሳታ፥ ኤንቲ ፆሳ ቤዓና። ");
INSERT INTO gofENT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","ሲጌꬄይሳቲ ኣንጄቲዳይሳታ፥ ኤንቲ ፆሳ ናይታ ጌቴቲ ፄጌታና። ");
INSERT INTO gofENT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","ፂሎባ ኦꬂያ ጊሾ ጊዲ፥ ጎዴቴይሳቲ ኣንጄቲዳይሳታ፥ ሳሎ ካዎቴꬃይ ኤንታሳ። ");
INSERT INTO gofENT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","«ኣሳይ ሂንቴና ታ ጊሾ ጊዲ ጫያ ዎዴ ጎዲያ ዎዴኔ ሂንቴ ቦላ ኢታባ ኡባ ዎርዶን ኦዲሲያ ዎዴ ሂንቴ ኣንጄቲዳይሳታ። ");
INSERT INTO gofENT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","ሂንቴ ዎይቶይ ሳሎን ጊታ ጊዲያ ጊሾ ኡፋይቲቴ፥ ሃሹ ጊቴ። ሂንቴፌ ካሴ ዴዒያ ናቤታ ሄሳዳ ጎዲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","«ሂንቴ ቢታስ ማፂኔ፤ ማፂኔይ ባ ማፂኔቴꬃ ኣጊኮ፥ ባ ማልዖቴꬃ ዋቲ ዛሪ ዴማኔ? ካሬ ሆሊን ኣሳን ዬꬌታናፔ ኣቲን ኣይቢስካ ማዴና። ");
INSERT INTO gofENT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","«ሂንቴ ቢታስ ፖዖ፤ ዴሬ ቦላ ዴዒያ ካታሚያ ቆሴታናው ዳንዳዑኩ። ");
INSERT INTO gofENT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","ፆምፔ ኦይꬂዲ ሶን ዴዒያ ኣሳ ኡባስ ፖዓና ሜላ ꬎቃ ሶን ዎꬄሲፔ ኣቲን ዳሎ ጊዶን ዎꬄይ ባዋ። ");
INSERT INTO gofENT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","ሄሳ ሜላ ኣሳይ ሂንቴ ሎዖ ኦሱዋ ቤዒዲ፥ ሳሎን ዴዒያ ሂንቴ ኣዋ ቦንቻና ሜላ ሂንቴ ፖዖይ ኣሳ ሲንꬃን ፖዖ። ");
INSERT INTO gofENT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","«ታኒ ሙሴ ሂጊያኔ ናቤታ ቃላ ሻራናው ዪዳ ሂንቴው ዳኖፖ። ታኒ፥ ኤንቲ ኦዲዳይሲ ቱማ ጊዴይሳ ቆንጪሳናው ያሲፔ ኣቲን ሻራናው ያቢኬ። ");
INSERT INTO gofENT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","ታ ሂንቴው ቱማ ኦዳይስ፤ ሳሎይኔ ሳዓይ ኣꬋና ጋካናው ሂጌ ኡባይ ፖሌታናፔ ኣቲን ሂጊያፌ ኢሲ ቃላይ ዎይኮ ፒዳሌይ ኣꬌና። ");
INSERT INTO gofENT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","ሄሳ ጊሾ፥ ሃ ኪታታፔ ጉፂያ ኢሲ ኪታ ሜንꬂያ ኦኒካ ቃሲ ሃራታ ሄሳꬆ ኦꬃና ሜላ ታማርሴይ ኦኒካ ሳሎ ካዎቴꬃን ኡባፌ ጉꬃ ጊዳና። ሺን ሃ ኪታ ፖሌይሲኔ ሃራታካ ፖላና ሜላ ታማርሴይ ሳሎ ካዎቴꬃን ጊታ ጊዳና። ");
INSERT INTO gofENT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","ታ ሂንቴው ኦዳይስ፤ ሂንቴ ፂሎቴꬃይ ፋሪሳዌታ ፂሎቴꬃፌኔ ሂጌ ኣስታማሬታ ፂሎቴꬃፌ ኣꬎና ኢፂኮ፥ ሳሎ ካዎቴꬃ ጌሌኬታ። ");
INSERT INTO gofENT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","«ሂንቴ ማይዛታስ፥ ‹ዎꬎፒቴ፤ ሼምፖ ዎꬊዳ ኦኒካ ፒርዴታና› ጌቴቶይሳ ሲዒዴታ። ");
INSERT INTO gofENT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","ሺን ታ ሂንቴው ኦዳይስ፤ ባ ኢሻ ሃንቄቲያ ኡባይ ፒርዴታና። ባ ኢሻ ጫያ ኦኒካ ዳይና ሲንꬂ ፒርዳስ ሺቃና። ባ ኢሻኮ፥ ‹ኤያይ› ጊያ ኦኒካ ቃሲ ጋናሜ ታማን ፒርዴታና። ");
INSERT INTO gofENT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","«ሄሳ ጊሾ፥ ኔኒ ኔ ያርሹዋ ያርሺያ ዎዴ ኔ ኢሻ ቆሂዳባይ ኔው ኣኬኬቲኮ፥ ");
INSERT INTO gofENT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ኔ ያርሹዋ ሄ ቤሳን ኣጋዳ ባ፤ ኮይሮታ ባዳ ኔ ኢሻራ ጊጋ፤ ያታ ሲማዳ፥ ኔ ያርሹዋ ፆሳስ ያርሻ። ");
INSERT INTO gofENT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","«ኔና ሞቴይሳራ ፒርዳ ኬꬂ ባሼ ኦጌ ቦላ ኢያራ ጊጋ። ሄሲ ኣቶ ጊኮ ኢ ኔና ዳይና ሲንꬂ ኤፋና። ዳይናይ ኔና ቃቼይሳስ ኣꬂ ኢማና፤ ኢ ኔና ዎይኔን ዬጋና። ");
INSERT INTO gofENT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","ታ ቱማ ኦዳይስ፤ ኔ ቦላ ፒርዴቲዳ ኣጩዋ ኢሲ ሳንቲሜይ ኣቶና ጪጋ ኦንጋና ጋካናው ቃሾ ኬꬃፌ ኬያካ። ");
INSERT INTO gofENT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","«ሃይሳፌ ካሴ፥ ‹ላይማቶፒቴ› ጌቴቶይሳ ሲዒዴታ። ");
INSERT INTO gofENT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","ሺን ታ ሂንቴው ኦዳይስ፥ ማጫስ ፄሊዲ፥ ኣሞቲዳ ኡባይ ባ ዎዛናን ኢራ ላይማቴስ። ");
INSERT INTO gofENT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","ኔ ኡሻቻ ኣይፌይ ኔው ናጋራስ ጋሶ ጊዲኮ፥ ኬሳ ሆላ። ኔ ኣሳቴꬃይ ኩሜꬂ ጋናሜ ታማን ዎꬋናፔ ኔ ኣሳቴꬃፌ ኢሶይ ꬋዪኮ ኔው ሎዖ። ");
INSERT INTO gofENT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","ኔ ኡሻቻ ኩሼይ ኔው ናጋራስ ጋሶ ጊዲኮ፥ ኢያ ቃንፃ ሆላ። ኔ ኣሳቴꬃይ ኩሜꬂ ጋናሜ ታማን ዎꬋናፔ ኔ ኣሳቴꬃፌ ኢሶይ ꬋዪኮ፥ ኔው ሎዖ። ");
INSERT INTO gofENT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","« ‹ባ ማቺው ዬዲያ ኦኒካ ኣንጆ ዋርቃቲያ ኢሞ› ጌቴቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","ሺን ታ ሂንቴው ኦዳይስ፤ ባ ማቺያ ላይማቶና ዴዒሺን ቢሊያ ኦኒካ ኢያ ላይማታና ሜላ ኦꬄስ። ሄሳዳካ፥ ኣንጄቲዳ ማጫሲው ኤኪያ ኡባይ ላይማቴስ። ");
INSERT INTO gofENT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","«ሂንቴ ማይዛታኮ፥ ‹ዎርዶን ጫቆፊቴ፤ ሂንቴ ፆሳ ሲንꬃን ጫቂዳይሳ ፖሊቴ› ጌቴቲዳይሳ ሲዒዴታ። ");
INSERT INTO gofENT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","ሺን ታ ሂንቴው ኦዳይስ፤ ኡባራካ ጫቆፊቴ። ፆሳይ ኡቲያ ኣራታ ጊዲያ ጊሾ ሳሎን ጫቆፊቴ። ");
INSERT INTO gofENT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ኢያ ቶሆይ ዬꬊያ ሶ ጊዲያ ጊሾ ሳዓንካ ጫቆፊቴ። ጊታ ካዉዋ ካታማ ጊዲያ ጊሾ ዬሩሳላሜንካ ጫቆፊቴ። ");
INSERT INTO gofENT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","ሂንቴ ቢናናፔ ኢሱዋካ ቦꬂ ዎይኮ ካሬꬂ ኦꬃናው ዳንዳዖና ጊሾ ሂንቴ ሂንቴ ሁዔንካ ጫቆፊቴ። ");
INSERT INTO gofENT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","ሄሳ ጊሾ፥ ሂንቴ ቃላይ፥ ‹ኤ› ዎይኮ ‹ኣካይ› ጊዶ። ሄሳፌ ካሬ ኬዬይ ፃላሄፔ ዬስ። ");
INSERT INTO gofENT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","« ‹ኣይፌ ጊሾ ኣይፌ፤ ኣቻ ጊሾ ኣቼ› ጌቴቲዳይሳ ሲዒዴታ። ");
INSERT INTO gofENT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","ሺን ታ ሂንቴው ኦዳይስ፤ ሂንቴ ቦላ ኢታባ ኦꬂያ ኡራራ ኤቄቶፊቴ። ኦኒካ ኔ ኡሻቻ ሻካላ ባቂኮ ኔ ሃዲርሳ ሻካላካ ቤሳ። ");
INSERT INTO gofENT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","ኢሲ ኣሲ ኔ ሻሚዚያ ኤካናው ኔና ሞቲኮ፥ ኔ ኮቲያ ጉጃዳ ኢማ። ");
INSERT INTO gofENT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","ኢሲ ኣሲ ኔና ዎልቃን ባባ ቶሲዲ ኢሲ ሳቴ ኦጌ ባራ ባና ሜላ ኔና ኡንዔꬂኮ፥ ኢያራ ናምዑ ሳቴ ኦጌ ባ። ");
INSERT INTO gofENT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","ዎሲያ ኦዴስካ ኢማ፤ ኔፔ ታልዓናው ኮያ ኦናካ ዲጎፋ። ");
INSERT INTO gofENT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","« ‹ኔና ዶሴይሳ ዶሳ፤ ኔና ኢፄይሳ ኢፃ› ጌቴቶይሳ ሲዒዴታ። ");
INSERT INTO gofENT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","ሺን ታ ሂንቴው ኦዳይስ፤ ሂንቴ ሞርኬታ ዶሲቴ፤ ሂንቴና ቆሄይሳታስ ዎሲቴ። ");
INSERT INTO gofENT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ሄሳꬆ ሂንቴ ኦꬂኮ፥ ሳሎን ዴዒያ ሂንቴ ኣዋስ ሂንቴ ናይታ ጊዳና። ኢ ኢታታሲኔ ሎዖታስ ኣዋ ኬሴስ፤ ፂሎታሲኔ ናጋራንቾታስ ባ ኢራ ቡኪሴስ። ");
INSERT INTO gofENT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","ሂንቴና ዶሲያ ኣሳ ፃላላ ሂንቴ ዶሲኮ፥ ሂንቴው ኣይ ዎይቶይ ዴዒ? ሃሪ ኣቶሺን፥ ቃራፃ ቃንፂሴይሳቲካ ሄሳ ኦꬆሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","ሂንቴ፥ ሂንቴ ኢሻታ ፃላላ ሳሮꬂኮ፥ ሃራታፔ ኣይ ሃራ ኣꬊያባ ኦꬂዴቲ? ሃሪ ኣቶሺን፥ ፆሳ ኣማኖና ኣሳይካ ሄሳ ኦꬆሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","ሂዛ፥ ሳሎን ዴዒያ ሂንቴ ኣዋይ ፖሎ ጊዶይሳዳ ሂንቴካ ፖሎ ጊዲቴ። ");
INSERT INTO gofENT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","«ኣሲ ቤዖ ጊዲ ሂንቴ ሎዖ ኦሱዋ ኣሳ ሲንꬃን ኦꬆናዳ ናጌቲቴ። ሄሳꬆ ሃኖና ኢፂኮ ሳሎን ዴዒያ ሂንቴ ኣዋፔ ዎይቶ ዴሜኬታ። ");
INSERT INTO gofENT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","«ሂንቴ ማንቆታስ ኢሚያ ዎዴ ኣሳ ሲንꬃን ቦንቼታናው ጊዲ ጩቦቲ ኦጊያ ዶናኒኔ ኣይሁዴ ዎሳ ኬꬃታን ኦꬄይሳዳ ኣሲ ቤዖ ጊዲ ኦꬆፊቴ። ታ ሂንቴው ቱማ ኦዳይስ፤ ኤንቲ ባንታ ኩሜꬃ ዎይቱዋ ኤኪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","ሺን ሂንቴ ማንቆታስ ኢሚያ ዎዴ ሂንቴ ኡሻቻ ኩሼይ ኦꬄይሳ ሂንቴ ሃዲርሳ ኩሼይ ኤሮፖ፤ ");
INSERT INTO gofENT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ሂንቴ ኢሞይ ጌማን ጊዶ። ጌማን ኦꬄይሳ ቤዒያ ሂንቴ ኣዋይ ሂንቴው ዎይቱዋ ቆንጬን ኢማና። ");
INSERT INTO gofENT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","«ዎሳ ዎሲሼ ጩቦታꬆ ሃኖፒቴ። ኤንቲ፥ ባንታና ኣሲ ቤዖ ጊዲ ኣይሁዴ ዎሳ ኬꬃኒኔ ኦጊያ ዶናን ኤቂዲ ዎሴይሳ ዶሶሶና። ታ ሂንቴው ቱማ ኦዳይስ፤ ኤንቲ ባንታ ኩሜꬃ ዎይቱዋ ኤኪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","ሺን ኔኒ ዎሲያ ዎዴ ኔ ሶ ጌላ፥ ዉላ ጎርዳዳ ጌማን ዴዒያ ኔ ኣዋኮ ዎሳ፤ ጌማን ኦሴቲዳይሳ ቤዒያ ኔ ኣዋይ ኔው ዎይቱዋ ኢማና። ");
INSERT INTO gofENT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","ሂንቴ ዎሲያ ዎዴ ኣማኖና ኣሳꬆ ጮ ቃላ ዳርሲዲ ዎሶፊቴ። ኤንቲ ኣዱሲ ዎሲን ፆሳይ ሲዔስ ጊዲ ቆፖሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","ሄሳ ጊሾ፥ ኤንታይሳዳ ሃኖፒቴ። ኣይስ ጊኮ፥ ሂንቴ ኣዋይ ሂንቴው ኣይ ኮሺያኮ ሂንቴ ዎሳናፔ ሲንꬃቲዲ ኤሬስ። ");
INSERT INTO gofENT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","«ሂዛ፥ ሂንቴ ያጊዲ ዎሲቴ፡ ‹ሳሎን ዴዒያ ኑ ኣዋው፥ ኔ ጌሻ ሱንꬃይ ኣንጄቶ። ");
INSERT INTO gofENT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","ኔ ካዎቴꬃይ ዮ፥ ኔ ሼኔይ ሳሎን ሃኒዳይሳዳ ሳዓንካ ሃኖ። ");
INSERT INTO gofENT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","ጋላሳ ካꬃ ሃቺ ሃቺ ኑስ ኢማ። ");
INSERT INTO gofENT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","ኑኒ ኑና ቆሂዳይሳታ፥ ኣቶ ጌይሳዳ፥ ኑስካ ኑ ቆሁዋ ኣቶ ጋ። ");
INSERT INTO gofENT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","ኑና ኢታፔ ኣሻፌ ኣቲን ፓጬን ጌልሶፋ። ካዎቴꬃይ፥ ዎልቃይኔ ቦንቾይ ሜሪናው ኔሳ። ኣሚንዒ።› ");
INSERT INTO gofENT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","«ሂንቴ ሂንቴና ቆሂዳይሳታ ኣቶ ጊኮ፥ ሳሎን ዴዒያ ሂንቴ ኣዋይ ሂንቴ ቆሁዋካ ኣቶ ጋና። ");
INSERT INTO gofENT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","ሺን ሂንቴ ሃራ ኣሳ ናጋራ ኣቶ ጎና ኢፂኮ ሂንቴ ኣዋይ ሂንቴ ናጋራ ኣቶ ጌና። ");
INSERT INTO gofENT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","«ሂንቴ ፆሚያ ዎዴ ጩቦታꬆ ካዮቶፊቴ። ኣይስ ጊኮ፥ ኤንቲ ፆሜይሳ ኣሲ ኤራና ሜላ ባንታ ሶምዑዋ ቂታዮሶና። ታ ቱማ ኦዳይስ፤ ኤንቲ ባንታ ዎይቱዋ ኤኪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","«ሺን ኔኒ ፆሚያ ዎዴ ኔ ሶምዑዋ ሜጫ፥ ኔ ሁዒያ ቲዬታ። ");
INSERT INTO gofENT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ሄሳዳ ኔ ኦꬂኮ ኔ ፆሚያ ፆማይ ኣሳፔ ጌሚዳይሳ፥ ሺን ጌማን ዴዒያ ኔ ኣዋይ ኤሪያ ፆማ ጊዳና። ጌማን ኦሴቲዳይሳ ቤዒያ ኔ ኣዋይ ኔው ዎይቱዋ ኢማና። ");
INSERT INTO gofENT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","«ቢሊ ሚያሶን፥ ቢራቲ ሺዒያሶን፥ ካይሶይ ቦኪዲ ኤኪያሶን፥ ሃ ሳዓን፥ ሂንቴው ሻሎ ሺሾፒቴ። ");
INSERT INTO gofENT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","ሺን ቢሊ ሞናሶን፥ ቢራቲ ሺዖናሶን፥ ካይሶይ ቦኪዲ ኤኮናሶን ሳሎን ሂንቴው ሻሎ ሺሺቴ። ");
INSERT INTO gofENT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","ኔ ሻሎይ ዴዒያሱዋን ኔ ዎዛናይ ዴዓና። ");
INSERT INTO gofENT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","«ኣይፌይ ኣሳቴꬃስ ፆምፔ። ሄሳ ጊሾ፥ ኔ ኣይፌይ ፓፃ ጊዲኮ ኔ ኩሜꬃ ኣሳቴꬃይ ፖዖ ጊዴስ። ");
INSERT INTO gofENT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","ኔ ኣይፌይ ሃርጋንቾ ጊዲኮ ኔ ኩሜꬃ ኣሳቴꬃይ ꬉማ ጊዴስ። ሂዛ፥ ኔናን ዴዒያ ፖዖይ ꬉማ ጊዲኮ፥ ꬉማይ ኣይ ሜላ ኣꬊዲ ꬉማንዴሻ! ");
INSERT INTO gofENT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","«ኢሲ ኣሲ ናምዑ ጎዳስ ሃሬታናው ዳንዳዔና። ኢሱዋ ዶሲኮ ሃንኩዋ ኢፄስ፤ ዎይኮ ኢሱዋ ቦንቺኮ ሃንኩዋ ካꬌስ። ፆሳሲኔ ሚሼስ ሃሬታናው ዳንዳዔኬታ። ");
INSERT INTO gofENT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","«ሂዛ፥ ሲዒቴ! ሂንቴ ዴዖን ዳናው፥ ‹ኣይ ማኔ? ኣይ ኡያኔ? ኣይ ማዓኔ?› ጊዲ ኡንዔቶፊቴ፤ ዴዖይ ካꬃፌ ዎይኮ ማዖፔ ኣꬌኔ? ");
INSERT INTO gofENT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","ሳሎ ካፎታ ፄሊቴ፤ ኤንቲ ዜሮኮና፥ ቡጮኮና፥ ሻሌን ዬጎኮና፥ ሺን ሂንቴ ሳሎ ኣዋይ ኤንታ ሙዜስ። ሂንቴ ኤንታፌ ኬሂ ኣꬌኬቲ? ");
INSERT INTO gofENT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","ሂንቴ ጊዶፌ ዳሮ ኡንዔቲዲ ባ ላይꬃ ቦላ ኢሲ ጋላስ ጉጃናው ዳንዳዔይ ዴዒ? ");
INSERT INTO gofENT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","«ቃሲ ሂንቴ ማዒያባስ ኣይስ ኡንዔቴቲ? ኣኔ ጪሻታ ቤዒቴ፥ ኦሶን ዳቡሮኮና ዎይኮ ሱቆኮና። ");
INSERT INTO gofENT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","ሲዒቴ! ሃሪ ኣቶሺን፥ ካዉዋ ሶሎሞኔይ ባ ቦንቾ ኡባን ሃ ጪሻታፔ ኢሱዋ ሜላካ ማዒቤና። ");
INSERT INTO gofENT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","ሂንቴኖ፥ ኣማኖይ ፓጪዳይሳቶ፥ ፆሳይ ሃቺ ቤንቲዲ ዎንቶ ታማን ዎꬋናው ዴዒያ ማታ ያቲዲ ማይዚያባ ጊዲኮ፥ ሂንቴና ኤንታፌ ኣꬂዲ ዋቲ ማይዜኔ? ");
INSERT INTO gofENT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","ሄሳ ጊሾ፥ ‹ኣይ ማኔ? ኣይ ኡያኔ? ኣይ ማዓኔ?› ጊዲ ኡንዔቶፊቴ። ");
INSERT INTO gofENT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","ሄ ኡባ ፆሳ ኣማኖና ኣሳይ ዳርሲዲ ዴማናው ኡንዔቶሶና። ሂንቴ ሳሎ ኣዋይ ሄ ኡባይ ሂንቴው ኮሼይሳ ኤሬስ። ");
INSERT INTO gofENT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","ሺን ኡባፌ ሲንꬄ ፆሳ ካዎቴꬃኔ ኢያ ፂሎቴꬃ ኮዪቴ፤ ሄ ኡባይ ሂንቴው ጉጂ ኢሜታና። ");
INSERT INTO gofENT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","ሄሳ ጊሾ፥ ዎንቶስ ቆፒሼ ኡንዔቶፊቴ። ዎንቶይሲ ዎንቶስ ኣቆ፤ ኢሲ ኢሲ ጋላሳይ ባው ጊዲያ ሜቶራ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","«ሂንቴ ቦላ ፒርዴቶና ሜላ ሃራታ ቦላ ፒርዶፊቴ። ");
INSERT INTO gofENT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","ኣይስ ጊኮ፥ ሃራታ ቦላ ሂንቴ ፒርዴይሳዳ ሂንቴ ቦላ ፒርዴታና፤ ሂንቴ ሃራታስ ማኪዳባን ሂንቴው ዛሪ ማኬታና። ");
INSERT INTO gofENT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","ኔ ኣይፌን ዴዒያ ቱሱ ዳኔይሳ ቤዖና ኔ ኢሻ ኣይፌን ዴዒያ ቡሪያ ኣይስ ቤዓይ? ");
INSERT INTO gofENT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","ኔ ኣይፌን ቱሲ ዴዒሺን ኔ ኢሻ ኣይፌን ዴዒያ ቡሪያ ኬሶ ጋናው ዋና ዳንዳዓይ? ");
INSERT INTO gofENT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","ኔኖ ጩቡዋው፥ ኮይሮታዳ ኔ ኣይፌን ዴዒያ ቱሲ ዳኔይሳ ኬሳ። ኢያፔ ጉዬ፥ ኔ ኢሻ ኣይፌን ዴዒያ ቡሪያ ኬሳናው ኔ ጌሻ ፄላና። ");
INSERT INTO gofENT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","«ጉዬ ሲሚዲ ሂንቴና ሳፆና ሜላ ጌሻባ ካናታስ ዬጎፊቴ። ባንታ ቶሁዋን ዬꬊዲ ኢሶና ሜላ ሂንቴ ኣልዖ ኢንቁዋ ጉዱንꬆታ ሲንꬃን ዬጎፊቴ። ");
INSERT INTO gofENT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","«ዎሲቴ ሂንቴው ኢሜታና፥ ኮዪቴ ሂንቴ ዴማና፥ ካሬ ዪዲ ፄጊቴ ሂንቴው ዶዬታና። ");
INSERT INTO gofENT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","ዎሲያ ኦዴስካ ኢሜታና፥ ኮያ ኦዴስካ ቤንታና፥ ካሬ ዪዲ ፄጊያ ኦዴስካ ዶዬታና። ");
INSERT INTO gofENT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","«ሂንቴ ጊዶፌ ባ ናዒ ኡይꬂ ዎሲኮ ሹቺ ኢሜይ ኦኔ? ");
INSERT INTO gofENT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","ዎይኮ ሞሎ ዎሲኮ ሾሺ ኢሜይ ዴዒ? ");
INSERT INTO gofENT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","ያቲን ሂንቴ ኢታ ጊዲሼ ሂንቴ ናይታስ ሎዖባ ኢሞ ኤሪኮ፥ ሂንቴ ሳሎ ኣዋይ ባና ዎሴይሳታስ ሎዖባ ዋቲ ዳርሲዲ ኢሜኔ? ");
INSERT INTO gofENT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","ሃራቲ ሂንቴው ኦꬃና ሜላ ሂንቴ ኮያባ ኡባ ሂንቴካ ሃራታስ ኦꬂቴ። ኣይስ ጊኮ፥ ሙሴ ሂጌይኔ ናቤቲ ታማርሴይ ሃይሳ። ");
INSERT INTO gofENT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","«ፁንꬃ ዉላራ ጌሊቴ፤ ኣይስ ጊኮ፥ ꬋዮስ ኤፊያ ኦጌይ ዎጋ፥ ዉላይካ ዳልጋ። ኢያራ ጌሊያ ኣሳይካ ዳሮ። ");
INSERT INTO gofENT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","ሺን ዴዑዋኮ ኤፊያ ኦጌይኔ ዉላይ ፁንꬁ፤ ያ ጌሊያ ኣሳይካ ጉꬃ። ");
INSERT INTO gofENT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","«ቦላ ባጋራ ዶርሴ ዳኒዲ ባንታ ጋꬃን ሱꬉሜ ጊዲዲ ሂንቴ ጊዶ ጌሊያ ዎርዳንቾ ናቤታፔ ናጌቲቴ። ");
INSERT INTO gofENT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","ሂንቴ ኤንታ፥ ኤንታ ኣይፊያፔ ኤራና፤ ኣጉንꬃፌ ዎይኔይ፥ ኪንቾቴፔ ላዴይ ማፄቴና። ");
INSERT INTO gofENT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","ሄሳ ሜላ ሎዖ ሚꬂ ኡባይ ሎዖ ኣይፌ ኣይፌስ፤ ኢታ ሚꬂ ኢታ ኣይፌ ኣይፌስ። ");
INSERT INTO gofENT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","ሎዖ ሚꬂ ኢታ ኣይፌ ኣይፌና፥ ቃሲ ኢታ ሚꬂ ሎዖ ኣይፌ ኣይፋናው ዳንዳዔና። ");
INSERT INTO gofENT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","ሎዖ ኣይፌ ኣይፎና ሚꬂ ኡባይ ቃንፄቲዲ ታማን ፁጌታና። ");
INSERT INTO gofENT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","ሄሳ ጊሾ፥ ሂንቴ ኤንታ፥ ኤንታ ኣይፊያን ኤራና። ");
INSERT INTO gofENT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","«ሳሎን ዴዒያ ታ ኣዋ ሼኒያ ኦꬂያ ኡራይ ሳሎ ካዎቴꬂ ጌላናፔ ኣቲን ጮ ታና ‹ጎዳው፥ ጎዳው› ጊያ ኡባይ ሳሎ ካዎቴꬂ ጌሌና። ");
INSERT INTO gofENT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","ፒርዳ ጋላስ ዳሮቲ፥ ‹ጎዳው፥ ጎዳው፥ ኔ ሱንꬃን ቲንቢቴ ኦዲቦኮ? ኔ ሱንꬃን ቱና ኣያናታ ኬሲቦኮ? ኔ ሱንꬃን ማላታታ ኦꬂቦኮ?› ያጋና። ");
INSERT INTO gofENT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","ሄ ዎዴ ታኒ፥ ‹ታ ሂንቴና ኡባራካ ኤሪኬ፥ ሂንቴ ኢታ ኦꬄይሳቲ ታፔ ሃኪቴ› ያጋና። ");
INSERT INTO gofENT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","«ሂዛ፥ ሃ ታ ቃላ ሲዒዲ ኦꬂያ ኦኒካ ባ ኬꬃ ሹቻ ቦላ ኬፂዳ ዎዛናማ ኣሳ ሜላ። ");
INSERT INTO gofENT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","ኢራይ ቡኪስ፥ ዲዖይ ዲዒስ፥ ጫርኮይካ ጫርኪዲ ሄ ኬꬃ ሱጊስ። ሺን ኬꬃይ ሹቻ ባሶ ቦላ ኬፄቲዳ ጊሾ ኩንዲቤና። ");
INSERT INTO gofENT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","ሃ ታ ቃላ ሲዒዲ ኦꬆና ኦኒካ ባ ኬꬃ ሻፌ ቦላ ኬፂዳ ኤያ ኡራ ሜላ። ");
INSERT INTO gofENT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","ኢራይ ቡኪዲ፥ ዲዖይ ዲዒዲ፥ ጫርኮይካ ጫርኪዲ፥ ሄ ኬꬃ ሱጊን፥ ሄ ኬꬃይ ኩንዲስ፤ ኢያ ኩንዴꬃይካ ዎልቃማ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","ዬሱሲ ባ ኦዳ ኦንጊዳ ዎዴ ኢያ ቲሚርቴይ ሂጌ ኣስታማሬታ ሜላ ጊዶና ማታራ ጊዲያ ጊሾ ኣሳይ ኢያ ቲሚርቲያን ማላሌቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","ዬሱሲ ዴሪያፔ ዎꬊያ ዎዴ ዳሮ ኣሳይ ኢያ ካሊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","ሄኮ ኢሲ ባሮ ሃርጋንቾይ ኢያኮ ሺቂዲ፥ ኢያ ሲንꬃን ጉልባቲዲ፥ «ጎዳው፥ ኔ ሼኔ ጊዲኮ ታና ጌሻዳ ፓꬃናው ዳንዳዓሳ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","ዬሱሲ ባ ኩሺያ ዬዲዲ ኢያ ቦቺዲ፥ «ኤ፥ ታ ሼኔ፥ ፓፃ» ያጊስ። ኡራይ ኢራካ ጌዪ ኣጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","ዬሱሲ ኢያኮ፥ «ኔ ፓፁዋ ኦዴስካ ኦዶፓ። ሺን ባዳ ኔ ጌያዳ ፓፆይሳ ካሂኔ ቤሳ። ኔ ፓፁዋስ ማርካ ጊዳና ሜላ ባዳ ሙሴይ ኪቲዳ ያርሹዋ ያርሻ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","ዬሱሲ ቂፊርናሆሜ ካታማ ጋኪዳ ዎዴ ኢሲ ማቶ ሃላቃይ ኢያኮ ሺቂዲ፥ ");
INSERT INTO gofENT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","«ጎዳው፥ ታ ኣይሌይ ኣሳቴꬃይ ጉንዲን ዳሮ ሃርጌቲዲ፥ ሶን ዚንዒዲ ዴዔስ» ያጊዲ ዎሲስ። ");
INSERT INTO gofENT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","ዬሱሲ ዛሪዲ፥ «ታኒ ባዳ ኢያ ፓꬃና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","ሺን ማቶ ሃላቃይ ዛሪዲ፥ «ጎዳው፥ ኔ ታ ሶ ጌላናው ቤሲያ ኣሲ ጊዲኬ፥ ሺን ኔ ሃን ኡታዳ ቃላ ፃላላ ኦዳ፥ ታ ኣይሌይ ፓፃና። ");
INSERT INTO gofENT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","ኣይስ ጊኮ፥ ታፔ ቦላራ ታ ኪቴቲያ ኣሳቲ ዴዖሶና፥ ቃሲ ታፔ ጋርሳራ ታው ኪቴቴይሳቲ ዴዖሶና። ኤንታፌ ኢሱዋ፥ ‹ባ› ጊያዴ ቤስ፤ ሃንኩዋ ቃሲ ‹ሃያ!› ጊያዴ ዬስ። ታ ኣይሊያ፥ ‹ሃይሳ ኦꬃ› ጊያዴ ኦꬄስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","ዬሱሲ ሄሳ ሲዒዳ ዎዴ ማላሌቲዲ፥ ባና ካሊያ ኣሳኮ፥ «ታ ሂንቴው ቱማ ኦዳይስ፤ ታኒ ሃይሳ ሜላ ኣማኖ ኢስራዔሌ ኣሳንካ ቤዓቢኬ። ");
INSERT INTO gofENT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","ታ ሂንቴው ኦዳይስ፤ ዳሮቲ ዶሎሃፔኔ ዉሎሃፔ ዪዲ፥ ሳሎ ካዎቴꬃን ኣብራሃሜራ፥ ዪሳቃራኔ ያይቆባራ ኢሲፌ ኢማቶ ቦላ ኡታና። ");
INSERT INTO gofENT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","ሺን ሳሎ ካዎቴꬃ ላታናው ቤሲሺን ኣቲዳይሳቲ ካሬ ꬉማን ሆሌታና። ያን ኤንታው ዬሆኔ ኣቻ ጋርጬꬂ ጊዳና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","ዬሱሲ ማቶ ሃላቃኮ፥ «ኔ ሶ ባ፥ ኔ ኣማኑዋꬆ ኔው ሃኖ» ያጊስ። ኢያ ኣይሌይ ሶሁዋራ ፓፂ ኣጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","ዬሱሲ ጴፂሮሳ ሶ ጌሊያ ዎዴ ጴፂሮሳ ማቼ ኣያ ቆፆ ሚሻ ሃርጌን ሳኬታዳ ዚንዒዳሮ ቤዒስ። ");
INSERT INTO gofENT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","ዬሱሲ ኢ ኩሺያ ቦቺዳ ዎዴ ቆፆይኔ ሚሻይ ኣጊ ኣጊስ። ፓፃ ዴንዳዳ ኢያ ሞካሱ። ");
INSERT INTO gofENT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","ሄ ዎዴ ኦማርሲ ቱና ኣያናን ኦይኬቲዳ ዳሮ ኣሳታ፥ ኣሳይ ዬሱሳኮ ኤሂዶሶና። ኢካ ቱና ኣያናታ ባ ቃላን ኬሲስ፥ ሃርጋንቾታ ኡባ ፓꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","ሄሳንካ ናቢያ ኢሳያሲ፥ «ኢ ኑ ሃርጊያ ባው ኤኪስ፥ ኢ ኑ ሃርጊያ ቶኪስ» ጊዳ ቃላይ ፖሌቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","ዬሱሲ ዳሮ ኣሳይ ኢያ ዩሹዋን ኤቂዳይሳ ቤዒዲ፥ ኣባፌ ሄፊንꬂ ፒናና ሜላ ባ ታማሬታ ኪቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","ሂጌ ኣስታማሬታፔ ኢሶይ፥ «ኣስታማሪያው፥ ኔ ቢያሶ ኡባ ታ ካላና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","ዬሱሲ ኢያኮ «ዎርካናታስ ኦሊ ዴዔስ፥ ሳሎ ካፎታስ ኬꬂ ዴዔስ። ሺን ኣሳ ናዓስ ባ ሁዒያ ሼምፒሲያ ቤሲ ባዋ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","ዬሱሳ ካሊያ ኣሳታፔ ኢሶይ፥ «ጎዳው፥ ታኒ ሲንꬃታ ባዳ ታ ኣዋ ሞጋዳ ያና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","ሺን ዬሱሲ፥ «ሃይቂዳይሳቲ ባንታ ሃይቆታ ሞጎ፤ ኔኒ ታና ካላ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","ዬሱሲ ባናው ዎጎሉዋን ጌሊዳ ዎዴ ኢያ ታማሬቲካ ኢያራ ባናው ጌሊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","ኤንቲ ቆፖና ዴዒሺን፥ ዎልቃማ ሆቤይ ሃꬃ ቦላ ዴንዲን ዎጎሎይ ሚቴታናው ጋኪስ። ሺን ዬሱሲ ꬊስኪስ። ");
INSERT INTO gofENT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","ኢያ ታማሬቲ ኢያኮ ሺቂዲ ኢያ ባርኬꬂዲ፥ «ጎዳው፥ ኑ ꬋዮስ ኑና ኣሻርኪ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","ዬሱሲ ኤንታኮ፥ «ሂንቴኖ፥ ኣማኖይ ፓጪዳይሳቶ፥ ኣይስ ያዬቲ?» ያጊስ። ዴንዲዲ፥ ሆቢያኔ ጎቲያ ኤሲስ። ኤሌሲዲ ኡባባይ ሲዒ ጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","ኢያ ታማሬቲ ማላሌቲዲ፥ «ሃይሲ፥ ሃሪ ኣቶሺን፥ ሆቤይኔ ጎቴይ ኪቴቴይሲ ዋኒዳ ኣሴ?» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","ዬሱሲ ኣባፌ ሄፊንꬃን ዴዒያ ጌርጌሶኔ ጊያ ቢታ ጋኪዳ ዎዴ ቱና ኣያናይ ኦይኪዳ ናምዑ ኣሳቲ ዱፎፔ ኬዪዲ ኢያራ ጋሄቲዶሶና። ኤንቲ ዳሮ ኢታኔ ያሺያ ኣሳታ ጊዲያ ጊሾ ኣሲ ሄ ቤሳራ ኣꬋናው ዳንዳዔና። ");
INSERT INTO gofENT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","ኤንቲካ፥ «ፆሳ ናዓው፥ ኑናኔ ኔና ኣይቤ ጋꬄይ? ዎዴይ ጋኮና ዴዒሺን ኑና ፒርዳናው ያዲ?» ጊዲ ዋሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","ኤንታፌ ዳሮ ሃኮና ጉዱንꬆ ዉዴይ ሄሜቴስ። ");
INSERT INTO gofENT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","ቱና ኣያናቲ ዬሱሳ፥ «ኔ ኑና ኬሳናባ ጊዲኮ፥ ሂኒ ጉዱንꬆ ዉዲያ ጊዶ ዬዳርኪ» ያጊዲ ዎሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","ዬሱሲ፥ «ቢቴ» ያጊስ። ቱና ኣያናቲ ኣሳታፔ ኬዪዲ ጉዱንꬆታን ጌሊዶሶና። ጉዱንꬆቲ ኡባይ ኣፎ ዶናራ ዲርጊዲ ቢዲ ኣባን ሚቴቲዲ ሃይቂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","ጉዱንꬆ ዉዲያ ሄሜይሳቲ ባቃቲዲ ካታማ ቢዲ፥ ሃኒዳባኔ ቱና ኣያናይ ኦይኪዳ ኣሳታ ቦላ ኦሴቲዳባ ኡባ ኦዲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","ያቲን፥ ካታማን ዴዒያ ኣሳ ኡባይ ዬሱሳ ቤዓናው ኬዪዶሶና። ኤንቲ ዬሱሳ ቤዒዳ ዎዴ ባንታ ቢታፌ ኬዪዲ ባና ሜላ ዎሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","ሄሳፌ ጉዬ፥ ዬሱሲ ዎጎሉዋን ጌሊዲ፥ ኣባ ፒኒዲ ባ ካታማ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","ሃኒዳ ጉꬃ ኣሳቲ ኢሲ ጉንዳ ኡራ ኣልጋራ ቶኪዲ ዬሱሳኮ ኤሂዶሶና። ዬሱሲ ኤንታ ኣማኑዋ ቤዒዲ፥ ጉንዳ ኡራ፥ «ታ ናዓው፥ ያዮፋ! ኔ ናጋራይ ኣቶ ጌቴቲስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","ሄ ሳቲያን፥ ኣይሁዴ ሂጌ ኣስታማሬታፔ ኢሶቲ ኢሶቲ፥ «ሃይሲ ፆሳ ጫሼ ጊዴኔ» ያጊዲ ባንታ ዎዛናን ቆፒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","ዬሱሲ ኤንታ ቆፋ ኤሪዲ፥ «ኢታባ ሂንቴ ዎዛናን ኣይስ ቆፔቲ? ");
INSERT INTO gofENT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","ሃኖሺን፥ ‹ኔ ናጋራይ ኣቶ ጌቴቲስ› ጌይሳፌኔ ‹ዴንዳ ኤቃዳ ባ› ጌይሳፌ ኣዉሲ ካዉዪ? ");
INSERT INTO gofENT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","ሺን ሳዓ ቦላ ናጋራ ኣቶ ጋናው ኣሳ ናዓስ ማቲ ዴዔይሳ ታ ሂንቴና ኤሪሳና» ያጊዲ፥ ጉንዳ ኣዲያኮ፥ «ዴንዳ ኤቃ፥ ኔ ኣልጋ ቶካዳ፥ ኔ ሶ ባ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","ጉንዳ ኡራይ ዴንዲዲ ባ ሶ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","ዴሬይ ሄሳ ቤዒዲ ማላሌቲዶሶና። ሄሳ ሜላ ማታ ኣሳስ ኢሚዳ ፆሳ ጋላቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","ዬሱሲ ያፔ ዴንዲዲ ቢሼ ማቶሳ ጌይሳ ቃራፃ ቃንፂሲያ ቤሳን ኡቲዳሺን ቤዒዲ፥ «ታና ካላ» ያጊስ። ኢካ ዴንዲዲ ካሊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","ዬሱሲ ማቶሳ ሶን ጋይታ ቦላ ኡቲዳሺን፥ ቃራፃ ቃንፂሲያ ዳሮ ኣሳቲኔ ናጋራንቾቲ ዪዲ ኢያራኔ ኢያ ታማሬታራ ኢሲፌ ማናው ኡቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","ኢሲ ኢሲ ፋሪሳዌቲ ሄሳ ቤዒዲ፥ ዬሱሳ ታማሬታ፥ «ሂንቴ ኣስታማሬይ ቃራፃ ቃንፂሴይሳታራኔ ናጋራንቾታራ ኣይስ ሚ?» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","ዬሱሲ ሄሳ ሲዒዲ፥ «ꬋሌ ኮሼይ ሃራጋንቾታሳፌ ኣቲን ፓፃታሳ ጊዴና። ");
INSERT INTO gofENT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","ሺን ሂንቴ ቢዲ፥ ‹ታኒ ሂንቴ ያርሹዋ ጊዶናሺን ሂንቴ ሃራታ ማራና ሜላ ኮያይስ› ጌቴቲዲ ፃፌቲዳይሲ ዎይ ጉሴኮ ኤሪቴ። ኣይስ ጊኮ፥ ታኒ ናጋራንቾታ ፄጋናው ያሲፔ ኣቲን ፂሎታ ፄጋናው ያቢኬ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","ሄ ዎዴ ዮሃኒሳ ታማሬቲ ዬሱሳኮ ሺቂዲ፥ «ኑኔ ፋሪሳዌቲ ፆሞስ፥ ሺን ኔ ታማሬቲ ኣይስ ፆሞኮና?» ያጊዲ ኦይቺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","ዬሱሲ ዛሪዲ ኤንታኮ፥ «ሙሹራይ ኤንታራ ዴዒሺን ፄጌቲዲ ዪዳ ኣሳይ ካዮታናው ዳንዳዖና? ሙሹራይ ኤንታ ማታፔ ኤኬታና ዎዴይ ያና፥ ኤንቲ ሄ ዎዴ ፆማና። ");
INSERT INTO gofENT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","«ኦራꬃ ማዖፔ ፔꬊዲ ጋልዓ ማዖ ቦላ ሲኬይ ኦኒካ ባዋ። ሄሳꬆ ኦꬂኮ ኦራꬃይ ጋልዓ ፔꬌስ። ፔꬌꬃይካ ጉጂ ዳልጌስ። ");
INSERT INTO gofENT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","ኦራꬃ ዎይኔ ጋልዓ ኦጎሮን ቆሊያ ኦኒካ ባዋ። ሄሳꬆ ኦꬂኮ ኦራꬃ ዎይኔይ ጋልዓ ኦጎሩዋ ꬉሴስ ዎይኔይካ ጉኬስ፤ ኦጎሮይካ ናምዓንꬆ ማዶናባ ጊዴስ። ሺን ኦራꬃ ዎይኔይ ኦራꬃ ኦጎሮን ቆሌታናው ቤሴስ። ሄሳꬆ ኦሴቲኮ ናምዓይካ ኢቶና ናጌቶሶና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","ዬሱሲ ሄሳ ኦዶ ቦላ ዴዒሺን፥ ኣይሁዴ ሃላቃታፔ ኢሶይ ኢያኮ ዪዲ፥ ኢያ ሲንꬃን ጉልባቲዲ፥ «ታ ናዒያ ሃዒ ሃይቃሱ፥ ሺን ኢያ ፓፃና ሜላ ኔኒ ያዳ ኔ ኩሺያ ኢ ቦላ ዎꬃርኪ» ጊዲ ዎሲስ። ");
INSERT INTO gofENT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","ዬሱሲ ዴንዲዲ ኢያራ ቢስ፤ ኢያ ታማሬቲካ ካሊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","ኢ ቢሺን ታማኔ ናምዑ ላይꬂ ኩሜꬂ ሱꬂ ጎጊዲ ዋይሲያ ኢሲ ማጫሲያ ጉዬራ ሺቃዳ ዬሱሳ ኣፊላ ማጫራ ቦቻሱ። ");
INSERT INTO gofENT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","ኢያ ባ ዎዛናን፥ «ታ ኢያ ኣፊላ ማጫራ ፃላላ ቦቺያኮ ፓፃና» ያጋዳ ቆፓሱ። ");
INSERT INTO gofENT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","ዬሱሲ ጉዬ ሲሚ ኢዮ ፄሊዲ፥ «ታ ናቴ፥ ያዮፋ! ኔና ኔ ኣማኖይ ፓꬂስ» ያጊስ። ማጫሲያ ሶሁዋራ ፓፃ ኣጋሱ። ");
INSERT INTO gofENT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","ዬሱሲ ኣይሁዴ ሃላቃ ሶ ጋኪያ ዎዴ ዛዬ ፑኔይሳታኔ ዬኬይሳታ ቤዒዲ፥ ");
INSERT INTO gofENT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","«ኣኔ ኪቺቴ፤ ጉꬃ ናዒያ ꬊስካሱፔ ኣቲን ሃይቃቡኩ» ያጊስ። ሺን ኣሳይ ኢያ ቦላ ሚጪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","ኣሳ ካሬ ኬሲዳፔ ጉዬ ሶ ጌሊዲ፥ ናዔ ኩሺያ ኦይኪስ፥ ናዒያ ዴንዳ ኤቃሱ። ");
INSERT INTO gofENT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","ሄ ዎሬይ ሄ ቢታ ኡባ ጋኪስ። ");
INSERT INTO gofENT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","ዬሱሲ ያፔ ዴንዲዲ ጌዴ ሲንꬄ ቢያ ዎዴ ናምዑ ቆቄቲ ባንታ ቃላ ꬎቁ ኦꬂዲ፥ «ዳዊቴ ናዓው፥ ኑና ማራርኪ» ያጊሼ ኢያ ካሊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","ዬሱሲ ሶ ጌሊዳ ዎዴ ቆቄቲ ኢያ ካሊዲ ዪዶሶና። ዬሱሲ ኤንታኮ፥ «ታኒ ሄሳ ኦꬃናው ዳንዳዔይሳ ሂንቴ ኣማኔቲ?» ያጊስ። ኤንቲካ፥ «ኤ፥ ጎዳው» ያጊዲ ዛሪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","ሄሳፌ ጉዬ፥ ዬሱሲ ኤንታ ኣይፊያ ቦቺዲ ኤንታኮ፥ «ሂንቴው፥ ሂንቴ ኣማኑዋꬆ ሃኖ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","ኤንታ ኣይፌይካ ዶዬቲስ። ዬሱሲ ኤንታኮ፥ «ሃይሳ ኦዴስካ ኦዶፒቴ» ያጊዲ ሚንꬂ ኦዲስ። ");
INSERT INTO gofENT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","ሺን ኣሳቲ ቢዲ ዬሱሳባ ሄ ቢታ ኡባን ኦዲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","ኤንቲ ያፔ ኬያ ዎዴ ኣሳይ ቱና ኣያናይ ኦይኪዲ ሙሚሲዳ ኢሲ ኣሲ ዬሱሳኮ ኤሂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","ቱና ኣያናይ ኬዪዳፔ ጉዬ ሙሜ ኡራይ ኦዴቲስ። ዴሬይካ ማላሌቲዲ፥ «ሃይሳ ሜላ ኦራꬃባይ ኢስራዔሌ ቢታን ሃኒቤና» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","ሺን ፋሪሳዌቲ፥ «ቱና ኣያናታ ሃላቃን ቱና ኣያናታ ኬሴስ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","ዬሱሲ ኣይሁዴ ዎሳ ኬꬃታን ታማርሲሼ፥ ሳሎ ካዎቴꬃ ዎንጌላ ሳባኪሼ፥ ኣሳ ሃርጌ ኡባፌ ፓꬂሼ ካታማታኒኔ ጉታ ኡባን ዩዪስ። ");
INSERT INTO gofENT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","ዳሮ ዴሬይ፥ ሄሚያ ኣሲ ባይና ዶርሳዳ ኤንታና ቤዒያ ኣሲ ꬋዪን ኡንዔቲዲ ዴዔይሳታ ቤዒዲ ኤንታው ቃꬌቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","ባ ታማሬታኮ፥ «ሺቃና ካꬃይ ዳሮ፥ ሺን ካꬃ ሺሺያ ኣሳይ ጉꬃ። ");
INSERT INTO gofENT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","ሄሳ ጊሾ፥ ጎዳይ ካꬃ ሺሺያ ኦሳንቾታ ዬዳና ሜላ ዎሲቴ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","ዬሱሲ ታማኔ ናምዑ ታማሬታ ባኮ ፄጊዲ፥ ቱና ኣያናታ ኬሳና ሜላኔ ሃርጌ ኡባ ፓꬃና ሜላ ኤንታው ማታ ኢሚስ። ");
INSERT INTO gofENT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","ዬሱሲ ኪቲዳ ታማኔ ናምዑ ሃዋሬታ ሱንꬃይ፡ ኮይሮይ ጴፂሮሳ ጊያ ሲሞናኔ ኢያ ኢሻ ኢንዲሪያሳ፥ ዛብዲዮሳ ናዓ ያይቆባኔ ኢያ ኢሻ ዮሃኒሳ፥ ");
INSERT INTO gofENT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ፊልጶሳኔ ባርቶሎሚዮሳ፥ ቶማሳኔ ቃራፃ ቃንፂሲያ ማቶሳ፥ ኢልፊዮሳ ናዓ ያይቆባ፥ ታዲዮሳ፥ ");
INSERT INTO gofENT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ባ ቢታስ ሚሼቲያ ሲሞናኔ ዬሱሳ ኣꬂ ኢሚዳ ኣስቆሮታ ዪሁዳ። ");
INSERT INTO gofENT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","ሄ ታማኔ ናምዓታ ዬሱሲ ኪቲዲ ዬዲሼ፥ «ኣይሁዴ ጊዶና ዴሪያኮ ቦፒቴ፥ ቃሲ ሳማሬታ ካታማካ ጌሎፒቴ። ");
INSERT INTO gofENT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","ሺን ኢስራዔሌ ኬꬃፌ ጊዲዳ ሂኒ ꬋዪዳ ዶርሳታኮ ቢቴ። ");
INSERT INTO gofENT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","ያ ቢዲ፥ ‹ሳሎ ካዎቴꬃይ ማታቲስ› ጊዲ ኦዲቴ። ");
INSERT INTO gofENT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","ሃርጋንቾታ ፓꬂቴ፥ ሃይቂዳይሳታ ሃይቆፔ ዴንꬂቴ፥ ባሮ ሃርጋንቾታ ጌሺ ፓꬂቴ፥ ቱና ኣያናታ ኬሲቴ። ሂንቴ ጮ ኤኪዳይሳ ጮ ኢሚቴ። ");
INSERT INTO gofENT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","ሂንቴ ኪሴን ዎርቃ፥ ዎይኮ ቢራ ሳንቲሜ ኦይኮፊቴ። ");
INSERT INTO gofENT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ሂንቴ ኦጊያስ ካርፂቶ፥ ናምዑ ኣፊላ፥ ዎይኮ ጫማ ዎይኮ ፃምዓ ኦይኮፊቴ፤ ኦሳንቹዋስ ጋላሳ ካꬂ ኮሼስ። ");
INSERT INTO gofENT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","«ሂንቴ ኢሲ ካታማ ዎይኮ ጉታ ጌሊያ ዎዴ ሂንቴና ሞኪዲ ኤካናው ኡፋይቲያ ኡራ ኮዪዲ ኢያ ሶን ሼምፒቴ፤ ሂንቴ ባና ጋካናው ያን ጋምዒቴ። ");
INSERT INTO gofENT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","ቃሲ ኦዴ ሶካ ጌሊሼ ሳሮꬂቴ። ");
INSERT INTO gofENT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","ሄ ኬꬃይ ሂንቴና ሞኪኮ ሂንቴ ሳሮꬂዳ ሳሮይ ኤንታና ጋኮ፥ ሺን ኤንቲ ሞኮና ኢፂኮ ሂንቴ ሳሮꬂዳ ሳሮይ ሂንቴው ጉዬ ሲሞ። ");
INSERT INTO gofENT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","ኦኒካ ሂንቴና ሞኮናኔ ሂንቴ ኦዲያባ ሲዖና ኢፂኮ ሄ ኬꬃፌ ዎይኮ ሄ ካታማፔ ኬዪሼ ሂንቴ ቶሁዋን ዴዒያ ባና ፒቲዲ ኬዪቴ። ");
INSERT INTO gofENT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","ታ ሂንቴው ቱማ ኦዳይስ፤ ፆሳ ፒርዳ ጋላሳን ሄ ካታማፔ ሶዶሜሲኔ ጋሞራ ካታማታስ ፒርዳይ ካዉያና። ");
INSERT INTO gofENT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","«ታ ሂንቴና ዶርሳታዳ ሱꬉሜታ ጊዶ ዬዳና። ሄሳ ጊሾ፥ ሾሻዳ ጪንጫታ፥ ሆሌዳ ኣዳታ ጊዲቴ። ");
INSERT INTO gofENT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","ኣሳይ ሂንቴና ፒርዳ ዳይናታስ ኣꬂ ኢማና፥ ቃሲ ኣይሁዴ ዎሳ ኬꬃን ሂንቴና ጋራፋና። ሄሳ ጊሾ፥ ኤንታፌ ናጌቲቴ። ");
INSERT INTO gofENT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","ታ ጊሾ ጊዲ ሂንቴና ዴሪያ ሃሬይሳታ ሲንꬄኔ ካዎታ ሲንꬄ ኤፋና። ኤንታ ሲንꬃኒኔ ኣይሁዴ ጊዶና ዴሪያ ሲንꬃን ኤቂዲ ሂንቴ ታባ ማርካታና። ");
INSERT INTO gofENT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","ሺን ሂንቴና ፒርዳስ ኣꬂ ኢሚያ ዎዴ ዎይጊዲ ዛሪኖ ጊዲ ኡንዔቶፊቴ፤ ሄ ሳቲያን ሂንቴ ጋናባ ፆሳይ ሂንቴው ኢማና። ");
INSERT INTO gofENT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","ኣይስ ጊኮ፥ ሂንቴናን ሃሳዬይ ሂንቴ ኣዋ ጌሻ ኣያናፔ ኣቲን ሂንቴና ጊዴኬታ። ");
INSERT INTO gofENT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","«ኢሻይ ባ ኢሻ፥ ኣዋይ ባ ናዓ፥ ሃይቆስ ኣꬂ ኢማና፥ ናይቲ ባንታና ዬሊዳይሳታ ቦላ ዴንዲዲ ኤንታና ዎꬊሳና። ");
INSERT INTO gofENT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","ታ ጊሾ ጊዲ ኣሳ ኡባይ ሂንቴና ኢፃና፥ ሺን ዉርሴꬂ ጋካናው ሚኒዳይ ኣታና። ");
INSERT INTO gofENT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","ኢሲ ሄራፔ ሂንቴና ኤንቲ ጎዲኮ ሃራ ካታማ ባቃቲቴ። ታኒ ሂንቴው ቱማ ኦዳይስ፤ ኣሳ ናዓይ ያና ጋካናው፥ ሂንቴ ኢስራዔሌ ካታማ ኡባ ካንꬄኬታ። ");
INSERT INTO gofENT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","«ታማሬይ ባ ኣስታማሪያፔ፥ ኣይሌይ ባ ጎዳፔ ኣꬌና። ");
INSERT INTO gofENT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","ታማሬይ ባ ኣስታማሪያ፥ ኣይሌይ ባ ጎዳ ዳኒኮ ኢያው ጊዳና። ኬꬃዋ ቢዔልዜቡላ ጊኮ ኢያ ሶ ኣሳ ዋኒዲ ኢሲዲ ፄጌኔ? ");
INSERT INTO gofENT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","«ሂዛ፥ ኣሳስ ያዮፊቴ። ካሜቲዳባይ ቆንጮና፥ ቆሴቲዳባይ ጌሺ ኬዮና ኣቴና። ");
INSERT INTO gofENT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","ታኒ ሂንቴው ꬉማን ኦዲያባ ሂንቴ ፖዖን ኦዲቴ፤ ታ ሂንቴው ሃይꬃን ካልካሺዳባ ዳባባን ኣዋጂቴ። ");
INSERT INTO gofENT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","ኣሾፔ ኣቲን ሼምፖ ዎꬋናው ዳንዳዖናይሳታስ ያዮፊቴ። ሺን ሼምፑዋኔ ኣሹዋ ጋናሜን ꬋይሳናው ዳንዳዒያ ፆሳስ ያዪቴ። ");
INSERT INTO gofENT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","ናምዑ ቡቤቲ ኢሲ ሳንቲሜን ባይዜቶኮናዬ? ሃኖፔ ኣቲን፥ ኤንታፌ ኢሲናካ ሂንቴ ፆሳይ ጎና ዴዒሺን ሳዓን ዎꬉኩ። ");
INSERT INTO gofENT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","ሃሪ ኣቶሺን፥ ሂንቴ ሁዔ ቢናናይካ ፓይዴቲዲ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","ሂዛ፥ ዳሮ ቡቤታፔ ሂንቴ ኣꬊያ ጊሾ ያዮፊቴ። ");
INSERT INTO gofENT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","«ኣሳ ሲንꬃን ታው ማርካቲያ ኡባስ ታኒካ ሳሉዋን ዴዒያ ታ ኣዋ ሲንꬃን ማርካታና። ");
INSERT INTO gofENT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","ሺን ኣሳ ሲንꬃን ታና ካዴይሳ ታኒካ ሳሎን ዴዒያ ታ ኣዋ ሲንꬃን ካዳና። ");
INSERT INTO gofENT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","«ታኒ ሳዓን ሳሮ ኤሃናው ዪዳ ሂንቴው ዳኖፖ። ታኒ ቶራፔ ኣቲን ሳሮቴꬂ ኤሃናው ያቢኬ። ");
INSERT INTO gofENT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","ታኒ ዪዳይ፥ ‹ናዓ ኣዋፔ ማጫ ናዒው ኣዬፔ ናዓ ማቺው ኣዚና ኣዬፔ ሻካናሳ። ");
INSERT INTO gofENT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","ኣሳስ ሞርኬቲ ኢያ ሶ ኣሳታ ጊዳና።› ");
INSERT INTO gofENT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","«ታፔ ኣꬂዲ ባ ኣዋ ዎይኮ ባ ኣዪው ዶሴይ፥ ታባ ጊዳናው ቤሴና። ባ ኣዴ ናዓ ዎይኮ ባ ማጫ ናዒው ታፔ ኣꬂዲ ዶሴይ፥ ታባ ጊዳናው ቤሴና። ");
INSERT INTO gofENT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","ባ ማስቃሊያ ቶኪዲ ታና ካሎና ኦኒካ ታባ ጊዳናው ቤሴና። ");
INSERT INTO gofENT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","ባ ሼምፑዋ ኣሻናው ኮዬይ ꬋይሳና፥ ሺን ባ ሼምፑዋ ታ ጊሾ ኣꬂ ኢሜይ ኣሻና። ");
INSERT INTO gofENT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","«ሂንቴና ሞኬይ ታና ሞኬስ፥ ታና ሞኬይ ቃሲ ታና ኪቲዳይሳ ሞኬስ። ");
INSERT INTO gofENT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","ናቢያ ናቤ ሱንꬃን ሞኬይ፥ ናቢያꬆ ዎይቴታና፤ ቃሲ ፂሉዋ ፂሎ ሱንꬃን ሞኬይ፥ ፂሉዋꬆ ዎይቴታና። ");
INSERT INTO gofENT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","ታ ሂንቴው ቱማ ኦዳይስ፤ ሃ ታ ታማሬታፔ ጉፂያ ኢሱዋስ ታና ካሊያ ጊሾ ሃሪ ኣቶሺን ጉꬃ ኢርፃ ሃꬂ ኢሚኮ ኢያ ዎይቶይ ꬋዬና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","ዬሱሲ ታማኔ ናምዑ ታማሬታ ኪታ ኦንጊዳፔ ጉዬ ያፔ ዴንዲዲ ታማርሳናዉኔ ሳባካናው ጋሊላ ካታማታ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","ዮሃኒሲ ቃሾ ኬꬃን ዴዒሼ ኪሪስቶሲ ኦꬂያባታ ሲዒዲ፥ ባ ታማሬታፔ ኢያኮ ኪቲዲ፥ ");
INSERT INTO gofENT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","«ያና ጌቴቲዳይ ኔኔዬ? ዎይኮ ኑኒ ሃራ ናጊኖ?» ያጊዲ ኦይቺስ። ");
INSERT INTO gofENT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","ዬሱሲ ኤንታኮ ዛሪዲ፥ «ቢዲ ሂንቴ ሲዒያባኔ ሂንቴ ቤዒያባ ዮሃኒሳስ ኦዲቴ። ");
INSERT INTO gofENT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","ቆቄቲ ፄሎሶና፥ ዎቤቲ ሃሙቶሶና፥ ባሮ ሃርጋንቾቲ ፓፆሶና፥ ቱሌቲ ሲዖሶና፥ ሃይቂዳይሳቲ ሃይቆፔ ዴንዶሶና፤ ማንቆታስ ዎንጌላይ ሳባኬቴስ። ");
INSERT INTO gofENT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","ታናን ꬉቤቶናይ ኣንጄቲዳይሳ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","ዮሃኒሳ ታማሬቲ ጉዬ ሲሚዲ ቢን፥ ዬሱሲ ዴሪያስ ዮሃኒሳባ ኦዲሼ፥ «ሃ ባዙዋ ኣይ ቤዓናው ኬዪዴቲ? ጫርኮይ ቃꬂያ ማቃ ቤዓናው ዪዴቲዬ? ");
INSERT INTO gofENT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","ያቲን፥ ኣይ ቤዓናው ኬዪዴቲ? ኪቴ ማዖ ማዒዳ ኣሴ ቤዓናሴዬ? ኪቴ ማዖ ማዒዳይሳቲ ካዎታ ኬꬃን ዴዖሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","ያቲን፥ ኣይ ቤዓናው ኬዪዴቲ? ናቤ ቤዓናሴዬ? ሄኮ፥ ሂንቴ ናቤፔካ ኣꬌይሳ ቤዔታ። ");
INSERT INTO gofENT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","«ኔ ኦጊያ ኔ ሲንꬃን ጊጊሲያ ታ ኪታንቹዋ ኔፔ ሲንꬄ ኪታና» ጌቴቲዲ ፃፌቲዳይ ኢያሳ። ");
INSERT INTO gofENT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","ታ ሂንቴው ቱማ ኦዳይስ፤ ማጫሳፔ ዬሌቲዳይሳታ ጊዶፌ ዮሃኒሳፔ ኣꬌይ ኦኒካ ባዋ፤ ሳሎ ካዎቴꬃን ኡባፌ ጉፄይ ኢ፥ ኢያፔ ኣꬋና። ");
INSERT INTO gofENT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","ፃማቂያ ዮሃኒሳ ዎዲያፔ ዶሚዲ ሃቺ ጋካናው ሳሎ ካዎቴꬃይ ዳሮ ናቄቴስ፥ ሚኒዳ ኣሳቲ ዎልቃን ያ ጌላና። ");
INSERT INTO gofENT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","ናቤቲ ኡባይኔ ሙሴ ሂጌይ ዮሃኒሳ ዎዴ ጋካናው ሳሎ ካዎቴꬃባ ቲንቢቴ ኦዲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","ሂዛ፥ ሂንቴ ኤንታ ኪታ ኣማናና ጊዲኮ፥ ያና ጌቴቲዳ ኤሊያሲ፥ ኢ ዮሃኒሳ። ");
INSERT INTO gofENT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","ሂዛ፥ ሲዒያ ሃይꬂ ዴዔይ ሲዖ። ");
INSERT INTO gofENT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","«ሂዛ፥ ሃ ዎዲያ ዬሌቴꬃ ኣይቢራ ዳኒሶ? ጊያ ጊዶን ኡቲዲ ዎሊ ፄጊዲ፥ ");
INSERT INTO gofENT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‹ኑ ሂንቴው ሱሱልዔ ፑኒን፤ ሂንቴ ዬፄኬታ። ኑ ሳቢዲ ዜሌሊን፤ ሂንቴ ዬኬኬታ› ያጊያ ናይታ ዳኖሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","ፃማቂያ ዮሃኒሲ ሞናኔ ኡዮና ዪን፥ ‹ቱና ኣያኒ ዴዔስ› ያጊዴታ። ");
INSERT INTO gofENT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","ኣሳ ናዓይ ሚሼኔ ኡዪሼ ዪን፥ ‹ያራምባኔ ኡሻንቾ፥ ቃራፃ ቃንፂሴይሳታኔ ናጋራንቾታ ዳቦ› ያጊዴታ። ሂዛ፥ ጪንጫቴꬃ ቱማቴꬃይ ኢያ ኦሱዋን ቆንጬስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","ሄሳፌ ጉዬ፥ ዬሱሲ ዳሮ ማላታታ ኦꬂዳ ካታማታን ዴዒያ ኣሳቲ ባንታ ናጋራፔ ሲሚዲ ማሮታን ጌሎና ኢፂዳ ጊሾ ኤንታና፥ ");
INSERT INTO gofENT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","«ኣዬ ኮራዚኔ ካታማው፥ ኣዬ ቤቴሳይዳ ካታማው፥ ኣይስ ጊኮ፥ ሂንቴ ጊዶን ኦሴቲዳ ማላታቲ ፂሮሳኒኔ ሲዶናን ኦሴቲዳ ጊዲያኮ፥ ኤንቲ ቤኒ ቢዶ ቲዬቲዲ፥ ካሌ ማዒዲ ባንታ ናጋራፔ ሲሚ ኣጋና። ");
INSERT INTO gofENT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","ሺን ታ ሂንቴው ኦዳይስ፤ ፒርዳ ጋላስ ሂንቴፌ ኣꬂዲ ፂሮሳሲኔ ሲዶናስ ፒርዳይ ካዉያና። ");
INSERT INTO gofENT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","ቃሲ፥ ቂፊርናሆሜ፥ ኔኒ ፑዴ ሳሎ ኬያናው ኮያይ? ሃኔና! ኔኒ ሲዖሌን ዬጌታና። ኣይስ ጊኮ፥ ኔ ጊዶን ኦሴቲዳ ማላታቲ ሶዶሜን ኦሴቲዳባ ጊዲያኮ፥ ሶዶሜይ ሃቺ ጋካናው ዴዓናሺን። ");
INSERT INTO gofENT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","ሺን ታ ኔው ኦዳይስ፤ ፒርዳ ጋላስ ኔፔ ኣꬂዲ ሶዶሜስ ፒርዳይ ካዉያና» ያጊዲ ሃንቄቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","ሄ ዎዴ ዬሱሲ፥ «ኣዋው፥ ሳሉዋኔ ሳዓ ጎዳው፥ ኔኒ ሃይሳ ኤራንቾታፔኔ ጪንጫታፔ ጌንꬃዳ ናይታስ ቆንጪሲዳ ጊሾ ኔና ጋላታይስ። ");
INSERT INTO gofENT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","ኤ፥ ታ ኣዋው፥ ሃይሲ ኔ ሎዖ ሼኒያዳ ሃኒስ። ");
INSERT INTO gofENT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","«ኡባይ ታው ታ ኣዋፔ ኢሜቲስ። ኣዋፔ ሃሪ ናዓ ኤሬይ ባዋ፥ ናዓፔኔ ኢ ኤንታው ቆንጪሳናው ኮዬይሳታፔ ሃሪ ኣዋ ኤራናው ዳንዳዔይ ባዋ። ");
INSERT INTO gofENT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","«ሂንቴኖ፥ ዳቡራንቾቶ፥ ቶሆይ ዴፂዳ ኡባይ ታኮ ሃ ዪቴ፤ ታኒ ሂንቴና ሼምፒሳና። ");
INSERT INTO gofENT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","ታኒ ታ ዎዛናን ኣሽኬኔ ኣዳ ጊዲያ ጊሾ ታ ቃምባራን ጌሊቴ፥ ታፔ ታማሪቴ፤ ሂንቴ፥ ሂንቴ ሼምፑዋስ ሼምፖ ዴማና። ");
INSERT INTO gofENT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","ታ ቃምባራይ ሊቆ፥ ቃሲ ታ ቶሆይካ ካዉሼ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","ሄሳፌ ጉዬ፥ ሳምባታ ጋላስ፥ ዬሱሲ ጋዴ ጊዶራ ኣꬌስ። ዬሱሳ ታማሬቲ ኮሻቲዳ ጊሾ ቲያ ባንጋ ሺሪኪዲ ሞሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","ሺን ፋሪሳዌቲ ሄሳ ቤዒዲ ዬሱሳኮ፥ «ሄኮ፥ ኔ ታማሬቲ ሳምባታ ጋላስ ኦꬃናው ቤሶናባ ኦꬆሶና» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","ዬሱሲ ኤንታኮ ዛሪዲ፥ «ዳዊቴይ ኮሻቲዳ ዎዴ ኢያራ ዴዔይሳታራ ኣይ ኦꬂዳኮ ናባቢቤኬቲ? ");
INSERT INTO gofENT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","ዳዊቴይ ፆሳ ኬꬂ ጌሊዲ ካሂኔታ ፃላላፔ ኣቲን ኢኔ ኢያራ ዴዔይሳታስ ቤሶና ጌሻ ዳቡዋ ሚስ። ");
INSERT INTO gofENT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","ዎይኮ ካሂኔቲ ሳምባታ ዎጋ ሻሪዲ ፆሳ ኬꬃን ሳምባታ ጋላስ ኦሶ ኦꬂኮ ኤንታው ባላ ጊዶናይሳ ሙሴ ሂጊያን ናባቢቤኬቲ? ");
INSERT INTO gofENT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","ሺን ሲዒቴ! ፆሳ ኬꬃፌ ኣꬌይ ሃይሳን ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","‹ታኒ ሂንቴ ያርሹዋ ጊዶናሺን ሂንቴ ሃራታ ማራና ሜላ ኮያይስ› ጊያ ቃላይ ዎይ ጉሴኮ ሂንቴ ኤሪዳኮ ፂሎ ኣሳ ቦላ ፒርዴኬታ። ");
INSERT INTO gofENT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","ኣሳ ናዓይ ሳምባታ ጎዳ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","ዬሱሲ ያፔ ቢዲ ኣይሁዴ ዎሳ ኬꬂ ጌሊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","ያን ኩሼይ ጉንዲዳ ኢሲ ኡራይ ዴዔስ። ዬሱሳ ሞታናው ጋሶ ኮያ ኣሳቲ፥ «ሳምባታ ጋላስ ፓꬃናው ቤሲ ቤሴኔ?» ያጊዲ ኦይቺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","ኢ ኤንታኮ፥ «ሂንቴ ጊዶፌ ኢሱዋስ ዶርሲ ሳምባታ ጋላስ ኣፎን ዉሊኮ፥ ጎቺዲ ኬሶናይ ኦኔ? ");
INSERT INTO gofENT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","ያቲን ኣሲ ዶርሳፌ ዋኒዲ ዳሮ ኣꬌኔ? ሄሳ ጊሾ፥ ሳምባታ ጋላስ ሎዖባ ኦሶይ ቤሴስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","ሄሳፌ ጉዬ፥ ዬሱሲ ኣዲያኮ፥ «ኔ ኩሺያ ፒዲ ኦꬃ» ያጊን፥ ኡራይ ፒዲ ኦꬂስ። ኢያ ኩሼይ ፓፂዲ ሃንኮ ኩሺያዳ ሃኒስ። ");
INSERT INTO gofENT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","ሺን ፋሪሳዌቲ ያፔ ካሬ ኬዪዲ፥ ዬሱሳ ዋቲ ዎꬋኔኮ ማቄቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","ዬሱሲ ኤንታ ቆፋ ኤሪዲ ሄ ቤሳ ኣጊዲ ሃራ ሶ ቢስ። ዳሮ ኣሳይ ኢያ ካሊዲ ቢዶሶና፥ ሃርጋንቾታ ኡባ ፓꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ዬሱሲ፥ «ታባ ሃራ ኦዴስካ ኦዶፒቴ» ያጊዲ ሚንꬂ ኦዲስ። ");
INSERT INTO gofENT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","ሄሲካ ናቢያ ኢሳያሲ፥ ");
INSERT INTO gofENT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","«ሄኮ ታ ዶሪዳ ኣይሌይ፥ ታ ዶሴይሲ፥ ታና ኡፋይሴይሲ፥ ታኒ ታ ኣያና፥ ኢያ ቦላ ሼምፒሳና፤ ኢ፥ ኣይሁዴ ጊዶና ዴሪያስ ሱሬ ፒርዳባ ኣዋጃና። ");
INSERT INTO gofENT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","ኢ ፓላሜና ዎይኮ ካጬና፤ ባ ቃላካ ዴንባን ጮ ሲሴና። ");
INSERT INTO gofENT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","ሱሬ ፒርዳን ፆኖ ዴማና ጋካናው፥ ዲንጬቲዳ ማቃ ሜንꬄና፥ ጩዪያ ሙቃዳ ቶይሴና። ");
INSERT INTO gofENT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","ኣይሁዴ ጊዶና ዴሬይ ኡባይ ኢያን ኡፋይሲ ዎꬃና» ያጊዲ ፃፊዳይሲ ፖሌታና ሜላሳ። ");
INSERT INTO gofENT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","ሄሳፌ ጉዬ፥ ቱና ኣያናን ኦይኬቲዳ ቆቄኔ ሙሜ ኣሴ ዴዔይሳ ኢያኮ ኤሂዶሶና። ዬሱሲ ኡራ ፓꬂን፥ ኡራይ ቤዒሲኔ ኦዴቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","ኣሳ ኡባይ ማላሌቲዲ፥ «ሃይሲ ዳዊቴ ናዓ ጊዳንዴሻ?» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","ሺን ፋሪሳዌቲ ሄሳ ሲዒዲ፥ «ሃ ኡራይ ቱና ኣያናታ ኬሴይ ቱና ኣያናታ ሃላቃ ቢዔልዜቡላ ዎልቃና» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","ዬሱሲ ኤንታ ቆፋ ኤሪዲ፥ «ዎሊ ጊዶን ሻኬቲያ ካዎቴꬃ ኡባይ ኩንዳና፤ ቃሲ ዎሊ ጊዶን ሻኬቲያ ካታማይ ዎይኮ ኬꬃይ ሚኒዲ ኤቄና። ");
INSERT INTO gofENT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","ፃላሄይ ፃላሄ ኬሲያባ ጊዲኮ ባ ጊዶን ሻኬቲስ ጉሱ። ሄሳꬆ ሃኒያባ ጊዲኮ ኢያ ካዎቴꬃይ ዋኒዲ ሚኒዲ ኤቃናው ዳንዳዒ? ");
INSERT INTO gofENT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","ታኒ ቱና ኣያና ኬሴይ ቢዔልዜቡላ ዎልቃን ጊዲኮ ሂንቴና ካሊያ ኣሳቲ ኦዴ ዎልቃን ኬሳኔ? ሄሳ ጊሾ፥ ሂንቴና ካሊያ ኣሳቲ ሂንቴና ፒርዳና። ");
INSERT INTO gofENT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","ሺን ታኒ ቱና ኣያናታ ኬሴይ ፆሳ ኣያናን ጊዲኮ፥ ፆሳ ካዎቴꬃይ ሂንቴኮ ዪስ። ");
INSERT INTO gofENT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","«ዎይኮ ኢሲ ኣሲ ዎልቃማ ኣሳ ሶ ጌሊዲ ኢያ ሻሉዋ ቦንቃናው ኮይኮ ኮይሮቲዲ ሄ ኡራ ቃቾና ኢፂኮ ዋቲዲ ዳንዳዒ? ያቲኮ ኢያ ሻሉዋ ቦንቃናው ዳንዳዔስ። ");
INSERT INTO gofENT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","«ታራ ጊዶናይ ኦኒካ ታራ ኤቄቴስ፤ ቃሲ ታራ ኢሲፌ ሺሾና ኡባይ ላሌስ። ");
INSERT INTO gofENT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","ሄሳ ጊሾ፥ ሲዒቴ፤ ኣሳይ ኦꬂያ ኣይ ናጋሪኔ ጫሻ ቃሊ ኡባይ ኣቶ ጌቴታና፥ ሺን ጌሻ ኣያና ጫያ ኦዴስካ ኢያ ናጋራይ ኣቶ ጌቴቴና። ");
INSERT INTO gofENT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","ኦኒካ ኣሳ ናዓ ቦላ ኢታባ ኦዴቲኮ ኢያው ኣቶ ጌቴታና፥ ሺን ጌሻ ኣያና ቦላ ኢታባ ኦዴቲያ ኦዴስካ ሃ ሳዓን ጊዲን ያና ኣላሚያን ኢያ ናጋራይ ኣቶ ጌቴቴና። ");
INSERT INTO gofENT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","«ሎዖ ሚꬃይ ሎዖ ኣይፌ ኣይፌስ፤ ቃሲ ኢታ ሚꬃይ ኢታ ኣይፌስ። ሂዛ፥ ሚꬃይ ኤሬቴይ ባ ኣይፊያና። ");
INSERT INTO gofENT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","ሂንቴኖ፥ ሾሻ ናይቶ፥ ሂንቴ ኢታ ጊዲሼ ዋኒዲ ሎዖባ ኦዴታናው ዳንዳዔቲ? ኣሲ ባ ዎዛናን ኩሚዳባፔ ዶናን ኦዴቴስ። ");
INSERT INTO gofENT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","ሎዖ ኣሲ ባ ዎዛናን ዎꬂዳ ሎዖባፔ፥ ሎዖባ ኬሴስ፤ ኢታ ኣሲ ባ ዎዛናን ዎꬂዳ ኢታባፔ፥ ኢታባ ኬሴስ። ");
INSERT INTO gofENT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","ሺን ሲዒቴ፥ ኣሳይ ኦዴቲያ ጮ ኦዳ ኡባስ ፒርዳ ጋላስ ዛሮ ኢማና። ");
INSERT INTO gofENT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","ኣይስ ጊኮ፥ ኔ ኦዴቲያ ኔ ቃላን ፂላና፤ ኔ ኦዴቲያ ኔ ቃላይ ኔ ቦላ ፒርዳና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","ሄሳፌ ጉዬ፥ ኢሲ ኢሲ ፋሪሳዌቲኔ ሂጌ ኣስታማሬቲ ዬሱሳኮ፥ «ኣስታማሪያው፥ ኔኒ ማላታ ኦꬃዳ ኑና ቤሳ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","ሺን ዬሱሲ ዛሪዲ፥ «ኣማኔቶናኔ ኢታ ዬሌቴꬃይ ማላታ ኮዬስ። ሺን ናቢያ ዮናሳ ማላታፔ ሃራ ማላቲ ኢያው ኢሜቴና። ");
INSERT INTO gofENT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","ዮናሲ ጊታ ሞሎ ኡሎን ሄꬑ ጋላሲኔ ሄꬑ ቃማ ጋምዒዳይሳ ሜላ ኣሳ ናዓይ ሄꬑ ጋላሲኔ ሄꬑ ቃማ ቢታ ጋርሳን ጋምዓና። ");
INSERT INTO gofENT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","ናናዌ ኣሳይ ፒርዳ ጋላስ ዴንዲዲ ሃ ዬሌቴꬃ ቦላ ፒርዳና፤ ኣይስ ጊኮ፥ ኤንቲ ዮናሳ ሲብካቲያ ሲዒዲ ባንታ ናጋራፔ ሲሚዶሶና። ሄኮ፥ ዮናሳፔ ኣꬌይሲ ሃይሳን ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","ፒርዳ ጋላስ ዱጌሃ ካዊያ ዴንዳዳ ሃ ዬሌቴꬃ ቦላ ፒርዳና፤ ኣይስ ጊኮ፥ ኢያ ሶሎሞኔ ጪንጫቴꬃ ሲዓናው ቢታ ጋፃፔ ያሱ። ሄኮ፥ ሶሎሞኔፔ ኣꬌይ ሃይሳን ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","«ቱና ኣያናይ ኣሳፔ ኬዪዳፔ ጉዬ ባው ሼምፒያሶ ኮዪዲ ሃꬂ ባይና ሜላ ቤሳን ዳቡሬስ፥ ሺን ባ ኮያ ሼምፑዋ ዴሜና። ");
INSERT INTO gofENT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ያኒን፥ ‹ታ ኣጋ ኬዪዳ ኬꬃ ሲማዳ ባና› ያጌስ። ኢ ሲሚያ ዎዴ ኬꬃይ ካይሲ ጊዴይሳኔ ፒቴቲዲ ጊጊ ኡቲዳይሳ ዴሜስ። ");
INSERT INTO gofENT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","ሂዛ፥ ሲሚ ቢዲ፥ ባፔ ኢቲያ ሃራ ላፑን ኢታ ኣያናታ ኤኪዲ ዬስ፤ ኤንቲካ ኡራ ጊዶ ጌሊዲ ዴዖሶና። ሄ ኡራስ ካሴይሳፌ ጉዬይሲ ዳሮ ኢቴስ። ሃ ኢታ ዬሌቴꬃ ቦላ ሄሳ ሜላ ሃናና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","ዬሱሲ ዴሪያስ ኦዳ ቦላ ዴዒሺን ኢያ ኣያኔ ኢያ ኢሻቲ ኢያ ኦዲሳናው ኮዪዲ ካሬን ኤቂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","ኢሲ ኣሲ ኢያኮ፥ «ኔ ኣያኔ ኔ ኢሻቲ ኔና ኦዲሳናው ኮዪዲ ካሬን ኤቂዶሶና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","ዬሱሲ ዛሪዲ፥ «ታ ኣያ ኦኔ? ታ ኢሻቲካ ኦናንቴ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","ባ ኩሺያራ ታማሬታ ማሊሼ፥ «ቤዒቴ፥ ታ ኣያኔ ታ ኢሻቲ ሃይሳታ። ");
INSERT INTO gofENT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","ሳሎን ዴዒያ ታ ኣዋ ሼኒያ ኦꬂያ ኡባይ ታ ኢሻ፥ ታ ሚቾኔ ታ ኣዮ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","ሄ ጋላስ ዬሱሲ ሶፔ ኬዪዲ ኣባ ጋፃን ኡቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","ዳሮ ዴሬይ ኢያ ዩሹዋን ሺቂን ኣሳ ኣባ ጋፃን ኣጋጊዲ ዎጎሎን ጌሊዲ ኡቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","ኣሳስ ዳሮባ ሌሚሶን ያጊዲ ኦዲስ፡ «ኢሲ ጎሻንቾይ ዜሬꬂ ዜራናው ኬዪስ። ");
INSERT INTO gofENT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","ኢ ዜሪያ ዎዴ ኢሲ ኢሲ ዜሬꬃቲ ኦጌ ጋፃን ዎꬊዶሶና፤ ኤንታካ ካፎቲ ዪዲ ማፂ ሚዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","ኢሲ ኢሲ ዜሬꬃቲ ጋርሳን ሻሎይ ዴዒያ ቢታ ቦላ ዎꬊዶሶና። ዳሮ ቢቲ ባይና ጊሾ ኤሌሲዲ ዶሊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","ሺን ኣዋይ ኬዪን ሹሊስ፤ ፃጶይ ባይና ጊሾ ሜሊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","ኢሲ ኢሲ ዜሬꬃይ ኣጉንꬃ ጊዶን ዎꬊስ፤ ኣጉንꬃይ ዲጪዲ ሄ ዶላ ጩሊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","ሃራቲ ቃሲ ኣራዳ ቢታ ቦላ ዎꬊስ፤ ዶሊዲ ኣይፌ ኣይፊስ። ኢሶይ ፄታ፥ ኢሶይ ኡሱፑን ታማ፥ ኢሶይ ቃሲ ሃስታማ ኣይፊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","ሲዒያ ሃይꬂ ዴዒያ ኡራይ ሲዖ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","ዬሱሳ ታማሬቲ ኢያኮ ሺቂዲ፥ «ኣይስ ኔኒ ዴሪያስ ሌሚሶን ኦዳይ?» ያጊዲ ኦይቺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","ኢ ዛሪዲ፥ «ሂንቴው ሳሎ ካዎቴꬃ ፁራ ኤራይ ኢሜቲስ፥ ሺን ኤንታው ኢሜቲቤና። ");
INSERT INTO gofENT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","ዴዒያ ኡባስ ጉዤታና፥ ኢያው ዳራና፥ ሺን ባይናይሳፌ ሃሪ ኣቶሺን ኢያው ዴዒያራካ ኤኬታና። ");
INSERT INTO gofENT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","ሄሳ ጊሾ፥ ታኒ ኤንቲ፥ ፄሊሼ ዴሞና ሜላ፥ ሲዒሼ ሲዖና ሜላ ዎይኮ ኣኬኮና ሜላ ኤንታው ሌሚሶን ኦዳይስ። ");
INSERT INTO gofENT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","«ኢሳያሲ ባ ማፃፋን ኦዲዳይሲ ኤንታ ቦላ ፖሌቲስ። ኢ ኦዲሼ፥ ‹ሂንቴ ሲሳ ሲዔታ፥ ሺን ኣኬኬኬታ፤ ሂንቴ ፄሌታ፥ ሺን ቤዔኬታ። ");
INSERT INTO gofENT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","ኣይስ ጊኮ፥ ሃ ኣሳ ዎዛናይ ዜልዑሚስ፤ ባንታ ሃይꬃ ኤሪሼ ቱሊሲዶሶና፥ ባንታ ኣይፊያ ጎዚዶሶና። ሄሲ ባይኔኮ ኤንቲ ባንታ ኣይፊያን ቤዒዲ፥ ባንታ ሃይꬃን ሲዒዲ፥ ባንታ ዎዛናን ኣኬኪዲ፥ ታኮ ሲማና፥ ታካ ኤንታ ፓꬃናሺን› ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","«ሺን ሂንቴ ኣይፌቲ ቤዒያ ጊሾኔ ሂንቴ ሃይꬃቲ ሲዒያ ጊሾ ሂንቴ ኣንጄቲዳይሳታ። ");
INSERT INTO gofENT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","ታ ሂንቴው ቱማ ኦዳይስ፤ ዳሮ ናቤቲኔ ፂሎ ኣሳቲ ሂንቴ ቤዔይሳ ቤዓናዉኔ ሂንቴ ሲዔይሳ ሲዓናው ኣሞቲዶሶና፥ ሺን ኤንታው ሃኒቤና። ");
INSERT INTO gofENT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","«ሂዛ፥ ሃ ዜሬꬃ ዜሪያ ኡራ ሌሚሱዋ ሲዒቴ። ");
INSERT INTO gofENT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","ኦጌ ጋፃን ዎꬊዳ ዜሬꬃ ሌሚሶይ ሃይሳ፡ ሳሎ ካዎቴꬃ ቃላ ሲዒዲ ኣኬኮና ኡራ ዎዛናፔ ፃላሄይ ዪዲ ኢያ ዎዛናን ዴዒያ ዜሬꬃ ማፂ ዲጌስ። ");
INSERT INTO gofENT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","ሻሎይ ጋርሳን ዴዒያ ቢታ ቦላ ዜሬቲዳይሲ ቃላ ሲዒዲ ኤሌሲዲ ኡፋይሳን ኤኬይሳታ። ");
INSERT INTO gofENT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","ሺን ፃጶ ዬዳናው ዳንዳዖና ጊሾ ዳሮ ጋምዖኮና። ቃላ ጋሶን ሜቶይ ዎይኮ ጎዴቴꬂ ያ ዎዴ ኤሌሲ ꬉቤቶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","ኣጉንꬃ ጋꬃን ዜሬቲዳይሲ ቃላ ሲዒስ፥ ሺን ሃ ኣላሚያ ዱሳ ሂርጋይኔ ዱሬቴꬃ ቆፋይ ቃላ ጩሊያ ጊሾ ኣይፌ ኣይፎና ኣቴስ። ");
INSERT INTO gofENT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","ሺን ኣራዳ ቢታን ዜሬቲዳ ዜሬꬃይ ኣኬካን ቃላ ሲዒያ ኡራ። ኢ ኣይፌ ኣይፌስ፤ ኢሶይ ፄታ፥ ኢሶይ ኡሱፑን ታማ ኢሶይ ቃሲ ሃስታማ ኣይፌስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","ዬሱሲ ኤንታው ሃራ ሌሚሶ ኦዲስ፥ «ፆሳ ካዎቴꬃይ ባ ጎሻን ሎዖ ዜሬꬂ ዜሪዳ ኡራ ዳኔስ። ");
INSERT INTO gofENT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","ሺን ኣሲ ኡባይ ꬊስኪን ኢያ ሞርኬይ ዪዲ ጊስቲያ ጊዶን ሌሾ ዜሪዲ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","ጊስቴይ ዲጪዲ ኣይፊያ ዎዴ ሌሾይ ኢያ ጊዶን ቤንቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","«ጋዲያ ጎዳ ኣይሌቲ ጎዳኮ ቢዲ፥ ‹ጎዳው፥ ኔ ጎሻን ኔ ሎዖ ዜሬꬂ ዜራቢኪሾ? ያቲን፥ ሌሾይ ኣዉፔ ዪዴ?› ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","«ኢ ኤንታኮ፥ ‹ሄሳ ሞርኬይ ኦꬂስ› ያጊስ። «ኣይሌቲ ጎዳኮ፥ ‹ኑ ቢዲ ሌሹዋ ሾዳና ሜላ ኮያይ?› ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","«ሺን ኢ፥ ‹ኣቶ ቦቾፊቴ፤ ሂንቴ ሌሹዋ ሾዳይስ ጊሺን ጊስቴይ ሾዴታና። ");
INSERT INTO gofENT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","ቦቾፊቴ፤ ጫካ ዎዴይ ጋካናው ኢሲፌ ዲጮ። ሄ ዎዴ ጫኪያ ኣሳታ ሌሹዋ ሲንꬃቲዲ ማፂዲ ታማን ፁጋናው ሚርቄን ሚርቄን ቃቺቴ። ሺን ጊስቲያ ሺሺዲ ታ ሻሊያን ቆሊቴ› ያጋና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","ቃሲ ሃራ ሌሚሶ ያጊዲ ኦዲስ፤ «ሳሎ ካዎቴꬃይ ኢሲ ኣሲ ባ ጎሻን ባኪዳ ጉꬃ ሚꬄ ኣይፌ ዳኔስ። ");
INSERT INTO gofENT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","ሄ ሚꬄ ኣይፌይ ሃራ ሚꬃ ኣይፌታፔ ጉꬃ፥ ሺን ኢያ ዶላ ዲጪዳ ሃራ ሚꬃታ ኡባፌ ኣꬋ ጊታታዉሱ። ኢ ታሺያን ካፎቲ ኬፂዲ ኡታና ጋካናው ዎልቃማ ሚꬂ ጊዳዉሱ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","ካሊዲካ፥ ዬሱሲ ሃራ ሌሚሶ ኦዲስ፤ «ሳሎ ካዎቴꬃይ ኢሲ ማጫሲ ሄꬑ ጋባቴ ꬊሌ ኤካ ሙኑቃዳ፥ ሙኑቃይ ዴንዳና ሜላ ኢያን ጉጂዳ ኢርሾ ዳኔስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","ዬሱሲ ዴሪያስ ሄ ሌሚሱዋ ኡባ ኦዲስ። ሌሚሶይ ባይና ኢሲባካ ኦዲቤና። ");
INSERT INTO gofENT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","ናቤይ ባ ማፃፋን፥ «ታኒ ታ ዶና፥ ሌሚሶን ዶያና፤ ሳሎይኔ ሳዓይ ሜꬌቶሳፔ፥ ጌሚዳይሳ ኦዳይስ» ያጊዲ ኦዲዳይሲ ሄሳን ፖሌቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","ዬሱሲ ዴሪያ ሞይዚዲ ሶ ጌሊስ። ኢያ ታማሬቲ ኢያኮ ሺቂዲ፥ «ጎሻን ዴዒያ ሌሹዋ ቢርሼꬃ ኑስ ኦዳ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","ኢ ዛሪዲ፥ «ሎዖ ዜሬꬃ ዜሪዳይ ኣሳ ናዓ። ");
INSERT INTO gofENT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ጎሻይ ሃ ኣላሚያ። ሎዖ ዜሬꬃይ ሳሎ ካዎቴꬃ ናይታ። ሌሾይ ፃላሄ ናይታ። ");
INSERT INTO gofENT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ሌሹዋ ዜሪዳይ ሞርኪያ ፃላሄ። ጫካ ዎዴይ፥ ዎዲያ ዉርሴꬃ። ጫኬይሳቲ ኪታንቾታ። ");
INSERT INTO gofENT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","«ሌሾይ ማፄቲዲ ታማን ፁጌቴይሳ ሜላ ዎዲያ ዉርሴꬃን ሄሳዳ ሃናና። ");
INSERT INTO gofENT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","ኣሳ ናዓይ ባ ኪታንቾታ ኪታና። ኤንቲ ናጋራስ ጋሶ ጊዴይሳታኔ ኢታ ኦꬂያ ኡባ ማፂዲ ኢያ ካዎቴꬃፌ ኬሳና። ");
INSERT INTO gofENT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ማፂ ሺሺዲ ዬሆይኔ ኣቻ ጋርጬꬂ ዴዒያ ቶዖና ታማን ዬጋና። ");
INSERT INTO gofENT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","ሄ ዎዴ ፂሎቲ ባንታ ኣዋ ካዎቴꬃን ኣዋዳ ፖዓና። ሲዒያ ሃይꬂ ዴዔይ ሲዖ! ");
INSERT INTO gofENT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","«ፆሳ ካዎቴꬃይ ጎሻን ሞጌቲዳ ሚሼ ዳኔስ። ኢሲ ኣሲ ሄ ሚሺያ ዴሚዲ ዛሪ ሞጊስ። ዳሮ ኡፋይቲዲ ቢዲ ባው ዴዒያባ ኡባ ባይዚዲ ሄ ጎሻ ጋዲያ ሻሚስ። ");
INSERT INTO gofENT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","«ሄሳዳካ፥ ቃሲ ሳሎ ካዎቴꬃይ ኢንቆ ጊያ ኣልዖ ሹቻታ ኮያ ዛልዓንቾ ዳኔስ። ");
INSERT INTO gofENT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","ዳሮ ኣልዖ ኢንቁዋ ዴሚዲ ቢዲ ባው ዴዒያባ ኡባ ባይዚዲ ኢያ ሻሚስ። ");
INSERT INTO gofENT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","«ቃሲ ፆሳ ካዎቴꬃይ ኣባን ዬጌቲዳ ዱማ ዱማ ቆሞ ሞሎ ኦይኪያ ጊቲያ ዳኔስ። ");
INSERT INTO gofENT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","ሞሎ ኦይኪያ ኣሳቲ ሞሎይ ጊቲያን ኩሚን ኣባፌ ጋፃ ኬሲዶሶና። ያን ኡቲዲ ሎዑዋ ቆሪ ቆሪ ዳቾን ዬጊዶሶና፥ ሺን ኢታ ሞሎታ ዎራ ሆሊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","ዎዲያ ዉርሴꬃን ሄሳꬆ ሃናና። ኪታንቾቲ ዪዲ ናጋራንቾታ ፂሎታፔ ሻኪዲ፥ ");
INSERT INTO gofENT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ዬሆይኔ ኣቻ ጋርጬꬂ ዴዒያ ቶዖና ታማን ዬጋና። ");
INSERT INTO gofENT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","«ሃ ኡባይ ሂንቴው ጌሊዴ?» ያጊዲ ኤንታ ኦይቺስ። ኤንቲ ዛሪዲ፥ «ኤ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","ዬሱሲ፥ «ሂዛ፥ ሳሎ ካዎቴꬃ ኤራ ኤኪዲ ሂጊያ ታማርሲያ ኡባይ፥ ባ ሚንጂዳ ሻሉዋፔ ኦራꬃኔ ጋልዓ ኬሲያ ኣሴ ዳኔስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","ዬሱሲ ሃ ሌሚሱዋ ኦዲ ዉርሲዳፔ ጉዬ ያፔ ዴንዲዲ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ባ ዬሌቲዳ ቢታ ቢዲ ኣይሁዴ ዎሳ ኬꬃን ዴሪያ ታማርሲስ። ኤንቲ ማላሌቲዲ፥ «ሃ ኡራይ ሃ ጪንጫቴꬃኔ ሃ ማላታታ ኦꬂያ ዎልቃ ኣዉፔ ኤኪዴ? ");
INSERT INTO gofENT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","ሃይሲ ኣናፂያ ናዓ ጊዴኔዬ? ኢያ ኣዬ ሱንꬃይ ማይራሞ ጊዴኔ? ኢያ ኢሻቲ ያይቆባ፥ ዮሴፋ፥ ሲሞናኔ ዪሁዳ ጊዶኮናዬ? ");
INSERT INTO gofENT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","ኢያ ሚቼቲ ኑራ ዴዖሶና ጊዶኮና? ያቲን፥ ሃ ኡራይ ሃ ኡባ ኣዉፔ ኤኪዴ?» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","ሄሳ ጊሾ፥ ኢ ጊያባ ኤኮና ኢፂዶሶና። ሺን ዬሱሲ፥ «ናቤይ ባ ዬሌቲዳ ቢታኒኔ ባ ሶ ኣሳ ማታን ቦንቼቴና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","ኤንቲ ኣማኖና ኢፂዳ ጊሾ ዳሮ ማላታታ ሄ ቤሳን ኦꬂቤና። ");
INSERT INTO gofENT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","ሄ ዎዴ ጋሊላ ኣይሲያ ሄሮዲሲ ዬሱሳባ ሲዒስ። ");
INSERT INTO gofENT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ባ ኣይሌታኮ፥ «ሃይሲ ፃማቂያ ዮሃኒሳ፤ ኢ ሃይቆፔ ዴንዲስ። ያኒዳ ጊሾ ሃ ኡባ ማላታታ ኢ ኦꬄስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","ኢ ሄሳ ጊዳይ ሄሮዲሲ ባ ኢሻ ፊልጶሳ ማቼ ሄሮዲያዲ ጋሶን ዮሃኒሳ ቃሾ ኬꬂ ጌልሲዳ ጊሾሳ። ");
INSERT INTO gofENT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","ዮሃኒሲ ሄሮዲሳ፥ «ኔ ኢዮ ኤካናው ዎጋ ጊዴና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","ሄሮዲሲ ዮሃኒሳ ዎꬋናው ኮዪስ፥ ሺን ዴሬይ ዮሃኒሳ ናቤ ኦꬂዲ ቤዒያ ጊሾ ያሼቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","ሄሮዲሲ ባ ዬሌቲዳ ጋላሳ ቦንቺያ ዎዴ ሄሮዲያዳ ናዒያ ኣሳ ሲንꬃን ዬꬃን ዱራዳ ኢያ ኡፋይሳሱ። ");
INSERT INTO gofENT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ያቲን፥ ኢ፥ «ኢያ ኮያባ ኡባ ኢማና ጊዲ» ጫቂስ። ");
INSERT INTO gofENT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","ናዒያ ባ ኣዬ ዞሪያ ሲዓዳ ሄሮዲሳኮ፥ «ፃማቂያ ዮሃኒሳ ሁዒያ ኬሬን ዎꬃዳ ታው ኢማ» ያጋሱ። ");
INSERT INTO gofENT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","ኢያ ያጊን ካዎይ ቂሮቲስ፥ ሺን ባ ጫቁዋ ጊሾኔ ባራ ዴዒያ ኢማꬃታ ጊሾ ጊዲ ኢ ኦይሻይ ፖሌታና ሜላ ኪቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","ካዎይ ኣሴ ኪቲዲ ዮሃኒሲ ቃሾ ኬꬃን ዴዒሺን ኢያ ቆꬊያ ጎይሪሲስ። ");
INSERT INTO gofENT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","ሁዒያ ኬሬን ዎꬂ ኤሂዲ ናዔስ ኢሚዶሶና፤ ናዒያካ ኤካዳ ባ ኣዬስ ኤፋሱ። ");
INSERT INTO gofENT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","ዮሃኒሳ ታማሬቲ ዪዲ ኢያ ኣሃ ኤፊዲ ሞጊዶሶና። ኢያፔ ጉዬ ሃኒዳባ ኡባ ቢዲ ዬሱሳስ ኦዲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","ዬሱሲ ሃኒዳባ ሲዒዳ ዎዴ ዎጎሉዋን ጌሊዲ ሄ ቤሳፌ ኢሲ ጌሚያ ሶ ባርካ ቢስ። ኣሳይ ሄሳ ሲዒዲ ካታማታፔ ዴንዲዲ ቶሆን ኢያ ካሊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","ዬሱሲ ዎጎሉዋፔ ዎꬊዲ ዳሮ ኣሳ ቤዒዲ ኤንታው ቃꬌቲስ። ኤንታ ጊዶን ዴዒያ ሃርጋንቾታ ፓꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","ሳዓይ ኦማርሲሼ ቢያ ዎዴ ዬሱሳ ታማሬቲ ኢያኮ ሺቂዲ፥ «ሃ ቤሳይ ኣሲ ባይና ቤሲ፥ ሳዓይካ ቃሚስ። ያኒያ ጊሾ፥ ሄራን ዴዒያ ጉታታ ቢዲ ባንታው ሻሚዲ ማና ሜላ ዴሪያ ዬዳ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","ሺን ዬሱሲ ኤንታኮ፥ «ዴሬይ ሞና ባናው ኮሼና፤ ኤንቲ ማናባ ሂንቴ ኢሚቴ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","ኤንቲ ዛሪዲ፥ «ኑስ ሃይሳን ኢቻሹ ኡይꬃፌኔ ናምዑ ሞሎፔ ሃሪ ባዋ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","ኢካ፥ «ኣኔ ኤንታ ሃ ኤሂቴ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","ካሊዲካ፥ ዴሬይ ማታን ኡታና ሜላ ኦዲስ። ኢቻሹ ኡይꬃኔ ናምዑ ሞሎታ ኤኪዲ፥ ሳሎ ፄሊዲ ጋላቲ ሲሚዲ፥ ኡይꬃ ሜንꬂዲ ባ ታማሬታስ ኢሚስ፤ ኤንቲ ቃሲ ዴሪያስ ኢሚዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","ኡባይ ሚዲ ካሊዶሶና። ዬሱሳ ታማሬቲ ሚሺን ኣቲዳይሳ ታማኔ ናምዑ ጋይታ ዴንꬂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","ካꬃ ሚዳ ኣሳይ ማጫሳይኔ ናይቲ ኣቲን ኢቻሹ ሙኩሉ ጊዴስ። ");
INSERT INTO gofENT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","ዬሱሲ ባ ታማሬቲ ዎጎሉዋን ጌሊዲ ባፔ ሲንꬃቲዲ ኣባፌ ሄ ፊንꬂ ፒናና ሜላ ኪቲዲ ባው ዴሪያ ሞይዛናው ጉዬ ኣቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","ዴሪያ ሞይዚ ሲሚዲ ባርካ ዎሳናው ኢሲ ዴሪያ ቦላ ኬዪስ። ሳዓይ ቃሚንካ ኢ ባርካ ያን ጋምዒስ። ");
INSERT INTO gofENT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","ሄ ዎዴ ዎጎሎይ ኣባ ቦላ ቢሺን ሲንꬃ ባጋራ ጫርኮይ ዴንዲን ሆቤይ ዎጎሉዋ ኡንዔꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","ዎንቲማꬃ ቦላ ዬሱሲ ኣባ ቦላ ሃሙቲሼ ባ ታማሬታኮ ዪስ። ");
INSERT INTO gofENT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","ኢያ ታማሬቲ፥ ኢ ኣባ ቦላ ሃሙቲሼ ባንታኮ ዬይሳ ቤዒዲ ያዪዶሶና። ኤንቲካ፥ «ሃይሲ ሞይቲሌ» ጊዲ ያዪዲ ዋሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","ሺን ዬሱሲ ኤሌሲዲ፥ «ኣይኮይ ባዋ! ያዮፊቴ! ታናባይ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","ጴፂሮሲ ኢያኮ፥ «ጎዳው፥ ኔና ጊዲኮ፥ ታኒ ሃꬃ ቦላራ ሃሙታዳ ኔኮ ባና ሜላ ታና ኪታ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","ዬሱሲ ጴፂሮሳኮ፥ «ሃያ» ያጊስ። ጴፂሮሲ ዎጎሉዋፔ ዎꬊዲ ሃꬃ ቦላራ ሃሙቲሼ ዬሱሳኮ ቡሱ ኦይኪስ። ");
INSERT INTO gofENT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","ሺን ዎልቃማ ጫርኩዋ ቤዒዲ ያዪስ። ሃꬃን ሚቴቴꬂ ኦይኪዳ ዎዴ «ጎዳው፥ ታና ኣሻርኪ» ያጊዲ ዋሲስ። ");
INSERT INTO gofENT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","ዬሱሲ ኤሌሲዲ ባ ኩሺያ ዬዲ ኢያ ኦይኪዲ፥ «ኔኖ፥ ኣማኖይ ፓጪዳይሶ ኣይስ ሲꬋይ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","ዬሱሳራኔ ጴፂሮሳራ ዎጎሉዋን ጌሊዳ ዎዴ ጫርኮይ ሲዒ ጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","ዎጎሉዋ ጊዶን ዴዒያ ኢያ ታማሬቲ፥ «ኔኒ ቱማካ ፆሳ ናዓ» ጊዲ ጎይኒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","ኤንቲ ኣባ ፒኒዲ ጌንሳሬፄ ቢታ ጋኪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","ሄ ቢታን ዴዒያ ኣሳይ ዬሱሳ ኤሪዳ ዎዴ ባንታ ሄራን ዴዒያ ጉታ ኡባ ኪታ ዬዲዶሶና። ኣሳይ ሃርጋንቾታ ኡባ ኢያኮ ኤሂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","ሃርጋንቾቲ ኢያ ኣፊላ ማጫራ ፃላላ ቦቻና ሜላ ዎሲዶሶና። ቦቺዳ ኡባይካ ፓፂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","ሄሳፌ ጉዬ፥ ኢሲ ኢሲ ፋሪሳዌቲኔ ሂጌ ኣስታማሬቲ ዬሩሳላሜፔ ዬሱሳኮ ዪዲ፥ ");
INSERT INTO gofENT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«ኔ ታማሬቲ ኣይስ ኑ ኣዋታ ዎጋ ሜንꬆና? ኤንቲ ካꬂ ማናፔ ሲንꬄ ባንታ ኩሺያ ሜጬቶኮና» ያጊዲ ኦይቺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","ዬሱሲ ዛሪዲ፥ «ሂንቴ፥ ሂንቴ ዎጋ ጊሾ ፆሳ ኪታ ፖሌይሳ ኣይስ ኢፄቲ? ");
INSERT INTO gofENT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","ኣይስ ጊኮ፥ ፆሳይ፥ ‹ኔ ኣዋኔ ኔ ኣዪው ቦንቻ። ኢ ባ ኣዋ ዎይኮ ባ ኣዪው ጫዬይሲ ሃይቆ ጊቤኔ?› ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","ሺን ሂንቴ፥ ኢሲ ኣሲ ባ ኣዋ ዎይኮ ባ ኣዪው ማዳናባይ ዴዒሺን፥ ‹ሃይሳ ታ ፆሳስ ያርሻስ ጊኮ፥ ");
INSERT INTO gofENT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ባ ኣዋ ዎይኮ ባ ኣዪው ቦንቻናው ቤሴና› ያጌታ። ያቲዲ ሂንቴ፥ ሂንቴ ዎጋ ፖላናው ፆሳ ቃላ ሜንꬄታ። ");
INSERT INTO gofENT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","ሂንቴኖ፥ ጩቦቶ፥ ኢሳያሲ ሂንቴባ ሊኬ ኦዲስ፥ ");
INSERT INTO gofENT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","« ‹ሃ ኣሳይ ታና ባንታ ዶናን ቦንቼስ፥ ሺን ኤንታ ዎዛናይ ታፔ ሃሆን ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","ኣሳይ ታና ጮ ጎይኖሶና፤ ኤንቲ ኣሲ ሜꬊዳ ኪታ ፆሳ ሂጌ ዳኒሲዲ ታማርሶሶና› ጊስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","ዬሱሲ ዳሮ ኣሳ ባኮ ፄጊዲ፥ «ሲዒቴ! ኣኬኪቴ! ");
INSERT INTO gofENT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","ኣሴ ቱኒሲያባይ ዶናራ ጌሊያባ ጊዶናሺን ዶናፔ ኬያባ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","ሄሳፌ ጉዬ፥ ዬሱሳ ታማሬቲ ኢያኮ ዪዲ፥ «ፋሪሳዌቲ ኔኒ ጊዳይሳ ሲዒዲ ꬉቤቲዳይሳ ኣኬካይ?» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","ሺን ዬሱሲ ኤንታው ዛሪዲ፥ «ሳሉዋን ዴዒያ ታ ኣዋይ ቶኪቦና ሚꬃይ ኡባይ ሾዴታና። ");
INSERT INTO gofENT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","ኤንታባ ሂርጎፊቴ፤ ኤንቲ ቆቄ ካሌꬂያ ቆቄታ። ቆቄይ ቆቄ ካሌꬂኮ፥ ናምዓይካ ኦላን ኩንዳና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","ጴፂሮሲ ዛሪዲ፥ «ሃ ሌሚሱዋ ቢርሼꬃ ኑስ ኦዳርኪ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","ዬሱሲ ኤንታኮ፥ «ሂንቴዉካ ሃዒ ጋካናው ጌሊቤኔ? ");
INSERT INTO gofENT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","ዶናራ ጌሊያባ ኡባይ ኡሎ ጌሊዲ ካሬ ኬዬይሳ ኤሬኬቲ? ");
INSERT INTO gofENT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","ሺን ዶናራ ኬያባይ ዎዛናፔ ኬዬስ። ኣሴ ቱኒሲያባቲ ሄሳታ። ");
INSERT INTO gofENT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","ኤንቲካ ኣሳ ዎዛና ጊዶፌ ኬያ ኢታ ቆፋ፥ ዎꬎ፥ ላይማቴꬂ፥ ኢታ ኦሶ፥ ካይሶ፥ ዎርዶ ማርካቴꬂ፥ ጫሼ። ");
INSERT INTO gofENT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","ሄሳ ዳኒያባቲ ኣሴ ቱኒሴሲፔ ኣቲን ሜጬቶና ኩሼራ ሜይሲ ቱኒሴና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","ሄሳፌ ጉዬ፥ ዬሱሲ ያፔ ኬዪዲ ፂሮሳኔ ሲዶና ካታማቲ ዴዒያ ቢታ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","ኢሲ ካናኔ ቢታ ማጫስ ዬሱሳኮ ያዳ፥ ባ ቃላ ꬎቁ ኦꬃዳ፥ «ጎዳው፥ ዳዊቴ ናዓው፥ ታው ቃꬌታርኪ፤ ታ ናዒው ቱና ኣያናይ ኦይኪዲ ኢታ ዋይሴስ» ያጋሱ። ");
INSERT INTO gofENT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","ሺን ዬሱሲ ኢሲ ቃላካ ዛሮና ሲዒ ጊስ። ዬሱሳ ታማሬቲ ኢያኮ ዪዲ፥ «ሃ ማጫሲያ ኑ ጌዶ ካላ ካላዳ፥ ዎሳዉሱ። ሄሳ ጊሾ፥ ኔኒ ኢዮ ሞይዛርኪ» ያጊዲ ዎሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","ዬሱሲ ዛሪዲ፥ «ታኒ ዉዴፔ ꬋዪዳ ዶርሳዳ ኢስራዔሌ ኬꬃፌ ꬋዪዳ ኣሳታ ፃላላስ ኪቴታስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","ሺን ኢያ፥ ኢያ ሲንꬃን ኩንዳዳ፥ «ጎዳው፥ ታና ማዳርኪ?» ያጋሱ። ");
INSERT INTO gofENT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","ኢ ዛሪዲ፥ «ናይታ ካꬂ ኤኪዲ ካናታስ ዬጌይሲ ሎዖ ጊዴና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","ማጫሲያካ፥ «ጎዳው፥ ሄሲ ቱማ፥ ሺን ሃሪ ኣቶሺን ካናቲ ባንታ ጎዳቲ ሚሺን፥ ጋይታፔ ዎꬊያ ቲፊያ ሞሶና» ያጋሱ። ");
INSERT INTO gofENT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","ዬሱሲ ዛሪዲ፥ «ሃ ማጫሴቴ፥ ኔ ኣማኖይ ጊታ፤ ኔ ኮዪዳይሳዳ ኔው ሃኖ» ያጊስ። ኢ ናዒያ ኢራካ ፓፃ ኣጋሱ። ");
INSERT INTO gofENT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","ዬሱሲ ያፔ ዴንዲዲ ጋሊላ ኣባ ማቲ ቢስ። ኢሲ ዴሬ ቦላ ኬዪዲ፥ ያን ኡቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","ዳሮ ኣሳይ ባንታራ፥ ዎቤታ፥ ቆቄታ፥ ኩናታ፥ ዶና ሙሜታኔ፥ ሃራ ዳሮ ሃርጋንቾታ ኤኪዲ፥ ኢያኮ ኤሂዲ ኢያ ሲንꬃን ዎꬂዶሶና። ዬሱሲ ኤንታና ፓꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","ሄሳ ጊሾ፥ ሙሜቲ ኦዴቲሺን፥ ኩናቲ ፒዲ ጊሺን፥ ዎቤቲ ሃሙቲሺን፥ ቆቄቲ ፄሊሺን ኣሳይ ቤዒዲ ማላሌቲዲ፥ ኢስራዔሌ ፆሳ ጋላቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","ዬሱሲ ባ ታማሬታ ባኮ ፄጊዲ፥ «ሃ ዳሮ ኣሳይ ታራ ሄꬑ ጋላስ ጋምዒዳ ጊሾኔ ኤንታው ሃዒ ሚያባይ ባይና ጊሾ ታኒ ኤንታው ቃꬌታይስ። ኤንቲ ኦጌን ዳቡሪዲ ኩንዶና ሜላ ኣይኮ ሙዞና ኤንታ ሜላ ዬዳናው ኮዪኬ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","ኢያ ታማሬቲ ዛሪዲ፥ «ኑኒ ሃ ባዙዋን ሃይሳ ኬና ኣሳስ ጊዲያ ካꬂ ኣዉፔ ዴማኔ?» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","ዬሱሲ ኤንታኮ፥ «ሂንቴው ኣፑን ኡይꬂ ዴዒ?» ያጊዲ ኦይቺስ። ኤንቲ ዛሪዲ፥ «ላፑን ኡይꬂኔ ላፋ ሞሎታፔ ጉꬂ ዴዔስ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","ዬሱሲ ዴሪያ ሳዓን ኡቲቴ ያጊዲ ኪቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","ሄሳፌ ጉዬ፥ ሄ ላፑን ኡይꬃኔ ሞሉዋ ኤኪዲ ፆሳ ጋላቲስ። ሜንꬂዲ ባ ታማሬታስ ኢሚስ። ኢያ ታማሬቲ ኣሳስ ጊሺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","ኣሳይ ኡባይ ሚዲ ካሊዶሶና። ኢያ ታማሬቲ፥ ሚሺን ኣቲዳ ቲፊያ ላፑን ጊታ ጋይታ ኩሜꬂ ዴንꬂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","ሚዳ ኣሳይ ማጫሲኔ ናዓ ፓይዶና ኣዴ ፃላሊ ኦይዱ ሙኩሉ። ");
INSERT INTO gofENT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","ዬሱሲ ዴሪያ ዬዲዳፔ ጉዬ ዎጎሉዋን ጌሊዲ ማጌዶና ጊያ ቢታ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","ፋሪሳዌቲኔ ሳዱቃዌቲ ዬሱሳኮ ዪዶሶና። ኢያ ፓጫናው ኮዪዲ፥ ባንታና ሳሎፔ ማላታ ቤሶ ጊዲ ኦይቺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","ሺን ኢ ኤንታኮ፥ «ሳዒ ኦማርሲያ ዎዴ ‹ሳሎይ ዞዒዳ ጊሾ ዎንቶ ቦቃላና› ያጌታ። ");
INSERT INTO gofENT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","ዎንቲያ ዎዴ፥ ‹ሳሎይ ዞዒዲ ሻራቲዳ ጊሾ ኢራይ ቡካና› ያጌታ። ያቲን ሂንቴ ሳሎ ማላ ቤዒዲ ኤሬታ፥ ሺን ዎዲያ ማላ ኤራናው ዳንዳዒቤኬታ። ");
INSERT INTO gofENT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","ኢታኔ ኣማኖና ዬሌቴꬃይ ማላታ ኮዬስ። ሺን ኢያው ዮናሳ ማላታፔ ሃራ ማላቲ ኢሜቴና» ያጊስ። ሄሳፌ ጉዬ፥ ኤንታና ያን ኣጊዲ ሃራ ሶ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","ኤንቲ ኣባፌ ሄፊንꬂ ፒኒዳ ዎዴ ዳቦ ኤኪዲ ያናይሳ ዶጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","ዬሱሲ ኤንታኮ፥ «ፋሪሳዌታፔኔ ሳዱቃዌታ ኢርሹዋፌ ናጌቲቴ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","ኤንቲካ ባንታ ጋርሳን፥ «ኢ ሄሳ ጊዳይ ኑ ዳቦ ኤኪዲ ዮና ጊሾሳ ጊዳና» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","ዬሱስ ኤንታ ቆፋ ኤሪዲ፥ «ሂንቴኖ፥ ኣማኖይ ፓጪዳይሳቶ! ዳቦ ኤኮና ዪዳ ጊሾ ዎሊ ጊዶን ኣይስ ኦዴቴቲ? ");
INSERT INTO gofENT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","ሃዒካ ሂንቴ ኣኬኬቲ? ኢቻሹ ሙኩሉ ኣሳስ ኢቻሹ ኡይꬃ ጊሺዳይሳኔ ኤንቲ ሚዲ ካሊን ሂንቴ ኣፑን ጋይታ ኩሜꬂ ዴንꬂዳኮ ዶጊዴቲ? ");
INSERT INTO gofENT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","ሄሳዳካ፥ ላፑን ኡይꬃ ኦይዱ ሙኩሉ ኣሳስ ጊሺዳይሳኔ ኤንቲ ሚዲ ካሊን፥ ሂንቴ ኣፑን ጊታ ጋይታ ኩሜꬂ ዴንꬂዳኮ ኣኬኬኬቲ? ");
INSERT INTO gofENT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","ሂዛ፥ ታኒ ፋሪሳዌታኔ ሳዱቃዌታ ኢርሹዋፌ ናጌቲቴ ጋዳ ኦዴይሲ ዳቦባ ጊዶናይሳ ኣኬኬኬቲ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","ያቲን፥ ኢያ ታማሬቲ ዬሱሲ ኦዴይ ሙኑቃ ዴንꬃናው ዬጌቲያ ኢርሾባ ጊዶናሺን ፋሪሳዌታኔ ሳዱቃዌታ ቲሚርቲያፌ ናጌታናይሳ ጊዴይሳ ኣኬኪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","ዬሱሲ ቂሳሪያ ፊልጶሳ ቢታ ጋኪዳ ዎዴ ባ ታማሬታኮ፥ «ኣሳይ፥ ኣሳ ናዓ ኦና ጎና?» ያጊዲ ኦይቺስ። ");
INSERT INTO gofENT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","ኤንቲካ፥ «ኢሶቲ ኢሶቲ ፃማቂያ ዮሃኒሳ፥ ሃራቲ ኤሊያሳ ቃሲ ሃንኮቲ ኤርሚያሳ ዎይኮ ናቤታፔ ኢሱዋ ጎሶና» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","ዬሱሲ ዛሪዲ፥ «ያቲን፥ ሂንቴ ታና ኦና ጌቲ» ጊዲ ኤንታ ኦይቺስ። ");
INSERT INTO gofENT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","ሲሞና ጴፂሮሲ ዛሪዲ፥ «ኔኒ ኪሪስቶሳ፥ ዴዖ ፆሳ ናዓ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","ዬሱሲ ጴፂሮሳኮ፥ «ዮና ናዓ ሲሞና፥ ኔኒ ኣንጄቲዳይሳ! ሃይሳ ኔው ቆንጪሲዳይ ሳሉዋን ዴዒያ ታ ኣዋፔ ኣቲን ኣሴ ጊዴና። ");
INSERT INTO gofENT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","ታ ኔው ኦዳይስ ጴፂሮሳ፥ ኔኒ ዛላ! ታኒ ሃ ዛላ ቦላ ታ ዎሳ ኬꬃ ኬፃና። ሃይቆ ዎልቃቲካ ኢዮ ፆኖኮና። ");
INSERT INTO gofENT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","ሳሎ ካዎቴꬃ ቁልፔታ ታ ኔው ኢማና። ሳዓን ኔኒ ዲጊያባይ ኡባይ ሳሎን ፆሳ ማታን ዲጌቲዳባ ጊዳና። ሳዓን ኔኒ ሃኖ ጊያባይ ኡባይ ሳሎን ፆሳ ማታን ሃኒዳባ ጊዳና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","ሄሳፌ ጉዬ፥ ኢ፥ ኪሪስቶሳ ጊዴይሳ ኦዴስካ ኦዶና ሜላ ባ ታማሬታ ሚንꬂዲ ኪቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","ሄ ዎዲያፔ ዶሚዲ ዬሱሲ ባ ታማሬታስ፥ «ታኒ ዬሩሳላሜ ባናው ቤሴስ። ያን ዴሪያ ጪማታን፥ ካሂኔ ሃላቃታኔ ሂጌ ኣስታማሬታ ኩሼን ዋዬ ኤካናው ቤሴስ። ኤንቲ ታና ዎꬋና፥ ሺን ታኒ ሄꬓንꬆ ጋላስ ሃይቆፔ ዴንዳና» ያጊዲ ቆንጪሲስ። ");
INSERT INTO gofENT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","ጴፂሮሲ ዬሱሳ ጋፃ ኬሲዲ፥ «ጎዳው፥ ሄሲ ሃኔና! ሄሳ ሜላባይ ኔና ኡባራካ ጋኮፎ!» ያጊዲ ሃንቄቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","ዬሱሲ ጴፂሮሳኮ ጉዬ ሲሚዲ፥ «ሃ ፃላሂያው፥ ታፔ ሃካ! ኔኒ ኣሳ ቆፋ ቆፓሳፔ ኣቲን ፆሳ ቆፋ ቆፖና ጊሾ ታው ꬉቤ ጊዳሳ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","ሄሳፌ ጉዬ፥ ዬሱሲ ባ ታማሬታኮ፥ «ኦኒካ ታና ካላናው ኮያባ ጊዲኮ ባና ካዶ፥ ባ ማስቃሊያ ቶኪዲ ታና ካሎ። ");
INSERT INTO gofENT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","ባ ዴዑዋ ኣሻናው ኮያ ኡባይ ꬋይሴስ። ሺን ባ ዴዑዋ ታ ጊሾ ጊዲ ኣꬂ ኢሜይሲ ኣሼስ። ");
INSERT INTO gofENT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","ኣሲ ኣላሜ ኩሜꬃ ባባ ኦꬂዲ፥ ጊዶሺን ባ ሼምፑዋ ꬋይሲኮ ኢያ ኣይ ማዲ? ዎይኮ ኣሲ ባ ሼምፑዋ ላሜ ኣይ ኢማናው ዳንዳዒ? ");
INSERT INTO gofENT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","ኣሳ ናዓይ ባ ኣዋ ቦንቹዋን ባ ኪታንቾታራ ያና። ሄ ዎዴ ኢሲ ኢሲ ኡራስ ኢያ ኦሱዋዳ ኢማና። ");
INSERT INTO gofENT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","ታ ቱማ ኦዳይስ፤ ኣሳ ናዓይ ካዎ ጊዲዲ ሲሜይሳ ቤዓና ጋካናው ሃይሳን ኤቂዳ ኣሳፔ ሃይቆናይሳቲ ዴዖሶና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","ኡሱፑን ጋላሳፔ ጉዬ ዬሱሲ፥ ጴፂሮሳ፥ ያይቆባኔ ኢያ ኢሻ ዮሃኒሳ ባራ ኤኪዲ ባንታርካ ጊዳናው ዴሪያ ቦላ ኬዪስ። ");
INSERT INTO gofENT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","ያን ኤንታ ሲንꬃን ዬሱሳ ማላይ ኩሜꬂ ላሜቲስ፤ ኢያ ሶምዖይካ ኣዋዳ ፆልቂስ። ኢያ ማዖይካ ዳሮ ቦፂስ። ");
INSERT INTO gofENT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","ሄኮ፥ ሙሴይኔ ኤሊያሲ ኢያራ ኦዴቲሺን ቤዒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","ጴፂሮሲ ዬሱሳኮ፥ «ኑኒ ሃይሳ ሃሹ ዪዳ። ኔ ኮይኮ ኢሲኖ ኔው፥ ኢሲኖ ሙሴስ፥ ኢሲኖ ኤሊያሳስ ሃይሳን ሄꬑ ሻቃራ ሻቃራና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","ጴፂሮሲ ሄሳ ቡሮ ኦዲሺን ቦꬃ ሻራይ ኤንታና ካሚስ። ሻራ ጊዶራ፥ «ታና ኡፋይሲያ፥ ታ ዶሲያ ናዓይ ሃይሳ፥ ኢያ ሲዒቴ!» ያጊያ ቃላይ ዪስ። ");
INSERT INTO gofENT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","ዬሱሳ ታማሬቲ ሄሳ ሲዒዳ ዎዴ ዳጋሚዲ ባንታ ሶምዑዋራ ሳዓን ኩንዲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","ሺን ዬሱሲ ኤንታኮ ሺቂዲ ኤንታ ቦቺዲ፥ «ዴንዲቴ፥ ያዮፊቴ!» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","ኤንቲ ꬎቁ ጊዲ ቤዒያ ዎዴ ዬሱሳፔ ሃራ ኦናካ ቤዒቦኮና። ");
INSERT INTO gofENT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","ኤንቲ ዴሪያፔ ዎꬊሺን ዬሱሲ ኤንታኮ፥ «ኣሳ ናዓይ ሃይቆፔ ዴንዳና ጋካናው ሃ ሂንቴ ቤዒዳባ ኦዴስካ ኦዶፒቴ» ጊዲ ኪቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","ዬሱሳ ታማሬቲ፥ «ያቲን፥ ሂጌ ኣስታማሬቲ ኤሊያሲ ኪሪስቶሳፔ ካሴቲዲ ያና ጊዳይ ኣይቢሴ?» ያጊዲ ኦይቺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","ዬሱሲ ዛሪዲ፥ «ኤ! ኤሊያሲ ካሴቲ ዪዲ ኡባባ ጊጊሳና። ");
INSERT INTO gofENT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","ሺን ታ ሂንቴው ቱማ ኦዳይስ፤ ኤሊያሲ ካሴቲዲ ዪስ። ኤንቲካ ኢያ ቦላ ኮዪዳባ ኦꬂዶሶናፔ ኣቲን ኢያ ሻኪ ኤሪቦኮና። ሄሳዳ ኣሳ ናዓይ ኤንታ ኩሼን ዋዬታና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","ሄ ዎዴ ዬሱሲ ጊዳይ ፃማቂያ ዮሃኒሳባ ጊዴይሳ ኣኬኪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","ኤንቲ ዴሪያፔ ኣሳኮ ሲሚያ ዎዴ ኢሲ ኣሲ ዬሱሳ ሲንꬃን ጉልባቲዲ፥ ");
INSERT INTO gofENT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","«ጎዳው፥ ሃያና ታ ናዓስ ቃꬌታርኪ፤ ኢያ ሾጪዲ ዬጊያ ሃርጌይ ዳሮ ኡንዔꬂዲ ታማኒኔ ሃꬃን ዬጌስ። ");
INSERT INTO gofENT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","ኔ ታማሬታኮ ኤሃስ፥ ሺን ኤንቲ ፓꬃናው ዳንዳዒቦኮና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","ዬሱሲ ዛሪዲ፥ «ሂንቴኖ፥ ኣማኖና ጌላ ዬሌቴꬃው ኣዉዴ ጋካናው ታ ሂንቴራ ዳኔ? ኣዉዴ ጋካናው ታ ሂንቴና ዳንዳዓኔ? ኣኔ ናዓ ሃ ኤኪ ዪቴ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","ዬሱሲ ቱና ኣያና ሃንቂን፥ ቱና ኣያናይ ናዓፔ ኬዪስ፤ ሄ ሳቴንካ ናዓይ ፓፂስ። ");
INSERT INTO gofENT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","ሄሳፌ ጉዬ፥ ዬሱሳ ታማሬቲ ባንታርካ ኢያኮ ሺቂዲ፥ «ኑኒ ቱና ኣያና ኬሳናው ዳንዳዒቦናይ ኣይቢሴ?» ያጊዲ ኦይቺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","ኢ ኤንታኮ፥ «ሂንቴው ኣማኖይ ላፊዳ ጊሾሳ። ታ ሂንቴው ቱማ ኦዳይስ፤ ጋሼ ኣይፌ ሜላ ኣማኖይ ሂንቴው ዴዒኮ ‹ሃ ዴሪያ ሃይሳፌ ዴንዳዳ ጌዴ ኣꬋ› ጊኮ ሂንቴው ኪቴታና። ሂንቴው ዳንዳዔቶናባይ ዴና። ");
INSERT INTO gofENT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","ሺን ሄሳ ሜላይ ዎሳፔኔ ፆማፔ ኣቲን ሃራን ኬዬና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","ዬሱሳ ታማሬቲ ጋሊላን ሺቂዲ ዴዒሺን ዬሱሲ ኤንታኮ፥ «ኣሳ ናዓይ ኣሳ ኩሼን ኣꬊዲ ኢሜታና። ");
INSERT INTO gofENT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ኤንቲ ኢያ ዎꬋና፥ ሺን ኢ ሄꬓንꬆ ጋላስ ሃይቆፔ ዴንዳና» ያጊስ። ኢያ ታማሬቲካ ዳሮ ቂሮቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","ዬሱሳራኔ ኢያ ታማሬታራ ቂፊርናሆሜ ካታማ ጋኪዳ ዎዴ ፆሳ ኬꬃ ጊራ ቃንፂሴይሳቲ ጴፂሮሳኮ ዪዲ፥ «ሂንቴ ኣስታማሬይ ፆሳ ኬꬃ ጊራ ጊሪ?» ያጊዲ ኦይቺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","ጴፂሮሲ ዛሪዲ፥ «ጊሬስ» ያጊስ። ጴፂሮሲ ሶ ጌሊያ ዎዴ ዬሱሲ ካሴቲዲ፥ «ጴፂሮሳ፥ ኔው ኣይ ዳኒ? ሃ ሳዓ ካዎቴꬃቲ ቃራፃኔ ጊራ ኦፔ ኤኮና? ጋዴ ኣሳፔዬ ዎይኮ ኣሳ ጋዴ ኣሳፔ?» ያጊዲ ኦይቺስ። ");
INSERT INTO gofENT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","ጴፂሮሲ «ኣሳ ጋዴ ኣሳፔ» ጊዲ ዛሪስ። ዬሱሲ ዛሪዲ፥ «ጋዴ ኣሳይ ጊራ ጊሮኮና ጉሱ። ");
INSERT INTO gofENT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","ሺን ኤንቲ ꬉቤቶና ሜላ ኣባ ባዳ ሞሉዋ ኦይኪያ ማንፃቆ ዬጋ። ኮይሮ ኔ ኦይኪያ ሞሉዋ ዶና ዶያዳ ጊራስ ጊዲያ ሚሺያ ኔ ጊሾኔ ታ ጊሾ ኤፋዳ ጊራ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","ሄ ዎዴ ዬሱሳ ታማሬቲ ዪዲ፥ «ሳሎ ካዎቴꬃን ኡባፌ ኣꬌይ ኦኔ?» ያጊዲ ኦይቺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","ዬሱሲ ኢሲ ጉꬃ ናዓ ፄጊዲ ኤንታ ጊዶን ኤሲዲ ሃይሳዳ ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","«ታኒ ሂንቴው ቱማ ኦዳይስ፤ ሂንቴ ላሜቶናኔ ጉꬃ ናይታዳ ሃኖና ኢፂኮ ሳሎ ካዎቴꬃ ኡባራካ ጌላናው ዳንዳዔኬታ። ");
INSERT INTO gofENT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","ሂዛ፥ ሃ ጉꬃ ናዓዳ ባና ካዉሺያ ኦኒካ ሳሎ ካዎቴꬃን ኡባፌ ኣꬌይሳ ጊዳና። ");
INSERT INTO gofENT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","ሃይሳ ሜላ ናዓ ታ ሱንꬃን ሞኪያ ኦኒካ ታና ሞኬስ። ");
INSERT INTO gofENT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","«ሺን ታናን ኣማኒያ ሃ ጉꬃታፔ ኢሱዋ ናጋራ ኦꬃና ሜላ ꬉቤ ጊዲያ ኦኒካ ጊታ ጋቻ ዎፃ ባ ቆꬌን ቃቺዲ ጪሞ ኣባን ሚቴቲኮ ኢያው ሎዖ። ");
INSERT INTO gofENT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","ኣላሜን ኣሳይ ናጋራ ኦꬃና ሜላ ኦꬂያባቲ ዴዒያ ጊሾ ኣላሚያ ኣዬ። ሄሳ ሜላባቲ ዮና ኣቴና፥ ሺን ꬉቤይ ኢያ ጋሶን ያ ኡራ ኣዬ። ");
INSERT INTO gofENT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","«ኔ ኩሼይ ዎይኮ ኔ ቶሆይ ኔና ባሌꬂኮ ኔፔ ቃንፃ ዬጋ። ኔኒ ናምዑ ኩሼራ ዎይኮ ናምዑ ቶሆራ ሜሪና ታማን ዬጌታናይሳፌ ኩሼ ዎይኮ ቶሆ ዱፃ ጊዳዳ ሜሪና ዴዖ ዴሜይሲ ኔው ሎዖ። ");
INSERT INTO gofENT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","ቃሲ ኔ ኣይፌይ ኔና ባሌꬂኮ ኢዮ ዎጫ ኬሳዳ ዎራ ሆላ። ኔኒ ናምዑ ኣይፌራ ጋናሜ ታማን ዬጌቴይሳፌ ኢሲ ኣይፌራ ሜሪና ዴዑዋ ጌሌይሲ ኔው ሎዖ። ");
INSERT INTO gofENT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","«ታ ሂንቴው ኦዳይስ፤ ሳሎን ዴዒያ ኤንታ ናጊያ ኪታንቾቲ ኡባ ዎዴ ሳሎን ዴዒያ ታ ኣዋ ሲንꬃን ዴዒያ ጊሾ ሂንቴ ሃ ጉꬃታፔ ኢሱዋካ ካꬎና ሜላ ናጌቲቴ። ");
INSERT INTO gofENT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","ኣሳ ናዓይ ꬋይዳይሳታ ኣሻናው ዪስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","ቃሲ ዬሱሲ፥ «ሂንቴው ኣይ ዳኒ? ኢሲ ኡራስ ፄቱ ዶርሳቲ ዴዔይሳታፔ ኢሶይ ꬋዪኮ ኡዱፉን ታማኔ ኡዱፉናታ ዴሪያ ቦላ ዬጊ ኣጊዲ ሄ ꬋዪዳይሳ ኮያናው ቤኔ? ");
INSERT INTO gofENT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","ታ ቱማ ኦዳይስ፤ ኢ ዴሚዳ ዎዴ ኡዱፉን ታማኔ ኡዱፉናታፔ ኣꬂዲ ꬋዪዲ ቤንቲዳ ኢሲ ዶርሳን ኡፋይቴስ። ");
INSERT INTO gofENT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","ሄሳዳካ፥ ሳሎን ዴዒያ ሂንቴ ኣዋይ ሃ ጉꬃታፔ ኢሶይ ꬋያና ሜላ ኮዬና። ");
INSERT INTO gofENT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","«ኔ ኢሻይ ኔና ቆሂኮ ኔርካ ኢያኮ ባዳ ኢያ ባላ ኢያው ኦዳ። ኢ ኔና ሲዒኮ ኔ ኢሻ ኔው ኢሻ ኦꬃ። ");
INSERT INTO gofENT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","ሺን ኢ ኔና ሲዖና ኢፂኮ፥ ናምዑ ዎይኮ ሄꬑ ኣሳ ማርካን ሞቶይ ላሴቲያ ጊሾ ኢሲ ዎይኮ ናምዑ ኣሲ ኤካዳ ኢያኮ ባ። ");
INSERT INTO gofENT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","ኢ ኤንታና ሲዖና ኢፂኮ፥ ዎሳ ኬꬃስ ኦዳ። ዎሳ ኬꬂ ጊያባ ሲዖና ኢፂኮ ኣማኖና ኣሳዳ ዎይኮ ቃራፃ ቃንፂሲያ ኣሳዳ ኢያ ፓይዳ። ");
INSERT INTO gofENT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","«ታ ሂንቴው ቱማ ኦዳይስ፤ ሳዓን ሂንቴ ዲጊያባቲ ኡባይ ሳሎን ፆሳ ማታን ዲጌቲዳባ ጊዳና። ሳዓን ሂንቴ ሃኖ ጊያባቲ ኡባይ ሳሎን ፆሳ ማታን ሃኒዳባ ጊዳና። ");
INSERT INTO gofENT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","«ቃሲካ ታ ሂንቴው ኦዳይስ፤ ሳዓን ሂንቴፌ ናምዓይ ባንታ ዎሲያባስ ኢሲ ዎዛናን ጊዲዲ ፆሳ ዎሲያባ ጊዲኮ ሳሎን ዴዒያ ታ ኣዋይ ሂንቴው ኦꬃና። ");
INSERT INTO gofENT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","ታና ካሌይሳታፔ ናምዓ ዎይኮ ሄꬓ ጊዲዲ ሺቂያ ቤሳን ታኒ ኤንታ ጊዶን ቤንታና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","ሄ ዎዴ ጴፂሮሲ ዬሱሳኮ ዪዲ፥ «ጎዳው፥ ታ ኢሻይ ታና ቆሂኮ ኣፑን ቶሆ ታኒ ኣቶ ጋናው ቤሲ? ላፑን ቶሆ ጋካናሴዬ?» ጊዲ ኦይቺስ። ");
INSERT INTO gofENT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","ዬሱሲ ዛሪዲ፥ «ጊዴና፥ ላፑን ታሙ ቶሆ ላፑናፔ ኣቲን ላፑን ቶሆ ጊዴና። ");
INSERT INTO gofENT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","«ሄሳ ጊሾ፥ ፆሳ ካዎቴꬃይ ባ ኦሳንቾታራ ባ ሚሼይ ፓጪዳኮኔ ፓላሂዳኮ ቤዓናው ቆፒዳ ካዉዋ ዳኔስ። ");
INSERT INTO gofENT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","ሄ ካዎይ ሚሼይ ፓጪዳኮኔ ፓላሂዳኮ ቤዒያ ዎዴ ዳሮ ጊንዲጊንዳ ኣጮይ ዴዒያ ኢሲ ኡራ ኢያኮ ኤሂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","ሺን ሄ ኣይሌይ ኣጩዋ ቃንፃናው ፆኔቲን ኢያራ፥ ኢያ ማቼራ፥ ኢያ ናይቲኔ ኢያው ዴዒያባይ ኡባይ ባይዜቲዲ ኣጮይ ጪጌታና ሜላ ኢያ ጎዳይ ኪቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","ያቲን ኣይሌይ ባ ጎዳ ቶሁዋ ቦላ ጉልባቲዲ፥ ‹ታ ጎዳው፥ ሃያና ጉꬃ ዎዴ ታካርኪ፥ ታ ኣጩዋ ኡባ ታ ጪጋና› ያጊዲ ዎሲስ። ");
INSERT INTO gofENT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","ካዎይ ኢያው ቃꬌቲዲ፥ ዬዲ ኣጊስ፤ ኢያ ኣጩዋ ማሪስ። ");
INSERT INTO gofENT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","«ሺን ሄ ኣይሌይ ኬዪ ቢዲ ባ ላጌ ኦሳንቾታፔ ኢሶይ ባፔ ዳሮ ጉꬃ ሚሼ ታልዒዳይሳ፥ ‹ኔ ቦላ ዴዒያ ታ ሚሺያ ታው ጪጋ› ጊዲ ቆꬌ ኦይኪስ። ");
INSERT INTO gofENT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","«ሄ ኢያ ላጌ ኣይሌይ ኢያ ሲንꬃን ጉልባቲዲ፥ ‹ሃያና ጉꬃ ዎዴ ታካርኪ ታኒ ታ ኣጩዋ ኡባ ጪጋና› ያጊዲ ዎሲስ። ");
INSERT INTO gofENT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","«ሺን ኢፂዲ ኤኪ ኤፊዲ ባ ላጌይ ኣጩዋ ቃንፃና ጋካናው ቃሾ ኬꬂ ጌልሲስ። ");
INSERT INTO gofENT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","ሄሳ ጊሾ፥ ሃራ ላጌ ኦሳንቾቲ ሄሳ ቤዒዳ ዎዴ ዳሮ ዪሎቲዲ፥ ቢዲ ባንታ ጎዳስ ኢ ኦꬂዳባ ኡባ ኦዲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","«ያቲን ካዎይ ሄ ኣይሊያ ፄጊሲዲ፥ ‹ሃ ኢታ ኣይሊያው፥ ኔኒ ታና ዎሲዳ ጊሾ ታ ኔ ኣጩዋ ኡባ ኔው ማራስ። ");
INSERT INTO gofENT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","ያቲን፥ ታኒ ኔ ኣጩዋ ማሪዳይሳዳ ኔኒ ኔ ላጌ ኣይሊያ ኣጩዋ ማራናው ኔው ቤሴኔ?› ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","ሄሳ ጊሾ፥ ካዎይ ዳሮ ዪሎቲዲ፥ ኢ ባ ኣጩዋ ኡባ ጪጋና ጋካናው ፓፃ ካዔታና ሜላ ቃሾ ኬꬃን ዬጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","«ሄሳዳካ፥ ሂንቴ ኢሶይ ኢሶይ ሂንቴ ኢሻ ዎዛናፔ ማሮና ኢፂኮ ሳሎን ዴዒያ ታ ኣዋይ ሂንቴና ሄሳዳ ኦꬃና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","ዬሱሲ ሄሳ ኦዲ ኦንጊዳፔ ጉዬ ጋሊላፔ ዴንዲዲ ዮርዳኖሴ ሻፋፔ ሄፊንꬃን ዴዒያ ዪሁዳ ቢታ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","ዳሮ ኣሳይ ኢያ ካሊዲ ቢን ኤንታ ጊዶፌ ሃርጋንቾታ ፓꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","ፋሪሳዌቲ ኢያ ፓጫናው ኮዪዲ ኢያኮ ዪዲ፥ «ኢሲ ኣሲ ኣይ ጋሶንካ ባ ማቺው ዬዳናው ቤሲ?» ያጊዲ ኦይቺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","ዬሱሲ ዛሪዲ፥ «ፆሳይ ኮይሮ ኣዴኔ ማጫስ ኦꬂ ሜꬊዳይሳ ሂንቴ ናባቢቤኬቲ? ");
INSERT INTO gofENT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","‹ሄሳ ጊሾ፥ ኢሲ ኣሲ ባ ኣዋኔ ባ ኣዪው ኣጊዲ ባ ማቼራ ኢሲኖ ጊዴስ፥ ናምዓይካ ኢሲ ኣሾ ጊዶሶና።› ");
INSERT INTO gofENT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","ሄሳ ጊሾ፥ ኤንቲ ኢሲ ኣሾ ጊዶሶናፔ ኣቲን ናምዓ ጊዶኮና። ሂዛ፥ ፆሲ ቃቺዳይሳ ኣሲ ሻኮፎ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","ፋሪሳዌቲ፥ «ያቲን፥ ሙሴይ ኢሲ ኣሲ ኣንጆ ዎርቃቴ ኢሚዲ ዬዳና ሜላ ኣይስ ኪቲዴ?» ያጊዲ ኦይቺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","ዬሱሲ ዛሪዲ፥ «ሂንቴ፥ ሂንቴ ማቼታ ዬዳና ሜላ ሙሴይ ሂንቴና ኪቲዳይ፥ ሂንቴ ዎዛና ሚኖቴꬃ ጊሾፔ ኣቲን ኮይሮፔ ሄሳ ሜላ ጊዴና። ");
INSERT INTO gofENT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","ታ ሂንቴው ኦዳይስ፤ ባ ማቺያ ላይማቶና ዴዒሺን ዬዲዲ ሃራ ኤኪያ ኦኒካ ላሜስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","ኢያ ታማሬቲ ኢያኮ፥ «ኣዚናባይኔ ማቺባይ ሄሳ ሜላ ጊዲኮ ኤኮ ጌሎይ ኣቲኮ ሎዖ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","ዬሱሲ ዛሪዲ፥ «ሄሳ ሜላ ቲሚርቴይ ፆሳይ ዳንዳዓ ኢሚዳይሳታሳፌ ኣቲን ኣሳ ኡባሳ ጊዴና። ");
INSERT INTO gofENT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","ሂዛ፥ ዬሌቲሼ ሹፋ ጊዲዲ ዬሌቲዳይሳቲ ዴዖሶና፥ ቃሲ ኣሲ ቃራቲዳይሳቲ ዴዖሶና፥ ቃሲ ሳሎ ካዎቴꬃ ጊሾ ጊዲ ባንታና ሹፋይዳይሳቲ ዴዖሶና። ሄሳ ጊሾ፥ ሃይሳ ኤካናው ዳንዳዒያ ኦኒካ ኤኮ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","ዬሱሲ ባ ኩሺያ ጉꬃ ናይታ ቦላ ዎꬂዲ ኤንታው ዎሳና ሜላ ኢሲ ኢሲ ኣሳይ ናይታ ኢያኮ ኤሂዶሶና። ሺን ኢያ ታማሬቲ ኣሳ ሃንቄቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","ሺን ዬሱሲ፥ «ፆሳ ካዎቴꬃይ ሃይሳታ ሜላሳ ጊዲያ ጊሾ ጉꬃ ናይቲ ታኮ ዬይሳ ዲጎፊቴ፤ ዮ ጊቴ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","ባ ኩሺያ ኤንታ ቦላ ዎꬂዳፔ ጉዬ ሄ ቤሳፌ ኣጊዲ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","ኢሲ ጋላስ ኢሲ ኡራይ ዬሱሳኮ ዪዲ፥ «ኣስታማሪያው፥ ታኒ ሜሪና ዴዖ ዴማናው ኣይ ሎዖባ ኦꬆ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","ዬሱሲ ኢያኮ፥ «ሎዖባ ኔ ታና ኣይስ ኦይቻይ? ኢሲ ፆሳፌ ኣቲን ሃሪ ሎዖይ ባዋ። ሺን ኔኒ ሜሪና ዴዑዋ ኤካናው ኮይኮ ኪታታ ናጋ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","ኡራይ ዛሪዲ፥ «ኣዉሳ ኪታታ» ያጊዲ ኦይቺስ። ዬሱሲ ዛሪዲ፥ «ዎꬎፓ፥ ላይማቶፓ፥ ካይሶቶፓ፥ ዎርዶ ማርካቶፋ፥ ");
INSERT INTO gofENT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ኔ ኣዋኔ ኔ ኣዪው ቦንቻ፥ ኔ ሾሩዋ ኔ ሁዒያꬆ ዶሳ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","ሄ ናዓቴꬃይ፥ «ታኒ ሃይሳታ ኡባ ናዓቴꬃፌ ዶማዳ ናጋስ። ያቲን፥ ሃሪ ታው ፓጪያባይ ኣይቤ?» ያጊዲ ኦይቺስ። ");
INSERT INTO gofENT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","ዬሱሲ ዛሪዲ፥ «ኔኒ ፖሎ ጊዳናው ኮይኮ ባዳ ኔው ዴዒያባ ባይዛዳ ማንቆታስ ኢማ፤ ኔኒ ሳሎን ዱሬታና። ያታ ሲማ ያዳ ታና ካላ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","ሺን ሄ ናቴꬃ ኡራይ ዳሮ ዱሬ ጊዲያ ጊሾ ሄሳ ሲዒዳ ዎዴ ኣዛኒሼ ኣጊዲ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","ሄሳፌ ጉዬ፥ ዬሱሲ ባ ታማሬታ፥ «ታኒ ሂንቴው ቱማ ኦዳይስ፤ ዱሬይ ሳሎ ካዎቴꬂ ጌላናይሲ ዳሮ ሜቶ። ");
INSERT INTO gofENT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","ዱሬ ኣሲ ፆሳ ካዎቴꬃ ጌላናይሳፌ ጊማሌይ ማርፔ ሉሆራ ኣꬌይሲ ካዉዬስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","ዬሱሳ ታማሬቲ ሄሳ ሲዒዲ ማላሌቲዲ፥ «ያቲን፥ ኦኒ ኣታናው ዳንዳዒ?» ያጊዲ ኦይቺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","ዬሱሲ ኤንታ ጫዲ ፄሊዲ፥ «ሃይሲ ኣሳስ ዳንዳዔቴና፥ ሺን ፆሳስ ኡባይ ዳንዳዔቴስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","ጴፂሮሲ ዛሪዲ፥ «ኑኒ ኡባባ ኣጊዲ ኔና ካሊዳ። ያቲን፥ ኑኒ ኣይ ዴማኔ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","ዬሱሲ ኤንታኮ ሃይሳዳ ያጊስ፡ «ታኒ ሂንቴው ቱማ ኦዳይስ፤ ኣሳ ናዓይ ያና ኣላሚያን ባ ቦንቾ ኣራታን ኡቲያ ዎዴ ሂንቴ ታማኔ ናምዓቲ፥ ታና ካሊዳይሳቲ፥ ታማኔ ናምዑ ኣራታን ኡቲዲ ታማኔ ናምዑ ኢስራዔሌ ዜሬꬃታ ቦላ ፒርዳና። ");
INSERT INTO gofENT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","ታ ሱንꬃ ጊሾ ኬꬄ ዎይኮ ኢሻታ ዎይኮ ሚቼታ ዎይኮ ኣዋ ዎይኮ ኣዪው ዎይኮ ናይታ ዎይኮ ጋዲያ ኣጊዳይ ኦኒካ ፄቱ ኩሼ ኤካና። ቃሲ ሜሪና ዴዑዋካ ኤካና። ");
INSERT INTO gofENT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","ሺን ዳሮቲ ሃዒ ዴꬃን ሲንꬄ ጊዲዳይሳቲ ጉዬ ጊዳና፥ ቃሲ ጉዬ ጊዲዳይሳቲ ሲንꬄ ጊዳና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","«ፆሳ ካዎቴꬃይ ባ ዎይኒያ ጊዶን ኦሳንቾታ ኬራ ኦሲሳናው ዎንታ ጉራ ኬዪዳ ኬꬃዋ ዳኔስ። ");
INSERT INTO gofENT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","ኢ ሄ ኦሳንቾታስ ሃቺ ሃቺ ኢሲ ዲናሬ ቃንፃናው ኤንታራ ጊጊዲ፥ ኤንታ ባ ዎይኒያ ጊዶ ዬዲስ። ");
INSERT INTO gofENT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","«ቃሲ ዎንታፌ ሄꬑ ሳቴ ጊዲሺን ኬዪዲ ኦሶ ꬋዪዲ ጊያ ቦላ ኤቂዳ ሃራ ኣሳታ ዴሚስ። ");
INSERT INTO gofENT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","ኢ ኤንታኮ፥ ‹ሂንቴካ ታ ዎይኒያ ጊዶ ቢዲ ኦꬂቴ፥ ታኒ ሂንቴው ቤሲያ ጋቲያ ቃንፃና› ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","ኤንቲካ ቢዶሶና። ቃሲካ ኢ ኡሱፑን ሳቴኒኔ ኡዱፉን ሳቴን ኬዪዲ ሄሳዳ ኦꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","ታማኔ ኢሲ ሳቴ ጊዲሺን ኢ ኬያ ዎዴ ሃራቲ ያን ኤቂዳይሳታ ዴሚዲ፥ ‹ሂንቴ ኦሶ ኦꬆና ጋላስ ኩሜꬂ ሃይሳን ኣይስ ኤቂዲ ፔዒዴቲ?› ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","«ኤንቲ ዛሪዲ፥ ‹ኑና ኬራ ኦሲሲያ ኣሲ ꬋዪዳ ጊሾሳ› ያጊዶሶና። «ኢካ፥ ‹ሂንቴካ ታ ዎይኒያ ጊዶ ቢዲ ኦꬂቴ› ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","«ሳዒ ኦማርሲን፥ ዎይኒያ ጎዳይ ኦሳንቾታ ሃላቃኮ፥ ‹ኦሳንቾታ ፄጋዳ ዉርሴꬃን ኦሶ ጌሊዳይሳታፔ ዶማዳ ኮይሮ ጌሊዳይሳታ ጋካናው ኤንታ ጋቲያ ቃንፃ› ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","ታማኔ ኢሲ ሳቴን ኦሶ ኦይኪዳይሳቲ ዪዲ፥ ሁዔን ሁዔን ኢሲ ኢሲ ዲናሬ ኤኪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","ኮይሮ ኦሶ ኦይኪዳይሳቲ ዪዲ፥ ባንታው ዳሮ ኢሜታና ጊዲ ቆፒዶሶና። ሺን ኤንቲካ ሁዔን ሁዔን ኢሲ ኢሲ ዲናሬ ኤኪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","ባንታ ሚሺያ ኤኪ ሲሚዲ ኬꬃዋ ቦላ ዙዙሚዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‹ሃይሳቲ ጉዬፔ ዪዲ ኢሲ ሳቴ ፃላላ ኦꬂዶሶና። ሺን ጋላስ ኩሜꬂ ኣዋ ሱላን ዳቡሪዲ ፔዒዳ ኑራ ኤንቲ ዋኒዲ ኢሲኖ ጊዶና› ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","«ዎይኒያ ኬꬃዋይ ኦሳንቾታፔ ኢሱዋኮ፥ ‹ታ ኢሻው፥ ታኒ ኔና ቆሃቢኬ፤ ኔ ታራ ጊጊዳይ ኢሲ ዲናሬሳ ጊዴኔ? ");
INSERT INTO gofENT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","ኔ ሚሺያ ኤካዳ ኔ ሶ ባ። ታ ኦማርሲ ዪዳይሳስካ ኔይሳ ሜላ ኢማናው ኮያይስ። ");
INSERT INTO gofENT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","ታኒ ታ ሚሺያን ኮዪዳባ ኦꬃናው ታው ማቲ ባዌ? ዎይኮ ታኒ ኬሃ ጊዲዳ ጊሾ ኔኒ ቃናታይ?› ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","«ሄሳዳ ሃዒ ዴꬃን ጉዬ ጊዲዳይሳቲ ሲንꬃታና፥ ሲንꬃቲዳይሳቲ ቃሲ ጉዬታና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","ዬሱሲ ዬሩሳላሜ ቢሼ፥ ታማኔ ናምዑ ታማሬታ ዱማ ጋፃ ኬሲዲ ኤንታኮ ያጊስ፡ ");
INSERT INTO gofENT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«ሄኮ፥ ኑኒ ሃዒ ዬሩሳላሜ ቡሳ ቦላ ዴዖስ። ያን ኣሳ ናዓይ ካሂኔ ሃላቃታሲኔ ሂጌ ኣስታማሬታስ ኣꬊ ኢሜታና። ኤንቲካ ኢያ ቦላ ሃይቆ ፒርዳ ፒርዳና። ");
INSERT INTO gofENT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ኢያ ኣይሁዴ ጊዶና ዴሪያስ ኣꬂ ኢማና። ኤንቲ ኢያ ካዉሻና፥ ጋራፋና፥ ያቲዲ ኢያ ማስቃሊያ ቦላ ካቃና። ሺን ኢ ሄꬓንꬆ ጋላስ ሃይቆፔ ዴንዳና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","ሄ ዎዴ ዛብዲዮሳ ማቺያ ባ ናምዑ ኣዴ ናይታራ ዬሱሳኮ ያዳ፥ ኢያ ሲንꬃን ጉልባታዳ ኢሲባ ኢያ ዎሳሱ። ");
INSERT INTO gofENT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","ዬሱሲ ኢኮ፥ «ኔ ኣይ ኮያይ?» ያጊስ። ኢያ ዛራዳ፥ «ኔ ካዎቴꬃን ሃ ታ ናምዑ ናይቲ ኢሶይ ኔ ኡሻቻን ኢሶይ ኔ ሃዲርሳን ኡቶ ጋርኪ!» ያጋሱ። ");
INSERT INTO gofENT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","ሺን ዬሱሲ ናይታኮ ዛሪዲ፥ «ሂንቴ ኣይ ዎሲያኮ ኤሬኬታ፤ ታኒ ኡያናው ዴዒያ ዋዬ ፁዓ ኡያናው ዳንዳዔቲ?» ያጊስ። ኤንቲካ፥ «ኤ ዳንዳዖስ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","ዬሱሲ፥ «ቱማካ ታኒ ኡያናው ዴዒያ ፁዓፔ ሂንቴ ኡያና። ሺን ታ ኡሻቻኒኔ ሃዲርሳን ኡታናይሳታ ዶሬይ ታና ጊዲኬ። ሄ ቤሳይ ኢሜቴይ፥ ታ ኣዋይ ኢማናው ጊጊሲዳ ኣሳታሳ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","ኣቲዳ ታሙ ኢያ ታማሬቲ ሄሳ ሲዒዳ ዎዴ ናምዑ ኢሻታ ቦላ ሃንቄቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","ሺን ዬሱሲ ኤንታ ኡባ ፄጊዲ ሃይሳዳ ያጊስ። «ኣይሁዴ ጊዶና ኣሳ ሃሬይሳቲ ባንታ ኣሳ ቦላ ጎዳቴይሳኔ ኤንታ ካሌꬄይሳቲ ዎልቃን ሃሬይሳ ሂንቴ ኤሬታ። ");
INSERT INTO gofENT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","ሺን ሂንቴ ጊዶን ሄሳዳ ጊዶፖ። ሂንቴፌ ጊታታናው ኮያ ኦኒካ ሂንቴው ኣይሌ ጊዶ። ");
INSERT INTO gofENT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ሂንቴ ጊዶን ኡባፌ ቦላ ጊዳናው ኮያ ኦኒካ ሂንቴው ኣይሌ ጊዳናው ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","ሄሳዳካ፥ ኣሳ ናዓይ ኣሴ ሃጋዛናዉኔ ዳሮ ኣሳ ዎዛናው ባ ሼምፑዋ ኢማናው ዪሲፔ ኣቲን ኣሳን ሃጋዜታናው ዪቤና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","ሄሳፌ ጉዬ፥ ዬሱሲ ባ ታማሬታራ ኢያርኮፌ ኬዪዲ ቢሺን፥ ዳሮ ኣሳይ ኤንታና ካሊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","ኦጌ ጋፃን ኡቲዳ ናምዑ ቆቄቲ ዬሱሲ ያራ ኣꬌይሳ ሲዒዲ፥ «ጎዳው፥ ዳዊቴ ናዓው፥ ኑስ ቃꬌታርኪ» ያጊዲ ዋሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","ዳሮ ኣሳይ ኤንታና፥ «ሃይዚቴ» ያጊዲ ካጪዶሶና። ሺን ኤንቲ፥ «ጎዳው፥ ዳዊቴ ናዓው፥ ኑስ ቃꬌታርኪ» ጊዲ ጉጂ ዋሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","ዬሱሲ ኤቂዲ፥ ኤንታ ፄጊዲ፥ «ታ ሂንቴው ኣይ ኦꬃና ሜላ ኮዬቲ?» ያጊዲ ኦይቺስ። ");
INSERT INTO gofENT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","ኤንቲካ፥ «ጎዳው፥ ኑ ኣይፌይ ፄላና ሜላ ኮዮስ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","ዬሱሲ ኤንታው ቃꬌቲዲ፥ ኤንታ ኣይፊያ ቦቺስ። ኤሌሲዲ ኤንታ ኣይፌይ ፄሊስ፤ ኤንቲ ኢያ ካሊዲ ቢዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","ዬሱሳራኔ ኢያ ታማሬታራ ዬሩሳላሜ ማቲዲ፥ ሻማሆ ዴሪያ ቦላ ዴዒያ ቤቴፋጌ ጊያ ጉታ ጋኪሼ፥ ዬሱሲ ባ ታማሬታፔ ናምዓታ ባፔ ሲንꬄ ያጊዲ ኪቲስ፡ ");
INSERT INTO gofENT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","«ሂንቴፌ ሲንꬃን ዴዒያ ጉታ ቢቴ። ያን ኢሲ ሃሬይ ቃሾን ዴዒያሮ ኢ ማራራ ሂንቴ ሶሁዋራ ዴማና። ኤንታ ቢሊዲ ሃ ኤኪ ዪቴ። ");
INSERT INTO gofENT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","ኦኒካ ሂንቴና ኦይቺኮ፥ ‹ጎዳይ ኤንታና ኮዬስ› ያጊቴ። ኢ ኤንታና ኢራካ ዬዲ ኣጋና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","ሄሲካ ናቤይ፥ ");
INSERT INTO gofENT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«ፂዮኔ ካታማስ፥ ‹ሄኮ፥ ኔ ካዎይ ኣሽኬ ጊዲዲ፥ ሃሬ ቦላኔ ሃሬ ማራ ቦላ ኡቲዲ፥ ኔኮ ዬስ› ያጊቴ» ያጊዲ ፃፊዳይሲ ፖሌታና ሜላ ሄሲ ሃኒስ። ");
INSERT INTO gofENT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","ኢያ ታማሬቲ ቢዲ ዬሱሲ ኤንታ ኪቲዳይሳዳ ኦꬂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","ሃሪዉኔ ሃሬ ማራ ኤሂዲ ቦላራ ማዒዳ ባንታ ማዑዋ ኤንታ ዞኮን ዬጊዶሶና። ዬሱሲ ማዖታ ቦላ ኡቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","ዳሮ ኣሳይ ባንታ ማዑዋ ኦጊያን ሂፂዶሶና። ሃራቲ ቦንጮ ታሺዲ ኦጊያ ቦላ ዬጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","ዬሱሳፔ ሲንꬃራ ሃሙቴይሳቲኔ ኢያፔ ጉዬራ ካሊያ ዳሮ ኣሳይ፥ «ሆሳና! ዳዊቴ ናዓይ ጋላቴቶ! ጎዳ ሱንꬃን ዬይሲ ኣንጄቲዳይሳ! ቦንቾይ ኡባፌ ꬎቃ ሳሉዋን ፆሳስ ጊዶ!» ያጊዲ ዋሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","ዬሱሲ ዬሩሳላሜ ካታማ ጌሊዳ ዎዴ ሄ ካታማን ዴዒያ ኣሳ ኡባይ፥ «ሃይሲ ኦኔ?» ያጊዲ ያርኪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","ኣሳይ፥ «ሃይሲ ጋሊላን ዴዒያ ናዚሬቴ ካታማፔ ዪዳ ናቢያ ዬሱሳ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","ዬሱሲ ፆሳ ኬꬂ ጌሊዲ፥ ያን ባይዜይሳታኔ ሻሜይሳታ ኡባ ካሬ ጎዲስ። ሚሼ ላሜይሳታ ፃርጴዛታኔ ሆሌታ ባይዚያ ኦይዴታ ሺሪ ዬጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","ኢካ ኤንታኮ፥ «ፆሳ ቃላን፥ ‹ታ ኬꬃይ ፆሳ ዎሲያ ኬꬂ ጌቴታና› ጌቴቲ ፃፌቲስ። ሺን ሂንቴ ፓንጋቲ ቆሴቲያ ጎንጎሎ ኦꬂዴታ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","ዬሱሲ ፆሳ ኬꬃን ዴዒሺን ቆቄቲኔ ጉንዳቲ ኢያኮ ዪን ኤንታ ፓꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","ሺን ካሂኔ ሃላቃቲኔ ሂጌ ኣስታማሬቲ ዬሱሲ ኦꬂዳ ማላሊሲያባታ ቤዒዳይሳሲኔ ጉꬃ ናይቲ ፆሳ ኬꬃን፥ «ዳዊቴ ናዓይ፥ ጋላቴቶ» ያጊዲ ዋሴይሳ ሲዒዲ ሃንቄቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ኤንቲ ዬሱሳኮ፥ «ሃይሳቲ ጌይሳ ኔ ሲዓይ?» ያጊዶሶና። ዬሱሲ፥ «ኤ ሲዓይስ፥ ፆሳ ቃላን፥ ‹ጉꬃ ናይታ ዶናኒኔ ꬋሚያ ናይታ ዶናን ጋላታ ዎꬃዳሳ› ጌቴቲዲ ፃፌቲዳይሳ ሂንቴ ናባቢቤኬቲ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","ኤንታና ያን ኣጊዲ ቢታኒያ ካታማ ቢዲ ኣቂስ። ");
INSERT INTO gofENT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","ዬሱሲ ዎንታ ጉራ ካታማ ሲሚዲ ዪሼ ኮሻቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","ኦጌ ጋፃን ኢሲ ባላሴ ሚꬂ ቤዒዲ ኢኮ ቢስ። ሺን ሃይꬃፌ ኣቲን ሃራ ኣይኮካ ዴሚቤና። ሄሳ ጊሾ፥ ኢዮ፥ «ሂዛፔ ናምዓንꬆ ኣይፌ ኣይፎፓ!» ያጊስ። ሄ ባላሴ ሚꬂያ ኤሌሳዳ ሜላ ኣጋሱ። ");
INSERT INTO gofENT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","ኢያ ታማሬቲ ሄሳ ቤዒዲ፥ «ሃ ባላሲያ ዋናዳ ኤሌሳ ሜላዴ?» ያጊዲ ማላሌቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","ዬሱሲ ዛሪዲ፥ «ታኒ ሂንቴው ቱማ ኦዳይስ፤ ሂንቴው ኣማኖይ ዴዒኮ፥ ቃሲ ሂንቴ ሲꬎና ኢፂኮ ባላሴ ቦላ ታኒ ኦꬂዳይሳ ሜላ ፃላላ ኦꬄኬታ፥ ሺን ‹ሃ ዴሪያ ሾዴታዳ ኣባን ዎꬋ› ያጊኮ ሃናና። ");
INSERT INTO gofENT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","ኣማኒዲ ሂንቴ ዎሲያባ ኣይቢባ ጊዲኮካ ሂንቴ ኤካና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","ዬሱሲ ፆሳ ኬꬃ ጌሊዲ ታማርሲሺን፥ ካሂኔ ሃላቃቲኔ ኣይሁዴ ጪማቲ ኢያኮ ዪዲ፥ «ኔኒ ሃይሳ ኦꬃና ሜላ ኔው ኣይ ማቲ ዴዒ? ኔው ሃ ማታ ኢሚዳይ ኦኔ?» ያጊዲ ኦይቺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","ዬሱሲ ኤንታኮ፥ «ታኒካ ሂንቴና ኢሲባ ኦይቻይስ፤ ሂንቴ ታው ሄሳ ዛሪኮ፥ ታኒ ኣይ ማታን ኦꬂያኮ ሂንቴው ኦዳና። ");
INSERT INTO gofENT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","ዮሃኒሲ ፃማቃና ሜላ ማታይ ኣዉፔ ኢሜቲዴ? ፆሳፌዬ ኣሳፔ?» ያጊስ። ኤንቲ ባንታ ጊዶን ዞሬቲዲ፥ «ኑኒ፥ ‹ፆሳፌ› ጊኮ፥ ኢ ኑና፥ ‹ያቲን ኣይስ ኣማኒቤኬቲ?› ያጋና። ");
INSERT INTO gofENT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","ኑኒ፥ ‹ኣሳፔ› ጊኮ፥ ኣሳ ኡባይ ዮሃኒሳ ናቤ ኦꬂ ፄሊያ ጊሾ ኣሳ ያዮስ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","ሄሳ ጊሾ፥ «ኑኒ ኤሮኮ» ያጊዲ ዛሪዶሶና። ኢካ፥ «ሂዛ፥ ታኒካ ሃይሳ ኣይ ማታን ኦꬂያኮ ሂንቴው ኦዲኬ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","«ዬሱሲ ካሊዲካ ሃይሳዳ ያጊስ፡ ናምዑ ኣዴ ናይቲ ዴዒያ ኢሲ ኡራይ ዴዔስ። ሄ ኡራይ ባይራ ናዓኮ ቢዲ፥ ‹ታ ናዓው፥ ሃቺ ዎይኒያ ጊዶ ባዳ ኦꬃ› ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","ናዓይ ዛሪዲ፥ ‹ኣቶ ቢኬ› ያጊስ። ሺን ጉዬፔ ባ ዎዛናን ቆፒ ኤኪዲ ኦꬃናው ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","ኣዋይ ባ ካሎ ናዓኮ ቢዲ፥ ባ ባይራ ናዓኮ ጊዳይሳዳ ኪቲስ። ኢካ፥ ‹ኤሮ፥ ታ ኣዋው› ያጊስ። ሺን ቢቤንና። ");
INSERT INTO gofENT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","ሃ ናምዑ ናይታፔ ባ ኣዋስ ኪቴቲዳይሲ ኣዉሴ?» ያጊስ። ኤንቲካ፥ «ባይራ» ያጊዶሶና። ዬሱሲ ኤንታኮ፥ «ታ ሂንቴው ቱማ ኦዳይስ፤ ቃራፃ ቃንፂሴይሳቲኔ ላይማቴይሳቲ ሂንቴፌ ሲንꬃቲዲ ፆሳ ካዎቴꬃ ጌላና። ");
INSERT INTO gofENT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","ፃማቂያ ዮሃኒሲ ሱሬ ኦጊያ ታማርሲሼ ዪን ኢ ጌይሳ ኣማኒቤኬታ። ሺን ቃራፃ ቃንፂሴይሳቲኔ ላይማቴይሳቲ ኣማኒዶሶና። ሂንቴ ሃሪ ኣቶሺን፥ ኤንታ ቤዒዲካ ሂንቴ ናጋራፔ ሲሚዲ ኣማኒቤኬታ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","ቃሲካ ዬሱሲ ሃይሳዳ ያጊስ፤ «ሃራ ሌሚሶ ሲዒቴ፥ ዎይኔ ቶኪዳ ኢሲ ኡራይ ዴዔስ። ሄ ዎይኒያ ዩሹዋ ዲሪስ። ዎይኒያ ጉምዒያ ኦላካ ቦኪስ። ዎይኒያ ናጋናው ሻኮካ ሻኪስ። ሄሳፌ ጉዬ፥ ጋዲያ ኮꬄ ኢሚዲ ሃራ ቢታ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","ዎይኔ ኣይፊያ ማፂያ ዎዴይ ጋኪን ባና ጋኪያ ባጋ ኤኪዲ ያና ሜላ ባ ኣይሌታ ኤንታኮ ዬዲስ። ");
INSERT INTO gofENT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","ኮꬄ ኣዋቲ ኢያ ኣይሌታ ኦይኪዲ ኢሱዋ ዋꬊዶሶና፥ ሃንኩዋ ዎꬊዶሶና ቃሲ ኣቲዳይሳ ሹቻን ጫዲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","ዎይኔ ኣታኪልቲያ ጎዳይ ካሴይሳታፔ ዳሪያ ሃራ ኣይሌታ ኪቲስ። ኮꬄ ኣዋቲ ኤንታ ቦላካ ሃንኮይሳታ ቦላ ኦꬂዳይሳዳ ኦꬂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","ዉርሴꬃን ኢ፥ ‹ታ ናዓ ኤንቲ ቦንቻና!› ያጊዲ ባ ናዓ ኤንታኮ ኪቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","«ሺን ኮꬄ ኣዋቲ ናዓ ቤዒዲ ባንታ ጊዶን ‹ጋዲያ ላታናይሲ ሃይሳ፥ ኢያ ዎꬊዲ ጋዲያ ኑኒ ላቶስ!› ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","ናዓ ኦይኪዲ ዎይኒያ ጊዶፌ ጋፃ ኪሲዲ ዎꬊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","«ሂዛ፥ ዎይኔ ኣታኪልቲያ ጎዳይ ያ ዎዴ ሄ ኮꬄ ኣዋታ ዋታኔ?» ያጊዲ ኦይቺስ። ");
INSERT INTO gofENT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","ኤንቲ ዛሪዲ፥ «ኢ ሄ ኢታ ኣሳታ ኢታ ዎꬎ ዎꬊዲ፥ ዎይኔይ ኣይፊያ ዎዴ ኢያ ጋኪያ ባጋ ዎዴን ዎዴን ኢሚያ ሃራ ኮꬄ ኣዋታስ ኢማና» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","ዬሱሲ ዛሪዲ ኤንታኮ፥ ፆሳ ቃላን፥ « ‹ጊምቤይሳቲ ቦሪዲ ኢፂዳ ሹቻይ፥ ጎዳ ፃጱዋ ሚንꬂያ፥ ኡባፌ ኣꬊያ ሹቻ ጊዲስ። ሃይሲ ጎዳይ ኦꬂዳባ፤ ኑ ኣይፊያስ ማላሊሲያባ› ጌቴቲዲ ፃፌቲዳይሳ ናባቢቤኬቲ? ");
INSERT INTO gofENT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","«ሄሳ ጊሾ፥ ታኒ ሂንቴው ኦዳይስ፤ ፆሳ ካዎቴꬃይ ሂንቴፌ ኤኬቲዲ ሎዖ ኣይፌ ኣይፊያ ኣሳታስ ኢሜታና። ");
INSERT INTO gofENT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","ሃ ሹቻ ቦላ ኩንዲያ ኡባይ ሜቄሬታና። ቃሲ ሄ ሹቻይ ኢያ ቦላ ዎꬊያ ኡራይካ ጋጬታና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","ካሂኔ ሃላቃቲኔ ፋሪሳዌቲ ዬሱሲ ኦዲዳ ሌሚሱዋን ባንታና ኦዲዳይሳ ኤሪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","ኤንቲ ዬሱሳ ኦይካናው ኮዪዶሶና፥ ሺን ኣሳይ ዬሱሳ ናቤ ኦꬂዲ ፄሊያ ጊሾ ኣሳስ ያዪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","ዬሱሲ ኣሳስ ዛሪዲ ሃይሳዳ ያጊዲ ሌሚሶ ኦዲስ። ");
INSERT INTO gofENT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«ፆሳ ካዎቴꬃይ ባ ናዓስ ያጋኖ ጊጊሲዳ ካዉዋ ዳኔስ። ");
INSERT INTO gofENT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","ሄ ካዎይ ያጋኖ ያና ሜላ ኦዲ ዎꬂዳ ኣሳታ ፄጋናው ባ ኣይሌታ ኪቲስ። ሺን ኣሳቲ ያናው ኮዪቦኮና። ");
INSERT INTO gofENT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","ቃሲ ሃራ ኣይሌታ ፄጊዲ፥ ፄጌቲዳ ኣሳታኮ ቢዲ፥ ‹ታኒ ታ ሳንጋታኔ ሞꬊዳ ጋታርሜንꬆታ ሹካስ፤ ኡባባይ ጊጊስ። ታ ያጋኑዋ ሃ ዪቴ ያጊቴ› ያጊዲ ኪቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","ሺን ፄጌቲዳይሳቲ ፄሳ ኢፂዲ፥ ባንታ ኦሶስ ኦሶስ ቢዶሶና። ኢሶይ ባ ጎሻስ፥ ሃንኮይ ባ ዛልዒያስ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ሃራቲ ቃሲ ካዉዋ ኣይሌታ ኦይኪዲ፥ ካዉሺ ዋꬊዲ ዎꬊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","«ካዎይ ዳሮ ዪሎቲዲ፥ ባ ዎታዳሬታ ዬዲዲ ሼምፖ ዎꬊዳይሳታ ዎꬊሲስ፥ ኤንታ ካታማካ ፁጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","ሄሳፌ ጉዬ፥ ባ ኣይሌታኮ፥ ‹ያጋኖይ ጊጊስ፥ ሺን ፄጌቲዳይሳቲ ያጋኑዋስ ቤሲያ ኣሲ ጊዶኮና። ");
INSERT INTO gofENT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","ሄሳ ጊሾ፥ ዎጋ ኦጌታ ቢዲ፥ ዴሚዳ ኣሲ ኡባ ያጋኑዋ ያና ሜላ ፄጊቴ› ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","ኣይሌቲ ኦጊያ ቦላ ቢዲ ባንታ ዴሚዳ ኣሲ ኡባ ሎዖታኔ ኢታታ ኤሂዲ ያጋኖ ሻቃራ ጌልሲዲ ኩንꬂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","«ሺን ካዎይ ካꬃ ማናው ኡቲዳ ኣሳ ቤዓናው ጌሊዳ ዎዴ ያጋኖ ማዖ ማዒቦና ኢሲ ኣሲ ዴሚስ። ");
INSERT INTO gofENT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","ኢያኮ፥ ‹ላ፥ ኔ ያጋኖ ማዖ ማዖና ዋናዳ ሃይሳ ጌላዲ?› ያጊስ። ሺን ኡራይ ሲዒ ጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","«ካዎይ ባ ኣይሌታኮ፥ ‹ሃ ኡራ ኩሺያኔ ቶሁዋ ቃቺዲ፥ ካሬ ꬉማ ኬሲ ዬጊቴ። ያን ኢያው ዬሆኔ ኣቻ ጋርጬꬂ ጊዳና› ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","«ሄሳዳካ፥ ፆሳ ካዎቴꬃስ ፄጌቲዳይሳቲ ዳሮ ሺን ዶሬቲዳይሳቲ ጉꬃ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","ሄሳፌ ጉዬ፥ ፋሪሳዌቲ ቢዲ፥ ዬሱሳ ዋቲ ኦዳን ኦይካኔኮ ዞሬቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","ባንታ ታማሬታኔ ሄሮዲሳ ባጋታፔ ኢሶታ ኢሶታ ኪቲዶሶና። ኤንቲካ፥ «ኣስታማሪያው፥ ኔ ቱማ ኦዴይሳ ኑ ኤሮስ። ኔኒ ኣሳፔ ኣሴ ሻካካ፥ ኣሳ ዎይጋንዴስ ጋዳ ኣይኮካ ኦꬃካ፥ ፆሳ ኦጊያ ቱማቴꬃን ታማርሳሳ። ");
INSERT INTO gofENT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","ኣኔ ኑስ ኦዳ፥ ኑኒ ሮሜ ካዉዋስ ጊራ ጊራናው ቤሲ ቤሴኔ?» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","ሺን ዬሱሲ ኤንታ ኢታ ቆፋ ኤሪዲ፥ «ሃ ጩቦቶ፥ ታና ኣይስ ፓጬቲ? ");
INSERT INTO gofENT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","ጊራ ጊሪያ ሚሺያ ታና ቤሲቴ» ያጊስ። ኤንቲካ ኢያው ሳንቲሜ ኤሂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ኢ፥ «ሃ ሱንꬃይኔ ማላይ ኦዴባዬ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","ኤንቲ፥ «ሮሜ ካዉዋይሳ» ያጊዶሶና። ያቲን ዬሱሲ ኤንታኮ፥ «ሂዛ፥ ካዉዋስ ቤሴይሳ ካዉዋስ፥ ፆሳስ ቤሴይሳ ፆሳስ ኢሚቴ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","ኤንቲ ሄሳ ሲዒዳ ዎዴ ማላሌቲዲ ኢያ ማታፔ ኣጊዲ ቢዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","ሄ ጋላስ ሃይቆፔ ዴንዶይ ባዋ ያጊያ ሳዱቃዌቲ ዬሱሳኮ ዪዲ፥ ያጊዲ ኢያ ኦይቺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","«ኣስታማሪያው፥ ‹ሙሴይ፥ ኢሲ ኣሲ ናዓ ዬሎና ሃይቂኮ፥ ሄ ሃይቂዳይሳ ኢሻይ ኢያ ማቺው ኤኪዲ፥ ባ ኢሻስ ናዓ ዬሎ› ያጊዲ ኪቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","ኑ ኤሪያ ላፑን ኢሻቲ ዴዖሶና። ባይራይ ማቾ ኤኪዲ ናዓ ዬሎና ሃይቂስ። ኢያ ማቺው ኢያ ካሎ ኢሻይ ኤኪስ። ");
INSERT INTO gofENT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","ሄሳዳካ፥ ሄ ማጫሲው ኤኪዳ ናምዓንꬆይካ፥ ሄꬓንꬆይካ፥ ቢዲ ላፑናቲ ዉራና ጋካናው ኡባይ ሃይቂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","ኡባፌ ጉዬ ሄ ማጫሲያ ሃይቃሱ። ");
INSERT INTO gofENT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","ያቲን፥ ላፑናቲ ኡባይ ኢዮ ኤኪዳ ጊሾ ሃይቆፔ ዴንዲያ ጋላስ፥ ሄ ማጫሲያ ላፑናታፔ ኣዉሳስ ማቾ ጊዳኔ?» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","ዬሱሲ ዛሪዲ፥ «ሂንቴ ፆሳ ቃላይ ታማርሲያባ ዎይኮ ኢያ ዎልቃ ኤሮና ጊሾ ባሌታ። ");
INSERT INTO gofENT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","ኣሳይ ሃይቆፔ ዴንዲያ ዎዴ ሳሎን ዴዒያ ኪታንቾታ ሜላ ጊዳናፔ ኣቲን ኤኮኮና ጌሎኮና። ");
INSERT INTO gofENT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","ቃሲ ሃይቂዳ ኣሳቲ ሃይቆፔ ዴንዳናባ ፆሳይ ሂንቴው ኦዲዳይሳ ናባቢቤኬቲ? ");
INSERT INTO gofENT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","ፆሳይ፥ ‹ታኒ ኣብራሃሜ ፆሳ፥ ዪሳቃ ፆሳ፥ ያይቆባ ፆሳ› ያጊስ። ሄሳ ጊሾ፥ ፆሳይ ፓፃ ዴዔይሳታ ፆሳፌ ኣቲን ሃይቂዳይሳታ ፆሳ ጊዴና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","ዳሮ ኣሳይ ሄሳ ሲዒዲ፥ ኢያ ቲሚርቲያን ማላሌቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","ዬሱሲ ሳዱቃዌታስ ጋናባ ꬋይሲዳይሳ ፋሪሳዌቲ ሲዒዳ ዎዴ ኢሲፌ ሺቂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","ኤንታ ጊዶፌ ኢሲ ሂጌ ኣስታማሬይ ዬሱሳ ፓጬ ኦይሾ ኦይቺስ። ");
INSERT INTO gofENT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«ኣስታማሪያው፥ ሂጌ ኡባፌ ኣꬌይሲ ኣዉሴ?» ያጊዲ ኦይቺስ። ");
INSERT INTO gofENT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","ዬሱሲ ዛሪዲ፥ « ‹ኔ ጎዳ፥ ኔ ፆሳ፥ ኔ ኩሜꬃ ዎዛናፔ፥ ኔ ኩሜꬃ ሼምፑዋፌ፥ ኔ ኩሜꬃ ቆፋፔ ዶሳ። ");
INSERT INTO gofENT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","ኡባፌ ኣꬌይሲኔ ባይራ ኪታይ ሃይሳ። ");
INSERT INTO gofENT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","ናምዓንꬆ ኡባፌ ኣꬊያ ኪታይ፥ ኣሴ ኡባ ኔ ሁዒያ ኔ ዶሴይሳዳ ዶሳ› ያጌይሳ። ");
INSERT INTO gofENT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","ሙሴ ሂጌይኔ ናቤታ ቲሚርቴይ ኡባይ ሃ ኪታታ ቦላ ካቶሶና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","ፋሪሳዌቲ ኢሲ ቦላ ሺቂዲ ዴዒሺን፥ ዬሱሲ ኤንታና፥ ");
INSERT INTO gofENT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","«ኪሪስቶሳባ ሂንቴ ዎይጌቲ? ኢ ኦዴ ናዔ?» ያጊዲ ኦይቺስ። ኤንቲ፥ «ኢ ካዉዋ ዳዊቴ ናዓ» ያጊዲ ዛሪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","ዬሱሲ ኤንታኮ፥ «ያቲን፥ ዳዊቴይ ጌሻ ኣያናን ጊዲዲ ዋቲዲ ኪሪስቶሳ፥ ‹ጎዳ› ጊዲ ፄጊ? ዳዊቴይ ጊሼ፥ ");
INSERT INTO gofENT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‹ጎዳ ፆሳይ፥ ታ ጎዳኮ፥ ኔ ሞርኬታ ኔ ቶሆይ ዬꬊያሶ ኦꬃና ጋካናው፥ ሃይሳን ታፔ ኡሻቻ ባጋን ኡታ› ጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","ሂዛ፥ ዳዊቴይ ኪሪስቶሳ ጎዳ ጊዲ ፄጊኮ፥ ዋኒዲ ኪሪስቶሲ ዳዊቴ ናዓ ጊዲ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","ዬሱሳስ ኢሲ ቃላ ዛራናው ዳንዳዒዳ ኣሲ ኦኒካ ባዋ። ቃሲ ሄ ጋላሳፔ ዶሚዲ ሃራ ኦይሻ ኦይቻናው ኦኒካ ዳንዳዒቤና። ");
INSERT INTO gofENT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","ሄሳፌ ጉዬ፥ ዬሱሲ ሺቂዳ ኣሳሲኔ ባ ታማሬታስ ሃይሳዳ ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«ሂጌ ኣስታማሬቲኔ ፋሪሳዌቲ ሙሴ ሂጊያ ቢላናው ማታራ ዴዖሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","ሄሳ ጊሾ፥ ኤንቲ ሂንቴና ኪቲያ ኡባ ኦꬂቴኔ ናጊቴ። ሺን ኤንቲ ኦꬄይሳዳ ኦꬆፊቴ። ኣይስ ጊኮ፥ ኤንቲ ኦዴይሳዳ ኦꬆኮና። ");
INSERT INTO gofENT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","ኤንቲ ቶካናው ዳንዳዔቶና ቶሆ ቃቺዲ ኣሳ ቶሶሶና። ሺን ባንታው ሃሪ ኣቶሺን፥ ሄ ቶሁዋ ኣሳይ ቶኪያ ዎዴ ቢራꬌ ፄራን ቦቻናው ኮዮኮና። ");
INSERT INTO gofENT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","«ሺን ኤንቲ ባንታ ኦሶ ኡባ ኣሲ ቤዓና ሜላ ኦꬆሶና። ባንታ ሶምዖኒኔ ቄሴን ቃቺያ ማፃፋ ፂቂሴይ ዴዒያ ኪታፌ ዳልጊሶሶና፥ ባንታ ማዑዋ ማጫራካ ኣዱሶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","ሞኬቲያ ቤሳን ቦንቾ ቤሲኔ ኣይሁዴ ዎሳ ኬꬃታን ዳሮ ሎዒያ ኦይዴ ዶሶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","ኣሳይ ጊያን ኤንታና ቦንቾን ሳሮꬃናይሳኔ ‹ኣስታማሪያው› ጊዲ ፄጋናይሳ ኮዮሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","«ሺን ሂንቴ ኣስታማሬይ ኢሱዋ ፃላላ ጊዲዳ ጊሾኔ ሂንቴ ኡባይ ኢሻታ ጊዲዳ ጊሾ ‹ኣስታማሪያው› ጌቴቲዲ ፄጌቶፊቴ። ");
INSERT INTO gofENT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","ሂንቴው ሳሎን ኢሲ ኣዋ ፃላሊ ዴዒያ ጊሾ ሃ ሳዓን ኦናካ ‹ኣዋው› ጊዲ ፄጎፒቴ። ");
INSERT INTO gofENT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","ሂንቴው ኢሲ ጎዳይ ኪሪስቶሳ ፃላሊ ዴዒያ ጊሾ ‹ጎዳው› ጌቴቲ ፄጌቶፊቴ። ");
INSERT INTO gofENT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","ሂንቴ ጊዶን ባይራቴይ ሂንቴ ኣይሌ ጊዶ። ");
INSERT INTO gofENT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","ባና ጊታያ ኦኒካ ካዉያና፤ ባና ካዉሺያ ኦኒካ ጊታታና። ");
INSERT INTO gofENT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","«ሂንቴኖ፥ ጩቦቶ፥ ሂጌ ኣስታማሬቶኔ ፋሪሳዌቶ፥ ኣሳ ሲንꬃን ሳሎ ካዎቴꬃ ጎርዴይሳቶ ሂንቴና ኣዬ። ሂንቴ፥ ሂንቴ ሁዔን ጌሌኬታ ቃሲ ሃራታካ ጌልሴኬታ። ");
INSERT INTO gofENT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","«ሂንቴኖ ጩቦቶ፥ ሂጌ ኣስታማሬቶኔ፥ ፋሪሳዌቶ፥ ኣምዔታ ኬꬃ ሂንቴ ቦንቂሼ፥ ኣሲ ቤዖ ጊዲ ዎሳ ኣዱሴታ። ሄሳ ጊሾ፥ ሂንቴና ኣዬ። ኡባፌ ኣꬊያ ፒርዳይ ሂንቴና ናጌስ። ");
INSERT INTO gofENT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","«ሂንቴኖ፥ ጩቦቶ፥ ሂጌ ኣስታማሬቶኔ ፋሪሳዌቶ፥ ሂንቴ ኢሲ ኡራ ኣማንꬃናው ኣባራኔ ሳዓራ ዩዬታ። ሺን ሂንቴ ኢያ ኣማንꬂዳ ዎዴ ሄ ኡራ ሂንቴፌ ኣꬂዲ ጋናሜስ ጊጌቲዳይሳ ኦꬂያ ጊሾ ሂንቴና ኣዬ። ");
INSERT INTO gofENT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","«ኦኒካ ፆሳ ኬꬃን ጫቂኮ ኣይኮይካ ባዋ። ሺን ፆሳ ኬꬃን ዴዒያ ዎርቃን ጫቂኮ፥ ሄ ጫቆይ ኢያ ጎማና ጊያ ቆቄቶ፥ ሂንቴው ቆቂዲ ሃራታ ካሌꬄይሳቶ፥ ሂንቴና ኣዬ። ");
INSERT INTO gofENT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","ሂንቴኖ፥ ኤያቶ፥ ቆቄቶ፥ ዎርቃይ ኣꬊዬ? ዎርቂያ ፆሳስ ዱማያ ፆሳ ኬꬃይ ኣꬊ? ");
INSERT INTO gofENT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","ቃሲ ‹ኦኒካ ያርሾ ያርሺያ ቤሳን ጫቂኮ፥ ኣይኮይካ ባዋ። ሺን ኦኒካ ኢያ ቦላ ዴዒያ ያርሹዋን ጫቂኮ፥ ሄ ጫቆይ ኢያ ጎማና› ያጊዲ ታማርሴታ። ");
INSERT INTO gofENT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","ሂንቴኖ፥ ቆቄቶ፥ ያርሾይ ኣꬊዬ? ያርሹዋ ፆሳስ ዱማያ ቤሳይ ኣꬊ? ");
INSERT INTO gofENT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","ሄሳ ጊሾ፥ ያርሾ ቤሳን ጫቂያ ኡራይ፥ ሄ ያርሾ ቤሳኒኔ ኢያ ቦላ ዴዒያ ኡባባን ጫቄስ። ");
INSERT INTO gofENT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","ፆሳ ኬꬃን ጫቂያ ኡራይ፥ ሄ ፆሳ ኬꬃኒኔ ኢያን ዴዒያ ፆሳን ጫቄስ። ");
INSERT INTO gofENT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","ሳሎን ጫቂያ ኡራይ ፆሳ ኣራታኒኔ ሄ ኣራታ ቦላ ኡቲያ ፆሳን ጫቄስ። ");
INSERT INTO gofENT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","«ሂንቴኖ፥ ጩቦቶ፥ ሂጌ ኣስታማሬቶኔ ፋሪሳዌቶ፥ ሂንቴና ኣዬ። ሂንቴ ካሬꬃ ሳዎፔ፥ ናቲሮፔኔ ኦካሼፔ ኣስራታ ኬሴታ። ሺን ሂጊያን ዴዒያ ኣꬊ ኮሼይሳታ ኣጊዴታ። ሄሲካ ሱሬ ፒርዳ፥ ቃꬌቴꬂኔ ኡባባን ኣማኔቴꬂ። ሃራታካ ኣጎናሺን ሃይሳታ ሂንቴ ኦꬃናው ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","ሂንቴው ቆቂዲ ሃራ ኣሲ ካሌꬄይሳቶ፥ ሂንቴ ኡሻፌ ኡዱንፄ ኬሲዲ ጊማሌ ሚቴታ። ");
INSERT INTO gofENT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","«ሂንቴኖ፥ ጩቦቶ፥ ሂጌ ኣስታማሬቶኔ ፋሪሳዌቶ፥ ሂንቴና ኣዬ። ሂንቴ ሻቲያሲኔ ኬሪያስ ቦላ ባጋ ጌሼታ። ሺን ኤንታው ጋርሳን ቦንቄይኔ ኡዜቴꬂ ኩሚ ኡቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","ኔኖ ቆቄ ፋሪሳዊያው፥ ሻቲያሲኔ ኬሪያስ ጋርሳ ካሴታዳ ጌሻ። ሄሳፌ ጉዬ፥ ቦላ ባጋይካ ጌሺ ጊዳና። ");
INSERT INTO gofENT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","«ሂንቴኖ፥ ጩቦቶ፥ ሂጌ ኣስታማሬቶኔ ፋሪሳዌቶ፥ ሂንቴና ኣዬ። ካሬ ባጋራ ቃላሜ ቲዬቲዲ ሎዒዲ፥ ጊዶን ሜቄꬂኔ ዎቂዳባይ ኩሚዳ ዱፎታ ዳኔታ። ");
INSERT INTO gofENT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","ሄሳዳካ፥ ቦላ ባጋራ ኣሳስ ሎዖ ዳኔታ። ሺን ሂንቴ ጋርሳን ጩቦቴꬂኔ ኢታቴꬂ ኩሚስ። ");
INSERT INTO gofENT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","«ሂንቴኖ፥ ጩቦቶ፥ ሂጌ ኣስታማሬቶኔ ፋሪሳዌቶ፥ ሂንቴና ኣዬ። ሂንቴ ናቤታስ ዱፎ ኬፄታ፥ ቃሲ ፂሎታ ዱፉዋካ ሎይꬄታ። ");
INSERT INTO gofENT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ቃሲ ሂንቴ፥ ‹ኑኒ ቤኒ ኑ ኣዋታ ዎዴ ዴዒዳባ ጊዲያኮ፥ ኤንታራ ኢሲፌ ናቤታ ሱꬃ ጉሶኮሺን› ያጌታ። ");
INSERT INTO gofENT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","ሄሳ ጊሾ፥ ሂንቴ ናቤታ ዎꬊዳ ኣሳ ናይታ ጊዴይሳ ሂንቴ ሂንቴ ሁዔን ማርካቴታ። ");
INSERT INTO gofENT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","ሂዛ፥ ሂንቴ ኣዋቲ ዶሚዳይሳ ሂንቴ ፖሊቴ። ");
INSERT INTO gofENT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","«ሃ ሾሻቶ፥ ሾሻ ናይቶ፥ ሂንቴ ጋናሜ ፒርዳፌ ዋኒዲ ኣታኔ? ");
INSERT INTO gofENT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","ሄሳ ጊሾ፥ ታ ኦዴይሳ ሲዒቴ፤ ታኒ ናቤታ፥ ጪንጫ ኣሳታኔ ኣስታማሬታ ሂንቴኮ ኪታና። ኤንታፌ ኢሶታ ኢሶታ ሂንቴ ዎꬋናኔ ማስቃሊያ ቦላ ካቃና። ባጋታ ኣይሁዴ ዎሳ ኬꬃታን ሊሶን ጋራፋናኔ ካታማፔ ካታማ ጎዳና። ");
INSERT INTO gofENT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","ሄሳ ጊሾ፥ ፂሉዋ ኣቤላ ዎꬊዳ ዎዲያፔ ዶሚዲ፥ ፆሳ ኬꬃሲኔ ያርሾ ቤሳፌ ጊዶን ሂንቴ ዎꬊዳ ባራኪያ ናዓ ዛካሪያሳ ዎዴ ጋካናው ሃይቂዳ ፂሎ ኣሳ ኡባ ጊሾ ሂንቴ ሴሬታና። ");
INSERT INTO gofENT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","ታኒ ሂንቴው ቱማ ኦዳይስ፤ ሂንቴኔ ሂንቴ ኣዋቲ ኦꬂዳ ባላስ ሃ ፒርዳ ኡባይ ሃ ዬሌቴꬃ ቦላ ጋካና። ");
INSERT INTO gofENT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","«ዬሩሳላሜ፥ ዬሩሳላሜ፥ ናቤታ ዎꬊያሬ! ፆሳይ ኔኮ ኪቲዳይሳታ ሹቻን ጫዲያሬ! ኩቶይ ባ ናይታ ባ ቄፌን ሃጴይሳዳ ታኒ ኔ ኣሳ ታ ቄሲያን ጌቻናው ኣፑን ቶሆ ኮያዲና! ሺን ታና ዲጋዳሳ። ");
INSERT INTO gofENT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","ሂዛ፥ ሂንቴ ፆሳ ኬꬃይ ካይሲ ጊዳና። ");
INSERT INTO gofENT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","ታኒ ሂንቴው ኦዳይስ፤ ‹ጎዳ ሱንꬃን ዬይሲ ኣንጄቲዳይሳ› ሂንቴ ጋና ጋካናው ናምዓንꬆ ታና ቤዔኬታ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","ዬሱሲ ፆሳ ኬꬃፌ ኬዪዲ ቢሺን፥ ኢያ ታማሬቲ ኢያኮ ዪዲ፥ ማላሌቲዲ ፆሳ ኬꬃ ጊምቢያ ቤሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","ዬሱሲ ኤንታኮ ዛሪዲ፥ «ኤ! ሃይሳ ኡባ ቤዔቲ? ታኒ ሂንቴው ቱማ ኦዳይስ፤ ሹቺ ሹቻ ቦላ ጊምቤቲዳ ሜላ ላሌቶና ኣቴና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","ዬሱሲ ሻማሆ ዴሪያ ቦላ ኡቲዳሺን፥ ኢያ ታማሬቲ ባንታርካ ኢያኮ ዪዲ፥ «ሄሲ ኣዉዴ ሃናኔኮ ኑስ ኦዳ። ቃሲ ኔ ዩሳሲኔ ዎዲያ ዉርሴꬃስ ማላታይ ኣይቤ?» ያጊዲ ኦይቺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","ዬሱሲ ዛሪዲ፥ «ሂንቴና ኦኒካ ባሌꬆና ሜላ ናጌቲቴ! ");
INSERT INTO gofENT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","ኣይስ ጊኮ፥ ዳሮ ኣሳቲ ታ ሱንꬃን፥ ‹ታኒ ኪሪስቶሳ፥ ፆሳይ ኣሳ ኣሻናው ኪቲዳይሳ› ያጊሼ ዪዲ ዳሮ ኣሳ ባሌꬃና። ");
INSERT INTO gofENT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","ማታን ዴዒያ ኦላ ጊርሳ፥ ሃሆን ዴዒያ ኦላ ዎሬ ሲዓናው ዴዔታ። ሄሳ ሜላባይ ሃናናው ቤሲያ ጊሾ ሂርጎፊቴ። ሺን ዉርሴꬃይ ቡሮና። ");
INSERT INTO gofENT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","ዴሬይ ዴሪያራ፥ ኢሲ ካዎቴꬃይ ሃራ ካዎቴꬃራ ኦሌታና። ኮሻይኔ ቢታ ቃፆይ ኡባ ቤሳን ሃናና። ");
INSERT INTO gofENT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","ሄሲ ኡባይ ዬሎ ኢቄꬃስ ዞኬ ሜላ። ");
INSERT INTO gofENT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","«ሄ ዎዴ ኣሳይ ሂንቴና ዋዬስ ኣꬂ ኢማና፥ ቃቻናኔ ዎꬋና። ታ ሱንꬃ ጊሾ ኣሳ ኡባይ ሂንቴና ኢፃና። ");
INSERT INTO gofENT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","ሄ ዎዴ ዳሮቲ ኣማኖ ኣጋና። ባንታ ጊዶን ኢሶይ ኢሱዋ ኣꬂዲ ኢማና፥ ኢሶይ ኢሱዋ ኢፃና። ");
INSERT INTO gofENT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","ቃሲ ዳሮ ዎርዶ ናቤቲ ዴንዲዲ ዳሮታ ባሌꬃና። ");
INSERT INTO gofENT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","ጌላቴꬂ ዳሪያ ጊሾ ዳሮ ኣሳ ሲቆይ ኢርፃና። ");
INSERT INTO gofENT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","ሺን ዉርሴꬂ ጋካናው ጌንጪያ ኡራይ ኣታና። ");
INSERT INTO gofENT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","ኣሳ ኡባስ ማርካ ጊዳና ሜላ ፆሳ ካዎቴꬃ ዎንጌላይ ቢታ ኡባን ኦዴታና። ሄሳፌ ጉዬ፥ ዉርሴꬃይ ያና። ");
INSERT INTO gofENT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","«ሄሳ ጊሾ፥ ናቢያ ዳኔሊ ኦዲዳ ባሻ ቱናቴꬃይ ጌሻ ቤሳን ኤቂዳይሳ ሂንቴ ቤዓና። (ኣኬኪሶ፡ ሄሲ ዎይ ጉሴኮ ናባቤይሲ ኣኬኮ!) ");
INSERT INTO gofENT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ሄ ዎዴ ዪሁዳ ቢታን ዴዔይሳቲ ዴሪያኮ ባቃቶ። ");
INSERT INTO gofENT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","ኬꬃ ሁዔን ዴዒያ ኡራይ ባ ሶን ዴዒያባ ኤካናው ሶ ጌሎና ባቃቶ። ");
INSERT INTO gofENT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","ጋዴን ዴዔይሲ ባ ማዑዋ ኤካናው ጉዬ ሲሞፎ። ");
INSERT INTO gofENT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","ሄ ዎዴ ቃንꬃ ማጫሳታሲኔ ꬋንꬂያ ማጫሳታስ ዳሮ ኡንዓ ጊዳና። ");
INSERT INTO gofENT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","ባልጎን ዎይኮ ሳምባታን ሂንቴ ባቃቶይ ጊዶና ሜላ ፆሳ ዎሲቴ። ");
INSERT INTO gofENT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","ኣይስ ጊኮ፥ ሳዒ ሜꬌቶሳፔ ሃቺ ጋካናው ሃኖናባይ፥ ቃሲ ሲንꬃፌካ ኡባራካ ሃኖና ዋዬይ ሄ ዎዴ ሃናና። ");
INSERT INTO gofENT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","ፆሳይ ሄ ጋላሳታ ታይቡዋ ጉꬆናኮ ኣሴ ጊዲዳ ኦኒካ ኣቴና። ሺን ኢ ባ ዶሪዳ ኣሳታ ጊሾ ሄ ጋላሳታ ታይቡዋ ጉꬃና። ");
INSERT INTO gofENT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","«ሄ ዎዴ ኦኒካ ሂንቴና፥ ‹ሄኮ፥ ኪሪስቶሲ ሃይሳን› ዎይኮ ‹ሂኒን ዴዔስ› ያጊኮ ኣማኖፒቴ። ");
INSERT INTO gofENT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","ኣይስ ጊኮ፥ ዎርዶ ኪሪስቶሳቲኔ ዎርዶ ናቤቲ ዴንዳና። ኤንታው ዳንዳዔቲኮ፥ ሃሪ ኣቶሺን ፆሳይ ዶሪዳይሳታካ ባሌꬃናው ጊታ ማላታታኔ ማላሊሲያባታ ኦꬃና። ");
INSERT INTO gofENT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","ኣኬኪቴ፥ ታኒ ሂንቴው ሃይሳ ካሴታዳ ኦዳስ። ");
INSERT INTO gofENT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","«ሄሳ ጊሾ፥ ኣሳይ ሂንቴኮ፥ ‹ሄኮ፥ ኪሪስቶሲ ባዞን ዴዔስ› ጊኮ፥ ያ ቦፒቴ። ዎይኮ ሂንቴኮ፥ ‹ሄኮ፥ ቆልዓን ዴዔስ› ጊኮ፥ ኤንታባ ኣማኖፒቴ። ");
INSERT INTO gofENT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","ኣይስ ጊኮ፥ ዎልዓንꬂ ሳሎን ዎልዓሚዲ፥ ዶሎሃፔ ዉሎሃ ጋካናው ቤንቴይሳዳ፥ ኣሳ ናዓ ዩሳይ ሄሳዳ ሃናና። ");
INSERT INTO gofENT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","«ባዉቲ ዴዒይሶን ኣንኮቲ ሺቃና። ");
INSERT INTO gofENT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","«ሄ ዎዴ ሄ ዋዬ ጋላሳታፔ ጉዬ፥ ሶሁዋራ ኣዋይ ꬉማና፥ ኣጌናይ ባ ፖዑዋ ዲጋና። ፆሊንቶቲ ሳሎፔ ዎꬋና፥ ቃሲ ሳሎን ዴዒያ ዎልቃቲ ቡቄታና። ");
INSERT INTO gofENT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","ሄ ዎዴ ኣሳ ናዓ ዩሳ ማላይ ሳሉዋ ቦላ ቤንታና። ሳዓን ዴዒያ ኣሲ ኡባይ ዬካና። ቃሲ ኣሳ ናዓይ፥ ዎልቃራኔ ጊታ ቦንቹዋራ ሳሉዋ ሻራ ጊዶራ ዪሺን ኤንቲ ቤዓና። ");
INSERT INTO gofENT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","ኢ ባ ኪታንቾታ ጊታ ፑኒያ ሞይዜራ ኪታና። ኤንቲ ሳዓ ኦይዱ ባጋ ቢዲ፥ ሃ ጋፃፔ ያ ጋፃ ጋካናው ዴዒያ ኢያው ዶሬቲዳይሳታ ሺሻና። ");
INSERT INTO gofENT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","«ባላሴ ሚꬃፌ ታማሪቴ። ኢ ኣጪዲ ሃይፂያ ዎዴ ቶርቼይ ማታቲዳይሳ ሂንቴ ኤሬታ። ");
INSERT INTO gofENT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","ሄሳዳካ፥ ሂንቴ ሃ ኡባባ ቤዒያ ዎዴ ዬሱሲ ማቲዲ ፔንጌን ዴዔይሳ ኤሪቴ። ");
INSERT INTO gofENT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","ታኒ ሂንቴው ቱማ ኦዳይስ፤ ሃ ኡባባይ ፖሌታና ጋካናው፥ ሃ ዬሌቴꬃይ ኣꬌና። ");
INSERT INTO gofENT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","ሳሎይኔ ሳዓይ ኣꬋና፥ ሺን ታ ቃላይ ኡባካ ኣꬌና። ");
INSERT INTO gofENT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","«ሄ ጋላሳኔ ሄ ሳቲያ ሳሎን ዴዒያ ታ ኣዋፔ ኣቲን ሃሪ ሳሎ ኪታንቾታ ጊዲን ዎይኮ ናዓ ጊዲን ኦኒካ ኤሬና። ");
INSERT INTO gofENT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","ኣሳ ናዓ ዩሳይ፥ ኖሄ ዎዴ ሃኒዳይሳ ሜላ ጊዳና። ");
INSERT INTO gofENT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","ሄ ዎዴ ꬋዮ ሃꬃይ ያናፔ ሲንꬄ ኖሄይ ማርካቢያን ጌሊዳ ጋላሳ ጋካናው፥ ኣሳይ ሚሼኔ ኡዪሼ፥ ኤኪሼኔ ጌሊሼ ጋምዒስ። ");
INSERT INTO gofENT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","ባሻ ሃꬃይ ዪዲ፥ ኤንታ ኡባ ꬋይሳና ጋካናው ኣኬኪቦኮና። ኣሳ ናዓ ዩሳይካ ሄሳዳ ሃናና። ");
INSERT INTO gofENT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","«ሄ ዎዴ ናምዑ ኣሳቲ ጋዴን ኦꬃና። ኤንታፌ ኢሶይ ኤኬታና፥ ሃንኮይ ኣታና። ");
INSERT INTO gofENT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","ናምዑ ማጫሳቲ ኢሲፌ ጋጫና። ኤንታፌ ኢሲኒያ ኤኬታና ሃንኪያ ኣታና። ");
INSERT INTO gofENT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","«ሂዛ፥ ሂንቴ ጎዳይ ኣይ ጋላስ ያኔኮ ሂንቴ ኤሮና ጊሾ ሚኒዲ ናጊቴ። ");
INSERT INTO gofENT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","ሺን ካይሶይ ቃማፌ ኣይ ሳቴን ያኔኮ ኬꬃዋይ ኤሪያኮ፥ ባ ኬꬃይ ቦኬቶና ሜላ ባርኪዲ ናጋናሺን። ");
INSERT INTO gofENT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","ሄሳዳካ፥ ኣሳ ናዓይ ሂንቴ ቆፖና ሳቴን ያና ጊሾ ሂንቴካ ጊጊዲ ዴዒቴ። ");
INSERT INTO gofENT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","«ያቲን፥ ባ ሶ ኣሳስ ካꬃ ኮሺያ ዎዲያን ኢማና ሜላ ኢያ ጎዳይ ዶሪዳ ኣማንꬄይሲኔ ዎዛናማ ኣይሌይ ኦኔ? ");
INSERT INTO gofENT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","ኢ ባ ጎዳይ ኪቲዳይሳ ኦꬂሺን ኢያ ጎዳይ ዪዲ ዴሚያ ኣይሌይ ኣንጄቲዳይሳ። ");
INSERT INTO gofENT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","ታኒ ሂንቴው ቱማ ኦዳይስ፤ ጎዳይ ሄ ኣይሊያ ባባ ኡባ ቦላ ሹማና። ");
INSERT INTO gofENT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","ሺን ሄ ኣይሌይ ኢታ ጊዲኮ፥ ‹ታ ጎዳይ ጋምዒዲ ያና› ያጊዲ ባ ዎዛናን ቆፒዲ፥ ");
INSERT INTO gofENT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ባ ላጌ ኦሳንቾታ ዋꬎ ዶሚኮ፥ ማꬆቴይሳታራ ሚኮኔ ኡዪኮ፥ ");
INSERT INTO gofENT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ሄ ኣይሊያ ጎዳይ ኢ ቆፖና ጋላሲኔ ኢ ኤሮና ሳቴን፥ ");
INSERT INTO gofENT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ዪዲ ኢያ ቃንፄሬꬃና። ኢያ ቃዳ ጩቦታራ ኦꬃና። ሄ ቤሳን ኢያው ዬሆኔ ኣቼ ጋርጬꬂ ጊዳና። ");
INSERT INTO gofENT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","«ሄ ዎዴ ሳሎ ካዎቴꬃይ ባንታ ኩራዚያ ኦይኪዲ፥ ማቾ ኤሃናው ቢዳ ኣዲያ ሞካናው ኬዪዳ ታሙ ጌላዖታ ዳኔስ። ");
INSERT INTO gofENT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","ኤንታፌ ኢቻሻቲ ኤያ፥ ቃሲ ኢቻሻቲ ጪንጫ። ");
INSERT INTO gofENT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","ኤያቲ ኩራዜ ኦይኪዶሶና፥ ሺን ሃራ ላምባ ኦይኪቦኮና። ");
INSERT INTO gofENT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","ሺን ጪንጫቲ ባንታ ኩራዚያኔ ሃራ ጉዣ ላምባ ኦይኪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","ማቺው ኤኬይሲ ጋምዒን፥ ሄ ጌላዖቲ ባንታና ꬊስኮይ ኦይኪን ꬊስኪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","«ጊዲ ቢላሄ ጊዲያ ዎዴ ‹ሄኮ፥ ማቺው ኤሄይሲ ጋኪስ፥ ኢያ ሞካናው ኬዪቴ› ያጊያ ጊታ ጫቦይ ሲዔቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","«ሄ ዎዴ ሄ ጌላዖቲ ኡባይ ባርኪዲ፥ ባንታ ኩራዚያ ጊጊሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","ኤያቲ ጪንጫታኮ፥ ‹ኑ ኩራዜይ ቶዓና ሃኒያ ጊሾ ሂንቴ ላምባፌ ኑስ ኢሜርኬቲ› ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","«ሺን ጪንጫቲ ኤንታኮ ዛሪዲ፥ ‹ኣካይ፥ ኑሲኔ ሂንቴስ ጊዲያ ላምቢ ባዋ። ሄሳ ጊሾ፥ ሂንቴው ቢዲ ሻሚዲ ኤኪቴ› ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","ኤያ ጌላዖቲ ላምባ ሻማናው ቢን፥ ማቺው ኤኬይሲ ፑቱ ጊስ። ጊጌቲ ኡቲዳ ኢቻሹ ጌላዖቲ ኢያራ ኢሲፌ ያጋኖ ኬꬃ ጌሊዶሶና፤ ካሬይካ ጎርዴቲ ኣጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","«ጉዬፔ ሃንኮ ጌላዖቲ ዪዲ፥ ‹ጎዳው፥ ጎዳው፥ ኑስ ዶያርኪ› ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","«ሺን ኢ ኤንታኮ ዛሪዲ፥ ‹ታኒ ሂንቴው ቱማ ኦዳይስ፤ ታ ሂንቴና ኤሪኬ!› ");
INSERT INTO gofENT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","«ሂዛ፥ ኣሳ ናዓይ ያና ጋላሳ ዎይኮ ሳቲያ ሂንቴ ኤሮና ጊሾ ባርኪዲ ናጊቴ። ");
INSERT INTO gofENT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","«ፆሳ ካዎቴꬃይ ባ ኦሳንቾታ ፄጊዲ ባው ዴዒያባ ኤንታው ሼꬊዲ ኦጌ ባናው ኬዪዳ ኡራ ዳኔስ። ");
INSERT INTO gofENT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","ኤንታው ሁዔን ሁዔን ኤንታ ዎልቃ ሜላ ኢሱዋስ ኢቻሹ ካርፂቴ ቢራ፥ ኢሱዋስ ናምዑ ካርፂቴ ቢራ ቃሲ ኢሱዋስ ኢሲ ካርፂቴ ቢራ ኢሚዲ ባ ኦጊያ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","ኢቻሹ ካርፂቴ ቢራ ኤኪዳ ኣይሌይ ሶሁዋራ ቢዲ ዛልዒዲ፥ ሃራ ኢቻሹ ካርፂቴ ቢራ ዎꬊሲስ። ");
INSERT INTO gofENT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","ሄሳዳካ፥ ቃሲ ናምዑ ካርፂቴ ቢራ ኤኪዳ ኣይሌይ ሃራ ናምዑ ካርፂቴ ቢራ ዎꬊሲስ። ");
INSERT INTO gofENT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","ሺን ኢሲ ካርፂቴ ቢራ ኤኪዳይሲ ቢዲ፥ ኦላ ቦኪዲ፥ ባ ጎዳ ሚሺያ ሞጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","«ዳሮ ዎዴፔ ጉዬ ሄ ኣይሌታ ጎዳይ ዪዲ፥ ባ ሚሺያ ኤንታራ ሳላዒስ። ");
INSERT INTO gofENT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","ኢቻሹ ካርፂቴ ቢራ ኤኪዳ ኣይሌይ ዪዲ፥ ሃራ ኢቻሹ ካርፂቴ ቢራ ኤሂዲ፥ ‹ታ ጎዳው፥ ኔኒ ታው ኢቻሹ ካርፂቴ ቢራ ኢማዳሳ። ሺን ታኒ ሃራ ኢቻሹ ካርፂቴ ቢራ ዎꬊሳስ› ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","ኢያ ጎዳይ፥ ‹ዛምቦይ! ኔኒ ሎዖኔ ኣማንꬂያ ኣይሌ፤ ኔኒ ጉꬃባን ኣማኔታዳሳ። ታኒ ኔና ዳሮባ ቦላ ሹማና፤ ሃ ጌላዳ ኔ ጎዳራ ኡፋይታ› ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","«ቃሲ ናምዑ ካርፂቴ ቢራ ኤኪዳይሲ ዪዲ፥ ‹ታ ጎዳው፥ ኔኒ ታው ናምዑ ካርፂቴ ቢራ ኢማዳሳ። ሺን ታኒ ሃራ ናምዑ ካርፂቴ ቢራ ዎꬊሳስ› ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","ኢያ ጎዳይ፥ ‹ዛምቦይ! ኔኒ ሎዖኔ ኣማንꬂያ ኣይሌ፤ ኔኒ ጉꬃባን ኣማኔታዳሳ። ታኒ ኔና ዳሮባ ቦላ ሹማና፤ ሃ ጌላዳ ኔ ጎዳራ ኡፋይታ› ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","«ቃሲ ኢሲ ካርፂቴ ቢራ ኤኪዳይሲ ዪዲ፥ ‹ታ ጎዳው፥ ኔኒ ዜሮና ቤሳፌ ጫኬይሳኔ ꬋርጮና ቤሳፌ ማፂያ ኢታ ኣሲ ጊዴይሳ ታኒ ኤራይስ። ");
INSERT INTO gofENT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","ሄሳ ጊሾ፥ ያያዳ ኔ ቢራ ቢታን ሞጋስ። ኔ ሚሼይ ሃይሲሽ› ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","«ኢያ ጎዳይ ዛሪዲ፥ ‹ሃ ኢታ ኣዛላ ኣይሊያው፥ ታኒ ዜሮና ቤሳፌ ጫኬይሳኔ ꬋርጮና ቤሳፌ ማፂያ ኣሲ ጊዴይሳ ኤራዳሳ። ");
INSERT INTO gofENT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ያቲን፥ ኔኒ ታ ሚሺያ ባንኬን ዎꬂዳባ ጊዲያኮ፥ ታኒ ሲሚያ ዎዴ ታ ሚሺያ ዎꬌራ ኤካናይሳ ዲጋዳሳ። ");
INSERT INTO gofENT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","ሄሳ ጊሾ፥ ሚሺያ ኢያፔ ኤኪዲ፥ ታሙ ካርፂቴ ቢሪ ዴዔይሳስ ኢሚቴ። ");
INSERT INTO gofENT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","ኣይስ ጊኮ፥ ዴዒያ ኡባስ ጉዤታናኔ ዳራና። ሺን ባይናይሳፌ ሃሪ ኣቶሺን፥ ሄ ኢያው ዴዒያ ጉꬂያካ ኤኬታና። ");
INSERT INTO gofENT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","ሃ ማዶና ኣይሊያ ካሬ ꬉማ ኬሲ ዬጊቴ። ያን ኢያው ዬሆኔ ኣቼ ጋርጬꬂ ጊዳና› ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","«ኣሳ ናዓይ፥ ኪታንቾ ኡባታራ፥ ባ ቦንቹዋራ ያ ዎዴ ኢ ባ ቦንቾ ካዎታ ኣራታ ቦላ ኡታና። ");
INSERT INTO gofENT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","ቢታን ዴዒያ ኣሲ ኡባይ ኢያ ሲንꬄ ሺቃና። ሄንꬃንቾይ ዶርሳታ ዴሻታፔ ሻኬይሳዳ ኢ ሄ ኣሳ ናምዓን ሻካና። ");
INSERT INTO gofENT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","ቃሲ ዶርሳታ ኡሻቻ ባጋራ ዴሻታ ሃዲርሳ ባጋራ ኤሳና። ");
INSERT INTO gofENT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","«ሄሳፌ ጉዬ፥ ካዎይ ኡሻቻ ባጋራ ዴዔይሳታኮ ሃይሳዳ ያጋና፡ ‹ታ ኣዋይ ኣንጂዳይሳቶ፥ ሃ ዪዲ ሳዓይ ሜꬌቲያ ዎዴ ሂንቴው ጊጊዳ ካዎቴꬃ ላቲቴ። ");
INSERT INTO gofENT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","ኣይስ ጊኮ፥ ታኒ ኮሻቲን ሙዚዴታ፥ ሳሞቲን ኡሺዴታ፥ ኤሬቶና ኢማꬃ ኣሲ ጊዳዳ ቢን ሞኪዴታ፥ ");
INSERT INTO gofENT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","ካሎቲን ማይዚዴታ፥ ሃርጌቲን ሃርጊሲዴታ፥ ቃሼቲን ታና ኦይቺዴታ› ያጋና። ");
INSERT INTO gofENT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","«ሄሳፌ ጉዬ፥ ፂሎቲ ዛሪዲ፥ ‹ጎዳው፥ ኔኒ ኮሻቲን ኣዉዴ ቤዒዲ ሙዚዶ? ዎይኮ ኔኒ ሳሞቲን ኣዉዴ ቤዒዲ ኡሺዶ? ");
INSERT INTO gofENT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","ኔኒ ኢማꬄ ጊዳዳ ዪን ኣዉዴ ቤዒዲ ሞኪዶ? ዎይኮ ኔኒ ካሎቲን ኣዉዴ ማይዚዶ? ");
INSERT INTO gofENT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","ኔኒ ሃርጊን ዎይኮ ቃሼቲን ኔኮ ቢዲ ኔና ኣዉዴ ኦይቺዶ?› ያጋና። ");
INSERT INTO gofENT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","ካዎይ ዛሪዲ፥ ‹ታኒ ሂንቴው ቱማ ኦዳይስ፤ ሂንቴ ታና ካሊያ ሃ ኡባፌ ጉፄይሳስ ኦꬂዳይሳ ታው ኦꬂዴታ› ያጋና። ");
INSERT INTO gofENT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","«ሄ ዎዴ ሃዲርሳ ባጋራ ዴዔይሳታኮ፥ ‹ሃ ቃንጌቲዳይሳቶ፥ ታ ማታፔ ሃኪቴ። ፃላሄሲኔ ኢያ ኪታንቾታስ ጊጊዳ ሜሪና ታማን ቢቴ። ");
INSERT INTO gofENT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","ኣይስ ጊኮ፥ ኮሻቲን ታና ሙዚቤኬታ፤ ሳሞቲን ኡሺቤኬታ። ");
INSERT INTO gofENT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ታኒ ኢማꬄ ጊዳዳ ቢን ታና ሞኪቤኬታ፥ ካሎቲን ማይዚቤኬታ፥ ሃርጊኒኔ ቃሼቲን ታና ኦይቺቤኬታ› ያጋና። ");
INSERT INTO gofENT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","«ሄ ዎዴ ኤንቲ፥ ‹ጎዳው፥ ኔኒ ኮሻቲን ዎይኮ ሳሞቲን ዎይኮ ኢማꬄ ጊዳዳ ቢን ዎይኮ ካሎቲን ዎይኮ ሃርጊን ዎይኮ ቃሼቲን ቤዒዲ ኔና ኣዉዴ ማዶና ኢፂዶ?› ያጊዲ ዛራና። ");
INSERT INTO gofENT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","«ሄ ዎዴ ካዎይ ዛሪዲ ኤንታኮ፥ ‹ታኒ ሂንቴው ቱማ ኦዳይስ፤ ሂንቴ ታና ካሊያ ሃ ኡባፌ ጉፄይሳ ማዶና ኢፂዳይሲ፥ ታና ማዶና ኢፂዳይሳ› ያጋና። ");
INSERT INTO gofENT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","ሄሳ ጊሾ፥ ሄ ኣሳቲ ሜሪና ፒርዳስ ቃሲ ፂሎቲ ሜሪና ዴዑዋስ ባና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","ዬሱሲ ሃ ቲሚርቲያ ኡባ ዉርሲዳ ዎዴ ባ ታማሬታኮ፥ ");
INSERT INTO gofENT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«ናምዑ ጋላሳፔ ጉዬ፥ ፓሲካ ባሌ ቦንቺያ ጋላስ ጊዴይሳ ኤሬታ። ሄ ጋላስ ኣሳ ናዓይ ማስቃሊያ ቦላ ካቄታናው ኣሳ ኩሼን ኣꬊ ኢሜታና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","ሄ ዎዴ ካሂኔ ሃላቃቲኔ ጪማቲ፥ ቃያፋ ጊያ ካሂኔ ሃላቃ ኬꬃን ሺቂዲ፥ ");
INSERT INTO gofENT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ኣሲ ኤሮና ዬሱሳ ኦይኪዲ፥ ዎꬋናው ማቄቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","ሺን ኤንቲ፥ «ኣሳይ ኦሺ ኬሶና ሜላ ጊዲ፥ ፓሲካ ቦንቺያ ጋላስ ሄሳ ኦꬆኮ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","ዬሱሲ ቢታኒያ ካታማን ባሮ ሃርጊዳ ሲሞና ሶን ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ዬሱሲ ኢማቱዋ ቦላ ዴዒሺን ኢሲ ማጫሲያ ኣልባስፂሮሴ ጲልቃፄ ኩሜꬃ ዳሮ ኣልዖ ሺቶ ኤካ ያዳ ዬሱሳ ሁዔን ቲጋሱ። ");
INSERT INTO gofENT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","ሺን ዬሱሳ ታማሬቲ ሄሳ ቤዒዲ ሃንቄቲዲ፥ «ሃ ሺቶይ ጮ ኢቴይ ኣይቢሴ? ");
INSERT INTO gofENT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","ሃ ሺቶይ ኣልዖ ጋቴን ባይዜቲዲ፥ ሚሼይ ማንቆታስ ኢሜታናው ዳንዳዔቴስ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","ዬሱሲ ኤንቲ ጌይሳ ኤሪዲ፥ ኤንታኮ፥ «ሃ ማጫሲው ኣይስ ዋይሴቲ? ኢያ ታው ሎዖባ ኦꬃሱ። ");
INSERT INTO gofENT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","ማንቆቲ ኡባ ዎዴ ሂንቴራ ዳና። ሺን ታኒ ሂንቴራ ኡባ ዎዴ ዴዒኬ። ");
INSERT INTO gofENT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","ኢያ ሃ ሺቱዋ ታ ቦላ ቲጊዳይሲ ታና ሞጋናው ጊጊሳናሳ። ");
INSERT INTO gofENT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","ታኒ ሂንቴው ቱማ ኦዳይስ፤ ቢታ ኡባን ሃ ዎንጌላይ ሳባኬቲያ ቤሳን ኣዉንካ፥ ኣሳይ ኢዮ ሃሳያና ሜላ ኢያ ኦꬂዳይሲ ኦዴታና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","ሄ ዎዴ ታማኔ ናምዑ ዬሱሳ ታማሬታፔ ኢሶይ፥ ኣስቆሮታ ዪሁዳ ጌቴቴይሲ ካሂኔ ሃላቃታኮ፥ ");
INSERT INTO gofENT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ቢዲ፥ «ታኒ ሂንቴው ዬሱሳ ኣꬃ ኢሚኮ፥ ሂንቴ ታው ኣይ ኢማኔ?» ያጊዲ ኤንታ ኦይቺስ። ኤንቲ ዞሬቲዲ ሃስታሙ ቢራ ሳንቲሜ ኢሚዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","ሄሳፌ ጉዬ፥ ዪሁዲ ዬሱሳ ኣꬂዲ ኢማናው ኢንጄቲያ ዎዴ ዎቼስ። ");
INSERT INTO gofENT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","ኡይꬃ ባሌ ቦንቺያ ኮይሮ ጋላስ፥ ዬሱሳ ታማሬቲ ኢያኮ ዪዲ፥ «ፓሲካ ቦንቺያ ጋላስ ኔኒ ማና ካꬂ ኑኒ ኣዉን ጊጊሲኖ?» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","ዬሱሲ ኤንታኮ፥ «ካታማን ዴዒያ ኣዲያኮ ቢዲ፥ ‹ኣስታማሬይ፥ ታው ዎዴይ ጋኪዳ ጊሾ ታ ታማሬታራ ፓሲካ ቦንቺያ ጋላሳ ኔ ሶን ኣꬃና ያጌስ› ያጊቴ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","ኢያ ታማሬቲ ዬሱሲ ባንታና ኪቲዳይሳዳ ኦꬂዲ፥ ፓሲካ ባሌ ጋላስ ማና ካꬃ ጊጊሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","ሳዓይ ኦማርሲያ ዎዴ ዬሱሲ ታማኔ ናምዑ ሃዋሬታራ ካꬂ ማናው ኡቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","ኤንቲ ሚሺን፥ ዬሱሲ ኤንታኮ፥ «ታኒ ሂንቴው ቱማ ኦዳይስ፤ ሂንቴፌ ኢሲ ኡራይ ታና ኣꬂዲ ኢማና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","ኤንቲ ዳሮ ዳጋሚዲ፥ ሁዔን ሁዔን፥ «ጎዳው፥ ቱማ ታኔሻ?» ጊዲ ኢያ ኦይቺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","ዬሱሲ ዛሪዲ፥ «ባ ኩሺያ ታራ ኢሲፌ ሻቲያን ዬዴይሲ ኢ ታና ኣꬂዲ ኢማና። ");
INSERT INTO gofENT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","ኣሳ ናዓይ፥ ፆሳ ቃላን ኢያው ፃፌቲዳይሳዳ ሃይቃና። ሺን ኣሳ ናዓ ኣꬂዲ ኢሚያ ኡራ ኣዬ፤ ሄ ኡራይ ዬሌቶና ኣቲዳኮ ኢያው ሎዖሺን» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","ኢያ ኣꬂ ኢማናው ዴዒያ ዪሁዲ ዛሪዲ፥ «ኣስታማሪያው፥ ኔኒ ጌይ ታኔዬ?» ያጊስ። ዬሱሲ ዛሪዲ፥ «ኔኒ ኔ ሁዔን ጋዳሳ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","ኤንቲ ሚሺን፥ ዬሱሲ ኡይꬃ ኤኪዲ ፆሳ ጋላቲስ። ሄ ኡይꬃ ሜንꬂዲ ባ ታማሬታስ ኢሚዲ፥ «ሄዒቴ፥ ሚቴ፥ ሃይሲ ታ ኣሹዋ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","ፁዓ ኤኪዲ፥ ፆሳ ጋላቲስ። ኤንታው ኢሚዲ፥ «ኡባይ ሃይሳፌ ኡዪቴ። ");
INSERT INTO gofENT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","ሃይሲ ዳሮ ኣሳ ናጋራይ ኣቶ ጌቴታና ሜላ ጉኪያ ታ ሱꬃ። ሃ ሱꬃይ ፆሳይ ሂንቴራ ጌሊያ ጫቁዋ ሚንꬄይሳ። ");
INSERT INTO gofENT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","ሺን ታኒ ሂንቴው ኦዳይስ፤ ታኒ ታ ኣዋ ካዎቴꬃን ኦራꬃ ዎይኔ ኡሻ ሂንቴራ ኡያና ጋላሳ ጋካናው ናምዓንꬆ ሃ ዎይኔ ኡሻ ኡዪኬ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","ጋላታ ማዝሙሬ ዬፂዳይሳፌ ጉዬ ሻማሆ ዴሪያ ቢዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","ሄ ዎዴ ዬሱሲ ኤንታኮ፥ « ‹ፆሳይ ሄንꬃንቹዋ ሾጫና ዶርሳቲካ ላሌታና› ጌቴቲዲ ፆሳ ቃላን ፃፌቲዳይሳ ሜላ ሃቺ ቃማ ሂንቴ ኡባይ ታና ኣጊዲ ባቃታና። ");
INSERT INTO gofENT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","ሺን ታኒ ሃይቆፔ ዴንዲዳፔ ጉዬ ሂንቴፌ ሲንꬃታዳ ጋሊላ ባና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","ጴፂሮሲ ዛሪዲ፥ «ኤንቲ ኡባይ ኔና ኣጊዲ ባቃቲኮካ፥ ታኒ ኔና ኣጊኬ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","ዬሱሲ ጴፂሮሳኮ፥ «ታኒ ኔው ቱማ ኦዳይስ፤ ሃቺ ቃማ ኩቶይ ዋሳናፔ ሲንꬄ ኔኒ ታና ሄꬑ ቶሆ ካዳና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","ጴፂሮሲ ዛሪዲ፥ «ታኒ ኔራ ኢሲፌ ሃይቆፔ ኣቲን ኔና ኡባካ ካዲኬ» ያጊስ። ሃንኮ ኢያ ታማሬቲ ኡባይካ ሄሳዳ ጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","ያቲዲ፥ ዬሱሲ ባ ታማሬታራ ጌቴሴማኔ ጊያ ቤሳ ቢዲ፥ ኤንታኮ፥ «ታኒ ሂኒ ባዳ ፆሳ ዎሳሻና፥ ሂንቴ ሃይሳን ኡቲቴ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","ጴፂሮሳኔ ዛብዲዮሳ ናይታ ናምዓታ ባራ ኤኪ ቢዲ ዳሮ ኣዛኖኔ ኡንዔቴꬂ ዶሚስ። ");
INSERT INTO gofENT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","ቃሲካ ኤንታኮ፥ «ታኒ ሃይቆስ ጋꬂያ ኡንዓ ኡንዔታስ። ሃይሳን ታራ ጋምዒቴኔ ሚኒዲ ናጊቴ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","ጉꬂ ሲንꬄ ቢዲ ቢታን ጉፋኒዲ፥ «ታ ኣዋው፥ ዳንዳዔቲያባ ጊዲኮ ሃ ዋዬ ፁዓ ታፔ ዲጋ። ሺን ኔ ሼኔይ ሃኖፔ ኣቲን ታ ሼኔይ ሃኖፖ» ያጊዲ ፆሳ ዎሲስ። ");
INSERT INTO gofENT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","ዬሱሲ ባ ታማሬታኮ ሲሚ ዪዲ ኤንቲ ꬊስኪዳሺን ዴሚስ። ጴፂሮሳኮ፥ «ሂንቴ ኢሲ ሳቴኮኔ ꬊስኮና ታራ ሚናናው ዳንዳዒቤኬቲ? ");
INSERT INTO gofENT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","ፓጬን ሂንቴ ጌሎና ሜላ ባርኪዲ ናጊቴኔ ፆሳ ዎሲቴ። ሂንቴው ሎዖ ኣሞይ ዴዔስ፥ ሺን ሂንቴ ዳቡራንቾ ኣሲ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","ዬሱሲ ቃሲ ናምዓንꬆ ቢዲ፥ «ታ ኣዋው፥ ታኒ ሃ ዋዬ ፁዓፔ ኡዮና ዴዒሼ ኣꬋናው ዳንዳዔቶናባ ጊዲኮ ኔ ሼኔይ ሃኖ» ያጊዲ ፆሳ ዎሲስ። ");
INSERT INTO gofENT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","ቃሲካ ሲሚ ያ ዎዴ ኢያ ታማሬታ ኣይፊያ ꬊስኮይ ጎዚን፥ ዚንዒዳሺን ዴሚስ። ");
INSERT INTO gofENT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","ቃሲካ ኤንታ ኣጊ ቢዲ፥ ካሴ ቃላ ዛሪ ሄꬓንꬆ ዎሲስ። ");
INSERT INTO gofENT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","ሄሳፌ ጉዬ፥ ባ ታማሬታኮ ዪዲ፥ «ሃዒ ጋካናው ꬊስኬቲኔ ሼምፔቲ? ሄኮ፥ ኣሳ ናዓይ፥ ናጋራንቾታ ኩሼን ኣꬊ ኢሜቲያ ሳቴይ ጋኪስ። ");
INSERT INTO gofENT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","ዴንዲዲ ዬꬊቴ፥ ታና ኣꬂዲ ኢሜይሲ ሃይሲሽ ጋኪስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","ዬሱሲ ቡሮ ሄሳ ሃሳዪሺን፥ ታማኔ ናምዑ ታማሬታፔ ኢሶይ፥ ዪሁዲ ጋኪ ዎꬊስ። ካሂኔ ሃላቃቲኔ ዴሪያ ጪማቲ ኪቲዳ ዳሮ ኣሳቲ ማሼኔ ፃምዓ ኦይኪዲ ኢያራ ኢሲፌ ዪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","ዬሱሳ ኣꬂ ኢሚያ ዪሁዲ ሄ ዳሮ ኣሳኮ፥ «ታኒ ዬሬይሲ ሂንቴ ኮዬይሲ ኢያ፥ ኢያ ኦይኪቴ» ያጊዲ ማላ ኢሚ ዎꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","ኢራካ ዬሱሳኮ ሺቂዲ፥ «ኣስታማሪያው፥ ሳሮ ዴዓይ» ያጊዲ ኢያ ዬሪስ። ");
INSERT INTO gofENT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","ዬሱሲ ኢያኮ፥ «ታ ላጊያው፥ ኔኒ ኦꬃናባ ኦꬃ ኣጋ» ያጊስ። ሄሳፌ ጉዬ፥ ሺቂዲ፥ ዬሱሳ ኦይኪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","ዬሱሳራ ዴዔይሳታፔ ኢሶይ ባ ማሻ ሾዲዲ ካሂኔ ሃላቃ ኣይሊያ ሾጪዲ፥ ኢያ ሃይꬃ ቃንፂዲ ዬጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","ሺን ዬሱሲ፥ «ኔ ማሻ ጉዬ ሾሁዋን ዛራ። ኣይስ ጊኮ፥ ማሻ ሾዲያ ኡባይ ማሻን ሃይቃና። ");
INSERT INTO gofENT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","ታ፥ ታ ኣዋ ዎሲያኮ ዳሮ ሙኩሉን ታይቤቲያ ኪታንቾታ ዬዳናው ዳንዳዖናባ ኔው ዳኒ? ");
INSERT INTO gofENT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","ያቲን፥ ፆሳ ቃላን ሄሳዳ ሃናናው ቤሴስ ጌቴቲዳይሲ ዋኒዲ ፖሌታኔ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","ሄ ሳቲያን፥ ዬሱሲ ሄ ሺቂዳ ዳሮ ኣሳኮ፥ «ታና ፓንጋ ኦꬂዲ ኦይካናው ማሼኔ ፃምዓ ኦይኪዲ ዪዴቲ? ታኒ ፆሳ ኬꬃን ጋላስ ጋላስ ታማርሳሼ ሂንቴራ ዴዒያ ዎዴ ታና ኦይኪቤኬታ። ");
INSERT INTO gofENT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","ሺን ሃይሲ ኡባይ ሃኒዳይሲ ናቤቲ ፆሳ ቃላን ፃፊዳይሲ ፖሌታና ሜላሳ» ያጊስ። ሄ ዎዴ ኢያ ታማሬቲ ኡባይ ኢያ ኣጊዲ ባቃቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","ዬሱሳ ኦይኪዳይሳቲ ካሂኔ ሃላቃ ቃያፋኮ ኢያ ኤፊዶሶና። ያን ሂጌ ኣስታማሬቲኔ ቢታ ጪማቲ ሺቂዲ ዴዖሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","ሺን ጴፂሮሲ ካሂኔ ሃላቃ ዛባ ጋካናው ሃሆን ኢያ ካሊስ። ኢያ ዉርሴꬃይ ሻኬታና ጋካናው ዛባ ጌሊዲ ናጌይሳታራ ኡቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","ካሂኔ ሃላቃቲኔ ሺቂዳ ኣሳ ኡባይ ዬሱሳ ዎꬋናው ኢያ ቦላ ዎርዶ ማርካ ኮዪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","ዳሮቲ ዪዲ ኢያ ቦላ ዎርዶ ማርካ ማርካቲዶሶና፥ ሺን ኣይኮካ ዴሚቦኮና። ጉዬፔ ናምዑ ኣሳቲ ዪዲ፥ ");
INSERT INTO gofENT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","«ሃ ኡራይ፥ ‹ታኒ ፆሳ ኬꬃ ላላዳ ሄꬑ ጋላሳን ዛራ ኬፃናው ዳንዳዓይስ› ያጊስ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","ካሂኔታ ሃላቃይ ዴንዲ ኤቂዲ ዬሱሳኮ፥ «ሃይሳቲ ኔና ሞቲያ ሞቶዋስ ኔኒ ዛሪያባይ ባዌ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","ሺን ዬሱሲ ሲዒ ጊስ። ቃሲካ ካሂኔ ሃላቃይ፥ «ታኒ ኔና ዴዖ ፆሳ ሱንꬃን ኦይካይስ፤ ኔኒ ፆሳ ናዓ ኪሪስቶሳ ጊዲኮ ኑስ ኦዳ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","ዬሱሲ ዛሪዲ፥ «ኔኒ ኔ ሁዔንካ ጋዳሳ። ሺን ታኒ ሂንቴው ኦዳይስ፤ ሂዛፔ ጉዬ፥ ኣሳ ናዓይ ዎልቃማ ፆሳ ኡሻቻ ባጋን ኡቲዳሺን፥ ቃሲ ሳሎ ሻራራ ዪሺን ሂንቴ ቤዓና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","ሄ ዎዴ ካሂኔ ሃላቃይ ዳሮ ዪሎቲዲ ባ ማዑዋ ፔꬊዲ፥ «ሃይሳ ቤዒቴ ፆሳ ጫዪስ! ኑና ሃራ ማርካ ኣይ ኮሺ? ኢ ሃዒ ጫዪዳይሳ ሂንቴ ሲዒዴታ። ");
INSERT INTO gofENT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","ሂንቴ ቆፋይ ኣይቤ?» ያጊስ። ኤንቲካ፥ «ኢያው ሃይቆ ቤሴስ» ያጊዲ ዛሪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","ያቲን፥ ኤንቲ ኢያ ሶምዖን ጩቲዲ ዴቺዶሶና። ሃራቲ ኢያ ባቂዲ፥ ");
INSERT INTO gofENT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","«ኪሪስቶሳ! ኔና ዴቺዳይ ኦኔ? ኣኔ ኑስ ኦዳ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","ጴፂሮሲ ዛባን ኡቲዳሺን፥ ኢሲ ኣይሊያ ኢያኮ ያዳ፥ «ኔኒካ ጋሊላ ዬሱሳራ ኢሲፌ ዴዓሳ» ያጋሱ። ");
INSERT INTO gofENT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","ሺን ኢ ኤንታ ኡባ ሲንꬃን ሄ ኣይሌኮ፥ «ኔኒ ጊያባይ ኣይቤኮ ታኒ ኤሪኬ» ያጊዲ ካዲስ። ");
INSERT INTO gofENT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","ቃሲ ቢዲ ዲርሳ ፔንጌኮ ጋኪሺን ሃራ ኣይሊያ ኢያ ቤዓዳ፥ ያን ዴዒያ ኣሳኮ፥ «ሃ ኡራይ ናዚሬቴ ዬሱሳራ ዴዔስ» ያጋሱ። ");
INSERT INTO gofENT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","ጴፂሮሲ ናምዓንꬆ ጫቂዲ፥ «ታኒ ሄ ኡራ ኤሪኬ!» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","ጉꬁ ጋምዒሺን፥ ያን ኤቂዳ ኣሳቲ ጴፂሮሳኮ ዪዲ፥ «ኔካ ቱማ ኤንታራ ኢሲፌ ዴዓሳ፤ ኔኒ ኔ ሃሳያን ኤሬታሳ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","ሄሳፌ ጉዬ፥ ጴፂሮሲ፥ «ታኒ ሄ ኡራ ኤሪኬ!» ያጊዲ፥ ባና ቃንጌꬂኔ ጫቆ ዶሚስ። ሄ ዎዴ ኢራካ ኩቶይ ዋሲ ኣጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","ዬሱሲ ኢያኮ፥ «ኔኒ ኩቶይ ዋሳናፔ ሲንꬄ ታና ሄꬑ ቶሆ ካዳና» ጊዳይሳ ጴፂሮሲ ኣኬኪዲ፥ ካሬ ኬዪዲ ኢታ ዬሆ ዬኪስ። ");
INSERT INTO gofENT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","ዎንታ ጉራ ካሂኔ ሃላቃቲኔ ቢታ ጪማቲ ኡባይ ዬሱሳ ዎꬊሳናው ማቄቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","ኤንቲ ዬሱሳ ቃቺ ኤፊዲ ዴሪያ ሃሪያ ጲላፆሳስ ኣꬂዲ ኢሚዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","ሄ ዎዴ ዬሱሳ ኦይꬂዳ ዪሁዲ፥ ጲላፆሲ ዬሱሳ ቦላ ፒርዲዳይሳ ቤዒዲ፥ ቂሮቲዲ፥ ሄ ሃስታሙ ቢራ ሳንቲሚያ ካሂኔ ሃላቃታሲኔ ዴሪያ ጪማታስ ጉዬ ዛሪስ። ");
INSERT INTO gofENT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","«ታኒ ፂሎ ኣሲ ሃይቆስ ኣꬃ ኢማዳ ናጋራ ኦꬃስ» ያጊስ። ሺን ኤንቲ፥ «ሄሲ ኑ ሜቶ ጊዴና ኔ ሜቶ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","ዪሁዲ ሚሺያ ፆሳ ኬꬃን ዬጊ ኣጊዲ ኤንታ ማታፔ ቢዲ፥ ሱሌቲ ሃይቂስ። ");
INSERT INTO gofENT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","ካሂኔ ሃላቃቲ ሚሺያ ኤኪዲ፥ «ሃ ሚሼይ ሱꬃ ሚሼ ጊዲያ ጊሾ ኑኒ ፆሳ ኬꬃ ሚሺያራ ጋꬄይሲ ዎጋ ጊዴና» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","ሄሳፌ ጉዬ፥ ኢሲፌ ዞሬቲዲ፥ ቤቴ ኣሲ ሞጋናው ማና ቢታ ሻሚዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","ሄሳ ጊሾ፥ ሄ ጋዴይ ሃቺ ጋካናው ሱꬃ ቢታ ጌቴቲ ፄጌቴስ። ");
INSERT INTO gofENT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","ናቢያ ኤርሚያሲ፥ «ኢስራዔሌ ኣሳይ ኢያው ቃንፃናው ጋማቲዳ ሃስታሙ ቢራ ሳንቲሜ ኤኪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ጎዳይ ታና ኪቲዳይሳዳ ማና ቢታ ሻማናው ኢሚዶሶና» ጊዳይሲ ሄ ዎዴ ፖሌቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","ዬሱሲ ዴሪያ ሃሪያ ጲላፆሳ ሲንꬄ ሺቂን፥ ጲላፆሲ ኢያኮ፥ «ኔኒ ኣይሁዴ ካዎ?» ያጊዲ ኦይቺስ። ዬሱሲ ዛሪዲ፥ «ኔ ጋዳሳ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","ካሂኔ ሃላቃቲኔ ቢታ ጪማቲ ኢያ ሞቲያ ዎዴ ኤንታው ኣይቢ ዛሮካ ኢሚቤና። ");
INSERT INTO gofENT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","ሄ ዎዴ ጲላፆሲ ዬሱሳኮ፥ «ሃይሳቲ ኔና ሞቲያ ሞቱዋ ኡባ ሲዒኪ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","ዬሱሲ ሃሪ ኣቶሺን፥ ኢሲ ቃላካ ዛሮና ኢፂን፥ ዴሪያ ሃሬይሲ ዳሮ ማላሌቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","ዴሪያ ሃሬይሲ ላይꬃን ላይꬃን ፓሲካ ባሌ ቦንቺያ ጋላሳን፥ ኣሳይ ኮያ ኢሲ ኣሲ ቃሾፔ ቢርሺያ ዎጊ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","ሄ ዎዴ ኢሲ ባርባና ዬሱሳ ጊያ ዳሮ ኤሬቲዳ ኢታ ኣሲ ቃሾ ኬꬃን ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","ሄሳ ጊሾ፥ ዳሮ ኣሳይ ሺቂዲ ዴዒሺን ጲላፆሲ፥ «ታኒ ሂንቴው ባርባና ዬሱሳ ቢርሾዬ፥ ዎይኮ ዬሱሳ ጊያ ኪሪስቶሳ ቢርሾ?» ያጊዲ ኣሳ ኦይቺስ። ");
INSERT INTO gofENT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","ኢ ሄሳ ጊዳይ ኤንቲ ቃናቲዲ ዬሱሳ ኦይꬂዳይሳ ኤሪያ ጊሾሳ። ");
INSERT INTO gofENT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","ጲላፆሲ ፒርዳ ኬꬃን ኡቲዳሺን፥ ኢያ ማቺያ፥ «ታኒ ሃቺ ቃማ ኣሙሆን ኢያባ ዳሮ ዋዬታሼ ኣቂዳ ጊሾ ሄ ፂሎ ኡራ ቦላ ኣይቢባካ ኦꬆፋ» ያጋዳ ኪታሱ። ");
INSERT INTO gofENT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","ሺን ካሂኔ ሃላቃቲኔ ዴሪያ ጪማቲ ጲላፆሲ ባርባና ቢርሺዲ፥ ዬሱሳ ዎꬋና ሜላ፥ ኣሳይ ኢያ ዎሳና ሜላ፥ ኣሳ ጪሚዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","ጲላፆሲ ዛሪዲ ኤንታኮ፥ «ታኒ ኤንታ ናምዓፌ ሂንቴው ኦና ቢላና ሜላ ኮዬቲ?» ያጊዲ ኦይቺስ። ኤንቲ፥ «ባርባና ቢላና ሜላ ኮዮስ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","ጲላፆሲ፥ «ያቲን፥ ዬሱሳ ጊያ ኪሪስቶሳ ዋቶ?» ያጊዲ ኤንታ ኦይቺስ። ኡባይ ዛሪዲ፥ «ማስቃሊያ ቦላ ኢያ ካቃ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","ጲላፆሲ ኣሳኮ፥ «ኣይስ? ኢ ኣይ ኢታባ ኦꬂዴ?» ያጊዲ ኦይቺስ። ሺን ኣሳይ ካሴይሳፌ ኣꬂዲ፥ «ማስቃሊያ ቦላ ኢያ ካቃ» ጊዲ ዋሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","ኦሺ ዴንꬄꬆፌ ሃራ ኣይቢባካ ኦꬃናው ዳንዳዔቶናይሳ ጲላፆሲ ቤዒዲ፥ ሃꬄ ኤኪዲ፥ «ሃ ኡራ ሃይቁዋን ታኒ ዴዒኬ። ሄሳ ኦꬄይ ሂንቴና» ያጊዲ ኣሳ ሲንꬃን ባ ኩሺያ ሜጬቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","ኣሳ ኡባይ ዛሪዲ፥ «ኢያ ሱꬃ ጎሜይ ኑናኔ ኑ ናይታ ጋኮ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","ያቲን፥ ጲላፆሲ ባርባና ኤንታው ቢሊዲ፥ ዬሱሳ ሊሶን ጋራፊዲ፥ ማስቃሊያ ቦላ ካቄቲዲ ሃይቃና ሜላ ኤንታው ኣꬂዲ ኢሚስ። ");
INSERT INTO gofENT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","ሄሳፌ ጉዬ፥ ጲላፆሳ ዎታዳሬቲ ዬሱሳ ዴሪያ ሃሬይሳ ሶ ኤኪ ኤፊን፥ ዎታዳሬቲ ኡባይ ኢያ ዩሹዋን ኤቂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","ኢያ ኣፊላ ቃሪ ኤኪዲ ዞዖ ኣፊላ ማይዚዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","ቃሲ ኣጉንꬃ ካላቻ ጊጊሲዲ፥ ኢያ ሁዔን ዎꬂዶሶና። ኢያ ኡሻቻ ኩሺያን ማይሬ ፃምዓ ኦይꬂዲ፥ ኢያ ሲንꬃን ጉልባቲዲ፥ «ኣይሁዴ ካዋው፥ ሙኩሉ ላይꬂ ካዎታ!» ያጊዲ፥ ኢያ ቦላ ቄልቂሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","ኢያ ቦላ ጩቲዶሶና። ሄ ማይሬ ፃምዓ ኤኪዲ፥ ኢያ ሁዔን ሾጪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","ኤንቲ ኢያ ቦላ ቄልቂሲዳይሳፌ ጉዬ ዞዖ ኣፊላ ኢያፔ ቃሪ ኤኪዲ፥ ኢያ ኣፊላ ኢያ ማይዚዶሶና። ማስቃሊያ ቦላ ኢያ ካቃናው ኤኪ ኤፊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","ኤንቲ ካሬ ኬዪዲ፥ ኢሲ ሲሞና ጊያ ቄሬና ቢታ ኣሲ ዴሚዲ፥ ዬሱሳ ማስቃሊያ ዎልቃን ቶሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","ጎልጎታ ጊያ ቤሲ ጋኪዶሶና። «ጎልጎታ» ጉሳይ «ጉጌ ቤሲ» ጉሱ። ");
INSERT INTO gofENT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ሄሳን ኤንቲ ጪዬ ዋላኬቲዳ ዎይኔ ኡሻ ኡዮ ጊዲ ኢያው ኢሚዶሶና። ሺን ኢ ሄሳ ጋንፂ ኤኪዲ፥ ኡዮና ኢፂስ። ");
INSERT INTO gofENT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","ኤንቲ ማስቃሊያ ቦላ ኢያ ካቂዳይሳፌ ጉዬ ኢያ ኣፊላ ሻኪዲ፥ ሳማ ዬጊዲ ኤኪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","ሄሳፌ ጉዬ፥ ያን ኡቲዲ ኢያ ናጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","ቃሲ፥ «ሃይሲ ኣይሁዴ ካዉዋ ዬሱሳ» ያጊያ ሞቶ ፁፊያ ኢያ ሁዔ ሶን ዎꬂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","ዬሱሳራ ሄ ዎዴ ናምዑ ፓንጋታ ኢሱዋ ኢያፔ ኡሻቻ ባጋን፥ ሃንኩዋ ኢያፔ ሃዲርሳ ባጋራ፥ ማስቃሊያ ቦላ ካቂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","ኦጊያራ ኣꬊያ ኣሳይ ዬሱሳ ቦሪዲ፥ ኢያ ቦላ ጩቲሼ፥ ");
INSERT INTO gofENT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","«ፆሳ ኬꬃ ላላዳ ሄꬑ ጋላሳ ጊዶን ኬፄይሶ፥ ኔና ኣሻ። ኔኒ ፆሳ ናዓ ጊዲኮ፥ ኣኔ ማስቃሊያ ቦላፌ ዎꬋ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","ሄሳዳካ፥ ካሂኔ ሃላቃቲ፥ ሂጌ ኣስታማሬቲኔ ቢታ ጪማቲ ኢሲፌ ዬሱሳ ቦላ ቄልቂሲዶሶና። ሃይሳዳ ያጊዶሶና፡ ");
INSERT INTO gofENT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«ሃራታ ኣሺስ፥ ሺን ባና ኣሻናው ዳንዳዒቤና። ኢ ኢስራዔሌ ካዎ ጊዲኮ፥ ኣኔ ማስቃሊያ ቦላፌ ሃዒ ዎꬎ፥ ኑካ ኢያ ኣማናና። ");
INSERT INTO gofENT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","ፆሳን ኢ ኣማኔቴስ፥ ፆሳይ ኢያ ኣሻናው ኮይኮ ኣኔ ኣሾ። ኣይስ ጊኮ፥ ኢ ባና፥ ‹ታኒ ፆሳ ናዓ› ጌስ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","ቃሲ ሃሪ ኣቶሺን፥ ኢያራ ማስቃሊያ ቦላ ካቄቲዳ ፓንጋቲካ ሄሳዳ ጊዲ ኢያ ቦላ ቄልቂሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","ኡሱፑን ሳቴፔ ቢዲ፥ ኡዱፉን ሳቴ ጋካናው ቢታ ኡባይ ꬉሚስ። ");
INSERT INTO gofENT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","ኡዱፉን ሳቴ ጊዲያ ዎዴ ዬሱሲ፥ «ኤሎሄ፥ ኤሎሄ፥ ላማ ሳባቂታኒ?» ጊዲ ጊታ ዋሶ ዋሲስ። «ኤሎሄ፥ ኤሎሄ፥ ላማ ሳባቂታኒ?» ጌይሳ ቢርሼꬃይ «ታ ፆሳው፥ ታ ፆሳው፥ ታና ኣይስ ኣጋዲ?» ጉሱ። ");
INSERT INTO gofENT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","ሄሳን ኤቂዳ ኣሳፔ ኢሶቲ ኢሶቲ ሄሳ ሲዒዲ፥ «ሃ ኡራይ ኤሊያሳ ፄጌስ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","ኢራ ኤንታፌ ኢሶይ ዎፂ ቢዲ፥ ኢስፖንጄ ኤኪዲ፥ ጫላ ዎይኔ ኡሻ ኩንꬂስ። ሄሳ ማይሬ ፃምዓ ፄራን ዎꬂዲ ኡሻናው ኢያ ዶናኮ ሺሺስ። ");
INSERT INTO gofENT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","ሺን ሃንኮቲ፥ «ናጋ፥ ኤሊያሲ ኢያ ኣሻናው ያኔኮ ኣኔ ቤዖስ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","ዬሱሲ ናምዓንꬆ ጊታ ዋሶ ዋሲዲ፥ ሃይቂ ኣጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","ሄ ሳቴን ፆሳ ኬꬃን ካቄቲዳ ማጋራጆይ ቆሞፌ ዱጌ ጋካናው ናምዑ ኬዪዲ፥ ፔꬌቲ ዎꬊስ። ቢታይ ቃፂስ፥ ዛላይካ ጳልቄቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ዱፎቲ ዶዬቲን ፆሳ ኣሳታፔ ዳሮቲ ሃይቆፔ ዴንዲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ኤንቲ ዱፎፔ ኬዪዲ፥ ዬሱሲ ሃይቆፔ ዴንዲዳይሳፌ ጉዬ ጌሻ ካታማ ቢዶሶና፤ ያን ኤንቲ ዳሮ ኣሳስ ቤንቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","ማቶ ሃላቃይኔ ኢያራ ዬሱሳ ናጊያ ዎታዳሬቲ ቢታይ ቃፂዳይሳኔ ሄሳን ሃኒዳባ ቤዒዳ ዎዴ ዳሮ ያዪዲ «ቱማ ሃይሲ ፆሳ ናዓ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","ሄሳን ዳሮ ማጫሳቲ፥ ጋሊላፔ ዶሚዲ ዬሱሳ ሃጋዚሼ ካሊዳይሳቲ ሃሆን ኤቂዲ ፄሎሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","ኤንታ ጊዶን ማግዴላ ማይራማ፥ ያይቆባኔ ዮሴፋ ኣያ ማይራማኔ ዛብዲዮሳ ማቺያ ዴዖሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","ሳዓይ ኦማርሲያ ዎዴ ዮሴፋ ጊያ ኢሲ ዱሬ ኡራይ፥ ኣርማቲያሳ ካታማፔ ዪስ። ኢ ባ ሁዔንካ ዬሱሳ ካሊያ ኣሲ። ");
INSERT INTO gofENT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","ዮሴፊ ጲላፆሳኮ ቢዲ፥ ዬሱሳ ኣሃ ኤካናው ዎሲስ። ጲላፆሲ ኣሃይ ዮሴፋስ ኢሜታና ሜላ ኪቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","ዬሱሳ ኣሃ ኤኪዲ፥ ጌሻ ሞጎ ኣፊላን ፃፂስ። ");
INSERT INTO gofENT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ባው ሞጌታናው ሹቻፌ ዎጪዳ ኦራꬃ ጎንጎሎን ኢያ ኣሃ ዎꬂስ። ቃሲ ሄ ጎንጎሉዋ ዶናን ጊታ ሹቻ ጎንዶርሲ ዎꬂዲ ኣጊ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","ማግዴላ ማይራማኔ ሃንኮ ማይራማ ሄ ጎንጎሉዋኮ ሲሚዲ ኡቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","ዎንቴꬄ ሳምባታ ጋላስ፥ ካሂኔ ሃላቃቲኔ ፋሪሳዌቲ ጲላፆሳኮ ዪዲ፥ ሃይሳዳ ያጊዶሶና፡ ");
INSERT INTO gofENT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","«ጎዳው፥ ሃ ዎርዳንቾይ ፓፃ ዴዒሼ፥ ‹ታኒ ሄꬑ ጋላሳፔ ጉዬ ሃይቆፔ ዴንዳና› ያጊዳይሲ ኑስ ሃሳዬቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","ሄሳ ጊሾ፥ ኢ ሞጌቲዳ ጎንጎሉዋ ሄꬑ ጋላስ ጋካናው፥ ሚንꬂ ናጋና ሜላ ኪታርኪ። ሄሲ ሃኖና ኢፂኮ፥ ኢያ ታማሬቲ ቢዲ ኢያ ኣሃ ካይሲ ꬋይሲዲ፥ ‹ሃይቆፔ ዴንዲስ› ያጊዲ ኣሳስ ኦዲኮ ናምዓንꬆ ባሌሶይ ኮይሮይሳፌ ኡባ ሃ ኢታና» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","ጲላፆሲ ኤንታኮ፥ «ሂንቴው ናጌይሳቲ ዴዖሶና፤ ቢዲ ሂንቴው ዳንዳዔቲዳ ሜላ ናጊሲቴ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","ሄሳ ጊሾ፥ ኤንቲ ቢዲ ዱፎይ ቦሼቶና ሜላ ሹቻ ቦላ ማታሜ ዎꬂዲ ዎታዳሬታን ናጊሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","ሳምባቲ ኣꬊን ዎጋ ዎዴ ዎንታ ጉራ፥ ማግዴላ ማይራማኔ ሃንኮ ማይራማ ዬሱሲ ሞጌቲዳ ጎንጎሉዋ ቤዓናው ቢዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","ቆፖና ዎልቃማ ቢታ ቃፆይ ሃኒስ። ጎዳ ኪታንቾይ ሳሎፔ ዎꬊዲ ዱፉዋ ዶናን ዴዒያ ሹቻ ጎንዶርሲዲ ኢያ ቦላ ኡቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","ኢያ ማላይ ዎልዓንꬂ ዳኔስ። ኢያ ማዖይካ ሻቻዳ ቦꬂ። ");
INSERT INTO gofENT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","ናጌይሳቲ ኪታንቹዋ ቤዒዲ፥ ያሻን ኮኮሪዲ፥ ሃይቂዳ ኣሳዳ ሃኒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","ኪታንቾይ ማጫሳታኮ፥ «ሂንቴ ማስቃሊያ ቦላ ካቄቲዳ ዬሱሳ ኮዬይሳ ታኒ ኤሪያ ጊሾ ያዮፊቴ። ");
INSERT INTO gofENT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","ኢ ካሴ ኦዲዳይሳ ሜላ ሃይቆፔ ዴንዲስ፤ ሃይሳን ዴና። ሃ ዪዲ ኢያ ዚንዒሲዳ ቤሳ ቤዒቴ። ");
INSERT INTO gofENT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","ሂንቴ ሃዒ ኤሌሲ ቢዲ፥ ኢያ ታማሬታስ፥ ‹ዬሱሲ ሃይቆፔ ዴንዲስ። ቃሲ ኢ ሂንቴፌ ሲንꬃቲዲ ጋሊላ ባና፤ ሂንቴ ኢያ ያን ቤዓና› ያጊዲ ኦዲቴ። ታኒ ሂንቴው ሃይሳ ኦዳናው ያስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","ኤንቲ ያዪሼኔ ዳሮ ኡፋይቲሼ፥ ዱፉዋ ማታፔ ኤሌሲዲ ቢዲ፥ ኢያ ታማሬታስ ኦዳናው ዎፂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","ቆፖና ዬሱሲ ኤንታራ ጋሄቲዲ ኤንታኮ፥ «ሳሮይ ሂንቴው ጊዶ» ያጊስ። ኤንቲ ኢያኮ ሺቂዲ፥ ኢያ ቶሁዋ ኦይኪዲ ኢያው ጎይኒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","ሄ ዎዴ ዬሱሲ ኤንታኮ፥ «ያዮፊቴ፤ ቢዲ ታ ታማሬቲ ጋሊላ ባና ሜላ ኤንታው ኦዲቴ። ኤንቲ ያን ታና ቤዓና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","ሄ ማጫሳቲ ቢሺን፥ ዱፉዋ ናጊያ ዎታዳሬታፔ ባጋቲ ካታማ ቢዲ፥ ሃኒዳባ ኡባ ካሂኔ ሃላቃታስ ኦዲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","ካሂኔ ሃላቃቲኔ ጪማቲ ሺቂዲ ዞሬቲዲ፥ ዎታዳሬታስ ዳሮ ሚሼ ኢሚዲ፥ ");
INSERT INTO gofENT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","« ‹ኑኒ ꬊስኪዳሺን ኢያ ታማሬቲ ቃማ ዪዲ፥ ኢያ ኣሃ ካይሲዶሶና› ያጊቴ። ");
INSERT INTO gofENT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","ሃ ኦዳ ዴሪያ ሃሬይሲ ሲዒኮ፥ ሄሲ ሂንቴ ባላ ጊዶናይሳ ኑኒ ኢያ ኦዲ ኣማንꬃና። ሂንቴና ኣይቢካ ሂርጊሶፖ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","ዎታዳሬቲ ሚሺያ ኤኪዲ፥ ኪቴቲዳይሳዳ ኦꬂዶሶና። ሃ ኦዳይ ኣይሁዴ ማታን ሃቺ ጋካናው ኦዴቲሼ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","ታማኔ ኢሲ ኢያ ታማሬቲ ዬሱሲ ባንታና ቢቴ ጊዳ ጋሊላ ዴሪያ ቦላ ቢዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","ያን ኤንቲ ኢያ ቤዒዳ ዎዴ ኢያው ጎይኒዶሶና፥ ሺን ኤንታፌ ኢሶቲ ኢሶቲ ሲꬊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","ዬሱሲ ኤንታኮ ሺቂዲ፥ «ሳሎኒኔ ሳዓን ማቲ ኡባይ ታው ኢሜቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","ሂዛ፥ ሂንቴ ኡባ ቤሲ ቢዲ፥ ኣዋ፥ ናዓ፥ ጌሻ ኣያና ሱንꬃን ኣሴ ኡባ ፃማቂዲ ታና ካሌይሳታ ኦꬂቴ። ");
INSERT INTO gofENT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ታኒ ሂንቴና ኪቲዳባ ኡባ ኤንቲ ናጋና ሜላ ኤንታ ታማርሲቴ። ታኒ ዎዲያ ዉርሴꬃ ጋካናው ኡባ ዎዴ ሂንቴራ ዴዓይስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","ሃይሲ ፆሳ ናዓ ዬሱስ ኪሪስቶሳ ዎንጌላ ዶሜꬃ። ");
INSERT INTO gofENT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","ናቢያ ኢሳያሲ ፃፊዳ ማፃፋን ፆሳይ፥ «ሄኮ፥ ታኒ ታ ኪታንቹዋ ኔፔ ሲንꬄ ዬዳና። ኢ ኔ ኦጊያ ጊጊሳና። ");
INSERT INTO gofENT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","ኢሶይ ባዞ ጊዶን ባ ቃላ ꬎቁ ኦꬂዲ፥ ‹ጎዳ ኦጊያ ጊጊሲቴ፤ ኢ ሃሙታና ሆሮጋ ኢያው ሱሪሲቴ ጊስ› » ያጌስ። ");
INSERT INTO gofENT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","ፃማቂያ ዮሃኒሲ ኣሳ ፃማቂሼ፥ «ሂንቴ ናጋራፔ ሲሚዲ ፃማቄቲቴ፤ ፆሳይ ሂንቴ ናጋራ ኣቶ ጋና» ያጊዲ ቃላ ኦዲሼ ባዞ ቢታፌ ዪስ። ");
INSERT INTO gofENT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","ዪሁዳ ቢታን ዴዒያ ኣሳይ ኡባይኔ ዬሩሳላሜ ካታማ ኣሳ ኡባይ ዮሃኒሳኮ ዮሶና። ባንታ ናጋራ ፓፂን፥ ዮሃኒሲ ኤንታ ዮርዳኖሴ ሻፋን ፃማቄስ። ");
INSERT INTO gofENT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","ዮሃኒሲ ጊማሌ ኢኪሴፔ ዳዴቲዳ ኣፊላ ማዔስ። ባ ፄሳን ዳፎ ዳንጬስ፤ ቃሲ ቦሌኔ ዴጌራ ኤሲ ሜስ። ");
INSERT INTO gofENT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","ዮሃኒሲ ቃላ ኦዲሼ፥ «ታፔ ጉዬራ ዳሮ ሚኔይሲ ዬስ። ሃሪ ኣቶሺን፥ ታኒ ኢያ ጫማ ዎዶሩዋ ሆካዳ ቢላናው ቤሲኬ። ");
INSERT INTO gofENT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","ታኒ ሂንቴና ሃꬃን ፃማቃይስ፥ ሺን ኢ ሂንቴና ጌሻ ኣያናን ፃማቃና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","ዬሱሲ ሄ ዎዴ ጋሊላ ቢታን ዴዒያ ናዚሬቴ ካታማፔ ዪን፥ ዮሃኒሲ ዮርዳኖሴ ሻፋን ኢያ ፃማቂስ። ");
INSERT INTO gofENT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","ዬሱሲ ሃꬃፌ ኬያ ዎዴ ሳሎይ ዶዬቲን፥ ጌሻ ኣያናይ ባ ቦላ ሆሌዳ ዎꬊሺን ቤዒስ። ");
INSERT INTO gofENT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","ቃሲ ሳሎፔ፥ «ታኒ ዶሲያ ታ ናዓይ ኔና፤ ታ ኔናን ኡፋይታይስ» ያጊያ ቃላይ ዪስ። ");
INSERT INTO gofENT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","ኢራ ጌሻ ኣያናይ ዬሱሳ ባዞ ቢታ ኤፊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ዬሱሲ ባዞ ቢታን ፃላሄን ፓጬቲሼ ኦይታሙ ጋላስ ጋምዒስ። ዶዓታራ ዴዒስ፥ ሺን ኪታንቾቲ ዪዲ ኢያ ማዲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","ዮሃኒሲ ቃሼቲዳፔ ጉዬ ዬሱሲ ፆሳ ካዎቴꬃ ዎንጌላ ኦዲሼ ጋሊላ ቢታ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","ያን፥ «ዎዴይ ጋኪስ፤ ፆሳ ካዎቴꬃይ ማታቲስ። ሂንቴ ናጋራፔ ሲሚዲ፥ ዎንጌላን ኣማኒቴ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","ዬሱሲ ጋሊላ ኣባ ማታራ ኣꬊሼ፥ ሞሎ ኦይኪያ፥ ሲሞናኔ ኢያ ኢሻ ኢንዲሪያሳ፥ ባንታ ጊቲያ ኣባን ዬጌይሳታ ቤዒስ። ");
INSERT INTO gofENT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","ኤንታኮ፥ «ታና ካሊቴ፤ ታኒ ሂንቴና ኣሴ ኦይꬁ ታማርሳና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","ኤንቲ ሶሁዋራ ባንታ ጊቲያ ዬጊ ኣጊዲ ዬሱሳ ካሊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","ዬሱሲ ጉꬂ ሲንꬄ ቢዲ፥ ናምዑ ኢሻታ ዛብዲዮሳ ናይታ፥ ያይቆባኔ ዮሃኒሳ ዎጎሉዋ ጊዶን ባንታ ጊቲያ ጊጊሴይሳታ ቤዒስ። ");
INSERT INTO gofENT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","ኢ ኤንታ ቤዒዳ ሜላ ፄጊስ። ኤንቲ ባንታ ኣዋ ዛብዲዮሳ፥ ኢያ ኦሳንቾታራ ዎጎሉዋ ጊዶን ዬጊ ኣጊዲ ዬሱሳ ካሊዲ ቢዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","ኤንቲ ቂፊርናሆሜ ካታማ ጌሊዶሶና። ሳምባቲ ጌሊዳ ሜላ ዬሱሲ ኤሌሲዲ ኣይሁዴ ዎሳ ኬꬂ ጌሊዲ ታማርሶ ኦይኪስ። ");
INSERT INTO gofENT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","ማታራ ዴዒያ ኣሳዳ ታማርሴሲፔ ኣቲን ሂጌ ኣስታማሬታꬆ ታማርሶና ጊሾ ኣሳይ ኢያ ቲሚርቲያን ማላሌቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","ሄ ዎዴ ቱና ኣያናይ ኦይኪዳ ኢሲ ኡራይ ኣይሁዴ ዎሳ ኬꬂ ጌሊዲ ባ ቃላ ꬎቁ ኦꬂዲ፥ ");
INSERT INTO gofENT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","«ናዚሬቴ ዬሱሳ፥ ኔኒ ኑፔ ኣይ ኮያይ? ኑና ꬋይሳናው ያዲ? ኔኒ ኦኔኮ ታ ኤራይስ፤ ኔኒ ፆሳ ጌሻ ጊዲኪ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","ዬሱሲ ሄ ቱና ኣያና፥ «ሃይዛ፥ ሃ ኣዲያፌ ኬያ» ጊዲ ኪቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","ቱና ኣያናይ ኡራ ዳፌሬꬂዲ፥ ዋሲዲ ኢያፔ ኬዪስ። ");
INSERT INTO gofENT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","ኣሳይ ኡባይ ማላሌቲዲ፥ «ሃይሲ ኣይቤ? ሃ ኡራይ ባ ማታን ሃሪ ኣቶሺን ቱና ኣያናታካ ኪቴስ። ኤንቲ ኢያው ኪቴቶሶና፤ ሃይሲ ኣይቢ ኦራꬃ ቲሚርቴ?» ጊዲ፥ ባንታ ጊዶን ኢሶይ ኢሱዋ ኦይቺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","ዬሱሳ ሱንꬃይ ኤሌሲዲ ጋሊላ ቢታን ዴዒያ ሄራ ኡባን ኬዪስ። ");
INSERT INTO gofENT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","ዬሱሲ ኣይሁዴ ዎሳ ኬꬃፌ ኬዪዲ፥ ያይቆባራኔ ዮሃኒሳራ ሲሞና ሶኔ ኢንዲሪያሳ ሶ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","ሲሞና ማቼ ኣያ ቆፆ ሚሻ ሃርጋዳ ዚንዒዳሮ ዬሱሲ ያ ጋኪያ ዎዴ ኢያው ኦዲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","ኢ ኢኮ ሺቂዲ፥ ኢ ኩሺያ ኦይኪዲ፥ ኢዮ ዴንꬂ ኤሲስ። ቆፆይኔ ሚሻይ ኣጊን ኢያ ኤንታ ሞካሱ። ");
INSERT INTO gofENT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","ሃርጊዳ ኣሳ ኡባኔ ቱና ኣያናቲ ኦይኪዳ ኣሳ ኡባ ኦማርሲ ኣዋይ ዉሊዳፔ ጉዬ ኢያኮ ኤሂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","ካታማን ዴዒያ ኣሳ ኡባይ ሄ ኬꬃ ካሬ ሺቂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","ዬሱሲ ዱማ ዱማ ሃርጌን ኦይኬቲዳ ዳሮ ኣሳ ፓꬂዲ፥ ዳሮ ቱና ኣያናታ ኬሲስ። ኢ ኦኔኮ ቱና ኣያናቲ ኤሪዳ ጊሾ ኤንታ ኦዲሶና ዲጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","ዬሱሲ ዎንታ ጉራ ዴንዲዲ፥ ኣሲ ባይና ቤሲ ቢዲ፥ ያን ፆሳ ዎሲስ። ");
INSERT INTO gofENT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","ሲሞኒኔ ኢያራ ዴዔይሳቲ ኢያ ኮዪሼ ቢዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ኤንቲ ኢያ ዴሚዲ፥ «ኣሳይ ኡባይ ኔና ኮዬስ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","ዬሱሲ ቃሲ ኤንታ፥ «ሄ ሄራን ዴዒያ ሃራ ካታማታ ዬꬊቴ። ታኒ ዪዳይ ዎንጌላ ኦዳናው ጊዲያ ጊሾ ያንካ ቃላ ኦዳናው ቤሴስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","ኣይሁዴ ዎሳ ኬꬃታን ቃላ ኦዲሼኔ ቱና ኣያናታ ኬሲሼ፥ ጋሊላ ቢታ ኡባን ዩዪስ። ");
INSERT INTO gofENT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","ባሮይ ኦይኪዳ ኢሲ ኡራይ ዬሱሳኮ ዪዲ፥ ኢያ ሲንꬃን ጉልባቲዲ፥ «ኔኒ ኮይኮ ታና ጌሻናው ዳንዳዓሳ» ያጊዲ ዎሲስ። ");
INSERT INTO gofENT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","ዬሱሲ ኢያው ቃꬌቲዲ፥ ባ ኩሺያ ዬዲዲ ኢያ ቦቺዲ፥ «ታኒ ኮያይስ፥ ጌያ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","ሶሁዋራ ባሮይ ኡራ ዬዲን ኡራይ ፓፂስ። ");
INSERT INTO gofENT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","ዬሱሲ ኡራ ሚንꬂ ናጊሲዲ ኬሲ ዬዲስ። ");
INSERT INTO gofENT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","ዬሱሲ ኢያ፥ «ኔና ኤራ፥ ሃይሳ ኦዴስካ ኦዶፓ። ሺን ባዳ ኔ ኣሳቴꬃ ካሂኔ ቤሳ። ኔኒ ሃዒ ጌሺ ጊዲዳይሳ ኣሳ ኤሪሳናው፥ ሙሴይ ኪቲዳ ያርሹዋ ያርሻ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","ሺን ኡራይ ቢዲ፥ ጉታ ኡባን ኣሳ ኡባስ ኦዲስ። ሄሳ ጊሾ፥ ዬሱሲ ቆንጬ ኬዪዲ፥ ካታማ ጌላናው ዳንዳዒቤና። ሺን ኣሲ ባይናሶን ጋፃን ዴዒስ፤ ቃሲ ኣሳይ ኡባ ቤሳፌ ኢያኮ ዮሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","ጉꬃ ጋላሳፔ ጉዬ ዬሱሲ ቂፊርናሆሜ ሲሚዲ፥ ሶን ዴዔስ ጊያ ኦዳይ ሲዔቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","ኣሳ ኬꬃይ ኤኮና ኢፂን፥ ሃሪ ኣቶሺን ካሬይካ ፁማና ጋካናው ዳሮ ኣሳይ ሺቂን፥ ዬሱሲ ቃላ ታማርሲስ። ");
INSERT INTO gofENT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","ኦይዱ ኣሳቲ ኢሲ ጉንዳ ኡራ ቶኪዲ ኢያኮ ኤሂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","ኣሳይ ዳሪዳ ጊሾ ኡራ ዬሱሳኮ ሺሻናው ኤንታው ዳንዳዔቶና ኢፂን፥ ዬሱሲ ዴዒያ ጊናራ ኬꬃ ቃሪዲ፥ ካራ ቃዉፂዲ ኡራ ኢ ዚንዒዳ ኣልጋራ ዱጌ ዬዲዲ ዬሱሳ ሲንꬃን ዎꬊሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","ዬሱሲ ኤንታ ኣማኑዋ ቤዒዲ፥ ሄ ጉንዳ ኡራ፥ «ታ ናዓው፥ ኔ ናጋራይ ኣቶ ጌቴቲስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","ሂጌ ኣስታማሬታፔ ሄ ቤሳን ኡቲዳ ኢሶቲ ኢሶቲ ባንታ ዎዛናን፥ ");
INSERT INTO gofENT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«ላ ሃ ኡራይ ሃይሳ ሜላ ኢታባ ፆሳ ቦላ ኣይስ ኦዴቲ? ፆሳ ፃላላፔ ኣቲን ሃሪ ኦኒ ናጋራ ኣቶ ጋናው ዳንዳዒ?» ጊዲ ቆፒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","ኤንቲ ባንታ ዎዛናን ሄሳዳ ቆፒዳይሳ ዬሱሲ ሶሁዋራ ባ ኣያናን ኤሪዲ፥ ኤንታኮ፥ «ሂንቴ ሂንቴ ዎዛናን ኣይስ ሄሳዳ ቆፔቲ? ");
INSERT INTO gofENT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","ጉንዳ ኡራ፥ ‹ኔ ናጋራይ ኣቶ ጌቴቲስ› ጌይሲ ማቴዬ? ዎይኮ፥ ‹ዴንዳ ኤቃዳ ኔ ኣልጋ ቶካዳ ባ› ጌይሲ ማቴ? ");
INSERT INTO gofENT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","ሺን ታው፥ ኣሳ ናዓስ፥ ሳዓ ቦላ ናጋራ ኣቶ ጋናው ማቲ ዴዔይሳ ሂንቴ ኤራና ሜላ» ጊዲ ሄ ጉንዳ ኡራኮ፥ ");
INSERT INTO gofENT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","«ኔና ጋይስ፥ ዴንዳ ኤቃዳ ኔ ኣልጋ ቶካዳ ኔ ሶ ባ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","ኡራይ ኤሌሲ ዴንዲ ኤቂዲ፥ ባ ኣልጋ ቶኪዲ ኣሳ ኡባይ ቤዒሺን ቢስ። ኣሳይ ኡባይ ማላሌቲዲ፥ «ኑኒ ሃይሳ ሜላ ማላሊሲያባ ቤዒ ኤሮኮ» ያጊዲ ፆሳ ጋላቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","ዬሱሲ ቃሲ ጋሊላ ኣባ ዶና ሲሚ ቢዲ፥ ባኮ ዪዳ ኣሳ ኡባ ታማርሲስ። ");
INSERT INTO gofENT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","ያራ ኣꬊሼ፥ ኢልፊዮሳ ናዓ ሌዌ ጌቴቴይሲ ቃራፃ ቃንፂሲያ ቤሳን ኡቲዳይሳ ቤዒዲ፥ «ታና ካላ» ያጊስ። ሌዌይ ዴንዲ ኤቂዲ ኢያ ካሊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","ዬሱሲ ካꬂ ማናው ሌዌ ሶን ኡቲስ። ኢያ ካሊያ ኣሳይ ዳሮ ጊዲያ ጊሾ ቃራፃ ቃንፂሲያ ዳሮ ኣሳይኔ ናጋራንቾቲ ኢያራኔ ኢያ ታማሬታራ ኢሲፌ ኡቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","ሂጌ ኣስታማሬ ጊዲዳ ኢሲ ኢሲ ፋሪሳዌቲ ዬሱሲ ናጋራንቾታራኔ ቃራፃ ቃንፂሴይሳታራ ካꬂ ሚሺን ቤዒዲ፥ «ኢ ኣይስ ናጋራንቾታራኔ ቃራፃ ቃንፂሴይሳታራ ካꬂ ሚ?» ያጊዲ፥ ኢያ ታማሬታ ኦይቺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","ዬሱሲ ኤንቲ ጌይሳ ሲዒዲ፥ «ሃርጋንቾታፔ ኣቲን ፓፃታስ ኣኪሜ ኮሼና። ታኒ ናጋራንቾታ ፄጋናው ያሲፔ ኣቲን ፂሎታ ፄጋናው ያቢኬ» ያጊዲ ኤንታው ዛሪስ። ");
INSERT INTO gofENT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","ፃማቂያ ዮሃኒሳ ታማሬቲኔ ፋሪሳዌቲ ፆሞሶና። ኢሲ ኢሲ ኣሳቲ ዬሱሳኮ ዪዲ፥ «ዮሃኒሳ ታማሬቲኔ ፋሪሳዌታ ታማሬቲ ፆሞሶና፥ ሺን ኔ ታማሬቲ ኣይስ ፆሞኮና?» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","ዬሱሲ ኤንታኮ፥ «ያጋኑዋ ዪዳ ኣሳቲ ማቺው ኤኬይሲ ኤንታራ ዴዒሺን፥ ፆማናው ዳንዳዖና? ማቺው ኤኬይሲ ኤንታራ ዴዒሺን፥ ፆማናው ዳንዳዖኮና። ");
INSERT INTO gofENT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","ሺን ማቺው ኤኬይሲ ኤንታ ማታፔ ኤኬታና ዎዴይ ያና፥ ኤንቲ ሄ ዎዴ ፆማና። ");
INSERT INTO gofENT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","«ጬጋ ማዖ ቦላ ኦራꬃ ዎꬂዲ ሲኪያ ኣሲ ባዋ። ዎꬂዲ ሲኪኮ፥ ኦራꬃይ ጬጋ ማዑዋ ዳኬስ፤ ዳኬꬃይካ ካሴይሳፌ ዳሬስ። ");
INSERT INTO gofENT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","ቃሲ ማልዓንቶ ዎይኔ ጬጋ ኦጎሮን ቆሊያ ኣሲ ባዋ። ሺን ቆሊኮ፥ ሄ ዎይኔይ ኦጎሩዋ ዳኬስ፥ ባዉካ ጉኬስ፥ ኦጎሮይካ ኢቴስ። ሺን ማልዓንቶ ዎይኔይ ኦራꬃ ኦጎሮን ቆሌቴስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","ዬሱሲ ኢሲ ሳምባታ ጋላስ ባንጋ ጋዴ ጊዶራ ኣꬊሺን፥ ኢያ ታማሬቲ ኢያራ ቢሼ ባንጋ ቲያ ሺርኪዲ ሞሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","ፋሪሳዌቲ ዬሱሳኮ፥ «ሄኮ፥ ኔ ታማሬቲ ሳምባታ ጋላስ ዎጋ ጊዶናባ ኣይስ ኦꬆና?» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","ዬሱሲ ኤንታኮ፥ «ዳዊቴይ ኮሻቲዲ፥ ሚያባ ኮዪዳ ዎዴ ባራ ዴዔይሳታራ ኦꬂዳይሳ ናባቢቤኬቲ? ");
INSERT INTO gofENT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","ኣቢያታሪ ካሂኔ ሃላቃ ጊዲዲ ዴዒያ ዎዴ ዳዊቴይ ፆሳ ኬꬂ ጌሊዲ፥ ካሂኔታ ፃላሊ ማናፔ ኣቲን ኦኒካ ማናው ዎጋ ጊዶናይሳ ጎዳ ሲንꬃን ዎꬂዳ ዳቡዋ ሚስ፥ ባራ ዴዔይስታስካ ኢሚስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","ቃሲካ ዬሱሲ ኤንታኮ፥ «ሳምባቲ ኣሳ ናዓ ጎዓስ ሜꬌቲሲፔ ኣቲን ኣሲ ሳምባታስ ሜꬌቲቤና። ");
INSERT INTO gofENT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","ሄሳ ጊሾ፥ ኣሳ ናዓይ፥ ሃሪ ኣቶሺን ሳምባታስካ ጎዳ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","ዬሱሲ ኣይሁዴ ዎሳ ኬꬂ ሲሚ ጌሊስ። ያን ኩሼይ ጉንዲዳ ኢሲ ኡራይ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","ኢሲ ኢሲ ኣሳይ ዬሱሳ ሞታናው ኮዪዲ፥ ኩሼይ ጉንዲዳ ኡራ ሳምባታ ጋላስ ኢ ፓꬂኮኔ ኣጊኮ ቤዓናው ኮዪዲ ሚንꬂዲ ናጎሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","ዬሱሲ ኩሼይ ጉንዲዳ ኡራ፥ «ዴንዳ ኤቃዳ ሃ ሲንꬄ ያ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","ሄሳፌ ጉዬ፥ ኣሳኮ፥ «ሳምባታ ጋላስ ሎዖባ ኦꬄይሲ ዎጌዬ ኢታባ ኦꬄይሲ ዎጌ? ኣሳ ሼምፖ ኣሾዬ ዎይኮ ዎꬎ?» ያጊዲ ኦይቺስ። ሺን ኣሳይ ሲዒ ጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","ዬሱሲ ሃንቄቲዲ፥ ኤንታ ዩሺ ኣꬂ ፄሊዲ፥ ኤንቲ ኦዲን ሲዖናይሳታ ጊዲያ ጊሾ ኤንታ ቦላ ዳሮ ኣዛኒስ። ሄ ኣዲያኮ፥ «ኔ ኩሺያ ፒዲ ኦꬃ» ያጊስ። ኡራይ ፒዲ ኦꬂን ኢያ ኩሼይ ፓፂስ። ");
INSERT INTO gofENT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","ኤሌሲዲ ፋሪሳዌቲ ኣይሁዴ ዎሳ ኬꬃፌ ካሬ ኬዪዲ፥ ዬሱሳ ዋቲ ዎꬋኔኮ ማቄታናው ሄሮዲሳ ባጋታራ ኢሲ ሶ ሺቂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","ዬሱሲ ባ ታማሬታራ ጋሊላ ኣባኮ ቢስ። ጋሊላፔኔ ዪሁዳፔ ዪዳ ዳሮ ኣሳይ ኢያ ካሊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ቃሲካ ዬሩሳላሜፔ፥ ኢዱሚያሳፔ፥ ዮርዳኖሴ ሻፋ ፒንꬃፌ፥ ፂሮሳ ካታማፔኔ ሲዶና ካታማፔ ዬሱሲ ኦꬂዳባ ሲዒዲ፥ ዳሮ ኣሳይ ኢያኮ ዪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","ኣሳ ዳሮቴꬃፌ ዴንዶይሳን ኢያ ኡንዔꬆና ሜላ ኢያ ታማሬቲ ዎጎሎ ኢያው ጊጊሳና ሜላ ኪቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","ዳሮ ኣሳ ኢ ፓꬂዳ ጊሾ ሃርጊያ ኣሳ ኡባይ ኢያ ቦቻናው ሱጌቶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","ቱና ኣያናይ ኦይኪዳ ኣሳቲ ኢያ ቤዒዳ ዎዴ ኢያ ሲንꬃን ኩንዲዲ፥ ባንታ ቃላ ꬎቁ ኦꬂዲ፥ «ኔኒ ፆሳ ናዓ ጊዲኪ?» ያጎሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","ዬሱሲ ሄ ቱና ኣያናቲ ባናቴꬃ ኦዴስካ ቆንጪሶና ሜላ ኤንታ ሚንꬂዲ ሃንቄቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","ዬሱሲ ዴሪያ ቦላ ኬዪዲ፥ ባ ኮዪዳ ኣሳታ ባኮ ፄጊስ፤ ኤንቲካ ኢያኮ ቢዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","ኤንቲ ባራ ዳና ሜላኔ ቃላ ታማርሳና ሜላ ታማኔ ናምዓታ ዶሪዲ፥ ኤንታ፥ «ሃዋሬታ» ጊዲ ሱንꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ቱና ኣያናታካ ኬሳና ሜላ ኤንታው ማታ ኢሚስ። ");
INSERT INTO gofENT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","ኢ ዶሪዳ ታማኔ ናምዓቲ ሃይሳታ፡ ጴፂሮሳ ያጊዲ ሱንꬂዳ ሲሞና፥ ");
INSERT INTO gofENT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ቦዓኔርጌስ (ዳዳ ዳኒያ ኣሳታ) ያጊዲ ሱንꬂዳይሳታ፥ ዛብዲዮሳ ናይታ ያይቆባኔ ያይቆባ ኢሻ ዮሃኒሳ፥ ");
INSERT INTO gofENT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","ኢንዲሪያሳ፥ ፊልጶሳ፥ ባርቶሎሚዮሳ፥ ማቶሳ፥ ቶማሳ፥ ኢልፊዮሳ ናዓ ያይቆባ፥ ታዲዮሳ፥ ባ ቢታስ ሚሼቲያ ሲሞናኔ፥ ");
INSERT INTO gofENT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ዬሱሳ ኣꬂ ኢሚዳ ኣስቆሮታ ዪሁዳ። ");
INSERT INTO gofENT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","ሄሳፌ ጉዬ፥ ዬሱሲ ሶ ቢስ። ቃሲ ዳሮ ኣሳይ ሺቂን፥ ኢኔ ኢያ ታማሬቲ ሃሪ ኣቶሺን ካꬂ ማናዉካ ዳንዳዒቦኮና። ");
INSERT INTO gofENT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","ኣሳይ ኢያ፥ «ጎዬስ» ጊያ ጊሾ ኢያ ዳቦቲ ሄሳ ሲዒዲ ኢያ ኤካናው ቢዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","ሂጌ ኣስታማሬታፔ ኢሶቲ ኢሶቲ ዬሩሳላሜፔ ዪዲ፥ «ኢያ ቦላ ቢዔልዜቡሊ ዴዔስ»፥ ኢ፥ «ፃላሄይ ዎልቃን ቱና ኣያናታ ኬሴስ» ያጊዲ ኦዴቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","ዬሱሲ ኣሳ ባኮ ፄጊዲ ሌሚሶ ኦዲስ። «ፃላሄይ ፃላሄ ዋቲ ኬሳናው ዳንዳዒ? ");
INSERT INTO gofENT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","ኢሲ ካዎቴꬃይ ባ ጊዶን ሻኬቲኮ ሄ ካዎቴꬃይ ኤቃናው ዳንዳዔና። ");
INSERT INTO gofENT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","ሄሳዳካ፥ ኢሲ ኬꬃ ኣሳይ ባንታ ጊዶን ሻኬቲኮ ꬋያናፔ ኣቲን ዳናው ዳንዳዖኮና። ");
INSERT INTO gofENT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","ሂዛ፥ ፃላሄይ ባራ ካጬቲዲ ሻኬቲኮ ꬋዮፔ ኣቲን ዳናው ዳንዳዔና። ");
INSERT INTO gofENT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","«ሺን ኮይሮቲዲ ዎልቃማ ኡራ ቃቾና ዴዒሼ ኢያ ኬꬃ ጌሊዲ፥ ኢያ ሚሺያ ቦንቃናው ዳንዳዒያ ኣሲ ባዋ። ቃቺ ሲሚዲ ኢያ ኬꬃ ቦንቃናው ዳንዳዔስ። ");
INSERT INTO gofENT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","«ታኒ ሂንቴው ቱማ ኦዳይስ፤ ፆሳይ ኣሳ ናይታስ ናጋራ ኡባኔ ኤንቲ ጫያ ጫሼ ኡባ ኣቶ ጋና። ");
INSERT INTO gofENT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","ሺን ጌሻ ኣያና ቦላ ኢታባ ኦዴቲያ ኦዴስካ ሜሪና ናጋራ ጊዳናፔ ኣቲን ፆሳይ ኡባራካ ኢያ ማሬና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","ዬሱሲ ሄሳ ጊዳይ፥ ኢሲ ኢሲ ኣሳቲ፥ «ኢያ ቦላ ቱና ኣያናይ ዴዔስ» ያጊዳ ጊሾሳ። ");
INSERT INTO gofENT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","ኢያ ኣያኔ ኢያ ኢሻቲ ዪዲ ካሬን ኤቂዲ፥ ኢያኮ ኣሴ ኪቲዲ ኢያ ፄጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","ኢያ ማታን ኡቲዳ ዳሮ ኣሳቲ፥ «ሄኮ፥ ኔ ኣዬራኔ ኔ ኢሻታራ ካሬን ኤቂዲ ኔና ኮዮሶና» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","ዬሱሲ ዛሪዲ፥ «ታ ኣያ ኦኔ? ቃሲ ታ ኢሻቲ ኦናንቴ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","ባ ማታን ኡቲዳ ኣሳ ዩሺ ኣꬂ ፄሊዲ፥ «ሄኮ፥ ታ ኣያኣኔ ታ ኢሻቲ ሃይሳታ። ");
INSERT INTO gofENT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","ፆሳይ ሼኒያ ኦꬂያ ኡባይ ታ ኢሻ፥ ታ ሚቾኔ ታ ኣዮ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","ዬሱሲ ዛሪዲ ጋሊላ ኣባ ማታን ታማርሴስ። ዳሮ ኣሳይ ኢያ ዩሹዋን ሺቂን፥ ኣባን ዴዒያ ዎጎሉዋ ጊዶ ጌሊዲ ኡቲስ፥ ኣሳ ኡባይ ኣባ ማታን ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","ኢ ኤንታ ዳሮባ ሌሚሶን ታማርሲስ። ታማርሲሼ ሃይሳዳ ያጊስ፡ ");
INSERT INTO gofENT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«ሲዒቴ! ኢሲ ኡራይ ዜሬꬂ ዜራናው ኬዪስ። ");
INSERT INTO gofENT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","ኢ ዜሪሺን፥ ኢሲ ኢሲ ዜሬꬃይ ኦጌ ጋፃን ዎꬊስ፤ ካፎቲ ዪዲ ሚዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","ኢሲ ኢሲ ዜሬꬃይ ጋርሳን ሻሎይ ዴዒያ ቢታ ቦላ ዎꬊስ። ዳሮ ቢቲ ባይና ጊሾ ሄ ዜሬꬃይ ኤሌሲዲ ዶሊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","ሺን ኣዊ ኬዪዳ ዎዴ ሹሊስ። ሎይꬂዲ ፃጶ ዬዲቦና ጊሾ ኤሌሲ ሜሊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","ኢሲ ኢሲ ዜሬꬃይ ኣጉንꬃ ጊዶን ዎꬊስ። ዶሊዳይሳ ኣጉንꬃይ ዲጪዲ ጩሊዳ ጊሾ ኣይፌ ኣይፎና ኣቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","ኢሲ ኢሲ ዜሬꬃይ ኣራዳ ቢታን ዎꬊዲ ዶሊስ። ዲጪዲ ኢሶይ ሃስታማ፥ ኢሶይ ኡሱፑን ታማ ኢሶይ ፄታ ኣይፊስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","«ሲዒያ ሃይꬂ ዴዒያ ኦኒካ ሲዖ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","ዬሱሲ ኦዲዳይሳ ሲዒዳ ኢሲ ኢሲ ኣሳቲኔ ታማኔ ናምዑ ታማሬቲ ዬሱሲ ባርካ ዴዒሺን፥ ኢያኮ ሺቂዲ ሄ ሌሚሱዋ ቢርሼꬃ ኦይቺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","ዬሱሲ ኤንታኮ ሃይሳዳ ያጊስ፡ «ሂንቴው ፆሳ ካዎቴꬃ ፁራ ኤሮይ ኢሜቲስ። ሺን ሃራታስ ካዎቴꬃፌ ካሬን ዴዔይሳታስ ኡባባይ ሌሚሶን ኦዴቴስ። ");
INSERT INTO gofENT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ጋሶይካ፥ ‹ኤንቲ ፄሎሶና፥ ሺን ዴሞኮና። ሲዖሶና፥ ሺን ኣኬኮኮና። ኤንቲ ዴሚያኮኔ ኣኬኪያኮ፥ ፆሳኮ ሲማና ኢካ ኤንታ ማራናሺን› » ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","ዬሱሲ ኤንታኮ፥ «ሃ ሌሚሶይ ሂንቴው ጌሌኔ? ያቲን፥ ሌሚሶ ኡባ ሂንቴ ዋቲ ኣኬካኔ? ");
INSERT INTO gofENT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","ዜሬይሲ ፆሳ ቃላ ዜሬስ። ");
INSERT INTO gofENT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","ቃላይ ዜሬቲያ ዎዴ ኦጌ ጋፃን ዎꬊዳይሳቲ ቃላ ሲዒዳይሳታ። ሺን ፃላሄይ ሶሁዋራ ዪዲ፥ ኤንታ ዎዛናን ዜሬቲዳ ቃላ ማፂ ዲጌስ። ");
INSERT INTO gofENT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","ሄሳዳካ፥ ጋርሳን ሻሎይ ዴዒያ ቢታን ዜሬቲዳይሲ ቃላ ሲዒዲ፥ ኤሌሲዲ ኡፋይሳን ኤኬይሳ። ");
INSERT INTO gofENT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","ሺን ኤንታው ሚኖ ፃጶይ ባይና ጊሾ ሃዒሳፌ ኣቲን ጋምዖኮና። ጉꬃ ዎዴፔ ጉዬ ቃላ ጋሶን ዋዬይ ዎይኮ ጎዲ ጋኪያ ዎዴ ኤሌሲዲ ꬉቤቶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","ኣጉንꬃ ጊዶን ዜሬቲዳይሲ ቃላ ሲዔይሳታ። ");
INSERT INTO gofENT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ሺን ሃ ሳዓ ዴዑዋስ ሂርጎይ፥ ዱሬቴꬃ ዶሶይኔ ሃራባ ኣሞቴይሲ ኢያ ዎዛናን ጌሊዲ ቃላ ጩሊያ ጊሾ ኣይፌ ኣይፎና ኣቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","ሺን ኣራዳ ቢታን ዜሬቲዳይሳቲ ቃላ ሲዒዲ ኤኬይሳታ። ኤንቲ ኢሶይ ሃስታማ፥ ኢሶይ ኡሱፑን ታማ ኢሶይ ፄታ ኣይፊስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","ዬሱሲ ጉጂዲ፥ «ፆምፔ ኤኪዲ፥ ዳቾፌ ዎይኮ ኣልጋፌ ጋርሳን ዎꬂያ ኣሲ ዴዒ? ꬎቃ ቤሳን ዎꬄኔዬ? ");
INSERT INTO gofENT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","ሂዛ፥ ቆሴቲዳባይ ኡባይ ቆንጬ ኬያና፤ ጌሚዳባይ ኡባይ ኤሬቶና ኣቴና። ");
INSERT INTO gofENT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","ሲዒያ ሃይꬂ ዴዒያ ኦኒካ ሲዖ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","ቃሲ ኤንታኮ፥ «ሂንቴ ሲዒያባ ኣኬኪዲ ሲዒቴ! ፆሳ ቃላ ሂንቴ ሲዔይሳ ሜላ ኢ ሂንቴው ኣኬካ ኢማና። ኡባካ ሂንቴው ዳርሲዲ ኢማና። ");
INSERT INTO gofENT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","ኢሲባይ ዴዒያ ኡራስ ጉጂ ኢሜታና፥ ባይናይሳፌ ሃሪ ኣቶሺን፥ ኢያው ዴዒያ ሄ ጉꬂያካ ኤኬታና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","ዬሱሲ ዛሪዲ፥ «ፆሳ ካዎቴꬃይ ባ ጋዴን ዜሬꬂ ዜሪያ ኣሳ ሜላ። ");
INSERT INTO gofENT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","ሄ ኡራይ ቃማ ꬊስኬስ፤ ዎንታ ዴንዴስ። ኢ ባ ሁዔን ዋኒያኮ ኤሮና ዴዒሺን ሄ ዜሬꬃይ ዶሌሲኔ ዲጬስ። ");
INSERT INTO gofENT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","ቢታይ ካꬂ ባርካ ኢሜስ። ኮይሮ ዶሊዲ ዲጬስ፥ ካሊዲ ኣይፋናው ጋምቡፄስ፥ ዉርሴꬃን ኩሜꬃ ኣይፌ ኣይፌስ። ");
INSERT INTO gofENT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","ሺን ካꬃይ ጋኪያ ዎዴ ኡራይ ሶሁዋራ ባጫራ ጌሊ ኣጌስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","ዬሱሲ፥ «ኑኒ ፆሳ ካዎቴꬃ ኣይ ዳኔስ ጋኔ? ዎይኮ ኣይቢራ ሌሚሳኔ? ");
INSERT INTO gofENT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","ፆሳ ካዎቴꬃይ ኣይፌ ጉꬃ ሚꬂ ዳኔስ። ሄ ሚꬃ ኣይፊያ ዜሪያ ዎዴ ሳዓን ዴዒያ ሚꬃ ኣይፌ ኡባፌ ጉፄስ። ");
INSERT INTO gofENT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","ዜሪን ዶሊዲ ኣታኪልቴ ኡባፌ ጊታቴስ፤ ዳሮ ዳሺ ዳዬስ። ካፎቲ ኢያ ታሺያ ቦላ ኬፂዲ ኡታና ጋካናው ዳዬስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","ዬሱሲ ሃይሳ ሜላ ዳሮ ሌሚሶን ኣሳይ ኣኬካናው ዳንዳዔይሳ ሜላ ቃላ ኦዲስ። ");
INSERT INTO gofENT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","ኣሳስ ሌሚሶይ ባይና ኦዴና። ሺን ዬሱሲ ባ ታማሬታ ፃላላራ ዴዒያ ዎዴ ኤንታው ኡባባ ቢርሺዲ ኦዲስ። ");
INSERT INTO gofENT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","ሄ ጋላስ ሳዓይ ኦማርሲን፥ ዬሱሲ ባ ታማሬታኮ፥ «ኣባፌ ሄፊንꬂ ፒኖስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","ኢያ ታማሬቲ ዳሮ ኣሳ ዬጊ ኣጊዲ፥ ዬሱሲ ካሴ ጌሊ ኡቲዳ ዎጎሉዋን ጌሊዲ ዬሱሳ ባንታራ ኤፊዶሶና። ሃራ ዎጎሎቲካ ያን ዴዖሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","ዎልቃማ ጎቴይ ዴንዲዲ፥ ሆቤይ ዎጎሉዋ ሾጪን፥ ኩማና ጋካናው ዎጎሉዋ ጊዶ ሃꬂ ጌሊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","ሄ ዎዴ ዬሱሲ ዎጎሉዋን ጉዬ ባጋራ ቦርኮቲዲ ꬊስኪስ። ኢያ ታማሬቲ ኢያ ዴንꬂዲ፥ «ኣስታማሪያው፥ ኑኒ ꬋያ ዎዴ ኔ ሲዒ ጋዳ ፄላይ?» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","ያቲን፥ ኢ ባርኪዲ ጎቲያ፥ «ሲዒ ጋ» ጊዲ፥ ኣባካ፥ «ዎፑ ጋ» ጊስ። ጎቴይካ ሲዒ ጊን ኡባባይ ዎፑ ጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","ዬሱሲ ባ ታማሬታኮ፥ «ኣይስ ሃይሳዳ ባቤቲ? ሂንቴው ኣማኖይ ዋኒዲ ꬋዪዴ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","ኤንቲ ዳሮ ባቢዲ ባንታ ጊዶን፥ «ሃይሲ ሃሪ ኣቶሺን፥ ጎቴይኔ ኣባይ ኪቴቴይሲ ኦኔ?» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","ዬሱሲኔ ኢያ ታማሬቲ ኣባ ፒኒዲ፥ ጌርጌሶኔ ጊያ ቢታ ጋኪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","ዬሱሲ ዎጎሉዋፔ ዎꬊያ ዎዴ ቱና ኣያናይ ኦይኪዳ ኢሲ ኡራይ ዱፎፔ ኬዪዲ ኢያራ ጋሄቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","ሄ ኡራይ ዱፉዋን ኣቂ ፔዒዲ ዴዔስ። ኢያ ኦኒካ ሳንꬃላታን ቃቻናው ዳንዳዔና። ");
INSERT INTO gofENT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","ኢ ዳሮ ቶሆ ዱꬃኒኔ ሳንꬃላታን ቃሼቲዲ ዴዔስ። ሺን ሳንꬃላታ ዱሴሬꬄስ፥ ዱꬃ ሜንꬄሬꬄስ። ኢያ ቴቃናው ዳንዳዒያ ኦኒካ ባዋ። ");
INSERT INTO gofENT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","ኢ ቃማኔ ጋላስ ሄ ዱፉዋኒኔ ዴሬ ቦላ ዋሴስ፥ ባ ቦላካ ሹቻን ጋሬስ። ");
INSERT INTO gofENT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","ዬሱሳ ሃሆን ቤዒዳ ዎዴ ዎፂ ቢዲ ኢያ ሲንꬃን ጉልባቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ሄ ኡራይ ባ ቃላ ꬎቁ ኦꬂዲ፥ «ኡባፌ ቦላ ፆሳ ናዓው ዬሱሳ፥ ኔናኔ ታና ኣይቤ ጋꬄይ? ታና ꬋይሶና ሜላ ታኒ ኔና ፆሳ ሱንꬃን ዎሳይስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","ኢ ሄሳ ጊዳይ ዬሱሲ ኢያ፥ «ላ ሃ ቱና ኣያናው፥ ሃ ኣዲያፌ ኬያ» ያጊዳ ጊሾሳ። ");
INSERT INTO gofENT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","ዬሱሲ ኢያኮ፥ «ኔ ሱንꬃይ ኦኔ?» ያጊዲ ኦይቺስ። ኢ፥ «ኑኒ ዳሮ ጊዲያ ጊሾ ታ ሱንꬃይ ሌጊዮና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","ቱና ኣያናቲ ባንታና ሄ ቢታፌ ኬሲ ዬዶና ሜላ ዬሱሳ ሚንꬂዲ ዎሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","ሄ ዴሪያ ቦላ ዳሮ ጉዱንꬆ ዉዴይ ሃሙቴስ። ");
INSERT INTO gofENT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","ቱና ኣያናቲ ዬሱሳኮ፥ «ኑና ሂኒ ጉዱንꬆ ዉዲያኮ ዬዳርኪ፥ ኤንታን ቢዲ ጌሎስ» ያጊዲ ዎሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","ዬሱሲ ኤንታኮ፥ «ቢቴ» ያጊስ። ያቲን ቱና ኣያናቲ ኣዲያፌ ኬዪዲ ጉዱንꬆታን ጌሊዶሶና። ናምዑ ሙኩሉ ጊዲያ ጉዱንꬆ ዉዴይ ኣፎ ዶናራ ዲርጊዲ ቢዲ ኣባን ጌሊዲ ሚቴቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","ጉዱንꬆ ዉዲያ ሄሜይሳቲ ባቃቲ ቢዲ ሃኒዳባ ካታማኒኔ ጋፃሪያን ኦዲዶሶና። ያቲን ኣሳይ ሃኒዳባ ቤዓናው ኬዪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","ኣሳይ ዬሱሳኮ ያ ዎዴ ቱና ኣያናን ኦይኬቲዳ ኡራ ቤዒዶሶና። ኢ ባ ዎዛናኮ ሲሚዲ፥ ማዖ ማዒዲ፥ ያን ኡቲዳይሳ ቤዒዳ ዎዴ ኡባይ ያዪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","ሄሳ ቤዒዳ ኣሳቲ ቱና ኣያናቲ ኦይኪዳ ኡራ ቦላኔ ጉዱንꬆታ ቦላ ሃኒዳባ ኡባ ኣሳስ ኦዲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","ሄሳ ጊሾ፥ ኣሳይ ባንታ ቢታፌ ዬሱሲ ባና ሜላ ዎሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","ዬሱሲ ዎጎሉዋን ጌሊያ ዎዴ ካሴ ቱና ኣያናይ ኦይኪዲ ዬዲዳ ኡራይ፥ ዬሱሳ ካላናው ኢያ ዎሲስ። ");
INSERT INTO gofENT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","ሺን ዬሱሲ ኢፂዲ ኢያኮ፥ «ኔ ሶ ሲማዳ፥ ጎዳይ ኔው ኣይ ሜላ ጊታባ ኦꬂዳኮኔ ኔው ኣይ ሜላ ኬሂዳኮ ኔ ሶ ኣሳስ ኦዳ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","ኡራይ ቢዲ ታሙ ካታማ ጊያሶን ዩዪዲ፥ ዬሱሲ ባው ኣይ ሜላ ጊታባ ኦꬂዳኮ ኦዲስ። ኢ ኦዲዳይሳ ሲዒዳ ኣሳ ኡባይ ማላሌቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","ዬሱሲ ሲሚዲ፥ ዎጎሉዋን ጌሊዲ፥ ኣባ ፒኒዳፔ ጉዬ ዳሮ ኣሳይ ኣባ ጋፃን ኢያ ዩሹዋን ሺቂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","ኢያሮሳ ጊያ ኣይሁዴ ዎሳ ኬꬃ ሃላቃታፔ ኢሶይ፥ ዬሱሳ ቤዒዳ ዎዴ ኢያኮ ዪዲ ኢያ ቶሁዋ ቦላ ");
INSERT INTO gofENT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ኩንዲዲ፥ «ታ ናዒያ ሃርጋዳ ሃይቃና ሃናውሱ። ኢያ ፓፃዳ ዴዓና ሜላ ያዳ ኔ ኩሺያ ኢ ቦላ ዎꬃርኪ» ያጊዲ ዬሱሳ ሚንꬂዲ ዎሲስ። ");
INSERT INTO gofENT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","ዬሱሲ ኢያሮሳራ ቢስ። ኢ ቢሺን ዳሮ ኣሳይ ኢያ ካሊዲ ኡንዔꬂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","ታማኔ ናምዑ ላይꬂ ኢ ቦላፌ ሱꬂ ጎጊያ ኢሲ ማጫሲያ ዴዓዉሱ። ");
INSERT INTO gofENT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","ዳሮ ኣኪሜቲ ኢዮ ኣኪሚዶሶና፥ ሺን ኢያ ፓፃ ካዔታሱ። ኢያ ባ ሚሺያ ኡባ ዉርሲንካ ኢው ሃ ኢቲስፔ ኣቲን ኣይኮካ ማዲቤና። ");
INSERT INTO gofENT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","ሄ ማጫሲያ ዬሱሳባ ሲዓዳ፥ ኣሳ ካንꬃዳ ዬሱሳ ጉዬራ ያዳ ኢያ ማዑዋ ቦቻሱ። ");
INSERT INTO gofENT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","ኢያ፥ «ታኒ ሃሪ ኣቶሺን ኢያ ማዑዋ ቦቺያኮ ፓፃና» ጋዳ ቆፓሱ። ");
INSERT INTO gofENT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","ኢፔ ጎጊያ ሱꬃይ ሶሁዋራ ኤቂ ኣጊስ። ኢያ ባ ዋያፔ ፓፂዳይሳ ባ ኣሳቴꬃን ኤራሱ። ");
INSERT INTO gofENT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","ዬሱሲ ባፔ ዎልቂ ኬዪዳይሳ ባ ሁዔን ኤሪዲ፥ ኤሌሲዲ ዳሮ ኣሳ ጊዶን ጉዬ ሲሚዲ፥ «ታ ማዑዋ ቦቺዳይ ኦኔ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","ኢያ ታማሬቲ፥ «ኣሳይ ኔና ሱጌይሳ ቤዓሼ፥ ‹ዎይጋዳ ታና ኦኔ ቦቺዳይ ያጋይ?› » ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","ዬሱሲ ሄሳ ኦኒ ኦꬂዳኮ ቤዓናው ዩሺ ኣꬂ ፄሊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","ሺን ማጫሲያ ባው ሃኒዳባ ኤራዳ፥ ያሻን ኮኮራሼ ያዳ ዬሱሳ ሲንꬃን ጉፋናሱ፤ ቃሲ ሃኒዳባ ኡባ ቱማ ኢያው ኦዳሱ። ");
INSERT INTO gofENT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","ያኒን፥ ዬሱሲ ኢኮ፥ «ታ ናቴ፥ ኔና ኔ ኣማኖይ ፓꬂስ፥ ሳሮን ባ፥ ኔ ዋያፔካ ፓፃ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","ዬሱሲ ቡሮ ሄሳ ኦዲሺን፥ ኣይሁዴ ዎሳ ኬꬃ ሃላቃ ሶፔ ኪቴቲዳ ኣሳቲ ዪዲ፥ «ኔ ናዒያ ሃይቃሱ፥ ኣስታማሪያ ኣይስ ዳቡሪሳይ?» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","ሺን ዬሱሲ ኤንቲ ጌይሳ ሲዒዲ፥ ኣይሁዴ ዎሳ ኬꬃ ሃላቃኮ፥ «ኣማኖ ፃላላ ኣማናፔ ኣቲን ባቦፋ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","ዬሱሲ ጴፂሮሳፔ፥ ያይቆባፔኔ ያይቆባ ኢሻ ዮሃኒሳፔ ሃሪ ኦኒካ ባና ካሎና ሜላ ዲጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","ኤንቲ ኣይሁዴ ዎሳ ኬꬃ ሃላቃ ሶ ጋኪያ ዎዴ ዬሱሲ ኣሳይ ካሃ ꬋዪዲ ዬኬይሳኔ ዜሌሌይሳ ቤዒስ። ");
INSERT INTO gofENT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","ጌሊዲ ኣሳኮ፥ «ኣይስ ካሃ ꬋዪዲ ዬኬቲ? ናዒያ ꬊስካሱፔ ኣቲን ሃይቃቡኩ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","ኣሳይ ኢያ ቦላ ሚጪስ። ሺን ኣሳ ኡባ ካሬ ኬሲዲ፥ ናዔ ኣዋ፥ ኣዪዉኔ ሄꬑ ታማሬታ ባራ ኤኪዲ ናዒያ ዴዒያሱዋ ጌሊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","ዬሱሲ ናዔ ኩሺያ ኦይኪዲ፥ «ፃሊታ፥ ቁሚ» (ጉꬃ ናቴ፥ ኔና ጋይስ ዴንዳ) ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","ናዒያ ሶሁዋራ ዴንዳ ኤቃዳ ሃሙታሱ። ኢያ ታማኔ ናምዑ ላይꬃ ናዓ። ሄሳን ኣሳይ ዳሮ ማላሌቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","ዬሱሲ ሄሳ ኤንቲ ኦዴስካ ኦዶና ሜላ ኤንታ ሚንꬂ ኪቲስ። ኤንቲ ኢው ሚያባ ኢማና ሜላ ኦዲስ። ");
INSERT INTO gofENT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","ዬሱሲ ያፔ ኬዪዲ፥ ባ ታማሬታ ካሌꬂዲ፥ ባ ካታማ ናዚሬቴ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","ሳምባታ ጋላስ ኣይሁዴ ዎሳ ኬꬃን ታማርሶ ኦይኪስ። ኢ ታማርሴይሳ ሲዒዳ ዳሮ ኣሳይ ማላሌቲዲ፥ «ሃይሲ ሃ ኡባ ኣዉፔ ዴሚዴ? ሃ ጪንጫቴꬃ ኢ ኣዉፔ ኤኪዴ? ሃ ማላታታ ኦꬂያ ማታ ኢ ኣዉፔ ዴሚዴ? ");
INSERT INTO gofENT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","ሃይሲ ኣናፂያ ጊዴኔ? ማይራሚ ናዓ፥ ያይቆባ፥ ዮሳ፥ ዪሁዳኔ ሲሞና ኢሻ ጊዴኔዬ? ኢያ ሚቼቲ ኑራ ሃይሳን ዴዖኮናዬ?» ያጊዲ፥ ኢ ጊያባ ኤኮና ኢፂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","ዬሱሲ ሄ ኣሳኮ፥ «ናቤይ ባ ቢታን፥ ባ ዳቦታኒኔ ባ ሶ ኣሳን ቦንቼቴናፌ ኣቲን ሃራታ ማታን ቦንቼቴስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","ኢ ሄ ቤሳን ባ ኩሺያ ጉꬃ ኣሳ ቦላ ዎꬂዲ ፓꬂዳይሳፌ ኣቲን ሃራ ማላታታ ኦꬃናው ዳንዳዒቤና። ");
INSERT INTO gofENT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","ኣሳይ ኣማኒቦና ጊሾ ዳሮ ማላሌቲስ። ሄሳፌ ጉዬ፥ ዬሱሲ ሄ ሄራን ዴዒያ ጉታታን ኣሳ ታማርሴስ። ");
INSERT INTO gofENT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","ዬሱሲ ታማኔ ናምዑ ታማሬታ ባኮ ፄጊዲ፥ ናምዓ ናምዓ ጋꬂዲ ኪቲስ። ኤንታው ቱና ኣያናታ ኬሲያ ዎልቃ ኢሚስ። ");
INSERT INTO gofENT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","ኤንታ፥ «ኦጌ ፃምዓፌ ኣቲን ካꬂ፥ ካርፂታ፥ ሂንቴ ኪሴን ሚሼ ኣይቢባካ ኦይኮፊቴ። ");
INSERT INTO gofENT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","ሂንቴ ቶሁዋን ጫማ ኣꬂቴ፥ ሺን ናምዑ ኣፊላ ኦይኮፊቴ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","ቃሲካ፥ «ሂንቴና ኣሲ ሞኪዳ ሶ ኣዉንካ ጊዲን ሄ ቤሳ ዬዲዲ ባና ጋካናው ሄ ኬꬃን ጋምዒቴ። ");
INSERT INTO gofENT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","ሂንቴና ኣሲ ሞኮናሱዋ ዎይኮ ሂንቴ ኦዲያባ ሲዖናሱዋ ኣዉን ጊዲኮካ፥ ሄ ቢታን ዴዒያ ኣሳስ ሄሲ ናጊሶ ማርካ ጊዳና ሜላ ሄ ቤሳፌ ኬዪሼ፥ ሂንቴ ቶሁዋፔ ባና ፒቲቴ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","ታማኔ ናምዑ ታማሬቲ ቢዲ፥ ኣሳይ ባንታ ናጋራፔ ሲማናዳ ቃላ ኦዲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","ኤንቲ ኣሳፔ ዳሮ ቱና ኣያናታ ኬሲዶሶና። ዳሮ ሃርጋንቾታ ዛይቴ ቲዪዲ ፓꬂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","ዬሱሳ ሱንꬃይ ኡባ ቤሳን ኬዪዳ ጊሾ ካዎይ ሄሮዲሲ ኢያባ ሲዒስ። ኢሲ ኢሲ ኣሳይ፥ «ፃማቂያ ዮሃኒሲ ሃይቆፔ ዴንዲስ፥ ሄሳ ጊሾ ሃ ማላታታ ኦꬄይ ኢያ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","ባጋቲ፥ «ሃይሲ ኤሊያሳ ጊዴኔ?» ያጊዶሶና። ሃራቲ ቃሲ፥ «ሃይሲ ቤኒ ዎዴ ናቤታፕ ኢሱዋ ጊዶና ኣጌና» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","ሺን ሄሮዲሲ ሄሳ ሲዒዳ ዎዴ «ሃይሲ ታኒ ቆꬊያ ቃንፂሲዳ ፃማቂያ ዮሃኒሳ ጊዴኔ? ኢ ሃይቆፔ ዴንዲስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","ሄሮዲሲ ባ ኢሻ ፊልጶሳ ማቺው ሄሮዲያዳ ኤኪዳ ጊሾ ኢ ጋሶን ዮሃኒሳ ኦይꬂዲ ቃሺሲስ። ");
INSERT INTO gofENT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","ዮሃኒሲ ሄሮዲሳ፥ «ኔኒ ኔ ኢሻ ማቺው ኤካናው ቤሴና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","ሄሮዲያዳ ዮሃኒሳ ባ ኡሎን ሞርካዳ ኢያ ዎꬊሳናው ኮያሱ፥ ሺን ዳንዳዓቡኩ። ");
INSERT INTO gofENT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ዮሃኒሲ ፂሎኔ ጌሻ ኣሲ ጊዲዳይሳ ሄሮዲሲ ኤሪዳ ጊሾ ኢያው ባቢዲ ሎይꬂ ናጊሴስ። ሄሮዲሲ ዮሃኒሲ ጊያባ ሲዓናው ዶሲኮካ ኢ ጊያባ ሲዒያ ዎዴ ዳሮ ዳጋሜስ። ");
INSERT INTO gofENT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","ሄሮዲሲ ባ ዬሌቲዳ ጋላሳ ቦንቻናው ዴሪያ ሃሬይሳታስ፥ ሻላቃታሲኔ ጋሊላን ዴዒያ ጊታ ኣሳስ ኢማቶ ጊጊሲስ። ሄሲ ሄሮዲያዳስ ኢንጄ ጋላስ ጊዲስ። ");
INSERT INTO gofENT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","ሄሮዲያዳ ናዒያ ኢማꬃይ ሞኬቲያ ቤሳ ጌላ ዱራዳ፥ ሄሮዲሳኔ ኢያ ኢማꬃታ ኡፋይሳሱ። ካዎይ ናዒው፥ «ኔ ኮያባ ኣይባ ጊዲኮካ ታና ኦይቻ፥ ታኒ ኔው ኢማና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","ቃሲ ኢው ጫቂዲ፥ «ኔኒ ኦይቺያባ ኣይባ ጊዲኮካ፥ ታኒ ኔው ኢማና። ሃሪ ኣቶሺን፥ ታ ካዎቴꬃ ባጋ ጊዲኮካ ታኒ ኔው ኢማና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","ናዒያ ካሬ ኬያዳ ባ ኣዬኮ፥ «ኣይ ኢማ ጎ?» ጋዳ ኦይቻሱ። ኢ ኣያ፥ «ፃማቂያ ዮሃኒሳ ሁዒያ ኢማ ጋ» ያጋሱ። ");
INSERT INTO gofENT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","ናዒያ ኤላሳዳ ካዉዋኮ ባዳ፥ «ፃማቂያ ዮሃኒሳ ሁዒያ ሳኔን ዎꬃዳ ሃዒ ታው ኢማና ሜላ ኮያይስ» ያጋሱ። ");
INSERT INTO gofENT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","ያኒን ካዎይ ዳሮ ቂሮቲስ፥ ሺን ባ ኢማꬃታ ጊሾ ኢው ጫቂዳ ባ ጫቁዋ ሜንꬃናው ኮዪቤና። ");
INSERT INTO gofENT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","ሄሳ ጊሾ፥ ኤሌሲዲ ናጌይሳ ዮሃኒሳ ሁዒያ ኤሃና ሜላ ኪቲስ። ናጌይሲ ቃሾ ኬꬂ ቢዲ ዮሃኒሳ ቆꬊያ ቃንፂስ። ");
INSERT INTO gofENT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ሄ ቃንፄቲዳ ሁዒያ ሳኔን ዎꬂ ኤሂዲ ናዔስ ኢሚስ። ናዒያ ቃሲ ባ ኣዬስ ኢማሱ። ");
INSERT INTO gofENT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","ዮሃኒሳ ታማሬቲ ሄሳ ሲዒዳ ዎዴ ቢዲ ኢያ ኣሃ ኤኪ ኤፊዲ ሞጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","ታማኔ ናምዑ ሃዋሬቲ ሲሚ ዪዲ ኤንቲ ኦꬂዳባኔ ታማርሲዳባ ኡባ ዬሱሳስ ኦዲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","ኤንታኮ ያ ኣሳይኔ ቢያ ኣሳይ ዳሪዳ ጊሾ ዬሱሳራኔ ኢያ ታማሬታራ፥ ሃሪ ኣቶሺን ካꬂ ማናዉካ ኤንታ ጋꬆና ኢፂስ። ያኒን፥ ዬሱሲ ኤንታኮ፥ «ኑርካ ጉꬂ ሼምፒ ኤካናው ኣሲ ባይና ቤሲ ዬꬊቴ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","ሄሳ ጊሾ፥ ኤንቲ ባንታርካ ዎጎሎን ጌሊዲ ኣሲ ባይና ቤሲ ቢዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","ኤንቲ ቢሺን ዳሮ ኣሳይ ኤንታ ቤዒዲ ኤሪዶሶና። ያቲን፥ ካታማ ኡባፌ ኣሳይ ቶሆራ ዎፂ ቢዲ ኤንቲ ቢያሱዋ ኤንታፌ ሲንꬄ ጋኪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","ዬሱሲ ዎጎሉዋፔ ዎꬊዲ ዳሮ ኣሳ ቤዒስ። ኣሳይ ሄሚያ ኣሲ ባይና ዶርሳ ሜላ ጊዲዳይሳ ቤዒዲ ኤንታው ቃꬌቲዲ ኤንታ ዳሮባ ታማርሲስ። ");
INSERT INTO gofENT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","ሳዓይ ኦማርሲያ ዎዴ ዬሱሳ ታማሬቲ ኢያኮ ዪዲ፥ «ሃይሲ ቤሳይ ኣሲ ባይና ቤሲ፤ ሃዒ ሳዓይካ ቃሚስ። ");
INSERT INTO gofENT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","ኣሳይ ጉታታኔ ካታማታ ቢዲ ባንታው ሚያባ ሻማና ሜላ ኣሳ ዬዳ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","ሺን ዬሱሲ ዛሪዲ ኤንታኮ፥ «ኣሳስ ሚያባ ሂንቴ ኢሚቴ» ያጊስ። ኤንቲ፥ «ኑኒ ቢዲ ናምዑ ፄቱ ዲናሬን ኡይꬁ ሻሚዲ ኣሳ ሙዛና ሜላ ኮያይ?» ያጊዲ ኦይቺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","ዬሱሲ ኤንታኮ፥ «ሂንቴው ኣፑን ኡይꬂ ዴዒ? ኣኔ ቢዲ ቤዒቴ» ያጊስ። ኤንቲ ቤዒዲ፥ «ኢቻሹ ኡይꬁኔ ናምዑ ሞሎ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","ዬሱሲ ባ ታማሬታ ኣሳ ኡባ ጩጋን ጩጋን ሻኪዲ ማታን ኡቲሳና ሜላ ኪቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","ኣሳይ ባጋይ ፄታ፥ ባጋይ ኢሻታማ ጊዲዲ ጩጋን ጩጋን ሻኬቲዲ ኡቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","ዬሱሲ ኢቻሹ ኡይꬃኔ ናምዑ ሞሎታ ኤኪዲ፥ ፑዴ ሳሎ ፄሊዲ ፆሳ ጋላቲስ። ኡይꬃ ሜንꬂዲ ኣሳስ ጊሻና ሜላ ባ ታማሬታስ ኢሚስ። ቃሲ ናምዑ ሞሎታ ኤንታ ኡባስ ሻኪስ። ");
INSERT INTO gofENT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","ኣሳ ኡባይ ሚዲ ካሊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","ኣቲዳ ኡይꬃ ቲፊያኔ ሞሎታ ቲፊያ፥ ኢያ ታማሬቲ ታማኔ ናምዑ ጋይታ ኩሜꬂ ዴንꬂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","ኡይꬃ ሚዳ ኣዴ ኣሳ ታይቦይ ኢቻሹ ሙኩሉ። ");
INSERT INTO gofENT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","ኤሌሲዲ ዬሱሲ ባ ታማሬቲ ዎጎሉዋን ጌሊዲ፥ ኣባፌ ሄፊንꬃን ዴዒያ ቤቴሳይዳ ባፔ ሲንꬃቲዲ ባና ሜላ ኪቲስ። ሺን ባው ኣሳ ሞይዛናው ጉዬ ኣቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","ኣሳ ሞይዚዳፔ ጉዬ ፆሳ ዎሳናው ዴሪያ ቦላ ኬዪስ። ");
INSERT INTO gofENT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","ሳዓይ ቃሚያ ዎዴ ዎጎሎይ ኣባ ጊዶን ዴዔስ፥ ሺን ዬሱሲ ኣባፌ ጋፃን ባርካ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","ጫርኮይ ኢያ ታማሬታኮ ጫርኪያ ጊሾ ኣባ ፒꬎይ ዋይሴይሳ ዬሱሲ ቤዒስ። ዎንቲማꬄ ሳዓይ ጌያና ሃኒያ ዎዴ ኢ ኣባ ቦላ ሃሙቲሼ ኤንታኮ ዪዲ፥ ኤንታ ዬጊዲ ኣꬋናው ኮዪስ። ");
INSERT INTO gofENT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ሺን ኢ ኣባ ቦላ ሃሙቲሺን፥ ኤንቲ ቤዒዲ፥ ኤንታው ሞይቲሌ ዳኒን ዋሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","ኤንቲ ኡባይ ኢያ ቤዒዲ፥ ያሻን ኮኮሪዶሶና። ሺን ዬሱሲ ኤሌሲዲ ኤንታኮ፥ «ታና፥ ኣይኮይ ባዋ፤ ያዮፊቴ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","ዬሱሲ ዎጎሉዋን ጌሊዲ ኤንታራ ኢሲፌ ኡቲን ጫርኮይ ዎፑ ጊስ። ኤንቲ ዳሮ ማላሌቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ኤንታ ዎዛናይ ዜልዑሚዳ ጊሾ ኤንቲ ኡይꬃባ ኣኬኪቦኮና። ");
INSERT INTO gofENT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","ኤንቲ ኣባ ፒኒዲ፥ ጌንሳሬፄ ቢታ ጋኪዲ፥ ዎጎሉዋ ጋፃ ሺሺዲ ቃቺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","ኤንቲ ዎጎሉዋፔ ዎꬊያ ዎዴ ኣሳይ ኤሌሲዲ ዬሱሳ ኤሪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ኤንቲ ሄራን ዴዒያ ቢታ ኡባን ዎፄሬቲዲ ሃርጋንቾታ ሃላን ቶኪዲ፥ «ዬሱሲ ዴዔስ» ጊን ሲዒዳ ቤሳ ኤሂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","ኣሳይ ኢ ቢዳ ሶ ኡባን፥ ጋፃሪያን ጊዲን፥ ካታማን፥ ዴዒያ ሃርጋንቾታ ዳባባ ኤፎሶና። ሃርጋንቾቲ ኢያ ኣፊላ ማጫራ ጊዲኮካ ቦቻና ሜላ ኣሳይ ኢያ ዎሲዶሶና። ቦቺዳ ኡባይ ፓፂስ። ");
INSERT INTO gofENT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","ዬሩሳላሜፔ ዪዳ ጉꬃ ፋሪሳዌቲኔ ሂጌ ኣስታማሬቲ ዬሱሳ ማታን ሺቂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","ዬሱሳ ታማሬታፔ ኢሶቲ ኢሶቲ ጌዮና ኩሺያን፥ ሄሲካ ኩሼ ሜጬቶና ካꬂ ሜይሳታ ቤዒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","ፋሪሳዌቲኔ ኣይሁዴ ኣሳ ኡባይ ባንታ ኣዋታ ዎጋꬆ ባንታ ኩሺያ ሜጬቶና ሞኮና። ");
INSERT INTO gofENT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","ሄሳዳካ፥ ኤንቲ ጊያፔ ሻሜቲዳባ ሜጮና ዴዒሼ ሞኮና። ቃሲ ኤንቲ ባንታ ኣዋታፔ ኤኪዳ ሃራ ዳሮ ዎጊ ዴዔስ፡ ሄሲካ ሲኒያ፥ ኬሪያ፥ ቢራታ ሚሼታኔ ኣርሳ ሜጪያ ዎጋ ናጌይሳ። ");
INSERT INTO gofENT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","ፋሪሳዌቲኔ ሂጌ ኣስታማሬቲ ዬሱሳ፥ «ኔ ታማሬቲ ኣይስ ኣዋታ ዎጋ ሜንꬂዲ ባንታ ኩሺያ ሜጬቶና ካꬂ ሞና?» ያጊዲ ኦይቺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","ዬሱሲ ኤንታኮ፥ «ኢሳያሲ ሂንቴና ጩቦታ፥ ‹ሃይሲ ኣሳይ ታና ባ ኢንፃርሳ ፃላላን ቦንቼስ፥ ሺን ኤንታ ዎዛናይ ታፔ ሃሆን ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","ኣሲ ሜꬊዳ ዎጋ ፆሳ ሂጌ ዳኒሲዲ ታማርሲያ ጊሾ ኤንቲ ታና ሜላ ጎይኖሶና› » ጊዲ ፃፊዳይሲ ቱማ። ");
INSERT INTO gofENT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","«ሂንቴ ፆሳ ኪታ ኣጊዲ ኣሳ ዎጋ ሚንꬂዲ ናጌታ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","ቃሲካ ዬሱሲ፥ «ሂንቴ ሂንቴ ዎጋ ናጊዲ ፆሳ ኪታ ዬጊ ኣጋናው ሎዖ ኦጌ ዴሚዴታ። ");
INSERT INTO gofENT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","ሙሴይ፥ ‹ኔ ኣዋኔ ኔ ኣዪው ቦንቻ›፥ ቃሲ ‹ባ ኣዋኔ ባ ኣዪው ጫዬይሲ ሃይቃናው ቤሴስ› ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","ሺን ኢሲ ኣሲ ባ ኣዋ ዎይኮ ባ ኣዪው ማዳናይሳ ኣጊዲ፥ ‹ሄሲ ፆሳ ያርሾ› ጊኮ፥ ");
INSERT INTO gofENT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ኢ ባ ኣዋ ዎይኮ ባ ኣዪው ማዶና ሜላ ኦꬄታ። ");
INSERT INTO gofENT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","ሄሳዳካ፥ ሂንቴ ሃራታ ታማርሲዳ ሂንቴ ዎጋን ፆሳ ቃላ ካꬊዴታ። ሄሳ ሜላ ሃራ ዳሮባ ኦꬄታ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","ዬሱሲ ዳሮ ኣሳ ቃሲካ ባኮ ፄጊዲ፥ «ኡባይ ታኒ ኦዴይሳ ሲዒቴኔ ኣኬኪቴ። ");
INSERT INTO gofENT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","ኣሳ ዎዛናፔ ኬያባይ ኣሴ ቱኒሴሲፔ ኣቲን ካሬፔ ኣሳ ኡሎ ጌሊዲ ኣሴ ቱኒሲያባይ ኣይቢካ ባዋ። ");
INSERT INTO gofENT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","ሲዒያ ሃይꬂ ዴዒያ ኦኒካ ሲዖ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","ዬሱሲ ዳሮ ኣሳ ዬጊ ኣጊዲ ሶ ጌሊን ኢያ ታማሬቲ ሄ ሌሚሱዋባ ኢያ ኦይቺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","ኢ ኤንታኮ፥ «ሂንቴዉካ ቃሲ ጌሊቤኔ? ካሬፔ ኣሳ ዎዛናን ጌሊያባይ ኣይቢካ ኣሴ ቱኒሳናው ዳንዳዖናይሳ ኣኬኬቲ? ");
INSERT INTO gofENT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","ኣይስ ጊኮ፥ ካꬂ ኣሳ ኡሎ ጊዶ ጌሊዲ ካንꬂዲ ኣꬌሲፔ ኣቲን ኣሳ ዎዛና ጊዶ ጌሌና» ያጊስ። ሄሳን ዬሱሲ ካꬂ ኡባይ ጌሺ ጊዴይሳ ኤሪሲስ። ");
INSERT INTO gofENT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","ካሊዲካ፥ ዬሱሲ፥ «ኣሳ ቱኒሲያባይ ኣሳ ዎዛና ጊዶፌ ኬያባ። ");
INSERT INTO gofENT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","ኣሳ ዎዛና ጊዶፌ ኬያባይ ኢታ ቆፋ፥ ላይማቴꬂ፥ ካይሶ፥ ኣሴ ዎꬎ፥ ላሜ፥ ");
INSERT INTO gofENT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ኢታ ኣሞ፥ ኢታቴꬂ፥ ጌኔ፥ ቃይፄ፥ ጪሞ፥ ቃናቴ፥ ጫሼ፥ ኦቶሮኔ ቦዛቴꬂ። ");
INSERT INTO gofENT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","ሃ ኢታባይ ኡባይካ ኣሳ ዎዛና ጊዶፌ ኬዪዲ ኣሴ ቱኒሴስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","ዬሱሲ ያፔ ኬዪዲ፥ ፂሮሳ ካታማ ማታን ዴዒያ ቢታ ቢስ። ኢ ኢሲ ኬꬂ ጌሊዲ ያን ዴዔይሳ ኦኒካ ኤራና ሜላ ኮዪቤና። ሺን ቆሴቲዲ ጋምዓናው ዳንዳዒቤና። ");
INSERT INTO gofENT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","ሺን ኢ ጉꬃ ናዒው ቱና ኣያናይ ኦይኪዳ ኢሲ ማጫሲያ ዬሱሳባ ሲዓዳ ኤሌሳ ኢያኮ ያዳ ኢያ ቶሁዋ ቦላ ኩንዳሱ። ");
INSERT INTO gofENT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","ኢያ ኣይሁዴ ማጫሲ ጊዱኩ፤ ኢያ ዬሌቲዳይ ሲሮፊንቄ ጊያ ቢታና። ኢያ፥ ባ ናዔፔ ቱና ኣያና ኬሳና ሜላ ዬሱሳ ዎሳሱ። ");
INSERT INTO gofENT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","ሺን ዬሱሲ ዛሪዲ፥ «ናይቲ ኮይሮቲዲ ካꬃ ካሎ፤ ናይታ ካꬃ ኤኪዲ ካናታስ ዬጌይሲ ሎዖ ጊዴና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","ማጫሲያ ዛራዳ፥ «ታ ጎዳው ሄሲ ቱማ፥ ሺን ጋይታ ማታን ዴዒያ ካናቲ ናይታፔ ዎꬊያ ቲፊያ ሞሶና» ያጋሱ። ");
INSERT INTO gofENT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","ዬሱሲ ቃሲ ኢኮ፥ «ሃ ኔ ቃላ ጊሾ ኔ ሶ ባ፤ ቱና ኣያናይ ኔ ናዔፔ ኬይስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","ማጫሲያ ባ ሶ ቢያ ዎዴ ቱና ኣያናይ ኢፔ ኬዪን ሂፃን ዚንዒዳሮ ዴማሱ። ");
INSERT INTO gofENT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","ዬሱሲ ፂሮሳ ካታማፔ ኬዪዲ፥ ሲዶናራኔ ታሙ ካታማታ ጊያ ቢታራ ካንꬂዲ ጋሊላ ኣባኮ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","ኣሳይ ቱሌኔ ዋዪዲ ኦዴቲያ ኣሲ ዬሱሳኮ ኤሂዲ፥ ባ ኩሺያ ኢያ ቦላ ዎꬃና ሜላ ኢያ ዎሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","ዬሱሲ ባርካ ሄ ኡራ ዳሮ ኣሳፔ ጋፃ ኬሲዲ፥ ባ ቢራꬊያ ኢያ ሃይꬃን ዬዲስ። ቃሲ ጩቺ ጩቲዲ ኢያ ኢንፃርሳ ቦቺስ። ");
INSERT INTO gofENT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","ሳሎ ፑዴ ፄሊዲ፥ ቶኪ ሼምፒዲ፥ «ኤፍታህ» ጊስ። ቢርሼꬃይካ «ዶዬታ» ጉሱ። ");
INSERT INTO gofENT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","ኡራ ሃይꬃይ ኤሌሲዲ ዶዬቲስ፥ ቃሼቲዳ ኢንፃርሳይካ ቢርሼቲስ፥ ኡራይ ጌሺዲ ኦዴቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","ዬሱሲ ኣሳኮ፥ «ሃይሳ ኦዴስካ ኦዶፒቴ» ያጊስ። ሺን ኢ ዳሮ ሚንꬂዲ ኦዶፒቴ ጊን፥ ኣሳይ ኦዳ ያ ዳርሲስ። ");
INSERT INTO gofENT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","ሄሳ ሲዒዳ ኣሳ ኡባይ ዳሮ ማላሌቲዲ፥ «ኡባባ ኢ ሎይꬂ ኦꬄስ። ሃሪ ኣቶሺን፥ ቱሊያ ሲሴስ፥ ሙሚያ ኦዲሴስ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","ጉꬃ ዎዴፔ ጉዬ፥ ዳሮ ኣሳይ ዬሱሳኮ ሺቂዶሶና። ኣሳስ ሚያባይ ꬋዪን ዬሱሲ ባ ታማሬታ ባኮ ፄጊዲ፥ ");
INSERT INTO gofENT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«ሃ ኣሳይ ታራ ሄꬑ ጋላስ ጋካናው ጋምዒዲ፥ ኣይኮካ ሚያባ ዴሚቦና ጊሾ ታና ኣሳይ ቃꬌꬄስ። ");
INSERT INTO gofENT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","ታኒ ኣሳ ኮሻራ ሶ ዬዲኮ ኣሳይ ቢሼ ኦጌን ዳቡሪዲ ኩንዳና፥ ባጋ ኣሳይ ሃሆሶፔ ዪዶሶና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","ዬሱሳ ታማሬቲ ዛሪዲ፥ «ሃ ባዞ ቢታን ሃ ኣሳ ኡባ ሙዛናው ጊዲያ ካꬂ ዴማናው ዳንዳዔይ ኦኔ?» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","ዬሱሲ ኤንታኮ፥ «ሂንቴው ኣፑን ኡይꬂ ዴዒ?» ያጊዲ ኦይቺስ። ኤንቲ ዛሪዲ፥ «ላፑን ኡይꬂ ዴዔስ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","ዬሱሲ ኣሳይ ሳዓን ኡታና ሜላ ኪቲስ። ያቲዲ፥ ላፑን ኡይꬃ ኤኪዲ ፆሳ ጋላቲ ሲሚዲ ሄ ኡይꬃ ሜንꬂዲ፥ ኣሳስ ጊሻና ሜላ ባ ታማሬታስ ኢሚስ። ኢያ ታማሬቲ ኣሳስ ጊሺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","ኤንታው ቃሲ ጉꬃ ላፋ ሞሎቲ ዴዖሶና። ዬሱሲ ሄ ሞሎታ ጊሾ ፆሳ ጋላቲዲ፥ ኣሳስ ጊሻና ሜላ ባ ታማሬታ ኪቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","ኣሳይ ኡባይ ሚዲ ካሊዶሶና። ኢያ ታማሬቲ ኣቲዳ ቲፊያ ላፑን ጋይታ ኩሜꬂ ዴንꬂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","ካꬃ ሚዳ ኣሳ ታይቦይ ኦይዱ ሙኩሉ ጊዳና። ሄሳፌ ጉዬ፥ ዬሱሲ ኣሳ ዬዲስ። ");
INSERT INTO gofENT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ኢ ቃሲ ባ ታማሬታራ ኤሌሲ ዎጎሎን ጌሊዲ ዳልማኑታ ጊያ ቢታ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","ፋሪሳዌቲ ዪዲ ዬሱሳ ፓጫናው ኮዪዲ፥ ሳሎፔ ባንታና ማላታ ቤሳና ሜላ ዬሱሳራ ፓላማ ኦይኪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","ዬሱሲ ቶኪ ሼምፒዲ፥ «ሃ ዎዲያ ኣሳይ ኣይስ ማላታ ኮዪ? ታኒ ሂንቴው ቱማ ኦዳይስ፤ ሃ ዎዲያ ኣሳስ ኣይ ማላቲካ ኢሜቴና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","ኢ ኤንታ ያን ዬጊ ኣጊዲ ዛሪ ዎጎሎን ጌሊዲ ኣባፌ ሄፊንꬂ ፒኒስ። ");
INSERT INTO gofENT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","ኢያ ታማሬቲ ካꬂ ኤፋናይሳ ዶጊዶሶና፤ ኤንታው ዎጎሉዋ ጊዶን ኢሲ ኡይꬃፌ ሃሪ ባዋ። ");
INSERT INTO gofENT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","ዬሱሲ ኤንታኮ፥ «ሂንቴና ኤሪቴ። ፋሪሳዌታ ኢርሹዋፌኔ ሄሮዲሳ ኢርሹዋፌ ናጌቲቴ» ያጊዲ ኪቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","ኤንቲ ባንታ ጊዶን፥ «ኢ ሃይሳ ጌይ ኑስ ኡይꬂ ባይና ጊሾሳ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","ዬሱሲ ኤንቲ ጌይሳ ኤሪዲ ኤንታኮ፥ «ሂንቴው ኡይꬂ ባይና ጊሾ ኣይስ ኦዴቴቲ? ሃዒካ ኤሬኬቲ? ዎይኮ ኣኬኬኬቲ? ሂንቴ ዎዛናይ ዶጪዴ? ");
INSERT INTO gofENT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","ሂንቴው ኣይፌይ ዴዒሺን ቤዔኬቲ? ሃይꬂ ዴዒሺን ሲዔኬቲ? ሂንቴ ኣኬኬቲ? ");
INSERT INTO gofENT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ታኒ ኢቻሹ ኡይꬃ ኢቻሹ ሙኩሉ ኣሳስ ባꬂዳ ዎዴ ኣፑን ጋይታ ኩሜꬂ ቲፌ ዴንꬂዴቲ?» ያጊስ። ኤንቲካ፥ «ታማኔ ናምዑ ጋይታ ኩሜꬂ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","«ሄሳዳካ፥ ታኒ ላፑን ኡይꬃ ኦይዱ ሙኩሉ ኣሳስ ባꬂዳ ዎዴ ኣፑን ጋይታ ኩሜꬃ ቲፌ ዴንꬂዴቲ?» ያጊስ። ኤንቲ፥ «ላፑን ጋይታ ኩሜꬂ ዴንꬂዳ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","ያቲን፥ «ሃዒካ ኣኬኪቤኬቲ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","ኤንቲ ቤቴሳይዳ ካታማ ቢዶሶና። ጉꬃ ኣሳቲ ቆቄ ኡራ ዬሱሳኮ ኤሂዲ ሄ ኡራ ቦቻና ሜላ ኢያ ዎሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","ዬሱሲ ቆቄ ኡራ ኩሺያ ኦይኪዲ ካታማፔ ጋፃ ኬሲስ። ኢያ ኣይፊያን ጩቲዲ ባ ኩሺያ ኢያ ቦላ ዎꬂዲ፥ «ኔው ኣይኮይ ቤንቲ?» ያጊዲ ኦይቺስ። ");
INSERT INTO gofENT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","ኡራይ ꬎቁ ጊዲ ፄሊዲ፥ «ታው ኣሳይ ቤንቴስ፥ ሺን ኣሳይ ሃሙቲሼ ሚꬂ ዳኔስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","ሄሳፌ ጉዬ፥ ዬሱሲ ዛሪዲ፥ ኡራ ኣይፊያን ባ ኩሺያ ዎꬂስ። ኡራይ ሎይꬂ ፄሊስ፥ ኢያ ኣይፌይ ፓፂስ፥ ኡባባ ጌሺዲ ቤዒስ። ");
INSERT INTO gofENT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","ዬሱሲ ኣዲያኮ፥ «ኔ ሶ ባ፥ ሺን ጉታ ጌሎፓ» ያጊዲ ኪቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","ዬሱሲ ባ ታማሬታራ ቂሳሪያ ፊልጶሳ ማታን ዴዒያ ጉታ ቢስ። ኤንቲ ቢሺን ኦጌ ቦላ ዬሱሲ፥ «ታና ኣሳይ ኦና ጎና?» ያጊዲ ባ ታማሬታ ኦይቺስ። ");
INSERT INTO gofENT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","ኢያ ታማሬቲ፥ «ኢሲ ኢሲ ኣሳይ ኔና፥ ‹ፃማቂያ ዮሃኒሳ› ጎሶና፤ ሃራቲ፥ ‹ኤሊያሳ ጎሶና› ቃሲ ሃራቲ፥ ‹ናቤታፔ ኢሱዋ› ጎሶና» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","ዬሱሲ ኤንታኮ፥ «ያቲን ሂንቴ ታና ኦና ጌቲ?» ያጊዲ ኦይቺስ። ጴፂሮሲ፥ «ኔኒ ኪሪስቶሳ» ያጊዲ ዛሪስ። ");
INSERT INTO gofENT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","ዬሱሲ፥ «ታባ ኦዴስካ ኦዶፒቴ» ያጊዲ ኤንታ ኪቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","ዬሱሲ ባ ታማሬታኮ፥ «ኣሳ ናዓይ፥ ዳሮ ሜቶ ኤካናው ቤሴስ፤ ጪማቲ፥ ካሂኔ ሃላቃቲኔ ሂጌ ኣስታማሬቲ ኢያ ኢፃናው ቤሴስ። ኤንቲ ኢያ ዎꬋናዉኔ ሄꬑ ጋላሳፔ ጉዬ፥ ኢ ሃይቆፔ ዴንዳናው ቤሴስ» ያጊዲ ኤንታ ታማርሲስ። ");
INSERT INTO gofENT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","ኢ ሄሳ ኤንታው ጌሺዲ ኦዲስ። ጴፂሮሲ ኢያ ኢሲ ባጋ ዛሪዲ ሃንቂስ። ");
INSERT INTO gofENT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","ሺን ዬሱሲ ጉዬ ሲሚዲ፥ ባ ታማሬታ ፄሊዲ፥ ጴፂሮሳ ሃንቄቲዲ፥ «ሃ ፃላሂያው፥ ታፔ ሃካ። ኔኒ ኣሲ ዶሲያባ ቆፓሳፔ ኣቲን ፆሳይ ዶሲያባ ቆፓካ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","ቃሲካ ዬሱሲ ዳሮ ኣሳኔ ባ ታማሬታ ባኮ ፄጊዲ፥ «ታና ካላናው ኮያ ኦኒካ ባና ካዶ፤ ባ ማስቃሊያ ቶኪዲ ታና ካሎ። ");
INSERT INTO gofENT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","ባ ሼምፑዋ ኣሻናው ኮያ ኡራይ ꬋይሳና። ሺን ታ ጊሾኔ ዎንጌላ ጊሾ ባ ሼምፑዋ ꬋይሲያ ኡራይ ኣሻና። ");
INSERT INTO gofENT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","ኢሲ ኣሲ ሳዓን ዴዒያ ኡባባ ባው ሺሺዲ፥ ባ ሼምፑዋ ꬋይሲኮ ኢያ ኣይ ማዳኔ? ");
INSERT INTO gofENT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","ኢሲ ኣሲ ባ ሼምፑዋ ዎዛናው ኣይ ኢማናው ዳንዳዒ? ");
INSERT INTO gofENT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","ፆሳ ኣማኖና ሃ ኢታ ዬሌቴꬃን፥ ኢሲ ኣሲ ታናኒኔ ታ ቃላን ዬላቲኮ፥ ኣሳ ናዓይ፥ ቃሲ ባ ኣዋ ቦንቾን ጌሻ ኪታንቾታራ ያ ዎዴ ኢያን ዬላታና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","ዬሱሲ ኤንታኮ፥ «ታኒ ሂንቴው ቱማ ኦዳይስ፤ ፆሳ ካዎቴꬃይ ዎልቃራ ዬይሳ ቤዖና ሃይቆና ኢሲ ኢሲ ኣሳቲ ሃይሳን ዴዖሶና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","ዬሱሲ ኡሱፑን ጋላሳፔ ጉዬ፥ ባራ ጴፂሮሳ፥ ያይቆባኔ ዮሃኒሳ ኤኪዲ፥ ኤንታ ፃላላ ጊታ ዴሪያ ቦላ ኬሲዲ ኤንታ ሲንꬃን ላሜቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ኢያ ማዖይካ ጶሊስ፤ ሳዓን ማዖ ሜጪያ ኦኒካ ጌሻናው ዳንዳዖናይሳ ሜላ ዳሮ ቦፂስ። ");
INSERT INTO gofENT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","ሄ ሄꬑ ታማሬቲ፥ ኤሊያሲኔ ሙሴይ ዬሱሳራ ኦዴቲሺን ቤዒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","ጴፂሮሲ ዬሱሳ፥ «ኣስታማሪያው፥ ኑኒ ሃይሳን ዴዔይሲ ኑስ ሎዖ፤ ኑ ሄꬑ ሻቃራታ ኢሱዋ ኔው፥ ኢሱዋ ሙሴስ፥ ቃሲ ኢሱዋ ኤሊያሳስ ሻቃራና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","ኢያራኔ ሃንኮታራ ዳሮ ያዪዳ ጊሾ ኢ ኣይ ጊያኮካ ኤሪቤና። ");
INSERT INTO gofENT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","ሄሳፌ ጉዬ፥ ሻራይ ዪዲ ኤንታ ካሚን ሻራፔ፥ «ሃይሲ ታ ዶሲያ፥ ታ ናዓ፥ ኢ ጌይሳ ሲዒቴ» ጊያ ቃላይ ዪስ። ");
INSERT INTO gofENT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","ኤሌሲዲ ኤንቲ ዩሺ ኣꬂ ፄሊያ ዎዴ ዬሱሳፔ ኣቲን ሃራ ኦናካ ባንታ ማታን ቤዒቦኮና። ");
INSERT INTO gofENT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","ኤንቲ ዴሪያፔ ዎꬊሺን፥ ዬሱሲ ኤንታኮ፥ «ኣሳ ናዓይ፥ ሃይቆፔ ዴንዳና ጋካናው፥ ሂንቴ ቤዒዳባ ኦዴስካ ኦዶፒቴ» ያጊዲ ኪቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","ኢ ኪቲዳይሳ ኤንቲ፥ «ኤሮ» ጊዲ፥ «ሃ ሃይቆፔ ዴንዶ ጌይሲ ዎይጉሴ» ጊዲ፥ ባንታ ጊዶን ኦዴቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","ኤንቲ ዛሪዲ፥ «ሂጌ ኣስታማሬቲ፥ ‹ኤሊያሲ ኮይሮቲዲ ያናው ቤሴስ› ኣይስ ጎና?» ያጊዲ ኦይቺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","ዬሱሲ ዛሪዲ «ኤሊያሲ ኮይሮቲዲ ዪዲ፥ ኡባባ ጊጊሴስ፤ ያቲን፥ ኣይስ ጌሻ ማፃፋይ፥ ‹ኣሳ ናዓይ ዳሮ ዋዬታና ኢፄታና› ያጊ ጊዲ ኦይቺስ። ");
INSERT INTO gofENT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","ሺን ታኒ ሂንቴው ኦዳይስ፤ ኤሊያሲ ዪስ፤ ቃሲ ኢያባይ ጌሻ ማፃፋን ፃፌቲዳይሳዳ፥ ኣሳይ ኢያ ቦላ ባንታ ኮዪዳባ ኦꬂዶሶና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","ዬሱሲ፥ ጴፂሮሲ፥ ያይቆቢኔ ዮሃኒሲ ሃንኮ ኢያ ታማሬታኮ ሲሚዲ ያ ዎዴ ዳሮ ኣሳይ ኤንታ ዩሹዋን ኤቂዳይሳታኔ ሂጌ ኣስታማሬ ጊዲዳ ጉꬃ ኣሳቲ ኤንታራ ፓላሜይሳ ቤዒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","ሄ ዳሮ ኣሳይ ዬሱሳ ቤዒዳ ዎዴ ማላሌቲዲ፥ ኤሌሲዲ ኢያኮ ዎፂ ዪዲ፥ ኢያ ሳሮꬂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","ዬሱሲ ባ ታማሬታኮ፥ «ኤንታራ ኣይ ፓላሜቲ?» ያጊዲ ኦይቺስ። ");
INSERT INTO gofENT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","ሄ ዳሮ ኣሳ ጊዶፌ ኢሲ ኡራይ ዛሪዲ፥ «ኣስታማሪያው፥ ታ ናዓ ቦላ ኦዴቴꬂ ዲጊያ ቱና ኣያናይ ዴዒያ ጊሾ ኢያ ኔኮ ኤካዳ ያስ። ");
INSERT INTO gofENT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","ሃ ቱና ኣያናይ ኢያ ኦይኪያ ዎዴ ኡባን፥ ኢያ ሾጪ ዬጌስ፤ ኢያ ዶናራ ጎፖንቶይ ዬስ፤ ቃሲ ኣቼ ጋርጪሴስ፤ ኣሳቴꬃካ ሚኔስ። ኢያፔ ሃ ቱና ኣያና ኬሳና ሜላ፥ ኔ ታማሬታስ ኦዳስ፥ ሺን ኬሳናው ዳንዳዒቦኮና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","ዬሱሲ ዛሪዲ ኤንታኮ፥ «ኣማኖና ሃ ዎዲያ ኣሳው! ታኒ ሂንቴራ ኣዉዴ ጋካናው ዳኔ? ቃሲ ሂንቴና ኣዉዴ ጋካናው ዳንዳዓኔ? ናዓ ታኮ ሃ ኤኪ ዪቴ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","ኤንቲ ናዓ ኢያኮ ኤሂዶሶና፤ ሄ ቱና ኣያናይ ዬሱሳ ቤዒዳ ሜላ ናዓ ኮኮርሲስ፤ ናዓይ ሳዓን ኩንዲዲ፥ ዶናራ ጎፖንቶይ ቶፉ ጊሺን ጎንዶሬቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","ዬሱሲ ሄ ናዓ ኣዋኮ፥ «ሃይሲ ኔ ናዓ ኦይኮሳፔ ኣይ ሜላ ዎዴ ጊዳኔ?» ያጊዲ ኦይቺስ። ናዓ ኣዋይ፥ «ኢ ጉꬃን ዴዒሺን ኦይኪስ። ");
INSERT INTO gofENT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","ኢያ ዎꬋናው ዳሮ ዎዴ ታማኒኔ ሃꬃን ዬጌስ፥ ሺን ኔ ዳንዳዒኮ፥ ኑስ ቃꬌታርኪ፥ ኑና ማዳርኪ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","ዬሱሲ ኢያ፥ « ‹ኔኒ ዳንዳዒኮ ጋይ?› ኣማኒያ ኦዴስካ ኡባባይ ዳንዳዔቴስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","ኤሌሲዲ ናዓ ኣዋይ ባ ቃላ ꬎቁ ኦꬂዲ፥ «ታኒ ኣማናይስ፥ ሺን ጉጃ ኣማናናዳ ታና ማዳርኪ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","ዬሱሲ ኣሳይ ዳሪ ዳሪ ቤይሳ ቤዒዲ፥ ቱና ኣያና፥ «ሃ ቱሌኔ ሙሜ ኣያናው፥ ሃ ናዓፔ ኬያ ጋዳ ኔና ታ ኪታይስ፤ ቃሲ ናምዓንꬆ ኢያን ጌሎፓ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","ሄ ቱና ኣያናይ ዋሲዲ፥ ናዓ ዳሮ ኮኮርሲዲ፥ ኢያፔ ኬዪስ። ናዓይ ሃይቂዳ ዳኒን፥ ዳሮ ኣሳይ፥ «ናዓይ ሃይቂስ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","ሺን ዬሱሲ ናዓ ኩሺያ ኦይኪዲ ዴንꬂን፥ ናዓይ ዴንዲ ኤቂስ። ");
INSERT INTO gofENT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","ዬሱሲ ሶ ጌሊዳይሳፌ ጉዬ ኢያ ታማሬቲ፥ «ኑኒ ሄ ቱና ኣያና ኬሳናው ኣይስ ዳንዳዒቦኮ?» ያጊዲ ዬሱሳ ዱማ ኦይቺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","ዬሱሲ ዛሪዲ፥ «ሄሳ ሜላይ ዎሳፔኔ ፆማፔ ኣቲን ሃራባን ኬያናው ዳንዳዔና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","ኤንቲ ሄ ቤሳፌ ዴንዲዲ፥ ጋሊላራ ኣꬊዲ ቢዶሶና፤ ዬሱሲ ባ ዴዒያሱዋ ኦኒካ ኤራና ሜላ ኮዪቤና። ");
INSERT INTO gofENT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ኢ ባ ታማሬታኮ፥ «ኣሳ ናዓ፥ ኣሲ ኣሳስ ኣꬂ ኢማናኔ ዎꬋና፤ ኢ ሄꬑ ጋላሳፔ ጉዬ፥ ሃይቆፔ ዴንዳና» ያጊዲ ታማርሴስ። ");
INSERT INTO gofENT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","ሺን ኤንታው ኢ ጌይሲ ጌሊቤና፤ ቃሲ ኢያ ኦይቻናዉካ ያዪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","ኤንቲ ቂፊርናሆሜ ካታማ ቢዲ ሶ ጌሊዳይሳፌ ጉዬ ዬሱሲ ኤንታኮ፥ «ኦጌን ኣይ ኦዴቴቲ?» ያጊዲ ኦይቺስ። ");
INSERT INTO gofENT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","ሺን ኤንቲ፥ «ኑ ጊዶን ኡባፌ ኣꬋናይ ኦኔ?» ያጊዲ ፓላሚዳ ጊሾ ሲዒ ጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","ዬሱሲ ኡቲዲ፥ ታማኔ ናምዑ ታማሬታ ፄጊዲ፥ «ኦኒካ ሲንꬄ ኣꬋናው ኮይኮ፥ ኡባፌ ጉዬ ኣꬊዲ፥ ኡባስ ኣይሌ ጊዳናው ቤሴስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","ኢሲ ጉꬃ ናዓ ኤኪዲ፥ ኤንታ ጊዶን ኤሲስ፤ ሄ ጉꬃ ናዓ ኢዲሚዲ ኤንታኮ፥ ");
INSERT INTO gofENT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«ሃይሳ ሜላ ጉꬃ ናይታፔ ኢሱዋ ታ ሱንꬃን ሞኪያ ኦኒካ ታና ሞኬስ፤ ቃሲ ታና ሞኪያ ኦኒካ ታና ኪቲዳይሳካ ሞኬሲፔ ኣቲን ታ ፃላላ ሞኬና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","ዮሃኒሲ፥ «ኣስታማሪያው፥ ኢሲ ኣሲ ኔ ሱንꬃን ቱና ኣያናታ ኬሲሺን ኑኒ ቤዒዲ፥ ኑ ባጋ ጊዶና ጊሾ ኢያ ዲጊዳ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","ሺን ዬሱሲ፥ «ኦኒካ ታ ሱንꬃን ፆሳይ ኦꬂያ ማላታታ ኦꬂዲ፥ ኤሌሲዲ ታ ቦላ ኢታባ ኦዴታናው ዳንዳዔይ ባይና ጊሾ ዲጎፊቴ። ");
INSERT INTO gofENT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","ኑባ ኢፆና ኡራይ ኑ ባጋ። ");
INSERT INTO gofENT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","ታኒ ሂንቴው ቱማ ኦዳይስ፤ ሂንቴ ታይሳታ ጊዲያ ጊሾ ኦኒካ ሂንቴው ታ ሱንꬃን ሃሎ ሃꬂ ኡያናው ኢሚኮካ፥ ባ ዎይቱዋ ኤካና። ");
INSERT INTO gofENT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","«ታና ኣማኒያ ሃ ጉꬃታፔ ኢሱዋ ባሌꬂያ ኦኒካ፥ ጋቻ ዎጋ ዎፃ ባ ቆꬌን ቃቺዲ፥ ኣባን ዉሊያኮ ኢያው ሎዖ። ");
INSERT INTO gofENT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","ኔ ኩሼይ ኔና ባሌꬂኮ፥ ቃንፃ ሆላ። ኔኒ ናምዑ ኩሼራ ቶዖና ጋናሜ ታማን ዬጌቴይሳፌ፥ ዱፃ ኩሼራ ዴዑዋ ጌሎይ ኔው ሎዖ። ");
INSERT INTO gofENT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","ኔ ቶሆይ ኔና ባሌꬂኮ፥ ቃንፃ ሆላ። ኔኒ ናምዑ ቶሁዋራ ጋናሜ ታማን ዬጌቴይሳፌ፥ ዎቤ ጊዳዳ ዴዑዋ ጌሌይሲ ኔው ሎዖ። ");
INSERT INTO gofENT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","ኔ ኣይፌይ ኔና ባሌꬂኮ፥ ዎጫ ኬሳ ሆላ። ኔኒ ናምዑ ኣይፊያራ ጋናሜ ታማን ዬጌቴይሳፌ፥ ኢሲ ኣይፊያራ ፆሳ ካዎቴꬃ ጌሌይሲ ኔው ሎዖ። ");
INSERT INTO gofENT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","ያን ኤንታ ሚያ ጉፁኔይ ሃይቄና፥ ታማይካ ቶዔና። ");
INSERT INTO gofENT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","«ያርሾይ ማፂኔን ጌዬይሳ ሜላ ኣሲ ኡባይ ታማን ሃርቄታና። ");
INSERT INTO gofENT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","ማፂኔይ ሎዖ፥ ሺን ኢ ማልዖና ኢፂኮ፥ ዛሪዲ ዋቲ ማልዔꬃኔ? ሂንቴናን ማፂኔይ ዴዖ። ያኒዲ ኢሶይ ኢሱዋራ ሳሮቴꬃን ዴዒቴ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","ዬሱሲ ሄሳፌ ዴንዲዲ፥ ዪሁዳ ቢታ ቢዲ ዮርዳኖሴ ሻፋ ፒኒስ። ዳሮ ኣሳይ ዛሪዲ ኢያኮ ሺቂን፥ ካሴይሳዳካ ሄ ኣሳ ታማርሲስ። ");
INSERT INTO gofENT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","ኢሲ ኢሲ ፋሪሳዌቲ ፓጫናው ኮዪዲ ዬሱሳ፥ «ኢሲ ኣሲ ባ ማቺው ዬዳና ሜላ ሙሴ ሂጌይ ኪቲ?» ያጊዲ ኢያ ኦይቺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","ኢ ዛሪዲ፥ «ሙሴይ ሂንቴና ዎይጊዲ ኪቲዴ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","ኤንቲ፥ «ሙሴይ፥ ‹ኢሲ ኣሲ ባ ማቼስ ኣንጆ ዎርቃቴ ኢሚዲ ዬዶ› ጊስ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","ዬሱሲ ዛሪዲ፥ ኤንታ «ሂንቴ ኦዲን ሲዖናይሳታ ጊዲያ ጊሾ ሙሴይ ሃ ኪታ ሂንቴው ፃፊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","ሺን ፆሳይ ኮይሮ ሜꬊያ ዎዴ ኣዴኔ ማጫ ኦꬂዲ፥ ኤንታ ሜꬊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","ሄሳ ጊሾ፥ ኢሲ ኣሲ ባ ኣዋኔ ባ ኣዪው ኣጊዲ፥ ባ ማቼራ ኢሲፌ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ኤንቲ ናምዓይ ኢሲ ኣሴ ጊዶሶና፤ ሂዛፔ፥ ኤንቲ ኢሲ ኣሴ ጊዶሶናፔ ኣቲን ናምዑ ኣሲ ጊዶኮና። ");
INSERT INTO gofENT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","ሄሳ ጊሾ፥ ፆሳይ ኢሲፌ ቃቺዳይሳ ኣሲ ሻኮፎ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","ኤንቲ ሶ ሲሚዳ ዎዴ ኢያ ታማሬቲ ሃ ኦዳባ ዬሱሳ ናምዓንꬆ ኦይቺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","ዬሱሲ ኤንታኮ፥ «ባ ማቺው ዬዲዲ ሃራ ኤኪያ ኦኒካ ላይማቴስ። ");
INSERT INTO gofENT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","ቃሲ ማጫሲያካ ባ ኣዚናፔ ኬያዳ ሃራ ኣዚና ጌሊኮ ላይማታዉሱ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","ዬሱሲ ጉꬃ ናይታ ቦቻና ሜላ፥ ኢሲ ኢሲ ኣሳይ ናይታ ኢያኮ ኤሆሶና፥ ሺን ኢያ ታማሬቲ ሄ ኣሳ ሃንቄቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","ዬሱሲ ሄሳ ቤዒዲ፥ ባ ታማሬታ ሃንቄቲዲ፤ ኤንታኮ፥ «ጉꬃ ናይቲ ታኮ ዬይሳ ዲጎፊቴ፤ ፆሳ ካዎቴꬃይ ሃይሳታ ሜላሳ። ");
INSERT INTO gofENT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","ታኒ ሂንቴው ቱማ ኦዳይስ፤ ፆሳ ካዎቴꬃ ጉꬃ ናዓዳ ኤኮና ኡራይ ኦኒካ ሄ ካዎቴꬃ ኡባራካ ጌሌና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","ጉꬃ ናይታ ኢዲሚዲ፥ ባ ኩሺያ ኤንታ ኢሱዋ ኢሱዋ ቦላ ዎꬂዲ ኣንጂስ። ");
INSERT INTO gofENT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","ዬሱሲ ባናው ኬዪዳ ዎዴ ኢሲ ኡራይ ዎፂ ዪዲ፥ ኢያ ሲንꬃን ጉልባቲዲ፥ «ኬሃ ኣስታማሪያው፥ ሜሪና ዴዑዋ ላታናው ታኒ ኣይ ኦꬆ?» ያጊዲ ኦይቺስ። ");
INSERT INTO gofENT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","ዬሱሲ፥ «ኣይስ ታና ኬሃው ጋዳ ፄጋይ? ፆሳ ፃላላፔ ኣቲን ሃሪ ኬሂ ኦኒካ ባዋ። ");
INSERT INTO gofENT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","ፆሳ ኪታ፥ ዎꬎፓ፤ ላይማቶፓ፤ ካይሶቶፓ፤ ዎርዶ ማርካቶፋ፤ ኢንፃርሳን ጪሞፋ፤ ኔ ኣዋኔ ኔ ኣዪው ቦንቻ ያጌይሳ ኤራሳ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","ኡራይ፥ «ኣስታማሪያው፥ ታኒ ሄሳ ኡባ ናዓቴꬃፌ ዶማዳ ሃዒ ጋካናው ናጋይስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","ዬሱሲ ኡራ ቲሺ ኦꬂ ፄሊዲ ዶሲስ፤ «ኔው ኢሲባይ ፓጬስ፤ ባዳ ኔው ዴዒያባ ኡባ ባይዛዳ፥ ሄ ሚሺያ ማንቆታስ ኢማ፤ ኔኒ ሳሎን ዱሬታና። ያታ ሲማዳ ታና ካላ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","ሺን ኡራይ ሄሳ ሲዒዲ፥ ኢ ዳሮ ዱሬ ጊዲያ ጊሾ ባ ሶምዑዋ ካሬꬂስ፥ ኡፋይቶና ኣጊዲ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","ዬሱሲ ባ ታማሬታ ዩሺ ኣꬂ ፄሊዲ፥ «ዱሬ ኣሲ ፆሳ ካዎቴꬃ ጌላናይሲ ዋኒዲ ሜታንዴሻ!» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","ኢያ ታማሬቲ ኢያ ቲሚርቲያ ሲዒዲ ማላሌቲዶሶና። ሺን ዬሱሲ ቃሲካ ኤንታኮ፥ «ናይቶ፥ ፆሳ ካዎቴꬃ ጌላናይሲ ዋኒዲ ሜታንዴሻ! ");
INSERT INTO gofENT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","ዱሬ ኣሲ ፆሳ ካዎቴꬃ ጌላናይሳፌ፥ ጊማሌይ ናርፔ ሉሆራ ኣꬌይሲ ካዉዬስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","ኢያ ታማሬቲ ማላሌቲዲ፥ «ያቲን፥ ኦኒ ኣታኔ?» ያጊዲ፥ ኢሶይ ኢሱዋ ኦይቺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","ዬሱሲ ኤንታ ቲሺ ኦꬂ ፄሊዲ፥ «ሃይሲ ፆሳስ ዳንዳዔቴስፔ ኣቲን ኣሳስ ዳንዳዔቴና፤ ፆሳስ ኡባባይ ዳንዳዔቴስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","ጴፂሮሲ ዬሱሳኮ፥ «ሄኮ፤ ኑኒ ኑባ ኡባ ኣጊዲ፥ ኔና ካሊዳ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","ዬሱሲ «ታኒ ሂንቴው ቱማ ኦዳይስ፤ ታ ጊሾኔ ዎንጌላ ጊሾ ኬꬃ ዎይኮ ኢሻታ ዎይኮ ሚቼታ ዎይኮ ኣዋ ዎይኮ ኣዪው ዎይኮ ማቺው ዎይኮ ናይታ ዎይኮ ጋዲያ ኣጊዳይ ኦኒካ፥ ");
INSERT INTO gofENT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ሃዒ ሃ ዎዲያን ፄቱ ኩሼ ኬꬃ፥ ኢሻታ፥ ሚቼታ፥ ኣዬታ፥ ናይታ፥ ጋዲያ፥ ጎዴቴꬃራ ኢሲፌ ኤካና። ሲንꬃፌ ያና ዎዲያንካ ሜሪና ዴዑዋ ኤካና። ");
INSERT INTO gofENT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","ሺን ዳሮቲ ሃዒ ዴꬃን ሲንꬄ ጊዲዳይሳቲ ጉዬ ጊዳና፥ ቃሲ ዳሮቲ ሃዒ ጉዬ ጊዲዳይሳቲ ሲንꬄ ጊዳና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","ዬሱሳራኔ ኢያ ታማሬታራ ዬሩሳላሜ ቢሺን፥ ዬሱሲ ባ ታማሬታ ሲንꬃን ሃሙቴስ። ኤንቲ ማላሌቲዶሶና። ኢያ ካሌይሳቲካ ያዪዶሶና። ናምዓንꬆ፥ ታማኔ ናምዑ ታማሬታ ጋፃ ኬሲዲ፥ ባና ጋካናባ ዱማ ኤንታው ሃይሳዳ ያጊዲ ኦዲስ። ");
INSERT INTO gofENT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","«ሄኮ፥ ኑኒ ዬሩሳላሜ ሃዒ ኬዮስ። ያን ኣሳ ናዓይ፥ ካሂኔ ሃላቃታሲኔ ሂጌ ኣስታማሬታስ ኣꬂ ኢሜታና። ኤንቲ ኢያ ቦላ ሃይቆ ፒርዳ ፒርዳና፤ ቃሲ ኣይሁዴ ጊዶና ዴሪያስ ኢያ ኣꬂ ኢማና። ");
INSERT INTO gofENT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ሄ ኣይሁዴ ጊዶና ዴሬይ ኢያ ቶቻና፥ ኢያ ቦላ ጩታና፥ ሊሶን ጋራፋናኔ ዎꬋና። ኢ ሄꬑ ጋላሳፔ ጉዬ፥ ሃይቆፔ ዴንዳና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","ዛብዲዮሳ ናይቲ ያይቆቢኔ ዮሃኒሲ ዬሱሳኮ ዪዲ፥ «ኣስታማሪያው፥ ኑኒ ኔና ዎሲያ ኢሲባ ኑስ ኦꬃርኪ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","ዬሱሲ ኤንታኮ፥ «ታኒ ሂንቴው ኣይ ኦꬆ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","ኤንቲ፥ «ኔኒ ኔ ቦንቾ ካዎቴꬃን ኡቲያ ዎዴ ኑፔ ኢሱዋ ኡሻቻ ባጋራ ቃሲ ኢሱዋ ሃዲርሳ ባጋራ ኡቲሳርኪ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","ሺን ዬሱሲ ኤንታኮ፥ «ሂንቴ ኣይ ዎሲያኮ ኤሬኬታ፥ ታ ኡያናው ዴዒያ ፁዓ ኡያናው ዳንዳዔቲ? ቃሲ ታኒ ፃማቄታናው ዴዒያ ፂንቃቲያ ፃማቄታናው ዳንዳዔቲ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","ኤንቲ ዛሪዲ፥ «ኤ ዳንዳዖስ» ያጊዶሶና። ዬሱሲ ቃሲ፥ «ቱማካ ታ ኡያናው ዴዒያ ፁዓ ሂንቴ ኡያና፥ ታኒ ፃማቄታናው ዴዒያ ፂንቃቲያ ሂንቴ ፃማቄታና። ");
INSERT INTO gofENT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ሺን ታፔ ኡሻቻ ባጋራኔ ሃዲርሳ ባጋራ ኡታናይሳታ ዶራናው ታው ማቲ ባዋ፥ ሺን ሄ ቤሳይ ፆሳይ ኢማናው ጊጊሲ ዎꬂዳይሳታሳ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","ሃንኮ ታሙ ታማሬቲ ሄሳ ሲዒዳ ዎዴ ያይቆባኔ ዮሃኒሳ ሃንቄቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","ዬሱሲ ኤንታ ኡባ ባኮ ፄጊዲ፥ «ኣይሁዴ ጊዶና ኣሳ ሃላቃቲ ዴሪያ ሃሬይሳታ ጌቴቲዲ ፄጌቴይሳኔ ሃሬይሳታስ ዴሪያ ቦላ ማቲ ዴዔይሳ ሂንቴ ኤሬታ። ");
INSERT INTO gofENT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","ሺን ሂንቴ ጊዶን ሄሳ ሜላ ጊዴና፤ ሂንቴ ጊዶን ጊታታናው ኮዬይ ኦኒካ ሂንቴው ኣይሌ ጊዳናው ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ቃሲ ሂንቴ ጊዶን ኡባፌ ቦላ ጊዳናው ኮዬይ ኦኒካ ሂንቴ ኡባስ ኣይሌ ጊዳናው ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","ሃሪ ኣቶሺን፥ ኣሳ ናዓይካ፥ ኣሳስ ኦꬃናዉኔ ዳሮታ ዎዛናው ባ ሼምፑዋ ኣꬂ ኢማናው ዪሲፔ ኣቲን ኣሲ ኢያው ኦꬃና ሜላ ዪቤና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","ኤንቲ ኢያርኮ ካታማ ቢዶሶና። ዬሱሲ ባ ታማሬታራኔ ዳሮ ኣሳራ ኢያርኮፌ ኬዪሺን፥ ፂሞሳ ናዓይ፥ ቆቄይ፥ ባርፂሞሳ ጌቴቴይሲ፥ ኦጌ ጋፃን ዎሲሼ ኡቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","ባርፂሞሲ፥ ያራ ኣꬌይ ናዚሬቴ ዬሱሳ ጊዲዳይሳ ሲዒዳ ዎዴ ባ ቃላ ꬎቁ ኦꬂዲ፥ «ዳዊቴ ናዓ ዬሱሳ፥ ታና ማራርኪ!» ያጉሱ ኦይኪስ። ");
INSERT INTO gofENT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","ዳሮ ኣሳይ ኢያ፥ «ሃይዛ!» ጊዲ ሃንቄቲዶሶና። ሺን፥ ኢ ባ ቃላ ካሴይሳፌ ዳሮ ꬎቁ ኦꬂዲ፥ «ዳዊቴ ናዓው፥ ታና ማራርኪ!» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","ዬሱሲ ኤቂዲ፥ «ኢያ ሃ ፄጊቴ» ያጊስ። ኤንቲ ቆቂያኮ፥ «ኣይኮይ ባዋ፥ ዴንዳ ኤቃ፥ ኔና ፄጌስ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","ቆቄይ ባ ማዑዋ ሆሊ ዬጊዲ፥ ጉፒ ዴንዲ ኤቂዲ፥ ዬሱሳኮ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","ዬሱሲ፥ «ታኒ ኔው ኣይ ኦꬃና ሜላ ኮያይ?» ያጊስ። ቆቄይ፥ «ኣስታማሪያው፥ ታ ፄላናው ኮያይስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","ዬሱሲ ኢያ፥ «ባ፥ ኔ ኣማኖይ ኔና ፓꬂስ» ያጊስ። ሶሁዋራካ ኢያ ኣይፌይ ፄሊን፥ ዬሱሳ ካሊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","ኤንቲ ዬሩሳላሜ ማቲሼ፥ ሻማሆ ዴሪያ ማታን ዴዒያ ቤቴፋጌኔ ቢታኒያ ካታማታ ጋኪዶሶና። ዬሱሲ ባ ታማሬታፔ ናምዓታ ሲንꬄ ኪቲዲ፥ ");
INSERT INTO gofENT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","«ሂንቴፌ ሲንꬃን ዴዒያ ጉታ ቢቴ፤ ያ ጌሊዳ ሜላ ኦኒካ ቶጊቦና ቃሾን ዴዒያ ሃሬ ማሪ ሂንቴ ዴማና፥ ኢያ ቢሊዲ፥ ሃ ኤኪ ዪቴ። ");
INSERT INTO gofENT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","ኦኒካ ሂንቴና፥ ‹ሃይሳ ኣይስ ኦꬄቲ?› ያጊዲ ኦይቺኮ፥ ‹ጎዳይ ኢያ ኮዬስ፥ ኤሌሲዲ ሃ ዬዳና› ያጊቴ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","ኤንቲ ቢዲ፥ ሃሬ ማሪ ካሬ ቦላ ኦጌ ማታን ቃሼቲዲ ዴዔይሳ ዴሚዲ ቢሊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ሄ ቤሳን ኤቂዳ ኢሲ ኢሲ ኣሳቲ ኤንታኮ፥ «ሃሬ ማራ ዋታናው ቢሌቲ?» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","ኢያ ታማሬቲ ዬሱሲ ባንታና ኪቲዳይሳ ኦዲን፥ ኣሳቲ ዬዲ ኣጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","ኤንቲ ሃሬ ማራ ዬሱሳኮ ኤሂዲ፥ ባንታ ማዑዋ ኢያ ዞኮን ሂፂን ዬሱሲ ሄ ሃሬ ማራ ቶጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","ዳሮ ኣሳይ ባንታ ማዑዋ ኦጊያን ሂፂዶሶና፤ ቃሲ ሃራቲ ሚꬃ ታሼ ታሺዲ፥ ኦጌን ሂፂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","ዬሱሳፔ ሲንꬃራ ሃሙቲያ ኣሳይኔ ኢያ ካሊያ ኣሳይ ባንታ ቃላ ꬎቁ ኦꬂዲ፥ «ሆሳና! ፆሳይ ጋላቴቶ! ጎዳ ሱንꬃን ዬይሲ ኣንጄቲዳይሳ። ");
INSERT INTO gofENT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","ጎዳ ሱንꬃን ያ ኑ ኣዋ ዳዊቴ ካዎቴꬃይ ኣንጄቲዳይሳ። ኡባፌ ቦላ ሳሉዋን ዴዒያ ፆሳይ ጋላቴቶ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","ዬሱሲ ዬሩሳላሜ ቢዲ፥ ፆሳ ኬꬃ ጌሊስ። ቃሲ ኡባባ ዩዪ ፄሊዳፔ ጉዬ፥ ሳዓይ ቃሚያ ጊሾ ታማኔ ናምዑ ታማሬታራ ቢታኒያ ካታማ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","ዎንቴꬃ ጋላስ ኤንቲ ቢታኒያፔ ኬዪዲ ቢሺን፥ ዬሱሲ ኮሻቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","ሃሆን ኢሲ ባላሴ ሚꬂው ሃይꬃ ፃላላ ማዓ ኡቲዳሮ ቤዒዲ፥ ኢ ቦላ ኣይፌይ ቤቲኮ ጊዲ፥ ቤዓናው ኢኮ ቢስ፥ ሺን ኢኮ ኢ ቢያ ዎዴ ሃይꬃ ፃላላፔ ኣቲን ኢሲ ኣይፌካ ዴሚቤና፤ ኣይስ ጊኮ፥ ባላሴይ ኣይፊያ ዎዴይ ጋኪቤና። ");
INSERT INTO gofENT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","ዬሱሲ ሄ ባላሲው፥ «ሂዛ፥ ኔፔ ሜሪናው ኣሲ ኣይፌ ሞፖ» ያጊስ። ኢያ ታማሬቲ ኢ ጌይሳ ሲዒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","ኤንቲ ዬሩሳላሜ ቢዶሶና፤ ዬሱሲ ፆሳ ኬꬃ ጌሊዲ፥ ያን ባይዜይሳታኔ ሻሜይሳታ ካሬ ጎዶ ኦይኪስ፤ ቃሲ ሚሼ ላሜይሳታ ፃርጴዛኔ ሆሌ ባይዜይሳታ ኦይዲያ ኣꬂ ዬጊዲ፥ ");
INSERT INTO gofENT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","ኣሲ ኣይቢባካ ቶኪዲ፥ ፆሳ ኬꬃ ጊዶራ ኣꬎና ሜላ ዲጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","ዬሱሲ ኣሳ ሃይሳዳ ያጊዲ ታማርሲስ፡ «ጌሻ ማፃፋን፥ ‹ታ ኬꬃይ ኣሲ ኡባይ ፆሳ ዎሲያ ኬꬂ ጊዳና› ጌቴቲዲ ፃፌቲስ። ሺን ሂንቴ ኢያ ፓንጋቲ ቆሴቲያ ጎንጎሎ ኦꬂዴታ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","ካሂኔ ሃላቃቲኔ ሂጌ ኣስታማሬቲ ሄሳ ሲዒዲ፥ ኢያ ዎꬋናው ኦጌ ኮሺ ኦይኪዶሶና። ሺን ዳሮ ኣሳይ ኢያ ቲሚርቲያን ማላሌቲያ ጊሾ ኢያው ያዪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","ሳዓይ ኦማርሲያ ዎዴ ዬሱሲኔ ኢያ ታማሬቲ ካታማፔ ጋፃ ኬዪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","ኤንቲ ዎንቴꬃ ጋላስ ሄ ኦጊያራ ኣꬊሼ፥ ሄ ባላሲያ ፃጶራ ሜሊዳሮ ቤዒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","ጴፂሮሲ ኣኬኪዲ፥ «ኣስታማሪያው፥ ሄኮ፥ ኔኒ ቃንጊዳ ባላሲያ ሜላሱ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","ዬሱሲ ዛሪዲ፥ «ፆሳ ኣማኒቴ። ");
INSERT INTO gofENT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","ታኒ ሂንቴው ቱማ ኦዳይስ፤ ኦኒካ ባ ዎዛናን ሲꬎና ጊዳባይ ሃናናይሳ ኣማኒዲ፥ ሃ ዴሪያ፥ ‹ዴንዳዳ ኣባን ኩንዳ› ያጊኮ ኢያው ሃናና። ");
INSERT INTO gofENT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","ሄሳ ጊሾ፥ ታኒ ሂንቴው ኦዳይስ፤ ፆሳ ሂንቴ ዎሲያባኔ ኦይቺያባ ኣይባ ጊዲኮካ ኤኪዳዳ ኣማኒቴ፥ ሂንቴ ኤካና። ");
INSERT INTO gofENT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","ፆሳ ዎሳናው ሂንቴ ኤቂያ ዎዴ ሳሎን ዴዒያ ሂንቴ ኣዋይ ሂንቴ ናጋራ ኣቶ ጋና ሜላ፥ ኦኒካ ሂንቴና ናቂዳባይ ዴዒኮ፥ ኢያው ኣቶ ጊቴ። ");
INSERT INTO gofENT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","ሺን ኣሳ ናጋራ ሂንቴ ኣቶ ጎና ኢፂኮ፥ ሳሎን ዴዒያ ሂንቴ ኣዋይካ ሂንቴ ናጋራ ሂንቴው ኣቶ ጌና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","ኤንቲ ዛሪዲ ዬሩሳላሜ ቢዶሶና። ዬሱሲ ፆሳ ኬꬃን ሃሙቲሺን፥ ካሂኔ ሃላቃቲ፥ ሂጌ ኣስታማሬቲኔ ጪማቲ ኢያኮ ዪዲ፥ ");
INSERT INTO gofENT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","«ኔኒ ሃይሳ ኦꬃናው ኔው ኣይ ማቲ ዴዒ? ዎይኮ ኔው ሃ ማታ ኢሚዳይ ኦኔ?» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","ዬሱሲ ዛሪዲ ኤንታኮ፥ «ታ ሂንቴና ኢሲባ ኦይቻና፥ ታው ኦዲቴ። ታ ቃሲ ሃይሳ ኣይ ማታን ኦꬂያኮ፥ ሂንቴው ኦዳና። ");
INSERT INTO gofENT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","ዮሃኒሳ ፂንቃቴይ ፆሳፌዬ ዎይኮ ኣሳፔ? ታው ኦዲቴ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","ኤንቲ ባንታ ጊዶን ፓላማ ዶሚዲ፥ «ኑኒ፥ ‹ፆሳፌ› ጊኮ፥ ኢ ኑኮ፥ ‹ያቲን፥ ዮሃኒሲ ኦዲዳይሳ ኣይስ ኣማኒቤኬቲ?› ያጋና። ");
INSERT INTO gofENT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","‹ኣሳፔ ጊኮ› ኣሳ ኡባይ ዮሃኒሲ ናቤ ጊዴይሳ ኤሮሶና።» ያኒያ ጊሾ ኣሳስ ያዪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","ሄሳ ጊሾ፥ ኤንቲ ዬሱሳኮ፥ «ኑኒ ኤሮኮ» ያጊዲ ዛሪዶሶና፤ ዬሱሲ፥ «ታኒካ ሃይሳ ኣይ ማታን ኦꬂያኮ፥ ሂንቴው ኦዲኬ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","ዬሱሲ ኤንታው ሌሚሶን ያጊዲ ኦዲስ፤ «ኢሲ ኡራይ ዎይኔ ኣታኪልቴ ቶኪዲ፥ ዩሺ ኣꬂዲ ዲርሲ ዲሪስ። ቃሲ ሄ ዎይኒያ ጉምዒያ ኦላካ ቦኪስ። ኢያ ናጋናው ኣዱሳ ሻኮ ሻኪስ። ሄሳፌ ጉዬ፥ ኮꬄ ኦꬂያ ኣሳስ ኢሚዲ፥ ሃራ ቢታ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","ዎይኔ ኣይፊያ ማፂያ ዎዴይ ጋኪን፥ ባና ጋኬይሳ ኤኪዲ ያና ሜላ፥ ኢሲ ባ ኣይሊያ ኮꬄ ኣዋታኮ ኪቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","ኮꬄ ኣዋቲ ኢያ ኣይሊያ ኦይኪዲ ዋꬊዲ፥ ሜላ ኩሼ ዬዲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","ናምዓንꬆ ሃራ ኣይሌ ኤንታኮ ኪቲን፥ ኤንቲ ሄ ኣይሊያስ ሁዒያ ቆዒዲ ካዉሺዲ ዬዲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","ዎይኔ ኣታኪልቲያ ጎዳይ ቃሲካ ሃራ ኣይሌ ኪቲስ። ሄ ኣይሊያ ዎꬊዶሶና፥ ቃሲ ሃራ ዳሮታ ሄሳዳ ኦꬂዶሶና፥ ኢሶታ ኢሶታ ዋꬊዲ፥ ሃራታ ዎꬊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","«ዎይኔ ኣታኪልቲያ ጎዳስ ኪታናው ኡባፌ ዉርሴꬃን ኢ ዳሮ ዶሲያ ባ ናዓ ፃላሊ ኣቲስ። ኢ፥ «ኤንቲ ታ ናዓ ቦንቾና ኣጎኮና» ጊዲ፥ ባ ናዓ ኤንታኮ ኪቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","«ሺን ኮꬄ ኣዋቲ ባንታ ጊዶን፥ ‹ላታናይሲ ሃይሳ፤ ዬꬊቴ ኢያ ዎꬎስ፤ ኢያ ላታይ ኑባ ጊዳና!› ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","ናዓ ኦይኪዲ ዎꬊዲ፥ ኢያ ኣሃ ዎይኔ ኣታኪልቲያ ጊዶፌ ጋፃ ኬሲ ሆሊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","«ሂዛ፥ ዎይኔ ኣታኪልቲያ ጎዳይ ዋታኔ? ዪዲ ሄ ኮꬄ ኣዋታ ዎꬊ ኦንጊዲ፥ ዎይኒያ ኮꬄ ኦꬂያ ሃራ ኣሳስ ኢማና። ");
INSERT INTO gofENT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","11","‹ጊምቤይሳቲ ቦሪዲ ኢፂዳ ሹቻይ ጎዳ ፃጱዋ ሚንꬂያ፥ ኡባፌ ኣꬊያ ሹቹ ጊዲስ። ሃይሲ ጎዳይ ኦꬂዳባ፤ ቃሲ ኑ ኣይፊያስካ ማላሊሲያባ› ያጌይሳ ጌሻ ማፃፋፔ ናባቢቤኬቲ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","ካሂኔ ሃላቃቲ፥ ሂጌ ኣስታማሬቲኔ ጪማቲ ዬሱሲ ሄ ሌሚሱዋ ባንታ ቦላ ሌሚሲዳይሳ ኤሪዳ ጊሾ ኢያ ኦይካናው ኮዪዶሶና፥ ሺን ኣሳስ ያዪዲ፥ ኣጊ ቢዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","ቃሲ ኢያ ኦዳፔ ባላ ዴሚዲ፥ ኢያ ኦይካና ሜላ፥ ፋሪሳዌታፔኔ ሄሮዲሳ ባጋታፔ ጉꬃ ኣሳታ ኢያኮ ኪቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","ኤንቲ ኢያኮ ዪዲ፥ «ኣስታማሪያው፥ ኔኒ ቱማ ኦዴቴይሳኔ ኣሳፔ ኣሴ ሻኮናይሳ ኑኒ ኤሮስ። ኔኒ ኣሴ ዱማያካ፤ ቃሲ ፆሳ ኦጊያ ቱማቴꬃን ታማርሳሳ። ኑኒ ሮሜ ቢታ ካዉዋ ቄሳሬስ ጊራ ጊሬይሲ ዎጌዬ ዎጋ ጊዴኔ? ጊራ ጊራኔ ኣጋኔ?» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","ሺን ኤንታ ጩቦቴꬃ ዬሱሲ ኤሪዲ፥ «ታና ኣይስ ፓጬቲ? ኣኔ ኢሲ ሳንቲሜ ታና ቤሲቴ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","ኤንቲ ኢያው ኤሂዶሶና፥ «ሃ ማላይኔ ሱንꬃይ ኦዴይሴ?» ያጊዲ ኤንታ ኦይቺስ። ኤንቲ፥ «ሮሜ ካዉዋ ቄሳሬይሳ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","ዬሱሲ ዛሪዲ፥ «ያቲኮ፥ ቄሳሬይሳ ቄሳሬስ፥ ፆሳይሳ ፆሳስ ኢሚቴ» ያጊን ኤንቲ ኢያባ ማላሌቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","ሃይቂዳ ኣሲ ዴንዴና ጊያ ሳዱቃዌታፔ ኢሲ ኢሲ ኣሳቲ ዬሱሳኮ ዪዲ፥ ሃይሳዳ ያጊዲ፥ ኢያ ኦይቺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«ኣስታማሪያው፥ ሙሴይ ኑስ ሂጊያ ፃፊሼ፥ ‹ማቾ ኤኪዳ ኣሲ ናዓ ዬሎና ሃይቂኮ፥ ሄ ሃይቂዳይሳ ኢሻይ ኢያ ማቺው ኤኪዲ፥ ባ ኢሻስ ናዓ ዬላናው ቤሴስ› ያጌይሳ ፃፊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","ቤኒ ዎዴ ላፑን ኢሻቲ ዴዔይሳታፔ ባይራይ ማቾ ኤኪዲ፥ ናዓ ዬሎና ሃይቂስ። ");
INSERT INTO gofENT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","ናምዓንꬆይ ኢዮ ኤኪስ፥ ኢካ ናዓ ዬሎና ሃይቂስ። ሄꬓንꬆይካ ሄሳዳ ሃኒስ። ");
INSERT INTO gofENT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ላፑናቲካ ሄሳꬆ ኢዮ ኤኪዲ፥ ናዓ ዬሎና ሃይቂዶሶና። ኡባፌ ጉዬ፥ ቃሲ ሄ ማጫሲያ ሃይቃሱ። ");
INSERT INTO gofENT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","ያቲን፥ ላፑናቲ ኢዮ ኤኪዳ ጊሾ ሃይቂዳ ኣሳይ ሃይቆፔ ዴንዲያ ጋላስ፥ ኢያ ኤንታፌ ኣዉሳስ ማቾ ጊዳኔ?» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","ዬሱሲ ዛሪዲ፥ «ሂንቴ ባሌይ፥ ጌሻ ማፃፋታ ዎይኮ ፆሳ ዎልቃ ኤሮና ጊሾሳ! ");
INSERT INTO gofENT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","ሃይቂዳ ኣሳይ ሃይቆፔ ዴንዲያ ጋላስ፥ ሳሎን ዴዒያ ኪታንቾታ ሜላ ጊዳናፔ ኣቲን ኣዴ ኣሳይ ኤኮኮና፤ ማጫ ኣሳይ ጌሌኮና። ");
INSERT INTO gofENT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","ሺን ሃይቂዳይሳታ ዴንዱዋባ ጊዲኮ፥ ሙሴ ማፃፋን ፃፌቲዳ ፁጌቲያ ቡሪያባ ኦዲያ ቤሳን፥ ፆሳይ ሙሴኮ፥ ‹ታኒ፥ ኣብራሃሜ ፆሳ፥ ዪሳቃ ፆሳ፥ ያይቆባ ፆሳ› ጊዳይሳ ናባቢቤኬቲ? ");
INSERT INTO gofENT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","ሄሳ ጊሾ፥ ኢ፥ ፓፃ ዴዔይሳታ ፆሳፌ ኣቲን ሃይቂዳይሳታ ፆሴ ጊዴና። ሂንቴ ዳሮ ባሊዴታ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","ሂጌ ኣስታማሬታፔ ኢሶይ ኤንቲ ፓላሜይሳ ሺቂዲ ሲዒስ። ቃሲ ዬሱሲ ኤንታው ሎይꬂ ዛሪዳይሳ ሲዒዲ፥ «ኪታ ኡባፌ ኣꬊያ ኪታይ ኣዉሴ?» ያጊዲ ዬሱሳ ኦይቺስ። ");
INSERT INTO gofENT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","ዬሱሲ ዛሪዲ፥ ኢያ ሃይሳዳ ያጊስ፡ «ኪታ ኡባፌ ኣꬊያ ኪታ ሲዒቴ፤ ‹ኢስራዔሌ ኣሳው፥ ጎዳይ ኑ ፆሳይ ኢሲ ጎዳ። ");
INSERT INTO gofENT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","ኔ ጎዳ ኔ ፆሳ ኔ ኩሜꬃ ዎዛናፔ፥ ኔ ኩሜꬃ ሼምፑዋፌ፥ ኔ ኩሜꬃ ቆፋፔ፥ ኔ ኩሜꬃ ዎልቃፌ ዶሳ› ያጌስ። ");
INSERT INTO gofENT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","ቃሲ ኪታ ኡባፌ ኣꬊያ ናምዓንꬆ ኪታይ ሃይሳ፤ ‹ኣሴ ኡባ ኔ ሁዒያዳ ዶሳ› ያጌይሳ፤ ሃይሳታፔ ኣꬊያ ሃራ ኪቲ ባዋ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","ሂጌ ኣስታማሬይ ዬሱሳኮ፥ «ኣስታማሪያው፥ ቱማ ጋዳሳ፤ ኔኒ ‹ፆሳይ ኢሲ ፆሳ ፃላላ። ኢያፔ ኣቲን ሃሪ ባዋ› ጊዳይሲ ቱማ። ");
INSERT INTO gofENT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","ፆሳ ኩሜꬃ ዎዛናፔ፥ ኩሜꬃ ቆፋፔኔ ኩሜꬃ ዎልቃፌ ዶሴይሲኔ ቃሲ ኣሴ ኡባ ባ ሁዒያዳ ዶሴይሲ፥ ፁጊያ ያርሹዋፌኔ ሃራ ያርሾ ኡባፌ ኣꬌስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","ዬሱሲ ሂጌ ኣስታማሪያ ዛሮይ ኣꬊዳ ኤራንቾ ኣሳ ዛሮ ጊዲዳይሳ ቤዒዲ፥ «ኔኒ ፆሳ ካዎቴꬃፌ ሃካባካ» ያጊስ፤ ሄሳፌ ጉዬ፥ ዬሱሳ ሃራባ ኦይቻናው ኦኒካ ሚኒቤና። ");
INSERT INTO gofENT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","ዬሱሲ ፆሳ ኬꬃን ታማርሲሼ፥ ሃይሳዳ ያጊስ፡ «ሂጌ ኣስታማሬቲ ኪሪስቶሳ ዎይጊዲ ዳዊቴ ናዓ ጎና? ");
INSERT INTO gofENT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","ዳዊቴይ ጌሻ ኣያናን ኩሚዲ፥ ‹ጎዳይ፥ ታ ጎዳ፥ «ታኒ ኔ ሞርኬታ ኔ ቶሆይ ዬꬊያሶ ኦꬃና ጋካናው፥ ሃይሳን ታፔ ኡሻቻ ባጋራ ኡታ» ጊስ› ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","ዳዊቴይ ባ ሁዔን ኪሪስቶሳ፥ ‹ጎዳ› ጊዲ ፄጊኮ፥ ያቲን፥ ኪሪስቶሲ ዋኒዲ፥ ዳዊቴ ናዓ ጊዲ» ያጊስ። ዳሮ ኣሳይ ዬሱሲ ጌይሳ ኡፋይሳን ሲዒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","ዬሱሲ ታማርሲሼ፥ ሃይሳዳ ያጊስ፡ «ሂጌ ኣስታማሬታፔ ናጌቲቴ፤ ኤንቲ ኣዱሳ ማዖ ማዒዲ ዩዬይሳኔ ጊያንካ ኣሳይ ኤንታ ቦንቺዲ ሳሮꬄይሳ ዶሶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ኤንቲ ኣይሁዴ ዎሳ ኬꬃታን ዳሮ ሎዖ ኦይዴ ዶሶሶና፤ ቃሲ ኣሲ ባንታና ሞኪያ ቤሳን ቦንቾ ቤሲ ዶሶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","ኤንቲ ኣምዔታ ኬꬃ ቦንቂዲ፥ ባንታው ሎዖ ዳናናው ዎሳ ኣዱሶሶና፤ ኤንቲ ኡባፌ ኣꬊያ ፒርዳ ኤካና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","ዬሱሲ ፆሳ ኬꬃን ሙፃታ ዬጊያ ሳፂኒያ ማታን ኡቲዲ፥ ኣሳይ ባ ሚሺያ ሄ ሳፂኒያን ዬጌይሳ ቤዒስ፤ ዳሮ ዱሬ ኣሳይ ዳሮ ሚሺያ ሄ ሳፂኒያን ዬጎሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","ኢሲ ማንቆ ኣምዒያ ያዳ፥ ናምዑ ባካናታ ሄ ሳፂኒያን ዬጋሱ። ");
INSERT INTO gofENT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","ዬሱሲ ባ ታማሬታ ፄጊዲ፥ «ታኒ ሂንቴው ቱማ ኦዳይስ፤ ሙፃታ ሳፂኒያን ዬጊዳ ኣሳ ኡባፌ ሃ ማንቆ ኣምዒያ ዳርሳዳ ዬጋሱ። ");
INSERT INTO gofENT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","ኣይስ ጊኮ፥ ሃራቲ ኡባይ ባንታው ፓላሂዳ ሚሺያፔ ዬጊዶሶና። ሺን ኢያ ባ ፓጪያፌ፥ ባው ዴዒያ ኣቁዋ ኩሜꬂ ኢማሱ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","ዬሱሲ ፆሳ ኬꬃፌ ኬዪሺን፥ ኢያ ታማሬታፔ ኢሶይ፥ «ኣስታማሪያው፥ ሃ ሎዖ ሹቻኔ ሃ ሎዖ ሹቻ ኬꬃ ቤዓይ!» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","ዬሱሲ ዛሪዲ፥ «ሃ ጊታ ሹቻ ኬꬃ ቤዓይ? ሃ ኬꬃይ ሹቺ ሹቻ ቦላ ጊምቤቲዳ ሜላ ላሌቶና ኣቴና፤ ኢሲ ሹቺካ ኣቶና ኡባይ ላሌታና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","ዬሱሲ ፆሳ ኬꬃፌ ሂኒ ባጋራ ሻማሆ ዴሪያ ቦላ ኡቲዳሺን፥ ጴፂሮሲ፥ ያይቆቢ፥ ዮሃኒሲኔ ኢንዲሪያሲ ባንታርካ ኢያኮ ዪዲ፥ ");
INSERT INTO gofENT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«ሃይሲ ኣዉዴ ሃናኔኮ፥ ኑስ ኦዳ፤ ሃ ኡባይ ፖሌታና ዎዲያ ኤሪሲያ ማላታይ ኣይቤ?» ያጊዲ ኦይቺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","ዬሱሲ ቃሲ ኤንታው ሃይሳዳ ያጊዲ ኦዲስ፡ «ሂንቴና ኦኒካ ባሌꬆና ሜላ ናጌቲቴ። ");
INSERT INTO gofENT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","ዳሮ ኣሳቲ ታ ሱንꬃን፥ ‹ታኒ ኪሪስቶሳ› ያጊዲ ታማርሲሼ ዪዲ፥ ዳሮ ኣሳ ባሌꬃና። ");
INSERT INTO gofENT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","ማታን ዴዒያ ኦላኔ ሃሆን ዴዒያ ኦላ ዎሬ ሂንቴ ሲዒያ ዎዴ ሂርጎፊቴ። ሄሳ ሜላባይ ሃናናው ቤሴስ፥ ሺን ዉርሴꬃይ ቡሮና። ");
INSERT INTO gofENT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","ኢሲ ቢታ ኣሳይ ሃራ ቢታ ኣሳራ ኦሌታና፤ ቃሲ ኢሲ ካዎቴꬃይ ሃራ ካዎቴꬃታራ ኦሌታና፤ ቢታ ቃፆይ ኡባ ቤሳን ሃናና፤ ኮሻይ ዳና፥ ሺን ሄሲ ኡባይ ዬሎ ኢቄꬃስ ዞኬ ሜላ። ");
INSERT INTO gofENT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","«ሺን ሂንቴ፥ ሂንቴ ሁዔን ናጌቲቴ። ኣይስ ጊኮ፥ ኣሲ ሂንቴና ኦይኪዲ፥ ፒርዳ ኬꬃስ ኣꬂ ኢማና፤ ቃሲ ኣይሁዴ ዎሳ ኬꬃታንካ ሂንቴና ሊሶን ጋራፋና፤ ዴሪያ ሃሬይሳታ ሲንꬃኒኔ ካዎታ ሲንꬃን ታ ጊሾ ሂንቴ ማርካታናው ኤቃና። ");
INSERT INTO gofENT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","ዉርሴꬃይ ጋካናፔ ሲንꬄ ዎንጌላይ ኮይሮ ዴሬ ኡባስ ኦዴታናው ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","ኤንቲ ሂንቴና ፒርዳ ኬꬂ ኤሂያ ዎዴኔ ኣꬂ ኢሚያ ዎዴ ዎይጊዲ ኦዳኔኮ ኮይሮ ሂርጎፊቴ፤ ሄ ሳቲያን ፆሳይ ሂንቴው ኢሚያባ ኦዲቴ። ሂንቴናን ጌሻ ኣያናይ ኦዴቴሲፔ ኣቲን ሂንቴና ጊዴኬታ። ");
INSERT INTO gofENT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","«ኢሻይ ባ ኢሻ፥ ኣዋይ ባ ናዓ ዎꬊሳና። ናይቲ ባንታና ዬሊዳይሳታ ቦላ ዴንዲዲ፥ ኤንታ ዎꬊሳና። ");
INSERT INTO gofENT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","ኣሳይ ኡባይ ሂንቴና ታ ሱንꬃ ጊሾ ኢፃና፥ ሺን ዉርሴꬂ ጋካናው ሚኒዳይ ኣታና። ");
INSERT INTO gofENT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","«ሺን ባሻ ቱናቴꬃይ ኤቃናው ቤሶና ቤሳን ኤቂዳሺን ሂንቴ ቤዓና።» (ኣኬኪሶ፡ ሄሲ ዎይ ጉሴኮ ናባቤይሲ ኣኬኮ!) «ዪሁዳ ቢታን ሄ ዎዴ ዴዔይሳቲ ዴሪያኮ ባቃቶ። ");
INSERT INTO gofENT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","ኬꬃ ሁዔን ዴዒያ ኡራይካ ኢሲባ ኤካናው ዱጌ ዎꬊዲ፥ ባ ሶ ጌሎፖ። ");
INSERT INTO gofENT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","ጋዴን ዴዔይሲ ባ ማዑዋ ኤካናው ጉዬ ሲሞፎ። ");
INSERT INTO gofENT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","ሄ ዎዴ ቃንꬃቲዳ ማጫሳታሲኔ ꬋንꬂያ ማጫሳታስ ዳሮ ኡንዓ ጊዳና። ");
INSERT INTO gofENT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","ሺን ሃይሲ ኡባይ ሃኒያ ዎዴይ ባልጎ ጊዶና ሜላ፥ ፆሳ ዎሲቴ። ");
INSERT INTO gofENT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","ኣይስ ጊኮ፥ ፆሳይ ኣላሚያ ሜꬊዳ ዎዲያፔ ዶሚዲ፥ ሃዒ ጋካናው ሃኒቦና ሜቶይኔ ሲንꬃፌካ ሃኖና ሜቶይ ኣሳ ቦላ ሄ ዎዴ ሃናና። ");
INSERT INTO gofENT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","ጎዳይ ሄ ጋላሳታ ታይቡዋ ጉꬆናኮ፥ ኣሴ ጊዲዳይ ኦኒካ ኣቴና። ሺን ኢ ባ ዶሪዳ ኣሳ ጊሾ ሄ ጋላሳታ ታይቡዋ ጉꬄስ። ");
INSERT INTO gofENT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","«ሄ ዎዴ ኦኒካ ሂንቴና፥ ‹ሄኮ፥ ኪሪስቶሲ ሃይሳን ዴዔስ ዎይኮ ኪሪስቶሲ ሂኒን ዴዔስ› ያጊኮ፥ ሄሳ ኣማኖፒቴ። ");
INSERT INTO gofENT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","ዎርዳንቾ ኪሪስቶሳቲኔ ዎርዶ ናቤቲ ዴንዲዲ ባንታው ዳንዳዔቲኮ፥ ሃሪ ኣቶሺን ፆሳይ ዶሪዳይሳታካ ባሌꬃናው ማላታታኔ ማላሊሲያባታ ቤሳና። ");
INSERT INTO gofENT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","ሺን ሂንቴ ናጌቲቴ፤ ታኒ ሂንቴው ኡባባ ካሴታዳ ኦዳስ። ");
INSERT INTO gofENT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","«ሺን ሄ ዎዴ ሄ ዋያፔ ጉዬ፥ ኣዋይ ꬉማና፤ ኣጌናይ ፖዑዋ ኣጋና፤ ");
INSERT INTO gofENT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ፆሊንቶቲ ሳሎፔ ኩንዳና፤ ቃሲ ሳሎን ዴዒያ ዎልቃቲካ ቃፃና። ");
INSERT INTO gofENT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","ሄ ዎዴ ኣሳ ናዓይ፥ ጊታ ዎልቃራኔ ቦንቹዋራ ሻራ ጊዶራ ዪሺን ኤንቲ ቤዓና። ");
INSERT INTO gofENT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","ሄ ዎዴ ታኒ ኪታንቾታ ሳዓ ኦይዱ ባጋ ኪታና፤ ሳዓ ጋፃፔ ሳሉዋ ጋፃ ጋካናው፥ ፆሳይ ዶሪዳ ኣሳ ሺሻና። ");
INSERT INTO gofENT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","«ሌሚሱዋ ባላሴ ሚꬃፌ ኣኬኪቴ፤ ባላሲያ ኣጪያ ዎዴኔ ኢ ሃይꬃይ ጪልዒያ ዎዴ ቶርቼይ ማታቲዳይሳ ሂንቴ ኤሬታ። ");
INSERT INTO gofENT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","ሄሳዳካ፥ ሂንቴ ሄ ኡባባይ ሃኔይሳ ቤዒያ ዎዴ ኢ ማቲዲ ፔንጌ ጋኪዳይሳ ኤሪቴ። ");
INSERT INTO gofENT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","ታኒ ሂንቴው ቱማ ኦዳይስ፤ ሃ ኡባባይ ሃናና ጋካናው ሃይሳን ዴዒያ ኣሳ ኡባይ ሃይቄና። ");
INSERT INTO gofENT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","ሳሎይኔ ሳዓይ ኣꬋና፥ ሺን ታ ቃላይ ኡባራካ ኣꬌና። ");
INSERT INTO gofENT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","«ሺን ሄ ጋላሳኔ ሄ ሳቲያ ኣዋ ፃላላፔ ኣቲን ሃሪ ኣቶሺን ሳሎን ዴዒያ ኪታንቾታ ጊዲን ዎይኮ ናዓ ጊዲን ኦኒካ ኤሬይ ባዋ። ");
INSERT INTO gofENT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","ሄ ዎዴይ ኣዉዴ ጊዳኔኮ፥ ሂንቴ ኤሮና ጊሾ ናጌቲቴኔ ሚኒቴ። ");
INSERT INTO gofENT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","ታ ዩሳይ ባ ኬꬃ ኣጊዲ፥ ኦጌ ቢያ ኡራ ሜላ። ኡራይ ባ ኣይሌታ ሁዔን ሁዔን ኦሱዋ ኢሚዲ ኤንታ ባ ኦሱዋስ ኣዋ ኦꬂስ፤ ቃሲ ናጌይሲካ ሚንꬂዲ ናጋና ሜላ ኪቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","«ሄሳ ጊሾ፥ ሚኒቴ። ኣይስ ጊኮ፥ ኬꬃዋይ ኦማርሲ ጊዲን ዎይኮ ጊዲ ቢላሄ ጊዲን ዎይኮ ኩቶ ዋሶ ጊዲን ዎይኮ ዎንታ ጉራ ጊዲን ኣዉዴ ያኔኮ፥ ሂንቴ ኤሬኬታ። ");
INSERT INTO gofENT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","ሂንቴ ኣኬኮና ኢ ዪዲ ሂንቴና ꬊስኪዲ ዴዒሺን ዴሞና ሜላ ሚኒቴ። ");
INSERT INTO gofENT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","ታኒ ሂንቴው ኦዴይሳ ኣሳ ኡባስ ኦዳይስ፤ ሚኒቴ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","ፓሲካ ባሌ ቦንቺያ ጋላሳይኔ ኡይꬃ ባሌ ቦንቺያ ጋላሳይ ጋካናው ናምዑ ጋላሲ ኣቲስ። ካሂኔ ሃላቃቲኔ ሂጌ ኣስታማሬቲ ኣሲ ኤሮና ዬሱሳ ኦይኪዲ ዎꬊያ ኦጌ ኮዮሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","«ኣሳይ ኦሺ ኬሶና ሜላ ፓሲካ ቦንቺያ ጋላሳን ሄሳ ኦꬆኮ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","ዬሱሲ ቢታኒያ ካታማን ባሮ ሃርጋንቹዋ ሲሞና ሶን ጊቢራ ቦላ ኡቲዳሺን፥ ኢሲ ማጫሲያ ኣልባስፂሮሴ ጊያ ሹቻፌ ኦሴቲዳ ጲልቃፄ ኩሜꬃ ናርዶሴ ጊያ ዳሮ ኣልዖ ሺቶ ኤካዳ ያሱ። ሄ ጲልቃፂያ ሜንꬃዳ ሺቱዋ ዬሱሳ ሁዒያን ቲጋሱ። ");
INSERT INTO gofENT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","ሄ ቤሳን ዴዒያ ኣሳፔ ኢሶይ ኢሶይ ሃንቄቲዲ፥ «ሃ ሺቶይ ሜላ ጮ ኢቴይ ኣይቢሴ? ");
INSERT INTO gofENT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","ሃ ሺቱዋ ሄꬑ ፄቱ ዲናሬን ባይዚዲ፥ ሚሺያ ማንቆታስ ኢማናው ዳንዳዔቴስ» ያጊዲ ባንታ ጊዶን ኦዴቲዶሶና። ያቲዲ፥ ሄ ማጫሲው ዳሮ ቦሪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","ሺን ዬሱሲ «ሃ ማጫሲው ኣይኮካ ጎፒቴ፤ ኢዮ ኣይስ ዋይሴቲ? ኢያ ታው ሎዖባ ኦꬃሱ። ");
INSERT INTO gofENT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","ማንቆቲ ኡባ ዎዴ ሂንቴራ ዴዖሶና። ሂንቴ ኮዪዳ ዎዴ ኣዉዴካ ሂንቴ ኤንታ ማዳናው ዳንዳዔታ፥ ሺን ታኒ ኡባ ዎዴ ሂንቴራ ዴዒኬ። ");
INSERT INTO gofENT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","ኢያ ባ ዳንዳዒዳይሳ ኦꬃሱ፤ ቃሲ ታና ሞጎስ ጊጊሳናው ካሴታዳ ሺቶ ቲያሱ። ");
INSERT INTO gofENT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","ታኒ ሂንቴው ቱማ ኦዳይስ፤ ሳዓ ኡባን ዎንጌላ ኦዲያሶን ኣዉንካ፥ ኣሳይ ኢዮ ኣኬካና ሜላ ሃ ኢያ ኦꬂዳይሲ ኦዴታና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","ታማኔ ናምዑ ታማሬታፔ ኢሶይ ኣስቆሮታ ዪሁዳ ጌቴቴይሲ ዬሱሳ ካሂኔ ሃላቃታስ ኣꬂ ኢማናው ኤንታኮ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","ኤንቲ ሄሳ ሲዒዳ ዎዴ ኡፋይቲዲ፥ «ኑኒ ኔው ሚሼ ኢማና» ያጊዶሶና፤ ዪሁዲ ዬሱሳ ኣꬂ ኢማናው ኢንጄ ዎዴ ኮዬስ። ");
INSERT INTO gofENT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","ኡይꬃ ባሌይ ቦንቼቲያ ኮይሮ ጋላስ፥ ፓሲካ ካꬃ ማናው ማራዜ ሹኪያ ዎዴ ዬሱሳ ታማሬቲ ኢያኮ፥ «ፓሲካ ቦንቺያ ጋላስ ኔኒ ማና ካꬃ ኑኒ ኣው ቢዲ ጊጊሲኖ?» ጊዲ ኦይቺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","ዬሱሲ ባ ታማሬታፔ ናምዓታ ሃይሳዳ ያጊዲ ኪቲስ፡ «ካታማ ቢቴ፤ ሂንቴ ቢሺን፥ ኦቶራ ሃꬄ ቶኪዳ ኢሲ ኡራይ ሂንቴራ ጋሄታና፤ ኢያ ካሊቴ። ");
INSERT INTO gofENT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ኢ ቢዲ ጌሊያ ኬꬃዋ፥ ‹ኣስታማሬይ ኔኮ፥ «ታኒ ታ ታማሬታራ ፓሲካ ማናው ኢማꬃ ኪፊሌይ ኣዉኔ?» ያጌስ› ያጊቴ። ");
INSERT INTO gofENT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","ኬꬃዋይ ሂንቴና ፖቂያ ቦላ ዴዒያ ጊጊ ኡቲዳ ዳልጋ ኪፊሌ ቤሳና፤ ሄሳን ጊጊሲቴ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","ሄ ናምዑ ታማሬቲ ኬዪዲ፥ ካታማ ቢዶሶና፤ ዬሱሲ ኤንታው ኦዲዳይሳዳ ዴሚዲ፥ ፓሲካ ካꬃ ጊጊሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","ሳዓይ ኦማርሲያ ዎዴ ዬሱሲ ታማኔ ናምዑ ታማሬታራ ያ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","ኤንቲ ኡቲዲ ካꬂ ሚሺን፥ ዬሱሲ ኤንታኮ፥ «ታኒ ሂንቴው ቱማ ኦዳይስ፤ ሂንቴፌ ኢሶይ ታራ ሜይሲ፥ ታና ኣꬂ ኢማና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","ኢያ ታማሬቲ ዳጋሚዲ፥ ባንታ ሁዔን ሁዔን፥ «ቱማ ታኔሻ?» ያጊዲ ኢያ ኦይቺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","ዬሱሲ ዛሪዲ፥ «ሄ ኡራይ ሂንቴ ታማኔ ናምዓታፔ ኢሱዋ፤ ኢ ታራ ኢሲፌ ቱሻናው ባ ኡይꬃ ሻቲያን ዬዴይሳ። ");
INSERT INTO gofENT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","ኣሳ ናዓይ፥ ጌሻ ማፃፋይ ሃይቃና ጊዳይሳዳ ሃይቃና፥ ሺን ኣሳ ናዓ፥ ኣꬂ ኢሚያ ኡራ ኣዬ። ሄ ኡራይ ዬሌቶና ኣቲዳኮ ኢያው ሎዖሺን» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","ኤንቲ ሚሺን፥ ዬሱሲ ኡይꬃ ኤኪዲ፥ ፆሳ ጋላቲስ፤ ሄ ኡይꬃ ሜንꬂዲ፥ ባ ታማሬታስ ኢሚሼ፥ «ሄዒቴ፥ ሃይሲ ታ ኣሹዋ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","ፁዓ ኤኪዲ፥ ፆሳ ጋላቲዲ፥ ኤንታው ኢሚን ኡባይካ ሄ ፁዓፔ ኡዪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","ዬሱሲ፥ «ሃይሲ ኦራꬃ ጫቁዋን ዳሮ ኣሳ ጊሾ ጉኪያ ታ ሱꬃ። ");
INSERT INTO gofENT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","ታኒ ሂንቴው ቱማ ኦዳይስ፤ ታኒ ፆሳ ካዎቴꬃን ኦራꬃ ዎይኒያ ኡያና ጋላሳይ ጋካናው ዛራዳ ሃ ዎይኒያፔ ኡዪኬ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","ማዝሙሬ ዬፂዳፔ ጉዬ ሻማሆ ዴሪያ ቦላ ቢዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","ዬሱሲ ኤንታኮ፥ «ሂንቴ ኡባይ ታና ዬጊ ኣጊዲ ባቃታና፤ ጌሻ ማፃፋይ፥ ‹ፆሳይ ዶርሳ ሄሜይሳ ዎꬋና፥ ዶርሳቲ ኡባይ ላሌታና› ያጌስ። ");
INSERT INTO gofENT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","ሺን ታኒ ሃይቆፔ ዴንዲዳፔ ጉዬ ሂንቴፌ ካሴታዳ ጋሊላ ባና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","ጴፂሮሲ ዛሪዲ፥ «ኤንቲ ኡባይ ኔና ዬጊ ኣጊዲ ባቃቲኮካ፥ ታ ኔና ኣጊኬ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","ዬሱሲ ጴፂሮሳኮ፥ «ታኒ ኔው ቱማ ኦዳይስ፤ ሃቺ ቃማ ኩቶይ ናምዑ ቶሆ ዋሳናፔ ሲንꬄ ኔኒ ታና ሄꬑ ቶሆ ካዳና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","ሺን ጴፂሮሲ ካሴይሳፌ ሚንꬂዲ፥ «ታኒ ሃሪ ኣቶሺን፥ ኔራ ኢሲፌ ሃይቂያኮካ፥ ኔና ካዲኬ» ያጊስ። ቃሲ ሃራቲ ኡባቲካ ሄሳዳ ጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","ጌቴሴማኔ ጊያ ቤሳ ቢዶሶና፤ ዬሱሲ ባ ታማሬታኮ፥ «ታኒ ፆሳ ዎሳዳ ሲማና ጋካናው ሂንቴ ሃይሳን ኡቲሺቴ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","ዬሱሲ ጴፂሮሳ፥ ያይቆባኔ ዮሃኒሳ ባራ ኤኪዲ ቢስ፤ ዳሮ ዋዬቲሲኔ ኡንዔቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ቃሲ ኤንታኮ፥ «ታኒ ሃይቃና ጋካናው ኣዛናስ፥ ሃይሳን ጋምዒሺቴ፤ ꬊስኮፊቴ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","ጉꬂ ሲንꬄ ሺቂዲ፥ ሳዓን ጉፋኒዲ፥ ዳንዳዔቲያባ ጊዲኮ፥ ሄ ዋያ ሳቴይ ባፔ ኣꬋና ሜላ፥ ፆሳ ዎሲስ። ");
INSERT INTO gofENT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","ቃሲ፥ «ኣባ፥ ታ ኣዋው፥ ኡባባይ ኔው ዳንዳዔቴስ፥ ሃ ዋዬ ፁዓ ታፔ ዲጋ። ሺን ኔ ሼኔይ ሃኖፔ ኣቲን ታ ሼኔይ ሃኖፖ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","ዬሱሲ ባ ታማሬታኮ ሲሚ ዪዲ፥ ኤንቲ ꬊስኪዳሺን ዴሚዲ፥ ጴፂሮሳኮ፥ «ሲሞና፥ ꬊስካዲ? ኔኒ ኢሲ ሳቴካ ባርካዳ ናጋናው ዳንዳዓቢኪ? ");
INSERT INTO gofENT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","ፓጬን ሂንቴ ጌሎና ሜላ ባርኪዲ ናጊቴኔ ፆሳ ዎሲቴ። ሂንቴው ሎዖ ኣሞይ ዴዔስ፥ ሺን ሂንቴ ዳቡራንቾ ኣሲ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","ቃሲካ ቢዲ ካሴይሳዳካ ፆሳ ዎሲስ። ");
INSERT INTO gofENT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","ባ ታማሬታኮ ጉዬ ሲሚዲ ያ ዎዴ ꬊስኪዳሺን ዴሚስ። ኤንታ ኣይፊያ ꬊስኮይ ጎዚ ዎꬂዳ ጊሾ ኢያኮ ኣይ ኦዴቲያኮካ ኤሮኮና። ");
INSERT INTO gofENT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","ሄꬓንꬆ ኤንታኮ ዪዲ፥ «ሃዒ ጋካናዉካ ꬊስኬቲኔ ሼምፔቲ? ሂዛ፥ ጊዳና፤ ሳቴይ ጋኪስ፤ ቤዒቴ! ኣሳ ናዓይ፥ ናጋራንቾ ኣሳታስ ኣꬊ ኢሜታና ዎዴይ ጋኪስ። ");
INSERT INTO gofENT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","ዴንዲዲ ዬꬊቴ፤ ቤዒቴ፥ ታና ኣꬂ ኢማናይሲ ጋኪስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","ዬሱሲ ሄሳ ቡሮ ኦዲሺን፥ ታማኔ ናምዑ ኢያ ታማሬታፔ ኢሶይ፥ ዪሁዲ፥ ኤሌሲዲ ጋኪ ዎꬊስ። ቃሲ ካሂኔ ሃላቃቲ፥ ሂጌ ኣስታማሬቲኔ ጪማቲ ኪቲን፥ ማሼኔ ፃምዓ ኦይኪዳ ዳሮ ኣሳይ ኢያራ ኢሲፌ ዪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","ዬሱሳ ኣꬂ ኢማናይሲ ሄ ዳሮ ኣሳስ፥ «ታኒ ዬሬይ ኢያ፤ ኢያ ኦይኪዲ፥ ሎይꬂ ናጊዲ፥ ኤኪ ኤፊቴ» ያጊዲ ማላ ኦዲ ዎꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","ዪሁዲ ጋኪ ዎꬊዳ ሜላ ዬሱሳኮ ሺቂዲ፥ «ኣስታማሪያው» ያጊዲ ዬሱሳ ዬሪ ኤኪስ። ");
INSERT INTO gofENT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","ሄ ዳሮ ኣሳይ ዬሱሳ ኦይኪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","ሺን ማታን ኤቂዳይሳታፔ ኢሶይ ባ ማሻ ሾዲዲ ካሂኔ ሃላቃ ኣይሊያ ሾጪዲ፥ ኢያ ሃይꬃ ቃንፂዲ ሆሊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","ዬሱሲ ዛሪዲ፥ ሄ ሺቂዳ ዳሮ ኣሳኮ፥ «ታና ፓንጋ ኬሲዲ፥ ፓንጋ ኦይኬይሳዳ ኦይካናው ማሼኔ ፃምዓ ኦይኪዲ ዪዴቲ? ");
INSERT INTO gofENT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","ታኒ ፆሳ ኬꬃን ታማርሳሼ፥ ጋላስ ጋላስ ሂንቴራ ዴዒያ ዎዴ ታና ኦይኪቤኬታ፥ ሺን ጌሻ ማፃፋይ ጊዳይሲ ፖሌታናው ቤሴስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","ኢያ ታማሬቲ ኡባይ ኢያ ዬጊ ኣጊዲ ባቃቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","ላፃና ፃላላ ማዒዳ ኢሲ ናቴꬃ ኡራይ ዬሱሳ ካሌይሳ ኣሳይ ኦይኪስ። ");
INSERT INTO gofENT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ሺን ሄ ኡራይ ላፃና ዬጊ ኣጊዲ፥ ፂሬ ካሎ ባቃቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","ኣሳይ ዬሱሳ ካሂኔ ሃላቃ ሶ ኤፊዶሶና። ያን ካሂኔ ሃላቃቲ፥ ጪማቲኔ ሂጌ ኣስታማሬቲ ሺቂዲ ዴዖሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","ጴፂሮሲ ካሂኔ ሃላቃ ዛባ ጋካናው ሃሆን ኢያ ካሊ ቢዲ ያን ናጌይሳታራ ኡቲዲ ታማ ካዬስ። ");
INSERT INTO gofENT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","ካሂኔ ሃላቃቲኔ ሺቂዳ ኣሳ ኡባይ ዬሱሳ ዎꬋናው ኢያ ቦላ ማርካ ኮዪዶሶና፥ ሺን ኣይኮካ ዴሚቦኮና። ");
INSERT INTO gofENT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","ዳሮ ኣሳቲ ኢያ ቦላ ዎርዶ ማርካቲዶሶና፥ ሺን ኤንታ ማርካቴꬃይ ኢሲኖ ጊዴና። ");
INSERT INTO gofENT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","58","ኢሲ ኢሲ ኣሳቲ ዴንዲ ኤቂዲ ዬሱሳ ቦላ፥ «ኢ፥ ‹ታኒ ኣሲ ኬፂዳ ሃ ፆሳ ኬꬃ ላላዳ፥ ኣሳ ኩሼን ኬፄቲቦና ሃራ ፆሳ ኬꬃ ሄꬑ ጋላሳ ጊዶን ኬፃና› ጊሺን ኑኒ ሲዒዳ» ያጊዲ ዎርዶ ማርካቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","ጊዶሺን፥ ኤንታ ማርካቴꬃይ ሄሳንካ ኢሲኖ ጊዴና። ");
INSERT INTO gofENT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","ካሂኔ ሃላቃይ ኣሳ ኡባ ሲንꬃን ዴንዲ ኤቂዲ፥ «ሃይሳቲ ኔና ሞቲያ ሞቱዋስ ኔ ዛሪያባይ ባዌ?» ያጊዲ ዬሱሳ ኦይቺስ። ");
INSERT INTO gofENT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","ሺን ዬሱሲ ሲዒ ጊስ፤ ኣይኮካ ዛሪቤና። ካሂኔ ሃላቃይ፥ «ኣንጄቲዳ ፆሳ ናዓይ፥ ኪሪስቶሲ ኔኔዬ?» ያጊዲ ዛሪ ኦይቺስ። ");
INSERT INTO gofENT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","ዬሱሲ ዛሪዲ፥ «ኤ ታና፥ ሂንቴ ኣሳ ናዓይ፥ ዎልቃማ ፆሳፌ ኡሻቻ ባጋራ ኡቲዳሺን ቃሲ ሳሉዋ ሻራራ ዪሺን ቤዓና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","ካሂኔ ሃላቃይ ባ ማዑዋ ፔꬊዲ፥ «ኑና ሃራ ማርካ ኣይ ኮሺ? ");
INSERT INTO gofENT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","ሂንቴ ኢያ ጫሻ ሲዒዴታ፤ ሂንቴ ቆፋይ ኣይቤ?» ያጊስ። ኤንቲ ኡባይ፥ «ኢ ሃይቃናው ቤሴስ» ያጊዲ ኢያ ቦላ ፒርዲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","ኤንታፌ ኢሶቲ ኢሶቲ ኢያ ቦላ ጩቴꬂ ኦይኪዶሶና። ኢያ ኣይፊያ ጎዚዲ ባቂሼ፥ «ኔና ዴቺዳይ ኦኔ? ኣኔ ኑስ ኦዳ!» ያጊዶሶና። ናጌይሳቲ ኢያ ኤኪ ኤፊዲ ጋራፊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","ጴፂሮሲ ካሂኔ ሃላቃ ዛባን ጋርሳ ባጋራ ዴዒሺን፥ ካሂኔ ሃላቃ ማጫ ኣይሌታፔ ኢሲኒያ ያ ያሱ። ");
INSERT INTO gofENT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ጴፂሮሲ ታማ ካዬይሳ ቤዓዳ፥ ቲሺ ኦꬃ ፄላዳ፥ «ኔኒካ ናዚሬቴ ዬሱሳራ ዴዓሳ» ያጋሱ። ");
INSERT INTO gofENT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","ሺን ጴፂሮሲ፥ «ኔ ጌይሲ ኣይቤኮ ታ ኤሪኬ፥ ታው ኣኬኬቴና» ያጊዲ ካዲስ። ያጊ ሲሚዲ ዛጎ ኬያ ዎዴ ሶሁዋራ ኩቶይ ዋሲስ። ");
INSERT INTO gofENT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","ሄ ኣይሊያ ጴፂሮሳ ቤዓዳ፥ ኢያ ማታን ኤቂዳ ኣሳታኮ፥ «ሃ ኡራይካ ኤንታራ ዴዔስ» ጋዳ ዛራ ኦዳሱ። ");
INSERT INTO gofENT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","ሺን ጴፂሮሲ ቃሲካ ካዲስ። ጉꬂ ጋምዒሺን፥ ማታን ኤቂዳ ኣሳቲ ናምዓንꬆ ጴፂሮሳኮ፥ «ኔኒ ጋሊላ ቢታ ኣሲ ጊዲያ ጊሾ ቱማ ኤንታራ ዴዓሳ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","ሺን ጴፂሮሲ፥ «ታኒ ሂንቴ ጊያ ኡራ ኤሪኬ!» ያጊዲ ባና ቃንጌꬂኔ ጫቆ ኦይኪስ። ");
INSERT INTO gofENT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","ሶሁዋራ ኩቶይ ናምዓንꬆ ዋሲ ኣጊስ። ጴፂሮሲ ዬሱሲ ኢያኮ፥ «ኔኒ ኩቶይ ናምዑ ቶሆ ዋሳናፔ ሲንꬄ ሄꬑ ቶሆ ታና ካዳና» ኢያኮ ጊዳይሳ ኣኬኪዲ ዳሮ ዬኪስ። ");
INSERT INTO gofENT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","ዎንታ ጉራ ኤሌሲዲ ካሂኔ ሃላቃቲ፥ ጪማቲ፥ ሂጌ ኣስታማሬቲኔ ኣይሁዴ ሻንጎቲ ኡባይ ሺቂዲ ማቄቲዶሶና። ኤንቲ ዬሱሳ ቃቺ ኤፊዲ ጲላፆሳስ ኣꬂ ኢሚዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","ጲላፆሲ ኢያኮ፥ «ኔኒ ኣይሁዴታ ካዎ?» ያጊዲ ኦይቺስ። ዬሱሲ ዛሪዲ፥ «ኔ ጋዳሳ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","ካሂኔ ሃላቃቲ ዬሱሳ ዳሮባን ሞቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","ሺን ጲላፆሲ ዛሪዲ ዬሱሳኮ፥ «ኔው ዛሪያባይ ባዌ? ኤንቲ ኔ ቦላ ኣይ ሜላ ሞቱዋ ኤሂያኮ ቤዒኪ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","ሺን ዬሱሲ ሃራባ ዛሮና ኢፂን፥ ጲላፆሲ ማላሌቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","ጲላፆሳስ ፓሲካ ባሌ ቦንቺያ ጋላሳን ኣሳይ ኮያ ኢሲ ኡራ ቃሾፔ ቢሊያ ሜዜይ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","ሄ ዎዴ ኢሲ ባርባና ጊያ ኡራይ ኦሹ ኬሲዲ ሼምፖ ዎꬊዳ ኣሳታራ ኢሲፌ ቃሾ ኬꬃን ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","ሺቂዳ ዳሮ ኣሳይ ጲላፆሲ ካሴይሳዳ ኦꬃና ሜላ ኢያ ኦይቺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","ጲላፆሲ ኣሳ ዛሪዲ፥ «ታኒ ሂንቴው ኣይሁዴታ ካዉዋ ቢላናይሳ ኮዬቲ?» ያጊዲ ኦይቺስ። ");
INSERT INTO gofENT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","ሄሳ ኢ ጊዳይ፥ ካሂኔ ሃላቃቲ ዬሱሳ ቃናቲዲ ኣꬂ ኢሚዳይሳ ኤሪያ ጊሾሳ። ");
INSERT INTO gofENT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","ሺን ካሂኔ ሃላቃቲ ዬሱሳ ጊሾ ባርባና ቢላናዳ፥ ሄ ሺቂዳ ኣሳይ ጲላፆሳ ዎሳና ሜላ ኣሳ ማቂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","ጲላፆሲ ዛሪዲ፥ «ያቲን፥ ሃ ሂንቴ ኣይሁዴ ካዎ ጌይሳ ዋቶ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","ኣሳይ ጲላፆሳ ቦላ ዋሲዲ፥ «ማስቃሊያ ቦላ ኢያ ካቃ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","ጲላፆሲ ኣሳኮ፥ «ኣይስ? ኢ ኣይ ኢታባ ኦꬂዴ?» ያጊስ። ሺን ኣሳይ ካሴይሳፌ ጉጂ ዋሲዲ፥ «ማስቃሊያ ቦላ ኢያ ካቃ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","ጲላፆሲ ኣሳ ኡፋይሳናው ኮዪዲ፥ ባርባና ኣሳስ ቢሊስ፤ ያቲዲ ሊሶን ዬሱሳ ጋራፊዲ፥ ማስቃሊያ ቦላ ካቃና ሜላ ኤንታው ኣꬂ ኢሚስ። ");
INSERT INTO gofENT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","ሄሳፌ ጉዬ፥ ዎታዳሬቲ ዬሱሳ ዴሪያ ሃሬይሳ ኦሶ ኬꬃ ኤኪ ኤፊዲ፥ ሃራ ዎታዳሬታ ኡባ ኢሲፌ ፄጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","ቃሲ ዞዖ ኣፊላ ኢያ ማይዚዶሶና፤ ኣጉንꬃ ካላቻ ጊጊሲዲ፥ ኢያ ሁዔን ዎꬂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","ሄሳፌ ጉዬ፥ ኢያኮ፥ «ኣይሁዴታ ካዉዋው ሚሪናው ካዎታ» ያጊዲ፥ ኢያው ዚጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","ኢያ ሁዒያ ፃምዓን ሾጪዶሶና፤ ቃሲ ኢያ ቦላ ጩቲዶሶና፤ ጉልባቲዲ ኢያው ጎይኒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","ኢያ ቶቺዳይሳፌ ጉዬ ዞዖ ኣፊላ ኢያፔ ቃሪ ኤኪዲ፥ ኢያ ኣፊላ ኢያ ማይዚዲ ማስቃሊያ ቦላ ኢያ ካቃናው ኤኪ ኤፊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","ኤንቲ ቢሼ፥ ኢስኪንዲሬኔ ሩፎሳ ኣዋ፥ ሲሞና ጊያ ቄሬና ቢታ ኣሲ፥ ጋፃሬፔ ካታማ ዬይሳራ ጋሄቲዲ፥ ዬሱሳ ማስቃሊያ ዎልቃን ቶሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","ያቲዲ ጎልጎታ ጊያ ቤሳ ዬሱሳ ኤፊዶሶና። «ጎልጎታ» ጉሳይ «ሁዔ ጉጌ» ጉሱ። ");
INSERT INTO gofENT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","ሳኮይ ሲዔቶና ሜላ ካርቤ ጊያ ꬋሌይ ዋላኬቲዳ ዎይኔ ኡዮ ጊዲ ኢያው ኢሚዶሶና። ሺን ኢ ኡዮና ኢፂስ። ");
INSERT INTO gofENT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","ኤንቲ ማስቃሊያ ቦላ ኢያ ካቂዶሶና። ኦና ኣይቢ ጋካኔኮ ጊዲ ኢያ ኣፊላ ሻኪዲ ሳማ ዬጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","ኤንቲ ማስቃሊያ ቦላ ኢያ ካቂያ ዎዴ ዎንታፌ ሄꬑ ሳቴ። ");
INSERT INTO gofENT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","ኤንቲ፥ «ኣይሁዴታ ካዉዋ» ያጊዲ ኢያ ሞቲያ ፁፌ ፃፊዲ ዎꬂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","ዬሱሳራ ናምዑ ፓንጋታ ኢሱዋ ኢያፔ ኡሻቻ ባጋራ ሃንኩዋ ኢያፔ ሃዲርሳ ባጋራ ማስቃሊያ ቦላ ካቂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","ጌሻ ማፃፋይ፥ «ኢታባ ኦꬂዳ ኣሳታራ ኢ ፓይዴቲስ» ጌቴቲዳይሲ ፖሌቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","ኦጊያራ ኣꬊያ ኣሳይ ዬሱሳ ካꬊዲ፥ ባንታ ሁዒያ ቃꬂዲ ጫዪዶሶና፤ «ሄኮ! ፆሳ ኬꬃ ላላዳ ሄꬑ ጋላሳ ጊዶን ኬፄይሶ፥ ኔ ሁዒያ ኣሻ፤ ");
INSERT INTO gofENT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","ኣኔ ማስቃሊያ ቦላፌ ዎꬋ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","ሄሳዳካ፥ ካሂኔ ሃላቃቲ ሂጊያ ታማርሴይሳታራ ኢሲፌ ዬሱሳ ቶቺዲ፥ «ሃራታ ኣሺስ፥ ሺን ባና ኣሻናው ዳንዳዔና፤ ");
INSERT INTO gofENT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","ኑኒ ቤዒዲ ኣማናና ሜላ ኪሪስቶሲ፥ ኢስራዔሌ ካዎይ፥ ኣኔ ማስቃሊያ ቦላፌ ሃዒ ዎꬎ» ያጊዶሶና። ቃሲ ሃሪ ኣቶሺን፥ ኢያራ ማስቃሊያ ቦላ ካቄቲዳይሳቲካ ኢያ ቶቺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","ኡሱፑን ሳቴፔ ዶሚዲ፥ ኡዱፉን ሳቴ ጋካናው ቢታ ኡባይ ꬉሚስ። ");
INSERT INTO gofENT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","ኡዱፉን ሳቲያን ዬሱሲ ባ ቃላ ꬎቁ ኦꬂዲ፥ «ኤሎሄ፥ ኤሎሄ፥ ላማ ሳባቂታኒ?» ያጊስ። ሄሳ ጉሳይ፥ «ታ ፆሳው፥ ታ ፆሳው፥ ታና ኣይስ ኣጋዲ?» ጉሱ። ");
INSERT INTO gofENT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","ሄሳን ኤቂዳ ኣሳፔ ኢሶይ ኢሶይ ሄሳ ሲዒዲ፥ «ሄኮ፥ ኤሊያሳ ፄጌስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","ሄ ኣሳፔ ኢሶይ ዎፂዲ፥ ኢስፖንጄን ጫላ ዎይኔ ኩንꬂስ፤ ሄሳ ፃምዓ ፄራን ዎꬂዲ፥ «ናጊቴ፤ ኤሊያሲ ማስቃሊያፔ ኢያ ዎꬊሳናው ያኔኮ ኣኔ ቤዖስ» ያጊዲ ዬሱሳ ዶናኮ ኡሻናው ሺሺስ። ");
INSERT INTO gofENT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","ዬሱሲ ባ ቃላ ꬎቁ ኦꬂ ዋሲዲ፥ ሃይቂስ። ");
INSERT INTO gofENT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","ፆሳ ኬꬃን ካቄቲዳ ማጋራጆይ ቆሞፌ ዱጌ ጋካናው፥ ናምዑ ኬዪዲ ዳኬቲ ዎꬊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","ማስቃሊያፔ ሲንꬃ ባጋራ ያን ኤቂዳ ኢሲ ማቶ ሃላቃይ፥ ዬሱሲ ዋኒዲ ሃይቂዳኮ ቤዒዳ ዎዴ «ሃ ኡራይ ቱማ ፆሳ ናዓ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","ሄሳ ሃሆን ኤቂዲ ቤዒያ ጉꬃ ማጫሳቲ ዴዖሶና። ኤንታ ጊዶን ማግዴላ ማይራማ፥ ካሉዋ ያይቆባኔ ዮሳ ኣያ ማይራማኔ ሳሎማ ዴዖሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","ሄ ማጫ ኣሳቲ ዬሱሲ ጋሊላን ዴዒያ ዎዴ ኢያ ካሊዳይሳታኔ ኢያ ሞኪዳይሳታ ቃሲ ዬሱሳራ ኢሲፌ ዬሩሳላሜ ቢዳ ሃራ ዳሮ ማጫ ኣሳቲ ያን ዴዖሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","ሳዓይ ኦማርሲዳ ዎዴ ሺቂዳ ኣሳን ቦንቼቲዳ ኣይሁዴ ሻንጎታፔ ኢሶይ፥ ዮሴፋ ጊያ ኡራይ፥ ፆሳ ካዎቴꬃይ ያናይሳ ናጊሼ ዴዔይሲ፥ ኣርማቲያሳ ካታማ ኣሲ ዴዔይሲ ዪስ። ዎንቴꬄ ሳምባታስ ጊጌቲያ ጋላስ ጊዲዳ ጊሾ ዮሴፊ ሚኒዲ ጲላፆሳኮ ቢዲ፥ ዬሱሳ ኣሃ ኤካናው ዎሲስ። ");
INSERT INTO gofENT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","ጲላፆሲ ዬሱሲ ሃይቂዳይሳ ሲዒዳ ዎዴ ማላሌቲስ፤ ማቶ ሃላቃ ፄጊዲ፥ «ኢ ሃይቂዲ ጋምዒዴ?» ያጊዲ ኦይቺስ። ");
INSERT INTO gofENT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","ጲላፆሲ ዬሱሲ ሃይቂዳይሳ ማቶ ሃላቃፔ ሲዒዲ ኢያ ኣሃ ዮሴፋስ ኢሚስ። ");
INSERT INTO gofENT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","ዮሴፊ ሞጎ ኣፊላ ሻሚስ፤ ዬሱሳ ኣሃ ማስቃሊያፔ ዎꬂዲ፥ ኣፊላን ፃፂዲ፥ ሹቻፌ ዎጬቲዳ ዱፎ ጊዶን ኢያ ኣሃ ሞጊስ። ቃሲ ሄ ዱፉዋ ዶናን ጊታ ሹቹ ጎንዶርሲዲ ዎꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","ማግዴላ ማይራማኔ ዮሳ ኣያ ማይራማ ዬሱሳ ኣሃ ኤንቲ ኣዉን ዎꬂያኮ ቤዖሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","ሳምባታይ ኣꬊዳፔ ጉዬ ማግዴላ ማይራማ፥ ያይቆባ ኣያ ማይራማኔ ሳሎማ ቢዲ፥ ዬሱሳ ኣሃ ቲያናው ሺቶ ሻሚዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","ዎጋ ዎዴ ዎንታ ዳሮ ጉራ ፃልቄይ ጫርሺን፥ ዱፉዋ ቢዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","ኤንቲ ባንታ ጊዶን ኢሶይ ኢሱዋራ፥ «ዱፉዋ ዶናፔ ኑስ ሹቻ ኦኔ ጎንዶርሲዲ ዲጋናይ?» ያጊዲ ኦዴቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","ኤንቲ ፄሊያ ዎዴ ሄ ዳሮ ጊታ ሹቻይ ጎንዶሬቲዲ ኪቺዳይሳ ቤዒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","ዬሱሲ ሞጌቲዳ ዱፉዋ ጊዶ ጌሊያ ዎዴ ኢሲ ፓንꬃ ኣዴይ ቦꬃ ማዖ ማዒዲ፥ ኡሻቻ ባጋራ ኡቲዳይሳ ቤዒዲ ዳጋሚዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","ሺን ኢ ኤንታኮ፥ «ዳጋሞፊቴ፤ ማስቃሊያ ቦላ ካቄቲዳ፥ ናዚሬቴ ዬሱሳ ሂንቴ ኮዬይሳ ታኒ ኤራይስ። ኢ ሃይሳን ዴና፥ ሃይቆፔ ዴንዲስ። ኤንቲ ኢያ ሞጊዳ ቤሳ ሃይሳ ቤዒቴ። ");
INSERT INTO gofENT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","ሃዒ ቢዲ ዬሱሳ ታማሬታሲኔ ጴፂሮሳስ፥ ‹ዬሱሲ ሂንቴፌ ሲንꬃቲዲ ጋሊላ ቤስ። ኢ ሂንቴው ኦዲዳይሳዳ ሂንቴ ኢያ ያን ቤዓና› ያጊዲ ኦዲቴ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","ማጫሳቲ ያሻን ኮኮሪሼ ዱፉዋፔ ኬዪዲ ባቃቲዶሶና። ቃሲ ኤንቲ ያዪዳ ጊሾ ሄሳ ኦዴስካ ኣይኮካ ኦዲቦኮና። ");
INSERT INTO gofENT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","ዬሱሲ ሃይቆፔ ዴንዲዳፔ ጉዬ ዎጋ ጋላስ ዎንታ፥ ላፑን ቱና ኣያናታ ኬሲዳ ማግዴላ ማይራሚስ ኮይሮቲዲ ቤንቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","ኢያ ባዳ ካሴ ኢያራ ዴዔይሳታስ፥ ኤንቲ ኣዛኒሼኔ ዬኪሼ ዴዒሺን ኦዳሱ። ");
INSERT INTO gofENT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","ሺን ዬሱሲ ፓፃ ዴዔይሳኔ ኢው ቤንቲዳይሳ ኤንቲ ሲዒዳ ዎዴ ኢያ ጌይሳ ኣማኒቦኮና። ");
INSERT INTO gofENT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","ሄሳፌ ጉዬ፥ ኤንታፌ ናምዓቲ ካታማፔ ኬዪዲ ቢሺን፥ ኦጌ ቦላ ዬሱሲ ካሴይሳፌ ዱማቲዲ ኤንታው ቤንቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","ኤንቲ ጉዬ ሲሚዲ፥ ሃራታስ ኦዲዶሶና፥ ሺን ሃራቲካ ኤንታ ኦዳ ቱማ ጊቦኮና። ");
INSERT INTO gofENT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","ጉዬፔ ታማኔ ኢሲ ኢያ ታማሬቲ ካꬂ ሚሺን፥ ዬሱሲ ኤንታው ቤንቲስ። ኤንታው ኣማኖይ ባይና ጊሾኔ ሃይቆፔ ኢ ዴንዲዳይሳ ቤዒዳ ኣሳይ ኦዲን ኤንቲ ኣማኖና ኢፂዳ ጊሾ ኢ ኤንታ ቦሪስ። ");
INSERT INTO gofENT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","ኢ ኤንታኮ፥ «ቢታ ኡባ ቢዲ ኣሳ ኡባስ ዎንጌላ ኦዲቴ። ");
INSERT INTO gofENT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","ኣማኔይኔ ፃማቄቴይ ኣታና፥ ሺን ኣማኖናይ ፒርዴታና። ");
INSERT INTO gofENT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","ኣማኔይሳታስ ሃ ማላታቲ ኢሜታና። ኤንቲ ታ ሱንꬃን ቱና ኣያናታ ኬሳና፥ ኦራꬃ ዶናን ኦዴታና። ");
INSERT INTO gofENT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ኤንቲ ሾሹ ኦይኪኮካ ዎይኮ ዎꬊያባ ኡዪኮካ ኤንታ ቆሄና። ቃሲ ኤንቲ ባንታ ኩሺያ ሃርጋንቾታ ቦላ ዎꬂዲ ኤንታ ፓꬃና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","ጎዳይ ዬሱሲ ታማሬታራ ኦዴቲዳፔ ጉዬ ፑዴ ሳሎ ኬዪስ፤ ፆሳፌ ኡሻቻ ባጋራ ኡቲስ። ");
INSERT INTO gofENT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","ኢያ ታማሬቲ ቢዳሶ ኡባን ቃላ ኦዲዶሶና። ጎዳይካ ኤንታራ ኢሲፌ ኦꬄስ። ኤንቲ ኦዲያ ቃላይ ቱማ ጊዲዳይሳ ፆሳይ ኤንታው ኢሚያ ማላታታን ኤሪሲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","ቦንቾ ቴዎፊሎሳ፥ ኑ ጊዶን ፖሌቲዳባስ ዳሮቲ፥ ባንታው ዳንዳዔቲዳ ሜላ ፃፊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","ሄ ታሪኪያ ኤንቲ ፃፊዳይ ኮይሮፔ ዶሚዲ ኣይፌ ማርካቲኔ ቃላ ሃጋዜይሳቲ ኑስ ኦዲዳይሳ። ");
INSERT INTO gofENT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","ታካ ታ ባጋራ ኮይሮፔ ኣኬካ ፄሊዳፔ ጉዬ ሄ ታሪኪያ ሃኖታ ማራያዳ ኔው ፃፎይ ታው ሎዖ ጊዲ ቤንቲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ሄሲካ፥ ኔ ታማሪዳባይ ቱማ ጊዴይሳ ኤሪሳናሳ። ");
INSERT INTO gofENT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","ዪሁዳ ካዉዋ ሄሮዲሳ ዎዴ ኣቢያ ያራፔ ጊዲዳ ዛካሪያሳ ጊያ ኣይሁዴ ካሂኔይ ዴዔስ። ኢያ ማቺያካ ኣሮና ሼሻፔ። ኢ ሱንꬃይካ ኤልሳቤፆ። ");
INSERT INTO gofENT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","ናምዓይካ ጎዳ ዎጋኔ ኪታ ኡባ ናጊዲ ቦሬይ ባይና ፆሳ ሲንꬃን ፂሎቴꬃን ዴዒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","ሃኖፔ ኣቲን ኤልሳቤፃ ማይንꬂ ጊዲዳ ጊሾ ኤንታው ናዒ ባዋ። ናምዓይካ ቃሲ ጪሚዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","ኢሲ ጋላስ ዛካሪያሲ ባ ጊሹዋ ማራን ፆሳ ሲንꬃን ካሂኔቴꬃን ሃጋዜስ። ");
INSERT INTO gofENT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ካሂኔቴꬃ ዎጋን ፆሳ ኬꬂ ጌሊዲ ኢፃኔ ጩዪሳናው ኢያ ሳሚ ጋኪስ። ");
INSERT INTO gofENT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","ኢፃኔይ ጩያ ዎዴ ኣሳይ ካሬን ዎሴስ። ");
INSERT INTO gofENT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","ጎዳ ኪታንቾይ ያርሹዋ ያርሺያ ቤሳፌ ኡሻቻ ባጋራ ኤቂዲ ቤንቲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","ዛካሪያሲ ኢያ ቤዒዳ ዎዴ ዳጋሚዲ ዳሮ ያዪስ። ");
INSERT INTO gofENT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","ሺን ኪታንቾይ ኢያኮ፥ «ዛካሪያሳ ያዮፋ፤ ኔ ዎሳይ ሲዔቲስ። ኔ ማቺያ ኤልሳቤፃ ኣዴ ናዓ ዬላና፥ ኢያ ዮሃኒሳ ጋዳ ኔ ሱንꬃና። ");
INSERT INTO gofENT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","ኢ ኔው ኢንጄኔ ኡፋይሲ ጊዳና፤ ዳሮቲ ኢያ ዬሌቴꬃን ኡፋይታና። ");
INSERT INTO gofENT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","ጎዳ ሲንꬃን ኢ ጊታ ጊዳና፤ ዎይኔ ኡሻ ጊዲን ሃራ ማꬆያ ኡሻ ኡዬና። ባ ኣዬ ኡሎን ዴዒሼ ጌሻ ኣያናን ኩማና። ");
INSERT INTO gofENT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","ኢስራዔሌ ኣሳታፔ ዳሮታ ባንታ ጎዳ፥ ፆሳኮ ዛራና። ");
INSERT INTO gofENT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","ኣዋታ ዎዛና ናይታኮ ዛራና፥ ኪቴቶናይሳታ ፂሎታ ጪንጫቴꬃኮ ዛራና ሜላ፥ ጎዳስ ቤሲያ ዴሬ ጊጊሳናው ኤሊያሳ ኣያናኒኔ ዎልቃን ጎዳ ሲንꬃን ባና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","ዛካሪያሲ ኪታንቹዋኮ፥ «ታ ሄሳ ኣይቢን ኤራኔ? ታራኔ ታ ማቼራ ጪሚዳ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","ኪታንቾይ ዛሪዲ፥ «ታኒ ፆሳ ሲንꬃን ኤቂያ ጋብሬሌ። ሃ ሚሺራቹዋ ኔው ኦዳናው ፆሳፌ ኪቴታስ። ");
INSERT INTO gofENT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","ሄኮ፥ ዎዲያ ናጊዲ ፖሌቲያ ታ ቃላ ኔ ኣማኖና ኢፂዳ ጊሾ ሃይሲ ፖሌታና ጋካናው ኔኒ ሙሜ ጊዳና፥ ኦዴታናዉካ ዳንዳዓካ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","ሄ ዎዴ ዛካሪያሲ ፆሳ ኬꬂ ጌሊዲ ጋምዒዳ ጊሾ ኣይቢ ሃኒዴ ጊዲ ኣሳይ ካሬን ናጊሼ ጋምዒስ። ");
INSERT INTO gofENT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","ኢ ካሬ ኬዪዲ ኤንታና ኦዲሳናው ዳንዳዒቤና። ማሊ ቤሶፔ ኣቲን ኦዴታናው ዳንዳዖናይሳ ቤዒዳ ዎዴ ቆንጬꬂ ቤዒዳይሳ ኤሪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","ዛካሪያሲ ሃጋዞ ዎዲያ ፖሊዲ ባ ሶ ሲሚስ። ");
INSERT INTO gofENT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","ሄሳፌ ጉዬ፥ ኢያ ማቺያ ኤልሳቤፃ ቃንꬃታሱ። ኢቻሹ ኣጌና ኩሜꬂ ባና ጌንꬃዳ ጋምዓሱ። ");
INSERT INTO gofENT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","ኢያ፥ «ጎዳይ ባ ማሮታን ታ ቦሪያ ኣሳ ጊዶፌ ዲጋናው ቤዒዲ ሃ ዎዲያን ሃይሳ ኦꬂስ» ያጋሱ። ");
INSERT INTO gofENT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","ኤልሳቤፃ ቃንꬃቲን ኡሱፑንꬃ ኣጌናን፥ ፆሳይ ኪታንቹዋ ጋብሬሌ ጋሊላ ቢታን ዴዒያ ናዚሬቴ ካታማ ኪቲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ካዉዋ ዳዊቴ ሼሻፔ ጊዲዳ ዮሴፋ ጊያ ኡራስ ኦይሼቲዳ ጌላዔኮ ኪቲስ። ሄ ጌላዒያ ማይራሞ ጌቴታዉሱ። ");
INSERT INTO gofENT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","ኪታንቾይ ኢኮ ቢዲ፥ «ዳሮ ዶሴቲዳሬ፥ ሳሮይ ኔው ጊዶ፥ ፆሳይ ኔራ ዴዔስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","ማይራማ ኢያ ኦዳን ዳሮ ዳጋማዳ፥ «ሃይሲ ኣይቢ ሳሮꬆ» ጋዳ ሄታሱ። ");
INSERT INTO gofENT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","ኪታንቾይ ዛሪዲ፥ «ማይራሜ፥ ባቦፋ፤ ኔኒ ፆሳ ሲንꬃን ሳባ ዴማዳሳ። ");
INSERT INTO gofENT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","ሄኮ ኔኒ ቃንꬃታና ኣዴ ናዓ ዬላና፥ ኢያ ሱንꬃካ ዬሱሳ ጋዳ ሱንꬃና። ");
INSERT INTO gofENT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","ኢ ጊታ ጊዳና፥ ኡባፌ ቦላ ፆሳ ናዓ ጌቴቲ ፄጌታና። ጎዳ ፆሳይ ኢያ ኣዋ ዳዊቴ ኣራታ ኢያው ኢማና። ");
INSERT INTO gofENT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ኢ ያይቆባ ሼሻ ቦላ ሜሪናው ካዎታና፤ ኢያ ካዎቴꬃስ ዛዊ ባዋ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","ማይራማ ኪታንቹዋኮ፥ «ሄሲ ዋኒዲ ሃናኔ? ታ ኣዴ ኤሪኬ» ያጋሱ። ");
INSERT INTO gofENT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","ኪታንቾይ ዛሪዲ፥ «ጌሻ ኣያናይ ኔ ቦላ ዎꬋና፥ ኡባፌ ቦላ ፆሳ ዎልቃይ ኔ ቦላ ኩያታና። ሄሳ ጊሾ፥ ዬሌቲያ ጌሻ ናዓይ ፆሳ ናዓ ጌቴታና። ");
INSERT INTO gofENT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","ሄኮ፥ ኔ ዳቢያ ኤልሳቤፃ ባ ጪማቴꬃ ላይꬃን ኣዴ ናዓ ቃንꬃታሱ። ኢያ ማይንꬂ ጌቴቲዳሮ፥ ሺን ሃዒ ኡሱፑንꬃ ኣጌና ኦይካሱ። ");
INSERT INTO gofENT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","ፆሳ ፆኒያባይ ባዋ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","ማይራማ፥ «ሄኮ፥ ታኒ ጎዳ ኣይሊው፥ ኔ ቃላዳ ታው ሃኖ» ያጋሱ። ሄሳፌ ጉዬ፥ ኪታንቾይ ኢፔ ሻኬቲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","ማይራማ ሄ ሳሚንታን ዴንዳዳ ዪሁዳ ቢታን ዴዒያ ኢሲ ጌዜ ካታማ ባሱ። ");
INSERT INTO gofENT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","ዛካሪያሳ ሶ ጌላዳ ኤልሳቤፆ ሳሮꬃሱ። ");
INSERT INTO gofENT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","ኤልሳቤፃ ማይራሚ ሳሮꬁዋ ሲዒዳ ዎዴ ኢ ኡሉዋን ዴዒያ ናዓይ ኡፋይሳን ጉፒስ። ኤልሳቤፃ ጌሻ ኣያናን ኩማዳ፥ ");
INSERT INTO gofENT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ባ ቃላ ꬎቁ ኦꬃዳ፥ «ኔኒ ማጫሳ ጊዶፌ ኣንጄቲዳሮ፥ ኔ ቃንꬃቲዳ ናዓይካ ኣንጄቲዳይሳ። ");
INSERT INTO gofENT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","ሃኖሺን፥ ታ ጎዳ ኣዬ፥ ኔኒ ታኮ ያና ሜላ ታኒ ኦኔ? ");
INSERT INTO gofENT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","ሄኮ ኔ ሳሮꬁዋ ታ ሲዒዳ ዎዴ ታ ኡሉዋን ዴዒያ ናዓይ ኡፋይሳን ጉፒስ። ");
INSERT INTO gofENT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","ጎዳይ ፖላና ጊዲ ኢሚዳ ቃላ ኣማኒዳራ፥ ኢያ ኣንጄቲዳሮ» ያጋሱ። ");
INSERT INTO gofENT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","ማይራማ ሃይሳዳ ያጋሱ፡ «ታ ሼምፒያ ጎዳ ቦንቻዉሱ፥ ");
INSERT INTO gofENT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ታ ኣያናይ ꬋሊያ ፆሳን ኡፋይቴስ። ");
INSERT INTO gofENT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","ኢ ባ ኣይሌ ካዉሻቴꬃ ቤዒስ። ሃቺፌ ዶሚዲ ዬሌቴꬂ ኡባይ ታና ኣንጄቲዳሮ ጋና። ");
INSERT INTO gofENT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ኣይስ ጊኮ፥ ዎልቃማ ጊዲዳ ኢ፥ ታው ጊታባ ኦꬂስ። ኢያ ሱንꬃይ ጌሻ። ");
INSERT INTO gofENT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","ኢያ ቦንቼይሳታ ቦላ፥ ኢያ ማሮቴꬃይ ሜሪናፔ ሜሪና ጋካናሳ። ");
INSERT INTO gofENT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","ባ ቄሲያን ሚኖባ ኦꬂስ፥ ባንታ ዎዛናን ኦቶርቴይሳታ ላሊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","ዎልቃማ ካዎታ ኣራታፔ ካዉሺስ፤ ባንታና ካዉሺዳይሳታ ካቦይስ። ");
INSERT INTO gofENT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","ኮሻቲዳይሳታ ሎዖባን ካልሲስ፥ ሺን ዱሬታ ሜላ ኩሼ ዬዲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","ባ ማሮታ ቆፒዲ፥ ባ ኣይሊያ ኢስራዔሌ ማዲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ሄሲካ ኑ ኣዋታስ ኦዲዳ ቃላ፥ ኣብራሃሜሲኔ ኢያ ሼሻስ ጊዳይሳ ሜሪናው ፖላናሳ» ያጋሱ። ");
INSERT INTO gofENT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","ማይራማ ኤልሳቤፂ ማታን ሄꬑ ኣጌና ሜላ ጋምዓዳ ባ ሶ ሲማሱ። ");
INSERT INTO gofENT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","ኤልሳቤፂስ ዬሎ ቃማይ ጋኪን ኣዴ ናዓ ዬላሱ። ");
INSERT INTO gofENT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","ኢ ሾሮቲኔ ኢ ዳቦቲ ጎዳይ ጊታ ማሮታ ኦꬂዳይሳ ሲዒዲ፥ ኢራ ኢሲፌ ኡፋይቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","ሆስፑንꬃ ጋላሳን ዮጋ ናዓ ቃፃራናው ዪዶሶና። ኢያ ኣዋ ሱንꬃን ዛካሪያሳ ጊዲ ሱንꬃናው ኮዪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","ሺን ኣያ፥ «ኣካይ፥ ዮሃኒሳ ጌቴታናው ቤሴስ» ያጋሱ። ");
INSERT INTO gofENT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","ኤንቲካ፥ «ኔ ዳቦታፔ ሃ ሱንꬃን ፄጌቲዳይ ኦኒካ ባዋ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","ኢያ ኣዋይ ኦና ጊዲ ሱንꬃኔኮ ኤራናው ኮዪዲ ኢያ ማላ ኦይቺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","ኢ ፃፊያባ ኦይቺ ኤኪዲ፥ «ኢያ ሱንꬃይ ዮሃኒሳ» ጊዲ ፃፊስ። ኡባይ ኢ ፃፊዳይሳ ቤዒዲ ማላሌቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","ኢራ ዛካሪያሳ ኢንፃርሳይ ቢሌቲስ፥ ፆሳ ጋላቲሼ ኦዴቴꬂ ኦይኪስ። ");
INSERT INTO gofENT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","ሾሮቲ ኡባይ ያሻን ኩሚዶሶና። ሃ ሃኒዳባይ ጌዜ ዪሁዳ ቢታን ኦዴቲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","ሄሳ ሲዒዳ ኡባይ፥ «ሃ ናዓይ ኣይ ሃናንዴሻ» ጊዲ ባንታ ጊዶን ኦዴቲዶሶና። ጎዳ ኩሼይ ኢያራ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","ዮሃኒሳ ኣዋይ ዛካሪያሲ ጌሻ ኣያናን ኩሚዲ ሃይሳዳ ያጊዲ ቲንቢቴ ኦዲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«ኢስራዔሊያ ጎዳይ ጋላቴቶ፥ ዪዲ ባ ኣሳ ዎዚስ። ");
INSERT INTO gofENT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","ባ ኣይሊያ ዳዊቴ ኬꬃን ኣቶቴꬃ ካጪያ ዴንꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","ሄሲካ ቤኒ ዎዴ ጌሻ ናቤታ ዶናን ኦዴቲዳይሳ ሜላ፥ ");
INSERT INTO gofENT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ኢያ ኣሾይ ኑ ሞርኬታፔኔ ኑራ ኤቄቲያ ኡባ ኩሺያፔ። ");
INSERT INTO gofENT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","ሄሳ ኢ ኦꬂዳይ ኑ ኣዋታስ ባ ማሮታ ቤሳናሲኔ፥ ባ ጌሻ ጫቁዋ ናጋናሳ። ");
INSERT INTO gofENT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","ኑ ኣዋ ኣብራሃሜስ ጫቂዳ ጫቁዋ ቆፓናሲኔ ");
INSERT INTO gofENT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ኑ ሞርኬታ ኩሼፔ ኬሲዲ ያሺ ባይና ኢያ ሃጋዛና ሜላሳ። ");
INSERT INTO gofENT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ኑ ላይꬃ ኡባን ጌሻቴꬃኒኔ ፂሎቴꬃን ባ ሲንꬃን ኑና ኤሳናሳ። ");
INSERT INTO gofENT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","ቃሲ ላ ናዓው፥ ኔኒ ኡባፌ ቦላ ፆሳ ናቤ ጌቴታና። ጎዳ ኦጊያ ሎይꬃናው ኔ ኢያ ሲንꬃን ባና። ");
INSERT INTO gofENT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ኤንታ ናጋራይ ቁሼቲን፥ ኤንቲ ኣቶቴꬂ ዴማናይሳ ኔ ጎዳ ዴሪያስ ኦዳና። ");
INSERT INTO gofENT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ኑ ፆሳ ሎዖ ማሮቴꬃፌ ዴንዶይሳን ዎንታ ፃልቄይ ኑስ ሳሉዋፔ ኬዪስ። ");
INSERT INTO gofENT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ሄሲካ ꬉማኒኔ፥ ሃይቆ ኩያ ጋርሳን ዴዔይሳታስ ፖዒሳናሳ፥ ኑ ቶሁዋካ ሳሮ ኦጊያኮ ዛራናሳ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","ናዓይ ዲጪስ፥ ኣያናን ሚኒስ፥ ኢስራዔሌ ኣሳስ ቆንጫና ጋካናው ባዞ ቢታን ዴዒስ። ");
INSERT INTO gofENT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","ሄ ዎዴ ሮሜ ቢታን ዴዒያ ኣሳ ኡባይ ታይቤታና ሜላኔ ሱንꬃይ ፃፌታና ሜላ ካዎይ ኣዉጊስፆሲ ኪቲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","ሄሲካ ቄሬኖሲ ሶሬ ቢታ ኣይሲያ ዎዴ ኦሴቲዳ ኮይሮ ታይቡዋ። ");
INSERT INTO gofENT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","ሄሳ ጊሾ፥ ኢሲ ኢሲ ኣሲ ባ ሱንꬃ ፃፌታናው ባ ዬሌቲዳ ቢታ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","ዮሴፊካ ዳዊቴ ኬꬃፌኔ ያራፔ ጊዲዳ ጊሾ ጋሊላ ናዚሬቴ ካታማፔ ዴንዲዲ ዳዊቴ ካታማ ጊዲዳ ዪሁዳ ቤቴሌሜ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","ቢሼ፥ ዬላናው ዎዴይ ዉሪዳ ኢ ኦይቺ ዎꬂዳ፥ ማይራሚራ ዎላ ፃፌታናው ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","ኤንቲ ያን ዴዒሺን ኢው ዬሎ ዎዴይ ጋኪስ። ");
INSERT INTO gofENT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","ባ ባይራ ናዓ ዬላሱ። ጩርቃራ ፃፃዳ ኢማꬂ ኣቂያሶን ቤሲ ꬋዪዳ ጊሾ ዳራን ሜሄ ሙዚያ ጎንጌን ዚንዒሳሱ። ");
INSERT INTO gofENT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","ሄ ጋዲያን ቃማ ዶርሳ ዉዲያ ናጊሼ ካሬን ኣቂያ ሄንꬃንቾቲ ዴዖሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","ጎዳ ኪታንቾይ ሃሳዮና ዪዲ ኤንታ ማታን ኤቂስ። ጎዳ ቦንቾይ ኤንታ ዩሹዋን ፖዒስ፤ ኤንቲካ ዎልቃማ ያሺ ያዪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","ሺን ኪታንቾይ፥ «ያዮፊቴ! ሄኮ፥ ኣሳ ኡባስ ጊዲያ ጊታ ኡፋይሳ ሚሺራቹዋ ኤካዳ ያስ። ");
INSERT INTO gofENT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","ሄሲካ፥ ዳዊቴ ካታማን ኣሼይሲ ሂንቴው ሃቺ ዬሌቲስ። ኢ ጎዳ ኪሪስቶሳ። ");
INSERT INTO gofENT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","ዞቃሌ ናዓይ ጩርቃራ ፃፄቲዲ ጎንጌን ዚንዒዳይሳ ሂንቴ ዴማና፤ ሄሲካ ሂንቴው ማላ ጊዶ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","ቆፖና ዳሮ ሳሎ ኪታንቾቲ ኪታንቹዉራ ኢሲፌ ቆንጪዲ፥ ");
INSERT INTO gofENT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«ቦንቾይ ፆሳስ ꬎቃ ሳሉዋን፥ ሳሮይ ቢታ ቦላ ፆሳይ ዶሲያ ኣሳስ ጊዶ» ያጊዲ ጋላቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","ኪታንቾቲ ኤንታፌ ሻኬቲዲ ሳሉዋ ኬዪዳፔ ጉዬ ሄንꬃንቾቲ፥ «ኣኔ ጎዳይ ኑስ ቆንጪሲዳባኔ ሃኒዳባ ቤዓናው ቤቴሌሜ ቦስ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","ኤንቲካ ኤሌሲዲ ቢዶሶና። ማይራሞ፥ ዮሴፋኔ ዞቃሌ ናዓ ጎንጌን ዚንዒዳይሳ ቤዒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","ቤዒ ሲሚዲ ናዓባ ኤንታው ኦዴቶይሳ፥ ቆንጪሲዲ ሄ ቤሳን ዴዒያ ኣሳስ ማርካቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","ሄሳ ሲዒዳ ኡባይ ሄንꬃንቾቲ ኦዲዳይሳን ማላሌቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","ማይራማ ሃኒዳባ ኡባ ባ ዎዛናን ቆፓሼ ዴዓሱ። ");
INSERT INTO gofENT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","ሄንꬃንቾቲ ኤንታው ኦዴቲዳይሳዳ ሃኒን ቤዒዶሶና። ሄሳ ጊሾ፥ ባንታ ሲዒዳባሲኔ ቤዒዳባ ኡባስ ፆሳ ቦንቺሼኔ ጋላቲሼ ሲሚዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","ሆስፑንꬃ ቃማን፥ ቃፃሮ ዎዴይ ጋኪን፥ ኢ ቃንꬃታናፔ ሲንꬄ ኪታንቾይ ዎꬂዳ ሱንꬃን ዬሱሳ ጌቴቲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","ሙሴ ዎጋ ሜላ ኤንታ ጌሻቴꬃ ዎዴይ ፖሌቲዳፔ ጉዬ ዮሴፋራኔ ማይራሚራ ዮጋ ናዓ ባንታ ጎዳስ ኢማናው ዬሩሳላሜ ቢዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","ሄሲካ፥ ጎዳ ዎጋን፥ «ኣዴ ጊዲዳ ባይራ ናዒ ኡባይ ጎዳስ ዱማቲዳይሳ ጊዶ» ጌቴቲዲ ፃፌቲዳይሳ ፖላናሳ። ");
INSERT INTO gofENT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","ቃሲ ጎዳ ዎጋን፥ ናምዑ ኩራቾ ዎይኮ ሆሌ ያርሻናው ኤፊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","ሄ ዎዴ ጌሺኔ ኣማኖራ ሚኖ ጊዲዳ ሲሞና ጌቴቲያ ኣሲ ዬሩሳላሜን ዴዔስ። ኢ ኢስራዔሌታ ኣቶቴꬃ ናጊሼ ዴዔስ። ጌሻ ኣያናይካ ኢያ ቦላ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ቃሲ ኪሪስቶሳ ቤዖና ሃይቆናይሳ ጌሻ ኣያናይ ኢያው ቆንጪሲን ኤሪዲ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","ኢ ሄ ጋላስ ኣያናይ ካሌꬂን ፆሳ ኬꬂ ቢስ። ናዓ ኣዬራኔ ኣዋራ ዎጋ ፖላናው ዮጋ ናዓ ዬሱሳ ኤኪዲ ጌሊዳ ዎዴ ");
INSERT INTO gofENT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ሲሞኒ ሞኪ ኤኪዲ ናዓ ኢዲሚዲ፥ ");
INSERT INTO gofENT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«ጎዳው ኔ ታው ጌሊዳ ቃላ ሜላ፥ ሃዒ ኔ ኣይሊያ ሳሮን ሞይዛ። ");
INSERT INTO gofENT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","ታ ኣይፌይ ኣሳ ኡባ ሲንꬃን ኔ ጊጊሲዳ፥ ");
INSERT INTO gofENT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ኔ ኣሹዋ ቤዒስ። ");
INSERT INTO gofENT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","ሄሲካ ካዎቴꬃታ ኡባስ፥ ፆሳ ኦጊያ ቆንጪሲያ ፖዖ፥ ኔ ኣሳ ኢስራዔሌስካ ቦንቾ» ያጊዲ ፆሳ ጋላቲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","ዮሴፋራኔ ማይራሚራ ኢያው ኦዴቲዳባን ማላሌቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","ሲሞኒ ኤንታ ኣንጂስ። ኣዬ ማይራሚኮ፥ «ሄኮ ዳሮ ኣሳ ዎዛና ቆፋይ ቆንጫና ሜላ፥ ኢስራዔሌን ዴዒያ ዳሮታስ ኤንታ ኩንዴꬃሲኔ ዴንዱዋስ ፆሳን ዶሬቲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","ቃሲ ኤቄቴይሳታስ ማላ ጊዳና። ኔ ሼምፑዋራካ ቃሲ ማሺ ኣꬋና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","ቃሲ ኣሴሬ ያራፔ ጊዲዳ ፋኑዔላ ናዒያ ሃና ጌቴቲያ ናቤይ ዴዓዉሱ። ኢያ ዳሮ ጪማሱ፤ ኢያ ባ ኮይሮ ኣዚናራ ላፑን ላይꬂ ዴዓሱ። ");
INSERT INTO gofENT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ኢ ኣዚናይ ሃይቂን ሆስፑን ታማኔ ኦይዱ ላይꬂ ጊዳና ጋካናው ቃማኔ ጋላስ ፓጬይ ባይና ዎሳኒኔ ፆማን ፆሳ ኬꬃን ሃጋዛሱ። ");
INSERT INTO gofENT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","ኢያ ሄ ሳቲያን ባዳ ፆሳ ጋላታሱ፤ ዬሩሳላሜ ዎዜቴꬃ ናጊያ ኡባስ ዮጋ ናዓባ ማርካታሱ። ");
INSERT INTO gofENT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","ዮሴፋራኔ ማይራሚራ ጎዳ ሂጊያን ኪቴቲዳ ዎጋ ኡባ ፖሊዳፔ ጉዬ ጋሊላ ቢታን ዴዒያ ባንታ ካታማ ናዚሬቴ ሲሚዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","ናዓይ ዲጪሼኔ ሚኒሼ ቢስ። ጪንጫቴꬃን ኩሚስ፤ ፆሳ ኣꬎ ኬሃቴꬃይ ኢያ ቦላ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","ዮሴፋራኔ ማይራሚራ ፋሲካ ባሌ ቦንቻናው ላይꬃን ላይꬃን ዬሩሳላሜ ቦሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","ዬሱሳስ ታማኔ ናምዑ ላይꬂ ጊዲያ ዎዴ ካሴ ሜዜቲዳይሳዳ ባሊያ ቦንቻናው ቢዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","ባሊያ ቦንቺዳፔ ጉዬ ሶ ሲሚያ ዎዴ ናዓይ ዬሱሲ ዬሩሳላሜን ኣቲስ። ሺን ዮሴፋራኔ ማይራሚራ ኢ ዬሩሳላሜን ኣቶይሳ ኤሪቦኮና። ");
INSERT INTO gofENT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","ኢ ሶ ሲሚያ ኣሳራ ዎላ ዴዒያ ዳኒን ኤንቲ ኢሲ ጋላሳ ኦጌ ቢዶሶና። ኢ ባይናይሳ ኤሪዳፔ ጉዬ ባንታ ዳቦታኔ ላጌታ ማታን ኮዪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ኢ ያን ꬋዪን ኮዪሼ ጉዬ ዬሩሳላሜ ጋካናው ቢዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","ሄꬑ ጋላሳፔ ጉዬ ፆሳ ኬꬃን ኣስታማሬታ ጊዶን ኡቲዲ ኤንታባ ሲዒሼኔ ኤንታ ኦይቺሼ ዴዒሺን ዴሚዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","ኢያ ሲዒያ ኡባይ ኢያ ኣኬካኒኔ ዛሩዋን ማላሌቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","ሶ ኣሳይ ኢያ ዴሚዳ ዎዴ ማላሌቲዶሶና። ኢያ ኣያካ፥ «ታ ናዓው፥ ኣይስ ኑና ሃይሳዳ ኦꬃዲ? ኔ ኣዋራኔ ታራ ኔና ኮዪሼ ኡንዔቲዳ» ያጋሱ። ");
INSERT INTO gofENT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","ዬሱሲ ኤንታኮ፥ «ታና ኣይስ ኮዬቲ? ታ፥ ታ ኣዋ ኬꬃን ዳናው ቤሴይሳ ኤሬኬቲ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","ሺን ኢ ኤንታኮ ጊዳባ ኤንቲ ኣኬኪቦኮና። ");
INSERT INTO gofENT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","ሄሳፌ ጉዬ፥ ኤንታራ ኢሲፌ ናዚሬቴ ካታማ ቢስ። ኤንታው ኪቴቲሼ ዴዒስ። ኢያ ኣያ ሄ ኡባ ባ ዎዛናን ዎꬃዳ ናጋሱ። ");
INSERT INTO gofENT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","ዬሱሲ፥ ጪንጫቴꬃን፥ ጌሳኒኔ ቴማን ፆሳ ሲንꬃኒኔ ኣሳ ሲንꬃን ዲጪስ። ");
INSERT INTO gofENT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","ካዎይ ፂባርዮሲ ሮሜ ቢታን ካዎቲን፥ ታማኔ ኢቻሻንꬆ ላይꬃን፥ ጴንፄ ጲላፆሲ ዪሁዳ ሃሪያ ዎዴ ሄሮዲሲ ጋሊላ ሃሪያ ዎዴ ኢያ ኢሻ ፊልጶሲ ኢፁሪያሳኔ ፂራኮንዶሳ ሃሪያ ዎዴ ሊሳኒዮሲ ኣብላኒሳ ሃሪያ ዎዴ ");
INSERT INTO gofENT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","ሃናራኔ ቃያፋራ ካሂኔ ሃላቃ ጊዲ ዴዒሺን፥ ፆሳ ቃላይ ዛካሪያሳ ናዓ ዮሃኒሳኮ ባዞ ቢታ ዪስ። ");
INSERT INTO gofENT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","ዮሃኒሲ፥ «ሂንቴ ናጋራፔ ሲሚቴኔ ፃማቄቲቴ። ፆሳይ ሂንቴ ናጋራ ኣቶ ጋና» ያጊዲ ታማርሲሼ ዮርዳኖሴ ሻፋ ሄራን ዴዒያ ቢታ ኡባ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","ሄሲካ ናቤይ ኢሳያሲ ባ ማፃፋን፥ «ባዞ ጊዶን ባ ቃላ ꬎቁ ኦꬂዲ፥ ዋሲያ ኡራ ቃላይ፥ ‹ጎዳ ኦጊያ ጊጊሲቴ፥ ሆሮጋካ ፒዲ ኦꬂቴ። ");
INSERT INTO gofENT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","ኣፎ ኡባይ ኩማና፥ ዙማይኔ ዴሬይ ዚቂ ጋና። ዎቤ ኦጌይ ሉላና፥ ጊጎና ሆሮጋይ ቂንፂ ጋና። ");
INSERT INTO gofENT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","ኣሾ ማዒዳ ኡባይ፥ ፆሳ ኣሹዋ ቤዓና› » ጊዲ ፃፊዳይሳዳ ሃኒስ። ");
INSERT INTO gofENT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","ዮሃኒሲ፥ ባ ኩሼን ፃማቄታናው ዪዳ ኣሳኮ፥ «ሂንቴኖ፥ ሾሻ ናይቶ ያናው ዴዒያ ሃንቁዋፌ ኣታና ሜላ ሂንቴና ዞሪዳይ ኦኔ? ");
INSERT INTO gofENT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","ሂዛ፥ ሂንቴ ሲሙዋ ቆንጪሲያ ሎዖ ኦሶ ኦꬂቴ፥ ሂንቴ ዎዛናን፥ ‹ኑስ፥ ኑ ኣዋይ ኣብራሃሜይ ዴዔስ ጊዲ ጬቄቶፊቴ።› ሃ ሲዒቴ፥ ሃ ሹቻታፔ ፆሳይ ኣብራሃሜስ ናዓ ኬሳናው ዳንዳዔስ። ");
INSERT INTO gofENT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","ሄኮ፥ ቤፄይ ሚꬃ ፃጶን ዴዔስ። ሂዛ፥ ሎዖ ኣይፌ ኣይፎና ሚꬃ ኡባይ ቃንፄቲዲ ታማን ዬጌታና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","ኣሳይ፥ «ያቲን ኑኒ ኣይ ኦꬂኖ?» ያጊዲ ኦይቺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","ዮሃኒሲ ዛሪዲ፥ «ናምዑ ኣፊሊ ዴዒያ ኣሲ ባይናይሳስ ኢሞ። ካꬂ ዴዔይሲ ባይናይሳስ ኢሞ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","ቃራፃ ቃንፂሴይሳቲ ፃማቄታናው ዪዲ፥ «ኣስታማሪያው፥ ኑኒ ኣይ ኦꬂኖ?» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","ኢ ዛሪዲ፥ «ሂንቴ ቃንፂሳናው ኪቴቶይሳፌ ኣꬂዲ ኤኮፊቴ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","ቃሲ ዎታዳሬቲ ዪዲ፥ «ኑኒ ኣይ ኦꬂኖ» ያጊዲ ኦይቺዶሶና። ዮሃኒሲ፥ «ኦዴባካ ዎልቃን ዳፊዲ ኤኮፊቴ፥ ኦናካ ዎርዶን ሞቶፒቴ፥ ሂንቴ ዳሞዜይ ሂንቴው ጊዶ፤ ኡፋይቲዲ ዴዒቴ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","ኣሳይ ኪሪስቶሳ ናጊሼ ዴዒያ ጊሾ ዮሃኒሳ፥ «ኢ ኪሪስቶሳ ጊዳንዴሻ?» ጊዲ ቆፒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","ዮሃኒሲ ኡባስ ዛሪዲ፥ «ታኒ ሂንቴና ሃꬃን ፃማቃይስ፥ ሺን ታፔ ኣꬊዲ ዎልቃሜይሲ ያና። ታኒ ኢያ ጫማ ዎዶሩዋ ቢላናው ቤሶና ኣሲ። ኢ ሂንቴና ጌሻ ኣያናኒኔ ታማን ፃማቃና። ");
INSERT INTO gofENT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","ዉዱማን ዴዒያ ካꬃ ፖሎ ጌሻናው ፒꬄይ ኢያ ኩሼን ዴዔስ። ጌሻ ካꬃ ባ ሻሊያን ቆላና፤ ካሊያ ꬋዮና ታማን ፁጋና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","ቃሲ ዮሃኒሲ ኣሳ ዳሮ ዞሬ ዞሪዲ ዎንጌላ ኦዲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","ሺን ዮሃኒሲ ሄሮዲሲ ባ ኢሻ ማቺው፥ ሄሮዲያዳ፥ ኤኪዳ ጊሾኔ ሃራ ኢታ ኦሶታ ጊሾ ካጪዳ ዎዴ ");
INSERT INTO gofENT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","ሄሮዲሲ ካሴይሳ ቦላ ሃራባ ኡባ ጉጂዲ ዮሃኒሳ ዎይኔ ጌልሲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","ዮሃኒሲ ቃሼታናፔ ሲንꬄ ኣሳ ኡባ ፃማቂዲ ሲሚን፥ ዬሱሲካ ቃሲ ፃማቄቲስ። ኢ ዎሲሺን ሳሎይ ዶዬቲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ጌሻ ኣያናይ ሆሌዳ ቤንቲሼ ኢያ ቦላ ኡቲስ። ሳሎፔ «ታኒ ዶሲያ ናዓይ ኔና፤ ኔ ታና ኡፋይሳሳ ያጊያ» ቃላይ ዪስ። ");
INSERT INTO gofENT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","ዬሱሲ ታማርሶ ኦይኪያ ዎዴ ኢያው ሃስታሙ ላይꬂ ጊዲሺን፥ ኣሳይ ኢያ ዮሴፋ ናዓ ጊዲ ቆፒስ። ዮሴፊ ኤሌ ናዓ፥ ");
INSERT INTO gofENT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ኤሌይ ማቴ ናዓ፥ ማቴይ ሌዌ ናዓ፥ ሌዌይ ማልካ ናዓ፥ ማልኬይ ዮና ናዓ፥ ዮኒ ዮሴፋ ናዓ፥ ");
INSERT INTO gofENT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ዮሴፊ ማታቴ ናዓ፥ ማታቴይ ኣሞፄ ናዓ፥ ኣሞፄይ ናሆሜ ናዓ፥ ናሆሜይ ኣሲሊሜ ናዓ፥ ኣሲሊሜይ ናጌ ናዓ፥ ");
INSERT INTO gofENT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ናጌይ ማዓቴ ናዓ፥ ማዓቴይ ማታቲዬ ናዓ፥ ማታቲዬይ ሳማዬ ናዓ፥ ");
INSERT INTO gofENT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ሳማዬይ ዪሁዳ ናዓ፥ ዪሁዲ ዮናኔ ናዓ፥ ዮናኔይ ራሴ ናዓ፥ ራሴይ ዜሩባቤላ ናዓ፥ ዜሩባቤሌይ ሳላቲያሌ ናዓ፥ ሳላቲያሌይ ኔሬ ናዓ፥ ");
INSERT INTO gofENT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ኔሬይ ማልካ ናዓ፥ ማልኬይ ሃዴ ናዓ፥ ሃዴይ ቆሳሜ ናዓ፥ ቆሳሜይ ኤልሞዳኔ ናዓ፥ ኤልሞዳኔይ ኤሬ ናዓ፥ ");
INSERT INTO gofENT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ኤሬይ ዮሴዔ ናዓ፥ ዮሴዔይ ኣላዛራ ናዓ፥ ኣላዛሪ ዮራሜ ናዓ፥ ዮራሜይ ማቴ ናዓ፥ ማቴይ ሌዌ ናዓ፥ ");
INSERT INTO gofENT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ሌዌይ ሲሞና ናዓ፥ ሲሞኒ ዪሁዳ ናዓ፥ ዪሁዲ ዮሴፋ ናዓ፥ ዮሴፊ ዮናኔ ናዓ፥ ዮናኔይ ኤሊያቄሜ ናዓ፥ ");
INSERT INTO gofENT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ኤሊያቄሜይ ማሊዬ ናዓ፥ ማሊዬይ ማይናኔ ናዓ፥ ማይናኔይ ማቴ ናዓ፥ ማቴይ ናታኔ ናዓ፥ ናታኔይ ዳዊቴ ናዓ፥ ");
INSERT INTO gofENT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ዳዊቴይ ኢሴዬ ናዓ፥ ኢሴዬይ ኢዮቤዴ ናዓ፥ ኢዮቤዴይ ቦዔዛ ናዓ፥ ቦዔዚ ሳልሞና ናዓ፥ ሳልሞኔይ ናዓሶና ናዓ፥ ");
INSERT INTO gofENT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ናዓሶኔይ ኣሚናዳቤ ናዓ፥ ኣሚናዳቤይ ራሜ ናዓ፥ ራሜይ ኣርኔ ናዓ፥ ኣርኔይ ኣስሮሜ ናዓ፥ ");
INSERT INTO gofENT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ኣስሮሜይ ፋሬሴ ናዓ፥ ፋሬሴይ ዪሁዳ ናዓ፥ ዪሁዲ ያይቆባ ናዓ፥ ያይቆቢ ዪሳቃ ናዓ፥ ዪሳቂ ኣብራሃሜ ናዓ፥ ኣብራሃሜይ ታራ ናዓ፥ ");
INSERT INTO gofENT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ታሪ ናኮሬ ናዓ፥ ናኮሬይ ሳሩጌ ናዓ፥ ሳሩጌይ ሬሁ ናዓ፥ ሬሁይ ፋሌቄ ናዓ፥ ፋሌቄይ ኤቤራ ናዓ፥ ኤቤሮይ ሴላ ናዓ፥ ");
INSERT INTO gofENT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ሴሊ ቃይናሜ ናዓ፥ ቃይናሜይ ኣርፋኪሳዳ ናዓ፥ ኣርፋኪሳዴይ ሴሜ ናዓ፥ ሴሜይ ኖሄ ናዓ፥ ኖሄይ ላሜሄ ናዓ፥ ");
INSERT INTO gofENT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ላሜሄይ ማቱሳላ ናዓ፥ ማቱሳሊ ሄኖኬ ናዓ፥ ሄኖኬይ ያሬዴ ናዓ፥ ያሬዴይ ማላልዔላ ናዓ፥ ማላልዔሊ ቃይናኔ ናዓ፥ ");
INSERT INTO gofENT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ቃይናኔይ ሄኖሳ ናዓ፥ ሄኖሴይ ሴታ ናዓ፥ ሴቴይ ኣዳሜ ናዓ፥ ኣዳሜይ ፆሳ ናዓ። ");
INSERT INTO gofENT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","ዬሱሲ ጌሻ ኣያናን ኩሚዲ ዮርዳኖሴ ሻፋፔ ሲሚዳ ሜላ ኣያናይ ኢያ ባዞ ኤፊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","ያን ኦይታሙ ጋላሲኔ ቃማ ፃላሄን ፓጬቲስ። ሄ ጋላሳታን ኣይኮካ ሞና ጋምዒዳ ጊሾ ዉርሴꬃን ኮሻቲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","ፃላሄይ ኢያኮ፥ «ኔኒ ፆሳ ናዓ ጊዲኮ ኣኔ ሃይሲ ሹቻይ ኡይꬁ ጊዶ ጋዳ ኪታ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","ዬሱሲ ዛሪዲ፥ «ኣሲ ኡይꬃ ፃላላን ዴና ጌቴቲዲ ፃፌቲስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","ሄሳፌ ጉዬ፥ ፃላሄይ ዬሱሳ ኣዱሳ ዴሬ ቦላ ኬሲዲ ሃ ኣላሚያ ካዎቴꬃታ ኣይፌ ቂጲ ዛራናው ቤሲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","ፃላሄይ፥ «ሃ ኡባስ ማታይኔ ቦንቾይ ታው ኢሜቲስ። ታኒ ዶሲዳ ኦዴስካ ኢሚያ ጊሾ ኔው ኢማና። ");
INSERT INTO gofENT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","ሄሳ ጊሾ፥ ኔኒ ታው ጎይኒኮ ኡባይ ኔው ጊዳና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","ዬሱሲ ዛሪዲ፥ «ኔ ጎዳ፥ ኔ ፆሳ፥ ኢያ ፃላላ ጎይና ጌቴቲዲ ፃፌቲስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","ዉርሴꬃን ፃላሄይ ዬሱሳ ዬሩሳላሜ ኤፊዲ ፆሳ ኬꬃስ ሁዒያ ቦላ ኤሲዲ፥ «ኔኒ ፆሳ ናዓ ጊዲኮ ኣኔ ዱጌ ሳዓን ኔና ዬጋ። ");
INSERT INTO gofENT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","ኣይስ ጊኮ፥ ‹ኔና ናጊያ ኪታንቾታ ፆሳይ ኔ ጊሾ ኪታና። ");
INSERT INTO gofENT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ኤንቲ ኔ ቶሆይ ሹቻን ꬉቤቶና ሜላ፥ ባንታ ኩሺያን ꬎቁ ኦꬂዲ ኔና ዴንꬃና› ጌቴቲዲ ፃፌቲስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","ዬሱሲ ዛሪዲ፥ «ኔ ጎዳ ፆሳ ፓጮፋ ጌቴቲዲ ፃፌቲስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","ፃላሄይ ዬሱሳ ፓጪያ ዉርሲዳፔ ጉዬ ሃራ ኢንጄ ዎዴ ዴማና ጋካናው ኢያፔ ሻኬቲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","ዬሱሲ ኣያና ዎልቃን ኩሚዲ ጋሊላ ሲሚስ። ኢያ ሱንꬃይ ሄራን ዴዒያ ቢታ ኡባን ኬዪስ። ");
INSERT INTO gofENT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","ኢ ኣይሁዴ ዎሳ ኬꬂ ጌሊዲ ታማርሲስ፤ ኣሳ ኡባይ ኢያ ጋላቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","ያፔ ኢ ዲጪዳ ካታማ ናዚሬቴ ዪስ። ካሴ ሜዜቲዳይሳዳ ሳምባታ ጋላስ ኣይሁዴ ዎሳ ኬꬂ ጌሊስ። ናባባናዉካ ዴንዲ ኤቂስ። ");
INSERT INTO gofENT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ናቢያ ኢሳያሳ ማፃፋይ ኢያው ኢሜቲን፥ ዶዪዲ፥ ሃይሳዳ ያጊዲ ፃፌቲዳይሳ ዴሚስ፡ ");
INSERT INTO gofENT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«ጎዳ ኣያናይ ታ ቦላ ዴዔስ፥ ማንቆታስ ዎንጌላ ኦዳና ሜላ ፆሳይ ታና ዶሪስ። ቃሼቲዳይሳታስ ቢሌቴꬂ፥ ቆቂዳይሳታ ፄሊሳናሲኔ ኡንዔቲዳይሳታ ቢርሻና ሜላ፥ ");
INSERT INTO gofENT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ፆሳይ ኬሃናው ቆፒዳ ላይꬃ ኦዳና ሜላ ታና ኪቲስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","ሄሳፌ ጉዬ፥ ማፃፋ ፃፂዲ ሃጋዜይሳስ ኢሚዲ ታማርሳናው ኡቲስ። ኣይሁዴ ዎሳ ኬꬃን ዴዒያ ኣሳቲ ኡባይ ጫዲ ፄሎሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","ኢ፥ «ሃይሲ ሂንቴ ሃይꬃን ሂንቴ ሲዒያ ሃ ማፃፋ ቃላይ ሃቺ ፖሌቲስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","ኡባይ ኢያባ ዳርሲዲ ኦዴቶሶና። ቃሲ ኢያ ዶናፔ ኬያ ኣꬎ ኬሃቴꬃን ኩሚዳ ቃላን ማላሌቲሼ፥ «ሃይሲ ዮሴፋ ናዓ ጊዴኔዬ?» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","ኢ፥ « ‹ኔኖ ꬋሌ ኣዋው ኔና ኣሻ፥ ቂፊርናሆሜን ኔ ኦꬂዳባ ኑ ሲዖይሳ ቃሲ ሃይሳን ኔ ካታማን ኦꬃ› ያጊያ ሌሚሱዋን ሂንቴ ታና ጋናይሳስ ሲꬌይ ባዋ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","ቃሲ፥ «ቱማ ኦዳይስ፤ ናቤይ ባ ዬሌቲዳ ቢታን ቦንቼቴና። ");
INSERT INTO gofENT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","«ታ ሂንቴው ቱማ ኦዳይስ፤ ሳሎይ ሄꬑ ላይꬂኔ ባጋ ጎርዴቲን ሚኖ ኮሺ ቢታ ኡባን ዴዒያ ኤሊያሳ ዎዴ ዳሮ ኣምዔቲ ኢስራዔሌን ዴዖሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","ኤሊያሲ ኤንታፌ ኢሲኔኮካ ኪቴቲቤና። ሺን ሳራፕታን ዴዒያ ኣምዔኮ ኪቴቲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","ናቢያ ኤልሳዔ ዎዴ ኢስራዔሌን ዳሮ ባሮ ሃርጋንቾቲ ዴዖሶና። ሺን ሶሬ ኡራ ኒዒማኔፔ ኣቲን ኦኒካ ፓፂቤና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","ኣይሁዴ ዎሳ ኬꬃን ዴዒያ ኣሳ ኡባይ ሄሳ ሲዒዳ ዎዴ ዳሮ ዪሎቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","ባንታ ኡቲዳ ቤሳፌ ዴንዲዲ ዙማ ቦላ ኬፄቲዳ ካታማፔ ጋፃ ኬሲዲ ሱጊ ዬዳናው ኣፎ ዶና ኤፊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","ሺን ኢ ኤንታ ጊዶራ ካንꬂዲ ኣꬊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","ያፔ ጋሊላ ቢታን ዴዒያ ቂፊርናሆሜ ካታማ ቢስ። ያን ሳምባታ ጋላስ ኣሳ ታማርሲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","ኢ ታማርሴይ ማታራ ጊዲያ ጊሾ ኡባይ ኢያ ቲሚርቲያን ማላሌቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","ኣይሁዴ ዎሳ ኬꬃን ቱና ኣያናይ ኦይኪዳ ኡራይ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","ኢ፥ «ናዚሬቴ ዬሱሳ ኑና ኣይስ ዋይሳይ ኑፔ ሃካ፤ ኔኒ ዪዳይ ኑና ꬋይሳናሴዬ? ኔኒ ኦኔኮ ታኒ ኤራይስ። ኔኒ ፆሳፌ ዪዳ ጌሻ» ያጊዲ ዋሲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","ዬሱሲ ቱና ኣያናኮ፥ «ሲዒ ጋዳ ሃ ኡራፔ ኬያ» ያጊዲ ሃንቂስ። ቱና ኣያናይ ኡራ ኣሳ ኡባ ሲንꬃን ሆሊ ዬጊዲ ኣይኮካ ቆሆና ዬዲዲ ኬዪስ። ");
INSERT INTO gofENT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","ኣሳ ኡባይ ማላሌቲዶሶና። ዎሊኮ፥ «ሃኖስ፥ ሃይሲ ኣይቢ ቲሚርቴ? ቱና ኣያናታ ማታኒኔ ዎልቃን ኪቴስ፤ ኤንቲካ ኬዮሶና» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","ኢያ ሱንꬃይ ሄራ ኡባን ኬዪስ። ");
INSERT INTO gofENT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","ሄሳፌ ጉዬ፥ ዬሱሲ ኣይሁዴ ዎሳ ኬꬃፌ ኬዪዲ ሲሞና ሶ ጌሊስ። ሲሞና ማቼ ኣያ ሚኖ ቆፆ ሚሻ ሃርጌን ሳኬታሱ። ኢዮ ፓꬃና ሜላ ዬሱሳ ዎሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","ኢ ሂፃኮ ሺቂ ሆኪዲ ኢ ሃርጊያ ሃንቂስ። ሚሻይ ኣጊን ኤሌሳ ዴንዳዳ ኤንታ ሞካሱ። ");
INSERT INTO gofENT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","ኣዋይ ዉላና ሃኒሺን ዱማ ዱማ ሃርጊያን ኦይኬቲዳ ኣሳ ኢያኮ ኤሂዶሶና። ኢ ኢሱዋ ኢሱዋ ቦላ ባ ኩሺያ ዎꬂዲ ፓꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","ቱና ኣያናቲ ቃሲ፥ «ኔኒ፥ ፆሳ ናዓ» ጊዲ ዋሲሼ ዳሮ ኣሳፔ ኬዪዶሶና። ሺን ኢ ኤንታና ሃንቂስ። ኢ ኪሪስቶሳ ጊዴይሳ ኤንቲ ኤሪያ ጊሾ ኢሲባካ ኦዴቶና ሜላ ዲጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","ቡሮ ዎንቲያ ዎዴ ዬሱሲ ኢሲ ጌማ ቤሲ ቢስ። ኣሳይ ኮዪሼ ኢ ዴዒያ ቤሳ ዪዶሶና። ኤንታፌ ኢ ሻኬቲዲ ቦና ሜላ ቡቴቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","ሺን ኢ፥ «ታኒ ሃራ ካታማታ ባዳ ፆሳ ካዎቴꬃ ዎንጌላ ማርካታናው ቤሴስ። ታ ኪቴቲዳይ ሄሳሳ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","ዪሁዳ ቢታን ዴዒያ ኣይሁዴ ዎሳ ኬꬃን ሳባኪስ። ");
INSERT INTO gofENT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","ኢሲ ጋላስ ዬሱሲ ጌንሳሬፄ ኣባ ማታን ኤቂዳሺን ዳሮ ኣሳይ ኢያ ዩሹዋ ኡንዔꬂዲ፥ ኢ ታማርሲያ ፆሳ ቃላ ሲዖሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","ያን ሃꬃ ጋፃን ዴዒያ ናምዑ ዎጎሎታ ቤዒስ። ሞሎ ኦይኪያ ኣሳቲ ዎጎሎታፔ ዎꬊዲ ባንታ ጊቲያ ሜጮሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","ሄ ዎጎሎታፔ ሲሞናይሳን ጌሊዲ ቢታፌ ጉꬂ ጊዶ ሺሻና ሜላ ኦይቺስ። ያቲዲ፥ ሄ ዎጎሉዋ ቦላ ኡቲዲ ኣሳ ታማርሲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","ባ ታማርሱዋ ኦንጊዳፔ ጉዬ ሲሞናኮ፥ «ጌዴ ጪሙዋኮ ሺሻዳ ሞሉዋ ኦይካናው ሂንቴ ጊቲያ ዬጊቴ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","ሲሞኒ ዛሪዲ፥ «ኣስታማሪያው፥ ቃማ ኩሜꬃ ዳቡሪሼ ኣቂዲ ኣይኮካ ኦይኪቦኮ፥ ሺን ኔ ጊኮ ጊቲያ ዬጋና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","ኤንቲ ጊቲያ ዬጊዳ ዎዴ ጊቴይ ዳኬታና ጋካናው ዳሮ ሞሎ ኦይኪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","ሃራ ዎጎሉዋን ዴዒያ ባንታ ላጌቲ ዪዲ፥ ባንታና ማዳና ሜላ ዉቲዲ ፄጊዶሶና። ኤንቲ ዪዲ ናምዑ ዎጎሎታ፥ ሃꬃን ሚቴታና ጋካናው ሞሎን ኩንꬂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","ሲሞን ጴፂሮሲ ሄሳ ቤዒዳ ዎዴ ዬሱሳ ሲንꬃን ኩንዲዲ፥ «ጎዳው፥ ታኒ ናጋራንቾ ኣሲ ጊዲያ ጊሾ ታፔ ሻኬታ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","ሄሳ ኢ ጊዳይ ኢኔ ኢያራ ዴዔይሳቲ ኦይኪዳ ሞሉዋ ዳሮቴꬃን ማላሌቲዳ ጊሾሳ። ");
INSERT INTO gofENT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","ቃሲ ሲሞና ላጌ ጊዲዳ ዛብዲዮሳ ናይቲ ያይቆባራኔ ዮሃኒሳራ ማላሌቲዶሶና። ዬሱሲ ሲሞናኮ፥ «ባቦፋ! ሂዛፔ ኔኒ ኣሴ ኦይኪያ ኣሲ ጊዳና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","ኤንቲ ዎጎሎታ ጋፃ ሺሺዳፔ ጉዬ ኡባ ኣጊዲ ዬሱሳ ካሊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","ዬሱሲ ካታማታፔ ኢሱዋን ዴዒሺን ኢሲ ባሮ ሃርጌን ኦይኬቲዳ ኣሲ ሄ ካታማን ዴዔስ። ሄ ኡራይ ዬሱሳ ቤዒዲ ኢያ ሲንꬃን ጉፋኒዲ፥ «ጎዳው፥ ኔ ሼኔ ጊዲኮ ታና ጌሻናው ዳንዳዓሳ» ጊዲ ዎሲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","ዬሱሲ ባ ኩሺያ ዬዲ ቦቺዲ፥ «ኤ፥ ታ ሼኔ፤ ጌያ» ያጊስ። ኢራ ባሮ ሃርጌይ ኡራፔ ኪቺስ። ");
INSERT INTO gofENT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","ዬሱሲ፥ «ሃይሳ ኦዴስካ ኦዶፓ፥ ሺን ባዳ ኔናቴꬃ ኣይሁዴ ካሂኒያ ቤሳ። ኔ ጌዪዳይሳስ ማርካ ጊዳና ሜላ ሙሴይ ኪቲዳ ያርሹዋ ያርሻ» ጊዲ ኪቲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","ጊዶሺን፥ ኢያ ሱንꬃይ ካሴፔ ኣꬊዲ ዳልጊሼ ቢስ። ዳሮ ኣሳይ ኢ ኦዲያባ ሲዓናዉኔ ባንታ ሃርጊያፌ ፓፃናው ዮሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","ሺን ዬሱሲ ዳሮ ዎዴ ጌማ ቤሲ ቢዲ ዎሴስ። ");
INSERT INTO gofENT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","ኢሲ ጋላስ ዬሱሲ ታማርሲሺን ጋሊላፔኔ ዪሁዳ ሄራ ኡባፌ ቃሲ ዬሩሳላሜፔካ ዪዳ ፋሪሳዌቲኔ ሂጌ ኣስታማሬቲ ያን ኡቲዶሶና። ኣሳ ፓꬂያ ጎዳ ዎልቃይካ ኢያራ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","ሄ ዎዴ ኣሳይ ኢሲ ጉንዳ ኣሲ ሃላራ ቶኪዲ ኤሂዶሶና። ሶ ጌልሲዲ ኢያ ሲንꬃን ዎꬃናው ቆፒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","ሺን ኣሳ ዳሮቴꬃፌ ዴንዶይሳን ሶ ጌልሳናው ፆኔቲዲ ኬꬃ ቦላ ኬዪዲ፥ ካራ ቃዉፂዲ፥ ሃርጋንቹዋ ሃላራ ኣሳ ሻኪዲ ዬሱሳ ሲንꬃን ዬጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","ዬሱሲ ኤንታ ኣማኑዋ ቤዒዲ፥ «ላ ኣዲያው፥ ኔ ናጋራይ ቁሼቲስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","ሂጌ ኣስታማሬቲኔ ፋሪሳዌቲ፥ «ሃይሲ ፆሳ ቦላ ያጊዲ ኦዴቴይ ኦኔ? ኢሲ ፆሳፌ ኣቲን ሃሪ ናጋራ ቁቻናው ዳንዳዔይ ኦኔ?» ያጊዲ ቆፒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","ዬሱሲ ኤንታ ቆፋ ኤሪዳ ጊሾ ኤንታኮ፥ «ሂንቴ ዎዛናን ሄሳꬆ ኣይስ ቆፔቲ? ");
INSERT INTO gofENT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","‹ኔ ናጋራይ ቁሼቲስ ጌይሳፌኔ ዴንዳዳ ባ ጌይሳፌ ኣዉሲ ካዉዪ?› ");
INSERT INTO gofENT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","ሺን ታ ሄሳ ጊዳይ ኣሳ ናዓይ ሳዓ ቦላ ናጋራ ቁቻናው ማቲ ዴዔይሳ ሂንቴ ኤራና ሜላሳ።» ሄሳፌ ካሊዲ፥ ጉንዳ ኡራኮ፥ «ዴንዳ፤ ኔ ኣልጋ ቶካዳ ኔ ሶ ባ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","ኢ ኤሌሲ ዴንዲዲ ኤንታ ሲንꬃን ኤቂስ፤ ኢ ቶኬቲዲ ዪዳ ኣልጋ ቶኪዲ ፆሳ ጋላቲሼ ባ ሶ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","ሄ ዎዴ ኡባይካ ማላሌቲዶሶና። ፆሳ ጋላቲሼ፥ «ሃቺ ጊታ ማላታ ቤዒዳ» ያጊዲ ያሼቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","ሄሳፌ ጉዬ፥ ዬሱሲ ያፔ ኬዪዲ ቢስ። ሌዌ ጌቴቲያ ኢሲ ቃራፃ ቃንፂሴይሲ ቃራፃ ቃንፂሲያ ቤሳን ኡቲዳይሳ ቤዒዲ፥ «ታና ካላ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","ኢ ኡባባ ኣጊ ዴንዲዲ ኢያ ካሊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","ሄ ሌዌይ ባ ሶን ጊታ ጊቢራ ጊጊሲስ። ዳሮ ቃራፃ ቃንፂሴይሳቲኔ ሃራ ኣሳቲ ካꬃ ማናው ኡቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","ፋሪሳዌቲኔ ሂጌ ኣስታማሬቲ፥ «ቃራፃ ቃንፄይሳታራኔ ናጋራንቾታራ ኣይስ ሜቲኔ ኡዬቲ?» ያጊዲ ዬሱሳ ታማሬታ ቦላ ዙዙሚዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","ዬሱሲ ኤንታኮ፥ «ሃርጋንቾታሳፌ ኣቲን ፓፃታስ ኣኪሜ ኮሼና። ");
INSERT INTO gofENT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","ታኒ ናጋራንቾታ ማሮታኮ ዛራናሳፌ ኣቲን ጌሻታ ፄጋናው ያቢኬ» ያጊዲ ዛሪስ። ");
INSERT INTO gofENT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","ኤንቲ ዬሱሳኮ፥ «ዮሃኒሳ ታማሬቲ ዳሮ ዎዴ ፆሞሶና፥ ዎሶሶና፤ ቃሲ ፋሪሳዌታ ታማሬቲካ ሄሳꬆ ኦꬆሶና። ሺን ኔይሳቲ ኡባ ዎዴ ሞሶናኔ ኡዮሶና» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","ዬሱሲ ኤንታኮ፥ «ሙሹራይ ኤንታራ ዴዒሺን ፄጌቲዳ ኣሳይ ፆማና ሜላ ኦꬃናው ዳንዳዔቲ? ");
INSERT INTO gofENT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","ሺን ሙሹራይ ኤንታፌ ሻኬታና ጋላሳይ ያና፥ ሄ ዎዴ ኤንቲ ፆማና።» ");
INSERT INTO gofENT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","ቃሲ ያጊዲ ሌሚሶ ኦዲስ፤ «ኦራꬃ ማዖፔ ፔꬊዲ ጋልዓ ማዖ ቦላ ሲኬይ ኦኒካ ባዋ። ሄሳꬆ ኦꬂኮ ኦራꬃ ማዑዋ ፔꬌስ፥ ኦራꬃይ ጋልዓስ ጊጌና። ");
INSERT INTO gofENT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","ማልዓንቶ ዎይኒያ ጋልዓ ኦጎሮን ቆሊያ ኦኒካ ባዋ። ሄሳ ኦꬂኮ፥ ኦራꬃ ዎይኔይ ጋልዓ ኦጎሩዋ ꬉሴስ፤ ዎይኔይ ጉኬስ ኦጎሮይካ ማዶናባ ጊዴስ። ");
INSERT INTO gofENT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","ሄሳ ጊሾ፥ ኦራꬃ ዎይኔይ ኦራꬃ ኦጎሮን ቆሌታናው ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","ሂዛ፥ ጫላይ ሎዖ ጊያ ጊሾ ጫላ ዎይኔ ኡዪ ሲሚዲ ማልዓንቶ ኮዬይ ኦኒካ ባዋ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","ኢሲ ሳምባታ ጋላስ ዬሱሲ ጊስቴ ጋዴ ጊዶራ ኣꬌስ። ዬሱሳ ታማሬቲ ቲያ ባንጋ ዱꬂዲ ባንታ ኩሼን ሺርኪዲ ሞሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","ሺን ፋሪሳዌታ ጊዶፌ ኢሶቲ ኢሶቲ፥ «ሳምባታ ጋላስ ኦꬃናው ቤሶናባ ኣይስ ኦꬄቲ?» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","ዬሱሲ ኤንታኮ ዛሪዲ፥ «ዳዊቴይ ኮሻቲዳ ዎዴ ባራ ዴዔይሳታራ ኢሲፌ ኦꬆይሳ ናባቢቤኬቲ? ");
INSERT INTO gofENT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","ፆሳ ኬꬂ ጌሊዲ ኣይሁዴ ካሂኔታ ፃላላስ ቤሲያ ዳቡዋ ሚስ፤ ባራ ዴዔይሳታስካ ኢሚስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","ቃሲ ዬሱሲ፥ «ኣሳ ናዓይ ሳምባታ ጎዳ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","ሃራ ሳምባታ ጋላስ ዬሱሲ ኣይሁዴ ዎሳ ኬꬂ ጌሊዲ ታማርሴስ። ሄ ቤሳን ኡሻቻ ኩሼይ ጉንዲዳ ኢሲ ኣሲ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","ሂጌ ኣስታማሬቲኔ ፋሪሳዌቲ ኢያ ሞታናው ጋሶ ኮዪዲ ሳምባታ ጋላስ ፓꬂኮ ቤዓና ጊዲ ናጎሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","ሺን ዬሱሲ ኤንታ ቆፋ ኤሪዲ ኩሼይ ጉንዲዳ ኡራኮ፥ «ዴንዳዳ ኣሳ ጊዱዋን ኤቃ» ያጊስ። ኡራይካ ዴንዲ ኤቂስ። ");
INSERT INTO gofENT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","ዬሱሲ፥ «ኣኔ ታ ሂንቴና ኢሲባ ኦይቻይስ፤ ሳምባታ ጋላስ ኦꬃናው ቤሴይ ሎዖባዬዬ ኢታባዬ? ሼምፖ ኣሾዬ ዎይኮ ꬋይሶ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","ቃሲ ዬሱሲ ኢያ ዩሹዋን ዴዒያ ኣሳ ዩሺ ፄሊዲ ኡራኮ፥ «ኔ ኩሺያ ፒዲ ኦꬃ» ያጊስ። ኡራይካ ኢ ጊዳይሳዳ ኦꬂን ኩሼይ ፓፂስ። ");
INSERT INTO gofENT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","ሺን ሂጌ ኣስታማሬቲኔ ፋሪሳዌቲ ዳሮ ዪሎቲዶሶና። ዬሱሳ ቦላ ኣይ ኦꬂኖ ጊዲ ባንታ ጊዶን ማቄቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","ሄ ዎዴ ጋላሳታፔ ኢሱዋን ዬሱሲ ዎሳናው ዴሪያ ቦላ ኬዪስ። ቃማ ኩሜꬃ ፆሳ ዎሲሼ ኣቂስ። ");
INSERT INTO gofENT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","ዎንቴꬄ ባ ታማሬታ ፄጊዲ ኤንታ ጊዶፌ ታማኔ ናምዓታ ዶሪዲ፥ ኤንታና፥ «ሃዋሬታ» ጊዲ ሱንꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","ኤንቲካ፥ ጴፂሮሳ ጊዲ ሱንꬂዳ ሲሞና፥ ኢያ ኢሻ ኢንዲሪያሳ፥ ያይቆባ፥ ዮሃኒሳ፥ ፊልጶሳ፥ ባርቶሎሚዮሳ፥ ");
INSERT INTO gofENT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ማቶሳ፥ ቶማሳ፥ ኢልፊዮሳ ናዓ ያይቆባ፥ ባ ቢታስ ሚሼቲያ ሲሞና፥ ");
INSERT INTO gofENT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ያይቆባ ናዓ ዪሁዳኔ ዬሱሳ ኣꬂ ኢሚዳ ኣስቆሮታ ዪሁዳ። ");
INSERT INTO gofENT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","ዬሱሲ ኤንታራ ኢሲፌ ዴሪያፔ ዎꬊዲ ዴንባ ቤሳን ኤቂስ። ኢያ ታማሬታፔ ዳሮቲ ሄ ቤሳን ዴዖሶና ዪሁዳ ቢታ ኡባፌ ዬሩሳላሜፔ፥ ፂሮሳፔኔ ሲዶና ኣባ ጋፃፔ ዪዳ ዳሮ ኣሳይ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","ኤንቲ ዪዳይ ኢ ታማርሲያባ ሲዓናዉኔ ባንታ ሃርጊያፌ ፓፃናሳ። ቱና ኣያናን ዋዬቲያ ኣሳቲካ ፓፂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","ዎልቃይ ኢያፔ ኬዪዲ ኣሳ ኡባ ፓꬂያ ጊሾ ኣሳይ ኢያ ቦቻናው ኮዮሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","ባ ታማሬታኮ ፄሊዲ ሃይሳዳ ያጊስ፡ «ሂንቴኖ፥ ማንቆቶ፥ ሂንቴ ኣንጄቲዳይሳታ፤ ፆሳ ካዎቴꬃይ ሂንቴሳ። ");
INSERT INTO gofENT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","ሂንቴ ሃዒ ኮሻቴይሳቲ ኣንጄቲዳይሳታ፥ ሂንቴ ካላና። ሂንቴ ሃዒ ዬኬይሳቲ ኣንጄቲዳይሳታ ሂንቴ ሚጫና። ");
INSERT INTO gofENT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","ኣሳይ ሂንቴና ኣሳ ናዓ ጊሾ ኢፂያ ዎዴ ሂንቴና ሂሊያ ዎዴ ሂንቴና ኤንቲ ቶቺያ ዎዴኔ፥ ኢታ ሱንꬂ ኤንቲ ሂንቴው ኢሚያ ዎዴ ሂንቴ ኣንጄቲዳይሳታ። ");
INSERT INTO gofENT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","«ሄኮ፥ ሂንቴ ዎይቶይ ሳሎን ጊታ ጊዲያ ጊሾ ሄ ዎዴ ኡፋይሳን ጉፒቴ። ኣይስ ጊኮ፥ ቤኒ ኤንታ ኣዋቲ ናቤታ ቦላ ሄሳዳ ኦꬂዶሶና።» ");
INSERT INTO gofENT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","«ሺን ዱሬቶ ሂንቴና ኣዬ፤ ሂንቴ ሃዒ ሎዖ ዱሳ ኤኪዴታ። ");
INSERT INTO gofENT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","ሃዒ ካሊዳይሳቶ ሂንቴና ኣዬ፤ ሂንቴ ኮሻታና። ሃዒ ሚጬይሳቶ ሂንቴኖሾ ሂንቴ ካዮታናኔ ዬካና። ");
INSERT INTO gofENT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","ኣሲ ኡባይ ሂንቴ ሎዖቴꬃ ፃላላ ኦዲያ ዎዴ ሂንቴና ኣዬ። ኤንታ ኣዋቲ ቤኒ ዎርዳንቾ ናቤታ ቦላ ሄሳዳ ኦꬂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","«ሺን ታና ሲዒያ ሂንቴስ ታ ኦዳይስ፤ ሂንቴ ሞርኬታ ሲቂቴ፤ ሂንቴና ኢፄይሳታስ ሎዖባ ኦꬂቴ። ");
INSERT INTO gofENT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","ሂንቴና ቃንጌይሳታ ኣንጂቴ፥ ሂንቴና ናቄይሳታስ ዎሲቴ። ");
INSERT INTO gofENT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","ኢሲ ባጋ ሻካላ ባቄይሳስ ሃንኮ ባጋካ ቤሳ። ኔ ላፃና ኤካና ጌይሳስ ኔ ሻሚዚያካ ጉጃዳ ኢማ። ");
INSERT INTO gofENT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","ኔና ዎሲያ ኡባስ ኢማ፤ ኔፔ ኤኪዳ ኦናካ ዛሮ ጋዳ ኦይቾፋ። ");
INSERT INTO gofENT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","ኣሳይ ሂንቴው ኦꬃና ሜላ ሂንቴ ኮያባ ኡባ ሂንቴካ ኣሳስ ኦꬂቴ። ");
INSERT INTO gofENT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","«ሂንቴ ሂንቴና ዶሲያ ኣሳታ ፃላላ ዶሲኮ፥ ኣይ ጋላቲ ሂንቴው ዴዒ? ሃሪ ኣቶሺን፥ ናጋራንቾቲካ ባንታና ሲቄይሳታ ሲቆሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","ሂንቴው ሎዖባ ኦꬄይሳታ ፃላላስ ሎዖባ ኦꬂኮ ሂንቴው ኣይ ጋላቲ ዴዒ? ናጋራንቾቲካ ሄሳዳ ኦꬆሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","ታልዔ ዛራና ኣሳ ፃላላስ ሂንቴ ታልዒኮ ኣይ ዱማ ጋላቴቴቲ? ናጋራንቾቲካ ጉዬ ዛራና ኣሲ ቤዒዲ ታልዖሶና።» ");
INSERT INTO gofENT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","«ሺን ሂንቴ ሞርኬታ ሲቂቴ፤ ኤንታው ሎዖባ ኦꬂቴ። ጉዬ ኤካናው ቆፖና ታልዒቴ። ሄሳን ሂንቴ ኤካና ዎይቶይ ጊታ ጊዳና። ሂንቴ ኡባፌ ቦላ ፆሳ ናይታ ጊዳና። ኢ ባና ጋላቶናይሳታሲኔ ኢታታስ ኬሃ። ");
INSERT INTO gofENT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","ሂንቴ ኣዋይ ኬሃ ጊዶይሳዳ ሂንቴካ ኬሃ ጊዲቴ። ");
INSERT INTO gofENT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","«ኣሳ ቦላ ፒርዶፊቴ፤ ሂንቴ ቦላ ፒርዴቴና። ሂንቴ ቦሬቶና ሜላ ኦናካ ቦሮፒቴ። ኣቶ ጊቴ፤ ፆሳይ ሂንቴው ኣቶ ጋና። ");
INSERT INTO gofENT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","ኢሚቴ፤ ሂንቴው ኢሜታና። ሂንቴ ማኪዳባን ሂንቴው ዛሪ ማኬታና፥ ኡባራካ ሎዖ ማኪያባን ባቂዲ፥ ሱዲ ኩንꬂዲ፥ ላሌታና ጋካናው ሂንቴው ማኬቲ ኢሜታና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","ቃሲካ ዬሱሲ ያጊዲ ኤንታው ሌሚሶ ኦዲስ፤ «ቆቄይ ቆቄ ካሌꬃናው ዳንዳዒ? ካሌꬂኮ ናምዓይካ ዎሊ ኤኪዲ ኣፎን ዉሎኮናዬ? ");
INSERT INTO gofENT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","ታማሬይ ኣስታማሬፔ ኣꬌና። ሺን ሎይꬂ ታማሪዳ ኡራይ ባ ኣስታማሪያꬆ ሃኔስ። ");
INSERT INTO gofENT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","«ኔ ኢሻ ኣይፊያን ዴዒያ ቡሪያ ኣይስ ቤዓይ? ኔ ኣይፊያን ዴዒያ ቱሲ ዳኔይሳ ኣይስ ቤዒኪ? ");
INSERT INTO gofENT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","ኔ ኣይፊያን ዴዒያ ቱሲ ዳኔይሳ ቤዖና ኔ ኢሻኮ፥ ‹ታ ኢሻው ኔ ኣይፊያን ዴዒያ ቡሪያ ኬሶ› ጋናው ዋና ዳንዳዓይ? ኔኖ ጩቡዋው፥ ኮይሮታዳ ኔ ኣይፊያን ዴዒያ ቱሲ ዳኔይሳ ኬሳ። ሄሳፌ ጉዬ፥ ኔ ኢሻ ኣይፊያን ዴዒያ ቡሪያ ኬሳናው ጌሻዳ ፄላና። ");
INSERT INTO gofENT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","«ሎዖ ሚꬂ ኢታ ኣይፌ ኣይፌና፤ ሄሳዳካ ኢታ ሚꬂ ሎዖ ኣይፌ ኣይፌና። ");
INSERT INTO gofENT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","ኣይፌ ኣይፊያ ሚꬂ ኡባይ ባ ኣይፊያን ኤሬቴስ። ኣጉንꬃፌ ባላሴ ሚꬃ ኣይፌይ ማፄቴና ቃሲ ላዴፔ ዎይኔ ኣይፌይ ማፄቴና። ");
INSERT INTO gofENT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","ሎዖ ኣሲ ባ ዎዛናን ኩሚዳ ሎዖባፔ ሎዖባ ኬሴስ። ኢታ ኣሲ ባ ዎዛናን ኩሚዳ ኢታባፔ ኢታባ ኬሴስ። ኣሲ ባ ዎዛናን ኩሚዲ ፓላሂዳባፔ ባ ዶናን ሃሳዬስ። ");
INSERT INTO gofENT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","«ታ ጌይሳ ኦꬄኬታ፥ ሺን ያቲን ኣይስ ታና፥ ‹ጎዳው፥ ጎዳው፥ ጌቲ?› ");
INSERT INTO gofENT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","ታኮ ዬይኔ ታ ቃላ ሲዒዲ ፖሊያ ኡባይ ኦና ዳኒያኮ ታ ሂንቴና ቤሳና። ");
INSERT INTO gofENT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","ኢ ኬꬄ ኬፃናው ዚቂ ኦꬂ፥ ኦላ ቦኪዲ፥ ጋርሳን ዴዒያ ዛላ ቦላ ኬꬃ ኤሲዳ ጪንጫ ኡራ ዳኔስ። ዲዖይ ዲዒዲ ሄ ኬꬃ ሱጊስ፥ ሺን ሚንꬂዲ ኬፂዳ ጊሾ ቃፃናው ዳንዳዒቤና። ");
INSERT INTO gofENT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","ሺን ታ ቃላ ሲዒዲ ኦꬆናይ ባ ኬꬃ ሻፌ ቢታ ቦላ ኬፂዳ ኡራ ዳኔስ። ዲዖይ ዲዒዲ ሄ ኬꬃ ሱጊዳ ዎዴ ኤሌሲዲ ኩንዲስ። ሄ ኬꬃይ ዎልቃማ ኩንዴꬂ ኩንዲስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","ዬሱሲ ሄሳ ኡባ ኣሳ ሲንꬃን ታማርሲዲ ኦንጊዳፔ ጉዬ፥ ቂፊርናሆሜ ካታማ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","ሄ ቤሳን ኢሲ ማቶ ሃላቃይ ዴዔስ። ኢ ዳሮ ዶሲያ ኣይሌይ ሃርጌቲዲ ሃይቆስ ጋኪስ። ");
INSERT INTO gofENT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","ኢ ዬሱሳባ ሲዒዳ ዎዴ ባ ኣይሊያ ፓꬃና ሜላ ኢያ ዎሶ ጊዲ ኢሲ ኢሲ ኣይሁዴ ጪማታ ዬሱሳኮ ኪቲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","ኪቴቲዳይሳቲ፥ ዬሱሳኮ ቢዲ፥ «ኔ ኢያው ሃይሳ ኦꬃናው ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ኣይስ ጊኮ፥ ሃ ኡራይ ኑ ኣሳ ዶሴስ፥ ኣይሁዴ ዎሳ ኬꬃካ ኬፂስ» ጊዲ ሚንꬂ ዎሲዶሶና ");
INSERT INTO gofENT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","ዬሱሲካ ኤንታራ ቢስ። ማቶ ሃላቃ ሶኮ ማቲያ ዎዴ ባ ላጌታ ኢያኮ ኪቲዲ፥ «ጎዳው፥ ታ ካራፔ ጋርሳን ኔ ጌላናው ታ ቤሶና ጊሾ ዳቡሮፓ። ");
INSERT INTO gofENT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","ታካ ታና ኔ ሲንꬄ ሺቃናው ቤሲያ ኣሲ ጋዳ ቆፒኬ። ሺን ኔ ኢሲ ቃላ ኦዳ፤ ታ ኣይሌይ ፓፃና። ");
INSERT INTO gofENT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","ታው ታፔ ቦላራ ሃላቃይ ዴዔስ፥ ታፔ ጋርሳን ታ ኪቲያ ዎታዳሬቲ ዴዖሶና። ኢሱዋ፥ ‹ባ› ጊኮ ቤስ፥ ሃንኩዋ፥ ‹ሃያ› ጊኮ ዬስ። ታ ኣይሊያኮ፥ ‹ሃኖ ኦꬃ› ጊኮ ኦꬄስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","ዬሱሲ ሄሳ ሲዒዳ ዎዴ ማላሌቲስ። ጉዬ ሲሚዲ ባራ ያ ኣሳኮ፥ «ታኒ ሂንቴው ቱማ ኦዳይስ፤ ሃሪ ኣቶሺን ኢስራዔሌንካ ሃይሳ ሜላ ጊታ ኣማኖ ዴማቢኬ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","ኪቴቲዳይሳቲ ሶ ሲሚያ ዎዴ ኣይሌይ ፓፂን ዴሚዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","ጉꬃ ዎዴፔ ጉዬ ዬሱሲ ናይኔ ካታማ ቢስ። ኢያ ታማሬታራኔ ሃራ ዳሮ ኣሳቲ ኢያራ ቢዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","ኢ ካታማ ጌላና ሃኒያ ዎዴ ኣሃ ቶኪዳ ዳሮ ኣሳቲ ካታማፔ ኬዮሶና። ሃይቂዳ ናዓይ ባ ኣዬስ ኢሱዋ፥ ኢያካ ኣምዖ ጊዳዳ ዳዓዉሱ። ካታማ ኣሳፔ ዳሮቲ ኢራ ዴዖሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","ጎዳይ ኢዮ ቤዒዳ ዎዴ ቃꬌቲዲ፥ «ዬኮፋ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","ሺቂዲ ሃላ ቦቺን ቶኪዳ ኣሳቲ ኤቂዶሶና። ዬሱሲ፥ «ላ፥ ያላጋው ዴንዳ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","ሃይቂዳይሲ ዴንዲ ኡቲዲ ኦዳ ኦይኪስ። ዬሱሲ ናዓ ኤኪዲ ኣዬስ ኢሚስ። ");
INSERT INTO gofENT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","ኣሳ ኡባይ ያሼቲዲ፥ «ጊታ ናቤይ ኑ ጊዶን ዴንዲስ፤ ፆሳይ ባ ኣሳ ቤዒስ» ያጊዲ ፆሳ ጋላቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","ኢያ ሱንꬃይ ዪሁዳኒኔ ሄ ሄራን ዴዒያ ቢታ ኡባን ሲዔቲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","ፃማቂያ ዮሃኒሳ ታማሬቲ ሄሳ ኡባ ዮሃኒሳስ ኦዲዶሶና። ኢ ኤንታ ጊዶፌ ናምዓታ ፄጊዲ፥ ");
INSERT INTO gofENT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","«ያና ጌቴቲዳይ ኔኔዬ? ዎይኮ ሃራ ናጊኖ?» ያጊዲ ኦይቺቴ ጊዲ ጎዳኮ ኪቲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","ኣሳቲ ዬሱሳኮ ቢዲ፥ ፃማቂያ ዮሃኒሲ፥ «ያና ጌቴቲዳይ ኔኔዬ? ዎይኮ ሃራ ናጊኖ?» ጊቴ ጊዲ ኑና ኔኮ ኪቲስ ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","ሄ ሳቴንካ ዬሱሲ ዳሮ ኣሳ ሃርጊያፌ ፓꬂስ። ቱና ኣያናታ ኬሲስ፥ ቆቂዳ ኣይፊያካ ፄሊሲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","ዮሃኒሳ ማታፔ ኪቴቲዲ ዪዳይሳታኮ፥ «ቢዲ ሂንቴ ቤዒዳይሳኔ ሲዒዳይሳ ዮሃኒሳስ ኦዲቴ። ኣይፌ ቆቄቲ ፄሎሶና፥ ጉንዳቲ ቢርሼቲዲ ሃሙቶሶና፥ ባሮ ሃርጋንቾቲ ጌዮሶና፥ ቱሌቲ ሲዖሶና፥ ሃይቂዳይሳቲ ሃይቆፔ ዴንዶሶና፥ ማንቆታስ ዎንጌላይ ሳባኬቴስ። ");
INSERT INTO gofENT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","ታናን ꬉቤቶና ኦኒካ ኣንጄቲዳይሳ።» ");
INSERT INTO gofENT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","ዮሃኒሲ ኪቲዳይሳቲ ቢዳፔ ጉዬ ዬሱሲ ኣሳስ ዮሃኒሳባ ያጊዲ ኦዲስ፡ «ሂንቴ ኣይ ቤዓናው ባዞ ቢታ ኬዪዴቲ? ጫርኮይ ቃꬂያ ማታ ቤዓናሴዬ? ");
INSERT INTO gofENT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","ያቲን፥ ኣይ ቤዓናው ኬዪዴቲ? ኮይሴ ማዖ ማዒዳ ኣሳ ቤዓናሴዬ? ኮይሴ ማዖ ማዒዳይሳቲኔ ሳዒ ኢንጄቲዳ ኣሳይ ካዎ ኬꬃን ዴዖሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","ያቲን፥ ኣይ ቤዓናው ኬዪዴቲ? ናቢያ ቤዓናሴዬ? ኤ፥ ታ ያጋይስ፡ ሂንቴ ቤዓናው ኬዪዳይ ናቤፔ ኣꬌይሳ። ");
INSERT INTO gofENT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","‹ኔ ኦጊያ ኔ ሲንꬃን ጊጊሲያ ታ ኪታንቹዋ ኔፔ ሲንꬄ ታ ኪታና› ጌቴቲዲ ፃፌቲዳይ ኢያሳ። ");
INSERT INTO gofENT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","ታ ሂንቴው ኦዳይስ፤ ማጫሳፔ ዬሌቲዳይሳታ ጊዶፌ ዮሃኒሳፔ ኣꬌይ ባዋ። ፆሳ ካዎቴꬃን ኡባፌ ጉፄይሲ፥ ኢ ኡባፌ ጊታ ጊዳና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","ሃሪ ኣቶሺን፥ ዬሱሳ ቃላ ሲዒዳ ቃራፃ ቃንፂሴይሳቲ ኡባይ ዮሃኒሳ ኩሼን ፃማቄቲዲ ፆሳይ ፂሎ ጊዴይሳ ቆንጪሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","ሺን ፋሪሳዌቲኔ ሂጌ ኣስታማሬቲ ዮሃኒሳ ኩሼን ፃማቄቶና ኢፂዲ ፆሳ ዞሪያ ሌቂሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","ዬሱሲ ካሊዲ ሃይሳዳ ያጊስ፡ «ሂዛ፥ ሃ ዎዲያ ዬሌቴꬃ ኣይቢራ ዳኒሶ? ኤንቲካ ኦና ዳኖና? ");
INSERT INTO gofENT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","ጊያ ጊዶን ኡቲዲ ዎሊ ፄጊዲ፥ ‹ኑ ሂንቴው ሱሱልዔ ፑኒን፥ ሂንቴ ዬፄኬታ። ኑ ሳቢዲ ዜሌሊን፥ ሂንቴ ዬኬኬታ› ያጊያ ናይታ ዳኖሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","ፃማቂያ ዮሃኒሲ ሞናኔ ኡዮና ዪን፥ ‹ኢታ ኣያናራ ዴዔስ ጊዴታ።› ");
INSERT INTO gofENT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","ኣሳ ናዓይ ሚሼኔ ኡዪሼ ዪን፥ ‹ያራምባኔ ኡሻንቾ፥ ቃራፃ ቃንፂሴይሳታኔ ናጋራንቾታ ዳቦ› ጊዴታ። ");
INSERT INTO gofENT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","ሂዛ፥ ጪንጫቴꬃ ቱማቴꬃይ ኢያ ናይታ ኡባ ማታን ኤሬቲስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","ኢሲ ፋሪሳዌይ ዬሱሳ ካꬂ ሙዛናው ባ ሶ ፄጊስ። ኢ ፋሪሳዊያ ሶ ቢዲ ጋይታ ቦላ ኡቲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","ሄ ካታማን ኢሲ ናጋራንቾ ማጫሲ ዴዒያራ ዬሱሲ ፋሪሳዊያ ሶን ጊቢራ ቦላ ዴዔይሳ ሲዒዳ ዎዴ ዳሮ ኣልዖ ጲልቃፄ ሺቶ ኤካዳ ያሱ። ");
INSERT INTO gofENT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","ዬሱሳስ ጉዬ ባጋራ፥ ኢያ ቶሁዋ ማታን ኤቃዳ ዬካሼ ኢያ ቶሁዋ ባ ኣፉꬃራ ላኬꬃውሱ። ባ ቢናናራ ኢያ ቶሁዋ ቁቻሼኔ ዬራሼ ሺቶ ቲያሱ። ");
INSERT INTO gofENT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","ጊቢራ ጊጊሲዳ ፋሪሳዌይ ሄሳ ቤዒዳ ዎዴ ባ ዎዛናን፥ «ሃይሲ ናቤ ጊዲያኮ ሃ ማጫሲያ ኢያ ቦቺያራ ኦኔኮ ቃሲ ኢያ ናጋራንቾ ጊዴይሳካ ኢ ኤራናሺን» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","ዬሱሲ፥ «ሲሞና፥ ታ ኔው ኦዲያባይ ዴዔስ» ያጊስ። ኢ፥ «ኣስታማሪያው፥ ታው ኦዳ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","ዬሱሲ ኢያኮ፥ «ናምዑ ኣሳቲ ኢሲ ኡራፔ ሚሼ ታልዒዶሶና። ኢሶይ ኢቻሹ ፄቱ ቢራ ሃንኮይ ቃሲ ኢሻታሙ ቢራ ታልዒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","ናምዓይካ ታልዒያ ጪጋናው ፆኔቲን፥ ናምዓታስካ ታልዒያ ማሪስ። ሂዛ፥ ሃ ናምዓታፔ ሄ ኡራ ዳሮ ዶሳናይ ኔው ኣዉሳ ዳኒ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","ሲሞኒ፥ «ዳሮ ኣጮይ ማሬቲዳ ኡራይ ዳሮ ዶሳና ዳኔስ» ያጊስ። ዬሱሲ፥ «ኔ ቱማ ፒርዳዳሳ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","ሄሳፌ ጉዬ፥ ዬሱሲ ማጫሴኮ ሲሚ ፄሊዲ፥ ሲሞናኮ፥ «ሃኖ ማጫሲው ቤዓይ? ታኒ ኔ ሶ ጌሊን ሃሪ ኣቲን ኔ ታው ቶሆ ሃꬄ ኢማባካ፥ ሺን ኢያ ታ ቶሁዋ ባ ኣፉꬃን ላኮꬃዳ ባ ቢናናን ቁቻሱ። ");
INSERT INTO gofENT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","ኔኒ ታና ዬራ ኤካባካ፥ ሺን ኢያ ታ ኔ ሶ ጌሎዴፔ ዶማዳ ታ ቶሁዋ ዬሮ ኣጋቡኩ። ");
INSERT INTO gofENT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","ኔኒ ታ ሁዒያን ዛይቴ ቲያባካ፥ ሺን ኢያ ታ ቶሁዋ ሺቶ ቲያዉሱ። ");
INSERT INTO gofENT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","ኢያ ታና ዳሮ ዶሲዳ ጊሾ ኢ ዳሮ ናጋራይ ኣቶ ጌቴቲስ። ኢያ ጉꬃ ናጋራይ ኣቶ ጌቴቲዳይ ጉꬃራ ዶሴስ።» ");
INSERT INTO gofENT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","ዬሱሲ ማጫሴኮ፥ «ኔ ናጋራይ ኣቶ ጌቴቲስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","ኢያራ ኢሲፌ ጋይታን ኡቲዲ ሚያ ኢማꬃቲ፥ «ናጋራ ኣቶ ያጌይ፥ ኢ ሃይሲ ኦኔ?» ያጊዲ ባንታ ዎዛናን ቆፒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","ዬሱሲ ማጫሴኮ፥ «ኔ ኣማኖይ ኔና ኣሺስ፤ ሳሮ ባ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","ሄሳፌ ጉዬ፥ ዬሱሲ ፆሳ ካዎቴꬃ ዎንጌላ ሳባኪሼ ካታማራኔ ጉታራ ኣꬊስ። ሄ ዎዴ ታማኔ ናምዑ ሃዋሬቲ ኢያራ ዴዖሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ቃሲ ቱና ኣያናፔኔ ዱማ ዱማ ሃርጊያፌ ፓፂዳ ኢሲ ኢሲ ማጫሳቲ ኢያራ ዴዖሶና። ኤንቲካ፥ ላፑን ቱና ኣያናቲ ኬዪዳ ማግዴላ ማይራሞ፥ ");
INSERT INTO gofENT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ሄሮዲሳ ሹማ ኩዛ ማቺው ዮሃና፥ ሶሲናራኔ ቃሲ ሃራ ዳሮቲ ኤንታና ሚሼን ማዴይሳቲ ዴዖሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","ዳሮ ኣሳይ ዱማ ዱማ ካታማፔ ኢያኮ ሺቂን ሌሚሶን ኤንታው ኦዲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«ኢሲ ጎሻንቾይ ዜሬꬂ ዜራናው ኬዪስ። ኢ ዜሪሺን ኢሲ ኢሲ ዜሬꬃይ ኦጌ ጋፃን ዎꬊዲ ዬꬌቲስ፥ ሳሎ ካፎቲ ማፂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","ሃራቲ ሻሎይ ጋርሳን ዴዒያ ቢታ ቦላ ዎꬊዶሶና። ቡሮ ዶሊዳ ሜላ ቢታን ላሆይ ባይና ጊሾ ሚጪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","ሃራ ዜሬꬃይ ቃሲ ኣጉንꬃ ጊዶን ዎꬊስ። ኣጉንꬃራ ዎላ ዲጪዳ ጊሾ ኣጉንꬃይ ጩሊዲ ቤሳን ኣሺስ። ");
INSERT INTO gofENT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","ሃራቲ ሎዖ ቢታ ቦላ ዎꬊዶሶና። ዶሊዳ ዎዴ ፄቱ ኩሼ ኣይፊዶሶና።» ሄሳ ኦዲ ኦንጊዲ፥ ባ ቃላ ꬎቁ ኦꬂዲ፥ «ሲዒያ ሃይꬂ ዴዒያ ኡባይ ሲዖ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","ኢያ ታማሬቲ፥ «ሃ ሌሚሱዋ ቢርሼꬃይ ኣይቤ?» ያጊዲ ኦይቺዶሶና ");
INSERT INTO gofENT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","ኢ፥ «ፆሳ ካዎቴꬃ ፁራ ኤራና ሜላ ሂንቴው ኢሜቲስ። ሺን ሃራቲ ቤዒሼ ዴሞና ሜላ፥ ሲዒሼ ኣኬኮና ሜላ ሌሚሶን ኦዳይስ። ");
INSERT INTO gofENT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","«ሂዛ፥ ሃ ሌሚሱዋ ቢርሼꬃይ ሃይሳ፡ ዜሬꬂ ያጌቲዳይ ፆሳ ቃላ። ");
INSERT INTO gofENT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","ኦጌ ጋፃን ዎꬊዳ ዜሬꬃይ ቃላ ሲዔይሳታ። ጊዶሺን፥ ኤንቲ ኣማኒዲ ኣቶና ሜላ ፃላሄይ ቃላ ኤንታ ዎዛናፔ ማፂ ዲጌስ። ");
INSERT INTO gofENT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","ሻሎይ ጋርሳን ዴዒያ ቢታ ቦላ ዎꬊዳ ዜሬꬃይ ቃላ ሲዒዲ ኡፋይሳን ኤኬይሳታ። ኤንቲ ሃዒስ ኣማኖሶናፔ ኣቲን ፃጶይ ባይና ጊሾ ፓጬይ ጋኪያ ዎዴ ኤሌሲዲ ካዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","ኣጉንꬃ ጊዶን ዜሬቲዳይሳቲ ቃላ ሲዔይሳታ። ኤንቲካ ኣላሚያ ቆፋን፥ ዱሬቴꬃኒኔ ሳዓ ዱሳ ሚኮቴꬃን ጩሌቲዲ ቤሴይሳዳ ኣይፊቦኮና። ");
INSERT INTO gofENT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","ሎዖ ቢታን ዎꬊዳ ዜሬꬃይ ሎዖ ዎዛናን ቃላ ሲዒዲ ናጌይሳታኔ ዳንዳዓን ሚኒዲ ኣይፌ ኣይፌይሳታ። ");
INSERT INTO gofENT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","«ፆምፔ ፆምፒዲ፥ ዳቾ ካሜይ ዎይኮ ኣርሳፌ ጋርሳን ዎꬄይ ዴና። ጌሊያ ኣሲ ቤዓና ሜላ ꬎቃ ቤሳን ዎꬄስ። ");
INSERT INTO gofENT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","«ሄሳ ጊሾ፥ ቆንጬ ኬዮና ቆሴቲዲ ኣቲያባይ፥ ኤሬቶና ጌሚዲ ኣቲያባይ ዴና። ");
INSERT INTO gofENT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","«ሂዛ፥ ሂንቴ ቃላ ዋቲ ሲዒያኮ ኣኬኪቴ። ዴዒያ ኡባስ ጉዤቲዲ ኢሜታና፥ ባይናይሳስ ሃሪ ኣቶሺን ኢያው ዴዒያ ጉꬂያካ ኢያፔ ኤኬታና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","ዬሱሳ ኣዬራኔ ኢሻታራ ኢያኮ ዪዶሶና። ሺን ኣሳ ዳሮቴꬃፌ ዴንዶይሳን ኢያ ዴማናው ዳንዳዒቦኮና። ");
INSERT INTO gofENT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","ኢሲ ኣሲ ዬሱሳኮ፥ «ኔ ኣዬራኔ ኔ ኢሻታራ ኔና ኮዪዲ ካሬን ናጎሶና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","ዬሱሲ ዛሪዲ፥ «ፆሳ ቃላ ሲዒዲ ኦሶን ፔሼይሳቲ ኡባይ ታው ኣዮኔ ታው ኢሻ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","ኢሲ ጋላስ ዬሱሳራኔ ኢያ ታማሬታራ ኢሲፌ ዎጎሎን ጌሊዲ፥ «ኣባ ፒኖስ» ያጊስ። ኤንቲካ ባናው ዴንዲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","ኣባ ቦላራ ኤንቲ ፒናናው ቢሺን ዬሱሲ ꬊስኪስ። ቆፖና ሚኖ ጫርኮይ ኣባ ቦላ ዴንዲስ። ሃꬃይ ዎጎሉዋን ጌሊን ዎጎሎይ ሚቴቴꬂ ኦይኪያ ዎዴ ኡባይ ባቢዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","ኢያ ታማሬቲ ኢያኮ ሺቂዲ፥ «ኑ ጎዳው፥ ኑ ጎዳው፥ ኑ ꬋዮስ ያጊዲ» ዬሱሳ ዴንꬂዶሶና። ዬሱሲ ዴንዲዲ ጫርኩዋኔ ጎቲያ ሴሪስ። ኤሌሲዲ ጫርኮይኔ ጎቴይ ዎፑ ጊስ። ሳሮቴꬃይካ ሲሚስ። ");
INSERT INTO gofENT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","ዬሱሲ ባ ታማሬታኮ፥ «ሂንቴ ኣማኖይ ኣዉኔ» ያጊስ። ኤንቲካ፥ ያዪሼኔ ማላሌቲሼ ኢሶይ ኢሱዋኮ፥ «ጫርኮይኔ ሃꬃይ ኪቴቴይሲ፥ ኢ ሃይሲ ኦኔ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","ኣባ ፒኒዲ ጋሊላ ባጋራ ዴዒያ ጌርጌሶኔ ቢታ ጋኪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","ዬሱሲ ዎጎሉዋፔ ኬዪዲ ሳዓን ዎꬊሺን ቱና ኣያናን ኦይኬቲዳ ኡራይ ካታማፔ ኬዪዲ ኢያራ ጋሄቲስ። ዳሮ ላይꬂ ኣፊሊ ማዖና ካሎ ዱፎን ዴዔሲፔ ኣቲን ሶ ጌሌና። ");
INSERT INTO gofENT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","ዬሱሳ ቤዒዳ ዎዴ ኢያ ሲንꬃን ጉፋኒዲ፥ ባ ቃላ ꬎቁ ኦꬂዲ፥ «ኡባፌ ቦላ ፆሳ ናዓው ዬሱሳ ኔራ ታው ኣይቢ ኢሲፌቴꬂ ዴዒ? ሃያና ታና ሃዒ ኡንዔꬆፋርኪ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","ሄሳ ኢ ጊዳይ፥ ቱና ኣያናይ ኡራፔ ኬያና ሜላ ዬሱሲ ሃንቄቲዳ ጊሾሳ። ዳሮ ዎዴ ቱና ኣያናይ ኢያ ሃሪዳ ጊሾ ሳንꬃላታኒኔ ቶሆ ቃቺያ ቢራታን ቃሼቲዲ ናጌቴስ። ሺን ቃሹዋ ዱꬂዲ ቱና ኣያናን ላጌቲዲ ባዞ ጌሊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","ዬሱሲ፥ «ኔ ሱንꬃይ ኦኔ» ያጊዲ ኦይቺስ። ኢ፥ ዳሮ ቱና ኣያናቲ ኢያ ኦይኪዲ ጊሾ ባና፥ «ሌጊዮና» ጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","ቱና ኣያናቲ ባንታና ሲዖሌ ኪቶና ሜላ ዎሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","ሄ ቤሳን ዞዜ ቦላ ሚያ ጉዱንꬆ ዉዴይ ሃሙቴስ። ሂኒ ጉዱንꬆታን ጌሊኖ ጊዲ ዎሲዶሶና፥ ኢካ «ጌሊቴ» ጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","ቱና ኣያናቲ ኡራፔ ኬዪዲ ጉዱንꬆታን ጌሊዶሶና። ዉዴይ ዴሪያፔ ዱጌ ጉርጉፂዲ ኣባን ጌሊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","ሄንꬃንቾቲ ሃኒዳይሳ ቤዒዳ ዎዴ ዎፂ ቢዲ፥ ካታማኒኔ ጉታ ኡባን ኦዲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","ኣሳይ ሃኒዳባ ቤዓናው ኬዪዲ ዬሱሳኮ ዪዶሶና። ቱና ኣያናይ ኬዪዳ ኡራይ ማዖ ማዒዲ፥ ኢያ ዎዛናይ ሲሚን፥ ዬሱሳ ቶሆ ማታን ኡቲዳይሳ ዴሚዲ ያዪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","ኢያ ቤዒዳ ኣሳይ ቱና ኣያናን ኦይኬቲዳ ኡራይ ዋኒዲ ፓፂዳኮ ኦዲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","ጌርጌሶኔ ዩሹዋን ዴዒያ ኣሳይ ጊታ ያሺ ያሼቲዲ ዬሱሲ ባንታ ማታፔ ባና ሜላ ዎሲዶሶና። ኢ ዎጎሉዋን ጌሊዲ ጉዬ ሲሚስ። ");
INSERT INTO gofENT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","ቱና ኣያናይ ኬዪዳ ኡራይ ዬሱሳራ ዳናው ዎሲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","ሺን ዬሱሲ ኢያኮ፥ «ኔ ሶ ሲማ፥ ፆሳይ ኣይ ሜላ ጊታባ ኔው ኦꬂዳኮ ኦዳ» ያጊዲ ሞይዚስ። ኡራይካ ዬሱሲ ኣይ ሜላ ጊታባ ኢያው ኦꬂዳኮ ካታማ ኡባን ማርካቲሼ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","ኣሳይ ናጊዲ ጋምዒዳ ጊሾ ዬሱሲ ሲሚያ ዎዴ ሞኪ ኤኪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","ኣይሁዴ ዎሳ ኬꬃ ሃላቃ ጊዲዳ ኢያሮሳ ጊያ ኡራይ ባ ሶ ያና ሜላ ዬሱሳ ቶሁዋ ቦላ ዎꬊዲ ዎሲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ኢያው ታማኔ ናምዑ ላይꬂ ጊዲዳ ማጫ ናዓ ዴዒያራ ሳኬታዳ ሃይቆስ ጋካዳ ዴዓዉሱ። ዬሱሲ ቢያ ዎዴ ኣሳይ ኢያ ኡንዔꬄስ። ");
INSERT INTO gofENT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","ታማኔ ናምዑ ላይꬂ ሱꬂ ጎጊሼ ጋምዒዳ ማጫሲ ዴዒያራ ዴዓዉሱ። ኢያ ባው ዴዒያ ሚሺያ ኣኪሜታስ ኢማዳ ኦንጋሱ። ሺን ፓፃናው ዳንዳዓቡኩ። ");
INSERT INTO gofENT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","ኢያ ዬሱሳስ ጉዬ ባጋራ ሺቃዳ፥ ኢያ ኣፊላ ማጫራ ቦቻሱ፥ ሶሁዋራ ጎጊያ ሱꬃይ ኤቂ ኣጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","ዬሱሲ፥ «ታና ቦቺዳይ ኦኔ?» ያጊስ። ኡባይ «ኑ ቦቺቦኮ» ያጊን፥ ጴፂሮሲ፥ «ኣስታማሪያው፥ ዳሮ ኣሳይ ካሊሺኒኔ ኡንዔꬂሺን ቤዓሼ ዋናዳ፥ ‹ታና ቦቺዳይ ኦኔ?› ጋይ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","ሺን ዬሱሲ፥ «ኢሲ ኣሲ ታና ቦቺስ፤ ኣይስ ጊኮ፥ ዎልቂ ታፔ ኬዮይሲ ታው ኤሬቲስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","ማጫሲያ፥ ኢባይ ቆንጪዳይሳ ኤሪዳ ዎዴ ኮኮራሼ ያዳ ዬሱሳ ቶሁዋ ቦላ ኩንዳሱ። ኣይስ ቦቺዳኮኔ ዋናዳ ኤሌሳዳ ፓፂዳኮ ኣሳ ኡባ ሲንꬃን ማርካታሱ። ");
INSERT INTO gofENT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","ኢ፥ «ታ ናቴ፥ ኔ ኣማኖይ ኔና ፓꬂስ፤ ሳሮን ባ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","ዬሱሲ ኦዳ ኦንጎና ዴዒሺን፥ ኣይሁዴ ዎሳ ኬꬃ ሃላቃ፥ ኢያሮሳ ሶፔ ኢሲ ኣሲ ዪዲ፥ «ኢያሮሳ፥ ኔ ናዒያ ሃይቃሱ፤ ኣስታማሪያ ሜላ ዳቡሪሶፋ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","ሺን ዬሱሲ ሄሳ ሲዒዲ ኢያሮሳኮ፥ «ባቦፋ! ኣማና፥ ኔ ናዒያ ፓፃና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","ዬሱሲ ኢያሮሳ ሶ ጋኪዳ ዎዴ ጴፂሮሳፔ፥ ዮሃኒሳፔ፥ ያይቆባፔ፥ ናዔ ኣዋፔኔ ኣዬፔ ኣቲን ሃሪ ጌላና ሜላ ኮዪቤና። ");
INSERT INTO gofENT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","ሄ ቤሳን ዴዒያ ኣሳ ኡባይ ናዔስ ሚሼቲዲ ዬኪሺን፥ ዬሱሲ፥ «ዬኮፊቴ! ናዒያ ꬊስካሱፔ ኣቲን ሃይቃቡኩ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","ኣሳይ ናዒያ ሃይቂዳይሳ ኤሪያ ጊሾ ኢያ ኦዳ ሌቂዲ ሚጪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","ሺን ዬሱሲ ናዔ ኩሺያ ኦይኪዲ፥ «ናቴ ዴንዳ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","ናዔስ ሼምፖይ ሲሚን ዴንዳ ኤቃሱ። ዬሱሲ ኤንታኮ፥ «ኢዉ ሚያባ ኢሚቴ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","ናዔ ኣዋራኔ ኣዬራ ማላሌቲዶሶና። ሺን ዬሱሲ ሃይሳ፥ «ኦዴስካ ኦዶፒቴ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","ዬሱሲ ታማኔ ናምዑ ሃዋሬታ ባኮ ፄጊዲ፥ ቱና ኣያናታ ኬሳና ሜላኔ ሃርጌ ኡባ ፓꬃና ሜላ ዎልቃኔ ማታ ኢሚስ። ");
INSERT INTO gofENT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","ፆሳ ካዎቴꬃባ ማርካታናዳኔ ሃርጋንቾታ ፓꬃናዳ ኪቲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","ኢ ኤንታኮ፥ «ፃምዓ ጊዲን ኦጎሮ ጊዲን ካꬂ ጊዲን ሚሼ ጊዲን ላሚ ማዒያ ኣፊላ ጊዲን ኦጌስ ጊዲ ኣይኮካ ኦይኮፊቴ። ");
INSERT INTO gofENT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","ሄ ካታማፔ ሂንቴ ኬያና ጋካናው ኢማꬃቴꬃን ሂንቴ ጌሊዳሱዋን ጋምዒቴ። ");
INSERT INTO gofENT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","ኦኒካ ሂንቴና ሞኮና ኢፂኮ ሄ ካታማፔ ኬዪሼ ኤንታው ማርካ ጊዳና ሜላ ሂንቴ ቶሁዋን ዴዒያ ባና ፒቲዲ ኬዪቴ።» ");
INSERT INTO gofENT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","ኤንቲካ ኪቴቲዳይሳዳ ኬዪዲ ዎንጌላ ኦዲሼኔ ዱማ ዱማ ጉታታን ሃርጋንቾታ ፓꬂሼ ኣꬊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","ጋሊላ ቢታ ሃሪያ ሄሮዲሲ ዬሱሲ ኦꬂዳባ ኡባ ሲዒዳ ዎዴ ዳጋሚስ። ኣይስ ጊኮ፥ ኢሲ ኢሲ ኣሳቲ ዮሃኒሲ ሃይቆፔ ዴንዶና ኣጌና ያጎሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ባጋቲ፥ «ኤሊያሲ ቆንጪስ» ጎሶና፤ ሃራቲ ቃሲ፥ «ቤኒ ናቤታፔ ኢሶይ ሃይቆፔ ዴንዲስ» ያጊዲ ኦዴቶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","ሺን ሄሮዲሲ፥ «ዮሃኒሳ ቆꬊያ ታ ቃንፂሳዳ ዎꬋስ። ያቲን፥ ሃይሳꬆ ያጌቲዲ ኢያባ ኦዴቴይ፥ ኢ ኦኔ?» ያጊዲ ባ ኣይፌን ቤዓናው ኮዬስ። ");
INSERT INTO gofENT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","ታማኔ ናምዑ ሃዋሬቲ ጉዬ ሲሚ ዪዲ፥ ኤንቲ ኦꬂዳባ ኡባ ዬሱሳስ ኦዲዶሶና። ኢ ኤንታና ኤኪዲ ቤቴሳይዳ ካታማፔ ጋፃ ኤፊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","ሺን ዳሮ ኣሳይ ዬሱሳ ጊዴይሳ ኤሪዲ ኢያ ካሊዶሶና። ኢ ኤንታ ሞኪ ኤኪዲ ፆሳ ካዎቴꬃባ ታማርሲስ፤ ፓፃናው ኮዬይሳታካ ፓꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","ሳዒ ኦማርሲያ ዎዴ ታማኔ ናምዑ ሃዋሬቲ ኢያኮ ሺቂዲ፥ «ኑ ዴዔይ ባዞ ቢታ ጊዲያ ጊሾ ኣሳይ ዱማ ዱማ ጉታታኔ ካታማታ ቢዲ፥ ካꬂኔ ኣቂያሶ ኮያና ሜላ ኣሳ ሞይዛ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","ሺን ኢ፥ «ኤንታው ሚያባ ሂንቴ ኢሚቴ» ያጊስ። ኤንቲ፥ «ኑስ ዴዔይ ኢቻሹ ኡይꬂኔ ናምዑ ሞሎ ጊዲያ ጊሾ ሃ ኣሳስ ጊዲያ ካꬂ ኑኒ ቢዲ ሻሞና ኢፂኮ ጊዴና» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","ሄ ቤሳን ኢቻሹ ሙኩሉ ጊዲያ ኣዴቲ ዴዖሶና። ዬሱሲ ባ ታማሬታኮ፥ «ኢሻታማን ኢሻታማን ሻኪ ሻኪ ኣሳ ኡቲሲቴ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","ኢያ ታማሬቲ፥ ኢ ኪቲዳይሳዳ ኣሳ ኡቲሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","ኢ ኢቻሹ ኡይꬃኔ ናምዑ ሞሎታ ኤኪዲ፥ ሳሎ ፄሊዲ፥ ፆሳ ጋላቲዲ፥ ሜንꬂዲ ኣሳ ኡባ ጋꬃና ሜላ ባ ታማሬታስ ኢሚስ። ");
INSERT INTO gofENT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","ኡባይ ሚዲ ካሊዶሶና። ኤንታፌ ኣቲዳ ቲፌይ ታማኔ ናምዑ ጋይታ ኩሜꬂ ጊዲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","ዬሱሲ ባ ፃላላ ዎሲሺን፥ ኢያ ታማሬቲ ኢያኮ ዪዶሶና። ኢ፥ «ኣሳይ ታና ኦና ጎና?» ጊዲ ኦይቺስ። ");
INSERT INTO gofENT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","ኤንቲ ዛሪዲ «ኢሶቲ ኢሶቲ፥ ‹ፃማቂያ ዮሃኒሳ፥ ባጋቲ ኤሊያሳ፥ ሃራቲ ቃሲ፥ ቤኒ ናቤታፔ ኢሶይ ሃይቆፔ ዴንዲስ› ያጎሶና» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","ኢ ዛሪዲ፥ «ያቲን ሂንቴ ታና ኦና ጌቲ» ያጊስ። ጴፂሮሲ፥ «ኔኒ ፆሳፌ ኪቴቲዳ ኪሪስቶሳ» ያጊዲ ዛሪስ። ");
INSERT INTO gofENT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","ዬሱሲ ሃይሳ ኦዴስካ ኦዶፒቴ ጊዲ ሚንꬂዲ ኦዲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","ቃሲካ ዬሱሲ፥ «ኣሳ ናዓይ ዳሮ ሜቱዋ ኤካና። ቢታ ጪማታን፥ ካሂኔ ሃላቃታን፥ ሂጌ ኣስታማሬታን ኣꬊ ኢሜታና። ኤንቲ ኢያ ዎꬋና፥ ሺን ኢ ሄꬓንꬆ ጋላስ ሃይቆፔ ዴንዳና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","ዬሱሲ ኣሳ ኡባኮ፥ «ታና ካላናው ኮዬይ ኦኒካ ዴዒኮ ባና ካዶ፥ ባ ማስቃሊያ ጋላስ ጋላስ ቶኪዲ ታና ካሎ። ");
INSERT INTO gofENT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","ባ ሼምፒው ኣሻናው ኮያ ኡባይ ኢዮ ꬋይሴስ፥ ባ ሼምፒው ታ ጊሾ ጊዲ ꬋይሲያ ኦኒካ ኢዮ ኣሼስ። ");
INSERT INTO gofENT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","ኣሲ ኣላሜ ኡባ ሃሪዲ፥ ጊዶሺን ባ ሼምፒው ꬋይሲያባ ዎይኮ ቆሂያባ ጊዲኮ ኢያ ኣይ ማዲ? ");
INSERT INTO gofENT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","ኦኒካ ታናኒኔ ታ ቃላን ዬላቲኮ ኣሳ ናዓይ ባ ቦንቹዋራ ሄሳዳካ ኣዋ ቦንቹዋራኔ ጌሻ ኪታንቾታ ቦንቹዋራ ያ ዎዴ ኢያን ዬላታና። ");
INSERT INTO gofENT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","ታ ሂንቴው ቱማ ኦዳይስ፤ ሃይሳን ኤቂዳይሳታ ጊዶፌ ፆሳ ካዎቴꬃ ቤዖናሺን ሃይቆና ኣሳቲ ዴዖሶና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","ዬሱሲ ሄ ኦዳ ኦዲን፥ ሆስፑን ጋላሳፔ ጉዬ ጴፂሮሳ፥ ያይቆባኔ ዮሃኒሳ ባራ ኤኪዲ ዎሳናው ዴሪያ ቦላ ኬዪስ። ");
INSERT INTO gofENT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","ኢ ዎሳ ቦላ ዴዒሺን ኢያ ኣይፌ ካሬይ ላሜቲስ፤ ኣፊላይካ ኣዋ ሜላ ጶሊዲ ቦፂስ። ");
INSERT INTO gofENT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","ናምዑ ኣሳቲ፥ ኤንቲካ ሙሴራኔ ኤሊያሳራ ቦንቾን ቆንጪዲ፥ ");
INSERT INTO gofENT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ዬሩሳላሜን ፖሌታናው ዴዒያባ፥ ሄሲካ፥ ኢ ሃ ኣላሚያፔ ሻኬታናባ ኢያራ ኦዴቶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","ጴፂሮሳኔ ኢያራ ዴዔይሳታ ꬊስኮይ ኤፊን፥ ኤንቲ ꬊስኮፌ ባርኪያ ዎዴ ኢያ ቦንቹዋኔ ኢያራ ኤቂዳ ናምዑ ኣሳታ ቤዒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","ኣሳቲ ዬሱሳፔ ሻኬቲዲ ባና ሃኒሺን፥ ጴፂሮሲ ዬሱሳኮ፥ «ጎዳው፥ ሃይሳን ጊዴይሲ ኑስ ኣይ ሜላ ሎዖ! ኢሲኖ ኔው፥ ኢሲኖ ሙሴስ፥ ኢሲኖ ኤሊያሳስ ኦꬂዲ ሄꬑ ሻቃራ ሻቃሮስ» ያጊስ። ሺን ኢ ኣይ ጊዳኮ ኤሬና። ");
INSERT INTO gofENT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","ኢ ያጊዲ ኦዴቲሺን ሻራይ ዪዲ ኤንታና ካሚስ። ኤንቲ ሄ ሻራ ጊዶ ጌሊሼ ባቢዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","ሻራ ጊዶፌ፥ «ታ ዶሪዳ ናዓይ ሃይሳ ኢያ ሲዒቴ» ያጊያ ቃላይ ሲዔቲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","ሄ ቃላይ ሲዔቲዳፔ ጉዬ ዬሱሲ ባርካ ዴዒሼ ቤንቲስ። ሄ ዎዴ ኤንቲ ቤዒዳባ ኦዴስካ ኦዶና፥ ባንታ ዎዛናን ኦይኪዲ ሲዒ ጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","ዎንቴꬄ ኤንቲ ዴሪያፔ ዎꬊያ ዎዴ ዳሮ ኣሳይ ዪዲ ኢያራ ጋሄቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","ሄ ዎዴ ኣሳ ጊዶፌ ኢሲ ኣሲ፥ «ኣስታማሪያው፥ ታ ኢሲ ናዓ ያዳ ቤዓርኪ። ");
INSERT INTO gofENT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","ቱና ኣያናይ ቆፖና ኦይኪዲ ዋሲሴስ፤ ጎፖንቶ ዬጊሲዲ ቃኬሬꬄስ፥ ኣሳቴꬃ ቆሂዲ ኡንዔꬂዲ ዬዴስ። ");
INSERT INTO gofENT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","ኔ ታማሬቲ ኬሳና ሜላ ዎሳስ፥ ሺን ኤንቲ ዳንዳዒቦኮና» ያጊዲ ዎሲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","ዬሱሲ፥ «ኣማኖይ ባይና ጌላ ዬሌቴꬃቶ፥ ኣዉዴ ጋካናው ታ ሂንቴራ ዳኔ፥ ሂንቴና ዳንዳዓኔ? ኔ ናዓ ባዳ ሃ ኤካያ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","ናዓ ኤኪዲ ያ ዎዴ ቱና ኣያናይ ሳዓን ሆሊ ዬጊዲ ኮኮርሲስ። ሺን ዬሱሲ ቱና ኣያና ሃንቂዲ ናዓፔ ኬሲስ። ናዓካ ናዓ ኣዋስ ኢሚስ። ");
INSERT INTO gofENT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","ኣሳይ ኡባይ ፆሳ ጊታ ዎልቃን ማላሌቲዶሶና። ኤንቲ ኢ ኦꬂዳባን ማላሌቲሺን፥ ዬሱሲ ባ ታማሬታኮ፥ ");
INSERT INTO gofENT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«ሃይሳ ታ ሂንቴው ኦዴይሳ ሎይꬂ ሲዒቴ፤ ኣሳ ናዓይ ሞርኬታ ኩሼን ኣꬊ ኢሜታና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","ሺን ኢ ጊዳባይ ኤንታፌ ጌሚዳ ጊሾ ኣኬኪቦኮና። ሄሳ ጊሾ፥ ዛሪዲ ኦይቻናው ባቢዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","ዬሱሳ ታማሬቲ፥ «ኑ ጊዶን ጊታ ጊዳናይ ኦኔ?» ጊዲ ፓላማ ኦይኪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","ዬሱሲ ኤንታ ዎዛና ቆፋ ኤሪዲ ዮጋ ናዓ ባ ማታን ኤሲዲ፥ ");
INSERT INTO gofENT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","«ሃ ዮጋ ናዓ ታ ሱንꬃን ሞኪያ ኦኒካ ታና ሞኬስ፥ ታና ሞኬይ ታና ኪቲዳይሳ ሞኬስ፥ ሂንቴ ኡባፌ ጉፄይሲ፥ ኢ ጊታ ጊዳና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","ዮሃኒሲ፥ «ጎዳው፥ ኢሲ ኣሲ ኔ ሱንꬃን ቱና ኣያናታ ኬሲሺን ቤዒዲ ኢ ኑራ ጊዶና ጊሾ ዲጊዳ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","ዬሱሲ ዛሪዲ፥ «ሂንቴራ ኤቄቶናይሲ፥ ኢ ሂንቴ ባጋ። ሄሳ ጊሾ፥ ኢያ ዲጎፊቴ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","ዬሱሲ ሳሎ ቢያ ዎዴይ ማታቲዳ ጊሾ ዬሩሳላሜ ባናው ቃንፂዲ ዴንዲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","ሳማሬ ቢታን ዴዒያ ኢሲ ጉታ ቢዲ፥ ኡባባ ኢያው ጊጊሳና ሜላ ኣሴ ያ ኪቲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","ሺን ኢ ቤይ ዬሩሳላሜ ጊዲያ ጊሾ ኤንቲ ኢያ ሞኪ ኤኪቦኮና። ");
INSERT INTO gofENT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","ዬሱሳ ታማሬቲ ያይቆባራኔ ዮሃኒሳራ ሄሳ ቤዒዲ፥ «ጎዳው፥ ሳሎፔ ታሚ ዎꬊዲ ኤንታ ሞ ጋና ሜላ ኔ ኮያይ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","ሺን ዬሱሲ ጉዬ ሲሚ ኤንታ ሃንቄቲዲ፥ «ሂንቴ ጋርሳን ኣይቢ ኣያኒ ዴዒያኮ ሂንቴ ኤሬኬታ። ኣሳ ናዓይ ኣሴ ኣሻናው ዪሲፔ ኣቲን ꬋይሳናሳ ጊዴና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","ያፔ ዴንዲዲ ሃራ ጉታ ቢዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","ኤንቲ ኦጊያራ ቢሺን፥ ኢሲ ኣሲ፥ «ኔ ቢያሶ ኡባ ታ ካላና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","ዬሱሲ ዛሪዲ፥ «ዎርካናታስ ኦሊ፥ ሳሎ ካፎታስ ኬꬂ ዴዔስ፥ ሺን ኣሳ ናዓይ ባ ሁዒያ ሼምፒሲያሶይ ባዋ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","ሃንኩዋኮ፥ «ኔኒ ታና ካላ» ያጊስ። ሺን ኡራይ፥ «ጎዳው፥ ኮይሮታዳ ታ ኣዋ ሞጋዳ ያና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","ሺን ዬሱሲ፥ «ሃይቂዳይሳቲ ሃይቂዳይሳታ ሞጋና ሜላ ኤንታው ኣጋጋ፤ ኔኒ ባዳ ፆሳ ካዎቴꬃ ሳባካ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","ቃሲ ሃራ ኣሲ፥ «ጎዳው፥ ታ ኔና ካላና፥ ሺን ኮይሮታዳ ታ ሶ ኣሳ ሳሮꬃዳ ያና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","ዬሱሲ ዛሪዲ፥ «ኮፄ ኦይኪዲ ጉዬ ፄሊያ ኦኒካ ፆሳ ካዎቴꬃስ ቤሴና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","ሄሳፌ ጉዬ፥ ጎዳይ ሃራ ላፑን ታማኔ ናምዑ ኣሳታ ዶሪስ። ኢ ባናው ቆፒዳ ካታማኔ ጉታ ኡባ ሲንꬃቲዲ ባናዳ ናምዓ ናምዓ ኦꬂዲ ኪቲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","ዬሱሲ ኤንታኮ፥ «ሄኮ ሺቃና ካꬃይ ዳሮ ሺን ኦሳንቾቲ ጉꬃ። ያኒያ ጊሾ፥ ካꬃ ጎዳይ ኦሳንቾታ ኪታና ሜላ ዎሲቴ። ");
INSERT INTO gofENT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","ሂዛ፥ ቢቴ፥ ዶርሳታዳ ሱꬉሜታ ጊዶ ሂንቴና ታኒ ዬዳና። ");
INSERT INTO gofENT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","ሂንቴ ቢያ ኦጊያስ ኣይኮካ ኦይኮፊቴ፥ ሚሼ ጊዲን ካꬂ ጊዲን ጫማ ኦይኮፊቴ። ኦጌ ቦላ ኦናካ ሳሮꬆፊቴ። ");
INSERT INTO gofENT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","ሂንቴ ጌሊያ ኬꬃ ኡባ ኮይሮቲዲ፥ ‹ሳሮይ ሃ ኬꬃስ ጊዶ› ያጊቴ። ");
INSERT INTO gofENT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","ሳሮ ዶሲያ ኣሲ ሄ ቤሳን ዴዒኮ፥ ሂንቴ ሳሮይ ያን ሼምፓና፤ ኢፃስ ጊኮ ሂንቴ ሳሮይ ሂንቴው ሲማና። ");
INSERT INTO gofENT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","ኦሳንቾስ ዳሞዜ ቤሲያ ጊሾ ሂንቴ ጌሊዳ ኬꬃን ሂንቴው ሺሺዳባ ኡባ ሚሼኔ ኡዪሼ ያን ጋምዒቴ። ኢሱዋ ሶፔ ኢሱዋ ሶ ዩዮፒቴ። ");
INSERT INTO gofENT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","ኣይ ካታማካ ሂንቴ ጌሊያ ዎዴ ኣሳይ ሂንቴና ሞኪዲ፥ ሂንቴው ሺሺዳባ ኡባ ሚቴ። ");
INSERT INTO gofENT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","ሄ ካታማን ዴዒያ ሃርጋንቾታ ፓꬂሼ፥ ‹ፆሳ ካዎቴꬃይ ሂንቴኮ ማቲስ› ያጊዲ ኦዲቴ። ");
INSERT INTO gofENT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","ሺን ኢሲ ካታማ ጌሊያ ዎዴ ኣሳይ ሂንቴና ሞኮና ኢፂኮ ዳባባ ኬዪዲ ሃይሳዳ ጊቴ፡ ");
INSERT INTO gofENT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‹ኑ ቶሁዋ ቦላ ዴዒያ ሂንቴ ካታማ ባና ፒቶስ፥ ሺን ፆሳ ካዎቴꬃይ ሂንቴኮ ማታቲዳይሳ ኤሪቴ።› ");
INSERT INTO gofENT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","ፒርዳ ጋላሳን ሃ ካታማፔ ሶዶሜ ካታማስ ፒርዳይ ካዉሼ ጊዳናይሳ ታ ሂንቴው ኦዳይስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","ካሊዲካ፥ ዬሱሲ፥ «ኔኖ ኮራዚኔ፥ ኔኖ ቤቴሳይዳ፥ ኣዬ፥ ሂንቴናን ኦሴቲዳ ማላታቲ ፂሮሳኒኔ ሲዶናን ኦሴቲዳኮ ያን ዴዒያ ኣሳይ ካሌ ማዒዲ፥ ቢዲንꬃ ቦላ ኡቲዲ ቤኒ ማሮታን ጌሊ ኣጋናሺን። ");
INSERT INTO gofENT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","ሄሳ ጊሾ፥ ሂንቴፌ ኣꬂዲ ፂሮሳሲኔ ሲዶናስ ፆሳ ፒርዳይ ካዉያና። ");
INSERT INTO gofENT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","ኔካ ቂፊርናሆሜ፥ ሳሎ ጋካናው ኔና ꬎቁ ኦꬃናው ኮያይ? ኔ ዱጌ ሲዖሌ ሆሌታና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","ቃሲካ ዬሱሲ ባ ታማሬታኮ፥ «ሂንቴና ሲዔይ ታና ሲዔስ፥ ሂንቴና ኤኮናይ ታና ኤኬና፥ ታና ኤኮናይ ታና ኪቲዳይሳ ኤኬና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","ላፑን ታማኔ ናምዑ ታማሬቲ ኪቴቲዳ ቤሳፌ ኬሂ ኡፋይቲሼ ሲሚዶሶና። ዬሱሳኮ ሺቂዲ፥ «ጎዳው፥ ኔ ሱንꬃን ቱና ኣያናቲካ ኑስ ኪቴቲዶሶና» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","ዬሱሲ ኤንታኮ፥ «ፃላሄይ ሳሎፔ ዎልዓንꬃዳ ዎꬊሺን ታ ቤዓስ። ");
INSERT INTO gofENT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","ሄኮ፥ ሾሻኔ ኮርኔ ዬꬋና ሜላኔ ሞርኪያ ዎልቃ ዛራና ሜላ ማታ ሂንቴው ኢማስ። ሂንቴና ቆሃናባይ ኣይኮይካ ዴና። ");
INSERT INTO gofENT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","ጊዶሺን፥ ሂንቴ ሱንꬃይ ሳሎ ማዝጋባን ፃፌቲዳ ጊሾ ኡፋይቲቴፔ ኣቲን ቱና ኣያናቲ ኪቴቲዳ ጊሾ ኡፋይቶፊቴ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","ሄ ዎዴ ዬሱሲ ጌሻ ኣያናን ኡፋይቲዲ፥ «ሳሉዋ ሳዓ ጎዳው፥ ሃይሳ ጪንጫታፔኔ ኤራንቾታፔ ጌንꬃዳ ያላጋታስ ቆንጪሲዳ ጊሾ ጋላቴታ። ኤ ታ ኣዋው፥ ሄሳ ኔ ኦꬃናው ሎዖ ሼኔ ጊዲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","«ኡባባይ ታ ኣዋፔ ታው ኢሜቲስ። ናዓይ ኦኔኮ ኣዋፔ ኣቲን ሃሪ ዎይኮ ናዓይ ቆንጪሳናው ኮዬይሳፌ ሃሪ ኦኒካ ኣዋ ኤሬይ ባዋ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","ካሊዲካ፥ ዬሱሲ ዱማ ባ ታማሬታኮ፥ «ሂንቴ ቤዔይሳ ቤዔይሳቲ ኣንጄቲዳይሳታ። ");
INSERT INTO gofENT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","ቱማ ዳሮ ናቤቲኔ ካዎቲ ሂንቴ ቤዔይሳኔ ሲዔይሳ ቤዓናዉኔ ሲዓናው ኣሞቲዶሶና፥ ሺን ቤዒቦኮና፥ ሲዒቦኮና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","ሄኮ፥ ኢሲ ጋላስ ሙሴ ዎጋ ኤሪያ ኢሲ ኡራይ ዴንዲዲ ዬሱሳ ያጊዲ ፓጬ ኦይሾ ኦይቺስ። «ኣስታማሪያው፥ ሜሪና ዴዑዋ ላታናው ታኒ ኣይ ኦꬆ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","ዬሱሲ፥ «ሙሴ ማፃፋን ፃፌቲዳይ ዎይጊ? ኔ ዋታ ናባባይ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","ኣዴይ ዛሪዲ፥ « ‹ኔ ጎዳ ኔ ፆሳ፥ ኔ ኩሜꬃ ዎዛናፔ፥ ኔ ኩሜꬃ ሼምፑዋፌ፥ ኔ ኩሜꬃ ዎልቃፌኔ ኔ ኩሜꬃ ቆፋፔ ዶሳ። ቃሲ ኣሴ ኔ ሾሩዋ ኔ ሁዒያዳ ዶሳ› ያጌስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","ዬሱሲ ኢያኮ፥ «ኔኒ ሊኬ ዛራዳሳ፥ ኔካ ሄሳዳ ኦꬃ። ኔኒ ሜሪናው ዴዖን ዳና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","ሺን ኡራይ ባና ፂሎ ኦꬃናው ኮዪዲ፥ «ሃኖስ ኢ ታ ሾሮይ ኦኔ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","ኢያ ኦይሻስ ዬሱሲ ያጊዲ ዛሮ ኢሚስ፥ «ኢሲ ኣሴ ዴዔይሲ ዬሩሳላሜ ካታማፔ ዱጌ ኢያርኮ ካታማ ቢሺን ኦጌ ቦላ ፓንጋቲ ኬዪዲ ሾጪዶሶና። ኢያ ማዑዋ ቃሪ ኤኪዲ ሃይቆፔኔ ፓፃፔ ጊዶን ዬጊዲ ቢዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","ጉዬፔ፥ ኣይሁዴ ካሂኔ ኢሶይ ሄ ኦጊያራ ባ ቡሱ ቢሼ ኡራ ቤዒዲ ዴሺ ጊዲ ኣꬊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","ቃሲ ኢሲ ሌዌ ዴዔይሲ ሄ ቤሳ ጋኪሼ ኡራ ቤዒዲ ሃራሶራ ኣꬊዲ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","ሺን፥ ኢሲ ሳማሬ ቢታ ኣሴ ዴዔይሲ ሄ ኦጊያራ ዪሼ ኡራ ቤዒዲ ኢያው ቃꬌቲስ ");
INSERT INTO gofENT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","ኢያኮ ሺቂዲ፥ ኢያ ማዱንꬃ ቦላ ዛይቴኔ ዎይኔ ቲጊዲ ቃቺስ። ባ ሃሪያ ቦላ ኡቲሲዲ ኢማꬂ ኣቂያ ኬꬂ ኤፊስ። ሄ ቤሳን ኢያው ኮሺያባ ኡባ ኦꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","ዎንቴꬄ ናምዑ ዲናሬ ኬሲዲ ኢማꬃ ኬꬃዋስ ኢሚዲ፥ ‹ሃያና ሃ ኡራ ሎይꬃ ፄላ። ታኒ ኔው ኢሚዳይሳፌ ቦላራ ኔ ኬሲያባ ኡባ ታ ኔው ጪጋና› ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","«ሂዛ፥ ሃ ሄꬑ ኣሳታፔ ፓንጋቲ ሾጪዳ ኡራስ ሾሮቴይ ኔው ኦና ዳኒ?» ");
INSERT INTO gofENT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","ኡራይ ዛሪዲ፥ «ኢያው ቃꬌቲዳይሳካ» ያጊስ። ዬሱሲ፥ «ኔካ ባዳ ሄሳዳ ኦꬃ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","ዬሱሲ ባ ታማሬታራ ኦጌ ቢሼ ኢሲ ጉታ ጋኪስ። ያን ማርታ ጌቴቲያ ኢሲ ማጫሲያ ኢያ ባ ሶን ሞካሱ። ");
INSERT INTO gofENT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","ኢዉካ ማይራሞ ጊያ ሚቺያ ዴዓዉሱ፥ ማይራማ ቃላ ሲዓሼ ጎዳ ቶሁዋ ማታን ኡታሱ። ");
INSERT INTO gofENT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","ሺን ማርታ ዳሮ ኦሶን ኡንዔታዳ ዬሱሳኮ ሺቃዳ፥ «ጎዳው፥ ታ ሚቺያ ኦሱዋ ታ ፃላላስ ዬጋዳ ኡታ ኣጊን ታ ዳቡሪያ ዎዴ ኔኒ ቤዓሼ ሲዒ ጋይ? ኢያ ታና ማዳና ሜላ ኦዲኪ» ያጋሱ። ");
INSERT INTO gofENT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","ሺን ጎዳይ ሃይሳዳ ጊዲ ዛሪስ፥ «ማርታ፥ ማርታ፥ ኔኒ ዳሮባን ኡንዔታሳኔ ሜቶታሳ። ");
INSERT INTO gofENT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","ጊዶሺን፥ ኮዬቴይ ኢሲባ ፃላላ። ማይራማ ሎዖባ ዶራሱ፥ ሄሲካ ኢፔ ኤኬቴና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","ኢሲ ጋላስ ዬሱሲ ኢሲ ቤሳን ዎሴስ። ዎሳ ዉርሲዳ ዎዴ ኢያ ታማሬታፔ ኢሶይ፥ «ጎዳው፥ ዮሃኒሲ ባ ታማሬታ ዎሳ ታማርሲዳ ሜላ ኔካ ኑና ዎሳ ታማርሳ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","ዬሱሲ፥ «ሃይሳዳ ያጊዲ ዎሲቴ፡ ‹ሳሉዋን ዴዒያ ኑ ኣዋው ኔ ጌሻ ሱንꬃይ ኣንጄቶ፤ ኔ ካዎቴꬃይ ዮ። ");
INSERT INTO gofENT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","ኑ ጋላሳ ካꬃ ሃቺ ሃቺ ኑስ ኢማ። ");
INSERT INTO gofENT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","ኑና ቆሄይሳታ ኑኒ ኣቶ ጌይሳዳ፥ ኑ ናጋራ ኣቶ ጋ፤ ፓጬን ኑና ጌልሶፋ› ያጊቴ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","ካሊዲካ፥ ዬሱሲ ባ ታማሬታኮ ያጊስ፡ «ሌሚሶስ ሂንቴፌ ኢሱዋስ ላጌይ ዴዔስ። ኢ ጊዲ ቢላሄ ባ ላጊያ ሶ ቢዲ፥ ‹ታ ላጊያው፥ ሄꬑ ሶሎ ታው ታልዓርኪ። ");
INSERT INTO gofENT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ታው ላጌ ጊዲዳ ኢሲ ኣሲ ኦጌፔ ዪን፥ ኢያው ኣꬂያባ ꬋያስ› ያጊኮ፥ ");
INSERT INTO gofENT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","«ኢያ ላጌይ ኬꬃ ጊዶን ጊዲዲ፥ ‹ሃያና ታና ዋይሶፓ፥ ዉላይ ጎርዴቲስ። ታ ናይቲካ ታራ ኣርሳ ቦላ ዚንዒዶሶና። ያኒያ ጊሾ፥ ዴንዳዳ ኔ ኮያባ ኢማናው ዳንዳዒኬ› ያጊዬ? ");
INSERT INTO gofENT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","ታ ሂንቴው ኦዳይስ፤ ላጌቴꬃ ጊሾ ዴንዲዲ ኢማናው ኮዮና ኢፂኮካ ዎሳን ሳሌꬂዳ ጊሾ ዴንዲዲ ኮሺያባ ኡባ ኢሜስ። ");
INSERT INTO gofENT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","«ሄሳ ጊሾ፥ ታኒ ሂንቴው ኦዳይስ፤ ዎሲቴ ሂንቴው ኢሜታና፤ ኮዪቴ ሂንቴ ዴማና፤ ካሬ ዪዲ ፄጊቴ ሂንቴው ዶዬታና። ");
INSERT INTO gofENT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","ጋሶይካ ዎሲያ ኡባይ ኤኬስ፤ ኮዬይ ዴሜስ፤ ካሬ ዪዲ ፄጌይሳስ ዶዬቴስ። ");
INSERT INTO gofENT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","«ሂንቴኖ፥ ኣዋቶ ሂንቴ ጊዶፌ ናዒ ኡይꬂ ዎሲን ሹቹ ኢሜይ ኦኔ? ሞሎ ዎሲን ሾሺ ኢሜይ ኦኔ? ");
INSERT INTO gofENT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","ዎይኮ ጱጱሌ ዎሲኮ ኮርኔ ኢሚ? ");
INSERT INTO gofENT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","ሂንቴ ኢታታ ጊዲሼ ሂንቴ ናይታስ ሎዖባ ኢሞ ኤሪኮ፥ ሳሎን ዴዒያ ሂንቴ ኣዋይ ዎሴይሳታስ ጌሻ ኣያና ዋቲ ኣꬂ ኢሜኔ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","ኢሲ ጋላስ ዬሱሲ ዶና ሙሚሲዳ ቱና ኣያና ኢሲ ኡራፔ ኬሲስ። ቱና ኣያናይ ኬዪዳ ሜላ ሙሜ ኡራይ ኦዴቲስ። ኣሳይካ ማላሌቲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","ሺን ኢሶቲ ኢሶቲ፥ «ቱና ኣያና ሃላቃ፥ ቢዔልዜቡላ ዎልቃን ቱና ኣያናታ ኬሴስ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","ሃራቲ ቃሲ ፓጬስ ሳሎፔ ማላ ቤሳና ሜላ ኮዪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","ሺን ዬሱሲ ኤንታ ቆፋ ኤሪዲ ኤንታኮ፥ «ዎሊ ጊዶን ሻኬቲያ ካዎቴꬂ ኡባይ ꬋዬስ፤ ዎሊ ጊዶን ሻኬቲያ ኬꬂ ኩንዴስ። ");
INSERT INTO gofENT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","ፃላሄይ ዎሊ ጊዶን ሻኬቲኮ ኢያ ካዎቴꬃይ ዋኒዲ ሚኒዲ ኤቃኔ? ሂንቴ ታና፥ ‹ኢ ቱና ኣያናታ ቢዔልዜቡላ ዎልቃን ኬሴስ› ያጌታ። ");
INSERT INTO gofENT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","ሂዛ፥ ታኒ ቱና ኣያና ቢዔልዜቡላ ዎልቃን ኬሲያባ ጊዲኮ ሂንቴ ናይቲ ኦዴ ዎልቃን ኬሶናሻ? ሄሳ ጊሾ፥ ኤንቲ ሂንቴ ቦላ ፒርዴይሳታ ጊዳና። ");
INSERT INTO gofENT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","ሺን ታኒ ቱና ኣያናታ ፆሳ ቢራꬌን ኬሲያባ ጊዲኮ ሂዛ ፆሳ ካዎቴꬃይ ሂንቴኮ ማቲዳይሳ ኤሪቴ። ");
INSERT INTO gofENT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","«ሚኖ ኣሲ ዳንጬቲዲ ባ ኬꬃ ናጊያባ ጊዲኮ፥ ኢያ ሻሎይ ቦሼቴና። ");
INSERT INTO gofENT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","ሃኖሺን፥ ኢያፔ ኣꬊ ሚኖ ጊዲዳ ኣሲ ዪዲ፥ ኢያ ቆሂዲ ፆኒኮ ኣማኔቲዲ ዳንጪዳ ዳንጩዋ ቢሊሲዲ፥ ኢያ ሻሉዋ ቦንቂዲ ሃራስ ሻኬስ። ");
INSERT INTO gofENT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","«ታራ ጊዶናይሲ ታና ኢፄስ፤ ታራ ሺሾናይሲካ ላሌስ። ");
INSERT INTO gofENT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","«ቱና ኣያናይ ኣሳፔ ኬዪዳ ዎዴ ሼምፒያሶ ኮዪዲ ሃꬂ ባይናሶራ ዩዬስ። ሼምፒያሶ ꬋዪዳ ዎዴ ‹ታ ኬዪዳሱዋ ሲማና› ያጌስ። ");
INSERT INTO gofENT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","ኢ ሲሚያ ዎዴ ኬꬃይ ፒቴቲዲ ሎዒዲ ዴዒሺን ዴሚስ። ");
INSERT INTO gofENT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","ሄሳፌ ጉዬ፥ ቢዲ ኢያፔ ኣꬊዲ ኢቲዳ ሃራ ላፑን ቱና ኣያናታ ኤኪዲ ዬስ። ኢያን ጌሊዲ ዱሱ ኦይኬስ። ሄ ኡራስ ኮይሮይሳፌ ጉዬይሲ ኣꬊዲ ኢታ ጊዴስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","ዬሱሲ ሄሳ ኦዳ ቦላ ዴዒሺን ኢሲ ማጫሲ ኣሳ ጋꬃፌ ዴንዳዳ፥ ባ ቃላ ꬎቁ ኦꬃዳ፥ «ኔና ቶኪዳ ኡሎይኔ ኔኒ ꬋሚዳ ꬋንꬃቲ ኣንጄቲዶሶና» ያጋሱ። ");
INSERT INTO gofENT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","ሺን ኢ፥ «ኣንጄቲዳይሳቲ ፆሳ ቃላ ሲዒዲ ኪቴቴይሳታ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","ዳሮ ኣሳይ ሺቂዳ ዎዴ ዬሱሲ፥ «ሃ ዬሌቴꬃይ ኢታ፤ ኦራꬃ ማላ ኮዬስ። ሺን ዮናሳ ማላታፔ ኣቲን ሃሪ ኤንታው ኢሜቴና። ");
INSERT INTO gofENT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","ዮናሲ ናናዌ ኣሳስ ማላ ጊዲዳ ሜላ ኣሳ ናዓይካ ሃ ዬሌቴꬃስ ማላ ጊዳና። ");
INSERT INTO gofENT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","ዱጌሃ ካዊያ ፒርዳ ጋላስ ሃ ዬሌቴꬃራ ዴንዳዳ ፒርዳና። ጋሶይካ፥ ኢያ ሶሎሞኔ ጪንጫቴꬃ ሲዓናው ቢታ ጋፃፔ ዴንዳዳ ያሱ። ሄኮ ሶሎሞኔፔ ኣꬌይሲ ሃይሳን ዴዔስ ");
INSERT INTO gofENT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","ናናዌ ኣሳቲ ፒርዳ ጋላስ ሃ ዬሌቴꬃራ ዴንዲዲ ኤንታ ቦላ ፒርዳና። ጋሶይካ ዮናሳ ሲብካቲያን ማሮታ ጌሊዶሶና። ሄኮ፥ ዮናሳፔ ኣꬌይ ሃይሳን ዴዔስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","«ፆምፔ ፆምፒዲ ቆሳ ቤሳን ዎይኮ ኦቶ ጊዶን ዎꬂያ ኣሲ ዴና። ኣሲ ፖዑዋ ቤዓና ሜላ ꬎቃ ቤሳን ዎꬄስ። ");
INSERT INTO gofENT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","ኔ ኣሳቴꬃስ ፖዖይ ኔ ኣይፊያ። ኔ ኣይፌይ ሎዖ ጊዲኮ፥ ኔ ኩሜꬃ ኣሳቴꬃይ ፖዔስ። ኔና ኣይፌይ ሳኪኮ ኔ ኣሳቴꬃይ ኡባይ ꬉሜስ። ");
INSERT INTO gofENT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","ሄሳ ጊሾ፥ ኔ ጋርሳን ዴዒያ ፖዖይ ꬉሞና ሜላ ናጌታ። ");
INSERT INTO gofENT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","ሂዛ፥ ኔ ኩሜꬃ ኣሳቴꬃይ ፖዖ ጊዲኮ፥ ኔ ኣሳቴꬃንካ ሃሪ ꬉማ ቤሲ ꬋዪኮ፥ ኔ ኣሳቴꬃ ኩሜꬃይ ዎሊሌ ፖዖ ሜላ ጊዴስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","ዬሱሲ ባ ኦዳ ኦንጊዳ ሜላ ኢሲ ፋሪሳዌይ ባራ ካꬂ ማና ሜላ ፄጊስ። ኢ ኢያራ ኢሲፌ ጌሊዲ ጊቢራ ቦላ ኡቲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","ፋሪሳዌይ ዬሱሲ ካꬂ ማናፔ ሲንꬄ ኩሼ ሜጮናይሳ ቤዒዲ ማላሌቲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","ጎዳይ ኢያኮ፥ «ሂንቴ ፋሪሳዌቲ ቁሊያኔ ሻቲያ ቦላ ባጋ ሜጬታ። ሺን ሂንቴ ጋꬃይ ኡዜቴꬃኒኔ ኢታቴꬃን ኩሚስ። ");
INSERT INTO gofENT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","ሂንቴኖ፥ ኤያቶ፥ ካሬ ባጋ ሜꬊዳይሲ ጋꬃ ሜꬊዳይ ኢያ ጊዴኔዬ? ");
INSERT INTO gofENT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","ሺን ቁሊያኒኔ ሻቲያን ዴዔይሳ ማንቆታስ ኢሚቴ። ሄ ዎዴ ሂንቴው ኡባባይ ጌሺ ጊዳና። ");
INSERT INTO gofENT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","«ፋሪሳዌቶ ሂንቴና ኣዬ፥ ሳዎፔ፥ ፃሎቴፔ፥ ሄሳ ሜላባፔ ኣስራታ ኬሴታ። ሺን ፂሎቴꬂኔ ፆሳ ዶሶይ ሂንቴናን ባዋ። ሃራታ ኣጎና ሃይሳታካ ኦꬃናው ቤሴስ፥ ሺን ኣጊዴታ። ");
INSERT INTO gofENT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","«ፋሪሳዌቶ ሂንቴና ኣዬ፥ ኣይሁዴ ዎሳ ኬꬃን ቦንቾ ኦይዴ፥ ጊያ ጊዶን ቦንቾ ሳሮꬆ ዶሴታ። ");
INSERT INTO gofENT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","«ማላይ ꬋዪን ኣሳይ ኤሮና ቦላራ ቢያ ዱፎ ዳኔይሳቶ ሂንቴና ኣዬ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","ሂጌ ኣስታማሬይ ዛሪዲ፥ «ኣስታማሪያው፥ ኔ ሄሳ ጋሼ ኑና ጫያሳ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","ዬሱሲ፥ «ሂንቴኖ፥ ሂጌ ኣስታማሬቶ፥ ሂንቴናካ ኣዬ፥ ኣሳይ ቶካናው ዳንዳዖና ዴፆ ቶሆ ቶሴታ፥ ሺን ሂንቴ ሂንቴ ሁዔስ ሃሪ ኣቶሺን ቢራꬌ ፄራንካ ቦቼኬታ። ");
INSERT INTO gofENT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","«ሂንቴ ኣዋቲ ዎꬊዳ ናቤታ ዱፉዋ ሂንቴ ጊጊሲያ ጊሾ ሂንቴና ኣዬ። ");
INSERT INTO gofENT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","ሂዛ፥ ሂንቴ ኣዋታ ኦሱዋ ሚንꬃናው ኤንቲ ዎꬊዳ ናቤታ ዱፉዋ ሂንቴ ሎይꬂያ ጊሾ ኤንታ ኢታ ኦሱዋስ ሂንቴ ማርካ። ");
INSERT INTO gofENT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","ሄሳ ጊሾ፥ ፆሳይ ባ ጪንጫቴꬃን፥ ‹ናቤታኔ ሃዋሬታ ታ ሂንቴው ኪታና፥ ሺን ሂንቴ ባጋታ ዎꬋና፤ ሃራታ ጎዳና› ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","ሄሳ ጊሾ፥ ሃ ዬሌቴꬃይ ኣላሜይ ሜꬌቶሳፔ ሃኖ ጋካናው ጉኪዳ ናቤታ ኡባ ሱꬃስ ኦይሼታና። ");
INSERT INTO gofENT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","ኣቤላፔ ዶሚዲ ያርሾ ቤሳሲኔ ፆሳ ኬꬃፌ ጊዱዋን ጉኪዳ ዛካሪያሳ ሱꬃ ጊሾ ሃ ዬሌቴꬃይ ኦይሼታና። ");
INSERT INTO gofENT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","«ሂጌ ኣስታማሬቶ፥ ሂንቴና ኣዬ፥ ኤራቴꬃ ቁልፒያ ሂንቴ ኩሼን ኦይኪዴታ፥ ሺን ሂንቴው ጌሌኬታ ሃራታካ ጌልሴኬታ።» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","ዬሱሲ ያፔ ባናው ኬያ ዎዴ ሂጌ ኣስታማሬቲኔ ፋሪሳዌቲ ኢያራ ኤቄቲዲ ኦይሾን ዋይሶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ኢያ ዶናፔ ኬያ ቃላን ኢያ ኦይካናው ኮዪዲ ሄሳ ኦꬂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","ሄ ዎዴ ዳሮ ሙኩሉን ታይቤቲያ ኣሳይ ዎሊ ቦላ ዬꬌታና ጋካናው ኣሲ ኣሳ ቦላ ሺቂዲ ዴዒሺን፥ ዬሱሲ ባ ታማሬታኮ፥ «ፋሪሳዌታ ኢርሹዋፌ ናጌቲቴ። ሄሲካ ኤንታ ጩቦቴꬃ። ");
INSERT INTO gofENT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","ቆንጮና ቆሴቲዲ፥ ኤሬቶና ጌሚዲ ኣቲያባይ ኣይኮይካ ባዋ። ");
INSERT INTO gofENT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","ሂዛ፥ ሂንቴ ꬉማን ኦዲዳባይ ኡባይ ፖዖን ሲዔታና፥ ቆልዓ ጋꬃን ካልካሺዳባይ ዳባባን ኦዴታና። ");
INSERT INTO gofENT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","«ታ ባጋቶ፥ ታ ኦዴይሳ ሲዒቴ፤ ኣሹዋ ዎꬎሶናፔ ኣቲን ሃራ ኣይኮካ ኦꬃናው ዳንዳዖናይሳታስ ባቦፊቴ። ");
INSERT INTO gofENT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","ሃኖሺን፥ ሂንቴ ባባናው ቤሴይሳ ታ ሂንቴው ቆንጪሳና። ሄሲካ ዎꬊዳፔ ጉዬ ጋናሜን ዬጋናው ዎልቃይ ዴዔይሳስ ኢያው ባቢቴ። ኤ፥ ቱማ ጋይስ፤ ኢያው ባቢቴ። ");
INSERT INTO gofENT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","ኢቻሹ ቡቤቲ ኢሲ ሳንቲሜስ ባይዜቶኮናዬ? ሃኖፔ ኣቲን ኤንታፌ ኢሲናካ ፆሳ ሲንꬃን ዶጌቱኩ። ");
INSERT INTO gofENT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","ሃሪ ኣቶሺን፥ ሂንቴ ሁዔ ቢናናይካ ፓይዴቲዲ ዴዔስ። ሂዛ፥ ባቦፊቴ፤ ዳሮ ቡቤታፔ ሂንቴ ኣꬌታ። ");
INSERT INTO gofENT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","«ታ ኦዴይሳ ሲዒቴ፤ ኣሳ ሲንꬃን ታው ማርካቲያ ኡባስ ኣሳ ናዓይ ፆሳ ኪታንቾታ ሲንꬃን ማርካታና። ");
INSERT INTO gofENT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","ኣሳ ሲንꬃን ታና ካዴይሳስ ፆሳ ኪታንቾታ ሲንꬃን ታ ኢያ ካዳና። ");
INSERT INTO gofENT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","ኣሳ ናዓ ቦላ ካꬌ ቃላ ሃሳያ ኡባይ ማሮታ ዴማና፥ ሺን ጌሻ ኣያና ቦላ ካꬌ ቃላ ኦዴቴይሲ ማሬቴና። ");
INSERT INTO gofENT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","«ኣሲ ሂንቴና ኦይኪዲ ኣይሁዴ ዎሳ ኬꬃን፥ ዳይናታ ሲንꬃኒኔ ካዎታ ሲንꬃን ጎሼቺያ ዎዴ ኣይ ኦዳኔኮኔ ዎይጊ ዛራኔኮ ሂርጎፊቴ። ");
INSERT INTO gofENT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","ሄ ዎዴ ሂንቴ ኦዳናባ ጌሻ ኣያናይ ሂንቴና ታማርሳና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","ኣሳ ጊዶፌ ኢሲ ኣሲ ዬሱሳኮ ዪዲ፥ «ታ ኢሻይ ታው ኑ ኣዋ ላታፔ ሻካና ሜላ ኢያው ኦዳ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","ዬሱሲ ዛሪዲ፥ «ላ ኣዲያው፥ ሂንቴ ቦላ ታና ዳይናኔ ላታ ሻኪያ ጪማ ኦꬂዳይ ኦኔ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","ቃሲካ ዬሱሲ፥ «ኣሳ ዴዖይ ሻሎ ዳሮቴꬃን ጊዶና ጊሾ ያሬ ኣጊዲ ሚንꬂዲ ሂንቴና ናጊቴ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","ካሊዲካ ሌሚሶን፥ «ጋዴይ ዳሮ ካꬂ ኢሚያ ኢሲ ዱሬ ኡራይ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","ሄ ኡራይ፥ ‹ታ ካꬃ ታኒ ሺሻናው ቤሲ ጉፂዳ ጊሾ ኣይ ኦꬆ?› ያጊዲ ባ ዎዛናን ቆፒስ። ");
INSERT INTO gofENT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","ሂዛፔ ያታና፤ ካሴ ዴዒያ ሻሌታ ላላዳ ሃራ ዳልጋ ሻሌታ ኬፃና። ካꬃኔ ታው ዴዒያባ ኡባ ኢያን ዬጋና። ");
INSERT INTO gofENT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","ባ ሼምፔኮ፥ ‹ታ ሼምፔቴ፥ ዳሮ ላይꬃስ ኔው ጊዲያ ሻሎ ሺሻስ። ሂዛ፥ ሼምፓዳ ማ፥ ኡያ፥ ኡፋይታ› ያጋና። ");
INSERT INTO gofENT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","«ሺን ፆሳይ፥ ‹ላ፥ ኤያ ኣዲያው፥ ሃቺ ቃማ ኔ ሼምፒያ ኔፔ ኤኬታዉሱ። ሂዛ፥ ኔ ሺሺዳባይ ኦዴስ ጊዳኔ?› ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","«ሄሳ ጊሾ፥ ባው ዱሬቴꬂ ሳዓን ሺሺያ ኣሳስ፥ ፆሳ ማታን ዱሬ ጊዶና ኣሳስ ዉርሴꬃይ ሃ ኡራይሳ ሜላ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","ሄሳፌ ጉዬ፥ ዬሱሲ ባ ታማሬታኮ፥ «ሂዛ፥ ታ ኦዲያባ ሲዒቴ፥ ሂንቴ ሼምፑዋስ ኣይ ሚኖ ሂንቴ ቦላስ ኣይ ማዒኖ ያጊዲ ኡንዔቶፊቴ። ");
INSERT INTO gofENT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","ሼምፖይ ካꬃፌ ቦሊ ኣፊላፔ ኣꬌስ። ");
INSERT INTO gofENT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","ካፎታ ቤዒቴ ዜሮኮና፥ ኪሾኮና፥ ኤሌይካ ሻሌይካ ባዋ። ሺን ፆሳይ ኤንታና ሙዜስ። ሂንቴ ካፎታፔ ዳሮ ኣꬌታ። ");
INSERT INTO gofENT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","ሃኖሺን፥ ሂንቴፌ ኡንዔቲዲ ባ ላይꬃ ቦላ ኢሲ ቃማ ጉጃናው ዳንዳዔይ ኦኔ? ");
INSERT INTO gofENT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","ሂዛ፥ ሃ ጉꬃባ ኦꬃናው ዳንዳዖና ሂንቴ ሃራባስ ኣይስ ኡንዔቴቲ? ");
INSERT INTO gofENT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","ኣኔ ጪሻቲ ዋኒዲ ዲጪያኮ ቤዒቴ። ዋዮኮናኔ ሱቆኮና። ሃሪ ኣቶሺን፥ ሶሎሞኔይ ባ ዴዒያ ቦንቾ ኡባን ኤንታፌ ኢሱዋ ሜላካ ማዒቤና። ");
INSERT INTO gofENT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","ሂንቴኖ፥ ኣማኖይ ፓጪዳይሳቶ፥ ሂዛ፥ ፆሳይ ሃቺ ቤንቲዲ ዎንቶ ታማን ዬጌታና ጪሻታ ሃይሳዳ ማይዚኮ፥ ሂንቴና ዋቲ ኣꬂ ማይዜኔ? ");
INSERT INTO gofENT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","ሄሳ ጊሾ፥ ኣይ ሚኖ ዎይኮ ኣይ ኡዪኖ ጊዲ ኡንዔቶፊቴ። ");
INSERT INTO gofENT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","ሄ ኡባስ ፆሳ ኣማኖና ኣሳቲ ኡንዔቶሶና። ሺን ሂንቴ ኣዋይ ፆሳይ ሄሲ ኡባይ ሂንቴው ኮሼይሳ ኤሬስ። ");
INSERT INTO gofENT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","ኡባፌ ኣꬂዲ ፆሳ ካዎቴꬃ ኮዪቴ ሄሲ ኡባይ ሂንቴው ጉጂ ኢሜታና። ");
INSERT INTO gofENT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","«ሂንቴኖ፥ ጉꬃ ዴሬቶ፥ ያዮፊቴ፤ ሂንቴ ኣዋ ፆሳይ ካዎቴꬃ ሂንቴው ኢማናው ኡፋይቴስ። ");
INSERT INTO gofENT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","ሂንቴው ዴዒያባ ባይዚዲ ማንቆታስ ኢሚቴ። ካይሶይ ኤኮናሶን፥ ቢሊ ሞናሶን፥ ጪሞና ካርፂታን፥ ዉሮና ሻሉዋ ሳሉዋን ሺሺቴ። ");
INSERT INTO gofENT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","ሂንቴ ዎዛናይ ሂንቴ ሻሎይ ዴዒያሱዋን ጊዳና። ");
INSERT INTO gofENT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","«ቃንꬃን ዳንጪዲ ጊጌቲቴ፤ ሂንቴ ፆምፔይ ፖዒዳይሳ ጊዶ። ");
INSERT INTO gofENT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","ባንታ ጎዳይ ያጋኖፔ ሲማና ጋካናው ባርኪዲ ናጌይሳታዳ፥ ጎዳይ ዪዲ ፄጊያ ዎዴ ኤሌሲዲ ዶያናው ጊጊዳ ኣሳታ ዳኒቴ። ");
INSERT INTO gofENT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","ባንታ ጎዳይ ሲሚያ ዎዴ ꬊስኮና ዴዒሼ ናጌይሳቲ ኣንጄቲዳይሳታ። ቱማ ጋይስ፤ ጎዳይ ቃንꬃን ዳንጪዲ ጋይታ ዩሹዋን ኡቲሲዲ ሞኬስ። ");
INSERT INTO gofENT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","ጎዳይ ላዴ ጊዲን ጊዲ ቢላሄ ጊዲን ዎይኮ ዎንቲማꬄ ጊዲን ዪዲ፥ ሄሳ ሜላ ꬊስኮና ናጊሺን ዴሚያ ሄ ኣይሌቲ ኣንጄቲዳይሳታ። ");
INSERT INTO gofENT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","ሺን ሃይሳ ኤሪቴ፤ ካይሶይ ኣዉዴ ያኔኮ ኬꬃዋይ ኤሪያኮ ኬꬃይ ቦኬቲያ ዎዴ ሲዒ ጊዲ ቤዔና። ");
INSERT INTO gofENT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","ሂንቴካ ጊጊዲ ናጊቴ፤ ኣሳ ናዓይ ሂንቴ ቆፖና ዎዴ ያና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","ጴፂሮሲካ፥ «ጎዳው ሃ ሌሚሱዋ ኑ ፃላላስ ኦዳዬ ዎይኮ ኣሳ ኡባሴ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","ጎዳይ ዛሪዲ፥ «ሂዛ፥ ካꬃ ሙዛናው ቤሲያ ዎዲያን ኢማና ሜላ ጎዳይ ባ ኣይሌታ ቦላ ሹሚዳ ኣማንꬄይሲኔ ዎዛናማ ሃላቃይ ኦኔ? ");
INSERT INTO gofENT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","ጎዳይ ሲሚያ ዎዴ ሄሳ ሜላ ኦꬂሼ ቤንቲያ ኣይሌይ ኢ ኣንጄቲዳይሳ ");
INSERT INTO gofENT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","ታ ሂንቴው ቱማ ኦዳይስ፤ ባ ጎዳስ ዴዒያ ሻሎ ኡባ ቦላ ኢ ሹሜታና። ");
INSERT INTO gofENT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","ሺን ሄ ኣይሌይ፥ ‹ታ ጎዳይ ኤሌ ዬና› ያጊዲ ባ ዎዛናን ቆፒዲ፥ ማጫ ኣይሌታኔ ኣዴ ኣይሌታ ዋꬊኮ፥ ቃሲ ባው ኮዪዳ ሜላ ሚሼኔ ኡዪሼ ማꬆቲኮ፥ ");
INSERT INTO gofENT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ሄ ኣይሊያ ጎዳይ ኢ ቆፖና ጋላሳኒኔ ሂርጎና ዎዴ ያና። ዪዲ ኢያ ቃንፄሬꬂዲ፥ ኢያ ቃዳ ኣማኖና ኣሳታራ ኦꬃና። ");
INSERT INTO gofENT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","«ጎዳ ሼኒያዳ ጊጎናይሲኔ ኢያ ጎዳይ ኣይ ዶሲያኮ ኤሪሼ ኦꬆና ኣይሌይ ዳሮ ጋራፌታና። ");
INSERT INTO gofENT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","ሺን ባ ጎዳ ሼኒያ ኤሮና ኣቲዲ ጋራፌታናው ቤሴይሳ ኦꬂዳይ ጉꬃራ ጋራፌታና። ጋሶይካ ዳሮ ኢሜቲዳይሳፌ ዳሮ ኮዬቴስ፥ ዳሮ ሃዳራ ኤኪዳይሳፌካ ዳሮ ኢማና ጊዲ ናጌቴስ። ");
INSERT INTO gofENT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","«ታኒ ዪዳይ ቢታ ቦላ ታማ ኦይꬃናሳ። ሃዒ ታማይ ኦይኪያኮ ታና ዋቲ ኡፋይሳንዴሻ! ");
INSERT INTO gofENT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","ሃኖሺን፥ ታ ሃዒ ፃማቄቲያ ፂንቃቴይ ዴዔስ። ኢ ፖሌታና ጋካናው ታ ዳሮ ኡንዔታይስ። ");
INSERT INTO gofENT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","ሳዓ ቦላ ሳሮቴꬂ ኤሃናው ዪዳ ሂንቴው ዳኒ? ጊዴና፥ ታ ዪዳይ ሻካናሳ። ");
INSERT INTO gofENT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","ሃዒፌ ዶሚዲ ዎሊ ጊዶን ሻኬቲዳ ኢቻሹ ኬꬃ ኣሳቲ ኢሲፌ ዴዖሶና። ናምዓቲ ሄꬓታ ቦላ፥ ሄꬓቲካ ናምዓታ ቦላ፥ ዴንዲዲ ሻኬቶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","ኣዋይ ናዓ ቦላ፥ ናዓይካ ኣዋ ቦላ፥ ኣያ ናዔ ቦላ፥ ናዒያ ኣዬ ቦላ፥ ኣዚና ኣያ ናዓ ማቼ ቦላ፥ ናዓ ማቺያ ኣዚና ኣዬ ቦላ፥ ዴንዲዲ ሻኬታና።» ");
INSERT INTO gofENT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","ቃሲካ ኣሳኮ፥ «ዉሎሃ ባጋራ ሳሎይ ሻራቲያ ዎዴ ቤዒዲ፥ ኤሌሲዲ፥ ‹ኢሪ ያና› ያጌታ፥ ሄሳዳካ ሃኔስ። ");
INSERT INTO gofENT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","ዱጌሃ ጫርኮይ ጫርኪያ ዎዴ ‹ሳዓይ ኣዋና› ያጌታ፥ ሄሳዳካ ሃኔስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","ሂንቴኖ፥ ጩቦቶ፥ ሳሎባኔ ሳዓባ ሻኪ ኤሬታሺን ሃ ዎዲያ ሻኪ ኤሮይ ሂንቴና ዋኒዲ ፆኒዴ? ");
INSERT INTO gofENT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","«ያቲን፥ ሂንቴ ሁዔስ ኣይስ ቱማ ፒርዴኬቲ? ");
INSERT INTO gofENT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","ኔ ሞርኪያራ ዎላ ዳይና ሲንꬃን ኤቃናው ባሼ ኦጌ ቦላ ጊጋናው ኮያ። ኔ ጊጎና ኢፂኮ ጎሼቺዲ ዳይና ሲንꬂ ኔና ኤፋና። ዳይናይ ኔና ፖሊሴስ ኣꬂ ኢማና። ኢ ኔና ዎይኔን ዬጋና። ");
INSERT INTO gofENT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","ሲዒቴ፥ ኢሲ ባካኒ ኣቶና ጪጋ ኦንጋና ጋካናው ኔ ያፔ ኬዮናይሳ ኤራ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","ሄ ዎዴ ዬሱሳኮ ኣሳይ ዪዲ ጲላፆሲ ዎꬊዲ ኤንታ ሱꬃራ ኤንታ ያርሹዋ ዋላኪዳ ጋሊላ ኣሳባ ኦዲዳ ኣሳቲ ሄ ቤሳን ዴዖሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","ኢ ሃይሳዳ ያጊዲ ዛሪስ፤ «ያቲን ሄ ጋሊላ ኣሳቲ ሄ ኢታ ሃይቆ ሃይቂዳ ጊሾ ጋሊላን ዴዒያ ኣሳ ኡባፌ ኣꬊዳ ናጋራንቾ ዳኖና? ");
INSERT INTO gofENT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","ጊዴና! ጊዶሺን፥ ሂንቴካ ማሮታን ሲሞና ኢፂኮ፥ ኡባይ ሄሳዳ ꬋያና። ");
INSERT INTO gofENT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","ዎይኮ ቃሲ ሳሊሆሜ ጊያ ቤሳን ጊምቤይ ዎዲዲ ዎꬊዳ ታማኔ ሆስፑን ኣሳይ ዬሩሳላሜን ዴዒያ ኣሳ ኡባፌ ኣꬊዳ ናጋራንቾ ዳኖና? ");
INSERT INTO gofENT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","ጊዴና! ሺን ሂንቴካ ማሮታን ሲሞና ኢፂኮ ኡባይ ሄሳዳ ꬋያና።» ");
INSERT INTO gofENT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","ቃሲካ ዬሱሲ ሃይሳዳ ጊዲ ሌሚሶ ኦዲስ፡ «ኢሲ ኡራስ ዎይኔ ጋዴን ቶኬቲዳ ባላሴ ሚꬂያ ዴዓዉሱ። ኢ ኢፔ ኣይፌ ኮዪ ዪዲ ኣይኮካ ዴሚቤና። ");
INSERT INTO gofENT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","ጋዲያ ጎዳይ ዎይኔ ኦሳንቹዋኮ፥ ‹ኣይፌ ዴማናው ኮያዳ ሄꬑ ላይꬂ ሲሜሬታዳ ኣይኮካ ዴማቢኬ። ሄሳ ጊሾ፥ ቃንፃ ዲጋ፤ ኣይስ ቢታ ሜሊሳይ?› ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","«ሺን ኦሳንቾይ፥ ‹ጎዳው፥ ኢ ዩሹዋ ኦꬃዳ ኦሻ ዬጋና ጋካናው ሃ ላይꬃስ ኣጋርኪ። ");
INSERT INTO gofENT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","ሃ ላይꬂ ኣይፊኮ ሎዖ፥ ኢፂኮ ቃንፃ ኣጋ› » ያጊዲ ዛሪስ። ");
INSERT INTO gofENT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","ዬሱሲ ሳምባታ ጋላስ ኣይሁዴ ዎሳ ኬꬃን ታማርሴስ። ");
INSERT INTO gofENT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","ሄ ቤሳን ታማኔ ሆስፑን ላይꬂ ቱና ኣያኒ ዞኮ ኩኒሲዳ ኢሲ ማጫሲያ ዴዓዉሱ። ኢያ ኩናፔ ዴንዶይሳን ሱሬ ኤቃናው ዳንዳዑኩ። ");
INSERT INTO gofENT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","ዬሱሲ ኢዮ ቤዒዳ ዎዴ ፄጊዲ፥ «ሃ ማጫሴቴ፥ ኔ ሃርጊያፌ ፓፃዳሳ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","ባ ኩሺያ ኢ ቦላ ዎꬂን፥ ኢያ ሶሁዋራ ሱራዳ ኤቃሱ። ፆሳካ ጋላታሱ። ");
INSERT INTO gofENT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","ሺን ኣይሁዴ ዎሳ ኬꬃ ሃላቃይ ዪሎቲዲ ኣሳኮ፥ «ኦሶ ኦꬂያ ኡሱፑን ጋላሳቲ ዴዖሶና። ሄሳ ጊሾ፥ ሄ ጋላሳታን ዪዲ ፓፂቴፔ ኣቲን ሳምባታ ጋላስ ጊዴና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","ጎዳይ፥ «ጩቦቶ፥ ሂንቴ ጊዶፌ ቦሪ ዎይኮ ሃሬ ሳምባታ ጋላስ ዛዳሎፔ ቢሊዲ ሃꬄ ኡሻናው ኤፎናይ ኦኔ? ");
INSERT INTO gofENT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","ያቲን፥ ሃ ማጫሲያ ኣብራሃሜ ናዓ ጊዳሼ ፃላሄን ቃሼታዳ ታማኔ ሆስፑን ላይꬂ ኩሜꬂ ዴዒዳሪስ ሳምባታ ጋላስ ቢርሼቴꬂ ኮሼኔ?» ያጊዲ ኦይቺስ። ");
INSERT INTO gofENT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","ኢ ሄሳ ኦዲዳ ዎዴ ኤቄቴይሳቲ ኡባይ ዬላቲዶሶና። ሺን ኣሳ ኡባይ ኢ ኦꬂዳ ማላሊሲያ ኦሶ ኡባን ኡፋይቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","ሄሳፌ ጉዬ፥ ዬሱሲ ሃይሳዳ ያጊስ፥ «ፆሳ ካዎቴꬃይ ኣይ ዳኒ? ኢያ ኣይቢራ ዳኒሶ? ");
INSERT INTO gofENT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","ፆሳ ካዎቴꬃይ ኢሲ ኣሲ ባ ጎሻን ቶኪዳ ዎላ ኣይፌ ሜላ። ኢ ዲጪዲ ሚꬂ ጊዲስ። ሳሎ ካፎቲ ኢያ ታሺያ ቦላ ሼምፒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","ቃሲ፥ «ፆሳ ካዎቴꬃ ኣይቢራ ዳኒሶ? ");
INSERT INTO gofENT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","ኢሲ ማጫሲያ ዳሮ ꬊሌራ ዋላካዳ ሙኑቂዳ ጉꬃ ኢርሾ ዳኔስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","ሄሳፌ ጉዬ፥ ዬሱሲ ዬሩሳላሜ ቢሼ ኢ ካንꬂያ ኦጊያን ዴዒያ ካታማታኒኔ ጉታታን ታማርሲሼ ኣꬊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","ኢሲ ኣሲ ዬሱሳኮ፥ «ጎዳው፥ ኣታናይ ጉꬃ ኣሳ ፃላሌ?» ያጊዲ ኦይቺስ። ዬሱሲ ኤንታኮ፥ ");
INSERT INTO gofENT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«ሲዒቴ፥ ፁንꬃ ዉላራ ጌላናው ባፄቲቴ። ዳሮቲ ጌላናው ኮዮሶና ሺን ኤንታው ሃኔና። ");
INSERT INTO gofENT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","ኬꬃዋይ ዴንዲዲ ዉላ ጎርዲዳፔ ጉዬ ‹ኑስ ዶያርኪ› ያጊሼ ካሬን ኤቂዲ ፄሲ ኦይኬታ። ሺን ኢ፥ ‹ሂንቴ ኦኔኮኔ ኣዉፔ ዪዳኮ ታ ኤሪኬ› ጊዲ ዛራና። ");
INSERT INTO gofENT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","ሄ ዎዴ ሂንቴ፥ ‹ኔራ ዎላ ሚዳ፥ ኡዪዳ፥ ኑ ዳባባንካ ታማርሳዳሳ› ያጋና። ");
INSERT INTO gofENT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","«ኢ ዛሪዲ፥ ‹ሂንቴ ኦኔኮኔ ኣዉፔ ዪዳኮ ኤሪኬ። ሂንቴኖ፥ ጌላቶ ታፔ ሃኪቴ› ያጋና። ");
INSERT INTO gofENT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","ኣብራሃሜ፥ ዪሳቃ፥ ያይቆባኔ ናቤታ ኡባ ፆሳ ካዎቴꬃን ቤዓና፥ ሺን ሂንቴ ካሬን ዎꬊዲ ኣቲያ ዎዴ ሂንቴው ዬሆኔ ኣቼ ጋርጬꬂ ጊዳና። ");
INSERT INTO gofENT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","ኣሳይ ዶሎሃፔ፥ ዉሎሃፔ፥ ፑዴሃፔኔ ዱጌሃፔ ዪዲ ፆሳ ካዎቴꬃን ጊቢራ ቦላ ኡታና። ");
INSERT INTO gofENT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","ሄሳ ጊሾ፥ ሃዒ ዴꬃን ጉዬ ጊዲዳይሳታፔ ሲንꬄ ጊዳናይሳቲ፥ ሲንꬄ ጊዲዳይሳታፔ ጉዬ ጊዳናይሳቲ ዴዖሶና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","ሄ ዎዴ ፋሪሳዌታፔ ኢሶቲ ኢሶቲ ዪዲ፥ «ሄሮዲሲ ኔና ዎꬋናው ኮያ ጊሾ ሃ ቤሳፌ ዴንዳዳ ባ ጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","ኢ ዛሪዲ፥ «ቢዲ፥ ሄ ዎርካናስ ሄኮ፥ ‹ሃቺኔ ዎንቶ ቱና ኣያናታ ኬሳና፥ ሃርጋንቾታ ፓꬃና፥ ሄꬓንꬆ ጋላሳን ኩሻ ቦላ ጋካና› ያጊስ ጊቴ። ");
INSERT INTO gofENT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","ሃኖፔ ኣቲን፥ ናቤይ ዬሩሳላሜፔ ካሬን ሃይቃናው ቤሴና። ሄሳ ጊሾ፥ ሃቺ፥ ዎንቶኔ ዎንቲ ፔዒን ሄ ቤሳ ባናው ዴንዳስ። ");
INSERT INTO gofENT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","«ዬሩሳላሜ፥ ዬሩሳላሜ፥ ናቤታ ዎꬊያሬ፥ ኔኮ ኪቴቲዳይሳታ ሹቻን ጫዲያሬ፥ ኩቶይ ባ ናይታ ባ ቄፊያፔ ጋርሳን ሺሺያዳ ኔ ናይታ ታ ቄሲያፔ ጋርሳን ኣፑን ቶሆ ሺሻናው ኮያዲና፥ ሺን ሂንቴ ኢፃስ ጊዴታ። ");
INSERT INTO gofENT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","ታ ሂንቴው ኦዳይስ፤ ሂንቴ ኬꬃይ ካይሳታና። ጎዳ ሱንꬃን ዬይሲ ኣንጄቲዳይሳ ሂንቴ ጋና ጋካናው ታና ዴሜኬታ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","ኢሲ ሳምባታ ጋላስ ዬሱሲ ኢሲ ፋሪሳዌታ ሃላቃ ሶ ካꬂ ማናው ጌሊያ ዎዴ ኣሳይ ጫዲ ፄሎሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","ሄ ቤሳን ሻዉሄ ሃርጌን ዋዬቲያ ኢሲ ኣሲ ኢያው ሲንꬃ ባጋራ ዚንዒስ። ");
INSERT INTO gofENT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","ዬሱሲ ፋሪሳዌታኮኔ ሂጌ ኣስታማሬታኮ፥ «ሳምባታ ጋላስ ሃርጋንቾ ፓሶይ ዎጌዬ ዎጋ ጊዴኔ?» ያጊዲ ኦይቺስ። ");
INSERT INTO gofENT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","ኤንቲ ሲዒ ጊዶሶና። ዬሱሲ ሃርጌቲያ ኡራ ቦቺ ፓꬂዲ ሞይዚስ። ");
INSERT INTO gofENT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","«ቃሲካ ሂንቴፌ ኢሱዋስ ናዒ ዎይኮ ቦሪ ሳምባታ ጋላስ ኣፎን ዉሊኮ ኤሌሲዲ ኬሶናይ ኦኔ?» ያጊዲ ኦይቺስ። ");
INSERT INTO gofENT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","ኤንቲ ኢሲባካ ዛራናው ዳንዳዒቦኮና። ");
INSERT INTO gofENT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","ዬሱሲ ኢማቱዋስ ፄጌቲዳይሳቲ ቦንቾ ቤሲ ዶሪሺን ቤዒዲ፥ ሃ ሌሚሱዋ ኦዲስ፡ ");
INSERT INTO gofENT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«ኢሲ ኣሲ ኔና ያጋኖ ፄጊኮ ቦንቾ ቤሳን ኡቶፋ። ኔፔ ኣꬊ ቦንቼቲያ ኣሲ ፄጌታናው ዳንዳዔስ። ");
INSERT INTO gofENT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ሂንቴና ናምዓታካ ፄጊዳይሲ ዪዲ፥ ‹ኔ ቤሳ ሃ ኢማꬃስ ዬዳ› ያጊያ ዎዴ ኔኒ ዬላታሼ ዚቃ ቤሲ ዎꬋሳ። ");
INSERT INTO gofENT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","ጊዶሺን፥ ኔ ፄጌቲዳ ዎዴ ኮይሮታዳ ዚቃ ቤሲ ቤዓዳ ኡታ። ፄጎይሲ ዪዲ፥ ‹ታ ላጊያው፥ ሃ ቦንቾ ቤሳን ኡታ› ያጋና። ሄ ዎዴ ኔራ ኢሲፌ ፄጌቲዳ ኣሳ ኡባ ሲንꬃን ኔ ቦንቼታና። ");
INSERT INTO gofENT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","ባና ꬎቁ ꬎቁ ኦꬂያ ኡባይ ካዉያና፤ ባና ዚቂ ዚቂ ኦꬂያ ኡባይ ꬎቁ ꬎቁ ጋና።» ");
INSERT INTO gofENT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","ቃሲ ዬሱሲ ኢያ ሞኪዳ ኬꬃ ኣዋኮ፥ «ቁማ ዎይኮ ካሆ ኢማቶ ፄጊያ ዎዴ ኔኒ ኩሼ ዛሮ ፄጎና ሜላ ኔ ላጌታ ዎይኮ ኔ ኢሻታ ዎይኮ ኔ ዳቦታ ዎይኮ ኔ ዱሬ ሾሮታ ኢማቶ ፄጎፓ። ");
INSERT INTO gofENT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","ጊዶሺን፥ ኔ ኢማቶ ጊጊሲዳ ዎዴ ማንቆታ፥ ዎቤታ፥ ጉንዳታኔ ቆቄታ ፄጋ፤ ኔኒ ኣንጄታና። ");
INSERT INTO gofENT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","ሃይሳቲ ኩሼ ዛራናው ዳንዳዖና ጊሾ ኩሼ ዛሮይ ጌሻታ ዴንዶ ጋላሳን ኔው ሲማና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","ዬሱሳራ ዎላ ኢማቶ ቦላ ኡቶይሳታ ጊዶፌ ኢሶይ ሄሳ ሲዒዲ፥ «ፆሳ ካዎቴꬃን ኢማቶ ቦላ ኡቴይሲ ኣንጄቲዳይሳ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","ዬሱሲ፥ «ኢሲ ኣሲ ጊታ ኢማቶ ጊጊሲዲ ዳሮ ኣሳታ ፄጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","ኢማቶይ ሞኬቲያ ሳቴይ ጋኪያ ዎዴ ፄጌቲዳ ኢማꬃታ፥ ‹ሄኮ ኡባባይ ጊጊስ፥ ሃ ዪቴ› ያጊዲ ፄጋናዳ ባ ኣይሊያ ኪቲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","«ሺን ኡባይካ ባንታ ጋሶ ጋሶ ሜꬊዶሶና። ኢሶይ፥ ‹ሃዒ ቡሮ ጋዴ ሻሚዳ ጊሾ ባዳ ቤዓናው ኮሼስ ሃያና ታና ኣጋርኪ ያጋ› ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","ሃንኮይ፥ ‹ኢቻሹ ዋꬃ ቦሪ ሻማስ ኤንታና ዋፃ ቤዓና ጊሾ ሃያና ታና ላንጮፋ› ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","ቃሲ ሃራይ፥ ‹ታኒ ቡሮ ሜዳን ዴዒያ ጊሾ ያናው ዳንዳዒኬ› ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","«ኣይሌይ ሲሚ ዪዲ ሄ ኡባ ባ ጎዳስ ኦዲስ። ሄ ዎዴ ያጋኖ ኣዋይ ሃንቄቲዲ ኣይሊያኮ፥ ‹ኤሌሳዳ ካታማን ዴዒያ ዎጋ ኦጌታኔ ዳጋላታ ባዳ፥ ማንቆታ፥ ዎቤታ፥ ቆቄታኔ ጉንዳታ ሃ ኤሃ› ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","«ኣይሌይ፥ ‹ታ ጎዳው፥ ኔ ኪቲዳይሲ ኡባይ ፖሌቲስ፥ ሺን ሃዒካ ቤሲ ዴዔስ› ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","«ጎዳይ ኣይሊያኮ፥ ‹ሆሮጋታ ቦላኔ፥ ጋዴ ጊዶ ኦጌታ ኬያ፥ ታ ኬꬃይ ኩማና ጋካናው ዴሚዳ ኡባ ያና ሜላ ኦꬃ። ");
INSERT INTO gofENT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","ታ ሂንቴው ኦዳይስ፤ ኢማቶቲዳይሳታፔ ኦኒካ ታ ጊቢራፔ ሞናይሳ ኤሪቴ› ጊስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","ዳሮ ኣሳይ ኢያራ ዎላ ቢሺን ዬሱሲ ኤንታኮ ጉዬ ሲሚዲ፥ ");
INSERT INTO gofENT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«ታኮ ያ ኡባይ ባ ኣዋኔ ባ ኣዪው፥ ባ ማቺዉኔ ባ ናይታ፥ ባ ኢሻታኔ ባ ሚቼታ፥ ሃሪ ኣቶሺን ባ ዴዑዋ ኢፆናይ ታ ታማሬ ጊዳናው ዳንዳዔና። ");
INSERT INTO gofENT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","ባ ማስቃሊያ ቶኪዲ ታና ካሎናይ ታ ታማሬ ጊዳናው ዳንዳዔና። ");
INSERT INTO gofENT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","«ሂንቴፌ ኢሲ ኣሲ ሹቻ ኬꬂ ኬፃናው ኮይኮ፥ ኬꬃ ኬፂዲ ኦንጋናው ኣይ ሜላ ሚሼ ኮሺያኮ ኮይሮቲዲ ኤራናው ቆፒ ቤዖናይ ኦኔ? ");
INSERT INTO gofENT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","ሄሳ ጊዶና ኢፂኮ፥ ሃ ኡራይ ባሶ ሹቻ ሂፂን ቁስቴꬂ ፆኒኮ፥ ");
INSERT INTO gofENT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","ቤዒያ ኡባይ፥ ‹ሃ ኡራይ ጊምቤꬂ ኦይኪን ቁስታናው ኢያ ፆኒስ› ያጊዲ ቦሮሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","«ዎይኮ ኢሲ ካዎይ ሃራ ካዎራ ኦሌታናው ዴንዲሼ ላታሙ ሙኩሉ ኦላንቾታ ኤኪ ያ ካዉዋራ ታሙ ሙኩሉ ኦላንቾታራ ኤቄታናው ዳንዳዓናይሳኔ ዳንዳዖናይሳ ኡቲዲ ዞሬቶናይ ኦኔ? ");
INSERT INTO gofENT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","ኤቄታናው ዳንዳዔቶናባ ጊዲኮ፥ ሄ ሃራ ካዉዋራ ሃሆን ዴዒሺን ጊጋናው ኮይሮቲዲ ጪማ ዬዲዲ ኦይቼስ። ");
INSERT INTO gofENT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","ሄሳዳካ፥ ሂንቴፌ ኦኒካ ባው ዴዒያባ ኡባ ኣጎና ኢፂኮ ታ ታማሬ ጊዳናው ዳንዳዔና። ");
INSERT INTO gofENT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","«ማፂኔይ ሎዖ፥ ሺን ማፂኔይ ባ ማልዑዋ ኣጊኮ፥ ዋኒዲ ማፂኔ ጌቴታናው ዳንዳዒ? ");
INSERT INTO gofENT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","ቢታቴꬃስካ ኣራዳቴꬃስካ ማዶናባ ጊዲያ ጊሾ ዎራ ዬጌቴስ። ሂዛ፥ ሲዒያ ሃይꬂ ዴዒያ ኣሲ ሲዖ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","ኢሲ ጋላስ ቃራፃ ቃንፄይሳቲኔ ናጋራንቾቲ ዬሱሳ ቲሚርቲያ ሲዓናው ኢያ ዩሹዋን ሺቂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","ሺን ፋሪሳዌቲኔ ሂጌ ኣስታማሬቲ፥ «ሃይሲ ኡራይ ናጋራንቾታ ሺሺዲ ኤኬስ፥ ኤንታራ ኢሲፌ ሜስ» ያጊዲ ዙዙሚዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","ዬሱሲ ያጊዲ ሃይሳ ሌሚሶ ኤንታው ኦዲስ፡ ");
INSERT INTO gofENT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«ሂንቴ ጊዶፌ ኢሱዋስ ፄቱ ዶርሳቲ ዴዒያባ ጊዲኮ ኤንታፌ ኢሶይ ꬋዪኮ ኡዱፉን ታማኔ ኡዱፉናታ ባዞን ኣጊዲ ꬋዮይሳ ዴማና ጋካናው ኮዮናይ ኦኔ? ");
INSERT INTO gofENT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","ዴሚዳ ዎዴ ኡፋይቲዲ ባ ጋናን ቶኪዲ፥ ");
INSERT INTO gofENT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ባ ሶ ሲሜስ። ባ ላጌታኔ ሾሮታ ኢሲፌ ፄጊዲ፥ ‹ꬋዪዳ ታ ዶርሳ ዴማስ፥ ታራ ኢሲፌ ኡፋይቲቴ› ያጌስ። ");
INSERT INTO gofENT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","ሄሳዳካ፥ ማሮቲ ኮሾና ኡዱፉን ታማኔ ኡዱፉን ፂሎታፔ ኣꬂዲ ማሮታን ጌሊያ ኢሲ ናጋራንቹዋ ጋሶን ሳሎን ጊታ ኡፋይሲ ጊዴስ። ");
INSERT INTO gofENT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","«ዎይኮ ታሙ ቢሪ ዴዒያ ኢሲ ማጫሲያ ታማፌ ኢሲያ ꬋዪኮ ዴማና ጋካናው ፆምፔ ኦይꬃዳ ኬꬃ ፒታዳ ሚንꬃ ኮዮናራ ኦኔ? ");
INSERT INTO gofENT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","ዴሚዳ ዎዴ ባ ላጌታኔ ባ ሾሮታ ፄጋዳ ‹ꬋዪዳ ታ ኢሲ ቢራ ዴሚዳ ጊሾ ታራ ኡፋይቲቴ› ያጋዉሱ። ");
INSERT INTO gofENT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","ሲዒቴ፥ ሄሳ ሜላ ኢሲ ማሮቴꬃን ጌሊያ ናጋራንቹዋን ፆሳ ኪታንቾታ ሲንꬃን ኡፋይሲ ጊዴስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","ዛሪዲ ዬሱሲ፥ «ኢሲ ኡራስ ናምዑ ናይቲ ዴዖሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","ኤንታፌ ካሎ ናዓይ ባ ኣዋኮ፥ ‹ታ ኣዋው፥ ኔ ሻሉዋፔ ታ ጊሹዋ ታው ኢማ› ያጊስ። ኣዋይ ባ ሻሉዋ ባ ናይታስ ሻኪስ። ");
INSERT INTO gofENT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","ጉꬃ ጋላሳፔ ጉዬ ካሎ ናዓይ ባ ጊሹዋ ኡባ ቃቺ ኤኪዲ ሃሆ ቢታ ቢስ። ያን ኣልታጫን ሻሉዋ ቶቺዲ ኦንጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","ኢ ባው ዴዒያባ ኡባ ዉርሲዳፔ ጉዬ ሄ ቢታ ኡባን ሚኖ ኮሺ ኬዪን ሜቶቲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","ሄሳ ጊሾ፥ ሄ ቢታ ኣሳፔ ኢሱዋ ሶ ጋታ ጌሊስ። ኡራይ ኢያ ጉዱንꬆ ሄማና ሜላ ባ ሞꬃ ዬዲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","ጉዱንꬆቲ ሚያ ሃርቁዋፌ ማናው ኣሞቲስ፥ ሺን ኢዮካ ኢያው ኢሚያ ኣሲ ቤንቲቤና። ");
INSERT INTO gofENT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","ዎዛኒ ሲሚን፥ ‹ኣፑን ታ ኣዋ ኣይሌታስ ካꬂ ዎራ ዎꬊን ታ ሃይሳን ኮሻራ ሃይቃናው ጋካዲና?› ");
INSERT INTO gofENT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","ዴንዳዳ ታ ኣዋኮ ባዳ፥ ‹ታ ኣዋው፥ ሳሎን ፆሳ፥ ሳዓን ኔና ቆሃስ። ");
INSERT INTO gofENT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","ሂዛፔ ኔ ናዓ ጌቴታዳ ፄጌታናው ታው ቤሶና ጊሾ ኔ ሶን ዴዒያ ኣይሌታፔ ኢሱዋዳ ታና ፓይዳ› ያጋና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","ሄሳ ጊሾ፥ ዴንዲዲ ባ ኣዋኮ ቢስ። «ሃኖሺን፥ ኢ ቡሮ ሃሆን ዴዒሺን ኣዋይ ቃꬌቲዲ፥ ኢያኮ ዎፂ ቢዲ ኢዲሚዲ ዬሪስ። ");
INSERT INTO gofENT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","ናዓይካ፥ ‹ታ ኣዋው ሳሎን ፆሳ፥ ሳዓን ኔና ታ ቆሃስ። ሂዛፔ ኔ ናዓ ጌቴታዳ ፄጌታናው ቤሲኬ› ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","«ኢያ ኣዋይ ኣይሌታ ፄጊዲ፥ ‹ኤሌሲዲ ኡባፌ ሎዖ ጊዲዳ ማዖ ኤሂዲ ኢያ ማይዚቴ፤ ኢያ ቢራꬌን ሳጋዮ፥ ኢያ ቶሁዋን ጫማ ኣꬂቴ። ");
INSERT INTO gofENT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","ሞꬎ ጋታርሜንꬆ ኤሂዲ ሹኪቴ፥ ሞስ፥ ኡፋይቶስ። ");
INSERT INTO gofENT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","ታ ናዓይ ሃይሲ ሃይቂስ፥ ሺን ሃዒ ፓፂስ፤ ꬋይስ፥ ሺን ቤንቲስ› ያጊስ። ሄሳፌ ጉዬ፥ ኡፋዬቴꬂ ኦይኪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","«ሄ ዎዴ ባይራ ናዓይ ጎሻ ጋዴን ዴዔስ። ያፔ ዪሼ ሶ ማቲሺን ዬꬂኔ ጉፋ ጊርሲ ሲዒስ። ");
INSERT INTO gofENT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","ኢ፥ ኣይሌታፔ ኢሱዋ ፄጊዲ ሃኒያባይ ኣይቤኮ ኤራናው ኦይቺስ። ");
INSERT INTO gofENT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","ኣይሌይ፥ ‹ኔ ኢሻይ ሳሮ ዪዳ ጊሾ ኔ ኣዋይ ሞꬎ ጋታርሜንꬆ ኢያው ሹኪስ› ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","«ባይራ ኢሻይ ዪሎቲዲ ሶ ጌላናዉካ ኮዪቤና። ኣዋይ ካሬ ኬዪዲ ሶ ጌላና ሜላ ኢያ ዎሲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","ሺን ኢ ባ ኣዋኮ፥ ‹ሄኮ፥ ሃይሳ ሜላ ላይꬂ ታ ኔው ኣይሌታዳ ኔ ኪታፔ ኢሱዋካ ፓጪሶና ኔው ኪቴቲን ታ ታ ላጌታራ ኡፋይታና ሜላ ሃሪ ኣቶሺን ኢሲ ላቃ ዴሼ ኢማባካ። ");
INSERT INTO gofENT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","ሃኖሺን፥ ሃይሲ ኔ ናዓይ ኔ ሻሉዋ ላይማታራ ዶሚሲዲ ዪን ሞꬎ ጋታርሜንꬆ ሹካዳሳ› » ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","«ኣዋይካ፥ ‹ታ ናዓው፥ ኔኒ ኡባ ዎዴ ታራ ዴዓሳ፥ ታባይ ኡባይ ኔሳ። ");
INSERT INTO gofENT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","ሃይሲ ኔ ኢሻይ ሃይቂስ፥ ሺን ፓፂስ፤ ꬋይስ፥ ሺን ቤንቲስ። ሄሳ ጊሾ፥ ዳሮ ኡፋይታናው ቤሴስ› ያጋና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","ዬሱሲ ባ ታማሬታኮ፥ «ኢሲ ዱሬ ኡራስ ኢያፔ ጋርሳራ ኢሲ ሹማይ ዴዔስ። ሄ ሹማይ ባ ጎዳ ሻሉዋ ቶቼስ ያጊያ ዎሬይ ኬꬃዋ ጋኪስ። ");
INSERT INTO gofENT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","ኬꬃዋይ ሹማ ፄጊሲዲ፥ ‹ታኒ ዎይጊያባ ሲዓዲና? ሂዛፔ ኔኒ ታ ኬꬃስ ሹማ ጊዳዳ ኦꬃናው ዳንዳዖና ጊሾ ታ ሻሉዋ ታው ሼꬋ› ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","«ሄ ሹማይካ ባ ዎዛናን ሃይሳዳ ያጊዲ ቆፒስ። ‹ታ ጎዳይ ታና ሹማቴꬃፌ ዎꬃና ሃኔስ፥ ጎያ ኣቃናው ዎልቂ ባዋ፥ ዎሳ ማናው ዬላዬስ፤ ያቲን ታ ዋኖ? ");
INSERT INTO gofENT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","ሹማቴꬃፌ ታ ዎꬊያ ዎዴ ኣሳይ ታና ሞካና ሜላ ኦꬃናባ ታ ኤራይስ› ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","«ሄሳ ጊሾ፥ ኢያ ጎዳ ኣጮይ ዴዒያ ኣሳ ኢሱዋ ኢሱዋ ፄጊ ኤሂዲ ኮይሮ ኡራኮ፥ ‹ኔ ቦላ ታ ጎዳ ኣጮይ ኣይ ሜሊ ዴዒ?› ያጊዲ ኦይቺስ። ");
INSERT INTO gofENT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","«ኢ፥ ‹ላታሙ ባርሜሌ ዛይቴ ኣጮይ ዴዔስ› ያጊስ። «ሹማይ፥ ‹ዉሌ ዋርቃቲያ ሄዔ፥ ኤሌሳዳ፥ ታሙ ባርሜሌ ዛይቴ ኣጮይ ዴዔስ ጋዳ ፃፋ› ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","«ሄሳፌ ካሊዲ ናምዓንꬁዋኮ፥ ‹ኔው ኣፑኒ ዴዒ?› ያጊስ። «ኢ፥ ‹370 ኩንታሌ ጊስቴ ኣጮይ ዴዔስ› ያጊስ። «ሹማይ፥ ‹ኔ ዉሌ ዋርቃቲያ ሄዔ፥ ኤሌሳዳ፥ 296 ኩንታሌ ያጋዳ ፃፋ› ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","ኬꬃዋይ ኣማኔቲቦና ሹማ ኢያ ቢላማቴꬃስ ናሺስ። ሃ ኣላሚያ ናይቲ ኣሴ ኦይꬃን ፖዖ ናይታፔ ኣꬊዳ ዎዛናማታ። ");
INSERT INTO gofENT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","«ሄሳ ጊሾ፥ ታ ሂንቴው ኦዳይስ፤ ሃ ኣላሚያ ሚሼይ ዉሪያ ዎዴ ሜሪና ኬꬃን ሞኬታና ሜላ ሃ ሚሺያራ ሂንቴው ላጌታ ሻሚቴ። ");
INSERT INTO gofENT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","ኡባፌ ጉꬃባን ኣማኔቲዳይ ዳሮባን ኣማኔቲዳይሳ ጊዴስ። ቃሲ ኡባፌ ጉꬃባን ኣማኔቶናይሲ ዳሮባን ኣማኔቴና። ");
INSERT INTO gofENT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","ሂዛ፥ ሃ ኣላሚያ ሚሼን ሂንቴ ኣማኔቶና ኢፂኮ ቱማ ሚሼ ሂንቴው ኦኒ ሃዳራ ኢማኔ? ");
INSERT INTO gofENT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","ሂንቴ ሃራ ኣሳ ሚሼን ኣማኔቶና ኢፂኮ፥ ሂንቴ ቡዞ ሚሼ ሂንቴው ኦኒ ኢማኔ? ");
INSERT INTO gofENT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","«ኢሲ ኣይሌይ ናምዑ ጎዳታስ ሃሬታናው ዳንዳዔና። ኢሱዋ ኢፂኮ ሃንኩዋ ዶሴስ ዎይኮ ኢሱዋኮ ሺቂኮ ሃንኩዋ ካꬌስ። ሄሳዳካ፥ ሂንቴ ፆሳሲኔ ሚሼስ ሃሬታናው ዳንዳዔኬታ።» ");
INSERT INTO gofENT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","ሚሼ ዶሲያ ፋሪሳዌቲ ሄሳ ሲዒዳ ዎዴ ዬሱሳ ቄልቂሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","ኢ፥ «ሂንቴ ሂንቴና ኣሳ ሲንꬃን ፂሊሴታ፥ ሺን ፆሳይ ሂንቴ ዎዛና ኤሬስ። ኣሳ ሲንꬃን ቦንቼቲዳይሲ ፆሳ ሲንꬃን ቦሬቲዳይሳ። ");
INSERT INTO gofENT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","«ሙሴ ሂጌይኔ ናቤታ ኪታይ ዮሃኒሳ ጋካናው ሂንቴው ኦዴቲሼ ጋምዒስ። ሄሳፌ ጉዬ፥ ፆሳ ካዎቴꬃ ዎንጌላይ ሳባኬቲሼ ጋምዒስ። ኣሲ ኡባይ ያ ጌላናው ዳፌቴስ። ");
INSERT INTO gofENT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","ጊዶሺን፥ ሂጊያፌ ኢሲ ላፋ ፒዳሌይ ኣታናፔ ሳሎይኔ ሳዓይ ኣꬌይሲ ካዉዬስ። ");
INSERT INTO gofENT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","«ባ ማቺው ዬዲዲ ሃራ ኤኪያ ኡባይ ላሜስ። ባ ኣዚናፔ ኣንጄቲዳሮ ኤኬይሲካ ላሜስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","«ኣልዖኔ ኣሌቆ ኣፊላ ማዒያ፥ ሳዒ ኢንጄቲን ጋላስ ጋላስ ኡፋይሳን ዴዒያ ኢሲ ዱሬ ኣሲ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","ሃሪ ቃሲ ኣሳቴꬃይ ኩሜꬂ ማዱንፂዳ ኢሲ ኣላዛራ ጌቴቲያ ማንቆይ ሄ ዱሬ ኡራ ካሬን ዬጌቲዲ ኣቲዳይሲ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ኮሻፔ ዴንዶይሳን ዱሬ ኡራ ጋይታፔ ዎꬊያ ቲፊያ ማናው ኣሞቲሼ ዴዔስ። ሃሪ ኣቶሺን፥ ካናቲ ዪዲ ኢያ ማዱንꬃ ላጮሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","«ሄ ማንቆይ ሃይቂስ፤ ኪታንቾቲ ኢያ ኣብራሃሜ ኪዑዋ ኤፊዶሶና። ቃሲ ዱሬ ኡራይካ ሃይቂዲ ሞጌቲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","ሲዖሌን ኡንዔቲዲ ዴዒሼ ꬎቁ ጊዲ ሃሆን ኣብራሃሜኔ ኢያ ኪዖን ዴዒያ ኣላዛራ ቤዒስ። ");
INSERT INTO gofENT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","ኢ፥ ‹ኣዋው ኣብራሃሜ፥ ታው ቃꬌታርኪ፤ ሃ ላጮ ታማን ኡንዔታዳ ዴዒያ ጊሾ ኣላዛሪ ባ ቢራꬊያ ሃꬃን ዬዲዲ ታ ኢንፃርሳ ላኮꬃና ሜላ ሃያና ኢያ ዬዳርኪ› ያጊዲ ዋሲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","«ሺን ኣብራሃሜይ ኢያኮ፥ ‹ታ ናዓው፥ ኔ ሳዓን ዴዒያ ዎዴ ሎዖባታ ኤኪዳይሳ፥ ቃሲ ኣላዛሪ ኢታባታ ኤኪዳይሳ ኣኬካ። ሺን ሃዒ ኢ ሃይሳን ኡፋይቴስ፥ ቃሲ ኔኒ ዋዬታሼ ዴዓሳ› ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","ሃ ኡባፌ ኣꬊዲ፥ ‹ሃፔ ሂንቴኮ፥ ሂኒፔ ሃ ኑኮ ኣꬋናው ኮዬይሳቲ ፒኖና ሜላ ኑሲኔ ሂንቴስ ጊዶን ጊታ ኣፎይ ዴዔስ› ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","«ዱሬ ኡራይ፥ ‹ኣዋው፥ ያኮ ኣላዛራ ታ ኣዋ ሶ ኪታና ሜላ ታ ኔና ዎሳይስ። ");
INSERT INTO gofENT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ታው ኢቻሹ ኢሻቲ ዴዒዶሶና፥ ኤንቲካ ሃ ዋዬ ቤሳ ዮና ሜላ ኤንታው ቢዲ ማርካቶ› ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","«ሺን ኣብራሃሜይ፥ ‹ኤንታው ሙሴራኔ ናቤታራ ዴዖሶና፤ ኤንቲ ኦዲያባ ሲዖና› ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","«ዱሬ ኡራይ፥ ‹ኣዋው ኣብራሃሜ፥ ሄሳꬆ ጊዴና፤ ኢሲ ኣሲ ሃይቆፔ ዴንዲዲ ቢኮ ኤንቲ ማሮታን ጌላና› ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","«ኣብራሃሜይ፥ ‹ሙሴኔ ናቤታ ሲዖና ኢፂኮ፥ ሃሪ ኣቶሺን ሃይቆፔ ኢሲ ኣሲ ዴንዲ ኦዲኮካ ኣማኖኮና› ያጊስ።» ");
INSERT INTO gofENT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","ዬሱሲ ባ ታማሬታኮ፥ «ኣሴ ꬉቤꬂዲ ናጋራን ጌልሲያባይ ዮና ኣጌና። ጊዶሺን፥ ናጋራን ጌላና ሜላ ኦꬂያ ኡራ ኣዬ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","ሄ ኡራይ ካሎታፔ ኢሱዋ ባሌꬃናፔ ዎፃ ባ ቆꬌን ቃቺዲ ኣባን ዉሊኮ ኢያው ሎዖ። ");
INSERT INTO gofENT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","ሄሳ ጊሾ ናጌቲቴ። «ኔ ኢሻይ ናጋራ ኦꬂኮ ሃንቄታ፤ ቂሮቲዲ ማሮቴꬃን ሲሚኮ፥ ኢያው ኣቶ ያጋ። ");
INSERT INTO gofENT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","ኢሲ ጋላሳን ላፑን ቶሆ ቆሂዲ፥ ላፑን ቶሆ፥ ‹ታኒ ታ ባላ ኤራስ ታና ማራ› ያጊዲ ኔኮ ዪኮ ኢያው ኣቶ ጋ።» ");
INSERT INTO gofENT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","ሃዋሬቲ ጎዳኮ፥ «ኣማኖ ኑስ ጉጃርኪ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","ጎዳይ፥ «ጋሼ ኣይፌ ሜላ ኣማኖይ ሂንቴው ዴዒኮ ‹ሃይሳ ዎላ ሾዴታዳ ኣባ ጊዶን ቶኬታ› ያጊኮ ሂንቴው ኪቴታና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","ጉጂዲካ ዬሱሲ፥ «ሂንቴ ጊዶፌ ኢሱዋስ ጎሻንቾይ ዎይኮ ዶርሴ ሄሚያ ኣይሌይ ዴዒኮ ኦሶ ጋዴፔ ዎይኮ ዉዴፔ ሶ ሲሚያ ዎዴ ‹ኤሌ ሃያዳ ካꬂ ማናው ኡታ› ያጌይ ዴዒ? ");
INSERT INTO gofENT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","ዴና፥ ‹ታው ካሆ ጊጊሳ፤ ታኒ ማዳ፥ ኡያዳ ኣጋና ጋካናው ኤቃዳ ሙዛ። ሄሳፌ ጉዬ፥ ኔኒ ቃሲ ማሳኔ ኡያሳ› ያጌኔዬ? ");
INSERT INTO gofENT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","ሂዛ፥ ጎዳይ፥ ኣይሌይ ኪታ ፖሊዳ ጊሾ ኣንጂዬ? ");
INSERT INTO gofENT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","ሄሳ ጊሾ፥ ሂንቴካ ኪቴቶይሳ ኡባ ፖሊዳ ዎዴ ‹ኑ ፓꬆና ኣይሌታ፤ ኦꬃናው ቤሲያ ኦሱዋ ፖሊዳ› ያጊቴ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","ዬሱሲ ዬሩሳላሜ ቢሼ ሳማሪሲኔ ጋሊላ ቢታስ ጊዶራ ካንꬂዲ ኣꬊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","ኢሲ ጉታ ጌሊያ ዎዴ ባሮ ሃርጌን ኦይኬቲዳ ታሙ ኣሳቲ ኢያ ዴሚዶሶና። ኤንቲካ ሃሆን ኤቂዲ፥ ");
INSERT INTO gofENT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","«ጎዳ ዬሱሳ፥ ኑስ ቃꬌታርኪ» ያጊዲ ዋሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","ኢ ኤንታ ቤዒዳ ዎዴ «ቢዲ ሂንቴናቴꬃ ኣይሁዴ ካሂኔ ቤሲቴ» ያጊስ። ኤንቲ ኦጊያ ቦላ ቢሼ ፓፂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","ኤንታፌ ኢሶይ ባ ፓፁዋ ቤዒዳ ዎዴ ꬎቁ ጊዳ ቃላን ፆሳ ቦንቺሼ ዬሱሳኮ ሲሚስ። ");
INSERT INTO gofENT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","ኢ ሳማሬ ቢታ ኣሲ፥ ሺን ዬሱሳ ቶሁዋ ቦላ ጉፋኒዲ ኢያ ጋላቲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","ዬሱሲ፥ «ፓፂዳይ ታሙ ኣሳታ ጊዶኮናዬ? ያቲን፥ ኡዱፉናቲ ኣው ቢዶና? ");
INSERT INTO gofENT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","ሃ ኣላጋ ኡራፔ ኣቲን ሃሪ ሲሚዲ ፆሳ ጋላቴይ ዴና ጉሴዬ?» ያጊዲ ኦይቺስ። ");
INSERT INTO gofENT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","ኡራኮ፥ «ኔ ኣማኖይ ኔና ፓꬂስ፤ ዴንዳዳ ባ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","ፋሪሳዌቲ፥ «ፆሳ ካዎቴꬃይ ኣዉዴ ያኔ?» ጊዲ ዬሱሳ ኦይቺዶሶና። ኢ፥ «ፆሳ ካዎቴꬃይ ቤንቲያ ማላን ዬና። ");
INSERT INTO gofENT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","ቃሲካ ኢዮ፥ ‹ሃኒና ዎይኮ ሂኒና ያጋናው ዳንዳዔና። ኣይስ ጊኮ፥ ፆሳ ካዎቴꬃይ ሂንቴ ጊዶን ዴዔስ› » ያጊዲ ዛሪስ። ");
INSERT INTO gofENT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","ዬሱሲ ባ ታማሬታኮ፥ «ኣሳ ናዓ ጋላሳታፔ ኢሱዋ ቤዓናው ሂንቴ ኣሞቲያ ዎዴይ ያና፥ ሺን ሂንቴ ቤዔኬታ። ");
INSERT INTO gofENT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","ኣሳይ፥ ‹ኢ ያን ዴዔስ› ዎይኮ፥ ‹ሃይሳን ዴዔስ› ያጋና፥ ሺን ኤንታና ካሊዲ ቦፒቴ። ");
INSERT INTO gofENT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","ዎልዓንꬂ ዎልዓሚዲ ሳሉዋ ጋፃፔ ጋፃ ፖዒሲያ ሜላ ኣሳ ናዓ ዩሳ ጋላሳይ ሄሳዳ ሃናና። ");
INSERT INTO gofENT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","ሺን ሄሲ ሃናናፔ ሲንꬄ ኣሳ ናዓይ ዳሮ ዋያናዉኔ ሃ ዬሌቴꬃን ኢፄታናው ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","ኖሄ ዎዴ ሃኒዳይሳ ሜላ ኣሳ ናዓ ዎዲያንካ ሄሳዳ ሃናና። ");
INSERT INTO gofENT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","ኖሄይ ማርካቢያን ጌሊዳ ቃማ ጋካናው ኣሳይ ሚሼኔ ኡዪሼ፥ ኤኪሼኔ ጌሊሼ ዴዒሺን ꬋዮ ሃꬃይ ዪዲ ኡባ ꬋይሲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","ሎፄ ላይꬃንካ ሄሳꬆ ሃኒስ። ኣሳይ ሚሼኔ ኡዪሼ፥ ሻሚሼኔ ባይዚሼ፥ ቶኪሼኔ ኬፂሼ፥ ጋምዒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","ሎፄይ ሶዶሜፔ ኬዪዳ ጋላስ ዲኔ ጌቴቲያ ፁጊያባይ ሳሎፔ ቡኪዲ ኡባ ꬋይሲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","ኣሳ ናዓይ ቆንጪያ ዎዴካ ሄሳዳ ሃናና። ");
INSERT INTO gofENT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","«ሄ ጋላሳን ኦኒካ ካሬን ዴዔይ ኬꬃ ጊዶን ዴዒያባ ኤካናው ሶ ጌሎፖ። ሄሳዳካ፥ ጋዴን ዴዒያ ኣሲ ኣይኮስካ ሶ ሲሞፎ። ");
INSERT INTO gofENT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","ሎፄ ማቺው ኣኬኪቴ፤ ");
INSERT INTO gofENT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","ባ ሼምፒው ኣሻናው ኮያ ኣሲ ኦኒካ ꬋይሳና፤ ባ ሼምፒው ኣꬂ ኢሚያ ኦኒካ ኢ ኣሻና። ");
INSERT INTO gofENT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","ታ ሂንቴው ኦዳይስ፤ ሄ ጋላሳን ናምዑ ኣሳቲ ኢሲ ኣርሳን ዚንዓና። ኢሶይ ኤኬታና፥ ሃንኮይ ኣታና። ");
INSERT INTO gofENT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","ናምዑ ማጫሳቲ ዎላ ጋጪሺን ኢሲያ ኤኬታና፥ ሃንኪያ ኣታና። ");
INSERT INTO gofENT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","ናምዑ ኣሳቲ ዎላ ጋዴን ጎዬይሳታፔ ኢሶይ ኤኬታና፥ ሃንኮይ ኣታና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","ኤንቲ፥ «ጎዳው ኣው ኤኬታኔ?» ያጊዲ ኦይቺዶሶና። ኢ፥ «ባዉቲ ዴዒያ ቤሳን ኣንኮቲ ሺቆሶና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","ዬሱሲ ባ ታማሬታ ኣዛሎና ኡባ ዎዴ ዎሳና ሜላ ታማርሳናው ኮዪዲ ያጊዲ ሌሚሶ ኦዲስ፡ ");
INSERT INTO gofENT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","«ኢሲ ካታማን ፆሳስ ያሼቶና ኣሳስካ ዬላቶና ኢሲ ዳይኒ ዴዔስ ");
INSERT INTO gofENT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","ሄ ካታማን ኢሲ ኣምዒያ ዳዓዉሱ። ኢያካ፥ ‹ታዉኔ ታ ሞርኪያስ ጊዶን ዴዒያ ሞቱዋ ፒርዳ› ያጋዳ ኡባ ዎዴ ሄ ዳይናኮ ሲሜሬታዉሱ። ");
INSERT INTO gofENT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","ዳይናይ ጉꬃ ዎዴስ ኢ ኦዳ ሲዖና ኢፂስ፥ ሺን ጉዬፔ ባ ዎዛናን፥ ‹ታኒ ፆሳስ ያዮና፥ ኣሳስ ዬላቶና ኢፂኮካ፥ ");
INSERT INTO gofENT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ሃ ኣምዒያ ታና ዋይሲያ ጊሾ ኢው ፒርዳና፤ ያቶና ኢፂኮ ኡባ ዎዴ ያዳ ታና ሳሌꬃና› ያጊዲ ቆፒስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","ጎዳይካ፥ «ጌላ ዳይናይ ጊዳይሳ ሲዒዴታ፤ ");
INSERT INTO gofENT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","ፆሳይ ቃማኔ ጋላስ ኢያኮ ዋሲያ ባ ዶሪዳይሳታስ ፒርዴኔዬ? ኤንታና ማዳናው ጋምዒዬ? ");
INSERT INTO gofENT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","ታ ሂንቴው ኦዴይሳ ሲዒቴ፥ ኤሌሲዲ ፒርዳና። ጊዶሺን፥ ኣሳ ናዓይ ያ ዎዴ ሳዓ ቦላ ኣማኖ ዴማንዴሻ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","ቃሲ ዛሪዲ፥ ዬሱሲ፥ ባንታና ፂሎ ኣሳዳ ኦꬂዲ ጬቄቴይሳታሲኔ ሃራታ ካꬌይሳታስ ሃይሳዳ ያጊዲ ሌሚሶ ኦዲስ፡ ");
INSERT INTO gofENT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","«ናምዑ ኣሳቲ ዎሳናው ፆሳ ኬꬂ ቢዶሶና። ኢሶይ ፋሪሳዌ ሃንኮይ ቃሲ ቃራፃ ቃንፂሲያ ኣሲ። ");
INSERT INTO gofENT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","ፋሪሳዌይ ኤቂዲ ባው ዎሲሼ፥ ‹ፆሳው ታኒ ሃራታ ሜላ ቦንቃንቾ፥ ጌላኔ ላይማቲያ ኣሲ፥ ኣꬊዳ ቃሲ ሃ ቃራፃ ቃንፂሲያ ኡራ ሜላ ጊዶና ጊሾ ኔና ጋላታይስ። ");
INSERT INTO gofENT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","ሳሚንታፌ ናምዑ ቶሆ ፆማይስ፥ ታ ዴሚያባ ኡባፌ ኣሲራታ ኬሳይስ› ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","«ሺን ቃራፃ ቃንፂሴይሲ ቃሲ ሃሆን ኤቂዲ ሃሪ ኣቶሺን ሳሎ ꬎቁ ጊዲ ፄላናዉካ ያዪዲ ባ ቲራ ኢጪሼ ‹ፆሳው፥ ታና ናጋራንቹዋ ማራርኪ› ጊዲ ዎሲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","ታ ሂንቴው ኦዴይሳ ሲዒቴ፤ ፋሪሳዊያፔ ሃይሲ ቃራፃ ቃንፂሴይሲ ፆሳ ሲንꬃን ፂሎ ጊዲዲ ባ ሶ ሲሚስ። ኣይስ ጊኮ፥ ባና ꬎቁ ꬎቁ ኦꬂያ ኣሲ ካዉያና፥ ባና ካዉሺያ ኣሲ ꬎቁ ꬎቁ ጋና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","ዬሱሲ ዮጋ ናይታ ቦላ ባ ኩሺያ ዎꬂዲ ኣንጃና ሜላ ኣሳይ ኢያኮ ኤሆሶና። ዬሱሳ ታማሬቲ ሄሳ ቤዒዲ ኣይስ ዬሱሳኮ ኤሄቲ ያጊዲ ካጪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","ሺን ዬሱሲ ናይታ ባኮ ፄጊዲ፥ «ዮጋ ናይቲ ታኮ ያናይሳ ዲጎፊቴ፤ ዮ ጊቴ። ኣይስ ጊኮ፥ ፆሳ ካዎቴꬃይ ኤንታዳ ሃኒዳይሳታሳ። ");
INSERT INTO gofENT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","ታኒ ሂንቴው ቱማ ኦዳይስ፤ ፆሳ ካዎቴꬃ ዮጋ ናይታꬆ ኤኮናይ ኦኒካ ያ ጌሌና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","ኣይሁዴ ሃላቃታፔ ኢሶይ፥ «ኬሃ ኣስታማሪያው፥ ሜሪና ዴዑዋ ዴማናው ኣይ ኦꬆ?» ያጊዲ ኦይቺስ። ");
INSERT INTO gofENT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","ዬሱሲ ኢያኮ፥ «ኣይስ ታና ኬሃው ያጋዳ ፄጋይ? ኢሲ ፆሳፌ ኣቲን ሃሪ ኬሂ ባዋ። ");
INSERT INTO gofENT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","ላሞፋ፥ ዎꬎፓ፥ ካይሶቶፓ፥ ዎርዶ ማርካቶፋ፥ ኔ ኣዋኔ ኔ ኣዪው ቦንቻ ያጊያ ኪታ ኤራይ» ያጊዲ ኦይቺስ። ");
INSERT INTO gofENT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","ኡራይካ፥ «ሄሳታ ኡባ ታኒ ናዓቴꬃፌ ዶማዳ ናጋሼ ጋምዓስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","ዬሱሲ ሄሳ ሲዒዳ ዎዴ «ሂዛ፥ ኔው ኢሲባይ ፓጬስ፤ ኔው ዴዒያባ ኡባ ባይዛዳ ማንቆታስ ኢማ፤ ሳሎን ኔና ሻሎይ ናጌስ። ያታ ሲማዳ ታና ካላ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","ሺን ኡራይ ሄሳ ሲዒዳ ዎዴ ኢያው ዳሮ ሻሎይ ዴዒያ ጊሾ ዳሮ ቂሮቲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","ዬሱሲ ኡራ ቤዒዲ፥ «ዱሬ ኣሳስ ፆሳ ካዎቴꬃ ጌሎይ ዋኒዲ ኡንዓንዴሻ? ");
INSERT INTO gofENT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","ዱሬይ ፆሳ ካዎቴꬃ ጌላናይሳፌ ጊማሌይ ናርፔ ሉሆራ ካንꬄይሲ ካዉዬስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","ሄሳ ሲዒዳ ኣሳይ፥ «ሄሳ ጊዲኮ ኦኒ ኣታኔ?» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","ዬሱሲ፥ «ኣሳስ ዳንዳዔቶናባይ ፆሳስ ዳንዳዔቴስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","ጴፂሮሲ፥ «ሄኮ ኑኒ ኑባ ኡባ ኣጊዲ ኔና ካሊዳ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","«ዬሱሲ ቱማ ታ ሂንቴው ኦዳይስ፤ ፆሳ ካዎቴꬃስ ጊዲ ባ ኬꬃ ዎይኮ ባ ማቺው ዎይኮ ባ ኢሻታ ዎይኮ ባ ኣዋኔ ባ ኣዪው ዎይኮ ባ ናይታ ኣጊዳይ፤ ");
INSERT INTO gofENT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ሃ ዎዲያን ዳኮ ዳሮ፥ ያና ኣላሚያን ሜሪና ዴዑዋ ኤኮናይ ኦኒካ ባዋ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","ዬሱሲ ታማኔ ናምዓታ ባኮ ፄጊዲ፥ «ኣኔ ዬሩሳላሜ ቦስ፥ ናቤቲ ኣሳ ናዓባ ፃፊዳባ ኡባይ ያን ፖሌታና። ");
INSERT INTO gofENT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","ኢ ኣይሁዴ ጊዶና ኣሳስ ኣꬊዲ ኢሜታና። ኤንቲ ኢያ ቶቻና፥ ጫያናኔ ኢያ ቦላ ጩታና። ");
INSERT INTO gofENT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ኢያ ጋራፊዳፔ ጉዬ ዎꬋና፥ ሺን ሄꬓንꬆ ጋላሳን ኢ ሃይቆፔ ዴንዳና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","ሺን ኢያ ታማሬቲ ሄሳ ኡባፌ ኢሲባካ ኣኬኪቦኮና። ኢያ ፁራይ ኤንታው ቆሴቲዳ ጊሾ ኢ ዎይጊዳኮ ኤሪቦኮና። ");
INSERT INTO gofENT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","ዬሱሲ ኢያርኮ ማታቲያ ዎዴ ኢሲ ቆቄ ኡራይ ኦጌ ጋፃን ኡቲዲ ዎሴስ። ");
INSERT INTO gofENT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","ቆቄ ኡራይ ኣሳይ ሄ ቤሳራ ኣꬊሺን ሲዒዲ፥ «ኢ ኣይቤ?» ጊዲ ኦይቺስ። ");
INSERT INTO gofENT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","ኤንቲ፥ «ናዚሬቴ ዬሱሲ ሃይሳራ ኣꬌስ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","ኢ፥ «ዳዊቴ ናዓው፥ ዬሱሳ፥ ታና ማራርኪ» ያጊዲ ዋሲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","ሲንꬄ ሲንꬄ ቢያ ኣሳቲ፥ «ሲዒ ጋ» ጊዲ ሃንቄቲዶሶና። ሺን ኢ፥ «ዳዊቴ ናዓው፥ ታና ማራ» ያጊዲ ዳርሲ ዋሲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","ዬሱሲ ኤቂዲ ኡራ ባኮ ኤሃና ሜላ ኪቲስ። ኡራይካ፥ ኢያኮ ሺቂን፥ ");
INSERT INTO gofENT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«ታ ኔው ኣይ ኦꬃና ሜላ ኮያይ?» ያጊዲ ኦይቺስ። ቆቄይ፥ «ጎዳው ታ ፄላናው ኮያይስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","ዬሱሲ፥ «ፄላ፥ ኔ ኣማኖይ ኔና ፓꬂስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","ኡራይ ሶሁዋራ ፄሊ ኣጊስ። ፆሳ ቦንቺሼ ዬሱሳ ካሊስ። ኣሳ ኡባይ ሄሳ ቤዒዲ ፆሳ ጋላቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","ዬሱሲ ኢያርኮ ጌሊዲ ኣꬌስ። ");
INSERT INTO gofENT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","ያን ዛኪዮሳ ጌቴቲያ ቃራፃ ቃንፂሴይሳታ ሃላቃይ ዴዔስ። ኢ ዳሮ ዱሬ። ");
INSERT INTO gofENT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","ኢ ዬሱሲ ኦኔኮ ቤዓናው ኮዪስ። ኢ ቃንꬂ ጊዲያ ጊሾ ኣሳ ዳሮቴꬃፌ ዴንዶይሳን ዬሱሳ ቤዓናው ዳንዳዒቤና። ");
INSERT INTO gofENT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","ዬሱሳ ቤዓናው ኮዪዲ ኢ ቢያ ኦጊያስ ሲንꬄ ዎፂ ቢዲ ኢሲ ቦባ ሚꬃ ቦላ ኬዪስ። ");
INSERT INTO gofENT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","ዬሱሲ ሄ ቤሳ ጋኪሼ ꬎቁ ጊዲ ቤዒዲ፥ «ዛኪዮሳ፥ ሃቺ ታ ኔ ሶን ፔዓናው ቤሲያ ጊሾ ኤሌ ዎꬋ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","ኢ ኤሌሲ ዎꬊዲ ኡፋይሳን ዬሱሳ ሞኪስ። ");
INSERT INTO gofENT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","ሄ ቤሳን ዴዒያ ኣሳ ኡባይ ሄሳ ቤዒዲ፥ «ናጋራንቹዋ ሶ ጌሊዲ ሞኬታንው ሃኔስ» ያጊዲ ዙዙሚዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","ጊዶሺን፥ ዛኪዮሲ ኤቂዲ ጎዳኮ፥ «ጎዳው፥ ሄኮ ታው ዴዒያ ሻሎ ኡባፌ ባጋ ማንቆታስ ኢማና። ኣሳፔ ኣይባካ ዎርዶን ባሌꬃዳ ኤኪዳባ ጊዲኮ ኦይዱ ኩሼ ዛራና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","ዬሱሲ ቃሲ፥ «ሃ ኡራይ ኣብራሃሜ ናዓ ጊዲዳ ጊሾ ሃቺ ኣቶቴꬃይ ሃ ሶ ዪስ። ");
INSERT INTO gofENT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","ኣሳ ናዓይ ዪዳይ ꬋዪዳይሳ ኮያናሳኔ ኣሻናሳ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","ኣሳይ ሄሳ ሲዒያ ዎዴ ዬሱሲ ዬሩሳላሜ ማታቲዳ ጊሾኔ ፆሳ ካዎቴꬃይ ሃዒ ማታራ ቆንጫና ዳኒዳ ጊሾ ኤንታው ሌሚሶ ኦዲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","ሄሳ ጊሾ፥ ዬሱሲ፥ «ኢሲ ጊታ ኣሲ ዴዔይሲ ባው ካዎቴꬂ ኤኪዲ ያናው ሃራ ቢታ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","ኢያው ኦꬂያ ኣይሌታፔ ታማታ ፄጊዲ ኢሱዋስ ኢሱዋስ ታሙ ሚናኔ ኢሚዲ ‹ታ ሲማዳ ያና ጋካናው ሃ ሚሺያራ ዛልዒቴ› ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","«ሄ ቢታ ኣሳይ ኢያ ኢፂያ ጊሾ ሃ ኡራይ ኑ ቦላ ካዎታና ሜላ ኑ ኮዮኮ ያጊዲ ኣሴ ኢያ ጉዬራ ኪቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","«ጊዶሺን፥ ሄ ኡራይ ካዎ ጊዲዲ ባ ቢታ ሲሚስ። ሄ ታሙ ኣይሌቲ ኢ ኢሚዳ ሚሺያን ኣይ ሜላ ዛልዒዲ ዎꬊሲዳኮ ኤራናው ኮዪዲ ኤንታና ፄጊሲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","«ኮይሮይሲ ዪዲ፥ ‹ጎዳው፥ ኔ ታው ኢሚዳ ሚሼይ ሃራ ታማ ዎꬊስ› ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","«ኢያ ጎዳይ፥ ‹ኔኖ ኣማኔቲዳ ኣይሊያው ሎዖ ኦꬃዳሳ። ኔኒ ጉꬃባን ኣማኔቲዳ ጊሾ ኔው ታሙ ካታማታ ቦላ ማታ ኢማስ› ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","«ናምዓንꬆይካ ዪዲ፥ ‹ጎዳው፥ ኔ ታው ኢሚዳ ሚሼይ ሃራ ኢቻሻ ዎꬊስ› ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","«ጎዳይ ኢያኮ፥ ‹ኔዉካ ቃሲ ኢቻሹ ካታማታ ቦላ ማታ ኢማስ› ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","«ሄኮ ሄꬓንꬆይ ዪዲ፥ ‹ጎዳው፥ ታ ጩርቃን ፃፃዳ ናጊዳ ኔ ሚሺያ ሃናሹ። ");
INSERT INTO gofENT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","ኣይስ ጊኮ፥ ኔኒ ኔባ ጊዶናባ ኤኬይሳኔ ኔ ዜሮናባ ቡጪያ ኢታ ኣሲ ጊዲያ ጊሾ ኔው ያያስ› ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","«ኢያ ጎዳይ ዛሪዲ፥ ‹ኔኖ ኢታ ኣይሊያው ኔ ዶናꬆ ታ ኔና ፒርዳና። ታ ዎꬆናባ ኤኬይሳኔ ዜሮናባ ቡጪያ ኣሲ ጊዴይሳ ኔ ኤሪኮ፥ ");
INSERT INTO gofENT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","ታ ያዳ ታ ሚሺያ ዎꬌራ ኤካና ሜላ ዛልዒያ ኣሳስ ኣይስ ኢማቢኪ?› ");
INSERT INTO gofENT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","«ኢያ ጎዳይ ሄ ቤሳን ኤቂዳይሳታኮ፥ ‹ኢያራ ዴዒያ ሚሺያ ኤኪዲ ታማ ዎꬊሲዳይሳስ ኢሚቴ› ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","«ኤንቲ፥ ‹ጎዳው፥ ኢያው ካሴካ ታሙ ሚናኔይ ዴዔስ› ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","«ጎዳይ፥ ታ ሂንቴው ኦዳይስ፤ ‹ዴዒያ ኡባስ ሃሪ ጉዤታና፥ ሺን ባይናይሳፌ ሃራይ ኣቶ ኢያው ዴዒያራካ ኤኬታና። ");
INSERT INTO gofENT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","ጊዶሺን፥ ታ ኤንታ ቦላ ካዎቶና ሜላ ኮዪዳይሳታ ሄ ታ ሞርኬታ ሃ ታ ሲንꬄ ኤሂዲ ጎይሪቴ› ጊስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","ዬሱሲ ሄሳ ኦዲዳይሳፌ ጉዬ ኤንታፌ ሲንꬄ ኣꬊ ሃሙቲዲ ዬሩሳላሜ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","ሻማሆ ዴሪያ ቦላ ዴዒያ ቤቴፋጌኔ ቢታኒያ ማታቲዳ ዎዴ ባ ታማሬታፔ ናምዓታ ያጊዲ ኪቲስ፡ ");
INSERT INTO gofENT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","«ሂንቴ ሲንꬃን ዴዒያ ጉታ ቢቴ፥ ሂንቴ ያ ጋኪያ ዎዴ ኦኒካ ቶጎና ቃሼቲዲ ዴዒያ ሃሬ ማሪ ዴማና። ኢያ ቢሊዲ ሃ ኤኪ ዪቴ። ");
INSERT INTO gofENT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","ኦኒካ፥ ‹ኣይስ ቢሌቲ?› ጊዲ ኦይቺኮ፥ ‹ጎዳይ ኢያ ኮዬስ› ያጊቴ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","ኪቴቲዳይሳቲ ቢዲ ኢ ጊዳይሳዳ ሃኒን ቤዒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","ኤንቲ ሃሬ ማራ ቢሊሺን ጎዳቲ ቤዒዲ፥ «ሃሬ ማራ ኣይስ ቢሌቲ?» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","ኤንቲ ዛሪዲ፥ «ጎዳይ ኢያ ኮዬስ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","ያፔ ሃሬ ማራ ዬሱሳኮ ኤሂዶሶና። ባንታ ማዑዋ ሃሬ ማራ ዞኮን ዬጊዲ ዬሱሳ ሃሬ ማራ ቦላ ኡቲሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","ኣሳይካ ኢ ቢያ ኦጊያ ቦላ ባንታ ማዑዋ ሂፂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","ሻማሆ ዴሪያ ዱጌꬃ ዎꬊሲያ ኦጊያኮ ማቲያ ዎዴ ታይቦን ኬሂ ዳሮ ኣሳይ ኤንቲ ቤዒዳ ማላሊሲያባን ኡፋይቲዲ ባንታ ቃላ ꬎቁ ኦꬂዲ፥ ");
INSERT INTO gofENT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","«ጎዳ ሱንꬃን ያ ካዎይ ኣንጄቲዳይሳ ሳሉዋን ሳሮይ ኡባፌ ꬎቃ ሳሉዋን ቦንቾይ ፆሳስ ጊዶ።» ያጊዲ ፆሳ ጋላቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","ኣሳ ጊዶፌ ኢሲ ኢሲ ፋሪሳዌቲ ዬሱሳኮ፥ «ኣስታማሪያው፥ ኔ ታማሬታ ሃይዚቴ ጋዳ ሃንቄታ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","ኢ ኤንታኮ፥ «ኤንቲ ሲዒ ጊኮ ሹቻቲ ዋሳና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","ዬሱሲ ዬሩሳላሜ ማቲሼ ካታማ ቤዒዲ ኢያው ዬኪስ። ");
INSERT INTO gofENT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","«ኔው ሳሮ ጊዳናይሳ ሃቺ ኔ ኤሪዳባ ጊዲያኮሺን፥ ሃዒ ኔ ኣይፊያፔ ጌሚስ። ");
INSERT INTO gofENT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","ኔ ሞርኬቲ ኔ ዩሹዋ ዲሪዲ ዱማ ዱማ ኦጊያራ ኔና ቴቂዲ ኡንዔꬂያ ዎዴይ ያና። ");
INSERT INTO gofENT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","ኔናኔ ኔ ዲርሳ ጋርሳን ዴዒያ ኔ ናይታ ꬋይሳና። ኢሲ ኢሲ ሹቹ ዴንꬂዲ ላላና፥ ኣይስ ጊኮ ፆሳይ ኔና ኣሻናው ያ ዎዲያ ኤራባካ» ያጊዲ ኢው ዬኪስ። ");
INSERT INTO gofENT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","ሄሳፌ ጉዬ፥ ዬሱሲ ፆሳ ኬꬂ ጌሊዲ ዛልዔይሳታ ያፔ ጎዲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ቃሲ፥ « ‹ታ ኬꬃይ ፆሳ ዎሲያ ኬꬂ ጊዳና› ጊዲ ፃፌቲስ፥ ሺን ሂንቴ ታ ኬꬃ ፓንጋታ ጎንጎሎ ኦꬂዴታ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","ጋላስ ጋላስ ፆሳ ኬꬃን ታማርሴስ። ካሂኔታ ሃላቃቲ፥ ሂጌ ኣስታማሬቲኔ ዴሪያ ጪማቲ ኢያ ዎꬋናው ኦጌ ኮዮሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","ጊዶሺን፥ ኣሳ ኡባይ ኢያ ቲሚርቲያ ባንታ ዎዛና ዬጊዲ ሲዒያ ጊሾ ኤንታው ኦꬃናባይ ꬋይስ። ");
INSERT INTO gofENT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","ኢሲ ጋላስ ዬሱሲ ፆሳ ኬꬃን ኣሳ ታማርሲሺኒኔ ዎንጌላ ማርካቲሺን፥ ካሂኔ ሃላቃቲ፥ ሂጌ ኣስታማሬቲኔ ዴሪያ ጪማቲ ኢሲፌ ኢያኮ ዪዲ፥ ");
INSERT INTO gofENT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","«ኔኒ ሃይሳታ ኣይቢ ማታን ኦꬂያኮ ኑስ ኦዳ። ሃ ማታ ኔው ኢሚዳይ ኦኔ?» ያጊዲ ኦይቺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","ኢ ኤንታኮ፥ «ታካ ሂንቴና ኢሲባ ኦይቻና፥ ኣኔ ታው ዛሪቴ። ");
INSERT INTO gofENT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ፃማቂያ ዮሃኒሳ ፂንቃቴይ ፆሳፌዬ ኣሳፔ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","ኤንቲ ዎሊ ጊዶን ያጊዲ ዞሬቲዶሶና፡ «ፆሳፌ ጊኮ ያቲን፥ ኣይስ ኣማኒቤኬቲ?» ያጋና። ");
INSERT INTO gofENT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","«ኣሳፔ ጊኮ፥ ኣሳ ኡባይ ዮሃኒሲ ናቤ ጊዴይሳ ኣማኒያ ጊሾ ኑና ሹቻን ጫዳና።» ");
INSERT INTO gofENT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","ያኒያ ጊሾ፥ «ኣዉፔኮ ኑ ኤሮኮ» ያጊዲ ዛሪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","ዬሱሲ ዛሪዲ፥ «ሂዛ፥ ታካ ኣይ ማታን ሃይሳታ ኦꬂያኮ ሂንቴው ኦዲኬ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","ሄሳፌ ጉዬ፥ ዬሱሲ ያጊዲ ሃ ሌሚሱዋ ኣሳስ ኦዲስ፡ «ኢሲ ኣሲ ዎይኔ ቶኪስ። ጎሻንቾታስ ኬራ ኢሚዲ ዳሮ ዎዴ ጋምዒዲ ያናው ሃራ ቢታ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","ዎይኔ ኣይፊያ ማፂያ ዎዴይ ጋኪን ዎይኒያ ኣይፊያፔ ኢያው ዬዳና ሜላ ጎሻንቾታኮ ባ ኣይሊያ ኪቲስ። ሺን ጎሻንቾቲ ሄ ኣይሊያ ኦይኪዲ ዋꬊዲ ሜላ ኩሼ ዬዲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","ካሊዲካ ሃራ ኣይሊያ ኪቲስ። ቃሲ ጎሻንቾቲ ኢያ ዋꬊዲ፥ ካዉሺዲ ሜላ ኩሼ ዬዲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","ሃዒካ ዛሪዲ ሄꬓንꬆ ኣይሊያ ኪቲስ። ጎሻንቾቲ ኢያካ ማዱንፂሲዲ ዎይኒያ ጊዶፌ ጋፃ ኬሲዲ ዬጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","«ዎይኒያ ጎዳይ፥ ‹ያቲን ታ ኣይ ኦꬆ? ኣኔ ቃሲ ታ ዶሲያ ታ ናዓ ዬዳና፤ ኦኒ ኤሪ ኤንቲ ኢያ ቦንቾና ኣጎኮና› ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","«ሺን ጎሻንቾቲ ኡራ ናዓ ቤዒዳ ዎዴ ‹ሃይሲ ኢያ ላቴይሳ፥ ሃ ዪቴ ኢያ ዎꬋና፥ ያቲኮ ላታይ ኑስ ጊዳና› ያጊዲ ዞሬቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","ዎይኒያ ጊዶፌ ጋፃ ኬሲዲ ዎꬊዶሶና። «ያቲን፥ ዎይኒያ ጎዳይ ሄ ኣሳታ ዋታኔ? ");
INSERT INTO gofENT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","ዪዲ ሄ ጎሻንቾታ ꬋይሳና፥ ዎይኒያ ቤሳ ሃራ ኣሳታስ ኢማና። ኣሳይ ሄሳ ሲዒዳ ዎዴ ‹ሺንቻሌ ሄሳ ሜላባ ኤሆፖ› ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","ዬሱሲ ኤንታ ጫዲ ፄሊዲ፥ «ያቲን ‹ጊምቤ ኬፂያ ኣሳቲ ቦሪዳ ሹቻይ፥ ኬꬃስ ማላኔ ሚኖቴꬂ ኢሚያ ኡባፌ ኣꬊያ ሹቺ ጊዲስ› ጌቴቲዲ ፃፌቲዳይሳ ቢርሼꬃይ ኣይቤ? ");
INSERT INTO gofENT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","ሄ ሹቻ ቦላ ኩንዲያ ኡባይ ቆፄታና፥ ሹቻይ ኢያ ቦላ ዎꬊያ ኡባይ ሊቃና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","ሂጌ ኣስታማሬቲኔ ካሂኔ ሃላቃቲ ሃ ሌሚሶይ ኦዴቲዳይ ኤንታ ቦላ ጊዴይሳ ኤሪዲ ሄ ዎዴ ኢያ ኦይካናው ኮዪዶሶና፥ ሺን ኣሳስ ባቢዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","ሄሳ ጊሾ፥ ዬሱሳ ዴሪያ ሃሪያ ሮሜ ካዉዋ ማታስ ኣꬂ ኢማናው ኮዪዲ ኢያ ዶናፔ ባላ ቃላ ናጎሶና። ሄሳ ፖሊሳናው ፂሎ ዳኒዲ ጪሚያ ኣሳታ ኢያኮ ኪቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","ኪቴቲዲ ቢዳ ኣሳቲ፥ «ኣስታማሪያው፥ ኔኒ ኦዴይሲኔ ታማርሴይሲ ሊኬ ጊዴይሳ፥ ቃሲ ፆሳ ኦጊያ ቱማቴꬃን ታማርሴይሳኔ ኦናካ ሻኮናይሳ ኑ ኤሮስ። ");
INSERT INTO gofENT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","ሃኖሺን፥ ሮሜ ካዉዋስ ጊራ ጊራናው ቤሲ ቤሴኔ?» ያጊዲ ኢያ ኦይቺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","ሺን ኢ ኤንታ ዎዛና ኢታቴꬃ ኤሪዳ ጊሾ ");
INSERT INTO gofENT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«ኣኔ ታና ኢሲ ሳንቲሜ ቤሲቴ፥ ኢያ ቦላ ዴዒያ ሚሲሌይኔ ሱንꬃይ ኦዴባዬ?» ያጊስ። ኤንቲ ዛሪዲ፥ «ሮሜ ካዉዋ ቄሳሬይሳ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","ኢ ዛሪዲ፥ «ያቲኮ፥ ቄሳሬይሳ ቄሳሬስ፥ ፆሳይሳ ፆሳስ ኢሚቴ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","ሄሳ ጊሾ፥ ኢ ዛሪዳ ዛሩዋን ኣሳ ሲንꬃን ባላ ዴማናው ዳንዳዒቦኮና። ኢያ ዛሩዋን ማላሌቲዲ ሲዒ ጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","ሃይቆፔ ዴንዶይ ባዋ ያጊያ ሳዱቃዌታፔ ኢሶቲ ኢሶቲ ዬሱሳኮ ዪዲ፥ ");
INSERT INTO gofENT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","«ኣስታማሪያው፥ ኢሲ ኣሲ ማቾ ኤኪዲ ናዓ ዬሎና ሃይቂኮ፥ ኢያ ኢሻይ ሄ ማጫሲው ኤኪዲ ናይታ ዬሊዲ ባ ኢሻስ ዜሬꬂ ኣሻና ሜላ ሙሴይ ፃፊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","ሄኮ ላፑን ኢሻቲ ዴዖሶና። ኮይሮይሲ ማቾ ኤኪዲ ናዓ ዬሎና ሃይቂስ። ");
INSERT INTO gofENT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","ናምዓንꬆይ ኢዮ ኤኪዲ ናዓ ዬሎና ሃይቂስ። ");
INSERT INTO gofENT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ሄꬓንꬆይካ ሄሳꬆ ሃኒስ። ላፑናቲ ኡባይ ሄሳዳ ሃኒዲ ኢዮ ኤኪዶሶና፥ ሺን ናዓ ዬሎና ሃይቂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","ዉርሴꬃን ማጫሲያ ሃይቃሱ። ");
INSERT INTO gofENT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","ሂዛ፥ ላፑን ኣዴይ ኢዮ ኤኪዳ ጊሾ ሃይቆፔ ዴንዲያ ዎዴ ኢያ ኦዴ ማቾ ጊዳኔ?» ያጊዲ ኦይቺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","ዬሱሲ ዛሪዲ፥ «ኣሳይ ሃ ዎዲያን ኤኮሶናኔ ጌሎሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","ሺን ሃይቆፔ ዴንዲዲ ያና ኣላሚያን ዳናው ቤሴይሳቲ ኤኮኮናኔ ጌሎኮና። ");
INSERT INTO gofENT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","ኤንቲ ኪታንቾ ሜላ ጊዲያ ጊሾ ሲንꬃፌ ሃይቆኮና። ሃይቆፔ ዴንዲዳ ጊሾ ኤንቲ ፆሳ ናይታ። ");
INSERT INTO gofENT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","ሙሴይ ጎዳ፥ ‹ኣብራሃሜ ጎዳ፥ ዪሳቃ ጎዳ፥ ያይቆባ ጎዳ› ጊዲ ቱሺያ ጊዶን ፁጌቲያ ታማ ታሪኪያ ፃፊዳይሳን ሃይቂዳ ኣሳይ ዴንዴይሳ ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","ኡባይ ኢያው ዴዖን ዴዔይሳታ ጊዲያ ጊሾ ኢ ዴዖን ዴዔይሳታ ጎዳፔ ኣቲን ሃይቂዳይሳታ ጎዳ ጊዴና» ያጊዲ ዛሪስ። ");
INSERT INTO gofENT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","ሂጌ ኣስታማሬታፔ ኢሶቲ ኢሶቲ፥ «ኣስታማሪያው፥ ሎዖባ ኦዳዳሳ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","ሄሳፌ ጉዬ፥ ሃራ ኦይሾ ኦይቻናው ያዪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","ኢያፔ ካሊዲ ዬሱሲ ኤንታኮ፥ «ኣሳይ ኪሪስቶሳ ዋቲዲ ዳዊቴ ናዓ ያጎና? ");
INSERT INTO gofENT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","ኣይስ ጊኮ፥ ዳዊቴይ ባ ሁዔን ባ ማፃፋን፥ ‹ፆሳይ ታ ጎዳኮ «ታ ኔ ሞርኬታ ኔ ቶሆይ ዬꬊያሶ ኦꬃና ጋካናው ታፔ ኡሻቻ ባጋን ኡታ» ጊስ› ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","«ሂዛ፥ ዳዊቴይ ኪሪስቶሳ፥ ‹ጎዳ ጊዲ ፄጊሼ ኢያው ናዓ ዋኒዲ ጊዲ?› » ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","ዴሬይ ኡባይ ሲዒሺን ባ ታማሬታኮ፥ ");
INSERT INTO gofENT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«ኣዱሳ ማዖ ማዒዲ ዩሼ ዶሴይሳታፔ፥ ጊያን ቦንቾ ሳሮꬆ፥ ኣይሁዴ ዎሳ ኬꬃን ቦንቾ ኦይዴ፥ ሞኬቲያ ሶንካ ቦንቾ ቤሲ ኮያ ሂጌ ኣስታማሬታፔ ናጌቲቴ። ");
INSERT INTO gofENT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","ኤንቲ ኣምዔታ ኬꬃ ካሎዮሶና፥ ፂሎ ኣሲ ዳኒዲ ዎሳ ኣዱሶሶና። ኤንቲ ኢታ ፒርዳ ኤካና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","ዱሬ ኣሳይ ፆሳ ኬꬃን ሙፃታ ሳፂኒያን ዬጊሺን ዬሱሲ ꬎቁ ጊዲ ኣሳ ቤዒስ። ");
INSERT INTO gofENT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","ቃሲ ኢሲ ማንቆ ኣምዒያ ናምዑ ሲኪና ዬጊሺን ቤዒዲ፥ ");
INSERT INTO gofENT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","«ታ ሂንቴው ቱማ ኦዳይስ፤ ሃ ማንቆ ኣምዒያ ኡባፌ ኣꬃዳ ኢማሱ። ");
INSERT INTO gofENT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","ኣይስ ጊኮ፥ ሃ ኣሳ ኡባይ ባንታው ዴዒያባፔ ኢሚዶሶና፥ ሺን ኢያ ባ ፓጪያፔ፥ ባው ዴዒያ ኣቁዋ ኡባ ኢማሱ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","ዬሱሳ ታማሬታፔ ኢሶቲ ኢሶቲ ፆሳ ኬꬃይ ዳሮ ሎዒያ ሹቻኒኔ ኣሳይ ፆሳስ ኢሚዳ ኢሞታን ሎዒዳይሳ ኦዴቶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","ሺን ዬሱሲ፥ «ሃ ሂንቴ ቤዒያባይ ኡባይ ላሌቶና፥ ሹቺ ሹቻ ቦላ ጊምቤቲዳ ሜላ ኣቶና ዎዴይ ያና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","ኤንቲካ፥ «ኣስታማሪያው፥ ሃ ኡባይ ሃናናይ ኣዉዴ? ቃሲ ሃይሲ ሃናናይሳስ ማላታይ ኣይቤ?» ያጊዲ ኦይቺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","ዬሱሲ ያጊዲ ኤንታው ዛሮ ኢሚስ፡ «ባሌቶና ሜላ ናጌቲቴ። ዳሮቲ፥ ‹ታኒ ኪሪስቶሳ፥ ዎዴይ ማታቲስ› ያጊሼ ታ ሱንꬃን ያና፥ ሺን ሂንቴ ኤንታ ካሎፊቴ። ");
INSERT INTO gofENT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","ሂንቴ ኦላባኔ ኣሳ ጌላቴꬃ ሲዒያ ዎዴ ዳጋሞፊቴ። ሄሲ ሲንꬃቲዲ ሃናናይሲ ኣቶናባ ጊዲያ ጊሾ ዎዲያ ዉርሴꬃይ ኤሌሲዲ ዬና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","ካሊዲካ፥ «ዴሬይ ዴሪያ ቦላ፥ ካዎቴꬃይ ካዎቴꬃ ቦላ ዴንዳና። ");
INSERT INTO gofENT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","ጊታ ቢታ ቃፆይ ሃናና፥ ኮሻይኔ ጋዶይ ዱማ ዱማ ቤሳን ዳራና፥ ያሺያባይኔ ጊታ ማላታቲ ሳሎፔ ቆንጫና። ");
INSERT INTO gofENT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","ሺን ሃ ኡባይ ሃናናፔ ሲንꬄ ታ ሱንꬃ ጊሾ ጊዲ ኣሳይ ሂንቴና ጎዳናኔ ኦይካና። ኣይሁዴ ዎሳ ኬꬃኒኔ ቃሾ ኬꬃን ሂንቴና ዬጋና። ካዎታ ሲንꬄኔ ዴሪያ ሃሬይሳታ ሲንꬄ ሂንቴና ኤፋና። ");
INSERT INTO gofENT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","ሄሲካ ታባ ሂንቴ ኤንታው ማርካታናው ሎዖ ኦጌ ጊዳና። ");
INSERT INTO gofENT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","ሄሳ ጊሾ፥ ሂንቴ ኦይሼቲያ ዎዴ ዎይጊዲ ዛሮ ኢማኔ ጊዲ ሂንቴ ዎዛናን ኡንዔቶና ሜላ ኣኬኪቴ። ");
INSERT INTO gofENT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","ኣይስ ጊኮ፥ ሂንቴ ሞርኬቲ ሂንቴራ ኤቄታናዉኔ ፓላማናው ዳንዳዖና ዶናኔ ጪንጫቴꬂ ታ ሂንቴው ኢማና። ");
INSERT INTO gofENT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","ሃሪ ኣቶሺን፥ ሂንቴና ዬሊዳይሳቲ፥ ሂንቴ ኢሻቲ፥ ሂንቴ ዳቦቲኔ ላጌቲ ሂንቴና ኣꬂ ኢማና። ሂንቴ ጊዶፌ ኢሶታ ኢሶታ ዎꬋና። ");
INSERT INTO gofENT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","ታ ሱንꬃ ጊሾ ኣሳ ኡባ ሲንꬃን ሂንቴ ኢፄቲዳይሳታ ጊዳና። ");
INSERT INTO gofENT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","ሺን ሃሪ ኣቶሺን፥ ሂንቴ ቢናናፔ ኢሶይካ ꬋዬና። ");
INSERT INTO gofENT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","ፖሎ ዳንዳዓን ሂንቴ፥ ሂንቴ ሼምፑዋ ኣሻና።» ");
INSERT INTO gofENT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","«ዬሩሳላሜ ካታማይ ዎታዳሬን ዲሬቲዲ ኡቲዳሺን ሂንቴ ቤዒኮ ኢያው ꬋዮይ ማታቲዳይሳ ኤሪቴ። ");
INSERT INTO gofENT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","ሄ ዎዴ ዪሁዳን ዴዒያ ኡባይ ዴሪያኮ ባቃቶ፥ ካታማን ዴዔይሳቲ ያፔ ኬዮ፥ ጋፃሪያን ዴዔይሳቲ ካታማ ጌሎፖ። ");
INSERT INTO gofENT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","ኣይስ ጊኮ፥ ሃ ፃፌቲዳባይ ፖሌታና ሜላ ሄሲ ፆሳይ ኩሼ ዛሪያ ዎዴ። ");
INSERT INTO gofENT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","ሳዓ ቦላ ጊታ ሜቶይ ያና፥ ሄሳንካ ኣሳ ቦላ ፆሳ ሃንቆይ ያና። ሄሳ ጊሾ፥ ቃንꬃቲዳይሳታኔ ꬋንꬄይሳታ ኣዬ። ");
INSERT INTO gofENT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","ኤንቲ ማሻን ሃይቃና፥ ኣሳ ኡባይ ኣላጋ ቢታ ዲዔታና። ኣይሁዴ ጊዶና ኣሳ ዎዴይ ፖሌታና ጋካናው ዬሩሳላሜይ ኤንታናን ዬꬌቲዳይሳ ጊዳና። ");
INSERT INTO gofENT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","«ኣዋን፥ ኣጌናኒኔ፥ ፆሊንቶታ ቦላ ማላታቲ ሃኒዲ ቤንታና። ኣባፌኔ ዙሊያ ዴሹዋፔ ዴንዶይሳን ቢታን ዴዒያ ኣሳይ ኡንዔታናኔ ያርካና። ");
INSERT INTO gofENT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","ሳሉዋ ዎልቃቲ ቡቄታና ጊሾ ኣሳይ ያሻኒኔ ቢታ ቦላ ኣይቢ ሃናንዴሻ ጊዲ ናጎን ባንታና ባሌታና። ");
INSERT INTO gofENT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","ሄ ዎዴ ኣሳ ናዓይ ዎልቃኒኔ ጊታ ቦንቹዋን ሻራራ ዪሺን ኤንቲ ቤዓና። ");
INSERT INTO gofENT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","ሂንቴ ኣቶቴꬃይ ማታቲዳ ጊሾ ሃ ሃኖቲ ፖሌቴꬂ ኦይኪያ ዎዴ ጊጌቲ ኤቂቴ፥ ሂንቴ ሁዒያ ꬎቁ ኦꬂዲ ፄሊቴ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","ካሊዲካ፥ ሃይሳዳ ጊዲ ሌሚሶ ኦዲስ፡ «ባላሴ ሚꬃኔ ሃራ ሚꬃታ ኡባ ቤዒቴ። ");
INSERT INTO gofENT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","ኤንቲ ኣጪያ ዎዴ ቶርቼይ ማታቲዳይሳ ሂንቴ ኤሬታ። ");
INSERT INTO gofENT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","ሄሳዳ ሃ ሃኖቲ ፖሌቲሺን ሂንቴ ቤዒኮ ፆሳ ካዎቴꬃይ ማታቲዳይሳ ኤሪቴ። ");
INSERT INTO gofENT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","«ታ ሂንቴው ቱማ ኦዳይስ፤ ሃ ኡባይ ፖሌታና ጋካናው ሃ ዬሌቴꬃይ ኣꬌና። ");
INSERT INTO gofENT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","ሳሎይኔ ሳዓይ ኣꬋና፥ ሺን ታ ቃላይ ኣꬌና። ");
INSERT INTO gofENT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","«ሂዛ፥ ꬋሲ ባይና ዴዖን፥ ኡሻ ዳሮኒኔ ዱሳባስ ኡንዔቴꬃን ሂንቴ ዎዛናይ ኦይኬቶና ሜላኔ ሄ ቃማይ ኣኬኮና ፂሄዳ ሂንቴ ቦላ ጋኮና ሜላ ናጌቲቴ። ");
INSERT INTO gofENT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","ሄ ቃማይ ቢታ ኩሜꬃን ዴዒያ ኡባ ቦላ ጋካና። ");
INSERT INTO gofENT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","ሄሳ ጊሾ፥ ያ ኢታፔ ኣታናዉኔ ኣሳ ናዓ ሲንꬃን ኤቃናው ዳንዳዓና ሜላ ኡባ ዎዴ ሚኒዲ ዎሲቴ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","ጋላስ ጋላስ ዬሱሲ ፆሳ ኬꬃን ታማርሲሼ፥ ቃማ ቃማ ሻማሆ ዴሪያ ቦላ ኬዪዲ ኣቄስ። ");
INSERT INTO gofENT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","ኣሳይ ኡባይ ኢያ ሲዓናው ዎንታ ጉራ ኢያኮ ፆሳ ኬꬂ ዮሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","ሄ ዎዴ ‹ፋሲካ› ያጊያ ኡይꬃ ባሌይ ማቲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","ካሂኔ ሃላቃቲኔ ሂጌ ኣስታማሬቲ ኣሳስ ያዪዳ ጊሾ ዋቲዲ ዬሱሳ ባንታ ጊዶፌ ꬋይሳኔኮ ኦጌ ኮዮሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","ፃላሄይ ታማኔ ናምዓታፔ ኢሱዋ ጊዲዳ ኣስቆሮታ ዪሁዳ ጌቴቴይሳ ጊዶ ጌሊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","ዪሁዲ ካሂኔ ሃላቃታኮኔ ፆሳ ኬꬃ ናጌይሳታ ሃላቃታኮ ቢዲ ዬሱሳ ዋቲ ኣꬂ ኢማኔኮ ኤንታራ ማቄቲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","ኤንቲካ ሄሳን ኡፋይቲዲ ሚሼ ኢማናው ኢያራ ዞሬቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","ኢካ ዞሬቴꬃን ጊጊስ። ኣꬂ ኤንታው ኢማናው ኣሲ ባይና ኢንጄ ዎዴ ናጊሼ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","ሄሳፌ ጉዬ፥ ፋሲካ ዶርሳይ ሹኬቲያ ኡይꬃ ባሌይ ጋኪስ። ");
INSERT INTO gofENT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","ዬሱሲ፥ «ፋሲካ ካሁዋ ማና ሜላ ቢዲ ኑስ ጊጊሲቴ» ያጊዲ ጴፂሮሳኔ ዮሃኒሳ ኪቲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","ኤንቲ፥ «ኑ ኣዉን ጊጊሳና ሜላ ኔ ኮያይ» ያጊዲ ኦይቺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","ኢ ኤንታኮ፥ «ሄኮ ሂንቴ ካታማ ጌሊሺን ሃꬃ ኦቶ ቶኪዳ ኣዴይ ሂንቴራ ጋሄታና። ኢ ቢዲ ጌሊያ ኬꬃ ኢያ ካሊዲ ጌሊቴ። ");
INSERT INTO gofENT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ኬꬃዋኮ ኣስታማሬይ፥ ‹ታ ታ ታማሬታራ ዎላ ፋሲካ ካሁዋ ማናው ኢማꬃ ኬꬂ ኣዉኔ? ያጊስ› ጊቴ። ");
INSERT INTO gofENT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","ኢ ፖቂያ ቦላ ሂፄቲዲ ጊጊዲ ዴዒያ ዳልጋ ኪፊሌ ሂንቴና ቤሳና፥ ያን ጊጊሲቴ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","ኤንቲ ቢዲ ዬሱሲ ጊዳይሳዳ ሃኒን ዴሚዶሶና። ፋሲካ ባሌ ካሁዋ ያን ጊጊሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","ሳቴይካ ጋኪዳ ዎዴ ዬሱሲ ሃዋሬታራ ዎላ ካሁዋ ቦላ ኡቲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","ኢ ኤንታኮ፥ «ታ ዋዬ ኤካናፔ ሲንꬄ ሃ ካሁዋ ሂንቴራ ማናው ዳሮ ኣሞታስ። ");
INSERT INTO gofENT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","ሂዛ፥ ሲዒቴ! ፆሳ ካዎቴꬃን ሃይሳስ ቢርሼꬃይ ፖሌታና ጋካናው ሃ ካሁዋ ዛራዳ ሚኬ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","ኡሻ ኤኪዲ ጋላቲ ሲሚዲ፥ «ሄዒቴ ሃይሳ ሂንቴ ጊዶን ሻኬቲቴ። ");
INSERT INTO gofENT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","ሲዒቴ! ፆሳ ካዎቴꬃይ ያና ጋካናው ሃቺፌ ዶማዳ ሃ ዎይኔ ኡሻፌ ዛራዳ ኡዪኬ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","ኡይꬃ ኤኪዲ፥ ጋላቲ ሲሚዲ፥ «ሃይሲ ሂንቴው ኢሜቲያ ታ ኣሹዋ። ሃይሳ ኦꬂሼ ታና ቆፒቴ» ያጊዲ ሜንꬂዲ ኤንታው ኢሚስ። ");
INSERT INTO gofENT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","ሄሳዳካ፥ ካሁዋፔ ጉዬ ኡሻ ኤኪዲ፥ «ሃ ኡሻይ ሂንቴው ጉኪዳ ታ ሱꬃን ጊዲያ ኦራꬃ ጫቁዋ። ");
INSERT INTO gofENT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","ጊዶሺን፥ ታና ኣꬂ ኢማና ኡራ ኩሼይ ታራ ኢሲፌ ጋይታና። ");
INSERT INTO gofENT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","ኣሳ ናዓይ ኢያው ጌቴቶይሳ ሜላ ሃይቃናው ዴዔስ፥ ሺን ኢያ ኣꬂ ኢሚያ ኡራ ኣዬ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","ኤንቲ ባንታ ጊዶን፥ «ሃይሳ ኦኒ ኦꬃኔ» ጊዲ ዎሊ ኦይቺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","ቃሲ ኤንታ ጊዶን ጊታ ጊዳናይ ኦኔ ጊያ ፓላሚ ሜꬌቲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","ዬሱሲ ኤንታኮ፥ «ዴሪያ ካዎቲ ባንታ ኣሳ ዎልቃን ሃሮሶና፤ ባንታ ዴሪያ ቦላ ጎዳቴይሳታስካ ባንታና፥ ‹ሎዖ ኦꬄይሳታ› ያጊዲ ፄጎሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","ሺን ሂንቴ ጊዶን ሄሳ ሜላ ጊዶፖ። ሂንቴ ጊዶን ባይራቴይ ካሎዳ ሃኖ፤ ካሌꬄይሲ ካሌይሳዳ ሃኖ። ");
INSERT INTO gofENT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","ሃኖሺን፥ ሞኬይሳፌኔ ሞኬቴይሳፌ ኣዉሲ ኣꬊ? ሞኬቴይሳ ጊዴኔዬ? ሺን ታኒ ሂንቴ ጊዶን ሞኬይሳ ሜላ። ");
INSERT INTO gofENT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","«ሂንቴካ ታ ሜቱዋን ታፔ ሻኬቶና ታራ ሚኒዲ ኤቂዳይሳታ። ");
INSERT INTO gofENT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","30","ሂንቴ ታ ጋይታፔ ማና ሜላ፥ ኡያና ሜላኔ ኣራታታ ቦላ ኡቲዲ ታማኔ ናምዑ ኢስራዔሌ ሼሻታ ቦላ ፒርዳና ሜላ ታ ኣዋይ ታና ሹሚዳይሳዳ ታካ ሂንቴና ታ ካዎቴꬃን ሹማና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","ካሊዲካ ዬሱሲ፥ «ሲሞና፥ ሲሞና፥ ፃላሄይ ሂንቴና ጊስቴዳ ሃርቃናው ዎሲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","ሺን ታኒ ኔ ኣማኖይ ꬋዮና ሜላ ኔው ጋናታስ። ኔካ ሲሚዳ ዎዴ ኔ ኢሻታ ሚንꬃ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","ሲሞኒ፥ «ጎዳው፥ ታኒ ኔራ ቃሼታናዉኔ ሃይቃናው ጊጌታስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","ዬሱሲ ጴፂሮሳኮ፥ «ታ ኔው ኦዳይስ፤ ሃቺ ኩቶይ ዋሳናፔ ሲንꬄ ኔ ታና ሄꬑ ቶሆ ካዳና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","ካሊዲካ፥ ዬሱሲ ኤንታኮ፥ «ታኒ ሂንቴና ኮሮጆይ፥ ካርፂቴይኔ ጫሚ ባይና ኪቲዳ ዎዴ ሂንቴው ፓጪዳባይ ዴዒ?» ያጊዲ ኦይቺስ። ኤንቲ ዛሪዲ፥ «ኣይኮይካ ፓጪቤና» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","ኢ ኤንታኮ፥ «ሃዒ ኮሮጆይኔ ካርፂቴይ ዴዔይ ኦይኮ፤ ማሺ ባይናይ ባ ኣፊላ ባይዚዲ ማሻ ሻሞ። ");
INSERT INTO gofENT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","ሃ ሲዒቴ! ‹ጌላታራ ታይቤቲስ› ጌቴቲዲ ፃፌቲዳይሲ ታናን ፖሌታናው ቤሴስ። ኤ፥ ታ ጊሾ ፃፌቲዳባይ ፖሌቴይሲ ቱማቲስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","ኢያ ታማሬቲ፥ «ጎዳው ሃይሳን ናምዑ ማሺ ዴዔስ» ያጊዶሶና። ኢ፥ «ጊዳና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","ዬሱሲ ካሴ ሜዜቲዳይሳዳ ዴንዲዲ ሻማሆ ዴሪያ ቦላ ኬዪስ። ኢያ ታማሬቲ ኢያ ካሊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","ሄ ቤሳ ጋኪዳ ዎዴ «ፓጬን ጌሎና ሜላ ዎሲቴ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","ኤንታፌ ሹቺ ሆሊን ጋኪያ ሶ ሜላ ሃኪዲ ጉልባቲዲ ዎሲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","«ታ ኣዋው፥ ኔ ሼኔ ጊዲኮ ሃ ሜቱዋ ታፔ ኣꬃ። ሺን ታ ሼኔ ጊዶፖ ኔ ሼኔይ ሃኖ» ያጊዲ ዎሲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","ኪታንቾይ ሳሎፔ ቆንጪዲ ሚንꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","ዳሮ ኡንዔቲዲ ሚንꬂዲ ዎሴስ። ኢያ ጫዋይካ ሱꬂ ፆኪያዳ ሳዓን ፆኬስ። ");
INSERT INTO gofENT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","ዬሱሲ ዎሳ ዉርሲዲ ባ ታማሬታኮ ዪስ። ኤንቲ፥ ኣዛኒያፔ ዴንዶይሳን ዳቡሪዲ ꬊስኪዳሺን ዴሚዲ፥ ");
INSERT INTO gofENT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","«ኣይስ ꬊስኬቲ? ፓጬን ጌሎና ሜላ ዴንዲዲ ዎሲቴ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","ኢ ቡሮ ኦዳ ቦላ ዴዒሺን ዳሮ ኣሳቲ ዪዶሶና። ታማኔ ናምዓታፔ ኢሶይ ዪሁዳ ጌቴቴይሲ ኤንታና ካሌꬄስ። ኢ ዬሱሳ ዬራናው ማቲ ሺቂስ። ");
INSERT INTO gofENT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","ሺን ዬሱሲ፥ «ዪሁዳ፥ ኣሳ ናዓ ዬራዳ ኣꬃ ኢማኔ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","ዬሱሳ ታማሬቲ ሄ ሃኑዋ ቤዒዲ፥ «ጎዳው ማሻን ሾጪኖ?» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","ኤንታ ጊዶፌ ኢሶይ ካሂኔ ሃላቃ ኦሳንቹዋ ሾጪዲ ኡሻቻ ሃይꬃ ቃንፂዲ ዬጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","ሺን ዬሱሲ፥ «ኣጋ! ዲጎፊቴ» ያጊስ። ኡራ ሃይꬃ ቦቺዲ ፓꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","ሄሳፌ ጉዬ፥ ዬሱሲ ባና ኦይካናው ዪዳ ካሂኔ ሃላቃታኮ፥ ፆሳ ኬꬃ ናጌይሳታ ሹማታኮኔ ጪማታኮ፥ «ፓኖ ኦይኪያ ኣሳዳ ማሼኔ ፃምዓ ኦይኪዲ ዪዴቲ? ");
INSERT INTO gofENT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","ኡባ ጋላስ ፆሳ ኬꬃን ታ ሂንቴራ ዴዒያ ዎዴ ታ ቦላ ኩሼ ዎꬂቤኬታ። ሺን ሃይሲ ꬉማ ካዎቴꬃይ ሃሪዳ ዎዴኔ ሂንቴ ዎዴ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","ሄሳፌ ጉዬ፥ ዬሱሳ ኦይኪዲ ካሂኔ ሃላቃ ዛባ ኤፊዶሶና። ጴፂሮሲ ሃሆን ዬሱሳ ካሌስ። ");
INSERT INTO gofENT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","ኣሳቲ ካሂኔ ሃላቃ ዛባን ታማ ኤꬂዲ ዎላ ኡቲዳሺን ጴፂሮሲ ኤንታራ ኢሲፌ ኡቲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","ኢሲ ኣይሊያ ጴፂሮሲ ታማ ማታን ኡቲዳይሳ ጫዳ ፄላዳ፥ «ሃ ኡራይ ኢያራ ዴዔስ» ያጋሱ። ");
INSERT INTO gofENT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","ሺን ጴፂሮሲ፥ «ሃ ማጫሴቴ ታ ሄ ኡራ ኤሪኬ» ያጊዲ ካዲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","ጉꬃ ዎዴፔ ጉዬ ኢሲ ሃራ ኣዴይ ኢያ ቤዒዲ፥ «ኔካ ኤንታፌ ኢሱዋ» ያጊስ። ሺን ጴፂሮሲ፥ «ሃ ኣዲያው ታና ጊዲኬ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","ኢሲ ሳቴ ሜላ ጋምዒዳፔ ጉዬ ኢሲ ሃራ ኣዴይ ቲሊሲዲ፥ «ሃ ኡራይ ጋሊላፔ ጊዲያ ጊሾ ሲꬌይ ባይና ኢያራ ዴዔስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","ሺን ጴፂሮሲ፥ «ሃ ኣዲያው፥ ኔ ጌይሳ ታ ኤሪኬ» ያጊስ። ኢ ሄ ኦዳ ኦንጎና ዴዒሺን ኩቶይ ዋሲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","ጎዳይ ጉዬ ሲሚዲ ጴፂሮሳ ፄሊስ። ጴፂሮሲ፥ «ሃቺ ኩቶይ ዋሳናፔ ሲንꬄ ኔ ታና ሄꬑ ቶሆ ካዳና» ያጊዲ፥ ጎዳይ ኦዲዳ ቃላ ኣኬኪስ። ");
INSERT INTO gofENT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","ጴፂሮሲ ካሬ ኬዪዲ ዳሮ ኮኮሪዲ ዬኪስ። ");
INSERT INTO gofENT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","ዬሱሳ ናጊያ ኣሳቲ ኢያ ሌቂሶኔ ዴሼꬂ ኦይኪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","ኢያ ኣይፊያ ጎዚዲ «ኣኔ ቲንቢቴ ኦዳ፤ ኔና ዴቺዳይ ኦኔ?» ያጊዲ ኦይቾሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","ሃራ ዳሮ ጫሼ ጫዪዲ ካዉሾሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","ሳዒ ዎንቲያ ዎዴ ኣይሁዴ ቢታ ጪማቲ፥ ካሂኔ ሃላቃቲኔ ሂጌ ኣስታማሬቲ ሺቂዲ፥ ዬሱሳ ባንታ ሲንꬄ ሺሺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","ኤንቲ፥ «ኔኒ ኪሪስቶሴ? ኣኔ ኑስ ኦዳ?» ያጊዲ ኦይቺዶሶና። ዬሱሲ፥ «ታ ኦዲያኮ ኣማኔኬታ። ");
INSERT INTO gofENT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ታ ኦይቺያኮ ዛሬኬታ። ");
INSERT INTO gofENT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","ሺን ኣሳ ናዓይ ሃይሳፌ ጌዴ ባጋን ዎልቃማ ፆሳ ኡሻቻ ባጋን ኡታና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","ሄ ዎዴ ኡባይ፥ «ያቲን፥ ኔኒ ፆሳ ናዔ?» ያጊዶሶና። ኢ፥ «ታ ፆሳ ናዓ ጊዴይሳ ሂንቴ ጊዴታ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","ኤንቲ፥ «ሂዛ፥ ሃራ ማርካ ኣይ ኮሺ? ኢ ባ ኢንፃርሳን ኦዲሺን ኑ ሲዒዳ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","ሄ ቤሳን ሺቂዳ ሻንጎቲ ኡባይ ዴንዲዲ ዬሱሳ ጲላፆሳኮ ኤፊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","«ሃ ኡራይ ኑ ኣሳ ባሌꬂሺን፥ ካዉዋስ ጊራ ጊሮና ሜላ ዲጊሺኒኔ ቃሲ፥ ‹ታኒ ኪሪስቶሳ ሂንቴ ካዉዋ› ያጊሺን ዴሚዳ» ያጊዲ ሞቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","ጲላፆሲ ዬሱሳ፥ «ኔኒ ኣይሁዴታ ካዎዬ?» ያጊዲ ኦይቺስ። ዬሱሲ፥ «ኤ፥ ኔ ጊዳይሳ ሜላ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","ጲላፆሲ ካሂኔ ሃላቃታኮኔ ኣሳኮ፥ «ሃ ኡራ ቦላ ታኒ ኢሲ ባላካ ዴማቢኬ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","ሺን ኤንቲ፥ «ሃ ኡራይ ጋሊላፔ ዶሚዲ ሃይሳ ጋካናው ዪሁዳ ኩሜꬃ ኢታባስ ዴንꬄꬄስ» ያጊዲ ሚንꬂ ኦዲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","ጲላፆሲ ሄሳ ሲዒዳ ዎዴ ዬሱሲ ጋሊላ ኣሴኮ ኤራናው ኮዪዲ ኢያ ኦይቺስ። ");
INSERT INTO gofENT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","ዬሱሲ ሄሮዲሳ ቢታፌ ዪዳ ኣሲ ጊዴይሳ ጲላፆሲ ኤሪዳ ዎዴ ሄሮዲሲ ሄ ዎዴ ዬሩሳላሜን ዴዒያ ጊሾ ኢያኮ ዬዲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","ሄሮዲሲ ዬሱሳ ቤዓናው ዳሮ ዎዴፔ ኮዪሼ ዴዒያ ጊሾ ኢያ ቤዒዳ ዎዴ ዳሮ ኡፋይቲስ። ኣይስ ጊኮ፥ ኢያባ ሲዒዳ ጊሾ ማላሊሲያባ ኦꬂን ቤዓናው ኣሞቲሼ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","ሄሮዲሲ ዬሱሳ ዳሮ ኦይሾታ ኦይቺስ፥ ሺን ኢ ኣይኮካ ዛሪቤና። ");
INSERT INTO gofENT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","ካሂኔታ ሃላቃቲኔ ሂጌ ኣስታማሬቲ ያን ኤቂዲ ሚንꬂዲ ኢያ ሞቶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","ሄሮዲሳራኔ ኢያ ዎታዳሬታራ ዬሱሳ ካꬊዶሶናኔ ሌቂሲዶሶና። ቦንቾ ኣፊላ ማይዚዲ ጲላፆሳኮ ዛሪዲ ዬዲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","ሄሮዲሳራኔ ጲላፆሳራ ካሴ ሞርኬሺን ሄ ጋላስ ዎላ ጊጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","ጲላፆሲ ካሂኔ ሃላቃታ፥ ኣሳ ሃሬይሳታኔ ኣሳ ፄጊዲ፥ ");
INSERT INTO gofENT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","« ‹ሃ ኡራይ ኣሳ ጌላቴꬃስ ዴንꬄꬄስ› ጊዲ ታኮ ኤሂዴታ። ታካ ሂንቴ ሲንꬃን ፒልጋዳ ሂንቴ ሺሺዳ ሞቱዋስ ኣይቢ ባላካ ዴማቢኬ። ");
INSERT INTO gofENT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","ሄሮዲሲ፥ ሄሳꬆ ኣይቢ ባላካ ኢያ ቦላ ዴሚቦና ጊሾ ኑኮ ዬዲስ። ቱማካ ሃ ኡራይ ሃይቆስ ጋꬂያ ኣይቢ ባላካ ኦꬂቤና። ");
INSERT INTO gofENT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","ሄሳ ጊሾ፥ ኢያ ጋራፋዳ ቢላ ዬዳና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","ሄሳ ኢ ጊዳይ ፋሲካ ባሌ ዎዴ ኢሲ ኣሲ ኤንታው ቢላናይሲ ኢያው ኣቶናባ ጊዲያ ጊሾሳ። ");
INSERT INTO gofENT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","ዴሬይ ኡባይ ኢሲ ቦላ፥ «ሃ ኡራ ጌዴ ዲጋ፥ ኑስ ባርባና ቢላ» ያጊዲ ዋሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","ባርባኒ ካታማ ጊዶን ኣሳ ኢታባስ ዴንꬄꬂዲ ኣሴ ዎꬊዲ ቃሼቲዳ ኣሲ። ");
INSERT INTO gofENT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","ጲላፆሲ ዬሱሳ ቢላናው ኮዪዲ ኣሳስ ዛሪ ኦዲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","ጊዶሺን፥ ኣሳይ፥ «ካቃ! ካቃ!» ያጊዲ ዋሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","ጲላፆሲ ሄꬓንꬆ፥ «ሃ ኡራይ ቆሂዳባይ ኣይቤ? ዎꬎስ ጋꬂያ ባላ ታ ዴማቢኬ። ሄሳ ጊሾ፥ ጋራፋዳ ዬዳ ኣጋና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","ኤንቲ ባንታ ቃላ ꬎቁ ኦꬂዲ፥ «ካቄታናው ቤሴስ» ጊዲ ሚንꬂ ዋሲዶሶና። ኤንታ ዋሶይካ ፆኒስ። ");
INSERT INTO gofENT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","ኤንታ ኦይሻ ጊሾ ጊዲ ጲላፆሲ ኢያ ቦላ ፒርዲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","ኣሳ ኢታባስ ዴንꬄꬄይሳኔ ኣሴ ዎꬊዲ ቃሼቲዳይሳ ቢላና ሜላ ዎሲዳ፥ ሄ ኡራ ኤንታው ቢሊስ። ሺን ዬሱሳ ኤንቲ ኮዪዳባ ኦꬃና ሜላ ኤንታው ኣꬂ ኢሚስ። ");
INSERT INTO gofENT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","ዬሱሳ ኦይኪዲ ኤፊሺን ሲሞና ጊያ ቄሬና ቢታ ኣዴይ ጋፃሬፔ ዪሺን፥ ዴሚዲ ማስቃሊያ ቶሲዲ ዬሱሳ ካሊዲ ባና ሜላ ኡንዔꬂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","ዳሮ ኣሳይኔ ባንታ ቲራ ኢጪሼ ዬኪያ ማጫሳቲ ኢያ ጉዪያራ ካሎሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","ሺን ዬሱሲ ኤንታኮ ጉዬ ሲሚዲ፥ «ሂንቴኖ፥ ዬሩሳላሜ ማጫሳቶ፥ ሂንቴ ሁዔሲኔ ሂንቴ ናይታስ ዬኪቴፔ ኣቲን ታው ዬኮፊቴ። ");
INSERT INTO gofENT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","‹ሄኮ ማይንꬃቲ፥ ዬሎና ኡሎቲኔ ꬋንꬆና ꬋንꬃቲ ኣንጄቲዶሶና› ሂንቴ ያጋና ጋላሳይ ያና። ");
INSERT INTO gofENT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","ሄ ዎዴ ዴሬታ፥ ‹ኑ ቦላ ኩንዲቴ›፥ ዙማታካ፥ ‹ኑና ካሚቴ› ያጋና። ");
INSERT INTO gofENT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","ሂዛ፥ ቃዬ ሚꬃ ሄሳꬆ ኦꬂኮ ሜላ ሚꬃ ዋታንዴሻ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","ኢያራ ዎꬋናው ሃራ ናምዑ ዎራንꬖታ ኤፊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","ቄራኒዮ ጌቴቲያ ቤሳ ጋꬂዲ ካቂዶሶና። ዎራንꬖታፔ ኢሱዋ ኡሻቻ ባጋራ ሃንኩዋ ሃዲርሳ ባጋራ ካቂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","ዬሱሲ፥ «ታ ኣዋው፥ ኤንቲ ኣይ ኦꬂያኮ ኤሮና ጊሾ ኔኒ ኤንታው ኣቶ ያጋ» ያጊስ። ኤንቲ ኢያ ኣፊላ ቦላ ሳማ ዬጊዲ ሻኬቲዲ ኤኪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","ኣሳይ ኤቂዲ ፄሎሶና፥ ሺን ዴሪያ ሃሬይሳቲ፥ «ሃራታ ኣሺስ፤ ፆሳይ ዶሪዳ ኪሪስቶሲ ኢያ ጊዲኮ ኣኔ ባና ኣሾ» ያጊዲ ሌቂሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","ዎታዳሬቲ ኢያኮ ሺቂዲ፥ ጫላ ዎይኔ ኡሻ ኢሚዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ያቲዲ፥ «ኔኒ ኣይሁዴታ ካዎ ጊዲኮ ኔ ሁዒያ ኣሻ» ያጊዲ ሌቂሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","ኢያው ሁዔ ባጋራ፥ «ሃይሲ ኣይሁዴታ ካዎ» ያጊያ ፁፌይ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","ካቄቲዳ ዎራንꬖታፔ ኢሶይ ጫሼ ሳዓራ ጎቺሼ፥ «ኣኔ ኔኒ ኪሪስቶሳ ጊዲኮ፥ ኔናካ ኑናካ ኣሻ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","ሺን ሃንኮ ዎራንꬖይ፥ «ኔኒ ሃይሳ ሜላ ፒርዳን ዴዓሼ ሃሪ ኣቶሺን፥ ፆሳስ ያዪኪ? ");
INSERT INTO gofENT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","ኑኒ ኑ ባላስ ቤሲያ ፒርዳ ኤኮስ፥ ሺን ሃ ኡራይ ኢሲ ኢታባካ ኦꬂቤና» ያጊዲ ሃንቄቲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","ቃሲካ፥ «ዬሱሳ፥ ኔ ኔ ካዎቴꬃራ ያ ዎዴ ታና ቆፓ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","ዬሱሲ፥ «ታ ኔው ቱማ ኦዳይስ፤ ሃቺ ኔኒ ታራ ጋናቴን ጊዳና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","ሄ ጋላስ ኡሱፑን ሳቴፔ ቢዲ ኡዱፉን ሳቴ ጋካናው ኣዋይ ፖዑዋ ዲጊዳ ጊሾ ቢታ ኡባ ቦላ ꬉማ ጊዲስ። ፆሳ ኬꬃ ማጋራጆይ ዳኬቲዲ ናምዓን ሻኬቲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","ዬሱሲ፥ ቃላ ꬎቁ ኦꬂዲ፥ «ታ ኣዋው፥ ታ ታ ሼምፒው ኔ ኩሼን ሼꬋይስ» ያጊዲ ሃይቂስ። ");
INSERT INTO gofENT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","ማቶ ሃላቃይ፥ ሃኒዳይሳ ቤዒዲ፥ «ሃይሲ ኡራይ ቱማካ ፂሎ» ያጊዲ ፆሳ ጋላቲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","ሃ ሃኒያባ ቤዓናው ሄ ቤሳ ሺቂዳ ኣሳ ኡባይ ሃኒዳባ ቤዒዳ ዎዴ ባንታ ቲራ ኢጪሼ ባንታ ሶ ሲሚዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","ጊዶሺን፥ ዬሱሳ ማታን ኤሪያ ኣሳ ኡባይ፥ ሄሳዳካ ጋሊላፔ ካሊዲ ዪዳ ማጫሳቲ ሄሳ ቤዒሼ ሃሆን ኤቂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","ኣይሁዴ ሻንጎታፔ ኢሶይ፥ ዮሴፋ ጌቴቲያ ኡራይ ዴዔስ። ኢ ኣርማቲያሳ ጌቴቲያ ዪሁዳ ካታማፔ ዪስ። ኢ ሎዖኔ ፂሎ ኣሲ ጊዲያ ጊሾ ፆሳ ካዎቴꬃ ዩሳ ናጌስ። ሻንጎታፔ ኢሱዋ ጊዲሼ ኤንታ ዞሬቴꬃኒኔ ኦሱዋን ዴና። ");
INSERT INTO gofENT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","ሄ ኡራይ ጲላፆሳኮ ቢዲ፥ ዬሱሳ ኣሃ ሞጋናው ታው ኢማ ጊዲ ዎሲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","ጲላፆሲ ኤካ ያጊን፥ ዬሱሳ ኣሃ ዎꬊሲዲ ኣፊላራ ፃፂስ። ዛላፌ ዎጪዲ ኬሲዳ ሃራ ኣሲ ሞጌቶና ኦራꬃ ዱፎን ዎꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","ሳምባቲ ጌላና ሃኒያ ጊሾ ሄ ጋላሳይ ጊጌቴꬃ ቃማ። ");
INSERT INTO gofENT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","ጋሊላፔ ዴንዲዲ ዬሱሳ ካሊዲ ዪዳ ማጫሳቲ ዮሴፋራ ቢዲ ኢያ ኣሃ ዋቲ ሞጊያኮ ዱፉዋ ኣኬኪዲ ቤዒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","ያፔ ሲሚዲ ሺቶኔ ቂባቲያ ጊጊሲዶሶና። ሂጌይ ኪቴይሳ ሜላ ሳምባታ ጋላስ ሼምፒ ፔዒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","ሳሚንታፌ ኮይሮ ጋላስ፥ ዎጋ ዎዴ ዎንታ ዳሮ ጉራ፥ ማጫሳቲ ባንታ ጊጊሲዳ ሺቱዋ ኤኪዲ ዱፉዋ ቢዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","ኤንቲ ያ ጋኪያ ዎዴ ዱፉዋ ዶናን ዴዒያ ሹቻይ ጎንዴሬቲዲ ኪቾይሳ ዴሚዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","ኤንቲ ዱፉዋ ጋꬂ ጌሊዶሶና፥ ሺን ጎዳ ዬሱሳ ኣሃ ዴሚቦኮና። ");
INSERT INTO gofENT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","ኤንቲ ያን ኤቂዲ ኣይቢ ሃኒዴ ጊዲ ቆፒሺን ኣኬኮና ዳሮ ጶሊያ ኣፊላ ማዒዳ ናምዑ ኣሳቲ ኤንታ ማታን ኤቂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","ማጫሳቲ ያሼቲዲ ባንታ ሁዒያ ሳዓን ዚቂ ኦꬂዲ ዴዒሺን፥ ኣሳቲ ኤንታኮ፥ «ዴዖን ዴዔይሳ ሃይቆታ ጊዶን ኣይስ ኮዬቲ? ");
INSERT INTO gofENT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","7","ኢ ሃይሳን ዴና፤ ሃይቆፔ ዴንዲስ፥ ‹ኣሳ ናዓይ ናጋራንቾታ ኩሼን ኣꬊ ኢሜታና፤ ኤንቲካ ኢያ ካቃና። ኢ ሄꬓንꬆ ቃማን ሃይቆፔ ዴንዳና› ያጊዲ፥ ኢ ሂንቴራ ጋሊላን ዴዒሼ ሂንቴው ኦዲዳ ቃላ ቆፒቴ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","ማጫሳቲ ሄ ዎዴ ኢያ ቃላ ቆፒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","ማጫሳቲ ዱፉዋፔ ሲሚዲ ሃኒዳባ ኡባ ታማኔ ኢሶታሲኔ ሃራታሲካ ኦዲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","ሄሳ ሃዋሬታስ ኦዲዳይ ማግዴላ ማይራሞ፥ ዮሃና፥ ያይቆባ ኣዪው ማይራሞኔ ኤንታራ ዴዒያ ሃራ ማጫሳታ። ");
INSERT INTO gofENT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","ሺን ኤንታው ማጫሳቲ ኦዲዳይሲ ኤልሞ ዳኒን ኣማኒቦኮና። ");
INSERT INTO gofENT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","ሺን ጴፂሮሲ ዴንዲ ዎፂዲ ዱፎ ቢስ። ሄ ቤሳ ጋኪዲ ሆኪ ጋꬂ ፄሊያ ዎዴ ሞጎ ኣፊላ ፃላላ ቤዒስ። ሃኒዳባን ማላሌቲሼ ባ ሶ ሲሚስ። ");
INSERT INTO gofENT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","ሄ ጋላስ ካሊያ ታማሬታፔ ናምዓቲ ዬሩሳላሜፔ ታማኔ ኢሲ ኪሎ ሚቲሬ ሃኪያ ኤማሁሴ ጉታ ቦሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","ኤንቲ ዎላ ሃኒዳባ ኡባ ኦዴቶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","ኤንቲ ሄ ሃኖታባ ቆፒሼኔ ኦዴቲሼ ቢያ ዎዴ ዬሱሲ ባ ሁዔን ሺቂዲ ኤንታራ ቤስ። ");
INSERT INTO gofENT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","ሃኖሺን፥ ኤንቲ ኢያ ኤሮና ሜላ ኤንታ ኣይፌይ ኦይኬቲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","ኢ፥ «ሂንቴ ዎላ ኦጌ ቦላ ዴዒሼ ኦዴቴይሲ ኣይቤ?» ያጊስ። ኤንቲ ኣዛኒዲ ሲዒ ጊዲ ኤቂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","ኤንታፌ ኢሶይ ቄሊዮጳ ጌቴቴይሲ፥ «ሃ ቃማታ ጊዶን ዬሩሳላሜን ሃኒዳባ ኤሮናይሲ፥ ኔ ቢታስ ኢማꬄዬ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","ኢ ዛሪዲ፥ «ኢ ሃኒዳይሲ ኣይቤ?» ያጊዲ ኦይቺስ። ኤንቲ፥ «ፆሳ ሲንꬃኒኔ ኣሳ ሲንꬃን ኦሶኒኔ ኦዳን ሚኖ ናቤ ጊዲዳ ናዚሬቴ ዬሱሳባ። ");
INSERT INTO gofENT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","ኢያ ካሂኔ ሃላቃቲኔ ኑና ሃሬይሳቲ ሃይቆ ፒርዳስ ኣꬂ ኢሚዲ፥ ካቂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","ኑኒ ኢስራዔሌ ኣሳ ዎዛንዴ ጊዲ ኡፋይቲዲ ናጊዳሺን ሃይሲ ሃኒን ሃቺ ሄꬓንꬆ ቃማ። ");
INSERT INTO gofENT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","ቃሲ ኑ ጊዶፌ ኢሲ ኢሲ ማጫሳቲ ኑና ማላሊሲዶሶና። ኤንቲ ሃቺ ዎንታ ጉራ ዱፉዋ ቢዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ኢያ ኣሃ ꬋዪዳ ዎዴ ሲሚ ዪዲ፥ ‹ኢ ፓፃ ዴዔስ› ያጊያ ኪታንቾቲ ቆንጪን ቤዒዳ ያጊዲ ኦዲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","ኑ ጊዶፌካ ኢሶቲ ኢሶቲ ዱፉዋ ቢዲ ማጫሳቲ ኦዲዳይሳꬆ ሃኒን ቤዒዶሶና፥ ሺን ኢያ ቤዒቦኮና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","ኢ ኤንታኮ፥ «ሂንቴኖ፥ ኣኬኮና ኣሳው፥ ሂንቴ ዎዛናይ ናቤቲ ኦዲዳባ ኡባ ኣማናናው ጋምዔይሳቶ፥ ");
INSERT INTO gofENT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","ኪሪስቶሲ ሃ ሜቱዋ ኤካናዉኔ ባ ቦንቹዋን ጌላናው ቤሴኔ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","ሙሴፔኔ ናቤታ ኡባፌ ዴንዲዲ ጌሻ ማፃፋን ኢያባይ ፃፌቲዳይሳ ኡባ ኤንታው ቆንጪሲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","ኤንቲ ቢያ ጉታኮ ማታቲዳ ዎዴ ዬሱሲ ኣꬊዲ ሃሆ ሶ ቢያ ዳኒን፥ ");
INSERT INTO gofENT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","ኤንቲ፥ «ሳዓይ ቃሚዳ ጊሾ ኑራ ኣቃ» ያጊዲ ሚንꬂዲ ዎሲዶሶና። ሄሳ ጊሾ፥ ኤንታራ ኣቃናው ጌሊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","ኤንታራ ኢሲፌ ጋይታ ቦላ ኡቲዲ፥ ኡይꬃ ዴንꬂዲ፥ ሜንꬂ ኣንጂዲ ኤንታው ኢሚስ። ");
INSERT INTO gofENT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","ሄ ዎዴ ኤንቲ ኤራና ሜላ ኤንታ ኣይፌይ ዶዬቲስ። ኤንቲካ ኤሪዶሶና። ሺን ኢ ኤንታፌ ጌሚስ። ");
INSERT INTO gofENT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","ኤንቲ፥ «ኑ ኦጊያ ቦላ ዴዒሺን ኢ ኑስ ጌሻ ማፃፋ ቢርሺሺኒኔ ኑና ሃሳዪሲሺን ኑ ዎዛናይ ፁጌቲቤኔ?» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","ሄ ዎዴ ዴንዲዲ ጉዬ ዬሩሳላሜ ዪዶሶና። ታማኔ ኢሶቲኔ ሃራቲ ኢሲ ቦላ ሺቂዲ ዴዒሺን ዴሚዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ኤንቲ፥ «ጎዳይ ቱማ ዴንዲስ፤ ሲሞናስ ቆንጪስ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","ሄ ናምዑ ታማሬቲ ኤማሁሴ ኦጊያ ቦላ ዴዒሺን ሃኒዳይሳኔ ኡይꬃ ሜንꬂዳ ዎዴ ዋቲ ኢያ ኤሪዳኮ ኤንታው ኦዲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","ናምዑ ታማሬቲ ሄሳ ኦዳ ቦላ ዴዒሺን፥ ዬሱሲ ኤንታ ጊዶን ኤቂዲ፥ «ሳሮይ ሂንቴው ጊዶ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","ጊዶሺን፥ ኤንቲ ዳጋሚዲ፥ ሞይቲሌ ቤዒዳ ዳኒን ያዪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","ኢ ኤንታኮ፥ «ኣይስ ባቢዴቲ? ኣይስ ሲꬌይ ሂንቴ ዎዛናን ጌሊዴ? ");
INSERT INTO gofENT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","ታ ኩሺያኔ ታ ቶሁዋ ቤዒቴ፤ ታኒ ታና። ቃሲ ኦይኪዲ ቤዒቴ፤ ታናን ሂንቴ ቤዔይሳዳ፥ ሞይቲሌስ ኣሾይኔ ሜቄꬂ ባዋ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","ያጊዲ፥ ባ ቶሁዋኔ ባ ኩሺያ ኤንታ ቤሲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","ኤንቲ ኡፋይሳፌ ዴንዶይሳን ኣማኖና ማላሌቴꬃን ዴዒሺን፥ ዬሱሲ ኤንታኮ፥ «ሃይሳን ሂንቴው ሚያባይ ዴዒ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","ኤንቲ ኢሲ ጫጬቲዳ ሞሎ ኢያው ኢሚዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ኢ ኤኪዲ ኤንታ ሲንꬃን ሚስ። ");
INSERT INTO gofENT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","ኢ፥ «ታ ሂንቴራ ጋምዒዳ ዎዴ ኡባን ሙሴ ማፃፋታን፥ ናቤታ ማፃፋታኒኔ ማዝሙሬ ማፃፋታን፥ ታ ጊሾ ፃፌቲዳባይ ኡባይ ፖሌታናው ቤሴስ ያጋዳ ታ ሂንቴው ኦዲዳ ቃላይ ሃይሳ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","ሄ ዎዴ ጌሻ ማፃፋታ ኣኬካና ሜላ ዎዛና ኤንታ ዶዪስ። ");
INSERT INTO gofENT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ሄሳዳካ፥ «ኪሪስቶሲ ዋዬ ኤካና፥ ሄꬓንꬆ ቃማን ሃይቆፔ ዴንዳና ያጊዲ ፃፌቲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","ዬሩሳላሜፔ ዴንዲዲ ኣሳ ኡባስ ናጋራፔ ማሮቴꬃይኔ ኣቶቴꬃይ ኢያ ሱንꬃን ማርካታና። ");
INSERT INTO gofENT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","ሂንቴ ሄሳስ ማርካታ። ");
INSERT INTO gofENT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","ሄኮ፥ ታካ ታ ኣዋይ ኢሚዳ ኡፋይሳ ሂንቴው ዬዳና። ሂንቴ ሳሎፔ ዎልቃ ማዓና ጋካናው ዬሩሳላሜ ካታማን ጋምዒቴ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","ሄሳፌ ጉዬ፥ ቢታኒያ ካታማ ኤንታና ኤኪዲ ቢስ። ባ ኩሺያ ዴንꬂዲ ኣንጂስ። ");
INSERT INTO gofENT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","ኤንታና ኣንጂሼ ኤንታፌ ሻኬቲዲ ፑዴ ሳሎ ኤኬቲስ። ");
INSERT INTO gofENT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","ኤንቲ ዚጊ ጎይኒዲ ዳሮ ኡፋይሳን ዬሩሳላሜ ሲሚዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","ፆሳ ኡባ ዎዴ ጋላቲሼ ፆሳ ኬꬃን ጋምዒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","ቃላይ ኮይሮ ዴዔስ። ቃላይካ ፆሳራ ዴዔስ፤ ሄ ቃላይ ፆሳ። ");
INSERT INTO gofENT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","ኮይሮፔ ቃላይ ፆሳራ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","ፆሳይ ኡባባ ቃላ ባጋራ ሜꬊስ። ሜꬌቲዳባፔ ኢሶይካ ኢያ ባጋራ ሜꬌቶናባይ ባዋ። ");
INSERT INTO gofENT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","ኢያን ዴዖይ ዴዔስ፤ ሄ ዴዖይ ኣሳስ ፖዖ። ");
INSERT INTO gofENT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","ፖዖይ ꬉማን ፖዔስ፤ ꬉማይ ፖዑዋ ፆኒቤና። ");
INSERT INTO gofENT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","ፆሳይ ኪቲዳ፥ ኢሲ ዮሃኒሳ ጊያ ኣሲ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","ኣሳ ኡባይ ፖዑዋን ኣማናና ሜላ ኢ ፖዖስ ማርካ ጊዲዲ ዪስ። ");
INSERT INTO gofENT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","ኢ ፖዑዋባ ማርካታናው ዪሲፔ ኣቲን ባ ሁዔን ፖዖ ጊዴና። ");
INSERT INTO gofENT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","ኣሳ ኡባስ ፖዒሲያ ቱማ ፖዖይ ኣላሚያ ዬስ። ");
INSERT INTO gofENT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","ቃላይ ኣላሜን ዴዒስ። ፆሳይ ቃላን ኣላሚያ ሜꬊስ፥ ሺን ኣላሜይ ኢያ ኤሪቤና። ");
INSERT INTO gofENT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","ኢ ባይሳታኮ ዪስ፥ ሺን ኢያይሳቲ ኢያ ኤኪቦኮና። ");
INSERT INTO gofENT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","ሺን ኢ ባና ኤኪዳይሳታሲኔ ኢያ ሱንꬃን ኣማኒዳይሳታስ ፆሳ ናይታ ጊዳና ሜላ ማታ ኢሚስ። ");
INSERT INTO gofENT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","ኤንቲ ፆሳፌ ዬሌቲዶሶናፔ ኣቲን ኣሲ ዬሌቲያ ዎጋን ዎይኮ ኣዴ ሼኔን ዎይኮ ኣሳ ኣሞን ዬሌቲቦኮና። ፆሳይ ኢ ኤንታ ኣዋ። ");
INSERT INTO gofENT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","ቃላይ ኣሴ ጊዲስ፤ ኣꬎ ኬሃቴꬃኔ ቱማ ኩሚዲ ኑ ጊዶን ዴዒስ። ኢ ኣዋስ ኢሲ ናዓ ጊዲዲ ኤኪዳ ኢያ ቦንቹዋ ኑኒ ቤዒዳ። ");
INSERT INTO gofENT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","ዮሃኒሲ ኢያባ ማርካቲስ። ባ ቃላ ꬎቁ ኦꬂዲ፥ «ታኒ፥ ‹ታፔ ጉዬራ ዬይሲ ታፔ ካሴ ዴዒያ ጊሾ ታፔ ኣꬌስ› ጋዳ ማርካቲዳይሲ ሃይሳ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","ኑኒ ኡባይ ኢያ ኣꬎ ኬሃቴꬃ ኩሜꬃፌ ኣንጆ ቦላ ኣንጆ ኤኪዳ። ");
INSERT INTO gofENT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","ፆሳይ ሂጊያ ሙሴ ባጋራ ኢሚስ፥ ሺን ኣꬎ ኬሃቴꬃይኔ ቱማቴꬃይ ዬሱስ ኪሪስቶሳ ባጋራ ዪስ። ");
INSERT INTO gofENT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","ፆሳ ቤዒዳ ኣሲ ኦኒካ ባዋ፤ ባ ኣዋ ማታን ዴዒያ ኢሲ ናዓ ፃላሊ ባው ፆሴ ጊዲዳይሲ ኢያ ቆንጪሲስ። ");
INSERT INTO gofENT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","ዬሩሳላሜን ዴዒያ ኣይሁዴ ሃላቃቲ፥ ካሂኔታኔ ሌዌታ፥ «ኔኒ ኦኔ?» ጊዲ፥ ዮሃኒሳ ኦይቻና ሜላ ኢያኮ ኪቲን፥ ዮሃኒሲ ኤንታው ማርካቲዳ ማርካቴꬃይ ሃይሳ። ");
INSERT INTO gofENT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","ዮሃኒሲ፥ «ታኒ ኪሪስቶሳ ጊዲኬ» ያጊዲ፥ ጌሺዲ ማርካቲሲፔ ኣቲን ካዲቤና። ");
INSERT INTO gofENT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","ኤንቲ፥ «ያቲን፥ ኔኒ ኦኔ? ኔኒ ኤሊያሴዬ?» ያጊዲ ኦይቺዶሶና። ዮሃኒሲ፥ «ኣካይ ጊዲኬ» ያጊስ። ቃሲ ኤንቲ፥ «ኔኒ ያና ጌቴቲዳ ናቢያዬ?» ያጊዲ ኦይቺዶሶና። ዮሃኒሲ፥ «ኣካይ» ጊዲ ዛሪስ። ");
INSERT INTO gofENT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","ያቲን፥ «ኔኒ ኦኔ? ኑኒ ኑና ኪቲዳይሳታስ ኦዳና ሜላ ኔኒ ኔና ኦና ጋይ?» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","ዮሃኒሲ ዛሪዲ፥ «ናቢያ ኢሳያሲ ጊዳይሳዳ፥ ‹ጎዳ ኦጊያ ሱሪሲቴ!› ጊዲ ባዞ ቢታን ዋሲያ ኡራ ቃላይ ታና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","ቃሲ ፋሪሳዌቲ ኪቲዳ ኣሳቲ ");
INSERT INTO gofENT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","ዮሃኒሳኮ፥ «ኔኒ ኪሪስቶሳ ዎይኮ ኤሊያሳ ዎይኮ ናቤ ጊዶና ኢፂኮ፥ ያቲን ኣይስ ፃማቃይ?» ጊዲ ኦይቺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","ዮሃኒሲ ዛሪዲ፥ «ታኒ ሃꬃን ፃማቃይስ፥ ሺን ሂንቴ ኤሮና ኣሲ ሂንቴ ጊዶን ኤቂስ። ");
INSERT INTO gofENT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","ኢ ታፔ ጉዬራ ዬስ። ታኒ ሃሪ ኣቶሺን ኢያ ጫማ ዎዶሩዋ ቢላናው ቤሲኬ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","ሄሲ ኡባይ ዮርዳኖሴ ሻፋፔ ሄፊንꬃን፥ ቢታኒያ ካታማን፥ ዮሃኒሲ ፃማቂያ ቤሳን ሃኒስ። ");
INSERT INTO gofENT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","ዮሃኒሲ ዎንቴꬃ ጋላስ ዬሱሲ ባኮ ዪሺን ቤዒዲ፥ «ኣላሚያ ናጋራ ቁቺያ ፆሳ ዶርሳይ ሃይሳ! ");
INSERT INTO gofENT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","ታኒ፥ ‹ታፔ ጉዬራ ኢሲ ኣሲ ያና። ኢ ታፔ ካሴ ዴዒያ ጊሾ ታፔ ኣꬌስ› ጋዳ ኦዲዳይሲ ሃይሳ። ");
INSERT INTO gofENT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","ኢ ኦኔኮ ታኒ ኤሪኬ። ሺን ኢስራዔሌ ኣሳስ ኢያ ቆንጪሳናው ሃꬃን ፃማቃሼ ያስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","ዮሃኒሲ ሃይሳዳ ያጊዲ ማርካቲስ፡ «ጌሻ ኣያናይ ሳሎፔ ሆሌዳ ዎꬊሺኒኔ ኢያራ ዴዒሺን ቤዓስ። ");
INSERT INTO gofENT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","ሄሲ ሃናናፔ ካሴ ታኒ ኢያ ኤሪኬ። ሺን ሃꬃን ፃማቃናው ታና ኪቲዳ ፆሳይ፥ ‹ጌሻ ኣያናይ ዎꬊዲ ኢያራ ዴዒሺን ኔኒ ቤዓናይሲኔ ጌሻ ኣያናን ፃማቃናይሲ ኢያ› ያጊዲ ታው ኦዲስ። ");
INSERT INTO gofENT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","ታኒ ሄሲ ሃኒሺን ቤዓዳ፥ ኢ ፆሳ ናዓ ጊዲዳይሳ ማርካታይስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","ቃሲ ዎንቴꬃ ጋላስ ዮሃኒሲ ባ ታማሬታፔ ናምዓታራ ኢሲፌ ኤቂስ። ");
INSERT INTO gofENT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ዬሱሲ ኣꬊሺን ዮሃኒሲ ቤዒዲ፥ «ፆሳ ዶርሳይ ሃይሲሽ!» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","ናምዑ ዮሃኒሳ ታማሬቲ ዮሃኒሲ ጌይሳ ሲዒዲ ዬሱሳ ካሊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","ዬሱሲ ባና ካሌይሳታ ጉዬ ሲሚ ቤዒዲ፥ «ኣይ ኮዬቲ?» ያጊዲ ኦይቺስ። ኤንቲ ዛሪዲ፥ «ኣስታማሪያው፥ ኔኒ ኣዉን ዴዓይ?» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","ዬሱሲ ኤንታኮ፥ «ሃ ዪዲ ቤዒቴ» ያጊስ። ኤንቲ ቢዲ ኢ ዴዒያሱዋ ቤዒዶሶና። ሄ ጋላስ ሳዓይ ታሙ ሳቴ ሄራ ጊዲያ ጊሾ ኢያ ማታን ፔዒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","ዮሃኒሲ ጊዳይሳ ሲዒዲ፥ ዬሱሳ ካሊዳ ናምዑ ታማሬታፔ ኢሶይ፥ ሲሞን ጴፂሮሳ ኢሻ ኢንዲሪያሳ። ");
INSERT INTO gofENT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","ኢንዲሪያሲ ኮይሮ ባ ኢሻ ሲሞናራ ጋሄቲዲ፥ «ኑኒ ኪሪስቶሳ ዴሚዳ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","ኢንዲሪያሲ ሲሞና ዬሱሳኮ ኤሂስ። ዬሱሲ ሲሞና ቤዒዲ፥ «ኔኒ ዮና ናዓ ሲሞና፤ ኔ ሱንꬃይ ኬፋ ጊዲ ፄጌታና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","ዎንቴꬃ ጋላስ ዬሱሲ ጋሊላ ቢታ ባናው ቆፋ ቃቺስ። ኢ ፊልጶሳራ ጋሄቲዲ፥ «ታና ካላ!» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","ፊልጶሲ፥ ኢንዲሪያሲኔ ጴፂሮሲ ዴዒዳ ቤቴሳይዳ ካታማፔ ዪዳ ኣሴ። ");
INSERT INTO gofENT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","ፊልጶሲ ናቲናዔላራ ጋሄቲዲ፥ «ሙሴይ ሂጌ ማፃፋን፥ ቃሲ ናቤቲካ ኢያባ ፃፊዳ ዮሴፋ ናዓ ናዚሬቴ ዬሱሳ ኑኒ ዴሚዳ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","ናቲናዔሊ ዛሪዲ፥ «ናዚሬቴ ካታማፔ ሎዖባይ ኬያናው ዳንዳዒ?» ያጊስ። ፊልጶሲ፥ «ያዳ ቤዓ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","ናቲናዔሊ ባኮ ዬይሳ ዬሱሲ ቤዒዲ፥ «ጌኔይ ባይና ቱማ ኢስራዔሌ ኣሲ ሃይሳ!» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","ናቲናዔሊ ዬሱሳኮ፥ «ኔኒ ታና ኣዉን ኤራይ?» ያጊስ። ዬሱሲ ዛሪዲ፥ «ፊልጶሲ ኔና ፄጋናፔ ሲንꬄ፥ ኔኒ ባላሴ ሚꬃ ጋርሳን ዴዒሺን ታኒ ኔና ቤዓስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","ናቲናዔሊ ዛሪዲ፥ «ኣስታማሪያው፥ ኔኒ ፆሳ ናዓ! ኔኒ ኢስራዔሌ ካዎ!» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","ዬሱሲ ኢያኮ፥ «ታኒ ኔና ባላሴ ሚꬃ ጋርሳን ቤዓስ ጊዳ ጊሾ ኣማናይ? ኔኒ ሃይሳፌ ኣꬊያባ ቤዓና!» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","ቃሲ ዬሱሲ፥ «ታኒ ሂንቴው ቱማ ኦዳይስ፤ ሳሎይ ዶዬቲን፥ ፆሳ ኪታንቾቲ ኣሳ ናዓ ቦላ ኬዪሺኒኔ ዎꬊሺን ሂንቴ ቤዓና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","ሄꬓንꬆ ጋላስ ጋሊላ ቢታን ቃና ካታማን ያጋኖይ ያጋኔቲስ። ዬሱሳ ኣያ ሄ ያጋኑዋን ዴዓዉሱ። ");
INSERT INTO gofENT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ዬሱሲካ ባ ታማሬታራ ኢሲፌ ሄ ያጋኑዋ ፄጌቲስ። ");
INSERT INTO gofENT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","ዎይኔ ኡሻይ ዉሪን፥ ዬሱሳ ኣያ ዬሱሳኮ፥ «ኤንታው ዎይኔ ኡሻይ ዉሪስ» ያጋሱ። ");
INSERT INTO gofENT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","ዬሱሲ ዛሪዲ፥ «ታ ኣዬ፥ ኔ ሃይሳን ጌሎፓ? ታ ዎዴይ ቡሮ ጋኪቤና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","ዬሱሳ ኣያ ኦሳንቾታኮ፥ «ኢ ሂንቴው ኦዲያባ ኣይቢባ ጊዲኮካ ኦꬂቴ» ያጋሱ። ");
INSERT INTO gofENT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","ኣይሁዴቲ ባንታ ጌሾ ዎጋስ ጎዔቲያ ኡሱፑን ሹቻ ባꬃቲ ሄ ቤሳን ዴዖሶና። ኢሲ ኢሲ ባꬃይ ናምዑ ዎይኮ ሄꬑ ፁጋ ኦይኬስ። ");
INSERT INTO gofENT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","ዬሱሲ ኦሳንቾታኮ፥ «ባꬃታን ሃꬄ ኩንꬂቴ» ያጊስ። ኤንቲ ባꬃታስ ዶና ጋካናው ሃꬄ ኩንꬂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","ዬሱሲ ኤንታኮ፥ «ሃዒ ዱቂዲ ያጋኑዋ ኣዋቴꬃን ፖሊሴይሳስ ኢሚቴ» ያጊስ። ኤንቲ ኢያው ኤፊዲ ኢሚዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","ያጋኑዋ ኣዋቴꬃን ፖሊሴይሲ ዎይኔ ኡሺ ላሜቲዳ ሃꬃ ጋንፂ ኤኪዲ ኣዉፔ ዪዳኮ ኤሪቤና፥ ሺን ሃꬃ ኩንꬂዳ ኦሳንቾቲ ኤሮሶና። ያጋኑዋ ኣዋቴꬃን ፖሊሴይሲ ማቺው ኤኬይሳ ፄጊዲ፥ ");
INSERT INTO gofENT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","«ኦኒካ ሎዖ ዎይኔ ኡሻ ኣሳ ኮይሮቲዲ ኡሼስ። ያቲዲ ኣሳይ ኡዪ ካሊዳፔ ጉዬ ቂራሪያ ኢሜስ። ሺን ኔኒ ሎዖ ዎይኔ ኡሻ ሃኖ ጋካናው ዎꬃ ኣጋዳሳ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","ዬሱሲ ሃ ኮይሮ ማላታ ጋሊላ ቢታን ቃና ካታማን ኦꬂስ፤ ሄሳን ባ ጊታቴꬃ ቤሲስ። ኢያ ታማሬቲ ኢያ ኣማኒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","ሄሳፌ ጉዬ፥ ዬሱሲ ባ ኣዬራ፥ ባ ኢሻታራኔ ባ ታማሬታራ ኢሲፌ ቂፊርናሆሜ ካታማ ቢዲ ጉꬃ ጋላስ ጋምዒስ። ");
INSERT INTO gofENT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","ኣይሁዴቲ ቦንቺያ ፓሲካ ባሌ ጋላሳይ ማታቲን ዬሱሲ ዬሩሳላሜ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","ቢዲ ፆሳ ኬꬃን ቦራታ፥ ሚዛታ፥ ዶርሳታኔ ሆሌታ ባይዜይሳታኔ ባንታ ኦይዲያን ኡቲዲ ሚሼ ላሜይሳታ ዴሚስ። ");
INSERT INTO gofENT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","ኢ ፁርቃፌ ዶቂዲ ኣሳ ኡባ ኤንታ ሜሄታራ ፆሳ ኬꬃፌ ጎዲዲ ካሬ ኬሲስ። ሚሼ ላሜይሳታ ፃርጴዛታካ ኣꬂ ዬጊዲ ኤንታ ሚሺያ ላሊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","ሆሌ ባይዜይሳታ፥ «ሃ ሆሌታ ሃይሳፌ ኬሲቴ፤ ታ ኣዋ ኬꬃ ጊያ ኦꬆፊቴ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","ኢያ ታማሬቲ ጌሻ ማፃፋን፥ «ታኒ ኔ ኬꬃስ ሚሼቲያ ሚሻይ ታና ታማዳ ፁጌስ» ጌቴቲዲ ፃፌቲዳይሳ ኣኬኪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","ሄሳፌ ጉዬ፥ ኣይሁዴቲ ዛሪዲ፥ «ኔ ሃይሳ ኦꬃናው ኔው ማቲ ዴዔይሳስ ኑና ኣይ ማላታ ኦꬃዳ ቤሳኔ?» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","ዬሱሲ፥ «ሃ ፆሳ ኬꬃ ላሊቴ፤ ታኒ ሄꬑ ጋላሳን ዛራዳ ኬፃና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","ቃሲካ ኣይሁዴቲ፥ «ሃ ፆሳ ኬꬃ ኬፃናው ኦይታማኔ ኡሱፑን ላይꬂ ኤኪስ፥ ሺን ኔኒ ሄꬑ ጋላሳን ኬፃኔ?» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","ሺን ዬሱሲ ኦዲያ ፆሳ ኬꬃይ ባ ኣሳቴꬃባ። ");
INSERT INTO gofENT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","ሄሳ ጊሾ፥ ዬሱሲ ሃይቆፔ ዴንዲዳፔ ጉዬ ኢያ ታማሬቲ ኢ ሄሳ ጊዳይሳ ኣኬኪዶሶና። ቃሲ ኤንቲ ጌሻ ማፃፋን ፃፌቲዳይሳኔ ዬሱሲ ኦዲዳይሳ ኣማኒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","ዬሱሲ ፓሲካ ቦንቺያ ቤሳን ዬሩሳላሜን ዴዒሺን፥ ኢ ኦꬂዳ ማላታታ ቤዒዲ ዳሮ ኣሳይ ኢያ ኣማኒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","ሺን ዬሱሲ ኣሳ ኡባ ኤሪያ ጊሾ ኤንታ ኣማኒቤና። ");
INSERT INTO gofENT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","ኣሳ ዎዛናን ዴዒያባ ኢ ባ ሁዔን ኤሪያ ጊሾ ኣሳባ ኦኒካ ኢያው ኦዳና ሜላ ኮሺቤና። ");
INSERT INTO gofENT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","ፋሪሳዌታ ያራፔ ጊዲዳ፥ ኣይሁዴታ ሃላቃይ፥ ኒቆዲሞሳ ጊያ ኢሲ ኣዴይ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","ኒቆዲሞሲ ቃማ ዬሱሳኮ ዪዲ፥ «ኣስታማሪያው፥ ኔኒ ፆሳይ ኪቲዳ ኣስታማሬ ጊዴይሳ ኑኒ ኤሮስ። ኣይስ ጊኮ፥ ፆሳይ ኢያራ ዶና ኢፂኮ ሃ ኔኒ ኦꬂያ ማላታ ኦꬃናው ዳንዳዒያ ኣሲ ባዋ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","ዬሱሲ ዛሪዲ፥ «ታኒ ኔው ቱማ ኦዳይስ፤ ኦኒካ ዛሪ ዬሌቶና ኢፂኮ ፆሳ ካዎቴꬃ ቤዓናው ዳንዳዔና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","ኒቆዲሞሲ፥ «ጬጋ ኣሲ ዋኒዲ ዛሪ ዬሌታናው ዳንዳዒ? ባ ኣዬ ኡሎ ሲሚ ጌሊዲ ዛሪ ዬሌታናው ዳንዳዒ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","ዬሱሲ ዛሪዲ፥ «ታኒ ኔው ቱማ ኦዳይስ፤ ኦኒካ ሃꬃፌኔ ጌሻ ኣያናፔ ዬሌቶና ኢፂኮ፥ ፆሳ ካዎቴꬃ ጌላናው ዳንዳዔና። ");
INSERT INTO gofENT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","ኣሾ ናዓቴꬂ ኣዉፔኔ ኣዪፔ ዬስ፤ ፆሳ ናዓቴꬂ ጌሻ ኣያናፔ ኢሜቴስ። ");
INSERT INTO gofENT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","ታኒ፥ ‹ሂንቴ ዛሪ ዬሌታናው ቤሴስ› ጋዳ ሂንቴው ኦዲዳ ጊሾ ኔኒ ማላሌቶፋ። ");
INSERT INTO gofENT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","ጫርኮይ ባ ኮዪዳ ቤሲ ጫርኬስ። ኔኒ ኢያ ኮሺንቻ ሲዓሳፔ ኣቲን ኢ ኣዉፔ ያኮ ዎይኮ ኣው ቢያኮ ኤራካ። ኣያናፔ ዬሌቲዳ ኡባይ ሄሳ ሜላ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","ያቲን ኒቆዲሞሲ፥ «ሄሲ ዋኒዲ ሃናናው ዳንዳዒ?» ያጊዲ ኦይቺስ። ");
INSERT INTO gofENT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","ዬሱሲ ዛሪዲ፥ «ኔኒ ኢስራዔላታ ኣስታማሬ ጊዳሼ ሃይሳ ኤሪኪ? ");
INSERT INTO gofENT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","ታኒ ኔው ቱማ ኦዳይስ፤ ኑ ኤሪያባ ኦዶሲኔ ቤዒዳባ ማርካቶስ፥ ሺን ኑ ማርካቴꬃ ሂንቴ ኤኬኬታ። ");
INSERT INTO gofENT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","ታኒ ሂንቴው ሳዓባ ኦዲን ሂንቴ ኣማኖናባ ጊዲኮ ሳሎባ ኦዲን ዋቲ ኣማናኔ? ");
INSERT INTO gofENT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","ሳሎፔ ዎꬊዳ ኣሳ ናዓፔ ኣቲን ሳሎ ኬዪዳይ ኦኒካ ባዋ፤ ሳሎን ዴዒያ ኣሳ ናዓይ ታና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","15","ሙሴይ ባዞ ቢታን ቢራታ ሾሺ ካቂዳይሳዳ ታና ኣማኒዳ ኡባይ ሜሪና ዴዑዋ ኤካና ሜላ ኣሳ ናዓይ ꬎቁ ጋናው ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","ፆሳ ናዓ ኣማኒያ ኡባይ ሜሪና ዴዑዋ ላታናፔ ኣቲን ꬋዮና ሜላ ፆሳይ ሃ ኣላሚያ ዳሮ ዶሲዳ ጊሾ ባ ኢሲ ናዓ ኢሚስ። ");
INSERT INTO gofENT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","ፆሳይ ባ ናዓ ሃ ኣላሚያ ኪቲዳይ ኣላሚያ ፒርዳናው ጊዶናሺን ኣላሚያ ኢያ ባጋራ ኣሻናሳ። ");
INSERT INTO gofENT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","ናዓ ኣማኒያ ኦኒካ ፒርዴቴና፥ ሺን ናዓ ኣማኖና ኦኒካ ኢሲ ፆሳ ናዓ ኣማኒቦና ጊሾ ሃዒ ፒርዴቲስ። ");
INSERT INTO gofENT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","ፒርዳይካ ሃይሳ፡ ፖዖይ ኣላሚያ ዪስ፥ ሺን ኣሳ ኦሶይ ኢታ ጊዲያ ጊሾ ኣሳይ ፖዑዋፔ ኣꬂዲ ꬉማ ዶሴስ። ");
INSERT INTO gofENT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","ኢታባ ኦꬂያ ኦኒካ ፖዖ ኢፄስ። ኣይስ ጊኮ፥ ባ ኦሶይ ቆንጮና ሜላ ፖዑዋኮ ዬና። ");
INSERT INTO gofENT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","ሺን ቱማ ኦꬂያ ኦኒካ ፆሳይ ኪቲዳይሳዳ ኢ ኦꬂዳይሳ ፖዖይ ቆንጪሳና ሜላ ፖዑዋኮ ዬስ። ");
INSERT INTO gofENT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","ሄሳፌ ጉዬ፥ ዬሱሲኔ ኢያ ታማሬቲ ዪሁዳ ቢታ ቢዶሶና። ዬሱሲ ያን ፃማቂሼ ኤንታራ ጉꬃ ዎዴ ኡቲስ። ");
INSERT INTO gofENT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","ቃሲ ዮሃኒሲ ሳሌሜ ማታን ዴዒያ ሄኖና ጊያሶን ጊዲያ ሃꬂ ዴዒያ ጊሾ ኣሳ ያን ፃማቄስ። ኣሳይካ ያ ቢዲ ፃማቄቶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","ሄ ዎዴ ዮሃኒሲ ቡሮ ቃሼቲቤና። ");
INSERT INTO gofENT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","ሄሳፌ ጉዬ፥ ዮሃኒሳ ታማሬቲኔ ኢሲ ኣይሁዴ ኣዴይ ጌሾ ዎጋባ ፓላሚዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","ኤንቲ ዮሃኒሳኮ ቢዲ፥ «ኣስታማሪያው፥ ዮርዳኖሴ ሻፋፔ ሄፊንꬃን ኔራ ዴዔይሲ፥ ኔኒ ኢያባ ማርካቲዳይሲ፥ ሄኮ ፃማቄስ። ኣሳይ ኡባይካ ኢያኮ ቦሶና» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","ዮሃኒሲ ዛሪዲ፥ «ፆሳይ ኢሞና ኣሲ ኣይቢባካ ኤካናው ዳንዳዔና። ");
INSERT INTO gofENT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","‹ታኒ ኪሪስቶሳ ጊዲኬ፥ ሺን ኢያፔ ሲንꬄ ኪቴታስ› ጊዳይሳስ ሂንቴ፥ ሂንቴ ሁዔን ታው ማርካ። ");
INSERT INTO gofENT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","ጌሎስ ጊጊዳራ ኤኬናው ጊጊዳይሳሳ። ኤኬይሳ ላጌይ ኢያ ማታን ኤቂዲ ኢ ጌይሳ ሲዒያ ዎዴ ዳሮ ኡፋይቴስ። ሄሳ ጊሾ፥ ሃይሲ ታ ኡፋይሳይ ፖሌቲስ። ");
INSERT INTO gofENT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","ኢ ጊታታናው ታኒ ጉፃናው ቤሴስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","ቦላፌ ዬይሲ ኡባፌ ቦላ። ሳዓፔ ቤንቲዳይሲ ሳዓባ። ኢ ሳዓባ ኦዴስ። ሳሎፔ ዬይሲ ኡባፌ ቦላ። ");
INSERT INTO gofENT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ኢ ባ ቤዒዳባኔ ሲዒዳባ ማርካቴስ፥ ሺን ኢያ ማርካቴꬃ ኤኬይ ባዋ። ");
INSERT INTO gofENT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","ኢያ ማርካቴꬃ ኤኪያ ኦኒካ ፆሳይ ቱማ ጊዴይሳ ቆንጪሴስ። ");
INSERT INTO gofENT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","ፆሳይ ባ ጌሻ ኣያና ኢያው ኩሜꬂ ኢሚያ ጊሾ ፆሳይ ኪቲዳይሲ ፆሳ ቃላ ኦዴስ። ");
INSERT INTO gofENT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","ኣዋይ ባ ናዓ ዶሲዲ ኡባባ ኢያ ኩሼን ዎꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","ናዓ ኣማኒያ ኡራስ ሜሪና ዴዖይ ዴዔስ። ሺን ናዓ ኣማኖናይሳ ቦላ ፆሳ ሃንቆይ ዴዔሲፔ ኣቲን ኢ ዴዖ ዴሜና። ");
INSERT INTO gofENT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","ዬሱሲ ዮሃኒሳይሳፌ ዳሪያ ካሌይሳታ ባኮ ሺሼይሳኔ ፃማቄይሳ ፋሪሳዌቲ ሲዒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","ጊዲኮካ ዬሱሳ ታማሬቲ ፃማቂዶሶናፔ ኣቲን ዬሱሲ ኦናካ ፃማቂቤና። ");
INSERT INTO gofENT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","ዬሱሲ ኣሳይ ኢያባ ጌይሳ ሲዒዳ ዎዴ ዪሁዳፔ ዴንዲዲ ጋሊላ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","ጋሊላ ቢሼ ሳማሬራ ኣꬋናይሲ ኢያው ኣቶናባ ጊዲስ። ");
INSERT INTO gofENT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","ሄሳ ጊሾ፥ ያይቆቢ ባ ናዓ ዮሴፋስ ኢሚዳ ጋዲያ ማታን ዴዒያ ሲካሬ ጊያ ሳማሬ ካታማ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","ሄ ቤሳን ያይቆባ ሃꬃ ኦላይ ዴዔስ። ዬሱሲ ሃሙꬃን ዳቡሪዲ ሄ ሃꬃ ኦላ ማታን ኡቲስ። ሄ ዎዴ ሳዓይ ኡሱፑን ሳቴ ሄራ። ");
INSERT INTO gofENT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","ኢሲ ሳማሬ ካታማ ማጫስ ሄ ኦላፌ ሃꬄ ቲካናው ያሱ። ዬሱሲ ሄ ማጫሴኮ፥ «ታና ሃꬄ ኡሻርኪ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","ሄ ዎዴ ዬሱሳ ታማሬቲ ካꬂ ሻማናው ካታማ ቢዶሶናሺን። ");
INSERT INTO gofENT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","ሄ ማጫሲያ ዛራዳ፥ «ኔኒ ኣይሁዴ ኣሴ ጊዳሼ፥ ሳማሬ ማጫስ ጊዲያ ታና ዋናዳ ሃꬄ ኡሻ ጋይ?» ያጋሱ። ሄሳ ኢያ ጊዳይ ኣይሁዴቲ ሳማሬታራ ጋሄቶና ጊሾሳ። ");
INSERT INTO gofENT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","ዬሱሲ ዛሪዲ፥ «ኔኒ ፆሳ ኢሞታኔ ሃꬄ ታና ኡሻ ጌይሲ ኦኔኮ ኤሪዳባ ጊዲያኮ ኢያ ኔ ዎሳና፤ ኢካ ኔው ዴዖ ኢሚያ ሃꬂ ኢማናሺን» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","ማጫሲያ ዛራዳ፥ «ጎዳው፥ ኔው ዱቂያባይ ባዋ፤ ኦላይካ ዚቃ። ያቲን፥ ዴዖ ኢሚያ ሃꬂ ኔ ኣዉፔ ኤካኔ? ");
INSERT INTO gofENT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","ኑስ ሃ ሃꬃ ኦላ ኢሚዳ ኑ ኣዋ ያይቆባፔ ኔኒ ኣꬋይ? ኢ፥ ኢያ ናይቲኔ ኢያ ሜሄይ ሃ ኦላፌ ኡዪዶሶና» ያጋሱ። ");
INSERT INTO gofENT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","ዬሱሲ፥ «ሃ ሃꬃፌ ኡዪዳ ኦኒካ ዛሪ ሳሞታና። ");
INSERT INTO gofENT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","ሺን ታኒ ኢማና ሃꬃ ኡያ ኦኒካ ኡባካ ሳሞቴና። ታኒ ኢማና ሃꬃይ ኢያ ጊዶን ሜሪና ዴዖ ኢሚያ ጎጊያ ፑልቶ ጊዳና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","ማጫሲያ ዛራዳ፥ «ጎዳው፥ ታኒ ሳሞቶና ሜላኔ ሃꬄ ቲካናው ሃ ቤሳ ዮና ሜላ ታው ሄ ሃꬃ ኢማ» ያጋሱ። ");
INSERT INTO gofENT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","ዬሱሲ ኢኮ፥ «ባዳ ኔ ኣዚና ፄጋዳ ያ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","ማጫሲያ ዛራዳ፥ «ታው ኣዚኒ ባዋ» ያጋሱ። ዬሱሲ ኢኮ፥ «ታው ኣዚኒ ባዋ ጉሳን ባላባካ። ");
INSERT INTO gofENT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","ኔው ካሴ ኢቻሹ ኣዚናቲ ዴዖሶና። ሃዒ ኔራ ዴዒያ ኣዴይ ኔ ኣዚና ጊዴና። ኔኒ ሃዒ ቱማ ኦዳዳሳ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","ማጫሲያ ዛራዳ፥ «ጎዳው፥ ኔኒ ናቤ ጊዴይሳ ታኒ ኤራስ። ");
INSERT INTO gofENT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","ኑ ኣዋቲ ሃ ዴሪያ ቦላ ፆሳ ጎይኒዶሶና። ሺን ሂንቴ ኣይሁዴቲ ኣሲ ፆሴ ጎይናናው ቤሲያ ቤሳይ ዬሩሳላሜና ጌታ» ያጋሱ። ");
INSERT INTO gofENT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","ዬሱሲ፥ «ሃ ማጫሴቴ ታና ኣማና፤ ሃ ዴሪያ ቦላ ዎይኮ ዬሩሳላሜን ኣዋ ሂንቴ ጎይኖና ዎዴይ ያና። ");
INSERT INTO gofENT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","ሂንቴ ሳማሬቲ ኤሮናይሳ ጎይኔታ። ሺን ኑኒ ኣቶቴꬃይ ኣይሁዴፔ ያ ጊሾ ኑ ኤሬይሳ ጎይኖስ። ");
INSERT INTO gofENT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","ሺን ኣዋ ቱማን ጎይኔይሳቲ ኣያናኒኔ ቱማቴꬃን ጎይናና ዎዴይ ማታቲስ፤ ሃዒካ ጋኪስ። ሂዛ፥ ኣዋይ ኮዬይ ሃይሳ ሜላ ኦጊያን ጎይኔይሳታ። ");
INSERT INTO gofENT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","ፆሳይ ኣያና፤ ኢያው ጎይኔይሳቲ ኣያናኒኔ ቱማቴꬃን ጎይናናው ቤሴስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","ማጫሲያ ዛራዳ፥ «ኪሪስቶሲ ያናይሳ ታኒ ኤራይስ። ኢ ያ ዎዴ ኑስ ኡባባ ኦዳና» ያጋሱ። ");
INSERT INTO gofENT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","ዬሱሲ፥ «ሃ ኔራ ኦዴቴይ ታኒ ኢያ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","ኤንቲ ኦዴቲሺን፥ ዬሱሳ ታማሬቲ ቢዳ ቤሳፌ ሲሚዶሶና። ዬሱሲ ማጫሳራ ኦዴቲሺን ኤንቲ ቤዒዲ ዳሮ ማላሌቲዶሶና። ሺን ማጫሴኮ፥ «ኣይ ኮያይ?» ዎይኮ ዬሱሳኮ፥ «ኢራ ኣይስ ኦዴታይ?» ጊዳይ ኦኒካ ባዋ። ");
INSERT INTO gofENT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","ሄሳፌ ጉዬ፥ ማጫሲያ ባ ሃꬃ ኦቱዋ ኣጋዳ ጉዬ ካታማ ባዳ ኣሳኮ፥ ");
INSERT INTO gofENT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«ታኒ ኦꬂዳባ ኡባ ታው ኦዲዳ ኣዲያ ቤዓናው ዬꬊቴ። ኢ ኪሪስቶሳ ጊዳንዴሻ?» ያጋሱ። ");
INSERT INTO gofENT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","ኣሳይ ካታማፔ ኬዪዲ ዬሱሳኮ ቢዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","ሄሲ ሃኒሺን፥ ኢያ ታማሬቲ ዬሱሳኮ፥ «ጉꬃባ ማርኪ» ያጊዲ ዎሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","ሺን ኢ፥ «ታው ሂንቴ ኤሮና ካꬂ ታ ሜይሲ ዴዔስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","ሄሳ ጊሾ፥ ኢያ ታማሬቲ ባንታ ጊዶን፥ «ኢያው ሚያባ ኣሲ ኤሆና ኣጌና?» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","ዬሱሲ ኤንታኮ፥ «ታ ካꬃይ ታና ኪቲዳይሳ ሼኒያ ኦꬃናይሳኔ ኢያ ኦሱዋ ፖላናይሳ። ");
INSERT INTO gofENT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","ሂንቴ፥ ‹ኦይዱ ኣጌናፔ ጉዬ ካꬃይ ጫኬታና› ጌኬቲዬ? ሺን ታኒ ሂንቴው ኦዳይስ፤ ካꬃይ ካፂዲ ሺሾስ ጋኪዳይሳ ሎይꬂ ፄሊቴ። ");
INSERT INTO gofENT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","ዜሬይሲኔ ጫኬይሲ ኢሲፌ ኡፋይታና ሜላ ጫኬይሲ ዳሞዜ ኤኬስ ቃሲ ካꬃ ሜሪና ዴዖስ ሺሼስ። ");
INSERT INTO gofENT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","ሂዛ፥ ‹ኢሶይ ዜሬስ፤ ሃንኮይ ቃሲ ጫኬስ› ጊያ ኦዳይ ቱማ። ");
INSERT INTO gofENT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","ሂንቴ ዳቡሪቦናይሳ ሺሻና ሜላ ታኒ ሂንቴና ኪታስ። ሃራቲ ኦꬂ ዳቡሪዳሱዋን ጌሊዲ ሂንቴ ኤንታ ዳቡራ ኣይፊያ ኤኪዴታ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","ማጫሲያ፥ «ኢ፥ ታኒ ኦꬂዳ ኡባባ ኦዲስ» ጋዳ ማርካቲዳ ጊሾ ሄ ካታማን ዴዒያ ሳማሬ ኣሳፔ ዳሮቲ ዬሱሳ ኣማኒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","ሳማሬ ኣሳይ ዬሱሳኮ ዪዲ፥ ባንታ ማታን ጋምዓና ሜላ ዬሱሳ ዎሲን ኢ ያን ናምዑ ጋላስ ኡቲስ። ");
INSERT INTO gofENT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","ኢ ኦዲያ ቃላ ጊሾ ካሴይሳፌ ዳሮ ኣሳይ ኣማኒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","ቃሲ ኤንቲ ማጫሴኮ፥ «ሃዒ ኑ ኣማኔይ ኑ ሁዔን ኢ ጌይሳ ሲዒዳ ጊሾሳፌ ኣቲን ኔኒ ማርካቲዳ ጊሾሳ ጊዴና። ቃሲ ኢ ቱማ ሃ ኣላሚያ ኣሼይሳ ጊዴይሳ ኑኒ ኤሪዳ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","ናምዑ ጋላሳፔ ጉዬ፥ ዬሱሲ ያፔ ኬዪዲ ጋሊላ ቢታ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","ዬሱሲ ባ ሁዔን፥ «ናቤይ ባ ቢታን ቦንቼቴና» ያጊዲ ካሴቲዲ ኦዲስ። ");
INSERT INTO gofENT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","ዬሱሲ ጋሊላ ጋኪዳ ዎዴ ጋሊላ ኣሳይ ኢያ ሞኪዶሶና። ኣይስ ጊኮ፥ ፓሲካ ባሌ ቦንቺያ ጋላስ ኤንቲ ዬሩሳላሜን ዴዒያ ጊሾ ኢ ኦꬂዳባ ኡባ ቤዒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","ዬሱሲ ሃꬃ ዎይኔ ኡሺ ላሚዳ ቤሳ፥ ጋሊላን ዴዒያ ቃና ካታማ ቢስ። ቂፊርናሆሜን ካዎ ኬꬃን ኦꬂያ ኢሲ ሹማስ ናዓይ ሃርጌቲስ። ");
INSERT INTO gofENT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","ዬሱሲ ዪሁዳፔ ጋሊላ ዪዳይሳ ሄ ሹማይ ሲዒዲ ኢያኮ ዪስ። ሃይቃናው ማቲዳ ባ ናዓ ቢዲ ፓꬃና ሜላ ዬሱሳ ዎሲስ። ");
INSERT INTO gofENT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","ዬሱሲ ሹማኮ፥ «ፆሳይ ኦꬂያ ማላታታኔ ኦራꬃባታ ቤዖና ዴዒሼ ሂንቴ ኡባራካ ኣማኔኬታ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","ሹማይ ዛሪዲ፥ «ጎዳው፥ ታ ናዓይ ሃይቆና ዴዒሺን ታራ ዬꬋርኪ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","ዬሱሲ፥ «ኔ ሶ ባ፤ ኔ ናዓይ ፓፃና» ያጊስ። ሄ ሹማይ ዬሱሲ ጊዳይሳ ኣማኒዲ ባ ሶ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","ኢ ባ ሶ ቢሺን ኢያ ኣይሌቲ ኢያኮ ዪሼ ኢያራ ኦጌን ጋሄቲዲ፥ «ኔ ናዓይ ፓፂስ» ጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","ኢ ባ ኣይሌታ ባ ናዓስ ኣይ ሳቴን ሎዒዳኮ ኦይቺስ። ኤንቲ ዛሪዲ፥ «ዚኔ ላፑን ሳቴን ሚሻይ ኣጊስ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","ናዓ ኣዋይ ዬሱሲ ባኮ፥ «ኔ ናዓይ ፓፃና» ጊዳይ ሄ ሳቲያን ጊዴይሳ ኣኬኪስ። ሄሳ ጊሾ፥ ኢኔ ኢያ ሶ ኣሳ ኡባይ ኣማኒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","ሄሲ ዬሱሲ ዪሁዳፔ ጋሊላ ዪዲ ኦꬂዳ ናምዓንꬆ ማላታ። ");
INSERT INTO gofENT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","ሄሳፌ ጉዬ፥ ዬሱሲ ኣይሁዴቲ ቦንቺያ ባሊያስ ዬሩሳላሜ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","ዬሩሳላሜን ዶርሳ ፔንጊያ ማታን ኢብራይስፄ ዶናን ቤቴሳይዳ ጊያ ቴቄቲዳ ሃꬂ ዴዔስ። ሄ ቴቄቲ ኡቲዳ ሃꬃ ማታን ኢቻሹ ሼምፒያ ቤሳቲ ዴዖሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","ሄሳን ሃꬃይ ቃፃናይሳ ናጊያ ዳሮ ሃርጋንቾቲ፥ ቆቄቲ፥ ዎቤቲኔ ጉንዳቲ ዚንዒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","ኣይስ ጊኮ፥ ኢሲ ኢሲ ቶሆ ጎዳ ኪታንቾይ ቴቄቲዳ ሃꬃን ዎꬊዲ ሃꬃ ቃꬄስ። ሃꬃይ ቃፂያ ዎዴ ኮይሮ ጌሊዳ ኡራይ ባና ኦይኪዳ ኣይ ሃርጌፌካ ፓፄስ። ");
INSERT INTO gofENT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","ሄ ቤሳን ሃስታማኔ ሆስፑን ላይꬂ ሃርጌቲዳ ኢሲ ኣዴይ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","ዬሱሲ ያን ዚንዒዳ ኣዲያ ቤዒዲ፥ ቃሲ ዳሮ ዎዴ ሃርጌቲዳይሳ ኤሪዲ ኣዲያኮ፥ «ፓፃናው ኮያይ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","ሃርጋንቾይ ዛሪዲ፥ «ጎዳው፥ ሃꬃይ ቃፂያ ዎዴ ታና ሃꬃን ዬጊያ ኣሲ ባዋ። ታኒ ጌላና ሃኒያ ዎዴ ሃራይ ታፔ ሲንꬃቲዲ ጌሊ ኪቼስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","ዬሱሲ ኢያኮ፥ «ዴንዳ ኤቃ፤ ኔ ኣልጋ ቶካዳ ባ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","ኣዴይ ሶሁዋራካ ፓፂስ፤ ባ ኣልጋ ቶኪዲ ቢስ። ሄሲ ሳምባታ ጋላሳን ሃኒስ። ");
INSERT INTO gofENT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","ሄሳ ጊሾ፥ ኣይሁዴቲ ፓፂዳ ኣዲያኮ፥ «ሃቺ ሳዓይ ሳምባታ፤ ኔኒ ኔ ኣልጋ ቶኬይሲ ዎጋ ጊዴና» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","ሺን ኣዴይ፥ «ታና ፓꬂዳይሲ፥ ኔ ኣልጋ ቶካዳ ባ ጊስ» ያጊዲ ዛሪስ። ");
INSERT INTO gofENT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","ኤንቲ ኢያኮ፥ «ኔና፥ ኔ ኣልጋ ቶካዳ ባ ጊዳይ ኢ ኦኔ?» ያጊዲ ኦይቺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","ሺን ዬሱሲ ሄ ቤሳን ዳሮ ኣሳ ጊዶራ ኤሪሶና ካንꬂዲ ቢዳ ጊሾ ኣዴይ ባና ፓꬂዳይ ኦኔኮ ኤሬና። ");
INSERT INTO gofENT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","ዬሱሲ ጉዬፔ ሄ ኣዲያ ፆሳ ኬꬃን ዴሚዲ፥ «ሄኮ፥ ኔኒ ፓፃዳሳ፤ ሃይሳፌ ኢታባይ ኔና ጋኮና ሜላ ዛራዳ ናጋራ ኦꬆፋ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","ሄሳፌ ጉዬ፥ ኣዴይ ቢዲ ባና ፓꬂዳይሲ ዬሱሳ ጊዲዳይሳ ኣይሁዴታስ ኦዲስ። ");
INSERT INTO gofENT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","ዬሱሲ ሄሳ ሳምባታ ጋላስ ኦꬂዳ ጊሾ ኣይሁዴቲ ዬሱሳ ጎዳ ኦይኪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","ዬሱሲ ዛሪዲ፥ «ታ ኣዋይ ኡባ ዎዴ ኦꬄስ፤ ታካ ኦꬃናው ቤሴስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","ዬሱሲ ሳምባታ ቦንቾና ጊሾ ፃላላስ ጊዶናሺን ፆሳይ ባ ኣዋ ጊዲ ባና ፆሳራ ጊጊሲዳ ጊሾ ኣይሁዴቲ ኢያ ዎꬋናው ካሴፔ ሚንꬂዲ ኮዪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","ዬሱሲ ዛሪዲ፥ «ታኒ ሂንቴው ቱማ ኦዳይስ፤ ናዓይ ባርካ ኣይኮካ ኦꬃናው ዳንዳዔና። ኢ ባ ኣዋይ ኦꬂሺን ቤዖይሳ ፃላላ ኦꬄስ። ኣዋይ ኦꬄይሳ ናዓይካ ኦꬄስ። ");
INSERT INTO gofENT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","ኣዋይ ባ ናዓ ዶሲያ ጊሾ ኢ ኦꬂያ ኦሶ ኡባ ባ ናዓ ቤሴስ። ሂንቴ ማላሌታና ሜላ ኢ ሃይሳፌ ኣꬊያ ኦሶ ባ ናዓ ቤሳና። ");
INSERT INTO gofENT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","ኣዋይ ሃይቂዳይሳታ ሃይቆፔ ዴንꬂዲ ኤንታው ዴዖ ኢሜይሳዳ ናዓይካ ባ ኮዬይሳታስ ዴዖ ኢሜስ። ");
INSERT INTO gofENT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","ኣዋይ ናዓስ ፒርዳ ማታ ኡባ ኢሚስፔ ኣቲን ኢ ኦናካ ፒርዴና። ");
INSERT INTO gofENT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ኣሳይ ኡባይ ኣዋ ቦንቼይሳዳ ናዓካ ቦንቻና። ናዓ ቦንቾና ኦኒካ ናዓ ኪቲዳ ኣዋካ ቦንቼና። ");
INSERT INTO gofENT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","«ታኒ ሂንቴው ቱማ ኦዳይስ፤ ታ ቃላ ሲዔይሳሲኔ ታና ኪቲዳይሳ ኣማኔይሳስ ሜሪና ዴዖይ ዴዔስ። ኢ ሃይቆፔ ዴዖን ፒኒዳ ጊሾ ፒርዴቴና። ");
INSERT INTO gofENT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","ታኒ ሂንቴው ቱማ ኦዳይስ፤ ሃይቂዳ ኣሳይ ፆሳ ናዓ ቃላ ሲዒያ ዎዴይ ያና፤ ሄሲካ ሃዒ። ሄ ቃላ ሲዔይ ዴዖን ዳና። ");
INSERT INTO gofENT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","ኣዋይ ዴዖስ ፑልቶ ጊዲዳይሳዳ ናዓካ ዴዖስ ፑልቶ ኦꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","ናዓይ ኣሳ ናዓ ጊዲያ ጊሾ ኣዋይ ናዓስ ፒርዳ ማታ ኢሚስ። ");
INSERT INTO gofENT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","«ዱፎን ዴዔይሳቲ ኢያ ቃላ ሲዒዲ ዴንዲያ ዎዴይ ያና ጊሾ ሃይሳን ማላሌቶፊቴ። ");
INSERT INTO gofENT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ሎዖ ኦꬂዳይሳቲ ዴዖን ዳናው ቃሲ ኢታ ኦꬂዳይሳቲ ፒርዳ ኤካናው ዱፎፔ ዴንዳና። ");
INSERT INTO gofENT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","«ታኒ ታ ማታን ኣይቢባካ ኦꬃናው ዳንዳዒኬ። ፆሳይ ታው ኦዲዳይሳዳ ፒርዳይስ። ታኒ ታና ኪቲዳይሲ ኮያባ ኦꬃይሲፔ ኣቲን ታ ኮያባ ኦꬆና ጊሾ ታ ፒርዳይ ቱማ። ");
INSERT INTO gofENT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","«ታኒ ታባ ማርካቲኮ ታ ማርካቴꬃይ ቱማ ጊዴና። ");
INSERT INTO gofENT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","ታባ ማርካቲያ ሃሪ ዴዔስ፤ ኢ ታባ ማርካቴይሲ ቱማ ጊዴይሳ ታኒ ኤራይስ። ");
INSERT INTO gofENT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","«ሂንቴ ዮሃኒሳኮ ኣሴ ኪቲን ኢ ቱማስ ማርካቲስ። ");
INSERT INTO gofENT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","ታኒ ሄሳ ሂንቴው ኦዴይ፥ ሂንቴ ኣታና ሜላ ጋዳፔ ኣቲን ኣሳ ማርካቴꬂ ታው ኮሺን ጊዴና። ");
INSERT INTO gofENT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","ዮሃኒሲ ሙቃዳዳ ኤፂሼ ፖዒስ። ሂንቴ ጉꬃ ዎዴ ኢያ ፖዑዋን ኡፋይቲዴታ። ");
INSERT INTO gofENT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","«ሺን ታው ዮሃኒሳፔ ኣꬊያ ማርኪ ዴዔስ። ታኒ ኦꬃና ሜላ ታ ኣዋይ ታው ኢሚዳ ኦሶቲ ታባ ማርካቶሶና፤ ኣዋይ ታና ኪቲዳይሳ ቆንጪሶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","«ቃሲ ታና ኪቲዳ ኣዋይካ ባ ሁዔን ታባ ማርካቴስ። ሂንቴ ኢያ ቃላ ኡባራካ ሲዒቤኬታ ዎይኮ ኢያ ማላ ቤዒቤኬታ። ");
INSERT INTO gofENT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ኢ ኪቲዳይሳ ሂንቴ ኣማኖና ጊሾ ኢያ ቃላይ ሂንቴ ዎዛናን ባዋ። ");
INSERT INTO gofENT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","«ጌሻ ማፃፋታፔ ሜሪና ዴዖ ዴማናባ ሂንቴው ዳኒን ኤንታ ፒልጌታ፤ ኤንቲ ታባ ማርካቶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","ሺን ሂንቴ ዴዖ ዴማናው ታኮ ያናው ኮዬኬታ። ");
INSERT INTO gofENT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","«ኣሳፔ ታኒ ቦንቾ ኮዪኬ። ");
INSERT INTO gofENT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","ሺን ታኒ ሂንቴ ዎዛናን ፆሳ ሲቆይ ባይናይሳ ኤራይስ። ");
INSERT INTO gofENT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","ታኒ ታ ኣዋ ማታን ያስ፥ ሺን ታና ሞኪቤኬታ። ሃራይ ባ ማታን ያ ዎዴ ኢያ ሞኬታ። ");
INSERT INTO gofENT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","ሂንቴ ኢሶይ ኢሱዋፌ ቦንቾ ኮዬይሳቲ፥ ኢሲ ፆሳፌ ያ ጋላታ ኤካናው ኮዮናይሳቲ፥ ዋኒዲ ታና ኣማናናው ዳንዳዔቲ? ");
INSERT INTO gofENT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","«ታኒ ታ ኣዋ ሲንꬃን ሂንቴና ሞቲያባ ሂንቴው ዳኖፖ። ሂንቴና ሞታናይ ሂንቴ ኡፋይሳን ናጊያ ሙሴ። ");
INSERT INTO gofENT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","ሂንቴ ሙሴ ኣማኒዳባ ጊዲያኮ ኢ ታባ ፃፊዳ ጊሾ ታናካ ኣማናናሺን። ");
INSERT INTO gofENT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","ሺን ሂንቴ ኢ ፃፊዳይሳ ኣማኖና ኢፂኮ ታ ቃላ ዋቲዲ ኣማናኔ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","ሄሳፌ ጉዬ፥ ዬሱሲ ፂባርዮሳ ጊያ ጋሊላ ኣባፌ ሄፊንꬂ ፒኒስ። ");
INSERT INTO gofENT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","ኢ ሃርጋንቾታ ፓሶን ኦꬂዳ ማላታ ቤዒዳ ጊሾ ዳሮ ኣሳይ ኢያ ካሊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","ዬሱሲ ዴሪያ ቦላ ኬዪዲ፥ ያን ባ ታማሬታራ ኢሲፌ ኡቲስ። ");
INSERT INTO gofENT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","ኣይሁዴቲ ቦንቺያ ፓሲካ ባሌ ጋላሳይ ጋኪስ። ");
INSERT INTO gofENT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","ዬሱሲ ዳሮ ኣሳይ ባኮ ዬይሳ ቤዒዲ ፊልጶሳኮ፥ «ሃ ኣሳ ኡባ ሙዛናው ጊዲያ ካꬂ ኣዉፔ ሻማኔ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","ኢ ሄሳ ፊልጶሳ ፓጫናው ጊሲፔ ኣቲን ኢ ባ ሁዔን ኣይ ኦꬃኔኮ ኤሬስ። ");
INSERT INTO gofENT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","ፊልጶሲ ዛሪዲ ዬሱሳኮ፥ «ሃሪ ኣቶሺን፥ ሁዔን ሁዔን፥ ኢሲ ኢሲ ባርሲ ጋꬃናው፥ ናምዑ ፄቱ ዲናሬን ኡይꬁ ሻሚንካ ጊዴና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","ቃሲ ዬሱሳ ታማሬታፔ ኢሶይ፥ ሲሞን ጴፂሮሳ ኢሻይ ኢንዲሪያሲ፥ ");
INSERT INTO gofENT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«ኢቻሹ ባንጋ ሶሎኔ ናምዑ ሞሎ ኦይኪዳ ኢሲ ናዓይ ሃይሳን ዴዔስ፥ ሺን ሃ ኣሳ ኡባስ ሄሲ ኣይ ማዳኔ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","ዬሱሲ ባ ታማሬታኮ፥ «ኣሳ ኡቲሲቴ» ያጊስ። ሄ ቤሳን ዳሮ ማቲ ዴዔስ፤ ኣሳ ኡባይ ኡቲስ። ኣዴ ኣሳ ታይቦይ ኢቻሹ ሙኩሉ ጊዳና። ");
INSERT INTO gofENT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","ዬሱሲ ኡይꬃ ኤኪዲ ፆሳ ጋላቲ ሲሚዲ ያን ኡቲዳ ኣሳስ ጊሺስ። ሞሉዋካ ኤኪዲ ሄሳዳ ኦꬂዲ ኢሚን፥ ኣሳይ ባ ኮዪዳይሳ ሜላ ሚስ። ");
INSERT INTO gofENT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","ኤንቲ ኡባይ ካሊዳፔ ጉዬ ዬሱሲ ባ ታማሬታኮ፥ «ኢሲባይካ ኢቶና ሜላ ኣቲዳ ቲፊያ ሺሺቴ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","ሄሳ ጊሾ፥ ኤንቲ ኡባ ሺሺዶሶና። ኣሳይ ሚን ኣቲዳ ባንጋ ሶሎ ቲፊያ ሺሺዲ ታማኔ ናምዑ ጋይታ ኩንꬂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","ኣሳይ ዬሱሲ ኦꬂዳ ማላታታ ቤዒዳ ዎዴ «ሃይሲ ቱማ ሃ ኣላሚያ ያና ጌቴቲዳ ናቢያ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","ዬሱሲ ኤንቲ ኢያ ኦይኪዲ ዎልቃን ካዎ ኦꬃናው ሃኔይሳ ኤሪዲ፥ ባርካ ዴሪያ ቦላ ዛሪ ኬዪስ። ");
INSERT INTO gofENT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","ሳዓይ ኦማርሲዳ ዎዴ ዬሱሳ ታማሬቲ ኣባኮ ዎꬊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ሳዓይ ቃሚዳ ጊሾኔ ዬሱሲ ቡሮ ኤንታኮ ዪቦና ጊሾ ኢያ ታማሬቲ ዎጎሎን ጌሊዲ ኣባ ፒኒዲ ቂፊርናሆሜ ባናው ዴንዲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","ዎልቃማ ጫርኮይ ጫርኪዳ ጊሾ ኣባይ ቃፄስ። ");
INSERT INTO gofENT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","ኢቻሹ ዎይኮ ኡሱፑን ኪሎ ሚቲሬ ጊዴይሳ ሜላ ኤንቲ ኣባ ፒꬊዲ ቢዳፔ ጉዬ ዬሱሲ ኣባ ቦላራ ሃሙቲሼ ዬይሳ ቤዒዲ ያዪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","ሺን ኢ፥ «ባቦፊቴ፥ ታና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","ኤንቲ ኡፋይቲዲ ኢያ ዎጎሉዋን ጌልሲዶሶና፤ ኢራካ ዎጎሎይ ኤንቲ ቢያ ኣባ ጋፃ ጋኪስ። ");
INSERT INTO gofENT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","ዎንቴꬃ ጋላስ ኣባፌ ሄፊንꬃን ኣቲዳ ዳሮ ኣሳይ ኢሲ ዎጎሎ ፃላሊ ዴዔይሳ ቤዒዶሶና። ዬሱሲ ባ ታማሬታራ ዎጎሉዋን ጌሊዲ፥ ኤንታራ ቦናይሳኔ ኤንቲ ባንታርካ ቢዳይሳ ኣኬኪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","ሺን ፂባርዮሳፔ ሃራ ዎጎሎቲ ዬሱሲ ፆሳ ጋላቲን፥ ኣሳይ ኡይꬃ ሚዳ ቤሳ ዪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","ኣሳይ ዬሱሲ ዎይኮ ኢያ ታማሬቲ ያን ባይናይሳ ቤዒዲ፥ ዬሱሳ ኮያናው ዎጎሎታን ጌሊዲ ቂፊርናሆሜ ቢዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","ኣሳይ ዬሱሳ ኣባፌ ሄፊንꬃን ዴሚዳ ዎዴ «ኣስታማሪያው፥ ሃ ኣዉዴ ያዲ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","ዬሱሲ ዛሪዲ፥ «ታኒ ሂንቴው ቱማ ኦዳይስ፤ ሂንቴ ታና ኮዬይ ኡይꬂ ሚዲ ካሊዳ ጊሾሳፌ ኣቲን ማላታ ቤዒዳ ጊሾሳ ጊዴና። ");
INSERT INTO gofENT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","ሳሚያ ካꬃስ ኦꬆፊቴ፥ ሺን ሜሪና ዴዖ ኢሚያ ካꬃስ ኦꬂቴ። ፆሳ ኣዋይ ኢ ኦꬃና ሜላ ኢያው ማታ ኢሚዳ ጊሾ ሄ ካꬃ ኣሳ ናዓይ ሂንቴው ኢማና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","ያቲን ኤንቲ፥ «ኑኒ ፆሳ ኦሱዋ ኦꬃናው ኣይ ኦꬃኔ?» ያጊዲ ዬሱሳ ኦይቺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","ዬሱሲ ዛሪዲ፥ «ሂንቴ ኦꬃና ሜላ ፆሳይ ኮያ ኦሶይ ሃይሳ፡ ኢ ኪቲዳይሳ ኣማኒቴ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","ኤንቲ ዛሪዲ፥ «ኑኒ ቤዒዲ፥ ኔና ኣማናና ሜላ ኣይ ማላታ ኔ ቤሳኔ? ኔ ኣይ ኦꬃኔ? ");
INSERT INTO gofENT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","ጌሻ ማፃፋን፥ ‹ኤንቲ ማና ሜላ ኡይꬁ ሳሎፔ ኢሚስ› ጌቴቲ ፃፌቲዳይሳዳ ኑ ኣዋቲ ባዞ ቢታን ማና ሚዶሶና» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","ዬሱሲ፥ «ታኒ ሂንቴው ቱማ ኦዳይስ፤ ሂንቴው ሳሎፔ ቱማ ኡይꬃ ኢሚዳይ ታ ኣዋፔ ኣቲን ሙሴ ጊዴና። ");
INSERT INTO gofENT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","ሂዛ፥ ፆሳይ ኢሚያ ኡይꬃይ ሳሎፔ ዎꬊዳይሲ ኣላሚያስ ዴዖ ኢሜይሳ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","ኤንቲ ዛሪዲ፥ «ጎዳው፥ ኑስ ሄ ኡይꬃ ኡባ ዎዴ ኢማ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","ዬሱሲ፥ «ታኒ ዴዖ ኢሚያ ኡይꬃ፤ ታኮ ያ ኦኒካ ኡባራካ ኮሻቴና። ቃሲ ታና ኣማኒያ ኡራይ ኡባራካ ሳሞቴና። ");
INSERT INTO gofENT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","ሺን ታኒ ሂንቴው ኦዳስ፤ ሂንቴ ታና ቤዒዴታ፥ ሺን ኣማኔኬታ። ");
INSERT INTO gofENT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","ታ ኣዋይ ታው ኢሚያ ኡባይ ታኮ ያና፤ ቃሲ ታኮ ያ ኦናካ ካሬ ዬዲኬ። ");
INSERT INTO gofENT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","ታኒ ታ ኮያባ ኦꬃናው ጊዶናሺን ታና ኪቲዳይሲ ኮያባ ኦꬃናው ሳሎፔ ያስ። ");
INSERT INTO gofENT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","ታና ኪቲዳይሲ ኮዬይ ሃይሳ፡ ታኒ ኢ ታው ኢሚዳ ኡባታካ ዉርሴꬃ ጋላስ ሃይቆፔ ዴንꬃና ሜላፔ ኣቲን ኢሱዋካ ꬋይሳና ሜላ ኮዬና። ");
INSERT INTO gofENT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","ሂዛ፥ ታ ኣዋይ ኮዬይ ሄሳ፡ ናዓ ቤዒዲ ኣማኒያ ኡባይ ሜሪና ዴዑዋ ኤካና፤ ታኒ ሄ ኡባ ዉርሴꬃ ጋላስ ሜሪና ዴዖስ ሃይቆፔ ዴንꬃና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","ዬሱሲ፥ «ታኒ ሳሎፔ ዎꬊዳ ኡይꬃ» ጊዳ ጊሾ ኣይሁዴቲ ኢያ ቦላ ዙዙሚዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","ኤንቲ፥ «ሃይሲ ኑኒ ኢያ ኣዋኔ ኢያ ኣዪው ኤሪያ ዮሴፋ ናዓ ዬሱሳ ጊዴኔ? ያቲን፥ ኢ ዋኒዲ፥ ‹ታኒ ሳሎፔ ዎꬋስ› ጋናው ዳንዳዒ?» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","ዬሱሲ ዛሪዲ፥ «ኢሶይ ኢሱዋራ ዙዙሜይሳ ኣጊቴ። ");
INSERT INTO gofENT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","ታና ኪቲዳ ታ ኣዋይ ታኮ ኤሂያ ኣሳፔ ኣቲን ታኮ ያናው ዳንዳዒያ ኦኒካ ባዋ። ታኒ ዉርሴꬃ ጋላስ ኢያ ሜሪና ዴዖስ ሃይቆፔ ዴንꬃና። ");
INSERT INTO gofENT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","ናቤቲ፥ ‹ፆሳይ ኣሳ ኡባ ታማርሳና› ያጊዲ ፃፊዶሶና። ኣዋ ሲዔይሲኔ ኢያፔ ታማሪያ ኦኒካ ታኮ ዬስ። ");
INSERT INTO gofENT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","ፆሳ ማታፔ ዪዳይሳፌ ኣቲን ኣዋ ቤዒዳይ ኦኒካ ባዋ፤ ኢያ ፃላሊ ኣዋ ቤዒስ። ");
INSERT INTO gofENT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","«ታኒ ሂንቴው ቱማ ኦዳይስ፤ ታና ኣማኒያ ኦዴስካ ሜሪና ዴዖይ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","ታኒ ዴዖ ኢሚያ ኡይꬃ። ");
INSERT INTO gofENT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","ሂንቴ ኣዋቲ ባዞን ማና ሚዶሶና፥ ሺን ሃይቂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","ሳሎፔ ያ ኡይꬃይ ሃይሳ፤ ሄ ኡይꬃ ሚያ ኦኒካ ሃይቄና። ");
INSERT INTO gofENT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","ሳሎፔ ዪዳ ዴዖ ኡይꬃይ ታና። ኦኒካ ሃ ኡይꬃ ሚኮ ሜሪናው ዳና። ቃሲ ሃ ኣላሜይ ዴዖን ዳና ሜላ ታኒ ሂንቴው ኢማና ኡይꬃይ ታ ኣሹዋ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","ኣይሁዴቲ፥ «ሃ ኣዴይ ባ ኣሹዋ ኑ ማና ሜላ ኑስ ዋቲዲ ኢማናው ዳንዳዒ?» ያጊዲ ባንታ ጊዶን ፓላሚዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","ሄሳ ጊሾ፥ ዬሱሲ ኤንታኮ፥ «ታኒ ሂንቴው ቱማ ኦዳይስ፤ ኣሳ ናዓ ኣሹዋ፥ ሂንቴ ሞና ኢፂኮ፥ ቃሲ ኢያ ሱꬃ ሂንቴ ኡዮና ኢፂኮ፥ ሂንቴው ዴዖይ ባዋ። ");
INSERT INTO gofENT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","ታ ኣሹዋ ሚያ ኡራሲኔ ታ ሱꬃ ኡያ ኡራስ ሜሪና ዴዖይ ዴዔስ። ታኒ ዉርሴꬃ ጋላስ ኢያ ሃይቆፔ ዴንꬃና። ");
INSERT INTO gofENT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","ታ ኣሾይ ቱማ ካꬂ፤ ታ ሱꬃይካ ቱማ ኡሹ። ");
INSERT INTO gofENT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","ታ ኣሹዋ ሚያ ኡራይኔ ታ ሱꬃ ኡያ ኡራይ ታናን ዴዔስ፤ ታካ ኢያን ዴዓይስ። ");
INSERT INTO gofENT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","ዴዖ ኣዋይ ታና ኪቲን፥ ታኒ ኢያ ባጋራ ዴዖን ዴዔይሳዳ፥ ታና ሚያ ኡራይካ ታ ጋሶን ዴዖን ዳና። ");
INSERT INTO gofENT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","ሳሎፔ ዎꬊዳ ኡይꬃይ ሃይሳ፡ ሂንቴ ኣዋቲ ሚዲ ሃይቂዳ ማና ሜላ ጊዴና፤ ሃ ኡይꬃ ሚያ ኡራይ ሜሪናው ዳና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","ዬሱሲ ቂፊርናሆሜ ካታማን ኣይሁዴ ዎሳ ኬꬃን ሃይሳ ታማርሲስ። ");
INSERT INTO gofENT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","ዬሱሳ ታማሬታፔ ዳሪያ ባጋይ ሄሳ ሲዒዳ ዎዴ «ሃይሲ ጌሎና ቲሚርቴ፤ ሃይሲ ኦዴስ ጌሊ?» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","ዬሱሲ ባ ታማሬቲ ሄሳስ ዙዙሚዳይሳ ኤሪዲ፥ «ሃይሲ ሂንቴና ꬉቢ? ");
INSERT INTO gofENT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","ያቲን፥ ኣሳ ናዓይ ካሴ ዴዒያሱዋ ፑዴ ኬዪሺን ሂንቴ ቤዒዲ ዎይጋንዴቲ? ");
INSERT INTO gofENT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","ጌሻ ኣያናይ ዴዖ ኢሜስ፤ ኣሳ ዎልቂ ኣይኮካ ማዴና። ታ ሂንቴው ኦዲያ ቃላይ ዴዖ ኢሚያ ጌሻ ኣያናፔ ዬስ። ");
INSERT INTO gofENT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","ሺን ሂንቴ ጊዶን ኣማኖናይሳቲ ዴዖሶና» ያጊስ። ኣማኖናይሳቲ ኦናንቴኮ ዬሱሲ ኮይሮፔ ዶሚዲ ኤሬስ። ቃሲ ባና ኣꬂ ኢማናይ ኦኔኮ ኤሬስ። ");
INSERT INTO gofENT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","ቃሲካ ዬሱሲ፥ «ኣዋይ ባ ጎና ኦኒካ ታኮ ያናው ዳንዳዔና ጋዳ ታኒ ኦዲዳይ ሄሳ ጊሾሳ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","ሄሳ ጋሶን፥ ዬሱሳ ካሌይሳታፔ ዳሮቲ ኢያ ኣጊዲ ጉዬ ሲሚዶሶና፤ ዛሪ ኢያ ካሊቦኮና። ");
INSERT INTO gofENT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","ዬሱሲ ታማኔ ናምዑ ባ ታማሬታ፥ «ሂንቴካ ኣጊዲ ባናው ኮዬቲ?» ያጊዲ ኦይቺስ። ");
INSERT INTO gofENT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","ሲሞን ጴፂሮሲ ዛሪዲ፥ «ጎዳው፥ ኑኒ ኦዴኮ ባኔ? ኔው ሜሪና ዴዖ ኢሚያ ቃላይ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","ኔኒ ፆሳ ጌሻ ጊዴይሳ ኑኒ ኣማኖሲኔ ኤሮስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","ዬሱሲ ኤንታኮ፥ «ታኒ ሂንቴና ታማኔ ናምዓታ ዶራቢኪና? ሺን ሂንቴፌ ኢሶይ ፃላሄ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","ዬሱሲ ሄሳ ጊዳይ ሲሞና ናዓ ኣስቆሮታ ዪሁዳሳ። ዪሁዲ ዬሱሳ ኣꬂ ኢማናው ዴዒያ ታማኔ ናምዑ ታማሬታፔ ኢሱዋ። ");
INSERT INTO gofENT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","ሄሳፌ ጉዬ፥ ኣይሁዴቲ ዬሱሳ ዎꬋናው ኮያ ጊሾ ኢ ዪሁዳ ኣጊዲ ጋሊላን ሲሜሬቴስ። ");
INSERT INTO gofENT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","ኣይሁዴቲ ቦንቺያ ሻቃራ ባሌይ ቦንቼታናው ማቲስ። ");
INSERT INTO gofENT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ሄሳ ጊሾ፥ ዬሱሳ ኢሻቲ፥ «ኔ ታማሬቲ ኔኒ ኦꬂያ ማላታታ ቤዓና ሜላ ሃይሳፌ ዴንዳዳ ዪሁዳ ቢታ ባ። ");
INSERT INTO gofENT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","ባው ኤሬታናው ኮያ ኣሲ ኦኒካ ባ ኦሱዋ ጌንꬄና። ኔኒ ሃይሳታ ኦꬃዳ ኔባ ኣላሚያ ኤሪሳ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","ኢያ ኢሻቲ ሄሳ ጊዳይ ኢያን ኣማኒቦና ጊሾሳ። ");
INSERT INTO gofENT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","ዬሱሲ ኤንታኮ፥ «ታው ኢንጄ ዎዴይ ጋኪቤና፥ ሺን ሂንቴው ኡባ ዎዴይ ኢንጄቴስ። ");
INSERT INTO gofENT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","ኣላሜይ ሂንቴና ኢፃናው ዳንዳዔና፥ ሺን ታኒ ኣላሚያ ኦሶይ ኢታ ጊዴይሳ ማርካቲያ ጊሾ ታና ኢፄስ። ");
INSERT INTO gofENT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","ሂንቴ ባሊያ ቢቴ፤ ታ ዎዴይ ጋኪቦና ጊሾ ታኒ ባሊያ ቢኬ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","ኢ ሄሳ ጊዲ ጋሊላን ኣቲስ። ");
INSERT INTO gofENT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","ኢያ ኢሻቲ ባሊያ ቦንቻናው ቢዳፔ ጉዬ ዬሱሲ ኦናካ ኤሪሶና ቆሳን ሄ ቤሳ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","ኣይሁዴቲ ባሊያ ቦንቺያ ቤሳን፥ «ኢ ኣዉን ዴዒ?» ያጊዲ ኢያ ኮዪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","ኣሳይ ካልካሺዲ ኢያባ ኦዴቶሶና። ባጋይ፥ «ኢ ሎዖ ኣሲ» ጊያ ዎዴ ሃራቲ ቃሲ፥ «ኣካይ፥ ኢ ኣሳ ባሌꬄስ» ያጎሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","ሺን ኣይሁዴ ሃላቃታስ ያዪዳ ጊሾ ኦኒካ ኢያባ ቆንጬን ኦዴቴና። ");
INSERT INTO gofENT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","ባሊያ ቦንቺዲ ጊዶ ጋꬂያ ዎዴ ዬሱሲ ፆሳ ኬꬂ ቢዲ ታማርሶ ኦይኪስ። ");
INSERT INTO gofENT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","ኣይሁዴቲ፥ «ሃ ኣዴይ ቲሚርቴ ታማሮና ሃይሳ ኡባ ዋቲ ኤሪዴ?» ያጊዲ ማላሌቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","ዬሱሲ ዛሪዲ፥ «ታ ታማርሲያ ቲሚርቴይ ታና ኪቲዳ ፆሳ ማታፔ ያ ቲሚርቴፌ ኣቲን ታባ ጊዴና። ");
INSERT INTO gofENT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","ፆሳ ሼኒያ ኦꬃናው ኮያ ኦኒካ ሃ ቲሚርቴይ ፆሳ ማታፔ ዪያኮኔ ዎይኮ ታኒ ታፔ ኦዲያኮ ኤራና። ");
INSERT INTO gofENT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","ባባ ኦዲያ ኦኒካ ባ ሁዔ ቦንቾ ኮዬስ። ሺን ባና ኪቲዳይሳ ቦንቹዋ ኮያ ኦኒካ ኢ ቱማንቾ፤ ኢያን ዎርዶይ ባዋ። ");
INSERT INTO gofENT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","ሙሴይ ሂንቴው ሂጊያ ኢሚስ፥ ሺን ሂንቴፌ ኦኒካ ሂጊያ ናጊቤና። ያቲን ኣይስ ታና ዎꬋናው ኮዬቲ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","ኣሳይ ዛሪዲ፥ «ኔና ፃላሄይ ኦይኪስ፤ ኔና ዎꬋናው ኦኔ ኮዬይ?» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","ዬሱሲ፥ «ታኒ ኢሲ ማላታ ኦꬂን ሂንቴ ኡባይ ማላሌቲዴታ። ");
INSERT INTO gofENT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","ሂንቴ፥ ሂንቴ ናይታ ቃፃራና ሜላ ሙሴይ ኪቲስ። ሺን ቃፃሮ ሂንቴ ማይዛቲ ዶሚዶሶናፔ ኣቲን ሙሴ ጊዴና። ሄሳ ጊሾ፥ ሂንቴ ሳምባታ ጋላስ ኣዴ ናይታ ቃፃሬታ። ");
INSERT INTO gofENT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","ሙሴ ሂጌይ ኪቲዳ ጊሾ ሂንቴ ሳምባታ ጋላስ ቃፃሪያባ ጊዲኮ፥ ታኒ ኢሲ ኣሳ ኩሜꬃ ኣሳቴꬃ ፓꬂዳ ጊሾ ታራ ኣይስ ካጬቲ? ");
INSERT INTO gofENT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","ቱማ ፒርዳ ፒርዲቴፔ ኣቲን ኣሳ ሶምዖ ቤዒዲ ፒርዶፊቴ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","ዬሩሳላሜ ኣሳፔ ኢሶቲ ኢሶቲ፥ «ኤንቲ ዎꬋናው ኮያ ኡራይ ሃይሳ ጊዴኔ? ");
INSERT INTO gofENT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","ሄኮ፥ ኢ ቆንጬን ኦዴስ፤ ኤንቲ ኢያ ኣይኮካ ጎኮና። ኢ ኪሪስቶሳ ጊዴይሳ ኣይሁዴ ሃላቃቲ ቱማ ኤሪዶናሻ? ");
INSERT INTO gofENT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","ኪሪስቶሲ ያ ዎዴ ኢ ኣዉፔ ያኮ ኦኒካ ኤሬና፥ ሺን ኢ ኣዉፔ ዪዳኮ ኑ ኤሮስ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","ዬሱሲ ፆሳ ኬꬃን ታማርሲሼ ባ ቃላ ꬎቁ ኦꬂዲ፥ «ቱማ ሂንቴ ታኒ ኦኔኮኔ ታ ኣዉፔ ዪዳኮ ኤሬቲ? ታኒ ታ ማታን ያቢኬ፥ ሺን ታና ኪቲዳይሲ ቱማንቾ፤ ሂንቴ ኢያ ኤሬኬታ። ");
INSERT INTO gofENT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","ሺን ታኒ ኢ ኪቲን ኢያ ማታፔ ዪዳ ጊሾ ኢያ ኤራይስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","ሄሳ ጊሾ፥ ኤንቲ ኢያ ኦይካናው ኮዪዶሶና። ሺን ኢያ ዎዴይ ቡሮ ጋኪቦና ጊሾ ኦኒካ ኢያ ቦላ ኩሼ ዎꬂቤና። ");
INSERT INTO gofENT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","ሺን ዳሮ ኣሳይ ዬሱሳ ኣማኒዲ፥ «ኪሪስቶሲ ያ ዎዴ ሃ ኡራይ ኦꬂዳ ማላታታፔ ዳሪያ ማላታ ኦꬃኔዬ?» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","ፋሪሳዌቲ ዳሮ ኣሳይ ዬሱሳባ ካልካሼይሳ ሲዒዶሶና። ካሂኔ ሃላቃቲኔ ፋሪሳዌቲ ኢያ ኦይꬂዲ ቃሺሳናው ፆሳ ኬꬂ ናጌይሳታ ኪቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","ዬሱሲ፥ «ታኒ ሂንቴራ ጉꬃ ዎዴ ጋምዓና፤ ሄሳፌ ጉዬ ታና ኪቲዳይሳኮ ባና። ");
INSERT INTO gofENT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","ሂንቴ ታና ኮያና፥ ሺን ዴሜኬታ። ታኒ ዴዒያሱዋ ሂንቴ ያናው ዳንዳዔኬታ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","ኣይሁዴቲ ኢሶይ ኢሱዋራ፥ «ሃይሲ ኑኒ ዴሞናሶ ኣው ባና ሃኒ? ጊሪኬ ካታማን ዴዒያ ኣይሁዴታኮ ቢዲ ጊሪኬታ ታማርሳናው ሃኒዬ? ");
INSERT INTO gofENT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","‹ሂንቴ ታና ኮያና፥ ሺን ዴሜኬታ› ቃሲ፥ ‹ታኒ ዴዒያሱዋ ሂንቴ ያናው ዳንዳዔኬታ› ጉሳይ ኣይ ጉሴ?» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","ባሊያ ቦንቺያ ጋላሳታፔ ዎልቃማኔ ዉርሴꬃ ጋላሳን ዬሱሲ ዴንዲዲ፥ ባ ቃላ ꬎቁ ኦꬂዲ፥ «ሳሞቲዳ ኦኒካ ታኮ ዪዲ ኡዮ። ");
INSERT INTO gofENT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","ታና ኣማኒያ ኦኒካ ጌሻ ማፃፋይ ጊዳይሳዳ ዴዖ ኢሚያ ፑልቶ ሃꬃይ ኢያፔ ጎጋና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","ኢ ሄሳ ጊዳይ ኢያ ኣማኒዳይሳቲ ኤካናው ዴዒያ ጌሻ ኣያናባ። ዬሱሲ ቡሮ ቦንቼቲቦና ጊሾ ሄ ዎዴ ጌሻ ኣያናይ ኢሜቲቤና። ");
INSERT INTO gofENT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","ሄ ኣሳፔ ዳሮቲ ኢ ጌይሳ ሲዒዲ፥ «ቱማ ሃይሲ ናቢያ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","ሃራቲ ቃሲ፥ «ሃይሲ ኪሪስቶሳ» ያጊዶሶና። ሺን ሃራቲ ቃሲ፥ «ኪሪስቶሲ ጋሊላፔ ዋኒዲ ኬዪ? ");
INSERT INTO gofENT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","ጌሻ ማፃፋይ፥ ‹ኪሪስቶሲ ዳዊቴ ሼሻፔ ዳዊቴይ ዴዒዳ ቤቴሌሜ ካታማፔ ያና› ያጌኔዬ?» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","ሄሳ ጊሾ፥ ዬሱሳ ጋሶን ኣሳይ ባንታ ጊዶን ሻኬቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","ሄ ኣሳፔ ኢሶቲ ኢሶቲ ኢያ ኦይካናው ኮዪዶሶና፥ ሺን ኦኒካ ኢያ ቦላ ኩሼ ዎꬂቤና። ");
INSERT INTO gofENT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","ፆሳ ኬꬃ ናጌይሳቲ ካሂኔ ሃላቃታኮኔ ፋሪሳዌታኮ ጉዬ ሲሚ ዪን ኤንቲ፥ «ኣይስ ኢያ ኤሂቤኬቲ?» ያጊዲ ኦይቺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","ፆሳ ኬꬃ ናጌይሳቲ ኤንታኮ፥ «ሃ ኣዴይ ኦዴቴይሳꬆ ኦኒካ ኦዴቴና» ያጊዲ ዛሪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","ፋሪሳዌቲ ዛሪዲ፥ «ኢ ሂንቴናካ ባሌꬂዴ? ");
INSERT INTO gofENT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","ኣይሁዴ ሃላቃታፔ ዎይኮ ፋሪሳዌቴፔ ኢያ ኣማኒዳ ኣሲ ዴዒ? ");
INSERT INTO gofENT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","ሙሴ ሂጊያ ኤሮና ሃ ኣሳይ ቃንጌቲዳባ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","ፋሪሳዌታፔ ኢሶይ ቃማ ዬሱሳኮ ቢዳ ኒቆዲሞሲ ኤንታኮ፥ ");
INSERT INTO gofENT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","«ኢሲ ኣሲ ጊያባ ሲዖና ዎይኮ ኢ ኣይ ኦꬂዳኮ ኤሮና ዴዒሼ ኮይሮቲዲ ኢያ ቦላ ፒርዴይሲ ኑ ሂጊያን ዴዒ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","ኤንቲ ዛሪዲ፥ «ኔኒካ ቃሲ ጋሊላ ቢታ ኣሴ? ጋሊላ ቢታፌ ናቤይ ኬዮናይሳ ጌሻ ማፃፋፔ ፒልጋዳ ዴማ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","ኢሶይ ኢሶይ ኣጊዲ ባ ሶ ባ ሶ ቢስ፥ ሺን ዬሱሲ ሻማሆ ዴሪያ ቦላ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","ቃሲ ዎንቴꬃ ጋላስ ጉራ ፆሳ ኬꬂ ሲሚስ። ዳሮ ኣሳይ ኢያኮ ዪን ኡቲዲ ኤንታ ታማርሲስ። ");
INSERT INTO gofENT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","ሂጌ ኣስታማሬቲኔ ፋሪሳዌቲ ላይማቲሺን ኦይኪዳ ኢሲ ማጫሲው ኢያኮ ኤሂዶሶና። ኤንቲ ኣሳ ኡባ ሲንꬃን ኢዮ ኤሲዲ፥ ");
INSERT INTO gofENT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","«ኣስታማሪያው፥ ሃ ማጫሲያ ላይማቲሺን ኑ ኦይኪዳ። ");
INSERT INTO gofENT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","ሙሴ ሂጌይ ሃኒ ሜላ ማጫስ ሹቻን ጫዴታ ሃይቃና ሜላ ኪቴስ። ያቲን፥ ኔኒ ዎይጋይ?» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","ኤንቲ ሄሳ ጊዳይ ዬሱሳ ፓጪዲ ኢያ ሞቲያባ ዴማናሳ። ሺን ዬሱሲ ሆኪዲ ባ ቢራꬌን ቢታ ቦላ ፃፊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","ኤንቲ ኢያ ዛሪ ዛሪ ኦይቺዲ ኣጎና ኢፂን፥ ፑዴ ꬎቁ ጊዲ፥ «ሂንቴ ጊዶን ናጋራ ኦꬂቦና ኣሲ ኮይሮቲዲ ኢዮ ሹቻን ጫዶ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","ቃሲካ ሆኪዲ ቢታ ቦላ ፃፊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","ኤንቲ ሄሳ ሲዒዳ ዎዴ ጪማታፔ ዶሚዲ ኢሶይ ኢሶይ ኬዪሼ ዉሪዶሶና። ዬሱሳ ፃላሊ ሄ ቤሳን ኤቂዳ ማጫሴራ ኣቲስ። ");
INSERT INTO gofENT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","ኢ ፑዴ ꬎቁ ጊዲ ማጫሴኮ፥ «ማጫሴቴ፥ ኣሳቲ ኣው ቢዶና? ኔ ቦላ ፒርዲዳይ ኦኒካ ባዌ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","ማጫሲያ፥ «ጎዳው፥ ኦኒካ ባዋ» ያጋሱ። ዬሱሲ ዛሪዲ፥ «ታኒካ ኔ ቦላ ፒርዲኬ። ባ፤ ዛራዳ ናጋራ ኦꬆፋ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","ቃሲካ ዬሱሲ ኣሳኮ፥ «ታኒ ኣላሚያስ ፖዖ። ታና ካሊያ ኦኒካ ዴዖ ኢሚያ ፖዑዋ ኤካናፔ ኣቲን ꬉማን ሲሜሬቴና» ያጊዲ ኦዲስ። ");
INSERT INTO gofENT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","ፋሪሳዌቲ፥ «ኔ ኔባ ማርካታሳ፥ ሺን ኔ ማርካቴꬃይ ቱማ ጊዴና» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","ዬሱሲ ዛሪዲ፥ «ታኒ ታባ ማርካቲኮካ ታ ማርካቴꬃይ ቱማ። ኣይስ ጊኮ፥ ታኒ ኣዉፔ ዪዳኮ ቃሲ ኣው ቢያኮ ኤራይስ፥ ሺን ሂንቴ ኤሬኬታ። ");
INSERT INTO gofENT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","ሂንቴ ኣሳ ቆፋን ፒርዴታ፤ ታኒ ኢሲ ኣሳ ቦላካ ፒርዲኬ። ");
INSERT INTO gofENT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","ታኒ ፒርዲያባ ጊዲኮካ ታ ፒርዳይ ቱማ። ኣይስ ጊኮ፥ ታና ኪቲዳ ታ ኣዋይ ታራ ዴዔሲፔ ኣቲን ታኒ ታርካ ዴዒኬ። ");
INSERT INTO gofENT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","ናምዑ ኣሳ ማርካቴꬂ ቱማ ጊዴይሲ ሂንቴ ሂጊያን ፃፌቲስ። ");
INSERT INTO gofENT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","ታኒ ታባ ታ ሁዔን ማርካታይስ፤ ቃሲ ታና ኪቲዳ ታ ኣዋይካ ታባ ማርካቴስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","ኤንቲ፥ «ኔ ኣዋይ ኣዉን ዴዒ?» ያጊዲ ኢያ ኦይቺዶሶና። ዬሱሲ ዛሪዲ፥ «ሂንቴ ታና ዎይኮ ታ ኣዋ ኤሬኬታ። ታና ኤሪዳባ ጊዲያኮ፥ ሂንቴ ታ ኣዋካ ኤራናሺን» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","ዬሱሲ ፆሳ ኬꬃን ሙፃታ ሚሺያ ዬጊያ ሳፂኔይ ዴዒያ ቤሳን ሄሳ ታማርሲስ። ኢያ ቃማይ ቡሮ ጋኪቦና ጊሾ ኦኒካ ኢያ ኦይኪቤና። ");
INSERT INTO gofENT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","ቃሲካ ዬሱሲ ኤንታኮ፥ «ታኒ ባና፤ ሂንቴ ታና ኮያና፥ ሺን ሂንቴ ኣቶቴꬂ ዴሞና ሂንቴ ናጋራን ሃይቃና። ታኒ ቢያሱዋ ባናው ሂንቴ ዳንዳዔኬታ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","ኣይሁዴ ሃላቃቲ፥ «ኢ፥ ‹ታኒ ቢያሱዋ ሂንቴ ባናው ዳንዳዔኬታ› ያጌስ። ኢ ባና ባርካ ዎꬋኔዬ?» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","ዬሱሲ ዛሪዲ፥ «ሂንቴ ጋርሳፌ፤ ታኒ ቦላፌ። ሂንቴ ሃ ኣላሚያፔ፥ ታኒ ሃ ኣላሚያፔ ጊዲኬ። ");
INSERT INTO gofENT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","ሂንቴ ኣቶቴꬂ ዴሞና ሂንቴ ናጋራን ሃይቃና ጋዳ ታኒ ሂንቴው ኦዲዳይ ሄሳሳ። ታኒ ታና ጊዴይሳ ሂንቴ ኣማኖና ኢፂኮ ሂንቴ ኣቶቴꬂ ዴሞና ሂንቴ ናጋራን ሃይቃና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","ኤንቲ፥ «ኔኒ ኦኔ?» ያጊዲ ኦይቺዶሶና። ዬሱሲ ዛሪዲ፥ «ታኒ፥ ኮይሮፔ ሂንቴው ኦዲዳ ታና። ");
INSERT INTO gofENT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","ታኒ ሂንቴባ ኦዳዳ ፒርዲያባይ ዳሮባይ ዴዔስ። ሺን ታና ኪቲዳይሲ ቱማንቾ፤ ቃሲ ታኒ ኢያፔ ሲዒዳይሳ ፃላላ ኣላሚያስ ኦዳይስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","ዬሱሲ ባ ኣዋባ ኦዴይሳ ኤንቲ ኣኬኪቦኮና። ");
INSERT INTO gofENT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","ሄሳ ጊሾ፥ ዬሱሲ ኤንታኮ፥ «ሂንቴ ኣሳ ናዓ ፑዴ ꬎቁ ኦꬂያ ዎዴ ታኒ ታና ጊዴይሳ ሂንቴ ኤራና። ቃሲካ ታኒ ታ ማታን ኣይኮካ ኦꬆናይሳኔ ታ ኣዋይ ታና ታማርሲዳይሳ ኦዴይሳ ሂንቴ ኤራና። ");
INSERT INTO gofENT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","ታና ኪቲዳይሲ ታራ ዴዔስ። ታኒ ኡባ ዎዴ ኢያ ኡፋይሲያባ ኦꬂያ ጊሾ ኢ ታና ታ ፃላላ ኣጊቤና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","ዬሱሲ ሄሳ ኦዲሺን ሲዒዳ ዳሮ ኣሳይ ኢያ ኣማኒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","ዬሱሲ ባና ኣማኒዳ ኣሳታኮ፥ «ሂንቴ ታ ቲሚርቲያስ ኪቴቲኮ ቱማ ታና ካሌይሳታ። ");
INSERT INTO gofENT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","ሂንቴ ቱማ ኤራና፤ ቱማይካ ሂንቴና ኣይሌቴꬃፌ ኬሳና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","ኤንቲ ዛሪዲ፥ «ኑኒ ኣብራሃሜ ሼሺ፤ ኑኒ ኦዴስካ ኣይሌቲቦኮ። ኔኒ ዎይጋዳ፥ ‹ሂንቴ ኣይሌቴꬃፌ ኬያና› ጋይ?» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","ዬሱሲ ዛሪዲ፥ «ታኒ ሂንቴው ቱማ ኦዳይስ፤ ናጋራ ኦꬂያ ኦኒካ ናጋራ ኣይሌ። ");
INSERT INTO gofENT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","ኣይሌይ ሜሪናው ሶ ኣሳራ ዴና፥ ሺን ናዓይ ሜሪናው ሶ ኣሳራ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","ናዓይ ሂንቴና ኣይሌቴꬃፌ ኬሲኮ ሂንቴ ኣይሌቴꬃፌ ቱማ ኬያና። ");
INSERT INTO gofENT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","ሂንቴ ኣብራሃሜ ሼሺ ጊዴይሳ ታኒ ኤራይስ። ሺን ታ ቃላይ ሂንቴ ዎዛናን ባይና ጊሾ ታና ዎꬋናው ኮዬታ። ");
INSERT INTO gofENT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","ታኒ ታ ኣዋይ ታና ቤሲዳይሳ ኦዳይስ፥ ሺን ሂንቴካ ሂንቴ ኣዋፔ ሲዒዳይሳ ኦꬄታ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","ኤንቲ ዛሪዲ፥ «ኑ ኣዋይ ኣብራሃሜ» ያጊዶሶና። ዬሱሲ ኤንታኮ፥ «ሂንቴ ኣብራሃሜ ናይታ ጊዲያኮ ኢ ኦꬂዳይሳ ኦꬃና። ");
INSERT INTO gofENT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","ሺን ፆሳፌ ሲዒዳ ቱማ ኦዲዳ ታና ሂንቴ ዎꬋናው ኮዬታ። ኣብራሃሜይ ሄሳዳ ኦꬂቤና። ");
INSERT INTO gofENT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","ሂንቴ፥ ሂንቴ ኣዋይ ኦꬂዳይሳ ኦꬄታ» ያጊስ። ኤንቲ ዛሪዲ፥ «ኑኒ ቱማ ፆሳ ናይታ፤ ኑስ ኢሲ ኣዋይ ፆሳ ፃላሊ ዴዔስ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","ዬሱሲ ኤንታኮ፥ «ፆሳይ ቱማ ሂንቴ ኣዋ ጊዲያኮ ሂንቴ ታና ዶሳና፤ ኣይስ ጊኮ፥ ታኒ ፆሳ ማታፔ ያዳ ሃይሳን ዴዓይስ። ታና ኢ ኪቲስፔ ኣቲን ታኒ ታ ማታን ያቢኬ። ");
INSERT INTO gofENT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","ታኒ ጌይሳ ሂንቴ ሲዓናው ኮዮና ጊሾ ታ ጊያባይ ሂንቴው ጌሌና። ");
INSERT INTO gofENT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","ሂንቴ፥ ሂንቴ ኣዋ ፃላሄ ናይታ። ቃሲ ሂንቴ፥ ሂንቴ ኣዋይ ኣሞቲያባ ኦꬃናው ኮዬታ። ኢ ኮይሮፔ ዶሚዲ ሼምፖ ዎꬌይሳ። ቱሚ ኢያን ባይና ጊሾ ኢ ቱማ ኢፄስ። ዎርዶይ ኢያው ሜꬎ ጊዲዳ ጊሾኔ ኢ ዎርዶ ኣዋ ጊዲያ ጊሾ ዎርዶ ኦዴቲሼ ባፔ ኦዴቴስ። ");
INSERT INTO gofENT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","ታኒ ቱማ ሃሳያይስ፥ ሺን ሂንቴ ታና ኣማኔኬታ። ");
INSERT INTO gofENT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","ሂንቴፌ፥ ‹ኔኒ ናጋራ ኦꬂሺን ታ ቤዓስ› ጋናው ዳንዳዔይ ኦኔ? ታኒ ቱማ ኦዴቲያባ ጊዲኮ ታና ኣይስ ኣማኔኬቲ? ");
INSERT INTO gofENT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","ፆሳ ኣሲ ፆሳይ ጊያባ ሲዔስ። ሂንቴ ፆሳ ኣሲ ጊዶና ጊሾ ፆሳይ ጊያባ ሲዔኬታ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","ኣይሁዴቲ ዛሪዲ፥ « ‹ኔኒ ሳማሬ ኣሲ፤ ኔናን ቱና ኣያናይ ዴዔስ› ጊሼ ሊኬ ጊዶኮ?» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","ዬሱሲ ኤንታኮ «ታ ቦላ ቱና ኣያኒ ባዋ። ታኒ ታ ኣዋ ቦንቻይስ፥ ሺን ሂንቴ ታና ካዉሼታ። ");
INSERT INTO gofENT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","ታኒ ታ ሁዔ ቦንቾ ኮዪኬ፤ ታኒ ቦንቼታና ሜላ ኮዬይሲኔ ታው ፒርዴይሲ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","ታኒ ሂንቴው ቱማ ኦዳይስ፤ ታ ቃላ ናጊያ ኦኒካ ሃይቄና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","ኣይሁዴቲ ዛሪዲ፥ «ኔ ቦላ ቱና ኣያናይ ዴዔይሳ ኑኒ ሃዒ ኤሪዳ። ኣብራሃሜይ ሃይቂስ፤ ናቤቲካ ሃይቂዶሶና። ሺን ኔኒ፥ ‹ታ ቃላ ናጊያ ኦኒካ ሃይቄና› ያጋሳ። ");
INSERT INTO gofENT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","ኔኒ ሃይቂዳ ኑ ኣዋ ኣብራሃሜፔ ኣꬋዬ? ናቤቲካ ቃሲ ሃይቂዶሶና። ኔኒ ኔና ኦና ጋዳ ቆፓይ?» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","ዬሱሲ፥ «ታኒ ታና ቦንቺኮ ታ ቦንቾይ ሃዳ። ሂንቴ፥ ‹ኑ ፆሳ› ጊያ ታ ኣዋይ ኢ ታና ቦንቼስ። ");
INSERT INTO gofENT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","ሂንቴ ኢያ ኤሮና ኢፂኮ ታኒ ኢያ ኤራይስ። ታኒ ኢያ ኤሪኬ ጊኮ ሂንቴ ሜላ ዎርዶታይስ። ሺን ታኒ ኢያ ኤራይስ፤ ቃሲ ኢያ ቃላካ ናጋይስ። ");
INSERT INTO gofENT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","ሂንቴ ኣዋይ ኣብራሃሜይ ታ ዩሳ ጋላሳ ቤዒዲ ኡፋይታናው ኣሞቲስ፤ ቤዒዲካ ኡፋይቲስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","ኣይሁዴቲ ዛሪዲ፥ «ሃሪ ኣቶሺን፥ ኔው ኢሻታሙ ላይꬂ ኩሚቤናሺን ዋናዳ ኣብራሃሜ ቤዓስ ጋይ?» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","ዬሱሲ ኤንታኮ፥ «ታኒ ሂንቴው ቱማ ኦዳይስ፤ ኣብራሃሜይ ዬሌታናፔ ካሴ ታኒ ታና » ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","ሄሳ ጊሾ፥ ኤንቲ ዬሱሳ ጫዳናው ሹቺ ኤኪዶሶና። ሺን ዬሱሲ ኤንታፌ ጌሚዲ ፆሳ ኬꬃፌ ኬዪዲ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","ዬሱሲ ቢሼ ዬሌቶሳፔ ቆቄ ጊዲዲ ዴዒያ ኢሲ ኣዲያ ቤዒስ። ");
INSERT INTO gofENT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","ኢያ ታማሬቲ፥ «ኣስታማሪያው፥ ሃ ኣዴይ ቆቄ ጊዲዲ ዬሌታና ሜላ ናጋራ ኦꬂዳይ ኦኔ? ኢ ኦꬂዴዬ ዎይኮ ኢያ ዬሊዳይሳቲ ኦꬂዶና?» ያጊዲ ኦይቺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","ዬሱሲ፥ «ፆሳ ኦሶይ ኢያ ቦላ ቆንጫና ሜላፔ ኣቲን ኢ ዎይኮ ኢያ ዬሊዳይሳቲ ናጋራ ኦꬂዳ ጊሾ ጊዴና። ");
INSERT INTO gofENT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","ሳዒ ጋላስ ዴዒሺን ታና ኪቲዳይሳ ኦሱዋ ኑ ኦꬃናው ቤሴስ። ኦኒካ ኦꬃናው ዳንዳዖና ቃማይ ዬስ። ");
INSERT INTO gofENT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","ታኒ ኣላሚያን ዴዓሼ ኣላሚያስ ፖዖ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","ዬሱሲ ሄሳ ጊዲ ሳዓን ጩቲስ። ባ ጩቻን ጉꬃ ቢታ ላኮꬂዲ ሄ ኡርቃን ቆቄ ኣዲያ ኣይፊያ ቲዪስ። ");
INSERT INTO gofENT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ያቲዲ፥ «ባዳ ሳሊሆሜ (ሳሊሆሜ ጉሳይ ኪቴቲዳይሳ ጉሱ) ጊያ ቴቄቲዳ ሃꬃን ኔ ኣይፊያ ሜጬታ» ያጊስ። ሄሳ ጊሾ፥ ኣዴይ ቢዲ ባ ኣይፊያ ሜጬቲዲ ፄሊሼ ሲሚስ። ");
INSERT INTO gofENT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","ኣዲያ ሾሮቲኔ ኣዴይ ካሴ ዎሲሺን ቤዒዳ ኣሳይ፥ «ሃይሲ ኡቲዲ ዎሲያ ኣዲያ ጊዴኔዬ?» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","ኢሲ ኢሲ ኣሳይ፥ «ሃይሲ ኢያ» ያጊዶሶና። ሃራቲ ቃሲ፥ «ኣካይ፥ ሃይሲ ኢያ ዳኔሲፔ ኣቲን ኢያ ጊዴና» ያጊዶሶና። ሺን ኣዴይ፥ «ኤ፥ ታና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","ኤንቲ ኢያኮ፥ «ያቲን ኔ ኣይፌይ ዋኒዲ ፄሊዴ?» ያጊዲ ኦይቺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","ኢ ዛሪዲ፥ «ዬሱሳ ጊያ ኣዴይ ጉꬃ ኡርቃ ላኮꬂዲ ታ ኣይፊያ ቲዪዲ፥ ‹ሳሊሆሜ ባዳ ኔ ኣይፊያ ሜጬታ› ያጊን፥ ታኒ ባዳ ሜጬታዳ ፄላ ኣጋስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","ኤንቲ ኢያኮ፥ «ኢ ኣዉን ዴዒ?» ያጊዲ ኦይቺዶሶና። ኣዴይ፥ «ታኒ ኤሪኬ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","ኤንቲ ካሴ ቆቄ፥ ሺን ሃዒ ፄሊዳ ኣዲያ ፋሪሳዌታኮ ኤፊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","ዬሱሲ ኡርቃ ላኮꬂዲ ኣዲያ ኣይፊያ ፓꬂዳ ጋላሳይ ሳምባታ ጋላስ። ");
INSERT INTO gofENT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","ሄሳ ጊሾ፥ ኣዴይ ዋኒዲ ፄሊዳኮ ፋሪሳዌቲ ኢያ ዛሪ ኦይቺዶሶና። ኣዴይ ኤንታኮ፥ «ኢ ታ ኣይፊያን ጉꬃ ኡርቃ ቲዪስ። ታ ኣይፊያ ሜጬታዳ ሃዒ ፄላይስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","ፋሪሳዌታፔ ኢሶቲ ኢሶቲ፥ «ሃይሳ ኦꬂዳ ኣዴይ ሳምባታ ሂጊያ ናጎና ጊሾ ፆሳ ማታፔ ዪቤና» ያጊዶሶና። ሺን ሃራቲ፥ «ናጋራንቾ ኣሲ ሃይሳ ሜላ ማላታ ዋቲ ኦꬃናው ዳንዳዒ?» ያጊዲ ባንታ ጊዶን ሻኬቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","ሄሳ ጊሾ፥ ፋሪሳዌቲ ኣዲያኮ፥ «ኢ ኔ ኣይፊያ ፄሊሲዳ ጊሾ ኔ ኢያባ ዎይጋይ?» ያጊዶሶና። ኣዴይ፥ «ኢ ናቤ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","ኣይሁዴ ሃላቃቲ፥ ኢያ ኣዪዉኔ ኣዋ ፄጊዲ ኦይቻና ጋካናው፥ ኣዴይ ካሴ ቆቄ ጊዲዳይሳኔ ሃዒ ኢ ፄሌይሳ ኣማኒቦኮና። ");
INSERT INTO gofENT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ኤንቲ ኢያ ኣዪዉኔ ኢያ ኣዋኮ፥ «ሂንቴ ‹ቆቄ ጊዲዲ ዬሌቲስ› ጊያ ሂንቴ ናዓይ ሃይሴ? ያቲን፥ ሃዒ ዋኒዲ ፄሊዴ?» ያጊዲ ኦይቺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","ኢያ ዬሊዳይሳቲ፥ «ሃይሲ ኑ ናዓ ጊዲዳይሳኔ ቆቄ ጊዲዲ ኢ ዬሌቲዳይሳ ኑ ኤሮስ። ");
INSERT INTO gofENT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","ሺን ሃዒ ኢ ዋኒዲ ፄሊዳኮ ቃሲ ኢያ ኣይፊያ ኦኒ ፓꬂዳኮ ኑኒ ኤሮኮ። ኢያ ኦይቺቴ። ኢ ባና ኤሪዳ ኣሲ ጊዲያ ጊሾ ባባ ኦዳናው ዳንዳዔስ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","ኢያ ዬሊዳይሳቲ ሄሳ ጊዳይ ኣይሁዴታስ ያዪዳ ጊሾሳ። ኣይስ ጊኮ፥ ኣይሁዴቲ፥ ዬሱሲ ኢ ኪሪስቶሳ ያጊዲ ማርካቲያ ኣሲ ዴዒኮ ሄ ኡራ ኣይሁዴ ዎሳ ኬꬃፌ ሂላናው ኮይሮቲዲ ዞሬ ቃቺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","ኢያ ዬሊዳይሳቲ፥ «ኢ ባና ኤሪዳ ኣሲ፤ ኢያ ኦይቺቴ» ያጊዳይ ሄሳሳ። ");
INSERT INTO gofENT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","ሄሳ ጊሾ፥ ቆቄ ጊዲዲ ዬሌቲዳ ኣዲያ ኤንቲ ዛሪ ፄጊዲ፥ «ቱማ ኦዳናው ፆሳን ጫቃ፤ ሃ ኣዴይ ናጋራንቾ ጊዴይሳ ኑ ኤሮስ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","ኣዴይ ዛሪዲ፥ «ኢ ናጋራንቾ ጊዲን፥ ጊዶና ኢፂን ታ ኤሪኬ። ታኒ ቆቄ ጊዴይሳኔ ሃዒ ፄሌይሳ ሄ ኢሲባ ኤራይስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","ኤንቲ ዛሪዲ፥ «ኢ ኔው ኣይ ኦꬂዴ? ኢ ኔ ኣይፊያ ዋቲ ፓꬂዴ?» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","ኢ ኤንታኮ፥ «ታኒ ሂንቴው ኦዳስ፥ ሺን ሲዒቤኬታ። ኣይስ ዛሪ ሲዓናው ኮዬቲ? ሂንቴካ ኢያ ታማሬ ጊዳናው ኮዬቲዬ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","ኤንቲ ኢያ ጫዪዲ፥ «ኔ ሄ ኡራ ታማሬ ጊዳ፤ ኑኒ ሙሴ ታማሬ። ");
INSERT INTO gofENT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","ፆሳይ ሙሴስ ኦዲዳይሳ ኑኒ ኤሮስ፥ ሺን ሃ ኡራይ ኢ ኣዉፔ ዪዳኮካ ኑ ኤሮኮ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","ኣዴይ ኤንታኮ፥ «ኢ ኣዉፔ ዪዳኮ ሂንቴ ኤሮናይሲ ማላሊሲያባ፥ ሺን ኢ ታ ኣይፊያ ፓꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","ፆሳ ቦንቼይሳኔ ኢ ኮያባ ኦꬂያ ኡራ ፆሳይ ሲዔሲፔ ኣቲን ናጋራንቾታ ሲዔና። ");
INSERT INTO gofENT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","ሳሎይ ሳዒ ሜꬌቶሳፔ ቆቄ ጊዲዲ ዬሌቲዳ ኣሳ ኣይፌ ፓꬂዳይ ኦኒካ ባዋ። ");
INSERT INTO gofENT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","ሃ ኣዴይ ፆሳፌ ኪቴቲቦናባ ጊዲያኮ ኢሲባካ ኦꬃናው ዳንዳዔና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","ኤንቲ ዛሪዲ፥ «ኔኒ ናጋራን ዬሌታዳ ዲጪዳይሲ ኑና ታማርሳናው ኮያይ?» ያጊዶሶና። ኢያ ኣይሁዴ ዎሳ ኬꬃፌ ሂሊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","ዬሱሲ ኤንቲ ኣዲያ ኬሲዳይሳ ሲዒዳ ዎዴ ኢያ ዴሚዲ፥ «ኣሳ ናዓ ኣማናይ?» ያጊዲ ኦይቺስ። ");
INSERT INTO gofENT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","ኣዴይ ዬሱሳኮ፥ «ጎዳው፥ ታኒ ኢያ ኣማናና ሜላ ኢ ኦኔ? ታው ኦዳርኪ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","ዬሱሲ ኣዲያኮ፥ «ኔኒ ኢያ ቤዓዳሳ፤ ሃ ኔራ ኦዴቴይሲ ኢያ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","ኣዴይ ዛሪዲ፥ «ጎዳው፥ ኣማናይስ» ያጊዲ ዬሱሳስ ጎይኒስ። ");
INSERT INTO gofENT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","ዬሱሲ፥ «ቆቄቲ ፄላና ሜላኔ ፄሌይሳቲ ቆቃና ሜላ ታኒ ፒርዳናው ሃ ኣላሚያ ያስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","ኢያራ ዴዒያ ጉꬃ ፋሪሳዌቲ ሄሳ ሲዒዲ፥ «ኑ ቆቄዬ?» ያጊዲ ኦይቺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","ዬሱሲ፥ «ሂንቴ ቆቄ ጊዲያኮ ሂንቴው ናጋራ ጊዴና። ሺን ሃዒ ሂንቴ ፄሎስ ጊያ ጊሾ ሂንቴ፥ ሂንቴ ናጋራን ዴዔታ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","ዬሱሲ፥ «ታኒ ሂንቴው ቱማ ኦዳይስ፤ ዶርሳ ጊርቤ ጊዶ ፔንጌራ ጊዶና ሃራሶራ ጌሊያ ኦኒካ ካይሶኔ ፓንጋ። ");
INSERT INTO gofENT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","ሺን ፔንጌራ ጌሌይሲ ዶርሳታ ሄሜይሳ። ");
INSERT INTO gofENT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","ፔንጊያ ናጌይሲ ኢያው ፔንጊያ ዶዬስ፤ ዶርሳቲካ ኢያ ቃላ ሲዖሶና። ኢ ባ ዶርሳታ ኤንታ ሱንꬃን ሱንꬃን ፄጌስ፤ ኤንታ ካሌꬂዲ ካሬ ኬሴስ። ");
INSERT INTO gofENT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","ኢ ባይሳታ ካሬ ኬሲዳፔ ጉዬ ኤንታ ሲንꬃን ሃሙቴስ። ኤንቲ ኢያ ቃላ ኤሪያ ጊሾ ኢያ ካሎሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","ሃራ ኡራ ቃላ ኤንቲ ኤሮና ጊሾ ኢያፔ ባቃቶሶናፔ ኣቲን ኢያ ጌዶ ካሎኮና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","ዬሱሲ ኤንታው ሃ ሌሚሱዋ ኦዲስ፥ ሺን ኢ ኣይ ጊዳኮ ኤንቲ ኣኬኪቦኮና። ");
INSERT INTO gofENT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","ዛሪዲ ዬሱሲ ኤንታኮ፥ «ታኒ ሂንቴው ቱማ ኦዳይስ፤ ታኒ ዶርሳታስ ፔንጌ። ");
INSERT INTO gofENT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","ታፔ ሲንꬄ ዪዳ ኡባይ ካይሶኔ ፓንጋ፥ ሺን ዶርሳቲ ኤንታ ሲዒቦኮና። ");
INSERT INTO gofENT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","ፔንጌይ ታና፤ ታ ባጋራ ጌሊያ ኦኒካ ኣታና። ኢ ታ ባጋራ ጌላናኔ ኬያና፤ ሎዖ ሄሜቲያ ቤሲ ዴማና። ");
INSERT INTO gofENT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","ካይሶይ ካይሶታናው፥ ሹካናዉኔ ꬋይሳናው ዬሲፔ ኣቲን ሃራባስ ዬና። ታኒ ኤንታው ዴዖይ ዳና ሜላኔ ኩሚዲ ፓላሃና ሜላ ያስ። ");
INSERT INTO gofENT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","«ታኒ ሎዖ ሄንꬃንቾ፤ ሎዖ ሄንꬃንቾይ ባ ዶርሳታ ጊሾ ባ ሼምፑዋ ኣꬂ ኢሜስ። ");
INSERT INTO gofENT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","ኬራ ሄሚያ ኣሲ ዶርሳታ ጎዳኔ ሄንꬃንቾ ጊዶና ጊሾ ሱꬉሜይ ያ ዎዴ ቤዒዲ ዶርሳታ ኣጊዲ ቤስ። ሄሳ ጊሾ፥ ሱꬉሜይ ዶርሳታ ኦይኪዲ ላሌስ። ");
INSERT INTO gofENT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","ኬራ ሄሜይሲ ሚሼስ ሄሚያ ጊሾኔ ዶርሳታባይ ኢያ ቆፊሶና ጊሾ ዶርሳታ ኣጊዲ ባቃቴስ። ");
INSERT INTO gofENT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","«ታኒ ሎዖ ሄንꬃንቾ። ታ ኣዋይ ታና ኤሬይሳዳ ታኒካ ታ ኣዋ ኤራይስ። ሄሳዳካ፥ ታኒ ታ ዶርሳታ ኤራይስ፤ ታ ዶርሳቲካ ታና ኤሮሶና። ታኒ ታ ዶርሳታ ጊሾ ታ ሼምፑዋ ኣꬃ ኢማይስ። ");
INSERT INTO gofENT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","ሃ ዉዲያን ባይና ሃራ ዶርሳቲ ታው ዴዖሶና። ታኒ ኤንታካ ኤሃናው ቤሴስ። ኤንቲ ታ ቃላ ሲዓና፤ ኤንቲ ኢሲ ዉዴ ጊዳና፤ ሄንꬃንቾይካ ኢሱዋ። ");
INSERT INTO gofENT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","«ታኒ ታ ሼምፑዋ ኣꬃ ኢማዳ ዛራ ኤኪያ ጊሾ ታ ኣዋይ ታና ዶሴስ። ");
INSERT INTO gofENT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","ታ ዶሳዳ ታ ሼምፑዋ ኣꬃ ኢማይሲፔ ኣቲን ታፔ ኦኒካ ኤኬና። ታ ታ ሼምፑዋ ኣꬃ ኢማናዉኔ ዛራ ኤካናው ማቲ ታው ዴዔስ። ታኒ ኦꬃና ሜላ ታ ኣዋይ ታና ኪቲዳይሲ ሃይሳ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","ሄሳ ኢ ጊዳ ጊሾ ኣይሁዴታ ጊዶን ቃሲካ ሻኬቴꬂ ሜꬌቲስ። ");
INSERT INTO gofENT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","ኤንታፌ ዳሪያ ባጋይ፥ «ኢያን ቱና ኣያኒ ዴዔስ! ኢ ጎዬስ! ኢ ጊያባ ኣይስ ሲዔቲ?» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","ሃራቲ ቃሲ፥ «ፃላሄይ ኦይኪዳ ኣሲ ሃይሳዳ ኦዴቴና። ቱና ኣያኒ ቆቄ ኣይፌ ፄሊሳናው ዳንዳዒዬ?» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","ዬሩሳላሜን ፆሳ ኬꬃ ኣንጂሲዳ ጋላሳታ ቦንቺያ ባሌይ ጋኪስ፤ ሄ ዎዴ ሳዒ ባልጎ። ");
INSERT INTO gofENT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","ዬሱሲ ፆሳ ኬꬃን ሶሎሞኔ ባራንዳን ሲሜሬቴስ። ");
INSERT INTO gofENT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","ኣይሁዴቲ ዬሱሳ ዩሾን ሺቂ ኤቂዲ፥ «ኔኒ ኑና ኣዉዴ ጋካናው ሲꬌራ ዎꬃኔ? ኔኒ ኪሪስቶሳ ጊዲኮ ኣኔ ኑስ ጌሻዳ ኦዳ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","ዬሱሲ ዛሪዲ ኤንታኮ፥ «ታኒ ሂንቴው ኦዳስ፤ ሺን ታና ኣማኔኬታ። ታኒ ታ ኣዋይ ታው ኢሚዳ ማታን ኦꬂያ ኦሶይ ታባ ማርካቴስ። ");
INSERT INTO gofENT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","ሺን ታኒ ሂንቴው ኦዲዳይሳዳ ሂንቴ ታ ዶርሴ ጊዶና ጊሾ ኣማኔኬታ። ");
INSERT INTO gofENT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","ታ ዶርሳቲ ታ ቃላ ሲዖሶና። ታኒ ኤንታ ኤራይስ፤ ኤንቲካ ታና ካሎሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","ታኒ ኤንታው ሜሪና ዴዑዋ ኢማይስ፤ ኤንቲ ኡባራካ ꬋዮኮና። ኦኒካ ታ ኩሼፔ ኤንታ ቦንቂ ኤካናው ዳንዳዔና። ");
INSERT INTO gofENT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","ኤንታ ታው ኢሚዳ ታ ኣዋይ ኡባፌ ኣꬌስ ኦኒካ ታ ኣዋ ኩሼፔ ኤንታ ቦንቂ ኤካናው ዳንዳዔና። ");
INSERT INTO gofENT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","ታኔ ታ ኣዋይ ኢሲኖ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","ኣይሁዴቲ ዬሱሳ ጫዳናው ቃሲካ ሹቺ ዴንꬂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","ዬሱሲ ኤንታኮ፥ «ታኒ ኦꬃና ሜላ ታ ኣዋይ ታው ኢሚዳ ዳሮ ሎዖ ኦሶታ ሂንቴና ኦꬃ ቤሳስ። ሄሳታፔ ኣዉሳ ጊሾ ታና ሹቻን ጫዳናው ኮዬቲ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","ኣይሁዴቲ ዛሪዲ፥ «ኑኒ ኔና ኔ ሎዖ ኦሶ ጊሾ ሹቻን ጫዳናው ኮዮኮ። ሺን ኔኒ ፆሳ ጫያ ጊሾኔ ኣሴ ጊዳሼ ኔ ኔና ፆሴ ጊያ ጊሾሳ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","ዬሱሲ ዛሪዲ፥ «ጌሻ ማፃፋን ፆሳይ፥ ‹ሂንቴ ፆሳታ› ጊዳይሲ ፃፌቲቤኔ? ");
INSERT INTO gofENT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","ጌሻ ማፃፋይ ሜሪናው ላሜቴና። ፆሳይ ባ ቃላ ኢሚዳ ኣሳታ፥ ‹ፆሳታ› ጊዲ ፄጊኮ፥ ");
INSERT INTO gofENT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","ኣዋይ ዶሪዲ ሃ ኣላሚያ ኪቲዳ ታና ፆሳ ናዓ ዋቲዲ ‹ፆሳ ጫያሳ› ያጌቲ? ");
INSERT INTO gofENT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","ታኒ ታ ኣዋይ ኦꬄይሳ ኦꬆና ኢፂኮ ታና ኣማኖፒቴ። ");
INSERT INTO gofENT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","ሺን ታኒ ኦꬂያባ ጊዲኮ ሂንቴ ታና ኣማኖና ኢፂኮካ፥ ታ ኣዋይ ታናን ዴዔይሳኔ ታካ ታ ኣዋን ዴዔይሳ ሂንቴ ኤራና ሜላ ታ ኦሱዋ ኣማኒቴ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","ቃሲካ ኤንቲ ኢያ ኦይካናው ኮዪዶሶና፥ ሺን ኢ ኤንታፌ ኬሲ ኤኪስ። ");
INSERT INTO gofENT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","ዮሃኒሲ ካሴ ፃማቂያ ቤሳ፥ ዮርዳኖሴ ሻፋፔ ሄፊንꬂ ዬሱሲ ፒኒዲ ያን ዴዒስ። ");
INSERT INTO gofENT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","ዳሮ ኣሳይ ዬሱሳኮ ዪዲ፥ «ዮሃኒሲ ማላታ ኦꬂቤና፥ ሺን ኢ ሃ ኣዲያባ ኦዲዳባይ ኡባይ ቱማ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","ያን ዳሮ ኣሳይ ዬሱሳ ኣማኒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","ቢታኒያ ጉታን ኣላዛራ ጊያ ኢሲ ኣዴይ ሃርጌቲስ። ቢታኔይ ማይራማኔ ኢ ሚቺያ ማርታ ዴዒያ ጉታ። ");
INSERT INTO gofENT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","ማይራማ ጎዳ ቶሁዋ ሺቶ ቲያዳ ባ ቢናናን ኢያ ቶሁዋ ቁቺዳሮ። ሃርጌቲዳይ ኢ ኢሻ ኣላዛራ። ");
INSERT INTO gofENT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","ሄሳ ጊሾ፥ ሚቼቲ፥ «ጎዳው፥ ኔ ዶሴይሲ ሃርጌቲስ» ጊዲ ዬሱሳኮ ኪቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","ዬሱሲ ሄሳ ሲዒዳ ዎዴ «ሃ ሃርጌይ፥ ፆሳይኔ ኢያ ናዓይ ቦንቼታና ሜላፔ ኣቲን ሃይቆስ ጋꬂያ ሃርጌ ጊዴና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","ዬሱሲ ማርታ፥ ኢ ሚቺዉኔ ኣላዛራ ዶሴስ። ");
INSERT INTO gofENT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","ሺን ኣላዛሪ ሃርጊዳይሳ ዬሱሲ ሲዒዲ ባ ዴዒያ ቤሳን ናምዑ ጋላስ ጋምዒስ። ");
INSERT INTO gofENT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","ሄሳፌ ጉዬ፥ ዬሱሲ ባ ታማሬታኮ፥ «ዛሪዲ ዪሁዳ ቢታ ቦስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","ኢያ ታማሬቲ ዛሪዲ፥ «ኣስታማሪያው፥ ጉꬃ ዎዴፔ ካሴ ኣይሁዴቲ ኔና ሹቻን ጫዲዲ ዎꬋናው ኮዪዶሶና፤ ሃዒካ ያ ባኔ?» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","ዬሱሲ፥ «ኢሲ ጋላሳን ታማኔ ናምዑ ሳቴይ ዴዔስ ጊዴኔዬ? ጋላስ ሃሙቲያ ኣሲ ሃ ኣላሚያ ፖዑዋ ቤዒያ ጊሾ ꬉቤቴና። ");
INSERT INTO gofENT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","ሺን ቃማ ሃሙቲያ ኦኒካ ፖዖይ ባይና ጊሾ ꬉቤቴስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","ዬሱሲ ሄሳ ጊዳፔ ጉዬ ኤንታኮ፥ «ኑ ዶሲያ ኣላዛሪ ꬊስኪስ፥ ሺን ኢያ ዴንꬃናው ታኒ ባና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","ኢያ ታማሬቲ ዛሪዲ፥ «ጎዳው፥ ኢ ꬊስኪዳባ ጊዲኮ ኢያው ሎዓና» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","ዬሱሲ ኣላዛሪ ሃይቂዳይሳ ኦዲስ፥ ሺን ኤንታው ጮ ꬊስኮ ዳኒስ። ");
INSERT INTO gofENT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","ሄሳ ጊሾ፥ ዬሱሲ ጌሺዲ ኤንታኮ፥ «ኣላዛሪ ሃይቂስ። ");
INSERT INTO gofENT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","ሂንቴ ኣማናና ሜላ ታኒ ሄ ቤሳን ዴዖናይሳስ ሂንቴ ጊሾ ኡፋይታይስ። ኣኔ ዬꬊቴ፤ ኢያኮ ቦስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","ሄሳፌ ጉዬ፥ ዲዲሞሳ ጌቴቲያ ቶማሲ ባ ላጌ ታማሬታኮ፥ «ኣስታማሪያራ ሃይቃናው ኑካ ቦስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","ዬሱሲ ጋኪያ ዎዴ ኣላዛሪ ሞጌቲን ኦይዱ ጋላስ ጊዲስ። ");
INSERT INTO gofENT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","ቢታኔይ ዬሩሳላሜፔ ሄꬑ ኪሎ ሚቲሬ ሜላ ሃኬስ። ");
INSERT INTO gofENT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ዳሮ ኣይሁዴቲ ማርታኔ ማይራሞ ኤንታ ኢሻይ ሃይቂዳይሳስ ሚንꬄꬃናው ዪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","ማርታ ዬሱሲ ዪዳይሳ ሲዓዳ ኢያ ሞካናው ኬያሱ፥ ሺን ማይራማ ሶን ኣታሱ። ");
INSERT INTO gofENT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","ማርታ ዬሱሳኮ፥ «ጎዳው፥ ኔኒ ሃይሳን ዴዒዳባ ጊዲያኮ ታ ኢሻይ ሃይቄና። ");
INSERT INTO gofENT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","ሺን ሃዒ ጊዲኮካ ኔኒ ዎሲያባ ፆሳይ ኔው ኢማናይሳ ታኒ ኤራይስ» ያጋሱ። ");
INSERT INTO gofENT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","ዬሱሲ፥ «ኔ ኢሻይ ሃይቆፔ ዴንዳና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","ማርታ ኢያኮ፥ «ዉርሴꬃ ጋላስ ኢ ሃይቆፔ ዴንዳናይሳ ኤራይስ» ያጋሱ። ");
INSERT INTO gofENT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","ዬሱሲ ኢኮ፥ «ታኒ ዴንዶኔ ዴዖ፤ ታና ኣማኒያ ኦኒካ ሃይቂኮካ ዴዖን ዳና። ");
INSERT INTO gofENT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ቃሲ ዴዖን ዴዔይኔ ታና ኣማኒያ ኦኒካ ሃይቄና። ሄሳ ኔኒ ኣማናይ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","ማርታ ዛራዳ፥ «ጎዳው፥ ኤ ታኒ ኣማናይስ! ኔኒ ፆሳ ናዓ፥ ኣላሚያ ያናው ዴዒያ ኪሪስቶሳ ጊዴይሳ ታኒ ኣማናይስ» ያጋሱ። ");
INSERT INTO gofENT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","ማርታ ሄሳ ጊዳፔ ጉዬ፥ ባዳ ባ ሚቺው ጌማን ፄጋዳ፥ «ኣስታማሬይ ዪዲ ኔና ኮዬስ» ያጋሱ። ");
INSERT INTO gofENT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","ማይራማ ሄሳ ሲዒዳ ዎዴ ኤሌሳ ዴንዳ ኤቃዳ ዬሱሳኮ ባሱ። ");
INSERT INTO gofENT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","ሄ ዎዴ ዬሱሲ ማርታራ ጋሄቲዳ ቤሳን ዴዔስ፤ ቡሮ ጉታ ጋኪቤና። ");
INSERT INTO gofENT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","ማይራሞ ሚንꬄꬂሼ ኢራ ሶን ዴዒያ ኣይሁዴቲ፥ ኢያ ዴንዳ ኤቃዳ ኤሌሳዳ ካሬ ኬዪዳይሳ ቤዒዲ፥ ዱፎ ባዳ ዬካናው ሃኒያ ዳኒን ኢዮ ካሊዲ ኬዪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","ማይራማ ዬሱሲ ዴዒያሱዋ ባዳ ኢያ ቤዒዳ ዎዴ ኢያ ቶሁዋ ቦላ ኩንዳዳ፥ «ጎዳው፥ ኔኒ ሃይሳን ዴዒዳባ ጊዲያኮ ታ ኢሻይ ሃይቄናሺን» ያጋሱ። ");
INSERT INTO gofENT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","ዬሱሲ ማይራማኔ ኢራ ዴዒያ፥ ኣይሁዴቲ ዬኬይሳ ቤዒዲ፥ ባ ዎዛናን ዳሮ ሴሌቲዲ፥ ");
INSERT INTO gofENT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","«ኣዉን ሞጊዴቲ?» ያጊዲ ኦይቺን፥ «ጎዳው፥ ያዳ ቤዓ» ያጊዲ ዛሪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","ዬሱሲ ኣፉፂስ። ");
INSERT INTO gofENT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","ሄሳ ጊሾ፥ ኣይሁዴቲ፥ «ኢ ኣላዛራ ኣይ ሜላ ዶሲያኮ ቤዒቴ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","ሺን ኤንታፌ ኢሶቲ ኢሶቲ፥ «ሃይሲ ቆቂያ ፄሊሲዳይሲ ሃ ኣዴይ ሃይቆና ሜላ ኦꬃናው ዳንዳዔኔሺን?» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","ቃሲካ ዬሱሲ ሴሌቲዲ፥ ኣላዛሪ ሞጌቲዳ ዱፉዋ ቢስ። ሄ ዱፎይ ሹቻን ጎርዴቲዳ ጎንጎሎ። ");
INSERT INTO gofENT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","ዬሱሲ፥ «ሹቻ ዴንꬂቴ» ያጊዲ ኪቲስ። ማርታ፥ «ጎዳው፥ ኢ ሃይቆሳፔ ኦይዱ ጋላስ ጊዲዳ ጊሾ ሃዒ ፂንቃና» ያጋሱ። ");
INSERT INTO gofENT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","ዬሱሲ ማርታኮ፥ «ኔ ኣማኒያባ ጊዲኮ ፆሳ ቦንቹዋ ቤዓናይሳ ታኒ ኔው ኦዳቢኪና?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","ኤንቲ ሹቻ ዴንꬂን ዬሱሲ ሳሎ ፑዴ ፄሊዲ፥ «ኣዋው፥ ታና ኔ ሲዒዳ ጊሾ ኔና ጋላታይስ። ");
INSERT INTO gofENT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","ኔ ኡባ ዎዴ ታና ሲዔይሳ ታኒ ኤራይስ። ሺን ሃይሳን ኤቂዳ ኣሳይ ኔኒ ታና ኪቲዳይሳ ኣማናና ሜላ ታኒ ኤንታ ጊሾ ሃይሳ ጋይስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","ዬሱሲ ሄሳ ጊዳፔ ጉዬ፥ ባ ቃላ ꬎቁ ኦꬂዲ፥ «ኣላዛራ፥ ሃ ኬያ!» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","ሃይቂዳ ኣዴይ ዚꬌቲዳ ሜላ ኩሼይኔ ቶሆይ ሻሎን ቃሼቲዲ ዴዒሺን ኢያ ኣይፌ ካሬይ ጎዜቲዳ ሜላ ዱፉዋፔ ኬዪስ። ዬሱሲ ኤንታ፥ «ቢርሺቴ! ቦ ጊቴ!» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","ሄሳ ጊሾ፥ ማይራሚኮ ዪዳ ኣይሁዴታፔ ዳሮቲ ዬሱሲ ኦꬂዳይሳ ቤዒዲ ኢያ ኣማኒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","ሺን ኤንታፌ ኢሶቲ ኢሶቲ ፋሪሳዌታኮ ቢዲ ዬሱሲ ኦꬂዳይሳ ኤንታው ኦዲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","ሄሳፌ ጉዬ፥ ካሂኔ ሃላቃቲኔ ፋሪሳዌቲ ሻንጉዋ ሺሺዲ፥ «ሃ ኣዴይ ዳሮ ማላታታ ኦꬂያ ጊሾ ኑ ኣይ ኦꬂኖ? ");
INSERT INTO gofENT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","ኑኒ ኢያ ሲዒ ጊዲ ኣጊኮ ኣሳ ኡባይ ኢያ ኣማናና። ቃሲ ሮሜ ቢታ ኣሳቲ ዪዲ ኑ ፆሳ ኬꬃኔ ኑ ዴሪያ ꬋይሳና» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","ኤንታፌ ኢሶይ ቃያፋ ጌይሲ፥ ሄ ላይꬂ ካሂኔ ሃላቃ ጊዲዳይሲ፥ «ሂንቴ ኣይኮካ ኤሬኬታ! ");
INSERT INTO gofENT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","ኣሳይ ኡባይ ꬋዬይሳፌ ኣሳ ኡባ ጊሾ ኢሲ ኣሲ ሃይቄይሲ ሎዖ ጊዴይሳ ኤሬኬቲ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","ኢ ሄሳ ባፔ ጊቤና። ሺን ሄ ላይꬂ ካሂኔ ሃላቃ ጊዲያ ጊሾ ዬሱሲ ኣይሁዴ ኣሳ ጊሾ ሃይቃናው ቤሴይሳ ቲንቢቴ ኦዲስ። ");
INSERT INTO gofENT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","ቃሲ ዬሱሲ ኣይሁዴ ኣሳ ፃላላስ ጊዶናሺን ላሌቲዲ ዴዒያ ፆሳ ኣሳ ኡባ ኢሲፌ ሺሻናዉኔ ኢሲ ኣሲ ኦꬃናው ሃይቃና። ");
INSERT INTO gofENT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","ሄ ጋላሳፔ ዶሚዲ ኤንቲ ኢያ ዎꬋናው ማቄቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","ሄሳ ጊሾ፥ ዬሱሲ ኣይሁዴታ ጊዶን ቆንጬን ሲሜሬቲቤና። ሺን ባዞ ቢታ ማታን ዴዒያ ኤፍሬሜ ጉታ ቢስ። ባ ታማሬታራ ሄ ቤሳን ጋምዒስ። ");
INSERT INTO gofENT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","ኣይሁዴቲ ቦንቺያ ፓሲካ ጋላሳይ ማቲስ። ቃሲ ዳሮ ኣሳይ ባንታና ጌሻናው ፓሲካ ቦንቺያ ጋላሳይ ጋካናፔ ሲንꬄ ሄ ቢታፌ ዬሩሳላሜ ቢዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","ኤንቲ ፆሳ ኬꬃን ኤቂዲ ዬሱሳ ዩሳ ናጊያ ጊሾ «ኣይ ቆፔቲ? ዬሱሲ ባሊያ ቦንቻናው ዬኔ?» ያጊዲ ኢሶይ ኢሱዋ ኦይቺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","ካሂኔ ሃላቃቲኔ ፋሪሳዌቲ ዬሱሳ ኦይካናው፥ ኢ ዴዒያሱዋ ኤሪያ ኦኒካ ባንታው ኦዳና ሜላ ኪቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","ፓሲካ ቦንቺያ ጋላሳፔ ኡሱፑን ጋላስ ሲንꬃቲዲ፥ ዬሱሲ ሃይቆፔ ዴንꬂዳ ኣላዛሪ ዴዒያ ጉታ፥ ቢታኒያ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","ሄ ቤሳን ኤንቲ ኢያው ካሆ ጊጊሲዶሶና። ኣላዛሪ ዬሱሳራ ኢሲፌ ጋይታ ቦላ ኡቲዳሺን ማርታ ኤንታና ሞካዉሱ። ");
INSERT INTO gofENT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","ማይራማ ናርዶሴ ጊያ ዳሮ ኣልዖ ጌሻ ሺቶ ኤሃዳ ዬሱሳ ቶሁዋ ቲያሱ። ባ ቢናናን ኢያ ቶሁዋ ቁቻሱ፤ ኬꬃ ኡባይ ሺቶ ሳዎን ቶንጉ ጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","ሺን ዬሱሳ ታማሬታፔ ኢሶይ፥ ዬሱሳ ኣꬂ ኢማናይሲ፥ ኣስቆሮታ ዪሁዲ፥ ");
INSERT INTO gofENT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","«ኣይስ ሃ ሺቶይ ሄꬑ ፄቱ ዲናሬን ባይዜቲዲ፥ ሚሼይ ማንቆታስ ኢሜቴኔ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","ኢ ካይሶ ጊዲዳ ጊሾ ሄሳ ጊሲፔ ኣቲን ማንቆታስ ቃꬌቲዲ ጊቤና። ኢ ሚሼ ካርፂታ ኦይኬይሳ ጊዲያ ጊሾ ኡባ ዎዴ ኢያፔ ባው ኤኬስ። ");
INSERT INTO gofENT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","ዬሱሲ፥ «ኢያ ባው ዴዒያባ ታ ሞጎ ጋላሳስ ሚንጂዳ ጊሾ ኢዮ ኣጋጊቴ። ");
INSERT INTO gofENT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","ማንቆቲ ኡባ ዎዴ ሂንቴራ ዳና፥ ሺን ታኒ ኡባ ዎዴ ሂንቴራ ዴዒኬ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","ሄ ዎዴ ዳሮ ኣሳይ ዬሱሲ ቢታኒያን ዴዔይሳ ሲዒዲ ያ ቢዶሶና። ኤንቲ ዬሱሳ ፃላላ ጊዶናሺን ኢ ሃይቆፔ ዴንꬂዳ ኣላዛራካ ቤዓናው ቢዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","ሄሳ ጊሾ፥ ካሂኔ ሃላቃቲ ኣላዛራካ ቃሲ ዎꬋናው ማቄቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ኣይስ ጊኮ፥ ኣላዛራ ጋሶን ዳሮ ኣይሁዴቲ ኤንታና ኢፂዲ ዬሱሳ ኣማኖሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","ዎንቴꬃ ጋላስ ፓሲካ ቦንቺያ ቤሳ ዪዳ ዳሮ ኣሳይ ዬሱሲ ዬሩሳላሜ ቤይሳ ሲዒዲ፥ ");
INSERT INTO gofENT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ዛምባ ሃይꬂ ኤኪዲ ኢያ ሞካናው ኬዪዶሶና። ባንታ ቃላ ꬎቁ ኦꬂዲ፥ «ሆሳና! ፆሳይ ጋላቴቶ! ጎዳ ሱንꬃን ዬይሲ ኣንጄቶ! ፆሳይ ኢስራዔሌ ካዉዋ ኣንጆ!» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","15","ጌሻ ማፃፋን፥ «ፂዮኔ ካታማው፥ ባቦፋ! ሄኮ፥ ኔ ካዎይ ሃሬ ማራ ቦላ ኡቲዲ ዬስ» ጌቴቲዳይሳዳ ዬሱሲ ሃሬ ማሪ ዴሚዲ ኢያ ቶጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","ዬሱሳ ታማሬቲ ሄሳ ካሴ ኣኬኪቦኮና። ሺን ዬሱሲ ቦንቼቲዳፔ ጉዬ ኤንቲ ሄሳ ኡባ ኣኬኪዶሶና። ሄሲ ኡባይ ጌሻ ማፃፋይ ጊዳይሳዳ ሃኒስ። ");
INSERT INTO gofENT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","ዬሱሲ ኣላዛራ ዱፎፔ ፄጊዲ፥ ሃይቆፔ ዴንꬂዳ ዎዴ ኢያራ ዴዒያ ዳሮ ኣሳይ ዬሱሳባ ማርካቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","ዳሮ ኣሳይ ኢያ ሞካናው ኬዪዳይ፥ ኢ ሄ ማላታታ ኦꬂዳይስሳ ሲዒዳ ጊሾሳ። ");
INSERT INTO gofENT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","ሄሳ ጊሾ፥ ፋሪሳዌቲ ኢሶይ ኢሱዋኮ፥ «ኑ ኣይኮካ ኦꬃናው ዳንዳዖናይሳ ቤዒቴ፤ ዴሬ ኡባይ ኢያ ካሌስ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","ፓሲካ ቦንቺያ ጋላስ ጎይናናው ዬሩሳላሜ ቢዳይሳታ ጊዶን ኢሲ ኢሲ ጊሪኬ ኣሳቲ ዴዖሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","ኤንቲ ጋሊላ ቢታን ቤቴሳይዳ ካታማፔ ዪዳ ፊልጶሳኮ ቢዲ፥ «ጎዳው፥ ኑኒ ዬሱሳ ቤዓናው ኮዮስ» ያጊዲ ዎሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","ፊልጶሲ ቢዲ ኢንዲሪያሳስ ኦዲን ናምዓይ ቢዲ፥ ዬሱሳስ ኦዲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","ዬሱሲ ኤንታኮ፥ «ኣሳ ናዓይ፥ ቦንቼቲያ ዎዴይ ጋኪስ። ");
INSERT INTO gofENT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","ታኒ ሂንቴው ቱማ ኦዳይስ፤ ኢሲ ጊስቴ ኣይፌይ ቢታን ዎꬊዲ ዎቆና ኢፂኮ ባርካ ኣቴስ። ሺን ሄ ጊስቴ ኣይፌይ ዎቂኮ ዳሮ ኣይፌ ኣይፌስ። ");
INSERT INTO gofENT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","ባ ሼምፑዋ ዶሲያ ኦኒካ ꬋይሴስ፤ ባ ሼምፑዋ ሃ ኣላሚያን ኢፂያ ኦኒካ ሜሪና ዴዖስ ኣሼስ። ");
INSERT INTO gofENT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","ታኒ ዴዒያሱዋን ታራ ዳና ሜላ ታው ኦꬃናው ኮያ ኦኒካ ታና ካላናው ቤሴስ። ታው ኦꬂያ ኦናካ ታ ኣዋይ ቦንቻና። ");
INSERT INTO gofENT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","«ሃዒ ታ ሼምፖይ ዳሮ ኡንዔቲስ፤ ያቲን ዎይጎ? ‹ታ ኣዋው፥ ታና ሃ ሳቴፔ ኣሻርኪ› ያጎ? ኣካይ፥ ታኒ ዪዳይ ዋዬ ኤካናሳ። ");
INSERT INTO gofENT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","ታ ኣዋው፥ ኔ ሱንꬃ ቦንቻ» ያጊስ። ሄ ዎዴ ሳሎፔ፥ «ታኒ ታ ሱንꬃ ቦንቻስ፤ ዛራዳካ ቦንቻና» ያጊያ ቃላይ ዪስ። ");
INSERT INTO gofENT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","ሄ ቤሳን ኤቂዳ ዳሮ ኣሳይ ሄ ቃላ ሲዒዲ፥ «ሄሲ ዳዳ» ያጊዶሶና። ሃራቲ ቃሲ፥ «ኪታንቾይ ኢያው ኦዲስ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","ዬሱሲ ዛሪዲ ኤንታኮ፥ «ሃ ቃላይ ሂንቴ ጊሾ ዪሲፔ ኣቲን ታ ጊሾ ጊዴና። ");
INSERT INTO gofENT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","ሃ ኣላሜይ ፒርዴቲያ ዎዴይ ሃዒ፤ ሃ ኣላሚያ ሃሬይሲ ሃዒ ካሬ ሆሌታና። ");
INSERT INTO gofENT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","ቃሲ ታኒ ሳዓፔ ꬎቁ ኦሴቲዳ ዎዴ ኣሳ ኡባ ታኮ ኤሃና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","ኢ ሄሳ ጊዳይ ኣይ ሜላ ሃይቆ ሃይቃኔኮ ኤንታው ቆንጪሳናሳ። ");
INSERT INTO gofENT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","ዳሮ ኣሳይ ዛሪዲ፥ «ኑ ሂጌይ ኪሪስቶሲ ሜሪናው ዴዔይሳ ኦዴስ። ያቲን፥ ኔኒ ዎይጋዳ፥ ‹ኣሳ ናዓይ ꬎቁ ጋናው ቤሴስ› ጋይ? ‹ኢ፥ ኣሳ ናዓይ ኦኔ?› » ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","ዬሱሲ፥ «ፖዖይ ሂንቴራ ጉꬃ ዎዴ ጋምዓና። ሂንቴው ꬉሞና ሜላ ፖዖይ ዴዒሺን፥ ፖዑዋን ሃሙቲቴ። ꬉማን ሃሙቲያ ኣሲ ኣው ቢያኮ ኤሬና። ");
INSERT INTO gofENT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","ፖዖ ናይታ ጊዳና ሜላ ፖዖይ ዴዒሺን ፖዑዋ ኣማኒቴ» ያጊስ። ዬሱሲ ሄሳ ኦዲዳፔ ጉዬ ቢዲ ኤንታፌ ጌሚስ። ");
INSERT INTO gofENT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","ኢ ሄሳ ሜላ ማላታታ ኤንታ ሲንꬃን ኦꬂንካ ኣማኒቦኮና። ");
INSERT INTO gofENT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ናቢያ ኢሳያሲ፥ «ጎዳው፥ ኑ ማርካቴꬃ ኦኒ ኣማኒዴ? ጎዳይ ባ ዎልቃ ኦዴስ ቆንጪሲዴ?» ጊዳይሲ ቱማ ጊዳና ሜላ ኤንቲ ኢያ ኣማኒቦኮና። ");
INSERT INTO gofENT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","40","ቃሲካ ኢሳያሲ፥ «ኤንታ ኣይፌይ ፄሎና ሜላ፥ ኤንታ ዎዛናይ ኣኬኮና ሜላ፥ ኤንቲ ፆሳኮ ሲሚን፥ ኢ ኤንታ ፓꬆና ሜላ፥ ፆሳይ ኤንታ ኣይፊያ ቆቂሲስ። ኤንታ ዎዛና ሚንꬂስ» ጊዳ ጊሾ ኤንቲ ኣማናናው ዳንዳዒቦኮና። ");
INSERT INTO gofENT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","ኢሳያሲ ሄሳ ጊዳይ፥ ዬሱሳ ቦንቹዋ ቤዒዳ ጊሾኔ ኢያባ ኦዲዳ ጊሾሳ። ");
INSERT INTO gofENT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","ጊዲኮካ፥ ኣይሁዴታ ሃላቃታፔካ ዳሮቲ ዬሱሳ ኣማኒዶሶና። ሺን ፋሪሳዌቲ ባንታና ኣይሁዴታ ዎሳ ኬꬃፌ ኬሶሶና ጊዲ ያዪዳ ጊሾ ኣማኒዳ ጊዲ ቆንጬን ማርካቲቦኮና። ");
INSERT INTO gofENT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","ሄሳ ኤንቲ ኦꬂዳይ፥ ፆሳን ኤሬታናይሳፌ ኣꬂዲ ኣሳን ኤሬታናይሳ ዶሲዳ ጊሾሳ። ");
INSERT INTO gofENT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","ዬሱሲ ባ ቃላ ꬎቁ ኦꬂዲ፥ «ታና ኣማኒያ ኦኒካ ታና ኪቲዳይሳካ ኣማኔስፔ ኣቲን ታ ፃላላ ኣማኔና። ");
INSERT INTO gofENT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","ታና ቤዒያ ኦኒካ ታና ኪቲዳይሳካ ቤዔስ። ");
INSERT INTO gofENT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","ታና ኣማኒያ ኡባይ ꬉማን ዶና ሜላ ታኒ ፖዖ ጊዳዳ ኣላሚያ ያስ። ");
INSERT INTO gofENT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","ታ ቃላ ሲዒዲ ኪቴቶና ኦናካ ታኒ ፒርዲኬ። ኣይስ ጊኮ፥ ታኒ ኣላሚያ ኣሻናው ያሲፔ ኣቲን ፒርዳናው ያቢኬ። ");
INSERT INTO gofENT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","ታና ኢፄይሳኔ ታ ቃላ ኤኮና ኦናካ ፒርዴይሲ ዴዔስ። ታኒ ኦዲዳ ቃላይ ዉርሴꬃ ጋላስ ሄ ኡራ ፒርዳና። ");
INSERT INTO gofENT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","ኣይስ ጊኮ፥ ታኒ ሄሳ ታፔ ኦዲኬ፥ ሺን ታና ኪቲዳ ታ ኣዋይ ታኒ ጋናይሳኔ ኦዳናይሳ ኪቲስ። ");
INSERT INTO gofENT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","ቃሲ ኢያ ኪታይ ሜሪና ዴዖ ጊዴይሳ ታኒ ኤራይስ። ሄሳ ጊሾ፥ ታኒ ኦዴይሲ ታ ኣዋይ ታና ኦዳ ጊዳይሳ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","ፓሲካ ቦንቺያ ጋላሳይ ጋካናፔ ሲንꬃቲዲ ሃ ኣላሚያ ኣጊዲ ኣዋኮ ቢያ ዎዴይ ጋኪዳይሳ ዬሱሲ ኤሪስ። ሃ ኣላሚያን ዴዒያ ባይሳታ ኡባ ዎዴ ዶሲስ፤ ዉርሴꬂ ጋካናዉካ ኤንታ ዶሲስ። ");
INSERT INTO gofENT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","ዬሱሳራኔ ኢያ ታማሬታራ ኢሲፌ ካሆ ሞሶና። ሄሳፌ ካሴ ፃላሄይ ሲሞና ናዓ ኣስቆሮታ ዪሁዲ ዬሱሳ ኣꬂ ኢማናዳ ኢያ ዎዛናን ኢታ ቆፋ ዎꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","ዬሱሲ ኣዋይ ኡባባ ኢያ ኩሼን ዎꬂዳይሳ፥ ኢ ፆሳ ማታፔ ዪዳይሳኔ ሲሚዲ ኢያኮ ባናይሳ ኤሪስ። ");
INSERT INTO gofENT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","ዬሱሲ ጋይታ ቦላፌ ዴንዲዲ ቦላ ባጋ ማዑዋ ቃሪ ዎꬂዲ፥ ፖፃ ኤኪዲ ባ ፄሳን ማርፃፊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","ሄሳፌ ጉዬ፥ ሃꬄ ሜቻ ሚሼን ቲጊዲ፥ ባ ታማሬታ ቶሁዋ ሜጪስ፤ ቃሲ ባ ፄሳን ዳንጪዳ ፖፃን ቁቺስ። ");
INSERT INTO gofENT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","ዬሱሲ ሲሞን ጴፂሮሳኮ ያ ዎዴ ጴፂሮሲ፥ «ጎዳው፥ ኔ ታ ቶሁዋ ሜጫኔ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","ዬሱሲ ዛሪዲ ኢያኮ፥ «ታኒ ኦꬄይሳ ኔ ሃዒ ኤራካ፥ ሺን ጉዬፔ ኣኬካና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","ያቲን፥ ጴፂሮሲ፥ «ኔ ታ ቶሁዋ ኡባራካ ሜጫካ» ያጊስ። ዬሱሲ ኢያኮ፥ «ታኒ ኔ ቶሁዋ ሜጮና ኢፂኮ ኔዉኔ ታው ኢሲፌቴꬂ ባዋ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","ጴፂሮሲ ዬሱሳኮ፥ «ጎዳው፥ ያቲኮ፥ ታ ቶሁዋ ፃላላ ጊዶናሺን ታ ኩሺያኔ ታ ሁዒያ ሜጫ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","ዬሱሲ ዛሪዲ፥ «ቦላ ሜጬቲዳ ኦኒካ ቶሆፔ ሃራባ ሜጬታናው ኮሼና፤ ኢያው ኡባሶይ ጌሺ። ሂንቴ ጌሺ፥ ሺን ኡባይ ጌሺ ጊዴኬታ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","ዬሱሲ ባና ኣꬂ ኢማና ኡራይ ኦኔኮ ኤሪያ ጊሾ «ሂንቴ ኡባይ ጌሺ ጊዴኬታ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","ኤንታ ቶሁዋ ሜጪዳፔ ጉዬ ዬሱሲ ባ ማዑዋ ዛሪ ማዒስ። ሲሚ ጋይታ ቦላ ኡቲዲ ኤንታኮ፥ «ታኒ ሂንቴው ኦꬂዳይሳ ኣኬኬቲ? ");
INSERT INTO gofENT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","ሂንቴ ታና ኣስታማሬኔ ጎዳ ጌታ፤ ታኒ ሂንቴ ጌይሳ ጊዲያ ጊሾ ሎዖ ጊዴታ። ");
INSERT INTO gofENT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","ታኒ ሂንቴው ጎዳኔ ኣስታማሬ ጊዳሼ ሂንቴ ቶሁዋ ሜጪኮ ሂንቴካ ኢሶይ ኢሱዋስ ሄሳዳ ኦꬃናው ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","ሂዛ፥ ታኒ ሂንቴው ኦꬂዳይሳዳ ሂንቴካ ኦꬃና ሜላ ሂንቴው ሌሚሶ ጊዳስ። ");
INSERT INTO gofENT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","ታኒ ሂንቴው ቱማ ኦዳይስ፤ ኣይሌይ ባ ጎዳፔ፥ ኪቴቲዳይሲ ኪቲዳይሳፌ ኣꬌና። ");
INSERT INTO gofENT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","ሂንቴ ሄሳ ኤሪዲ ኦꬂያባ ጊዲኮ ኣንጄቲዳይሳታ። ");
INSERT INTO gofENT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","«ታኒ ሂንቴና ኡባ ጊኬ፤ ታኒ ዶሪዳይሳታ ኤራይስ። ሺን ጌሻ ማፃፋን፥ ‹ታ ባርሲዳይሲ ታ ኩሺያ ሳፂስ› ጌቴቲዳይሲ ቱማ ጊዳናው ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","ታኒ ታና ጊዴይሳ ሂንቴ ኣማናና ሜላ ሄሲ ሃናናፔ ሲንꬃታዳ ሂንቴው ኦዳይስ። ");
INSERT INTO gofENT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","ታኒ ሂንቴው ቱማ ኦዳይስ፤ ታኒ ኪቲዳ ኦናካ ሞኪያ ኡራይ ታና ሞኬስ። ታና ሞኪያ ኦኒካ ታና ኪቲዳይሳ ሞኬስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","ዬሱሲ ሄሳ ኦዲዳፔ ጉዬ ባ ዎዛናን ዳሮ ኡንዔቲዲ፥ «ታኒ ሂንቴው ቱማ ኦዳይስ፤ ታና ሂንቴፌ ኢሶይ ኣꬂ ኢማና» ጊዲ ቆንጪሲዲ ኦዲስ። ");
INSERT INTO gofENT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","ኢ ኦዴባ ኦዲያኮ ኢያ ታማሬታስ ኤሬቶና ኢፂን ኢሶይ ኢሱዋ ፄሊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","ኢያ ታማሬታፔ ኢሶይ፥ ዬሱሲ ዶሴይሲ፥ ዬሱሳ ማታን ኡቲስ። ");
INSERT INTO gofENT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","ሄሳ ጊሾ፥ ሲሞን ጴፂሮሲ ኢያ ቃምዖቲዲ፥ «ኢ ኦና ጊያኮ ኣኔ ኦይቻ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","ሄሳ ጊሾ፥ ሄ ታማሬይ ዬሱሳኮ ሺቂዲ ሃይꬃን፥ «ጎዳው፥ ኢ ኦኔ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","ዬሱሲ ዛሪዲ፥ «ታኒ ኡይꬃ ዎፄን ቱሻዳ ባርሴይሳ» ያጊስ። ቃሲ ኡይꬃ ሜንꬂ ኤኪዲ፥ ዎፄን ቱሺዲ፥ ሲሞና ናዓ ኣስቆሮታ ዪሁዳ ባርሲስ። ");
INSERT INTO gofENT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","ዪሁዲ ኡይꬃ ባሪዳፔ ጉዬ ፃላሄይ ሶሁዋራ ዪሁዳን ጌሊስ። ዬሱሲ ኢያኮ፥ «ኔኒ ኦꬃናው ቆፒዳባ ኤሌሳዳ ኦꬃ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","ሺን ጋይታ ቦላ ኡቲዳይሳታፔ ኦኒካ ዬሱሲ ሄሳ ኣይስ ኢያኮ ጊዳኮ ኤሪቤና። ");
INSERT INTO gofENT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","ዪሁዲ ሚሼ ኦይኪያ ጊሾ ኢያ ታማሬታፔ ኢሶቲ ኢሶቲ ዬሱሲ ኢያ፥ «ፓሲካ ቦንቺያ ጋላሳስ ባንታው ኮሺያባ ሻማ ዎይኮ ማንቆታስ ሙፃታ ኢማ ጊስ» ያጊዲ ቆፒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","ዪሁዲ ኡይꬃ ባሪዳ ሜላ ሶሁዋራ ካሬ ኬዪስ። ሄ ዎዴ ሳዒ ቃማ። ");
INSERT INTO gofENT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","ዪሁዲ ካሬ ኬዪዳፔ ጉዬ፥ ዬሱሲ፥ «ሃዒ ኣሳ ናዓይ ቦንቼቲስ፤ ፆሳይካ ኢያ ባጋራ ቦንቼቲስ። ");
INSERT INTO gofENT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","ፆሳይ ኢያ ባጋራ ቦንቼቲኮ ኢ ባ ሁዔን ኣሳ ናዓ ቦንቻና፤ ቃሲ ኢ ሄሳ ኤሌሲዲ ኦꬃና። ");
INSERT INTO gofENT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","ታ ናይቶ፥ ታኒ ሂንቴራ ዳሮ ዎዴ ጋምዒኬ። ሂንቴ ታና ኮያና፥ ሺን ታኒ ኣይሁዴታስ ኦዲዳይሳ ሜላ፥ ‹ሂንቴ ታኒ ቢያሱዋ ባናው ዳንዳዔኬታ።› ");
INSERT INTO gofENT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","ታኒ ሂንቴው ኢሚያ ኦራꬃ ኪታይ ሃይሳ፤ ኢሶይ ኢሱዋ ዶሲቴ። ታኒ ሂንቴና ዶሲዳይሳዳ ሂንቴ ኢሶይ ኢሱዋ ዶሳናው ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","ሂንቴ ኢሶይ ኢሱዋራ ዶሴቲኮ ሂንቴ ታ ታማሬ ጊዴይሳ ኣሳ ኡባይ ኤራና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","ሲሞን ጴፂሮሲ ዬሱሳኮ፥ «ጎዳው፥ ኔኒ ኣው ባይ?» ያጊስ። ዬሱሲ ዛሪዲ፥ «ታኒ ቢያሱዋ ኔኒ ሃዒ ካላናው ዳንዳዓካ፥ ሺን ጉዬፔ ታና ካላና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","ጴፂሮሲ፥ «ጎዳው፥ ታኒ ኔና ሃዒ ካላናው ኣይስ ዳንዳዒኪና? ታኒ ኔ ጊሾ ሃይቃናዉካ ጊጋ ኡታስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","ዬሱሲ ዛሪዲ፥ «ታ ጊሾ ሃይቃናው ቱማ ጊጋ ኡታዲ? ታኒ ኔው ቱማ ኦዳይስ፤ ኩቶይ ዋሳናፔ ሲንꬄ ኔኒ ታና ሄꬑ ቶሆ ካዳና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","ዬሱሲ ባ ታማሬታኮ፥ «ሂንቴ ዎዛናይ ኡንዔቶፎ፥ ፆሳ ኣማኒቴ፥ ታናካ ኣማኒቴ። ");
INSERT INTO gofENT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","ታ ኣዋ ኬꬃን ዳሮ ቤሲ ዴዔስ። ታኒ ሂንቴው ቤሴ ጊጊሳናው ባይስ። ሄሳ ጊዶናኮ ታኒ ሂንቴው ኦዲኬሺን። ");
INSERT INTO gofENT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","ታኒ ባዳ ቤሴ ጊጊሲዳፔ ጉዬ ታኒ ዴዒያሱዋን ሂንቴ ዳና ሜላ ሲማ ያዳ ሂንቴና ታኮ ኤፋና። ");
INSERT INTO gofENT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","ሂንቴ ታኒ ቢያሱዋ ኤፊያ ኦጊያ ኤሬታ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","ያቲን፥ ቶማሲ፥ «ጎዳው፥ ኔኒ ቢያሱዋ ኑኒ ኤሮኮ፤ ኦጊያ ዋቲዲ ኤራናው ዳንዳዓኔ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","ዬሱሲ ዛሪዲ፥ «ኦጌይ፥ ቱማይኔ ዴዖይ ታና። ታ ባጋራ ጊዶና ኢፂኮ ኦኒካ ታ ኣዋኮ ባናው ዳንዳዔና። ");
INSERT INTO gofENT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","ሂንቴ ታና ኤሪያባ ጊዲያኮ፥ ታ ኣዋካ ኤራና። ሺን ሂዛፔ ዶሚዲ ሂንቴ ኢያ ኤሬታኔ ኢያ ቤዒዴታ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","ፊልጶሲ ዬሱሳኮ፥ «ጎዳው፥ ኣዋ ኑና ቤሳ፤ ሄሲ ኑስ ጊዳና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","ዬሱሲ ዛሪዲ፥ «ታኒ ሃይሳ ሜላ ዎዴ ሂንቴራ ዴዒንካ ታና ኤሪኪ? ታና ቤዒዳ ኡራይ ኣዋካ ቤዒስ። ያቲን፥ ኔኒ ዎይጋዳ፥ ‹ኣዋ ኑና ቤሳ› ጋይ? ");
INSERT INTO gofENT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","ታኒ ኣዋራ ኢሲኖ ጊዴይሳኔ ኣዋይካ ታራ ኢሲኖ ጊዴይሳ ኔኒ ኣማኒኪዬ? ታኒ ሂንቴው ኦዲያ ቃላ ታኒ ታፔ ኦዲኬ፥ ሺን ታናን ዴዒያ ኣዋይ ባ ኦሱዋ ኦꬄስ። ");
INSERT INTO gofENT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","ታኒ ኣዋን ዴዔይሳኔ ኣዋይካ ታናን ዴዔይሳ ኣማኒቴ። ሄሳ ኣማኖና ኢፂኮ ታ ኦꬂያባታን ታና ኣማኒቴ። ");
INSERT INTO gofENT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","«ታኒ ሂንቴው ቱማ ኦዳይስ፤ ታና ኣማኒያ ኡራይ ታኒ ኦꬂያ ኦሱዋፔ ኣꬊያ ኦሶ ኦꬃና። ታኒ ኣዋኮ ቢያ ጊሾ ታና ኣማኒያ ኦኒካ ሃይሳፌ ኣꬊያ ኦሶ ኦꬃና። ");
INSERT INTO gofENT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","ኣዋይ ናዓ ባጋራ ቦንቼታና ሜላ ታ ሱንꬃን ሂንቴ ዎሲያ ኡባ ታ ሂንቴው ኦꬃና። ");
INSERT INTO gofENT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","ታ ሱንꬃን ኣይቢባካ ሂንቴ ኦይቺኮ ታ ሂንቴው ኦꬃና። ");
INSERT INTO gofENT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","«ሂንቴ ታና ዶሲኮ ታ ኪታ ናጋና። ");
INSERT INTO gofENT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","ታኒ ኣዋ ዎሳና፤ ሂንቴራ ሜሪናው ዳና ሜላ ሚንꬄꬄይሳ ሂንቴው ኢማና። ");
INSERT INTO gofENT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","ሄ ኣያናይ ፆሳ ቱማ ቆንጪሴስ። ሃ ኣላሚያ ኣሳይ ኢያ ቤዖና ጊሾኔ ኤሮና ጊሾ ኢያ ኤካናው ዳንዳዖኮና። ሺን ኢ ሂንቴራ ዴዒያ ጊሾኔ ሂንቴ ጊዶን ዳና ጊሾ ሂንቴ ኢያ ኤሬታ። ");
INSERT INTO gofENT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","«ታኒ ሂንቴና ኣያ ኣዉ ባይና ናዓዳ ሂንቴ ፃላላ ኣጊኬ፤ ሲማዳ ሂንቴኮ ያና። ");
INSERT INTO gofENT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","ጉꬃ ዎዴፔ ጉዬ ኣላሜይ ታና ዛሪ ቤዔና፥ ሺን ሂንቴ ቤዓና። ታኒ ዴዖን ዴዒያ ጊሾ ሂንቴካ ዴዖን ዴዓና። ");
INSERT INTO gofENT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","ታኒ ታ ኣዋን፥ ሂንቴ ታናን፥ ቃሲ ታኒ ሂንቴናን ዴዔይሳ ሂንቴ ሄ ጋላስ ኤራና። ");
INSERT INTO gofENT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","«ታ ኪታ ኤኪዲ ናጌይ ታና ዶሴስ። ታና ዶሴይሳ ታ ኣዋይካ ዶሴስ፤ ታኒካ ኢያ ዶሳይስ፤ ታኒ ኢያው ቆንጫና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","ኣስቆሮታ ዪሁዳ ጊዶና ዪሁዲ ዬሱሳኮ፥ «ጎዳው፥ ኔኒ ዋታዳ ኣላሚያስ ጊዶናሺን ኑስ ኔና ቆንጪሳኔ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","ዬሱሲ ዛሪዲ፥ «ታና ዶሲያ ኦኒካ ታ ቃላስ ኪቴታና። ታ ኣዋይ ኢያ ዶሳና። ቃሲ ታ ኣዋይኔ ታኒ ኢያኮ ዪዲ ኢያራ ዳና። ");
INSERT INTO gofENT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","ታና ዶሶና ኦኒካ ታ ቃላስ ኪቴቴና። ሂንቴ ሲዒያ ቃላይ ታና ኪቲዳ ኣዋባፔ ኣቲን ታባ ጊዴና። ");
INSERT INTO gofENT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","«ታኒ ሂንቴራ ሃዒ ዴዓሼ ሄሳ ሂንቴው ኦዳስ። ");
INSERT INTO gofENT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","ሺን ኣዋይ ታ ሱንꬃን ኪታና ሚንꬄꬂያ ጌሻ ኣያናይ፥ ሂንቴና ኡባባ ታማርሳና። ታኒ ሂንቴው ኦዲዳ ኡባ ኢ ሂንቴና ሃሳዪሳና። ");
INSERT INTO gofENT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","«ሳሮቴꬂ ሂንቴው ኢማና። ታኒ ታ ሳሮቴꬃ ሂንቴው ኢማና። ታ ኢሚያ ሳሮቴꬃይ ኣላሜይ ኢሚያ ሳሮቴꬃ ሜላ ጊዴና። ሄሳ ጊሾ፥ ኡንዔቶፊቴ፥ ያዮፊቴ። ");
INSERT INTO gofENT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","‹ታኒ ባና፥ ሺን ሲማዳ ሂንቴኮ ያና› ጊዳይሳ ሲዒዴታ። ሂንቴ ታና ቱማ ዶሲያባ ጊዲያኮ ታ ኣዋይ ታፔ ኣꬊያ ጊሾ ታኒ ኢያኮ ቤይሳን ሂንቴ ኡፋይታና። ");
INSERT INTO gofENT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","ሄሲ ሃኒያ ዎዴ ሂንቴ ኣማናና ሜላ ሄሲ ሃኖና ዴዒሺን ሲንꬃታዳ ታኒ ሂንቴው ኦዳስ። ");
INSERT INTO gofENT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","«ሃ ኣላሚያ ሃሬይሲ ያ ጊሾ ሂዛፔ ጉዬ ሂንቴራ ዳሮ ኦዴቲኬ። ታና ኢ ኣይኮካ ኦꬃናው ዳንዳዔና። ");
INSERT INTO gofENT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ሺን ታኒ ኣዋ ዶሴይሳ ኣላሜይ ኤራና ሜላ ታ ኣዋይ ታና ኪቲዳይሳ ኡባ ኦꬃይስ። ዴንዲቴ፤ ሃይሳፌ ቦስ። ");
INSERT INTO gofENT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","«ታኒ ዎይኒያ ቱማ ኡባ። ጎሻንቾይ ታ ኣዋ። ");
INSERT INTO gofENT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","ታ ቦላ ዴዒያ ኣይፌ ኣይፎና ታሺያ ኡባ ኢ ካሬስ። ኣይፊያ ታሺያ ካሴይሳፌ ኣꬊ ኣይፋና ሜላ ሄ ታሺያ ኢ ጊጊሳና። ");
INSERT INTO gofENT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","ታኒ ሂንቴው ኦዲዳ ቃላ ጊሾ ሂንቴ ጌሺ። ");
INSERT INTO gofENT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","ታናን ዴዒቴ፤ ታኒካ ሂንቴናን ዴዓና። ዎይኒያ ታሼይ ኡባራ ዴዖና ኢፂኮ ሄ ታሼይ ባርካ ኣይፌ ኣይፋናው ዳንዳዔና። ሄሳዳካ፥ ሂንቴካ ታናን ዴዖና ኢፂኮ ኣይፌ ኣይፋናው ዳንዳዔኬታ። ");
INSERT INTO gofENT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","«ታኒ ዎይኒያ ኡባ፤ ሂንቴ ታሼታ። ታናን ዴዔይሲኔ ታኒ ኢያን ዴዔይሲ፥ ኢ ዳሮ ኣይፌ ኣይፋና። ታ ባይና ሂንቴ ፃላላ ኣይኮካ ኦꬃናው ዳንዳዔኬታ። ");
INSERT INTO gofENT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","ታናን ዶና ኡራይ ታሼዳ ካሬን ዬጊቲዲ ሜላና። ሄሳ ሜላ ታሼቲ ሺቂዲ ታማን ዬጌታና፥ ፁጌታና። ");
INSERT INTO gofENT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","ሂንቴ ታናን ዴዒኮ፥ ታ ቃላይካ ሂንቴናን ዴዒኮ፥ ሂንቴ ኮያባይ ኣይባ ጊዲኮካ ዎሲቴ፤ ሂንቴ ኤካና። ");
INSERT INTO gofENT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","ሂንቴ ዳሮ ኣይፌ ኣይፊያ ታ ታማሬ ጊዲኮ፥ ሄሳን ታ ኣዋይ ቦንቼታና። ");
INSERT INTO gofENT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","ኣዋይ ታና ዶሴይሳዳ ታኒካ ሂንቴና ዶሳይስ፤ ታ ሲቁዋን ዴዒቴ። ");
INSERT INTO gofENT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","ታኒ ታ ኣዋ ኪታ ናጋዳ ኢያ ሲቁዋን ዴዒዳይሳዳ ሂንቴካ ታ ኪታ ናጊኮ ታ ሲቁዋን ዳና። ");
INSERT INTO gofENT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","«ታ ኡፋይሳይ ሂንቴናን ጊዳና ሜላኔ ሂንቴ ኡፋይሳይ ፖሎ ጊዳና ሜላ ታኒ ሂንቴው ሄሳ ኦዳስ። ");
INSERT INTO gofENT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","ታ ኪታይ ሃይሳ፤ ታኒ ሂንቴና ዶሲዳይሳዳ ሂንቴካ ኢሶይ ኢሱዋ ዶሲቴ። ");
INSERT INTO gofENT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","ባ ሼምፑዋ ባ ላጊያስ ኣꬂዲ ኢሜይሳፌ ኣꬊያ ጊታ ሲቆይ ባዋ። ");
INSERT INTO gofENT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","ታኒ ሂንቴና ኪቲዳባ ኡባ ኦꬂኮ ሂንቴ ዶሴቲዳይሳታ። ");
INSERT INTO gofENT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","«ኣይሌይ ባ ጎዳይ ኦꬂያባ ኤሮና ጊሾ ታኒ ሂንቴና ሂዛፔ ጉዬ ኣይሌታ ጊኬ። ሺን ታ ኣዋፔ ሲዒዳ ኡባ ታኒ ሂንቴው ኦዲዳ ጊሾ ሂንቴና ዶሴቲዳይሳታ ጋስ። ");
INSERT INTO gofENT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","ታኒ ሂንቴና ዶራሲፔ ኣቲን ሂንቴ ታና ዶሪቤኬታ። ሂንቴ ቢዲ ꬋዮና ኣይፌ ኣይፋና ሜላ ታኒ ሂንቴና ሹማስ። ያኒኮ ታ ኣዋይ ሂንቴ ታ ሱንꬃን ዎሲዳባ ኡባ ኢማና። ");
INSERT INTO gofENT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","ታ ኪታይ ሃይሳ፡ ኢሶይ ኢሱዋ ዶሲቴ። ");
INSERT INTO gofENT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","«ኣላሜይ ሂንቴና ኢፂኮ ኮይሮቲዲ ታና ኢፂዳይሳ ኣኬኪቴ። ");
INSERT INTO gofENT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","ሂንቴ ኣላሚያባ ጊዲያኮ ኣላሜይ ባባዳ ሂንቴና ዶሳና። ሺን ታኒ ሂንቴና ኣላሜፔ ዶሪዳ ጊሾኔ ሂንቴ ኣላሚያባ ጊዶና ጊሾ ኣላሜይ ሂንቴና ኢፄስ። ");
INSERT INTO gofENT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","‹ኣይሌይ ባ ጎዳፔ ኣꬌና› ጋዳ ታኒ ሂንቴው ኦዲዳይሳ ኣኬኪቴ። ኤንቲ ታና ጎዲዳባ ጊዲኮ ሂንቴናካ ጎዳና። ኤንቲ ታ ቃላ ናጊዳባ ጊዲኮ ሂንቴ ቃላካ ናጋና። ");
INSERT INTO gofENT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","ሺን ኤንቲ ታና ኪቲዳይሳ ኤሮና ጊሾ ሃ ኡባ ታ ጋሶን ሂንቴ ቦላ ኦꬃና። ");
INSERT INTO gofENT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","ታኒ ያዳ ኦዶናባ ጊዲያኮ ኤንታው ናጋራ ጊዴና። ሺን ሃዒ ኤንቲ ኦꬂዳ ናጋራስ ጋሶያባይ ባዋ። ");
INSERT INTO gofENT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","ታና ኢፄይሲ ታ ኣዋካ ኢፄስ። ");
INSERT INTO gofENT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","ኦኒካ ኦꬂቦና ኦሶ ታ ኤንታ ጊዶን ኦꬃቦናባ ጊዲያኮ ኤንታው ናጋራ ጊዶና ኣታና። ሺን ሃዒ ኤንቲ ታኒ ኦꬂዳ ኦሱዋ ቤዒዲ ታናካ ታ ኣዋካ ኢፂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","ሺን ኤንታ ሂጊያን፥ ‹ታና ጮ ኢፂዶሶና› ጌቴቲዲ ፃፌቲዳይሲ ፖሌታና ሜላ ሄሲ ሃኒስ። ");
INSERT INTO gofENT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","«ኣዋፔ ያ ቱማ ቆንጪሲያ ኣያና ታ ሂንቴው ኪታና። ኢ ሂንቴና ሚንꬄꬃና፥ ታባ ማርካታና። ");
INSERT INTO gofENT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","ሂንቴካ ኮይሮፔ ዶሚዲ ታራ ዴዒያ ጊሾ ታባ ማርካታና። ");
INSERT INTO gofENT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","«ታኒ ሄሳ ሂንቴ ኣማኖይ ꬋዮና ሜላ ሂንቴው ኦዳስ። ");
INSERT INTO gofENT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","ኤንቲ ሂንቴና ኣይሁዴ ዎሳ ኬꬃታፔ ኬሲ ዬዳና። ሄሳዳካ፥ ሂንቴና ዎꬊያ ኦኒካ ፆሲ ኮያባ ኦꬂያ ዳኒያ ዎዴይ ያና። ");
INSERT INTO gofENT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","ኤንቲ ሄሳ ሂንቴ ቦላ ኦꬄይ ታና ዎይኮ ኣዋ ኤሮና ጊሾሳ። ");
INSERT INTO gofENT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","ሺን ኤንቲ ሄሳ ሂንቴ ቦላ ኦꬂያ ዎዴይ ጋኪያ ዎዴ ታኒ ሂንቴው ኦዲዲዳይሳ ሂንቴ ኣኬካና ሜላ ታኒ ሂንቴው ሃይሳ ኦዳስ። «ሲንꬃታዳ ታኒ ሃይሳ ሂንቴው ኦዶና ጋምዒዳይ ታ ሂንቴራ ዴዒያ ጊሾሳ። ");
INSERT INTO gofENT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","ሺን ሃዒ ታኒ ታና ኪቲዳይሳኮ ባይስ፤ ሂንቴፌ ኦኒካ፥ ‹ኣዉ ባይ?› ጊዲ ታና ኦይቼይ ባዋ። ");
INSERT INTO gofENT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","ሺን ታኒ ሄሳ ኦዲዳ ጊሾ ሂንቴ ዎዛናን ዳሮ ኣዛኖይ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","ሺን ታኒ ሂንቴው ቱማ ኦዳይስ፤ ታኒ ቢኮ ሂንቴው ሎዖ። ኣይስ ጊኮ፥ ታኒ ቦና ኢፂኮ ሚንꬄꬄይሲ ሂንቴኮ ዬና። ሺን ታኒ ቢኮ ኢያ ሂንቴኮ ዬዳና። ");
INSERT INTO gofENT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","ሚንꬄꬄይሲ ዪዲ፥ ናጋራባ፥ ፂሎቴꬃባኔ ፒርዳባ ሃ ኣላሚያ ኣሳ ኤሪሳና። ");
INSERT INTO gofENT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","ናጋራባይ፥ ኣሳይ ታና ኣማኖና ጊሾሳ። ");
INSERT INTO gofENT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","ፂሎቴꬃባይ፥ ታኒ ኣዋኮ ቢያ ጊሾኔ ሂንቴ ታና ዛሪ ቤዖና ጊሾሳ። ");
INSERT INTO gofENT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ፒርዳባይ፥ ቃሲ ኣላሚያ ሃሬይሲ ፒርዴቲዳ ጊሾሳ። ");
INSERT INTO gofENT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","«ታኒ ሂንቴው ኦዲያባይ ዳሮባይ ዴዔስ፥ ሺን ሃዒ ሂንቴው ጌሌና። ");
INSERT INTO gofENT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","ቱማ ኣያናይ ያ ዎዴ ሂንቴና ቱማቴꬃ ኡባኮ ካሌꬃና። ኢ ሲዒዳባ ኦዴሲፔ ኣቲን ባፔ ኣይቢባካ ኦዴና። ቃሲ ሲንꬃፌ ያናባ ሂንቴው ኢ ኦዳና። ");
INSERT INTO gofENT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","ኢ ታው ዴዔይሳፌ ኤኪዲ ሂንቴው ኦዲያ ጊሾ ኢ ታና ቦንቻና። ");
INSERT INTO gofENT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","ኣዋስ ዴዒያባ ኡባይ ታባ፤ ‹ሚንꬄꬄይሲ ታው ዴዔይሳፌ ኤኪዲ ሂንቴው ኦዳና› ታኒ ጊዳይ ሄሳሳ። ");
INSERT INTO gofENT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","«ጉꬃ ዎዴፔ ጉዬ ታና ቤዔኬታ፤ ቃሲ ጉꬃ ዎዴፔ ጉዬ ሂንቴ ታና ቤዓና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","ኢያ ታማሬታፔ ኢሶቲ ኢሶቲ ባንታ ጊዶን፥ «ጉꬃ ዎዴፔ ጉዬ ሂንቴ ታና ቤዔኬታ፤ ቃሲ ጉꬃ ዎዴፔ ጉዬ ሂንቴ ታና ቤዓና፤ ቃሲካ ታኒ ኣዋኮ ባይስ ጉሳይ ዎይ ጉሴ?» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","«ጉꬃ ዎዴፔ ጉዬ ጌይሲ ዎይ ጉሴ? ኢ ኣይ ኦዴቲያኮ ኑስ ኤሬቴና» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","ኤንቲ ባና ኦይቻናው ኮዬይሳ ዬሱሲ ኤሪዲ፥ «ታኒ፥ ‹ጉꬃ ዎዴፔ ጉዬ ታና ቤዔኬታ፤ ቃሲ ጉꬃ ዎዴፔ ጉዬ ሂንቴ ታና ቤዓና› ጊዳይሳስ ሂንቴ ኢሶይ ኢሱዋ ኦይቼቲ? ");
INSERT INTO gofENT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","ታኒ ሂንቴው ቱማ ኦዳይስ፤ ሂንቴ ዬካናኔ ኣፉፃና፥ ሺን ሃ ኣላሜይ ኡፋይታና። ሃዒ ሂንቴ ኣዛናና፥ ሺን ሂንቴ ኣዛኖይ ኡፋይሳን ላሜታና። ");
INSERT INTO gofENT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","ኢሲ ማጫሲያ ናዓ ዬላና ሃኒያ ዎዴ ባ ዬሎ ዎዴይ ጋኪዳ ጊሾ ሂርጋዉሱ። ሺን ናዓ ዬሊዳፔ ጉዬ ናዒ ሃ ኣላሚያን ዬሌቲዳ ኡፋይሳ ጊሾ ባ ኡንዓ ዶጋዉሱ። ");
INSERT INTO gofENT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","ሄሳዳካ፥ ሂንቴካ ሂንቴ ዎዛናን ኣዛኔታ፥ ሺን ታኒ ሂንቴና ዛራዳ ቤዓና። ሂንቴ ዎዛናይ ዳሮ ኡፋይታና፤ ሄ ኡፋይሳ ኦኒካ ሂንቴፌ ኤኬና። ");
INSERT INTO gofENT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","«ሄ ጋላስ ሂንቴ ታና ኣይቢባካ ዎሴኬታ። ታኒ ሂንቴው ቱማ ኦዳይስ፤ ሂንቴ ታ ሱንꬃን ዎሲያባ ኡባ ኣዋይ ሂንቴው ኢማና። ");
INSERT INTO gofENT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","ሃዒ ጋካናው ታ ሱንꬃን ኣይቢባካ ዎሲቤኬታ። ሂንቴ ኡፋይሳይ ፖሎ ጊዳና ሜላ ፆሳ ዎሲቴ፤ ሂንቴ ኤካና። ");
INSERT INTO gofENT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","«ታኒ ሃዒ ጋካናው ሂንቴው ሌሚሶን ኦዳስ፥ ሂዛፔ ታኒ ሌሚሶን ኦዶና ዎዴይ ያና። ሺን ኣዋባ ታኒ ሂንቴው ቆንጬን ኦዳና። ");
INSERT INTO gofENT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","ሄ ጋላስ ሂንቴ ታ ሱንꬃን ኣዋ ዎሳና፤ ሂንቴ ጊሾ ታኒ ኣዋ ዎሲኬ። ");
INSERT INTO gofENT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","ኣይስ ጊኮ፥ ኣዋይ ባ ሁዔን ሂንቴና ዶሴስ። ሂንቴ ታና ዶሲያ ጊሾኔ ታኒ ኣዋ ማታፔ ዪዳይሳ ኣማኒዳ ጊሾ ኢ ሂንቴና ዶሴስ። ");
INSERT INTO gofENT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","ታኒ ኣዋ ማታፔ ሃ ኣላሚያ ያስ፤ ቃሲ ኣላሚያ ኣጋዳ ኣዋኮ ባና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","ኢያ ታማሬቲ ዛሪዲ፥ «ሄኮ፥ ሃዒ ኔኒ ቆንጬን ኦዳሳ፤ ሌሚሶን ኣይኮካ ኦዳካ። ");
INSERT INTO gofENT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","ኔኒ ኡባባ ኤሬይሳ ኑኒ ሃዒ ኤሮስ፤ ቃሲ ኔና ኦኒካ ኦይቻና ሜላ ኔኒ ኮያካ። ሄሲ ኑና ኔኒ ፆሳፌ ኪቴቲዳይሳ ኣማንꬄስ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","ያቲን፥ ዬሱሲ ዛሪዲ ኤንታኮ፥ «ሃዒ ኣማኔቲ? ");
INSERT INTO gofENT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","ሄኮ፥ ሂንቴ፥ ሂንቴ ሶ ሂንቴ ሶ ላሌቲያ ዎዴይኔ ታ ፃላላ ዬጊ ኣጊዲ ባቃቲያ ዎዴይ ያና፤ ሃዒካ ዪኪቺስ። ሺን ኣዋይ ታራ ዴዒያ ጊሾ ታ ታ ፃላላ ጊዲኬ። ");
INSERT INTO gofENT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","ሂንቴ ታራ ዴዒሼ ሳሮይ ሂንቴው ዳና ሜላ ታኒ ሄሳ ኦዳስ። ኣላሜን ዴዒሼ ሂንቴ ዋዬታና። ሺን ሚኒቴ፤ ታኒ ኣላሚያ ፆናስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","ዬሱሲ ሄሳ ኦዲዳፔ ጉዬ ፑዴ ሳሎ ፄሊዲ፥ ሃይሳዳ ያጊስ፡ «ኣዋው፥ ሳቴይ ጋኪስ፤ ኔ ናዓይ ኔና ቦንቻና ሜላ ኔኒ ኔ ናዓ ቦንቻ። ");
INSERT INTO gofENT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","ኔኒ ኢያው ኢሚዳ ኡባስ ኢ ሜሪና ዴዑዋ ኢማና ሜላ ኣሳ ኡባ ቦላ ኢያው ማታ ኢማዳሳ። ");
INSERT INTO gofENT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","ሜሪና ዴዖይ፥ ኔና፥ ኢሲ ቱማ ፆሳኔ ኔ ኪቲዳ ዬሱስ ኪሪስቶሳ ኤሮ። ");
INSERT INTO gofENT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","ኔኒ ታ ኦꬃና ሜላ ኢሚዳ ኦሱዋ ፖላዳ ኔና ሳዓን ቦንቻስ። ");
INSERT INTO gofENT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","ሃዒካ፥ ኣዋው፥ ኣላሜይ ሜꬌታናፔ ሲንꬄ ኔ ማታን ታው ዴዒያ ቦንቹዋን ታና ቦንቻ። ");
INSERT INTO gofENT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","«ኣላሚያ ኣሳፔ ኔኒ ታው ኢሚዳይሳታ ኔና ኤሪሳስ። ኤንቲ ኔይሳታ፤ ኔኒ ኤንታ ታው ኢማዳሳ። ኤንቲ ኔ ቃላስካ ኪቴቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","ኔኒ ታው ኢሚዳ ኡባባይ ኔፔ ዪዳይሳ ኤንቲ ሃዒ ኤሮሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","ኔኒ ታው ኢሚዳ ቃላ ታኒ ኤንታው ኢማስ፤ ኤንቲካ ሄ ቃላ ኤኪዶሶና። ታኒ ኔ ማታፔ ዪዳይሲ ቱማ ጊዴይሳ ኤሪዲ ኔኒ ታና ኪቲዳይሳካ ኣማኒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","«ታኒ ኤንታው ዎሳይስ። ኤንቲ ኔይሳታ ጊዲያ ጊሾ ኔኒ ታው ኢሚዳ ኣሳስ ዎሳይሲፔ ኣቲን ኣላሚያስ ዎሲኬ። ");
INSERT INTO gofENT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","ታው ዴዒያ ኡባባይ ኔባ፤ ኔው ዴዒያ ኡባይካ ታባ። ታኒ ኤንታ ባጋራ ቦንቼታስ። ");
INSERT INTO gofENT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","ታኒ ሂዛፔ ጉዬ ኣላሜን ዴዒኬ፤ ኤንቲ ኣላሜን ዴዖሶና። ታኒ ሃዒ ኔኮ ባይስ። ጌሻ ኣዋው፥ ሃ ኔኒ ታው ኢሚዳይሳቲ ኔራኔ ታራ ኢሲኖ ጊዲዳይሳዳ ኤንቲ ኢሲኖ ጊዳና ሜላ ኤንታ ኔ ታው ኢሚዳ ኔ ሱንꬃን ናጋ። ");
INSERT INTO gofENT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","ታኒ ኤንታራ ሳዓን ዴዓሼ፥ ኔ ታው ኢሚዳ ኔ ሱንꬃ ዎልቃን ኤንታ ናጋስ። ጌሻ ማፃፋይ ጊዳይሲ ፖሌታና ሜላ ꬋዮይ ቤሲያ ኡራፔ ኣቲን ኤንታፌ ሃሪ ኦኒካ ꬋዪቤና። ");
INSERT INTO gofENT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","«ሃዒ ታኒ ኔኮ ባይስ። ታ ኡፋይሳይ ኤንታ ዎዛናን ፖሎ ጊዳና ሜላ ሃይሳ ታኒ ኣላሜን ዴዓሼ ኦዳይስ። ");
INSERT INTO gofENT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","ታኒ ኤንታው ኔ ቃላ ኢማስ። ታኒ ኣላሜፔ ጊዶናይሳዳ፥ ኤንቲካ ኣላሜፔ ጊዶና ጊሾ ኣላሜይ ኤንታ ኢፂስ። ");
INSERT INTO gofENT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","ኔኒ ፃላሄፔ ኤንታ ናጋና ሜላፔ ኣቲን ኣላሜፔ ኬሳና ሜላ ዎሲኬ። ");
INSERT INTO gofENT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","ታኒ ኣላሜፔ ጊዶናይሳዳ ኤንቲካ ኣላሜፔ ጊዶኮና። ");
INSERT INTO gofENT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","ኔኒ ኔ ቱማቴꬃን ኤንታ ኔባ ኦꬃ፤ ኔ ቃላይካ ቱማ። ");
INSERT INTO gofENT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","ኔኒ ታና ኣላሚያ ኪቲዳይሳዳ ታኒካ ኤንታ ኣላሚያ ኪታስ። ");
INSERT INTO gofENT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","ቃሲ ኤንቲ ቱማ ኔባ ጊዳና ሜላ ኤንታ ጊሾ ታኒ ታ ሁዒያ ኔው ኢማይስ። ");
INSERT INTO gofENT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","«ታኒ ኤንታ ፃላላስ ጊዶናሺን ኤንቲ ቃላ ኦዲን፥ ታና ኣማናናይሳታስካ ዎሳይስ። ");
INSERT INTO gofENT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","ኤንቲ ኡባይ ኢሲኖ ጊዳና ሜላ ታኒ ዎሳይስ። ኣዋው፥ ኔ ታናን ዴዔይሳዳ፥ ቃሲ ታ ኔናን ዴዔይሳዳ ኤንቲ ኑናን ዳና ሜላ ዎሳይስ። ሄ ዎዴ ኔኒ ታና ኪቲዳይሳ ኣላሜይ ኣማናና። ");
INSERT INTO gofENT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","ኔኒኔ ታኒ ኢሲኖ ጊዴይሳዳ፥ ኤንቲ ኢሲኖ ጊዳና ሜላ፥ ኔኒ ታና ቦንቺዳይሳዳ፥ ታኒካ ኤንታ ቦንቻስ። ");
INSERT INTO gofENT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","ታኒ ኤንታን፥ ኔኒ ታናን ዴዔይሳዳ ኤንቲ ፖሎ ኢሲኖ ጊዳና ሜላ ኔና ዎሳይስ። ሄሲካ፥ ኔ ታና ኪቲዳይሳኔ ኔ ታና ዶሲዳ ዶሱዋን ኤንታ ዶሲዳይሳ ኣላሜይ ኤራን ሜላሳ። ");
INSERT INTO gofENT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","«ኣዋው፥ ኔኒ ታው ኢሚዳይሳቲ ታኒ ዴዒያሱዋን ታራ ዳና ሜላ ኮያይስ። ኣላሜይ ሜꬌታናፔ ሲንꬄ ኔኒ ታና ዶሲዳ ጊሾ ታው ኢሚዳ ታ ቦንቹዋ ኤንቲ ቤዓና። ");
INSERT INTO gofENT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","«ጌሻ ኣዋው፥ ኣላሜይ ኔና ኤሬና፥ ሺን ታኒ ኤራይስ። ቃሲ ኔኒ ታና ኪቲዳይሳ ሃይሳቲ ኤሮሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","ኔኒ ታና ሲቂዳ ሲቆይ ኤንታናን ዳና ሜላ፥ ቃሲ ታኒ ኤንታናን ጊዳና ሜላ፥ ታኒ ኔ ሱንꬃ ኤንታ ኤሪሳስ፤ ሲንꬃስካ ኤሪሳና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","ዬሱሲ ዎሳ ኦንጊዳፔ ጉዬ ባ ታማሬታራ ቄዲሮና ዛንጋራ ፒኒዲ፥ ሄ ቤሳን ዴዒያ ኣታኪልቲያ ጊዶ ጌሊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","ዬሱሲ ኡባ ዎዴ ባ ታማሬታራ ያን ሺቂያ ጊሾ ዬሱሳ ኣꬂ ኢሚዳ ዪሁዲ ሄ ቤሳ ኤሬስ። ");
INSERT INTO gofENT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","ሄሳ ጊሾ፥ ዪሁዲ ፓኖሴ፥ ፆምፔ፥ ቶራኔ ጎንዳሌ ኦይኪዳ ዳሮ ዎታዳሬታ፥ ካሂኔ ሃላቃቲኔ ፋሪሳዌቲ ኪቲዳ ፆሳ ኬꬃ ናጊያ ፖሊሴታ ካሌꬂ ኤኪዲ፥ ሄ ቤሳ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","ዬሱሲ ባና ጋካና ሃኒያባ ኡባ ኤሪዲ፥ ጋፃ ኬዪዲ፥ «ኦና ኮዬቲ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","ኤንቲ ዛሪዲ፥ «ናዚሬቴ ዬሱሳ ኮዮስ» ያጊዶሶና። ኢ ዛሪዲ፥ «ታኒ ዬሱሳ» ያጊስ። ዬሱሳ ኣꬂ ኢሚዳ ዪሁዲ ያን ኤንታራ ኤቂስ። ");
INSERT INTO gofENT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","ኢ፥ «ታኒ ዬሱሳ» ጊዳ ዎዴ ኤንቲ ጉዬ ሺቂዲ፥ ሳዓን ኩንዲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","ዬሱሲ ቃሲካ፥ «ኦና ኮዬቲ?» ያጊዲ ኦይቺስ። ኤንቲ፥ «ናዚሬቴ ዬሱሳ ኮዮስ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","ኢ ዛሪዲ፥ «ታኒ ዬሱሳ ጊዴይሳ ሂንቴው ኦዳስ። ሂዛ፥ ሂንቴ ታና ኮያባ ጊዲኮ ሃይሳታ ዬዲቴ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","ኢ ሄሳ ጊዳይ፥ «ኣዋው፥ ኔኒ ታው ኢሚዳይሳታፔ ሃሪ ኣቶሺን ኢሱዋካ ꬋይሳቢኬ» ጊዳይሲ ፖሌታና ሜላሳ። ");
INSERT INTO gofENT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","ሲሞን ጴፂሮሳስ ማሺ ዴዔስ። ኢ ሄ ማሻ ሾዲዲ ካሂኔ ሃላቃ ኣይሊያስ ኡሻቻ ሃይꬃ ሾጪዲ፥ ቃንፂ ዬጊስ። ሄ ኣይሊያ ሱንꬃይ ማልኮሳ። ");
INSERT INTO gofENT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","ዬሱሲ ጴፂሮሳኮ፥ «ኔ ማሻ ሾሁዋን ዛራ። ታ ኣዋይ ታው ኢሚዳ ፁዓፔ ታኒ ኡዮናባ ኔው ዳኒ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","ሮሜ ዎታዳሬቲኔ ኤንታ ሃላቃይ ፆሳ ኬꬃ ናጊያ ፖሊሴታራ ኢሲፌ ዬሱሳ ኦይኪዲ ቃቺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","ኮይሮ ዬሱሳ ሃናኮ ኤፊዶሶና። ሃኒ ሄ ላይꬂ ካሂኔ ሃላቃ ጊዲያ ቃያፋ ቦሎ። ");
INSERT INTO gofENT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","ቃያፊ፥ «ኣሳ ኡባ ጊሾ ኢሲ ኣሲ ሃይቂኮ ሎዖ» ጊዲ ካሴ ኣይሁዴታ ዞሪዳይሳ። ");
INSERT INTO gofENT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","ሲሞን ጴፂሮሲኔ ሃራ ኢሲ ታማሬይ ዬሱሳ ካሊዲ ቢዶሶና። ካሂኔ ሃላቃይ ሄ ሃራ ታማሪያ ሎይꬂ ኤሬስ። ሄሳ ጊሾ፥ ኢ ዬሱሳራ ካሂኔ ሃላቃ ዛባ ጌሊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","ሺን ጴፂሮሲ ካሬራ ዲርሳ ፔንጌን ኤቂስ። ካሂኔ ሃላቃይ ኤሪያ ሃራ ታማሬይ ካሬ ኬዪዲ፥ ፔንጊያ ናጊያ ናዔስ ኦዲዲ፥ ጴፂሮሳ ጋꬂ ጌልሲስ። ");
INSERT INTO gofENT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","ፔንጊያ ናጊያ ናዒያ ጴፂሮሳኮ፥ «ኔኒ፥ ሄ ኣዲያ ታማሬታፔ ኢሱዋ ጊዲኪ?» ያጋሱ። ጴፂሮሲ ዛሪዲ፥ «ኣካይ፥ ታኒ ጊዲኬ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","ሳዓይ ሜጊያ ጊሾ ኣይሌቲኔ ናጌይሳቲ ፂፋ ታማ ኤꬂዲ፥ ዩዪ ኣꬊ ኤቂዲ ካዮሶና። ጴፂሮሲካ ኤንታራ ኤቂዲ ታማ ካዬስ። ");
INSERT INTO gofENT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","ካሂኔ ሃላቃይ ዬሱሳ፥ ኢያ ታማሬታባኔ ኢያ ቲሚርቲያባ ኦይቺስ። ");
INSERT INTO gofENT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","ዬሱሲ ዛሪዲ፥ «ታኒ ኣሳ ኡባስ ቆንጬን ኦዳስ። ታኒ ኣይሁዴ ኡባይ ሺቂያ ኣይሁዴ ዎሳ ኬꬃኒኔ ፆሳ ኬꬃን ኡባ ዎዴ ታማርሳስ። ጌማን ኣይኮካ ኦዳቢኬ። ");
INSERT INTO gofENT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","ያቲን፥ ኔኒ ታና ኣይስ ኦይቻይ? ታ ኦዲሺን ሲዒዳ ኣሳ ኦይቻ። ሄ ኣሳይ ታኒ ኦዲዲዳይሳ ኤሮሶና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","ዬሱሲ ሄሳ ጊዳ ዎዴ ሄ ቤሳን ኤቂዳ ዎታዳሬታፔ ኢሶይ ዬሱሳ ባቂዲ፥ «ካሂኔ ሃላቃስ ሃይሳዳ ዛራይ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","ዬሱሲ ዛሪዲ፥ «ታኒ ኢታባ ኦዲዳባ ጊዲኮ ሃይሳን ዴዒያ ኣሳ ኡባ ሲንꬃን ኦዳ። ሺን ታኒ ቱማ ኦዲዳባ ጊዲኮ ታና ኣይስ ባቃይ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","ሄሳ ጊሾ፥ ሃኒ፥ ዬሱሲ ቃሼቲዳ ሜላ ካሂኔ ሃላቃ ቃያፋኮ ዬዲስ። ");
INSERT INTO gofENT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","ጴፂሮሲ ያን ኤቂዲ፥ ታማ ካዪሺን፥ ሃራቲ ኢያኮ፥ «ኔኒ ሃ ኣዲያ ታማሬታፔ ኢሱዋ ጊዲኪ?» ያጊስ። ጴፂሮሲ ዛሪዲ፥ «ኣካይ፥ ታኒ ጊዲኬ» ያጊዲ ካዲስ። ");
INSERT INTO gofENT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","ካሂኔ ሃላቃ ኣይሌታፔ ኢሶይ፥ ጴፂሮሲ ሃይꬃ ቃንፂዳ ኣዲያ ዳቦይ፥ ጴፂሮሳኮ፥ «ታኒ ኔና ኢያራ ኣታኪልቲያ ጊዶን ቤዓቢኪና?» ያጊዲ ኦይቺስ። ");
INSERT INTO gofENT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","ጴፂሮሲ ቃሲካ ካዲስ። ሶሁዋራ ኩቶይ ዋሲ ኣጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","ዎንታ ጉራ፥ ኤንቲ ዬሱሳ ቃያፋ ሶፔ ዴሪያ ሃሬይሳ ኦሶ ኬꬂ ኤፊዶሶና። ኣይሁዴቲ ፓሲካ ባሌ ካꬃ ማናው ባንታና ቱኒሶና ሜላ ዴሪያ ሃሬይሳ ኦሶ ኬꬃ ጌሊቦኮና። ");
INSERT INTO gofENT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","ሄሳ ጊሾ፥ ጲላፆሲ ኤንታኮ ካሬ ኬዪዲ፥ «ሃ ኣዲያ ኣይስ ሞቴቲ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","ኤንቲ፥ «ኢ ኢታ ኦꬆናባ ጊዲያኮ ኑኒ ኢያ ኔኮ ኤሆኮ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","ጲላፆሲ ዛሪዲ፥ «ሂንቴ ኢያ ኤኪ ኤፊዲ፥ ሂንቴ ሂጌይ ጌይሳዳ ኢያ ቦላ ፒርዲቴ» ያጊስ። ኣይሁዴቲ፥ «ኦናካ ዎꬊያ ማቲ ኑስ ባዋ» ያጊዶሶና፤ ");
INSERT INTO gofENT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","ሄሲ ሃኒዳይ ዬሱሲ ኣይ ሜላ ሃይቆ ሃይቃኔኮ ኤሪሳናው ኦዲዳይሲ ፖሌታናሳ። ");
INSERT INTO gofENT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","ጲላፆሲ ባ ኦሶ ኬꬃ ዛሪ ጌሊዲ፥ ዬሱሳ ፄጊዲ፥ «ኔኒ ኣይሁዴ ካዎ?» ያጊዲ ኦይቺስ። ");
INSERT INTO gofENT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","ዬሱሲ ጲላፆሳ፥ «ሃ ኦይሻ ኔኒ ኔፔ ኦይቻዬ ዎይኮ ሃራ ኣሲ ኔው ታባ ኦዲዴ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","ጲላፆሲ ዛሪዲ፥ «ታ ኣይሁዴ ኣሴ? ኔ ኣሳይኔ ካሂኔ ሃላቃቲ ኔና ታው ኣꬂ ኢሚዶሶና። ኔ ኣይ ኦꬃዲ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","ዬሱሲ፥ «ታ ካዎቴꬃይ ሃ ኣላሚያና ጊዴና። ኢ ሃይሳን ጊዲያኮ ታ ኣይሁዴታ ሃላቃታስ ኣꬋ ኢሜቶና ሜላ ታ ኣይሌቲ ታው ኦሌታና። ሺን ታ ካዎቴꬃይ ሃ ኣላሚያና ጊዴና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","ሄሳ ጊሾ፥ ጲላፆሲ ዬሱሳኮ፥ «ያቲን፥ ኔኒ ካዎዬ?» ያጊዲ ኦይቺስ። ዬሱሲ ዛሪዲ፥ «ቱማ ታ ካዎ ጊዴይሳ ኔ ጋዳሳ። ታኒ ዬሌቲዳይኔ ሃ ኣላሚያ ዪዳይ ቱማቴꬃስ ማርካታናሳ። ቱማ ባጋ ጊዲዳ ኦኒካ ታኒ ጌይሳ ሲዔስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","ጲላፆሲ፥ «ቱሚ ኣይቤ?» ያጊስ። ጲላፆሲ ሄሳ ጊዳፔ ጉዬ ኣይሁዴታኮ ካሬ ኬዪዲ፥ «ታኒ ኢያፔ ኣይ ኢታካ ዴማቢኬ። ");
INSERT INTO gofENT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","ሺን ፓሲካ ባሌ ጋላስ፥ ኢሲ ኣሴ ሂንቴው ቃሾፔ ቢሊያ ሜዜይ ዴዔስ። ታኒ ሂንቴው ኣይሁዴታ ካዉዋ ቢላና ሜላ ኮዬቲ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","ኤንቲ ዛሪዲ፥ ባንታ ቃላ ꬎቁ ኦꬂዲ፥ «ባርባና ቢላፌ ኣቲን ኢያ ጊዴና» ያጊዶሶና። ሺን ባርባኒ ፓንጋ። ");
INSERT INTO gofENT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","ሄሳፌ ጉዬ፥ ጲላፆሲ ዬሱሳ ጋራፊሲስ። ");
INSERT INTO gofENT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","ዎታዳሬቲ ኣጉንꬃ ካላቻ ሜꬊዲ ኢያ ሁዔን ዎꬂዶሶና። ቃሲ ዞዖ ማዖ ኢያ ማይዚዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","ኢያኮ ሺቂዲ፥ «ኣይሁዴ ካዉዋው፥ ሜሪናው ካዎታ» ያጊዲ ኢያ ባቂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","ጲላፆሲ ቃሲካ ካሬ ኬዪዲ፥ ኣይሁዴታኮ፥ «ሄኮ፥ ታኒ ኢያፔ ኣይ ኢታካ ዴማቦናይሳ ሂንቴ ኤራና ሜላ ኢያ ሂንቴኮ ካሬ ኬሳና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","ሄሳፌ ጉዬ፥ ዬሱሲ ኣጉንꬃ ካላቻ ባ ሁዔን ዎꬂዲ፥ ዞዖ ማዖ ማዒዲ፥ ካሬ ኬዪስ። ጲላፆሲ ኣይሁዴታኮ፥ «ኡራ ሃይሳ ቤዒቴ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","ካሂኔ ሃላቃቲኔ ፆሳ ኬꬃ ናጌይሳቲ ኢያ ቤዒዳ ዎዴ ባንታ ቃላ ꬎቁ ኦꬂዲ፥ «ማስቃሊያ ቦላ ካቃ! ካቃ!» ያጊዶሶና። ጲላፆሲ ኤንታኮ፥ «ሂንቴ ኢያ ኤፊዲ፥ ማስቃሊያ ቦላ ካቂቴ። ታኒ ኢያፔ ኣይ ኢታካ ዴማቢኬ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","ኣይሁዴቲ ዛሪዲ፥ «ኑስ ሂጌይ ዴዔስ። ኢ ባና ፆሳ ናዓ ኦꬂዳ ጊሾ ኑ ሂጊያꬆ ኢ ሃይቃናው ቤሴስ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","ጲላፆሲ ሄሳ ሲዒዳ ዎዴ ካሴይሳፌ ዳሮ ያዪስ። ");
INSERT INTO gofENT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","ቃሲካ ጲላፆሲ ባ ኦሶ ኬꬂ ሲሚ ጌሊዲ ዬሱሳኮ፥ «ኔኒ ኣዉፔ ያዲ?» ያጊዲ ኦይቺስ። ሺን ዬሱሲ ኢያው ኣይኮካ ዛሪቤና። ");
INSERT INTO gofENT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","ሄሳ ጊሾ፥ ጲላፆሲ፥ «ታው ኦዲኪ? ኔና ቢላናው ዎይኮ ማስቃሊያ ቦላ ካቃናው ታው ማቲ ዴዔይሳ ኤሪኪ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","ዬሱሲ፥ «ፆሳይ ኔው ማታ ኢሚቦናባ ጊዲያኮ ታ ቦላ ማቲ ኔው ዴናሺን። ሄሳ ጊሾ፥ ታና ኔው ኣꬂ ኢሚዳይስ ኣꬊያ ናጋራ ኦꬂስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","ጲላፆሲ ሄሳ ሲዒዳ ዎዴ ዬሱሳ ቢላናው ኦጌ ኮዪስ። ሺን ኣይሁዴቲ ባንታ ቃላ ꬎቁ ኦꬂዲ፥ «ኔኒ ኢያ ቢሊያባ ጊዲኮ ካዉዋ ቄሳሬ ባጋ ጊዳካ። ባና ካዎ ጊያ ኦኒካ ቄሳሬ ሞርኬ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","ጲላፆሲ ሄሳ ሲዒዲ ዬሱሳ ካሬ ኬሲስ። ያቲዲ፥ «ሎቼ ሹቺ» ጊያሶን ፒርዳ ኦይዲያን ኡቲስ። ኢብራይስፄ ቃላን ሄ ቤሳይ «ጋባታ» ጉሱ። ");
INSERT INTO gofENT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","ሄ ጋላሳይ ፓሲካ ባሌ ቦንቻናው ጊጌቴꬃ ጋላስ። ሄ ዎዴ ሳዒ ኡሱፑን ሳቴ ሄራ። ጲላፆሲ ኣይሁዴታኮ፥ «ሂንቴ ካዉዋ ሃይሳ ቤዒቴ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","ኣይሁዴቲ ባንታ ቃላ ꬎቁ ኦꬂዲ፥ «ዲጋ! ዲጋ! ማስቃሊያ ቦላ ካቃ» ያጊዶሶና። ጲላፆሲ ዛሪዲ፥ «ሂንቴ ካዉዋ ታኒ ማስቃሊያ ቦላ ካቃናይሳ ኮዬቲ?» ያጊዲ ኦይቺስ። ካሂኔ ሃላቃቲ፥ «ቄሳሬፔ ሃራ ካዎይ ኑስ ባዋ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","ሄሳፌ ጉዬ፥ ኤንቲ ዬሱሳ ማስቃሊያ ቦላ ካቃና ሜላ ጲላፆሲ ኤንታው ኣꬂ ኢሚስ። ኤንቲ ዬሱሳ ኦይኪዲ ኤፊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","ዬሱሲ ባ ማስቃሊያ ቶኪዲ፥ «ሁዔ ጉጌ» ጊያ ቤሳ ቢስ። «ሁዔ ጉጌ» ጉሳይ ኢብራይስፄ ቃላን «ጎልጎታ» ጉሱ። ");
INSERT INTO gofENT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","ኤንቲ ሄ ቤሳን ማስቃሊያ ቦላ ዬሱሳ ካቂዶሶና። ቃሲ ኢያራ ሃራ ናምዑ ኣሳታ፥ ኢሱዋ ያ ባጋራ ሃንኩዋ ሃ ባጋራ ማስቃሊያ ቦላ ካቂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","ጲላፆሲ፥ «ኣይሁዴታ ካዉዋ፥ ናዚሬቴ ዬሱሳ» ያጊያ ፁፌ ፃፊዲ ማስቃሊያ ቦላ ዎꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","ዬሱሲ ማስቃሊያ ቦላ ካቄቲዳ ቤሳይ ካታማስ ማታን ዴዒያ ጊሾ ዳሮ ኣይሁዴቲ ሄ ፁፊያ ናባቢዶሶና። ፁፌይ ፃፌቲዳይ ኢብራይስፄ ዶናን፥ ላቲኔ ዶናኒኔ ጊሪኬ ዶናና። ");
INSERT INTO gofENT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","ሄሳ ጊሾ፥ ካሂኔ ሃላቃቲ ጲላፆሳኮ፥ « ‹ሃ ኣዴይ ባና ኣይሁዴ ካዎ ያጊስ› ጋዳ ፃፋፔ ኣቲን ‹ኣይሁዴ ካዎ› ጋዳ ፃፎፓ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","ያቲን፥ ጲላፆሲ፥ «ታ ፃፊዳይሳ ፃፋስ» ያጊዲ ዛሪስ። ");
INSERT INTO gofENT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","ዎታዳሬቲ ማስቃሊያ ቦላ ኢያ ካቂዳፔ ጉዬ ኢያ ማዑዋ ኤኪዲ፥ ኦይዱ ቤሳን ሻኪዲ፥ ኢሶ ኢሶ ኤኪዶሶና። ዬዳ ማዔቲያ ኢያ ኣዱሳ ማዑዋ ኤኪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","ዎታዳሬቲ፥ «ኦና ጋካኔኮ፥ ሳማ ዬጋናፔ ኣቲን ማዑዋ ፔꬎኮ» ያጊዶሶና። ሄሲ ሃኒዳይ ጌሻ ማፃፋን፥ «ታ ማዑዋ ሻኪ ኤኪዶሶና፤ ታ ኣዱሳ ማዑዋ ቦላካ ሳማ ዬጊዶሶና» ጌቴቲዳይሲ ፖሌታና ሜላሳ። ሄሳ ጊሾ፥ ዎታዳሬቲ ሄሳ ኦꬂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","ሺን ዬሱሳ ማስቃሊያ ማታን ኢያ ኣያ፥ ኢያ ኣዬ ሚቺያ፥ ቄሊዮጴ ማቺያ ማይራማኔ ማግዴላ ማይራማ ኤቂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","ዬሱሲ ባ ኣዪዉኔ ኢ ዶሲያ ታማሬይ ያን ኤቂዳይሳታ ቤዒዲ፥ ባ ኣዬኮ፥ «ታ ኣዬ፥ ኔ ናዓ ሃይሳ ቤዓ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","ሄሳፌ ጉዬ፥ ሄ ታማሪያኮ፥ «ኔ ኣዪው ሃኖ ቤዓ» ያጊስ። ሄ ታማሬይ ኢዮ ሄ ዎዴፔ ዶሚዲ ባራ ዳና ሜላ ሶ ኤፊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","ሄሳፌ ጉዬ፥ ዬሱሲ ኡባይ ሃዒ ፖሌቲዳይሳ ኤሪዲ፥ ጌሻ ማፃፋን ፃፌቲዳይሲ ፖሌታና ሜላ «ታና ሳሜስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","ሄ ቤሳን ኢሲ ፁጋ ኩሜꬃ ጫላ ዎይኔይ ዴዔስ። ኤንቲ ኢስፖንጄ ሄ ዎይኒያን ዬጊዲ፥ ሂሶጴ ሚꬃ ፄራን ዎꬂዲ፥ ዬሱሳ ዶናኮ ሺሺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","ዬሱሲ ዎይኒያ ጋንፂ ቤዒዲ፥ «ፖሌቲስ» ያጊስ። ሄሳፌ ጉዬ፥ ባ ሁዒያ ዚቂ ኦꬂዲ ባ ሼምፑዋ ኢሚስ። ");
INSERT INTO gofENT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","ሄ ጋላሳይ ጊጌቴꬃ ጋላስ ጊዲያ ጊሾኔ ዎንቴꬃ ጋላሳይ ቦንቾ ሳምባታ ጊዲያ ጊሾ ኣሳታ ኣሃይ ማስቃሊያ ቦላ ሳምባታ ጋላስ ፔዖና ሜላ ኤንታ ቶሁዋ ሜንꬂዲ፥ ማስቃሊያፔ ዎꬊሳና ሜላ ኣይሁዴቲ ጲላፆሳ ዎሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","ሄሳ ጊሾ፥ ዎታዳሬቲ ቢዲ፥ ዬሱሳራ ካቄቲዳ ናምዑ ኣሳታ ቶሁዋ ሜንꬂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","ሺን ዬሱሳኮ ዪዳ ዎዴ ኢ ሃይቂዳይሳ ቤዒዲ፥ ኢያ ቶሁዋ ሜንꬂቦኮና። ");
INSERT INTO gofENT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","ሺን ዎታዳሬታፔ ኢሶይ ኢያ ሚያ ቶራን ጫዲን ሶሁዋራ ሱꬂኔ ሃꬂ ጎጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","ሂንቴ ኣማናና ሜላ ሄሳ ቤዒዳይሲ ማርካቲስ። ኢያ ማርካቴꬃይካ ቱማ። ቃሲ ኢ ኦዴይሲ ቱማ ጊዴይሳ ኤሬስ። ");
INSERT INTO gofENT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","ሄሲ ሃኒዳይ ጌሻ ማፃፋይ፥ «ኢያ ሜቄꬃታፔ ኢሶይካ ሜቄና» ጊዳይሲ ፖሌታና ሜላሳ። ");
INSERT INTO gofENT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","ቃሲካ ጌሻ ማፃፋይ ሃራ ቤሳን፥ «ኤንቲ ባንታ ጫዲዳይሳ ቤዓና» ያጌስ። ");
INSERT INTO gofENT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","ሄሳፌ ጉዬ፥ ኣርማቲያሳ ካታማፔ ዪዳ ዮሴፊ ዬሱሳ ኣሃ ኤካናው ጲላፆሳ ዎሲስ። ዮሴፊ ኣይሁዴታስ ያዪዳ ጊሾ ቆሳን ዬሱሳ ካሌይሳ። ጲላፆሲ፥ «ኤካ» ያጊስ። ሄሳ ጊሾ፥ ዮሴፊ ቢዲ ዬሱሳ ኣሃ ኤኪስ። ");
INSERT INTO gofENT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","ቃሲ ኒቆዲሞሲ፥ ሃይሳፌ ካሴ ዬሱሳኮ ቃማ ዪዳይሲ፥ ካርቤኔ ጎዳሬ ኡꬃራ ዋላኬቲዳ ሃስታማኔ ኢሲ ኪሎ ጊራሜ ጊዲያ ሺቶ ኤኪዲ ዮሴፋራ ዪስ። ");
INSERT INTO gofENT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","ሄ ናምዑ ኣሳቲ ዬሱሳ ኣሃ ኤኪዲ፥ ኣይሁዴቲ ኣሃ ፃፂያ ማራን፥ ሺቶራ፥ ሞጎ ኣፊላን ፃፂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","ዬሱሲ ማስቃሊያ ቦላ ካቄቲዳ ቤሳን ዳሮ ኣታኪልቴይ ዴዔስ። ሄ ኣታኪልቲያ ጊዶን ሹቻፌ ዎጬቲዲ ኦሴቲዳ ቡሮ ኦኒካ ሞጌቲቦና ኦራꬃ ዱፎይ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","ሄ ጎንጎሎይ ማታን ዴዒያ ጊሾኔ ኣይሁዴቲ ሳምባታስ ጊጌቲያ ጋላስ ጊዲያ ጊሾ ዬሱሳ ኣሃ ያን ሞጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","ዎጋ ዎዴ ዎንታ ቡሮ ጌዮና ዴዒሺን፥ ማግዴላ ማይራማ፥ ዬሱሲ ሞጌቲዳ ዱፉዋ ባዳ ሹቻይ ሄ ዱፉዋ ዶናፔ ዴንዲዳይሳ ቤዓሱ። ");
INSERT INTO gofENT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","ሲሞን ጴፂሮሳኮኔ ዬሱሲ ዶሲያ ሃንኮ ታማሪያኮ ዎፃ ባዳ፥ «ዱፉዋፔ ጎዳ ኤፊዶሶና፤ ኢያ ኣዉን ዎꬂዳኮ ኑ ኤሮኮ» ያጋሱ። ");
INSERT INTO gofENT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","ሄሳ ጊሾ፥ ጴፂሮሲኔ ሃንኮ ታማሬይ ኬዪዲ ዱፉዋ ቢዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","ናምዓይካ ኢሲፌ ዎፂዶሶና፥ ሺን ሃንኮ ታማሬይ ጴፂሮሳፔ ኣꬊዲ ሲንꬃቲዲ ዱፉዋ ጋኪስ። ");
INSERT INTO gofENT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","ሄ ታማሬይ ሆኪዲ፥ ሞጎ ኣፊላ ቤዒስ፥ ሺን ዱፉዋን ዎꬊቤና። ");
INSERT INTO gofENT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","ሲሞን ጴፂሮሲ ኢያ ካሊ ዪዲ፥ ዱፉዋን ዎꬊዲ ሞጎ ኣፊላይ ያን ዴዔይሳ ቤዒስ። ");
INSERT INTO gofENT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ቃሲ ዬሱሳ ሁዔን ፃፄቲዳ ኣፊላይ ፃፄቲዳ ሜላ ዱማ ኢሲ ቤሳን ዴዔይሳ ቤዒስ። ሄ ኣፊላይ ዱማ ዴዔሲፔ ኣቲን ሞጎ ኣፊላራ ኢሲፌ ዴና። ");
INSERT INTO gofENT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","ሄ ዎዴ ሲንꬃቲዲ ዱፉዋ ጋኪዳ ሃንኮ ታማሬይ ጌሊ ቤዒዲ ኣማኒስ። ");
INSERT INTO gofENT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","ዬሱሲ ሃይቆፔ ዴንዳናው ቤሴይሳ ኦዲያ ጌሻ ማፃፋ ቃላ ኤንቲ ቡሮ ኣኬኪቦኮና። ");
INSERT INTO gofENT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","ሄሳፌ ጉዬ፥ ኢያ ታማሬቲ ባንታ ሶ ሲሚዲ ቢዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","ሺን ማይራማ ሄ ዱፉዋ ዶናን ኤቃዳ ዬካሼ ሆካዳ ዱፉዋ ጊዶ ፄላሱ። ");
INSERT INTO gofENT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ቦꬃ ማዖ ማዒዳ ናምዑ ኪታንቾቲ ዬሱሳ ኣሃይ ዚንዒዳሱዋን ኢሶይ ሁዔሶራ ሃንኮይ ቶሆሶራ ኡቲዳሺን ቤዓሱ። ");
INSERT INTO gofENT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","ኤንቲ ኢኮ፥ «ማጫሴቴ፥ ኣይስ ዬካይ?» ያጊዲ ኦይቺዶሶና። ኢያ፥ «ኤንቲ ታ ጎዳ ኤፊዶሶና፤ ኤንቲ ኣዉን ዎꬂዳኮ ታኒ ኤሪኬ» ያጋሱ። ");
INSERT INTO gofENT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","ሄሳ ጊዳፔ ጉዬ፥ ኢያ ጉዬ ሲማ ፄሊያ ዎዴ ዬሱሲ ያን ኤቂዳይሳ ቤዓሱ። ሺን ኢ ዬሱሳ ጊዲዳይሳ ኤራቡኩ። ");
INSERT INTO gofENT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","ዬሱሲ ኢኮ፥ «ማጫሴቴ፥ ኣይስ ዬካይ? ኦና ኮያይ?» ያጊዲ ኦይቺስ። ማይራማ ኣታኪልቴ ኦሳንቹዋ ዳኒን፥ «ጎዳው፥ ኔ ኤኪዳባ ጊዲኮ፥ ኢያ ኣዉን ዎꬂዳኮ ታው ኦዳርኪ። ታኒ ኢያ ኤካና» ያጋሱ። ");
INSERT INTO gofENT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","ዬሱሲ ኢኮ፥ «ማይራሜ» ያጊስ። ኢያ ኢያኮ ሲማዳ፥ ኢብራይስፄ ዶናን «ሬቡኒ» ያጋሱ። ሄሳስ ቢርሼꬃይ «ኣስታማሪያው» ጉሱ። ");
INSERT INTO gofENT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","ዬሱሲ ኢኮ፥ «ታኒ ቡሮ ታ ኣዋኮ ቦና ጊሾ ታና ኦይካዳ ኣሻናው ኮዮፓ። ሺን ታ ኢሻታኮ ባዳ፥ ‹ታኒ ታ ኣዋኮኔ ሂንቴ ኣዋኮ፥ ታ ፆሳኮኔ ሂንቴ ፆሳኮ፥ ሲማና ጊስ› ጋዳ ኤንታው ኦዳ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","ማግዴላ ማይራማ ጎዳ ቤዒዳይሳኔ ኢው ሄሳ ኢ ኦዲዲዳይሳ ባዳ ኢያ ታማሬታስ ኦዳሱ። ");
INSERT INTO gofENT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","ዎጋ ዎዴ ኦማርሲ፥ ኢያ ታማሬቲ ኣይሁዴታስ ያዪዲ ካሪያ ጎርዲዲ ሺቂ ኡቲዳሺን፥ ዬሱሲ ዪዲ፥ ኤንታ ጊዶን ኤቂዲ፥ «ሳሮይ ሂንቴው ጊዶ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","ሄሳ ጊዲ ሲሚዲ ባ ኩሺያኔ ባ ሚያ ኤንታ ቤሲስ። ኢያ ታማሬቲ ጎዳ ቤዒዳ ዎዴ ዳሮ ኡፋይቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","ዬሱሲ ዛሪዲ ኤንታኮ፥ «ሳሮይ ሂንቴው ጊዶ፤ ታ ኣዋይ ታና ኪቲዳይሳዳ ታኒካ ሂንቴና ኪታይስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","ሄሳ ጊዳፔ ጉዬ፥ ኤንታ ቦላ ኡፉ ጊዲ ፑኒስ። ቃሲ፥ «ጌሻ ኣያና ኤኪቴ። ");
INSERT INTO gofENT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","ሂንቴ ኣቶ ጊዳ ኣሳ ናጋራይ ኣቶ ጌቴታና። ሂንቴ ኣቶ ጎናይሳታ ናጋራይ ኣቶ ጌቴቴና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","ሺን ታማኔ ናምዑ ታማሬታፔ ኢሶይ፥ ዲዲሞሳ ጌቴቲያ ቶማሲ፥ ዬሱሲ ዪዳ ዎዴ ኤንታራ ዴና። ");
INSERT INTO gofENT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","ሄሳ ጊሾ፥ ሃንኮ ኢያ ታማሬቲ ቶማሳኮ፥ «ኑኒ ጎዳ ቤዒዳ» ያጊዶሶና። ሺን ቶማሲ ኤንታኮ፥ «ሚሲማሬን ኢ ጫዴቲዳ ኢያ ኩሺያን ዴዒያ ቤታ ቤዖናኔ ሄ ቤታ ታ ቢራꬌን ቦቾና፥ ቃሲ ታ ኩሺያ ኢያ ሚያን ዬዳ ቤዖና ኣማኒኬ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","ሳሚንታፌ ጉዬ፥ ዬሱሳ ታማሬቲ ቃሲካ ሶን ሺቂዲ ኡቲዶሶና፤ ቶማሲካ ኤንታራ ዴዔስ። ካሬይ ጎርዴቲዲ ዴዒሺን ዬሱሲ ዪዲ፥ ኤንታ ጊዶን ኤቂዲ፥ «ሳሮይ ሂንቴው ጊዶ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","ሄሳፌ ጉዬ፥ ዬሱሲ ቶማሳኮ፥ «ታ ኩሺያ ኔ ቢራꬊያን ቦቻዳ ቤዓ። ቃሲ ኔ ኩሺያ ታ ሚያን ዬዳዳ ቤዓ፤ ሲꬎፓ፥ ኣማና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","ቶማሲ ዛሪዲ፥ «ታ ጎዳው፥ ታ ፆሳው» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","ያቲን ዬሱሲ፥ «ኔኒ ታና ቤዒዳ ጊሾ ኣማናዳሳ፥ ሺን ታና ቤዖና ኣማኒዳይሳቲ ኣንጄቲዳይሳታ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","ዬሱሲ ሃ ማፃፋን ፃፌቲቦና ሃራ ዳሮ ማላታታ ባ ታማሬታ ሲንꬃን ኦꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","ሺን ዬሱሲ ኢ ኪሪስቶሳ፥ ፆሳ ናዓ ጊዴይሳ ሂንቴ ኣማናና ሜላኔ ኣማኒዲ ኢያ ሱንꬃን ዴዖ ዴማና ሜላ ሄሲ ፃፌቲስ። ");
INSERT INTO gofENT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","ሄሳፌ ጉዬ፥ ዬሱሲ ፂባርዮሳ ኣባ ማታን ባ ታማሬታስ ዛሪ ቆንጪስ። ኢ ኤንታው ሃይሳፌ ካሊዲ ዴዒያ ሃኖታን ቆንጪስ። ");
INSERT INTO gofENT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","ሲሞን ጴፂሮሲ፥ ሜንቴ ጌቴቲያ ቶማሲ፥ ቃና ጋሊላፔ ዪዳ ናቲናዔሊ፥ ዛብዲዮሳ ናይቲኔ ዬሱሳ ታማሬታፔ ሃራ ናምዓቲ ኢሲፌ ዴዖሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","ሲሞን ጴፂሮሲ ኤንታኮ፥ «ታኒ ሞሎ ኦይካናው ባይስ» ያጊስ። ኤንቲ፥ «ኑካ ኔራ ባና» ያጊዲ፥ ዎጎሉዋ ጊዶ ጌሊዶሶና። ሺን ኤንቲ ሄ ቃማን ኣይቢ ሞሎካ ኦይኪቦኮና። ");
INSERT INTO gofENT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","ዎንታ ጉራ ፃልቄይ ዶላናፔ ሲንꬄ፥ ዬሱሲ ኣባ ጋፃን ኤቂስ፥ ሺን ኢያ ታማሬቲ ዬሱሳ ጊዲዳይሳ ኤርቦኮና። ");
INSERT INTO gofENT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","ዬሱሲ ኤንታኮ፥ «ታ ላጌቶ፥ ሞሎ ኦይኪቤኬቲ?» ያጊስ። ኤንቲ ዛሪዲ፥ «ኣይኮካ ኦይኪቦኮ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","ኢ ዛሪዲ፥ «ሂንቴ ጊቲያ ዎጎሉዋፔ ኡሻቻ ባጋራ ዬጊቴ፤ ጉꬃ ሞሎ ሂንቴ ኦይካና» ያጊስ። ሄሳ ጊሾ፥ ጊቲያ ኡሻቻ ባጋራ ዬጊዶሶና። ሞሎይ ዳሪዳ ጊሾ ጎቺዲ ኬሳናው ፆኔቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","ዬሱሲ ዶሲያ ታማሬይ ጴፂሮሳኮ፥ «ሃይሲ ጎዳ!» ያጊስ። ሲሞን ጴፂሮሲ ኢ ጎዳ ጊዳይሳ ሲዒዳ ዎዴ ካሎ ዴዒያ ጊሾ ባ ማዑዋ ማዒዲ ኣባ ጊዶ ጉፒ ጌሊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","ሺን ዎጎሉዋን ኣቲዳ ሃንኮ ታማሬቲ ሞሎይ ኩሚዳ ጊቲያ ጎቺዲ፥ ኣባፌ ጋፃ ኬዪዶሶና። ኤንቲ ኣባፌ ናምዑ ፄቱ ዋꬋ ሜላ ሃኮሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","ኤንቲ ኣባፌ ጋፃ ኬዪዳ ዎዴ ፂፋ ቦንቆን ሞሎይ ዴዔይሳኔ ኡይꬂ ቤዒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","ዬሱሲ ኤንታኮ፥ «ሃዒ ሂንቴ ኦይኪዳ ሞሉዋፔ ጉꬃራ ሃሚቴ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","ሲሞን ጴፂሮሲ ዎጎሉዋን ጌሊዲ፥ ፄታኔ ኢሻታማኔ ሄꬑ ዎጋ ሞሎቲ ኩሚዳ ጊቲያ ጎቺዲ ኣባፌ ጋፃ ኬሲስ። ሞሎይ ሄሳ ሜላ ዳሮ ጊዲን ጊቴይ ዳኬቲቤና። ");
INSERT INTO gofENT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","ዬሱሲ ኤንታኮ፥ «ሃ ዪዲ ሚቴ» ያጊስ። ኢ ጎዳ ጊዴይሳ ኤንቲ ኤሪዳ ጊሾ ኢያ ታማሬታፔ ኢሶይካ፥ «ኔኒ ኦኔ?» ጊዲ ኢያ ኦይቻናው ሚኒዳይ ባዋ። ");
INSERT INTO gofENT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","ዬሱሲ ዪዲ፥ ኡይꬃ ኤኪዲ ኤንታው ኢሚስ፤ ሞሉዋካ ሄሳዳ ኢሚስ። ");
INSERT INTO gofENT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","ዬሱሲ ሃይቆፔ ዴንዲዲ ባ ታማሬታስ ቆንጪሺን ሃይሲ ሄꬓንꬆ። ");
INSERT INTO gofENT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","ኤንቲ ሚዳፔ ጉዬ፥ ዬሱሲ ሲሞን ጴፂሮሳኮ፥ «ዮና ናዓው ሲሞና፥ ታና ሃይሳታፔ ኣꬃዳ ዶሳይ?» ያጊስ። ሲሞን ጴፂሮሲ፥ «ኤ ጎዳው፥ ታኒ ኔና ዶሴይሳ ኔ ኤራሳ» ያጊስ። ዬሱሲ ኢያኮ፥ «ታ ዶርሳ ማራታ ሄማ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","ዬሱሲ ቃሲካ፥ «ዮና ናዓው ሲሞና፥ ታና ዶሳይ?» ያጊስ። ሲሞን ጴፂሮሲ፥ «ኤ ጎዳው፥ ታኒ ኔና ዶሴይሳ ኔ ኤራሳ» ያጊስ። ዬሱሲ፥ «ታ ዶርሳታ ሄማ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","ዬሱሲ ሄꬓንꬆ፥ «ዮና ናዓው ሲሞና፥ ታና ዶሳይ?» ያጊስ። ዬሱሲ ሄꬓንꬆ ሲሞን ጴፂሮሳኮ፥ «ታና ዶሳይ?» ያጊዲ ኦይቺዳ ጊሾ ጴፂሮሲ ኣዛኒዲ፥ «ጎዳው፥ ኔኒ ኡባባ ኤራሳ፤ ታኒ ኔና ዶሴይሳ ኔ ኤራሳ» ያጊስ። ዬሱሲ፥ «ታ ዶርሳታ ሄማ። ");
INSERT INTO gofENT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","ታኒ ኔው ቱማ ኦዳይስ፤ ኔኒ ናዓቴꬃን ዴዒያ ዎዴ ኔርካ ዳንጬታዳ፥ ኔ ኮዪዳ ሶ ባሳ። ሺን ኔ ጪሚዳ ዎዴ ኔ ኩሺያ ሚጫ ቤሳና። ሃሪ ዳንጪሳና፤ ኔ ዶሶና ሶ ኤፋና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","ዬሱሲ ሄሳ ጴፂሮሲ ኣይ ሜላ ሃይቆ ሃይቂዲ፥ ፆሳ ቦንቺሳኔኮ ኤሪሳናው ጊስ። ሄሳ ጊዳፔ ጉዬ፥ ዬሱሲ ጴፂሮሳኮ፥ «ታና ካላ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","ጴፂሮሲ ጉዬ ሲሚዲ፥ ዬሱሲ ዶሲያ ታማሬይ ባፔ ጉዬራ ዬይሳ ቤዒስ። ሄ ታማሬይ፥ ካሆ ሚያሶን ዬሱሳኮ ሺቂዲ፥ «ጎዳው፥ ኔና ኣꬂ ኢማናይ ኦኔ?» ጊዳይሳ። ");
INSERT INTO gofENT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","ጴፂሮሲ ሄ ታማሪያ ቤዒዲ፥ «ጎዳው፥ ሃ ኣዴይ ቃሲ ዋናኔ?» ያጊዲ ዬሱሳ ኦይቺስ። ");
INSERT INTO gofENT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","ዬሱሲ ኢያኮ፥ «ታኒ ያና ጋካናው ኢ ዳና ሜላ ታኒ ኮይኮ፥ ሄሲ ኔና ኣይ ሜቲዴ? ኔኒ ታና ካላ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","ሄሳ ጊሾ፥ ሄ ታማሬይ ሃይቄና ጊያ ኦዳይ ኢሻታ ኡባ ጋኪስ። ሺን ዬሱሲ፥ «ታኒ ያና ጋካናው፥ ኢ ዳና ሜላ ታኒ ኮይኮ ኔና ኣይ ሜቲዴ?» ያጊሲፔ ኣቲን «ሃይቄና» ጊቤና። ");
INSERT INTO gofENT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","ሃ ኦዳባ ማርካቲዳይኔ ሃይሳ ፃፊዳይ ሄ ታማሪያ። ኢያ ማርካቴꬃይ ቱማ ጊዴይሳ ኑኒ ኤሮስ። ");
INSERT INTO gofENT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","ዬሱሲ ኦꬂዳ ሃራ ዳሮባይ ዴዔስ። ታ ቆፒን፥ ኡባባይ ሁዔን ሁዔን ፃፌቲዳኮ፥ ፃፌቲያ ማፃፋታስ ኩሜꬃ ኣላሜይ ዎꬃንው ጊዳናባ ዳኔና። ");
INSERT INTO gofENT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","ቴዎፊሎሳ፥ ዬሱሲ ባ ኦሱዋ ኦይኪዳ ዎዴፔ ሳሎ ቢዳ ጋላሳ ጋካናው፥ ኦꬂዳባኔ ታማርሲዳባ ኡባ ታኒ ታ ኮይሮ ማፃፋን ፃፋስ። ሳሎ ባናፔ ሲንꬄ ኢ ባ ዶሪዳ ሃዋሬታ ጌሻ ኣያናን ኪቲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","ኢ ባ ዋያፔ ጉዬ ሃይቆፔ ዴንዲዳይሳ ሲꬌይ ባይና ቆንጪሲዲ ኤንታው ባና ቤሲስ። ኦይታሙ ጋላስ ኤንታው ቆንጪዲ ፆሳ ካዎቴꬃባ ኤንታ ታማርሲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","ኢሲ ዎዴ ኤንታራ ኢሲፌ ሚሼ ኤንታ ሃይሳዳ ያጊዲ ኪቲስ፡ «ታ ሂንቴው ኦዲዳ፥ ታ ኣዋይ ኢማና ጊዳ ኡፋይሳ ቃላ ናጊቴፔ ኣቲን ዬሩሳላሜፔ ኬዮፒቴ። ");
INSERT INTO gofENT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","ኣይስ ጊኮ፥ ዮሃኒሲ ሃꬃን ፃማቂስ፥ ሺን ጉꬃ ዎዴፔ ጉዬ ጌሻ ኣያናን ሂንቴ ፃማቄታና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","ሃዋሬቲ ዬሱሳራ ጋሄቲዳ ዎዴ ኢያኮ፥ «ጎዳው፥ ኢስራዔሌታስ ኔ ካዎቴꬃ ዛራና ዎዴይ ሃይሴ?» ያጊዲ ኦይቺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","ዬሱሲ ኤንታኮ፥ «ታ ኣዋይ ባ ማታን ኦꬂያ ዎዲያኔ ላይꬃ ሂንቴ ኤራናው ዳንዳዔኬታ። ");
INSERT INTO gofENT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","ሺን ጌሻ ኣያናይ ሂንቴ ቦላ ዎꬊያ ዎዴ ሂንቴ ዎልቃን ኩማና። ያኒ ሲሚዲ፥ ዬሩሳላሜን፥ ዪሁዳ ቢታ ኡባን፥ ሳማሬኒኔ ሳዓ ጋፃ ጋካናው ታው ማርካታ ጊዳና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","ሄሳ ጊዳይሳፌ ጉዬ ኤንቲ ፄሊሺን፥ ꬎቁ ꬎቁ ጊዲ፥ ሳሉዋ ቢን ሻራይካ ኢያ ኤንታ ኣይፊያፔ ጌንꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","ዬሱሲ ቢያ ዎዴ ኤንቲ ሳሎ ቲሺ ኦꬂዲ ፄሊሺን፥ ቦꬃ ማዖ ማዒዳ ናምዑ ኣሳቲ ኣኬኮና ኤንታ ማታን ኤቂዲ፥ ");
INSERT INTO gofENT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","«ጋሊላ ኣሳው፥ ሳሎ ፄሊሼ፥ ሂንቴ ኣይስ ኤቂዴቲ? ሃ ሂንቴ ቤዒሺን ሳሎ ቢዳ ዬሱሲ ሄሳዳካ ሲሚዲ ያና» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","ሄሳፌ ጉዬ፥ ሃዋሬቲ ሻማሆ ዴሪያፔ ዬሩሳላሜ ሲሚዶሶና። ሻማሆ ዴሬይ ዬሩሳላሜስ ማታን ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","ኤንቲ ዬሩሳላሜ ጌሊዲ፥ ባንታ ዴዒያ ቤሳ ፖቂያ ቦላ ኬዪዶሶና። ኤንቲካ፡ ጴፂሮሳ፥ ዮሃኒሳ፥ ያይቆባ፥ ኢንዲሪያሳ፥ ፊልጶሳ፥ ቶማሳ፥ ባርቶሎሚዮሳ፥ ማቶሳ፥ ኢልፊዮሳ ናዓ ያይቆባ፥ ባ ቢታስ ሚሼቲያ ሲሞናኔ ያይቆባ ናዓ ዪሁዳ። ");
INSERT INTO gofENT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","ሃይሳቲ ኡባይ ማጫሳታራ፥ ዬሱሳ ኣዬ ማይራሚራኔ ዬሱሳ ኢሻታራ ኡባይ ኢሲ ዎዛናን ጊዲዲ ሚንꬂዲ ዎሶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","ሄ ዎዴ ጴፂሮሲ ፄታኔ ላታማ ጊዲያ ኣማኒያ ኣሳይ ሺቂዳ ቤሳን ዴንዲ ኤቂዲ፥ ሃይሳዳ ያጊስ፡ ");
INSERT INTO gofENT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","«ኣሳው፥ ዬሱሳ ኦይኪዳይሳታ ካሌꬂዳ ዪሁዳባ ጌሻ ኣያናይ ካሴ ዳዊቴ ዶናን ኦዲዳ ፆሳ ቃላይ ፖሌታናው ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","ዪሁዲ ኑራ ኢሲፌ ሃ ኦሱዋ ኦꬃናው ዶሬቲዳ ኣሲ።» ");
INSERT INTO gofENT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","ሺን ዪሁዲ ባ ኢታ ኦሱዋን ዴሚዳ ሚሼን ጋዴ ሻሚስ። ኢ ጉፋኒዲ ኩንዲን፥ ኢያ ኡሎይ ዳኬቲስ፤ ኢያ ማራጬይ ኡባይ ካሬ ኬዪስ። ");
INSERT INTO gofENT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","ዪሁዳ ቦላ ሃኒዳባ ዬሩሳላሜን ዴዒያ ኣሳ ኡባይ ሲዒስ። ሄሳ ጊሾ፥ ሄ ጋዲያ ባንታ ቃላን ኣኬልዳማ (ሱꬃ ጋዴ) ጊዲ ፄጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","«ሄሲካ ማዝሙሬ ማፃፋን፥ ‹ኢያ ኬꬃይ ካሎ ኣቶ፤ ኦኒካ ኢያን ዴዖፖ። ቃሲ ኢያ ሹማቴꬃ ሃሪ ኤኮ› ጌቴቲ ፃፌቲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","«ሄሳ ጊሾ፥ ጎዳ ዬሱሲ ኑ ጊዶን ሲሜሬቲዳ ዎዴ ኡባን ኑራ ዴዔይሳታፔ፥ ");
INSERT INTO gofENT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","ቃሲ ፃማቂያ ዮሃኒሳ ዎዲያፔ ዶሚዲ ጎዳ ዬሱሲ ሳሎ ቢዳ ጋላስ ጋካናው ኑራ ዴዔይሳታፔ ኢሲ ኣሲ ኢያ ዴንዱዋስ ኑራ ማርካ ጊዳናው ቤሴስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","ሄሳ ጊሾ፥ ኣሳይ ዶሩዋስ ዮስፆሳ ጊያ ባርሳባሳ ጌቴቲያ ዮሴፋኔ ማቲያሳ ናምዓ ሺሺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","ሄሳፌ ጉዬ፥ ፆሳ ዎሲሼ፥ «ኣሳ ኡባ ዎዛና ኤሪያ ጎዳው፥ ሃ ናምዓታፔ ኔ ኦና ዶሪዳኮ ኑና ቤሳ። ");
INSERT INTO gofENT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ዪሁዲ ባ ቤሳ ቢዲ፥ ኣጊዳ ኦሱዋኔ ሃዋሬቴꬃ ኦሱዋ ኤካና ሜላ ሃይሳታፔ ኑስ ቆንጪሳ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","ኤንታ ቦላ ሳማ ዬጊዶሶና። ሳማይ ማቲያሳ ቦላ ዎꬊን ማቲያሲ ታማኔ ኢሲ ሃዋሬታ ቦላ ጉዤቲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","ጴንፄቆስፄ ጊያ ጋላሳይ ጋኪዳ ዎዴ ኣማኒያ ኣሳ ኡባይ ኢሲፌ ኢሲ ቤሳን ሺቂዲ ዴዖሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","ቆፖና ዎልቃማ ጎቴዳ ጉሚያ ጉንꬃይ ኣኬኮና ሳሎፔ ዪዲ ኤንቲ ዴዒያ ኬꬃ ኩሚስ። ");
INSERT INTO gofENT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","ቃሲ ታማ ላጮ ዳኒያ ኢንፃርሳቲ ኤንታው ቤንቲሼ፥ ሻኬቲ ሻኬቲ ኤንታ ኡባ ቦላ ዎꬊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","ኤንቲ ኡባይ ጌሻ ኣያናን ኩሚዲ ዱማ ዱማ ዶናን ኦዴታና ሜላ ጌሻ ኣያናይ ኤንታ ዳንዳዒሲን ሃሳያ ዶሚዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","ሄ ዎዴ ቢታ ኡባፌ ዪዳ ፆሳ ያያ ኣይሁዴቲ ዬሩሳላሜን ዴዖሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","ሄ ጉንꬃ ሲዒዳ ዎዴ ዳሮ ኣሳይ ሺቂዶሶና። ኣማኒያ ኣሳይ ኤንታ ቃላን ኦዴቲሺን ሲዒዳ ጊሾ ");
INSERT INTO gofENT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","ማላሌቲዲ፥ «ሃ ኦዴቲያ ኣሳ ኡባይ ጋሊላ ኣሴ ጊዶኮናዬ? ");
INSERT INTO gofENT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","ያቲን፥ ኑኒ፥ ኑ ዬሌቲዳ ቢታ ዶናን ኤንቲ ኦዴቲሺን ዋኒዲ ሲዓናው ዳንዳዒዶ? ");
INSERT INTO gofENT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","ኑኒ ጳርፄን፥ ሜዶናን፥ ኤላሜን፥ ናምዑ ሻፋታፔ ጊዶን ዴዔይሳቲ፥ ዪሁዳን፥ ቃጳዶቂያን፥ ጳንፆሳን፥ ኢሲያን፥ ");
INSERT INTO gofENT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ጲርጌን፥ ጲንፊሌን፥ ጊብፄን፥ ቃሬና ማታን ዴዒያ ሊቢያን ዴዔይሳታ። ኑፔ ባጋቲካ ሮሜፔ ዪዳ ኣሳታ። ");
INSERT INTO gofENT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ኣይሁዴቲኔ ኣይሁዴቴꬃ ኣማኖ ጌሊዳ ኣሳቲ፥ ቃርፄሳኔ ኣራቤ ኣሳቲ፥ ፆሳይ ኦꬂዳ ጊታ ኦሱዋ ኑ ቃላን ኦዴቲሺን ሲዖስ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","ኡባይ ማላሌቲዲ፥ ጋናባ ꬋዪዲ ዎሊኮ፥ «ላ ሃይሲ ኣይ ጉሴ?» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","ሺን ሃራቲ፥ «ሃይሳቲ ኡዪዲ ማꬆቲዶሶና» ያጊዲ ቄልቂሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","ሺን ጴፂሮሲ፥ ታማኔ ኢሲ ሃዋሬታራ ዴንዲ ኤቂዲ፥ ባ ቃላ ꬎቁ ኦꬂዲ፥ ኤንታው ሃይሳዳ ያጊዲ ኦዲስ፡ «ኣይሁዴቶ፥ ዬሩሳላሜን ዴዒያ ኡባቶ፥ ታኒ ኦዴይሳ ሲዒቴ። ");
INSERT INTO gofENT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","ዎንታፌ ሄꬑ ሳቴ ጊዲያ ጊሾ ሂንቴ ቆፔይሳዳ ሃ ኣሳቲ ማꬆቲቦኮና፤ ሄሲ ሂንቴው ኤሬቶ። ");
INSERT INTO gofENT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","ሺን ሃይሲ ሃኒዳይ ናቢያ ኢዩዔሊ ኦዲዳይሲ ፖሌታና ሜላሳ። ");
INSERT INTO gofENT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","« ‹ፆሳይ፥ ዎዲያ ዉርሴꬃን ሃይሳዳ ሃናና ያጌስ፡ ታኒ ኣሳ ኡባ ቦላ ታ ኣያና ጉሳና። ሂንቴ ኣዴ ናይቲኔ ማጫ ናይቲ፥ ቲንቢቴ ኦዳና። ሂንቴ ያላጋቲ ቆንጬꬂ ቤዓና፤ ሂንቴ ጪማቲ ኣሙሆ ኣሙሃና። ");
INSERT INTO gofENT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","ሄ ጋላሳታን ታና ኣማኒያ ኣዴ ኣይሌታ ቦላኔ ማጫ ኣይሌታ ቦላ ታኒ ታ ኣያና ጉሳና፤ ኤንቲ ቲንቢቴ ኦዳና። ");
INSERT INTO gofENT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","ቃሲ ታኒ ቦላ ሳሉዋን ኦራꬃባ፥ ጋርሳ ሳዓንካ ማላ ቤሳና። ሱꬂ፥ ታሚኔ ዎልቃማ ጫጋኒ ቤንታና። ");
INSERT INTO gofENT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","ጊታኔ ቦንቾ ጊዲዳ ጎዳ ጋላሳይ ጋካናፔ ሲንꬄ ኣዋይ ꬉማና፤ ኣጌናይካ ሱꬂ ዳናና። ");
INSERT INTO gofENT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","ሄ ዎዴ ሄሳዳ ሃናና፤ ጎዳ ሱንꬃ ፄጊያ ኦኒካ ኣታና› ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","«ኢስራዔሌ ኣሳው፥ ሃ ቃላ ሲዒቴ። ናዚሬቴ ዬሱሳ ኦናቴꬃይ፥ ፆሳይ ሂንቴ ጊዶን ኦꬂዳ ዎልቃማ ኦሱዋኒኔ ማላታታን ሂንቴው ቆንጮይሳ ሂንቴ፥ ሂንቴ ሁዔን ኤሬታ። ");
INSERT INTO gofENT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","ፆሳ ካሴ ኤራኒኔ ኢያ ሼኒያን ዬሱሲ ሂንቴው ኣꬊ ኢሜቲስ። ሂንቴ ኢያ ናጋራንቾቲ ማስቃሊያ ቦላ ካቂዲ ዎꬋና ሜላ ኣꬂ ኢሚዴታ። ");
INSERT INTO gofENT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","ሺን ፆሳይ ሃይቆ ዎልቃ ዲጊዲ ኢያ ዴንꬂስ። ሄሳ ጊሾ፥ ሃይቆይ ኢያ ኦይካናው ዳንዳዒቤና። ");
INSERT INTO gofENT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","ዳዊቴይ ኢያባ ኦዲሼ፥ ‹ታኒ ያርኮና ሜላ፥ ጎዳይ ታ ኡሻቻን ዴዔስ። ጎዳ ኡባ ዎዴ ታ ማታን ቤዓይስ። ");
INSERT INTO gofENT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","ሄሳ ጊሾ፥ ታ ዎዛናይ ኡፋይቲስ፤ ታ ኢንፃርሳን ኡፋይሲ ኩሚስ፤ ሃይቂያ ታ ኣሳቴꬃይ ኡፋይሳን ዳና። ");
INSERT INTO gofENT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","ኣይስ ጊኮ፥ ታ ሼምፑዋ ሲዖሌን ኣጋካ። ቃሲ ኔ ጌሻ ናዓ ኣሃ ዎቂሳካ። ");
INSERT INTO gofENT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","ኔኒ ታና ዴዖ ኦጊያ ኤሪሳዳሳ። ኔኒ ታራ ዴዔይሳን ታ ኡፋይሳይ ኩሜꬂ ጊዴስ› ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","«ኣሳው፥ ኑ ኣዋ ዳዊቴባ ታ ሂንቴው ጌሻዳ ኦዳና። ዳዊቴይ ሃይቂዲ ሞጌቲስ፤ ኢያ ዱፎይ ሃቺ ጋካናው ኑ ማታን ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","ዳዊቴይ ናቤ ጊዲዳ ጊሾ ፆሳይ ኢያ ሼሻፔ ኢሱዋ ኢያ ካዎቴꬃ ኣራታ ቦላ ኡቲሳናው ኢያው ጫቂዳ ጫቁዋ ኤሬስ። ");
INSERT INTO gofENT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","ሄሳ ጊሾ፥ ኪሪስቶሳ ዴንዱዋ ሲንꬄ ፄሊዲ፥ ‹ኢያ ሼምፖይ ሲዖሌን ኣቲቤና፤ ኢያ ኣሳቴꬃይካ ዎቂቤና› ጊዲ ኦዲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","«ፆሳይ፥ ሃ ዬሱሳ ሃይቁዋፔ ዴንꬂዳይሳስ ኑኒ ኡባይ ማርካ። ");
INSERT INTO gofENT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","ሄሳ ጊሾ፥ ፆሳይ ባራ ሃራና ሜላ ባፔ ኡሻቻ ባጋራ ኢያ ꬎቁ ꬎቁ ኦꬂዲ፥ ኢያው ኢማና ጌቴቲዳ ጌሻ ኣያና ኤኪዲ፥ ሃይሳ ሂንቴ ሃዒ ቤዔይሳኔ ሲዔይሳ ኑ ቦላ ጉሲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","ጋሶይካ፥ ዳዊቴይ ባ ሁዔን ሳሎ ቢቤናሺን ያጊስ፡ ‹ጎዳይ፥ ታ ጎዳ፥ «ታኒ ኔ ሞርኬታ ኔ ቶሆይ ዬꬊያሶ ኦꬃና ጋካናው ሃይሳን ታፔ ኡሻቻ ባጋን ኡታ» ጊስ› ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","«ሄሳ ጊሾ፥ ሃ ሂንቴ ማስቃሊያ ቦላ ካቂዳ ዬሱሳ፥ ፆሳይ ጎዳኔ ኪሪስቶሳ ኦꬂዳይሳ ኢስራዔሌ ኣሳ ኡባይ ቱማ ኤሮ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","ኣሳይ ጴፂሮሲ ጊዳይሳ ሲዒዳ ዎዴ ባንታ ዎዛናን ቦሼቲዲ ጴፂሮሳኔ ሃንኮ ሃዋሬታኮ፥ «ኢሻቶ፥ ያቲን ኑኒ ኣይ ኦꬂኖ?» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","ጴፂሮሲ ኤንታኮ፥ «ሂንቴ ናጋራይ ኣቶ ጌቴታና ሜላ ናጋራፔ ሲሚዲ፥ ሂንቴ ኢሶይ ኢሶይ ዬሱስ ኪሪስቶሳ ሱንꬃን ፃማቄቲቴ። ፆሳይ ኢሚያ ጌሻ ኣያና ሂንቴ ኤካና። ");
INSERT INTO gofENT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","ጋሶይካ ፆሳይ ኢማና ጊዳ ኡፋይሳ ቃላይ ሂንቴስ፥ ሂንቴ ናይታሲኔ ጎዳይ ኑ ፆሳይ ባኮ ፄጊያ ሃሆን ዴዒያ ኡባሳ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","ጴፂሮሲ ኤንታው ሃራ ቃላካ ጉጂ ማርካቲዲ፥ «ሃ ዎዲያ ጌላ ኣሳ ቦላ ያናው ዴዒያ ፒርዳፌ ሂንቴ ሁዒያ ኣሺቴ» ያጊዲ ዞሪስ። ");
INSERT INTO gofENT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","ጴፂሮሲ ኦዲዳይሳ ኤኪዳይሳቲ ፃማቄቲዶሶና። ሄ ጋላስ ሄꬑ ሙኩሉ ጊዲያ ኣሳይ ኣማኒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","ኤንቲ ሃዋሬታ ቲሚርቲያን፥ ኢሲፌቴꬃን፥ ኡይꬃ ሙሳኒኔ ፆሳ ዎሳን ሚኖሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","ሃዋሬታ ኩሼን ዳሮ ኦራꬃባይኔ ማላቲ ኦሴቲያ ጊሾ ኣሳ ኡባይ ያዪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","ኣማኒዳ ኡባይ ኢሲፌ ዴዖሶና፤ ባንታው ዴዒያባ ኡባ ኢሲፌ ሻኬቶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","ኤንቲ ባንታው ዴዒያባ ባይዚዲ ሚሺያ ኢሱዋስ ኢሱዋስ ኮሺዳ ሜላ ሻኮሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","ኡባ ጋላስ ኢሲ ዎዛናን ጊዲዲ ፆሳ ኬꬃን ሺቆሶና። ባንታ ኬꬃን ኢሶይ ኢሱዋ ፄጊዲ ኡፋይሳኒኔ ኣሽኬ ዎዛናን ካꬃ ሞሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","ፆሳ ጋላቲሼ ኣሳ ኡባን ሳቤቲዶሶና። ጎዳይ ኣቴይሳታ ጋላስ ጋላስ ኤንታ ቦላ ጉጄስ። ");
INSERT INTO gofENT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","ኢሲ ጋላስ ጴፂሮሲኔ ዮሃኒሲ ፆሳ ዎሳናው ኡዱፉን ሳቴን ፆሳ ኬꬂ ቢዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","ዬሌቶሶፔ ዶሚዲ ዎቤ ጊዲዳ ኢሲ ኣዴይ ፆሳ ኬꬂ ጌሊያ ኣሳፔ ሚሼ ዎሳና ሜላ ኡባ ዎዴ ሎዖ ጊያ ፆሳ ኬꬃ ፔንጊያን ኤሂዲ ዎꬆሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","ሄ ዎቤ ኣዴይ ጴፂሮሲኔ ዮሃኒሲ ፆሳ ኬꬂ ጌላና ሃኒሺን ቤዒዲ ኤንታ ሚሼ ዎሲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","ኤንቲካ ኢያ ጫዲ ፄሊዲ፥ «ኑኮ ሃ ፄላ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","ዎቤ ኣዴይ ኤንታፌ ኣይኮ ኤካና ዳኒን ኤንታኮ ፄሊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","ሺን ጴፂሮሲ ኢያኮ፥ «ታው ሚሼይ ባዋ፥ ሺን ታው ዴዒያባ ታኒ ኔው ኢማና። ናዚሬቴ ዬሱስ ኪሪስቶሳ ሱንꬃን ዴንዳዳ ሃሙታ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","ሄሳፌ ጉዬ፥ ዎቤ ኣዲያ ኡሻቻ ኩሺያ ኦይኪዲ ዴንꬂስ። ኤሌሲዲ ኢያ ቶሆይኔ ቂንጫፊሌይ ሚኒ ኣጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ኣዴይ ጉፒዲ ዴንዲ ኤቂስ። ጌዴኔ ሃ ሃሙꬂ ዶሚስ። ሄሳፌ ጉዬ፥ ሃሙቲሼ፥ ጉፒሼኔ ፆሳ ጋላቲሼ ኤንታራ ኢሲፌ ፆሳ ኬꬂ ጌሊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","ኢ ሃሙቲሺኒኔ ፆሳ ጋላቲሺን ኣሳ ኡባይ ኢያ ቤዒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ቤዒዳ ኡባይ ሚሼ ዎሳናው ሎዖ ጊያ ፆሳ ኬꬃ ፔንጌን ኡቲዳይሲ ኢያ ጊዲዳይሳ ኤሪዶሶና፤ ኢ ሃኒዳባ ቤዒዲ ማላሌቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","ኣዴይ ጴፂሮሳፔኔ ዮሃኒሳፔ ዱፂኬ ጊዲ ኦይኪዲ ዴዒሺን ኣሳ ኡባይ ማላሌቲዲ፥ ሶሎሞኔ ባራንዳ ጊያሶን ኢሲፌ ኤንታኮ ዎፂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","ጴፂሮሲ ኣሳ ቤዒዳ ዎዴ ኣሳኮ፥ «ኢስራዔሌ ኣሳው፥ ኣይስ ሃይሳን ማላሌቴቲ? ዎይኮ ኣይስ ኑና ጫዲ ፄሌቲ? ኑኒ ኑ ዎልቃን ዎይኮ ኑ ፂሎቴꬃን ሃ ኣዲያ ሃሙꬂዳባ ሂንቴው ዳኒ? ");
INSERT INTO gofENT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","ኣብራሃሜ፥ ዪሳቃ፥ ያይቆባ ፆሳይ፥ ኑ ኣዋታ ፆሳይ፥ ባ ናዓ ዬሱሳ ቦንቺስ። ሺን ሂንቴ ሃይቆስ ኣꬂ ኢሚዳይሳ ጲላፆሲ ቢላናው ኮዪንካ ሂንቴ ኢያ ሲንꬃን፥ ‹ኑኒ ኢያ ኤሮኮ› ያጊዴታ። ");
INSERT INTO gofENT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","ሂንቴ ጌሻኔ ፂሉዋ፥ ‹ኑኒ ኢያ ኤሮኮ› ጊዲ፥ ሼምፖ ዎꬊዳይሳ ሂንቴው ቢላና ሜላ ጲላፆሳ ዎሲዴታ። ");
INSERT INTO gofENT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","ዴዑዋ ኢሜይሳ ሂንቴ ዎꬊዴታ፥ ሺን ፆሳይ ሃይቆፔ ኢያ ዴንꬂስ። ሄሳስ ኑኒ ማርካ። ");
INSERT INTO gofENT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","ሃ ሂንቴ ቤዔይሲኔ ኤሪያ ኣዴይ ፓፂዲ ሚኒዳይ ዬሱሳ ሱንꬃን ኣማኒዳይሳና። ሃ ሂንቴ ኡባ ሲንꬃን ኢያ ሃይሳዳ ፓꬂዳይ ኢ ዬሱሳ ኣማኒዳ ጊሾሳ። ");
INSERT INTO gofENT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","«ሃዒካ ታ ኢሻቶ፥ ሂንቴካ ሂንቴና ካሌꬄይሳታዳ፥ ኤሮና ኦꬂዳይሳ ታኒ ኤራይስ። ");
INSERT INTO gofENT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","ሺን ፆሳይ ቤኒ ናቤታ ኡባ ዶናን፥ ‹ኪሪስቶሲ ዋዬ ኤካናው ቤሴስ› ያጊዳይሲ ሃይሳዳ ፖሌታና ሜላ ኦꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","ሂዛ፥ ፆሳይ ሂንቴ ናጋራ ኣቶ ጋና ሜላ ጎዳኮ ሲሚቴ። ");
INSERT INTO gofENT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ጎዳ ማታፔ ሚንꬄꬆ ዎዴይ ሂንቴው ያና። ፆሳይ ኪሪስቶሳ ጊዳና ሜላ ሲንꬃቲዲ ዶሪዳ ዬሱሳ ሂንቴው ዬዳና። ");
INSERT INTO gofENT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","ፆሳይ ባ ጌሻ ናቤታ ዶናን ቤኒ ኦዲዳይሳ ሜላ ኡባባይ ኦራፂያ ዎዴይ ጋካናው ዬሱሲ ሳሎን ጋምዓናው ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","ሙሴይ፥ ‹ጎዳ ፆሳይ ታና ዴንꬂዳይሳ ሜላ ሂንቴ ጊዶፌ ሂንቴው ናቤ ዴንꬃና። ሂንቴ ኢ ጌይሳ ኡባ ሲዒቴ። ");
INSERT INTO gofENT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","ሄ ናቤይ ኦዴይሳ ሲዖና ኣሲ ኦኒካ ኣሳ ጊዶፌ ሻኬቲዲ ꬋዮ› ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","«ቃሲ ሳሙዔላፔ ዶሚዲ ዴዒያ ናቤቲ ኡባይ ሃ ዎዲያባ ኦዲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","ሂንቴ ናቤታ ናይታ፤ ቃሲ ፆሳይ ኣብራሃሜስ፥ ‹ሳዓን ዴዒያ ኣሳ ኡባ ታኒ ኔ ሼሻ ባጋራ ኣንጃና› ያጊዲ ኑ ኣዋታስ ጌሊዳ ቃላ ላቲያ ናይታ። ");
INSERT INTO gofENT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","ፆሳይ ሂንቴና ኡባ ሂንቴ ኢታ ኦጊያፔ ዛሪዲ ኣንጃና ሜላ ባ ናዓ ዴንꬂዲ ሂንቴው ኮይሮ ዬዲስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","ጴፂሮሲኔ ዮሃኒሲ ኣሳስ ኦዲሺን ካሂኔ ሃላቃቲ፥ ፆሳ ኬꬃ ናጌይሳታ ሃላቃይኔ ሳዱቃዌቲ ኤንታኮ ዪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","ኤንቲ ዬሱሲ ሃይቆፔ ዴንዶይሳኔ ኢያ ጋሶን ሃይቆፔ ዴንዶይ ዴዔይሳ ኣሳ ታማርሲዳ ጊሾ ዪሎቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","ሄሳ ጊሾ፥ ኤንታ ኦይኪዲ ሳዓይ ኦማርሲዳ ጊሾ ዎንታና ጋካናው ቃሾ ኬꬂ ጌልሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","ሺን ቃላ ሲዒዳይሳታፔ ዳሮቲ ኣማኒዶሶና። ኣማኒዳ ኣዴ ኣሳ ታይቦይ ኢቻሹ ሙኩሉኮ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","ዎንቴꬃ ጋላስ ዴሪያ ሃሬይሳቲ፥ ጪማቲኔ፥ ሂጌ ኣስታማሬቲ ዬሩሳላሜን ሺቂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","ሄ ኣሳ ጊዶን ካሂኔ ሃላቃይ ሃኒ፥ ቃያፊ፥ ዮሃኒሲ፥ ኢስኪንዲሬይኔ ካሂኔ ሃላቃ ሶ ኣሳቲ ኡባይ ዴዖሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","ሃዋሬታ ባንታ ሲንꬃን ኤሲዲ፥ «ኣይቢ ዎልቃን ዎይኮ ኦዴ ሱንꬃን ሃይሳ ሂንቴ ኦꬂዴቲ?» ያጊዲ ኦይቺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","ሄ ዎዴ ጴፂሮሲ ጌሻ ኣያናን ኩሚዲ፥ «ዴሪያ ሃሬይሳቶ፥ ጪማቶ፥ ");
INSERT INTO gofENT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ሃቺ ሃ ዎቤ ኣዲያስ ኦሴቲዳ ሎዖ ኦሱዋሲኔ ኢ ዋኒዲ ፓፂዳኮ ሂንቴ ኑና ኦይቺኮ፥ ");
INSERT INTO gofENT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ማስቃሊያ ቦላ ሂንቴ ካቂን፥ ፆሳይ ሃይቆፔ ዴንꬂዳ ናዚሬቴ ዬሱስ ኪሪስቶሳ ሱንꬃን ሃ ኣዴይ ፓፂዲ ሂንቴ ሲንꬃን ኤቂዳይሲ ሂንቴዉኔ ኢስራዔሌ ኣሳ ኡባስ ኤሬቶ። ");
INSERT INTO gofENT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","‹ጊምቤይሳቲ ቦሪዲ ኢፂዳ ሹቻይ፥ ጎዳ ፃጱዋ ሚንꬂያ፥ ኡባፌ ኣꬊያ ሹቹ ጊዲስ፤ ሄ ሹቻይ ዬሱሳ።› ");
INSERT INTO gofENT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","ሄሳ ጊሾ፥ ኣቶቴꬂ ኢያ ባጋራፔ ኣቲን ሃራ ኦዴ ባጋራካ ባዋ። ኑኒ ኢያ ሱንꬃን ኣታና ሜላ ኣሳ ኡባስ ፆሳይ ሳሎፔ ጋርሳን ኢሚዳ ሃራ ሱንꬂ ባዋ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","ሺቂዳ ኣሳይ ጴፂሮሲኔ ዮሃኒሲ ሚኒዳ ሚኖቴꬃ ቤዒዳ ዎዴ ኤንቲ ታማሪቦና ጮ ኣሲ ጊዲዳይሳ ኣኬኪዲ ማላሌቲዶሶና፤ ኤንቲ ዬሱሳራ ዴዔይሳ ኤሪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","ቃሲ ፓፂዳ ኣዴይ ጴፂሮሳራኔ ዮሃኒሳራ ኤቂዳይሳ ኣሳይ ቤዒዲ ጊያባ ꬋዪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","ሺን ጴፂሮሳኔ ዮሃኒሳ ካሬ ኬያና ሜላ ኦꬂዲ ባንታ ጊዶን፥ ");
INSERT INTO gofENT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","«ሃ ኣሳታ ኑ ኣይ ኦꬂኖ? ኤንታ ኩሼን ኦሴቲዳ ጊታ ማላታይ ዬሩሳላሜን ዴዒያ ኡባስ ቤንቴስ። ኑኒ ሄሳ ኤሮኮ ጋናው ዳንዳዖኮ። ");
INSERT INTO gofENT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","ሺን ሃ ኦዳይ ኣሳ ጊዶን ላሌቶና ሜላ ሂዛፔ ጉዬ ሃ ኣሳቲ ዬሱሳ ሱንꬃን ኦዴስካ ኦዶና ሜላ ሚንꬂዲ ናጊሳና» ያጊዲ ዞሬቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","ኤንታ ፄጊዲ፥ ዬሱሳ ሱንꬃን ሂዛፔ ኦዶና ሜላ ዎይኮ ታማርሶና ሜላ ኪቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","ሺን ጴፂሮሲኔ ዮሃኒሲ ኤንታኮ ዛሪዲ፥ «ፆሳስ ኪቴታናይሳፌኔ ሂንቴው ኪቴታናይሳፌ ፆሳ ሲንꬃን ኣዉሲ ሎዖኮ ኣኔ ሂንቴ ፒርዲቴ። ");
INSERT INTO gofENT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","ኑኒ ቤዒዳባኔ ሲዒዳባ ኦዶና ኣጋናው ዳንዳዖኮ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","ቢታ ጪማቲኔ ዴሪያ ሃሬይሳቲ ካሴፔ ሚንꬂ ናጊሲዲ ኤንታ ዬዲ ኣጊዶሶና። ኣሳይ ሃኒዳባስ ፆሳ ጋላቲያ ጊሾ ኤንታ ሴራናው ዳንዳዒቦኮና። ");
INSERT INTO gofENT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","ሄ ማላታን ሃርጊያፌ ፓꬂዳ ኣዲያስ ላይꬃይ ኦይታማፔ ኣꬊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","ጴፂሮሲኔ ዮሃኒሲ ቢርሼቲዲ ባንታ ዳቦታኮ ቢዲ፥ ካሂኔ ሃላቃቲኔ ጪማቲ ባንታኮ ጊዳባ ኡባ ኤንታው ኦዲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","ኤንቲ ሄሳ ሲዒዳ ዎዴ ኢሲ ዎዛናን ጊዲዲ ፆሳ ሃይሳዳ ያጊዲ ዎሲዶሶና፡ «ኡባ ሃሪያ ጎዳው፥ ሳሉዋ፥ ሳዓ፥ ኣባኔ ኤንታ ጊዶን ዴዒያ ኡባባ ሜꬊዳይሶ፥ ");
INSERT INTO gofENT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","ኔኒ ኔ ኣይሊያ፥ ኑ ኣዋ ዳዊቴ ዶናን ጌሻ ኣያናን፥ ‹ዴሬይ ኣይስ ዪሎቲዶና? ኣሳይ ኣይስ ጮ ማቄቲዶና? ");
INSERT INTO gofENT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","ሳዓ ካዎቲኔ ዴሪያ ሃሬይሳቲ ኢሲፌ ጎዳ ቦላኔ ኪሪስቶሳ ቦላ ዴንዲዶሶና› ያጋዳሳ። ");
INSERT INTO gofENT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","«ቱማካ፥ ሄሮዲሲኔ ጴንፄ ጲላፆሲ ኣይሁዴ ጊዶና ኣሳራኔ ኢስራዔሌ ኣሳራ ኔ ዶሪዳ ኔ ጌሻ ናዓ ዬሱሳ ቦላ ዴንዳናው ሃ ካታማን ሺቂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","ቃሲ ኔኒ ኔ ዎልቃኒኔ ኔ ሼኒያን ኦꬃና ጋዳ ቆፓ ኡቲዳባ ኡባ ፖሊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","ሃዒካ ጎዳው፥ ኤንታ ማንዴꬃ ቤዓ፤ ኑኒ ኔ ኣይሌቲ ኔ ቃላ ኩሜꬃ ዎዛናን ኦዳና ሜላ ኑና ዳንዳዒሳ። ");
INSERT INTO gofENT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","ኔ ጌሻ ናዓ ዬሱሳ ሱንꬃን ሃርጋንቾታ ፓꬃናው፥ ኦራꬃባይኔ ማላታቲ ኦሴታና ሜላ ኔ ኩሺያ ሚጫ» ጊዲ ዎሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","ኤንቲ ፆሳ ዎሲዳፔ ጉዬ ሄ ኤንቲ ሺቂዳሶይ ቃፂስ። ኤንታ ኡባን ጌሻ ኣያኒ ኩሚን ፆሳ ቃላ ሚኖቴꬃን ኦዲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","ኣማኔይሳቲ ኡባይ ቆፋኒኔ ዎዛናን ኢሲኖ ጊዲዶሶና። ኤንቲ ባንታው ዴዒያባ ታባ ጎናሺን ኢሲፌ ሻኬቶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","ሃዋርቲ ጎዳ ዬሱሲ ሃይቆፔ ዴንዲዳይሳ ጊታ ዎልቃን ማርካቶሶና። ፆሳይ ኤንታ ኡባስ ኣꬎ ኬሃቴꬃ ዳርሲዲ ኢሚስ። ");
INSERT INTO gofENT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","ቢቲ ዎይኮ ኬꬂ ዴዔይሳቲ ኡባይ ባይዚ ኤኪዳ ሚሺያ ኤሂያ ጊሾ ኣማኔይሳታ ጊዶን ሜቶታንቾይ ኢሶይካ ባዋ። ");
INSERT INTO gofENT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ሚሺያ ኤሂዲ ሃዋሬታስ ኢሞሶና፤ ሄ ሚሺያ ኢሱዋስ ኢሱዋስ ኮሼይሳዳ ሻኪ ሻኪ ኢሜስ። ");
INSERT INTO gofENT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","ቆጲሮሳ ጊያ ቤሳን ዬሌቲዳ ዮሴፋ ጊያ ሌዌ ሼሻፔ ጊዲዳ ኢሶይ ዴዔስ። ኢያ ሱንꬃ ሃዋሬቲ ባርናባሳ (ሚንꬄꬆ ናዓ) ጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","ባርናባሲ ባው ዴዒያ ቢታ ባይዚዲ ሚሺያ ኤሂዲ ሃዋሬታስ ኢሚስ። ");
INSERT INTO gofENT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","ኢሲ ሃናኒያ ጊያ ኣዴይ ባ ማቼ ሳጲሪራ ጋዴ ባይዚስ። ");
INSERT INTO gofENT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","ሄ ባይዚዳ ሚሺያፔ ባ ማቺያ ኤሪሺን ባጋ ኣሺዲ፥ ኣቲዳይሳ ኤሂዲ ሃዋሬታስ ኢሚስ። ");
INSERT INTO gofENT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","ሺን ጴፂሮሲ ሃናኒያኮ፥ «ኔኒ ጌሻ ኣያና ጪማና ሜላኔ ጋዲያ ባይዚዳ ሚሺያፔ ሻካዳ ኣሻና ሜላ ፃላሄይ ኔ ዎዛናን ኣይስ ጌሊዴ? ");
INSERT INTO gofENT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","ኔኒ ባይዛናፔ ካሴ ጋዴይ ኔባ ጊዴኔዬ? ቃሲ ኔኒ ባይዛ ሲሚንካ ሚሼይ ኔባ ጊዴኔዬ? ያቲን፥ ሄሳ ሜላባ ኦꬃናው ኣይስ ኔ ዎዛናን ቆፓዲ? ኔኒ ፆሳ ቦላ ዎርዶታዳሳፔ ኣቲን ኣሳ ቦላ ዎርዶታባካ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","ሃናኔይ ሄ ቃላ ሲዒዳ ሜላ ኩንዲዲ ሃይቂስ፤ ሄሳ ሲዒዳ ኡባይ ዳሮ ያዪስ። ");
INSERT INTO gofENT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","ናዓቴꬃ ኣሳቲ ሶ ጌሊዲ ኢያ ኣሃ ፃፂዲ ኤፊዲ ሞጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","ሄꬑ ሳቴፔ ጉዬ ሃናኒያ ማቺያ ሄሳ ኤሮና ዴዓሼ ጴፂሮሲ ዴዒያሱዋ ጌላሱ። ");
INSERT INTO gofENT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","ጴፂሮሲ ኢኮ፥ «ሂንቴ ጋዲያ ሃይሳ ሜላ ሚሼስ ባይዚዴቲ? ኣኔ ታው ኦዳ» ያጊስ። ኢያካ፥ «ኤ፥ ሃይሳ ሜላ ሚሼስ ባይዚዳ» ያጋሱ። ");
INSERT INTO gofENT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","ጴፂሮሲ ማጫሲው፥ «ኔራኔ ኔ ኣዚናራ ጎዳ ኣያና ፓጫናው ኣይስ ዞሬቲዴቲ? ሄኮ፥ ኔ ኣዚና ሞጊዳ ኣሳቲ ካሬን ዴዖሶና፤ ኔናካ ኤንቲ ካሬ ኬሳና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","ማጫሲያ ኢራካ ጴፂሮሳ ቶሁዋ ማታን ኩንዳዳ ሃይቃ ኣጋሱ፤ ናዓቴꬃቲ ጌሊያ ዎዴ ሃይቂዳሮ ዴሚዲ ካሬ ኬሲዲ፥ ኢ ኣዚና ማታን ሞጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","ኩሜꬃ ዎሳ ኬꬃይኔ ሄሳ ሲዒዳ ሃራ ኣሳ ኡባይ ዳሮ ያዪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","ሃዋሬቲ ዳሮ ማላታታኔ ኦራꬃባታ ኣሳ ጊዶን ኦꬆሶና። ኣማኒያ ኡባይ ሶሎሞኔ ባራንዳን ኢሲፌ ሺቆሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","ሃራ ኣሳፔ ኤንታራ ጋሄታናው ኢሲ ኣሲካ ሚኒቤና፥ ሺን ኣሳይ ኤንታ ቦንቼስ። ");
INSERT INTO gofENT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","ኣማኒያ ኣዴታኔ ማጫሳታ ታይቦይ ካሴይሳፌ ዳሪሼ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","ሄሳ ጊሾ፥ ኣሳይ ሃርጋንቾታ ሃላኒኔ ኣልጋን ቶኪዲ ጴፂሮሲ ኣꬊያ ዎዴ ኢያ ኩያይ ኤንታፌ ኢሶታ ኢሶታ ቦላ ሼምፓና ሜላ ኦጌ ዶናን ኬሲዲ ዎꬆሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","ቃሲ ዳሮ ኣሳይ ዬሩሳላሜ ማታን ዴዒያ ካታማታፔ ሃርጋንቾታኔ ቱና ኣያኒ ዋይሲያ ኣሳታ ኤኪዲ ዮሶና፤ ኡባይካ ፓፂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","ካሂኔ ሃላቃይኔ ኢያራ ዴዒያ ሳዱቃዌቲ ኡባይ ቃናቴን ኩሚዲ ሃዋሬታ ቦላ ዴንዲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","ሃዋሬታ ኦይኪዲ ዴሪያ ቃሾ ኬꬃን ዬጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","ሺን ጎዳ ኪታንቾይ ቃማ ቃሾ ኬꬃ ፔንጊያ ዶዪዲ ሃዋሬታ ካሬ ኬሲዲ፥ ");
INSERT INTO gofENT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","«ቢዲ፥ ፆሳ ኬꬃን ኤቂዲ ሃ ኦራꬃ ዴዖ ቃላ ኣሳ ኡባስ ኦዲቴ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","ሃዋሬቲ ሄሳ ሲዒዳ ዎዴ ዎንታ ጉራ ፆሳ ኬꬂ ጌሊዲ ታማርሶ ዶሚዶሶና። ካሂኔታ ሃላቃይኔ ኢያራ ዴዔይሳቲ ዪዲ፥ ኢስራዔሌ ጪማታ ኡባ ፄጊ ሺሺዲ ሃዋሬታ ባንታ ሲንꬄ ኤሃና ሜላ ዎታዳሬታ ቃሾ ኬꬂ ኪቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","ሺን ዎታዳሬቲ ቃሾ ኬꬂ ቢዲ ሃዋሬታ ዴሚቦኮና። ጉዬ ሲሚ ዪዲ ዴሪያስ፥ ");
INSERT INTO gofENT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","«ኑኒ ቢያ ዎዴ ቃሾ ኬꬃ ፔንጌይ ሚንꬂ ጎርዴቲን፥ ናጌይሳቲ ፔንጌን ኤቂዳይሳታ ዴሚዳ። ሺን ኑኒ ካሪያ ዶያ ዎዴ ጊዶን ሃሪ ኣቶሺን ኢሲ ኣሲካ ባዋ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","ሄሳ ጊሾ፥ ፆሳ ኬꬃ ዎታዳሬታ ኪቴይሲኔ ካሂኔ ሃላቃቲ ሄሳ ሲዒዳ ዎዴ «ሃዋሬታ ቦላ ኣይቢ ሃኒዴ?» ያጊዲ ሂርጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","ሄ ዎዴ ኢሲ ኣዴይ ኤንታኮ ዪዲ፥ «ሄኮ፥ ቃሾ ኬꬂ ሂንቴ ጌልሲዳ ኣሳቲ ፆሳ ኬꬃን ኤቂዲ ኣሳ ታማርሶሶና» ያጊዲ ኤንታው ኦዲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","ፆሳ ኬꬃ ዎታዳሬታ ኪቴይሲ ባ ዎታዳሬታራ ቢዲ ሃዋሬታ ኤሂስ። ሺን ኤንቲ ባንታና ኣሳይ ሹቻን ጫዳና ጊዲ ያዪዳ ጊሾ ኤንታ ኣዳሺዲ ኤሂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","ኤንቲ ሃዋሬታ ኤሂዲ፥ ሺቂዳ ሻንጉዋ ሲንꬃን ኤሲን ካሂኔ ሃላቃይ ኤንታኮ፥ ");
INSERT INTO gofENT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","«ሂንቴና ኑኒ ሄ ኡራ ሱንꬃን ታማርሶና ሜላ ሚንꬂዲ ኪቲቦኮ? ሄኮ፥ ሂንቴ ቲሚርቲያ ዬሩሳላሜ ካታማ ኡባ ጋꬂዴታ። ሄ ኡራ ሼምፑዋስ ኑና ኦይꬃናው ቆፔቲ?» ያጊዲ ኦይቺስ። ");
INSERT INTO gofENT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","ጴፂሮሳራኔ ሃንኮ ሃዋሬታራ ኤንታው ዛሪሼ፥ «ኑኒ ኣሳስ ኪቴታናፔ ፆሳስ ኪቴታናው ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","ማስቃሊያ ቦላ ሂንቴ ካቂዲ ዎꬊዳ ዬሱሳ ኑ ኣዋታ ፆሳይ ሃይቆፔ ዴንꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","ኢስራዔሌቲ ናጋራፔ ሲማና ሜላኔ ኤንታ ናጋራይ ኣቶ ጌቴታና ሜላ ፆሳይ ዬሱሳ ሃሬይሳኔ ኣሼይሳ ኦꬂዲ ቦንቾን ባፔ ኡሻቻ ባጋን ኡቲሲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","ሄሳስ ኑኒ ማርካ፤ ቃሲ ፆሳይ ባና ኣማኔይሳታስ ኢሚዳ ጌሻ ኣያናይካ ማርካ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","ሺቂዳ ኣሳይ ሄሳ ሲዒዳ ዎዴ ዳሮ ዪሎቲዲ፥ ሃዋሬታ ዎꬋናው ቆፒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","ሺን ኣሳ ኡባን ዳሮ ቦንቼቲዳ፥ ሂጌ ኣስታማሬይ፥ ጋማሊያሌ ጊያ ኢሲ ፋሪሳዌይ ዴንዲ ኤቂዲ ሃዋሬታ ጉꬃ ዎዴስ ካሬ ኬሳና ሜላ ኪቲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","ሄሳፌ ጉዬ፥ ሺቂዳ ኣሳኮ፥ «ኢስራዔሌ ኣሳው፥ ሃ ኣሳታ ቦላ ሂንቴ ኦꬃናው ቆፒያባፔ ናጌቲቴ። ");
INSERT INTO gofENT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","ኣይስ ጊኮ፥ ሃይሳፌ ካሴ ቴዎዳሲ ባና፥ ‹ታኒ ጊታ› ጊዲ ዴንዲን፥ ኦይዱ ፄቱ ጊዲያ ኣሳቲ ኢያራ ኢሲፊዶሶና። ሺን ኢያ ዎꬊን ኢያ ካሊዳ ኡባይ ላሌቲን ፓꬆና ኣሲ ጊዲዲ ኣቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","ሄሳፌ ጉዬ፥ ኣሳይ ታይቤቲያ ዎዴ ጋሊላ ዪሁዲ ዴንዲዲ ዳሮ ኣሳ ፓንጋዪዲ ካሌꬂስ፥ ሺን ኢያካ ዎꬊን ኢያ ካሊዳ ኣሳ ኡባይ ላሌቲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","ሃዒካ ታ ሂንቴው ኦዳይስ፤ ሃ ኣሳታፔ ሻኬቲቴ፤ ኤንታ ቦቾፊቴ። ኣይስ ጊኮ፥ ሃ ቆፋኔ ሃ ኦሱዋ ኣሲ ኦꬂያባ ጊዲኮ ꬋያና። ");
INSERT INTO gofENT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","ሺን ሃ ቆፋይኔ ሃ ኦሶይ ፆሳፌ ዪዳባ ጊዲኮ፥ ሂንቴ ኤንታ ꬋይሳናው ዳንዳዔኬታ። ጌላዳ ያኒሼ ሂንቴ ፆሳራ ካጬታና» ያጊዲ ኦዲስ። ሄሳ ጊሾ፥ ሺቂዳ ኣሳይ ጋማሊያሌ ዞሪያ ኤኪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","ሃዋሬታ ሶ ፄጊዲ ሊሶን ጋራፊሲስ። ሄሳፌ ጉዬ፥ ኤንታኮ፥ «ዬሱሳ ሱንꬃ ናምዓንꬆ ዴንꬆፊቴ» ጊዲ ቢርሺ ዬዲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","ዬሱሳ ሱንꬃ ጊሾ ኤንቲ ካዉያናይሲ ቤሲያባ ጊዴይሳ ኤሪዳ ጊሾ ሻንጉዋ ሲንꬃፌ ኡፋይቲሼ ኬዪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","ኤንቲ ኡባ ዎዴ ፆሳ ኬꬃኒኔ ኣሳ ሶን ዬሱሲ ኢ ኪሪስቶሳ ጊዴይሳ ታማርሶኔ ሳባኮ ኣጊቦኮና። ");
INSERT INTO gofENT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","ሄ ዎዴ ካሌይሳታ ታይቦይ ዳሪ ዳሪ ቢሺን፥ ጊሪኬ ዶና ኦዴቲያ ኣይሁዴቲ ዪሁዳን ዬሌቲዲ ዴዒያ ኣይሁዴታ ቦላ ዙዙሚዶሶና። ኣይስ ጊኮ፥ ጊሪኬ ዶና ኦዴቲያ ኣይሁዴቲ፥ «ጋላስ ጋላስ ኢሜቲያ ካꬃን ኑ ኣምዔቲ ናቄቶሶና» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","ታማኔ ናምዑ ሃዋሬቲ ዎሳ ኬꬃ ኣሳ ኡባ ፄጊዲ፥ «ኑኒ ፆሳ ቃላ ኦዴይሳ ኣጊዲ ካꬂ ጊሻናው ኑስ ቤሴና። ");
INSERT INTO gofENT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","ሂዛ፥ ኢሻቶ፥ ሎዖ ኣሳታ፥ ጌሻ ኣያናኒኔ ጪንጫቴꬃን ኩሚዳ ላፑን ኣሳታ ሂንቴ ጊዶፌ ዶሪቴ፤ ኑኒ ኤንታ ሃ ኦሱዋስ ሹማና። ");
INSERT INTO gofENT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","ሺን ኑኒ፥ ኑ ኩሜꬃ ዎዲያ ፆሳ ዎሳኒኔ ቃላ ታማርሶን ፔሻና» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","ሃዋሬቲ ኦዲዳ ኦዳይ ኣሳ ኡባ ኡፋይሲስ። ሄሳ ጊሾ፥ ኣማኖይኔ ጌሻ ኣያኒ ኩሚዳ ኢስፂፋኖሴ፥ ፊልጶሳ፥ ጲሮኮሮሳ፥ ኒቃሮኔ፥ ፂሞና፥ ጳርሜናኔ ኣይሁዴ ኣማኖ ጌሊ ሲሚዳ ኣንፆኪያ ኒቆላዎሳ ዶሪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","ኤንታ ሃዋሬታ ሲንꬃን ኤሲን፥ ሃዋሬቲ ኤንታ ቦላ ኩሼ ዎꬂዲ ፆሳ ዎሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","ፆሳ ቃላይ ዳልጊ ዳልጊ ቢስ። ዬሩሳላሜን ዴዒያ ኣማኔይሳታ ታይቦይ ዳሪ ዳሪ ቢስ፤ ዳሮ ካሂኔቲካ ኣማኒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","ኢስፂፋኖሴይ ኣꬎ ኬሃቴꬃኒኔ ዎልቃን ኩሚዲ ኣሳ ጊዶን ኦራꬃባታኔ ማላታታ ኦꬄስ። ");
INSERT INTO gofENT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","ኣይሌቴꬃፌ ኬዪዳ ኣይሁዴ ዎሳ ኬꬃ ኣሳይ ቄሬናፔኔ ኢስኪንዲሪያፔ ኪልቂያፌኔ ኢሲያፔ ዪዳ ኢሲ ኢሲ ኣሳቲ ዴንዲዲ ኢስፂፋኖሴራ ፓላሚዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","ሺን ኢስፂፋኖሴይ ኣያና ዎልቃን ኦዴቲያ ጪንጫቴꬃ ኤንቲ ኤቄታናው ዳንዳዒቦኮና። ");
INSERT INTO gofENT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","ሄ ዎዴ ኤንቲ፥ «ሙሴኔ ፆሳ ኢ ጫዪሺን ሲዒዳ» ጊያ ዎርዶ ኣሳታ ሻሚዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","ሄሳዳ ኦꬂዲ ቢታ ጪማታኔ ሂጌ ኣስታማሬታ ኢያ ቦላ ዴንꬂዶሶና። ኢስፂፋኖሴ ኦይኪዲ ሻንጉዋ ሲንꬄ ኤፊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","ኢያ ቦላ ፓይዲዳ ዎርዶ ማርካቲ፥ «ሃ ኡራይ ሃ ፆሳ ኬꬃኔ ሙሴ ሂጊያ ዛሪ ዛሪ ጫዬስ። ");
INSERT INTO gofENT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","ኢ፥ ‹ሃይሲ ናዚሬቴ ዬሱሲ፥ ሃ ፆሳ ኬꬃ ላላና፤ ቃሲ ሙሴይ ኑስ ኢሚዳ ሂጊያ ላማና› ያጊሺን ኑኒ ሲዒዳ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","ሻንጎ ሺቆን ኡቲዳ ኣሳ ኡባይ ኢስፂፋኖሴ ሎይꬂዲ ፄሊያ ዎዴ ኢያ ሶምዖይ ኪታንቾ ሶምዖ ዳኔስ። ");
INSERT INTO gofENT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","ካሂኔታ ሃላቃይ ኢስፂፋኖሴኮ፥ «ሃይሲ ቱሜ?» ያጊዲ ኦይቺስ። ");
INSERT INTO gofENT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","ኢስፂፋኖሴይ፥ «ታ ኢሻቶ፥ ታ ኣዋቶ፥ ሲዒቴ! ኑ ኣዋ ኣብራሃሜይ ካራኔን ዳናው ባናፔ ሲንꬄ ማሴጴፆሚያን ዴዒሺን፥ ቦንቾ ፆሳይ ኢያው ቆንጪዲ፥ ");
INSERT INTO gofENT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","‹ኔ ቢታፌኔ ኔ ዳቦታፔ ሻኬታዳ ታኒ ኔና ቤሲያ ቢታ ባ› ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","ሄ ዎዴ ኣብራሃሜይ ካልዳዌታ ቢታፌ ኬዪዲ ካራኔን ዳናው ቢስ። ኢያ ኣዋይ ሃይቂዳፔ ጉዬ ፆሳይ ኢያ ሃ ቢታ ሃዒ ሂንቴ ዴዒያ ቤሳ ኤሂስ። ");
INSERT INTO gofENT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","ኢ ሃ ቢታፌ ሃሪ ኣቶሺን ቶሆይ ዬꬊያ ቤሲካ ኣብራሃሜስ ኢሚቤና። ሺን ናዒ ኢያው ባይና ዎዴ ፆሳይ ሃ ቢታ ኢያዉኔ ኢያ ሼሻስ ላታ ኦꬂዲ ኢማናይሳ ቃላ ጌሊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","ፆሳይ ኣብራሃሜኮ፥ ‹ኔ ሼሻይ ሃራ ቢታን ኢማꬃቴꬃን ዳና፤ ያን ኦይዱ ፄቱ ላይꬂ ኤንቲ ኣይሌቴꬃን ሃሬታና። ");
INSERT INTO gofENT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","ሺን ታኒ ኔ ሼሻ ሃሪያ ዴሪያ ቦላ ፒርዳና። ሄሳፌ ጉዬ፥ ኤንቲ ሄ ቢታፌ ኬዪዲ ሃይሳን ታው ጎይናና› ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","ፆሳይ ኣብራሃሜ ሼሻይ ቃፃሬታና ሜላ ኢያራ ጫቂን፥ ዪሳቂ ዬሌቲዳ ሆስፑንꬃ ጋላሳን ቃፃሪስ። ዪሳቂ ያይቆባ ቃፃሪስ፤ ቃሲ ያይቆቢ ታማኔ ናምዑ ባ ናይታ፥ ኑ ኣዋታ ማይዛታ ቃፃሪስ። ");
INSERT INTO gofENT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","«ያይቆባ ናይቲ ዮሴፋ ቃናቲዲ ጊብፄ ቢታን ኣይሌቴꬃስ ባይዚዶሶና፥ ሺን ፆሳይ ኢያራ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ኢያ፥ ኢያ ዋዬ ኡባፌ ኬሲስ። ጊብፄ ካዉዋ ሲንꬃን ሳባኔ ጪንጫቴꬂ ኢያው ኢሚስ። ጊብፄ ካዎይ ዮሴፋስ ጊብፄ ቢታኔ ባ ኬꬃ ኡባ ኣይሳናዳ ሃላቃቴꬂ ኢሚስ። ");
INSERT INTO gofENT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","«ጊብፄ ቢታኒኔ ካናኔ ቢታ ኡባን ኮሺ ጌሊዲ ዳሮ ኣሳ ኡንዔꬂስ። ሄ ዎዴ ኑ ማይዛቲ ካꬂ ዴማናው ዳንዳዒቦኮና። ");
INSERT INTO gofENT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","ያይቆቢ ጊብፄ ቢታን ካꬂ ዴዔይሳ ሲዒዲ ኑ ኣዋታ ኮይሮ ያ ዬዲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","ናምዓንꬆ ቡሳን ዮሴፊ ባ ኢሻታስ ባናቴꬃ ኤሪሲስ። ጊብፄ ካዎይካ ዮሴፋ ሼሻ ኤሪስ። ");
INSERT INTO gofENT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","ዮሴፊ ባ ኣዋ ያይቆባኔ ባ ዳቦ ኡባ፥ ላፑን ታማኔ ኢቻሹ ኣሳ ባኮ ያና ሜላ ኪቲዲ ኤሂሲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","ያይቆቢ ጊብፄ ቢታ ዎꬊስ፤ ኢኔ ኢያ ናይቲ ያን ሃይቂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","ኤንታ ኣሃይ ሄ ቤሳፌ ሴኬሜ ቢታ ቶኬቲዲ ቢዲ፥ ያን ኣብራሃሜይ ሃሞሬ ናይታፔ ዳሮ ቢራን ሻሚዳ ዱፎን ሞጌቲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","«ሺን ፆሳይ ኣብራሃሜስ ኢማና ጊዳይሳ ፖሊያ ዎዴይ ጋካናው ማቲዳ ዎዴ ጊብፄ ቢታን ዴዒያ ኑ ኣሳይ ዳሪ ዳሪ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","ሄሳፌ ጉዬ፥ ዮሴፋ ኤሮና ሃራ ካዎይ ጊብፄ ቢታን ካዎቲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","ሄ ካዎይ ኑ ዜሬꬃ ጌኒዲ ጉꬃ ናይቲ ሃይቃና ሜላ ኤንታ ካሬ ኬሲ ዬጋና ሜላ ኑ ኣዋታ ኡንዔꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","«ሄ ዎዴ ሙሴይ ዬሌቲስ፤ ኢ ፆሳ ሲንꬃን ዳሮ ሎዖ ናዓ። ባ ኣዋ ኬꬃን ሄꬑ ኣጌና ጋካናው ዲጪስ። ");
INSERT INTO gofENT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","ሙሴይ ዎራ ሆሌቲዳ ዎዴ ጊብፄ ካዉዋ ናዒያ ዴማ ኤካዳ ባ ናዓ ኦꬃዳ ኢያ ዲቻሱ። ");
INSERT INTO gofENT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","ሙሴይ ጊብፄታ ጪንጫቴꬃ ኡባ ታማሪዲ ኦዳኒኔ ኦሶን ሚኖ ኣሲ ጊዲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","«ሙሴስ ላይꬃይ ኦይታማ ኩሚዳ ዎዴ ባ ኢሻታ፥ ኢስራዔሌታ ቤዓናው ባ ዎዛናን ቆፒስ። ");
INSERT INTO gofENT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","ኢስራዔላታፔ ኢሱዋ ጊብፄ ኢሶይ ቆሂሺን ቤዒዲ ሄ ኢስራዔሌ ኡራ ማዲዲ፥ ሄ ቆሂዳ ጊብፄ ኡራ ዎꬊዲ ኩሼ ዛሪስ። ");
INSERT INTO gofENT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","ሙሴይ ባ ኢሻታ ባ ባጋራ ፆሳይ ኣሻናው ሃኔይሳ ኤንቲ ኣኬካና ጊዲ ቆፒስ፥ ሺን ኤንቲ ኣኬኪቦኮና። ");
INSERT INTO gofENT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","«ዎንቴꬃ ጋላስ ናምዑ ኢስራዔሌ ኣሳቲ ኢሶይ ኢሱዋራ ዋꬌቲሺን ዴሚዲ ኤንታ ሲጌꬃናው ኮዪዲ፥ ‹ኣሳቶ፥ ሂንቴ ኢሻንታ፤ ኣይስ ኢሶይ ኢሱዋ ቆሄቲ?› ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","«ሺን ባ ላጊያ ቆሄይሲ ሙሴኮ፥ ‹ኔና ኑ ቦላ ሃሬይሳኔ ዳይና ኦꬂዳይ ኦኔ? ");
INSERT INTO gofENT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","ኔኒ ዚኔ ጊብፄ ኡራ ዎꬊዳይሳዳ ታና ዎꬋናው ኮያይ?› ያጊዲ ሙሴ ሱጊ ዬዲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","ሙሴይ ሄሳ ሲዒዳ ዎዴ ጊብፄፌ ቤቲዲ ሚዲያሜ ቢታን ቤቴ ኣሲ ጊዲዲ ዴዒሼ ናምዑ ኣዴ ናይታ ዬሊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","«ጎዳ ኪታንቾይ ኦይታሙ ላይꬃፌ ጉዬ ሲና ዴሪያ ማታን ዴዒያ ባዞ ቱሺያ ጊዶን ኤፂያ ታማ ላጮ ጊዶን ሙሴስ ቤንቲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","ሙሴይ ባ ቤዒዳይሳን ማላሌቲዲ፥ ሎይꬂ ቤዓናው ቱሺያ ማቲ ሺቂዲ ዴዒሺን፥ ጎዳ ቃላይ፥ ");
INSERT INTO gofENT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‹ታኒ ኔ ኣዋታ፥ ኣብራሃሜ ፆሳ፥ ዪሳቃ ፆሳ፥ ያይቆባ ፆሳ› ያጊሼ ሙሴኮ ዪስ። ሙሴይ ያሻን ኮኮሪዲ ፄላናው ዳንዳዒቤና። ");
INSERT INTO gofENT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","«ጎዳይ ሙሴኮ፥ ‹ኔኒ ኤቂዳ ቢታይ ጌሺ ጊዲያ ጊሾ ኔ ቶሁዋን ዴዒያ ጫማ ኬሳ። ");
INSERT INTO gofENT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","ታኒ ጊብፄን ዴዒያ ታ ኣሳ ኡንዔቴꬃ ቤዓስ። ኤንታ ዋሱዋ ሲዓዳ ኤንታ ኣሻናው ዎꬋስ። ሃዒ ሃያ! ታኒ ኔና ጊብፄ ኪታና› ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","«ኢስራዔሌቲ ሙሴ፥ ‹ኔና ኑና ሃሬይሳኔ ዳይና ኦꬂዳይ ኦኔ?› ያጊዲ ኢፂዳይሳ ቱሺያ ጊዶን ኢያው ቤንቲዳ ኪታንቹዋ ባጋራ ሃሬይሳኔ ኣሼይሳ ኦꬂዲ ፆሳይ ኪቲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","ሙሴይ ኢስራዔሌታ ጊብፄፌ ኬሲዲ ማላሊሲያባታኔ ኦራꬃባታ ጊብፄ ቢታኒኔ ዞዖ ኣባን ኦꬂዲ ኤንታ ኦይታሙ ላይꬂ ባዞ ቢታን ካሌꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","«ኢስራዔሌ ኣሳኮ፥ ‹ፆሳይ ታና ዴንꬂዳይሳዳ ሂንቴ ሼሻ ጊዶፌ ታ ሜላ ናቤ ሂንቴው ዴንꬃና› ያጊዳይ ሄ ሙሴ። ");
INSERT INTO gofENT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","ባዞ ቢታን ሺቂዳ ኢስራዔሌ ኣሳራ ዴዒዳይሲ፥ ኑ ኣዋታራኔ ሲና ዴሪያ ቦላ ኢያው ኦዲዳ ኪታንቹዋራ ዴዒዳ ሙሴይ ኢያ። ያቲዲ፥ ፆሳ ዴዖ ቃላ ኑስ ኢማናው ኤኪስ። ");
INSERT INTO gofENT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","«ሺን ኑ ማይዛቲ ሙሴስ ኪቴታናው ዶሲቦኮና፤ ኢያ ኢፂዲ ጉዬ ጊብፄ ሲማናው ኣሞቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","ቃሲ ኣሮናኮ፥ ‹ኑና ካሌꬂያ ፆሳታ ኑስ ኦꬃ። ኣይስ ጊኮ፥ ሃይሲ ኑና ጊብፄፌ ኤሂዳ ሙሴይ፥ ዋኒዳኮ ኑኒ ኤሮኮ› ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","ሄ ዎዴ ማሪ ዳኒሲዲ ኤቃ ኦꬂዶሶና። ሄ ኤቃስ ያርሾ ያርሺዲ ባንታ ኩሼን ኦꬂዳ ኦሱዋን ኡፋይቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","ሺን ፆሳይ ኤንታው ዞኮ ዛሪስ። ኤንቲ ሳሎ ፆሊንቶታ ጎይናና ሜላ ኤንታ ዬጊ ኣጊስ። ናቤታ ማፃፋን፥ ‹ኢስራዔሌ ኣሳው፥ ኦይታሙ ላይꬂ ኩሜꬂ ባዞ ቢታን ሹኪዳ ሜሂያኔ ያርሺዳ ያርሹዋ ታው ያርሺዴቲ? ");
INSERT INTO gofENT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","ሂንቴ፥ ሂንቴው ጎይናናው ኬሲዳ ኤቃኔ ሞሎኬ ዱንካኒያ ሬፋና ጊያ ሂንቴ ፆሳ ፆሊንቶ ሚሲሊያ ቶኪዴታ። ታኒ ሂንቴና ባቢሎኔፔ ሂኒ ባጋ ዬዳና› ጌቴቲዲ ፃፌቲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","«ኑ ኣዋታስ ባዞ ቢታን ማርካ ዱንካኔይ ዴዔስ። ኢያካ ፆሳይ ሙሴ ኪቲዳይሳዳኔ ኢያ ቤሲዳይሳዳ ኦꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","ቃሲ ኑ ኣዋቲ ሄ ዱንካኒያ ባንታ ኣዋታፔ ኤኪዲ ፆሳይ ካሴ ዬዴꬂዳ ኣይሁዴ ጊዶና ኣሳ ቢታ ኦይኪዳ ዎዴ ኢያሱራ ያ ኤኪዲ ጌሊዶሶና። ሄ ዱንካኔይ ዳዊቴ ዎዴ ጋካናዉካ ሄ ቤሳን ዴዒስ። ");
INSERT INTO gofENT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","ዳዊቴይ ፆሳን ሳቤቲስ። ቃሲ ያይቆባ ጎዳይ ዴዓና ኬꬃ ኬፃናው ፆሳ ዎሲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","ሺን ኢያው ኬꬃ ኬፂዳይ ሶሎሞኔ። ");
INSERT INTO gofENT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","«ሃኖሺን፥ ኡባፌ ቦላ ፆሳይ ኣሲ ኬፂዳ ኬꬃን ዴና። ናቤይ ጊዳይሳ ሜላ፥ ");
INSERT INTO gofENT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‹ሳሎይ ታ ኣራታ፥ ሳዓይካ ታ ቶሆይ ዬꬊያሶ። ያቲን፥ ታው ሂንቴ ኣይ ሜላ ኬꬂ ኬፃኔ? ዎይኮ ታኒ ሼምፒያሶይ ኣዉኔ? ");
INSERT INTO gofENT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","ሃ ኡባ ታ ኩሺያን ኦꬃቢኪና?› ያጌስ ጎዳይ። ");
INSERT INTO gofENT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","«ሂንቴ ዋኒዳ ሲዖና ኣሴ? ሂንቴ ዎዛናይ ፆሳ ቃላ ኤካናው ኣይስ ኢፂዴ? ሂንቴ ሃይꬃይ ኣይስ ቱሊዴ? ሂንቴ፥ ሂንቴ ኣዋታꬆ ኡባ ዎዴ ጌሻ ኣያናራ ኤቄቴታ። ");
INSERT INTO gofENT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","ናቤታ ጊዶፌ ሂንቴ ኣዋቲ ጎዶናይ ኦኔ? ፆሳ ናዓይ፥ ፂሎይ ያናይሳ ካሴቲዲ ኦዲዳይሳታ ዎꬊዶሶና። ሃዒ ሂንቴ ኢያ ኣꬂ ኢሚዲ ዎꬊዴታ። ");
INSERT INTO gofENT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","ሂንቴ ኪታንቹዋ ኩሼፔ ፆሳ ሂጊያ ኤኪዴታ፥ ሺን ኪቴቲቤኬታ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","ኤንቲ ሄሳ ሲዒዳ ዎዴ ባንታ ዎዛናን ኢስፂፋኖሴ ቦላ ዳሮ ዪሎቲዲ፥ ባንታ ሜቴርሻ ሳፂዲ ማንዲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","ሺን ኢስፂፋኖሴይ ጌሻ ኣያናን ኩሚዲ፥ ሳሎ ፑዴ ፄሊዲ፥ ፆሳ ቦንቹዋኔ ዬሱሳ ፆሳ ኡሻቻ ባጋን ኤቂዳይሳ ቤዒስ። ");
INSERT INTO gofENT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","«ሄኮ፥ ታኒ ሳሎይ ዶዬቲን፥ ኣሳ ናዓይ፥ ፆሳ ኡሻቻ ባጋን ኤቂዳይሳ ቤዓይስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","ቃላ ꬎቁ ኦꬂዲ ዋሲሼ፥ ባንታ ሃይꬃ ኦይኪዲ ኢሲፌ ኢያኮ ዎፂዶሶና ");
INSERT INTO gofENT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ኢያ ካታማፔ ጋፃ ኬሲዲ፥ ሹቻን ጫዲዶሶና። ማርካቲ ባንታ ማዑዋ ኢሲ ሳዖላ ጊያ ናዓቴꬃ ማታን ዎꬂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","ኢስፂፋኖሴይ፥ «ታ ጎዳ ዬሱሳ፥ ታ ሼምፑዋ ኤካ» ያጊዲ ፄጊሺን ኤንቲ ኢያ ሹቻን ጫዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","ጉልባቲዲ፥ ባ ቃላ ꬎቁ ኦꬂዲ፥ «ታ ጎዳው፥ ሃ ናጋራ ኤንታው ኣቶ ጋ» ያጊስ። ሄሳ ያጊዲ ሲሚዳ ሜላ ሃይቂ ኣጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","ሳዖሊ ኢስፂፋኖሴ ሃይቁዋን ኡፋይቲስ። ሄ ጋላስ ዬሩሳላሜን ዴዒያ ዎሳ ኬꬃን ጊታ ጎዲ ዴንዲስ። ሃዋሬቲ ኣቲን ኣማኔይሳቲ ኡባይ ዪሁዳ ቢታኒኔ ሳማሬ ቢታን ላሌቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","ኢሲ ኢሲ ፆሳ ኣሳቲ ኢስፂፋኖሴ ሞጊዶሶና፤ ቃሲ ኢያው ዳሮ ዬኪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","ሺን ሳዖሊ ዎሳ ኬꬃ ꬋይሳናው ኮዬስ። ሶ ሶ ዩዪ ጌሊዲ፥ ኣማኒያ ኣዴታኔ ማጫሳታ ጎቺ ጎቺ ኬሲዲ ቃሾ ኬꬂ ጌልሴስ። ");
INSERT INTO gofENT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","ላሌቲዳ ኣማኔይሳቲ ቢዳ ቤሳ ኡባን ቃላ ኦዲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","ፊልጶሲ ሳማሬ ካታማ ቢዲ ኪሪስቶሳባ ኣሳስ ኦዲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","ዳሮ ኣሳይ ፊልጶሲ ጊዳይሳ ሲዒዳ ዎዴኔ ኢ ኦꬂያ ማላታታ ቤዒዳ ዎዴ ኢያ ኣኬኪዲ ሲዒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","ቱና ኣያናቲ ዋሲዲ ዳሮ ኣሳፔ ኬዪዶሶና፤ ቃሲ ዳሮ ጉንዳቲኔ ዎቤቲ ቢሌቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","ሄ ካታማን ዴዒያ ኣሳይ ዳሮ ኡፋይቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","ሺን ሲሞና ጊያ ኢሲ ኡራይ ሄ ካታማን ዴዔስ። ኢ፥ ‹ባና ጊታ› ጊዲ ሳማሬ ኣሳ ማሮቴꬃን ማላሊሲሼ ጋምዒስ። ");
INSERT INTO gofENT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","ጉꬃፌ ጊታ ጋካናው ዴዒያ ኣሳ ኡባይ፥ «ጊታ ፆሳ ዎልቃይ ሃይሳ» ጊዲ ኢያባ ሲዖሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","ዳሮ ዎዴፔ ዶሚዲ ማሮቲሼ ሳማሬ ኣሳ ማላሊሲዳ ጊሾ ኣሳይ ኢያባ ሲዖሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","ሺን ፊልጶሲ ፆሳ ካዎቴꬃባኔ ዬሱስ ኪሪስቶሳ ሱንꬃባ ኣዴታሲኔ ማጫታስ ኦዲን፥ ኤንቲ ኢያባ ኣማኒዲ ፃማቄቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","ቃሲ ሲሞኒካ ባ ሁዔን ኣማኒዲ ፃማቄቲስ። ፊልጶሳራ ኢሲፌ ቢዳ ቤሳ ኡባን ኦሴቲያ ጊታ ማላታታ ቤዒዲ ማላሌቲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","ዬሩሳላሜን ዴዒያ ሃዋሬቲ ሳማሬ ኣሳይ ፆሳ ቃላ ኤኪዳይሳ ሲዒዳ ዎዴ ጴፂሮሳኔ ዮሃኒሳ ኤንታኮ ዬዲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","ጴፂሮሲኔ ዮሃኒሲ ቢዲ፥ ኣማኔይሳቲ ጌሻ ኣያና ኤካና ሜላ ኤንታው ፆሳ ዎሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","ኣይስ ጊኮ፥ ሳማሬ ኣሳቲ ጎዳ ዬሱሳ ሱንꬃ ፃላላን ፃማቄቲዶሶናፔ ኣቲን ኤንታፌ ኢሱዋ ቦላካ ጌሻ ኣያኒ ዎꬊቤና። ");
INSERT INTO gofENT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","ሄ ዎዴ ጴፂሮሲኔ ዮሃኒሲ ባንታ ኩሺያ ኤንታ ቦላ ዎꬂን፥ ኤንቲ ጌሻ ኣያና ኤኪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","ሃዋሬቲ ባንታ ኩሺያ ኤንታ ቦላ ዎꬂን፥ ኤንታው ጌሻ ኣያናይ ኢሜቲዳይሳ ሲሞኒ ቤዒዳ ዎዴ ጴፂሮሳሲኔ ዮሃኒሳስ ሚሼ ኤሂዲ፥ ");
INSERT INTO gofENT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","«ታኒካ ታ ኩሺያ ዎꬂያ ኡባይ ጌሻ ኣያና ኤካና ሜላ ሃ ማታ ታዉካ ኢሜርኬቲ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","ሺን ጴፂሮሲ ኢያኮ፥ «ኔኒ ፆሳ ኢሞታ ሚሼን ሻማናው ቆፒዳ ጊሾ ኔ ሚሼይ ኔራ ꬋዮ። ");
INSERT INTO gofENT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","ኔ ዎዛናይ ፆሳ ሲንꬃን ሱሬ ጊዶና ጊሾ ኔው ሃይሳን ጊሾይ ዎይኮ ቃዲ ባዋ። ");
INSERT INTO gofENT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","ሂዛ፥ ሃ ኔ ዎዛና ኢታቴꬃ ጊሾ ናጋራፔ ሲማ። ኔ ዎዛናን ዴዒያ ኢታ ቆፋ ፆሳይ ኣቶ ጋና ሜላ ፆሳ ዎሳ። ");
INSERT INTO gofENT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","ጋሶይካ፥ ኔኒ ኢታ ቃናቴኒኔ ናጋራ ቃሹዋን ዴዔይሳ ታኒ ቤዓይስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","ሲሞኒ ዛሪዲ፥ «ሂንቴ ጊዳይሳፌ ኢሶይካ ታና ጋኮና ሜላ ታው ፆሳ ዎሲቴ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","ጴፂሮሲኔ ዮሃኒሲ ማርካቲዳፔኔ ጎዳ ቃላ ኦዲዳፔ ጉዬ ዬሩሳላሜ ሲሚዶሶና። ሳማሬን ዴዒያ ዳሮ ጉታታን ዎንጌላ ኦዲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","ጎዳ ኪታንቾይ ፊልጶሳኮ፥ «ዴንዳዳ ዬሩሳላሜፔ ጋዛ ኤፊያ ባዞ ቢታ ኦጊያኮ ባ። ሄ ኦጌይ ዱጌሃ ባጋራ ዴዔስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","ፊልጶሲ ዴንዲዲ ቢስ። ሂንዴኬ ጊያ ቶጲያ ካዌስ ኢ ሚሼ ኡባ ናጊያ ቶጲያ ኣሲ ዴዔስ። ኢካ ጎይናናው ዬሩሳላሜ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ፓራ ጋሪያን ኡቲዲ፥ ዬሩሳላሜፔ ባ ቢታ ሲሚሼ ናቢያ ኢሳያሳ ማፃፋ ናባቤስ። ");
INSERT INTO gofENT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","ጌሻ ኣያናይ ፊልጶሳኮ፥ «ሄ ጋሪያኮ ባዳ ኢያ ማቲ ሺቃ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","ያቲን ፊልጶሲ ዎፂ ቢዲ ጋኪያ ዎዴ ሞሪናይ ናቢያ ኢሳያሳ ማፃፋፔ ናባቢሺን ሲዒዲ፥ «ኔ ናባቤያሲ ኔው ጌሊ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","ሞሪናይ፥ «ታው ኦዲ ጌልሲያ ኣሲ ባይና ዋኒዲ ጌላኔ?» ያጊስ። ባራ ጋሪያን ኬዪዲ ኡታና ሜላ ፊልጶሳ ዎሲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","ሞሪናይ ናባቢያ ማፃፋ ኪፊሌይ፥ «ኢ ዶርሳዳ ሹኬታናው ላጌቲስ፤ ዶርሳ ማሪ ባ ኢኪሲያ ሜዴይሳታ ሲንꬃን ሲዒ ጌይሳዳ፥ ኢካ ባ ዶና ዶዪቤና። ");
INSERT INTO gofENT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","ኢ ካዉዪስ፤ ኢያው ፂሎ ፒርዲ ꬋይስ። ኢያ ዴዖይ ሃ ሳዓፔ ቃንፄቲዳ ጊሾ ኢያ ሼሻባ ኦኔ ኦዳናይ?» ያጌስ። ");
INSERT INTO gofENT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","ሞሪናይ ዛሪዲ ፊልጶሳኮ፥ «ናቤይ ኦዴባ ኦዲ? ባባ ኦዲዬ ዎይኮ ሃራ ኣሳባ ኦዲ? ታው ኦዳርኪ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","ፊልጶሲ ዛሪዲ፥ ፆሳ ቃላ ሄ ቤሳፌ ዶሚዲ፥ ዬሱሳባ ኦዲያ ዎንጌላ ኢያው ኦዲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","ኤንቲ ቢሼ ሃꬂ ዴዒያሶ ጋኪዶሶና። ሞሪናይ፥ «ሃꬄ ሃይሳ ቤዓ፤ ታ ፃማቄቶና ሜላ ኣይቢ ዲጊ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","ፊልጶሲ ኢያኮ፥ «ኔኒ ኔ ኩሜꬃ ዎዛናፔ ኣማኒኮ ዳንዳዓሳ» ያጊስ። ኢ ዛሪዲ፥ «ዬሱስ ኪሪስቶሲ ፆሳ ናዓ ጊዴይሳ ታኒ ኣማናይስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","ጋሬይ ኤቃና ሜላ ሞሪናይ ኪቲን፥ ናምዓይ ዎꬊዲ ሃꬃን ጌሊዶሶና፤ ፊልጶሲ ኢያ ፃማቂስ። ");
INSERT INTO gofENT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","ኤንቲ ሃꬃፌ ጋፃ ኬዪዳ ዎዴ ጎዳ ኣያናይ ፊልጶሳ ቆፖና ኤኪስ። ናምዓንꬆ ሞሪናይ ፊልጶሳ ቤዒቤና፥ ሺን ባ ኦጊያ ኡፋይቲሼ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","ፊልጶሲ ኣዛፆናን ባና ዴሚስ። ቃሲ ቂሳሪያ ያና ጋካናው ካታማታን ዩዪዲ ዎንጌላ ማርካቲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","ሄ ዎዴ ሳዖሊ ጎዳ ካሌይሳታ ዎꬋናው ማንዲዲ ካሂኔ ሃላቃኮ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ጎዳ ኦጊያ ካሊያ ኣዴታኔ ማጫታ ዴሚኮ፥ ቃቺሼ ዬሩሳላሜ ኤሃናው፥ ዳማስቆን ዴዒያ ኣይሁዴ ዎሳ ኬꬃታስ ዳብዳቤይ ፃፌታና ሜላ ኢያ ዎሲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","ኢ ቢዲ፥ ዳማስቆ ካታማ ጋካናው ማቲሺን፥ ቆፖና ሳሎፔ ዎልቃማ ፖዖይ ኢያ ዩሹዋን ፖዒስ። ");
INSERT INTO gofENT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","ኢ ሳዓን ኩንዲዳሺን፥ «ሳዖላ፥ ሳዖላ፥ ኣይስ ታና ጎዳይ?» ጊያ ቃላ ሲዒስ። ");
INSERT INTO gofENT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","ሳዖሊ፥ «ጎዳው፥ ኔኒ ኦኔ?» ያጊዲ ኦይቺስ። «ታኒ፥ ኔኒ ጎዲያ ዬሱሳ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","ሺን ሳዖሊ ኮኮሪሼኔ ማላሌቲሼ፥ «ጎዳው፥ ታኒ ኣይ ኦꬃና ሜላ ኮያይ?» ያጊስ። ጎዳይ ኢያኮ፥ «ዴንዳዳ ካታማ ጌላ፤ ኔኒ ኦꬃናው ቤሲያባይ ያን ኔው ኦዴታና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","ሳዖላራ ኦጊያ ቢያ ኣሳቲ ኣይኮካ ኦዴቶና ኤቂ ኣቲዶሶና። ቃላ ሲዖሶና፥ ሺን ኦናካ ቤዒቦኮና። ");
INSERT INTO gofENT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","ሳዖሊ ኩንዲዳ ቤሳፌ ዴንዲዲ ፄሊያ ዎዴ ኢያ ኣይፌይ ዴሞና ኢፂስ። ሄሳ ጊሾ፥ ኤንቲ ኢያ ኩሺያ ኦይኪዲ ካሌꬂዲ ዳማስቆ ጌልሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","ሄꬑ ጋላስ ጋካናው ኢ ፄላናው ዳንዳዒቤና፤ ኣይኮካ ሚቤና፤ ኡዪቤና። ");
INSERT INTO gofENT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","ዳማስቆን ኢሲ ሃናኒያ ጊያ ዬሱሳ ታማሬይ ዴዔስ። ጎዳይ ቆንጬꬃን፥ «ሃናኒያ» ያጊዲ ፄጊስ። ሃናኔይ ዛሪዲ፥ «ታ ጎዳው፥ ሃይሳን ዴዓይስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","ጎዳይ ኢያኮ፥ «ዴንዳዳ ሱሬ ጌቴቲያ ኦጊያ ባዳ፥ ዪሁዳ ሶን ሳዖላ ጊያ ቴርሴሴፔ ዪዳ ኡራ ኮያ፤ ሳዖሊ ዎሴስ። ");
INSERT INTO gofENT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ቃሲ ሃናኔይ ጌሊዲ፥ ሳዖሊ ናምዓንꬆ ፄላና ሜላ ባ ኩሺያ ኢያ ቦላ ዎꬂሺን ቆንጬꬃን ቤዒስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","ሃናኔይ ዛሪዲ፥ «ጎዳው፥ ዬሩሳላሜን ኔ ጌሻ ኣሳ ቦላ ሄ ኡራይ ኣይ ሜላ ኢታባ ኦꬂዳኮ ታኒ ዳሮ ኣሳፔ ሲዓስ። ");
INSERT INTO gofENT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","ቃሲ ዳማስቆን ኔ ሱንꬃ ፄጌይሳታ ኡባ ቃቻናው፥ ካሂኔ ሃላቃቲ ኢያው ማታ ኢሚዶሶና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","ሺን ጎዳይ ኢያኮ፥ «ሳዖሊ ኣይሁዴ ጊዶና ኣሳ ሲንꬃን፥ ካዎታ ሲንꬃኒኔ ኢስራዔሌ ኣሳ ሲንꬃን፥ ታ ሱንꬃ ኤሪሳናዉኔ ታው ኦꬃናው ዶሬቲዳ ሚሼ ጊዲያ ጊሾ ኔኒ ኢያኮ ባ። ");
INSERT INTO gofENT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","ኣይስ ጊኮ፥ ታ ሱንꬃ ጊሾ ኢ ኣይ ሜላ ዋዬ ኤካናው ቤሲያኮ ታኒ ኢያ ቤሳና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","ሃናኔይ ቢዲ፥ ሶ ጌሊዲ፥ ባ ኩሺያ ሳዖላ ቦላ ዎꬂዲ፥ «ታ ኢሻ ሳዖላ፥ ኔኒ ያ ኦጊያን ኔው ቤንቲዳ ጎዳ ዬሱሲ፥ ኔኒ ፄላና ሜላኔ ጌሻ ኣያናን ኩማና ሜላ ታና ኪቲስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","ኤሌሲዲ፥ ሳዖላ ኣይፊያፔ ኢሲ ፖቆ ሜላባይ ዎꬊን፥ ሳዖሊ ናምዓንꬆ ፄሊስ። ቃሲ ዴንዲዲ ፃማቄቲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","ካꬂ ሚዲ ፃሊዲ፥ ዳማስቆን ዴዒያ ኣማኔይሳታራ ጉꬃ ጋላስ ጋምዒስ። ");
INSERT INTO gofENT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","ኤሌሲዲ ሳዖሊ፥ «ዬሱሲ ፆሳ ናዓ» ያጊዲ ዳማስቆን ዴዒያ ኣይሁዴ ዎሳ ኬꬃታን ቃላ ታማርሲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","ሄሳ ሲዒዳ ኡባይ ማላሌቲዲ፥ «ሃይሲ ዬሩሳላሜን ዬሱሳ ሱንꬃ ፄጌይሳታ ቃቼይሳ ጊዴኔዬ? ቃሲ ሃ ዪዳይ ኤንታ ቃቺዲ፥ ካሂኔ ሃላቃታ ሲንꬄ ኤፋናሳ ጊዴኔ?» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","ሺን ሳዖሊ ቃላ ኦዶን ሚኒ ሚኒ ቢስ። ዬሱሲ፥ ኢ ኪሪስቶሳ ጊዴይሳ ቆንጪሲዲ ኦዲዳ ጊሾ ዳማስቆን ዴዒያ ኣይሁዴቲ ኢያው ዛሪያባ ꬋዪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","ዳሮ ጋላሳፔ ጉዬ ኣይሁዴቲ ሺቂዲ፥ ሳዖላ ዎꬋናው ዞሬቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","ሺን ኣይሁዴቲ ባና ዎꬋናው ቆፒዳይሳ ሳዖሊ ሲዒስ። ኤንቲ ኢያ ዎꬋናው ቃማኔ ጋላስ ካታማ ፔንጊያን ናጎሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","ሺን ኢያ ታማሬቲ ኢያ ቃማ ኤፊዲ፥ ጊምቤ ዲርሳ ማስኮቲያራ ዳቾራ ዎꬊሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","ሳዖሊ ዬሩሳላሜ ጋኪዳ ዎዴ ኣማኔይሳታራ ጋሄታናው ኮዪስ። ሺን ኢ ኪሪስቶሳ ኣማኒዳይሲ ኤንታው ቱማ ዳኖና ኢፂን ኢያው ያዪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","ሺን ባርናባሲ ሳዖላ ሃዋሬታኮ ኤፊስ። ኦጌን ጎዳይ ዋኒዲ ቆንጪዳኮኔ ሃሳዪሲዳኮ፥ ቃሲ ሳዖሊ ዳማስቆን ዬሱሳ ሱንꬃን ያዮና ዋቲዲ ቃላ ኦዲዳኮ ኤንታው ጌሺዲ ኦዲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","ሳዖሊ ዬሩሳላሜን ዩዪዲ ጎዳ ሱንꬃን ያዮና ቃላ ኦዲሼ፥ ሃዋሬታራ ኢሲፌ ዴዒስ። ");
INSERT INTO gofENT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","ቃሲ ሳዖሊ ጊሪኬ ቃላ ሃሳያ ኣይሁዴታራ ኦዴቲሼ ፓላሜስ። ሺን ኤንቲ ኢያ ዎꬋናው ኮዪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","ኣማኒያ ኣሳቲ ሄሳ ሲዒዲ፥ ሳዖላ ቂሳሪያ ኤፊዲ ቴርሴሴ ዬዲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","ዪሁዳን፥ ጋሊላኒኔ ሳማሬ ኡባን ዴዒያ ዎሳ ኬꬃቲ ሳሮቴꬃን ዴዒዶሶና። ቃሲ ሚኒዶሶና፤ ጎዳስ ያዪሼ ጌሻ ኣያና ሚንꬄꬁዋን ዳሪ ዳሪ ቢዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","ጴፂሮሲ ቢታ ኡባ ዩዪሼ ሊዳን ዴዒያ ኣማኒያ ኣሳታኮ ጋኪስ። ");
INSERT INTO gofENT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","ያን ሆስፑን ላይꬂ ኩሜꬂ ጉንዲዲ ኣርሳን ዚንዒዲ ዴዒያ ኤኒያ ጊያ ኣዲያ ዴሚስ። ");
INSERT INTO gofENT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","ጴፂሮሲ፥ «ኤኒያ፥ ዬሱስ ኪሪስቶሲ ኔና ፓꬃና፤ ዴንዳዳ ኔ ሂፃ ዴንꬃ» ያጊስ። ኢካ ኤሌሲዲ ዴንዲ ኤቂስ። ");
INSERT INTO gofENT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","ሊዳኒኔ ሳሮናን ዴዒያ ኣሳ ኡባይ ኤኒያ ቤዒዲ፥ ጎዳኮ ሲሚዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","ዮጴ ካታማን ኢሲ ፃቢቶ ጊያ ኣማኒያራ ዴዓዉሱ። (ፃቢቶ ጉሳይ ጌንዔ ጉሱ) ኢያ ባ ዴዒዳ ዎዴ ኡባን ሎዖባ ኦꬃሼኔ ማንቆታ ማዳሼ ዴዓሱ። ");
INSERT INTO gofENT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","ሄ ዎዴ ኢያ ሃርጋዳ ሃይቂን፥ ኣሳይ ኢ ኣሃ ሜጪዲ፥ ፖቂያ ቦላ ኬሲዲ ዚንዒሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","ሊዲ ዮጴስ ማታ። ኣማኔይሳቲ ጴፂሮሲ ሊዳን ዴዔይሳ ሲዒዲ፥ «ሃያና ኑኮ ኤሌሳዳ ያ» ያጊያ ኪታ ናምዑ ኣሳታ ቦላ ኢያኮ ኪቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","ሄሳ ጊሾ፥ ጴፂሮሲ ዴንዲዲ፥ ኤንታራ ቢስ። ያ ጋኪን፥ ፖቂያ ቦላ ዴዒያ ኪፊሊያ ኢያ ጌልሲዶሶና። ኣምዔቲ ጴፂሮሳ ዩሹዋን ኤቂዲ ዬኪሼ ዶርቃ ኤንታራ ፓፃ ዴዓሼ ኦꬂዳ ቃሚሴታኔ ኣፊላታ ኡባ ጴፂሮሳ ቤሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","ጴፂሮሲ ኤንታ ኡባ ካሬ ኬሲዲ፥ ጉልባቲዲ ፆሳ ዎሲስ። ቃሲ ኣሃኮ ሲሚዲ፥ «ፃቢቴ፥ ዴንዳ» ያጊስ። ፃቢታ ባ ኣይፊያ ዶያዳ ጴፂሮሳ ቤዓዳ፥ ዴንዳ ኡታሱ። ");
INSERT INTO gofENT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","ጴፂሮሲ ኢዮ ባ ኩሺያን ማዲዲ ዴንꬂ ኤሲስ። ሄሳፌ ጉዬ፥ ኣማኔይሳታኔ ኣምዔታ ፄጊዲ፥ ዴንዲዳሮ ኤንታ ሲንꬄ ሺሺስ። ");
INSERT INTO gofENT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","ሃ ኦዳይ ዮጴ ካታማ ኡባ ጋኪስ። ዳሮ ኣሳይ ጎዳ ኣማኒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","ጴፂሮሲ ዮጴን ሲሞና ጊያ ጋልባ ሃሼይሳ ሶን ዳሮ ጋላስ ጋምዒስ። ");
INSERT INTO gofENT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","ቂሳሪያን፥ «ፃሌ ኦላ ኣሳታ» ጌቴቲያ ኦላንቾታ ጊዶን ኢሲ ቆርኔሊዮሳ ጌቴቲያ ማቶ ሃላቃይ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","ቆርኔሊዮሲ ባ ሶ ኣሳራ ፆሳ ሚንꬂ ኣማኒያ ኣሲኔ ፆሳ ጎይኒያ ኣሲ። ኣይሁዴ ማንቆታካ ዳሮ ማዴስ፥ ቃሲ ፆሳ ኡባ ዎዴ ዎሴስ። ");
INSERT INTO gofENT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","ኢሲ ጋላስ ኡዱፉን ሳቴ ሄራን ፆሳ ኪታንቾይ ኢያኮ ዪዲ፥ «ቆርኔሊዮሳ» ጊዲ ፄጊሺን ኢ ቆንጬꬃን ጌሺዲ ቤዒስ። ");
INSERT INTO gofENT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","ቆርኔሊዮሲ ዳጋሚዲ ኪታንቹዋ ቲሺ ኦꬂ ፄሊዲ፥ «ጎዳው፥ ኢ ኣይቤ?» ያጊስ። ኪታንቾይ ዛሪዲ፥ «ኔ ዎሳይኔ ማንቆታ ኔ ማዴይሲ ፆሳ ሲንꬃን ሃሳዬቲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","ሃዒ ዮጴ ኣሴ ኪታዳ፥ ጴፂሮሳ ጊያ ሲሞና ኤሂሳ። ");
INSERT INTO gofENT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","ጴፂሮሲ ኣባ ዶናን ጋልባ ሃሺያ ሲሞና ሶን ኢማꬃቴꬂ ሲራቲስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","ቆርኔሊዮሲ ባው ኦዲዳ ኪታንቾይ ቢን፥ ባ ኣይሌታፔ ናምዓታኔ ፆሳ ጎይኒያ ባ ማታ ዎታዳሬታፔ ኢሱዋ ፄጊዲ፥ ");
INSERT INTO gofENT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","ኤንታው ኡባባ ኦዲዲ ዮጴ ኪቲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","ዎንቴꬃ ጋላስ ኤንቲ ቢዲ፥ ዮጴ ካታማ ማቲሺን ኡሱፑን ሳቴ ሄራን ፆሳ ዎሳናው ጴፂሮሲ ፖቄ ቦላ ኬይስ። ");
INSERT INTO gofENT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","ኢ ኮሻቲዲ ካꬂ ማናው ኮዪስ፥ ሺን ካꬂ ካፂሺን ኢ ቆንጬꬂ ቤዒስ። ");
INSERT INTO gofENT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","ሳሎይ ዶዬቲን፥ ጊታ ኣፊላ ዳኒያባይ ኦይዱ ባጋራ ኦይኬቲዲ ዎꬊሺን ኢ ቤዒስ። ");
INSERT INTO gofENT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","ኢያን ኦይዱ ቶሆራ ዴዒያ ሜሄቲ፥ ዎራ ዶዓቲ፥ ኡሎራ ጎሼቲያ ሜꬌቴꬃቲኔ ሳሎ ካፎቲ ኡባይ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","ሄ ዎዴ «ጴፂሮሳ፥ ዴንዳ ኤቃዳ ሹካዳ ማ» ጊያ ቃሊ ኢያኮ ዪስ። ");
INSERT INTO gofENT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","ሺን ጴፂሮሲ፥ «ጎዳው፥ ኣካይ! ታ ቱናባ ኡባራካ ማ ኤሪኬ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","ቃሲ፥ «ፆሳይ ጌሺዳይሳ ኔኒ ቱና ጎፓ» ጊያ ቃሊ ናምዓንꬆ ኢያኮ ዪስ። ");
INSERT INTO gofENT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","ሄሲካ፥ ሄꬑ ቶሆ ሃኒዳፔ ጉዬ ሄ ጊታ ኣፊላ ዳኔይሲ ኤሌሲዲ ፑዴ ሳሎ ኤኬቲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","ጴፂሮሲ ባ ቤዒዳ ቆንጬꬃ ቢርሼꬃይ፥ «ኣይ ጊዳንዴሻ?» ጊዲ ባ ዎዛናን ቆፒሺን፥ ቆርኔሊዮሲ ኪቲዳ ኣሳቲ ሲሞና ሶ ኦይቺ ዴሚዲ ካሬን ኤቂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","ባንታ ቃላ ꬎቁ ኦꬂዲ፥ «ጴፂሮሳ ጊያ ሲሞኒ ኢማꬃቴꬃን ዴዔይ ሃይሳኔ?» ያጊዲ ኦይቺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","ጴፂሮሲ ቆንጬꬃን ቤዒዳባ ቆፋ ቦላ ዴዒሺን፥ ጌሻ ኣያኒ ኢያኮ፥ «ሄኮ፥ ሄꬑ ኣሳቲ ኔና ኮዮሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","ዴንዳዳ ዎꬋ፥ ታኒ ኤንታ ኪቲዳ ጊሾ ሲꬎና ኤንታራ ባ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","ጴፂሮሲ ኣሳታኮ ዎꬊዲ፥ «ሂንቴ ኮዬይ ታና፤ ኣይስ ዪዴቲ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","ኤንቲ ዛሪዲ፥ «ኑና ማቶ ሃላቃይ ቆርኔሊዮሲ ኪቲስ። ኢ ፂሎ፥ ፆሳ ጎይኒያ ኣሲኔ ኣይሁዴ ኣሳ ኡባን ዳሮ ቦንቼቲዳ ኣሲ። ቆርኔሊዮሲ፥ ኔና ባ ሶ ኤሂሲዲ ቃላ ኔፔ ሲዓና ሜላ ጌሻ ኪታንቾይ ኢያው ኦዲስ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","ጴፂሮሲ ኣሳታ ሶ ጌልሲዲ ሞኪስ። ዎንቴꬃ ጋላስ፥ ዴንዲዲ ኤንታራ ቢስ። ዮጴ ካታማን ዴዒያ ኣማኔይሳታፔ ኢሶቲ ኢሶቲ ኢያራ ኢሲፌ ቢዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","ዎንቴꬃ ጋላስ፥ ቂሳሪያ ጋኪዶሶና። ቆርኔሊዮሲ ባ ዳቦታኔ ባ ማታ ላጌታ ኢሲፌ ፄጊ ሺሺዲ፥ ጴፂሮሳ ናጌስ። ");
INSERT INTO gofENT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","ጴፂሮሲ ሶ ጌላና ሃኒሺን፥ ቆርኔሊዮሲ ኢያራ ጋሄቲዲ ኢያ ሲንꬃን ኩንዲዲ ኢያው ጎይናናው ኮዪስ። ");
INSERT INTO gofENT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","ሺን ጴፂሮሲ፥ «ዴንዳ፥ ታካ ታ ሁዔን ኔ ሜላ ኣሴ» ያጊዲ ኢያ ዴንꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","ጴፂሮሲ ቆርኔሊዮሳራ ኦዴቲሼ ሶ ጌሊያ ዎዴ ዳሮ ኣሳይ ሺቂዳይሳ ዴሚስ። ");
INSERT INTO gofENT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","ኢ ኣሳኮ፥ «ኣይሁዴ ኣሲ ሃራ ዴሬራ ኢሲፋናው ዎይኮ ጋሄታናው ዎጋ ጊዶናይሳ ሂንቴ ኤሬታ። ሺን ታኒ ኦናካ ቱና ዎይኮ ጌሺ ጊዴና ጎና ሜላ ፆሳይ ታና ቤሲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","ሄሳ ጊሾ፥ ሂንቴ ታኮ ኪቲን ኢፆይ ባይና ያስ። ሃዒ ታና ኣይስ ፄጊሲዳኮ ታው ኦዲቴ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","ቆርኔሊዮሲ፥ «ታኒ ሃቺ ኦይዱ ጋላሳፔ ካሴ ሃኖዴ ኡዱፉን ሳቴ ዎሳ ዎሲሺን፥ ጶሊያ ማዖ ማዒዳ ኣሲ ታ ሲንꬃን ኤቂስ። ");
INSERT INTO gofENT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ኢ ታኮ፥ ‹ቆርኔሊዮሳ፥ ፆሳይ ኔ ዎሳ ሲዒስ፥ ኔኒ ማንቆታ ማዲዳይሳካ ሃሳይስ። ");
INSERT INTO gofENT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","ሂዛ፥ ኣሴ ዮጴ ኪታዳ፥ ሲሞን ጴፂሮሳ ጌይሳ ፄጊሳ። ኢ፥ ሲሞና ጊያ ጋልባ ሃሺያ ኡራ ሶን ኣባ ዶናን ሲራቲስ› ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","ሄሳ ጊሾ፥ ታኒ ኔኮ ኤሌሳዳ ኪታስ፤ ኔ ሎዖ ያዳሳ። ሂዛ፥ ፆሳይ ኔና ኪቲዳባ ኡባ ሲዓናው ሃዒ ኑኒ ኡባይ ሃይሳን ጎዳ ሲንꬃን ዴዖስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","ካሊዲካ፥ ጴፂሮሲ፥ «ፆሳይ ኣሳ ሶምዖ ቤዒዲ ኣሴ ኣሳፔ ሻኬና። ");
INSERT INTO gofENT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","ሺን ኣሴ ኡባ ኦና ጊዲኮካ ባው ያዬይሳኔ ፂሎ ኦሶ ኦꬄይሳን ፆሳይ ኡፋይቴይሳ ታኒ ቱማ ኣኬካስ። ");
INSERT INTO gofENT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","ፆሳይ፥ ኡባ ጎዳ ጊዲዳ ዬሱስ ኪሪስቶሳ ባጋራ ሳሮቴꬃ ኦዲሼ ሃ ዎንጌላ ኢስራዔሌ ኣሳስ ኪቲዳይሳ ሂንቴ ኤሬታ። ");
INSERT INTO gofENT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","ዮሃኒሲ ፂንቃቴባ ጋሊላን ሳባኪዳ ዎዲያፔ ዶሚዲ ዪሁዳ ቢታ ኡባ ጋካናው ሃኒዳባ ሂንቴ ኤሬታ። ");
INSERT INTO gofENT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","ፆሳይ ናዚሬቴ ዬሱሳስ ጌሻ ኣያናኔ ዎልቃ ኢሚስ። ፆሳይ ኢያራ ዴዒያ ጊሾ ሎዖባ ኢ ኦꬂሼ ፃላሄ ኩሼን ሃሬቲዳ ኡባ ፓꬂሼ ዩዪስ። ");
INSERT INTO gofENT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","«ኣይሁዴ ቢታኒኔ ዬሩሳላሜን ኢ ኦꬂዳ ኡባባስ ኑኒ ማርካታ። ኤንቲ ማስቃሊያ ቦላ ካቂዲ ኢያ ዎꬊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","ሺን ፆሳይ ሄꬓንꬆ ጋላሳን ሃይቆፔ ኢያ ዴንꬂዲ ኣሳስ ቆንጫና ሜላ ኦꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","ሄ ቆንጬꬃይ ፆሳይ ኮይሮ ዶሪዳ ማርካታሳፌ ኣቲን ኣሳ ኡባስ ጊዴና። ኢ ሃይቆፔ ዴንዲዳፔ ጉዬ ኢያራ ሚዳኔ ኡዪዳ። ");
INSERT INTO gofENT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","ኑኒ ዎንጌላ ኣሳስ ኦዳና ሜላኔ ፓፃ ዴዔይሳታ ቦላኔ ሃይቂዳይሳታ ቦላ ፒርዳናው ፆሳይ ሹሚዳይ ዬሱሳ ጊዴይሳ ማርካታና ሜላ ኑና ኪቲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","ፆሳይ ኢያ ኣማኒያ ኡባ ናጋራይ፥ ኢያ ሱንꬃን ኣቶ ጌቴቴይሳ ናቤቲ ማርካቶሶና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","ጴፂሮሲ ቡሮ ሄ ኦዳ ኦንጎናሺን ቃላ ሲዒያ ኡባ ቦላ ጌሻ ኣያኒ ዎꬊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","ጴፂሮሳራ ዮጴፌ ዪዳ ኣማኒያ ቃፃሬቲዳ ኣይሁዴ ኡባይ፥ ኣይሁዴ ጊዶናይሳታ ቦላ ጌሻ ኣያኒ ጉኪዳ ጊሾ ማላሌቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","ጋሶይካ፥ ኤንቲ ዱማ ዱማ ዶናን ሃሳዪሺኒኔ ፆሳ ጊታቴꬃ ሳቢሺን ሲዒዶሶና። ሄ ዎዴ ጴፂሮሲ ዛሪዲ፥ ");
INSERT INTO gofENT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","«ሃይሳቲ ቃሲ ኑ ሜላ ጌሻ ኣያና ኤኪዳይሳቲ ፃማቄቶና ሜላ ሃꬄ ዲጋናይ ኦኔ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","ኤንቲ ዬሱስ ኪሪስቶሳ ሱንꬃን ፃማቄታና ሜላ ኤንታ ኪቲስ። ሄሳፌ ጉዬ፥ ኤንቲ ባንታራ ጉꬃ ጋላስ ኡታና ሜላ ጴፂሮሳ ዎሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","ሃዋሬቲኔ ዪሁዳ ኡባን ዴዒያ ኣማኔይሳቲ፥ ኣይሁዴ ጊዶናይሳቲካ ፆሳ ቃላ ኤኪዳይሳ ሲዒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","ጴፂሮሲ ዬሩሳላሜ ቢዳ ዎዴ ቃፃሬቲዳ ኣማኔይሳቲ፥ ");
INSERT INTO gofENT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","ኢያኮ፥ «ኔኒ ቃፃሬቲቦናይሳታኮ ጌላዳ ኤንታራ ካꬂ ኣይስ ማዲ?» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","ሺን ጴፂሮሲ ሃኒዳባ ኮይሮፔ ዶሚዲ ማራን ማራን ኦዲስ፡ ");
INSERT INTO gofENT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","«ታኒ ዮጴ ካታማን ፆሳ ዎሳሼ ቆንጬꬂ ቤዓስ። ጊታ ኣፊላ ዳኒያባይ ኦይዱ ባጋራ ኦይኬቲዲ ሳሎፔ ዎꬊሼ ታኮ ዪስ። ");
INSERT INTO gofENT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","ታኒ ቲሺ ኦꬃ ኢያ ጊዶ ፄሊያ ዎዴ ኦይዱ ቶሆራ ዴዒያ ሜሄታ፥ ዎራ ዶዓታ፥ ኡሎራ ጎሼቲያ ሜꬌቴꬃታኔ ሳሎ ካፎታ ቤዓስ። ");
INSERT INTO gofENT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","‹ጴፂሮሳ፥ ዴንዳ፥ ሹካዳ ማ› ጊያ ቃላ ሲዓስ። ");
INSERT INTO gofENT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","«ሺን ታኒ፥ ‹ጎዳው፥ ኣካይ፥ ቱናባይ ዎይኮ ጌዮናባይ ኡባካ ታ ዶናኮ ሺቂ ኤሬና› ያጋስ። ");
INSERT INTO gofENT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","« ‹ፆሳይ ጌሺዳይሳ ኔኒ ቱና ጎፓ› ያጊያ ቃሊ ናምዓንꬆ ሳሎፔ ዪስ። ");
INSERT INTO gofENT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","«ሄሲ ሄꬑ ቶሆ ሃኒን፥ ዉርሴꬃን ኡባባይ ሳሎ ፑዴ ኤኬቲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","ሄ ሳቴንካ ሄꬑ ኣሳቲ ቂሳሪያፔ ታኮ ኪቴቲዲ ታኒ ዴዒያ ኬꬃ ጋኪ ኣጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","ሲꬎና ኤንታራ ባና ሜላ ኣያናኢ ታው ኦዲስ። ቃሲ ሃ ኡሱፑን ኢሻቲ ዮጴፌ ታራ ቂሳሪያ ቢዳይሳታራ ቆርኔሊዮሳ ሶ ጌሊዳ። ");
INSERT INTO gofENT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","ኪታንቾይ ኢያ ሶን ኤቂዲ፥ ‹ዮጴ ኪታዳ ጴፂሮሳ ጌቴቲያ ሲሞና ፄጊሳ። ");
INSERT INTO gofENT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","ኔናኔ ኔ ሶ ኣሳ ኡባ ኣሺያ ቃላ ኢ ኔው ኦዳና› ጊዳይሳ ቆርኔሊዮስ ኑስ ኦዲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","«ታኒ ሃሳያ ዶሚያ ዎዴ ጌሻ ኣያናይ ኮይሮ ኑ ቦላ ዎꬊዳይሳዳ ኤንታ ቦላካ ዎꬊ ኣጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","ሄ ዎዴ ‹ዮሃኒሲ ሃꬃን ፃማቂስ፥ ሺን ሂንቴ ጌሻ ኣያናን ፃማቄታና› ያጊዳ ጎዳ ቃላይ ታው ቆፌቲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","ፆሳይ ኑስ ጎዳ ዬሱስ ኪሪስቶሳ ኣማኒዳይሳታስ ኢሚዳ ኢሞታ ኣይሁዴ ጊዶናይሳታስካ ኢሚኮ፥ ያቲን ፆሳ ዲጋናው ታኒ ኦኔ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","ኤንቲ ሄሳ ሲዒዳ ዎዴ ባንታ ፓላማ ኣጊዲ፥ «ሄሳ ጊዲኮ፥ ፆሳይ ኣይሁዴ ጊዶናይሳቲካ ናጋራፔ ሲሚዲ ዴዖን ዳናዳ ቃዳ ኢሚስ» ያጊዲ ፆሳ ጋላቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","ኢስፂፋኖሴ ሃይቆስ ጋꬂዳ ጎዳ ጋሶን ላሌቲዳ ኣማኔይሳቲ ቃላ ኣይሁዴታ ፃላላስ ኦዲሼ ሲሮፊንቄ፥ ቆጲሮሳኔ ኣንፆኪያ ጋካናው ዩዪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","ሺን ቆጲሮሳፔኔ ቄሬናፔ ዪዳ ኢሲ ኢሲ ኣማኒያ ኣሳቲ ኣንፆኪያ ቢዲ፥ ጎዳ ዬሱሳ ዎንጌላ ጊሪኬ ኣሳስካ ኦዲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","ጎዳ ዎልቃይ ኤንታራ ዴዔስ፤ ቃሲ ዳሮ ኣሳይ ኣማኒዲ ጎዳኮ ሲሚዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","ሄ ኦዳ ዬሩሳላሜን ዴዒያ ዎሳ ኬꬃይ ሲዒዳ ጊሾ ባርናባሳ ኣንፆኪያ ኪቲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","ባርናባሲ ኣንፆኪያ ቢዳ ዎዴ ፆሳ ኣꬎ ኬሃቴꬃ ኦሱዋ ቤዒዲ ኡፋይቲስ። ኤንቲ ኡባይ ባንታ ኩሜꬃ ዎዛናን ጎዳን ሚኒዲ ዳና ሜላ ኤንታ ዞሪስ። ");
INSERT INTO gofENT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","ባርናባሲ ጌሻ ኣያናይኔ ኣማኖይ ኩሚዳ ሎዖ ኣሲ ጊዲያ ጊሾ ዳሮ ኣሳይ ጎዳ ኣማኒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","ሄሳፌ ጉዬ፥ ባርናባሲ ሳዖላ ኮያናው ቴርሴሴ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","ያን ሳዖላ ዴሚዳ ዎዴ ኣንፆኪያ ኤኪዲ ዪስ። ባርናባሲኔ ሳዖሊ ዎሳ ኬꬃ ኣሳራ ላይꬂ ኩሜꬂ ኡቲዲ ዳሮ ኣሳ ታማርሲዶሶና። ኣማኔይሳቲ ኣንፆኪያን «ኪሪስታኔ» ጌቴቲዲ ኮይሮ ፄጌቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","ሄ ዎዴ ኢሲ ኢሲ ናቤቲ ዬሩሳላሜፔ ኣንፆኪያ ዎꬊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","ኤንታ ጊዶፌ ኣጋቦሳ ጌይሲ ዴንዲዲ ቢታ ኡባን ጊታ ኮሺ ኬያናይሳ ኣያና ዎልቃን ቲንቢቴ ኦዲስ። ሄሲ ሃኒዳይ ሮሜ ካዉዋ ቃላዉዲዮሳ ዎዴና። ");
INSERT INTO gofENT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","ኣማኔይሳቲ ሁዔን ሁዔን ባንታ ዎልቃ ሜላ ሚሼ ኬሲዲ ዪሁዳን ዴዒያ ኣማኔይሳታስ ማዴ ዬዳናው ቆፋ ቃቺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","ኤንቲ ሄሳዳ ኦꬂዲ፥ ሚሺያ ባርናባሳ ቦላኔ ሳዖላ ቦላ ዎሳ ኬꬃ ጪማታስ ዬዲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","ሄ ዎዴ ካዎይ ሄሮዲሲ ዎሳ ኬꬃ ኣሳፔ ባጋ ጎዳ ዶሚስ። ");
INSERT INTO gofENT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","ዮሃኒሳ ኢሻ ያይቆባ ማሻን ዎꬊሲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","ሄሲ ኣይሁዴታ ኡፋይሲዳይሳ ቤዒዲ፥ ጉጂዲ ጴፂሮሳካ ኦይꬂስ። ሄሲ ሃኒዳይ ፓሲካ ባሌ ቦንቺያ ጋላሳታና። ");
INSERT INTO gofENT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","ጴፂሮሳ ኦይኪዲ ቃቺስ። ፓሲካ ቦንቺያ ጋላሳታፔ ጉዬ ዴሪያ ሲንꬄ ኣꬃናው ቆፒዲ፥ ኦይዱ ኦይዱ ዎታዳሬቲ ኢያ ናጋና ሜላ ታማኔ ኡሱፑን ዎታዳሬታስ ኣꬂ ኢሚስ። ");
INSERT INTO gofENT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","ሄሳ ጊሾ፥ ጴፂሮሲ ቃሾ ኬꬃን ናጌቴስ። ሺን ዎሳ ኬꬃ ኣሳይ ኢያው ሚንꬂዲ ፆሳ ዎሶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","ሄሮዲሲ ጴፂሮሳ ኣሳ ሲንꬄ ሺሻናፔ ካሴ ቃማ ጴፂሮሲ ናምዑ ባጋራ ናምዑ ዎታዳሬታራ ሳንꬃላታን ቃሼቲዲ ኤንታ ጊዶን ꬊስኪስ። ናጌይሳቲ ቃሾ ኬꬃ ፔንጌታን ኤቂዲ ናጎሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","ኣኬኮና ዴዒሺን ጎዳ ኪታንቾይ ቆንጪስ። ቃሾ ኬꬃን ፖዖይ ፖዒስ። ኪታንቾይ ጴፂሮሳ ሚያ ቦቺ ባርኪሲዲ፥ «ኤሌ ዴንዳ» ያጊስ። ኢራካ ሳንꬃላታይ ኢያ ኩሺያፔ ዎꬊ ኣጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","ኪታንቾይ ኢያኮ፥ «ኔ ማዑዋ ማዓ፥ ኔ ጫማካ ኣꬃ» ያጊስ። ጴፂሮሲ ሄሳዳ ኦꬂስ፤ ኪታንቾይ፥ «ኔ ላፃና ማዓዳ ታና ካላ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","ጴፂሮሲ ቃሾ ኬꬃፌ ኬዪዲ ኪታንቹዋ ካሊስ። ኢያው ቆንጬꬂ ቤዒያባ ዳኒሲፔ ኣቲን ኪታንቾይ ኦꬂያባይ ቱማ ዳኒቤና። ");
INSERT INTO gofENT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","ኪታንቾይኔ ጴፂሮሲ ኮይሩዋኔ ናምዓንꬆ ዎታዳሪያ ኣꬊዲ ካታማ ኤፊያ ቢራታ ፔንጊያኮ ጋኪዶሶና። ፔንጌይ ኤንታው ባርካ ዶዬቲ ኣጊስ። ኤንቲ ኬዪዲ ኢሲ ኦጊያራ ቢሺን ኪታንቾይ ኣኬኮና ጴፂሮሳፔ ሻኬቲ ኣጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","ጴፂሮሳስ ዎዛኒ ሲሚን፥ «ታና ጎዳይ ባ ኪታንቹዋ ኪቲዲ፥ ሄሮዲሳ ኩሼፔኔ ናጊዲ ኡቲዳ ኣይሁዴ ኣሳ ኡባፌ ኣሺዳይሳ ሃዒ ቱማ ኤራስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","ኢ ሄሳ ኣኬኪዳ ዎዴ ዳሮ ኣሳይ ኢሲፌ ሺቂዲ ፆሳ ዎሲያ ቤሳ፥ ማርቆሳ ጊያ ዮሃኒሳ ኣዬ ማይራሚ ሶ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","ያን ካሬን ኤቂዲ ፄጊስ። ኢሲ ሮዳ ጊያ ኦሳንቺያ ፔንጊያ ዶያናው ያሱ። ");
INSERT INTO gofENT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","ሮዳ ጴፂሮሳ ቃላ ጊዲዳይሳ ኤሪዳ ዎዴ ኡፋይሳን ኩማዳ ካሪያ ዶዬና ጉዬ ዎፃ ባዳ፥ «ጴፂሮሲ ካሬን ኤቂስ» ያጋዳ ኣሳስ ኦዳሱ። ");
INSERT INTO gofENT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","ኣሳይ ኢኮ፥ «ኔኒ ጎያይ!» ያጊዶሶና። ሮዳ ጴፂሮሳ ጊዲዳይሳ ጌሻዳ ኦዳሱ። ኤንቲ፥ «ሄሲ ኢያ ናጊያ ኪታንቹዋ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","ሺን ጴፂሮሲ ካሬን ኤቂዲ ፄጊዲ ኣጎና ኢፂን ኣሳይ ካሪያ ዶዪዲ ኢያ ቤዒዲ ማላሌቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","ሺን ኤንቲ ሲዒ ጋና ሜላ ጴፂሮሲ ባ ኩሺያን ማሊዲ ጎዳይ ቃሾ ኬꬃፌ ኢያ ዋቲ ኬሲዳኮ ኤንታው ቆንጪሲ ኦዲዲ፥ «ሃይሳ ያይቆባሲኔ ኣማኒያ ኣሳታስ ኦዲቴ» ጊዲ ያፔ ኬዪዲ ሃራሶ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","ሳዒ ዎንቲያ ዎዴ «ጴፂሮሲ ኣው ቢዴ» ጊዲ ዎታዳሬቲ ዎሊ ጊዶን ዳሮ ካጪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","ሄሮዲሲ ጴፂሮሳ ኮዪሲን፥ ኢ ꬋዪዳ ዎዴ ናጌይሳታ ቆሪዲ፥ ኤንታ ዎꬋና ሜላ ኪቲስ። ሄሳፌ ጉዬ፥ ሄሮዲሲ ዪሁዳፔ ቂሳሪያ ዎꬊዲ ያን ጉꬃ ዎዴ ኡቲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","ሄሮዲሲ ፂሮሳ ኣሳ ቦላኔ ሲዶና ኣሳ ቦላ ዳሮ ሃንቄቲስ። ኤንታ ቢታይ ካꬂ ሄሮዲሳ ቢታፌ ዴሚያ ጊሾ ኤንቲ ኢሲፌ ጊዲዲ ኢያ ሞሪና ቢላስፆሳ ባንታው ጪማ ኦꬂዲ ጊጋናው ሄሮዲሳኮ ቢዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","ሄሮዲሲ ሱንꬂዳ ጋላሳን ባ ካዎቴꬃ ኣፊላ ማዒዲ፥ ኣራታ ቦላ ኡቲዲ ኣሳስ ኦዲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","ኣሳይ፥ «ሄሲ ፆሳ ቃላ፥ ኣሳ ቃላ ጊዴና» ያጊዲ ዋሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","ሄሮዲሲ ፆሳ ቦንቺቦና ጊሾ ኢራካ ጎዳ ኪታንቾይ ኢያ ዴቺን ጉፁኔን ሜቴቲዲ ሃይቂስ። ");
INSERT INTO gofENT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","ሺን ፆሳ ቃላይ ዲጪሼኔ ዳልጊሼ ቤስ። ");
INSERT INTO gofENT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","ባርናባሲኔ ሳዖሊ ባንታ ኦሱዋ ፖሊዲ ማርቆሳ ጊያ ዮሃኒሳ ባንታራ ኤኪዲ ዬሩሳላሜፔ ሲሚዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","ኣንፆኪያን ዴዒያ ዎሳ ኬꬃን ናቤቲኔ ኣስታማሬቲ ዴዖሶና። ኤንቲ ባርናባሳ፥ ካሬꬂ ጌቴቲያ ሲሞና፥ ቄሬናፔ ዪዳ ሉኪዮሳ፥ ካዉዋ ሄሮዲሳራ ዲጪዳ ሚናሄኔ ሳዖላ። ");
INSERT INTO gofENT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","ኤንቲ ጎዳ ጎይኒሺኒኔ ፆሚሺን ጌሻ ኣያናይ፥ «ታኒ ፄጊዳ ኦሱዋስ ባርናባሳኔ ሳዖላ ታው ዱማዪቴ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","ሄሳ ጊሾ፥ ኤንቲ ፆሚዳፔኔ ዎሲዳፔ ጉዬ ባንታ ኩሺያ ኤንታ ቦላ ዎꬂዲ ዬዲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","ሄሳ ጊሾ፥ ጌሻ ኣያኒ ኤንታ ኪቲስ። ሴሌዉቄ ቢዶሶና፤ ያፔ ማርካቤን ጌሊዲ ቆጲሮሳ ሃꬃን ቴቄቲዳ ቢታ ቢዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","ኤንቲ ሲልማና ጋኪዲ ኣይሁዴ ዎሳ ኬꬃታን ፆሳ ቃላ ኦዲዶሶና። ዮሃኒሲ ማዲሼ ኤንታራ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","ኤንቲ ቆጲሮሳ ሃꬃን ቴቄቲዳ ቢታ ካንꬂዲ ጳፉ ጋኪያ ዎዴ ኢሲ ዎርዳንቾ ናቢያ ባር-ዬሱሳ ጊያ ኣይሁዴ ማሩዋ ዴሚዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","ሄ ማሮይ ዴሪያ ኣይሲያ ሳርጊዮስ ጳዉሎሳ ጊያ ኣኬካንቾ ኣዲያራ ዴዔስ። ሳርጊዮስ ጳዉሎሲ ባርናባሳኔ ሳዖላ ባኮ ፄጊዲ ፆሳ ቃላ ሲዓናው ኮዪስ። ");
INSERT INTO gofENT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","ሺን ጊሪኬ ዶናን ማሩዋ ሱንꬃይ «ኤልማሳ» ጌቴቴስ። ኢ ዴሪያ ሃሬይሲ ኣማኖና ሜላ ዲጋናው ኮዪዲ ባርናባሳራኔ ጳዉሎሳራ ኤቄቲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","ሺን ጳዉሎሳ ጊያ ሳዖሊ ጌሻ ኣያናን ኩሚዲ ማሩዋ ጫዲ ፄሊዲ፥ ");
INSERT INTO gofENT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","«ላ፥ ፃላሄ ናዓው፥ ኢታቴꬂ ኡባይ ኩሚዳይሶ፥ ፂሎቴꬃ ኡባስ ሞርኪያው፥ ሱሬ ጎዳ ኦጊያ ሚርቄይሳ ኣጊኪ? ");
INSERT INTO gofENT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","ሄኮ፥ ሃዒ ጎዳ ኩሼይ ኔ ቦላ ዴዔስ። ኔኒ ቆቄ ጊዳና፤ ጉꬃ ዎዴስ ኣዋ ፖዖ ቤዓካ» ያጊስ። ኢራ ጫጋናይኔ ꬉማይ ኢያ ኣይፊያ ጎዚን፥ ባ ኩሺያ ኦይኪዲ ካሌꬂያ ኣሲ ኮዪሼ ዩዪስ። ");
INSERT INTO gofENT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","ዴሪያ ሃሬይሲ ሄሳ ቤዒዳ ዎዴ ጎዳባ ታማርሴይሳን ማላሌቲዲ ኣማኒስ። ");
INSERT INTO gofENT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","ጳዉሎሲኔ ኢያራ ዴዔይሳቲ ጳፉፔ ዴንዲዲ፥ ጲንፊሊያን ዴዒያ ጴርጌ ማርካቤራ ቢዶሶና። ዮሃኒሲ ኤንታፌ ሻኬቲዲ ዬሩሳላሜ ሲሚስ። ");
INSERT INTO gofENT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","ሺን ኤንቲ ጴርጌፌ ኣꬊዲ ጲሲዲያን ዴዒያ ኣንፆኪያ ጋኪዶሶና። ሳምባታ ጋላስ ኣይሁዴ ዎሳ ኬꬂ ጌሊዲ ኡቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","ሙሴ ሂጌይኔ ናቤታ ማፃፋይ ናባቤቲዳፔ ጉዬ ኣይሁዴ ዎሳ ኬꬃ ሃላቃቲ፥ «ኑ ኢሻቶ፥ ኣሳ ሚንꬄꬂያ ቃሊ ሂንቴው ዴዒያኮ ኣሳስ ኦዴርኬቲ» ያጊዲ ኤንታኮ ኪቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","ጳዉሎሲ ዴንዲ ኤቂዲ ባ ኩሼ ማሊዲ፥ «ኢስራዔሌ ኣሳታው፥ ቃሲ ፆሳ ጎይኒያ ኣይሁዴ ጊዶና ኣሳው፥ ሲዒቴ። ");
INSERT INTO gofENT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","ሃ ኢስራዔሌ ኣሳ ፆሳይ፥ ኑ ማይዛታ ዶሪስ። ጊብፄ ቢታን ኢማꬃቴꬃን ኤንቲ ዴዒሺን፥ ኤንታ ዳርሲዲ ባ ጊታ ዎልቃን ጊብፄ ቢታፌ ኤንታ ኬሲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","ባዞ ቢታን ኦይታሙ ላይꬃ ሜላ ኤንታ ዳንዳዒስ። ");
INSERT INTO gofENT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","ካናኔ ቢታን ኣይሁዴ ጊዶና ላፑን ካዎቴꬃታ ዲጊዲ ኤንታ ቢታ ባ ኣሳ ላቲሲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","ሄሳፌ ጉዬ፥ ናቢያ ሳሙዔላ ዎዴ ጋካናው ኦይዱ ፄታኔ ኢሻታሙ ላይꬃ ሜላ ኣይሲያ ዳይናታ ኤንታው ኢሚስ። ");
INSERT INTO gofENT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","ሄሳፌ ጉዬ፥ ኤንቲ ባንታው ካዎ ኢማና ሜላ ዎሲን፥ ፆሳይ ቢኒያሜ ሼሻፔ ቂሴ ናዓ፥ ሳዖላ ኦይታሙ ላይꬂ ካዎታና ሜላ ኤንታው ኢሚስ። ");
INSERT INTO gofENT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","ፆሳይ ሳዖላ ሻሪዳፔ ጉዬ ኤንታ ቦላ ዳዊቴ ካዎꬂስ። ፆሳይ ዳዊቴባ ማርካቲሼ፥ ‹ታኒ ኮያ ኡባ ታ ዎዛና ሜላ ኦꬂያ ኢሴዬ ናዓ ዳዊቴ ዴማስ› ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","«ፆሳይ፥ ‹ታኒ ዳዊቴ ሼሻፔ ኢስራዔሌ ዴሪያ ኣሼይሳ ኤሃና› ጊዳይሳ ሜላ ዬሱሳ ኤሂስ። ");
INSERT INTO gofENT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","ዬሱሲ ያናፔ ሲንꬄ ኢስራዔሌ ኣሳ ኡባይ ባንታ ናጋራፔ ሲሚዲ ፃማቄታና ሜላ ዮሃኒሲ ቃላ ኦዲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","ቃሲ ዮሃኒሲ ባ ኦሱዋ ዉርሳና ሃኒሼ ኣሳኮ፥ ‹ታና ኦና ጊዲ ቆፔቲ? ታኒ ሂንቴ ናጊያ ኪሪስቶሳ ጊዲኬ፥ ሺን ታኒ ኢያ ጫማ ቢርሻናው ታው ቤሶናይሲ ታፔ ጉዬራ ዬስ› ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","«ኢሻቶ፥ ኣብራሃሜ ሼሻቶ፥ ቃሲ ሃይሳን ኣይሁዴ ጊዶናሺን ፆሳስ ያዬይሳቶ፥ ሃ ኣቶቴꬃ ቃላይ ኑስ ኪቴቲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","ኣይስ ጊኮ፥ ዬሩሳላሜን ዴዒያ ኣሳይኔ ኤንታ ሃላቃቲ ዬሱሳ ኤሪቦኮና። ሳምባታ ኡባን ናባቤቲያ ናቤታ ቃላ ኣኬኪቦና ጊሾ ኢያ ቦላ ፒርዲዲ ናቤቲ ኦዲዳ ቃላ ፖሊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","ዬሱሳ ዎꬊሳናው ኢሲ ጋሶይካ ꬋዪን ጲላፆሲ ኢያ ዎꬋና ሜላ ዎሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","ኤንቲ ዬሱሳባይ ጌሻ ማፃፋን ፃፌቲዳባ ኡባ ፖሊዳ ዎዴ ማስቃሊያፔ ኢያ ዎꬊሲዲ ሞጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","ሺን ፆሳይ ሃይቆፔ ዬሱሳ ዴንꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","ሄሳፌ ጉዬ፥ ኢ ባራ ጋሊላፔ ዬሩሳላሜ ዪዳይሳታስ ዳሮ ቶሆ ቤንቲስ። ኤንቲ ሃዒ ኢያባ ኣሳስ ማርካቶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","«ፆሳይ ኑ ኣዋታስ ኢማና ጊዳ ዎንጌላ ኑኒ ሂንቴው ኦዶስ። ");
INSERT INTO gofENT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ዳዊቴይ ባ ማዝሙሬ ማፃፋን ናምዓንꬆ ሼምፑዋን፥ ‹ኔኒ፥ ታ ናዓ፥ ታኒ ሃቺ ኔና ዬላስ› ጌቴቲዲ ፃፌቲዳ ዬሱሳ፥ ፆሳይ ሃይቆፔ ዴንꬂዲ ኑ ማይዛታስ ኢማና ጊዳይሳ ኑስ ኤንታ ናይታስ ፖሊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","ኢ ዎቆና ሜላ ፆሳይ ሃይቆፔ ኢያ ዴንꬆን ኤሪሳናው፥ ‹ታኒ ዳዊቴስ ኢማና ጊዳ ኣማኔቲዳ ጌሻ ኣንጁዋ ሂንቴው ኢማና› ያጊዲ ኦዲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","ሄሳ ጊሾ፥ ማዝሙሬ ማፃፋን ሃራሶን ቃሲ፥ ‹ኔ ጌሻ ናዓ ኣሃ ዎቂሳካ› ያጌስ። ");
INSERT INTO gofENT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","«ዳዊቴይ ባ ዎዴ ፆሳ ቆፋ ፖሊዳፔ ጉዬ ሃይቂዲ ባ ኣዋታራ ሞጌቲዲ ዎቂስ። ");
INSERT INTO gofENT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","ሺን ፆሳይ ሃይቆፔ ዴንꬂዳይሲ ዎቂቤና። ");
INSERT INTO gofENT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","«ሄሳ ጊሾ፥ ታ ኢሻቶ፥ ናጋራ ኣቶቴꬃይ ዬሱሳ ባጋራ ካሴቲዲ ሂንቴው ኦዴቲዳይሳ ኤሪቴ። ሙሴ ሂጌይ ናጋራፔ ፂሊሳናው ዳንዳዔና። ");
INSERT INTO gofENT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","ሺን ዬሱሳ ኣማኒያ ኡባይ ናጋራፔ ፂሌስ። ");
INSERT INTO gofENT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","ሄሳ ጊሾ፥ ናቤቲ ጊዳይሲ ሂንቴ ቦላ ጋኮና ሜላ ናጌቲቴ። ");
INSERT INTO gofENT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‹ፆሳይ ጊዳባ ሌቂሴይሳቶ! ቤዒቴ! ማላሌቲቴ! ꬋዪቴ! ኦኒካ ኦዲን፥ ሂንቴ ኣማኖና ኦሱዋ ታኒ ሂንቴ ዎዲያን ኦꬃና› » ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","ጳዉሎሲኔ ባርናባሲ ኣይሁዴ ዎሳ ኬꬃፌ ኬዪሺን፥ ካሊያ ሳምባታን ሄሳ ጉጂዲ ኦዳና ሜላ ኣሳይ ኤንታና ዎሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","ሺቆይ ላሌቲዳፔ ጉዬ ዳሮ ኣይሁዴቲኔ ኣይሁዴታ ኣማኑዋን ጌሊዲ ፆሳ ጎይኒያ ዳሮቲ ጳዉሎሳኔ ባርናባሳ ካሊዶሶና። ኣማኒዳይሳቲ ፆሳ ኣꬎ ኬሃቴꬃን ሚኒዲ ዳና ሜላ ኤንታ ዞሪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","ካሊያ ሳምባታን ካታማን ዴዒያ ኣሳፔ ዳሮቲ ፆሳ ቃላ ሲዓናው ሺቂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","ሺን ኣይሁዴቲ ዳሮ ኣሳ ቤዒዳ ዎዴ ጳዉሎሳ ቃናቲዲ ኢያ ሃሳያ ኢፂዲ ኢያ ጫዪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","ጳዉሎሲኔ ባርናባሲ ያዮና፥ «ፆሳ ቃላይ ኮይሮቲዲ ሂንቴው ኦዴታናው ኮሼስ። ሺን ሂንቴ ቃላ ኢፂዲ ሜሪና ዴዑዋ ኤካናው ኑስ ቤሴና ጊዲ ሂንቴ፥ ሂንቴ ሁዔን ፒርዲዳ ጊሾ ሂዛ ኑኒ ኣይሁዴ ጊዶናይሳታኮ ሲሞስ። ");
INSERT INTO gofENT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","ጋሶይካ ጎዳይ፥ ‹ኣላሜ ኩሜꬃይ ኔ ባጋራ ኣታና ሜላ፥ ታኒ ኔና ኣይሁዴ ጊዶና ዴሪያስ ፖዖ ኦꬃስ› ያጊዲ ኑና ኪቲስ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","ኣይሁዴ ጊዶናይሳቲ ሄሳ ሲዒዳ ዎዴ ኡፋይቲዲ ፆሳ ቃላ ቦንቺዶሶና። ቃሲ ሜሪና ዴዑዋስ ዶሬቲዳ ኡባይ ኣማኒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","ጎዳ ቃላይ ሄ ቢታ ኡባ ጋኪስ። ");
INSERT INTO gofENT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","ሺን ኣይሁዴቲ፥ ኣይሁዴ ጊዶና ፆሴ ጎይኒያ ዱሬ ማጫሳታኔ ካታማን ዴዒያ ጊታ ኣሳታ ጳዉሎሳ ቦላኔ ባርናባሳ ቦላ ዴንꬄꬂዶሶና። ሄ ኣሳቲ ኤንታ ጎዳ ዶሚዲ ባንታ ቢታፌ ኬሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","ሺን ጳዉሎሳራኔ ባርናባሳራ ኢፄይሳታስ ማላ ጊዳና ሜላ ባንታ ቶሁዋፔ ባና ፒቲዲ ኢቆኒዮኔ ካታማ ቢዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","ቃሲ ኣንፆኪያን ዴዒያ ኣማኔይሳቲ ጌሻ ኣያናኒኔ ኡፋይሳን ኩሚዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","ካሴይሳዳካ፥ ጳዉሎሲኔ ባርናባሲ ኢቆኒዮኔን ኣይሁዴታ ዎሳ ኬꬂ ጌሊዲ ዳሮ ኣይሁዴቲኔ ኣይሁዴ ጊዶናይሳቲ ኣማናና ጋካናው ቃላ ኦዲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","ሺን ኣማኒቦና ኣይሁዴቲ፥ ኣይሁዴ ጊዶናይሳታ ዎዛና ላሚዲ ኢሻታ ቦላ ዴንꬄꬂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","ሃዋሬቲ ያን ዳሮ ዎዴ ጋምዒዶሶና። ኤንቲ ያዮና ጎዳባ ኦዲዶሶና። ጎዳይ ማላታታኔ ኦራꬃባ ኤንቲ ኦꬃና ሜላ ኤንታው ማታ ኢሚዲ ባ ኣꬎ ኬሃቴꬃ ቃላይ ቱማ ጊዴይሳ ቆንጪሲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","ሺን ሄ ካታማ ኣሳይ ሻኬቲዲ፥ ባጋይ ኣይሁዴታራ ባጋይ ቃሲ ሃዋሬታራ ጊዲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","ኣይሁዴ ጊዶናይሳቲኔ ኣይሁዴቲ ባንታ ሃላቃታራ ኢሲፌ ጊዲዲ ሃዋሬታ ቆሃናዉኔ ሹቻን ጫዳናው ኮዪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","ሃዋሬቲ ሄሳ ኤሪዲ፥ ሊስፂራኔ ዳርቤ ጊያ ሊቃዖኒያ ካታማታኔ ኤንታ ሄራን ዴዒያ ቢታ ባቃቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","ያን ዎንጌላ ኦዲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","ዬሌቶሳፔ ዶሚዲ ናምዑ ቶሆይ ዎቢን ሃሙቲ ኤሮና ኢሲ ኣዴይ ሊስፂራን ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","ሄ ኣዴይ ጳዉሎሲ ኦዲሺን ኡቲዲ ሲዔስ። ጳዉሎሲ ኢያ ጫዲዲ ፄሊያ ዎዴ ፓፃናው ኢያው ኣማኖይ ዴዔይሳ ቤዒዲ፥ ");
INSERT INTO gofENT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","ባ ቃላ ꬎቁ ኦꬂዲ፥ «ሲቲ ጋዳ ኔ ቶሁዋን ኤቃ» ያጊስ። ያቲን፥ ጉፒ ዴንዲ ኤቂዲ ሃሙꬂ ዶሚስ። ");
INSERT INTO gofENT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","ጳዉሎሲ ኦꬂዳይሳ ኣሳይ ቤዒዲ ባንታ ቃላ ꬎቁ ኦꬂዲ ሊቃዖኒያ ዶናን፥ «ፆሳቲ ኣሴ ዳኒዲ ኑኮ ዎꬊዶሶና» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","ባርናባሳ፥ «ዲያ» ጊዲ፥ ጳዉሎሲ ሃሳያን ዋናቲያ ጊሾ ኢያ፥ «ሄርሜሳ» ጊዲ ሱንꬂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","ካታማፔ ጋፃን ዴዒያ ኤቃ ዲያ ኬꬃ ካሂኔይኔ ኣሳይ ኮርማታኔ ኣሌቆ ጪሻታ ሃዋሬታስ ያርሻናው ኮዪዲ ካታማ ፔንጌ ኤሂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","ሺን ባርናባሲኔ ጳዉሎሲ ሄሳ ሲዒዳ ዎዴ ኤንቲ ኦꬃናው ቆፒዳይሳ ኢፂዲ ባንታ ማዑዋ ፔꬊዶሶና። ኣሳ ጊዶ ዎፂ ጌሊዲ፥ ");
INSERT INTO gofENT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","ባንታ ቃላ ꬎቁ ኦꬂዲ፥ «ኣሳው፥ ሃይሳ ኣይስ ኦꬄቲ? ኑካ ሂንቴ ሜላ ኣሴ። ሃ ፓꬆናባፔ ሳሉዋኔ ሳዓ፥ ኣባኔ ኤንታ ጊዶን ዴዒያ ኡባባ ሜꬊዳ ዴዖ ፆሳኮ ሂንቴ ሲማና ሜላ ሂንቴው ኑኒ ዎንጌላ ኦዶስ። ");
INSERT INTO gofENT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","ኢ ቤኒ ኣሳ ባንታ ኦጊያ ባና ሜላ ዬዲ ኣጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","ሺን ኢራ ሳሉዋፔ ቡኪሲስ፥ ካꬃካ ዎዴን ዎዴን ኢሚስ፥ ካꬂ ኢሚዲ ሂንቴና ዳሮ ኡፋይሲስ፥ ያቲዲ ሂንቴው ሎዖባ ኦꬂዲ ባው ማርካ ꬋይሲቤና» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","ሃዋሬቲ ሄሳ ጊዲ ባንታው ኣሳይ ያርሾና ሜላ ዋዪዲ ዲጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","ኣንፆኪያፔኔ ኢቆኒዮኔፔ ዪዳ ኣይሁዴቲ፥ ኣሳ ባንታ ባጋ ዛሪዲ ሹቻን ጳዉሎሳ ጫዲዶሶና። ኤንታው ኢ ሃይቂዳባ ዳኒን ካታማፔ ጋፃ ጎቺ ኤፊዲ ዬጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","ሺን ኣማኔይሳቲ ዪዲ፥ ኢያ ዩሹዋን ኤቂዳሺን ኢ ዴንዲዲ ካታማ ጌሊስ። ዎንቴꬃ ጋላስ ባርናባሳራ ኢሲፌ ዳርቤ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","ኤንቲ ዳርቤ ካታማን ዎንጌላ ኦዲዲ ዳሮታ ኣማንꬂዳፔ ጉዬ ሊስፂራ፥ ኢቆኒዮኔኔ ጲሲዲያ ኣንፆኪያ ሲሚዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","ያን ኣማኔይሳታ ሚንꬄꬂሼኔ ኤንቲ ኣማኖን ሚኒዲ ዴዓና ሜላ ዞሪሼ፥ «ፆሳ ካዎቴꬃ ጌላናው ኑኒ ዳሮ ዋዬ ኤካናው ቤሴስ» ያጊዲ ታማርሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","ቃሲ ዎሳ ኬꬃታስ ሁዔን ሁዔን ጪማታ ዶሪዶሶና። ፆሚዳፔኔ ዎሲዳፔ ጉዬ ኤንቲ ኣማኒዳ ጎዳስ ኤንታ ሃዳራ ኢሚዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","ጲሲዲያ ቢታ ካንꬂዲ ኣꬊዲ ጲንፊሊያ ቢዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","ጴርጌን ቃላ ኦዲዳፔ ጉዬ ኣፃሊያ ቢዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","ያፔ ኤንቲ ባንታ ፖሊዳ ኦሱዋስ ፆሳ ኣꬎ ኬሃቴꬃስ ኤንታ ሃዳራ ኢሚዳ ኣንፆኪያ ማርካቤራ ሲሚዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","ኣንፆኪያ ጋኪዳ ዎዴ ዎሳ ኬꬃ ኣሳ ሺሺዲ ፆሳይ ኤንታራ ኦꬂዳ ኦሱዋ ኡባኔ ኣይሁዴ ጊዶና ኣሳይ ኣማናና ሜላ ኤንታው ዋቲ ፔንጌ ዶዪዳኮ ኦዲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","ሄሳን ኣማኔይሳታራ ዳሮ ዎዴ ጋምዒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","ኢሲ ኢሲ ኣሳቲ ዪሁዳፔ ኣንፆኪያ ቢዲ፥ «ሙሴ ዎጋꬆ ሂንቴ ቃፃሬቶና ኢፂኮ ኣታናው ዳንዳዔኬታ» ጊዲ ኣማኔይሳታ ታማርሶ ዶሚዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","ሄሲ ጳዉሎሳኔ ባርናባሳ ኤንታራ ዳሮ ፓላማናዳኔ ካጫናዳ ኦꬂስ። ሄሳ ጊሾ፥ ኣንፆኪያን ዴዒያ ኢሲ ኢሲ ኣሳቲ ጳዉሎሳራኔ ባርናባሳራ ዬሩሳላሜ ቢዲ ሃዋሬታራኔ ጪማታራ ጋሄቲዲ ሄ ኦዳ ቢላና ሜላ ቆፋ ቃቺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","ዎሳ ኬꬃይ ኤንታ ኪቲን ቢዶሶና። ኤንቲ ሲሮፊንቄ ሳማሬራ ኣꬊሼ ኣይሁዴ ጊዶናይሳቲ ፆሳኮ ዋኒዲ ሲሚዳኮ ኦዲዶሶና። ሄሲ ኣማኔይሳታ ኡባ ዳሮ ኡፋይሲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","ኤንቲ ዬሩሳላሜ ጋኪዳ ዎዴ ዎሳ ኬꬃይ፥ ሃዋሬቲኔ ጪማቲ ኤንታ ሞኪዶሶና። ፆሳይ ባንታራ ኦꬂዳባ ኡባ ኦዲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","ሺን ፋሪሳዌታ ባጋፌ ኣማኒዳ ኢሲ ኢሲ ኣሳቲ ዴንዲ ኤቂዲ፥ «ኣይሁዴ ጊዶናሺን ኣማኒዳ ኣሳቲ ቃፃሬታናዉኔ ሙሴ ሂጊያ ናጋናው ቤሴስ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","ሃዋሬቲኔ ጪማቲ ሄሳ ዞሬታናው ሺቂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","ዳሮ ሃሳዪዳፔ ጉዬ፥ ጴፂሮሲ ዴንዲ ኤቂዲ፥ «ታ ኢሻቶ፥ ኣይሁዴ ጊዶናይሳቲ ዎንጌላ ቃላ ታ ዶናፔ ሲዒዲ ኣማናና ሜላ ካሴቲዲ ታና ፆሳይ ሂንቴ ጊዶፌ ዶሪዳይሳ ሂንቴ ኤሬታ። ");
INSERT INTO gofENT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","ኣሳ ዎዛና ኤሪያ ፆሳይ ጌሻ ኣያና ኑስ ኢሚዳይሳዳ ኤንታዉካ ኢሚዲ ቱማይስ። ");
INSERT INTO gofENT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","ኣማኖን ኤንታ ዎዛና ጌሺዳ ጊሾ ኑ ጊዶኒኔ ኤንታ ጊዶን ዱማቴꬂ ዎꬂቤና። ");
INSERT INTO gofENT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","ሄሳ ጊሾ፥ ኑ ኣዋቲኔ ኑኒ ቶካናው ዳንዳዒቦና ቃምባራ ኣማኔይሳታ ሞርጌን ዎꬂዲ ሃዒ ኣይስ ፆሳ ፓጬቲ? ");
INSERT INTO gofENT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","ጎዳ ዬሱስ ኪሪስቶሳ ኣꬎ ኬሃቴꬃን ኤንቲ ኣቲዳይሳዳ ኑካ ኣቲዳይሳ ኣማኖስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","ኣሳይ ሲዒ ጊዲ፥ ባርናባሲኔ ጳዉሎሲ ኣይሁዴ ጊዶና ኣሳ ጊዶን ባንታ ባጋራ ፆሳይ ኦꬂዳ ማላታታኔ ኦራꬃባ ኡባ ኦዲሺን ሲዖሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","ኤንቲ ሃሳያ ኦንጊዳፔ ጉዬ ያይቆቢ፥ «ኢሻቶ፥ ታ ጌይሳ ሲዒቴ። ");
INSERT INTO gofENT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","ፆሳይ ኣይሁዴ ጊዶናይሳታ ጊዶፌ ባ ኣሴ ዶራናው ኮዪዲ ኤንታና ኮይሮ ዋቲዲ ቆፒዳኮ ሲሞኒ ኦዲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","ናቤታ ቃላይ ሃይሳራ ጊኔስ። ጌሻ ማፃፋን፥ ");
INSERT INTO gofENT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‹ሃይሳፌ ጉዬ፥ ታኒ ሲማና፥ ኩንዲዳ ዳዊቴ ካዎቴꬃ ዴንꬃና። ላሌቲዳ ኬꬃካ ዛራ ኤሳና። ");
INSERT INTO gofENT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","ኣቲዳ ኣሳ ኡባይ ታኮ ያና፥ ታኒ ፄጊዳ ኣይሁዴ ጊዶና ኣሳ ኡባይ ታና ኮያና። ");
INSERT INTO gofENT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","ቤኒፔ ዶማዳ ሄሲ ኤሬታና ሜላ ኦꬂዳ ፆሳይ፥ ታኒ ያጋይስ› ያጌስ። ");
INSERT INTO gofENT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","«ሄሳ ጊሾ፥ ታ ቆፋይ ፆሳኮ ሲሚያ ኣይሁዴ ጊዶናይሳታ ኑኒ ዋይሶናኮ ሎዖ። ");
INSERT INTO gofENT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","ሺን ኤንቲ ኤቃስ ያርሼቲዲ ቱኒዳባ ሞና ሜላ፥ ላይማቶና ሜላ፥ ባዉታ ሞና ሜላኔ ሱꬂ ኡዮና ሜላ ኤንታው ኑኒ ዳብዳቤ ፃፋናው ኮሼስ። ");
INSERT INTO gofENT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","ሙሴ ሂጌይ ቤኒፔ ዶሚዲ ሳምባታን ሳምባታን ኣይሁዴ ዎሳ ኬꬃታን ናባቤቲሼ ካታማ ኡባን ሳባኬቴስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","ሄሳፌ ጉዬ፥ ሃዋሬቲኔ ጪማቲ ዎሳ ኬꬃ ኣሳ ኡባራ ኢሲፌ ባንታ ጊዶፌ ጉꬃ ኣሳታ ዶሪዲ ጳዉሎሳራኔ ባርናባሳራ ኣንፆኪያ ዬዳናው ቆፋ ቃቺዶሶና። ኤንቲ ዳሮ ቦንቼቲዳ ናምዑ ኣሳታ ባርሳባሳ ጌቴቲያ ዪሁዳኔ ሲላሴ ዶሪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","ሃይሳዳ ጌቴቲ ፃፌቲዳ ዳብዳቢያ ኤንታ ቦላ ዬዲዶሶና፡ «ኑኒ ሃዋሬቲኔ ጪማቲ ሂንቴ ኢሻቲ፥ ኣንፆኪያን፥ ሶሪያኒኔ ኪልቂያን ዴዒያ ኣይሁዴ ጊዶና ኢሻታስ ኑ ሳሮꬁዋ ኪቶስ። ");
INSERT INTO gofENT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","«ኑኒ ኪቶና ኣሳቲ ኑ ጊዶፌ ቢዲ፥ ‹ሂንቴ ቃፃሬታናዉኔ ሂጊያ ናጋናው ቤሴስ› ጊዲ፥ ሂንቴና ዋይሲዳይሳኔ ዪሎዪዳይሳ ሲዒዳ። ");
INSERT INTO gofENT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","ኑኒ ዶሲያ ባርናባሳኔ ጳዉሎሳ ዶሬቲዳ ኣሳታራ ኢሲፌ ሂንቴኮ ኪታናው ኢሲ ዎዛናን ኑ ቆፋ ቃቺዳ። ");
INSERT INTO gofENT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ኤንቲ ኑ ጎዳ ዬሱስ ኪሪስቶሳ ጊሾ ባንታ ዴዑዋ ኣꬂ ኢሚዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","ሄሳ ጊሾ፥ ኑኒ ፃፊዳይሳ ኤንቲ ባንታ ዶናን ጉጂዲ ሂንቴው ኦዳና ሜላ ዪሁዳኔ ሲላሴ ኪቲዳ። ");
INSERT INTO gofENT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","«ሃ ኮሼይሳታፔ ኣቲን ሃራ ቶሆ ሂንቴና ቶሶና ሜላ ኑኔ ጌሻ ኣያናይ ኦዳ ቃቺዳ። ");
INSERT INTO gofENT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","ኤቃስ ያርሼቲዲ ቱኒዳባ ሞፒቴ፥ ሱꬁ ኡዮፒቴ፥ ባዉታ ሞፒቴ፥ ላይማቶፒቴ። ሃ ኡባፌ ሂንቴ፥ ሂንቴ ሁዒያ ናጊኮ ሎዖባ ኦꬄታ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","ሄሳ ጊሾ፥ ኪቴቲዳይሳቲ ሞይዜቲዲ ኣንፆኪያ ቢዲ ኣማኒያ ኣሳ ሺሺዲ፥ ዳብዳቤ ኢሚዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","ኤንቲ ሄ ሚንꬄꬂያ ዳብዳቢያ ናባቢዳ ዎዴ ኡፋይቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","ቃሲ ዪሁዲኔ ሲላሴይ ባንታ ሁዔን ናቤ ጊዲያ ጊሾ ኣማኔይሳታ ሎይꬂ ዞሪዲ ሚንꬄꬂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","ኤንቲ ኣንፆኪያን ጉꬃ ጋላስ ኡቲዳፔ ጉዬ ኢሻቲ ሎዖራ ሞይዚን ባንታና ኪቲዳይሳታኮ ሲሚዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","ሺን ሲላሴይ ያን ኣታናው ኮዪስ። ");
INSERT INTO gofENT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","ቃሲ ጳዉሎሲኔ ባርናባሲ ሃራ ዳሮ ኣሳታራ ኢሲፌ ጎዳ ቃላ ታማርሲሼኔ ዎንጌላ ኦዲሼ ኣንፆኪያን ጋምዒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","ጉꬃ ጋላሳፔ ጉዬ ጳዉሎሲ ባርናባሳኮ፥ «ኑኒ ጎዳ ቃላ ኦዲዳ ካታማ ኡባን ኣማኔይሳቲ ዋኒዲ ዴዒያኮ ጉዬ ሲሚሼ ፆሞሳና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","ባርናባሲ ማርቆሳ ጌቴቲያ ዮሃኒሳ ባንታራ ኤፋናው ኮዪስ። ");
INSERT INTO gofENT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","ሺን ጳዉሎሲ ማርቆሳ ባንታራ ኤፋናው ኮዪቤና። ጋሶይካ፥ ኢ ጲንፊሊያን ሻኬቲዲ ኤንታራ ኦꬃናው ቢቤና። ");
INSERT INTO gofENT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","ኤንታ ጊዶን ኢታ ኦሺ ኬዪን ኢሶይ ኢሱዋፌ ሻኬቲዶሶና። ባርናባሲ ማርቆሳ ኤኪዲ ማርካቤራ ቆጲሮሳ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","ሺን ጳዉሎሲ ሲላሴ ዶሪስ፤ ኣማኔይሳቲ ጳዉሎሳ ፆሳ ኣꬎ ኬሃቴꬃስ ሃዳራ ኢሚዳፔ ጉዬ ኢ ኬዪዲ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","ያቲዲ፥ ዎሳ ኬꬃታ ሚንꬄꬂሼ ሶሪያራኔ ኪልቂያራ ኣꬊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","ጳዉሎሲ ዳርቤኔ ሊስፂራ ቢስ። ያን ፂሞቲዮሳ ጊያ ኣማኒያ ኣሲ ዴዔስ። ኢያ ኣያ ኣማኒያ ኣይሁዴ ማጫስ፥ ኢያ ኣዋይ ጊሪኬ ኣሲ። ");
INSERT INTO gofENT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","ሊስፂራኒኔ ኢቆኒዮኔን ዴዒያ ኣማኔይሳቲ ፂሞቲዮሳባ ሎይꬂዲ ማርካቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","ጳዉሎሲ ፂሞቲዮሳ ባራ ኤፋናው ኮዪዲ፥ ኢያ ኣዋይ ጊሪኬ ኣሲ ጊዲዳይሳ ሄ ቤሳን ዴዒያ ኣይሁዴ ኡባይ ኤሪያ ጊሾ ኢያ ቃፃሪስ። ");
INSERT INTO gofENT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","ኤንቲ ካታማታራ ቢሼ ዬሩሳላሜን ዴዒያ ሃዋሬቲኔ ጪማቲ ዎꬂዳ ሂጊያ ኣማኔይሳቲ ናጋና ሜላ ኤንታው ኦዲሼ ኣꬊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","ሄሳ ጊሾ፥ ዎሳ ኬꬃቲ ኣማኖን ሚኒሼ፥ ታይቦንካ ጋላስ ጋላስ ዳሪ ዳሪ ቢዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","ኢሲያን ቃላ ኦዶና ሜላ ጌሻ ኣያናይ ኤንታ ዲጊዳ ጊሾ ጲርጌራኔ ጋላቲያ ቢታራ ኣꬊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","ኤንቲ ሚሲያ ዛዋ ጋኪዳ ዎዴ ቢቲኒያ ባናው ኮዪዶሶና። ሺን ዬሱሳ ኣያናይ ኤንታ ዲጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","ሄሳ ጊሾ፥ ኤንቲ ሚሲያ ማታራ ኣꬊሼ ፂሮዓዳ ዎꬊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","ጳዉሎሲ ቃማ ቆንጬꬃን ኢሲ ማቄዶኒያ ኣሲ ባኮ፥ «ማቄዶኒያ ፒናዳ ኑና ማዳርኪ» ያጊሼ ኤቂዲ ዎሲሺን ቤዒስ። ");
INSERT INTO gofENT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","ቆንጬꬃ ኢ ቤዒዳፔ ጉዬ ኤሌሲዲ ኑኒ ማቄዶኒያ ባናው ኮዪዳ። ሄሲካ፥ ዎንጌላ ያን ዴዒያ ኣሳስ ኦዳናው ፆሳይ ኑና ፄጊዳይሳ ኤሪዳ ጊሾሳ። ");
INSERT INTO gofENT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","ፂሮዓዳፔ ዴንዲዲ ማርካቤን ጌሊዲ ሳሞቲራቄ ቢዳ፥ ዎንቴꬃ ጋላስ ናጱሌ ቢዳ። ");
INSERT INTO gofENT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","ያፔ ዴንዲዲ ማቄዶኒያ ቢታን ዴዒያ ፊልጲሲዩሳ ጊያ ኮይሮ ካታማ ቢዳ። ቃሲ ፊልጲሲዩሲ ሮሜ ኣሳይ ዴዒያ ካታማ። ኑኒ ሄ ካታማን ጉꬃ ጋላስ ኡቲዳ። ");
INSERT INTO gofENT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","ሳምባታ ጋላስ ካታማፔ ጋፃን ሻፋ ዶናን ኣይሁዴቲ ፆሳ ዎሲያ ቤሲ ዴዔይሳ ኤሪዲ ያ ቢዳ። ሄ ቤሳን ሺቂዳ ማጫሳስ ቃላ ኦዲዳ። ");
INSERT INTO gofENT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","ኑና ሲዒያ ኣሳፔ ኢሲ ሊዲያ ጌቴቲያ ቲያቲሮና ካታማፔ ዪዳ፥ ፆሳ ኣማኒዳ ዞዖ ኣፊላ ዛልዒያ፥ ማጫሲያ ዴዓዉሱ። ጳዉሎሲ ኦዴይሳ ኢያ ሲዓና ሜላ ፆሳይ ኢ ዎዛና ዶዪስ። ");
INSERT INTO gofENT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","ሊዲያ ባ ሶ ኣሳራ ኢሲፌ ፃማቄቲዳፔ ጉዬ ኑኮ፥ «ሂንቴ ታና ጎዳ ቱማ ኣማናሱ ጊኮ ታ ሶ ዬꬊቴ» ጋዳ ሚንꬃዳ ዎሳሱ። ");
INSERT INTO gofENT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","ኑኒ ፆሳ ዎሲያ ቤሳ ቢሺን ኢታ ኣያኒ ኢ ቦላ ዴዒዲ ካይሲያ ኢሲ ጌላዖ ኣይሌይ ኑራ ጋሄታሱ። ኢያ ካያዳ ዳሮ ሚሼ ባ ጎዳታስ ኤሃዉሱ። ");
INSERT INTO gofENT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","ጳዉሎሳኔ ኑና ካላዳ፥ «ሃይሳቲ ኡባፌ ቦላ ፆሳ ኣይሌታ! ኤንቲ ሂንቴ ኣታና ኦጊያ ኦዴይሳታ» ጋዳ ዋሳሱ። ");
INSERT INTO gofENT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","ኡባ ጋላስ ሄሳዳ ጋዉሱ። ሺን ጳዉሎሲ ዪሎቲዲ ጉዬ ሲሚዲ፥ ሄ ኣያና፥ «ዬሱስ ኪሪስቶሳ ሱንꬃን ኢፔ ኬያ» ጊዲ ኪቲስ። ኢራካ ኢታ ኣያናይ ኢፔ ኬዪ ኣጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","ሺን ኢ ጎዳቲ ባንታው ሚሼ ዴሚያ ኦጌይ ꬋዪዳይሳ ቤዒዲ፥ ጳዉሎሳኔ ሲላሴ ኦይኪዲ፥ ዳባባ ዳይናታ ሲንꬄ ጎቺ ኤፊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","ዳይናታ ሲንꬄ ኤንታ ኤፊዲ፥ «ሃይሳቲ ኣይሁዴ ኣሲ ጊዲሼ ኑ ካታማ ኣሳ ዳሮ ዋይሶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","ኑኒ ሮሜ ቢታ ኣሲ ጊዲሼ ኤካናዉኔ ኦꬃናው ዎጋ ጊዶናባ ታማርሶሶና» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","ኣሳይ ኢሲ ባጋ ጊዲዲ፥ ጳዉሎሳ ቦላኔ ሲላሴ ቦላ ዴንዲዶሶና። ዳይናቲ ኤንታ ማዑዋ ቃሪዲ ፃምዓን ኤንታ ሾጫና ሜላ ኪቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","ኤንታ ዳሮ ዋꬊዳፔ ጉዬ ቃሾ ኬꬂ ጌልሲዶሶና። ቃሾ ኬꬃ ናጌይሲ ኤንታ ሚንꬂ ናጋና ሜላ ኪቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","ቃሾ ኬꬃ ናጌይሲ ሄ ኪታ ኤኪዲ፥ ጳዉሎሳኔ ሲላሴ ቃሾ ኬꬃስ ቆልዓ ጌልሲስ። ኤንታ ቶሁዋ ዱፂስ ");
INSERT INTO gofENT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","ሺን ጊዲ ቢላሄ ጊዲያ ዎዴ ጳዉሎሳራኔ ሲላሴራ ዎሲሼኔ ማዝሙሬ ዬፂሼ ፆሳ ጋላቶሶና። ቃሾ ኬꬃን ዴዒያ ሃራ ኣሳቲካ ኤንቲ ጊያባ ሲዖሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","ቆፖና ቃሾ ኬꬃ ባሶይ ቃፃና ጋካናው ቢታ ቃፆይ ሃኒስ። ሄ ሳቴንካ ፔንጌ ኡባይ ዶዬቲ ኣጊስ፤ ቃሼቲዳ ኣሳ ኡባ ሳንꬃላታይ ቢርሼቲ ዎꬊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","ቃሾ ኬꬃ ናጌይሲ ꬊስኮፌ ባርኪዳ ዎዴ ቃሾ ኬꬃ ፔንጌ ኡባይ ዶዬቲዳይሳ ቤዒዲ ቃሾ ኣሳይ ኬሲ ኤኪ ቢዳባ ዳኒን ባና ዎꬋናው ማሼ ኤኪስ። ");
INSERT INTO gofENT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","ሺን ጳዉሎሲ ቃላ ꬎቁ ኦꬂዲ «ኑ ኡባይ ሃይሳን ዴዒያ ጊሾ ኔኒ ኔና ቆሆፓ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","ቃሾ ኬꬃ ናጌይሲ ፆምፔ ዎሲ ኤኪዲ ኤሌሲዲ ጋꬂ ዎፂስ። ኮኮሪሼ ጳዉሎሳ ሲንꬃኒኔ ሲላሴ ሲንꬃን ጉፋኒስ። ");
INSERT INTO gofENT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","ኤንታ ካሬ ኬሲዲ፥ «ታ ጎዳቶ፥ ታኒ ኣታናው ኣይ ኦꬃናው ቤሲ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","ጳዉሎሳራኔ ሲላሴራ ኢያኮ፥ «ጎዳ ዬሱስ ኪሪስቶሳ ኣማና፤ ኔራኔ ኔ ሶ ኣሳራ ኣታና» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","ኤንቲ ኢያሲኔ ኢያ ሶን ዴዒያ ኡባስ ጎዳ ቃላ ኦዲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","ቃማ ሄ ሳቴንካ ቃሾ ኬꬃ ናጌይሲ ኤንታ ኤፊዲ ኤንታ ማዱንꬃ ሜጪስ። ኤሌሲዲ ባ ሶ ኣሳ ኡባራ ፃማቄቲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","ጳዉሎሳኔ ሲላሴ ባ ሶ ኤፊዲ ኤንታው ካꬂ ኣꬂስ። ኢ ባ ሶ ኣሳ ኡባራ ፆሳ ኣማኒዳ ጊሾ ኡፋይቲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","ሳዓይ ዎንቲን ዳይናቲ፥ «ሄ ኣሳታ ቢላ» ያጊዲ ፖሊሴ ሃላቃታ ኢያኮ ኪቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","ቃሾ ኬꬃ ናጌይሲ፥ «ሂንቴ ቢሌታና ሜላ ዳይናቲ ኪቲዶሶና። ሂዛ፥ ኬዪዲ ሳሮ ቢቴ» ያጊዲ ሄ ኪታ ጳዉሎሳስ ኦዲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","ሺን ጳዉሎሲ ሄ ፖሊሴ ሃላቃታኮ፥ «ኑኒ ሮሜ ኣሲ ጊዲሺን ኤንቲ ኑና ፒርዲ ባይና ኣሳ ሲንꬃን ዋꬊዲ፥ ቃሾ ኬꬃን ዬጊዶሶና። ሃዒ ኑና ጌማን ኬዪዲ ቦ ጎና? ሃኔና፥ ኤንቲ ባንታ ሁዔን ዪዲ ኑና ኬሶ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","ፖሊሴ ሃላቃቲ ዳይናታስ ሄሳ ኦዲን፥ ጳዉሎሳራኔ ሲላሴራ ሮሜ ቢታ ኣሲ ጊዲዳይሳ ሲዒዳ ዎዴ ያዪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","ሄሳ ጊሾ፥ ዳይናቲ ዪዲ ኤንታኮ፥ «ኑኒ ሂንቴና ቆሂዳ» ጊዶሶና። ቃሾ ኬꬃፌ ካሬ ኤንታ ኬሲዲ፥ ካታማፔ ኬዪዲ ባና ሜላ ዎሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","ጳዉሎሳራኔ ሲላሴራ ቃሾ ኬꬃፌ ኬዪዲ ሊዲያ ሶ ቢዶሶና። ያን ኣማኔይሳታራ ጋሄቲዲ ኤንታ ሚንꬄꬂዲ ኬዪዲ ቢዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","ጳዉሎሳራኔ ሲላሴራ ኣምፊጶሊሳራኔ ኣጶሎኒያራ ኣꬊዲ ቴሴሎንቄ ቢዶሶና። ያን ኣይሁዴ ዎሳ ኬꬂ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","ጳዉሎሲ ካሴይሳዳ ያ ጌሊስ። ያን ሄꬑ ሳሚንታ ፆሳ ቃላፔ ኣሳስ ኦዲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","ኪሪስቶሲ ዋዬ ኤካናዉኔ ሃይቆፔ ዴንዳናው ቤሴይሳ ኤንታው ቆንጪሲዲ ኦዲሼ፥ «ዬሱሲ ሃ ታኒ ሂንቴው ኦዴይሲ ኪሪስቶሳ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","ኤንታፌ ኢሶቲ ኢሶቲ ኦዳይ ቱማ ጊዴይሳ ማዒዲ ጳዉሎሳራኔ ሲላሴራ ኢሲፊዶሶና። ሄሳዳካ፥ ፆሳ ጎይኒያ ዳሮ ጊሪኬ ኣሳይኔ ዳሮ ቦንቼቲዳ ማጫሳቲካ ኤንታራ ኢሲፊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","ሺን ኣይሁዴቲ ቃናቲዲ ኢሲ ኢሲ ኦሶይ ባይና ኢታ ኣሳታ ኦጌፔ ሺሺዶሶና። ካታማን ቡቄꬂ ኬሲዶሶና፤ ጳዉሎሳኔ ሲላሴ ኣሳስ ኣꬂ ኢማናው ኮዪዲ ያሶና ኬꬃ ቴቂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","ጳዉሎሲኔ ሲላሲ ኤንታው ቤንቶና ኢፂን፥ ያሶናኔ ኢሲ ኢሲ ኣማኔይሳታ ካታማ ሃላቃታኮ ጎቺ ኤፊዲ፥ «ሃይሳቲ ቢታ ኡባ ቡቄይሳቲ ሃዒ ኑኮ ዪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","ያሶኒ ኤንታ ባ ሶን ዎꬂስ። ሃይሳቲ፥ ‹ዬሱሳ ጊያ ሃራ ካዎይ ዴዔስ› ጊዲ ቄሳሬ ኪታ ሜንꬆሶና» ያጊዲ ꬎቁ ጊዳ ቃላን ኦዲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","ሺቂዳ ኣሳይኔ ካታማ ሃላቃቲ ሄሳ ሲዒዲ ሃናናባ ꬋዪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","ሃላቃቲ ያሶናኔ ሃራታ ዋሴን ቢርሺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","ኣማኔይሳቲ ጳዉሎሳኔ ሲላሴ ቃማራ ቤሪያ ዬዲዶሶና። ቤሪያ ጋኪዲ፥ ኣይሁዴ ዎሳ ኬꬂ ጌሊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","ቤሪያ ኣሳቲ ቴሴሎንቄ ኣሳታፔ ኣꬊዳ ሱሬታ። ኤንቲ ቃላ ኩሜꬃ ዎዛናፔ ኤኪዶሶና፤ ጳዉሎሲ ጊዳይሲ ቱማ ጊዴይሳ ሻኪ ኤራናው ጋላስ ጋላስ ጌሻ ማፃፋታ ፃናዖሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","ሄሳ ጊሾ፥ ኤንታፌ ዳሮቲ፥ ጊሪኬታፔካ ቦንቼቲዳ ዳሮ ማጫሳቲኔ ዳሮ ኣዴቲ ኣማኒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","ሺን ቴሴሎንቄን ዴዒያ ኣይሁዴቲ ጳዉሎሲ ፆሳ ቃላ ቤሪያንካ ኦዲዳይሳ ሲዒዳ ዎዴ ቤሪያ ዪዲ ኣሳ ቡቂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","ሄሳፌ ጉዬ፥ ኣማኔይሳቲ ኤሌሲዲ ጳዉሎሳ ኣባ ማቲ ዬዲዶሶና። ሺን ሲላሴይኔ ፂሞቲዮሲ ቤሪያን ኣቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","ጳዉሎሳ ሞይዚዳ ኣሳቲ ኣቴና ጋꬂዶሶና። ሄ ኣሳቲ ሲላሴይኔ ፂሞቲዮሲ ባንታው ዳንዳዔቲዳ ሜላ ኤሌሲዲ ባኮ ያና ሜላ ጳዉሎሲ ኪቲዳ ኪታ ኤኪዲ ቤሪያ ሲሚዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","ጳዉሎሲ ኣቴናን ሲላሴኔ ፂሞቲዮሳ ናጊሼ፥ ካታማን ኤቂ ኩሚዳይሳ ቤዒዲ ዪሎቲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","ሄሳ ጊሾ፥ ኣይሁዴ ዎሳ ኬꬃን ኣይሁዴታራኔ ፆሳ ጎይኒያ ኣይሁዴ ጊዶና ኣሳታራ ቃሲ ባራ ጋሄቲያ ኣሳታራ ኡባ ዎዴ ፓላሜስ። ");
INSERT INTO gofENT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","ኤጲቆሮሳኔ ኢስቶይኬ ጌቴቲያ ጩጋታፔ ኢሲ ኢሲ ኤራንቾቲ ጳዉሎሳራ ፓላሚዶሶና። ኤንታፌ ኢሶቲ ኢሶቲ፥ «ሃ ዮያማይ ኣይ ኦዳናው ኮዪ?» ያጊዶሶና። ሃራቲ ጳዉሎሲ ዬሱሳባኔ ሃይቆፔ ኢ ዴንዲዳይሳ ባንታው ኦዲዳ ጊሾ «ኦራꬃ ፆሳታባ ኦዲያ ዳኔስ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","ጳዉሎሳ ኦይኪዲ ኣርዮስፓጎሳ ጊያ ሺቆ ቤሳ ኤፊዲ፥ «ሃ ኔኒ ታማርሲያ ኦራꬃባይ ኣይቤኮ ኑና ኤሪሲኪ? ");
INSERT INTO gofENT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","ኣይስ ጊኮ፥ ኔኒ ኑስ ኦራꬃባ ኦዳሳ፤ ሂዛ ሄሲ ኣይቤኮ ኑኒ ኤራናው ኮዮስ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","ኣቴና ኣሳ ኡባይኔ ያን ዴዒያ ኢማꬃቲ ኦራꬃባ ኦዴቶናኔ ሲዖና ፔዖኮና። ");
INSERT INTO gofENT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","ጳዉሎሲ ኣርዮስፓጎሳን ሺቂዳ ኣሳ ሲንꬃን ኤቂዲ፥ «ኣቴና ኣሳው፥ ሂንቴ ፆሳታስ ኡባባን ዳሮ ያዬይሳ ታኒ ቤዓይስ። ");
INSERT INTO gofENT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","ታኒ ሂንቴ ካታማራ ዩያሼ ሂንቴ ጎይኒያ ቤሳታ ቤዒያ ዎዴ ‹ኤሬቶና ፆሳስ› ጌቴቲ ፃፌቲዳ ያርሾ ቤሳ ዴማስ። ሃ ሂንቴ ኤሮናሺን ጎይኔይሳ ታኒ ሂንቴው ኦዳይስ። ");
INSERT INTO gofENT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","ሳዓኔ ሳዓን ዴዒያ ኡባባ ሜꬊዳ ፆሳይ፥ ሳሉዋኔ ሳዓ ጎዳይ፥ ኣሲ ኬፂዳ ኬꬃን ዴና። ");
INSERT INTO gofENT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","ኢ ዴዖ፥ ሼምፖኔ ኡባባ ኣሳ ኡባስ ኢሚያ ጊሾ ፓጪ ዴዒያ ኣሳዳ ኣሳ ማዴ ኮዬና። ");
INSERT INTO gofENT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","ፆሳይ ኣሳ ዜሬꬂ ኡባ ኢሲ ኣዲያፌ ሜꬊዲ ቢታ ኡባን ዎꬂስ። ያቲዲ ኤንቲ ዴዓና ዎዲያሲኔ ቤሳስ ዛዋ ኢሚስ። ");
INSERT INTO gofENT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","ኢ ሄሳ ኦꬂዳይ ኣሲ ኢያ ኮያና ሜላኔ ፒልጊዲ ዴማና ሜላሳ። ሃኒኮካ ኢ ኑፔ ጌሚቤና። ");
INSERT INTO gofENT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","ሂንቴፌ ኢሲ ኢሲ ዬፄይሳቲ፥ ‹ኑኒ ኢያ ናይታ› ጊዳይሳዳ፥ ‹ኑኒ ኢያን ፓፃ ዴዖስ፥ ቃፆስ።› ");
INSERT INTO gofENT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","ሂዛ፥ ኑኒ ፆሳ ናይታ ጊዲያ ጊሾ ‹ፆሳይ ኣሳ ሂላቴꬃኒኔ ቆፋን ዎርቃፌ ዎይኮ ቢራፔ ዎይኮ ሹቻፌ ኦሴቲዳባ ዳኔስ› ያጊዲ ቆፓናው ቤሴና። ");
INSERT INTO gofENT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","ሄሳ ጊሾ፥ ፆሳይ ካሴ ዎዴ ኣሳይ ኤሮና ኦꬂዳይሳ ኣጊዲ ኣꬊስ፥ ሺን ሃዒ ኡባሶን ዴዒያ ኣሲ ኡባይ ናጋራፔ ሲማና ሜላ ኪቴስ። ");
INSERT INTO gofENT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","ኣይስ ጊኮ፥ ፆሳይ ባ ዶሪዳ ኣዲያን ሳዓን ዴዒያ ኣሳ ኡባ ቦላ ፂሎ ፒርዳ ፒርዳናው ቃማ ጊጊሲ ዎꬂስ። ኢያ ሃይቆፔ ዴንꬂዲ ሄሳ ኣሳ ኡባስ ቱማዪስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","ኤንታፌ ኢሲ ኢሲ ኣሳቲ ሃይቆፔ ዴንዶባ ጳዉሎሳፔ ሲዒዲ፥ ኢያ ቦላ ቄልቂሲዶሶና። ሺን ሃራቲ፥ «ኑኒ ሄሳ ኔፔ ጉጂዲ ሲዓናው ኮዮስ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","ሄሳ ጊሾ፥ ጳዉሎሲ ኤንታ ጊዶፌ ኬዪስ። ");
INSERT INTO gofENT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","ሺን ኢሲ ኢሲ ኣዴቲ ጳዉሎሳራ ጋሄቲዲ ኣማኒዶሶና። ኤንታ ጊዶፌ ኣርዮስፓጎሳን ሺቁዋን ዴዒያ ዲዮናስዮሳ ጊያ ኣዴይ፥ ዳማርሶ ጊያ ኢሲ ማጫሲያኔ ሃራቲ ዴዖሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","ሄሳፌ ጉዬ፥ ጳዉሎሲ ኣቴናፔ ኬዪዲ፥ ቆሮንቶሳ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","ያን ኣቂላ ጊያ ጳንፆሳን ዬሌቲዳ ኢሲ ኣይሁዴ ኣሲ ዴሚስ። ኣይሁዴ ኣሳ ኡባይ ሮሜፔ ኬያና ሜላ ካዎይ ቃላዉዲዮሲ ኪቲዳ ጊሾ ጉꬃ ዎዴፔ ካሴ ኢ ባ ማቼ ጲሪስቂላራ ፃሌፔ ዪስ። ጳዉሎሲ ኤንታራ ጋሄታናው ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","ኢያ ኦሶይ ኤንታይሳዳ ዱንካኔ ሲኮ ጊዲያ ጊሾ ኤንታራ ኡቲዲ ኢሲፌ ኦꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","ጳዉሎሲ ሳምባታ ኡባን ኣይሁዴታኔ ጊሪኬታ ኣማንꬃናው ኣይሁዴ ዎሳ ኬꬃን ፓላሜስ። ");
INSERT INTO gofENT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","ሲላሴይኔ ፂሞቲዮሲ ማቄዶኒያፔ ዪዳ ዎዴ ጳዉሎሲ ባ ኩሜꬃ ዎዲያ ኢሚዲ ኣይሁዴታስ ዬሱሲ ኢ፥ ኪሪስቶሳ ጊዲ ቃላ ኦዲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","ሺን ኤንቲ ጳዉሎሳ ኢፂዲ ኢያ ጫዪን ጳዉሎሲ ባ ማዑዋፔ ባና ቆቆፊሼ፥ «ሂንቴ ጎሜይ ሂንቴና ኦይኮ፤ ታኒ ሄሳን ዴዒኬ። ሂዛፔ ጉዬ፥ ታኒ ኣይሁዴ ጊዶና ኣሳኮ ባይስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","ያፔ ኬዪዲ ፆሳ ጎይኒያ ቲቶስ ዮስፆሳ ጊያ ኡራ ሶ ቢስ። ዮስፆሳ ኬꬃይ ኣይሁዴ ዎሳ ኬꬃ ማታን ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","ኣይሁዴ ዎሳ ኬꬃ ሃላቃይ ቃሪስጶሲ ባ ሶ ኣሳ ኡባራ ጎዳ ኣማኒስ። ቆሮንቶሳ ኣሳታፔካ ዳሮቲ ፆሳ ቃላ ሲዒዳ ዎዴ ኣማኒዲ ፃማቄቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","ጎዳይ ኢሲ ቃማ ጳዉሎሳስ ቆንጪዲ፥ «ያዮፋ፤ ኦዳ፥ ሲዒ ጎፓ። ");
INSERT INTO gofENT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","ታኒ ኔራ ዴዓይስ። ታው ሃ ካታማን ዳሮ ኣሲ ዴዒያ ጊሾ ኔና ቆሂዲ ኢታባን ዬጋና ኣሲ ኦኒካ ባዋ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","ሄሳ ጊሾ፥ ጳዉሎሲ ፆሳ ቃላ ኣሳ ታማርሲሼ ኢሲ ላይꬂኔ ኡሱፑን ኣጌና ኤንታራ ኡቲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","ጋሊዮሲ ኣካያ ቢታ ኣይሲያ ዎዴ ኣይሁዴቲ ኢሲፌ ጳዉሎሳ ቦላ ዴንዲዲ ፒርዳ ኬꬂ ኢያ ኤፊዲ፥ ");
INSERT INTO gofENT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","«ሃ ኣዴይ ሂጊያ ኢፂዲ፥ ኣሳይ ፆሳ ጎይናና ሜላ ኦꬄስ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","ጳዉሎሲ ሃሳያና ሃኒሺን፥ ጋሊዮሲ ኣይሁዴታኮ፥ «ኣይሁዴቶ፥ ሄሲ ኢታ ኦሶ ዎይኮ ናቆ ጊዲያኮ ታኒ ሂንቴባ ዳንዳዓዳ ሲዓናው ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","ሺን ቃላስ፥ ሱንꬃሲኔ ሂንቴ ሂጊያስ ሂንቴ ፓላሚያባ ጊዲኮ ሂንቴ፥ ሂንቴው ቢሊቴ፤ ሄሳ ታኒ ፒርዲኬ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","ያቲዲ፥ ኤንታ ፒርዳ ኬꬃፌ ካሬ ኬሲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","ሄሳፌ ጉዬ፥ ጊሪኬ ኣሳ ኡባይ ኣይሁዴ ዎሳ ኬꬃ ሃላቃ ሶስቴኒሳ ኦይኪዲ ፒርዳ ኬꬃ ሲንꬃን ዋꬊዶሶና። ሺን ጋሊዮሲ ሄሳ ፓፃባ ጊቤና። ");
INSERT INTO gofENT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","ጳዉሎሲ ዳሮ ጋላስ ቆሮንቶሳን ኡቲዳፔ ጉዬ ኣማኒያ ኣሳ ሳሮꬂዲ፥ ጲሪስቂሊራኔ ኣቂላራ ማርካቤራ ሶሪያ ቢስ። ሺን ኢ ባናፔ ሲንꬄ ባው ጋሶይ ዴዒያ ጊሾ ኪንኪሪያ ካታማን ባ ሁዒያ ቡሉሴቲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","ኤንቲ ኤፌሶና ጋኪዳ ዎዴ ጳዉሎሲ ጲሪስቂሎኔ ኣቂላ ያን ኣጊስ። ሺን ባው ኣይሁዴ ዎሳ ኬꬂ ጌሊዲ ኣይሁዴታራ ኦዴቲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","ኤንቲ ባንታራ ዳሮ ዎዴ ኡታና ሜላ ጳዉሎሳ ዎሲዶሶና ሺን ኢ ኢፂስ። ");
INSERT INTO gofENT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","ኤንታፌ ሻኬቲሼ፥ «ታኒ ያ ባሊያ ዬሩሳላሜን ቦንቻናው ቤሴስ። ሺን ፆሲ ጊኮ ሂንቴኮ ሲማዳ ያና» ያጊዲ ኤፌሶናፔ ማርካቤራ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","ቂሳሪያ ጋኪዳ ዎዴ ዬሩሳላሜ ቢዲ ዎሳ ኬꬃ ኣሳ ሳሮꬂዳፔ ጉዬ ኣንፆኪያ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","ያን ጉꬃ ዎዴ ጋምዒዳፔ ጉዬ ኣማኒያ ኣሳታ ኡባ ሚንꬄꬂሼ ጋላቲያራኔ ጲርጌራ ኣꬊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","ኢስኪንዲሪያን ዬሌቲዳ ኢሲ ኣጲሎሳ ጊያ ኣይሁዴ ኣሲ ኤፌሶና ቢስ። ኢ ኦዳ ኤሪያ ኣሲኔ ፆሳ ቃላ ዳሮ ኤሪያ ኣሲ። ");
INSERT INTO gofENT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","ኢ ጎዳ ኦጊያ ታማሪዲ፥ ኣያናን ፁጌቲዲ ዬሱሳባ ሱሬ ታማርሴስ። ጊዶሺን፥ ዮሃኒሳ ፂንቃቲያ ፃላላ ኤሬስ። ");
INSERT INTO gofENT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","ኢ ኣይሁዴ ዎሳ ኬꬃን ያዮና ታማርሴስ። ጲሪስቂሊኔ ኣቂሊ ኢ ኦዴይሳ ሲዒዳ ዎዴ ኢያ ባንታራ ሶ ኤፊዲ ፆሳ ኦጊያ ካሴይሳፌ ጌሺዲ ኢያው ኦዲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","ኣጲሎሲ ኣካያ ባናው ኮዪን ኤፌሶናን ዴዒያ ኣማኒያ ኣሳይ ኢያ ቆፋ ኤኪዲ ኣካያን ዴዒያ ኣማኔይሳቲ ኢያ ሞካና ሜላ ኤንታው ዳብዳቤ ፃፊዶሶና። ኢ ያ ጋኪዳ ዎዴ ፆሳ ኣꬎ ኬሃቴꬃ ባጋራ ዬሱስ ኪሪስቶሳ ኣማኒዳይሳታ ዳሮ ማዲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","ኣይስ ጊኮ፥ ዬሱሲ ኢ ኪሪስቶሳ ጊዴይሳ ኣይሁዴታስ ፆሳ ቃላፔ ቆንጪሲዲ ዴሪያ ሲንꬃን ሚንꬂ ኦዲዲ ኤንታ ላꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","ኣጲሎሲ ቆሮንቶሳን ዴዒሺን፥ ጳዉሎሲ ቆሞ ባጋራ ኣꬊዲ ኤፌሶና ቢስ። ያን ኢሲ ኢሲ ኣማኒያ ኣሳታ ዴሚስ። ");
INSERT INTO gofENT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","ኤንታኮ፥ «ሂንቴ ኣማኒዳ ዎዴ ጌሻ ኣያና ኤኪዴቲ?» ያጊዲ ኦይቺስ። ኤንቲ፥ «ኣካይ፥ ኤኪቦኮ፤ ሃሪ ኣቶሺን፥ ጌሻ ኣያኒ ዴዒያባካ ሲዒቦኮ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","ጳዉሎሲ ኤንታኮ፥ «ያቲን፥ ኣይቢን ፃማቄቲዴቲ?» ያጊስ። ኤንቲ፥ «ኑኒ ዮሃኒሳ ፂንቃቲያን ፃማቄቲዳ» ያጊዲ ዛሪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","ጳዉሎሲ፥ «ዮሃኒሲ ባፔ ጉዬራ ያ ዬሱስ ኪሪስቶሳን ኣሳይ ኣማናና ሜላ ኣሳስ ኦዲሼ፥ ናጋራፔ ሲሞ ቤሲያ ፂንቃቲያን ፃማቂስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","ኤንቲ ሄሳ ሲዒዳ ዎዴ ጎዳ ዬሱስ ኪሪስቶሳ ታማሬ ጊዳናው ፃማቄቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","ጳዉሎሲ ባ ኩሺያ ኤንታ ቦላ ዎꬂዳ ዎዴ ጌሻ ኣያኒ ኤንታ ቦላ ዎꬊን፥ ዱማ ዱማ ዶናን ኦዴቲዶሶና፤ ቃሲ ቲንቢቴ ኦዲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","ሄ ቤሳን ታማኔ ናምዓ ጊዲያ ኣሳቲ ዴዖሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","ጳዉሎሲ ኣይሁዴ ዎሳ ኬꬃ ጌሊዲ፥ ፆሳ ካዎቴꬃባ ያዮና ፓላሚሼኔ ሎይꬂ ቆንጪሲሼ ኤንታራ ሄꬑ ኣጌና ጋካናው ጋምዒስ። ");
INSERT INTO gofENT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","ሺን ኤንታፌ ኢሶቲ ኢሶቲ ꬉቤ ጊዲዲ ዳሮ ኣሳ ሲንꬃን ጎዳ ኦጊያ ጫዪዲ ኣማኖና ኢፂዶሶና። ጳዉሎሲ ኣማኔይሳታ ኤንታፌ ሻኪ ኤኪዲ ፂራኖሳ ጊያ ቲሚርቴ ኬꬃን ኡባ ዎዴ ኤንታ ታማርሲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","ጳዉሎሲ ናምዑ ላይꬂ ጋካናው ቃላ ኦዲስ። ሄሳ ጊሾ፥ ኢሲያን ዴዒያ ኣሳ ኡባይ፥ ኣይሁዴቲኔ ኣይሁዴ ጊዶናይሳቲ ጎዳ ቃላ ሲዒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","ፆሳይ ጳዉሎሳ ኩሼን ዎልቃማ ማላታታ ኦꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","ሄሳ ጊሾ፥ ኣሳይ ኢያ ቦላ ቦቺዳ ማራቢያ ዎይኮ ማዑዋ ሃርጋንቾታስ ኤፎሶና። ኤንቲካ ፓፆሶና፤ ቱና ኣያናቲካ ኤንታፌ ኬዮሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","ቱና ኣያናታ ኬሲሼ ዩያ ኣይሁዴታፔ ኢሶቲ ኢሶቲ፥ «ጳዉሎሲ ሳባኪያ ዬሱሳ ሱንꬃን ኬዪቴ ጊዲ ሂንቴና ኪቶስ» ያጊዲ፥ ቱና ኣያናቲ ኦይኪዳ ኣሳታ ቦላ ጎዳ ዬሱሳ ሱንꬃ ፄጊዶሶና ");
INSERT INTO gofENT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","ካሂኔ ሃላቃ ኣስቄዌ ጊያ ኢሲ ኣይሁዴ ኣዲያስ ሄሳ ኦꬂያ ላፑን ናይቲ ዴዖሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","ሺን ቱና ኣያናይ ኤንታኮ፥ «ታኒ ዬሱሳካ ጳዉሎሳካ ኤራይስ፥ ሺን ሂንቴ ኦናንቴ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","ቱና ኣያናይ ኦይኪዳ ኣዴይ ኤንታ ቦላ ጉፒ ዎꬊዲ፥ ኤንታ ማዱንፂሲዲ፥ ሄ ኬꬃፌ ካሎ ባቃታና ጋካናው ዎልቃሚስ። ");
INSERT INTO gofENT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","ኤፌሶናን ዴዒያ ኣይሁዴቲኔ ኣይሁዴ ጊዶናይሳቲ ኡባይ ሄሳ ሲዒዲ ዳሮ ያዪዶሶና። ጎዳ ዬሱሳ ሱንꬃይ ዳሮ ቦንቼቲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","ኣማኔይሳታፔ ዳሮቲ ባንታ ኦꬂዳ ኢታ ኦሱዋ ፓፂሼኔ ቆንጬን ኦዲሼ ዮሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","ቢቴይሳታፔ ዳሮቲ ባንታ ማፃፋታ ሺሺዲ ኣሳ ኡባ ሲንꬃን ፁጊዶሶና። ሄ ማፃፋታ ጋቲያ ቆዳይ ኢሻታሙ ሙኩሉ ቢራ ሳንቲሜ ጊዲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","ሄሳዳ ሃኒዲ ፆሳ ቃላይ ዲጪሼኔ ዳልጊሼ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","ሄሲ ፖሌቲዳፔ ጉዬ ጳዉሎሲ፥ «ታኒ ዬሩሳላሜ ባ ሲማዳ ሮሜካ ባናው ቤሴስ» ያጊዲ ማቄዶኒያራኔ ኣካያራ ኣꬊዲ ዬሩሳላሜ ባናው ቆፋ ቃቺስ። ");
INSERT INTO gofENT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","ቃሲ ባና ማዴይሳታፔ ናምዓታ ፂሞቲዮሳኔ ኤራስፆሳ ማቄዶኒያ ኪቲዲ፥ ባው ኢሲያን ጉꬃ ዎዴ ጋምዒስ። ");
INSERT INTO gofENT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","ሄ ዎዴ ጎዳ ኦጊያ ጊሾ ኤፌሶናን ዎልቃማ ካቺ ኬዪስ። ");
INSERT INTO gofENT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","ኢሲ ቢራ ኦꬂያ ዲሜፂሮሳ ጊያ ኡራይ ኣርፄሚሲ ኤቃ ኬꬃ ሚሲሊያ ቢራፔ ኦꬂዲ ዳሮ ዎꬌ ዴሜስ። ");
INSERT INTO gofENT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","ሄሳ ጊሾ፥ ሄሳ ሜላ ኦሶ ኦꬄይሳታ ኢሲፌ ሺሺዲ፥ «ኣሳው፥ ኑ ዱሬቴꬃይ ሃ ኦሱዋን ጊዴይሳ ሂንቴ ኤሬታ። ");
INSERT INTO gofENT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","ሃይሲ ጳዉሎሲ፥ ‹ኣሳ ኩሼን ኦሴቲዳይሳቲ ፆሳታ ጊዶኮና› ያጊዲ፥ ኤፌሶናኒኔ ጉꬃ ቢታታፔ ኣቲን ኩሜꬃ ኢሲያ ኡባን ዴዒያ ዳሮ ኣሳ ኦዲ ኣማንꬂዳይሳኔ ባሌꬂዳይሳ ሂንቴ ቤዒዴታኔ ሲዒዴታ። ");
INSERT INTO gofENT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","ሜቶ ጊዲዳይ፥ ኑ ኦሶይ ካꬌቴይሳ ፃላላ ጊዶናሺን ኢሲያኒኔ ቢታ ኡባን ዴዒያ ኣሲ ጎይኒያ ጊታ ፆሴ ኣርፄሚሲ ኬꬃይ ቦንቼቶና ኣቴይሳኔ ኢ ጊታቴꬃይካ ኩንዳናይሳ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","ኣሳይ ሄሳ ሲዒዳ ዎዴ ሼኔን ፁጌቲዲ፥ «ኤፌሶና ኣርፄሚሳ ጊታ» ያጊዲ ዋሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","ሄ ዋሶይ ካታማ ኡባ ጋኪስ። ጳዉሎሳራ ሃሙቲያ ማቄዶኒያ ኣሳታ፥ ጋዮሳኔ ኣርስፂሮኮሳ ኦይኪዲ ጎቺሼ ካሳ ቤሳ ዎፂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","ጳዉሎሲካ ኣሳይ ሺቂዳሱዋ ጌላናው ኮዪስ፥ ሺን ኣማኔይሳቲ ኢያ ዲጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","ኢሲያ ቢታ ሃላቃታፔ ጳዉሎሳ ላጌ ጊዲዳ ኢሶቲ ኢሶቲ ጳዉሎሳኮ ኪቲዲ፥ «ካሳ ቤሳ ቆንጬን ኬያዳ ቤንቶፋ» ጊዲ ኢያ ዎሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","ሺቂዳ ኣሳስ ሃናናባይ ꬋይስ፤ ዳሪያ ባጋ ኣሳይ ሃሪ ኣቶሺን ኣይስ ሺቂዳኮ ኤሮና ጊሾ ኢሶይ ኢሲባስ ዋሲያ ዎዴ ሃንኮይ ሃራባስ ዋሴስ። ");
INSERT INTO gofENT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","ኣይሁዴቲ ኢስኪንዲሬ ጊያ ኣዲያ ኣꬂ ቤሲን፥ ኢሲ ኢሲ ኣሳይ ኢ ጋናባ ኦዲዲ ኢያ ሲንꬄ ኣꬂዶሶና። ኢ ኣሳይ ሲዒ ጋና ሜላ ባ ኩሺያን ማሊ ቤሲዲ፥ ኣሳስ ሞቴታናው ኤቂስ። ");
INSERT INTO gofENT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","ሺን ኢስኪንዲሬይ ኣይሁዴ ኣሲ ጊዲዳይሳ ኣሳይ ኤሪዳ ዎዴ ናምዑ ሳቴ ጊዳናይሳ ሜላ ኡባይ ኢሲ ቃላን፥ «ኤፌሶና ኣርፄሚሳ ጊታ» ያጊዲ ዋሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","ዉርሴꬃን ካታማ ፃፌይ ኣሳ ሲዒ ኦꬂዲ፥ «ኤፌሶና ኣሳው! ኤፌሶና ካታማይ ጊታ ኣርፄሚሲ ኤቃ ኬꬃኔ ሳሎፔ ዎꬊዳ፥ ኢ ሹቻ ሚሲሊያ ናጌይሳ ጊዴይሳ ኤሮና ኣሲ ባዋ። ");
INSERT INTO gofENT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","ሃይሳ ካሺ ጊያ ኣሲ ባይና ጊሾ ሂንቴ ሲዒ ጋናዉኔ ዲርጊዲ ኣይኮ ኦꬆና ኣጋናው ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","ሂንቴ ሃ ኣሳታ፥ ኤቃ ኬꬃ ሚሼ ካይሶቲቦናይሳታኔ ኑ ፆሳታ ጫይቦናይሳታ ኤሂዴታ። ");
INSERT INTO gofENT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","ሄሳ ጊሾ፥ ዲሜፂሮሲኔ ኢያራ ዴዒያ ኦሳንቾቲ ኣሳ ሞታናው ኮይኮ፥ ፒርዳ ኬꬃይ ዶያ ዴዔስ፤ ዳይናቲካ ዴዖሶና፤ ኤንቲ ሞታናው ዳንዳዖሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","ሺን ሂንቴ ሃራ ኦዳ ኮይኮ፥ ሻንጎ ሺቆን ኦዳይ ቤዔቶ። ");
INSERT INTO gofENT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","ሄሳ ጊዶና ኢፂኮ ሃቺ ሃኒዳባስ ሮሜ ካዎቴꬃይ ኑና ኦይቻና። ሃ ቡቄꬃስ ጋሶይ ባይና ጊሾ ኑኒ ጋሶ ኦዳናው ዳንዳዖኮ» ");
INSERT INTO gofENT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","ያጊዲ ሺቁዋ ላሊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","ዋሶይ ዴጪዳፔ ጉዬ ጳዉሎሲ ኣማኒያ ኣሳታ ፄጊሲዲ ኤንታ ዞሪዳፔ ጉዬ ሳሮꬂዲ ማቄዶኒያ ባናው ኬዪስ። ");
INSERT INTO gofENT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","ኢ ኣꬊያ ቢታታን ዴዒያ ኣማኒያ ኣሳ ቃላ ኦዲዲ ሚንꬄꬂዳፔ ጉዬ ጊሪኬ ቢታ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","ኢ ያን ሄꬑ ኣጌና ኡቲዲ፥ ማርካቤራ ሶሪያ ባናው ቆፒዲ ዴዒሺን፥ ኣይሁዴቲ ባና ዎꬋናው ኮዬይሳ ኤሪዲ ማቄዶኒያራ ጉዬ ሲማናው ኮዪስ። ");
INSERT INTO gofENT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","ጳዉሎሳ ሞይዚዳይሳቲ ቤሪያፔ ጳርሁሳ ናዓ ሶጳፂሮሳ፥ ቴሴሎንቄፌ ኣርስፂሮኮሳኔ ሲኮንዱሳ፥ ዴርቤፌ ጋዮሳ፥ ኢሲያፔ ቲኪቆሳ፥ ፂሮፊሞሳኔ ፂሞቲዮሳ። ");
INSERT INTO gofENT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","ሄሳቲ ሲንꬄ ቢዲ ኑና ፂሮዓዳን ናጎሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","ኑኒ ኡይꬃ ባሊያ ቦንቺዳፔ ጉዬ ፊልጲሲዩሳፔ ማርካቤራ ዴንዲዲ፥ ኢቻሻንꬆ ጋላሳን ኤንታ ፂሮዓዳን ጋኪዲ ያን ላፑን ጋላስ ጋምዒዳ። ");
INSERT INTO gofENT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","ሳሚንታፌ ኮይሮ ጋላሳን ኑኒ ኡይꬃ ሜንꬃናው ሺቂዲ ዴዒሺን፥ ጳዉሎሲ ዎንቴꬄ ባናው ቆፒዳ ጊሾ ኤንታው ቃላ ኦዲሼ ጊዲ ቢላሄ ጋካናው ኦዳ ኣዱሲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","ኑኒ ሺቂዲ ኡቲዳ ፖቂያን ዳሮ ፖዖይ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","ኤዉፂኮሳ ጊያ ኢሲ ናዓቴꬃይ ማስኮቴ ቦላ ኡቲዲ፥ ባና ዶጊዲ ꬊስኪስ። ጳዉሎሲ ኦዳ ኣዱሲዳ ዎዴ ኤዉፂኮሲ ꬊስኮ ኤዪዲ ሄꬓንꬆ ፖቂያፔ ኩንዲዲ ሃይቂዳይሳ ኣሳይ ዴንꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","ሺን ጳዉሎሲ ዎꬊዲ፥ ኢያ ቦላ ጉፋኒስ። ኢያ ኢዲሚዲ፥ «ኢ ሃይቂቤና፥ ሂርጎፊቴ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","ሄሳፌ ጉዬ፥ ፑዴ ፖቂያ ቦላ ኬዪዲ ኡይꬃ ሜንꬂዲ ሚስ። ሳዒ ዎንታና ጋካናው ኣሳስ ኦዲዳፔ ጉዬ ዴንዲዲ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","ሄ ፓፂዳ ናቴꬃ ሶ ኤፊዲ ዳሮ ኡፋይቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","ሺን ጳዉሎሲ ባና ያፔ ሞካና ሜላ ኑስ ኦዲዳ ጊሾ ካሴቲዲ ማርካቢያኮ ቢዲ፥ ኣሶሳ ባናው ዴንዲዳ። ኣይስ ጊኮ፥ ኢ ቶሆን ባናው ቆፒዳ ጊሾ ኑና ሄሳꬆ ኪቲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","ኢ ኑራ ኣሶሳን ጋሄቲን ማርካቢያን ኢያ ኤኪዲ ሚፂሊኔ ቢዳ። ");
INSERT INTO gofENT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","ዎንቴꬃ ጋላስ ያፔ ዴንዲዲ ማርካቤራ ኪዮሳ ሲንꬄን ዴዒያ ቤሳ ጋኪዳ፤ ቃሲ ዎንቴꬃ ጋላስ ሳሞሳ ፒኒዲ ካሊያ ጋላስ ሚሊፄ ጋኪዳ። ");
INSERT INTO gofENT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","ጳዉሎሲ ኢሲያን ዳሮ ጋምዖና ኤፌሶና ማታራ ኣꬋናው ቆፒስ። ባው ዳንዳዔቲኮ ጴንፄቆስፄ ባሊያ ጋላስ ዬሩሳላሜ ጋካናው ኤሶቴስ። ");
INSERT INTO gofENT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","ጳዉሎሲ ሚሊፄፔ ኤፌሶና ኪቲዲ ዎሳ ኬꬃ ጪማታ ፄጊሲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","ዎሳ ኬꬃ ጪማቲ ኢያኮ ዪን፥ ኤንታኮ ሃይሳዳ ያጊስ፡ «ታኒ ኢሲያ ጌሊዳ ኮይሮ ጋላሳፔ ዶሚዳ ሂንቴራ ዴዒዳ ዎዴ ኡባን ዋና ዴዒዳኮ ሂንቴ ኤሬታ። ");
INSERT INTO gofENT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","ኣይሁዴቲ ዱላቲዲ ታ ቦላ ሜቶ ጋꬂኮካ ታኒ ኣሽኬቴꬃኒኔ ዳሮ ኣፉꬃን ጎዳስ ኦꬃስ። ");
INSERT INTO gofENT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","ዳባባንካ ሂንቴ ኬꬃን ኬꬃን ሂንቴና ታማርሲሼ ሂንቴና ማዲያባፔ ኢሲባካ ፓጪሳቢኬ። ");
INSERT INTO gofENT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","ታኒ ኣይሁዴታሲኔ ኣይሁዴ ጊዶናይሳታስ ናጋራፔ ፆሳኮ ሲማና ሜላኔ ኑ ጎዳ ዬሱሳ ኣማናና ሜላ ማርካታስ። ");
INSERT INTO gofENT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","«ያን ታና ኣይቢ ጋካኔኮ ኤሪኬ፥ ሺን ሃዒ ታኒ ጌሻ ኣያናስ ኪቴታዳ ዬሩሳላሜ ባይስ። ");
INSERT INTO gofENT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","ጌሻ ኣያናይ ቃሾይኔ ዋዬይ ታና ናጌይሳ ካታማ ኡባን ታው ማርካቲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","ሺን ታ ዎꬃ ፖላናዉኔ ጎዳ ዬሱስ ኪሪስቶሳፔ ኤኪዳ ኦሱዋ፥ ፆሳ ኣꬎ ኬሃቴꬃ ዎንጌላ ማርካቴይሳ ፖላናው ታ ሼምፒው ፓꬆናባዳ ቆዳይስ። ");
INSERT INTO gofENT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","«ታኒ ሃዒካ ፆሳ ካዎቴꬃ ማርካታሼ ሂንቴ ኡባ ጊዶን ዩያስ። ሂዛፔ ጉዬ ሂንቴፌ ኦኒካ ታና ቤዖናይሳ ኤራይስ። ");
INSERT INTO gofENT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","ሄሳ ጊሾ፥ ሂንቴፌ ኢሲ ኡራይ ꬋዪኮካ ታ ኦይሼቶናይሳ ሃቺ ሂንቴው ጌሻዳ ኦዳይስ። ");
INSERT INTO gofENT_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","ኣይስ ጊኮ፥ ፆሳይ ኦꬃናው ቆፒዳባ ኡባ ሂንቴው ኣይቢባካ ኣሾና ኦዳስ። ");
INSERT INTO gofENT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","«ባ ናዓ ሱꬃን ዎዚዳ ፆሳ ዎሳ ኬꬃ ናጊቴ። ጌሻ ኣያናይ ሂንቴና ሃላቃ ኦꬂዲ ዶሪዳ ዉዲያሲኔ ሂንቴ ሁዒያስ ናጌቲቴ። ");
INSERT INTO gofENT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","ታኒ ቢዳፔ ጉዬ፥ ዉዲያስ ቃꬌቶና ኢታ ሱꬉሜቲ ሂንቴ ጊዶ ጌላናይሳ ታ ኤራይስ። ");
INSERT INTO gofENT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","ኣማኔይሳታ ባንታ ጌዶ ካሌꬃናው ዎርዶ ታማርሲያ ኣሳቲ ሂንቴ ጊዶፌ ዴንዳና። ");
INSERT INTO gofENT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","ሄሳ ጊሾ፥ ታኒ ሄꬑ ላይꬂ ቃማኔ ጋላስ ኣፉꬃን ሂንቴና ሁዔን ሁዔን ሚንꬄꬂዳይሳ ቆፒሼ ናጌቲቴ። ");
INSERT INTO gofENT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","«ሃዒካ ሂንቴና ሚንꬃናዉኔ ጌሻ ኣሳራ ላቲሳናው ዳንዳዒያ ፆሳሲኔ ኢያ ኣꬎ ኬሃቴꬃ ቃላስ ሂንቴና ሃዳራ ኢማይስ። ");
INSERT INTO gofENT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","«ታኒ ኦፔካ ቢራ ዎይኮ ዎርቃ ዎይኮ ኣፊላ ኣሞታቢኬ። ");
INSERT INTO gofENT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","ታኒ ታ ኩሼን ኦꬃዳ ታናኔ ታራ ዴዔይሳታ ኮሺዳባ ማዲዳይሳ ሂንቴ፥ ሂንቴ ሁዔን ኤሬታ። ");
INSERT INTO gofENT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","ሂንቴ ሃይሳዳ ዳቡሪዲ ኦꬂሼ ዳቡራንቾታ ማዳናይሳኔ ጎዳ ዬሱሲ፥ ‹ኤኬይሳፌ ኢሜይሲ ኣንጄቲዳይሳ› ጊዳ ቃላ ሂንቴ ቆፓናው ቤሴይሳ ታኒ ሂንቴና ኡባባን ቤሳስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","ጳዉሎሲ ሄሳ ኦዲ ኦንጊዲ ኤንታ ኡባራ ጉልባቲዲ ፆሳ ዎሲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","ኤንቲ ኡባይካ ጳዉሎሳ ኢዲሚዲ ዬኪዲ ዬሪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","ኢ ዛሪዲ፥ «ታና ቤዔኬታ» ያጊዳ ቃላይ ኤንታ ዳሮ ኣዛንꬂስ። ኤንቲ ማርካቢያ ጋካናው ኢያ ሞይዚዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","ኑኒ ኤፌሶና ጪማታፔ ሻኬቲዳ ሜላ ቆሴ ቢዳ። ዎንቴꬃ ጋላስ ሮዳ ጋኪዲ ያፔ ጳፃራ ቢዳ። ");
INSERT INTO gofENT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","ሲሮፊንቄ ፒኒያ ማርካቤ ዴሚዲ ኢያን ጌሊዲ ባናው ዴንዲዳ። ");
INSERT INTO gofENT_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","ኑኒ ቆጲሮሳ ቤዓናው ዳንዳዒያ ሶ ዪዲ፥ ቆጲሮሳ ሃዲርሳ ባጋ ኣጊዲ ሶሪያ ቢዳ። ማርካቤይ ባ ጫና ያን ዎꬃናው ኮዪዳ ጊሾ ፂሮሳ ቢዳ። ");
INSERT INTO gofENT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","ያን ኣማኒያ ኣሳታ ዴሚዲ ኤንታራ ላፑን ጋላስ ኡቲዳ። ጳዉሎሲ ዬሩሳላሜ ቦና ሜላ ኤንቲ ኢያው ኣያናን ኦዲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","ኑኒ ኤንታራ ኡቲያ ዎዴይ ዉሪን ኬዪዲ ቢዳ። ኤንቲ ኡባይ ባንታ ማጫሳታራኔ ባንታ ናይታራ ኢሲፌ ካታማፔ ካሬ ኬሲዲ ኑና ሞይዚዶሶና። ኑኒ ኣባ ዶናን ጉልባቲዲ ፆሳ ዎሲዳ። ");
INSERT INTO gofENT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","ሄሳፌ ጉዬ፥ ዎሊ ሳሮꬂዲ ኑ ማርካቢያን ጌሊዳ፤ ኤንቲ ባንታ ሶ ሲሚዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","ኑኒ ኣባ ኦጊያ ኦንጊዲ፥ ፂሮሳፔ ጴፄሌማይሳ ጋኪዳ። ያን ኣማኒያ ኣሳታ ሳሮꬂዲ፥ ኤንታ ማታን ኢሲ ጋላስ ፔዒዳ። ");
INSERT INTO gofENT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","ዎንቴꬃ ጋላስ ኬዪዲ፥ ቂሳሪያ ቢዳ። ሳባኪያ ፊልጶሳ ሶ ጋኪዲ ኢያ ማታን ኡቲዳ። ኢ ዬሩሳላሜን ካሴ ዶሬቲዳ ላፑናታፔ ኢሱዋ። ");
INSERT INTO gofENT_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","ፊልጶሳስ ናቤ ጊዲዳ ኦይዱ ጌላዖ ናይቲ ዴዖሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","ኑኒ ኡንዴና ጋላስ ያን ኡቲዲ ዴዒሺን ኣጋቦሳ ጊያ ናቤይ ዪሁዳፔ ቂሳሪያ ዪስ። ");
INSERT INTO gofENT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","ኑኮ ዪዲ ጳዉሎሳ ሳቂያ ኤኪዲ ባ ኩሺያኔ ባ ቶሁዋ ቃቺዲ፥ «ጌሻ ኣያናይ ሃ ሳቂያ ጎዳ፥ ዬሩሳላሜን ኣይሁዴቲ ሃይሳዳ ቃቺዲ፥ ኣይሁዴ ጊዶና ኣሳስ ኣꬂዲ ኢማና ያጌስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","ኑኒ ሄሳ ሲዒዳ ዎዴ ኑኔ ያን ዴዒያ ኣሳቲ ጳዉሎሲ ዬሩሳላሜ ቦና ሜላ ዎሲዳ። ");
INSERT INTO gofENT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","ሺን ጳዉሎሲ ዛሪዲ፥ «ሂንቴ ሃይሳዳ ዬኪሼ ኣይስ ታ ዎዛና ሹጊሴቲ? ታኒ፥ ጎዳ ዬሱሳ ሱንꬃ ጊሾ ቃሼቴꬃ ፃላላ ጊዶናሺን ዬሩሳላሜን ሃይቃናዉካ ጊጌታስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","ኑ ዞሪያ ኢ ኤኮና ኢፂን፥ «ጎዳ ሼኔይ ሃኖ» ያጊዲ ሲዒ ጊዳ። ");
INSERT INTO gofENT_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","ያን ጉꬃ ዎዴ ጋምዒዳፔ ጉዬ ጊጌቲዲ ዬሩሳላሜ ባናው ኬዪዳ። ");
INSERT INTO gofENT_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","ቂሳሪያን ዴዒያ ኣማኒያ ኣሳታፔ ጉꬃቲ ኑራ ቢዶሶና። ኤንቲ ኑኒ ሼምፓናሱዋ ሚናሶና ጊያ ቆጲሮሳ ኣዲያ ሶ ኤፊዶሶና። ሚናሶኒ ኮይሮ ኣማኒዳ ኣሳፔ ኢሱዋ። ");
INSERT INTO gofENT_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","ኑኒ ዬሩሳላሜ ጋኪዳ ዎዴ ኣማኒያ ኣሳቲ ኑና ኡፋይሳን ሞኪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","ዎንቴꬃ ጋላስ ጳዉሎሲኔ ኑኒ ያይቆባራ ጋሄታናው ቢዳ። ዎሳ ኬꬃ ጪማቲ ኡባቲካ ያን ዴዖሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","ጳዉሎሲ ኤንታ ሳሮꬂዳፔ ጉዬ ኣይሁዴ ጊዶና ኣሳ ጊዶን ባ ባጋራ ፆሳይ ኦꬂዳባ ኡባ ኤንታው ኦዲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","ኤንቲ ሄሳ ሲዒዳ ዎዴ ፆሳ ጋላቲዲ ጳዉሎሳኮ ሃይሳዳ ያጊዶሶና፡ «ኑ ኢሻው፥ ኣይሁዴታ ጊዶን ኣፑን ሙኩላቲ ፆሳ ኣማኒዳኮ ኔ ቤዓሳ፤ ኤንቲ ኡባይካ ሂጊያ ሚንꬂ ናጎሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","ኔኒ ኣይሁዴ ጊዶናይሳታ ቢታን ዴዒያ ኣይሁዴ ኡባይ ባንታ ናይታ ቃፃሮና ሜላ፥ ኣይሁዴታ ዎጋ ካሎና ሜላኔ ሙሴ ሂጊያ ኢፃና ሜላ ኔኒ ታማርሴይሳ ዬሩሳላሜን ዴዒያ ኣይሁዴቲ ሲዒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","ያቲን ኣይቢ ሎዖ? ኔኒ ዪዳይሳ ዳሮቲ ሲዓና። ");
INSERT INTO gofENT_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","«ሄሳ ጊሾ፥ ኑኒ ኔው ኦዴይሳ ሲዓ፤ ጋሶይ ዴዒያ ኦይዱ ኣሳቲ ኑ ማታን ዴዖሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","ኤንታ ኤካዳ ኤንታራ ጌያ፤ ቃሲ ኤንቲ ባንታ ሁዒያ ሜዴታና ሜላ ኤንታው ሚሼ ኢማ። ኤንቲ ካሴ ኔባ ሲዒዳይሲ ቱማ ጊዶናይሳኔ ኔኒ ኔ ሁዔንካ ሂጌ ናጊያ ኣሲ ጊዴይሳ ኡባይ ኤራና። ");
INSERT INTO gofENT_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","«ሺን ኣማኒዳ ኣይሁዴ ጊዶና ኣሳታ ጊዲኮ፥ ኤንቲ ኤቃስ ያርሼቲዳባ ሞና ሜላ፥ ሱꬁ ኡዮና ሜላ፥ ባዉታ ሞና ሜላኔ ላይማቶና ሜላ፥ ኑኒ ኦዳ ቃቺዲ፥ ኤንታው ዳብዳቤ ፃፊዳ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","ሄሳፌ ጉዬ፥ ጳዉሎሲ ዎንቴꬃ ጋላስ ኣሳታ ኤኪዲ፥ ኤንታራ ጌዪስ። ኢ ባንታ ጌያ ጋላሳይ ኣዉዴ ፖሌቲያኮ ኤሪሳናዉኔ ባንታ ያርሹዋ ኣዉዴ ያርሻኔኮ ኤሪሳናው ፆሳ ኬꬂ ጌሊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","ላፑን ጋላሳይ ዉራና ሃኒሺን፥ ኢሲያፔ ዪዳ ኣይሁዴቲ ፆሳ ኬꬃን ጳዉሎሳ ቤዒዲ፥ ኣሳ ኡባ ዴንꬄꬂዲ ጳዉሎሳ ኦይኪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","«ኢስራዔሌ ኣሳው፥ ኑና ማዲቴ፤ ሃ ኡራይ፥ ኑ ዴሪያ፥ ኑ ሂጊያኔ ሃ ፆሳ ኬꬃ ኢፃና ሜላ ኣሳ ኡባ ታማርሴስ። ሄሲካ ጊዶና ኢፂን ኣይሁዴ ጊዶናይሳታ ፆሳ ኬꬂ ጌልሲዲ፥ ሃ ጌሻ ቤሳ ቱኒሲስ» ያጊዲ ዋሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","ኤንቲ ሄሳ ጊዳይ ካሴ ኤፌሶና ፂሮፊሞሳ ጳዉሎሳራ ካታማን ቤዒዳ ጊሾ ሃዒ ጳዉሎሲ ፆሳ ኬꬂ ኢያ ኤኪ ጌሊዳባ ኤንታው ዳኒስ። ");
INSERT INTO gofENT_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","ካታማ ኡባይ ቡቄቲስ፤ ኣሳ ኡባይ ሺቂዲ ጳዉሎሳ ኦይኪዲ ፆሳ ኬꬃፌ ካሬ ጎቺዶሶና። ፆሳ ኬꬃ ፔንጌቲ ኤሌሲዲ ጎርዴቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","ኣሳይ ጳዉሎሳ ዎꬋና ሃኒሺን፥ «ዬሩሳላሜ ካታማይ ኩሜꬂ ቡቄቲስ» ጊያ ኦዳይ ሮሜ ሻላቃኮ ጋኪስ። ");
INSERT INTO gofENT_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","ሻላቃይ ዎታዳሬታኔ ማቶ ሃላቃታ ኤኪዲ ዎፂሼ ዪስ። ኣሳይ ሻላቃኔ ዎታዳሬታ ቤዒዳ ዎዴ ጳዉሎሳ ዋꬌይሳ ኣጋጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","ሄ ዎዴ ሻላቃይ ሺቂዲ፥ ጳዉሎሳ ኦይኪዲ፥ ናምዑ ሳንꬃላታን ቃሼታና ሜላ ኪቲስ። ያቲዲ፥ ኢ ኦኔኮኔ ኣይ ኦꬂዳኮ ኣሳ ኦይቺስ። ");
INSERT INTO gofENT_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","ኣሳፔ ባጋይ ኢሲባ ጊዲ ዋሲያ ዎዴ ሃራቲ ሃራባ ጊዲ ዋሴስ። ዋሶይ ዳሪዳ ጊሾ ሻላቃይ ቱማ ሻካንው ዳንዳዔቶና ኢፂን፥ ዎታዳሬቲ ጳዉሎሳ ባንታ ዴዒያሶ ኤፋና ሜላ ኪቲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","ጳዉሎሲ ዬꬊ ኬያ ዴꬃ ጋኪያ ዎዴ ኣሳ ሱጌꬃ ጊሾ ዎታዳሬቲ ኢያ ቶኪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","ዳሮ ኣሳይ፥ «ኢ ሃይቆ!» ያጊዲ ዋሲሼ ካሎሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","ዎታዳሬቲ ጳዉሎሳ ባንታ ዴዒያሱዋ ጌልሳና ሃኒሺን፥ ጳዉሎሲ ሻላቃኮ፥ «ታኒ ኔው ኢሲባ ኦዶ?» ያጊስ። ኢ ጳዉሎሳኮ፥ «ኔኒ ጊሪኬ ዶና ኤራይ? ");
INSERT INTO gofENT_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","ኔኒ ሃይሳፌ ሲንꬄ ቡቄꬂ ሜꬊዲ ሼምፖ ዎꬊዳ ኦይዱ ሙኩሉ ኣሳታ ኤኪዲ ባዞ ጌሊዳ ጊብፄ ኡራ ጊዲኪ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","ሺን ጳዉሎሲ፥ «ታኒ፥ ኪልቂያን ዴዒያ ኤሬቲዳ ቴርሴሴ ካታማን ዬሌቲዳ ኣይሁዴ ኣሲ። ሃያና ታና ኦዲሳርኪ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","ሻላቃይ ኢያኮ፥ «ኦዳ» ያጊን ጳዉሎሲ ዴꬃ ቦላ ኤቂዲ፥ ኣሳይ ሲዒ ጋና ሜላ ባ ኩሺያን ማሊስ። ኣሳይ ሲዒ ጊን ኢብራይስፄ ዶናን ሃይሳዳ ያጊስ፡ ");
INSERT INTO gofENT_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","«ታ ኢሻቶ፥ ታ ኣዋቶ፥ ታኒ ሃዒ ሂንቴው ኢሚያ ዛሩዋ ሲዒቴ።» ");
INSERT INTO gofENT_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","ጳዉሎሲ ኤንታው ኢብራይስፄ ዶናን ኦዴይሳ ሲዒዲ ካሴይሳፌ ኣꬂዲ ሲዒ ጊዶሶና። ኢ ካሊዲ፥ ");
INSERT INTO gofENT_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","«ታኒ ኪልቂያን ዴዒያ ቴርሴሴን ዬሌታዳ ሃ ካታማን ዲጫስ። ታ ኣስታማሬይካ ጋማሊያሌ፤ ታኒ ኑ ኣዋታ ሂጊያ ሚንꬃ ታማሪዳ፥ ሃቺ ሂንቴ ኡባይ ሃኔይሳዳ ፆሳስ ሚሼቲያ ኣይሁዴ ኣሲ። ");
INSERT INTO gofENT_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","ታኒ ሃ ኦጊያ ካሊያ ማጫታኔ ኣዴታ ኦይካዳ ቃሾ ኬꬃን ዬጋሼን ኤንታ ዎꬊሳና ጋካናው ዋዬ ቤሲዳ ኣሲ። ");
INSERT INTO gofENT_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","ሄሳዳካ፥ ካሂኔ ሃላቃይኔ ሻንጎ ኡባይ ታባ ማርካታናው ዳንዳዔስ። ታኒ ዳማስቆን ዴዒያ ኤንታ ኢሻታስ ኤንታፌ ዳብዳቤ ኤካዳ ያን ዴዒያ ኣሳቲ ቃሼቲዲ ሴሬታና ሜላ ዬሩሳላሜ ኤንታ ኤሃናው ያ ባስ። ");
INSERT INTO gofENT_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","«ታኒ ባዳ ዳማስቆ ማቲዳ ዎዴ ሴታ ጋላስ ቆፖና ሳሎፔ ጊታ ፖዖይ ታ ዩሹዋን ፖዒስ። ");
INSERT INTO gofENT_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","ታኒ ሳዓን ኩንዳ ዴዒሺን፥ ‹ሳዖላ፥ ሳዖላ፥ ታና ኣይስ ጎዳይ?› ጊያ ቃላ ሲዓስ። ");
INSERT INTO gofENT_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","ታኒ ዛራዳ፥ ‹ጎዳው፥ ኔኒ ኦኔ?› ያጋስ። ኢ ዛሪዲ፥ ‹ታኒ፥ ኔኒ ጎዲያ ናዚሬቴ ዬሱሳ› ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","ታራ ዴዔይሳቲ ፖዑዋ ቤዒዶሶናፔ ኣቲን ታው ኦዴይሳ ቃላ ኣኬኪቦኮና። ");
INSERT INTO gofENT_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","«ታኒ፥ ‹ጎዳው፥ ታ ኣይ ኦꬆ?› ያጋስ። «ጎዳይ ታኮ፥ ‹ዴንዳዳ ዳማስቆ ባ። ኔኒ ኦꬃና ሜላ ፆሳይ ቆፒዳባ ኡባይ ያን ኔው ኦዴታና› ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","ሄ ዎልቃማ ፖዑዋ ጋሶን ታ ኣይፌይ ቆቂን፥ ታራ ዴዒያ ኣሳቲ ታ ኩሺያ ኦይኪዲ፥ ታና ጎቺን ዳማስቆ ጋካስ። ");
INSERT INTO gofENT_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","«ዳማስቆን ዴዒያ ኣይሁዴ ኡባይ ዳሮ ቦንቺያ ኢሲ ሃናኒያ ጊያ ኣዴይ፥ ኑ ሂጊያ ቦንቼይሲኔ ፆሳ ሚንꬂ ዎሴይሲ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","ሃናኔይ ታኮ ዪዲ፥ ታ ማታን ኤቂዲ፥ ‹ታ ኢሻው ሳዖላ፥ ፄላ› ያጊስ። ኤሌሳዳ ታኒ ኢያ ፄላ ኣጋስ። ");
INSERT INTO gofENT_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","«ኢ ታኮ፥ ‹ኑ ኣዋታ ፆሳይ ኔኒ ኢያ ሼኒያ ኤራና ሜላ፥ ኢያ ፂሎ ናዓ ቤዓና ሜላኔ ኢያ ዶናፔ ቃላ ሲዓና ሜላ ካሴቲዲ ኔና ዶሪስ። ");
INSERT INTO gofENT_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","ኔኒ ቤዒዳባኔ ሲዒዳባ ኣሳ ኡባ ሲንꬃን ኢያው ማርካታና። ");
INSERT INTO gofENT_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","ሃዒ ኣይስ ጋምዓይ? ዴንዳዳ ፃማቄታ፤ ኢያ ሱንꬃ ፄጋዳ ኔ ናጋራፔ ሜጬታ› ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","«ታኒ ጉዬ ዬሩሳላሜ ሲማዳ ፆሳ ኬꬃን ዎሲሺን፥ ታው ቆንጬꬂ ቤንቲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","ቆንጬꬃን ጎዳይ ታኮ፥ ‹ኔ ታው ማርካቲያ ማርካቴꬃ ኣሳይ ኤኮና ጊሾ ኤሌሳዳ ዬሩሳላሜፔ ኬያ› ያጊሺን ቤዓስ። ");
INSERT INTO gofENT_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","«ታኒ፥ ‹ጎዳው፥ ኣይሁዴ ዎሳ ኬꬃ ኡባን ኔና ኣማኔይሳታ ኦይካዳ ዋꬊዳይሳኔ ቃሾ ኬꬃን ዬጊዳይሳ ኤንቲ ኤሮሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","ኤንቲ ኔ ማርካ ኢስፂፋኖሴ ዎꬊያ ዎዴ ታኒ ሄ ኦዳን ኢሲፋስ። ቃሲ ኤንታ ማታን ኤቃዳ ኢያ ዎꬌይሳታ ማዑዋ ናጋይስ› ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","«ጎዳይ ታኮ፥ ‹ታኒ ኔና ኣይሁዴ ጊዶና ኣሳኮ ሃሆሶ ኪቲያ ጊሾ ዴንዳዳ ባ› » ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","ጳዉሎሲ ሄ ቃላ ኦዲዲ ኦንጋና ጋካናው ኣሳይ ኢ ጌይሳ ሲዖሶና። ሄሳፌ ጉዬ፥ ባንታ ቃላ ꬎቁ ኦꬂዲ፥ «ሃይሳ ቢታፌ ꬋይሳ! ኢ ዳናው ቤሴና» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","ኤንቲ ዎጫሚሺን፥ ባንታ ማዑዋ ቦላ ሆሊሺኒኔ ባና ቦላ ላሊሺን፤ ");
INSERT INTO gofENT_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","ሻላቃይ ቤዒዲ ዎታዳሬቲ ጳዉሎሳ ባንታ ዴዒያሱዋ ኤፋና ሜላ ኪቲስ። ቃሲ ኣሳይ ኣይስ ሄሳዳ ዎጫሚዳኮ ኤራናው ኮዪዲ ጳዉሎሳ ሊሶን ጋራፊዲ ፒልጋና ሜላ ኤንታ ኪቲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","ሺን ዎታዳሬቲ ጳዉሎሳ ዳፎን ሚንꬂ ቃቺዲ ጋራፋና ሃኒያ ዎዴ ጳዉሎሲ ባ ማታን ኤቂዳ ማቶ ሃላቃኮ፥ «ሮሜ ኣሲ ፒርዲ ባይና ጋራፌይሲ ሂንቴው ዎጌ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","ማቶ ሃላቃይ ሄሳ ሲዒዳ ዎዴ ሻላቃኮ ቢዲ፥ «ሃ ኣዴይ ሮሜ ኣሲ። ኔኒ ኣይ ኦꬃናው ቆፓይ?» ያጊዲ ኦይቺስ። ");
INSERT INTO gofENT_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","ሻላቃይ ጳዉሎሳኮ ሺቂዲ፥ «ኔኒ ሮሜ ኣሴ? ኣኔ ታው ኦዳ» ያጊስ። ጳዉሎሲ፥ «ኤ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","ሻላቃይ ዛሪዲ፥ «ታኒ ሃ ጋዴቴꬃ ዳሮ ሚሼን ሻማስ» ያጊስ። ሺን ጳዉሎሲ፥ «ታ ሃ ጋዴቴꬃ ዬሌቴꬃን ዴማ ኤካስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","ሄሳ ጊሾ፥ ጳዉሎሳ ፒልጋናው ቆፒዳይሳቲ ኢራ ኢያፔ ሻኬቲዶሶና። ሻላቃይ ሮሜ ኣሲ ሳንꬃላታን ቃቺዳይሳ ኤሪዳ ዎዴ ያዪስ። ");
INSERT INTO gofENT_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","ዎንቴꬃ ጋላስ ሻላቃይ፥ ኣይሁዴቲ ጳዉሎሳ ኣይስ ሞቲዳኮ ጌሺ ኤራናው ኮዪስ። ካሂኔ ሃላቃቲኔ ሻንጎ ኡባይ ሺቃና ሜላ ኪቲስ፤ ቃሲ ጳዉሎሳ ቃሾፔ ቢሊሲዲ ኤንታ ሲንꬃን ኤሲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","ጳዉሎሲ ሺቁዋ ጫዲ ፄሊዲ፥ «ታ ኢሻቶ፥ ታኒ ሃቺ ጋካናው ፆሳ ሲንꬃን ታ ዴዖ ኡባን ሎዖ ዎዛናን ዴዓስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","ካሂኔ ሃላቃይ ሃናኔይ፥ ጳዉሎሳ ዶናን ባቃና ሜላ ኢያ ማታን ኤቂዳይሳታ ኪቲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","ሄ ዎዴ ጳዉሎሲ ኢያኮ፥ «ላ ኔ ቦቂንቴ ቲዪዳ ጎዳ ዳኔይሶ፥ ፆሳይ ኔና ባቃና። ኔኒ ታ ቦላ ሂጊያꬆ ፒርዳናው ኡታዳ ዴዓሼ ሂጌይ ባይና ታና ባቃና ሜላ ኪታይ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","ጳዉሎሳ ማታን ኤቂዳይሳቲ ኢያኮ፥ «ኔ ፆሳ ካሂኔ ሃላቃ ጫያይ?» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","ጳዉሎሲ፥ «ታ ኢሻቶ፥ ኢ ካሂኔ ሃላቃ ጊዲዳይሳ ታኒ ኤራቢኬ፤ ኣይስ ጊኮ ፆሳ ቃላን፥ ‹ኔ ዴሪያ ኣይሴይሳ ቦላ ኢታ ቃላ ሃሳዮፓ› ጌቴቲ ፃፌቲስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","ሺን ጳዉሎሲ ሄ ቤሳን ዴዒያ ኣሳፔ ባጋቲ ሳዱቃዌታ፥ ባጋቲ ፋሪሳዌታ ጊዴይሳ ቤዒዲ፥ «ታ ኢሻቶ፥ ታኒ ፋሪሳዌኔ ፋሪሳዌ ናዓ፤ ‹ሃይቂዳይሳቲ ሃይቆፔ ዴንዳና› ጋዳ ታኒ ኡፋይሳን ናጊያ ጊሾ ኤንቲ ታ ቦላ ፒርዶሶና» ያጊዲ ኦዲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","ጳዉሎሲ ሄሳ ጊዳ ዎዴ ፋሪሳዌታ ጊዶኒኔ ሳዱቃዌታ ጊዶን ኦሺ ኬዪን ሻኬቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","ኣይስ ጊኮ፥ ሳዱቃዌቲ፥ «ሃይቂዳ ኣሲ ዴንዴና፤ ኪታንቾይካ ኣያኒካ ባዋ» ያጎሶና። ሺን ፋሪሳዌቲ ናምዓይካ ዴዔይሳ ኣማኖሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","ጊታ ካቺ ኬዪስ፤ ፋሪሳዌታ ባጋ ጊዲዳ ሂጌ ኣስታማሬቲ ዴንዲ ኤቂዲ፥ «ሃ ኡራ ቦላ ኣይቢ ባላካ ዴሚቦኮ፤ ኢያው ኣያኒ ዎይኮ ኪታንቾይ ሃሳዮና ኣጌና» ያጊዲ ፓላሚዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","ኦሻይ ዳሪን ኣሳይ ጳዉሎሳ ሻቄሬꬆና ሜላ ጊዲ፥ ሻላቃይ ባ ዎታዳሬቲ ዎꬊዲ ኤንታ ጊዶፌ ኢያ ኤሌሲ ኬሲዲ ባንታ ዴዒያሱዋ ኤፋና ሜላ ኪቲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","ሄ ቃማ ጎዳይ ጳዉሎሳ ማታን ኤቂዲ፥ «ጳውሎሳ፥ ኔኒ ታው ዬሩሳላሜን ማርካቲዳይሳዳ ሮሜንካ ማርካታናው ቤሴስ፤ ሚና፤ ኣይኮይ ባዋ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","ዎንቴꬃ ጋላስ ኣይሁዴቲ፥ «ጳዉሎሳ ዎꬎና ዴዒሼ ሞኮ ኡዮኮ» ጊዲ ጫቂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","ጳዉሎሳ ቦላ ሄሳ ማቄቲዳ ኣሳቲ ኦይታማፔ ዳሮሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","ኤንቲ ካሂኔ ሃላቃታኮኔ ዴሪያ ጪማታኮ ቢዲ፥ «ኑኒ ጳዉሎሳ ዎꬎና ዴዒሼ ካꬂ ጊያባ ሞኮ ጊዲ ጫቂዳ። ");
INSERT INTO gofENT_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","ሂዛ፥ ሂንቴኔ ሻንጎይ ኢያባ ጌሺዲ ፒልጊያባይ ዴዒያ ዳኒሲዲ፥ ጳዉሎሳ ሂንቴኮ ኤሃና ሜላ ሻላቃ ኦይቺቴ። ኑኒ ኢ ሃ ሺቁዋ ጋካናፔ ሲንꬄ ኢያ ዎꬋናው ጊጊዲ ኡቲዳ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","ሺን ጳዉሎሳ ሚቼ ናዓይ ሄ ማቁዋ ሲዒዳ ዎዴ ቢዲ ዎታዳሬቲ ዴዒያሱዋ ጌሊዲ፥ ጳዉሎሳስ ኦዲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","ጳዉሎሲ ማቶ ሃላቃታፔ ኢሱዋ ፄጊዲ፥ «ሃ ናዓይ ሻላቃስ ኦዲያባይ ዴዒያ ጊሾ ኢያ ሻላቃኮ ኤፋ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","ማቶ ሃላቃይ ናዓ ሻላቃኮ ኤፊዲ፥ «ቃሾ ኬꬃን ዴዒያ ጳዉሎሲ ታና ባኮ ፄጊዲ፥ ሃ ናዓይ ኔው ኦዲያባይ ዴዒያ ጊሾ ኢያ ኔኮ ኤሃና ሜላ ታና ዎሲስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","ሻላቃይ ናዓ ኩሺያ ኦይኪዲ፥ ዱማ ካሬ ኬሲዲ፥ «ኔኒ ታው ኦዳናባይ ኣይቤ?» ያጊዲ ኦይቺስ። ");
INSERT INTO gofENT_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","ናዓይ ሻላቃኮ፥ «ኣይሁዴቲ ጳዉሎሳባ ካሴፔ ሚንꬂ ፒልጋናው ኮዪዳባ ዳኒሲዲ ኔኒ ዎንቶ ኢያ ሺቁዋ ኤሃና ሜላ ኔና ዎሳናው ዞሬታ ቃቺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","ሺን ኔኒ ኤንቲ ጊያባ ሲዖፓ። ኣይስ ጊኮ፥ ኦይታማፔ ዳሪያ ኣሳቲ ጳዉሎሳ ዎꬎና ዴዒሼ ‹ካꬂ ሞኮ፥ ሃꬄ ኡዮኮ› ጊዲ ጫቂዲ፥ ቆሴቲዲ ኢያ ናጎሶና። ሃዒ ኔ ጊያባ ፃላላ ሲዓናው ናጎሶና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","ሻላቃይ ዛሪዲ፥ «ሃ ኦዳ ኔ ታው ኦዲዳይሳ ሃራ ኦዴስካ ኦዶፓ» ያጊዲ ናዓ ጉዬ ዬዲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","ሻላቃይ ማቶ ሃላቃታፔ ናምዓታ ፄጊዲ፥ «ቃማፌ ሄꬑ ሳቴን ቂሳሪያ ባናው፥ ናምዑ ፄቱ ዎታዳሬታ፥ ላፑን ታሙ ፓራ ኣሳታኔ ናምዑ ፄቱ ቶራንቾታ ጊጊሲቴ። ");
INSERT INTO gofENT_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","ዴሪያ ኣይሲያ ፊልኪሳኮ ጳዉሎሳ ሳሮ ጋꬃናው ቶጋ ሜሄ ጊጊሲቴ» ያጊዲ ኤንታ ኪቲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","ሻላቃይ ፊልኪሳስ ሃይሳዳ ጊያ ዳብዳቤ ፃፊስ፡ ");
INSERT INTO gofENT_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","«ቃላዉዲዮሳ ሉሲዮሳፔ ዴሪያ ኣይሲያ ቦንቾ ፊልኪሳስ፥ ሳሮይ ኔው ጊዶ። ");
INSERT INTO gofENT_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","ኣይሁዴቲ ሃ ኡራ ኦይኪዲ ዎꬋና ሃኒሺን፥ ኢ ሮሜ ቢታ ኣሲ ጊዶይሳ ኤራዳ ዎታዳሬታራ ጋካዳ ኢያ ኣሻስ። ");
INSERT INTO gofENT_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","ኤንቲ ኢያ ኣይስ ሞቲያኮ ኤራናው ኮያዳ ኤንታ ሺቁዋን ኢያ ሺሻስ። ");
INSERT INTO gofENT_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","ኤንቲ ባንታ ሂጊያስ ኢያ ሞቲዳይሳፌ ኣቲን ኢያ ዎꬊሲያባ ዎይኮ ቃሺሲያባ ጊዶናይሳ ታ ዴማስ። ");
INSERT INTO gofENT_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","ኤንቲ ሃ ኡራ ቦላ ማቄቲዳ ዚጊርሳይ ታና ጋኪን፥ ታኒ ኤሌሳዳ ኢያ ኔኮ ዬዳስ። ኢያ ሞቴይሳቲ ኔ ሲንꬃን ቢዲ ሞታና ሜላ ኪታስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","ሄሳ ጊሾ፥ ዎታዳሬቲ ኪቴቲዳይሳዳ ጳዉሎሳ ኤኪዲ፥ ቃማ ኣንቲጳፂሪሳ ጋꬂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","ዎንቴꬃ ጋላስ ፓራ ኣሳቲ ኢያራ ባና ሜላ ኦꬂዲ ቶሆ ኣሳቲ ጉዬ ሲሚዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","ቶጋይ ቂሳሪያ ጋኪዲ ዳብዳቢያ ዴሪያ ኣይሴይሳስ ኢሚዲ፥ ጳዉሎሳ ኢያ ሲንꬄ ኣꬂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","ዴሪያ ኣይሴይሲ ዳብዳቢያ ናባቢዳፔ ጉዬ «ጳዉሎሳ፥ ኔ ኣው ኣዉራጃ ኣሴ?» ጊዲ ኢያ ኦይቺስ። ኢ ኪልቂያ ኣሲ ጊዶይሳ ኤሪዳ ዎዴ ");
INSERT INTO gofENT_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","«ታኒ ኔባ ኔና ሞቴይሳቲ ያ ዎዴ ሲዓና» ያጊስ። ዎታዳሬቲ ጳዉሎሳ ሄሮዲሳ ኬꬃን ናጋና ሜላ ኪቲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","ኢቻሹ ጋላሳፔ ጉዬ ካሂኔ ሃላቃይ፥ ሃናኔይ፥ ጪማታራኔ ፄርፄሉሳ ጊያ ኢሲ ፃባቃራ ቂሳሪያ ቢስ። ኤንቲ ዴሪያ ኣይሴይሳ ቦላ ጳዉሎሳ ሞቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","ጳዉሎሲ ፄጌቲዲ ጌሊዳ ዎዴ ፄርፄሉሲ ኢያ ሃይሳዳ ያጊዲ ሞቲስ፡ «ቦንቾ ፊልኪሳ፥ ኑኒ ኔ ባጋራ ዳሮ ሳሮቴꬃ ዴሚዳ፥ ኔ ሎዖ ኣይሱዋን ኑ ቢታይ ዳሮ ላሜቲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","ቦንቾ ፊልኪሳ፥ ኑኒ ኣዉንካ ኣዉዴ ጊዲን ዳሮ ጋላታን ሄሳ ኤኮስ። ");
INSERT INTO gofENT_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","ታኒ ኔና ጋምዒሶናሺን ኔኒ ኔ ኬሃቴꬃን ኑባ ቃንꬃን ሲዓና ሜላ ኔና ዎሳይስ። ");
INSERT INTO gofENT_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","ሃ ኡራይ ꬉቤ ጊዲዲ ቢታ ኡባን ዴዒያ ኣይሁዴታ ጊዶን ቡቄꬂ ሜꬊዲ ናዚራዌታ ባጋ ኣሳ ካሌꬄይሳ ጊዶይሳ ኤሪዳ። ");
INSERT INTO gofENT_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","ሃሪ ኣቶሺን፥ ፆሳ ኬꬃ ቱኒሳና ሃኒሺን ኑኒ ኢያ ኦይኪዳ፤ ኑ ሂጊያዳ ኢያ ቦላ ፒርዳናው ቆፒዳ። ");
INSERT INTO gofENT_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","ሺን ሻላቃ ሉሲዮሲ ዪዲ፥ ዎልቃን ኑ ኩሼፔ ኢያ ዎꬂ ኤኪስ። ");
INSERT INTO gofENT_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","ኢያ ሞቴይሳቲካ ኔኮ ያና ሜላ ኪቲስ። ኔኒ ኔ ሁዔን ሃ ኡራ ፒልጋዳ ኑኒ ኢያ ሞቲያ ሞቱዋ ኡባ ኤራናው ዳንዳዓሳ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","ኣይሁዴቲካ፥ «ሃ ኦዳይ ቱማ» ጊዲ ኢያ ቆፋ ማዒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","ዴሪያ ኣይሴይሲ ጳዉሎሳ ኦዳ ጊዲ ማሊስ። ጳዉሎሲ ሃይሳዳ ጊዲ ዛሪስ፡ «ኔኒ ዳሮ ዎዴፔ ዶማዳ፥ ሃ ኣሳስ ፒርዳሼ ዴዔይሳ ኤራዳ ታ ኦዳስ ኡፋይሳን ዛሮ ኢማይስ። ");
INSERT INTO gofENT_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","ታኒ ጎይናናው ዬሩሳላሜ ኬዪን ታማኔ ናምዑ ጋላሳፔ ኣꬎናይሳ ኔኒ ኔ ሁዔን ኤራናው ዳንዳዓሳ። ");
INSERT INTO gofENT_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","ኣይሁዴቲ ታና ፆሳ ኬꬃን ጊዲን ኣይሁዴ ዎሳ ኬꬃን ጊዲን ካታማን ጊዲን ኦዴራካ ፓላሚሺን ዎይኮ ኣሴ ሺሻዳ ማቂሺን ኢሲ ኣሲካ ዴሚቤና። ");
INSERT INTO gofENT_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","ሃዒካ ኤንቲ ታና ሞቲያባስ ማርካ ዴማናው ዳንዳዖኮና። ");
INSERT INTO gofENT_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","«ሺን ታኒ ኢሲባ ኣማናይስ፤ ታኒ ሂጌን ዴዒያባኔ ናቤቲ ፃፊዳ ኡባባ ኣማናዳ፥ ኑ ኣዋታ ፆሳ፥ ኤንቲ ዎርዶ ጊያ ኦጊያን ጎይናይስ። ");
INSERT INTO gofENT_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","ኤንቲ ባንታ ሁዔን ኣማኔይሳ ሜላ ፂሎቲኔ ናጋራንቾቲ ሃይቆፔ ዴንዳናይሳ ታካ ኣማናይስ። ");
INSERT INTO gofENT_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","ሄሳ ጊሾ፥ ታኒ ፆሳ ሲንꬃኒኔ ኣሳ ሲንꬃን ኡባ ዎዴ ሎዖ ካሂ ታው ዳና ሜላ ሚናይስ። ");
INSERT INTO gofENT_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","«ታኒ ዬሩሳላሜፔ ኬዮሳፔ ዳሮ ላይꬃፌ ጉዬ ታ ቢታ ማንቆታስ ማዴ ኢማናዉኔ ያርሾ ያርሻናው ዬሩሳላሜ ባስ። ");
INSERT INTO gofENT_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","ታኒ ፆሳ ኬꬃን ሄሳ ኦꬃዳ ጌሻ ዎጋ ፖላ ሲሚን ታና ዴሚዶሶና። ሄ ዎዴ ታራ ኣሲ ባዋ፥ ኦሺካ ኬዪቤና። ");
INSERT INTO gofENT_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","ሺን ኢሲያፔ ዪዳ ኢሲ ኢሲ ኣይሁዴቲ ያን ዴዖሶና፤ ኤንቲ ታ ቦላ ኦዳ ኮይኮ ዪዲ ታና ኔ ቦላ ሞታናው ዳንዳዖሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","ዎይኮ ታኒ ሻንጉዋ ሲንꬄ ሺቂዳ ዎዴ ኦꬂዳ ባሊ ዴዒኮ ሃይሳቲ ኔ ሲንꬃን ዴዔይሳቲ ኦዶና። ");
INSERT INTO gofENT_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","ታኒ ኤንታ ጊዶን ኤቃዳ፥ ‹ሃይቂዳይሳቲ ዴንዳና ጋዳ ዋሳዳ ኦዲዳ ጊሾ ሃቺ ሂንቴ ሲንꬃን ታ ቦላ ፒርዶሶና› ጋስ፤ ሄሳፌ ሃራባ ኦꬃቢኬ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","ሺን ፊልኪሲ ፆሳ ኦጊያባ ጌሺ ኤሪዳ ጊሾ «ታኒ ሂንቴ ኦዳ ሻላቃ ሉሲዮሲ ያ ዎዴ ፒርዳና» ያጊዲ ሞይዚስ። ");
INSERT INTO gofENT_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","ፊልኪሲ ቃሲ ጳዉሎሳ ቃቾና ናጋና ሜላኔ ኢያ ዳቦታፔ ኦኒካ ኢያ ኦይቻናው ዪሺን ዲጎና ሜላ ማቶ ሃላቃስ ኦዲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","ጉꬃ ጋላሳፔ ጉዬ፥ ፊልኪሲ ኣይሁዴ ባጋ ጊዲዳ ባ ማቼ ዲሩሲላራ ዪዲ ጳዉሎሳ ኪቲ ኤሂሲዲ ዬሱስ ኪሪስቶሳን ኣማኖባ ኢያፔ ሲዒስ። ");
INSERT INTO gofENT_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","ጳዉሎሲ ፂሎቴꬃባ፥ ባ ሁዔ ሃሮባኔ ያናው ዴዒያ ፒርዳባ ኦዲሺን፥ ፊልኪሲ ያዪዲ፥ «ኔኒ ሃዒስ ባ፤ ታው ኢንጄቲዳ ዎዴ ኔና ፄጊሳና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","ሄ ዎዴ ጳዉሎሳፔ ጉቦ ኤካናው ቆፒዲ ኢያ ዛሪ ዛሪ ፄጊሲዲ ኢያራ ኦዴቴስ። ");
INSERT INTO gofENT_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","ናምዑ ላይꬃፌ ጉዬ፥ ፊልኪሳ ቤሳ ጶርቂዮስ ፊስፆሲ ኤኪስ። ፊልኪሲ ኣይሁዴታ ኡፋይሳናው ኮዪዲ ጳዉሎሳ ቢሎና ኣጋጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","ፊስፆሲ ካዎቲዳ ሄꬑ ጋላሳፔ ጉዬ ቂሳሪያፔ ዬሩሳላሜ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","ያን ካሂኔ ሃላቃቲኔ ኣይሁዴታ ካሌꬄይሳቲ ጳዉሎሳ ሞቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","ጳዉሎሳ ዬሩሳላሜ ኤሂሺን ኦጌን ቆሴቲዲ ኢያ ዎꬋናው ኤንታው ኢንጄታና ሜላ ባንታና ማዶ ጊዲ ፊስፆሳ ዎሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","ፊስፆሲ ኤንታኮ፥ «ጳዉሎሲ፥ ቂሳሪያን ቃሾ ኬꬃን ዴዔስ፤ ታኒ ታ ሁዔንካ ኤሌሳዳ ጉዬ ሲማና ሃናይስ። ");
INSERT INTO gofENT_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","ኢ ባሊዳባይ ዴዒኮ ሂንቴ ጊዶን ኣዋቴይሳቲ ታራ ቂሳሪያ ቢዲ ኢያ ሞቶና» ያጊዲ ዛሪስ። ");
INSERT INTO gofENT_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","ፊስፆሲ ኤንታ ማታን ሆስፑን ዎይኮ ታሙ ጋላሳ ሜላ ጋምዒዳፔ ጉዬ ቂሳሪያ ቢስ። ዎንቴꬃ ጋላስ ፒርዳ ኦይዲያን ኡቲዲ ጳዉሎሳ ኤሃና ሜላ ኪቲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","ኢ ዪን ዬሩሳላሜፔ ዪዳ ኣይሁዴቲ ኢያ ዩሹዋን ኤቂዲ ኤንቲ ላꬃናው ዳንዳዖና ዳሮ ዴፆ ሞቶ ኢያ ቦላ ሺሺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","ጳዉሎሲ ዛሪዲ፥ «ታኒ ኣይሁዴ ሂጊያ ጊዲን ፆሳ ኬꬃ ዎይኮ ሮሜ ካዉዋ ቄሳሬ ናቃቢኬ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","ሺን ፊስፆሲ ኣይሁዴታ ኡፋይሳናው ኮዪዲ ጳዉሎሳኮ፥ «ዬሩሳላሜ ባዳ ሃ ሞቱዋባ ያን ታ ሲንꬃን ፒርዴታናው ኮያይ?» ያጊዲ ኦይቺስ። ");
INSERT INTO gofENT_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","ሺን ጳዉሎሲ፥ «ታኒ ፒርዴታናው ቤሲያ ቄሳሬ ፒርዳ ኬꬃን ኤቃ ኪቻስ። ኔኒ ሎይꬃ ኤሬይሳዳ ታኒ ኣይሁዴታ ኣይቢንካ ናቃቢኬ። ");
INSERT INTO gofENT_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","ሂዛ፥ ታኒ ናቂዳባይ ዎይኮ ሃይቆስ ጋꬂያባ ኦꬂዳባ ጊዲኮ ሃይቆፔ ታና ኣሻ ጊኬ። ሺን ኤንቲ ታና ሞቲያ ሞቶይ ጮ ጊዳፔ ጉዬ ኦኒካ ታና ኤንታው ኣꬂ ኢማናው ዳንዳዔና። ቄሳሬይ ታባ ፒርዶ ጋዳ ኦይቻይስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","ሄ ዎዴ ፊስፆሲ ባ ዞራንቾታራ ዞሬቲዲ፥ «ኔኒ ቄሳሬይ ታባ ፒርዶ ጋዳ ኦይቻዳሳ፤ ቄሳሬኮ ባሳ» ያጊዲ ዛሪስ። ");
INSERT INTO gofENT_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","ጉꬃ ጋላሳፔ ጉዬ ካዎይ ኣጊርጲኔ ባርኒቄይ ፊስፆሳ ሳሮꬃናው ቂሳሪያ ቢዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","ያን ኤንቲ ዳሮ ጋላስ ጋምዒን፥ ፊስፆሲ ካዉዋስ ጳዉሎሳባ ሃይሳዳ ያጊዲ ኦዲስ፤ «ፊልኪሲ ቢሎና ኣጊዲ ቢዳ ኢሲ ኣዴይ ሃይሳን ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","ታኒ ዬሩሳላሜ ቢዳ ዎዴ ካሂኔ ሃላቃቲኔ ኣይሁዴ ጪማቲ ኢያ ቦላ ፒርዳና ሜላ ታና ዎሲዲ ኢያባ ታው ኦዲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","ታኒ፥ ‹ሞቴቲዳ ኡራይ ባና ሞቴይሳታ ሲንꬃን ኤቂዲ ባ ሞቲዳባስ ዛሮ ኢሞናሺን፥ ኦና ጊዲኮካ ኣꬊዲ ኢሜቴይሲ ሮሜ ሂጌ ጊዴና› ያጋዳ ኤንታው ዛራስ። ");
INSERT INTO gofENT_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","«ሄሳ ጊሾ፥ ኤንቲ ሃይሳን ሺቂዳ ዎዴ ታኒ ጋምዖና ዎንቴꬃ ጋላስ ፒርዳ ኬꬃ ጌላዳ ጳዉሎሳ ኤሃና ሜላ ኪታስ። ");
INSERT INTO gofENT_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","ኢያ ሞቴይሳቲ ኢያ ማታን ኤቂዲ፥ ኢታባን ኢያ ሞቶና ኣጎኮና ጋዳ ታኒ ቆፒዳይሳ ሜላ ኢያ ሞቲቦኮና። ");
INSERT INTO gofENT_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","ሺን ኤንቲ ባንታ ኣማኖባኔ ጳዉሎሲ፥ ‹ፓፃ ዴዔስ› ጊያ ኢሲ ሃይቂዳ ዬሱሳ ጌቴቲያ ኣዲያባ ኢያራ ፓላሞሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","ሃ ኦዳይ ታና ሻካናው ሜቲዳ ጊሾ ጳዉሎሲ ዬሩሳላሜ ቢዲ፥ ያን ፒርዴታናው ኮያኮ ጋዳ ኢያ ኦይቻስ። ");
INSERT INTO gofENT_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","ሺን ጳዉሎሲ ባ ኦዳ ቄሳሬይ ቤዓና ጋካናው ቃሾ ኬꬃን ጋምዓናው ኦይቺስ። ታኒ ኢያ ቄሳሬኮ ዬዳና ጋካናው ኢ ቃሼታና ሜላ ኪታስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","ሄሳ ጊሾ፥ ኣጊርጲ ፊስፆሳኮ፥ «ታኒ ታ ሁዔንካ ሄ ኡራይ ጊያባ ሲዓናው ኮያይስ» ያጊስ። ፊስፆሲ ኢያኮ፥ «ኔኒ ዎንቶ ኢ ጊያባ ሲዓና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","ዎንቴꬃ ጋላስ ኣጊርጲኔ ባርኒቄይ ጊታ ቦንቾን ሻላቃታራኔ ካታማን ዴዒያ ጊታ ኣሳታራ ዪዲ ፒርዳ ኬꬂ ጌሊዶሶና። ፊስፆሲ ጳዉሎሳ ፄጊሲዲ ኤሂስ። ");
INSERT INTO gofENT_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","ፊስፆሲ፥ «ካዋው ኣጊርጳ፥ ሃይሳን ኑራ ዴዒያ ኣሳው፥ ኣይሁዴቲ ዬሩሳላሜንካ ሃይሳንካ ዋሲዲ፥ ‹ኢ ሂዛፔ ጉዬ ፓፃ ዳናው ቤሴና› ያጊዲ፥ ታና ዎሲዳ ኡራ ሃይሳ ቤዔታ። ");
INSERT INTO gofENT_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","ሺን ኢያ ሃይቆስ ጋꬂያባ ኣይቢባካ ታኒ ዴማቢኬ። ኢ ባ ሁዔን፥ ‹ቄሳሬይ ታባ ፒርዶ ያጋዳ ኦይቻይስ› ጊዳ ጊሾ ቄሳሬኮ ኢያ ዬዳናው ቆፋ ቃቻስ። ");
INSERT INTO gofENT_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","ታኒ ኢያባ ታ ጎዳ ቄሳሬስ ፃፋናው ጊዲያ ጋሶይ ኣይቢካ ባዋ። ሄሳ ጊሾ፥ ኢያባ ሂንቴ ቤዒኮ ታ ፃፊያባይ ቤንታኔኮ ጋዳ ሂንቴ ሲንꬄ ኡባራካ ካዋው፥ ኣጊርጳ፥ ኔ ሲንꬄ ኢያ ኤሃስ። ");
INSERT INTO gofENT_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","ኣይስ ጊኮ፥ ቃሼቲዳ ኣሲ ቦላ ዳይናስ ኣꬂያ ዎዴ ኢ ኣይስ ሞቴቲዳኮ ቆንጪሶና ኣጌይሲ ታው ኤያቴꬂ ዳኔስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","ኣጊርጲ ጳዉሎሳኮ፥ «ኔኒ ኔባ ኦዳናው ዳንዳዓሳ» ያጊስ። ሄ ዎዴ ጳዉሎሲ ባ ኩሺያ ዴንꬂዲ ሃይሳዳ ያጊስ፡ ");
INSERT INTO gofENT_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","«ካዋው፥ ኣጊርጳ፥ ኣይሁዴቲ ታና ሞቲዳባስ ዛሮ ኢማናው ሃቺ ኔ ሲንꬃን ኤቃሼ ታ ቃዳይ ሎዖ ጋዳ ቆፓይስ። ");
INSERT INTO gofENT_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","ኔኒ ኣይሁዴ ዎጋኔ ፓላማ ሎይꬃዳ ኤሪያ ጊሾ ታና ሳሌቶና ሲዓና ሜላ ዎሳይስ። ");
INSERT INTO gofENT_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","«ታኒ ናዓቴꬃፌ ዶማዳ ታ ኣሳ ጊዶኒኔ ዬሩሳላሜን ዴዒዳ ታ ዴዑዋ ኣይሁዴ ኡባይ ኤሮሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","ታኒ ኮይሮፔ ዶማዳ፥ ኑ ኣማኖ ሂጊያ ሚንꬂዲ ናጊያ ፋሪሳዌታ ያራፔ ጊዴይሳ ኤንቲ ማርካታናው ኮይኮ ኤሮሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","ሃዒካ ታኒ ፆሳይ ኑ ኣዋታስ ኢማና ጊዳ ኡፋይሳ ናጊያ ጊሾ ሞቴታዳ ሃይሳን ኤቃስ። ");
INSERT INTO gofENT_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","ቃሲ ታማኔ ናምዑ ኑ ኣዋታ ሼሻይ ፆሳ ቃማኔ ጋላስ ሚንꬂዲ ጎይኒሼ ፆሳይ ኢማና ጊዳይሳ ኤካናው ኡፋይሳን ናጎሶና። ካዋው ኣጊርጳ፥ ኣይሁዴቲ ታና ሞቴይ ታኒ ኡፋይሳን ሄሳ ናጊያ ጊሾሳ። ");
INSERT INTO gofENT_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","ኣይሁዴቶ፥ ፆሳይ ሃይቂዳይሳታ ዴንꬄይሳ ኣይስ ኣማኔኬቲ? ");
INSERT INTO gofENT_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","«ካሴ ታኒ ታ ሁዔንካ ናዚሬቴ ዬሱሳ ሱንꬃ ቴቃናው ዳንዳዔቲዳባ ኡባ ኦꬃናው ቤሴስ ጋዳ ቆፓስ። ");
INSERT INTO gofENT_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","ታኒ ዬሩሳላሜን ኦꬂዳይ ሃይሳ። ካሂኔ ሃላቃታፔ ማታ ኤካዳ ፆሳ ኣሳታፔ ዳሮታ ቃሺሳስ። ኤንታ ዎꬊያ ዎዴካ ኤንታ ሃይቁዋ ዶሳስ። ");
INSERT INTO gofENT_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","ዳሮ ዎዴ ኣይሁዴ ዎሳ ኬꬃ ኡባን ኤንቲ ሴሬታና ሜላኔ ዬሱሳ ጫዪዲ ካዳና ሜላ ኡንዔꬃስ። ታኒ ዎጊ ባይና ኤንታ ሃንቄታዳ ሃሪ ኣቶሺን፥ ሃራ ቢታ ካታማታ ጋካናው ኤንታ ጎዳስ። ");
INSERT INTO gofENT_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","«ታኒ ሃ ኦዳስ ካሂኔ ሃላቃታፔ ማታኔ ኪታ ኤካዳ ዳማስቆ ባይስ። ");
INSERT INTO gofENT_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","ካዋው፥ ታኒ ሴታ ጋላስ ኦጊያን ዴዒሺን ኣዋ ፖዖፔ ዳሮ ኣꬊያ ፖዖይ ታ ዩሹዋኒኔ ታራ ቤይሳታ ዩሹዋን ሳሎፔ ፖዒስ። ");
INSERT INTO gofENT_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","ኑኒ ኡባይካ ሳዓን ኩንዲዳ ዎዴ ኢብራይስፄ ዶናን፥ ‹ሳዖላ፥ ሳዖላ፥ ታና ኣይስ ጎዳይ? ኔኒ ኔና ጫዲያ ፃምዓ ቃኪኮ ኔና ቆሃሳ› ያጊዲ ታው ኦዲሺን ሲዓስ። ");
INSERT INTO gofENT_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","«ታኒ፥ ‹ጎዳው፥ ኔኒ ኦኔ?› ያጋስ። «ጎዳይ፥ ‹ታኒ፥ ኔኒ ጎዲያ ዬሱሳ፤ ");
INSERT INTO gofENT_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","ሺን ዴንዳ ኤቃ። ሃቺ ኔኒ ታና ቤዒዳይሳኒኔ ሲንꬃፌ ታ ኔና ቤሳኝሳ ሃራታስ ማርካታና ሜላ ታ ኦሳንቾ ኦꬃዳ ኔና ሹማናው ኔው ቤንታስ። ");
INSERT INTO gofENT_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","ኢስራዔሌ ኣሳታፔኔ ታኒ ኔና ኤንታኮ ኪቲያ ኣይሁዴ ጊዶናይሳታፔ ኔና ኣሻና። ");
INSERT INTO gofENT_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","ኔኒ ኤንታ ኣይፊያ ዶያና፥ ꬉማፔ ፖዖኮ፥ ፃላሄ ኩሼፔ ፆሳኮ ኤንታ ዛራና። ኤንቲ ታናን ኣማኒዲ ናጋራ ኣቶቴꬃ ኤካና። ፆሳይ ዶሪዳ ኣሳ ጊዶን ባንታ ላታ ዴማና› ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","«ካዋው ኣጊርጳ፥ ሄሳ ጊሾ፥ ታው ሳሎፔ ቤንቲዳ ቆንጬꬃስ ኪቴታናይሳ ኢፃቢኬ። ");
INSERT INTO gofENT_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","ሺን ታኒ ኮይሮታዳ ዳማስቆን ሄሳፌ ጉዬ ዬሩሳላሜኒኔ ዪሁዳ ቢታ ኡባን ዴዔይሳቲኔ ኣይሁዴ ጊዶናይሳቲ ባንታ ናጋራፔ ፆሳኮ ሲማና ሜላኔ ናጋራፔ ሲሙዋ ቤሲያ ኦሶ ኦꬃና ሜላ ቃላ ኦዳስ። ");
INSERT INTO gofENT_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","ሄሳ ጊሾ፥ ኣይሁዴቲ ታና ፆሳ ኬꬃን ኦይኪዲ ዎꬋናው ኮዪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","ሃቺ ጋካናው ፆሳ ማዴይ ታፔ ሻኬቲቤና፤ ያኒያ ጊሾ፥ ጉꬃሲኔ ጊታስ ማርካታሼ ሃይሳን ኤቃስ። ናቤቲኔ ሙሴይ ሃናና ጊዲ ኦዲዳይሳፌ ሃራ ኢሲባካ ታኒ ኦዲዳባይ ባዋ። ");
INSERT INTO gofENT_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","ሄሲካ፥ ‹ኪሪስቶሲ ዋዬ ኤካናው ቤሴስ፤ ቃሲ ሃይቆፔ ኮይሮ ዴንዲዲ ኣይሁዴታሲኔ ኣይሁዴ ጊዶናይሳታስ ኣቶቴꬃ ፖዖ ኦዳናው ቤሴስ› ጊዳይሳ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","ጳዉሎሲ ሄሳ ያጊዲ ዛሪሺን፥ ፊስፆሲ ባ ቃላ ꬎቁ ኦꬂዲ፥ «ጳውሎሳ፥ ኔ ጎያዳሳ፤ ኔ ዳሮ ቲሚርቴይ ኔና ጎሻስ ጋꬂስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","ሺን ጳዉሎሲ፥ «ቦንቾ ፊስፆሳ፥ ታኒ ቱማባኔ ቤሲያባ ኦዳይሲፔ ኣቲን ጎያቢኬ። ");
INSERT INTO gofENT_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","ታኒ ቆንጬን ኦዲያ ኦዳ ካዎይ ኤሬስ። ሃ ኦዳይ ጌማን ኦሴቲቦና ጊሾ ኢሶይካ ኢያፔ ጌሞናይሳ ታኒ ጌሻዳ ኤራይስ። ");
INSERT INTO gofENT_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","«ካዋው ኣጊርጳ፥ ኔኒ ናቤታ ኣማናሳ ጊዲኪ? ኔኒ ኣማኔይሳ ታኒ ኤራይስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","ካዎይ ኣጊርጲ፥ ጳዉሎሳኮ፥ «ሃ ጉꬃ ሳቴን ታና ኣማንꬃናው ኮያይ?» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","ጳዉሎሲ፥ «ዳሮ ዎዴ ጊዲን ጉꬃ ዎዴ ኔ ፃላላ ጊዶናሺን ሃቺ ታና ሲዒያ ኡባይ ሃ ቃሹዋፔ ኣቲን ታ ሜላ ጊዳና ሜላ ፆሳ ዎሳይስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","ሄሳፌ ጉዬ፥ ካዎይ ፊስፆሲ፥ ባርኒቄይኔ ኤንታራ ኡቲዳ ኡባይካ ዴንዲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","ያፔ ኬዪዲ ቢሼ ኢሶይ ኢሱዋራ፥ «ሃ ኡራይ ሃይቆስ ዎይኮ ቃሾስ ጋꬂያባ ኣይኮካ ኦꬂቤና» ያጊዲ ኦዴቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","ኣጊርጲ ፊስፆሳኮ፥ «ሃ ኡራይ ‹ቄሳሬይ ታባ ፒርዶ› ጎናኮ ቢሌታናው ዳንዳዔስ፥ ሺን ኣቲስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","ኑኒ ማርካቤራ ፃሌ ባናው ቃቺዳ ዎዴ ኣዉጊስፆሳ ዎታዳሬታ ጌቴቴይሳታፔ ኢሲ ዩሊዮሳ ጊያ ማቶ ሃላቃስ ጳዉሎሳኔ ሃራ ጉꬃ ቃሾ ኣሳታ ኢሚዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","ኢሲያ ጋፃን ዴዒያ ቢታታ ቢያ ኣዲራሚፂዮኔ ማርካቤን ጌሊዲ ዴንዲዳ። ማቄዶኒያ ኣሲ ጊዲዳ ቴሴሎንቄ ኣርስፂሮኮሲ ኑራ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","ዎንቴꬃ ጋላስ ኑኒ ሲዶና ጋኪሺን፥ ዩሊዮሲ ጳዉሎሳስ ኬሂዲ ባ ላጌታኮ ቢዲ ኮሺያባን ማዴታና ሜላ ኤንታኮ ዬዲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","ያፔ ዴንዲዲ ሲንꬃራ ኑ ቦላ ጫርኪያ ጊሾ ሃꬃን ቴቄቲዳ ቢታ፥ ቆጲሮሳን ዜምፒዲ ኣꬊዳ። ");
INSERT INTO gofENT_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","ኪልቂያኔ ጲንፊሊያ ማታን ዴዒያ ኣባ ፒኒዲ ሊቂያን ዴዒያ ሙራ ጋኪዳ። ");
INSERT INTO gofENT_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","ያን ማቶ ሃላቃይ ፃሌ ቢያ ኢስኪንዲሪያ ማርካቤ ዴሚዲ፥ ኢያን ኑና ጌልሲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","ኑኒ ዳሮ ጋላስ ሎዳራ ቢዲ፥ ዳሮ ሜቶን ቃንዶሳ ካታማ ማታ ጋኪዳ። ያራ ባናው ኑና ጫርኮይ ዲጊን ሳልሞናራ ኣꬊዲ ሃꬃን ቴቄቲዳ ቢታ፥ ቃርፄሳን ዜምፒዲ ኣꬊዳ። ");
INSERT INTO gofENT_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","ዳሮ ሜቶን ጋፃ ጋፃ ኦይኪዲ ላሲያ ካታማ ማታን ዴዒያ ኣባ ዶናን «ማርካቤይ ዎፑ ጊዲ ሼምፒያሶ» ጊያ ቤሳ ጋኪዳ። ");
INSERT INTO gofENT_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","ኑኒ ያን ዳሮ ዎዲያ ጋምዒዳፔ ጉዬ ፆሚ ቢሌቲን፥ ማርካቤራ ቡሲ ሜቲያ ጊሾ ጳዉሎሲ ኤንታ ዞሪስ። ");
INSERT INTO gofENT_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","«ኣሳው፥ ኑ ቡሳን ጊታ ቦሺኔ ዳሮ ቆሆይ ዴዔይሲ ታው ቤንቴስ፤ ቆሆይ ጫና ቦላኔ ማርካቢያ ቦላ ፃላላ ጊዶናሺን ኑ ዴዑዋ ቦላካ ጋካና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","ሺን ማቶ ሃላቃይ ጳዉሎሲ ጊዳይሳፌ ኣꬂዲ ማርካቢያ ላጌይሲኔ ማርካቢያ ጎዳይ ጌይሳ ኣማኒስ። ");
INSERT INTO gofENT_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","ሄ ኣባ ዶናን ዴዒያ ካታማይ ባልጎ ኣጌና ኣꬃናው ኤንታው ኢንጄቶና ጊሾ ዳሪያ ኣሳቲ ባንታው ዳንዳዔቲኮ ፊንቄ ካታማ ጋኪዲ ባልጎ ኣጌና ያን ኣꬃናው ዞሬቲዶሶና። ፊንቄይ ፑዴሃ-ዉሎሃፔኔ ዱጌሃ-ዉሎሃፔ ጊዶን ኣባ ዶናን ዴዒያ ካታማ። ");
INSERT INTO gofENT_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","ካዉሻ ዱጌሃ ጫርኮይ ሎዳራ ጫርኪዳ ዎዴ ባንታ ቆፒዳይሳዳ ሃኒዳባ ዳኒን ዴንዲዲ፥ ማርካቤይ ቃፆና ሜላ ኦይኪያ ቢራታ ፑዴ ኤኪዲ ቃርፄሳ ማታራ ኣꬊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","ሺን ዳሮ ጋምዖና «ኣዉራቂስ» ጊያ ዎልቃማ ጎቴይ ሃꬃን ቴቄቲዳ ቢታፌ ዱጌ ኤንታ ቦላ ዴንዲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","ሄ ጎቴይ ማርካቢያ ሱጊዲ ኤፎና ዲጊዳ ጊሾ ጫርኮይ ማርካቢያ ባ ዶሲዳ ሶ ኤፊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","ኑኒ ቄዳ ጊያ ሃꬃን ቴቄቲዳ ቢታ ዜምፒዲ ቢሼ ዳሮ ሜቶቴቲዲ ማርካቢያ ዎጎሉዋ ኣሻናው ዳንዳዒዳ። ");
INSERT INTO gofENT_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","ኤንቲ ዎጎሉዋ ፑዴ ኬሲዳፔ ጉዬ ዎዶሩዋን ማርካቢያ ቦላ ፃፂዲ፥ ሚንꬂ ቃቺዶሶና። ሱርቲሳ ጊያ ሻፊያን ባንታና ዶምዔꬃና ጊዲ ሂርጊዲ፥ ማርካቢያ ሻራ ዎꬊሲዲ ማርካቢያ ጮ ዬዲ ኣጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","ጎቴይ ዎልቃሚሼ ቢን ዎንቴꬃ ጋላስ ጫናፔ ባጋ ኣባን ሆሎ ኦይኪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","ሄꬓንꬆ ጋላስ ማርካቢያ ሚሺያ ኤኪዲ ባንታ ኩሼን ሆሊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","ኑኒ ዳሮ ጋላስ ኣዋ ኣይፌኔ ፆሊንቶ ቤዖና ጊሾኔ ዎልቃማ ኡሾይ ኑ ቦላ ኡሺዳ ጊሾ ሲንꬃፌ ሼምፖራ ኣታና ጊዲ ቆፒቦኮ። ");
INSERT INTO gofENT_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","ሄ ዎዴ ኤንቲ ዳሮ ጋላስ ካꬂ ሞና ጋምዒዳ ጊሾ ጳዉሎሲ ኤንታ ጊዶን ዴንዲ ኤቂዲ፥ «ኣሳው፥ ሂንቴ ታ ዞሪያ ኤኪዲ ቃርፄሳፔ ዴንዶና ኣጊዳኮ ሃ ሜቶይኔ ቆሆይ ኑና ጋኬና። ");
INSERT INTO gofENT_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","ሺን ታኒ ሂንቴና ያዮፊቴ ጋዳ ዞራይስ፤ ኣይስ ጊኮ፥ ሃ ማርካቤይ ꬋያናፔ ኣቲን ሂንቴፌ ኢሲ ኣሳ ሼምፖይካ ꬋዬና። ");
INSERT INTO gofENT_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","ዚኔ ቃማ ታ ኢያባ ጊዲዳይሲኔ ታ ጎይኒያ ፆሳይ ኪቲዳ ኪታንቾይ ታ ማታን ኤቂዲ፥ ");
INSERT INTO gofENT_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","‹ጳዉሎሳ፥ ያዮፋ፤ ኔኒ ሮሜ ካዉዋ ቄሳሬ ሲንꬃን ኤቃናው ቤሴስ። ሄኮ ፆሳይ ኔ ጊሾ ኔራ ቢያ ኣሳ ኡባ ሼምፑዋ ኣሺስ› ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","ሄሳ ጊሾ፥ ኣሳው፥ ያዮፊቴ። ሄ ኪታንቾይ ታው ኦዲዳይሲ ሃናናይሳ ታኒ ኣማናይስ። ");
INSERT INTO gofENT_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","ሺን ጫርኮይ ኑና ኤፊዲ ኢሲ ሃꬃን ቴቄቲዳ ቢታ ጋፃን ሆላና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","ታማኔ ኦይዳንꬆ ቃማን ሜዲቲራኔ ኣባን ኑና ጫርኮይ ጌዴኔ ሃ ሱጊሺን፥ ጊዲ ቢላሄ ጊዲያ ዎዴ ማርካቢያን ኦꬄይሳታስ ቢታኮ ማቲዳባ ዳኒስ። ");
INSERT INTO gofENT_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","ኤንቲ ጪሞቴꬃ ኤራናው ኮዪዲ ዎዶሮ ፄራን ዴፂያባ ቃቺዲ ኣባን ዬጊን፥ ኣባይ ሆስፑን ታሙ ዋꬋ ጊዲስ። ጉꬂ ጋምዒዲ፥ ዛሪ ዬጊን ኡሱፑን ታሙ ዋꬋ ጊዲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","ኤንቲ ኣባ ጋፃን ዴዒያ ሹቻን ዶምዔቶና ሜላ ያዪዲ፥ ማርካቤይ ቦና ሜላ ኦይኪያ ኦይዱ ቢራታታ ማርካቢያፔ ጉዬራ ኣባን ዬጊዲ፥ ሳዓይ ዎንታና ሜላ ፆሳ ዎሶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","ማርካቢያን ኦꬄይሳቲ ማርካቢያፔ ባቃታናው ኮዪዲ፥ ማርካቤይ ቦና ሜላ ኦይኪያ ቢራታታ ማርካቢያፔ ሲንꬃ ባጋራ ኣባን ዬጊያ ዳኒን ዎጎሉዋ ኣባን ዬጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","ጳዉሎሲ ማቶ ሃላቃኮኔ ዎታዳሬታኮ፥ «ሃይሳቲ ማርካቢያን ሼምፒ ኡቶና ኢፂኮ ሂንቴ ኣታናው ዳንዳዔኬታ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","ሄሳ ጊሾ፥ ዎታዳሬቲ ዎጎሎይ ቃሼቲዳ ዎዶሩዋ ቃንፂዲ ዬዲ ኣጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","ሳዒ ዎንታና ሃኒሺን ኡባይ ካꬂ ማና ሜላ ጳዉሎሲ ኣሳኮ፥ «ሂንቴ ካꬂ ሞና ናጊሼ ሃቺራ ታማኔ ኦይዱ ጋላስ ጋምዒዴታ። ");
INSERT INTO gofENT_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","ሄሳ ጊሾ፥ ጉꬃ ካꬂ ሂንቴ ማና ሜላ ታኒ ሂንቴና ዎሳይስ። ሂንቴ ጋሽታና ሜላ ጉꬃ ካꬂ ማናው ኮሼስ፤ ሃሪ ኣቶሺን ሂንቴ ሁዔ ቢናናፔ ኢሶይካ ꬋዬና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","ጳዉሎሲ ሄሳ ጊዲ ኡይꬂ ኤኪዲ ኡባ ሲንꬃን ፆሳ ጋላቲስ፤ ኡይꬃ ሜንꬂዲ ሙሱ ዶሚስ። ");
INSERT INTO gofENT_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","ኡባይ ሚኔቲዲ ባንታው ካꬂ ኤኪዲ ሚዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","ኑኒ ማርካቢያን ዴዔይሳቲ ናምዑ ፄታኔ ላፑን ታማኔ ኡሱፑና። ");
INSERT INTO gofENT_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","ኤንቲ ሚዲ ካሊዳ ዎዴ ጫና ጊስቲያ ኣባን ዬጊዲ ማርካቢያ ዴፁዋ ካዉሺዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","ሳዒ ዎንቲዳ ዎዴ ማርካቢያ ኦሳንቾቲ ኣው ቢታ ጋኪዳኮ ኤሮናሺን፥ ኣባ ጋፃን ዴዒያ ሻፌኔ ሲሊሞ ቤዒዶሶና። ባንታው ዳንዳዔቲኮ ማርካቢያ ሄ ሻፊያኮ ሺሻናው ቆፒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","ያቲዲ፥ ማርካቤይ ቦና ሜላ ኦይኪያ ቢራታታ ቢርሺዲ ኣባን ዬጊዶሶና። ሄ ዎዴ ላጊያ ሚꬃ ቃቺያ ዎዶሩዋ ቢርሺዶሶና። ሄሳፌ ጉዬ፥ ጫርኮይ ማርካቢያ ሲንꬄ ሱጋና ሜላ ማርካቢያ ኤፊያ ሻራ ሲንꬃ ባጋራ ꬎቁ ኦꬂዲ ቡሱ ዶሚዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","ሺን ማርካቤይ ሻፌ ዶሬን ዶምዔቲዲ ሚቴቲስ። ማርካቢያስ ሲንꬃ ባጋይ ፁጉኒዲ ሻፊያ ጫዲ ኦይኪዲ ቃፆና ኢፂን፥ ጉዬ ባጋይ ዙሊያ ሱጌꬃን ሜቄሬቴꬂ ኦይኪስ። ");
INSERT INTO gofENT_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","ዎታዳሬቲ ቃሾ ኣሳፔ ኢሶይካ ሃꬃ ዋꬊዲ ኬሲ ኤኮና ሜላ ኤንታ ዎꬋናው ዞሬቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","ሺን ማቶ ሃላቃይ ጳዉሎሳ ኣሻናው ኮዪዲ ዎታዳሬታ ዞሬታ ኢፂስ። ሃꬄ ዋꬎ ኤሪያ ኡባይ ማርካቢያፔ ሃꬃን ጉፒ ጉፒ ዎꬊዲ ካሴቲዲ ጋፃ ኬያና ሜላ ኪቲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","ኣቲዳይሳቲ ሳንቃ ቦላኔ፥ ማርካቢያ ሜዑዋ ቦላ ኬያና ሜላ ኪቲስ። ሄሳዳ ሃኒዲ ኡባይ ጋፃ ሳሮራ ኬዪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","ኑኒ ጋፃ ሳሮ ኬዪዳ ዎዴ ጋኪዳ ሃꬃን ቴቄቲዳ ቢታይ ማልታ ጌቴቴይሳ ኤሪዳ። ");
INSERT INTO gofENT_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","ማልታ ኣሳይ ኑስ ዳሮ ኬሃ ኬሂዶሶና። ኢሪ ቡኪያ ጊሾኔ ሜጊያ ጊሾ ታማ ኤꬂዲ ኑና ኡባ ሞኪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","ጳዉሎሲ ዳሮ ኣፊራ ሺሺዲ ታማን ዎꬂሺን፥ ሾሺ ሴላ ጊሾ ኬዪዲ ኢያ ኩሺያ ቦላ ፃፄቲዲ ኢያ ዱኪስ። ");
INSERT INTO gofENT_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","ማልታ ኣሳይ ሾሺ ጳዉሎሳ ኩሼን ፃፄቲዳይሳ ቤዒዳ ዎዴ ኢሶይ ኢሱዋኮ፥ «ቱማ ሃ ኡራይ ሼምፖ ዎꬊዳ ኣሲ፤ ሃሪ ኣቶሺን ኣባፌ ኢ ኣቲንካ ፆሳ ፒርዳፌ ኣቲዲ ፓፃ ዳናው ዳንዳዒቤና» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","ሺን ጳዉሎሲ ባ ኩሺያፔ ሾሻ ዉፃርኪዲ፥ ታማን ዬጊስ፤ ኢያ ኣይኮካ ቆሂቤና። ");
INSERT INTO gofENT_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","ኤንቲ፥ «ኢያ ኣሳቴꬃይ ኪፄስ፥ ዎይኮ ኣኬኮና ኩንዲዲ ሃይቄስ» ጊዲ ናጎሶና። ሺን ዳሮ ዎዴ ናጊዲ ኢያ ኣሳቴꬃን ኣይቢካ ዱማቲዳባይ ꬋዪን፥ «ሃይሲ ፆሴ» ያጊዲ ባንታ ቆፋ ላሚዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","ሄ ሄራን ሃꬃን ቴቄቲዳ ቢታ ሃላቃ፥ ፑፕሊዮሳ ጌይሳስ ጋዴይ ዴዔስ፤ ሄꬑ ጋላስ ጋካናው ኢ ኑና ሲቆን ሞኪስ። ");
INSERT INTO gofENT_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","ፑፕሊዮሳ ኣዋይ ቆፆ፥ ሚሻኔ ኡሎ ኡቲሶን ሃርጌቲዲ ዚንዒዲ ዴዔስ። ጳዉሎሲ ኢያ ሶ ጌሊዲ ኢያው ፆሳ ዎሲስ፤ ባ ኩሺያ ኢያ ቦላ ዎꬂዲ ፓꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","ሄሳፌ ጉዬ፥ ማልታን ዴዒያ ሃርጊያ ሃራ ኣሳቲካ ዪዲ ፓፂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","ኤንቲ ኑና ዳሮ ቦንቺዶሶና፤ ኑኒ ማርካቤራ ባናው ዴንዲዳ ዎዴ ኦጌስ ኮሺያባ ኑስ ኢሚዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","ሄꬑ ኣጌናፔ ጉዬ፥ ማልታን ባልጎ ኣꬂዲ ኢስኪንዲሪያ ማርካቤራ ባናው ዴንዲዳ። ሄ ማርካቢያ ቦላ ዲዮስቆሮሳ ጊያ ሜንቴ ኤቃታ ሚሲሌይ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","ሲራኩሴ ካታማ ጌሊዲ ያን ሄꬑ ጋላስ ኡቲዳ። ");
INSERT INTO gofENT_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","ያፔ ዴንዲዲ ሬጊዩሜ ካታማ ጋኪዳ። ኢሲ ጋላሳፔ ጉዬ፥ ዱጌሃ ባጋ ጫርኮይ ጫርኪን፥ ዎንቴꬃ ጋላስ ፑቲዮሌ ካታማ ጋኪዳ። ");
INSERT INTO gofENT_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","ያን ኑኒ ኢሲ ኢሲ ኣማኒያ ኣሳታ ዴሚን፥ ባንታራ ሳሚንታ ጋምዓና ሜላ ኑና ዎሲዶሶና። ሄሳፌ ጉዬ፥ ሮሜ ቢዳ። ");
INSERT INTO gofENT_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","ሮሜን ዴዒያ ኣማኒያ ኣሳቲ ኑባ ሲዒዲ፥ ኣፊዮሳ ጊያን፥ ሄꬑ ኣቂያሶ ጊያ ቤሳ ጋካናው ኑና ሞካናው ዪዶሶና። ጳዉሎሲ ኤንታ ቤዒዳ ዎዴ ፆሳ ጋላቲዲ ሚኔቲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","ኑኒ ሮሜ ጌሊዳ ዎዴ ጳዉሎሲ ባና ናጊያ ዎታዳሪያራ ባርካ ዴዖ ጌቴቲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","ሄꬑ ጋላሳፔ ጉዬ፥ ጳዉሎሲ ኣይሁዴታ ሃላቃታ ባኮ ፄጊሲስ። ኤንቲ ሺቂዳ ዎዴ ኤንታኮ፥ «ታ ኢሻቶ፥ ታኒ ኑ ኣሳ ዎይኮ ኑ ኣዋታ ዎጋ ቦላ ኣይቢ ቆሆካ ኦꬃቢኬ፥ ሺን ታና ዬሩሳላሜን ቃቺዲ ሮሜ ኣሳስ ኣꬂዲ ኢሚዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","ኤንቲ ታ ሞቱዋ ቤዒዲ ሃይቆስ ጋꬂያባ ታ ቦላ ኣይቢባካ ዴሚቦና ጊሾ ታና ቢላናው ቆፒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","ሺን ኣይሁዴቲ ሄሳ ኢፂዳ ዎዴ ‹ታባ ቄሳሬይ ፒርዶ› ያጋሲፔ ኣቲን ታኒ ታ ዴሪያ ሞቲያባይ ዴዒን ጊዴና። ");
INSERT INTO gofENT_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","ታኒ ሂንቴና ፄጊሲዳይ ሂንቴና ቤዓናዉኔ ሂንቴው ሃይሳ ኦዳናሳ። ታኒ ሃ ሳንꬃላታን ቃሼቲዳይ ኢስራዔሌ ኣሳይ ናጊያ ኡፋይሳ ጊሾሳ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","ኣይሁዴ ሃላቃቲ ጳዉሎሳኮ፥ «ኑስ ዪሁዳፔ ኔባ ፃፌቲዳ ዳብዳቤይ ጋኪቤና። ያፔ ዪዳ ኣሳታፔ ኢሶይካ ኔባ ኢታ ኦዲዳይ ባዋ። ");
INSERT INTO gofENT_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","ሺን ሃ ኔ ካሊያ ኣማኑዋ ዱማ ዱማ ቤሳን ኣሳይ ኢፄይሳ ኑኒ ኤሪያ ጊሾ ኔ ቆፋ ሲዓናው ኮዮስ» ያጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","ኤንቲ ባንታ ያና ጋላስ ጳዉሎሳስ ቃፃሪዲ፥ ሄ ጋላስ ዳሪዲ ኢ ዴዒያሱዋ ዪዶሶና። ኢ ዎንታፌ ኦማርሲ ጋካናው ፆሳ ካዎቴꬃባ ኤንታው ማርካቲስ። ቃሲ ኤንቲ ዬሱሳባ ኣማናና ሜላ ሙሴ ሂጊያፌኔ ናቤታ ማፃፋፔ ቆንጪሲዲ ኤንታ ታማርሲስ። ");
INSERT INTO gofENT_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","ኢሶቲ ኢሶቲ ጳዉሎሲ ጊዳይሳ ኣማኒዶሶና፥ ሺን ሃራቲ ኣማኒቦኮና። ");
INSERT INTO gofENT_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","ኤንቲ ባንታ ጊዶን ኦዳ ማዖና ኢፂዳ ዎዴ ጳዉሎሲ ኢሲባ ጊዳፔ ጉዬ ቢዶሶና። ኢ ሃይሳዳ ያጊስ፡ «ጌሻ ኣያናይ ኑ ኣዋታስ ናቢያ ኢሳያሳ ዶናን ኦዲዳይሲ ቱማ። ");
INSERT INTO gofENT_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","‹ኔኒ ሄ ኣሳኮ ባዳ፥ ሂንቴ ሲሳ ሲዔታ፥ ሺን ሂንቴው ጌሌና፤ ሂንቴ ቤዖ ቤዔታ፥ ሺን ዴሜኬታ። ");
INSERT INTO gofENT_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","ሃ ኣሳ ዎዛናይ ሙሚስ፤ ኤንታ ሃይꬃይ ቱሊስ፤ ኤንታ ኣይፌይካ ጎዜቲስ። ሄሲ ባይኔኮ፥ ኤንቲ ባንታ ኣይፊያን ቤዒዲ፥ ባንታ ሃይꬃን ሲዒዲ፥ ባንታ ዎዛናን ኣኬኪዲ፥ ኤንቲ ታኮ ሲማና፤ ታካ ኤንታ ፓꬃናሺን› ያጋ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","«ሂዛ፥ ሃይሲ ፆሳ ኣቶቴꬃ ኪታይ ኣይሁዴ ጊዶናይሳታስ ጊዴይሳ ኤሬታ። ኤንቲካ ሲዓና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","ጳዉሎሲ ሄሳ ጊዳፔ ጉዬ ኣይሁዴቲ ባንታ ጊዶን ዳሮ ፓላሚሼ ኬዪዲ ቢዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","ጳዉሎሲ ኬራ ኬꬃን ናምዑ ላይꬂ ኩሜꬂ ዴዒስ፤ ያን ዴዒሼ ባኮ ያ ኡባ ሞኬስ። ");
INSERT INTO gofENT_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","ያሺ ባይናኔ ኦኒካ ዲጎናሺን ፆሳ ካዎቴꬃባ ሳባኪስ፤ ጎዳ ዬሱስ ኪሪስቶሳባ ቆንጪሲዲ ታማርሴስ። ");
INSERT INTO gofENT_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","ዬሱስ ኪሪስቶሳ ኣይሌ ጊዲዳ፥ ሃዋሬ ጊዳና ሜላ ፄጌቲዳይሳፌኔ ፆሳ ዎንጌላ ሳባካና ሜላ ዶሬቲዳ ጳዉሎሲ ኪቲዳ ኪታ። ");
INSERT INTO gofENT_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","ፆሳይ ዳሮ ዎዴፔ ሲንꬄ ባ ናቤታ ባጋራ ኢማና ያጊዳ ፆሳ ዎንጌላይ ጌሻ ማፃፋታን ፃፌቲስ። ");
INSERT INTO gofENT_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","ሄ ዎንጌላይ ኣሾን ዳዊቴ ሼሻፔ ዬሌቲዳ፥ ፆሳ ናዓ፥ ኑ ጎዳ ዬሱስ ኪሪስቶሳባ። ");
INSERT INTO gofENT_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","ቃሲ ኢ ባ ጌሻ ኣያናን ሃይቆፔ ዴንዲዲ፥ ፆሳ ናዓ ጊዴይሳ ጊታ ዎልቃን ቤሲስ። ");
INSERT INTO gofENT_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","ኢያ ባጋራ ኣይሁዴ ጊዶና ኣሳ ኡባይ፥ ኣማኒዲ ኪቴታና ሜላ ኪሪስቶሳ ሱንꬃ ጊሾ ፆሳይ ኣꬎ ኬሃቴꬂኔ ሃዋሬቴꬃ ማታ ኑስ ኢሚስ። ");
INSERT INTO gofENT_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","ዬሱስ ኪሪስቶሳስ ጊዳና ሜላ ፄጌቲዳ ኣሳታፔ ባጋቲ ሂንቴና። ");
INSERT INTO gofENT_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","ሮሜን ዴዒያ፥ ፆሳይ ሲቄይሳታሲኔ ኢያ ጌሻ ዴሬ ጊዳና ሜላ ዶሪዳይሳታስ። ፆሳ ኑ ኣዋፔኔ ጎዳ ዬሱስ ኪሪስቶሳፔ ኣꬎ ኬሃቴꬃይኔ ሳሮቴꬃይ ሂንቴው ጊዶ። ");
INSERT INTO gofENT_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","ኡባፌ ኮይሮታዳ፥ ሂንቴ ኣማኖይ ቢታ ኡባን ሲዔቲዳ ጊሾ ዬሱስ ኪሪስቶሳ ባጋራ ሂንቴ ጊሾ ታ ፆሳ ጋላታይስ። ");
INSERT INTO gofENT_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","ታኒ ኢያ ናዓ ዎንጌላባ ኩሜꬃ ዎዛናን ኦዲያ ፆሳይ፥ ታኒ ታ ዎሳን ኡባ ዎዴ ሂንቴና ቆፔይሳስ ኢ ማርካ። ");
INSERT INTO gofENT_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","ዉርሴꬃን፥ ፆሳ ሼኔ ጊዲኮ፥ ታኒ ሂንቴኮ ባናው ኦጌይ ታው ኢንጄታና ሜላ ኡባ ዎዴ ዎሳይስ። ");
INSERT INTO gofENT_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","ታኒ ሂንቴው ኣያና ኢሙዋ ሻካናዉኔ ሂንቴና ቤዓናው ላሞታይስ። ");
INSERT INTO gofENT_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","ሄሲካ፥ ታኒ ሂንቴ ኣማኑዋን፥ ቃሲ ሂንቴ ታ ኣማኑዋን ሚኔታና ሜላሳ። ");
INSERT INTO gofENT_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","ታ ኢሻቶ፥ ታኒ ኣይሁዴ ጊዶና ኣሳፔ ኣይፌ ዴሚዳይሳዳ፥ ሂንቴፌካ ኣይፌ ዴማናው ሂንቴኮ ባናው ቆፓስ፥ ሺን ዲጌታስ። ");
INSERT INTO gofENT_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","ታማሪዳ ኣሳሲኔ ታማሪቦና ኣሳስ ቃሲ ጪንጫታሲኔ ኤያታስ ታው ኣጮይ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","ሄሳ ጊሾ፥ ሮሜን ዴዒያ ሂንቴዉካ ዎንጌላ ኦዳናው ኣሞታይስ። ");
INSERT INTO gofENT_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","ኢያ ኣማኒያ ኡባ፥ ኮይሮቲዲ ኣይሁዴታ፥ ካሊዲ ኣይሁዴ ጊዶናይሳታ ኣሻናው ዎንጌላይ ፆሳ ዎልቃ ጊዲያ ጊሾ ታ ዎንጌላን ዬላቲኬ። ");
INSERT INTO gofENT_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","ፂሎይ ኣማኖን ዴዖን ዳና ጌቴቲዲ ጌሻ ማፃፋን ፃፌቲስ። ዎንጌላን ፆሳ ፂሎቴꬃይ ቆንጪስ፤ ኮይሮፔ ዉርሴꬂ ጋካናው ኣሳይ ፂሌይ ኣማኖና። ");
INSERT INTO gofENT_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","ቱማይ ኤሬቶና ሜላ ባንታ ኢታ ኦሶን ካሚያ ኣሳ ቦላኔ ናጋራ ኡባ ቦላ፥ ፆሳ ሃንቆይ ሳሎፔ ዎꬌስ። ");
INSERT INTO gofENT_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","ፆሳይ ኤንታው ቆንጫናው ቤሲያባ ቆንጪሲዳ ጊሾ ኤንቲ ፆሳባ ኤሮሶና። ");
INSERT INTO gofENT_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","ኣላሜይ ሜꬌቶሳፔ ዶሚዲ፥ ኣሳስ ቤንቶና ፆሳ ካንዶይ፥ ሄሲካ ኢያ ሜሪና ዎልቃይኔ ፆሳቴꬃይ ኢያ ሜꬌቴꬃን ቆንጪዲ ዴዒያ ጊሾ ኣሳይ ባንታ ኢታቴꬃስ ጋሶያባይ ባዋ። ");
INSERT INTO gofENT_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","ኤንቲ ፆሳ ኤሪሼ፥ ኢያ ቦንቺቦኮናኔ ጋላቲቦኮና። ኤንታ ቆፋይ ማዶናባ ጊዲስ፤ ኤንታ ኣኬኮና ዎዛናይ ꬉሚስ። ");
INSERT INTO gofENT_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","ኤንቲ ባንታና ጪንጫታ ጎሶና፥ ሺን ኤያታ። ");
INSERT INTO gofENT_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","ኤንቲ ሃይቆና ፆሳ ጎይናናይሳ ኣጊዲ፥ ሃይቂያ ኣሳ ሜꬎን፥ ካፎታ ሜꬎን፥ ዶዓታ ሜꬎኒኔ ኡሎራ ጎሼቲያባታ ዳኒሲዲ ኦꬂዳ ሚሲሌታ ጎይኒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","ሄሳ ጊሾ፥ ኤንቲ ኢሶይ ኢሱዋራ ቦርሶባ ኦꬂዲ፥ ባንታ ኣሳቴꬃ ካዉሻና ሜላ ፆሳይ ኤንታ ዎዛናይ ኣሞቲያ ቱና ኦሶስ ኤንታ ዬጊ ኣጊስ። ");
INSERT INTO gofENT_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","ሄሲ ሃኒዳይ ኤንቲ ፆሳ ቱማ ዎርዶን ላሚዳ ጊሾኔ ሜꬊዳ ፆሳ ኣጊዲ፥ ሜꬌቴꬂ ጎይኒዳ ጊሾሳ። ፆሳይ ሜሪናው ጋላቴቲዳይሳ። ኣሚንዒ። ");
INSERT INTO gofENT_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","ሄሳ ጊሾ፥ ፆሳይ ኤንታና ኤንታ ቦርሶ ኣሙዋስ ዬጊ ኣጊስ። ኤንታ ማጫሳይ ባንታው ቤሲያ ኣዴራ ጋሄቴꬂ ኣጊዲ፥ ቤሶናባ ሃኒዲ ማጫሲ ማጫሳራ ጋሄቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","ሄሳዳካ፥ ኣዴቲ ባንታው ቤሲያ ማጫሳራ ጋይቴꬂ ኣጊዲ፥ ኣዴይ ኣዴራ ጋሄቲዶሶና። ኣዴቲ ኢሶይ ኢሱዋራ ኣሞን ፁጌቲዲ፥ ቦርሶባ ኦꬂዶሶና። ባንታ ኦꬂዳ ባላስ ቤሲያ ፒርዳ ኤኪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","ኤንቲ ፆሳ ኤሪሼ፥ ሃሪ ኣቶሺን ኢያባ ቆፓናው ኮዮና ኢፂዳ ጊሾ ቤሶናባ ኦꬃና ሜላ ፆሳይ ኤንታና ፓꬆና ቆፋስ ኣꬂ ኢሚስ። ");
INSERT INTO gofENT_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","ኤንታን ጌላቴꬂ፥ ኢታቴꬂ፥ ዪቄይ፥ ጌኔይ፥ ቃናቴይ፥ ሼምፖ ዎꬎይ፥ ፓላሚ፥ ጪሞይኔ ኢታ ኣሞይ ኩሚስ። ኤንቲ ዚጊሬይሳታ፥ ");
INSERT INTO gofENT_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","ኣሳ ሱንꬂ ኢሴይሳታ፥ ፆሳ ኢፄይሳታ፥ ጫዬይሳታ፥ ኦቶሬይሳታ፥ ጬቄቴይሳታ፥ ኢታባ ኦꬃናው ኮዬይሳታኔ ባንታ ኣዬሲኔ ኣዋስ ኪቴቶናይሳታ፥ ");
INSERT INTO gofENT_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","ኣኬኮናይሳታ፥ ጫቆ ሜንꬄይሳታ፥ ሲቆይ ባይናይሳታ፥ ቃꬌይ ባይናይሳታ። ");
INSERT INTO gofENT_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","ሃይሳታ ሜላ ኦꬄይሳታስ ሃይቆይ ቤሴስ ጊያ ፆሳ ሂጊያ ኤሪሼ፥ ሃይሳታ ኦꬆሶና። ኤንቲ ባንታው ኦሶ ፃላላ ጊዶናሺን ኦꬂያ ሃራታካ ናሾሶና። ");
INSERT INTO gofENT_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","ሄሳ ጊሾ፥ ኔኖ ሃራታ ቦላ ፒርዴይሶ፥ ኔኒ ጋሶያባይ ባዋ። ኔኒ ሃራታ ቦላ ፒርዳሼ፥ ሄ ኔኒ ፒርዲያ ኡራ ሜላ ኦꬂኮ፥ ኔ፥ ኔ ቦላ ፒርዳሳ። ");
INSERT INTO gofENT_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","ሄሳ ሜላ ኦሶ ኦꬄይሳታ ቦላ ፆሳይ ፂሎ ፒርዳ ፒርዴይሳ ኑ ኤሮስ። ");
INSERT INTO gofENT_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","ኔኖ፥ ሄሳ ሜላ ኦሶ ኦꬄይሳታ ቦላ ፒርዴይሶ፥ ኤንቲ ኦꬄይሳ ሜላ ኦꬄይሶ፥ ኔኒ ፆሳ ፒርዳፌ ኣታናባ ዳኒ? ");
INSERT INTO gofENT_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","ዎይኮ ፆሳ ኬሃቴꬃ፥ ጌንጫኔ ዳንዳዓ ዳሮቴꬃ ካꬋዬ? ፆሳይ ኔው ኬሂዳይ ኔና ናጋራፔ ዛራናው ጊዴይሳ ኤሪኪዬ? ");
INSERT INTO gofENT_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","ሺን ሂንቴው ሹቻ ዎዛኒኔ ሲዖና ሃይꬂ ዴዔስ። ሄሳ ጊሾ፥ ፆሳ ሃንቆይኔ ፂሎ ፒርዳይ ቆንጪያ ጋላስ፥ ኔ ቦላ ፒርዳይ ዳራና ሜላ ኦꬃሳ። ");
INSERT INTO gofENT_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","ፆሳይ ኢሱዋስ ኢሱዋስ ኢያ ኦሱዋ ሜላ ኢማና። ");
INSERT INTO gofENT_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","ሎዖ ኦሶን ሚኒዲ፥ ጋላታ፥ ቦንቾኔ ꬋዮና ዴዑዋ ኮዬይሳታስ ፆሳይ ሜሪና ዴዑዋ ኢማና። ");
INSERT INTO gofENT_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","ሺን ባንታና ሲቄይሳታ፥ ቱማ ኢፄይሳታኔ ኢታባ ኦꬃናው ኮዬይሳታ ቦላ ፆሳ ሃንቆይኔ ፒርዳይ ያና። ");
INSERT INTO gofENT_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","ኢታባ ኦꬂያ ኣሳ ኡባ፥ ኮይሮቲዲ ኣይሁዴታ፥ ካሊዲ ኣይሁዴ ጊዶና ኣሳ ሜቶይኔ ዋዬይ ጋካና። ");
INSERT INTO gofENT_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","ሺን ፆሳይ ሎዖ ኦሶ ኦꬂያ ኡባስ፥ ኮይሮቲዲ ኣይሁዴታስ፥ ካሊዲ ኣይሁዴ ጊዶናይሳታስ ጋላታ፥ ቦንቾኔ ሳሮቴꬃ ኢማና። ");
INSERT INTO gofENT_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","ፆሳይ ሶምዖ ቤዒዲ ኣሴ ሻኬና። ");
INSERT INTO gofENT_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","ሂጌይ ባይና ናጋራ ኦꬂዳ ኡባይ ሂጌይ ባይና ꬋያና። ሂጌይ ዴዒሺን፥ ናጋራ ኦꬂዳ ኡባይ ሂጌን ፒርዴታና። ");
INSERT INTO gofENT_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","ፆሳ ሲንꬃን ፂሌይሳቲ ሂጌ ናጌይሳታፔ ኣቲን ሂጌ ሲሳ ፃላላ ሲዔይሳታ ጊዶኮና። ");
INSERT INTO gofENT_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","ሂጌይ ባይና ኣይሁዴ ጊዶና ኣሳይ ሜꬎን ሂጌይ ኪቴይሳ ኦꬆሶና። ኤንታው ፃፌቲዳ ሂጌይ ባይና ኢፂኮካ ኤንቲ ባንታ ዎዛናን ሂጊያ ኤሮሶና። ");
INSERT INTO gofENT_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","ኤንታ ሃኖታይ፥ ሂጌ ኪታይ ኤንታ ዎዛናን ፃፌቲዳይሳ ቤሴስ። ቃሲ ኤንታ ካሃይ ኤንታ ቦላ ማርካቴስ። ኤንታ ቆፋይ ኢሲ ኢሲ ቶሆ ኤንታና ባላ ጌስ፤ ኢሲ ኢሲ ቶሆ ኤንታና ሊኬ ጌስ። ");
INSERT INTO gofENT_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","ታ ታማርሲዳ ዎንጌላ ሜላ ፆሳይ ዬሱስ ኪሪስቶሳ ባጋራ ኣሳ ዎዛናን ጌሚዳ ቆፋ ፒርዲያ ዎዴ ሄሲ ኤሬታና። ");
INSERT INTO gofENT_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","ሺን ኔ ኔና ኣይሁዴ ጋሳ፤ ሂጌን ዜምፓሳ፤ ፆሳን ጬቃሳ። ");
INSERT INTO gofENT_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","ኔ ኦꬃና ሜላ ፆሳይ ኮያባይ ኣይቤኮ ኤራሳ። ሂጊያ ታማሪዳ ጊሾ ቱማ ጊዲያባ ዶራናው ኤራሳ። ");
INSERT INTO gofENT_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","ኔኒ ቆቄታ ካሌꬄይሳ፥ ቃሲ ꬉማን ዴዔይሳታስ ፖዖ ጊዴይሳ ሻካ ኤራሳ። ");
INSERT INTO gofENT_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","ኔኒ ሂጊያፌ ዴሚዳ ኤራቴꬃኒኔ ቱማቴꬃን ኤያታ ኤሪሴይሳኔ ዮጋታ ታማርሴይሳ ጊዴይሳ ኤራሳ። ");
INSERT INTO gofENT_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","ያቲን፥ ኔ ሃራታ ታማርሴይሲ ኔ ኔና ኣይስ ታማርሲኪ? ኔኒ፥ «ካይሶቶፓ» ጋሼ፥ ኔኒ ኔ ሁዔን ካይሶታዬ? ");
INSERT INTO gofENT_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","ኔኒ፥ «ላሞፋ» ጋሼ፥ ኔኒ ኔ ሁዔን ላማዬ? ኔኒ ኤቃ ኢፃሼ፥ ኤቃይ ዴዒያ ኬꬃ ቦንቃዬ? ");
INSERT INTO gofENT_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","ኔኒ ፆሳ ሂጊያን ጬቄታሳ፥ ሺን ሂጊያስ ኪቴቶና ኢፃዳ ፆሳ ዬላያይ? ");
INSERT INTO gofENT_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","ጌሻ ማፃፋን፥ «ሂንቴ ጋሶን ፆሳ ሱንꬃይ ኣይሁዴ ጊዶና ኣሳታን ጫዬቴስ» ጌቴቲዲ ፃፌቲስ። ");
INSERT INTO gofENT_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","ኔ ሂጌስ ኪቴቲኮ፥ ኔ ቃፃሬቴꬃስ ማዴይ ዴዔስ፥ ሺን ኔኒ ሂጊያስ ኪቴቶና ኢፂኮ ኔ ቃፃሬቴꬃይ ቃፃሬቲቦና ሜላ ጊዴስ። ");
INSERT INTO gofENT_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","ኣይሁዴ ጊዶና ኣሲ ቃፃሬቶና ዴዒሼ፥ ሂጊያስ ኪቴቲኮ፥ ፆሳይ ኢያ ቃፃሬቲዳ ሜላ ታይቤኔ? ");
INSERT INTO gofENT_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","ሂንቴ፥ ኣይሁዴ ኣሳቲ፥ ሂንቴው ፃፌቲዳ ሂጌይኔ ቃፃሮይ ዴዒሺን፥ ሂንቴ ሂጌስ ኪቴቶና ኢፂኮ፥ ኣይሁዴ ጊዶና ኣሳይ ቃፃሬቶና ኢፂኮካ ሂጌስ ኪቴቲዲ፥ ሂንቴ ቦላ ፒርዳና። ");
INSERT INTO gofENT_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","ሂዛ፥ ሱንꬃን ኣይሁዴ ጊዲዳ ኡባይ ቱማ ኣይሁዴ ጊዴና። ቃሲ ካሬ ኣሳቴꬃ ቃፃሮይ ቱማ ቃፃሮ ጊዴና። ");
INSERT INTO gofENT_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","ሺን ቱማ ኣይሁዴቴꬂ ጋꬃ ባጋን ኣይሁዴ ጊዴይሳ። ቱማ ቃፃሬቴꬂ ፆሳ ኣያናን ኦሴቲያ ዎዛና ቃፃሬቴꬃፌ ኣቲን ፃፌቲዳ ሂጊያን ኦሴቲያ ኣሳቴꬃ ቃፃሮ ጊዴና። ሄ ኡራይ ጋላታ ፆሳፌ ኤኬሲፔ ኣቲን ኣሳፔ ጊዴና። ");
INSERT INTO gofENT_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","ያቲን፥ ኣይሁዴ ጊዶን ኣይ ዱማቴꬂ ዴዒ? ዎይኮ ቃፃሬቴꬃን ኣይ ማዴይ ዴዒ? ");
INSERT INTO gofENT_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","ቱማካ ኣይሁዴ ጊዶይ ዳሮ ኦጌራ ማዴስ። ኡባፌ ሲንꬄ ፆሳይ ባ ቃላ ሃዳራ ኣይሁዴታስ ኢሚስ። ");
INSERT INTO gofENT_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","ያቲን፥ ኤንታፌ ኢሶቲ ኢሶቲ ቃላ ኣማኖና ኢፂኮ፥ ኤንታ ኢፆይ ፆሳ ኣማኔቴꬃ ዲጊዬ? ");
INSERT INTO gofENT_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","ዲጌና! ኣሳ ኡባይ ዎርዳንቾ ጊዲኮካ ፆሳይ ቱማ ጊዶ። ጌሻ ማፃፋን፥ «ኔ ቃላን ኔ ፂላሳ፤ ኔና ሞቴይሳ ፒርዳን ላꬃሳ» ጌቴቲዲ ፃፌቲስ። ");
INSERT INTO gofENT_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","ያቲን፥ ኑ ናጋራይ ፆሳይ ፂሎ ጊዴይሳ ቤሲያባ ጊዲኮ፥ ኑ ዎይጋኔ? ፆሳይ ኑ ናጋራ ጊሾ ኑ ቦላ ፒርዲኮ፥ ሊኬ ጊዴኔዬ? ሃይሳ ታኒ ኣሳ ቆፋꬆ ጋይስ። ");
INSERT INTO gofENT_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","ሄሲ ኡባራካ ሃኔና። ሄሳዳ ሃኒኮ፥ ፆሳይ ሃ ኣላሚያ ቦላ ዋቲ ፒርዳኔ? ");
INSERT INTO gofENT_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","ሺን ታ ዎርዶቴꬃይ ፆሳ ቱማ ቆንጪሲዲ፥ ኢያ ቦንቹዋ ዳርሲ ቤሲያባ ጊዲኮ፥ ያቲን፥ ኣይስ ታ ቦላ ናጋራንቾዳ ፒርዴቲ? ");
INSERT INTO gofENT_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","ኢሲ ኢሲ ኣሳይ፥ «ሎዖይ ያና ሜላ ኢታ ኦꬆስ» ያጊዲ ታማርሲያዳ ኦꬂዲ ታና ሞቶሶና። ሄሳ ሜላ ኣሳ ቦላ ያ ፆሳ ፒርዳይ ሊኬ። ");
INSERT INTO gofENT_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","ያቲን፥ ኑኒ ዎይጋኔ? ኑ ኣይሁዴቲ፥ ኣይሁዴ ጊዶናይሳታፔ ኣꬎናዬ? ጊዴና! ኣይሁዴ ጊዲን፥ ኣይሁዴ ጊዶና ኢፂን ኡባይ ናጋራንቾ ጊዴይሳ ታኒ ካሴታዳ ሂንቴው ኦዳስ። ");
INSERT INTO gofENT_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","ጌሻ ማፃፋን፥ «ፂሎ ኣሲ ኢሶይካ ባዋ። ");
INSERT INTO gofENT_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","ኣኬኪያ ኣሲ ባዋ፥ ፆሳ ኮያ ኦኒካ ባዋ። ");
INSERT INTO gofENT_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","ኣሳ ኡባይ ፆሳስ ዞኮ ዛሪዶሶና፤ ኡባይ ኢሲፌ ፓꬆናባ ጊዲዶሶና። ሎዖ ኦꬂያ ኦኒካ ባዋ፤ ኢሲ ኣሲካ ባዋ። ");
INSERT INTO gofENT_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","ኤንታ ዶናፔ ኬያ ቃላይ፥ ዶዬቲዳ ዱፎፔ ኬያ ፂንቆ ሜላ፤ ባንታ ኢንፃርሳን ጪሞሶና። ኤንታ ዶናፔ ኣሴ ዎꬊያ፥ ሾሻ ማርዜይ ኬዬስ። ");
INSERT INTO gofENT_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","ኤንታ ዶናን ጫሞ ኦዳይኔ ባዴꬂ ኩሚስ። ");
INSERT INTO gofENT_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","ኤንቲ ሱꬂ ጉሳናው ኤሌሶሶና። ");
INSERT INTO gofENT_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","ኤንታ ኦጊያን ꬋዮይኔ ቆሆይ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","ኤንቲ ሳሮቴꬃ ኦጊያ ኤሮኮና። ");
INSERT INTO gofENT_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","ባንታ ዴዑዋን ፆሳስ ያዮኮና» ጌቴቲዲ ፃፌቲስ። ");
INSERT INTO gofENT_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","ኣሴ ኡባ ዶና ኦይꬃናዉኔ ኩሜꬃ ኣላሚያ ፆሳ ፒርዳፌ ጋርሳን ሺሻናው፥ ሂጌይ ኢሜቲዳይ ሂጌፌ ጋርሳን ኣቄይሳታስ ጊዴይሳ ኑ ኤሮስ። ");
INSERT INTO gofENT_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","ሄሳ ጊሾ፥ ኦኒካ ሂጌስ ኪቴቲዲ ፆሳ ሲንꬃን ፂላናው ዳንዳዔና። ሂጌይ ኣሲ ኡባይ ናጋራንቾ ጊዴይሳ ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","ሺን ሃዒ ፆሳይ ኣሲ ሂጌይ ባይናሺን ፂሊያ ኦጌ ቆንጪሲስ። ሄ ኦጊያ ሙሴ ሂጌይኔ ናቤቲ ማርካቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","ሃ ፂሎቴꬃ፥ ፆሳይ ዬሱስ ኪሪስቶሳ ባጋራ ኣሳ ኡባስ ሻኮይ ባይና ኢሜስ። ");
INSERT INTO gofENT_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","ኣሳ ኡባይ ናጋራ ኦꬂዶሶና፤ ፆሳይ ኤንታው ኢሚዳ ቦንቹዋፌ ሃኪዲ ኣቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","ሺን ኤንቲ ፆሳ ኣꬎ ኬሃቴꬃን፥ ዎዚያ ኪሪስቶስ ዬሱሳ ባጋራ ጮ ፂሊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","ፆሳይ ዬሱስ ኪሪስቶሳ ያርሾ ኦꬂዲ ኢሚዳይ፥ ኢያ ኣማኒያ ኡባይ ኢያ ሱꬃን ናጋራ ማሮቴꬂ ዴማና ሜላሳ። ፆሳይ ሄሳ ኦꬂዳይ ባ ዳንዳዓን ካሴ ናጋራ ታይቦና ኣጊዲ፥ ባ ፂሎቴꬃ ቤሳናሳ። ");
INSERT INTO gofENT_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","ሃዒ ዎዲያን ዬሱሳ ኣማኒያ ኡባ ፂሊሲዲ፥ ፆሳይ ባ ሁዔን ፂሎ ጊዴይሳ ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","ያቲን፥ ኑ ጬቄቲያባይ ኣይቢ ዴዒ? ኣይቢካ ባዋ። ኑኒ ጬቄቴይ ሂጌስ ኪቴቲያ ጊሾዬ? ኣካይ! ኣማኖ ጊሾሳ። ");
INSERT INTO gofENT_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","ፆሳይ ኣሴ ፂሊሴይ ኣማኖናፔ ኣቲን ሂጌስ ኪቴቴꬃን ጊዶናይሳ ኑ ኣኬኮስ። ");
INSERT INTO gofENT_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","ዎይኮ ፆሳይ ኣይሁዴታ ፃላላ ፆሴዬ? ኣይሁዴ ጊዶናይሳታስ ፆሴ ጊዴኔዬ? ቱማ፥ ኣይሁዴ ጊዶናይሳታስካ ኢ ፆሴ። ");
INSERT INTO gofENT_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","ፆሳይ ኢሶ፤ ኣይሁዴታኔ ኣይሁዴ ጊዶናይሳታ ኣማኖን ፂሊሴይ ኢያ። ");
INSERT INTO gofENT_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","ያቲን፥ ኑኒ ሂጊያ ኣማኖ ጊሾ ሻሮስ ጉሴዬ? ጊዴና! ሂጊያ ሚንꬆሲፔ ኣቲን። ");
INSERT INTO gofENT_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","ያቲን፥ ኑ ማይዛይ ኣብራሃሜይ ኣይ ዴሚዴ? ");
INSERT INTO gofENT_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","ኣብራሃሜይ ኦሶን ፂሊዳባ ጊዲያኮ፥ ኢ ጬቄቲያባይ ዴዔስ፥ ጊዶሺን፥ ፆሳ ሲንꬃን ጬቄታናው ዳንዳዔና። ");
INSERT INTO gofENT_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","ጌሻ ማፃፋይ፥ «ኣብራሃሜይ ፆሳ ኣማኒስ፤ ፆሳይ ሄሳ ኢያው ፂሎቴꬂ ኦꬂዲ ኤኪስ» ያጌስ። ");
INSERT INTO gofENT_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","ኦꬂያ ኡራይ ኤኪያ ዳሞዜይ፥ ኢያ ኦሶ ዎልቃስ ጪጌቲያ ጋቴፔ ኣቲን ኢያው ኢሞታ ጊዴና። ");
INSERT INTO gofENT_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","ሺን ኦሶ ኦꬆና ኦኒካ ናጋራንቹዋ ፂሊሲያ ፆሳ ኣማኒኮ፥ ኢያ ኣማኖይ ኢያው ፂሎቴꬂ ጊዲዲ ታይቤቴስ። ");
INSERT INTO gofENT_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","ጌሻ ማፃፋን ዳዊቴይ፥ ኦሶይ ባይና ፆሳይ ፂሊሲያ ኣሳቲ ኣይ ሜላ ኣንጄቲዳኮ ሃይሳዳ ያጊዲ ቆንጪሴስ፡ ");
INSERT INTO gofENT_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","«ኤንታ ባላይ ኣቶ ጌቴቲዳይሳቲኔ ኤንታ ናጋራይ ካሜቲዳይሳቲ ኣንጄቲዳይሳታ። ");
INSERT INTO gofENT_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","ጎዳይ ኢያ ናጋራ ታይቦና ኣሲ ኣንጄቲዳይሳ» ያጌስ። ");
INSERT INTO gofENT_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","ያቲን፥ ዳዊቴይ ኦዲዳ ኣንጆይ ቃፃሬቲዳ ኣሳ ፃላላሴዬ? ዎይኮ ቃፃሬቲቦና ኣሳሴ? ኑኒ፥ «ጌሻ ማፃፋይ፥ ‹ኣብራሃሜይ ፆሳ ኣማኒስ፤ ፆሳይ ሄሳ ኢያው ፂሎቴꬂ ኦꬂዲ ኤኪስ› ያጌስ» ጊዳ። ");
INSERT INTO gofENT_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","ያቲን፥ ሄሲ ኣዉዴ ሃኒዴ? ኣብራሃሜይ ቃፃሬቲኔዬ? ዎይኮ ቃፃሬቶና ዴዒሺኔ? ቃፃሬታናፔ ሲንꬄ ሃኒሲፔ ኣቲን ጉዬ ጊዴና። ");
INSERT INTO gofENT_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","ኣብራሃሜይ ቃፃሬታናፔ ሲንꬄ ኢያ ኣማኖይ ኢያው ፂሎቴꬂ ጊዲዲ ታይቤቲዳይሳ ኤሪሳናው፥ ኢያ ቃፃሮይ ማላታ ጊዲስ። ሄሳ ጊሾ፥ ኣብራሃሜይ ቃፃሬቶና ኣማኔይሳታሲኔ ኣማኖን ፂሌይሳታ ኡባስ ኣዋ ጊዲስ። ");
INSERT INTO gofENT_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","ኢ ቃፃሬቲዳይሳታስካ ኣዋ። ኣብራሃሜይ ኤንታው ኣዋ ጊዲዳይ ኤንቲ ቃፃሬቲዳ ጊሾ ፃላላስ ጊዶናሺን ኢ ቃፃሬታናፔ ሲንꬄ ኣማኒዳ ኣማኑዋ ኤንቲ ካሊዳ ጊሾሳ። ");
INSERT INTO gofENT_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","ኣብራሃሜሲኔ ኢያ ሼሻስ፥ «ኣላሚያ ታ ሂንቴው ኢማና» ያጊዳ ኡፋይሳይ፥ ኣብራሃሜይ ኣማኖን ፂሊዳ ጊሾሳፌ ኣቲን ሂጌ ናጊዲ ፖሊዳ ጊሾ ጊዴና። ");
INSERT INTO gofENT_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","ሂጌስ ኪቴቲዳይሳቲ ፆሳይ ኢማና ጊዳ ኡፋይሳ ላታኤይሳታ ጊዲኮ፥ ኣሳ ኣማኖይ ማዴና፤ ፆሳ ኡፋይሳይካ ሃዳ ጊዲስ። ");
INSERT INTO gofENT_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","ሂጌ ሜንꬆይ ፆሳ ሃንቆ ኤሄስ፥ ሺን ሂጌይ ባይናሶን ሂጌ ሜንꬆይ ባዋ። ");
INSERT INTO gofENT_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","ሄሳ ጊሾ፥ ፆሳይ ኢሚዳ ኡፋይሳይ ኣማኖን ኤኬቴስ። ሃ ኡፋይሳይ ኣብራሃሜ ሼሻ ኡባስ ፆሳ ኣꬎ ኬሃቴꬃ ባጋራ ኢሜቲዳይሳ ቆንጪሴስ። ሄሲካ ሂጌ ናጌይሳታ ፃላላስ ጊዶናሺን ኣብራሃሜዳ ኣማኒዳ ኡባሳ። ኣብራሃሜይ ኑ ኡባስ ኣዋ። ");
INSERT INTO gofENT_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","ጌሻ ማፃፋን፥ «ታ ኔና ዳሮ ካዎቴꬃታስ ኣዋ ኦꬃስ» ጌቴቲዲ ኣብራሃሜ ጊሾ ፃፌቲስ። ሃ ኡፋይሳይ ኣብራሃሜስ ኢሜቲዳይ ሃይቂዳይሳታስ ዴዖ ኢሜይሲኔ ኦራꬃባ ኦꬂያ ፆሳይ ኢያ ጊዴይሳ ኢ ኣማኒዳ ጊሾሳ። ");
INSERT INTO gofENT_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","ፆሳይ ኣብራሃሜስ ዳሮ ዜሬꬂ ኢማናይሳ ጫቂስ። ኡፋይሲ ኦꬃናው ኣይኮካ ዳንዳዔቶና ዎዴ ኣብራሃሜይ ፆሳን ኣማኒዳ ጊሾኔ ኡፋይሲ ኦꬂዳ ጊሾ ዳሮ ካዎቴꬃታስ ኣዋ ጊዲስ። ");
INSERT INTO gofENT_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","ኣብራሃሜስ ፄቱ ላይꬂ ኩማና ሃኒኮካ፥ ባ ዳቡሪዳ ኣሳቴꬃኔ ሳራ ናዓ ዬላናው ዳንዳዖናይሳ ኤሪሼ ባ ኣማኑዋን ዳቡሪቤና። ");
INSERT INTO gofENT_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","ጊዶሺን፥ ኢ ባ ኣማኑዋን ሚኒዲ ፆሳስ ቦንቾ ኢሚስፔ ኣቲን ፆሳይ ኢሚዳ ኡፋይሳ ኣማኖና ኢፂዲ፥ ሲꬊቤና። ");
INSERT INTO gofENT_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","ኣብራሃሜይ፥ ፆሳይ ጫቂዳ ጫቁዋ ፖላናይሳ ባ ኩሜꬃ ዎዛናን ኣማኒስ። ");
INSERT INTO gofENT_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","ሄሳ ጊሾ፥ ፆሳይ ኢያ ኣማኑዋ ፂሎቴꬃን ታይቢስ። ");
INSERT INTO gofENT_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","ሺን፥ «ኢያው ፂሎቴꬃን ታይቢስ» ጊያ ቃላይ ኣብራሃሜ ፃላላስ ፃፌቲቤና። ");
INSERT INTO gofENT_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","ሄ ቃላይ ኑ ጎዳ ዬሱሳ ሃይቆፔ ዴንꬂዳ ፆሳ ኣማኒያ ኑስካ ኑ ኣማኖይ ፂሎቴꬃን ታይቤታና ሜላ ፃፌቲስ። ");
INSERT INTO gofENT_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","ፆሳይ ኢያ ኑ ናጋራ ጊሾ ሃይቆስ ኣꬂዲ ኢሚስ፤ ኢ ኑና ፂሊሳናው ሃይቆፔ ዴንዲስ። ");
INSERT INTO gofENT_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","ሂዛ፥ ኑ ኣማኖን ፂሊዳ ጊሾ ኑ ጎዳ ዬሱስ ኪሪስቶሳ ባጋራ ፆሳራ ኑስ ሳሮቴꬂ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","ኑኒ ኢያ ባጋራ ሃዒ ኑ ኤቂዳ ኣꬎ ኬሃቴꬃ ጊዶ ኣማኖን ጌሊዳ። ሄሳ ጊሾ፥ ኑ ፆሳ ቦንቹዋ ሻኬታናው ዴዒያ ኡፋይሳን ጬቄቶስ። ");
INSERT INTO gofENT_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","ሄሳ ፃላላ ጊዶናሺን ሜቶይ ዳንዳዓ ኤሄይሳ ኑ ኤሪያ ጊሾ ኑ ሜቱዋንካ ጬቄቶስ። ");
INSERT INTO gofENT_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","ቃሲ ዳንዳዓይ ጌንጫ፥ ጌንጫይ ኡፋይሲ ኢሜይሳ ኑ ኤሮስ። ");
INSERT INTO gofENT_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","ኑስ ኢሚዳ ጌሻ ኣያና ባጋራ ፆሳይ ባ ሲቁዋ ኑ ዎዛናን ጉሲዳ ጊሾ ሄ ኡፋይሳይ ኑና ዬላዬና። ");
INSERT INTO gofENT_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","ኑኒ ቡሮ ዳቡራንቾታ ጊዲዲ ዴዒሺን፥ ፆሳ ዎዴይ ጋኪን፥ ኪሪስቶሲ ናጋራንቾታ ጊሾ ሃይቂስ። ");
INSERT INTO gofENT_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","ፂሎ ኣሳ ጊሾ ሃይቃና ኣሲ ዴማናይሲ ዳሮ ሜቶ፥ ሺን ኬሃ ኣሳ ጊሾ ሃይቃና ኣሲ ኦኒ ኤሪ ቤንቶና ኣጌና። ");
INSERT INTO gofENT_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","ሺን ኑኒ ቡሮ ናጋራንቾ ጊዲዲ ዴዒሺን፥ ኪሪስቶሲ ኑ ጊሾ ሃይቂስ። ሄሲ ፆሳይ ኑና ኣይ ሜላ ሲቂያኮ ኢያ ሲቁዋ ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","ሂዛ፥ ኑኒ ኪሪስቶሳ ሱꬃን ፂሊዳባ ጊዲኮ፥ ኡባፌ ኣꬂዲ ኢያ ባጋራ ፆሳ ሃንቁዋፌ ኣታና። ");
INSERT INTO gofENT_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","ኑኒ ፆሳራ ካሴ ሞርኬ፥ ሺን ኢያ ናዓ ሃይቁዋን ኢያራ ሲጌቲዳ። ሄሳፌ ኣꬂዲ፥ ሃዒ ኑኒ ፆሳራ ሲጌቲዳፔ ጉዬ ኢያ ናዓ ዴዑዋ ጋሶን ኑኒ ኣታና። ");
INSERT INTO gofENT_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","ሄሳ ፃላላ ጊዶናሺን ሃዒ ኑና ፆሳራ ሲጌꬂዳ ኑ ጎዳ ዬሱስ ኪሪስቶሳ ባጋራ ኑ ፆሳን ጬቄቶስ። ");
INSERT INTO gofENT_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","ኣዳሜ ባጋራ ናጋሪ ሃ ኣላሚያ ጌሊስ። ሄ ናጋራ ባጋራ ሃይቆይ ዪስ። ኣሲ ኡባይ ናጋራ ኦꬂዳ ጊሾ ሃይቆይ ኣሳ ዛሬ ኡባ ጋኪስ። ");
INSERT INTO gofENT_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","ሂጌይ ኢሜታናፔ ሲንꬄ ኣላሜን ናጋሪ ዴዔስ፥ ሺን ሂጌይ ባይና ዎዴ ናጋሪ ናጋራ ጊዲዲ ታይቤቴና። ");
INSERT INTO gofENT_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","ሺን ኣዳሜፔ ሙሴ ጋካናው ሃይቆይ ኣሳ ኡባ ሃሪስ። ሃሪ ኣቶሺን፥ ኣዳሜዳ ሂጌስ ኪቴቶና ኢፂዲ፥ ናጋራ ኦꬂቦናይሳታ ቦላካ ሃይቆይ ካዎቲስ። ኣዳሜይ ያና ዬሱሳስ ሌሚሶ። ");
INSERT INTO gofENT_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","ሺን ፆሳ ኣꬎ ኬሃቴꬃይ ኣዳሜ ናጋራ ሜላ ጊዴና። ኢሲ ኣሳ ናጋራ ባጋራ ዳሮ ኣሳይ ሃይቂስ። ሺን ዬሱስ ኪሪስቶሳ ባጋራ ፆሳ ኣꬎ ኬሃቴꬃይ ኣሳ ኡባስ ዳሪዲ ኢሜቲስ። ");
INSERT INTO gofENT_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","ኣዳሜ ናጋራ ጊዶኒኔ ፆሳ ኢሞታ ጊዶን ዳሮ ዱማቴꬂ ዴዔስ። ኢሲ ኣሳ ናጋራ ጋሶን ፆሳይ ኢያ ቦላ ፒርዲስ። ሺን ኣሳይ ዳሮ ናጋራ ኦꬂንካ ፆሳ ኣꬎ ኬሃቴꬃይ ፂሎቴꬃ ኤሂስ። ");
INSERT INTO gofENT_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","ኢሲ ኣሳ ናጋራ ጋሶን ሃይቆይ ኣሳ ኡባ ቦላ ካዎቲስ። ሺን ዬሱስ ኪሪስቶሳ ባጋራ ፆሳ ኣꬎ ኬሃቴꬃኔ ፂሎቴꬃ ኢሞታ ኤኪያ ኡባይ፥ ፆኖ ዴዖን ዴዖሶና። ");
INSERT INTO gofENT_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","ሂዛ፥ ኢሲ ኣሲ ናጋራ ኦꬂዳ ጋሶን ኣሳ ኡባ ቦላ ፒርዲ ዪዳይሳዳ ኢሲ ኣሲ ፂሎ ኦꬂዳ ጋሶን፥ ፆሳይ ኣሴ ኡባ ፂሊሲዲ ኤንታው ዴዖ ኢሜስ። ");
INSERT INTO gofENT_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","ኢሲ ኣሲ ኪቴቶና ኢፂዳ ጋሶን፥ ዳሮ ኣሳይ ናጋራንቾ ጊዲዳይሳዳ ኢሲ ኣሳ ኪቴቴꬃን ዳሮ ኣሳይ ፂላና። ");
INSERT INTO gofENT_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","ኣሳይ ናጋራ ዎልቃ ኤራና ሜላ ሂጌይ ዪስ፥ ሺን ናጋራ ዎልቃይ ዳሪዳ ዎዴ ፆሳ ኣꬎ ኬሃቴꬃይ ኣꬊዲ ዳሪስ። ");
INSERT INTO gofENT_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","ናጋሪ ሃይቆ ዎልቃን ካዎቲዳይሳ ሜላ ፆሳ ኣꬎ ኬሃቴꬃይ ፂሎቴꬃ ዎልቃን ካዎቲዲ፥ ኑ ጎዳ ዬሱስ ኪሪስቶሳ ባጋራ ኑና ሜሪና ዴዑዋኮ ካሌꬄስ። ");
INSERT INTO gofENT_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","ያቲን፥ ኑኒ ዎይጋኔ? ፆሳ ኣꬎ ኬሃቴꬃይ ዳራና ሜላ ናጋራን ሚኒዲ ዴዒኖ? ");
INSERT INTO gofENT_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","ኣካይ፥ ኑኒ ናጋራስ ሃይቂዳባ ጊዲኮ፥ ያቲን፥ ኑኒ ሂዛፔ ዋኒዲ ናጋራን ዳኔ? ");
INSERT INTO gofENT_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","ኑ ኡባይ ኪሪስቶስ ዬሱሳራ ኢሲፋናው ፃማቄቲዳ ዎዴ ኢያ ሃይቁዋን ኢያራ ኢሲፋናው ፃማቄቲዳይሳ ኤሬኬቲዬ? ");
INSERT INTO gofENT_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","ኑ ፃማቄቲዳ ዎዴ ኪሪስቶሳራ ሃይቂዳኔ ሞጌቲዳ። ኪሪስቶሲ ፆሳ ኣዋ ቦንቾ ዎልቃን ሃይቆፔ ዴንዲዳይሳ ሜላ ኑካ ኦራꬃ ዴዖን ዳና። ");
INSERT INTO gofENT_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","ኑ ኢያ ሃይቁዋን ኢያራ ኢሲኖ ጊዲኮ፥ ሄሳዳካ፥ ኢያ ዴንዱዋን ኢያራ ኢሲኖ ጊዳና። ");
INSERT INTO gofENT_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","ኑ ሂዛፔ ናጋራስ ኣይሌ ጊዶና ሜላኔ ኑ ናጋራንቾ ኣሳቴꬃ ዎልቃይ ꬋያና ሜላ ኑ ጪማ ኣሳቴꬃይ ኪሪስቶሳራ ካቄቲዳይሳ ኤሮስ። ");
INSERT INTO gofENT_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","ኢሲ ኣሲ ኪሪስቶሳን ሃይቂዳባ ጊዲኮ፥ ኢ ናጋራ ዎልቃፌ ላዓ ኬዪስ። ");
INSERT INTO gofENT_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","ኑኒ ኪሪስቶሳራ ሃይቂኮ፥ ኢያራ ዴዖን ዳናይሳ ኣማኖስ። ");
INSERT INTO gofENT_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","ኪሪስቶሲ ሃይቆፔ ዴንዲዳ ጊሾ ዛሪ ኢ ሃይቆናይሳኔ ሃይቆይ ሲንꬃፌ ኢያ ሃሮናይሳ ኑ ኤሮስ። ");
INSERT INTO gofENT_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","ኢ ሃይቂዳ ዎዴ ናጋራስ ኢሲ ቶሆ ዉርሴꬂ ጋካናው ሃይቂስ፥ ሺን ሃዒ ዴዖን ፆሳስ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","ሄሳዳካ፥ ሂንቴ ናጋራስ ሃይቂዲ፥ ጎዳ ኪሪስቶስ ዬሱሳ ባጋራ ፆሳስ ዴዖን ዴዔይሳ ቆፒቴ። ");
INSERT INTO gofENT_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","ሄሳ ጊሾ፥ ሂንቴ፥ ሂንቴ ኣሳቴꬃ ኣሙዋስ ኪቴቶና ሜላ ሃይቂያ ሂንቴ ኣሳቴꬃ ናጋሪ ሃሮፖ። ");
INSERT INTO gofENT_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","ቃሲ ሂንቴ ኣሳቴꬃ ናጋራ ኦꬃናው ጌላቴꬃ ሚሼ ኦꬂዲ ኢሞፊቴ። ሺን ሂንቴ ሃይቆፔ ዴንዲዲ፥ ዴዖን ዴዒያ ኣሳዳ ሂንቴ ኣሳቴꬃ ፆሳስ ኢሚቴ። ቃሲ ሂንቴ ኩሜꬃ ኣሳቴꬃ ፂሎ ኦሶ ኦꬃናው ፆሳስ ኣꬂ ኢሚቴ። ");
INSERT INTO gofENT_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","ሂንቴ ፆሳ ኣꬎ ኬሃቴꬃ ጋርሳን ዴዔታፔ ኣቲን ሂጌፌ ጋርሳን ዴዖና ጊሾ ናጋሪ ሂንቴና ሃራናው ቤሴና። ");
INSERT INTO gofENT_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","ያቲን፥ ኑ ዎይጋኔ? ሂጌፌ ጋርሳን ጊዶናሺን ፆሳ ኣꬎ ኬሃቴꬃ ጋርሳን ዴዒያ ጊሾ ናጋራ ኦꬃኔዬ? ኣካይ! ");
INSERT INTO gofENT_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","ሂንቴ ኢሲ ኣሳስ ኪቴታናው ሂንቴና ኣይሌ ኦꬂዲ ኢሚያ ዎዴ ሄ ሂንቴ ኪቴቴይሳስ ኣይሌ ጊዴይሳ ኤሬታ። ሄሳዳካ፥ ሂንቴ ናጋራስ ኪቴቲኮ፥ ሂንቴው ሃይቆ ኤሂያ ናጋራስ ኣይሌ ጊዴታ። ዎይኮ ሂንቴ ፆሳስ ኪቴቲኮ ፂሎቴꬂ ኤሂያ ፆሳስ ኣይሌ ጊዴታ። ");
INSERT INTO gofENT_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","ካሴ ሂንቴ ናጋራስ ኣይሌ፥ ሺን ሃዒ ሂንቴ ኤኪዳ ቱማ ቲሚርቲያስ ኩሜꬃ ዎዛናፔ ኪቴቲዳ ጊሾ ፆሳስ ጋላቲ ጊዶ። ");
INSERT INTO gofENT_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","ሂንቴ ናጋራ ኣይሌቴꬃ ቃሾፔ ቢሌቲዲ ፂሎቴꬃ ኣይሌ ጊዲዴታ። ");
INSERT INTO gofENT_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","ሂንቴ ሂንቴ ቆፋን ዳቡራንቾ ጊዲያ ጊሾ ታኒ ኦዴስካ ጌሊያ ኦጌን ኦዳይስ። ካሴ ሂንቴ፥ ሂንቴ ኣሳቴꬃ ቱናኔ ኢታባ ኦꬃናው ኣይሌ ኦꬂዲ ኢሚዳይሳ ሜላ ሃዒ ሂንቴ ኣሳቴꬃ ጌሺ ጊዳና ሜላ ፂሎቴꬃ ኣይሌ ኦꬂዲ ኢሚቴ። ");
INSERT INTO gofENT_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","ሂንቴ ናጋራስ ኣይሌቲዲ ዴዒያ ዎዴ ፂሎቴꬃስ ሃሬቴኬታ። ");
INSERT INTO gofENT_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","ሂንቴና ሃዒ ዬላያ ቤኒ ሂንቴ ኢታ ኦሱዋፔ ኣይ ማዴ ዴሚዴቲ? ሄ ኦሶታ ዉርሴꬃይ ሃይቆ። ");
INSERT INTO gofENT_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","ሺን ሂንቴ ናጋራ ኣይሌቴꬃ ቃሾፔ ቢሌቲዲ፥ ፆሳስ ኣይሌ ጊዲዴታ። ሄሲ ሂንቴና ጌሺ ኦꬂዲ ሜሪና ዴዑዋኮ ካሌꬄስ። ");
INSERT INTO gofENT_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","ናጋራ ጋቴይ ሃይቆ። ሺን ፆሳይ፥ ኑ ጎዳ ኪሪስቶስ ዬሱሳ ባጋራ ኢሚያ ኢሞታይ ሜሪና ዴዖ። ");
INSERT INTO gofENT_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","ታ ኢሻቶ፥ ታኒ ኦዴይ ሂጌ ኤሪያ ኣሳታሳ። ሂጌይ ኢሲ ኣሲ ፓፃ ዴዒያ ዎዴ ኡባን ኢያ ሃሬስ። ");
INSERT INTO gofENT_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","ሌሚሶስ፥ ኣዚና ጌሊዳ ማጫሲያ ኢ ኣዚናይ ፓፃ ዴዒያ ዎዴ ሂጌን ኢያራ ቃሼታሱ። ሺን ኢ ኣዚናይ ሃይቂኮ ኢያራ ኢያ ጫቂዳ ጫቆይ ኢዮ ሃሬና። ");
INSERT INTO gofENT_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","ሄሳ ጊሾ፥ ኢያ ባ ኣዚናይ ፓፃ ዴዒሺን፥ ሃራ ኣዴ ጌሊኮ፥ ኢያ ላሚዳሮ ጌቴታዉሱ። ሺን ኢ ኣዚናይ ሃይቂኮ፥ ጫቆይ ኢዮ ሃሮና ጊሾ ኢያ ሃራ ኣዚና ጌሊኮ፥ ኢያ ላሚዳሮ ጌቴቱኩ። ");
INSERT INTO gofENT_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","ሄሳ ጊሾ፥ ታ ኢሻቶ፥ ሂንቴ ኪሪስቶሳ ኣሳቴꬃ ባጋራ ሂጌ ዎልቃስ ሃይቂዲ፥ ፆሳስ ኣይፌ ኣይፋናው ሃይቆፔ ዴንዲዳ ኪሪስቶሳስ ጊዲዴታ። ");
INSERT INTO gofENT_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","ኑ ኣሾ ኣሞይ ኑና ሃሪን፥ ኑ ዴዒያ ዎዴ ሂጌይ ጉጂ ናጋራ ኦꬃና ሜላ ኑና ዴንꬄꬄስ። ኑ ኣሳቴꬃ ጊዶን ኢታ ኣሞቴꬂ ዴዒያ ጊሾ ኑኒ ሃይቆ ኣይፌ ኣይፋና ሜላ ኦꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","ሺን ሃዒ ኑኒ ኑና ቃቺዳ ሂጊያስ ሃይቂዳ ጊሾ ኑኒ ሂጌ ቃሾፔ ቢሌቲዳ። ሄሳ ጊሾ፥ ጌሻ ኣያና ኦጌን ፆሳስ ኪቴቶሲፔ ኣቲን ፃፌቲዳ ጪማ ሂጊያስ ኪቴቶኮ። ");
INSERT INTO gofENT_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","ያቲን፥ ኑኒ ዎይጋኔ? ሂጌይ ባ ሁዔን ናጋሬ? ጊዴና! ሺን ሂጌይ ናጋሪ ኣይቤኮ ታና ኤሪሲስ። ሂጌይ፥ «ኣሞቶፋ» ጎናኮ፥ ኣሞቴꬂ ኣይቤኮ ታኒ ኤሪኬ። ");
INSERT INTO gofENT_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","ሺን ታ ኡባባ ኣሞታና ሜላ ናጋሪ ሂጌ ባጋራ ታናን ኦጌ ዴሚስ። ሂጌይ ባይኔኮ ናጋሪ ሃይቂዳይሳ። ");
INSERT INTO gofENT_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","ካሴ ሂጌይ ባይና ዎዴ ታ ፓፃ፥ ሺን ሂጌይ ኢሜቲዳ ዎዴ ናጋሪ ፓፂን ታ ቃሲ ሃይቃስ። ");
INSERT INTO gofENT_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","ታኒ ዴዖን ዳና ሜላ ፆሳይ ኢሚዳ ሂጌይ ታው ሃይቆ ኤሂስ። ");
INSERT INTO gofENT_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","ናጋሪ ሂጌ ባጋራ ታና ጪሚያ ኦጌ ዴሚዲ፥ ዎꬊስ። ");
INSERT INTO gofENT_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","ሄሳ ጊሾ፥ ሂጌይ ጌሺ፤ ኢያን ፃፌቲዳ ኪታይካ ጌሺ፥ ፂሎኔ ሎዖ። ");
INSERT INTO gofENT_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","ያቲን፥ ሎዖ ጊዲዳባይ ታ ቦላ ሃይቆ ኤሂዴዬ? ጊዴና! ሺን ናጋሪ ናጋራ ጊዴይሲ ቆንጫና ሜላ ሎዖባን ማዴቲዲ ታው ሃይቆ ኤሂስ። ሄሳ ጊሾ፥ ናጋራ ናጋራቴꬃይ ሂጌ ባጋራ ኣꬊዲ ኤሬቲስ። ");
INSERT INTO gofENT_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","ኑኒ ሂጌይ ኣያናባ ጊዴይሳ ኤሮስ። ሺን ታኒ ናጋራስ ባይዜቲዳ ኣሾ ኣሲ። ");
INSERT INTO gofENT_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","ታኒ ኦꬂያባ ኣኬኪኬ፤ ታኒ ዶሲያባ ኦꬃናይሳ ኣጋዳ ታ ኢፂያባ ኦꬃይስ። ");
INSERT INTO gofENT_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","ታኒ ኢፂያባ ኦꬂያባ ጊዲኮ፥ ሂጌይ ሎዖ ጊዴይሳ ማዓይስ። ");
INSERT INTO gofENT_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","ሄሳ ጊዲኮ፥ ሄ ኦሱዋ ታናን ዴዒያ ናጋራይ ኦꬃይሲፔ ኣቲን ታ ኦꬂኬ። ");
INSERT INTO gofENT_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","ታናን፥ ሄሲካ ታ ኣሹዋን ሎዖባይ ባይናይሳ ኤራይስ። ሎዖባ ኦꬂያ ኣሞቴꬂ ታናን ዴዔስ፥ ሺን ሎዖባ ኦꬃናው ዳንዳዒኬ። ");
INSERT INTO gofENT_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","ታኒ ኢፂያ ኢታባ ኦꬃይሲፔ ኣቲን ታ ዶሲያ ሎዖባ ኦꬂኬ። ");
INSERT INTO gofENT_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","ታኒ ኢፂያባ ኦꬂያባ ጊዲኮ፥ ሄሳ ታናን ዴዒያ ናጋራይ ኦꬄሲፔ ኣቲን ኦꬄይ ታና ጊዲኬ። ");
INSERT INTO gofENT_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","ሂዛ፥ ታ ሎዖባ ኦꬃናው ዶሲሺን፥ ኢታባ ኦሶይ ዎጋ ጊዴይሳ ዴማስ። ");
INSERT INTO gofENT_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","ታኒ ታ ዎዛናን ፆሳ ሂጊያን ኡፋይታይስ። ");
INSERT INTO gofENT_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","ሺን ታ ኣሳቴꬃ ጊዶን ዴዒያ ታ ቆፋ ሂጊያራ ኦሌቲያ ዱማ ሂጌ ቤዓይስ። ሄ ሂጌይ ታ ኣሳቴꬃ ጊዶን ኦꬂያ ናጋራ ሂጊያስ ታና ኣይሌ ኦꬂዲ ኢሚስ። ");
INSERT INTO gofENT_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","ታኒ ዋኒዳ ዪባታ ኣሴ? ሃይቆስ ኤፊያ ሃ ኣሳቴꬃፌ ታና ኣሻናይ ኦኔ? ");
INSERT INTO gofENT_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","ኑ ጎዳ ዬሱስ ኪሪስቶሳ ባጋራ ታና ኣሺያ ፆሳስ ጋላቲ ጊዶ። ሂዛ፥ ታኒ ታ ቆፋን ፆሳ ሂጊያስ ሃሬታይስ፤ ሺን ታ ኣሳቴꬃን ታና ናጋራ ኦሲሲያ ሂጊያስ ሃሬታይስ። ");
INSERT INTO gofENT_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","ሄሳ ጊሾ፥ ኪሪስቶስ ዬሱሳን ዴዔይሳቲ ሃዒ ፒርዴቶኮና። ");
INSERT INTO gofENT_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","ኪሪስቶስ ዬሱሳ ባጋራ ኑስ ዴዖ ኢሚያ ጌሻ ኣያና ሂጌይ፥ ታና ናጋራኔ ሃይቆ ሂጌ ኣይሌቴꬃፌ ኬሲስ። ");
INSERT INTO gofENT_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","ኑ ናጋራ ኣሳቴꬃ ጋሶን፥ ሂጌይ ዳቡራንቾ ጊዲያ ጊሾ ኑና ኣሻናው ዳንዳዒቤና። ፆሳይ ባ ናዓ ናጋራንቾ ኣሳ ሌሚሶን ናጋራስ ያርሾ ጊዳና ሜላ ኪቲዲ ሄሳ ኦꬂስ። ያቲዲ፥ ፆሳይ ኪሪስቶሳ ኣሹዋ ባጋራ ናጋራ፥ ናጋራንቾ ኣሳ ጊዶን ፒርዲስ። ");
INSERT INTO gofENT_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","ፆሳይ ሄሳ ኦꬂዳይ፥ ኑ ኣሾ ኣሞይ ኮዬይሳዳ ጊዶናሺን ጌሻ ኣያናይ ኮዬይሳዳ ዴዒያ ኑ ቦላ ሂጊያ ፂሎ ኪታይ ፖሌታና ሜላሳ። ");
INSERT INTO gofENT_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","ባንታ ኣሾ ኣሙዋ ካሊዲ ዴዔይሳቲ ባንታና ኡፋይሲያባ ቆፖሶና። ሺን ጌሻ ኣያና ሼኔን ዴዔይሳቲ ጌሻ ኣያና ኡፋይሲያባ ቆፖሶና። ");
INSERT INTO gofENT_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","ኑ ቆፋይ ኣሾ ኣሞስ ሃሬቲኮ ሃይቆ ኤሄስ፥ ሺን ኣያና ኣሞስ ሃሬቲኮ ዴዖኔ ሳሮቴꬂ ኤሄስ። ");
INSERT INTO gofENT_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","ኣሾ ኣሞስ ሃሬቲያ ኣሲ ፆሳ ሂጊያስ ኪቴታናው ኮዮና ጊሾኔ ኪቴታናው ዳንዳዖና ጊሾ ፆሳራ ሞርኬ። ");
INSERT INTO gofENT_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","ባንታ ኣሾ ኣሙዋስ ሃሬቴይሳቲ ፆሳ ኡፋይሳናው ዳንዳዖኮና። ");
INSERT INTO gofENT_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","ሺን ፆሳ ኣያናይ ሂንቴናን ዴዒኮኔ ሂንቴና ሃሪኮ፥ ሂንቴ ኣያና ሼኔን ዴዔታፔ ኣቲን ሂንቴ ኣሾ ኣሙዋስ ሃሬቴኬታ። ኪሪስቶሳ ኣያናይ ባይና ኦኒካ ኪሪስቶሳባ ጊዴና። ");
INSERT INTO gofENT_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","ሺን ኪሪስቶሲ ሂንቴናን ዴዒኮ፥ ሂንቴ ኣሳቴꬃይ ናጋራ ጋሶን ሃይቂዳይሳ። ሺን ሂንቴ ኣያናይ ፂሎቴꬃ ጋሶን ዴዖን ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","ሺን ዬሱሳ ሃይቆፔ ዴንꬂዳ ፆሳ ኣያናይ ሂንቴናን ዴዒኮ፥ ኪሪስቶሳ ሃይቆፔ ዴንꬂዳ ፆሳይ፥ ሂንቴናን ዴዒያ ባ ጌሻ ኣያናን ሃይቂያ ሂንቴ ኣሳቴꬃስ ዴዖ ኢማና። ");
INSERT INTO gofENT_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","ሂዛ፥ ታ ኢሻቶ፥ ኑኒ ኑ ኣሾ ኣሙዋ ካሊዲ ዳናው ቤሴና። ");
INSERT INTO gofENT_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","ሂንቴ፥ ሂንቴ ኣሾ ኣሙዋስ ዴዒኮ ሃይቃና፥ ሺን ጌሻ ኣያና ዎልቃን ናጋራ ኦሱዋ ዎꬊኮ ሂንቴ ዴዖን ዳና። ");
INSERT INTO gofENT_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","ፆሳ ኣያናይ ካሌꬂያ ኡባይ ፆሳ ናይታ። ");
INSERT INTO gofENT_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","ኑኒ፥ «ኣባ፥ ታ ኣዋው» ያጊዲ ፄጊያ፥ ፆሳ ናይታ ኦꬂያ ጌሻ ኣያና ኤኪዳፔ ኣቲን ዛሪዲ ያሻን ዳናው ኣይሌ ኦꬂያ ኣያና ኤኪቦኮ። ");
INSERT INTO gofENT_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","ፆሳ ኣያናይ ኑ ኣያናራ ጊዲዲ ኑኒ ፆሳ ናይታ ጊዴይሳ ማርካቴስ። ");
INSERT INTO gofENT_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","ኑኒ ኢያ ናይታ ጊዲኮ ፆሳ ኣንጁዋ ላታና፤ ኪሪስቶሳራ ዎላ ሄ ኣንጁዋ ላታና። ቃሲ ኑኒ ኪሪስቶሳራ ሜቱዋ ኤኪኮ ኢያራ ዎላ ኢያ ቦንቹዋን ሻኬታና። ");
INSERT INTO gofENT_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","ኑኒ ሃዒ ዋዬቲያ ዋያ፥ ሲንꬃፌ ኑስ ቆንጫና ቦንቹዋራ ጋꬂ ቤዒኮ፥ ጊኒሳናው ዳንዳዔቴና ጋዳ ቆፓይስ። ");
INSERT INTO gofENT_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","ሜꬌቴꬃ ኡባይ ፆሳ ናይታ ቆንጬꬃ ዳሮ ላሞቲዲ ናጎሶና። ");
INSERT INTO gofENT_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","ሜꬌቴꬃ ኡባይ ሃዳ ጊዲስ፤ ሄሲካ፥ ሜꬌቴꬃ ዶሮን ጊዶናሺን ኡፋይሳን ናጋና ሜላ ኦꬂዳ ፆሳ ሼኔን ሃኒስ። ");
INSERT INTO gofENT_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","ሜꬌቴꬃይ ባ ሁዔን ꬋዮ ኣይሌቴꬃፌ ዎዜቲዲ፥ ፆሳ ናይታራ ዎላ ቦንቾ ላዓ ሻኬታና። ");
INSERT INTO gofENT_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","ሜꬌቴꬃይ ኢሲፌ ሃኖ ጋካናው ሚፆይ ኦይኪዳ ማጫሳዳ ኦሌኒኔ ኡንዓን ዴዔይሳ ኑ ኤሮስ። ");
INSERT INTO gofENT_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","ቃሲ ሄሳ ሜꬌቴꬃ ፃላላ ጊዶናሺን ጌሻ ኣያና ባይራ ኢሞታዳ ኤኪዳ ኑኒ፥ ኑ ሁዔን ኑ ኣሳቴꬃስ ዎዞ ጊዲዳ ፆሳ ናይታ ጊዳና ኡፋይሳ ናጊሼ ኑ ኣሳቴꬃን ኦሎስ። ");
INSERT INTO gofENT_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","ሃ ኡፋይሳን ኑኒ ኣቲዳ። ሺን ኑኒ ኡፋይሲ ኦꬂያባይ ቤንቲያ ጊዲኮ ሄሳ ኦኒ ኡፋይሲ ኦꬂ? ");
INSERT INTO gofENT_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","ሺን ኑ ቤዖናባ ዴማና ጊዲ ኡፋይሳን ናጊኮ ሄሳ ዳንዳዓን ናጎስ። ");
INSERT INTO gofENT_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","ሄሳዳ ጌሻ ኣያናይ ኑ ዳቡራን ማዴስ። ኑኒ ፆሳ ዋቲ ዎሳናው ቤሲያኮ ኤሮኮ፥ ሺን ጌሻ ኣያናይ ባ ሁዔን፥ ኣሲ ኦዳናው ዳንዳዔቶና ቃላን ኑስ ጋናቴስ። ");
INSERT INTO gofENT_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","ቃሲ ኣሳ ዎዛና ኤሪያ ፆሳይ ጌሻ ኣያና ቆፋይ ኣይቤኮ ኤሬስ። ጌሻ ኣያናይ ፆሳ ሼኒያዳ ጌሻታስ ጋናቴስ። ");
INSERT INTO gofENT_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","ፆሳ ሲቄይሳታሲኔ ኢያ ሼኒያዳ ፄጌቲዳይሳታስ ፆሳይ ኡባ ሎዖስ ኦꬄይሳ ኤሮስ። ");
INSERT INTO gofENT_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","ፆሳይ ኮይሮቲዲ ኤሪዳይሳቲ ባ ናዓ ዳናና ሜላኔ ናዓይካ ኣማኔይሳታ ጊዶን ባይራ ጊዳና ሜላ ኤንታ ዱማዪዲ ዎꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","ፆሳይ ኮይሮቲዲ ዱማዪዳይሳታ ፄጊስ፤ ሄ ፄጊዳይሳታ ፂሊሲስ፤ ሄ ፂሊሲዳይሳታ ቃሲ ቦንቺስ። ");
INSERT INTO gofENT_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","ያቲን፥ ኑ ሃ ኡባስ ዎይጋኔ? ፆሳይ ኑ ባጋ ጊዲኮ ኑራ ኦኔ ኤቄታናይ? ");
INSERT INTO gofENT_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","ኢ ሃሪ ኣቶሺን፥ ባ ናዓስ ቃꬌቶናሺን፥ ኑ ጊሾ ኣꬂ ኢሚስ። ያቲን፥ ባ ናዓ ኑስ ኣꬂ ኢሚዳይሲ ዋኒዲ ኡባባ ጮ ኢሜኔ? ");
INSERT INTO gofENT_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","ፆሳይ ኤንታና ፂሊሲዳ ጊሾ ኢ ዶሪዳይሳታ ኦኔ ሞታናይ? ");
INSERT INTO gofENT_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","ያቲን፥ ኤንታ ቦላ ፒርዳናው ዳንዳዔይ ኦኔ? ኦኒካ ባዋ። ሃይቆፔ ዴንዲዲ ፆሳ ኡሻቻን ኡቲዳ፥ ኪሪስቶስ ዬሱሲ፥ ኢ ኑስ ጋናቴስ። ");
INSERT INTO gofENT_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","ሂዛ፥ ኑና ኪሪስቶሳ ሲቁዋፔ ሻካናይ ኦኔ? ዋዬዬ ዎይኮ ሜቶዬ ዎይኮ ጎዴዬ ዎይኮ ኮሼዬ ዎይኮ ካሎቴꬄዬ ዎይኮ ያሼዬ ዎይኮ ኦሌዬ? ");
INSERT INTO gofENT_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","ጌሻ ማፃፋን፥ «ኑኒ ኔ ጊሾ ጋላሳ ኩሜꬃ ሃይቆስ፤ ሹካስ ኤፊያ ዶርሳዳ ታይቤቲዳ» ጌቴቲዲ ፃፌቲዳይሳ ሜላ ጊዲስ። ");
INSERT INTO gofENT_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","ሺን ኑኒ፥ ኑና ሲቂዳ ኪሪስቶሳን ሃ ኡባ ፖሎ ፆኖስ። ");
INSERT INTO gofENT_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","ሄሳ ጊሾ፥ ሃይቆ ጊዲን ዴዖ ጊዲን ኪታንቾታ ጊዲን ሃሬይሳታ ጊዲን ሃዒ ዴዔይሳ ጊዲን ሲንꬃፌ ያናይሳ ጊዲን ዎልቃማታ ጊዲን፥ ");
INSERT INTO gofENT_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","ሳሎ ዎልቃ ጊዲን ሳዓ ዎልቃ ጊዲን ኣይ ሜꬌቴꬂ ጊዲን ኑ ጎዳ፥ ኪሪስቶስ ዬሱሳን ዴዒያ ፆሳ ሲቁዋፔ ኑና ሻካናው ዳንዳዖናይሳ ታኒ ኤራስ። ");
INSERT INTO gofENT_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","ታኒ ኪሪስቶሳን ቱማ ኦዳይስ፥ ዎርዶቲኬ። ጌሻ ኣያናይ ካሌꬂያ ታ ካሃይ ታኒ ዎርዶቶናይሳ ታው ማርካቴስ። ");
INSERT INTO gofENT_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","ታ ዎዛናን ኢስራዔሌታስ ዳሮ ቃꬌታይሲኔ ቃማ ጋላስ ቆፓይስ። ");
INSERT INTO gofENT_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","ታኒ፥ ታ ኢሻታ ጊሾ ኪሪስቶሳፔ ሻኬታዳ ፆሳ ቃንጌꬃፌ ጋርሳን ዴዒዳኮ ዶሳይሲሺን። ");
INSERT INTO gofENT_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","ኤንቲ ኢስራዔሌታ፥ ፆሳይ ኤንታ ባ ናይታ ኦꬂስ፥ ባ ቦንቹዋ ኤንታው ቆንጪሲስ። ኤንታራ ጫቂስ፤ ሂጊያ ኤንታው ኢሚስ። ኤንቲ ፆሳ ጎይናና ቱማ ኦጊያ ቤሲስ፤ ፆሳይ ኡፋይሳ ቃላ ኤንታው ኢሚስ። ");
INSERT INTO gofENT_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","ኤንቲ ዬሌቴꬃን ማይዛታ ዛሬ፤ ቃሲ ኪሪስቶሲ ኣሾን ኤንታ ዛሬ ጊዲዲ ዪስ። ኡባፌ ቦላ ጊዲዳ ፆሳይ ሜሪናው ጋላቴቶ። ኣሚንዒ! ");
INSERT INTO gofENT_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","ጊዶሺን፥ ፆሳይ ጌሊዳ ቃላይ ፖሌቶና ኣቲስ ጉሱ ጊዴና። ኢስራዔሌ ኣሳ ኡባይ ፆሳ ኣሲ ጊዶኮና። ");
INSERT INTO gofENT_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","ቃሲ ኣብራሃሜ ዛሬ ኡባይ ኣብራሃሜ ናይታ ጊዶኮና። ፆሳይ ኣብራሃሜስ፥ «ኔ ዜሬꬃይ ዪሳቃ ባጋራ ፄጌታና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","ሄሳ ጉሳይ ኣሾን ዬሌቲዳ ናይቲ ኡባይ ፆሳ ናይታ ጊዶኮና። ሺን ቱማ ኢስራዔሌ ናይቲ ፆሳይ ኣብራሃሜስ ጌሊዳ ቃላዳ ዬሌቲዳ ናይታ። ");
INSERT INTO gofENT_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","ፆሳይ ኢማና ጊዲ ጌሊዳ ቃላይ፥ «ታኒ ዎንቶ ላይꬂ ሃኖዴ ያና፤ ሳራካ ኣዴ ናዓ ዬላና» ያጌይሳ። ");
INSERT INTO gofENT_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","ሄሳ ፃላላ ጊዶናሺን ኢርቢቂኔ ዪሳቂ ዬሊዳ ሜንቴ ኣዴ ናይታባ ኣኬኪቴ። ");
INSERT INTO gofENT_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","ኤንቲ ዬሌታናፔ ዎይኮ ኢታ ዎይኮ ሎዖ ኦꬃናፔ ሲንꬄ ፆሳ ዶሮይ ኦሶን ጊዶናሺን ፄሳን ጊዴይሳ ቆንጪሳናው፥ ");
INSERT INTO gofENT_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","«ባይራይ ካሉዋስ ኪቴታና» ያጊዲ ጎዳይ ኢርቢቃስ ኦዲስ። ");
INSERT INTO gofENT_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","ሄሲካ ጌሻ ማፃፋን፥ «ያይቆባ ዶሳስ፥ ኤሳዌ ኢፃስ» ጌቴቲዲ ፃፌቲስ። ");
INSERT INTO gofENT_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","ያቲን፥ ኑኒ ዎይጋኔ? ፆሳይ ኣሴ ኣሳፔ ሻኪዬ? ጊዴና። ");
INSERT INTO gofENT_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","ጎዳይ ሙሴኮ፥ «ታ ማራናው ኮዪዳይሳታ ማራና፤ ታ ቃꬌታናው ኮዪዳይሳታስ ቃꬌታና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","ሂዛ፥ ፆሳ ዶሮይ ኣሳ ሼኔን ዎይኮ ኦሶን ጊዶናሺን ኢያ ማሮቴꬃና። ");
INSERT INTO gofENT_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","ጌሻ ማፃፋን፥ ጊብፄ ካዉዋኮ፥ «ታኒ፥ ታ ዎልቃ ኔናን ቤሳናዉኔ ታ ሱንꬃይ ኣላሜ ኡባን ኤሬታና ሜላ ሄሳስ ኔና ካዎꬃስ» ጌቴቲዲ ፃፌቲስ። ");
INSERT INTO gofENT_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","ሂዛ፥ ፆሳይ ማራናው ኮዬይሳ ማሬስ፤ ዎዛና ሙሚሳናው ኮዬይሳ ዎዛና ሙሚሴስ። ");
INSERT INTO gofENT_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","ሂንቴፌ ኢሶይ፥ «ያቲን፥ ፆሳይ ኣሴ ኢታ ኦሶ ጊሾ ኣይስ ቦሪ? ፆሳ ሼኒያ ኢፃስ ጋናይ ኦኔ?» ያጊዲ ኦይቻናው ዳንዳዔስ። ");
INSERT INTO gofENT_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","ሺን ታ ኢሻው፥ ፆሳራ ፓላማናው ኔኒ ኦኔ? ኡርቃፌ ሜꬌቲዳ ሚሼይ ባና ሜꬊዳይሳ፥ «ታና ሃይሳዳ ኦꬃዳ ኣይስ ሜꬋዲ?» ጊዲ ኦይቻናው ዳንዳዒ? ");
INSERT INTO gofENT_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","ዎይኮ ኡርቃ ሜꬌይሲ ኢሲ ኡርቃፌ ኢሱዋ ቦንቾ ሚሼ፥ ሃንኩዋ ቃሲ ቶሼ ሚሼ ኦꬂዲ ሜꬋናው ማቲ ባዌ? ");
INSERT INTO gofENT_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","ፆሳይ ባ ሃንቁዋ ቤሳናዉኔ ባ ዎልቃ ኤሪሳናው ኮዪዲ፥ ፒርዳስ ጊጊዳ ሃንቆ ናይታ ዳሮ ጌንጫን ዳንዳዒዳኮ ኔ ኣይ ኤራይ? ");
INSERT INTO gofENT_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","ሄሳ ኢ ኦꬂዳይ ኮይሮቲዲ ቦንቾስ ጊጊሲዳ፥ ባ ዶሪዳ ናይታስ ባ ቦንቹዋ ቆንጪሳናሳ። ");
INSERT INTO gofENT_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","ኣይሁዴ ጊዲን፥ ዎይኮ ኣይሁዴ ጊዶና ኣሳ ኡባይ ፆሳን ዶሬቲዳ። ");
INSERT INTO gofENT_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","ናቢያ ሆሴዔ ማፃፋን፥ «ታ ኣሴ ጊዶናይሳታ፥ ‹ታ ኣሴ› ጋዳ ፄጋና። ታ ሲቃቦና ዴሪያ፥ ‹ሲቄቲዳይሳታ› ጋዳ ፄጋና። ");
INSERT INTO gofENT_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","ኤንቲ፥ ‹ታ ኣሴ ጊዴኬታ› ጌቴቲ ፄጌቲዳ ቤሳን፥ ‹ዴዖ ፆሳ ናይታ› ጌቴቲዲ ፄጌታና» ያጌስ። ");
INSERT INTO gofENT_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","ናቢያ ኢሳያሲ ኢስራዔሌ ኣሳባ፥ «ኢስራዔሌ ኣሳይ ኣባ ጋፃን ዴዒያ ሻፊያዳ ዳሪኮካ፥ ኤንታፌ ጉꬃ ኣሳ ፃላሊ ኣታና። ");
INSERT INTO gofENT_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","ጎዳይ ኣላሚያ ኡባ ቦላ ኤሌሲዲ ፖሎ ፒርዳ ፒርዳና።» ");
INSERT INTO gofENT_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","ቃሲካ ኢሳያሲ፥ «ኡባፌ ዎልቃማ ጎዳይ ኑስ ጉꬃ ዜሬꬂ ኣሾናባ ጊዲያኮ፥ ኑኒ ሶዶሜኔ ጋሞራ ካታማዳ ꬋያናሺን» ያጊዲ ኮይሮቲዲ ኦዲስ። ");
INSERT INTO gofENT_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","ያቲን፥ ኑ ዎይጋኔ? ፂሎቴꬃ ኮዪቦና ኣይሁዴ ጊዶና ኣሳይ ኣማኖን ፂሎቴꬂ ዴሚዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","ሺን ፂሎቴꬃኮ ጋꬂያ ሂጌይ ዴዒያ ኢስራዔሌ ኣሳይ ፂሎቴꬂ ዴሚቦኮና። ");
INSERT INTO gofENT_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","ኣይስ ዴሚቦኮና? ኤንቲ ፂሎቴꬃ ኣማኖን ጊዶናሺን ኦሶን ኤካናው ኮዪዳ ጊሾሳ። ያኒያ ጊሾ፥ ኤንቲ፥ «ꬉቢያ ሹቻን» ꬉቤቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","ጌሻ ማፃፋን፥ «ታኒ ፂዮኔን ꬉቢ ኩንዲሲያ ሹቻ ዎꬃና። ኢያን ኣማኒያ ኦኒካ ዬላቴና» ጌቴቲዲ ፃፌቲስ። ");
INSERT INTO gofENT_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","ታ ኢሻቶ፥ ታ ኩሜꬃ ዎዛናን ታ ኣሞቴይኔ ፆሳ ዎሴይ ኢስራዔሌይ ኣታና ሜላሳ። ");
INSERT INTO gofENT_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","ኤንቲ ፆሳስ ሚሼቶሶናሺን፥ ቱማ ኤራቴꬃን ሚሼቶናይሳ ታ ማርካታይስ። ");
INSERT INTO gofENT_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","ኤንቲ ፆሳ ፂሎቴꬃ ኦጊያ ኤሮና ኢፂዲ፥ ባንታ ሁዔ ፂሎቴꬃ ካሊዶሶናፔ ኣቲን ፆሳ ፂሎቴꬃ ኮዪቦኮና። ");
INSERT INTO gofENT_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","ኣሲ ኡባይ ኣማኖን ፂላና ሜላ ኪሪስቶሲ ሂጊያ ፖሊስ። ");
INSERT INTO gofENT_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","ኣሲ ሂጌ ናጊዲ ኤኪያ ፂሎቴꬃባ ሙሴይ ፃፊሼ፥ «ሂጌ ናጊያ ኦኒካ ሄ ሂጊያ ናጊዳ ሜላ ዴዔስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","ሺን ኣማኖን ኤኪያ ፂሎቴꬃባ ጌቴቲዳይ ሃይሳ፡ «ኔ ዎዛናን፥ ‹ኦኒ ሳሎ ኬያኔ?› ያጎፓ፤ ሄሲ ኪሪስቶሳ ዎꬊሳናሳ። ");
INSERT INTO gofENT_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","ዎይኮ፥ ‹ዱጌ ሳዓ ጋርሲ ዎꬋናይ ኦኔ?› ጎፓ፤ ሄሲ ኪሪስቶሳ ዱፎፔ ኬሳናሳ። ");
INSERT INTO gofENT_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","ሺን ያጊዲ ፃፌቲስ፡ ‹ፆሳ ቃላይ ኔ ማታና፤ ኔ ዶናኒኔ ኔ ዎዛናን ዴዔስ› ኑኒ ሂንቴው ኦዲያ ኣማኖ ቃላይ ሃይሳ። ");
INSERT INTO gofENT_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","«ዬሱሲ ጎዳ» ጋዳ ኔ ዶናን ማርካቲኮኔ ፆሳይ ኢያ ሃይቆፔ ዴንꬂዳይሳ ኔ ዎዛናን ኣማኒኮ፥ ኔ ኣታና። ");
INSERT INTO gofENT_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","ኣሲ ባ ዎዛናን ኣማኒዲ ፂሌስ፤ ባ ዶናን ማርካቲዲ ኣቴስ። ");
INSERT INTO gofENT_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","ጌሻ ማፃፋይ፥ «ኢያን ኣማኒያ ኦኒካ ዬላቴና» ያጌስ። ");
INSERT INTO gofENT_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","ኢሲ ፆሳይ ኡባ ጎዳ ጊዲያ ጊሾ ኣይሁዴታ ጊዶኒኔ ኣይሁዴ ጊዶና ኣሳ ጊዶን ዱማቴꬂ ባዋ። ኢ ባና ፄጊያ ኡባስ ዳሮ ኬሃ። ");
INSERT INTO gofENT_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","ጌሻ ማፃፋይ፥ «ጎዳ ሱንꬃ ፄጊያ ኦኒካ ኣታና» ያጌስ። ");
INSERT INTO gofENT_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","ያቲን፥ ኤንቲ ኣማኖና ዴዒሼ ዋኒዲ ኢያ ፄጋናው ዳንዳዖና? ኤንቲ ኢያባ ሲዖና ዴዒሼ ዋቲዲ ኢያ ኣማናናው ዳንዳዖና? ቃሲ ኤንታው ቃላ ኦዲያ ኣሲ ባይና ዴዒሺን፥ ዋኒዲ ሲዓናው ዳንዳዖና? ");
INSERT INTO gofENT_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","ኪቴቲዳ ኣሲ ባይና ዴዒሺን፥ ቃላይ ዋኒዲ ኦዴታናው ዳንዳዒ? ጌሻ ማፃፋን፥ «ኡፋይሳ ዎንጌላ ኦዲያ ኣሳ ቶሆቲ ዋኒዲ ሎዖና!» ያጊዲ ፃፌቲስ። ");
INSERT INTO gofENT_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","ሺን ኢሳያሲ፥ «ጎዳው፥ ኑ ማርካቴꬃ ኦኒ ኣማኒዴ?» ያጊዳይሳዳ፥ ኡባይ ዎንጌላ ኣማኒቦኮና። ");
INSERT INTO gofENT_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","ሄሳ ጊሾ፥ ኣማኖይ ሲሳፌ ዬስ፤ ሲሲ ኪሪስቶሳ ቃላፔ ዬስ። ");
INSERT INTO gofENT_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","ጊዶሺን፥ ኢስራዔሌ ኣሳይ ቃላ ሲዒቦኮና ጉሴዬ? ኣካይ ሲዒዶሶና። ጌሻ ማፃፋን፥ «ኤንታ ቃላይ ቢታ ኡባን ሲዔቲስ፥ ኤንታ ኦዳይ ሳዓ ጋፃ ጋኪስ» ያጌቲስ። ");
INSERT INTO gofENT_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","ሺን ኢስራዔሌ ኣሳይ ኤሪቦኮና ጉሴዬ? ሙሴይ ካሴ፥ «ታኒ ሂንቴና ሌቄቲዳ ኣሳን ቂሮይሳና፤ ቃሲ ኤያ ኣሳን ሂንቴና ዪሎያና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","ቃሲ ኢሳያሲ፥ «ታና ኮዪቦና ኣሳስ ቤንታስ፤ ታና ኦይቺቦና ኣሳስ ቆንጫስ» ያጊዲ ያዮና ኦዲስ። ");
INSERT INTO gofENT_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","ሺን ኢሳያሲ ኢስራዔሌታባ ኦዲሼ፥ «ኡባ ዎዴ ኪቴቶና ኣሳሲኔ ታና ኢፂያ ኣሳስ ታ ኩሺያ ሚጫስ» ያጌስ። ");
INSERT INTO gofENT_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","ኣኔ ታ ኦይቻይስ፡ ያቲን፥ ፆሳይ ባ ኣሳ ኣጊዴዬ? ኣጊቤና! ታኒ ታ ሁዔን ኢስራዔሌ፤ ኣብራሃሜ ሼሺ፤ ቢኒያሜ ዛሬ። ");
INSERT INTO gofENT_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","ፆሳይ ኮይሮ ዶሪዳ ባ ኣሳታ ዬጌና። ጌሻ ማፃፋን፥ ኤሊያሲ ኢስራዔላታ ፆሳ ሲንꬃን ዋቲ ሞቲዳኮ፥ ሂንቴ ኤሬኬቲ? ");
INSERT INTO gofENT_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","ኤሊያሲ፥ «ጎዳው፥ ኤንቲ ኔ ናቤታ ዎꬊዶሶና፥ ኔ ያርሾ ቤሳካ ላሊዶሶና። ታ ታርካ ኣታስ፤ ኤንቲ ታናካ ዎꬋናው ኮዮሶና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","ፆሳይ ኢያው ዎይጊ ዛሪዴ? «ባዓሌ ኤቃስ ጎይኒቦና ላፑን ሙኩሉ ኣሳ ታው ኣሻስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","ሄሳዳካ፥ ሃ ዎዲያን ፆሳይ ባ ኣꬎ ኬሃቴꬃን ዶሪዳ ጉꬃ ኢስራዔሌቲ ዴዖሶና። ");
INSERT INTO gofENT_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","ኢ ኤንታ ዶሪዳይ ባ ኣꬎ ኬሃቴꬃናፔ ኣቲን ኤንታ ኦሶን ጊዴና። ዶሮይ ኦሶን ጊዲኮ፥ ኢያ ኣꬎ ኬሃቴꬃይ ቱማ ኣꬎ ኬሃቴꬂ ጊዴና። ");
INSERT INTO gofENT_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","ያቲን፥ ዋኒዴ? ኢስራዔሌቲ ባንታ ኮያባ ዴሚቦኮና፥ ሺን ፆሳይ ዶሪዳ ጉꬃቲ ዴሚዶሶና። ኣቲዳይሳቲ ባንታ ዎዛና ሙሚሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","ሄሲካ፥ ጌሻ ማፃፋን፥ «ኤንቲ ባንታ ኣይፊያን ቤዖናዳ ባንታ ሃይꬃን ሲዖናዳ፥ ሃኖ ጋካናው ኤንታው ፆሳይ ኣዛላ ኣያና ኢሚስ» ጌቴቲዲ ፃፌቲዳይሳዳ ሃኒስ። ");
INSERT INTO gofENT_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","ቃሲ ዳዊቴይ፥ «ኤንቲ ሚያ ጋይታይ ኤንታ ፂሄዳ ኦይኮ፤ ኤንታ ጉፋንꬂያ ኣፎ ጊዶ፤ ኤንታ ኢታቴꬃይ ኤንታ ቦላ ጋኮ። ");
INSERT INTO gofENT_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","ኤንቲ ፄሎናዳ ኤንታ ኣይፌይ ጎዜቶ፤ ኡባ ዎዴ ሜቶን ኤንቲ ኩኒዲ ዴዖ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","ያቲን፥ ኣይሁዴቲ ዛሪ ዴንዶና ሜላ ኩንዲዶናዬ? ጊዴና! ኤንታ ኩንዴꬃይ ኣይሁዴ ጊዶና ኣሳይ ኣታና ሜላ ጋሶ ጊዲስ። ሄሲካ ኣይሁዴቲ ኤንታ ቦላ ቃናታናዳ ኦꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","ኣይሁዴታ ናጋራይ ኣላሚያስ ዳሮ ኣንጆ ኤሂስ፤ ቃሲ ኤንታ ኩንዴꬃይ ኣይሁዴ ጊዶና ኣሳስ ዳሮ ኣንጆ ጊዲስ። ያቲን፥ ዶሬቲዳ ኣይሁዴቲ ኩሜꬂ ኣቲያ ዎዴ ኣንጆይ ኣይ ሜላ ዳራንዴሻ! ");
INSERT INTO gofENT_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","ታኒ፥ ሃዒ ሂንቴው ኣይሁዴ ጊዶና ኣሳስ ኦዳይስ። ኣይሁዴ ጊዶና ኣሳስ ሃዋሬ ጊዳዳ ኦꬄይሳን ታኒ ዳሮ ጬቄታይስ። ");
INSERT INTO gofENT_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","ታ ሄሳ ኦꬂዳይ ታው ኣሾን ዛሬ ጊዲዳ ኢስራዔሌታ ቂሮያዳ ኤንታፌ ጉꬃታ ኣሻናሳ። ");
INSERT INTO gofENT_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","ፆሳይ ኤንታ ዬጊዳ ዎዴ ሃ ኣላሜይ ፆሳራ ሲጌቲስ። ፆሳይ ኤንታ ሺሺ ኤኪያ ዎዴ ሃይቂዳ ኣሲ ሃይቆፔ ዴንዲዳ ሜላ ጊዴስ። ");
INSERT INTO gofENT_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","ኮይሮ ሜንꬂዳ ባሶ ኡይꬃይ ፆሳስ ያርሼቲዲ ጌሺ ጊዲኮ፥ ሙሜ ኡይꬃይካ ጌሺ። ሚꬃስ ፃጶይ ጌሺ ጊዲኮ፥ ታሼይካ ጌሺ። ");
INSERT INTO gofENT_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","ጋዴን ቶኪዳ ሻማሆ ታሼ ጊዲዳ ኣይሁዴቲ ካሬቲን፥ ሂንቴ ባዞን ዶሊዳ ሻማሆ ታሼ ጊዲዳ ኣይሁዴ ጊዶናይሳቲ ኤንታ ቤሳን ꬋንꬄቲዲ ኤንታ ኣንጁዋኔ ዱሬቴꬃ ሻኬቲዴታ። ");
INSERT INTO gofENT_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","ሂዛ፥ ሂንቴ ታሼዳ ካሬቲ ዎꬊዳ ኣይሁዴታ ቦላ ኦቶርቶፊቴ። ሂንቴ ኦቶርቲያባ ጊዲኮ፥ ፃጶይ ሂንቴና ቶኬሲፔ ኣቲን ሂንቴ ፃጱዋ ቶኮናይሳ ኣኬኪቴ። ");
INSERT INTO gofENT_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","ኔኒ፥ «ሄ ታሼቲ ካሬቲዳይ፥ ታ ኤንታ ቤሳን ꬋንꬄታና ሜላሳ» ጋናው ዳንዳዓሳ። ");
INSERT INTO gofENT_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","ሄሲ ቱማ። ኤንቲ ኣማኒቦና ጊሾ ካሬቲዶሶና። ኔኒ ኣማኒዳ ጊሾ ሄ ቤሳን ኤቃዳሳ። ኔኒ ያያናው ቤሴስፔ ኣቲን ኦቶራናው ቤሴና። ");
INSERT INTO gofENT_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","ፆሳይ ሜꬎን ታሼ ጊዲዳ ኣይሁዴታስ ቃꬌቶና ኢፂኮ ሂንቴዉካ ቃꬌቴና። ");
INSERT INTO gofENT_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","ሂዛ፥ ፆሳይ ኣይ ሜላ ኬሄኮኔ ኣይ ሜላ ያሺያኮ ቤዓ። ኢ ያሼይ ኪቴቶናይሳታ፥ ቃሲ ኢ ኬሄይ ኢያ ኣማኒዲ ሚኒዲ ኤቂዳይሳታሳ። ሚኒዲ ኤቆና ኢፂኮ ሂንቴካ ካሬታና። ");
INSERT INTO gofENT_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","ኣይሁዴቲ ኣማኒኮ፥ ካሴ ኤንቲ ዴዒያ ቤሳ ሲማና። ፆሳይ ኤንታ ዛሪዲ፥ ዎꬃናው ዳንዳዔስ። ");
INSERT INTO gofENT_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","ሂንቴና ባዞን ዴዒያ ሻማሆ ጊዲዳ ኣይሁዴ ጊዶናይሳታ ቃንፂዲ፥ ጋዴን ቶኬቲዳ ሻማሁዋ ቦላ ሂንቴና ቶኪኮ፥ ሜꬎን ጋዴ ሻማሆ ጊዲዳ ኣይሁዴታ ባንታ ኮይሮ ቤሳን ዛሪ ቶካናው ዋኒዲ ዳንዳዔቴኔ? ");
INSERT INTO gofENT_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","ታ ኢሻቶ፥ ሂንቴ ሂንቴና ኤራንቾ ጊዲ ጬቄቶፊቴ። ታ ሂንቴው ኦዲያ ኢሲ ፁሪ ዴዔስ። ሄሲካ ኢስራዔሌታፔ ባጋይ ሲዖና ኢፂዳይ ዉርሴꬂ ጋካናው ጊዶናሺን ኣታናው ዴዒያ ኣይሁዴ ጊዶና ኣሳይ ኩሜꬂ ፆሳኮ ያና ጋካናሳ። ");
INSERT INTO gofENT_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","ሄሳዳካ፥ ኢስራዔሌ ኣሳ ኡባይ ኣታና። ጌሻ ማፃፋን፥ «ኑና ኣሼይሲ ፂዮኔፔ ያና፤ ያይቆባ ዜሬꬃፌ ኢታ ኡባ ዲጋና። ");
INSERT INTO gofENT_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","ታኒ ኤንታ ናጋራ ኣቶ ጊያ ዎዴ ኤንታራ ጫቃና ጫቆይ ሃይሳ» ጌቴቲዲ ፃፌቲስ። ");
INSERT INTO gofENT_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","ኣይሁዴቲ ዎንጌላ ኤኮና ኢፂዲ፥ ሂንቴ ጊሾ ፆሳራ ሞርኬ ጊዲዶሶና። ጊዶሺን፥ ሃዒካ ኤንቲ ዶሬቲዳይሳታ፥ ፆሳይ ኤንታ ኣዋታ ጊሾ ኤንታ ዶሴስ። ");
INSERT INTO gofENT_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","ፆሳይ ባ ኢሙዋኒኔ ባ ፄሳን ቂሮቴና። ");
INSERT INTO gofENT_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","ሂንቴ ኣይሁዴ ጊዶናይሳቲ ካሴ ፆሳስ ኪቴቲቤኬታ። ሺን ሃዒ ኣይሁዴቲ ኪቴቶና ኢፂን፥ ሂንቴ ፆሳ ማሮቴꬃ ኤኪዴታ። ");
INSERT INTO gofENT_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","ሄሳዳካ፥ ሂንቴ ኤኪዳ ማሮቴꬃ ኣይሁዴቲ ኤካና ሜላ ሃዒ ፆሳስ ኪቴቶና ኢፂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","ፆሳይ ኣሳ ኡባ ባ ማሮቴꬃ ቤሳናው ኮዪዲ፥ ኣሲ ኡባይ ኪቴቶና ኢፃና ሜላ ኦꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","ፆሳ ዱሬቴꬃ፥ ጪንጫቴꬃኔ ኤራቴꬃ ኣኬኪዲ ኦዳናይ ኦኔ? ኢያ ፒርዳይ ፒልጌቴና፥ ኢያ ኦጌይ ኤሬቴና። ");
INSERT INTO gofENT_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","ጌሻ ማፃፋን፥ «ጎዳ ቆፋ ኤሬይ ኦኔ? ኢያ ዞራናው ዳንዳዔይ ኦኔ? ");
INSERT INTO gofENT_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","ፆሳስ ታልዔይኔ ታልዒያ ዛሪዲ ኤኬይ ኦኔ?» ያጌስ። ");
INSERT INTO gofENT_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","ኡባ ኢ ሜꬊስ፤ ኡባይ ኢያን ዴዔስ፤ ኡባይ ኢያ ቦንቾሳ። ፆሳስ ሜሪናው ቦንቾይ ጊዶ። ኣሚንዒ። ");
INSERT INTO gofENT_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","ሂዛ፥ ታ ኢሻቶ፥ ሂንቴ፥ ሂንቴ ኣሳቴꬃ ፆሳ ኡፋይሲያ፥ ዴዖኔ ጌሻ ያርሾ ኦꬂዲ፥ ኢማና ሜላ ታኒ ሂንቴና ፆሳ ማሮቴꬃን ዎሳይስ። ፆሳ ሂንቴ ጎይናናው ቤሲያ ቱማ ኦጌይ ሄሳ። ");
INSERT INTO gofENT_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","ሎዖ፥ ኡፋይሴይሳኔ ፖሎ ጊዲዳ ፆሳ ሼኒያ ሂንቴ ሻኪ ኤራናው ሂንቴ ቆፋን ላሜቲቴፔ ኣቲን ሃ ኣላሚያ ዳኖፒቴ። ");
INSERT INTO gofENT_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","ፆሳይ ሂንቴ ኢሱዋስ ኢሱዋስ ኢሚዳ ኣማኑዋ ሜላ ዎዛናማ ኣሳዳ ቆፒቴ። ቆፓናው ቤሴይሳፌ ኣꬂዲ ሂንቴና ዱማዪዲ፥ ኦቶሮን ቆፖፊቴ ጋዳ ታው ኢሜቲዳ ኣꬎ ኬሃቴꬃን ሂንቴው ኦዳይስ። ");
INSERT INTO gofENT_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","ኑ ኢሲ ኣሳቴꬃ ጊዶን ዱማ ዱማ ኪፊሌቲ ዴዖሶና፤ ሄ ዱማ ዱማ ኪፊሌታስ ዱማ ዱማ ኦሶይ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","ሄሳዳ፥ ኑኒ ዳሮ ኣሲ ጊዲኮካ ኪሪስቶሳን ኢሲ ኣሳቴꬂ ጊዲዳ። ኑኒ ኢሲ ኣሳቴꬂ ጊዲዲ ዱማ ዱማ ኪፊሌቲ ኢሶይ ኢሱዋራ ኦይኬቲዳ። ");
INSERT INTO gofENT_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","ኑስ ኢሜቲዳ ኣꬎ ኬሃቴꬃን ዱማ ዱማ ኢሞታቲ ዴዖሶና። ኑ ኢሞይ ቲንቢት ኦዶ ጊዲኮ፥ ኑስ ዴዒያ ኣማኑዋ ሜላ ኦዳናው ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","ኑ ኢሞይ ሃራታ ማዴ ጊዲኮ፥ ሄ ኦሱዋን ሚናናው ቤሴስ፤ ታማርሶ ጊዲኮ፥ ሄ ታማርሱዋን ሚናናው ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","ኑ ኢሞይ ሃራታ ሚንꬄꬆ ጊዲኮ፥ ሚኒዲ ሚንꬄꬃናው ቤሴስ። ኑ ኢሞይ ኑስ ዴዒያባፔ ሃራታስ ኢሞ ጊዲኮ፥ ዎዛናፔ ኢማናው ቤሴስ። ኑ ኢሞይ ኣይሶ ጊዲኮ፥ ሚኒዲ ኣይሳናው ቤሴስ። ኑ ኢሞይ ሃራታስ ኬሆ ጊዲኮ፥ ኡፋይሳን ኬሃናው ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","ሂንቴ ሲቆይ ቆꬌፔ ቆሞን ጊዳናው ቤሴና። ኢታባ ኢፂቴ፤ ሎዖባ ሚንꬂዲ ኦይኪቴ። ");
INSERT INTO gofENT_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","ኢሶይ ኢሱዋራ ኢሻዳ ሲቄቲቴ፤ ኢሶይ ኢሱዋ ቦንቺቴ። ");
INSERT INTO gofENT_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","ኣዛሎፊቴ፤ ሂንቴ ኣያናን ሚኒዲ ጎዳስ ኦꬂቴ። ");
INSERT INTO gofENT_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","ፆሳይ ኢሚዳ ኡፋይሳን ኡፋይቲቴ፤ ሜቱዋ ዳንዳዒቴ፤ ኡባ ዎዴ ፆሳ ዎሲቴ። ");
INSERT INTO gofENT_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","ኣማኒያ ጌሻታ ኮሺያባን ማዲቴ፤ ኢማꬃታ ሞኪቴ። ");
INSERT INTO gofENT_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","ሂንቴና ጎዴይሳታ ኣንጂቴ፤ ኣንጂቴፔ ኣቲን ባዶፊቴ። ");
INSERT INTO gofENT_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","ኡፋይቴሳታራ ኡፋይቲቴ፤ ዬኬይሳታራ ዬኪቴ። ");
INSERT INTO gofENT_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","ኢሶይ ኢሱዋራ ኢሲ ቆፋን ዴዒቴ። ኦቶሮ ቆፋ ኣጊዲ፥ ሂንቴና ካዉሺዲ፥ ካዉሻ ኦሶ ኦꬂቴ። ሂንቴ ሂንቴና ጪንጫ ጊዲ ቆፖፊቴ። ");
INSERT INTO gofENT_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","ኦኒካ ሂንቴው ኢታባ ኦꬂኮ፥ ሄ ኡራስ ኢታ ዛሮፒቴ። ኣሳ ኡባ ሲንꬃን ናሺሲያ ሎዖ ኦሶ ኦꬂቴ። ");
INSERT INTO gofENT_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","ኣሳ ኡባራ ሳሮን ዳናው ሂንቴው ዳንዳዔቲያ ኡባ ኦꬂቴ። ");
INSERT INTO gofENT_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","ታ ኢሻቶ፥ ሂንቴ፥ ሂንቴ ሁዔን ኣሳስ ሃሎ ኬዮፒቴ። ፆሳይ ሃሎ ኬያና ሜላ ኢያው ኣጋጊቴ። ጌሻ ማፃፋን፥ «ታኒ ሃሎ ኬያና፤ ታኒ ኩሼ ዛራና» ያጌስ ጎዳይ፥ ጌቴቲዲ ፃፌቲስ። ");
INSERT INTO gofENT_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","ሺን ጌሻ ማፃፋን፥ «ኔ ሞርኬይ ኮሻቲኮ ሙዛ፤ ኢ ሳሞቲኮ ኡሻ። ኔኒ ሄሳ ኦꬂኮ ኢያ ሁዔን ዬላ ታማ ቦንቆ ቆላሳ» ጌቴቲዲ ፃፌቲስ። ");
INSERT INTO gofENT_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","ኢታ ሎዖን ፆናፔ ኣቲን ኢታን ፆኔቶፋ። ");
INSERT INTO gofENT_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","ፆሳ ሼኔ ጊዶናሺን ማቲ ኢሜቶና ጊሾኔ ሃዒ ዴዒያ ሹማቲካ ፆሳ ሼኔን ሹሜቲዳ ጊሾ ኣሲ ኡባይ ዴሪያ ኣይሴይሳታስ ኪቴታናው ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","ሄሳ ጊሾ፥ ማታራ ዴዔይሳታስ ኪቴቶና ኢፂያ ኦኒካ ፆሳ ኪታ ኢፄስ። ኪቴቶና ኢፂያ ኦኒካ ባ ቦላ ፒርዳ ኤሄስ። ");
INSERT INTO gofENT_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","ኣይሴይሳቲ ኢታ ኦꬄይሳታፔ ኣቲን ሎዖ ኦꬄይሳታ ያሾኮና። ኣይሴይሳታስ ያዮና ኣጋናው ኮያይ? ያኮ ሎዖ ኦꬃ፤ ኤንቲ ኔና ጋላታና። ");
INSERT INTO gofENT_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","ኤንቲ ኔው ሎዖባ ኦꬃናው ሹሜቲዳ ፆሳ ኣይሌ። ሺን ኔኒ ኢታባ ኦꬂኮ፥ ኤንቲ ኢታባ ኦꬂዳይሳ ሴሪያ ጊሾ ኢያው ያያ። ኤንቲ ኢታ ኦꬄይሳታ ሴሪዲ፥ ፆሳ ሃንቁዋ ቆንጪሲያ ፆሳ ኣይሌ። ");
INSERT INTO gofENT_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","ሄሳ ጊሾ፥ ፆሳ ሃንቁዋ ፃላላስ ጊዶናሺን ሂንቴ ካሃይ ማርካቲያ ጊሾ ዴሪያ ኣይሴይሳታስ ኪቴታናው ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","ሂንቴ ጊራ ጊሬይካ ሄሳሳ። ዴሪያ ኣይሴይሳቲ ሄ ኦሱዋ ኦꬄይ፥ ኤንቲ ፆሳ ኣይሌታ ጊዲዳ ጊሾሳ። ");
INSERT INTO gofENT_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","ኢሱዋስ ኢሱዋስ ቤሴይሳ ኢሚቴ። ጊራ ጊራናው ቤሴይሳስ ጊሪቴ፤ ቃራፃ ቃንፃናው ቤሴይሳስ ቃራፃ ቃንፂቴ፤ ያያናው ቤሴይሳስ ያዪቴ፤ ቦንቾይ ቤሴይሳ ቦንቺቴ። ");
INSERT INTO gofENT_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","ኢሶይ ኢሱዋራ ሲቄቲቴ። ሲቆ ኣጮፔ ኣቲን ሂንቴ ቦላ ሃራ ኣጮይ ዶፖ። ኣሴ ሲቂያ ኦኒካ ሂጌይ ጌይሳ ፖሊስ። ");
INSERT INTO gofENT_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","«ላሞፋ፤ ዎꬎፓ፤ ካይሶቶፓ፤ ኣሞቶፋ» ጊያ ኪታይኔ ሃራ ኪታ ኡባይ፥ «ኣሴ ኔ ሁዔዳ ዶሳ» ጊያ ኪታን ቃሼቲስ። ");
INSERT INTO gofENT_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","ኣሴ ሲቂያ ኦኒካ ኢያ ቦላ ኢታባ ኦꬄና። ሄሳ ጊሾ፥ ኣሴ ሲቄይሲ ሂጌ ኪታ ፖሊስ። ");
INSERT INTO gofENT_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","ꬊስኮፌ ሂንቴ ባርኪያ ዎዴይ ሃዒ ጊዴይሳ ኣኬኪዲ ሄሳ ኦꬂቴ። ኑ ኣታና ዎዴይ ኮይሮ ኑ ኣማኒዳ ዎዲያፔ ሃዒ ኑኮ ማቲስ። ");
INSERT INTO gofENT_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","ꬉማ ዎዴይ ኣꬋናው ሃኔስ፤ ዎንታይ ማቲስ። ሂዛ፥ ኑኒ ꬉማ ኦሶ ኣጊዲ ፖዖ ኦላ ሚሼ ኦይኮስ። ");
INSERT INTO gofENT_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","ኣኔ ጋላስ ፖዖን ዴዒያ ኣሳዳ ማራን ዴዖስ። ማꬆኒኔ ላይማቴꬃራ ጋሄቲያ ዱማ ዱማ ቱና ኦሶታን፥ ፓላማኒኔ ቃናቴን ጊዶፖ። ");
INSERT INTO gofENT_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","ጎዳ ዬሱስ ኪሪስቶሳ ካንዱዋ ማዒቴ፤ ሂንቴ ናጋራንቾ ኣሳቴꬃይ ባ ኣሙዋ ፖላና ሜላ ኢያው ቆፖፊቴ። ");
INSERT INTO gofENT_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","ኣማኖን ዳቡሪዳ ኦናካ ሺሺ ኤኪቴፔ ኣቲን ኢያ ቆፋ ቦላ ፒርዶፊቴ። ");
INSERT INTO gofENT_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","ሌሚሶስ፥ ኣማኖን ሚኒዳ ኢሲ ኣሲ ኣይ ካꬂካ ማናው ዳንዳዔስ። ሺን ኣማኖን ዳቡሪያ ኣሲ ኣታኪልቴ ፃላላ ሜስ። ");
INSERT INTO gofENT_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","ኡባባ ሚያ ኣሲ ሞና ኡራ ካꬎፖ። ኡባባ ሞና ኣሲ ሚያ ኡራ ቦላ ፒርዶፎ። ፆሳይ ኡባ ሚያ ኡራ ሺሺ ኤኪስ። ");
INSERT INTO gofENT_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","ሃራ ኣሳ ኣይሌ ቦላ ፒርዴይ ኔኒ ኦኔ? ኢ ዳቡሪን ዎይኮ ሚኒን ባ ጎዳሳ። ጎዳይ ኢያ ኤሳናው ዳንዳዒያ ጊሾ ኢ ሚኒዲ ኤቃና። ");
INSERT INTO gofENT_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","ቃሲ «ኢሲ ጋላሳይ ሃራ ጋላሳፔ ኣꬌስ» ያጊዲ ቆፒያ ኣሲ ዴዔስ። ሃራይ ቃሲ፥ «ጋላሳቲ ኡባይ ኢሲ ሜላ» ጊዲ ቆፔስ። ሺን ኢሶይ ኢሶይ ባ ቆፋ ኣኬኪዲ ቃቾ። ");
INSERT INTO gofENT_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","ኢሲ ጋላሳ ሃራ ጋላሳታፔ ኣꬂዲ ቦንቺያ ኦኒካ ጎዳ ቦንቾስ ጊዲ ኦꬄስ። ኡባ ካꬂ ሚያ ኣሲ ጎዳ ቦንቾስ ጊዲ ሜስ። ኢ ሚያ ሄ ካꬃ ጊሾ ፆሳ ጋላቴስ። ኡባ ካꬂ ሞና ኣሲ ጎዳ ቦንቾስ ሞና ኣጌስ፤ ቃሲ ሞና ኣጎን ፆሳ ጋላቴስ። ");
INSERT INTO gofENT_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","ኑፔ ኦኒካ ባው ዴና፤ ቃሲ ኑ ጊዶፌ ኦኒካ ባው ሃይቄና። ");
INSERT INTO gofENT_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","ኑ ዴዖን ዴዒኮ ጎዳስ ዴዖስ፤ ቃሲ ሃይቂኮካ ጎዳስ ሃይቆስ። ሂዛ፥ ኑ ዴዖን ዴዒን ዎይኮ ሃይቂን ጎዳሳ። ");
INSERT INTO gofENT_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","ኪሪስቶሲ ሃይቂዲ ሃይቆፔ ዴንዲዳይ፥ ዴዖን ዴዔይሳታሲኔ ሃይቂዳይሳታስ ጎዳ ጊዳናሳ። ");
INSERT INTO gofENT_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","ያቲን፥ ኔኒ ኔ ኢሻ ቦላ ኣይስ ፒርዳይ? ዎይኮ ኔኒ ኔ ኢሻ ኣይስ ካꬋይ? ኑኒ ኡባይ ፆሳ ፒርዳ ኣራታ ሲንꬃን ኤቃና። ");
INSERT INTO gofENT_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","ጌሻ ማፃፋን ጎዳይ፥ «ታኒ ዴዖን ዴዓይስ፤ ኣሳ ኡባይ ታ ሲንꬃን ጉልባታና፤ ታኒ ፆሴ ጊዴይሳ ማርካታና» ያጌስ። ");
INSERT INTO gofENT_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","ሂዛ፥ ኑ ኦꬂዳባስ ኑ ሁዔን ሁዔን ፆሳ ሲንꬃን ሺቂዲ ዛሮ ኢማና። ");
INSERT INTO gofENT_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","ሄሳ ጊሾ፥ ኑኒ ኢሶይ ኢሱዋ ቦላ ፒርዴይሳ ኣጎስ። ሺን ሂንቴ ኢሻ ꬉብሲዲ ዎይኮ ቃፂዲ ናጋራን ጌልሲያባ ኦꬆናዳ ናጌቲቴ። ");
INSERT INTO gofENT_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","ጎዳ ዬሱሳ ኣማኒያ ኣሳዳ፥ ባ ሁዔን ቱና ጊዲዳ ካꬂ ባይናይሳ ታኒ ጌሻዳ ኤራይስ። ሺን ኢሲ ኣሲ ኢሲባ ቱና ጊዲ ቆፒኮ ሄሲ ኢያው ቱና ጊዴስ። ");
INSERT INTO gofENT_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","ኔ ሚያ ካꬃ ጊሾ ኔ ኢሻ ꬉቢያባ ጊዲኮ፥ ኪሪስቶሳን ዴዒያ ኔ ኢሻ ሲቃካ። ኪሪስቶሲ ኢያ ጊሾ ሃይቂዳ ኡራ ኔ ሚያ ካꬃን ኢያ ኣያና ዴዑዋ ꬋይሶፋ። ");
INSERT INTO gofENT_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","ሂዛ፥ ሂንቴው ዴዒያ ላዓቴꬃ ሃራቲ ቦራና ሜላ ኦꬆፊቴ። ");
INSERT INTO gofENT_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","ፆሳ ካዎቴꬃይ ጌሻ ኣያናን ቤንቲያ ፂሎቴꬂ፥ ሳሮቴꬂኔ ቱማ ኡፋይሲፌ ኣቲን ሙሳባኔ ኡሻባ ጊዴና። ");
INSERT INTO gofENT_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","ሄሳዳ ኪሪስቶሳስ ኦꬂያ ኣሲ ፆሳ ኡፋይሴስ፤ ኣሳንካ ኣንጄቴስ። ");
INSERT INTO gofENT_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","ሄሳ ጊሾ፥ ኣኔ ኑኒ ሳሮቴꬂ ቤንቲያ ኦጊያኔ ኢሱዋ ኢሱዋ ኣማኖን ሚንꬂያ ኦጊያ ኮዮስ። ");
INSERT INTO gofENT_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","ካꬃ ጊሾ ጋዳ ፆሳ ኦሱዋ ꬋይስሶፋ። ኡባ ካꬂ ሜቴቴስ፥ ሺን ሃራ ኣሲ ናጋራን ꬉብሲያ ካꬂ ሙሲ ኢታ። ");
INSERT INTO gofENT_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","ኔ ኢሻይ ꬉቤቶና ሜላ ኣሾ ሞና ዎይኮ ኡሹ ኡዮና ዎይኮ ኔ ኢሻ ꬉቢያ ሃራባ ኦꬆና ኣጎይ ሎዖ። ");
INSERT INTO gofENT_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","ሂዛ፥ ሃ ኔ ኣማኑዋ ኔ ጊዶኒኔ ኔ ፆሳ ጊዶን ናጋ። ሊኬ ጊዲ ቆፒዳባ ኦꬂያ ዎዴ ኢያ ካሃይ ሞቶና ኡራይ ኣንጄቲዳይሳ። ");
INSERT INTO gofENT_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","ሺን ሲꬊሼ ሚያ ኡራስ ኢያ ሙሳይ ኣማኖን ጊዶና ጊሾ ፒርዴቴስ። ኣማኖይ ባይና ኦሴቲዳ ኦሶ ኡባይ ናጋራ። ");
INSERT INTO gofENT_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","ኑኒ ኣማኖን ሚኒዳይሳቲ ዳቡራንቾታ ቶሁዋ ቶካናው ቤሴስ። ኑኒ ኑና ኡፋይሳናው ቤሴና። ");
INSERT INTO gofENT_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","ኑኒ ኑ ኢሻ ኣማኖን ሚንꬃናው ኢያ ማዳናዉኔ ኡፋይሳናው ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","ኪሪስቶሲ ባና ኡፋይሲቤና። ሺን ጌሻ ማፃፋን፥ «ኣሳይ ኔና ጫዪዳ ጫሻይ ታና ጋኪስ» ጌቴቲ ፃፌቲዳይሳዳ ሃኒስ። ");
INSERT INTO gofENT_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","ጌሻ ማፃፋይ ኢሚያ ጌንጫኒኔ ሚንꬄꬁዋን ኑ ኡፋይሳ ኤካና ሜላ ጌሻ ማፃፋን ፃፌቲዳ ኡባይ ኑና ታማርሳናው ፃፌቲስ። ");
INSERT INTO gofENT_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","ጌንጫኔ ሚኖቴꬂ ኢሚያ ጎዳይ ሂንቴ ኪሪስቶስ ዬሱሳ ካሊያ ዎዴ ኢሲፌቴꬂ ሂንቴው ኢሞ። ");
INSERT INTO gofENT_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","ሄሲካ፥ ኑ ጎዳ ዬሱስ ኪሪስቶሳ ኣዋ፥ ፆሳ፥ ኢሲ ዎዛናኒኔ ኢሲ ቃላን ሂንቴ ቦንቻና ሜላሳ። ");
INSERT INTO gofENT_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","ኪሪስቶሲ ሂንቴና ኤኪዳይሳዳ ፆሳ ቦንቾስ ኢሶይ ኢሱዋ ኤኪቴ። ");
INSERT INTO gofENT_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","ፆሳይ ቤኒ ኣዋታስ ኢሚዳ ኡፋይሳይ ፖሌታና ሜላኔ ኢያ ቱማቴꬃይ ኤሬታና ሜላ ኪሪስቶሲ ኣይሁዴታ ኣይሌ ጊዲዲ ዪዳይሳ ታ ሂንቴው ኦዳይስ። ");
INSERT INTO gofENT_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","ኪሪስቶሲ ኣይሁዴታ ኣይሌ ጊዲዳ ሃራ ጋሶይ ቃሲ ኣይሁዴ ጊዶና ኣሳቲ ፆሳ ኢያ ማሮቴꬃ ጊሾ ጋላታና ሜላሳ። ጌሻ ማፃፋን፥ «ታ ኔና ኣይሁዴ ጊዶና ኣሳ ጊዶን ጋላታና፤ ኔ ሱንꬃ ሳባና» ጌቴቲዲ ፃፌቲዳይሳዳ ሃኒስ። ");
INSERT INTO gofENT_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","ቃሲ፥ «ኣይሁዴ ጊዶና ኣሳው፥ ፆሳ ዴሪያራ ኡፋይቲቴ» ያጌቲስ። ");
INSERT INTO gofENT_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","ቃሲ ዛሪዲ፥ «ኣይሁዴ ጊዶና ኣሳው፥ ጎዳ ጋላቲቴ፤ ካዎቴꬃ ኡባይ ኢያ ሳቢቴ» ያጌቲስ። ");
INSERT INTO gofENT_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","ሄሳዳ ኢሳያሲ፥ «ኢሴዬ ዛሬፔ ዬሌቲያ ኢሶይ ያና፤ ኢ ካዎቴꬃ ኡባ ሃራና። ኤንቲ ባንታ ኡፋይሳ ኢያ ቦላ ዎꬃና» ያጌስ። ");
INSERT INTO gofENT_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","ጌሻ ኣያና ዎልቃን ሂንቴ ዲጫና ሜላ ኡፋይሲ ኢሚያ ፆሳይ፥ ሂንቴ ኣማኑዋ ጋሶን ሂንቴው ኡፋይሲኔ ሳሮቴꬂ ኩሜꬂ ኢሞ። ");
INSERT INTO gofENT_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","ታ ኢሻቶ፥ ሂንቴናን ሎዖቴꬂኔ ኤራቴꬂ ኩሚዳይሳ ቃሲ ኢሶይ ኢሱዋ ዞራናው ዳንዳዔይሳ ታ ጌሻዳ ኤራይስ። ");
INSERT INTO gofENT_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","ታኒ ሂንቴና ኢሲ ኢሲባ ጉጃ ኣኬኪሳናው ኮያዳ ያዮና ሃ ዳብዳቢያ ሂንቴው ፃፋስ። ");
INSERT INTO gofENT_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","ታኒ ኪሪስቶስ ዬሱሳ ኣይሌ ጊዳዳ፥ ኣይሁዴ ጊዶና ኣሳስ ካሂኔዳ ኦꬃዳ፥ ዎንጌላ ኦዳና ሜላ ፆሳይ ታው ኣꬎ ኬሃቴꬃ ኢሚስ። ኣይሁዴ ጊዶና ኣሳይ ጌሻ ኣያናን ጌዪዲ፥ ፆሳ ኡፋይሲያ ያርሾ ጊዳና ሜላ ፆሳይ ሄሳ ኦꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","ታኒ ኪሪስቶስ ዬሱሳን ጊዳዳ ፆሳስ ኦꬂያ ኦሱዋን ጬቄታይስ። ");
INSERT INTO gofENT_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","ኣይሁዴ ጊዶና ኣሳይ ፆሳስ ኪቴታናዳ፥ ኪሪስቶሲ ታ ቃላኔ ታ ኦሱዋ ባጋራ ኦꬂዳ ኦሱዋፔ ኣቲን ሃሪ ታ ጬቄቲያባይ ባዋ። ");
INSERT INTO gofENT_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","ፆሳይ ሄሳ ማላታኒኔ ጌሻ ኣያና ዎልቃን ዋቲ ኦꬂዳኮ ታ ሂንቴው ኦዳና። ታኒ ዬሩሳላሜፔ ዶማዳ፥ ኢሊዋርቆኔ ጋካናው ኪሪስቶሳ ዎንጌላ ሳባካስ። ");
INSERT INTO gofENT_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","ታኒ ሃራ ኣሲ ባሲዳ ቤሳን ኬፃናው ኮዪኬ። ኪሪስቶሳ ሱንꬃይ ፄጌቲቦና ቤሳን ዎንጌላ ኦዳናው ኣሞታይስ። ");
INSERT INTO gofENT_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","ጌሻ ማፃፋን፥ «ኢያባይ ኦዴቲቦና ኣሳቲ ኢያ ቤዓና፤ ኢያባ ሲዒቦና ኣሳቲ ኣኬካና» ጌቴቲዲ ፃፌቲስ። ");
INSERT INTO gofENT_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","ሄሳ ጋሶን፥ ታኒ ሂንቴኮ ያናው ዳንዳዓቢኬ። ");
INSERT INTO gofENT_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","ሺን ታኒ ሃዒ ሃ ሄራን ታ ኦሱዋ ኦንጊዳ ጊሾኔ ዳሮ ላይꬃፌ ዶማዳ ሂንቴና ቤዓናው ላሞቲዳ ጊሾ ");
INSERT INTO gofENT_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","ታኒ ኢስፔኔ ባሼ ሂንቴና ቤዓናው ቆፓስ። ቃሲ ጉꬃ ዎዴ ሂንቴራ ኡፋይቲዳፔ ጉዬ ኢስፔኔ ቢያ ዎዴ ሂንቴ ታ ኦጊያስ ታና ማዳና ሜላ ኮያይስ። ");
INSERT INTO gofENT_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","ሺን ሃዒ ታኒ ፆሳ ኣሳታ ማዳናው ዬሩሳላሜ ባይስ። ");
INSERT INTO gofENT_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","ማቄዶኒያኔ ኣካያን ዴዒያ ፆሳ ኣሳቲ፥ ዬሩሳላሜን ዴዒያ ማንቆታ ሚሼን ማዳናው ኮዪዳ ጊሾሳ። ");
INSERT INTO gofENT_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","ኤንቲ ማንቆታ ማዳናይሲ ኤንታው ኣቶናባ ጊዲዳ ጊሾ ባንታ ሁዔን ሄሳ ኦꬃናው ቆፋ ቃቺዶሶና። ኣይሁዴቲ ኣይሁዴ ጊዶናይሳታራ ኣያና ኣንጁዋ ሻኬቲኮ፥ ኤንቲ ቃሲ ባንታው ዴዒያባን ኣይሁዴታ ማዳናው ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","ሄሳ ጊሾ፥ ታኒ ሄ ሺቂዳ ሚሺያ ኤንታው ኢሚዳፔ ጉዬ ኢስፔኔ ባሼ ሂንቴ ማታራ ኣꬋና። ");
INSERT INTO gofENT_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","ታኒ ሂንቴኮ ቢያ ዎዴ ኪሪስቶሳ ኣንጁዋን ኩማዳ ባናይሳ ኤራይስ። ");
INSERT INTO gofENT_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","ታ ኢሻቶ፥ ታው ፆሳ ዎሲሼ ታ ባፂያን ታራ ኤቃና ሜላ ጎዳ ዬሱስ ኪሪስቶሳኒኔ ጌሻ ኣያና ሲቁዋን ሂንቴና ዎሳይስ። ");
INSERT INTO gofENT_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","ፆሳይ ታና ዪሁዳን ዴዒያ ኣማኖና ኣሳታፔ ኣሻናዳኔ ዬሩሳላሜን ታ ኦꬃና ኦሶይ ፆሳ ኣሳታ ማታን ኤኬታና ሜላ ታው ዎሲቴ። ");
INSERT INTO gofENT_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","ቃሲ ፆሲ ጊኮ፥ ታኒ ሂንቴኮ ባዳ ኡፋይሳን ሂንቴራ ሼምፓና ሜላ ታው ዎሲቴ። ");
INSERT INTO gofENT_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","ሳሮቴꬃ ፆሳይ ሂንቴ ኡባራ ጊዶ። ኣሚንዒ። ");
INSERT INTO gofENT_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","ኪንኪሪያ ካታማን ዴዒያ ዎሳ ኬꬃን ኦꬂያ ኑ ሚቺያ ፌባ ሎዖ ማጫስ ጊዴይሳ ሂንቴ ኤራና ሜላ ኮያይስ። ");
INSERT INTO gofENT_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","ሂንቴ ኢዮ ኣማኒያ ኣሳቲ ጎዳ ሱንꬃን ሞካናው ቤሲያ ኣማኒያ ኣሳታፔ ኢሱዋዳ ሞኪቴ። ኢያ ሂንቴፌ ኮያባ ኡባ ኢዮ ማዲቴ። ኢያ ባ ሁዔን ዳሮ ኣሳ ማዳሱ፤ ቃሲ ታና ታ ሁዔንካ ዳሮ ማዳሱ። ");
INSERT INTO gofENT_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","ኪሪስቶስ ዬሱሳ ኦሱዋ ታራ ኢሲፌ ኦꬂያ ጲሪስቂላኔ ኣቂላ ሳሮ ጊቴ። ");
INSERT INTO gofENT_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","ኤንቲ ታ ጊሾ ባንታ ሼምፑዋ ኣꬂ ኢሚዶሶና። ታ ፃላላ ጊዶናሺን ኣይሁዴ ጊዶና ኣሳ ዎሳ ኬꬃ ኡባይ ኤንታ ጋላቴስ። ");
INSERT INTO gofENT_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","ኤንታ ሶን ሺቂያ ኣማኒያ ኣሳ ሳሮ ጊቴ። ኢሲያ ቢታን ኪሪስቶሳ ኮይሮ ኣማኒዳ፥ ታ ዶሲያ ኤጳኔፆሳስ ታ ሳሮꬁዋ ኦዲቴ። ");
INSERT INTO gofENT_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","ሂንቴ ጊሾ ኦሶን ዳሮ ዳቡሪዳ ማይራሞ ሳሮ ጊቴ። ");
INSERT INTO gofENT_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","ታራ ቃሾ ኬꬃን ኣꬂዳ ታ ኣይሁዴ ላጌታ ኣንዲሮኒቆሳኔ ዩኒያሳ ሳሮ ጊቴ። ኤንቲ ዬሱሳ ሃዋሬታ ጊዶን ኤሬቲዳይሳታ። ቃሲ ኤንቲ ኪሪስቶሳ ታፔ ሲንꬄ ኣማኒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","ጎዳን ኣማኒያ ታ ሲቆ ላጊያ፥ ኣምጲሊያፆሳ ሳሮ ጊቴ። ");
INSERT INTO gofENT_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","ኪሪስቶሳ ኦሱዋ ኑራ ኢሲፌ ኦꬂያ ኡርባኖሴኔ ታ ዶሲያ ኢስታኩሳ ሳሮ ጊቴ። ");
INSERT INTO gofENT_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","ኪሪስቶሳን ኣማንꬂያ ኣይሊያ ኣጴሊሳስ ታ ሳሮꬁዋ ኦዲቴ። ኣርስፆቡሎሳ ሶ ኣሳስ ታ ሳሮꬁዋ ኦዲቴ። ");
INSERT INTO gofENT_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","ታ ኣይሁዴ ላጊያ ሄሮዲዮና ሳሮ ጊቴ። ናርሲሳኔ ኢያ ሶ ኣሳፔ ኪሪስቶሳ ኣማኒዳይሳታ ሳሮ ጊቴ። ");
INSERT INTO gofENT_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","ጎዳ ኦሱዋን ዳቡሪያ ቲሩፋይናኔ ቲሩፎሳ ሳሮ ጊቴ። ቃሲ ጎዳስ ዳሮ ዳቡራዳ ኦꬂያ፥ ታ ዶሲያ ጴርሲሶ ሳሮ ጊቴ። ");
INSERT INTO gofENT_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","ጎዳ ኦሱዋን ዳሮ ኤሬቲዳ ሩፎሳሲኔ ታና ባ ናዓዳ ቤዒያ ኢያ ኣዬስ ታ ሳሮꬁዋ ኦዲቴ። ");
INSERT INTO gofENT_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","ኣሲኒኪርቶሳስ፥ ፊሌጎናስ፥ ሄርሜሳስ፥ ፓቲሮባሳሲኔ ኤንታራ ዴዒያ ኣማኒያ ኢሻታ ኡባስ ታ ሳሮꬁዋ ኦዲቴ። ");
INSERT INTO gofENT_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","ፊሎሎጉሳ፥ ዩሊያ፥ ኔሪያ፥ ኢያ ሚቺው፥ ኦሉምፖሳኔ ኤንታራ ዴዒያ ኣማኒያ ኣሳ ኡባ ሳሮ ጊቴ። ");
INSERT INTO gofENT_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","ጌሻ ዬሬቴꬂ ዬሬቲሼ፥ ኢሶይ ኢሱዋ ሳሮꬂቴ። ኪሪስቶሳ ዎሳ ኬꬃ ኡባይ ሂንቴና ሳሮ ያጎሶና። ");
INSERT INTO gofENT_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","ታ ኢሻቶ፥ ሂንቴ ታማሪዳ ቲሚርቲያ ኢፂዲ፥ ሂንቴ ጊዶን ሻኬቴꬂኔ ሜቶ ሜꬊያ ኣሳታፔ ናጌቲቴ። ኤንታፌ ሃኪቴ። ");
INSERT INTO gofENT_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","ሄሳ ሜላ ኣሳቲ ባንታው ኦꬆሶናፔ ኣቲን ኑ ጎዳ ኪሪስቶሳስ ኦꬆኮና። ባንታ ማልዒያ ዶናኒኔ ሳጶꬂያ ቃላን ኣይኮ ኤሮና ኣሳ ዎዛና ባሌꬆሶና። ");
INSERT INTO gofENT_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","ዎንጌላስ ሂንቴ ኪቴቲዳይሳ ኣሳ ኡባይ ሲዒዳይሲ ታና ኡፋይሴስ። ሺን ሂንቴ ሎዖባ ኤራና ሜላኔ ኢታባፔ ሃካና ሜላ ታ ኮያይስ። ");
INSERT INTO gofENT_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","ሳሮቴꬃ ፆሳይ ፃላሂያ ሂንቴ ቶሁዋፔ ጋርሳን ጋጪ ዬጋና። ኑ ጎዳ ዬሱስ ኪሪስቶሳ ኣꬎ ኬሃቴꬃይ ሂንቴራ ጊዶ። ");
INSERT INTO gofENT_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","ታራ ኦꬂያ ፂሞቲዮሲ ሂንቴና ሳሮ ያጌስ። ሄሳዳካ፥ ታ ዳቦቲ ሉቂዮሲ፥ ያሶኒኔ ሶስጳፂሮሲ ሂንቴና ሳሮ ያጎሶና። ");
INSERT INTO gofENT_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","ሃ ዳብዳቢያ ጳዉሎሳስ ፃፊዳ ታኒ፥ ፃርፂዮሲ፥ ሂንቴና ጎዳ ሱንꬃን ሳሮ ያጋይስ። ");
INSERT INTO gofENT_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","ታና ሞኪዳይኔ ዎሳ ኬꬃ ኡባይ ኢያ ሶን ሺቂያ ጋዮሲ፥ ሂንቴና ሳሮ ያጌስ። ካታማ ሚሺያ ኦይኪያ ኤራስፆሲኔ ኑ ኢሻ ቃርፆሲ ሂንቴና ሳሮ ያጎሶና።  ");
INSERT INTO gofENT_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","ኑ ጎዳ ዬሱስ ኪሪስቶሳ ኣꬎ ኬሃቴꬃይ ሂንቴ ኡባራ ጊዶ። ኣሚንዒ። ");
INSERT INTO gofENT_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","ፆሳስ ጋላቲ ጊዶ። ታኒ፥ ዬሱስ ኪሪስቶሳባ ኦዲያ ዎንጌላ ቃላኒኔ ዳሮ ዎዴፔ ቆሴቲዲ ጋምዒዳ ቱማቴꬃን፥ ፆሳይ ሂንቴና ኣማኖን ሚንꬂዲ ኤሳናው ዳንዳዔስ። ");
INSERT INTO gofENT_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","ሺን ሃዒ ሄ ቱማይ ቆንጪስ። ካዎቴꬃ ኡባይ ኣማኒዲ ኪቴታና ሜላ ሜሪና ፆሳ ኪታን ናቤቲ ሄ ቱማባ ፃፊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","ዬሱስ ኪሪስቶሳ ባጋራ ጪንጫቴꬂ ኢያ ፃላላስ ዴዒያ፥ ኢሲ ፆሳስ ሜሪናው ቦንቾይ ጊዶ። ኣሚንዒ። ");
INSERT INTO gofENT_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","ፆሳ ሼኒያን ዬሱስ ኪሪስቶሳ ሃዋሬ ጊዳናው ፄጌቲዳ ጳዉሎሲኔ፥ ኑ ኢሻ ሶስቴኒሲ፥ ");
INSERT INTO gofENT_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","ቆሮንቶሳን ዴዒያ ፆሳ ዎሳ ኬꬃስ፥ ዬሱስ ኪሪስቶሳን ጌዪዳይሳታሲኔ ጌሺ ጊዳና ሜላ ፄጌቲዳይሳታስ፤ ቃሲ ኤንታሲኔ ኑስ ጎዳ ጊዲያ ኑ ጎዳ ዬሱስ ኪሪስቶሳ ሱንꬃ ኡባ ቤሳን ፄጊያ ኡባስ፤ ");
INSERT INTO gofENT_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","ፆሳይ፥ ኑ ኣዋይኔ ጎዳይ ዬሱስ ኪሪስቶሲ ሂንቴው ኣꬎ ኬሃቴꬃኔ ሳሮቴꬃ ኢሞ። ");
INSERT INTO gofENT_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","ፆሳይ ኪሪስቶስ ዬሱሳ ባጋራ ሂንቴው ኢሚዳ ኣꬎ ኬሃቴꬃ ጊሾ ታኒ ኡባ ዎዴ ፆሳ ጋላታይስ። ");
INSERT INTO gofENT_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","ኢያን ኦዳኒኔ ኤራቴꬃ ኡባን ሂንቴ ዱሬቲዴታ። ");
INSERT INTO gofENT_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","ታኒ ኪሪስቶሳባ ማርካቲዳይሲ ቱማ ጊዴይሳ ሄሲ ቆንጪሴስ። ");
INSERT INTO gofENT_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","ሄሳ ጊሾ፥ ሂንቴ ኑ ጎዳ ዬሱስ ኪሪስቶሳ ዩሳ ናጊሼ ዴዒሺን፥ ኣይ ኣያና ኢሞይካ ሂንቴው ፓጬና። ");
INSERT INTO gofENT_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","ኑ ጎዳ ዬሱስ ኪሪስቶሲ ሲሚያ ዎዴ ሂንቴ ቦሬቶናይሳታ ጊዳና ሜላ ኢ ዉርሴꬂ ጋካናው ሂንቴና ሚንꬃና። ");
INSERT INTO gofENT_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","ባ ናዓ፥ ኑ ጎዳ ዬሱስ ኪሪስቶሳራ ኢሲፌቴꬃይ ዳና ሜላ ሂንቴና ፄጊዳ ፆሳይ ኣማኔቲዳይሳ። ");
INSERT INTO gofENT_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","ታ ኢሻቶ፥ ሂንቴ ጊዶን ሻኬቴꬂ ዶናዳ ሂንቴ ኢሲ ዎዛናኒኔ ኢሲ ቆፋን ኢሶ ጊዲዲ፥ ዳና ሜላ ኑ ጎዳ ዬሱስ ኪሪስቶሳ ሱንꬃን ታ ሂንቴና ዎሳይስ። ");
INSERT INTO gofENT_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","ታ ኢሻቶ፥ ቄሎዔ ሶ ኣሳይ ሂንቴ ጊዶን ኦሺ ዴዔይሳ ታው ኦዲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","ሂንቴፌ ኢሶቲ ኢሶቲ፥ «ታኒ ጳዉሎሳሳ፤ ታኒ ኣጲሎሳሳ፤ ታኒ ጴፂሮሳሳ፤ ታኒ ኪሪስቶሳሳ» ያጌታ። ");
INSERT INTO gofENT_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","ኪሪስቶሲ ሻኬቲዴዬ? ሂንቴ ጊሾ ማስቃሊያ ቦላ ካቄቲዳይ ጳዉሎሴዬ? ዎይኮ ሂንቴ ጳዉሎሳ ሱንꬃን ፃማቄቲዴቲዬ? ");
INSERT INTO gofENT_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","ታኒ ቃሪስጶሲኔ ጋዮሲ ኣቲን ሂንቴፌ ኦናካ ፃማቃቦና ጊሾ ፆሳ ጋላታይስ። ");
INSERT INTO gofENT_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","ሄሳ ጊሾ፥ ኦኒካ ሂንቴና ታ ሱንꬃን ፃማቄቲዴታ ጋናው ዳንዳዔና።  ");
INSERT INTO gofENT_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","ቃሲ ኢስፂፋኖሴ ሶ ኣሳካ ታ ፃማቂዳይሳ ኣኬካይስ፥ ሺን ሃራ ኦና ፃማቂዳኮ ሃሳዪኬ። ");
INSERT INTO gofENT_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","ኪሪስቶሲ ታና ኪቲዳይ ዎንጌላ ኦዳና ሜላሳፌ ኣቲን ፃማቃና ሜላ ጊዴና። ኪሪስቶሲ ማስቃሊያ ቦላ ሃይቂዳይሲ ሃዳ ጊዶና ሜላ ታኒ ኣሳ ጪንጫቴꬃ ቃላን ኦዲኬ። ");
INSERT INTO gofENT_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","ኪሪስቶሲ ማስቃሊያ ቦላ ሃይቂዳይሳ ኦዲያ ቃላይ ꬋዬይሳታስ ኤያቴꬂ፥ ሺን ኑስ ኣቴይሳታስ ፆሳ ዎልቃ። ");
INSERT INTO gofENT_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","ጌሻ ማፃፋን፥ «ታኒ ጪንጫታ ጪንጫቴꬃ ꬋይሳና፤ ኣኬካንቾታ ኣኬካ ባሌꬃና» ያጌስ። ");
INSERT INTO gofENT_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","ያቲን፥ ጪንጪ ኣዉን ዴዒ? ሂጌ ኣስታማሬይ ኣዉን ዴዒ? ዎይኮ ሃ ሳዓ ኤራንቾይ ኣዉን ዴዒ? ፆሳይ ሃ ሳዓ ጪንጫቴꬃ ኤያቴꬂ ኦꬂቤኔ? ");
INSERT INTO gofENT_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","ሃ ሳዓ ኣሳይ ባንታ ጪንጫቴꬃን ፆሳ ኤሮና ሜላ ባ ጪንጫቴꬃን ዲጊዲ፥ ኤያቴꬃን ታይቤቲያ፥ ኑኒ ኦዲያ ቃላን ኣማኔይሳታ ኣሻናው ፆሳ ሼኔ ጊዲስ። ");
INSERT INTO gofENT_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","ኣይሁዴቲ ማላታ ቤዓናው ኮዮሶና፤ ቃሲ ጊሪኬቲ ጪንጫቴꬂ ኮዮሶና። ");
INSERT INTO gofENT_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","ሺን ኑኒ ማስቃሊያ ቦላ ካቄቲዳ ኪሪስቶሳ ሳባኮስ። ሄሲ ኣይሁዳታስ ꬉቤ፤ ቃሲ ጊሪኬታስ ኤያቴꬂ። ");
INSERT INTO gofENT_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","ሺን ፆሳይ ፄጊዳይሳታስ፥ ኣይሁዴ ጊዲን፥ ጊሪኬ ጊዲን ኪሪስቶሲ ፆሳ ዎልቃኔ ኢያ ጪንጫቴꬃ። ");
INSERT INTO gofENT_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","ፆሳ ኤያቴꬃይ ኣሳ ጪንጫቴꬃፌ ኣꬌስ፤ ቃሲ ፆሳ ዳቡራይ ኣሳ ሚኖቴꬃፌ ሚኔስ። ");
INSERT INTO gofENT_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","ሂዛ፥ ታ ኢሻቶ፥ ፆሳይ ሂንቴና ፄጊያ ዎዴ ሂንቴ ኣይ ሜላ ኣሴኮ ቆፒቴ። ኣሳ ቆፋን ሂንቴ ጊዶን ጪንጫቲ፥ ዎልቃማቲኔ ꬎቃ ዛሬቲ ዶኮና። ");
INSERT INTO gofENT_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","ሺን ፆሳይ ጪንጫታ ዬላያናው ኣላሜን ዴዒያ ኤያታ ዶሪስ፤ ቃሲ ሚኖታ ዬላያናው ኣላሜን ዴዒያ ዳቡራንቾታ ዶሪስ። ");
INSERT INTO gofENT_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","ፆሳይ ሃ ኣላሚያን ጊታ ጌቴቲዳባ ꬋይሳናው፥ ሃ ሳዓ ካዉሻባ፥ ካꬌቲዳባኔ ፓꬆናባ ዶሪስ። ");
INSERT INTO gofENT_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","ኦኒካ ፆሳ ሲንꬃን ጬቄቶና ሜላ ሄሳ ኦꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","ሺን ፆሳይ ሂንቴው ኪሪስቶስ ዬሱሳራ ኢሲፌቴꬂ ዳና ሜላ ኦꬂስ። ኢ ኑስ ፆሳፌ ጪንጫቴꬂ፥ ፂሎቴꬂ፥ ጌሻቴꬂኔ ኣቶቴꬂ ጊዲስ። ");
INSERT INTO gofENT_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","ሄሳ ጊሾ፥ ጌሻ ማፃፋን፥ «ጬቄቲያ ኦኒካ ጎዳን ጬቆ» ያጌስ። ");
INSERT INTO gofENT_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","ታ ኢሻቶ፥ ታኒ ኮይሮ ፆሳ ቃላ ሂንቴው ኦዳሼ ዪዳ ዎዴ ዶና ቢላቴꬃኒኔ ጪንጫቴꬃን ያቢኬ። ");
INSERT INTO gofENT_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","ታኒ ሂንቴራ ዴዒያ ዎዴ ማስቃሊያ ቦላ ካቄቲዳ ዬሱስ ኪሪስቶሳፔ ኣቲን ሃራባ ኤራናው ኮዪኬ ጋዳ ታ ቆፋ ቃቻስ። ");
INSERT INTO gofENT_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","ታ ሂንቴራ ዴዒያ ዎዴ ዳቡራን፥ ያሻኒኔ ዳሮ ኮኮርሳን ዴዓስ። ");
INSERT INTO gofENT_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","ታ ኪታይኔ ታ ቲሚርቴይ ዶና ቢላቴꬃኒኔ ጪንጫቴꬃን ጊዶናሺን ጌሻ ኣያና ዎልቃ ቆንጪሴꬃና። ");
INSERT INTO gofENT_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","ሄሲካ፥ ሂንቴ ኣማኖይ ፆሳ ዎልቃናፔ ኣቲን ኣሳ ጪንጫቴꬃን ዜምፖና ሜላሳ። ");
INSERT INTO gofENT_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","ኣያና ዴዖን ዲጪዳይሳታስ ኑኒ ጪንጫቴꬃ ቃላን ኦዶስ። ሺን ሄ ጪንጫቴꬃይ፥ ሃ ሳዓ ጪንጫቴꬃ ዎይኮ ꬋያናው ዴዒያ ሃ ሳዓ ሃሬይሳታ ጪንጫቴꬃ ጊዴና። ");
INSERT INTO gofENT_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","ሺን ኑኒ ኦዲያ ጪንጬቴꬃይ፥ ዳሮ ዎዴፔ ሲንꬄ ፆሳይ ኑ ቦንቹዋስ ጊጊሲዳይሳኔ ጌሚዲ ዴዒያ ፁራ ጪንጫቴꬃ። ");
INSERT INTO gofENT_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","ሃ ሳዓ ሃሬይሳታፔ ኦኒካ ሃ ጪንጫቴꬃ ኤሪቤና። ኤንቲ ኤሪዳባ ጊዲያኮ፥ ቦንቾ ጎዳ ማስቃሊያ ቦላ ካቆኮና። ");
INSERT INTO gofENT_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","ሺን ጌሻ ማፃፋን፥ «ኣይፌይ ቤዒቦናባ፥ ሃይꬂ ሲዒቦናባ፥ ዎዛኒ ቆፒቦናባ፥ ፆሳይ ባና ሲቄይሳታስ ጊጊሲስ» ያጌስ። ");
INSERT INTO gofENT_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","ፆሳይ ባ ፁራ ባ ኣያና ባጋራ ኑስ ቆንጪሲስ። ጌሻ ኣያናይ ሃሪ ኣቶሺን ጌሚዳ ፆሳ ፁራ ኡባ ፒልጌስ። ");
INSERT INTO gofENT_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","ኣሳን ዴዒያ ኣሳ ኣያናፔ ኣቲን ኣሳባ ኦኒካ ኤሬና። ሄሳዳካ፥ ፆሳባ ፆሳ ኣያናፔ ኣቲን ኦኒካ ኤሬና። ");
INSERT INTO gofENT_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","ፆሳይ ኑስ ጮ ኢሚዳባ ኑ ኤራና ሜላ ፆሳ ኣያና ኤኪዳፔ ኣቲን ሃ ሳዓ ኣያና ኤኪቦኮ። ");
INSERT INTO gofENT_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","ኑኒ ኣያናባ፥ ኣያና ኣሳታስ ኣሳ ጪንጫቴꬃን ጊዶናሺን ፆሳ ኣያናይ ኢሚያ ጪንጫቴꬃን ታማርሶስ። ");
INSERT INTO gofENT_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","ሺን ጌሻ ኣያናይ ባይና ኣሲ ፆሳ ኣያና ኢሞታታ ኤኬና። ሄሲ ኢያው ኤያቴꬂ፤ ኡባይ ጌሻ ኣያናን ፒልጌቲያ ጊሾ ኢ ኤራናው ዳንዳዔና። ");
INSERT INTO gofENT_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","ሺን ጌሻ ኣያኒ ዴዒያ ኣሲ ኡባባ ፒልጌስ፥ ሺን ኢያ ኦኒካ ፒልጌና። ");
INSERT INTO gofENT_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","ጌሻ ማፃፋን፥ «ጎዳ ዎዛና ኤሬይ ኦኔ? ኢያ ዞራናው ዳንዳዔይ ኦኔ?» ጌቴቲዲ ፃፌቲዳይሳ ሜላ። ሺን ኑስ ኪሪስቶሳ ዎዛኒ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","ታ ኢሻቶ፥ ሂንቴ ኪሪስቶሳን ቡሮ ዮጋኔ ኣማኖና ኣሳꬆ ዴዒያ ጊሾ ታኒ ኣያናባ ሂንቴው ኦዳናው ዳንዳዓቢኬ። ");
INSERT INTO gofENT_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","ሂንቴ ሚኖ ካꬂ ማናው ዳንዳዒቦና ጊሾ ታኒ ሂንቴና ማꬂ ፓሃስ፤ ሃዒካ ዳንዳዒቤኬታ። ");
INSERT INTO gofENT_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","ሃዒካ ሂንቴ ኣማኖና ኣሳዳ ዴዔታ። ሂንቴ ጊዶን ዴዒያ ቃናቴይኔ ፓላማይ ሂንቴ ኣማኖና ኣሳዳ ዴዔይሳ ኤሪሴኔ? ሂንቴ ኣማኖና ኣሳዳ ሃኔታ። ");
INSERT INTO gofENT_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","ሂንቴፌ ኢሶይ፥ «ታኒ ጳዉሎሳሳ» ሃራይ ቃሲ፥ «ታኒ ኣጲሎሳሳ» ጊኮ፥ ኣማኖና ኣሳ ሜላ ጊዴኬቲ? ");
INSERT INTO gofENT_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","ያቲን፥ ኣጲሎሲ ኦኔ? ጳዉሎሲ ኦኔ? ኑኒ ሂንቴና ኣማንꬂዳ ፆሳ ኦሳንቾታ። ፆሳይ ኢሱዋስ ኢሱዋስ ኢሚዳ ኦሱዋ ሜላ ኦꬂያ ኦሳንቾታ ጊዶኮናዬ? ");
INSERT INTO gofENT_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","ታ ቶካስ፤ ኣጲሎሲ ሃꬄ ኡሺስ፥ ሺን ዲቼይ ፆሳ። ");
INSERT INTO gofENT_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","ሄሳ ጊሾ፥ ዲቺዳ ፆሳፌ ኣቲን ቶኬይካ ሃꬄ ኡሼይካ ኣይኮካ ጊዴና። ");
INSERT INTO gofENT_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","ቶኬይኔ ሃꬄ ኡሼይ ዎሊ ሜላ፥ ሺን ኢሶይ ኢሶይ ባ ኦሱዋ ሜላ ፆሳይ ኢሚያ ዎይቱዋ ኤካና። ");
INSERT INTO gofENT_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","ኑኒ ኢሲፌ ፆሳስ ኦꬂያ ኢያ ኦሳንቾታ ጊዲያ ጊሾ ሂንቴ ፆሳ ሾቃ፤ ፆሳ ኬꬂ። ");
INSERT INTO gofENT_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","ፆሳይ ታው ኢሚዳ ኣꬎ ኬሃቴꬃ ሜላ ሂላንቾ ኣናፄዳ ባሱዋ ዬጋስ። ሃራ ኡራይ ኢያ ቦላ ኬፄስ። ሺን ኢያ ቦላ ኬፂያ ኦኒካ ዋቲዲ ኬፂያኮ፥ ባው ናጌቶ። ");
INSERT INTO gofENT_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","ኢሲ ቶሆ ዬጌቲዳ ባሱዋፔ ሃራ ባሶ ዬጋናው ኦኒካ ዳንዳዔና። ሄ ባሶይካ ዬሱስ ኪሪስቶሳ። ");
INSERT INTO gofENT_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","ሺን ሃ ባሱዋ ቦላ ኦኒካ ዎርቃን ዎይኮ ቢራን ጊዲን፥ ኣልዖ ሹቻን ዎይኮ ሚꬃን ጊዲን፥ ማታን ዎይኮ ማቃን ኬፂኮ፥ ");
INSERT INTO gofENT_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","ኢሲ ኢሲ ኣሲ ሄ ባሱዋ ቦላ ኣይቢን ኬፂዳኮ ፒርዳ ጋላስ ታማን ፓጬቲዲ ቆንጫና። ");
INSERT INTO gofENT_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","ኦኒካ ሄ ባሱዋ ቦላ ኬፂዳ ኬꬃይ ታማን ፁጌቶና ኣቲኮ፥ ባ ዎይቱዋ ኤካና። ");
INSERT INTO gofENT_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","ሺን ኦዴ ኦሶይካ ታማን ፁጌቲኮ፥ ሄ ኡራስ ዎይቶይ ባዋ። ጊዶሺን፥ ኢ ባ ሁዔን ታማፔ ኬሲ ኤኪዳ ኣሳዳ ኣታና። ");
INSERT INTO gofENT_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","ሂንቴ ፆሳ ኬꬂ ጊዴይሳኔ ፆሳ ኣያናይ ሂንቴናን ዴዔይሳ ኤሬኬቲ? ");
INSERT INTO gofENT_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","ኦኒካ ፆሳ ኬꬂ ላሊኮ፥ ፆሳይካ ኢያ ላላና። ፆሳ ኬꬃይ ጌሺ፤ ሄ ኬꬃይካ ሂንቴና። ");
INSERT INTO gofENT_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","ኦኒካ ባና ጪሞፎ። ሃ ሳዓ ጪንጫቴꬃን ባና ጪንጫ ኦꬂዲ ኤኪያ ኦኒካ ፆሳ ሲንꬃን ጪንጫ ጊዳናው ኤያ ጊዶ። ");
INSERT INTO gofENT_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","ሃ ሳዓ ጪንጫቴꬃይ ፆሳ ሲንꬃን ኤያቴꬂ። ጌሻ ማፃፋን፥ «ፆሳይ ጪንጫታ ኤንታ ጌኔ ቆፋን ኦይኬስ» ያጌስ። ");
INSERT INTO gofENT_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","ቃሲ፥ «ጪንጫታ ቆፋይ ማዶናባ ጊዴይሳ ጎዳይ ኤሬስ» ያጌስ። ");
INSERT INTO gofENT_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","ሄሳ ጊሾ፥ ኡባይ ሂንቴሳ ጊዲያ ጊሾ ኦኒካ ኣሳን ጬቄቶፎ። ");
INSERT INTO gofENT_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","ጳዉሎሲ፥ ኣጲሎሲኔ ጴፂሮሲ፥ ሃ ኣላሜይ፥ ዴዖይ፥ ሃይቆይ፥ ሃዒ ዴዔይ፥ ሲንꬃፌ ያናይሲ፥ ኡባይ ሂንቴሳ። ");
INSERT INTO gofENT_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","ሂንቴ ኪሪስቶሳሳ፤ ኪሪስቶሲ ፆሳሳ። ");
INSERT INTO gofENT_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","ኣሳይ ኑና ኪሪስቶሳ ኣይሌዳኔ ፆሳ ፁራ ቆንጪሳናው ሃዳሪ ኢሜቲዳ ኣሳዳ ኦꬂዲ ቆፖ። ");
INSERT INTO gofENT_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","ሄ ሃዳራ ኤኪዳ ኣሳቲ ባንታ ጎዳስ ኣማኔቲዳይሳታ ጊዳናው ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","ሺን ሂንቴ ዎይኮ ሃራይ ታና ፒርዲኮ፥ ታው ኣይኮካ ጊዴና። ሃራይ ኣቶ፥ ታካ ታ ቦላ ፒርዲኬ። ");
INSERT INTO gofENT_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","ታ ካሃይ ጌሺ፥ ሺን ሄሲ ታ ፖሎ ፂሎ ጊዴይሳ ቤሴና። ታ ቦላ ፒርዳናይ ጎዳ ፃላላ። ");
INSERT INTO gofENT_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","ሄሳ ጊሾ፥ ዎዴይ ጋኮና፥ ጎዳይ ዮና ኦዴ ቦላካ ፒርዶፊቴ። ኢ ꬉማን ጌሚዳባ ፖዖ ኬሴና፤ ኣሳ ዎዛናን ቆሴቲዳ ቆፋ ቆንጪሳና። ሄ ዎዴ ኢሶይ ኢሶይ ፆሳፌ ጋላታ ኤካና። ");
INSERT INTO gofENT_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","ታ ኢሻቶ፥ ሂንቴ ጊሾ ኣጲሎሳኔ ታና ሌሚሶ ኦꬃዳ ሂንቴው ኦዳስ። ሄሳ ታ ኦꬂዳይ፥ «ፃፌቲዳይሳፌ ኣꬎፋ» ያጊያ ዞሪያ ሂንቴ ኑፔ ታማራና ሜላሳ። ሄሳ ጊሾ፥ ኦኒካ ኢሱዋ ሳቢዲ ሃንኩዋ ካꬋናው ቤሴና። ");
INSERT INTO gofENT_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","ኔ ሃራታፔ ኣይቢን ኣꬋይ? ኔኒ ኤካቦናባይ ኣይቢ ዴዒ? ያቲን፥ ኔኒ ኤኪዳባ ሃራ ኣሳፔ ኤኪዳ ጊዲኮ፥ ኤኪቦና ኣሳዳ ኣይስ ጬቄታይ? ");
INSERT INTO gofENT_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","ሃዒ ሂንቴ ካሊዴታ። ሃዒ ሂንቴ ዱሬቲዴታ። ኑኒ ባይና ሂንቴ ፃላላ ካዎቲዴታ። ሂንቴ ቱማ ካዎቲዳባ ጊዲያኮ፥ ኑካ ሂንቴራ ካዎታናሺን። ");
INSERT INTO gofENT_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","ፆሳይ ኑና ሃዋሬታ፥ ሃይቆ ፒርዴቲዳ ኣሳዳ ኣሳ ኡባፌ ኑና ጉዬ ኣꬂዳ ታው ዳኔስ። ኑኒ ሃ ኣላሚያስ፥ ኪታንቾታሲኔ ኣሳስ ካሳባ ጊዲዳ። ");
INSERT INTO gofENT_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","ኑኒ ኪሪስቶሳ ጊሾ ኤያ ጊዲዳ፥ ሺን ሂንቴ ኪሪስቶሳን ጪንጫታ ጊዲዴታ። ኑኒ ዳቡራንቾ፥ ሺን ሂንቴ ሚኖ ጊዲዴታ። ሂንቴ ቦንቼቲዴታ፥ ሺን ኑኒ ቶሼቲዳ። ");
INSERT INTO gofENT_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","ሃዒ ጋካናው ኑ ኮሻቶስ፥ ሳሞቶስ፥ ካሎቶስ፥ ዋꬌቶስ፤ ዳና ሶ ꬋዪዲ ቶይላቶስ። ");
INSERT INTO gofENT_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","ኑኒ ኑ ኩሼን ኦꬂ ኣቆስ። ኑና ኣሲ ባዲያ ዎዴ ኣንጆስ፤ ኑና ጎዲያ ዎዴ ዳንዳዖስ። ");
INSERT INTO gofENT_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","ኑ ቦላ ኢታባ ኦዴቲያ ዎዴ ሎዖ ቃላ ዛሮስ። ኑ ሃዒ ጋካናው ሃ ኣላሚያ ፒቶኔ ዎራ ዬጌቲያ ቡሬ ጊዲዳ። ");
INSERT INTO gofENT_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","ታኒ ሄሳ ፃፊዳይ፥ ታ ሲቂያ ናይታዳ፥ ሂንቴና ዞራናው ፃፋሲፔ ኣቲን ዬላያናው ጊዴና። ");
INSERT INTO gofENT_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","ኪሪስቶሳን ሂንቴና ዲቺያ ታይቦፔ ቦላ ጊዲዳ ካሌꬄይሳቲ ዴዒኮካ፥ ሂንቴው ኢሲ ኣዉ ዴዔስ። ታ ሂንቴና ኪሪስቶስ ዬሱሳ ዎንጌላን ዬላስ። ");
INSERT INTO gofENT_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","ሂዛ፥ ሂንቴ ታና ሌሚሶ ኦꬂዲ ካላና ሜላ ሂንቴና ዎሳይስ። ");
INSERT INTO gofENT_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","ሄሳ ጊሾ፥ ኣማኔቲዳ፥ ታ ሲቂያ፥ ጎዳን ታ ናዓ፥ ፂሞቲዮሳ ሂንቴኮ ኪታስ። ኢ ዱማ ዱማ ቤሳን ዴዒያ ዎሳ ኬꬃን ታ ታማርሲዳ፥ ኪሪስቶሳ ዬሱሳን ዴዒያ ታ ኦጊያ ሂንቴና ሃሳዪሳና። ");
INSERT INTO gofENT_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","ታኒ ሂንቴኮ ዮናባ ዳኒን፥ ኦቶሪያ ኢሲ ኢሲ ኣሳቲ ዴዖሶና። ");
INSERT INTO gofENT_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","ሺን ጎዳይ ጊኮ፥ ማታ ዎዴ ታኒ ሂንቴኮ ባና። ሄ ዎዴ ኦቶራንቾታ ኦዳ ፃላላ ጊዶናሺን ኤንታ ዎልቃካ ኤራና። ");
INSERT INTO gofENT_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","ፆሳ ካዎቴꬃይ ኦዳ ጊዶናሺን ዎልቃ። ");
INSERT INTO gofENT_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","ታኒ ሂንቴኮ ፃምዓራ ቦዬ ዎይኮ ሲቆራኔ ኣሽኬ ኣያናራ ቦ? ኣዉሳ ዶሬቲ? ");
INSERT INTO gofENT_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","ሂንቴ ጊዶን ላይማቴꬂ ዴዔይሲ ዚጊሬቴስ። ሄሳ ሜላ ላይማቴꬂ ሃሪ ኣቶሺን፥ ኣማኖና ኣሳይካ ኦꬆኮና። ሂንቴ ጊዶን ባ ኣዋ ማቼራ ቱኒዳ ኣሲ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","ሄሳን ሂንቴ ቂሮታናዉኔ ዬላታናው ቤሴኔ፥ ሺን ኦቶርቲዴታ። ሄሳ ሜላ ቦርሶባ ኦꬂዳ ኡራ ሂንቴ ጊዶፌ ኬሳናው ቤሴኔ? ");
INSERT INTO gofENT_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","ታኒ ኣሾን ሂንቴራ ዶና ኢፂኮካ ኣያናን ታ ሂንቴራ ዴዓይስ። ታኒ ሂንቴራ ዴዒያ ኣሳዳ ሃናዳ ሄሳ ሜላ ኦሱዋ ኦꬂዳ ኡራ ቦላ ፒርዳስ። ");
INSERT INTO gofENT_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","ኑ ጎዳ ዬሱስ ኪሪስቶሳ ሱንꬃን ሂንቴ ሺቂያ ዎዴ ታኒ ኣያናን ሂንቴራ ዳና። ሄሳን ጎዳ ዬሱስ ኪሪስቶሳ ዎልቃይ ሂንቴራ ጊዳና። ");
INSERT INTO gofENT_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","ሄ ኡራ ናጋራ ኣሾይ ꬋዪዲ፥ ኢያ ኣያናይ ጎዳ ዬሱሳ ፒርዳ ጋላሳን ኣታና ሜላ ኢ ፃላሄስ ኣꬊ ኢሜቶ። ");
INSERT INTO gofENT_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","ሂንቴ ጬቆይ ሎዖ ጊዴና። ጉꬃ ኢርሾይ ሙኑቃ ኡባ ዴንꬄይሳ ኤሬኬቲዬ? ");
INSERT INTO gofENT_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","ሂንቴ ሃዒ ኢርሾይ ባይና ሙኑቃ ጊዳና ሜላ፥ ናጋራ ኢርሹዋ ሂንቴፌ ኬሲቴ። ኑስ ፓሲካ ዶርሳ ጊዲዳ ኪሪስቶሲ ያርሼቲስ። ");
INSERT INTO gofENT_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","ሄሳ ጊሾ፥ ጌኔይኔ ኢታቴꬂ ዴዒያ ኢርሹዋራ ጊዶናሺን ቱማቴꬂኔ ጌሻቴꬂ ዴዒያ ኡይꬃራ ኑ ባሊያ ቦንቾስ። ");
INSERT INTO gofENT_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","ታ ካሴ ፃፊዳ ዳብዳቢያን ሂንቴ ላይማቲያ ኣሳራ ጋሄቶና ሜላ ሂንቴው ኦዳስ። ");
INSERT INTO gofENT_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","ሄሳ ጉሳይ ሃ ኣላሚያን ዴዒያ ላይማቴይሳታራ ዎይኮ ኡዜታራ ዎይኮ ካይሶታራ ዎይኮ ኤቃ ጎይኔይሳታራ ፖሎ ጋሄቶፊቴ ጉሱ ጊዴና። ሄሳ ጊዲኮ፥ ሃ ኣላሚያፔ ሂንቴ ኬያናው ቤሴስ ሺን ኣቲስ። ");
INSERT INTO gofENT_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","ሺን ኣማናይስ ያጊሼ ላይማቴይሳታራ ዎይኮ ኡዜታራ ዎይኮ ኤቃ ጎይኔይሳታራ ዎይኮ ጫዬይሳታራ ዎይኮ ማꬆቴይሳታራ ዎይኮ ካይሶታራ ጋሄቶፊቴ ጋዳ ሂንቴው ኦዳይስ። ሄሳ ሜላ ኣሳራ ሃሪ ኣቶሺን፥ ካꬂካ ሞፒቴ። ");
INSERT INTO gofENT_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","ዎሳ ኬꬃፌ ካሬራ ዴዔይሳታ ቦላ ፒርዳናው ታና ኣይቤ ጋꬄይ? ዎሳ ኬꬃን ዴዔይሳታ ቦላ ሂንቴ ፒርዴኬቲዬ? ");
INSERT INTO gofENT_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","ሺን ካሬራ ዴዔይሳታ ቦላ ፆሳይ ፒርዳና። ሄ ኢታባ ኦꬂያ ኡራ ሂንቴ ጊዶፌ ኬሲቴ። ");
INSERT INTO gofENT_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","ሂንቴ ጊዶፌ ኢሶይ ኢሱዋራ ሞቶይ ዴዒኮ፥ ሄሳ ኣማኒያ ኣሳ ሲንꬃን ፒርዴታናይሳ ኣጊዲ ኣማኖና ኣሳ ሲንꬃን ፒርዴታናው ዋኒዲ ቢ? ");
INSERT INTO gofENT_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","ጌሻቲ ኣላሚያ ቦላ ፒርዳናይሳ ሂንቴ ኤሬኬቲ? ያቲን፥ ሂንቴ ኣላሚያ ቦላ ፒርዲያባ ጊዲኮ፥ ሃይሳ ሜላ ጉꬃባ ፒርዳናው ዋኒዲ ዳንዳዔኬቲ? ");
INSERT INTO gofENT_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","ኑኒ ኪታንቾታ ቦላ ፒርዳናይሳ ኤሬኬቲ? ያቲን፥ ሃ ሳዓ ዱሳባ ቦላ ፒርዳናይሲ ሂንቴና ዋኒዲ ፆኒ? ");
INSERT INTO gofENT_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","ያቲን፥ ሄሳ ሜላ ሜቶይ ሂንቴ ጊዶን ሜꬌቲኮ፥ ዎሳ ኬꬃ ኣይፌን ካꬌቲዳ ኣሳ ሲንꬃን ፒርዴታናው ዋቲ ኤፌቲ? ");
INSERT INTO gofENT_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","ታኒ ሂንቴና ዬላያናው ሄሳ ጋይስ። ሂንቴ ጊዶን ካጬቲዳ ኣሳታ ሲጌꬃናው ዳንዳዒያ ኣኬካ ኣሲ ባዌ? ");
INSERT INTO gofENT_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","ያቲን፥ ኢሲ ኣማኔይሲ ሃንኮ ኣማኔይሳ ፒርዳ ኬꬃን ኣማኖና ኣሳ ሲንꬃን ሞታናው ቤሲ? ");
INSERT INTO gofENT_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","ሂዛ፥ ሂንቴ ኢሶይ ኢሱዋ ሞቲያባ ጊዲኮ ሄሲ ሂንቴ ኩንዴꬃ ቤሴስ። ሄሳፌ ሂንቴ ቆሄቲኮኔ ጪሜቲኮ ኬሄኔ? ");
INSERT INTO gofENT_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","ሺን ሂንቴ ዎሊ ጊዶን ኣማኔይሳቲ ኢሶይ ኢሱዋ ቆሄታኔ ጪሜታ። ");
INSERT INTO gofENT_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","ጌላቲ ፆሳ ካዎቴꬃ ላቶናይሳ ሂንቴ ኤሬኬቲ? ሂንቴና ጪሞፊቴ፤ ላይማቴይሳቲ ዎይኮ ኤቃ ጎይኔይሳቲ ዎይኮ ቃይፄይሳቲ ዎይኮ ኣዴራ ኣዴራ ጋሄቴይሳቲ፥ ");
INSERT INTO gofENT_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","ዎይኮ ካይሶቲ ዎይኮ ኡዜቲ ዎይኮ ማꬆቴይሳቲ ዎይኮ ጫዬይሳቲ ዎይኮ ቦንቄይሳቲ ፆሳ ካዎቴꬃ ላቶኮና። ");
INSERT INTO gofENT_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","ሂንቴፌ ኢሲ ኢሲ ኣሳቲ ካሴ ሄሳ ሜላ። ሺን ሂንቴ ሃዒ ጎዳ ዬሱስ ኪሪስቶሳ ሱንꬃኒኔ ፆሳ ኣያናን ሜጬቲዴታ፤ ጌዪዴታ፤ ፂሊዴታ። ");
INSERT INTO gofENT_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","ሂንቴ፥ «ኑ ኮዪዳባ ኦꬃናው ዳንዳዖስ» ያጌታ። ሺን ኡባይ ሂንቴና ማዴና። ታኒ ኮዪዳባ ኡባ ኦꬃናው ዳንዳዓይስ፥ ሺን ኣይቢካ ታና ሃሬና። ");
INSERT INTO gofENT_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","ሂንቴ፥ «ካꬂ ኡሎሳ፤ ኡሎይካ ካꬃሳ» ያጌታ። ሺን ፆሳይ ኡሉዋካ ካꬃካ ꬋይሳናይሳ ታ ሂንቴው ኦዳይስ። ኑ ኣሳቴꬃይ ጎዳሳፌ ኣቲን ላይማቴꬃሳ ጊዴና። ጎዳይካ ኑ ኣሳቴꬃሳ። ");
INSERT INTO gofENT_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","ፆሳይ ጎዳ ሃይቆፔ ዴንꬂዳይሳዳ፥ ኑናካ ሃይቆፔ ባ ዎልቃን ዴንꬃና። ");
INSERT INTO gofENT_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","ሂንቴ ኣሳቴꬃይ ኪሪስቶሳ ኣሳቴꬃፌ ባጋ ጊዴይሳ ኤሬኬቲ? ያቲን፥ ታኒ ኪሪስቶሳ ኣሳቴꬃፌ ባጋ ኤፋዳ ላይማቴꬃ ኣሳቴꬂ ጊዳና ሜላ ኦꬆ? ሃኔና! ");
INSERT INTO gofENT_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","ላይማቲያ ኡራይ ኢ ጋሄቲያ ኣሴራ ኢሲ ኣሳቴꬂ ጊዴይሳ ኤሬኬቲ? ጌሻ ማፃፋን፥ «ኤንቲ ናምዓይ ኢሲ ኣሳቴꬂ ጊዳና» ጌቴቲዲ ፃፌቲስ። ");
INSERT INTO gofENT_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","ሺን ጎዳራ ኢሲፊያ ኡራይ ኢያራ ኣያናን ኢሶ ጊዴስ። ");
INSERT INTO gofENT_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","ላይማቴꬃፌ ሃኪቴ። ኢሲ ኡራይ ኦꬂያ ሃራ ናጋራይ ኢያ ኣሳቴꬃፌ ካሬራ ኦሴቴስ፥ ሺን ላይማቲያ ኣሲ ባ ኣሳቴꬃ ቦላ ናጋራ ኦꬄስ። ");
INSERT INTO gofENT_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","ሂንቴ ኣሳቴꬃይ ፆሳይ ሂንቴው ኢሚዳ ሂንቴናን ዴዒያ ጌሻ ኣያና ኬꬂ ጊዴይሳ ኤሬኬቲ? ሂንቴ ሂንቴባ ጊዴኬታ። ");
INSERT INTO gofENT_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","ፆሳይ ሂንቴና ጋቴን ሻሚስ። ሄሳ ጊሾ፥ ሂንቴ ኣሳቴꬃን ፆሳ ቦንቺቴ። ");
INSERT INTO gofENT_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","ሂንቴ ታው ፃፊዳ ዳብዳቢያስ ዛሮይ ሃይሳ። ኢሲ ኣሲ ማቾና ዴዒኮ ሎዖ። ");
INSERT INTO gofENT_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","ሺን ላይማቴꬃፌ ኣታናው ኢሲ ኢሲ ኣዴይ ማቾ ኤኮ፤ ቃሲ ኢሲ ኢሲ ማጫሳስ ኣዚኒ ዴዖ። ");
INSERT INTO gofENT_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","ኣዚናይ ባ ማቼስ፥ ቃሲ ማቺያ ባ ኣዚናስ ቤሲያባ ኩንꬆ። ");
INSERT INTO gofENT_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","ማቼስ ባ ኣሳቴꬃ ቦላ ኢው ማቲ ባዋ፥ ሺን ማታይ ኢ ኣዚናሳ። ሄሳዳካ፥ ኣዚናስ ኢያ ኣሳቴꬃ ቦላ ማቲ ባዋ፥ ሺን ማታይ ማቼሳ። ");
INSERT INTO gofENT_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","ሂንቴ ዎሳን ጉꬃ ዎዴ ጋምዓናው ዞሬቴꬃን ጊዶና ኢፂኮ፥ ኢሶይ ኢሱዋ ዲጎፊቴ። ሄሳ ጋሶን ሂንቴናቴꬃ ሃራናው ፆኔቲን፥ ፃላሄይ ሂንቴና ፓጮና ሜላ ኢሲፌ ዴዒቴ። ");
INSERT INTO gofENT_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","ሺን ታኒ ሂንቴና ዞራናው ሃይሳ ጋይሲፔ ኣቲን ኪታ ጊዴና። ");
INSERT INTO gofENT_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","ኣሲ ኡባይ ታዳ ማቾ ኤኮና ዴዒያኮ ዶሳይስ፥ ሺን ፆሳይ ኢሱዋስ ኢሱዋስ ኢሚዳ ዱማ ኢሞቲ ዴዔስ። ኢሱዋስ ሃይሳ ሜላ ሃንኩዋስ ሄሳ ሜላ ኢሞቲ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","ማቾ ኤኪቦናይሳታሲኔ ኣዚና ጌሊቦናይሳታስ ቃሲ ኣምዔታስ ታኒ ጌይ፥ ታዳ ኤኮና ዎይኮ ጌሎና ዴዒቴ ጋዳ ዞራይስ። ");
INSERT INTO gofENT_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","ሺን ኣሞን ፁጌቴይሳፌ ኤኬይሲኔ ጌሌይሲ ሎዖ ጊዲያ ጊሾ ኤንቲ ባንታና ሃራናው ዳንዳዖና ኢፂኮ፥ ኤኮኔ ጌሎ። ");
INSERT INTO gofENT_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","ታኒ ኤኪዳይሳታኔ ጌሊዳይሳታ ሃይሳዳ ጋዳ ዞራይስ፤ ታና ጊዲኬ ጎዳይ ኪቴስ፤ ማቺያ ባ ኣዚናፔ ሻኬቶፎ። ");
INSERT INTO gofENT_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","ሺን ሻኬቲኮ ሃራ ኣዚና ጌሎና ባርካ ዴዖ ዎይኮ ባ ኣዚናራ ጊጎ። ኣዚናይ ባ ማቺው ቢሎፎ። ");
INSERT INTO gofENT_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","ሺን ሃራታስ ጎዳ ጊዶናሺን ታኒ ሃይሳዳ ጋይስ። ኣማኖና ማቻ ዴዒያ ኣማኒያ ኣዚኒ ዴዒኮ፥ ኢያ ማቺያ ኢያራ ኢሲፌ ዳናው ኮይኮ ኢዮ ቢሎፎ። ");
INSERT INTO gofENT_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","ቃሲ ኣማኖና ኣዚኒ ዴዒያ ኣማኒያ ማቻ ዴዒኮ፥ ኢ ኣዚናይ ኢራ ኢሲፌ ዳናው ኮይኮ ኢያፔ ቢሌቶፎ። ");
INSERT INTO gofENT_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","ኣማኖና ኣዚናይ ባ ኣማኒያ ማቼ ባጋራ ጌዬስ፤ ቃሲ ኣማኖና ማቺያ ባ ኣማኒያ ኣዚና ባጋራ ጌያዉሱ። ሄሲ ባይኔኮ፥ ሂንቴ ናይቲ ቱና ጊዶሶና፥ ሺን ሃዒ ኤንቲ ጌሺ። ");
INSERT INTO gofENT_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","ሺን ኣማኖና ኣዚናይ ዎይኮ ማቺያ ቢላናው ኮይኮ ቢሎ። ኣማኒያ ማቺያ ዎይኮ ኣዚናይ ሄሳ ሜላባን ቃሼቶኮና። ፆሳይ ኑና ሳሮቴꬃን ዳና ሜላ ፄጊስ። ");
INSERT INTO gofENT_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","ኣማኒያ ማቼቴ፥ ኔኒ ኣማኖና ኔ ኣዚና ኣሻኔኮ ኣይ ኤራይ? ዎይኮ ኣማኒያ ኣዚናው፥ ኔኒ ኣማኖና ኔ ማቺው ኣሻኔኮ ኣይ ኤራይ? ");
INSERT INTO gofENT_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","ኢሲ ኢሲ ኣሲ ጎዳይ ኢያው ኢሚዳ ኢሞታዳኔ ፆሳይ ኢያ ፄጊዳይሳዳ ዴዖ። ዎሳ ኬꬃ ኡባን ታኒ ታማርሲዳ ዎጋይ ሃይሳ። ");
INSERT INTO gofENT_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","ኦኒካ ቃፃሬቲዲ ኣማኒዳባ ጊዲኮ፥ ቃፃሬቶናዳ ሃኖፖ። ቃፃሬቶና ኣማኒዳ ኦኒካ ዴዒኮ፥ ቃፃሬታናው ኮዮፖ። ");
INSERT INTO gofENT_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","ፆሳ ኪታ ፖላናው ቤሴስፔ ኣቲን ቃፃሬቲን ቃፃሬቶና ኣጊን ኣይኮካ ማዴና። ");
INSERT INTO gofENT_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","ኢሲ ኢሲ ኣሲ ፆሳይ ባና ፄጊያ ዎዴ ዴዔይሳዳ ዴዖ። ");
INSERT INTO gofENT_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","ፆሳይ ኔና ፄጊያ ዎዴ ኔኒ ኣይሌ? ኣይኮይ ባዋ ሄሳስ ኡንዔቶፋ። ሺን ኔኒ ኣይሌቴꬃፌ ላዓ ኬያናው ዳንዳዒኮ ዬዳ ኬያ። ");
INSERT INTO gofENT_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","ኣይሌ ጊዲ ዴዒሼ ጎዳን ፄጌቲዳ ኣሲ ጎዳን ኣይሌቴꬃፌ ላዓ ኬዪስ። ሄሳዳካ፥ ኣይሌ ጊዶና ዴዒሼ፥ ጎዳን ፄጌቲዳ ኣሲ ኪሪስቶሳ ኣይሌ። ");
INSERT INTO gofENT_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","ፆሳይ ሂንቴና ጋቴን ሻሚዳ ጊሾ ኣሳ ኣይሌ ጊዶፒቴ። ");
INSERT INTO gofENT_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","ታ ኢሻቶ፥ ሂንቴ ኢሶይ ኢሶይ ፄጌቲያ ዎዴ ዴዒያ ዴዑዋን ፆሳራ ኢሲፌ ዴዒቴ። ");
INSERT INTO gofENT_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","ጌላዖታባ ጎዳይ ታና ኪቲዳባይ ባዋ። ሺን ጎዳይ ታው ኢሚዳ ማሮቴꬃ ሜላ ታኒ ሂንቴና ዞራይስ። ");
INSERT INTO gofENT_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","ሂዛ፥ ሃዒ ሜቱዋ ጊሾ ኤኮና ዎይኮ ጌሎና ዱሲ ታው ሎዖ ዳኔስ። ");
INSERT INTO gofENT_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","ኔ ማቾ ኤኪዳባ ጊዲኮ፥ ቢላናው ኮዮፓ። ኔ ማቾ ኤካቦናባ ጊዲኮ፥ ኤካናው ኮዮፓ። ");
INSERT INTO gofENT_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","ሺን ኔ ማቾ ኤኪኮ ናጋሪ ባዋ። ሄሳዳ ጌላዒያካ ኣዚና ጌሊኮ ናጋሪ ባዋ። ሺን ኤኪያ ጌሊያ ኣሳስ ሃ ሳዓን ዳሮ ሜቶይ ዴዒያ ጊሾ ሂንቴ ሄሳፌ ኣታና ሜላ ታ ኮያይስ። ");
INSERT INTO gofENT_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","ታ ኢሻቶ፥ ታ ጌይ ሄሳ፤ ዎዴይ ዉሪስ። ሂዛፔ ሲንꬄ ማቻ ዴዔይሲ ማቾ ኤኮናይሳዳ ዴዖ። ");
INSERT INTO gofENT_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","ዬኬይሳቲ ዬኮናዳ፥ ኡፋይቴይሳቲ ኡፋይቶናዳ፥ ሻሜይሳቲ ኣይኮይካ ባይናዳ ባንታና ታይቦ። ");
INSERT INTO gofENT_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","ሃ ሳዓ ሻሉዋን ማዴቴይሳቲ ማዴቲቦናዳ ሃኖ። ሃ ኣላሚያ ማላይ ኣꬋና። ");
INSERT INTO gofENT_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","ሂንቴ ሂርጊ ባይና ዳና ሜላ ታ ዶሳይስ። ማቾ ኤኪቦናይሲ ጎዳ ኡፋይሳናው ኮያ ጊሾ ጎዳባ ቆፔስ። ");
INSERT INTO gofENT_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","ሺን ማቾ ኤኪዳይሲ ባ ማቺው ኡፋይሳናው ኮያ ጊሾ ሃ ሳዓባ ቆፔስ። ");
INSERT INTO gofENT_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","ኢያ ቆፋይ ናምዓን ሻኬቴስ። ኣዚና ጌላቦና ጌላዒያ ባ ኣሳቴꬃኒኔ ባ ሼምፑዋን ጌያዳ ጎዳ ኡፋይሳናው ኮያ ጊሾ ጎዳባ ቆፓዉሱ። ሺን ኣዚና ጌሊዳራ ባ ኣዚና ኡፋይሳናው ኮያ ጊሾ ሳዓባ ቆፓዉሱ። ");
INSERT INTO gofENT_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","ታኒ ሄሳ ሂንቴው ኦዴይ፥ ሂንቴ ማዴታና ሜላሳፌ ኣቲን ሂንቴና ኡንዔꬃናው ጊዴና። ሺን ሂንቴ ቆፋይ ሻኬቶና ማራን ዴዒዲ ጎዳ ኡፋይሲያባ ሂንቴ ኦꬃና ሜላ ታኒ ኦዳይስ። ");
INSERT INTO gofENT_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","ኦኒካ ባ ኦይቺዳ ጌላዔስ ጌሎ ዎዴይ ኣꬊስ ጊዲ ኢዮ ኣጋናው ቆፒኮ፥ ሄሲ ቃሲ ኢው ሎዖ ጊዶናይሲ ኢያው ሲዔቲኮ፥ ባ ኮዪዳይሳ ኦꬆ፤ ኤንቲ ኤኬቶ፥ ጌሌቶ፤ ሄሳን ናጋሪ ባዋ። ");
INSERT INTO gofENT_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","ሺን ኢሲ ኣሲ ኡንዔꬂያባይ ꬋዪን፥ ባ ዎዛናን ሚኒዲ፥ ባና ሃሪዲ፥ ባ ኦይቺዳ ጌላዒው ኤኮና ኣጋናው ኮይኮ ሎይꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","ሄሳ ጊሾ፥ ጌላዒው ኤኪያ ኡራይ ሎይꬂስ፤ ቃሲ ኤኮና ኡራይ ዳሮ ሎይꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","ማቺያ ባ ኣዚናይ ፓፃ ዴዒያ ዎዴ ኡባን ኢያራ ቃሼታሱ። ሺን ኢ ኣዚናይ ሃይቂኮ፥ ባ ዶሲዳ ኣዚና ጌላናው ዳንዳዓዉሱ። ጊዶሺን፥ ኢያ ጌሊያ ኣዴይ ኣማኒያ ኣሲ ጊዳናው ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","ታ ቆፋን ጊዲኮ፥ ኢያ ጌሎና ዴዒኮ ኡፋይሳን ዳና። ቃሲ ታው፥ ታ ቦላ ፆሳ ኣያኒ ዴዒያ ዳኔስ። ");
INSERT INTO gofENT_vpl VALUES ("C18_1","076_8_1","1CO","8","1","1","ኤቃስ ያርሼቲያ ካꬃባ ጊዲኮ ኑ ኡባይ ኤሮስ። ኤራቴꬂ ኦቶርሴስ፥ ሺን ሲቆይ ዲቼስ። ");
INSERT INTO gofENT_vpl VALUES ("C18_2","076_8_2","1CO","8","2","2","ኦኒካ ባና ኤራይስ ጊዲ ቆፒኮ፥ ኢ ቡሮ ኤራናው ቤሴይሳ ኤሪቤና። ");
INSERT INTO gofENT_vpl VALUES ("C18_3","076_8_3","1CO","8","3","3","ሺን ኦኒካ ፆሳ ሲቂኮ ኢ ፆሳ ማታን ኤሬቲዳይሳ። ");
INSERT INTO gofENT_vpl VALUES ("C18_4","076_8_4","1CO","8","4","4","ሄሳ ጊሾ፥ ኤቃስ ያርሼቲዳ ካꬂ ሙሳባ ጊዲኮ ሃ ኣላሚያን ጎዲ ኢሲ ፆሳፌ ኣቲን ሃሪ ባይና ጊሾ ኤቂ ፓꬆናባ ጊዴይሳ ኑኒ ኤሮስ። ");
INSERT INTO gofENT_vpl VALUES ("C18_5","076_8_5","1CO","8","5","5","ፆሴ ጊዶናሺን ሳሎኒኔ ሳዓን ፆሴ ጌቴቲ ፄጌቲያ ዳሮ ፆሳቲኔ ጎዳቲ ዴዒኮካ፥ ");
INSERT INTO gofENT_vpl VALUES ("C18_6","076_8_6","1CO","8","6","6","ኡባባ ሜꬊዳ፥ ኑ ኢያባ ጊዲዳ፥ ኢሲ ፆሳይ፥ ኣዋይ፥ ኑስ ዴዔስ። ኡባይ ኢያ ባጋራ ሜꬌቲዳ፥ ኑካ ኢያ ባጋራ ዴዖ ዴሚዳ ኢሲ ጎዳይ፥ ዬሱስ ኪሪስቶሲ ኑስ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("C18_7","076_8_7","1CO","8","7","7","ሺን ሃይሳ ኤሬይ ኡባ ጊዴና። ኢሲ ኢሲ ኣሳይ ኤቃ ጎይኖራ ሜዜቲዳ ጊሾ ካꬂ ሚያ ዎዴ ኤቃስ ያርሼቲዳባ ኦꬂዲ ኤኮሶና። ሄ ዎዴ ኤንታ ካሃይ ዳቡራ ጊዲያ ጊሾ ቱኔስ። ");
INSERT INTO gofENT_vpl VALUES ("C18_8","076_8_8","1CO","8","8","8","ሺን ካꬂ ኑና ፆሳራ ዳቦዬና። ኑ ሞና ኣጊዲ ኣይኮካ ቆሄቶኮ፤ ቃሲ ሚዲ ዱማ ጎዔቶኮ። ");
INSERT INTO gofENT_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","ሺን ሂንቴ ኮዪዳባ ማናው ላዓቴꬂ ሂንቴው ዴዒኮካ ሄሲ ኣማኖን ሚኖናይሳታ ꬉቦና ሜላ ናጌቲቴ። ");
INSERT INTO gofENT_vpl VALUES ("C18_10","076_8_10","1CO","8","10","10","ኔኒ ኔና ኤራንቾ ጋዳ ኤቃስ ያርሼቲዳ ካꬂ ማናው ኤቃ ኬꬃን ኡቲዳሺን፥ ኣማኖን ሚኖናይሲ ኔና ቤዒኮ ሄሲ ኢያ ኤቃስ ያርሼቲዳ ካꬂ ማና ሜላ ዴንꬄꬄኔዬ? ");
INSERT INTO gofENT_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","ሂዛ፥ ኔ ኤራቴꬃ ጋሶን ኪሪስቶሲ ኢያ ጊሾ ሃይቂዳ፥ ኣማኖን ሚኖና ኔ ኢሻይ፥ ꬋይስ። ");
INSERT INTO gofENT_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","ሄሳዳ ኦꬂዲ፥ ኣማኖን ሚኖና ሂንቴ ኢሻታ ቆሂሼኔ ኤንታ ካሃ ማዱንፂሲሼ ኪሪስቶሳ ቆሄታ። ");
INSERT INTO gofENT_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","ሄሳ ጊሾ፥ ካꬂ ታ ኢሻ ꬉቢያባ ጊዲኮ፥ ኢ ꬉቤቶና ሜላ ኣሾ ኡባራካ ሚኬ። ");
INSERT INTO gofENT_vpl VALUES ("C19_1","076_9_1","1CO","9","1","1","ታኒ ዬዳ ዴዒያ ኣሲ ጊዲኪና? ታ ሃዋሬ ጊዲኪና? ታኒ ኑ ጎዳ ዬሱስ ኪሪስቶሳ ቤዓቢኪና? ሂንቴ ጎዳን ታ ዳቡራ ኣይፌ ጊዴኬቲ? ");
INSERT INTO gofENT_vpl VALUES ("C19_2","076_9_2","1CO","9","2","2","ሂንቴ ጎዳባ ጊዲያ ጊሾ ታ ሃራታስ ሃዋሬ ጊዶና ኢፂኮካ፥ ሂንቴው ሃዋሬ ጊዴይሳስ ሂንቴ ማርካ። ");
INSERT INTO gofENT_vpl VALUES ("C19_3","076_9_3","1CO","9","3","3","ታና ሃዋሬ ጊዴና ጌይሳታስ ታ ኢሚያ ዛሮይ ሃይሳ። ");
INSERT INTO gofENT_vpl VALUES ("C19_4","076_9_4","1CO","9","4","4","ኑ ሂንቴፌ ማናዉኔ ኡያናው ቱማ ኑስ ማቲ ባዌ? ");
INSERT INTO gofENT_vpl VALUES ("C19_5","076_9_5","1CO","9","5","5","ሃንኮ ሃዋሬታዳ፥ ጎዳ ኢሻታዳኔ ጴፂሮሳዳ፥ ኣማኒያ ኑ ማቼታ ኤኪ ሃሙታናው ኑስ ማቲ ባዌ? ");
INSERT INTO gofENT_vpl VALUES ("C19_6","076_9_6","1CO","9","6","6","ዎይኮ ኦꬂዲ ማናው ቤሴይ ታራኔ ባርናባሳ ፃላሌ? ");
INSERT INTO gofENT_vpl VALUES ("C19_7","076_9_7","1CO","9","7","7","ባ ሚሼን ዎታዳሬታꬂ ኦꬄይ ኦኔ? ዎይኮ ዎይኔ ቶኪዲ፥ ኢያፔ ኣይፌ ሞናይ ኦኔ? ዎይኮ ዉዴ ሄሚሼ፥ ሄ ዉዲያፔ ማꬂ ኡዮናይ ኦኔ? ");
INSERT INTO gofENT_vpl VALUES ("C19_8","076_9_8","1CO","9","8","8","ታኒ ሄሳ ኣሳ ቆፋꬆ ጋይናዬ? ሂጌይ ሄሳ ጌኔ? ");
INSERT INTO gofENT_vpl VALUES ("C19_9","076_9_9","1CO","9","9","9","ሙሴ ሂጊያን፥ «ዉዱማን ካꬃ ዬꬊያ ቦራ ዶና ቃቾፋ» ጌቴቲዲ ፃፌቲስ። ያቲን ፆሳይ ሄሳ ቦራስ ቆፒዲ ጊዴ? ");
INSERT INTO gofENT_vpl VALUES ("C19_10","076_9_10","1CO","9","10","10","ፆሳይ ሄሳ ጊዳይ ኑስ ቆፒዲ ጊዴኔ? ኤ ኑ ጊሾሳ። ጎዬይሲካ፥ ካꬃ ጌሼይሲካ ባና ጋኬይሳ ኤካና ጊዲ ኡፋይሳን ኦꬃናው ቤሴስ ጌቴቲዲ ቱማ ኑ ጊሾ ፃፌቲስ። ");
INSERT INTO gofENT_vpl VALUES ("C19_11","076_9_11","1CO","9","11","11","ኑኒ ሂንቴ ጊዶን ኣያና ዜሬꬂ ዜሪዳ ጊዲኮ ኣሾስ ኮሺያባ ኑ ሂንቴፌ ኤኪኮ፥ ሄሲ ጊታባዬ? ");
INSERT INTO gofENT_vpl VALUES ("C19_12","076_9_12","1CO","9","12","12","ሃራቲ ሄሳ ሂንቴፌ ኤካናው ኤንታው ማቲ ዴዒኮ፥ ኑስ ኤንታይሳፌ ኣꬊያ ማቲ ዴዔስ። ሺን ኑኒ ኪሪስቶሳ ዎንጌላስ ꬉቤ ጊዶና ሜላ፥ ኡባ ጌንጮሲፔ ኣቲን ሄ ማታን ጎዔቲቦኮ። ");
INSERT INTO gofENT_vpl VALUES ("C19_13","076_9_13","1CO","9","13","13","ፆሳ ኬꬃን ኦꬂያ ኣሳቲ ባንታ ካꬃ ፆሳ ኬꬃፌ ኤኬይሳ ኤሬኬቲ? ቃሲ ያርሾ ቤሳን ኦꬄይሳቲ ያርሹዋፌ ኤኬይሳ ኤሬኬቲ? ");
INSERT INTO gofENT_vpl VALUES ("C19_14","076_9_14","1CO","9","14","14","ሄሳዳካ፥ ዎንጌላ ማርካቴይሳቲ ዱሳስ ኮሺያባ ዎንጌላፔ ኤካና ሜላ ጎዳይ ኪቲስ። ");
INSERT INTO gofENT_vpl VALUES ("C19_15","076_9_15","1CO","9","15","15","ሺን ታኒ ሃ ማታ ኡባን ኣይኮካ ጎዔታቢኬ። ታኒ ሃይሳ ፃፊዳይ ታ ማታ ቦንቺሳናው ኮያዳ ጊዴና። ኦኒካ ታ ጬቁዋ ሃዳ ኦꬃናፔ ሃይቆይ ታው ሎዖ። ");
INSERT INTO gofENT_vpl VALUES ("C19_16","076_9_16","1CO","9","16","16","ታኒ ዎንጌላ ኦዴይ ኪቴቲዳ ጊሾሳፌ ኣቲን ታና ጬቂሲያባ ጊዴና። ዎንጌላ ኦዶና ኢፂኮ፥ ታና ኣዬ። ");
INSERT INTO gofENT_vpl VALUES ("C19_17","076_9_17","1CO","9","17","17","ታኒ ዎንጌላ ዶሳዳ ሳባኪኮ ታው ዎይቶይ ዴዔስ። ሺን ታኒ ዎንጌላ ዶሶና ኪቴታዳ ሳባኪያባ ጊዲኮ ሄሳ ፆሳይ ታው ሃዳራ ኢሚስ። ");
INSERT INTO gofENT_vpl VALUES ("C19_18","076_9_18","1CO","9","18","18","ያቲን፥ ታ ዎይቶይ ኣይቤ? ታኒ ዎንጌላ ሳባኪያ ዎዴ ታ ማታን ጎዔቶና ዎንጌላ ጮ ሳባኬይሲ ታው ዎይቶ። ");
INSERT INTO gofENT_vpl VALUES ("C19_19","076_9_19","1CO","9","19","19","ታኒ ኦዴስካ ኣይሌ ጊዲኬ፥ ሺን ዳሮታ ኣሻናው ኡባስ ኣይሌ ጊዳስ። ");
INSERT INTO gofENT_vpl VALUES ("C19_20","076_9_20","1CO","9","20","20","ታኒ ኣይሁዴታ ኣሻናው ኤንታራ ኤንታ ጊዳስ። ታ ሁዔን ሂጌፌ ጋርሳን ዴዒኬ፥ ሺን ሂጌፌ ጋርሳን ዴዔይሳታ ኣሻናው ሂጌፌ ጋርሳን ዴዒያ ኣሲ ጊዳስ። ");
INSERT INTO gofENT_vpl VALUES ("C19_21","076_9_21","1CO","9","21","21","ፆሳ ሂጊያፌ ካሬ ኬዮና፥ ኪሪስቶሳ ሂጊያስ ኪቴታሼ፥ ሂጌይ ባይናይሳታ ኣሻናው ሂጌይ ባይና ኣሳዳ ጊዳስ። ");
INSERT INTO gofENT_vpl VALUES ("C19_22","076_9_22","1CO","9","22","22","ታኒ ዳቡራንቾታ ኣሻናው ዳቡራንቾ ጊዳስ። ታኒ ጉꬃታ ኣሻናው ኡባራ ኡባ ሃናስ። ");
INSERT INTO gofENT_vpl VALUES ("C19_23","076_9_23","1CO","9","23","23","ታኒ ዎንጌላ ኣንጁዋ ሻኬታናው፥ ሃ ኡባ ዎንጌላ ጊሾ ሃናስ። ");
INSERT INTO gofENT_vpl VALUES ("C19_24","076_9_24","1CO","9","24","24","ዎꬃን ጋዴቲያ ኡባይ ዎፄስ፥ ሺን ኢሱዋ ፃላሊ ዎይቶ ኤኬይሳ ኤሬኬቲ? ሄሳዳ ሂንቴካ ዎይቱዋ ኤካናው ዎፂቴ። ");
INSERT INTO gofENT_vpl VALUES ("C19_25","076_9_25","1CO","9","25","25","ጋዴቲያ ኣሳ ኡባይ ኡባባን ባንታና ሃሬስ። ኤንቲ ሄሳ ዳቡሬይ ꬋያ ካላቻ ዎይቶ ኤካናሳ። ሺን ኑኒ ዳቡሬይ ሜሪና ካላቻ ዎይቱዋ ኤካናሳ። ");
INSERT INTO gofENT_vpl VALUES ("C19_26","076_9_26","1CO","9","26","26","ሄሳ ጊሾ፥ ታኒ ቆፊ ባይና ኣሳዳ ዎፂኬ። ጫርኮ ዪምፒያ ኣሳዳ ጮ ኩሼ ዬዲኬ። ");
INSERT INTO gofENT_vpl VALUES ("C19_27","076_9_27","1CO","9","27","27","ሺን ታኒ ሃራታስ ዎንጌላ ሳባኪዳፔ ጉዬ ታ ሁዔን ዬጌቲዳ ኣሲ ጊዶና ሜላ ታ ኣሳቴꬃ ዎልቃን ሃራዳ ታው ኪቴታና ሜላ ኦꬃይስ። ");
INSERT INTO gofENT_vpl VALUES ("C110_1","076_10_1","1CO","10","1","1","ታ ኢሻቶ፥ ታኒ ሂንቴ ሃይሳ ኣኬካና ሜላ ኮያይስ። ኑ ኣዋቲ ኡባይ ሻራፔ ጋርሳራ ሃሙቲዶሶና፤ ኡባይ ኣባ ፒኒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("C110_2","076_10_2","1CO","10","2","2","ኤንቲ ሙሴራ ኢሲፋናው ሻራኒኔ ኣባን ፃማቄቲዶስና። ");
INSERT INTO gofENT_vpl VALUES ("C110_3","076_10_3","1CO","10","3","3","ኤንቲ ኡባይ ኢሲ ኣያና ካꬃ ሚዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("C110_4","076_10_4","1CO","10","4","4","ቃሲ ኡባይ ኢሲ ኣያና ኡሻ ኡዪዶሶና። ኤንቲ ባንታና ካሊያ ኣያና ዛላፌ ፑልቲዳ ኡሻ ኡዪዶሶና፤ ሄ ዛላይካ ኪሪስቶሳ። ");
INSERT INTO gofENT_vpl VALUES ("C110_5","076_10_5","1CO","10","5","5","ሺን ፆሳይ ኤንታፌ ዳሮታን ኡፋይቲቦና ጊሾ ኤንታ ኣሃይ ባዞ ቢታን ዎꬊዲ ኣቲስ። ");
INSERT INTO gofENT_vpl VALUES ("C110_6","076_10_6","1CO","10","6","6","ኤንቲ ኢታባ ኣሞቲዳይሳዳ፥ ኑካ ኢታባ ኣሞቶና ሜላ ሄሲ ኡባይ ኑስ ሌሚሶ ጊዲስ። ");
INSERT INTO gofENT_vpl VALUES ("C110_7","076_10_7","1CO","10","7","7","ጌሻ ማፃፋን፥ «ኣሳይ ማናዉኔ ኡያናው ኡቲዶሶና፤ ቃሲ ዬፃናው ዴንዲዶሶና» ጌቴቲዳይሳዳ ኤንታፌ ኢሶቲ ኢሶቲ ኤቃ ጎይኒዳይሳ ሜላ ሂንቴ ኤቃ ጎይኖፊቴ። ");
INSERT INTO gofENT_vpl VALUES ("C110_8","076_10_8","1CO","10","8","8","ኤንታፌ ኢሶቲ ኢሶቲ ላይማቲዳይሳዳ ኑ ላይማታናው ቤሴና። ሄሳ ጋሶን ኤንታፌ ኢሲ ጋላስ ላታማኔ ሄꬑ ሙኩሉ ኣሲ ሃይቂስ። ");
INSERT INTO gofENT_vpl VALUES ("C110_9","076_10_9","1CO","10","9","9","ኤንታፌ ኢሶቲ ኢሶቲ ጎዳ ፓጪዲ ሾሻን ዱኬቲዲ ሃይቂዳይሳዳ ኑ ጎዳ ፓጫናው ቤሴና። ");
INSERT INTO gofENT_vpl VALUES ("C110_10","076_10_10","1CO","10","10","10","ኤንታፌ ኢሶቲ ኢሶቲ ዙዙሚዲ ሃይቆ ኤሂያ ኪታንቹዋን ꬋዪዳይሳዳ ሂንቴካ ዙዙሞፊቴ። ");
INSERT INTO gofENT_vpl VALUES ("C110_11","076_10_11","1CO","10","11","11","ሃ ኤንታ ቦላ ጋኪዳ ኡባይ ኑ ናጌታና ሜላ ኑስ ሌሚሶ ጊዲስ። ቃሲ ዎዴ ዉርሴꬃ ቦላ ዴዒያ ኑስ ቲሚርቴ ጊዳና ሜላ ሃ ኡባይ ፃፌቲስ። ");
INSERT INTO gofENT_vpl VALUES ("C110_12","076_10_12","1CO","10","12","12","ሄሳ ጊሾ፥ ታ ኤቃስ ጊያ ኦኒካ ኩንዶና ሜላ ባና ናጎ። ");
INSERT INTO gofENT_vpl VALUES ("C110_13","076_10_13","1CO","10","13","13","ኣሴ ኡባ ጋኪያ ፓጬፔ ኣቲን ዱማ ፓጬይ ሂንቴና ጋኪቤና። ሂንቴ ዎልቃይ ዳንዳዔይሳፌ ኣꬊያ ፓጬን ሂንቴ ፓጬቶና ሜላ ኣꬂ ኢሞና ፆሳይ ኣማኔቲዳይሳ። ሂንቴና ፓጬይ ጋኪያ ዎዴ ሄ ፓጪያ ኢ ሂንቴና ዳንዳዒሳና። ቃሲ ሄ ፓጪያፔ ሂንቴ ኬያና ኦጊያ ኢ ጊጊሳና። ");
INSERT INTO gofENT_vpl VALUES ("C110_14","076_10_14","1CO","10","14","14","ሂዛ፥ ታ ኣልዖ ኢሻቶ፥ ኤቃ ጎይኖፌ ሃኪቴ። ");
INSERT INTO gofENT_vpl VALUES ("C110_15","076_10_15","1CO","10","15","15","ሂንቴ ዎዛናማ ኣሲ ጊዲዳ ጊሾ ታ ሃይሳ ኦዳይስ። ታኒ ጌይሲ ቱማ ጊዴይሳ ሂንቴ ሂንቴ ሁዔን ፒርዲቴ። ");
INSERT INTO gofENT_vpl VALUES ("C110_16","076_10_16","1CO","10","16","16","ኑኒ ፆሳ ጋላቲዲ ሻኬቲያ ኣንጆ ፁዓይ ኪሪስቶሳ ሱꬃራ ኢሲፌቴꬂ ዴዔይሳ ጊዴኔዬ? ቃሲ ኑኒ ባꬂያ ኡይꬃይ ኪሪስቶሳ ኣሹዋራ ኢሲፌቴꬂ ዴዔይሳ ጊዴኔዬ? ");
INSERT INTO gofENT_vpl VALUES ("C110_17","076_10_17","1CO","10","17","17","ኑኒ ዳሮ ጊዲኮካ ኡይꬃይ ኢሲኖ፥ ኑ ሄ ኢሲ ኡይꬃ ሻኬቲያ ጊሾ ኢሲ ኣሳቴꬂ። ");
INSERT INTO gofENT_vpl VALUES ("C110_18","076_10_18","1CO","10","18","18","ኣኔ ኢስራዔሌ ኣሳይ ኦꬂዳይሳ ኣኬኪቴ። ያርሼቲዳ ያርሹዋ ሜይሳታስ ያርሾ ቤሳራ ኢሲፌቴꬂ ባዌዬ? ");
INSERT INTO gofENT_vpl VALUES ("C110_19","076_10_19","1CO","10","19","19","ታኒ ኣይ ጋናው ኮያዳ ጋይና? ኤቃስ ያርሼቲዳ ካꬃይ ዎይኮ ኤቃይ ፓꬂያባ ጊዴና። ");
INSERT INTO gofENT_vpl VALUES ("C110_20","076_10_20","1CO","10","20","20","ኤንቲ ያርሼይ ፆሳስ ጊዶናሺን ቱና ኣያናታሳ። ሄሳ ጊሾ፥ ሂንቴው ቱና ኣያናታራ ኢሲፌቴꬂ ዳና ሜላ ኮዪኬ። ");
INSERT INTO gofENT_vpl VALUES ("C110_21","076_10_21","1CO","10","21","21","ሂንቴ ጎዳ ፁዓፔ ኡዪሼ፥ ቃሲ ቱና ኣያናታ ፁዓፔ ኡያናው ዳንዳዔኬታ። ጎዳ ጋይታፔ ሚሼ ቃሲ ቱና ኣያናታ ጋይታፔ ማናው ዳንዳዔኬታ። ");
INSERT INTO gofENT_vpl VALUES ("C110_22","076_10_22","1CO","10","22","22","ኑ ሄሳ ኦꬂዲ ጎዳ ዪሎይኖ? ኑ ኢያፔ ኣꬊያ ሚኖዬ? ");
INSERT INTO gofENT_vpl VALUES ("C110_23","076_10_23","1CO","10","23","23","ሂንቴ፥ «ኡባባ ኦꬆና ሜላ ዲጊያባይ ባዋ» ጌታ፥ ሺን ኡባይ ማዴና። ሂንቴ፥ «ኡባባ ኦꬆና ሜላ ዲጊያባይ ባዋ» ጌታ፥ ሺን ኡባባይ ዲቼና። ");
INSERT INTO gofENT_vpl VALUES ("C110_24","076_10_24","1CO","10","24","24","ኢሲ ኢሲ ኣሲ፥ ሃራ ኣሲ ማዲያባ ቆፓናው ቤሴሲፔ ኣቲን ባና ማዲያባ ፃላላ ቆፖፎ። ");
INSERT INTO gofENT_vpl VALUES ("C110_25","076_10_25","1CO","10","25","25","ሂንቴ ካሃ ሲꬌን ጌልሲያ ኦይሻ ዴንꬆና ጊያን ባይዜቲያ ኣሹዋ ጮ ሚቴ። ");
INSERT INTO gofENT_vpl VALUES ("C110_26","076_10_26","1CO","10","26","26","ኣይስ ጊኮ፥ «ሳዒኔ ሳዓን ዴዒያ ኡባይ ጎዳሳ።» ");
INSERT INTO gofENT_vpl VALUES ("C110_27","076_10_27","1CO","10","27","27","ኢሲ ኣማኖና ኣሲ ሂንቴና ኢማታናው ኮዪዲ ፄጊኮ ባናው ኮይኮ ቢቴ። ሂንቴ ካሃን ሜꬌቲያ ኦይሻን ሲꬎና ሂንቴ ሲንꬄ ኣꬂያባ ኡባ ሚቴ። ");
INSERT INTO gofENT_vpl VALUES ("C110_28","076_10_28","1CO","10","28","28","ሺን ኢሲ ኣሲ፥ «ሃይሲ ኤቃስ ያርሼቲዳባ» ጊኮ፥ ሄ ሂንቴው ኦዲዳ ኣዲያ ጊሾኔ ሂንቴ ካሃ ጊሾ ሄ ካꬃ ሞፒቴ። ");
INSERT INTO gofENT_vpl VALUES ("C110_29","076_10_29","1CO","10","29","29","ታኒ፥ ካሃ ጊሾ ጌይ ሄ ሂንቴው ኦዲዳ ኡራ ካሃ ጉሱፌ ኣቲን ሂንቴ ካሃ ጊዴና። ሃራ ኣሳ ካሃ ጊሾ ጋዳ ታኒ ታ ላዓቴꬃ ቦላ ኣይስ ፒርዶ? ");
INSERT INTO gofENT_vpl VALUES ("C110_30","076_10_30","1CO","10","30","30","ታኒ ሚያ ካꬃ ፆሳ ጋላታዳ ሚኮ ባሊዳዳ ኣይስ ቦሬቲያና? ");
INSERT INTO gofENT_vpl VALUES ("C110_31","076_10_31","1CO","10","31","31","ሂዛ፥ ሂንቴ ኣይ ሚኮ ኣይ ኡዪኮ፥ ዎይኮ ኣይ ኦꬂኮካ ኡባባ ፆሳ ቦንቾስ ኦꬂቴ። ");
INSERT INTO gofENT_vpl VALUES ("C110_32","076_10_32","1CO","10","32","32","ኣይሁዴታ ጊዲን ጊሪኬታ ጊዲን ዎይኮ ፆሳ ዎሳ ኬꬂ ጊዲን ኦዴስካ ꬉቤ ጊዶፒቴ። ");
INSERT INTO gofENT_vpl VALUES ("C110_33","076_10_33","1CO","10","33","33","ታኒ ኡባ ዎዴ ዳሮታ ኣሻናው ኤንቲ ማዴቲያ ኦጌ ኮያይሲፔ ኣቲን ታና ማዲያ ኦጌ ኮዪኬ። ");
INSERT INTO gofENT_vpl VALUES ("C111_1","076_11_1","1CO","11","1","1","ታኒ ኪሪስቶሳ ሌሚሱዋ ካሌይሳዳ፥ ሂንቴካ ታና ካሊቴ። ");
INSERT INTO gofENT_vpl VALUES ("C111_2","076_11_2","1CO","11","2","2","ሂንቴ ኡባባን ታና ቆፒያ ጊሾኔ ታ ታማርሲዳ ቲሚርቲያ ሚንꬂዲ ናጊዳ ጊሾ ታ ሂንቴና ጋላታይስ። ");
INSERT INTO gofENT_vpl VALUES ("C111_3","076_11_3","1CO","11","3","3","ሺን ኪሪስቶሲ ኣዴ ኡባስ ሁዔ፥ ኣዴይ ማጫሳስ ሁዔ፥ ቃሲ ፆሳይ ኪሪስቶሳስ ሁዔ ጊዴይሳ ሂንቴ ኤራና ሜላ ታ ኮያይስ። ");
INSERT INTO gofENT_vpl VALUES ("C111_4","076_11_4","1CO","11","4","4","ባ ሁዒያ ጉሉንቲዲ ፆሳ ዎሲያ ዎይኮ ቲንቢቴ ኦዲያ ኣዴ ኡባይ ሁዔ ጊዲዳ ኪሪስቶሳ ቶቼስ። ");
INSERT INTO gofENT_vpl VALUES ("C111_5","076_11_5","1CO","11","5","5","ባ ሁዒያ ቃጮና ፆሳ ዎሲያ ዎይኮ ቲንቢቴ ኦዲያ ማጫሲያ ሁዔ ጊዲዳ ባ ኣዚና ቶቻዉሱ። ባ ሁዒያ ቃጮና ማጫሲያ ባ ሁዒያ ሜዴቲዳ ማጫሳ ሜላ። ");
INSERT INTO gofENT_vpl VALUES ("C111_6","076_11_6","1CO","11","6","6","ማጫሲ ባ ሁዒያ ቃጮና ኢፂኮ፥ ባ ሁዒያ ቃንፄቶ። ሺን ኢው ሁዒያ ቃንፆይ ዎይኮ ሜዶይ ቦርሶ ጊዲኮ ባ ሁዒያ ቃጮ። ");
INSERT INTO gofENT_vpl VALUES ("C111_7","076_11_7","1CO","11","7","7","ኣዴይ ፆሳ ሌሚሶኔ ፆሳ ቦንቾ ጊዲያ ጊሾ ባ ሁዒያ ቃቻናው ቤሴና፥ ሺን ማጫሲ ኣዴስ ቦንቾ። ");
INSERT INTO gofENT_vpl VALUES ("C111_8","076_11_8","1CO","11","8","8","ማጫሲ ኣዴፌ ሜꬌታሱፔ ኣቲን ኣዴይ ማጫሳፔ ሜꬌቲቤና። ");
INSERT INTO gofENT_vpl VALUES ("C111_9","076_11_9","1CO","11","9","9","ማጫሲ ኣዴስ ሜꬌቲሲፔ ኣቲን ኣዴይ ማጫሳስ ሜꬌቲቤና። ");
INSERT INTO gofENT_vpl VALUES ("C111_10","076_11_10","1CO","11","10","10","ሃይሳ ጊሾኔ ኪታንቾታ ጊሾ ማጫሲ ባው ማቲ ዴዔይሳ ቤሲያ ማላ ባ ሁዔን ቃጫናው ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("C111_11","076_11_11","1CO","11","11","11","ሺን ጎዳ ቆፋን ማጫሲ ኣዴይ ባይና ዴና፤ ኣዴይካ ማጫሲ ባይና ዴዔና። ");
INSERT INTO gofENT_vpl VALUES ("C111_12","076_11_12","1CO","11","12","12","ማጫሲ ኣዴፌ ሜꬌቲዳይሳዳ ኣዴይካ ማጫሳፔ ዬሌቲስ። ሺን ኡባባይካ ፆሳፌ ሜꬌቲስ። ");
INSERT INTO gofENT_vpl VALUES ("C111_13","076_11_13","1CO","11","13","13","ኣኔ ሂንቴ ፒርዲቴ። ማጫሲ ባ ሁዔ ቃጮና ፆሳ ዎሳናው ቤሲ? ");
INSERT INTO gofENT_vpl VALUES ("C111_14","076_11_14","1CO","11","14","14","ኣዴይ ባ ሁዒያ ዲቺኮ ኢያው ቦርሶ ጊዴይሳ ሃሪ ኣቶሺን ሜꬌቴꬂ ሂንቴና ታማርሴኔ? ");
INSERT INTO gofENT_vpl VALUES ("C111_15","076_11_15","1CO","11","15","15","ሺን ማጫሲ ባ ሁዒያ ዲቺኮ ኢው ቦንቾ ጊዴኔ? ማጫሳስ ሁዔይ ኢሜቲዳይ ኢያ ባና ካማና ሜላሳ። ");
INSERT INTO gofENT_vpl VALUES ("C111_16","076_11_16","1CO","11","16","16","ሺን ሃይሳ ቦላ ፓላማናው ኮያ ኣሲ ዴዒኮ፥ ኑስ ጊዲን ዎይኮ ፆሳ ዎሳ ኬꬃታስ ጊዲን ሃይሳፌ ሃራ ዎጊ ባዋ። ");
INSERT INTO gofENT_vpl VALUES ("C111_17","076_11_17","1CO","11","17","17","ሂንቴ ኢሲፌ ሺቄይ ጎዓስ ጊዶናሺን ቆሆስ ጊዲያ ጊሾ ሃዒ ታ ኢሚያ ኪታን ሂንቴና ናሺኬ። ");
INSERT INTO gofENT_vpl VALUES ("C111_18","076_11_18","1CO","11","18","18","ታ ኮይሮ ሲዒዳይ፥ ሂንቴ ዎሳ ኬꬃን ሺቂያ ዎዴ ሂንቴ ጊዶን ሻሄቴꬂ ዴዔይሳ። ሄ ታ ሲዒዳይሳፌ ባጋይ ቱማ ጊዴይሳ ኣማናይስ። ");
INSERT INTO gofENT_vpl VALUES ("C111_19","076_11_19","1CO","11","19","19","ሂንቴ ጊዶፌ ቱሚ ዴዔይሳቲ ኦናንቴኮ ኤሬታና ሜላ ሂንቴ ጊዶን ሻኮይ ዳናይሲ ኣቴና። ");
INSERT INTO gofENT_vpl VALUES ("C111_20","076_11_20","1CO","11","20","20","ሂንቴ ኢሲፌ ሺቂያ ዎዴ ሂንቴ ሺቄይ ጎዳ ካሁዋ ማናሳ ጊዴና። ");
INSERT INTO gofENT_vpl VALUES ("C111_21","076_11_21","1CO","11","21","21","ሂንቴ ካꬂ ሚያ ዎዴ ኢሶይ ኢሱዋ ናጎና ባይሳ ባይሳ ሚያ ጊሾ ኢሶይ ኮሻቴስ ሃንኮይ ቃሲ ማꬆቴስ። ");
INSERT INTO gofENT_vpl VALUES ("C111_22","076_11_22","1CO","11","22","22","ቱማ ሂንቴ ማናዉኔ ኡያናው ሂንቴው ኬꬂ ባዌ? ዎይኮ ፆሳ ዎሳ ኬꬃ ካꬌቲ? ኣይኮይ ባይና ማንቆታ ዬላዬቲ? ታ ሂንቴና ዎይጎ? ሃይሳስ ታ ሂንቴና ናሾ? ናሺኬ። ");
INSERT INTO gofENT_vpl VALUES ("C111_23","076_11_23","1CO","11","23","23","ታኒ ሂንቴው ኢሚዳ ቲሚርቲያ ጎዳፔ ኤካስ። ጎዳ ዬሱሲ ኣꬊዲ ኢሜቲያ ቃማን ኡይꬃ ኤኪዲ፥ ");
INSERT INTO gofENT_vpl VALUES ("C111_24","076_11_24","1CO","11","24","24","ፆሳ ጋላቲስ። ኡይꬃ ባꬂዲ «ሄዒቴ፤ ሚቴ። ሃይሲ ሂንቴው ኢሜቲያ ታ ኣሹዋ። ሃይሳ ሚሼ ታና ሃሳዪቴ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("C111_25","076_11_25","1CO","11","25","25","ሄሳዳካ፥ ካሁዋ ሚዲ ሲሚን፥ ፁዓ ኤኪዲ፥ «ሃይሲ ፁዓይ ታ ሱꬃን ኤቂያ ኦራꬃ ጫቁዋ። ሂንቴ ኢያፔ ኡያ ዎዴ ኡባን ታና ሃሳዪቴ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("C111_26","076_11_26","1CO","11","26","26","ሂንቴ ሃ ኡይꬃ ሚያ ዎዴኔ ሃ ፁዓ ኡያ ዎዴ ኡባን ጎዳይ ያና ጋካናው ኢያ ሃይቁዋ ኦዴታ። ");
INSERT INTO gofENT_vpl VALUES ("C111_27","076_11_27","1CO","11","27","27","ሄሳ ጊሾ፥ ቤሶና ኦጊያን ጎዳ ኡይꬃ ሚያ ዎይኮ ጎዳ ፁዓ ኡያ ኦኒካ ኢያ ኣሹዋኔ ሱꬃ ቶቺዳ ጊሾ ባ ናጋራን ኦይሼቴስ። ");
INSERT INTO gofENT_vpl VALUES ("C111_28","076_11_28","1CO","11","28","28","ሺን ኣሲ ባና ፓጮ። ያቲዲ ኡይꬃ ሞ፤ ፁዓፔካ ኡዮ። ");
INSERT INTO gofENT_vpl VALUES ("C111_29","076_11_29","1CO","11","29","29","ጎዳ ኣሹዋባ ሻኪ ኤሮና፥ ኡይꬃ ሜይኔ ፁዓፔ ኡዬይ፥ ባ ቦላ ፒርዳ ሜሲኔ ኡዬስ። ");
INSERT INTO gofENT_vpl VALUES ("C111_30","076_11_30","1CO","11","30","30","ሄሳ ጊሾ፥ ሂንቴ ጊዶፌ ዳሮቲ ዳቡሪዶሶና፤ ሃርጊዶሶና፤ ቃሲ ኡንዴና ኣሳቲ ሃይቂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("C111_31","076_11_31","1CO","11","31","31","ሺን ኑ ኑና ፓጪ ቤዒዳባ ጊዲያኮ፥ ኑ ቦላ ፒርዴታናሺን። ");
INSERT INTO gofENT_vpl VALUES ("C111_32","076_11_32","1CO","11","32","32","ኣላሜይ ፒርዴቲያ ዎዴ ኑ ኣላሚያራ ፒርዴቶና ሜላ ሃዒ ጎዳይ ኑና ሴሬስ። ");
INSERT INTO gofENT_vpl VALUES ("C111_33","076_11_33","1CO","11","33","33","ሄሳ ጊሾ፥ ታ ኢሻቶ፥ ጎዳ ካሁዋ ማናው ሂንቴ ሺቂያ ዎዴ ኢሶይ ኢሱዋ ጋꬂ ኤኪቴ። ");
INSERT INTO gofENT_vpl VALUES ("C111_34","076_11_34","1CO","11","34","34","ሂንቴ ሺቆይ ፒርዳስ ጊዶና ሜላ ኮሻቲዳ ኦኒካ ዴዒኮ፥ ባ ሶን ሞ። ኣቲዳባ ታኒ ያ ባዳ ሂንቴው ኦዳና። ");
INSERT INTO gofENT_vpl VALUES ("C112_1","076_12_1","1CO","12","1","1","ታ ኢሻቶ፥ ጌሻ ኣያና ኢሞታታባ ሂንቴ ኤራና ሜላ ታ ኮያስ። ");
INSERT INTO gofENT_vpl VALUES ("C112_2","076_12_2","1CO","12","2","2","ሂንቴ ፆሳ ኣማኖና ዎዴ ዶኒ ባይና ኤቃታን ጎሼቲዲ፥ ሂንቴ ኤሮና ሶ ቢዳይሳ ኤሬታ። ");
INSERT INTO gofENT_vpl VALUES ("C112_3","076_12_3","1CO","12","3","3","ፆሳ ኣያናይ ካሌꬂያ ኣሲ ኦኒካ፥ «ዬሱሲ ቃንጌቶ» ያጌና። ቃሲ ጌሻ ኣያናይ ካሌꬆና ዴዒሺን፥ ኦኒካ፥ «ዬሱሲ ጎዳ» ጋናው ዳንዳዖናይሳ ሂንቴ ኤራና ሜላ ኮያይስ። ");
INSERT INTO gofENT_vpl VALUES ("C112_4","076_12_4","1CO","12","4","4","ዱማ ዱማ ኣያና ኢሞታቲ ዴዖሶና፥ ሺን ኢሞታታ ኢሚያ ኣያናይ ኢሱዋ። ");
INSERT INTO gofENT_vpl VALUES ("C112_5","076_12_5","1CO","12","5","5","ኑ ጎዳስ ኦꬂያ ዱማ ዱማ ኦሶቲ ዴዖሶና፥ ሺን ጎዳይ ኢሱዋ። ");
INSERT INTO gofENT_vpl VALUES ("C112_6","076_12_6","1CO","12","6","6","ኑ ጎዳስ ኦꬂያ ዱማ ዱማ ኦጌቲ ዴዖሶና፥ ሺን ሄ ኦጌታን ኣሳ ኡባን ኦꬂያ ፆሳይ ኢሱዋ። ");
INSERT INTO gofENT_vpl VALUES ("C112_7","076_12_7","1CO","12","7","7","ሺን ኢሱዋስ ኢሱዋስ ኢሜቲዳ ኢሞታታን ሃራታ ማዳና ሜላ ጌሻ ኣያናይ ቆንጬስ። ");
INSERT INTO gofENT_vpl VALUES ("C112_8","076_12_8","1CO","12","8","8","ጌሻ ኣያናይ ኢሱዋስ ጪንጫቴꬂ ኩሚዳ ቃላ ኢሜስ፤ ቃሲ ኢሱዋስ ኤራቴꬂ ኩሚዳ ቃላ ኢሜስ። ");
INSERT INTO gofENT_vpl VALUES ("C112_9","076_12_9","1CO","12","9","9","ሄ ጌሻ ኣያናይ ኢሱዋስ ኣማኖ፥ ሃንኩዋስ ቃሲ ፓꬂያ ዎልቃ ኢሜስ። ");
INSERT INTO gofENT_vpl VALUES ("C112_10","076_12_10","1CO","12","10","10","ጌሻ ኣያናይ ኢሱዋስ ማላታ ኦꬂያ ዎልቃ፥ ኢሱዋስ ቲንቢቴ ኦዲያ ዎልቃ ኢሜስ። ኢሱዋስ ኣያናፔ ኣያና ሻኪ ኤሪያ ዎልቃ፥ ኢሱዋስ ዱማ ዱማ ዶናን ኦዲያ ዎልቃ፥ ቃሲ ኢሱዋስ ዱማ ዱማ ዶናን ኦዴቲዳይሳ ቢርሺያ ዎልቃ ኢሜስ። ");
INSERT INTO gofENT_vpl VALUES ("C112_11","076_12_11","1CO","12","11","11","ሺን ሃ ኡባ ኦꬄይ ሄ ኢሲ ጌሻ ኣያና። ኢ ኮያ ሜላ ኢሲ ኢሲ ኣሳስ ዱማ ዱማ ኢሞታ ኢሜስ። ");
INSERT INTO gofENT_vpl VALUES ("C112_12","076_12_12","1CO","12","12","12","ኢሲ ኣሳቴꬃን ዳሮ ቢሊቴቲ ዴዖሶና፥ ሺን ሄ ዱማ ዱማ ቢሊቴቲ ኢሲ ኣሳቴꬂ ጊዶሶና። ሄሳዳካ፥ ኪሪስቶሲ ዱማ ዱማ ቢሊቴቲ ዴዒያ ኣሳቴꬃ ሜላ። ");
INSERT INTO gofENT_vpl VALUES ("C112_13","076_12_13","1CO","12","13","13","ኑኒ ኣይሁዴ ጊዲን ጊሪኬ ጊዲን ኣይሌ ጊዲን ዎማኖ ጊዲን፥ ኡባይ ኢሲ ኣሳቴꬂ ጊዳናው ጌሻ ኣያናን ፃማቄቲዳ። ቃሲ ኑ ኡባይ ኢሲ ጌሻ ኣያና ኤኪዳ። ");
INSERT INTO gofENT_vpl VALUES ("C112_14","076_12_14","1CO","12","14","14","ኑ ኣሳቴꬃን ዱማ ዱማ ቢሊቴቲ ዴዖሶናፔ ኣቲን ኢሲ ቢሊቴ ጊዴና። ");
INSERT INTO gofENT_vpl VALUES ("C112_15","076_12_15","1CO","12","15","15","ቶሆይ፥ «ታኒ ኩሼ ጊዶና ጊሾ ቢሊቴ ጊዲኬ» ጊኮ፥ ኢ ሄሳ ጊዳ ጊሾ ቢሊቴቴꬃይ ኣቲዬ? ");
INSERT INTO gofENT_vpl VALUES ("C112_16","076_12_16","1CO","12","16","16","ሃይꬂ፥ «ታኒ ኣይፌ ጊዶና ጊሾ ቢሊቴ ጊዲኬ» ጊኮ፥ ኢ ሄሳ ጊዳ ጊሾ ኣሳቴꬃፌ ኢሲ ቢሊቴ ጊዴይሲ ኣቲዬ? ");
INSERT INTO gofENT_vpl VALUES ("C112_17","076_12_17","1CO","12","17","17","ኣሳቴꬃ ኡባይ ኣይፌ ፃላላ ጊዲዳኮ፥ ኑ ኣይቢን ሲዓኔ? ቃሲ ኣሳቴꬂ ኡባይ ሃይꬃ ፃላላ ጊዲዳኮ ኑ ኣይቢን ሲንጋኔ? ");
INSERT INTO gofENT_vpl VALUES ("C112_18","076_12_18","1CO","12","18","18","ሺን ፆሳይ ባ ኮዪዳይሳዳ፥ ኣሳቴꬃ ጊዶን ዱማ ዱማ ቢሊቴታ ዎꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("C112_19","076_12_19","1CO","12","19","19","ኡባይ ኢሲ ቢሊቴ ጊዲዳኮ ኣሳቴꬂ ዋኒዲ ዳኔ? ");
INSERT INTO gofENT_vpl VALUES ("C112_20","076_12_20","1CO","12","20","20","ሺን ቢሊቴቲ ዳሮ ጊዲኮካ፥ ኣሳቴꬃይ ኢሶ። ");
INSERT INTO gofENT_vpl VALUES ("C112_21","076_12_21","1CO","12","21","21","ኣይፌይ ኩሼኮ፥ «ኔ ታው ኮሻካ» ጋናው ዳንዳዔና። ዎይኮ ሁዔይ ቶሆኮ፥ «ኔ ታው ኮሻካ» ጋናው ዳንዳዔና። ");
INSERT INTO gofENT_vpl VALUES ("C112_22","076_12_22","1CO","12","22","22","ሺን ዳቡራ ዳኒያ ኣሳቴꬃ ቢሊቴቲ ኑስ ኣꬊዲ ኮሾሶና። ");
INSERT INTO gofENT_vpl VALUES ("C112_23","076_12_23","1CO","12","23","23","ቦንቾ ኮሼና ጊዲ ኑ ቆፒያ ኑ ቢሊቴታፔ ባጋታ ዳሮ ቦንቾስ። ቃሲ ኑ ቦርሴቲያ ኑ ኣሳቴꬃ ቢሊቴታ ኣꬂ ቦንቺዲ ናጎስ። ");
INSERT INTO gofENT_vpl VALUES ("C112_24","076_12_24","1CO","12","24","24","ኑ ቤዒን ቦርሶና ኣሳቴꬃ ቢሊቴታስ ቦንቾ ኮሼና። ሺን ፆሳይ ኑ ኣሳቴꬃ ቢሊቴታ ዎሊራ ጋሴꬂዲ ቦርሲያ ቢሊቴታስ ኣꬊያ ቦንቾ ኢሚስ። ");
INSERT INTO gofENT_vpl VALUES ("C112_25","076_12_25","1CO","12","25","25","ኣሳቴꬃ ቢሊቴቲ ኢሶይ ኢሱዋራ ሻኮ ሜꬎና ዎሊስ ቆፓና ሜላ ኦꬂዲ ሜꬊስ። ");
INSERT INTO gofENT_vpl VALUES ("C112_26","076_12_26","1CO","12","26","26","ኣሳቴꬃ ቢሊቴታፔ ኢሶይ ሳኬቲኮ ቢሊቴቲ ኡባይ ኢያራ ሳኬቶሶና። ኣሳቴꬃ ቢሊቴታፔ ኢሶይ ቦንቼቲኮ ቢሊቴቲ ኡባይ ኢያራ ኡፋይቶሶና። ");
INSERT INTO gofENT_vpl VALUES ("C112_27","076_12_27","1CO","12","27","27","ሂንቴ ኡባይ ኪሪስቶሳ ኣሳቴꬂ፤ ቃሲ ሂንቴ ኢሶይ ኢሶይ ኢያ ቢሊቴታ። ");
INSERT INTO gofENT_vpl VALUES ("C112_28","076_12_28","1CO","12","28","28","ዎሳ ኬꬃን ፆሳይ፥ ኮይሮ ሃዋሬታ፥ ናምዓንꬆ ናቤታ፥ ሄꬓንꬆ ኣስታማሬታ፥ ካሊዲ ማላታ ኦꬄይሳታ፥ ፓꬄይሳታ፥ ሃራታ ማዴይሳታ፥ ዎሳ ኬꬃ ኣይሴይሳታኔ፥ ዱማ ዱማ ዶናን ሃሳዬይሳታ ዎꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("C112_29","076_12_29","1CO","12","29","29","ኡባይ ሃዋሬ? ኡባይ ናቤ? ኡባይ ኣስታማሬ? ኡባይ ማላታ ኦꬂ? ");
INSERT INTO gofENT_vpl VALUES ("C112_30","076_12_30","1CO","12","30","30","ኡባይ ፓꬂዬ? ኡባይ ዱማ ዱማ ዶናን ኦዴቲ? ኡባይ ዱማ ዱማ ዶናን ኦዴቶይሳ ቢርሺ? ");
INSERT INTO gofENT_vpl VALUES ("C112_31","076_12_31","1CO","12","31","31","ሺን ኡባፌ ኣꬊያ ኢሞታ ሚንꬂዲ ኮዪቴ። ቃሲ ኡባፌ ኣꬊያ ኦጊያ ታ ሂንቴና ቤሳና። ");
INSERT INTO gofENT_vpl VALUES ("C113_1","076_13_1","1CO","13","1","1","ታኒ ኣሳ ቃላኔ ኪታንቾ ቃላ ኦዴታናው ዳንዳዒኮካ፥ ታው ሲቆይ ꬋዪኮ፥ ጮ ጊሪያ ዳላ ሜላ። ");
INSERT INTO gofENT_vpl VALUES ("C113_2","076_13_2","1CO","13","2","2","ቲንቢቴ ኦዲያ ኢሞይ ታው ዴዒኮካ፥ ፁራ ኡባ ኤሪኮካ፥ ኤራቴꬂ ኡባይ ዴዒኮካ፥ ቃሲ ዴሪያ ዴንꬂዲ ሃራሶ ኤፊያ ኣማኖይ ታው ዴዒኮካ፥ ሲቆይ ꬋዪኮ፥ ታ ኣይኮካ ጊዲኬ። ");
INSERT INTO gofENT_vpl VALUES ("C113_3","076_13_3","1CO","13","3","3","ታው ዴዒያባ ኡባ ማንቆታስ ኢሚኮካ፥ ሃሪ ኣቶሺን፥ ታና ታማስ ኣꬃ ኢሚኮካ፥ ሲቆይ ꬋዪኮ ታና ኣይኮካ ማዴና። ");
INSERT INTO gofENT_vpl VALUES ("C113_4","076_13_4","1CO","13","4","4","ሲቆይ ዳንዳዓንቾ። ሲቆይ ኬሃ። ሲቆይ ቃናቴና። ሲቆይ ጬቄቴና። ሲቆይ ኦቶሬና። ");
INSERT INTO gofENT_vpl VALUES ("C113_5","076_13_5","1CO","13","5","5","ሲቆይ ቤሶናባ ኦꬄና። ሲቆይ ኡዜቴና። ሲቆይ ዪሎቴና። ሲቆይ ባ ቆሆ ፓይዴና። ");
INSERT INTO gofENT_vpl VALUES ("C113_6","076_13_6","1CO","13","6","6","ሲቆይ ቱማን ኡፋይቴሲፔ ኣቲን ዎርዶን ኡፋይቴና። ");
INSERT INTO gofENT_vpl VALUES ("C113_7","076_13_7","1CO","13","7","7","ሲቆይ ኡባ ዳንዳዔስ፤ ኡባ ኣማኔስ፤ ሎዖባይ ሃናና ጊዲ፥ ኡፋይሳን ናጌስ፤ ኡባ ጌንጬስ። ");
INSERT INTO gofENT_vpl VALUES ("C113_8","076_13_8","1CO","13","8","8","ሲቆይ ዉርሴꬂ ጋካናው ꬋዬና። ሺን ቲንቢቴይ ኣታና፤ ዱማ ዱማ ዶናን ኦዴቴይሲ ኣታና፤ ኤራቴꬂካ ኣꬋና። ");
INSERT INTO gofENT_vpl VALUES ("C113_9","076_13_9","1CO","13","9","9","ኑ ኤራቴꬃፌ ጉꬂ ኤሮስ፤ ቲንቢቲያፔ ባጋ ኦዶስ። ");
INSERT INTO gofENT_vpl VALUES ("C113_10","076_13_10","1CO","13","10","10","ሺን ፖሎ ጊዲዳይሲ ያ ዎዴ ፖሎ ጊዶናይሲ ኣታና። ");
INSERT INTO gofENT_vpl VALUES ("C113_11","076_13_11","1CO","13","11","11","ታኒ ናዓ ዴዒያ ዎዴ ናዓዳ ሃሳይስ፤ ናዓዳ ቆፓይስ፤ ናዓዳ ኣኬካይስ። ታ ካሃሚዳ ዎዴ ናዓቴꬃ ሃኑዋ ኣጋስ። ");
INSERT INTO gofENT_vpl VALUES ("C113_12","076_13_12","1CO","13","12","12","ሃዒ ፖዖይ ባይናሶን ማስቶቴን ቤዔይሳዳ ቤዖስ፥ ሺን ሄ ዎዴ ኑ ቆንጬን ቤዓና። ሃዒ ኑ ኤራቴꬃፌ ጉꬃ ኤሮስ፥ ሺን ሄ ዎዴ ፆሳይ ኑና ኤሬይሳዳ ፖሎ ኤራና። ");
INSERT INTO gofENT_vpl VALUES ("C113_13","076_13_13","1CO","13","13","13","ሂዛ፥ ኣማኖይ፥ ኡፋይሲኔ ሲቆይ፥ ሃ ሄꬓቲ ኤቂዲ ዳና። ሺን ሃይሳታፔ ኣꬌይ ሲቆ። ");
INSERT INTO gofENT_vpl VALUES ("C114_1","076_14_1","1CO","14","1","1","ሲቆ ካሊቴ። ኣያና ኢሞታታ ሚንꬂዲ ኮዪቴ፤ ኡባፌ ኣꬂዲ፥ ቲንቢቴ ኢሞታ ሚንꬂዲ ኮዪቴ። ");
INSERT INTO gofENT_vpl VALUES ("C114_2","076_14_2","1CO","14","2","2","ዱማ ዱማ ዶናን ኦዴቲያ ኣሲ ፆሳስ ኦዴሲፔ ኣቲን ኣሳስ ኦዴና። ሺን ኣሳስ ቆንጪቦና ፁራ ኣያና ዎልቃን ኦዴቲያ ጊሾ ኦኒካ ኢ ኦዴቴይሳ ኣኬኬና። ");
INSERT INTO gofENT_vpl VALUES ("C114_3","076_14_3","1CO","14","3","3","ሺን ቲንቢቴ ኦዴይሳቲ ኣሴ ዲቻናው፥ ሚንꬄꬃናዉኔ ሚንꬃናው ኣሳስ ኦዴስ። ");
INSERT INTO gofENT_vpl VALUES ("C114_4","076_14_4","1CO","14","4","4","ዱማ ዱማ ዶናን ኦዲያ ኣሲ ባና ዲቼስ። ሺን ቲንቢቴ ኦዲያ ኣሲ ዎሳ ኬꬃ ዲቼስ። ");
INSERT INTO gofENT_vpl VALUES ("C114_5","076_14_5","1CO","14","5","5","ሂንቴ ኡባይ ዱማ ዱማ ዶናን ኦዴቲያኮ ታ ዶሳይስ፥ ሺን ቲንቢቴ ኦዳናይሳ ኣꬃዳ ዶሳይስ። ዱማ ዱማ ዶናን ኦዴቴይሳ ዎሳ ኬꬂ ዲቻናው ቢርሺያ ኣሲ ꬋዪኮ፥ ዱማ ዱማ ዶና ኦዴቴያሳፌ ቲንቢቴ ኦዴይሲ ኣꬌስ። ");
INSERT INTO gofENT_vpl VALUES ("C114_6","076_14_6","1CO","14","6","6","ሺን ታ ኢሻቶ፥ ታኒ ሂንቴኮ ባዳ ቆንጬꬃን ዎይኮ ኤራቴꬃን ዎይኮ ቲንቢቴ ኦዶን ዎይኮ ቲሚርቴን ጊዶናሺን ዱማ ዱማ ዶናን ኦዴቲኮ ሂንቴና ኣይ ማዳኔ? ");
INSERT INTO gofENT_vpl VALUES ("C114_7","076_14_7","1CO","14","7","7","ዱማ ዱማ ዬꬃ ሚሼታስ ኢሲ ቆሞ ጊርሲ ዴዒኮ፥ ሱሱልዔ ጊርሲኔ ዲꬃ ጊርሲ ዋቲዲ ሻኪ ኤራኔ? ");
INSERT INTO gofENT_vpl VALUES ("C114_8","076_14_8","1CO","14","8","8","ቃሲ ሞይዜ ፑኖይ ጌዪዲ ኤሬቶና ኢፂኮ ኦላስ ጊጌቴይ ኦኔ? ");
INSERT INTO gofENT_vpl VALUES ("C114_9","076_14_9","1CO","14","9","9","ሄሳዳካ፥ ዱማ ዱማ ዶናን ሂንቴ ኦዴቴይሲ ቆንጬ ጊዶና ኢፂኮ ሂንቴ ኦዴይሳ ኦኒ ኤራኔ? ሄሲ ጫርኮስ ኦዲያ ሜላ። ");
INSERT INTO gofENT_vpl VALUES ("C114_10","076_14_10","1CO","14","10","10","ሃ ኣላሚያን ዳሮ ዶናቲ ዴዖሶና፤ ሄ ኡባስ ቢርሼꬂ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("C114_11","076_14_11","1CO","14","11","11","ሺን ኢሲ ኣሲ ኦዴቲያ ዶና ታኒ ኤሮና ኢፂኮ ኢ ታው ኢማꬄ ጊዴስ፤ ታካ ኢያው ኢማꬄ ጊዳይስ። ");
INSERT INTO gofENT_vpl VALUES ("C114_12","076_14_12","1CO","14","12","12","ሄሳዳካ፥ ጌሻ ኣያና ኢሞታ ሂንቴ ኤካናው ሚንꬂዲ ኮይኮ፥ ዎሳ ኬꬂ ዲቻናው ኡባፌ ኣꬊያ ኢሞታ ኮዪቴ። ");
INSERT INTO gofENT_vpl VALUES ("C114_13","076_14_13","1CO","14","13","13","ዱማ ዱማ ዶናን ኦዴቲያ ኣሲ ባ ኦዳ ቢርሻናው ቢርሼꬃ ኢሞታይ ኢሜታና ሜላ ፆሳ ዎሶ። ");
INSERT INTO gofENT_vpl VALUES ("C114_14","076_14_14","1CO","14","14","14","ታኒ ዱማ ዱማ ዶናን ፆሳ ዎሲኮ፥ ታ ኣያናይ ዎሴስ፥ ሺን ታ ዎዛናይ ኣይኮካ ጎዔቴና። ");
INSERT INTO gofENT_vpl VALUES ("C114_15","076_14_15","1CO","14","15","15","ያቲን፥ ታ ኣይ ኦꬃናው ኮሺ? ታኒ ታ ኣያናን ዎሳይስ፤ ታ ዎዛናንካ ዎሳይስ። ታኒ ታ ኣያናን ዬፃይስ፤ ታ ዎዛናንካ ዬፃይስ። ");
INSERT INTO gofENT_vpl VALUES ("C114_16","076_14_16","1CO","14","16","16","ሄሳ ጊዶና ኢፂኮ ኔኒ ኔ ኣያናን ፆሳ ጋላቲያ ዎዴ ሄ ቤሳን ኔኒ ጌይሳ ኤሮና ኣሲ ኔ ጋላቴይሳ ዎይጊዲ፥ «ኣሚንዒ» ጋኔ? ");
INSERT INTO gofENT_vpl VALUES ("C114_17","076_14_17","1CO","14","17","17","ኔኒ ፆሳ ጋላቴይሲ ሎዖ፥ ሺን ሃራ ኣሲ ማዴና። ");
INSERT INTO gofENT_vpl VALUES ("C114_18","076_14_18","1CO","14","18","18","ታ ሂንቴ ኡባፌ ኣꬃዳ ዱማ ዱማ ዶናን ኦዴቲያ ጊሾ ፆሳ ጋላታይስ። ");
INSERT INTO gofENT_vpl VALUES ("C114_19","076_14_19","1CO","14","19","19","ሺን ታኒ ዎሳ ኬꬃን ሃራታ ታማርሳናው ዱማ ዱማ ዶናን ታሙ ሙኩሉ ቃላ ኦዴታናፔ ኤሬቲያ ዶናን ኢቻሹ ቃላ ኦዴታናው ዶሳይስ። ");
INSERT INTO gofENT_vpl VALUES ("C114_20","076_14_20","1CO","14","20","20","ታ ኢሻቶ፥ ሂንቴ ቆፋን ናይታዳ ሃኖፒቴ። ሂንቴ ኢታባስ ናይታዳ ሃኒቴፔ ኣቲን ሂንቴ ቆፋን ካሃማታ ጊዲቴ። ");
INSERT INTO gofENT_vpl VALUES ("C114_21","076_14_21","1CO","14","21","21","ጎዳይ፥ ጌሻ ማፃፋን፥ «ታኒ ሃ ኣሳስ፥ ዱማ ዱማ ዶናን ኦዴቲያ ኣሳኒኔ ኢማꬃ ኢንፃርሳን ኦዴቲያ ኣሳን ኦዳና። ሺን ሄሲ ሃኒኒካ ታና ሲዖኮና» ያጌስ። ");
INSERT INTO gofENT_vpl VALUES ("C114_22","076_14_22","1CO","14","22","22","ሂዛ፥ ዱማ ዱማ ዶናን ሃሳዮይ፥ ኣማኖና ኣሳስ ማላ ጊዴሲፔ ኣቲን ኣማኒያ ኣሳሳ ጊዴና። ቲንቢቴይ ኣማኒያ ኣሳስ ማላ ጊዴሲፔ ኣቲን ኣማኖና ኣሳሳ ጊዴና። ");
INSERT INTO gofENT_vpl VALUES ("C114_23","076_14_23","1CO","14","23","23","ዎሳ ኬꬃ ኣሳይ ኢሲፌ ሺቂያ ዎዴ ኡባይ ዱማ ዱማ ዶናን ኦዴቲኮ ኤሮና ዎይኮ ኣማኖና ኣሳይ ሂንቴ ሺቁዋ ዪዲ፥ «ሃይሳቲ ጎዮሶና» ጎኮናዬ? ");
INSERT INTO gofENT_vpl VALUES ("C114_24","076_14_24","1CO","14","24","24","ሺን ኤሮና ዎይኮ ኣማኖና ኣሳይ ዎሳ ኬꬂ ያ ዎዴ ኣሳይ ቲንቢቴ ኦዲሺን፥ ሲዒኮ ባ ናጋራ ኣኬካና፤ ቃሲ ኢ ሲዒዳ ቃላን ፒርዴታና። ");
INSERT INTO gofENT_vpl VALUES ("C114_25","076_14_25","1CO","14","25","25","ኤንቲ ኢያ ዎዛናን ጌሚዳ ቆፋ ቆንጪሳና። ሄሳዳካ፥ «ቱማ ፆሳይ ሂንቴ ጊዶን ዴዔስ» ያጊዲ ማርካቲዲ፥ ጉፋኒዲ ፆሳስ ጎይናና። ");
INSERT INTO gofENT_vpl VALUES ("C114_26","076_14_26","1CO","14","26","26","ታ ኢሻቶ፥ ኑ ዎይጊኖ? ሂንቴ ኢሲፌ ሺቂያ ዎዴ ኢሱዋስ ማዝሙሬይ ዴዔስ፤ ኢሱዋስ ታማርሶ ኢሞቲ ዴዔስ፤ ኢሱዋስ ቆንጬꬂ ዴዔስ፤ ኢሱዋስ ዱማ ዱማ ዶናን ሃሳዮይ ዴዔስ፤ ኢሱዋስ ቢርሼꬃ ኢሞቲ ዴዔስ። ሄ ኡባይ ዎሳ ኬꬂ ዲቺያባ ጊዳናው ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("C114_27","076_14_27","1CO","14","27","27","ዱማ ዱማ ዶናን ኦዴቲያ ኣሳቲ ዴዒኮ፥ ናምዓ ዎይኮ ዳሪኮ ሄꬓ ጊዲዲ ማራን ማራን ሃሳያናው ቤሴስ። ኤንቲ ኦዴቴይሳ ሃራ ኣሲ ቢርሾ። ");
INSERT INTO gofENT_vpl VALUES ("C114_28","076_14_28","1CO","14","28","28","ሺን ቢርሺያ ኣሲ ꬋዪኮ፥ ዱማ ዱማ ዶናን ኦዴቴይሲ ዎሳ ኬꬃን ሲዒ ጎ። ባዉኔ ባ ፆሳስ ኦዶ። ");
INSERT INTO gofENT_vpl VALUES ("C114_29","076_14_29","1CO","14","29","29","ቲንቢቴ ኦዴይሳቲ ናምዓ ዎይኮ ሄꬓ ጊዲዲ ኦዶ። ቃሲ ሃራቲ ኤንቲ ጊያባ ፒርዶና። ");
INSERT INTO gofENT_vpl VALUES ("C114_30","076_14_30","1CO","14","30","30","ሄ ሺቁዋን ዴዒያ ሃራ ኣሳስ ኢሲባይ ቆንጪኮ ካሴ ኦዴቴይሲ ሲዒ ጎ። ");
INSERT INTO gofENT_vpl VALUES ("C114_31","076_14_31","1CO","14","31","31","ኡባይ ታማራና ሜላኔ ኡባይ ሚናና ሜላ ማራን ማራን ቲንቢቴ ኦዳናው ዳንዳዔታ። ");
INSERT INTO gofENT_vpl VALUES ("C114_32","076_14_32","1CO","14","32","32","ናቤታ ኣያናይ ናቤታስ ኪቴቴስ። ");
INSERT INTO gofENT_vpl VALUES ("C114_33","076_14_33","1CO","14","33","33","ጌሻታ ዎሳ ኬꬃ ኡባይ ሜዜቲዳይሳዳ ፆሳይ ሳሮቴꬃ ፆሳፌ ኣቲን ጫቦ ፆሲ ጊዴና። ");
INSERT INTO gofENT_vpl VALUES ("C114_34","076_14_34","1CO","14","34","34","ማጫሲ ዎሳ ኬꬃን ሲዒ ጎ። ሙሴ ሂጌይ ጌይሳዳ ኤንቲ ሃሬቶፌ ኣቲን ዎሳ ኬꬃን ኦዳናው ኤንታው ማቲ ባዋ። ");
INSERT INTO gofENT_vpl VALUES ("C114_35","076_14_35","1CO","14","35","35","ማጫሲ ዎሳ ኬꬃን ሃሳዮይ ቦርሶ ጊዲያ ጊሾ ኢሲባ ኤራናው ኮይኮ ሶን ባንታ ኣዚናታ ኦይቾና። ");
INSERT INTO gofENT_vpl VALUES ("C114_36","076_14_36","1CO","14","36","36","ፆሳ ቃላ ኮይሮ ሂንቴ ኤሂዴቲ? ዎይኮ ፆሳ ቃላይ ሂንቴ ፃላላኮ ዪዴ? ");
INSERT INTO gofENT_vpl VALUES ("C114_37","076_14_37","1CO","14","37","37","ኦኒካ ባና ናቤ ዎይኮ ባና ፆሳ ኣሲ ጊዲ ቆፒኮ፥ ታኒ ሂንቴው ፃፌይሲ ጎዳ ኪታ ጊዴይሳ ኣኬኮ። ");
INSERT INTO gofENT_vpl VALUES ("C114_38","076_14_38","1CO","14","38","38","ሺን ኦኒካ ኣኬኮና ኢፂኮ ኢካ ኣኬኬቶፎ። ");
INSERT INTO gofENT_vpl VALUES ("C114_39","076_14_39","1CO","14","39","39","ሄሳ ጊሾ፥ ታ ኢሻቶ፥ ቲንቢቴ ኦዳናው ሚንꬂዲ ኣሞቲቴ፤ ቃሲ ዱማ ዱማ ዶናን ኦዴቴይሳካ ዲጎፊቴ። ");
INSERT INTO gofENT_vpl VALUES ("C114_40","076_14_40","1CO","14","40","40","ሺን ኡባይካ ዎጋኒኔ ማራን ጊዶ። ");
INSERT INTO gofENT_vpl VALUES ("C115_1","076_15_1","1CO","15","1","1","ታ ኢሻቶ፥ ታ ሂንቴው ማርካቲዳ ዎንጌላ ሂንቴ ኤኪዳይሳኔ ሂንቴ ኣማኖይ ኢያን ኤቂዳይሳ ሂንቴ ኣኬካና ሜላ ኮያይስ። ");
INSERT INTO gofENT_vpl VALUES ("C115_2","076_15_2","1CO","15","2","2","ታ ታማርሲዳ ዎንጌላ ሚንꬂዲ ኦይኪኮ ሂንቴ ኢያን ኣታና። ሄሲ ሃኖና ኢፂኮ ሂንቴ ኣማናኦይ ሃዳ ጊዳና። ");
INSERT INTO gofENT_vpl VALUES ("C115_3","076_15_3","1CO","15","3","3","ታኒ ኤኪዳ ኡባፌ ኣꬊያ ኪታ ካሴታዳ ሂንቴው ኢማስ። ሄሲካ፥ ጌሻ ማፃፋይ ጌይሳዳ፥ ኪሪስቶሲ ኑ ናጋራ ጊሾ ሃይቂስ። ");
INSERT INTO gofENT_vpl VALUES ("C115_4","076_15_4","1CO","15","4","4","ሞጌቲስ፤ ጌሻ ማፃፋይ ጌይሳዳ፥ ሄꬓንꬆ ጋላሳን ሃይቆፔ ዴንዲስ። ");
INSERT INTO gofENT_vpl VALUES ("C115_5","076_15_5","1CO","15","5","5","ጴፂሮሳስ ቆንጪስ። ሄሳፌ ጉዬ፥ ታማኔ ናምዑ ሃዋሬታስ ቆንጪስ። ");
INSERT INTO gofENT_vpl VALUES ("C115_6","076_15_6","1CO","15","6","6","ሄሳፌ ጉዬ፥ ኢቻሹ ፄታፔ ዳሪያ ኣሳስ ኢሲ ቶሆ ቆንጪስ። ኤንታፌ ዳሪያ ባጋይ ሃዒ ጋካናው ፓፃ ዴዖሶና፥ ሺን ጉꬃቲ ሃይቂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("C115_7","076_15_7","1CO","15","7","7","ሄሳፌ ጉዬ፥ ያይቆባስ ቆንጪስ፤ ጉዬፔ ባ ሃዋሬታ ኡባስ ቆንጪስ። ");
INSERT INTO gofENT_vpl VALUES ("C115_8","076_15_8","1CO","15","8","8","ቃሲ ዉርሴꬃን ኣዉጫያ ሜላ ጊዲዳ ታው ቆንጪስ። ");
INSERT INTO gofENT_vpl VALUES ("C115_9","076_15_9","1CO","15","9","9","ታኒ ዬሱሳ ሃዋሬታ ኡባፌ ላፋ። ታኒ ፆሳ ዎሳ ኬꬃ ጎዲዳ ጊሾ ዬሱሳ ሃዋሬ ጌቴታዳ ፄጌታናው ቤሶናይሳ። ");
INSERT INTO gofENT_vpl VALUES ("C115_10","076_15_10","1CO","15","10","10","ሺን ፆሳ ኣꬎ ኬሃቴꬃን ታ ሃዒ ጊዲዳይሳ ጊዳስ፤ ኢ ታው ኢሚዳ ኣꬎ ኬሃቴꬃይ ሜላ ኣቲቤና። ታኒ ሃንኮ ሃዋሬታፔ ኣꬃዳ ዳቡራስ። ሺን ታራ ዴዒያ ፆሳ ኣꬎ ኬሃቴꬃይ ኦꬂስፔ ኣቲን ታና ጊዲኬ። ");
INSERT INTO gofENT_vpl VALUES ("C115_11","076_15_11","1CO","15","11","11","ሂዛ፥ ታና ጊዲን ኤንቲ፥ ኑ ኡባይ ታማርሴይ ሄሳ፤ ሂንቴካ ሄ ኪታ ኣማኒዴታ። ");
INSERT INTO gofENT_vpl VALUES ("C115_12","076_15_12","1CO","15","12","12","ኪሪስቶሲ ሃይቆፔ ዴንዲዳይሳ ኑ ሳባኪያ ዎዴ ሂንቴፌ ኢሶቲ ኢሶቲ ያቲን፥ ዎይጊዲ፥ «ሃይቆፔ ዴንዶይ ባዋ» ያጎና? ");
INSERT INTO gofENT_vpl VALUES ("C115_13","076_15_13","1CO","15","13","13","ሃይቆፔ ዴንዶይ ባይናባ ጊዲኮ ኪሪስቶሲ ሃይቆፔ ዴንዲቤና ጉሱ። ");
INSERT INTO gofENT_vpl VALUES ("C115_14","076_15_14","1CO","15","14","14","ኪሪስቶሲ ሃይቆፔ ዴንዲቦናባ ጊዲኮ ኑ ቲሚርቴይ ቃሲ ሂንቴ ኣማኖይካ ሃዳ። ");
INSERT INTO gofENT_vpl VALUES ("C115_15","076_15_15","1CO","15","15","15","ሃይቆፔ ዴንዶይ ባይናሺን፥ ኑኒ ፆሳይ፥ «ኪሪስቶሳ ሃይቆፔ ዴንꬂስ» ያጊዲ ሳባኪሼ ፆሳ ዎርዳንቾ ማርካታ ጊዲዳ ጉሱ። ");
INSERT INTO gofENT_vpl VALUES ("C115_16","076_15_16","1CO","15","16","16","ሃይቂዳ ኣሳይ ሃይቆፔ ዴንዲቦናባ ጊዲኮ ሂዛ፥ ኪሪስቶሲ ሃይቆፔ ዴንዲቤና። ");
INSERT INTO gofENT_vpl VALUES ("C115_17","076_15_17","1CO","15","17","17","ኪሪስቶሲ ሃይቆፔ ዴንዶናባ ጊዲኮ፥ ሂንቴ ኣማኖይ ሃዳ፤ ቃሲ ሂንቴ ሃዒ ጋካናው ሂንቴ ናጋራን ዴዔታ። ");
INSERT INTO gofENT_vpl VALUES ("C115_18","076_15_18","1CO","15","18","18","ሂዛ፥ ኪሪስቶሳ ኣማኒዲ ሃይቂዳይሳቲካ ꬋዪዶሶና ጉሱ። ");
INSERT INTO gofENT_vpl VALUES ("C115_19","076_15_19","1CO","15","19","19","ኑኒ ሃ ኣላሚያ ዴዑዋ ፃላላስ ኪሪስቶሳን ኡፋይሲ ኦꬂዳባ ጊዲኮ፥ ሃ ሳዓን ዴዒያ ኣሳ ኡባፌ ኑባይ ኣꬊዳ ዪባታ። ");
INSERT INTO gofENT_vpl VALUES ("C115_20","076_15_20","1CO","15","20","20","ሺን ኪሪስቶሲ ሃይቂዳይሳታስ ሃይቆፔ ዴንዶን ባይራ ጊዲዲ ቱማ ዴንዲስ። ");
INSERT INTO gofENT_vpl VALUES ("C115_21","076_15_21","1CO","15","21","21","ሃይቆይ ኢሲ ኣሳ ባጋራ ሃ ኣላሚያ ዪዳይሳዳ ሃይቆፔ ዴንዶይ ኢሲ ኣሳ ባጋራ ዪስ። ");
INSERT INTO gofENT_vpl VALUES ("C115_22","076_15_22","1CO","15","22","22","ኣዳሜ ባጋራ ኣሳ ኡባይ ሃይቂዳይሳዳ ኪሪስቶሳ ባጋራ ኣሳ ኡባይ ዴዖን ዳና። ");
INSERT INTO gofENT_vpl VALUES ("C115_23","076_15_23","1CO","15","23","23","ሺን ኢሶይ ኢሶይ ባ ማራን ማራን ዴንዳና። ኪሪስቶሲ ኡባፌ ካሴቲዲ ዴንዲስ፤ ሄሳፌ ጉዬ፥ ኪሪስቶሳይሳቲ ኢ ያ ዎዴ ዴንዳና። ");
INSERT INTO gofENT_vpl VALUES ("C115_24","076_15_24","1CO","15","24","24","ሄሳፌ ጉዬ፥ ኪሪስቶሲ ሃሬይሳ፥ ማታኔ ዎልቃ ኡባ ꬋይሲዲ፥ ካዎቴꬃ ፆሳ ኣዋስ ኢሚያ ዎዴ ዎዲያ ዉርሴꬃይ ያና። ");
INSERT INTO gofENT_vpl VALUES ("C115_25","076_15_25","1CO","15","25","25","ፆሳይ ኢያ ሞርኬታ ኡባ ኢያ ቶሁዋፔ ጋርሳን ዎꬃና ጋካናው ኪሪስቶሲ ሃራናው ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("C115_26","076_15_26","1CO","15","26","26","ዉርሴꬃን ኢ ꬋይሳናው ዴዒያ ሞርኬይ ሃይቆ። ");
INSERT INTO gofENT_vpl VALUES ("C115_27","076_15_27","1CO","15","27","27","ጌሻ ማፃፋን፥ «ፆሳይ ኡባባ ኢያ ማታፔ ጋርሳን ሃሪሲስ» ጌቴቲዲ ፃፌቲስ። ሺን ኡባ ኢያ ማታፔ ጋርሳን ሃሪሲስ ጌይሲ፥ ኡባባ ኢያ ማታፔ ጋርሳን ሃሪሲዳ ፆሳ ጉጄና። ");
INSERT INTO gofENT_vpl VALUES ("C115_28","076_15_28","1CO","15","28","28","ኡባባይ ኪሪስቶሳ ማታፔ ጋርሳን ሃሬቲዳፔ ጉዬ ኪሪስቶሲ ቃሲ ባ ሁዔን ኡባባ ባው ሃሪሲዳ ፆሳስ ሃሬታና። ሄ ዎዴ ፆሳይ ባ ፃላላ ኡባ ሃራና። ");
INSERT INTO gofENT_vpl VALUES ("C115_29","076_15_29","1CO","15","29","29","ሃይቂዳይሳቲ ዴንዶናባ ጊዲኮ ኤንታ ጊሾ ኣሳስ ኣይቢ ዎꬌይ ዴዒ? ሃይቂዳይሳቲ ዴንዶናባ ጊዲኮ ያቲን፥ ኣይስ፥ ኣሳይ ሃይቂዳይሳታ ጊሾ ፃማቄቶና? ");
INSERT INTO gofENT_vpl VALUES ("C115_30","076_15_30","1CO","15","30","30","ያቲን፥ ኑኒ ኣይስ ኡባ ዎዴ ኑናቴꬃ ሜቶስ ኣꬂ ኢሞና? ");
INSERT INTO gofENT_vpl VALUES ("C115_31","076_15_31","1CO","15","31","31","ታ ኢሻቶ፥ ታ ጋላስ ጋላስ ሃይቆስ ኣꬋዳ ኢሜታይስ። ሄሲካ፥ ጎዳ ኪሪስቶስ ዬሱሳን ዴዒያ ዴዑዋ ኢሲፌቴꬃን ሂንቴናን ጬቂያ ጊሾሳ። ");
INSERT INTO gofENT_vpl VALUES ("C115_32","076_15_32","1CO","15","32","32","ኣሳ ቆፋꬆ ጊዲኮ፥ ታኒ ኤፌሶናን ዶዓራ ቡቴቲዳይሲ ታና ኣይ ማዲ? ሃይቂዳይሳቲ ሃይቆፔ ዴንዶናባ ጊዲኮ፥ «ዎንቶ ኑ ሃይቂያ ጊሾ ሃቺ ማና ኡያና» ያጊያ ኣሳ ሜላ ጊዶስ። ");
INSERT INTO gofENT_vpl VALUES ("C115_33","076_15_33","1CO","15","33","33","ጪሜቶፊቴ! ኢታ ላጌቴꬂ ሎዖ ኣማሊያ ኢሴስ። ");
INSERT INTO gofENT_vpl VALUES ("C115_34","076_15_34","1CO","15","34","34","ሂንቴ ኣኬካኮ ሲሚቴ። ናጋራ ኦꬆፊቴ። ሂንቴፌ ኢሲ ኢሲ ኣሳይ ፆሳ ኤሮኮና። ታኒ ሂንቴና ዬላያናው ሄሳ ጋይስ። ");
INSERT INTO gofENT_vpl VALUES ("C115_35","076_15_35","1CO","15","35","35","ኢሲ ኣሲ፥ «ሃይቂዳ ኣሳይ ዋኒዲ ዴንዳኔ? ኤንቲ ኣይ ሜላ ኣሳቴꬃራ ያኔ?» ያጎና ኣጌና። ");
INSERT INTO gofENT_vpl VALUES ("C115_36","076_15_36","1CO","15","36","36","ኔኖ ኤያው፥ ኔኒ ቢታን ዜሪያ ዜሬꬃይ ሃይቆና ዶሌና። ");
INSERT INTO gofENT_vpl VALUES ("C115_37","076_15_37","1CO","15","37","37","ኔኒ ዜሬይ ጊስቴ ጊዲን ዎይኮ ሃራ ካꬃ ቆሞ ኣይፌ ፃላላ ዜራሳፔ ኣቲን ዶሊዳ ዶላ ጊዴና። ");
INSERT INTO gofENT_vpl VALUES ("C115_38","076_15_38","1CO","15","38","38","ሺን ፆሳይ ዜሬꬃስ ባ ዶሲዳ ሜላ ሜꬌቴꬂ ኢሜስ። ዱማ ዱማ ዜሬꬃስ ዱማ ዱማ ኣሳቴꬂ ኢሜስ። ");
INSERT INTO gofENT_vpl VALUES ("C115_39","076_15_39","1CO","15","39","39","ሜꬌቴꬃ ኡባ ኣሾይ ኢሶ ጊዴና። ሺን ኣሳ ኣሾይ ኢሱዋ፤ ሜሄ ኣሾይ ዱማ፤ ካፎታ ኣሾይ ዱማ፤ ቃሲ ሞሎ ኣሾይ ዱማ። ");
INSERT INTO gofENT_vpl VALUES ("C115_40","076_15_40","1CO","15","40","40","ሳሎ ኣሳቴꬂ ዴዔስ፤ ቃሲ ሳዓ ኣሳቴꬂ ዴዔስ። ሺን ሳሎ ኣሳቴꬃ ቦንቾይ ዱማ፤ ቃሲ ሳዓ ኣሳቴꬃ ቦንቾይ ዱማ። ");
INSERT INTO gofENT_vpl VALUES ("C115_41","076_15_41","1CO","15","41","41","ኣዋ ቦንቾይ ዱማ፤ ኣጌና ቦንቾይ ዱማ፤ ፆሊንቶታ ቦንቾይ ዱማ፤ ኢሲ ፆሊንቶይ ሃንኮ ፆሊንቱዋፌ ቦንቾን ዱማቴስ። ");
INSERT INTO gofENT_vpl VALUES ("C115_42","076_15_42","1CO","15","42","42","ሃይቂዳይሳቲ ሃይቆፔ ዴንዲያ ዎዴ ሄሳዳ ሃናና። ሃይቂያ ኣሳቴꬃይ ዜሬቴስ፤ ሃይቆና ኣሳቴꬂ ጊዲዲ ዴንዴስ። ");
INSERT INTO gofENT_vpl VALUES ("C115_43","076_15_43","1CO","15","43","43","ቶሼን ዜሬቲዲ፥ ቦንቾን ዴንዳና፤ ዳቡራን ዜሬቲዲ፥ ዎልቃን ዴንዳና። ");
INSERT INTO gofENT_vpl VALUES ("C115_44","076_15_44","1CO","15","44","44","ሜꬌቴꬃ ኣሳቴꬃይ ዜሬቲዲ፥ ኣያና ኣሳቴꬂ ጊዲዲ ዴንዳና። ሜꬌታ ኣሳቴꬂ ዴዒኮ፥ ኣያና ኣሳቴꬂ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("C115_45","076_15_45","1CO","15","45","45","ሄሳዳካ፥ ጌሻ ማፃፋን፥ «ኮይሮ ኣዴይ፥ ኣዳሜይ፥ ፓፃ ዴዒያ ኣሴ ጊዲዲ ሜꬌቲስ» ያጌስ። ሺን ዉርሴꬃ ኣዳሜይ፥ ኪሪስቶሲ፥ ዴዖ ኢሚያ ኣያና ጊዲስ። ");
INSERT INTO gofENT_vpl VALUES ("C115_46","076_15_46","1CO","15","46","46","ሺን ሜꬌታ ኣሲ ኮይሮ ዪን፥ ጉዬፔ ኣያና ኣሲ ዪሲፔ ኣቲን ኣያና ኣሲ ኮይሮ ዪቤና። ");
INSERT INTO gofENT_vpl VALUES ("C115_47","076_15_47","1CO","15","47","47","ኮይሮ ኣዳሜይ ቢታፌ ሜꬌቲዳ ቢታ ኣሲ፤ ናምዓንꬆ ኣዳሜይ ሳሎፔ ዪዳ ሳሎ ኣሲ። ");
INSERT INTO gofENT_vpl VALUES ("C115_48","076_15_48","1CO","15","48","48","ቢታፌ ሜꬌቲዳይሳቲ ቢታፌ ሜꬌቲዳይሳ ዳኖሶና። ሳሎይሳቲ ሳሎፔ ዪዳይሳ ዳኖሶና። ");
INSERT INTO gofENT_vpl VALUES ("C115_49","076_15_49","1CO","15","49","49","ኑኒ ቢታፌ ሜꬌቲዳ ኣዲያ ዳኔይሳ ሜላ ሳሎፔ ዪዳ ኣዲያ ዳናና። ");
INSERT INTO gofENT_vpl VALUES ("C115_50","076_15_50","1CO","15","50","50","ታ ኢሻቶ፥ ታ ጌይሲ ሄሳ፤ ሃዒ ኑ ማዒዳ ኣሳቴꬃይ ፆሳ ካዎቴꬃ ላታናው ዳንዳዔና። ዎቂያ ኣሳቴꬃይ ዎቆና ኣሳቴꬃ ላቴና። ");
INSERT INTO gofENT_vpl VALUES ("C115_51","076_15_51","1CO","15","51","51","ታ ሂንቴው ኢሲ ፁራ ኦዳና። ኑ ኡባይ ሃይቆኮ፥ ሺን ዉርሴꬃን ኡባይ ላሜታና። ");
INSERT INTO gofENT_vpl VALUES ("C115_52","076_15_52","1CO","15","52","52","ሞይዜይ ፑኔቲያ ዎዴ ኣይፌይ ቂጲ ፄላናው ሃሳዮና ላሜታና። ሃይቂዳ ኣሳይ ዎቆና ኣሲ ጊዲዲ ዴንዳና፤ ኑካ ላሜታና። ");
INSERT INTO gofENT_vpl VALUES ("C115_53","076_15_53","1CO","15","53","53","ሃይሲ ዎቄይሲ ዎቆናይሳ፥ ሃይሲ ሃይቄይሲ ሃይቆናይሳ ማዓናው ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("C115_54","076_15_54","1CO","15","54","54","ሃይሲ ዎቄይሲ ዎቆናይሳ፥ ቃሲ ሃይሲ ሃይቄይሲ ሃይቆናይሳ ማዒያ ዎዴ ጌሻ ማፃፋን፥ «ሃይቆይ ፆኖን ሚቴቲስ» ጊያ ቃላይ ፖሌታና። ");
INSERT INTO gofENT_vpl VALUES ("C115_55","076_15_55","1CO","15","55","55","ሄሳዳካ፥ «ሃይቆ፥ ኔ ፆኖይ ኣዉን ዴዒ? ሃይቆ፥ ኔ ቆሂያ ዎልቃይ ኣዉን ዴዒ?» ጊዳ ቃላይ ፖሌታና። ");
INSERT INTO gofENT_vpl VALUES ("C115_56","076_15_56","1CO","15","56","56","ሃይቆይ ዱኪያ ዎልቃይ ናጋራ፤ ቃሲ ናጋራ ዎልቃይ ሂጌ። ");
INSERT INTO gofENT_vpl VALUES ("C115_57","076_15_57","1CO","15","57","57","ሺን ኑ ጎዳ ዬሱስ ኪሪስቶሳ ባጋራ ኑስ ፆኖ ኢሚያ ፆሳ ጋላቲ ጋኮ። ");
INSERT INTO gofENT_vpl VALUES ("C115_58","076_15_58","1CO","15","58","58","ሄሳ ጊሾ፥ ታ ሲቆ ኢሻቶ፥ ቃፆና ሚኒዲ ኤቂቴ። ጎዳ ኦሱዋን ሂንቴ ዳቡሬይሲ ጮ ጊዶናይሳ ኤሪዲ ኡባ ዎዴ ጎዳ ኦሱዋ ኣዛሎና ኦꬂቴ። ");
INSERT INTO gofENT_vpl VALUES ("C116_1","076_16_1","1CO","16","1","1","ኣማኒያ ኣሳስ ሚሼ ሺሾባ ጋላቲያ ዎሳ ኬꬃታስ ታኒ ኪቲዳይሳዳ ሂንቴካ ኦꬂቴ። ");
INSERT INTO gofENT_vpl VALUES ("C116_2","076_16_2","1CO","16","2","2","ሚሺያ ሺሾይ ታ ሂንቴኮ ቢያ ዎዴ ጊዶና ሜላ ኢሶይ ኢሶይ ሳሚንታፌ ኮይሮ ጋላስ፥ ዎጋ ዎዴ ዎጋ ዎዴ ባ ዴሜይሳፌ ኬሲዲ ባ ሶን ዳጋዮ። ");
INSERT INTO gofENT_vpl VALUES ("C116_3","076_16_3","1CO","16","3","3","ታኒ ያ ቢዳ ዎዴ ሚሺያ ዬሩሳላሜ ጋꬃና ሜላ ሂንቴ ዶሪያ ኣሳስ ዳብዳቤ ኢማዳ ኤንታ ዬሩሳላሜ ኪታና። ");
INSERT INTO gofENT_vpl VALUES ("C116_4","076_16_4","1CO","16","4","4","ኤንታራ ታ ቡሳይ ኮሺያባ ጊዲኮ ኤንቲ ታራ ባናው ዳንዳዖሶና። ");
INSERT INTO gofENT_vpl VALUES ("C116_5","076_16_5","1CO","16","5","5","ታኒ ማቄዶኒያራ ኣꬋናው ቆፒዳ ጊሾ ያ ባዳ ሂንቴኮ ያና። ");
INSERT INTO gofENT_vpl VALUES ("C116_6","076_16_6","1CO","16","6","6","ታ ቢያሶ ኣው ጊዲኮካ፥ ታ ቡሳን ሂንቴ ታና ማዳና ሜላ ሂንቴ ማታን ጉꬃ ዎዴ ጋምዖና ኣጊኬ። ባልጎ ኣጌናታ ሂንቴ ማታን ኣꬆና ዋያ ኣጋና። ");
INSERT INTO gofENT_vpl VALUES ("C116_7","076_16_7","1CO","16","7","7","ታኒ ኦጌራ ኣꬋሼ ሂንቴና ቤዓናው ኮዪኬ። ጎዳይ ጊኮ፥ ሂንቴ ማታን ጉꬃ ዎዴ ታካናው ቆፓይስ። ");
INSERT INTO gofENT_vpl VALUES ("C116_8","076_16_8","1CO","16","8","8","ሺን ታኒ ጴንፄቆስፄ ባሌይ ጋካናው ኤፌሶናን ጋምዓና። ");
INSERT INTO gofENT_vpl VALUES ("C116_9","076_16_9","1CO","16","9","9","ታው ኦሶይ ኩሚዳ ዳልጋ ፔንጌይ ዶዬቲስ፥ ሺን ዳሮ ኤቄቲያ ሞርኬቲ ዴዖሶና። ");
INSERT INTO gofENT_vpl VALUES ("C116_10","076_16_10","1CO","16","10","10","ኢ ታ ሜላ ጎዳ ኦሶ ኦꬂያ ኣሲ ጊዲያ ጊሾ ፂሞቲዮሲ ሂንቴኮ ቢኮ፥ ሂንቴ ማታን ኢ ሂርጎና ዳና ሜላ ኦꬂቴ። ");
INSERT INTO gofENT_vpl VALUES ("C116_11","076_16_11","1CO","16","11","11","ኦኒካ ኢያ ካꬎፖ። ኢ ታኮ ሳሮ ሲማና ሜላ ኢያ ማዲዲ ሞይዚቴ። ታኒ ኢ ሃንኮ ኣማኔይሳታራ ሲማናይሳ ናጋይስ። ");
INSERT INTO gofENT_vpl VALUES ("C116_12","076_16_12","1CO","16","12","12","ኑ ኢሻ ኣጲሎሲ ሃንኮ ኣማኔይሳታራ ሂንቴኮ ባና ሜላ ታ ኢያ ሚንꬃ ዎሳስ። ሃዒ ሂንቴኮ ባናው ኮዪቤና፥ ሺን ኢያው ኢንጄቲያ ዎዴ ሂንቴኮ ባና። ");
INSERT INTO gofENT_vpl VALUES ("C116_13","076_16_13","1CO","16","13","13","ባርኪቴ፤ ኣማኖን ኤቂቴ፤ ፃሊቴ፤ ሚኒቴ። ");
INSERT INTO gofENT_vpl VALUES ("C116_14","076_16_14","1CO","16","14","14","ኦሶ ኡባ ሲቆን ኦꬂቴ። ");
INSERT INTO gofENT_vpl VALUES ("C116_15","076_16_15","1CO","16","15","15","ታ ኢሻቶ፥ ኢስፂፋኖሴይኔ ኢያ ሶ ኣሳይ ኣካያን ኤንቲ ኮይሮ ኣማኒዳይሳታ ጊዴይሳኔ ኣማኔይሳታ ማዳናው ባንታና ኣꬂ ኢሚዳይሳ ሂንቴ ኤሬታ። ");
INSERT INTO gofENT_vpl VALUES ("C116_16","076_16_16","1CO","16","16","16","ሂንቴካ ኤንታ ሜላ ኣሳሲኔ፥ ኤንታራ ኦሶን ዳቡሪያ ኡባስ ኪቴታና ሜላ ታ ሂንቴና ዎሳይስ። ");
INSERT INTO gofENT_vpl VALUES ("C116_17","076_16_17","1CO","16","17","17","ኢስፂፋኖሴይ፥ ፎርቹናሲኔ ኣካይቆሲ ታኮ ዪዳይሲ ታና ኡፋይሲስ። ሂንቴ ባይና ቤሳን ኤንቲ ሂንቴና ጊዲዲ ታ ፓጫ ኩንꬂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("C116_18","076_16_18","1CO","16","18","18","ኤንቲ ሂንቴና ኡፋይሲዳይሳዳ ታናካ ኡፋይሲዶሶና። ሄሳ ሜላ ኣሳታ ዶጎፒቴ። ");
INSERT INTO gofENT_vpl VALUES ("C116_19","076_16_19","1CO","16","19","19","ኢሲያ ዎሳ ኬꬃ ኣሳይ ሂንቴና ሳሮ ጎሶና። ኣቂሊኔ ጲሪስቂላ ባንታ ሶን ሺቂያ ዎሳ ኬꬃ ኣሳራ ኢሲፌ ሂንቴና ጎዳ ሱንꬃን ዎዛናፔ ሳሮꬆሶና። ");
INSERT INTO gofENT_vpl VALUES ("C116_20","076_16_20","1CO","16","20","20","ኣማኒያ ኢሻቲ ኡባይ ሂንቴና ሳሮ ያጎሶና። ጌሻ ዬሬቴꬂ ዬሬቲሼ ኢሶይ ኢሱዋ ሳሮꬂቴ። ");
INSERT INTO gofENT_vpl VALUES ("C116_21","076_16_21","1CO","16","21","21","ታኒ፥ ጳዉሎሲ፥ ሃ ሳሮꬁዋ ታ ኩሼን ፃፋስ። ");
INSERT INTO gofENT_vpl VALUES ("C116_22","076_16_22","1CO","16","22","22","ጎዳ ዶሶና ኣሲ ዴዒኮ፥ ቃንጌቲዳይሳ ጊዶ። ኑ ጎዳው፥ ሃያ! ");
INSERT INTO gofENT_vpl VALUES ("C116_23","076_16_23","1CO","16","23","23","ጎዳ ዬሱስ ኪሪስቶሳ ኣꬎ ኬሃቴꬃይ ሂንቴራ ጊዶ። ");
INSERT INTO gofENT_vpl VALUES ("C116_24","076_16_24","1CO","16","24","24","ታ ሲቆይ ኪሪስቶስ ዬሱሳን ዴዒያ ሂንቴ ኡባራ ጊዶ። ኣሚንዒ። ");
INSERT INTO gofENT_vpl VALUES ("C21_1","077_1_1","2CO","1","1","1","ፆሳ ሼኔን ዬሱስ ኪሪስቶሳ ሃዋሬ ጊዲዳ ጳዉሎሲኔ፥ ኑ ኢሻ ፂሞቲዮሲ፥ ቆሮንቶሳን ዴዒያ ፆሳ ዎሳ ኬꬃሲኔ ኣካያ ቢታን ዴዒያ ፆሳ ኣሳ ኡባስ ፃፊዳ ኪታ። ");
INSERT INTO gofENT_vpl VALUES ("C21_2","077_1_2","2CO","1","2","2","ፆሳ ኑ ኣዋፔኔ ጎዳ ዬሱስ ኪሪስቶሳፔ፥ ኣꬎ ኬሃቴꬃይኔ ሳሮቴꬃይ ሂንቴው ጊዶ። ");
INSERT INTO gofENT_vpl VALUES ("C21_3","077_1_3","2CO","1","3","3","ማሮቴꬃ ኣዋስ፥ ኡባ ዎዴ ኑና ሚንꬄꬂያ ፆሳስ፥ ኑ ጎዳ ዬሱስ ኪሪስቶሳ ኣዋስ ጋላቲ ጊዶ። ");
INSERT INTO gofENT_vpl VALUES ("C21_4","077_1_4","2CO","1","4","4","ፆሳይ ኑስ ኢሚዳ ሚንꬄꬁዋን፥ ሜቶን ዴዔይሳታ ኑ ሚንꬄꬃና ሜላ ፆሳይ ኑና ኑ ሜቶ ኡባን ሚንꬄꬄስ። ");
INSERT INTO gofENT_vpl VALUES ("C21_5","077_1_5","2CO","1","5","5","ኑኒ ኪሪስቶሳ ዳሮ ዋያ ሻኬቲዳይሳዳ ቃሲ ኑኒ ኢያ ዳሮ ሚንꬄꬁዋን ሚናና። ");
INSERT INTO gofENT_vpl VALUES ("C21_6","077_1_6","2CO","1","6","6","ኑኒ ዋዬቲኮ ሄሲ ሂንቴና ሚንꬄꬃናሳኔ ሂንቴና ኣሻናሳ። ቃሲ ኑኒ ሚኔቲኮ ኑኒ ጌንጪዳ ዋያ ሜላ ሂንቴካ ጌንጪዲ፥ ፆሳይ ሂንቴው ኢሚያ ሚንꬄꬁዋን ሚናና። ");
INSERT INTO gofENT_vpl VALUES ("C21_7","077_1_7","2CO","1","7","7","ሂንቴ ኑ ኤኪዳ ሜቱዋ ሜላ ኤኪዲ፥ ኑ ሚንꬄꬁዋን ሻኬታናይሳ ኑ ኤሪያ ጊሾ ኑ ኡፋይሳይ ሂንቴናን ሚኖ። ");
INSERT INTO gofENT_vpl VALUES ("C21_8","077_1_8","2CO","1","8","8","ኑ ኢሻቶ፥ ኢሲያ ቢታን ኑና ጋኪዳ ሜቱዋ ሂንቴ ኤራና ሜላ ኮዮስ። ሄ ኑና ጋኪዳ ሜቶይ ኑ ዎልቃፌ ዳሪን፥ ሃይቆና ኣቶኮ ጊዲ ኡፋይሲ ቃንፂዳሺን። ");
INSERT INTO gofENT_vpl VALUES ("C21_9","077_1_9","2CO","1","9","9","ኑኒ ኑ ቦላ ሃይቆ ፒርዲ ፒርዴቲዳ ሜላ ቆፒዳ። ሺን ኑኒ ኑ ሁዔን ጊዶናሺን፥ ሃይቂዳይሳታ ዴንꬂያ ፆሳን ኣማኔታና ሜላ ሄሲ ሃኒስ። ");
INSERT INTO gofENT_vpl VALUES ("C21_10","077_1_10","2CO","1","10","10","ፆሳይ ሄሳ ሜላ ኢታ ሃይቆፔ ኑና ኣሺስ፤ ሃዒካ ኣሻና፤ ሲንꬃፌካ ኢ ኑና ኣሻና ጊዲ ኢያን ኡፋይሲ ዎꬆስ። ");
INSERT INTO gofENT_vpl VALUES ("C21_11","077_1_11","2CO","1","11","11","ዎሳን ኑና ማዲቴ። ዳሮ ዎሳ ጋሶን ፆሳ ማዱዋ ኑ ዴሚያ ዎዴ ዳሮ ኣሳይ ኑ ጊሾ ፆሳ ጋላቶሶና። ");
INSERT INTO gofENT_vpl VALUES ("C21_12","077_1_12","2CO","1","12","12","ኑኒ ኑ ጌሻ ካሃን ጬቄቶስ። ኑኒ ሃ ኣላሚያን ዴዒዳ ዴዑዋን ኡባራካ ኑ ዴዒዳ ዴዑዋን ቱማቴꬃኒኔ ሱሬቴꬃን ሂንቴራ ዴዒዳ። ሄሲካ፥ ሃ ኣላሚያ ጪንጫቴꬃን ጊዶናሺን ፆሳ ኣꬎ ኬሃቴꬃና። ");
INSERT INTO gofENT_vpl VALUES ("C21_13","077_1_13","2CO","1","13","13","ኑ ሂንቴው ፃፊዳ ዳብዳቤይ ሂንቴ ናባባናዉኔ ኣኬካናው ዳንዳዒያባፔ ኣቲን ሃራ ጊዴና። ሂንቴ ኢያ ኣኬካናው ዳንዳዔይሳ ታ ኣማናይስ። ");
INSERT INTO gofENT_vpl VALUES ("C21_14","077_1_14","2CO","1","14","14","ሃዒ ሂንቴ ኑና ሃኒዳ ኬና ኤሬታ፥ ሺን ሲንꬃፌ ኩሜꬂ ኤራናይሳ ታ ኣማኔታይስ። ኑ ጎዳ ዬሱሲ ሲሚያ ዎዴ ኑኒ ሂንቴናን ጬቄቲዳይሳዳ ሂንቴካ ኑናን ጬቄታና። ");
INSERT INTO gofENT_vpl VALUES ("C21_15","077_1_15","2CO","1","15","15","ሄሳ ታኒ ሎይꬃ ኤሪዳ ጊሾ ሂንቴ ናምዓንꬆ ጎዔታና ሜላ ካሴታዳ ሂንቴኮ ባናው ቆፋ ቃቻስ። ");
INSERT INTO gofENT_vpl VALUES ("C21_16","077_1_16","2CO","1","16","16","ታኒ ማቄዶኒያ ባሼኔ ያፔ ሲማሼ ሂንቴና ቤዓና። ታኒ ያፔ ዪሁዳ ቢያ ዎዴ ሂንቴ ታና ታ ኦጊያን ማዳና ጋዳ ቆፓስ። ");
INSERT INTO gofENT_vpl VALUES ("C21_17","077_1_17","2CO","1","17","17","ታኒ ሄሳ ጋሼ ኣይ ኦꬃናው ቤሲያኮ ኤሮና ኣሲ ዳናይና? ዎይኮ ታኒ ታ ቆፋ ቃቺያ ዎዴ ኣሳ ቆፋዳ፥ ኢሲ ቶሆ «ኤ» ቃሲ ኢሲ ቶሆ «ኣካይ» ጊያ ኣሳ ሜሌዬ? ");
INSERT INTO gofENT_vpl VALUES ("C21_18","077_1_18","2CO","1","18","18","ሺን ፆሳይ ኣማኔቴይሳ ጊዲያ ጊሾ ኑ ሂንቴው ኦዲያ ቃላይ «ኤ» ዎይኮ «ኣካይ» ጌይሳ ጊዴና። ");
INSERT INTO gofENT_vpl VALUES ("C21_19","077_1_19","2CO","1","19","19","ታኒ፥ ሲላሴይኔ ፂሞቲዮሲ ሂንቴው ማርካቲዳ ፆሳ ናዓይ፥ ዬሱስ ኪሪስቶሲ ኡባ ዎዴ «ኤፔ» ኣቲን «ኤ» ኔ «ኣካይ» ጊዴና። ");
INSERT INTO gofENT_vpl VALUES ("C21_20","077_1_20","2CO","1","20","20","ፆሳይ ኢማና ጊዳ ኡባይ ኪሪስቶሳ ባጋራ «ኤ» ጊዴስ። ኑኒ ኪሪስቶሳ ባጋራ ፆሳ ቦንቾስ፥ «ኣሚንዒ» ጌይ ሄሳ ጊሾሳ። ");
INSERT INTO gofENT_vpl VALUES ("C21_21","077_1_21","2CO","1","21","21","ኑኔ ሂንቴ ኪሪስቶሳን ሚኒዲ ኤቃና ሜላ ኦꬂዳይኔ ባ ኦሱዋስ ዶሪዳይ ፆሳ። ");
INSERT INTO gofENT_vpl VALUES ("C21_22","077_1_22","2CO","1","22","22","ኑኒ ኢያባ ጊዴይሳ ኤሪሳናው ባ ማታሚያ ኑ ቦላ ዎꬂስ፤ ቃሲ ባ ጌሻ ኣያና ኦይꬂ ኦꬂዲ ኑ ዎዛናን ዎꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("C21_23","077_1_23","2CO","1","23","23","ታኒ ቆሮንቶሳ ቦና ኣጊዳይ ሂንቴ ኣዛኖና ኣታና ሜላሳ፤ ሄሲ ዎርዶ ጊዲኮ ፆሳይ ታ ሼምፑዋ ታፔ ኤኮ። ");
INSERT INTO gofENT_vpl VALUES ("C21_24","077_1_24","2CO","1","24","24","ሂንቴ፥ ሂንቴ ኣማኑዋን ሚኒዲ ዴዒያ ጊሾ ኑ ሂንቴና ኡፋይሳናው ሂንቴራ ኢሲፌ ኦꬄይሳታፔ ኣቲን ሂንቴና ዎልቃን ኣማንꬄይሳታ ጊዶኮ። ");
INSERT INTO gofENT_vpl VALUES ("C22_1","077_2_1","2CO","2","1","1","ታኒ ናምዓንꬆ ሂንቴኮ ቢኬ ጋዳ ቆፋ ቃቺዳይ ሂንቴና ኣዛንꬆና ኣጋናሳ። ");
INSERT INTO gofENT_vpl VALUES ("C22_2","077_2_2","2CO","2","2","2","ታኒ ሂንቴና ኣዛንꬂኮካ ታ ኣዛንꬂዳ ሂንቴፌ ሃሪ ታና ኡፋይሳናው ዴዔይ ኦኔ? ");
INSERT INTO gofENT_vpl VALUES ("C22_3","077_2_3","2CO","2","3","3","ታኒ ሂንቴው ሄ ዳብዳቢያ ፃፊዳይ፥ ታ ሂንቴና ቤዓናው ቢያ ዎዴ ታና ኡፋይሳናው ቤሲያ ኣሳን ታ ኣዛናናው ኮዮና ጊሾሳ። ታ ኡፋይቲያ ዎዴ ሂንቴ ኡባይካ ኡፋይታናይሳ ታ ኣማናይስ። ");
INSERT INTO gofENT_vpl VALUES ("C22_4","077_2_4","2CO","2","4","4","ታኒ ዳሮ ዋዬኒኔ ኡንዓን ቃሲ ዳሮ ኣፉꬃን ፃፊዳይ፥ ሂንቴና ኣዛንꬃናሳ ጊዶናሺን ታኒ ሂንቴና ኡባ ኣይ ሜላ ዶሲያኮ ሂንቴና ኤሪሳና ሜላሳ። ");
INSERT INTO gofENT_vpl VALUES ("C22_5","077_2_5","2CO","2","5","5","ኣሴ ኣዛንꬂዳ ኦኒካ ዴዒኮ ታ ኢያ ባላ ዳርሳናው ኮዪኬፌ ኣቲን ታና ጊዶናሺን ሂንቴፌ ዳሮታ ኣዛንꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("C22_6","077_2_6","2CO","2","6","6","ሂንቴፌ ዳሪያ ኣሳይ ሄ ኡራ ሴሪዳ ሴራይ ኢያው ጊዳና። ");
INSERT INTO gofENT_vpl VALUES ("C22_7","077_2_7","2CO","2","7","7","ሄሳ ጊሾ፥ ሄ ኡራይ ዳሮ ኣዛኒዲ፥ ኡፋይሲ ቃንፆና ሜላ ሂንቴ ኢያ ማራናዉኔ ሚንꬄꬃናው ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("C22_8","077_2_8","2CO","2","8","8","ሂንቴ ኢያ ሲቄይሳ ዛሪ ኢያው ቆንጪሳና ሜላ ታ ሂንቴና ዎሳይስ። ");
INSERT INTO gofENT_vpl VALUES ("C22_9","077_2_9","2CO","2","9","9","ታ ሄ ዳብዳቢያ ሂንቴው ፃፊዳይ፥ ሂንቴ ፓጬቲዲ፥ ኡባባን ታው ኪቴቴይሳ ኤራናው ኮዪዳ ጊሾሳ። ");
INSERT INTO gofENT_vpl VALUES ("C22_10","077_2_10","2CO","2","10","10","ሂንቴ ማሪያ ኡራ ታካ ማራና። ታኒ ማራናባይ ኣይቢ ዴዒኮካ፥ ኪሪስቶሳ ሲንꬃን ሂንቴ ጊሾ ጋዳ ማራስ። ");
INSERT INTO gofENT_vpl VALUES ("C22_11","077_2_11","2CO","2","11","11","ታኒ ሄሳ ኦꬂዳይ ፃላሂያ ጪሞ ኦሱዋ ኑ ኤሪያ ጊሾ ፃላሄን ጪሜቶና ኣታና ሜላሳ። ");
INSERT INTO gofENT_vpl VALUES ("C22_12","077_2_12","2CO","2","12","12","ታኒ ኪሪስቶሳ ዎንጌላ ሳባካናው ፂሮዓዳ ቢዳ ዎዴ ጎዳይ ያን ታው ኦሶ ኦጌ ጊጊሲዲ ዎꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("C22_13","077_2_13","2CO","2","13","13","ሺን ታኒ ታ ኢሻ ቲቶ ያን ዴማቦና ጊሾ ታ ዎዛናይ ሼምፒቤና። ሄሳ ጊሾ፥ ያን ዴዒያ ኣሳ ሳሮꬃዳ ኢያ ኮያናው ማቄዶኒያ ባስ። ");
INSERT INTO gofENT_vpl VALUES ("C22_14","077_2_14","2CO","2","14","14","ሺን ኪሪስቶሳ ባጋራ ኡባ ዎዴ ኑና ፆኖን ካሌꬂያኔ ሺቶ ሜላ ሳዊያ ኪሪስቶሳባ ኑ ኤሪያ ቲሚርቲያ ኡባ ቤሲ ጋꬃና ሜላ ኦꬂያ ፆሳ ጋላቲ ጋኮ። ");
INSERT INTO gofENT_vpl VALUES ("C22_15","077_2_15","2CO","2","15","15","ኑኒ ኣቲያ ኣሳ ጊዶኒኔ ꬋያ ኣሳ ጊዶን ኪሪስቶሳ ባጋራ ፆሳስ ኢሜቲዳ ሳዊያ ሺቶ ሜላ። ");
INSERT INTO gofENT_vpl VALUES ("C22_16","077_2_16","2CO","2","16","16","ꬋያ ኣሳስ ሃይቆኮ ኤፊያ ሃይቆ ፔኖ፤ ቃሲ ኣቲያ ኣሳስ ዴዖኮ ኤፊያ ዴዖ ሳዎ፤ ያቲን፥ ሄሳ ሜላ ኦሱዋስ ጊዳናይ ኦኔ? ");
INSERT INTO gofENT_vpl VALUES ("C22_17","077_2_17","2CO","2","17","17","ኑኒ ፆሳ ቃላ ዎꬌ ዴማናው ኮዪዲ ዋላኪዲ ዛልዒያ ዳሮ ኣሳ ሜላ ጊዶኮ። ሺን ፆሳይ ኪቲዳ ሱሬ ኣሳታ ሜላ ኪሪስቶሳን ዴዒዲ ፆሳ ሲንꬃን ቃላ ኦዶስ። ");
INSERT INTO gofENT_vpl VALUES ("C23_1","077_3_1","2CO","3","1","1","ኑኒ ዛሪዲ ኑና ሳቢኖዬ? ዎይኮ ሃራ ኣሳዳ፥ ሳባ ዳብዳቢያ ሂንቴው ዬዳናው ዎይኮ ሂንቴፌ ኤካናው ኑና ኮሺዬ? ");
INSERT INTO gofENT_vpl VALUES ("C23_2","077_3_2","2CO","3","2","2","ኣሲ ኡባይ ሂንቴና ኤራና ሜላኔ ናባባና ሜላ ሂንቴ ኑ ዎዛናን ፃፌቲዲ ዴዒያ ኑ ዳብዳቤ። ");
INSERT INTO gofENT_vpl VALUES ("C23_3","077_3_3","2CO","3","3","3","ሂንቴ ቃላሜን ጊዶናሺን ዴዖ ፆሳ ኣያናን፥ ሹቻ ቦላ ጊዶናሺን ኣሳ ዎዛናን ፃፌቲዳይሳታኔ ኑናን ሃጋዜቲዳ ኪሪስቶሳ ዳብዳቤ ጊዴይሳ ቤሲዴታ። ");
INSERT INTO gofENT_vpl VALUES ("C23_4","077_3_4","2CO","3","4","4","ኑ ሄሳ ጊዳይ፥ ኪሪስቶሳ ባጋራ ፆሳን ኣማኖይ ኑስ ዴዒያ ጊሾሳ። ");
INSERT INTO gofENT_vpl VALUES ("C23_5","077_3_5","2CO","3","5","5","ኑ ሄሳ ኦꬃናው ዳንዳዒዳይ ፆሳ ዎልቃናፔ ኣቲን ኑኒ ኑ ዎልቃን ኣይኮካ ኦꬃናው ዳንዳዖኮ። ");
INSERT INTO gofENT_vpl VALUES ("C23_6","077_3_6","2CO","3","6","6","ኑ ኦራꬃ ጫቁዋ ኦሳንቾታ ጊዳና ሜላ ፆሳይ ኑና ዳንዳዒሲስ። ሄ ኦራꬃ ጫቆይ ጌሻ ኣያናን ቤንቲዳይሳፌ ኣቲን ፃፌቲዳ ሂጌን ጊዴና። ሂጌይ ዎꬌስ፥ ሺን ጌሻ ኣያናይ ዴዖ ኢሜስ። ");
INSERT INTO gofENT_vpl VALUES ("C23_7","077_3_7","2CO","3","7","7","ሹቻ ቦላ ፃፌቲዳ ሂጌይ ኢሜቲያ ዎዴ ፆሳ ቦንቾይ ቆንጪስ። ሙሴ ሶምዑዋን ዴዒያ ቦንቾይ ꬋዪሼ ቢያባ ጊዲኮካ፥ ኢስራዔሌ ኣሳይ ኢያ ሶምዑዋ ቲሺ ኦꬂዲ ፄላናው ዳንዳዒቦኮና። ሂዛ፥ ሃይቆ ኤሂያ ሂጌይ ሄሳ ሜላ ቦንቾን ቆንጪኮ፥ ");
INSERT INTO gofENT_vpl VALUES ("C23_8","077_3_8","2CO","3","8","8","ያቲን፥ ጌሻ ኣያናን ኦሴቲያ ኦሱዋ ቦንቾይ ዋኒዲ ኣꬌኔ? ");
INSERT INTO gofENT_vpl VALUES ("C23_9","077_3_9","2CO","3","9","9","ኣሳ ቦላ ፒርዳ ኤሂያ ሂጌይ ቦንቾ ጊዲኮ ያቲን፥ ኣሴ ፂሊሲያ ኦራꬃ ኦጌይ ዋኒዲ ኣꬊዲ ቦንቼቴኔ? ");
INSERT INTO gofENT_vpl VALUES ("C23_10","077_3_10","2CO","3","10","10","ካሴ ቦንቾ ጊዲዳይሳ ሃዒ ኣꬊያ ቦንቾይ ዴዔይሳራ ጋꬂ ቤዒያ ዎዴ ቦንቾይ ባይናባ ጊዲስ። ");
INSERT INTO gofENT_vpl VALUES ("C23_11","077_3_11","2CO","3","11","11","ጉꬃ ዎዴስ ቆንጪዲ ጉዬፔ ꬋይዳይሲ ሃይሳዳ ቦንቼቲኮ፥ ሜሪናው ዴዔይሲ ዋኒዲ ኣꬊዲ ቦንቼቴኔ? ");
INSERT INTO gofENT_vpl VALUES ("C23_12","077_3_12","2CO","3","12","12","ኑስ ሃይሳ ሜላ ኡፋይሳይ ዴዒያ ጊሾ ዬላቶና ኦዴቶስ። ");
INSERT INTO gofENT_vpl VALUES ("C23_13","077_3_13","2CO","3","13","13","ኑኒ፥ ኢስራዔሌ ኣሳይ ꬋዪሼ ቢያ ቦንቹዋ ዉርሴꬃ ቤዖና ሜላ ባ ሶምዑዋ ካሚዳ ሙሴ ሜላ ጊዶኮ። ");
INSERT INTO gofENT_vpl VALUES ("C23_14","077_3_14","2CO","3","14","14","ሺን ኤንታ ዎዛናይ ዶጪስ። ሃቺ ጋካናው ኤንቲ ጋልዓ ጫቁዋ ናባቢያ ዎዴ ኤንታ ዎዛናይ ሄ ካማን ካሜቲ ዴዔስ። ሄ ካማይ ኪሪስቶሳ ፃላላን ቃሬቴስ። ");
INSERT INTO gofENT_vpl VALUES ("C23_15","077_3_15","2CO","3","15","15","ሺን ሃቺ ጋካናዉካ ኤንቲ ሙሴ ማፃፋ ናባቢያ ዎዴ ኡባን ሄ ካማይ ኤንታ ዎዛና ካሜስ። ");
INSERT INTO gofENT_vpl VALUES ("C23_16","077_3_16","2CO","3","16","16","ሺን ኦኒካ ጎዳኮ ሲሚያ ዎዴ ኣዉዴካ ሄ ካማይ ቃሬቴስ። ");
INSERT INTO gofENT_vpl VALUES ("C23_17","077_3_17","2CO","3","17","17","ጎዳይ ኣያና፤ ጎዳ ኣያናይ ዴዒያ ቤሳን ላዓቴꬂ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("C23_18","077_3_18","2CO","3","18","18","ኑኒ ኡባይ ካሜቲቦና ሶምዖን ጎዳ ቦንቹዋ ቤዓና። ኑኒ ኣያና ጊዲዳ ጎዳ ማላ ዳናናው ቦንቾፌ ቦንቾን ላሜታና። ");
INSERT INTO gofENT_vpl VALUES ("C24_1","077_4_1","2CO","4","1","1","ሂዛ፥ ፆሳይ ባ ማሮቴꬃን ሃ ኦሱዋ ኑስ ኢሚዳ ጊሾ ኑኒ ኡፋይሲ ቃንፆኮ። ");
INSERT INTO gofENT_vpl VALUES ("C24_2","077_4_2","2CO","4","2","2","ኑኒ ዬላያ ጌማ ኦሶ ኡባ ኣጊዳ፤ ጌኔ ኦሶ ኦꬆኮ፤ ፆሳ ቃላ ዎርዶራ ዋላኮኮ። ቱማ ቆንጬን ሃሳዪሼ፥ ኣሳ ኡባ ካሃይ ኑና ኤካና ሜላ ፆሳ ሲንꬃን ኑና ሺሾስ። ");
INSERT INTO gofENT_vpl VALUES ("C24_3","077_4_3","2CO","4","3","3","ኑ ኦዲያ ዎንጌላይ ጌሚዳባ ጊዲኮካ፥ ጌሚዳይ ꬋዮ ኦጌን ዴዒያ ኣሳሳ። ");
INSERT INTO gofENT_vpl VALUES ("C24_4","077_4_4","2CO","4","4","4","ሃ ኣላሚያ ሃሪያ ፆሳይ ኣማኖና ኣሳ ዎዛና ጎዚስ። ኤንቲ ፆሳ ማላን ቆንጪዳ ኪሪስቶሳ ቦንቾ ዎንጌላ ፖዑዋ ቤዖና ሜላ ዲጊስ። ");
INSERT INTO gofENT_vpl VALUES ("C24_5","077_4_5","2CO","4","5","5","ኑኒ፥ ዬሱስ ኪሪስቶሲ ጎዳ ጊዴይሳኔ ኑ ኢያ ጊሾ ሂንቴ ኦሳንቾ ጊዴይሳ ኦዶሲፔ ኣቲን ኑባ ኦዶኮ። ");
INSERT INTO gofENT_vpl VALUES ("C24_6","077_4_6","2CO","4","6","6","«ꬉማን ፖዖይ ፖዖ» ጊዳ ፆሳይ፥ ኪሪስቶሳ ሶምዑዋን ፖዒያ ፆሳ ቦንቹዋ ኤራ ፖዑዋ ኢማናው ባ ፖዑዋ ኑ ዎዛናን ፖዒሲስ። ");
INSERT INTO gofENT_vpl VALUES ("C24_7","077_4_7","2CO","4","7","7","ሺን ኡባፌ ኣꬊያ ዎልቃይ ኑባ ጊዶናሺን ፆሳባ ጊዴይሳ ቤሳናው ሃ ቦንቾ ሻሎይ ሜቃ ሚሼ ጊዲዳ ኑ ኣሳቴꬃን ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("C24_8","077_4_8","2CO","4","8","8","ኑ ኡባ ባጋራካ ዋዬቲዳ፥ ሺን ሜቄሬቲቦኮ። ኑስ ሃዲርሲ ጊዲስ፥ ሺን ኡፋይሲ ቃንፂቦኮ። ");
INSERT INTO gofENT_vpl VALUES ("C24_9","077_4_9","2CO","4","9","9","ኑ፥ ሞርኬታን ጎዴቲዳ፥ ሺን ላጌ ꬋዪቦኮ። ኑ ሞርኬታን ሾጬቲዲ ኩንዲዳ፥ ሺን ꬋዪቦኮ። ");
INSERT INTO gofENT_vpl VALUES ("C24_10","077_4_10","2CO","4","10","10","ዬሱሳ ዴዖይ ኑ ኣሳቴꬃን ቆንጫና ሜላ ኢያ ሃይቁዋ ኡባ ዎዴ ኑ ኣሳቴꬃን ቶኪዲ ዩዮስ። ");
INSERT INTO gofENT_vpl VALUES ("C24_11","077_4_11","2CO","4","11","11","ዬሱሳ ዴዖይ ሃይቂያ ኑ ኣሳቴꬃን ቆንጫና ሜላ ፓፃ ዴዒያ ኑኒ ኢያ ጊሾ ኡባ ዎዴ ሃይቆስ ኣꬊዲ ኢሜቶስ። ");
INSERT INTO gofENT_vpl VALUES ("C24_12","077_4_12","2CO","4","12","12","ሂዛ፥ ሃይቆይ ኑናን ኦꬂያ ዎዴ ዴዖይ ሂንቴናን ኦꬄስ። ");
INSERT INTO gofENT_vpl VALUES ("C24_13","077_4_13","2CO","4","13","13","ጌሻ ማፃፋን፥ «ታ ኣማናስ፤ ሄሳ ጊሾ ሃሳያስ» ያጌቲስ። ሄሳ ሜላ ኣማኖይ ኑስ ዴዒያ ጊሾ ሃሳዮስ። ");
INSERT INTO gofENT_vpl VALUES ("C24_14","077_4_14","2CO","4","14","14","ጎዳ ዬሱሳ ሃይቆፔ ዴንꬂዳ ፆሳይ፥ ኑናካ ዬሱሳራ ሃይቆፔ ዴንꬃናይሳኔ ሂንቴራ ኢሲፌ ባ ሲንꬄ ሺሻናይሳ ኤሮስ። ");
INSERT INTO gofENT_vpl VALUES ("C24_15","077_4_15","2CO","4","15","15","ሄሲ ኡባይ ሃኒዳይ ሂንቴ ጊሾሳ። ፆሳ ኣꬎ ኬሃቴꬃይ ዳሮ ኣሳ ጋኪያ ዎዴ ኣሳይ ፆሳ ቦንቹዋስ ዳሮ ጋላታ ኢማና። ");
INSERT INTO gofENT_vpl VALUES ("C24_16","077_4_16","2CO","4","16","16","ሄሳ ጊሾ፥ ኑኒ ኡፋይሲ ቃንፆኮ። ኑ ቤንቲያ ኣሳቴꬃይ ዳቡሪሼ ቢያባ ጊዲኮካ፥ ኑ ኣያና ኣሳቴꬃይ ጋላስ ጋላስ ኦራፄስ። ");
INSERT INTO gofENT_vpl VALUES ("C24_17","077_4_17","2CO","4","17","17","ሃዒስ ኑኒ ዋዬቲያ ሃ ካዉሻ ዋዬይ፥ ኡባፌ ኬሂ ጊታቲያ ሜሪና ቦንቹዋ ኑስ ኢሚሳና። ");
INSERT INTO gofENT_vpl VALUES ("C24_18","077_4_18","2CO","4","18","18","ኑኒ ቤንቲያባ ጊዶናሺን ቤንቶናባ ፄሎስ። ቤንቲያባይ ሃዒሳ፥ ሺን ቤንቶናባይ ሜሪናሳ። ");
INSERT INTO gofENT_vpl VALUES ("C25_1","077_5_1","2CO","5","1","1","ሃዒ ኑ ዴዒያ ዱንካኔ ዳኒያ ሃ ሳዓ ኣሳቴꬃይ ላሌቲኮካ፥ ኣሲ ኬፂቦና፥ ፆሳይ ኬፂዳ ሜሪና ኬꬃይ ኑስ ሳሎን ዴዔይሳ ኤሮስ። ");
INSERT INTO gofENT_vpl VALUES ("C25_2","077_5_2","2CO","5","2","2","ሳሎ ኣሳቴꬃ ማዓናው ኣሞቲሼ ሃዒ ሃ ሳዓን ዴዒሼ ኦሎስ። ");
INSERT INTO gofENT_vpl VALUES ("C25_3","077_5_3","2CO","5","3","3","ኑኒ ሄሳ ማዒያ ዎዴ ካሎቶኮ። ");
INSERT INTO gofENT_vpl VALUES ("C25_4","077_5_4","2CO","5","4","4","ዱንካኔ ዳኒያ ሃ ሳዓ ኣሳቴꬃን ኑ ዴዒሼ ዴፄቲዲ ኦሎስ። ሃይቂያ ኑ ኣሳቴꬃይ ዴዖን ላሜታና ሜላ ሳሎ ኣሳቴꬃ ማዓናው ኮዮሲፔ ኣቲን ኣሹዋፔ ሻኬታናው ኮዪዲ ጊዴና። ");
INSERT INTO gofENT_vpl VALUES ("C25_5","077_5_5","2CO","5","5","5","ኑና ሃይሳስ ጊጊሲዳይ ፆሳ። ቃሲ ሲንꬃፌ ያናባስ ኦይꬂ ኦꬂዲ ባ ኣያና ኑስ ኢሚስ። ");
INSERT INTO gofENT_vpl VALUES ("C25_6","077_5_6","2CO","5","6","6","ሄሳ ጊሾ፥ ኑኒ ሃ ሳዓ ኣሳቴꬃን ዴዒያ ዎዴ ኡባን ጎዳፔ ሃኪዲ ዴዔይሳ ኤሪኮካ ኡባ ዎዴ ኣማኔቲዲ ዴዖስ። ");
INSERT INTO gofENT_vpl VALUES ("C25_7","077_5_7","2CO","5","7","7","ኑኒ ዴዔይ ኣማኖናፔ ኣቲን ቤዒያባን ጊዴና። ");
INSERT INTO gofENT_vpl VALUES ("C25_8","077_5_8","2CO","5","8","8","ኑ ሃ ሳዓ ኣሳቴꬃፌ ሻኬቲዲ፥ ኑ ሶ ቢዲ ጎዳራ ኢሲፌ ዳናው ኣሞቲያ ጊሾ ኣማኔቲዲ ዴዖስ። ");
INSERT INTO gofENT_vpl VALUES ("C25_9","077_5_9","2CO","5","9","9","ሄሳ ጊሾ፥ ኑ ሃ ኣሳቴꬃን ዴዒን ዎይኮ ሃ ኣሳቴꬃፌ ሻኬቲን፥ ኑ ኣሞይ ኢያ ኡፋይሳናይሳ። ");
INSERT INTO gofENT_vpl VALUES ("C25_10","077_5_10","2CO","5","10","10","ኑኒ ኢሶይ ኢሶይ ሃ ሳዓን ዴዒሼ ሎዖ ጊዲን ዎይኮ ኢታ ጊዲን፥ ኦꬂዳ ኦሱዋስ ቤሲያ ፒርዳ ኤካናው ኪሪስቶሳ ፒርዳ ኣራታ ሲንꬃን ሺቃና። ");
INSERT INTO gofENT_vpl VALUES ("C25_11","077_5_11","2CO","5","11","11","ሂዛ፥ ኑኒ ጎዳ ቦንቼይሲ ኣይ ጉሴኮ ኤሪያ ጊሾ ኣሳይ ኑ ኦዴይሳ ኤካና ሜላ ዞሮስ። ፆሳይ፥ ኑኒ ኦኔኮ ኑና ኤሬስ፤ ቃሲ ሂንቴካ ሂንቴ ካሃን ኑ ኦኔኮ ኤሬታ ያጋዳ ቆፓይስ። ");
INSERT INTO gofENT_vpl VALUES ("C25_12","077_5_12","2CO","5","12","12","ዎዛናን ጊዶናሺን ማላን ጬቄቲያ ኣሳ ዶና ኦይꬃናው ሂንቴ ኑናን ጬቄታና ሜላ ሂንቴው ጋሶ ጊዳናው ኮዮሲፔ ኣቲን ኑ ኑና ዛሪዲ ናሻናው ኮዮኮ። ");
INSERT INTO gofENT_vpl VALUES ("C25_13","077_5_13","2CO","5","13","13","ኑ ጎሺ ጊዲኮ ፆሳ ቦንቾሳ፤ ዎዛናማ ጊዲኮ ሂንቴሳ። ");
INSERT INTO gofENT_vpl VALUES ("C25_14","077_5_14","2CO","5","14","14","ኢሶይ ኡባስ ሃይቂዳይሳኔ ኡባይ ቃሲ ኢያራ ሃይቂዳይሳ ኑ ኤሪያ ጊሾ ኪሪስቶሳ ሲቆይ ኑና ሃሬስ። ");
INSERT INTO gofENT_vpl VALUES ("C25_15","077_5_15","2CO","5","15","15","ዴዖን ዴዔይሳቲ ሂዛፔ ጉዬ ባንታው ጊዶናሺን ኤንታው ሃይቂዳይሳሲኔ ሃይቆፔ ዴንዲዳይሳስ ዳና ሜላ ኪሪስቶሲ ኣሳ ኡባ ጊሾ ሃይቂስ። ");
INSERT INTO gofENT_vpl VALUES ("C25_16","077_5_16","2CO","5","16","16","ሂዛፔ ጉዬ፥ ኑኒ ኦናካ ኣሳ ቆፋን ፒርዶኮ። ሃይሳፌ ካሴ ኑኒ ኪሪስቶሳካ ኣሳ ቆፋን ፒርዲዳባ ጊዲኮካ፥ ሂዛፔ ሄሳዳ ፒርዶኮ። ");
INSERT INTO gofENT_vpl VALUES ("C25_17","077_5_17","2CO","5","17","17","ሄሳ ጊሾ፥ ኦኒካ ኪሪስቶሳን ዴዒኮ ኦራꬃ ሜꬌቴꬂ፤ ጋልዓ ሜꬌቴꬃይ ኣꬊስ፤ ኡባይካ ኦራꬂ ጊዲስ። ");
INSERT INTO gofENT_vpl VALUES ("C25_18","077_5_18","2CO","5","18","18","ሄሳ ኡባ ፆሳይ ኦꬂስ። ኢ ኪሪስቶሳ ባጋራ ኑና ባራ ሲጌꬂስ። ቃሲ ሃራታ ባራ ሲጌꬃና ሜላ ኑስ ሲጌꬆ ኦሶ ኢሚስ። ");
INSERT INTO gofENT_vpl VALUES ("C25_19","077_5_19","2CO","5","19","19","ፆሳይ ኪሪስቶሳ ባጋራ ኣሳ ኡባ ባራ ሲጌꬄስ። ኤንታ ናጋራ ታይቢቤና፤ ቃሲ ኣሳ ባራ ሲጌꬂያ ቃላ ኑስ ኢሚስ። ");
INSERT INTO gofENT_vpl VALUES ("C25_20","077_5_20","2CO","5","20","20","ፆሳይ ኣሳ ኑ ባጋራ ፄጊያ ጊሾ ኑ ኪሪስቶሳን ኪቴቲዲ ኣሳ ፆሳራ ሲጌቲቴ ጊዲ ኪሪስቶሳ ጊሾ ዎሶስ። ");
INSERT INTO gofENT_vpl VALUES ("C25_21","077_5_21","2CO","5","21","21","ኑኒ ፆሳ ፂሎቴꬃ ኪሪስቶሳ ባጋራ ኤካና ሜላ፥ ናጋራ ኤሮና ኪሪስቶሳ ኑ ጊሾ ናጋራንቾ ኣሳዳ ኦꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("C26_1","077_6_1","2CO","6","1","1","ኑኒ ፆሳራ ኢሲፌ ኦꬂያ ኣሲ ጊዴይሳዳ፥ ሂንቴ ኤኪዳ ኣꬎ ኬሃቴꬃ ሃዳ ኦꬆና ሜላ ኑ ሂንቴና ዎሶስ። ");
INSERT INTO gofENT_vpl VALUES ("C26_2","077_6_2","2CO","6","2","2","ፆሳይ፥ «ታ ኔና ሲዓና ዎዴን ሲዓስ፤ ኣቶቴꬃ ጋላሳን ኔና ማዳስ» ያጌስ። ሄኮ፥ ታ ሲዒያ ዎዴይ ሃዒ፤ ኣቶቴꬃ ጋላሳይ ሃቺ። ");
INSERT INTO gofENT_vpl VALUES ("C26_3","077_6_3","2CO","6","3","3","ኦኒካ ኑ ኦሱዋ ቦራና ሜላኔ ኑናን ꬉቤታና ሜላ ኮዮኮ። ");
INSERT INTO gofENT_vpl VALUES ("C26_4","077_6_4","2CO","6","4","4","ጊዶሺን፥ ኑ ቱማ ፆሳ ኦሳንቾታ ጊዴይሳ ኑ ኦꬂያ ኡባባን ቤሲዳ። ዳሮ ጌንጫን፥ ዋዬን፥ ሜቶን፥ ኡንዓን፥ ");
INSERT INTO gofENT_vpl VALUES ("C26_5","077_6_5","2CO","6","5","5","ጋራፌቴꬃን፥ ቃሾን፥ ኢፆን ኩሚዳ ዎጫማን፥ ዳቡራን፥ ꬊስኮ ꬋዮን፥ ፆማን፥ ");
INSERT INTO gofENT_vpl VALUES ("C26_6","077_6_6","2CO","6","6","6","ጌሻቴꬃን፥ ኤራቴꬃን፥ ዳንዳዓን፥ ኬሃቴꬃን፥ ጌሻ ኣያናን፥ ቱማ ሲቆን፥ ");
INSERT INTO gofENT_vpl VALUES ("C26_7","077_6_7","2CO","6","7","7","ቱማ ሃሳያኒኔ ፆሳ ዎልቃን ኑኒ ኢያ ኦሳንቾታ ጊዴይሳ ቤሲዳ። ቃሲ ፂሎቴꬃይ ኑስ ቶራኔ ጎንዳሌ። ");
INSERT INTO gofENT_vpl VALUES ("C26_8","077_6_8","2CO","6","8","8","ኑኒ ቦንቼቲዳኔ ቶሼቲዳ፤ ጫዬቲዳኔ ጋላቴቲዳ። ቱማ ሃሳዮስ፥ ሺን ኣሳይ ኑና ዎርዳንቾ ጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("C26_9","077_6_9","2CO","6","9","9","ኑ ኣሳን ኤሬቲዳ ኣሲ፥ ሺን ኤሬቶና ኣሳ ሜላ ጊዲዳ። ሃይቂዶሶና ያጌቲዳ፥ ሺን ፓፃ ዴዖስ፤ ሾጬቲዳ፥ ሺን ሃይቂቦኮ። ");
INSERT INTO gofENT_vpl VALUES ("C26_10","077_6_10","2CO","6","10","10","ኑኒ ኣዛኒኮካ ኡባ ዎዴ ኡፋይቶስ። ኑ ማንቆ ዳኖስ፥ ሺን ዳሮ ኣሳ ዱሬዮስ። ቃሲ ኣይኮይካ ባይና ኣሲ ዳኖስ፥ ሺን ኡባይ ኑባ። ");
INSERT INTO gofENT_vpl VALUES ("C26_11","077_6_11","2CO","6","11","11","ቆሮንቶሳ ኣሳው፥ ኑ ሂንቴው ቆንጬን ኦዲዳ፤ ኑ ኡሉዋ ሂንቴና ቤሲዳ። ");
INSERT INTO gofENT_vpl VALUES ("C26_12","077_6_12","2CO","6","12","12","ሂንቴ ኑና ሂንቴ ሲቁዋ ቤሶና ዲጊዴታፔ ኣቲን ኑ ኑ ሲቁዋ ሂንቴና ዲጊቦኮ። ");
INSERT INTO gofENT_vpl VALUES ("C26_13","077_6_13","2CO","6","13","13","ኣዉ ባ ናይታስ ኦዴይሳዳ ታ ሂንቴው ኦዳይስ፤ ኑ ሂንቴና ኑ ኡሉዋ ቤሲዳይሳዳ፥ ሂንቴካ ሂንቴ ኡሉዋ ኑና ቤሲቴ። ");
INSERT INTO gofENT_vpl VALUES ("C26_14","077_6_14","2CO","6","14","14","ኣማኖና ኣሳራ ቤሶና ኦጌን ዋፄቶፊቴ። ፂሎቴꬃሲኔ ናጋራስ ኣይቢ ጋሄቴꬂ ዴዒ? ፖዖሲኔ ꬉማስ ኣይቢ ኢሲፌቴꬂ ዴዒ? ");
INSERT INTO gofENT_vpl VALUES ("C26_15","077_6_15","2CO","6","15","15","ኪሪስቶሳኔ ፃላሄ ኢሲፌ ጋꬂያባይ ኣይቤ? ቃሲ ኣማኔይሲኔ ኣማኖናይሲ ኢሲፌ ኮፂያባይ ኣይቤ? ");
INSERT INTO gofENT_vpl VALUES ("C26_16","077_6_16","2CO","6","16","16","ፆሳ ኬꬃስ ኤቃታራ ኣይቢ ኢሲፌቴꬂ ዴዒ? ፆሳይ፥ «ታኒ ኤንታ ጊዶን ዴዓና፥ ኤንታ ጊዶን ሃሙታና። ታኒ ኤንታ ፆሳ ጊዳና፤ ኤንቲካ ታ ኣሴ ጊዳና» ጊዳይሳዳ፥ ኑኒ ዴዖ ፆሳ ኬꬂ። ");
INSERT INTO gofENT_vpl VALUES ("C26_17","077_6_17","2CO","6","17","17","ሄሳዳካ፥ ጎዳይ፥ «ኤንታ ጊዶፌ ሻኬቲዲ ኬዪቴ፤ ቱና ጊዲዳባ ቦቾፊቴ፤ ታ ሂንቴና ኤካና። ");
INSERT INTO gofENT_vpl VALUES ("C26_18","077_6_18","2CO","6","18","18","ታ ሂንቴው ኣዋ ጊዳና፤ ሂንቴ ታው ኣዴ ናይታኔ ማጫ ናይታ ጊዳና፤ ያጌስ ኡባፌ ዎልቃማ ጎዳይ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("C27_1","077_7_1","2CO","7","1","1","ሂዛ፥ ታ ሲቆቶ፥ ሃ ኡፋይሳይ ኑስ ዴዒያ ጊሾ ኑ ኣሹዋኔ ኑ ሼምፑዋ ቱኒሲያባ ኡባፌ ኑና ጌሾስ። ፆሳስ ያዪዲ ኑ ጌሻቴꬃ ፖሎ ኦꬆስ። ");
INSERT INTO gofENT_vpl VALUES ("C27_2","077_7_2","2CO","7","2","2","ሂንቴ ኡሉዋ ኑና ቤሲቴ። ኑኒ ኦናካ ናቂቦኮ፤ ኦናካ ቆሂቦኮ፤ ኦናካ ጪሚቦኮ። ");
INSERT INTO gofENT_vpl VALUES ("C27_3","077_7_3","2CO","7","3","3","ታኒ ሄሳ ሂንቴ ቦላ ፒርዳናው ጊኬ። ሃይሳፌ ካሴ ታ ሂንቴው ኦዲዳይሳዳ፥ ሂንቴ ኑ ዎዛናን ዴዔታ፤ ኑ ፓፃ ዴዒንካ ሃይቂንካ ሂንቴፌ ሻኬቶኮ። ");
INSERT INTO gofENT_vpl VALUES ("C27_4","077_7_4","2CO","7","4","4","ታ ኦዲያባ ሂንቴፌ ቆቲኬ፤ ታ ሂንቴናን ጬቄታይስ፤ ኑ ዋዬ ኡባን ሚኔታይስ፤ ቃሲ ጊታ ኡፋይሲ ኡፋይታይስ። ");
INSERT INTO gofENT_vpl VALUES ("C27_5","077_7_5","2CO","7","5","5","ኑኒ ማቄዶኒያ ቢዳ ዎዴ ኡባ ባጋራ ዋዬቲዳፔ ኣቲን ሼምፒቦኮ። ካሬራ ሞርኬታን፥ ኑ ጋꬃን ያሻን ኡንዔቲዳ። ");
INSERT INTO gofENT_vpl VALUES ("C27_6","077_7_6","2CO","7","6","6","ሺን ኣዛኒዳይሳታ ሚንꬄꬂያ ፆሳይ፥ ቲቶ ዩሳን ኑና ሚንꬄꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("C27_7","077_7_7","2CO","7","7","7","ኑና ሚንꬄꬂዳይ ቲቶ ዩሳ ፃላላ ጊዶናሺን ሂንቴካ ኢያ ሚንꬄꬂዳይሳና። ሂንቴ ታና ላሞቴይሳ፥ ታው ኣዛኔይሳኔ ታው ቆፔይሳ ታ ሲዒዳ ዎዴ ታና ዳሮ ኡፋይሲስ። ");
INSERT INTO gofENT_vpl VALUES ("C27_8","077_7_8","2CO","7","8","8","ታ ዳብዳቤይ ሂንቴና ኣዛንꬂኮካ ኣይስ ፃፋዲናሻ ጋዳ ቂሮቲኬ። ታ ቂሮቲዳይ ታ ፃፊዳ ዳብዳቤይ ሂንቴና ጉꬃ ዎዴስ ኣዛንꬂዳ ጊሾሳ። ");
INSERT INTO gofENT_vpl VALUES ("C27_9","077_7_9","2CO","7","9","9","ሃዒ ታኒ ኡፋይቲዳይ፥ ታ ሂንቴና ኣዛንꬂዳ ጊሾ ጊዶናሺን ሂንቴ ኣዛኖይ ሂንቴና ሂንቴ ናጋራፔ ዛሪዳ ጊሾሳ። ፆሳይ ባ ሼኒያዳ ሂንቴና ኣዛንꬂሲፔ ኣቲን ኑ ሂንቴና ኣይቢንካ ቆሂቦኮ። ");
INSERT INTO gofENT_vpl VALUES ("C27_10","077_7_10","2CO","7","10","10","ፆሳይ ኮያ ኣዛኖይ፥ ኣቶቴꬃኮ ጋꬂያ ናጋራፔ ሲሞ ኤሄስ፤ ኢያን ቂሮያባይ ባዋ። ሺን ሃ ሳዓ ኣዛኖይ ሃይቆ ኤሄስ። ");
INSERT INTO gofENT_vpl VALUES ("C27_11","077_7_11","2CO","7","11","11","ሂንቴ ኣዛኖይ ሂንቴናን ኣይፊሲዳ ኣይፊያ ቤዒቴ። ሄ ኣዛኖይ ሂንቴና ኣይ ሜላ ዴንꬄꬂዳኮ፥ ኣይ ሜላ ዛሮ ኢማናዳ ጊጊሲዳኮ፥ ሄ ኡራ ቦላ ኣይ ሜላ ሃንቂሲዳኮ፥ ኣይ ሜላ ታው ያያና ሜላ ኦꬂዳኮ፥ ኣይ ሜላ ኣሞዪዳኮ፥ ሄ ኡራ ሴራናው ኣይ ሜላ ጊጊዳኮ ቤዒቴ። ሃ ኡባባን ሂንቴ ጌሺ ጊዴይሳ ማርካዪዴታ። ");
INSERT INTO gofENT_vpl VALUES ("C27_12","077_7_12","2CO","7","12","12","ሄሳ ጊሾ፥ ታኒ ሃ ዳብዳቢያ ሂንቴው ፃፊዳይ፥ ናቂዳ ኡራ ዎይኮ ናቄቲዳ ኡራ ጊሾ ጊዴና። ሺን ሂንቴ ኑስ ኣይ ሜላ ቆፒያኮ ፆሳ ሲንꬃን ሂንቴ፥ ሂንቴና ቤዓና ሜላ ፃፋስ። ");
INSERT INTO gofENT_vpl VALUES ("C27_13","077_7_13","2CO","7","13","13","ኑኒ ኡፋይቲዳይ ሄሳ ጊሾሳ። ኑ ኡፋይሳፌ ኣꬊዲ ኑና ዳሮ ኡፋይሲዳይ፥ ሂንቴ ቲቶ ኡፋይሲዳይሳኔ ኢያ ዎዛና ሼምፒሲዳይሳ። ");
INSERT INTO gofENT_vpl VALUES ("C27_14","077_7_14","2CO","7","14","14","ታኒ ሂንቴና ናሻዳ ኢያው ኦዲን ሂንቴ ታና ዬላዪቤኬታ። ሺን ኑኒ ኡባ ዎዴ ሂንቴው ቱማ ኦዲዳ፤ ሄሳዳካ ኑኒ ቲቶ ሲንꬃን ሂንቴና ናሺዳይሲ ቱማ ጊዲስ። ");
INSERT INTO gofENT_vpl VALUES ("C27_15","077_7_15","2CO","7","15","15","ሂንቴ ኢያው ያሻን ኮኮሪዲ፥ ኢያ ሞኪዳይሳ ቃሲ ኢያው ኣይ ሜላ ኪቴቲዳኮ ኢ ቆፒያ ዎዴ ሂንቴው ዴዒያ ሲቆይ ሚኒሼ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("C27_16","077_7_16","2CO","7","16","16","ታኒ ኡባባን ሂንቴናን ኣማኔቲያ ጊሾ ኡፋይታይስ። ");
INSERT INTO gofENT_vpl VALUES ("C28_1","077_8_1","2CO","8","1","1","ኑ ኢሻቶ፥ ፆሳይ ማቄዶኒያን ዴዒያ ዎሳ ኬꬃታስ ኢሚዳ ኣꬎ ኬሃቴꬃ ሂንቴ ኤራና ሜላ ኑ ኮዮስ። ");
INSERT INTO gofENT_vpl VALUES ("C28_2","077_8_2","2CO","8","2","2","ኤንቲ ጊታ ሜቶን ፓጬቲዶሶና፥ ሺን ኤንታ ኡፋይሳይ ዎልቃማ። ኤንታ ማንቆቴꬃስ ዛዊ ባዋ፥ ሺን ባንታ ኢሙዋን ዳሮ ኬሂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("C28_3","077_8_3","2CO","8","3","3","ኤንቲ ባንታ ዎልቃ ሜላኔ ባንታ ዎልቃፌ ኣꬌይሳ ዶሲዲ ኢሚዳይሳስ ታ ማርካ። ");
INSERT INTO gofENT_vpl VALUES ("C28_4","077_8_4","2CO","8","4","4","ኤንቲ ፆሳ ኣሳ ማዲያ ሎዖ ኦሶ ኑራ ኦꬃናው ኮዪዲ ኑና ዳሮ ዎሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("C28_5","077_8_5","2CO","8","5","5","ኤንቲ ኑኒ ቆፒዳይሳፌ ኣꬂዲ ኦꬂዶሶና። ኮይሮቲዲ ባንታና ጎዳስ ኢሚዶሶና፤ ካሊዲ፥ ፆሳ ሼኒያዳ ባንታና ኑስ ኢሚዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("C28_6","077_8_6","2CO","8","6","6","ሃ ሎዖ ኦሱዋ ዶሚዳ ቲቶይ ጉጂ ኦꬃናዳኔ ሂንቴና ማዲዲ፥ ሄ ኦሱዋ ፖሊሳናዳ ኢያ ዎሲዳ። ");
INSERT INTO gofENT_vpl VALUES ("C28_7","077_8_7","2CO","8","7","7","ሺን ሂንቴ ኡባባን፥ ኣማኖን፥ ሃሳያን፥ ኤራቴꬃን፥ ጊታ ኣሞን፥ ኑና ሲቆኒኔ ኡባባን ዱሬቲዳይሳዳ ሃ ሎዖ ኦሱዋንካ ሂንቴ ኬሃ ጊዳና ሜላ ኑ ኮዮስ። ");
INSERT INTO gofENT_vpl VALUES ("C28_8","077_8_8","2CO","8","8","8","ታኒ ሄሳ ኪታናው ጊኬ። ሺን ሃራታ ጊታ ኣሙዋ ሂንቴ ሲቁዋራ ጋꬃ ቤዓዳ ሂንቴ ኣይ ኬና ቱሜኮ ኤራናው ጋይስ። ");
INSERT INTO gofENT_vpl VALUES ("C28_9","077_8_9","2CO","8","9","9","ሂንቴ ኑ ጎዳ ዬሱስ ኪሪስቶሳ ኣꬎ ኬሃቴꬃ ኤሬታ። ኪሪስቶሲ ዱሬ ጊዲ ኡቲዲ፥ ሂንቴ ኢያ ማንቆቴꬃን ዱሬታናዳ ሂንቴ ጊሾ ማንቂስ። ");
INSERT INTO gofENT_vpl VALUES ("C28_10","077_8_10","2CO","8","10","10","ታኒ ሃ ኦዳን ሂንቴና ማዲያ ዞሬ ዞራናው ኮያይስ። ሂንቴ ዚላይꬂ ኢማናው ፃላላ ጊዶናሺን ሄሳ ኦꬃናው ኣሞቴꬃንካ ሂንቴ ኮይሮ። ");
INSERT INTO gofENT_vpl VALUES ("C28_11","077_8_11","2CO","8","11","11","ሂንቴ ኦꬃናው ዶሚዳ ኦሱዋ ሃዒ ፖሊቴ። ሂንቴ ሂንቴው ዴዔይሳ ኬና ኢሚኮ፥ ሄሲ ሂንቴ ኢማናው ዳሮ ኣሞቴይሳ ቆንጪሴስ። ");
INSERT INTO gofENT_vpl VALUES ("C28_12","077_8_12","2CO","8","12","12","ኢሲ ኣሲ ኢማናው ኣሞቲኮ፥ ኢያ ኢሞይ ፆሳ ሲንꬃን ኤኬቴይ፥ ኢ ባው ዴዒዳይሳ ኬና ኢሚናፔ ኣቲን ባይናባፔ ኢማናው ኡንዔቲን ጊዴና። ");
INSERT INTO gofENT_vpl VALUES ("C28_13","077_8_13","2CO","8","13","13","ታኒ ሄሳ ጌይ፥ ሂንቴ ኡባይ ኢሲ ጊና ጊዳና ሜላሳፌ ኣቲን ሃራቲ ዋያፔ ሼምፒን ሂንቴ ዋዬታና ሜላሳ ጊዴና። ");
INSERT INTO gofENT_vpl VALUES ("C28_14","077_8_14","2CO","8","14","14","ዎዴ ኤንታ ፓላሃይ ሂንቴ ፓጫ ኩንꬃና ሜላ ሃዒ ሂንቴ ፓላሃይ ኤንታ ፓጫ ኩንꬆ። ሄሳን ሂንቴ ጊና ጊዳና። ");
INSERT INTO gofENT_vpl VALUES ("C28_15","077_8_15","2CO","8","15","15","ጌሻ ማፃፋን፥ «ዳሮ ሺሺዳይሳስ ፓላሂቤና፤ ጉꬃ ሺሺዳይሳስ ፓጪቤና» ጌቴቲ ፃፌቲዳይሳ ሜላ። ");
INSERT INTO gofENT_vpl VALUES ("C28_16","077_8_16","2CO","8","16","16","ኑ ሂንቴው ቆፔይሳዳ ቲቶይካ ሂንቴው ቆፓና ሜላ ኦꬂዳ ፆሳይ ጋላቴቶ። ");
INSERT INTO gofENT_vpl VALUES ("C28_17","077_8_17","2CO","8","17","17","ቲቶይ ሂንቴኮ ቢዳይ፥ ኑ ኢያ ዴንꬄꬂዳ ጊሾ ፃላላ ጊዶናሺን ኢ ባ ሼኔን ባናው ኣሞቲዳ ጊሾሳ። ");
INSERT INTO gofENT_vpl VALUES ("C28_18","077_8_18","2CO","8","18","18","ዎንጌላ ማርካቴꬃን ዎሳ ኬꬃ ኡባን ዳሮ ኤሬቲዳ ኢሻ፥ ኑኒ ቲቶራ ኢሲፌ ኪቶስ። ");
INSERT INTO gofENT_vpl VALUES ("C28_19","077_8_19","2CO","8","19","19","ሄሳ ቦላ ኑኒ ሃ ኬሃ ኢሞታ ኤፊያ ዎዴ ኑራ ባና ሜላ ሃ ሎዖ ኦሱዋን ጎዳ ቦንቻናዉኔ ሃራታ ማዳናው ዴዒያ ኣሙዋ ቤሳናው ኢ ዎሳ ኬꬃታን ዶሬቲስ። ");
INSERT INTO gofENT_vpl VALUES ("C28_20","077_8_20","2CO","8","20","20","ሃ ኢሜቲዳ ኬሃ ኢሙዋ፥ ኑ ኦሶ ቦላ ፔሺያ ዎዴ ቦሬቶና ሜላ ናጌቶስ። ");
INSERT INTO gofENT_vpl VALUES ("C28_21","077_8_21","2CO","8","21","21","ኑኒ ጎዳ ሲንꬃን ፃላላ ጊዶናሺን ኣሳ ሲንꬃንካ ሎዖ ጊዲዳባ ኦꬆስ። ");
INSERT INTO gofENT_vpl VALUES ("C28_22","077_8_22","2CO","8","22","22","ቃሲ ዳሮ ዎዴ ፓጬን ሚኒዲ ኣꬊዳ ኑ ኢሻ፥ ኤንታራ ሂንቴኮ ኪቲዳ። ኢ ሂንቴናን ኬሂ ኣማኔቲያ ጊሾ ሃዒ ሂንቴና ማዳናው ዳሮ ኣሞቴስ። ");
INSERT INTO gofENT_vpl VALUES ("C28_23","077_8_23","2CO","8","23","23","ቲቶባ ኤራናው ኮይኮ፥ ኢ ሂንቴና ማዳናው ታራ ኦꬂያ ታ ኦሶ ላጊያ። ሃንኮ ኢሻታባ ጊዲኮ ዎሳ ኬꬃቲ ኪቲዳይሳታ፤ ቃሲ ኣሳይ ኤንታ ዱሳ ቤዒዲ ኪሪስቶሳ ቦንቾሶና። ");
INSERT INTO gofENT_vpl VALUES ("C28_24","077_8_24","2CO","8","24","24","ሄሳ ጊሾ፥ ዎሳ ኬꬃቲ ሂንቴ ሲቁዋኔ ኑ ሂንቴና ናሼይሲ ቱማ ጊዴይሳ ቆንጪሳናው ሂንቴ ሲቁዋ ሃ ኣሳታ ቤሲቴ። ");
INSERT INTO gofENT_vpl VALUES ("C29_1","077_9_1","2CO","9","1","1","ኣማኒያ ኣሳስ ኬሲያ ሚሺያባ ታ ሂንቴው ፃፋናው ኮሼና። ");
INSERT INTO gofENT_vpl VALUES ("C29_2","077_9_2","2CO","9","2","2","ሂንቴ ማዳናው ኬሂ ኣሞቴይሳ ታ ኤራይስ። ሂንቴ ኣካያ ኣሳይ፥ ዚላይꬃፌ ዶሚዲ ማዳናው ጊጌቲዳይሳ ታኒ ማቄዶኒያ ኣሳስ ዶና ኩንꬃዳ ኦዳስ። ሂንቴ ጊታ ኣሞይካ ኤንታፌ ዳሮታ ዴንꬄꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("C29_3","077_9_3","2CO","9","3","3","ሃ ኦሱዋን ሂንቴናን ኑ ጬቄቲያ ጬቆይ ሃዳ ጊዶና ሜላ ኮይሮ ሂንቴባ ታ ኦዲዳይሳዳ ሂንቴ ጊጌቲዲ ናጋና ሜላ ሃ ኢሻታ ሂንቴኮ ኪታስ። ");
INSERT INTO gofENT_vpl VALUES ("C29_4","077_9_4","2CO","9","4","4","ማቄዶኒያ ኣሳይ ታራ ቢዲ፥ ሂንቴ ጊጌቶና ዴዒሺን፥ ዴሚኮ፥ ኑ ሂንቴናን ዬላታና፤ ቃሲ ሂንቴ ኑፔ ኣꬎ ዬላታና። ");
INSERT INTO gofENT_vpl VALUES ("C29_5","077_9_5","2CO","9","5","5","ሄሳ ጊሾ፥ ሃ ኢሻቲ ታፔ ሲንꬃቲዲ ሂንቴኮ ቢዲ፥ ሂንቴ ኢማና ጊዳ ኢሙዋ ካሴቲዲ ጊጊሳና ሜላ ታ ኤንታና ኪታስ። ታኒ ጋኪያ ዎዴ ሄ ኢሞይ ጊጊ ኡቴስ። ሄ ዎዴ ሄ ኬሃቴꬃ ኢሞይ ዎልቃን ጊዶናሺን ዶሳን ጊዴይሳ ኤሪሴስ። ");
INSERT INTO gofENT_vpl VALUES ("C29_6","077_9_6","2CO","9","6","6","ሃይሳ ኣኬኪቴ፤ ጉꬁ ዜሪዳይ ጉꬁ ጫካና፤ ዳሮ ዜሪዳይ ዳሮ ጫካና። ");
INSERT INTO gofENT_vpl VALUES ("C29_7","077_9_7","2CO","9","7","7","ፆሳይ ኡፋይሳን ኢሚያ ኡራ ዶሲያ ጊሾ ዎልቃን ዎይኮ ዶሲ ባይና ጊዶናሺን ኢሲ ኢሲ ኣሲ ባ ዎዛናን ቆፒዳይሳዳ ዶሳን ኢማናው ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("C29_8","077_9_8","2CO","9","8","8","ኡባ ዎዴ ኡባባን ኮሺያባ ኡባ ዴሚዲ ሎዖ ኦሶ ኡባ ኦꬃናው ዳንዳዓና ሜላ ፆሳይ ሂንቴው ባ ኣንጁዋ ዳርሳና። ");
INSERT INTO gofENT_vpl VALUES ("C29_9","077_9_9","2CO","9","9","9","ጌሻ ማፃፋን፥ «ኢ ባ ሻሉዋ ማንቆታስ ላሊስ፤ ኢያ ፂሎቴꬃይ ሜሪናው ዴዓና» ያጌስ። ");
INSERT INTO gofENT_vpl VALUES ("C29_10","077_9_10","2CO","9","10","10","ዜሬይሳስ ዜሬꬂ፥ ማናው ካꬂ ኢሚያ ጎዳይ፥ ሂንቴ ዜሪያ ዜሬꬃ ዳርሲዲ ኢማና። ሂንቴ ፂሎቴꬃ ኣይፊያካ ዳርሳና። ");
INSERT INTO gofENT_vpl VALUES ("C29_11","077_9_11","2CO","9","11","11","ዳሮ ኣሳይ ሂንቴ ኢሚያ ኢሙዋ ኑፔ ኤኪዲ፥ ፆሳ ጋላታናዳ፥ ሂንቴ ኡባ ዎዴ ዳርሲዲ ኢሜይሳታ ጊዳና ሜላ ፆሳይ ሂንቴና ኡባ ባጋራ ዱሬያና። ");
INSERT INTO gofENT_vpl VALUES ("C29_12","077_9_12","2CO","9","12","12","ሃ ሂንቴ ኢሚያ ኢሞይ ኣማኒያ ኣሳ ፓጫ ኩንꬆ ፃላላ ጊዶናሺን ኣሳይ ፆሳ ጋላታናው ጋሶ ጊዴስ። ");
INSERT INTO gofENT_vpl VALUES ("C29_13","077_9_13","2CO","9","13","13","ሃ ሂንቴ ኦሶይ ሂንቴ ኣማኑዋ ኤርሲዲ ኪሪስቶሳ ዎንጌላ ሂንቴ ኣማኒዲኔ ኢያው ኪቴቲዲ ሂንቴው ዴዒያባ ኤንታራኔ ሃራታራ ሻኬቲዳ ጊሾ ኡባይ ፆሳ ቦንቻና። ");
INSERT INTO gofENT_vpl VALUES ("C29_14","077_9_14","2CO","9","14","14","ፆሳይ ሂንቴው ኢሚዳ ኣꬎ ኬሃቴꬃ ጊሾ ኤንቲ ሂንቴው ፆሳ ዎሲሼ ሂንቴና ቤዓናው ላሞቶሶና። ");
INSERT INTO gofENT_vpl VALUES ("C29_15","077_9_15","2CO","9","15","15","ዛዊ ባይና ፆሳ ኢሙዋስ ፆሳይ ጋላቴቶ። ");
INSERT INTO gofENT_vpl VALUES ("C210_1","077_10_1","2CO","10","1","1","ታ ሂንቴራ ዴዒያ ዎዴ ሹጎ፥ ቃሲ ሂንቴፌ ሃኪያ ዎዴ ኑ ቦላ ሚኔስ ያጌቲዳ፥ ጳዉሎሲ፥ ኬሃኔ ኣሽኬ ጊዲዳ ኪሪስቶሳ ሱንꬃን ሂንቴና ዎሳይስ። ");
INSERT INTO gofENT_vpl VALUES ("C210_2","077_10_2","2CO","10","2","2","ታኒ ሂንቴኮ ቢያ ዎዴ ኑ ኣሾ ቆፋራ ሲሜሬቲያ ኣሲ ኦꬂዲ ቆፒያ ኣሳ ቦላ ሚኖ ቃላን ኦዴታናው ቆፋ ቃቻስ። ሂንቴ ቦላ ሄሳዳ ኦዴታና ሜላ ሂንቴ ታና ኦꬆናዳ ሂንቴና ዎሳይስ። ");
INSERT INTO gofENT_vpl VALUES ("C210_3","077_10_3","2CO","10","3","3","ኑኒ ሃ ሳዓን ዴዒኮካ ሃ ሳዓ ኣሳዳ ኦሌቶኮ። ");
INSERT INTO gofENT_vpl VALUES ("C210_4","077_10_4","2CO","10","4","4","ኑ ኦላ ሚሼይ ሃ ሳዓይሳ ጊዴና። ሺን ሚፃ ላላናው ዎልቃራ ዴዒያ ፆሳ ቶራ። ቱማራ ኤቄቲያ ፓላማኔ፥ ");
INSERT INTO gofENT_vpl VALUES ("C210_5","077_10_5","2CO","10","5","5","ፆሳ ኤሮና ሜላ ዲጊያ ኦቶሮ ቆፋ ኡባ ላሎስ። ኣሳ ቆፋ ኡባ ዲዒዲ ኪሪስቶሳስ ኪቴታና ሜላ ኦꬆስ። ");
INSERT INTO gofENT_vpl VALUES ("C210_6","077_10_6","2CO","10","6","6","ሂንቴ ኪቴቴꬃይ ፖሎ ጊዲያ ዎዴ ኑኒ ኪቴቴꬃ ኢፆ ኡባ ሴራናው ጊጌታና። ");
INSERT INTO gofENT_vpl VALUES ("C210_7","077_10_7","2CO","10","7","7","ሂንቴ ኣይፌይ ቤዒዳ ሜላ ፒርዴታ። ኦኒካ ባና ኪሪስቶሳባ ጊዲ ቆፒያባ ጊዲኮ፥ ኑካ ኪሪስቶሳባ ጊዴይሳ ኤሮ። ");
INSERT INTO gofENT_vpl VALUES ("C210_8","077_10_8","2CO","10","8","8","ጎዳይ ታው ኢሚዳ ማታን ጬቄቲኮካ ሄሳን ዬላቲኬ። ሄ ማታይ ታው ኢሜቲዳይ ሂንቴና ዲቻናሳፌ ኣቲን ቆሃናሳ ጊዴና። ");
INSERT INTO gofENT_vpl VALUES ("C210_9","077_10_9","2CO","10","9","9","ታኒ ታ ዳብዳቢያን ሂንቴና ያሺሳናው ኮያዳ ፃፊዳባ ዳኖፖ። ");
INSERT INTO gofENT_vpl VALUES ("C210_10","077_10_10","2CO","10","10","10","ኢሲ ኢሲ ኣሳይ፥ «ጳዉሎሳ ዳብዳቤይ ዴፆኔ ዎልቃማ፥ ሺን ኢያ ሶምዖን ቤዒያ ዎዴ ኢ ዳቡራንቾ፤ ኢያ ኦዳይካ ፓꬄና» ያጎሶና። ");
INSERT INTO gofENT_vpl VALUES ("C210_11","077_10_11","2CO","10","11","11","ሄ ኣሳቲ ኑ ሃሆን ዴዒሼ ፃፊያ ዳብዳቢያኒኔ ማታን ሂንቴራ ዴዒሼ ኦꬂያ ኦሱዋ ጊዶን ዱማቴꬂ ባይናይሳ ኣኬኮ። ");
INSERT INTO gofENT_vpl VALUES ("C210_12","077_10_12","2CO","10","12","12","ኑኒ ባንታና ናሺያ ኣሳታራ ኑና ጊናያናው ዎይኮ ጋዴያናው ኮዮኮ። ሺን ኤንቲ ባንታና ባንታራ ጊናዪዲ ዎይኮ ጋዴዪዲ ቤዒሼ ኤያ። ");
INSERT INTO gofENT_vpl VALUES ("C210_13","077_10_13","2CO","10","13","13","ሺን ኑኒ ፆሳይ ኑስ ኢሚዳ ꬋሳን ጬቄቶሲፔ ኣቲን ዛዋ ፒኒዲ ጬቄቶኮ፤ ሄ ዛዋይ ሂንቴኮካ ጋኬስ። ");
INSERT INTO gofENT_vpl VALUES ("C210_14","077_10_14","2CO","10","14","14","ኑኒ ቤሴይሳፌ ኣꬂዲ ጬቄቶኮ፥ ሺን ኪሪስቶሳ ዎንጌላ ሂንቴኮ ጋꬂዳይሳን ጬቄቶስ። ");
INSERT INTO gofENT_vpl VALUES ("C210_15","077_10_15","2CO","10","15","15","ኑኒ ፆሳይ ኤሲዳ ዛዋፔ ፒኒዲ፥ ሃራቲ ኦꬂዳ ኦሶን ጬቄቶኮ። ጊዶሺን፥ ሂንቴ ኣማኖይ ዲጫና ሜላ ፆሳይ ኢሚዳ ዛዋን ሂንቴ ጊዶን ኑ ኦꬂያ ኦሶይ ዳልጋና ጊዲ ቆፖስ። ");
INSERT INTO gofENT_vpl VALUES ("C210_16","077_10_16","2CO","10","16","16","ኑኒ ሃራ ኣሲ ባ ዛዋን ኦꬂዳ ኦሶን ጌሊዲ ጬቄቶኮ፥ ሺን ሂንቴፌ ፒኒዲ ሃራታስ ዎንጌላ ማርካታናው ዳንዳዖስ። ");
INSERT INTO gofENT_vpl VALUES ("C210_17","077_10_17","2CO","10","17","17","ሺን፥ ጌሻ ማፃፋን፥ «ጬቂያ ኡባይ ጎዳ ሎዖቴꬃን ጬቆ» ያጊዲ ፃፌቲስ። ");
INSERT INTO gofENT_vpl VALUES ("C210_18","077_10_18","2CO","10","18","18","ጎዳይ ናሺያ ኡራፔ ኣቲን ባና ባው ናሺያ ኡራይ ናሼቴና። ");
INSERT INTO gofENT_vpl VALUES ("C211_1","077_11_1","2CO","11","1","1","ታ ጉꬃ ኤያቴꬃ ሂንቴ ሃዒካ ዳንዳዓና ጋዳ ቆፓይስ፤ ሃያና ዳንዳዒቴ። ");
INSERT INTO gofENT_vpl VALUES ("C211_2","077_11_2","2CO","11","2","2","ፆሳይ ሂንቴው ቆፒዳይስሳዳ፥ ታካ ሂንቴው ቆፓይስ። ታኒ ሂንቴና ጌሻ ጌላዒዳ ኢሲ ኣዲያ፥ ኪሪስቶሳስ ኢማናው ኦይቻ ዎꬃስ። ");
INSERT INTO gofENT_vpl VALUES ("C211_3","077_11_3","2CO","11","3","3","ሺን ሾሻይ ባ ጌኒያን ሄዋኖ ባሌꬂዳይሳዳ ኦኒ ኤሪ ሂንቴ ዎዛናይ ኢቲዲ ኪሪስቶሳስ ዴዒያ ሂንቴ ሱሬቴꬃኔ ጌሻቴꬃ ኣጋንዴቲ ጋዳ ሂርጋይስ። ");
INSERT INTO gofENT_vpl VALUES ("C211_4","077_11_4","2CO","11","4","4","ኢሲ ኣሲ ዪዲ፥ ኑኒ ሂንቴው ማርካቲዳ ዬሱሳፔ ሃራ ዬሱሳ ሂንቴው ማርካቲኮ፥ ዎይኮ ሂንቴ ኤኪዳ ኣያናፔኔ ዎንጌላፔ ሃራ ኣያናኔ ዎንጌላ ሂንቴው ኦዲኮ፥ ሲዒ ጊዲ ኤኬታ። ");
INSERT INTO gofENT_vpl VALUES ("C211_5","077_11_5","2CO","11","5","5","ሺን ታኒ ዬሱስ ኪቲዳ «ጊታ ሃዋሬታፔ» ጉፃይስ ጋዳ ቆፒኬ። ");
INSERT INTO gofENT_vpl VALUES ("C211_6","077_11_6","2CO","11","6","6","ታኒ ኦዳ ኤሮና ኣሲ ጊዲኮካ፥ ኤራቴꬂ ታው ዴዔስ። ሄሳ ታ ሂንቴው ዳሮ ኦጌን ቆንጪሳስ። ");
INSERT INTO gofENT_vpl VALUES ("C211_7","077_11_7","2CO","11","7","7","ታኒ ሚሼ ኦይቾና ፆሳ ዎንጌላ ሂንቴው ጮ ኦዲዳይሲኔ ሂንቴና ꬎቁ ኦꬃዳ ታና ቶቺዳይሲ ታው ናጋራ ጊዲ? ");
INSERT INTO gofENT_vpl VALUES ("C211_8","077_11_8","2CO","11","8","8","ታኒ ሂንቴው ኦꬃናው ሃራ ዎሳ ኬꬃታፔ ሚሼ ቦንቃ ኤካስ። ");
INSERT INTO gofENT_vpl VALUES ("C211_9","077_11_9","2CO","11","9","9","ታ ሂንቴራ ዴዒያ ዎዴ ታና ሜቲንካ ሂንቴፌ ኢሲ ኣሲካ ዋይሳቢኬ። ማቄዶኒያፔ ዪዳ ኣማኔይሳቲ ታና ኮሺያባ ኡባን ማዲዶሶና። ሃቺ ጋካናው ታ ሂንቴው ቶሆ ጊዳቢኬ ሲንꬃስካ ቶሆ ጊዲኬ። ");
INSERT INTO gofENT_vpl VALUES ("C211_10","077_11_10","2CO","11","10","10","ኪሪስቶሳ ቱማቴꬃይ ታናን ዴዒሺን፥ ታ ጬቁዋ ኣካያ ቢታን ታና ኦኒካ ዲጌና። ");
INSERT INTO gofENT_vpl VALUES ("C211_11","077_11_11","2CO","11","11","11","ታ ሃይሳ ኣይስ ጋይና? ሂንቴና ዶሶና ጊሾሴዬ? ታኒ ሂንቴና ዶሴይሳ ፆሳይ ኤሬስ። ");
INSERT INTO gofENT_vpl VALUES ("C211_12","077_11_12","2CO","11","12","12","«ኑካ ሂንቴ ሜላ ኦꬆስ» ያጊዲ ጬቂያ ሃንኮ ሃዋሬታ ጬቁዋ ጋሱዋ ꬋይሳናው ሃዒ ታ ኦꬄይሳ ሲንꬃስካ ኦꬃና። ");
INSERT INTO gofENT_vpl VALUES ("C211_13","077_11_13","2CO","11","13","13","ሃይሳ ሜላ ኣሳቲ ኪሪስቶሳ ሃዋሬ ዳናናው ባንታና ላሚያ ዎርዳንቾ ሃዋሬታኔ ጪሚያ ኦሳንቾታ። ");
INSERT INTO gofENT_vpl VALUES ("C211_14","077_11_14","2CO","11","14","14","ሄሲ ማላሊሲያባ ጊዴና፤ ኣይስ ጊኮ፥ ፃላሄይ ፖዖ ኪታንቾ ዳናናው ባና ላሜስ። ");
INSERT INTO gofENT_vpl VALUES ("C211_15","077_11_15","2CO","11","15","15","ሄሳ ጊሾ፥ ፃላሄ ኦሳንቾቲ ፂሎቴꬃ ኦሳንቾታ ዳናናው ባንታና ላሚኮ ሄሲ ጊታባ ጊዴና። ኤንቲ ዉርሴꬃን ባንታ ኦሱዋዳ ኤካና። ");
INSERT INTO gofENT_vpl VALUES ("C211_16","077_11_16","2CO","11","16","16","ኦኒካ ታና ኤያ ጊዲ ቆፖና ሜላ ዛራዳካ ኦዳይስ። ታ ሂንቴው ኤያ ዳኒኮካ ታ ጉꬃራ ጬቄታና ሜላ ታና ኤያ ኦꬂዲ ኤኪቴ። ");
INSERT INTO gofENT_vpl VALUES ("C211_17","077_11_17","2CO","11","17","17","ታኒ ሃይሳዳ ጬቄታዳ ኦዴቴይ፥ ጎዳይ ኮዬይሳዳ ጊዶናሺን ኤያቴꬃን ኦዳይስ። ");
INSERT INTO gofENT_vpl VALUES ("C211_18","077_11_18","2CO","11","18","18","ዳሮ ኣሳይ ሃ ሳዓባን ጬቄቲያ ጊሾ ታካ ጬቄታና። ");
INSERT INTO gofENT_vpl VALUES ("C211_19","077_11_19","2CO","11","19","19","ሂንቴ ዎዛናማ ጊዲያ ጊሾ ኤያ ኣሳባ ኡፋይሳን ዳንዳዔታ። ");
INSERT INTO gofENT_vpl VALUES ("C211_20","077_11_20","2CO","11","20","20","ኦኒካ ሂንቴና ኣይሌይኮ ዎይኮ ሂንቴና ቦንቂኮ ዎይኮ ባው ማዴታናው ሂንቴኮ ሺቂኮ ዎይኮ ሂንቴ ቦላ ኦቶርቲኮ ዎይኮ ሂንቴና ባቂኮ ሂንቴ ዳንዳዔታ። ");
INSERT INTO gofENT_vpl VALUES ("C211_21","077_11_21","2CO","11","21","21","ኑኒ ሄሳ ኦꬃናው ዳሮ ዳቡራንቾ ጊዴይሳ ዬላታሼ ታ ኦዳይስ። ሺን ኦኒካ ሚኒዲ ጬቄቲኮ፥ ታካ ጬቄታናው ሚናይስ። ታኒ ሄሳ ኤያ ኣሳዳ ኦዴታይስ። ");
INSERT INTO gofENT_vpl VALUES ("C211_22","077_11_22","2CO","11","22","22","ኤንቲ ኢብራዌ? ታካ ኢብራዌ። ኤንቲ ኢስራዔሌ? ታካ ኢስራዔሌ። ኤንቲ ኣብራሃሜ ሼሼ? ታካ ኣብራሃሜ ሼሺ። ");
INSERT INTO gofENT_vpl VALUES ("C211_23","077_11_23","2CO","11","23","23","ኤንቲ ኪሪስቶሳ ኦሳናቾ? ታኒ ጎሻ ኣሳዳ ኦዳይስ፥ ኤንታፌ ኣꬊያ ኪሪስቶሳ ኦሳንቾ። ታኒ ኦሶን ዳሮ ዳቡራስ፤ ዳሮ ዎዴ ቃሼታስ፤ ጋራፌታስ፤ ዳሮ ዎዴ ሃይቆፔ ኣታስ። ");
INSERT INTO gofENT_vpl VALUES ("C211_24","077_11_24","2CO","11","24","24","ኣይሁዴቲ ታና ሃስታማኔ ኡዱፉና ኢቻሹ ቶሆ ጋራፊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("C211_25","077_11_25","2CO","11","25","25","ሄꬑ ቶሆ ፃምዓን ሾጬታስ፤ ኢሲ ቶሆ ሹቻን ጫዴታስ፤ ማርካቤይ ሄꬑ ቶሆ ሜዒስ፤ ኣባ ጊዶን ኢሲ ቃማ ኩሜꬂ ኣቃዳ ፔዓስ። ");
INSERT INTO gofENT_vpl VALUES ("C211_26","077_11_26","2CO","11","26","26","ታኒ ዳሮ ኦጊያ ዳቡራን ሃሙታስ። ኪፃ ሃꬃፌኔ ፓንጋፌ ኣታስ። ኣይሁዴቲኔ ኣይሁዴ ጊዶና ኣሳይ ታ ቦላ ሜቶ ጋꬂዶሶና። ካታማይ፥ ባዞይ፥ ኣባይ፥ ታና ያሺስ፤ ኣማኒያ ዳኒያ ኣሳቲ ታና ዋይሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("C211_27","077_11_27","2CO","11","27","27","ታኒ ኦሶን ዳቡራሲኔ ጫዋታስ፥ ዳሮ ቶሆ ꬊስኮ ꬋያስ፥ ኮሻታስ፥ ሳሞታስ፥ ዳሮ ቶሆ ፆማስ፥ ሜጌታስ፥ ካሎታስ። ");
INSERT INTO gofENT_vpl VALUES ("C211_28","077_11_28","2CO","11","28","28","ሃራባ ኡባ ታይቦና ኡባ ዎዴ ታና ቆፊሴይ ዎሳ ኬꬃታባ። ");
INSERT INTO gofENT_vpl VALUES ("C211_29","077_11_29","2CO","11","29","29","ኢሲ ኣሲ ዳቡሪያ ዎዴ ኢያራ ታ ዳቡራቢኪና? ኢሲ ኣሲ ናጋራን ꬉቤቲያ ዎዴ ታ ኣዉዴ ቂሮቶና ኣጋዲና? ");
INSERT INTO gofENT_vpl VALUES ("C211_30","077_11_30","2CO","11","30","30","ታ ጬቄታናው ኮሺያባ ጊዲኮ ታኒ ዳቡራንቾ ጊዴይሳ ኤሪሲያባን ጬቄታና። ");
INSERT INTO gofENT_vpl VALUES ("C211_31","077_11_31","2CO","11","31","31","ሜሪናው ቦንቼቲዳ ፆሳይ፥ ኑ ጎዳ ዬሱስ ኪሪስቶሳ ኣዋይ፥ ታ ዎርዶቶናይሳ ኤሬስ። ");
INSERT INTO gofENT_vpl VALUES ("C211_32","077_11_32","2CO","11","32","32","ዳማስቆ ካታማን ኣሬታሳ ጊያ ካዉዋፔ ጋርሳራ ሃሬይሲ ታና ኦይꬃናው ኮዪዲ ዳማስቆ ካታማ ፔንጊያ ናጊሲስ። ");
INSERT INTO gofENT_vpl VALUES ("C211_33","077_11_33","2CO","11","33","33","ሺን ኣሳይ ታና ዳቾን ዬጊዲ፥ ካታማ ዲርሳ ማስኮቲያራ ዎꬊሲን ታኒ ኢያ ኩሺያፔ ኣታስ። ");
INSERT INTO gofENT_vpl VALUES ("C212_1","077_12_1","2CO","12","1","1","ጬቄቴꬃስ ጎዒ ባይናይሳ ኤራይስ። ሺን ጬቄታናው ኮሺኮ፥ ጎዳፔ ኤኪዳ ቆንጬꬃን ጬቃና። ");
INSERT INTO gofENT_vpl VALUES ("C212_2","077_12_2","2CO","12","2","2","ታማኔ ኦይዱ ላይꬃፌ ካሴ፥ ኪሪስቶሳ ኣማኒያ ኢሲ ኡራይ ሄꬓንꬆ ሳሉዋ ቢዳይሳ ታ ኤራይስ። ሄ ኡራይ ኣሾን ዎይኮ ኣሾፔ ካሬራ ቢዳኮ ታ ኤሪኬ፤ ፆሳይ ኤሬስ። ");
INSERT INTO gofENT_vpl VALUES ("C212_3","077_12_3","2CO","12","3","3","ሄ ኡራይ ሄꬓንꬆ ሳሉዋ ኤኬቲዳይሳ ኤራይስ። ሺን ኢ ኣሾን ዎይኮ ኣሾፔ ካሬራ ኤኬቲዳኮ ታ ኤሪኬ፤ ፆሳይ ኤሬስ። ");
INSERT INTO gofENT_vpl VALUES ("C212_4","077_12_4","2CO","12","4","4","ሄ ኡራይ ጋናቴ ኤኬቲዲ ኣሲ ቆንጪሳናዉኔ ኣሲ ኦዳናው ዳንዳዖናባ ሲዒስ። ");
INSERT INTO gofENT_vpl VALUES ("C212_5","077_12_5","2CO","12","5","5","ታኒ ሄ ኣዲያባን ጬቄታና፥ ሺን ታኒ ታ ዳቡራፔ ኣቲን ታናን ጬቄቲያባይ ባዋ። ");
INSERT INTO gofENT_vpl VALUES ("C212_6","077_12_6","2CO","12","6","6","ታኒ ቱማ ኦዴቲያ ጊሾ ጬቄታናው ኮይኮካ ኤያ ጊዲኬ። ሺን ኣሲ ታ ኦꬄይሳ ቤዔይሳፌኔ ሲዔይሳፌ ኣꬂዲ ቆፖና ሜላ ጋዳ ጬቄቴꬂ ኣጋይስ። ");
INSERT INTO gofENT_vpl VALUES ("C212_7","077_12_7","2CO","12","7","7","ታው ቆንጪዳ ጊታ ቆንጬꬃን ታ ኦቶርቶና ሜላ ታና ዋይሳናው ታ ኣሹዋን ጫዲያ ፃላሂያ ኪታንቾይ ታው ኢሜቲስ። ");
INSERT INTO gofENT_vpl VALUES ("C212_8","077_12_8","2CO","12","8","8","ሃ ዋይሲያባ ታፔ ዲጋና ሜላ ታኒ ጎዳ ሄꬑ ቶሆ ዎሳስ። ");
INSERT INTO gofENT_vpl VALUES ("C212_9","077_12_9","2CO","12","9","9","ሺን ጎዳይ፥ «ታ ዎልቃይ ኔ ዳቡራን ቆንጪያ ጊሾ ታ ኣꬎ ኬሃቴꬃይ ኔው ጊዳና» ያጊስ። ኪሪስቶሳ ዎልቃይ ታናን ቆንጫና ሜላ ታ ዳቡራን ኡፋይታሼ ጬቄታይስ። ");
INSERT INTO gofENT_vpl VALUES ("C212_10","077_12_10","2CO","12","10","10","ታኒ ኪሪስቶሳ ጊሾ ዳቡሪያ ዎዴ ጫዬቲያ ዎዴ ዋዬቲያ ዎዴ ጎዴቲያ ዎዴ ሜቶቲያ ዎዴ ታ ዳቡራን ኡፋይታይስ። ኣይስ ጊኮ፥ ታ ዳቡሪያ ዎዴ ሄ ዎዴ ሚናይስ። ");
INSERT INTO gofENT_vpl VALUES ("C212_11","077_12_11","2CO","12","11","11","ታኒ ኤያ ኣሳዳ ጬቄታስ። ሄሳዳ ታ ጬቄታና ሜላ ኦꬂዳይ ሂንቴና። ታ፥ ታ ሁዔን ኤሬቶና ኣሲ ጊዲኮካ፥ «ጊታ ሃዋሬታ» ጌቴቴይሳታፔ ጉፂኬ። ሄሳ ታው ማርካታናው ቤሴይ ሂንቴናሺን። ");
INSERT INTO gofENT_vpl VALUES ("C212_12","077_12_12","2CO","12","12","12","ታ ሂንቴ ጊዶን ዴዓሼ ዳንዳዓን ኦꬂዳ ማላታቲኔ ማላቲ ታ ቱማ ሃዋሬ ጊዴይሳ ቤሶሶና። ");
INSERT INTO gofENT_vpl VALUES ("C212_13","077_12_13","2CO","12","13","13","ታ ሂንቴው ቶሆ ጊዶናይሳፌ ኣቲን ሃራ ዎሳ ኬꬃታፔ ሂንቴ ኣይቢን ጉፂዴቲ? ሄሲ ባላ ጊዲኮ ታና ማሪቴ። ");
INSERT INTO gofENT_vpl VALUES ("C212_14","077_12_14","2CO","12","14","14","ታኒ ሂንቴኮ ባናው ጊጌቲሺን ሃይሲ ታው ሄꬓንꬆ። ታ ሂንቴናፔ ኣቲን ሂንቴው ዴዒያባ ኮዮና ጊሾ ሂንቴና ዋይሳናው ኮዪኬ። ዬሊዳይሳቲ ባንታ ናይታስ ሻሎ ሚንጆሶናፔ ኣቲን ናይቲ ባንታና ዬሊዳይሳታስ ሻሎ ሚንጆኮና። ");
INSERT INTO gofENT_vpl VALUES ("C212_15","077_12_15","2CO","12","15","15","ታ ሂንቴ ጊሾ ታው ዴዒያባኔ ታና ኣꬃ ኢሚንካ ታና ኡፋይሴስ። ያቲን፥ ታኒ ሂንቴና ሄሳዳ ኬሃ ሲቂያ ዎዴ ሂንቴ ታና ጉꬃራ ሲቄቲ? ");
INSERT INTO gofENT_vpl VALUES ("C212_16","077_12_16","2CO","12","16","16","ጊዲኮካ፥ ታ ሂንቴው ቶሆ ጊዲኬ፤ ዋይሳቢኬ፤ ሺን ሂንቴና ጪሞኒኔ ጌኔን ኦይኪዳባ ሂንቴው ዳኖና ኣጌና። ");
INSERT INTO gofENT_vpl VALUES ("C212_17","077_12_17","2CO","12","17","17","ሃሪ ኣቶሺን፥ ታ ሂንቴኮ ኪቲዳ ኣሳታፔ ሂንቴና ጪሚዳ ኣሲ ዴዒ? ");
INSERT INTO gofENT_vpl VALUES ("C212_18","077_12_18","2CO","12","18","18","ቲቶይ ሂንቴኮ ባና ሜላ ታኒ ዎሳስ፤ ቃሲ ኣማኒያ ኢሻካ ኢያራ ዬዳስ። ያቲን፥ ቲቶይ ሂንቴና ጪሚዴ? ኑኒ ኑ ኦሱዋ ኢሲ ኣያናን ኦꬂቦኮ? ቃሲ ኑ ሃኖይካ ኢሲኖ ጊዴኔ? ");
INSERT INTO gofENT_vpl VALUES ("C212_19","077_12_19","2CO","12","19","19","ኑ ኡባ ዎዴ ሂንቴ ሲንꬃን ኑና ፂሊሳናው ሞቴቲያባ ሂንቴው ዳኒ? ኑ ኪሪስቶሳን ዴዒዲ ፆሳ ሲንꬃን ሃዒ ጋካናው ኦዶስ። ኑ ሲቆ ኢሻቶ፥ ኑ ሃ ኡባ ኦꬄይ ሂንቴና ዲቻናሳ። ");
INSERT INTO gofENT_vpl VALUES ("C212_20","077_12_20","2CO","12","20","20","ታ ሂንቴኮ ቢያ ዎዴ ኦኒ ኤሪ ሂንቴ ታ ኮዬይሳዳ ሃኖና፥ ቃሲ ታካ ሂንቴ ኮዬይሳዳ ሃኖና ጋሄቶና ኣጎኮ ጋዳ ያያይስ። ቃሲ ኦኒ ኤሪ ሂንቴ ጊዶን ፓላሚ፥ ቃናቴይ፥ ሃንቆይ፥ ዪቄይ፥ ዚጊርሲ፥ ኣሳ ሱንꬁ ኢሶይ፥ ኦቶሮይኔ ካቺ ዶና ኣጌና ጋዳ ያያይስ። ");
INSERT INTO gofENT_vpl VALUES ("C212_21","077_12_21","2CO","12","21","21","ታኒ ናምዓንꬆ ሂንቴኮ ቢያ ዎዴ ፆሳይ ሂንቴ ሲንꬃን ታና ካዉሻና ጋዳ ያያይስ። ካሴ ናጋራ ኦꬂዲ ሄ ባንታ ኦꬂዳ ቱናቴꬃፌ፥ ላይማቴꬃፌኔ ዬላያ ኦሱዋፔ ሲሚቦና ኣሳታ ቤዓዳ ኣዛኖና ኣጊኬ ጋዳ ያያይስ። ");
INSERT INTO gofENT_vpl VALUES ("C213_1","077_13_1","2CO","13","1","1","ታ ሂንቴኮ ቢሺን ሃይሲ ሄꬓንꬆ። ኣይ ሞቶይካ ናምዑ ዎይኮ ሄꬑ ማርካን ሚኔስ። ");
INSERT INTO gofENT_vpl VALUES ("C213_2","077_13_2","2CO","13","2","2","ታኒ ናምዓንꬆ ሂንቴራ ጋሄቲዳ ዎዴ ሂንቴ ጊዶን ካሴ ናጋራ ኦꬂዳ ኡራኔ ሃራታ ኡባ ሴሮና ኣጊኬ ጋዳ ኦዳ ዎꬃስ። ሃዒ ታ ሃካዳ ዴዒኮካ ሲማዳ ሂንቴኮ ቢያ ዎዴ ኦዴስካ ቃꬌቲኬ። ");
INSERT INTO gofENT_vpl VALUES ("C213_3","077_13_3","2CO","13","3","3","ታናን ዴዒዲ ኦዴይ ኪሪስቶሳ ጊዴይሳ ሂንቴ ኤራናው ኮዬታ። ኢ ሂንቴራ ሃሳያ ዎዴ ዎልቃማፔ ኣቲን ሂንቴ ጊዶን ዳቡራንቾ ጊዴና። ");
INSERT INTO gofENT_vpl VALUES ("C213_4","077_13_4","2CO","13","4","4","ኪሪስቶሲ ማስቃሊያ ቦላ ዳቡራን ካቄቲስ፥ ሺን ፆሳ ዎልቃን ዴዖን ዴዔስ። ኢ ዳቡራንቾ ጊዲዳይሳዳ፥ ኑካ ዳቡራንቾ። ሺን ሂንቴና ሃጋዛናው ፆሳ ዎልቃን ኢያራ ዴዖን ዳና። ");
INSERT INTO gofENT_vpl VALUES ("C213_5","077_13_5","2CO","13","5","5","ኣማኖን ሚኒዲ ዴዒያኮ ሂንቴና ሂንቴው ፓጪ ቤዒቴ። ፓጬን ሂንቴ ኩንዶና ኣቲኮ፥ ኪሪስቶሲ ሂንቴናን ዴዔይሳ ሂንቴ ኤሬታ። ሺን ኪሪስቶሲ ሂንቴናን ዶና ኢፂኮ ሂንቴ ኩንዴታ። ");
INSERT INTO gofENT_vpl VALUES ("C213_6","077_13_6","2CO","13","6","6","ኑኒ ፓጬን ኩንዶናይሳ ሂንቴ ኤሬታ ጋዳ ኣማናይስ። ");
INSERT INTO gofENT_vpl VALUES ("C213_7","077_13_7","2CO","13","7","7","ሂንቴ ኢታባ ኦꬆና ሜላ ኑኒ ፆሳ ዎሶስ። ኑኒ ሚኖ ጊዴይሳ ኣሳይ ቤዓና ሜላ ጊዶናሺን ኑኒ ሚኖ ጊዶና ኢፂኮካ፥ ሂንቴ ሎዖ ኦꬃና ሜላ ኑኒ ዎሶስ። ");
INSERT INTO gofENT_vpl VALUES ("C213_8","077_13_8","2CO","13","8","8","ኑኒ ቱማስ ኦꬆሲፔ ኣቲን ቱማራ ኤቄቲያባ ኣይባካ ኦꬆኮ። ");
INSERT INTO gofENT_vpl VALUES ("C213_9","077_13_9","2CO","13","9","9","ኑ ዳቡሪያ ዎዴ ሂንቴ ቃሲ ሚኒያ ዎዴ ኑና ኡፋይሴስ። ሂንቴ ቦሬይ ባይናይሳታ ጊዳና ሜላ ኑ ሂንቴው ፆሳ ዎሶስ። ");
INSERT INTO gofENT_vpl VALUES ("C213_10","077_13_10","2CO","13","10","10","ታኒ ሂንቴፌ ሃካዳ ዴዓሼ ፃፊዳይ ሄሳ ጊሾሳ። ታኒ ሂንቴኮ ቢያ ዎዴ ጎዳይ ታው ኢሚዳ ማታን ዜምፓዳ ሂንቴ ቦላ ጎዳታናው ኮዪኬ። ጎዳይ ታው ማታ ኢሚዳይ፥ ሂንቴና ማዳናሳፌ ኣቲን ቆሃናሳ ጊዴና። ");
INSERT INTO gofENT_vpl VALUES ("C213_11","077_13_11","2CO","13","11","11","ዉርሴꬃን ታ ኢሻቶ፥ ሳሮ ዴዒቴ። ቦሬይ ባይና ዴዒቴ፤ ታ ዞሪያ ሲዒቴ። ኢሲ ዎዛናን ጊዲዲ ዴዒቴ፤ ሳሮቴꬃን ዴዒቴ። ሲቆኔ ሳሮ ኢሚያ ፆሳይ ሂንቴራ ጊዶ። ");
INSERT INTO gofENT_vpl VALUES ("C213_12","077_13_12","2CO","13","12","12","ጌሻ ዬሬቴꬂ ዬሬቲሼ፥ ኢሶይ ኢሱዋ ሳሮꬂቴ። ");
INSERT INTO gofENT_vpl VALUES ("C213_13","077_13_13","2CO","13","13","13","ፆሳ ኣሳ ኡባይ ሂንቴና ሳሮ ሳሮ ያጎሶና። ");
INSERT INTO gofENT_vpl VALUES ("C213_14","077_13_14","2CO","13","14","14","ጎዳ ዬሱስ ኪሪስቶሳ ኣꬎ ኬሃቴꬃይ፥ ፆሳ ሲቆይ፥ ጌሻ ኣያና ኢሲፌቴꬃይ ሂንቴ ኡባራ ጊዶ። ");
INSERT INTO gofENT_vpl VALUES ("GL1_1","078_1_1","GAL","1","1","1","ኣሳፔ ዎይኮ ኣሳ ባጋራ ጊዶናሺን ዬሱስ ኪሪስቶሳፔኔ ኢያ ሃይቆፔ ዴንꬂዳ ፆሳ ኣዋፔ ሃዋሬ ጊዳና ሜላ ኪቴቲዳ ታ ጳዉሎሲ፥ ");
INSERT INTO gofENT_vpl VALUES ("GL1_2","078_1_2","GAL","1","2","2","ታራ ዴዒያ ኣማኒያ ኢሻቲ ኡባይ፥ ጋላቲያን ዴዒያ ዎሳ ኬꬃታስ ኪቲዳ ኪታ። ");
INSERT INTO gofENT_vpl VALUES ("GL1_3","078_1_3","GAL","1","3","3","ፆሳይ ኑ ኣዋይኔ ኑ ጎዳ ዬሱስ ኪሪስቶሲ ሂንቴው ኣꬎ ኬሃቴꬃኔ ሳሮቴꬃ ኢሞ። ");
INSERT INTO gofENT_vpl VALUES ("GL1_4","078_1_4","GAL","1","4","4","ሃ ኢታ ዎዲያፔ ኑና ኣሻናው፥ ኑ ፆሳ፥ ኑ ኣዋ ሼኔን ኪሪስቶሲ ኑ ናጋራ ጊሾ ባና ኣꬂ ኢሚስ። ");
INSERT INTO gofENT_vpl VALUES ("GL1_5","078_1_5","GAL","1","5","5","ፆሳስ ሜሪናፔ ሜሪና ጋካናው ቦንቾይ ጊዶ። ኣሚንዒ። ");
INSERT INTO gofENT_vpl VALUES ("GL1_6","078_1_6","GAL","1","6","6","ኪሪስቶሳ ኣꬎ ኬሃቴꬃን ሂንቴና ፄጊዳ ፆሳ ኣጊዲ፥ ሃራ ዎንጌላኮ፥ ሂንቴ ኤሌሲዲ፥ ዋኒዲ ሲሚዳኮ ታና ማላሊሴስ። ");
INSERT INTO gofENT_vpl VALUES ("GL1_7","078_1_7","GAL","1","7","7","ሂንቴና ባሌꬃናዉኔ ኪሪስቶሳ ዎንጌላ ዎቢሳንው ኮያ ጉꬃ ኣሳቲ ዴዖሶናፔ ኣቲን ቱማ ዎንጌላይ ኢሲኖ። ");
INSERT INTO gofENT_vpl VALUES ("GL1_8","078_1_8","GAL","1","8","8","ሺን ኑና ጊዲን ዎይኮ ሳሎ ኪታንቾ ጊዲን ኑኒ ሂንቴው ኮይሮ ኦዲዳ ዎንጌላፔ ዱማቲያ ሃራ ዎንጌላ ሂንቴው ኦዲያባ ጊዲኮ፥ ኢ ቃንጌቲዳባ ጊዶ። ");
INSERT INTO gofENT_vpl VALUES ("GL1_9","078_1_9","GAL","1","9","9","ሃይሳፌ ሲንꬄ ኑኒ ጊዳይሳዳ ሃዒካ ዛራዳ ጋይስ። ሂንቴ ኤኪዳ ዎንጌላፔ ዱማቲያ ዎንጌላ ኦኒካ ሂንቴው ኦዲኮ ሄ ኡራይ ቃንጌቲዳባ ጊዶ። ");
INSERT INTO gofENT_vpl VALUES ("GL1_10","078_1_10","GAL","1","10","10","ያቲን፥ ታና ኣሲ ናሻና ሜላ ኮያይናዬ? ዎይኮ ፆሲ ናሻና ሜላ ኮያይና? ዎይኮ ታ ኣሴ ኡፋይሳናው ኮያይና? ታ ኣሴ ኡፋይሳናው ኮያባ ጊዲኮ፥ ኪሪስቶሳ ኣይሌ ጊዲኬ። ");
INSERT INTO gofENT_vpl VALUES ("GL1_11","078_1_11","GAL","1","11","11","ታ ኢሻቶ፥ ታ ሂንቴው ኦዲዳ ዎንጌላይ ኣሳፔ ጊዶናይሳ ሂንቴ ኤራና ሜላ ታ ኮያይስ። ");
INSERT INTO gofENT_vpl VALUES ("GL1_12","078_1_12","GAL","1","12","12","ታው ሃ ዎንጌላ ዬሱሲ ኪሪስቶሲ ቆንጪሲሲፔ ኣቲን ኣሳፔ ኤካቢኬ ዎይኮ ኣሲ ታና ታማርሲቤና። ");
INSERT INTO gofENT_vpl VALUES ("GL1_13","078_1_13","GAL","1","13","13","ታ ካሴ ኣይሁዴ ኣማኖን ዴዒያ ዎዴ ዋና ዴዒዳኮ፥ ሂንቴ ሲዒዴታ። ታ ዎሳ ኬꬃ ቃꬌይ ባይና ጎዳናዉኔ ꬋይሳናው ባፄታስ። ");
INSERT INTO gofENT_vpl VALUES ("GL1_14","078_1_14","GAL","1","14","14","ኣይሁዴ ኣማኖ ናጎን፥ ታ ዎዴን ዴዒያ ኣይሁዴ ኢሻታፔ ኣꬋይስ። ኑ ኣዋታ ዎጋስካ ኣꬋዳ ሚሼታይስ። ");
INSERT INTO gofENT_vpl VALUES ("GL1_15","078_1_15","GAL","1","15","15","ሺን ታ ቡሮ ታ ኣዬ ኡሎን ዴዒሺን ፆሳይ ታና ዶሪስ፤ ባ ኣꬎ ኬሃቴꬃን ታና ፄጊስ። ");
INSERT INTO gofENT_vpl VALUES ("GL1_16","078_1_16","GAL","1","16","16","ኣይሁዴ ጊዶና ኣሳስ ዎንጌላ ኦዳና ሜላ ፆሳይ ባ ናዓ ታው ቆንጪሲዳ ዎዴ ታ ኦዴራካ ዞሬታቢኬ። ");
INSERT INTO gofENT_vpl VALUES ("GL1_17","078_1_17","GAL","1","17","17","ዎይኮ ታፔ ሲንꬄ ሃዋሬ ጊዲዳይሳታራ ጋሄታናው ዬሩሳላሜ ባቢኬ። ሺን ታ ካሴታዳ ኣራቤ ቢታ ባስ፤ ሄሳፌ ሲማዳ ዳማስቆ ካታማ ያስ። ");
INSERT INTO gofENT_vpl VALUES ("GL1_18","078_1_18","GAL","1","18","18","ሄꬑ ላይꬃፌ ጉዬ፥ ጴፂሮሳራ ጋሄታናው ዬሩሳላሜ ባዳ ኢያራ ታማኔ ኢቻሹ ጋላስ ኡታስ። ");
INSERT INTO gofENT_vpl VALUES ("GL1_19","078_1_19","GAL","1","19","19","ሺን ጎዳ ኢሻ ያይቆባፔ ኣቲን ሃንኮ ሃዋሬታ ቤዓቢኬ። ");
INSERT INTO gofENT_vpl VALUES ("GL1_20","078_1_20","GAL","1","20","20","ታ ሂንቴው ፃፊይዳይሲ ዎርዶ ጊዶናይሳ ፆሳ ሲንꬃን ሂንቴው ቆንጪሳይስ። ");
INSERT INTO gofENT_vpl VALUES ("GL1_21","078_1_21","GAL","1","21","21","ሄሳፌ ጉዬ፥ ታኒ ሶሪያ ቢታኔ ኪልቂያ ቢታ ባስ። ");
INSERT INTO gofENT_vpl VALUES ("GL1_22","078_1_22","GAL","1","22","22","ዪሁዳን ዴዒያ ዎሳ ኬꬃ ኣሳይ ታና ቤዒዲ ኤሪቦኮና። ");
INSERT INTO gofENT_vpl VALUES ("GL1_23","078_1_23","GAL","1","23","23","ሺን ኤንቲ፥ «ካሴ ኑና ጎዲያ ኡራይ፥ ሃዒ ሄ ኢ ꬋይሳናው ኮያ ኣማኑዋባ ሳባኬስ» ያጌይሳ ሲዒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("GL1_24","078_1_24","GAL","1","24","24","ሲዒዳ ኡባይ ታ ጋሶን ፆሳ ጋላቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("GL2_1","078_2_1","GAL","2","1","1","ታማኔ ኦይዱ ላይꬃፌ ጉዬ፥ ባርናባሳራ ዛራዳ ዬሩሳላሜ ባስ። ሄ ዎዴ ቲቶ ታራ ኤካዳ ባስ። ");
INSERT INTO gofENT_vpl VALUES ("GL2_2","078_2_2","GAL","2","2","2","ፆሳይ ታው ቆንጪሲዳ ቆንጬꬃን ያ ባዳ ኣይሁዴ ጊዶና ኣሳ ጊዶን ታ ሳባኪያ ዎንጌላ ኤንታው ቆንጪሳስ። ካሴ ታ ዎፂዳ ዎꬃይኔ ሃዒካ ታ ዎፂያ ዎꬃይ ሃዳ ጊዶና ሜላ ጋዳ ካሌꬄይሳታ ዱማ ሺሻዳ ኤንታው ኦዳስ። ");
INSERT INTO gofENT_vpl VALUES ("GL2_3","078_2_3","GAL","2","3","3","ሃሪ ኣቶሺን፥ ታራ ዴዒያ ቲቶይ ጊሪኬ ኣሲ ጊዲኮካ፥ ቃፃሬቶ ጊዲ ኡንዔꬂቦኮና። ");
INSERT INTO gofENT_vpl VALUES ("GL2_4","078_2_4","GAL","2","4","4","ጊዶሺን፥ ኣማኒያ ኢሻታ ዳኒዲ ኑ ጊዶ ጌሊዳ ኢሶቲ ኢሶቲ ኢ ቃፃሬታና ሜላ ኮዪዶሶና። ሄ ኣሳቲ ኪሪስቶስ ዬሱሳን ኑስ ዴዒያ ላዓቴꬃ ዎቺዲ ቤዓናው ጌማን ኑ ጊዶ ጌሊዲ ዛሪዲ ኑና ኣይሌ ኦꬃናው ኮዮሶና። ");
INSERT INTO gofENT_vpl VALUES ("GL2_5","078_2_5","GAL","2","5","5","ሺን ቱማ ዎንጌላይ ሂንቴናን ሚኒዲ ዳና ሜላ ኑኒ ሃሪ ኣቶሺን፥ ጉꬃ ዎዴስካ ኤንታው ኩሼ ኢሚቦኮ። ");
INSERT INTO gofENT_vpl VALUES ("GL2_6","078_2_6","GAL","2","6","6","ሺን ሃላቃ ዳኒያ ኣሳታ ኦናቴꬃይ ታው ኣይኮካ ጊዴና። ፆሳይ ኣሳ ሶምዖ ቤዒዲ ፒርዴና። ሃ ኣሳቲ ታ ማርካቲያ ዎንጌላ ቦላ ጉጂዳባይ ባዋ። ");
INSERT INTO gofENT_vpl VALUES ("GL2_7","078_2_7","GAL","2","7","7","ሺን ጴፂሮሲ፥ ኣይሁዴታስ ዎንጌላ ኦዳና ሜላ ፆሳይ ኢያው ሃዳራ ኢሚዳይሳዳ ታዉካ ኣይሁዴ ጊዶና ኣሳስ ዎንጌላ ኦዲያ ሃዳራ ኢሚዳይሳ ኤንቲ ጉዬፔ ቤዒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("GL2_8","078_2_8","GAL","2","8","8","ሂዛ፥ ጴፂሮሲ ኣይሁዴታ ሃዋሬ ጊዳና ሜላ ኦꬂዳ ፆሳይ፥ ታካ ኣይሁዴ ጊዶና ኣሳስ ሃዋሬ ጊዳና ሜላ ኦꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("GL2_9","078_2_9","GAL","2","9","9","ቃሲ ቱሱ ዳኒዲ ቤንቲያ ያይቆቢ፥ ጴፂሮሲኔ ዮሃኒሲ፥ ታው ኢሜቲዳ ኣꬎ ኬሃቴꬃ ቤዒዳ ዎዴ ኑራ ኢሲፊዳይሳ ቆንጪሳናው ታ ኩሺያኔ ባርናባሳ ኩሺያ ኦይኪዶሶና። ኑኒ ኣይሁዴ ጊዶና ኣሳኮ፥ ቃሲ ኤንቲ ኣይሁዴ ኣሳኮ ባናው ጊጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("GL2_10","078_2_10","GAL","2","10","10","ኤንቲ ኑና ሚንꬂዲ ሃዳራ ጊዳይ፥ ኑኒ ማንቆታስ ቆፓናይሳ። ካሴካ ታ ሄሳ ኦꬃናው ኣሞቴይስ። ");
INSERT INTO gofENT_vpl VALUES ("GL2_11","078_2_11","GAL","2","11","11","ጴፂሮሲ ኣንፆኪያ ካታማ ዪዳ ዎዴ ኢ ባሊዳ ጊሾ ታኒ ኢያ ሶምዖን «ኔኒ ባላዳሳ» ጋስ። ");
INSERT INTO gofENT_vpl VALUES ("GL2_12","078_2_12","GAL","2","12","12","ያይቆቢ ኪቲዳ ጉꬃ ኣሳይ ያናፔ ሲንꬄ ኢ ኣይሁዴ ጊዶና ኣሳራ ሜስ፥ ሺን ኤንቲ ዪዳፔ ጉዬ፥ «ኣይሁዴ ጊዶና ኣሳፔ ኣማኒዳይሳቲ ቃፃሬታናው ቤሴስ» ጊያ ኣሳስ ያዪዲ ኤንታፌ ሻኬቲስ። ");
INSERT INTO gofENT_vpl VALUES ("GL2_13","078_2_13","GAL","2","13","13","ቃሲ ሃንኮ ኣማኒዳ ኣይሁዴቲ ጴፂሮሳ ሃኑዋ ካሊዶሶና። ሃሪ ኣቶሺን፥ ባርናባሲካ ኢያ ቆፋን ጎሼቲስ። ");
INSERT INTO gofENT_vpl VALUES ("GL2_14","078_2_14","GAL","2","14","14","ሺን ኤንቲ ዎንጌላ ቱማቴꬃን ሱሬ ሃሙቶናይሳ ቤዓዳ፥ ጴፂሮሳ ኣሳ ኡባ ሲንꬃን፥ «ኔኒ ኣይሁዴ ጊዳሼ፥ ኣይሁዴ ዎጋꬆ ጊዶናሺን ኣይሁዴ ጊዶና ኣሳዳ ዴዓሳ፤ ያቲን፥ ዋናዳ ኣይሁዴ ጊዶናይሳታ፥ ‹ኣይሁዴ ዎጋን ዴዒቴ ጋዳ ዎልቃታይ?› » ያጋስ። ");
INSERT INTO gofENT_vpl VALUES ("GL2_15","078_2_15","GAL","2","15","15","ኑኒ ዬሌታን ኣይሁዴ፥ ሺን ናጋራንቾ ጊዲዳ ኣይሁዴ ጊዶና ኣሳ ሜላ ጊዶኮ። ");
INSERT INTO gofENT_vpl VALUES ("GL2_16","078_2_16","GAL","2","16","16","ሺን ኣሲ ዬሱስ ኪሪስቶሳ ኣማኒዲ ፂሌሲፔ ኣቲን ሂጌ ናጊዲ ፂሎናይሳ ኤሮስ። ኦኒካ ሂጌ ናጊዲ ፂሎና ጊሾ ኑካ ሂጌ ናጊዲ ጊዶናሺን ኪሪስቶሳን ኣማኒዲ ፂላና ሜላ ኪሪስቶስ ዬሱሳ ኣማኒዳ። ");
INSERT INTO gofENT_vpl VALUES ("GL2_17","078_2_17","GAL","2","17","17","ኑ ኣይሁዴቲካ ኪሪስቶሳ ባጋራ ፂላናው ኮሼስ። ሄሳ ጊዲኮ ኑካ ሃራ ኣሳዳ ናጋራንቾ ጊዴይሳ ቤዖስ። ያቲን፥ ኑ ናጋራ ኦꬃና ሜላ ዴንꬄꬄይ ኪሪስቶሳ ጉሴዬ? ኡባካ ጊዴና! ");
INSERT INTO gofENT_vpl VALUES ("GL2_18","078_2_18","GAL","2","18","18","ሂዛ፥ ታ ላሊዳይሳ ዛራዳ ኬፂያባ ጊዲኮ ታኒ ታ ሁዔን ሂጌ ሜንꬄይሳ ጊዴይሳ ቆንጪሳይስ። ");
INSERT INTO gofENT_vpl VALUES ("GL2_19","078_2_19","GAL","2","19","19","ታኒ ፆሳስ ዳና ሜላ ሂጌ ባጋራ ሂጌስ ሃይቃስ። ");
INSERT INTO gofENT_vpl VALUES ("GL2_20","078_2_20","GAL","2","20","20","ታኒ ኪሪስቶሳራ ማስቃሊያ ቦላ ካቄታስ። ታኒ ሂዛፔ ታው ዴዒኬ፥ ሺን ኪሪስቶሲ ታናን ዴዔስ። ታ ሃዒ ዴዒያ ዴዑዋ፥ ታና ዶሲዲ ታ ጊሾ ባና ኣꬂ ኢሚዳ ፆሳ ናዓ ኣማናዳ ዴዓይስ። ");
INSERT INTO gofENT_vpl VALUES ("GL2_21","078_2_21","GAL","2","21","21","ታኒ ፆሳ ኣꬎ ኬሃቴꬃ ሃዳ ኦꬂኬ። ፂሎቴꬂ ኣሳስ ሂጌ ባጋራ ቤንቲያባ ጊዲያኮ፥ ኪሪስቶሲ ጮ ሃይቂስ ጉሱ። ");
INSERT INTO gofENT_vpl VALUES ("GL3_1","078_3_1","GAL","3","1","1","ሂንቴኖ፥ ኣኬኪ ባይና ጋላቲያ ኣሳው፥ ሂንቴ ኣይፊያ ሲንꬃን ኪሪስቶሲ ማስቃሌ ቦላ ካቄቲዳ ሚሲሌዳ ቆንጪዲ ቤንቴስ። ያቲን፥ ቱማስ ሂንቴ ኪቴቶና ሜላ ሂንቴና ቢቲዳይ ኦኔ? ");
INSERT INTO gofENT_vpl VALUES ("GL3_2","078_3_2","GAL","3","2","2","ታ ኢሲባ ኤራናው ኮያይስ፤ ሂንቴ ጌሻ ኣያና ኤኪዳይ ሂጌ ናጊዲዬ ዎይኮ ሂንቴ ሲዒዳ ዎንጌላ ኣማኒዲ ኤኪዴቲ? ");
INSERT INTO gofENT_vpl VALUES ("GL3_3","078_3_3","GAL","3","3","3","ሂንቴ ሄሳ ሜላ ኤዬ? ሂንቴ ፆሳ ኣያናን ዶሚዲ፥ ሃዒ ዎልቃን ፖላናው ኮዬቲ? ");
INSERT INTO gofENT_vpl VALUES ("GL3_4","078_3_4","GAL","3","4","4","ሂንቴ ዎንጌላ ጋሶን ዳሮ ዋዬቲዳይ ሜሌ? ሄ ዋዬ ኡባይ ጮ ጊዲዴ? ");
INSERT INTO gofENT_vpl VALUES ("GL3_5","078_3_5","GAL","3","5","5","ፆሳይ ሂንቴው ጌሻ ኣያና ኢሜይኔ ሂንቴ ጊዶን ማላታታ ኦꬄይ፥ ሂንቴ ሂጌ ናጊዳ ጊሾዬ ዎይኮ ዎንጌላ ሲዒዲ ኣማኒዳ ጊሾ? ");
INSERT INTO gofENT_vpl VALUES ("GL3_6","078_3_6","GAL","3","6","6","ኣኔ ኣብራሃሜ ቤዒቴ፥ «ኢ ፆሳ ኣማኒስ፤ ፆሳይ ኢያው ሄሳ ፂሎቴꬂ ኦꬂዲ ኤኪስ» ጌቴቲዲ ፃፌቲስ። ");
INSERT INTO gofENT_vpl VALUES ("GL3_7","078_3_7","GAL","3","7","7","ሂዛ፥ ኣማኔይሳቲ ኣብራሃሜ ናይታ ጊዴይሳ ኤሪቴ። ");
INSERT INTO gofENT_vpl VALUES ("GL3_8","078_3_8","GAL","3","8","8","ፆሳይ ኣይሁዴ ጊዶና ኣሳ ኣማኖን ፂሊሳናይሳ ጌሻ ማፃፋይ ቤዒዲ፥ «ካዎቴꬃ ኡባይ ኔናን ኣንጄታና» ያጊዲ፥ ዎንጌላ ኣብራሃሜስ ካሴቲዲ ኦዲስ። ");
INSERT INTO gofENT_vpl VALUES ("GL3_9","078_3_9","GAL","3","9","9","ሄሳ ጊሾ፥ ኣማኒያ ኡባይ ኣማኒዳ ኣብራሃሜራ ኢሲፌ ኣንጄቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("GL3_10","078_3_10","GAL","3","10","10","ሂጌ ናጊዲ ፂላና ጊያ ኦኒካ ቃንጌቲዳይሳ። ኣይስ ጊኮ፥ ጌሻ ማፃፋን፥ «ሂጌ ማፃፋን ፃፌቲዳ ኡባ ናጎና ኦኒካ ቃንጌቲዳይሳ ጊዶ» ጌቴቲዲ ፃፌቲስ። ");
INSERT INTO gofENT_vpl VALUES ("GL3_11","078_3_11","GAL","3","11","11","«ፂሎይ ኣማኖን ዳና» ጌቴቲዲ ፃፌቲዳ ጊሾ ኦኒካ ፆሳ ሲንꬃን ሂጌ ናጊዲ ፂሎናይሲ ኤሬቲዳባ። ");
INSERT INTO gofENT_vpl VALUES ("GL3_12","078_3_12","GAL","3","12","12","ሂጌይ ኣማኖን ዜምፔና። ሺን፥ «ሂጊያ ናጊያ ኦኒካ ሂጊያን ዴዖን ዳና» ያጌስ። ");
INSERT INTO gofENT_vpl VALUES ("GL3_13","078_3_13","GAL","3","13","13","«ሚꬃ ቦላ ካቄቲዲ ሃይቂያ ኦኒካ ቃንጌቲዳይሳ» ጌቴቲ ፃፌቲዳ ጊሾ ኪሪስቶሲ ኑ ጊሾ ቃንጌቲዳይሳ ጊዲዲ፥ ኑና ሂጌ ቃንጌꬃፌ ዎዚስ። ");
INSERT INTO gofENT_vpl VALUES ("GL3_14","078_3_14","GAL","3","14","14","ፆሳይ ኣብራሃሜስ ኢሚዳ ኣንጆይ፥ ዬሱስ ኪሪስቶሳ ባጋራ ኣይሁዴ ጊዶና ኣሳ ጋካና ሜላኔ ፆሳይ ኢማና ጊዳ ጌሻ ኣያና ኑኒ ኣማኖን ኤካና ሜላ ሄሳ ኦꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("GL3_15","078_3_15","GAL","3","15","15","ታ ኢሻቶ፥ ታ ሂንቴው ኣሳ ዴዖን ሜዜ ጊዲዲ ዴዒያባ ሌሚሶ ኦꬃዳ ኦዳይስ። ኣሲ ጫቂዳ ጫቆይ ሚኒዳፔ ጉዬ፥ ኦኒካ ሄ ጫቁዋ ሻራናው ዎይኮ ኢያ ቦላ ሃራ ጉጃናው ዳንዳዔና። ");
INSERT INTO gofENT_vpl VALUES ("GL3_16","078_3_16","GAL","3","16","16","ፆሳይ ሄ ኬኬ ቃላ ኣብራሃሜሲኔ ኢያ ዜሬꬃስ ኢሚስ። ጌሻ ማፃፋይ፥ ዳሮ ኣሳስ ኦዲያዳ፥ «ኔ ዜሬꬃታስ» ጌና። ሺን ኢሲ ኣሳስ ኦዲያዳ፥ «ኔ ዜሬꬃስ» ያጌስ፤ ኢካ ኪሪስቶሳ። ");
INSERT INTO gofENT_vpl VALUES ("GL3_17","078_3_17","GAL","3","17","17","ታኒ ጌይ ሃይሳ፤ ኦይዱ ፄታኔ ሃስታሙ ላይꬃፌ ጉዬ ኢሜቲዳ ሂጌይ፥ ኮይሮ ፆሳይ ሚንꬂዳ ጫቁዋ ሻሪዲ ኡፋይሳ ቃላ ꬋይሳናው ዳንዳዔና። ");
INSERT INTO gofENT_vpl VALUES ("GL3_18","078_3_18","GAL","3","18","18","ፆሳይ ኢሚያ ላታይ ሂጌን ኤኬቲያባ ጊዲያኮ ፆሳይ ኢሚዳ ኡፋይሳ ባጋራ ጊዴይሲ ኣቴስ። ሺን ፆሳይ ባ ኣꬎ ኬሃቴꬃን ላታ ኣብራሃሜስ ኡፋይሳ ቃላ ባጋራ ኢሚስ። ");
INSERT INTO gofENT_vpl VALUES ("GL3_19","078_3_19","GAL","3","19","19","ያቲን፥ ሂጌይ ኣይስ ኢሜቲዴ? ሂጌይ ኢሜቲዳይ፥ ኣብራሃሜስ ኡፋይሳ ቃሊ ኢሜቲዳ ዜሬꬃይ ያና ጋካናው ኢታ ኦሶይ ኣይቤኮ ኤሪሳናሳ። ሂጌይ ኪታንቾታ ባጋራ ኢሜቲዲ፥ ጊዶ ጊዲዲ ሲጌꬂያ ኢሲ ኣሳ ባጋራ ኦሶ ቦላ ፔዒስ። ");
INSERT INTO gofENT_vpl VALUES ("GL3_20","078_3_20","GAL","3","20","20","ጊዶ ጊዲዲ ሲጌꬂያ ኡራይ ኢሲ ኣሳ ፃላላስ ጊዴና፥ ሺን ፆሳይ ኢሲኖ። ");
INSERT INTO gofENT_vpl VALUES ("GL3_21","078_3_21","GAL","3","21","21","ያቲን፥ ሂጌይ ፆሳ ኡፋይሳ ቃላራ ኤቄቲዬ? ኣካይ፥ ጊዴና! ሂጌይ ኢሜቲዳይ ኣሳስ ዴዖ ኢማናው ጊዲያኮ፥ ፂሎቴꬂ ሂጌ ባጋራ ቤንታናሺን። ");
INSERT INTO gofENT_vpl VALUES ("GL3_22","078_3_22","GAL","3","22","22","ሺን ዬሱስ ኪሪስቶሳ ኣማኒን ቤንቲያ ኡፋይሳ ቃላይ ኣማኔይሳታስ ኢሜታና ሜላ ኩሜꬃ ኣላሜይ ናጋራስ ሃሬቲዲ ዴዔይሳ ጌሻ ማፃፋይ ኦዴስ። ");
INSERT INTO gofENT_vpl VALUES ("GL3_23","078_3_23","GAL","3","23","23","ሺን ኣማኖይ ያናፔ ካሴ ሂጌይ ኑና ቃቺ ዎꬂስ። ሄ ኣማኖይ ቆንጫና ጋካናው ሂጌይ ኑ ቦላ ጎርዲ ዎꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("GL3_24","078_3_24","GAL","3","24","24","ሄሳ ጊሾ፥ ኑኒ ኣማኖን ፂላና ሜላ ኪሪስቶሲ ያና ጋካናው ሂጌይ ናዓ ናጊያ ኣሳ ሜላ ኑና ናጌይሳ ጊዲስ። ");
INSERT INTO gofENT_vpl VALUES ("GL3_25","078_3_25","GAL","3","25","25","ሺን ሃዒ ኣማኖይ ዪዳ ጊሾ ሂጌይ ሂዛፔ ጉዬ ናዓ ናጊያ ኣሳ ሜላ ኑና ናጌይሲ ኣቲስ። ");
INSERT INTO gofENT_vpl VALUES ("GL3_26","078_3_26","GAL","3","26","26","ሂንቴ ኡባይ ዬሱስ ኪሪስቶሳ ኣማኒዲ ፆሳ ናይታ ጊዲዴታ። ");
INSERT INTO gofENT_vpl VALUES ("GL3_27","078_3_27","GAL","3","27","27","ኪሪስቶሳራ ኢሲኖ ጊዳናው ፃማቄቲዳ ኡባይ ኪሪስቶሳ ማዖዳ ማዒዴታ። ");
INSERT INTO gofENT_vpl VALUES ("GL3_28","078_3_28","GAL","3","28","28","ሂንቴ ኡባይ ኪሪስቶሳን ኢሲኖ ጊዲያ ጊሾ ኣይሁዴ ኣሳ ጊዶኒኔ ጊሪኬ ኣሳ ጊዶን፥ ኣይሌ ጊዶኒኔ ዎማኖ ጊዶን፥ ኣዴ ጊዶኒኔ ማጫሳ ጊዶን ዱማቴꬂ ባዋ። ");
INSERT INTO gofENT_vpl VALUES ("GL3_29","078_3_29","GAL","3","29","29","ሂዛ፥ ሂንቴ ኪሪስቶሳባ ጊዲኮ ሂንቴ ኣብራሃሜ ዛሬ። ፆሳ ኡፋይሳ ቃላዳ ሂንቴ ላቴይሳታ። ");
INSERT INTO gofENT_vpl VALUES ("GL4_1","078_4_1","GAL","4","1","1","ታ ጌይሲ ሃይሳ። ላቴይ ናዓ ጊዲ ዴዒሼ፥ ሻሎ ኡባይ ኢያባ ጊዲኮካ፥ ኢ ኣይሌፌ ኣይኮካ ዱማቴና። ");
INSERT INTO gofENT_vpl VALUES ("GL4_2","078_4_2","GAL","4","2","2","ሺን ኢያ ኣዋይ ጊዳ ዎዴይ ጋካናው ኢ ሃዳራ ኤኪዳይሳታ ኩሼኒኔ ናጌይሳታ ኩሼን ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("GL4_3","078_4_3","GAL","4","3","3","ሄሳዳካ፥ ኑኒ ናዓቴꬃን ዴዒያ ዎዴ ኣላሚያ ዎጋስ ኣይሌቲዲ ዴዒዳ። ");
INSERT INTO gofENT_vpl VALUES ("GL4_4","078_4_4","GAL","4","4","4","ሺን ዎዴይ ጋኪዳ ዎዴ ፆሳይ ሂጌፌ ጋርሳን፥ ማጫሳፔ ዬሌቲዳ ባ ናዓ ኪቲስ። ");
INSERT INTO gofENT_vpl VALUES ("GL4_5","078_4_5","GAL","4","5","5","ኢ ሄሳ ኦꬂዳይ፥ ሂጌስ ሃሬቲዲ ዴዔይሳታ ዎዛናዉኔ ኑና ባ ናይታ ኦꬃናሳ። ");
INSERT INTO gofENT_vpl VALUES ("GL4_6","078_4_6","GAL","4","6","6","ኑ ፆሳ ናይታ ጊዲያ ጊሾ «ኣባ፥ ኣዋው» ጊዲ ፄጊያ ባ ናዓ ኣያና ኑ ዎዛና ጊዶ ኪቲስ። ");
INSERT INTO gofENT_vpl VALUES ("GL4_7","078_4_7","GAL","4","7","7","ሄሳ ጊሾ፥ ሂዛፔ ኔኒ ፆሳ ናዓፔ ኣቲን ኣይሌ ጊዳካ። ኔኒ ኢያ ናዓ ጊዲኮ፥ ፆሳ ላቴይሳ ጊዳዳሳ። ");
INSERT INTO gofENT_vpl VALUES ("GL4_8","078_4_8","GAL","4","8","8","ሂንቴ ካሴ ፆሳ ኤሮና ዎዴ ፆሴ ጊዶናይሳታስ ኣይሌ ጊዲዲ ሃሬቲዴታ። ");
INSERT INTO gofENT_vpl VALUES ("GL4_9","078_4_9","GAL","4","9","9","ሺን ሃዒ ሂንቴ ፆሳ ኤሪዴታ፤ ኡባራካ ፆሳን ኤሬቲዴታ። ያቲን ፓꬆናኔ ጎዖና ኣላሜ ዎጋታኮ ጉዬ ዋኒዲ ሲሜቲ? ዎꬊ ኤቂዲ፥ ዋኒዲ ኤንታው ኣይሌ ጊዳናው ኮዬቲ? ");
INSERT INTO gofENT_vpl VALUES ("GL4_10","078_4_10","GAL","4","10","10","ዱማ ጊዲዳ ጋላሳታ፥ ኣጌናታ፥ ዎዴታኔ ላይꬃታ ሂንቴ ሎይꬂ ቦንቼታ። ");
INSERT INTO gofENT_vpl VALUES ("GL4_11","078_4_11","GAL","4","11","11","ታና ሂንቴባይ ያሼስ፤ ታ ሂንቴው ጮ ዳቡራዲናሻ? ");
INSERT INTO gofENT_vpl VALUES ("GL4_12","078_4_12","GAL","4","12","12","ታ ኢሻቶ፥ ታ ሂንቴዳ ሃኒዳ ጊሾ ሂንቴካ ታዳ ሃኒቴ ጋዳ ሂንቴና ዎሳይስ። ሂንቴ ታና ኣይቢንካ ቆሂቤኬታ። ");
INSERT INTO gofENT_vpl VALUES ("GL4_13","078_4_13","GAL","4","13","13","ታኒ ኮይሮ ሃርጌታሼ ሂንቴው ዎንጌላ ኦዲዳይሳ ሂንቴ ኤሬታ። ");
INSERT INTO gofENT_vpl VALUES ("GL4_14","078_4_14","GAL","4","14","14","ታ ሃርጌይ ሂንቴው ፓጬ ጊዲኮካ፥ ታና ሳሌቲቤኬታ፤ ኢፂቤኬታ። ሺን ታና ፆሳ ኪታንቾ ዎይኮ ኪሪስቶስ ዬሱሳ ሞኬይሳዳ ሞኪዴታ። ");
INSERT INTO gofENT_vpl VALUES ("GL4_15","078_4_15","GAL","4","15","15","ያቲን፥ ሄ ሂንቴው ዴዒያ ኡፋይሳይ ኡባይ ኣው ቢዴ? ሂንቴው ዳንዳዔቲዳኮ፥ ሂንቴ ታው፥ ሂንቴ ኣይፊያ ኬሲዲ ኢሚያኮ ኢፆናይሳ ታ ማርካታይስ። ");
INSERT INTO gofENT_vpl VALUES ("GL4_16","078_4_16","GAL","4","16","16","ያቲን፥ ታ ሂንቴው ቱማ ኦዲዳ ጊሾ ሂንቴው ሞርኬ ጊዳዲናዬ? ");
INSERT INTO gofENT_vpl VALUES ("GL4_17","078_4_17","GAL","4","17","17","ሄ ኣሳቲ ሂንቴና ባንታኮ ዛራናው ኮዮሶና፥ ሺን ኤንታ ቆፋይ ሎዖሳ ጊዴና። ኤንታ ቆፋይ ሂንቴና ሻካናሳኔ ሂንቴ ኤንታው ቆፓና ሜላ ኦꬃናሳ። ");
INSERT INTO gofENT_vpl VALUES ("GL4_18","078_4_18","GAL","4","18","18","ሎዖባ ኦꬃናው ኣሞቲኮ ሎዖ፥ ሺን ሄሲ ታ ሂንቴራ ዴዒያ ዎዴ ፃላላ ጊዶናሺን ኡባ ዎዴ ጊዶ። ");
INSERT INTO gofENT_vpl VALUES ("GL4_19","078_4_19","GAL","4","19","19","ታ ሲቆ ናይቶ፥ ኪሪስቶሲ ሂንቴናን ሚሲሌታና ጋካናው ዬሎስ ማጫሲ ሚፆቴይሳዳ ታ ሂንቴ ጊሾ ሚፆታይስ። ");
INSERT INTO gofENT_vpl VALUES ("GL4_20","078_4_20","GAL","4","20","20","ሂንቴባይ ታው ሃዲርሲ ጊዲን ታ ኡንዔታስ፤ ሃዒ ሂንቴ ጊዶን ታ ቤንታዳ ሼኔታዳ ኦዲያኮ ኣይ ሜላ ዶሳይናሺን። ");
INSERT INTO gofENT_vpl VALUES ("GL4_21","078_4_21","GAL","4","21","21","ሙሴ ሂጌን ሃሬቲዲ ዳናው ኮዬይሳቶ፥ ኣኔ ታው ኦዲቴ፤ ሂጌይ ኣይ ጊያኮ ኤሬኬቲ? ");
INSERT INTO gofENT_vpl VALUES ("GL4_22","078_4_22","GAL","4","22","22","ጌሻ ማፃፋይ፥ «ኣብራሃሜስ ኣይሌፌኔ ጎዳቴፌ ዬሌቲዳ ናምዑ ናይቲ ዴዖሶና» ያጌስ። ");
INSERT INTO gofENT_vpl VALUES ("GL4_23","078_4_23","GAL","4","23","23","ኣይሌ ናዓይ ኣሲ ናዓ ዬሊያ ማራን ዬሌቲስ፥ ሺን ጎዳቴ ናዓይ ፆሳ ኡፋይሳ ቃላን ዬሌቲስ። ");
INSERT INTO gofENT_vpl VALUES ("GL4_24","078_4_24","GAL","4","24","24","ሃ ማጫሳቲ ናምዑ ጫቆታስ ሌሚሶ ጊዲዲ ኤኬቶሶና። ኤንታፌ ኢሲኒያ፥ ሲና ዴሪያፔ ዪዳራ፥ ባ ናይታ ኣይሌቴꬃስ ዬላሱ፤ ኢያካ ኣጋሮ። ");
INSERT INTO gofENT_vpl VALUES ("GL4_25","078_4_25","GAL","4","25","25","ኣጋራ ኣራቤ ቢታን ዴዒያ ሲና ዴሪያን ሌሚሴታዳ ሃዒ ዴዒያ ዬሩሳላሜ ዳናዉሱ። ኣይስ ጊኮ፥ ኢያ ባ ናይታራ ኣይሌቴꬃን ዴዓዉሱ። ");
INSERT INTO gofENT_vpl VALUES ("GL4_26","078_4_26","GAL","4","26","26","ሺን ሳሎን ዴዒያ ዬሩሳላሜይ ኣይሌቴꬃን ዴዑኩ፤ ኢያ ኑ ኡባስ ኣዮ። ");
INSERT INTO gofENT_vpl VALUES ("GL4_27","078_4_27","GAL","4","27","27","ጌሻ ማፃፋይ፥ «ናቴ፥ ዬሎና ማይንꬄቴ ኡፋይታ፤ ናቴ ሚፆታ ኤሮናሬ ኢሊላ። ኣዚናራ ዴዒያ ማጫሴፔ፥ ኣዚኒ ባይና ማጫሴስ ናይቲ ዳሮ» ያጌስ። ");
INSERT INTO gofENT_vpl VALUES ("GL4_28","078_4_28","GAL","4","28","28","ታ ኢሻቶ፥ ሂንቴ ዪሳቃዳ ፆሳ ኡፋይሳ ቃላን ዬሌቲዳ ናይታ። ");
INSERT INTO gofENT_vpl VALUES ("GL4_29","078_4_29","GAL","4","29","29","ሺን ሄ ዎዴ ኣሳ ማራዳ ዬሌቲዳይሲ፥ ኣያና ዎልቃን ዬሌቲዳይሳ ጎዲስ። ሃቺካ ሄሳ ሜላ። ");
INSERT INTO gofENT_vpl VALUES ("GL4_30","078_4_30","GAL","4","30","30","ሺን ጌሻ ማፃፋይ ዎይጊ? «ኣይሌ ናዓይ ጎዳቴ ናዓራ ኢሲፌ ላቶና ጊሾ ኣይሊው ኢ ናዓራ ዎላ ኬሳ ዬዳ» ያጌስ። ");
INSERT INTO gofENT_vpl VALUES ("GL4_31","078_4_31","GAL","4","31","31","ሄሳ ጊሾ፥ ታ ኢሻቶ፥ ኑኒ ጎዳቴ ናይታፔ ኣቲን ኣይሌ ናይታ ጊዶኮ። ");
INSERT INTO gofENT_vpl VALUES ("GL5_1","078_5_1","GAL","5","1","1","ኑኒ ላዓቴꬃን ዳና ሜላ ኪሪስቶሲ ኑና ኣይሌቴꬃፌ ኬሲስ። ሂዛ፥ ሚኒዲ ኤቂቴ፤ ዛሪዲ ኣይሌቴꬃ ቃምባራን ጌሎፒቴ። ");
INSERT INTO gofENT_vpl VALUES ("GL5_2","078_5_2","GAL","5","2","2","ታ፥ ጳዉሎሲ፥ ጌይሳ ሲዒቴ። ሂንቴ ቃፃሬታናው ኮይኮ፥ ኪሪስቶሲ ሂንቴና ኣይኮካ ማዴና። ");
INSERT INTO gofENT_vpl VALUES ("GL5_3","078_5_3","GAL","5","3","3","ቃፃሬቲያ ኦኒካ ሂጌይ ኪቲያ ኡባ ፖላናው ቤሴይሳ ጉጃዳ ታ ኦዳይስ። ");
INSERT INTO gofENT_vpl VALUES ("GL5_4","078_5_4","GAL","5","4","4","ሂጌ ናጊዲ ፂላናው ኮዬይሳቶ፥ ኪሪስቶሳፔ ሻኬቲዴታ፤ ፆሳ ኣꬎ ኬሃቴꬃፌ ኩንዲዴታ። ");
INSERT INTO gofENT_vpl VALUES ("GL5_5","078_5_5","GAL","5","5","5","ሺን ኑኒ ፆሳ ኣያና ባጋራ ኣማኖን ፂላናው ኡፋይሳን ናጎስ። ");
INSERT INTO gofENT_vpl VALUES ("GL5_6","078_5_6","GAL","5","6","6","ሂዛ፥ ኪሪስቶስ ዬሱሳን ዴዒኮ፥ ሲቆን ቆንጪያ ኣማኖፔ ኣቲን ቃፃሬቲን፥ ቃፃሬቶና ኣጊን ኑና ኣይኮካ ማዴና። ");
INSERT INTO gofENT_vpl VALUES ("GL5_7","078_5_7","GAL","5","7","7","ካሴ ሂንቴ ሎዖ ዎፄታ፥ ሺን ሃዒ ቱማስ ኪቴቶና ሜላ ሂንቴና ዲጊዳይ ኦኔ? ");
INSERT INTO gofENT_vpl VALUES ("GL5_8","078_5_8","GAL","5","8","8","ሃይሳ ሜላ ኢታ ጪሞይ ሂንቴና ፄጊዳ ፆሳፌ ዪቤና። ");
INSERT INTO gofENT_vpl VALUES ("GL5_9","078_5_9","GAL","5","9","9","ሄሲካ፥ «ጉꬃ ኢርሾይ ሙኑቃ ኡባ ዴንꬄስ።» ጌቴቲዲ ፃፌቲዳይሳ ሜላ። ");
INSERT INTO gofENT_vpl VALUES ("GL5_10","078_5_10","GAL","5","10","10","ሂንቴው ሃራ ቆፊ ባይናይሳስ ታ ጎዳን ኣማኔታይስ። ሺን ሂንቴና ቡቂያ ኦኒካ ፆሳፌ ባ ፒርዳ ኤካና። ");
INSERT INTO gofENT_vpl VALUES ("GL5_11","078_5_11","GAL","5","11","11","ታ ኢሻቶ፥ ታ ሃዒ ጋካናው ቃፃሮ ሳባኪያባ ጊዲኮ፥ ያቲን ታና ኣይስ ጎዶና? ሄሲ ቱማ ጊዲያኮ ኪሪስቶሳ ማስቃሊያባ ታማርሶይ ኣሳስ ꬉቤ ጊዴናሺን። ");
INSERT INTO gofENT_vpl VALUES ("GL5_12","078_5_12","GAL","5","12","12","ሂንቴና ቡቄይሳቲ ቃፃሬቴꬃ ፃላላ ጊዶናሺን ባንታና ቃራቲያኮካ ታ ዶሳይስ። ");
INSERT INTO gofENT_vpl VALUES ("GL5_13","078_5_13","GAL","5","13","13","ታ ኢሻቶ፥ ሂንቴ ላዓ ዳናው ፄጌቲዴታ። ጊዶሺን፥ ሂንቴ ላዓቴꬃይ ኣሾ ኣሞ ፖላናው ሂንቴው ጋሶ ጊዶፖ፤ ሄሳፌ ኣꬂዲ ኢሶይ ኢሱዋ ሲቆን ማዲቴ። ");
INSERT INTO gofENT_vpl VALUES ("GL5_14","078_5_14","GAL","5","14","14","ሂጌ ኡባይ፥ «ኣሴ ኔዳ ዶሳ» ያጊያ ኢሲ ቃላን ቃሼቲስ። ");
INSERT INTO gofENT_vpl VALUES ("GL5_15","078_5_15","GAL","5","15","15","ሺን ሂንቴ ኢሶይ ኢሱዋራ ሳፄቲያባኔ ሜቴቲያባ ጊዲኮ፥ ሂንቴ ዎሊ ዉርሶና ሜላ ናጌቲቴ። ");
INSERT INTO gofENT_vpl VALUES ("GL5_16","078_5_16","GAL","5","16","16","ሂዛ፥ ታ ሂንቴው ኦዳይስ፤ ኣያናን ዴዒቴ፤ ሂንቴ ኣሾ ኣሙዋ ፖሎፒቴ። ");
INSERT INTO gofENT_vpl VALUES ("GL5_17","078_5_17","GAL","5","17","17","ኣሾ ኣሞይ ኣያና ኣሙዋራ ሞርኬ፤ ቃሲ ኣያና ኣሞይካ ኣሾ ኣሙዋራ ሞርኬ። ኤንቲ ኢሶይ ኢሱዋራ ኢፄቲያ ጊሾ ሂንቴ ዶሲያባ ኦꬃናው ዳንዳዔኬታ። ");
INSERT INTO gofENT_vpl VALUES ("GL5_18","078_5_18","GAL","5","18","18","ሺን ኣያናይ ሂንቴና ካሌꬂያባ ጊዲኮ ሂጌይ ሂንቴና ሃሬና። ");
INSERT INTO gofENT_vpl VALUES ("GL5_19","078_5_19","GAL","5","19","19","ኣሾ ኦሶቲ ኤሬቲዳይሳታ፤ ኤንቲካ፥ ላይማቴꬂ፥ ቱናቴꬂ፥ ቃይፄ፥ ");
INSERT INTO gofENT_vpl VALUES ("GL5_20","078_5_20","GAL","5","20","20","ኤቃ ጎይኖ፥ ቢታ፥ ሞርኬቴꬂ፥ ካቺ፥ ቃናቴ፥ ሃንቆ፥ ባና ዶሶ፥ ሻኬቴꬂ፥ ኢታ ቶቤ ");
INSERT INTO gofENT_vpl VALUES ("GL5_21","078_5_21","GAL","5","21","21","ጌኔ፥ ማꬆ፥ ዬꬂኔ ሄሳ ሄሳ ሜላታ። ካሴ ታ ሂንቴው ኦዲዳይሳዳ ሃዒካ ታ ሂንቴው ኦዳይስ። ሃይሳ ሜላባታ ኦꬄይሳቲ ፆሳ ካዎቴꬃ ላቶኮና። ");
INSERT INTO gofENT_vpl VALUES ("GL5_22","078_5_22","GAL","5","22","22","ሺን ኣያና ኣይፌይ፥ ሲቆ፥ ኡፋይሲ፥ ሳሮቴꬂ፥ ዳንዳዓ፥ ኬሃቴꬂ፥ ሎዖቴꬂ፥ ኣማኖ፥ ");
INSERT INTO gofENT_vpl VALUES ("GL5_23","078_5_23","GAL","5","23","23","ኣሽኬቴꬂ፥ ባና ሃሮ። ሃይሳ ሜላባታ ኢፂያ ሂጌይ ባዋ። ");
INSERT INTO gofENT_vpl VALUES ("GL5_24","078_5_24","GAL","5","24","24","ኪሪስቶስ ዬሱሳባ ጊዲዳይሳቲ ባንታ ኣሹዋ ኢያ ኢታ ቆፋራኔ ኢያ ኣሙዋራ ኢሲፌ ማስቃሊያ ቦላ ካቂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("GL5_25","078_5_25","GAL","5","25","25","ኑ ኣያናን ዴዒያባ ጊዲኮ፥ ኑና ኣያናይ ካሌꬆ። ");
INSERT INTO gofENT_vpl VALUES ("GL5_26","078_5_26","GAL","5","26","26","ኣኔ ኢሶይ ኢሱዋ ዪሎዪሼኔ ቃናቲሼ ጮ ጬቄቴይሳ ኣጎስ። ");
INSERT INTO gofENT_vpl VALUES ("GL6_1","078_6_1","GAL","6","1","1","ታ ኢሻቶ፥ ኢሲ ኣሲ ናጋራን ኩንዲኮ፥ ኣያናን ዴዒያ ሂንቴ ሄ ኡራ ኣሽኬቴꬃን ሱሪሲቴ። ሺን ኔኒ ሄሳ ሜላባን ፓጬቶና ሜላ ኔና ናጋ። ");
INSERT INTO gofENT_vpl VALUES ("GL6_2","078_6_2","GAL","6","2","2","ኢሶይ ኢሱዋ ዴፆ ቶሁዋ ቶኪቴ። ያቲኮ ኪሪስቶሳ ሂጊያ ፖሌታ። ");
INSERT INTO gofENT_vpl VALUES ("GL6_3","078_6_3","GAL","6","3","3","ኢሲ ኣሲ ኣይኮይካ ባዋሺን፥ ባና ሃራታፔ ሎዖ ጊዲ ቆፒኮ፥ ኢ ባና ጪሜስ። ");
INSERT INTO gofENT_vpl VALUES ("GL6_4","078_6_4","GAL","6","4","4","ሺን ኢሲ ኢሲ ኣሲ ባ ኦሱዋ ፓጮ። ሄሳፌ ጉዬ፥ ሃራታራ ባና ጋዴዬይሳ ኣጊዲ ባው ጬቄቲያባ ዴሜስ። ");
INSERT INTO gofENT_vpl VALUES ("GL6_5","078_6_5","GAL","6","5","5","ኢሲ ኢሲ ኣሲ ባ ቶሁዋ ባው ቶካናው ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("GL6_6","078_6_6","GAL","6","6","6","ፆሳ ቃላ ታማሪያ ኦኒካ ሎዖባ ኡባ ባ ኣስታማሪያራ ሻኬቴስ። ");
INSERT INTO gofENT_vpl VALUES ("GL6_7","078_6_7","GAL","6","7","7","ሂንቴ፥ ሂንቴና ጪሞፊቴ። ኣሲ ባ ዜሪዳባ ዛሪዲ ጫኪያ ጊሾ ፆሳ ቦላ ቄልቂሶፒቴ። ");
INSERT INTO gofENT_vpl VALUES ("GL6_8","078_6_8","GAL","6","8","8","ባ ኣሾ ኣሙዋ ኩንꬃናው ዜሪያ ኦኒካ፥ ባ ኣሾ ኣሙዋፔ ሃይቆ ቡጫና። ሺን ኣያና ኡፋይሳናው ዜሪያ ኦኒካ ኣያናፔ ሜሪና ዴዖ ጫካና። ");
INSERT INTO gofENT_vpl VALUES ("GL6_9","078_6_9","GAL","6","9","9","ኣኔ ሎዖ ኦሶ ኦꬃናው ኣዛሌይሳ ኣጎስ። ኑኒ ኣዛሎና ኢፂኮ ዎዴይ ጋኪያ ዎዴ ኑ ዜሪዳይሳ ጫካና። ");
INSERT INTO gofENT_vpl VALUES ("GL6_10","078_6_10","GAL","6","10","10","ኑ ኢንጄ ዎዴ ዴሚኮ፥ ኣሳ ኡባስ፥ ኣꬂዲካ ኣማኒያ ኣሳስ ሎዖባ ኦꬆስ። ");
INSERT INTO gofENT_vpl VALUES ("GL6_11","078_6_11","GAL","6","11","11","ታኒ ታ ኩሼን፥ ኣይ ሜላ ጊታ ፒዳሌን ሂንቴው ፃፊዳኮ ቤዒቴ። ");
INSERT INTO gofENT_vpl VALUES ("GL6_12","078_6_12","GAL","6","12","12","ኣሳ ሲንꬃን ሎዖ ጊዲዲ ቤንታናው ኮያ ኣሳቲ ሂንቴ ቃፃሬታና ሜላ ኮዮሶና። ሺን ሄሳ ኤንቲ ኦꬄይ፥ ኪሪስቶሳ ማስቃሊያ ጊሾ ኤንታና ጎዲ ጋኮና ሜላሳ። ");
INSERT INTO gofENT_vpl VALUES ("GL6_13","078_6_13","GAL","6","13","13","ኤንቲ ሂንቴ ቃፃሬቴꬃን ጬቄታናው ኮዪዲ ሂንቴና ቃፃሬቶ ጎሶናፔ ኣቲን ቃፃሬቲዳይሳቲካ ባንታ ሁዔን ሂጊያ ናጎኮና። ");
INSERT INTO gofENT_vpl VALUES ("GL6_14","078_6_14","GAL","6","14","14","ሺን ኣላሜይ ታው ካቄቲዳይሳፌኔ ታኒካ ኣላሚያስ ካቄቲዳ፥ ጎዳ ዬሱስ ኪሪስቶሳ ማስቃሊያፔ ኣቲን ሃራ ጬቄቴꬂ ታፔ ሃኮ። ");
INSERT INTO gofENT_vpl VALUES ("GL6_15","078_6_15","GAL","6","15","15","ሂዛ፥ ቃፃሬቲን ቃፃሬቶና ኣጊን ኣይኮካ ማዴና። ማዴይ ኦራꬃ ሜꬌቴꬂ ጊዶ። ");
INSERT INTO gofENT_vpl VALUES ("GL6_16","078_6_16","GAL","6","16","16","ሃ ዎጋ ካሊያ ኡባሲኔ ፆሳ ዴሬ ጊዲዳ ኢስራዔሌስ ሳሮቴꬃይኔ ማሮቴꬃይ ጊዶ። ");
INSERT INTO gofENT_vpl VALUES ("GL6_17","078_6_17","GAL","6","17","17","ታኒ ዬሱሳስ ማዱንፂዳ ቤታ ታ ኣሳቴꬃን ቶኪዳ ጊሾ ሂዛፔ ታና ኦኒካ ዋይሶፖ። ");
INSERT INTO gofENT_vpl VALUES ("GL6_18","078_6_18","GAL","6","18","18","ታ ኢሻቶ፥ ኑ ጎዳ ዬሱስ ኪሪስቶሳ ኣꬎ ኬሃቴꬃይ ሂንቴራ ጊዶ። ኣሚንዒ። ");
INSERT INTO gofENT_vpl VALUES ("EP1_1","079_1_1","EPH","1","1","1","ፆሳ ሼኔን ኪሪስቶስ ዬሱሳ ሃዋሬ ጊዲዳ ጳዉሎሳፔ፥ ኤፌሶናን ዴዒያ ጌሻታሲኔ ኪሪስቶስ ዬሱሳ ኣማኔይሳታስ ፃፌቲዳ ኪታ። ");
INSERT INTO gofENT_vpl VALUES ("EP1_2","079_1_2","EPH","1","2","2","ፆሳ ኑ ኣዋፔኔ ጎዳ ዬሱስ ኪሪስቶሳፔ ኣꬎ ኬሃቴꬃይኔ ሳሮቴꬃይ ሂንቴው ጊዶ። ");
INSERT INTO gofENT_vpl VALUES ("EP1_3","079_1_3","EPH","1","3","3","ሳሎን ዴዒያ ኣያና ኣንጆ ኡባን ኪሪስቶሳ ባጋራ ኑና ኣንጂዳ፥ ኑ ጎዳ ዬሱስ ኪሪስቶሳ ኣዋይ፥ ፆሳይ ጋላቴቶ። ");
INSERT INTO gofENT_vpl VALUES ("EP1_4","079_1_4","EPH","1","4","4","ኑኒ ኢያ ሲንꬃን ጌሻታኔ ቦሬይ ባይናይሳታ ጊዳና ሜላ ፆሳይ ኣላሜይ ሜꬌታናፔ ካሴ ኪሪስቶሳ ባጋራ ባ ሲቁዋን ኑና ዶሪስ። ");
INSERT INTO gofENT_vpl VALUES ("EP1_5","079_1_5","EPH","1","5","5","ፆሳይ ባ ሼኒያን ባ ዶሲዳይሳዳ ዬሱስ ኪሪስቶሳ ባጋራ ኑና ባ ናይታ ኦꬃናው ካሴቲዲ ቆፒ ዎꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("EP1_6","079_1_6","EPH","1","6","6","ፆሳይ ባ ሲቂያ ናዓ ባጋራ ኑስ ጮ ኢሚዳ ኣꬎ ኬሃቴꬃይ ቦንቼታና ሜላ ሄሳ ኦꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("EP1_7","079_1_7","EPH","1","7","7","ፆሳ ኣꬎ ኬሃቴꬃ ዱሬቴꬃዳ ኪሪስቶሳ ሱꬃን ዎዜቲዲ ናጋራ ኣቶቴꬃ ዴሚዳ። ");
INSERT INTO gofENT_vpl VALUES ("EP1_8","079_1_8","EPH","1","8","8","ባ ኣꬎ ኬሃቴꬃ ጪንጫቴꬃኒኔ ኤራቴꬃን ኩንꬂዲ ኑስ ኢሚስ። ");
INSERT INTO gofENT_vpl VALUES ("EP1_9","079_1_9","EPH","1","9","9","ፆሳይ ባ ዶሲዳይሳዳ ኪሪስቶሳ ባጋራ ኢያ ሼኒያ ፁራ ኑ ኤራና ሜላ ኦꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("EP1_10","079_1_10","EPH","1","10","10","ዎዴይ ጋኪያ ዎዴ ፆሳይ ፖላናው ቆፒዳ ቆፋይ፥ ሳሎኒኔ ሳዓን ዴዒያ ሜꬌቴꬃ ኡባይ ኪሪስቶሳፔ ጋርሳን ጊዳና ሜላሳ። ");
INSERT INTO gofENT_vpl VALUES ("EP1_11","079_1_11","EPH","1","11","11","ኡባባ ባ ሼኒያዳ ኦꬂያ ፆሳይ፥ ካሴቲዲ ባ ቆፒ ዎꬂዳይሳዳ ኪሪስቶሳ ባጋራ ኑኒ ኢያባ ጊዳና ሜላ ኑና ዶሪስ። ");
INSERT INTO gofENT_vpl VALUES ("EP1_12","079_1_12","EPH","1","12","12","ሄሳ ኢ ኦꬂዳይ፥ ኪሪስቶሳን ኡፋይሲ ዎꬂዲ ናጎን ኮይሮ ጊዲዳ ኑኒ ፆሳ ቦንቹዋ ጋላታን ቆንጪሳና ሜላሳ። ");
INSERT INTO gofENT_vpl VALUES ("EP1_13","079_1_13","EPH","1","13","13","ሂንቴካ ሂንቴ ኣቶቴꬃ ዎንጌላ፥ ሄሲካ ቱማ ቃላ ሲዒዳ ዎዴ ኪሪስቶሳ ኣማኒዴታ። ፆሳይ ሂንቴው ኢማና ጊዳ ጌሻ ኣያናን ሂንቴ ኣታሜቲዴታ። ");
INSERT INTO gofENT_vpl VALUES ("EP1_14","079_1_14","EPH","1","14","14","ፆሳ ቦንቾይ ጋላቴታና ሜላ ፆሳይ ባ ኣሳ ዎዛና ጋካናው ጌሻ ኣያና ኑስ ኦይꬁ ኦꬂዲ ኢሚስ። ");
INSERT INTO gofENT_vpl VALUES ("EP1_15","079_1_15","EPH","1","15","15","ሄሳ ጊሾ፥ ጎዳ ዬሱሳ ሂንቴ ኣማኔይሳኔ ጌሻታ ኡባ ሂንቴ ሲቄይሳ ታ ሲዒዳ ዎዴ ");
INSERT INTO gofENT_vpl VALUES ("EP1_16","079_1_16","EPH","1","16","16","ታ ዎሳን ሂንቴና ቆፓሼ ሂንቴ ጊሾ ፆሳ ጋላቴይሳ ኣጋቢኬ። ");
INSERT INTO gofENT_vpl VALUES ("EP1_17","079_1_17","EPH","1","17","17","ጎዳ ዬሱስ ኪሪስቶሳ ፆሳይ፥ ቦንቾ ኣዋይ፥ ፆሳ ሂንቴ ኣꬂ ኤራናዳ ጪንጫቴꬃኔ ቆንጬꬃ ኣያና ሂንቴው ኢማናዳ ታኒ ፆሳ ዎሳይስ። ");
INSERT INTO gofENT_vpl VALUES ("EP1_18","079_1_18","EPH","1","18","18","ፆሳይ ሂንቴና ፄጊዳ ኡፋይሳይኔ ጌሻቲ ላቲያ ቦንቾ ላታይ ኣይ ሜላ ዳሮኮ ሂንቴ ኤራና ሜላ ፆሳይ ሂንቴ ዎዛና ኣይፊያ ዶያና ሜላ ታኒ ፆሳ ዎሳይስ። ");
INSERT INTO gofENT_vpl VALUES ("EP1_19","079_1_19","EPH","1","19","19","ቃሲ ኢያ ኣማኒያ ኑናን ኦꬂያ ኢያ ዎልቃይ ኣይ ሜላ ኣꬊዳ ጊቴኮ ሂንቴ ኤራና ሜላ ዎሳይስ። ሄ ዎልቃይ ፆኔቶናኔ ዳቡሮና ዎልቃ። ሃ ኑናን ዴዒዲ ኦꬂያ ዎልቃይኔ፥ ");
INSERT INTO gofENT_vpl VALUES ("EP1_20","079_1_20","EPH","1","20","20","ኪሪስቶሳ ሃይቆፔ ዴንꬂዲ፥ ሳሎን ፆሳፌ ኡሻቻ ባጋራ ኡቲሲዳ ጊታ ዎልቃይ ኢሲኖ። ");
INSERT INTO gofENT_vpl VALUES ("EP1_21","079_1_21","EPH","1","21","21","ኢያ ሱንꬃይ፥ ኣይሴይሳታፔኔ ማታ ኣዋታፔ፥ ሃሬይሳታፔኔ ጎዳታፔ፥ ቦላ ጊዲዲ ሃ ኣላሚያ ፃላላን ጊዶናሺን ሲንꬃፌ ያና ኣላሚያንካ ሃራ ሱንꬃታ ኡባፌ ꬎቃ። ");
INSERT INTO gofENT_vpl VALUES ("EP1_22","079_1_22","EPH","1","22","22","ፆሳይ ኡባ ኪሪስቶሳ ቶሁዋፔ ጋርሳን ሃሪሲስ፤ ቃሲ ዎሳ ኬꬃን ኡባባን ጎዳ ጊዳና ሜላ ኢያ ሹሚስ። ");
INSERT INTO gofENT_vpl VALUES ("EP1_23","079_1_23","EPH","1","23","23","ዎሳ ኬꬃይ ኪሪስቶሳ ኩሜꬂ ኦꬂያ ኢያ ኣሳቴꬃ። ሜꬌቴꬃይ ዴዒያ ቤሳ ኡባን ኪሪስቶሲ ባ ሁዔን ኡባባ ኩንꬄይሳ። ");
INSERT INTO gofENT_vpl VALUES ("EP2_1","079_2_1","EPH","2","1","1","ሃይሳፌ ካሴ ሂንቴ፥ ሂንቴ ናጋራኔ ሂንቴ ቆሁዋ ጋሶን ሃይቂዳይሳታ። ");
INSERT INTO gofENT_vpl VALUES ("EP2_2","079_2_2","EPH","2","2","2","ሄ ዎዴ ሂንቴ ሃ ኣላሚያ ኢታ ኦጊያ ካሊዴታ። ጫርኩዋ ቦላ ዴዒያ ኣያና ዎልቃታ ሃላቃሲኔ ሃዒካ ፆሳስ ኪቴቶና ኣሳ ሃሪያ ኣያናስ ኪቴቲዴታ። ");
INSERT INTO gofENT_vpl VALUES ("EP2_3","079_2_3","EPH","2","3","3","ኑ ኡባይካ ካሴ ሄ ኣሳታ ጊዶን ኑ ኣሾ ኣሙዋኔ ኑ ዎዛና ሼኒያ ካሊዲ ዴዒዳ። ኑካ ሃራታ ሜላ ኑ ሜꬌቴꬃን ፆሳ ሃንቁዋ ኤካናው ዴዔይሳታ። ");
INSERT INTO gofENT_vpl VALUES ("EP2_4","079_2_4","EPH","2","4","4","ሺን ፆሳ ጊታ ማሮቴꬃፌኔ ኑስ ዴዒያ ጊታ ሲቁዋፔ ዴንዲዳይሳን፥ ");
INSERT INTO gofENT_vpl VALUES ("EP2_5","079_2_5","EPH","2","5","5","ሃሪ ኣቶሺን ኑኒ ኑ ቆሁዋን ሃይቂዲ ዴዒሺን ኪሪስቶሳ ባጋራ ኑስ ዴዖ ኢሚስ። ሂንቴካ ኣቲዳይ ፆሳ ኣꬎ ኬሃቴꬃና። ");
INSERT INTO gofENT_vpl VALUES ("EP2_6","079_2_6","EPH","2","6","6","ፆሳይ ኑና ኪሪስቶሳራ ኢሲፌ ሃይቆፔ ዴንꬂዲ ሳሎ ሶሁዋን ኢያራ ኢሲፌ ዎꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("EP2_7","079_2_7","EPH","2","7","7","ኢ ሄሳ ኦꬂዳይ፥ ኪሪስቶስ ዬሱሳ ባጋራ ኑስ ቆንጪሲዳ ባ ኬሃቴꬃኔ ዛዊ ባይና ባ ኣꬎ ኬሃቴꬃ ዱሬቴꬃ ያና ላይꬃን ኑና ቤሳናሳ። ");
INSERT INTO gofENT_vpl VALUES ("EP2_8","079_2_8","EPH","2","8","8","ሂንቴ ኣꬎ ኬሃቴꬃን ኣማኖን ኣቲዴታ። ሄሲካ፥ ፆሳ ኢሞታፔ ኣቲን ሂንቴ ኦሶን ቤንቲዳባ ጊዴና። ");
INSERT INTO gofENT_vpl VALUES ("EP2_9","079_2_9","EPH","2","9","9","ኦኒካ ጬቄቶና ሜላ ኣቶቴꬃይ ቤንቲዳይ ኦሶን ጊዴና። ");
INSERT INTO gofENT_vpl VALUES ("EP2_10","079_2_10","EPH","2","10","10","ኑኒ ፆሳ ሜꬌቴꬂ፤ ኢ ኑስ ካሴቲዲ ጊጊሲ ዎꬂዳ ሎዖ ኦሶታ ኦꬃና ሜላ ኪሪስቶስ ዬሱሳ ባጋራ ኦራꬂ ሜꬌቲዳ። ");
INSERT INTO gofENT_vpl VALUES ("EP2_11","079_2_11","EPH","2","11","11","ሄሳ ጊሾ፥ ሂንቴኖ ዬሌታን ኣይሁዴ ጊዶናይሳቶ፥ ኣይሁዴቲ ባንታው ኣሳ ኩሼን ቃፃሬቲዲ፥ ሂንቴና ቃሲ ቃፃሬቲቦናይሳታ ጊዲ ፄጌይሳ ኣኬኪቴ። ");
INSERT INTO gofENT_vpl VALUES ("EP2_12","079_2_12","EPH","2","12","12","ሄ ዎዴ ሂንቴ ኪሪስቶሳፔ ሻኬቲ ዴዒዳይሳ፥ ኢስራዔሌ ኣሳስ ኣላጋ ጊዲዲ ዴዒዳይሳ፥ ፆሳ ኡፋይሳ ቃላፔ ሃኪዲ ዴዒዳይሳኔ ሃ ኣላሚያን ኡፋይሲኔ ፆሲ ባይና ዴዒዳይሳ ኣኬኪቴ። ");
INSERT INTO gofENT_vpl VALUES ("EP2_13","079_2_13","EPH","2","13","13","ሺን ሂንቴ ካሴ ሃኪዲ ዴዒዳይሳቲ፥ ሃዒ ኪሪስቶስ ዬሱሳን ዴዒዲ ኪሪስቶሳ ሱꬃን ማታ ሺቂዴታ። ");
INSERT INTO gofENT_vpl VALUES ("EP2_14","079_2_14","EPH","2","14","14","ኪሪስቶሲ ኑ ሳሮቴꬃ፤ ኢ ኣይሁዴኔ ኣይሁዴ ጊዶና ኣሳ ቲሚዲ፥ ናምዓ ሻኪ ዎꬂዳ ሞርኬቴꬃ ጎዳ ላሊስ። ");
INSERT INTO gofENT_vpl VALUES ("EP2_15","079_2_15","EPH","2","15","15","ኢ ባናን ሃ ናምዑ ዛሬታፔ ኢሲ ኦራꬃ ኣሴ ሜꬊዲ፥ ሂጊያ ኢያ ኪታራኔ ዎጋታራ ኢሲፌ ባ ኣሳቴꬃን ꬋይሲዲ ሳሮቴꬂ ኢሚስ። ");
INSERT INTO gofENT_vpl VALUES ("EP2_16","079_2_16","EPH","2","16","16","ኪሪስቶሲ ማስቃሊያ ቦላ ሃይቂዲ ሞርኬቴꬃ ꬋይሲስ፤ ቃሲ ናምዑ ዛሬታ ኢሲ ኣሳቴꬂ ኦꬂዲ ፆሳራ ሲጌꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("EP2_17","079_2_17","EPH","2","17","17","ኪሪስቶሲ ዪዲ፥ ፆሳፌ ሃኪዲ ዴዒያ ሂንቴው፥ ቃሲ ማቲዲ ዴዒያ ኤንታው ሳሮቴꬃ ዎንጌላ ኦዲስ። ");
INSERT INTO gofENT_vpl VALUES ("EP2_18","079_2_18","EPH","2","18","18","ኑ ኡባይ ኢያ ባጋራ ኢሲ ኣያናን ኣዋ ሲንꬄ ሺቃናው ዳንዳዖስ። ");
INSERT INTO gofENT_vpl VALUES ("EP2_19","079_2_19","EPH","2","19","19","ሂዛፔ ሂንቴ ኣላጋ ዎይኮ ኢማꬄ ጊዴኬታ፥ ሺን ሂንቴ ሃዒ ጌሻታ ቢታ ኣሲኔ ፆሳ ሶ ኣሲ። ");
INSERT INTO gofENT_vpl VALUES ("EP2_20","079_2_20","EPH","2","20","20","ሂንቴ ሃዋሬቲኔ ናቤቲ ባሲዳ ባሱዋ ቦላ ኬፄቲዴታ። ጎዳ ፃጱዋ ሚንꬂያ ሹቻይ ኪሪስቶስ ዬሱሳ። ");
INSERT INTO gofENT_vpl VALUES ("EP2_21","079_2_21","EPH","2","21","21","ኢያን ኬꬃ ኡባይ ኢሲፌ ኦይኬቲዲ ጎዳን ጌሻ ፆሳ ኬꬂ ጊዳናው ዲጬስ። ");
INSERT INTO gofENT_vpl VALUES ("EP2_22","079_2_22","EPH","2","22","22","ሂንቴ ቃሲ ፆሳይ ባ ኣያናን ዴዒያ ኬꬂ ጊዳናው ኪሪስቶሳን ኢሲፌ ኬፄቴታ። ");
INSERT INTO gofENT_vpl VALUES ("EP3_1","079_3_1","EPH","3","1","1","ሄሳ ጊሾ፥ ታኒ፥ ጳዉሎሲ፥ ኣይሁዴ ጊዶና ሂንቴ ጊሾ ኪሪስቶስ ዬሱሳን ቃሾ ኣሲ ጊዳስ። ");
INSERT INTO gofENT_vpl VALUES ("EP3_2","079_3_2","EPH","3","2","2","ታ ሂንቴና ማዳና ሜላ ፆሳይ ባ ኣꬎ ኬሃቴꬃን ታው ኢሚዳ ሃ ኦሱዋባ ሂንቴ ሎይꬂ ሲዒዴታ። ");
INSERT INTO gofENT_vpl VALUES ("EP3_3","079_3_3","EPH","3","3","3","ታ ሂንቴው ካሴ ቃንꬃን ፃፊዳይሳዳ ፆሳይ ባ ፁራ ቆንጬꬃን ታው ቆንጪሲስ። ");
INSERT INTO gofENT_vpl VALUES ("EP3_4","079_3_4","EPH","3","4","4","ታ ፃፊዳይሳ ሂንቴ ናባቢያ ዎዴ ኪሪስቶሳ ፁራ ታ ኣይ ሜላ ኤሪዳኮ ሂንቴ ኣኬካናው ዳንዳዔታ። ");
INSERT INTO gofENT_vpl VALUES ("EP3_5","079_3_5","EPH","3","5","5","ሃ ፁራይ ጌሻ ሃዋሬታሲኔ ናቤታስ ሃዒ ኣያና ባጋራ ቆንጪዳይሳዳ ቤኒ ዎዴ ኣሳስ ሄሳዳ ቆንጪሲቤና። ");
INSERT INTO gofENT_vpl VALUES ("EP3_6","079_3_6","EPH","3","6","6","ፁራይ ሃይሳ፡ ኣይሁዴ ጊዶና ኣሳይ ዎንጌላ ባጋራ ኢስራዔሌታራ ኢሲፌ ፆሳ ኣንጁዋ ላቶሶና። ኢስራዔሌታራ ኢሲ ኬꬃ ኣሲ ጊዶሶና፤ ኪሪስቶስ ዬሱሳ ባጋራ ፆሳ ኡፋይሳ ቃላ ኤኮሶና። ");
INSERT INTO gofENT_vpl VALUES ("EP3_7","079_3_7","EPH","3","7","7","ፆሳይ ባ ኦꬂያ ዎልቃ ባጋራ ታው ኢሚዳ ኣꬎ ኬሃቴꬃን ሃ ዎንጌላስ ኦሳንቾ ጊዳስ። ");
INSERT INTO gofENT_vpl VALUES ("EP3_8","079_3_8","EPH","3","8","8","ታኒ ጌሻታ ኡባፌ ላፋ ጊዲኮካ ኣይሁዴ ጊዶና ኣሳስ ዛዊ ባይና ኪሪስቶሳ ዱሬቴꬃ ዎንጌላ ኦዳና ሜላ ሃ ኣꬎ ኬሃቴꬃይ ታው ኢሜቲስ። ");
INSERT INTO gofENT_vpl VALUES ("EP3_9","079_3_9","EPH","3","9","9","ቃሲ ካሴ ዎዲያን ኡባ ሜꬊዳ ፆሳን ቆሴቲዲ ዴዒያ ፁራስ፥ ፆሳ ቆፋይ ኣይቤኮ ቆንጪሳናው ኣꬎ ኬሃቴꬃይ ታው ኢሜቲስ። ");
INSERT INTO gofENT_vpl VALUES ("EP3_10","079_3_10","EPH","3","10","10","ፆሳይ ሄሳ ኦꬂዳይ ሃዒ ዎዲያን ዎሳ ኬꬃ ባጋራ ሳሎ ሶሁዋን ዴዒያ ሃላቃታሲኔ ሃሬይሳታስ ባ ዱማ ዱማ ቆንጬꬃ ኤሪሳናሳ። ");
INSERT INTO gofENT_vpl VALUES ("EP3_11","079_3_11","EPH","3","11","11","ፆሳይ ባ ሜሪና ቆፋ ኑ ጎዳ ኪሪስቶስ ዬሱሳ ባጋራ ፖላናው ሄሳ ኦꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("EP3_12","079_3_12","EPH","3","12","12","ኑ ኣማኖን ያሺ ባይና ፆሳኮ ሺቃና ሜላ ኪሪስቶሲ ኑስ ሚኖቴꬂኔ ላዓቴꬂ ኢሚስ። ");
INSERT INTO gofENT_vpl VALUES ("EP3_13","079_3_13","EPH","3","13","13","ታኒ ሂንቴ ጊሾ ዋዬ ኤኪያ ጊሾ ሂንቴ ታ ዋያን ዬላቶናዳ ሂንቴና ዎሳይስ፤ ታኒ ሂንቴ ቦንቹዋስ ዋዬታይስ። ");
INSERT INTO gofENT_vpl VALUES ("EP3_14","079_3_14","EPH","3","14","14","ታኒ ኣዋ ሲንꬃን ጉልባታዳ ዎሴይ ሄሳ ጊሾሳ። ");
INSERT INTO gofENT_vpl VALUES ("EP3_15","079_3_15","EPH","3","15","15","ሳሎኒኔ ሳዓን ዴዒያ ኢሲ ኢሲ ሶ ኣሳይ ኢያን ሱንꬄቴስ። ");
INSERT INTO gofENT_vpl VALUES ("EP3_16","079_3_16","EPH","3","16","16","ፆሳይ ባ ቦንቾ ዱሬቴꬃፌ ሂንቴ ጋርሳ ኣሳቴꬃ ሚንꬂያ ዎልቃ ባ ኣያና ባጋራ ኢማና ሜላ ሂንቴው ዎሳይስ። ");
INSERT INTO gofENT_vpl VALUES ("EP3_17","079_3_17","EPH","3","17","17","ቃሲ ኣማኖን ኪሪስቶሲ ሂንቴ ዎዛናን ዳና ሜላኔ ሂንቴ ሲቆን ፃጶ ዬዲዲ ሚኒዲ ዳና ሜላ ዎሳይስ። ");
INSERT INTO gofENT_vpl VALUES ("EP3_18","079_3_18","EPH","3","18","18","ሄሳዳካ፥ ኪሪስቶሳ ሲቆይ ኣይ ሜላ ዳልጌኮ፥ ኣዱሴኮ፥ ꬎቄኮኔ ጪሞኮ ጌሻታ ኡባራ ኤሪያ ዎልቃ ሂንቴ ኣኬካና ሜላ ዎሳይስ። ");
INSERT INTO gofENT_vpl VALUES ("EP3_19","079_3_19","EPH","3","19","19","ኤራቴꬃፌ ኣꬊያ ኪሪስቶሳ ሲቁዋ ሂንቴ ኤራና ሜላ ቃሲ ዴዖ ኢሚያ ፆሳ ዎልቃን ሂንቴ ኩማና ሜላ ታ ዎሳይስ። ");
INSERT INTO gofENT_vpl VALUES ("EP3_20","079_3_20","EPH","3","20","20","ሂዛ፥ ኑ ጊዶን ኦꬂያ ባ ዎልቃ ባጋራ ኑኒ ዎሴይሳፌ ዎይኮ ቆፔይሳፌ ኣꬂዲ ኦꬃናው ዳንዳዒያ ፆሳስ፥ ");
INSERT INTO gofENT_vpl VALUES ("EP3_21","079_3_21","EPH","3","21","21","ዎሳ ኬꬃኒኔ ኪሪስቶስ ዬሱሳን ዎዴ ኡባን ሜሪናፔ ሜሪና ጋካናው ቦንቾይ ጊዶ። ኣሚንዒ። ");
INSERT INTO gofENT_vpl VALUES ("EP4_1","079_4_1","EPH","4","1","1","ሂዛ፥ ጎዳ ጊሾ ቃሼቲዳ ታኒ፥ ሂንቴ ፄጌቲዳ ፄሳስ ቤሲያ ዴዖ ዳና ሜላ ሂንቴና ዎሳይስ። ");
INSERT INTO gofENT_vpl VALUES ("EP4_2","079_4_2","EPH","4","2","2","ሂንቴ ኡባ ዎዴ ኣዳኔ ሃዮ ጊዲቴ፤ ኢሶይ ኢሱዋ ዳንዳዒቴኔ ሲቆን ዴዒቴ። ");
INSERT INTO gofENT_vpl VALUES ("EP4_3","079_4_3","EPH","4","3","3","ሳሮቴꬃን ቃሼቲዲ ኣያናይ ኢሚያ ኢሲፌቴꬃ ናጋናው ሚኒቴ። ");
INSERT INTO gofENT_vpl VALUES ("EP4_4","079_4_4","EPH","4","4","4","ፆሳይ ሂንቴና ፄጊዳ ዎዴ ኢሲ ኡፋይሳስ ፄጊዳይሳዳ ኢሲ ኣሳቴꬂኔ ኢሲ ኣያኒ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("EP4_5","079_4_5","EPH","4","5","5","ኢሲ ጎዳይ፥ ኢሲ ኣማኖይኔ ኢሲ ፂንቃቴይ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("EP4_6","079_4_6","EPH","4","6","6","ኡባፌ ቦላ ጊዲዳ፥ ኡባ ባጋራ ኦꬂያኔ ኡባ ጊዶን ዴዒያ ኢሲ ፆሳይ፥ ኡባ ኣዋይ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("EP4_7","079_4_7","EPH","4","7","7","ሺን ኪሪስቶሲ ኢማናው ኮዪዳይሳዳ ኑ ኢሶይ ኢሶይ ዱማ ዱማ ኢሞታ ኤኪዳ። ");
INSERT INTO gofENT_vpl VALUES ("EP4_8","079_4_8","EPH","4","8","8","ሄሳ ጊሾ፥ ፆሳ ቃላይ፥ «ኢ ፑዴ ኬዪዳ ዎዴ ዲዔቲዳ ዳሮታ ባራ ኤኪዲ ቢስ፤ ኣሳስካ ኢሞታ ኢሚስ» ያጌስ። ");
INSERT INTO gofENT_vpl VALUES ("EP4_9","079_4_9","EPH","4","9","9","ያቲን፥ «ፑዴ ኬዪስ» ጉሳይ ዎይ ጉሴ? ኢ ኮይሮ ዱጌ፥ ሳዓ ዚቃ ቤሳ ዎꬊስ ጉሱ ጊዶና ኢፂኮ ኣይ ጉሴ? ");
INSERT INTO gofENT_vpl VALUES ("EP4_10","079_4_10","EPH","4","10","10","ሃ ዱጌ ዎꬊዳይሲ፥ ኡባ ቤሳን ቤንታናው ኡባፌ ꬎቃ ሳሉዋ ኬዪዳይሲ ኢያ። ");
INSERT INTO gofENT_vpl VALUES ("EP4_11","079_4_11","EPH","4","11","11","ኢ ኢሶታ ኢሶታ ሃዋሬታ፥ ኢሶታ ኢሶታ ናቤታ፥ ኢሶታ ኢሶታ ዎንጌላ ሳባኬታ፥ ኢሶታ ኢሶታ ዎሳ ኬꬂ ሄሜይሳታ፥ ኢሶታ ኢሶታ ኣስታማሬታ ኦꬂዲ ኢሚስ። ");
INSERT INTO gofENT_vpl VALUES ("EP4_12","079_4_12","EPH","4","12","12","ኢ ሄሳ ኦꬂዳይ ኪሪስቶሳ ኣሳቴꬂ ጊዲዳ ዎሳ ኬꬂ ዲቻናዉኔ ኣማኒያ ኣሳ ፆሳ ኦሶስ ጊጊሳናሳ። ");
INSERT INTO gofENT_vpl VALUES ("EP4_13","079_4_13","EPH","4","13","13","ሄሳዳካ፥ ኑ ኡባይ ፆሳ ናዓ ኤሪዲ ኣማኖን ቤንቲያ ኢሲፌቴꬃኮ ጋኪዲ፥ ኪሪስቶሳ ኣያና ዴዑዋ ኩሜꬃ ጋኪዲ ዲጫና ሜላሳ። ");
INSERT INTO gofENT_vpl VALUES ("EP4_14","079_4_14","EPH","4","14","14","ሂዛፔ ጉዬ፥ ኣሳ ጌኔ ጪሞን ጊጊዳ ባሌꬂያ ዎርዶ ቲሚርቴ ጫርኮኒኔ ሆቤን ጌዴኔ ሃ ኩሎ ካዒያ ናይታ ሜላ ጊዳናው ቤሴና። ");
INSERT INTO gofENT_vpl VALUES ("EP4_15","079_4_15","EPH","4","15","15","ሺን ኑኒ ቱማ ሲቆን ኦዲሼ ኣሳቴꬃስ ሁዔ ጊዲያ ኪሪስቶሳራ ዴዒያ ኢሲፌቴꬃ ጉጂ ጉጂ ዲቾስ። ");
INSERT INTO gofENT_vpl VALUES ("EP4_16","079_4_16","EPH","4","16","16","ኩሜꬃ ኣሳቴꬃይ ኪሪስቶሳ ቦላ ዜምፔስ ቃሲ ዱማ ዱማ ኣሳቴꬃ ቢሊቴቲ ኢሶይ ኢሱዋራ ኦይኬቲዲ ኡቲስ። ኢሲ ኢሲ ኣሳቴꬃ ኪፊሌይ ባ ኦሱዋ ኦꬂያ ዎዴ ኩሜꬃ ኣሳቴꬃይ ሲቆን ዲጬስ። ");
INSERT INTO gofENT_vpl VALUES ("EP4_17","079_4_17","EPH","4","17","17","ሄሳ ጊሾ፥ ታኒ ሃይሳ ሂንቴው ጎዳ ሱንꬃን ኦዳይሲኔ ማርካታይስ። ጎዒ ባይና ቆፋ ቆፒያ ኣይሁዴ ጊዶና ኣሳታዳ ዴዖፒቴ። ");
INSERT INTO gofENT_vpl VALUES ("EP4_18","079_4_18","EPH","4","18","18","ኤንታ ቆፋይ ꬉሚስ፤ ባንታ ዎዛና ሙሚሲዶሶና። ኤንቲ ኤራቴꬃ ꬋዮኒኔ ኢፃስ ጊዲ ፆሳይ ኢሚያ ዴዑዋፔ ሃኪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("EP4_19","079_4_19","EPH","4","19","19","ኤንቲ ዬላ ጊያባ ኤሮኮና፤ ኤንቲ ላይማቴꬃስ ባንታና ኣꬂ ኢሚዶሶና፤ ቃሲ ቱናባ ኡባ ጉዬ ጎና ኦꬆሶና። ");
INSERT INTO gofENT_vpl VALUES ("EP4_20","079_4_20","EPH","4","20","20","ሺን ሂንቴ ኪሪስቶሳ ኤሪዳይ ሄሳ ሜላ ኦጌን ጊዴና። ");
INSERT INTO gofENT_vpl VALUES ("EP4_21","079_4_21","EPH","4","21","21","ኢያባ ቱማ ሲዒዴታ። ቃሲ ዬሱሳን ዴዒያ ቱማ ሜላ ኢያፔ ታማሪዴታ። ");
INSERT INTO gofENT_vpl VALUES ("EP4_22","079_4_22","EPH","4","22","22","ሂንቴ ካሴ ዴዒያ ዴዖ ኦጊያ ኣጊቴ። ቃሲ ባ ጪሚያ ኣሞን ꬋያ ሂንቴ ጬጋ ኣሳቴꬃ ዲጊቴ። ");
INSERT INTO gofENT_vpl VALUES ("EP4_23","079_4_23","EPH","4","23","23","ሂንቴ ዎዛና ቆፋን ኦራፂቴ። ");
INSERT INTO gofENT_vpl VALUES ("EP4_24","079_4_24","EPH","4","24","24","ቱማ ፂሎቴꬃኒኔ ጌሻቴꬃን ፆሳ ሌሚሶን ሜꬌቲዳ ኦራꬃ ኣሳቴꬃ ማዒቴ። ");
INSERT INTO gofENT_vpl VALUES ("EP4_25","079_4_25","EPH","4","25","25","ሂዛ፥ ዎርዶ ኦዴቶፊቴ። ኑኒ ኡባይ ኪሪስቶሳ ኣሳቴꬃ ቢሊቴታ ጊዲያ ጊሾ ኣሳ ኡባራ ቱማ ኦዴቲቴ። ");
INSERT INTO gofENT_vpl VALUES ("EP4_26","079_4_26","EPH","4","26","26","ሃንቄቲቴ፥ ሺን ሂንቴ ሃንቁዋን ናጋራ ኦꬆፊቴ። ሂንቴ ሃንቄቲ ዴዒሺን ኣዊ ዉሎፎ። ");
INSERT INTO gofENT_vpl VALUES ("EP4_27","079_4_27","EPH","4","27","27","ፃላሄስ ቤሴ ኢሞፊቴ። ");
INSERT INTO gofENT_vpl VALUES ("EP4_28","079_4_28","EPH","4","28","28","ካይሲያ ኡራይ ሂዛፔ ጉዬ ካይሶቶፖ። ሺን ማንቆታ ማዲያባይ ኢያው ዳና ሜላ ባ ኩሼን ሎዖባ ኦꬆ። ");
INSERT INTO gofENT_vpl VALUES ("EP4_29","079_4_29","EPH","4","29","29","ሂንቴ ዶናፔ ኢታ ቃሊ ኬዮፖ። ሺን ሲዔይሳታ ጎዓና ሜላኔ ሃራታ ሚንꬄꬂያ ኮሺያ ሎዖ ቃሊ ሂንቴ ዶናፔ ኬዮ። ");
INSERT INTO gofENT_vpl VALUES ("EP4_30","079_4_30","EPH","4","30","30","ፆሳይ ሂንቴና ዎዚያ ጋላሳስ ሂንቴና ኣታሚዲ ዎꬂዳ ፆሳ ኣያና ኣዛንꬆፊቴ። ");
INSERT INTO gofENT_vpl VALUES ("EP4_31","079_4_31","EPH","4","31","31","ጫሜቴꬂ፥ ዪሎ፥ ሃንቆ፥ ዋሶ፥ ጫሼኔ ኢታ ኡባ ሂንቴፌ ሃሲቴ። ");
INSERT INTO gofENT_vpl VALUES ("EP4_32","079_4_32","EPH","4","32","32","ኣꬂዲ ኢሶይ ኢሱዋስ ኬሃኔ ቃꬌቴይሳታ ጊዲቴ። ፆሳይ ኪሪስቶሳ ባጋራ ሂንቴው ኣቶ ጊዳይሳዳ ሂንቴካ ዎሊስ ኣቶ ጊቴ። ");
INSERT INTO gofENT_vpl VALUES ("EP5_1","079_5_1","EPH","5","1","1","ሂዛ፥ ፆሳይ ዶሲያ ናይታዳ ኢያ ዳኒቴ። ");
INSERT INTO gofENT_vpl VALUES ("EP5_2","079_5_2","EPH","5","2","2","ኪሪስቶሲ ኑና ዶሲዲ ባና ኑ ጊሾ ፆሳስ ሳዊያ ኢሞኔ ያርሾ ኦꬂዲ ኢሚዳይሳዳ ሂንቴካ ሲቆን ዴዒቴ። ");
INSERT INTO gofENT_vpl VALUES ("EP5_3","079_5_3","EPH","5","3","3","ሺን ላይማቴꬂ፥ ቱናቴꬂኔ ኡዜቴꬂ ኣማኒያ ኣሳስ ቤሶና ጊሾ ሂንቴ ጊዶን ኡባራካ ሲዔቶፎ። ");
INSERT INTO gofENT_vpl VALUES ("EP5_4","079_5_4","EPH","5","4","4","ፆሳ ጋላቲቴፔ ኣቲን ዬላያባይኔ ኤያ ኦዲ ዎይኮ ቂꬌይ ሂንቴው ቤሶና ጊሾ ሂንቴ ጊዶን ኡባካ ዴዖፖ። ");
INSERT INTO gofENT_vpl VALUES ("EP5_5","079_5_5","EPH","5","5","5","ሃይሳ ኤሪቴ፤ ኦኒካ ላይማቴይ ዎይኮ ቱናባ ኦꬄይ ዎይኮ ኡዜቴይ ኪሪስቶሳ ካዎቴꬃኔ ፆሳ ካዎቴꬃ ላታናው ዳንዳዔና። ኡዜቴꬂ ኤቃ ጎይኖ ሜላ። ");
INSERT INTO gofENT_vpl VALUES ("EP5_6","079_5_6","EPH","5","6","6","ሃይሳታ ጋሶን ፆሳ ሃንቆይ ኪቴቶና ኣሳ ቦላ ያና ጊሾ ኦኒካ ሂንቴና ፓꬆና ኦዳን ጪሞፎ። ");
INSERT INTO gofENT_vpl VALUES ("EP5_7","079_5_7","EPH","5","7","7","ሄሳ ሜላ ኣሳራ ኢሲፌቴꬂ ኦꬆፊቴ። ");
INSERT INTO gofENT_vpl VALUES ("EP5_8","079_5_8","EPH","5","8","8","ካሴ ሂንቴ ꬉማን ዴዒዴታ፥ ሺን ሃዒ ጎዳ ባጋራ ፖዖን ዴዔታ። ሂዛ፥ ፖዖ ኣሳዳ ፖዖን ሲሜሬቲቴ። ");
INSERT INTO gofENT_vpl VALUES ("EP5_9","079_5_9","EPH","5","9","9","ፖዖይ ሎዖቴꬂ፥ ፂሎቴꬂኔ ቱማቴꬂ ኣይፌስ። ");
INSERT INTO gofENT_vpl VALUES ("EP5_10","079_5_10","EPH","5","10","10","ጎዳ ኡፋይሲያባ ኦꬃናው ኮዪቴ። ");
INSERT INTO gofENT_vpl VALUES ("EP5_11","079_5_11","EPH","5","11","11","ጎዒ ባይና ꬉማ ኦሶ ቆንጪሲቴፔ ኣቲን ኢያራ ኢሲፎፒቴ። ");
INSERT INTO gofENT_vpl VALUES ("EP5_12","079_5_12","EPH","5","12","12","ኤንቲ ጌማን ኦꬂያ ኦሱዋ ሃሪ ኣቶሺን ኦዳናዉካ ዬላዬስ። ");
INSERT INTO gofENT_vpl VALUES ("EP5_13","079_5_13","EPH","5","13","13","ሺን ኡባባይ ፖዖን ኬያ ዎዴ ቆንጬን ቤንቴስ። ");
INSERT INTO gofENT_vpl VALUES ("EP5_14","079_5_14","EPH","5","14","14","ፖዖይ ኡባባ ቆንጬን ቤሴስ። ሄሳ ጊሾ፥ «ኔኖ ꬊስኬይሶ ባርካ፤ ሃይቆፔ ዴንዳ፤ ኪሪስቶሲ ኔ ቦላ ፖዓና» ያጌቲስ። ");
INSERT INTO gofENT_vpl VALUES ("EP5_15","079_5_15","EPH","5","15","15","ሂዛ፥ ሂንቴ ዋኒዲ ዴዒያኮ ኣኬኪ ቤዒቴ። ጪንጫታ ጊዲቴፔ ኣቲን ኤያታ ጊዶፒቴ። ");
INSERT INTO gofENT_vpl VALUES ("EP5_16","079_5_16","EPH","5","16","16","ላይꬃይ ኢታ ጊዲያ ጊሾ ኢንጄቲያ ዎዴ ኡባ ጎዔቲቴ። ");
INSERT INTO gofENT_vpl VALUES ("EP5_17","079_5_17","EPH","5","17","17","ሄሳ ጊሾ፥ ጎዳ ሼኔይ ኣይቤኮ ኣኬኪቴፔ ኣቲን ኤዮፒቴ። ");
INSERT INTO gofENT_vpl VALUES ("EP5_18","079_5_18","EPH","5","18","18","ጌሻ ኣያናን ጋላስ ጋላስ ኩሚቴፔ ኣቲን ꬋዮኮ ሂንቴና ካሌꬂያ ጊሾ ዎይኔ ኡሻን ማꬆቶፊቴ። ");
INSERT INTO gofENT_vpl VALUES ("EP5_19","079_5_19","EPH","5","19","19","ማዝሙሬን፥ ሳባኒኔ ኣያና ዬꬃን፥ ኢሶይ ኢሱዋራ ኦዴቲቴ። ቃሲ ሂንቴ ዎዛናን ዛማሪሼኔ ሳቢሼ ጎዳ ጋላቲቴ። ");
INSERT INTO gofENT_vpl VALUES ("EP5_20","079_5_20","EPH","5","20","20","ኑ ጎዳ ዬሱስ ኪሪስቶሳ ሱንꬃን ኡባ ዎዴ ፆሳ ኣዋ ኡባባስ ጋላቲቴ። ");
INSERT INTO gofENT_vpl VALUES ("EP5_21","079_5_21","EPH","5","21","21","ኪሪስቶሳ ቦንቹዋስ ጊዲ ኢሶይ ኢሱዋስ ሃሬቲቴ። ");
INSERT INTO gofENT_vpl VALUES ("EP5_22","079_5_22","EPH","5","22","22","ማቼቶ፥ ጎዳስ ሃሬቴይሳዳ ሂንቴ ኣዚናታስ ሃሬቲቴ። ");
INSERT INTO gofENT_vpl VALUES ("EP5_23","079_5_23","EPH","5","23","23","ኪሪስቶሲ ዎሳ ኬꬃስ ሁዔ ጊዴይሳዳ ኣዚኒካ ባ ማቼስ ሁዔ። ቃሲ ኪሪስቶሲ ባ ኣሳቴꬂ ጊዲዳ ዎሳ ኬꬃ ኣሼይሳ። ");
INSERT INTO gofENT_vpl VALUES ("EP5_24","079_5_24","EPH","5","24","24","ሺን ዎሳ ኬꬃይ ኪሪስቶሳስ ሃሬቴይሳዳ ማቼቲ ባንታ ኣዚናታስ ኡባባን ሃሬታናው ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("EP5_25","079_5_25","EPH","5","25","25","ኣዚናቶ፥ ኪሪስቶሲ ዎሳ ኬꬃ ዶሲዲ ባና ኢው ኢሚዳይሳዳ ሂንቴካ ሂንቴ ማቼታ ዶሲቴ። ");
INSERT INTO gofENT_vpl VALUES ("EP5_26","079_5_26","EPH","5","26","26","ኢ ዎሳ ኬꬃ ባ ቃላ ባጋራ ሃꬃን ሜጪዲ ጌሺስ። ");
INSERT INTO gofENT_vpl VALUES ("EP5_27","079_5_27","EPH","5","27","27","ኪሪስቶሲ ዎሳ ኬꬃ ቂቲ ዎይኮ ሶምዖ ቱሲ ዎይኮ ሄሳ ሜላባይ ባይና ኢ ኩሜꬃ ቦንቹዋራ ጌሺኔ ቦሬቶናሮ ኦꬂዲ ባኮ ሺሻናው ኮዪዲ ሄሳ ኦꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("EP5_28","079_5_28","EPH","5","28","28","ሄሳዳካ፥ ኣዚናቲ ባንታና ዶሴይሳዳ ባንታ ማቼታ ዶሳናው ቤሴስ። ባ ማቺው ዶሴይሲ ባና ዶሴስ። ");
INSERT INTO gofENT_vpl VALUES ("EP5_29","079_5_29","EPH","5","29","29","ባና ኢፂያ ኣሲ ኦኒካ ባዋ፥ ሺን ኪሪስቶሲ ዎሳ ኬꬃስ ኦꬄይሳዳ ባ ኣሳቴꬃ ሙዜሲኔ ናጌስ። ");
INSERT INTO gofENT_vpl VALUES ("EP5_30","079_5_30","EPH","5","30","30","ኑኒ ኪሪስቶሳ ኣሳቴꬃ ቢሊቴታ። ");
INSERT INTO gofENT_vpl VALUES ("EP5_31","079_5_31","EPH","5","31","31","ፆሳ ቃላይ፥ «ሄሳ ጊሾ፥ ኣሲ ባ ኣዋኔ ባ ኣዪው ኣጊዲ፥ ባ ማቼራ ኢሲፌ ዳና፤ ኤንቲ ናምዓይካ ኢሲ ኣሾ ጊዳና» ያጌስ። ");
INSERT INTO gofENT_vpl VALUES ("EP5_32","079_5_32","EPH","5","32","32","ሃይሲ ጊታ ፁራ፥ ሺን ታኒ ሄሳ ኪሪስቶሳባኔ ዎሳ ኬꬃባ ሌሚሶ ኦꬃዳ ኦዳይስ። ");
INSERT INTO gofENT_vpl VALUES ("EP5_33","079_5_33","EPH","5","33","33","ጊዶሺን፥ ሂንቴ ኢሶይ ኢሶይ ሂንቴ ማቼታ ሂንቴ፥ ሂንቴና ዶሴይሳዳ ዶሲቴ። ኢሲ ኢሲ ማቻ ባ ኣዚና ቦንቻናው ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("EP6_1","079_6_1","EPH","6","1","1","ናይቶ፥ ሂንቴ ጎዳባ ጊዲያ ጊሾ ሂንቴና ዬሊዳይሳታስ ኪቴቲቴ። ሄሲ ሂንቴው ቤሲያባ። ");
INSERT INTO gofENT_vpl VALUES ("EP6_2","079_6_2","EPH","6","2","2","«ኔ ኣዪዉኔ ኔ ኣዋ ቦንቻ።» ሄሲ ኡፋይሳ ቃሊ ዴዒያ ኮይሮ ኪታ። ");
INSERT INTO gofENT_vpl VALUES ("EP6_3","079_6_3","EPH","6","3","3","«ኔ ሄሳ ፖሊያባ ጊዲኮ ኡባይ ኔው ኢንጄታና፤ ኔ ላይꬃይ ሳዓ ቦላ ኣዱቃና።» ");
INSERT INTO gofENT_vpl VALUES ("EP6_4","079_6_4","EPH","6","4","4","ኣዋቶ፥ ሂንቴ ናይታ ጎዳ ቃላ ታማርሶኒኔ ኤንታ ካሌሶን ዲቺቴፔ ኣቲን ኤንታና ጫሚሶፒቴ። ");
INSERT INTO gofENT_vpl VALUES ("EP6_5","079_6_5","EPH","6","5","5","ኣይሌቶ፥ ኪሪስቶሳስ ኪቴቴይሳዳ ሂንቴ ሳዓ ጎዳታስ ያሻን፥ ቦንቾኒኔ ሱሬ ዎዛናን ኪቴቲቴ። ");
INSERT INTO gofENT_vpl VALUES ("EP6_6","079_6_6","EPH","6","6","6","ኤንታ ሲንꬃን ሳባ ዴማናው ኤንቲ ቤዒያ ዎዴ ፃላላ ኦꬆፊቴ። ሺን ኪሪስቶሳ ኣይሌታዳ ፆሳ ሼኒያ ዎዛናፔ ፖሊቴ። ");
INSERT INTO gofENT_vpl VALUES ("EP6_7","079_6_7","EPH","6","7","7","ኣሳስ ጊዶናሺን ጎዳስ ጊዲ ሂንቴ ኩሜꬃ ዎዛናፔ ኦꬂቴ። ");
INSERT INTO gofENT_vpl VALUES ("EP6_8","079_6_8","EPH","6","8","8","ኣይሌ ጊዲን ዎይኮ ጎዳ ጊዲን ኢሶይ ኢሶይ ባ ኦꬂዳ ሎዖ ኦሱዋስ ጎዳፔ ዎይቶ ኤካናይሳ ኤሬታ። ");
INSERT INTO gofENT_vpl VALUES ("EP6_9","079_6_9","EPH","6","9","9","ጎዳቶ፥ ኣሳ ሶምዖ ቤዒዲ ማዶና ጎዳይ፥ ሳሉዋን ዴዔይሳ ኤሬታ። ሄሳ ጊሾ፥ ሂንቴ ኣይሌታ ማንዴይሳ ኣጊዲ ኤንቲ ሂንቴው ቦንቾን ኪቴቴይሳ ሜላ ሂንቴ ኤንታው ሎዖባ ኦꬂቴ። ");
INSERT INTO gofENT_vpl VALUES ("EP6_10","079_6_10","EPH","6","10","10","ዉርሴꬃን፥ ጎዳኒኔ ኢያ ጊታ ዎልቃን ሚኒቴ። ");
INSERT INTO gofENT_vpl VALUES ("EP6_11","079_6_11","EPH","6","11","11","ፃላሄ ጪሙዋ ኤቄታናው ዳንዳዓና ሜላ ፆሳይ ሂንቴው ኢሚዳ ኦላ ሚሺያ ኡባ ማዒቴ። ");
INSERT INTO gofENT_vpl VALUES ("EP6_12","079_6_12","EPH","6","12","12","ኑ ኦላይ ኣሳራ ጊዶናሺን ሳሎን ዴዒያ ቱና ኣያና ኦላንቾታራ፥ ማታ ኣዋታራ፥ ሃሬይሳታራኔ ሃ ꬉማ ኣላሚያ ዎልቃታራ። ");
INSERT INTO gofENT_vpl VALUES ("EP6_13","079_6_13","EPH","6","13","13","ሄሳ ጊሾ፥ ኢታ ጋላሳ ቴቃናዉኔ ኡባ ፖሊዲ፥ ሚኒዲ ኤቃናው ሂንቴ ዳንዳዓና ሜላ ፆሳ ኦላ ሚሼታ ኡባ ማዒቴ። ");
INSERT INTO gofENT_vpl VALUES ("EP6_14","079_6_14","EPH","6","14","15","ቱማ ፄሳን ዳንጮዳ ዳንጪዲ፥ ፂሎቴꬃ ፁሩሬዳ ቲራን ዎꬂዲ፥ ሳሮቴꬃ ዎንጌላ ሂንቴ ቶሁዋን ጫማዳ ኣꬂዲ ሚኒዲ ኤቂቴ። ");
INSERT INTO gofENT_vpl VALUES ("EP6_16","079_6_16","EPH","6","16","16","ሄ ኡባፌ ኣꬂዲ፥ ፃላሄይ ዬዲያ ላፂያ ታማ ዶንጌ ኡባ ቶይሳናው ዳንዳዒያ ኣማኑዋ ኡባ ዎዴ ጎንዳሌዳ ኦይኪቴ። ");
INSERT INTO gofENT_vpl VALUES ("EP6_17","079_6_17","EPH","6","17","17","ፆሳ ኣቶቴꬃ ቢራታ ባርኔፃዳ ሂንቴ ሁዔን ዎꬂቴ፤ ቃሲ ጌሻ ኣያና ማሻ፥ ኢካ ፆሳ ቃላ ኦይኪቴ። ");
INSERT INTO gofENT_vpl VALUES ("EP6_18","079_6_18","EPH","6","18","18","ዎሳ ኣጎፊቴ፤ ሃራታስካ ጋናቲቴ፤ ኡባ ዎዴ ኣያናን ዎሲቴ። ሄሳን፥ ጌሻታስ ሳሌቶና ሚኒዲ ኡባ ዎዴ ዎሲቴ። ");
INSERT INTO gofENT_vpl VALUES ("EP6_19","079_6_19","EPH","6","19","19","ታኒ ዎንጌላ ፁራ ያሺ ባይና ቆንጪሳዳ ኦዳና ሜላ ፆሳይ ታው ቃላ ኢማና ሜላ ዎሲቴ። ");
INSERT INTO gofENT_vpl VALUES ("EP6_20","079_6_20","EPH","6","20","20","ታኒ ሄሳ ኦꬃናው ኪቴታስ ሃዒካ ቃሾን ዴዔይ ሄ ዎንጌላ ጊሾሳ። ያኒያ ጊሾ፥ ታኒ ያሺ ባይና ቤሴይሳዳ ኦዳና ሜላ ታው ዎሲቴ። ");
INSERT INTO gofENT_vpl VALUES ("EP6_21","079_6_21","EPH","6","21","21","ታኒ ዋና ዴዒያኮኔ ኣይ ኦꬂያኮ ሂንቴ ኤራና ሜላ ኑ ሲቆ ኢሻይ፥ ጎዳ ኦሱዋን ኣማኔቲዳ ኦሳንቾይ፥ ቲኪቆሲ፥ ታባ ኡባ ሂንቴው ኦዳና። ");
INSERT INTO gofENT_vpl VALUES ("EP6_22","079_6_22","EPH","6","22","22","ኑኒ ኡባይ ዋኒዲ ዴዒያኮ ሂንቴው ኦዳና ሜላኔ ሂንቴና ሚንꬄꬃና ሜላ ታኒ ኢያ ሂንቴኮ ኪታስ። ");
INSERT INTO gofENT_vpl VALUES ("EP6_23","079_6_23","EPH","6","23","23","ፆሳ ኣዋፔ፥ ጎዳ ዬሱስ ኪሪስቶሳፔ ሳሮቴꬃይኔ ሲቆይ ኣማኖራ ኢሲፌ ኣማኒያ ኡባስ ጊዶ። ");
INSERT INTO gofENT_vpl VALUES ("EP6_24","079_6_24","EPH","6","24","24","ኢርፆና ሲቆን ኑ ጎዳ ዬሱስ ኪሪስቶሳ ሲቂያ ኡባራ ፆሳ ኣꬎ ኬሃቴꬃይ ጊዶ። ");
INSERT INTO gofENT_vpl VALUES ("PP1_1","080_1_1","PHP","1","1","1","ኪሪስቶስ ዬሱሳራ ኢሲፊዳ ጊሾ ፆሳባ ጊዲዳ፥ ፊልጲሲዩሳ ካታማን ዴዒያ ዎሳ ኬꬃ ጪማታሲኔ ዳቆኔታ ኡባስ። ዬሱስ ኪሪስቶሳ ኣይሌ ጊዲዳ፥ ጳዉሎሳፔኔ ፂሞቲዮሳፔ ኪቴቲዳ ኪታ። ");
INSERT INTO gofENT_vpl VALUES ("PP1_2","080_1_2","PHP","1","2","2","ኑ ኣዋ ፆሳፌኔ ጎዳ ዬሱስ ኪሪስቶሳፔ ኣꬎ ኬሃቴꬃይኔ ሳሮቴꬃይ ሂንቴው ጊዶ። ");
INSERT INTO gofENT_vpl VALUES ("PP1_3","080_1_3","PHP","1","3","3","ታኒ ሂንቴና ቆፒያ ዎዴ ኡባን፥ ታ ፆሳ ጋላታይስ። ");
INSERT INTO gofENT_vpl VALUES ("PP1_4","080_1_4","PHP","1","4","4","ታኒ ሂንቴ ኡባስ ፆሳ ዎሲያ ዎዴ ኡፋይሳን ዎሳይስ። ");
INSERT INTO gofENT_vpl VALUES ("PP1_5","080_1_5","PHP","1","5","5","ሂንቴ ኮይሮ ጋላሳፔ ሃዒ ጋካናው፥ ዎንጌላ ማርካቴይሳን ታራ ኢሲፌ ጊዲዲ፥ ታና ማዲዳ ጊሾ ፆሳ ጋላታይስ። ");
INSERT INTO gofENT_vpl VALUES ("PP1_6","080_1_6","PHP","1","6","6","ሂንቴ ጊዶን ሎዖ ኦሶ ዶሚዳ ፆሳይ፥ ኪሪስቶስ ዬሱሲ ሲሚያ ጋላሳይ ጋካናው፥ ፖላናይሳ ኤራይስ። ");
INSERT INTO gofENT_vpl VALUES ("PP1_7","080_1_7","PHP","1","7","7","ሂንቴ ኡባ ዎዴ ታ ዎዛናን ዴዔታ። ታኒ ኡባ ዎዴካ ሄሳዳ ቆፓናው ቤሴስ። ሃዒ ታኒ ቃሾን ዴዓሼኔ ቃሼታናፔ ሲንꬄ ዎንጌላ ናጎኒኔ ዎንጌላ ሚንꬃ ኤሶን ፆሳይ ታው ቃዲዳ ቃዳ ሂንቴካ ታራ ሻኬቲዴታ። ");
INSERT INTO gofENT_vpl VALUES ("PP1_8","080_1_8","PHP","1","8","8","ታኒ ሂንቴና ኡባ ኪሪስቶስ ዬሱሳ ሲቁዋን ኣይ ሜላ ላሞቲያኮ ፆሳይ ታው ማርካ። ");
INSERT INTO gofENT_vpl VALUES ("PP1_9","080_1_9","PHP","1","9","9","ሂንቴ ሲቆይ ቱማ ኤራቴꬃራኔ ኣኬካራ ኢሲፌ ጉጂ ጉጂ ዲጫና ሜላ ፆሳ ዎሳይስ። ");
INSERT INTO gofENT_vpl VALUES ("PP1_10","080_1_10","PHP","1","10","10","ሄሳን ሂንቴ ሎዖባ ሻኪዲ፥ ዶሬይሳታ፥ ኪሪስቶሲ ሲሚያ ጋላሳን ጌሻታኔ ቦሬቶናይሳታ ጊዳና። ");
INSERT INTO gofENT_vpl VALUES ("PP1_11","080_1_11","PHP","1","11","11","ሂንቴ ዴዖይ ፆሳ ቦንቹዋሲኔ ጋላታስ ዬሱስ ኪሪስቶሳ ባጋራ ቤንቲያ ፂሎቴꬃ ኣይፊያን ኩሚዲ ኣይፋና። ");
INSERT INTO gofENT_vpl VALUES ("PP1_12","080_1_12","PHP","1","12","12","ታ ኢሻቶ፥ ታና ጋኪዳ ኡባይ ዎንጌላይ ዳልጋና ሜላ ቱማ ማዲዳይሳ ሂንቴ ኤራና ሜላ ኮያይስ። ");
INSERT INTO gofENT_vpl VALUES ("PP1_13","080_1_13","PHP","1","13","13","ታኒ ኪሪስቶሳ ጊሾ ቃሼቲዳይሳ፥ ካዎ ኬꬃ ናጌይሳቲኔ ሃይሳን ዴዒያ ሃራቲ ኡባይ ኤሮሶና። ");
INSERT INTO gofENT_vpl VALUES ("PP1_14","080_1_14","PHP","1","14","14","ታ ቃሹዋ ጋሶን ኑ ኢሻታፔ ዳሮቲ ጎዳን ኬሂ ኣማኔቲዶሶና። ሄሳ ጊሾ፥ ፆሳ ቃላ ያሺ ባይና ካሴይሳፌ ኣꬊ ሚኒዲ ኦዳና ሜላ ሚኖቴꬂ ዴሚዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("PP1_15","080_1_15","PHP","1","15","15","ጊዶሺን፥ ኢሶቲ ኢሶቲ ቃናቴኒኔ ፓላማን ኪሪስቶሳባ ኦዶሶና፥ ሺን ሃራቲ ሱሬ ዎዛናፔ ኦዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("PP1_16","080_1_16","PHP","1","16","16","ሱሬ ዎዛናፔ ኦዴይሳቲ፥ ፆሳይ ታው ዎንጌላ ናጎ ኦሶ ኢሚዳይሳ ኤሪያ ጊሾ ሲቆን ኦዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("PP1_17","080_1_17","PHP","1","17","17","ሺን ታና ቃናቴይሳቲ ታ ቃሹዋ ቦላ ሃራ ሜቶ ኤሃናባ ኤንታው ዳኒን ባንታና ዶሲዲ ኪሪስቶሳባ ኦዶሶናፔ ኣቲን ቱማ ዎዛናፔ ኦዶኮና። ");
INSERT INTO gofENT_vpl VALUES ("PP1_18","080_1_18","PHP","1","18","18","ሄሲ ኣይኮካ ሜቴና። ቱማ ኦጌን ጊዲን ዎይኮ ዎርዶ ኦጌን ጊዲን ሄ ኡባን ኪሪስቶሲ ሳባኬቴስ። ታና ሄሲ ኡፋይሴስ። ቃሲ ሃራባይ ታና ኡፋይሲያባይ፥ ");
INSERT INTO gofENT_vpl VALUES ("PP1_19","080_1_19","PHP","1","19","19","ታኒ ሂንቴ ዎሳኒኔ ዬሱስ ኪሪስቶሳ ኣያና ማዱዋን ኣታናይሳ ኤሪያ ጊሾ ታና ኡፋይሴስ። ");
INSERT INTO gofENT_vpl VALUES ("PP1_20","080_1_20","PHP","1","20","20","ታ ጊታ ኣሞይኔ ኡፋይሳን ናጊያ ናጎይ ታ ዬላቶና ኣታናይሳ። ሺን ኡባ ዎዴ ኦꬄይሳዳ፥ ሃዒካ ታኒ ፓፃ ዴዒን ዎይኮ ሃይቂን ያዮና ታ ኩሜꬃ ኣሳቴꬃን ኪሪስቶሲ ቦንቼታና ጋዳ ሚኖቴꬃን ኦዳይስ። ");
INSERT INTO gofENT_vpl VALUES ("PP1_21","080_1_21","PHP","1","21","21","ታ ዴዒኮካ ኪሪስቶሳ ፃላላስ ዴዓይስ፤ ቃሲ ታ ሃይቂኮካ ታው ኣꬊዳ ዎꬌ። ");
INSERT INTO gofENT_vpl VALUES ("PP1_22","080_1_22","PHP","1","22","22","ሺን ታ ፓፃ ዴዒኮ ኣይፌይ ዴዒያ ኦሶ ኦꬃና። ሺን ፓፃ ዴዔይሳፌኔ ሃይቆፔ ኣዉሳ ዶራኔኮ ታው ኤሬቴና። ");
INSERT INTO gofENT_vpl VALUES ("PP1_23","080_1_23","PHP","1","23","23","ታኒ ሃ ናምዓታፔ ኣዉሳ ዶራኔኮ ኡንዔታስ። ሃ ዴዑዋፔ ሻኬታዳ ኪሪስቶሳራ ኢሲፌ ዳናው ኣሞታይስ፤ ኪሪስቶሳራ ኢሲፌ ዴዔይሲ ኡባፌ ኣꬊዳ ሎዖ። ");
INSERT INTO gofENT_vpl VALUES ("PP1_24","080_1_24","PHP","1","24","24","ሺን ታኒ ሂንቴ ጊሾ ፓፃ ዴዔይሲ ሂንቴው ዳሮ ኮሺያባ። ");
INSERT INTO gofENT_vpl VALUES ("PP1_25","080_1_25","PHP","1","25","25","ሄሳ ታኒ ጌሻዳ ኤራይስ፤ ታኒ፥ ሂንቴ ኣማኖን ዲጫናዳኔ ኡፋይታናዳ ሂንቴራ ፓፃ ዳና። ");
INSERT INTO gofENT_vpl VALUES ("PP1_26","080_1_26","PHP","1","26","26","ሄሳ ጊሾ፥ ታኒ ሂንቴኮ ሲማዳ ያ ዎዴ ኪሪስቶስ ዬሱሳራ ሂንቴ ዴዒያ ዴዑዋን ታናን ዴዒያ ጬቄቴꬃይ ሂንቴው ዳራና። ");
INSERT INTO gofENT_vpl VALUES ("PP1_27","080_1_27","PHP","1","27","27","ኡባፌ ኣꬂዲ፥ ሂንቴ ኪሪስቶሳ ዎንጌላስ ቦንቾ ኤሂያ ዴዖ ዴዒቴ። ታ ሂንቴና ቤዒን ዎይኮ ቤዖና ኢፂን ሂንቴ ኢሲ ቆፋን ሚኒዲ ኤቂዲ፥ ሃራቲ ዎንጌላን ኣማናና ሜላ ኢሲ ዎዛናን ጊዲዲ ኢሲፌ ባፄቴይሳ ታ ሲዓና። ");
INSERT INTO gofENT_vpl VALUES ("PP1_28","080_1_28","PHP","1","28","28","ሂንቴ ሞርኬታስ ያዮፊቴ። ኤንቲ ሂንቴራ ኤቄቲያባ ጊዲኮ ሄሲ ሂንቴው ኣቶቴꬃስ፥ ኤንታው ꬋዮስ ፆሳፌ ጊዲዳ ማላ። ");
INSERT INTO gofENT_vpl VALUES ("PP1_29","080_1_29","PHP","1","29","29","ኪሪስቶሳስ ኦꬂያ ቃዳይ ሂንቴው ኢሜቲዳይ፥ ሂንቴ ኢያ ኣማናና ሜላ ፃላላ ጊዶናሺን ሂንቴ ኢያ ጊሾ ሜቶ ኤካና ሜላሳ። ");
INSERT INTO gofENT_vpl VALUES ("PP1_30","080_1_30","PHP","1","30","30","ሄሳ ጊሾ፥ ሂንቴ ታ ዋያ ካሴ ቤዒዴታ፤ ሃዒካ ታ ዋዬቴይሳ ሲዔታ። ሂንቴካ ታ ዋያ ሜላ ዋዬቴታ። ");
INSERT INTO gofENT_vpl VALUES ("PP2_1","080_2_1","PHP","2","1","1","ኪሪስቶሳን ሂንቴ ዴዒያ ዴዖይ ሂንቴና ሚንꬄስ፤ ቃሲ ኢያ ሲቆይካ ሂንቴና ሚንꬄꬄስ። ጌሻ ኣያናራ ሂንቴው ኢሲፌቴꬂ ዴዔስ፤ ሂንቴ ሃራታስ ኬሄታኔ ቃꬌቴታ። ");
INSERT INTO gofENT_vpl VALUES ("PP2_2","080_2_2","PHP","2","2","2","ሂዛ፥ ሂንቴ ኢሲ ቆፋን፥ ሲቆን፥ ኢሲ ዎዛናኒኔ ኣያናን ኢሲኖ ጊዲዲ ታና ፖሎ ኡፋይሲቴ። ");
INSERT INTO gofENT_vpl VALUES ("PP2_3","080_2_3","PHP","2","3","3","ሂንቴና ዶሶን ዎይኮ ጬቄቲያ ሃዳ ኣሞን ኢሲባካ ኦꬆፊቴ። ሺን ሂንቴ ኢሶይ ኢሱዋፌ ጊታታይስ ያጊዲ ቆፖና ሂንቴና ካዉሺቴ። ");
INSERT INTO gofENT_vpl VALUES ("PP2_4","080_2_4","PHP","2","4","4","ሂንቴ ኢሶይ ኢሶይ፥ ሃራ ኣሲ ማዲያባ ኮዪቴፔ ኣቲን ሂንቴና ማዲያባ ፃላላ ኮዮፒቴ። ");
INSERT INTO gofENT_vpl VALUES ("PP2_5","080_2_5","PHP","2","5","5","ኪሪስቶስ ዬሱሳን ዴዒያ ቆፋይ ሂንቴናን ዳናው ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("PP2_6","080_2_6","PHP","2","6","6","ኢያው ኡባ ዎዴ ፆሳ ሃኖቴꬂ ዴዔስ። ያኒያ ጊሾ፥ ኢያ ፆሳራ ኢሲኖ ኦꬂያ ሃኖታ፥ ዎልቃን ኤካናው ኮዪቤና። ");
INSERT INTO gofENT_vpl VALUES ("PP2_7","080_2_7","PHP","2","7","7","ጊዶሺን፥ ኢ ባው ዴዒያ ቦንቹዋ ኡባ ኣጊዲ፥ ኣይሌ ሜꬌታ ኤኪስ፤ ኣሴ ዳኒዲ ቆንጪስ። ");
INSERT INTO gofENT_vpl VALUES ("PP2_8","080_2_8","PHP","2","8","8","ኢ ባና ካዉሺስ፤ ሃይቃና ጋካናው፥ ሃሪ ኣቶሺን ማስቃሊያ ቦላ ሃይቃናው ኪቴቲስ። ");
INSERT INTO gofENT_vpl VALUES ("PP2_9","080_2_9","PHP","2","9","9","ሄሳ ጊሾ፥ ፆሳይ ኢያ ዳሮ ꬎቁ ꬎቁ ኦꬂስ፤ ቃሲ ሱንꬃ ኡባፌካ ኣꬊያ ꬎቃ ሱንꬃ ኢሚስ። ");
INSERT INTO gofENT_vpl VALUES ("PP2_10","080_2_10","PHP","2","10","10","ሳሎኒኔ ሳዓን፥ ሳዓፔ ጋርሳን ዴዒያ ኡባይ፥ ዬሱሳ ሱንꬃ ቦንቹዋስ ጉልባታና። ");
INSERT INTO gofENT_vpl VALUES ("PP2_11","080_2_11","PHP","2","11","11","ኣሳ ኡባይ ባንታ ኢንፃርሳን፥ ዬሱስ ኪሪስቶሳ ጎዳ ያጊዲ፥ ፆሳ ኣዋ ቦንቹዋስ ማርካታና። ");
INSERT INTO gofENT_vpl VALUES ("PP2_12","080_2_12","PHP","2","12","12","ታ ኢሻቶ፥ ታኒ ሂንቴራ ዴዒያ ዎዴ ኡባን ሂንቴ ኪቴቲዳይሳዳ፥ ሃዒ ታኒ ሂንቴ ማታፔ ሃኪንካ፥ ካሴይሳፌ ኣꬂዲ፥ ኪቴታናው ቤሴስ። ፆሳስ ያሻኒኔ ኮኮርሳን ሂንቴ ኣቶቴꬃ ፖላናው ኦꬂቴ። ");
INSERT INTO gofENT_vpl VALUES ("PP2_13","080_2_13","PHP","2","13","13","ፆሳይ፥ ሂንቴ ኢያው ኤሮ ጊዲ ኪቴታና ሜላ ኡባ ዎዴ ሂንቴ ጊዶን ኦꬄስ። ");
INSERT INTO gofENT_vpl VALUES ("PP2_14","080_2_14","PHP","2","14","14","ኣይ ኦሶ ኦꬂሼካ ዙዙሞና ዎይኮ ፓላሞና ኦꬂቴ። ");
INSERT INTO gofENT_vpl VALUES ("PP2_15","080_2_15","PHP","2","15","15","ጌላኔ ናጋራንቾ ኣሳ ጊዶን ቦሬቶናይሳታ፥ ጌሻታኔ ፖኮይ ባይና ፆሳ ናይታ ጊዲቴ። ሂንቴ ኤንታ ጊዶን ሳሎ ፆሊንቶዳ ፖዒሼ፥ ");
INSERT INTO gofENT_vpl VALUES ("PP2_16","080_2_16","PHP","2","16","16","ዴዖ ኢሚያ ኪታ ኤንታው ኦዲቴ። ሄ ዎዴ ታ ዳቡሪሳይኔ ታ ኦሶይ ሜላ ኣቲቦና ጊሾ ኪሪስቶሲ ያ ጋላስ ታ ሂንቴናን ጬቄታና። ");
INSERT INTO gofENT_vpl VALUES ("PP2_17","080_2_17","PHP","2","17","17","ሂንቴ ፆሳስ ኢሚያ ኣማኖ ኢሞታ ቦላ ታ ሱꬃይ ኡሻ ያርሾዳ ጉኪኮካ ታና ኡፋይሴስ። ሂንቴካ ታራ ኡፋይታና። ");
INSERT INTO gofENT_vpl VALUES ("PP2_18","080_2_18","PHP","2","18","18","ሄሳዳ ሂንቴካ ኡፋይቲዲ ታናካ ኡፋይሳናው ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("PP2_19","080_2_19","PHP","2","19","19","ታኒ ሂንቴ ዴዑዋባ ሲዓዳ ኡፋይታናው ፂሞቲዮሳ ሂንቴኮ ኤሌሳዳ ዬዳና ሜላ ጎዳ ዬሱሲ ታና ማዳናይሳ ኣማኔታይስ። ");
INSERT INTO gofENT_vpl VALUES ("PP2_20","080_2_20","PHP","2","20","20","ሂንቴ ዴዑዋስ ዎዛናፔ ቆፒያ ኢያ ሜላ ኣሲ ሃሪ ኦኒካ ባዋ። ");
INSERT INTO gofENT_vpl VALUES ("PP2_21","080_2_21","PHP","2","21","21","ሃራቲ ባንታና ጎዒያባ ኮዮሶናፔ ኣቲን ዬሱስ ኪሪስቶሲ ኮያባ ኦꬆኮና። ");
INSERT INTO gofENT_vpl VALUES ("PP2_22","080_2_22","PHP","2","22","22","ኢ ታራ ኢሲፌ ጊዲዲ ናዒ ባ ኣዋስ ኦꬄይሳዳ ዎንጌላ ኦሶ ኦꬂዳይሳኔ ኣማኔቲያ ኣሲ ጊዴይሳ ሂንቴ ኤሬታ። ");
INSERT INTO gofENT_vpl VALUES ("PP2_23","080_2_23","PHP","2","23","23","ሄሳ ጊሾ፥ ታባይ ሃኒያባ ቤዓዳ ኤሌሳዳ ኢያ ሂንቴኮ ዬዳና ጋዳ ቆፓይስ። ");
INSERT INTO gofENT_vpl VALUES ("PP2_24","080_2_24","PHP","2","24","24","ታኒ፥ ታ ሁዔን ማታ ዎዴን ሂንቴኮ ባናይሳ ጎዳን ኣማኔታይስ። ");
INSERT INTO gofENT_vpl VALUES ("PP2_25","080_2_25","PHP","2","25","25","ሄሳዳካ፥ ታኒ፥ ታ ኢሻ ኤጳፊሮዲቱሳ፥ ታራ ኢሲፌ ታ ባጋ ጊዲዲ ኦꬂዳይሳ፥ ኦሌቲዳይሳኔ፥ ታና ማዳናው ሂንቴው ኪቴቲዳይሳ፥ ሂንቴኮ ኪታናው ቆፓስ። ");
INSERT INTO gofENT_vpl VALUES ("PP2_26","080_2_26","PHP","2","26","26","ኢ ሂንቴና ኡባ ቤዓናው ዳሮ ላሞቴስ። ቃሲ ኢ ሃርጌቲዳይሳ ሂንቴ ሲዒዳ ጊሾ ባ ዎዛናን ዳሮ ኡንዔቲስ። ");
INSERT INTO gofENT_vpl VALUES ("PP2_27","080_2_27","PHP","2","27","27","ኢ ቱማ ሃርጌቲዲ ሃይቂ ኪቺዲ ኣቲስ። ሺን ፆሳይ ኢያው ቃꬌቲስ። ኢያ ፃላላስ ጊዶናሺን ኣዛኖይ ኣዛኖ ቦላ ጉዤቶናዳ፥ ታዉካ ቃꬌቲስ። ");
INSERT INTO gofENT_vpl VALUES ("PP2_28","080_2_28","PHP","2","28","28","ሂዛ፥ ሂንቴ ኢያ ዛሪ ቤዒዲ ኡፋይታናዳ ታዉካ ታ ዎዛና ሴላይ ኢርፃናዳ ታኒ ኢያ ኤሌሳዳ ሂንቴኮ ዬዳናው ኣሞታይስ። ");
INSERT INTO gofENT_vpl VALUES ("PP2_29","080_2_29","PHP","2","29","29","ጎዳስ ሃጋዚያ ኣሳዳ ኢያ ኩሜꬃ ኡፋይሳን ሞኪቴ። ቃሲ ኢያ ሜላ ኣሳ ኡባካ ቦንቺቴ። ");
INSERT INTO gofENT_vpl VALUES ("PP2_30","080_2_30","PHP","2","30","30","ሂንቴ ታ ማታን ጊዲዲ ኦꬃናው ዳንዳዖና ማዲያ ማዲዲ ኪሪስቶሳ ኦሱዋ ጊሾ ባ ሼምፑዋስ ሚሼቶና ኢፂዲ ሃይቂ ኪቺዲ ኣቲስ። ");
INSERT INTO gofENT_vpl VALUES ("PP3_1","080_3_1","PHP","3","1","1","ዉርሴꬃን፥ ታ ኢሻቶ፥ ሂንቴ ጎዳባ ጊዲያ ጊሾ ኡፋይቲቴ። ታኒ ካሴ ፃፊዳይሳ ዛራዳ ፃፋናይሲ ታና ዋይሴና፥ ሺን ሂንቴና ባላፔ ናጋና። ");
INSERT INTO gofENT_vpl VALUES ("PP3_2","080_3_2","PHP","3","2","2","ኢታባ ኦꬂያ ካናታፔ፥ ቃሲ ቃፃሬታናው ኮሼስ ጊያ ኢታ ኣሳታፔ ናጌቲቴ። ");
INSERT INTO gofENT_vpl VALUES ("PP3_3","080_3_3","PHP","3","3","3","ኑኒ ፆሳ ጌሻ ኣያናን ጎይኒያ ጊሾኔ ኑ ዴዑዋን ኪሪስቶስ ዬሱሳን ጬቄቲያ ጊሾ ቱማ ቃፃሮ ቃፃሬቲዳይሳታ። ኑኒ ካሬ ኣሳቴꬃ ቦላ ኦሴቲያባን ጬቄቶኮ። ");
INSERT INTO gofENT_vpl VALUES ("PP3_4","080_3_4","PHP","3","4","4","ታ ካሬ ኣሳቴꬃን ጬቄታናው ኮሺኮ ታ ዳሮባን ጬቄታናው ዳንዳዓይስ። ኣይ ኣሲካ ባ ካሬ ኣሳቴꬃን ጬቄቲያባይ ባው ዴዔስ ጊዲ ቆፒኮ፥ ታኒ ኢያፔ ዳሮ ኣꬋዳ ጬቄቲያባይ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("PP3_5","080_3_5","PHP","3","5","5","ታኒ ዬሌቲዳ ሳሚንታራ ቃፃሬታስ። ታኒ ዬሌታን ኢስራዔሌ፤ ታኒ ቢኒያሜ ዛሬ፤ ታኒ ዋላኪ ባይና ኣይሁዴ ኣሴ። ኣይሁዴ ሂጌ ናጎን ጊዲኮ ታኒ ፋሪሳዌ። ");
INSERT INTO gofENT_vpl VALUES ("PP3_6","080_3_6","PHP","3","6","6","ኣይሁዴ ኣማኑዋስ ሚሼቴꬃን ጊዲኮ ታኒ ዎሳ ኬꬃ ዬዴꬃስ። ኢሲ ኣሲ ሂጌ ናጊዲ ፂሊያባ ጊዲኮ፥ ታናን ቦሬይ ቤንቲቤና። ");
INSERT INTO gofENT_vpl VALUES ("PP3_7","080_3_7","PHP","3","7","7","ሺን ካሴ ታና ማዴስ ጋዳ ቆፒዳባ ኡባ፥ ኪሪስቶሳ ጊሾ ጋዳ ማዶናባ ኦꬃዳ ታይባስ። ");
INSERT INTO gofENT_vpl VALUES ("PP3_8","080_3_8","PHP","3","8","8","ሄሳ ፃላላ ጊዶናሺን ታኒ ታ ጎዳ ኪሪስቶስ ዬሱሳ ኤሬይሲ ሃራባ ኡባፌ ዳሮ ኣꬊያ ጊሾ ሄ ኡባ ዎꬌይ ባይናባዳ ታይባስ። ታኒ ኢያ ጊሾ ኡባባ ꬋያስ። ኪሪስቶሳ ዴማናው ኡባባ ዎራ ሆሌቲዳ ቡሬዳ ታይባይስ። ታኒ ዬሱሳራ ኢሲኖ ጊዳስ። ");
INSERT INTO gofENT_vpl VALUES ("PP3_9","080_3_9","PHP","3","9","9","ታኒ ሂጌስ ኪቴታዳ ዴሚያ ታ ሁዔ ፂሎቴꬂ ታው ባዋ። ኪሪስቶሳ ኣማኒን ቤንቲያ ፂሎቴꬃይ፥ ፆሳ ማታፔ ያ ፂሎቴꬃይ ሃዒ ታው ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("PP3_10","080_3_10","PHP","3","10","10","ታኒ ኪሪስቶሳኔ ኢያ ዴንዶ ዎልቃ ኤራናው ኮያይስ። ታኒ ኢያ ሜቱዋ ኢያራ ሻኬታናዉኔ ኢያ ሃይቁዋን ኢያ ዳናናው ኣሞታይስ። ");
INSERT INTO gofENT_vpl VALUES ("PP3_11","080_3_11","PHP","3","11","11","ሄሳዳካ፥ ሃይቆፔ ዴንዳዳ ሜሪናው ዴዖን ዳናይሳ ኡፋይሲ ኦꬃይስ። ");
INSERT INTO gofENT_vpl VALUES ("PP3_12","080_3_12","PHP","3","12","12","ታኒ ሃዒ ጋፃ ጋካስ ዎይኮ ታናን ባሊ ባዋ ጊኬ። ሺን ኪሪስቶስ ዬሱሲ ታና ኦይኪዳ ጊሾ ታኒ ታ ሲንꬃን ዴዒያ ዎይቱዋ ኦይካናው ዎፃይሲኔ ቡቴታይስ። ");
INSERT INTO gofENT_vpl VALUES ("PP3_13","080_3_13","PHP","3","13","13","ታ ኢሻቶ፥ ታኒ ሄሳ ዴማስ ጋዳ ቆፒኬ፥ ሺን ታኒ ኢሲባ ኦꬃይስ። ታፔ ጉዬራ ዴዔይሳ ዶጋዳ ሲንꬃን ዴዔይሳ ኦይካናው ዛቱራይስ። ");
INSERT INTO gofENT_vpl VALUES ("PP3_14","080_3_14","PHP","3","14","14","ሄሳ ጊሾ፥ ታኒ ጋፃ ጋካናው ዎፃይስ። ፆሳይ ኪሪስቶስ ዬሱሳ ባጋራ ሳሎ ዴዑዋስ ፄጊዳ ዎይቱዋ ኤካናው ዳቡራይስ። ");
INSERT INTO gofENT_vpl VALUES ("PP3_15","080_3_15","PHP","3","15","15","ሂዛ፥ ኑኒ ኣያናን ጋሽቲዳ ኡባይ ሄሳ ቆፓናው ቤሴስ። ሂንቴፌ ባጋታስ ዱማቲያ ቆፊ ዴዒኮ፥ ሄሳካ ፆሳይ ሂንቴው ቆንጪሳና። ");
INSERT INTO gofENT_vpl VALUES ("PP3_16","080_3_16","PHP","3","16","16","ጊዲኮካ፥ ኑኒ ሃኖ ጋካናው ዴዒዳ ዴዑዋን፥ ኣኔ ሲንꬄ ቦስ። ");
INSERT INTO gofENT_vpl VALUES ("PP3_17","080_3_17","PHP","3","17","17","ታ ኢሻቶ፥ ታና ዳኒቴ፤ ሄሳዳካ፥ ኑ ሌሚሱዋ ካሊያ ኣሳታ ኣኬኪዲ ቤዒቴ። ");
INSERT INTO gofENT_vpl VALUES ("PP3_18","080_3_18","PHP","3","18","18","ታኒ ሄሳ ሂንቴው ካሴ ዳሮ ቶሆ ኦዳስ፥ ሺን ሃዒካ ዛራዳ ኣፉꬃን ኦዳይስ። ኪሪስቶሲ ማስቃሊያ ቦላ ሃይቂዳይሳስ ባንታና ሞርኬ ኦꬂዳ ዳሮ ኣሳቲ ዴዖሶና። ");
INSERT INTO gofENT_vpl VALUES ("PP3_19","080_3_19","PHP","3","19","19","ኤንታ ዉርሴꬃይ ꬋዮ፤ ኤንታ ኡሎይ ኤንታው ፆሴ። ዬላታናው ቤሲያባን ኤንቲ ጬቄቶሶና፤ ቃሲ ሃ ሳዓባ ፃላላ ቆፖሶና። ");
INSERT INTO gofENT_vpl VALUES ("PP3_20","080_3_20","PHP","3","20","20","ኑ ቢታይ ሳሉዋና። ሳሎፔ ዪዲ ኑና ኣሻናው ዴዒያ ጎዳ ዬሱስ ኪሪስቶሳ ናጎስ። ");
INSERT INTO gofENT_vpl VALUES ("PP3_21","080_3_21","PHP","3","21","21","ኪሪስቶሲ ኡባባ ባ ማታፔ ጋርሳን ኦꬃናው ዳንዳዒያ ባ ዎልቃን ኑ ዳቡራንቾ ኣሳቴꬃ ላሚዲ ባ ቦንቾ ኣሳቴꬃ ዳኒሳና። ");
INSERT INTO gofENT_vpl VALUES ("PP4_1","080_4_1","PHP","4","1","1","ታ ኢሻቶ፥ ታ ዶሴይሳቶ፥ ታ ላሞቴይሳቶ፥ ታና ኡፋይሴይሳቶ፥ ታና ጊታዬይሳቶ ሂዛ ጎዳን ሚኒዲ ኤቂቴ። ");
INSERT INTO gofENT_vpl VALUES ("PP4_2","080_4_2","PHP","4","2","2","ኤዎዲኔ ሲንፂካ፥ ሂንቴ ናምዓይ፥ ኢሲ ቆፋን ሚቺዳ ጎዳን ዳናዳ ታኒ ሂንቴና ዞራይስ። ");
INSERT INTO gofENT_vpl VALUES ("PP4_3","080_4_3","PHP","4","3","3","ታራ ኦꬂያ ኣማንꬄይሶ፥ ኔኒ ሃ ማጫሳታ ማዳና ሜላ ታ ኔና ዎሳይስ። ሃ ማጫሳቲ ታራ፥ ቄሌሚንፆሳራኔ ኤንታ ሱንꬃይ ፆሳ ዴዖ ማፃፋን ፃፌቲዳ ሃራታራ ኢሲፌ ዎንጌላ ኡባ ቤሳ ጋꬃናው ዳቡሪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("PP4_4","080_4_4","PHP","4","4","4","ጎዳራ ሂንቴ ዴዒያ ዴዑዋን ኡባ ዎዴ ኡፋይቲቴ። ታኒ ሄሳ ጉጃዳካ ኦዳይስ፤ ኡፋይቲቴ። ");
INSERT INTO gofENT_vpl VALUES ("PP4_5","080_4_5","PHP","4","5","5","ኣሳ ኡባይ ሂንቴ ኣሽኬቴꬃ ኤሮ፤ ጎዳይ ማታን ያና። ");
INSERT INTO gofENT_vpl VALUES ("PP4_6","080_4_6","PHP","4","6","6","ፆሳ ሂንቴ ዎሲያ ዎዴ ኡባን ኢያ ጋላቲሼ፥ ሂንቴና ኮሺያባ ኡባስ ዎሲቴፔ ኣቲን ኣይቢባስካ ሂርጎፊቴ። ");
INSERT INTO gofENT_vpl VALUES ("PP4_7","080_4_7","PHP","4","7","7","ኣሳ ኤራቴꬃ ኡባፌ ኣꬊያ ፆሳ ሳሮቴꬃይ፥ ሂንቴ ዎዛናኔ ሂንቴ ቆፋ ጎዳ ዬሱስ ኪሪስቶሳ ባጋራ ናጋና። ");
INSERT INTO gofENT_vpl VALUES ("PP4_8","080_4_8","PHP","4","8","8","ዉርሴꬃን፥ ታ ኢሻቶ፥ ሂንቴ ዎዛናን ሎዖባኔ ጋላቲሲያባ ቆፒቴ። ቱማ ጊዲያባ ኡባ፥ ቦንቾባ ኡባ፥ ቆሆ ጊዶናባ ኡባ፥ ጌሻባ ኡባ፥ ሲቆባ ኡባኔ ኡፋይሲያባ ኡባ ቆፒቴ። ");
INSERT INTO gofENT_vpl VALUES ("PP4_9","080_4_9","PHP","4","9","9","ሂንቴ ታፔ ታማሪዳባ፥ ኤኪዳባ፥ ሲዒዳባኔ ቤዒዳባ ኡባ ኦꬂቴ። ሳሮቴꬃ ኢሚያ ፆሳይ ሂንቴራ ኢሲፌ ጊዳና። ");
INSERT INTO gofENT_vpl VALUES ("PP4_10","080_4_10","PHP","4","10","10","ዳሮ ዎዴፔ ጉዬ፥ ሂንቴ ታባ ዛሪዲ ቆፓናው ዶሚዳ ጊሾ ታኒ ጎዳን ዳሮ ኡፋይታይስ። ሄሳ ጉሳይ፥ ታው ቆፓናው ሂንቴው ኢንጄቶና ኢፂዳይሳፌ ኣቲን ታው ቆፋ ኣጊቤኬታ። ");
INSERT INTO gofENT_vpl VALUES ("PP4_11","080_4_11","PHP","4","11","11","ታኒ ሄሳ ታና ሜቲዳ ጊሾ ጊኬ፤ ታው ዴዒያባይ ጊዳና ጉሱ ታማራስ። ");
INSERT INTO gofENT_vpl VALUES ("PP4_12","080_4_12","PHP","4","12","12","ታኒ ሜቶቴቲዲ ዴዒያ ዱሲ ኤራይስ፤ ቃሲ ዱሬቲዲ ዴዒያ ዱሲካ ኤራይስ። ኣዉን ጊዲን ቃሲ ኣይ ዎዴካ ታኒ ካሎኔ ኮሻ፥ ፓጬኔ ፓላሃ ታማራስ። ");
INSERT INTO gofENT_vpl VALUES ("PP4_13","080_4_13","PHP","4","13","13","ኪሪስቶሲ ታው ኢሚያ ዎልቃን ኡባባ ኦꬃናው ዳንዳዓይስ። ");
INSERT INTO gofENT_vpl VALUES ("PP4_14","080_4_14","PHP","4","14","14","ጊዲኮካ፥ ሂንቴ ታ ሜቱዋ ታራ ኤኪዳይሳን ሎዖ ኦꬂዴታ። ");
INSERT INTO gofENT_vpl VALUES ("PP4_15","080_4_15","PHP","4","15","15","ፊልጲሲዩሳ ኣሳው፥ ዎንጌላ ኮይሮ ኦዳናው ታኒ ማቄዶኒያፔ ኬያ ዎዴ ኢሚያባንካ ኤኪያባንካ ሂንቴ ዎሳ ኬꬃፌ ኣቲን ሃሪ ታና ማዲቦናይሳ ሂንቴ ኤሬታ። ");
INSERT INTO gofENT_vpl VALUES ("PP4_16","080_4_16","PHP","4","16","16","ቴሴሎንቄን ሜቶይ ጋኪዳ ዎዴካ ታና ዛሪ ዛሪዲ ማዲዴታ። ");
INSERT INTO gofENT_vpl VALUES ("PP4_17","080_4_17","PHP","4","17","17","ታኒ፥ ሂንቴፌ ኢሞታ ኤካናው ኮያዳ ጊዶናሺን ኢሞፔ ያ ኣንጁዋ ሂንቴ ኤካና ሜላሳ። ");
INSERT INTO gofENT_vpl VALUES ("PP4_18","080_4_18","PHP","4","18","18","ታኒ፥ ሂንቴ ኢሚዳ ኡባኔ ጊዲዲ ፓላሄይሳ ኤካስ። ሂንቴ ዬዲዳ ኡባ ኤጳፊራዲቱሳፔ ኤካስ፤ ኮሺያባ ኡባይ ታው ዴዔስ። ሂንቴ ታው ዬዲዳ ኢሞይ ፆሳስ ሳዎ ቶንጉ ጊያ፥ ኢ ዶሲያ፥ ኢ ኡፋይቲያ ያርሾ ሜላ። ");
INSERT INTO gofENT_vpl VALUES ("PP4_19","080_4_19","PHP","4","19","19","ታ ፆሳይ ባ ቦንቾ ዱሬቴꬃፌ፥ ኪሪስቶስ ዬሱሳ ባጋራ ሂንቴው ኮሺያባ ኡባ ኢማና። ");
INSERT INTO gofENT_vpl VALUES ("PP4_20","080_4_20","PHP","4","20","20","ኑ ኣዋ ፆሳስ ሜሪናፔ ሜሪና ጋካናው ቦንቾይ ጊዶ። ኣሚንዒ። ");
INSERT INTO gofENT_vpl VALUES ("PP4_21","080_4_21","PHP","4","21","21","ኪሪስቶስ ዬሱሳ ባጋራ ፆሳባ ጊዲዳ ኡባ ሳሮ ጊቴ። ታራ ዴዒያ ኢሻቲ ሂንቴና ሳሮ ጎሶና። ");
INSERT INTO gofENT_vpl VALUES ("PP4_22","080_4_22","PHP","4","22","22","ፆሳባ ጊዲዳ ኣሳ ኡባይ፥ ኡባፌ ኣꬂዲ ካዉዋ ቄሳሬ ኬꬃን ዴዔይሳቲ ሂንቴና ሳሮ ጎሶና። ");
INSERT INTO gofENT_vpl VALUES ("PP4_23","080_4_23","PHP","4","23","23","ጎዳ ዬሱስ ኪሪስቶሳ ኣꬎ ኬሃቴꬃይ ሂንቴራ ጊዶ። ");
INSERT INTO gofENT_vpl VALUES ("CL1_1","081_1_1","COL","1","1","1","ፆሳ ሼኔን ኪሪስቶሲ ዬሱሳ ሃዋሬ ጊዲዳ ጳዉሎሲኔ ኑ ኢሻ ፂሞቲዮሲ፥ ");
INSERT INTO gofENT_vpl VALUES ("CL1_2","081_1_2","COL","1","2","2","ቆላሲያሳ ካታማን ዴዒያ ኪሪስቶሳን ጌሻታሲኔ ኣማኔቲዳ ኣሳስ ፃፊዳ ኪታ። ፆሳ ኑ ኣዋፔ ኣꬎ ኬሃቴꬃይኔ ሳሮቴꬃይ ሂንቴው ጊዶ። ");
INSERT INTO gofENT_vpl VALUES ("CL1_3","081_1_3","COL","1","3","3","ኑኒ ሂንቴው ዎሲያ ዎዴ ፆሳ ኑ ጎዳ፥ ዬሱስ ኪሪስቶሳ ኣዋ ኡባ ዎዴ ጋላቶስ። ");
INSERT INTO gofENT_vpl VALUES ("CL1_4","081_1_4","COL","1","4","4","ኑኒ ኪሪስቶስ ዬሱሳን ዴዒያ ሂንቴ ኣማኑዋኔ ጌሻታ ኡባስ ዴዒያ ሂንቴ ሲቁዋ ሲዒዳ። ");
INSERT INTO gofENT_vpl VALUES ("CL1_5","081_1_5","COL","1","5","5","ሄሳ ሂንቴ ኦꬂዳይ ሂንቴ ኡፋይሳይ ሳሎን ሂንቴው ናጌቲዳ ጊሾሳ። ሂንቴ ቱማ ኪታ ጊዲዳ ዎንጌላ ኮይሮ ኣማኒዳ ዎዴ ሄ ኡፋይሳ ሲዒዴታ። ");
INSERT INTO gofENT_vpl VALUES ("CL1_6","081_1_6","COL","1","6","6","ሂንቴ ሄ ዎንጌላ ሲዒዳ ዎዴኔ ፆሳ ኣꬎ ኬሃቴꬃ ቱማ ሻኪ ኤሪዳ ዎዴፔ ዶሚዲ ሂንቴ ጊዶን ሃኒዳይሳዳ ቢታ ኡባን ዲጪሼኔ ኣይፊሼ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("CL1_7","081_1_7","COL","1","7","7","ሂንቴ ሄሳ ኑራ ኢሲፌ ኪሪስቶሳስ ኦꬂያ ኣማኔቲዳ፥ ዶሴቲዳ ኤጳፊራፔ ታማሪዴታ። ");
INSERT INTO gofENT_vpl VALUES ("CL1_8","081_1_8","COL","1","8","8","ኢ ሄሳ ቦላ ጉጂዲ ኣያናይ ሂንቴው ኢሚዳ ሲቁዋባ ኑስ ኦዲስ። ");
INSERT INTO gofENT_vpl VALUES ("CL1_9","081_1_9","COL","1","9","9","ሄሳ ጊሾ፥ ኑኒ ሂንቴባ ሲዒዳ ጋላሳፔ ዶሚዲ፥ ፆሳይ ባ ሼኒያ ሂንቴና ቤሳና ሜላኔ፥ ጌሻ ኣያናይ ኢሚያ ኤራቴꬃኒኔ ጪንጫቴꬃ ኡባን ሂንቴና ኩንꬃና ሜላ ኡባ ዎዴ ሂንቴው ፆሳ ዎሶስ። ");
INSERT INTO gofENT_vpl VALUES ("CL1_10","081_1_10","COL","1","10","10","ሄሳዳካ፥ ጎዳይ ኮዬይሳዳ ሂንቴ ዳና ሜላ፥ ኡባ ዎዴ ኢያ ኡፋይሳና ሜላ፥ ሎዖ ኦሶ ኡባን ሂንቴ ኣይፌ ኣይፋና ሜላኔ ፆሳ ኣꬂ ኤሪሼ ዲጫና ሜላ ፆሳ ዎሶስ። ");
INSERT INTO gofENT_vpl VALUES ("CL1_11","081_1_11","COL","1","11","11","ፆሳ ቦንቾ ዎልቃይ ሂንቴ ኡባባ ጌንጫናዳኔ ዳንዳዓናዳ ባ ሚኖቴꬃ ኢሚዲ ሂንቴና ኡፋይሶ። ");
INSERT INTO gofENT_vpl VALUES ("CL1_12","081_1_12","COL","1","12","12","ቃሲ ጌሻታ ፖዖ ካዎቴꬃ ላታና ሜላ ሂንቴና ኦꬂዳ ኣዋ ጋላቲቴ። ");
INSERT INTO gofENT_vpl VALUES ("CL1_13","081_1_13","COL","1","13","13","ኢ ኑና ꬉማ ዎልቃፌ ኣሺዲ ባ ዶሲያ ናዓ ካዎቴꬃኮ ኤሂስ። ");
INSERT INTO gofENT_vpl VALUES ("CL1_14","081_1_14","COL","1","14","14","ኢያን ዎዜቲዲ ኢያ ሱꬃን ናጋራ ኣቶቴꬂ ዴሚዳ። ");
INSERT INTO gofENT_vpl VALUES ("CL1_15","081_1_15","COL","1","15","15","ኪሪስቶሲ ቤንቶና ፆሳስ ቱማ ሌሚሶ። ኢ ሜꬌቴꬃ ኡባፌ ባይራ። ");
INSERT INTO gofENT_vpl VALUES ("CL1_16","081_1_16","COL","1","16","16","ኡባባይ ኢያ ባጋራ ሜꬌቲስ። ቤንቲያባቲኔ ቤንቶናባቲ፥ ዎልቃቲኔ ጎዳቲ፥ ሃሬይሳቲኔ ማታ ኣዋቲ፥ ሳሎኒኔ ሳዓን ዴዒያ ኡባይ ኢያዉኔ ኢያ ባጋራ ሜꬌቲስ። ");
INSERT INTO gofENT_vpl VALUES ("CL1_17","081_1_17","COL","1","17","17","ኢ ኡባባፔ ካሴ ዴዔስ። ኡባባይ ኢያን ባ ቤሳን ቤሳን ኦይኬቲዲ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("CL1_18","081_1_18","COL","1","18","18","ኢ ባ ኣሳቴꬂ ጊዲዳ ዎሳ ኬꬃስ ሁዔ። ኢ ኡባፌ ቦላ ጊዳናው ሃይቆፔ ዴንዶን ሲንꬄኔ ባይራ። ");
INSERT INTO gofENT_vpl VALUES ("CL1_19","081_1_19","COL","1","19","19","ፆሳይ ባ ኩሜꬃ ፆሳቴꬃራ ኢያን ዳናው ኮዪስ። ");
INSERT INTO gofENT_vpl VALUES ("CL1_20","081_1_20","COL","1","20","20","ቃሲ ማስቃሊያ ቦላ ጉሲዳ ባ ናዓ ሱꬃን ሳሮቴꬂ ሜꬊዲ ሳሎኒኔ ሳዓን ዴዒያ ኡባ ኢያ ባጋራ ባራ ሲጌꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("CL1_21","081_1_21","COL","1","21","21","ሃይሳፌ ካሴ ሂንቴ ቆፋ ኢታቴꬃይ ሂንቴና ፆሳፌ ሻኪሲኔ ኢያራ ሞርኬ ኦꬂስ፤ ሂንቴ ኦሶይካ ኢታ። ");
INSERT INTO gofENT_vpl VALUES ("CL1_22","081_1_22","COL","1","22","22","ሺን ሃዒ ኪሪስቶሲ ኣሾን ሃይቂዳ ሃይቁዋ ባጋራ ፆሳይ ሂንቴና ባራ ሲጌꬂዲ፥ ጌሻታ፥ ቦሬይ ባይናይሳታኔ ፂሎታ ኦꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("CL1_23","081_1_23","COL","1","23","23","ሂንቴ፥ ሂንቴ ኣማኑዋን ቃፆና ሚኒዲኔ ፃጲዲ ዳናው ቤሴስ። ሂንቴ ዎንጌላ ቃላ ሲዒዳ ዎዴ ኤኪዳ ኡፋይሳ ሚንꬂ ኦይኪቴ። ሄ ዎንጌላይ ሂንቴ ሲዒዳይሳኔ ቢታ ኡባን ሳባኬቲዳይሳ። ታ፥ ጳዉሎሲካ ሃ ዎንጌላስ ኦሳንቾ ጊዳስ። ");
INSERT INTO gofENT_vpl VALUES ("CL1_24","081_1_24","COL","1","24","24","ታኒ ሂንቴ ጊሾ ሃዒ ኤኪያ ዋያን ኡፋይታይስ። ኪሪስቶሲ ኢያ ኣሳቴꬂ ጊዲዳ ዎሳ ኬꬃስ ኤኪዳ ዋያ ታኒ ታ ኣሹዋን ፖላይስ። ");
INSERT INTO gofENT_vpl VALUES ("CL1_25","081_1_25","COL","1","25","25","ፆሳ ቃላ ሂንቴው ፖላዳ ኦዳና ሜላ ታው ኢሜቲዳ ማታን ዎሳ ኬꬃስ ኦሳንቾ ጊዳስ። ");
INSERT INTO gofENT_vpl VALUES ("CL1_26","081_1_26","COL","1","26","26","ሃ ቃላይ ካሴ ኣꬊዳ ዎዲያን ዬሌቴꬃ ኡባፌ ጌሚዲ ዴዒስ። ሺን ሃዒ ፆሳይ ሃ ፁራ ኣማኒያ ኡባስ ቆንጪሲስ። ");
INSERT INTO gofENT_vpl VALUES ("CL1_27","081_1_27","COL","1","27","27","ፆሳይ ኣይሁዴ ጊዶና ኣሳ ጊዶን ሃ ፁራ ቦንቾ ዱሬቴꬃ ቆንጪሲስ። ኢካ ቦንቾ ኡፋይሲ ጊዲዳ ሂንቴ ጊዶን ዴዒያ ኪሪስቶሳ። ");
INSERT INTO gofENT_vpl VALUES ("CL1_28","081_1_28","COL","1","28","28","ሄሳ ጊሾ፥ ኢሲ ኢሲ ኣሲ ኪሪስቶሳን ኩሜꬃ ኣሲ ኦꬂዲ ሺሻናው ጪንጫቴꬃ ኡባን ኣሳ ታማርሶኒኔ ዞሬን ኪሪስቶሳባ ሳባኮስ። ");
INSERT INTO gofENT_vpl VALUES ("CL1_29","081_1_29","COL","1","29","29","ፆሳይ ባ ጊታ ዎልቃን ታናን ኦꬂያ ጊሾ ሃዒ ጋካናው ኢያ ዎልቃን ባፄታይሲኔ ዳቡራይስ። ");
INSERT INTO gofENT_vpl VALUES ("CL2_1","081_2_1","COL","2","1","1","ታ ሂንቴዉኔ ሎዶቂያ ካታማን ዴዒያ ኣሳስ፥ ሄሳዳካ ታና ኣይፌን ቤዒቦና ኣሳ ኡባስ ኣይ ሜላ ባፄቲያኮ ሂንቴ ኤራና ሜላ ኮያይስ። ");
INSERT INTO gofENT_vpl VALUES ("CL2_2","081_2_2","COL","2","2","2","ታ ባፄቲያ ጋሶይካ ኤንቲ ባንታ ዎዛናን ሚኒዲ፥ ሲቆን ቃሼቲዲ፥ ፖሎ ጊዲዳ ኩሜꬃ ኣኬካ ዱሬቴꬃ ዴሚዲ ፆሳ ፁራ ኪሪስቶሳ ኤራና ሜላሳ። ");
INSERT INTO gofENT_vpl VALUES ("CL2_3","081_2_3","COL","2","3","3","ኢያን ፆሳይ ሚንጂዳ ኤራይኔ ጪንጫቴꬃ ኡባይ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("CL2_4","081_2_4","COL","2","4","4","ታ ሄሳ ኦኒካ ሂንቴና ጪሞ ቃላን ባሌꬆና ሜላ ኮያዳ ጋይስ። ");
INSERT INTO gofENT_vpl VALUES ("CL2_5","081_2_5","COL","2","5","5","ታ ሂንቴፌ ሃካዳ ዴዒኮካ ኣያናን ሂንቴራ ዴዓይስ። ሂንቴ ዱሳ ማራኔ ኪሪስቶሳ ሂንቴ ሚኒዲ ኣማኔይሳ ቤዓዳ ኡፋይታይስ። ");
INSERT INTO gofENT_vpl VALUES ("CL2_6","081_2_6","COL","2","6","6","ሂንቴ ጎዳ ኪሪስቶስ ዬሱሳ ኤኪዳይሳዳ ኢያን ዴዒቴ። ");
INSERT INTO gofENT_vpl VALUES ("CL2_7","081_2_7","COL","2","7","7","ኢያን ፃጶ ዬዲቴ፤ ኢያን ኬፄቲቴ። ሂንቴ ታማሪዳይሳዳ ኣማኖን ሚኒቴ፤ ፆሳስ ኩሚዲ ፓላሂዳ ጋላታ ኢሚቴ። ");
INSERT INTO gofENT_vpl VALUES ("CL2_8","081_2_8","COL","2","8","8","ኪሪስቶሳፔ ጊዶናሺን ኣሳ ዎጋኒኔ ሃ ኣላሚያ ጮ ዎጋን ካቲዳ ቲሚርቲያኒኔ ኣሳፔ ዪዳ ኤራቴꬃን ኦኒካ ሂንቴና ጪሚ ባሌꬂዲ ዲዖና ሜላ ናጌቲቴ። ");
INSERT INTO gofENT_vpl VALUES ("CL2_9","081_2_9","COL","2","9","9","ፆሳ ፆሳቴꬃይ ኪሪስቶሳ ኣሳቴꬃን ኩሜꬂ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("CL2_10","081_2_10","COL","2","10","10","ሂንቴካ ማታሲኔ ዎልቃ ኡባስ ሁዔ ጊዲያ ኪሪስቶሳን ኩሚዴታ። ");
INSERT INTO gofENT_vpl VALUES ("CL2_11","081_2_11","COL","2","11","11","ሂንቴ ኪሪስቶሳ ኣማኒዲ ቃፃሬቲዴታ። ሄሲካ ኣሳ ኩሼን ጊዶናሺን ሂንቴና ኢታ ሃኖቴꬃፌ ዲጊያ ኪሪስቶሳን ኦሴቲዳ ቃፃሬቴꬂ። ");
INSERT INTO gofENT_vpl VALUES ("CL2_12","081_2_12","COL","2","12","12","ሂንቴ ፃማቄቲዳ ዎዴ ኪሪስቶሳራ ኢሲፌ ሞጌቲዲ፥ ኪሪስቶሳ ሃይቆፔ ዴንꬂዳ ፆሳ ዎልቃ ኣማኒዲ፥ ኪሪስቶሳራ ኢሲፌ ዴንዲዴታ። ");
INSERT INTO gofENT_vpl VALUES ("CL2_13","081_2_13","COL","2","13","13","ሂንቴ፥ ሂንቴ ናጋራ ጊሾኔ ሂንቴ ጬጋ ኣሳቴꬃ ቃፃሬቶና ጊሾ ሃይቂዲ ዴዒሺን፥ ፆሳይ ሂንቴ ናጋራ ኣቶ ጊስ። ኪሪስቶሳራ ሂንቴው ዴዖ ኢሚስ። ");
INSERT INTO gofENT_vpl VALUES ("CL2_14","081_2_14","COL","2","14","14","ኢ ኑና ሞቲያኔ ኑራ ኤቄቲያ፥ ኑ ቦላ ፃፌቲዳ ኣጩዋ ዳኪዲ ማስቃሊያ ቦላ ꬊሺዲ ኦጌፔ ዲጊስ። ");
INSERT INTO gofENT_vpl VALUES ("CL2_15","081_2_15","COL","2","15","15","ኪሪስቶሲ ዎልቃታኔ ማታታ ማስቃሊያን ፆኒዲ፥ ኤንታ ኦላ ዳንጩዋ ቢሊሲዲ፥ ዲዔቲዳ ኣሳዳ ኦꬂዲ ኤንታ ቆንጬን ዩሺዲ ቤሲስ። ");
INSERT INTO gofENT_vpl VALUES ("CL2_16","081_2_16","COL","2","16","16","ሄሳ ጊሾ፥ ሚያባን ዎይኮ ኡያባን፥ ባሌ ጋላስ ዎይኮ ኣጌኒ ፄሪያ ቃማ ቦንቾን ኦኒካ ሂንቴ ቦላ ፒርዶፎ። ");
INSERT INTO gofENT_vpl VALUES ("CL2_17","081_2_17","COL","2","17","17","ሃይሳቲ ሲንꬃፌ ያናው ዴዒያባታስ ኤሾ፥ ሺን ቱማይ ኪሪስቶሳ። ");
INSERT INTO gofENT_vpl VALUES ("CL2_18","081_2_18","COL","2","18","18","ቆꬌፔ ቆሞ ኣሽኬቴꬃኒኔ ኪታንቾ ጎይኖን ጬቄቲያ ኦኒካ ሂንቴና ሂንቴ ዎይቱዋፔ ኣሾፎ። ሄሳ ሜላ ኣሲ ባ ቤዒዳ ቆንጬꬃን ናሼቲሼ ባ ኣሾ ቆፋን ጮ ኦቶርቴስ። ");
INSERT INTO gofENT_vpl VALUES ("CL2_19","081_2_19","COL","2","19","19","ሄሳ ሜላ ኣሳስ ሁዔ ጊዲዳ ኪሪስቶሳራ ጋሄቴꬂ ባዋ። ኢ ኣሳቴꬃ ኡባ ሻያኒኔ ኬሶን ኬሶን ጋꬂ ኦይꬂዲ ሙዚዲ ዲቼስ። ፆሳይ ሄሳ ሜላ ኦጌን ኣሳቴꬃ ኡባስ ዲቺ ኢሜስ። ");
INSERT INTO gofENT_vpl VALUES ("CL2_20","081_2_20","COL","2","20","20","ሂንቴ ኪሪስቶሳራ ሃይቂዲ ሃ ኣላሚያ ሃሪያ ኣያናታ ዎልቃፌ ላዓ ኬዪዴታ። ያቲን፥ ኣይስ ሻኬቶና ኣሳዳ ጊዲዲ ሃ ዎጋታስ ሃሬቴቲ? ");
INSERT INTO gofENT_vpl VALUES ("CL2_21","081_2_21","COL","2","21","21","ሃ ዎጋቲ፥ «ኦይኮፋ፤ ላጮፋ፤ ቦቾፋ» ጌቴቴይሳታ። ");
INSERT INTO gofENT_vpl VALUES ("CL2_22","081_2_22","COL","2","22","22","ሃ ኡባይ ኣሳ ዎጋኔ ቲሚርቴ ጊዲያ ጊሾ ኦሶ ቦላ ፔዒዳፔ ጉዬ ꬋያና። ");
INSERT INTO gofENT_vpl VALUES ("CL2_23","081_2_23","COL","2","23","23","ሃ ኪታቲ ቦንቾኔ ጪንጫቴꬂ ዳኒዲ ቤንታናው ዳንዳዖሶና። ሃ ዎጋቲ ፆሴ ዳሮ ዶሲሲያባ፥ ኣሽኬኔ ሂንቴ ኣሳቴꬃ ሃሪሲያባ ዳኖሶና፥ ሺን ኑ ኢታ ኣሞቴꬃ ቦላ ዎልቂ ኤንታው ባዋ። ");
INSERT INTO gofENT_vpl VALUES ("CL3_1","081_3_1","COL","3","1","1","ሂዛ፥ ሂንቴ ኪሪስቶሳራ ሃይቆፔ ዴንዲዳይሳዳ፥ ፆሳፌ ኡሻቻ ባጋን ኡቲዳ ኪሪስቶሲ ዴዒያ ቤሳን፥ ሳሎን ዴዒያባታ ኮዪቴ። ");
INSERT INTO gofENT_vpl VALUES ("CL3_2","081_3_2","COL","3","2","2","ሳሎን ዴዔይሳታ ቦላ ሂንቴ ቆፋ ዎꬂቴፔ ኣቲን ሳዓን ዴዒያባታ ቦላ ዎꬆፊቴ። ");
INSERT INTO gofENT_vpl VALUES ("CL3_3","081_3_3","COL","3","3","3","ሂንቴ ሃይቆን ሻኬቲዳ ሜላ ሃ ኣላሚያፔ ሻኬቲዴታ። ሂንቴ ዴዖይ ኪሪስቶሳራ ኢሲፌ ፆሳን ጌሚስ። ");
INSERT INTO gofENT_vpl VALUES ("CL3_4","081_3_4","COL","3","4","4","ሂንቴው ዴዖ ጊዲዳ ኪሪስቶሲ ቆንጪያ ዎዴ ሄ ዎዴ ሂንቴካ ኢያራ ቦንቾን ቆንጫና። ");
INSERT INTO gofENT_vpl VALUES ("CL3_5","081_3_5","COL","3","5","5","ሄሳ ጊሾ፥ ሂንቴናን ዴዒያ ኣላሜ ኣሞታ ዎꬊቴ። ሄሳቲካ ላይማቴꬂ፥ ቱናቴꬂ፥ ላይማታናው ኣሞቴꬂ፥ ኤቃ ጎይኖ ሜላ ጊዲዳ ኡዜቴꬂ። ");
INSERT INTO gofENT_vpl VALUES ("CL3_6","081_3_6","COL","3","6","6","ሃይሳታ ጋሶን ፆሳ ሃንቆይ ኪቴቶና ኣሳ ቦላ ያና። ");
INSERT INTO gofENT_vpl VALUES ("CL3_7","081_3_7","COL","3","7","7","ሂንቴካ ካሴ ሄ ኢታ ኦጊያን ቢያ ኣሳ ጊዶን ዴዒሼ ሃይሳታ ኦꬂዴታ። ");
INSERT INTO gofENT_vpl VALUES ("CL3_8","081_3_8","COL","3","8","8","ሃዒ ሂንቴ ሄሳታ ኦꬆፊቴ። ቃሲ ሃንቆ፥ ኢፆ፥ ካቺ፥ ዚጊርሲኔ ቦርሶ ኦዳ ሂንቴፌ ዲጊት። ");
INSERT INTO gofENT_vpl VALUES ("CL3_9","081_3_9","COL","3","9","9","ጬጋ ኣሳቴꬃ ኢያ ኦሱዋራ ሂንቴፌ ቃሪዳ ጊሾ ኢሶይ ኢሱዋስ ዎርዶቶፒቴ። ");
INSERT INTO gofENT_vpl VALUES ("CL3_10","081_3_10","COL","3","10","10","ፆሳ ሜꬎ ዳኒያ፥ ኤራቴꬃን ላሜቲዳ ኦራꬃ ኣሳቴꬃ ማዒቴ። ");
INSERT INTO gofENT_vpl VALUES ("CL3_11","081_3_11","COL","3","11","11","ሃ ኦራꬃ ሜꬌቴꬃን፥ ጊሪኬ ኣሲ ዎይኮ ኣይሁዴ ኣሲ፥ ቃፃሬቲዳይ ዎይኮ ቃፃሬቶናይ፥ ባርባሬ ኣሲ ዎይኮ ኢስኩቴ ኣሲ ኣይሌይ ዎይኮ ዎማኖይ ባዋ። ኪሪስቶሲ ኡባ፤ ኢ ኡባን ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("CL3_12","081_3_12","COL","3","12","12","ሄሳ ጊሾ፥ ፆሳን ዶሬቲዳ ኣሳዳ ጌሻታኔ ዶሴቲዳይሳታ ጊዲዲ፥ ማሮቴꬃ፥ ኬሃቴꬃ፥ ኣሽኬቴꬃኔ ዳንዳዓ ማዒቴ። ");
INSERT INTO gofENT_vpl VALUES ("CL3_13","081_3_13","COL","3","13","13","ኢሶይ ኢሱዋ ዳንዳዒቴ። ኦኒካ ባ ላጊያን ቆሄቲዳባይ ዴዒኮ ኢያው ኣቶ ጎ። ጎዳይ ሂንቴው ኣቶ ጊዳይሳዳ ሂንቴካ ዎሊስ ኣቶ ጊቴ። ");
INSERT INTO gofENT_vpl VALUES ("CL3_14","081_3_14","COL","3","14","14","ሄ ኡባ ቦላ ኡባባ ኢሲፌ ሺሺዲ ቃቺያ ሲቆ ማዒቴ። ");
INSERT INTO gofENT_vpl VALUES ("CL3_15","081_3_15","COL","3","15","15","ፆሳይ ሂንቴና ኢሲ ኣሲ ኦꬂዲ ፄጊዳይ፥ ሳሮቴꬃስ ጊዲያ ጊሾ ኪሪስቶሳ ሳሮቴꬃይ ሂንቴ ዎዛና ሃሮ። ");
INSERT INTO gofENT_vpl VALUES ("CL3_16","081_3_16","COL","3","16","16","ኪሪስቶሳ ቃላይ ሂንቴ ዎዛናን ኩሚዲ ዴዖ። ጪንጫቴꬃ ኡባን ኢሶይ ኢሱዋ ታማርሲቴኔ ዞሪቴ። ማዝሙሬን፥ ሳባኒኔ ኣያና ዬꬃን ፆሳ ዎዛናፔ ጋላቲሼ ዬፂቴ። ");
INSERT INTO gofENT_vpl VALUES ("CL3_17","081_3_17","COL","3","17","17","ፆሳ ኣዋ ዬሱሳ ባጋራ ጋላቲሼ ሂንቴ ኦዴቲያባ ዎይኮ ኦꬂያባ ኡባ ጎዳ ዬሱሳ ሱንꬃን ኦꬂቴ። ");
INSERT INTO gofENT_vpl VALUES ("CL3_18","081_3_18","COL","3","18","18","ማቼቶ፥ ኣማኒያ ኣሳስ ቤሲያባ ጊዲያ ጊሾ ሂንቴ ኣዚናታስ ሃሬቲቴ። ");
INSERT INTO gofENT_vpl VALUES ("CL3_19","081_3_19","COL","3","19","19","ኣዚናቶ፥ ሂንቴ ማቼታ ሲቂቴ፤ ኤንታው ኢቶፒቴ። ");
INSERT INTO gofENT_vpl VALUES ("CL3_20","081_3_20","COL","3","20","20","ናይቶ፥ ሂንቴና ዬሊዳይሳታስ ኡባባን ኪቴቲቴ፤ ሄሲ ጎዳ ኡፋይሲያባ። ");
INSERT INTO gofENT_vpl VALUES ("CL3_21","081_3_21","COL","3","21","21","ኣዋቶ፥ ሂንቴ ናይቲ ኡፋይሲ ቃንፆና ሜላ ኤንታ ጫሜꬆፊቴ። ");
INSERT INTO gofENT_vpl VALUES ("CL3_22","081_3_22","COL","3","22","22","ኣይሌቶ፥ ሳዓን ሂንቴው ጎዳ ጊዲዳይሳታስ ኡባባን ኪቴቲቴ። ጎዳ ቦንቺሼ ሱሬ ዎዛናፔ ኪቴቲዲ ኤንታ ኡፋይሲቴፔ ኣቲን ኣሲ ቤዖ ጊዲ ኦꬆፊቴ። ");
INSERT INTO gofENT_vpl VALUES ("CL3_23","081_3_23","COL","3","23","23","ሂንቴ ኦꬂያ ኦሶ ኡባ ኣሳስ ጊዶናሺን ጎዳስ ኦꬂያ ሜላ ዎዛናፔ ኦꬂቴ። ");
INSERT INTO gofENT_vpl VALUES ("CL3_24","081_3_24","COL","3","24","24","ጎዳፔ ላታ ዎይቶ ኦꬂዲ ሂንቴ ኤኬይሳ ኤሪቴ፤ ሂንቴ ጎዳ ኪሪስቶሳ ሃጋዜታ። ");
INSERT INTO gofENT_vpl VALUES ("CL3_25","081_3_25","COL","3","25","25","ፆሳይ ኣሳ ሶምዖ ቤዒዲ ፒርዶና ጊሾ ኦኒካ ኢታ ኦሶ ኦꬂኮ ባ ኢታ ኦሱዋ ጊሾ ዛሮ ኤካና። ");
INSERT INTO gofENT_vpl VALUES ("CL4_1","081_4_1","COL","4","1","1","ጎዳቶ፥ ሂንቴዉካ ቃሲ ሳሎን ጎዳይ ዴዔይሳ ኤሪዲ፥ ሂንቴ ኣይሌታስ ፂሎቴꬃኒኔ ኢሱዋ ኢሱዋፌ ሻኮና ኮሺያባ ኦꬂቴ። ");
INSERT INTO gofENT_vpl VALUES ("CL4_2","081_4_2","COL","4","2","2","ፆሳ ባርኪዲ ጋላቲሼ ቃንፆና ዎሲቴ። ");
INSERT INTO gofENT_vpl VALUES ("CL4_3","081_4_3","COL","4","3","3","ፆሳይ ባ ቃላስ ፔንጌ ዶያና ሜላኔ ታኒ ሄሳ ጋሶን ቃሾን ዴዒያ ኪሪስቶሳ ፁራ ኣዋጃና ሜላ ኑስካ ዎሲቴ። ");
INSERT INTO gofENT_vpl VALUES ("CL4_4","081_4_4","COL","4","4","4","ቃሲ ታካ ቤሴይሳዳ ቃላ ቆንጪሳዳ ኦዳና ሜላ ታው ፆሳ ዎሲቴ። ");
INSERT INTO gofENT_vpl VALUES ("CL4_5","081_4_5","COL","4","5","5","ኢንጄቲያ ዎዴ ኡባ ጎዔቲሼ ኣማኖና ኣሳ ማታን ጪንጫቴꬃን ዴዒቴ። ");
INSERT INTO gofENT_vpl VALUES ("CL4_6","081_4_6","COL","4","6","6","ሂንቴ ኣሳ ኡባስ ኮሺያ ዛሮ ኢሞ ኤራና ሜላ ሂንቴ ኦዳይ ኡባ ዎዴ ኣꬎ ኬሃቴꬃን ኩሚዳይሳኔ ማፂኔዳ ማልዒያባ ጊዳናው ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("CL4_7","081_4_7","COL","4","7","7","ኑ ሲቆ ኢሻይ ቲኪቆሲ፥ ታራ ኢሲፌ ጎዳ ኦሱዋን ኣይሌ ጊዲዳ፥ ኣማኔቲያ ኦሳንቾይ፥ ታ ዴዑዋባ ሂንቴው ኦዳና። ");
INSERT INTO gofENT_vpl VALUES ("CL4_8","081_4_8","COL","4","8","8","ታኒ ኢያ ሂንቴኮ ኪቲዳይ፥ ኑ ዋኒዲ ዴዒያኮ ሂንቴው ኦዲዲ ሂንቴና ሚንꬄꬃና ሜላሳ። ");
INSERT INTO gofENT_vpl VALUES ("CL4_9","081_4_9","COL","4","9","9","ኣናስሞሲ፥ ኣማኔቲያ ሲቆ ኢሻይ፥ ሂንቴ ባጋይ፥ ኢያራ ሂንቴኮ ቤስ። ኤንቲ ሃይሳን ሃኒያባ ኡባ ሂንቴው ኦዳና። ");
INSERT INTO gofENT_vpl VALUES ("CL4_10","081_4_10","COL","4","10","10","ታራ ቃሼቲዳ ኣሪስፂሮኮሲኔ ባርናባሳ ኢሻ ናዓይ ማርቆሲ፥ ሂንቴና ሳሮ ያጎሶና። ታ ሂንቴው ካሴ ኦዲዳይሳዳ ማርቆሲ ሂንቴኮ ቢኮ ኢያ ሞኪቴ። ");
INSERT INTO gofENT_vpl VALUES ("CL4_11","081_4_11","COL","4","11","11","ዬሱሳ ጊያ ያስፆሲ ሂንቴና ሳሮ ሳሮ ያጌስ። ፆሳ ካዎቴꬃ ጊሾ ታራ ኦꬂያ ኣሳታ ጊዶፌ ኣይሁዴ ጊዲዳይሳቲ ሃ ሄꬓታ፤ ኤንቲ ታና ዳሮ ሚንꬄꬂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("CL4_12","081_4_12","COL","4","12","12","ሂንቴ ባጋይ፥ ኪሪስቶስ ዬሱሳ ኣይሌይ፥ ኤጳፊሪ ሂንቴና ሳሮ ሳሮ ያጌስ። ኢ ሂንቴ ፆሳ ሲንꬃን ሚኒዲ ኤቃናዳኔ ፆሳ ሼኒያ ኤሪዲ ፖላና ሜላ ኡባ ዎዴ ፆሳ ሂንቴ ጊሾ ዎሴስ። ");
INSERT INTO gofENT_vpl VALUES ("CL4_13","081_4_13","COL","4","13","13","ኢ ሂንቴ ጊሾኔ ሎዶቂያኒኔ ሂራፖሊሳ ካታማን ዴዒያ ኣሳ ጊሾ ዳሮ ዳቡሪዳይሳ ታ ማርካታይስ። ");
INSERT INTO gofENT_vpl VALUES ("CL4_14","081_4_14","COL","4","14","14","ኑ ሲቆ ኢሻይ ዶቶሬይ ሉቃሲኔ ዴማሲ፥ ሂንቴና ሳሮ ሳሮ ያጎሶና። ");
INSERT INTO gofENT_vpl VALUES ("CL4_15","081_4_15","COL","4","15","15","ሎዶቂያን ዴዒያ ኑ ኢሻታስ፥ ኒምፋሲኔ ኢ ኬꬃን ሺቂያ ኣሳስ ኑ ሳሮꬁዋ ኦዲቴ። ");
INSERT INTO gofENT_vpl VALUES ("CL4_16","081_4_16","COL","4","16","16","ሃ ዳብዳቢያ ሂንቴ ናባቢዳፔ ጉዬ፥ ሎዶቂያ ዎሳ ኬꬃን ናባቢሲቴ። ሂንቴካ ሎዶቂያ ዎሳ ኬꬃይ ሂንቴው ዬዲያ ዳብዳቢያ ናባቢቴ። ");
INSERT INTO gofENT_vpl VALUES ("CL4_17","081_4_17","COL","4","17","17","ቃሲ ኣርኪጳሳ፥ «ጎዳይ ኔው ኢሚዳ ኦሱዋ ፖላናይሳ ዶጎፓ» ያጊዲ ቆፊሲቴ። ");
INSERT INTO gofENT_vpl VALUES ("CL4_18","081_4_18","COL","4","18","18","ታኒ፥ ጳዉሎሲ፥ ሃ ሳሮꬁዋ ታ ኩሼን ፃፋስ። ታ ቃሹዋ ቆፒቴ። ፆሳ ኣꬎ ኬሃቴꬃይ ሂንቴራ ጊዶ። ");
INSERT INTO gofENT_vpl VALUES ("H11_1","082_1_1","1TH","1","1","1","ጳዉሎሲ ሲላሴይኔ ፂሞቲዮሲ ቴሴሎንቄ ዎሳ ኬꬃን ዴዒያ፥ ፆሳ ኣዋባኔ ጎዳ ዬሱስ ኪሪስቶሳባ ጊዲዳ ኣሳስ ፃፊዳ ኪታ። ኣꬎ ኬሃቴꬃይኔ ሳሮይ ሂንቴው ጊዶ። ");
INSERT INTO gofENT_vpl VALUES ("H11_2","082_1_2","1TH","1","2","2","ኑኒ ፆሳ ዎሲያ ዎዴ ኡባን ሂንቴና ቆፒሼ ሂንቴ ጊሾ ኡባ ዎዴ ፆሳ ጋላቶስ። ");
INSERT INTO gofENT_vpl VALUES ("H11_3","082_1_3","1TH","1","3","3","ፆሳ ኑ ኣዋ ሲንꬃን ኣማኖን ሂንቴ ኦꬂዳ ኦሱዋ፥ ሲቆን ሂንቴ ዳቡሪዳ ዳቡራኔ ዬሱስ ኪሪስቶሳን ዴዒያ ኡፋይሳ ኤካናው ሂንቴ ሚኒዲ ኤቂዳ ኤቁዋ ኡባ ዎዴ ቆፖስ። ");
INSERT INTO gofENT_vpl VALUES ("H11_4","082_1_4","1TH","1","4","4","ኑ ኢሻቶ፥ ፆሳይ ሂንቴና ዶሴይሳኔ ባ ኣሴ ኦꬂዲ ሂንቴና ዶሪዳይሳ ኤሮስ። ");
INSERT INTO gofENT_vpl VALUES ("H11_5","082_1_5","1TH","1","5","5","ኣይስ ጊኮ፥ ኑኒ ዎንጌላ ዶና ፃላላን ጊዶናሺን ዎልቃን፥ ጌሻ ኣያናኒኔ ዎንጌላ ቱማ ኣማኖን ሂንቴው ኤሂዳ። ኑኒ ሂንቴራ ጋምዒዳ ዎዴ ኡባን ሂንቴ ጊሾ ዋኒዲ ዴዒዳኮ ሂንቴ ኤሬታ። ");
INSERT INTO gofENT_vpl VALUES ("H11_6","082_1_6","1TH","1","6","6","ሂንቴ ዳሮ ሜቶ ኤኪኮካ ጌሻ ኣያናይ ኢሚያ ኡፋይሳን ኪታ ኤኪዴታ፤ ኑናኔ ጎዳ ዳኒዴታ። ");
INSERT INTO gofENT_vpl VALUES ("H11_7","082_1_7","1TH","1","7","7","ሄሳ ጊሾ፥ ማቄዶኒያኔ ኣካያ ቢታን ዴዒያ ኣማኒያ ኡባስ ሌሚሶ ጊዲዴታ። ");
INSERT INTO gofENT_vpl VALUES ("H11_8","082_1_8","1TH","1","8","8","ጎዳ ቃላይ ሂንቴፌ ኬዪዲ፥ ማቄዶኒያኒኔ ኣካያ ፃላላን ጊዶናሺን ፆሳ ሂንቴ ኣማኔይሲ ኡባሶን ሲዔቲስ። ሂዛ፥ ኑኒ ጋናባይ ኣይኮይካ ባዋ። ");
INSERT INTO gofENT_vpl VALUES ("H11_9","082_1_9","1TH","1","9","9","ኑኒ ሂንቴኮ ቢዳ ዎዴ ሂንቴ ኑና ሞኪዳ ሞኩዋኔ ሂንቴ፥ ሂንቴ ኤቃ ኣጊዲ ቱማኔ ዴዖ ፆሳ ሃጋዛናው ሂንቴ ሲሚዳይሳ ኤንቲ ባንታ ሁዔን ኦዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("H11_10","082_1_10","1TH","1","10","10","ቃሲ ፆሳ ናዓይ፥ ዬሱሲ፥ ፆሳይ ሃይቆፔ ዴንꬂዳይሲ፥ ሲንꬃፌ ያና ፆሳ ሃንቁዋፌ ኑና ኣሻናይሲ፥ ሳሎፔ ያናይሳ ሂንቴ ናጌይሳ ኤንቲ ማርካቶሶና። ");
INSERT INTO gofENT_vpl VALUES ("H12_1","082_2_1","1TH","2","1","1","ታ ኢሻቶ፥ ኑኒ ሂንቴኮ ቢዳይ ሜላ ጊዶናይሳ ሂንቴ፥ ሂንቴ ሁዔን ኤሬታ። ");
INSERT INTO gofENT_vpl VALUES ("H12_2","082_2_2","1TH","2","2","2","ሺን ኑኒ ሂንቴኮ ቴሴሎንቄ ያናፔ ሲንꬄ ፊልጲሲዩሳ ካታማን ዋዬቲዳይሳኔ ጫዬቲዳይሳ ሂንቴ ኤሬታ። ዳሮ ኢፆይ ዴዒኮካ ሂንቴው ኢያ ዎንጌላ ኦዳና ሜላ ፆሳይ ኑስ ሚኖቴꬂ ኢሚስ። ");
INSERT INTO gofENT_vpl VALUES ("H12_3","082_2_3","1TH","2","3","3","ኑኒ ሂንቴና ዞሪዳይ ባሌሶን ዎይኮ ጪሞን ዎይኮ ጌኔን ጊዴና። ");
INSERT INTO gofENT_vpl VALUES ("H12_4","082_2_4","1TH","2","4","4","ሺን ፆሳይ ኑናን ኣማኔቲዲ ባ ዎንጌላ ኦዳና ሜላ ኑስ ሃዳራ ኢሚዳ ጊሾ ኦዶስ። ኑ ሄሳ ኦꬄይ ኑ ዎዛና ቤዒያ ፆሳ ኡፋይሳናሳፌ ኣቲን ኣሴ ኡፋይሳናሳ ጊዴና። ");
INSERT INTO gofENT_vpl VALUES ("H12_5","082_2_5","1TH","2","5","5","ኑ ሚሼ ያሪዲ ዎርዶ ሂንቴና ሳቢሼ ሂንቴኮ ዮናይሳ ሎይꬂዲ ኤሬታ፤ ፆሳይ ኑስ ማርካ። ");
INSERT INTO gofENT_vpl VALUES ("H12_6","082_2_6","1TH","2","6","6","ኑኒ ሂንቴፌ ጊዲን ዎይኮ ሃራ ኣሳ ኦዴፌካ ቦንቾ ኮዪቦኮ። ");
INSERT INTO gofENT_vpl VALUES ("H12_7","082_2_7","1TH","2","7","7","ኑኒ ኪሪስቶሳ ሃዋሬ ጊዴይሳዳ ኑስ ኮሺያባ ኢሚቴ ጊዲ ኤካናው ዳንዳዖስ፥ ሺን ኣያ ባ ናይታ ዲቼይሳ ሜላ ሂንቴ ጊዶን ኣሽኬ ጊዲዳ። ");
INSERT INTO gofENT_vpl VALUES ("H12_8","082_2_8","1TH","2","8","8","ኑ ሂንቴና ዶሲዳ ጊሾ ፆሳ ዎንጌላ ሂንቴው ሻኮ ፃላላ ጊዶናሺን ኑ ዴዑዋካ ሂንቴው ኢማናው ጊጊዳ። ሂንቴ ኑስ ዳሮ ኣልዖ። ");
INSERT INTO gofENT_vpl VALUES ("H12_9","082_2_9","1TH","2","9","9","ኑ ኢሻቶ፥ ኑ ኦሱዋኔ ኑ ዳቡራ ኤሬታ። ሂንቴው ፆሳ ዎንጌላ ኦዲሼ፥ ሂንቴና ዋይሶና ሜላ ቃማኔ ጋላስ ኦꬂዳ። ");
INSERT INTO gofENT_vpl VALUES ("H12_10","082_2_10","1TH","2","10","10","ኑ ዴዖይ ሂንቴ ኣማኔይሳታ ማታኒኔ ፆሳ ሲንꬃን ጌሺ፥ ፂሎኔ ቦሬቶናይሳ ጊዴይሳስ ሂንቴ ማርካ። ");
INSERT INTO gofENT_vpl VALUES ("H12_11","082_2_11","1TH","2","11","11","ኑኒ ሂንቴው ሁዔን ሁዔን ዬሊዳይሳቲ ባንታ ናይታስ ሃኔይሳዳ ሃኒዳይሳ ኤሬታ። ");
INSERT INTO gofENT_vpl VALUES ("H12_12","082_2_12","1TH","2","12","12","ኑ ሂንቴና ዞሪዳ፥ ሚንꬄꬂዳ። ቃሲ ባ ካዎቴꬃኔ ባ ቦንቹዋ ሻካናው ሂንቴና ፄጊያ ፆሳ ኡፋይሲያ ዴዖ ሂንቴ ዳና ሜላ ሂንቴው ሚንꬂዲ ኦዲዳ። ");
INSERT INTO gofENT_vpl VALUES ("H12_13","082_2_13","1TH","2","13","13","ሂንቴው ኑኒ ፆሳ ቃላ ኦዲዳ ዎዴ ኣሳ ቃላዳ ጊዶናሺን ፆሳ ቃላዳ ሲዒዲ ኤኪዳ ጊሾ ኑኒ ኡባ ዎዴ ፆሳ ጋላቶስ። ኢ ቱማ ፆሳ ቃላ፤ ፆሳ ቃላይ ኣማኒያ ሂንቴናን ኦꬄስ። ");
INSERT INTO gofENT_vpl VALUES ("H12_14","082_2_14","1TH","2","14","14","ታ ኢሻቶ፥ ሂንቴ ዪሁዳ ቢታን ዴዒያ ዎሳ ኬꬃታኔ ያን ኪሪስቶስ ዬሱሳ ካሊያ ኣሳታዳ ሃኒዴታ። ኤንታ ኣይሁዴቲ ዋይሲዳይሳዳ ሂንቴናካ ሂንቴ ቢታ ኣሳይ ዋይሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("H12_15","082_2_15","1TH","2","15","15","ሄ ኣይሁዴቲ ጎዳ ዬሱሳኔ ናቤታ ዎꬊዶሶና፤ ቃሲ ኑና ጎዲዶሶና። ኤንቲ ፆሳ ኡፋይሶናይሳታኔ ኣሴ ኡባ ኢፄይሳታ። ");
INSERT INTO gofENT_vpl VALUES ("H12_16","082_2_16","1TH","2","16","16","ኤንቲ ሃሪ ኣቶሺን፥ ኣይሁዴ ጊዶና ኣሳይ ኣታና ሜላ ኑኒ ኤንታው ቃላ ኦዴይሳ ዲጎሶና። ሄሳዳ ሃኒዲ ኤንታ ናጋራ ፁዓይ ኩማና ጋካናው ኡባ ዎዴ ናጋራ ኦꬆሶና። ዉርሴꬃን፥ ፆሳ ሃንቆይ ኤንታ ቦላ ዎꬌስ። ");
INSERT INTO gofENT_vpl VALUES ("H12_17","082_2_17","1TH","2","17","17","ሺን ኑ ኢሻቶ፥ ኑኒ ኑ ቆፋን ጊዶናሺን ኣሾን ሂንቴፌ ሻኬቲዲ ጉꬃ ዎዴ ጋምዒዳይሳን ሂንቴና ዳሮ ላሞቲዲ ቤዓናው ኮዪዳ። ");
INSERT INTO gofENT_vpl VALUES ("H12_18","082_2_18","1TH","2","18","18","ኑ ሲሚ ሂንቴኮ ባናው ኮዪዳ። ታኒ ታ ሁዔን ሂንቴኮ ባናው ኮያስ፥ ሺን ፃላሄይ ኑና ዲጊስ። ");
INSERT INTO gofENT_vpl VALUES ("H12_19","082_2_19","1TH","2","19","19","ሂዛ፥ ኑ ጎዳ ዬሱስ ኪሪስቶሲ ያ ዎዴ ኑ ኡፋይሳይ ዎይኮ ኑ ጬቄቲያ ኑ ካላቻይ ኦኔ? ሂንቴና ጊዴኬቲዬ? ");
INSERT INTO gofENT_vpl VALUES ("H12_20","082_2_20","1TH","2","20","20","ቱማ ሂንቴ ኑ ቦንቾኔ ኑ ኡፋይሲ። ");
INSERT INTO gofENT_vpl VALUES ("H13_1","082_3_1","1TH","3","1","1","ሄሳ ጊሾ፥ ኑስ ጌንጫናው ዳንዳዔቶና ኢፂን፥ ኣቴና ካታማን ኑርካ ኣታናው ቆፋ ቃቺዳ። ");
INSERT INTO gofENT_vpl VALUES ("H13_2","082_3_2","1TH","3","2","2","ሂንቴና ዞራናዳኔ ኣማኖን ሂንቴና ሚንꬄꬃናዳ ኑራ ኢሲፌ ፆሳስ ኦꬄይሳኔ ኪሪስቶሳ ዎንጌላ ኦዲያ ኑ ኢሻ ፂሞቲዮሳ ሂንቴኮ ኪቲዳ። ");
INSERT INTO gofENT_vpl VALUES ("H13_3","082_3_3","1TH","3","3","3","ሂንቴና ጋኪዳ ጎዳን ሂንቴፌ ኦኒካ ጉዬ ሲሞፎ። ሄ ጎዳይ ኑስ ፆሳ ሼኔ ጊዴይሳ ሂንቴ፥ ሂንቴ ሁዔን ኤሬታ። ");
INSERT INTO gofENT_vpl VALUES ("H13_4","082_3_4","1TH","3","4","4","ኑ ሂንቴራ ዴዒያ ዎዴ ጎዲ ጋካናይሳ ሂንቴው ኮይሮቲዲ ኦዲዳ። ሂንቴ ኤሬይሳ ሜላ ሄሳዳ ሃኒስ። ");
INSERT INTO gofENT_vpl VALUES ("H13_5","082_3_5","1TH","3","5","5","ሄሳ ጊሾ፥ ታው ጌንጫናው ዳንዳዔቶና ኢፂን፥ «ኦኒ ኤሪ ፃላሄይ ኤንታ ፓጪዲ ኑ ዳቡራ ሜላ ኣሾና ኣጌና» ጋዳ ሂንቴ ኣማኑዋባ ኤራናው ፂሞቲዮሳ ሂንቴኮ ኪታስ። ");
INSERT INTO gofENT_vpl VALUES ("H13_6","082_3_6","1TH","3","6","6","ሃዒ ፂሞቲዮሲ ሂንቴ ማታፔ ዪዲ፥ ሂንቴ ኣማኑዋባኔ ሂንቴ ሲቁዋባ ሎዖ ዎሬ ኦዲስ። ቃሲ ሂንቴ ኡባ ዎዴ ኑስ ሎዖ ቆፔይሳኔ ኑኒ ሂንቴና ቤዓናው ላሞቴይሳዳ ሂንቴካ ኑና ቤዓናው ላሞቴይሳ ኢ ኑስ ኦዲስ። ");
INSERT INTO gofENT_vpl VALUES ("H13_7","082_3_7","1TH","3","7","7","ታ ኢሻቶ፥ ኑና ጋኪያ ዋያኒኔ ኑ ሜቶ ኡባን ሂንቴ ኣማኑዋ ጊሾ ሂንቴናን ሚኔቲዳ። ");
INSERT INTO gofENT_vpl VALUES ("H13_8","082_3_8","1TH","3","8","8","ሂንቴ ጎዳን ሚኒዲ ዴዒኮ ኑካ ዴዖን ዴዖስ። ");
INSERT INTO gofENT_vpl VALUES ("H13_9","082_3_9","1TH","3","9","9","ሂዛ፥ ኑኒ ሂንቴ ጋሶን ዴሚዳ ኡፋይሳስ ፆሳ ዋቲ ጋላቲኖ? ");
INSERT INTO gofENT_vpl VALUES ("H13_10","082_3_10","1TH","3","10","10","ኑኒ ሂንቴና ቤዓናዉኔ ሂንቴ ኣማኑዋን ፓጪዳባ ኩንꬃናው ቃማኔ ጋላስ ኑ ኩሜꬃ ዎዛናን ፆሳ ዎሶስ። ");
INSERT INTO gofENT_vpl VALUES ("H13_11","082_3_11","1TH","3","11","11","ፆሳይ ኑ ኣዋይ ባ ሁዔኒኔ ኑ ጎዳይ ዬሱስ ኪሪስቶሲ ኑ ሂንቴኮ ባና ኦጊያ ጊጊሶ። ");
INSERT INTO gofENT_vpl VALUES ("H13_12","082_3_12","1TH","3","12","12","ኑ ሂንቴና ዳሮ ዶሴይሳዳ ጎዳይ ሂንቴ ኢሶይ ኢሱዋ ሲቂያ ሲቆኔ ኣሴ ኡባ ሲቂያ ሲቆ ሂንቴው ዳርሶኔ ጉጆ። ");
INSERT INTO gofENT_vpl VALUES ("H13_13","082_3_13","1TH","3","13","13","ኑ ጎዳይ ዬሱስ ኪሪስቶሲ ባ ጌሻታራ ያ ዎዴ ፆሳ፥ ኑ ኣዋ ሲንꬃን ሂንቴ ዎዛናይ ጌሺኔ ቦሬይ ባይናይሳ ኦꬂዲ ኢ ሂንቴና ሚንꬄꬃና። ");
INSERT INTO gofENT_vpl VALUES ("H14_1","082_4_1","1TH","4","1","1","ዉርሴꬃን፥ ታ ኢሻቶ፥ ፆሳ ኡፋይሳናው ሂንቴ ዋኒዲ ዳናው ቤሲያኮ ኑፔ ታማሪዴታ። ሄሲ ሂንቴ ኮይሮፔ ዴዒዳ ዴዑዋ፥ ሺን ሃዒ ሂንቴ ካሴይሳፌ ኣꬂዲ ኦꬃናዳ ጎዳ ዬሱሳ ሱንꬃን ሂንቴና ዎሶሲኔ ዞሮስ። ");
INSERT INTO gofENT_vpl VALUES ("H14_2","082_4_2","1TH","4","2","2","ኑኒ ጎዳ ዬሱሳ ማታን ሂንቴና ኪቲዳ ኪታይ ኣዉሴኮ ኤሬታ። ");
INSERT INTO gofENT_vpl VALUES ("H14_3","082_4_3","1TH","4","3","3","ፆሳይ፥ ሂንቴ ጌሺ ጊዳና ሜላኔ ላይማቶና ሜላ ኮዬስ። ");
INSERT INTO gofENT_vpl VALUES ("H14_4","082_4_4","1TH","4","4","4","ሂንቴ ኢሶይ ኢሶይ፥ ሂንቴ ማቼታራ ጌሻቴꬃኒኔ ቦንቾን ዳናው ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("H14_5","082_4_5","1TH","4","5","5","ፆሳ ኤሮናኔ ኣማኖና ኣሳዳ ላይማቴꬃ ኣሞን ፁጌቶፊቴ። ");
INSERT INTO gofENT_vpl VALUES ("H14_6","082_4_6","1TH","4","6","6","ኑ ካሴ ሂንቴው ኦዲዳይሳዳኔ ሚንꬂ ዞሪዳይሳዳ ጎዳይ ሄሳ ሜላባ ኦꬂያ ኡባ ፒርዲያ ጊሾ ኦኒካ ሃይሳታን ባ ኣማኒያ ኢሻ ናቃናዉኔ ጪማናው ቤሴና። ");
INSERT INTO gofENT_vpl VALUES ("H14_7","082_4_7","1TH","4","7","7","ፆሳይ ኑኒ ጌሽቴꬃን ዳና ሜላፔ ኣቲን ቱናቴꬃን ዳና ሜላ ፄጊቤና። ");
INSERT INTO gofENT_vpl VALUES ("H14_8","082_4_8","1TH","4","8","8","ሄሳ ጊሾ፥ ሃ ቲሚርቲያ ኢፂያ ኦኒካ ሂንቴው ጌሻ ኣያና ኢሚያ ፆሳ ኢፄስፔ ኣቲን ኣሴ ጊዴና። ");
INSERT INTO gofENT_vpl VALUES ("H14_9","082_4_9","1TH","4","9","9","ሂንቴ ኢሶይ ኢሱዋ ዋቲ ሲቃኔኮ ፆሳይ ሂንቴና ታማርሲዳ ጊሾ ሃዒ ሲቆባ ኑ ህንቴው ፃፋናው ኮሼና። ");
INSERT INTO gofENT_vpl VALUES ("H14_10","082_4_10","1TH","4","10","10","ቃሲ ማቄዶኒያ ቢታን ዴዒያ ኣማኒያ ኢሻታ ኡባ ቱማ ሂንቴ ዶሴታ። ሺን ኑ ኢሻቶ፥ ሃዒካ ሂንቴ ኤንታ ኣꬂ ዶሳና ሜላ ሂንቴና ዎሶስ። ");
INSERT INTO gofENT_vpl VALUES ("H14_11","082_4_11","1TH","4","11","11","ኑኒ ካሴ ሂንቴው ኦዲዳይሳዳ ዎፑ ጊዳ ዴዑዋ ዴዒቴ። ሂንቴ፥ ሂንቴ ኦሶ ኦꬂዲ ሂንቴው ዱሳስ ኮሺያባ ዴሚቴ። ");
INSERT INTO gofENT_vpl VALUES ("H14_12","082_4_12","1TH","4","12","12","ሄሳዳ ሃኒኮ፥ ኣማኖናይሳታ ማታን ሂንቴ ቦንቼታና፤ ቃሲ ሂንቴና ኮሺያባስ ኦናካ ኣዳሼኬታ። ");
INSERT INTO gofENT_vpl VALUES ("H14_13","082_4_13","1TH","4","13","13","ኑ ኢሻቶ፥ ኣማኒዲ ሃይቂዳ ኣሳቲ ሃናናባ ሂንቴ ኤራና ሜላ ኮዮስ። ሂንቴ ኤንታ ጊሾ ኡፋይሲ ባይና ኣሳዳ ካዮቶፊቴ። ");
INSERT INTO gofENT_vpl VALUES ("H14_14","082_4_14","1TH","4","14","14","ኑኒ፥ ዬሱሲ ሃይቂዳይሳኔ ቃሲ ሃይቆፔ ዴንዲዳይሳ ኣማኖስ። ሄሳዳካ፥ ፆሳይ ዬሱሳ ኣማኒዲ ሃይቂዳይሳታ ኢያራ ዎላ ኤሃናይሳ ኣማኖስ። ");
INSERT INTO gofENT_vpl VALUES ("H14_15","082_4_15","1TH","4","15","15","ጎዳይ ኑስ ኦዲዳይሳዳ ጎዳይ ያ ጋላስ ኢያራ ጋሄታናው ኑኒ ፓፃ ዴዔይሳቲ፥ ሃይቂዳይሳታፔ ሲንꬃቶኮ። ");
INSERT INTO gofENT_vpl VALUES ("H14_16","082_4_16","1TH","4","16","16","ጎዳይ ዎልቃማ ኪታራ፥ ኪታንቾታ ሃላቃ ጊርሳራ፥ ፆሳ ሞይዜ ፑኖራ፥ ሳሎፔ ዎꬋና። ኪሪስቶሳ ኣማኒዲ ሃይቂዳይሳቲ ኮይሮቲዲ ሃይቆፔ ዴንዳና። ");
INSERT INTO gofENT_vpl VALUES ("H14_17","082_4_17","1TH","4","17","17","ሄሳፌ ጉዬ፥ ሄ ዎዴ ኑኒ ፓፃ ዴዔይሳቲ፥ ጎዳራ ሻራን ጋሄታናው ኤንታራ ኢሲፌ ሳሎ ኤኬታና። ሄሳፌ ጉዬ፥ ኑኒ ጎዳራ ኢሲፌ ሜሪናው ዳና። ");
INSERT INTO gofENT_vpl VALUES ("H14_18","082_4_18","1TH","4","18","18","ሄሳ ጊሾ፥ ሃ ቃላን ኢሶይ ኢሱዋ ሚንꬄꬂቴ። ");
INSERT INTO gofENT_vpl VALUES ("H15_1","082_5_1","1TH","5","1","1","ታ ኢሻቶ፥ ሃ ሃኖቲ ሃናና ዎዲያኔ ኣጌና ሂንቴው ፃፋናው ኮሼና። ");
INSERT INTO gofENT_vpl VALUES ("H15_2","082_5_2","1TH","5","2","2","ጎዳ ጋላሳይ ካይሶይ ቃማ ዬይሳዳ ያናይሳ ሂንቴ ሎይꬂ ኤሬታ። ");
INSERT INTO gofENT_vpl VALUES ("H15_3","082_5_3","1TH","5","3","3","ኣሳይ፥ «ሳዒ ሳሮ፥ ኣይኮይካ ሃኔና» ያጊሺን፥ ማጫስ ኢቄꬂ ኦይኬይሳዳ ꬋዮይ ኤንቲ ቆፖና ኤንታ ቦላ ያና። ኤንቲ ኣይ ኦጌንካ ኬሲ ኤኮኮና። ");
INSERT INTO gofENT_vpl VALUES ("H15_4","082_5_4","1TH","5","4","4","ሺን ኑ ኢሻቶ፥ ሄ ጋላሳይ ሂንቴው ካይሶይ ዬይሳዳ ያናው ሂንቴ ꬉማን ዴዔኬታ። ");
INSERT INTO gofENT_vpl VALUES ("H15_5","082_5_5","1TH","5","5","5","ሂንቴ ኡባይ ፖዖ ኣሲኔ ጋላሳን ዴዒያ ኣሲ፤ ኑኒ ቃማ ኣሲ ዎይኮ ꬉማ ኣሲ ጊዶኮ። ");
INSERT INTO gofENT_vpl VALUES ("H15_6","082_5_6","1TH","5","6","6","ሄሳ ጊሾ፥ ኑኒ ሃራቲ ꬊስኬይሳዳ ꬊስካናው ቤሴና፤ ኑኒ ባርካንዉኔ ጊጊዲ ዳናው ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("H15_7","082_5_7","1TH","5","7","7","ꬊስኬይሳቲ ቃማ ꬊስኮሶና፤ ማꬆቴይሳቲ ቃማ ማꬆቶሶና። ");
INSERT INTO gofENT_vpl VALUES ("H15_8","082_5_8","1TH","5","8","8","ሺን ኑኒ ጋላሳ ኣሲ ጊዲያ ጊሾ ጊጊዲ ዳናው ቤሴስ። ኣማኖኔ ሲቆ ፁሩሬዳ ቲራን ማዒዲ፥ ኣቶቴꬃ ኡፋይሳ ሁዔን ዎꬂያ ኦላ ቢራታ ባርኔፃዳ ዎꬂዲ ዳናው ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("H15_9","082_5_9","1TH","5","9","9","ፆሳይ ኑና ኑ ጎዳ ዬሱስ ኪሪስቶሳ ባጋራ ኩሜꬃ ኣቶቴꬂ ኤካና ሜላ ዶሪስፔ ኣቲን ሃንቆስ ዶሪቤና። ");
INSERT INTO gofENT_vpl VALUES ("H15_10","082_5_10","1TH","5","10","10","ኑኒ ፓፃ ዴዒን ዎይኮ ሃይቂን፥ ኪሪስቶሲ ያ ዎዴ ኢያራ ኢሲፌ ዳና ሜላ ኪሪስቶሲ ኑ ጊሾ ሃይቂስ። ");
INSERT INTO gofENT_vpl VALUES ("H15_11","082_5_11","1TH","5","11","11","ሄሳ ጊሾ፥ ሂንቴ ካሴ ኦꬄይሳዳ፥ ኢሶይ ኢሱዋ ሚንꬄꬂቴኔ ዲቺቴ። ");
INSERT INTO gofENT_vpl VALUES ("H15_12","082_5_12","1TH","5","12","12","ኑ ኢሻቶ፥ ሂንቴ ጊዶን ኦꬄይሳታ፥ ሂንቴና ካሌꬃና ሜላኔ ዞራና ሜላ ጎዳይ ዶሪዳይሳታ ቦንቻና ሜላ ሂንቴና ዎሶስ። ");
INSERT INTO gofENT_vpl VALUES ("H15_13","082_5_13","1TH","5","13","13","ኤንቲ ኦꬂያ ኦሱዋ ጊሾ ኤንታ ዳሮ ቦንቺቴኔ ሲቂቴ። ኢሶይ ኢሱዋራ ሳሮቴꬃን ዴዒቴ። ");
INSERT INTO gofENT_vpl VALUES ("H15_14","082_5_14","1TH","5","14","14","ኑ ኢሻቶ፥ ኑኒ ሂንቴና ዞሮስ። ቦዛታ ሃንቂቴ፤ ባቤይሳታ ሚንꬄꬂቴ፤ ዳቡራንቾታ ማዲቴ፤ ኣሴ ኡባ ዳንዳዒቴ። ");
INSERT INTO gofENT_vpl VALUES ("H15_15","082_5_15","1TH","5","15","15","ኦኒካ ኢታ ጊሾ ኢታ ዛሮና ሜላ ናጌቲቴ። ሂንቴ ዎሊሲኔ ኣሳ ኡባስ ሎዖባ ኦꬃናው ሚኒቴ። ");
INSERT INTO gofENT_vpl VALUES ("H15_16","082_5_16","1TH","5","16","16","ኡባ ዎዴ ኡፋይቲቴ። ");
INSERT INTO gofENT_vpl VALUES ("H15_17","082_5_17","1TH","5","17","17","ኡባ ዎዴ ፆሳ ዎሲቴ። ");
INSERT INTO gofENT_vpl VALUES ("H15_18","082_5_18","1TH","5","18","18","ኡባባን ጋላቲቴ። ኪሪስቶስ ዬሱሳ ባጋራ ፆሳይ ሂንቴፌ ኮዬይ ሄሳ። ");
INSERT INTO gofENT_vpl VALUES ("H15_19","082_5_19","1TH","5","19","19","ጌሻ ኣያና ኦሱዋ ቶይሶፒቴ። ");
INSERT INTO gofENT_vpl VALUES ("H15_20","082_5_20","1TH","5","20","20","ቲንቢቴ ቃላ ካꬎፒቴ። ");
INSERT INTO gofENT_vpl VALUES ("H15_21","082_5_21","1TH","5","21","21","ኡባባ ፓጪቴ፤ ሎዖባ ኤኪቴ። ");
INSERT INTO gofENT_vpl VALUES ("H15_22","082_5_22","1TH","5","22","22","ኢታ ኦሶ ኡባፌ ሃኪቴ። ");
INSERT INTO gofENT_vpl VALUES ("H15_23","082_5_23","1TH","5","23","23","ሳሮ ኢሚያ ፆሳይ ባ ሁዔን ሂንቴና ፖሎ ጌሾ። ኑ ጎዳይ ዬሱስ ኪሪስቶሲ ያና ጋላሳስ፥ ፆሳይ ሂንቴ ኣያና፥ ሂንቴ ሼምፑዋኔ ሂንቴ ኩሜꬃ ኣሳቴꬃ ቦሬይ ባይና ናጎ። ");
INSERT INTO gofENT_vpl VALUES ("H15_24","082_5_24","1TH","5","24","24","ሂንቴና ፄጌይሲ ኣማኔቲዳይሳ ጊዲያ ጊሾ ሄሳ ኢ ፖላና። ");
INSERT INTO gofENT_vpl VALUES ("H15_25","082_5_25","1TH","5","25","25","ኑ ኢሻቶ፥ ኑስ ፆሳ ዎሲቴ። ");
INSERT INTO gofENT_vpl VALUES ("H15_26","082_5_26","1TH","5","26","26","ኣማኒያ ኣሳ ኡባ ጌሻ ዬሬቴꬃን ሳሮꬂቴ። ");
INSERT INTO gofENT_vpl VALUES ("H15_27","082_5_27","1TH","5","27","27","ሂንቴ ሃ ኪታ ኣማኒያ ኣሳ ኡባስ ናባባናዳ ጎዳ ሱንꬃን ሂንቴና ዎሳይስ። ");
INSERT INTO gofENT_vpl VALUES ("H15_28","082_5_28","1TH","5","28","28","ኑ ጎዳ ዬሱስ ኪሪስቶሳ ኣꬎ ኬሃቴꬃይ ሂንቴራ ኢሲፌ ጊዶ። ኣሚንዒ። ");
INSERT INTO gofENT_vpl VALUES ("H21_1","083_1_1","2TH","1","1","1","ጳዉሎሲ፥ ሲላሴይኔ ፂሞቲዮሲ ቴሴሎንቄ ዎሳ ኬꬃን ዴዒያ፥ ፆሳ ኣዋባኔ ጎዳ ዬሱስ ኪሪስቶሳባ ጊዲዳ ኣሳስ ፃፊዳ ኪታ። ");
INSERT INTO gofENT_vpl VALUES ("H21_2","083_1_2","2TH","1","2","2","ፆሳ ኑ ኣዋፔኔ ጎዳ ዬሱስ ኪሪስቶሳፔ ኣꬎ ኬሃቴꬃይኔ ሳሮቴꬃይ ሂንቴው ጊዶ። ");
INSERT INTO gofENT_vpl VALUES ("H21_3","083_1_3","2TH","1","3","3","ኑ ኢሻቶ፥ ሂንቴ ኣማኖይኔ ሂንቴ ኢሶይ ኢሱዋኔ ሃራታ ሲቂያ ሲቆይ ዳሮ ዲጪያ ጊሾ ኑኒ ሄሳስ ፆሳ ኡባ ዎዴ ጋላታናው ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("H21_4","083_1_4","2TH","1","4","4","ሂንቴና ጋኪዳ ጎዳኒኔ ዋዬ ኡባን ጌንጫኒኔ ኣማኖን ሚኒዲ ኤቂዳ ጊሾ ኑኒ ኑ ሁዔን ፆሳ ዎሳ ኬꬃታን ሂንቴባ ማርካቲሼ ሂንቴናን ጬቄቶስ። ");
INSERT INTO gofENT_vpl VALUES ("H21_5","083_1_5","2TH","1","5","5","ሂንቴ ኢያ ጊሾ ጊዲ ሜቶ ኤኪያ ፆሳ ካዎቴꬃስ ቤሴይሳታ ጊዲዲ ታይቤታና ሜላ ፆሳ ፂሎ ፒርዳስ ሃይሲ ማላ። ");
INSERT INTO gofENT_vpl VALUES ("H21_6","083_1_6","2TH","1","6","6","ፆሳይ ቱማ ፒርዳ ፒርዳና። ፆሳይ ሂንቴና ዋይሴይሳታ ቦላ ዋዬ ኤሃና። ");
INSERT INTO gofENT_vpl VALUES ("H21_7","083_1_7","2TH","1","7","7","ጎዳይ ዬሱሲ ባ ዎልቃማ ኪታንቾታራ፥ ታማ ላጮራ ሳሎፔ ያ ዎዴ ዋዬቲያ ሂንቴናኔ ኑና ሼምፒሳና። ");
INSERT INTO gofENT_vpl VALUES ("H21_8","083_1_8","2TH","1","8","8","ቃሲ ፆሳይ ባና ኤሮናይሳታኔ ኑ ጎዳ ዬሱስ ኪሪስቶሳ ዎንጌላስ ኪቴቶናይሳታ ፒርዳና። ");
INSERT INTO gofENT_vpl VALUES ("H21_9","083_1_9","2TH","1","9","9","ኤንቲ ጎዳ ሲንꬃፌኔ ኢያ ቦንቹዋ ዎልቃፌ ሻኬቲዲ ሜሪና ꬋዩዋን ፒርዴታና። ");
INSERT INTO gofENT_vpl VALUES ("H21_10","083_1_10","2TH","1","10","10","ሄ ጋላስ፥ ኢ ባይሳታኒኔ ባና ኣማኔይሳታ ኡባን ቦንቼታንዉኔ ሳቤታናው ያ ዎዴ ኑ ሂንቴው ኦዲዳ ኪታ ሂንቴ ኣማኒዳ ጊሾ ሂንቴ ኢያ ቦንቼይሳታ ጊዶኒኔ ሳቤይሳታ ጊዶን ዳና። ");
INSERT INTO gofENT_vpl VALUES ("H21_11","083_1_11","2TH","1","11","11","ኑኒ ሂንቴው ኡባ ዎዴ ፆሳ ዎሴይ ሄሳሳ። ኑ ፆሳይ ሂንቴና ፄጊዳ ዴዑዋስ ቤሴይሳታ ጊዲዲ ታይቤታና ሜላ ኑኒ ዎሶስ። ሂንቴ ሎዖባ ኦꬃናው ኣሞቲያ ኣሙዋኔ ሂንቴ ኣማኖ ኦሱዋ ኢ ባ ዎልቃን ፖሎ። ");
INSERT INTO gofENT_vpl VALUES ("H21_12","083_1_12","2TH","1","12","12","ሄሳን ኑ ፆሳኔ ኑ ጎዳ ዬሱስ ኪሪስቶሳ ኣꬎ ኬሃቴꬃን፥ ጎዳ ዬሱሳ ሱንꬃ ሂንቴ ቦንቻና፤ ሂንቴናካ ኢ ቦንቻና። ");
INSERT INTO gofENT_vpl VALUES ("H22_1","083_2_1","2TH","2","1","1","ኑ ኢሻቶ፥ ኑ ጎዳ ዬሱስ ኪሪስቶሳ ዩሳባኔ ኑ ኢያራ ጋሄታናው ሺቃናባስ ኑ ሂንቴና ዎሶስ። ");
INSERT INTO gofENT_vpl VALUES ("H22_2","083_2_2","2TH","2","2","2","ቲንቢቴን ዎይኮ ሃራ ኣሳፔ ሲዒዳ ቃላን ዎይኮ ኑፔ ኤኪዳ ኪታዳ ኦꬂዲ፥ «ጎዳ ጋላሳይ ጋኪስ» ጊዲ ሂንቴ ዎዛናይ ዳጋሞፎኔ ዋባቆፖ። ");
INSERT INTO gofENT_vpl VALUES ("H22_3","083_2_3","2TH","2","3","3","ሂንቴና ኦኒካ ኣይ ኦጌንካ ባሌꬆፎ። ካሴቲዲ ዉርሴꬃ ኡራ ጌላቴꬃይ ቆንጮናኔ ꬋዮይ ቤሲያ ጌላ ኡራይ ዮና ዴዒሺን፥ ጎዳ ጋላሳይ ጋኬና። ");
INSERT INTO gofENT_vpl VALUES ("H22_4","083_2_4","2TH","2","4","4","ኣሲ ጎይኒያባኔ ፆሳያባ ኡባ ኢ ኢፃናኔ ባና ꬎቁ ኦꬃና። ሃሪ ኣቶሺን፥ ፆሳ ኬꬂ ጌሊ ኡቲዲ፥ «ታኒ ፆሴ» ጋና። ");
INSERT INTO gofENT_vpl VALUES ("H22_5","083_2_5","2TH","2","5","5","ታኒ ሂንቴራ ዴዓሼ ሂንቴው ኦዲዳይሳ ኣኬኬኬቲ? ");
INSERT INTO gofENT_vpl VALUES ("H22_6","083_2_6","2TH","2","6","6","ኢ ባ ጋላሳን ያናፔ ኣቲን ሃዒ ዮናዳ ኣይቢ ኢያ ቴቂያኮ ኤሬታ። ");
INSERT INTO gofENT_vpl VALUES ("H22_7","083_2_7","2TH","2","7","7","ኣሳስ ቆንጪቦና ጌላቴꬃ ፁራ ዎልቃይ ሃዒካ ኦꬄስ፥ ሺን ሃዒ ኢያ ቴቄይሲ ዴዔስ። ኢያ ቴቄይሲ ኦጌፔ ኪቻና ጋካናው ኢ ቆንጬና። ");
INSERT INTO gofENT_vpl VALUES ("H22_8","083_2_8","2TH","2","8","8","ሄሳፌ ጉዬ፥ ጌላ ኡራይ ቆንጫና፥ ሺን ጎዳ ዬሱሲ ባ ዶናፔ ኬያ ሼምፑዋን ባ ቦንቾ ዩሳን ኢያ ዎꬋና። ");
INSERT INTO gofENT_vpl VALUES ("H22_9","083_2_9","2TH","2","9","9","ጌላ ኡራይ ፃላሂያ ዎልቃን ዪዲ ዎርዶ ማላታታኔ ማላሊሲያባታ ኦꬃና። ");
INSERT INTO gofENT_vpl VALUES ("H22_10","083_2_10","2TH","2","10","10","ሄሳዳካ፥ ꬋዮስ ዴዒያ ኣሳታ ዱማ ዱማ ጪሚያ ኢታ ኦሶን ባሌꬃና። ኤንቲ ꬋዪዳይ ኣሺያ ቱማ ዶሲዲ ኤኮና ኢፂዳ ጊሾሳ። ");
INSERT INTO gofENT_vpl VALUES ("H22_11","083_2_11","2TH","2","11","11","ሄሳ ጊሾ፥ ኤንቲ ዎርዶ ጊዲያባ ኣማናና ሜላ ፆሳይ ዎልቃማ ባሌሶ ኤንታ ቦላ ዬዳና። ");
INSERT INTO gofENT_vpl VALUES ("H22_12","083_2_12","2TH","2","12","12","ሄሲካ፥ ቱማ ኣማኖና ኣሳቲ፥ ናጋራ ኦሶን ኡፋይቴሳቲ ኡባይ ፒርዴታና ሜላሳ። ");
INSERT INTO gofENT_vpl VALUES ("H22_13","083_2_13","2TH","2","13","13","ጎዳይ ዶሲያ ኑ ኢሻቶ፥ ኑኒ ፆሳ ሂንቴ ጊሾ ኡባ ዎዴ ጋላታናው ቤሴስ። ሂንቴ ኣታና ሜላ ፆሳይ ጌሻ ኣያና ዎልቃን ሂንቴና ጌሺዳይሳኔ ሂንቴካ ቱማ ኣማኒዳይሳን ኢ ሂንቴና ባይራዳ ዶሪስ። ");
INSERT INTO gofENT_vpl VALUES ("H22_14","083_2_14","2TH","2","14","14","ፆሳይ፥ ኑ ሂንቴው ኦዲዳ ዎንጌላ ባጋራ ሂንቴና ፄጊዳይ፥ ሂንቴ ኑ ጎዳ ዬሱስ ኪሪስቶሳራ ኢሲፌ ቦንቼታናሳ። ");
INSERT INTO gofENT_vpl VALUES ("H22_15","083_2_15","2TH","2","15","15","ሂዛ፥ ኑ ኢሻቶ፥ ሚኒዲ ኤቂቴ። ኑኒ ሂንቴና ኑ ዶናን ጊዲን ዎይኮ ዳብዳቢያን ጊዲን ታማርሲዳ ቲሚርቲያ ኦይኪቴ። ");
INSERT INTO gofENT_vpl VALUES ("H22_16","083_2_16","2TH","2","16","17","ፆሳይ ኑ ኣዋይ ኑና ዶሴስ። ኢ ኑስ ኬሃ፤ ኢ ሜሪና ሚንꬄꬆኔ ሎዖ ኡፋይሳ ኑስ ኢሚስ። ሂንቴ ኡባ ዎዴ ሎዖባ ኦꬃናዉኔ ኦዴታናው ኢ ሚንꬄꬃና ሜላኔ ማዳና ሜላ ኑ ጎዳ ዬሱስ ኪሪስቶሳኔ ፆሳ ኑ ኣዋ ዎሶስ። ");
INSERT INTO gofENT_vpl VALUES ("H23_1","083_3_1","2TH","3","1","1","ዉርሴꬃን ኑ ኢሻቶ፥ ጎዳ ቃላይ ሂንቴ ጊዶን ኤሌሲዲ ዳልጋናዳኔ ቦንቼታናዳ ኑስ ዎሲቴ። ");
INSERT INTO gofENT_vpl VALUES ("H23_2","083_3_2","2TH","3","2","2","ሄሳዳካ፥ ኣሲ ኡባይ ቃላ ሲዒዲ ኣማኖና ጊሾ ፆሳይ ጌላታፔኔ ኢታ ኣሳታፔ ኑና ኣሻና ሜላ ኑስ ዎሲቴ። ");
INSERT INTO gofENT_vpl VALUES ("H23_3","083_3_3","2TH","3","3","3","ሺን ጎዳይ ኣማኔቲዳይሳ፤ ኢ ሂንቴና ሚንꬄꬃናኔ ፃላሄፔ ናጋና። ");
INSERT INTO gofENT_vpl VALUES ("H23_4","083_3_4","2TH","3","4","4","ኑኒ ሂንቴና ኪቴይሳ ሃዒካ ሲንꬃፌካ ሂንቴ ኦꬃናይሳስ ጎዳን ኑኒ ኣማኔቶስ። ");
INSERT INTO gofENT_vpl VALUES ("H23_5","083_3_5","2TH","3","5","5","ጎዳይ ሂንቴ ዎዛና ፆሳ ሲቁዋኮኔ ኪሪስቶሳ ዳንዳዓኮ ካሌꬆ። ");
INSERT INTO gofENT_vpl VALUES ("H23_6","083_3_6","2TH","3","6","6","ኑ ኢሻቶ፥ ሂንቴ ኑፔ ኤኪዳ ኪታ ካሎናይሳታፔኔ ኦሶ ቢሊያ ኣዛላ ኣማኒያ ኣሳታፔ ሂንቴ ሻኬታናዳ ጎዳ ዬሱስ ኪሪስቶሳ ሱንꬃን ሂንቴና ኪቶስ። ");
INSERT INTO gofENT_vpl VALUES ("H23_7","083_3_7","2TH","3","7","7","ኑዳ ሃኒዲ ዳናው ቤሴይሳ ሂንቴ፥ ሂንቴ ሁዔን ኤሬታ። ኑኒ ሂንቴራ ዴዒያ ዎዴ ኦሶ ቢሊቦኮ። ");
INSERT INTO gofENT_vpl VALUES ("H23_8","083_3_8","2TH","3","8","8","ኑኒ ኦዴፌካ ካꬂ ሜላ ሚቦኮ። ኑስ ዳንዳዔቲዳ ሜላ ቃማኔ ጋላስ ኦꬂ ዳቡሪዲ ዴዒዳፔ ኣቲን ኦዴስካ ቶሆ ጊዲቦኮ። ");
INSERT INTO gofENT_vpl VALUES ("H23_9","083_3_9","2TH","3","9","9","ኑኒ ሄሳ ኦꬂዳይ፥ ሂንቴው ሌሚሶ ጊዳናሳፌ ኣቲን ሂንቴፌ ማዴ ኦይቻናው ኑስ ማቲ ꬋዪና ጊዴና። ");
INSERT INTO gofENT_vpl VALUES ("H23_10","083_3_10","2TH","3","10","10","ኑ ሂንቴራ ዴዒያ ዎዴካ፥ «ኦꬃናው ኮዮና ኣሲ ኦኒካ ሞፖ» ያጊዲ ኪቲዳ። ");
INSERT INTO gofENT_vpl VALUES ("H23_11","083_3_11","2TH","3","11","11","ኑኒ ሄሳ ጊዳይ፥ ሂንቴ ጊዶን ኢሲ ኢሲ ኣዛላቲ ዴዔይሳ ሲዒዳ ጊሾሳ። ሄ ኣሳቲ ጌልሶናባን ጌሊዲ ሃራታ ኦሶ ቢሊሶሶናፔ ኣቲን ኣይኮካ ኦꬆኮና። ");
INSERT INTO gofENT_vpl VALUES ("H23_12","083_3_12","2TH","3","12","12","ኑኒ ሄሳ ሜላ ኣሳቲ ማራ ዴዖ ዳናዳኔ ባንታና ኮሺያባ ኦꬂዲ ዴማናዳ ጎዳ ዬሱስ ኪሪስቶሳ ሱንꬃን ኤንታ ኪቶሲኔ ዞሮስ። ");
INSERT INTO gofENT_vpl VALUES ("H23_13","083_3_13","2TH","3","13","13","ሺን ኑ ኢሻቶ፥ ሎዖ ኦሶ ኦꬃናው ኣዛሎፊቴ። ");
INSERT INTO gofENT_vpl VALUES ("H23_14","083_3_14","2TH","3","14","14","ሃዒ ኑኒ ሃ ዳብዳቢያን ኪቲዳ ኪታስ ኪቴቶና ኣሲ ኦኒካ ዴዒኮ ሄ ኡራ ኤሪቴ። ኢ ዬላታና ሜላ ኢያፔ ሻኬቲቴ። ");
INSERT INTO gofENT_vpl VALUES ("H23_15","083_3_15","2TH","3","15","15","ሺን ኢያ ኢሻዳ ሴሪቴፔ ኣቲን ሞርኬዳ ፄሎፊቴ። ");
INSERT INTO gofENT_vpl VALUES ("H23_16","083_3_16","2TH","3","16","16","ሳሮ ኢሚያ ጎዳይ፥ ባ ሁዔን ሂንቴው ኡባ ዎዴኔ ኡባ ባጋራ ሳሮ ኢሞ። ጎዳይ ሂንቴ ኡባራ ጊዶ። ");
INSERT INTO gofENT_vpl VALUES ("H23_17","083_3_17","2TH","3","17","17","ታኒ ጳዉሎሲ፥ ሃ ኪታ ታ ኩሼን ፃፋስ። ታ ኪታ ኡባስ ማላይ ሃይሳ፤ ታኒ ሄሳዳ ፃፋይስ። ");
INSERT INTO gofENT_vpl VALUES ("H23_18","083_3_18","2TH","3","18","18","ኑ ጎዳ ዬሱስ ኪሪስቶሳ ኣꬎ ኬሃቴꬃይ ሂንቴ ኡባራ ጊዶ። ");
INSERT INTO gofENT_vpl VALUES ("T11_1","084_1_1","1TI","1","1","1","ኑና ኣሺያ ፆሳኒኔ ኑ ኡፋይሳን ናጊያ ዬሱስ ኪሪስቶሳን ኪቴቲዳ፥ ዬሱስ ኪሪስቶሳ ሃዋሬ ጊዲዳ፥ ጳዉሎሳፔ፥ ");
INSERT INTO gofENT_vpl VALUES ("T11_2","084_1_2","1TI","1","2","2","ኣማኖን ታው ቱማ ናዓ ጊዲዳ ፂሞቲዮሳስ። ፆሳ ኑ ኣዋ፥ ኑ ጎዳ ኪሪስቶሳ ኣꬎ ኬሃቴꬃይ፥ ማሮቴꬃይኔ ሳሮቴꬃይ ኔው ጊዶ። ");
INSERT INTO gofENT_vpl VALUES ("T11_3","084_1_3","1TI","1","3","3","ታኒ ማቄዶኒያ ባሼ ኔና ሃዳሪዳይሳዳ፥ ኢሲ ኢሲ ኣሳቲ ዎርዶ ቲሚርቲያ ታማርሴይሳ ዲጋናው ኔ ኤፌሶናን ጋምዓና ሜላ ኮያይስ። ");
INSERT INTO gofENT_vpl VALUES ("T11_4","084_1_4","1TI","1","4","4","ኤንቲ ጎዒ ባይና ሃይሴ ኦዳኔ ባንታ ኮቻ ታይቡዋ ኣጋናዳ ኦዳ። ሄሳ ሜላባይ ፓላማ ካሌꬄሲፔ ኣቲን ኣማኖን ኦሴቲያ ፆሳ ኦሱዋስ ማዴና። ");
INSERT INTO gofENT_vpl VALUES ("T11_5","084_1_5","1TI","1","5","5","ሃ ኪታ ሁዔ ቆፋይ ጌሻ ዎዛናፔ፥ ሎዖ ካሃፔኔ ቱማ ኣማኑዋፔ ቤንቲያ ሲቁዋ ዴንꬄꬃናሳ። ");
INSERT INTO gofENT_vpl VALUES ("T11_6","084_1_6","1TI","1","6","6","ኢሲ ኢሲ ኣሳቲ ሃይሳ ኣጊዲ፥ ፓꬆና ኦዳኮ ሲሚዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("T11_7","084_1_7","1TI","1","7","7","ኤንቲ ፆሳ ሂጊያ ኣስታማሬ ጊዳናው ኮዮሶና። ሺን ኤንቲ ኣይ ኦዲያኮ ዎይኮ ቱማ ኦꬂዲ ኦዴይሲ ኢ ኣይቤኮ ኤሮኮና። ");
INSERT INTO gofENT_vpl VALUES ("T11_8","084_1_8","1TI","1","8","8","ኣሲ ቤሴይሳዳ ሂጊያን ጎዔቲኮ ሂጌይ ሎዖ ጊዴይሳ ኤሮስ። ");
INSERT INTO gofENT_vpl VALUES ("T11_9","084_1_9","1TI","1","9","9","ኢሲባ ኣኬካናው ኮሼስ። ሂጌይ ሎዖ ኣሳስ ሜꬌቲቤና። ሺን ሂጌይ፥ ሂጌ ሜንꬄይሳታ፥ ዎራንꬖታ፥ ፆሴ ያዮናይሳታ፥ ሼምፖ ዎꬌይሳታ፥ ናጋራንቾታ፥ ጌሻቴꬂ ባይናይሳታ፥ ቱናታ፥ ሃሪ ኣቶሺን ባንታ ኣዪው ዎይኮ ኣዋ ዎꬌይሳታ፥ ");
INSERT INTO gofENT_vpl VALUES ("T11_10","084_1_10","1TI","1","10","10","ላሜይሳታ፥ ኣዴይ ኣዴራ ላይማቴይሳታ፥ ኣሴ ባይዜይሳታ፥ ዎርዳንቾታ፥ ዎርዶን ጫቄይሳታ፥ ዎይኮ ቱማ ቲሚርቲያራ ጋሄቶና ኣይ ኦሶ ኦꬄይሳታ ሴራናው ኬዪስ። ");
INSERT INTO gofENT_vpl VALUES ("T11_11","084_1_11","1TI","1","11","11","ሄ ቲሚርቴይ ቦንቾኔ ኣንጄቲዳ ፆሳይ ታኒ ኣዋጃና ሜላ ታው ሃዳራ ኢሚዳ ዎንጌላ ጊዶን ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("T11_12","084_1_12","1TI","1","12","12","ታኒ ኦꬂያ ኦሱዋን ታው ዎልቃ ኢሚዳ ኑ ጎዳ ኪሪስቶስ ዬሱሳ ጋላታይስ። ታና ባ ኦሱዋስ ሹሚዲ ሄ ኦሱዋስ ቤሳሳ ጊዲ ታይቢዳ ጊሾ ኢያ ጋላታይስ። ");
INSERT INTO gofENT_vpl VALUES ("T11_13","084_1_13","1TI","1","13","13","ታኒ ሃይሳፌ ካሴ ኢያ ጫዬይሳ፥ ኢያ ዬዴꬄይሳኔ ሜቶꬄይሳ ጊዲኮካ ታኒ ሄሳ ኤሮናኔ ኣማኖና ኦꬂዳ ጊሾ ፆሳይ ታና ማሪስ። ");
INSERT INTO gofENT_vpl VALUES ("T11_14","084_1_14","1TI","1","14","14","ኑ ጎዳይ ባ ኣꬎ ኬሃቴꬃ ታ ቦላ ጉሲዲ፥ ሄ ኣꬎ ኬሃቴꬃራ ኣማኖኔ ሲቆ ኪሪስቶስ ዬሱሳ ባጋራ ታው ኢሚስ። ");
INSERT INTO gofENT_vpl VALUES ("T11_15","084_1_15","1TI","1","15","15","«ኪሪስቶስ ዬሱሲ ናጋራንቾታ ኣሻናው ሃ ኣላሚያ ዪስ» ጊያ ቃላይ ኣማንꬄይሳኔ ኣሳ ኡባይ ኤካናው ቤሴይሳ። ኡባፌ ኣꬊዳ ናጋራንቾይ ታና። ");
INSERT INTO gofENT_vpl VALUES ("T11_16","084_1_16","1TI","1","16","16","ሺን ሜሪና ዴዑዋ ኤካናው ኢያ ኣማኒያ ኣሳስ ታኒ ሌሚሶ ጊዳና ሜላ ዬሱስ ኪሪስቶሲ ዳሮ ዳንዳዒስ። ታው ኡባፌ ኣꬊዳ ናጋራንቹዋስ ፆሳይ ባ ማሮታ ዳርሲስ። ");
INSERT INTO gofENT_vpl VALUES ("T11_17","084_1_17","1TI","1","17","17","ኣይፌን ቤንቶናይሳስ፥ ኢሲ ፆሳስ፥ ሃይቆናይሳስ፥ ሜሪና ካዉዋስ፥ ሜሪናፔ ሜሪና ጋካናው ጋላታይኔ ቦንቾይ ጊዶ። ኣሚንዒ። ");
INSERT INTO gofENT_vpl VALUES ("T11_18","084_1_18","1TI","1","18","18","ፂሞቲዮሳ፥ ታ ናዓው፥ ካሴ ኔባ ናቤቲ ኦዲዳ ቃላ ቦላ ኤቃዳ ሃ ኪታ ሃዳራ ኔው ኢማይስ። ኔ ሄ ቃላ ካሊኮ ሎዖ ኦላ ኦሌታና። ");
INSERT INTO gofENT_vpl VALUES ("T11_19","084_1_19","1TI","1","19","19","ኣማኖይኔ ሎዖ ካሂ ኔው ዴዖ። ኢሶቲ ኢሶቲ ካሃ ꬋዪዲ ማርካቤይ ሆቤን ꬋዬይሳዳ ባንታ ኣማኑዋ ꬋይሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("T11_20","084_1_20","1TI","1","20","20","ሄሳ ሃኒዳይሳታ ጊዶን ሄሜኔዮሲኔ ኢስኪንዲሬይ ዴዖሶና። ኤንቲ ታማሪዲ ፆሳ ጫዬይሳ ኣጋና ሜላ ታኒ ፃላሄስ ኤንታና ኣꬃ ኢማስ። ");
INSERT INTO gofENT_vpl VALUES ("T12_1","084_2_1","1TI","2","1","1","ኡባፌ ሲንꬃታዳ፥ ኣሳ ኡባስ ፆሳ ኦይቻናው፥ ዎሳናው፥ ጋናታናዉኔ ጋላታናው ቤሴይሳ ታኒ ኔና ኣኬኪሳይስ። ");
INSERT INTO gofENT_vpl VALUES ("T12_2","084_2_2","1TI","2","2","2","ኑኒ ቱማ ኣያና ዴዖኒኔ ጌሻቴꬃን ፆሳ ጎይኒሼ ሳሮቴꬃኒኔ ዎፑ ጊዳ ዴዖን ዳና ሜላ ካዎታሲኔ ሹማታ ኡባስ ዎሲቴ። ");
INSERT INTO gofENT_vpl VALUES ("T12_3","084_2_3","1TI","2","3","3","ሄሳ ሜላ ዎሳይ ኑና ኣሺያ ፆሳ ሲንꬃን ሎዖኔ ኡፋይሲያባ። ");
INSERT INTO gofENT_vpl VALUES ("T12_4","084_2_4","1TI","2","4","4","ፆሳይ ኣሲ ኡባይ ኣታናዳኔ ቱማ ኤራናዳ ኮዬስ። ");
INSERT INTO gofENT_vpl VALUES ("T12_5","084_2_5","1TI","2","5","5","ኢሲ ፆሲ ዴዔስ። ፆሳፌኔ ኣሳፔ ጊዶን ጊዲዲ ሲጌꬂያ ኢሶይ ዴዔስ፤ ኢካ ኣሴ ጊዲዳ ኪሪስቶስ ዬሱሳ። ");
INSERT INTO gofENT_vpl VALUES ("T12_6","084_2_6","1TI","2","6","6","ኢ ኣሳ ኡባ ዎዛናው ባና ኣꬂ ኢሚስ። ፆሳይ ባ ዎዲያን ኣሳ ኡባ ዎዛናው ኮዬይሳ ቤሲያ ማርካይ ሃይሳ። ");
INSERT INTO gofENT_vpl VALUES ("T12_7","084_2_7","1TI","2","7","7","ፆሳይ ታና ዎንጌላስ ኣስታማሬኔ ሃዋሬ ኦꬂዲ ዶሪዳይ ሄሳሳ። ታኒ ቱማ ኦዳይስ፤ ዎርዶቲኬ፤ ኣማኖኔ ቱማ ኣይሁዴ ጊዶና ኣሳስ ማርካታና ሜላ ፆሳይ ታና ሹሚስ። ");
INSERT INTO gofENT_vpl VALUES ("T12_8","084_2_8","1TI","2","8","8","ሄሳ ጊሾ፥ ኡባ ቤሳን ዴዒያ ኣዴቲ፥ ባንታና ፆሳስ ዱማዪዲ፥ ሃንቆኔ ፓላማ ዲጊዲ፥ ባንታ ኩሺያ ፑዴ ዴንꬂዲ ፆሳ ዎሳና ሜላ ኮያይስ። ");
INSERT INTO gofENT_vpl VALUES ("T12_9","084_2_9","1TI","2","9","9","ሄሳዳ ማጫሳይ ባንታና ሃሪዳይሳ ቆንጪሲያ፥ ቦንቾይኔ ማሪ ዴዒያ ማዑዋ ማዓናው ቤሴስ። ኤንቲ ማሪ ባይና ሁዔ ዳꬃን፥ ዎርቃን ዎይኮ ኢንቆን፥ ዎይኮ ኣልዖ ኣፊላን ባንታና ኣሌቂሶፖ። ");
INSERT INTO gofENT_vpl VALUES ("T12_10","084_2_10","1TI","2","10","10","ሺን ፆሳስ ጎይናይስ ጊያ ማጫሳይ ባንታው ቤሴይሳዳ ሎዖባ ኦꬆና። ");
INSERT INTO gofENT_vpl VALUES ("T12_11","084_2_11","1TI","2","11","11","ማጫሲ ኪቴቴꬃን ሲዒ ጊዲ ታማሮ። ");
INSERT INTO gofENT_vpl VALUES ("T12_12","084_2_12","1TI","2","12","12","ታኒ ማጫሳይ ታማርሳና ሜላ ዎይኮ ኣዴ ቦላ ኣዋታና ሜላ ጊዶናሺን ሲዒ ጊዲ ዳና ሜላ ኮያይስ። ");
INSERT INTO gofENT_vpl VALUES ("T12_13","084_2_13","1TI","2","13","13","ኣዳሜይ ኮይሮ ሜꬌቲስ፤ ጉዬፔ ሄዋና ሜꬌታሱ። ");
INSERT INTO gofENT_vpl VALUES ("T12_14","084_2_14","1TI","2","14","14","ቃሲ ጪሜታዳ ፆሳ ሂጊያ ሜንꬂዳይ ማጫሲፔ ኣቲን ኣዳሜ ጊዴና። ");
INSERT INTO gofENT_vpl VALUES ("T12_15","084_2_15","1TI","2","15","15","ሺን ማጫሲ ኣማኖን፥ ሲቆኒኔ ጌሻቴꬃን ባንታና ሃሪዲ ዴዒኮ ናይታ ዬሎን ኣታና። ");
INSERT INTO gofENT_vpl VALUES ("T13_1","084_3_1","1TI","3","1","1","ኦኒካ፥ «ዎሳ ኬꬂ ካሌꬂያ ኣሲ ጊዳናው ኮይኮ ሎዖባ ኣሞቴስ» ጊያ ኦዳይ ቱማ። ");
INSERT INTO gofENT_vpl VALUES ("T13_2","084_3_2","1TI","3","2","2","ዎሳ ኬꬃ ካሌꬂያ ኣሲ ቦሬቶናይሳ፥ ኢሲ ማቺ ፃላሊ ዴዔይሳ፥ ማራን ዴዔይሳ፥ ባና ሃሬይሳ፥ ቤሴይሳዳ ኦꬄይሳ፥ ኢማꬄ ሞኬይሳ፥ ታማርሳናው ዳንዳዔይሳ፥ ");
INSERT INTO gofENT_vpl VALUES ("T13_3","084_3_3","1TI","3","3","3","ማꬆቶናይሳ፥ ኦዬቶናይሳ፥ ፓላሞናይሳ፥ ሚሼ ሲቆናይሳ፥ ");
INSERT INTO gofENT_vpl VALUES ("T13_4","084_3_4","1TI","3","4","4","ኢያ ናይቲ ኢያው ኪቴቴይሳኔ ቦንቼይሳ፥ ባ ኬꬃ ኣይሳናው ዳንዳዔይሳ ጊዳናው ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("T13_5","084_3_5","1TI","3","5","5","ኢሲ ኣሲ ባ ኬꬃ ኣይሳናው ዳንዳዖና ኢፂኮ፥ ፆሳ ዎሳ ኬꬂ ዋቲ ኣይሳናው ዳንዳዒ? ");
INSERT INTO gofENT_vpl VALUES ("T13_6","084_3_6","1TI","3","6","6","ኦቶሮን ሱጌቲዲ፥ ፃላሄይ ፆሳ ፒርዳን ኩንዲዳይሳዳ ኩንዶና ሜላ፥ ኦራꬂ ኣማኒዳ ኣሲ ጊዳናው ቤሴና። ");
INSERT INTO gofENT_vpl VALUES ("T13_7","084_3_7","1TI","3","7","7","ቦሬኒኔ ፃላሄ ፂሄን ጌሎና ሜላ ሄ ኡራይ ኣማኖና ኣሳ ማታን ናሼቴይሳ ጊዳናው ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("T13_8","084_3_8","1TI","3","8","8","ሄሳዳ ቃሲ ዎሳ ኬꬃ ዳቆኔቲ ቦንቼቲዳይሳታ፥ ናምዑ ዶና ኦዴቶናይሳታ፥ ዳሮ ዎይኔ ኡሻ ኡዮናይሳታ፥ ሚሼ ያሬቶናይሳታ፥ ");
INSERT INTO gofENT_vpl VALUES ("T13_9","084_3_9","1TI","3","9","9","ኣማኑዋ ፁራ ጌሻ ካሃን ናጌይሳታ ጊዳናው ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("T13_10","084_3_10","1TI","3","10","10","ኤንቲ ኮይሮቲዲ ፓጬታናው ኮሼስ፤ ኤንታ ቦላ ቦሬይ ባይና ኢፂኮ፥ ዎሳ ኬꬃ ዳቆኔ ጊዲዲ ኦꬆ። ");
INSERT INTO gofENT_vpl VALUES ("T13_11","084_3_11","1TI","3","11","11","ሄሳዳካ፥ ኤንታ ማጫሳቲ ቦንቼቲዳይሳታ፥ ዚጊሮናይሳታ፥ ማራን ዴዔይሳታ፥ ኡባባን ኣማኔቴይሳታ ጊዳናው ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("T13_12","084_3_12","1TI","3","12","12","ዎሳ ኬꬃ ዳቆኔቲ ኢሲ ማቺ ፃላሊ ዴዔይሳ ጊዶ። ባ ናይታኔ ባ ኬꬃ ሎይꬂ ኣይሴይሳ ጊዳናው ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("T13_13","084_3_13","1TI","3","13","13","ዎሳ ኬꬃ ዳቆኔ ጊዲዲ፥ ሎዖ ኦሶ ኦꬄይሳቲ፥ ኤንታው ጊታ ቦንቾ ቃሲ ኪሪስቶስ ዬሱሳን ባንታው ዴዒያ ኣማኑዋባ ኦዳናው ዳሮ ሚኖቴꬂ ዴማና። ");
INSERT INTO gofENT_vpl VALUES ("T13_14","084_3_14","1TI","3","14","14","ታኒ ሃ ኪታ ኔው ፃፋሼ፥ ኤሌሳዳ ኔኮ ባና ጋዳ ኡፋይሲ ዎꬃይስ። ");
INSERT INTO gofENT_vpl VALUES ("T13_15","084_3_15","1TI","3","15","15","ሺን ታኒ ቦና ጋምዒኮ፥ ፆሳ ኬꬃን ኣሳይ ዋኒዲ ዳናው ቤሲያኮ ኤራና ሜላ ሃይሳ ኔው ፃፋይስ። ዴዖ ፆሳ ኬꬃይ ቱማቴꬃስ ቱሲኔ ባሶ። ");
INSERT INTO gofENT_vpl VALUES ("T13_16","084_3_16","1TI","3","16","16","ኑ ኣማኑዋ ፁራይ ሲꬌይ ባይና ጊታ። ኪሪስቶሲ ኣሾ ማዒዲ ቆንጪስ፤ ኢያ ቱማቴꬃ ጌሻ ኣያናይ ማርካቲስ። ኪታንቾታስ ቤንቲስ፤ ኢ ካዎቴꬃ ኡባስ ሳባኬቲስ። ኣላሜን ዴዒያ ኣሳን ኣማኔቲስ፤ ቦንቾን ሳሎ ኤኬቲስ። ");
INSERT INTO gofENT_vpl VALUES ("T14_1","084_4_1","1TI","4","1","1","ያና ዎዲያን ባሌꬂያ ኣያናታኔ ቱና ኣያናታ ቲሚርቲያ ካሊዲ፥ ኢሲ ኢሲ ኣሳይ ኣማኑዋ ካዳናይሳ ጌሻ ኣያናይ ቆንጪሲዲ ኦዲስ። ");
INSERT INTO gofENT_vpl VALUES ("T14_2","084_4_2","1TI","4","2","2","ሄሳ ሜላ ቲሚርቴይ ኤንታ ካሃይ ዶጪን፥ ኣሳ ባሌꬂያ ዎርዳንቾ ኣስታማሬታፔ ዬስ። ");
INSERT INTO gofENT_vpl VALUES ("T14_3","084_4_3","1TI","4","3","3","ሄሳ ሜላ ኣሳቲ ኤኮኔ ጌሎ ቃሲ ኢሲ ኢሲ ካꬃታ ሞና ሜላ ዲጎሶና። ሺን ኣማኔይሳቲኔ ቱማ ኤሬይሳቲ ፆሳ ጋላቲ ዎሲዲ ማና ሜላ ፆሳይ ካꬂ ሜꬊስ። ");
INSERT INTO gofENT_vpl VALUES ("T14_4","084_4_4","1TI","4","4","4","ፆሳይ ሜꬊዳ ኡባባይ ሎዖ። ፆሳ ጋላቲዲ ሚኮ ዎራ ዎꬊያባይ ኣይቢካ ባዋ። ");
INSERT INTO gofENT_vpl VALUES ("T14_5","084_4_5","1TI","4","5","5","ኡባባይ ፆሳ ቃላኒኔ ዎሳን ጌሺ ጊዴስ። ");
INSERT INTO gofENT_vpl VALUES ("T14_6","084_4_6","1TI","4","6","6","ሄሳ ጊሾ፥ ኔኒ ሃ ቲሚርቲያ ኣማኔይሳታ ታማርሲኮ፥ ኑ ኣማኑዋኒኔ ሎዖ ቲሚርቲያ ኪቴታዳ ዲጪዳ ኪሪስቶስ ዬሱሳ ሎዖ ኣይሌ ጊዳና። ");
INSERT INTO gofENT_vpl VALUES ("T14_7","084_4_7","1TI","4","7","7","ሺን ጎዒ ባይና ቱማ ጊዶና ኦዳፔኔ ጪማ ማጫሳ ሃይሲያፔ ባቃታ። ቱማ ኣያና ዴዖን ዳናው ኔና ሎሂሳ። ");
INSERT INTO gofENT_vpl VALUES ("T14_8","084_4_8","1TI","4","8","8","ኣሲ ባ ኣሳቴꬃ ሚንꬃናው ኦꬂያ ኦሶይ ጉꬂ ማዴስ። ሺን ቱማ ኣያና ዴዖን ባና ሎሂሶይ ሃዒካ ሜሪናዉካ ዴዖ ኢሚያ ኡፋይሲ ዴዒያ ጊሾ ኡባስ ማዴስ። ");
INSERT INTO gofENT_vpl VALUES ("T14_9","084_4_9","1TI","4","9","9","ሃ ቃላይ ኣሳ ኡባይ ኤካናው ቤሲያ ቱማ ኦዳ። ");
INSERT INTO gofENT_vpl VALUES ("T14_10","084_4_10","1TI","4","10","10","ኑኒ ኣሳ ኡባ፥ ኡባፌ ኣꬂዲ ኣማኔይሳታ ኣሺያ ዴዖ ፆሳፌ ኤካና ጊዲ ኡፋይሳን ናጊያ ጊሾ፥ ሄሳስ ኑኒ ኦሶን ዳቡሮሲኔ ባፄቶስ። ");
INSERT INTO gofENT_vpl VALUES ("T14_11","084_4_11","1TI","4","11","11","ሃይሳ ኪታኔ ታማርሳ። ");
INSERT INTO gofENT_vpl VALUES ("T14_12","084_4_12","1TI","4","12","12","ኔኒ ያላጋ ጊዲያ ጊሾ ኔና ኦኒካ ካꬎፖ። ሺን ኣማኔይሳታስ ኔኒ ኦዳን፥ ኦሶን፥ ሲቆን፥ ኣማኖኒኔ ጌሻቴꬃን ሌሚሶ ጊዳ። ");
INSERT INTO gofENT_vpl VALUES ("T14_13","084_4_13","1TI","4","13","13","ታኒ ያና ጋካናው ኣሳስ ጌሻ ማፃፋ ናባቦን፥ ሳባኮኒኔ ታማርሶን ሚና። ");
INSERT INTO gofENT_vpl VALUES ("T14_14","084_4_14","1TI","4","14","14","ቲንቢቴይ ኦዴቲን፥ ጪማቲ ባንታ ኩሺያ ኔ ቦላ ዎꬂዳ ዎዴ ኔኒ ኤኪዳ፥ ኔናን ዴዒያ ጌሻ ኣያና ኢሞታ ካꬎፓ። ");
INSERT INTO gofENT_vpl VALUES ("T14_15","084_4_15","1TI","4","15","15","ኔ ዲቻይ ኣሳ ኡባስ ቆንጫና ሜላ ሄሳ ሚንꬃ ቆፓ፤ ሃይሳ ኡባ ዎዴ ኦꬃ። ");
INSERT INTO gofENT_vpl VALUES ("T14_16","084_4_16","1TI","4","16","16","ኔ ሁዒያሲኔ ኔ ቲሚርቲያስ ናጌታ። ኔኒ ሄሳ ኡባ ዎዴ ኦꬂኮ ኔናኔ ኔና ሲዔይሳታ ኣሻሳ። ");
INSERT INTO gofENT_vpl VALUES ("T15_1","084_5_1","1TI","5","1","1","ጪማ ኣዴታ ኔ ኣዋዳ ቦንቻፌ ኣቲን ሃንቄቶፋ። ያላጋ ኣዴታ ኔ ኢሻዳ ኦꬃዳ ፄላ። ");
INSERT INTO gofENT_vpl VALUES ("T15_2","084_5_2","1TI","5","2","2","ጪማ ማጫሳታ ኔ ኣዪዳ፥ ያላጋ ማጫሳታ ኔ ሚቺዳ፥ ፖሎ ጌሻቴꬃን ኦይካ። ");
INSERT INTO gofENT_vpl VALUES ("T15_3","084_5_3","1TI","5","3","3","ኣዚኒ ሃይቂዳ ቱማ ኣምዔታ ቦንቻ። ");
INSERT INTO gofENT_vpl VALUES ("T15_4","084_5_4","1TI","5","4","4","ሺን ኣምዔስ ናይቲ ዎይኮ ናይታ ናይቲ ዴዒኮ፥ ሄ ናይቲ ቱማ ኣያና ዴዖን ዴዔይሳ ቤሳናው ባንታና ዬሊዳይሳታኔ፥ ባንታ ዎጋ ኣዪዉኔ ዎጋ ኣዋ ማዲዲ ኩሼ ዛሮ ታማሮ። ሄሲ ፆሳ ኡፋይሲያባ። ");
INSERT INTO gofENT_vpl VALUES ("T15_5","084_5_5","1TI","5","5","5","ባርካ ዴዒያ ቱማ ኣምዒያ ፆሳፌ ማዴ ዴማናው ኡፋይሳን ናጋሱ። ጋላሲኔ ቃማ ፆሳይ ባና ማዳና ሜላ ዎሳዉሱኔ ኦይቻዉሱ። ");
INSERT INTO gofENT_vpl VALUES ("T15_6","084_5_6","1TI","5","6","6","ሺን ሃ ኣላሚያን ሎዖ ዱሳ ፃላላ ኮያ ኣምዒያ ፓፃ ዴዓሼ ሃይቂዳሮ። ");
INSERT INTO gofENT_vpl VALUES ("T15_7","084_5_7","1TI","5","7","7","ኦኒካ ኤንታ ቦሮና ሜላ ሃ ኪታ ኤንታው ኢማ። ");
INSERT INTO gofENT_vpl VALUES ("T15_8","084_5_8","1TI","5","8","8","ሺን ባ ዳቦታስ፥ ኡባፌ ኣꬂዲ ባ ሶ ኣሳስ ቆፖና ኦኒካ ባ ኣማኑዋ ካዲዳይሳ፤ ኣማኖና ኣሳፔካ ኣꬊዳ ኢታ። ");
INSERT INTO gofENT_vpl VALUES ("T15_9","084_5_9","1TI","5","9","9","ላይꬂ ኡሱፑን ታሙ ኩሚቦና ኣምዔ ሱንꬃ ማዝጋባን ፃፎፓ። ቃሲ ሄሳ ቦላ ኢያ ባ ኣዚናስ ኣማኔቲዳሮ ጊዳናው ኮሼስ። ");
INSERT INTO gofENT_vpl VALUES ("T15_10","084_5_10","1TI","5","10","10","ናይታ ዲሾን፥ ኢማꬄ ሞኮን፥ ጌሻታ ቶሁዋ ሜቻን፥ ሜቶቲያ ኣሳ ማዴን፥ ሎዖ ኦሶ ኡባስ ባና ኣꬃ ኢሚዳሮኔ ሎዖ ኦሶን ኤሬቲዳሮ ጊዳናው ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("T15_11","084_5_11","1TI","5","11","11","ሺን ያላጋ ኣምዔታ ሱንꬃ ማዝጋባን ፃፎፓ። ኤንታና ኣዚና ጌሎ ጌሎ ጊያ ኣሾ ኣሞይ ኦይኪያ ዎዴ ኪሪስቶሳ ኣጋና። ");
INSERT INTO gofENT_vpl VALUES ("T15_12","084_5_12","1TI","5","12","12","ኤንቲ ኮይሮ ጌሊዳ ቃላ ሜንꬂዳ ጊሾ ፒርዴታና። ");
INSERT INTO gofENT_vpl VALUES ("T15_13","084_5_13","1TI","5","13","13","ሄሳ ቦላ ኤንቲ ኦሶ ꬋዪዲ ኬꬃፌ ኬꬄ ዩያና። ዩሻ ፃላላ ጊዶናሺን ዚጊርሳኒኔ ባንታና ጋꬆናባን ጌሊዲ ቤሶናባ ኦዴቶሶና። ");
INSERT INTO gofENT_vpl VALUES ("T15_14","084_5_14","1TI","5","14","14","ሄሳ ጊሾ፥ ኑ ሞርኬቲ ኑ ቦላ ኦዴቲያ ኢታባ ዴሞና ሜላ ያላጋ ኣምዔቲ ኣዚና ጌሊዲ፥ ናዓ ዬሊዲ፥ ባንታ ኬꬃ ኣይሳና ሜላ ዞራይስ። ");
INSERT INTO gofENT_vpl VALUES ("T15_15","084_5_15","1TI","5","15","15","ሃይሳፌ ካሴ ጉꬃ ኣምዔቲ ፃላሄ ካላናው ጉዬ ሲሚዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("T15_16","084_5_16","1TI","5","16","16","ኢሲ ኣማኒያ ማጫሴስ ሶ ኣሳ ጊዶን ኣምዔቲ ዴዒኮ ኢያ ኤንታ ማዳናው ቤሴስ። ሄሳዳ ኦꬂኮ፥ ዎሳ ኬꬃስ ቶሆይ ካዉዬስ። ሄ ዎዴ ዎሳ ኬꬃይ ማዴ ቤሲያ ቱማ ኣምዔታ ማዳናው ዳንዳዔስ። ");
INSERT INTO gofENT_vpl VALUES ("T15_17","084_5_17","1TI","5","17","17","ዎሳ ኬꬂ ሎይꬂ ሄሚያ ጪማቲ፥ ኡባፌ ኣꬂዲ፥ ቃላ ሳባኮኒኔ ታማርሶን ዳቡሬይሳቲ ዳኮ ቦንቾ ኤካናው ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("T15_18","084_5_18","1TI","5","18","18","ጌሻ ማፃፋይ፥ «ዉዱማን ካꬃ ዬꬊያ ቦራ ዶና ቃቾፋ» ሄሳዳካ፥ «ኦሳንቾይ ባ ዳሞዚያ ኤካናው ቤሴስ» ያጌስ። ");
INSERT INTO gofENT_vpl VALUES ("T15_19","084_5_19","1TI","5","19","19","ናምዑ ዎይኮ ሄꬑ ማርኪ ባይና፥ ዎሳ ኬꬃ ጪማ ሞቲያባ ሲዖፓ። ");
INSERT INTO gofENT_vpl VALUES ("T15_20","084_5_20","1TI","5","20","20","ሃራቲ ያያና ሜላ ናጋራ ኦꬂያ ኦናካ ኣሳ ኡባ ሲንꬃን ሃንቄታ። ");
INSERT INTO gofENT_vpl VALUES ("T15_21","084_5_21","1TI","5","21","21","ኔኒ ኣሳ ሶምዖ ቤዖና፥ ኢሱዋ ኢሱዋፌ ዱማዮና ሃ ኪታ ናጋና ሜላ ፆሳ፥ ጎዳ ዬሱስ ኪሪስቶሳኔ ዶሬቲዳ ኪታንቾታ ሲንꬃን ታ ኔና ዞራይስ። ");
INSERT INTO gofENT_vpl VALUES ("T15_22","084_5_22","1TI","5","22","22","ኦዴ ቦላካ ኔ ኩሺያ ዎꬃዳ ሹማናው ኤሌሶፓ። ሃራታ ናጋራን ጌሎፓ፤ ኔና ጌሻቴꬃን ናጋ። ");
INSERT INTO gofENT_vpl VALUES ("T15_23","084_5_23","1TI","5","23","23","ኔኒ ኡባ ዎዴ ሃርጌቲያ ጊሾኔ ኔ ኡሎ ሃርጊያ ጊሾ ሃꬃ ፃላላ ኡዮፓ፤ ጉꬃ ዎይኔ ኡያ። ");
INSERT INTO gofENT_vpl VALUES ("T15_24","084_5_24","1TI","5","24","24","ኢሲ ኢሲ ኣሳታ ናጋራይ ቆንጬ፤ ኤንታ ናጋራይ ኤንታ ፒርዳናው ኤንታፌ ሲንꬄ ኣꬌስ፥ ሺን ሃራታ ናጋራይ ጉዬፔ ጋምዒዲ ቆንጬስ። ");
INSERT INTO gofENT_vpl VALUES ("T15_25","084_5_25","1TI","5","25","25","ሄሳዳ፥ ሎዖ ኦሶይካ ቆንጬ፤ ቆንጮና ኢፂኮካ ጌማናው ዳንዳዔና። ");
INSERT INTO gofENT_vpl VALUES ("T16_1","084_6_1","1TI","6","1","1","ፆሳ ሱንꬃይኔ ኑ ቲሚርቴይ ጫዬቶና ሜላ ኣይሌቴꬃን ዴዔይሳቲ ባንታና ሃሪያ ጎዳታ ቦንቾ። ");
INSERT INTO gofENT_vpl VALUES ("T16_2","084_6_2","1TI","6","2","2","ኣማኒያ ጎዳቲ ዴዒያ ኣይሌቲ፥ ኤንታ ጎዳቲ ኤንታው ኢሻ ጊዲያ ጊሾ ኤንታ ካꬎፖ። ኤንታ ኦሱዋን ማዴቲያ ጎዳቲ፥ ኣማኔይሳታኔ ዶሴቲዳይሳታ ጊዲያ ጊሾ ኤንቲ ካሴይሳፌ ኣꬂዲ ኦꬃናው ቤሴስ። ኔኒ ሃይሳ ታማርሳናዉኔ ኤንቲ ኦꬃና ሜላ ዞራናው ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("T16_3","084_6_3","1TI","6","3","3","ኦኒካ ዱማ ቲሚርቲያ ታማርሲያባ ጊዲኮ፥ ኑ ጎዳ ዬሱስ ኪሪስቶሳ ቱማ ቃላራኔ ኑ ኣማኑዋ ቲሚርቲያራ ጋሄቴና። ");
INSERT INTO gofENT_vpl VALUES ("T16_4","084_6_4","1TI","6","4","4","ሄ ኡራይ ኦቶሮን ሱጌቴሲፔ ኣቲን ኣይኮካ ኤሬና። ኤንታው ኢሲ ቆፋ ቦላ ፓላማናዉኔ ኦዬታናው ኢታ ኣሞይ ዴዔስ። ሄሲ ቃናቴ፥ ኦሺ፥ ጫሼ፥ ኢታ ሲꬌኔ፥ ");
INSERT INTO gofENT_vpl VALUES ("T16_5","084_6_5","1TI","6","5","5","ጊጎና ፓላማ ካሌꬄስ። ቃሲ ኤንታው ኢታ ዎዛኒ ዴዔስ፤ ቱማካ ባሊዶሶና፤ ኤንቲ ፆሳ ኣማኖይ ዱሬቴꬃስ ኦጌ ጊዲ ቆፖሶና። ");
INSERT INTO gofENT_vpl VALUES ("T16_6","084_6_6","1TI","6","6","6","ሺን ታው ዴዒያባይ ጊዳና ጊያ ኣሳስ ቱማ ኣያና ዴዖይ ጊታ ዎꬌ። ");
INSERT INTO gofENT_vpl VALUES ("T16_7","084_6_7","1TI","6","7","7","ኑኒ ሃ ኣላሚያ ኣይኮካ ኤሂቦኮ፤ ቃሲ ኢያፔ ኣይኮካ ኤኪዲ ቦኮ። ");
INSERT INTO gofENT_vpl VALUES ("T16_8","084_6_8","1TI","6","8","8","ኑስ ካꬂኔ ማዖይ ዴዒኮ ሄሲ ጊዳና። ");
INSERT INTO gofENT_vpl VALUES ("T16_9","084_6_9","1TI","6","9","9","ሺን ዱሬቴꬂ ኮዬይሳቲ ፓጬኒኔ ፂሄን ጌሎሶና። ቃሲ ኤንታና ዱጌ ዳፊያኔ ꬋይሲያ ኤያቴꬂኔ ቆሂያ ኣሞን ኩንዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("T16_10","084_6_10","1TI","6","10","10","ሚሼ ሲቆይ ኢታቴꬃ ኡባስ ፑልቶ። ኢሶቲ ኢሶቲ ሚሼ ኣሞቲሼ ኣማኖፔ ባሌቲዲ ዳሮ ሜቶን ባንታና ዬጊዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("T16_11","084_6_11","1TI","6","11","11","ሺን ኔኖ፥ ፆሳ ኣሶ፥ ሄሳፌ ባቃታ። ፂሎቴꬃ፥ ፆሳ ዳኖ፥ ኣማኖ፥ ሲቆ፥ ዳንዳዓኔ ኣሽኬቴꬂ ካላ። ");
INSERT INTO gofENT_vpl VALUES ("T16_12","084_6_12","1TI","6","12","12","ኣማኖ ባፂያ ሎይꬃ ባፄታ። ዳሮ ኣሳ ሲንꬃን ኔ ማርካቲዳ ኔ ኣማኑዋባ፥ ፆሳይ ኔና ኢያው ፄጊዳ ሜሪና ዴዑዋ ኦይካ። ");
INSERT INTO gofENT_vpl VALUES ("T16_13","084_6_13","1TI","6","13","13","ኡባስ ዴዖ ኢሚያ ፆሳ ሲንꬃኒኔ፥ ጴንፄ ጲላፆሳ ሲንꬃን ሎዖ ማርካ ማርካቲዳ ኪሪስቶስ ዬሱሳ ሲንꬃን ታ ኔና ኪታይስ። ");
INSERT INTO gofENT_vpl VALUES ("T16_14","084_6_14","1TI","6","14","14","ኑ ጎዳ ዬሱስ ኪሪስቶሲ ቆንጫና ጋካናው ሃ ኪታ ባሊኔ ቦሬይ ባይና ናጋ። ");
INSERT INTO gofENT_vpl VALUES ("T16_15","084_6_15","1TI","6","15","15","ባ ፃላላ ኡባ ሃሪያ ቦንቾ ፆሳይ፥ ካዎታ ካዎይ፥ ጎዳታ ጎዳይ፥ ባ ቆፒዳ ቃማን ዬሱስ ኪሪስቶሳ ዛሪ ኪታና። ");
INSERT INTO gofENT_vpl VALUES ("T16_16","084_6_16","1TI","6","16","16","ኢሲ ኢያ ፃላሊ ሃይቄና። ኦኒካ ሺቃናው ዳንዳዖና ፖዖን ዴዔስ። ኦኒካ ኢያ ቤዒቤና፤ ቃሲ ቤዓናዉካ ዳንዳዔና። ቦንቾይኔ ሜሪና ዎልቃይ ኢያው ጊዶ። ኣሚንዒ። ");
INSERT INTO gofENT_vpl VALUES ("T16_17","084_6_17","1TI","6","17","17","ሃ ኣላሚያ ዱሬቲ ጮ ꬋያ ሻሎን ኦቶርቶና ሜላኔ ጬቆና ሜላ ኦዳ። ኑስ ኮሺያባ ፓላሂሲዲ ኢሚያ ኑና ኣንጂያ፥ ዱሬ ፆሳን ኣማኔታና ሜላ ኤንታ ኪታ። ");
INSERT INTO gofENT_vpl VALUES ("T16_18","084_6_18","1TI","6","18","18","ኤንቲ ሎዖ ኦሶ ኦꬃናዳ ሎዖ ኦሶን ዱሬታናዳ፥ ኬሃታኔ ሃራታስ ሻኬይሳታ ጊዳና ሜላ ኪታ። ");
INSERT INTO gofENT_vpl VALUES ("T16_19","084_6_19","1TI","6","19","19","ሄሲ ኤንታው ሲንꬃስ ሚኖ ባሶ ጊዲያ ጊሾ ሄ ዎዴ ኤንቲ ቱማ ዴዖይ ኣይ ዳኒያኮ ኤራና። ");
INSERT INTO gofENT_vpl VALUES ("T16_20","084_6_20","1TI","6","20","20","ፂሞቲዮሳ፥ ኢሲ ኢሲ ኣሳይ፥ «ኤራቴꬂ» ጊያ ኤያ ፓላማፔኔ ሃዳ ኦዳፔ ባቃታ፤ ኔው ኢሜቲዳ ሃዳራ ናጋ። ");
INSERT INTO gofENT_vpl VALUES ("T16_21","084_6_21","1TI","6","21","21","ኢሶቲ ኢሶቲ ኑስ ኤራቴꬂ ዴዔስ ያጊሼ ኣማኑዋ ኣጊዶሶና። ፆሳ ኣꬎ ኬሃቴꬃይ ሂንቴ ኡባራ ጊዶ። ");
INSERT INTO gofENT_vpl VALUES ("T21_1","085_1_1","2TI","1","1","1","ፆሳ ሼኔን፥ ዬሱስ ኪሪስቶሳን ቤንቲዳ ዴዖ ኡፋይሳ ማርካታናው ዬሱስ ኪሪስቶሳ ሃዋሬ ጊዲዳ ጳዉሎሳፔ፥ ");
INSERT INTO gofENT_vpl VALUES ("T21_2","085_1_2","2TI","1","2","2","ታ ዶሲያ ናዓ ፂሞቲዮሳስ ኪቴቲዳ ኪታ። ፆሳ ኣዋፔኔ ኑ ጎዳ ኪሪስቶስ ዬሱሳፔ ኣꬎ ኬሃቴꬃይ፥ ማሮቴꬃይኔ ሳሮቴꬃይ ኔው ጊዶ። ");
INSERT INTO gofENT_vpl VALUES ("T21_3","085_1_3","2TI","1","3","3","ታኒ፥ ታ ዎሳን ቃማኔ ጋላስ ኔና ቆፓይስ። ታኒ ዎሲያ ዎዴ ታ ማይዛታ ፆሳኔ ታኒ ሎዖ ካሃን ሃጋዚያ ፆሳ ኔ ጊሾ ጋላታይስ። ");
INSERT INTO gofENT_vpl VALUES ("T21_4","085_1_4","2TI","1","4","4","ታኒ ኔ ኣፉꬃ ቆፓይስ፤ ኔና ቤዓዳ ኡፋይታናው ዳሮ ላሞታይስ። ");
INSERT INTO gofENT_vpl VALUES ("T21_5","085_1_5","2TI","1","5","5","ቃሲ ኔው ዴዒያ ቱማ ኣማኑዋ ኤራይስ። ሄ ኣማኖይ ቤኒ ኔ ዎጋ ኣዬ ሎይዲኒኔ ኔ ኣዬ ኤዉኒቂን ዴዒያ ኣማኑዋ ሜላ። ");
INSERT INTO gofENT_vpl VALUES ("T21_6","085_1_6","2TI","1","6","6","ሄሳ ጊሾ፥ ታኒ ታ ኩሺያ ኔ ቦላ ዎꬂዳ ዎዴ ፆሳይ ኔው ኢሚዳ ኢሞታ ኔኒ ዛራ ኤꬃና ሜላ ኣኬኪሳይስ። ");
INSERT INTO gofENT_vpl VALUES ("T21_7","085_1_7","2TI","1","7","7","ኣይስ ጊኮ፥ ፆሳይ ኑስ ዎልቃ፥ ሲቆኔ ኑ ሁዔ ሃሪያ ኣያና ኢሚስፔ ኣቲን ያሻ ኣያና ኢሚቤና። ");
INSERT INTO gofENT_vpl VALUES ("T21_8","085_1_8","2TI","1","8","8","ሂዛ፥ ኑ ጎዳስ ማርካታናው ዬላቶፓ፤ ቃሲ ኢያ ጊሾ ቃሼቲዳ ታናንካ ዬላቶፓ። ሺን ፆሳይ ኔው ኢሚያ ዎልቃን ዎንጌላ ጊሾ ታራ ሜቶ ኤካ። ");
INSERT INTO gofENT_vpl VALUES ("T21_9","085_1_9","2TI","1","9","9","ፆሳይ ባ ሼኔኒኔ ባ ኣꬎ ኬሃቴꬃን ኑና ኣሺዲ፥ ባ ጌሻ ዴሬ ኦꬃናው ኑና ዶሪስፔ ኣቲን ኑኒ ኦꬂዳ ኦሱዋ ጊሾ ጊዴና። ሃ ኣꬎ ኬሃቴꬃ ኪሪስቶስ ዬሱሳ ባጋራ ኣላሜይ ሜꬌታናፔ ሲንꬄ ኑስ ኢሚስ። ");
INSERT INTO gofENT_vpl VALUES ("T21_10","085_1_10","2TI","1","10","10","ሃዒ ሃ ኣꬎ ኬሃቴꬃይ ኑና ኣሺያ ኪሪስቶስ ዬሱሳ ዩሳን ቆንጪስ። ኢ ሃይቆ ዎልቃ ꬋይሲዲ፥ ዎንጌላ ባጋራ ꬋዮና ዴዖ ኑስ ቆንጪሲስ። ");
INSERT INTO gofENT_vpl VALUES ("T21_11","085_1_11","2TI","1","11","11","ታኒ ዎንጌላ ሳባኬ፥ ሃዋሬኔ ኣስታማሬ ጊዳና ሜላ ፆሳይ ታና ዶሪስ። ");
INSERT INTO gofENT_vpl VALUES ("T21_12","085_1_12","2TI","1","12","12","ታኒ ሄሳ ጊሾ ሃ ሜቱዋ ኤካይስ፤ ሺን ታ ኣማኔይ ኦኔኮ ኤሪያ ጊሾ ዬላቲኬ። ታው ኢሜቲዳ ሃዳራ ሄ ጋላሳይ ጋካናው ኢ ናጋናው ዳንዳዔይሳ ኤራይስ። ");
INSERT INTO gofENT_vpl VALUES ("T21_13","085_1_13","2TI","1","13","13","ታኒ ኔና ታማርሲዳ ቱማ ቃላ ሌሚሶ ኦꬃ ኦይካዳ ኪሪስቶስ ዬሱሳ ባጋራ ኑባ ጊዲዳ ኣማኑዋኒኔ ሲቁዋን ዴዓ። ");
INSERT INTO gofENT_vpl VALUES ("T21_14","085_1_14","2TI","1","14","14","ኑ ጊዶን ዴዒያ ጌሻ ኣያና ዎልቃን ኔው ኢሜቲዳ ሎዖ ሃዳራ ናጋ። ");
INSERT INTO gofENT_vpl VALUES ("T21_15","085_1_15","2TI","1","15","15","ኢሲያ ቢታን ዴዒያ ኡባይ ታፔ ሃኪዳይሳ ኤራሳ፤ ኤንታ ጊዶን ፊጌሉሲኔ ሄርሞጌኔሲ ዴዖሶና። ");
INSERT INTO gofENT_vpl VALUES ("T21_16","085_1_16","2TI","1","16","16","ኣኔስፎሪ ታና ዳሮ ዎዴ ሚንꬄꬂዳ ጊሾ ጎዳይ ኢያ ሶ ኣሳስ ቃꬌቶ። ታኒ ቃሾ ኬꬃን ዴዒያ ዎዴ ኢ ታናን ዬላቲቤና። ");
INSERT INTO gofENT_vpl VALUES ("T21_17","085_1_17","2TI","1","17","17","ሄሳ ቦላ ኢ ሮሜ ካታማ ዪዳ ዎዴ ታና ሚንꬂ ኮዪዲ ዴሚስ። ");
INSERT INTO gofENT_vpl VALUES ("T21_18","085_1_18","2TI","1","18","18","ዉርሴꬃ ጋላሳን ጎዳይ ኢያው ቃꬌታና ሜላ ታኒ ጎዳ ዎሳይስ። ኤፌሶና ካታማን ኢ ታና ኣይ ሜላ ማዲዳኮ ኔ ሎይꬃ ኤራሳ። ");
INSERT INTO gofENT_vpl VALUES ("T22_1","085_2_1","2TI","2","1","1","ሂዛ፥ ታ ናዓው፥ ኪሪስቶስ ዬሱሳን ዴዒያ ማሮቴꬃን ሚና። ");
INSERT INTO gofENT_vpl VALUES ("T22_2","085_2_2","2TI","2","2","2","ዳሮ ማርካታ ሲንꬃን ታኒ ኔና ታማርሲዳ ቲሚርቲያ፥ ሃራታ ታማርሳናው ዳንዳዒያ ኣማኔቲዳ ኣሳስ ሃዳራ ኢማ። ");
INSERT INTO gofENT_vpl VALUES ("T22_3","085_2_3","2TI","2","3","3","ዬሱስ ኪሪስቶሳስ ኣማንꬂያ ዎታዳሬ ጊዳዳ ታራ ሜቶ ኤካ። ");
INSERT INTO gofENT_vpl VALUES ("T22_4","085_2_4","2TI","2","4","4","ኦላ ዎታዳሬይ ባ ሃላቃ ኡፋይሳናው ጊጌቴሲፔ ኣቲን ሃራ ኦሶን ባና ፔሼና። ");
INSERT INTO gofENT_vpl VALUES ("T22_5","085_2_5","2TI","2","5","5","ሄሳዳካ፥ ጋዴ ዎፂያ ኦኒካ ቤሲያ ኦጌራ ጋዴቶና ኢፂኮ ዎይቶ ኤኬና። ");
INSERT INTO gofENT_vpl VALUES ("T22_6","085_2_6","2TI","2","6","6","ጎሻን ዳቡሪያ ጎሻንቾይ ባ ዳቡራ ኣይፊያፔ ሚያ ኮይሮ ኣሲ ጊዳናው ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("T22_7","085_2_7","2TI","2","7","7","ኔ ኣኬካና ሜላ ጎዳይ ኔና ማዳና ጊሾ ታ ኔው ኦዲዳባ ኔ ዎዛናን ናጋ። ");
INSERT INTO gofENT_vpl VALUES ("T22_8","085_2_8","2TI","2","8","8","ታኒ ማርካቲያ ዎንጌላ ሜላ ሃይቆፔ ዴንዲዳ፥ ዳዊቴ ዜሬꬂ ጊዲዳ ዬሱስ ኪሪስቶሳ ቆፓ። ");
INSERT INTO gofENT_vpl VALUES ("T22_9","085_2_9","2TI","2","9","9","ታኒ ዎንጌላ ኦዲያ ጊሾ ኢታባ ኦꬂዳ ኣሳዳ፥ ቃሼታዳ ሜቶ ኤካስ። ሺን ፆሳ ቃላይ ቃሼቴና። ");
INSERT INTO gofENT_vpl VALUES ("T22_10","085_2_10","2TI","2","10","10","ሄሳ ጊሾ፥ ፆሳይ ዶሪዳ ኣሳቲ ኪሪስቶስ ዬሱሳን ዴዒያ ኣቶቴꬃ ሜሪና ቦንቹዋራ ኤካና ሜላ ኤንታ ጊሾ ኡባባን ዋዬታይስ። ");
INSERT INTO gofENT_vpl VALUES ("T22_11","085_2_11","2TI","2","11","11","ሃይሳዳ ያጊያ ቱማ ቃሊ ዴዔስ፤ «ኑኒ ኢያራ ሃይቂዳባ ጊዲኮ፥ ኢያራ ኢሲፌ ዴዓና። ");
INSERT INTO gofENT_vpl VALUES ("T22_12","085_2_12","2TI","2","12","12","ኑኒ ጌንጪኮ፥ ኢያራ ኢሲፌ ካዎታና። ኑኒ ኢያ ካዲኮ፥ ኢ ኑና ካዳና። ");
INSERT INTO gofENT_vpl VALUES ("T22_13","085_2_13","2TI","2","13","13","ኑኒ ኣማኔቶና ኢፂኮ፥ ኢ ኣማኔቲዳይሳ ጊዲዲ ዳና። ኣይስ ጊኮ፥ ኢ ባና ካዳናው ዳንዳዔና» ያጌስ። ");
INSERT INTO gofENT_vpl VALUES ("T22_14","085_2_14","2TI","2","14","14","ኔኒ ኤንታ ሃይሳ ኣኬኪሳ፤ ኤንቲ ቃላታ ጋሶን ፓላሞና ሜላ፥ ጎዳ ሲንꬃን ኤንታ ዞራ። ሄሲ ሲዔይሳታ ꬋይሴሲፔ ኣቲን ኣይኮካ ማዴና። ");
INSERT INTO gofENT_vpl VALUES ("T22_15","085_2_15","2TI","2","15","15","ኔኒ ቱማ ቃላ ሱሬቴꬃን ታማርሴይሳኔ ዬላዮና ኦሳንቾ ጊዳዳ፥ ፆሳይ ናሺያ ኣሳዳ፥ ኔናቴꬃ ኢያው ኢማናው ሚና። ");
INSERT INTO gofENT_vpl VALUES ("T22_16","085_2_16","2TI","2","16","16","ሺን ሃ ኣላሚያስ ኢንጄቲያ ጎዖና ኦዳፔ ባቃታ። ሄሳ ሜላ ኦዳይ ኣሴ ፆሳፌ ሃሴስ። ");
INSERT INTO gofENT_vpl VALUES ("T22_17","085_2_17","2TI","2","17","17","ሄሳ ሜላ ኦዳይ ኣሳቴꬂ ሚዲጊያ ፓፆና ዎይዛዚሬ ማዱንꬃ ሜላ። ሄሳ ሜላ ኦዳ ኦዴቴይሳታ ጊዶፌ ሄሜኔዮሲኔ ፊሊፆሲ ዴዖሶና። ");
INSERT INTO gofENT_vpl VALUES ("T22_18","085_2_18","2TI","2","18","18","ሃ ኣሳቲ ቱማ ኦጊያ ኣጊዲ፥ «ሃይቂዳ ኣሳይ ሃይቆፔ ቤኒ ዴንዲዶሶና» ያጊዲ ጉꬃ ኣሳታ ኣማኑዋ ꬋይሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("T22_19","085_2_19","2TI","2","19","19","ጊዶሺን፥ ፆሳይ ሚኖ ዛላ ሂፂዳ ጊሾ ቃፃናው ዳንዳዔና። ኢያ ቦላ፥ «ጎዳይ ባይሳታ ኤሬስ። ጎዳ ሱንꬃ ፄጊያ ኦኒካ ኢታ ኦሶፔ ሃኮ» ያጊያ ቃላይ ፃፌቲስ። ");
INSERT INTO gofENT_vpl VALUES ("T22_20","085_2_20","2TI","2","20","20","ኢሲ ጊታ ኬꬃን ዎርቃፌ ዎይኮ ቢራፔ ኦሴቲዳ ሚሼታ ፃላላ ጊዶናሺን ሚꬃፌ ዎይኮ ኡርቃፌ ኦሴቲዳ ሚሼቲካ ዴዖሶና። ሄሳታፔ ባጋቲ ቦንቾ ኦሶስ፥ ቃሲ ባጋቲ ቶሼቲያ ኦሶስ ፔዖሶና። ");
INSERT INTO gofENT_vpl VALUES ("T22_21","085_2_21","2TI","2","21","21","ሄሳ ጊሾ፥ ኦኒካ ኢታ ኡባ ኣጊኮኔ ባና ጌሺኮ፥ ቦንቾ ኦሶ ኦꬂያ ሚሼ ጊዳና። ኤንታ ዴዖይ ጌሺኔ ጎዳ ኡፋይሲያባ፥ ቃሲ ኤንቲ ሎዖ ኦሶ ኡባ ኦꬃናው ዳንዳዔይሳታ ጊዳና። ");
INSERT INTO gofENT_vpl VALUES ("T22_22","085_2_22","2TI","2","22","22","ናዓቴꬃ ኢታ ኣሙዋፔ ባቃታ። ጌሻ ዎዛናን ጎዳ ፄጊያ ኣሳታራ ኢሲፌ፥ ፂሎቴꬃ፥ ኣማኑዋ፥ ሲቆኔ ሳሮቴꬃ ካላ። ");
INSERT INTO gofENT_vpl VALUES ("T22_23","085_2_23","2TI","2","23","23","ሺን ኦሺ ሜꬌይሳ ኤራዳ ኤያቴꬂኔ ሃዳ ጊዲዳ ፓላማፔ ሃካ። ");
INSERT INTO gofENT_vpl VALUES ("T22_24","085_2_24","2TI","2","24","24","ጎዳ ኦሳንቾይ ኣሳ ኡባስ ኬሃ፥ ሎዖ ታማርሴይሳኔ ዳንዳዓንቾ ጊዳናው ቤሴሲፔ ኣቲን ኦዬታናው ቤሴና። ");
INSERT INTO gofENT_vpl VALUES ("T22_25","085_2_25","2TI","2","25","25","ኢ ባራ ኤቄቴይሳታ ኣሽኬቴꬃን ሴሬይሳ ጊዳናው ቤሴስ። ኤንቲ ባንታ ናጋራፔ ሲሚዲ ቱማ ኤራናዳ ፆሳይ ኦꬃኔኮ ኦኒ ኤሪ። ");
INSERT INTO gofENT_vpl VALUES ("T22_26","085_2_26","2TI","2","26","26","ኤንቲ ባንታ ዎዛናኮ ሲሚዲ ባ ሼኒያ ኦꬃና ሜላ ኤንታ ኦይኪዳ ፃላሄ ፂሂያፔ ኬሲ ኤካና። ");
INSERT INTO gofENT_vpl VALUES ("T23_1","085_3_1","2TI","3","1","1","ዉርሴꬃ ጋላሳን ኡንዔꬂያ ዎዴይ ያናይሳ ኤራ። ");
INSERT INTO gofENT_vpl VALUES ("T23_2","085_3_2","2TI","3","2","2","ኣሳይ ባንታና ዶሴይሳታ፥ ሚሼ ሲቄይሳታ፥ ጬቄቴይሳታ፥ ኦቶሬይሳታ፥ ጫዬይሳታ፥ ባንታና ዬሊዳይሳታስ ኪቴቶናይስታ፥ ጋላቶናይስታ፥ ጌሻቴꬂ ባይናይሳታ፥ ");
INSERT INTO gofENT_vpl VALUES ("T23_3","085_3_3","2TI","3","3","3","ሲቆይ ባይናይሳታ፥ ማሮቴꬂ ኤሮናይሳታ፥ ዚጊሬይሳታ፥ ባንታና ሃሮናይሳታ፥ ቃꬌይ ባይናይሳታ፥ ሎዖ ዶሶናይሳታ፥ ");
INSERT INTO gofENT_vpl VALUES ("T23_4","085_3_4","2TI","3","4","4","ሞርኬስ ኣꬂ ኢሜይሳታ፥ ቆፊ ባይናይሳታ፥ ኦቶሮን ሱጌቴይሳታ፥ ፆሳፌ ኣꬂዲ ኣሾ ኡፋይሳናው ዶሴይሳታ ጊዳና። ");
INSERT INTO gofENT_vpl VALUES ("T23_5","085_3_5","2TI","3","5","5","ኤንቲ ኣማኒያ ዳኖሶናፔ ኣቲን ኣማኖ ዎልቃ ካዶሶና፤ ኔኒ ሄሳ ሜላ ኣሳታፔ ባቃታ። ");
INSERT INTO gofENT_vpl VALUES ("T23_6","085_3_6","2TI","3","6","6","ኤንታፌ ኢሶቲ ኢሶቲ ኣሳ ኬꬂ ጌሊዲ ናጋራን ኦይኬቲዳይሳታኔ ዱማ ዱማ ኣሞን ሱጌቲያ ዳቡራንቾ ማጫሳታ ቦላ ጎዳቶሶና። ");
INSERT INTO gofENT_vpl VALUES ("T23_7","085_3_7","2TI","3","7","7","ሄ ማጫሳቲ ኡባ ዎዴ ታማሮሶና፥ ሺን ቱማ ኤራናው ዳንዳዖኮና። ");
INSERT INTO gofENT_vpl VALUES ("T23_8","085_3_8","2TI","3","8","8","ያኔሲኔ ያምባሬሲ ሙሴራ ኤቄቲዳይሳዳ ሃ ኣሳቲ ጉጌይ ኦꬆናይሳታኔ ኣማኖን ኩንዲዳ ኣሳታ ጊዲያ ጊሾ ቱማራ ኤቄቶሶና። ");
INSERT INTO gofENT_vpl VALUES ("T23_9","085_3_9","2TI","3","9","9","ሺን ያኔሳኔ ያምባሬሳ ኤያቴꬃይ ቆንጪዳይሳዳ ኤንታ ኤያቴꬃይካ ኣሳ ኡባ ሲንꬃን ቆንጫና ጊሾ ኤንታው ሃኔና። ");
INSERT INTO gofENT_vpl VALUES ("T23_10","085_3_10","2TI","3","10","10","ሺን ኔኒ ታ ቲሚርቲያ፥ ታ ዱሳ፥ ታ ቆፋ፥ ታ ኣማኑዋ፥ ታ ዳንዳዓ፥ ታ ሲቁዋ፥ ታ ጌንጫ፥ ");
INSERT INTO gofENT_vpl VALUES ("T23_11","085_3_11","2TI","3","11","11","ታ ዬዴቴꬃኔ ታ ሜቱዋ ኤራሳ። ኣንፆኪያን፥ ኢቆኒዮኔን፥ ሊስፂራ ካታማታን ታና ጋኪዳባኔ ታኒ ዳንዳዒዳ ሜቱዋ ኤራሳ፤ ጎዳይ ታና ሄ ኡባፌ ኣሺስ። ");
INSERT INTO gofENT_vpl VALUES ("T23_12","085_3_12","2TI","3","12","12","ኪሪስቶስ ዬሱሳን ፆሳ ኡፋይሲያ ዴዖ ዳናው ኮያ ኡባይ ጎዴታና። ");
INSERT INTO gofENT_vpl VALUES ("T23_13","085_3_13","2TI","3","13","13","ኢታ ኣሳቲኔ ባሌꬄይሳቲ ባንታው ባሌቲሼኔ ሃራታ ባሌꬂሼ ካሴፔ ኢቲ ኢቲ ባና። ");
INSERT INTO gofENT_vpl VALUES ("T23_14","085_3_14","2TI","3","14","14","ሺን ኔ ታማሪዳ ቱማኒኔ ኔ ኣማኒዳ ኣማኑዋን ኤቃ። ኔ ኦዴፌ ታማሪዳኮ ኤራሳ። ");
INSERT INTO gofENT_vpl VALUES ("T23_15","085_3_15","2TI","3","15","15","ኔኒ ኔ ናዓቴꬃፌ ዶማዳ ኪሪስቶስ ዬሱሳ ኣማናዳ ኣቶቴꬂ ዴሚያ ጪንጫቴꬂ ኢማናው ዳንዳዒያ ጌሻ ማፃፋታ ኤራዳሳ። ");
INSERT INTO gofENT_vpl VALUES ("T23_16","085_3_16","2TI","3","16","16","ጌሻ ማፃፋ ኡባይ ፆሳፌ ኢሜቲዳ ቃላ። ሄ ማፃፋይ ቱማ ታማርሳናው፥ ባሊዳይሳታ ሴራናው፥ ሱሪሳናዉኔ ፂሎቴꬃ ዱሳስ ኮሺያ ዞሬ ኢማናው ማዴስ። ");
INSERT INTO gofENT_vpl VALUES ("T23_17","085_3_17","2TI","3","17","17","ፆሳ ኣሲ ፖሎኔ ሎዖ ኦሶ ኡባ ኦꬃናው ጊጊዳይሳ ጊዳና ሜላ ማዴስ። ");
INSERT INTO gofENT_vpl VALUES ("T24_1","085_4_1","2TI","4","1","1","ታኒ ኔና ፆሳ ሲንꬃኒኔ፥ ካዎ ጊዲዲ ሃራናው ቆንጪያ ዎዴ ፓፃታኔ ሃይቂዳይሳታ ፒርዳናው ዴዒያ ኪሪስቶስ ዬሱሳ ሲንꬃን ዞራይስ። ");
INSERT INTO gofENT_vpl VALUES ("T24_2","085_4_2","2TI","4","2","2","ቃላ ኦዳ፤ ዎዴይ ኢንጄቲን ኢንጄቶና ኢፂን ሚናዳ ኦዳ። ዳሮ ዳንዳዓኒኔ ታማርሶን ኣሳ ዞራ፥ ሴራኔ ዴንꬄꬃ። ");
INSERT INTO gofENT_vpl VALUES ("T24_3","085_4_3","2TI","4","3","3","ኣሳይ ቱማ ቲሚርቲያ ሲዖና ኢፂያ ዎዴይ ያና። ኤንቲ ባንታ ኣሙዋ ካሊዲ፥ ባንታው ሲዓናው ኡፋይሲያባ ኦዲያ ኣስታማሬታ ሺሾሶና። ");
INSERT INTO gofENT_vpl VALUES ("T24_4","085_4_4","2TI","4","4","4","ኤንቲ ቱማ ቲሚርቲያ ኣጊዲ፥ ቱማ ጊዶና ኦዳ ሲዓናው ባንታ ሃይꬃ ዛሮሶና። ");
INSERT INTO gofENT_vpl VALUES ("T24_5","085_4_5","2TI","4","5","5","ሺን ኔኒ ኡባባን ኔና ሃራ። ሜቱዋ ዳንዳዓ። ዎንጌላ ማርካቴꬃ ኦሱዋ ኦꬃ። ኔው ኢሜቲዳ ፆሳ ኦሶ ኡባ ፖላ። ");
INSERT INTO gofENT_vpl VALUES ("T24_6","085_4_6","2TI","4","6","6","ታኒ ያርሼቲያ ዎዴይ ጋኪስ፤ ሃ ኣላሚያ ኣጋዳ ቢያ ዎዴይ ማቲስ። ");
INSERT INTO gofENT_vpl VALUES ("T24_7","085_4_7","2TI","4","7","7","ታኒ ሎዖ ኦላ ኦሌታስ፤ ታ ጋዲያ ዎፃዳ ዉርሳስ፤ ኣማኑዋ ናጋስ። ");
INSERT INTO gofENT_vpl VALUES ("T24_8","085_4_8","2TI","4","8","8","ሲንꬃፌ ፂሎቴꬃ ካላቻይ ታና ናጌስ። ሄሳ ፂሎ ፒርዳ ፒርዲያ ጎዳይ ሄ ጋላስ ታው ኢማና። ሄሳ ታ ፃላላስ ጊዶናሺን ኢያ ቆንጬꬃ ኣሞቲያ ኡባስ ኢማና። ");
INSERT INTO gofENT_vpl VALUES ("T24_9","085_4_9","2TI","4","9","9","ኤሌሳ ያዳ ታና ቤዓ። ");
INSERT INTO gofENT_vpl VALUES ("T24_10","085_4_10","2TI","4","10","10","ዴማሲ ሃ ኣላሚያን ዴዒያባታ ዶሲዲ፥ ታና ኣጊዲ፥ ቴሴሎንቄ ካታማ ቢስ። ቄርቂሲ ጋላቲያ ቢታ፥ ቃሲ ቲቶይ ዲልማፂያ ቢታ ቢስ። ");
INSERT INTO gofENT_vpl VALUES ("T24_11","085_4_11","2TI","4","11","11","ሉቃሳ ፃላሊ ታራ ዴዔስ። ማርቆሲ ፆሳ ኦሶን ታና ማዳናው ዳንዳዒያ ጊሾ ኔራ ኤካዳ ያ። ");
INSERT INTO gofENT_vpl VALUES ("T24_12","085_4_12","2TI","4","12","12","ታኒ ቲኪቆሳ ኤፌሶና ካታማ ኪታስ። ");
INSERT INTO gofENT_vpl VALUES ("T24_13","085_4_13","2TI","4","13","13","ኔኒ ያሼ፥ ፂሮዓዳ ካታማን ካርፖሳ ማታን ኣጋዳ ዪዳ ታ ኮቲያኔ ማፃፋታ ታው ኤካዳ ያ። ኡባካ ጋልባን ፃፌቲዳ ማፃፋታ ኤኮና ዮፓ። ");
INSERT INTO gofENT_vpl VALUES ("T24_14","085_4_14","2TI","4","14","14","ቢራታ ቆፂያ ኢስኪንዲሬይ ታና ዳሮ ቆሂስ፤ ጎዳይ ኢያ ኦሱዋዳ ኢያው ዛራና። ");
INSERT INTO gofENT_vpl VALUES ("T24_15","085_4_15","2TI","4","15","15","ኢ ኑ ቲሚርቲያ ዳሮ ኢፂያ ጊሾ ኢያፔ ኔና ናጋ። ");
INSERT INTO gofENT_vpl VALUES ("T24_16","085_4_16","2TI","4","16","16","ኮይሮ ታ ሞቴቲያ ዎዴ ኡባይ ኣጊዲ ቢዶሶናፔ ኣቲን ኦኒካ ታና ማዲቤና። ፆሳይ ሄ ባላ ኤንታው ታይቦፖ። ");
INSERT INTO gofENT_vpl VALUES ("T24_17","085_4_17","2TI","4","17","17","ሺን ታኒ ኩሜꬃ ኪታ ኣይሁዴ ጊዶና ኣሳ ኡባስ ማርካቲን፥ ኤንቲ ሲዓና ሜላ ጎዳይ ታ ማታን ኤቂዲ ታው ዎልቃ ኢሚስ። ቃሲ ኮሻቲዳ ጋሞዳ ዶና ዶዪዳ ሃይቁዋፔ ታና ኣሺስ። ");
INSERT INTO gofENT_vpl VALUES ("T24_18","085_4_18","2TI","4","18","18","ጎዳይ ታና ኢታ ኡባፌ ኣሺዲ ባ ሳሎ ካዎቴꬃ ሳሮን ኤፋና። ኢያው ሜሪናፔ ሜሪና ጋካናው ቦንቾይ ጊዶ። ኣሚንዒ። ");
INSERT INTO gofENT_vpl VALUES ("T24_19","085_4_19","2TI","4","19","19","ጲሪስቂላስ፥ ኣቂላሲኔ ኣኔስፎራ ሶ ኣሳስ ታ ሳሮꬁዋ ኦዳ። ");
INSERT INTO gofENT_vpl VALUES ("T24_20","085_4_20","2TI","4","20","20","ኤራስፆሲ ቆሮንቶሳ ካታማን ኣቲስ። ፂሮፊሞሲ ሃርጌቲዳ ጊሾ ሚሊፄ ካታማን ኣጋስ። ");
INSERT INTO gofENT_vpl VALUES ("T24_21","085_4_21","2TI","4","21","21","ባልጎይ ጌላናፔ ሲንꬄ ኤሌሳዳ ያ። ኤዉቡሉሲ፥ ጱዴሲ፥ ሊኑሲ፥ ቂላዴይኔ ሃራ ኣማኒያ ኣሳቲ ኡባይ ኔና ሳሮ ሳሮ ጎሶና። ");
INSERT INTO gofENT_vpl VALUES ("T24_22","085_4_22","2TI","4","22","22","ጎዳይ ዬሱስ ኪሪስቶሲ ኔ ኣያናራ ጊዶ። ፆሳ ማሮቴꬃይ ሂንቴ ኡባራ ጊዶ። ");
INSERT INTO gofENT_vpl VALUES ("TT1_1","086_1_1","TIT","1","1","1","ዬሱስ ኪሪስቶሳ ሃዋሬይኔ ፆሳ ኣይሌይ፥ ጳዉሎሲ፥ ፃፊዳ ዳብዳቢያ። ፆሳይ ዶሪዳ ኣሳ ኣማኑዋ ዲቻናዳኔ ቱማ ኣያና ዴዑዋ ዋኒዲ ዳኔኮ ቤሲያ ቱማ ኤራኮ ኤንታ ካሌꬃናው ታኒ ኪቴታስ። ");
INSERT INTO gofENT_vpl VALUES ("TT1_2","086_1_2","TIT","1","2","2","ሄ ኣማኖይኔ ኤራቴꬃይ ሜሪና ዴዑዋ ኡፋይሳ ቦላ ዜምፒስ። ሄሳ ዳሮ ዎዴፔ ሲንꬄ ዎርዶቶና ፆሳይ ኑስ ኢማና ጊዲ ቃላ ጌሊስ። ");
INSERT INTO gofENT_vpl VALUES ("TT1_3","086_1_3","TIT","1","3","3","ኑና ኣሺያ ፆሳይ ባ ዎዴን ሃ ኪታ ኦዳና ሜላ ታው ሃዳራ ኢሚስ። ");
INSERT INTO gofENT_vpl VALUES ("TT1_4","086_1_4","TIT","1","4","4","ኑ ኮꬄ ኣማኑዋን ታ ቱማ ናዓ ጊዲዳ ቲቶ፥ ፆሳ ኣዋፔኔ ኑና ኣሺያ ዬሱስ ኪሪስቶሳፔ ኣꬎ ኬሃቴꬃይ፥ ማሮቴꬃይኔ ሳሮቴꬃይ ኔው ጊዶ። ");
INSERT INTO gofENT_vpl VALUES ("TT1_5","086_1_5","TIT","1","5","5","ታኒ ኔና ቃርፄሳን ኣጋዳ ዪዳይ፥ ኔኒ ኣቲዳባ ጊጊሳናዳኔ ታኒ ኪቲዳይሳዳ ካታማ ኡባን ዎሳ ኬꬃ ጪማታ ዶራና ሜላሳ። ");
INSERT INTO gofENT_vpl VALUES ("TT1_6","086_1_6","TIT","1","6","6","ጪሚ ቦሬቶናይሳ፥ ኢሲ ማቼ ኣዚና፥ ማራ ꬋዮን ዎይኮ ኪቴቴꬃ ኢፆን ኣሲ ቦሮና ኣማኒያ ናይቲ ዴዒያ ኣሲ ጊዳናው ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("TT1_7","086_1_7","TIT","1","7","7","ዎሳ ኬꬃ ጪሚ ፆሳ ኦሱዋ ሃዳራ ኤኪዳ ጊሾ ቦሬቶናይሳ፥ ኦቶርቶናይሳ፥ ኤሌ ዪሎቶናይሳ፥ ማꬆቶናይሳ፥ ኦዳ ሜꬎናይሳኔ ቤሶና ጎዓስ ዳፌቶናይሳ ጊዳናው ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("TT1_8","086_1_8","TIT","1","8","8","ሺን ኢማꬄ ሞኬይሳ፥ ሎዖባ ኡባ ዶሴይሳ፥ ኣኬካንቾ፥ ፂሎ፥ ጌሺኔ ባና ሃሬይሳ ጊዳናው ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("TT1_9","086_1_9","TIT","1","9","9","ሃራታ ሱሬ ቲሚርቲያን ሚንꬄꬃናዉኔ ሄ ቲሚርቲያ ኢፄይሳታ ዛራናው ባ ታማሪዳ ቱማ ቃላን ሚኒዲ ኤቃናው ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("TT1_10","086_1_10","TIT","1","10","10","ኪቴቶናይሳቲ፥ ፓꬆና ኦዳ ኦዴቴይሳቲ፥ ጪሜይሳቲ ኡባካ ቃፃሬቴꬃ ዎጋ ናጊያ ዳሮ ኣሳቲ ዴዖሶና። ");
INSERT INTO gofENT_vpl VALUES ("TT1_11","086_1_11","TIT","1","11","11","ኤንቲ ቤሶና ኦጌን ሚሼ ዴማናው ኮዪዲ፥ ታማርሳናው ቤሶናባ ታማርሲሼ ኬꬃ ኣሳ ኡባ ኢሲያ ጊሾ ኤንታ ቲሚርቲያ ቴቃናው ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("TT1_12","086_1_12","TIT","1","12","12","ኤንታ ናቤታፔ ኢሶይ፥ «ቃርፄሳ ኣሳይ ኡባ ዎዴ ዎርዶ ኦዴቶሶና፤ ኢታ ዶዓታኔ ኣዛላ ያራምባታ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("TT1_13","086_1_13","TIT","1","13","13","ሃ ማርካቴꬃይ ቱማ ማርካቴꬂ። ሄሳ ጊሾ፥ ኤንታው ቱማ ኣማኖይ ዳና ሜላ ኤንታ ሃንቄታ። ");
INSERT INTO gofENT_vpl VALUES ("TT1_14","086_1_14","TIT","1","14","14","ቱማ ኢፂያ ኣሳ ቲሚርቲያኔ ኣይሁዴታ ፓꬆና ቶሲያ ሲዖና ሜላ ኤንታ ሴራ። ");
INSERT INTO gofENT_vpl VALUES ("TT1_15","086_1_15","TIT","1","15","15","ባንታው ጌሺ ጊዲዳይሳታስ ኡባይ ጌሺ፥ ሺን ቱናታሲኔ ኣማኖናይስታስ ኤንታ ቆፋይኔ ካሃይ ቱኒዳ ጊሾ ኤንታው ኣይቢካ ጌሺ ጊዴና። ");
INSERT INTO gofENT_vpl VALUES ("TT1_16","086_1_16","TIT","1","16","16","ኤንቲ ኑ ፆሳ ኤሮስ ጎሶና፥ ሺን ባንታ ኦሱዋን ኢያ ካዶሶና። ኤንቲ ፆሳን ኢፄቲዳይሳታ፥ ኪቴቶናይሳታኔ ሎዖ ኦሶ ኡባስ ጊዶናይሳታ። ");
INSERT INTO gofENT_vpl VALUES ("TT2_1","086_2_1","TIT","2","1","1","ሺን ኔኒ ሱሬ ቲሚርቲያ ጳልቆና ቲሚርቴ ታማርሳናው ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("TT2_2","086_2_2","TIT","2","2","2","ጪማ ኣዴቲ ባንታና ሃሬይሳታ፥ ዎፑ ጊዳይሳታ፥ ቦንቼቲዳይሳታ፥ ኣማኖን፥ ሲቆኒኔ ዳንዳዓን፥ ሚኖ ጊዳና ሜላ ዞራ። ");
INSERT INTO gofENT_vpl VALUES ("TT2_3","086_2_3","TIT","2","3","3","ሄሳዳካ፥ ጪማ ማጫሳይ ባንታ ዱሳን ጌሻታ፥ ዚጊሮናይሳታ፥ ዎይኔ ኡሻን ሃሬቶናይሳታኔ ሎዖባ ታማርሴይሳታ ጊዳና ሜላ ታማርሳ። ");
INSERT INTO gofENT_vpl VALUES ("TT2_4","086_2_4","TIT","2","4","4","ኤንቲ ሄሳዳ ሃኒኮ ያላጋ ማጫሳይ ባንታ ኣዚናታኔ ባንታ ናይታ ሲቃና ሜላ ታማርሳናው ዳንዳዖሶና። ");
INSERT INTO gofENT_vpl VALUES ("TT2_5","086_2_5","TIT","2","5","5","ፆሳ ቃላይ ቦሬቶና ሜላ ባንታና ሃሬይሳታ፥ ጌሻታ፥ ባንታ ሶን ኦꬄይሳታ፥ ኬሃታኔ ባንታ ኣዚናታስ ኪቴቴይሳታ ጊዳና ሜላ ያላጋ ማጫሳ ታማርሶና። ");
INSERT INTO gofENT_vpl VALUES ("TT2_6","086_2_6","TIT","2","6","6","ሄሳዳካ፥ ያላጋ ኣዳቲ ባንታና ሃራና ሜላ ዞራ። ");
INSERT INTO gofENT_vpl VALUES ("TT2_7","086_2_7","TIT","2","7","7","ኔኒ ኔ ሁዔን ሎዖ ኦሶ ኡባን ኤንታው ሌሚሶ ጊዳ። ኔኒ ኔ ቲሚርቲያን ኤቂዳይሳኔ ኣማኔቲዳይሳ ጊዳ። ");
INSERT INTO gofENT_vpl VALUES ("TT2_8","086_2_8","TIT","2","8","8","ኑ ሞርኬቲ ኑና ዚጊራናው ጋሶያባይ ኤንታው ꬋዪን ኤንቲ ዬላታና ሜላ ኔኒ ቦሬቶና ሎዖ ኦዳ ኦዴታ። ");
INSERT INTO gofENT_vpl VALUES ("TT2_9","086_2_9","TIT","2","9","9","ኣይሌቲ ኡባባን ባንታ ጎዳታስ ኪቴታና ሜላ፥ ኤንታ ኡፋይሳና ሜላኔ ኤንታራ ፓላሞና ሜላ ዞራ። ");
INSERT INTO gofENT_vpl VALUES ("TT2_10","086_2_10","TIT","2","10","10","ኤንቲ ባንታ ጎዳታፔ ካይሶቶፖ። ሄሲካ፥ ኑና ኣሺያ ፆሳ ቲሚርቴይ፥ ኡባ ኦጌን ዶሴቲዳይሳ ጊዳና ሜላ ባንታ ኦꬂያ ኦሱዋን ኣማኔቴይሳታ ጊዴይሳ ቤሳና ሜላ ኤንታ ዞራ። ");
INSERT INTO gofENT_vpl VALUES ("TT2_11","086_2_11","TIT","2","11","11","ኣሴ ኣሺያ ፆሳ ኣꬎ ኬሃቴꬃይ ኣሳ ኡባስ ቆንጪስ። ");
INSERT INTO gofENT_vpl VALUES ("TT2_12","086_2_12","TIT","2","12","12","ሄ ኣꬎ ኬሃቴꬃይ፥ ኑ ናጋራኔ ሃ ኣላሚያ ኣሙዋ ኣጊዲ፥ ሃ ዎዲያን ኑና ሃሪዲ፥ ቱማ ኣያና ዴዑዋኒኔ ፂሎቴꬃን ዳና ሜላ ኑና ታማርሴስ። ");
INSERT INTO gofENT_vpl VALUES ("TT2_13","086_2_13","TIT","2","13","13","ኑኒ ኣንጄቲዳ ኡፋይሳ ጊዲዳ ጊታ ፆሳኔ ኑና ኣሺያ ዬሱስ ኪሪስቶሳ ቦንቾ ቆንጬꬃ ናጎስ። ");
INSERT INTO gofENT_vpl VALUES ("TT2_14","086_2_14","TIT","2","14","14","ኢታ ኦሶ ኡባፌ ኑና ዎዛናዉኔ ሎዖባ ኦꬃናው ኣሞቲያ ባ ጌሻ ኣሲ ኬሳናው ኑ ጊሾ ባና ኣꬂ ኢሚስ። ");
INSERT INTO gofENT_vpl VALUES ("TT2_15","086_2_15","TIT","2","15","15","ኔኒ ሃይሳ ታማርሳ፤ ኩሜꬃ ማታን ዞራ፥ ሴራ፤ ኦኒካ ኔና ካꬎፖ። ");
INSERT INTO gofENT_vpl VALUES ("TT3_1","086_3_1","TIT","3","1","1","ኣሳይ ዴሪያ ሃሬይሳታስ፥ ኣዋቴꬃይ ዴዔይሳታስ ሃሬታናው፥ ኪቴታናዉኔ ሎዖ ኦሶ ኡባ ኦꬃናው ጊጌቲዳይሳታ ጊዳና ሜላ ኣኬኪሳ። ");
INSERT INTO gofENT_vpl VALUES ("TT3_2","086_3_2","TIT","3","2","2","ቃሲ ኤንቲ ኦዴ ቦላካ ኢታ ኦዴቶና ሜላ፥ ሳሮ ኣሲ ጊዳና ሜላ፥ ኣሽኬታኔ ኣሳ ኡባስ ካꬌቴይሳታ ጊዳና ሜላ ዞራ። ");
INSERT INTO gofENT_vpl VALUES ("TT3_3","086_3_3","TIT","3","3","3","ኑኒ ካሴ ኤያታ፥ ኪቴቶናይሳታ፥ ባሌቲዳይሳታ፥ ዱማ ዱማ ኣሾ ኡፋይሳሲኔ ኣሞስ ኣይሌቲዳይሳታ። ኑኒ ኢታቴꬃኒኔ ቃናቴን ኩሚዳይሳታ፤ ኑ ኣሴ ኢፄይሳታ፥ ኣሲካ ኑና ኢፄይሳታ። ");
INSERT INTO gofENT_vpl VALUES ("TT3_4","086_3_4","TIT","3","4","4","ሺን ኣሺያ ፆሳ ኬሃቴꬃይኔ ሲቆይ ቆንጪዳ ዎዴ ");
INSERT INTO gofENT_vpl VALUES ("TT3_5","086_3_5","TIT","3","5","5","ኑ ኦꬂዳ ፂሎ ኦሱዋ ጊሾ ጊዶናሺን ባ ማሮቴꬃ ጊሾ ኑና ኣሺስ። ኑና ኢ ኣሺዳይ፥ ናምዓንꬆ ዬሌቴꬃ ሜቻኒኔ ጌሻ ኣያና ባጋራ ኢሚዳ ኦራꬃ ዴዑዋና። ");
INSERT INTO gofENT_vpl VALUES ("TT3_6","086_3_6","TIT","3","6","6","ሄ ኣያና፥ ፆሳይ ኑና ኣሺያ ዬሱስ ኪሪስቶሳ ባጋራ ኑ ቦላ ዳርሲዲ ጉሲስ። ");
INSERT INTO gofENT_vpl VALUES ("TT3_7","086_3_7","TIT","3","7","7","ባ ኣꬎ ኬሃቴꬃ ባጋራ ኑና ፂሊሲዲ ሜሪና ዴዑዋ ላታ ኡፋይሳ ኦይካና ሜላ ሄሳ ኦꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("TT3_8","086_3_8","TIT","3","8","8","ሃ ቃላይ ኣማኔቲዳ ቃላ። ፆሳ ኣማኔይሳቲ ሎዖ ኦሶ ኦꬃናው ጊጊዳይሳታ ጊዳና ሜላ ኔ ሃ ቃላ ሚንꬃዳ ኦዳና ሜላ ታ ኮያይስ። ሃይሳቲ ኣሴ ኡባስ ሎዖኔ ጎዔይሳታ። ");
INSERT INTO gofENT_vpl VALUES ("TT3_9","086_3_9","TIT","3","9","9","ሺን ኤያቴꬃ ፓላማፔ፥ ኮቻ ታይቦፔ፥ ካቻፌኔ ሂጌ ጋሶን ዴንዲያ ኦሻፌ ናጌታ። ሄሲ ጎዒኔ ዎꬌይ ባይናባ። ");
INSERT INTO gofENT_vpl VALUES ("TT3_10","086_3_10","TIT","3","10","10","ሻሆቴꬂ ሜꬊያ ኡራ ኮይሮ ዞራ፤ ናምዓንꬆ ሃንቄታ ሄሳፌ ጉዬ ኢያፔ ሃካ። ");
INSERT INTO gofENT_vpl VALUES ("TT3_11","086_3_11","TIT","3","11","11","ሄሳ ሜላ ኣሲ ጌላኔ ናጋራንቾ፤ ኢ ባ ቦላ ፒርዴይሳ ኤራ። ");
INSERT INTO gofENT_vpl VALUES ("TT3_12","086_3_12","TIT","3","12","12","ታኒ ባልጎ ያን ሻጫናው ቆፒዳ ጊሾ ኣርፄማሳ ዎይኮ ቲኪቆሳ ኔኮ ኪቲያ ዎዴ ኔ ታኮ ኒቆጲሊዮና ያናው ሚና። ");
INSERT INTO gofENT_vpl VALUES ("TT3_13","086_3_13","TIT","3","13","13","ሂጌ ኤሪያ ዜናሲኔ ኣጲሎሲ ኦጌ ቢያ ዎዴ ኤንታው ኮሺያባይ ፓጮና ሜላ ኤንታ ማዳ። ");
INSERT INTO gofENT_vpl VALUES ("TT3_14","086_3_14","TIT","3","14","14","ኑ ኣሳይካ ፓꬆና ኣሲ ጊዲዲ ኣቶና ሜላ ባንታው ኮሺያባ ዴማና ሜላ ሎዖ ኦሶ ኦꬃናው ሚኒዲ ታማሮ። ");
INSERT INTO gofENT_vpl VALUES ("TT3_15","086_3_15","TIT","3","15","15","ታራ ዴዒያ ኡባይ ኔና ሳሮ ጎሶና፤ ኣማኖን ኑና ሲቂያ ኣሳ ሳሮ ጋ። ፆሳ ኣꬎ ኬሃቴꬃይ ሂንቴ ኡባራ ጊዶ። ኣሚንዒ። ");
INSERT INTO gofENT_vpl VALUES ("PM1_1","087_1_1","PHM","1","1","1","ታኒ ጳዉሎሲ፥ ዬሱስ ኪሪስቶሳ ጊሾ ቃሾን ዴዔይሲኔ ኑ ኢሻ ፂሞቲዮሲ፥ ኑራ ኦꬂያ ኑኒ ዶሲያ ፊልሞናስ፥ ");
INSERT INTO gofENT_vpl VALUES ("PM1_2","087_1_2","PHM","1","2","2","ኔ ሶን ሺቂያ ዎሳ ኬꬃስ፥ ኑ ሚቼ ኣፊቢያሲኔ ኑራ ኢሲፌ ዴዒያ ዎታዳሬ ኣርኪጳሳስ ፃፊዳ ኪታ። ");
INSERT INTO gofENT_vpl VALUES ("PM1_3","087_1_3","PHM","1","3","3","ፆሳ ኑ ኣዋፔኔ ኑ ጎዳ ዬሱስ ኪሪስቶሳፔ ኣꬎ ኬሃቴꬃይኔ ሳሮቴꬃይ ሂንቴው ጊዶ። ");
INSERT INTO gofENT_vpl VALUES ("PM1_4","087_1_4","PHM","1","4","5","ኔኒ ጌሻታ ዶሴይሳኔ ጎዳ ዬሱሳ ኣማኔይሳ ታኒ ሲዒያ ጊሾ ፆሳ ዎሳሼ ኔና ቆፒያ ዎዴ ኡባን ታ ፆሳ ጋላታይስ። ");
INSERT INTO gofENT_vpl VALUES ("PM1_6","087_1_6","PHM","1","6","6","ኔኒ ኔ ኣማኑዋ ሃራታስ ሻኬይሲ ኑስ ኪሪስቶስ ዬሱሳ ባጋራ ያ ሎዖባ ኡባ ኤሪሳና ሜላ ታኒ ፆሳ ዎሳይስ። ");
INSERT INTO gofENT_vpl VALUES ("PM1_7","087_1_7","PHM","1","7","7","ጌሻታ ዎዛናይ ኔ ኦሱዋን ሚኒዳ ጊሾ ታ ኢሻው፥ ታኒ ኔ ሲቁዋን ዳሮ ኡፋይሲኔ ሚንꬄꬆ ዴማስ። ");
INSERT INTO gofENT_vpl VALUES ("PM1_8","087_1_8","PHM","1","8","8","ሄሳ ጊሾ፥ ኔኒ ኦꬃናው ቤሲያባ ኦꬃና ሜላ ኔና ኪታናው ኪሪስቶሳ ባጋራ ታው ሚኖቴꬂ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("PM1_9","087_1_9","PHM","1","9","9","ታኒ፥ ጪማይ ጳዉሎሲ፥ ኪሪስቶስ ዬሱሳስ ሃዒካ ቃሾን ዴዔይሲ፥ ሲቆን ኔና ዎሳይስ። ");
INSERT INTO gofENT_vpl VALUES ("PM1_10","087_1_10","PHM","1","10","10","ታኒ ቃሾን ዴዓሼ ኢያው ዞሪያ ኣዋ ጊዳዳ ታ ናዓ ኣናስሞሳ ጊሾ ኔና ዎሳይስ። ");
INSERT INTO gofENT_vpl VALUES ("PM1_11","087_1_11","PHM","1","11","11","ኢ ካሴ ኔና ማዴና፥ ሺን ሃዒ ኔናካ ታናካ ቱማ ማዲያ ኣሲ። ");
INSERT INTO gofENT_vpl VALUES ("PM1_12","087_1_12","PHM","1","12","13","ታኒ ዎዛናፔ ዶሲያ ኣናስሞሳ ኔኮ ዬዳይስ። ታኒ ዎንጌላ ጊሾ ቃሼቲዳሺን፥ ኔ ጊሾ ታው ኦꬂዲ ታና ማዳና ሜላ ታ ማታን ኢያ ኣሻናው ኮያስ። ");
INSERT INTO gofENT_vpl VALUES ("PM1_14","087_1_14","PHM","1","14","14","ሺን ኔ ሼኔዳ ኦꬃናው ኮያሲፔ ኣቲን ኔራ ዞሬቶና ዎልቃን ኣይኮካ ኦꬃናው ኮዪኬ። ");
INSERT INTO gofENT_vpl VALUES ("PM1_15","087_1_15","PHM","1","15","15","ኣናስሞሲ ጉꬃ ዎዴ ኔፔ ሻኬቲዳይሲ፥ ኦኒ ኤሪ ሲሚዲ ኡባ ዎዴ ኔራ ዴዖና ኣጌና። ");
INSERT INTO gofENT_vpl VALUES ("PM1_16","087_1_16","PHM","1","16","16","ሂዛ፥ ሃይሳፌ ጉዬ ኣናስሞሲ ኣይሌ ጊዶናሺን ኣይሌፌ ኢ ዳሮ ኣꬌስ። ኢ ታው ኣይ ሜላ ሲቆ ኢሼ! ቃሲ ኢ ኔው ኣሳ ባጋራካ ጎዳ ባጋራካ ኣꬊዳ ኢሻ። ");
INSERT INTO gofENT_vpl VALUES ("PM1_17","087_1_17","PHM","1","17","17","ሂዛ፥ ኔኒ ታና ኔ ላጌ ጊያባ ጊዲኮ ታና ሞኬይሳዳ ኢያ ሞካ። ");
INSERT INTO gofENT_vpl VALUES ("PM1_18","087_1_18","PHM","1","18","18","ኢ ኔና ቆሂዳባይ ዎይኮ ኢ ኣጮቲዳባይ ዴዒኮ ታፔ ኤካ። ");
INSERT INTO gofENT_vpl VALUES ("PM1_19","087_1_19","PHM","1","19","19","ሄ ኣጩዋ ታኒ ቃንፃና ጋዳ ታኒ፥ ጳዉሎሲ፥ ታ ኩሼን ፃፋይስ። ኔኒ ታው ኔ ሼምፑዋ ኣጮታ ኡቲዳይሳ ታኒ ኔና ኣኬኪሳናው ኮሼና። ");
INSERT INTO gofENT_vpl VALUES ("PM1_20","087_1_20","PHM","1","20","20","ታ ኢሻው፥ ጎዳ ባጋራ ኔፔ ማዴ ዴማናው ኮያይስ። ኪሪስቶሳ ባጋራ ታና ሚንꬄꬃ። ");
INSERT INTO gofENT_vpl VALUES ("PM1_21","087_1_21","PHM","1","21","21","ታኒ ጊዳይሳፌ ዳሮ ኔኒ ኦꬃናይሳ ኤራዳ ቃሲ ኔ ታው ኪቴታናይሳ ኣማናዳ ሃይሳ ፃፋይስ። ");
INSERT INTO gofENT_vpl VALUES ("PM1_22","087_1_22","PHM","1","22","22","ፆሳይ ሂንቴ ዎሳ ሲዒዲ ታና ሂንቴኮ ጉዬ ዛራና ጋዳ ቆፒያ ጊሾ ታው ኢማꬂ ሼምፒያ ኬꬂ ጊጊሳ። ");
INSERT INTO gofENT_vpl VALUES ("PM1_23","087_1_23","PHM","1","23","23","ኪሪስቶስ ዬሱሳ ጊሾ ታራ ቃሾን ዴዒያ ኤጳፊሪ ኔና ሳሮ ሳሮ ጌስ። ");
INSERT INTO gofENT_vpl VALUES ("PM1_24","087_1_24","PHM","1","24","24","ቃሲ ታራ ኢሲፌ ኦꬂያ ማርቆሲ፥ ኣርስፂሮኮሲ፥ ዴማሲኔ ሉቃሲ ኔና ሳሮ ሳሮ ጎሶና። ");
INSERT INTO gofENT_vpl VALUES ("PM1_25","087_1_25","PHM","1","25","25","ጎዳ ዬሱስ ኪሪስቶሳ ኣꬎ ኬሃቴꬃይ ሂንቴ ኣያናራ ጊዶ። ");
INSERT INTO gofENT_vpl VALUES ("HB1_1","088_1_1","HEB","1","1","1","ካሴ ፆሳይ፥ ኑ ኣዋታስ ናቤታ ባጋራ ዱማ ዱማ ኦጌን ዳሮ ዎዴ ኦዲስ። ");
INSERT INTO gofENT_vpl VALUES ("HB1_2","088_1_2","HEB","1","2","2","ሺን ሃ ዉርሴꬃ ዎዲያን ኡባ ኢያ ላቲሲዳ ቃሲ ኣላሚያ ኢያ ባጋራ ሜꬊዳ ባ ናዓ ባጋራ ኑስ ኦዲስ። ");
INSERT INTO gofENT_vpl VALUES ("HB1_3","088_1_3","HEB","1","3","3","ናዓይ ፆሳ ቦንቹዋ ጶሌꬃኔ ኩሜꬃ ፆሳ ፆሳቴꬃ ኤኪዲ፥ ባ ዎልቃማ ቃላን ሃ ኣላሚያ ካቲሲዲ ኦይኪስ። ኣሳ ኤንታ ናጋራፔ ጌሺዳፔ ጉዬ ኡባፌ ቦላ ፆሳ ኡሻቻ ባጋን ሳሉዋን ኡቲስ። ");
INSERT INTO gofENT_vpl VALUES ("HB1_4","088_1_4","HEB","1","4","4","ኢያው ኢሜቲዳ ሱንꬃይ ኪታንቾታ ሱንꬃፌ ቦላ ጊዴይሳዳ ኢ ኤንታፌ ቦላ። ");
INSERT INTO gofENT_vpl VALUES ("HB1_5","088_1_5","HEB","1","5","5","ሂዛ፥ ፆሳይ ኪታንቾታፔ ኦዴኮ፥ «ኔኒ ታ ናዓ፤ ታ ሃቺ ኔው ኣዋ ጊዳስ» ጊዴ? ዎይኮ ቃሲ ኦዴኮ፥ «ታኒ ኢያው ኣዋ ጊዳና፤ ኢካ ታው ናዓ ጊዳና» ጊዴ? ");
INSERT INTO gofENT_vpl VALUES ("HB1_6","088_1_6","HEB","1","6","6","ቃሲ ፆሳይ ባ ባይራ ናዓ ሃ ኣላሚያ ኪቲሼ፥ «ፆሳ ኪታንቾቲ ኡባይ ኢያው ጎይኖ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("HB1_7","088_1_7","HEB","1","7","7","ፆሳይ ኪታንቾታባ ኦዲሼ፥ «ፆሳይ ባ ኪታንቾታ ጫርኮ፥ ባ ኣይሌታ ታማ ላጮ ኦꬄስ» ያጌስ። ");
INSERT INTO gofENT_vpl VALUES ("HB1_8","088_1_8","HEB","1","8","8","ሺን ባ ናዓባ ኦዲሼ፥ «ፆሳው፥ ኔ ካዎቴꬃይ ሜሪናው ዴዔስ። ኔ ካዎቴꬃ ኔ ፂሎቴꬃን ኣይሳሳ። ");
INSERT INTO gofENT_vpl VALUES ("HB1_9","088_1_9","HEB","1","9","9","ኔኒ ፂሎቴꬂ ዶሳዳሳ፤ ኢታ ኢፃዳሳ። ፆሳይ፥ ኔ ጎዳይ፥ ኔና ኔ ላጌታፔ ኣꬂዲ ዶሪስ፥ ኡፋይሳ ዛይቴ ኔና ቲዪስ» ያጌስ። ");
INSERT INTO gofENT_vpl VALUES ("HB1_10","088_1_10","HEB","1","10","10","ፆሳይ ዛሪዲ፥ «ጎዳው፥ ኮይሮ ኔኒ ሳዓ ሜꬋዳሳ፤ ሳሎቲ ኔ ኩሼ ኦሶ። ");
INSERT INTO gofENT_vpl VALUES ("HB1_11","088_1_11","HEB","1","11","11","ሄሳቲ ኡባይ ꬋያና፤ ሺን ኔኒ ዳና። ኤንቲ ኡባይ ኣፊላዳ ዉራና። ");
INSERT INTO gofENT_vpl VALUES ("HB1_12","088_1_12","HEB","1","12","12","ኔኒ ኤንታ ሳሌናዳ ፃፃና፤ ቃሲ ኤንቲ ኣፊላዳ ላሜታና። ሺን ኔኒ ኡባ ዎዴ ኔና፤ ኔ ላይꬃይካ ዉሬና» ያጌስ። ");
INSERT INTO gofENT_vpl VALUES ("HB1_13","088_1_13","HEB","1","13","13","ሺን ፆሳይ ኪታንቾታፔ ኦዴኮ፥ «ታኒ ኔ ሞርኬታ ኔ ቶሆይ ዬꬊያሶ ኦꬃና ጋካናው፥ ሃይሳን ታፔ ኡሻቻ ባጋን ኡታ» ጊዴ? ");
INSERT INTO gofENT_vpl VALUES ("HB1_14","088_1_14","HEB","1","14","14","ኪታንቾቲ ኡባይ ኣቶቴꬂ ዴማናው ዴዒያ ኣሳታ ማዳናው ፆሳይ ኪቲዳ ኣያናታ ጊዶኮናዬ? ");
INSERT INTO gofENT_vpl VALUES ("HB2_1","088_2_1","HEB","2","1","1","ሄሳ ጊሾ፥ ኑኒ ሲዒዳ ቱማፔ ሃራሶ ኤኬቶና ሜላ ሄ ሲዒዳይሳ ሚንꬂዲ ናጋናው ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("HB2_2","088_2_2","HEB","2","2","2","ሂዛ፥ ኪታንቾታ ባጋራ ኦዴቲዳ ቃላይ ቱማ ጊዲኮ፥ ኢያ ናቆይኔ ኪቴቶና ኢፆይ ፒርዳ ኤሂያባ ጊዲኮ፥ ");
INSERT INTO gofENT_vpl VALUES ("HB2_3","088_2_3","HEB","2","3","3","ያቲን፥ ኑኒ ሃይሳ ሜላ ጊታ ኣቶቴꬃ ኢፃስ ጊኮ፥ ዋኒዲ ኣታኔ? ኮይሮ ጎዳይ ባ ሁዔን ሄ ኣቶቴꬃ ኦዲስ፤ ቃሲ ኢያፔ ሲዒዳይሳቲ ኑስ ጌሺዲ ማርካቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("HB2_4","088_2_4","HEB","2","4","4","ቃሲ ፆሳይ ማላታታን፥ ኦራꬃባታን፥ ዱማ ዱማ ማላታኒኔ ባ ሼኒያዳ ኢሚዳ ጌሻ ኣያና ኢሞታታን ማርካቴꬃ ሚንꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("HB2_5","088_2_5","HEB","2","5","5","ፆሳይ ሃ ኑኒ ኦዲያ ሲንꬃፌ ያና ኣላሚያ፥ ኪታንቾታስ ሃሪሲቤና። ");
INSERT INTO gofENT_vpl VALUES ("HB2_6","088_2_6","HEB","2","6","6","ጌሻ ማፃፋይ ኢሲ ቤሳን ሃይሳዳ ያጌስ፡ «ኔኒ ኣሳስ ቆፓናው ኣሲ ኣይቤ? ዎይኮ ኔኒ ኢያ ናጋናው ኢ ኣይቤ? ");
INSERT INTO gofENT_vpl VALUES ("HB2_7","088_2_7","HEB","2","7","7","ኔ ኢያ ኪታንቾታፔ ጉꬃ ዎዴስ ጉꬃዳሳ፤ ኢያ ሁዔን ቦንቾኔ ሳባ ካላቻ ዎꬃዳሳ። ");
INSERT INTO gofENT_vpl VALUES ("HB2_8","088_2_8","HEB","2","8","8","ቃሲ ኡባባ ኢያ ቶሁዋፔ ጋርሳን ዎꬃዳሳ» ያጌስ። ፆሳይ ኡባባ ኢያው ሃሪሲያ ዎዴ ኢያው ሃሬቲቦናባይ ኣይቢካ ባዋ። ሺን ሃዒ ኡባባይ ኢያው ሃሬቲሺን ኑኒ ቤዒቦኮ። ");
INSERT INTO gofENT_vpl VALUES ("HB2_9","088_2_9","HEB","2","9","9","ሺን ኑኒ ኪታንቾታፔ ጉꬃራ ጉፂዳ ዬሱሳ ቤዖስ። ፆሳ ኣꬎ ኬሃቴꬃ ጋሶን ዬሱሲ ኣሳ ኡባስ ሃይቂስ። ኢ ዋዬ ሃይቆ ሃይቂዳ ጊሾ ቦንቾኔ ሳባ ካላቻ ኢያ ሁዔን ዎꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("HB2_10","088_2_10","HEB","2","10","10","ኡባባይ ኢያዉኔ ኢያ ጋሶን ሜꬌቲዳ ፆሳይ፥ ዳሮ ናይታ ባራ ቦንቺሳናው ኤንታ ኣቶቴꬃ ሁዒያ፥ ዬሱሳ ዋዬን ፖሎ ኦꬃናው ኢያው ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("HB2_11","088_2_11","HEB","2","11","11","ዬሱሲኔ ሄ ኢ ጌሺዳ ኣሳ ኡባይ ኢሲ ኣዋ ናይታ። ዬሱሲ ኤንታ፥ «ታ ኢሻታ» ጊዲ ፄጋናው ዬላቶናይ ሄሳሳ። ");
INSERT INTO gofENT_vpl VALUES ("HB2_12","088_2_12","HEB","2","12","12","ዬሱሲ፥ «ታኒ ኔ ሱንꬃ ታ ኢሻታስ ኣዋጃና፤ ዴሪያ ሺቁዋን ኔና ጋላታና» ያጌስ። ");
INSERT INTO gofENT_vpl VALUES ("HB2_13","088_2_13","HEB","2","13","13","ቃሲ ኢ፥ «ታኒ ታ ኣማኑዋ ኢያ ቦላ ዎꬃና» ቃሲካ፥ «ፆሳይ ታው ኢሚዳ ናይታራ ታ ሃይሳን ዴዓይስ» ያጌስ። ");
INSERT INTO gofENT_vpl VALUES ("HB2_14","088_2_14","HEB","2","14","14","ናይቲ ኣሾይኔ ሱꬂ ዴዔይሳታ ጊዲያ ጊሾ ዬሱሲካ ኤንታዳ ኣሴ ጊዲስ። ኢ ሄሳ ኦꬂዳይ፥ ሃይቆ ቦላ ዎልቂ ዴዒያ ፃላሂያ ባ ሃይቁዋን ꬋይሳናሳ። ");
INSERT INTO gofENT_vpl VALUES ("HB2_15","088_2_15","HEB","2","15","15","ቃሲ ባንታ ዴዖ ላይꬃ ኡባን ሃይቆ ያሻን ኣይሌቲዲ ዴዔይሳታ ኣይሌቴꬃፌ ዎዛናሳ። ");
INSERT INTO gofENT_vpl VALUES ("HB2_16","088_2_16","HEB","2","16","16","ቱማ ዬሱሲ ዪዳይ ኣብራሃሜ ዜሬꬂ ማዳናሳፌ ኣቲን ኪታንቾታ ማዳናሳ ጊዴና። ");
INSERT INTO gofENT_vpl VALUES ("HB2_17","088_2_17","HEB","2","17","17","ኣሳ ናጋራይ ኣቶ ጌቴታና ሜላ ፆሳ ሲንꬃን ማሪያኔ ኣማኔቲዳ ካሂኔ ሃላቃ ጊዲስ። ሄሳ ጊሾ፥ ኢ ኡባባን ባ ኢሻታ ዳናናው ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("HB2_18","088_2_18","HEB","2","18","18","ኢ ባ ሁዔን ፓጬን ዋዬቲዳ ጊሾ ፓጬቴይሳታ ማዳናው ዳንዳዔስ። ");
INSERT INTO gofENT_vpl VALUES ("HB3_1","088_3_1","HEB","3","1","1","ሄሳ ጊሾ፥ ፆሳይ ፄጊዳ ጌሻ ኢሻቶ፥ ኑ ኣማኖን ጎዳ ጊዲ ፄጊያ ሃዋሪያኔ ካሂኔ ሃላቃ ዬሱሳ ቤዒቴ። ");
INSERT INTO gofENT_vpl VALUES ("HB3_2","088_3_2","HEB","3","2","2","ሙሴይ ፆሳ ኬꬃ ኡባን ኣማኔቲዳይሳዳ ዬሱሲካ ባና ዶሪዳ ፆሳስ ኣማኔቲዳይሳ። ");
INSERT INTO gofENT_vpl VALUES ("HB3_3","088_3_3","HEB","3","3","3","ኬꬄ ኬፄይሲ ኬꬃፌ ኣꬊዲ ቦንቼቴይሳዳ ዬሱሲ ሙሴፔ ኣꬊያ ቦንቾ ኤካናው ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("HB3_4","088_3_4","HEB","3","4","4","ኢሲ ኢሲ ኬꬃ ኬፂዳ ኣሲ ዴዔስ፥ ሺን ኡባ ጊጊሲዳይ ፆሳ። ");
INSERT INTO gofENT_vpl VALUES ("HB3_5","088_3_5","HEB","3","5","5","ሙሴይ ፆሳ ኬꬃ ኡባን ኣማኔቲዳ ኣይሌ ጊዲዲ፥ ፆሳይ ሲንꬃፌ ጋናባስ ማርካ ጊዲስ። ");
INSERT INTO gofENT_vpl VALUES ("HB3_6","088_3_6","HEB","3","6","6","ሺን ኪሪስቶሲ ፆሳ ኬꬃን ናዓዳ ኣማኔቲዳይሳ። ኑኒ ኤካና ጊዲ ናጊያ ኡፋይሳ ሚንꬂዲ ናጊኮ ፆሳ ኬꬂ ጊዶስ። ");
INSERT INTO gofENT_vpl VALUES ("HB3_7","088_3_7","HEB","3","7","7","ሄሳ ጊሾ፥ ጌሻ ኣያናይ ጌይሳዳ፥ «ሃቺ ሂንቴ ፆሳይ ጌይሳ ሲዒያ ዎዴ ");
INSERT INTO gofENT_vpl VALUES ("HB3_8","088_3_8","HEB","3","8","8","ባዞ ቢታን ፓጪያ ጋላስ፥ ሂንቴ ኣዋቲ ማካሊዳይሳዳ፥ ሂንቴ ዎዛና ሚንꬆፊቴ። ");
INSERT INTO gofENT_vpl VALUES ("HB3_9","088_3_9","HEB","3","9","9","ሂንቴ ኣዋቲ ታና ፓጪዶሶና፤ ኦይታሙ ላይꬂ ታ ኦሱዋ ቤዒዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("HB3_10","088_3_10","HEB","3","10","10","ሄሳ ጊሾ፥ ታ ሄ ዬሌቴꬃ ሃንቄታዳ፥ ‹ኤንቲ ኡባ ዎዴ ባንታ ዎዛናን ባሎሶና፤ ታ ኦጊያ ኤሪቦኮና› ያጋስ። ");
INSERT INTO gofENT_vpl VALUES ("HB3_11","088_3_11","HEB","3","11","11","ሄሳ ጊሾ፥ ታኒ ታ ሃንቁዋን ጫቃዳ፥ ‹ታ ሼምፖ ቤሳ ኡባካ ጌሎኮና› ያጋስ» ያጌስ። ");
INSERT INTO gofENT_vpl VALUES ("HB3_12","088_3_12","HEB","3","12","12","ታ ኢሻቶ፥ ሂንቴፌ ኦዴንካ፥ ዴዖ ፆሳፌ ሂንቴና ሻኪያ ኢታኔ ኣማኖና ዎዛኒ ዶና ሜላ ናጌቲቴ። ");
INSERT INTO gofENT_vpl VALUES ("HB3_13","088_3_13","HEB","3","13","13","ሂንቴፌ ኦናካ ናጋሪ ባሌꬂን፥ ባ ዎዛና ሚንꬆና ሜላ «ሃቺ» ያጌቲዲ ፄጌቲሺን ጋላስ ጋላስ ኢሶይ ኢሱዋራ ዞሬቲቴ። ");
INSERT INTO gofENT_vpl VALUES ("HB3_14","088_3_14","HEB","3","14","14","ኑ ኮይሮ ኣማኑዋ ኑኒ ዉርሴꬂ ጋካናው ሚንꬂዲ ናጊኮ፥ ኪሪስቶሳራ ኢሲፌ ላታና። ");
INSERT INTO gofENT_vpl VALUES ("HB3_15","088_3_15","HEB","3","15","15","ጌሻ ማፃፋን፥ «ሃቺ ፆሳይ ጌይሳ ሂንቴ ሲዒያ ዎዴ ሄ ዎዴ ኤንቲ ማካላቴꬃን ሃኒዳይሳዳ፥ ሂንቴ ዎዛና ሚንꬆፊቴ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("HB3_16","088_3_16","HEB","3","16","16","ፆሳይ ጊያባ ሲዒዲ ማካሊዳይ ኦኔ? ሙሴይ ጊብፄፌ ካሌꬂ ኬሲዳ ኡባ ጊዶኮናዬ? ");
INSERT INTO gofENT_vpl VALUES ("HB3_17","088_3_17","HEB","3","17","17","ፆሳይ ኦይታሙ ላይꬂ ኦና ሃንቄቲዴ? ናጋራ ኦꬂዳይሳታኔ ኤንታ ኣሃይ ባዞ ቢታን ዎꬊ ኣቲዳ ኣሳታ ጊዶኮናዬ? ");
INSERT INTO gofENT_vpl VALUES ("HB3_18","088_3_18","HEB","3","18","18","ቃሲ ፆሳይ፥ «ታ ሼምፖ ቤሳ ጌሌኬታ» ያጊዲ ጫቂዳይ፥ ኢያው ኪቴቶና ኢፂዳ ኣሳፔ ኣቲን ኦዴሴ? ");
INSERT INTO gofENT_vpl VALUES ("HB3_19","088_3_19","HEB","3","19","19","ሂዛ፥ ኤንቲ ሄ ሼምፖ ቤሳ ጌሎና ኣቲዳይ ኣማኒቦና ጊሾ ጊዴይሳ ኑ ቤዖስ። ");
INSERT INTO gofENT_vpl VALUES ("HB4_1","088_4_1","HEB","4","1","1","ሂዛ፥ ፆሳይ ኑና ባ ሼምፖ ቤሳ ጌልሳና ጊዳ ቃላይ ቡሮ ሲንꬃፌ ዴዒያ ጊሾ ሂንቴፌ ኦኒካ ሄ ሼምፖ ቤሳ ጌሎና ኣቶና ሜላ ናጌቶስ። ");
INSERT INTO gofENT_vpl VALUES ("HB4_2","088_4_2","HEB","4","2","2","ኤንታው ዎንጌላይ ሳባኬቲዳይሳዳ፥ ኑስካ ሳባኬቲስ። ሺን ኤንቲ ሲዒዳባ ኣማኒዲ ኤኪቦና ጊሾ ኤንታ ጎዒቤና። ");
INSERT INTO gofENT_vpl VALUES ("HB4_3","088_4_3","HEB","4","3","3","ጊዶሺን፥ ኣላሜይ ሜꬌቶሳፔ ዶሚዲ ፆሳ ኦሶይ ፖሌቲዳይሳ ጊዲኮካ፥ ፆሳይ፥ «ታኒ ታ ሃንቁዋን ጫቃዳ፥ ታ ሼምፖ ቤሳ ኡባካ ጌሎኮና» ጊዳይሳዳ፥ ኑኒ ኣማኒዳይሳቲ ኢያ ሼምፖ ቤሳ ጌላና። ");
INSERT INTO gofENT_vpl VALUES ("HB4_4","088_4_4","HEB","4","4","4","ላፑንꬃ ጋላሳባ ኢሲ ቤሳን፥ «ፆሳይ ላፑንꬃ ጋላሳን ባ ኦሶ ኡባፌ ሼምፒስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("HB4_5","088_4_5","HEB","4","5","5","ቃሲካ ሄ ቤሳን፥ «ኤንቲ ታ ሼምፖ ቤሳ ኡባራካ ጌሎኮና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("HB4_6","088_4_6","HEB","4","6","6","ኮይሮ ዎንጌላ ሲዒዳይሳቲ ኪቴቶና ኢፂዲ ሼምፖ ቤሳ ጌሊቦኮና። ያኒያ ጊሾ፥ ሃዒካ ሄ ሼምፖ ቤሳ ጌላና ኢሲ ኢሲ ኣሳቲ ዴዖሶና። ");
INSERT INTO gofENT_vpl VALUES ("HB4_7","088_4_7","HEB","4","7","7","ሄሳ ጊሾ፥ ፆሳይ፥ «ሃቺ» ጊዲ ፄጊሼ ኢሲ ጋላስ ኑስ ቃንፂስ። ዳሮ ዎዴፔ ጉዬ ፆሳይ ዳዊቴ ባጋራ፥ «ፆሳይ ጊያባ ሃቺ ሂንቴ ሲዒያ ዎዴ ሂንቴ ዎዛና ሚንꬆፊቴ» ያጊዲ ኦዲስ። ");
INSERT INTO gofENT_vpl VALUES ("HB4_8","088_4_8","HEB","4","8","8","ኢያሱይ ኤንታው ሼምፑዋ ኢሚዳባ ጊዲያኮ፥ ፆሳይ ሃራ ጋላሳባ ጉዬፔ ኦዴናሺን። ");
INSERT INTO gofENT_vpl VALUES ("HB4_9","088_4_9","HEB","4","9","9","ሂዛ፥ ፆሳ ኣሳስ ሳምባታ ሼምፖይ ናጌቲዲ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("HB4_10","088_4_10","HEB","4","10","10","ፆሳ ሼምፖ ቤሳ ጌሊያ ኦኒካ፥ ፆሳይ ባ ኦሱዋፔ ሼምፒዳይሳዳ ኢካ ባ ኦሱዋፔ ሼምፓና። ");
INSERT INTO gofENT_vpl VALUES ("HB4_11","088_4_11","HEB","4","11","11","ሄሳ ጊሾ፥ ኦኒካ ሄ ኣሳ ኪቴቴꬃ ኢፁዋ ካሊዲ፥ ኩንዶናዳ ፆሳ ሼምፖ ቤሳ ጌላናው ሚኖስ። ");
INSERT INTO gofENT_vpl VALUES ("HB4_12","088_4_12","HEB","4","12","12","ፆሳ ቃላይ ዴዖኔ ኦꬄይሳ። ናምዑ ባጋራ ቃራቲዳ ማሻፌ ኣꬊዲ ኦጮ። ኢ ሼምፖ፥ ኣያና፥ ፃጶኔ ኮሊዜ ጋካናው ካንꬂዲ ጫዴስ። ቃሲ ኣሳ ዎዛናን ዴዒያ ጌሚዳ ቆፋኔ ኣሙዋ ሻኪዲ ፒርዴስ። ");
INSERT INTO gofENT_vpl VALUES ("HB4_13","088_4_13","HEB","4","13","13","ፆሳ ሲንꬃፌ ቆሴቲያባይ ኣይባ ሜꬌቴꬂካ ባዋ። ኢያ ኣይፌ ሲንꬃን ኡባባይ ቆንጬኔ ካሎ ዴዔስ። ኑኒ ዛሮ ኢማናው ቤሴይ ኢያ ሲንꬃና። ");
INSERT INTO gofENT_vpl VALUES ("HB4_14","088_4_14","HEB","4","14","14","ሂዛ፥ ሳሎ ኬዪዳ ጊታ ካሂኔ ሃላቃይ፥ ፆሳ ናዓይ ዬሱሲ፥ ኑስ ዴዒያ ጊሾ ኑ ኣማኑዋ ሚንꬂዲ ናጎስ። ");
INSERT INTO gofENT_vpl VALUES ("HB4_15","088_4_15","HEB","4","15","15","ኑ ካሂኔ ሃላቃይ ኑ ዳቡሪያ ዎዴ ኑስ ቃꬌታናው ዳንዳዔይሳ። ኢ ናጋራ ኦꬂቤና፥ ሺን ኑዳ ኡባባን ፓጬቲስ። ");
INSERT INTO gofENT_vpl VALUES ("HB4_16","088_4_16","HEB","4","16","16","ሂዛ፥ ማሮቴꬃ ኤካናዉኔ ማዴ ኮሺያ ዎዴ ኣꬎ ኬሃቴꬃ ዴማናው ኣꬎ ኬሃቴꬃይ ዴዒያሱዋ ፆሳ ኣራታኮ ያዮና ሺቆስ። ");
INSERT INTO gofENT_vpl VALUES ("HB5_1","088_5_1","HEB","5","1","1","ኢሲ ኢሲ ካሂኔ ሃላቂ ኣሳ ጊዶፌ ዶሬቲዲ፥ ፆሳራ ጋꬂያባን ኣሳ ጊሾ ኢሞታኔ ናጋራ ያርሾ ያርሻናው ሹሜቴስ። ");
INSERT INTO gofENT_vpl VALUES ("HB5_2","088_5_2","HEB","5","2","2","ኢ ባ ሁዔን ዳቡራንቾ ጊዲያ ጊሾ ኤሮናይሳታሲኔ ባሌይሳታስ ቃꬌታናው ዳንዳዔስ። ");
INSERT INTO gofENT_vpl VALUES ("HB5_3","088_5_3","HEB","5","3","3","ኢ ባ ናጋራ ጊሾኔ ኣሳ ኡባ ናጋራ ጊሾ ያርሾ ያርሻናው ቤሴይ ሄሳሳ። ");
INSERT INTO gofENT_vpl VALUES ("HB5_4","088_5_4","HEB","5","4","4","ኦኒካ ሃ ቦንቹዋ ባው ኤካናው ዳንዳዔና፥ ሺን ኣሮኒ ካሂኔ ሃላቃ ጊዳናው ፄጌቲዳይሳዳ ፆሳን ፄጌታናው ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("HB5_5","088_5_5","HEB","5","5","5","ሄሳዳካ፥ ኪሪስቶሲ ካሂኔ ሃላቃ ጊዲያ ቦንቹዋ ባው ኤኪቤና። ሺን ፆሳይ ኢያ፥ «ኔኒ ታ ናዓ። ሃቺ ታ ኔው ኣዋ ጊዳስ» ያጌስ። ");
INSERT INTO gofENT_vpl VALUES ("HB5_6","088_5_6","HEB","5","6","6","ቃሲ ሃራሶን፥ «ማልኬፃዲቄይ ካሂኔ ጊዲዳይሳዳ፥ ኔኒ ሜሪናው ካሂኔ ጊዳና» ያጌስ። ");
INSERT INTO gofENT_vpl VALUES ("HB5_7","088_5_7","HEB","5","7","7","ዬሱሲ ኣሴ ጊዲዲ ሃ ኣላሚያን ዴዒያ ዎዴ ባና ሃይቆፔ ኣሻናው ዳንዳዒያ ፆሳ ዳሮ ዬሆኒኔ ኣፉꬃን ዎሲስ። ኢ፥ ኢያ ቦንቺዲ ኪቴቲዳ ጊሾ ፆሳይ ኢያ ዎሳ ሲዒስ። ");
INSERT INTO gofENT_vpl VALUES ("HB5_8","088_5_8","HEB","5","8","8","ዬሱሲ ፆሳ ናዓ ጊዲኮካ ባ ዋዬቲዳ ዋያን ኪቴቴꬂ ታማሪስ። ");
INSERT INTO gofENT_vpl VALUES ("HB5_9","088_5_9","HEB","5","9","9","ሄሳንካ፥ ዬሱሲ ባ ኦሱዋ ፖሊዳፔ ጉዬ ባው ኪቴቲያ ኡባይ ሜሪና ኣቶቴꬃ ዴማና ሜላ ጋሶ ጊዲስ። ");
INSERT INTO gofENT_vpl VALUES ("HB5_10","088_5_10","HEB","5","10","10","ፆሳይ ማልኬፃዲቄ ሹሚዳይሳዳ ካሂኔ ሃላቃ ኦꬂዲ ኢያ ሹሚስ። ");
INSERT INTO gofENT_vpl VALUES ("HB5_11","088_5_11","HEB","5","11","11","ሃ ኑ ኦዳ ቦላ ጉጂ ሃሳያናባይ ዳሮባይ ዴዔስ፥ ሺን ሂንቴ ኣኬካይ ጉꬃ ጊዲያ ጊሾ ሂንቴው ኦዲ ጌልሳናው ዋይሴስ። ");
INSERT INTO gofENT_vpl VALUES ("HB5_12","088_5_12","HEB","5","12","12","ሂንቴ ሃኖዴ ኣስታማሬ ጊዳናው ቤሴስ፥ ሺን ፆሳ ቃላ ኮይሮ ቲሚርቲያ ሂንቴና ዛሪ ታማርሲያ ሃራ ኣሲ ኮሼስ። ሂንቴ ሚኖ ካꬂ ማናው ዳንዳዖና ጊሾ ማꬂ ኮሼስ። ");
INSERT INTO gofENT_vpl VALUES ("HB5_13","088_5_13","HEB","5","13","13","ማꬂ ፓሄቲያ ኦኒካ ዮጋ ናዓ ጊዲያ ጊሾ ሎዖኔ ኢታ ሻኪ ኤሬና። ");
INSERT INTO gofENT_vpl VALUES ("HB5_14","088_5_14","HEB","5","14","14","ሺን ሚኖ ካꬂ ሎዖኔ ኢታ ሻኪዲ ኤሪያ ካሃማ ኣሳሳ። ");
INSERT INTO gofENT_vpl VALUES ("HB6_1","088_6_1","HEB","6","1","1","ሂዛ፥ ኪሪስቶሳባ ታማርሲያ ኮይሮ ቲሚርቲያ ኣጊዲ ኪሪስቶሳን ካሃማቴꬃኮ ቦስ። ሃይቆ ኦሶፔ ሲሞባኔ ፆሳ ኣማኖባ ኮይሮ ቲሚርቲያኮ ጉዬ ሲሞኮ። ");
INSERT INTO gofENT_vpl VALUES ("HB6_2","088_6_2","HEB","6","2","2","ሄሳዳካ፥ ፂንቃቴታባ፥ ኩሼ ዎሶባ፥ ሃይቆፔ ዴንዶባኔ ሜሪና ፒርዳባ ዛሪ ታማሮኮ። ");
INSERT INTO gofENT_vpl VALUES ("HB6_3","088_6_3","HEB","6","3","3","ፆሳይ ጊኮ ኑ ሄሳ ኦꬃና። ");
INSERT INTO gofENT_vpl VALUES ("HB6_4","088_6_4","HEB","6","4","4","ኢሲ ቶሆ ፖዖይ ፖዒዳይሳታ፥ ሳሎ ኢሞታ ኤኪዳይሳታ፥ ጌሻ ኣያናን ሻኬቲዳይሳታ፥ ");
INSERT INTO gofENT_vpl VALUES ("HB6_5","088_6_5","HEB","6","5","5","ሎዖ ፆሳ ቃላኔ ሲንꬃፌ ያና ኣላሚያ ዎልቃ ቤዒዳይሳታ፥ ");
INSERT INTO gofENT_vpl VALUES ("HB6_6","088_6_6","HEB","6","6","6","ጉዬፔ ካዲዳይሳታ ናጋራፔ ናምዓንꬆ ዛራናው ዳንዳዔቴና። ኣይስ ጊኮ፥ ኤንቲ ባንታ ꬋዩዋስ ፆሳ ናዓ ዛሪ ካቂያ ሜላ ማስቃሊያ ቦላ ኢያ ካቆሶናኔ ኣሳ ሲንꬃን ካዉሾሶና። ");
INSERT INTO gofENT_vpl VALUES ("HB6_7","088_6_7","HEB","6","7","7","ኡባ ዎዴ ኢ ቦላ ቡኪያ ኢራ ኡያዳ፥ ጎዪዳ ኡራ ማዲያ ካꬂ ኢሚያ ቢቲያ ፆሳን ኣንጄቲዳሮ። ");
INSERT INTO gofENT_vpl VALUES ("HB6_8","088_6_8","HEB","6","8","8","ሺን ኣጉንꬁኔ ኪንቾቴ ዶሊያ ቢቲያ ኣይቢባካ ማዱኩ፤ ኢው ቃንጌꬃይ ማታቲስ፤ ዉርሴꬃን ፁጌታና። ");
INSERT INTO gofENT_vpl VALUES ("HB6_9","088_6_9","HEB","6","9","9","ኑ ሲቆ ኢሻቶ፥ ኑኒ ሃይሳዳ ኦዲያባ ጊዲኮካ፥ ሂንቴና ኣቶቴꬃኮ ካሌꬂያ ሎዖባይ ሂንቴው ዴዔይሳ ኤሮስ። ");
INSERT INTO gofENT_vpl VALUES ("HB6_10","088_6_10","HEB","6","10","10","ፆሳይ ሱሬ ፒርዴይሳ። ፆሳይ፥ ሂንቴ ኦꬂዳ ኦሱዋኔ ካሴ ጊዲን ሃዒካ ኣማኔይሳታ ማዲዲ፥ ኢያው ዴዒያ ሲቁዋ ቤሲዳይሳ ዶጌና። ");
INSERT INTO gofENT_vpl VALUES ("HB6_11","088_6_11","HEB","6","11","11","ሂንቴ ኡባይ ኡፋይሳን ናጌይሳ ዴማና ጋካናው ሃ ሚኖቴꬃ ዉርሴꬂ ጋካናው ቤሳና ሜላ ኑ ኣሞቶስ። ");
INSERT INTO gofENT_vpl VALUES ("HB6_12","088_6_12","HEB","6","12","12","ሂንቴ ኣማኖኒኔ ዳንዳዓን ናጊያ ኡፋይሳ ላቲያ ኣሳ ዳናና ሜላፔ ኣቲን ኣዛላ ጊዳና ሜላ ኮዮኮ። ");
INSERT INTO gofENT_vpl VALUES ("HB6_13","088_6_13","HEB","6","13","13","ፆሳይ ኣብራሃሜስ ኢማና ጊዲ ጫቂዳ ዎዴ ባፔ ኣꬊያ ሃሪ ጊቲ ባይና ጊሾ ባ ሁዔን ጫቂስ። ");
INSERT INTO gofENT_vpl VALUES ("HB6_14","088_6_14","HEB","6","14","14","ኢያኮ፥ «ታኒ ኔና ኣንጃና፤ ኔ ዜሬꬃካ ዳርሳና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("HB6_15","088_6_15","HEB","6","15","15","ኣብራሃሜይ ዳንዳዓን ናጊዲ ፆሳይ ኢማና ጊዳ ኡፋይሳ ኤኪስ። ");
INSERT INTO gofENT_vpl VALUES ("HB6_16","088_6_16","HEB","6","16","16","ኣሲ ጫቂሼ ባፔ ጊታቲያ ኡራን ጫቄስ፤ ሄ ጫቆይ ጌቴቲዳባ ሚንꬂዲ፥ ፓላማ ኡባ ቴቄስ። ");
INSERT INTO gofENT_vpl VALUES ("HB6_17","088_6_17","HEB","6","17","17","ሄሳ ጊሾ፥ ፆሳይ ባ ላሜቶና ቆፋ ኡፋይሳ ቃላ ላቴይሳታስ ቆንጪሳናው ኮዪዳ ጊሾ ጫቆን ሚንꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("HB6_18","088_6_18","HEB","6","18","18","ፆሳይ ዎርዶቴና። ኢያ ኡፋይሳ ቃላይኔ ጫቆይ፥ ናምዓይካ ላሜቶኮና። ሃ ናምዑባታን ኑ ሲንꬃን ዴዒያ ኡፋይሳ ኦይካናው ዳናዳዓና ሜላ ጌሼ ዴማናው ኢያኮ ባቃቲዳ ኑኒ፥ ዎልቃማ ሚንꬄꬆ ዴማና። ");
INSERT INTO gofENT_vpl VALUES ("HB6_19","088_6_19","HEB","6","19","19","ሃ ኡፋይሳይ ኑ ሼምፑዋስ፥ ማርካቤይ ቃፆናዳ ሚንꬂዲ ኦይኪያ ቢራታ ሜላ። ሄ ኡፋይሳይ ማጋራጁዋፌ ጉዬ ባጋን ዴዒያ ጌሻ ቤሳ ጌሊስ። ");
INSERT INTO gofENT_vpl VALUES ("HB6_20","088_6_20","HEB","6","20","20","ዬሱሲ ማልኬፃዲቄ ሹማቴꬃዳ ሜሪናው ካሂኔ ሃላቃ ጊዲዲ፥ ኑ ጊሾ ኑፔ ሲንꬃቲዲ ሄ ቤሳ ጌሊስ። ");
INSERT INTO gofENT_vpl VALUES ("HB7_1","088_7_1","HEB","7","1","1","ማልኬፃዲቄይ፥ ሳሌሜ ካዎይ፥ ኡባፌ ቦላ ፆሳ ካሂኔ። ሄ ማልኬፃዲቄይ ኣብራሃሜይ ካዎታ ኦሊ ፆኒዲ ሲሚሺን ኢያራ ጋሄቲዲ ኢያ ኣንጂስ። ");
INSERT INTO gofENT_vpl VALUES ("HB7_2","088_7_2","HEB","7","2","2","ኣብራሃሜይ ባ ዲዒዳባ ኡባፌ ኢያው ኣስራታ ኬሲዲ ኢሚስ። ማልኬፃዲቄ ሱንꬃይ ኮይሮ «ፂሎቴꬃ ካዎ»፥ ናምዓንꬆ፥ «ሳሌሜ ካዎ» ቢርሼꬃይ፥ «ሳሮቴꬃ ካዉዋ» ጉሱ። ");
INSERT INTO gofENT_vpl VALUES ("HB7_3","088_7_3","HEB","7","3","3","ማልኬፃዲቄስ ኣያ ዎይኮ ኣዉ ዎይኮ ዛሬ ፓይዶይ ባዋ። ኢያ ዬሌቴꬃስ ዶሜꬂ ዎይኮ ኢያ ዴዑዋስ ዉርሴꬂ ባዋ፥ ሺን ፆሳ ናዓ ዳኒዲ ሜሪናው ካሂኔ ጊዲስ። ");
INSERT INTO gofENT_vpl VALUES ("HB7_4","088_7_4","HEB","7","4","4","ማልኬፃዲቄይ ኣይ ሜላ ጊቴኮ ቤዒቴ። ኑ ኣዋታ ማይዛይ፥ ኣብራሃሜይ፥ ባ ዴዒዳባፔ ኢያው ኣስራታ ኢሚስ። ");
INSERT INTO gofENT_vpl VALUES ("HB7_5","088_7_5","HEB","7","5","5","ካሂኔ ጊዲያ ሌዌ ዛሬይ ኢስራዔሌ ኣሳፔ፥ ሄሲካ ኣብራሃሜ ዜሬꬂ ጊዲዳ ባንታ ኢሻታፔ ኣስራታ ኤካና ሜላ ሂጌይ ኪቴስ። ");
INSERT INTO gofENT_vpl VALUES ("HB7_6","088_7_6","HEB","7","6","6","ማልኬፃዲቄይ ሌዌ ዛሬ ጊዶና ኢፂኮካ ኣብራሃሜፔ ኣስራታ ኤኪስ፤ ኡፋይሳ ቃሊ ዴዒያ ኣብራሃሜ ኣንጂስ። ");
INSERT INTO gofENT_vpl VALUES ("HB7_7","088_7_7","HEB","7","7","7","ጉꬃይ ጊታን ኣንጄቴይሲ ፓላንꬄና። ");
INSERT INTO gofENT_vpl VALUES ("HB7_8","088_7_8","HEB","7","8","8","ኢሲ ባጋራ፥ ኣስራታ ኤኬይሳቲ ሃይቂያ ኣሳታ፥ ሺን ሃራ ባጋራ ኣስራታ ኤኬይሲ ዴዖን ዴዔስ ያጊዲ ኦዴቲዳይሳ። ");
INSERT INTO gofENT_vpl VALUES ("HB7_9","088_7_9","HEB","7","9","9","ሂዛ፥ ኣስራታ ኤኪያ ሌዌይ፥ ኣብራሃሜ ባጋራ ኣስራታ ኢሚስ ጋናው ዳንዳዔቴስ። ");
INSERT INTO gofENT_vpl VALUES ("HB7_10","088_7_10","HEB","7","10","10","ኣይስ ጊኮ፥ ማልኬፃዲቄይ ኣብራሃሜራ ጋሄቲያ ዎዴ ሌዌይ ዬሌቲቦናባ ጊዲኮካ፥ ባ ማይዛ ኣብራሃሜ ጉልባታን ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("HB7_11","088_7_11","HEB","7","11","11","ኢስራዔሌ ኣሳስ ሂጌይ ሌዌ ካሂኔቴꬃ ባጋራ ኢሜቲስ። ሃ ሌዌ ካሂኔቴꬃይ ፖሎ ጊዲዳባ ጊዲያኮ ኣሮናይሳ ሜላ ጊዶናሺን፥ ማልኬፃዲቄ ሜላ ሃራ ካሂኔ ሹማናው ኣይስ ኮሺዴ? ");
INSERT INTO gofENT_vpl VALUES ("HB7_12","088_7_12","HEB","7","12","12","ሂዛ፥ ካሂኔቲ ላሜቲያ ዎዴ ሂጌይካ ቃሲ ላሜታናው ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("HB7_13","088_7_13","HEB","7","13","13","ሃ ኑ ኢያባ ኦዲያ ኡራይ ሃራ ዛሬ፤ ኢያ ሼሻፔ ኦኒካ ያርሾ ቤሳን ካሂኔቴꬃን ኦꬂቤና። ");
INSERT INTO gofENT_vpl VALUES ("HB7_14","088_7_14","HEB","7","14","14","ኑ ጎዳይ ዪሁዳ ሼሻፔ ዪዳይሲ ኤሬቲዳይሳ። ጊዶሺን፥ ሙሴይ ካሂንቴባ ኦዲሼ ዪሁዳ ዛሪያባ ኣይባካ ኦዲቤና። ");
INSERT INTO gofENT_vpl VALUES ("HB7_15","088_7_15","HEB","7","15","15","ማልኬፃዲቄ ሜላ ሃራ ካሂኔይ ዪዳባ ጊዲያኮ ሃ ኑ ኦዲያባይ ኣꬊ ቆንጫና። ");
INSERT INTO gofENT_vpl VALUES ("HB7_16","088_7_16","HEB","7","16","16","ኢ ካሂኔ ጊዲዳይ ꬋዮና ዴዑዋ ዎልቃናፔ ኣቲን ኢያ ማይዛ ሂጌኒኔ ዎጋን ጊዴና። ");
INSERT INTO gofENT_vpl VALUES ("HB7_17","088_7_17","HEB","7","17","17","ጌሻ ማፃፋይ፥ «ማልኬፃዲቄ ካሂኔቴꬃ ሜላ፥ ኔኒ ሜሪናው ካሂኔ» ያጊዲ ማርካቴስ። ");
INSERT INTO gofENT_vpl VALUES ("HB7_18","088_7_18","HEB","7","18","18","ኮይሮ ሂጌይ ዳቡራንቾኔ ማዶናባ ጊዲያ ጊሾ ሻሬቲስ። ");
INSERT INTO gofENT_vpl VALUES ("HB7_19","088_7_19","HEB","7","19","19","ሙሴ ሂጌይ ኣይቢንካ ፖሎ ኦꬃናው ዳንዳዒቤና። ሺን ኑኒ ኢያ ባጋራ ፆሳኮ ሺቂያ ኡባፌ ኣꬊያ ኡፋይሳ ቃላይ ኑስ ኢሜቲስ። ");
INSERT INTO gofENT_vpl VALUES ("HB7_20","088_7_20","HEB","7","20","20","ኪሪስቶሲ ካሂኔ ጊዲያ ዎዴ ፆሳይ ጫቂስ፥ ሺን ሃራቲ ካሂኔ ጊዲዳ ዎዴ ሄሳ ሜላ ጫቆይ ባዋ። ");
INSERT INTO gofENT_vpl VALUES ("HB7_21","088_7_21","HEB","7","21","21","ሺን ዬሱሲ ጫቆን ካሂኔ ጊዲስ። ፆሳይ ያጊዲ ጫቂስ፤ «ጎዳይ ጫቂስ፤ ኢ ባ ቆፋ ላሜና፤ ‹ኔኒ ሜሪና ካሂኔ› » ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("HB7_22","088_7_22","HEB","7","22","22","ሃ ጫቁዋ ጋሶን ዬሱሲ ኑስ ኡባፌ ኣꬊያ ቃላ ጫቁዋስ ዋሴ ጊዲስ። ");
INSERT INTO gofENT_vpl VALUES ("HB7_23","088_7_23","HEB","7","23","23","ካሂኔቴꬃን ኦꬆና ሜላ ሃይቆይ ኤንታ ዲጊዳ ጊሾ ኮይሮ ካሂኔታ ታይቦይ ዳሮ። ");
INSERT INTO gofENT_vpl VALUES ("HB7_24","088_7_24","HEB","7","24","24","ሺን ዬሱሲ ሜሪናው ዴዒያ ጊሾ ኢያ ካሂኔቴꬃ ሃሪ ላቴና። ");
INSERT INTO gofENT_vpl VALUES ("HB7_25","088_7_25","HEB","7","25","25","ሄሳ ጊሾ፥ ኢ ኡባ ዎዴ ኤንታ ጊሾ ጋናታናው ሜሪናው ዴዒያ ጊሾ ፆሳኮ ኢያ ባጋራ ዬይሳታ ፖሎ ኣሻናው ዳንዳዔስ። ");
INSERT INTO gofENT_vpl VALUES ("HB7_26","088_7_26","HEB","7","26","26","ሂዛ፥ ኑስ ኮሺያባ ኢሚያ፥ ጌሻይ፥ ቦሬይኔ ቱኒ ባይናይሲ፥ ናጋራንቾታፔ ሻኬቲዳይሲኔ ሳሉዋፔ ኣꬊዲ ꬎቂዳ ካሂኔ ሃላቃይ ኑስ ኮሼስ። ");
INSERT INTO gofENT_vpl VALUES ("HB7_27","088_7_27","HEB","7","27","27","ኢ ሃንኮ ካሂኔ ሃላቃታ ሜላ ኮይሮ ባ ናጋራ ጊሾ ካሊዲ ኣሳ ናጋራ ጊሾ ጋላስ ጋላስ ያርሾ ያርሻናው ኮሼና። ኢ ባና ያርሺዳ ዎዴ ዛሬꬆና ኦጌን ኢሲ ቶሆ ባና ያርሺስ። ");
INSERT INTO gofENT_vpl VALUES ("HB7_28","088_7_28","HEB","7","28","28","ሙሴ ሂጌይ ዳቡራንቾ ኣሳ ካሂኔ ሃላቃ ኦꬂዲ ሹሜስ። ሺን ሂጊያፌ ጉዬ ዪዳ ጫቆ ቃላይ ሜሪናው ፖሎ ጊዲዳ ፆሳ ናዓ ሹሚስ። ");
INSERT INTO gofENT_vpl VALUES ("HB8_1","088_8_1","HEB","8","1","1","ኑኒ ሃሳያ ጊታባይ ሄሳ። ሳሉዋን ኡባፌ ቦላ ፆሳ ኣራታፔ ኡሻቻ ባጋን ኡቲዳ ሃይሳ ሜላ ካሂኔ ሃላቃይ ኑስ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("HB8_2","088_8_2","HEB","8","2","2","ኢ ኣሳን ጊዶናሺን ጎዳን ኤቂዳ ቱማ ዱንካኒያን ፆሳ ኬꬃን ኦꬄስ። ");
INSERT INTO gofENT_vpl VALUES ("HB8_3","088_8_3","HEB","8","3","3","ካሂኔ ሃላቃ ኡባይ ኢሞኔ ያርሾ ያርሻናው ሹሜቴስ። ሄሳ ጊሾ፥ ሃ ካሂኔይ ያርሻናው ኢሲባይ ዳናው ኮሼስ። ");
INSERT INTO gofENT_vpl VALUES ("HB8_4","088_8_4","HEB","8","4","4","ሂጌይ ኪቴይሳዳ ያርሺያ ካሂኔቲ ዴዒያ ጊሾ ኪሪስቶሲ ሳዓን ዴዒያባ ጊዲያኮ ካሂኔ ጊዴና። ");
INSERT INTO gofENT_vpl VALUES ("HB8_5","088_8_5","HEB","8","5","5","ኤንቲ ካሂኔቴꬃን ኦꬂያ ዱንካኔይ ሳሎን ዴዔይሳስ ሌሚሶኔ ኩያ። ሙሴይ ዱንካኒያ ኤሲያ ዎዴ ፆሳይ ኢያኮ፥ «ታኒ ኔና ዴሪያ ቦላ ቤሲዳ ሌሚሱዋ ካላዳ ኦꬃ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("HB8_6","088_8_6","HEB","8","6","6","ሺን ዬሱሲ ጊዶ ጊዲዲ ሲጌꬂያ ጫቆይ፥ ኮይሮ ጫቁዋፔ ኣꬌይሳዳ ኢ ኤኪዳ ኦሶይ ኤንታይሳፌ ኣꬌስ። ሄሲ ኤቂዳይ ኣꬊያ ጫቆ ቃላና። ");
INSERT INTO gofENT_vpl VALUES ("HB8_7","088_8_7","HEB","8","7","7","ኮይሮ ጫቁዋን ባሊ ባይናባ ጊዲያኮ ናምዓንꬆ ጫቆ ኮሼና። ");
INSERT INTO gofENT_vpl VALUES ("HB8_8","088_8_8","HEB","8","8","8","ሺን ጎዳይ ኢያ ቦሪዲ፥ ሃይሳዳ ያጊስ፡ «ታኒ ኢስራዔሌ ኣሳራኔ ዪሁዳ ኣሳራ ኦራꬃ ጫቆ ጫቂያ ዎዴይ ያና። ");
INSERT INTO gofENT_vpl VALUES ("HB8_9","088_8_9","HEB","8","9","9","ሄ ጫቆይ ታ ኤንታ ኣዋታ ጊብፄ ቢታፌ ኩሺያ ኦይካዳ፥ ጎቻ ኬሲዳ ዎዴ ኤንታራ ጫቂዳ ጫቁዋ ሜላ ጊዴና። ኤንቲ ታ ጫቁዋን ኣማኔቲቦና ጊሾ ታኒ ኤንታ ዬጋ ኣጋስ ያጌስ ጎዳይ። ");
INSERT INTO gofENT_vpl VALUES ("HB8_10","088_8_10","HEB","8","10","10","ሺን ሂዛፔ ጉዬ ኢስራዔሌ ኣሳራ ታ ጫቃና ጫቆይ ሃይሳ ያጌስ ጎዳይ። ታኒ ታ ሂጊያ ኤንታ ጉጊያን ዎꬃና፤ ኤንታ ዎዛናን ፃፋና። ታኒ ኤንታ ፆሳ ጊዳና፤ ኤንቲካ ታ ኣሴ ጊዳና። ");
INSERT INTO gofENT_vpl VALUES ("HB8_11","088_8_11","HEB","8","11","11","ኤንታፌ ኦኒካ ባ ሾሩዋ ዎይኮ ባ ኢሻ፥ ‹ጎዳ ኤራ› ያጊዲ ታማርሴና። ኤንቲ ጉꬃፌ ጊታ ጋካናው ኡባይ ታና ኤራና። ");
INSERT INTO gofENT_vpl VALUES ("HB8_12","088_8_12","HEB","8","12","12","ታኒ ኤንታ ናቁዋ ኣቶ ጋና፤ ኤንታ ናጋራ ዛራ ቆፒኬ» ያጌስ። ");
INSERT INTO gofENT_vpl VALUES ("HB8_13","088_8_13","HEB","8","13","13","ፆሳይ ሃ ጫቁዋ «ኦራꬂ» ጊዲ ፄጊሼ ኮይሮይሳ ጋልዒሲስ። ሂዛ፥ ጋልዓይኔ ጬጋይ ꬋያ ዎዴይ ጋኪስ። ");
INSERT INTO gofENT_vpl VALUES ("HB9_1","088_9_1","HEB","9","1","1","ኮይሮ ጫቁዋስ ፆሳ ጎይኒያ ዎጋይኔ ሳዓ ፆሳ ኬꬃይ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("HB9_2","088_9_2","HEB","9","2","2","ዱንካኔይ ኤቂስ። ኢያን ፆምፔ ዎꬂያ ኮጫይ፥ ፃርጴዛይኔ ጎዳ ሲንꬃን ዎꬂያ ኡይꬃይ ዴዔስ፤ ሄ ቤሳይ ጌሻ ቤሳ ጌቴቴስ። ");
INSERT INTO gofENT_vpl VALUES ("HB9_3","088_9_3","HEB","9","3","3","ናምዓንꬆ ማጋራጁዋፌ ጉዬ ባጋራ ዴዒያ ቤሳይ ኡባፌ ጌሻ ቤሳ ጌቴቴስ። ");
INSERT INTO gofENT_vpl VALUES ("HB9_4","088_9_4","HEB","9","4","4","ኢያ ጊዶን ኢፃኔ ጩዪሲያ ዎርቃ ሳፂኔይኔ ዎርቃን ሜሼቲዳ ጫቆ ታቦቴይ ዴዔስ። ሄ ጫቆ ታቦቲያን ማናይ ዴዒያ ዎርቃ ፃሮይ፥ ኣጪዳ ኣሮና ፃምዓይኔ ሙሴ ሂጌይ ፃፌቲዳ ናምዑ ሎቼ ሹቻቲ ዴዖሶና። ");
INSERT INTO gofENT_vpl VALUES ("HB9_5","088_9_5","HEB","9","5","5","ሄ ታቦቲያፔ ቦላ ባጋራ ኣቶቴꬃ ካማ ባንታ ቄፊያን ጌንꬂያ ቦንቾ ኪሩቤቲ ዴዖሶና። ሺን ሃዒ ሄ ኡባ ቆንጪሲዲ ኦዳናው ዳንዳዖኮ። ");
INSERT INTO gofENT_vpl VALUES ("HB9_6","088_9_6","HEB","9","6","6","ሃ ኡባይ ሃይሳዳ ጊጊዳፔ ጉዬ፥ ካሂኔቲ ኡባ ዎዴ ባንታ ኦሱዋ ኦꬃናው ዱንካኒያስ ኮይሮ ኪፊሊያ ጌሎሶና። ");
INSERT INTO gofENT_vpl VALUES ("HB9_7","088_9_7","HEB","9","7","7","ሺን ካሂኔ ሃላቃ ፃላሊ ዱንካኒያስ ናምዓንꬆ ኪፊሊያ ላይꬃፌ ኢሲ ቶሆ ጌሌስ። ኢ ያ ጌሊሼ ባ ናጋራ ጊሾኔ ኣሳይ ኤሮና ኦꬂዳ ናጋራ ጊሾ ሱꬃ ያርሾ ኤኮና ጌሌና። ");
INSERT INTO gofENT_vpl VALUES ("HB9_8","088_9_8","HEB","9","8","8","ኮይሮ ዱንካኔይ ኤቂዲ ዴዒሺን፥ ኡባፌ ጌሻ ቤሳ ኤፊያ ኦጌይ ቡሮ ዶዬቲቦናይሳ ጌሻ ኣያናይ ሄሳን ኤሪሴስ። ");
INSERT INTO gofENT_vpl VALUES ("HB9_9","088_9_9","HEB","9","9","9","ሄሲ ሃ ዎዲያስ ሌሚሶ፤ ፆሳስ ኢሜቲያ ኢሞይኔ ያርሾይ ጎይኒያ ኡራ ካሃ ጌሻናው ዳንዳዖናይሳ ሃይሲ ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("HB9_10","088_9_10","HEB","9","10","10","ሄሳቲ ሙሳባ፥ ኡሻባኔ ዱማ ዱማ ሜቻ ዎጋታ ኦዴይሳታ። ኤንቲ ኦራꬃ ዎጋይ ያና ጋካናው ኦሴቲያ ካሬ ባጋ ዎጋታ። ");
INSERT INTO gofENT_vpl VALUES ("HB9_11","088_9_11","HEB","9","11","11","ሺን ኪሪስቶሲ ሃዒ ኑ ዴሚዳ ሎዖባታስ ካሂኔ ሃላቃ ጊዲዲ ዪስ። ኢ ጌሊዳ ዱንካኔይ ጊታኔ ፖሎ ጊዲዳይሳ። ሄ ዱንካኔይ ኣሳ ኩሼን ኦሴቲቤና ቃሲ ሃ ኣላሚያባ ጊዴና። ");
INSERT INTO gofENT_vpl VALUES ("HB9_12","088_9_12","HEB","9","12","12","ኪሪስቶሲ ኡባፌ ጌሻ ቤሳ ጌሊያ ዎዴ ዴሻ ሱꬂኔ ማራ ሱꬂ ኤኪዲ ጌሊቤና። ሺን ሜሪና ኣቶቴꬃ ኢማናው ባ ሱꬃ ኤኪዲ ዛሬꬆና ኦጌን ኢሲ ቶሆ ጌሊስ። ");
INSERT INTO gofENT_vpl VALUES ("HB9_13","088_9_13","HEB","9","13","13","ዴሻ ሱꬃይኔ ኮርማ ሱꬃይ፥ ፁጌቲዳ ኡሳ ቢዶይ፥ ቱኒዳ ኣሳ ቦላ ꬋርጬቲዲ ኤንታና ጌሺያባ ጊዲኮ፥ ");
INSERT INTO gofENT_vpl VALUES ("HB9_14","088_9_14","HEB","9","14","14","ሜሪና ጌሻ ኣያና ባጋራ ቦሬይ ባይና ያርሾ ኦꬂዲ፥ ፆሳስ ባና ኢሚዳ ኪሪስቶሳ ሱꬃይ፥ ዴዖ ፆሳ ጎይናና ሜላ ሃይቆ ካሌꬂያ ኦሱዋፔ ኑ ካሃ ዋቲ ኣꬂ ጌሼኔ? ");
INSERT INTO gofENT_vpl VALUES ("HB9_15","088_9_15","HEB","9","15","15","ሄሳ ጊሾ፥ ፄጌቲዳይሳቲ ፆሳይ ኢሚዳ ሜሪና ላታ ኤካና ሜላ ኪሪስቶሲ ኦራꬃ ጫቁዋስ ጊዶ ጊዲዲ ሲጌꬄይሳ ጊዲስ። ሄሲ ሃኒዳይ ኣሳይ ኮይሮ ጫቁዋፔ ጋርሳን ዴዒያ ዎዴ ኦꬂዳ ናጋራፔ ኤንታና ዎዛናው ኢ ሃይቂዳይሳና። ");
INSERT INTO gofENT_vpl VALUES ("HB9_16","088_9_16","HEB","9","16","16","ሂዛ፥ ኬኬይ ዴዒኮ፥ ሄ ኬኪዳ ኡራ ሃይቆይ ኤሬታናው ኮሼስ። ");
INSERT INTO gofENT_vpl VALUES ("HB9_17","088_9_17","HEB","9","17","17","ኬኪዳ ኡራይ ሃይቂኮ ኢያ ኬኬይ ሚኔስ። ኬኪዳ ኡራይ ሃይቆና ኣቲኮ ኢያ ኬኬይ ኦꬄና። ");
INSERT INTO gofENT_vpl VALUES ("HB9_18","088_9_18","HEB","9","18","18","ሃሪ ኣቶሺን፥ ኮይሮ ጫቆይካ ሱꬂ ባይና ሚኒቤና። ");
INSERT INTO gofENT_vpl VALUES ("HB9_19","088_9_19","HEB","9","19","19","ሙሴይ ሂጌ ኪታ ኡባ ኣሳስ ኦዲዳፔ ጉዬ ማራ ሱꬂኔ ዴሻ ሱꬂ ሃꬃራ ዋላኪዲ፥ ዞዖ ዶርሳ ኢኪሴኔ ሂሶጴ ቦንጮ ኤኪዲ፥ ማፃፋ ቦላኔ ኣሳ ቦላ ዉርፂስ። ");
INSERT INTO gofENT_vpl VALUES ("HB9_20","088_9_20","HEB","9","20","20","ሙሴይ ኣሳኮ፥ «ሂንቴ ናጋና ሜላ ፆሳይ ኪቲዳ ሱꬃ ጫቆይ ሃይሳ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("HB9_21","088_9_21","HEB","9","21","21","ሄሳዳካ፥ ዱንካኒያ ቦላኔ ኦꬂያ ሚሼ ኡባ ቦላ ሱꬃ ዉርፂስ። ");
INSERT INTO gofENT_vpl VALUES ("HB9_22","088_9_22","HEB","9","22","22","ቱማካ ሂጌይ ጌይሳዳ ጉꬃባታፔ ኣቲን ኡባባይ ሱꬃን ጌዬስ። ሱꬂ ጉኮናሺን ኣቶቴꬂ ባዋ። ");
INSERT INTO gofENT_vpl VALUES ("HB9_23","088_9_23","HEB","9","23","23","ሳሉዋባስ ሌሚሶ ጊዲዳይሳቲ ኡባይ ሜሄ ያርሾን ጌያናው ኮሼስ። ሺን ሳሎባቲ ባንታ ሁዔን ሄሳፌ ኣꬊያ ያርሹዋን ጌያናው ኮሼስ። ");
INSERT INTO gofENT_vpl VALUES ("HB9_24","088_9_24","HEB","9","24","24","ኪሪስቶሲ ቱማ ፆሳ ኬꬃስ ሌሚሶ ጊዲዳ፥ ኣሳ ኩሼን ኦሴቲዳ ኡባፌ ጌሻ ቤሳ ጌሊቤና። ሺን ኢ ሃዒ ኑ ጊሾ ፆሳ ሲንꬃን ቤንታናው ሳሉዋ ጌሊስ። ");
INSERT INTO gofENT_vpl VALUES ("HB9_25","088_9_25","HEB","9","25","25","ካሂኔ ሃላቃይ ላይꬃን ላይꬃን ባ ሱꬂ ጊዶናይሳ ኤኪዲ፥ ኡባፌ ጌሻ ቤሳ ጌሌስ። ሺን ኪሪስቶሲ ዳሮ ቶሆ ባና ያርሻናው ሳሎ ጌሊቤና። ");
INSERT INTO gofENT_vpl VALUES ("HB9_26","088_9_26","HEB","9","26","26","ሄሳዳ ሃኒዳባ ጊዲያኮ፥ ኪሪስቶሲ ኣላሜይ ሜꬌቶሳፔ ዶሚዲ ዳሮ ቶሆ ዋዬታናው ኮሼስ። ሺን ሃዒ ዎዲያ ዉርሴꬃን ናጋራ ዲጋናው ባና ያርሺዲ ዛሬꬆና ኦጌን ኢሲ ቶሆ ቤንቲስ። ");
INSERT INTO gofENT_vpl VALUES ("HB9_27","088_9_27","HEB","9","27","27","ኣሲ ኡባይ ኢሲ ቶሆ ሃይቃናው ሄሳፌ ጉዬ ፒርዴታናው ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("HB9_28","088_9_28","HEB","9","28","28","ሄሳዳካ፥ ኪሪስቶሲ ዳሮ ኣሳ ናጋራ ዲጋናው ኢሲ ቶሆ ያርሼቲስ። ሺን ኢ ናጋራ ቶካናው ጊዶናሺን ባና ናጌይሳታ ኣሻናው ናምዓንꬆ ቆንጫና። ");
INSERT INTO gofENT_vpl VALUES ("HB10_1","088_10_1","HEB","10","1","1","ሙሴ ሂጌይ ያናው ዴዒያ ሎዖባታስ ኩያፔ ኣቲን ባ ሁዔን ዋና ጊዴና። ሄሳ ጊሾ፥ ላይꬃን ላይꬃን ፓጬይ ባይና ያርሼቲያ ያርሾይ ጎይናናው ሺቂያ ኣሳ ፖሎ ኦꬃናው ዳንዳዔና። ");
INSERT INTO gofENT_vpl VALUES ("HB10_2","088_10_2","HEB","10","2","2","ሂጌይ ኤንታ ፖሎ ኦꬃናው ዳንዳዒዳባ ጊዲያኮ ኤንቲ ያርሾ ያርሼይሳ ኣጋናሺን። ቃሲ ጎይናናው ሺቂያ ኣሳይ ባንታ ናጋራፔ ጌያና፤ ኤንታ ካሃይካ ኤንታና ባላ ጊዲ ሞቴና። ");
INSERT INTO gofENT_vpl VALUES ("HB10_3","088_10_3","HEB","10","3","3","ሺን ሄ ያርሾቲ ላይꬃን ላይꬃን ናጋራ ቆፊሶሶና። ");
INSERT INTO gofENT_vpl VALUES ("HB10_4","088_10_4","HEB","10","4","4","ኣይስ ጊኮ፥ ኮርማ ሱꬂኔ ዴሻ ሱꬂ ናጋራ ዲጋናው ዳንዳዔና። ");
INSERT INTO gofENT_vpl VALUES ("HB10_5","088_10_5","HEB","10","5","5","ሄሳ ጊሾ፥ ኪሪስቶሲ ሃ ኣላሚያ ዪዳ ዎዴ ሃይሳዳ ያጊስ፡ «ኔኒ ያርሾኔ ኢሞ ኮያባካ፤ ሺን ታው ኣሾ ጊጊሳዳሳ። ");
INSERT INTO gofENT_vpl VALUES ("HB10_6","088_10_6","HEB","10","6","6","ኔኒ ፁጌቲያ ያርሾኒኔ ናጋራ ያርሹዋን ኡፋይታባካ። ");
INSERT INTO gofENT_vpl VALUES ("HB10_7","088_10_7","HEB","10","7","7","ሄ ዎዴ ‹ታ ጊሾ ማፃፋን ፃፌቲዳይሳዳ፥ ጎዳው፥ ታኒ ኔ ሼኒያ ኦꬃናው ያስ› ያጋስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("HB10_8","088_10_8","HEB","10","8","8","ያርሾይ ያርሼታና ሜላ ሂጌይ ኪቲያባ ጊዲኮካ፥ ኪሪስቶሲ ኮይሮ፥ «ኔኒ ያርሾኔ ኢሞ፥ ፁጌቲያ ያርሾኔ ናጋራ ያርሾ ኮያባካ፤ ኤንታን ኡፋይታባካ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("HB10_9","088_10_9","HEB","10","9","9","ካሊዲካ ኢ፥ «ጎዳው፥ ሄኮ ታኒ ኔ ሼኒያ ኦꬃናው ያስ» ያጊስ። ሄሳ ጊሾ፥ ኪሪስቶሲ ናምዓንꬁዋ ኤሳናው ኮይሮይሳ ሻሪስ። ");
INSERT INTO gofENT_vpl VALUES ("HB10_10","088_10_10","HEB","10","10","10","ዬሱስ ኪሪስቶሲ ፆሳ ሼኒያ ኦꬂዲ፥ ዛሬꬆና ኦጌን ኢሲ ቶሆ ባ ኣሹዋ ያርሺዳ ጊሾ ኑኒ ጌዪዳ። ");
INSERT INTO gofENT_vpl VALUES ("HB10_11","088_10_11","HEB","10","11","11","ካሂኔ ኡባይ፥ ናጋራ ዲጋናው ዳንዳዖና ሄ ያርሾታ ጋላስ ጋላስ ያርሺሼ ኤቂዲ ባ ኦሱዋ ኦꬄስ። ");
INSERT INTO gofENT_vpl VALUES ("HB10_12","088_10_12","HEB","10","12","12","ሺን ኪሪስቶሲ ኡባ ዎዴስ ጊዲያ ኢሲ ናጋራ ያርሹዋ ያርሺዲ፥ ፆሳፌ ኡሻቻ ባጋን ኡቲስ። ");
INSERT INTO gofENT_vpl VALUES ("HB10_13","088_10_13","HEB","10","13","13","ሄ ዎዲያፔ ዶሚዲ ኢያ ሞርኬቲ ኢያ ቶሆይ ዬꬊያባ ኦꬃና ጋካናው ናጌስ። ");
INSERT INTO gofENT_vpl VALUES ("HB10_14","088_10_14","HEB","10","14","14","ኢ ዛሬꬆና ኦጌን ኢሲ ቶሆ ባና ያርሺዳ ያርሹዋን ጌሻታ ሜሪናው ፖሎ ኦꬂስ። ");
INSERT INTO gofENT_vpl VALUES ("HB10_15","088_10_15","HEB","10","15","15","ቃሲ ጌሻ ኣያናይ ኑስ ሃይሳ ማርካቴስ። ኮይሮ ሃይሳዳ ያጊስ፡ ");
INSERT INTO gofENT_vpl VALUES ("HB10_16","088_10_16","HEB","10","16","16","«ሄ ጋላሳታፔ ጉዬ፥ ታኒ ኤንታራ ጫቂያ ጫቆይ ሃይሳ፡ ታኒ ታ ሂጊያ ኤንታ ቆፋን ዎꬃና፤ ኤንታ ዎዛናን ፃፋና» ያጌስ። ");
INSERT INTO gofENT_vpl VALUES ("HB10_17","088_10_17","HEB","10","17","17","ካሊዲካ፥ «ታኒ ኤንታ ናጋራኔ ኤንታ ኢታ ኦሱዋ ዛራ ቆፒኬ» ያጌስ። ");
INSERT INTO gofENT_vpl VALUES ("HB10_18","088_10_18","HEB","10","18","18","ሂዛ፥ ናጋሪ ኣቶ ጌቴቲዳፔ ጉዬ ናጋራስ ያርሼቲያ ያርሾ ኮሼና። ");
INSERT INTO gofENT_vpl VALUES ("HB10_19","088_10_19","HEB","10","19","19","ሂዛ፥ ታ ኢሻቶ፥ ኑኒ ዬሱሳ ሱꬃ ባጋራ ኡባፌ ጌሻ ቤሳ ጌላናው ኑስ ሚኖቴꬂ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("HB10_20","088_10_20","HEB","10","20","20","ኑ ጌላናይ ኪሪስቶሲ ባ ማጋራጁዋ፥ ሄሲካ ባ ኣሹዋ ባጋራ ኑስ ዶዪዳ ኦራꬂኔ ዴዖ ጊዲዳ ኦጊያና። ");
INSERT INTO gofENT_vpl VALUES ("HB10_21","088_10_21","HEB","10","21","21","ኑስ ፆሳ ኬꬃ ቦላ ሹሜቲዳ ጊታ ካሂኔ ሃላቃይ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("HB10_22","088_10_22","HEB","10","22","22","ኑኒ ኢታ ካሃፔ ጌያናው ኑ ዎዛና ዉርፄቲዲ፥ ኑ ኣሳቴꬃ ፂሎ ሃꬃን ሜጬቲዲ፥ ሱሬ ዎዛናኒኔ ፖሎ ኣማኖን ፆሳኮ ሺቆስ። ");
INSERT INTO gofENT_vpl VALUES ("HB10_23","088_10_23","HEB","10","23","23","ኑስ ኡፋይሳ ቃላ ኢሚዳ ፆሳይ ኣማንቲዳይሳ ጊዲያ ጊሾ ኑ ማርካቲያ ኡፋይሳ ኡሻቺ ሃዲርሲ ጎና ሚንꬂዲ ኦይኮስ። ");
INSERT INTO gofENT_vpl VALUES ("HB10_24","088_10_24","HEB","10","24","24","ኢሶይ ኢሱዋ ሲቆሲኔ ሎዖ ኦሶስ ዋቲ ዴንꬄꬃኔኮ ኣኔ ቆፖስ። ");
INSERT INTO gofENT_vpl VALUES ("HB10_25","088_10_25","HEB","10","25","25","ኢሶቲ ኢሶቲ ሜዜ ኦꬂዲ ሺቄይሳ ኣጊዳይሳዳ ኑኒ ኢሲፌ ሺቄይሳ ኣጎኮ። ሺን ጎዳ ጋላሳይ ማታቲዳይሳ ሂንቴ ቤዒያ ጊሾ ሄሳ ካሴይሳፌ ኣꬂዲ ኦꬂቴ። ");
INSERT INTO gofENT_vpl VALUES ("HB10_26","088_10_26","HEB","10","26","26","ኑኒ ቱማ ኤራቴꬃ ኤኪዳፔ ጉዬ ኤሪሼ ናጋራ ኦꬂኮ፥ ሂዛፔ ኑ ናጋራ ጊሾ ያርሼታና ያርሾይ ባዋ። ");
INSERT INTO gofENT_vpl VALUES ("HB10_27","088_10_27","HEB","10","27","27","ሺን ሂዛ ኣቲዳይ ያሺያ ፒርዳኔ ፆሳ ሞርኬታ ፁጋናው ጊጊዳ ዎልቃማ ታማ። ");
INSERT INTO gofENT_vpl VALUES ("HB10_28","088_10_28","HEB","10","28","28","ሙሴ ሂጊያ ኪቴቶና ኢፂዳ ኦኒካ ናምዑ ዎይኮ ሄꬑ ኣሲ ኢያ ቦላ ማርካቲኮ ቃꬌይ ባይናሺን ሃይቄስ። ");
INSERT INTO gofENT_vpl VALUES ("HB10_29","088_10_29","HEB","10","29","29","ያቲን፥ ፆሳ ናዓ ካꬊዳ ኡራይ፥ ባና ጌሺዳ ፆሳ ጫቆ ሱꬃ ቱናባዳ ቆፒዳ ኡራይ፥ ቃሲ ኣꬎ ኬሃቴꬃ ኣያና ጫዪዳ ኡራይ፥ ኣይ ሜላ ኢታ ፒርዳ ኤካናው ቤሲያኮ ኣኔ ቆፒቴ። ");
INSERT INTO gofENT_vpl VALUES ("HB10_30","088_10_30","HEB","10","30","30","ሂዛ፥ «ሃሎ ኬሶይ ታባ፥ ታ ኩሼ ዛራና» ጊዳይሳ ኑ ኤሮስ። ቃሲካ፥ «ጎዳይ ባ ኣሳ ፒርዳና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("HB10_31","088_10_31","HEB","10","31","31","ዴዖ ፆሳ ኩሼን ኩንዴꬂ ዳሮ ያሼስ። ");
INSERT INTO gofENT_vpl VALUES ("HB10_32","088_10_32","HEB","10","32","32","ሂንቴው ፆሳ ፖዖይ ፖዒዳፔ ጉዬ ሂንቴ ዳሮ ዋዬን፥ ጊታ ባፄን ጌንጪዳ ቤኒ ዎዲያ ቆፒቴ። ");
INSERT INTO gofENT_vpl VALUES ("HB10_33","088_10_33","HEB","10","33","33","ኢሲ ኢሲ ቶሆ ሂንቴ ኣሳ ሲንꬃን ጫዬቲዴታ፤ ጎዴቲዴታ፤ ኢሲ ኢሲ ቶሆ ሄሳ ሜላ ዋዬይ ጋኪዳ ኣሳራ ኢሲፌ ዋዪዴታ። ");
INSERT INTO gofENT_vpl VALUES ("HB10_34","088_10_34","HEB","10","34","34","ቃሾን ዴዒያ ኣሳስካ ቃꬌቲዴታ። ሂንቴው ሎዖኔ ꬋዮና ሻሎይ ሳሎን ዴዔይሳ ሂንቴ ኤሪዳ ጊሾ ሂንቴ ሻሎይ ቦንቄቲያ ዎዴ ኡፋይሳን ዳንዳዒዴታ። ");
INSERT INTO gofENT_vpl VALUES ("HB10_35","088_10_35","HEB","10","35","35","ሄሳ ጊሾ፥ ጊታ ዎይቶይ ዴዒያ ሂንቴ ሚኖቴꬃ ዬጎፊቴ። ");
INSERT INTO gofENT_vpl VALUES ("HB10_36","088_10_36","HEB","10","36","36","ፆሳ ሼኒያ ፖሊዲ፥ ኢ ሂንቴው ኢማና ጊዳ ኡፋይሳ ኤካና ጋካናው ጌንጫናው ኮሼስ። ");
INSERT INTO gofENT_vpl VALUES ("HB10_37","088_10_37","HEB","10","37","37","ሂዛ፥ ጌሻ ማፃፋን፥ «ኢ፥ ያና ጊዳይሲ ያና፤ ጋምዔና። ");
INSERT INTO gofENT_vpl VALUES ("HB10_38","088_10_38","HEB","10","38","38","ሺን ታ ፂሎይ፥ ታናን ኣማኔቲዲ ዳና፤ ኦኒካ ጉዬ ሲሚኮ ታና ኡፋይሴና» ያጌስ። ");
INSERT INTO gofENT_vpl VALUES ("HB10_39","088_10_39","HEB","10","39","39","ኑኒ ኣማኔቲዲ ኣቲያ ኣሳ ባጋፌ ኣቲን ጉዬ ሲሚዲ ꬋያ ኣሳ ባጋ ጊዶኮ። ");
INSERT INTO gofENT_vpl VALUES ("HB11_1","088_11_1","HEB","11","1","1","ኣማኖይ ጉሳይ፥ ዴማና ጊዲ ኡፋይሳን ኣማኔቲዲ ናጊያባኔ ኑ ቤዖናባ ቤዒያዳ ኦꬂዲ ኤኪያባ። ");
INSERT INTO gofENT_vpl VALUES ("HB11_2","088_11_2","HEB","11","2","2","ቤኒ ኣዋቲ ኣማኖን ፆሳፌ ማርካቴꬂ ኤኪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("HB11_3","088_11_3","HEB","11","3","3","ኣላሜይ ፆሳ ቃላን ሜꬌቲዳይሳ ኑ ኣማኖን ኤሮስ። ቃሲ ቤንቲያባይ ቤንቶናባፔ ሜꬌቲስ። ");
INSERT INTO gofENT_vpl VALUES ("HB11_4","088_11_4","HEB","11","4","4","ኣቤሊ ቃዔላይሳፌ ኣꬊያ ያርሾ ፆሳስ ያርሺዳይ ኣማኖና። ፆሳይ ኣቤላ ኢሙዋ ኡፋይቲዲ ኤኪዳ ዎዴ ኢ ፂሎ ጊዲዳይሳ ማርካቲስ። ኣቤሊ ሃሪ ኣቶሺን፥ ሃይቂዲካ ባ ኣማኑዋን ሃዒ ጋካናው ኦዴስ። ");
INSERT INTO gofENT_vpl VALUES ("HB11_5","088_11_5","HEB","11","5","5","ሄኖኬይ ሃይቆና ሳሎ ቢዳይ ኣማኖና። ፆሳይ ኢያ ኤኪዳ ጊሾ ኦኒካ ኢያ ቤዓናው ዳንዳዒቤና። ሄኖኬይ ሳሎ ኤኬታናፔ ሲንꬄ ኢ ፆሳ ኡፋይሲዳ ኣሲ ጊዴይሲ ኦዴቲስ። ");
INSERT INTO gofENT_vpl VALUES ("HB11_6","088_11_6","HEB","11","6","6","ኣማኖይ ባይና ኦኒካ ፆሳ ኡፋይሳናው ዳንዳዔና። ፆሳኮ ያ ኦኒካ ፆሳይ ዴዔይሳኔ ባና ኮዬይሳታስ ዎይቶ ኢሜይሳ ኣማናናው ኮሼስ። ");
INSERT INTO gofENT_vpl VALUES ("HB11_7","088_11_7","HEB","11","7","7","ኖሄይ ቡሮ ቤንቶናባስ ፆሳይ ኢያው ኦዲዳ ዎዴ ፆሳስ ያዪዲ፥ ባናኔ ባ ሶ ኣሳ ኣሻናው ኣማኖን ማርካቤ ኬፂስ። ያቲዲ ባ ኣማኑዋን ኣላሚያ ፒርዲዲ፥ ኣማኖን ቤንቲያ ፂሎቴꬃ ፆሳፌ ኤኪስ። ");
INSERT INTO gofENT_vpl VALUES ("HB11_8","088_11_8","HEB","11","8","8","ኣብራሃሜይ ላታ ኦꬂዲ ኤካና ቢታ ባና ሜላ ፆሳይ ኢያ ፄጊዳ ዎዴ ሃሪ ኣቶሺን፥ ኢ ኣው ቢያኮ ኤሮና ኢፂኮካ ኪቴቲዳይ ኣማኖና። ");
INSERT INTO gofENT_vpl VALUES ("HB11_9","088_11_9","HEB","11","9","9","ኣብራሃሜይ ፆሳይ ኢያው ኢማና ጊዳ ቢታን ቤቴ ኣሳዳ ዴዒዳይ ኣማኖና። ፆሳይ ሄ ኢማና ጊዳይሳ ኢያራ ኢሲፌ ላታናው ዴዒያ ዪሳቃራኔ ያይቆባራ ዎላ ዱንካኔን ዴዒስ። ");
INSERT INTO gofENT_vpl VALUES ("HB11_10","088_11_10","HEB","11","10","10","ኢ፥ ፆሳይ ቆፒዲ ኬፂዳ ፃላ ባሶይ ዴዒያ ካታማ ናጌስ። ");
INSERT INTO gofENT_vpl VALUES ("HB11_11","088_11_11","HEB","11","11","11","ሳራ ባ ሁዔን ጪሚዳባ ጊዲኮካ ኡፋይሲ ኢሚዳ ፆሳይ ኣማኔቲዳይሳ ጊዴይሳ ኤሪዳ ጊሾ ቃንꬃታናው ዎልቃ ዴሚዳይ ኣማኖና። ");
INSERT INTO gofENT_vpl VALUES ("HB11_12","088_11_12","HEB","11","12","12","ሄሳ ጊሾ፥ ሃይቂዳ ኣሲ ዳኒያ ኢሲ ኣዲያፌ ሳሎ ፆሊንቶ ሜላኔ ኣባ ጋፃን ዴዒያ ታይቦይ ባይና ሻፌ ሜላ ዜሬꬃይ ዬሌቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("HB11_13","088_11_13","HEB","11","13","13","ሄ ኣሳ ኡባይ ባንታው ጌቴቲዳ ኡፋይሳ ቃላ ኤኮና ኣማኖን ሃይቂዶሶና። ሺን ሃሆራ ሄሳ ቤዒዲ፥ ዴሚዳዳ ኦꬂዲ፥ ኡፋይሳን ኤኪዶሶና። ቃሲ ኤንቲ ሳዓን ኢማꬄኔ ቤቴ ኣሲ ጊዴይሳ ኤሪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("HB11_14","088_11_14","HEB","11","14","14","ሄሳዳ ጊያ ኣሳይ ባንታ ቢታ ናጌይሳ ቆንጬን ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("HB11_15","088_11_15","HEB","11","15","15","ኤንቲ ሄ ኣጊዲ ኬዪዳ ቢታ ጉዬ ቆፒዳባ ጊዲያኮ ጉዬ ሲማናው ዳንዳዖሶና። ");
INSERT INTO gofENT_vpl VALUES ("HB11_16","088_11_16","HEB","11","16","16","ሺን ሃዒ ኣꬊ ሎዒያ ሳሎ ቢታ ላሞቶሶና። ሄሳ ጊሾ፥ ፆሳይ ኤንታው ካታማ ጊጊሲዳ ጊሾ «ኤንታ ፆሳ» ጌቴቲዲ ፄጌታናው ዬላቴና። ");
INSERT INTO gofENT_vpl VALUES ("HB11_17","088_11_17","HEB","11","17","17","ኣብራሃሜይ ፓጬቲዳ ዎዴ ዪሳቃ ያርሺዳይ ኣማኖና። ሄ ኡፋይሳ ቃላ ኤኪዳ ኣብራሃሜይ ባ ኢሲ ናዓ ያርሻናው ጊጊስ። ");
INSERT INTO gofENT_vpl VALUES ("HB11_18","088_11_18","HEB","11","18","18","ፆሳይ ኣብራሃሜኮ፥ «ኔ ዜሬꬃይ ዪሳቃ ባጋራ ፄጌታና» ያጊዲ ኦዲስ። ");
INSERT INTO gofENT_vpl VALUES ("HB11_19","088_11_19","HEB","11","19","19","ፆሳይ ሃይቆፔ ዴንꬃናው ዳንዳዔይሳ ኣብራሃሜይ ኣማኒዳ ጊሾ ዪሳቃ ሃይቆፔ ፓፂ ዴንዲዳዳ ኦꬂዲ ዛሪ ኤኪስ። ");
INSERT INTO gofENT_vpl VALUES ("HB11_20","088_11_20","HEB","11","20","20","ዪሳቂ ዎዴፔ ሃናናባ ኤሪዲ ያይቆባኔ ኤሳዌ ኣንጂዳይ ኣማኖና። ");
INSERT INTO gofENT_vpl VALUES ("HB11_21","088_11_21","HEB","11","21","21","ያይቆቢ ሃይቃና ሃኒሼ፥ ኢሲ ኢሲ ዮሴፋ ናይታ ኣንጂዳይኔ ጉፌ ቦላ ካቲዲ ጎይኒዳይ ኣማኖና። ");
INSERT INTO gofENT_vpl VALUES ("HB11_22","088_11_22","HEB","11","22","22","ዮሴፊ ሃይቃናው ማቲዳ ዎዴ ኢስራዔሌ ኣሳይ ጊብፄፌ ኬያናይሳ ኦዲዳይኔ ባ ሜቄꬃ ኦꬃናባ ኤንታ ኪቲዳይ ኣማኖና። ");
INSERT INTO gofENT_vpl VALUES ("HB11_23","088_11_23","HEB","11","23","23","ሙሴይ ዬሌቲዳፔ ጉዬ ኢያ ኣያኔ ኢያ ኣዋይ ማላ ሎዖ ናዓ ጊዲዳይሳ ቤዒዲ ሄꬑ ኣጌና ቆቲዳይ ኣማኖና፤ ኤንቲ ካዉዋ ኣዋጁዋ ያዪቦኮና። ");
INSERT INTO gofENT_vpl VALUES ("HB11_24","088_11_24","HEB","11","24","24","ሙሴይ ዲጪዳፔ ጉዬ ጊብፄ ካዉዋ ናዔ ናዓ ጌቴታናይሳ ኢፂዳይ ኣማኖና። ");
INSERT INTO gofENT_vpl VALUES ("HB11_25","088_11_25","HEB","11","25","25","ሙሴይ ናጋራን ጉꬃ ዎዴስ ኡፋይታናፔ፥ ፆሳ ኣሳራ ዋዬ ኤካናይሳ ዶሪስ። ");
INSERT INTO gofENT_vpl VALUES ("HB11_26","088_11_26","HEB","11","26","26","ኢ ዎዴፔ ዴማና ዎይቱዋ ቲሺ ኦꬂዲ ፄሊዳ ጊሾ ጊብፄ ሻሉዋፔ ኣꬂዲ ኪሪስቶሳ ጊሾ ቦሬታናይሲ ዳሮ ኣꬊያ ዱሬቴꬂ ጊዲዳይሳ ኤሪስ። ");
INSERT INTO gofENT_vpl VALUES ("HB11_27","088_11_27","HEB","11","27","27","ሙሴይ ካዉዋ ሃንቁዋ ያዮና፥ ጊብፄፌ ኬዪዳይ ኣማኖና። ቤንቶና ፆሳ ቤዒዳ ኣሳዳ ሃኒዲ ባ ቆፋን ጌንጪስ። ");
INSERT INTO gofENT_vpl VALUES ("HB11_28","088_11_28","HEB","11","28","28","ሃይቆ ኤሂያ ኪታንቾይ ኢስራዔሌ ኣሳ ባይራ ናይታ ዎꬎና ሜላ ሙሴይ ፋሲካኔ ሱꬃ ዉርፄꬃ ዎጋ ኦꬂዳይ ኣማኖና። ");
INSERT INTO gofENT_vpl VALUES ("HB11_29","088_11_29","HEB","11","29","29","ኢስራዔሌ ኣሳይ ሜላ ቢታራ ሃሙቲያዳ ሃሙቲዲ፥ ዞዖ ኣባ ፒኒዳይ ኣማኖና። ሺን ጊብፄ ኣሳይ ጌላናው ፓጪ ቤዒሺን ሃꬃይ ኤንታ ሚቲስ። ");
INSERT INTO gofENT_vpl VALUES ("HB11_30","088_11_30","HEB","11","30","30","ኢስራዔሌ ኣሳይ ኢያርኮ ካታማ ሹቻ ዲርሳ ላፑን ጋላስ ዩዪዲ፥ ኩንዲሲዳይ ኣማኖና። ");
INSERT INTO gofENT_vpl VALUES ("HB11_31","088_11_31","HEB","11","31","31","ላይሚያ ራዓባ ቢታ ዎቼይሳታ ሞኪዳ ጊሾ ኪቴቶና ኣሳራ ሃይቆና ኣቲዳይ ኣማኖና። ");
INSERT INTO gofENT_vpl VALUES ("HB11_32","088_11_32","HEB","11","32","32","ሂዛ፥ ሃራ ታ ኣይ ጎ? ጌዲዮናባ፥ ባራቃባ፥ ሳምሶናባ፥ ዮፍታሄባ፥ ዳዊቴባ፥ ሳሙዔላባ፥ ቃሲ ናቤታባ ኦዳናው ታው ዎዴይ ጊዴና። ");
INSERT INTO gofENT_vpl VALUES ("HB11_33","088_11_33","HEB","11","33","33","ኤንቲ ኣማኖን ካዎቴꬃታ ፆኒዶሶና፤ ፂሎቴꬃን ኣይሲዶሶና፤ ፆሳይ ኢማና ጊዳ ኡፋይሳ ኤኪዶሶና፤ ጋሞታ ዶና ጎርዲዶሶና፤ ");
INSERT INTO gofENT_vpl VALUES ("HB11_34","088_11_34","HEB","11","34","34","ታማ ዎልቃ ቶይሲዶሶና፤ ሞርካታ ማሻፌ ኣቲዶሶና፤ ባንታ ዳቡራን ሚኒዶሶና፤ ኦላን ዎልቃማ ጊዲዶሶና፤ ኣላጋ ቶራ ጎዲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("HB11_35","088_11_35","HEB","11","35","35","ማጫሳቲ ባንታ ሃይቂዳይሳቲ ሃይቆፔ ፓፂን ኤኪዶሶና። ቃሲ ሃራቲ ኣꬊያ ሃይቆፔ ዴንዱዋ ኤካናው ኮዪዲ ቃሹዋፔ ቢሌታናይሳ ኢፂዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("HB11_36","088_11_36","HEB","11","36","36","ሃራቲ ኣሳን ቦሬቲዲ ሊሶን ጋራፌቲዶሶና፤ ሃራቲ ሳንꬃላታን ቃሼቲዲ ቃሾ ኬꬃን ዬጌቲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("HB11_37","088_11_37","HEB","11","37","37","ኤንቲ ሱቻን ጫዴቲዶሶና፤ ማጋዜን ናምዓ ኬዪዲ ጳልቄቲዶሶና፤ ፓጬቲዶሶና፤ ማሻን ሃይቂዶሶና፤ ኤንታው ኡባባይ ꬋዪን ሜቶቲዶሶና። ዶርሳ ኢቴኔ ዴሻ ኢቴ ማዒዲ ዩዪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("HB11_38","088_11_38","HEB","11","38","38","ኤንታው ሃ ኣላሜይ ጊጎና ኢፂን ባዞ ቢታን፥ ዴሬ ቦላ፥ ጎንጎሎኒኔ ኦላ ጊዶን ዩዪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("HB11_39","088_11_39","HEB","11","39","39","ፆሳይ ኤንታ ኣማኑዋባ ማርካቲኮካ፥ ሄ ኡባይ ጌቴቲዳ ኡፋይሳ ቃላ ኤኪቦኮና። ");
INSERT INTO gofENT_vpl VALUES ("HB11_40","088_11_40","HEB","11","40","40","ፆሳይ ኑስ ሎዖባ ቆፒ ዎꬂዳ ጊሾ ኤንቲ ኑኒ ባይና ፖሎ ጊዶኮና። ");
INSERT INTO gofENT_vpl VALUES ("HB12_1","088_12_1","HEB","12","1","1","ሂዛ፥ ሻራዳ ኑ ዩሹዋን ዳሪዳ ሃይሳ ሜላ ማርካቲ ኑ ማታን ዴዒያ ጊሾ ኑና ꬉቢያ ኡባኔ ኦይኪዲ ሃሪያ ናጋራ ዲጊዲ፥ ኑ ሲንꬃን ዴዒያ ጋዴ ዎꬃ ጌንጫን ዎፆስ። ");
INSERT INTO gofENT_vpl VALUES ("HB12_2","088_12_2","HEB","12","2","2","ኑ ኣማኑዋስ ኦጌ ዶዪዳይሳኔ ኑ ዉርሴꬃ ፖሉዋኮ ኑና ጋꬂያ ዬሱሳ ቦላ ኑ ኣይፊያ ዎꬆስ። ዬሱሲ ዎዴፔ ዴዒያ ኡፋይሳ ጊሾ ማስቃሊያ ዋያ ዳንዳዒዲ፥ ዬላ ሃይቁዋ ካꬊዲ፥ ፆሳፌ ኡሻቻ ባጋን ኡቲስ። ");
INSERT INTO gofENT_vpl VALUES ("HB12_3","088_12_3","HEB","12","3","3","ሂዛ፥ ሂንቴ ዶጪዲ ኡፋይሲ ቃንፆና ሜላ ናጋራንቾታ ኢፁዋ ዳንዳዒዳ ዬሱሳ ቆፒቴ። ");
INSERT INTO gofENT_vpl VALUES ("HB12_4","088_12_4","HEB","12","4","4","ናጋራራ ዴዒያ ባፂያን ቡሮ ሱꬁ ጉሳና ጋካናው ኤቄቲቤኬታ። ");
INSERT INTO gofENT_vpl VALUES ("HB12_5","088_12_5","HEB","12","5","5","ፆሳይ ባ ቃላን፥ ባ ናይታዳ ሂንቴና ዞሪዳይሳ ዶጊዴታ። «ታ ናዓው፥ ፆሳ ሴራ ሌቆፋ፤ ኢ ኔና ሴሪያ ዎዴ ኡፋይሲ ቃንፆፋ። ");
INSERT INTO gofENT_vpl VALUES ("HB12_6","088_12_6","HEB","12","6","6","ጎዳይ ባ ዶሲያ ኡራ ሴሬስ፤ ቃሲ ባ ናዓዳ ኤኪያ ኡባ ጋራፌስ» ያጌስ። ");
INSERT INTO gofENT_vpl VALUES ("HB12_7","088_12_7","HEB","12","7","7","ፆሳይ ሂንቴና ባ ናይታዳ ሴሪያ ዎዴ ጌንጪቴ፤ ኣዋይ ሴሮና ናዒ ኦኔ? ");
INSERT INTO gofENT_vpl VALUES ("HB12_8","088_12_8","HEB","12","8","8","ፆሳይ ባ ናይታ ኡባ ሴሬስ፤ ሂንቴ ሴሬቶና ኢፂኮ ቱማ ኢያ ናይታ ጊዶናሺን ባላኮ ናይታ። ");
INSERT INTO gofENT_vpl VALUES ("HB12_9","088_12_9","HEB","12","9","9","ቃሲ ኑና ዬሊዳ ኑ ኣዋቲ ኑና ሴሮሶና፤ ኑካ ኤንታና ቦንቾስ። ያቲን፥ ኑኒ ኑ ኣያና ኣዋስ ዋኒዲ ኣꬂ ሃሬቶኮ? ");
INSERT INTO gofENT_vpl VALUES ("HB12_10","088_12_10","HEB","12","10","10","ሂዛ፥ ኑ ኣዋቲ ባንታው ሎዖ ዳኒዳ ሜላ ጉꬃ ዎዴስ ኑና ሴሪዶሶና። ሺን ፆሳይ ኑ ጎዓስ፥ ኑ ኢያ ጌሻቴꬃን ሻኬታና ሜላ ሴሬስ። ");
INSERT INTO gofENT_vpl VALUES ("HB12_11","088_12_11","HEB","12","11","11","ኑኒ ሴሬቲያ ዎዴ ዪሎዬሲፔ ኣቲን ኡፋይሴና። ሺን ጉዬፔ ሴሬቴꬃ ሜዜቲዳ ኣሳስ ሴራይ፥ ሳሮይ ኩሚዳ ፂሎቴꬃ ኣይፌ ኣይፊሴስ። ");
INSERT INTO gofENT_vpl VALUES ("HB12_12","088_12_12","HEB","12","12","12","ሂዛ፥ ሂንቴ ኣርጋጪዳ ቄሲያኔ ሂንቴ ዳቡሪዳ ጉልባታ ሚንꬂቴ። ");
INSERT INTO gofENT_vpl VALUES ("HB12_13","088_12_13","HEB","12","13","13","ዎቤይ ፓፃና ሜላፔ ኣቲን ኣꬂ ሜቆና ሜላ ሂንቴ ቶሁዋስ ሱሬ ኦጌ ጊጊሲቴ። ");
INSERT INTO gofENT_vpl VALUES ("HB12_14","088_12_14","HEB","12","14","14","ኣሳ ኡባራ ሳሮ ዳናዉኔ ጌሻቴꬃን ዳናው ሚኒቴ፤ ጌሻቴꬂ ባይና ኦኒካ ጎዳ ቤዓናው ዳንዳዔና። ");
INSERT INTO gofENT_vpl VALUES ("HB12_15","088_12_15","HEB","12","15","15","ሂንቴፌ ኦዴስካ ፆሳ ኣꬎ ኬሃቴꬃይ ፓጮናዳ፥ ቃሲ ጫሞ ኣይፌ ኣይፊዲ ዳሮ ኣሳ ቱኒሲያኔ ꬋይሲያ ዜሬꬃዳ ጊዶና ሜላ ናጌቲቴ። ");
INSERT INTO gofENT_vpl VALUES ("HB12_16","088_12_16","HEB","12","16","16","ሂንቴ ጊዶን ላይማቲያ ኣሲ ዎይኮ ኢሲ ቶሆ ሚያ ካꬃስ ባ ባይራቴꬃ ቶቺዲ ባይዚዳ ኤሳዌ ሜላ ኣሲ ዶና ሜላ ናጌቲቴ። ");
INSERT INTO gofENT_vpl VALUES ("HB12_17","088_12_17","HEB","12","17","17","ጉዬፔ ኤሳዌይ ሄ ኣንጁዋ ኤካናው ኮዪዳ ዎዴ ዲጌቲዳይሳ ኤሬታ። ኢ ሄ ኣንጁዋ ኣፉꬃን ሚኒዲ ኮይኮካ፥ ዴማናው ዳንዳዒቤና፤ ኢ ናጋራፔ ሲማናው ቃዳ ዴሚቤና። ");
INSERT INTO gofENT_vpl VALUES ("HB12_18","088_12_18","HEB","12","18","18","ሂንቴ ኩሼን ቦሼቲያ ሲና ዴሪያኮ፥ ኤፂያ ታማኮ፥ ꬉማኮ፥ ጫጋናኮ፥ ጎቲያኮ፥ ");
INSERT INTO gofENT_vpl VALUES ("HB12_19","088_12_19","HEB","12","19","19","ሞይዚያ ዋሱዋኮ ዎይኮ ቃላይ ሲዔቲያ ቤሳኮ ዪቤኬታ። ሄ ቃላ ሲዒዳ ኣሳይ ሃራ ጉዣ ቃላ ሲዖና ሜላ ዎሲዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("HB12_20","088_12_20","HEB","12","20","20","ኣይስ ጊኮ፥ «ሃሪ ኣቶሺን፥ ዶዒ ሄ ዴሪያ ቦቺኮ፥ ሹቻን ጫዴቲዲ ሃይቆ» ያጊዳ ኪታ ኤንቲ ቶካናው ዳንዳዒቦኮና። ");
INSERT INTO gofENT_vpl VALUES ("HB12_21","088_12_21","HEB","12","21","21","ሄ ሃኒያባይ ዳሮ ዳጋንꬂያባ ጊዲዳ ጊሾ ሙሴይ፥ «ታኒ ያሻን ኮኮራስ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("HB12_22","088_12_22","HEB","12","22","22","ሺን ሂንቴ ፂዮኔ ዴሪያኮ፥ ዴዖ ፆሳይ ዴዒያ ዬሩሳላሜ ካታማኮ፥ ኢሲፌ ሺቂዲ ኡፋይቲያ ዳሮ ሙኩሉ ኪታንቾታኮ ሳሉዋ ዪዴታ። ");
INSERT INTO gofENT_vpl VALUES ("HB12_23","088_12_23","HEB","12","23","23","ኤንታ ሱንꬃይ ሳሎን ፃፌቲዳ ዎሳ ኬꬃ ባይራ ናይታኮ፥ ኣሳ ኡባ ፒርዲያ ፆሳኮ፥ ፖሎ ጊዲዳ ፂሎ ኣሳ ኣያናታኮ ዪዴታ። ");
INSERT INTO gofENT_vpl VALUES ("HB12_24","088_12_24","HEB","12","24","24","ኦራꬃ ጫቁዋስ ጊዶ ጊዲዲ ሲጌꬂያ ዬሱሳኮ፥ ኣቤላ ሱꬃፌ ኣꬊያባ ኦዲያ ዉርፄቲዳ ሱꬃኮ ዪዴታ። ");
INSERT INTO gofENT_vpl VALUES ("HB12_25","088_12_25","HEB","12","25","25","ሂንቴው ኦዲያ ኡራ ቃላ ኢፃስ ጎና ሜላ ናጌቲቴ። ካሴይሳቲ ሳዓን ጊዲዲ ኦዲዳ ኪታ ሲዖና ኢፂዲ ኣቲቦናባ ጊዲኮ ያቲን፥ ሳሎን ጊዲዲ ኦዲያ ቃላ ኑኒ ኢፃስ ጊኮ ዋኒዲ ኣታኔ? ");
INSERT INTO gofENT_vpl VALUES ("HB12_26","088_12_26","HEB","12","26","26","ሄ ዎዴ ኢያ ቃላይ ሳዓ ቃꬂስ። ሺን ሃዒ ታኒ፥ «ሳዓ ፃላላ ጊዶናሺን ኢሲ ቶሆ ዛራዳ ሳሉዋካ ቃꬃና» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("HB12_27","088_12_27","HEB","12","27","27","«ኢሲ ቶሆ ዛራዳ» ጊያ ቃላይ ቃፆኖባይ ሚኒዲ ዳና ሜላ ቃፂያ ሜꬌቲዳባቲ ꬋያናይሳ ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("HB12_28","088_12_28","HEB","12","28","28","ኑኒ ቃፃናው ዳንዳዖና ካዎቴꬃ ኤኪያ ጊሾ ፆሳ ጋላቶስ፤ ፆሳ ኡፋይሲያ ኦጌን ቦንቾኒኔ ያሻቴꬃን ኢያ ጎይኖስ። ");
INSERT INTO gofENT_vpl VALUES ("HB12_29","088_12_29","HEB","12","29","29","ሂዛ፥ ኑ ፆሳይ ቱማ ፁጊያ ታማ። ");
INSERT INTO gofENT_vpl VALUES ("HB13_1","088_13_1","HEB","13","1","1","ኣማኒያ ኣሳዳ ኢሶይ ኢሱዋራ ፖሎ ሲቄቲቴ። ");
INSERT INTO gofENT_vpl VALUES ("HB13_2","088_13_2","HEB","13","2","2","ኢማꬄ ሞኬይሳ ዶጎፒቴ። ኢሲ ኢሲ ኣሳቲ ሄሳዳ ኦꬂሼ ኤሮና ኪታንቾታ ሞኪዶሶና። ");
INSERT INTO gofENT_vpl VALUES ("HB13_3","088_13_3","HEB","13","3","3","ቃሾን ዴዔይሳታ ሂንቴካ ኤንታራ ኢሲፌ ቃሾን ዴዒያዳ ኦꬂዲ ኤንታና ቆፒቴ። ዋዬ ኤኪያ ኣሳራ ኢሲፌ ሂንቴካ ዋዬ ኤኪያዳ ኦꬂዲ ኤንታና ቆፒቴ። ");
INSERT INTO gofENT_vpl VALUES ("HB13_4","088_13_4","HEB","13","4","4","ኤኮይኔ ጌሎይ ኣሳ ኡባ ማታን ቦንቼቲዳባ ጊዶ። ቃሲ ፆሳይ ላይማቴይሳታኔ ላሜይሳታ ፒርዳናው ዴዒያ ጊሾ ኣዚናይኔ ማቺያ ኢሶይ ኢሱዋስ ኣማኔታናው ቤሴስ። ");
INSERT INTO gofENT_vpl VALUES ("HB13_5","088_13_5","HEB","13","5","5","ሚሼ ሲቆፔ ሂንቴና ናጊቴ፤ ሂንቴው ዴዒያባን ኣሊቴ። ፆሳይ፥ «ታኒ ኔና ኡባራካ ዬጊኬ ዎይኮ ኣጊኬ» ያጊስ። ");
INSERT INTO gofENT_vpl VALUES ("HB13_6","088_13_6","HEB","13","6","6","ሄሳ ጊሾ፥ ኑኒ ኣማኔቲዲ፥ «ጎዳይ ታና ማዴይሳ፤ ታ ያዪኬ፤ ኣሲ ታና ኣይ ኦꬃኔ?» ያጎስ። ");
INSERT INTO gofENT_vpl VALUES ("HB13_7","088_13_7","HEB","13","7","7","ፆሳ ቃላ ኮይሮ ሂንቴው ኦዲዳ ሂንቴና ካሌꬄይሳታ ቆፒቴ። ኤንቲ ዋኒዲ ዴዒዳኮ ኤንታ ዱሳ ቤዒዲ ኤንታ ኣማኑዋ ካሊቴ። ");
INSERT INTO gofENT_vpl VALUES ("HB13_8","088_13_8","HEB","13","8","8","ዬሱስ ኪሪስቶሲ ዚኔካ ሃቺካ ሜሪናዉካ ላሜቴና። ");
INSERT INTO gofENT_vpl VALUES ("HB13_9","088_13_9","HEB","13","9","9","ዱማ ዱማ ኦራꬃ ቲሚርቴን ሃራሶ ቢዲ ꬋዮፒቴ፤ ቦፒቴ። ኑ ዎዛናይ ፆሳ ኣꬎ ኬሃቴꬃን ሚናናው ቤሴስፔ ኣቲን ሚን ጎዖና ካꬃን ዎጋ ፖሎን ጊዶፖ። ");
INSERT INTO gofENT_vpl VALUES ("HB13_10","088_13_10","HEB","13","10","10","ሺን ዱንካኒያ ጊዶን ኦꬂያ ካሂኔቲ ሄ ያርሾ ካꬃፌ ማናው ኤንታው ማቲ ባይና ያርሾ ቤሳይ ኑስ ዴዔስ። ");
INSERT INTO gofENT_vpl VALUES ("HB13_11","088_13_11","HEB","13","11","11","ካሂኔ ሃላቃይ ናጋራ ያርሾስ ሜሄ ሱꬂ ኤኪዲ ያርሻናው ኡባፌ ጌሻ ቤሳ ጌሌስ። ሺን ሄ ሜሂያ ኣሹዋ ዲርሳፌ ካሬን ፁጌስ። ");
INSERT INTO gofENT_vpl VALUES ("HB13_12","088_13_12","HEB","13","12","12","ሄሳዳካ፥ ዬሱሲ ዴሪያ ናጋራፔ ባ ሱꬃን ጌሻናው ካታማ ፔንጊያፌ ካሬን ዋዬቲስ። ");
INSERT INTO gofENT_vpl VALUES ("HB13_13","088_13_13","HEB","13","13","13","ሂዛ፥ ኑኒ ቦሪያ ቶኪዲ ዲርሳፌ ካሬ ኢያኮ ኬዮስ። ");
INSERT INTO gofENT_vpl VALUES ("HB13_14","088_13_14","HEB","13","14","14","ሂዛ፥ ኑስ ሃይሳን ሜሪናው ዴዒያ ካታሚ ባዋ፥ ሺን ኑኒ ያና ካታማ ናጎስ። ");
INSERT INTO gofENT_vpl VALUES ("HB13_15","088_13_15","HEB","13","15","15","ሂዛ፥ ዬሱሳ ባጋራ ኡባ ዎዴ ኢያ ሱንꬃስ ማርካቲያ ሜቴርሻ ጋላታ ያርሾ ፆሳስ ኢሞስ። ");
INSERT INTO gofENT_vpl VALUES ("HB13_16","088_13_16","HEB","13","16","16","ሎዖባ ኦሶኔ ሂንቴው ዴዒያባፔ ሜቶቲዳ ኣሳስ ኢሞ ዶጎፒቴ። ሂዛ፥ ሄሳ ሜላ ያርሾይ ፆሳ ኡፋይሴስ። ");
INSERT INTO gofENT_vpl VALUES ("HB13_17","088_13_17","HEB","13","17","17","ሂንቴና ካሌꬄይሳታስ ኪቴቲቴ፤ ኤንቲ ጊያባ ኦꬂቴ። ኤንቲ ባንታ ኦꬂያባስ ፆሳ ሲንꬃን ኦይሼታናው ዴዒያ ጊሾ ሂንቴና ሄሞሶና። ሂንቴ ኤንታው ኪቴቲኮ፥ ባንታ ኦሱዋ ኡፋይቲዲ ኦꬃና፤ ሄሲ ሃኖና ኢፂኮ፥ ኤንቲ ኣዛኒሼ ኦꬃና፤ ሄሲ ሂንቴና ኣይቢባካ ማዴና። ");
INSERT INTO gofENT_vpl VALUES ("HB13_18","088_13_18","HEB","13","18","18","ኑስ ፆሳ ዎሲቴ። ኑ ካሃይ ጌሺ፤ ኑ ኡባ ዎዴ ሎዖባ ኦꬃናው ኮዮስ። ");
INSERT INTO gofENT_vpl VALUES ("HB13_19","088_13_19","HEB","13","19","19","ታኒ ሂንቴኮ ኤሌሳዳ ያና ሜላ ሂንቴ ታው ሚንꬂዲ ፆሳ ዎሳና ሜላ ታ ሂንቴና ሃዳራ ጋይስ። ");
INSERT INTO gofENT_vpl VALUES ("HB13_20","088_13_20","HEB","13","20","20","ሳሮቴꬃ ፆሳይ፥ ዶርሳ ሄሚያ ኑ ጎዳ ዬሱሳ፥ ባ ሜሪና ጫቆ ሱꬃን ሃይቆፔ ዴንꬂዳይሲ፥ ");
INSERT INTO gofENT_vpl VALUES ("HB13_21","088_13_21","HEB","13","21","21","ኢያ ሼኒያ ኦꬃና ሜላ ሎዖባ ኡባን ኢ ሂንቴና ዳንጪሶ። ኢያ ኡፋይሲያባ ዬሱስ ኪሪስቶሳ ባጋራ ኑናን ፆሳይ ኦꬆ። ዬሱስ ኪሪስቶሳ ባጋራ ፆሳስ ሜሪናፔ ሜሪና ጋካናው ቦንቾይ ጊዶ። ኣሚንዒ። ");
INSERT INTO gofENT_vpl VALUES ("HB13_22","088_13_22","HEB","13","22","22","ታ ኢሻቶ፥ ታ ሃ ዳብዳቢያ ሂንቴው ቃንꬃን ፃፊዳ ጊሾ ሂንቴ ታ ዞሪያ ሳሌቶና ኤካና ሜላ ታ ሂንቴና ዎሳይስ። ");
INSERT INTO gofENT_vpl VALUES ("HB13_23","088_13_23","HEB","13","23","23","ኑ ኢሻይ፥ ፂሞቲዮሲ ቃሾፔ ቢሌቲዳይሳ ኤሪቴ። ኢ ኤሌሲዲ ታኮ ዪኮ ታ ኢያራ ሂንቴና ባዳ ቤዓና። ");
INSERT INTO gofENT_vpl VALUES ("HB13_24","088_13_24","HEB","13","24","24","ሂንቴና ካሌꬄይሳታኔ ኣማኒያ ኡባ ሳሮ ጊቴ። ፃሌፔ ዪዳ ኣማኒያ ኣሳይ ሂንቴና ሳሮ ያጎሶና። ");
INSERT INTO gofENT_vpl VALUES ("HB13_25","088_13_25","HEB","13","25","25","ፆሳ ኣꬎ ኬሃቴꬃይ ሂንቴ ኡባራ ጊዶ። ኣሚንዒ። ");
INSERT INTO gofENT_vpl VALUES ("JM1_1","089_1_1","JAS","1","1","1","ፆሳኔ ጎዳ ዬሱስ ኪሪስቶሳ ኣይሌይ፥ ያይቆቢ፥ ቢታ ኡባን ላሌቲዳ ታማኔ ናምዑ ሼሻታስ ኪቲዳ ኪታ። ሳሮ፥ ኣይ ሜላ ዴዔቲ? ");
INSERT INTO gofENT_vpl VALUES ("JM1_2","089_1_2","JAS","1","2","2","ታ ኢሻቶ፥ ሂንቴና ዱማ ዱማ ፓጬይ ጋኪያ ዎዴ ሂንቴ ሎዖባ ዴሚዳዳ ኩሜꬃ ኡፋይሳን ኤኪቴ። ");
INSERT INTO gofENT_vpl VALUES ("JM1_3","089_1_3","JAS","1","3","3","ሂንቴ ኣማኑዋ ፓጬቴꬃይ ዳንዳዓ ሂንቴው ኢሜይሳ ኤሬታ። ");
INSERT INTO gofENT_vpl VALUES ("JM1_4","089_1_4","JAS","1","4","4","ሂንቴ ዉርሴꬂ ጋካናው ዳንዳዒኮ ኣይቢ ፓጬይ ባይና ፖሎኔ ኩሜꬂ ጊዴታ። ");
INSERT INTO gofENT_vpl VALUES ("JM1_5","089_1_5","JAS","1","5","5","ሂንቴፌ ኦዴስካ ጪንጫቴꬂ ꬋዪኮ ፆሳ ዎሶ። ኢያው ኢሜታና። ፆሳይ ኦናካ ቦሮና ኡባስ ኬሃቴꬃን ኢሚያ ፆሴ። ");
INSERT INTO gofENT_vpl VALUES ("JM1_6","089_1_6","JAS","1","6","6","ሺን ኢ ዎሲያ ዎዴ ሲꬎና ኣማኖን ፆሳ ዎሶ። ሲꬊያ ኦኒካ ጫርኮይ ሱጊን ቃፂያ ኣባ ዙሌ ሜላ። ");
INSERT INTO gofENT_vpl VALUES ("JM1_7","089_1_7","JAS","1","7","8","ናምዑ ቆፊ ዴዔይኔ ባ ኦጊያን ኤቆና ኦኒካ ጎዳፔ ኣይኮካ ዴማና ጊዲ ቆፖፎ። ");
INSERT INTO gofENT_vpl VALUES ("JM1_9","089_1_9","JAS","1","9","9","ኣማኒያ ማንቆ ኣሳቲ፥ ፆሳይ ኤንታና ꬎቁ ኦꬂያ ዎዴ ኡፋይቶ። ");
INSERT INTO gofENT_vpl VALUES ("JM1_10","089_1_10","JAS","1","10","10","ቃሲ ኣማኒያ ዱሬ ኣሳቲ ፆሳይ ኤንታና ዚቂ ኦꬂያ ዎዴ ኡፋይቶ። ዱሬ ኣሳቲ ጪሻዳ ꬋያና። ");
INSERT INTO gofENT_vpl VALUES ("JM1_11","089_1_11","JAS","1","11","11","ኣዋይ ባ ሚሻራ ኬዪዲ ማታ ሜሊሲን፥ ጪሻይ ቆሌቴስ፤ ኢያ ሎዖቴꬃይካ ꬋዬስ። ሄሳዳካ፥ ዱሬ ኣሳቲ ባንታ ኦሱዋን ዳቡሪሼ ꬋያና። ");
INSERT INTO gofENT_vpl VALUES ("JM1_12","089_1_12","JAS","1","12","12","ሜቱዋ ፆኒዲ ኣꬊዳፔ ጉዬ፥ ፆሳይ ባና ሲቄይሳታስ ኢማና ጊዲ ቃላ ጌሊዳ ዴዖ ካላቻ ኤካና ጊሾ ሜቶን ጌንጪያ ኣሲ ኣንጄቲዳይሳ። ");
INSERT INTO gofENT_vpl VALUES ("JM1_13","089_1_13","JAS","1","13","13","ኦኒካ ፓጬቲያ ዎዴ «ታና ፆሳይ ፓጬስ» ጎፖ። ፆሳይ ኢታን ፓጬቴና፤ ቃሲ ኢ ኦናካ ፓጬና። ");
INSERT INTO gofENT_vpl VALUES ("JM1_14","089_1_14","JAS","1","14","14","ሺን ኢሲ ኢሲ ኣሲ ባ ኢታ ኣሙዋን ጎሼቲያ ዎዴኔ ጪሜቲያ ዎዴ ፓጬቴስ። ");
INSERT INTO gofENT_vpl VALUES ("JM1_15","089_1_15","JAS","1","15","15","ሄሳፌ ጉዬ፥ ኣሞቴꬂ ቃንꬃቲዲ ናጋራ ዬሌስ፤ ቃሲ ናጋሪ ዲጪዲ ሃይቆ ዬሌስ። ");
INSERT INTO gofENT_vpl VALUES ("JM1_16","089_1_16","JAS","1","16","16","ታ ሲቆ ኢሻቶ፥ ጪሜቶፊቴ። ");
INSERT INTO gofENT_vpl VALUES ("JM1_17","089_1_17","JAS","1","17","17","ሎዖ ኢሞይኔ ኩሜꬃ ኣንጆ ኡባይ ሳሎፔኔ ሳሉዋ ፖዑዋ ሜꬊዳ ፆሳ ኣዋፔ ዬስ። ፆሳይ ኩያዳ ኡባ ዎዴ ላሜቴና። ");
INSERT INTO gofENT_vpl VALUES ("JM1_18","089_1_18","JAS","1","18","18","ኑኒ፥ ኢያ ሜꬌቴꬃስ ኮይሮ ጊዳና ሜላ ኑና ቱማ ቃላን ባ ሼኔን ዬሊስ። ");
INSERT INTO gofENT_vpl VALUES ("JM1_19","089_1_19","JAS","1","19","19","ታ ሲቆ ኢሻቶ፥ ሃይሳ ኣኬኪቴ። ኣሲ ኡባይ ሲዓናው ኤሌሶ፥ ሺን ኦዴታናዉኔ ሃንቄታናው ኤሌሶፖ። ");
INSERT INTO gofENT_vpl VALUES ("JM1_20","089_1_20","JAS","1","20","20","ኣሳ ሃንቆይ ፆሳይ ኮያ ፂሎቴꬃ ኤሄና። ");
INSERT INTO gofENT_vpl VALUES ("JM1_21","089_1_21","JAS","1","21","21","ሄሳ ጊሾ፥ ቱና ሃኖታኔ ኢታቴꬃ ኡባ ዲጊዲ፥ ፆሳይ ሂንቴ ዎዛናን ቶኪዳ ሂንቴ ሼምፑዋ ኣሻናው ዳንዳዒያ ቃላ ኣዳቴꬃን ኤኪቴ። ");
INSERT INTO gofENT_vpl VALUES ("JM1_22","089_1_22","JAS","1","22","22","ሺን ፆሳ ቃላ ኦሶን ፔሺቴፔ ኣቲን ሲሳ ፃላላን ሂንቴና ጪሞፊቴ። ");
INSERT INTO gofENT_vpl VALUES ("JM1_23","089_1_23","JAS","1","23","23","ቃላ ሲዒዲ ኦꬆና ኣሲ፥ ኢ ባ ሶምዑዋ ማስቶቴን ቤዒያ ኣሳ ሜላ። ");
INSERT INTO gofENT_vpl VALUES ("JM1_24","089_1_24","JAS","1","24","24","ኢ ባ ሶምዑዋ ቤዒዲ ቤስ፥ ሺን ኢ ኣይ ዳኒያኮ ኤሌሲ ዶጌስ። ");
INSERT INTO gofENT_vpl VALUES ("JM1_25","089_1_25","JAS","1","25","25","ሺን ኦኒካ ኣይሌቴꬃፌ ኬሲያ ፖሎ ሂጊያ ኣኬካን ቤዒዲ፥ ካሊዲ ናጌይ፥ ሲዒዳይሳ ዶጎና ኦሶን ፔሺያ ኡራይ፥ ባ ኦሶ ኡባን ኣንጄታና። ");
INSERT INTO gofENT_vpl VALUES ("JM1_26","089_1_26","JAS","1","26","26","ባ ኢንፃርሳ ናጎና ኣማናይስ ጊያ ኡራይ ባና ጪሜስ፤ ኢያ ኣማኖይ ሃዳ። ");
INSERT INTO gofENT_vpl VALUES ("JM1_27","089_1_27","JAS","1","27","27","ፆሳ ኣዋ ሲንꬃን ቦሬይ ባይና ጌሻ ኣማኖይ ሃይሳ፡ ኣያ ኣዉ ባይና ናይታኔ ኣምዔታ ማዶኔ ኣላሚያ ቱናፔ ባና ናጎ። ");
INSERT INTO gofENT_vpl VALUES ("JM2_1","089_2_1","JAS","2","1","1","ታ ኢሻቶ፥ ሂንቴ ኑ ቦንቾ ጎዳ ዬሱስ ኪሪስቶሳ ኣማኒያባ ጊዲኮ፥ ኣሳ ሶምዖ ፄሊዲ ኣሴ ቦንቾፊቴ። ");
INSERT INTO gofENT_vpl VALUES ("JM2_2","089_2_2","JAS","2","2","2","ሌሚሶስ፥ ዎርቃ ሚጊዶ ኣꬂዲ፥ ሎዖ ማዖ ማዒዳ ዱሬ ኣሲ ሂንቴ ሺቁዋ ዪስ። ቃሲ ጩርቃ ማዖ ማዒዳ ማንቆ ኣሲካ ዪስ። ");
INSERT INTO gofENT_vpl VALUES ("JM2_3","089_2_3","JAS","2","3","3","ሎዖ ማዖ ማዒዳ ኣዲያ ሂንቴ ኣꬂ ቦንቺዲ፥ «ኔ ሃይሳን ሎዒያ ኦይዲያን ኡታ» ጊዲ፥ ቃሲ ማንቆ ኣዲያ፥ «ኔ ያን ኤቃ ዎይኮ ሃይሳን ታ ቶሁዋ ማታን ሳዓን ኡታ» ጌታ። ");
INSERT INTO gofENT_vpl VALUES ("JM2_4","089_2_4","JAS","2","4","4","ያቲን፥ ሂንቴ፥ ሂንቴ ጊዶን ሻኬቴꬂ ሜꬌይሳታኔ ኢታ ቆፋራ ዴዒያ ዳይናታ ሜላ ጊዴኬቲዬ? ");
INSERT INTO gofENT_vpl VALUES ("JM2_5","089_2_5","JAS","2","5","5","ታ ሲቆ ኢሻቶ፥ ሲዒቴ። ኣማኖን ዱሬ ጊዳና ሜላኔ ባና ሲቄይሳታስ ኢማና ጊዳ ሳሎ ካዎቴꬃ ላታና ሜላ ሃ ሳዓን ዴዒያ ማንቆታ ፆሳይ ዶሪቤኔዬ? ");
INSERT INTO gofENT_vpl VALUES ("JM2_6","089_2_6","JAS","2","6","6","ሺን ሂንቴ ማንቆታ ቶቼታ። ሂንቴና ኡንዔꬄይሳቲ ዱሬታ ጊዶኮናዬ? ሂንቴና ዳይና ሲንꬂ ጎቼይሳቲ ኤንታ ጊዶኮናዬ? ");
INSERT INTO gofENT_vpl VALUES ("JM2_7","089_2_7","JAS","2","7","7","ሂንቴ ፄጌቲዳ ሎዖ ጎዳ ሱንꬃ ጫዬይሳቲ ኤንታ ጊዶኮናዬ? ");
INSERT INTO gofENT_vpl VALUES ("JM2_8","089_2_8","JAS","2","8","8","ሺን ጌሻ ማፃፋን፥ «ኣሴ ኡባ ኔና ኔ ዶሴይሳዳ ዶሳ» ጌቴቲዲ ፃፌቲዳ ፆሳ ካዎቴꬃ ሂጊያ ሂንቴ ፖሊኮ ሎዖ ኦꬄታ። ");
INSERT INTO gofENT_vpl VALUES ("JM2_9","089_2_9","JAS","2","9","9","ሺን ሂንቴ ኣሳ ሶምዖ ፄሊዲ ቦንቺኮ፥ ናጋራ ኦꬄታ ቃሲ ሂጌይ ሂንቴና ሂጌ ሜንꬂዳ ኣሳዳ ፒርዳና። ");
INSERT INTO gofENT_vpl VALUES ("JM2_10","089_2_10","JAS","2","10","10","ኦኒካ ሂጌ ኡባፌ ኢሱዋ ሜንꬂዲ፥ ኣቲዳ ኡባ ናጊኮ ኡባ ሜንꬂዳዳ ታይቤቴስ። ");
INSERT INTO gofENT_vpl VALUES ("JM2_11","089_2_11","JAS","2","11","11","«ላሞፋ» ጊዳ ጎዳይ፥ ቃሲ «ዎꬎፓ» ጊስ። ሺን ኔኒ ላሞና ኣጋዳ ዎꬊዳባ ጊዲኮ፥ ሂጊያ ሜንꬃዳሳ። ");
INSERT INTO gofENT_vpl VALUES ("JM2_12","089_2_12","JAS","2","12","12","ኣይሌቴꬃፌ ኬሲያ ሂጊያ ሲንꬃን ፒርዳ ኤካናው ዴዒያ ኣሳዳ ኦዴቲቴኔ ኦꬂቴ። ");
INSERT INTO gofENT_vpl VALUES ("JM2_13","089_2_13","JAS","2","13","13","ኣሴ ማሮና ኦናካ ፆሳይ ማሮና ፒርዳና። ሺን ማሮቴꬃይ ፒርዳ ፆኔስ። ");
INSERT INTO gofENT_vpl VALUES ("JM2_14","089_2_14","JAS","2","14","14","ታ ኢሻቶ፥ ሂንቴፌ ኢሲ ኣሲ ታው ኣማኖይ ዴዔስ ጊዲ፥ ባ ኣማኑዋ ኦሶን ቤሶና ኢፂኮ ኢያ ኣይ ማዳኔ? ኢያ ኣማኖይ ኢያ ኣሻናው ዳንዳዒ? ");
INSERT INTO gofENT_vpl VALUES ("JM2_15","089_2_15","JAS","2","15","15","ሌሚሶስ ኢሲ ኢሻይ ዎይኮ ኢሲ ሚቺያ ካሎቲኮኔ ኤንታው ሚያባይ ꬋዪኮ፥ ");
INSERT INTO gofENT_vpl VALUES ("JM2_16","089_2_16","JAS","2","16","16","ሂንቴፌ ኢሲ ኣሲ ኤንታኮ፥ «ሳሮ ቢቴ! ታማ ካዪቴ! ካሊዲ ሚቴ!» ጊዲ፥ ኮሺያባ ኤንታው ኢሞና ኢፂኮ ኤንታ ኣይ ማዲ? ");
INSERT INTO gofENT_vpl VALUES ("JM2_17","089_2_17","JAS","2","17","17","ሄሳ ጊሾ፥ ኦሶይ ባይና ኣማኖይ ባርካ ሃይቂዳይሳ። ");
INSERT INTO gofENT_vpl VALUES ("JM2_18","089_2_18","JAS","2","18","18","ሺን ኢሲ ኣሲ፥ «ኔው ኣማኖይ ዴዔስ፤ ቃሲ ታው ኦሶይ ዴዔስ። ኔኒ ኔ ኣማኑዋ ኔ ኦሱዋፔ ሻካዳ ታና ቤሳ፤ ታካ ታ ኣማኑዋ ታ ኦሱዋን ኔና ቤሳና» ጋና። ");
INSERT INTO gofENT_vpl VALUES ("JM2_19","089_2_19","JAS","2","19","19","ኔኒ፥ ኢሲ ፆሳይ ዴዔይሳ ኣማናሳ፤ ሄሲ ሎዖ። ቱና ኣያናቲካ ኣማኖሶና፤ ያሻን ኮኮሮሶና። ");
INSERT INTO gofENT_vpl VALUES ("JM2_20","089_2_20","JAS","2","20","20