﻿USE sofia;
DROP TABLE IF EXISTS sofia.gnwNT_vpl;
CREATE TABLE gnwNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES gnwNT_vpl WRITE;
INSERT INTO gnwNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Tamɨmbeu cua tupapire pe Jesucristo itenondegua reta. Jesucristo co jae David iñemoñaa reta pegua. Jae ramiño vi jae co Abraham iñemoñaa reta pegua. ");
INSERT INTO gnwNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham iñemoñaa Isaac, jare Isaac iñemoñaa Jacob, jare Jacob iñemoñaa reta Judá jare tɨqueɨ reta jare tɨvɨ reta. ");
INSERT INTO gnwNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Jare Judá umɨñemoña Tamar güi Fares jare Zara. Jare Fares iñemoñaa Esrom, jare Esrom iñemoñaa Aram. ");
INSERT INTO gnwNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Jare Aram iñemoñaa Aminadab, jare Aminadab iñemoñaa Naasón, jare Naasón iñemoñaa Salmón. ");
INSERT INTO gnwNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Jare Salmón umɨñemoña Rahab güi Booz. Jare Booz umɨñemoña Rut güi Obed. Jare Obed iñemoñaa Isaí. ");
INSERT INTO gnwNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jare Isaí iñemoñaa David. Jae co Israel pegua reta juvicha guasu. Jare mburuvicha guasu David umɨñemoña Urías jembirecocue güi Salomón. ");
INSERT INTO gnwNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Jare Salomón iñemoñaa Roboam, jare Roboam iñemoñaa Abías, jare Abías iñemoñaa Asa. ");
INSERT INTO gnwNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Jare Asa iñemoñaa Josafat, jare Josafat iñemoñaa Joram, jare Joram iñemoñaa Uzías. ");
INSERT INTO gnwNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Jare Uzías iñemoñaa Jotam, jare Jotam iñemoñaa Acaz, jare Acaz iñemoñaa Ezequías. ");
INSERT INTO gnwNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Jare Ezequías iñemoñaa Manasés, jare Manasés iñemoñaa Amón, jare Amón iñemoñaa Josías. ");
INSERT INTO gnwNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Jare Josías iñemoñaa reta Jeconías jare tɨvɨ reta. Jare Jeconías ico yave, ɨvɨ Babilonia pegua reta umɨamɨri Israel pegua reta jare güɨraa jeta Israel pegua reta Babilonia pe. ");
INSERT INTO gnwNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Jare yugüɨraa ma Babilonia pe yave, Jeconías iñemoñaa Salatiel, jare Salatiel iñemoñaa Zorobabel. ");
INSERT INTO gnwNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Jare Zorobabel iñemoñaa Abiud, jare Abiud iñemoñaa Eliaquim, jare Eliaquim iñemoñaa Azor. ");
INSERT INTO gnwNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Jare Azor iñemoñaa Sadoc, jare Sadoc iñemoñaa Aquim, jare Aquim iñemoñaa Eliud. ");
INSERT INTO gnwNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Jare Eliud iñemoñaa Eleazar, jare Eleazar iñemoñaa Matán, jare Matán iñemoñaa Jacob. ");
INSERT INTO gnwNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jare Jacob iñemoñaa José - jae co María ime. Jare María imembɨ Jesús - jae co Cristo jee vae. ");
INSERT INTO gnwNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Jáeramo yaipapa catorce ñemoñaa Abraham güi David pe. Jae ramiño vi yaipapa catorce ñemoñaa David güi Jeconías pe. Echa'ã Jeconías ico yave, Israel pegua reta uyereraaca Babilonia pe. Jae ramiño vi yaipapa catorce ñemoñaa Jeconías güi Cristo pe. ");
INSERT INTO gnwNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Añave tamɨmbeu quirãi Jesucristo oa ichɨ güi vae regua. María José ndive umendata yave, ndei José güɨreco mbove, uyecuaa ipurúa oĩ. Ipurúa co Espíritu Santo imbaepuere pe. ");
INSERT INTO gnwNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Jayave José ipɨa pe uyemɨngueta jei vaerã chupe ndarau umenda jae ndive, ẽrei uipota'ã uyapo opaete vae reta jovaque. Echa'ã José penti cuimbae jupi vae co jare uipota'ã umɨmaraca María opaete vae reta jovaque. ");
INSERT INTO gnwNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ẽrei cua re ipɨa pe uyemɨngueta oĩ rambueve, penti ángel yandeYa pe uyeyocui vae uyecuaa chupe ipau pe jare jei chupe: —José. Nde co jae David iñemoñaa reta pegua. Ndepuere nemenda María ndive ndequɨye mbae reve. Echa'ã ipurúa oĩ Espíritu Santo imbaepuere pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Jare imembɨta penti cuimbae jare nembɨjeeta Jesús. Echa'ã jae umbɨasata ɨvɨ pegua reta. Echa'ã umbaita imbaeyoa reta —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Jare opaete cua uyeyapo, Tumpa iñee aracae umɨmbeu vae rupi yandeYa jei vae uyeyapo vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Echa'ã jei cuarãi: “Mase, penti cuñatai cuimbae güɨreco'ã etei vae ipuruata jare imembɨta penti cuimbae. Jare umbɨjeeta reta Emanuel.” Jucuarãi jei. (Cua tee uipota jei: “Tumpa ime yande ndive oĩ”.) ");
INSERT INTO gnwNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Jayave José usareco yave, umenda María ndive ángel yandeYa pe uyeyocui vae jei chupe rami. ");
INSERT INTO gnwNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ẽrei José opoco'ã María re ndei imembɨrɨpɨ oa mbove. Jare María imembɨ oa ma yave, José umbɨjee Jesús. ");
INSERT INTO gnwNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesús oa ma yave tenta guasu Belén ɨvɨ Judea pegua pe, Herodes ico mburuvicha guasurã. Jare jocua ara rupi yugüeru cuimbae reta yasɨtata re uyemboe vae reta guarasɨ oẽ vae cotɨ güi uvãe tenta guasu Jerusalén pe. ");
INSERT INTO gnwNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Jare jei reta: —¿Quiape pa ime oĩ sambiaɨ judío reta juvicha guasurã icota vae? Echa'ã nduecha yasɨtata uicuaaca oreve vae guarasɨ oẽ vae cotɨ. Jáeramo ndoyu ma nuvãe numbɨadora vaerã —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Mburuvicha guasu Herodes cua uyandu yave, uyemɨpɨa'ã. Opaete Jerusalén pegua reta uyemɨpɨa'ã vi. ");
INSERT INTO gnwNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Jayave Herodes umbatɨca opaete sacerdote reta itenondegua reta jare mboroyocui re oporomboe vae reta, jare upɨrandu chupe reta quiape ra oata Cristo, Tumpa ombou vae. ");
INSERT INTO gnwNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Jare jae reta jei chupe: —Oata Belén Judea pegua pe. Echa'ã Tumpa iñee aracae umɨmbeu vae jei cuarãi: ");
INSERT INTO gnwNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Belén Judea pegua penti tenta guasu Judea pegua icavi vae. Echa'ã joco pe oata penti mburuvicharã. Jae oyocuita Israel pegua reta. Israel pegua reta chembae co.’ Jucuarãi jei —jei reta chupe. ");
INSERT INTO gnwNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Jayave Herodes uenica vɨari jocua yasɨtata re uyemboe vae reta, jare upɨrandu chupe reta quirãi yave ra uyecuaa jocua yasɨtata. ");
INSERT INTO gnwNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Jayave Herodes jei chupe reta: —Pecua Belén pe peeca cavi jocua sambiaɨ. Jare pevãe ma chupe yave, peyu ye cua pe pemɨmbeu cheve, che vi aa vaerã ambɨadora —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Uyandu reta ma yave mburuvicha guasu jei vae, cuimbae reta yugüɨraa Jerusalén güi. Jare uecha reta ye jocua yasɨtata guarasɨ oẽ vae cotɨ ñugüɨnoi yave uecha vae. Jare yasɨtata oo jae reta jenonde uyemboɨ sambiaɨ oĩ vae iárambo. ");
INSERT INTO gnwNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Jocua yasɨtata uecha reta yave, cuimbae reta tuicha rupi uyerovia. ");
INSERT INTO gnwNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Jare uique reta yave sambiaɨ oĩ vae pe, uecha reta sambiaɨ ichɨ ndive - jae co María jee vae. Jayave jae reta uyeatɨca jare umbɨadora sambiaɨ. Jayave uipea jɨvɨta reta jare umee sambiaɨ pe güeru reta chupe vae - oro jare mbae ipiche cavi vae reta incienso jare mirra jee vae. ");
INSERT INTO gnwNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Jare Tumpa umɨmbeu cuimbae reta pe ipau pe agüɨye vaerã yugüɨraa ye Herodes jenta rupi. Jáeramo yugüɨraa ye iɨvɨ pe ĩru tape rupi. ");
INSERT INTO gnwNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Jare cuimbae reta yugüɨraa ma yave, penti ángel yandeYa pe uyeyocui vae uyecuaa José pe ipau pe jare jei chupe: —Epũa. Eraa sambiaɨ jare ichɨ pecua Egipto pe. Pepɨta joco pe amɨmbeu ye ndeve regua. Echa'ã Herodes uecacata sambiaɨ uyucaca vaerã —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Jayave José upũa, jare pɨ̃tu oĩ reve güɨraa sambiaɨ jare ichɨ ɨvɨ Egipto cotɨ. ");
INSERT INTO gnwNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Jare jae reta upɨta Egipto pe Herodes umano regua. Jucuarãi uyapo José, uyeyapo vaerã Tumpa iñee aracae umɨmbeu vae rupi yandeYa jei vae. Echa'ã jei cuarãi: “Egipto güi aeni cheRaɨ.” ");
INSERT INTO gnwNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Jayave Herodes uicuaa jocua yasɨtata re uyemboe vae reta uyapo'ã co jae jei vae. Jáeramo tanta rupi pochɨ jare omondo sundaro reta uyuca vaerã opaete sambiaɨ cuimbae mi retaño Belén pe jare Belén iyɨpɨ rupi ñugüɨnoi vae reta ndei mocui año güɨnoi vae. Echa'ã yasɨtata re uyemboe vae reta opou Herodes pe yave, Herodes upɨrandu cavi chupe reta quirãi yave ra uecha yasɨtata. ");
INSERT INTO gnwNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Jare jucuarãi uyeyapo Tumpa iñee aracae umɨmbeu vae Jeremías jei vae. ");
INSERT INTO gnwNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Echa'ã jei cuarãi: “Ramá pe uyendu ñee. Uyendu uyao ñugüɨnoi tuicha ipɨatɨtɨ vae reta. Raquel uyao oĩ imembɨ reta re. Ipuere'ã etei quía umbɨpɨacatu imembɨ reta umano ma ramo.” Jucuarãi jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ẽrei Herodes umano ma yave, José Egipto pe oĩ rambueve, penti ángel yandeYa pe uyeyocui vae uyecuaa José pe ipau pe. ");
INSERT INTO gnwNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Jare jei chupe: —Epũa. Eraa ye sambiaɨ jare ichɨ Israel pegua reta iɨvɨ pe. Echa'ã uipota tẽi uyucaca sambiaɨ vae reta umano ma —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Jayave José upũa jare güɨraa sambiaɨ jare ichɨ Israel pegua reta iɨvɨ pe. ");
INSERT INTO gnwNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ẽrei uyandu quirãi Arquelao ico mburuvicha guasurã Judea pe. Echa'ã Arquelao Herodes taɨ co. Jayave José uquɨye oo vaerã Judea pe. Ẽrei Tumpa umɨmbeu José pe ipau pe oo vaerã ɨvɨ Galilea pe. Jáeramo jocotɨ oo. ");
INSERT INTO gnwNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Jare José oo uvãe penti tenta guasu Nazaret jee vae pe jare joco pe ico, uyeyapo vaerã Tumpa iñee aracae umɨmbeu vae reta jei vae. Echa'ã jei reta cuarãi: “Ĩru vae reta umbɨjeeta penti Nazaret pegua.” ");
INSERT INTO gnwNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Jocua ara reta rupi ou Juan ñana Judea pe oĩ vae pe upurumbɨbautiza jare umɨmbeu Tumpa iñee. ");
INSERT INTO gnwNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Jae jei: —Peeya piyemɨngueta icavi mbae vae pepɨa pe oĩ vae. Echa'ã outa ma uvãe mboroyocuia ara pegua —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Tumpa iñee aracae umɨmbeu vae Isaías jee vae imiari Juan re. Echa'ã Isaías jei cuarãi: “Jae iñeeãta reve jeita ñana pe: ‘Piyapɨcatu yandeYa japerã. Pemɨsɨmi tape.’ ” Jucuarãi jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jare Juan jemimonde maemɨmba camello jee vae jaagüe pegua co, jare jumbɨcuaa guacapi pegua co. Jare jembíu co jae tucu jare ei ñana rupigua. ");
INSERT INTO gnwNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Jare jeta Jerusalén pegua reta jare Judea pegua reta jare jeta tenta ɨãca Jordán iyɨpɨ rupi ñugüɨnoi vae pegua reta yugüɨraa Juan oĩ vae pe. ");
INSERT INTO gnwNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Jare Juan umbɨbautiza reta ɨãca Jordán pe imbaeyoa reta opa umɨmbeu yave. ");
INSERT INTO gnwNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Jare jeta fariseo reta jare saduceo reta yugüeru Juan oĩ vae pe, jae umbɨbautiza vaerã. Jare Juan uecha reta yave, jei chupe reta: —Pe reta co jae mboi reta rami. ¿Quía pa umɨmbeu peve piyerova vaerã Tumpa cotɨ agüɨye vaerã Tumpa uiporaraca peve? ");
INSERT INTO gnwNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Piyapo icavi vae, jucuarãi picuaaca vaerã añetete peeya co piyemɨngueta icavi mbae vae pepɨa pe oĩ vae. ");
INSERT INTO gnwNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Agüɨye pere piyupe pepɨa pe: ‘Yandetenondegua co jae Abraham.’ Echa'ã che jae peve cua: Tumpa ipuere uyapo cua ita reta güi Abraham iñemoñaa retarã —jei Juan chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Yamɨjaanga penti temitɨ. Temitɨ ía icavi'ã yave, iya uyasɨa japo reve jare uapɨ. Jae ramiño vi piyapo'ã yave icavi vae, Tumpa uiporaracata peve —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Che pumbɨbautiza ɨ pe piyemɨngueta icavi mbae vae pepɨa pe oĩ vae peeya yave. Ẽrei cheraɨcue rupi outa ipuere ete chegüi vae. Jupi'ã co che amboi araa vaerã ipɨpasa. Jae pembɨbautizata Espíritu Santo pe jare tata pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Jae co trigo uipoo vae rami. Echa'ã trigo uipoo vae umbɨveve trigo uequi vaerã ɨtɨ. Jayave uñuvatu trigo jɨru pe. Ẽrei uapɨ ɨtɨ tata pe. Tata Cristo uiporuta vae opa mbae vae co —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Jare Jesús ou Galilea güi uvãe Jordán pe Juan oĩ vae pe, Juan pe uyembɨbautizaca vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ẽrei Juan ñatẽɨ umbɨbautiza Jesús. Jáeramo jei chupe: —¿Maera pa ndipota che numbɨbautiza vaerã? Echa'ã icavi co nde chembɨbautiza vaerã —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jayave Jesús jei chupe: —Icavi co nde chembɨbautiza vaerã añave. Echa'ã jucuarãi icavi co yayapo vaerã opaete jupi vae —jei. Jayave Juan umbɨbautiza Jesús. ");
INSERT INTO gnwNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jare Juan umbɨbautiza ma yave, Jesús oẽ ɨ güi. Jare jupivoi uecha ara uyepea oĩ, jare uecha vi Tumpa iEspíritu ugüeyɨ jese pɨcasu rami. ");
INSERT INTO gnwNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Jare jupivoi uyendu ñee ara güi jei: —Cua co jae cheRaɨ aau ete vae. Chembɨyerovia ete —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Jayave Espíritu Santo güɨraa Jesús ñnaa pe. Jare joco pe aña guasu umɨngueta uyavɨca vaerã tẽi chupe. ");
INSERT INTO gnwNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Jare Jesús jou'ã mbae ave cuarenta ara. Jáeramo cuarenta ara uasa ma yave, iyembaɨ. ");
INSERT INTO gnwNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Jayave aña guasu umɨngueta uyavɨca vaerã tẽi chupe. —Nde co jae Tumpa Taɨ yave, ere cua ita reta pe uyeyapo vaerã mbɨyaperã —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ẽrei Jesús jei chupe: —Tumpa iñee pe uyecuatía oĩ cuarãi: ‘Icavi co ɨvɨ pegua reta jou vaerã mbɨyape güɨnoi vaerã tecove. Ẽrei icavi ete co uyapɨsaca vaerã Tumpa iñee re jare uyapo vaerã jei vae güɨnoi vaerã tecove opa mbae vae.’ Jucuarãi uyecuatía oĩ —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Jayave aña guasu güɨraa Jesús Jerusalén pe jare umbuyupi Tumpa jo iyapɨte re. ");
INSERT INTO gnwNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Jayave jei chupe: —Nde co jae Tumpa Taɨ yave, ea cua güi. Echa'ã Tumpa iñee pe uyecuatía oĩ cuarãi: ‘Tumpa oyocuita ángel reta uyandareco vaerã nderé. Ipo pe ndepɨsɨ ndeocota reta, agüɨye vaerã ndepɨ uyererocua ita re.’ Jucuarãi uyecuatía oĩ —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jayave Jesús jei chupe: —Tumpa iñee pe uyecuatía oĩ cuarãi: ‘Che co jae ndeYa Tumpa. Agüɨye mbae iyapo ndicuaa vaerã tuicha ra chepɨaguasu.’ Jucuarãi uyecuatía oĩ —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Jayave aña guasu güɨraa Jesús penti ɨvɨtu guasu ɨvate vae re jare uechaca chupe opaete mburuvicha guasu reta iporoyocuia ɨvɨ pe ñugüɨnoi vae reta opaete ipõra vae reve. ");
INSERT INTO gnwNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Jayave aña guasu jei chupe: —Tamee ndeve opaete cua, ndiyeatɨca yave chembɨadora vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jayave Jesús jei chupe: —Esɨrɨ chegüi, Satanás. Echa'ã Tumpa iñee pe uyecuatía oĩ cuarãi: ‘Che co jae ndeYa Tumpa. Chembɨadora. Jaeño cheve iyeyocui.’ Jucuarãi uyecuatía oĩ —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Jayave aña guasu usɨrɨ Jesús güi, jare jupivoi yugüeru ángel reta omborɨ Jesús. ");
INSERT INTO gnwNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Jare Jesús uicuaa ma yave Juan uyemɨingueca ma co peresorɨru pe, oo Galilea pe. ");
INSERT INTO gnwNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Oo Nazaret güi uvãe tenta guasu Capernaum pe jare joco pe ico, (Capernaum oĩ ɨ guasu jembeɨ pe Zabulón jare Neftalí iɨvɨ pe) ");
INSERT INTO gnwNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","uyeyapo vaerã Tumpa iñee aracae umɨmbeu vae Isaías jei vae. Echa'ã jae jei cuarãi: ");
INSERT INTO gnwNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Zabulón iɨvɨ jare Neftalí iɨvɨ, ɨ guasu jembeɨ pe, Jordán jovaicho pe, Galilea judío mbae vae reta pegua. ");
INSERT INTO gnwNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Pɨ̃tumimbi pe yugüɨreco vae reta uecha ma tembipe tuicha vae. Mano iguarasɨ̃a pe yugüɨreco vae reta pe uyecuaa tembipe.” Jucuarãi jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Jayave Jesús umbɨpɨ umɨmbeu Tumpa iñee. Jae jei: —Peeya piyemɨngueta icavi mbae vae pepɨa pe oĩ vae. Echa'ã outa ma uvãe mboroyocuia ara pegua —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jare uguata rambueve Galilea pe ɨ guasu jembeɨ rupi, Jesús uecha Simón - jae co Pedro jee vae - jare Simón tɨvɨ Andrés jee vae. Jae reta omombo ñugüɨnoi pɨsa ɨ guasu pe, pira uipɨsɨ vaerã. Echa'ã jae reta pira uipɨsɨ vae reta co. ");
INSERT INTO gnwNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jare Jesús jei chupe reta: —Peyu cherupíe, jare che chembaepuere pe pemboeta ĩru vae reta güɨrovia vaerã cheré. ");
INSERT INTO gnwNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Jayave jae reta ueya voi ipɨsa, jare yugüɨraa jae jupíe. ");
INSERT INTO gnwNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Jesús oo catu ye joco güi, jare uecha Zebedeo taɨ reta. Penti jee Jacobo jare tɨvɨ jee Juan. Uyapɨcatu ñugüɨnoi pɨsa reta chalana pe tu ndive. Jayave Jesús ueni. ");
INSERT INTO gnwNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Jayave jae reta ueya voi chalana jare tu, jare yugüɨraa jae jupíe. ");
INSERT INTO gnwNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jare Jesús oo opaete Galilea rupi, jare oporomboe judío reta itupaopao rupi. Umɨmbeu ñee icavi vae Tumpa iporoyocuia pegua, jare umbɨgüera imbaerasɨ vae reta ipotave mbaerasɨ güi. ");
INSERT INTO gnwNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Jare opaete ɨvɨ Siria pegua reta uyandu Jesús uyapo vae regua. Jare ĩru vae reta güeru jae oĩ vae pe imbaerasɨ vae reta. Amocue vae uiporara ete jasɨ vae, jare aña oya amocue vae re, jare amocue vae imbɨquere, jare amocue vae ipuere mbae omɨ vae. Jayave Jesús umbɨgüera reta. ");
INSERT INTO gnwNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Jare yugüɨraa Jesús jaɨcue jeta vae Galilea güi, jare ɨvɨ Decápolis jee vae güi, jare Jerusalén güi, jare Judea güi, jare ɨãca Jordán jovaicho güi. ");
INSERT INTO gnwNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jare Jesús jeta vae reta uecha yave, uyupi penti ɨvɨtu guasu re. Joco pe uguapɨ oĩ, jare jemimboe reta yugüeru jae oĩ vae pe. ");
INSERT INTO gnwNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Jayave Jesús umbɨpɨ omboe reta. ");
INSERT INTO gnwNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Jei chupe reta: —Tuyerovia icoi Tumpa ueca vae reta. Echa'ã Tumpa umeeta chupe reta yugüɨreco vaerã mboroyocuia ara pegua pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Tuyerovia ipɨatɨtɨ vae reta. Echa'ã Tumpa umbɨpɨacatuta reta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Tuyerovia uñemɨmichi vae reta. Echa'ã Tumpa umeeta chupe reta ɨvɨ imbaerã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Tuyerovia iquɨrẽɨ jupi vae uyapo vae reta. Echa'ã Tumpa umbujupita reta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Tuyerovia ĩru vae reta uiparareco vae reta. Echa'ã Tumpa uipararecota reta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Tuyerovia ipɨa iquɨa mbae vae reta. Echa'ã uechata reta Tumpa —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Tuyerovia ĩru vae reta umbɨpɨacatu vae reta. Echa'ã Tumpa jeita chupe reta: ‘Pe co jae cheraɨ reta’ —jeita, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Tuyerovia jupi vae uyapo ramo ĩru vae reta icavi mbae vae uyapo chupe vae reta. Echa'ã Tumpa umeeta chupe reta yugüɨreco vaerã mboroyocuia ara pegua pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Ĩru vae reta jeita icavi mbae vae peve jare uyapota icavi mbae vae peve. Ipotave icavi mbae vae jeita pecotɨ iyapu reve, pe reta cherau ramo. Ẽrei piyeroviaño peĩ —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Piyerovia ete. Echa'ã Tumpa güɨnoi ara pe mbae icavi ete vae pembaerã. Echa'ã jae reta itenondegua reta uyapo cua nunga icavi mbae vae Tumpa iñee aracae umɨmbeu vae reta pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Pe reta co jae yuquɨ rami cua ɨvɨ pe. Ẽrei yuquɨ jembochɨ'ã ma yave, ¿quirãita ra jembochɨ ye? Icavi'ã ma mbaerã. Icavi co yamombo vaerã jare ñapɨ̃ro jese vaerã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Pe reta co jae penti mechero ɨvɨ pegua reta pe tembipe umee vae rami. Yayapo yave tenta guasu penti ɨvɨtu re, yandepuere'ã etei ñañomi. Opaete vae ipuere uecha —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Jae ramiño vi mechero yamɨendɨ yave, ndarau ñañono yapepo uyembovapo oĩ vae igüɨ pe. Ñañono co mechero jenda pe, opaete o pe ñugüɨnoi vae reta güɨnoi vaerã tembipe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Mechero umee yandeve tembipe. Jae ramiño vi pe reta pico cavi ĩru vae reta jovaque, jae reta uicuaa vaerã pe reta piyapo co icavi vae. Echa'ã jucuarãi yave, umbɨadorata reta peRu ara pe oĩ vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Aramoi pe reta pepɨa pe piyemɨngueta che ayu co ambai vaerã Moisés iporoyocui jare Tumpa iñee aracae umɨmbeu vae reta jei vae. Ẽrei jucuarãi'ã co. Che ayu ayapo vaerã, ayu'ã co ambai vaerã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Añete che jae peve, ara jare ɨvɨ uasa regua ndarau uyembai penti cuatía michi ete vae yepe Moisés iporoyocui güi ndei opaete uyeyapo mbove —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ime yave quía penti mboroyocui michi vae uyapo'ã jare umɨmbeu ĩru vae reta pe agüɨye vaerã uyapo vae, ĩru vae reta jeita jae co taɨcuegua vae mboroyocuia ara pegua pe. Ẽrei ime yave quía uyapo jare umɨmbeu ĩru vae reta pe uyapo vaerã vae, ĩru vae reta jeita jae co tenondegua vae mboroyocuia ara pegua pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Echa'ã che jae peve cua: Jupi vae pe reta piyapo vae jupi ete'ã yave jupi vae mboroyocui re oporomboe vae reta jare fariseo reta uyapo vae güi, ndarau etei pico mboroyocuia ara pegua pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Piyandu ma quirãi Moisés jei yandetenondegua reta pe cuarãi: ‘Agüɨye epuruyuca. Echa'ã upuruyuca vae uñeãacata co.’ Jucuarãi jei —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ẽrei che jae peve, ime yave quía pochɨ tɨvɨ pe vae, uñeãacata co. Jare ime yave quía tɨvɨ güɨrɨ̃ro vae, judío reta itenondegua reta uãata. Jare ime yave quía tɨvɨ pe: ‘Nembɨquere’, jei vae, tata guasu pe uiporarata —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Jáeramo nderu yave penti ofrenda uñemeearenda pe, jare joco pe nemandúa yave quirãi nderɨvɨ pochɨ ndeve mbae re, ");
INSERT INTO gnwNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","eeya joco pe jocua ofrenda uñemeearenda jovai. Ecua rani iyeyapɨcatu nderɨvɨ ndive. Jayave taɨcue rupi ndepuereta nemee jocua ofrenda Tumpa pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Iyeyapɨcatu ɨmambae uipota uñeapo nderé mbae re vae ndive jae ndive ndeo rambueve tape rupi mburuvicha oĩ vae cotɨ. Echa'ã ndiyeyapɨcatu'ã yave, uñeapota nderé mburuvicha pe, jare mburuvicha nemondota peresorɨru iyandarecoa pe jare peresorɨru iyandarecoa neñonota peresorɨru pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Añete che jae ndeve, ndarau etei neẽ peresorɨru güi ndei opaete ndepía nembɨepɨ mbove —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Piyandu ma quirãi Moisés jei yandetenondegua reta pe cuarãi: ‘Agüɨye iyuvanga menda re.’ Jucuarãi jei —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ẽrei che jae peve, ime yave quía umae cuña re uipota reve vae, uyuvanga ma menda re ipɨa pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Jare nderesa ndeacata cotɨgua uyapoca yave mbaeyoa ndeve, enoẽ emombo ndiyugüi. Icavi co penti nderesa ucañɨ vaerã ndegüi, tata guasu pe opaete nderete reve Tumpa nemondo vaerã tẽi güi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Jae ramiño vi ndepo ndeacata cotɨgua uyapoca yave mbaeyoa ndeve, iyasɨa emombo ndiyugüi. Icavi co penti ndepo ucañɨ vaerã ndegüi, tata guasu pe opaete nderete reve Tumpa nemondo vaerã tẽi güi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Aracae Moisés jei vi cuarãi: ‘Jembireco omombo vae tumee chupe tupapire umɨmbeu vaerã pɨpe omombo ma vae co.’ Jucuarãi jei —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ẽrei che jae peve, penti cuimbae ipuere omombo jembireco, cuña aguasa uyapo yave. Ẽrei cuña uyapo'ã yave aguasa jare cuimbae omombo yave jembireco, jocua cuña uyuvanga co menda re umenda yave ĩru cuimbae ndive. Jae ramiño vi jocua cuimbae cuña ndive umenda vae uyuvanga co menda re —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Piyandu ma quirãi Moisés jei yandetenondegua reta pe cuarãi: ‘Agüɨye ere: YandeYa jee re ayapota, ndepurumbɨtavɨ vaerã. Echa'ã ndere yave: YandeYa jee re ayapota, iyapo.’ Jucuarãi jei —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ẽrei che jae peve, agüɨye ere jucuarãi. Agüɨye ere: ‘Ara jee re ayapota.’ Echa'ã ara Tumpa iguapɨa co. ");
INSERT INTO gnwNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Agüɨye vi ere: ‘Ɨvɨ jee re ayapota.’ Echa'ã ɨvɨ Tumpa ipɨ jenda co. Agüɨye vi ere: ‘Jerusalén jee re ayapota.’ Echa'ã Jerusalén Mburuvicha Guasu mbaepuere güɨnoi vae jenta guasu co. ");
INSERT INTO gnwNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Agüɨye vi ere: ‘Cheãca jee re ayapota.’ Echa'ã ndepuere'ã ndiyapo ndea tĩ ani jũ —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ẽrei ndipota yave ndere: ‘Ayapota’, ere: ‘Ayapota.’ Jae ramiño vi ndipota yave ndere: ‘Ndarau ayapo’, ere: ‘Ndarau ayapo.’ Echa'ã jeta cua güi ndere yave, ndiyapota icavi mbae vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Piyandu ma quirãi Moisés aracae jei cuarãi: ‘Ime yave quía ĩru vae jesa urucumegua vae, ĩru vae reta turucumegua vi jae jesa. Jae ramiño vi ime yave quía ĩru vae jãi omopẽ vae, ĩru vae reta tomopẽ vi jae jãi.’ Jucuarãi jei —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ẽrei che jae peve, emaeño ĩru vae re uyapo vaerã ndeve icavi mbae vae. Ime yave quía ocua nderovaɨque re vae, erova ipuere vaerã ocua ye jovaicho re. ");
INSERT INTO gnwNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Jae ramiño vi ime yave quía uñeapo nderé ndecamisa upɨ̃ro vaerã ndegüi vae, emaeño jese upɨ̃ro vaerã ndegüi ndeasoya vi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Jae ramiño vi ime yave quía ndeocui nderaa vaerã jɨvɨta penti kilómetro, eraa chupe mocui kilómetro rupi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Jae ramiño vi ime yave quía uyerure ndeve mbae re vae, emee chupe, jare ime yave quía mbae uiporu ndeve vae, iporuca chupe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Piyandu ma quirãi Moisés aracae jei cuarãi: ‘Eau neĩru jare emɨtarẽɨ nderovaicho.’ Jucuarãi jei —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ẽrei che jae peve, peau perovaicho reta. Piyerure Tumpa pe umɨvendise vaerã uyepɨpeyu peré vae reta. Piyapo icavi vae pemɨtarẽɨ vae reta pe. Piyerure Tumpa pe icavi mbae vae uyapo peve vae reta re —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Jucuarãi piyapo yave, picota peRu ara pe oĩ vae taɨ retarã. Echa'ã peRu umee guarasɨ icavi mbae vae uyapo vae reta jare icavi vae uyapo vae reta pe, opaete vae güɨnoi vaerã tembipe. Jae ramiño vi umee ama jupi vae reta jare jupi mbae vae reta pe, opaete vae güɨnoi vaerã ɨ —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Echa'ã peau yave perau vae retaño, jocua mbaetɨ etei co mbae icavi vae. Jáeramo Tumpa ndarau umee peve mbae jocua jeco pegua. Echa'ã mburuvicha peguarã ocovara vae reta vi uyapo jucuarãi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Jae ramiño vi pembɨsaluda picuãva reve yave perɨvɨ retaño, jocua mbaetɨ etei co mbae icavi vae. Echa'ã upurugüɨrovia mbae vae reta vi uyapo jucuarãi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Jáeramo jecuaeño piyapo icavi vae. Echa'ã peRu ara pe oĩ vae jecuaeño uyapo icavi vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Jupi vae piyapo yave, agüɨye piyapo opaete vae jovaque jae reta uecha vaeraño. Echa'ã piyapo yave opaete vae jovaque, peRu ara pe oĩ vae ndarau umee peve mbae jocua jupi vae piyapo vae jeco pegua —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Jáeramo nemee mbae iparavete vae reta pe yave, agüɨye iyapo upurumbɨtavɨ vae reta uyapo rami. Echa'ã jae reta omondo jenonde judío reta itupao reta pe jare calle rupi uyemimbɨ vae, ĩru vae reta icavi uyemɨngueta jese vaerã umee mbae iparavete vae reta pe yave. Añete che jae peve, jocua upurumbɨtavɨ vae reta güɨnoita'ã imbaerã jucuarãi uyapo ramo —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ẽrei nde nemee mbae iparavete vae reta pe yave, agüɨye tuicuaa ndepo ndeaso cotɨgua ndepo ndeacata uyapo vae, ");
INSERT INTO gnwNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","agüɨye vaerã quía ye uicuaa nde ndiyapo vae regua. Ẽrei ndeRu uicuaata nde ndiyapo vɨari vae jare umeeta ndeve mbae opaete vae jovaque —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Jare ndiyerure Tumpa pe yave, agüɨye iyapo upurumbɨtavɨ vae reta uyapo rami. Echa'ã jae reta uyerure Tumpa pe yave, uipota quía reta uecha vaerã. Jáeramo uyemboɨ judío reta itupao reta pe jare calle uyerea pe uyerure Tumpa pe yave. Añete che jae peve, jocua upurumbɨtavɨ vae reta güɨnoita'ã imbaerã jucuarãi uyapo ramo —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ẽrei nde ndiyerure Tumpa pe yave, ique ndero pe jare iyuquenda onque. Jayave iyerure ndeRu pe quía reta uicuaa mbae reve. Jare ndeRu uicuaata nde ndiyapo vɨari vae jare umeeta ndeve mbae opaete vae jovaque —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ẽrei piyerure Tumpa pe yave, agüɨye iyapo upurugüɨrovia mbae vae reta uyapo rami. Echa'ã jae reta jecuaeño umbɨaɨcuerecuere jei penti vaeño. Echa'ã ipɨa pe uyemɨngueta tẽi Tumpa uyapɨsacata jese reta jucuarãi uyapo yave —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Jáeramo agüɨye piyapo jae reta uyapo rami. Echa'ã peRu uicuaa mbae uata peve vae ndei piyerure chupe jese mbove —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Jáeramo piyerure Tumpa pe cuarãi: ‘OreRu ara pe neĩ vae, tuyembɨadoraca nderee. ");
INSERT INTO gnwNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Tou ndeporoyocuia. Tuyeyapo nde ndere vae cua ɨvɨ pe ara pe uyeyapo oĩ rami. ");
INSERT INTO gnwNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Emee oreve opa ara orerembiurã. ");
INSERT INTO gnwNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Embɨasa oreve orembaeyoa reta, ore numbɨasa ipotave iyoa orecotɨ vae pe rami. ");
INSERT INTO gnwNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Jare agüɨye emaeño aña guasu re uyapoca vaerã oreve mbaeyoa. Orerepɨ aña guasu güi. Echa'ã nembae co mboroyocuia. Nde nenoi opaete mbaepuere. Opaete vae nembɨadorata jaeño mai pegua. Amén.’ Jucuarãi piyerure —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Echa'ã pe reta pembɨasa yave iyoa pecotɨ vae reta, peRu ara pe oĩ vae umbɨasata vi peve pembaeyoa reta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ẽrei pembɨasa'ã yave iyoa pecotɨ vae reta, peRu ndarau vi umbɨasa peve pembaeyoa reta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Piyecuacu tembíu güi yave, agüɨye piyapo upurumbɨtavɨ vae reta uyapo rami. Echa'ã jae reta uyecuacu tembíu güi yave, uyecuaa ipɨatɨtɨ, ĩru vae reta uicuaa vaerã uyecuacu co ñugüɨnoi tembíu güi. Añete che jae peve, jae reta güɨnoita'ã imbaerã jucuarãi uyapo ramo —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ẽrei nde tembíu güi ndiyecuacu yave, iyapɨcatu ndea jare iyovae, ");
INSERT INTO gnwNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","agüɨye vaerã ĩru vae reta uicuaa ndiyecuacu co neĩ tembíu güi. Jaeño ndeRu uicuaata ndiyecuacu co neĩ tembíu güi vae. NdeRu uicuaata nde ndiyapo vɨari vae jare umeeta ndeve mbae opaete vae jovaque —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Agüɨye piñuvatu cua ɨvɨ pe jeta mbaembae icavi vae piyupeguarã. Echa'ã cua ɨvɨ pe cupii reta urucumegua mbaembae jare ĩru mbaembae iyuquɨrɨ urucumegua, jare imonda vae reta uique vɨari mbaembae oñomi vaerã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Piñuvatu mbaemabe icavi vae piyupeguarã ara pe. Echa'ã joco pe ndarau cupii reta urucumegua vaerã mbaembae jare ndarau mbae iyuquɨrɨ, jare ndarau imonda vae reta uique vɨari mbaembae oñomi vaerã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Echa'ã piñuvatu yave mbaembae icavi vae piyupeguarã ɨvɨ pe, jecuaeño pepɨa pe piyemɨnguetata ɨvɨ pegua re. Ẽrei piñuvatu yave mbaembae icavi vae piyupeguarã ara pe, jecuaeño pepɨa pe piyemɨnguetata ara pegua re —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Tembipe uique yanderete pe yanderesa rupi. Icavi yave nderesa, nderete tɨneeta tembipe pe. ");
INSERT INTO gnwNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ẽrei icavi'ã yave nderesa, nderete tɨneeta pɨ̃tumimbi pe. Nderete tɨneeta tẽi tembipe pe. Ẽrei tɨnee yave pɨ̃tumimbi pe, pɨ̃tumimbi ete co —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Penti uyeyocui vae uipota yave uyeyocui mocui patrón pe, umɨtarẽɨta penti patrón jare uauta ĩru vae, ani uparavɨquɨ cavita penti patrón pe jare güɨrɨ̃rota ĩru vae. Pepuere'ã piyeyocui Tumpa pe corepoti peau reve —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Jáeramo che jae peve, agüɨye piyemɨpɨa'ã mbae re. Agüɨye piyemɨpɨa'ã perembiurã vae re. Jae ramiño vi agüɨye piyemɨpɨa'ã peremimonderã vae re. Ndarau pepuere pico cavi jecuaeño piyemɨpɨa'ã yave perembiurã vae re jare peremimonderã vae re —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Pemae güɨra reta re. Jae reta umaetɨ'ã jare umbaevɨro'ã. Uñuvatu'ã vi avati avatío pe. Ẽrei peRu ara pe oĩ vae umɨngaru reta. Jare Tumpa perau ete güɨra reta güi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Aramoi piyemɨpɨa'ã pipota tẽi pepucu ramo. Ẽrei ndarau etei pepuere piyembɨcuacuaa pepucu ete vaerã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","¿Maera pa piyemɨpɨa'ã peremimonderã vae re? Pemae mbaepotɨ reta re, quirãi ucuacuaa reta. Uparavɨquɨ'ã reta. Umaepova'ã reta vi. ");
INSERT INTO gnwNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ẽrei che jae peve, mbaepotɨ reta ipõra ete Salomón jemimonde ipõra vae güi. ");
INSERT INTO gnwNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Tumpa omopõra ñana, yepe tẽi penti ara ñana oĩ co pe jare pɨareve pe ocai. Jáeramo Tumpa umeeta co peve peremimonderã. Michi ete co pepurugüɨrovia —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Agüɨye piyemɨpɨa'ã mbae re. Agüɨye piyemɨpɨa'ã perembiurã vae re. Jae ramiño vi agüɨye piyemɨpɨa'ã peremimonderã vae re —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Echa'ã opaete ɨvɨ pegua reta uyemɨpɨa'ã cua mbaembae re. Jare peRu ara pe oĩ vae uicuaa icavi co penoi vaerã opaete cua mbaembae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ẽrei icavi co pipota ete vaerã Tumpa iporoyocuia jare pipota vaerã piyapo jupi vae Tumpa jupi vae uyapo rami. Jucuarãi yave, Tumpa umeeta peve opaete cua mbaembae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Jáeramo agüɨye piyemɨpɨa'ã pɨareve peguarã vae re. Echa'ã pɨareve pe uyeyapo yeta mbae pemɨpɨa'ã vaerã. Opa ara uyeyapo mbaembae pemɨpɨa'ã vaerã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Agüɨye piñera ĩru vae re, agüɨye vaerã ĩru vae iñera peré. ");
INSERT INTO gnwNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Echa'ã piñera yave ĩru vae re, ĩru vae iñerata vi peré. Jae ramiño vi icavi vae piyapo yave ĩru vae pe, ĩru vae uyapota vi icavi vae peve. Jae ramiño vi icavi mbae vae piyapo yave ĩru vae pe, ĩru vae uyapota vi icavi mbae vae peve —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Agüɨye emae ɨtɨ michi vae neĩru jesa pe oĩ vae re, ime yave nenoi ɨtɨ tuicha vae nderesa pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ndarau ndepuere ndere neĩru pe: ‘Cherɨvɨ, taequi nderesa güi jocua ɨtɨ michi vae.’ Echa'ã nde nenoi ɨtɨ tuicha vae nderesa pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Nde co jae upurumbɨtavɨ vae. Eequi rani ɨtɨ tuicha vae nderesa güi. Jayave nemae cavita ndepuere vaerã ndeequi ɨtɨ michi vae neĩru jesa güi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Agüɨye pemee mbae uñeñono tee Tumpa peguarã vae yɨmba reta pe. Jae ramiño vi agüɨye piñono ita ipõra vae reta cuchi reta ñugüɨnoi vae rupi. Echa'ã jucuarãi piyapo yave, upɨ̃rota jese reta jare aramoi uyerovata pesuu vaerã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Piyerure Tumpa pe mbae re, jare Tumpa umeeta peve. Peeca, jare pevãeta. Pembopu onque, jare onque uyepeata peve —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Echa'ã piyerure yave Tumpa pe mbae re, Tumpa umeeta peve. Jare peeca yave mbae, pevãeta. Jare pembopu yave onque, uyepeata peve —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Nde nenoi yave penti nderaɨ, nderaɨ uyerure yave ndeve mbɨyape re, ndarau nemee chupe penti ita mbɨyape ipepɨca pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Jae ramiño vi nderaɨ uyerure yave ndeve pira re, ndarau nemee chupe penti mboi pira ipepɨca pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Yepe tẽi pe reta jecuaeño piyapo icavi mbae vae, ẽrei pemee co mbaembae icavi vae pesambiaɨ reta pe. Jáeramo peRu ara pe oĩ vae iquɨrẽɨ umee mbaembae icavi vae uyerure chupe jese vae reta pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Jáeramo piyapo ĩru vae reta pe pipota ĩru vae reta uyapo vaerã peve vae rami. Echa'ã cua co jae mboroyocui jei vae jare Tumpa iñee aracae umɨmbeu vae reta jei vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Pique onque ipɨ-raɨ vae rupi. Echa'ã onque ipɨguasu vae rupi uique vae reta uguata tape ipɨguasu vae rupi, ẽrei yugüɨraa cañɨtei pe. Jare jeta vae uique jocua onque ipɨguasu vae rupi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Echa'ã onque ipɨ-raɨ vae rupi uique vae reta uguata tape ipɨ-raɨ vae rupi, ẽrei yugüɨraa tecove opa mbae vae güɨnoi vae reta ñugüɨnoi vae pe. Jare mbovɨño uvãe jocua onque ipɨ-raɨ vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Amocue upurumbɨtavɨ vae reta jeita: ‘Che co jae Tumpa iñee umɨmbeu vae.’ Agüɨye perovia. Jae reta jei peve uipota co umɨmbeu peve Tumpa iñee, ẽrei uipota uyapo icavi mbae vae peve —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Picuaata jae reta upurumbɨtavɨ vae reta co icavi mbae vae uyapo ramo. Yaequi'ã uva penti yai jãti vae güi. Jae ramiño vi yaequi'ã ɨva penti yai jãti vae güi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Penti temitɨ icavi vae umee ía icavi vae. Jae ramiño vi penti temitɨ icavi mbae vae umee ía icavi mbae vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Penti temitɨ icavi vae umee'ã ía icavi mbae vae. Jae ramiño vi penti temitɨ icavi mbae vae umee'ã ía icavi vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Temitɨ ía icavi'ã yave, iya uyasɨa jare uapɨ —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Jáeramo picuaata jae reta upurumbɨtavɨ vae reta co icavi mbae vae uyapo ramo —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Jeta vae jeita cheve: ‘CheYa, cheYa.’ Ẽrei amocue jucuarãi jei vae ndarau yugüɨreco mboroyocuia ara pegua pe. Echa'ã jaeño cheRu ara pe oĩ vae jei vae uyapo vae reta yugüɨrecota joco pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Jeta vae jeita cheve jocua ara: ‘CheYa, cheYa, ore numɨmbeu Tumpa iñee nderee pe. Jae ramiño vi nderee pe numbɨsɨrɨ aña reta oya jese vae reta güi. Jae ramiño vi nderee pe nduyapo jeta mɨacañɨ reta.’ Jucuarãi jeita —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ẽrei che jaeta chupe reta: ‘Che pucuaa'ã etei. Pesɨrɨ chegüi. Echa'ã pe reta piyapo icavi mbae vae.’ Jucuarãi jaeta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Jáeramo ime yave quía uyapɨsaca cheré vae, jae uyapo yave che jae chupe uyapo vaerã vae, jae co penti cuimbae iyaracuaa vae jentarã uyapo vae rami. Echa'ã cuimbae iyaracuaa vae oñono jenta iguapɨcarã itape re —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Jayave tuicha oquɨ jare jeta ɨ usɨrɨ tenta cotɨ. Tanta vi ɨvɨtu tenta re. Ɨ jare ɨvɨtu umbɨyaparata tẽi tenta. Ẽrei uyapara'ã. Echa'ã iguapɨca oĩ penti itape re —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ẽrei ime yave quía uyapɨsaca cheré vae, uyapo'ã yave che jae chupe uyapo vaerã vae, jae co penti cuimbae iyaracuaa mbae vae jentarã uyapo vae rami. Echa'ã cuimbae iyaracuaa mbae vae uyapo jentarã ɨvɨcuĩti re —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Jayave tuicha oquɨ jare jeta ɨ usɨrɨ tenta cotɨ. Tanta vi ɨvɨtu tenta re. Ɨ jare ɨvɨtu umbɨyapara. Opa uyembai jocua tenta —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jare Jesús opaete cua jei ma yave, opaete uyapɨsaca jese vae reta ipɨacañɨ iporomboe re. ");
INSERT INTO gnwNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Echa'ã omboe reta mbaepuere güɨnoi vae rami. Jucuarãi'ã oporomboe mboroyocui re oporomboe vae reta. ");
INSERT INTO gnwNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jare Jesús ugüeyɨ ma ɨvɨtu guasu güi yave, jeta yugüɨraa jaɨcue. ");
INSERT INTO gnwNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Jayave ou Jesús oĩ vae pe penti cuimbae ipire ocui vae. Uyeatɨca Jesús jovai. —CheYa, ndipota yave, ndepuere chembɨgüera —jei chupe. ");
INSERT INTO gnwNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jayave Jesús oñono ipo jese. —Aipota. Ecuera —jei chupe. Jare jupivoiño cuimbae ucuera imbaerasɨ güi. Ocui'ã ma ipire. ");
INSERT INTO gnwNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jayave Jesús jei chupe: —Agüɨye emɨmbeu quía pe. Ecua iyeechaca sacerdote pe, jare emee ofrenda Moisés peocui rami, tenta guasu pegua reta uicuaa vaerã ndecuera ma co —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jare Jesús oo uvãe yave Capernaum pe, ou jae oĩ vae pe penti sundaro reta juvicha uyerure vaerã chupe mbae re. ");
INSERT INTO gnwNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Jae jei Jesús pe: —CheYa, cherembiocui imbaerasɨ oĩ cherenta pe. Ipuere'ã omɨ. Jasɨ ete oĩ chupe —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jayave Jesús jei chupe: —Taa tambɨgüera. ");
INSERT INTO gnwNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ẽrei sundaro reta juvicha jei chupe: —CheYa, agüɨye ecua cherenta pe. Echa'ã mbae'ã co che. Ndepuere ndere cua güiño cherembiocui ucuera vaerã jare ucuerata co —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Echa'ã ime mburuvicha mbaepuere güɨnoi cheré vae reta. Jae ramiño vi che anoi mbaepuere sundaro reta re. Che jae penti sundaro pe: ‘Ecua’, jare jae oo. Jae ramiño vi che jae ĩru sundaro pe: ‘Eyu’, jare jae ou. Jae ramiño vi che jae cherembiocui pe: ‘Iyapo cua’, jare jae uyapo —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jare Jesús cua uyandu yave, ipɨacañɨ sundaro reta juvicha re, jare jei yugüɨraa jaɨcue vae reta pe: —Añete che jae peve, avãe'ã cua nunga mburugüɨrovia tuicha vae Israel pegua reta ipɨte pe. ");
INSERT INTO gnwNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Jare che jae peve, jeta vae yugüeruta guarasɨ oẽ vae cotɨ güi jare guarasɨ uique vae cotɨ güi jare uguapɨta reta Abraham jare Isaac jare Jacob ndive mboroyocuia ara pegua pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ẽrei mboroyocuia pe yugüɨrecota tẽi vae reta uyemombocata oca pe pɨ̃tumimbi oĩ vae pe. Joco pe uyaota reta jare jãi umbɨquɨrɨrɨuta —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Jayave Jesús jei sundaro reta juvicha pe: —Ndepuere ndeo. Ayapo ma ndipota ayapo vaerã vae nderovia cheré ramo —jei. Jare jocua ora pe etei sundaro reta juvicha jembiocui ucuera. ");
INSERT INTO gnwNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jare Jesús uique Pedro jenta pe yave, uecha Pedro jaicho jacu oĩ jupa pe. ");
INSERT INTO gnwNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jayave Jesús uipɨsɨ ipo pe jare jacu upɨta voi chugüi. Jayave cuña upũa jare umee mbae jou reta vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Jare guarasɨ uique ma yave, tenta guasu pegua reta güeru Jesús pe jeta aña oya jese vae reta. Jayave Jesús oyocui aña reta usɨrɨ vaerã opaete oya jese vae reta güi, jare umbɨgüera opaete imbaerasɨ vae reta. ");
INSERT INTO gnwNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Jucuarãi uyapo Jesús uyeyapo vaerã Tumpa iñee aracae umɨmbeu vae Isaías jei vae. Echa'ã jae jei cuarãi: “Jae etei güɨraa yandegüi yanembaerasɨ reta.” ");
INSERT INTO gnwNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jare jeta yugüeru Jesús oĩ vae pe. Jare Jesús uecha yave, jei jemimboe reta pe yugüɨraa vaerã ɨ guasu jovaicho pe. ");
INSERT INTO gnwNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Jare penti mboroyocui re oporomboe vae ou Jesús oĩ vae pe jare jei chupe: —Oporomboe vae, taa nderupíe opaete que rupi ndeo vae rupi. ");
INSERT INTO gnwNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jayave Jesús jei chupe: —Aguara reta güɨnoi icua reta, jare güɨra reta güɨnoi jaitɨ reta. Ẽrei che cuimbaerã ayeyapo vae mbaetɨ cherenta —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Jare ĩru jemimboe jei Jesús pe: —CheYa, emaeño rani cheré aa vaerã aico cheru re umano regua. ");
INSERT INTO gnwNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ẽrei Jesús jei chupe: —Eyu cherupíe. Tecove opa mbae vae güɨnoi mbae vae reta toñotɨ umano vae reta —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jayave Jesús uyupi chalana pe jare jemimboe reta vi uyupi pɨpe. ");
INSERT INTO gnwNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Jare ou ɨvɨtu tanta uyepeyu, jare ɨ uyembɨaparoaroa uique chalana pe, jare umɨtɨnee seri ma. Ẽrei Jesús oque oĩ. ");
INSERT INTO gnwNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Jayave Jesús jemimboe reta yugüɨraa omomba. Jei reta chupe: —OreYa, orerepɨ. Ñamanota ma. ");
INSERT INTO gnwNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jayave Jesús jei chupe reta: —¿Maera pa pequɨye? Michi ete co pepurugüɨrovia —jei. Jayave upũa jare uñeengata ɨvɨtu jare ɨ guasu pe. Jare opaete voi quĩi ngatu upɨta. ");
INSERT INTO gnwNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Jare Jesús jemimboe reta ipɨacañɨ jare jei: —¿Mbae nunga cuimbae pa cua? Ɨvɨtu jare ɨ guasu uyapo jae oyocui vae. ");
INSERT INTO gnwNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jayave yugüɨraa uvãe ɨ guasu jovaicho pe, gadareno reta iɨvɨ pe. Jare yugüeru teõgüerɨrurenda güi oovãiti Jesús mocui cuimbae aña oya jese vae reta. Pochɨ reta. Jáeramo mbaetɨ quía ipuere uguata jocua tape rupi. ");
INSERT INTO gnwNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Jare jae reta iñeeãta reve jei: —¿Maera pa ndeyu oremambeco, Jesús? Nde co jae Tumpa Taɨ. ¿Ndeyu pa ndiporaraca oreve añave? Taɨcue rupi ramo co ndiporaracata tẽi oreve —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Jare mbɨrɨ catu jeta cuchi reta ucaru ñugüɨnoi. ");
INSERT INTO gnwNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Jare aña reta uyerure Jesús pe: —Cua cuimbae reta güi orembɨsɨrɨ yave, emaeño oreré ndoo vaerã ndoya cuchi reta re. ");
INSERT INTO gnwNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jayave Jesús jei chupe reta: —Pecua. Jare yugüɨraa ma yave cuimbae reta güi, aña reta yugüɨraa oya cuchi reta re. Jayave opaete cuchi reta tanta osi ɨvɨa rupi oa ɨ guasu pe, jare joco pe opa ipɨtupa reta. ");
INSERT INTO gnwNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Jayave cuchi iyandarecoa reta opa osi, jare yugüɨraa tenta guasu pe, jare umɨmbeu joco pegua reta pe opaete uyeyapo vae regua. Umɨmbeu vi chupe reta mbae aña oyase jese vae reta pe uyeyapo vae. ");
INSERT INTO gnwNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Jayave opaete joco pegua reta yugüeru oovãiti Jesús. Jare uecha yave, umɨñera oo ye vaerã jae reta iɨvɨ güi. ");
INSERT INTO gnwNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jare Jesús uyupi ye penti chalana pe jare oo ye ɨ guasu jovaicho pe. Jayave oo uvãe jenta guasu pe. ");
INSERT INTO gnwNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Jayave amocue vae güeru penti cuimbae imbaerasɨ vae. Cua cuimbae ipuere mbae omɨ vae. Jupa pe oĩ. Jesús cua uecha yave, uicuaa jae reta güɨrovia co jese, jare jei cuimbae ipuere mbae omɨ vae pe: —Iyerovia, cherɨvɨ. Nembaeyoa reta uyembai ma —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Jayave amocue mboroyocui re oporomboe vae reta ipɨa pe uyemɨngueta: “Cua cuimbae jei icavi mbae vae Tumpa cotɨ.” ");
INSERT INTO gnwNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ẽrei Jesús uicuaa jae reta ipɨayemɨngueta, jare jei chupe reta: —¿Maera pa penoi pepɨa pe yemɨngueta icavi mbae vae reta? ");
INSERT INTO gnwNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Chepuere jae cua cuimbae pe: ‘Nembaeyoa reta uyembai ma.’ Jae ramiño vi chepuere jae chupe: ‘Epũa eguata.’ ¿Mbae nunga pa yavai jae vaerã? —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ẽrei aipota picuaa vaerã cua: Che cuimbaerã ayeyapo vae chepuere ambɨasa quía pe imbaeyoa reta cua ɨvɨ pe aĩ rambueve —jei. Jayave jei cuimbae ipuere mbae omɨ vae pe: —Epũa evoɨ nderupa, jare ecua nerenta pe. ");
INSERT INTO gnwNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Jayave cuimbae upũa, jare oẽ oo jenta cotɨ. ");
INSERT INTO gnwNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ẽrei jeta joco pe ñugüɨnoi vae reta uecha yave, uquɨye jare umbɨadora reta Tumpa, mbaepuere tuicha vae umee Jesús pe ramo. ");
INSERT INTO gnwNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jare Jesús joco güi oo yave, uecha penti cuimbae Mateo jee vae uguapɨ oĩ mburuvicha peguarã ocovara ñugüɨnoi vae pe, jare jei chupe: —Eyu cherupíe. Jayave Mateo upũa, jare oo jae jupíe. ");
INSERT INTO gnwNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Jare Jesús ucaru oĩ rambueve Mateo jenta pe, jeta mburuvicha peguarã ocovara vae reta jare teco icavi mbae vae uyapo vae reta yugüeru ucaru vaerã Jesús jare jemimboe reta ndive. ");
INSERT INTO gnwNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Jare fariseo reta cua uecha yave, jei Jesús jemimboe reta pe: —¿Maera pa ucaru pemboe vae ocovara vae reta jare teco icavi mbae vae uyapo vae reta ndive? ");
INSERT INTO gnwNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ẽrei Jesús cua uyandu yave, jei chupe reta: —Icove catu vae reta ueca'ã upurupɨano vae. Imbaerasɨ vae retaño ueca —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Pecua piyemboe mbae uipota jei cua: ‘Aipota pepuruparareco vaerã, aipota'ã maemɨmba uyeyucacue reta pemee cheve vaerãño.’ Echa'ã che ayu aeca vaerã iyoa vae reta. Ayu'ã aeca vaerã jupi vae reta —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Jayave yugüeru Juan jemimboe reta Jesús oĩ vae pe jare upɨrandu chupe: —¿Maera pa ore jare fariseo reta nduyecuacu tembíu güi, ẽrei nderemimboe reta uyecuacu'ã tembíu güi? ");
INSERT INTO gnwNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jayave Jesús jei chupe reta: —Umendata vae pe ñugüɨnoi vae reta ndarau etei uyecuacu tembíu güi, umendata vae jae reta ndive oĩ rambueve. Ẽrei outa uvãe ara umendata vae uyereraaca vaerã chugüi reta. Jayave ramo uyecuacuta tembíu güi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Icavi'ã yamboya vaerã temimonde indechi vae maemboyaa ipɨau vae pe. Echa'ã jucuarãi yayapo yave, maemboyaa ipɨau vae umɨãta temimonde indechi vae, jare temimonde jeiete osoro —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Jae ramiño vi icavi'ã yambɨru vaerã vino ipɨau vae vino jɨru guacapi indechi vae pe. Echa'ã jucuarãi yayapo yave, vino omondoro jɨru, jare vino uyepɨyere, jare jɨru icavi'ã ma. Jáeramo yambɨru vino ipɨau vae jɨru ipɨau vae pe. Echa'ã jucuarãi yayapo yave, jɨru osoro'ã jare vino uyepɨyere'ã —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jare Jesús cua jei chupe reta rambueve, ou Jesús oĩ vae pe uvãe penti mburuvicha. Jae uyeatɨca Jesús jovai jare jei: —Cherayɨ umanota ma oĩ. Ẽrei yaa iñono ndepo jese embɨgüera, agüɨye vaerã umano —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jayave Jesús jare jemimboe reta yugüɨraa mburuvicha jupíe. ");
INSERT INTO gnwNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Jare penti cuña doce año ma uiporara tugüɨguasu vae oya Jesús re icupe cotɨ jare uyavɨquɨ jemimonde jembeɨ. ");
INSERT INTO gnwNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Echa'ã jae jei ma iyupe ipɨa pe: “Yepe tẽi jemimondeño tayavɨquɨ, acuerata co.” ");
INSERT INTO gnwNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ẽrei Jesús uyerova, jare uecha yave, jei chupe: —Cherindɨ, ndepɨacatu. Ndecuera ma nderovia cheré ramo. Jare jupivoiño cuña ucuera. ");
INSERT INTO gnwNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Jare Jesús uique mburuvicha jo pe yave, uecha uyemimbɨ vae reta umɨñee ma jemimbɨ reta teõgüe güɨraa oñotɨ vaerã jare jeta joco pe yatɨ ñugüɨnoi vae reta umbɨapu ñugüɨnoi. ");
INSERT INTO gnwNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Jayave jei chupe reta: —Pecua oca pe. Cua cuñatai umano'ã co. Oqueño co oĩ —jei. Ẽrei joco pe ñugüɨnoi vae reta oyoyai Jesús. ");
INSERT INTO gnwNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Jayave Jesús omoẽ opaete vae oca pe. Jayave uique ye o pe jare uipɨsɨ cuñatai ipo pe, jare cuñatai upũa voi. ");
INSERT INTO gnwNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Jare opaete jocua ɨvɨ pegua reta pe jerãcua quirãi Jesús uyapo cua mɨacañɨ. ");
INSERT INTO gnwNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jare Jesús joco güi oo yave, mocui cuimbae jesa mbae vae reta yugüɨraa jaɨcue, jare iñeeãta reve jei chupe: —Nde co jae David iñemoñaa reta pegua. Oreparareco. ");
INSERT INTO gnwNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jare Jesús uique ma yave o pe, cuimbae jesa mbae vae reta vi uique jaɨcue. Jayave Jesús upɨrandu chupe reta: —¿Perovia pa chepuere co ayapo cua peve? —Ndugüɨrovia, oreYa —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Jayave Jesús uyavɨquɨ jae reta jesa, jare jei chupe reta: —Perovia ramo, pemae. ");
INSERT INTO gnwNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Jare mocui reve ipuere umae. Jayave Jesús jei chupe reta: —Agüɨye pemɨmbeu quía pe ave. ");
INSERT INTO gnwNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ẽrei jae reta yugüɨraa ma yave, umɨmbeu jeta jocua ɨvɨ pegua reta pe Jesús uyapo chupe reta vae. ");
INSERT INTO gnwNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Jare jae reta yugüɨraa ma yave, ĩru vae reta güeru Jesús oĩ vae pe penti cuimbae iupa vae, aña oya jese vae. ");
INSERT INTO gnwNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jayave Jesús umbɨsɨrɨ aña chugüi jare iupa vae umbɨpɨ uyemɨngueta. Jare jeta vae reta ipɨacañɨ jare jei reta: —Yaecha'ãi cua nunga mɨacañɨ Israel pe. ");
INSERT INTO gnwNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ẽrei fariseo reta jei: —Aña guasu imbaepuere pe umbɨsɨrɨ aña reta oya jese vae reta güi. ");
INSERT INTO gnwNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jare Jesús oo opaete tenta guasu reta jare tenta guasu-raɨ reta rupi, jare oporomboe judío reta itupaopao pe. Umɨmbeu ñee icavi vae Tumpa iporoyocuia pegua, jare umbɨgüera imbaerasɨ vae reta ipotave mbaerasɨ güi. ");
INSERT INTO gnwNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ẽrei uecha yave jeta vae, uiparareco umae jese reta. Echa'ã jae reta uyemɨpɨa'ã jare ipɨatɨtɨ. Ovecha mbaetɨ iyandarecoa güɨnoi vae reta rami co. ");
INSERT INTO gnwNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Jayave Jesús jei jemimboe reta pe: —Jeta ete co yaavɨro vaerã. Ẽrei mbovɨ ete co umbaevɨro vae reta. ");
INSERT INTO gnwNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Jáeramo pe reta piyerure yandeYa pe omondo vaerã uparavɨquɨ vae reta umbaevɨro reta vaerã —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Penti ara Jesús umbatɨ jocua doce jemimboe reta, jare umee chupe reta mbaepuere umbɨsɨrɨ vaerã aña reta oya jese vae reta güi jare umbɨgüera vaerã imbaerasɨ vae reta ipotave mbaerasɨ güi. ");
INSERT INTO gnwNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Cua co jae jocua doce Jesús jemimondo reta jee: Simón (Pedro jee vae), jare Simón tɨvɨ Andrés jee vae, jare Zebedeo taɨ reta Jacobo jare Juan jee vae, ");
INSERT INTO gnwNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe, Bartolomé, Tomás, Mateo ocovara vae, Alfeo taɨ Jacobo jee vae, Tadeo, ");
INSERT INTO gnwNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simón (jae co Zelote pe ueni vae), jare Judas Iscariote (cua cuimbae umee Jesús jovaicho reta pe). ");
INSERT INTO gnwNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jare ndei omondo reta mbove, Jesús oyocui cua doce reve. —Agüɨye pecua judío mbae vae reta ñugüɨnoi vae pe. Agüɨye pecua Samaritano jenta guasu reta pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Pecua Israel pegua reta ñugüɨnoi vae pe. Echa'ã jae reta ovecha ucañɨ vae reta rami co —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Jare peguata rambueve, pemɨmbeu ĩru vae reta pe cuarãi: ‘Mboroyocuia ara pegua outa ma uvãe’ —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Pembɨgüera imbaerasɨ vae reta. Pembɨgüera ipire ocui vae reta. Pembɨjecove ye umanocue vae reta. Pembɨsɨrɨ aña reta oya jese vae reta güi. Che amee ma peve cua mbaepuere jepɨ mbae reve. Jáeramo agüɨye pecovara mbae quía pe piyapota chupe vae re —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Agüɨye peraa oro jare corepoti. ");
INSERT INTO gnwNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Agüɨye vi peraa peurupucu, jare agüɨye peraa mocui camisa. Peraa jaeño penti pepopoca jare pepɨpasa pemonde vae. Echa'ã icavi co ĩru vae reta umbɨepɨ vaerã uparavɨquɨ vae pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Jare peo yave penti tenta guasu pe ani penti tenta guasu-raɨ pe, pepɨrandu quía ra pepuere perovia catu joco pe. Jayave pico joco pe peo ye regua —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Jare pevãe yave penti tenta pe, pere: ‘Tumpa tumee peve mbɨacatu.’ ");
INSERT INTO gnwNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Jare pepuere yave perovia catu joco pe yugüɨreco vae reta, Tumpa umeeta chupe reta mbɨacatu. Ẽrei pepuere'ã yave perovia catu, pe retaño penoita mbɨacatu —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Jare ime yave tenta pegua reta ani tenta guasu pegua reta uipota'ã pepɨta vaerã joco pe jare uipota'ã uyapɨsaca peré vae, pecuaño joco güi, jare pemɨtɨmo ɨvɨcuii pepɨ güi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Añete co jae peve, Tumpa uãa yave ɨvɨ pegua reta, jocua tenta guasu pegua reta tanta uiporarata Sodoma jare Gomorra pegua reta güi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Mase, pomondo icavi mbae vae uyapo vae reta ipɨte rupi. Pe reta ovecha reta rami co. Jae reta co yaguapɨ̃ta reta rami. Jáeramo pearacuaa catu mboi iyaracuaa catu rami. Jae ramiño vi agüɨye piyapo icavi mbae vae pɨcasu uyapo'ã icavi mbae vae rami —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Piñemoa ngatu. Echa'ã ĩru vae reta pereraata mburuvicha reta yatɨ vae pe, uñeapo vaerã peré. Jare penupata judío reta itupao reta pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Jare piyereraacata mburuvicha reta jare mburuvicha guasu reta jovai chereco pegua, pepuere vaerã chemɨmbeu chupe reta jare judío mbae vae reta pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ẽrei jae reta pemee yave, agüɨye piyemɨpɨa'ã mbae pereta mburuvicha reta pe vae re. Echa'ã Espíritu Santo uicuaacata peve jocua ora pe etei mbae pere vaerã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Echa'ã peRu iEspíritu pemborɨta piyemɨngueta vaerã, pe retaiño'ã co piyemɨnguetata —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Jare penti cuimbae umeeta tɨvɨ uyeyucaca vaerã. Jae ramiño vi penti cuimbae umeeta taɨ uyeyucaca vaerã. Jare sambiaɨ reta oyovaichota tu jare ichɨ ndive, jare uyucacata —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Jare piñemɨtarẽɨcata opaete vae pe chereco pegua. Ẽrei jõsata oo uvãe iyapɨ pe vae uyembɨasacata co —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ẽrei penti tenta guasu pe uyapo reta icavi mbae vae peve yave, pesi ĩru tenta guasu pe. Añete che jae peve, ndarau peo opaete Israel pegua reta jenta guasu pe ndei che cuimbaerã ayeyapo vae ayu ye mbove —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Penti uyemboe oĩ vae uicuaa ete'ã oporomboe vae uicuaa vae rami. Jae ramiño vi penti uyeyocui vae imbaepuere tuicha'ã ete ipatrón imbaepuere rami —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Icavi co penti uyemboe oĩ vae uyemboe cavi vaerã oporomboe vae uicuaa vae re. Jae ramiño vi icavi co penti uyeyocui vae uiporu cavi vaerã mbaepuere ipatrón umee chupe vae. Che co jae peYa, jare ĩru vae reta chembɨjee Beelzebú. Jáeramo pembɨjeeta Beelzebú taɨ reta. Echa'ã pe reta piyeyocui cheve —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Ẽrei agüɨye pequɨye chugüi reta. Ime yave mbae uyeyasoi vae, uyeechacañotai co. Jare ime yave mbae uñeñomi vae, uyecuaañotai co —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Pɨ̃tumimbi pe che jae peve vae re piyemɨngueta tembipe pe. Jare che jae vɨari peve vae pemɨmbeu opaete vae pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Agüɨye pequɨye upuruyuca vae reta güi. Echa'ã pereteño ipuere uyuca. Ipuere'ã uyuca perecove. Pequɨye Tumpa güi. Echa'ã jae ipuere omondo quía jete jare jecove tata guasu pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Picuaa co quirãi umaemee vae reta umee mocui güɨra-raɨ mbovɨ ete corepoti re. Ẽrei mbaetɨ penti yepe umano oa ɨvɨ pe peRu uicuaa'ã reve —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Tumpa uicuaa mbovɨ pea penoi peãca re vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Jáeramo agüɨye pequɨye. Echa'ã Tumpa perau ete jeta güɨra-raɨ reta güi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Ime yave quía ĩru vae reta jovaque jei yave: ‘Che co jae Jesús jemimboe’, che jaeta cheRu ara pe oĩ vae jovaque: ‘Cua co jae cheremimboe’ —jaeta, jei Jesús—. ");
INSERT INTO gnwNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ẽrei ime yave quía ĩru vae reta jovaque checuacu vae, che vi aicuacuta cheRu ara pe oĩ vae jovaque —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Aramoi pepɨa pe piyemɨngueta che ayu co amee vaerã mbɨacatu ɨvɨ pegua reta pe. Ẽrei jucuarãi'ã co. Che ayu uyembɨyao vaerã uyugüi ɨvɨ pegua reta, mbaetɨ güɨnoi vaerã mbɨacatu —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ayu penti cuimbae oyovaicho vaerã tu ndive, jare cuñatai oyovaicho vaerã ichɨ ndive, jare cuña oyovaicho vaerã imesɨ ndive —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Jare cuimbae jenta pegua reta oyovaichota jae ndive —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ime yave quía uau ete tu jare ichɨ chegüi vae, ndarau ipuere ico cheremimboerã. Jae ramiño vi ime yave quía uau ete isambiaɨ reta chegüi vae, ndarau ipuere ico cheremimboerã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Jare ime yave quía ovoɨ'ã icurusu oo vaerã cherupíe vae, ndarau ipuere ico cheremimboerã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Uipota uñuvatu jecove vae ndarau ipuere. Ẽrei umeeta jecove chereco pegua vae uñuvatuta co —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Ime yave quía uyapo icavi vae peve, cheve uyapo icavi vae. Jare jocua cheve uyapo icavi vae, uyapo vi icavi vae chembou vae pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ime yave quía icavi vae uyapo penti Tumpa iñee umɨmbeu vae pe Tumpa iñee umɨmbeu ramo, Tumpa umeeta chupe iñee umɨmbeu vae pe umeeta vae. Jae ramiño vi ime yave quía icavi vae uyapo penti jupi vae uyapo vae pe jupi vae uyapo ramo, Tumpa umeeta chupe jupi vae uyapo vae pe umeeta vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Añete che jae peve, ime yave quía umee penti vaso ɨ roɨ̃sa vae yepe penti sambiaɨ jou vaerã vae, uyapo yave jucuarãi jae co cheremimboe ramo, ambɨjecoviata co chupe —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jare Jesús opa ma oyocui yave jocua doce jemimboe reta, jae etei oo joco güi oporomboe vaerã jare umɨmbeu vaerã Tumpa iñee Israel pegua tenta guasu reta pe. ");
INSERT INTO gnwNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Jare Juan peresorɨru pe oĩ rambueve, uicuaa Cristo uyapo oĩ vae regua. Jayave ombou mocui jemimboe reta Jesús oĩ vae pe ");
INSERT INTO gnwNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","jei vaerã chupe: —¿Nde pa co jae Cristo outa vae? ani ¿nuãrota pa ĩru vae ou vaerã? ");
INSERT INTO gnwNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jayave Jesús jei chupe reta: —Pecua ye pemɨmbeu Juan pe piyandu jare peecha vae regua. ");
INSERT INTO gnwNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Jesa mbae vae reta umae ma. Ipuere mbae uguata vae reta uguata ma. Ipire ocui vae reta ucuera ma. Iyapɨsa mbae vae reta uyandu ma. Umanocue vae reta icove ye ma. Iparavete vae reta uyapɨsaca ñee icavi vae re —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Jare Tumpa umɨvendiseta jecuae güɨrovia cheré vae reta —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Jare yugüɨraa ye yave Juan ombou vae reta, Jesús umbɨpɨ umɨngueta joco pe ñugüɨnoi vae reta Juan re. Jei chupe reta: —¿Quía re pa co peo ñuu pe pemae? Jae ipɨrãta mbae vae'ã co tacuarãsɨ omɨ ɨvɨtu uipeyu yave vae rami —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Quía re pa co peo pemae? Jae omonde'ã temimonde ipõra vae. Mase, temimonde ipõra vae omonde vae reta yugüɨreco mburuvicha guasu reta jenta pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Quía re pa co peo pemae? ¿Peo ra pemae vaerã penti Tumpa iñee umɨmbeu vae re? Añete che jae peve, Tumpa umee chupe uyapo vaerã jeta ete ĩru Tumpa iñee umɨmbeu vae reta uyapo vae güi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Tumpa iñee uyecuatía oĩ jese cuarãi: ‘Mase’ —jei Tumpa—, ‘che amondota chiñee güɨraata vae nderenonde, uyapɨcatu vaerã nderaperã.’ Jucuarãi uyecuatía oĩ —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Añete che jae peve, Tumpa umee Juan upurumbɨbautizase vae pe uyapo vaerã jeta ete ĩru Tumpa iñee umɨmbeu vae reta uyapo vae güi. Ẽrei taɨcuegua vae ara pegua mboroyocuia pegua uyembutuichaca eteta Juan güi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Juan upurumbɨbautizase vae umbɨpɨ Tumpa iporoyocuia regua umɨmbeu güive, opaete vae uipota uique jocua mboroyocuia ara pegua pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Echa'ã opaete Tumpa iñee aracae umɨmbeu vae reta uicuatía vae jare mboroyocui vi uicuaaca Tumpa iporoyocuia regua ndei Juan ou mbove —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Jare pipota yave perovia, jae co Elías. Echa'ã Tumpa iñee aracae umɨmbeu vae jei outa co Elías —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Uipota uyandu vae tuyapɨsaca cua re —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Tamɨmbeu peve mbae ndive amboyovaque añave yugüɨreco vae reta. Jae reta co sambiaɨ plaza pe uguapɨ ñugüɨnoi vae reta rami. Jae reta jei uyupe cuarãi: ");
INSERT INTO gnwNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Nduyemimbɨ ma peve, ẽrei pe reta pepɨrae'ã. Orepɨatɨtɨ perovaque, ẽrei pe reta piyao'ã.’ Jucuarãi jei —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Echa'ã Juan ou, jare jae uyecuacu tembíu jare vino güi. Jáeramo uicuaa vae reta jei aña oya co Juan re —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Che cuimbaerã ayeyapo vae ayu, jare che ayecuacu'ã tembíu jare vino güi. Jáeramo checuaa vae reta jei cuarãi: ‘Mase, jae jou jeta tembíu jare vino. Jae co mburuvicha peguarã ocovara vae reta jare teco icavi mbae vae uyapo vae reta iamigo.’ Jucuarãi jei —jei—. Ẽrei opaete iyaracuaa vae reta uicuaaca aracuaa icavi co —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jayave Jesús umbɨpɨ uñeengata jocua tenta guasu jeta mɨacañɨ uyapo pɨpe vae reta pe. Echa'ã jocua tenta guasu pegua reta ueya'ã iyemɨngueta icavi mbae vae ipɨa pe oĩ vae. Jae jei: ");
INSERT INTO gnwNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—Corazín pegua reta uiporarata co. Betsaida pegua reta uiporarata co. Echa'ã jeta mɨacañɨ reta ayapo ipɨte pe chembaepuere pe. Jucuarãi ayapo yave mona Tiro jare Sidón pe, joco pegua reta ueyata tẽi aracae ma iyemɨngueta icavi mbae vae ipɨa pe oĩ vae. Omondeta tẽi temimonde jaimbe vae jare oñonota tẽi tanimbu iñãca re uicuaaca vaerã ipɨatɨtɨ co —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ẽrei che jae peve, Tumpa uãa yave ɨvɨ pegua reta, Corazín jare Betsaida pegua reta tanta uiporarata Tiro jare Sidón pegua reta güi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Jare Capernaum pegua reta ipɨa pe uyemɨngueta tẽi icavi co yugüɨreco vaerã Tumpa ndive. Ẽrei Tumpa omondota reta yugüɨreco vaerã cañɨtei pe. Echa'ã jeta mɨacañɨ reta ayapo ipɨte pe chembaepuere pe. Jucuarãi ayapo yave mona Sodoma pe, Sodoma ndarau tẽi uyembai —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ẽrei che jae peve, Tumpa uãa yave ɨvɨ pegua reta, Capernaum pegua reta tanta uiporarata Sodoma pegua reta güi —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Jayave Jesús jei: —CheRu, nde co jae ara pegua reta jare ɨvɨ pegua reta iYa. Amee yasurupai ndeve quirãi nde nemaeño'ã cua ɨvɨ pegua iyaracuaa vae reta re uicuaa vaerã cua mbaembae, ẽrei ndicuaaca sambiaɨ rami vae reta pe. ");
INSERT INTO gnwNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Icavi co, cheRu. Echa'ã icavi co ndeve ndiyapo vaerã jucuarãi —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Jayave jei vi: —CheRu umee ma cheve opaete. Mbaetɨ quía uicuaa cavi cheregua, jaeño cheRu. Jae ramiño vi mbaetɨ quía uicuaa cavi cheRu regua, jaeño che jare che aicuaaca chupe vae reta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Opaete piyemɨpɨa'ã jare pepɨatɨtɨ pico vae reta peyu checotɨ. Che tambuputuu perecove —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Piñemɨĩru che ndive jare piyemboe che aipota pomboe jese vae re. Echa'ã che añemɨmichi. Ayembutuicha'ã etei. Jucuarãi piyapo yave, perecove uputuuta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Echa'ã piñemɨĩru yave che ndive, ndarau piyemɨpɨa'ã jare ndarau pepɨatɨtɨ —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Mbutuu ara pe Jesús oo co rupi jemimboe reta ndive. Jesús jemimboe reta iyembaɨ jare umbɨpɨ uipoo trigo jare jou. ");
INSERT INTO gnwNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ẽrei fariseo reta uecha yave, jei Jesús pe: —Mase, nderemimboe reta uyapo ñugüɨnoi aguɨyeta tẽi uyapo mbutuu ara pe vae. ");
INSERT INTO gnwNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jayave Jesús jei chupe reta: —¿Pemɨngueta'ã pa David uyapocue vae regua, jae jare jae ndive ñugüɨnoi vae reta iyembaɨ yave? ");
INSERT INTO gnwNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","David uique Tumpa jo pe jare jou mbɨyape Tumpa jo pe uñeñono tee vae reta. Agüɨyeta tẽi co David jare jae ndive ñugüɨnoi vae reta jou jocua mbɨyape. Jaeño sacerdote reta ipuere jou —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Jare ¿pemɨngueta'ã etei pa mboroyocui pe quirãi mbutuu ara pe sacerdote Tumpa jo pe ñugüɨnoi vae reta uyapo agüɨyeta tẽi quía uyapo mbutuu ara pe vae? Ẽrei Tumpa umbɨjeco'ã reta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ẽrei che jae peve, che cua pe aĩ vae ayembutuichaca ete Tumpa jo güi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ẽrei picuaa'ã mbae uipota jei cua Tumpa iñee pe uyecuatía oĩ vae: ‘Aipota pepuruparareco vaerã’ —jei Tumpa—, ‘aipota'ã maemɨmba uyeyucacue reta pemee cheve vaerãño.’ Jucuarãi uyecuatía oĩ. Echa'ã picuaa yave mona, ndarau tẽi pembɨjeco mbaetɨ teco güɨnoi vae reta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Echa'ã che cuimbaerã ayeyapo vae chepuere jae mbae icavi uyeyapo vaerã mbutuu ara pe —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jare Jesús oo joco güi uique judío reta itupao pe. ");
INSERT INTO gnwNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Jare joco pe oĩ penti cuimbae ipo jovaicho tɨpa vae. Jare joco pe ñugüɨnoi vae reta upɨrandu Jesús pe: —¿Icavi pa yambɨgüera vaerã quía mbutuu ara pe? ¿Mbae pa jei mboroyocui cua re? —jei reta. Echa'ã jae reta uipota tẽi umbɨjeco Jesús. ");
INSERT INTO gnwNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jayave Jesús jei chupe reta: —Penti cuimbae güɨnoi yave penti ovecha, jare ovecha oa yave ɨvɨcua pe mbutuu ara pe, cuimbae uipɨsɨ voita güɨnoẽ ɨvɨcua güi. ");
INSERT INTO gnwNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ẽrei penti cuimbae jepɨ ete penti ovecha güi. Jáeramo jupi co yayapo vaerã icavi vae mbutuu ara pe —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Jayave jei cuimbae pe: —Eupi ndepo. Jayave cuimbae ipo uupi, jare ucuera voi. Oyovaque ma ipo jovaicho ipo icavi vae ndive. ");
INSERT INTO gnwNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Jayave fariseo reta oẽ judío reta itupao güi, jare uyemboemboe quirãi ra uyucacata Jesús. ");
INSERT INTO gnwNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ẽrei Jesús cua uicuaa yave, oo joco güi. Jare jeta vae reta yugüɨraa jaɨcue, jare Jesús umbɨgüera opaete imbaerasɨ vae reta. ");
INSERT INTO gnwNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Jare Jesús oyocui reta agüɨye vaerã umɨmbeu quía co jae vae. ");
INSERT INTO gnwNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Cua uyapo, uyeyapo vaerã Tumpa iñee aracae umɨmbeu vae Isaías jei vae. Echa'ã jae jei cuarãi: ");
INSERT INTO gnwNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Mase, jae co cherembiocui aiparavo vae” —jei Tumpa—. “Aau ete. Ayerovia tuicha jese. Ameeta chupe cheEspíritu, jare jae uãata judío mbae vae reta. ");
INSERT INTO gnwNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ndarau uyeaca quía ndive. Ndarau vi quía uyandu iñee calle rupi. ");
INSERT INTO gnwNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ndarau uaquɨo tacuarãsɨ uyeca vae. Ndarau vi ombove mechero michi ete jendɨ oĩ vae, ndei upurumɨamɨri upuruãa vaerã mbove. ");
INSERT INTO gnwNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Jare jae jee re judío mbae vae reta güɨroviata.” Jucuarãi jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Jayave amocue vae güeru Jesús oĩ vae pe penti cuimbae aña oya jese vae. Cuimbae jesa mbae vae jare iupa vi. Jare Jesús umbɨgüera. Cuimbae umae ma jare uyemɨngueta ma. ");
INSERT INTO gnwNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Jare opaete joco pe ñugüɨnoi vae reta ipɨacañɨ jare jei: —¿Cua ra co jae David iñemoñaa reta pegua? ");
INSERT INTO gnwNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ẽrei fariseo reta cua uyandu yave, jei reta: —Aña guasu Beelzebú imbaepuere pe umbɨsɨrɨ aña reta oya jese vae reta güi. ");
INSERT INTO gnwNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesús uicuaa fariseo reta ipɨayemɨngueta jare jei chupe reta: —Penti tenta guasu pegua reta oyovaicho uyupii yave, opata co jocua tenta guasu. Jae ramiño vi penti tenta pegua reta oyovaicho uyupii yave, opata co jocua tenta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Jare Satanás umbɨsɨrɨ yave Satanás oya jese vae reta güi, imbaepuere uyembɨyao ma co. Jáeramo ndarau etei ma oĩ iporoyocuia —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ẽrei che ambɨsɨrɨ yave aña reta oya jese vae reta güi Beelzebú imbaepuere pe, ¿quía imbaepuere pe ra umbɨsɨrɨ aña reta oya jese vae reta güi perentarã reta? Pepuere pepɨrandu chupe reta jese —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ẽrei che ambɨsɨrɨ aña reta oya jese vae reta güi Tumpa iEspíritu imbaepuere pe. Jáeramo pepuere picuaa ou ma co uvãe peve Tumpa iporoyocuia —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ime yave quía uipota uique cuimbae ipɨrãta vae jenta pe upɨ̃ro vaerã imbaembae chugüi vae, uipocuata rani cuimbae ipɨrãta vae. Jayave ramo ipuereta upɨ̃ro imbaembae chugüi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ime yave quía uipota'ã ico cheĩrurã vae, oyovaicho co che ndive. Jae ramiño vi ime yave quía chemborɨ'ã vae, uyapo co icavi mbae vae checotɨ —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Jáeramo che jae peve, opaete ɨvɨ pegua reta imbaeyoa reta jare opaete iñee icavi mbae Tumpa cotɨ vae Tumpa ipuere umbai. Ẽrei Tumpa ndarau etei umbɨasa jei icavi mbae vae Espíritu Santo cotɨ vae pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Jare ime yave quía jei icavi mbae vae che cuimbaerã ayeyapo vae cotɨ vae, Tumpa umbɨasata chupe. Ẽrei ime yave quía jei icavi mbae vae Espíritu Santo cotɨ vae, Tumpa ndarau etei umbɨasa chupe, añave jare ara reta outa vae pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Penoi yave temitɨ icavi vae, penoita vi ía icavi vae. Jae ramiño vi penoi yave temitɨ icavi mbae vae, penoita vi ía icavi mbae vae. Echa'ã peecha yave temitɨ ía, picuaata icavi ra temitɨ —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Pe reta co jae mboi pochɨ vae reta rami. Echa'ã pe reta piyapo icavi mbae vae. Jáeramo pepuere'ã etei pere icavi vae. Echa'ã penti penti uyemɨngueta ipɨa pe güɨnoi vae rupi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Quía nunga jecocavi vae güɨnoi icavi vae ipɨa pe. Jáeramo jei icavi vae. Jae ramiño vi quía nunga jecopochɨ vae güɨnoi icavi mbae vae ipɨa pe. Jáeramo jei icavi mbae vae. ");
INSERT INTO gnwNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ẽrei che jae peve, jocua ara Tumpa upuruãa yave, jae umbɨjecota ɨvɨ pegua reta opaete ñee icavi mbae vae regua re —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Echa'ã Tumpa jeita icavi vae co piyapo, icavi vae pere yave. Jae ramiño vi Tumpa jeita icavi mbae vae co piyapo, icavi mbae vae pere yave —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Jayave amocue mboroyocui re oporomboe vae reta jare fariseo reta jei Jesús pe: —Oporomboe vae, nduipota ndiyapo vaerã mbae ndicuaaca vaerã oreve quía co nde. ");
INSERT INTO gnwNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jayave Jesús jei chupe reta: —Añave yugüɨreco vae reta icavi mbae vae uyapo vae reta co. Upurugüɨrovia'ã. Jáeramo uipota ayapo vaerã mɨacañɨ chupe reta. Ẽrei jaeño uyeyapota mbae Tumpa iñee aracae umɨmbeu vae Jonás pe uyeyapo vae rami, jae reta uicuaa vaerã quía co che —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Echa'ã Jonás upɨta mbapɨ ara jare mbapɨ pɨare jocua pira guasu jɨe pe. Jae ramiño vi che cuimbaerã ayeyapo vae apɨtata mbapɨ ara jare mbapɨ pɨare ɨvɨgüɨ pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Tumpa upuruãa yave, Nínive pegua reta upũata umbɨjeco vaerã añave yugüɨreco vae reta. Echa'ã jae reta ueya iyemɨngueta icavi mbae vae ipɨa pe oĩ vae, Jonás umɨmbeu chupe reta yave Tumpa iñee. Ẽrei chembaepuere tuicha ete co Jonás imbaepuere güi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Tumpa upuruãa yave, jocua cuña mburuvicha guasu ico sur cotɨ vae upũata umbɨjeco vaerã añave yugüɨreco vae reta. Echa'ã jae ou mbɨrɨ ete güi uyapɨsaca vaerã Salomón iyaracuaa catu vae re. Ẽrei che chearacuaa catu ete Salomón güi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Penti aña usɨrɨ ma yave oya jese vae güi, uguata ñana rupi ueca quiape ico vaerã. Ẽrei ipuere'ã yave uvãe quiape ico vaerã, ");
INSERT INTO gnwNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","jei iyupe: Taa ye jocua chero ayu chugüi vae pe —jei, jei—. Echa'ã yandepuere yamɨjaanga penti o jocua cuimbae aña usɨrɨ ma chugüi vae re. Aña ou ye uvãe yave jocua o pe, uecha ipo'ã. O iya utupei ma jare uyapɨcatu —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Jayave oo ye aña güeru siete aña icavi mbae ete chugüi vae reta jocua o pe. Jayave ocho reve uique o pe, joco pe yugüɨreco vaerã. Tenonde yave, penti aña oya jese yave, jocua cuimbae uiporara. Ẽrei taɨcue rupi ocho aña reta oya jese. Jáeramo tanta uiporara. Jae ramiño vi uyeyapota añave yugüɨreco vae icavi mbae vae uyapo vae reta pe —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jare Jesús uyemɨngueta rambueve joco pe ñugüɨnoi vae reta pe, Jesús ichɨ jare tɨvɨ reta yugüeru uvãe jae oĩ vae pe, jare oca pe ñugüɨnoi. Jae reta uipota uyemɨngueta Jesús ndive. ");
INSERT INTO gnwNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Jayave penti joco pe oĩ vae jei Jesús pe: —¡Aipo! Ndesɨ jare nderɨvɨ reta oca pe ñugüɨnoi. Uipota uyemɨngueta nde ndive —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ẽrei Jesús jei chupe: —¿Quía nunga pa co jae chesɨ jare cherɨvɨ reta? ");
INSERT INTO gnwNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Jayave uupi ipo jemimboe reta cotɨ, jare jei: —Cua nunga reta co jae chesɨ jare cherɨvɨ reta. ");
INSERT INTO gnwNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Echa'ã opaete cheRu ara pe oĩ vae jei vae uyapo vae reta co jae cherɨvɨ jare cherindɨ jare chesɨ —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Jocua ara Jesús oẽ tenta güi oo uguapɨ ɨ guasu jembeɨ pe. ");
INSERT INTO gnwNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Jare jeta vae uyembatɨ Jesús oĩ vae pe. Jáeramo Jesús uyupi penti chalana ɨ guasu pe oĩ vae pe, jare uguapɨ pɨpe. Jare yatɨ vae reta uyemboɨ ñugüɨnoi ɨ guasu jembeɨ pe. ");
INSERT INTO gnwNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Jare Jesús omboe reta jeta mbaembae re umɨjaanga reve. Jei chupe reta: —Penti cuimbae oo umaetɨ vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Umaetɨ yave, umɨai temitɨ, jare amocue oa tape rupi. Jayave yugüeru güɨra reta opa jou —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ĩru temitɨ oa mbovɨño ɨvɨ itape iárambo oĩ vae pe. Cua ɨmambae oẽ, jeta'ã ɨvɨ chupe ramo —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ẽrei guarasɨ jasɨ yave, ipiru. Jare japo quɨpe'ã oĩ ramo, utini —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ĩru temitɨ oa ñanapɨte pe. Ñana ucuacuaa yave, opa uyuca temitɨ. ");
INSERT INTO gnwNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Jare ĩru temitɨ oa ɨvɨcavi pe. Cua reta ucuacuaa cavi jare ía. Amocue jeta ete jãɨ, jare ĩru jeta catu jãɨ, jare ĩru mbovɨño jãɨ —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Uipota uyandu vae tuyapɨsaca cua re —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Jayave Jesús jemimboe reta yugüeru upɨrandu chupe: —¿Maera pa nemɨngueta reta nemɨjaanga reve? ");
INSERT INTO gnwNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jayave Jesús jei chupe reta: —Amɨmbeu ma peve mboroyocuia ara pegua regua. Cua uyecuaa'ã ĩru vae reta pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Echa'ã güɨnoi vae pe uñemɨĩruta, jeta güɨnoi vaerã. Ẽrei mbaetɨ güɨnoi vae güi mbovɨ ete güɨnoi vae uyeequita —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Jáeramo amɨngueta reta amɨjaanga reve, agüɨye vaerã uicuaa cavi, yepe tẽi uecha, jare agüɨye vaerã uicuaa, yepe tẽi uyandu —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Jare uyeyapo chupe reta Tumpa iñee aracae umɨmbeu vae Isaías jei vae. Echa'ã jae jei cuarãi: ‘Piyandu tẽita, ẽrei ndarau picuaa. Peecha tẽita, ẽrei ndarau picuaa cavi. ");
INSERT INTO gnwNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Echa'ã cua reta ipɨatanta, jare iyapɨsa pe uyandu tẽi, jare usapɨmiño, agüɨye vaerã uecha jesa pe, jare agüɨye vaerã uyandu iyapɨsa pe, jare agüɨye vaerã uicuaa ipɨa pe, jare agüɨye vaerã uyerova checotɨ. Echa'ã uyerova checotɨ yave, ambaita tẽi imbaeyoa reta’ —jei Tumpa. Jucuarãi jei Isaías —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ẽrei Tumpa pemɨvendise ma. Echa'ã pe reta peecha peresa pe, jare piyapɨsaca peapɨsa pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Añete che jae peve, jeta Tumpa iñee aracae umɨmbeu vae reta jare jupi vae reta uipota tẽi uecha pe reta peecha ma vae, ẽrei uecha'ã. Jae ramiño vi jae reta uipota tẽi uyandu pe reta piyandu ma vae, ẽrei uyandu'ã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Amɨmbeu ma peve amɨjaanga reve cuimbae umaetɨ vae. Jáeramo piyapɨsaca ye jese —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ime yave quía uyapɨsaca Tumpa iporoyocuia re vae, uicuaa cavi'ã yave uyandu vae, ou voi jocua icavi mbae vae jare umɨacañɨ Tumpa iñee güi. Amɨjaanga cua nunga re temitɨ tape rupi oa vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Jae ramiño vi jocua temitɨ uñeñotɨ mbovɨño ɨvɨ itape iárambo oĩ vae pe vae uyemɨjaanga ĩru vae reta Tumpa iñee uyandu vae re. Jupivoiño uyerovia reta, jare uipota cua ñee —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ẽrei cua reta jocua temitɨ japo quɨpe'ã oĩ vae rami co. Jáeramo ɨmambae icueri reta. Mbaesusere uyeyapo chupe reta ani ĩru vae reta uyapo icavi mbae vae chupe reta Tumpa iñee uicuaa ramo. Jare jupivoiño uipota'ã ma uyapɨsaca reta Tumpa iñee re —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Jae ramiño vi jocua temitɨ uñeñotɨ ñanapɨte pe vae uyemɨjaanga ĩru vae reta Tumpa iñee uyandu vae re. Ẽrei jae reta umbɨpɨ uyemɨpɨa'ã ɨvɨ pe mbaembae uyeyapo vae re, jare uyembɨtavɨ, uipota icocatu ramo. Jare opaete cua umɨacañɨ reta Tumpa iñee güi. Jáeramo jae reta jocua temitɨ ia'ã vae rami co —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ẽrei jocua temitɨ uñeñotɨ ɨvɨcavi pe vae uyemɨjaanga ĩru vae reta Tumpa iñee uyandu vae re. Cua reta uicuaa cavi Tumpa iñee. Amocue vae jocua temitɨ jeta ete jãɨ vae rami co. Ĩru vae reta jocua temitɨ jeta catu jãɨ vae rami co. Jare ĩru vae reta jocua temitɨ mbovɨño jãɨ vae rami co —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesús imiari ye yatɨ vae reta pe umɨjaanga reve. Jei chupe reta: —Mboroyocuia ara pegua penti cuimbae temitɨ icavi vae ico pe oñotɨ vae rami co. ");
INSERT INTO gnwNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ẽrei opaete vae oque rambueve, cuimbae jovaicho ou oñotɨ trigo-raanga trigo ipɨte rupi, jare oo ye —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Trigo ucuacuaa jare ía. Ẽrei ucuacuaa vi trigo-raanga trigo ipɨte rupi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Jáeramo co iya jembiocui reta yugüeru ipatrón pe jei chupe: ‘Patrón, ¿niñotɨ'ã pa trigo icavi vae ndeco pe? ¿Maera pa ucuacuaa trigo-raanga?’ —jei reta, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Jayave ipatrón jei chupe reta: ‘Penti cherovaicho oñotɨ.’ Jayave jembiocui reta jei chupe: ‘¿Ndipota pa ndoo vaerã nduequi trigo-raanga?’ ");
INSERT INTO gnwNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ẽrei ipatrón jei: ‘Agüɨye peequi. Echa'ã peequi yave trigo-raanga, aramoi peequita vi trigo trigo-raanga ndive’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","‘Tucuacuaa pãve mocui reve trigo yaipoo regua. Jare yaipoo yave, jaeta uipoo vae reta pe: Pembatɨ rani trigo-raanga piyocua peapɨ vaerã. Ẽrei pembatɨ trigo jɨru pe’ —jei, jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesús imiari ye yatɨ vae reta pe umɨjaanga reve. Jei chupe reta: —Mboroyocuia ara pegua penti mostaza jãɨcue cuimbae güɨraa oñotɨ ico pe vae rami co. ");
INSERT INTO gnwNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Cua jãɨcue michi-raɨ ete opaete ĩru temitɨ reta jãɨcue güi. Ẽrei ucuacuaa ma yave, tuicha ete opaete ĩru temitɨ penti año peguaño ucuacuaa vae reta güi. Uyeyapo penti ɨvɨra. Jáeramo güɨra reta ipuere uyapo jaitɨrã jãca reta re —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jesús imiari ye yatɨ vae reta pe umɨjaanga reve. Jei chupe reta: —Mboroyocuia ara pegua levadura rami co. Cuña umbɨyea levadura jeta catu harina ndive, levadura uñemɨai vaerã opaete masa rupi —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Opaete cua jei Jesús yatɨ vae reta pe umɨjaanga reve. Jare jecuaeño imiari chupe reta umɨjaanga reve, ");
INSERT INTO gnwNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","uyeyapo vaerã Tumpa iñee aracae umɨmbeu vae jei vae. Echa'ã jei cuarãi: “Chemiarita amɨjaanga reve. Amɨmbeuta ɨvɨ uyeyapo güive uyecuaa mbae vae.” Jucuarãi jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jayave Jesús omondo ye yatɨ vae reta, jare uique o pe. Jare Jesús jemimboe reta yugüeru jei chupe: —Nemɨmbeu ma oreve nemɨjaanga reve jocua co trigo-raanga ucuacuaa pɨpe vae. Emɨmbeu oreve mbae uipota jei vae. ");
INSERT INTO gnwNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jayave Jesús jei chupe reta: —Temitɨ icavi vae oñotɨ vae uyemɨjaanga che cuimbaerã ayeyapo vae re. ");
INSERT INTO gnwNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Jocua co uyemɨjaanga opaete ɨvɨ re. Trigo icavi vae uyemɨjaanga Tumpa iporoyocuia pegua reta re. Ẽrei trigo-raanga uyemɨjaanga icavi mbae vae uyapo vae reta re —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Jocua co iya jovaicho trigo-raanga oñotɨ vae uyemɨjaanga aña guasu re. Mbaepoo uyemɨjaanga cua ara reta iyapɨ re. Umbaepoo vae reta uyemɨjaanga ángel reta re —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Jocua trigo-raanga uyembatɨca jare ocai tata pe. Jae ramiño vi jucuarãita uyeyapo cua ara reta iyapɨ pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Che cuimbaerã ayeyapo vae ambouta ángel cheve uyeyocui vae reta, jare jae reta umbatɨta opaete iyoa vae reta jare icavi mbae vae uyapo vae reta, omombo reta vaerã cheporoyocuia güi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Jare omombota reta tata guasu pe. Joco pe uyaota reta jare jãi umbɨquɨrɨrɨuta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Jayave jupi vae reta uyecuaata Tu iporoyocuia pe guarasɨ jembipe rami. Uipota uyandu vae tuyapɨsaca cua re —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Mboroyocuia ara pegua corepoti uñeñotɨ vae rami co. Echa'ã penti cuimbae uvãe yave jocua corepoti uñeñotɨ vae, oñomi ye, jare uyerovia reve oo umee corepoti re opaete imbaembae ogua vaerã jocua co —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Mboroyocuia ara pegua penti umaemee vae ita ipõra vae reta ueca vae rami co —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Uvãe yave penti ita ipõra vae jepɨ ete vae, oo umee corepoti re opaete imbaembae ogua vaerã jocua ita ipõra vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Mboroyocuia ara pegua penti pɨsa rami co. Echa'ã cuimbae reta omombo pɨsa ɨ guasu pe omboa vaerã ipotave jevae ɨ rupigua reta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Jare pɨsa tɨnee ma yave, cuimbae reta güeru ɨ guasu jembeɨ pe. Jayave uguapɨ joco pe jare umbatɨ umbɨru jevae ɨ rupigua icavi vae reta jɨru pe, ẽrei omombo jevae ɨ rupigua icavi mbae vae reta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Jae ramiño vi jucuarãita uyeyapo cua ara reta iyapɨ pe. Ángel reta yugüeruta jare umbatɨta icavi mbae vae uyapo vae reta omombo vaerã jupi vae reta ipɨte güi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Jare omombota reta tata guasu pe. Joco pe uyaota reta jare jãi umbɨquɨrɨrɨuta —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jayave Jesús upɨrandu chupe reta: —¿Picuaa cavi ma pa opaete cua? —Nduicuaa cavi ma, oreYa —jei reta chupe. ");
INSERT INTO gnwNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Jayave Jesús jei chupe reta: —Penti mboroyocui re oporomboe vae mboroyocuia ara pegua re uyemboe vae, penti tenta iya rami co. Echa'ã tenta iya umee jenta pegua reta pe mbaembae ipɨau vae jare mbaembae indechi vae jo pe uñuvatu vae güi —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jare Jesús opa ma yave cua jei umɨjaanga reve, oo ye joco güi. ");
INSERT INTO gnwNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Jare oo uvãe yave iɨvɨ pe, oporomboe judío reta itupao pe, jare uyapɨsaca jese vae reta ipɨacañɨ jare jei. —¿Quíape ra uyemboe cua cuimbae iyaracuaa catu vaerã? ¿Quía ra umee chupe mbaepuere cua mɨacañɨ reta uyapo vaerã? ");
INSERT INTO gnwNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Jae co carpintero taɨ. Jae co María imembɨ. Jae co Jacobo, José, Simón jare Judas tɨqueɨ —jei reta—. ");
INSERT INTO gnwNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Jare opaete jindɨ reta yugüɨreco yandepɨte pe. Jáeramo ¿quirãi ra ipuere uyapo opaete cua? —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Jáeramo jae reta pochɨ Jesús pe. Jayave Jesús jei chupe reta: —Opaete vae uipɨu penti Tumpa iñee umɨmbeu vae. Jaeño jentaɨgua reta jare jenta pegua reta uipɨu'ã reta —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Jare joco pe ipuere'ã uyapo jeta mɨacañɨ reta jae reta güɨrovia'ã jese ramo. ");
INSERT INTO gnwNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Jare jocua ara reta pe mburuvicha guasu Herodes uyandu Jesús regua. ");
INSERT INTO gnwNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Jare jei jembiocui reta pe: —Jae co Juan upurumbɨbautizase vae. Icove ye ma ou umanocue vae reta ipɨte güi. Jáeramo uyapo cua mɨacañɨ reta —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Echa'ã ndei Juan umano mbove, Herodes uipɨsɨca Juan, jare oñonoca peresorɨru pe, Herodías jei ramo. Herodías co jae Herodes tɨvɨ Felipe jee vae jembireco. ");
INSERT INTO gnwNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Echa'ã tenonde yave Juan jei Herodes pe: “Icavi'ã nemenda vaerã nderɨvɨ jembireco ndive.” ");
INSERT INTO gnwNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Jáeramo Herodes uipota tẽi uyucaca Juan. Ẽrei uquɨye tenta guasu pegua reta güi. Echa'ã jae reta güɨrovia Juan co jae penti Tumpa iñee umɨmbeu vae. ");
INSERT INTO gnwNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ẽrei Herodes uyembɨara yave oa vae regua, Herodías imembɨ cuña ou upɨrae ipɨte pe jare umbɨyerovia Herodes. ");
INSERT INTO gnwNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Jayave Herodes jei Tumpa jee re umeeta co cuñatai pe ipotave mbae ueca chupe vae. ");
INSERT INTO gnwNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Jayave cuñatai jei Herodes pe: —Emee cheve cua pe Juan upurumbɨbautizase vae iñãca penti plato pe. Echa'ã cuñatai ichɨ umɨmbeu ma chupe jucuarãi jei vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Jayave mburuvicha guasu ipɨatɨtɨ. Ẽrei Tumpa jee re jei chupe ramo, jare ĩru vae reta uyandu ramo, omondo sundaro Juan iñãca güeru vaerã umee chupe. ");
INSERT INTO gnwNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Jayave oo sundaro peresorɨru pe uñãcasɨa Juan. ");
INSERT INTO gnwNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Jayave güeru iñãcacue penti plato pe, jare umee cuñatai pe. Jayave cuñatai güɨraa umee ichɨ pe. ");
INSERT INTO gnwNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Jare Juan jemimboe reta yugüeru güɨraa jetecue jare oñotɨ. Jayave yugüɨraa umɨmbeu Jesús pe. ");
INSERT INTO gnwNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jare Jesús cua uyandu yave, oo penti chalana pe quĩi ngatu vae pe. Ẽrei jeta vae uicuaa yave, yugüɨraa ɨvɨ rupiño tenta guasu reta güi Jesús oo vae pe. ");
INSERT INTO gnwNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jesús ugüeyɨ yave chalana güi, uecha jeta vae, jare uiparareco reta. Jayave umbɨgüera imbaerasɨ vae joco pe ñugüɨnoi vae reta. ");
INSERT INTO gnwNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Caaru ma yave, Jesús jemimboe reta yugüeru jei chupe: —Mbaetɨ quiave ico cua rupi, jare caaru ma oĩ. Emondo cua jeta vae, ogua vaerã jembiurã tenta tenta rupi —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ẽrei Jesús jei chupe reta: —Agüɨye tuyugüɨraa. Pe reta pemee tucaru —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","—Jaeño ime cua pe nonoi pandepo mbɨyape jare mocui pira —jei reta chupe. ");
INSERT INTO gnwNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","—Peru cheve cua pe —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Jayave Jesús oyocui jocua jeta vae reta uguapɨ vaerã capiichape re. Jayave uipɨsɨ jocua pandepo mbɨyape jare mocui pira, jare umae ara cotɨ, jare umee yasurupai Tumpa pe. Jayave upɨsãa mbɨyape, jare umee jemimboe reta pe, jae reta umee vaerã yatɨ vae reta pe. ");
INSERT INTO gnwNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Opareve ucaru, jare iyangapɨɨ reta. Jayave Jesús jemimboe reta umbatɨ tembíu uñepɨsãacue jembɨre vae, jare umɨtɨnee doce canasta. ");
INSERT INTO gnwNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Jare ucaru vae reta güi cuimbae retaño uyepapa cinco mil rupi. Uyepapa'ã cuña reta jare sambiaɨ reta. ");
INSERT INTO gnwNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Jare jupivoiño Jesús oyocui jemimboe reta uyupi vaerã chalana pe, jare yugüɨraa vaerã jenonde ɨ guasu jovaicho pe, jae omondo rambueve uyembatɨ vae reta. ");
INSERT INTO gnwNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Jare opa omondo yave, Jesús uyupi ɨvɨtu guasu re uyerure vaerã Tumpa pe. Jare pɨ̃tu ma yave, jaeño Jesús joco pe oĩ. ");
INSERT INTO gnwNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ẽrei chalana oo ma uvãe ɨ guasu mbɨte pe. Yavai Jesús jemimboe reta uruguata vaerã. Echa'ã tuicha ɨ uyembɨaparoaroa jare ɨvɨtu tanta oovãiti. ");
INSERT INTO gnwNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Jare cõeta ma yave, Jesús uguata oo ɨ iárambo güɨraa uepitɨ. ");
INSERT INTO gnwNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Jare Jesús jemimboe reta uecha yave uguata ou ɨ iárambo rupi, uquɨye. Jei reta: —Penti mbae iãcue co. Usapɨcai reta uquɨye güi. ");
INSERT INTO gnwNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ẽrei jupivoiño Jesús ombou iñee chupe reta. —Piñemɨatangãtu. Che co. Agüɨye pequɨye —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Jayave Pedro jei chupe: —CheYa, jae co nde yave, cheocui aguata vaerã aa ɨ iárambo rupi ndecotɨ. ");
INSERT INTO gnwNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","—Eyu —jei Jesús chupe. Jayave Pedro ugüeyɨ chalana güi, jare umbɨpɨ uguata ɨ iárambo oo vaerã Jesús cotɨ. ");
INSERT INTO gnwNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ẽrei uecha yave quirãi ɨvɨtu tanta chupe, Pedro uquɨye. Jayave umbɨpɨ uique ɨ pe, jare iñeeãta reve jei: —CheYa, cherepɨ. ");
INSERT INTO gnwNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Jupivoiño Jesús uupi ipo jare uipɨsɨ Pedro. Jayave jei chupe: —Michi ete ndepurugüɨrovia. ¿Maera pa nderovia'ã cheré? —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Jare uyupi reta yave chalana pe, upɨta ɨvɨtu. ");
INSERT INTO gnwNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Jare chalana pe ñugüɨnoi vae reta umbɨadora Jesús. Jei reta: —Añete co, nde co jae Tumpa Taɨ. ");
INSERT INTO gnwNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Jare ɨ guasu uasa reta yave, yugüɨraa uvãe ɨvɨ Genesaret pe. ");
INSERT INTO gnwNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Jare joco pegua reta uicuaa jae co Jesús. Jáeramo jae reta yugüɨraa opaete jocua ɨvɨ rupi, jare güeru Jesús oĩ vae pe imbaerasɨ vae reta. ");
INSERT INTO gnwNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Jare güeru vae reta uyerure Jesús pe umaeño imbaerasɨ vae reta uyavɨquɨ vaerã jemimonde jembeɨ yepe. Jare opaete jemimonde uyavɨquɨ vae reta ucuera. ");
INSERT INTO gnwNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Jayave fariseo reta jare mboroyocui re oporomboe vae reta yugüeru Jerusalén güi Jesús oĩ vae pe jare jei chupe: ");
INSERT INTO gnwNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Maera pa nderemimboe reta uyapo'ã yandetenondegua reta iporomboe? ¿Maera pa ucaru reta uyepoe mbae reve? —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jayave Jesús jei chupe reta: —¿Maera pa pe reta piyavɨ Tumpa iporoyocui piyapo vaerã yandetenondegua reta iporoyocui? ");
INSERT INTO gnwNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Tumpa oporoyocui cuarãi: ‘Ipɨu nderu jare ndesɨ.’ Jare oporoyocui vi cuarãi: ‘Jei icavi mbae vae tu ani ichɨ cotɨ vae uyeyucacata co.’ Jucuarãi oporoyocui Tumpa —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ẽrei pe reta pere cuarãi: ‘Penti vae ipuere jei tu jare ichɨ pe umeeta tẽi chupe reta omborɨ vaerã vae umee ma Tumpa pe.’ Jucuarãi pere —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Jare jucuarãi omborɨ'ã tu jare ichɨ. Jucuarãi pe reta pemombo Tumpa iporoyocui piyugüi piyapo vaerã yandetenondegua reta iporoyocui —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Pe reta co jae upurumbɨtavɨ vae reta. Añete yepe Isaías imiari peré. Echa'ã jae jei cuarãi: ");
INSERT INTO gnwNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Cua reta chepɨu iyuru peño’ —jei Tumpa—. ‘Ẽrei ipɨa pe chepɨu'ã etei. ");
INSERT INTO gnwNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Chembɨadora-raangaiño. Oporomboe cuimbae iporoyocui re. Che jucuarãi'ã aporoyocui’ —jei Tumpa. Jucuarãi jei Isaías —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jare Jesús ueni opaete joco pe ñugüɨnoi vae reta. —Piyapɨsaca cua re, picuaa cavi vaerã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ipotave mbae peu vae ipuere'ã umɨnguɨa pepɨa. Jupi mbae vae pere vae, jocua umɨnguɨa pepɨa —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Jayave Jesús jemimboe reta yugüeru jei chupe: —¿Ndicuaa pa fariseo reta pochɨ co ndeve jocua ndere chupe reta vae re? ");
INSERT INTO gnwNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jayave Jesús jei chupe reta: —Opaete temitɨ reta cheRu ara pe oĩ vae oñotɨ'ã vae uyeequita co. ");
INSERT INTO gnwNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Pemaeño jese reta. Echa'ã jae reta jesa mbae vae reta uechaca ñugüɨnoi tape ĩru jesa mbae vae reta pe vae rami co. Jare jesa mbae vae uechaca yave tape ĩru jesa mbae vae pe, mocui reve uasavita ɨvɨcua pe —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Jayave Pedro jei Jesús pe: —Emɨmbeu oreve mbae uipota jei cua nemɨjaanga reve ndere vae. ");
INSERT INTO gnwNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jayave Jesús jei chupe reta: —¿Pe retave pa picuaa cavi'ã? ");
INSERT INTO gnwNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Picuaa cavi cua: Ipotave mbae peu vae oo perɨe pe, jare pemombo —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ẽrei jupi mbae vae pere vae, jocua umɨnguɨa pepɨa. Echa'ã pere vae ou pepɨa güi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Echa'ã pepɨa güi oẽ opaete icavi mbae vae: pepɨa pe piyemɨngueta icavi mbae vae, pepuruyuca, piyuvanga menda re, piyapo aguasa, pemonda, peapu ĩru vae reta re, icavi mbae vae pere ĩru vae reta cotɨ —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Cua reta umɨnguɨa pepɨa. Ẽrei pecaru yave piyepoe mbae reve, jocua umɨnguɨa'ã pepɨa —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jayave Jesús oo ye joco güi Tiro jare Sidón iyɨpɨ rupi. ");
INSERT INTO gnwNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Jare penti cuña ɨvɨ Canaán pegua joco pe ico. Jae ou Jesús oĩ vae pe jare iñeeãta reve jei chupe: —CheYa, cheparareco. Nde co jae David iñemoñaa reta pegua. Chemembɨ cuña uiporara oĩ. Echa'ã penti aña oya ma jese —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ẽrei Jesús jei'ã mbae chupe. Jayave Jesús jemimboe reta yugüeru jei chupe: —Emondo ye jocua cuña. Echa'ã iñeeãta ou yanderaɨcue. ");
INSERT INTO gnwNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jayave Jesús jei: —Tumpa chembou Israel pegua reta peño. Jae reta ovecha ucañɨ vae reta rami co —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Jayave cuña ou uyeatɨca Jesús jovai, jare jei chupe: —Carai, chemborɨ. ");
INSERT INTO gnwNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ẽrei Jesús jei chupe: —Icavi'ã yaequi vaerã tembíu sambiaɨ reta güi, ñamee vaerã yɨmba-raɨ reta pe —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","—Añete tẽi co, carai —jei cuña Jesús pe—. Ẽrei yɨmba-raɨ reta jou tembíu usururucue iya imesa güi oa vae —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Jayave Jesús jei chupe: —Cuña, tuicha co ndepurugüɨrovia. Tuyeyapo ndeve nde ndipota rupi —jei. Jare jupivoiño cuña imembɨ ucuera. ");
INSERT INTO gnwNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jayave Jesús oo joco güi uvãe ɨ guasu Galilea pe oĩ vae pe. Jayave uyupi penti ɨvɨtu guasu re, jare uguapɨ joco pe. ");
INSERT INTO gnwNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Jare jeta vae yugüeru jae oĩ vae pe. Jae reta güeru icõcho vae reta, jare ipo jovaicho mbae vae reta, jare jesa mbae vae reta, jare iupa vae reta, jare jeta ĩru imbaerasɨ vae reta oñono Jesús jovai. Jayave Jesús umbɨgüera reta. ");
INSERT INTO gnwNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Jáeramo joco pe yatɨ vae reta ipɨacañɨ. Echa'ã uyandu iupa vae reta uyemɨngueta, jare uecha ipo jovaicho mbae vae reta ucuera, jare icõcho vae reta uguata cavi, jare jesa mbae vae reta umae. Jare opaete vae umbɨadora Israel pegua reta iTumpa. ");
INSERT INTO gnwNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jayave Jesús ueni jemimboe reta jare jei chupe reta: —Aiparareco cua yatɨ vae reta. Echa'ã mbapɨ ara ma ñugüɨnoi che ndive, jare mbaetɨ mbae güɨnoi jou vaerã. Ndarau amondo ye reta ucaru mbae reve, agüɨye vaerã ipɨtu tape rupi —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Jayave Jesús jemimboe reta upɨrandu chupe: —¿Quirãita pa yandepuere ñamee mbɨyape cua jeta vae reta pe cua mbaetɨ quiave ico vae pe, jae reta ucaru cavi vaerã? ");
INSERT INTO gnwNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jayave Jesús upɨrandu chupe reta: —¿Mbovɨ pa mbɨyape penoi? —Ime nonoi siete, jare mbovɨ pira —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Jayave Jesús oyocui yatɨ vae reta uguapɨ vaerã ɨvɨ pe. ");
INSERT INTO gnwNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Jayave uipɨsɨ jocua siete mbɨyape jare mbovɨ pira, jare umee yasurupai Tumpa pe. Jayave upɨsãa mbɨyape jare pira, jare umee jemimboe reta pe, jae reta umee vaerã yatɨ vae reta pe. ");
INSERT INTO gnwNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Opareve ucaru, jare iyangapɨɨ reta. Jayave Jesús jemimboe reta umbatɨ tembíu uñepɨsãacue jembɨre vae, jare umɨtɨnee siete canasta. ");
INSERT INTO gnwNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Jare ucaru vae reta güi cuimbae retaño uyepapa cuatro mil rupi. Uyepapa'ã cuña reta jare sambiaɨ reta. ");
INSERT INTO gnwNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Jayave Jesús omondo ye yatɨ vae reta. Jayave uyupi chalana pe, jare oo uvãe ɨvɨ Magdala pe. ");
INSERT INTO gnwNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Jare fariseo reta jare saduceo reta yugüeru Jesús oĩ vae pe, jare jei chupe uechaca vaerã chupe reta mɨacañɨ ara güi. Echa'ã jae reta uipota uicuaa uyapota ra mɨacañɨ chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ẽrei Jesús jei chupe reta: —Amo pe pɨ̃tuta ma yave pe reta pere: ‘Ara cavita co curiye. Echa'ã pɨ̃ta co amapɨ̃tu reta.’ ");
INSERT INTO gnwNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Jae ramiño vi amo pe neimbove yave pere: ‘Ara pochɨta co cua ara. Echa'ã pɨ̃ta co amapɨ̃tu reta jare ara uyasoi oĩ’ —pere, jei—. Pe reta co jae upurumbɨtavɨ vae reta. Echa'ã ara re pemae yave, picuaa mbae uyeyapota vae. Ẽrei picuaa'ã etei mbae añave uyeyapo oĩ vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Añave yugüɨreco vae reta icavi mbae vae uyapo vae reta co. Upurugüɨrovia'ã. Jáeramo uipota ayapo vaerã mɨacañɨ chupe reta. Ẽrei jaeño uyeyapota mbae Tumpa iñee aracae umɨmbeu vae Jonás pe uyeyapo vae rami, jae reta uicuaa vaerã quía co che —jei. Jayave Jesús oo ye chugüi reta. ");
INSERT INTO gnwNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jesús jare jemimboe reta uyupi chalana pe yugüɨraa ɨ guasu jovaicho cotɨ. Jare ɨ guasu jovaicho pe yugüɨraa ma uvãe yave ramo, Jesús jemimboe reta uicuaa ñacañɨ co güeru vaerã mbɨyape. ");
INSERT INTO gnwNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jare Jesús jei chupe reta: —Piñemoa ngatu fariseo reta jare saduceo reta ilevadura güi. ");
INSERT INTO gnwNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Jayave jemimboe reta jei uyupe: —Cua jei, yaru'ã mbɨyape ramo. ");
INSERT INTO gnwNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesús uicuaa chugüi mbae jei reta vae, jare jei chupe reta: —Michi ete co pepurugüɨrovia. ¿Maera pa piyemɨngueta mbɨyape peru mbae vae re? —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Ndeiño pa picuaa cavi? ¿Pemandua'ã pa? Cue yave apɨsãa pandepo mbɨyape ucaru vaerã cinco mil vae reta. Tembíu jembɨrecue pembatɨ yave, ¿mbovɨ canasta pa pemɨtɨnee? —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Jare siete mbɨyape apɨsãa vi, ucaru vaerã cuatro mil vae reta? Tembíu jembɨrecue pembatɨ yave, ¿mbovɨ canasta pa pemɨtɨnee? —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Maera pa picuaa'ã che jae peve vae? Che jae peve piñemoa ngatu vaerã fariseo reta jare saduceo reta ilevadura güi. Jae'ã peve mbɨyape re —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Jayave ramo jemimboe reta uicuaa Jesús jei'ã co chupe reta uñemoa ngatu vaerã mbɨyape ilevadura güi. Jaeño uipota jei chupe reta uñemoa ngatu vaerã fariseo reta jare saduceo reta iporomboe güi. ");
INSERT INTO gnwNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jare Jesús coiño ma oo uvãe tenta guasu Cesarea Filipo güi. Jayave upɨrandu jemimboe reta pe: —¿Quía pa co che cuimbaerã ayeyapo vae ĩru vae reta pe? ");
INSERT INTO gnwNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Jayave jae reta jei chupe: —Amocue vae jei nde co jae Juan upurumbɨbautizase vae, jare ĩru vae reta jei nde co jae Elías, jare ĩru vae reta jei nde co jae Jeremías ani ĩru Tumpa iñee aracae umɨmbeu vae —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Jayave Jesús upɨrandu chupe reta: —Ẽrei ¿quía pa co che peve? ");
INSERT INTO gnwNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Jayave Simón Pedro jei chupe: —Nde co jae Cristo, Tumpa ombou vae. Nde co jae Tumpa jecuaeño ico vae Taɨ —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jayave Jesús jei Pedro pe: —Simón, nde co jae Jonás taɨ. Tumpa nemɨvendise ma. Echa'ã cheRu ara pe oĩ vae uicuaaca ndeve cua. Mbaetɨ quía ye uicuaaca ndeve —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Jare che jae ndeve, nde co jae Pedro. (Pedro uipota jei: “ita”.) Jare che etei amɨmɨrãtata aiparavo vae reta, ipɨrãta vaerã penti tenta ita tuicha vae iárambo oĩ vae ipɨrãta rami. Jáeramo cañɨtei ndarau ipuere jese reta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Jare ameeta ndeve mboroyocuia ara pegua illave reta. Jare ime yave mbae ɨvɨ pe niñapɨ̃tita vae, Tumpa vi uñapɨ̃tita ara pe. Jae ramiño vi ime yave mbae ɨvɨ pe ndiyorata vae, Tumpa vi oyorata ara pe —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Jayave Jesús oyocui jemimboe reta agüɨye vaerã umɨmbeu quía pe jae co Cristo, Tumpa ombou vae. ");
INSERT INTO gnwNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Jare jocua ara reta güive Jesús umɨmbeu jemimboe reta pe quirãi jae oota co Jerusalén pe, jare quirãi tenta guasu pegua reta itenondegua reta jare sacerdote reta itenondegua reta jare mboroyocui re oporomboe vae reta uiporaracata co chupe, jare quirãi jae uyeyucacata, jare quirãi mbapɨ ara rupi icove yeta ou umanocue vae reta ipɨte güi. ");
INSERT INTO gnwNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Jayave Pedro güɨraa Jesús ĩru reta ipɨte güi, jare umbɨpɨ umbɨeta chupe. Jei: —Tumpa tanemborɨ, cheYa. Agüɨye etei tuyeyapo ndeve cua —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ẽrei Jesús uyerova jare jei Pedro pe: —Esɨrɨ chegüi, Satanás. Ndipota chembɨavai. Echa'ã nde ndiyemɨngueta neĩ ɨvɨ pegua reta uyemɨngueta rami, ndiyemɨngueta'ã Tumpa uyemɨngueta rami —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Jayave Jesús jei jemimboe reta pe: —Ime yave quía uipota oo cherupíe vae, tiñacañɨ iyugüi, tovoɨ icurusu, jare too cherupíe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Uipota uñuvatu jecove vae ndarau ipuere. Ẽrei umeeta jecove chereco pegua vae uñuvatuta co —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿Mbae ra umɨnganata quía, umɨngana yave opaete ɨvɨ pegua, ẽrei ipuere'ã yave uñuvatu jecove? ¿Mbovɨ ra umbɨepɨta quía ogua ye vaerã jecove? —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Echa'ã che cuimbaerã ayeyapo vae ayu yeta cheRu imbaepuere reve ángel cheve uyeyocui vae reta ndive. Jare jayave ameeta opaete vae pe penti penti uyapo vae rupi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Añete che jae peve, ndei amocue cua pe ñugüɨnoi vae reta umano mbove, cherechata che cuimbaerã ayeyapo vae cheporoyocuia pe —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Seis ara ma uasa yave, Jesús güɨraa Pedro, Jacobo jare Juan - jae co Jacobo tɨvɨ - ĩru reta ipɨte güi penti ɨvɨtu guasu ɨvate vae re. ");
INSERT INTO gnwNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Jare joco pe uyembɨambɨe jae reta jovai. Jova jembipe guarasɨ jembipe rami, jare jemimonde tĩ asɨ jare uvera. ");
INSERT INTO gnwNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Jare uyecuaa chupe reta Moisés jare Elías uyemɨngueta ñugüɨnoi Jesús ndive. ");
INSERT INTO gnwNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Jayave Pedro jei Jesús pe: —OreYa, icavi co ñaĩ vaerã cua pe. Nde ndipota yave, turuyapo cua pe mbapɨ guarasɨ̃a ñanaroquɨ pegua, penti nembaerã, penti Moisés peguarã jare penti Elías peguarã —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pedro uyemɨngueta oĩ rambueve, amapɨ̃tu jembipe vae umɨguarasɨ̃a reta, jare amapɨ̃tu güi uyendu ñee. —Cua co jae cheRaɨ aau ete vae. Chembɨyerovia ete. Piyapɨsaca jese —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Jare Jesús jemimboe reta cua uyandu yave, oa ɨvɨ re. Echa'ã uquɨye ete reta. ");
INSERT INTO gnwNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jayave Jesús ou oñono ipo jese reta jare jei: —Pepũa. Agüɨye pequɨye. ");
INSERT INTO gnwNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Jare umae reta ye yave, uecha'ã ma quía jae reta ndive, jaeño Jesús. ");
INSERT INTO gnwNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Jare ɨvɨtu guasu güi ugüeyɨ yugüeru rambueve, Jesús oyocui reta: —Agüɨye pemɨmbeu quía pe cua peecha vae, ndei che cuimbaerã ayeyapo vae aicove ye ayu umanocue vae reta ipɨte güi mbove. ");
INSERT INTO gnwNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Jayave jemimboe reta upɨrandu chupe: —¿Maera pa jei mboroyocui re oporomboe vae reta Elías rani co outa? ");
INSERT INTO gnwNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","—Añete Elías rani co outa —jei Jesús—, jare opaete uyapɨcatuta. ");
INSERT INTO gnwNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ẽrei che jae peve, Elías ou ma co, jare Israel pegua reta uicuaa'ã. Jáeramo uyapo reta chupe jae reta uipota vae. Jae ramiño vi jae reta uiporaracata cheve —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Jayave Jesús jemimboe reta uicuaa jae imiari oĩ chupe reta Juan upurumbɨbautizase vae re. ");
INSERT INTO gnwNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Jare yugüeru uvãe yave jeta ñugüɨnoi vae pe, penti cuimbae ou oovãiti Jesús. Uyeatɨca jae jovai, jare jei chupe: ");
INSERT INTO gnwNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—CheYa, iparareco cheraɨ. Echa'ã imbaerasɨ iñãca pe jare uiporara oĩ. Jeta vese ma oa tata pe. Oa vi ɨ pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Aru nderemimboe reta pe umbɨgüera vaerã tẽi, ẽrei jae reta ipuere'ã —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jayave Jesús jei joco pe ñugüɨnoi vae reta pe: —Yavai pe reta cua ɨvɨ pe pico vae pepurugüɨrovia vaerã. ¿Quirãi regua ra apɨtata pe reta ndive? ¿Quirãi regua ra arupɨata peve? Peru cheve cua pe jocua cunumi —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jayave Jesús uñeengata aña pe, jare aña usɨrɨ cunumi güi. Jare jupivoiño cunumi ucuera. ");
INSERT INTO gnwNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Jayave Jesús jemimboe reta yugüeru Jesús oĩ vae pe upɨrandu chupe, jae retaño jae ndive ñugüɨnoi yave: —¿Maera pa ore orepuere'ã numbɨsɨrɨ aña? ");
INSERT INTO gnwNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","—Pepurugüɨrovia'ã ramo —jei Jesús chupe reta—. Añete che jae peve, aramoi pepurugüɨrovia michi ete penti mostaza jãɨcue michi-raɨ vae rami. Ẽrei jocua nunga mburugüɨrovia penoi yave, pepuereta pere cua ɨvɨtu guasu pe: ‘Ecua cua güi epɨta joco pe’, jare oota co. Ndarau mbae yavai peve —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ẽrei ndarau pepuere pembɨsɨrɨ cua nunga aña, jaeño piyerure yave Tumpa pe piyecuacu reve tembíu güi —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Jare Galilea pe ñugüɨnoi rambueve, Jesús jei jemimboe reta pe: —Che cuimbaerã ayeyapo vae penti vae chemeeta ĩru vae reta pe. ");
INSERT INTO gnwNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Jae reta cheyucata. Ẽrei amano ma yave, mbapɨ ara rupi aicove yeta ayu umanocue vae reta ipɨte güi —jei. Jayave jemimboe reta ipɨatɨtɨ tuicha. ");
INSERT INTO gnwNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jare Capernaum pe yugüɨraa uvãe yave, mburuvicha peguarã ocovara vae reta yugüeru upɨrandu Pedro pe: —¿Umbɨepɨ pa pemboe vae mburuvicha ocovara vae? ");
INSERT INTO gnwNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","—Umbɨepɨ —jei Pedro chupe reta. Jare uique yave tenta pe, Jesús jei Simón Pedro pe: —Simón, mburuvicha ɨvɨ pegua reta ocovara ĩru vae reta pe. ¿Ocovara reta vi pa taɨ reta pe ani ĩru vae reta peño? ¿Mbae pa ndepɨa pe ndiyemɨngueta cua re? —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","—Ĩru vae reta peño —jei Pedro. Jayave Jesús jei chupe: —Jáeramo taɨ reta umbɨepɨ'ã chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ẽrei agüɨye vaerã yayapo icavi mbae vae echa chupe reta, ecua epindapo ɨ guasu pe. Ipea jocua pira tenonde ndipɨsɨ vae iyuru. Joco pe nevãeta penti corepoti. Eraa emee mburuvicha peguarã ocovara vae reta pe cheve peguarã jare ndeve peguarã —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Jayave jemimboe reta yugüeru jei Jesús pe —¿Quía pa co jae tenondegua vae mboroyocuia ara pegua pe? ");
INSERT INTO gnwNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jayave Jesús ueni penti sambiaɨ, jare oñono jae reta ipɨte pe. ");
INSERT INTO gnwNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","—Añete che jae peve, piyerova'ã yave Tumpa cotɨ jare piyeyapo'ã yave sambiaɨ reta rami, ndarau pique mboroyocuia ara pegua pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ime yave quía uñemɨmichi cua sambiaɨ rami vae, jae icota tenondeguarã mboroyocuia ara pegua pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Jare ime yave quía uyapo icavi vae cua nunga sambiaɨ pe cheree pe vae, cheve co uyapo icavi vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ime cheré güɨrovia vae reta. Ime yave quía penti cua nunga pe mbaeyoa uyapoca vae, icavita tẽi co ĩru vae reta uñapɨ̃ti vaerã iyayu re penti ita tuicha vae umbaeso pɨpe vae, omombo vaerã ɨ tɨpɨ pe ɨ guasu pe jae ipɨtupa vaerã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Amocue ɨvɨ pegua reta uiporara ĩru vae reta uyapoca chupe reta mbaeyoa ramo. Jecuaeño amocue vae reta uyapoca mbaeyoa ĩru vae reta pe. Ẽrei jocua mbaeyoa uyapoca vae reta uiporarata vi co —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Jáeramo ndepo jovaicho ani ndepɨ jovaicho uyapoca yave mbaeyoa ndeve, iyasɨa emombo ndiyugüi. Icavi co tecove opa mbae vae nenoi vaerã ndepo jovaicho mbae reve ani ndepɨ jovaicho mbae reve, tata guasu opa mbae vae pe mocui ndepo reve ani mocui ndepɨ reve Tumpa nemondo vaerã tẽi güi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Jae ramiño vi nderesa jovaicho uyapoca yave mbaeyoa ndeve, eequi emombo ndiyugüi. Icavi co tecove opa mbae vae nenoi vaerã nderesa jovaicho mbae reve, tata guasu pe mocui nderesa reve Tumpa nemondo vaerã tẽi güi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Agüɨye perɨ̃ro penti upurugüɨrovia vae. Che jae peve, ara pe ángel uyandareco cua nunga sambiaɨ reta re vae reta jecuaeño ñugüɨnoi cheRu ara pe oĩ vae jovai —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Echa'ã che cuimbaerã ayeyapo vae ayu ambɨasa vaerã ucañɨ Tumpa güi vae reta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Pepɨa pe piyemɨngueta cua re. Ime yave penti cuimbae cien ovecha güɨnoi vae, penti ovecha ucañɨ yave, cuimbae ueya jocua noventa y nueve ovecha reta oo ɨvɨtu guasu rupi ueca ucañɨ vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Jare uvãe chupe yave, añete che jae peve, uyerovia tuicha jocua ovecha re noventa y nueve ovecha ucañɨ mbae vae reta re güi. ");
INSERT INTO gnwNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Jae ramiño vi peRu ara pe oĩ vae uipota'ã cua upurugüɨrovia vae reta güi penti ave ucañɨtei vaerã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Jare nderɨvɨ iyoa yave ndecotɨ, ecua emɨmbeu chupe uyapo vae regua quía uicuaa mbae reve. Jare nderɨvɨ uyapɨsaca nderé yave, ndiyeyapɨcatuta jae ndive —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ẽrei uipota'ã yave uyapɨsaca nderé, eraa nderupíe penti ani mocui neĩrurã, ĩru vae reta uicuaa vaerã mocui ani mbapɨ vae rupi mbae pere vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Jare uipota'ã yave uyapɨsaca jese reta, emɨmbeu upurugüɨrovia vae reta pe. Ẽrei nderɨvɨ uipota'ã yave uyapɨsaca upurugüɨrovia vae reta re, emae jese penti upurugüɨrovia mbae vae rami ani mburuvicha peguarã ocovara vae rami —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Añete che jae peve, ime yave mbae ɨvɨ pe piñapɨ̃tita vae, Tumpa vi uñapɨ̃tita ara pe. Jae ramiño vi ime yave mbae ɨvɨ pe piyorata vae, Tumpa vi oyorata ara pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Jare che jae ye peve, mocui vae ɨvɨ pegua omboyovaque iyemɨngueta jei yave: ‘Yayerure Tumpa pe jocua re’, cheRu ara pe oĩ vae uyapota chupe reta uyerure chupe jese vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Echa'ã mocui ani mbapɨ vae uyembatɨ yave cheree re, jae reta ipɨte pe che aĩta —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Jayave Pedro ou jei Jesús pe: —CheYa, cherɨvɨ iyoa yave checotɨ jeta vese, ¿mbovɨ vese pa ambɨasata chupe? ¿Siete vese pa? —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jayave Jesús jei Pedro pe: —Che jae ndeve, embɨasa chupe setenta vese siete, mbaetɨ siete veseño. ");
INSERT INTO gnwNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Echa'ã mboroyocuia ara pegua penti mburuvicha guasu jembiocui reta pe ipía uipota ocovara vae rami co —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Mburuvicha guasu umbɨpɨ ocovara chupe reta yave, ou uyemboɨ jae jovai penti jembiocui jeta ete corepoti re ipía chupe vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Jocua jembiocui ipuere'ã umbɨepɨ. Jáeramo mburuvicha guasu oyocui uñemee vaerã corepoti re jembiocui jare jembireco jare isambiaɨ reta, jare opaete imbaembae, jembiocui ipuere vaerã umbɨepɨ chupe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Jayave jembiocui uyeatɨca mburuvicha guasu jovai, jare jei chupe: ‘Agüɨye ndepochɨ cheve. Ndepɨaguasu cheve yave, ambɨepɨta ndeve opaete’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Jayave mburuvicha guasu uiparareco jocua jembiocui jare oyora. Umbai chupe ipía —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ẽrei jocua uyeyocui vae oẽ mburuvicha guasu oĩ vae güi jare uvãe ĩru uyeyocui vae mbovɨ corepoti re ipía chupe vae. Jayave uipɨsɨ uyasɨombiri jare jei chupe: ‘Embɨepɨ cheve ndepía.’ ");
INSERT INTO gnwNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Jayave jocua ĩru uyeyocui vae uyeatɨca jae jovai, jare uyerure chupe: ‘Agüɨye ndepochɨ cheve. Ndepɨaguasu cheve yave, ambɨepɨta ndeve opaete’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ẽrei uipota'ã ipɨaguasu chupe. Umɨingueca peresorɨru pe opaete ipía umbɨepɨ regua —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Jare ĩru uyeyocui vae reta uicuaa yave uyeyapo vae, ipɨatɨtɨ, jare yugüɨraa umɨmbeu mburuvicha guasu pe opaete uyeyapo vae regua —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Jayave mburuvicha guasu ueni jocua jembiocui, jare jei chupe: ‘Nde co jae cherembiocui icavi mbae vae. Che ambai ndeve opaete ndepía, nde ndiyerure cheve jese ramo’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","‘¿Maera pa ndiparareco'ã nderapicha, che nduparareco rami?’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Jayave mburuvicha guasu pochɨ jembiocui pe, jare oyocui peresorɨru iyandarecoa reta uiporaraca vaerã chupe opaete ipía umbɨepɨ regua —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Jae ramiño vi cheRu ara pe oĩ vae uyapota jucuarãi peve, pembɨasa'ã yave opaete pepɨa reve perɨvɨ iyoa pecotɨ vae pe —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jare Jesús opaete cua jei ma yave, oo Galilea güi Judea pe Jordán jovaicho pe. ");
INSERT INTO gnwNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Jare jeta vae yugüɨraa jaɨcue. Jayave Jesús umbɨgüera imbaerasɨ vae joco pe ñugüɨnoi vae reta. ");
INSERT INTO gnwNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Yugüeru vi fariseo reta Jesús oĩ vae pe. Jae reta uipota tẽi uyavɨca chupe. Jáeramo upɨrandu reta chupe: —¿Jupi pa cuimbae omombo vaerã jembireco ipotave mbae jeco pegua? ");
INSERT INTO gnwNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jayave Jesús jei chupe reta: —¿Pemɨngueta'ã pa Tumpa iñee pe quirãi Tumpa uyapo ramo yave, uyapo cuimbae jare cuña? —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Jare Tumpa jei cuarãi: ‘Jáeramo cuimbae usɨrɨta tu jare ichɨ güi, jare oota ico vaerã jembireco ndive. Jare mocui vae uyeyapota penti ramiño.’ Jucuarãi jei Tumpa —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Jáeramo mbaetɨ ma mocui rami. Yugüɨreco penti ramiño. Jáeramo agüɨye quía tumbɨsɨrɨ Tumpa umɨĩru vae reta —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Jayave fariseo reta jei chupe: —¿Maera pa Moisés oyocui cuimbae uicuatía vaerã tupapire jembireco omombo vaerã? ");
INSERT INTO gnwNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","—Moisés umaeño peré pemombo vaerã pembireco pepɨatanta ramo —jei Jesús—. Ẽrei Tumpa uyapo ramo yave, jucuarãi'ã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Jare che jae peve, penti cuimbae ipuere omombo jembireco, cuña aguasa uyapo yave. Ẽrei cuña uyapo'ã yave aguasa, jare cuimbae omombo yave jembireco, jocua cuimbae uyuvanga co menda re umenda yave ĩru cuña ndive. Jae ramiño vi ĩru cuimbae umenda yave jocua cuña uyemomboca vae ndive, jae vi uyuvanga menda re —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Jayave Jesús jemimboe reta jei chupe: —Jucuarãi yaveño cuimbae ipuere omombo jembireco, icavi'ã cuimbae umenda vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ẽrei Jesús jei chupe reta: —Amocue vaeño ipuere uicuaa cua che jae peve vae. Jocua Tumpa umee uicuaa vaerã vae reta peño ipuere uicuaa —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Echa'ã amocue vae ichɨ güi oa güive yugüɨreco eunucorã reta. Jare amocue vae yugüɨreco eunucorã reta ĩru vae reta uapiavo reta ramo. Jare amocue vae yugüɨreco eunucorã reta rami mboroyocuia ara pegua jeco pegua. Ime yave quía ipuere uicuaa cua, tuicuaa —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Jare amocue vae güeru Jesús oĩ vae pe sambiaɨ reta, Jesús oñono vaerã ipo jese reta jare uyerure vaerã Tumpa pe jese reta. Ẽrei jemimboe reta uñeengata güeru vae reta pe. ");
INSERT INTO gnwNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ẽrei Jesús jei: —Pemaeño sambiaɨ reta re yugüeru vaerã checotɨ. Echa'ã cua nunga uyeyocui Tumpa pe mboroyocuia ara pegua pe —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Jayave oñono ipo jese reta. Jayave oo joco güi. ");
INSERT INTO gnwNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Jare penti cuimbae ou jei Jesús pe: —Oporomboe vae, nde ndepɨacavi co. ¿Mbae nunga mbae icavi vae pa ayapota anoi vaerã tecove opa mbae vae? —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jayave Jesús jei chupe: —¿Maera pa ndere cheve chepɨacavi vae co? Mbaetɨ quía ipɨacavi, jaeño co Tumpa. Ẽrei ndipota yave nenoi tecove opa mbae vae, iyapo mboroyocui reta —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","—¿Mbae nunga reta pa? —jei Jesús pe. Jayave Jesús jei chupe: —‘Agüɨye epuruyuca. Agüɨye iyuvanga menda re. Agüɨye nemonda. Agüɨye ndapu ĩru vae reta re. ");
INSERT INTO gnwNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ipɨu nderu jare ndesɨ. Jare eau nderapicha nde ndiyerau rami’ —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Jayave cuimbae jei Jesús pe: —Ayavɨ'ã penti ave cua mboroyocui reta chemichi güive. ¿Mbae ye pa uata cheve ayapo vaerã? —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jayave Jesús jei chupe: —Ndipota yave ndiyapo opaete icavi ndiyapo vaerã vae, ecua emee opaete mbaembae nenoi vae corepoti re, jare emee ndecorepoti iparavete vae reta pe, jare ndicocatuta ara pe. Jayave eyu cherupíe —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ẽrei cua uyandu yave, cuimbae oo ipɨatɨtɨ reve. Echa'ã jeta mbaembae güɨnoi. ");
INSERT INTO gnwNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Jayave Jesús jei jemimboe reta pe: —Añete che jae peve, yavai ete co icocatu vae uique vaerã mboroyocuia ara pegua pe. ");
INSERT INTO gnwNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Che jae ye peve, yavai ete icocatu vae uique vaerã Tumpa iporoyocuia pe, maemɨmba camello jee vae yuu jesacua rupi uasa vaerã güi —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Jesús jemimboe reta cua uyandu yave, ipɨacañɨ jare jei: —Jucuarãi yave, ¿quía pa ipuere uyembɨasaca? ");
INSERT INTO gnwNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jayave Jesús umae jese reta jare jei: —Ɨvɨ pegua reta ipuere'ã uyembɨasa. Ẽrei Tumpa ipuere umbɨasa reta. Echa'ã Tumpa ipuere uyapo opaete mbaembae —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Jayave Pedro jei chupe: —Mase, ore opaete mbaembae ndueya, ndoyu vaerã nde ndive. ¿Mbae pa nonoita ore? ");
INSERT INTO gnwNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jayave Jesús jei jemimboe reta pe: —Añete che jae peve, che cuimbaerã ayeyapo vae aguapɨta cheguapɨa pe ayembɨadoraca vaerã, opaete uyeyapɨcatu yave. Jae ramiño vi pe reta che ndive peyu vae peguapɨta doce guapɨa pe, jare peãata doce atɨ Israel pegua reta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Jare ime yave quía ueya jenta, ani tɨqueɨ reta, ani tɨvɨ reta, ani jindɨ reta, ani tu, ani ichɨ, ani jembireco, ani isambiaɨ reta, ani iɨvɨ reta chereco pegua vae, cien rupi jecoviata co chupe, jare güɨnoita imbaerã tecove opa mbae vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ẽrei Tumpa umbɨtaɨcueta uyembutuicha vae reta, jare umɨtenondeta uñemɨmichi vae reta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Echa'ã mboroyocuia ara pegua penti co iya rami co. Co iya oẽ neimbove asɨ ueca quía ipuere uparavɨquɨ vaerã ico pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Upɨrandu amocue vae pe uparavɨquɨta ra chupe umbɨepɨ yave chupe reta penti denario ara rupi. (Penti denario co penti ara mbaravɨquɨ jepɨ pegua.) Jare jae reta jei uparavɨquɨta co chupe. Jayave co iya omondo reta ico pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Jayave co iya oẽ ye guarasɨ ɨvate catu mi yave, jare uecha ĩru vae reta uyemboɨ ñugüɨnoi plaza pe. Mbaetɨ co jae reta iparavɨquɨ. ");
INSERT INTO gnwNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Jayave co iya jei chupe reta: ‘Pe reta vi pecua peparavɨquɨ checo pe. Tambɨepɨ peve jupi co ambɨepɨ peve vaerã vae’ —jei, jei—. Jayave jae reta yugüɨraa co pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Jayave co iya oẽ ye guarasɨ ara mbɨte ma oĩ yave, jare omondo ĩru vae reta ico pe uparavɨquɨ vaerã. Jae ramiño vi oẽ ye mbapɨ ora ma caaru yave, jare omondo ye ĩru vae reta ico pe uparavɨquɨ vaerã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Jare co iya oẽ ye caaru ete yave, jare uecha ĩru vae reta uyemboɨ ñugüɨnoi mbaetɨ iparavɨquɨ ramo. Jayave jei chupe reta: ‘¿Maera pa peĩ cua pe opaete ara peparavɨquɨ mbae reve?’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","‘Mbaetɨ quía oremɨmbaravɨquɨca ramo’ —jei reta, jei—. Jayave co iya jei chupe reta: ‘Pe reta vi pecua peparavɨquɨ checo pe. Tambɨepɨ peve jupi ambɨepɨ peve vaerã vae’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Guarasɨ uique ma yave, co iya jei jembiocui pe: ‘Eeni uparavɨquɨ vae reta embɨepɨ chupe reta. Embɨepɨ rani taɨcue rupi umbɨpɨ uparavɨquɨ vae reta pe, jare taɨcue rupi embɨepɨ tenonde yave umbɨpɨ uparavɨquɨ vae reta pe’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Jare co güi yugüeru ye yave caaru ete umbɨpɨ uparavɨquɨ vae reta, co iya jembiocui umee penti penti pe penti denario —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Jare neimbove asɨ umbɨpɨ uparavɨquɨ vae reta co güi yugüeru yave, ipɨa pe uyemɨngueta tẽi co iya jembiocui umbɨepɨta co chupe reta jeta caaru ete umbɨpɨ uparavɨquɨ vae reta pe umbɨepɨ vae güi. Ẽrei co iya jembiocui umbɨepɨ vi chupe reta penti denario ĩru reta pe rami —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Jayave penti denarioño güɨnoi yave, iñeenguru co iya pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Jae reta jei chupe: ‘Cua taɨcue rupi umbɨpɨ uparavɨquɨ vae reta penti oraño uparavɨquɨ. Ẽrei nde nembɨepɨ chupe reta penti denario oreve nembɨepɨ rami, yepe tẽi ore nduparavɨquɨ tanta guarasɨ jasɨ reve’ —jei reta, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ẽrei co iya jei penti vae pe: ‘Cheamigo, ayapo'ã etei icavi mbae vae ndeve. Echa'ã nde ndere cheve ndeparavɨquɨta checo pe che ambɨepɨ ndeve yave penti denario’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","‘Ecua eraa cua nemɨnganacue. Aipota ambɨepɨ taɨcue rupi umbɨpɨ uparavɨquɨ vae pe penti denario ndeve ambɨepɨ rami’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","‘Echa'ã jupi co che ayapo vaerã aipota vae chembaembae ndive. Agüɨye neacatãa cua ĩru vae re che ayapo icavi vae chupe ramo’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Jae ramiño vi Tumpa umbɨtaɨcueta uyembutuicha vae reta, jare umɨtenondeta uñemɨmichi vae reta —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jare Jesús Jerusalén cotɨ oo rambueve, ueni jocua doce jemimboe reta ĩru reta ipɨte güi, jare jei chupe reta: ");
INSERT INTO gnwNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Mase, yaa co ñaĩ Jerusalén pe. Jare che cuimbaerã ayeyapo vae penti vae chemeeta sacerdote reta itenondegua reta jare mboroyocui re oporomboe vae reta pe. Jae reta jeita amano vaerã, ");
INSERT INTO gnwNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","jare chemeeta judío mbae vae reta pe. Jae reta cheyoyaita, chenupata chicote pe, jare checututa curusu re. Ẽrei mbapɨ ara rupi aicove yeta ayu umanocue vae reta ipɨte güi —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Cua jaɨcue rupi ou Jesús oĩ vae pe Zebedeo jembireco imembɨ reta Jacobo jare Juan ndive. Cuña uyeatɨca Jesús jovai jare jei chupe uipota uyapo vaerã mbae chupe. ");
INSERT INTO gnwNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jayave Jesús upɨrandu cuña pe: —¿Mbae pa ndipota? —Emaeño cua mocui chemembɨ re uguapɨ vaerã ndeyɨpɨ pe ndeporoyocuia pe, penti ndeacata cotɨ jare ĩru ndeaso cotɨ —jei cuña chupe. ");
INSERT INTO gnwNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ẽrei Jesús jei Jacobo jare Juan pe: —Picuaa'ã mbae re piyerure vae. ¿Pepuereta pa piporara che aiporarata vae rami? ¿Pepuereta pa piyembɨbautizaca che ayembɨbautizacata vae rami? —jei. —Orepuereta co —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","—Añete pe reta piporarata che aiporarata vae rami, jare pe reta piyembɨbautizacata che ayembɨbautizacata vae rami —jei Jesús chupe reta—. Ẽrei chepuere'ã jae peve peguapɨ vaerã cheyɨpɨ pe, penti cheacata cotɨ jare ĩru cheaso cotɨ. Echa'ã cheRu umɨcuatɨ̃ro ma joco pe uguapɨta vae reta peguarã —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Jare ĩru diez Jesús jemimboe reta cua uyandu yave, pochɨ reta Jacobo jare Juan pe. ");
INSERT INTO gnwNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Jayave Jesús ueni reta. —Picuaa cavi co cua —jei chupe reta—. Mburuvicha ɨvɨ pegua reta oporoyocui, jare mbaepuere güɨnoi vae reta jei ĩru reta pe mbae uyapo vaerã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ẽrei pe reta agüɨye piyapo jucuarãi —jei—. Ime yave penti pepɨte pe oĩ vae uipota mbaepuere güɨnoi vae, tuyeyocui ĩru reta pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Jare ime yave penti pepɨte pe oĩ vae uipota tenondeguarã ico vae, tuyeyocui ĩru reta pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Echa'ã che cuimbaerã ayeyapo vae ayu ayeyocui vaerã ĩru vae reta pe. Ayu'ã ĩru vae reta uyeyocui cheve vaerã. Ayu amano vaerã, jeta vae aepɨ vaerã —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jare yugüɨraa yave tenta guasu Jericó güi, jeta vae yuguɨraa Jesús jaɨcue. ");
INSERT INTO gnwNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Jare mocui cuimbae jesa mbae vae uguapɨ ñugüɨnoi joco pe tape jembeɨ pe. Jare uicuaa reta Jesús uasa oo oĩ yave, iñeeãta reve jei reta: —OreYa, oreparareco. Nde co jae David iñemoñaa reta pegua. ");
INSERT INTO gnwNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Jeta joco pe ñugüɨnoi vae reta uñeengata chupe reta. Uipota tẽi umɨquĩi. Ẽrei jae reta jeiete iñeeãta reve jei: —OreYa, oreparareco. Nde co jae David iñemoñaa reta pegua. ");
INSERT INTO gnwNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jayave Jesús uyemboɨ, jare uenica cuimbae jesa mbae vae reta. —¿Mbae pa pipota ayapo vaerã peve? —jei chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","—Nduipota numae, oreYa —jei reta chupe. ");
INSERT INTO gnwNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jayave Jesús uiparareco reta jare uyavɨquɨ jesa chugüi. Jare jupivoiño mocui reve ipuere umae, jare yugüɨraa Jesús jaɨcue. ");
INSERT INTO gnwNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jare coiño ma Jerusalén güi ñugüɨnoi yave, yugüɨraa uvãe tenta guasu-raɨ Betfagé iyɨpɨ pe, ɨvɨtu guasu Olivos jovai. Jayave Jesús oyocui mocui jemimboe reta: ");
INSERT INTO gnwNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","—Pecua pea tenta guasu-raɨ yanderovai oĩ vae pe —jei—. Peo pevãe yave, pevãeta penti mburica uñeñapɨ̃ti oĩ, jare pevãeta vi mburica taɨrusu vae jae ndive. Piyora peru —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Jare ime yave quía mbae jei peve, pere chupe: ‘YandeYa uipota uiporu, ẽrei ɨmambae güeruruca yeta cua pe’ —pere, jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Opaete cua uyeyapo, Tumpa iñee aracae umɨmbeu vae jei vae uyeyapo vaerã. Echa'ã jae jei cuarãi: ");
INSERT INTO gnwNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Pemɨmbeu Jerusalén pegua reta pe: ‘Mase, peRuvicha Guasu ou peve. Uñemɨmichi oĩ. Echa'ã opo ou mburica taɨrusu vae re.’ ” Jucuarãi jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Jayave Jesús jemimboe reta yugüɨraa, jare uyapo Jesús jei chupe reta uyapo vaerã vae. ");
INSERT INTO gnwNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Jare güeru mburica jare mburica taɨrusu vae Jesús oĩ vae pe. Jayave Jesús jemimboe reta oñono iyasoya maemɨmba reta icupe re, jare Jesús opo mburica taɨrusu vae re. ");
INSERT INTO gnwNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Jare jeta vae uipɨso iyasoya tape rupi mburica taɨrusu vae jenonde, jare ĩru vae reta uyasɨa ñanaroquɨ jare oñono tape rupi. ");
INSERT INTO gnwNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Jare Jesús jenonde yugüɨraa vae reta jare jaɨcue rupi yugüɨraa vae reta iñeeãta reve jei: —¡Icavi co! Cua co jae David iñemoñaa reta pegua. Tuyembɨadoraca yandeYa jee re ou vae. Tei reta ‘icavi co’ ara pe —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jare Jesús oo ma uvãe yave Jerusalén pe, opaete Jerusalén pegua reta ipɨacañɨ reve jei: —¿Quía pa co jae? ");
INSERT INTO gnwNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Jare jeta vae reta jei: —Cua co jae Jesús. Jae co penti Tumpa iñee umɨmbeu vae Nazaret pegua. Nazaret Galilea pegua co —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jayave Jesús uique Tumpa jo pe, jare omoẽ joco güi opaete umaemee vae reta jare mbae ogua vae reta, jare umbɨyapara corepoti uipepɨca vae reta imesa reta jare pɨcasu reta umee vae reta jenda reta. ");
INSERT INTO gnwNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Jare jei chupe reta: —Tumpa iñee pe uyecuatía oĩ cuarãi: ‘Chero uyembɨjeeta o yerure pegua pe.’ Jucuarãi uyecuatía oĩ. Ẽrei pe reta piyapo ma imonda vae reta iñemia rami —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Jare yugüeru Jesús oĩ vae pe Tumpa jo pe jesa mbae vae reta jare icõcho vae reta, jare Jesús umbɨgüera reta. ");
INSERT INTO gnwNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Jare sacerdote reta itenondegua reta jare mboroyocui re oporomboe vae reta uecha mɨacañɨ Jesús uyapo vae reta, jare uyandu vi sambiaɨ Tumpa jo pe ñugüɨnoi vae reta iñeeãta reve jei: —¡Icavi co! Cua co jae David iñemoñaa reta pegua. Jáeramo jae reta pochɨ. ");
INSERT INTO gnwNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Jayave jei reta Jesús pe: —¿Ndiyandu pa cua reta jei vae? Jayave Jesús jei chupe reta: —Ayandu. ¿Pemɨngueta'ã pa cua Tumpa iñee pe uyecuatía oĩ vae? ‘Nde nemee sambiaɨ reta jare imeño ucambu vae reta pe nembɨadora vaerã.’ Jucuarãi uyecuatía oĩ —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Jayave Jesús ueya reta. Oo Jerusalén güi Betania pe, jare joco pe ico. ");
INSERT INTO gnwNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Pɨareve pe neimbove yave Jesús oo ye Jerusalén cotɨ, jare iyembaɨ. ");
INSERT INTO gnwNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Jare uecha penti ɨva coiño tape güi. Jayave oo umae jese, ẽrei uvãe'ã ía, jaeño joquɨ. Jayave jei ɨva pe: —Ndarau etei ma ndeía. Jare ɨmambae ɨva yɨpi. ");
INSERT INTO gnwNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Jare Jesús jemimboe reta uecha yave ɨva yɨpi vae, ipɨacañɨ jese jare jei: —Ɨmambae yɨpi jocua ɨva. ");
INSERT INTO gnwNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jayave Jesús jei chupe reta: —Añete che jae peve, pepurugüɨrovia yave, pe reta vi pepuereta piyapo che ayapo ɨva pe vae rami. Ẽrei pepurugüɨrovia yave, pepuereta vi pere cua ɨvɨtu guasu pe: ‘Pecua cua güi piyemombo ɨ guasu pe’, jare jucuarãita uyeyapo. Pere'ã yave pepɨa pe: ‘Ndarau ndipo uyeyapo’, uyeyapota co peve —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Jare ime yave mbae pipota vae, piyerure Tumpa pe jese. Jare perovia yave Tumpa umeeta co peve, penoita co —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jare Jesús uique ye yave Tumpa jo pe, sacerdote reta itenondegua reta jare tenta guasu pegua reta itenondegua reta yugüeru jae oĩ vae pe oporomboe rambueve, jare upɨrandu chupe: —¿Mbae nunga mbaepuere pa nenoi cua mbaembae ndiyapo vaerã? ¿Quía pa umee ndeve mbaepuere cua ndiyapo vaerã? —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jayave Jesús jei chupe reta: —Che vi tapɨrandu peve mbae re. Pemɨmbeu yave cheve, che vi amɨmbeuta peve mbae nunga mbaepuere anoi cua mbaembae ayapo vaerã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Quía pa ombou Juan upurumbɨbautiza vaerã? ¿Tumpa pa ombou? ani ¿ɨvɨ pegua reta pa ombou? —jei. Jayave jae reta jei uyupe: —Yae yave: ‘Tumpa co ombou’, jae jeita yandeve: ‘Jucuarãi yave, ¿maera pa perovia'ã?’ —jei reta uyupe—. ");
INSERT INTO gnwNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ẽrei yandepuere'ã yae: ‘Ɨvɨ pegua reta co ombou.’ Echa'ã yaquɨye tenta guasu pegua reta güi. Echa'ã opaete vae güɨrovia Juan co jae penti Tumpa iñee umɨmbeu vae —jei reta uyupe. ");
INSERT INTO gnwNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Jayave jei reta Jesús pe: —Nduicuaa'ã. —Che vi ndarau amɨmbeu peve mbae nunga mbaepuere anoi cua mbaembae ayapo vaerã —jei Jesús chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","¿Quirãi pa pepɨa pe piyemɨngueta cua re? Penti cuimbae güɨnoi mocui taɨ reta. Ou jei penti taɨ pe: ‘Cheraɨ, cua ara ecua eparavɨquɨ checo pe.’ ");
INSERT INTO gnwNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Taɨ jei chupe: ‘Aata'ã aparavɨquɨ.’ Ẽrei taɨcue rupi iquɨrẽɨ oo. Jáeramo oo uparavɨquɨ tu ico pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Jare cuimbae jei ĩru taɨ pe: ‘Cheraɨ, cua ara ecua eparavɨquɨ checo pe.’ Taɨ jei chupe: ‘Aata aparavɨquɨ, cheru.’ Ẽrei oo'ã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Quía nunga pa cua mocui vae güi uyapo tu jei vae? —jei. Jayave jae reta jei chupe: —Jocua tenonde tu oyocui vae. Jayave Jesús jei chupe reta: —Añete che jae peve, mburuvicha peguarã ocovara vae reta jare cuña aguasa rupi yugüɨreco vae reta uiqueta perenonde Tumpa iporoyocuia pe. ");
INSERT INTO gnwNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Echa'ã Juan ou uicuaaca peve jupi vae, ẽrei pe reta perovia'ã. Ẽrei mburuvicha peguarã ocovara vae reta jare cuña aguasa rupi yugüɨreco vae reta güɨrovia. Jare yepe tẽi cua picuaa, ẽrei peeya'ã piyemɨngueta icavi mbae vae pepɨa pe oĩ vae. Jecuae peatẽɨ perovia Juan —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Tamɨmbeu ye peve amɨjaanga reve cua: Ico penti cuimbae icorã uiquẽse vae. Jayave oñotɨ pɨpe jeta uva. Jayave oyoo ɨvɨ, jare uyapo uva uitami pɨpe vaerã. Uyapo vi penti chapapa, umae vaerã ɨvate güi opaete co re. Jayave uiporuca ico ĩru vae reta pe, jae reta uyandareco vaerã jese. Jayave co iya oo mbɨrɨ ambɨe ɨvɨ pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Jare uva yagüɨye ma yave, co iya ombou amocue jembiocui reta co iporúa reta pe, jae reta umbɨyao vaerã tẽi uva reta, iya güɨnoi vaerã imbaerã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ẽrei co iporúa reta uipɨsɨ co iya jembiocui reta, jare uinupa penti vae, jare uyuca ĩru vae, jare uyapi ita pe ĩru vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Jayave co iya ombou ye jeta catu ete jembiocui reta tenonde ombou vae güi. Ẽrei co iporúa reta jecuae jucuarãi uyapo ye chupe reta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Jayave taɨcue rupi co iya ombou taɨ. Jei tẽi iyupe: ‘Aramoi uipɨuta cheraɨ’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ẽrei co iporúa reta uecha yave co iya taɨ, jei reta uyupe: ‘Cua co jae iyarã vae. Yaa yayuca, jare yande yaicota co iyarã’ —jei reta, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Jayave jae reta uipɨsɨ co iya taɨ omombo co güi jare uyuca —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Jáeramo co iya ou ye yave, ¿mbae ra uyapota jocua co iporúa reta pe? —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Jayave jae reta jei Jesús pe: —Opata uyuca jocua cuimbae icavi mbae vae reta, jare uiporucata ico ambɨe vae reta pe. Jae reta umeeta co iya pe imbaerã uva yagüɨye ma yave —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jayave Jesús jei chupe reta: —¿Pemɨngueta'ã pa cua Tumpa iñee pe uyecuatía oĩ vae? ‘Ita tenta iyapoa reta omombo vae uyeyapo ma ita tenondegua vae. YandeYa uyapo cua. Yaecha ma, jare yandepɨacañɨ jese.’ Jucuarãi uyecuatía oĩ —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Jáeramo che jae peve, pe reta ndarau pico Tumpa iporoyocuia pe. Tumpa umeeta ĩru reta pe yugüɨreco vaerã joco pe. Jae reta uyapota jupi vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ime yave quía jocua ita re uyepɨaca vae, uñemopẽta co. Jare ime yave quía jocua ita oa jese vae, opata umbɨperasoraso —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Jare sacerdote reta itenondegua reta jare fariseo reta cua uyandu yave, uicuaa cua Jesús umɨjaanga reve jei vae uicuaaca quirãi jae reta teco güɨnoi. ");
INSERT INTO gnwNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Jare jae reta uipota tẽi uipɨsɨ Jesús. Ẽrei ipuere'ã. Echa'ã uquɨye jeta vae reta güi. Echa'ã jocua jeta vae reta güɨrovia Jesús co jae penti Tumpa iñee umɨmbeu vae. ");
INSERT INTO gnwNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jare Jesús imiari ye joco pe ñugüɨnoi vae reta pe umɨjaanga reve. Jei chupe reta: ");
INSERT INTO gnwNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Mboroyocuia ara pegua penti mburuvicha guasu rami co. Jocua mburuvicha guasu taɨ umendata. Jáeramo mburuvicha guasu uyapo parea —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Uparea ma amocue vae pe yugüeru vaerã menda pe. Jayave omondo jembiocui reta ueni reta vaerã. Ẽrei jae reta ñatẽɨ yugüeru —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Jayave mburuvicha guasu oyocui ye ĩru jembiocui reta. Jei chupe reta: ‘Pecua pemɨmbeu aparea chupe vae reta pe: Mase, jáema oĩ peu vaerã. Ayucaca ma chegüeye reta jare ĩru cherɨmba iquɨra vae reta. Ayapɨcatu ma opaete. Pecua menda pe’ —pere, jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ẽrei jae reta uipota'ã yugüɨraa. Penti vae oo ico pe. Ĩru vae oo umaemee. ");
INSERT INTO gnwNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Jare ĩru reta uipɨsɨ mburuvicha guasu jembiocui reta, uyapo icavi mbae vae chupe reta jare uyuca reta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ẽrei mburuvicha guasu uicuaa yave cua regua, pochɨ ete co. Jáeramo omondo isundaro reta opa vaerã uyuca jocua upuruyuca vae reta jare uapɨ vaerã jenta guasu —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Jayave mburuvicha guasu jei jembiocui reta pe: ‘Opaete uyeyapɨcatu ma oĩ yayapo vaerã menda. Ẽrei aparea chupe vae reta uyapo'ã jupi vae’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","‘Jáeramo pecua calle rupi jare pere opaete pevãe chupe vae reta pe yugüeru vaerã menda pe’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Jayave mburuvicha guasu jembiocui reta yugüɨraa calle rupi jare umbatɨ opaete uvãe chupe vae reta - icavi vae uyapo vae reta jare icavi mbae vae uyapo vae reta. Jare mburuvicha guasu jo tɨnee ma —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Jare mburuvicha guasu ou uvãe yave umae vaerã yugüeru vae reta re, uecha joco pe penti cuimbae temimonde menda pegua mbaetɨ güɨnoi vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Jayave jei chupe: ‘Cheamigo, ¿quirãi pa ndique cua pe temimonde menda pegua mbae reve?’ Ẽrei cuimbae jei'ã mbae ave —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Jayave mburuvicha guasu jei jembiocui reta pe: ‘Piñapɨ̃ti ipo rupi jare ipɨ rupi, jare peraa cua güi pemombo oca pe pɨ̃tumimbi oĩ vae pe. Joco pe uyaota jare jãi umbɨquɨrɨrɨuta’ —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Echa'ã Tumpa ueni jeta vae reta ẽrei mbovɨño uiparavo —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Jayave fariseo reta uyembatɨ, jare uyemboemboe quirãi ipuere uyavɨca Jesús pe jae uyemɨngueta yave. ");
INSERT INTO gnwNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Jayave jae reta omondo jemimboe reta Jesús oĩ vae pe herodiano reta ndive. Jae reta jei Jesús pe: —Oporomboe vae, nduicuaa nde ndere vae añete co. Nde ndeporomboe cavi quirãi Tumpa uipota yaico vaerã vae re. Nde nemae oyovaque opaete pãve re. Nembutuicha'ã penti ave ĩru vae güi —jei reta—. ");
INSERT INTO gnwNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Jáeramo emɨmbeu oreve, ¿quirãi pa ndepɨa pe ndiyemɨngueta cua re? César yandeocui yambɨepɨ vaerã chupe corepoti pe. ¿Jupi pa yambɨepɨ vaerã chupe? ani ¿jupi'ã pa? —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ẽrei Jesús uicuaa jae reta uipota tẽi co uyapo icavi mbae vae chupe, jare jei chupe reta: —¿Maera pa pipota piyavɨca cheve? Pe reta co jae upurumbɨtavɨ vae reta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Peechaca cheve corepoti mburuvicha guasu ocovara peve vae —jei. Jayave güeru reta chupe penti corepoti. ");
INSERT INTO gnwNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Jayave Jesús upɨrandu chupe reta: —¿Quía jova íã pa cua? ¿Quía jee pa cua uyecuatía oĩ vae? —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","—Jocua César imbae co —jei reta. Jayave Jesús jei chupe reta: —Pemee César pe Cesar pegua, jare pemee Tumpa pe Tumpa pegua. ");
INSERT INTO gnwNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Cua uyandu reta yave, ipɨacañɨ reta jese. Jayave jae reta yugüɨraa Jesús güi. ");
INSERT INTO gnwNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Jare jocua ara etei amocue saduceo reta yugüeru Jesús oĩ vae pe. Opaete saduceo reta jei umanocue vae reta icove ye'ã co. Saduceo yugüeru vae reta jei Jesús pe: ");
INSERT INTO gnwNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Oporomboe vae, Moisés jei ueya yandeve cuarãi: ‘Penti tɨqueɨ vae umano yave, jembirecocue mbaetɨ imembɨ chupe yave, cuimbae amɨri tɨvɨ tumenda jocua cuña ndive. Jayave cuña imembɨ yave, cuimbae tumbɨjee sambiaɨ tɨqueɨ amɨri jee pe.’ Jucuarãi jei Moisés —jei reta chupe—. ");
INSERT INTO gnwNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ico orepɨte pe penti cuimbae seis tɨvɨ reta güɨnoi vae. Cua cuimbae umenda, jare umano umɨmembɨ mbae reve. Cuimbae amɨri jaɨcue rupigua umenda jembirecocue ndive —jei reta—. ");
INSERT INTO gnwNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ẽrei jae vi umano umɨmembɨ mbae reve. Jae ramiño vi uyeyapo jaɨcue rupigua ye pe. Opaete siete reve umenda jocua cuña ndive, jare opaete siete reve umano umɨmembɨ mbae reve —jei reta—. ");
INSERT INTO gnwNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Taɨcue rupi cuña umano vi. ");
INSERT INTO gnwNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Jayave umanocue vae reta icove ye yave, ¿quía nunga vae jembirecorã pa icota jocua cuña? Echa'ã opaete siete reve umenda jae ndive —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ẽrei Jesús jei chupe reta: —Pe reta piyavɨ co. Echa'ã picuaa'ã Tumpa iñee uyecuatía oĩ vae jare Tumpa imbaepuere —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Umanocue vae reta icove ye yave, cuimbae reta jare cuña reta ndarau umenda. Yugüɨrecota ángel ara pe ñugüɨnoi vae reta yugüɨreco rami —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Tamɨmbeu peve umanocue vae reta regua. Icove yeta co. ¿Pemɨngueta'ã pa Tumpa iñee pe uyecuatía oĩ vae? ");
INSERT INTO gnwNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Echa'ã uyecuatía oĩ cuarãi: ‘Che co jae Abraham, Isaac jare Jacob iTumpa’ —jei Tumpa. Jucuarãi uyecuatía oĩ —jei—. Tumpa mbaetɨ co umanocue vae reta iTumpa. Jae co tecove güɨnoi vae reta iTumpa —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Jare yatɨ vae reta cua uyandu yave, ipɨacañɨ Jesús iporomboe re. ");
INSERT INTO gnwNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ẽrei fariseo reta uicuaa yave saduceo reta ipuere'ã ma co mbae jei Jesús pe, amocue jae reta uyembatɨ Jesús oĩ vae pe. ");
INSERT INTO gnwNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Jayave penti fariseo - jae co penti mboroyocui re oporomboe vae vi - upɨrandu Jesús pe mbae re. Uipota tẽi uyavɨca chupe. ");
INSERT INTO gnwNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Jei chupe: —Oporomboe vae, ¿mbae nunga mboroyocui pa co jae tenondegua vae? ");
INSERT INTO gnwNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jayave Jesús jei chupe: —Mboroyocui tenondegua vae co cua: ‘Eau ndeYa Tumpa opaete ndepɨa reve, opaete nderecove reve, jare opaete ndepɨayemɨngueta reve’ —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Cua co jae mboroyocui tenondegua vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Jare jaɨcue rupigua vae co cua: ‘Eau nderapicha nde ndiyerau rami’ —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Cua mocui mboroyocui ndiyapo yave, ndiyapo ma co opaete Moisés iporoyocui jei vae jare Tumpa iñee aracae umɨmbeu vae reta jei vae —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Jare fariseo reta Jesús oĩ vae pe uyembatɨ yave, Jesús upɨrandu chupe reta: ");
INSERT INTO gnwNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—¿Mbae pa pepɨa pe piyemɨngueta Cristo re? ¿Quía iñemoñaa reta pegua pa co jae? —Jae co David iñemoñaa reta pegua —jei reta chupe. ");
INSERT INTO gnwNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","—Jucuarãi yave, ¿maera pa David etei jei chupe: ‘CheYa’? Echa'ã Espíritu Santo uicuaaca David pe jucuarãi jei vaerã —jei chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Echa'ã David jei cuarãi: ‘YandeYa jei cheYa pe: Eguapɨ cheyɨpɨ pe cheacata cotɨ, nderovaicho reta opa amɨamɨri regua’ —jei yandeYa. Jucuarãi jei David aracae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","¿Quirãi pa ipuere ico David iñemoñaa reta peguarã? Echa'ã David etei jei chupe: ‘CheYa’ —jei Jesús chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Jare mbaetɨ quía ipuere umɨmbeu chupe. Jare jocua ara güive mbaetɨ ye quía uipota upɨrandu Jesús pe mbae re. ");
INSERT INTO gnwNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Jayave Jesús jei jeta vae pe jare jemimboe reta pe: ");
INSERT INTO gnwNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Mboroyocui re oporomboe vae reta jare fariseo reta umɨmbeu peve Moisés iporoyocui reta. ");
INSERT INTO gnwNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Jáeramo jecuaeño piyapo jei reta peve piyapo vaerã vae. Ẽrei agüɨye piyapo jae reta uyapo rami. Echa'ã jae reta etei uyapo'ã jei peve piyapo vaerã vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Jae reta jei ĩru vae reta pe uyapo vaerã yavai uyapo vaerã vae. Yamɨjaanga penti tɨvɨta. Jae reta jei ĩru vae reta pe ovoɨ vaerã penti tɨvɨta poɨ vae. Ẽrei jae reta omborɨ'ã etei ovoɨ vaerã. Uyavɨquɨ'ã etei reta jɨvɨta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Mboroyocui re oporomboe vae reta jare fariseo reta mbae uyapo yave, uipota ĩru vae reta uecha vaerã. Echa'ã jae reta oñono iyee Tumpa iñee jɨru tuicha vae jare uyapo jemimonde pucu —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Yugüɨraa yave tupao pe jare parea pe, jecuaeño uipota uguapɨ tenda tenondegua vae reta pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Jare uipota ĩru vae reta pe uyembɨsaludaca vaerã calle reta rupi jare jei vaerã chupe reta: ‘Oporomboe vae’ —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ẽrei agüɨye pipota ĩru vae reta jei vaerã peve: ‘Oporomboe vae.’ Echa'ã che co jae pomboe vae, jare opaete pe reta cherɨvɨ reta co —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Jare agüɨye pere: ‘Cheru’, penti cuimbae ɨvɨ pegua pe. Echa'ã pentiño co jae peRu, jare jae ico ara pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Jare agüɨye pipota ĩru vae reta jei vaerã peve: ‘Cheya.’ Echa'ã pentiño co jae peYa. Jae co che. Echa'ã che co jae Cristo, Tumpa ombou vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ime yave quía uipota tenondeguarã ico vae, tuyeyocui opaete ĩru reta pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Echa'ã uyembutuicha vae uñemɨmichicata co. Jae ramiño vi uñemɨmichi vae uyembutuichacata co —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Jayave Jesús jei mboroyocui re oporomboe vae reta jare fariseo reta pe: —Pe reta co jae mboroyocui re oporomboe vae reta jare fariseo reta. Piporarata co. Pe reta co jae upurumbɨtavɨ vae reta. Echa'ã pe reta piyopia ĩru vae reta agüɨye vaerã uique mboroyocuia ara pegua pe. Pe reta etei pique'ã. Ĩru vae reta uipota tẽi uique, ẽrei pe reta piyopia reta agüɨye vaerã uique —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Pe reta co jae mboroyocui re oporomboe vae reta jare fariseo reta. Piporarata co. Pe reta co jae upurumbɨtavɨ vae reta. Echa'ã pepɨ̃ro cuña ime umano vae reta güi opaete imbaembae, jare pucu piyerure Tumpa pe pepurumbɨtavɨ vaerã. Jáeramo piporara eteta co —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Pe reta co jae mboroyocui re oporomboe vae reta jare fariseo reta. Piporarata co. Pe reta co jae upurumbɨtavɨ vae reta. Echa'ã peo peeca opaete ɨ guasu rupi jare ɨvɨ rupi pevãe vaerã penti pepuere pemɨquɨrẽɨ peporomboe güɨrovia vaerã vae. Jare güɨrovia yave peporomboe, jecuae pemboe mbaembae re. Jocua jeco pegua jae uyeyapo icavi mbae vaerã. Pe reta peota tata guasu pe. Jare jae peporomboe re güɨrovia ramo, oota vi tata guasu pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Pe reta co jae jesa mbae vae uechaca ñugüɨnoi tape ĩru vae reta pe vae reta rami. Piporarata co. Echa'ã pe reta pere: ‘Ime yave quía: Tumpa jo jee re ayapota, jei vae, jocua mbae'ã co. Ẽrei ime yave quía: Oro Tumpa jo pegua jee re ayapota, jei vae, uyapota co jocua jei uyapota vae’ —pere, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Pe reta co jae jesa mbae vae reta rami. Pe reta pearacuaa'ã. Echa'ã jocua oro uñeñono tee Tumpa peguarã, Tumpa jo pegua co ramoño. Jáeramo Tumpa jo uyembujupica ete jocua oro Tumpa jo pegua güi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Jae ramiño vi pe reta pere: ‘Ime yave quía: Uñemeearenda jee re ayapota, jei vae, jocua mbae'ã co. Ẽrei ime yave quía: Ofrenda jee re uñemeearenda pe oĩ vae ayapota, jei vae, uyapota co jei uyapota vae’ —pere, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Pe reta co jae jesa mbae vae reta rami. Pe reta pearacuaa'ã. Echa'ã jocua ofrenda uñeñono tee Tumpa peguarã, uñemeearenda pe oĩ ramoño. Jáeramo uñemeearenda uyembujupica ete ofrenda uñemee vae güi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Jáeramo ime yave quía: Uñemeearenda jee re ayapota, jei vae, opaete ofrenda uñemeearenda pe oĩ vae uñemɨĩru uñemeearenda ndive —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Jae ramiño vi ime yave: Tumpa jo jee re ayapota, jei vae, Tumpa jo pe ico vae uñemɨĩru Tumpa jo ndive —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Jae ramiño vi ime yave quía: Ara jee re ayapota, jei vae, Tumpa uñemɨĩru ara ndive. Echa'ã ara Tumpa iguapɨa co —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Pe reta co jae mboroyocui re oporomboe vae reta jare fariseo reta. Piporarata co. Pe reta co jae upurumbɨtavɨ vae reta. Echa'ã pemee Tumpa pe diezmo temitɨ reta penoi vae güi. Ẽrei cua michi ete. Mboroyocui jei peve piyapo vaerã jeta ete cua güi. Echa'ã jei peve piyapo vaerã jupi vae jare pepuruparareco vaerã jare pepurugüɨrovia vaerã. Piyapo'ã opaete cua. Icavi co pemee vaerã Tumpa pe jocua nunga diezmo. Ẽrei piyapota tẽi jupi vae jare pepurupararecota tẽi jare pepurugüɨroviata tẽi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Pe reta co jae jesa mbae vae uechaca ñugüɨnoi tape ĩru vae reta pe vae reta rami. Pe reta peatẽɨ pemocui penti ñeti, ẽrei pemocui penti camello —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Pe reta co jae mboroyocui re oporomboe vae reta jare fariseo reta. Piporarata co. Pe reta co jae upurumbɨtavɨ vae reta. Pe reta co jae taza jare plato icupe rupiño uyeyoe vae rami. Ẽrei pepɨa iquɨa co. Echa'ã pipota ĩru vae reta imbaembae jare piyapo icavi mbae vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Pe reta co jae fariseo reta. Pe reta co jae jesa mbae vae reta rami. Piyoe rani pepɨa, taza jare plato japɨpe rupi piyoe rami. Jayave icupe rupi vi uyeyoeta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Pe reta co jae mboroyocui re oporomboe vae reta jare fariseo reta. Piporarata co. Pe reta co jae upurumbɨtavɨ vae reta. Echa'ã pe reta co jae teõgüerɨru uñemotĩ cavi vae reta rami. Jocua nunga teõgüerɨru ipõra echa, ẽrei japɨpe pe tɨnee umanocue vae reta icãgüecue reta pe jare iquɨa —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Jae ramiño vi ĩru vae reta ipɨa pe uyemɨngueta tẽi pe reta co jae jupi vae reta, ẽrei pepɨa tɨnee tavɨ jare icavi mbae vae pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Pe reta co jae mboroyocui re oporomboe vae reta jare fariseo reta. Piporarata co. Pe reta co jae upurumbɨtavɨ vae reta. Echa'ã pe reta piyapo Tumpa iñee aracae umɨmbeu vae reta iteõgüerɨru reta, jare pemopõra jupi vae reta iteõgüerɨru reta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Jare pere: ‘Yande yaico yave mona yandetenondegua reta yugüɨreco yave, yande yamborɨta'ã tẽi jae reta uyuca yave Tumpa iñee aracae umɨmbeu vae reta’ —pere, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Jucuarãi pere ramo, picuaaca quirãi pe reta co jae Tumpa iñee aracae umɨmbeu vae reta uyuca vae reta iñemoñaa reta pegua —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Agüɨyeta tẽi ma piyapo petenondegua reta uyapo rami —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Pe reta mboi reta rami co. Añete co, pe reta mboi reta iñemoñaa reta rami co. Ndarau etei piyerepɨ Tumpa perãa yave peo vaerã tata guasu pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Amondota peve chiñee umɨmbeu vae reta jare iyaracuaa catu vae reta jare cheporoyocui re oporomboe vae reta. Picututa curusu re amocue vae piyuca, jare pinupata chicote pe amocue vae petupao reta pe jare peaɨcuemoñata reta penti tenta guasu güi ĩru tenta guasu pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Jare pe reta penoita teco opaete jupi vae reta imano re. Tenonde voi Abel uyeyucaca - jae co jupi vae - jare taɨcue rupi Berequías taɨ Zacarías jee vae uyeyucaca. Echa'ã Zacarías umano maemɨmba uyeyucacue uñemeearenda jare Tumpa jo ipãu pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Añete che jae peve, cua reta jare opaete ĩru vae reta imano re pe reta añave pico vae piyembɨjecota —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jerusalén pegua reta, pe reta piyuca Tumpa iñee aracae umɨmbeu vae reta. Pe reta piyapi ita pe piyuca Tumpa ombou peve vae reta. Jeta vese ma chequɨrẽɨ tẽi pumbatɨ, uru umbatɨ imembɨ reta ipepo igüɨ pe rami, ẽrei pe reta pipota'ã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Mase, Tumpa usɨrɨta ma pegüi. ");
INSERT INTO gnwNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Che jae peve, ndarau ma cherecha pere regua: ‘Tuyembɨadoraca yandeYa jee re ou vae’ —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jayave Jesús oẽ Tumpa jo güi. Jare jemimboe reta yugüeru uechaca Jesús pe opaete o Tumpa jo pe ñugüɨnoi vae reta. ");
INSERT INTO gnwNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Jare Jesús jei chupe reta: —¿Pemae pa peĩ opaete cua o reta re? Añete che jae peve, ndarau upɨta penti ave ita ĩru ita iárambo. Opaete uyeitɨta co —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jare Jesús uguapɨ oĩ rambueve ɨvɨtu guasu Olivos re, jemimboe reta yugüeru jae oĩ vae pe jare jei chupe, jae retaño jae ndive ñugüɨnoi yave: —Emɨmbeu oreve, ¿quirãi yave pa cua uyeyapota? Jare ndeyu yeta ma yave, ¿quirãita pa nduicuaa? Jare cua ara reta opata ma yave, ¿quirãita pa nduicuaa? —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jayave Jesús jei chupe reta: —Piñemoa ngatu agüɨye vaerã petavɨ. ");
INSERT INTO gnwNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Echa'ã yugüeruta jeta cheree pe uyembɨjeeta vae reta. Jae reta jeita: ‘Che co jae Cristo.’ Jare umbɨtavɨta jeta vae reta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Imeta co ñerãro reta coiño pegüi. Imeta vi ñerãro reta mbɨrɨ pegüi. Piyandu yave cua reta regua, agüɨye pequɨye. Cua susere reta uyeyapoñotai co. Ẽrei cua susere reta ndei ave co opa vaerã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Penti ɨvɨ pegua reta uñerãrota ambɨe ɨvɨ pegua reta ndive, jare mburuvicha reta uñerãrota ĩru mburuvicha reta ndive. Jare imeta caruai reta jare ɨvɨcãta jeta que rupi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ẽrei cua susere reta uyembɨpɨ ramo co oĩ —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Jayave ĩru vae reta pemeeta uiporaracata peve vae reta pe, jare piyeyucacata. Jare piñemɨtarẽɨcata opaete vae pe chereco pegua —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Jare jeta vae uñatima yeta Tumpa güi jare uñemeeta reta jare uñemɨtarẽɨta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Jare jeta upurumbɨtavɨ vae reta jeita: ‘Che co jae penti Tumpa iñee umɨmbeu vae.’ Jáeramo jae reta umbɨtavɨta jeta vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Jare jeta vae uyapota icavi mbae vae. Jáeramo jeta tenonde yave upuruau vae reta ndarau ma upuruau —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ẽrei jõsata oo uvãe iyapɨ pe vae uyembɨasacata co —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Jare cua ñee icavi vae Tumpa iporoyocuia pegua jerãcuata opaete ɨvɨ rupi opaete ɨvɨ pegua reta uyandu vaerã. Jayave cua ara reta opata co —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Jare peechata icavi mbae vae opaete urucumegua vae uyemboɨ oĩ o uñeñono tee Tumpa peguarã vae pe. Tumpa iñee aracae umɨmbeu vae Daniel jei uyecuaata co. (Umɨngueta vae tuicuaa) —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Jayave Judea pe ñugüɨnoi vae reta tosi ɨvɨtu guasu cotɨ. ");
INSERT INTO gnwNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Jare o cupe re oĩ vae agüɨye tuique jo pe güɨraa vaerã imbaembae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Jare ico pe oĩ vae agüɨye tou ye jenta pe güɨraa vaerã iyasoya —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Jare ipurúa vae reta jare umɨcambu vae reta uiporara eteta jocua ara reta pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Jare piyerure Tumpa pe agüɨye vaerã pesi roɨ ma yave ani mbutuu ara pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Echa'ã jocua ara reta pe ɨvɨ pegua reta uiporara eteta. Jucuarãi'ã uiporara reta ɨvɨ uyeyapo güive, jare ndarau ye jucuarãi uiporara reta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Jare yandeYa uipota'ã yave opa vaerã jocua ara reta, mbaetɨta tẽi quía ipuere ico. Ẽrei Tumpa uiparavo vae reta jeco pegua opata jocua ara reta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Aramoi jocua ara reta pe quía jeita peve: ‘Mase, co oĩ Cristo’, ani jeita: ‘Mase, pee oĩ Cristo.’ Jucuarãi jei yave, agüɨye perovia —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Amocue upurumbɨtavɨ vae reta jeita: ‘Che co jae Cristo’, jare ĩru upurumbɨtavɨ vae reta jeita: ‘Che co jae Tumpa iñee umɨmbeu vae.’ Jare jae reta uyapota mɨacañɨ reta, umbɨtavɨ vaerã tẽi Tumpa uiparavo vae reta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Mase, amɨmbeu ma peve cua, ndei uyeyapo mbove —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Jayave ĩru vae reta jei yave peve: ‘Mase, ime co ñana pe oĩ’, agüɨye pecua. Jare ĩru vae reta jei yave peve: ‘Mase, ime co cua o pe oĩ’, agüɨye perovia —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Tamɨjaanga ama uvera vae. Echa'ã ama uvera vae uyecuaa opaete ara re guarasɨ oẽ vae cotɨ güi guarasɨ uique vae cotɨ pe. Jae ramiño vi che cuimbaerã ayeyapo vae ayecuaata opaete vae pe ayu ye yave —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Umano vae jetecue oĩ vae pe uyembatɨta uruvɨ reta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Jayave opa uiporara reta jocua ara reta pe yave, guarasɨ uñemɨpɨ̃tumimbita, jare yasɨ ndarau ma jembipe, jare yasɨtata reta oata ara güi, jare opaete ara re mbaepuere güɨnoi vae reta ucãtata —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Jayave mbae uyecuaata ara re. Jocua uicuaacata ɨvɨ pegua reta pe che cuimbaerã ayeyapo vae ayu yeta co. Jayave opaete atɨ Israel pegua reta ipɨatɨtɨta jare cherechata ayu amapɨ̃tu reve ara güi. Che cuimbaerã ayeyapo vae anoita mbaepuere tuicha vae, jare ayembɨadoracata opaete vae pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Jare amondota ángel cheve uyeyocui vae reta trompeta uñee reve, jae reta güeru vaerã aiparavo vae reta opaete ɨvɨ rupi güi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Yandepuere yamɨjaanga ɨva. Piyemboe jese —jei—. Joquɨ yave, picuaa uyaro ma co ama oquɨ vaerã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Jae ramiño vi pe reta peecha yave opaete cua mbaembae uyeyapo ñugüɨnoi vae, picuaata che coiño ma co aĩ —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Añete che jae peve, cua ɨvɨ pe añave yugüɨreco vae reta ndarau opa umano ndei opaete cua mbaembae uyeyapo mbove —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ara jare ɨvɨ opata, ẽrei chiñee ndarau opa —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Ẽrei mbaetɨ quía uicuaa mbae ara pe ani mbae ora pe yepe cua uyeyapota, jaeño cheRu. Ángel ara pe ñugüɨnoi vae reta uicuaa'ã. Che co jae Tumpa Taɨ. Ẽrei che ave aicuaa'ã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Noé ico rambueve, ɨvɨ pegua reta uyapo icavi mbae vae. Jae ramiño vi che cuimbaerã ayeyapo vae ayu ye yave, ɨvɨ pegua reta uyapota icavi mbae vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ndei ɨporu guasu ou mbove, ɨvɨ pegua reta ucaruñoi jare ucauñoi yugüɨreco, jare jecuaeño cuimbae reta umenda cuñatai reta ndive jare tu reta umee tayɨ reta cuimbae reta pe umenda jae ndive vaerã. Ẽrei penti ara Noé uique jocua chalana guasu pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Jare uyepocouca reta, ɨporu guasu ou yave. Jáeramo ɨporu guasu opa uyuca reta. Jucuarãita vi uyeyapo che cuimbaerã ayeyapo vae ayu ye yave —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Jocua ara mocui cuimbae imeta co pe ñugüɨnoi. Penti vae uyereraacata jare ĩru vae upɨtata co pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Jae ramiño vi mocui cuña umbaesota ñugüɨnoi penti angúa pe. Penti vae uyereraacata jare ĩru vae upɨtata —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Jáeramo jecuaeño peãro. Echa'ã picuaa'ã mbae ara pe ayu yeta. Che co jae peYa —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Aipota picuaa vaerã cua: Penti tenta iya uicuaa yave mbae ora pe outa uvãe imonda vae oñomi vaerã imbaembae jenta güi, uñemɨcuatɨ̃rota tẽi jare ndarau tẽi umaeño imonda vae re güɨraa vaerã imbaembae chugüi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Jae ramiño vi pe reta peãro, agüɨye vaerã che cuimbaerã ayeyapo vae ayu ye avãe piyandareco'ã pẽi yave —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Penti uyeyocui vae iyaracuaa vae uyapo ipatrón jei chupe uyapo vaerã vae. Jare ipatrón umee chupe ico vaerã ĩru jembiocui reta juvicharã, jare umee vaerã chupe reta jembiurã opa ara —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ipatrón ou ye uvãe yave jenta pe, uecha yave jocua jembiocui uyapo oĩ iparavɨquɨ, jocua jembiocui uyeroviata co —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Añete che jae peve, ipatrón umeeta chupe uyandareco vaerã opaete imbaembae re —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ẽrei aramoi uyeyocui vae uyapo icavi mbae vae jare jei iyupe ipɨa pe: ‘Chepatrón ndarau ou ye ɨmambae.’ ");
INSERT INTO gnwNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Jare umbɨpɨ uinupa ĩru uyeyocui vae reta, jare ucaru jare ucau usavɨpo vae reta ndive —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Jayave penti ara ipatrón ou yeta uvãe jembiocui uyandareco'ã oĩ yave. Jocua ora pe etei ipatrón uipocouta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Jayave ipatrón uiporaracata chupe jare omondota ico vaerã opaete ĩru upurumbɨtavɨ vae reta ndive. Joco pe uyaota jare jãi umbɨquɨrɨrɨuta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Mboroyocuia ara pegua diez cuñatai cuimbae güɨreco'ã etei vae reta rami co. Penti penti cuñatai güɨraa ilámpara oẽ oo uñeovãiti vaerã cuimbae umendata vae ndive —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Jare pandepo jocua cuñatai reta iyaracuaa, jare ĩru pandepo vae reta iyaracuaa mbae vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Jocua iyaracuaa mbae vae reta güɨraa ilámpara, ẽrei güɨraa'ã aceite lámpara peguarã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ẽrei iyaracuaa vae reta güɨraa vi aceite lámpara peguarã aceite jɨru pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Jare ndeiño ou uvãe cuimbae umendata vae. Jáeramo opaete cuñatai reta jopeɨ jare oque —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Jare pɨare mbɨte yave uyendu ñee. ‘Mase, outa ma uvãe cuimbae umendata vae. Pecua peovãiti’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Jayave opaete jocua cuñatai reta upũa jare uyapɨcatu ilámpara —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Jare cuñatai iyaracuaa mbae vae reta jei cuñatai iyaracuaa vae reta pe: ‘Pemee mi oreve michi peaceite. Echa'ã orelámpara ove ma’ —jei reta, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ẽrei cuñatai iyaracuaa vae reta jei: ‘Numee yave peve, ndarau ndipo uepitɨ oreve. Icavi ndipo pe reta peo vaerã aceite umee vae reta pe pegua vaerã piyupe’ —jei reta, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Jare cuñatai iyaracuaa mbae vae reta yugüɨraa aceite ueca rambueve, ou uvãe cuimbae umendata vae. Jare cuñatai iyaracuaa vae reta uique jae ndive menda uyeyapo oĩ vae pe. Jayave onque uyeyuquenda —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Jare taɨcue rupi yugüeru uvãe jocua ĩru cuñatai reta jare jei: ‘Oreya, oreya, ipea oreve onque.’ ");
INSERT INTO gnwNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ẽrei cuimbae jei chupe reta: ‘Añete che jae peve, pucuaa'ã.’ ");
INSERT INTO gnwNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Jáeramo jecuaeño peãro. Echa'ã picuaa'ã mbae ara pe jare mbae ora pe che cuimbaerã ayeyapo vae ayu yeta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Tamɨjaanga penti cuimbae iɨvɨ güi ambɨe ɨvɨ mbɨrɨ oĩ vae pe oota vae. Ndei oo mbove, ueni jembiocui reta jare jei chupe reta uyandareco vaerã imbaembae re —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Jayave umee penti jembiocui pe pandepo corepoti talento jee vae. Jare umee ĩru jembiocui pe mocui talento. Jare umee ĩru jembiocui pe penti talento. Echa'ã umee chupe reta penti penti ipuereta uyapo vae rupi. Jayave cuimbae oo ambɨe ɨvɨ cotɨ —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Jayave pandepo talento güɨnoi vae umbɨpɨ umɨmbaravɨquɨ icorepoti, jare jucuarãi umɨĩru jocua pandepo talento ndive pandepo ye —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Jae ramiño vi mocui talento güɨnoi vae umbɨpɨ umɨmbaravɨquɨ icorepoti, jare jucuarãi umɨĩru jocua mocui talento ndive mocui ye —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ẽrei penti talento güɨnoi vae oo oyoo ɨvɨ jare oñomi ɨvɨgüɨ pe corepoti ipatrón umee chupe vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Jare ɨma ma yave jocua uyeyocui vae reta ipatrón ou ye uvãe iɨvɨ pe jare upɨrandu chupe reta mbae ra uyapo icorepoti umee chupe reta vae pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Jare tenonde yave pandepo talento güɨnoi vae güeru jocua pandepo talento ĩru pandepo talento umɨĩru vae reve, jare jei ipatrón pe: ‘Patrón, nde nemee cheve pandepo talento. Mase, amɨĩru jae reta ndive pandepo talento ye’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Jayave ipatrón jei chupe: ‘Icavi ndiyapo. Nde co jae cherembiocui icavi vae. Ndiyeyocui cavi cheve cua mbovɨ vae re. Jáeramo tamee ndeve jeta mbaembae ndiyandareco jese vaerã. Iyerovia che ndive’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Jae ramiño vi tenonde yave mocui talento güɨnoi vae ou jei ipatrón pe: ‘Patrón, nde nemee cheve mocui talento. Mase, amɨĩru jae reta ndive mocui talento ye’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Jayave ipatrón jei chupe: ‘Icavi ndiyapo. Nde co jae cherembiocui icavi vae. Ndiyeyocui cavi cheve cua mbovɨ vae re. Jáeramo tamee ndeve jeta mbaembae ndiyandareco jese vaerã. Iyerovia che ndive’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Jayave tenonde yave penti talento güɨnoi vae ou jei ipatrón pe: ‘Patrón, che nducuaa co. Aicuaa nde co jae penti cuimbae jecopochɨ vae. Nde nepɨ̃ro mbaembae ĩru vae reta güi, jare ndeavɨro ĩru vae reta oñotɨ vae’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","‘Jáeramo aquɨye ndegüi ramo, aa añomi ndecorepoti ɨvɨgüɨ pe. Mase, co oĩ nembae’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Jayave ipatrón jei chupe: ‘Nde co jae cherembiocui icavi mbae vae. Ndeaquɨ co. Nde ndicuaa quirãi apɨ̃ro mbaembae ĩru vae reta güi jare quirãi aavɨro ĩru vae reta oñotɨ vae’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","‘Jáeramo nderaata tẽi checorepoti banco pe. Echa'ã jucuarãi ndiyapo yave, ayu ye yave nemeeta tẽi co cheve corepoti amee ndeve vae jare mbovɨ ye banco pegua reta umɨĩruta tẽi jae ndive vae’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Jayave ipatrón jei jembiocui reta pe: ‘Pepɨ̃ro chugüi jocua penti talento emee diez talento güɨnoi vae pe’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","‘Echa'ã güɨnoi vae pe uñemɨĩruta. Jeta eteta güɨnoi. Ẽrei mbaetɨ güɨnoi vae güi mbovɨ ete güɨnoi vae uyeequita’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","‘Ẽrei pemombo cua cherembiocui uyeyocui cavi'ã cheve vae oca pe pɨ̃tumimbi oĩ vae pe. Joco pe uyaota jare jãi umbɨquɨrɨrɨuta’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Che cuimbaerã ayeyapo vae ayu ye yave ayembɨadoraca vaerã, opaete ángel uñeñono tee Tumpa peguarã vae reta yugüeruta che ndive. Jayave aguapɨta cheguapɨa yembɨadora pegua pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Jare uyembatɨta cherovai opaete ɨvɨ pegua reta. Jare ambɨyaota amocue vae ĩru vae reta güi, penti cuimbae umbɨyao iovecha reta icapura reta güi rami —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Jare añonocata ovecha reta cheacata cotɨ jare capura reta cheaso cotɨ —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Che co jae Mburuvicha Guasu. Jaeta cheacata cotɨ ñugüɨnoi vae reta pe: ‘Peyu pico mboroyocuia ɨvɨ uyeyapo güive uñemɨcuatɨ̃ro peve vae pe. CheRu pemɨvendise ma’ —jaeta, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","‘Echa'ã chiyembaɨ yave, pemee acaru. Cheúe aico yave, pemee jau ɨ. Yepe tẽi che co jae ambɨe ɨvɨ pegua, ẽrei pemaeño vɨte cheré aico vaerã perenta pe’ —jaeta, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","‘Chenani yave, pemee cheve cheremimonderã. Chembaerasɨ yave, pepou chepɨ. Peresorɨru pe aĩ yave, peyu pepou chepɨ’ —jaeta, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Jayave jupi vae reta jeita cheve: ‘OreYa, ¿quirãi yave pa nduecha ndiyembaɨ yave jare numee ndecaru? ¿Quirãi yave pa nduecha ndeúe yave jare numee ndeu ɨ?’ —jeita, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","‘¿Quirãi yave pa nduecha penti ambɨe ɨvɨ peguarã ndico yave, jare numaeño nderé ndico vaerã orerenta pe? ¿Quirãi yave pa nduecha nenani jare numee ndeve nderemimonderã?’ —jeita, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","‘¿Quirãi yave pa nduecha nembaerasɨ ani peresorɨru pe jare ndopou ndepɨ?’ —jeita, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Jayave che jaeta chupe reta: ‘Añete che jae peve, jucuarãi piyapo cherɨvɨ reta pe, yepe tẽi uñererɨ̃roca. Jare jucuarãi piyapo yave, piyapo co cheve vi’ —jaeta, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Jayave jaeta cheaso cotɨ ñugüɨnoi vae reta pe: ‘Pesɨrɨ chegüi pecua tata opa mbae vae pe. Jocua tata uñemɨcuatɨ̃ro ma oĩ aña guasu jare opaete ángel chupe uyeyocui vae reta pe. Tumpa uiporaracata peve’ —jaeta, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","‘Echa'ã chiyembaɨ yave, pemee'ã acaru. Cheúe yave, pemee'ã ɨ jau’ —jaeta, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","‘Che co jae ambɨe ɨvɨ pegua jare pemaeño'ã cheré aico vaerã perenta pe. Chenani yave, pemee'ã cheve cheremimonderã. Chembaerasɨ yave jare peresorɨru pe aĩ yave, pepou'ã chepɨ’ —jaeta, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Jayave jae reta vi jeita cheve: ‘OreYa, ¿quirãi yave pa nduecha ndiyembaɨ yave, ani ndeúe yave, ani ambɨe ɨvɨ peguarã ndico yave, ani nenani yave, ani nembaerasɨ yave, ani peresorɨru pe neĩ yave, jare nomborɨ'ã?’ —jeita, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Jayave che jaeta chupe reta: ‘Añete che jae peve, pemborɨ'ã cherɨvɨ uñererɨ̃roca vae reta. Jare jucuarãi co chemborɨ'ã’ —jaeta, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Jare cua reta yugüɨraata tata guasu pe. Joco pe uiporarata reta jaeño mai pegua. Ẽrei jupi vae reta güɨnoita tecove opa mbae vae —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jare opaete cua jei ma yave, Jesús jei jemimboe reta pe: ");
INSERT INTO gnwNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Picuaa mocui araño ma co uata pascua iara uvãe vaerã, jare che cuimbaerã ayeyapo vae añemeecata co ayecutuca vaerã —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Jare sacerdote reta itenondegua reta jare tenta guasu pegua reta itenondegua reta uyembatɨ sacerdote tenondegua joca pe. Sacerdote tenondegua jee co Caifás. ");
INSERT INTO gnwNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Jare uyemboemboe reta quirãi ipuere uipɨsɨ vɨari Jesús uyucaca vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ẽrei jei reta: —Agüɨye yaipɨsɨ pascua ara rupi, agüɨye vaerã tenta guasu pegua reta uyapo tecorai. ");
INSERT INTO gnwNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jare Jesús oĩ rambueve tenta guasu-raɨ Betania pe Simón ipire ocuise vae jenta pe, ");
INSERT INTO gnwNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","uique penti cuña. Jae güeru ɨru-raɨ ita alabastro jee vae pegua. Cua ɨru-raɨ tɨnee mbae ipiche cavi vae jepɨ vae pe. Jare cuña upɨyere mbae ipiche cavi vae Jesús iñãca re, Jesús mesa pe uguapɨ oĩ rambueve. ");
INSERT INTO gnwNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Jare Jesús jemimboe reta cua uecha yave, pochɨ cuña pe. Jei reta: —¿Maera pa umɨcañɨtei? ");
INSERT INTO gnwNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Echa'ã umee yave corepoti re, guɨnoita tẽi jeta corepoti umee vaerã iparavete vae reta pe —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ẽrei Jesús uicuaa jei reta vae, jare jei chupe reta: —¿Maera pa pemambeco cuña? Icavi vae co uyapo cheve —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Echa'ã yugüɨrecoñotai co iparavete vae reta pe reta ndive, ẽrei che ndarau aicoño pe reta ndive —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Cua mbae ipiche cavi vae upɨyere cheré vae pe chembɨpiche cavi ma, ndei añeñotɨca mbove —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Añete che jae peve, opaete ɨvɨ rupi ñee icavi vae jerãcua vae rupi, cua uyapo vae vi jerãcuata, ĩru vae reta imandúa vaerã jese —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Jayave jocua doce jemimboe reta güi penti Judas Iscariote jee vae oo sacerdote reta itenondegua reta ñugüɨnoi vae pe, ");
INSERT INTO gnwNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","jare jei chupe reta: —¿Mbae pa pemeeta cheve, amee yave Jesús peve? Jayave jae reta jei umeeta co chupe treinta corepoti. ");
INSERT INTO gnwNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Jayave jocua güive Judas ueca quirãi ipuere umee Jesús chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Jare jocua ara judío reta umbɨpɨ jou mbɨyape ovu mbae vae yave, Jesús jemimboe reta yugüeru jei chupe: —¿Quíape pa ndipota nduyapɨcatu vaerã, tembíu pascua pegua ndeu vaerã? ");
INSERT INTO gnwNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jayave Jesús jei chupe reta: —Pecua tenta guasu pe pere cuimbae amɨmbeu peve vae pe: ‘Oporomboe vae jei: Ora uvãe ma. Jauta tembíu pascua pegua nerenta pe cheremimboe reta ndive’ —jei, pere chupe, jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Jayave jemimboe reta uyapo Jesús jei chupe reta uyapo vaerã vae. Jare uyapo reta tembíu pascua pegua jou reta vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Jare pɨ̃tu ma yave Jesús uguapɨ ucaru vaerã jocua doce jemimboe reta ndive. ");
INSERT INTO gnwNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Jare ucaru ñugüɨnoi rambueve, Jesús jei chupe reta: —Añete che jae peve, penti pepɨte pe oĩ vae chemeeta cherovaicho reta pe. ");
INSERT INTO gnwNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Jayave jae reta ipɨatɨtɨ, jare jei Jesús pe penti penti rupi: —CheYa, ¿che pa co jae? ");
INSERT INTO gnwNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jayave Jesús jei chupe reta: —Mbɨyape umãquɨ oĩ che ndive plato pe vae co jae. ");
INSERT INTO gnwNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Che cuimbaerã ayeyapo vae aañotai amano vaerã, uyecuatía oĩ cheregua rami. Ẽrei jocua cuimbae chemeeta vae uiporarata co. Icavi tẽi mona jocua cuimbae mbaetɨ ico yave —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Jayave Judas (Jesús umee vae) jei chupe: —Oporomboe vae, ¿che pa co jae? —Ndere ma co —jei Jesús chupe. ");
INSERT INTO gnwNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Jare ucaru ñugüɨnoi rambueve, Jesús uipɨsɨ mbɨyape, jare umee yasurupai Tumpa pe. Jayave upɨsãa mbɨyape jare umee jemimboe reta pe. —Peu —jei chupe reta—. Cua co jae cherete —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Jayave Jesús uipɨsɨ vi penti copa, jare yasurupai umee ye yave Tumpa pe, umee jemimboe reta pe. —Peu opaete pe reta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Cua co jae cherugüɨ. Cherugüɨ uyepɨyereta, Tumpa jei pɨau ye vae uyeyapo vaerã, jare Tumpa umbɨasa vaerã jeta vae pe imbaeyoa reta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ẽrei che jae peve, ndarau ma jau uva tɨcuecue, cheRu iporoyocuia pe uva tɨcuecue ipɨau vae pe reta ndive jau regua —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Jare opa yave ucanta reta Tumpa pe, oẽ reta yugüɨraa ɨvɨtu guasu Olivos cotɨ. ");
INSERT INTO gnwNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Jayave Jesús jei chupe reta: —Opaete pe reta chereyata cua pɨ̃tu. Echa'ã Tumpa iñee pe uyecuatía oĩ cuarãi: ‘Ayucata ovecha reta iyandarecoa, jare ovecha reta opata uñemɨai.’ Jucuarãi uyecuatía oĩ —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ẽrei aicove ye ayu yave umanocue vae reta ipɨte güi, aata perenonde Galilea pe —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Jayave Pedro jei Jesús pe: —Yepe tẽi opaete ĩru reta tandereya, ẽrei che ndarau ndueya. ");
INSERT INTO gnwNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","—Añete che jae ndeve —jei Jesús chupe—, cua pɨ̃tu etei, ndei uru cuimbae uñee mbove, mbapɨ vese ma checuacuta —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ẽrei Pedro jei chupe: —Yepe tẽi tamano nde ndive, ẽrei ndarau nducuacu. Jare jucuarãi vi jei opaete Jesús jemimboe reta. ");
INSERT INTO gnwNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Jayave Jesús oo jae reta jupíe uvãe Getsemaní pe. Jare Jesús jei jemimboe reta pe: —Peguapɨ cua pe, che aa pea pe ayerure Tumpa pe rambueve. ");
INSERT INTO gnwNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Jayave güɨraa Pedro jare jocua mocui Zebedeo taɨ reta, jare umbɨpɨ ipɨatɨtɨ jare uiporara. ");
INSERT INTO gnwNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Jayave jei jocua mbapɨ jemimboe reta pe: —Tuicha chepɨatɨtɨ, jare amano pota echa. Pepɨta cua pe, jare agüɨye peque —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Jayave Jesús usɨrɨ catu chugüi reta, jare uyeatɨca ɨvɨ re jare uyerure Tumpa pe. —CheRu, nde ndipota yave, embɨasa chegüi cua aiporarata vae. Ẽrei tuyeyapo cheve nde ndere vae. Agüɨye tuyeyapo che jae vae —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Jayave Jesús ou ye jemimboe reta ñugüɨnoi vae pe, jare uecha oque ñugüɨnoi. Jayave jei Pedro pe: —¿Pepuere'ã pa penti ora yepe peque mbae peĩ chemborɨ vaerã? ");
INSERT INTO gnwNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Agüɨye peque. Piyerure Tumpa pe, agüɨye vaerã peyoa. Pepɨa pe peratangãtu co, ẽrei perete iyaquɨ co —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Jayave Jesús usɨrɨ ye uyerure Tumpa pe. —CheRu, nde ndipota yave aiporara vaerã, tuyeyapo cheve nde ndere vae —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Jayave ou ye jemimboe reta ñugüɨnoi vae pe, jare uecha oque ye ñugüɨnoi. Echa'ã jae reta jopeɨ ete ma. ");
INSERT INTO gnwNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Jayave Jesús usɨrɨ ye chugüi reta uyerure Tumpa pe. Uyerure ye tenonde yave uyerure rami. ");
INSERT INTO gnwNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Jayave ou ye jemimboe reta ñugüɨnoi vae pe jare jei chupe reta: —Peque jare peputuuño ma. Mase, ora uvãe ma. Che cuimbaerã ayeyapo vae penti vae chemeeta cuimbae jeco pochɨ vae reta pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Pepũa. Yaaño ma. Mase, chemeeta vae coiño ma ou —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jare uyemɨngueta oĩ rambueve, ou Judas - jae co jocua doce vae güi penti. Jeta vae yugüeru jae ndive iquɨsepucu reve jare iɨvɨra reve reve. Sacerdote reta itenondegua reta jare tenta guasu pegua reta itenondegua reta ombou Jesús pe cua reta. ");
INSERT INTO gnwNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Jare umeeta vae umɨmbeu ma ĩru reta pe mbae uyapota vae. Jei ma chupe reta: —Jocua ayurupɨteta vae co jae. Pipɨsɨ curi —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Judas ou voi Jesús oĩ vae pe. —Pɨ̃tu ma, oporomboe vae —jei chupe. Jayave uyurupɨte. ");
INSERT INTO gnwNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jayave Jesús jei chupe: —Cheamigo, ¿maera pa ndiyapo jucuarãi? Jayave ĩru reta yugüeru uipɨsɨ Jesús. ");
INSERT INTO gnwNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Jare penti Jesús ndive oĩ vae uipɨsɨ iquɨsepucu jare uequi jɨru güi, jare uiporu sacerdote tenondegua jembiocui inambi re, jare uyasɨa inambi chugüi. ");
INSERT INTO gnwNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jayave Jesús jei chupe: —Iñono ye quɨsepucu jɨru pe. Echa'ã opaete quɨsepucu uiporu vae reta uyeyucacata quɨsepucu pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Aipota yave, chepuere ayerure cheRu pe ombou voi vaerã jeta ángel reta cherepɨ vaerã. ¿Ndicuaa'ã pa cua? —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ẽrei jucuarãi yave, ¿quirãita pa uyeyapo Tumpa iñee pe uyecuatía oĩ vae? Echa'ã jei jucuarãita co uyeyapo cheve —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Jayave Jesús jei yugüeru vae reta pe: —¿Maera pa peru quɨsepucu reta jare ɨvɨra reta chepɨsɨ vaerã, imonda vae pipɨsɨ vae rami? Opa ara aguapɨ pe reta ndive Tumpa jo pe. Joco pe aporomboe, jare chepɨsɨ'ã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ẽrei opaete cua uyeyapo oĩ Tumpa iñee aracae umɨmbeu vae reta uicuatía vae uyeyapo vaerã —jei. Jayave opaete jemimboe reta ueya Jesús, jare opa osi. ");
INSERT INTO gnwNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Jayave Jesús uipɨsɨ vae reta güɨraa sacerdote tenondegua Caifás jenta pe. Jare joco pe uyembatɨ ma mboroyocui re oporomboe vae reta jare tenta guasu pegua reta itenondegua reta. ");
INSERT INTO gnwNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Jare Pedro oo vi Jesús jaɨcue. Ẽrei mbɨrɨño oo chugüi. Jae uique sacerdote tenondegua joca pe, jare uguapɨ sacerdote tenondegua jembiocui reta ndive, uecha vaerã mbae uyeyapota vae. ");
INSERT INTO gnwNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Jare sacerdote reta itenondegua reta jare opaete ĩru mburuvicha reta ueca quía uñeapo vaerã Jesús re iyapu reve, uyucaca vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ẽrei uvãe'ã reta teco jese, yepe tẽi jeta vae iyapu reve uñeapo jese. Taɨcue rupi mocui vae iyapu reve uñeapo jese. ");
INSERT INTO gnwNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Jae reta jei: —Cua cuimbae jei: ‘Chepuere ambusururu Tumpa jo jare ayapo ye mbapɨ ara pe’ —jei, jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Jayave sacerdote tenondegua upũa uyemboɨ jare upɨrandu Jesús pe: —¿Maera pa niñee nemoẽ'ã? ¿Mbae re pa cua reta uñeapo nderé? —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ẽrei Jesús quĩiño. Jayave sacerdote tenondegua upɨrandu ye chupe: —¿Nde pa co jae Cristo, Tumpa ombou vae? ¿Nde pa co jae Tumpa Taɨ? Che ndoyocui Tumpa jecuaeño ico vae jee re nemɨmbeu vaerã oreve —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jayave Jesús jei chupe: —Nde ndere rami jae co che. Ẽrei che jae peve, che cuimbaerã ayeyapo vae cherechata co aguapɨ aĩ Tumpa mbaepuere güɨnoi vae iyɨpɨ pe iyacata cotɨ. Cherechata vi ayu amapɨ̃tu reve ara güi —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Jayave sacerdote tenondegua cua uyandu yave, pochɨ ramo omondoro jemimondei, jare jei: —Jei ma icavi mbae vae Tumpa cotɨ. ¿Maera ma pa yaeca yeta ĩru vae reta uñeapo vaerã jese? Mase, pe reta piyandu ma icavi mbae vae jei Tumpa cotɨ —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Mbae pa pere añave? —jei. Ĩru reta jei chupe: —Icavi'ã co. Icavi co yayucaca vaerã —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Jayave amocue vae undɨvɨ Jesús jova re, jare uinupa. Jare ĩru vae reta ocua jese, ");
INSERT INTO gnwNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","jare jei chupe: —Nde co jae Cristo, Tumpa ombou vae yave, emɨmbeu oreve quía ra ocua oĩ nderé. ");
INSERT INTO gnwNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Jare Pedro uguapɨ oĩ oca pe. Jare penti cuñatai ou jei chupe: —Nde vi co jae Jesús Galilea pegua iĩru. ");
INSERT INTO gnwNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","—Che jae iĩru'ã co —jei Pedro opaete vae jovaque—. Aicuaa'ã mbae ndere vae —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Jayave Pedro oo onque tuicha vae cotɨ. Jare ĩru cuñatai uecha jare jei joco pe ñugüɨnoi vae reta pe: —Cua cuimbae co jae penti Jesús Nazaret pegua iĩru. ");
INSERT INTO gnwNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ẽrei Pedro jei ye: —Che jae iĩru'ã co. Tumpa jee re aicuaa'ã jocua cuimbae —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Jare ndei ɨma mbove joco pe ñugüɨnoi vae reta yugüeru jei Pedro pe: —Añete co, nde co jae penti Jesús iĩru. Echa'ã nde ndiyemɨngueta Jesús iĩru reta uyemɨngueta vae rami —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Jayave Pedro jei Tumpa jee re: —Tumpa tuiporaraca cheve cua jae vae añetete'ã yave. Aicuaa'ã jocua cuimbae. Jare jupivoi uru cuimbae uñee. ");
INSERT INTO gnwNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Jare Pedro imandúa Jesús jei chupe vae re: “Ndei uru cuimbae uñee mbove, mbapɨ vese ma checuacuta.” Jayave Pedro oẽ joco güi, jare tanta ipɨatɨtɨ reve uyao. ");
INSERT INTO gnwNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Jare cõe ma yave, opaete sacerdote reta itenondegua reta jare tenta guasu pegua reta itenondegua reta uyemboemboe Jesús re, uyucaca vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Jayave uipocua Jesús jare güɨraa mburuvicha guasu Poncio Pilato pe umee. ");
INSERT INTO gnwNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Jayave Judas (Jesús umee vae) ipɨatɨtɨ uyapo vae re. Echa'ã uicuaa ma quirãi Jesús jovaicho reta umbɨjeco ma Jesús. Jayave güɨraa ye jocua treinta corepoti sacerdote reta itenondegua reta jare tenta guasu pegua reta itenondegua reta ñugüɨnoi vae pe. ");
INSERT INTO gnwNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Jare jei chupe reta: —Ayapo mbaeyoa. Echa'ã amee peve jocua cuimbae teco güɨnoi mbae vae piyucaca vaerã —jei. Jayave jae reta jei Judas pe: —Jocua mbae'ã co oreve. Nde co nenoi teco. ");
INSERT INTO gnwNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Jayave Judas omombo corepoti Tumpa jo pe. Jayave oẽ Tumpa jo güi oo uyeyuvɨ. ");
INSERT INTO gnwNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Jayave sacerdote reta itenondegua reta omonoo jocua corepoti jare jei: —Jupi'ã co ñañono ye vaerã cua corepoti jɨru Tumpa jo pe oĩ vae pe. Echa'ã ñamee Judas pe yandepuere vaerã yayucaca Jesús —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Jayave uyemɨngueta reta uicuaa vaerã mbae ra uyapota corepoti pe. Jayave ogua ñaeu iyapoa iɨvɨ, uñeñotɨca vaerã joco pe ambɨe ɨvɨ pegua reta. ");
INSERT INTO gnwNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Jáeramo umbɨjee jocua ɨvɨ: Ɨvɨ tugüɨ jepɨcue. ");
INSERT INTO gnwNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Jare jucuarãi uyeyapo Tumpa iñee aracae umɨmbeu vae Jeremías jei vae. Echa'ã jae jei cuarãi: “Jare jae reta omonoo jocua treinta corepoti. Echa'ã Israel pegua reta umbɨepɨ treinta corepoti jocua cuimbae re. Jepɨ co treinta corepoti. ");
INSERT INTO gnwNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Jayave ogua pɨpe ñaeu iyapoa ico, yandeYa jei cheve rami.” Jucuarãi jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jare Jesús uyemboɨ mburuvicha guasu jovai. Jayave mburuvicha guasu upɨrandu chupe: —¿Nde pa co jae judío reta juvicha guasu? —jei. —Nde ndere rami jae co che —jei Jesús chupe. ");
INSERT INTO gnwNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Jare sacerdote reta itenondegua reta jare tenta guasu pegua reta itenondegua reta uñeapo Jesús re yave, Jesús jei'ã mbae ave. ");
INSERT INTO gnwNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Jayave Pilato jei chupe: —¿Ndiyandu'ã pa quirãi jeta mbaembae re uñeapo reta nderé? ");
INSERT INTO gnwNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ẽrei Jesús jei'ã mbae ave chupe. Jáeramo mburuvicha guasu ipɨacañɨ jese. ");
INSERT INTO gnwNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Jare pascua ara rupi Pilato oyoracañoi penti pereso tenta guasu pegua reta uipota vae. ");
INSERT INTO gnwNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Jare peresorɨru pe oĩ penti cuimbae jerãcua vae. Jee co Barrabás. ");
INSERT INTO gnwNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Jayave Pilato upɨrandu yatɨ vae reta pe: —¿Pipota pa ayoraca vaerã peve Barrabás ani Jesús, Cristo jee vae? ");
INSERT INTO gnwNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Echa'ã jae uicuaa judío reta umee Jesús chupe ñacatãa jese ramo. ");
INSERT INTO gnwNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Jare Pilato uguapɨ oĩ yave uãa vaerã Jesús, jembireco ombou quía jei vaerã chupe: —Agüɨye iyapo mbae jocua cuimbae jupi vae pe. Echa'ã aiporara ma pɨare chepau pe jae jeco pegua. ");
INSERT INTO gnwNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ẽrei sacerdote reta itenondegua reta jare tenta guasu pegua reta itenondegua reta omboemboe yatɨ vae reta uyerure vaerã Pilato pe oyoraca vaerã Barrabás jare uyucaca vaerã Jesús. ");
INSERT INTO gnwNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Jayave Pilato upɨrandu chupe reta: —¿Quía nunga pa cua mocui cuimbae güi pipota ayoraca vaerã peve? —Barrabás —jei reta chupe. ");
INSERT INTO gnwNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Jayave Pilato upɨrandu chupe reta: —Jucuarãi yave, ¿mbae pa pipota ayapo vaerã Jesús, Cristo jee vae pe? Jayave opaete vae jei: —Tuyecutuca curusu re. ");
INSERT INTO gnwNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ẽrei Pilato upɨrandu chupe reta: —¿Mbae icavi mbae vae pa uyapo? Ẽrei jae reta iñeeãta reve jei: —Tuyecutuca curusu re. ");
INSERT INTO gnwNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Jare Pilato uicuaa yave ipuere'ã mbae uyapo oyoraca vaerã Jesús - echa'ã judío reta umbɨpɨ uyapo tecorai - jei güeru vaerã chupe ɨ jare uyepoe yatɨ vae reta jovai. Jayave jei chupe reta: —Che anoi'ã teco cua cuimbae jupi vae imano re. Pe reta penoi teco —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Jayave opaete yatɨ vae reta jei: —Ore jare oriñemoñaa reta turugüɨnoi teco imano re. ");
INSERT INTO gnwNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Jayave Pilato oyoraca chupe reta Barrabás. Jare uinupaca ma yave Jesús chicote pe, umee sundaro reta pe, uicutu vaerã curusu re. ");
INSERT INTO gnwNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Jayave mburuvicha guasu isundaro reta güɨraa Jesús palacio pe, jare umbatɨ opaete ĩru sundaro reta joco pe. ");
INSERT INTO gnwNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Jayave sundaro reta omboi Jesús güi jemimonde jare omondeca chupe temimonde pɨ̃ta vae. ");
INSERT INTO gnwNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Jayave oñope reta yurãti catuii vae jare umbapúa oñono Jesús iñãca re. Umee reta vi chupe penti tacuarãsɨ uipɨsɨ vaerã ipo iyacata pe. Jayave uyeatɨca reta jae jovai jare oyoyai. —¡Viva, judío reta juvicha guasu! —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Jare undɨvɨ reta jese. Jayave uipɨsɨ reta tacuarãsɨ uiporu iñãca re. ");
INSERT INTO gnwNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Jare opa oyoyai reta yave, sundaro reta omboi chugüi temimonde pɨ̃ta vae, jare omondeca ye chupe jemimondei. Jayave güɨraa reta mburuvicha guasu joca güi, uicutu vaerã curusu re. ");
INSERT INTO gnwNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Jare yugüɨraa reta rambueve, uecha penti cuimbae Simón jee vae. (Cua Simón tenta guasu Cirene pegua co.) Jayave sundaro reta güɨraaca Simón pe Jesús icurusu. ");
INSERT INTO gnwNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Jare sundaro reta güɨraa Jesús Gólgata jee vae pe. (Cua uipota jei: “Ãcacuerenda”.) ");
INSERT INTO gnwNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Jayave umee reta Jesús pe vino uyea mbae iro vae ndive vae. Ẽrei Jesús uicuaa yave mbae jocua, jou'ã. ");
INSERT INTO gnwNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Jayave sundaro reta uicutu curusu re. Jayave uyuguari reta Jesús jemimonde re, uicuaa vaerã mbae nunga penti penti güɨraa iyupe vaerã. Jucuarãi uyapo reta uyeyapo vaerã Tumpa iñee aracae umɨmbeu vae jei vae. Echa'ã jei cuarãi: “Uyuguari reta cheremimonde re, uicuaa vaerã mbae nunga penti penti güɨraa iyupe vaerã.” Jucuarãi jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Jayave sundaro reta uguapɨ joco pe uyandareco vaerã Jesús re. ");
INSERT INTO gnwNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Jare oñono reta curusu re Jesús iñãca iárambo uyecuatía mbae umbɨjeco jesegua vae: “Cua co Jesús, judío reta juvicha guasu.” ");
INSERT INTO gnwNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Jare sundaro reta uicutu vi mocui imonda vae reta, jare oñono penti Jesús iyacata cotɨ jare ĩru iyaso cotɨ. ");
INSERT INTO gnwNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Jare uasa vae reta uñeãcambɨvava reve jei icavi mbae vae Jesús pe. ");
INSERT INTO gnwNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","—Nde ndere nembusururuta co Tumpa jo jare ndiyapo yeta mbapɨ ara pe —jei reta chupe—. Iyerepɨ. Nde co jae Tumpa Taɨ yave, egüeyɨ curusu güi —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Jae ramiño vi sacerdote reta itenondegua reta jare mboroyocui re oporomboe vae reta jare tenta guasu pegua reta itenondegua reta oyoyai. ");
INSERT INTO gnwNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Jae uepɨ ĩru vae reta —jei reta—. Ẽrei ipuere'ã jae uyerepɨ. Jae co Israel pegua reta juvicha guasu yave, tugüeyɨ añave curusu güi, yarovia vaerã jese —jei reta—. ");
INSERT INTO gnwNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Güɨrovia Tumpa re; Tumpa tuepɨ añave, uipota yave. Echa'ã jae jei: ‘Che co jae Tumpa Taɨ’ —jei, jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Jare imonda vae Jesús ndive uyecutuca vae reta jei icavi mbae vae chupe. ");
INSERT INTO gnwNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Jare guarasɨ ara mbɨte güive mbapɨ ora rupi uñemɨpɨ̃tumimbi opaete ɨvɨ pe. ");
INSERT INTO gnwNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Jayave mbapɨ ora ma caaru yave Jesús iñeeãta reve jei: —Elí, Elí, ¿lama sabactani? (Cua uipota jei: “CheTumpa, cheTumpa, ¿maera pa chereya?”) ");
INSERT INTO gnwNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Amocue joco pe ñugüɨnoi vae reta uyandu jare jei tẽi: —Mase, Elías ueni. ");
INSERT INTO gnwNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Jare jupivoi penti vae osi oo umãquɨ esponja vinagre pe, jare oñono tacuarãsɨ re, jare omondo Jesús iyuru cotɨ. ");
INSERT INTO gnwNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ẽrei ĩru reta jei: —Eãro. Yaecha ou Elías umbɨgüeyɨ vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jayave Jesús tanta usapɨcai, jare umano. ");
INSERT INTO gnwNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Jayave Tumpa jo umbɨyao vae osoro mbɨte rupi ɨvate güi ɨvɨ cotɨ. Jare ɨvɨ ucãta jare itape reta ovo. ");
INSERT INTO gnwNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Jare teõgüerɨru reta uyepea, jare jeta uñeñono tee Tumpa peguarã umanocue vae reta icove ye, ");
INSERT INTO gnwNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","jare oẽ teõgüerɨru reta güi Jesús icove ye yave ou umanocue vae reta ipɨte güi. Jae reta yugüɨraa Jerusalén pe jare uyecuaa jeta vae pe. ");
INSERT INTO gnwNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Jare sundaro reta juvicha Jesús re uyandareco oĩ vae jare jae ndive ñugüɨnoi vae reta uecha yave quirãi ɨvɨ ucãta jare opaete uyeyapo vae, uquɨye ete jare jei: —Añeteñoi yepe, cua cuimbae co jae Tumpa Taɨ. ");
INSERT INTO gnwNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Jare jeta cuña reta umae ñugüɨnoi mbɨrɨ güi. Cua cuña reta yugüeru Jesús ndive Galilea güi uyeyocui vaerã chupe. ");
INSERT INTO gnwNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Cua reta ipɨte pe ñugüɨnoi María Magdalena, jare Jacobo jare José ichɨ María jee vae, jare Zebedeo taɨ reta ichɨ. ");
INSERT INTO gnwNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Jare guarasɨ uique ma yave, penti cuimbae icocatu vae tenta guasu Arimatea pegua José jee vae - jae vi co penti Jesús jemimboe - ");
INSERT INTO gnwNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","oo Pilato pe, jare uyerure chupe Jesús jetecue re. Jayave Pilato oyocui uñemee vaerã chupe Jesús jetecue. ");
INSERT INTO gnwNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Jayave José umbɨgüeyɨ Jesús jetecue, jare oñoma penti nieso iquɨa mbae vae pe. ");
INSERT INTO gnwNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Jayave oñono penti teõgüerɨru ipɨau vae itape uyeyoo vae pe, (José imbae co jocua teõgüerɨru) jare umbɨyapayere ita tuicha vae teõgüerɨru jonque re. Jayave José oo ye teõgüerɨru güi. ");
INSERT INTO gnwNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Jare María Magdalena jare ĩru cuña María jee vae uguapɨ ñugüɨnoi teõgüerɨru jovai. ");
INSERT INTO gnwNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Jare jocua ara opaete judío reta uyeyapɨcatu ñugüɨnoi pɨareve peguarã. Jayave pɨareve pe sacerdote reta itenondegua reta jare fariseo reta yugüɨraa Pilato pe, ");
INSERT INTO gnwNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","jare jei chupe: —Oreruvicha, oremandúa ma quirãi jocua cuimbae upurumbɨtavɨse vae ndei umano mbove jei mbapɨ ara rupi icove yeta ou umanocue vae reta ipɨte güi. ");
INSERT INTO gnwNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Iyocui ndesundaro reta uyandareco vaerã teõgüerɨru re mbapɨ ara pegua, agüɨye vaerã jemimboe reta yugüɨraa joco pe pɨ̃tu yave oñomi vaerã jetecue. Echa'ã jucuarãi yave, jeita reta opaete vae pe icove ye ma co ou umanocue vae reta ipɨte güi. Jare jucuarãi yave, jae reta umbɨtavɨta jeta Jesús umbɨtavɨ vae reta güi —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Jayave Pilato jei chupe reta: —Joco pe penoi chesundaro reta. Pecua pembɨyandarecoca cavi jese pepuere rupi —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Jayave jae reta yugüɨraa jare uyuquenda cavi teõgüerɨru jonque. Echa'ã oñono mbae ita tuicha vae re agüɨye vaerã quía uipea, jare ueya joco pe sundaro reta uyandareco vaerã teõgüerɨru re. ");
INSERT INTO gnwNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Mbutuu ara uasa ma yave, neimbove asɨ domingo ara pe María Magdalena jare ĩru cuña María jee vae yugüɨraa teõgüerɨru cotɨ. ");
INSERT INTO gnwNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Jare ɨvɨ tanta ucãta. Echa'ã penti ángel yandeYa pe uyeyocui vae ugüeyɨ ara güi jare umbɨsɨrɨ ita tuicha vae teõgüerɨru jonque güi. Jayave ángel uguapɨ oĩ ita re. ");
INSERT INTO gnwNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Jare jova uyecuaa ama uvera vae rami. Jare jemimonde tĩ asɨ roɨ tĩ asɨ vae rami. ");
INSERT INTO gnwNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Jare teõgüerɨru re uyandareco ñugüɨnoi vae reta urɨrɨ uquɨye ramo, jare umano vae echa upɨta reta. ");
INSERT INTO gnwNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Jayave ángel jei cuña reta pe: —Agüɨye pequɨye. Echa'ã aicuaa peeca peĩ Jesús curusu re uyecutuca vae. ");
INSERT INTO gnwNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Mbaetɨ ma cua pe oĩ. Icove ye ma ou umanocue vae reta ipɨte güi, jae jei rami. Peyu pemae jendacue re —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Jare pecua voi pere jemimboe reta pe: ‘Jae icove ye ma ou umanocue vae reta ipɨte güi. Jae oota perenonde Galilea pe. Joco pe peechata.’ Amɨmbeu ma co peve —jei chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Jayave cuña reta oẽ voi teõgüerɨru güi. Uquɨye reta jare uyerovia tuicha reta. Jare osi yugüɨraa umɨmbeu vaerã Jesús jemimboe reta pe. ");
INSERT INTO gnwNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Jare Jesús uñeovãiti jae reta ndive jare jei chupe reta: —Piyerovia catu. Jayave cuña reta uyeatɨca ɨvɨ pe uicuãva ipɨ rupi jare umbɨadora. ");
INSERT INTO gnwNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jayave Jesús jei chupe reta: —Agüɨye pequɨye. Pecua pemɨmbeu cherɨvɨ reta pe yugüɨraa vaerã Galilea pe. Joco pe cherechata —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Jare cuña reta yugüɨraa ye rambueve teõgüerɨru güi, amocue sundaro tenonde yave teõgüerɨru re uyandareco vae reta yugüɨraa vi tenta guasu pe, jare umɨmbeu sacerdote reta itenondegua reta pe opaete uyeyapo vae re. ");
INSERT INTO gnwNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Jare sacerdote reta itenondegua reta uyembatɨ tenta guasu pegua reta itenondegua reta ndive. Jare uyemboemboe ma yave, umee jeta corepoti sundaro reta pe. ");
INSERT INTO gnwNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Jare jei chupe reta: —Pere: ‘Jesús jemimboe reta yugüɨraa teõgüerɨru pe pɨ̃tu yave, jare oñomi Jesús jetecue ore ndoque noĩ rambueve’ —pere, jei reta—. ");
INSERT INTO gnwNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Jare mburuvicha guasu cua uicuaa yave, numɨmbeuta chupe pe reta mbaetɨ co teco penoi —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Jayave sundaro reta uipɨsɨ corepoti jare uyapo sacerdote reta itenondegua reta jare tenta guasu pegua reta itenondegua reta jei chupe reta uyapo vaerã vae. Jare jecuaeño opaete judío reta jei jucuarãi co uyeyapo. ");
INSERT INTO gnwNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Jayave jocua once Jesús jemimboe reta yugüɨraa Galilea pe penti ɨvɨtu guasu re Jesús umɨmbeu chupe reta vae rami. ");
INSERT INTO gnwNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Jare jemimboe reta uecha yave Jesús, umbɨadora. Ẽrei amocue vae ipuere'ã güɨrovia jae co Jesús vae. ");
INSERT INTO gnwNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jare Jesús ou jei chupe reta: —Opaete mbaepuere uñemee ma cheve ara pe jare ɨvɨ pe. ");
INSERT INTO gnwNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Jáeramo pecua peporomboe opaete que rupi rupi jare pembɨbautiza cheRu jee re jare cheree re jare Espíritu Santo jee re —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Jare pemboe reta opaete che poyocui vae re. Jare che aĩta pe reta ndive jaeño mai pegua cua ara reta opa regua —jei.");
INSERT INTO gnwNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Añave aicuatía aĩ ñee icavi vae Jesucristo regua. Jesucristo co jae Tumpa Taɨ. ");
INSERT INTO gnwNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Isaías co jae penti Tumpa iñee aracae umɨmbeu vae. Jae uicuatía cuarãi: “Mase” —jei Tumpa—, “che amondota chiñee güɨraa vae nderenonde, uyapɨcatu vaerã nderaperã. ");
INSERT INTO gnwNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Jae iñeeãta reve jeita ñana pe: ‘Piyapɨcatu yandeYa japerã. Pemɨsɨmi tape’” —jeita, jei Tumpa. Jucuarãi uicuatía Isaías. ");
INSERT INTO gnwNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Jáeramo Juan ou upurumbɨbautiza ñana pe, jare umɨmbeu yatɨ ñugüɨnoi vae reta pe: —Peeya piyemɨngueta icavi mbae vae pepɨa pe oĩ vae, jare che pumbɨbautizata, Tumpa umbɨasa vaerã peve pembaeyoa reta —jei chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Jare jeta ɨvɨ Judea pegua reta jare tenta guasu Jerusalén pegua reta yugüɨraa Juan oĩ vae pe. Jare Juan umbɨbautiza reta ɨãca Jordán jee vae pe, imbaeyoa reta opa umɨmbeu yave. ");
INSERT INTO gnwNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jare Juan jemimonde maemɨmba camello jee vae jaagüe pegua co, jare jumbɨcuaa guacapi pegua co. Jare jembíu co jae tucu jare ei ñana rupigua. ");
INSERT INTO gnwNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Jae umɨmbeu yatɨ vae reta pe: —Cheraɨcue rupi outa ipuere ete chegüi vae. Jupi'ã co che chepe ayora vaerã ipɨpasa ichã. ");
INSERT INTO gnwNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Che pumbɨbautiza ɨ pe, ẽrei jae pembɨbautizata Espíritu Santo pe —jei chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Jare mbovɨ ara rupi ou Jesús tenta guasu Nazaret ɨvɨ Galilea pegua güi. Jare Juan umbɨbautiza Jesús ɨãca Jordán pe. ");
INSERT INTO gnwNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Jare Jesús oẽ ye ɨ güi yave, uecha ara uyepea oĩ, jare uecha vi Espíritu Santo ugüeyɨ jese pɨcasu rami. ");
INSERT INTO gnwNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Jayave uyendu ñee ara güi jei: —Nde co jae cheRaɨ nduau ete vae. Chembɨyerovia ete —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Jayave Espíritu Santo omondo Jesús ñana pe. ");
INSERT INTO gnwNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Jare upɨta ñana pe cuarenta ara, jare Satanás umɨngueta uyavɨca vaerã tẽi chupe. Jare ico Jesús maemɨmba ñana rupigua reta ñugüɨnoi vae pe. Jare yugüeru ángel reta omborɨ vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Juan uyemɨingueca ma peresorɨru pe yave, oo Jesús Galilea pe, jare umɨmbeu ñee icavi vae Tumpa iporoyocuia regua. ");
INSERT INTO gnwNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Jesús jei: —Ara uvãe ma. Outa uvãe Tumpa iporoyocuia. Peeya piyemɨngueta icavi mbae vae pepɨa pe oĩ vae, jare perovia Tumpa iñee icavi vae —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jare uguata rambueve ɨ guasu Galilea jembeɨ rupi, Jesús uecha Simón jare Simón tɨvɨ Andrés jee vae. Jae reta omombo ñugüɨnoi pɨsa ɨ guasu pe, pira uipɨsɨ vaerã. Echa'ã jae reta pira uipɨsɨ vae reta co. ");
INSERT INTO gnwNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jayave Jesús jei chupe reta: —Peyu cherupíe, jare che chembaepuere pe pemboeta ĩru vae reta güɨrovia vaerã cheré —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Jayave ueya reta ipɨsa, jare yugüɨraa jae jupíe. ");
INSERT INTO gnwNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ndei mbɨrɨ oo mbove, Jesús uecha Zebedeo taɨ reta. Penti jee Jacobo, jare tɨvɨ jee Juan. Uyapɨcatu ñugüɨnoi pɨsa reta chalana pe. ");
INSERT INTO gnwNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jare Jesús ueni voi. Jayave jae reta ueya tu chalana pe uparavɨquɨ chupe vae reta ndive, jare yugüɨraa Jesús jupíe. ");
INSERT INTO gnwNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jare yugüɨraa uvãe tenta guasu Capernaum pe. Jare mbutuu ara pe Jesús uique judío reta itupao pe, jare joco pe oporomboe. ");
INSERT INTO gnwNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Jare uyapɨsaca jese vae reta ipɨacañɨ iporomboe re. Echa'ã omboe reta mbaepuere güɨnoi vae rami. Jucuarãi'ã oporomboe mboroyocui re oporomboe vae reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Jare uique oo tupao pe cuimbae aña oya jese vae. Jae iñeeãta reve jei: ");
INSERT INTO gnwNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—¿Maera pa ndeyu oremambeco, Jesús Nazaret pegua? ¿Ndeyu pa oremɨcañɨtei vaerã? Che nducuaa. Nde co jae Tumpa Taɨ —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jayave Jesús uñeengata aña pe. —¡Nequĩi! Esɨrɨ chugüi —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Jayave aña umbɨrɨrɨ ete jocua cuimbae, jare tanta jãse reve usɨrɨ chugüi. ");
INSERT INTO gnwNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Jare opaete uecha vae reta ipɨacañɨ, jare upɨrandu uyupe: —¿Mbae pa co cua uyapo vae? ¡Moromboe ipɨau vae ndipo! Mbaepuere pe oyocui aña reta usɨrɨ vaerã oya jese vae reta güi, jare jae reta uyapo oyocui vae —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Jayave ɨmambaeño jerãcua jesegua opaete Galilea rupi. ");
INSERT INTO gnwNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jare Jesús judío reta itupao güi oẽ ye yave, oo Simón jare Andrés jenta pe Jacobo jare Juan ndive. ");
INSERT INTO gnwNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simón jaicho jacu oĩ jupa pe. Jare ĩru reta umɨmbeu Jesús pe jesegua. ");
INSERT INTO gnwNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jayave Jesús oo uipɨsɨ ipo pe, jare umupũa. Jare jacu upɨta voi chugüi. Jayave jocua cuña umee mbae jou reta vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Jare guarasɨ uique ma yave, tenta guasu pegua reta güeru Jesús pe imbaerasɨ vae reta jare aña oya jese vae reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Jare jeta joco pegua reta uyembatɨ jocua tenta jonque pe. ");
INSERT INTO gnwNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jayave Jesús umbɨgüera jeta imbaerasɨ vae reta ipotave mbaerasɨ güi, jare umbɨsɨrɨ jeta aña reta oya jese vae reta güi. Jare umaeño'ã aña reta re uyemɨngueta vaerã. Echa'ã jae reta uicuaa quía co jae. ");
INSERT INTO gnwNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Pɨareve pe Jesús upũa ndei cõe mbove, jare oẽ oo quĩi ngatu vae pe. Joco pe uyerure oĩ Tumpa pe. ");
INSERT INTO gnwNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Jayave Simón jare jae ndive ñugüɨnoi vae reta yugüɨraa ueca. ");
INSERT INTO gnwNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Jare uvãe chupe yave, jei reta Jesús pe: —Ndereca ñugüɨnoi reta —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jayave Jesús jei chupe reta: —Yaa ĩru tenta guasu-raɨ reta coiño ñugüɨnoi vae pe, joco pe vi amɨmbeu vaerã Tumpa iñee. Echa'ã ayu cua ayapo vaerã —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Jare oo opaete ɨvɨ Galilea rupi, jare umɨmbeu Tumpa iñee judío reta itupaopao rupi, jare umbɨsɨrɨ aña reta oya jese vae reta güi. ");
INSERT INTO gnwNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Jayave ou Jesús oĩ vae pe penti cuimbae ipire ocui vae. Uyeatɨca Jesús jovai jare uyerure chupe: —Ndipota yave, ndepuere chembɨgüera —jei chupe. ");
INSERT INTO gnwNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesús uiparareco umae jese, jare oñono ipo jese. —Aipota. Ecuera —jei chupe. ");
INSERT INTO gnwNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Jare jupivoiño cuimbae ucuera imbaerasɨ güi. Ocui'ã ma ipire. ");
INSERT INTO gnwNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jare jupivoiño Jesús oyocui ete, ndei omondo mbove: ");
INSERT INTO gnwNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Agüɨye emɨmbeu quía pe. Ecua iyeechaca sacerdote pe, jare emee ofrenda Moisés peocui rami, tenta guasu pegua reta uicuaa vaerã ndecuera ma co —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ẽrei cuimbae oo, jare umbɨpɨ umɨmbeu ĩru vae reta pe. Jecuae umɨmbeu jeta vae pe. Jáeramo Jesús ipuere'ã ma oo tenta guasu reta pe joco pegua reta jovaque. Upɨta ñana rupi, jare yugüeru jae oĩ vae pe opaete que rupi rupi güi. ");
INSERT INTO gnwNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Mbovɨ ara rupi Jesús oo ye Capernaum pe, jare jerãcua jae ime oĩ jenta pe. ");
INSERT INTO gnwNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Jayave jeta vae uyembatɨ joco pe, jare tɨnee ñugüɨnoi o pe jare onque rupi. Jare Jesús umɨmbeu Tumpa iñee chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Jayave amocue yugüeru vae reta güeru penti cuimbae imbaerasɨ vae. Cua cuimbae ipuere mbae omɨ vae. Uyerevoɨca ou irundɨ cuimbae reta pe. ");
INSERT INTO gnwNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ẽrei güeru vae reta ipuere'ã uruique jocua cuimbae Jesús oĩ vae pe, uyembɨape'ã ye ñugüɨnoi reta ramo. Jáeramo uruyupi o iárambo jare uipea chupe Jesús jese catu. Joco pe umbɨgüeyɨ jocua cuimbae ipuere mbae omɨ vae jupa reve. ");
INSERT INTO gnwNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jesús cua uecha yave, uicuaa jae reta güɨrovia co jese, jare jei cuimbae ipuere mbae omɨ vae pe: —Nembaeyoa reta uyembai ma, cherɨvɨ. ");
INSERT INTO gnwNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Amocue mboroyocui re oporomboe vae reta uguapɨ ñugüɨnoi joco pe, jare ipɨa pe uyemɨngueta reta: ");
INSERT INTO gnwNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Maera pa jei cuarãi cua cuimbae? Jei icavi mbae vae Tumpa cotɨ. Tumpaño co ipuere umbɨasa quía pe imbaeyoa reta.” Jucuarãi ipɨa pe uyemɨngueta reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jare Jesús uicuaa voi jae reta ipɨayemɨngueta, jare jei chupe reta: —¿Maera pa pepɨa pe piyemɨngueta jucuarãi? ");
INSERT INTO gnwNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Chepuere jae cua cuimbae ipuere mbae omɨ vae pe: ‘Nembaeyoa reta uyembai ma.’ Jae ramiño vi chepuere jae chupe: ‘Epũa evoɨ nderupa, jare eguata.’ ¿Mbae nunga pa yavai jae vaerã? —jei Jesús chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ẽrei aipota picuaa vaerã cua: Che cuimbaerã ayeyapo vae chepuere ambɨasa quía pe imbaeyoa reta cua ɨvɨ pe aĩ rambueve —jei. Jayave jei cuimbae ipuere mbae omɨ vae pe: ");
INSERT INTO gnwNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Che jae ndeve: Epũa evoɨ nderupa, jare ecua nerenta pe. ");
INSERT INTO gnwNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Jayave cuimbae upũa, jare ovoɨ jupa, jare oẽ voi oo opaete joco pe ñugüɨnoi vae reta jovaque. Opareve ipɨacañɨ, jare umbɨadora reta Tumpa. —Yaecha'ãi cua nunga —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jayave Jesús oo ye ɨ guasu jembeɨ pe. Jare jeta vae reta uyembatɨ jae oĩ vae pe, jare jae omboe reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Jare joco güi oo yave, uecha Alfeo taɨ Leví jee vae uguapɨ oĩ mburuvicha peguarã ocovara ñugüɨnoi vae pe, jare jei chupe: —Eyu cherupíe. Jayave Leví upũa, jare oo jae jupíe. ");
INSERT INTO gnwNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Jare Jesús ucaru oĩ rambueve Leví jenta pe, jeta mburuvicha peguarã ocovara vae reta jare teco icavi mbae vae uyapo vae reta ucaru vi ñugüɨnoi Jesús jare jemimboe reta ndive. Echa'ã jecuaeño jeta jae reta yugüɨraa Jesús ndive. ");
INSERT INTO gnwNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Jayave mboroyocui re oporomboe vae reta jare fariseo reta uecha yave Jesús ucaru oĩ ocovara vae reta jare teco icavi mbae vae uyapo vae reta ndive, jei jemimboe reta pe: —¿Maera pa ucaru pemboe vae ocovara vae reta jare teco icavi mbae vae uyapo vae reta ndive? ");
INSERT INTO gnwNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jesús cua uyandu yave, jei chupe reta: —Icove catu vae reta ueca'ã upurupɨano vae. Imbaerasɨ vae retaño ueca. Che ayu aeca vaerã iyoa vae reta. Ayu'ã aeca vaerã jupi vae reta —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Jare Juan jemimboe reta jare fariseo jemimboe reta uyecuacu ñugüɨnoi tembíu güi. Jayave amocue vae yugüeru, jare upɨrandu Jesús pe: —¿Maera pa Juan jemimboe reta jare fariseo jemimboe reta uyecuacu tembíu güi, ẽrei nderemimboe reta uyecuacu'ã chugüi? ");
INSERT INTO gnwNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jayave Jesús jei chupe reta: —Umendata vae pe ñugüɨnoi vae reta ndarau etei uyecuacu tembíu güi, umendata vae jae reta ndive oĩ rambueve. Echa'ã umendata vae jae reta ndive oĩ rambueve, uyecuacu'ã tembíu güi. ");
INSERT INTO gnwNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ẽrei outa uvãe ara umendata vae uyereraaca vaerã chugüi reta. Jayave ramo uyecuacuta tembíu güi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Icavi'ã yamboya vaerã temimonde indechi vae maemboyaa ipɨau vae pe. Echa'ã jucuarãi yayapo yave, maemboyaa ipɨau vae umɨãta temimonde indechi vae, jare temimonde jeiete osoro —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Jae ramiño vi icavi'ã yambɨru vaerã vino ipɨau vae vino jɨru guacapi indechi vae pe. Echa'ã jucuarãi yayapo yave, vino omondoro jɨru, jare vino uyepɨyere, jare jɨru icavi'ã ma. Jáeramo yambɨru vino ipɨau vae jɨru ipɨau vae pe —jei chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Mbutuu ara pe Jesús oo co rupi jemimboe reta ndive. Uasa rambueve, jemimboe reta uipoo trigo. ");
INSERT INTO gnwNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Jayave fariseo reta jei Jesús pe: —Mase, ¿maera pa uyapo reta agüɨyeta tẽi uyapo mbutuu ara pe vae? ");
INSERT INTO gnwNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jesús jei chupe reta: —¿Pemɨngueta'ã pa David uyapocue vae regua, jae jare jae ndive ñugüɨnoi vae reta mbaetɨ ma mbae güɨnoi yave jare iyembaɨ reta? —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","David uique Tumpa jo pe, sacerdote tenondegua Abiatar jee vae ico yave, jare jou mbɨyape Tumpa jo pe uñeñono tee vae reta. Agüɨyeta tẽi co quía jou jocua mbɨyape, jaeño sacerdote reta. Jare David umee vi jae ndive ñugüɨnoi vae reta pe —jei chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jayave Jesús jei chupe reta: —Mbutuu ara uyeyapo yanemborɨ vaerã. Yande yayeyapo'ã mbutuu ara peguarã. ");
INSERT INTO gnwNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Jáeramo che cuimbaerã ayeyapo vae chepuere jae mbae icavi uyeyapo vaerã mbutuu ara pe —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jesús uique ye judío reta itupao pe, jare joco pe oĩ penti cuimbae ipo jovaicho tɨpa vae. ");
INSERT INTO gnwNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Jare joco pe ñugüɨnoi vae reta umae ngatu Jesús re, uecha vaerã umbɨgüerata ra quía mbutuu ara pe. Echa'ã jae reta uipota tẽi umbɨjeco Jesús. ");
INSERT INTO gnwNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jayave Jesús jei cuimbae ipo jovaicho tɨpa vae pe: —Epũa eyu iyemboɨ cua reta jovai. ");
INSERT INTO gnwNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Jare Jesús upɨrandu joco pe ñugüɨnoi vae reta pe: —¿Yayapota pa icavi vae ani icavi mbae vae mbutuu ara pe? ¿Icavi pa yapuruepɨ ani yapuruyuca vaerã mbutuu ara pe? ¿Mbae pa jei mboroyocui cua re? —jei chupe reta. Ẽrei jae reta jei'ã mbae ave. ");
INSERT INTO gnwNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Pochɨ reve Jesús umae iyɨpɨ rupi ñugüɨnoi vae reta re, jare tuicha ipɨatɨtɨ jae reta ipɨatanta ramo. —Eupi ndepo —jei cuimbae pe. Jayave cuimbae ipo uupi, jare ucuera voi. ");
INSERT INTO gnwNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Jayave fariseo reta oẽ judío reta itupao güi, jare uyemboemboe voi herodiano reta ndive Jesús re, quirãita ra uyucaca vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Jayave Jesús jare jemimboe reta yugüɨraa ɨ guasu pe, jare yugüɨraa vi jaɨcue jeta Galilea güi. Jare yugüeru vi jae oĩ vae pe jeta Judea pegua reta, Jerusalén pegua reta, ɨvɨ Idumea pegua reta, Jordán jovaicho pegua reta, jare tenta guasu Tiro jare Sidón iyɨpɨ rupigua reta, uyandu yave opaete Jesús uyapo vae regua. ");
INSERT INTO gnwNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Jare Jesús oyocui jemimboe reta umɨcuatɨ̃ro chalana jae oĩ vaerã pɨpe, agüɨye vaerã oyopɨ yatɨ vae reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Echa'ã jae umbɨgüera ma jeta vae, jare opaete ĩru imbaerasɨ vae reta uñemɨañamɨaña yugüeru icotɨ. Echa'ã uipota oya jese, uyavɨquɨ vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Jare aña reta uecha Jesús yave, uyeatɨca jae jovai jare iñeeãta reve jei: —Nde co jae Tumpa Taɨ. ");
INSERT INTO gnwNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Jare Jesús oyocui ete: —Agüɨye pemɨmbeu quía co che. ");
INSERT INTO gnwNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jayave Jesús oo ɨvɨtu guasu re, jare ueni jae uiparavo vae retaño. Jare jae reta yugüeru jae oĩ vae pe. ");
INSERT INTO gnwNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Jare jocua reta güi uiparavo doce cuimbae reta umɨĩru vaerã. Jae omondota reta umɨmbeu vaerã Tumpa iñee. ");
INSERT INTO gnwNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Umeeta vi chupe reta mbaepuere umbɨgüera vaerã imbaerasɨ vae reta jare umbɨsɨrɨ vaerã aña reta oya jese vae reta güi. ");
INSERT INTO gnwNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Cua co jae uiparavo vae reta jee: Simón (Jesús umbɨjee Pedro), ");
INSERT INTO gnwNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","jare Zebedeo taɨ reta Jacobo jare Juan jee vae (Jesús umbɨjee cua mocui reve Boanerges. Cua jee uipota jei: “Ara jɨapu vae rami”), ");
INSERT INTO gnwNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","jare Andrés, Felipe, Bartolomé, Mateo, Tomás, Alfeo taɨ Jacobo jee vae, Tadeo, Simón (jae co Zelote pe ueni vae), ");
INSERT INTO gnwNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","jare Judas Iscariote (cua cuimbae umee Jesús jovaicho reta pe). Jayave Jesús ou ye jenta pe jae reta ndive. ");
INSERT INTO gnwNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Jare uyembatɨ ye jeta vae. Jáeramo Jesús jare jemimboe reta iquĩi'ã ucaru vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Jesús jentarã reta cua uicuaa yave, yugüeru güɨraa vaerã tẽi. —Iyaracuaa'ã ma oĩ —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Jare mboroyocui re oporomboe vae yugüeru Jerusalén güi vae reta jei: —Aña guasu Beelzebú jee vae oya ma jese, jare aña guasu imbaepuere pe umbɨsɨrɨ aña reta oya jese vae reta güi —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jayave Jesús ueni reta, jare jei chupe reta umɨjaanga reve: —Ndarau Satanás jaei uyembɨsɨrɨ cuimbae güi. ");
INSERT INTO gnwNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Penti tenta guasu pegua reta oyovaicho uyupii yave, opata co jocua tenta guasu. ");
INSERT INTO gnwNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Jae ramiño vi penti tenta pegua reta oyovaicho uyupii yave, opata co jocua tenta. ");
INSERT INTO gnwNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Jare Satanás pochɨ iyupe yave, jare imbaepuere uyembɨyao yave, ndarau tẽi ma ico. Opata tẽi co —jei chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ime yave quía uipota uique cuimbae ipɨrãta vae jenta pe upɨ̃ro vaerã imbaembae chugüi vae, uipocuata rani cuimbae ipɨrãta vae. Jayave ramo ipuereta upɨ̃ro imbaembae chugüi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Añete che jae peve, opaete ɨvɨ pegua reta imbaeyoa reta jare opaete iñee icavi mbae Tumpa cotɨ jei reta vae Tumpa ipuere umbai. ");
INSERT INTO gnwNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ẽrei Tumpa ndarau etei umbɨasa jei icavi mbae vae Espíritu Santo cotɨ vae pe. Uyembɨjecota jaeño mai pegua —jei chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Echa'ã tenonde yave jae reta jei: —Aña oya ma jese. Jáeramo Jesús jei jucuarãi chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Jayave Jesús ichɨ jare tɨvɨ reta yugüeru uvãe Jesús oĩ vae pe, jare oca güi omondo uenica. ");
INSERT INTO gnwNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Jare uguapɨ ñugüɨnoi iyɨpɨ rupi vae reta jei chupe: —¡Aipo! Ndesɨ jare nderɨvɨ reta oca pe ñugüɨnoi, jare ndereca. ");
INSERT INTO gnwNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","—¿Quía nunga pa co jae chesɨ jare cherɨvɨ reta? —jei Jesús chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Jayave umae iyɨpɨ rupi uguapɨ ñugüɨnoi vae reta re. —Cua nunga reta co jae chesɨ jare cherɨvɨ reta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Echa'ã Tumpa jei vae uyapo vae reta co jae cherɨvɨ jare cherindɨ jare chesɨ —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jesús umbɨpɨ ye oporomboe ɨ guasu jembeɨ pe. Jayave jeta yugüeru uyembatɨ jae oĩ vae pe. Jáeramo Jesús uyupi penti chalana ɨ guasu pe oĩ vae pe, jare uguapɨ pɨpe. Jare yatɨ vae reta ñugüɨnoi ɨ guasu jembeɨ pe. ");
INSERT INTO gnwNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Jare Jesús omboe reta jeta mbaembae re umɨjaanga reve. Jei chupe reta: ");
INSERT INTO gnwNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Piyapɨsaca cheré. Penti cuimbae oo umaetɨ vaerã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Umaetɨ yave, umɨai temitɨ, jare amocue oa tape rupi. Jayave yugüeru güɨra reta opa jou —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ĩru temitɨ oa mbovɨño ɨvɨ itape iárambo oĩ vae pe. Cua ɨmambae oẽ, jeta'ã ɨvɨ chupe ramo. ");
INSERT INTO gnwNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ẽrei guarasɨ jasɨ yave, ipiru. Jare japo quɨpe'ã oĩ ramo, utini —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ĩru temitɨ oa ñanapɨte pe. Ñana ucuacuaa yave, opa uyuca temitɨ. Jáeramo temitɨ ia'ã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Jare ĩru temitɨ oa ɨvɨcavi pe. Cua reta oẽ, jare ucuacuaa, jare ía. Amocue mbovɨño jãɨ, jare ĩru jeta catu jãɨ, jare ĩru jeta ete jãɨ —jei chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Jayave Jesús jei chupe reta: —Uipota uyandu vae tuyapɨsaca cua ñee re. ");
INSERT INTO gnwNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Mbovɨño ma upɨta jae ndive yave, jocua doce uiparavo vae reta jare ĩru upɨta vae reta upɨrandu Jesús pe umɨjaanga reve jei vae re. ");
INSERT INTO gnwNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jayave Jesús jei chupe reta: —Amɨmbeu ma peve Tumpa iporoyocuia regua. Cua uyecuaa'ã ĩru vae reta pe. Jáeramo amboe ĩru vae reta amɨjaanga reve —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Cua ayapo agüɨye vaerã uicuaa cavi, yepe tẽi uecha, jare agüɨye vaerã uicuaa, yepe tẽi uyandu, jare agüɨye vaerã uyerova Tumpa cotɨ, imbaeyoa reta uyembai vaerã —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jayave Jesús jei chupe reta: —¿Picuaa'ã pa mbae cua amɨjaanga reve jae peve vae uipota jei vae? Picuaa'ã yave, ¿quirãita pa picuaa mbae opaete amɨjaanga reve jaeta peve vae uipota jei vae? —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Jocua umaetɨ vae uyemɨjaanga Tumpa iñee umɨmbeu vae re —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Temitɨ tape rupi oa vae uyemɨjaanga amocue Tumpa iñee uyandu vae re. Ẽrei jupivoiño ou Satanás, jare umɨacañɨ Tumpa iñee güi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Jae ramiño vi jocua temitɨ uñeñotɨ mbovɨño ɨvɨ itape iárambo oĩ vae pe vae uyemɨjaanga ĩru vae reta Tumpa iñee uyandu vae re. Jupivoiño uyerovia reta, jare uipota ete cua ñee. ");
INSERT INTO gnwNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ẽrei cua reta jocua temitɨ japo quɨpe'ã oĩ vae rami co. Jáeramo ɨmambae icueri reta. Mbaesusere uyeyapo chupe reta ani ĩru vae reta uyapo icavi mbae vae chupe reta Tumpa iñee uicuaa ramo. Jare jupivoiño uipota'ã ma uyapɨsaca reta Tumpa iñee re —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Jae ramiño vi jocua temitɨ uñeñotɨ ñanapɨte pe vae uyemɨjaanga ĩru vae reta Tumpa iñee uyandu vae re. ");
INSERT INTO gnwNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Ẽrei jae reta umbɨpɨ uyemɨpɨa'ã ɨvɨ pe mbaembae uyeyapo vae re, jare uyembɨtavɨ, uipota icocatu ramo. Uipota vi güɨnoi jeta mbaembae. Jare opaete cua umɨacañɨ reta Tumpa iñee güi. Jáeramo jae reta jocua temitɨ ia'ã vae rami co —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ẽrei jocua temitɨ uñeñotɨ ɨvɨcavi pe vae uyemɨjaanga ĩru vae reta Tumpa iñee uyandu vae re. Cua reta güɨrovia. Amocue vae jocua temitɨ mbovɨño jãɨ vae rami co. Ĩru vae reta jocua temitɨ jeta catu jãɨ vae rami co. Jare ĩru vae reta jocua temitɨ jeta ete jãɨ vae rami co —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jayave Jesús jei chupe reta: —Mechero yaruique yave o pe, ndarau ñañono yapepo uyembovapo oĩ vae igüɨ pe, ani güɨrapembɨ igüɨ pe. Ñañono co mechero jenda pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ime yave mbae uñeñomi vae, uyeechacañotai co. Jae ramiño vi ime yave mbae uyeyasoi vae, uyecuaañotai co —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Uipota uyandu vae tuyapɨsaca cua ñee re —jei Jesús. ");
INSERT INTO gnwNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Jare jei chupe reta: —Pepɨa pe piyemɨngueta cavi piyandu vae re. Tumpa umɨaangata umee peve pemɨaanga pemee ĩru vae reta pe rami, jare umɨĩruta vi peve —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Echa'ã güɨnoi vae pe uñemɨĩruta, jare mbaetɨ güɨnoi vae güi mbovɨ ete güɨnoi vae uyeequita —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jare Jesús jei chupe reta: —Tumpa iporoyocuia penti cuimbae oo umaetɨ vae rami co —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Cuimbae oque pɨ̃tu yave, jare upũa cõe yave. Temitɨ oẽ jare ucuacuaa, jare umaetɨ vae uicuaa'ã quirãi ra ucuacuaa vae. ");
INSERT INTO gnwNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Echa'ã temitɨ ucuacuaa yamborɨ mbae reve, tenonde iɨ, jayave avatiquɨ, joco güi avati —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Jare yagüɨye ma yave, iya uavɨro. Echa'ã uvãe ma ara uavɨro vaerã —jei chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jare Jesús jei: —¿Mbae ra ipuere uyemɨjaanga Tumpa iporoyocuia re? ¿Mbae ra yamɨjaangata jese? —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Yandepuere yamɨjaanga jese penti mostaza jãɨcue —jei—. Uñeñotɨ yave, cua jãɨcue michi-raɨ ete opaete ĩru temitɨ reta jãɨcue ɨvɨ pe oĩ vae güi. ");
INSERT INTO gnwNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ẽrei uñeñotɨ yave, ucuacuaa, jare tuicha ete opaete ĩru temitɨ penti año peguaño ucuacuaa vae reta güi, jare tuicha jãca uyeyapo. Jáeramo güɨra reta ipuere uyapo jaitɨrã jese guarasɨ̃a pe —jei chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jeta cuarãi Jesús umɨmbeu Tumpa iñee chupe reta umɨjaanga reve, jae reta ipuere uicuaa rupiño. ");
INSERT INTO gnwNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Jare jecuaeño imiari chupe reta umɨjaanga reve. Ẽrei jemimboe reta peño uicuaaca cavi mbae uipota jei vae. ");
INSERT INTO gnwNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Jocua ara guarasɨ uique ma yave, Jesús jei jemimboe reta pe: —Yaa ɨ guasu jovaicho pe —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Jayave jae reta ueya yatɨ vae reta, jare güɨraa Jesús jocua chalana oĩ pɨpe vae pe. Jare ĩru vae reta yugüɨraa vi ambɨe chalana reta pɨpe. ");
INSERT INTO gnwNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Jare ou ɨvɨtu tanta uyepeyu, jare ɨ uyembɨaparoaroa uique chalana pe, jare umɨtɨnee seri ma. ");
INSERT INTO gnwNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jare Jesús uñemɨãcanɨta chalana iyapɨ pe, jare oque oĩ. Jayave jae reta omomba jare jei chupe: —¡Oporomboe vae! ¿Ndepɨa'ã pa opata ma ñamano? ");
INSERT INTO gnwNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jayave Jesús upũa, jare uñeengata ɨvɨtu pe. —¡Epɨta! ¡Nequĩi! —jei ɨ guasu pe. Jare ɨvɨtu javoi upɨta, jare opaete quĩi ngatu. ");
INSERT INTO gnwNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Jayave Jesús upɨrandu chupe reta: —¿Maera pa pequɨye? ¿Ndeiño pa pepurugüɨrovia? —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Jare uquɨye ete reta, jare jei uyupe: —¿Mbae nunga cuimbae pa cua? Ɨvɨtu jare ɨ guasu uyapo jae oyocui vae —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jayave yugüɨraa uvãe ɨ guasu jovaicho pe, gadareno reta iɨvɨ pe. ");
INSERT INTO gnwNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Jesús ugüeyɨ chalana güi rupive, ou oovãiti teõgüerɨrurenda güi penti cuimbae aña oya jese vae. ");
INSERT INTO gnwNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Jae ico teõgüerɨrurenda rupi, jare ipuere'ã ma quía uñapɨ̃ti, yepe tẽi uñapɨ̃ti cadena pe. ");
INSERT INTO gnwNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Jeta vese ma jae reta uipocua tẽi ipo jare ipɨ cadena pe. Ẽrei jae opa omondoo cadena reta. Jare ipuere'ã quía jese. ");
INSERT INTO gnwNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Jare jecuaeño pɨ̃tu rupi jare ara rupi oĩ teõgüerɨrurenda rupi jare ɨvɨtu guasu rupi, jare jecuae usapɨcai jare uyembɨpere ita pe. ");
INSERT INTO gnwNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Cua cuimbae uecha yave Jesús mbɨrɨ güi, osi ou icotɨ jare uyeatɨca jovai. ");
INSERT INTO gnwNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Jare iñeeãta reve jei: —¿Maera pa ndeyu chemambeco, Jesús? Nde co jae Tumpa ara pe oĩ vae Taɨ. Ayerure ndeve Tumpa jee re agüɨye iporaraca cheve —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Echa'ã Jesús jei aña pe: —Esɨrɨ cua cuimbae güi, aña. ");
INSERT INTO gnwNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jayave Jesús upɨrandu chupe: —¿Mbae pa nderee? —Cheree co jae jeta vae. Echa'ã jeta vae co ore —jei chupe. ");
INSERT INTO gnwNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Jare aña reta uyerure Jesús pe agüɨye vaerã umbɨsɨrɨ reta jocua ɨvɨ güi. ");
INSERT INTO gnwNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Jare joco pe jeta cuchi reta ucaru ñugüɨnoi coiño ɨvɨtu guasu güi. ");
INSERT INTO gnwNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Jayave aña reta uyerure Jesús pe: —Oremondo pea cuchi reta cotɨ. Emaeño oreré ndoya vaerã jese reta —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jayave Jesús umaeño jese reta. Jare aña reta usɨrɨ cuimbae güi, jare oya cuchi reta re. Jayave cuchi reta tanta osi ɨvɨa rupi oa ɨ guasu pe, jare joco pe opa ipɨtupa reta. Cuchi reta uyepapa dos mil rupi. ");
INSERT INTO gnwNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Jayave cuchi iyandarecoa reta opa osi, jare umɨmbeu tenta guasu pegua reta pe jare jocoropi ñugüɨnoi vae reta pe cua uyeyapo vae regua. Jare uyandu vae reta yugüeru, uecha vaerã mbae uyeyapo vae. ");
INSERT INTO gnwNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Jare yugüeru uvãe yave Jesús oĩ vae pe, uecha cuimbae aña oyase jese vae uguapɨ oĩ joco pe. Uecha uyemonde ma jare iyaracuaaño ma oĩ. Jae co tenonde yave jeta aña reta oyase jese vae. Jare opaete yugüeru vae reta uquɨye. ");
INSERT INTO gnwNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Jare jocua tenonde yave uecha vae reta umɨmbeu ĩru reta pe quirãi uyeyapo cuimbae aña oyase jese vae pe jare cuchi reta pe. ");
INSERT INTO gnwNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Jayave yatɨ vae reta umɨñera Jesús oo ye vaerã jae reta iɨvɨ güi. ");
INSERT INTO gnwNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jare Jesús uyupi ye ma oĩ yave chalana pe, jocua cuimbae aña reta oyase jese vae uyerure chupe: —Emaeño cheré aa vaerã nderupíe —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ẽrei Jesús umaeño'ã jese. —Ecua nerenta pe emɨmbeu nerentarã reta pe mbae icavi vae ndeYa uyapo ndeve vae, jare quirãi ndeparareco vae —jei chupe. ");
INSERT INTO gnwNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Jayave cuimbae oo, jare umbɨpɨ umɨmbeu ɨvɨ Decápolis jee vae rupi mbae icavi vae Jesús uyapo chupe vae. Jare opaete ipɨacañɨ jese. ");
INSERT INTO gnwNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jesús oo uvãe yave ɨ guasu jovaicho cotɨ chalana pɨpe, yugüeru jeta vae reta jae oĩ vae pe. Jare Jesús upɨta ɨ guasu jembeɨ pe. ");
INSERT INTO gnwNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Jayave ou penti cuimbae Jairo jee vae. Jae co judío reta itupao re uyandareco vae. Uecha yave Jesús, uyeatɨca jovai. ");
INSERT INTO gnwNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Jare uyerure chupe: —Cherayɨ umanota ma oĩ —jei—. Yaa iñono ndepo jese embɨgüera, agüɨye vaerã umano —jei chupe. ");
INSERT INTO gnwNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Jayave Jesús oo voi jupíe. Jare jeta yuguɨraa Jesús jupíe, jare oyopɨ reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Jare jae reta ipɨte pe oo penti cuña doce año ma uiporara tugüɨguasu vae. ");
INSERT INTO gnwNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Jare uiporara ma jeta upurupɨano vae reta uipɨano tẽi reve, jare opaete ma icorepoti umee iyugüi upurupɨano vae reta pe. Ẽrei ucuera'ã. Jeseve jeieteño ma imbaerasɨ. ");
INSERT INTO gnwNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Jae uyandu Jesús regua yave, oya Jesús re icupe cotɨ jeta vae reta ipɨte rupi, jare uyavɨquɨ jemimonde. ");
INSERT INTO gnwNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","—Yepe tẽi jemimondeño tayavɨquɨ, acuerata co —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Jare jupivoiño jugüɨguasu upɨta chugüi, jare uyandu jete ucuera ma imbaerasɨ güi. ");
INSERT INTO gnwNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jayave Jesús uicuaa umbɨgüera ma co quía imbaepuere pe. Jáeramo uyerova umae jeta vae re, jare upɨrandu: —¿Quía pa cheremimonde uyavɨquɨ? ");
INSERT INTO gnwNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Jayave jemimboe reta jei chupe: —Ndeecha co cua jeta vae reta ndeopɨ ñugüɨnoi. ¿Maera pa ndepɨrandu: ‘Quía pa cheremimonde uyavɨquɨ’? —jei reta chupe. ");
INSERT INTO gnwNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ẽrei Jesús umae iyɨpɨ rupi, uecha vaerã quía ra jucuarãi uyapo. ");
INSERT INTO gnwNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Cuña uicuaa uyeyapo ma chupe vae, jare ou icotɨ. Uquɨye güi urɨrɨ, jare uyeatɨca Jesús jovai, jare umɨmbeu chupe opaete uyeyapo ma vae. ");
INSERT INTO gnwNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jayave Jesús jei chupe: —Ndecuera ma, cherindɨ, nderovia cheré ramo. Ecua ndepɨacatu reve. Ndecuera ma co nembaerasɨ güi —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jare Jesús uyemɨngueta oĩ rambueve, yugüeru uvãe amocue vae tupao re uyandareco vae jenta güi. Jare jei reta Jairo pe: —Nderayɨ umano ma. Agüɨye ma emambeco oporomboe vae —jei reta chupe. ");
INSERT INTO gnwNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ẽrei Jesús cua uyandu yave, jei tupao re uyandareco vae pe: —Agüɨye ndepɨatɨtɨ. Epurugüɨroviaño —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Jare umaeño'ã ĩru reta re yugüɨraa vaerã jae ndive, jaeño Pedro, Jacobo jare Juan. Juan co jae Jacobo tɨvɨ. ");
INSERT INTO gnwNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Yugüɨraa uvãe yave tupao re uyandareco vae jenta pe, Jesús uecha jeta vae reta icorai jare uyao ñugüɨnoi reta jãse reve. ");
INSERT INTO gnwNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Jesús uique yave o pe, jei chupe reta: —¿Maera pa picorai jare piyao? Cua cuñatai umano'ã co. Oqueño co oĩ —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ẽrei jae reta oyoyai. Jayave Jesús omoẽ opaete vae oca pe, jare uruique cuñatai oĩ vae pe cuñatai tu jare ichɨ, jare jemimboe jae ndive yugüɨraa vae reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Jayave Jesús uipɨsɨ cuñatai ipo pe. —Talita cumi —jei chupe. (Cua uipota jei: “Cuñatai, che jae ndeve, epũa”.) ");
INSERT INTO gnwNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Jayave cuñatai upũa jare umbɨpɨ uguata. Cua cuñatai doce año ma güɨnoi. Jare Jesús ndive ñugüɨnoi vae reta ipɨacañɨ ete. ");
INSERT INTO gnwNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jayave Jesús oyocui ete reta agüɨye vaerã umɨmbeu quía pe ave, jare oyocui vi umɨngaru vaerã cuñatai. ");
INSERT INTO gnwNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesús oo joco güi iɨvɨ pe, jare jemimboe reta yugüɨraa jupíe. ");
INSERT INTO gnwNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Jayave mbutuu ara pe Jesús umbɨpɨ oporomboe judío reta itupao pe. Jare jeta vae uyapɨsaca jese, jare ipɨacañɨ reta. Jei reta uyupe: —¿Quiape ra uyemboe cua cuimbae opaete cua re? ¿Mbae nunga aracuaa ra uñemee chupe? ¿Mbae nunga mɨacañɨ ra cua uyapo ipo pe vae? —jei reta—. ");
INSERT INTO gnwNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Cua co jae carpintero. Jae co María imembɨ. Jae co Jacobo, José, Judas jare Simón tɨqueɨ. Jare jindɨ reta yugüɨreco vi yandepɨte pe —jei reta. Jáeramo jae reta pochɨ Jesús pe. ");
INSERT INTO gnwNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jayave Jesús jei chupe reta: —Opaete vae uipɨu penti Tumpa iñee umɨmbeu vae. Jaeño jentaɨgua reta, jentarã reta jare jenta pegua reta uipɨu'ã reta —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Jare joco pe ipuere'ã uyapo jeta mɨacañɨ. Jaeño oñono ipo mbovɨ imbaerasɨ vae reta re umbɨgüera vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Jare Jesús ipɨacañɨ jese reta, güɨrovia'ã jese ramo. Jayave Jesús oo oporomboe ĩru tenta guasu-raɨ jocoropi ñugüɨnoi vae reta rupi. ");
INSERT INTO gnwNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Penti ara Jesús umbatɨ jocua doce jemimboe reta, jare omondo mocui mocui rupi, jare umee chupe reta mbaepuere umbɨsɨrɨ vaerã aña reta oya jese vae reta güi. ");
INSERT INTO gnwNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Jare oyocui: —Peo yave, agüɨye mbae peraa, jaeño pepopoca. Agüɨye peraa peurupucu, perembiurã jare corepoti —jei chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Pemonde pepɨpasa, jare agüɨye peraa mocui camisa —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Jare jei vi chupe reta: —Peo pevãe yave penti tenta pe, joco pe peĩ, jocua tenta guasu güi peo ye regua —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Jare ime yave penti tenta guasu pegua reta uipota'ã pepɨta vaerã joco pe jare uipota'ã uyapɨsaca peré vae, pecuaño joco güi, jare pemɨtɨmo ɨvɨcuii pepɨ güi, uicuaa vaerã jae reta co teco güɨnoi —jei—. Añete che jae peve, Tumpa uãa yave ɨvɨ pegua reta, jocua tenta guasu pegua reta tanta uiporarata Sodoma jare Gomorra pegua reta güi —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Jayave jae reta yugüɨraa, jare umɨmbeu ĩru vae reta pe: —Peeya piyemɨngueta icavi mbae vae pepɨa pe oĩ vae. ");
INSERT INTO gnwNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Jare jae reta umbɨsɨrɨ jeta aña reta oya jese vae reta güi, jare jeta imbaerasɨ vae reta re oñono aceite umbɨgüera vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Opaete vae uyandu ma Jesús regua. Mburuvicha guasu Herodes jee vae uyandu vi. Jae jei: —Juan upurumbɨbautizase vae icove ye ma ou umanocue vae reta ipɨte güi. Jáeramo uyapo cua mɨacañi reta —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ĩru vae reta jei: —Jae co Elías. Jare ĩru vae reta jei: —Jae co penti Tumpa iñee umɨmbeu vae Tumpa iñee aracae umɨmbeu vae rami. ");
INSERT INTO gnwNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ẽrei Herodes uyandu yave, jei: —Jae co Juan añãcasɨaca vae. Icove ye ma ou umanocue vae reta ipɨte güi —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Echa'ã ndei Juan umano mbove, Herodes umenda Felipe jembireco Herodías jee vae ndive. Felipe co jae Herodes tɨvɨ. Jayave Herodes omondo uipɨsɨca Juan, jare oñonoca peresorɨru pe, Herodías jei ramo. ");
INSERT INTO gnwNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Echa'ã tenonde yave Juan jei Herodes pe: “Icavi'ã nemenda vaerã nderɨvɨ jembireco ndive.” ");
INSERT INTO gnwNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Jáeramo Herodías pochɨ Juan pe, jare uipota tẽi uyucaca, ẽrei ipuere'ã. ");
INSERT INTO gnwNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Echa'ã Herodes uicuaa Juan co jae cuimbae jupi vae. Jáeramo uipɨu, jare umaeño'ã quía re uyapo vaerã icavi mbae vae chupe. Jare uyandu yave Juan jei vae, uyemɨpɨa'ã tuicha. Ẽrei jecuaeño uipota uyapɨsaca jese. ");
INSERT INTO gnwNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ẽrei uvãe ara Herodías uyapo vaerã icavi mbae vae Juan pe. Jocua ara Herodes uyembɨara oa vae regua, jare umbatɨca ĩru mburuvicha reta, sundaro reta juvicha reta, jare icocatu vae reta Galilea pegua, umɨngaru vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Jare Herodías imembɨ cuña uique upɨrae yave, umbɨyerovia Herodes jare jae ndive ucaru ñugüɨnoi vae reta. Jayave Herodes jei cuñatai pe: —Eeca cheve mbae ndipota vae, jare che ameeta ndeve —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Jare jei ye chupe Tumpa jee re: —Ipotave mbae ndeeca cheve vae ameeta co ndeve, cheɨvɨ mbɨte rupi yepe. ");
INSERT INTO gnwNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Jayave cuñatai oẽ oo upɨrandu ichɨ pe: —¿Mbae pa aecata chupe? —Eeca chupe Juan upurumbɨbautizase vae iñãca —jei ichɨ chupe. ");
INSERT INTO gnwNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Jayave ɨmambaeño cuñatai uique ye mburuvicha guasu oĩ vae pe. —Aipota nemee vaerã cheve añave voi Juan upurumbɨbautizase vae iñãca penti plato pe —jei chupe. ");
INSERT INTO gnwNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Jayave mburuvicha guasu ipɨatɨtɨ tuicha. Ẽrei Tumpa jee re jei chupe ramo, jare ĩru vae reta uyandu ramo, uipota'ã uicuacu iñee. ");
INSERT INTO gnwNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Jáeramo omondo sundaro Juan iñãca güeru vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Jayave oo sundaro peresorɨru pe uñãcasɨa Juan. Jare güeru iñãcacue penti plato pe, jare umee cuñatai pe. Jayave jae umee ichɨ pe. ");
INSERT INTO gnwNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Jare Juan jemimboe reta cua uicuaa yave, yugüeru güɨraa jetecue oñotɨ vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jesús jemimondo reta uyembatɨ ye yave jae ndive, umɨmbeu reta chupe opaete uyapo vae jare oporomboe jese vae. ");
INSERT INTO gnwNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Jayave Jesús jei chupe reta: —Pe retaño peyu yaa quĩi ngatu vae pe, peputuu vaerã michi pegua —jei. Echa'ã jecuaecuae jeta vae yugüeru opou ipɨ. Jáeramo Jesús jare jemimboe reta iquĩi'ã ucaru vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Jayave jae retaño yugüɨraa chalana pe quĩi ngatu vae pe. ");
INSERT INTO gnwNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ẽrei jeta vae reta uecha yugüɨraa, jare uicuaa quía co jae vae. Jare yugüɨraa ɨvɨ rupiño tenta guasu reta güi Jesús oo vae pe, jare yugüɨraa uvãe ndei Jesús oo uvãe mbove, jare uyembatɨ joco pe. ");
INSERT INTO gnwNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jesús ugüeyɨ yave chalana güi, uecha jeta vae, jare uiparareco reta. Echa'ã jae reta ovecha mbaetɨ iyandarecoa güɨnoi vae reta rami co. Jare umbɨpɨ omboe reta jeta mbaembae re. ");
INSERT INTO gnwNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Caaru ma yave, Jesús jemimboe reta yugüeru jei chupe: —Mbaetɨ quiave ico cua rupi, jare caaru ma oĩ. ");
INSERT INTO gnwNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Emondo cua reta ogua vaerã jembiurã tenta tenta rupi. Echa'ã mbaetɨ mbae jou reta vaerã cua pe —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ẽrei Jesús jei chupe reta: —Pe reta pemee tucaru. —¿Ndoota pa ndogua doscientos ara mbaravɨquɨ jepɨ pegua mbɨyape, numee jou reta vaerã? —jei reta chupe. ");
INSERT INTO gnwNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesús jei chupe reta: —¿Mbovɨ pa mbɨyape ime penoi? Pecua peeca —jei. Jae reta uicuaa ma yave, umɨmbeu Jesús pe: —Ime nonoi pandepo mbɨyape jare mocui pira —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Jayave Jesús oyocui opaete vae uyembatɨmbatɨ vaerã uguapɨ capiichape re. ");
INSERT INTO gnwNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Jayave uyembatɨmbatɨ reta uguapɨ cien rupi jare cincuenta rupi. ");
INSERT INTO gnwNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jayave Jesús uipɨsɨ jocua pandepo mbɨyape jare mocui pira, jare umae ara cotɨ, jare umee yasurupai Tumpa pe. Jayave upɨsãa mbɨyape, jare umee jemimboe reta pe, jae reta umee vaerã yatɨ yatɨ ñugüɨnoi vae reta pe. Jesús upɨsãa vi jocua mocui pira, uñemee vaerã opaete vae pe. ");
INSERT INTO gnwNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Opareve ucaru, jare iyangapɨɨ reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Jayave Jesús jemimboe reta umbatɨ tembíu uñepɨsãacue jembɨre vae, jare umɨtɨnee doce canasta. ");
INSERT INTO gnwNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Jare ucaru vae reta güi cuimbae retaño uyepapa cinco mil. ");
INSERT INTO gnwNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Jare jupivoiño Jesús oyocui jemimboe reta uyupi vaerã chalana pe, jare yugüɨraa vaerã jenonde ɨ guasu jovaicho pe tenta guasu Betsaida pe, jae omondo rambueve uyembatɨ vae reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Jare opa omondo yave, Jesús uyupi ɨvɨtu guasu re uyerure vaerã Tumpa pe. ");
INSERT INTO gnwNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Pɨ̃tu ma yave, jemimboe reta yugüɨraa chalana pe ɨ guasu mbɨte rupi, jare Jesús jaeño upɨta ɨvɨ pe. ");
INSERT INTO gnwNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Jare Jesús uecha tanta ma uparavɨquɨ reta, uruguata vaerã chalana. Echa'ã ɨvɨtu tanta oovãiti. Jare cõeta ma yave, Jesús uguata oo ɨ iárambo rupi güɨraa uepitɨ. Jare uasata tẽi chugüi reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Jae reta uecha yave uguata oo ɨ iárambo rupi, ipɨa pe uyemɨngueta tẽi uecha mbae iãcue, jare usapɨcai reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Echa'ã opaete jae reta uecha, jare uquɨye ete reta. Ẽrei jupivoiño Jesús ombou iñee chupe reta: —Piñemɨatangãtu. Che co. Agüɨye pequɨye —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Jayave Jesús ou uyupi chalana pe, jare upɨta ɨvɨtu. Jare jae reta ipɨacañɨ. ");
INSERT INTO gnwNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Echa'ã jocua mɨacañɨ mbɨyape regua uyapo yave, Jesús uipota tẽi jae reta uicuaa cavi vaerã. Ẽrei ndeiño uicuaa. Echa'ã jecuaeño ipɨatanta. ");
INSERT INTO gnwNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","54","Ɨ guasu uasa reta yave, yugüɨraa uvãe ɨvɨ Genesaret pe. Jare ugüeyɨ reta yave chalana güi ɨ guasu jembeɨ pe, jupivoiño joco pegua reta uicuaa jae co Jesús vae. ");
INSERT INTO gnwNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Jare yugüɨraa opaete jocua ɨvɨ rupi, jare umbɨpɨ güeru imbaerasɨ vae reta jupa reve Jesús oĩ vae pe. Ĩru vae reta umɨmbeu chupe reta quiape oĩ vae. ");
INSERT INTO gnwNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Jare Jesús oo tenta guasu-raɨ reta rupi, jare tenta guasu reta rupi, jare tenta ñana rupi ñugüɨnoi vae reta pe. Jare oo vae rupi joco pegua reta güeru oñono imbaerasɨ vae reta tape rupi, jare uyerure Jesús pe umaeño imbaerasɨ vae reta uyavɨquɨ vaerã jemimonde jembeɨ yepe. Jare opaete uyavɨquɨ vae reta ucuera. ");
INSERT INTO gnwNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Fariseo reta jare amocue mboroyocui re oporomboe vae Jerusalén güi yugüeru vae reta uyembatɨ Jesús oĩ vae pe. ");
INSERT INTO gnwNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Jae reta uecha amocue Jesús jemimboe reta ucaru ñugüɨnoi uyepoe mbae reve. Echa'ã jae reta uyapo ve'ã ma itenondegua reta iporomboe. Jáeramo umbɨjeco reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Echa'ã fariseo reta jare opaete judío reta uyepoeñoi ndei ucaru mbove, uyapo vaerã itenondegua reta iporomboe. ");
INSERT INTO gnwNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Jare yugüeru ye yave umaemee vae reta ñugüɨnoi vae güi, jecuaeño uyepoe ndei ucaru mbove. Jare uyapoñoi reta jeta ĩru mbaembae itenondegua reta iporomboe. Echa'ã oyoe vaso reta, yapepo reta, paila reta jare tupa reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Jayave fariseo reta jare mboroyocui re oporomboe vae reta upɨrandu Jesús pe: —¿Maera pa nderemimboe reta uyapo'ã yandetenondegua reta iporomboe? ¿Maera pa ucaru reta uyepoe mbae reve? —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jayave Jesús jei chupe reta: —Añete yepe Isaías imiari peré. Echa'ã jae uicuatía upurumbɨtavɨ vae reta re cuarãi: ‘Cua reta chepɨu iyuru peño’ —jei Tumpa—. ‘Ẽrei ipɨa pe chepɨu'ã etei. ");
INSERT INTO gnwNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Chembɨadora-raangaiño. Che jucuarãi'ã aporoyocui’ —jei Tumpa. Jucuarãi uicuatía Isaías —jei Jesús—. ");
INSERT INTO gnwNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Echa'ã pe reta piyapo'ã Tumpa iporoyocui, ẽrei piyapo cavi yandetenondegua reta iporomboe. Piyoe yapepo reta jare vaso reta, jare jeta cua nunga piyapo —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Jare Jesús jei chupe reta: —Tumpa iporoyocui pemombo co, piyapo vaerã yandetenondegua reta iporoyocui. ");
INSERT INTO gnwNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moisés jei cuarãi: ‘Ipɨu nderu jare ndesɨ.’ Jare jei vi cuarãi: ‘Jei icavi mbae vae tu ani ichɨ cotɨ vae uyeyucacata co.’ Jucuarãi jei Moisés —jei chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ẽrei pe reta pere cuarãi: ‘Penti cuimbae ipuere jei tu ani ichɨ pe umeeta tẽi chupe omborɨ vaerã vae Corbán co.’ Jucuarãi pere —jei—. (Corbán uipota jei: “Amee ma Tumpa pe”.) ");
INSERT INTO gnwNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Jayave pe reta pemaeño'ã ma jese omborɨ vaerã tu jare ichɨ —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Jare jeta cua nunga piyapo. Jucuarãi pe reta pemombo Tumpa iporoyocui piyugüi piyapo vaerã yandetenondegua reta iporoyocui. Jare pemboe vi pesambiaɨ reta uyapo vaerã yandetenondegua reta iporoyocui —jei Jesús chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jare Jesús ueni umbatɨ opaete joco pe ñugüɨnoi vae reta. —Piyapɨsaca cua re opaete pe reta, picuaa cavi vaerã —jei chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ipotave mbae peu vae oo perɨe pe. Jáeramo umɨnguɨa'ã pepɨa. Jocua piyapo vae jare pere vae umɨnguɨa pepɨa —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Uipota uyandu vae tuyapɨsaca cua ñee re —jei chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jare Jesús ueya yatɨ vae reta yave, uique jo pe. Jayave jemimboe reta upɨrandu chupe umɨjaanga reve jei vae re. ");
INSERT INTO gnwNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jayave Jesús jei chupe reta: —¿Pe retave pa picuaa cavi'ã? Picuaa cavi cua: Ipotave mbae peu vae umɨnguɨa'ã pepɨa. ");
INSERT INTO gnwNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Echa'ã oo'ã pepɨa pe. Oo perɨe pe jare pemombo. Jucuarãi uyeyapo opaete tembíu pe —jei chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Jare Jesús jei: —Jocua piyapo vae jare pere vae umɨnguɨa pepɨa. ");
INSERT INTO gnwNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Echa'ã pepɨa güi oẽ opaete icavi mbae vae: pepɨa pe piyemɨngueta icavi mbae vae, piyuvanga menda re, piyapo aguasa, pepuruyuca, ");
INSERT INTO gnwNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","pemonda, pipota ĩru vae reta imbaembae, piyapo icavi mbae vae, pepurumbɨtavɨ, pembɨquere, peacatãa, icavi mbae vae pere perapicha cotɨ, piyembɨcate jare pico iyaracuaa mbae vae reta rami —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Opaete cua icavi mbae vae oẽ pepɨa güi. Jare cua reta umɨnguɨa pepɨa —jei chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jayave Jesús oo ye joco güi Tiro jare Sidón iyɨpɨ rupi. Jare uique yave penti tenta pe, uipota'ã tẽi quiave uicuaa vaerã jae joco pe oĩ vae. Ẽrei uicuaañoi joco pegua reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Jare penti cuña aña oya imembɨ cuña re vae uyandu Jesús regua, jare ou uyeatɨca jae jovai. ");
INSERT INTO gnwNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Jae co penti sirofenicia griega pe uyemɨngueta vae. Jae uyerure Jesús pe umbɨsɨrɨ vaerã aña imembɨ güi. ");
INSERT INTO gnwNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ẽrei Jesús jei chupe: —Tiangapɨɨ rani sambiaɨ reta. Icavi'ã yaequi vaerã tembíu sambiaɨ reta güi, ñamee vaerã yɨmba-raɨ reta pe —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","—Añete tẽi co, carai —jei cuña Jesús pe—. Ẽrei yɨmba-raɨ mesa igüɨ pe ñugüɨnoi vae reta jou tembíu usururucue sambiaɨ reta uitɨ vae —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jayave Jesús jei chupe: —Cua ndere vae jeco pegua ndepuere ndeo. Aña usɨrɨ ma nemembɨ güi —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Jayave cuña oo uvãe jenta pe yave, uecha imembɨ jupa pe oĩ. Aña usɨrɨ ma chugüi. ");
INSERT INTO gnwNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jayave Jesús ou Tiro iyɨpɨ rupigua güi, jare uasa Sidón jare Decápolis rupi, jare ou uvãe ɨ guasu Galilea pe oĩ vae pe. ");
INSERT INTO gnwNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Jare amocue vae güeru chupe penti cuimbae iupaupa jare iyapɨsa mbae vae. Güeru vae reta uyerure Jesús pe oñono vaerã ipo jese. ");
INSERT INTO gnwNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jayave Jesús güɨraa cuimbae yatɨ vae reta ipɨte güi. Oñono ipoãca cuimbae iyapɨsa pe. Jayave undɨvɨ, jare uyavɨquɨ cuimbae icũ chugüi. ");
INSERT INTO gnwNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Jayave umae ara cotɨ, jare iañeequi, jare jei: —¡Efata! (Cua uipota jei: “¡Iyepea!”) ");
INSERT INTO gnwNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Jayave cuimbae uyandu ma, jare icũ omɨ cavi, jare uyemɨngueta cavi ma. ");
INSERT INTO gnwNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jayave Jesús oyocui reta agüɨye vaerã umɨmbeu quía pe. Ẽrei yepe tẽi oyocui ye ye, jeseve jae reta umɨmbeuñoi ĩru vae reta pe. ");
INSERT INTO gnwNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Jae reta ipɨacañɨ ete, jare jei: —Opaete mbaembae uyapo vae icavi ete co. Umbɨgüera iyapɨsa mbae vae reta uyandu vaerã, jare umbɨgüera vi upa reta uyemɨngueta vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Penti ara jeta uyembatɨ yave, mbaetɨ ma mbae güɨnoi reta jou vaerã. Jayave Jesús ueni jemimboe reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Aiparareco cua yatɨ vae reta —jei—. Echa'ã mbapɨ ara ma ñugüɨnoi che ndive, jare mbaetɨ ma mbae güɨnoi jou vaerã —jei jemimboe reta pe—. ");
INSERT INTO gnwNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Amondo yave jenta cotɨ ucaru mbae reve, ipɨtuta co reta tape rupi. Echa'ã amocue yugüeru mbɨrɨ güi —jei chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","—¿Quirãita pa yandepuere ñamee mbɨyape chupe reta cua mbaetɨ quiave ico vae pe? —jei jemimboe reta Jesús pe. ");
INSERT INTO gnwNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jayave Jesús upɨrandu chupe reta: —¿Mbovɨ pa mbɨyape penoi? —Ime nonoi siete —jei reta chupe. ");
INSERT INTO gnwNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Jayave Jesús oyocui yatɨ vae reta uguapɨ vaerã ɨvɨ pe. Jayave uipɨsɨ jocua siete mbɨyape, jare umee yasurupai Tumpa pe. Jayave upɨsãa mbɨyape, jare umee jemimboe reta pe, jae reta umee vaerã yatɨ vae reta pe. Jayave jucuarãi uyapo reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Jare güɨnoi vi mbovɨ pira michi vae reta. Cua re vi Jesús umee yasurupai Tumpa pe, jare jei jemimboe reta pe cua vi umee vaerã yatɨ vae reta pe. ");
INSERT INTO gnwNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Opareve ucaru, jare iyangapɨɨ reta. Jayave Jesús jemimboe reta umbatɨ tembíu uñepɨsãacue jembɨre vae, jare umɨtɨnee siete canasta. ");
INSERT INTO gnwNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Jare joco pe ñugüɨnoi vae reta uyepapa cuatro mil rupi. Jayave Jesús omondo ye yatɨ vae reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Jayave jae jare jemimboe reta uyupi chalana pe, jare yugüɨraa ɨvɨ Dalmanuta jee vae pe. ");
INSERT INTO gnwNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Jayave yugüeru fariseo reta, jare umbɨpɨ uyeaca Jesús ndive. —Eechaca oreve mɨacañɨ ara güi —jei reta chupe. Jae reta uipota uicuaa uyapota ra mɨacañɨ chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jayave Jesús iañeequi. —¿Maera pa añave yugüɨreco vae reta uipota aechaca vaerã chupe reta mɨacañɨ? —jei—. Añete che jae peve, ndarau uyeechaca mɨacañɨ cua reta pe —jei chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Jayave Jesús ueya reta, jare uyupi ye chalana pe oo ɨ guasu jovaicho pe. ");
INSERT INTO gnwNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Jare Jesús jemimboe reta ñacañɨ güeru vaerã mbɨyape. Pentiño mbɨyape güɨnoi chalana pe. ");
INSERT INTO gnwNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jare Jesús jei chupe reta: —Piñemoa ngatu fariseo reta jare Herodes ilevadura güi. ");
INSERT INTO gnwNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Jayave jemimboe reta jei uyupe: —Cua jei, yaru'ã mbɨyape ramo. ");
INSERT INTO gnwNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesús uicuaa chugüi mbae jei reta vae, jare jei chupe reta: —¿Maera pa piyemɨngueta mbɨyape peru mbae vae re? ¿Ndeiño pa picuaa cavi? ¿Tanta mbate pa co pepɨa? —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Peresa jare peapɨsa penoi. ¿Peecha'ã pa jare piyandu'ã pa? ¿Pemandua'ã pa? —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Cue yave apɨsãa pandepo mbɨyape, ucaru vaerã cinco mil vae reta. Tembíu jembɨrecue pembatɨ yave, ¿mbovɨ canasta pa pemɨtɨnee? —jei. —Numɨtɨnee doce —jei reta chupe. ");
INSERT INTO gnwNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","—Jare siete mbɨyape apɨsãa vi, ucaru vaerã cuatro mil vae reta. Tembíu jembɨrecue pembatɨ yave, ¿mbovɨ canasta pa pemɨtɨnee? —jei Jesús. —Numɨtɨnee siete —jei reta chupe. ");
INSERT INTO gnwNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Jayave Jesús jei chupe reta: —¿Ndeiño pa picuaa cavi? ");
INSERT INTO gnwNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Jare yugüɨraa uvãe Betsaida pe. Jayave amocue vae güeru Jesús pe cuimbae jesa mbae vae, jare jae reta uyerure chupe oñono vaerã ipo jese. ");
INSERT INTO gnwNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jayave Jesús uipoco güɨraa cuimbae jesa mbae vae tenta guasu güi. Jayave undɨvɨ cuimbae jesa re, jare oñono ipo jese. —¿Ndepuere pa mbae ndeecha? —jei chupe. ");
INSERT INTO gnwNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Cuimbae umae. —Cuimbae reta aecha —jei Jesús pe—. Ẽrei ɨvɨra reta echa cheve. Ẽrei aecha uguata ñugüɨnoi —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jayave Jesús oñono ye ipo jesa re, uecha cavi vaerã. Jayave ramo uecha cavi opaete mbaembae. ");
INSERT INTO gnwNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jayave Jesús oyocui: —Agüɨye ecua cua tenta guasu rupi. Jare agüɨye emɨmbeu quía pe ave jocoropi —jei chupe. Jayave omondo jenta pe. ");
INSERT INTO gnwNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Coiño tenta guasu Cesarea Filipo güi ñugüɨnoi amocue tenta guasu-raɨ reta. Jocotɨ yugüɨraa Jesús jare jemimboe reta. Jare tape rupi Jesús upɨrandu jemimboe reta pe: —¿Quía pa co che ĩru vae reta pe? ");
INSERT INTO gnwNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Jae reta umɨmbeu chupe: —Amocue vae jei nde co jae Juan upurumbɨbautizase vae, jare ĩru vae reta jei nde co jae Elías, jare ĩru vae reta jei nde co jae penti Tumpa iñee aracae umɨmbeu vae —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Jayave Jesús upɨrandu chupe reta: —Jare ¿quía pa co che peve? Jayave Pedro jei chupe: —Nde co jae Cristo, Tumpa ombou vae. ");
INSERT INTO gnwNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Jayave Jesús oyocui reta agüɨye vaerã umɨmbeu quía pe. ");
INSERT INTO gnwNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jayave Jesús umɨmbeu chupe reta: —Che cuimbaerã ayeyapo vae jetata co aiporara. Jare tenta guasu pegua reta itenondegua reta, sacerdote reta itenondegua reta, jare mboroyocui re oporomboe vae reta chererɨ̃rota jare cheyucacata. Ẽrei mbapɨ ara rupi aicove yeta ayu umanocue vae reta ipɨte güi —jei chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Cua umɨmbeu cavi chupe reta. Jayave Pedro güɨraa Jesús ĩru reta ipɨte güi, jare umbɨpɨ umbɨeta chupe. ");
INSERT INTO gnwNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ẽrei Jesús uyerova umae ĩru jemimboe reta cotɨ, jare uñeengata Pedro pe. —Esɨrɨ chegüi, Satanás —jei chupe—. Echa'ã nde ndiyemɨngueta neĩ ɨvɨ pegua reta uyemɨngueta rami, ndiyemɨngueta'ã Tumpa uyemɨngueta rami —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Jare Jesús ueni jemimboe reta jare ĩru joco pe ñugüɨnoi vae reta. Jayave jei chupe reta: —Ime yave quía uipota oo cherupíe vae, tiñacañɨ iyugüi, tovoɨ icurusu, jare too cherupíe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Uipota uñuvatu jecove vae ndarau ipuere. Ẽrei jocua umeeta jecove chereco pegua jare Tumpa iñee icavi vae jeco pegua vae uñuvatuta co —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","¿Mbae ra umɨnganata quía, umɨngana yave opaete ɨvɨ pegua, ẽrei ipuere'ã yave uñuvatu jecove? ");
INSERT INTO gnwNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¿Mbovɨ ra umbɨepɨta quía ogua ye vaerã jecove? —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ɨvɨ pegua añave yugüɨreco vae reta güɨrovia'ã Tumpa jare uyapo icavi mbae vae. Ime yave quía imara cheré jare chiñee re cua reta ipɨte pe vae, che cuimbaerã ayeyapo vae chemarata vi jese, ayu ye yave cheRu imbaepuere reve ángel uñeñono tee Tumpa peguarã vae reta ndive —jei chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jesús jei chupe reta: —Añete che jae peve, ndei amocue cua pe ñugüɨnoi vae umano mbove, uechata reta Tumpa iporoyocuia mbaepuere pegua. ");
INSERT INTO gnwNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Seis ara ma uasa yave, Jesús güɨraa Pedro, Jacobo jare Juan ĩru reta ipɨte güi penti ɨvɨtu guasu ɨvate vae re, jare joco pe uyembɨambɨe jae reta jovai. ");
INSERT INTO gnwNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Jemimonde umbɨpɨ uvera jare tĩ asɨ. Mbaetɨ penti ave umbaeputuca vae ipuere umɨtĩ asɨ jucuarãi. ");
INSERT INTO gnwNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Jare uyecuaa chupe reta Elías jare Moisés uyemɨngueta ñugüɨnoi Jesús ndive. ");
INSERT INTO gnwNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Jayave Pedro jei Jesús pe: —Oporomboe vae, icavi co ñaĩ vaerã cua pe. Nduyapota mbapɨ guarasɨ̃a ñanaroquɨ pegua, penti nembaerã, penti Moisés peguarã jare penti Elías peguarã —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Echa'ã Jesús jemimboe reta uquɨye ete, jare Pedro uicuaa'ã mbae jei vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Jayave ou amapɨ̃tu umɨguarasɨ̃a reta, jare amapɨ̃tu güi uyendu ñee jei: —Cua co jae cheRaɨ aau ete vae. Piyapɨsaca jese —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Jare aramoiño umae reta yave, uecha'ã ma quía jae reta ndive, jaeño Jesús. ");
INSERT INTO gnwNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Jare ɨvɨtu guasu güi ugüeyɨ yugüeru rambueve, Jesús oyocui reta: —Agüɨye pemɨmbeu quía pe cua peecha vae, ndei che cuimbaerã ayeyapo vae aicove ye ayu umanocue vae reta ipɨte güi mbove —jei chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Jáeramo umɨmbeu'ã quía pe, ẽrei upɨrandu reta uyupe: —¿Mbae pa uipota jei cua umɨmbeu yandeve vae? ¿Quirãita pa icove ye ou umanocue vae reta ipɨte güi? —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Jayave jae reta upɨrandu Jesús pe: —¿Maera pa jei mboroyocui re oporomboe vae reta Elías rani co outa? ");
INSERT INTO gnwNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","—Añete Elías rani co outa —jei Jesús chupe reta—, jare opaete uyapɨcatuta. Jare ¿mbae ra uyecuatía oĩ Tumpa iñee pe che cuimbaerã ayeyapo vae re? Uyecuatía oĩ che jetata aiporara jare ĩru vae reta chererɨ̃rota —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ẽrei che jae peve, Elías ou ma co, jare amocue vae uyapo chupe jae reta uipota vae, Tumpa iñee pe uyecuatía oĩ rami —jei chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Jare yugüeru uvãe yave ĩru jemimboe reta ñugüɨnoi vae pe, uecha jeta yatɨ ñugüɨnoi iyɨpɨ rupi, jare mboroyocui re oporomboe vae reta uyeaca ñugüɨnoi jae reta ndive. ");
INSERT INTO gnwNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Jayave opaete joco pe ñugüɨnoi vae reta uecha Jesús, jare ipɨacañɨ reta. Jayave osi yugüeru reta icotɨ, jare umbɨsaluda reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jayave Jesús upɨrandu chupe reta: —¿Mbae re pa piyeaca peĩ jae reta ndive? ");
INSERT INTO gnwNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Jayave penti cuimbae yatɨ vae reta ipɨte pe oĩ vae jei chupe: —Oporomboe vae, aru ndeve cheraɨ. Aña oya jese jare umbuupa —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Jare que rupi oĩ vae pe aña oya jese yave, joco pe umbɨrɨrɨ, jare cunumi iyuru tɨrɨyai, jãi umbɨquɨrɨrɨu jare jete opa uñemɨtanta —jei—. Ayerure tẽi ma nderemimboe reta pe umbɨsɨrɨ vaerã aña chugüi, ẽrei ipuere'ã reta —jei cuimbae Jesús pe. ");
INSERT INTO gnwNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jayave Jesús jei chupe reta: —Pe reta cua ɨvɨ pe pico vae pepurugüɨrovia'ã. ¿Quirãi regua ra apɨtata pe reta ndive? ¿Quirãi regua ra arupɨata peve? Peru cheve cua pe jocua cunumi —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Jayave güeru chupe, jare aña uecha yave Jesús, jupivoiño umbɨrɨrɨ tanta jocua cunumi jare oa ɨvɨ re. Uyapayere, jare iyuru tɨrɨyai. ");
INSERT INTO gnwNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jayave Jesús upɨrandu tu pe: —Quirãi yave ma pa uyeyapo chupe cua? —Michi güive uyeyapo chupe —jei tu—. ");
INSERT INTO gnwNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Jare jeta vese ma uitɨ tata pe jare ɨ pe, uyuca vaerã tẽi. Ẽrei nde ndepuere yave mbae ndiyapo chupe, oreparareco jare oremborɨ —jei chupe. ");
INSERT INTO gnwNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jayave Jesús jei chupe: —¿Ndepuere pa ndepurugüɨrovia? Upurugüɨrovia vae ipuere uyapo opaete mbaembae —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Jayave cunumi tu iñeeãta reve jei: —Ndugüɨrovia. Apurugüɨrovia'ã yave, chemborɨ apurugüɨrovia vaerã —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jare Jesús uecha yave jeta vae uyembatɨ joco pe, uñeengata aña pe. —Aña upurumbuupa jare upurumbɨapɨsa mbae vae, che ndoyocui ndesɨrɨ vaerã cua cunumi güi, jare agüɨye etei ma eya ye jese —jei aña pe. ");
INSERT INTO gnwNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Jare aña jãse ma yave, umbɨrɨrɨ tanta cunumi, jare usɨrɨ chugüi. Jare cunumi umano echa upɨta. Jare jeta joco pe ñugüɨnoi vae reta jei tẽi: —Umano ma. ");
INSERT INTO gnwNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ẽrei Jesús uipɨsɨ cunumi ipo pe, jare umupũa. Jare cunumi uyemboɨ. ");
INSERT INTO gnwNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Jare Jesús uique yave penti o pe, jemimboe reta upɨrandu chupe, jae retaño jae ndive ñugüɨnoi yave: —¿Maera pa ore orepuere'ã numbɨsɨrɨ aña? ");
INSERT INTO gnwNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","—Ndarau pepuere pembɨsɨrɨ cua nunga aña, jaeño piyerure yave Tumpa pe piyecuacu reve tembíu güi —jei Jesús chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Jesús jare jemimboe reta yugüɨraa yave joco güi, uasa Galilea rupi. Jare Jesús uipota'ã quía uicuaa vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Echa'ã omboe güɨnoi jemimboe reta. —Che cuimbaerã ayeyapo vae penti vae chemeeta ĩru vae reta pe. Jae reta cheyucata —jei chupe reta—. Ẽrei amano ma yave, mbapɨ ara rupi aicove yeta ayu umanocue vae reta ipɨte güi —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ẽrei jae reta uicuaa cavi'ã mbae re ra Jesús umɨngueta vae, jare uipɨu reta upɨrandu vaerã chupe jese. ");
INSERT INTO gnwNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Jayave yugüɨraa uvãe Capernaum pe. Jare jenta pe oĩ yave, Jesús upɨrandu jemimboe reta pe: —¿Mbae re pa piyemɨngueta peyu tape rupi? ");
INSERT INTO gnwNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ẽrei jae reta iquĩiño. Echa'ã tape rupi jae reta uyemɨngueta yugüeru quía ra tenondegua ĩru reta güi vae. ");
INSERT INTO gnwNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jayave Jesús uguapɨ, jare ueni jocua doce jemimboe reta. Jayave jei chupe reta: —Ime yave quía uipota tenondeguarã ico vae, tuñemɨmichi opaete vae güi, jare tuyeyocui opaete ĩru reta pe —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Jayave ueni penti sambiaɨ, jare oñono jae reta ipɨte pe. Jayave uicuãva sambiaɨ, jare jei chupe reta: ");
INSERT INTO gnwNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Ime yave quía uyapo icavi vae cua nunga sambiaɨ pe cheree pe vae, cheve co uyapo icavi vae. Jare jocua cheve uyapo icavi vae, uyapo vi icavi vae chembou vae pe —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jayave Juan jei Jesús pe: —Oporomboe vae, nduecha penti cuimbae nderee pe umbɨsɨrɨ aña reta oya jese vae reta güi, jare ndoe chupe agüɨye ma uyapo vaerã. Echa'ã jae ñaneĩru'ã co —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","—Agüɨye pere chupe jucuarãi —jei Jesús chupe—. Echa'ã cheree pe mɨacañɨ uyapo vae ndarau jupivoiño jei icavi mbae vae checotɨ —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Echa'ã oyovaicho'ã yande ndive vae yanemborɨ co —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Aramoi quía umeeta peve penti vaso ɨ cheree pe vae. Jucuarãi uyapo yave cheré perovia ramo, añete che jae peve, ambɨjecoviata co chupe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ime cheré güɨrovia vae reta. Ime yave quía penti cua nunga pe mbaeyoa uyapoca vae, icavita tẽi co ĩru vae reta uñapɨ̃ti vaerã iyayu re penti ita tuicha vae umbaeso pɨpe vae, jare omombo vaerã ɨ guasu pe —jei chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ndepo jovaicho uyapoca yave mbaeyoa ndeve, iyasɨa ndiyugüi. Icavi co tecove opa mbae vae nenoi vaerã ndepo jovaicho mbae reve, tata guasu opa mbae vae pe mocui ndepo reve ndeo vaerã tẽi güi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Echa'ã tata guasu pe taso ndarau umano, jare tata ndarau ove —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Jae ramiño vi ndepɨ jovaicho uyapoca yave mbaeyoa ndeve, iyasɨa ndiyugüi. Icavi co tecove opa mbae vae nenoi vaerã ndepɨ jovaicho mbae reve, tata guasu opa mbae vae pe mocui ndepɨ reve Tumpa nemondo vaerã tẽi güi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Tata guasu pe taso ndarau umano, jare tata ndarau ove —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Jae ramiño vi nderesa jovaicho uyapoca yave mbaeyoa ndeve, eequi ndiyugüi. Icavi co ndico vaerã Tumpa iporoyocuia pe nderesa jovaicho mbae reve, tata guasu pe mocui nderesa reve Tumpa nemondo vaerã tẽi güi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Tata guasu pe taso ndarau umano, jare tata ndarau ove —jei ye chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Echa'ã tata uñeñonocata opaete re, yuquɨ uñeñonoca tembíu pe rami. Yuquɨ uñeñonocata vi opaete maemɨmba Tumpa pe uyeyuca vae re —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Yuquɨ icavi co yau vaerã. Ẽrei jembochɨ'ã ma yave, ¿quirãita ra jembochɨ ye? —jei—. Piyapo yuquɨ uyapo rami, jare pico cavi pãve —jei chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jayave Jesús oo joco güi Judea pe Jordán jovaicho pe. Joco pe jeta uyembatɨ ye jae oĩ vae pe. Jayave Jesús omboe reta, jecoño mai uyapo rami. ");
INSERT INTO gnwNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Jayave fariseo reta yugüeru Jesús oĩ vae pe. Jae reta uipota tẽi uyavɨca chupe. Jáeramo upɨrandu reta chupe: —¿Jupi pa cuimbae omombo vaerã jembireco? ");
INSERT INTO gnwNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","—¿Mbae pa peocui Moisés? —jei Jesús chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","—Moisés umaeño cuimbae re uicuatía vaerã tupapire jembireco omombo vaerã —jei reta chupe. ");
INSERT INTO gnwNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","—Moisés uicuatía cua mboroyocui pepɨatanta ramo —jei Jesús—. ");
INSERT INTO gnwNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ẽrei Tumpa uyapo ramo yave, uyapo cuimbae jare cuña —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Jáeramo cuimbae usɨrɨta tu jare ichɨ güi, jare oota ico vaerã jembireco ndive —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Jare mocui vae uyeyapota penti ramiño. Jáeramo mbaetɨ ma mocui rami. Yugüɨreco penti ramiño —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Jáeramo agüɨye quía tumbɨsɨrɨ Tumpa umɨĩru vae reta —jei chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Jare o pe ñugüɨnoi yave, jemimboe reta upɨrandu ye Jesús pe cua re. ");
INSERT INTO gnwNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jayave Jesús jei chupe reta: —Cuimbae omombo jembireco jare umenda ĩru cuña ndive yave, uyuvanga menda re jembireco omombo vae cotɨ. ");
INSERT INTO gnwNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Jare cuña usɨrɨ ime güi jare umenda ĩru cuimbae ndive yave, uyuvanga vi menda re —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Jare amocue vae güeru Jesús oĩ vae pe sambiaɨ reta, Jesús oñono vaerã ipo jese reta. Ẽrei jemimboe reta uñeengata güeru vae reta pe. ");
INSERT INTO gnwNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jesús cua uecha yave, pochɨ jemimboe reta pe, jare jei chupe reta: —Pemaeño sambiaɨ reta re yugüeru vaerã checotɨ. Agüɨye piyopia. Echa'ã cua nunga uyeyocui Tumpa pe iporoyocuia pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Añete che jae peve, pipota'ã yave Tumpa pe piyeyocui vaerã penti sambiaɨ uipota rami, ndarau pico Tumpa iporoyocuia pe —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Jayave Jesús uicuãva sambiaɨ reta, jare oñono ipo jese reta, jare uyerure Tumpa pe jese reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jare Jesús joco güi oo yave, penti cuimbae osi ou icotɨ. Uyeatɨca Jesús jovai. —Oporomboe vae, nde ndepɨacavi co —jei Jesús pe—. ¿Mbae pa ayapota anoi vaerã tecove opa mbae vae? —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","—¿Maera pa ndere cheve chepɨacavi vae co? —jei Jesús chupe—. Mbaetɨ quía ipɨacavi, jaeño co Tumpa —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Nde ndicuaa co mboroyocui reta: ‘Agüɨye iyuvanga menda re. Agüɨye epuruyuca. Agüɨye nemonda. Agüɨye ndapu ĩru vae re. Agüɨye epurumbɨtavɨ. Ipɨu nderu jare ndesɨ’ —jei chupe. ");
INSERT INTO gnwNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","—Oporomboe vae, ayavɨ'ã penti ave cua mboroyocui reta chemichi güive —jei cuimbae chupe. ");
INSERT INTO gnwNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesús umae jese uau reve. —Ime mbae uata ndiyapo vaerã —jei chupe—. Ecua emee opaete mbaembae nenoi vae corepoti re, jare emee ndecorepoti iparavete vae reta pe, jare ndicocatuta ara pe. Jayave evoɨ ndecurusu, jare eyu cherupíe —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ẽrei cua uyandu yave, cuimbae oo ipɨatɨtɨ reve. Echa'ã jeta mbaembae güɨnoi. ");
INSERT INTO gnwNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jayave Jesús umae iyɨpɨ rupi, jare jei jemimboe reta pe: —Yavai ete co icocatu vae reta uique vaerã Tumpa iporoyocuia pe. ");
INSERT INTO gnwNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Jemimboe reta ipɨacañɨ Jesús jei vae re. Ẽrei Jesús jei ye: —Cherɨvɨ reta, yavai ete co icocatu vae reta uique vaerã Tumpa iporoyocuia pe. Echa'ã jei tẽi ipɨa pe: ‘Icavita co cheve. Echa'ã jeta mbaembae anoi’ —jei, jei Jesús—. ");
INSERT INTO gnwNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Yavai ete icocatu vae uique vaerã Tumpa iporoyocuia pe, maemɨmba camello jee vae yuu jesacua rupi uasa vaerã güi —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Jayave jae reta ipɨacañɨ ete, jare upɨrandu uyupe: —Jucuarãi yave, ¿quía pa ipuere uyembɨasaca? ");
INSERT INTO gnwNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesús umae jese reta jare jei: —Ɨvɨ pegua reta ipuere'ã uyembɨasa. Ẽrei Tumpa ipuere umbɨasa reta. Echa'ã Tumpa ipuere uyapo opaete mbaembae —jei chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Jayave Pedro jei Jesús pe: —Mase, ore opaete mbaembae ndueya, ndoyu vaerã nderupíe. ");
INSERT INTO gnwNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","—Añete che jae peve —jei Jesús—, ime yave quía ueya jenta, ani tɨqueɨ reta, ani tɨvɨ reta, ani jindɨ reta, ani tu, ani ichɨ, ani jembireco, ani isambiaɨ reta, ani iɨvɨ reta chereco pegua jare Tumpa iñee icavi vae jeco pegua vae, ");
INSERT INTO gnwNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","cien rupi jecoviata co chupe ɨvɨ pe ico rambueve. Jecoviata jenta reta, tɨqueɨ reta, tɨvɨ reta, jindɨ reta, ichɨ reta, isambiaɨ reta jare iɨvɨ reta —jei—. Ẽrei ĩru vae reta uyapota icavi mbae vae chupe. Ẽrei taɨcue rupi Tumpa umeeta chupe tecove opa mbae vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ẽrei Tumpa umbɨtaɨcueta uyembutuicha vae reta, jare umɨtenondeta uñemɨmichi vae reta —jei chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jesús jare jae ndive ñugüɨnoi vae reta yugüɨraa tape Jerusalén cotɨ oo vae rupi, jare Jesús tenonde oo. Jare jaɨcue rupi yugüɨraa vae reta ipɨacañɨ jare uquɨye. Jayave Jesús ueni ye jocua doce jemimboe reta ĩru reta ipɨte güi, jare umbɨpɨ umɨmbeu chupe reta mbae uyeyapota oĩ chupe vae. ");
INSERT INTO gnwNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","—Mase, yaa co ñaĩ Jerusalén pe —jei chupe reta—. Jare che cuimbaerã ayeyapo vae penti vae chemeeta sacerdote reta itenondegua reta jare mboroyocui re oporomboe vae reta pe. Jae reta jeita amano vaerã, jare chemeeta judío mbae vae reta pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Jae reta cheyoyaita, chenupata chicote pe, undɨvɨta cheré, jare cheyucata. Ẽrei mbapɨ ara rupi aicove yeta ayu umanocue vae reta ipɨte güi —jei chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Cua jaɨcue rupi Zebedeo taɨ reta Jacobo jare Juan jee vae yugüeru Jesús cotɨ jare jei chupe: —Oporomboe vae, nduipota ndiyapo vaerã oreve nduyerureta ndeve jese vae. ");
INSERT INTO gnwNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","—¿Mbae pa pipota ayapo vaerã peve? —jei Jesús chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","—Ndiyembutuichaca yave, emaeño oreré nduguapɨ vaerã ndeyɨpɨ pe, penti ndeacata cotɨ jare ĩru ndeaso cotɨ —jei reta chupe. ");
INSERT INTO gnwNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","—Picuaa'ã mbae re piyerure vae —jei Jesús—. ¿Pepuereta pa piporara che aiporarata vae rami? ¿Pepuereta pa piyembɨbautizaca che ayembɨbautizacata vae rami? —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","—Orepuereta co —jei reta. —Añete pe reta piporarata che aiporarata vae rami, jare pe reta piyembɨbautizacata che ayembɨbautizacata vae rami —jei Jesús—. ");
INSERT INTO gnwNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ẽrei chepuere'ã jae peve peguapɨ vaerã cheyɨpɨ pe, penti cheacata cotɨ jare ĩru cheaso cotɨ. Echa'ã Tumpa umɨcuatɨ̃ro ma joco pe uguapɨta vae reta peguarã —jei chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Jare ĩru diez Jesús jemimboe reta cua uyandu yave, pochɨ reta Jacobo jare Juan pe. ");
INSERT INTO gnwNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jayave Jesús ueni reta. —Picuaa cavi co cua —jei chupe reta—. Mburuvicha ɨvɨ pegua reta oporoyocui, jare mbaepuere güɨnoi vae reta jei ĩru reta pe mbae uyapo vaerã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ẽrei pe reta agüɨye piyapo jucuarãi —jei—. Ime yave penti pepɨte pe oĩ vae uipota mbaepuere güɨnoi vae, tuyeyocui ĩru reta pe. ");
INSERT INTO gnwNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Jare ime yave penti pepɨte pe oĩ vae uipota tenondeguarã ico vae, tuyeyocui ĩru reta pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Echa'ã che cuimbaerã ayeyapo vae ayu ayeyocui vaerã ĩru vae reta pe. Ayu'ã ĩru vae reta uyeyocui cheve vaerã. Ayu amano vaerã, jeta vae aepɨ vaerã —jei chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jayave yugüɨraa uvãe tenta guasu Jericó pe. Jare Jesús oo ye Jericó güi jemimboe reta jare jeta vae reta ndive. Jare Timeo taɨ Bartimeo jee vae uguapɨ uyerure oĩ mbae re tape jembeɨ pe. Bartimeo co jae jesa mbae vae. ");
INSERT INTO gnwNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Jare uicuaa Jesús Nazaret pegua uasa oo oĩ yave, iñeeãta reve jei: —Cheparareco, Jesús. Nde co jae David iñemoñaa reta pegua —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Jeta joco pe ñugüɨnoi vae reta uñeengata chupe. Uipota tẽi umɨquĩi. Ẽrei jae jeiete iñeeãta reve jei: —David iñemoñaa reta pegua, cheparareco. ");
INSERT INTO gnwNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jayave Jesús uyemboɨ. —Peeni —jei. Jayave ueni reta jesa mbae vae. —Iñemɨatangãtu. Epũa. Nereni ma oĩ —jei reta chupe. ");
INSERT INTO gnwNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Jayave jesa mbae vae ueya iyasoya, jare upũa voi oo Jesús cotɨ. ");
INSERT INTO gnwNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesús upɨrandu chupe: —¿Mbae pa ndipota ayapo vaerã ndeve? —Tamae, oporomboe vae —jei jesa mbae vae. ");
INSERT INTO gnwNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jayave Jesús jei chupe: —Ndepuere ndeo. Ndecuera ma, nderovia cheré ramo —jei. Jupivoiño ipuere umae, jare oo Jesús jaɨcue tape rupi. ");
INSERT INTO gnwNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jare coiño ma Jerusalén güi ñugüɨnoi yave, yugüɨraa uvãe tenta guasu-raɨ reta Betfagé jare Betania iyɨpɨ pe, ɨvɨtu guasu Olivos jovai. Jayave Jesús oyocui mocui jemimboe reta: ");
INSERT INTO gnwNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","—Pecua pea tenta guasu-raɨ yanderovai oĩ vae pe —jei chupe reta—. Peo pevãe rupive, pevãeta penti mburica taɨrusu vae uñeñapɨ̃ti oĩ. Ndei ave etei quía opo jese. Piyora jare peru —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Jare ime yave quía jei peve vae: ‘¿Maera pa cua piyapo?’ pere chupe: ‘YandeYa uipota uiporu, ẽrei ɨmambae güeruruca yeta cua pe’ —pere, jei chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Jayave Jesús jemimboe reta yugüɨraa, jare uvãe mburica taɨrusu vae. Uñeñapɨ̃ti oĩ tape pe penti onque jovai. Jayave jae reta oyora. ");
INSERT INTO gnwNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Jare amocue joco pe ñugüɨnoi vae jei Jesús jemimboe reta pe: —¿Maera pa piyora peĩ mburica? ");
INSERT INTO gnwNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Jesús jemimboe reta jei chupe reta Jesús oyocui reta vae. Jayave joco pe ñugüɨnoi vae reta umaeño güɨraa vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Jayave güeru mburica taɨrusu vae Jesús oĩ vae pe. Jayave Jesús jemimboe reta oñono iyasoya mburica icupe re, jare Jesús opo jese. ");
INSERT INTO gnwNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Jare jeta vae uipɨso iyasoya tape rupi mburica jenonde, jare ĩru vae reta uyasɨa ñanaroquɨ jare oñono tape rupi. ");
INSERT INTO gnwNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Jare Jesús jenonde yugüɨraa vae reta jare jaɨcue rupi yugüɨraa vae reta iñeeãta reve jei: —¡Icavi co! Tuyembɨadoraca yandeYa jee re ou vae. ");
INSERT INTO gnwNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Oporoyocuita yandetenondegua David jee vae oporoyocui rami. Tuyembɨadoraca. Tei reta ‘icavi co’ ara pe —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jare Jesús oo uvãe Jerusalén pe, jare uique Tumpa jo pe. Joco pe umae opaete mbaembae re. Jare caaru ma yave, ou ye Betania pe jocua doce jemimboe reta ndive. ");
INSERT INTO gnwNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Pɨareve pe yugüɨraa ye Betania güi, jare Jesús iyembaɨ. ");
INSERT INTO gnwNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Jare mbɨrɨ güi uecha penti ɨva joquɨ reve, jare oo umae jese ime ra ía. Ẽrei uecha ia'ã, jaeño joquɨ. Echa'ã ndei uvãe ɨva ía vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Jayave Jesús jei ɨva pe: —Ndarau etei ma ndeía. Jare jemimboe reta uyandu. ");
INSERT INTO gnwNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jare yugüɨraa uvãe Jerusalén pe. Jayave Jesús uique Tumpa jo pe, jare umbɨpɨ omoẽ joco güi umaemee vae reta jare mbae ogua vae reta, jare umbɨyapara corepoti uipepɨca vae reta imesa reta jare pɨcasu reta umee vae reta jenda reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Jare umaeño'ã quía re jɨvɨta reve uguata vaerã Tumpa jo rupi. ");
INSERT INTO gnwNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Jare jei joco pe ñugüɨnoi vae reta pe: —Tumpa iñee pe uyecuatía oĩ cuarãi: ‘Chero uyembɨjeeta o opaete ɨvɨ pegua reta ipuere uyerure Tumpa pe pɨpe vaerã.’ Jucuarãi uyecuatía oĩ. Ẽrei pe reta piyapo ma imonda vae reta iñemia rami —jei chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Jayave sacerdote reta itenondegua reta jare mboroyocui re oporomboe vae reta cua uyandu yave, ueca quirãi ipuere uyucaca vaerã Jesús. Echa'ã jae reta uquɨye chugüi, opaete vae ipɨacañɨ iporomboe re ramo. ");
INSERT INTO gnwNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Jare pɨ̃tuɨpɨ yave, Jesús ou ye Jerusalén güi. ");
INSERT INTO gnwNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Pɨareve pe neimbove yave uasa yugüɨraa ye yave, uecha ɨva yɨpi ma iyɨpɨ güive. ");
INSERT INTO gnwNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Jayave Pedro imandúa jese, jare jei Jesús pe: —¡Emae, oporomboe vae! Ɨva pe ndere iata'ã ma vae yɨpi ma —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesús jei jemimboe reta pe: —Perovia Tumpa. ");
INSERT INTO gnwNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Añete che jae peve, yae yave cua ɨvɨtu guasu pe: ‘Ecua iyemombo ɨ guasu pe’, jare yae'ã yave yandepɨa pe: ‘Ndarau ndipo uyeyapo’, ẽrei yarovia yave yae vae uyeyapota, uyeyapota co yandeve —jei chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Jáeramo che jae peve, ime yave mbae pipota vae, piyerure Tumpa pe jese. Jare perovia yave Tumpa umeeta co peve, penoita co —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Jare piyerure peĩ Tumpa pe yave, pembɨasa ĩru icavi mbae vae uyapo pecotɨ vae pe, peRu ara pe oĩ vae umbɨasa vaerã vi peve pembaeyoa reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ẽrei pembɨasa'ã yave ĩru icavi mbae vae uyapo pecotɨ vae pe, peRu ara pe oĩ vae ndarau vi umbɨasa peve pembaeyoa reta —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jare yugüɨraa uvãe ye Jerusalén pe. Jare Jesús uguata rambueve Tumpa jo rupi, yugüeru jae oĩ vae pe sacerdote reta itenondegua reta, mboroyocui re oporomboe vae reta, jare tenta guasu pegua reta itenondegua reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Jae reta upɨrandu chupe: —¿Mbae nunga mbaepuere pa nenoi cua mbaembae ndiyapo vaerã? ¿Quía pa umee ndeve mbaepuere cua ndiyapo vaerã? —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jayave Jesús jei chupe reta: —Che vi tapɨrandu peve mbae re. Pemɨmbeu yave cheve, che vi amɨmbeuta peve mbae nunga mbaepuere anoi cua mbaembae ayapo vaerã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Quía pa ombou Juan upurumbɨbautiza vaerã? ¿Tumpa pa ombou? ani ¿ɨvɨ pegua reta pa ombou? Pemɨmbeu cheve —jei chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Jayave jae reta jei uyupe: —Yae yave: ‘Tumpa co ombou’, jae jeita yandeve: ‘Jucuarãi yave, ¿maera pa perovia'ã?’ ");
INSERT INTO gnwNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ani ¿yaeta pa: ‘Ɨvɨ pegua reta co ombou’? —jei reta. Ẽrei jae reta uquɨye tenta guasu pegua reta güi. Echa'ã opaete vae güɨrovia Juan co jae añetete penti Tumpa iñee umɨmbeu vae. ");
INSERT INTO gnwNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Jáeramo jei reta Jesús pe: —Nduicuaa'ã. —Che vi ndarau amɨmbeu peve mbae nunga mbaepuere anoi cua mbaembae ayapo vaerã —jei Jesús chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jayave Jesús umbɨpɨ imiari chupe reta umɨjaanga reve. —Ico penti cuimbae icorã uiquẽse vae, jare oñotɨ pɨpe jeta uva —jei—. Jayave oyoo ɨvɨ, jare uyapo uva uitami pɨpe vaerã. Uyapo vi penti chapapa, umae vaerã ɨvate güi opaete co re. Jayave uiporuca ico ĩru vae reta pe, jae reta uyandareco vaerã jese. Jayave co iya oo mbɨrɨ ambɨe ɨvɨ pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Jare uva yagüɨye ma yave, co iya ombou penti jembiocui co iporúa reta pe, jae reta umbɨyao vaerã tẽi uva chupe reta, iya güɨnoi vaerã imbaerã. ");
INSERT INTO gnwNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ẽrei jae reta uipɨsɨ uinupa co iya jembiocui, jare omondo ye. Umee'ã etei chupe güɨraa vaerã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Jayave co iya ombou ye tẽi ĩru jembiocui. Ẽrei co iporúa reta uyapi ita pe umbɨpere iñãca rupi, jare uyapo reta icavi mbae vae chupe. Jayave omondo ye —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Jayave co iya ombou ye tẽi ĩru jembiocui. Ẽrei co iporúa reta uyuca cua. Jare jucuarãiñoi uyapo reta jeta ĩru co iya jembiocui reta pe. Jae reta uinupa amocue vae, jare uyuca ĩru vae reta —jei Jesús—. ");
INSERT INTO gnwNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Co iya güɨnoi jaeño penti taɨ uau ete vae. Taɨcue ete ombou cua taɨ co iporúa reta pe. Co iya jei tẽi: ‘Aramoi jae reta uipɨuta cheraɨ’ —jei, jei chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ẽrei co iporúa reta jei uyupe: ‘Cua co jae iyarã vae. Yayuca, jare yande yaicota co iyarã’ —jei reta, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Jayave jae reta uipɨsɨ co iya taɨ uyuca omombo co güi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","¿Mbae ra uyapota co iya? —jei—. Outa, opa uyuca vaerã jocua co iporúa reta, jare uiporucata ico ambɨe vae reta pe —jei Jesús—. ");
INSERT INTO gnwNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","¿Pemɨngueta'ã pa cua Tumpa iñee pe uyecuatía oĩ vae? ‘Ita tenta iyapoa reta omombo vae uyeyapo ma ita tenondegua vae. ");
INSERT INTO gnwNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","YandeYa uyapo cua. Yaecha ma, jare yandepɨacañɨ jese.’ Jucuarãi uyecuatía oĩ —jei chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Jayave jocua uyapɨsaca jese vae reta uipota tẽi uipɨsɨ Jesús. Echa'ã uicuaa catu cua umɨjaanga reve jei vae uicuaaca quirãi jae reta teco güɨnoi. Ẽrei uquɨye tenta guasu pegua reta güi. Jáeramo ueyaño, jare yugüɨraa. ");
INSERT INTO gnwNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Jayave jae reta ombou amocue fariseo reta jare herodiano reta, uyavɨca vaerã tẽi chupe jae uyemɨngueta yave. ");
INSERT INTO gnwNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Jae reta yugüeru uvãe yave, jei Jesús pe: —Oporomboe vae, nduicuaa nde ndere vae añete co. Nde nemae oyovaque opaete pãve re. Nembutuicha'ã penti ave ĩru vae güi. Nde ndeporomboe cavi quirãi Tumpa uipota yaico vaerã vae re —jei reta—. César yandeocui yambɨepɨ vaerã chupe corepoti pe. ¿Jupi pa yambɨepɨ vaerã chupe? ani ¿jupi'ã pa? ¿Yambɨepɨta pa chupe? ani ¿yambɨepɨta'ã pa chupe? —jei reta Jesús pe. ");
INSERT INTO gnwNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ẽrei Jesús uicuaa jae reta uipota tẽi co umbɨtavɨ, jare jei chupe reta: —¿Maera pa pipota piyavɨca cheve? Peru cheve penti corepoti taecha —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Jae reta güeru chupe. Jayave jae upɨrandu chupe reta: —¿Quía jova íã pa cua? ¿Quía jee pa cua uyecuatía oĩ vae? —jei. —Cua César imbae co —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","—Pemee César pe César pegua, jare pemee Tumpa pe Tumpa pegua —jei Jesús chupe reta. Jare jae reta ipɨacañɨ jese. ");
INSERT INTO gnwNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Jayave yugüeru vi Jesús oĩ vae pe amocue saduceo reta. Opaete saduceo reta jei umanocue vae reta icove ye'ã co. Saduceo yugüeru vae reta jei Jesús pe: ");
INSERT INTO gnwNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Oporomboe vae, Moisés uicuatía ueya yandeve cuarãi: ‘Penti tɨqueɨ vae umano yave, jembirecocue mbaetɨ imembɨ chupe yave, cuimbae amɨri tɨvɨ tumenda jocua cuña ndive. Jayave cuña imembɨ yave, cuimbae tumbɨjee sambiaɨ tɨqueɨ amɨri jee pe.’ Jucuarãi uicuatía Moisés —jei reta chupe—. ");
INSERT INTO gnwNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ico penti cuimbae seis tɨvɨ reta güɨnoi vae. Cua cuimbae umenda, jare umano umɨmembɨ mbae reve —jei reta—. ");
INSERT INTO gnwNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Cuimbae amɨri jaɨcue rupigua umenda jembirecocue ndive, ẽrei umano vi umɨmembɨ mbae reve. Jae ramiño vi uyeyapo jaɨcue rupigua ye pe. ");
INSERT INTO gnwNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Opaete siete reve umenda jocua cuña ndive, jare opaete siete reve umano umɨmembɨ mbae reve. Taɨcue rupi cuña umano vi —jei reta—. ");
INSERT INTO gnwNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Jayave umanocue vae reta icove ye yave, ¿quía nunga vae jembirecorã pa icota jocua cuña? Echa'ã opaete siete reve umenda jae ndive —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","—Pe reta piyavɨ co —jei Jesús chupe reta—. Echa'ã picuaa'ã Tumpa iñee uyecuatía oĩ vae jare Tumpa imbaepuere —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Echa'ã umanocue vae reta icove ye yave, cuimbae reta jare cuña reta ndarau umenda. Yugüɨrecota ángel ara pe ñugüɨnoi vae reta yugüɨreco rami —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Tamɨmbeu peve umanocue vae reta regua. Icove yeta co. ¿Pemɨngueta'ã pa Moisés uicuatía vae? —jei—. Uyecuatía oĩ jocua yai regua, jare quirãi Tumpa jei Moisés pe jocua yai jendɨ vae ipɨte güi: ‘Che co Abraham, Isaac jare Jacob iTumpa’ —jei, jei chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Tumpa mbaetɨ co umanocue vae reta iTumpa. Jae co tecove güɨnoi vae reta iTumpa. Tuicha co piyavɨ —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ou vi Jesús oĩ vae pe penti mboroyocui re oporomboe vae. Uyandu uyeaca reta, jare uicuaa Jesús umɨmbeu cavi co chupe reta. Jayave jae upɨrandu Jesús pe: —¿Mbae nunga mboroyocui pa co jae tenondegua vae? —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesús jei chupe: —Mboroyocui tenondegua vae co cua: ‘Israel pegua, iyapɨsaca. YandeYa Tumpa, jaeño co Tumpa. ");
INSERT INTO gnwNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Eau ndeYa Tumpa opaete ndepɨa reve, opaete nderecove reve, opaete ndepɨayemɨngueta reve jare opaete nepɨrãta reve.’ Cua co jae mboroyocui tenondegua vae —jei chupe—. ");
INSERT INTO gnwNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Jare jaɨcue rupigua co cua: ‘Eau nderapicha nde ndiyerau rami.’ Mbaetɨ ĩru mboroyocui tenondegua cua reta güi vae —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Jayave mboroyocui re oporomboe vae jei Jesús pe: —Añete co, oporomboe vae. Icavi ndere Tumpa pentiño co jare mbaetɨ ye ĩru. ");
INSERT INTO gnwNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Jare yaau yave Tumpa opaete yandepɨa reve, opaete yanderecove reve, opaete yandepɨayemɨngueta reve jare opaete ñanepɨrãta reve, jare yaau yave yanderapicha yande yayerau rami, jocua icavi opaete maemɨmba Tumpa peguarã ñamee vae reta güi —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jare Jesús uyandu yave jae jei jupi cavi vae, jei chupe: —Jeta'ã uata ndiyeyocui vaerã Tumpa pe iporoyocuia pe. Jare mbaetɨ ma quía uipota upɨrandu chupe mbae re. ");
INSERT INTO gnwNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jare Jesús oporomboe oĩ Tumpa jo pe. —¿Maera pa jei mboroyocui re oporomboe vae reta Cristo co jae David iñemoñaa reta pegua? —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Echa'ã David etei jei Espíritu Santo rupi cuarãi: ‘YandeYa jei cheYa pe: Eguapɨ cheyɨpɨ pe cheacata cotɨ, nderovaicho reta opa amɨamɨri regua.’ Jucuarãi jei David aracae —jei Jesús—. ");
INSERT INTO gnwNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","¿Quirãi pa ipuere ico David iñemoñaa reta peguarã? Echa'ã David etei jei chupe: ‘CheYa’ —jei Jesús chupe reta. Jare jeta vae uyapɨsaca ñugüɨnoi Jesús re uyerovia reve. ");
INSERT INTO gnwNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jare Jesús oporomboe yave, jei chupe reta: —Piñemoa ngatu mboroyocui re oporomboe vae reta güi —jei—. Jae reta jecuaeño uipota uguata jemimonde pucu vae reve, jare jecuaeño uipota ĩru vae reta pe uyembɨsaludaca vaerã calle reta rupi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Yugüɨraa yave tupao pe jare parea pe, jecuaeño uipota uguapɨ tenda tenondegua vae reta pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Jare upɨ̃ro reta cuña ime umano vae reta güi opaete imbaembae, jare pucu uyerure Tumpa pe upurumbɨtavɨ vaerã —jei—. Jae reta uiporara eteta co —jei chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Penti ara Jesús uguapɨ oĩ corepoti jɨru jovai Tumpa jo pe, jare uecha quirãi jeta yugüeru vae reta oñono corepoti pɨpe. Icocatu vae reta oñono jeta corepoti. ");
INSERT INTO gnwNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Jare ou vi penti cuña ime umano vae iparavete vae. Jae oñono mocui riare. Jocua jeta'ã co jepɨ. ");
INSERT INTO gnwNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jare Jesús ueni jemimboe reta jare jei chupe reta: —Añete che jae peve, cua cuña ime umano vae iparavete vae uyapo jeta opaete ĩru oñono vae reta güi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Echa'ã opaete ĩru reta güeru oñono jeta güɨnoi vae güi. Ẽrei cua cuña, yepe tẽi iparavete, oñono opaete güɨnoi vae. Jocua co jembíu jepɨrã tẽi vae —jei chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jesús oẽ yave Tumpa jo güi, penti jemimboe jei chupe: —Mase, oporomboe vae, icavi cua ita reta jare o reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","—¿Nemae pa neĩ cua o tuicha vae reta re? —jei Jesús chupe—. Ndarau upɨta penti ave ita ĩru ita iárambo. Opaete uyeitɨta co —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jare Jesús uguapɨ oĩ rambueve ɨvɨtu guasu Olivos re Tumpa jo jovai, Pedro, Jacobo, Juan jare Andrés upɨrandu chupe, jae retaño jae ndive ñugüɨnoi yave: ");
INSERT INTO gnwNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Emɨmbeu oreve, ¿quirãi yave pa cua uyeyapota? Jare opaete cua uyeyapota ma yave, ¿quirãita pa nduicuaa? —jei reta chupe. ");
INSERT INTO gnwNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jayave Jesús jei chupe reta: —Piñemoa ngatu agüɨye vaerã petavɨ. ");
INSERT INTO gnwNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Echa'ã yugüeruta jeta cheree pe uyembɨjeeta vae reta. Jae reta jeita: ‘Che co jae Cristo.’ Jare umbɨtavɨta jeta vae reta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Imeta co ñerãro reta coiño pegüi. Imeta vi ñerãro reta mbɨrɨ pegüi. Piyandu yave cua reta regua, agüɨye pequɨye. Cua susere reta uyeyapoñotai co. Ẽrei cua susere reta ndei ave co opa vaerã —jei Jesús—. ");
INSERT INTO gnwNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Penti ɨvɨ pegua reta uñerãrota ambɨe ɨvɨ pegua reta ndive, jare mburuvicha reta uñerãrota ĩru mburuvicha reta ndive. Jare ɨvɨ tanta ucãtata jeta que rupi. Jare imeta caruai reta jare tecorai reta. Ẽrei cua susere reta uyembɨpɨ ramo co oĩ —jei chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Piñemoa ngatu. Echa'ã ĩru vae reta pereraata mburuvicha reta ñugüɨnoi vae pe, uñeapo vaerã peré. Jare penupata judío reta itupao reta pe. Jare pereraata mburuvicha guasu reta jovai chereco pegua, chemɨmbeu vaerã chupe reta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Jare Tumpa iñee icavi vae jerãcuata co rani opaete ɨvɨ pegua reta pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Jare ĩru vae reta pereraa yave pemee vaerã mburuvicha reta pe, agüɨye piyemɨpɨa'ã mbae pereta vae re —jei—. Pemee yave, Tumpa uicuaacata peve mbae pere vaerã. Jocuaño pere. Echa'ã Espíritu Santo pemborɨta piyemɨngueta vaerã, pe retaiño'ã co piyemɨnguetata —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Tɨqueɨ umeeta tɨvɨ, uyucaca vaerã. Jare tu umeeta isambiaɨ. Jare sambiaɨ reta oyovaichota tu jare ichɨ ndive, jare uyucacata reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Jare piñemɨtarẽɨcata opaete vae pe chereco pegua. Ẽrei jõsata oo uvãe iyapɨ pe vae uyembɨasacata co —jei chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Jare peechata icavi mbae vae opaete urucumegua vae uyemboɨ oĩ oĩta'ã tẽi vae pe. Tumpa iñee aracae umɨmbeu vae Daniel jei uyecuaata co. (Umɨngueta vae tuicuaa) —jei—. Jayave Judea pe ñugüɨnoi vae reta tosi ɨvɨtu guasu cotɨ —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Jare o cupe re oĩ vae ugüeyɨ yave, agüɨye tuique jo pe güɨraa vaerã imbaembae. ");
INSERT INTO gnwNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Jare ico pe oĩ vae agüɨye tou ye jenta pe güɨraa vaerã iyasoya —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Jare ipurúa vae reta jare umɨcambu vae reta uiporarata jocua ara reta pe —jei Jesús chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Piyerure Tumpa pe cuarãi: ‘Agüɨye emaeño tuyeyapo roɨ ma yave.’ ");
INSERT INTO gnwNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Echa'ã jocua ara reta pe ɨvɨ pegua reta uiporara eteta. Jucuarãi'ã uiporara reta Tumpa ɨvɨ uyapo güive, jare ndarau ye jucuarãi uiporara reta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Jare yandeYa uipota'ã yave opa vaerã jocua ara reta, mbaetɨta tẽi quía ipuere ico. Ẽrei Tumpa uiparavo vae reta jeco pegua opata jocua ara reta —jei chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Aramoi jocua ara reta pe quía jeita peve: ‘Mase, co oĩ Cristo’, ani jeita: ‘Mase, pee oĩ Cristo.’ Jucuarãi jei yave, agüɨye perovia —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Amocue upurumbɨtavɨ vae reta jeita: ‘Che co jae Cristo’, jare ĩru upurumbɨtavɨ vae reta jeita: ‘Che co jae penti Tumpa iñee umɨmbeu vae.’ Jare jae reta uyapota mɨacañɨ reta, umbɨtavɨ vaerã tẽi Tumpa uiparavo vae reta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Piñemoa ngatu. Amɨmbeu ma peve opaete, ndei uyeyapo mbove —jei chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Jayave opa uiporara reta jocua ara reta pe yave, guarasɨ uñemɨpɨ̃tumimbita, jare yasɨ ndarau ma jembipe. ");
INSERT INTO gnwNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Yasɨtata reta oata ara güi, jare opaete ara re mbaepuere güɨnoi vae reta ucãtata —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Jayave ɨvɨ pegua reta cherechata ayu amapɨ̃tu reve. Che cuimbaerã ayeyapo vae anoita mbaepuere tuicha vae, jare ayembɨadoracata opaete vae pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Jayave amondota ángel reta güeru vaerã aiparavo vae reta opaete ɨvɨ rupi güi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Yandepuere yamɨjaanga ɨva. Piyemboe jese —jei—. Joquɨ yave, picuaa uyaro ma co ama oquɨ vaerã —jei Jesús—. ");
INSERT INTO gnwNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Jae ramiño vi pe reta peecha yave cua mbaembae uyeyapo ñugüɨnoi vae, picuaata che coiño ma co aĩ —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Añete che jae peve, cua ɨvɨ pe añave yugüɨreco vae reta ndarau opa umano ndei opaete cua mbaembae uyeyapo mbove —jei chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ara jare ɨvɨ opata, ẽrei chiñee ndarau opa —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Ẽrei mbaetɨ quía uicuaa mbae ara pe ani mbae ora pe yepe cua uyeyapota, jaeño cheRu. Ángel ara pe ñugüɨnoi vae reta uicuaa'ã. Che co jae Tumpa Taɨ. Ẽrei che ave aicuaa'ã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Jecuaeño peãro, jare piyerure Tumpa pe. Echa'ã picuaa'ã quirãi yave ra uyeyapota —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Yamɨjaanga penti cuimbae oo ambɨe ɨvɨ pe vae. Oota ma jenta güi yave, umee mbaepuere jembiocui reta pe, jare oyocui penti penti uyapo vaerã iparavɨquɨ, jare oyocui vi taraquẽra jãroa uãro cavi vaerã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Picuaa'ã quirãi yave ra tenta iya ou yeta uvãe. Aramoi outa uvãe pɨ̃tu ave ma yave, ani pɨare catu yave, ani uru cuimbae uñee yave, ani neimbove yave —jei—. Jáeramo peãro peĩ, ");
INSERT INTO gnwNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","agüɨye vaerã, aramoiño ou uvãe yave, pepocou peque peĩ —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Jare cua jae peve vae jae vi opaete vae pe: Peãro peĩ —jei chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Mocui araño ma uata pascua uyapo reta vaerã. Jocua ara pe judío reta jou mbɨyape ovu mbae vae. Jare sacerdote reta itenondegua reta jare mboroyocui re oporomboe vae reta ueca ñugüɨnoi quirãi ipuere uipɨsɨ tavɨ rupi Jesús, uyucaca vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ẽrei jei reta: —Agüɨye yaipɨsɨ pascua ara rupi, agüɨye vaerã tenta guasu pegua reta uyapo tecorai. ");
INSERT INTO gnwNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jare Jesús ucaru oĩ rambueve Betania pe Simón ipire ocuise vae jenta pe, uique penti cuña. Jae güeru ɨru-raɨ ita alabastro jee vae pegua. Cua ɨru-raɨ tɨnee mbae ipiche cavi vae nardo jee vae pe. Cua nardo jepɨ ete. Cuña oyoca ɨru-raɨ, jare upɨyere nardo Jesús iñãca re. ");
INSERT INTO gnwNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Jayave amocue joco pe ñugüɨnoi vae pochɨ jare jei uyupe: —¿Maera pa umɨcañɨtei? ");
INSERT INTO gnwNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Umee yave corepoti re, güɨnoita tẽi trescientos ara mbaravɨquɨ jepɨ pegua umee vaerã iparavete vae reta pe —jei reta. Jayave iñera reta jese. ");
INSERT INTO gnwNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ẽrei Jesús jei chupe reta: —Pemaeño jese. ¿Maera pa pemambeco? Icavi vae co uyapo cheve —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Echa'ã yugüɨrecoñotai co iparavete vae reta pe reta ndive, jare pipota yave, pepuereta pemborɨ. Ẽrei che ndarau aicoño pe reta ndive —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Cua cuña uyapo ipuere vae. Chembɨpiche cavi ma, ndei añeñotɨca mbove —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Añete che jae peve, opaete ɨvɨ rupi Tumpa iñee icavi vae jerãcua vae rupi, cua uyapo vae vi jerãcuata, ĩru vae reta imandúa vaerã jese —jei chupe reta. (Mt 26.14-16; Lc 22.3-6) ");
INSERT INTO gnwNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Jayave jocua doce jemimboe reta güi penti Judas Iscariote jee vae oo sacerdote reta itenondegua reta ñugüɨnoi vae pe, umee vaerã Jesús chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Cua uicuaa reta yave, uyerovia reta, jare jei Judas pe umeeta co chupe corepoti. Jayave Judas umbɨpɨ ueca quirãi ipuere umee vaerã Jesús chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Pascua ara pe judío reta uyuca ovecha. Jocua ara umbɨpɨ jou mbɨyape ovu mbae vae. Jayave Jesús jemimboe reta jei chupe: —¿Quiape pa ndipota nduyapɨcatu vaerã, tembíu pascua pegua ndeu vaerã? ");
INSERT INTO gnwNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Jayave Jesús oyocui mocui jemimboe reta: —Pecua tenta guasu pe —jei chupe reta—. Peovãitita joco pe penti cuimbae ɨ güɨraa ɨru pe vae. Pecua jaɨcue —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Jare uique yave tenta pe, pere tenta iya pe: ‘Oporomboe vae jei: ¿Quiape pa ime oĩ o, joco pe jau vaerã tembíu pascua pegua cheremimboe reta ndive’ —jei, pere chupe, jei Jesús—. ");
INSERT INTO gnwNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Jayave tenta iya uechacata peve penti o tuicha vae jo ɨvate pe, opaete mbaembae yaiporuta vae reve. Joco pe piyapɨcatu yandeve —jei chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Jare Jesús jemimboe reta yugüɨraa uvãe yave tenta guasu pe, uvãe opaete Jesús jei chupe reta vae rami. Jare uyapo reta tembíu pascua pegua jou reta vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Jare pɨ̃tu ma yave, Jesús oo jocua doce jemimboe reta ndive. ");
INSERT INTO gnwNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Jare mesa pe uguapɨ ucaru ñugüɨnoi rambueve, Jesús jei chupe reta: —Añete che jae peve, penti pepɨte pe oĩ vae chemeeta cherovaicho reta pe. Jae co penti ucaru oĩ che ndive vae —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Jayave jae reta ipɨatɨtɨ, jare upɨrandu Jesús pe penti penti rupi: —¿Che pa co jae? ");
INSERT INTO gnwNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","—Pe reta co jae doce cheremimboe reta —jei Jesús chupe reta—. Penti pepɨte pe oĩ vae co jae. Mbɨyape umãquɨ oĩ che ndive plato pe vae co jae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Che cuimbaerã ayeyapo vae aañotai amano vaerã, Tumpa iñee pe uyecuatía oĩ cheregua rami. Ẽrei jocua cuimbae chemeeta vae uiporarata co. Icavi tẽi mona jocua cuimbae mbaetɨ ico yave —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Jare jae reta ucaru ñugüɨnoi rambueve, Jesús uipɨsɨ mbɨyape, jare umee yasurupai Tumpa pe. Jayave upɨsãa mbɨyape jare umee chupe reta. —Peu —jei chupe reta—. Cua co jae cherete —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Jayave Jesús uipɨsɨ vi penti copa, jare yasurupai umee ye yave Tumpa pe, umee jemimboe reta pe. Jare opareve jou copa güi. ");
INSERT INTO gnwNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Jesús jei chupe reta: —Cua co jae cherugüɨ. Cherugüɨ uyepɨyereta, Tumpa jei pɨau ye vae uyeyapo vaerã, jare jeta vae reta uyembɨasaca vaerã —jei Jesús—. ");
INSERT INTO gnwNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Añete che jae peve, ndarau ma jau uva tɨcuecue, Tumpa iporoyocuia pe uva tɨcuecue ipɨau vae jau regua —jei chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Jare opa yave ucanta reta Tumpa pe, oẽ reta yugüɨraa ɨvɨtu guasu Olivos cotɨ. ");
INSERT INTO gnwNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jayave Jesús jei chupe reta: —Opaete pe reta chereyata cua pɨ̃tu. Echa'ã Tumpa iñee pe uyecuatía oĩ cuarãi: ‘Ayucata ovecha reta iyandarecoa, jare ovecha reta opata uñemɨai.’ Jucuarãi uyecuatía oĩ —jei chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ẽrei aicove ye ayu yave umanocue vae reta ipɨte güi, aata perenonde Galilea pe —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Jayave Pedro jei Jesús pe: —Yepe tẽi opaete ĩru reta tandereya, ẽrei che ndarau ndueya. ");
INSERT INTO gnwNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","—Añete che jae ndeve —jei Jesús chupe—, cua pɨ̃tu etei, ndei mocui vese uru cuimbae uñee mbove, mbapɨ vese ma checuacuta —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ẽrei Pedro jeiete jei: —Yepe tẽi tamano nde ndive, ẽrei ndaraui nducuacu. Jare jucuarãi vi jei opaete Jesús jemimboe reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Jayave yugüɨraa uvãe reta Getsemaní pe. —Peguapɨ cua pe, che aa ayerure Tumpa pe rambueve —jei Jesús jemimboe reta pe. ");
INSERT INTO gnwNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Jayave güɨraa Pedro, Jacobo jare Juan, jare umbɨpɨ ipɨatɨtɨ jare uiporara. ");
INSERT INTO gnwNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","—Tuicha chepɨatɨtɨ, jare amano pota echa. Pepɨta cua pe, jare agüɨye peque —jei jocua mbapɨ jemimboe reta pe. ");
INSERT INTO gnwNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Jayave Jesús usɨrɨ catu chugüi reta, jare uyeatɨca ɨvɨ re. Uyerure Tumpa pe, Tumpa uipota yave, umbɨasa vaerã chugüi jocua uyeyapota chupe vae. ");
INSERT INTO gnwNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","—CheRu, cheRu, opaete mbae ndepuere ndiyapo. Embɨasa chegüi cua aiporarata vae. Ẽrei tuyeyapo cheve nde ndere vae. Agüɨye tuyeyapo che jae vae —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Jayave Jesús ou jemimboe reta ñugüɨnoi vae pe, jare uecha oque ñugüɨnoi. Jayave jei Simón Pedro pe: —Simón, ¿ndeque pa? ¿Ndepuere'ã pa ndeque mbae neĩ penti ora yepe? —jei chupe. ");
INSERT INTO gnwNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Jei vi jemimboe reta pe: —Agüɨye peque. Piyerure Tumpa pe, agüɨye vaerã peyoa. Pepɨa pe peratangãtu co, ẽrei perete iyaquɨ co —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Jayave Jesús usɨrɨ ye uyerure Tumpa pe tenonde uyerure vae rami. ");
INSERT INTO gnwNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Jayave ou ye jemimboe reta ñugüɨnoi vae pe, jare uecha oque ye ñugüɨnoi. Echa'ã jae reta jopeɨ ete ma. Jare uicuaa'ã mbae jei vaerã Jesús pe. ");
INSERT INTO gnwNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Jayave Jesús usɨrɨ ye mbapɨa re, jare ou ye yave, jei chupe reta: —Peque jare peputuuño ma. Jocuaño ma. Ora uvãe ma. Che cuimbaerã ayeyapo vae penti vae chemeeta cuimbae jeco pochɨ vae reta pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Pepũa. Yaaño ma. Mase, chemeeta vae coiño ma ou —jei chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jare uyemɨngueta oĩ rambueve, ou Judas - jae co jocua doce vae güi penti. Jeta vae yugüeru jae ndive iquɨsepucu reve jare iɨvɨra reve reve. Sacerdote reta itenondegua reta, mboroyocui re oporomboe vae reta, jare tenta guasu pegua reta itenondegua reta ombou Jesús pe cua reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Jare umeeta vae umɨmbeu ma ĩru reta pe mbae uyapota vae. Jei ma chupe reta: —Jocua ayurupɨteta vae co jae. Pipɨsɨ curi, jare peraa. Agüɨye tosi —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Judas ou uvãe yave, ou voi Jesús oĩ vae pe. —Oporomboe vae, oporomboe vae —jei chupe. Jayave uyurupɨte. ");
INSERT INTO gnwNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Jayave uipɨsɨ reta Jesús. ");
INSERT INTO gnwNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Jare penti cuimbae joco pe oĩ vae uequi iquɨsepucu jɨru güi, sacerdote tenondegua jembiocui re uiporu, jare uyasɨa inambi chugüi. ");
INSERT INTO gnwNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jayave Jesús jei yugüeru vae reta pe: —¿Maera pa peru quɨsepucu reta jare ɨvɨra reta chepɨsɨ vaerã, imonda vae pipɨsɨ vae rami? ");
INSERT INTO gnwNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Opa ara aico pe reta ndive Tumpa jo pe. Joco pe aporomboe, jare chepɨsɨ'ã. Ẽrei piyapo cua, Tumpa iñee uyecuatía oĩ vae uyeyapo vaerã —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Jayave opaete jemimboe reta ueya Jesús, jare opa osi. ");
INSERT INTO gnwNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Jare penti cunumi uñepẽgua penti asoya pe vae oo Jesús jaɨcue rupi. Jare amocue joco pe ñugüɨnoi vae reta uipɨsɨ tẽi. ");
INSERT INTO gnwNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ẽrei jae ueya iyasoya, jare nani etei oẽ osi. ");
INSERT INTO gnwNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Jayave güɨraa reta Jesús sacerdote tenondegua jenta pe. Jare joco pe uyembatɨ opaete sacerdote reta itenondegua reta, tenta guasu pegua reta itenondegua reta, jare mboroyocui re oporomboe vae reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Jare Pedro oo vi Jesús jaɨcue. Ẽrei mbɨrɨño oo chugüi. Jae uique sacerdote tenondegua joca pe, jare uguapɨ sacerdote tenondegua jembiocui reta ndive uyepee ñugüɨnoi tataɨpɨ pe. ");
INSERT INTO gnwNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Jare sacerdote reta itenondegua reta jare opaete ĩru mburuvicha reta ueca quía uñeapo vaerã Jesús re, uyucaca vaerã. Ẽrei uvãe'ã reta teco jese. ");
INSERT INTO gnwNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Yepe tẽi jeta vae iyapu reve uñeapo jese, ẽrei jei reta tẽi vae oyovaque'ã. ");
INSERT INTO gnwNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Jare amocue upũa uñeapo iyapu reve jese vae jei: ");
INSERT INTO gnwNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Ore nduyandu jei: ‘Ambusururuta Tumpa jo cuimbae reta uyapo vae, jare mbapɨ ara pe che ayapota ĩru Tumpa jo cuimbae reta uyapota'ã vae’ —jei, jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ẽrei yepe tẽi jucuarãi jei reta, ẽrei jei reta tẽi vae oyovaque'ã. ");
INSERT INTO gnwNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Jayave sacerdote tenondegua upũa uyemboɨ yatɨ vae reta ipɨte pe, jare upɨrandu Jesús pe: —¿Maera pa niñee nemoẽ'ã? ¿Mbae re pa cua reta uñeapo nderé? —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ẽrei Jesús quĩiño. Jei'ã mbae ave. Jayave sacerdote tenondegua upɨrandu ye chupe: —¿Nde pa co jae Cristo, Tumpa ombou vae? ¿Nde pa co jae Tumpa Taɨ? —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","—Jae co che —jei Jesús chupe—. Jare che cuimbaerã ayeyapo vae cherechata co aguapɨ aĩ Tumpa mbaepuere güɨnoi vae iyɨpɨ pe iyacata cotɨ. Cherechata vi ayu amapɨ̃tu reve —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Jayave sacerdote tenondegua cua uyandu yave, pochɨ ramo omondoro jemimondei, jare jei: —¿Maera ma pa yaeca yeta ĩru vae reta uñeapo vaerã jese? ");
INSERT INTO gnwNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Piyandu ma icavi mbae vae jei Tumpa cotɨ —jei—. ¿Mbae pa pere añave? —jei. Jayave opaete reve jei reta: —Icavi'ã co. Icavi co yayucaca vaerã —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Jare amocue vae umbɨpɨ undɨvɨ jese, jare uesañoma, jare ocua jese. Jare jei Jesús pe: —Emɨmbeu oreve quía ra ocua oĩ nderé. Jare sacerdote tenondegua jembiocui reta ocua vi jese. ");
INSERT INTO gnwNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Jare Pedro oca pe oĩ rambueve, ou penti cuñatai sacerdote tenondegua pe uyeyocui vae. ");
INSERT INTO gnwNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Jare uecha yave Pedro uyepee oĩ, omondo umae jese. —Nde vi co jae Jesús Nazaret pegua iĩru —jei chupe. ");
INSERT INTO gnwNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Jayave Pedro uicuacu Jesús. —Aicuaa'ã jocua cuimbae, jare aicuaa'ã mbae ndere vae —jei Pedro chupe. Jayave Pedro oo onque tuicha vae cotɨ. Jare uru cuimbae uñee. ");
INSERT INTO gnwNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Jayave cuñatai uecha ye, jare imiari jese joco pe ñugüɨnoi vae reta pe: —Cua cuimbae co jae penti Jesús iĩru —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ẽrei Pedro uicuacu ye. Jare ndei ɨma mbove joco pe ñugüɨnoi vae reta jei ye Pedro pe: —Añete nde co jae penti Jesús iĩru. Echa'ã nde vi co jae penti Galilea pegua. Nde ndiyemɨngueta jae reta uyemɨngueta vae rami —jei reta chupe. ");
INSERT INTO gnwNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Jayave Pedro jei Tumpa jee re: —Tumpa tuiporaraca cheve cua jae vae añetete'ã yave. Aicuaa'ã jocua cuimbae piyemɨngueta peĩ jese vae. ");
INSERT INTO gnwNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Jayave uru cuimbae uñee ma mocui vese. Jare Pedro imandúa Jesús jei chupe vae re: “Ndei mocui vese uru cuimbae uñee mbove, mbapɨ vese ma checuacuta.” Jare cua re ipɨa pe uyemɨngueta yave, umbɨpɨ uyao. ");
INSERT INTO gnwNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Jayave cõe rupive sacerdote reta itenondegua reta, tenta guasu pegua reta itenondegua reta, mboroyocui re oporomboe vae reta, jare opaete ĩru mburuvicha reta uyembatɨ uyemɨngueta ñugüɨnoi reta uyupii. Jayave uipocua Jesús jare güɨraa Pilato pe umee. ");
INSERT INTO gnwNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Jayave Pilato upɨrandu Jesús pe: —¿Nde pa co jae judío reta juvicha guasu? —Nde ndere rami jae co che —jei Jesús chupe. ");
INSERT INTO gnwNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Jayave sacerdote reta itenondegua reta uñeapo Jesús re jeta mbaembae re. ");
INSERT INTO gnwNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Jayave Pilato upɨrandu ye Jesús pe: —¿Maera pa niñee nemoẽ'ã? Mase, jeta mbaembae re uñeapo reta nderé —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ẽrei Jesús jei'ã mbae ave chupe. Jáeramo Pilato ipɨacañɨ jese. ");
INSERT INTO gnwNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Jare pascua ara rupi Pilato oyoracañoi penti pereso tenta guasu pegua reta uipota vae. ");
INSERT INTO gnwNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Jare peresorɨru pe ñugüɨnoi amocue upuruyuca vae reta. Cua reta upuruyuca, mburuvicha reta ndive uñerãro yave. Penti jee co Barrabás. ");
INSERT INTO gnwNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Jare jeta vae yugüeru uyerure Pilato pe uyapo vaerã chupe reta opa año uyapo rami. ");
INSERT INTO gnwNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Jayave Pilato jei chupe reta: —¿Pipota pa ayoraca vaerã peve judío reta juvicha guasu? ");
INSERT INTO gnwNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Echa'ã jae uicuaa sacerdote reta itenondegua reta umee Jesús chupe ñacatãa jese ramo. ");
INSERT INTO gnwNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ẽrei sacerdote reta itenondegua reta omboemboe yatɨ vae reta: —Piyerure Pilato pe oyoraca vaerã peve Barrabás. Agüɨye toyoraca Jesús —jei reta. Jayave jucuarãi uyerure reta Pilato pe. ");
INSERT INTO gnwNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Jayave Pilato upɨrandu chupe reta: —Barrabás ayoraca yave, ¿mbae pa pipota ayapo vaerã cua cuimbae judío reta juvicha guasu pere chupe vae pe? ");
INSERT INTO gnwNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Jayave jae reta iñeeãta reve jei: —Icutuca curusu re. ");
INSERT INTO gnwNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ẽrei Pilato upɨrandu chupe reta: —¿Mbae icavi mbae vae pa uyapo? Ẽrei jae reta jeiete iñeeãta reve jei: —Icutuca curusu re. ");
INSERT INTO gnwNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Jayave Pilato oyoraca chupe reta Barrabás, uipota umbɨyerovia reta ramo. Jare Pilato uinupaca yave Jesús chicote pe, umee sundaro reta pe, uicutu vaerã curusu re. ");
INSERT INTO gnwNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Jayave sundaro reta güɨraa Jesús juvicha joca palacio pe, jare ueni opaete ĩru sundaro reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Jayave sundaro reta omondeca Jesús pe temimonde pɨ̃ta vae, jare oñope yurãti catuii vae, jare umbapúa oñono Jesús iñãca re. ");
INSERT INTO gnwNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Jayave umbɨpɨ umbɨadora-raanga reta. —¡Viva, judío reta juvicha guasu! —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Jare uiporu reta iñãca re ɨvɨra. Jare undɨvɨ reta jese, jare uyeatɨca reta jae jovai umbɨadora-raanga vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Jare opa oyoyai reta yave, sundaro reta omboi chugüi temimonde pɨ̃ta vae, jare omondeca ye chupe jae jemimondei. Jayave güɨraa reta mburuvicha guasu joca güi, uicutu vaerã curusu re. ");
INSERT INTO gnwNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Penti cuimbae Simón jee vae tenta guasu Cirene pegua, Alejandro jare Rufo tu, ou uvãe tenta guasu cotɨ. Jocoropi uasa oo oĩ yave, sundaro reta güɨraaca chupe Jesús icurusu. ");
INSERT INTO gnwNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Jare sundaro reta güɨraa Jesús Gólgota jee vae pe. (Cua uipota jei: “Ãcacuerenda”.) ");
INSERT INTO gnwNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Jayave umee reta Jesús pe vino uyea mirra ndive vae. Ẽrei Jesús jou'ã. ");
INSERT INTO gnwNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Jayave sundaro reta uicutu curusu re. Jayave uyuguari reta Jesús jemimonde re, uicuaa vaerã mbae nunga penti penti güɨraa iyupe vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Jare neimbove yave nueve pe, uicutu reta Jesús curusu re. ");
INSERT INTO gnwNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Jare oñono reta curusu re Jesús iñãca iárambo uyecuatía mbae umbɨjeco jesegua vae: “Judío reta juvicha guasu.” ");
INSERT INTO gnwNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Jare sundaro reta uicutu vi curusu re mocui imonda vae reta, jare oñono penti Jesús iyacata cotɨ jare ĩru iyaso cotɨ. ");
INSERT INTO gnwNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Jare uyeyapo ma Tumpa iñee uyecuatía oĩ vae: “Ĩru vae reta jei tẽi jae vi co penti icavi mbae vae.” ");
INSERT INTO gnwNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Jare uasa vae reta uñeãcambɨvava reve jei icavi mbae vae Jesús pe. —Aa! —jei reta—. Nde ndere nembusururuta co Tumpa jo jare ndiyapo yeta mbapɨ ara pe. ");
INSERT INTO gnwNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Iyerepɨ añave, jare egüeyɨ curusu güi —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Jae ramiño vi sacerdote reta itenondegua reta jare mboroyocui re oporomboe vae reta imiari uyupe yave, oyoyai reta. —Jae uepɨ ĩru vae reta —jei reta—. Ẽrei ipuere'ã jae uyerepɨ. ");
INSERT INTO gnwNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Jae co Cristo, Tumpa ombou vae yave, jae co Israel pegua reta juvicha guasu yave, tugüeyɨ añave curusu güi, yaecha vaerã, jare yarovia vaerã —jei reta. Jare Jesús ndive uyecutu ñugüɨnoi vae reta vi jei icavi mbae vae chupe. ");
INSERT INTO gnwNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Jare guarasɨ ara mbɨte güive mbapɨ ora rupi uñemɨpɨ̃tumimbi opaete ɨvɨ pe. ");
INSERT INTO gnwNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Jayave mbapɨ ora ma caaru yave, Jesús iñeeãta reve jei: —Eloi, Eloi, ¿lama sabactani? (Cua uipota jei: “CheTumpa, cheTumpa, ¿maera pa chereya?”) ");
INSERT INTO gnwNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Amocue joco pe ñugüɨnoi vae uyandu jare jei tẽi: —Mase, Elías ueni. ");
INSERT INTO gnwNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Jare penti vae osi oo umãquɨ esponja vinagre pe, jare oñono ɨvɨra re, jare omondo Jesús iyuru cotɨ. —Peãro —jei—. Yaecha ou Elías umbɨgüeyɨ vaerã —jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jayave Jesús tanta usapɨcai, jare umano. ");
INSERT INTO gnwNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Jayave Tumpa jo umbɨyao vae osoro mbɨte rupi ɨvate güi ɨvɨ cotɨ. ");
INSERT INTO gnwNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Jare sundaro reta juvicha Jesús jovai uyemboɨ oĩ vae uecha yave quirãi usapɨcai jare umano, jei: —Añeteñoi yepe, cua cuimbae co jae Tumpa Taɨ. ");
INSERT INTO gnwNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Jare amocue cuña reta umae ñugüɨnoi mbɨrɨ güi. Cua reta ipɨte pe ñugüɨnoi María Magdalena, Salomé jare María. Cua María imembɨ reta co jae Jacobo taɨrusu vae jare José. ");
INSERT INTO gnwNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Jesús Galilea pe icose yave, cua cuña reta yugüɨraa jae ndive uyeyocui vaerã chupe. Jare jeta ĩru cuña yugüeru jae ndive Jerusalén pe vae reta joco pe ñugüɨnoi vi. ");
INSERT INTO gnwNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Jocua ara opaete judío reta uyeyapɨcatu ñugüɨnoi pɨareve peguarã. Echa'ã pɨareve pe co mbutuu ara. Jáeramo guarasɨ uique ma yave, ");
INSERT INTO gnwNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","penti cuimbae tenta guasu Arimatea pegua José jee vae uñemɨatangãtu oo Pilato pe, jare uyerure chupe Jesús jetecue re. José co jae penti mburuvicha. Opaete tenta guasu pegua reta uipɨu cua José. Jae uãro ico Tumpa iporoyocuia. ");
INSERT INTO gnwNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Jare Pilato ipɨacañɨ Jesús umano ma vae re. Jayave ueni sundaro reta juvicha, jare upɨrandu chupe quirãi yave ra umano Jesús. ");
INSERT INTO gnwNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Jare sundaro reta juvicha umɨmbeu chupe. Jayave Pilato jei José pe: —Ndepuere nderaa Jesús jetecue. ");
INSERT INTO gnwNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Jayave José ogua nieso. Jare umbɨgüeyɨ ma yave Jesús jetecue, oñoma nieso pe. Jayave oñono penti teõgüerɨru itape uyeyoo vae pe, jare umbɨyapayere ita tuicha vae teõgüerɨru jonque re. ");
INSERT INTO gnwNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Jare María Magdalena jare José ichɨ María jee vae uecha quiape oñono Jesús jetecue. ");
INSERT INTO gnwNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Mbutuu ara uasa ma yave, María Magdalena, Jacobo ichɨ María jee vae jare Salomé ogua mbae ipiche cavi vae, jare yugüɨraa uipichɨ vaerã Jesús jetecue re. ");
INSERT INTO gnwNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Jare neimbove asɨ domingo ara pe cua cuña reta yugüɨraa teõgüerɨru cotɨ. ");
INSERT INTO gnwNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Jare jei reta uyupe: —¿Quía ra umbɨsɨrɨta yandeve ita tuicha vae teõgüerɨru jonque güi? ");
INSERT INTO gnwNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ẽrei umae reta yave, uecha ita uyembɨsɨrɨ ma teõgüerɨru jonque güi. Jocua ita tuicha co. ");
INSERT INTO gnwNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Jare uique reta yave teõgüerɨru pe, uecha penti cunumi uguapɨ oĩ iyacata cotɨ. Jemimonde pucu jare tĩ. Jare ipɨacañɨ reta jese. ");
INSERT INTO gnwNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ẽrei cunumi jei chupe reta: —Agüɨye pepɨacañɨ. Peeca co peĩ Jesús Nazaret pegua uyecutuca curusu re vae. Jae icove ye ma ou umanocue vae reta ipɨte güi. Mbaetɨ ma cua pe oĩ. Mase, pemae jendacue re —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Pecua pere jemimboe reta pe jare Pedro pe: ‘Jae oota perenonde Galilea pe. Joco pe peechata, jae jei peve vae rami’ —pere chupe reta, jei. ");
INSERT INTO gnwNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Jayave cuña reta oẽ teõgüerɨru güi, jare tanta osi yugüɨraa. Uquɨye ramo umbɨpɨ urɨrɨ. Jare jei'ã mbae ave quía pe. ");
INSERT INTO gnwNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jesús icove ye ou umanocue vae reta ipɨte güi neimbove asɨ domingo ara pe. Jayave uyeechaca tenonde ete María Magdalena pe. Tenonde yave Jesús umbɨsɨrɨ siete aña reta cua cuña güi. ");
INSERT INTO gnwNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","María oo umɨmbeu Jesús ndive yugüɨrecose vae reta pe. Jae reta ipɨatɨtɨ ramo uyao ñugüɨnoi. ");
INSERT INTO gnwNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","María jei chupe reta: —Jesús icove ye ma oĩ. Aecha ma —jei chupe reta. Ẽrei uyandu yave, güɨrovia'ã reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Cua jaɨcue rupi Jesús uyeechaca mocui jemimboe reta pe, jae reta yugüɨraa rambueve tape rupi tenta mbae vae cotɨ. Ambɨe vae echa Jesús chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Jae reta yugüeru ye tenta guasu pe umɨmbeu ĩru reta pe. Ẽrei jeseve güɨrovia'ã reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Cua jaɨcue rupi Jesús uyeechaca jocua once jemimboe reta pe etei, jae reta ucaru ñugüɨnoi rambueve, jare uñeengata chupe reta, upurugüɨrovia'ã jare ipɨatanta ramo. Echa'ã ĩru vae reta uecha Jesús, icove ye yave ou umanocue vae reta ipɨte güi, jare umɨmbeu tẽi jemimboe reta pe. Ẽrei jae reta güɨrovia'ã. ");
INSERT INTO gnwNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Jayave Jesús jei chupe reta: —Pecua opaete ɨvɨ rupi. Pemɨmbeu Tumpa iñee icavi vae opaete ɨvɨ pegua reta pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Jocua güɨroviata jare uyembɨbautizacata vae uyembɨasacata. Ẽrei jocua güɨrovia'ã vae ucañɨteita co —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Jare ĩru vae reta uechata güɨrovia vae reta uyapo ñugüɨnoi cua nunga mɨacañɨ reta. Cheree re jae reta umbɨsɨrɨta aña reta oya jese vae reta güi. Uyemɨnguetata ambɨe ñee pe. ");
INSERT INTO gnwNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Uipɨsɨta mboi reta. Jou yave imbayachi vae, ndarau mbae uyeyapo chupe reta. Oñonota ipo imbaerasɨ vae reta re umbɨgüera vaerã —jei chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Jayave yandeYa opa uyemɨngueta yave jae reta ndive, oo ara pe, jare uguapɨ Tumpa iyɨpɨ pe iyacata cotɨ. ");
INSERT INTO gnwNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Jare jemimboe reta yugüɨraa umɨmbeu Tumpa iñee opaete que rupi. Jare yandeYa omborɨ, jare uicuaaca ĩru vae reta pe jemimboe reta jei vae añete vae mɨacañɨ reta uyapo vae rupi. Jaeño ma.");
INSERT INTO gnwNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Jeta vae umɨmbeu ma uicuatía reve opaete yandepɨte pe uyeyapo vae regua. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Jocua uyeyapo vae iyɨpɨ güive uecha vae reta jucuarãi umɨmbeu yandeve. Echa'ã jae reta umɨmbeu Tumpa iñee ĩru vae reta pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Jáeramo icavi echa cheve che vi aicuatía vaerã ndeve, mburuvicha Teófilo, amɨmbeu vaerã ndeve quirãi opaete uyeyapo. Echa'ã che aicuaa cavi opaete iyɨpɨ güive uyeyapo vae. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Aicuatía aĩ ndeve cua, ndicuaa vaerã añete co jocua ndiyemboe jese vae. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Herodes ico yave ɨvɨ Judea pegua reta juvicha guasurã, ico vi penti sacerdote Zacarías jee vae. Jae co sacerdote penti atɨ Abías jee vae pegua. Zacarías jembireco co jae Aarón iñemoñaa reta pegua jare jee co Elisabet. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Zacarías jare jembireco uyapo jupi vae jare jucuarãi umbɨyerovia Tumpa. Echa'ã jecuaeño uyapo yandeYa iporoyocui reta. Mbaetɨ quía ipuere umbɨjeco reta mbae re. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ẽrei mbaetɨ co Zacarías isambiaɨ. Echa'ã Elisabet imembɨ mbae vae co. Jare Zacarías jare Elisabet ucuacuaa ete ma. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Penti ara penti atɨ Abías jee vae pegua sacerdote reta uparavɨquɨ ñugüɨnoi Tumpa jo pe. Jáeramo Zacarías uyapo oĩ iparavɨquɨ joco pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Jare jocua ara Zacarías iparavɨquɨ co uique vaerã yandeYa jo japɨpe pe etei uapɨ vaerã mbae ipiche cavi vae. Echa'ã jecuaeño uyapo jucuarãi sacerdote reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Jare jeta Israel pegua reta yatɨ ma uyerure ñugüɨnoi Tumpa jo oca pe, Zacarías mbae ipiche cavi vae uapɨ oĩ rambueve. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Jare uyecuaa Zacarías pe penti ángel yandeYa pe uyeyocui vae. Ángel uyemboɨ oĩ mbae ipiche cavi vae imesa iyacata cotɨ. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Jare Zacarías uecha yave ángel, ipɨacañɨ jare uquɨye vi. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ẽrei ángel jei chupe: —Agüɨye equɨye, Zacarías. Tumpa uyandu ma ndiyerure, jare nembireco Elisabet imembɨta ndeve cuimbae. Jare nembɨjeeta Juan —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Jare nde ndiyeroviata co tuicha. Jare jeta vi uyeroviata jae oa vae regua —jei ángel Zacarías pe—. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Echa'ã yandeYa umbutuichacata co. Jae ndarau etei ucau. Jare tɨneeta Espíritu Santo pe ichɨ güi oa güive —jei chupe—. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Jare umbɨyerovata yandeYa Tumpa cotɨ jeta Israel pegua reta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Jae oota yandeYa jenonde uauca vaerã tu reta pe isambiaɨ reta jare Tumpa jei vae uyapo'ã vae reta uyeyapo vaerã iyaracuaa vae retarã jare jupi vae retarã. Jucuarãi uyapota, Israel pegua reta uãro vaerã yandeYa. Jae icota Elías icose vae rami jare güɨnoita mbaepuere Elías güɨnoise vae rami —jei ángel Zacarías pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Jayave Zacarías jei ángel pe: —¿Quirãita pa aicuaa añetete ra cua nde ndere cheve vae? Echa'ã che acuacuaa ete ma jare chembireco ucuacuaa ete ma vi —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Jayave ángel jei ye Zacarías pe: —Che co jae Gabriel. Che ayeyocui Tumpa pe. Tumpa chembou chemiari vaerã ndeve jare amɨmbeu vaerã ndeve cua ñee icavi vae —jei chupe—. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Mase, niñeeta'ã ndepɨta cua amɨmbeu ndeve vae uyeyapo regua. Echa'ã nderovia'ã che jae ndeve vae. Ẽrei che jae ndeve vae uyeyapota co ara ou uyeyapo vaerã yave —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Jare Israel pegua reta uãro ñugüɨnoi Zacarías oẽ vaerã Tumpa jo güi, jare ipɨacañɨ reta quirãi Zacarías upɨta ɨma Tumpa jo japɨpe pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Jare Zacarías oẽ yave, ipuere'ã omoẽ iñee chupe reta. Jáeramo jae reta uicuaa Zacarías uecha mbae Tumpa jo pe oĩ rambueve. Echa'ã jae umupũa ipo chupe reta. Ẽrei ipuere'ã etei mbae jei chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Jare opa ma yave Zacarías iparavɨquɨ Tumpa jo pe, oo ye jenta pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Jare mbovɨ ara rupi Zacarías jembireco Elisabet ipurúa. Jayave Elisabet uñemi pandepo yasɨ jenta pe. Echa'ã jae jei: ");
INSERT INTO gnwNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","—Cuarãi yandeYa uyapo cheve. Ɨma ma chemara ĩru vae reta güi chemembɨ'ã etei ramo. Ẽrei añave yandeYa chemborɨ agüɨye vaerã chemara chugüi reta —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Jare Elisabet seis yasɨ ma ipurúa yave, Tumpa ombou ángel Gabriel tenta guasu Nazaret ɨvɨ Galilea pegua pe ");
INSERT INTO gnwNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","María ipɨ. María co jae penti cuñatai güɨreco'ã etei cuimbae vae. Ẽrei jae jei ma umenda vaerã José ndive. José co jae penti David iñemoñaa reta pegua. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Jare ángel uique María oĩ vae pe jare jei chupe: —Iyerovia. YandeYa ipɨacavi ndeve. YandeYa oĩ nde ndive. YandeYa nemɨvendise ete ĩru cuña reta güi —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","María cua uyandu yave, ipɨacañɨ. Echa'ã uicuaa'ã mbae ra uipota jei ángel jei chupe vae. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Jayave ángel jei chupe: —Agüɨye equɨye, María. Echa'ã Tumpa ipɨacavi ndeve —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Mase, ndepuruata co jare nemembɨta. Jare nembɨjeeta nemembɨ Jesús —jei María pe—. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Jae güɨnoita mbaepuere tuicha vae, jare jeeta co Tumpa Taɨ. Jare yandeYa Tumpa uyapota Israel pegua reta juvicha guasurã itenondegua David rami —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Jare jae icota Jacob iñemoñaa reta juvicha guasurã jaeño mai pegua. Jare jae iporoyocuia ndarau opa —jei ángel chupe. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Jayave María jei ángel pe: —¿Quirãita pa uyeyapo cua? Echa'ã ndei areco cuimbae —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Jayave ángel jei María pe: —Espíritu Santo outa ndeve. Tumpa imbaepuere rupi cua uyeyapota ndeve. Jáeramo nemembɨ oata iyoa mbae reve jare jeeta co Tumpa Taɨ —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Mase, nerentarã Elisabet ipurúa vi, yepe tẽi ucuacuaa ete ma. Seis yasɨ ma ipurúa oĩ, yepe tẽi ĩru vae reta umbɨjee ‘Imembɨ mbae vae’ —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Echa'ã Tumpa ipuere uyapo opaete —jei chupe. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Jayave María jei ángel pe: —Mase, che co jae yandeYa pe ayeyocui vae. Tome tuyeyapo cheve nde ndere cheve vae rami —jei. Jayave ángel oo ye María oĩ vae güi. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Jayave mbovɨ ara rupi María oẽ oo voi jenta güi penti tenta guasu ɨvɨtu reta re Judea pegua pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Jare oo uvãe Zacarías jenta pe, jare umbɨsaluda Elisabet. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Jare Elisabet uyandu yave María jei chupe vae, Elisabet imembɨ omɨ rai jɨe pe. Jare Elisabet tɨnee Espíritu Santo pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Jayave Elisabet iñeeãta reve jei: —Tumpa nemɨvendise ete ĩru cuña reta güi. Jare umɨvendiseta nemembɨ —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Jare yepe tẽi nde co jae cheYa ichɨrã, ẽrei nde ndeyu ndepou chepɨ. Chepɨacañɨ cua re —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Mase, nde nembɨpɨ chemɨngueta rupive, chemembɨ omɨ rai cherɨe pe uyerovia ramo —jei Elisabet María pe—. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Nde nderovia yandeYa uyapota co jae jei ndeve uyapota vae. Jáeramo jae nemɨvendise ma —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Jayave María jei: “Ambɨadora yandeYa. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ayerovia Tumpa re. Jae co chembɨasa vae. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Yepe tẽi che cheparavete, ẽrei jae cheparareco. Mase, añave güive opaete vae jeita Tumpa chemɨvendise co. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Echa'ã Tumpa imbaepuere tuicha co. Jae uyapo icavi vae cheve imbaepuere pe. Jae co iyoa mbae vae jee vae. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Jare Tumpa uiparareco opaete uipɨu Tumpa vae reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Uicuaaca quirãi imbaepuere tuicha co. Opa umɨai uyembɨcate vae reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Jae uequi imbaepuere mburuvicha reta güi, jare umbutuichaca uñemɨmichi vae reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Umɨngapɨɨ iyembaɨ vae reta tembíu icavi vae pe. Ẽrei umee'ã co mbae icocatu vae reta pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Omborɨ Israel pegua uyeyocui chupe vae reta. Echa'ã imandúa quirãi jei uipararecota co. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Echa'ã jucuarãi jei yandetenondegua reta pe - jae reta co Abraham jare iñemoñaa reta. Echa'ã jei chupe reta uipararecota co jaeño mai pegua” —jei María. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Jare María upɨta Elisabet ipɨ mbapɨ yasɨ pegua. Jayave ramo oo ye jenta pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Jare ara ou uvãe yave Elisabet imembɨ vaerã, oa imembɨ cuimbae. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Jare jerãcua Elisabet jentaɨgua reta jare jentarã reta pe quirãi yandeYa uiparareco Elisabet. Jare jae reta uyerovia Elisabet ndive. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Jare sambiaɨ ocho ara ma güɨnoi yave, jentarã reta yugüeru umɨcircuncidaca vaerã. Jare jae reta uipota oñono jese tu jee Zacarías. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ẽrei sambiaɨ ichɨ jei chupe reta: —Jucuarãi'ã co. Yambɨjeeta co Juan. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ẽrei jae reta jei chupe: —Mbaetɨ etei co nerentarã jocua tee güɨnoi vae. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Jayave jae reta iñãca omomɨ Zacarías pe upɨrandu vaerã chupe mbae nunga tee ra uipota oñono taɨ re. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Jayave Zacarías uechaca chupe reta jae uipota mbae uicuatía jese vae. Jayave uicuatía cuarãi: “Jee co Juan.” Jare opaete joco pe ñugüɨnoi vae reta ipɨacañɨ. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Jayave jupivoi Zacarías ipuere omoẽ ye iñee. Jare imiari chupe reta umbɨadora reve Tumpa. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Jare opaete Zacarías jentaɨgua reta ipɨacañɨ cua re. Jare opaete cua uyeyapo vae jerãcua opaete ɨvɨtu Judea pegua reta rupi. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Jare opaete uyandu vae reta ipɨa pe uyemɨngueta cua uyeyapo vae re jare jei reta iyupe: —¿Mbae nunga sambiaɨ ra co aipo cua? Echa'ã yandeYa imbaepuere oĩ jae ndive. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Jayave Zacarías - jae co Juan tu - tɨnee Espíritu Santo pe jare umɨmbeu Tumpa iñee. Echa'ã jae jei: ");
INSERT INTO gnwNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Tuyembɨadoraca yandeYa Tumpa. Yande co jae Israel pegua reta. Echa'ã Tumpa ipɨacavi yandeve ramo, yanderepɨ ma. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Jae ombou yandeve jembiocui David iñemoñaa reta pegua yanembɨasa vaerã imbaepuere tuicha vae pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Jucuarãi Tumpa jei iyɨpɨ güive Tumpa iñee umɨmbeu vae reta rupi. Jae reta uñeñono tee Tumpa peguarã. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Tumpa yanembɨasata yanderovaicho reta güi. Jae yanembɨasata opaete ñanemɨtarẽɨ vae reta güi. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","73","Tumpa uiparareco Abraham jare ĩru yandetenondegua reta. Echa'ã Tumpa etei uyemɨngueta Abraham ndive, jare añave imandúa ma jocua jei uyapota vae re. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Jáeramo umeeta yandeve yayeyocui vaerã chupe yaquɨye mbae reve. Echa'ã jae yanderepɨta yanderovaicho reta güi” —jei Zacarías—. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","“Tumpa ñaneñono teeta iyupeguarã jare yayapota jupi vae, jare jae icota yande ndive cua ɨvɨ pe yaico rambueve. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Jare ĩru vae reta uyemɨngueta nderé yave, jeita: ‘Jae co penti Tumpa iñee umɨmbeu vae.’ Echa'ã nde, cheraɨ, ndeota yandeYa jenonde ndiyapɨcatu vaerã japerã. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Nemɨmbeuta yandeYa imbae reta pe quirãi Tumpa umbɨasata chupe reta imbaeyoa reta jare jucuarãi uyembɨasacata. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Cuarãi Tumpa uyapota, yandeparareco ramo. Jare ipuruparareco jeco pegua ombouta yanembɨasa vaerã, opa ara rupi ombou guarasɨ yanemborɨ vaerã rami. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Jae yanemborɨta guarasɨ jembipe yanemborɨ rami. Echa'ã guarasɨ umee yandeve tembipe agüɨye vaerã yaico pɨ̃tumimbi pe. Jae yanemborɨta agüɨye vaerã yaquɨye mano güi. Jae yanemborɨta yaico vaerã yandepɨacatu reve” —jei Zacarías. ");
INSERT INTO gnwNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Jare sambiaɨ ucuacuaa, jare uñemɨatangãtu Tumpa cotɨ. Jare ico ñana rupi uyecuaa Israel pegua reta pe regua. ");
INSERT INTO gnwNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Juan ichɨ güi oa yave, romano reta juvicha guasu Augusto César jee vae oyocui opaete vae uyepapaca vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Jaeramo opaete vae uyepapaca Cirenio ico ɨvɨ Siria pegua reta juvicha guasurã yave. ");
INSERT INTO gnwNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Jare opaete vae yugüɨraa itenondegua jenta guasu pe uyepapaca vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Jare José vi oo Nazaret Galilea pegua güi tenta guasu Belén Judea pegua pe. Echa'ã jae co David iñemoñaa reta pegua, jare David jenta guasu co jae Belén. ");
INSERT INTO gnwNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Jáeramo José oo Belén pe uyepapaca vaerã, jare güɨraa jembireco María. Jare María ipurúa ma. ");
INSERT INTO gnwNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Jare Belén pe ñugüɨnoi rambueve, ara ou uvãe María imembɨ oa vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Jare María imembɨrɨpɨ cuimbae oa. Jayave María oñoma penti ñomaa pe jare umbɨyapacua penti maemɨmba icaruarɨru pe. Echa'ã mbaetɨ co José jare María jendarã tenta pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Jare jocua pɨ̃tu amocue ovecha iyandarecoa reta uyandareco ñugüɨnoi iovecha reta re ñana rupi coiño tenta guasu Belén güi. ");
INSERT INTO gnwNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Jare uyecuaa chupe reta penti ángel yandeYa pe uyeyocui vae, jare jembipe jae reta ñugüɨnoi vae pe. Echa'ã yandeYa imbaepuere uyecuaa chupe reta. Jare jae reta uquɨye ete. ");
INSERT INTO gnwNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Jayave ángel jei chupe reta: —Agüɨye pequɨye. Mase, amɨmbeuta peve ñee icavi vae tuicha rupi piyerovia vaerã. Cua ñee opaete vae peguarã co —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Echa'ã cua pɨ̃tu oa upurumbɨasa vae David jenta guasu pe. Jae co yandeYa Cristo, Tumpa ombou vae —jei ángel chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Jare cuarãi picuaata: Pevãeta sambiaɨ uñeñoma oĩ penti ñomaa pe jare uyapacua oĩ penti maemɨmba icaruarɨru pe —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Jare jupivoi uyecuaa jocua ángel ndive jeta ete ángel reta. Opaete vae umbɨadora Tumpa. Echa'ã jei reta: ");
INSERT INTO gnwNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Tuyembɨadoraca Tumpa ara pe oĩ vae, jare ɨvɨ pegua reta Tumpa ipɨacavi chupe reta vae tipɨacatu” —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Jare ángel reta yugüɨraa ye yave chugüi reta ara pe, ovecha iyandarecoa reta jei uyupe: —Yaa Belén pe yaecha vaerã cua uyeyapo vae. Echa'ã yandeYa uicuaaca yandeve —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Jayave javoi pegua yugüɨraa joco pe, jare uvãe María jare José jare sambiaɨ. Jocua sambiaɨ uyapacua oĩ maemɨmba icaruarɨru pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Jare uecha ma yave, yugüɨraa ye umɨmbeu ĩru vae reta pe ángel jei chupe reta jocua sambiaɨ re vae. ");
INSERT INTO gnwNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Jare opaete uyandu vae reta ipɨacañɨ ovecha iyandarecoa reta umɨmbeu chupe reta vae re. ");
INSERT INTO gnwNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ẽrei María imandúa opaete cua re jare ipɨa pe uyemɨngueta cavi jese. ");
INSERT INTO gnwNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Jare ovecha iyandarecoa reta yugüɨraa ye Belén güi. Umbɨadora reta Tumpa jare umee yasurupai chupe opaete uyandu jare uecha vae re. Echa'ã jae reta uecha ma sambiaɨ ángel jei chupe reta rami. ");
INSERT INTO gnwNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Jare sambiaɨ ocho ara ma güɨnoi yave, tu jare ichɨ umɨcircuncidaca jare umbɨjee Jesús. Echa'ã ángel umɨmbeu María pe jucuarãi umbɨjee vaerã ndei María ipurúa mbove. ");
INSERT INTO gnwNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Jare ara ou uvãe María oo vaerã yandeYa jo pe uyeyoeca vaerã yandeYa cotɨ. Echa'ã jucuarãi uyecuatía oĩ Moisés iporoyocui pe cuña imembɨ vae uyapo vaerã. Jayave tu jare ichɨ güɨraa Jesús tenta guasu Jerusalén pe yandeYa jo pe oñonoca tee vaerã Tumpa peguarã. ");
INSERT INTO gnwNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Echa'ã yandeYa iporoyocui pe uyecuatía oĩ cuarãi: “Cuña imembɨrɨpɨ cuimbae oa yave, sambiaɨ uñeñono teeta yandeYa peguarã.” Jucuarãi uyecuatía oĩ. ");
INSERT INTO gnwNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Jáeramo Jesús tu jare ichɨ uyucaca umee vaerã yandeYa pe mocui güɨra tórtola jee vae ani mocui pɨcasu taɨrusu vae. Echa'ã jucuarãi jei uyapo vaerã mboroyocui yandeYa umee chupe reta vae pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Jare jocua ara penti cuimbae Jerusalén pegua Simeón jee vae oĩ Tumpa jo pe. Simeón jecuaeño uyapo jupi vae jare umbɨadora Tumpa. Jae uãro oĩ omborɨta Israel pegua reta vae ou vaerã. Jare jae tɨnee Espíritu Santo pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Jare Espíritu Santo uicuaaca ma Simeón pe quirãi ndarau umano ndei uecha Cristo yandeYa ombouta vae mbove. ");
INSERT INTO gnwNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Jare jocua ara Espíritu Santo uicuaaca ma Simeón pe oo vaerã uique Tumpa jo pe. Jare Jesús tu jare ichɨ güɨraa Jesús uruique Tumpa jo pe uyapo vaerã mboroyocui jei vae rupi. ");
INSERT INTO gnwNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Jayave Simeón ovoɨ Jesús jare umbɨadora Tumpa. Jae jei: ");
INSERT INTO gnwNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“CheYa, jecuaeño ayeyocui ndeve. Añave ndepuere nemaeño cheré amano vaerã chepɨacatu reve. Echa'ã cuarãi nde ndere cheve uyeyapota co. ");
INSERT INTO gnwNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Aecha ma upurumbɨasa vae nde nembou vae. ");
INSERT INTO gnwNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Nde ndiparavo opaete vae peguarã. ");
INSERT INTO gnwNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Jae co penti tembipe rami. Ime tembipe yave, yaecha cavi mbaembae. Jae ramiño vi jae ndecuaaca cavita judío mbae vae reta pe. Jare Israel pegua reta uyepɨucata jae jeco pegua. Echa'ã Israel pegua reta nembae reta co” —jei Simeón. ");
INSERT INTO gnwNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Jare José jare Jesús ichɨ ipɨacañɨ Simeón jei Jesús re vae re. ");
INSERT INTO gnwNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Jare Simeón jei Tumpa tumɨvendise José jare María. Jayave jei María pe: —Mase, Tumpa uiparavo ma cua nemembɨ. Jae uicuaacata Israel pegua reta pe quía co jae. Ẽrei jeta Israel pegua reta güɨrɨ̃rota jare jeta vae güɨroviata jese —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Echa'ã uyecuaata opaete vae ipɨa pe oĩ vae. Jare nde etei ndepɨatɨtɨ eteta jese —jei Simeón María pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Jare ico vi penti cuña Ana jee vae. Jae co Fanuel tayɨ. Jocua Fanuel co jae penti atɨ Aser jee vae pegua. Ana co jae Tumpa iñee umɨmbeu vae. Ucuacuaa ete ma. Jaeño siete año ico ime ndive. ");
INSERT INTO gnwNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Echa'ã jayave ime umano chugüi. Ana güɨnoi ma ochenta y cuatro año. Jecuaeño ico Tumpa jo pe jare uyeyocui Tumpa pe. Echa'ã uyecuacu tembíu güi jare uyerure Tumpa pe ara rupi jare pɨ̃tu rupi. ");
INSERT INTO gnwNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Jae ou uvãe José jare María jare Jesús ñugüɨnoi vae pe. Jayave jae vi umee yasurupai yandeYa pe, jare imiari Jesús re opaete Jerusalén pegua uãro ñugüɨnoi Cristo ou uepɨ vaerã vae reta pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Jare José jare María uyapo yandeYa jo pe opaete yandeYa iporoyocui jei uyapo vaerã vae. Jayave yugüɨraa ye Galilea pe jae jenta guasu Nazaret pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Jare sambiaɨ ucuacuaa jare jatangãtu. Iyaracuaa catu vi. Jare Tumpa ipɨacavi oĩ jae ndive. ");
INSERT INTO gnwNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Jare opa año Jesús tu jare ichɨ yugüɨraa Jerusalén pe pascua ara pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jare Jesús doce año ma güɨnoi yave, oo jae reta jupíe pascua peguarã, jae reta jecoño mai uyapo vae rami. ");
INSERT INTO gnwNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Jare uasa ma yave pascua, Jesús tu jare ichɨ oẽ Jerusalén güi yugüeru ye vaerã jenta pe. Ẽrei Jesús upɨta Jerusalén pe tu jare ichɨ uicuaa mbae reve. ");
INSERT INTO gnwNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Echa'ã jae reta jei tẽi Jesús ou co oĩ iguataĩru reta jupíe. Ẽrei caaru ma yave, ueca reta tẽi jentarã reta jare ĩru uicuaa vae reta ñugüɨnoi vae rupi. ");
INSERT INTO gnwNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ẽrei uvãe'ã chupe. Jayave Jesús tu jare ichɨ yugüɨraa ye Jerusalén pe ueca vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Jare mbapɨ ara ma uasa yave, uvãe reta chupe Tumpa jo pe. Jesús uguapɨ oĩ mboroyocui re oporomboe vae reta ipɨte pe. Uyapɨsaca oĩ jese reta jare upɨrandu chupe reta mbaembae re. ");
INSERT INTO gnwNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Jare opaete vae ipɨacañɨ. Echa'ã Jesús uicuaa cavi opaete iporomboe jare ipuere umɨmbeu cavi chupe reta jae reta upɨrandu chupe mbae re yave. ");
INSERT INTO gnwNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Jare Jesús tu jare ichɨ uecha yave, jae reta vi ipɨacañɨ. Jayave ichɨ jei Jesús pe: —Chemembɨ, ¿maera pa ndiyapo cuarãi oreve? Mase, nderu jare che ndueca tẽi opaete que rupi orepɨatɨtɨ reve —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jayave Jesús jei chupe reta: —¿Maera pa chereca opaete que rupi? Icavi co apɨta vaerã cua pe ayapo vaerã cheRu iparavɨquɨ. ¿Picuaa'ã pa cua? —jei chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ẽrei jae reta uicuaa'ã mbae uipota jei jocua Jesús jei chupe reta vae. ");
INSERT INTO gnwNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Jayave Jesús ou ye Nazaret pe jae reta jupíe, jare jecuaeño uyapo jae reta jei vae. Jare Jesús ichɨ imandúa opaete uyeyapo vae re. ");
INSERT INTO gnwNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jare Jesús jecuaeño ucuacuaa oo oĩ. Jare iyaracuaa catu. Jecuaeño umbɨyerovia Tumpa jare ĩru vae reta vi. ");
INSERT INTO gnwNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Jare Tiberio César quince año ma romano reta juvicha guasurã ico yave, Tumpa ombou iñee Juan pe. Juan co jae Zacarías taɨ, jare ico ñana pe. Jocua ara reta pe Poncio Pilato ico Judea pegua reta juvicha guasurã, jare Herodes ico Galilea pegua reta juvicha guasurã, jare Herodes tɨvɨ Felipe jee vae ico ɨvɨ Iturea pegua reta jare ɨvɨ Traconite pegua reta juvicha guasurã, jare Lisanias ico ɨvɨ Abilinia pegua reta juvicha guasurã. Jare Anás jare Caifás yugüɨreco Israel pegua reta isacerdote tenondegua retarã. ");
INSERT INTO gnwNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Jayave Juan uguata ico opaete ɨãca Jordán iyɨpɨ rupi. Jare umɨmbeu opaete vae pe ueya vaerã iyemɨngueta icavi mbae vae ipɨa pe oĩ vae jare uyembɨbautizaca vaerã, Tumpa umbɨasa vaerã chupe reta imbaeyoa reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Isaías co jae penti Tumpa iñee aracae umɨmbeu vae. Jae uicuatía cuarãi: “Jae iñeeãta reve jeita ñana rupi: ‘Piyapɨcatu yandeYa japerã. Pemɨsɨmi tape’ —jeita—. ");
INSERT INTO gnwNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","‘Opaete jugua reta uñemɨtɨneeta ɨvɨ pe. Jare opaete ɨvɨtu reta uyeyapota ñuu rami. Jare tape ipãri vae reta uñemɨsɨmicata. Jare tape quɨpe quɨpe vae reta ipecavita. ");
INSERT INTO gnwNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Jare opaete vae uicuaata quirãi Tumpa ipuere upurumbɨasa.’ ” Jucuarãi uicuatía Isaías. ");
INSERT INTO gnwNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Jare jeta vae yugüeru Juan oĩ vae pe uyembɨbautizaca vaerã. Jayave Juan jei chupe reta: —Pe reta co jae mboi reta rami. ¿Quía pa umɨmbeu peve piyerova vaerã Tumpa cotɨ agüɨye vaerã Tumpa uiporaraca peve? —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Piyapo icavi vae, jucuarãi picuaaca vaerã añetete peeya co piyemɨngueta icavi mbae vae pepɨa pe oĩ vae. Agüɨye pere piyupe pepɨa pe: ‘Yandetenondegua co jae Abraham.’ Echa'ã che jae peve cua: Tumpa ipuere uyapo cua ita reta güi Abraham iñemoñaa retarã —jei Juan chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Yamɨjaanga penti temitɨ. Temitɨ ía icavi'ã yave, iya uyasɨa japo reve jare uapɨ. Jae ramiño vi piyapo'ã yave icavi vae, Tumpa uiporaracata peve —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Jayave joco pe ñugüɨnoi vae reta upɨrandu Juan pe: —¿Mbae pa nduyapota? ");
INSERT INTO gnwNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Jayave Juan jei chupe reta: —Ime yave quía mocui temimonde güɨnoi vae, tumee penti mbaetɨ temimonde güɨnoi vae pe. Jare ime yave quía jeta tembíu güɨnoi vae, tumee mbaetɨ tembíu güɨnoi vae pe —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Yugüeru vi Juan oĩ vae pe mburuvicha peguarã ocovara vae reta uyembɨbautizaca vaerã. Jae reta upɨrandu Juan pe: —Oporomboe vae, ¿mbae pa nduyapota? ");
INSERT INTO gnwNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Jayave Juan jei chupe reta: —Agüɨye ma pembɨasa pecovara mburuvicha reta peocui vae güi. ");
INSERT INTO gnwNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Sundaro reta vi upɨrandu Juan pe: —¿Mbae pa nduyapota? Jayave Juan jei chupe reta: —Agüɨye pemumburu ĩru vae reta jare agüɨye peapu ĩru vae reta re. Jare agüɨye jecuaeño pipota jeta peruvicha reta umbɨepɨ peve vae güi. ");
INSERT INTO gnwNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Opaete vae uãro ñugüɨnoi Cristo ou vaerã, jare ipɨa pe uyemɨngueta quirãi aramoi Juan co jae Cristo. ");
INSERT INTO gnwNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Jáeramo Juan jei chupe reta: —Che pumbɨbautiza ɨ pe. Ẽrei outa ipuere ete chegüi vae. Jupi'ã co che ayora vaerã ipɨpasa ichã. Jae pembɨbautizata Espíritu Santo pe jare tata pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Jae co trigo uipoo vae rami. Echa'ã trigo uipoo vae umbɨveve trigo uequi vaerã ɨtɨ. Jayave uñuvatu trigo jɨru pe. Ẽrei uapɨ ɨtɨ tata pe. Tata Cristo uiporuta vae opa mbae vae co —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jare Juan jeta jei chupe reta umɨmbeu vaerã chupe reta ñee icavi vae. ");
INSERT INTO gnwNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Jare mburuvicha guasu Herodes umenda tɨvɨ Felipe jembireco Herodías jee vae ndive jare uyapo jeta mbae icavi mbae vae. Jare Juan iñeengueta Herodes pe opaete icavi mbae vae uyapo vae re. ");
INSERT INTO gnwNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Jayave Herodes uyapo ye icavi mbae vae. Echa'ã oñonoca Juan peresorɨru pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ẽrei ndei Juan uñeñonoca peresorɨru pe mbove, penti ara Jesús ou Juan oĩ vae pe. Jare Juan ĩru vae reta umbɨbautiza yave, umbɨbautiza vi Jesús. Jare Jesús uyerure Tumpa pe rambueve, ara uyepea. ");
INSERT INTO gnwNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Jare uyecuaa Espíritu Santo ugüeyɨ Jesús re pɨcasu rami. Jayave uyendu ñee ara güi jei: —Nde co jae cheRaɨ nduau ete vae. Chembɨyerovia ete —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jare Jesús güɨnoi ma treinta año rupi. Ĩru vae reta ipɨa pe uyemɨngueta tẽi jae co José taɨ ete. José co jae Elí taɨ. ");
INSERT INTO gnwNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí co jae Matat taɨ. Matat co jae Leví taɨ. Leví co jae Melqui taɨ. Melqui co jae Jana taɨ. Jana co jae José taɨ. ");
INSERT INTO gnwNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José co jae Matatías taɨ. Matatías co jae Amós taɨ. Amós co jae Nahum taɨ. Nahum co jae Esli taɨ. Esli co jae Nagai taɨ. ");
INSERT INTO gnwNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai co jae Maat taɨ. Maat co jae Matatías taɨ. Matatías co jae Semei taɨ. Semei co jae José taɨ. José co jae Judá taɨ. ");
INSERT INTO gnwNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá co jae Joana taɨ. Joana co jae Resa taɨ. Resa co jae Zorobabel taɨ. Zorobabel co jae Salatiel taɨ. Salatiel co jae Neri taɨ. ");
INSERT INTO gnwNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri co jae Melqui taɨ. Melqui co jae Adi taɨ. Adi co jae Cosam taɨ. Cosam co jae Elmodam taɨ. Elmodam co jae Er taɨ. ");
INSERT INTO gnwNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er co jae Josué taɨ. Josué co jae Eliezer taɨ. Eliezer co jae Jorim taɨ. Jorim co jae Matat taɨ. ");
INSERT INTO gnwNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat co jae Leví taɨ. Leví co jae Simeón taɨ. Simeón co jae Judá taɨ. Judá co jae José taɨ. José co jae Jonán taɨ. Jonán co jae Eliaquim taɨ. ");
INSERT INTO gnwNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim co jae Melea taɨ. Melea co jae Mainán taɨ. Mainán co jae Matata taɨ. Matata co jae Natán taɨ. ");
INSERT INTO gnwNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natán co jae David taɨ. David co jae Isaí taɨ. Isaí co jae Obed taɨ. Obed co jae Booz taɨ. Booz co jae Salmón taɨ. Salmón co jae Naasón taɨ. ");
INSERT INTO gnwNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón co jae Aminadab taɨ. Aminadab co jae Aram taɨ. Aram co jae Esrom taɨ. Esrom co jae Fares taɨ. Fares co jae Judá taɨ. ");
INSERT INTO gnwNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá co jae Jacob taɨ. Jacob co jae Isaac taɨ. Isaac co jae Abraham taɨ. Abraham co jae Taré taɨ. Taré co jae Nacor taɨ. ");
INSERT INTO gnwNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor co jae Serug taɨ. Serug co jae Ragau taɨ. Ragau co jae Peleg taɨ. Peleg co jae Heber taɨ. Heber co jae Sala taɨ. ");
INSERT INTO gnwNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala co jae Cainán taɨ. Cainán co jae Arfaxad taɨ. Arfaxad co jae Sem taɨ. Sem co jae Noé taɨ. Noé co jae Lamec taɨ. ");
INSERT INTO gnwNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec co jae Matusalén taɨ. Matusalén co jae Enoc taɨ. Enoc co jae Jared taɨ. Jared co jae Mahalaleel taɨ. Mahalaleel co jae Cainán taɨ. ");
INSERT INTO gnwNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán co jae Enós taɨ. Enós co jae Set taɨ. Set co jae Adán taɨ. Adán co jae Tumpa taɨ. ");
INSERT INTO gnwNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jare Jesús ou ye Jordán güi. Jae tɨnee Espíritu Santo pe. Jayave Espíritu Santo güɨraa Jesús ñana pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Jare Jesús upɨta ñana pe cuarenta ara, jare aña guasu umɨngueta uyavɨca vaerã tẽi chupe. Jare jocua ara reta pe Jesús jou'ã mbae ave. Jáeramo jocua ara reta opa ma yave, iyembaɨ. ");
INSERT INTO gnwNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Jayave aña guasu jei Jesús pe: —Nde co jae Tumpa Taɨ yave, ere cua ita pe uyeyapo vaerã mbɨyaperã. ");
INSERT INTO gnwNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ẽrei Jesús jei chupe: —Tumpa iñee pe uyecuatía oĩ cuarãi: ‘Icavi co ɨvɨ pegua reta jou vaerã mbɨyape güɨnoi vaerã tecove. Ẽrei icavi ete co uyapɨsaca vaerã Tumpa iñee re jare uyapo vaerã jei vae güɨnoi vaerã tecove opa mbae vae.’ Jucuarãi uyecuatía oĩ —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Jayave aña guasu güɨraa Jesús penti ɨvɨtu guasu ɨvate vae re jare uechaca chupe penti jeia pe opaete mburuvicha guasu reta iporoyocuia ɨvɨ pe ñugüɨnoi vae reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Jayave aña guasu jei Jesús pe: —Tamee ndeve mbaepuere ndiyeyapo vaerã opaete cua juvicha guasurã, opaete vae nembɨadora vaerã. Echa'ã cua mbaepuere uñemee co cheve jare chepuere amee aipota amee chupe vae pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Nde ndiyeatɨca yave chembɨadora vaerã, tamee ndeve nembaerã —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jayave Jesús jei chupe: —Esɨrɨ chegüi, Satanás. Echa'ã Tumpa iñee pe uyecuatía oĩ cuarãi: ‘Che co jae ndeYa Tumpa. Chembɨadora. Jaeño cheve iyeyocui.’ Jucuarãi uyecuatía oĩ —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Jayave aña guasu güɨraa Jesús Jerusalén pe jare umbuyupi Tumpa jo iyapɨte re. Jayave jei chupe: —Nde co jae Tumpa Taɨ yave, ea cua güi. ");
INSERT INTO gnwNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Echa'ã Tumpa iñee pe uyecuatía oĩ cuarãi: ‘Tumpa oyocuita ángel reta uyandareco vaerã nderé. ");
INSERT INTO gnwNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ipo pe ndepɨsɨ ndeocota reta, agüɨye vaerã ndepɨ uyererocua ita re.’ Jucuarãi uyecuatía oĩ —jei aña guasu chupe. ");
INSERT INTO gnwNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jayave Jesús jei chupe: —Tumpa iñee pe uyecuatía oĩ cuarãi: ‘Che co jae ndeYa Tumpa. Agüɨye mbae iyapo ndicuaa vaerã tuicha ra chepɨaguasu.’ Jucuarãi uyecuatía oĩ —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Jare aña guasu opa ma umɨngueta yave uyavɨca vaerã tẽi chupe, usɨrɨ chugüi michi pegua. ");
INSERT INTO gnwNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jayave Jesús ou ye Galilea pe. Jare güɨnoi mbaepuere Espíritu Santo umee chupe vae. Jare jerãcua jese opaete jocua ɨvɨ rupi. ");
INSERT INTO gnwNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Jare jae oporomboe judío reta itupao reta pe jare opaete vae umbɨadora. ");
INSERT INTO gnwNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jayave ou ye Nazaret pe - joco pe jae ucuacuaa. Jayave mbutuu ara pe uique judío reta itupao pe uyapoñoi rami, jare uyemboɨ Tumpa iñee umɨngueta vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Jare uñemee Jesús pe penti libro. Jocua libro pe oĩ Tumpa iñee aracae umɨmbeu vae Isaías uicuatía vae. Jayave Jesús uipea libro jare uvãe umɨngueta vaerã. Jayave umɨngueta cuarãi: ");
INSERT INTO gnwNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“YandeYa iEspíritu ime che ndive oĩ. Jae cheparavo amɨmbeu vaerã ñee icavi vae iparavete vae reta pe. Jae chembou ambɨpɨacatu vaerã ipɨatɨtɨ vae reta. Chembou vi amɨmbeu vaerã pereso reta pe ipuere ma uyeyora, jare amɨmbeu vaerã jesa mbae vae reta pe umae vaerã. Chembou vi ayora vaerã uiporara vae reta uiporaraca chupe vae reta imbaepuere güi. ");
INSERT INTO gnwNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Chembou vi amɨmbeu vaerã yandeYa ipɨacavita opaete vae pe.” Jucuarãi umɨngueta. ");
INSERT INTO gnwNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jayave Jesús uyuquenda ye libro jare umee ye libro iyandarecoa pe. Jayave uguapɨ ye. Jare opaete tupao pe ñugüɨnoi vae reta umae ngatu Jesús re. ");
INSERT INTO gnwNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Jayave Jesús jei chupe reta: —Cua ara cua uyecuatía oĩ vae uyeyapo ma perovaque. ");
INSERT INTO gnwNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Jare opaete joco pe ñugüɨnoi vae reta uyemɨngueta cavi jese. Echa'ã ipɨacañɨ iñee icavi ete vae re. Jae reta jei: —¿Jae'ã yera cua José taɨ? ");
INSERT INTO gnwNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jayave Jesús jei chupe reta: —Pereta co cheve jocua yamɨjaanga reve yae vae: ‘Nde co jae penti upurupɨano vae. Jáeramo iñepɨano. Echa'ã jerãcua oreve quirãi mbaembae ndiyapo Capernaum pe. Jáeramo iyapo vi cua pe ndeɨvɨ pe’ —pereta, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Añete che jae peve, ime yave quía Tumpa iñee umɨmbeu jentaɨgua reta pe vae, jae reta güɨrovia'ã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Añete che jae peve, jeta cuña ime umano vae reta yugüɨreco Israel pe Elías ico rambueve. Mbapɨ año jare seis yasɨ oquɨ'ã jare caruai opaete que rupi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ẽrei Tumpa omondo'ã Elías penti cuña ime umano vae Israel pegua pe. Jaeño omondo penti cuña ime umano vae tenta guasu Sarepta Sidón pegua vae pe —jei Jesús chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Jae ramiño vi jeta ipire ocui vae reta yugüɨreco Israel pe Tumpa iñee aracae umɨmbeu vae Eliseo ico rambueve. Ẽrei Tumpa omondo'ã Eliseo umbɨgüera vaerã penti ipire ocui vae Israel pegua. Jaeño omondo umbɨgüera vaerã Naamán, jare Naamán co jae Siria pegua —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Cua uyandu reta yave, opaete tupao pe ñugüɨnoi vae reta pochɨ ete Jesús pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Jayave jae reta upũa jare güɨraa Jesús tenta guasu güi ɨvɨtu iyapɨte re omombo vaerã tẽi ɨvɨ cotɨ joco güi. Jocua tenta guasu oĩ ɨvɨtu guasu re. ");
INSERT INTO gnwNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ẽrei Jesús uasa jae reta ipɨte rupi jare oo chugüi reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jayave Jesús oo tenta guasu Capernaum Galilea pegua pe. Joco pe Jesús oporomboe opaete mbutuu ara pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Jare uyapɨsaca jese vae reta ipɨacañɨ iporomboe re. Echa'ã omboe reta mbaepuere güɨnoi vae rami. ");
INSERT INTO gnwNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Jare uique oo tupao pe cuimbae aña oya jese vae. Jae iñeeãta reve jei: ");
INSERT INTO gnwNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—¿Maera pa ndeyu oremambeco, Jesús Nazaret pegua? ¿Ndeyu pa oremɨcañɨtei vaerã? Che nducuaa. Nde co jae Tumpa Taɨ —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jayave Jesús uñeengata chupe. —¡Nequĩi! ¡Esɨrɨ chugüi! —jei. Jayave opaete vae jovaque aña uitɨ ɨvɨ re cuimbae jare usɨrɨ chugüi. Ueya caviño. ");
INSERT INTO gnwNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Jare opaete uecha vae reta ipɨacañɨ, jare upɨrandu uyupe: —¿Mbae nunga ñee pa cua? Echa'ã mbaepuere pe oyocui aña reta usɨrɨ vaerã oya jese vae reta güi, jare jae reta uyapo oyocui vae —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Jare jerãcua jesegua opaete jocua ɨvɨ rupi. ");
INSERT INTO gnwNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jare Jesús tupao güi oẽ ye yave, uique Simón jenta pe. Jare Simón jaicho tanta jacu oĩ. Ĩru joco pe ñugüɨnoi vae reta uyerure Jesús pe umbɨgüera vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jayave Jesús oo cuña oĩ vae pe, jare jei jacu upɨta vaerã chugüi. Jayave jacu upɨta chugüi. Jayave jupivoiño cuña upũa jare umee mbae jou reta vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Jare guarasɨ uique ma yave, opaete jentarã imbaerasɨ vae güɨnoi vae reta güeru imbaerasɨ vae reta Jesús oĩ vae pe. Jare Jesús oñono ipo penti penti re jare umbɨgüera reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Jare aña reta usɨrɨ oya jese vae reta güi. Usapɨcai reta jare jei: —Nde co jae Tumpa Taɨ. Ẽrei Jesús uñeengata chupe reta. Umaeño'ã aña reta re uyemɨngueta vaerã. Echa'ã jae reta uicuaa jae co Cristo, Tumpa ombou vae. ");
INSERT INTO gnwNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Pɨareve pe Jesús oẽ tenta guasu güi oo quĩi ngatu vae pe. Jayave tenta guasu pegua reta yugüɨraa ueca. Jare yugüɨraa uvãe yave jae oĩ vae pe, uyerure tẽi chupe agüɨye vaerã oo chugüi reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ẽrei Jesús jei chupe reta: —Icavi co aa vaerã ĩru tenta guasu-raɨ reta pe amɨmbeu vaerã joco pe vi ñee icavi vae Tumpa iporoyocuia regua. Echa'ã cuarã Tumpa chembou —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Jare oo opaete ɨvɨ Galilea rupi, jare umɨmbeu Tumpa iñee judío reta itupaopao rupi. ");
INSERT INTO gnwNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Jare penti ara Jesús uyemboɨ rambueve ɨ guasu Genesaret jee vae jembeɨ pe, jeta vae yugüeru jae oĩ vae pe uyapɨsaca vaerã Tumpa iñee re. ");
INSERT INTO gnwNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Jare Jesús uecha mocui chalana ɨ jembeɨ pe. Iya reta pira uipɨsɨ vae reta co. Cua iya reta ueya joco pe, pɨsa reta oyoe rambueve. ");
INSERT INTO gnwNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jayave Jesús uyupi penti chalana pe, jare uyerure Simón pe uruique vaerã chalana ɨ pe. Echa'ã Simón imbae co jocua chalana. Jayave Jesús uguapɨ chalana pe jare joco güi omboe joco pe ñugüɨnoi vae reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Jare opa ma uyemɨngueta yave, Jesús jei Simón pe: —Ecua ɨ tɨpɨ vae pe pemombo pepɨsa reta pipɨsɨ vaerã pira. ");
INSERT INTO gnwNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Jayave Simón jei Jesús pe: —CheYa, orecõe ma nduparavɨquɨ tẽi. Nduipɨsɨ'ã mbae ave. Ẽrei tamombo pɨsa reta nde ndere cheve ramo —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Jare jucuarãi uyapo reta ma yave, jeta ete pira reta uique pɨsa pe. Jare pɨsa uyembɨpɨ osoro. ");
INSERT INTO gnwNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Jayave uyepueru reta iĩru ĩru chalana pe ñugüɨnoi vae reta pe yugüeru vaerã omborɨ. Jayave jae reta yugüeru jare umɨtɨnee reta mocui reve chalana. Jare mocui reve poɨ ete jare usacambu pota echa. ");
INSERT INTO gnwNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Jare Simón Pedro cua uecha yave, uyeatɨca Jesús jovai jare jei chupe: —Esɨrɨ chegüi, cheYa. Echa'ã che co jae penti cuimbae iyoa vae —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Echa'ã Pedro jare opaete jae ndive ñugüɨnoi vae reta ipɨacañɨ jeta ete pira uipɨsɨ vae re. ");
INSERT INTO gnwNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Jae ramiño vi Simón iĩru reta Jacobo jare Juan jee vae ipɨacañɨ jese. Jacobo jare Juan Zebedeo taɨ reta co. Jayave Jesús jei Simón pe: —Agüɨye equɨye. Che nduyapota ĩru vae reta nderu vaerã cheve cua ara güive —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Jayave jae reta güeru ichalana reta ɨ jembeɨ pe. Jayave ueya reta opaete, yugüɨraa vaerã Jesús jupíe. ");
INSERT INTO gnwNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jare Jesús oo uvãe yave penti tenta guasu pe, joco pe oĩ penti cuimbae ipire ocui vae. Cuimbae uecha Jesús yave, uyeatɨca jae jovai jare uyerure chupe. —CheYa —jei—, ndipota yave, ndepuere chembɨgüera. ");
INSERT INTO gnwNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jayave Jesús oñono ipo jese. —Aipota. Ecuera —jei chupe. Jare jupivoiño cuimbae ucuera imbaerasɨ güi. Ocui'ã ma ipire. ");
INSERT INTO gnwNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jayave Jesús oyocui: —Agüɨye emɨmbeu quía pe. Ecua iyeechaca sacerdote pe, jare emee ofrenda Moisés peocui rami, tenta guasu pegua reta uicuaa vaerã ndecuera ma co —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ẽrei jeta vae uyandu Jesús uyapo vae regua. Jayave jeta vae uyembatɨ jae oĩ vae pe uyapɨsaca vaerã jese jare jae umbɨgüera vaerã imbaerasɨ vae reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ẽrei Jesús oo chugüi reta ñuu cotɨ uyerure vaerã Tumpa pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Jare penti ara Jesús oporomboe oĩ, jare amocue fariseo reta jare mboroyocui re oporomboe vae reta uguapɨ ñugüɨnoi jocoropi. Jae reta yugüeru Jerusalén jare opaete tenta guasu Galilea jare Judea pegua reta güi. Jare Jesús güɨnoi Tumpa imbaepuere umbɨgüera vaerã imbaerasɨ vae reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Jayave amocue yugüeru vae reta güeru penti cuimbae imbaerasɨ vae jupa reve. Cua cuimbae ipuere mbae omɨ vae. Güeru vae reta uipota tẽi uruique imbaerasɨ vae o pe, oñono vaerã Jesús jovai. ");
INSERT INTO gnwNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ẽrei ipuere'ã uruique Jesús oĩ vae pe, uyembɨape'ã ye ñugüɨnoi reta ramo. Jáeramo uruyupi o iárambo jare uipea chupe Jesús jese catu. Joco pe umbɨgüeyɨ jocua cuimbae ipuere mbae omɨ vae jupa reve opaete vae ipɨte pe Jesús jovai. ");
INSERT INTO gnwNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jesús cua uecha yave, uicuaa jae reta güɨrovia co jese, jare jei cuimbae ipuere mbae omɨ vae pe: —Nembaeyoa reta uyembai ma, cherɨvɨ. ");
INSERT INTO gnwNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Jayave mboroyocui re oporomboe vae reta jare fariseo reta ipɨa pe uyemɨngueta: “¿Quía pa co jae cuarãi jei vaerã? Jei icavi mbae vae Tumpa cotɨ. Tumpaño co ipuere umbɨasa quía pe imbaeyoa reta.” ");
INSERT INTO gnwNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ẽrei Jesús uicuaa jae reta ipɨayemɨngueta, jare jei chupe reta: —¿Maera pa pepɨa pe piyemɨngueta jucuarãi? ");
INSERT INTO gnwNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Chepuere jae cua cuimbae pe: ‘Nembaeyoa reta uyembai ma.’ Jae ramiño vi chepuere jae chupe: ‘Epũa eguata.’ ¿Mbae nunga pa yavai jae vaerã? —jei Jesús chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ẽrei aipota picuaa vaerã cua: Che cuimbaerã ayeyapo vae chepuere ambɨasa quía pe imbaeyoa reta cua ɨvɨ pe aĩ rambueve —jei. Jayave jei cuimbae ipuere mbae omɨ vae pe: —Che jae ndeve: Epũa evoɨ nderupa, jare ecua nerenta pe —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Jayave jupivoi cuimbae upũa, jare ovoɨ jupa, jare oẽ oo jenta cotɨ opaete joco pe ñugüɨnoi vae reta jovaque. Jare oo rambueve, umbɨadora Tumpa. ");
INSERT INTO gnwNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Jae ramiño vi opaete joco pe ñugüɨnoi vae reta umbɨadora Tumpa. Echa'ã opareve ipɨacañɨ jare uquɨye. Jei reta: —Cua añave yaecha vae ñanemɨpɨacañɨ. ");
INSERT INTO gnwNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Jayave Jesús oẽ jare uecha mburuvicha peguarã ocovara vae Leví jee vae uguapɨ oĩ mburuvicha peguarã ocovara ñugüɨnoi vae pe, jare jei chupe: —Eyu cherupíe. ");
INSERT INTO gnwNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Jayave Leví upũa, jare oo jae jupíe. Ueya opaete imbaembae joco pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Jare Leví uyapo parea guasu jae jenta pe Jesús peguarã. Jare joco pe jeta mburuvicha peguarã ocovara vae reta jare ĩru vae reta ucaru vi ñugüɨnoi Jesús jare ĩru reta ndive. ");
INSERT INTO gnwNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ẽrei mboroyocui re oporomboe vae reta jare fariseo reta iñeenguru Jesús jemimboe reta pe. Jei reta: —¿Maera pa pecaru mburuvicha peguarã ocovara vae reta jare teco icavi mbae vae uyapo vae reta ndive? ");
INSERT INTO gnwNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jayave Jesús jei chupe reta: —Icove catu vae reta ueca'ã upurupɨano vae. Imbaerasɨ vae retaño ueca —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Che ayu aeca vaerã iyoa vae reta ueya vaerã iyemɨngueta icavi mbae vae ipɨa pe oĩ vae. Ayu'ã aeca vaerã jupi vae reta —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Jare amocue vae yugüeru Jesús oĩ vae pe jare jei chupe: —Juan jemimboe reta jeta vese uyecuacu tembíu güi uyerure reve Tumpa pe. Jae ramiño vi uyapo jucuarãi fariseo reta jemimboe reta. Ẽrei nderemimboe reta ucaruñoi —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jayave Jesús jei chupe reta: —Umendata vae pe ñugüɨnoi vae reta ndarau etei uyecuacu tembíu güi, umendata vae jae reta ndive oĩ rambueve —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ẽrei outa uvãe ara umendata vae uyereraaca vaerã chugüi reta. Jayave ramo uyecuacuta tembíu güi —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jayave imiari chupe reta umɨjaanga reve. —Icavi'ã yamboya vaerã temimonde indechi vae maemboyaa ipɨau vae pe. Echa'ã jucuarãi yayapo yave, maemboyaa ipɨau vae umɨãta temimonde indechi vae, jare temimonde jeiete osoro —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Jae ramiño vi icavi'ã yambɨru vaerã vino ipɨau vae vino jɨru guacapi indechi vae pe. Echa'ã jucuarãi yayapo yave, vino ipɨau vae omondoro jɨru, jare vino uyepɨyere, jare jɨru icavi'ã ma —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Jáeramo yambɨru vino ipɨau vae jɨru ipɨau vae pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Jare ime yave quía vino indechi vae jou vae, uipota'ã jupivoi jou vino ipɨau vae. Echa'ã jae jei vino indechi vae icavi ete vino ipɨau vae güi —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Mbutuu ara pe Jesús oo co rupi jemimboe reta ndive. Jare jemimboe reta uipoo trigo. Jayave uipoquɨtɨ uequi vaerã ipire, trigo jou vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Jare amocue fariseo reta jei chupe reta: —¿Maera pa piyapo piyapota'ã tẽi mbutuu ara pe vae? ");
INSERT INTO gnwNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jayave Jesús jei fariseo reta pe: —¿Pemɨngueta'ã pa David uyapocue vae regua, jae jare jae ndive ñugüɨnoi vae reta iyembaɨ yave? —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","David uique Tumpa jo pe jare jou mbɨyape Tumpa jo pe uñeñono tee vae reta, jare umee vi jae ndive ñugüɨnoi vae reta pe. Agüɨyeta tẽi co quía jou jocua mbɨyape, jaeño sacerdote reta —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Jayave Jesús jei chupe reta: —Che cuimbaerã ayeyapo vae chepuere jae mbae icavi uyeyapo vaerã mbutuu ara pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Jare ĩru mbutuu ara pe Jesús uique judío reta itupao pe jare oporomboe. Jare joco pe oĩ penti cuimbae ipo iyacata tɨpa vae. ");
INSERT INTO gnwNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Jare mboroyocui re oporomboe vae reta jare fariseo reta umae ngatu Jesús re, uecha vaerã umbɨgüerata ra quía mbutuu ara pe. Echa'ã uipota tẽi umbɨjeco vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ẽrei Jesús uicuaa jae reta ipɨayemɨngueta, jare jei cuimbae ipo jovaicho tɨpa vae pe: —Epũa eyu iyemboɨ cua reta jovai. Jayave cuimbae upũa uyemboɨ joco pe ñugüɨnoi vae reta ipɨte pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Jayave Jesús jei chupe reta: —Tapɨrandu peve cua: ¿Mbae pa jei mboroyocui? ¿Yayapota pa icavi vae ani icavi mbae vae mbutuu ara pe? ¿Icavi pa yapuruepɨ ani yapuruyuca vaerã mbutuu ara pe? —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Jayave umae opaete iyɨpɨ rupi ñugüɨnoi vae reta re, jare jei cuimbae pe: —Eupi ndepo. Jayave cuimbae ipo uupi, jare ucuera voi. ");
INSERT INTO gnwNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Jayave mboroyocui re oporomboe vae reta jare fariseo reta pochɨ ete Jesús pe jare uyemboemboe mbae ra uyapota Jesús pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Jayave penti pɨ̃tu Jesús oo ɨvɨtu guasu re uyerure vaerã Tumpa pe, jare icõe joco pe uyerure Tumpa pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Jare cõe ma yave, ueni jemimboe reta. Jayave uiparavo doce umbɨjee temimondo reta vae: ");
INSERT INTO gnwNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simón (Jesús umbɨjee Pedro), jare Simón tɨvɨ Andrés jee vae, jare Jacobo jare Juan, jare Felipe, Bartolomé, ");
INSERT INTO gnwNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tomás, Alfeo taɨ Jacobo jee vae, Simón (jae co Zelote pe ueni vae), ");
INSERT INTO gnwNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Jacobo tɨvɨ Judas jee vae, jare Judas Iscariote (cua cuimbae umee Jesús jovaicho reta pe). ");
INSERT INTO gnwNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jayave Jesús ugüeyɨ ye ɨvɨtu guasu güi ñuu pe jae reta ndive. Jare joco pe ñugüɨnoi jeta Jesús jemimboe reta jare jeta Judea pegua reta jare Jerusalén pegua reta jare tenta guasu Tiro jare Sidón iyɨpɨ rupigua reta. Tiro jare Sidón coiño co ñugüɨnoi ɨ guasu güi. Opaete vae yugüeru uyapɨsaca vaerã Jesús re, jare Jesús umbɨgüera vaerã imbaerasɨ vae reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Jesús umbɨgüera vi aña oya jese vae reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Jare opaete vae uipota uyavɨquɨ Jesús. Echa'ã jae güɨnoi mbaepuere umbɨgüera vaerã opaete imbaerasɨ vae reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jayave Jesús umae jemimboe reta re jare jei: —Tuyerovia iparavete vae reta. Echa'ã Tumpa umeeta chupe reta yugüɨreco vaerã iporoyocuia pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Tuyerovia añave iyembaɨ vae reta. Echa'ã Tumpa jeta umeeta chupe reta. Tuyerovia añave uyao vae reta. Echa'ã upucata reta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ĩru vae reta pemɨtarẽɨta jare ndarau uipota yugüɨreco peĩrurã. Jae reta jeita icavi mbae vae peve jare uyemɨnguetata peãgüe pe. Cuarãi uyapota reta peve, pe reta perovia cheré ramo. Che co jae cuimbaerã uyeyapo vae. Ẽrei piyerovia —jei Jesús—. ");
INSERT INTO gnwNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Jocua ara ou uvãe yave, piyerovia. Echa'ã Tumpa güɨnoi ara pe mbae icavi ete vae pembaerã. Echa'ã jucuarãi uyapota reta peve vae itenondegua reta uyapo cua nunga icavi mbae vae Tumpa iñee aracae umɨmbeu vae reta pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ẽrei icocatu vae reta uiporarata co. Echa'ã jae reta uyerovia ma jeta corepoti güɨnoi vae re —jei Jesús chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Jare jeta güɨnoi vae reta uiporarata co. Echa'ã iyembaɨta reta. Añave upuca reta. Ẽrei ipɨatɨtɨta reta jare uyaota reta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Jare opaete vae jei icavi vae jese vae reta uiporarata co. Echa'ã jucuarãiño vi uyapo itenondegua reta upurumbɨtavɨ vae reta pe. Jocua upurumbɨtavɨ vae reta jei iyapu reve: ‘Che co jae Tumpa iñee umɨmbeu vae’ —jei Jesús—. ");
INSERT INTO gnwNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Ẽrei che jae pe reta piyapɨsaca cheré vae pe cua: Peau perovaicho reta, jare piyapo icavi vae pemɨtarẽɨ vae reta pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ĩru vae reta uyepɨpeyu peré yave jare icavi mbae vae jei peve yave, piyerure Tumpa pe jae umɨvendise reta vaerã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ime yave quía ocua nderovaɨque re vae, erova ipuere vaerã ocua ye jovaicho re. Jare ime yave quía ndeasoya upɨ̃ro ndegüi vae, emaeño jese upɨ̃ro vaerã ndegüi ndecamisa vi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ime yave quía uyerure ndeve mbae re vae, emee chupe. Jare ime yave quía nembaembae upɨ̃ro ndegüi vae, agüɨye iñemɨacatẽɨ chupe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Piyapo ĩru vae reta pe pipota ĩru vae reta uyapo vaerã peve vae rami —jei chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Echa'ã peau yave perau vae retaño, jocua mbaetɨ co mbae icavi vae. Echa'ã iyoa vae reta uyapo vi jucuarãi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Jare piyapo yave icavi vae icavi vae uyapo peve vae reta peño, jocua mbaetɨ co mbae icavi vae. Echa'ã iyoa vae reta uyapo vi jucuarãi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Jare piporuca yave mbae ĩru vae pe jae umee ye peve vaerãño, jocua mbaetɨ co mbae icavi vae. Echa'ã iyoa vae reta uiporuca mbaembae ĩru vae pe jocua ĩru vae umbɨjecovia ye chupe vaerã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ẽrei peau perovaicho reta, jare piyapo icavi vae chupe reta. Piporuca mbae ĩru vae pe jare agüɨye peãro umbɨjecovia ye peve vaerã. Jucuarãi piyapo yave, Tumpa umeeta peve mbae icavi ete vae jare peapota taɨ retarã. Echa'ã Tumpa ipɨacavi umee'ã yasurupai chupe vae reta pe jare icavi mbae vae uyapo vae reta pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Piparareco ĩru vae reta, peRu uiparareco rami —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Agüɨye piñera ĩru vae re, agüɨye vaerã ĩru vae iñera peré. Agüɨye pembɨjeco ĩru vae mbae re, agüɨye vaerã ĩru vae pembɨjeco mbae re. Pembɨasa ĩru vae pe, ĩru vae umbɨasa vaerã peve —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Pemee mbaembae ĩru vae reta pe, jare ĩru vae reta umeeta mbaembae peve. Jae reta umeeta peve jeta ete ĩru vae reta pe pemee vae güi. Echa'ã icavi vae piyapo yave ĩru vae reta pe, ĩru vae reta uyapota icavi vae peve. Ẽrei icavi mbae vae piyapo yave ĩru vae reta pe, ĩru vae reta uyapota icavi mbae vae peve —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jayave Jesús jei chupe reta umɨjaanga reve: —Penti jesa mbae vae ipuere'ã etei uechaca tape ĩru jesa mbae vae pe. Jucuarãi uyapo yave, mocui reve uasavita ɨvɨcua pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Penti uyemboe oĩ vae uicuaa ete'ã oporomboe vae uicuaa vae rami. Ẽrei opaete re uyemboe yave, uicuaata oporomboe vae uicuaa rami —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Agüɨye emae ɨtɨ michi vae neĩru jesa pe oĩ vae re, ime yave nenoi ɨtɨ tuicha vae nderesa pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ndarau ndepuere ndere neĩru pe: ‘Cherɨvɨ, taequi nderesa güi jocua ɨtɨ michi vae.’ Echa'ã nde nenoi ɨtɨ tuicha vae nderesa pe. Nde co jae upurumbɨtavɨ vae. Eequi rani ɨtɨ tuicha vae nderesa güi. Jayave nemae cavita ndepuere vaerã ndeequi ɨtɨ michi vae neĩru jesa güi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Penti temitɨ icavi vae umee'ã ía icavi mbae vae. Jae ramiño vi penti temitɨ icavi mbae vae umee'ã ía icavi vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Echa'ã yaicuaa penti temitɨ icavi co, ía icavi yave. Yaequi'ã ɨva penti yai jãti vae güi. Jae ramiño vi yaequi'ã uva penti yai jãti vae güi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Quía nunga jecocavi vae güɨnoi icavi vae ipɨa pe. Jáeramo jei icavi vae. Jae ramiño vi quía nunga jecopochɨ vae güɨnoi icavi mbae vae ipɨa pe. Jáeramo jei icavi mbae vae. Echa'ã penti penti uyemɨngueta ipɨa pe güɨnoi vae rupi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","¿Maera pa pere cheve: ‘OreYa, oreYa’? Echa'ã piyapo'ã che jae peve piyapo vaerã vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ime yave quía ou cheve uyapɨsaca vaerã cheré vae, jae uyapo yave che jae chupe uyapo vaerã vae, tamɨjaanga peve mbae rami co jae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Jae co penti cuimbae jentarã uyapo vae rami. Oyoo quɨpe oñono vaerã tenta iguapɨcarã itape re. Jare tenta uyeyapo ma yave, tuicha oquɨ jare jeta ete ɨ usɨrɨ tenta iyɨpɨ rupi. Ẽrei tenta omɨ'ã etei. Echa'ã iyapoa oñono itape re —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ẽrei ime yave quía uyapɨsaca cheré vae, uyapo'ã yave che jae chupe uyapo vaerã vae, jae co ĩru cuimbae jentarã uyapo vae rami. Ẽrei jae oyoo'ã oñono vaerã tenta iguapɨcarã itape re. Oñono jentarã ɨvɨ iaramboño. Jayave tuicha oquɨ jare jeta ete ɨ usɨrɨ tenta iyɨpɨ rupi jare opa umbɨyapara. Opa uyembai jocua tenta —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jare opa ma imiari yave uyapɨsaca jese vae reta pe, Jesús oo Capernaum pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Jare jocua tenta guasu pe ico penti sundaro reta juvicha jembiocui. Cua cuimbae imbaerasɨ. Umano pota echa. Jare sundaro reta juvicha uau cua jembiocui. ");
INSERT INTO gnwNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Jare sundaro reta juvicha uyandu Jesús regua. Jáeramo omondo Jesús oĩ vae pe amocue judío reta itenondegua reta, jae reta uyerure vaerã Jesús pe oo vaerã umbɨgüera sundaro reta juvicha jembiocui. ");
INSERT INTO gnwNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Jare yugüeru uvãe yave Jesús oĩ vae pe, uyerure chupe cua re. Jei reta chupe: —Cua mburuvicha ipɨacavi co. Jáeramo icavi co nde ndiyapo vaerã cua chupe. ");
INSERT INTO gnwNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Echa'ã jae yanderau jare uyapo yandeve penti tupao —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","7","Jayave Jesús oo jae reta jupíe. Jare yugüɨraa ma uvãe yave coiño mburuvicha jenta güi, mburuvicha ombou amocue iĩru reta uñeovãiti vaerã Jesús ndive. Jae reta jei chupe: —Mburuvicha jei: ‘Agüɨye iyemambeco, cheYa, ndeyu vaerã cherenta pe. Echa'ã mbae'ã co che. Jáeramo aa'ã noovãiti. Ndepuere ndere joco güiño cherembiocui ucuera vaerã, jare ucuerata co’ —jei, jei reta chupe—. ");
INSERT INTO gnwNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","‘Echa'ã ime mburuvicha mbaepuere güɨnoi cheré vae reta. Jae ramiño vi che anoi mbaepuere sundaro reta re. Che jae penti sundaro pe: Ecua, jare jae oo. Jae ramiño vi che jae ĩru sundaro pe: Eyu, jare jae ou. Jae ramiño vi che jae cherembiocui pe: Iyapo cua, jare jae uyapo’ —jei, jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jare Jesús cua uyandu yave, ipɨacañɨ sundaro reta juvicha re. Jayave uyerova jare jei jeta vae yugüɨraa jaɨcue vae pe: —Che jae peve, avãe'ã cua nunga mburugüɨrovia tuicha vae Israel pegua reta ipɨte pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Jayave sundaro reta juvicha ombou vae reta yugüɨraa ye sundaro reta juvicha jenta pe, jare uecha ucuera ma co uyeyocui vae imbaerasɨ ico vae. ");
INSERT INTO gnwNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Jayave pɨareve pe Jesús oo tenta guasu Naín pe. Jare jeta jemimboe reta jare ĩru vae reta yugüɨraa jae jupíe. ");
INSERT INTO gnwNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Jare oo ma uvãe yave coiño tenta guasu jonque güi, umano vae güeru vae reta yugüeru tenta guasu güi. Umano vae penti cuimbae co jare ichɨ penti cuña ime umano vae co. Umano vae jocua cuña imembɨ jae vaeño co. Jare jeta tenta guasu pegua reta yugüeru jocua cuña jupíe. ");
INSERT INTO gnwNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Jare yandeYa uecha yave cuña, uiparareco jare jei chupe: —Agüɨye iyao. ");
INSERT INTO gnwNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Jayave Jesús oo uyavɨquɨ umano vae jɨru. Jare ovoɨ güeru vae reta uyemboɨ. Jayave Jesús jei taɨrusu vae pe: —Che jae ndeve: Epũa. ");
INSERT INTO gnwNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Jayave umano vae uguapɨ jare umbɨpɨ uyemɨngueta. Jayave Jesús umee ye ichɨ pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Jayave opaete vae uquɨye. Umbɨadora reta Tumpa. Jei reta: —Penti Tumpa iñee umɨmbeu vae ipuere ete vae ou ma yandepɨte pe. Tumpa ombou yandeve yanderau ramo. Echa'ã yande co jae imbae reta —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Jare Jesús uyapo vae jerãcua opaete Judea rupi jare opaete Judea iyɨpɨ rupigua rupi. ");
INSERT INTO gnwNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jare Juan jemimboe reta umɨmbeu Juan pe opaete cua regua. ");
INSERT INTO gnwNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Jayave Juan ueni mocui jemimboe reta jare ombou yandeYa oĩ vae pe jei vaerã chupe: —¿Nde pa co jae Cristo outa vae? ani ¿nuãrota pa ĩru vae ou vaerã? ");
INSERT INTO gnwNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Jayave jocua cuimbae reta yugüeru uvãe Jesús oĩ vae pe jare jei chupe: —Juan upurumbɨbautizase vae orembou ndeve. Jae jei: ‘¿Nde pa co jae Cristo outa vae? ani ¿nuãrota pa ĩru vae ou vaerã?’ —jei, jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Jayave jocua ora pe etei Jesús umbɨgüera jeta imbaerasɨ vae reta jare umbɨsɨrɨ aña reta oya jese vae reta güi. Jae ramiño vi umbɨgüera jeta jesa mbae vae reta, jae reta umae vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Jayave Jesús jei Juan ombou chupe vae reta pe: —Pecua ye pemɨmbeu Juan pe peecha jare piyandu vae. Jesa mbae vae reta umae ma. Ipuere mbae uguata vae reta uguata ma. Ipire ocui vae reta ucuera ma. Iyapɨsa mbae vae reta uyandu ma. Umano vae reta icove ye ma. Iparavete vae reta uyapɨsaca ñee icavi vae re —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Jare Tumpa umɨvendiseta jecuae güɨrovia cheré vae reta —jei chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Jare yugüɨraa ye yave Juan ombou vae reta, Jesús umbɨpɨ umɨngueta joco pe ñugüɨnoi vae reta Juan re. Jei chupe reta: —¿Quía re pa co peo ñana pe pemae? Jae ipɨrãta mbae vae'ã co tacuarãsɨ omɨ ɨvɨtu uipeyu yave vae rami —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Quía re pa co peo pemae? Jae omonde'ã temimonde ipõra vae. Mase, temimonde ipõra vae omonde vae reta yugüɨreco mburuvicha guasu reta jenta pe jare icavi ete yugüɨreco —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Peo ra pemae vaerã penti Tumpa iñee umɨmbeu vae re? Añete che jae peve, Tumpa umee chupe uyapo vaerã jeta ete ĩru Tumpa iñee umɨmbeu vae reta uyapo vae güi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Tumpa iñee pe uyecuatía oĩ jese cuarãi: ‘Mase’ —jei Tumpa—, ‘che amondota chiñee güɨraata vae nderenonde, uyapɨcatu vaerã nderaperã.’ Jucuarãi uyecuatía oĩ —jei chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Che jae peve, Tumpa umee Juan upurumbɨbautizase vae pe uyapo vaerã jeta ete ĩru Tumpa iñee umɨmbeu vae reta uyapo vae güi. Ẽrei taɨcuegua vae Tumpa iporoyocuia pegua uyembutuichaca eteta Juan güi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Jare mburuvicha peguarã ocovara vae reta jare opaete uyapɨsaca Juan re vae reta uicuaaca Tumpa jupi co. Echa'ã Juan umbɨbautiza reta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ẽrei fariseo reta jare mboroyocui re oporomboe vae reta uyapo'ã Tumpa jei uyapo vaerã vae. Echa'ã uyembɨbautizaca'ã Juan pe —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jayave Jesús jei chupe reta: —Tamɨmbeu peve mbae ndive amboyovaque añave yugüɨreco vae reta. Tamɨmbeu peve mbae rami co jae reta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Jae reta co sambiaɨ plaza pe uguapɨ ñugüɨnoi vae reta rami. Jae reta jei uyupe cuarãi: ‘Nduyemimbɨ ma peve, ẽrei pe reta pepɨrae'ã. Orepɨatɨtɨ perovaque, ẽrei pe reta piyao'ã.’ Jucuarãi jei —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Echa'ã Juan upurumbɨbautizase vae ou, jare jae uyecuacu tembíu jare vino güi. Jáeramo pe reta pere aña oya co Juan re —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Che cuimbaerã ayeyapo vae ayu, jare che ayecuacu'ã tembíu jare vino güi. Jáeramo pe reta pere: ‘Mase, jae jou jeta tembíu jare vino. Jae co mburuvicha peguarã ocovara vae reta jare teco icavi mbae vae uyapo vae reta iamigo’ —pere, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ẽrei opaete iyaracuaa vae reta uicuaaca aracuaa icavi co —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Jare penti fariseo uparea Jesús pe oo vaerã ucaru jae ndive. Jayave Jesús oo fariseo jenta pe jare uguapɨ ucaru vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Jare penti cuña aguasa rupi ico vae jocua tenta guasu pegua uicuaa Jesús ucaru co oĩ fariseo jenta pe, jare güeru mbae ipiche cavi vae jɨru ita alabastro jee vae pegua pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Jayave cuña uyemboɨ Jesús icupe cotɨ jare uyao. Jare umbɨpɨ umãquɨ Jesús ipɨ jesaɨ pe. Jayave cuña umɨtini Jesús ipɨ ía pe jare uyurupɨte vi ipɨ. Jayave uipichɨ mbae ipiche cavi vae ipɨ re. ");
INSERT INTO gnwNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Jare fariseo Jesús pe uparea vae cua uecha yave, jei iyupe ipɨa pe: “Cua cuimbae penti Tumpa iñee umɨmbeu vae yave, uicuaata tẽi quía co cua cuña jare mbae nunga cuña co jae. Echa'ã iyoa vae co” —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jayave Jesús jei fariseo pe: —Simón, aipota mbae jae ndeve. —Ere cheve, oporomboe vae —jei Jesús pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jayave Jesús jei chupe: —Mocui cuimbae ipía ĩru cuimbae pe. Penti cuimbae ipía chupe quinientos ara mbaravɨquɨ jepɨ pegua, jare ĩru cuimbae ipía chupe cincuenta ara mbaravɨquɨ jepɨ pegua —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ẽrei mocui reve mbaetɨ güɨreco corepoti ipía umbɨepɨ vaerã. Jayave upurumbɨpía vae opa umɨcañɨ mocui reve pe ipía —jei—. Emɨmbeu cheve, upurumbɨpía vae cua uyapo ramo, cua mocui vae güi ¿quía nunga pa uau eteta upurumbɨpía vae? —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Jayave Simón jei Jesús pe: —Che chepɨa pe ayemɨngueta jocua cuimbae jeta ipía opa umɨcañɨ chupe vae. Jayave Jesús jei chupe: —Jaecavi ndere. ");
INSERT INTO gnwNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Jayave Jesús uyerova cuña cotɨ jare jei Simón pe: —Mase, emae cua cuña re. Che aique nerenta pe yave, nemee'ã cheve ɨ ayoe vaerã chepɨ. Ẽrei jae umãquɨ ma chepɨ jesaɨ pe jare umɨtini ía pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Nde cheyurupɨte'ã. Ẽrei cua cuña aique güive uyurupɨte chepɨ —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Nde niñono'ã aceite cheãca re. Ẽrei cua cuña uipichɨ mbae ipiche cavi vae chepɨ re —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Jáeramo che jae ndeve, yepe tẽi jeta cua cuña imbaeyoa reta, ẽrei ambɨasa chupe. Echa'ã jae cherau ete. Ẽrei ime yave quía michiño ĩru vae umbɨasa chupe vae, jae michiño vi uau jocua ĩru vae —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Jayave Jesús jei cuña pe: —Ambɨasa ma ndeve nembaeyoa reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Jayave Jesús ndive ucaru ñugüɨnoi vae reta jei iyupe ipɨa pe: “¿Quía ra co cua? ¿Quirãita ra ipuere umbɨasa quía pe imbaeyoa reta?” ");
INSERT INTO gnwNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ẽrei Jesús jei cuña pe: —Ndiyembɨasaca ma nderovia cheré ramo. Ecua ndepɨacatu reve —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Jare cua jaɨcue rupi Jesús oo opaete tenta guasu reta jare tenta guasu-raɨ reta rupi, jare umɨmbeu ñee icavi vae Tumpa iporoyocuia regua. Jare jocua doce vae yugüɨraa jae jupíe. ");
INSERT INTO gnwNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","3","Jare jeta cuña reta yugüɨraa vi jae jupíe jare omborɨ Jesús jare jemimboe reta. Mbaembae uata Jesús jare jemimboe reta pe yave, jocua cuña reta ogua chupe reta. Tenonde yave amocue jocua cuña reta imbaerasɨ jare aña reta oya amocue vae re. Ẽrei Jesús umbɨgüera. Penti cuña jee co María Magdalena. Jesús umbɨsɨrɨ siete aña reta chugüi. Ĩru jee co Juana. Jae co Chuza jembireco. Chuza co jae mburuvicha guasu Herodes jembiocui. Ĩru jee co Susana. ");
INSERT INTO gnwNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Jare jeta vae yugüeru opaete tenta guasu reta güi uyembatɨ Jesús oĩ vae pe. Jayave Jesús jei chupe reta umɨjaanga reve: ");
INSERT INTO gnwNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Penti cuimbae oo umaetɨ vaerã. Umaetɨ yave, umɨai temitɨ, jare amocue oa tape rupi. Jayave ĩru vae reta upɨ̃ro temitɨ re jare güɨra reta jou vi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ĩru temitɨ oa mbovɨño ɨvɨ itape iárambo oĩ vae pe. Ẽrei oẽ rupive, ipiru, jocua ɨvɨ ñãquɨ ngatu'ã ramo —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ĩru temitɨ oa ñanapɨte pe. Ñana ucuacuaa yave, opa uyuca temitɨ —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ĩru temitɨ oa ɨvɨcavi pe. Cua oẽ jare ucuacuaa jare jeta ete ía —jei. Jare cua jei ma chupe reta yave, iñeeãta reve jei: —Uipota uyandu vae tuyapɨsaca cua ñee re. ");
INSERT INTO gnwNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Jayave Jesús jemimboe reta upɨrandu Jesús pe: —¿Mbae pa uipota jei cua nemɨjaanga reve ndere vae? ");
INSERT INTO gnwNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jayave Jesús jei chupe reta: —Amɨmbeu ma peve Tumpa iporoyocuia regua. Cua uyecuaa'ã ĩru vae reta pe. Jáeramo amboe ĩru vae reta amɨjaanga reve. Cua ayapo agüɨye vaerã uicuaa cavi, yepe tẽi uecha, jare agüɨye vaerã uicuaa, yepe tẽi uyandu —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Cua amɨjaanga reve che jae peve vae uipota jei cua: Temitɨ uyemɨjaanga Tumpa iñee re —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Jocua temitɨ tape rupi oa vae uyemɨjaanga amocue Tumpa iñee uyandu vae re. Jayave ou aña guasu chupe reta jare umɨacañɨ Tumpa iñee güi, agüɨye vaerã güɨrovia Tumpa uyembɨasaca vaerã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Jae ramiño vi jocua temitɨ uñeñotɨ mbovɨño ɨvɨ itape iárambo oĩ vae pe vae uyemɨjaanga ĩru vae reta Tumpa iñee uyandu vae re. Jae reta uyandu rupive, güɨrovia uyerovia reve. Ẽrei cua reta jocua temitɨ japo quɨpe'ã vae rami co. Echa'ã michi peguaño güɨrovia ñee. Ẽrei mbaesusere uyeyapo chupe yave, uipota'ã ma uyapɨsaca reta Tumpa iñee re —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Jae ramiño vi jocua temitɨ uñeñotɨ ñanapɨte pe vae uyemɨjaanga ĩru vae reta Tumpa iñee uyandu vae re. Ẽrei umbɨpɨ uyemɨpɨa'ã ɨvɨ pe mbaembae uyeyapo vae re jare corepoti uipota güɨnoi vaerã vae re jare yerovia ɨvɨ pegua re. Jáeramo jae reta jocua temitɨ ia'ã vae rami co —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ẽrei jocua temitɨ uñeñotɨ ɨvɨcavi pe vae uyemɨjaanga ĩru vae reta Tumpa iñee uyandu vae re. Cua reta uyapɨsaca cavi Tumpa iñee re ipɨacavi reve, jare uyapo Tumpa iñee jei uyapo vaerã vae. Jaéramo jae reta jocua temitɨ ía cavi vae rami co. Jae reta uyapo icavi vae ipɨaguasu reve —jei Jesús—. ");
INSERT INTO gnwNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Mechero yamɨendɨ yave, ndarau ñañono yapepo uyembovapo oĩ vae igüɨ pe, ani güɨrapembɨ igüɨ pe. Ñañono co mechero jenda pe, o pe uique vae reta güɨnoi vaerã tembipe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ime yave mbae uñeñomi vae, uyeechacañotai co. Jae ramiño vi ime yave mbae uyeyasoi vae, uyecuaañotai co —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Pepɨa pe piyemɨngueta cavi piyandu vae re. Echa'ã güɨnoi vae pe uñemɨĩruta, jare mbaetɨ güɨnoi vae güi mbovɨ ete güɨnoi echa vae uyeequita —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jayave Jesús ichɨ jare tɨvɨ reta yugüeru uvãe Jesús oĩ vae pe. Ẽrei ipuere'ã oya Jesús re jeta joco pe ñugüɨnoi vae reta jeco pegua. ");
INSERT INTO gnwNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Jayave amocue vae jei Jesús pe: —Ndesɨ jare nderɨvɨ reta oca pe ñugüɨnoi. Ndereca ñugüɨnoi —jei reta chupe. ");
INSERT INTO gnwNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jayave Jesús jei chupe reta: —Cua reta uyapɨsaca Tumpa iñee re jare uyapo jei vae. Cua nunga reta co jae chesɨ jare cherɨvɨ reta —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Jare penti ara Jesús uyupi chalana pe jemimboe reta ndive. Jayave Jesús jei chupe reta: —Yaa ɨ guasu jovaicho pe. Jayave umbɨpɨ uasa ɨ guasu. ");
INSERT INTO gnwNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ẽrei uasa ñugüɨnoi rambueve, Jesús oque oĩ. Jare ou ɨvɨtu tanta uyepeyu, jare ɨ uyembɨaparoaroa uique chalana pe, jare umɨtɨnee seri ma. Jae reta ipɨa pe uyemɨngueta umanota co. ");
INSERT INTO gnwNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Jayave omomba reta Jesús, jare jei chupe: —¡Oporomboe vae, oporomboe vae! Ñamanota ma. Jayave Jesús upũa, jare uñeengata ɨvɨtu jare ɨ guasu pe. Jare jupivoiño upɨta ɨvɨtu, jare opaete quĩi ngatu. ");
INSERT INTO gnwNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Jayave Jesús jei chupe reta: —¿Maera pa pepurugüɨrovia'ã? Jare jae reta uquɨye jare ipɨacañɨ, jare jei uyupe: —¿Mbae nunga cuimbae pa cua? Echa'ã jae oyocui ɨvɨtu jare ɨ guasu, jare jae reta uyapo oyocui vae —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Jayave yugüɨraa Galilea güi uvãe ɨ guasu jovaicho pe, gadareno reta iɨvɨ pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Jesús ugüeyɨ ma chalana güi yave, ou oovãiti penti cuimbae jocua tenta guasu pegua. Ɨma ma aña reta oya jese. Nani ico. Ico'ã etei tenta rupi. Teõgüerɨrurenda rupiño ma ico. ");
INSERT INTO gnwNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Cua cuimbae uecha Jesús yave, usapɨcai jare uyeatɨca Jesús jovai. Jayave iñeeãta reve jei: —¿Maera pa ndeyu chemambeco, Jesús? Nde co jae Tumpa ara pe oĩ vae Taɨ. Ayerure ndeve agüɨye iporaraca cheve —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Echa'ã Jesús oyocui ma aña usɨrɨ vaerã cuimbae güi. Ɨma ma uyembɨiya jese. Jare ĩru vae reta uipocua tẽi ipo jare ipɨ cadena pe. Ẽrei jae opa omondoo cadena reta. Jare jecuaeño oo ñana cotɨ aña omondo ramo. ");
INSERT INTO gnwNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jare Jesús upɨrandu chupe: —¿Mbae pa nderee? —Cheree co jae jeta vae —jei. Echa'ã jeta aña reta oya jese. ");
INSERT INTO gnwNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Jayave aña reta uyerure Jesús pe agüɨye vaerã oyocui reta yugüɨraa vaerã umanocue vae reta ipɨ. ");
INSERT INTO gnwNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Jare joco pe jeta cuchi reta ucaru ñugüɨnoi ɨvɨtu guasu re. Jayave aña reta uyerure Jesús pe umaeño vaerã jese reta oya vaerã cuchi reta re. Jayave Jesús umaeño jese reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Jayave aña reta usɨrɨ cuimbae güi, jare oya cuchi reta re. Jayave cuchi reta tanta osi ɨvɨa rupi oa ɨ guasu pe, jare joco pe opa ipɨtupa reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Jare cuchi iyandarecoa reta cua uecha yave, osi yugüɨraa tenta guasu pe umɨmbeu joco pegua reta jare icotɨ'ã rupigua reta pe cua uyeyapo vae regua. ");
INSERT INTO gnwNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Jayave uyandu vae reta yugüeru, uecha vaerã mbae uyeyapo vae. Jare yugüeru uvãe yave Jesús oĩ vae pe, uecha cuimbae aña reta oyase jese vae uguapɨ oĩ Jesús jovai. Uecha uyemonde ma jare iyaracuaaño ma oĩ. Jare opaete yugüeru vae reta uquɨye. ");
INSERT INTO gnwNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Jare jocua tenonde yave uecha vae reta umɨmbeu ĩru reta pe quirãi uyeyapo cuimbae aña reta oyase jese vae pe jae ucuera vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Jayave opaete gadareno reta umɨñera Jesús oo ye vaerã jae reta iɨvɨ güi. Echa'ã uquɨye ete reta. Jayave Jesús uyupi ye chalana pe yugüɨraa ye vaerã chugüi reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Jare cuimbae aña reta oyase jese vae uyerure Jesús pe umaeño vaerã jese oo vaerã jae jupíe. Ẽrei Jesús umaeño'ã jese. Jei chupe: ");
INSERT INTO gnwNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Ecua nerenta pe emɨmbeu ĩru vae reta pe mbae icavi vae Tumpa uyapo ndeve vae. Jayave cuimbae oo, jare umɨmbeu ĩru vae reta pe opaete tenta guasu rupi mbae icavi vae Jesús uyapo chupe vae. ");
INSERT INTO gnwNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jare Jesús oo uvãe yave ɨ guasu jovaicho pe, joco pe ñugüɨnoi vae reta umae jese uyerovia reve. Echa'ã uãro ñugüɨnoi. ");
INSERT INTO gnwNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Jayave ou penti cuimbae Jairo jee vae. Jae co judío reta itupao re uyandareco vae. Jae uyeatɨca Jesús jovai, jare uyerure chupe oo vaerã jae jenta pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Echa'ã jae güɨnoi pentiño tayɨ doce año rupi güɨnoi vae. Umano pota echa ma. Jayave Jesús oo jae jupíe. Jare jeta yugüɨraa Jesús jupíe, jare oyopɨ reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Jare jae reta ipɨte pe oo penti cuña doce año ma uiporara tugüɨguasu vae. Cuña opaete ma icorepoti umee iyugüi upurupɨano vae reta pe. Ẽrei penti ave ipuere'ã umbɨgüera. ");
INSERT INTO gnwNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Jayave cuña oya Jesús re icupe cotɨ, jare uyavɨquɨ jemimonde jembeɨ. Jare jupivoi jugüɨguasu upɨta chugüi. ");
INSERT INTO gnwNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jayave Jesús jei: —¿Quía pa cheremimonde uyavɨquɨ? Opaete vae jei uyavɨquɨ'ã co jemimonde. Jare Pedro jei Jesús pe: —Oporomboe vae, jeta ete ñugüɨnoi cua pe jare ndeopɨ reta co. ¿Maera pa ndere: ‘Quía pa cheremimonde uyavɨquɨ?’ —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ẽrei Jesús jei: —Quía nunga vae uyavɨquɨ co cheremimonde. Echa'ã aicuaa ambɨgüera ma co chembaepuere pe quía —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Jayave cuña uicuaa ipuere'ã ma uñemi Jesús güi. Jayave ou icotɨ urɨrɨ reve jare uyeatɨca Jesús jovai. Jayave umɨmbeu chupe opaete vae jovaque maera uyavɨquɨ jemimonde jare quirãi jupivoi ucuera. ");
INSERT INTO gnwNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jayave Jesús jei chupe: —Ndecuera ma, cherindɨ, nderovia cheré ramo. Ecua ndepɨacatu reve —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jare Jesús uyemɨngueta oĩ rambueve, penti vae ou uvãe tupao re uyandareco vae jenta güi. —Umano ma nderayɨ —jei—. Agüɨye ma emambeco oporomboe vae —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ẽrei Jesús cua uyandu yave, jei tupao re uyandareco vae pe: —Agüɨye ndepɨatɨtɨ. Epurugüɨroviaño. Ucuerata co —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Jare oo uvãe yave tenta pe, Jesús umaeño'ã ĩru reta re uique vaerã jae ndive, jaeño Pedro, Jacobo jare Juan, jare cuñatai tu jare ichɨ. ");
INSERT INTO gnwNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Jare opaete joco pe ñugüɨnoi vae reta uyao jare jãse ñugüɨnoi. Jayave Jesús jei chupe reta: —Agüɨye piyao. Umano'ã co. Oqueño co oĩ —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ẽrei jae reta oyoyai. Echa'ã uicuaa reta umano co. ");
INSERT INTO gnwNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Jayave Jesús uipɨsɨ cuñatai ipo pe. —¡Cuñatai, epũa! —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Jayave cuñatai icove ye, jare jupivoi upũa. Jayave Jesús oyocui umɨngaru vaerã cuñatai. ");
INSERT INTO gnwNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Jare cuñatai tu jare ichɨ ipɨacañɨ. Ẽrei Jesús oyocui reta agüɨye vaerã umɨmbeu quía pe ave mbae uyeyapo vae. ");
INSERT INTO gnwNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Penti ara Jesús opa umbatɨ jocua doce jemimboe reta, jare umee chupe reta mbaepuere umbɨsɨrɨ vaerã aña reta oya jese vae reta güi jare umbɨgüera vaerã imbaerasɨ vae reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Jayave omondo reta umɨmbeu vaerã Tumpa iporoyocuia jare umbɨgüera vaerã imbaerasɨ vae reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Jare jei chupe reta: —Agüɨye mbae peraa. Agüɨye peraa pepopoca. Agüɨye peraa peurupucu, perembiurã jare corepoti. Jare agüɨye peraa mocui camisa —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Peo pevãe yave penti tenta pe, joco pe peĩ jocua tenta guasu güi peo ye regua —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Jare ime yave penti tenta guasu pegua reta uipota'ã pepɨta vaerã joco pe vae, peo joco güi yave, pemɨtɨmo ɨvɨcuii pepɨ güi, uicuaa vaerã jae reta co teco güɨnoi —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Jayave jae reta yugüɨraa tenta guasu-raɨ reta rupi. Umɨmbeu reta ĩru vae reta pe ñee icavi vae jare opaete uguata vae rupi umbɨgüera imbaerasɨ vae reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Jare mburuvicha guasu Herodes uyandu opaete Jesús uyapo vae regua. Jayave ipɨacañɨ. Echa'ã amocue vae jei: —Juan icove ye ma ou umanocue vae reta ipɨte güi. ");
INSERT INTO gnwNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Jare ĩru vae reta jei: —Jae co Elías ou ye vae. Jare ĩru vae reta jei: —Jae co penti Tumpa iñee aracae umɨmbeu vae icove ye ma ou umanocue vae reta ipɨte güi vae. ");
INSERT INTO gnwNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ẽrei Herodes jei: —Añãcasɨaca co Juan. Ẽrei ¿quía ra co cua? Echa'ã ayandu ma jeta jesegua —jei. Jáeramo Herodes uipota uecha Jesús. ");
INSERT INTO gnwNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Jare Jesús jemimondo reta yugüeru ye Jesús oĩ vae pe, jare umɨmbeu Jesús pe opaete uyapo vae regua. Jayave Jesús güɨraa reta quĩi ngatu vae pe coiño tenta guasu Betsaida güi. ");
INSERT INTO gnwNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ẽrei jeta vae uicuaa yave, yugüɨraa jaɨcue. Jare Jesús umbɨresive cavi jare imiari chupe reta Tumpa iporoyocuia re jare umbɨgüera imbaerasɨ vae reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Caaru ma yave, jocua doce vae yugüeru Jesús oĩ vae pe jare jei chupe: —Emondo cua jeta vae tenta tenta rupi, joco pe ucaru vaerã jare oque vaerã. Echa'ã mbaetɨ tenta cua rupi —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ẽrei Jesús jei chupe reta: —Pe reta pemee tucaru. —Jaeño ime nonoi pandepo mbɨyape jare mocui pira —jei reta—. ¿Ndoota pa ndogua opaete cua reta jembiurã? ");
INSERT INTO gnwNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Echa'ã cuimbae retaño uyepapa cinco mil rupi. Jayave Jesús jei jemimboe reta pe: —Tuyembatɨmbatɨ cincuenta rupi tuguapɨ. ");
INSERT INTO gnwNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Jayave jucuarãi uyapo reta. Jei reta opaete joco pe ñugüɨnoi vae reta pe uguapɨ vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jayave Jesús uipɨsɨ jocua pandepo mbɨyape jare mocui pira, jare umae ara cotɨ, jare umee yasurupai Tumpa pe. Jayave upɨsãa mbɨyape jare pira, jare umee jemimboe reta pe, jae reta umee vaerã opaete joco pe uguapɨ ñugüɨnoi vae reta pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Opareve ucaru, jare iyangapɨɨ reta. Jayave Jesús jemimboe reta umbatɨ tembíu uñepɨsãacue jembɨre vae, jare umɨtɨnee doce canasta. ");
INSERT INTO gnwNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Penti ara Jesús oo jeta vae ipɨte güi uyerure vaerã Tumpa pe. Jare jemimboe reta joco pe ñugüɨnoi jae ndive. Jayave Jesús upɨrandu chupe reta: —¿Quía pa co che ĩru vae reta pe? —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Jae reta jei chupe: —Amocue vae jei nde co jae Juan upurumbɨbautizase vae, jare ĩru vae reta jei nde co jae Elías, jare ĩru vae reta jei nde co jae penti Tumpa iñee aracae umɨmbeu vae icove ye ma ou umanocue vae reta ipɨte güi vae —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Jayave Jesús upɨrandu chupe reta: —Jare ¿quía pa co che peve? —jei. Jayave Pedro jei chupe: —Nde co jae Cristo, Tumpa ombou vae —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Jayave Jesús oyocui ete reta agüɨye vaerã umɨmbeu quía pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Jayave Jesús jei chupe reta: —Che cuimbaerã ayeyapo vae aiporara eteta. Jare judío reta itenondegua reta jare sacerdote reta itenondegua reta jare mboroyocui re oporomboe vae reta ndarau uipota aico vaerã juvicha guasurã, jare cheyucacata. Ẽrei mbapɨ ara rupi aicove yeta ayu umanocue vae reta ipɨte güi —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Jayave Jesús jei opaete vae pe: —Ime yave quía uipota oo cherupíe vae, tiñacañɨ iyugüi, tovoɨ icurusu opa ara, jare too cherupíe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Uipota uñuvatu jecove vae ndarau ipuere. Ẽrei jocua umeeta jecove chereco pegua vae uñuvatuta co —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿Mbae ra umɨnganata quía, umɨngana yave opaete ɨvɨ pegua, ẽrei ipuere'ã yave uñuvatu jecove? —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ime yave quía imara cheré jare chiñee re vae, che cuimbaerã ayeyapo vae chemarata vi jese, ayu ye yave ayembutuichaca vaerã chembaepuere reve, cheRu imbaepuere reve, jare ángel uñeñono tee Tumpa peguarã vae reta imbaepuere reve —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ẽrei añete che jae peve, ndei amocue cua pe ñugüɨnoi vae umano mbove, uechata reta Tumpa iporoyocuia —jei Jesús. ");
INSERT INTO gnwNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Jare ocho ara rupi cua jei rendave pe, Jesús güɨraa Pedro, Juan jare Jacobo ĩru vae reta ipɨte güi, jare uyupi penti ɨvɨtu guasu re uyerure vaerã Tumpa pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Jare Jesús uyerure Tumpa pe rambueve, jova uyembɨambɨe jare jemimonde tĩ asɨ jare uvera. ");
INSERT INTO gnwNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Jare mocui cuimbae uyemɨngueta ñugüɨnoi Jesús ndive. Jae reta co Moisés jare Elías. ");
INSERT INTO gnwNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Mocui reve uyecuaa tembipe ipõra ete vae re jare uyemɨngueta reta Jesús imano re, quirãi umanota co Jerusalén pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ẽrei Pedro jare jae ndive ñugüɨnoi vae jopeɨ jare oque. Ẽrei usareco ye, jare uecha Jesús ipõra ete, jare uecha vi jocua mocui cuimbae Jesús ndive ñugüɨnoi vae reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Jare Moisés jare Elías yugüɨraa yeta ma yave, Pedro jei Jesús pe: —Oporomboe vae, icavi co ñaĩ vaerã cua pe. Turuyapo mbapɨ guarasɨ̃a ñanaroquɨ pegua, penti nembaerã, penti Moisés peguarã jare penti Elías peguarã —jei. Echa'ã Pedro uicuaa'ã mbae jei vae. ");
INSERT INTO gnwNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Jare Pedro cua jei rambueve, ou amapɨ̃tu umɨguarasɨ̃a reta. Jare jae reta uquɨye amapɨ̃tu umɨguarasɨ̃a yave. ");
INSERT INTO gnwNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Jayave uyendu ñee amapɨ̃tu güi jei: —Cua co jae cheRaɨ aau ete vae. Piyapɨsaca jese —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Jare ñee opa ma yave, jae reta uecha'ã quía joco pe, jaeño Jesús. Jare jocua ara reta pe jae reta umɨmbeu'ã quía pe ave mbaembae uecha vae. ");
INSERT INTO gnwNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Jare pɨareve pe ɨvɨtu guasu güi ugüeyɨ reta yave, jeta vae yugüeru uñeovãiti jae reta ndive. ");
INSERT INTO gnwNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Jayave penti cuimbae yatɨ vae reta ipɨte pe oĩ vae jei Jesús pe: —Oporomboe vae, ayerure ndeve nemae vaerã cheraɨ re. Jae co cheraɨ jae vaeño. ");
INSERT INTO gnwNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Aramoiño penti aña oya jese jare umbɨsapɨcai. Jayave umbɨrɨrɨ ete jare cunumi iyuru tɨrɨyai. Jayave uyembɨpere. Jecuaeño uyapo jucuarãi chupe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ayerure tẽi ma nderemimboe reta pe umbɨsɨrɨ vaerã aña chugüi, ẽrei ipuere'ã reta —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jayave Jesús jei joco pe ñugüɨnoi vae reta pe: —Yavai ete pe reta cua ɨvɨ pe pico vae pepurugüɨrovia vaerã. ¿Quirãi regua ra apɨtata pe reta ndive? ¿Quirãi regua ra arupɨata peve? —jei. Jayave jei cunumi tu pe: —Eru nderaɨ cua pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Jare cunumi ou rambueve, aña uipɨaca jare umbɨrɨrɨ ete. Jayave Jesús uñeengata aña pe. Jayave umbɨgüera cunumi jare umee ye tu pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Jare opaete joco pe ñugüɨnoi vae reta ipɨacañɨ Tumpa imbaepuere tuicha vae re. Ẽrei ipɨacañɨ rambueve opaete Jesús uyapo vae re, Jesús jei jemimboe reta pe: ");
INSERT INTO gnwNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Piyapɨsaca cavi cua jae peve vae re. Echa'ã che cuimbaerã ayeyapo vae penti vae chemeeta cherovaicho reta pe —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ẽrei jae reta uicuaa cavi'ã mbae Jesús jei chupe reta vae. Yavai chupe reta uicuaa vaerã, jare uipɨu reta upɨrandu vaerã chupe jese. ");
INSERT INTO gnwNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Jayave jae reta umbɨpɨ uyemɨngueta quía ra tenondegua ĩru reta güi vae. ");
INSERT INTO gnwNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jare Jesús uicuaa chugüi reta ipɨayemɨngueta. Jayave ueni penti sambiaɨ jare oñono iyɨpɨ pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Jayave jei jemimboe reta pe: —Ime yave quía uyapo icavi vae cua nunga sambiaɨ pe cheree pe vae, cheve co uyapo icavi vae. Jare jocua cheve uyapo icavi vae, uyapo vi icavi vae chembou vae pe. Echa'ã pepɨte pe oĩ vae uñemɨmichi vae icota tenondeguarã —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jayave Juan jei Jesús pe: —Oporomboe vae, nduecha penti cuimbae nderee pe umbɨsɨrɨ aña reta oya jese vae reta güi, jare ndoe chupe agüɨye ma uyapo vaerã. Echa'ã jae ñaneĩru'ã co —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","—Agüɨye pere chupe jucuarãi —jei Jesús chupe—. Echa'ã oyovaicho'ã yande ndive vae yanemborɨ co —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Jare outa ma uvãe Jesús oo ye vaerã ara pe. Jáeramo iquɨrẽɨ ete oo Jerusalén pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Jayave omondo amocue jemimboe reta jenonde. Jae reta yugüɨraa penti tenta guasu-raɨ ɨvɨ Samaria pegua pe uyapɨcatu vaerã Jesús peguarã. ");
INSERT INTO gnwNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ẽrei joco pegua reta uipota'ã Jesús upɨta vaerã joco pe. Echa'ã uicuaa reta jae oo Jerusalén cotɨ. ");
INSERT INTO gnwNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Jare Jesús jemimboe reta Jacobo jare Juan cua uicuaa yave, jei reta Jesús pe: —OreYa, ¿ndipota pa ore ndoyocui tata ou vaerã ara güi opa vaerã uapɨ cua tenta guasu-raɨ pegua reta Elías uyapo rami? ");
INSERT INTO gnwNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ẽrei Jesús uyerova icotɨ jare uñeengata chupe reta. Jei chupe reta: —Agüɨye pere jucuarãi. ");
INSERT INTO gnwNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Echa'ã che cuimbaerã ayeyapo vae ayu apurumbɨasa vaerã. Ayu'ã apurumɨcañɨtei vaerã —jei. Jayave yugüɨraa ĩru tenta guasu-raɨ cotɨ. ");
INSERT INTO gnwNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Jare tape rupi uguata reta rambueve, penti cuimbae jei Jesús pe: —Taa nderupíe opaete que rupi ndeo vae rupi. ");
INSERT INTO gnwNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jayave Jesús jei chupe: —Aguara reta güɨnoi icua reta, jare güɨra reta güɨnoi jaitɨ reta. Ẽrei che cuimbaerã ayeyapo vae mbaetɨ cherenta —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jare Jesús jei ĩru cuimbae pe: —Eyu cherupíe. Ẽrei cuimbae jei: —Emaeño rani cheré aa vaerã aico cheru re umano regua. ");
INSERT INTO gnwNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jayave Jesús jei chupe: —Tecove opa mbae vae güɨnoi mbae vae reta toñotɨ umano vae reta. Ẽrei nde ecua emɨmbeu Tumpa iporoyocuia —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Jayave ĩru cuimbae jei Jesús pe: —Taa nderupíe, cheYa. Ẽrei emaeño rani cheré aa vaerã cherenta pe amɨmbeu vaerã chupe reta jáema co aa —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ẽrei Jesús jei chupe: —Tamɨjaanga umbɨara vae. Umbɨara vae umae yave jaɨcue cotɨ, ndarau sɨmi oo. Jae ramiño vi che amɨmbaravɨquɨ yave quía, uyapo cavi'ã yave iparavɨquɨ, ndarau icavi ico vaerã Tumpa iporoyocuia pe —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Cua jaɨcue rupi yandeYa uiparavo ĩru setenta cuimbae reta jare omondo jenonde mocui mocui rupi opaete tenta guasu reta jae oota joco pe vae pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Jare jei chupe reta: —Jeta ete co yaavɨro vaerã. Ẽrei mbovɨ ete co umbaevɨro vae reta. Jáeramo pe reta piyerure yandeYa pe omondo vaerã uparavɨquɨ vae reta umbaevɨro reta vaerã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Pecua. Mase, pomondo icavi mbae vae uyapo vae reta ipɨte rupi. Pe reta ovecha-raɨ reta rami co. Jae reta yaguapɨ̃ta reta rami co —jei Jesús chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Agüɨye peraa corepoti, jare urupucu, jare pepɨpasa. Jare agüɨye pemiariño quía perovãiti yave tape rupi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Jare pique yave penti tenta pe, pere rani: ‘Tipɨacatu cua tenta pegua reta’ —pere, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Jare ime yave quía jocua tenta pe mbɨacatu uipota vae, jae ipɨacatuta co. Uipota'ã yave, ndarau ipɨacatu —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Jare pepɨta jocua tenta pe etei. Peu ipotave umee peu vaerã vae. Echa'ã icavi co ĩru vae reta umbɨepɨ vaerã uparavɨquɨ vae pe. Agüɨye cotɨ cotɨño pepɨta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Jare penti tenta guasu pe peo pevãe yave, joco pegua reta pembɨresive cavi yave, peu ipotave umee peu vaerã vae —jei chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Pembɨgüera imbaerasɨ vae joco pe ñugüɨnoi vae reta. Jare pere chupe reta: ‘Tumpa iporoyocuia coiño ma peve’ —pere, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ẽrei peo yave penti tenta guasu pe, joco pegua reta uipota'ã yave pepɨta vaerã joco pe, peguata calle rupi jare pere joco pegua reta pe: ");
INSERT INTO gnwNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Numɨtɨmo orepɨ güi ɨvɨcuii, cua tenta guasu pegua reta picuaa vaerã pe reta co teco penoi. Ẽrei turumɨmbeu peve cua: Tumpa iporoyocuia coiño ma peve’ —pere, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ẽrei che jae peve, Tumpa uãa yave ɨvɨ pegua reta, jocua tenta guasu pegua reta tanta uiporarata Sodoma pegua reta güi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Corazín pegua reta uiporarata co. Betsaida pegua reta uiporarata co. Echa'ã jeta mɨacañɨ reta ayapo ipɨte pe chembaepuere pe. Jucuarãi mona ayapo yave Tiro jare Sidón pe, joco pegua reta ueyata tẽi aracae ma iyemɨngueta icavi mbae vae ipɨa pe oĩ vae. Omondeta tẽi temimonde jaimbe vae jare oñonota tẽi tanimbu iñãca re uicuaaca vaerã ipɨatɨtɨ co —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ẽrei Tumpa upuruãa yave, Corazín jare Betsaida pegua reta tanta uiporarata Tiro jare Sidón pegua reta güi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Jare Capernaum pegua reta ipɨa pe uyemɨngueta tẽi icavi co yugüɨreco vaerã Tumpa ndive. Ẽrei Tumpa omondota reta yugüɨreco vaerã cañɨtei pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Uyapɨsaca peré vae uyapɨsaca co cheré. Ẽrei pererɨ̃ro vae chererɨ̃ro co. Jare chererɨ̃ro vae güɨrɨ̃ro chembou vae —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Jare jocua setenta vae reta yugüeru ye yave Jesús oĩ vae pe, uyerovia jare jei Jesús pe: —OreYa, nderee re nonoi mbaepuere aña reta re. ");
INSERT INTO gnwNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jayave Jesús jei chupe reta: —Che aecha Satanás oa ara güi ama uvera vae rami. ");
INSERT INTO gnwNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Mase, amee ma peve mbaepuere pepuere vaerã pepɨ̃ro mboi re jare chumɨcarape re, jare penoi vaerã mbaepuere tovaicho re, yepe tẽi jae güɨnoi vi mbaepuere. Ipuereta'ã mbae uyapo peve —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ẽrei agüɨye piyerovia mbaepuere aña reta re penoi vae re. Ẽrei piyerovia peree uyecuatía ma oĩ ara pe vae re —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Jocua ora pe etei Jesús uyerovia jare jei: —Amee yasurupai ndeve, cheRu, quirãi nde nemaeño'ã cua ɨvɨ pegua iyaracuaa vae reta re uicuaa vaerã cua mbaembae, ẽrei ndicuaaca sambiaɨ rami vae reta pe. Icavi co, cheRu. Echa'ã icavi co ndeve ndiyapo vaerã jucuarãi. Nde co jae ara pegua reta jare ɨvɨ pegua reta iYa —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Jayave jei vi: —CheRu umee ma cheve opaete. Mbaetɨ quía uicuaa cavi cheregua, jaeño cheRu. Jae ramiño vi mbaetɨ quía uicuaa cavi cheRu regua, jaeño che jare che aicuaaca chupe vae reta —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Jayave uyerova umae jemimboe reta re jare jei chupe retaño: —Tumpa pemɨvendise ma. Echa'ã umaeño peré peecha vaerã jeta mbaembae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Che jae peve, jeta Tumpa iñee aracae umɨmbeu vae reta jare mburuvicha guasu reta uipota tẽi uecha pe reta peecha ma vae, ẽrei uecha'ã. Jae ramiño vi jae reta uipota tẽi uyandu pe reta piyandu ma vae, ẽrei uyandu'ã —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Penti ara penti mboroyocui re oporomboe vae uyemboɨ Jesús jovai jare jei chupe: —Oporomboe vae, ¿mbae pa ayapota anoi vaerã tecove opa mbae vae? Uipota tẽi uyavɨca Jesús pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jayave Jesús jei chupe: —¿Mbae pa uyecuatía oĩ mboroyocui pe? ¿Mbae pa nemɨngueta joco pe? —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Jayave jei Jesús pe: —Uyecuatía oĩ cuarãi: ‘Eau ndeYa Tumpa opaete ndepɨa reve, jare opaete nderecove reve, jare opaete nepɨrãta reve jare opaete ndepɨayemɨngueta reve. Jae ramiño vi eau nderapicha nde ndiyerau rami.’ Jucuarãi uyecuatía oĩ —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jayave Jesús jei chupe: —Icavi co ndere. Cuarãi iyapo jare nenoita tecove opa mbae vae —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Mboroyocui re oporomboe vae uipota uicuaaca jupi co jae. Jáeramo upɨrandu Jesús pe: —¿Quía pa co jae cherapicha? ");
INSERT INTO gnwNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jayave Jesús jei chupe: —Penti cuimbae oo Jerusalén güi tenta guasu Jericó cotɨ. Jare aramoiño imonda vae reta uipɨsɨ. Jae reta omboi jemimonde chugüi jare umbɨpere. Uyuca raɨ raɨ ueya reta tape rupi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Jare aramoiño ou penti sacerdote jocua tape rupi. Jare uecha yave cuimbae ipere vae, uipota'ã etei oya jese. Mbɨrɨ rupiño uasa chugüi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Jae ramiño vi ou penti levita jocua tape rupi. Jare uecha yave cuimbae ipere vae, uipota'ã etei oya jese. Mbɨrɨ rupiño vi uasa chugüi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ẽrei penti Samaria pegua ou jocua tape rupi, jare ou uvãe cuimbae ipere vae oĩ vae pe. Jare Samaria pegua uecha yave, uiparareco —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Jayave oya jese jare uequi moa uipɨano vaerã chugüi ipere vae jare umbɨyasoi ipere. Jayave uupi imburica re jare güɨraa penti tenta pe, jare joco pe uyandareco jese —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Jare pɨareve pe Samaria pegua oota ma joco güi yave, uequi corepoti mocui ara mbaravɨquɨ jepɨ pegua jare umee tenta iya pe. Jei chupe: ‘Iyandareco mi jese. Jare jeta ete cua güi ndiyemɨngasta yave, ambɨepɨta ndeve ayu ye yave’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Añave tapɨrandu ndeve: ¿Quía nunga pa co jae jocua imonda vae reta uipɨsɨ vae japicha añetete vae? Echa'ã mbapɨ cuimbae uasa jocoropi —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Jare mboroyocui re oporomboe vae jei Jesús pe: —Jocua uiparareco vae. Jayave Jesús jei chupe: —Ecua iyapo jae uyapo vae rami. ");
INSERT INTO gnwNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesús jare jemimboe reta jecuae yugüɨraa Jerusalén cotɨ. Jayave yugüɨraa uvãe penti tenta guasu-raɨ pe. Joco pe penti cuña Marta jee vae umbɨresive cavi jenta pe Jesús. ");
INSERT INTO gnwNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Jare Marta ipɨquɨɨ co jee María. Jare María uguapɨ yandeYa iyɨpɨ pe uyapɨsaca vaerã jese. ");
INSERT INTO gnwNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ẽrei Marta uyemɨpɨa'ã tembiurã uyapo oĩ vae re. Jayave ou Jesús oĩ vae pe jare jei chupe: —CheYa, chepɨquɨɨ chemborɨ'ã. Jáeramo cheño ayapo aĩ tembiurã. ¿Icavi ra ndeve uyapo vaerã cuarãi? Iyocui chemborɨ vaerã —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Jayave yandeYa jei chupe: —Marta, Marta, ndiyemɨpɨa'ã jeta mbaembae re. ");
INSERT INTO gnwNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ẽrei yaipota'ã jeta mbaembae. Cua María uiparavo icavi vae ndegüi. Ndarau quía ipuere uequi chugüi —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Jare penti ara Jesús uyerure oĩ Tumpa pe. Jare opa ma yave, penti jemimboe jei chupe: —CheYa, oremboe nduyerure vaerã Tumpa pe Juan vi omboe jemimboe reta rami. ");
INSERT INTO gnwNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jayave Jesús jei chupe reta: —Piyerure Tumpa pe yave, pere cuarãi: ‘OreRu ara pe neĩ vae, tuyembɨadoraca nderee. Tou ndeporoyocuia. Tuyeyapo nde ndere vae cua ɨvɨ pe ara pe uyeyapo oĩ rami. ");
INSERT INTO gnwNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Emee oreve opa ara orerembiurã. ");
INSERT INTO gnwNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Embɨasa oreve orembaeyoa reta, ore numbɨasa ipotave iyoa orecotɨ vae pe rami. Jare agüɨye emaeño aña guasu re uyapoca vaerã oreve mbaeyoa. Orerepɨ aña guasu güi’ —pere, jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Jayave jei vi chupe reta: —Yamɨjaanga penti cuimbae jare iamigo. Cuimbae oo yave iamigo jenta pe pɨare mbɨte rupi uyerure vaerã chupe mbae re, aramoi jeita chupe: ‘Cheamigo, iporuca cheve mbapɨ mbɨyape. ");
INSERT INTO gnwNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Echa'ã penti cheamigo ou uvãe chepɨ, jare mbaetɨ mbae anoi amee jou vaerã.’ Aramoi jucuarãita jei —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Jare aramoi iamigo ombouta chupe iñee japɨpe güi: ‘Agüɨye chemambeco. Echa'ã uyeyuquenda ma oĩ cheronque, jare che jare opaete chesambiaɨ reta nduyapacua ma noĩ ndoque vaerã. Chepuere'ã ma apũa amee vaerã ndeve.’ Aramoi jucuarãita jei —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Che jae peve, yepe tẽi uipota'ã upũa, jocua cuimbae co jae iamigo ramo, ẽrei jocua cuimbae jecuaeño ueni oĩ yave, upũata co umee vaerã chupe opaete uipota vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Jare che jae peve, piyerure Tumpa pe mbae re, jare Tumpa umeeta peve. Peeca, jare pevãeta. Pembopu onque, jare uyepeata peve —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Echa'ã uyerure yave quía Tumpa pe mbae re, Tumpa umeeta chupe. Jare ueca yave quía mbae, uvãeta. Jare ombopu yave quía onque, uyepeata chupe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Nde nenoi yave penti nderaɨ, nderaɨ uyerure yave ndeve mbɨyape re, ndarau nemee chupe penti ita mbɨyape ipepɨca pe. Jae ramiño vi nderaɨ uyerure yave ndeve pira re, ndarau nemee chupe penti mboi pira ipepɨca pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Jae ramiño vi nderaɨ uyerure yave ndeve ururupía re, ndarau nemee chupe penti chumɨcarape ururupía ipepɨca pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Yepe tẽi pe reta jecuaeño piyapo icavi mbae vae, ẽrei pemee co mbaembae icavi vae pesambiaɨ reta pe. Jáeramo peRu ara pe oĩ vae iquɨrẽɨ ete umee Espíritu Santo uyerure chupe jese vae reta pe —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Penti ara Jesús umbɨsɨrɨ aña penti cuimbae iupa vae güi. Jare aña usɨrɨ ma chugüi yave, cuimbae uyemɨngueta. Jare jeta vae joco pe ñugüɨnoi vae ipɨacañɨ. ");
INSERT INTO gnwNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ẽrei amocue vae jei: —Aña guasu Beelzebú imbaepuere pe umbɨsɨrɨ aña reta oya jese vae reta güi. ");
INSERT INTO gnwNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Jare ĩru vae reta uipota uicuaa mbae ra Jesús ipuere uyapo. Jáeramo jei reta Jesús pe uyeyapo vaerã mbae ara re jae reta uicuaa vaerã quía co jae. ");
INSERT INTO gnwNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ẽrei Jesús uicuaa ipɨayemɨngueta, jare jei chupe reta: —Penti tenta guasu pegua reta oyovaicho uyupii yave, opata co jocua tenta guasu. Jae ramiño vi penti tenta pegua reta oyovaicho uyupii yave, opata co jocua tenta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Jae ramiño vi Satanás pochɨ iyupe yave, opata co iporoyocuia. Echa'ã pe reta pere che ambɨsɨrɨ aña reta oya jese vae reta güi aña guasu Beelzebú imbaepuere pe —jei Jesús chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ẽrei che ambɨsɨrɨ yave aña reta oya jese vae reta güi Beelzebú imbaepuere pe, ¿quía imbaepuere pe ra umbɨsɨrɨ aña reta oya jese vae reta güi perentarã reta? Pepuere pepɨrandu chupe reta jese —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ẽrei che ambɨsɨrɨ aña reta oya jese vae reta güi Tumpa imbaepuere pe. Jáeramo pepuere picuaa ou ma co uvãe peve Tumpa iporoyocuia —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Penti cuimbae ipɨrãta vae mboca güɨnoi vae uyandareco yave jenta re, ipuere'ã quía upɨ̃ro chugüi imbaembae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ẽrei ou yave ĩru cuimbae ipɨrãta ete chugüi vae uñerãro vaerã jae ndive, umɨamɨrita co jare upɨ̃rota chugüi imboca güɨrovia catu tẽi uyerepɨ vaerã pɨpe vae. Jae ramiño vi upɨ̃rota chugüi imbaembae umbɨyao vaerã umee iĩru reta pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ime yave quía uipota'ã ico cheĩrurã vae, oyovaicho co che ndive. Jae ramiño vi ime yave quía chemborɨ'ã vae, uyapo co icavi mbae vae checotɨ —jei chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Penti aña usɨrɨ ma yave oya jese vae güi, uguata ñana rupi ueca quiape ico vaerã. Ẽrei ipuere'ã yave uvãe quiape ico vaerã, jei iyupe: ‘Taa ye jocua chero ayu chugüi vae pe’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Echa'ã yandepuere yamɨjaanga penti o jocua cuimbae aña usɨrɨ ma chugüi vae re. Aña ou ye uvãe yave jocua o pe, uecha o iya utupei ma jare opa oñono cavi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Jayave oo ye aña güeru siete aña icavi mbae ete chugüi vae reta jocua o pe. Jayave ocho reve uique o pe, joco pe yugüɨreco vaerã. Tenonde yave, penti aña oya jese yave, jocua cuimbae uiporara. Ẽrei taɨcue rupi ocho ma aña reta oya jese. Jáeramo tanta uiporara —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jare Jesús cua mbaembae re imiari yave, penti cuña joco pe ñugüɨnoi vae reta ipɨte pe oĩ vae iñeeãta reve jei: —Tumpa tumɨvendise ndesɨ. Echa'ã nde ndea co chugüi jare jae nemɨcambu —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ẽrei Jesús jei: —Añete co. Ẽrei Tumpa umɨvendiseta opaete uyapɨsaca iñee re vae reta, uyapo yave jae jei vae —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Jare jeta vae yugüeru Jesús oĩ vae pe. Jayave Jesús jei chupe reta: —Añave yugüɨreco vae reta icavi mbae vae uyapo vae reta co. Jae reta uipota ayapo vaerã mbae aicuaaca vaerã chupe reta quía co che. Ẽrei jaeño uyeyapota mbae Jonás pe uyeyapo vae rami, jae reta uicuaa vaerã quía co che —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Echa'ã Jonás pe uyeyapo vae uicuaaca Nínive pegua reta pe Jonás jei chupe reta vae añete vae co. Jae ramiño vi uyeyapota cheve vae uicuaacata añave yugüɨreco vae reta pe quía co che. Che co jae cuimbaerã uyeyapo vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Tumpa upuruãa yave, jocua cuña mburuvicha guasu ico sur cotɨ vae upũata umbɨjeco vaerã añave yugüɨreco vae reta. Echa'ã jae ou mbɨrɨ ete güi uyapɨsaca vaerã Salomón iyaracuaa catu vae re. Ẽrei che chearacuaa catu ete Salomón güi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Tumpa upuruãa yave, Nínive pegua reta upũata umbɨjeco vaerã añave yugüɨreco vae reta. Echa'ã jae reta ueya iyemɨngueta icavi mbae vae ipɨa pe oĩ vae, Jonás umɨmbeu chupe reta yave Tumpa iñee. Ẽrei chembaepuere tuicha ete co Jonás imbaepuere güi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Mechero yamɨendɨ yave, ndarau ñañomi. Ndarau ñañono yapepo uyembovapo oĩ vae igüɨ pe. Ñañono co mechero jenda pe, o pe uique vae reta güɨnoi vaerã tembipe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Tembipe uique yanderete pe yanderesa rupi. Icavi yave nderesa, nderete tɨneeta tembipe pe. Ẽrei icavi'ã yave nderesa, nderete tɨneeta pɨ̃tumimbi pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Jáeramo iñemoa ngatu agüɨye vaerã nderete tɨnee pɨ̃tumimbi pe. Echa'ã tɨneeta tẽi tembipe pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Nderete tɨnee yave tembipe pe, ndarau ico joco pe pɨ̃tumimbi. Opaete tɨneeta tembipe pe, penti tembipe tuicha vae nembɨesape vae rami —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jare jucuarãi imiari ma yave Jesús, penti fariseo uparea chupe ucaru vaerã jae ndive. Jayave Jesús oo fariseo jenta pe jare uguapɨ ucaru vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Jare fariseo cua uecha yave, ipɨacañɨ jese. Echa'ã Jesús uyepoe'ã ndei ucaru mbove. ");
INSERT INTO gnwNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Jayave yandeYa jei: —Pe reta co jae fariseo reta. Pe reta co jae taza jare plato icupe rupiño uyeyoe vae rami. Ẽrei pepɨa iquɨa co. Echa'ã pipota ĩru vae reta imbaembae jare piyapo icavi mbae vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Pe reta co jae iyaracuaa mbae vae reta. Echa'ã Tumpa uyapo opaete yandepuere yaecha vae. Ẽrei uyapo vi opaete yandepuere mbae yaecha vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Pemee pequɨrẽɨ reve mbaembae iparavete vae reta pe. Cua piyapo yave, picuaacata ĩru vae reta pe iquɨa mbae co pepɨa —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Pe reta co jae fariseo reta. Piporarata co. Echa'ã pemee Tumpa pe diezmo temitɨ reta penoi vae güi. Ẽrei piyapo'ã jupi piyapo vaerã vae, jare peau'ã Tumpa. Icavi co pemee vaerã Tumpa pe jocua nunga diezmo. Ẽrei piyapota tẽi jupi co piyapo vaerã vae, jare peauta tẽi Tumpa —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Pe reta co jae fariseo reta. Piporarata co. Echa'ã pipota peguapɨ tenda tenondegua vae reta pe tupao pe, jare pipota ĩru vae reta pe piyembɨsaludaca vaerã calle reta rupi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Pe reta co jae mboroyocui re oporomboe vae reta jare fariseo reta. Piporarata co. Echa'ã pepurumbɨtavɨñoi. Pe reta co jae teõgüerɨru reta quía uecha'ã vae rami. Yepe tẽi ĩru vae reta upɨ̃ro jese reta, uicuaa'ã joco pe ñugüɨnoi vae —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Jayave penti mboroyocui re oporomboe vae jei Jesús pe: —Cua añave ndere vae rupi ndere vi icavi mbae vae oreve. ");
INSERT INTO gnwNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jayave Jesús jei: —Pe reta co jae mboroyocui re oporomboe vae reta. Pe reta vi piporarata co. Echa'ã pe reta pere ĩru vae reta pe uyapo vaerã yavai uyapo vaerã vae. Yamɨjaanga penti tɨvɨta. Pe reta pere ĩru vae reta pe ovoɨ vaerã penti tɨvɨta poɨ ete vae. Ẽrei pe reta pemborɨ'ã etei ovoɨ vaerã. Pe reta piyavɨquɨ'ã etei tɨvɨta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Piporarata co. Echa'ã pe reta piyapo Tumpa iñee aracae umɨmbeu vae reta iteõgüerɨru reta. Jare petenondegua reta uyuca reta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Jucuarãi picuaaca petenondegua reta uyapo vae icaviño co peve. Echa'ã jae reta uyuca reta, jare pe reta piyapo iteõgüerɨru reta —jei chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Jucuarãiño vi Tumpa iyaracuaa catu vae jei: ‘Amondota peve chiñee umɨmbeu vae reta jare cheremimondo reta, jare pe reta piyucata amocue vae jare piyapota icavi mbae vae ĩru reta pe’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Jare pe reta añave pico vae penoita teco opaete Tumpa iñee umɨmbeu vae reta ɨvɨ uyeyapo güive uyeyucaca vae imano re —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Tenonde voi Abel uyeyucaca, jare taɨcue rupi Zacarías uyeyucaca. Echa'ã Zacarías umano maemɨmba uyeyucacue uñemeearenda jare Tumpa jo ipãu pe. Añete che jae peve, cua reta jare opaete ĩru vae reta imano re pe reta añave pico vae piyembɨjecota —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Pe reta co jae mboroyocui re oporomboe vae reta. Piporarata co. Echa'ã pemboe'ã ĩru vae reta uicuaa vaerã Tumpa. Pe reta etei picuaa'ã Tumpa. Ĩru vae reta uipota tẽi uicuaa Tumpa, ẽrei pe reta piyopia agüɨye vaerã uicuaa —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jare jucuarãi jei ma yave chupe reta, mboroyocui re oporomboe vae reta jare fariseo reta pochɨ ete chupe, jare umbɨpɨ upɨrandu chupe jeta mbaembae re. ");
INSERT INTO gnwNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Jecuaeño jae reta uyapɨsaca cavi jese. Echa'ã uipota tẽi uyandu jei mbae ipuere umbɨjeco jese vae. ");
INSERT INTO gnwNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Jare jeta ete uyembatɨ Jesús oĩ vae pe, jare uñemɨañamɨaña. Jayave Jesús jei jemimboe reta pe rani: —Piñemoa ngatu fariseo reta güi. Echa'ã jae reta upurumbɨtavɨ vae reta co. Jare tavɨ ipuere uñemɨai levadura rami —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ime yave mbae uyeyasoi vae, uyeechacañotai co. Jae ramiño vi ime yave mbae uñeñomi vae, uyecuaañotai co —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Jáeramo pɨ̃tumimbi pe pere vae uyenduta tembipe pe, jare perenta japɨpe pe pere vɨari vae jerãcuata opaete vae uyandu vaerã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Jare che jae peve, cherɨvɨ reta, agüɨye pequɨye upuruyuca vae reta güi. Echa'ã upuruyuca yave, mbaetɨ ye mbae icavi mbae vae ipuere uyapo peve —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ẽrei tamɨmbeu peve quía güi pequɨye vaerã. Icavi co pequɨye vaerã Tumpa güi. Echa'ã jae güɨnoi mbaepuere upuruyuca vaerã jare oporomondo vaerã cañɨtei pe. Añete che jae peve, pequɨye chugüi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Picuaa co quirãi umaemee vae reta umee pandepo güɨra-raɨ mbovɨ ete corepoti re. Ẽrei Tumpa ñacañɨ'ã penti yepe güɨra-raɨ güi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Tumpa uicuaa mbovɨ pea penoi peãca re vae. Jáeramo agüɨye pequɨye. Echa'ã Tumpa perau ete jeta güɨra-raɨ reta güi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Jae ramiño vi che jae peve cua: Ime yave quía ĩru vae reta jovaque jei yave: ‘Che co jae Jesús jemimboe’, che cuimbaerã ayeyapo vae jaeta ángel Tumpa pe uyeyocui vae reta jovaque: ‘Cua co jae cheremimboe’ —jaeta, jei Jesús—. ");
INSERT INTO gnwNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ẽrei ime yave quía ĩru vae reta jovaque checuacu vae, che vi aicuacuta ángel Tumpa pe uyeyocui vae reta jovaque —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Jare ime yave quía jei icavi mbae vae che cuimbaerã ayeyapo vae cotɨ vae, Tumpa umbɨasata chupe. Ẽrei ime yave quía jei icavi mbae vae Espíritu Santo cotɨ vae, Tumpa ndarau etei umbɨasa chupe —jei Jesús chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Jare ĩru vae reta pereraa yave pemee vaerã tupao reta pe jare mburuvicha reta pe jare ĩru vae reta mbaepuere güɨnoi vae pe, agüɨye piyemɨpɨa'ã mbae pereta chupe reta vae re —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Echa'ã Espíritu Santo uicuaacata peve jocua ora pe etei mbae pere vaerã —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Jayave penti cuimbae jeta vae ipɨte pe oĩ vae jei Jesús pe: —Oporomboe vae, ere cherɨqueɨ pe umbɨyao vaerã cheve oreru ueya vae. ");
INSERT INTO gnwNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jayave Jesús jei chupe: —Cuimbae, che chepuere'ã co ayapɨcatu jocua nunga. Ndarau ambɨyao peve nderu ueya vae —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Jayave Jesús jei opaete vae pe: —Piñemoa ngatu agüɨye vaerã pipota ĩru vae reta imbaembae. Echa'ã ndarau yaico cavi jeta mbaembae ñanoi vae ramoño —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Jayave jei chupe reta umɨjaanga reve: —Penti cuimbae icocatu vae iavati yagüɨye cavi. ");
INSERT INTO gnwNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Jare cuimbae jei iyupe ipɨa pe: ‘¿Mbae ra ayapota? Mbaetɨ ma cheavati jendarã’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Jayave jei iyupe ipɨa pe: ‘Aicuaa ma. Ambaita cheavatío reta jare ambutuicha eteta cheavatío reta, jare joco pe añuvatuta opaete cheavati jare opaete uyeavɨro vae’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Jayave che jaeta cherecove pe cuarãi: ‘Cherecove, jeta ete ma mbaevɨro niñuvatu. Uepitɨta jeta año pegua. Eputuu, ecaru, ecau jare iyerovia.’ Cuarãi jaeta —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ẽrei Tumpa jei jocua cuimbae pe: ‘Nde co jae iyaracuaa mbae vae. Echa'ã cua pɨ̃tu aequita nderecove ndegüi. Jare jayave ¿quía ra güɨnoita opaete jocua mbaembae niñuvatu ndiyupeguarã vae?’ —jei, jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Jayave Jesús jei chupe reta: —Ime yave quía jeta mbaembae uñuvatu iyupeguarã vae, ẽrei icocatu'ã yave Tumpa cotɨ, uyeyapota chupe jocua cuimbae icocatu vae pe uyeyapo rami —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jayave Jesús jei jemimboe reta pe: —Jáeramo che jae peve, agüɨye piyemɨpɨa'ã perembiurã vae re. Jae ramiño vi agüɨye piyemɨpɨa'ã peremimonderã vae re —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ndarau pepuere pico cavi jecuaeño piyemɨpɨa'ã yave perembiurã vae re, jare peremimonderã vae re —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Pemae güɨra reta re. Echa'ã jae reta umaetɨ'ã jare umbaevɨro'ã vi. Mbaetɨ vi güɨnoi avatío uñuvatu vaerã iavati. Ẽrei Tumpa umɨngaru reta. Jare Tumpa perau ete güɨra reta güi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Aramoi piyemɨpɨa'ã pipota tẽi pepucu ramo. Ẽrei ndarau etei pepuere piyembɨcuacuaa pepucu ete vaerã —jei Jesús chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Mbaetɨ etei mbae pepuere piyapo cua re. Ẽrei cua yavai'ã co Tumpa pe. Jáeramo agüɨye piyemɨpɨa'ã ĩru mbaembae re —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Pemae mbaepotɨ reta re, quirãi ucuacuaa reta. Uparavɨquɨ'ã reta. Umaepova'ã reta vi. Ẽrei che jae peve, mbaepotɨ reta ipõra ete Salomón jemimonde ipõra vae güi. ");
INSERT INTO gnwNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Tumpa omopõra ñana, yepe tẽi penti ara ñana oĩ co pe jare pɨareve pe ocai. Jáeramo Tumpa umeeta co peve peremimonderã. Michi ete co pepurugüɨrovia —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Agüɨye piyemɨpɨa'ã perembiurã vae re, jare agüɨye piyemɨpɨa'ã ĩru mbaembae re —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Echa'ã opaete ɨvɨ pegua reta uyemɨpɨa'ã cua mbaembae re. Ẽrei peRu uicuaa icavi co penoi vaerã cua mbaembae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ẽrei icavi co pipota ete vaerã Tumpa iporoyocuia, jare Tumpa umeeta peve opaete cua mbaembae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Agüɨye pequɨye, yepe tẽi pe reta mbovɨ ete co. Echa'ã Tumpa umeeta co pe reta pico vaerã iporoyocuia pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Pemee corepoti re pembaembae, jare pemee corepoti uata chupe vae reta pe. Cuarãi piyapo yave, penoita mbaembae ara pegua. Jae co peurupucu ara pe penoita vae rami. Jocua nunga urupucu ndarau etei indechi jare jocua mbaembae icavi vae peurupucu ara pegua pe penoi vae ndarau ucañɨ. Echa'ã imonda vae ndarau oya jese jare cupii ndarau urucumegua —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Echa'ã piñuvatu yave mbaembae icavi vae piyupeguarã ɨvɨ pe, jecuaeño pepɨa pe piyemɨnguetata ɨvɨ pegua re. Ẽrei piñuvatu yave mbaembae icavi vae piyupeguarã ara pe, jecuaeño pepɨa pe piyemɨnguetata ara pegua re —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Yamɨjaanga peré uyeyocui vae reta. Uyeyocui vae reta ipatrón oo umenda vaerã yave, uyeyocui vae reta uãro ñugüɨnoi ipatrón ou ye regua. Uãro reta jare jecuaeño jendɨ imechero reta. Jare ipatrón ou ye uvãe yave ombopu onque, jupivoi jembiocui reta uipea onque ipatrón ipuere vaerã uique jenta pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Uyeyocui vae reta jecuaeño uãro ñugüɨnoi yave ipatrón ou ye uvãe yave, uyeroviata reta. Añete che jae peve, ipatrón uyembɨcuata toalla pe, jare jeita jembiocui reta pe uguapɨ vaerã mesa pe, jare ipatrón etei umɨngaruta jembiocui reta —jei Jesús—. ");
INSERT INTO gnwNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Aramoi ipatrón ou yeta uvãe pɨ̃tu ma yave ani pɨare mbɨte rupi. Ẽrei jae uecha yave jembiocui reta uãro ñugüɨnoi, jae reta uyeroviata co —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Aipota picuaa vaerã cua: Penti tenta iya uicuaa yave mbae ora pe outa uvãe imonda vae oñomi vaerã imbaembae, uñemɨcuatɨ̃rota tẽi jare ndarau tẽi umaeño imonda vae re güɨraa vaerã imbaembae chugüi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Jae ramiño vi pe reta peãro, agüɨye vaerã che cuimbaerã ayeyapo vae ayu ye avãe piyandareco'ã peĩ yave —jei chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Jayave Pedro jei Jesús pe: —CheYa, cua ndere ma nemɨjaanga reve. ¿Oreve peguarãño pa co cua? ani ¿opaete vae peguarã pa? —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Jayave yandeYa jei: —Penti uyeyocui vae iyaracuaa vae uyapo ipatrón jei chupe uyapo vaerã vae. Jare ipatrón umee chupe ico vaerã ĩru jembiocui reta juvicharã, jare umee vaerã chupe reta jembiurã opa ara —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ipatrón ou ye uvãe yave jenta pe, uecha yave jocua jembiocui uyapo oĩ iparavɨquɨ, jocua jembiocui uyeroviata co —jei chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Añete che jae peve, ipatrón umeeta chupe uyandareco vaerã opaete imbaembae re —jei Jesús—. ");
INSERT INTO gnwNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ẽrei aramoi uyeyocui vae jei iyupe ipɨa pe: ‘Chepatrón ndarau ou ye ɨmambae.’ Jare umbɨpɨ uinupa ĩru uyeyocui vae reta - cuimbae reta jare cuñatai reta - jare ucaru jare ucau jare usavɨpo —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Jayave penti ara ipatrón ou yeta uvãe jembiocui uyandareco'ã oĩ yave. Jocua ora pe etei ipatrón uipocouta. Jayave ipatrón uiporaraca eteta chupe jare omondota ico vaerã ipatrón iporoyocui uyapo mbae vae reta ndive —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ipatrón uiporaraca eteta. Echa'ã uyeyocui vae uicuaa tẽi ipatrón iporoyocui, ẽrei uyapo'ã —jei chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ẽrei ime yave uyeyocui vae uicuaa'ã ipatrón iporoyocui vae, yepe tẽi uiporarata co uyapo'ã ipatrón iporoyocui ramo, ẽrei ipatrón ndarau uiporaraca ete chupe. Echa'ã ipatrón uicuaaca yave jembiocui pe iporoyocui, icavi co jembiocui uyapo vaerã uicuaa vae rupi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Che ayu cua ɨvɨ pe tata ambɨyepota vaerã, jare chequɨrẽɨ ete opa cheparavɨquɨ ayapo —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Che aiporara eteta co jare yavai eteta cheve opa uyeyapo regua —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Pepɨa pe piyemɨngueta pa che ayu amee vaerã mbɨacatu ɨvɨ pegua reta pe? Che jae peve, jucuarãi'ã co. Che ayu uyembɨyao vaerã uyugüi ɨvɨ pegua reta —jei chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Echa'ã añave güive yugüɨreco yave pandepo penti tenta pe, uyembɨyaota co uyugüi reta. Mbapɨ oyovaichota mocui ndive, jare mocui oyovaichota mbapɨ ndive —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Tu oyovaichota taɨ ndive, jare taɨ oyovaichota tu ndive. Ichɨ oyovaichota imembɨ cuña ndive, jare imembɨ cuña oyovaichota ichɨ ndive. Imesɨ oyovaichota imembɨ-tatɨ ndive, jare imembɨ-tatɨ oyovaichota imesɨ ndive —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jare Jesús jei yatɨ vae reta pe: —Peecha yave amapɨ̃tu uyeyapo oĩ guarasɨ uique vae cotɨ, jupivoi pere: ‘Oquɨta co.’ Jare jucuarãi uyeyapo —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Jae ramiño vi tanta ɨvɨtu yave, pere: ‘Aracuta co.’ Jare jucuarãi uyeyapo —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Pe reta co jae upurumbɨtavɨ vae reta. Echa'ã ara jare ɨvɨ re pemae yave, picuaa mbae uyeyapota vae. Ẽrei picuaa'ã etei mbae añave uyeyapo oĩ vae —jei chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","¿Maera pa peatẽɨ picuaa mbae jupi piyapo vaerã vae? —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ndeo yave uipota uñeapo nderé mbae re vae ndive mburuvicha pe, tape rupi peo rambueve iyeyapɨcatu jae ndive, agüɨye vaerã jae uñeapo nderé mburuvicha pe. Echa'ã mburuvicha nemondota peresorɨru iyandarecoa pe, jare peresorɨru iyandarecoa neñonota peresorɨru pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Che jae ndeve, ndarau etei neẽ peresorɨru güi ndei opaete ndepía nembɨepɨ mbove —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Jare amocue joco pe ñugüɨnoi vae reta umɨmbeu Jesús pe quirãi Pilato uyucaca amocue Galilea pegua reta, jae reta maemɨmba uyeyucacue reta umee Tumpa pe ñugüɨnoi rambueve. ");
INSERT INTO gnwNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jayave Jesús jei chupe reta: —Aramoi pe reta pepɨa pe piyemɨngueta jucuarãi uyeyapo jocua Galilea pegua reta pe, jae reta iyoa ete opaete ĩru Galilea pegua reta güi ramo. ");
INSERT INTO gnwNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Che jae peve, jucuarãi'ã co. Jare peeya'ã yave piyemɨngueta icavi mbae vae pepɨa pe oĩ vae, pe reta pecañɨteita vi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Jare jocua torre Siloé pe oĩse vae usururu jocua dieciocho vae re jare uyuca reta. Aramoi pe reta pepɨa pe piyemɨngueta jocua dieciocho vae iyoa ete opaete ĩru Jerusalén pegua reta güi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Che jae peve, jucuarãi'ã co. Jare peeya'ã yave piyemɨngueta icavi mbae vae pepɨa pe oĩ vae, pe reta pecañɨteita vi —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jayave Jesús jei chupe reta umɨjaanga reve: —Penti cuimbae güɨnoi ico pe penti ɨva. Oo tẽi ueca ɨva ía. Uvãe'ã chupe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Jayave jei ico pe uparavɨquɨ chupe vae pe: ‘Mase, mbapɨ año ma ayu tẽi aeca cua ɨva ía jare avãe'ã chupe. Iyasɨa. Ñañotɨta tẽi ĩru temitɨ jendacue pe’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Jayave co pe uparavɨquɨ vae jei co iya pe: ‘Patrón, emaeño tupɨta ye penti año pegua. Tayoo rani iyɨpɨ rupi jare tañono vacarepoti iyɨpɨ rupi’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","‘Jayave ía yave, icavita co. Ẽrei ia'ã yave, ndepuereta ndiyasɨaca’ —jei, jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Jare Jesús oporomboe oĩ penti judío reta itupao pe mbutuu ara pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Jare uecha joco pe penti cuña dieciocho año ma imbaerasɨ vae. Jecuaeño ipe ete. Ipuere'ã etei uyemboɨ cavi. ");
INSERT INTO gnwNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jare Jesús uecha ma yave, jei chupe: —Eyu checotɨ, cuña. Ndecuera ma co nembaerasɨ güi —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Jayave Jesús oñono ipo cuña iñãca re. Jare jupivoi cuña ipuere uyemboɨ cavi jare umbɨpɨ umbɨadora Tumpa. ");
INSERT INTO gnwNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Jayave tupao re uyandareco vae pochɨ cua re. Echa'ã Jesús umbɨgüera cuña mbutuu ara pe. Jáeramo tupao re uyandareco vae jei joco pe ñugüɨnoi vae reta pe: —Icavi co yaparavɨquɨ vaerã seis ara. Peyu jocua seis ara pecuera vaerã. Agüɨye peyu pecuera vaerã mbutuu ara pe —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ẽrei yandeYa jei chupe: —Pe reta co jae upurumbɨtavɨ vae reta. Pe reta piyora pegüeye jare pemburica jenda güi mbutuu ara pe peraa vaerã pembɨu —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Mase, cua cuña Abraham iñemoñaa reta pegua co. Ẽrei Satanás dieciocho año ma umɨmbaerasɨ. ¿Icavi'ã pa che ambɨgüera vaerã cua mbaerasɨ güi mbutuu ara pe? —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jare cua Jesús jei ma yave, opaete Jesús jovaicho reta imara. Echa'ã opaete joco pe ñugüɨnoi vae reta uyerovia opaete icavi ete vae Jesús uyapo vae re. ");
INSERT INTO gnwNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jayave Jesús jei: —¿Mbae ra ipuere uyemɨjaanga Tumpa iporoyocuia re? ¿Mbae ra amɨjaangata jese? ");
INSERT INTO gnwNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Yandepuere yamɨjaanga jese penti mostaza jãɨcue —jei—. Uñeñotɨ yave, ucuacuaa jare uyeyapo ɨvɨra tuicha vae. Jare güɨra reta yugüeru uyapo jaitɨrã jese —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jayave jei chupe reta: —¿Mbae ra amɨjaangata Tumpa iporoyocuia re? ");
INSERT INTO gnwNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Yandepuere yamɨjaanga jese levadura —jei—. Cuña umbɨyea levadura jeta catu harina ndive, levadura uñemɨai vaerã opaete masa rupi —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jare Jesús uguata opaete tenta guasu reta jare tenta guasu-raɨ reta rupi, jare oporomboe joco pe. Jare jecuaeño oo Jerusalén cotɨ. ");
INSERT INTO gnwNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Jayave penti vae upɨrandu Jesús pe: —CheYa, ¿ime pa mbovɨ catu uyembɨasacata vae? Jayave Jesús jei joco pe ñugüɨnoi vae reta pe: ");
INSERT INTO gnwNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Piñemɨmɨrãta pique vaerã onque ipɨ-raɨ vae rupi. Echa'ã che jae peve, jeta vae uipota tẽita uique, ẽrei ndarau ipuere —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Echa'ã tenta iya uyequenda ma yave onque, pe reta pepɨtata oca pe. Jayave pemboputa tẽi onque jare pereta tẽi: ‘OreYa, ipea onque oreve.’ Ẽrei jae jeita peve: ‘Che pucuaa'ã’ —jeita, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Jayave pereta: ‘Nducaru nderovaque, jare nde ndeporomboe orecalle reta rupi’ —pereta, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ẽrei jae jeita peve: ‘Che jae peve, che pucuaa'ã. Pe reta co jae icavi mbae vae uyapo vae reta. Pesɨrɨ chegüi’ —jeita peve, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Jayave piyaota jare perãi pembɨquɨrɨrɨuta. Echa'ã peechata Abraham jare Isaac jare Jacob jare opaete Tumpa iñee aracae umɨmbeu vae reta Tumpa iporoyocuia pe ñugüɨnoi. Ẽrei pe reta oca pe pẽita —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Yugüeruta reta opaete que rupi rupi güi, jare uguapɨta reta Tumpa iporoyocuia pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ẽrei pemandúa cua re: Amocue añave uñemɨmichi vae uyembɨtenondecata co, jare amocue añave uyembutuicha vae uyembɨtaɨcuecata co —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Jocua ara yugüeru Jesús oĩ vae pe amocue fariseo reta. Jae reta jei Jesús pe: —Ecua cua güi. Echa'ã Herodes uipota ndeyucaca. ");
INSERT INTO gnwNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jayave Jesús jei chupe reta: —Herodes co jae penti aguara rami. Pecua ipɨ jare pemɨmbeu chupe quirãi jecuae ambɨsɨrɨta aña reta oya jese vae reta güi jare ambɨgüerata imbaerasɨ vae reta añave jare curiye. Jare cõeramo opata co cheparavɨquɨ —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Añete co, icavi co jecuaeño aa Jerusalén cotɨ añave jare curiye jare cõeramo. Echa'ã Jerusalén peño judío reta uyuca Tumpa iñee umɨmbeu vae reta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Jerusalén pegua reta, pe reta piyuca Tumpa iñee aracae umɨmbeu vae reta. Pe reta piyapi ita pe piyuca Tumpa ombou peve vae reta. Jeta vese ma chequɨrẽɨ tẽi pumbatɨ, uru umbatɨ imembɨ reta ipepo igüɨ pe rami, ẽrei pe reta pipota'ã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Mase, Tumpa usɨrɨta ma pegüi. Che jae peve, ndarau ma cherecha pere regua: ‘Tuyembɨadoraca yandeYa jee re ou vae’ —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Jare penti mbutuu ara pe Jesús oo uique penti fariseo reta itenondegua jenta pe ucaru vaerã jae ndive. Jare fariseo reta umae ñugüɨnoi Jesús re. ");
INSERT INTO gnwNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Jare Jesús uecha joco pe penti cuimbae opaete jete iruru vae. ");
INSERT INTO gnwNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jayave Jesús upɨrandu mboroyocui re oporomboe vae reta jare fariseo reta pe: —¿Jei pa mboroyocui yandepuere yambɨgüera vaerã quía mbutuu ara pe? ");
INSERT INTO gnwNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ẽrei jae reta quĩiño. Jayave Jesús oñono ipo cuimbae imbaerasɨ vae re jare umbɨgüera. Jayave jei chupe oo vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Jayave Jesús jei joco pe ñugüɨnoi vae reta pe: —Pemburica ani pegüeye uasavi yave penti ɨvɨcua pe mbutuu ara pe, jupivoi peo penoẽ joco güi —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Jare joco pe ñugüɨnoi vae reta ipuere'ã mbae jei Jesús pe cua regua. ");
INSERT INTO gnwNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jayave Jesús uecha quirãi opaete tenta iya uparea chupe vae reta uiparavo tenda icavi vae. Jayave jei chupe reta umɨjaanga reve: ");
INSERT INTO gnwNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Penti cuimbae uparea ndeve yave menda vae pe, agüɨye eguapɨ tenda tenondegua vae pe. Echa'ã aramoi tenta iya uparea vi ĩru uipɨu ete ndegüi vae pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Jayave tenta iya güeruta jocua ĩru vae ndeguapɨ vae pe jare jeita ndeve: ‘Emee cua cuimbae pe nerenda.’ Jayave nde nemarata co ndeo ndeguapɨ tenda taɨcuegua vae pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ẽrei tenta iya uparea ndeve yave, ecua eguapɨ tenda taɨcuegua vae pe. Echa'ã ou yave tenta iya, aramoi jeita ndeve: ‘Cheamigo, ecua eguapɨ penti tenda tenondegua vae pe.’ Jucuarãi ndiyepɨucata opaete yugüeru ucaru vaerã vae reta jovaque —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Echa'ã ime yave quía uyembutuicha vae, uñemɨmichicata co. Jare ime yave quía uñemɨmichi vae, uyembutuichacata co —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jayave Jesús jei tenta iya pe: —Ndipota yave ndepurumɨngaru, agüɨye eparea neamigo reta jare nerentarã reta jare nerentaɨgua icocatu vae reta pe. Echa'ã chupe reta ndeparea yave, jae reta upareata ndeve nde ndeparea chupe reta ramo —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ẽrei ndipota yave ndepurumɨngaru, eparea iparavete vae reta jare ipo chutu vae reta jare icõcho vae reta jare jesa mbae vae reta pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Jucuarãi ndiyapo yave, Tumpa nemɨvendiseta. Echa'ã jae reta ndarau ipuere nemɨngaru. Ẽrei Tumpa umbɨjecoviata ndeve jupi vae reta icove ye yave yugüeru umanocue vae reta ipɨte güi —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Jare penti jae ndive uguapɨ oĩ mesa pe vae cua uyandu yave, jei Jesús pe: —Tumpa iporoyocuia pe ucaruta vae uyemɨvendiseta co. ");
INSERT INTO gnwNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jayave Jesús jei chupe: —Penti cuimbae uyapoca jeta tembíu jare uparea jeta vae pe ucaru vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Tembíu oyɨ ma yave, omondo jembiocui jei vaerã uparea chupe vae reta pe: ‘Peyu. Echa'ã opaete uñeñono ma mesa pe’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ẽrei penti penti jei uyeyocui vae pe ipuere'ã oo ucaru vaerã. Penti vae jei chupe: ‘Agua ma checorã jare icavi co aa vaerã amae jese. Jáeramo chepuere'ã aa. Ere ndepatrón pe chembɨasa vaerã’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Jare ĩru vae jei chupe: ‘Agua ma diez güeye. Aata amboporova reta. Jáeramo chepuere'ã aa. Ere ndepatrón pe chembɨasa vaerã’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Jare ĩru vae jei chupe: ‘Amenda ramo ete. Jáeramo chepuere'ã aa’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Jayave uyeyocui vae ou ye ipatrón pe jare umɨmbeu chupe opaete cua regua. Jayave ipatrón pochɨ reve jei jembiocui pe: ‘Ecua voi opaete calle rupi jare eru cua pe iparavete vae reta jare ipo chutu vae reta jare icõcho vae reta jare jesa mbae vae reta’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Uyapo ma yave jucuarãi, uyeyocui vae jei ipatrón pe: ‘Patrón, ayapo ma ndeporoyocui, jare imeño ĩru vae reta jendarã’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Jayave ipatrón jei jembiocui pe: ‘Ecua ye opaete tape rupi jare ere nevãe chupe vae reta pe yugüeru vaerã, tɨnee vaerã cherenta’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","‘Echa'ã che jae peve, mbaetɨ penti ave jocua tenonde voi aparea chupe vae ucaruta cherenta pe’ —jei, jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Jare jeta vae uyembatɨ Jesús oĩ vae pe. Jayave Jesús umae jese reta jare jei chupe reta: ");
INSERT INTO gnwNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Ime yave quía uipota oo cherupíe vae, cherau ete'ã yave tu jare ichɨ jare jembireco jare isambiaɨ reta jare jentarã reta güi, jare uyerau ete yave chegüi, ndarau ipuere ico cheremimboerã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Jare ime yave quía ovoɨ'ã icurusu oo vaerã cherupíe vae, ndarau ipuere ico cheremimboerã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Penti cuimbae iquɨrẽɨ yave uyapo torre, uguapɨta rani uipapa vaerã mbovɨ ra jepɨta, uicuaa vaerã icorepoti uepitɨta ra opa uyapo vaerã —jei chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Echa'ã uyapo'ã yave jucuarãi, aramoi oñonota torre iguapɨcarã, ẽrei ndarau uepitɨ icorepoti opa uyapo vaerã. Jáeramo opaete uecha vae reta oyoyaita jocua cuimbae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Echa'ã jeita reta: ‘Jocua cuimbae umbɨpɨ tẽi uyapo torre, ẽrei ipuere'ã opa uyapo’ —jeita, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Jae ramiño vi penti mburuvicha guasu iquɨrẽɨ yave oo uñerãro ĩru mburuvicha guasu ndive, uguapɨta rani ipɨa pe uyemɨngueta cavi vaerã jese, uicuaa vaerã jocua diez mil isundaro reta ipuereta ra umɨamɨri jocua veinte mil sundaro reta jovaicho güɨnoi vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Echa'ã ipɨa pe uyemɨngueta yave isundaro reta ndarau umɨamɨri jovaicho isundaro reta, mbɨrɨ jovaicho güi oĩ rambueve, omondota amocue vae reta uyerure vaerã chupe agüɨye vaerã uñerãro jae ndive —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Jae ramiño vi ime yave quía pepɨte pe opaete imbaembae ueya'ã vae, ndarau ipuere ico cheremimboerã —jei chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Yuquɨ icavi co yau vaerã. Ẽrei jembochɨ'ã ma yave, ¿quirãita ra jembochɨ ye? —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Icavi'ã ma mbaerã. Icavi'ã yepe ɨvɨ peguarã. Yamomboño. Uipota uyandu vae tuyapɨsaca cua re —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Jayave uyembatɨ Jesús oĩ vae pe jeta mburuvicha peguarã ocovara vae reta jare teco icavi mbae vae uyapo vae reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Jayave fariseo reta jare mboroyocui re oporomboe vae reta iñeenguru jese. Jae reta jei: —Cua cuimbae uñemɨĩru teco icavi mbae vae uyapo vae reta ndive, jare ucaru jae reta ndive. ");
INSERT INTO gnwNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Jayave Jesús jei chupe reta umɨjaanga reve: ");
INSERT INTO gnwNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Penti cuimbae güɨnoi yave cien ovecha, umɨcañɨ yave penti, ueya ĩru noventa y nueve ñana pe jare oo ueca ucañɨ vae uvãe chupe regua —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Jare uvãe ma chupe yave, ovoɨ güeru ye iyatiɨ re uyerovia reve —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Jare ou ye uvãe yave jenta pe, umbatɨ opaete iamigo reta jare jentaɨgua reta, jare jei chupe reta: ‘Piyerovia che ndive. Avãe ye ma cheovecha ucañɨ vae’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Che jae peve, jae ramiño vi ara pegua reta uyerovia eteta iyoa vae ueya yave iyemɨngueta icavi mbae vae ipɨa pe oĩ vae. Jucuarãita'ã uyerovia noventa y nueve ‘jupi co che’ jei vae reta re. Echa'ã jae reta jei tẽi: ‘Mbaetɨ anoi yemɨngueta icavi mbae vae chepɨa pe’ —jei reta, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Jae ramiño vi penti cuña güɨnoi yave diez corepoti, umɨcañɨ yave penti, umɨendɨ mechero jare utupei opaete tenta rupi. Ueca cavi uvãe chupe regua —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Jare uvãe ma chupe yave, umbatɨ opaete iamiga reta jare jentaɨgua reta, jare jei chupe reta: ‘Piyerovia che ndive. Avãe ye ma corepoti amɨcañɨ vae’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Che jae peve, jae ramiño vi ángel Tumpa pe uyeyocui vae reta uyerovia ete iyoa vae ueya yave iyemɨngueta icavi mbae vae ipɨa pe oĩ vae —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jayave Jesús jei chupe reta: —Penti cuimbae güɨnoi mocui taɨ. ");
INSERT INTO gnwNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Jare taɨ taɨcuegua vae jei tu pe: ‘Cheru, emee cheve añave voi mbaembae nde nemano ma yave anoita vae’ —jei, jei—. Jayave tu umbɨyao imbaembae umee taɨ reta pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Jayave mbovɨ ara rupi taɨ taɨcuegua vae umbatɨ umee opaete imbaembae jare oo mbɨrɨ ambɨe ɨvɨ pe. Joco pe uyapo jeta parea jare jucuarãi opa umɨngasta iyugüi opaete icorepoti —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Jare opa icorepoti umɨngasta yave, ou caruai tuicha vae jocua ɨvɨ pe, jare cuimbae mbaetɨ ma mbae güɨnoi jou vaerã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Jayave oo uyerure penti patrón pe umee vaerã chupe mbaravɨquɨ. Jayave jocua patrón omondo jenta pe umɨngaru vaerã cuchi reta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Jare cuimbae uipota tẽi uyemɨngapɨɨ ɨvope cuchi reta jou vae pɨpe. Jare mbaetɨ quía umee chupe jou vaerã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Jare cuimbae uicuaa ma quirãi uyapo iyaracuaa mbae vae uyapo vae rami. Jayave jei iyupe ipɨa pe: ‘Cheru umɨmbaravɨquɨ vae reta jeta güɨnoi jou vaerã. Ẽrei che amanota ma aĩ yembaɨ pɨpe’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Taa ye cua güi cheru pe jare tae chupe: ‘Cheru, cheyoa ma Tumpa cotɨ jare ndecotɨ vi. ");
INSERT INTO gnwNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Jupi'ã ma aico vaerã nderaɨrã. Emee cheve mbaravɨquɨ ĩru nemɨmbaravɨquɨ vae reta pe nemee rami’ —jaeta, jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Jayave uñatima ye tu jenta cotɨ. Ẽrei mbɨrɨ catu oĩ rambueve, tu uecha jare uiparareco. Jayave tu osi oovãiti taɨ, jare uicuãva jare uyurupɨte —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Jayave taɨ jei tu pe: ‘Cheru, cheyoa ma Tumpa cotɨ jare ndecotɨ vi. Jupi'ã ma aico vaerã nderaɨrã’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ẽrei tu jei jembiocui reta pe: ‘Peru voi temimonde icavi vae pemondeca chupe. Jae ramiño vi piñono moãcaregua ipoãca re jare mbɨapasa ipɨ re’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","‘Jare peru cua pe vaca taɨrusu vae amɨnguɨra vae piyuca. Yacaru jare yayerovia’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","‘Echa'ã tenonde yave cua cheraɨ penti umanocue vae rami co cheve, ẽrei añave icove ye ma cheve. Tenonde yave ucañɨ chegüi, ẽrei añave avãe ye ma chupe’ —jei, jei—. Jare umbɨpɨ reta uyembɨyerovia —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Jare taɨ tenondegua vae uparavɨquɨ oĩ co pe. Jare ou ye oĩ yave coiño ma tenta güi, uyandu uyemimbɨ ñugüɨnoi tenta pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Jayave ueni penti tu jembiocui jare upɨrandu chupe mbae ra co jocua uyandu vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Jayave uyeyocui vae jei chupe: ‘Nderɨvɨ ou ye ma, jare nderu uyucaca vaca taɨrusu vae umɨnguɨra vae, taɨ ou ye icavi uvãe ramo’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Jayave taɨ tenondegua vae pochɨ jare uique'ã tenta pe. Jayave tu oẽ tenta güi jare jei taɨ pe uique vaerã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Jayave taɨ tenondegua vae jei tu pe: ‘Mase, jeta año ma ayeyocui ndeve. Jecuaeño ayapo ndeporoyocui. Ẽrei nemee'ã etei cheve capura-raɨ yepe, aparea vaerã cheamigo reta pe nducaru vaerã’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","‘Jare cua nderaɨ ico cuña aguasa rupi ico vae reta ndive jare jucuarãi umɨngasta opaete nde nemee chupe vae. Ẽrei jae ou ye uvãe rupive, ndiyucaca chupe vaca taɨrusu vae nemɨnguɨra vae’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Jayave tu jei taɨ tenondegua vae pe: ‘Cheraɨ, jecuaeño nde ndico che ndive, jare opaete chembae nembae co’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","‘Icavi co yayerovia vaerã. Echa'ã tenonde yave cua nderɨvɨ penti umanocue vae rami co cheve, ẽrei añave icove ye ma cheve. Tenonde yave ucañɨ chegüi, ẽrei añave avãe ye ma chupe’ —jei, jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jare Jesús jei jemimboe reta pe: —Ico penti patrón icocatu vae jare ime güɨreco jembiocui. Jerãcua patrón pe quirãi jembiocui opa umɨngasta imbaembae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Jayave jocua patrón ueni jembiocui jare jei chupe: ‘¿Mbae pa co cua nererãcua cheve vae? Emɨmbeu cheve mbae ndiyapo opaete chembaembae ndive vae. Echa'ã nomoẽta co’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Jayave uyeyocui vae jei iyupe ipɨa pe: ‘¿Mbae ra ayapota? Echa'ã chepatrón chemoẽta. Chepuere'ã ayoo ɨvɨ corepoti amɨngana vaerã. Chepuere'ã vi ayerure ĩru vae reta pe mbaembae re. Echa'ã chemarata co’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","‘Aicuaa ma mbae ayapota vae. Cuarãi ayapo yave, chepatrón chemoẽ ma yave, ĩru vae reta uyandarecota cheré’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Jayave omondo umɨmbeu vaerã opaete ipatrón pe mbae re ipía vae reta yugüeru vaerã ipɨ. Jayave upɨrandu tenonde ou vae pe: ‘¿Mbovɨ pa ndepía chepatrón pe?’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","‘Cien lata aceite’ —jei, jei—. Jayave uyeyocui vae jei chupe: ‘Co oĩ ndetupapire. Eguapɨ voi jare icuatía cincuenta lata’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Jayave upɨrandu ĩru vae pe: ‘¿Mbovɨ pa ndepía chepatrón pe?’ —jei, jei—. ‘Cien arroba trigo’ —jei, jei—. Jayave uyeyocui vae jei chupe: ‘Co oĩ ndetupapire. Icuatía ochenta arroba’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Jare patrón icocatu vae jei jembiocui jupi mbae vae uyapo vae pe: ‘Icavi ete ndiyapo ndiyupe. Ndearacuaa co’ —jei, jei—. Echa'ã cua ɨvɨ pegua reta iyaracuaa ete corepoti re Tumpa pe uyeyocui vae reta güi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Che pumbɨaracuaa piporu vaerã pecorepoti pemborɨ vaerã ĩru vae reta. Jayave jae reta uyeyapota peamigo retarã. Echa'ã pemano yave, opata peeya pecorepoti. Ẽrei ara pe peamigo reta pembɨresiveta jare joco pe picota jaeño mai pegua —jei Jesús chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ime yave quía yandepuere yarovia catu mbae michi vae re vae, yandepuere vi yarovia catu mbae tuicha vae re. Jae ramiño vi ime yave quía upurumbɨtavɨ mbae michi vae re vae, upurumbɨtavɨta vi mbae tuicha vae re —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Jáeramo Tumpa ipuere'ã yave pererovia catu corepoti re, ndarau vi pererovia catu mbaembae icavi vae ara pegua re —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Jare ime yave quía yandepuere'ã yarovia catu ĩru vae icorepoti re vae, ndarau ñamee chupe corepoti güɨnoi vaerã iyupeguarã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Penti uyeyocui vae uipota yave uyeyocui mocui patrón pe, umɨtarẽɨta penti patrón jare uauta ĩru vae, ani uparavɨquɨ cavita penti patrón pe jare güɨrɨ̃rota ĩru vae. Pepuere'ã piyeyocui Tumpa pe corepoti peau reve —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Jare fariseo reta cua uyandu yave, oyoyai Jesús. Echa'ã jae reta uipota ete corepoti. ");
INSERT INTO gnwNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jayave Jesús jei chupe reta: —Pe reta piyembujupi ĩru vae reta jovaque. Ẽrei Tumpa uicuaa pepɨa pe oĩ vae. Jare yepe tẽi ĩru vae reta pepɨu, ẽrei Tumpa uicuaa piyapo vae icavi mbae co —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Ndei Juan ou mbove, Tumpa umɨmbeu yandeve yayapo vaerã mboroyocui jare Tumpa iñee aracae umɨmbeu vae reta jei vae. Ẽrei Juan umbɨpɨ umɨmbeu ñee icavi vae Tumpa iporoyocuia regua, jare opaete vae uipota uique Tumpa iporoyocuia pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ara jare ɨvɨ opata. Ẽrei yandepuere'ã etei yambai mboroyocui —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Ime yave quía omombo jembireco vae, güɨreco yave ĩru vae jembirecorã, uyuvanga menda re. Jare ime yave quía uyemombo ma vae güɨreco vae, jae vi uyuvanga menda re —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ico penti cuimbae icocatu vae. Jecuaeño uyemonde icavi ete jare opa ara rupi uyapoca tembíu icavi vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Jare ico vi ĩru cuimbae Lázaro jee vae. Jae co iparavete vae. Lázaro ituyu yepai ico. Opa ara rupi uguapɨ cuimbae icocatu vae jonque jovai —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Lázaro uipota jou tembíu usururucue cuimbae icocatu vae imesa güi oa vae. Jare yɨmba reta yugüeru uere Lázaro ituyu —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Jare penti ara jocua cuimbae iparavete vae umano, jare ángel reta güɨraa ara pe Abraham oĩ vae pe. Jae ramiño vi cuimbae icocatu vae umano jare uñeñotɨca —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Jare cañɨtei pe cuimbae icocatuse vae uiporara ete oĩ. Jayave jovaɨva jare uecha Abraham mbɨrɨ oĩ chugüi. Uecha vi Lázaro Abraham ndive —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Jayave iñeeãta reve jei: ‘Cheru Abraham, cheparareco. Embou Lázaro oñono vaerã ipoãca ɨ pe umãquɨ vaerã checũ. Echa'ã aiporara ete aĩ cua tata pe’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ẽrei Abraham jei chupe: ‘Cheraɨ, nemandúa quirãi nde ndico ɨvɨ pe yave, nde nenoise mbaembae icavi vae. Jae ramiño vi Lázaro ico ɨvɨ pe yave, mbaembae icavi mbae vae uyeyapo chupe. Ẽrei añave jae ipɨacatu oĩ jare nde ndiporara neĩ’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","‘Jae ramiño vi ime oĩ mbae ñanepãu pe yandepuere'ã yaasa vae. Jáeramo nduipota yave ndoo pepɨ, ndarau orepuere. Jae ramiño vi pipota yave peyu orepɨ, ndarau pepuere’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Jayave cuimbae icocatuse vae jei Abraham pe: ‘Cua jeco pegua ayerure ndeve, cheru, nemondo vaerã Lázaro cheru jenta pe’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","‘Echa'ã che ime anoi pandepo cherɨvɨ reta. Emondo umɨmbeu vaerã chupe reta, agüɨye vaerã jae reta vi yugüeru cua jasɨ catu noĩ vae pe’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Jayave Abraham jei chupe: ‘Ime güɨnoi Moisés iporoyocui jare Tumpa iñee aracae umɨmbeu vae reta uicuatía vae. Tumɨngueta reta jocua’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Jayave cuimbae icocatuse vae jei Abraham pe: ‘Ndarau umɨngueta reta, cheru Abraham. Ẽrei uyecuaa yave chupe reta umanocue vae, ueyata reta iyemɨngueta icavi mbae vae ipɨa pe oĩ vae’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Jayave Abraham jei chupe: ‘Uipota'ã yave uyapɨsaca Moisés iporoyocui jare Tumpa iñee aracae umɨmbeu vae reta uicuatía vae re, ndarau uyapo Tumpa jei uyapo vaerã vae yepe tẽi quía icove ye oo chupe reta umanocue vae reta ipɨte güi’ —jei, jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jayave Jesús jei jemimboe reta pe: —Jecuaeño yugüɨrecota upurumbɨavai vae reta. Ẽrei upurumbɨavai vae reta uiporarata co —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Icavita tẽi co ĩru vae reta uñapɨ̃ti vaerã iyayu re penti ita tuicha vae umbaeso pɨpe vae, jare omombo vaerã ɨ guasu pe, agüɨye vaerã uyapoca tẽi mbaeyoa penti cheré güɨrovia vae pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Piñemoa ngatu. Nderɨvɨ uyapo yave icavi mbae vae ndeve, embɨaracuaa. Jare jae ipɨatɨtɨ yave jeco re, embɨasa chupe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Jare uyapo yave icavi mbae vae ndeve siete vese penti ara pe, jare jei yave ndeve siete vese jocua ara pe: ‘Ndarau ma ayavɨ ndecotɨ’, embɨasa chupe —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Jayave yandeYa jemimondo reta jei chupe: —Emɨmbeu oreve quirãi orepurugüɨrovia ipuere uñemɨĩru. ");
INSERT INTO gnwNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Jayave yandeYa jei chupe reta: —Aramoi pepurugüɨrovia michi ete penti mostaza jãɨcue michi-raɨ vae rami. Ẽrei jocua nunga mburugüɨrovia penoi yave, pepuereta pere cua ɨvɨra sicómoro jee vae pe: ‘Ecua cua güi epɨta ɨ guasu pe’, jare ɨvɨra uyapota pere vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Aramoi penti uyeyocui vae oo co pe umbɨara vaerã ani umɨngaru vaerã maemɨmba reta. Iparavɨquɨ opa ma uyapo yave, ou ye ipatrón jenta pe. Ẽrei ipatrón jei'ã etei chupe: ‘Eyu eguapɨ cua mesa pe ecaru.’ Jucuarãi'ã jei chupe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Echa'ã ipatrón jei chupe: ‘Ecua rani emboyɨ mbae jau vaerã. Jayave javoi pegua eru cheve cherembiurã. Jare che opa ma acaru yave, ndepuereta ndecaru’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Jare ipatrón umee'ã etei yasurupai jembiocui pe jembiocui uyapo jei vae ramo —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Jae ramiño vi pe reta piyapo ma yave opaete Tumpa jei peve piyapo vaerã vae, pere piyupe: ‘Ayapo'ã mbae ayembutuichaca vaerã cheYa pe. Echa'ã jaeño ayapo jupi ayapo vaerã vae.’ Jucuarãi pere —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jare Jesús ooñoi Jerusalén cotɨ. Jayave oo uvãe Samaria jare Galilea ipãu pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Jare oo penti tenta guasu-raɨ pe uvãe, jare joco pe yugüeru Jesús cotɨ diez cuimbae ipire ocui vae reta. Ẽrei jae reta upɨta mbɨrɨ catu Jesús güi. ");
INSERT INTO gnwNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Jayave jae reta iñeeãta reve jei Jesús pe: —Jesús, oporomboe vae, oreparareco. ");
INSERT INTO gnwNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jare Jesús uecha reta yave, jei chupe reta: —Pecua sacerdote reta pe, jae reta umae vaerã peré —jei. Jare yugüɨraa rambueve, aramoiño ocui'ã ma ipire. ");
INSERT INTO gnwNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Jare penti cuimbae ou ye ĩru cuimbae reta ipɨte güi jare iñeeãta reve jei: —Tumpa tuyembɨadoraca. Echa'ã uicuaa ucuera ma co imbaerasɨ güi. ");
INSERT INTO gnwNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Jayave uyeatɨca Jesús jovai jare umee yasurupai chupe. Jae co Samaria pegua. ");
INSERT INTO gnwNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jayave Jesús jei: —Ambɨgüera diez cuimbae reta. Ẽrei nueve yugüeru'ã ye —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Cua pentiño ou ye umbɨadora vaerã Tumpa. Jare cua judio'ã co —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Jayave jei cuimbae pe: —Epũa iyemboɨ jare ecua nerenta pe. Ndecuera ma, nderovia cheré ramo —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Jare fariseo reta upɨrandu Jesús pe quirãi yave ra uyecuaata Tumpa iporoyocuia. Jayave Jesús jei chupe reta: —Tumpa iporoyocuia ndarau uyecuaa pe reta pesareco jese vae rupi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Jae ramiño vi ndarau quía jei: ‘Mase, co oĩ’, ani: ‘Mase, pee oĩ.’ Echa'ã Tumpa iporoyocuia ime ma pepɨte pe oĩ —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Jayave Jesús jei jemimboe reta pe: —Outa ara reta pipota vaerã tẽi cherecha - che cuimbaerã ayeyapo vae - penti ara yepe, ẽrei ndarau cherecha —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Jayave ĩru vae reta jeita peve: ‘Mase, co oĩ’, ani: ‘Mase, pee oĩ.’ Ẽrei agüɨye pecua jae reta ndive —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Tamɨjaanga ama uvera vae. Ama uvera vae uyecuaa opaete ara re. Jae ramiño vi che cuimbaerã ayeyapo vae ayecuaata opaete vae pe ayu ye yave —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ẽrei aiporara eteta rani jare añave yugüɨreco vae reta ndarau uipota aico vaerã juvicha guasurã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Picuaa co quirãi ɨvɨ pegua reta uyapo icavi mbae vae Noé ico rambueve. Jae ramiño vi uyapota reta icavi mbae vae che cuimbaerã ayeyapo vae ayu ye yave —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Echa'ã Noé ico rambueve, ɨvɨ pegua reta ucaruñoi jare ucauñoi yugüɨreco, jecuaeño cuimbae reta umenda cuñatai reta ndive jare tu reta umee tayɨ reta cuimbae reta pe umenda jae ndive vaerã. Ẽrei penti ara Noé uique jocua chalana guasu pe. Jayave ou ɨporu guasu jare opa uyuca reta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Jae ramiño vi Lot ico rambueve, Sodoma pegua reta ucaruñoi jare ucauñoi jare jecuaeño ogua mbaembae jare umee mbaembae, jare jecuaeño umaetɨ jare uyapo jenta retarã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ẽrei jocua ara Lot oẽ Sodoma güi yave, Tumpa ombou tata jare azufre jare opa uyuca Sodoma pegua reta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Jucuarãita vi uyeyapo che cuimbaerã ayeyapo vae ayecuaa yave —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Jocua ara ime yave penti cuimbae o cupe re oĩ vae, o cupe güi ugüeyɨ yave, agüɨye tuique jo pe güɨraa vaerã imbaembae. Jae ramiño vi ime yave penti cuimbae co pe oĩ vae, agüɨye tou ye jenta pe —jei Jesús chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Pemandúa Lot jembireco pe uyeyapo vae re —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Uipota uñuvatu jecove vae ndarau ipuere uñuvatu. Ẽrei jocua umeeta jecove vae uñuvatuta co —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Che jae peve, jocua pɨ̃tu mocui vae uyapacuata ñugüɨnoi jupa pe. Tumpa güɨraacata penti vae jare ĩru vae upɨtata jupa pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Jae ramiño vi mocui cuña umbaesota ñugüɨnoi. Tumpa güɨraacata penti cuña jare ĩru cuña upɨtata —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Jae ramiño vi mocui cuimbae ñugüɨnoita co pe. Tumpa güɨraacata penti cuimbae jare ĩru cuimbae upɨtata co pe —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Jayave Jesús jemimboe reta upɨrandu chupe: —OreYa, ¿quiape pa uyeyapota cua? Jayave Jesús jei chupe reta: —Umano vae jetecue oĩ vae pe uyembatɨta uruvɨ reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jare penti ara Jesús imiari ye jemimboe reta pe umɨjaanga reve. Uipota uicuaaca chupe reta quirãi icavi co jecuaeño uyerure vaerã Tumpa pe jare agüɨye vaerã icueri chugüi. ");
INSERT INTO gnwNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Jáeramo jei chupe reta: —Ico penti tenta guasu pe penti mburuvicha upuruãa vae. Uquɨye'ã Tumpa güi jare güɨrɨ̃ro ĩru vae reta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Jae ramiño vi ico jocua tenta guasu pe penti cuña ime umano vae. Penti ara cuña ime umano vae oo mburuvicha upuruãa vae pe jare jei chupe: ‘Cherepɨ cherovaicho güi’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Mburuvicha upuruãa vae uyapo'ã mbae uepɨ vaerã cuña. Ẽrei mbovɨ ara rupi jei iyupe ipɨa pe: ‘Yepe tẽi aquɨye'ã Tumpa güi jare arɨ̃ro ĩru vae reta, ");
INSERT INTO gnwNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ẽrei cua cuña ime umano vae chemambeco ramo, aepɨta co. Echa'ã aepɨ'ã yave, jecuaeño outa chepɨ jare ndarau umaeño aputuu’ —jei, jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Jayave yandeYa jei: —Jucuarãi co jei jocua mburuvicha upuruãa vae jupi mbae vae uyapo vae. ");
INSERT INTO gnwNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ẽrei Tumpa jupi co. Jáeramo uepɨta co uiparavo vae ara rupi jare pɨ̃tu rupi uyerure chupe vae reta, yepe tẽi aramoi ndarau uepɨ voi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Che jae peve, ɨmambae Tumpa uepɨta reta. Ẽrei che cuimbaerã ayeyapo vae ayu ye yave ɨvɨ pe, ¿imeta ra ñugüɨnoi upurugüɨrovia vae reta? —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jare Jesús oĩ vae pe ñugüɨnoi amocue uyembujupi ipɨayemɨngueta pe vae. Jae reta güɨrɨ̃ro ĩru vae reta. Jare Jesús jei chupe reta umɨjaanga reve: ");
INSERT INTO gnwNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Mocui cuimbae yugüɨraa Tumpa jo pe uyerure vaerã Tumpa pe. Penti co fariseo jare ĩru vae mburuvicha peguarã ocovara vae co —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Fariseo uyemboɨ jare uyerure iyupe ipɨa pe cuarãi: ‘Tumpa, amee yasurupai ndeve. Echa'ã che aico'ã ĩru cuimbae reta yugüɨreco rami. Che apurumbɨtavɨ'ã apɨ̃ro vaerã quía güi imbaembae. Ayapo'ã jupi mbae vae. Ayuvanga'ã menda re. Ayapo'ã vi jocua mburuvicha peguarã ocovara vae uyapo rami’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","‘Che ayecuacu tembíu güi mocui vese semana pe, jare amee ndeve diezmo opaete anoi vae güi’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Jare mburuvicha peguarã ocovara vae uyemboɨ oĩ mbɨrɨ catu fariseo güi, jare uipota'ã jovaɨva. Jaeño ocua iyee ipɨtía re jare jei: ‘Tumpa, cheparareco. Echa'ã che cheyoa vae co’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Che jae peve, Tumpa umbɨasa mburuvicha peguarã ocovara vae pe imbaeyoa reta, jare jae oo ye jenta pe. Ẽrei umbɨasa'ã fariseo pe imbaeyoa reta. Echa'ã ime yave quía uyembutuicha vae, uñemɨmichicata co. Jare ime yave quía uñemɨmichi vae, uyembutuichacata co —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Jare amocue vae güeru Jesús oĩ vae pe sambiaɨ reta, Jesús oñono vaerã ipo jese reta. Ẽrei Jesús jemimboe reta uecha reta yave, uñeengata güeru vae reta pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ẽrei Jesús ueni sambiaɨ reta jare jei: —Pemaeño sambiaɨ reta re yugüeru vaerã checotɨ. Agüɨye piyopia. Echa'ã cua nunga uyeyocui Tumpa pe iporoyocuia pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Añete che jae peve, pipota'ã yave Tumpa pe piyeyocui vaerã penti sambiaɨ uipota rami, ndarau pico Tumpa iporoyocuia pe —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Jare penti mburuvicha jei Jesús pe: —Oporomboe vae, nde ndepɨacavi co. ¿Mbae pa ayapota anoi vaerã tecove opa mbae vae? —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jayave Jesús jei chupe: —¿Maera pa ndere cheve chepɨacavi vae co? Mbaetɨ quía ipɨacavi, jaeño co Tumpa —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Nde ndicuaa co mboroyocui reta: ‘Agüɨye iyuvanga menda re. Agüɨye epuruyuca. Agüɨye nemonda. Agüɨye ndapu ĩru vae re. Ipɨu nderu jare ndesɨ’ —jei Jesús chupe. ");
INSERT INTO gnwNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","—Ayavɨ'ã penti ave cua mboroyocui reta chemichi güive —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jare Jesús cua uyandu yave, jei chupe: —Ime mbae uata ndiyapo vaerã. Emee opaete mbaembae nenoi vae corepoti re, jare emee ndecorepoti iparavete vae reta pe, jare ndicocatuta ara pe. Jayave eyu cherupíe —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ẽrei mburuvicha cua uyandu yave, tuicha ipɨatɨtɨ. Echa'ã icocatu ete co. ");
INSERT INTO gnwNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jare Jesús uecha yave mburuvicha ipɨatɨtɨ upɨta, jei: —Yavai ete co icocatu vae reta uique vaerã Tumpa iporoyocuia pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Yavai ete icocatu vae uique vaerã Tumpa iporoyocuia pe, maemɨmba camello jee vae yuu jesacua rupi uasa vaerã güi —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Jayave cua uyandu vae reta jei: —Jucuarãi yave, ¿quía pa ipuere uyembɨasaca? ");
INSERT INTO gnwNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jayave Jesús jei chupe reta: —Ɨvɨ pegua reta ipuere'ã uyembɨasa. Ẽrei Tumpa ipuere umbɨasa reta —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Jayave Pedro jei Jesús pe: —Mase, ore opaete mbaembae ndueya, ndoyu vaerã nderupíe. ");
INSERT INTO gnwNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","—Añete che jae peve —jei Jesús—, ime yave quía ueya jenta, ani tu, ani ichɨ, ani tɨqueɨ reta, ani tɨvɨ reta, ani jembireco, ani isambiaɨ reta Tumpa iporoyocuia jeco pegua vae, ");
INSERT INTO gnwNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","jeta ete jecoviata co chupe ɨvɨ pe ico rambueve, jare taɨcue rupi Tumpa umeeta chupe tecove opa mbae vae —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jayave Jesús ueni jocua doce jemimboe reta, jare jei chupe reta: —Mase, yaa co ñaĩ Jerusalén pe, jare opaete Tumpa iñee aracae umɨmbeu vae reta uicuatiacue cuimbaerã uyeyapo vae regua uyeyapota co cheve —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Echa'ã ĩru vae reta chemeeta judío mbae vae reta pe. Jare jae reta cheyoyaita, uyapota icavi mbae vae cheve, jare undɨvɨta cheré —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Jayave chenupata chicote pe jare cheyucata. Ẽrei mbapɨ ara rupi aicove yeta ayu umanocue vae reta ipɨte güi —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ẽrei Jesús jemimboe reta uicuaa'ã mbae ra uipota jei cua Jesús jei chupe reta vae. Yavai ete chupe reta uicuaa vaerã mbae jei vae. ");
INSERT INTO gnwNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jare Jesús coiño ma ou Jericó güi yave, penti cuimbae jesa mbae vae uguapɨ uyerure oĩ mbae re tape jembeɨ pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Jae uyandu jeta vae uasa ñugüɨnoi jocoropi, jare upɨrandu mbae ra uyeyapo oĩ. ");
INSERT INTO gnwNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Jayave uasa vae reta umɨmbeu chupe Jesús Nazaret pegua uasa oĩ. ");
INSERT INTO gnwNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Jayave jesa mbae vae iñeeãta reve jei: —Cheparareco, Jesús. Nde co jae David iñemoñaa reta pegua —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Jeta joco pe ñugüɨnoi vae reta uñeengata chupe. Uipota tẽi umɨquĩi. Ẽrei jesa mbae vae jeiete iñeeãta reve jei: —Nde co jae David iñemoñaa reta pegua. Cheparareco —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jayave Jesús uyemboɨ, jare jei joco pe ñugüɨnoi vae reta pe güeru vaerã jesa mbae vae. Jare jesa mbae vae ou yave Jesús oĩ vae pe, Jesús upɨrandu chupe: ");
INSERT INTO gnwNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Mbae pa ndipota ayapo vaerã ndeve? —Tamae, cheYa —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jayave Jesús jei chupe: —Emae. Ndecuera ma, nderovia cheré ramo —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Jare jupivoi ipuere umae, jare oo Jesús jaɨcue umbɨadora reve Tumpa. Jare opaete joco pe ñugüɨnoi vae reta vi cua uecha yave, umbɨadora Tumpa. ");
INSERT INTO gnwNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jare Jesús uique Jericó pe jare oo ye joco güi. ");
INSERT INTO gnwNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Jare ico joco pe penti cuimbae Zaqueo jee vae. Jae co mburuvicha peguarã ocovara vae reta itenondegua jare jae co icocatu vae. ");
INSERT INTO gnwNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Jare Zaqueo uipota tẽi uecha Jesús. Ẽrei ipuere'ã uecha. Echa'ã jeta vae ñugüɨnoi Jesús uasa vae rupi, jare Zaqueo ipucu'ã co. ");
INSERT INTO gnwNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Jáeramo Zaqueo osi oo penti ɨvɨra sicómoro jee vae tape jembeɨ pe oĩ vae pe, jare uyupi jese uecha vaerã Jesús. Echa'ã Jesús uasata oĩ jocoropi. ");
INSERT INTO gnwNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jare Jesús oo uvãe yave ɨvɨra oĩ vae pe, jovaɨva umae jare uecha Zaqueo. Jayave jei chupe: —Egüeyɨ, Zaqueo. Echa'ã añave aipota apou ndepɨ —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Jayave Zaqueo ugüeyɨ voi, jare güɨraa Jesús jenta pe uyerovia reve. ");
INSERT INTO gnwNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Jare opaete ĩru vae reta cua uecha yave, iñeenguru reve jei reta: —Jae oo opou penti cuimbae iyoa vae pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ẽrei Zaqueo uyemboɨ yandeYa jovai jare jei chupe: —Mase, cheYa, ameeta chembaembae mbɨte rupi iparavete vae reta pe. Jare ime yave quía güi apɨ̃ro mbae chugüi vae, irundɨ ye ambɨjecoviata chupe —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jayave Jesús jei chupe: —Cua ara yembɨasa ou cua tenta pegua reta pe. Echa'ã nde vi co jae Abraham iñemoñaa reta pegua —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Echa'ã che cuimbaerã ayeyapo vae ayu aeca vaerã jare ambɨasa vaerã ucañɨ Tumpa güi vae reta —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Jare Jesús ndive ñugüɨnoi vae reta cua uyandu ma yave, Jesús imiari ye chupe reta umɨjaanga reve. Echa'ã oo ma uvãe coiño Jerusalén güi, jare jae ndive ñugüɨnoi vae reta ipɨa pe uyemɨngueta tẽi ɨmambae ete co uyecuaata Tumpa iporoyocuia. ");
INSERT INTO gnwNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Jáeramo Jesús jei chupe reta: —Penti mburuvicha oota iɨvɨ güi ambɨe ɨvɨ mbɨrɨ oĩ vae pe uyeyapo vaerã iɨvɨ pegua reta juvicha guasurã. Jare taɨcue rupi ou yeta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Jare ndei oo mbove, ueni diez jembiocui reta jare umee penti penti pe corepoti jepɨ ete vae, jare jei chupe reta: ‘Piporu cua corepoti ayu ye regua’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ẽrei mburuvicha jentaɨgua reta umɨtarẽɨ mburuvicha, jare mburuvicha oo ma yave ambɨe ɨvɨ pe, jae reta omondo jei vaerã: ‘Nduipota'ã jocua cuimbae ico vaerã oreruvicha guasurã’ —jei reta, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ẽrei mburuvicha uyeyapo jentaɨgua reta juvicha guasurã. Jayave ou ye uvãe iɨvɨ pe jare ueni jembiocui corepoti umee chupe vae reta uyembatɨ vaerã, jae uicuaa vaerã mbovɨ ra penti penti umɨngana —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Penti jembiocui jei chupe: ‘Patrón, amɨmbaravɨquɨ corepoti nemee cheve vae, jare añave anoi diez corepoti’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Jayave ipatrón jei jocua jembiocui pe: ‘Icavi ndiyapo. Nde co jae cherembiocui icavi vae. Cua amee ndeve vae mbovɨño. Ẽrei nemɨmbaravɨquɨ cavi. Jáeramo che toroñono diez tenta guasu pegua reta juvicharã’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Jayave ĩru jembiocui jei chupe: ‘Patrón, amɨmbaravɨquɨ corepoti nemee cheve vae, jare añave anoi pandepo corepoti’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Jayave ipatrón jei jocua jembiocui pe: ‘Icavi ndiyapo. Che toroñono pandepo tenta guasu pegua reta juvicharã’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Jayave ĩru jembiocui jei chupe: ‘Mase, patrón, co oĩ corepoti nemee cheve vae. Ayapɨcua añuvatu ndeve’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","‘Echa'ã aquɨye ndegüi ndepɨapochɨ ramo. Nde nepɨ̃ro mbaembae ĩru vae reta güi jare ndeavɨro ĩru vae reta oñotɨ vae’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Jayave ipatrón jei jocua jembiocui pe: ‘Nde ndere vae rupi etei che nuãata co. Nde co jae cherembiocui icavi mbae vae. Ndicuaa chepɨapochɨ co jare quirãi apɨ̃ro mbaembae ĩru vae reta güi jare quirãi aavɨro ĩru vae reta oñotɨ vae’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","‘¿Maera pa nderaa'ã checorepoti banco pe? Echa'ã jucuarãi ndiyapo yave, ayu ye yave nemeeta tẽi co cheve corepoti amee ndeve vae jare mbovɨ ye banco pegua reta umɨĩruta tẽi jae ndive vae’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Jayave ipatrón jei ĩru jembiocui joco pe ñugüɨnoi vae reta pe: ‘Pepɨ̃ro chugüi jocua corepoti jare pemee jocua diez corepoti güɨnoi vae pe’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ẽrei jae reta jei ipatrón pe: ‘Patrón, jae güɨnoi ma diez corepoti.’ ");
INSERT INTO gnwNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","‘Añete co’ —jei ipatrón chupe reta, jei—. ‘Ẽrei che jae peve, güɨnoi vae pe uñemɨĩruta, jare mbaetɨ güɨnoi vae güi mbovɨ ete güɨnoi vae uyeequita’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","‘Ẽrei peru cua pe jocua cherovaicho reta. Jae reta uipota'ã che aico vaerã juvicha guasurã. Piyuca cherovaque’ —jei, jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jare Jesús cua jei ma chupe reta yave, uguata ye ĩru vae reta jenonde oo Jerusalén cotɨ. ");
INSERT INTO gnwNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Jare yugüɨraa uvãe coiño tenta guasu-raɨ reta Betfagé jare Betania güi. Joco pe oĩ ɨvɨtu guasu Olivos. Jayave Jesús oyocui mocui jemimboe reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","—Pecua pea tenta guasu-raɨ yanderovai oĩ vae pe —jei chupe reta—. Peo pevãe rupive, pevãeta penti mburica taɨrusu vae uñeñapɨ̃ti oĩ. Ndei ave etei quía opo jese. Piyora jare peru —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Jare ime yave quía jei peve vae: ‘¿Maera pa piyora?’ pere chupe cuarãi: ‘YandeYa uipota uiporu’ —pere, jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Jayave Jesús omondo vae reta yugüɨraa, jare uvãe mburica taɨrusu vae Jesús umɨmbeu chupe reta rami. ");
INSERT INTO gnwNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Jare oyora ñugüɨnoi yave, mburica iya reta upɨrandu chupe reta: —¿Maera pa piyora peĩ mburica? ");
INSERT INTO gnwNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","—YandeYa uipota uiporu —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Jayave güeru reta mburica taɨrusu vae Jesús oĩ vae pe. Jayave Jesús jemimboe reta oñono iyasoya mburica icupe re, jare Jesús opo jese. ");
INSERT INTO gnwNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Jare Jesús oo rambueve Jerusalén cotɨ, joco pe ñugüɨnoi vae reta uipɨso iyasoya tape rupi mburica jenonde. ");
INSERT INTO gnwNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Jare umbɨpɨ reta ugüeyɨ ɨvɨtu guasu Olivos güi. Coiño ma yugüeru Jerusalén güi. Jayave opaete Jesús jemimboe reta umbɨpɨ uyerovia. Umbɨadora reta Tumpa iñeeãta reve opaete mɨacañɨ uecha Jesús uyapo vae reta re. ");
INSERT INTO gnwNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Jare jei reta: —Tuyembɨadoraca yandeRuvicha Guasurã yandeYa jee re ou vae. Mbɨacatu toĩ ara pe. Ara pegua reta tumbɨadora Tumpa —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Jare amocue fariseo reta jeta vae ipɨte pe ñugüɨnoi vae jei Jesús pe: —Oporomboe vae, iñeengata nderemimboe reta pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ẽrei Jesús jei chupe reta: —Che jae peve, cua reta quĩi yave, jupivoiño ita reta uyemɨnguetata iñeeãta reve —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jare Jesús coiño ma Jerusalén güi ou uvãe yave, umae Jerusalén re jare umbɨpɨ uyao. ");
INSERT INTO gnwNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Jare jei: —Ndicuaa'ã quirãi ra ndepuere nenoi mbɨacatu. Cua ara reta pe ndicuaata tẽi co. Ẽrei añave ndarau ndicuaa —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Outa ma uvãe nderovaicho reta nequẽse vaerã jare ndarau umaeño ndepɨte pe yugüɨreco vae reta re oẽ vaerã ndegüi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Jare jae reta opata nembusururu jare uyucata opaete ndepɨte pe yugüɨreco vae reta. Ndarau ueya reta penti ita ĩru ita iárambo, ndicuaa'ã Tumpa umeeta tẽi mbɨacatu ndeve ramo —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jayave Jesús uique Tumpa jo pe, jare umbɨpɨ omoẽ joco güi umaemee vae reta jare mbae ogua vae reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Jare jei chupe reta: —Tumpa iñee pe uyecuatía oĩ cuarãi: ‘Chero co jae piyerure cheve pɨpe vae.’ Jucuarãi uyecuatía oĩ. Ẽrei pe reta piyapo ma imonda vae reta iñemia rami —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Jayave Jesús oporomboe Tumpa jo pe opa ara rupi. Ẽrei sacerdote reta itenondegua reta jare mboroyocui re oporomboe vae reta jare tenta guasu pegua reta itenondegua reta ueca quirãi ipuere uyucaca vaerã Jesús. ");
INSERT INTO gnwNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ẽrei uicuaa'ã reta quirãita ra uyucaca. Echa'ã opaete tenta guasu pegua reta uipota ete uyapɨsaca Jesús re. ");
INSERT INTO gnwNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Jare penti ara Jesús oporomboe oĩ Tumpa jo pe, jare umɨmbeu joco pe ñugüɨnoi vae reta pe ñee icavi vae. Jayave yugüeru vi joco pe sacerdote reta itenondegua reta jare mboroyocui re oporomboe vae reta jare tenta guasu pegua reta itenondegua reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Jayave jae reta jei Jesús pe: —Emɨmbeu oreve, ¿mbae nunga mbaepuere pa nenoi cua mbaembae ndiyapo vaerã? ¿Quía pa umee ndeve mbaepuere cua ndiyapo vaerã? —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jayave Jesús jei chupe reta: —Che vi tapɨrandu peve mbae re. Yaecha pepuere pemɨmbeu cheve —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Quía pa ombou Juan upurumbɨbautiza vaerã? ¿Tumpa pa ombou? ani ¿ɨvɨ pegua reta pa ombou? —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Jayave jae reta jei uyupe: —Yae yave: ‘Tumpa co ombou’, jae jeita yandeve: ‘Jucuarãi yave, ¿maera pa perovia'ã?’ ");
INSERT INTO gnwNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ẽrei yae yave: ‘Ɨvɨ pegua reta co ombou’, opaete tenta guasu pegua reta yandeapita ita pe yandeyuca. Echa'ã jae reta güɨrovia Juan co jae penti Tumpa iñee umɨmbeu vae —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Jáeramo jei reta Jesús pe: —Nduicuaa'ã quía ra ombou Juan. ");
INSERT INTO gnwNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Jayave Jesús jei chupe reta: —Che vi ndarau amɨmbeu peve mbae nunga mbaepuere anoi cua mbaembae ayapo vaerã —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jayave Jesús umbɨpɨ imiari joco pe ñugüɨnoi vae reta pe umɨjaanga reve. —Penti cuimbae oñotɨ jeta uva ico pe. Jayave uiporuca ico ĩru vae reta pe, jae reta uyandareco vaerã jese. Jayave co iya oo mbɨrɨ ambɨe ɨvɨ pe upɨta vaerã ɨma pegua —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Jare uva yagüɨye ma yave, co iya ombou penti jembiocui co iporúa reta pe, jae reta umbɨyao vaerã tẽi uva chupe reta, iya güɨnoi vaerã imbaerã. Ẽrei co iporúa reta uinupa co iya jembiocui, jare omondo ye. Umee'ã etei chupe güɨraa vaerã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Jayave co iya ombou ye tẽi ĩru jembiocui. Ẽrei co iporúa reta uinupa jare uyapo icavi mbae vae chupe, jare omondo ye. Umee'ã etei chupe güɨraa vaerã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Jayave co iya ombou ye tẽi ĩru jembiocui. Ẽrei co iporúa reta umbɨpere, jare omondo ye —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Jayave co iya jei iyupe: ‘¿Mbae ra ayapota? Amondota cheraɨ aau ete vae. Aramoi jae reta uipɨuta cheraɨ’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ẽrei co iporúa reta uecha yave co iya taɨ, jei reta uyupe: ‘Cua co jae iyarã vae. Yaa yayuca, jare yande yaicota co iyarã’ —jei reta, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Jayave jae reta omombo co güi, jare uyuca. Jáeramo ¿mbae ra uyapota co iya jocua co iporúa reta pe? —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Outa, opa uyuca vaerã jocua co iporúa reta, jare uiporucata ico ambɨe vae reta pe —jei. Jayave cua uyandu vae reta jei: —Tumpa mona jei agüɨye uyeyapo. ");
INSERT INTO gnwNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jayave Jesús umae jese reta jare jei: —¿Mbae ra uipota jei cua Tumpa iñee pe uyecuatía oĩ vae? ‘Ita tenta iyapoa reta omombo vae uyeyapo ma ita tenondegua vae.’ ");
INSERT INTO gnwNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ime yave quía jocua ita re uyepɨaca vae, uñemopẽta co. Jare ime yave quía jocua ita oa jese vae, opata umbɨperasoraso —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Jayave jupivoi sacerdote reta itenondegua reta jare mboroyocui re oporomboe vae reta uipota tẽi uipɨsɨ Jesús. Echa'ã uicuaa cua Jesús umɨjaanga reve jei vae uicuaaca quirãi jae reta teco güɨnoi. Ẽrei uquɨye tenta guasu pegua reta güi. ");
INSERT INTO gnwNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Jare jecuaeño jae reta umae Jesús re. Jare omondo vi ĩru vae reta uipiãro vaerã Jesús. Cua reta uipota tẽi umbɨtavɨ Jesús, Jesús ipɨa pe uyemɨngueta vaerã tẽi jae reta jupi co. Ẽrei jae reta uipota tẽi umbɨjeco mbae jei vae re, uñeapo vaerã jese mburuvicha pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Jayave jae reta jei Jesús pe: —Oporomboe vae, nduicuaa nde ndere vae jare ndeporomboe jese vae añete co. Nde nembutuicha'ã penti ave ĩru vae güi. Nde ndeporomboe cavi quirãi Tumpa uipota yaico vaerã vae re —jei reta—. ");
INSERT INTO gnwNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","César yandeocui yambɨepɨ vaerã chupe corepoti pe. ¿Jupi pa yambɨepɨ vaerã chupe? ani ¿jupi'ã pa? —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ẽrei Jesús uicuaa jae reta uipota tẽi co umbɨtavɨ, jare jei chupe reta: —¿Maera pa pipota piyavɨca cheve? ");
INSERT INTO gnwNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Peru cheve penti corepoti taecha —jei—. ¿Quía jova íã pa cua? ¿Quía jee pa cua uyecuatía oĩ vae? —jei. —Cua César imbae co —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Jayave Jesús jei chupe reta: —Pemee César pe César pegua, jare pemee Tumpa pe Tumpa pegua —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Jare jae reta ipuere'ã umbɨjeco Jesús mbae jei vae re tenta guasu pegua reta jovaque. Ipɨacañɨ cua jei vae re, jare jei'ã ye mbae ave chupe. ");
INSERT INTO gnwNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Jayave yugüeru Jesús oĩ vae pe amocue saduceo reta. Opaete saduceo reta jei umanocue vae reta icove ye'ã co. Saduceo yugüeru vae reta jei Jesús pe: ");
INSERT INTO gnwNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Oporomboe vae, Moisés uicuatía ueya yandeve cuarãi: ‘Penti tiqueɨ vae umano yave, jembirecocue mbaetɨ imembɨ chupe yave, cuimbae amɨri tɨvɨ tumenda jocua cuña ndive. Jayave cuña imembɨ yave, cuimbae tumbɨjee sambiaɨ tɨqueɨ amɨri jee pe.’ Jucuarãi uicuatía Moisés —jei reta—. ");
INSERT INTO gnwNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ico penti cuimbae seis tɨvɨ reta güɨnoi vae. Cua cuimbae umenda, jare umano umɨmembɨ mbae reve. ");
INSERT INTO gnwNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Cuimbae amɨri jaɨcue rupigua umenda jembirecocue ndive, ẽrei umano vi umɨmembɨ mbae reve. ");
INSERT INTO gnwNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Jayave jaɨcue rupigua ye umenda cuña ndive, jare umano vi umɨmembɨ mbae reve. Opaete siete reve umenda jocua cuña ndive, jare opaete siete reve umano umɨmembɨ mbae reve —jei reta—. ");
INSERT INTO gnwNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Taɨcue rupi cuña umano vi. ");
INSERT INTO gnwNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Jayave umanocue vae reta icove ye yave, ¿quía nunga vae jembirecorã pa icota jocua cuña? Echa'ã opaete siete reve umenda jae ndive —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jayave Jesús jei chupe reta: —Cua ɨvɨ pe yugüɨreco rambueveño cuimbae reta umenda cuña reta ndive jare cuña reta umenda cuimbae reta ndive. ");
INSERT INTO gnwNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ẽrei icavita co Tumpa pe umbɨjecove ye vaerã amocue vae güeru umanocue vae reta ipɨte güi. Jae reta yugüɨreco yeta co, ẽrei cuimbae reta ndarau umenda cuña reta ndive jare cuña reta ndarau umenda cuimbae reta ndive icove reta ye yave —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Jae ramiño vi ndarau umano ye. Echa'ã yugüɨrecota ángel reta yugüɨreco rami. Yugüɨrecota Tumpa taɨ retarã. Echa'ã Tumpa umbɨjecove yeta güeru umanocue vae reta ipɨte güi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Tamɨmbeu peve umanocue vae reta regua. Icove yeta co. Moisés uicuaaca cua uicuatía yave jocua yai jendɨ vae regua. Echa'ã Moisés umɨmbeu quirãi yandeYa Tumpa jei: ‘Che co jae Abraham, Isaac jare Jacob iTumpa.’ Cua umɨmbeu Moisés —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Echa'ã Tumpa mbaetɨ co umanocue vae reta iTumpa. Jae co tecove güɨnoi vae reta iTumpa. Yepe tẽi ñamano, yanderecove imeño oĩ —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Jayave amocue mboroyocui re oporomboe vae reta jei Jesús pe: —Oporomboe vae, icavi ndere. ");
INSERT INTO gnwNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Jare jocua güive uquɨye reta upɨrandu vaerã chupe mbae re. ");
INSERT INTO gnwNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jayave Jesús upɨrandu joco pe ñugüɨnoi vae reta pe: —¿Maera pa jei mboroyocui re oporomboe vae reta Cristo co jae David iñemonaa reta pegua? ");
INSERT INTO gnwNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Echa'ã David etei jei Salmo reta pe cuarãi: ‘YandeYa Tumpa jei cheYa pe: Eguapɨ cheyɨpɨ pe cheacata cotɨ, ");
INSERT INTO gnwNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","nderovaicho reta opa amɨamɨri regua’ —jei Tumpa. Jucuarãi jei David —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","¿Maera pa jei reta Cristo co jae David iñemoñaa reta pegua? Echa'ã David etei jei chupe: ‘CheYa’ —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Jayave Jesús jei jemimboe reta pe opaete joco pe ñugüɨnoi vae reta jovaque: ");
INSERT INTO gnwNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Piñemoa ngatu mboroyocui re oporomboe vae reta güi. Jae reta jecuaeño uipota uguata jemimonde pucu vae reve, jare uipota ĩru vae reta pe uyembɨsaludaca vaerã calle reta rupi. Jare yugüɨraa yave tupao pe jare parea pe, jecuaeño uipota uguapɨ tenda tenondegua vae reta pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Jae reta upɨ̃ro cuña ime umano vae reta güi opaete imbaembae, jare pucu uyerure Tumpa pe upurumbɨtavɨ vaerã. Jae reta uiporara eteta co —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jare Jesús Tumpa jo pe oĩ yave, uecha icocatu vae reta oñono icorepoti corepoti jɨru pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Jare uecha vi penti cuña ime umano vae iparavete vae oñono mocui riare corepoti jɨru pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Jayave Jesús jei: —Añete che jae peve, cua cuña ime umano vae iparavete vae uyapo jeta ete opaete ĩru oñono vae reta güi. ");
INSERT INTO gnwNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Echa'ã opaete ĩru reta güeru oñono mbovɨ jeta güɨnoi vae güi. Ẽrei cua cuña, yepe tẽi iparavete, oñono opaete güɨnoi vae. Jocua co jembíu jepɨrã tẽi vae —jei chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Jare amocue vae uyemɨngueta ñugüɨnoi Tumpa jo re. Jei reta icavi ete co ita reta jare mbaembae tenta guasu pegua reta güeru omopõra vaerã vae. Jayave Jesús jei: ");
INSERT INTO gnwNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Outa co uvãe ara cua o reta añave peecha vae uyeitɨ vaerã. Ndarau upɨta penti ave ita ĩru ita iárambo —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Jayave Jesús jemimboe reta upɨrandu chupe: —Oporomboe vae, ¿quirãi yave pa cua uyeyapota? Jare opaete cua uyeyapota ma yave, ¿quirãita pa nduicuaa? —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jayave Jesús jei chupe reta: —Piñemoa ngatu agüɨye vaerã petavɨ. Echa'ã yugüeruta jeta cheree pe uyembɨjeeta vae reta. Jae reta jeita: ‘Che co jae Cristo. Outa co uvãe jocua ara reta’ —jeita, jei—. Ẽrei agüɨye piñemɨĩru jae reta ndive —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Imeta co ñerãro reta jare tecorai reta. Ẽrei piyandu yave cua reta regua, agüɨye pequɨye. Cua susere reta uyeyapoñotai co. Ẽrei cua susere reta ndei ave co opa vaerã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Penti ɨvɨ pegua reta uñerãrota ambɨe ɨvɨ pegua reta ndive, jare mburuvicha reta uñerãrota ĩru mburuvicha reta ndive. ");
INSERT INTO gnwNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Jare ɨvɨ tanta ucãtata jeta que rupi. Jare imeta caruai reta jare mbaerasɨ reta jeta vae uyucata vae. Jare mbaembae ara re uyecuaata vae upurumɨnguɨyeta co —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ẽrei ndei cua uyeyapo mbove, ĩru vae reta pepɨsɨta jare uyapota icavi mbae vae peve. Jae reta pereraata itupao reta pe jare peñonota peresorɨru pe, jare pereraata mburuvicha guasu reta jovai chereco pegua —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ẽrei jucuarãi uyapo reta peve yave, pepuereta pemɨmbeu cheregua —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Agüɨye piyemɨpɨa'ã cua re jare agüɨye pepɨa pe piyemɨngueta mbae ra pereta vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Echa'ã che aicuaacata peve mbae pere vaerã, jare che pumbɨaracuaata agüɨye vaerã perovaicho reta uicuaa mbae ra ipuere jei peve —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Jare peru jare pesɨ, jare perɨqueɨ reta jare perɨvɨ reta, jare perentarã reta jare peamigo reta pemeeta perovaicho reta pe, jare amocue pe reta piyeyucacata co —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Jare piñemɨtarẽɨcata opaete vae pe chereco pegua. ");
INSERT INTO gnwNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ẽrei ndarau penti ave pea ucañɨ —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Jare perõsa peo pevãe iyapɨ pe yave, piyembɨasacata co —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Jare peecha jeta sundaro reta Jerusalén oñova yave, picuaata ou ma co uvãe Jerusalén uyembai vaerã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Jayave Judea pe ñugüɨnoi vae reta tosi ɨvɨtu guasu cotɨ. Jare Jerusalén pe ñugüɨnoi vae reta toẽ tosi joco güi. Jare jocua coiño Jerusalén güi ñugüɨnoi vae reta agüɨye tuyugüɨraa Jerusalén pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Echa'ã jocua ara reta pe ɨvɨ pegua reta uiporara eteta, jare opaete Tumpa iñee pe uyecuatía oĩ vae uyeyapota co —jei chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Jare ipurúa vae reta jare umɨcambu vae reta uiporara eteta jocua ara reta pe. Echa'ã cua ɨvɨ pegua reta uiporara eteta. Echa'ã Tumpa uiporaracata co chupe reta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Jare jeta cua ɨvɨ pegua reta uyeyucacata quɨsepucu pe. Jare jovaicho reta güɨraata jeta cua ɨvɨ pegua reta ambɨe ɨvɨ reta pe. Jare judío mbae vae reta yugüɨrecota Jerusalén pe judío mbae vae reta iara reta opa regua —jei Jesús chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Jayave ɨvɨ pegua reta uechata mbae uyecuaa oĩ guarasɨ jare yasɨ jare yasɨtata reta re. Jare opaete ɨvɨ pegua reta uiporarata jare ndarau uicuaa mbae uyapo vaerã. Jare ɨ guasu reta jɨapu eteta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Jare ɨvɨ pegua reta uquɨye eteta. Uquɨye eteta mbae ɨvɨ pe uyeyapo oĩ vae güi. Jare ara re mbaepuere güɨnoi vae reta ucãtata —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Jayave ɨvɨ pegua reta cherechata ayu amapɨ̃tu reve. Che cuimbaerã ayeyapo vae anoita mbaepuere tuicha vae, jare ayembɨadoracata opaete vae pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Jare opaete cua mbaembae umbɨpɨ uyeyapo yave, piñemɨatangãtu. Echa'ã ɨmambae Tumpa perepɨta —jei chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Jayave Jesús jei chupe reta umɨjaanga reve: —Tamɨjaanga ɨva jare opaete ɨvɨra reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Uyembɨpɨ joquɨ yave, picuaa uyaro ma co ama oquɨ vaerã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Jae ramiño vi pe reta peecha yave cua mbaembae uyeyapo ñugüɨnoi vae, picuaata coiño ma co ou Tumpa iporoyocuia —jei Jesús chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Añete che jae peve, cua ɨvɨ pe añave yugüɨreco vae reta ndarau opa umano ndei opaete cua mbaembae uyeyapo mbove —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ara jare ɨvɨ opata, ẽrei chiñee ndarau opa —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Piñemoa ngatu, agüɨye vaerã pecau jare pesavɨpo, jare agüɨye vaerã piyemɨpɨa'ã mbaembae ɨvɨ pegua re. Echa'ã jucuarãi piyapo yave, outa uvãe jocua ara peãro mbae peĩ reve —jei chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Echa'ã jocua ara uipocouta opaete ɨvɨ pegua reta ñuai oporomboa rami —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Jáeramo piñemoa ngatu, jare jecuaeño piyerure Tumpa pe icavi vaerã chupe perepɨ vaerã opaete cua uyeyapota vae güi jare piyemboɨ vaerã cherovai. Che co jae cuimbaerã uyeyapo vae —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jare opa ara rupi Jesús oporomboe oĩ Tumpa jo pe. Ẽrei caaru ma yave oo joco güi upɨta ɨvɨtu guasu Olivos re. ");
INSERT INTO gnwNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Jare opaete tenta guasu pegua reta yugüeru neimbove asɨ Tumpa jo pe uyapɨsaca vaerã Jesús re. ");
INSERT INTO gnwNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Jare pascua uyaro ma oĩ. Jocua ara pe judío reta jou mbɨyape ovu mbae vae. ");
INSERT INTO gnwNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Jayave sacerdote reta itenondegua reta jare mboroyocui re oporomboe vae reta ueca ñugüɨnoi quirãi ipuere uyucaca Jesús. Ẽrei uquɨye tenta guasu pegua reta güi. ");
INSERT INTO gnwNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Jayave Satanás etei oya Judas Iscariote re - Judas co jae jocua doce vae güi penti. ");
INSERT INTO gnwNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Jayave Judas oo sacerdote reta itenondegua reta jare Tumpa jo re uyandareco vae reta ñugüɨnoi vae pe uyemɨngueta vaerã jae reta ndive quirãi ra ipuere umee Jesús chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Jayave jae reta uyerovia, jare jei Judas pe umeeta co chupe corepoti. ");
INSERT INTO gnwNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Jayave Judas jei chupe reta umeeta co Jesús chupe reta. Jayave umbɨpɨ ueca quirãi ipuere umee Jesús chupe reta tenta guasu pegua reta mbaetɨ Jesús ndive ñugüɨnoi yave. ");
INSERT INTO gnwNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Jare ou uvãe pascua. Jocua ara judío reta jecuaeño uyuca ovecha jare umbɨpɨ jou mbɨyape ovu mbae vae. ");
INSERT INTO gnwNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jayave Jesús jei Pedro jare Juan pe: —Pecua piyapɨcatu yau vaerã tembíu pascua pegua. ");
INSERT INTO gnwNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Jayave jei reta chupe: —¿Quiape pa ndipota nduyapɨcatu vaerã? ");
INSERT INTO gnwNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","—Mase, peo pevãe yave tenta guasu pe, peovãitita penti cuimbae ɨ güɨraa ɨru pe vae —jei—. Pecua jaɨcue. Jae uiqueta penti tenta pe. Pique vi pe reta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Jayave pere tenta iya pe: ‘Oporomboe vae jei: ¿Quiape pa ime oĩ o, joco pe jau vaerã tembíu pascua pegua cheremimboe reta ndive’ —jei, pere chupe, jei Jesús—. ");
INSERT INTO gnwNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Jayave tenta iya uechacata peve penti o tuicha vae jo ɨvate pe, opaete mbaembae yaiporuta vae reve. Joco pe piyapɨcatu yandeve —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Jayave Pedro jare Juan yugüɨraa jare uvãe Jesús jei chupe reta rami. Jare uyapo reta tembiu pascua pegua Jesús jare jemimboe reta jou vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Jare ora ou ma uvãe yave, Jesús uguapɨ mesa pe jocua doce jemimondo reta ndive. ");
INSERT INTO gnwNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Jayave jei chupe reta: —Chequɨrẽɨ ete jau cua tembíu pascua pegua pe reta ndive, ndei amano mbove. ");
INSERT INTO gnwNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Che jae peve, ndarau ye jau, opaete cua uyemɨjaanga jese vae Tumpa iporoyocuia pe uyeyapo regua —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Jayave Jesús uipɨsɨ copa, jare umee yasurupai Tumpa pe. Jayave jei: —Opaete pe reta peu cua vino. ");
INSERT INTO gnwNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Che jae peve, ndarau ye jau vino, Tumpa iporoyocuia ou regua —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Jayave Jesús uipɨsɨ mbɨyape, jare umee yasurupai Tumpa pe. Jayave upɨsãa mbɨyape jare umee chupe reta. —Cua co jae cherete —jei—. Añemeeta amano vaerã peré. Peu cua cheré pemandúa vaerã —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Jae ramiño vi uipɨsɨ copa, opa ma ucaru reta yave, jare jei: —Cua vino co jae Tumpa jei pɨau ye vae cherugüɨ pe ayapota vae. Cherugüɨ uyepɨyereta peré —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ẽrei yandepɨte pe uguapɨ oĩ cherovaicho reta pe chemeeta vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Añete co, che cuimbaerã ayeyapo vae amanota. Cua Tumpa jei vae co. Ẽrei jocua cuimbae chemeeta vae uiporarata co —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Jayave jemimboe reta umbɨpɨ upɨrandu uyupe quía ra uyapota chupe jucuarãi. ");
INSERT INTO gnwNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Jare Jesús jemimboe reta umbɨpɨ uyemɨngueta uyupe quía ra icota tenondeguarã vae. ");
INSERT INTO gnwNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jayave Jesús jei chupe reta: —Ɨvɨ pegua reta juvicha guasu reta oyocui reta. Jare jae reta uipota ĩru vae reta jei icavi vae jesegua —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ẽrei pepɨte pe icavi'ã jucuarãi piyapo vaerã. Ime yave quía pepɨte pe uipota ico vaerã tenondeguarã vae, tuyeyapo penti taɨrusu vae ĩru vae reta pe uyeyocui vae rami —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Mesa pe uguapɨ ucaru vaerã vae co tenondegua tembíu güeru vae güi. Ẽrei che aico pepɨte pe ayeyocui peve vaerã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Pe reta jecuaeño pepɨta che ndive opaete cua aiporara rambueve —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Jare che puparavo ma pico vaerã Tumpa iporoyocuia pe, cheRu cheparavo rami —jei chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Jáeramo pecaruta chemesa pe cheporoyocuia pe. Jae ramiño vi penoita mbaepuere peãa vaerã jocua doce atɨ Israel pegua reta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Simón, Simón, mase, Satanás uipota tẽi güɨnoi mbaepuere peré, trigo yambɨveve vae rami —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ẽrei che ayerure Tumpa pe nderé jecuaeño nenoi vaerã mburugüɨrovia. Jare ndiyerova ye yave Tumpa cotɨ, emborɨ nderɨvɨ reta ipɨrãta vaerã ipurugüɨrovia re —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Jayave Pedro jei Jesús pe: —CheYa, apɨtata co nde ndive, peresorɨru pe neñono reta yave. Ndarau ndueya, yepe tẽi aramoi ĩru vae reta cheyuca —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","—Che jae ndeve, Pedro —jei Jesús—, ndei uru cuimbae uñee mbove, mbapɨ vese ma checuacuta —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jayave Jesús jei jemimboe reta pe: —Che pomondo yave chiñee peraa vaerã, amɨmbeu peve agüɨye vaerã peraa corepoti, jare peurupucu, jare pepɨpasa. ¿Uata pa mbae peve? —jei. —Uata'ã —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Jayave jei chupe reta: —Ẽrei añave tamɨmbeu peve cua: Corepoti penoi yave, peraa. Jae ramiño vi peurupucu penoi yave, peraa. Jare mbaetɨ yave penoi quɨsepucu, pemee peremimonde pegua vaerã quɨsepucu —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Echa'ã che jae peve, uyeyapota co cheve Tumpa iñee pe uyecuatía oĩ vae. Echa'ã uyecuatía oĩ cuarãi: ‘Ĩru vae reta jei tẽi jae vi co penti icavi mbae vae.’ Jucuarãi uyecuatía oĩ. Jare opaete cheré uyecuatía oĩ vae uyeyapota co cheve —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Jayave jae reta jei chupe: —Mase, oreYa, ime nonoi mocui quɨsepucu. —Icaviño ma co —jei chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jayave Jesús oẽ o güi oo vaerã ɨvɨtu guasu Olivos pe jae jecoño mai rami. Jare jemimboe reta vi yugüɨraa jae ndive. ");
INSERT INTO gnwNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Jare oo uvãe yave upɨta vae pe, Jesús jei jemimboe reta pe: —Piyerure Tumpa pe agüɨye vaerã peyoa. ");
INSERT INTO gnwNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Jayave Jesús usɨrɨ catu chugüi reta, jare uyeatɨca uyerure Tumpa pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","—CheRu —jei—, nde ndipota yave, embɨasa chegüi cua aiporarata vae. Ẽrei tuyeyapo cheve nde ndere vae. Agüɨye tuyeyapo che jae vae —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Jayave uyecuaa Jesús pe penti ángel ara güi ou vae umɨmɨrãta vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Jesús uiporara ete oĩ, jare jeiete uyerure Tumpa pe. Jeta ipireipo oĩ. Tugüɨ rami utɨquɨ ɨvɨ pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Jare Tumpa pe uyerure ma yave, upũa ye jare ou ye jemimboe reta ñugüɨnoi vae pe. Uecha oque ñugüɨnoi ipɨatɨtɨ güi. ");
INSERT INTO gnwNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Jayave Jesús jei chupe reta: —¿Maera pa peque peĩ? Pepũa piyerure Tumpa pe, agüɨye vaerã peyoa —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jare uyemɨngueta oĩ rambueve, uyecuaa jeta vae. Jare Judas - jae co jocua doce vae güi penti - ou jocua jeta vae jenonde. Jayave ou uvãe Jesús oĩ vae pe, jare uyurupɨte. ");
INSERT INTO gnwNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Jayave Jesús jei chupe: —Judas, ¿penti yurupɨte rupi pa chemee cua reta pe? ");
INSERT INTO gnwNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Jare Jesús jemimboe reta uyemboɨ ñugüɨnoi Jesús iyɨpɨ pe. Jare uicuaa mbae uyeyapota vae ramo, jei Jesús pe: —OreYa, ¿nduiporuta pa quɨsepucu jese reta? ");
INSERT INTO gnwNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Jayave penti Jesús jemimboe uiporu iquɨsepucu sacerdote tenondegua jembiocui inambi re, jare uyasɨa inambi chugüi. ");
INSERT INTO gnwNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Jayave Jesús jei: —Pemaeño cheré ayapo vaerã cua. Jayave uyavɨquɨ cuimbae inambi jendacue, jare cuimbae ucuera. ");
INSERT INTO gnwNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Yugüeru vi joco pe sacerdote reta itenondegua reta jare Tumpa jo re uyandareco vae reta jare tenta guasu pegua reta itenondegua reta. Jare Jesús jei chupe reta: —¿Maera pa peru quɨsepucu reta jare ɨvɨra reta chepɨsɨ vaerã, imonda vae pipɨsɨ vae rami? ");
INSERT INTO gnwNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Opa ara aico pe reta ndive Tumpa jo pe, ẽrei chepɨsɨ'ã. Ẽrei ora uvãe ma chepɨsɨ vaerã. Cuarãi piyapo peĩ Satanás imbaepuere pe —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Jayave uipɨsɨ reta Jesús jare güɨraa sacerdote tenondegua jenta pe. Jare Pedro oo jae reta jaɨcue, ẽrei mbɨrɨño oo chugüi. ");
INSERT INTO gnwNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Jayave joco pe ñugüɨnoi vae reta uyapo tata sacerdote tenondegua joca pe jare uguapɨ joco pe. Jare Pedro vi uguapɨ joco pe jae reta ipɨte pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ẽrei penti cuñatai uecha Pedro uguapɨ oĩ tataɨpɨ pe. Umae ngatu jese. Jayave jei: —Cua cuimbae vi icose jocua ĩru cuimbae ndive. ");
INSERT INTO gnwNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Jayave Pedro uicuacu Jesús. —Aicuaa'ã jocua cuimbae —jei Pedro cuñatai pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ndei ɨma mbove penti cuimbae vi uecha Pedro jare jei chupe: —Nde co jae iĩru vi. —Che'ã co —jei Pedro cuimbae pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Jare penti ora rupi ma uasa yave, ĩru cuimbae jeiete jei: —Añete co, cua cuimbae icose jocua ĩru cuimbae ndive. Echa'ã Galilea pegua co —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","—Aicuaa'ã mbae ndere vae —jei Pedro cuimbae pe. Jare uyemɨngueta rupive, uru cuimbae uñee. ");
INSERT INTO gnwNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Jayave yandeYa uyerova jare umae Pedro re. Jayave Pedro imandúa yandeYa jei chupe vae re: ‘Ndei uru cuimbae uñee mbove, mbapɨ vese ma checuacuta.’ ");
INSERT INTO gnwNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Jayave Pedro oẽ joco güi, jare tanta ipɨatɨtɨ reve uyao. ");
INSERT INTO gnwNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Jare cuimbae uyandareco ñugüɨnoi Jesús re vae reta oyoyai jare uinupa. ");
INSERT INTO gnwNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Jayave jae reta uesañoma Jesús jare ocua jova re. Jayave jei reta chupe: —Emɨmbeu oreve quía ra ocua nderé. ");
INSERT INTO gnwNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Jare jeta icavi mbae vae jei reta chupe. ");
INSERT INTO gnwNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Jare cõe ma yave, tenta guasu pegua reta itenondegua reta jare sacerdote reta itenondegua reta jare mboroyocui re oporomboe vae reta uyembatɨ. Jayave güeruruca reta Jesús. Jayave jei reta chupe: ");
INSERT INTO gnwNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—¿Nde pa co jae Cristo, Tumpa ombou vae? Emɨmbeu oreve. —Che amɨmbeu yave peve, ndarau chererovia —jei Jesús—. ");
INSERT INTO gnwNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Jare che apɨrandu yave peve mbae re, ndarau pemɨmbeu cheve, jare ndarau cheyora —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ẽrei che cuimbaerã ayeyapo vae aguapɨta curi Tumpa mbaepuere güɨnoi vae iyɨpɨ pe iyacata cotɨ —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Jayave opaete jae reta upɨrandu chupe: —¿Nde pa co jae Tumpa Taɨ? —Pe reta pere rami jae co che —jei Jesús chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Jayave jae reta jei: —¿Maera pa yaeca ye ĩru vae reta uñeapo vaerã jese? Echa'ã yande etei yayandu mbae jei vae —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Jayave opaete jae reta upũa jare güɨraa Jesús Pilato pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Jare umbɨpɨ reta uñeapo Jesús re. Jei reta: —Cua cuimbae umɨmbeu tenta guasu pegua reta pe uyapo vaerã icavi mbae vae. Echa'ã jei chupe reta agüɨye vaerã umbɨepɨ corepoti César peguarã. Jare jei jae co mburuvicha guasu Cristo jee vae —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Jayave Pilato upɨrandu Jesús pe: —¿Nde pa co jae judío reta juvicha guasu? —Nde ndere rami jae co che —jei Jesús chupe. ");
INSERT INTO gnwNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Jayave Pilato jei sacerdote reta itenondegua reta jare tenta guasu pegua reta pe: —Avãe'ã teco cua cuimbae re. ");
INSERT INTO gnwNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Jayave jae reta jeiete jei: —Omboepochɨ tenta guasu pegua reta. Oporomboe opaete Judea rupi. Umbɨpɨ Galilea pe jare añave ou uvãe cua pe oporomboe oĩ —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilato uyandu yave jei reta vae, upɨrandu penti Galilea pegua ra jocua cuimbae. ");
INSERT INTO gnwNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Jayave umɨmbeu reta Pilato pe Galilea pegua co Jesús. Jayave Pilato güɨraaca Jesús Herodes pe. Echa'ã Herodes co jae Galilea pegua reta juvicha guasu. Jare jocua ara reta pe Herodes opou oĩ Jerusalén pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Jare Herodes uecha Jesús yave, uyerovia ete, ɨma ma uipota uecha ramo. Echa'ã uyandu ma jeta Jesús regua, jare uipota uecha Jesús uyapo penti mɨacañɨ. ");
INSERT INTO gnwNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Jayave Herodes upɨrandu Jesús pe jeta mbaembae re, ẽrei Jesús jei'ã mbae ave chupe. ");
INSERT INTO gnwNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Jare sacerdote reta itenondegua reta jare mboroyocui re oporomboe vae reta uyemboɨ Herodes jovai jare iñeeãta reve uñeapo Jesús re. ");
INSERT INTO gnwNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Jare Herodes jare isundaro reta güɨrɨ̃ro jare oyoyai Jesús. Jayave omondeca chupe temimonde ipõra vae. Jayave Herodes güɨraaca ye Pilato pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Jare jocua ara etei Pilato jare Herodes uyeyapɨcatu ye. Echa'ã tenonde yave uñemɨtarẽɨ. ");
INSERT INTO gnwNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Jayave Pilato umbatɨca sacerdote reta itenondegua reta jare tenta guasu pegua reta itenondegua reta ndive. ");
INSERT INTO gnwNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Jare jei chupe reta: —Pe reta peru cua cuimbae cheve jare pere cheve omboepochɨ co tenta guasu pegua reta. Mase, che apɨrandu chupe jocua re perovaque, jare avãe'ã etei teco jocua pe reta piñeapo cheve jese vae re —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Jae ramiño vi Herodes uvãe'ã teco cua cuimbae re. Echa'ã che pomondo Herodes pe. Mase, mbaetɨ mbae teco uyapo umano vaerã —jei Pilato chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Jáeramo ainupacañota jare ayoraca yeta —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Echa'ã opa año tenta guasu pegua reta uyerure chupe oyoraca vaerã penti pereso pascua ara rupi, jare Pilato oyoracañoi penti pereso. ");
INSERT INTO gnwNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Jayave opaete vae iñeeãta reve jei: —Iyucaca cua cuimbae. Iyoraca oreve Barrabás —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Tenonde yave Barrabás upuruyuca Jerusalén pe, mburuvicha reta ndive uñerãro yave. Jáeramo umɨingue peresorɨru pe.) ");
INSERT INTO gnwNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ẽrei Pilato uipota tẽi oyoraca Jesús. Jáeramo jei ye chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ẽrei iñeeãta reve jei reta: —Icutuca curusu re. Icutuca curusu re. ");
INSERT INTO gnwNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Jayave Pilato upɨrandu ye chupe reta: —¿Mbae pa uyapo? Avãe'ã mbae icavi mbae vae jese umano vaerã. Jáeramo ainupacañota jare ayoraca yeta —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ẽrei jeiete iñeeãta reve jei reta uicutuca vaerã Jesús curusu re. Jare sacerdote reta itenondegua reta jare ĩru joco pe ñugüɨnoi vae reta iñee umɨquɨrẽɨ Pilato. ");
INSERT INTO gnwNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Jayave Pilato jei uyeyapo vaerã Jesús pe jae reta uipota vae. ");
INSERT INTO gnwNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Jayave oyoraca chupe reta tenonde yave mburuvicha reta ndive uñerãro yave upuruyuca ramo peresorɨru pe umɨingue vae, jae reta uipota rami. Ẽrei umee Jesús chupe reta uyeyapo vaerã chupe jae reta uipota vae. ");
INSERT INTO gnwNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Jayave güɨraa reta Jesús joco güi. Jare penti cuimbae Simón jee vae tenta guasu Cirene pegua, ou uvãe tenta guasu cotɨ. Jocoropi uasa oĩ yave, sundaro reta uipɨsɨ Simón jare güɨraaca chupe Jesús icurusu. Jayave Simón güɨraa curusu Jesús jaɨcue. ");
INSERT INTO gnwNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Jare yugüɨraa vi Jesús jaɨcue jeta vae. Jare jae reta ipɨte pe yugüɨraa cuña reta. Jae reta uapĩro yugüɨraa Jesús. ");
INSERT INTO gnwNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ẽrei Jesús uyerova umae jese reta jare jei chupe reta: —Jerusalén pegua cuña reta, agüɨye piyao cheré. Piyao piyee jare pemembɨ reta re —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Mase, outa uvãe ara reta jei reta vaerã: ‘Uyerovia co imembɨ mbae vae. Uyerovia co umɨcambu mbae etei vae’ —jeita, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Jayave umbɨpɨta tẽi jei ɨvɨtu guasu pe: ‘Piyapara oreárambo. Oreasoi’ —jeita, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Uyapo reta icavi mbae vae cheve yave, ¿mbae ra uyapota peve? —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Jare sundaro reta güɨraa vi Jesús ndive mocui cuimbae icavi mbae vae uyapo vae uyuca vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Jare yugüɨraa uvãe Ãcacüerenda jee vae pe. Jayave joco pe sundaro reta uicutu curusu re Jesús jare cuimbae reta icavi mbae vae uyapo vae. Oñono reta penti Jesús iyacata cotɨ jare ĩru iyaso cotɨ. ");
INSERT INTO gnwNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jayave Jesús jei: —CheRu, embɨasa chupe reta. Uicuaa'ã mbae uyapo ñugüɨnoi vae —jei. Jayave sundaro reta uyuguari Jesús jemimonde re, uicuaa vaerã mbae nunga penti penti güɨraa iyupe vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Jare tenta guasu pegua reta uyemboɨ ñugüɨnoi jocoropi umae Jesús re. Jare tenta guasu pegua reta itenondegua joco pe ñugüɨnoi vae reta oyoyai Jesús. Jei reta: —Jae uepɨ ĩru vae reta. Añave tuyerepɨ, jae co Cristo yave, jae co Tumpa uiparavo vae yave —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Jare sundaro reta vi oyoyai Jesús. Oya reta jese jare umee vinagre chupe. ");
INSERT INTO gnwNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Jare jei reta: —Nde co jae judío reta juvicha guasu yave, iyerepɨ. ");
INSERT INTO gnwNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Jare oñono reta curusu re Jesús iñãca iárambo uyecuatía jesegua vae: “Cua co jae judío reta juvicha guasu.” Uyecuatía oĩ griego iñee pe jare latín pe jare hebreo iñee pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Jare penti cuimbae icavi mbae vae uyapo vae uyecutuca vae uñeengata Jesús pe. —Nde co jae Cristo, Tumpa ombou vae yave, iyerepɨ jare orerepɨ vi —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ẽrei ĩru cuimbae uñeengata chupe. —¿Ndequɨye'ã pa Tumpa güi? Echa'ã nde vi nemano neĩ cua ĩru vae rami —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Jare jupi co yande ñamano vaerã. Echa'ã yande ñamanota ñaĩ icavi mbae vae yayapo vae jeco pegua. Ẽrei cua cuimbae uyapo'ã mbae icavi mbae vae —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Jayave jei Jesús pe: —Jesús, nemandúa cheré ndeporoyocuia pe neĩ yave. ");
INSERT INTO gnwNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jayave Jesús jei chupe: —Añete che jae ndeve, cua ara neĩta che ndive ara pe —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Jare guarasɨ ara mbɨte güive mbapɨ ora rupi uñemɨpɨ̃tumimbi opaete ɨvɨ pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Guarasɨ jembipe'ã etei. Jayave Tumpa jo umbɨyao vae osoro mbɨte rupi. ");
INSERT INTO gnwNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Jayave Jesús tanta usapɨcai. Jayave jei: —CheRu, amee ndeve cherecove. Jare cua jei ma yave, umano. ");
INSERT INTO gnwNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Jare cien sundaro vae juvicha joco pe oĩ vae uecha mbae uyeyapo vae. Jayave umbɨadora Tumpa jare jei: —Añetete co, cua cuimbae co jae jupi vae. ");
INSERT INTO gnwNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Jare opaete joco pe yatɨ vae reta vi uecha mbae uyeyapo vae jare ocua iyee ipɨtía re. Jayave opaete vae yugüɨraa ye jenta jenta pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Jare opaete Jesús uicuaa vae reta jare cuña Jesús ndive Galilea güi yugüeru vae reta uyemboɨ ñugüɨnoi mbɨrɨ curusu güi. Umae ñugüɨnoi mbae uyeyapo vae re. ");
INSERT INTO gnwNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Jare joco pe oĩ vi penti cuimbae José jee vae. Jae co penti mburuvicha. Ipɨacavi jare jupi. ");
INSERT INTO gnwNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","(Jae uipota'ã tẽi ĩru mburuvicha reta uyapo vaerã icavi mbae vae Jesús pe.) Jae co tenta guasu Arimatea pegua. (Arimatea Judea pegua co.) José vi uãro ico Tumpa iporoyocuia. ");
INSERT INTO gnwNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Cua cuimbae oo Pilato pe, jare uyerure chupe Jesús jetecue re. ");
INSERT INTO gnwNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Jayave umbɨgüeyɨ Jesús jetecue, jare oñoma nieso pe. Jayave oñono penti teõgüerɨru itape uyeyoo vae pe, ndei quía uñeñono pɨpe vae pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Jocua ara opaete judío reta uyeyapɨcatu ñugüɨnoi pɨareve peguarã. Echa'ã pɨareve pe co mbutuu ara. ");
INSERT INTO gnwNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Jare cuña Jesús ndive Galilea güi yugüeru vae reta, yugüɨraa José jaɨcue jare uecha teõgüerɨru jare quirãi José oñono pɨpe Jesús jetecue vae. ");
INSERT INTO gnwNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Jayave yugüɨraa ye jenta jenta pe jare uyapɨcatu mbaembae ipiche cavi vae. Jayave uputuu reta mbutuu ara pe. Echa'ã jucuarãi uyecuatía oĩ mboroyocui pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Jare neimbove asɨ domingo ara pe cuña reta yugüɨraa ye teõgüerɨru cotɨ. Güɨraa reta mbaembae ipiche cavi vae uyapɨcatu ma vae. ");
INSERT INTO gnwNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Jare uecha ita tuicha vae uyembɨsɨrɨ ma teõgüerɨru jonque güi. ");
INSERT INTO gnwNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Jayave uique reta teõgüerɨru pe, ẽrei uvãe'ã yandeYa Jesús jetecue joco pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ipɨacañɨ ete reta cua re, ẽrei aramoiño uyecuaa uyemboɨ ñugüɨnoi iyɨpɨ pe mocui cuimbae. Jocua mocui cuimbae jemimonde uvera oĩ. ");
INSERT INTO gnwNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Jáeramo cuña reta uquɨye jare ipe cuimbae reta jovai. Jayave cuimbae reta jei chupe reta: —¿Maera pa peeca peĩ icove ye vae umanocue vae reta ipɨte pe? ");
INSERT INTO gnwNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Mbaetɨ ma cua pe oĩ. Jae icove ye ou umanocue vae reta ipɨte güi. Pemandúa jae icose pe ndive Galilea pe yave jei peve vae re —jei reta—. ");
INSERT INTO gnwNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Echa'ã jae jei peve: ‘Chemeeta cuimbae icavi mbae vae uyapo vae reta pe. Jae reta checututa curusu re. Ẽrei che cuimbaerã ayeyapo vae aicove yeta ayu umanocue vae reta ipɨte güi mbapɨ ara rupi’ —jei, jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Jayave jae reta imandúa Jesús jei chupe reta vae re. ");
INSERT INTO gnwNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Jayave yugüeru ye teõgüerɨru güi jare umɨmbeu opaete uyeyapo vae jocua once vae jare opaete ĩru vae reta pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Jocua cuña reta co jae María Magdalena, jare Juana, jare Jacobo ichɨ María jee vae, jare ĩru cuña jae reta jupíe yugüɨraa vae reta. Cua reta umɨmbeu Jesús jemimondo reta pe mbae uyeyapo vae. ");
INSERT INTO gnwNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ẽrei iyapu echa reta Jesús jemimondo reta pe. Güɨrovia'ã reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Jayave Pedro osi oo teõgüerɨru cotɨ. Jare joco pe oo uvãe yave, ipe umae vaerã teõgüerɨru japɨpe pe, jare uecha nieso reta joco pe oĩ. Jayave ou ye joco güi. Ipɨacañɨ uyeyapo vae re. ");
INSERT INTO gnwNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Jare jocua ara etei mocui Jesús jemimboe reta yugüɨraa tape rupi Jerusalén güi tenta guasu-raɨ Emaús cotɨ. Emaús oĩ mocui legua Jerusalén güi. ");
INSERT INTO gnwNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Jare tape rupi yugüɨraa rambueve, imiari uyupe opaete uyeyapo vae re. ");
INSERT INTO gnwNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Jare aramoiño uyemɨngueta ñugüɨnoi rambueve, Jesús uyecuaa chupe reta jare oo jae reta jupíe. ");
INSERT INTO gnwNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ẽrei jae reta uicuaa'ã Jesús. Echa'ã Jesús ndei uipota uyecuaaca chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jayave Jesús upɨrandu chupe reta: —¿Mbae re pa pemiari piyupe peguata rambueve? ¿Maera pa pepɨatɨtɨ? —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Jare penti Cleofas jee vae upɨrandu Jesús pe: —¿Ndico'ã pa Jerusalén pe? ¿Ndicuaa'ã pa cua ara reta pe opaete uyeyapo vae? —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","—¿Mbae pa? —jei chupe reta. —Jesús Nazaret pegua pe uyeyapo vae —jei reta chupe—. Jae co penti Tumpa iñee umɨmbeu vae. Uyapo jeta mbae icavi vae mbaepuere reve, jare icavi oporomboe. Uyeyocui cavi Tumpa pe jare opaete tenta guasu pegua reta umbɨadora —jei reta Jesús pe—. ");
INSERT INTO gnwNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ẽrei sacerdote reta itenondegua reta jare oretenondegua reta umee mburuvicha guasu pe, jae uyucaca vaerã. Jare uicutuca reta curusu re —jei reta—. ");
INSERT INTO gnwNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ẽrei ore ndugüɨrovia tẽi jae uepɨta Israel pegua reta. Jare cua ara mbapɨ ara ma opaete cua uyeyapo vae güi —jei reta—. ");
INSERT INTO gnwNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ẽrei amocue cuña ore ndive uyeyocuise Jesús pe vae reta iyei neimbove yugüɨraa teõgüerɨru pe, jare yugüeru ye yave, oremɨpɨacañɨ ete. ");
INSERT INTO gnwNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Echa'ã jae reta uvãe'ã Jesús jetecue, jare yugüeru ye yave, jei oreve quirãi uecha ángel reta joco pe jare quirãi ángel reta jei Jesús icove ye ma oĩ —jei reta—. ");
INSERT INTO gnwNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Jayave amocue ore ndive ñugüɨnoi vae yugüɨraa vi teõgüerɨru pe, jare yugüeru ye yave, umɨmbeu oreve mbaetɨ joco pe oĩ Jesús jetecue cuña reta jei oreve rami —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Jayave Jesús jei chupe reta: —Pe reta co jae iyaracuaa mbae vae reta rami. Yavai co oĩ peve perovia vaerã opaete Tumpa iñee aracae umɨmbeu vae reta uicuatiacue vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Picuaata tẽi ma jae reta uicuatía co quirãi Cristo, Tumpa ombou vae, uiporarañotai rani co jare quirãi jocua jaɨcue rupi uyembɨadoracata co —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Jayave Jesús umɨmbeu chupe reta jeta Moisés jare Tumpa iñee aracae umɨmbeu vae reta uicuatiacue vae güi, jare umɨmbeu cavi chupe reta quirãi opaete jocua uyecuatía oĩ vae imiari Cristo re. ");
INSERT INTO gnwNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Jare yugüɨraa ma uvãe coiño Emaús güi. Echa'ã jocua mocui vae upɨtata joco pe. Jare Jesús uasata tẽi oo cutɨ. ");
INSERT INTO gnwNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ẽrei jae reta jei chupe: —Epɨta ore ndive. Echa'ã caaru ma. Pɨ̃tuta co ndeve —jei reta. Jayave Jesús upɨta jae reta jenta pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Jare uguapɨ rambueve mesa pe ucaru vaerã, Jesús uipɨsɨ mbɨyape jare umee yasurupai Tumpa pe. Jayave upɨsãa umee chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Jayave ramo uicuaa reta Jesús. Echa'ã Jesús umaeño ma jese reta uicuaa vaerã. Jayave jupivoiño Jesús ucañɨ chugüi reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Jayave jei reta uyupe: —Añete co, jae yanembɨyerovia ete, tape rupi imiari yandeve rambueve. Echa'ã uicuaaca yandeve Tumpa iñee uyecuatía oĩ vae —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Jayave jocua ora pe etei jae reta upũa mesa güi jare yugüɨraa ye Jerusalén pe. Joco pe uvãe jocua once vae yatɨ ĩru vae reta ndive. ");
INSERT INTO gnwNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","—Añete co, yandeYa icove ye ma ou umanocue vae reta ipɨte güi —jei yatɨ vae reta—. Echa'ã uyecuaa co Simón pe. ");
INSERT INTO gnwNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Jayave jocua mocui vae vi umɨmbeu yatɨ vae reta pe mbae tape rupi uyeyapo vae jare quirãi Jesús uyecuaaca chupe reta mbɨyape upɨsãa yave. ");
INSERT INTO gnwNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Jare uyemɨngueta ñugüɨnoi rambueve, Jesús etei uyecuaa uyemboɨ oĩ ipɨte pe, jare jei chupe reta: —Mbɨacatu toĩ pe ndive. ");
INSERT INTO gnwNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ẽrei jae reta uquɨye ete. Ipɨa pe uyemɨngueta tẽi jocua co Jesús iãcue. ");
INSERT INTO gnwNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ẽrei Jesús jei chupe reta: —¿Maera pa pequɨye? ¿Maera pa pepɨa pe piyemɨngueta jucuarãi? —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Pemae chepo jare chepɨ re. Che co jae. Pepuere cheavɨquɨ picuaa vaerã jae co che. Echa'ã penti vae iãcue güɨnoi'ã soo jare maecãgüe. Ẽrei pepuere peecha che ime co anoi soo jare maecãgüe —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Jare cua jei ma yave, uechaca chupe reta ipo jare ipɨ. ");
INSERT INTO gnwNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Jae reta ipɨacañɨ, jare uyerovia ete ramo ndei ipuere güɨrovia ete. Jayave Jesús upɨrandu chupe reta: —¿Ime pa penoi cua pe mbae jau vaerã? ");
INSERT INTO gnwNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Jayave umee reta chupe pira oyɨcue iperaso jare mbovɨ ei. ");
INSERT INTO gnwNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Jare Jesús uipɨsɨ jou jae reta jovaque. ");
INSERT INTO gnwNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Jayave jei chupe reta: —¿Pemandua'ã pa pe reta ndive aico rambueve che jae peve vae re? Echa'ã Moisés iporoyocui jare Tumpa iñee aracae umɨmbeu vae reta uicuatiacue vae jare Salmo reta chemɨmbeu. Jare amɨmbeu peve quirãi opaete cua chemɨmbeu vae uyeyapota co —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Jayave umee chupe reta uicuaa cavi vaerã Tumpa iñee uyecuatía oĩ vae. ");
INSERT INTO gnwNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Jayave jei chupe reta: —Cuarãi uyecuatía oĩ quirãi Cristo, Tumpa ombou vae, uiporarañotai co jare icove yeta co ou umanocue vae reta ipɨte güi mbapɨ ara rupi, ");
INSERT INTO gnwNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","jare quirãi jerãcuata ĩru vae reta pe Cristo jee re ueya vaerã iyemɨngueta icavi mbae vae ipɨa pe oĩ vae Tumpa umbɨasa vaerã chupe reta imbaeyoa reta. Jerãcuata rani Jerusalén pe. Jayave joco güi jerãcuata opaete ɨvɨ pegua reta pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Jare pe reta pemɨmbeuta opaete cua regua —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Mase, ambouta peve cheRu jei umeeta co peve vae. Ẽrei pepɨta tenta guasu Jerusalén pe mbaepuere güɨnoi vae ara güi ou peve regua —jei. ");
INSERT INTO gnwNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Jayave Jesús güɨraa reta Betania pe. Jayave uupi ipo ara cotɨ jare umɨvendise reta. ");
INSERT INTO gnwNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Jare umɨvendise oĩ rambueve, oo chugüi reta ara cotɨ. ");
INSERT INTO gnwNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Jayave jae reta umbɨadora. Jayave yugüɨraa ye Jerusalén pe uyerovia reve. ");
INSERT INTO gnwNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Jare jecuaeño yugüɨraa Tumpa jo pe umbɨadora reve Tumpa. Amén.");
INSERT INTO gnwNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ndei mbae uyeyapo mbove, ico Ñee. Jare Ñee ico Tumpa ndive. Jae co Tumpa etei. ");
INSERT INTO gnwNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ñee ico Tumpa ndive ndei mbae uyeyapo mbove. ");
INSERT INTO gnwNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Jae uyapo opaete. Opaete uyeyapo vae jae etei uyapo. ");
INSERT INTO gnwNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Jae umee tecove opaete pe, jare cua tecove rupi jae uyecuaa ɨvɨ pegua reta pe mbaembae uyecuaa tembipe rupi rami. ");
INSERT INTO gnwNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Jae co tembipe rami. Tembipe jecuaeño jembipe pɨ̃tumimbi pe, jare pɨ̃tumimbi ipuere'ã etei ombove. ");
INSERT INTO gnwNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","7","Ico penti cuimbae Juan jee vae. Tumpa ombou cua cuimbae umɨmbeu vaerã tembipe regua, ĩru vae reta upurugüɨrovia vaerã uyandu yave. ");
INSERT INTO gnwNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Jae jae'ã co jocua tembipe. Jaeño ou umɨmbeu vaerã jocua tembipe re. ");
INSERT INTO gnwNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Tembipe etei ou ma cua ɨvɨ pe. Jae uyecuaa opaete vae pe. ");
INSERT INTO gnwNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Jae ico cua ɨvɨ pe, jare jae uyapo cua ɨvɨ. Ẽrei ɨvɨ pegua reta uicuaa'ã. ");
INSERT INTO gnwNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ou ɨvɨ pe, ẽrei ɨvɨ pegua reta umbɨresive'ã. ");
INSERT INTO gnwNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ẽrei amocue vae umbɨresive. Güɨrovia jese. Jáeramo jae umee cua reta pe Tumpa taɨ retarã jare tayɨ retarã yugüɨreco vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Tumpa etei umee cua reta pe tecove. Cua tecove ou'ã co ichɨ rupi. Güɨnoi'ã cua tecove tu jei vae rupi. ");
INSERT INTO gnwNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Jocua Ñee uyeyapo cuimbaerã. Ou cua ɨvɨ pe ico vaerã yande ndive. Jare ore nduecha yembutuicha ara pegua co jae. Jaeño Tumpa Taɨ jae vaeño cua yembutuicha güɨnoi vae. Jae ipɨacavi ete jare opaete jei vae añete co. ");
INSERT INTO gnwNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Echa'ã Juan umɨmbeu ĩru vae reta pe: —Cua co jae chemiari jese vae —jei chupe reta—. Che jae ma peve: ‘Cheraɨcue rupi outa vae ipuere ete chegüi. Echa'ã jae ico ndei aico mbove’ —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Jocua Ñee ipɨacavi ete. Jáeramo jecuaeño uyapo icavi vae yandeve. ");
INSERT INTO gnwNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Tumpa umɨmbeu mboroyocui Moisés rupi. Ẽrei Jesucristo rupi Tumpa umɨmbeu ipɨacavi co jare yanemboe añete vae re. ");
INSERT INTO gnwNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Mbaetɨ etei quía uecha Tumpa. Ẽrei Tumpa Taɨ jae vaeño uicuaaca yandeve. Tumpa uau Taɨ. ");
INSERT INTO gnwNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Penti ara yugüɨraa uvãe Juan oĩ vae pe sacerdote reta jare levita reta. Judío reta Jerusalén pegua omondo cua reta chupe. Jae reta jei Juan pe: —¿Quía pa co nde? ");
INSERT INTO gnwNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Juan umɨmbeu cavi. Iyapu'ã chupe reta. —Che jae'ã co Cristo jee vae —jei chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Jayave upɨrandu reta ye chupe: —Nde jae'ã yave, ¿nde pa co jae Elías jee vae? Juan jei: —Che'ã co jae. Jei reta chupe: —¿Nde pa co jocua Tumpa iñee umɨmbeu vae? —Che'ã co jae —jei Juan chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Jayave upɨrandu reta ye chupe: —¿Quía pa co nde? Echa'ã nduipota numɨmbeu orembou vae reta pe. ¿Mbae pa ndere ndiyupe? —jei reta Juan pe. ");
INSERT INTO gnwNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Jayave Juan jei: —Che co jae penti ñee umɨmbeu vae. Chiñeeãta ñana pe: ‘Piyapɨcatu yandeYa japerã.’ Jucuarãi che jae —jei Juan—. Echa'ã jucuarãi jei Isaías aracae Tumpa iñee umɨmbeu vae —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Cua Juan oĩ vae pe yugüɨraa vae reta fariseo reta co. ");
INSERT INTO gnwNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Upɨrandu reta Juan pe: —Nde jae'ã yave Cristo ani Elías ani jocua Tumpa iñee umɨmbeu vae, ¿maera pa ndepurumbɨbautiza? ");
INSERT INTO gnwNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","27","—Che apurumbɨbautiza ɨ pe —jei Juan—. Ẽrei picuaa'ã, ime pepɨte pe jocua cheraɨcue rupi outa vae. Jupi'ã co che amboi vaerã ipɨpasa —jei chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Opaete cua uyeyapo Betábara pe ɨãca Jordán jee vae jovaicho pe. Echa'ã joco pe upurumbɨbautiza Juan. ");
INSERT INTO gnwNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Pɨareve pe Juan uecha Jesús ou icotɨ jare jei: —Mase, pee oĩ Tumpa ombou vae. Jae co ovecha rami. Ou güɨraa vaerã opaete ɨvɨ pegua reta imbaeyoa —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Cua co jae chemiari jese vae. Che jae ma peve: ‘Cheraɨcue rupi outa vae ipuere ete chegüi. Echa'ã jae ico ndei aico mbove.’ Cua co jae —jei Juan—. ");
INSERT INTO gnwNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Che aicuaa'ã. Ẽrei ayu apurumbɨbautiza ɨ pe jae uyecuaa vaerã Israel pegua reta pe —jei chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Juan umɨmbeu vi chupe reta: —Aecha Espíritu Santo ugüeyɨ ara güi pɨcasu rami jare ou upɨta jese —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Che aicuaa'ã. Ẽrei chembou apurumbɨbautiza vaerã ɨ pe vae jei cheve: ‘Ndeechata Espíritu Santo ugüeyɨ ou upɨta penti cuimbae re. Jocua cuimbae upurumbɨbautizata Espíritu Santo pe’ —jei, jei Juan—. ");
INSERT INTO gnwNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Jocua aecha ma jare amɨmbeu peve cua co jae Tumpa Taɨ —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Pɨareve pe Juan uyemboɨ ye oĩ joco pe mocui jemimboe ndive. ");
INSERT INTO gnwNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Jayave ou Jesús uasa jocoropi. Juan umae ngatu jese. —Mase, pee oĩ Tumpa ombou vae. Jae co ovecha rami —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Jocua mocui jemimboe uyandu jare yugüɨraa Jesús jaɨcue. ");
INSERT INTO gnwNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jesús uyerova yave, uecha yugüeru icotɨ. —¿Mbae pa peeca? —jei chupe reta. —¿Quíape pa ndico, Rabí? —jei reta. (Rabí uipota jei: “Oporomboe vae”.) ");
INSERT INTO gnwNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","—Peyu peecha —jei Jesús. Jayave yugüɨraa Jesús ico vae pe uecha, jare upɨta jocua ara jae ndive. Echa'ã caaru catu ma. ");
INSERT INTO gnwNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Mocui cuimbae co jocua Jesús jaɨcue yugüɨraa vae. Echa'ã yugüɨraa jaɨcue uyandu yave Juan jei chupe reta vae. Penti cuimbae jee co Andrés. Jae co Simón Pedro tɨvɨ. ");
INSERT INTO gnwNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andrés oo rani uvãe tɨqueɨ Simón pe jare jei chupe: —Nuvãe ma Mesías. (Cua uipota jei hebreo iñee pe: “Cristo, Tumpa ombou vae”.) ");
INSERT INTO gnwNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Jayave Andrés güeru Simón Jesús oĩ vae pe. Jesús umae ngatu Simón re jare jei: —Nde co jae Simón. Nde co jae Jonás taɨ. Turumbɨjee Cefas. (Cua uipota jei: “Pedro”.) ");
INSERT INTO gnwNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","44","Pɨareve pe Jesús uipota oo Galilea pe. Jare uvãe Felipe Betsaida pegua. Andrés jare Pedro Betsaida pegua vi. Jesús jei Felipe pe: —Eyu cherupíe. ");
INSERT INTO gnwNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Jayave Felipe oo uvãe Natanael pe jare jei chupe: —Nuvãe ma Moisés mboroyocui pe imiari jese vae. Aracae Tumpa iñee umɨmbeu vae reta vi imiari jese —jei—. Jae co Jesús Nazaret pegua. Jae co José taɨ —jei chupe. ");
INSERT INTO gnwNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","—¿Ime pa mbae icavi vae Nazaret pegua? —jei Natanael. —Yaa eecha —jei Felipe. ");
INSERT INTO gnwNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jesús uecha Natanael ou icotɨ jare jei: —Mase, co ou penti Israel pegua añetete vae. Jecuaeño uyapo añete vae rupi —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanael upɨrandu Jesús pe: —¿Quirãi pa checuaa? Jesús jei chupe: —Ndei Felipe nereni mbove, che nduecha ɨva igüɨ pe. ");
INSERT INTO gnwNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","—Nde co jae Tumpa Taɨ, Oporomboe vae —jei Natanael—. Nde co jae Israel pegua reta juvicha guasu —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesús jei chupe: —Amɨmbeu ndeve che nduecha ɨva igüɨ pe. ¿Cua jeco pegua ra ndepurugüɨrovia ma? —jei—. Ndeechata mbaembae ndepurugüɨrovia ete vaerã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Añete che jae ndeve, ndeechata ara uyepea oĩ, jare ndeechata vi ángel Tumpa pe uyeyocui vae reta uyupi ñugüɨnoi jare ugüeyɨ ñugüɨnoi che aĩ vae pe. Che co jae cuimbaerã uyeyapo vae —jei Jesús. ");
INSERT INTO gnwNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Mbapɨ ara rupi penti cuimbae umenda cuñatai ndive Caná Galilea pegua pe, jare Jesús ichɨ joco pe oĩ. ");
INSERT INTO gnwNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jare uparea reta vi Jesús jare jemimboe reta pe. ");
INSERT INTO gnwNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Vino opa ma yave, Jesús ichɨ jei Jesús pe: —Opa ma vino. ");
INSERT INTO gnwNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","—Cuña, ¿maera pa ndere cheve cua? —jei Jesús—. Ndei uvãe cheparavɨquɨ ayapo vaerã —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Jayave Jesús ichɨ jei joco pe uyeyocui vae reta pe: —Piyapo umɨmbeuta peve vae. ");
INSERT INTO gnwNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Joco pe ñugüɨnoi seis ɨru guasu ita pegua. Judío reta uiporu jocua nunga ɨru guasu mbaembae oyoe vaerã Tumpa cotɨ jecoño mai uyapo rami. Penti penti ɨru guasu ipuere tɨnee pandepo ɨru ɨ pe. ");
INSERT INTO gnwNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesús jei tembiocui reta pe: —Pemɨtɨnee cavi ɨru guasu reta ɨ pe. Jayave jae reta umɨtɨnee cavi. ");
INSERT INTO gnwNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Jesús jei chupe reta: —Añave piñoẽ peraa peruvicha pe. Jayave jucuarãi uyapo reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Uyeyocui vae reta juvicha jou jocua ɨ vinorã uyeyapo vae. Jae uicuaa'ã quía güi ra ou jocua jou vae, ẽrei jembiocui reta uicuaa catu quía güi co oñoẽ. Jayave mburuvicha ueni cuimbae umenda vae. ");
INSERT INTO gnwNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","—Opaete ĩru vae reta umee vino icavi vae mboupa reta pe. Jayave jeta vino jou yave ramo umee chupe reta vino icavi nunga mbae vae —jei chupe—. Ẽrei nde añave ramo nemee vino icavi ete vae —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jesús cua uyapo Caná Galilea pegua pe. Cuarãi Jesús umbɨpɨ uicuaaca jemimboe reta pe jae imbaepuere tuicha ete co. Jare cua uyapo vae jeco pegua jemimboe reta güɨrovia jese. ");
INSERT INTO gnwNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Cua jaɨcue rupi Jesús oo Capernaúm pe. Yugüɨraa vi jae jupíe ichɨ jare tɨvɨ reta jare jemimboe reta. Jare upɨta reta joco pe mbovɨ ara. ");
INSERT INTO gnwNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Jare coiño ma ou judío reta pascua iara. Jayave Jesús oo Jerusalén pe. ");
INSERT INTO gnwNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Jare Tumpa jo pe uecha umaemee vae reta. Umee ñugüɨnoi güeye reta jare ovecha reta jare pɨcasu reta. Uecha vi corepoti uipepɨca vae reta uguapɨ ñugüɨnoi joco pe. ");
INSERT INTO gnwNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Jayave Jesús uyapo chicote jare omoẽ umaemee vae reta jare ovecha reta jare güeye reta Tumpa jo güi. Jayave upɨyere corepoti uipepɨca vae reta icorepoti jare umbɨyapara imesa reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Jare jei pɨcasu umee vae reta pe: —Peraa cua güi cua reta. Agüɨye pemee mbaembae cheRu jo pe —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Jayave jemimboe reta imandúa quirãi ime Tumpa iñee pe uyecuatía oĩ cuarãi: “Aipota ete Tumpa jo uyepɨuca vaerã. Cheragüɨ̃ro jese. Jáeramo cua jeco pegua ĩru vae reta uyapota icavi mbae vae cheve.” Jucuarãi uyecuatía oĩ. ");
INSERT INTO gnwNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Jayave judío reta upɨrandu Jesús pe: —¿Mbae nunga mɨacañɨ pa ndeechacata oreve nduicuaa vaerã ime ra nenoi mbaepuere cua mbaravɨquɨ ndiyapo vae ndiyapo vaerã? ");
INSERT INTO gnwNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesús jei chupe reta: —Pembusururu yave cua Tumpa jo, che amupũa yeta co mbapɨ ara pe. ");
INSERT INTO gnwNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","—Uparavɨquɨ reta cuarenta y seis año uyapo vaerã cua Tumpa jo —jei judío reta—. ¿Nemupũa yeta ra nde mbapɨ ara pe? —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ẽrei Jesús uyemɨngueta chupe reta jete re. Echa'ã jete co jae Tumpa jo. ");
INSERT INTO gnwNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Jáeramo Jesús icove ye yave ou umanocue vae reta ipɨte güi, jemimboe reta imandúa cua jei vae re. Jayave güɨrovia aracae Tumpa iñee pe uyecuatía oĩ vae jare jocua Jesús jei chupe reta vae. ");
INSERT INTO gnwNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jesús upɨta Jerusalén pe pascua iara pe. Joco pe oĩ rambueve, jeta vae güɨrovia jese uecha yave jocua mɨacañɨ reta uyapo vae. ");
INSERT INTO gnwNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ẽrei Jesús güɨrovia'ã añetete cua reta ipurugüɨrovia. Echa'ã uicuaa cavi opaete ɨvɨ pegua reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Jae ueca'ã quía umɨmbeu vaerã chupe ɨvɨ pegua reta regua. Echa'ã jae uicuaa cavi ɨvɨ pegua reta ipɨa pe oĩ vae. ");
INSERT INTO gnwNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ico penti fariseo Nicodemo jee vae. Jae co judío reta juvicha. ");
INSERT INTO gnwNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Cua cuimbae ou Jesús oĩ vae pe pɨ̃tu yave jare jei chupe: —Oporomboe vae, nduicuaa co Tumpa nembou ndeporomboe vaerã. Echa'ã mbaetɨ quía ipuere uyapo jocua nunga mɨacañɨ ndiyapo vae Tumpa oĩ'ã yave jae ndive —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","—Añete che jae ndeve —jei Jesús Nicodemo pe—, ime yave quía uipota ico Tumpa iporoyocuia pe vae, güɨnoita rani co tecove ipɨau vae —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","—¿Quirãita pa co yandepuere tecove ipɨau vae ñanoi yanendechi ma yave? —jei Nicodemo—. Yandepuere'ã etei yaique ye yandesɨ jɨe pe yaa ye vaerã —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesús jei chupe: —Añete che jae ndeve, ime yave quía uipota ico Tumpa iporoyocuia pe vae, güɨnoita rani co tecove ipɨau vae ɨ jare Espíritu Santo rupi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Yaa yave yandesɨ güi, ñanoi tecove ɨvɨ peguarãño. Ẽrei Espíritu Santo umee yandeve tecove Espíritu pegua —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Amɨmbeu ma ndeve quirãi penoita rani co tecove ipɨau vae. Agüɨye nepɨacañɨ cua re —jei chupe—. ");
INSERT INTO gnwNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ɨvɨtu uyepeyu ipotave rupi güi jare ndiyandu jɨapu. Ẽrei ndicuaa'ã quetɨ güi ra ou jare quetɨ ra oo. Jucuarãi co oĩ Espíritu Santo umee tecove chupe vae —jei Jesús. ");
INSERT INTO gnwNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nicodemo upɨrandu Jesús pe: —¿Quirãita pa co uyeyapo cua? ");
INSERT INTO gnwNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesús upɨrandu Nicodemo pe: —¿Ndicuaa'ã pa cua? Echa'ã nde co jae Israel pegua reta omboe vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Añete che jae ndeve, nduyemɨngueta nduicuaa vae re jare numɨmbeu nduecha vae. Ẽrei perovia'ã numɨmbeu peve vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Amɨmbeu ma peve mbaembae uyeyapo ɨvɨ pe vae, ẽrei chererovia'ã. ¿Quirãita pa pepuere chererovia mbaembae uyeyapo ara pe vae amɨmbeu peve yave? —jei Jesús Nicodemo pe—. ");
INSERT INTO gnwNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","14","Mbaetɨ quía ye uyupi oo ara pe, jaeño che ara güi agüeyɨ ayu vae. Che co jae cuimbaerã uyeyapo vae ara pe oĩ vae —jei chupe—. Moisés aracae uupi jocua mboi ɨvɨra re, ñana pe ico yave. Jucuarãi vi ĩru vae reta chereupita co, ");
INSERT INTO gnwNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ipotave güɨrovia cheré vae güɨnoi vaerã tecove opa mbae vae. Ndarau oo cañɨtei pe —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Echa'ã Tumpa uau ete ɨvɨ pegua reta. Jáeramo umee Taɨ jae vaeño, ipotave güɨrovia jese vae güɨnoi vaerã tecove opa mbae vae. Ndarau oo cañɨtei pe. ");
INSERT INTO gnwNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Tumpa ombou Taɨ ɨvɨ pe, ɨvɨ pegua reta uyembɨasaca vaerã jae jeco pegua. Taɨ ou'ã uãa vaerã ɨvɨ pegua reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Güɨrovia Tumpa Taɨ re vae reta ndarau ma uñeãaca. Ẽrei ĩru vae reta uñeãaca ma co. Echa'ã Tumpa Taɨ jae vaeño umɨmbeu ma quía co jae. Ẽrei jae reta güɨrovia'ã. ");
INSERT INTO gnwNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Tembipe ou ma ɨvɨ pe, ẽrei ɨvɨ pegua reta uipota ete ico pɨ̃tumimbi pe. Uipota'ã ico tembipe pe. Echa'ã uyapo reta icavi mbae vae. Jáeramo uñeãaca reta ma co. ");
INSERT INTO gnwNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ipotave icavi mbae vae uyapo vae umɨtarẽɨ tembipe. Ou'ã tembipe oĩ vae pe agüɨye vaerã ĩru vae reta uicuaa mbae uyapo vae. ");
INSERT INTO gnwNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ẽrei añete pegua rupi ico vae ou tembipe oĩ vae pe, ĩru vae reta uicuaa vaerã mbaravɨquɨ uyapo vae uyapo co Tumpa jei vae rupi. ");
INSERT INTO gnwNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Cua jaɨcue rupi Jesús jare jemimboe reta yugüɨraa ɨvɨ Judea jee vae pe. Joco pe upɨta Jesús jae reta ndive jare upurumbɨbautizaca oĩ. ");
INSERT INTO gnwNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Juan vi upurumbɨbautiza oĩ Enón pe. Enón coiño oĩ Salim güi. Echa'ã joco pe jeta ɨ oĩ. Jare amocue vae yugüeru jare Juan umbɨbautiza reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Echa'ã Juan ndei uyereraaca peresorɨru pe. ");
INSERT INTO gnwNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Jayave Juan jemimboe reta uyeaca ñugüɨnoi judío reta ndive quirãi ipuere uyeyoe cavi Tumpa peguarã vae re. ");
INSERT INTO gnwNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Jayave yugüeru Juan oĩ vae pe jare jei chupe: —Oporomboe vae, nde nemɨmbeu ma oreve Jordán jovaicho pe nde ndive icose vae regua. Mase, jae upurumbɨbautiza oĩ, jare opaete vae yugüɨraa ñugüɨnoi jae oĩ vae pe —jei reta Juan pe. ");
INSERT INTO gnwNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Jayave Juan jei chupe reta: —Tumpa umee yandeve vaeño yandepuere ñanoi. ");
INSERT INTO gnwNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Che jae ma peve: ‘Che jae'ã co Cristo. Jaeño Tumpa che rani chembou chugüi.’ Pe reta etei picuaa cuarãi co che jae peve —jei chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Jae co penti cuimbae umendata vae rami. Che co umendata vae iamigo rami. Echa'ã umendata vae iamigo upɨta umendata vae ndive jare uyapɨsaca jese jare uyerovia iñee uyandu yave. Jucuarãiño vi co che ayerovia ete —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Echa'ã jeta vae yugüɨraata jae oĩ vae pe, ẽrei mbovɨño ma co yugüeruta che aĩ vae pe —jei Juan chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ara güi ou vae ipuere opaete ĩru vae reta güi. Ɨvɨ pegua reta ɨvɨ peguaño co jare uyemɨngueta mbaembae ɨvɨ pe oĩ vae re. Ara güi ou vae ipuere opaete ĩru vae reta güi. ");
INSERT INTO gnwNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Jae umɨmbeu uecha jare uyandu vae, ẽrei mbaetɨ quía güɨrovia jae umɨmbeu vae. ");
INSERT INTO gnwNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Jae umɨmbeu vae güɨrovia vae uicuaaca ĩru vae reta pe güɨrovia co Tumpa iñee añete co. ");
INSERT INTO gnwNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Echa'ã jocua Tumpa ombou vae umɨmbeu Tumpa iñee, jare Tumpa umee chupe Espíritu Santo opaete imbaepuere reve. ");
INSERT INTO gnwNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Tu uau Taɨ jare oñono opaete mbaembae ipo pe. ");
INSERT INTO gnwNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Tumpa Taɨ re güɨrovia vae güɨnoi ma tecove opa mbae vae. Tumpa Taɨ re güɨrovia mbae vae ndarau güɨnoi tecove. Tumpa uiporaracata chupe. ");
INSERT INTO gnwNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","YandeYa Jesús uyandu jerãcua ma co fariseo reta pe cuarãi: “Jesús uyapo oĩ jare umbɨbautiza oĩ jeta jemimboe retarã Juan güi.” Jucuarãi jerãcua. ");
INSERT INTO gnwNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Ẽrei Jesús etei upurumbɨbautiza'ã. Jemimboe retaño upurumbɨbautiza ñugüɨnoi. ");
INSERT INTO gnwNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Jayave cua uicuaa yave, Jesús oẽ Judea güi oo ye Galilea pe. ");
INSERT INTO gnwNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Jare oo Samaria rupi. Echa'ã tape uasa jocoropi. ");
INSERT INTO gnwNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Jayave oo uvãe tenta guasu Sicar jee vae pe. Jocua tenta guasu Samaria pegua co, jare coiño oĩ ɨvɨ Jacob aracae umee taɨ José pe vae güi. ");
INSERT INTO gnwNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Jocua ɨvɨ pe oĩ penti ɨcua. Jocua ɨcua jee Jacob iɨcua. Jayave Jesús uguapɨ ɨcua iyɨpɨ pe. Echa'ã mbɨrɨ ma uguata, jare icandɨ. Jare doce pota rupi ma. ");
INSERT INTO gnwNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Jayave ou uvãe penti cuña Samaria pegua ɨ güɨnoẽ vaerã. Jare Jesús jei chupe: —Emee tau ɨ. ");
INSERT INTO gnwNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Echa'ã Jesús jemimboe reta yugüɨraa tenta guasu pe jembiurã ogua vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Jayave cuña Samaria pegua jei Jesús pe: —Nde co jae penti judío jare che co jae penti Samaria pegua. ¿Maera pa nde ndere cheve: ‘Emee tau ɨ?’ —jei. (Echa'ã judío reta uyemɨngueta'ã Samaria pegua reta ndive.) ");
INSERT INTO gnwNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jayave Jesús jei cuña pe: —Che jae ma ndeve: ‘Emee tau ɨ.’ Ndicuaa yave Tumpa uipota umee ndeve vae jare ndicuaa yave quía co che, ndiyerureta tẽi co cheve jare che ameeta tẽi co ndeve ɨ tecove güɨnoi vae —jei Jesús. ");
INSERT INTO gnwNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","—Carai —jei cuña Jesús pe—, nde mbaetɨ mbae nenoi ɨ nenoẽ pɨpe vaerã, jare cua ɨ quɨpe oĩ. ¿Quía güi pa nderuta jocua ɨ tecove güɨnoi vae? —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","¿Tuicha ete pa nembaepuere yandetenondegua Jacob imbaepuere güi? Echa'ã Jacob umee yandeve cua ɨ. Jae etei jare taɨ reta jare jɨmba reta jou cua güi —jei cuña. ");
INSERT INTO gnwNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesús jei chupe: —Ipotave cua ɨ jou vae iúe yeta co. ");
INSERT INTO gnwNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ẽrei ipotave ɨ che ameeta jou vae ndarau ye iúe —jei—. Echa'ã jocua ɨ che ameeta chupe vae uyeyapota ipɨa pe penti ɨcua ɨ oẽ vae rami. Jecuaeño umeeta chupe tecove opa mbae vae —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","—Carai —jei cuña—, emee cheve cua ɨ, agüɨye ye vaerã cheúe jare agüɨye ye vaerã ayu cua pe ɨ anoẽ vaerã —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jayave Jesús jei chupe: —Ecua eeni neme peyu cua pe. ");
INSERT INTO gnwNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","—Mbaetɨ cheme —jei cuña. —Añete co ndere: ‘Mbaetɨ cheme’ —jei Jesús cuña pe—. ");
INSERT INTO gnwNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Echa'ã nenoi ma pandepo neme, jare jocua cuimbae añave nenoi vae jae'ã co neme. Añete co ndere —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","—Carai —jei cuña—, añave aicuaa nde co jae penti Tumpa iñee umɨmbeu vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Yandetenondegua reta umbɨadora Tumpa cua ɨvɨtu guasu re. Ẽrei pe reta pere Jerusalén pe oĩ Tumpa jo, jare joco peño ĩru vae reta vi umbɨadorata tẽi Tumpa —jei cuña. ");
INSERT INTO gnwNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","—Chererovia, cuña —jei Jesús—. Outa ma ara agüɨye vaerã pembɨadora cheRu cua ɨvɨtu guasu reño ani Jerusalén peño —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Pe reta pemaembɨadora yave, picuaa cavi'ã mbae pembɨadora vae. Ore numaembɨadora yave, nduicuaa cavi co mbae numbɨadora vae. Echa'ã ĩru vae reta uyembɨasacata judío reta rupi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ẽrei outa ma ara - ou ma co - añetete Tumpa umbɨadora vae umbɨadora vaerã Espíritu Santo rupi. Umbɨadorata añete vae rupi —jei—. Echa'ã cheRu ueca cua nunga jae reta umbɨadora vaerã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Tumpa co jae Espíritu. Umbɨadora vae reta tumbɨadora Espíritu Santo rupi jare añete vae rupi —jei Jesús. ");
INSERT INTO gnwNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Jayave cuña jei Jesús pe: —Aicuaa Tumpa ombou vae outa co - jae co Cristo jee vae - jare jae ou yave, umɨmbeuta yandeve opaete mbaembae regua —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","—Jae co che ayemɨngueta aĩ nde ndive vae —jei Jesús. ");
INSERT INTO gnwNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Cua jei oĩ yave, Jesús jemimboe reta yugüeru uvãe. Ipɨacañɨ Jesús uyemɨngueta oĩ cuña ndive vae re. Ẽrei penti ave jei'ã chupe: “¿Mbae pa ndipota?” ani “¿Maera pa ndiyemɨngueta jae ndive?” ");
INSERT INTO gnwNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Jayave cuña ueya iɨru joco pe jare oo uvãe tenta guasu pe. Jei cuimbae tenta guasu pegua reta pe: ");
INSERT INTO gnwNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Pecua peecha cuimbae opaete ayapocue umɨmbeu cheve vae. ¿Jae'ã ra co Cristo, Tumpa ombou vae? —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Jayave cuimbae reta oẽ tenta guasu güi yugüeru Jesús cotɨ. ");
INSERT INTO gnwNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Cuña oo ma yave, Jesús jemimboe reta jei chupe: —Oporomboe vae, ecaru. ");
INSERT INTO gnwNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","—Ime anoi cherembiurã pe reta picuaa mbae vae —jei Jesús chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Jayave jemimboe reta jei uyupe: —¿Güeru ma ra quía mbae jou vaerã? ");
INSERT INTO gnwNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","—Che ayapo chembou vae uipota ayapo vaerã vae, jare opaete iparavɨquɨ ayapo —jei Jesús—. Cua co jae cherembiurã rami —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Pe reta pere: ‘Irundɨ yasɨ rupi oĩta ma co mbaevɨro.’ Ẽrei che jae peve: Mase, pemae co reta re. Joco pe oĩ vae yagüɨye ma co. Uvãe ma mbaevɨro —jei Jesús—. ");
INSERT INTO gnwNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Jare tecove opa mbae vae uñemee chupe vae uyeavɨro vae rami co. Jare temitɨ iya umbɨepɨ umbaevɨro vae pe, umaetɨ vae jare umbaevɨro vae uyerovia pãve vaerã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Jucuarãi añete co cua: ‘Penti vae umaetɨ jare ĩru vae umbaevɨro’ —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Che pomondo peavɨro vaerã peparavɨquɨ'ã jese vae. Ĩru vae reta uparavɨquɨ jese, jare pe reta peavɨro jae reta iparavɨquɨ vae —jei Jesús chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Jare jeta jocua tenta guasu pegua reta - Samaria pegua reta co - güɨrovia Jesús re cuña umɨmbeu chupe reta vae jeco pegua. Echa'ã cuña jei ma chupe reta: “Opaete ayapocue umɨmbeu cheve.” ");
INSERT INTO gnwNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Jayave Samaria pegua reta yugüeru uvãe yave Jesús oĩ vae pe, jei chupe: —Ecua orerenta pe epɨta ore ndive. Jayave Jesús oo upɨta joco pe mocui ara. ");
INSERT INTO gnwNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Jare jeta ĩru vae reta upurugüɨrovia Jesús etei jei chupe reta vae jeco pegua. ");
INSERT INTO gnwNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Jayave jei reta cuña pe: —Tenonde yave ndupurugüɨrovia nde ndere oreve vae jeco pegua. Ẽrei añave ndupurugüɨrovia ore etei nduyandu ramo, jare añave nduicuaa cua co jae ɨvɨ pegua reta umbɨasa vae Cristo jee vae —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Mocui ara rupi Jesús oo joco güi Galilea cotɨ. ");
INSERT INTO gnwNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Echa'ã Jesús etei jei penti Tumpa iñee umɨmbeu vae jentaɨgua reta uipɨu'ã. ");
INSERT INTO gnwNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Jayave Jesús oo uvãe yave Galilea pe, joco pegua reta umbɨresive cavi. Echa'ã uecha reta ma opaete Jesús uyapo Jerusalén pe pascua pe vae. Echa'ã jae reta yugüɨraa vi joco pe. ");
INSERT INTO gnwNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Jayave Jesús oo uvãe Caná Galilea pegua pe. Joco pe tenonde yave uyapo ɨ vinorã. Jare ico Capernaum pe penti mburuvicha. Cua cuimbae taɨ imbaerasɨ oĩ. ");
INSERT INTO gnwNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Jare uicuaa yave Jesús ou ma co Judea güi uvãe Galilea pe, ou uvãe Jesús oĩ vae pe jare uyerure chupe taɨ re. —Ecua cherenta pe embɨgüera cheraɨ —jei—. Echa'ã umanota ma oĩ. ");
INSERT INTO gnwNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","—Aechaca'ã peve yave mɨacañɨ reta, ndarau perovia cheré —jei Jesús chupe. ");
INSERT INTO gnwNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","—Carai —jei mburuvicha—, ecua cherenta pe agüɨye vaerã cheraɨ umano. ");
INSERT INTO gnwNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","—Ecua yeño —jei Jesús chupe—. Nderaɨ icove catu ye ma oĩ —jei. Jayave mburuvicha güɨrovia Jesús jei chupe vae jare oo ye jenta cotɨ. ");
INSERT INTO gnwNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Jare oo rambueve jenta cotɨ, jembiocui reta yugüeru oovãiti jare jei chupe: —Icove catu ye ma oĩ nderaɨ. ");
INSERT INTO gnwNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Jayave mburuvicha upɨrandu chupe reta: —¿Mbae ora pe pa umbɨpɨ ucuera? —Caarumo una rupi jacu upɨta chugüi —jei reta chupe. ");
INSERT INTO gnwNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Jare cunumi tu uicuaa jocua ora pe etei co Jesús jei chupe: “Nderaɨ icove catu ye ma oĩ.” Jayave upurugüɨrovia jae jare opaete jenta pegua reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Cua mɨacañɨ uyapo Jesús uicuaaca vaerã quía co jae, ou yave Judea güi Galilea pe. Mocui ma co cua mɨacañɨ. ");
INSERT INTO gnwNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Cua jaɨcue rupi judío reta uyapo ñugüɨnoi fiesta, jare Jesús oo Jerusalén pe. ");
INSERT INTO gnwNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jare ime Jerusalén pe ovecha reta uñemeea jonque iyɨpɨ pe penti estanque tɨpɨ vae hebreo iñee pe Betesda jee vae. Ime cua ɨ iyɨpɨ rupi pandepo o-raɨ. ");
INSERT INTO gnwNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","O-raɨ japɨpe pe uyapacua ñugüɨnoi jeta imbaerasɨ vae reta. Joco pe ñugüɨnoi jesa mbae vae reta, ipuere mbae uguata vae reta, jare ipuere mbae omɨ vae reta. Opaete cua reta uãro ñugüɨnoi ɨ omɨ vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Echa'ã amo amo pe ugüeyɨ penti ángel omomɨ vaerã ɨ. Jare ɨ omɨ ma yave, jocua imbaerasɨ vae tenonde voi uique ɨ pe vae ucuera ipotave imbaerasɨ güi. ");
INSERT INTO gnwNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Jare imbaerasɨ vae reta ipɨte pe oĩ penti cuimbae treinta y ocho año ma ipuere mbae uguata vae. ");
INSERT INTO gnwNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jesús uecha cuimbae uyapacua oĩ joco pe, jare uicuaa ɨma ete ma imbaerasɨ. Jayave upɨrandu chupe: —¿Ndipota pa ndecuera? ");
INSERT INTO gnwNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","—Carai —jei cuimbae—, mbaetɨ quía cheñono vaerã ɨ pe ɨ omɨ yave. Che aa rambueve, ĩru vae uique ɨ pe tenonde chegüi —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jayave Jesús jei chupe: —Epũa evoɨ nderupa jare eguata. ");
INSERT INTO gnwNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Jayave cuimbae ucuera voi, jare ovoɨ jupa uguata. Jare jocua ara mbutuu ara co. ");
INSERT INTO gnwNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Jayave judío reta jei cuimbae ucuera ma vae pe: —Cua ara mbutuu ara co. Jupi'ã ndevoɨ vaerã nderupa mbutuu ara pe —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Cuimbae jei chupe reta: —Cuimbae chembɨgüera vae jei cheve: ‘Evoɨ nderupa jare eguata’ —jei cheve, jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Jayave upɨrandu reta chupe: —¿Quía pa jae ‘Evoɨ nderupa jare eguata’ jei ndeve vae? ");
INSERT INTO gnwNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ẽrei ucuera vae - tenonde yave ipuere mbae uguata vae - uicuaa'ã. Echa'ã jeta vae joco pe ñugüɨnoi jare Jesús oo ma joco güi. ");
INSERT INTO gnwNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ndei ɨma mbove Jesús oovãiti cuimbae Tumpa jo pe. —Ndecuera ma co. Jáeramo agüɨye ye iyapo icavi mbae vae. Echa'ã ndiyapo ye yave, mbae icavi mbae ete vae uyeyapota ndeve —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Jayave cuimbae oo umɨmbeu judío reta pe Jesús co jae umbɨgüera ma vae. ");
INSERT INTO gnwNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Jare Jesús uyapo ma amocue cua nunga mɨacañɨ mbutuu ara pe. Cua jeco pegua judío reta uipota uyapo icavi mbae vae chupe. Uipota vi uyuca. ");
INSERT INTO gnwNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ẽrei Jesús jei chupe reta: —CheRu jecuaeño uparavɨquɨ, jare che vi aparavɨquɨ. ");
INSERT INTO gnwNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Cua jeco pegua judío reta uipota uyuca Jesús. Echa'ã Jesús uyapo mbutuu ara pe jae reta jei jupi'ã uyeyapo vaerã vae, jare Jesús uyemɨngueta yave, jei: “Tumpa etei co cheRu”, jare cua uipota jei jae co Tumpa etei. ");
INSERT INTO gnwNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jayave Jesús jei chupe reta: —Añete che jae peve, che co jae Tumpa Taɨ. Cheiño chepuere'ã mbae ayapo. Ayapo jocua aecha cheRu uyapo oĩ vaeño. CheRu uyapo oĩ vae che ayapo vi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Echa'ã cheRu cherau jare uicuaaca ma cheve opaete iparavɨquɨ. Jare uicuaacata vi cheve mbaravɨquɨ tuicha ete cua reta güi vae, pepɨacañɨ ete vaerã jese —jei Jesús chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","CheRu umee tecove umanocue vae reta pe. Jae ramiño vi che amee tecove amocue vae reta pe. Amee aipota vae pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","CheRu ndarau uãa ɨvɨ pegua reta. Echa'ã umaeñota cheré aãa vaerã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Jucuarãi opaete vae chepɨuta uipɨu cheRu rami. Chepɨu'ã vae uipɨu'ã vi cheRu. Echa'ã jae co chembou —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Añete che jae peve, chiñee piyandu yave jare chembou vae perovia yave, penoi ma tecove opa mbae vae. Ndarau ma piñeãaca. Peasa ma co mano güi tecove opa mbae vae pe. ");
INSERT INTO gnwNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Añete che jae peve, outa ma ara - jáema ou - umanocue vae reta uyandu vaerã chiñee - che co jae Tumpa Taɨ - jare uyandu vae reta icove yeta co —jei Jesús chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Echa'ã cheRu ipuere umee tecove. Jae ramiño vi umaeño cheré amee vaerã tecove —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Jare cheRu umee cheve mbaepuere aãa vaerã ɨvɨ pegua reta che ayeyapo cuimbaerã ramo —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Agüɨye pepɨacañɨ cua re. Echa'ã outa ma ara opaete umanocue uñeñotɨ oĩ vae reta uyandu vaerã chiñee —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Icavi vae uyapo vae reta icove yeta ou tecove opa mbae vae güɨnoi vaerã, jare icavi mbae vae uyapo vae reta icove yeta ou uñeãaca vaerã —jei Jesús chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Cheiño chepuere'ã mbae ayapo. Che apuruãa cheRu umɨmbeu cheve vae rupi. Jáeramo apuruãa jupi vae rupi. Echa'ã ayapo'ã jae vae rupiño. Ayapo chembou vae jei vae rupi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Cheiño chemiari peve chiyee yave, pe reta peroviata'ã jocua jae vae. ");
INSERT INTO gnwNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ime ĩru chemɨmbeu vae, jare aicuaa jae jei peve cheré vae añete co —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Echa'ã pe reta pemondo cuimbae reta Juan re uyapɨsaca vaerã, jare jae jei cheré vae añete co —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Che aeca'ã quía chemɨmbeu vaerã, ẽrei cua che jae peve piyembɨasaca vaerã —jei Jesús—. ");
INSERT INTO gnwNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juan co jae penti mechero rami. Echa'ã mechero jendɨ jare umee yandeve tembipe. Ɨma ngatu rupi icavi echa peve piyerovia vaerã tembipe Juan umee peve vae re —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Cua mbaravɨquɨ ayapo vae reta chemɨmbeu ete Juan chemɨmbeu vae güi. CheRu uipota opa ayapo vaerã cua mbaravɨquɨ reta, jare cua ayapo vae rupi aicuaaca ĩru vae reta pe cheRu co chembou vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","CheRu chembou jare jae etei chemɨmbeu. Piyandu'ãi cheRu iñee jare peecha'ãi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Piyapo'ã cheRu jei peve piyapo vaerã vae. Echa'ã jae chembou, ẽrei chererovia'ã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Jecuaeño pemɨngueta Tumpa iñee pe uyecuatía oĩ vae. Echa'ã pepɨa pe piyemɨngueta joco pe pevãe quirãi pepuere penoi tecove opa mbae vae. Jare Tumpa iñee pe uyecuatía oĩ vae che co chemɨmbeu —jei Jesús chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ẽrei pipota'ã perovia cheré tecove opa mbae vae amee vaerã peve —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Che ayeco'ã yembutuicha ɨvɨ pegua reta umee vae re. ");
INSERT INTO gnwNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Echa'ã aicuaa pe reta peau'ã Tumpa pepɨa pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Che ayu cheRu chembou ramo, ẽrei pe reta chembɨresive'ã. Ĩru vae ou yave jei vae rupi, pembɨresiveta co —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Pepuere'ã etei pepurugüɨrovia. Echa'ã jecuaeño peeca ĩru vae reta pembutuicha vaerã, ẽrei peeca'ã yembutuicha Tumpa uipota tẽi penoi vaerã vae. Tumpa co jae pentiño —jei Jesús—. ");
INSERT INTO gnwNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Agüɨye pepɨa pe piyemɨngueta che ayu pumbɨjeco vaerã cheRu jovai. Echa'ã Moisés uicuatía vae co pembɨjeco, yepe tẽi pe reta pere: ‘Ore nduyapo Moisés uicuatía vae rupi. Jáeramo icavita oreve.’ Jucuarãi pere tẽi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Echa'ã Moisés uicuatía vae perovia yave, chereroviata tẽi co. Echa'ã Moisés uicuatía vae che co chemɨmbeu —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ẽrei perovia'ã Moisés uicuatía vae ramo, ndarau vi perovia chiñee —jei Jesús chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Cua jaɨcue rupi Jesús oo uvãe ɨ guasu Galilea jovaicho pe. Jocua ɨ guasu jee vi Tiberias. ");
INSERT INTO gnwNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Jare tenonde yave Jesús umbɨgüera amocue imbaerasɨ vae reta, jare jeta vae uecha ma mɨacañɨ Jesús uyapo vae reta. Jáeramo añave cua reta yugüɨraa Jesús jaɨcue. ");
INSERT INTO gnwNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jayave Jesús oo uyupi ɨvɨtu guasu re jare uguapɨ joco pe jemimboe reta ndive. ");
INSERT INTO gnwNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Jare coiño ma ou judío reta ifiesta pascua jee vae. ");
INSERT INTO gnwNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jare Jesús umae yave, uecha jeta vae yugüeru icotɨ. Jayave upɨrandu Felipe pe: —¿Quiape pa yandepuereta yagua mbɨyape cua reta jou vaerã —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jare cua Jesús jei uicuaa vaerã mbae ra jeita Felipe. Echa'ã Jesús uicuaa ma mbae uyapota vae. ");
INSERT INTO gnwNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Felipe jei chupe: —Doscientos ara mbaravɨquɨ jepɨ pegua mbɨyape ndarau uepitɨ cua reta jou vaerã, penti penti mbovɨño jou yave. ");
INSERT INTO gnwNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Penti Jesús jemimboe Andrés jee vae - jae co Simón Pedro tɨvɨ - jei Jesús pe: ");
INSERT INTO gnwNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Ime cua pe oĩ penti cunumi pandepo mbɨyape jare mocui pira güɨnoi vae. Ẽrei jocua mbovɨ co cua jeta vae reta jou vaerã —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","—Pemɨmbeu chupe reta uguapɨ vaerã —jei Jesús. Jare jeta capiichape oĩ joco pe. Jayave uguapɨ reta. Jare cuimbae reta cinco mil rupi ñugüɨnoi. ");
INSERT INTO gnwNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jayave Jesús uipɨsɨ jocua mbɨyape jare umee yasurupai Tumpa pe. Jayave umee mbɨyape jemimboe reta pe, jare jemimboe reta umee uguapɨ vae reta pe. Jae ramiño vi umee pira chupe reta. Jare opaete vae jou jare iyangapɨɨ. ");
INSERT INTO gnwNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Jayave iyangapɨɨ reta ma yave, Jesús jei jemimboe reta pe: —Pembatɨ tembíu uñepɨsãacue jembɨre vae, agüɨye vaerã mbae uyemombo —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Echa'ã jocua pandepo mbɨyape güi jembɨre mbɨyape uñepɨsãacue jare uyeeya joco pe, opa ma ucaru reta yave. Jayave Jesús jemimboe reta umbatɨ jare umɨtɨnee doce canasta. ");
INSERT INTO gnwNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Jare joco pe ñugüɨnoi vae reta uecha ma yave cua mɨacañɨ Jesús uyapo vae, jei reta: —Cua cuimbae jocua Tumpa iñee umɨmbeu vae etei co. Echa'ã Tumpa iñee pe uyecuatía oĩ outa co ɨvɨ pe —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jare Jesús uicuaa yugüeruta uipɨsɨ uyapo vaerã juvicha guasurã, yepe tẽi jae uipota'ã. Jayave oo chugüi reta ɨvɨtu guasu re. Jaeño oo. ");
INSERT INTO gnwNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Jare pɨ̃tu ave ma yave, Jesús jemimboe reta ugüeyɨ yugüɨraa ɨ guasu pe. ");
INSERT INTO gnwNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Joco pe uyupi chalana pe jare umbɨpɨ uasa ɨ guasu rupi Capernaum cotɨ. Pɨ̃tumimbi ma oĩ, jare Jesús ndei ou ye jae reta ñugüɨnoi vae pe. ");
INSERT INTO gnwNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Jayave tanta uyepeyu ɨvɨtu jare ɨ uyembɨaparoaroa. ");
INSERT INTO gnwNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Uruguata reta ma yave chalana penti legua rupi ndipo, uecha Jesús uguata ou ɨ iárambo jare ou coiño ma chalana güi. Jayave uquɨye reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ẽrei Jesús jei chupe reta: —Che co. Agüɨye pequɨye —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Jayave uyerovia reve jae reta umbuyupi Jesús chalana pe, jare jupivoiño chalana oo uvãe ɨvɨ pe uipota yugüɨraa uvãe vae pe. ");
INSERT INTO gnwNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Pɨareve pe jeta vae reta jecuaeño upɨta ɨ guasu jovaicho pe. Uecha pentiño chalana joco pe oĩ ndei Jesús jemimboe reta yugüɨraa pɨpe mbove. Jare uicuaa Jesús oo'ã chalana pe jemimboe reta ndive. ");
INSERT INTO gnwNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ẽrei ĩru chalana reta tenta guasu Tiberias güi yugüeru vae upɨta coiño tenonde yave ucaru reta vae güi. Echa'ã joco pe jae reta jou mbɨyape yandeYa umee yave yasurupai Tumpa pe. ");
INSERT INTO gnwNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Uicuaa reta ma Jesús jare jemimboe reta mbaetɨ joco pe ñugüɨnoi. Jayave uyupi reta jocua chalana reta pe jare yugüɨraa Capernaum cotɨ, Jesús ueca vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ɨ guasu uasa reta ma yave, uvãe Jesús jare jei reta chupe: —Oporomboe vae, ¿quirãi yave pa ndeyu cua pe? ");
INSERT INTO gnwNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jayave Jesús jei chupe reta: —Añete che jae peve, pe reta chereca jocua mbɨyape pemɨangapɨɨ ramoño, chereca'ã jocua mɨacañɨ pe aipota aicuaaca peve ramo —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Agüɨye peparavɨquɨ perembiurã ɨmata'ã ico peve vae reño. Ẽrei peparavɨquɨ perembiurã ameeta peve vae re. Che ayeyapo cuimbaerã vae ameeta peve perembiurã opata'ã vae. Echa'ã penoita tecove opa mbae vae. Echa'ã cheRu Tumpa uicuaaca ma peve chepuere ayapo jucuarãi —jei Jesús chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Jayave upɨrandu reta Jesús pe: —¿Mbae pa nduyapota? ¿Quirãi pa orepuere nduyapo mbaravɨquɨ Tumpa uipota nduyapo vaerã vae? —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jayave Jesús jei: —Perovia cheré. Cua co mbaravɨquɨ Tumpa uipota piyapo vaerã vae. Echa'ã jae chembou —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Jayave jei reta chupe: —¿Mbae nunga mɨacañɨ pa ndiyapota, nduecha vaerã jare ndugüɨrovia vaerã nderé? ¿Mbae nunga mbaravɨquɨ pa ndiyapota nde? —jei reta—. ");
INSERT INTO gnwNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Yandetenondegua reta jou maná ñana pe. Echa'ã Tumpa iñee pe uyecuatía oĩ: ‘Umee chupe reta jembiurã ara güi jou reta vaerã’ —jei reta chupe. ");
INSERT INTO gnwNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","—Añete che jae peve —jei Jesús—, Moisés umee'ã co jembiurã ara güi ou vae. Añave cheRu umeeta peve perembiurã añetete vae ara güi ou vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Echa'ã tembíu Tumpa añave umeeta vae jocua co jae ara güi ou vae. Jae umeeta tecove ɨvɨ pegua reta pe —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","—Carai —jei reta—, jecuaeño emee oreve cua nunga orerembiurã. ");
INSERT INTO gnwNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","—Che co jae jocua tembíu tecove umeeta vae —jei Jesús—. Ipotave cheré güɨrovia vae ndarau iyembaɨ, jare ipotave cheré güɨrovia vae ndarau iúe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ẽrei che jae ma peve cuarãi: Perovia'ã, yepe tẽi cherecha ma. ");
INSERT INTO gnwNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Opaete cheRu umee cheve vae reta güɨroviata co cheré —jei—, jare ipotave cheré güɨrovia vae ndarau amombo. ");
INSERT INTO gnwNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Echa'ã agüeyɨ ayu ara güi ayapo vaerã chembou vae jei vae. Ayu'ã che jae vaeño ayapo vaerã —jei Jesús—. ");
INSERT INTO gnwNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ndarau amɨcañɨ penti ave opaete cheRu umee ma cheve vae reta güi. Echa'ã ambɨjecove yeta aru umanocue vae reta ipɨte güi ara taɨcuegua vae pe. Cua uipota chembou vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ipotave cherecha vae güɨnoita tecove opa mbae vae cheré güɨrovia yave, jare che ambɨjecove yeta aru umanocue vae reta ipɨte güi ara taɨcuegua vae pe. Cua uipota cheRu —jei Jesús. ");
INSERT INTO gnwNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Jayave judío reta iñeenguru Jesús re. Echa'ã Jesús jei ma: “Che co jae tembíu ara güi ou vae.” ");
INSERT INTO gnwNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Jare judío reta jei: —Cua co jae Jesús. Jae co José taɨ. Yaicuaa catu co tu jare ichɨ. ¿Quirãi pa ipuere jei: ‘Agüeyɨ ayu ara güi’? —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jayave Jesús jei chupe reta: —Agüɨye piñeenguru checotɨ. ");
INSERT INTO gnwNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","CheRu chembou —jei—. CheRu güɨroviaca cheré vaeño ipuere güɨrovia cheré. Jare che ambɨjecove yeta aru umanocue vae reta ipɨte güi ara taɨcuegua vae pe —jei chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Tumpa iñee aracae umɨmbeu vae uicuatía cuarãi: ‘Jare Tumpa omboeta opaete vae.’ Jucuarãi uicuatía —jei—. Ipotave uyapɨsaca Tumpa re jare uyemboe Tumpa jei chupe vae re vae outa checotɨ —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Mbaetɨ quía uecha cheRu, jaeño che ayu Tumpa güi vae. Che aecha ma co cheRu —jei Jesús—. ");
INSERT INTO gnwNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Añete che jae peve, cheré güɨrovia vae güɨnoi tecove opa mbae vae. ");
INSERT INTO gnwNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Che co jae jocua tembíu tecove umee vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Petenondegua reta jou jocua maná ñana pe jare umano reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Che co jae tembíu ara güi ou vae. Cua tembíu jou vae ndarau umano —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Che co jae tembíu tecove umee vae. Che agüeyɨ ayu ara güi. Ipotave cua tembíu jou vae güɨnoita tecove opa mbae vae —jei Jesús chupe reta—. Jare jocua tembíu ameeta vae cherete co. Ameeta cherete ɨvɨ pegua reta güɨnoi vaerã tecove —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Jayave judío reta uyeaca uyupii. —¿Quirãita ra ipuere cua cuimbae umee yandeve jete yau vaerã? —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","—Añete che jae peve —jei Jesús chupe reta—, peu'ã yave cherete jare cherugüɨ, ndarau tecove opa mbae vae penoi. Che co jae cuimbaerã uyeyapo vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Cherete jare cherugüɨ jou vae güɨnoi tecove opa mbae vae, jare ambɨjecove yeta aru umanocue vae reta ipɨte güi ara taɨcuegua vae pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Echa'ã cherete jare cherugüɨ tembíu añetete vae co —jei Jesús—. ");
INSERT INTO gnwNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Cherete jare cherugüɨ jou vae ico che ndive jare che aico jae ndive —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","CheRu güɨnoi tecove opa mbae vae jare jae chembou, jare che anoi tecove opa mbae vae cheRu güi. Jae ramiño vi jocua cherete jou vae güɨnoita tecove opa mbae vae chegüi —jei chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Che co jae tembíu ara güi ou vae. Cua tembíu jae'ã co jocua tembíu petenondegua reta jou vae rami. Echa'ã jae reta umano. Ẽrei ipotave cua tembíu jou vae güɨnoita tecove opa mbae vae —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jucuarãi jei Jesús judío reta itupao pe, Capernaum pe oporomboe oĩ yave. ");
INSERT INTO gnwNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Cua uyandu reta yave, jeta Jesús jemimboe reta jei uyupe: —Icavi'ã co cua jei vae. Agüɨye yayapɨsaca cua nunga ñee re —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jesús uicuaa jemimboe reta iñeenguru co icotɨ. Jayave jei chupe reta: —¿Maera pa piñeenguru checotɨ cua re? ");
INSERT INTO gnwNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Mbae pa piyapota cherecha yave ayupi aa tenonde aico vae pe? Che co jae cuimbaerã uyeyapo vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Jaeño Espíritu Santo ipuere umee tecove opa mbae vae. Yanderete ipuere'ã umee yandeve cua nunga tecove. Cua amɨmbeu ma peve vae ɨvɨ pegua'ã co. Jae co tecove opa mbae vae pegua —jei Jesús—. ");
INSERT INTO gnwNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ẽrei amocue pe reta perovia'ã cheré —jei. Echa'ã Jesús uicuaa iyɨpɨ güive quía reta güɨrovia'ã jese jare quía umeeta jovaicho reta pe. ");
INSERT INTO gnwNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Jayave jei chupe reta: —Jáeramo amɨmbeu ma peve quirãi cheRu güɨroviaca cheré vaeño ipuere güɨrovia cheré —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Cua jaɨcue rupi jeta jemimboe reta uñatima ye Jesús güi, jare uguata'ã ma jae ndive. ");
INSERT INTO gnwNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Jayave Jesús upɨrandu jocua doce vae reta pe: —¿Peota pa chegüi pe reta vi? ");
INSERT INTO gnwNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","—¿Quía re pa ndoota, oreYa? —jei Simón Pedro chupe—. Nde co nemɨmbeu oreve tecove opa mbae vae regua. ");
INSERT INTO gnwNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Jare ndugüɨrovia ma nderé jare nduicuaa ma nde co jae Tumpa oñono tee iyupeguarã vae —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jayave Jesús jei: —Che puparavo. Pe co jae doce vae reta. Ẽrei ime penti pepɨte pe oĩ vae uyeyocui aña guasu pe —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Cuarãi uyemɨngueta Judas re. Judas co jae Simón Iscariote taɨ. Echa'ã Jesús uiparavo doce jare jae reta güi penti co jae Judas. Judas umeeta Jesús jovaicho reta pe. ");
INSERT INTO gnwNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Cua jaɨcue rupi Jesús oo tenta guasu Galilea pegua reta pe. Oo'ã Judea pe. Echa'ã judío reta uipota uyuca. ");
INSERT INTO gnwNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Jare outa ma uvãe judío reta ifiesta Tabernáculos jee vae iara reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Jayave Jesús tɨvɨ reta jei chupe: —Ecua cua güi Judea pe, nderemimboe reta uecha vaerã mbaravɨquɨ ndiyapo vae. ");
INSERT INTO gnwNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Echa'ã ime yave quía uipota ĩru vae reta uicuaa cavi vaerã jesegua vae, uyapo vɨari'ã iparavɨquɨ. Ndiyapo co cua mbaravɨquɨ. Jáeramo iyapo opaete vae jovaque —jei reta chupe. ");
INSERT INTO gnwNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Echa'ã tɨvɨ reta vi güɨrovia'ã jese. ");
INSERT INTO gnwNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jayave Jesús jei chupe reta: —Ndei uvãe jucuarãi ayapo vaerã, ẽrei pe reta pepuere peo pequɨrẽɨ vae rupi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ɨvɨ pegua reta ipuere'ã pemɨtarẽɨ, ẽrei ɨvɨ pegua reta chemɨtarẽɨ. Echa'ã che amɨmbeu chupe reta icavi mbae vae co jae uyapo reta vae —jei Jesús—. ");
INSERT INTO gnwNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Pe reta pecua fiesta pe. Che ndei rani aa cua fiesta pe. Echa'ã ndei uvãe che aa joco pe vaerã —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Jucuarãi jei chupe reta Jesús, jare upɨta Galilea pe. ");
INSERT INTO gnwNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Cua jaɨcue rupi tɨvɨ reta yugüɨraa ma yave fiesta pe, Jesús oo vi. Oo'ã jeta vae jupíe agüɨye vaerã uecha reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Jare judío reta ueca ñugüɨnoi Jesús fiesta pe. —¿Quíape pa ime oĩ? —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Jare joco pe ñugüɨnoi vae reta uyeaca uyupii Jesús re. Amocue vae jei: —Cuimbae jecocavi vae co jae. Ĩru vae reta jei: —Jecocavi'ã co. Upurumbɨtavɨ vae co. ");
INSERT INTO gnwNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ẽrei opaete vae uquɨye judío reta güi. Jáeramo uyemɨngueta vɨariño reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Fiesta mbɨte ma yave, Jesús oo Tumpa jo pe umbɨpɨ oporomboe. ");
INSERT INTO gnwNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Jare judío reta ipɨacañɨ. —¿Quirãi ra cua cuimbae jeta uicuaa mbaembae re uyemboe mbae reve? —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jayave Jesús jei chupe reta: —Cheporomboe chembaeño'ã co. Jae co chembou vae iporomboe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ipotave Tumpa jei vae uipota uyapo vae uicuaata cheporomboe Tumpa iporomboe co. Uicuaata chiñeeiño'ã co —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ipotave vae jae iñee reño oporomboe yave, jae uipota ĩru vae reta pe uyembutuichaca vaerãño. Ẽrei quía ueca umbutuicha vaerã ombou vae, jae oporomboe añete vae re. Iyapu'ã co —jei Jesús—. ");
INSERT INTO gnwNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moisés umee peve mboroyocui. Ẽrei mbaetɨ penti ave pe reta piyapo mboroyocui pe uyecuatía oĩ vae rupi —jei—. ¿Maera pa pipota cheyuca? —jei chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Jayave judío reta jei: —Aña oya ma nderé. ¿Quía pa uipota ndeyuca? —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","—Ayapo ma penti mbaravɨquɨ —jei Jesús—, jare opaete pe reta pepɨacañɨ jese. ");
INSERT INTO gnwNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moisés umɨmbeu peve piñemɨcircuncidaca vaerã. Ẽrei uyembɨpɨ'ã Moisés umɨmbeu yave. Echa'ã Moisés itenondegua reta uyapo jucuarãi. Jare pe reta pepurumɨcircuncidaca mbutuu ara pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Che ambɨgüera ma penti cuimbae mbutuu ara pe. Opaete jete ucuera cavi ma. ¿Maera pa pepochɨ cheve cua jeco pegua? Echa'ã pe reta pepurumɨcircuncidaca mbutuu ara pe mboroyocui Moisés umɨmbeu peve vae pipota'ã piyavɨ ramo —jei Jesús—. ");
INSERT INTO gnwNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Agüɨye pepuruãa peecha vae rupiño. Pepuruãa cavi jupi vae rupi —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Jáeramo amocue Jerusalén pegua reta jei: —¿Jae'ã ra cua judío reta uipota uyuca vae? ");
INSERT INTO gnwNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Mase, co oĩ cua pe, jare uyemɨngueta oĩ opaete vae pe. Ẽrei mbaetɨ quía mbae jei chupe. Aramoi yanderuvicha reta uicuaa ma jae co Cristo, Tumpa ombou vae —jei reta—. ");
INSERT INTO gnwNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ẽrei yaicuaa quetɨ güi ou cua cuimbae. Echa'ã Cristo uyecuaa yave, ndarau quía uicuaa quetɨ güi ou —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jáeramo Jesús oporomboe oĩ rambueve Tumpa jo pe, iñeeãta reve jei: —Pe reta checuaa co, jare picuaa co quetɨ güi ayu vae. Ẽrei ayu'ã che aipota ayu rupiño. Echa'ã chembou vae imiari añete vae re, jare pe reta picuaa'ã chembou vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ẽrei che aicuaa. Echa'ã ayu jae oĩ vae güi. Jae chembou —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Jáeramo judío reta uipota tẽi uipɨsɨ. Ẽrei uipɨsɨ'ã quía. Echa'ã ndei uvãe uyepɨsɨ vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Jare jeta joco pe ñugüɨnoi vae güɨrovia jese. Echa'ã jei reta: —Cristo ou yave, ¿uyapota ra jeta ete mɨacañɨ cua cuimbae uyapo vae güi? ");
INSERT INTO gnwNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Jare fariseo reta uyandu jeta vae iñeenguru ñugüɨnoi Jesús re. Jayave sacerdote reta itenondegua reta jare fariseo reta ombou jembiocui reta uipɨsɨ vaerã Jesús. ");
INSERT INTO gnwNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jayave Jesús jei: —Aĩta pe reta ndive michi peguaño. Jayave aata chembou vae pe. ");
INSERT INTO gnwNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Cherecata co, ẽrei ndarau chevãe. Ndarau peo che aĩta vae pe —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Jayave judío reta jei uyupe: —¿Quetɨ ra oota cua cuimbae agüɨye vaerã ñavãe chupe? Oota ndipo judío reta judío mbae vae reta ipɨte rupi uñemɨai vae pe. Omboeta ndipo judío mbae vae reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Mbae ra uipota jei, jei yave cuarãi: ‘Cherecata co, ẽrei ndarau chevãe. Ndarau peo che aĩta vae pe?’ —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Jocua ara fiesta opata ma yave icavi ete opaete ĩru fiesta iara güi. Jayave Jesús uyemboɨ jare iñeeãta reve jei: —Ime yave quía iúe vae, tou checotɨ ɨ tou —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Cheré güɨrovia vae güi usɨrɨta jeta ɨ tecove umee vae. Jucuarãi Tumpa iñee pe uyecuatía oĩ —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jucuarãi uyemɨngueta Jesús Espíritu Santo re. Uipota jei umeeta Espíritu Santo güɨrovia jese vae reta pe. Echa'ã ndei umee Espíritu Santo. Echa'ã Jesús ndei oo ye ara pe. ");
INSERT INTO gnwNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Cua uyandu yave, amocue joco pe ñugüɨnoi vae jei: —Cua cuimbae jocua Tumpa iñee umɨmbeu vae etei co. ");
INSERT INTO gnwNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ĩru vae reta jei: —Cua cuimbae Cristo, Tumpa ombou vae co. Ẽrei amocue vae jei: —¿Galilea pegua ra Cristo? ");
INSERT INTO gnwNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Echa'ã Tumpa iñee pe uyecuatía oĩ Cristo co jae David iñemoñaa reta pegua jare Belén pegua co. Echa'ã David joco pegua vi co —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Jesús jei chupe reta vae jeco pegua, joco pe ñugüɨnoi vae reta uyeaca uyupii. ");
INSERT INTO gnwNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Jare amocue vae uipota tẽi uipɨsɨ Jesús, ẽrei uipɨsɨ'ã quía. ");
INSERT INTO gnwNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Jayave uyeyocui vae sacerdote reta itenondegua reta jare fariseo reta ombou vae reta yugüɨraa ye jucuarãiño chupe reta. Jayave sacerdote reta itenondegua reta jare fariseo reta jei jembiocui reta pe: —¿Maera pa peru'ã? ");
INSERT INTO gnwNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Jembiocui reta jei: —Echa'ã mbaetɨ etei quía uyemɨngueta jocua cuimbae uyemɨngueta rami. ");
INSERT INTO gnwNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Jayave fariseo reta jei: —¿Piyembɨtavɨca ma pa pe reta vi? ");
INSERT INTO gnwNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Güɨrovia ma ra jese mburuvicha reta jare fariseo reta? Güɨrovia'ã penti ave —jei reta—. ");
INSERT INTO gnwNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ẽrei cua jeta vae uicuaa'ã mboroyocui pe uyecuatía oĩ vae. Tumpa uiporaracata co chupe reta —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Jayave penti jae reta ipɨte pe oĩ vae jei ĩru reta pe - jae co Nicodemo jee vae - tenonde yave jae oo opou Jesús pe pɨ̃tu yave: ");
INSERT INTO gnwNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Mboroyocui pe uyecuatía oĩ vae rupi yandepuere'ã ñaãa ipotave vae ndei yayapɨsaca jese mbove. Echa'ã yayapɨsaca jese yave, yaicuaa mbae uyapo vae —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ĩru reta jei chupe: —¿Nde vi ra Galilea pegua? Ndeeca yave, ndicuaata mbaetɨ co penti ave Tumpa iñee umɨmbeu vae Galilea pegua —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Jayave opaete vae yugüɨraa ye jenta jenta pe. ");
INSERT INTO gnwNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ẽrei Jesús oo ɨvɨtu guasu Olivos jee vae pe. ");
INSERT INTO gnwNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Pɨareve pe neimbove asɨ Jesús oo ye Tumpa jo pe. Jayave jeta vae yugüeru jae oĩ vae pe, jare jae uguapɨ omboe reta oĩ. ");
INSERT INTO gnwNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Jayave mboroyocui re oporomboe vae reta jare fariseo reta güeru penti cuña. Uipocou reta cuña menda re uyuvanga oĩ yave. Jayave oñono reta joco pe ñugüɨnoi vae reta ipɨte pe. ");
INSERT INTO gnwNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","—Oporomboe vae —jei reta Jesús pe—, cua cuña nduipocou menda re uyuvanga oĩ yave. ");
INSERT INTO gnwNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mboroyocui pe Moisés yandeocui yayuca vaerã cua nunga cuña reta ita pe. ¿Mbae pa ndere nde cua re? —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Cua jei reta uicuaa vaerã mbae ra jeita Jesús. Echa'ã uipota umbɨjeco. Jayave Jesús ipe jare uicuatía mbae ɨvɨ re ipoãca pe. ");
INSERT INTO gnwNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Jecuaecuae upɨrandu reta chupe cua re. Jayave Jesús uyemboɨ jare jei chupe reta: —Mbaetɨ mbaeyoa güɨnoi pepɨte pe vae rani tuyapi ita pe. ");
INSERT INTO gnwNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Jayave ipe ye jare uicuatía ye mbae ɨvɨ re ipoãca pe. ");
INSERT INTO gnwNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ẽrei cua uyandu reta yave, ipɨa umbɨjeco jeco re jare yugüɨraa joco güi penti penti rupi. Tenonde yugüɨraa indechi vae reta. Jayave opaete vae yugüɨraa. Jaeño Jesús upɨta joco pe cuña jae jovai uyemboɨ oĩ vae ndive. ");
INSERT INTO gnwNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jayave Jesús uyemboɨ ye umae jese, jare jei: —¿Jama pa jocua cuimbae reta, cuña? ¿Mbaetɨ ma pa quía nembɨjeco? ");
INSERT INTO gnwNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","—Mbaetɨ quía, carai —jei cuña chupe. Jayave Jesús jei: —Che numbɨjeco'ã vi. Ecua, agüɨye ye iyapo jocua mbaeyoa —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Cua jaɨcue rupi Jesús jei yatɨ vae reta pe: —Che co jae penti tembipe rami. Ayu co ɨvɨ pegua reta uecha cavi vaerã. Ico che ndive vae ndarau uguata pɨ̃tumimbi pe. Echa'ã güɨnoita tecove ipuere vaerã uecha cavi —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Jayave fariseo reta jei Jesús pe: —Nemɨmbeu oreve vae ndarau ndugüɨrovia. Echa'ã nde nemiari ndiyee —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","—Amɨmbeu ma peve vae pepuere perovia, yepe tẽi chemiari peve chiyee —jei Jesús—. Echa'ã che aicuaa co quetɨ güi ayu jare quetɨ aa vae. Ẽrei pe reta picuaa'ã quetɨ güi ayu jare quetɨ aa vae. ");
INSERT INTO gnwNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Pe reta pepuruãa opaete ɨvɨ pegua reta upuruãa rami. Che aãa'ã quía —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ẽrei apuruãa yave, apuruãa añete vae rupi. Echa'ã cheRu chembou. Jare che jare cheRu nupuruãa - cheiño'ã co —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Peporoyocui pe uyecuatía oĩ cuarãi: ‘Mocui jei vae oyovaque yave, peroviata co.’ Jucuarãi uyecuatía oĩ —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Chemiari peve chiyee jare cheRu chemɨmbeu peve - jae co chembou —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Jayave judío reta jei: —¿Quiape pa oĩ ndeRu? —Pe reta checuaa'ã jare picuaa'ã cheRu —jei Jesús chupe reta—. Checuaa yave mona, cheRu picuaata tẽi co vi —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Cua jei Jesús Tumpa jo pe corepoti Tumpa pegua jɨru reta ñugüɨnoi vae pe. Echa'ã joco pe oporomboe. Ẽrei uipɨsɨ'ã quía. Echa'ã ndei uvãe uyepɨsɨ vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jare Jesús jei ye chupe reta: —Aata ma cua güi. Pe reta cherecata co, ẽrei pemanota pembaeyoa uyembai mbae reve. Pe reta ndarau pepuere peo che aata vae pe —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","—¿Uyeyucata ra? —jei judío reta—. Echa'ã jei ma: ‘Pe reta ndarau pepuere peo che aata vae pe.’ ");
INSERT INTO gnwNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jayave Jesús jei: —Pe reta ɨvɨ pegua co, ẽrei che ara pegua co. Pe reta ɨvɨ pegua co, ẽrei che ɨvɨ pegua'ã co. ");
INSERT INTO gnwNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Amɨmbeu ma peve pemanota pembaeyoa uyembai mbae reve. Echa'ã pemanota co pembaeyoa uyembai mbae reve, perovia'ã yave che co jae vae —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Jayave jei reta Jesús pe: —¿Quía pa co nde? —Jocua tenonde güive amɨmbeu ma peve vae —jei Jesús—. ");
INSERT INTO gnwNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Jeta mbaembae re chepuere chemiari peré jare jeta mbae re chepuere puãa. Ẽrei chembou vae imiari añete vae re, jare amɨmbeu ɨvɨ pegua reta pe chembou vae umɨmbeu cheve vae —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Jae reta uicuaa'ã Jesús imiari chupe reta Tu ara pe oĩ vae regua. ");
INSERT INTO gnwNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Jayave Jesús jei: —Pe reta chereupi ma curusu re yave - che ayeyapo cuimbaerã vae - picuaata che co jae. Ayapo'ã mbae che aipota ayapo rupiño. CheRu umɨmbeu cheve vae rupiño chemiari —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Jare chembou vae ico che ndive. Chereya'ã cheiño aico vaerã. Echa'ã jecuaeño ayapo jae uipota vae rupi —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Jare Jesús imiari yave, jeta vae güɨrovia jese. ");
INSERT INTO gnwNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Jayave Jesús jei jocua judío güɨrovia jese vae reta pe: —Jecuaeño piyapo yave che jae peve piyapo vaerã vae, picota co cheremimboe retarã añetete vae. ");
INSERT INTO gnwNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Jare picuaata añete vae, jare añete vae peyorata co —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Judío reta jei chupe: —Abraham iñemoñaa reta co ore. Mbaetɨ etei nduyeyocui quía pe. ¿Maera pa ndere nduyeyorata co? —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","—Añete che jae peve —jei Jesús—, iyoa vae uyeyocui oĩ mbaeyoa pe. ");
INSERT INTO gnwNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Uyeyocui vae ipuere'ã ico ete tenta pe. Ẽrei tenta iya taɨ jecuaeño ico tenta pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Che co jae Tumpa Taɨ. Che poyora yave mbaeyoa güi, añetete piyeyora ma co —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Che aicuaa Abraham iñemoñaa reta co pe reta. Ẽrei pipota cheyuca, pipota'ã piyapo che jae peve piyapo vaerã vae ramo —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Chemiari peve cheRu ndive aico yave aecha vae re, jare pe reta piyapo peru umɨmbeu peve piyapo vaerã vae rupi —jei Jesús. ");
INSERT INTO gnwNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","—Abraham co jae oreru —jei reta. —Pe reta Abraham taɨ reta añetete vae yave mona —jei Jesús—, piyapota tẽi co Abraham uyapo vae rami. ");
INSERT INTO gnwNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ẽrei añave pipota cheyuca, yepe tẽi amɨmbeu ma peve añete vae. Jae co Tumpa umɨmbeu cheve vae. Cuarãi'ã uyapo Abraham —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Pe reta piyapo peĩ peru iparavɨquɨ —jei Jesús chupe reta. —Oremɨñemoña'ã co aguasa pe oreru reta —jei reta—. Tumpaño co jae oreRu. ");
INSERT INTO gnwNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jayave Jesús jei chupe reta: —Tumpa co jae peRu yave mona, pe reta cherauta tẽi co. Echa'ã che ayu Tumpa güi. Che Tumpa pegua co. Che aipota ramoño'ã co ayu. Jae co chembou —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Maera pa picuaa'ã amɨmbeu peve vae? Pipota'ã piyapɨsaca chiñee re. Jáeramo picuaa'ã —jei Jesús—. ");
INSERT INTO gnwNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Aña guasu co jae peru, jare pe reta pipota piyapo peru uipota vae rupi. Peru jecuaeño upuruyuca ico, jare uyapo'ã etei añete vae rupi. Echa'ã añetete vae pegua'ã co. Jae co aña guasu. Jáeramo jecuaeño iyapu. Echa'ã jae co iyapu vae jare omboe ɨvɨ pegua reta iyapu vaerã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ẽrei pe reta chererovia'ã, añete vae amɨmbeu peve ramo —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Mbaetɨ penti yepe pepuere pere cheve: ‘Ndeyoa co.’ Echa'ã che amɨmbeu peve añete vae. ¿Maera pa chererovia'ã? —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Tumpa taɨ reta uyapɨsaca Tumpa iñee re. Pe reta Tumpa taɨ reta'ã co. Jáeramo piyapɨsaca'ã jese —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Jayave judío reta jei: —Ndoe ma nde co jae penti Samaria pegua, jare aña oya ma nderé. Añete co cua ndoe vae —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","—Oya'ã co cheré aña —jei Jesús—. Che aipɨu aĩ cheRu, ẽrei pe reta chererɨ̃ro. ");
INSERT INTO gnwNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ẽrei aipota'ã ɨvɨ pegua reta chembutuicha vaerã. Ime co quía uipota chembutuichaca vae. Jae upuruãata co —jei Jesús—. ");
INSERT INTO gnwNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Añete che jae peve, uyapo che jae chupe uyapo vaerã vae ndarau umano —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Jayave judío reta jei Jesús pe: —Añave nduicuaa ma aña oya co nderé. Abraham jare Tumpa iñee aracae umɨmbeu vae reta umano. Ẽrei nde ndere: ‘Uyapo che jae chupe uyapo vaerã vae ndarau umano.’ ");
INSERT INTO gnwNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Tuicha ete pa nembaepuere yandetenondegua Abraham imbaepuere güi? Echa'ã Abraham umano. Jae ramiño vi Tumpa iñee aracae umɨmbeu vae reta umano. ¿Quía pa co nde? ¿Mbae pa ndere ndiyee? —jei reta Jesús pe. ");
INSERT INTO gnwNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","—Ayembutuicha'ã co —jei Jesús—. Echa'ã jucuarãi ayapo yave, jocua nunga yembutuicha mbae'ã co. Ẽrei cheRu chembutuichaca, jare pe reta pere Tumpa co jae peRu —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ẽrei pe reta picuaa'ã Tumpa. Che aicuaa co. Che jae yave: ‘Aicuaa'ã’, cheaputa tẽi co pe reta peapu rami. Ẽrei aicuaa co, jare ayapo jei cheve ayapo vaerã vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Petenondegua Abraham uyerovia cherechata ramo. Cherecha co jare uyerovia —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Jayave judío reta jei chupe: —Nde ndei nenoi cincuenta año. ¿Quirãi pa ndepuere ndere ndeecha co Abraham? —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","—Añete che jae peve —jei Jesús—, ndei Abraham ico mbove, che imeño mai aico —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Jayave judío reta omonoo ita reta uyapi vaerã tẽi Jesús. Ẽrei Jesús uasa jae reta ipɨte rupi oẽ Tumpa jo güi, jare jae reta uecha'ã ma. ");
INSERT INTO gnwNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jare Jesús uasa oo yave, uecha penti cuimbae jesa mbae vae. Cua cuimbae jucuarãi ico ichɨ güi oa güive. ");
INSERT INTO gnwNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Jayave Jesús jemimboe reta upɨrandu Jesús pe: —Oporomboe vae, ¿quía pa iyoa, ichɨ güi oa yave jesa mbae vaerã? ¿Iyoa pa jae etei? ¿Iyoa pa tu jare ichɨ? —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","—Jae imbaeyoa jeco pegua'ã co jare tu jare ichɨ imbaeyoa jeco pegua'ã co cuarãi oĩ —jei Jesús—. Cuarãi oĩ Tumpa imbaepuere uyecuaa vaerã ucuera yave —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Icavi co ayapo vaerã ara rupi chembou vae iparavɨquɨ. Echa'ã ara rupi ñanoi tembipe. Ẽrei outa pɨ̃tu, jare pɨ̃tu yave mbaetɨ quía ipuere uparavɨquɨ —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Cua ɨvɨ pe aico rambueve, che co jae penti tembipe rami. Ayu co ɨvɨ pegua reta uecha cavi vaerã —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Cua jei ma yave, undɨvɨ ɨvɨ re jare jocua güi uyapo tuñuu. Jayave oñono tuñuu cuimbae jesa re. ");
INSERT INTO gnwNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Jayave jei chupe: —Ecua iyoe nderesa ɨ Siloé pe. (Cua Siloé uipota jei: “Uyemondo”.) Jayave cuimbae oo oyoe jesa jare ou ye yave, umae ma. ");
INSERT INTO gnwNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Jayave cuimbae jenta iyɨpɨ rupigua reta jare ĩru vae reta tenonde uecha uyerure oĩ corepoti re vae jei: —¿Jae'ã ra cua uguapɨ uyerure corepoti re vae? ");
INSERT INTO gnwNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Amocue vae jei: —Jae co. Ĩru vae reta jei: —Jae'ã co. Ẽrei jae echa ete vae co. Ẽrei cuimbae jei: —Che co jae. ");
INSERT INTO gnwNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Jayave jei reta chupe: —¿Quirãi pa añave ndepuere nemae? ");
INSERT INTO gnwNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","—Jocua cuimbae Jesús jee vae uyapo tuñuu oñono cheresa re —jei cuimbae chupe reta—. Jayave jei cheve: ‘Ecua Siloé pe iyoe nderesa’ —jei cheve, jei—. Jáeramo aa ayoe cheresa, jare amae ma —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","—¿Quiape pa ime oĩ? —jei reta. —Aicuaa'ã —jei cuimbae chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Jayave jae reta güɨraa fariseo ñugüɨnoi vae pe cuimbae tenonde yave jesa mbae ico vae. ");
INSERT INTO gnwNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Jare jocua ara mbutuu ara co. Echa'ã jocua ara Jesús uyapo tuñuu umɨmae vaerã cuimbae. ");
INSERT INTO gnwNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Jayave fariseo reta vi upɨrandu cuimbae pe quirãi ra ipuere umae. —Oñono tuñuu cheresa re —jei cuimbae—. Jayave ayoe cheresa, jare amae voi —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Amocue fariseo reta jei: —Tumpa pegua'ã co cua cuimbae. Echa'ã uyapo mbutuu ara pe mboroyocui pe jei agüɨye yayapo vaerã vae. Ẽrei ĩru fariseo reta jei: —¿Quirãi ra ipuere cuimbae iyoa vae uyapo cua nunga mɨacañɨ? Jare uyeaca reta uyupii. ");
INSERT INTO gnwNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Jayave jei reta ye cuimbae tenonde yave jesa mbae ico vae pe: —¿Mbae pa ndere nde jocua nemɨmae vae re? —Jae co penti Tumpa iñee umɨmbeu vae —jei chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Judío reta güɨrovia'ã cua cuimbae tenonde yave jesa mbae ico vae co. Güɨrovia'ã vi jaeramo co umae. Jáeramo uenica cuimbae umae ma vae tu jare ichɨ. ");
INSERT INTO gnwNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Jayave upɨrandu reta tu jare ichɨ pe: —¿Jae pa co cua nderaɨ jesa mbae co oa pere chupe vae? ¿Quirãi pa añave umae? ");
INSERT INTO gnwNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","—Aicuaa jae co cheraɨ jesa mbae oa ichɨ güi vae —jei chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ẽrei nduicuaa'ã quirãi ra añave umae. Nduicuaa'ã vi quía ra umɨmae. Pepɨrandu chupe. Echa'ã ucuacuaa ma co jae. Jae etei ipuere umɨmbeu peve —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Jucuarãi jei cuimbae tu jare ichɨ, uquɨye judío reta güi ramo. Echa'ã judío reta jei ma uyupe: “Jocua Jesús co jae Cristo jei vae tuyemombo yandetupao güi.” ");
INSERT INTO gnwNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Jáeramo tu jare ichɨ jei: “Ucuacuaa ma co jae. Pepɨrandu chupe.” ");
INSERT INTO gnwNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Jayave judío reta ueni ye cuimbae tenonde yave jesa mbae ico vae. —Emɨmbeu cavi oreve Tumpa jovaque —jei reta chupe—. Echa'ã nduicuaa cua cuimbae iyoa vae co. ");
INSERT INTO gnwNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","—Aicuaa'ã iyoa vae ra jae —jei cuimbae—. Ẽrei cua co aicuaa: Tenonde yave cheresa mbae aico vae co, añave amae. ");
INSERT INTO gnwNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Jayave upɨrandu reta ye chupe: —¿Mbae pa uyapo ndeve? ¿Quirãi pa nemɨmae? ");
INSERT INTO gnwNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","—Amɨmbeu ma peve —jei cuimbae—, ẽrei pipota'ã piyapɨsaca cheré. ¿Maera pa pipota piyandu ye? ¿Pipota pa pe reta vi piyeyapo jemimboe retarã? —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Jayave judío reta uñeengata cuimbae pe. —Nde co jae jemimboe —jei reta—. Ore co jae Moisés jemimboe reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ore nduicuaa Tumpa umɨngueta co Moisés. Ẽrei nduicuaa'ã quía pegua ra cua cuimbae —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","—Cua co penti mɨacañɨ —jei cuimbae—. Pe reta picuaa'ã quía pegua ra. Ẽrei jae chemɨmae. ");
INSERT INTO gnwNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Yaicuaa Tumpa uyapɨsaca'ã iyoa vae reta re. Ẽrei ime yave quía umbɨadora Tumpa jare uyapo Tumpa jei vae, Tumpa uyapɨsaca jese —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ɨvɨ uyeyapo güive mbaetɨ etei quía ipuere umɨmae jesa mbae oa ichɨ güi vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Tumpa pegua'ã yave cua cuimbae, ipuereta'ã tẽi mbae uyapo —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Jayave judío reta jei chupe: —Nde ndea ndesɨ güi ndeyoa reve. Mbaetɨ mbae re ndepuere oremboe —jei reta. Jayave omombo reta cuimbae. ");
INSERT INTO gnwNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jare Jesús uicuaa yave judío reta omombo ma cuimbae, oo ueca. Jare oovãiti yave, jei chupe: —¿Nderovia pa cuimbaerã uyeyapo vae re? ");
INSERT INTO gnwNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","—¿Quía pa co jae, carai? —jei Jesús pe—. Emɨmbeu cheve, arovia vaerã jese. ");
INSERT INTO gnwNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","—Ndeecha ma —jei Jesús chupe—. Che ayemɨngueta aĩ nde ndive vae co jae. ");
INSERT INTO gnwNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","—CheYa, arovia ma —jei cuimbae. Jayave cuimbae uyeatɨca Jesús jovai jare umbɨadora. ");
INSERT INTO gnwNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jayave Jesús jei: —Ayu ɨvɨ pe ambɨyao vaerã uyugüi ɨvɨ pegua reta. Ayu ipuere mbae umae vae reta umae vaerã, jare ipuere umae vae reta agüɨye vaerã umae —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Amocue fariseo reta joco pe ñugüɨnoi vae uyandu cua, jare upɨrandu chupe: —¿Ore vi pa co jae umae mbae vae reta? ");
INSERT INTO gnwNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","—Pemae'ã yave, mbaetɨta tẽi teco penoi —jei Jesús—. Ẽrei pere ma: ‘Numae.’ Jáeramo teco imeño penoi —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","—Añete che jae peve —jei Jesús—, imonda vae uique'ã onque rupi ovecha-rocai pe. Uique icotɨ'ã rupi. Echa'ã uipota oñomi güɨraa ambɨe vae iovecha reta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ẽrei ovecha iyandarecoa uique onque rupi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Jare ovecha iyandarecoa uipota uique yave, onque jãroa uipea chupe. Jare ovecha reta uyandu iyandarecoa iñee. Echa'ã iyandarecoa ueni ovecha reta jee rupi jare güɨraa ovecha-rocai güi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Jare güɨraa yave opaete imbae reta ovecha-rocai güi, jae oo tenonde jare ovecha reta yugüɨraa jaɨcue. Echa'ã uicuaa iñee —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ndarau yugüɨraa cuimbae uicuaa mbae vae jaɨcue. Osita chugüi. Echa'ã uicuaa'ã iñee —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Cua ñee umɨjaanga vae pe Jesús omboe reta tẽi, ẽrei jae reta uicuaa'ã mbae re ra umɨjaanga cua jei chupe reta vae. ");
INSERT INTO gnwNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Jayave Jesús jei: —Añete che jae peve, che co jae ovecha-rocai jonque rami. ");
INSERT INTO gnwNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Amocue vae yugüeru ndei ayu mbove. Ẽrei ovecha reta uyapo'ã jocua reta jei vae. Echa'ã jocua reta imonda vae reta co. Jae reta uipota güɨraa ambɨe vae iovecha reta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Che co jae onque rami. Che rupi ovecha-rocai pe uique vae uyembɨasacata co. Uiqueta jare oẽta jare uvãeta mbae jou vaerã —jei Jesús—. ");
INSERT INTO gnwNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Imonda vae ou güɨraa vaerã ambɨe vae iovecha reta. Ou uyuca vaerã ovecha reta. Che ayu ɨvɨ pegua reta güɨnoi vaerã tecove opa mbae vae, jare jocua tecove güɨnoi yave tuicha uyeroviata —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Che co jae ovecha reta iyandarecoa icavi vae rami. Echa'ã ovecha reta iyandarecoa icavi vae umano ovecha reta uepɨ vaerã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Jepɨ re ovecha reta re uyandareco vae uecha yave yaguapɨ̃ta ou, ueya ovecha reta jare osi. Echa'ã jae'a co ovecha reta iyandarecoa añetete vae, jare ovecha reta imbae'ã. Jayave yaguapɨ̃ta ou uipɨsɨ amocue ovecha reta, jare ĩru ovecha reta opa uñemɨai. ");
INSERT INTO gnwNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Jocua cuimbae osi jepɨ reño uyandareco ovecha reta re ramo. Echa'ã ipɨatɨtɨ'ã ovecha reta uiporara yave —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Che co jae ovecha reta iyandarecoa icavi vae rami. Aicuaa cheovecha reta jare cheovecha reta checuaa —jei Jesús—. ");
INSERT INTO gnwNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Jucuarãi cheRu checuaa jare che aicuaa cheRu. Jare che amanota ovecha reta aepɨ vaerã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Jare ime anoi ĩru ovecha reta. Jae reta cua pegua'ã co. Jae reta aruta vi. Jae reta uyapɨsacata chiñee re. Jayave imeta penti atɨ jare penti ovecha reta iyandarecoa —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","CheRu cherau amanota ramo. Amanota co, cherecove anoi ye vaerã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Mbaetɨ quía ipuere uequi chegüi cherecove. Amanota aipota ramo. Chepuere amee cherecove amano vaerã, jare chepuere anoi ye. Cuarãi cheocui cheRu —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Jesús cua jei ramo, judío reta uyeaca ye uyupii. ");
INSERT INTO gnwNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Jeta jae reta jei: —Aña oya ma jese. Uicuaa'ã ma mbae jei. ¿Maera pa piyapɨsaca jese? ");
INSERT INTO gnwNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ĩru vae reta jei: —Mbaetɨ quía aña oya jese vae ipuere uyemɨngueta jucuarãi. Ipuere'ã etei aña umɨmae jesa mbae vae reta —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Roɨ ma Jerusalén pe, jare judío reta uyapo ñugüɨnoi fiesta imandúa vaerã Tumpa jo uyepɨu ye yave. ");
INSERT INTO gnwNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jare Jesús uguata Tumpa jo pe oca Salomón jee vae rupi. ");
INSERT INTO gnwNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Jayave judío reta uyembatɨ Jesús iyɨpɨ rupi jare jei: —¿Quirãi yave pa nemɨmbeu cavita oreve, agüɨye vaerã orembopa? Nde co jae Cristo yave, emɨmbeu cavi oreve —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","—Amɨmbeu ma peve —jei Jesús—, ẽrei perovia'ã chiñee. CheRu chembou cua mbaravɨquɨ ayapo vaerã, jare cua mbaravɨquɨ uicuaaca quía co che —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Amɨmbeu ma peve pe reta cheovecha'ã co. Jáeramo perovia'ã cheré. ");
INSERT INTO gnwNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Cheovecha reta uyapɨsaca chiñee re. Aicuaa cheovecha reta, jare jae reta yugüɨraa cheraɨcue rupi —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Jare amee chupe reta tecove opa mbae vae, jare ndarau etei oo cañɨtei pe. Mbaetɨ quía ipuere upɨ̃ro chegüi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","CheRu umee ma cheve cua reta, jare cheRu imbaepuere tuicha ete opaete vae imbaepuere güi. Jare mbaetɨ quía ipuere upɨ̃ro cheRu güi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Che jare cheRu pentiño co —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Jayave judío reta omonoo ye ita reta uyapi vaerã tẽi Jesús. ");
INSERT INTO gnwNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jayave Jesús jei chupe reta: —Aechaca ma peve jeta mbaravɨquɨ icavi vae. Cua ayapo cheRu imbaepuere rupi. ¿Mbae nunga mbaravɨquɨ jeco pegua pa pipota cheapi ita pe? —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","—Penti mbaravɨquɨ icavi vae jeco pegua'ã —jei judío reta chupe—. Nde ndere icavi mbae vae Tumpa cotɨ. Jocua jeco pegua nduyapita ita pe. Echa'ã nde co jae penti cuimbaeño, ẽrei ndere ndiyupe nde co jae Tumpa vae —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jayave Jesús jei chupe reta: —Mboroyocui penoi vae pe uyecuatía oĩ quirãi Tumpa jei cuarãi: ‘Pe reta co jae tumpa reta.’ Jucuarãi jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Echa'ã Tumpa iñee ou chupe reta vae pe, jae etei umbɨjee tumpa reta. Jare Tumpa iñee pe uyecuatía oĩ vae jecuaeño co añete. ");
INSERT INTO gnwNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Jáeramo ¿maera pa pere cheve: ‘Nde ndere icavi mbae vae Tumpa cotɨ’, che jae vae jeco pegua? Echa'ã che jae: ‘Che co jae Tumpa Taɨ.’ Echa'ã Tumpa cheñono tee cua mbaravɨquɨ ayapo vaerã, jare jae chembou cua ɨvɨ pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ayapo'ã yave mona cheRu iparavɨquɨ, agüɨyeta tẽi chererovia. ");
INSERT INTO gnwNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ẽrei ayapo co cheRu iparavɨquɨ. Jáeramo yepe tẽi chererovia'ã, perovia mbaravɨquɨ ayapo vae cheRu pegua co, picuaa vaerã cheRu ico che ndive jare che aico cheRu ndive —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Jayave judío reta uipota ye tẽi uipɨsɨ Jesús, ẽrei jae oo chugüi reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Jare Jesús oo ye ɨ Jordán jovaicho pe tenonde yave Juan upurumbɨbautiza oĩ vae pe, jare joco pe upɨta. ");
INSERT INTO gnwNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Jare jeta vae reta yugüeru jae oĩ vae pe jare jei: —Juan uyapo'ã penti ave mɨacañɨ. Ẽrei opaete Juan jei cua cuimbae re vae añete co —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Jare jeta vae güɨrovia Jesús re joco pe. ");
INSERT INTO gnwNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Penti cuimbae Lázaro jee vae imbaerasɨ oĩ. Jae jare María jare Marta - jae co María tɨque - Betania pegua reta co. ");
INSERT INTO gnwNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Jocua María upɨyere mbae ipiche cavi vae yandeYa re jare umɨtini ipɨ ía pɨpe. Jocua Lázaro imbaerasɨ oĩ vae María iquɨvɨ co. ");
INSERT INTO gnwNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Jare Lázaro jindɨ reta omondo umɨmbeu vaerã Jesús pe: —OreYa, imbaerasɨ oĩ cua ndeau vae. ");
INSERT INTO gnwNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jesús cua uicuaa yave, jei: —Cua imbaerasɨ ou chupe ĩru vae reta umbɨadora vaerã Tumpa. Ou'ã jae umano vaerã. Echa'ã che co jae Tumpa Taɨ, jare ĩru vae reta chembɨadorata cua mbaerasɨ jeco pegua —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesús uau Marta jare ipɨquɨɨ jare Lázaro. ");
INSERT INTO gnwNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ẽrei uicuaa ma yave Lázaro imbaerasɨ oĩ, upɨtaño mocui ara joco pe. ");
INSERT INTO gnwNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Cua jaɨcue rupi jei jemimboe reta pe: —Yaa ye ma Judea pe. ");
INSERT INTO gnwNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","—Oporomboe vae —jei reta—, ndei co ɨma judío reta uipota tẽi ndeapi ita pe joco pe. Jáeramo ¿maera pa ndeo yeta? ");
INSERT INTO gnwNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","—Ime doce ora güɨnoi ara —jei Jesús—. Ara rupi uguata vae ndarau ipɨ güɨrocua. Echa'ã güɨnoi tembipe cua ɨvɨ pegua —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ẽrei pɨ̃tu yave uguata vae ipɨ güɨrocua. Echa'ã güɨnoi'ã tembipe. ");
INSERT INTO gnwNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Jucuarãi jei Jesús. Jayave jei: —Ñaneamigo Lázaro oque ma oĩ. Ẽrei che aata amomba —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Jemimboe reta jei: —OreYa, oque oĩ yave, ucuera yeta co. ");
INSERT INTO gnwNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ẽrei Jesús jucuarãi jei yave, uipota jei umano ma. Jae reta ipɨa pe uyemɨngueta tẽi uipota jei uputuuño oque oĩ. ");
INSERT INTO gnwNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Jayave Jesús umɨmbeu cavi chupe reta: —Lázaro umano ma. ");
INSERT INTO gnwNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Jare ayerovia joco pe aĩ'ã vae re. Cua icavita co peve. Echa'ã peroviata co. Yaa ma icotɨ —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Jayave Tomás - jae co Choguaquiri pe uyembɨjee vae - jei ĩru Jesús jemimboe reta pe: —Yaa vi yande, ñamano vaerã jae ndive. ");
INSERT INTO gnwNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Jare Jesús ou uvãe yave, amocue vae umɨmbeu chupe irundɨ ara ma co Lázaro oĩ teõgüerɨru pe. ");
INSERT INTO gnwNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania coiño oĩ Jerusalén güi. Uepitɨ penti legua seri rupi. ");
INSERT INTO gnwNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Jare jeta judío reta yugüeru ma Marta jare María ipɨ umbɨpɨacatu vaerã iquɨvɨ amɨri re. ");
INSERT INTO gnwNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Jare Marta uicuaa yave Jesús ou co uvãe, oo oovãiti. Ẽrei María upɨta tenta pe. ");
INSERT INTO gnwNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Jayave Marta jei Jesús pe: —CheYa, nde mona cua pe neĩ yave, umanota'ã tẽi chequɨvɨ. ");
INSERT INTO gnwNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Jare añave aicuaa ipotave mbae ndiyerure Tumpa pe jese vae Tumpa umeeta co ndeve —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","—Ndequɨvɨ icove yeta co ou umanocue vae reta ipɨte güi —jei Jesús chupe. ");
INSERT INTO gnwNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","—Aicuaa icove yeta co ou umanocue vae reta ipɨte güi ara taɨcuegua vae pe —jei Marta—. Echa'ã jocua ara ĩru vae reta vi icove yeta yugüeru umanocue vae reta ipɨte güi —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","—Che co amee tecove umanocue vae reta pe jare aru ye ĩru umanocue vae reta ipɨte güi —jei Jesús—. Cheré güɨrovia vae, yepe tẽi umano oĩ, icove yeta co. ");
INSERT INTO gnwNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Jare opaete icove oĩ vae cheré güɨrovia vae ndarau etei umano. ¿Nderovia pa cua? —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","—Arovia, cheYa —jei Marta—. Añave arovia nde co jae Cristo. Nde co jae Tumpa Taɨ. Echa'ã Tumpa iñee pe uyecuatía oĩ outa co Tumpa Taɨ ɨvɨ pe —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Marta cua jei ma yave, oo ueni María - jae co Marta ipɨquɨɨ. Jayave güɨraa ĩru vae reta ipɨte güi jare jei chupe: —Oporomboe vae cua pe oĩ jare uipota ndeo vaerã jae oĩ vae pe. ");
INSERT INTO gnwNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","María cua uyandu yave, ɨmambae upũa oo Jesús oĩ vae pe. ");
INSERT INTO gnwNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Marta oovãiti vae peño upɨta Jesús. Echa'ã ndei uique tenta guasu-raɨ pe. ");
INSERT INTO gnwNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Tenta pe judío uyemɨngueta ñugüɨnoi María ndive umbɨpɨacatu vaerã vae reta uecha María ɨmambae upũa oo tenta güi. Jayave yugüɨraa María jaɨcue. Echa'ã ipɨa pe uyemɨngueta tẽi jae oo teõgüerɨru oĩ vae pe uyao vaerã joco pe. ");
INSERT INTO gnwNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Jayave María oo uvãe Jesús oĩ vae pe. Uecha rupive oo uyeatɨca jae jovai jare jei: —CheYa, nde mona cua pe neĩ yave, umanota'ã tẽi chequɨvɨ. ");
INSERT INTO gnwNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jesús uecha yave María jare judío María ndive yugüeru vae reta uyao ñugüɨnoi, iañeequi jare tuicha ipɨatɨtɨ. ");
INSERT INTO gnwNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Jayave upɨrandu: —¿Quíape pa piñono? —Eyu eecha, carai —jei reta chupe. ");
INSERT INTO gnwNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jayave Jesús uyao. ");
INSERT INTO gnwNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Jare judío reta jei: —Mase, uau ete co. ");
INSERT INTO gnwNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ẽrei amocue vae jei: —¿Ipuere'ã ra uyapo mbae cua cuimbae agüɨye vaerã umano tẽi Lázaro? Echa'ã umɨmae cuimbae jesa mbae vae. ");
INSERT INTO gnwNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesús iañeequi ye. Jayave oo teõgüerɨru oĩ vae pe. Jocua teõgüerɨru penti itape uyeyoo vae co jare ita tuicha vae oĩ teõgüerɨru jonque re. ");
INSERT INTO gnwNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jayave Jesús jei: —Pembɨsɨrɨ ita joco güi. Marta - jae co cuimbae amɨri jindɨ - jei chupe: —CheYa, ine ma co. Echa'ã irundɨ ara ma oĩ umano güive —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesús jei chupe: —Amɨmbeu ma ndeve nderovia yave ndeechata mbae ayapota ĩru vae reta umbɨadora vaerã Tumpa. ");
INSERT INTO gnwNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Jayave umbɨsɨrɨ reta ita teõgüerɨru jonque güi. Jayave Jesús umae ara cotɨ jare jei: —CheRu, amee yasurupai ndeve nde ndiyandu cheve vae re. ");
INSERT INTO gnwNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Aicuaa jecuaeño ndiyandu cheve, ẽrei jae cuarãi cua cheyɨpɨ rupi ñugüɨnoi vae reta jeco pegua, jae reta güɨrovia vaerã nde co chembou vae —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Jayave iñeeãta. —Lázaro, eẽ joco güi —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Jare cuimbae amɨri oẽ. Ipo jare ipɨ uyeyocua tarapo pe, jare jova uñenoma nieso pe. Jayave Jesús jei: —Piyora iyocuaa. Pemaeño tuguata —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Jare jeta judío yugüeru opou María ipɨ vae reta uecha Jesús uyapo vae jare güɨrovia jese. ");
INSERT INTO gnwNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ẽrei amocue vae yugüɨraa fariseo reta pe umɨmbeu Jesús uyapo vae. ");
INSERT INTO gnwNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Jayave sacerdote reta itenondegua reta jare fariseo reta umbatɨ opaete mburuvicha reta. —¿Mbae pa yayapota? —jei reta—. Cua cuimbae jecuaeño uyapo jeta mɨacañɨ reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ñamaeño yave cuarãi uyapo vaerã, opaete vae reta güɨroviata jese. Jayave romano reta yugüeruta umbusururu Tumpa jo jare uyucata opaete ñanerentaɨgua reta —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ẽrei penti ipɨte pe oĩ vae - Caifás jee vae - jae co sacerdote tenondegua jocua año - jei: —Picuaa'ã etei mbae. ");
INSERT INTO gnwNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Pepɨa pe piyemɨngueta cavi'ã. Echa'ã icavita co yandeve penti cuimbae umano vaerã opaete vae reta ipepɨca pe. Echa'ã jucuarãi'ã yave, aramoi opaete vae reta umanota —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Jare cua umɨmbeu chupe reta ndei uyeyapo mbove. Umɨmbeu'ã jaeiño. Echa'ã jae sacerdote tenondegua co jocua año. Umɨmbeu Jesús umanota opaete judío reta ipepɨca pe. ");
INSERT INTO gnwNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Umanota umbatɨ vaerã opaete Tumpa taɨ uñemɨai vae reta - umanota'ã judío reta reño. ");
INSERT INTO gnwNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Jáeramo jocua ara güive uyemboemboe quirãi uyucaca vaerã Jesús. ");
INSERT INTO gnwNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Jáeramo Jesús upɨta'ã ma Judea pe, agüɨye vaerã judío reta uecha. Oo joco güi penti tenta guasu Efraín jee vae pe. Jocua tenta guasu coiño oĩ ñana güi. Jare joco pe Jesús upɨta jemimboe reta ndive. ");
INSERT INTO gnwNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Jare coiño ma ou judío reta ifiesta pascua jee vae, jare jeta judío reta yugüɨraa Jerusalén pe joco güi ndei pascua iara ou uvãe mbove. Echa'ã uipota uyeyoe Tumpa cotɨ fiesta peguarã. ");
INSERT INTO gnwNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Jayave ueca ñugüɨnoi Jesús, jare Tumpa jo pe ñugüɨnoi rambueve jei uyupe: —¿Mbae pa pepɨa pe piyemɨngueta? ¿Ndarau ra ou cua fiesta pe? —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Echa'ã sacerdote reta itenondegua reta jare fariseo reta oyocui ma opaete vae cuarãi: “Ime yave quía uicuaa quiape Jesús ime oĩ vae, tumɨmbeu oreve orepuere nduipɨsɨ vaerã.” ");
INSERT INTO gnwNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Seis araño ma uata pascua uvãe vaerã. Jayave Jesús oo ye Betania pe. Echa'ã joco pe ico Lázaro tenonde yave umano vae Jesús umbɨjecove ye güeru umanocue vae reta ipɨte güi vae. ");
INSERT INTO gnwNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Pɨ̃tu ma yave Lázaro jenta pegua reta uyapo Jesús jou vaerã. Marta güeru tembíu, jare Lázaro uguapɨ ucaru mesa pe Jesús ndive. ");
INSERT INTO gnwNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Jayave María güeru penti libra mbae ipiche cavi vae nardo jee vae jepɨ ete vae jare upɨyere Jesús ipɨ re. Jayave umɨtini ipɨ ía pɨpe. Jare opaete o ipiche cavi. ");
INSERT INTO gnwNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Jayave penti Jesús jemimboe Judas Iscariote jee vae - jae co Simón taɨ - jae co umeeta Jesús jovaicho reta pe vae - jei: ");
INSERT INTO gnwNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—¿Maera pa umee'ã cua mbae ipiche cavi vae trescientos ara mbaravɨquɨ jepɨ pegua pe? Echa'ã ipuereta tẽi co umee corepoti iparavete vae reta pe —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ẽrei jae ipɨatɨtɨ'ã iparavete vae reta re. Echa'ã jucuarãi jei imonda ramo. Echa'ã jae güɨnoi corepoti ĩru vae reta umee chupe reta vae jɨru, jare jecuaeño uequi vɨari chugüi corepoti iyupeguarã. ");
INSERT INTO gnwNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jayave Jesús jei: —Emaeño jese. Penti ara añeñotɨcata co. Jocua ara peguarã uñuvatu cua mbae ipiche cavi vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Iparavete vae reta yugüɨrecoñotai co pe reta ndive. Ẽrei che ndarau aicoño pe reta ndive —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Jare jeta judío reta uicuaa Jesús joco pe oĩ. Jáeramo yugüeru. Jare yugüeru'ã Jesús joco pe oĩ ramoño. Ẽrei yugüeru vi umae vaerã Lázaro re. Echa'ã Jesús umbɨjecove ye Lázaro güeru umanocue vae reta ipɨte güi. ");
INSERT INTO gnwNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Jayave sacerdote reta itenondegua reta uyemɨngueta vi quirãi uyucaca vaerã Lázaro. ");
INSERT INTO gnwNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Echa'ã Lázaro jeco pegua jeta judío reta yugüɨraa chugüi reta. Echa'ã güɨrovia ma Jesús re. ");
INSERT INTO gnwNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Pɨareve pe jeta ete pascua pe yugüeru ma vae uicuaa Jesús outa ma co Jerusalén pe. ");
INSERT INTO gnwNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Jayave uequi reta carandaɨ joquɨ yugüɨraa oovãiti vaerã Jesús. —¡Icavi co! —jei reta—. Tuyembɨadoraca yandeYa jee re ou vae. Tuyembɨadoraca Israel pegua reta juvicha guasu —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jare Jesús uvãe penti mburica taɨrusu vae, jare opo jese. Echa'ã Tumpa iñee pe uyecuatía oĩ cuarãi: ");
INSERT INTO gnwNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Agüɨye pequɨye, Jerusalén pegua reta. Mase, co ou ma peruvicha guasu. Opo ou mburica taɨrusu vae re. Jucuarãi uyecuatía oĩ. ");
INSERT INTO gnwNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Jocua ara Jesús jemimboe reta uicuaa cavi'ã cua regua. Ẽrei Jesús oo ye ma ara pe yave, imandúa reta cua re. Echa'ã jucuarãi Tumpa iñee pe uyecuatía oĩ jese, jare jucuarãi uyeyapo chupe. ");
INSERT INTO gnwNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Jare amocue joco pe ñugüɨnoi vae jei: —Ore noĩ Jesús ndive, jae umbɨjecove ye yave Lázaro güeru umanocue vae reta ipɨte güi jare oyocui oẽ vaerã teõgüerɨru güi —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Jáeramo jeta vae yugüɨraa oovãiti Jesús. Echa'ã uicuaa ma uyapo cua mɨacañɨ. ");
INSERT INTO gnwNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Jayave fariseo reta jei uyupe: —Mase, mbaetɨ mbae yandepuere yayapo. Echa'ã opaete que rupi rupigua reta yugüɨraa umae vaerã jese. ");
INSERT INTO gnwNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Jare amocue griego reta yugüeru ma pascua pe ĩru vae reta ndive umbɨadora vaerã Tumpa. ");
INSERT INTO gnwNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Jae reta yugüeru Felipe Betsaida pegua pe - jocua Betsaida Galilea pegua co - jare jei chupe: —Carai, nduipota nduecha Jesús. ");
INSERT INTO gnwNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Jayave Felipe oo umɨmbeu Andrés pe. Jayave mocui reve yugüɨraa umɨmbeu Jesús pe. ");
INSERT INTO gnwNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jayave Jesús jei: —Ara uvãe ma che ayeyapo cuimbaerã vae ayembɨadoraca vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Añete che jae peve, penti trigo jãɨcue uñeñotɨ'ã yave, jaeño upɨta. Ẽrei uñeñotɨ yave, jeta uñemoña —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Uyerau vae ndarau uyembɨasaca. Ẽrei uyerau'ã cua ɨvɨ pe vae uyembɨasacata co. Güɨnoita tecove opa mbae vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Uyeyocui cheve vae too cherupíe. Cherembiocui oĩta che aĩta vae pe. Jare cheRu umbutuichacata uyeyocui cheve vae —jei Jesús—. ");
INSERT INTO gnwNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Tuicha chepɨatɨtɨ aĩ. Ẽrei chepuere'ã jae: ‘CheRu, cherepɨ cua ora pe uyeyapota cheve vae güi.’ Echa'ã uvãe ma cua ora cua uyeyapo cheve vaerã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","CheRu, iyapo cheve ɨvɨ pegua reta nembɨadora vaerã —jei. Jayave ñee uyendu ara güi: —Ayapo ma mbaembae nde rupi ɨvɨ pegua reta chembɨadora vaerã, jare cuarãi ayapo yeta co. ");
INSERT INTO gnwNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Jeta joco pe ñugüɨnoi vae reta uyandu ñee jare jei ara co jɨapu. Ĩru reta jei: —Penti ángel ombou iñee chupe. ");
INSERT INTO gnwNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jayave Jesús jei: —Cua ñee uyendu pereco pegua - chereco pegua'ã co. ");
INSERT INTO gnwNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Uñeãa ma ɨvɨ pegua reta, jare jae reta juvicha uyemombota co —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Jare ĩru vae reta chereupi curusu re yave ɨvɨ güi, arurucata opaete ɨvɨ pegua reta checotɨ —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Cua jei Jesús uicuaaca vaerã chupe reta quirãita co umano. ");
INSERT INTO gnwNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Jayave jae reta jei Jesús pe: —Mboroyocui pe uyecuatía oĩ vae umɨmbeu oreve Cristo imeñoi ico. ¿Mbae pa uipota jei jocua nde ndere vae? Echa'ã nde ndere ĩru vae reta uupita ɨvɨ güi cuimbaerã uyeyapo vae. ¿Quía pa co jae cuimbaerã uyeyapo vae? —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","—Tembipe imeño ico pe reta ndive —jei Jesús—. Ẽrei ndarau ɨma upɨta pe reta ndive. Peguata tembipe ico pe reta ndive rambueve, agüɨye vaerã pɨ̃tu peve. Echa'ã pɨ̃tumimbi pe uguata vae uicuaa'ã quetɨ oo —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Tembipe pe reta ndive ico rambueve, perovia tembipe re, pe reta peĩ vaerã tembipe rami —jei chupe reta. Cua jei ma yave, Jesús oo chugüi reta, jare ipuere'ã ma uvãe chupe. ");
INSERT INTO gnwNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ẽrei yepe tẽi Jesús uyapo jeta mɨacañɨ reta jae reta jovaque uicuaaca vaerã tẽi chupe reta quía co jae, ẽrei jae reta güɨrovia'ã jese, ");
INSERT INTO gnwNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","uyeyapo vaerã Isaías uicuatía vae - Isaías co jae Tumpa iñee aracae umɨmbeu vae. Echa'ã Isaías uicuatía cuarãi: “CheYa, ¿quía pa güɨrovia numɨmbeu vae? ¿Quía nunga vae pe pa ndicuaaca nembaepuere?” Jucuarãi uicuatía Isaías aracae. ");
INSERT INTO gnwNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Jáeramo jae reta ipuere'ã güɨrovia. Echa'ã Isaías uicuatía vi cuarãi: ");
INSERT INTO gnwNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Tumpa uyapo reta jesa mbae vae reta rami jare umɨpɨatanta, agüɨye vaerã uecha cavi reta, jare agüɨye vaerã uicuaa cavi reta, jare agüɨye vaerã uyerova icotɨ. Echa'ã uyerova yave Tumpa cotɨ, Tumpa umbaita tẽi imbaeyoa reta.” Jucuarãi uicuatía Isaías. ");
INSERT INTO gnwNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaías cua jei, uecha yave yembutuicha ara pegua. Jáeramo imiari jucuarãi jese. ");
INSERT INTO gnwNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ẽrei amocue mburuvicha reta güɨrovia Jesús re. Ẽrei uipota'ã jei jae co Cristo fariseo reta jeco pegua. Echa'ã jucuarãi jei yave, fariseo reta omombota tẽi co judío reta itupao güi. ");
INSERT INTO gnwNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Echa'ã jae reta uipota ete japicha reta pe uyembutuichaca vaerã Tumpa umbutuichaca vaerã tẽi güi. ");
INSERT INTO gnwNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jayave Jesús iñeeãta reve jei: —Cheré güɨrovia vae chereño'ã güɨrovia. Güɨrovia chembou vae re —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Cherecha vae uecha vi chembou vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ayu ɨvɨ pe amee vaerã tembipe ɨvɨ pegua reta pe, agüɨye vaerã cheré güɨrovia vae upɨta pɨ̃tumimbi pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Chiñee re uyapɨsaca vae uyapo'ã yave che jae vae rupi, che aãa'ã. Echa'ã che ayu ambɨasa vaerã ɨvɨ pegua reta. Ayu'ã aãa vaerã —jei Jesús—. ");
INSERT INTO gnwNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Jocua güɨrovia'ã cheré jare uyapo'ã che jae chupe uyapo vaerã vae uñeãata co. Echa'ã ara taɨcuegua vae pe cua che jae vae uãata —jei chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Echa'ã cheporomboe chembaeño'ã co. Cheru chembou, jare jae cheocui mbae jae vaerã, jare quirãi chemiari vaerã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Jare aicuaa cheRu cheocui vae tecove opa mbae vae pegua co. Jáeramo che jae peve cheRu jei cheve vae —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Uyaro ma pascua iara. Jare Jesús uicuaa ara uvãe ma ueya vaerã cua ɨvɨ oo ye vaerã Tu pe. Imeño uau imbae cua ɨvɨ pe ñugüɨnoi vae reta, jare añave uicuaacata quirãi uau ete. ");
INSERT INTO gnwNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","4","Judas Iscariote - jae co Simón taɨ - ipɨa pe uyemɨngueta ma umee vaerã Jesús jovaicho reta pe. Echa'ã jucuarãi uipota aña guasu Judas ipɨa pe uyemɨngueta vaerã. Jare Jesús uicuaa cavi ma Tu oñono opaete mbaembae ipo pe. Uicuaa vi ou co Tumpa güi jare oo yeta co Tumpa pe. Jare pɨ̃tu yave Jesús jare jemimboe reta ucaru ñugüɨnoi yave, Jesús upũa mesa güi, omboi iyasoya iarambogua, jare oñoma icúa penti toalla pe. ");
INSERT INTO gnwNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Jayave oñono ɨ penti ɨa pe jare umbɨpɨ oyoe jemimboe reta ipɨ, jare oyoe ma yave, umɨtini toalla icúa re oĩ vae pɨpe. ");
INSERT INTO gnwNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Jare oo uvãe yave Simón Pedro oĩ vae pe, Pedro jei chupe: —CheYa, ¿nequɨrẽɨ pa ndiyoe chepɨ? ");
INSERT INTO gnwNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","—Cua ayapo aĩ vae ndicuaa cavi'ã añave —jei Jesús—, ẽrei ndicuaa cavita co taɨcue rupi. ");
INSERT INTO gnwNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","—Ndarau etei ndiyoe chepɨ —jei Pedro. —Jucuarãi yave, nde cheĩru'ã co —jei Jesús chupe. ");
INSERT INTO gnwNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Jayave Simón Pedro jei: —CheYa, iyoe chepo jare cheãca vi - agüɨye iyoe chepɨño. ");
INSERT INTO gnwNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","—Uyau ma vae uyau yeta'ã ma —jei Jesús—. Ipɨño ma oyoeta. Echa'ã opaete jete iquɨa mbae ma. Jare pe reta pequɨa mbae ma. Ẽrei opaete'ã co pe reta —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Echa'ã Jesús uicuaa quía umeeta jovaicho reta pe. Jáeramo jei: “Ẽrei opaete'ã co pe reta.” ");
INSERT INTO gnwNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Jayave opa yave ipɨ reta oyoe, uyemonde ye Jesús jare oo uguapɨ jenda pe. Jayave upɨrandu chupe reta: —¿Picuaa cavi pa ayapo ma peve vae? ");
INSERT INTO gnwNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Pe reta pere cheve: ‘Oporomboe vae’, jare pere vi: ‘OreYa.’ Añete co cua pere vae. Echa'ã aporomboe jare che co jae peYa —jei chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ẽrei yepe tẽi che pomboe jare che co jae peYa, ẽrei ayoe ma pepɨ reta. Jáeramo icavi co pe reta piyoe vaerã pepɨ piyugüi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Echa'ã che cua ayapo aicuaaca vaerã peve, pe reta vi piyapo vaerã che ayapo peve vae rami —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Añete che jae peve, penti uyeyocui vae imbaepuere tuicha'ã ete ipatrón imbaepuere rami. Jae ramiño vi penti temimondo imbaepuere tuicha'ã ete omondo vae imbaepuere rami —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Cua picuaa cavi. Piyapo yave, Tumpa uyapota icavi vae peve —jei Jesús chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Opaete pe reta re'ã ayemɨngueta aĩ. Che aicuaa quía aiparavo vae reta. Ẽrei Tumpa iñee pe uyecuatía oĩ vae uyeyapota co. Echa'ã uyecuatía oĩ cuarãi: ‘Jocua ucaru che ndive vae chemeeta.’ Jucuarãi uyecuatía oĩ —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Cua amɨmbeu peve añave ndei uyeyapo mbove, cua uyeyapo yave perovia vaerã quía co che —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Añete che jae peve, cheremimondo pe uyapo icavi vae, cheve co uyapo icavi vae. Jare jocua cheve uyapo icavi vae, uyapo vi icavi vae chembou vae pe —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Cua jei ma yave, Jesús tuicha ipɨatɨtɨ jare jei: —Añete che jae peve, penti pepɨte pe oĩ vae chemeeta cherovaicho reta pe. ");
INSERT INTO gnwNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Jayave Jesús jemimboe reta umae iyee reta. Uicuaa'ã quía re ra uyemɨngueta. ");
INSERT INTO gnwNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Penti jemimboe - jae co Jesús uau vae - ucaru oĩ Jesús iyɨpɨ pe. ");
INSERT INTO gnwNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Jayave Simón Pedro omomɨ iñãca jocua ĩru temimboe uecha vaerã, jare jae upɨrandu vaerã Jesús pe quía regua ra uyemɨngueta. ");
INSERT INTO gnwNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Jayave jocua temimboe Jesús iyɨpɨ pe ucaru oĩ vae upɨrandu Jesús pe: —¿Quía pa co jae, cheYa? ");
INSERT INTO gnwNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","—Ameeta chupe mbɨyape —jei Jesús—, tembíu pe amãquɨ ma yave. Jocua co jae —jei. Jayave tembíu pe umãquɨ ma yave, uequi umee Judas Iscariote pe - jae co Simón taɨ. ");
INSERT INTO gnwNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Jayave Judas jou ma yave, Satanás oya jese. Jayave Jesús jei Judas pe: —Iyapo voi jocua ndiyapota vae. ");
INSERT INTO gnwNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ẽrei mbaetɨ quía mesa pe oĩ vae uicuaa maera Jesús jei jucuarãi Judas pe. ");
INSERT INTO gnwNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Amocue vae ipɨa pe uyemɨngueta tẽi Jesús jei chupe vae uipota jei: “Ecua egua yaipota fiesta peguarã vae”, ani: “Ecua emee mbae iparavete vae reta pe.” Echa'ã Judas güɨnoi corepoti jɨru. ");
INSERT INTO gnwNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Jayave opa yave jou mbɨyape, Judas oẽ oo. Jare pɨ̃tu ma co. ");
INSERT INTO gnwNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Jayave oẽ ma yave Judas, Jesús jei: —Che ayeyapo cuimbaerã. Añave ɨvɨ pegua reta chembɨadorata. Jare umbɨadorata vi Tumpa chereco pegua —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ɨvɨ pegua reta umbɨadorata Tumpa chereco pegua. Jáeramo Tumpa etei chembɨadoracata ɨvɨ pegua reta pe. Añave voi chembɨadoracata —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Cherɨvɨ reta, michi peguaño ma apɨtata pe reta ndive. Jayave chereca tẽita, ẽrei pe reta ndarau pepuere peo che aata vae pe. Echa'ã cuarãi amɨmbeu judío reta pe, jare añave amɨmbeu vi peve —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Amee peve penti mboroyocui ipɨau vae. Piyerau. Piyerau che puau rami —jei Jesús chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Piyerau yave, opaete ɨvɨ pegua reta uicuaata pe reta cheremimboe reta co —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simón Pedro jei Jesús pe: —CheYa, ¿quetɨ pa ndeota? —Ndarau añave ndepuere ndeo che aata vae pe —jei Jesús—. Ẽrei taɨcue rupi ndeota co —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pedro jei: —CheYa, ¿maera pa chepuere'ã aa nde ndive añave? Che tamano ndepepɨca pe —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","—Nde ndere nemanota chepepɨca pe —jei Jesús—. Añete che jae ndeve, ndei uru cuimbae uñee mbove, mbapɨ vese ma checuacuta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Agüɨye pepɨatɨtɨ. Perovia Tumpa re. Perovia vi cheré —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","CheRu jenta pe ime jeta o. Jucuarãi'ã yave, amɨmbeuta tẽi co peve. Aata ayapɨcatu perendarã —jei Jesús chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Jare aa ma yave ayapɨcatu perendarã, ayu yeta puraa vaerã, pe reta vi pico vaerã che aicota vae pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Jare pe reta picuaa tape que rupi aata —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Jayave Tomás jei: —OreYa, ore nduicuaa'ã quetɨ ndeota vae. ¿Quirãita ra nduicuaa tape? ");
INSERT INTO gnwNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","—Che co jae tape —jei Jesús—. Che co jae añetete uyemɨngueta vae. Che co jae tecove opa mbae vae umee vae. Mbaetɨ quía ipuere uñemɨĩru cheRu ndive jaeño che rupi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Checuaa cavi yave mona, picuaata tẽi co cheRu vi. Ẽrei añave güive picuaa co. Echa'ã peecha ma —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Felipe jei chupe: —OreYa, eechaca oreve ndeRu. Jocuaño nduipota. ");
INSERT INTO gnwNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","—Ɨma ma aico pe reta ndive, Felipe —jei Jesús—. ¿Ndei pa co checuaa cavi? Cherecha vae uecha ma co cheRu. ¿Maera pa ndere: ‘Eechaca oreve ndeRu’? —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Perovia'ã pa che aico cheRu ndive jare cheRu ico che ndive vae? Ñee amɨmbeu peve vae chembaeño'ã co. Echa'ã cheRu ico che ndive, jare jae uyapo mbaravɨquɨ reta —jei Jesús—. ");
INSERT INTO gnwNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Perovia cua che jae peve vae: Che aico cheRu ndive, jare cheRu ico che ndive. Cua perovia'ã yave, chererovia mbaravɨquɨ ayapo vae reta jeco pegua —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Añete che jae peve, cheré güɨrovia vae uyapota mbaravɨquɨ reta che ayapo ma vae reta rami. Jare iparavɨquɨ reta tuicha eteta cheparavɨquɨ reta güi, che aata cheRu pe ramo —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Pepuereta piyerure ipotave mbae re cheree re, jare che ayapota peve, cheRu uyembɨadoraca vaerã che ayapota vae rupi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Piyerure yave ipotave mbae re cheree re, ayapota co peve —jei Jesús chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Cherau yave, piyapo cheporoyocui reta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Jare che ayerureta cheRu pe jae ombou vaerã peve ĩru vae. Jae jecuaeño icota pe reta ndive pembɨpɨacatu vaerã. Jae co Espíritu Santo —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Jae imiarita añete vae re. Upurugüɨrovia mbae vae reta ndarau ipuere umbɨresive Espíritu Santo. Echa'ã upurugüɨrovia mbae vae reta uecha'ã jare uicuaa'ã. Ẽrei pe reta picuaa. Echa'ã jae ico pe reta ndive jare icota pepɨa pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Che aa ma yave, ndarau pueya jentarã mbae vae reta rami. Echa'ã che ayu yeta co —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Michi peguaño ma ɨvɨ pegua reta cherechata. Ndarau ma cherecha ye. Ẽrei pe reta cherecha yeta. Che jecuaeño aico ramo, pe reta picota vi —jei chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Jocua ara picuaata co che aico cheRu ndive, jare pe reta pico che ndive vae, jare che aico pepɨa pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ime yave quía uyapɨsaca cheporoyocui reta re uyapo vaerã vae, jae co cherau. Jare cheRu uauta cherau vae, jare che aauta, jare aicuaacata chupe quía co che —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Jayave Judas - jae'ã co Judas Iscariote - jei chupe: —OreYa, ¿quirãita pa ndicuaaca oreve quía co nde, ndicuaaca'ã yave upurugüɨrovia mbae vae reta pe? ");
INSERT INTO gnwNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","—Cherau vae uyapota che jae chupe uyapo vaerã vae —jei Jesús—. Jare cheRu uauta. Jare ndoyuta nduico vaerã jae ndive —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Cherau'ã vae uyapo'ã che jae chupe uyapo vaerã vae. Jare chiñee piyandu vae chembaeño'ã co. Echa'ã cua ñee cheRu iñee co. Jae co chembou —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Cua mbaembae re chemiari ma peve, aico pe ndive rambueve. ");
INSERT INTO gnwNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ẽrei jocua pembɨpɨacatuta vae pemboeta opaete mbae re. CheRu ombouta peve cheree re. Jae co Espíritu Santo. Jae pemɨmanduata opaete che jae peve vae re —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Mbɨacatu aeya pe ndive. Mbɨacatu che anoi vae amee peve. Ɨvɨ pegua reta ipuere'ã umee peve che amee peve vae nunga mbɨacatu. Agüɨye pepɨatɨtɨ. Agüɨye pequɨye —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Piyandu ma quirãi che jae: ‘Aata ma jare ayu yeta peve.’ Cherau yave mona, piyeroviata tẽi. Echa'ã aata cheRu pe, jare cheRu imbaepuere tuicha ete chembaepuere güi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Amɨmbeu ma peve ndei uyeyapo mbove, perovia vaerã uyeyapo yave —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ndarau ma ɨma chemiari peve. Echa'ã ɨvɨ pegua reta juvicha ɨmambae outa uvãe cheve. Ẽrei ndarau ipuere cheré —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ẽrei ayapota cheRu iporoyocui, ɨvɨ pegua reta uicuaa vaerã che aau cheRu. Pepũa, yaa ma cua güi —jei chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Che co jae uva iyɨpɨ añetete vae rami, jare cheRu co jae uva iyɨpɨ iyandarecoa rami —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Opaete jãca ía mbae vae reta cheRu uyasɨata. Jare opaete jãca ía vae reta jae uitɨota, jeta ía vaerã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Pe reta piyeyoeca ma ñee amɨmbeu peve vae pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Pico cheré perovia reve, jare che aicota pepɨa pe. Penti jãca uyeasɨa yave uva iyɨpɨ güi, ndarau ipuere ía. Echa'ã jãca jaeño ipuere'ã ía. Jae ramiño vi pe reta pico'ã yave cheré perovia reve, ndarau pepuere piyapo icavi vae Tumpa peguarã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Che co jae uva iyɨpɨ rami, jare pe reta co jae jãca reta rami. Jocua ico cheré güɨrovia reve vae uyapota jeta icavi vae Tumpa peguarã. Echa'ã che aico ipɨa pe. Ẽrei che aico'ã yave pepɨa pe, pepuereta'ã mbae piyapo Tumpa peguarã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Jocua ico'ã cheré güɨrovia reve vae uyemombota penti jãca uyeasɨa vae uyemombo yɨpi vaerã vae rami. Jare jãca yɨpi vae reta uyembatɨca jare uyemondoca tata pe ocai vaerã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Pico yave cheré perovia reve, jare piyapo yave che jae peve piyapo vaerã vae, pepuereta piyerure pipota vae re jare penoita co —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Piyapo yave jeta icavi vae cheRu peguarã, ɨvɨ pegua reta umbɨadorata cheRu. Jare cuarãi picuaacata pe reta co cheremimboe reta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","CheRu cherau. Jae ramiño vi che puau. Jecuaeño piyeyocui cheve, che puau ramo —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Piyapo yave cheporoyocui reta, che jecuaeño puauta. Echa'ã cuarãi che ayapo cheRu iporoyocui reta, jare jecuaeño jae cherau —jei Jesús chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Cuarãi chemiari ma peve piyerovia vaerã che ayerovia rami. Cuarãi ayapo tuicha ete piyerovia vaerã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Cua co jae cheporoyocui: Piyerau che puau rami. ");
INSERT INTO gnwNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ime yave quía iquɨrẽɨ umano uepɨ vaerã iamigo reta vae, ipuruau tuicha ete co ĩru mburuau güi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Pe reta co jae cheamigo reta, piyapo yave che jae peve piyapo vaerã vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Che jae'ã ma peve pe reta co cherembiocui reta. Echa'ã uyeyocui vae uicuaa'ã mbae ra uyapo ipatrón. Ẽrei che jae ma peve pe reta co jae cheamigo reta. Echa'ã opaete cheRu umɨmbeu cheve vae aicuaaca ma co peve —jei chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Pe reta cheparavo'ã. Che co puparavo. Jare amee ma peve mbaepuere peo vaerã piyapo icavi vae Tumpa peguarã, jare jecuae jucuarãi piyapo vaerã. Cua ayapo cheRu umee vaerã peve ipotave piyerureta chupe jese cheree re vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Cua co poyocui: Piyerau —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Piñemɨtarẽɨca upurugüɨrovia mbae vae reta pe yave, pemandúa quirãi jae reta che rani co chemɨtarẽɨ —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Pico yave mona upurugüɨrovia mbae vae reta yugüɨreco rami, upurugüɨrovia mbae vae reta perauta tẽi. Ẽrei che puparavo ma upurugüɨrovia mbae vae reta ipɨte güi. Jáeramo pico'ã ma upurugüɨrovia mbae vae reta yugüɨreco rami. Jáeramo piñemɨtarẽɨca upurugüɨrovia mbae vae reta pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Pemandúa cua che jae peve vae re: ‘Penti uyeyocui vae imbaepuere tuicha'ã ete ipatrón imbaepuere rami.’ Echa'ã upurugüɨrovia mbae vae reta uyapo yave icavi mbae vae cheve, uyapota vi icavi mbae vae peve. Uyapo reta yave che jae chupe uyapo vaerã vae, uyapota vi pe reta pere chupe uyapo vaerã vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ẽrei upurugüɨrovia mbae vae reta uyapota peve opaete cua mbaembae cheré perovia ramo. Echa'ã jae reta uicuaa'ã chembou vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ayu'ã yave mona chemiari vaerã chupe reta, ndarau tẽi teco güɨnoi. Ẽrei añave opaete vae ipuere uicuaa jae reta co teco güɨnoi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Chemɨtarẽɨ vae umɨtarẽɨ vi cheRu —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ayapo'ã yave mona ipɨte pe mbaravɨquɨ mbaetɨ quía ye uyapo vae reta, ndarau tẽi teco güɨnoi. Ẽrei jae reta cherecha ma - jae co cheRu uecha rami - jare oremɨtarẽɨ —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Cua uyapo reta uyeyapo vaerã mboroyocui pe uyecuatía oĩ vae. Echa'ã uyecuatía oĩ cuarãi: ‘Jae reta chemɨtarẽɨ mbaetɨ mbae icavi mbae vae ayapo chupe reta reve.’ Jucuarãi uyecuatía oĩ —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Ẽrei ambouta peve cheRu ico vae güi pembɨpɨacatuta vae - jae co Espíritu Santo añete vae re imiarita vae. Jae ou yave, chemɨmbeuta co —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Jare pe reta vi chemɨmbeuta. Echa'ã tenonde güive pico che ndive —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Opaete cua che jae ma peve agüɨye vaerã piyerova Tumpa güi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Piyemombocata co judío reta itupao reta güi. Añete co, outa ma ara piyeyucaca vaerã. Jare jocua reta peyucata vae ipɨa pe uyemɨngueta tẽita uyeyocui co oĩ Tumpa pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Jae reta uicuaa'ã cheRu jare checuaa'ã vi. Jáeramo jucuarãi uyapota —jei chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ẽrei cua che jae ma peve, pemandúa vaerã cuarãi amɨmbeu peve vae re jucuarãi uyapo reta yave —jei—. Amɨmbeu'ã peve cua tenonde güive. Echa'ã che aico pe ndive. ");
INSERT INTO gnwNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Ẽrei aata chembou vae pe. Jare penti ave añave pepɨrandu'ã cheve: ‘¿Quetɨ pa ndeota?’ —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ẽrei cua che jae peve vae jeco pegua pepɨatɨtɨ. ");
INSERT INTO gnwNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ẽrei amɨmbeu peve añete vae. Icavita co peve che aa vaerã. Echa'ã che aa'ã yave, ndarau ou peve pembɨpɨacatuta vae. Ẽrei aa yave, ambouta peve. ");
INSERT INTO gnwNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","11","Jare jae ou yave, uicuaacata ɨvɨ pegua reta pe jae reta uyapo co mbaeyoa. Echa'ã güɨrovia'ã cheré. Uicuaacata jupi vae. Echa'ã aata cheRu oĩ vae pe jare pe reta ndarau ye ma cherecha. Uicuaacata Tumpa uãata ɨvɨ pegua reta. Echa'ã uãa ma ɨvɨ pegua reta juvicha —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Ime jeta aipota tẽi jae peve vae, ẽrei ndeiño pepuere picuaa cavi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ẽrei Espíritu Santo añete vae re imiarita vae ou ma yave, umɨmbeuta peve añete vae. Echa'ã ñee umɨmbeuta peve vae ndarau imbaeño. Imiarita Tumpa umɨmbeu chupe vae re, jare umɨmbeuta peve uyeyapota vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Jae chembɨadoracata co. Echa'ã jae pemboeta che pomboe rami —jei Jesús chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Opaete cheRu imbae chembae vi co. Jáeramo che jae cuarãi: ‘Jae pemboeta che pomboe rami’ —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Michi peguaño ma pe reta cherechata. Ẽrei ɨmambae cherecha yeta. Echa'ã aata cheRu pe —jei chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Amocue jemimboe reta jei uyupe: —¿Mbae pa uipota jei cua jei yandeve vae? Echa'ã jei: ‘Michi peguaño ma pe reta cherechata. Ẽrei ɨmambae cherecha yeta.’ Jare jei vi: ‘Echa'ã aata cheRu pe.’ ");
INSERT INTO gnwNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Mbae pa uipota jei: ‘Michi peguaño ma’? Yaicuaa'ã mbae ra uipota jei —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesús uicuaa jae reta uipota tẽi upɨrandu chupe cua re. Jáeramo jei chupe reta: —Che jae peve cuarãi: ‘Michi peguaño ma pe reta cherechata. Ẽrei ɨmambae cherecha yeta.’ Jare pepɨrandu peĩ piyupe mbae ra uipota jei cua che jae peve vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Añete che jae peve, piyaota jare pepɨatɨtɨta, ẽrei upurugüɨrovia mbae vae reta uyeroviata. Pepɨatɨtɨta co, ẽrei jaɨcue rupi piyeroviata co —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Penti cuña imembɨ oata ma oĩ yave, cuña ipɨatɨtɨ jasɨ chupe ramo. Ẽrei imembɨ oa ma yave, imandua'ã ma jasɨ chupe vae re. Echa'ã uyerovia imembɨ oa ma ramo —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Jae ramiño vi pe reta pepɨatɨtɨ añave, ẽrei puecha yeta, jare piyeroviata, jare ndarau quía ipuere pembɨpɨatɨtɨ ye —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Jocua ara ndarau pepɨrandu cheve mbae re. Añete che jae peve, ipotave piyerureta cheRu pe jese vae cheRu umeeta peve cheree re —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ndeiño peeca mbae cheree re. Piyerure Tumpa pe mbaembae re, jare cheRu umeeta co peve tuicha ete piyerovia vaerã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Cua amɨmbeu ma peve amɨjaanga reve. Ẽrei outa ma ara reta amɨmbeu cavi vaerã peve cheRu regua. Ndarau ye ma amɨmbeu peve amɨjaanga reve —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Jocua ara reta pe piyerureta mbaembae re cheree re. Jare che jae'ã peve ayerureta cheRu pe jae uyapo vaerã piyerure jese vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Echa'ã cheRu etei perau, pe reta cherau jare perovia che ayu cheRu güi ramo —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ayu co cheRu güi cua ɨvɨ pe. Aa yeta ma cua ɨvɨ güi cheRu pe —jei chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Jesús jemimboe reta jei chupe: —Añave nemɨmbeu cavi ma oreve nemɨjaanga mbae reve. ");
INSERT INTO gnwNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Añave nduicuaa nde ndicuaa co opaete vae, jare ndeeca'ã quía umɨmbeu vaerã ndeve mbae re. Cua jeco pegua ndugüɨrovia nde ndeyu co Tumpa güi —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesús jei chupe reta: —Pe reta pere perovia ma. ");
INSERT INTO gnwNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ẽrei outa ma ara - ou ma co - pe reta piñemɨai vaerã. Chereyata jare penti penti peota perenta pe. Cheño apɨtata. Ẽrei ndarau cheño aico. Echa'ã cheRu ico che ndive —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Cua che jae ma peve pepɨacatu vaerã cheré perovia ramo. Cua ɨvɨ pe pico rambueve, piporarata co. Ẽrei agüɨye pepɨatɨtɨ. Echa'ã che chepuere ete ɨvɨ pegua reta güi —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Cua jei ma yave, Jesús umae ara cotɨ jare jei: —CheRu, ara uvãe ma. Che co jae ndeRaɨ. Chembɨadoraca, chepuere vaerã numbɨadoraca vi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Echa'ã nde cheapo ma opaete vae iYarã, amee vaerã tecove opa mbae vae opaete nde nemee cheve vae reta pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ime yave quía yandecuaa vae, jae güɨnoi tecove opa mbae vae. Nde co jae pentiño Tumpa añetete vae. Che co jae Jesucristo. Nde chembou —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Che numbɨadoraca cua ɨvɨ pe. Echa'ã opa ma ayapo mbaravɨquɨ nde nemee cheve ayapo vaerã vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ndei ɨvɨ uyeyapo mbove aico nde ndive yave ayembɨadoraca co. Jae ramiño vi añave chembɨadoraca ye nderovai —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Nde nemee ma cheve cua cuimbae reta upurugüɨrovia mbae vae reta ipɨte güi. Che amɨmbeu ma nderegua cua reta pe. Jae reta nembae co jare nde nemee ma cheve. Jae reta uyapo nde ndere chupe reta uyapo vaerã vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Jae reta uicuaa opaete nde nemee cheve vae ou co ndegüi. ");
INSERT INTO gnwNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Echa'ã che amee ma chupe reta ñee nde nemee cheve vae, jare jae reta güɨrovia niñee. Uicuaa cavi che ayu co ndegüi. Güɨrovia ma nde co chembou —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ayerure ndeve jese reta. Ayerure'ã upurugüɨrovia mbae vae reta re. Ayerure ndeve nde nemee cheve vae reta re. Echa'ã jae reta nembae co —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Opaete chembae nembae co, jare nembae chembae co. Jare che ayembɨadoraca ma jae reta jeco pegua —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Jare ndarau ma aico cua ɨvɨ pe. Ẽrei jae reta upɨtañota cua ɨvɨ pe. Che aata ma ndepɨ. CheRu, nde co jae jupi vae. Cua reta nemee ma cheve. Emborɨ nembaepuere pe, agüɨye vaerã uyerova ndegüi, jare yugüɨreco vaerã penti ramiño. Echa'ã jucuarãi yande yaico penti ramiño —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Che aico jae reta ndive rambueve, che amborɨ nembaepuere pe cua nemee cheve vae reta, agüɨye vaerã uyerova ndegüi. Pentiño oota cañɨtei pe, niñee pe uyecuatía oĩ vae uyeyapo vaerã. Ẽrei amborɨ ĩru reta, agüɨye vaerã yugüɨraa cañɨtei pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Ẽrei aata ma ndepɨ. Cuarãi chemiari chupe reta ɨvɨ pe aico rambueve, jae reta uyerovia ete vaerã che ayerovia rami —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Amee ma chupe reta niñee, jare uñemɨtarẽɨca upurugüɨrovia mbae vae reta pe. Che aico'ã upurugüɨrovia mbae vae reta yugüɨreco rami. Jae ramiño vi jae reta yugüɨreco'ã upurugüɨrovia mbae vae reta yugüɨreco rami —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ayerure'ã ndeve nde nderaa vaerã cua ɨvɨ güi. Ayerure ndeve nemborɨ vaerã, agüɨye vaerã icavi mbae vae iya umɨamɨri —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Che aico'ã upurugüɨrovia mbae vae reta yugüɨreco rami. Jae ramiño vi jae reta yugüɨreco'ã upurugüɨrovia mbae vae reta yugüɨreco rami. ");
INSERT INTO gnwNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Iñono tee reta ndiyupeguarã añete vae rupi. Niñee co jae añete vae —jei Jesús—. ");
INSERT INTO gnwNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Nde chembou ɨvɨ pe. Jae ramiño vi che amondo cua reta opaete ɨvɨ rupi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Cua reta jeco pegua añeñono tee ma ndeve peguarã, jae reta vi uñeñono tee vaerã ndeve peguarã añete vae rupi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Jare ayerure ndeve cheré güɨroviata vae re. Echa'ã güɨroviata cua reta iñee rupi. Cua reta reño'ã ayerure ndeve —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ayerure ndeve opaete jae reta yugüɨreco vaerã penti ramiño. Nde ndico che ndive, cheRu, jare che aico nde ndive. Jae ramiño vi ayerure ndeve cua reta yugüɨreco vaerã yanderé güɨrovia reve, ɨvɨ pegua reta güɨrovia vaerã nde co chembou vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Nde ndepɨacavi ndeechaca cheve vae, che vi aechaca chupe reta, jae reta yugüɨreco vaerã penti ramiño. Echa'ã jucuarãi yande yaico penti ramiño —jei Jesús—. ");
INSERT INTO gnwNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Nde ndicota che ndive jare che aicota ipɨa pe, añetete yugüɨreco vaerã penti ramiño, ɨvɨ pegua reta uicuaa vaerã nde co chembou jare nde ndeau co cua reta nde cherau rami —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","CheRu, aipota cua nemee cheve vae reta vi yugüɨreco vaerã che aicota vae pe, uecha vaerã ndepɨacavi cheve vae. Echa'ã ndei ɨvɨ uyeyapo mbove nde cherauño mai —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","CheRu, nde co jae jupi vae. Upurugüɨrovia mbae vae reta ndecuaa'ã. Ẽrei che co nducuaa, jare cua reta uicuaa nde co chembou vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Che numɨmbeu ma chupe reta jare numɨmbeu yeta, jae reta tuau ĩru vae reta nde cherau rami, jare che aico vaerã ipɨa pe —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jesús cua jei ma yave, uasa jemimboe reta ndive ɨãca Cedrón jee vae jovaicho pe oo uvãe temitɨ reta ñugüɨnoi vae pe. Joco pe uique Jesús jare jemimboe reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Jare Judas - jae co umee jovaicho reta pe vae - uicuaa jocua temitɨ reta jenda. Echa'ã joco pe uyembatɨñoi yepi Jesús jemimboe reta ndive. ");
INSERT INTO gnwNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Jayave Judas oo sacerdote reta itenondegua reta jare fariseo reta ñugüɨnoi vae pe, jare jae reta omondo amocue sundaro reta jare jembiocui reta temitɨ reta ñugüɨnoi vae cotɨ Judas jupíe. Güɨraa reta mechero jare ɨvɨra jare quɨsepucu reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jayave Jesús oo jae reta ñugüɨnoi vae cotɨ jare jei: —¿Quía pa peeca? Echa'ã jae uicuaa ma mbae uyeyapota chupe vae. ");
INSERT INTO gnwNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","—Jesús Nazaret pegua —jei reta. —Che co jae —jei Jesús. Jare Judas - jae co umee jovaicho reta pe vae - uyemboɨ oĩ joco pe jae reta ndive. ");
INSERT INTO gnwNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Jesús jei yave chupe reta: “Che co jae”, jae reta opa usɨrɨ jaɨcue cotɨ jare oa reta ɨvɨ re. ");
INSERT INTO gnwNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Jayave Jesús upɨrandu ye chupe reta: —¿Quía pa peeca? Jei reta ye: —Jesús Nazaret pegua. ");
INSERT INTO gnwNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","—Amɨmbeu ma peve che co jae —jei Jesús—. Pe reta che chereca. Jáeramo pemaeño cua che ndive ñugüɨnoi vae reta re yugüɨraa ye vaerã —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Cua jei uyeyapo vaerã tenonde yave jei vae: “Amɨcañɨ'ã penti ave nde nemee cheve vae reta güi.” Jucuarãi jei ma. ");
INSERT INTO gnwNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Jare Simón Pedro güɨnoi penti quɨsepucu. Jayave uequi jɨru güi jare uiporu sacerdote tenondegua jembiocui inambi iyacata cotɨgua re, jare uyasɨa inambi chugüi. (Jocua uyeyocui vae jee co Malco.) ");
INSERT INTO gnwNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jayave Jesús jei Pedro pe: —Iñono ye ndequɨsepucu jɨru pe. Aiporarañotai co. Echa'ã cheRu uipota aiporara vaerã —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Jayave sundaro reta juvicha ndive jare judío reta itenondegua reta jembiocui reta uipɨsɨ Jesús uñapɨ̃ti. ");
INSERT INTO gnwNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Jayave güɨraa Jesús Anás pe rani - jae co Caifás jembireco tu - Caifás co jae sacerdote tenondegua jocua año. ");
INSERT INTO gnwNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Tenonde yave cua Caifás umɨmbeu judío reta pe icavita co chupe reta penti cuimbae umano vaerã opaete vae reta ipepɨca pe. ");
INSERT INTO gnwNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Jare Simón Pedro jare ĩru temimboe yugüɨraa Jesús jaɨcue. Jare cua ĩru temimboe uique sacerdote tenondegua joca pe Jesús uique yave. Echa'ã sacerdote tenondegua uicuaa cua temimboe. ");
INSERT INTO gnwNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ẽrei Pedro uique'ã japɨpe pe. Upɨta uyemboɨ oĩ onque tuicha vae iyɨpɨ pe. Jayave ĩru temimboe sacerdote tenondegua uicuaa vae oẽ umɨngueta cuñatai onque uãro vae pe jare uruique Pedro. ");
INSERT INTO gnwNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Jayave cuñatai onque uãro vae jei Pedro pe: —¿Jae'ã pa co nde penti jocua cuimbae jemimboe? —Jae'ã co che —jei Pedro. ");
INSERT INTO gnwNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Jare sacerdote tenondegua jembiocui reta jare judío reta itenondegua reta jembiocui reta uyapo ma tata jare uyemboɨ reta tata iyɨpɨ rupi uyepee vaerã. Echa'ã roɨ co. Pedro vi upɨta joco pe uyemboɨ oĩ jae reta ndive uyepee vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Jayave sacerdote tenondegua upɨrandu Jesús pe jemimboe reta re jare iporomboe re. ");
INSERT INTO gnwNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jayave Jesús jei chupe: —Che ayemɨngueta co opaete vae jovaque. Jecuaeño aporomboe judío reta itupao reta pe jare Tumpa jo pe. Echa'ã joco pe jecuaeño uyembatɨ judío reta. Ayemɨngueta vɨari'ã etei —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Maera pa ndepɨrandu cheve? Epɨrandu uyapɨsaca cheré vae reta pe che jae chupe reta vae re. Jae reta uicuaa che jae vae —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Cua jei ma yave Jesús, penti judío reta itenondegua reta jembiocui joco pe oĩ vae ocua Jesús jova re. —¿Maera pa jucuarãi ndiyemɨngueta sacerdote tenondegua pe? —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","—Icavi'ã ayemɨngueta yave, emɨmbeu mbae ra icavi'ã —jei Jesús—. Ẽrei icavi ayemɨngueta. ¿Maera pa ndecua cheré? —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Jayave Anás omondo Jesús iyocuaa reve Caifás pe - jae vi co sacerdote tenondegua. ");
INSERT INTO gnwNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Jare Simón Pedro uyemboɨ uyepee oĩ. Ĩru vae reta jei chupe: —¿Jae'ã pa co nde penti jemimboe? Pedro uicuacu. Jei: —Jae'ã co che. ");
INSERT INTO gnwNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Penti sacerdote tenondegua jembiocui - jae co jocua cuimbae Pedro uyasɨa inambi chugüi vae jentarã - jei Pedro pe: —Che nduecha co temitɨ reta ñugüɨnoi vae pe jae ndive. ");
INSERT INTO gnwNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pedro jei ye: —Jae'ã co che. Jare cua jei ma yave, uru cuimbae uñee. ");
INSERT INTO gnwNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Jayave güɨraa reta Jesús Caifás jenta güi palacio pe. Neimbove asɨ. Jae reta uique'ã palacio japɨpe pe. Echa'ã uique yave joco pe jocua ara, iporomboe umɨmbeu chupe reta uyemɨnguɨata tẽi co, jare ndarau tẽi ipuere jou tembíu pascua pegua. ");
INSERT INTO gnwNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Jayave Pilato oẽ chupe reta. —¿Mbae re pa pembɨjeco cua cuimbae? —jei chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","—Cua cuimbae jecocavi yave mona, ndarau tẽi numee ndeve —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","—Pe reta etei peraa peãa vaerã peporoyocui rupi —jei Pilato. —Romano reta umaeño'ã oreré nduyuca vaerã quía —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Jucuarãi jei reta, uyeyapo vaerã Jesús jei ma uyeyapota chupe vae. Echa'ã Jesús umɨmbeu ma quirãita co umano. ");
INSERT INTO gnwNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Jayave Pilato uique ye palacio pe jare ueni Jesús. —¿Nde pa co jae judío reta juvicha guasu? —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","—¿Ndeiño pa ndiyemɨngueta jucuarãi, ani ĩru vae reta pa umɨmbeu ndeve cheregua? —jei Jesús. ");
INSERT INTO gnwNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","—Che penti judio'ã co —jei Pilato—. Nerentaɨgua reta jare sacerdote reta itenondegua reta nemee cheve. ¿Mbae pa ndiyapo? —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","—Che co jae penti mburuvicha guasu —jei Jesús—, ẽrei che jae'ã co mburuvicha guasu ɨvɨ pegua reta rami. Che jocua reta rami yave mona, cherembiocui reta uñerãrota tẽi co, agüɨye vaerã añemee judío reta pe. Ẽrei che jae'ã co mburuvicha guasu ɨvɨ pegua reta rami —jei Jesús. ");
INSERT INTO gnwNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Jayave Pilato jei chupe: —¿Nde pa co jae penti mburuvicha guasu? —Nde ndere rami che co jae penti mburuvicha guasu —jei Jesús—. Cuarã ayeyapo cuimbaerã. Cuarã ayu ɨvɨ pe. Ayu amɨmbeu vaerã añete vae. Opaete añete vae güɨrovia vae reta uyapɨsaca chiñee re —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Jayave Pilato upɨrandu chupe: —¿Mbae pa jocua añete vae? Jare cua jei ma yave, Pilato oẽ ye judío reta jovai jare jei chupe reta: —Avãe'ã etei teco jese. ");
INSERT INTO gnwNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ẽrei pe reta jecuaeño pipota ayora vaerã peve penti pereso pascua pe. ¿Pipota pa ayora vaerã peve cua judío reta juvicha guasu? —jei chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Jae reta iñeeãta reve jei: —Agüɨye iyora jocua cuimbae. Iyora oreve Barrabás —jei reta. Jocua Barrabás co jae imonda vae. ");
INSERT INTO gnwNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Jayave Pilato güɨraaca Jesús uinupaca chicote pe. ");
INSERT INTO gnwNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Jare sundaro reta oñope yurãti catuii vae jare umbapúa oñono Jesús iñãca re. Jare omondeca reta Jesús pe temimonde pɨ̃ta vae. ");
INSERT INTO gnwNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Jayave jei reta chupe: —¡Viva, judío reta juvicha guasu! Jayave ocua reta jese ipo pe. ");
INSERT INTO gnwNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Jayave Pilato oẽ ye, jare jei judío reta pe: —Mase, aruta peve picuaa vaerã avãe'ã co teco jese. ");
INSERT INTO gnwNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Jayave Jesús oẽ. Güɨnoi jocua yurãti catuii vae iñãca re jare omonde temimonde pɨ̃ta vae. Jayave Pilato jei chupe reta: —Mase, co oĩ cua cuimbae. ");
INSERT INTO gnwNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Sacerdote reta itenondegua reta jare jembiocui reta uecha yave Jesús, iñeeãta reve jei: —¡Icutuca curusu re, icutuca curusu re! Jayave Pilato jei chupe reta: —Pe reta etei peraa picutuca curusu re. Echa'ã che avãe'ã etei teco jese —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Judío reta jei Pilato pe: —Ore nonoi penti mboroyocui, jare jocua mboroyocui rupi umanota co. Echa'ã jei jae co Tumpa Taɨ —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Cua uyandu yave, Pilato uquɨye ete. ");
INSERT INTO gnwNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Jayave uique ye palacio pe jare upɨrandu Jesús pe: —¿Quía pegua pa nde? Ẽrei Jesús jei'ã mbae ave chupe. ");
INSERT INTO gnwNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Jayave Pilato jei chupe: —¿Maera pa niñee nemoẽ'ã cheve? Che anoi mbaepuere nducutuca vaerã curusu re. Anoi vi mbaepuere ndoyora vaerã. ¿Ndicuaa'ã pa cua? —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","—Tumpa umaeño'ã nderé yave, ndarau tẽi ndepuere cheré —jei Jesús—. Jáeramo chemee ndeve vae iyoa ete ma co. ");
INSERT INTO gnwNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Cua uyandu ma yave, Pilato uipota tẽi oyora Jesús. Ẽrei judío reta iñeeãta reve jei: —Cua cuimbae ndiyora yave, nde ndiyeyocui'ã ma co César pe. Echa'ã ipotave jei jae co mburuvicha guasu vae oyovaicho ma César ndive —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilato cua uyandu yave, güɨnoẽ Jesús jare uguapɨ Empedrado jee vae pe. (Cua co jee Gabata hebreo iñee pe.) Echa'ã joco pe jecuaeño uãa teco güɨnoi vae reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Jare jocua ara judío reta uyeyapɨcatu ñugüɨnoi pascua peguarã, jare ara mbɨte seri ma. Jayave Pilato jei judío reta pe: —Co oĩ peruvicha guasu. ");
INSERT INTO gnwNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Jayave jae reta iñeeãta reve jei: —¡Eraaca cua güi, eraaca cua güi, icutuca curusu re! Pilato upɨrandu chupe reta: —¿Aicutucata pa peruvicha guasu? Jayave sacerdote reta itenondegua reta jei: —Jaeño César oreruvicha guasu. ");
INSERT INTO gnwNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Jayave Pilato umee Jesús chupe reta uicutuca vaerã curusu re. Jayave jae reta uipɨsɨ Jesús güɨraa. ");
INSERT INTO gnwNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jayave Jesús oẽ jare ovoɨ güɨraa icurusu. Jayave sundaro reta güɨraa Jesús Ãcacuerenda jee vae pe. (Cua co jee Gólgota hebreo iñee pe.) ");
INSERT INTO gnwNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Joco pe uicutu reta Jesús curusu re. Uicutu reta vi ĩru mocui cuimbae reta jare oñono penti Jesús iyacata cotɨ jare ĩru iyaso cotɨ. Jesús oĩ mbɨte pe. ");
INSERT INTO gnwNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Jare Pilato uicuatía curusu re oñonoca vaerã. Cuarãi uyecuatía oĩ: “Jesús Nazaret pegua, judío reta juvicha guasu.” ");
INSERT INTO gnwNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Jare jeta judío reta umɨngueta cua uyecuatía oĩ vae. Echa'ã Jesús uyecutuca vae coiño oĩ tenta guasu güi. Jare uyecuatía oĩ hebreo iñee pe jare griego iñee pe jare latín pe. ");
INSERT INTO gnwNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Jayave judío reta isacerdote reta itenondegua reta jei Pilato pe: —Agüɨyeta tẽi co ndicuatía: ‘Judío reta juvicha guasu.’ Ndicuatiata tẽi co: ‘Cua cuimbae jei: Che co jae judío reta juvicha guasu’ —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","—Cua aicuatía vae aicuatía ma co —jei Pilato. ");
INSERT INTO gnwNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Jare sundaro reta uicutu ma yave Jesús, irundɨ reve uyembɨiya Jesús jemimonde re umbɨyao ma yave. Ẽrei jemimonde pucu vae uyembɨvɨvɨ'ã. Uyeyapo penti güiño. Cua vi sundaro reta uequi chugüi. ");
INSERT INTO gnwNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Jayave sundaro reta jei uyupe: —Agüɨye yamondoro. Yayuguari jese, yaicuaa vaerã quía güɨraata vae —jei reta. Cuarãi uyeyapo Tumpa iñee pe uyecuatía oĩ vae. Echa'ã uyecuatía oĩ cuarãi: “Uyuguari reta cheremimonde re, uicuaa vaerã mbae nunga penti penti güɨraa iyupe vaerã.” Jucuarãi uyecuatía oĩ, jare jucuarãi uyapo sundaro reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jare uyemboɨ ñugüɨnoi Jesús icurusu iyɨpɨ pe Jesús ichɨ, jare ichɨ ipɨquɨɨ, jare María - jae co Cleofas jembireco - jare María Magdalena. ");
INSERT INTO gnwNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jesús uecha ichɨ jare jemimboe jae uau vae uyemboɨ ñugüɨnoi coiño chugüi. Jare jei ichɨ pe: —Chesɨ, joco oĩ nemembɨrã. ");
INSERT INTO gnwNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Cua jaɨcue rupi jei jemimboe pe: —Joco oĩ ndesɨrã. Jáeramo jocua ora güive jocua jemimboe güɨraa jenta pe Jesús ichɨ. ");
INSERT INTO gnwNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Cua jaɨcue rupi Jesús jei: —Cheúe. Cuarãi uyeyapo ma Tumpa iñee pe uyecuatía oĩ vae. Echa'ã Jesús uicuaa opaete iparavɨquɨ opa ma. ");
INSERT INTO gnwNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Jare joco pe oĩ vinagre penti yapepo pe. Jayave umãquɨ reta esponja vinagre pe. Jayave oñono reta ɨvɨra re jare omondo Jesús iyuru pe. ");
INSERT INTO gnwNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jare Jesús jou ma yave vinagre, jei: —Opa ma ayapo Tumpa jei vae. Jayave iñãcatindɨ jare umano. ");
INSERT INTO gnwNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Jare jocua ara judío reta uyeyapɨcatu ñugüɨnoi pascua peguarã. Jáeramo uyerure reta Pilato pe omopẽca vaerã curusu re ñugüɨnoi vae reta itɨmaca jare güɨraaca vaerã joco güi. Echa'ã uipota'ã jetecue reta upɨta vaerã curusu reta re jocua mbutuu ara pe. Echa'ã jocua mbutuu ara uyepɨu reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Jáeramo sundaro reta yugüɨraa omopẽ penti cuimbae Jesús ndive curusu re uyecutu oĩ vae itɨmaca. Jayave omopẽ ĩru cuimbae itɨmaca. ");
INSERT INTO gnwNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ẽrei yugüɨraa yave Jesús pe, uecha umano ma. Jáeramo omopẽ'ã itɨmaca. ");
INSERT INTO gnwNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ẽrei penti sundaro uicutu Jesús iyɨque pe, jare oẽ voi tugüɨ jare ɨ. ");
INSERT INTO gnwNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Jare uecha vae umɨmbeu cua, pe reta vi perovia vaerã. Jare cua umɨmbeu vae añete co. Echa'ã jae uicuaa cavi umɨmbeu vae añete co. ");
INSERT INTO gnwNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Echa'ã opaete cua uyeyapo Tumpa iñee pe uyecuatía oĩ vae uyeyapo vaerã. Echa'ã uyecuatía oĩ cuarãi: “Ndarau icãgüe ave opẽ.” ");
INSERT INTO gnwNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Jare: “Umaeta reta jocua uicutu vae re.” Jucuarãi uyecuatía oĩ. ");
INSERT INTO gnwNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Cua jaɨcue rupi José Arimatea pegua uyerure Pilato pe güɨraa vaerã Jesús jetecue. Cua José co jae penti Jesús jemimboe, ẽrei uyecuaaca'ã. Echa'ã uquɨye judío reta güi. Jayave Pilato jei chupe ipuere güɨraa Jesús jetecue. ");
INSERT INTO gnwNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nicodemo ou vi - jae co tenonde yave oo pɨ̃tu yave Jesús pe vae. Jae güeru mirra jare áloes uyeacue vae. Uepitɨ treinta kilo rupi. ");
INSERT INTO gnwNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Jayave umbɨgüeyɨ reta Jesús jetecue, jare oñoma mbae ipiche cavi vae reta reve nieso pe. Echa'ã jucuarãiño mai uyapo judío reta, jetecue oñotɨ yave. ");
INSERT INTO gnwNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jare Jesús uyecutuca vae pe oĩ penti temitɨ reta ñugüɨnoi vae, jare jocua ipɨte pe oĩ penti teõgüerɨru ipɨau vae - ndei quía uñeñono pɨpe vae pe. ");
INSERT INTO gnwNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Jocua ara judío reta uyeyapɨcatu ñugüɨnoi pascua peguarã. Jáeramo oñono reta Jesús jetecue jocua teõgüerɨru pe. Echa'ã coiño oĩ. ");
INSERT INTO gnwNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Jare ndei cõe cavi mbove domingo ara pe María Magdalena ou teõgüerɨru pe, jare uecha ita uyembɨsɨrɨ ma teõgüerɨru güi. ");
INSERT INTO gnwNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Jayave osi oo Simón Pedro jare ĩru temimboe Jesús uau vae ñugüɨnoi vae pe, jare jei chupe reta: —Güɨraa reta ma yandeYa teõgüerɨru güi, jare nduicuaa'ã quiape ra oñono reta. ");
INSERT INTO gnwNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Jayave Pedro jare ĩru temimboe oẽ pãve jare yugüɨraa teõgüerɨru cotɨ. ");
INSERT INTO gnwNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Mocui reve osi pãve yugüɨraa, ẽrei ĩru temimboe iñacua ete Pedro güi, jare oo uvãe teõgüerɨru pe Pedro jenonde. ");
INSERT INTO gnwNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Jayave ipe umae vaerã japɨpe cotɨ, jare uecha nieso reta joco pe oĩ, ẽrei uique'ã. ");
INSERT INTO gnwNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Jayave Simón Pedro oo uvãe jaɨcue rupi, jare uique teõgüerɨru pe. Jare uecha nieso reta joco pe oĩ. ");
INSERT INTO gnwNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Uecha vi nieso Jesús iñãca re tenonde yave uñeñono vae uñeñomañoma oĩ tee ĩru nieso reta güi. ");
INSERT INTO gnwNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Jayave jocua ĩru temimboe vi - jae Pedro jenonde oo uvãe vae - uique teõgüerɨru pe, jare uecha yave, upurugüɨrovia. ");
INSERT INTO gnwNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Echa'ã ndei uicuaa cavi reta Tumpa iñee pe uyecuatía oĩ vae quirãi Jesús icove yeta ou umanocue vae reta ipɨte güi. ");
INSERT INTO gnwNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Jayave temimboe reta yugüɨraa ye jenta pe. ");
INSERT INTO gnwNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ẽrei María uyemboɨ oĩ teõgüerɨru iyɨpɨ pe. Uyao oĩ. Jare uyao oĩ rambueve, ipe umae vaerã teõgüerɨru japɨpe cotɨ. ");
INSERT INTO gnwNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Jare uecha mocui ángel reta uguapɨ ñugüɨnoi Jesús jetecue uñeñono vae pe. Jemimonde tĩ asɨ co. Penti uguapɨ oĩ Jesús iñãca jendacue cotɨ jare ĩru uguapɨ oĩ Jesús ipɨta jendacue cotɨ. ");
INSERT INTO gnwNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ángel reta jei María pe: —¿Maera pa ndiyao? —Güɨraa reta ma cheYa, jare aicuaa'ã quiape ra oñono reta —jei María. ");
INSERT INTO gnwNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Cua jei ma yave, María uyerova jare uecha Jesús uyemboɨ oĩ joco pe. Ẽrei uicuaa'ã jae co Jesús vae. ");
INSERT INTO gnwNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jayave Jesús jei chupe: —Cuña, ¿maera pa ndiyao? ¿Quía pa ndeeca? María ipɨa pe uyemɨngueta tẽi jae co temitɨ reta iyandarecoa. Jáeramo jei chupe: —Carai, nde nderaa yave, emɨmbeu cheve quiape niñono, jare che araata. ");
INSERT INTO gnwNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","—¡María! —jei Jesús chupe. María uyerova ye icotɨ jare jei chupe: —Raboni. (Cua uipota jei: “Oporomboe vae”.) ");
INSERT INTO gnwNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jayave Jesús jei chupe: —Agüɨye chepɨsɨ. Echa'ã ndei ayupi cheRu pe. Ẽrei ecua emɨmbeu cherɨvɨ reta pe che jae cuarãi: ‘Aata ma cheRu pe - jae co peRu vi. Jae co cheTumpa - jae co peTumpa vi’ —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Jayave María Magdalena oo umɨmbeu Jesús jemimboe reta pe. —Aecha ma yandeYa —jei. Jayave umɨmbeu chupe reta Jesús jei chupe vae. ");
INSERT INTO gnwNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Jare jocua pɨ̃tu - domingo ara pe - Jesús jemimboe reta uyembatɨ jare uyuquenda jonque reta. Echa'ã jae reta uquɨye judío reta güi. Jayave ou Jesús uyemboɨ ipɨte pe jare jei chupe reta: —Pepɨacatu. ");
INSERT INTO gnwNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Cua jei ma yave, Jesús uechaca chupe reta ipo jare iyɨque. Jayave Jesús jemimboe reta uyerovia. Echa'ã uecha ma iYa. ");
INSERT INTO gnwNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jayave Jesús jei ye chupe reta: —Pepɨacatu. CheRu chembou. Jae ramiño vi che pomondo —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Jare cua jei ma yave, iputũé omoẽ icotɨ reta jare jei: —Amee ma peve Espíritu Santo. ");
INSERT INTO gnwNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Pembɨasa yave ipotave vae pe imbaeyoa, imbaeyoa uyembaita co. Jare pembɨasa'ã yave ipotave vae pe imbaeyoa, imbaeyoa ndarau uyembai —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Jare jocua doce jemimboe reta güi penti Tomás jee vae - jae co Choguaquiri pe uyembɨjee vae - oĩ'ã joco pe ĩru reta ndive Jesús ou yave. ");
INSERT INTO gnwNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Jare ĩru Jesús jemimboe reta jei Tomás pe: —Nduecha ma yandeYa. Ẽrei Tomás jei: —Aecha'ã yave uyecuturendacue ipo re jare añono'ã yave chepoãca uyecuturendacue pe jare añono'ã yave chepo iyɨque pe, ndarau arovia. ");
INSERT INTO gnwNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ocho ara uasa ma yave, temimboe reta ñugüɨnoi ye jocua o pe. Tomás joco pe oĩ vi. Yepe tẽi onque reta uyeyuquenda ñugüɨnoi, ẽrei Jesús ou uyemboɨ ipɨte pe jare jei: —Pepɨacatu. ");
INSERT INTO gnwNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Jayave jei Tomás pe: —Emae chepo re. Iñono cua pe nepoãca. Eupi ndepo iñono cheyɨque pe. Agüɨye ma ico ndepurugüɨrovia mbae reve. Mburugüɨrovia reve ma ico —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","—Nde co jae cheYa jare cheTumpa —jei Tomás. ");
INSERT INTO gnwNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jayave Jesús jei: —Ndepurugüɨrovia ma cherecha ramo. Tuicha uyeroviata jocua cherecha mbae reve upurugüɨroviata vae reta —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jare Jesús uyapo jemimboe reta jovaque jeta ĩru mɨacañɨ reta uicuaaca vaerã quía co jae, yepe tẽi uyecuatia'ã oĩ cua pe. ");
INSERT INTO gnwNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ẽrei aicuatía cua pe uyecuatía oĩ vae, perovia vaerã Jesús co jae Cristo - jae co Tumpa Taɨ - jare penoi vaerã tecove opa mbae vae cua perovia yave. ");
INSERT INTO gnwNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Cua jaɨcue rupi Jesús uyecuaa ye jemimboe reta pe ɨ Tiberias jee vae iyɨpɨ pe. Uyecuaa chupe reta cuarãi: ");
INSERT INTO gnwNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simón Pedro jare Tomás - jae co Choguaquiri pe uyembɨjee vae - jare Natanael Caná pegua - jocua Caná Galilea pegua co - jare Zebedeo taɨ reta jare mocui ĩru temimboe reta uyembatɨ. ");
INSERT INTO gnwNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Jayave Simón Pedro jei ĩru reta pe: —Aata pira aipɨsɨ vaerã. —Ore ndoota vi nde ndive —jei reta. Jayave yugüɨraa uyupi chalana pe. Ẽrei jocua pɨ̃tu uipɨsɨ'ã mbae ave. ");
INSERT INTO gnwNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Jare cõeta ma yave Jesús uyemboɨ oĩ ɨ jembeɨ pe. Ẽrei temimboe reta uicuaa'ã jae co Jesús. ");
INSERT INTO gnwNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jayave Jesús jei chupe reta: —Cherɨvɨ reta, ¿pipɨsɨ ma pa mbae? —Nduipɨsɨ'ã mbae ave —jei reta chupe. ");
INSERT INTO gnwNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","—Pemombo pepɨsa chalana iyacata cotɨ jare pipɨsɨta pira reta —jei Jesús. Jayave jucuarãi uyapo reta, jare ipuere'ã ma umɨãta pɨsa ɨ güi jeta ete pira omboa ramo. ");
INSERT INTO gnwNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Jayave jocua temimboe Jesús uau vae jei Pedro pe: —Jae co yandeYa. Simón Pedro uyandu yave jocua cuimbae co jae iYa, uyemonde jare ugüeyɨ voi ɨ pe. Echa'ã omboi jemimonde uparavɨquɨ cavi vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Jare ĩru reta yugüeru chalana pe. Jae reta umɨãta pɨsa pira reve. Echa'ã coiño ñugüɨnoi ɨ jembeɨ güi - cien metro rupi. ");
INSERT INTO gnwNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Jare yugüeru oẽ ɨ güi yave, uecha tata tatãpɨ reve joco pe. Uecha vi pira tatãpɨ iárambo jare mbɨyape vi. ");
INSERT INTO gnwNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jayave Jesús jei chupe reta: —Peru mbovɨ pira pipɨsɨ vae. ");
INSERT INTO gnwNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Jayave Simón Pedro uyupi ye chalana pe jare umɨãta pɨsa ɨ güi. Pɨsa tɨnee pira tuichacue vae pe - güɨnoi ciento cincuenta y tres. Ẽrei yepe tẽi jeta ete, ẽrei omondoro'ã pɨsa. ");
INSERT INTO gnwNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jayave Jesús jei chupe reta: —Peyu rani pecaru. Jare penti ave jemimboe iquɨrẽɨ'ã upɨrandu chupe: “¿Quía pa co nde?” Echa'ã uicuaa jae co iYa. ");
INSERT INTO gnwNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jayave Jesús oo uipɨsɨ mbɨyape umee chupe reta. Jae ramiño vi umee chupe reta pira. ");
INSERT INTO gnwNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Jare mbapɨ vese ma cua re Jesús uyecuaa jemimboe reta pe icove ye güive ou umanocue vae reta ipɨte güi. ");
INSERT INTO gnwNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ucaru reta ma yave, Jesús jei Simón Pedro pe: —Simón, Jonás taɨ, ¿cherau ete pa cua reta güi? —Nduau, cheYa —jei Pedro—. Ndicuaa che nduau co. —Emɨngaru cheovecha-raɨ reta —jei Jesús chupe. ");
INSERT INTO gnwNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jesús jei ye chupe: —Simón, Jonás taɨ, ¿cherau pa? —Nduau, cheYa —jei ye Pedro—. Ndicuaa che nduau co. —Iyandareco cheovecha reta re —jei Jesús. ");
INSERT INTO gnwNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Jesús jei ye chupe mbapɨ vecea re: —Simón, Jonás taɨ, ¿cherau pa? Pedro ipɨatɨtɨ. Echa'ã mbapɨ vese ma Jesús jei chupe: “¿Cherau pa?” Jayave jei ye: —CheYa, nde ndicuaa opaete. Nde ndicuaa che nduau co. —Emɨngaru cheovecha reta —jei Jesús chupe—. ");
INSERT INTO gnwNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Añete che jae ndeve, nde ndetaɨrusu yave, ndiyemonde jare ndeguata ndipota ndeo vae rupi. Ẽrei nendechi ma yave, ndeupita ndeyɨva jare ĩru vae omondecata ndeve jare ndereraata ndipota'ã ndeo vae pe —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Cua jei Jesús umɨmbeu vaerã quirãita co umano Pedro. Jare Pedro umano yave, Tumpa uyembɨadoracata imano rupi. Jayave Jesús jei Pedro pe: —Eyu che ndive. ");
INSERT INTO gnwNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pedro uyerova yave, uecha jocua temimboe Jesús uau vae ou jaɨcue. Jocua temimboe co jae tenonde yave ucaru ñugüɨnoi yave ucaru oĩ Jesús iyɨpɨ pe jare: “¿Quía pa nemeeta, CheYa?” jei chupe vae. ");
INSERT INTO gnwNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Jare Pedro uecha yave jocua temimboe, upɨrandu Jesús pe: —¿Mbae pa uyeyapota chupe, cheYa? ");
INSERT INTO gnwNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesús jei chupe: —Che aipota yave jae ico vaerã che ayu ye regua, jocua mbae'ã co ndeve. Nde eyu che ndive —jei. ");
INSERT INTO gnwNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Jare opaete upurugüɨrovia vae reta uicuaa cua Jesús jei vae, jare ipɨa pe uyemɨngueta tẽi cua uipota jei jocua jemimboe ndarau umano. Ẽrei Jesús jei'ã ndarau umano. Jaeño jei: “Che aipota yave jae ico vaerã che ayu ye regua, jocua mbae'ã co ndeve.” ");
INSERT INTO gnwNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Che co jae jocua Jesús jemimboe, jare che amɨmbeu añete co cua pe uyecuatía oĩ vae. Echa'ã che aicuatía cua. Jare opaete nduicuaa cua amɨmbeu vae añete co. ");
INSERT INTO gnwNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jare ime ye jeta mbaembae Jesús uyapo vae. Opaete cua mbaembae regua uyecuatía oĩ yave penti penti rupi, uatata opaete tupapire jendarã cua ɨvɨ pe. Amén.");
INSERT INTO gnwNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teófilo, tenonde aicuatía ndeve vae pe amɨmbeu ndeve opaete Jesús uyapo vae jare jocua oporomboe jese vae. ");
INSERT INTO gnwNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Ndei oo ye ara pe mbove, umee mboroyocui reta Espíritu Santo rupi jemimondo uiparavo vae reta pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Jesús imano rendave pe, uyecuaa chupe reta. Jae reta uicuaa catu jae icove ye co jeta mbaembae uyapo jovaque vae jeco pegua. Jesús uyecuaa chupe reta cuarenta ara, jare umɨngueta reta Tumpa iporoyocuia re. ");
INSERT INTO gnwNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Jae reta uyembatɨ yave, Jesús oyocui agüɨye vaerã yugüɨraa tenta guasu Jerusalén güi. Oyocui uãro vaerã yandeRu umeeta chupe reta vae. Jesús jei chupe reta: —Jocua re chemiari ma peve. ");
INSERT INTO gnwNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Juan upurumbɨbautiza ɨ pe, ẽrei pe reta piyembɨbautizacata Espíritu Santo pe mbovɨ ara rupi —jei. ");
INSERT INTO gnwNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Jayave yatɨ vae reta upɨrandu Jesús pe: —OreYa, ¿nemaeñota pa Israel pegua reta re uyeyapo vaerã mburuvicha retarã cua ara reta rupi? ");
INSERT INTO gnwNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","—Ndarau picuaa jocua ara regua —jei Jesús—. Jaeño cheRu jeita jocua re —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ẽrei pe reta penoita Espíritu Santo imbaepuere, ou yave peve, jare pe reta chemɨmbeuta Jerusalén pe, opaete Judea rupi, Samaria rupi jare opaete ɨvɨ rupi —jei chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Jare Jesús opa imiari chupe reta yave, oo ɨvate, jae reta umae jese rambueve. Jayave amapɨ̃tu umbɨyasoi Jesús, jare uecha'ã ma reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Jare umae ngatu ñugüɨnoi rambueve ara cotɨ, Jesús oo rambueve, mocui cuimbae uyecuaa jae reta iyɨpɨ pe. Cua cuimbae reta jemimonde tĩ asɨ. ");
INSERT INTO gnwNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Cua reta jei chupe reta: —Cuimbae Galilea pegua reta, ¿maera pa piyemboɨ pemae peĩ ara cotɨ? Jesús oo ma pegüi ara pe. Ẽrei jae etei ou yeta jucuarãi ete, peecha oo rami —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Jayave temimondo reta yugüeru ye Jerusalén pe ɨvɨtu guasu Olivos jee vae güi. Jocua ɨvɨtu guasu coiño oĩ Jerusalén güi. Judío reta iporoyocui umaeño uguata vaerã joco pe Jerusalén güi mbutuu ara pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Yugüeru uvãe yave, uique reta penti tenta pe, jare uyupi o ɨvate vae pe. Joco pe yugüɨreco Pedro, Jacobo, Juan, Andrés, Felipe, Tomás, Bartolomé, Mateo, Alfeo taɨ Jacobo jee vae, Simón Zelote jare Jacobo tɨvɨ Judas jee vae. ");
INSERT INTO gnwNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Opaete cua reta, jare Jesús ichɨ María jare ĩru cuña reta, jare Jesús tɨvɨ reta jecuae uyerure penti ramiño. ");
INSERT INTO gnwNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Upurugüɨrovia vae joco pe ñugüɨnoi vae reta ciento veinte rupi. Jare penti ara Pedro uyemboɨ ipɨte pe jare jei: ");
INSERT INTO gnwNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","—Cherɨvɨ reta, jupi co uyeyapo vaerã David aracae uicuatía Judas re vae. Espíritu Santo etei cua umɨmbeu yandeve David rupi. Judas güɨraa cuimbae reta Jesús oĩ vae pe uipɨsɨca vaerã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Jae icose yande ndive, jare uyeparavo co uyapo vaerã cua mbaravɨquɨ —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Jae uipɨsɨ corepoti icavi mbae vae uyapo vae re. Jayave corepoti pe ogua penti ɨvɨ. Joco pe oa ɨvate güi, jare jɨe osoro, jare opaete ichuri uyecuavo —jei Pedro—. ");
INSERT INTO gnwNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Cua jerãcua opaete Jerusalén pegua reta pe. Jáeramo jocua ɨvɨ jee Acéldama jae reta iñee pe —jei—. (Acéldama uipota jei: “Ɨvɨ tugüɨ jepɨcue”.) ");
INSERT INTO gnwNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Echa'ã uyecuatía oĩ Tumpa iñee pe Salmo reta pe cuarãi: ‘Tuyeyapo ɨvɨ ipo mbae ico vae, jare agüɨye quía tuico pɨpe.’ Jare: ‘Ĩru vae tuyapo chugüi iparavɨquɨ.’ Jucuarãi uyecuatía oĩ —jei chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Ime cua pe ñugüɨnoi cua cuimbae reta. Jae reta yugüɨreco yande ndive, yandeYa Jesús ico yande ndive rambueve. Echa'ã yugüɨreco yande ndive Juan umbɨbautiza Jesús güive Jesús yandepɨte güi oo regua —jei Pedro—. Jáeramo icavi co cua cuimbae reta güi penti yaiparavo vaerã. Jae umɨmbeuta ĩru vae reta pe yande ndive Jesús icove ye co ou umanocue vae reta ipɨte güi —jei chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Jayave uiparavo reta mocui cuimbae. Penti jee co José Barsabás - jae co uyembɨjee Justo pe vae. Ĩru cuimbae jee co Matías. ");
INSERT INTO gnwNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Jayave uyerure reta Tumpa pe cuarãi: —OreYa, nde ndicuaa opaete vae ipɨa. Eechaca oreve quía nunga ra ndiparavo ma cua mocui cuimbae güi, ");
INSERT INTO gnwNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","jae omborɨ vaerã cua mbaravɨquɨ pe, jare ico vaerã nderemimondorã. Judas opia cua mbaravɨquɨ güi, icavi mbae vae uyapo ramo, jare oo ma jendarã jae uiparavo vae pe —jei reta Tumpa pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Jayave uyuguari reta jee re, uicuaa vaerã quía nunga ra Tumpa uiparavo ma. Jare uiparavo Matías, jare jae uyeyapo Jesús jemimondorã ĩru once reta ndive. ");
INSERT INTO gnwNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pentecostés ara pe opaete upurugüɨrovia vae reta penti ramiño uyembatɨ. ");
INSERT INTO gnwNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Jare aramoiño ou ara güi jɨapu vae penti ɨvɨtu tanta uyepeyu vae rami. Tanta jɨapu uguapɨ ñugüɨnoi vae pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Jayave uyecuaa chupe reta tataendɨ rami. Cua uyecuaa penti penti iyapɨte re. ");
INSERT INTO gnwNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Jayave opaete joco pe ñugüɨnoi vae reta tɨnee Espíritu Santo pe, jare umbɨpɨ uyemɨngueta reta ambɨe vae iñee Espíritu Santo umee chupe reta uyemɨngueta vaerã vae pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Jare jocua ara reta pe yugüɨreco Jerusalén pe jeta judío ambɨembɨe ɨvɨ güi yugüeru vae reta. Cua reta umbɨadora Tumpa. ");
INSERT INTO gnwNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Jare cua jɨapu vae uyendu yave, uyembatɨ jeta vae, jare opaete vae ipɨacañɨ. Echa'ã upurugüɨrovia vae reta uyemɨngueta ñugüɨnoi, jare penti penti yatɨ vae reta uyandu iñeei pe jei vae. ");
INSERT INTO gnwNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ipɨacañɨ reve jei reta: —¡Mase, Galilea pegua reta co opaete cua uyemɨngueta vae reta! ");
INSERT INTO gnwNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Quirãi ra yayandu uyemɨngueta ñaniñee ñanemichi güive yayemɨngueta pɨpe vae pe? —jei reta—. ");
INSERT INTO gnwNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Yande co jae Parto pegua, Medo, Elam, Mesopotamia, Judea, Capadocia, Ponto, Asia, ");
INSERT INTO gnwNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","11","Frigia, Panfilia jare Egipto pegua, jare Africa pegua Cirene iyɨpɨ pe yaico vae, jare romano reta cua pe yaico vae, Creta jare Arabia pegua. Yande co jae judío reta jare judiorã yayeyapo vae reta. Opaete yayandu ñaniñee pe uyemɨngueta ñugüɨnoi mɨacañɨ Tumpa uyapo vae re —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Jare opaete yatɨ vae reta ipɨacañi jare jei uyupe: —¿Mbae ra co cua? ");
INSERT INTO gnwNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ĩru vae reta oyoyai. —Usavɨpo ñugüɨnoi —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Jayave Pedro uyemboɨ jocua ĩru once Jesús jemimondo reta ndive, jare jei yatɨ vae reta pe iñeeãta reve: —Cuimbae Judea pegua reta, jare opaete pico Jerusalén pe vae. Cua regua pipota picuaa yave, piyapɨsaca chiñee re —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Pe reta pepɨa pe piyemɨngueta tẽi cua reta usavɨpo ñugüɨnoi. Ẽrei jucuarãi'ã co. Echa'ã neimboveño co —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Tumpa iñee aracae umɨmbeu vae Joel imiari cua re. Jae jei cuarãi: ");
INSERT INTO gnwNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Jare ara taɨcuegua reta pe’ —jei Tumpa— ‘ameeta cheEspíritu opaete vae pe. Jare peraɨ reta jare perayɨ reta umɨmbeuta chiñee. Jare cunumi reta jare indechi vae reta upauta. ");
INSERT INTO gnwNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Jare jocua ara reta pe ameeta cheEspíritu cuimbae reta jare cuña reta uyeyocui cheve vae pe, jare umɨmbeuta reta chiñee. ");
INSERT INTO gnwNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Jare tambou mɨacañɨ reta ara re jare ɨvɨ pe. Imeta tugüɨ, tata jare tatãti. ");
INSERT INTO gnwNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Guarasɨ uñemɨpɨ̃tumimbita, jare yasɨ uyeyapota tugüɨ rami, ndei peYa ivãe ara ou mbove. Jocua ara opaete vae ipɨacañɨta co. ");
INSERT INTO gnwNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Jare opaete uyerureta peYa pe omborɨ vaerã vae reta uyembɨasacata co’ —jei. Jucuarãi jei Joel —jei Pedro chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Pedro jei vi chupe reta: —Cuimbae Israel pegua reta, piyapɨsaca cua re. Tumpa uyapoca pepɨte pe mɨacañɨ reta Jesús Nazaret pegua pe. Jucuarãi Tumpa uechaca peve Jesús añete vae co. Cua picuaa catu co pe reta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Cua Jesús uñemee umano vaerã, Tumpa jei vae uyeyapo vaerã. Tumpa uicuaa opaete ndei uyeyapo mbove. Ẽrei pe reta pipɨsɨ picutuca curusu re cuimbae jeco pochɨ vae reta pe piyucaca —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ẽrei Tumpa oyora mano yandepɨsɨ pɨpe vae güi, jare umbɨjecove ye güeru umanocue vae reta ipɨte güi. Echa'ã mano ipuere'ã etei oyopia Jesús —jei Pedro—. ");
INSERT INTO gnwNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Echa'ã David jei Jesús re cuarãi: ‘Aecha cheYa jecuaeño cherovai. Cheacata pe oĩ ramo, ndarau aquɨye. ");
INSERT INTO gnwNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Jáeramo ayerovia chepɨa pe, jare chemiari ayecou reve. Aicota co aãro reve. ");
INSERT INTO gnwNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Echa'ã ndeeyata'ã cherecove umanocue vae reta ñugüɨnoi vae pe. Che co jae jupi vae. Nemaeñota'ã cheretecue re icumegua vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ndicuaaca cheve quirãi aico vaerã ayerovia reve, jare ayerovia eteta vi nde ndive aĩ yave.’ Jucuarãi jei David —jei chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Cherɨvɨ reta, chepuere chemiari peve yandetenondegua David re. Jae umano jare uñeñotɨca, jare iñeñotɨcarenda imeño oĩ yande ndive —jei Pedro—. ");
INSERT INTO gnwNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ẽrei Tumpa jei jee re David pe umbɨguapɨta co David iguapɨa pe David iñemoñaa reta güi penti oporoyocui vaerã. Jocua co jae Cristo, Tumpa ombou vae. Opaete cua David uicuaa. Echa'ã David Tumpa iñee aracae umɨmbeu vae ico ramo, ");
INSERT INTO gnwNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","uicuaa ndei uyeyapo mbove, jare imiari Cristo icove yeta ou umanocue vae reta ipɨte güi vae re. Echa'ã jei Cristo re uyeeyata'ã co jecove umanocue vae reta ñugüɨnoi vae pe, jare icumeguata'ã co jetecue —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Tumpa umbɨjecove ye cua Jesús güeru umanocue vae reta ipɨte güi, jare ore opareve cua numɨmbeu ĩru vae reta pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Tumpa güɨraa ma ara pe imbaepuere pe, jare umee chupe jocua jei umeeta chupe Espíritu Santo vae. Jáeramo Jesús etei ombou cua peecha jare piyandu vae —jei Pedro chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Echa'ã David uyupi'ã ara pe. Ẽrei jae etei jei cuarãi: ‘YandeYa jei cheYa pe: Eguapɨ cheyɨpɨ pe cheacata cotɨ, ");
INSERT INTO gnwNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","nderovaicho reta opa amɨamɨri regua’ —jei. Jucuarãi jei David —jei Pedro chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Pe reta co jae Israel pegua reta. Jáeramo picuaa catu cua. Pe reta picutuca Jesús, ẽrei Tumpa uyapo ma yandeYarã - jae co Cristo —jei Pedro. ");
INSERT INTO gnwNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Cua uyandu reta yave, tuicha rupi ipɨatɨtɨ reta, jare upɨrandu Pedro jare ĩru Jesús jemimondo reta pe: —Orerɨqueɨ reta, ¿mbae pa nduyapota? ");
INSERT INTO gnwNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Jayave Pedro jei chupe reta: —Peeya piyemɨngueta icavi mbae vae pepɨa pe oĩ vae, jare piyembɨbautizaca Jesucristo jee re, Tumpa umbɨasa vaerã peve pembaeyoa reta. Jare jae umeeta peve Espíritu Santo —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Echa'ã cua Tumpa jei umeeta vae co jae pembaerã, peraɨ reta peguarã, opaete mbɨrɨ ñugüɨnoi vae reta peguarã jare opaete yandeYa Tumpa uenita vae reta peguarã —jei. ");
INSERT INTO gnwNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Jare Pedro umbɨaracuaa jeta ye ye. Jei chupe reta: —Añave yugüɨreco vae reta icavi mbae vae uyapo. Piyembɨasaca pe reta cua reta güi —jei. ");
INSERT INTO gnwNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Jayave Pedro jei vae güɨrovia vae reta uyembɨbautizaca, jare jocua ara tres mil rupi uñemɨĩru upurugüɨrovia vae reta ndive. ");
INSERT INTO gnwNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Jare jecuae upurugüɨrovia vae reta uyemboe Jesús jemimondo reta iporomboe re, jare opaete penti ramiño ñugüɨnoi. Jecuae uyembatɨ, umbɨyao tembíu uyupe, jare uyerure Tumpa pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Jare opaete tenta guasu pegua reta ipɨacañɨ, jare Jesús jemimondo reta uyapo jeta mɨacañɨ reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Jare opaete upurugüɨrovia vae reta uyembatɨ, jare opaete imbaembae reta penti ramiño co. ");
INSERT INTO gnwNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Jare umee imbaembae reta, jare umbɨyao jepɨcue mbaetɨ mbae güɨnoi vae reta pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Jare opa ara yugüɨraa pãve uyembatɨ Tumpa jo pe. Jare tenta tenta rupi umbɨyao tembíu uyupe jare ucaru pãve reta uyerovia jare ipɨacatu reve. ");
INSERT INTO gnwNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Jae reta umbɨadora Tumpa, jare opaete tenta guasu pegua reta umae cavi jese reta. Jare opa ara yandeYa umɨĩru jae reta ndive uyembɨasaca vae reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Pedro jare Juan yugüɨraa pãve Tumpa jo pe, Tumpa pe uyerure vaerã, mbapɨ ora ma caaru yave. ");
INSERT INTO gnwNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Jare ĩru vae reta güeru opa ara rupi penti cuimbae ipuere mbae uguata vae oñono Tumpa jo jonque pe. Cua onque jee co ipõra vae. Cuimbae ichɨ güi oa güive ipuere'ã etei uguata. Jocua onque pe cuimbae uyerure corepoti re Tumpa jo pe uique vae reta pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Cuimbae uecha Pedro jare Juan ndei uique Tumpa jo pe mbove, jare uyerure corepoti re chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Jayave Pedro jare Juan umae ngatu jese, jare Pedro jei: —Emae oreré. ");
INSERT INTO gnwNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Jayave cuimbae umae ngatu jese reta, umeeta echa mbae chupe ramo. ");
INSERT INTO gnwNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ẽrei Pedro jei: —Mbaetɨ anoi corepoti jare oro. Ẽrei anoi vae tamee ndeve. Jesucristo Nazaret pegua jee re epũa jare eguata —jei chupe. ");
INSERT INTO gnwNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Jayave Pedro uipɨsɨ cuimbae ipo iyacata pe umupũa. Jare jupivoiño ipɨrãta cuimbae ipɨ jare ipɨñúa. ");
INSERT INTO gnwNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Jare cuimbae uyemboɨ voi. Jayave uguata jare uique jae reta ndive Tumpa jo pe. Uguata jare upɨrɨrɨquɨrɨquɨ oo, jare umbɨadora Tumpa. ");
INSERT INTO gnwNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Jare opaete tenta guasu pegua reta uecha uguata jare umbɨadora Tumpa. ");
INSERT INTO gnwNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Uicuaa reta jae co uguapɨse Tumpa jo jonque ipõra vae pe uyerure corepoti re vae. Jare ipɨacañɨ reta. Uquɨye reta vi cua uyeyapo cuimbae pe vae re. ");
INSERT INTO gnwNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Cuimbae ucuera ma vae uyepɨsɨ Pedro jare Juan re. Jare opaete tenta guasu pegua reta osi uyembatɨ ipɨacañɨ reve jae reta ñugüɨnoi vae pe oca Salomón jee vae pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Jayave Pedro uecha yave, jei tenta guasu pegua reta pe: —Cuimbae Israel pegua reta, ¿maera pa pepɨacañɨ cua re? ¿Maera pa pemae ngatu oreré? ¿Pepɨa pe piyemɨngueta pa oreiño nduyapo uguata vaerã cua cuimbae orembaepuere rupi ani jupi vae nduyapo ramo? Jucuarãi'ã co —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Abraham, Isaac, Jacob jare yandetenondegua reta iTumpa umbɨadoraca ma Jesús - jae co Tumpa Taɨ. Cua Jesús pe reta pemee, jare perɨ̃ro Pilato jovai. Echa'ã Pilato jei tẽi oyoraca vaerã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ẽrei pe reta perɨ̃ro cua Jesús - jae co iyoa mbae vae jare jupi vae - jare piyerure Pilato pe oyoraca vaerã peve penti upuruyuca vae —jei Pedro—. ");
INSERT INTO gnwNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Jare piyucaca jocua tecove umee yandeve vae. Jae co Tumpa umbɨjecove ye güeru umanocue vae reta ipɨte güi. Jocua co ore numɨmbeu nduico —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Mburugüɨrovia Jesús jee re vae jeco pegua, jae jee umbɨgüera cua cuimbae pe reta peecha jare picuaa vae. Añete co, jocua mburugüɨrovia Jesús umee vae umbɨgüera cavi ete cua cuimbae opaete pe reta perovaque —jei chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Añave, cherɨvɨ reta, aicuaa peruvicha reta jare pe reta vi piyapo cua icavi mbae vae, picuaa'ã ramo —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ẽrei jucuarãi uyapo Tumpa, opaete iñee aracae umɨmbeu vae reta jei rami. Echa'ã jei reta Cristo uiporarañotai co —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Jayave peeya piyemɨngueta icavi mbae vae pepɨa pe oĩ vae jare piyerova Tumpa cotɨ, pembaeyoa reta uyembai vaerã, jare ou vaerã yandeYa güi ara mbɨacatu pegua reta, ");
INSERT INTO gnwNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","jare Tumpa ombou ye vaerã Jesucristo tenonde yave jerãcua peve vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Jae upɨtata ara pe opaete mbaembae uyeyapɨcatu cavi regua. Jocua mbaembae re Tumpa imiari oñono tee iñee umɨmbeu vaerã vae reta rupi aracae güive —jei Pedro chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Echa'ã Moisés jei yandetenondegua reta pe: ‘YandeYa Tumpa ombouta peve iñee umɨmbeuta vae perɨvɨ reta ipɨte güi, chembou rami. Piyapɨsacata jese opaete jeita peve vae re. ");
INSERT INTO gnwNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Jare ime yave quía uyapɨsacata'ã jocua Tumpa iñee umɨmbeuta vae re vae, Tumpa omombota co ĩru vae reta ipɨte güi’ —jei, jei Pedro—. ");
INSERT INTO gnwNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Jare jucuarãi vi jei opaete Tumpa iñee aracae umɨmbeu vae reta Samuel güive. Opaete penti rami umɨerãcua cua ara reta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Pe reta co jae Tumpa iñee aracae umɨmbeu vae reta iñemoñaa reta, jare petenondegua reta pe Tumpa jei vae uyeyapota peve. Echa'ã Tumpa jei Abraham pe: ‘Niñemoñaa rupi ayapota co icavi vae opaete ɨvɨ pegua reta pe’ —jei, jei Pedro—. ");
INSERT INTO gnwNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Tumpa umbɨjecove ye Taɨ güeru umanocue vae reta ipɨte güi, jare ombou ma peve tenonde ete, uyapo vaerã icavi vae peve, penti penti piyerova vaerã Tumpa cotɨ pereco icavi mbae vae güi —jei Pedro chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pedro jare Juan imiari ñugüɨnoi rambueve tenta guasu pegua reta pe, yugüeru sacerdote reta, Tumpa jo iyandarecoa reta juvicha jare saduceo reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Jae reta pochɨ Jesús jemimondo reta pe. Echa'ã Jesús jemimondo reta omboe tenta guasu pegua reta, jare umɨmbeu chupe reta Jesús icove ye co ou umanocue vae reta ipɨte güi. ");
INSERT INTO gnwNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Jayave jae reta uipɨsɨ Pedro jare Juan, jare oñono peresorɨru pe pɨareve regua. Echa'ã caaru ma co. ");
INSERT INTO gnwNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ẽrei jeta ete Tumpa iñee uyandu vae reta güɨrovia. Cuimbae reta güɨrovia vae cinco mil rupi. ");
INSERT INTO gnwNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Pɨareve pe uyembatɨ Jerusalén pe mburuvicha reta, tenta guasu pegua reta itenondegua reta, mboroyocui re oporomboe vae reta, ");
INSERT INTO gnwNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Anás - jae co sacerdote tenondegua - Caifás, Juan, Alejandro jare opaete sacerdote tenondegua jentarã reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Jayave güeruruca Pedro jare Juan jae reta ipɨte pe, jare upɨrandu chupe reta: —¿Mbae nunga mbaepuere pe pa piyapo cua? Jare ¿quía jee re pa piyapo? ");
INSERT INTO gnwNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Jayave Pedro tɨnee Espíritu Santo pe, jare jei chupe reta: —Mburuvicha tenta guasu pegua reta jare tenondegua Israel pegua reta, ");
INSERT INTO gnwNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","añave pepɨrandu peĩ oreve cua icavi vae uyeyapo vae re. Pipota picuaa quirãi ra cua cuimbae ucuera ma imbaerasɨ güi —jei Pedro—. ");
INSERT INTO gnwNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Picuaa catu opaete pe reta, jare tuicuaa opaete Israel pegua reta, Jesucristo Nazaret pegua jee re ucuera ma cua cuimbae perovaque oĩ vae. Pe reta picutuca curusu re cua Jesucristo, ẽrei Tumpa umbɨjecove ye güeru umanocue vae reta ipɨte güi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Cua Jesús pe reta perɨ̃ro, tenta ita pegua iyapoa reta penti ita güɨrɨ̃ro rami. Ẽrei jae uyeyapo ma ita uñeñono tenonde tentarã vae rami —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Jare mbaetɨ ye quía re yandepuere yayembɨasaca. Echa'ã uñemee'ã ɨvɨ pegua reta pe ĩru tee, jese uyembɨasaca vaerã —jei chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Jayave yatɨ vae reta uecha quirãi Pedro jare Juan uquɨye mbae reve imiari, yepe tẽi mocui reve jeta'ã uyemboe. Jáeramo ipɨacañɨ reta jese. Jare uicuaa Jesús ndive yugüɨrecose vae. ");
INSERT INTO gnwNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ẽrei uecha reta yave cuimbae ucuera vae uyemboɨ oĩ jae reta ndive, ipuere'ã jei mbae Jesús jemimondo reta cotɨ. ");
INSERT INTO gnwNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Jayave oyocui Pedro jare Juan oẽ rani vaerã ipɨte güi. Jayave uyemɨngueta reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","—¿Mbae ra yayapota cua cuimbae reta pe? Echa'ã opaete Jerusalén pegua reta uicuaa penti mɨacañɨ tuicha vae uyapo reta co, jare yande yandepuere'ã yaicuacu —jei reta—. ");
INSERT INTO gnwNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Jayave yayocui cua reta agüɨye vaerã añave güive imiari quía pe cua cuimbae jee re, agüɨye vaerã ĩru vae reta uicuaa —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Jayave ueni Pedro jare Juan, jare oyocui: —Agüɨye ye pemiari ani peporomboe Jesús jee re. ");
INSERT INTO gnwNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ẽrei Pedro jare Juan jei chupe reta: —¿Mbae ra Tumpa uipota nduyapo vaerã? Nduyapo yave peporoyocui, ndarau nduyapo Tumpa iporoyocui. ¿Mbae nunga mboroyocui ra nduyapota? Pe reta pemɨmbeu oreve. ");
INSERT INTO gnwNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Echa'ã ore numɨmbeuñotai co nduecha jare nduyandu vae —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Jayave yatɨ vae reta umɨnguɨye tẽi omondo Pedro jare Juan. Uinupaca'ã, tenta guasu pegua reta güi uquɨye ramo. Echa'ã opaete tenta guasu pegua reta umbɨadora Tumpa jocua uyeyapo vae jeco pegua. ");
INSERT INTO gnwNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Echa'ã cuimbae mɨacañɨ pe ucuera vae cuarenta año uasa ma güɨnoi. ");
INSERT INTO gnwNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Jare Pedro jare Juan omoẽ ma yave, yugüɨraa iĩru reta pe, jare umɨmbeu chupe reta opaete sacerdote reta itenondegua reta jare tenta guasu pegua reta itenondegua reta jei chupe reta vae. ");
INSERT INTO gnwNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Jae reta cua uyandu yave, uyerure Tumpa pe: —OreYa Tumpa, nde co jae ara, ɨvɨ, ɨ guasu jare opaete mbaembae ñugüɨnoi pɨpe vae iyapoa —jei reta—. ");
INSERT INTO gnwNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Nde ndere nderembiocui David jee vae rupi cuarãi: ‘¿Maera pa pochɨ judío mbae vae reta? ¿Maera pa ɨvɨ pegua reta ipɨa pe uyemɨngueta uyapo vaerã icavi mbae vae? ");
INSERT INTO gnwNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Mburuvicha guasu ɨvɨ pegua reta jare ɨvɨ pegua reta itenondegua reta uyembatɨ penti rami yandeYa jare Cristo jovaicho retarã.’ Jucuarãi nde ndere David rupi —jei reta—. ");
INSERT INTO gnwNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Añete co, Herodes, Poncio Pilato, judío mbae vae reta jare Israel pegua reta uyembatɨ cua tenta guasu pe Jesús jovaicho retarã. Jesús co jae ndeRaɨ. Jae co jupi vae nde ndiparavo vae —jei reta—. ");
INSERT INTO gnwNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Uyembatɨ reta uyapo vaerã nde ndiyapoca vae. Aracae güive nde ndipota uyapo reta vaerã —jei reta Tumpa pe—. ");
INSERT INTO gnwNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Añave, oreYa, ndicuaa oremɨnguɨye tẽi vae reta jei vae. Jáeramo oremborɨ numɨmbeu vaerã niñee nduquɨye mbae reve. Echa'ã ore co nderembiocui. ");
INSERT INTO gnwNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Jare eechaca nembaepuere ndepurumbɨgüera vaerã, jare iyapo vi mɨacañɨ reta Jesús jee re. Jae co ndeRaɨ jupi vae —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Jare opa uyerure yave, yatɨ ñugüɨnoi vae pe ɨvɨcãta vae echa. Jare opaete jae reta tɨnee Espíritu Santo pe, jare imiari Tumpa iñee re uquɨye mbae reve. ");
INSERT INTO gnwNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Jare opaete upurugüɨrovia vae reta penti ramiño ñugüɨnoi. Mbaetɨ penti ave jei imbaembae re: “Jocua co chembae.” Echa'ã opaete imbaembae reta penti ramiño. ");
INSERT INTO gnwNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Jare mbaepuere tuicha vae reve Jesús jemimondo reta umɨmbeu yandeYa Jesús icove ye co ou umanocue vae reta ipɨte güi. Jare opaete jae reta ipɨacavi ete. ");
INSERT INTO gnwNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Mbaetɨ penti ave mbae uata chupe vae jae reta ipɨte pe. Echa'ã opaete ɨvɨ reta jare tenta reta güɨnoi vae reta umee, jare güeru jepɨcue, ");
INSERT INTO gnwNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","jare oñono Jesús jemimondo reta jovai. Jayave umbɨyao reta uata chupe vae reta pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","37","Jare penti levita ɨvɨ Chipre pegua José jee vae güɨnoi vi penti ɨvɨ. Jesús jemimondo reta umbɨjee cua cuimbae Bernabé. (Cua tee uipota jei: “Upurumbɨpɨacatu vae”.) Jae umee iɨvɨ jare güeru jepɨcue oñono Jesús jemimondo reta jovai. ");
INSERT INTO gnwNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ẽrei ĩru cuimbae Ananías jee vae jembireco Safira jee vae ndive umee penti iɨvɨ. ");
INSERT INTO gnwNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Jayave Ananías uñuvatu iyupe mbovɨ ɨvɨ jepɨcue güi jembireco uicuaa reve, jare güeru mbovɨño oñono Jesús jemimondo reta jovai. ");
INSERT INTO gnwNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Jayave Pedro jei chupe: —Ananías, ¿maera pa nemaeño Satanás re umɨtɨnee vaerã ndepɨa icavi mbae vae pe? Niñuvatu ndiyupe mbovɨ ndeɨvɨ jepɨcue güi. Ndapu ma co Espíritu Santo pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ndei nemee ndeɨvɨ mbove, nembae co. Jare nemee ma yave, jepɨcue vi nembae co. ¿Maera pa ndepɨa pe ndiyemɨngueta icavi mbae vae ndiyapo vaerã? Ndapu'ã co cuimbae reta peño. Ndapu Tumpa pe etei —jei Pedro Ananías pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Cua uyandu yave, Ananías oa ɨvɨ re, jare umano. Jare opaete cua regua uicuaa vae reta uquɨye ete. ");
INSERT INTO gnwNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Jayave upũa cuimbae taɨrusu vae reta, jare oñoma umanocue, jare güɨraa oñotɨ. ");
INSERT INTO gnwNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Mbapɨ ora ma uasa yave, uique jembireco. Jae uicuaa'ã mbae uyeyapo vae. ");
INSERT INTO gnwNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Jayave Pedro upɨrandu chupe: —Emɨmbeu cheve, ¿pemee pa peɨvɨ cuarãi pe? Cuña jei chupe: —Añete, jucuarãi pe co —jei. ");
INSERT INTO gnwNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","—¿Maera pa pe reta piyemboemboe pembɨavai vaerã yandeYa iEspíritu? —jei Pedro chupe—. Co onque pe ma yugüeru neme iñotɨa reta. Jae reta ndereraata vi —jei. ");
INSERT INTO gnwNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Jare jupivoiño Safira oa Pedro jovai, jare umano. Uique ma yave cuimbae taɨrusu vae reta, uecha umano ma. Jayave güɨraa oñotɨ imecue iyɨpɨ pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Jare upurugüɨrovia vae reta jare opaete cua mbaembae regua uicuaa vae reta uquɨye ete. ");
INSERT INTO gnwNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Jare uyeyapo jeta mɨacañɨ reta tenta guasu pegua reta ipɨte pe Jesús jemimondo reta rupi. Jare opaete upurugüɨrovia vae reta uyembatɨ oca Salomón jee vae pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Jare opaete ĩru vae reta uquɨye uyembatɨ vaerã jae reta ndive. Ẽrei tenta guasu pegua reta uipɨu. ");
INSERT INTO gnwNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Jare jecuaeño jeta ĩru cuimbae reta jare cuña reta güɨrovia yandeYa re. ");
INSERT INTO gnwNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Jare tenta guasu pegua reta güɨraa imbaerasɨ vae reta oñono calle reta rupi jupa reve. Cua uyapo reta Pedro iguarasɨ̃a yepe oĩ vaerã amocue vae re, jae uasa oo oĩ yave. ");
INSERT INTO gnwNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Jare jeta vae yugüeru Jerusalén pe ĩru tenta guasu coiño Jerusalén güi ñugüɨnoi vae reta güi, jare güeru imbaerasɨ vae reta jare aña oya jese vae reta. Jare opareve ucuera. ");
INSERT INTO gnwNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Jayave sacerdote tenondegua jare opaete saduceo jae ndive ñugüɨnoi vae reta ñacatãa Jesús jemimondo reta re. ");
INSERT INTO gnwNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Jáeramo uipɨsɨ reta, jare oñono peresorɨru tenta guasu pegua pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ẽrei pɨ̃tu yave penti ángel yandeYa pe uyeyocui vae uipea peresorɨru jonque reta. Jayave güɨraa Pedro jare Juan oca pe, jare jei chupe reta: ");
INSERT INTO gnwNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","—Pecua piyemboɨ Tumpa jo pe pemɨmbeu tenta guasu pegua reta pe cua tecove ipɨau vae regua. ");
INSERT INTO gnwNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Cua uyandu yave, Pedro jare Juan uique Tumpa jo pe neimbove asɨ jare oporomboe. Cua uyeyapo rambueve, sacerdote tenondegua jare jae ndive ñugüɨnoi vae reta ueni opaete mburuvicha reta jare tenondegua Israel pegua reta. Jayave jae reta omondo sacerdote tenondegua jembiocui reta peresorɨru pe, jae reta güeru vaerã tẽi Jesús jemimondo reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ẽrei uyeyocui vae reta yugüɨraa uvãe yave, uvãe'ã Jesús jemimondo reta peresorɨru pe. Jayave yugüeru ye yave, jei reta yatɨ vae reta pe: ");
INSERT INTO gnwNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","—Nduecha peresorɨru jonque reta uyeyuquenda cavi oĩ, jare jãroa reta uyemboɨ ñugüɨnoi onque reta rupi. Ẽrei nduipea yave, nuvãe'ã quía japɨpe pe —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Cua uyandu yave, sacerdote tenondegua, Tumpa jo iyandarecoa reta juvicha jare sacerdote reta itenondegua reta ipɨacañɨ. Jare uicuaa'ã mbae ra uyeyapota. ");
INSERT INTO gnwNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Jayave ou penti vae, jare jei chupe reta: —Cuimbae piñono peresorɨru pe vae reta ime Tumpa jo pe ñugüɨnoi, jare omboe ñugüɨnoi tenta guasu pegua reta —jei. ");
INSERT INTO gnwNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Jayave Tumpa jo iyandarecoa reta juvicha oo sacerdote tenondegua jembiocui reta ndive, jare güeru cavi Jesús jemimondo reta uinupa mbae reve. Echa'ã uquɨye reta tenta guasu pegua reta güi. Ipɨa pe uyemɨngueta aramoi uyapita reta ita pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Jare güeru yave, oñono mburuvicha reta jovai. Jayave sacerdote tenondegua jei Jesús jemimondo reta pe: ");
INSERT INTO gnwNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","—Poyocui tẽi ma agüɨye ye vaerã peporomboe jocua cuimbae jee re. Echa'ã pemɨmbeu ma opaete Jerusalén pegua reta pe cua moromboe. Jare pipota pemboya jocua cuimbae imano oreré —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Jayave Pedro jare ĩru Jesús jemimondo reta jei chupe reta: —Icavi ete co nduyapo vaerã Tumpa iporoyocui, cuimbae reta iporoyocui güi. ");
INSERT INTO gnwNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Yandetenondegua reta iTumpa umbɨjecove ye Jesús güeru umanocue vae reta ipɨte güi. Pe reta picutuca curusu re cua Jesús piyucaca —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Imbaepuere pe Tumpa uyapo ma cua Jesús tenondegua vae jare upurumbɨasa vae, Israel pegua reta ueya vaerã iyemɨngueta icavi mbae vae ipɨa pe oĩ vae, jare Tumpa umbɨasa vaerã chupe reta imbaeyoa reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Jare ore numɨmbeu ĩru vae reta pe cua, jare Espíritu Santo vi umɨmbeu. Echa'ã Tumpa umee Espíritu Santo jei vae uyapo vae reta pe —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Cua uyandu yave, yatɨ vae reta pochɨ chupe reta, jare uipota tẽi uyuca. ");
INSERT INTO gnwNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ẽrei upũa penti fariseo Gamaliel jee vae yatɨ vae reta ipɨte pe. Jae co penti mboroyocui re oporomboe vae, jare opaete tenta guasu pegua reta uipɨu. Jae oyocui omondo reta rani vaerã michi pegua Jesús jemimondo reta oca pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Jayave jae jei yatɨ vae reta pe: —Cuimbae Israel pegua reta, pepɨa pe piyemɨngueta cavi mbae piyapota cua cuimbae reta pe vae re. ");
INSERT INTO gnwNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Echa'ã caramboe yave uyecuaa Teudas jee vae, jare uyereroviaca ĩru vae reta pe. Jare jeta cuimbae reta, aramoi cuatrocientos, uyembatɨ jae ndive. Ẽrei jae uyeyucaca, jare opaete jae ndive ñugüɨnoi vae reta opa uñemɨai, jare ipuere'ã ma mbae uyapo. ");
INSERT INTO gnwNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Jaɨcue rupi, mburuvicha reta upurupapa ñugüɨnoi yave, uyecuaa Galilea pegua Judas jee vae. Jae umbatɨ jeta tenta guasu pegua reta. Ẽrei jae vi umano, jare opaete jae ndive ñugüɨnoi vae reta opa uñemɨai —jei Gamaliel chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Jáeramo añave che jae peve cua: Agüɨye ma piyapo mbae cua cuimbae reta pe, jare pemaeño ma jese reta. Echa'ã imbaepuere peño yave jucuarãi imiari reta jare cua mbaembae uyapo reta, ndarau mbae uyapo reta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ẽrei cua Tumpa güi ou yave, ndarau pepuere pembai. Echa'ã aramoi piyovaichota Tumpa ndive —jei chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Jare cua Gamaliel jei vae icavi chupe reta. Jayave ueni reta Jesús jemimondo reta, jare uinupa. Jayave oyocui reta agüɨye vaerã ma imiari ye Jesús jee re, jare omondo. ");
INSERT INTO gnwNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Jayave Jesús jemimondo reta oẽ yatɨ vae reta ñugüɨnoi vae güi. Uyerovia reta, Jesús umaeño uiporara reta ramo. Echa'ã uñererɨ̃roca reta, Jesús re güɨrovia ramo. ");
INSERT INTO gnwNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Jare opa ara jecuae oporomboe reta Tumpa jo pe jare tenta reta rupi. Umɨmbeu ĩru vae reta pe Jesucristo regua. ");
INSERT INTO gnwNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Jocua ara reta pe ĩru vae reta upurugüɨrovia jare uñemɨĩru ñugüɨnoi upurugüɨrovia vae reta ndive yave, griego pe uyemɨngueta vae reta iñeenguru hebreo pe uyemɨngueta vae reta cotɨ. Echa'ã uyandareco'ã reta ime umano vae reta griego iñee pe uyemɨngueta vae re, opa ara rupi mbae uñemee yave. ");
INSERT INTO gnwNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Jayave jocua doce Jesús jemimondo reta umbatɨ upurugüɨrovia vae reta, jare jei chupe reta: —Icavi ore ndoo numɨmbeu vaerã Tumpa iñee, cua reta numɨngaru vaerãve. ");
INSERT INTO gnwNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Jáeramo piparavo pepɨte güi, orerɨvɨ reta, siete cuimbae jerãcua cavi jese vae reta, tɨnee Espíritu Santo pe jare iyaracuaa catu vae reta. Jae reta uyapota yandeve cua mbaravɨquɨ —jei reta—. ");
INSERT INTO gnwNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ẽrei ore jecuae nduyerureta Tumpa pe jare numɨmbeuta Tumpa iñee —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Cua jei vae icavi opareve pe, jare uiparavo reta Esteban - jae co penti cuimbae upurugüɨrovia cavi jare tɨnee Espíritu Santo pe vae - Felipe, Prócoro, Nicanor, Timón, Parmenas jare Nicolás - jae co tenta guasu Antioquía pegua judiorã uyeyapo vae. ");
INSERT INTO gnwNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Jayave güeru reta cua uiparavo vae reta Jesús jemimondo reta jovai. Jayave Jesús jemimondo reta uyerure Tumpa pe, jare oñono ipo jese reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Jare Tumpa iñee jecuae uñemɨai. Jeta vae upurugüɨrovia Jerusalén pe jare uñemɨĩru upurugüɨrovia vae reta ndive, jare jeta sacerdote reta vi upurugüɨrovia. ");
INSERT INTO gnwNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Jare Esteban ipɨacavi ete, jare mbaepuere reve uyapo mɨacañɨ tuicha vae reta tenta guasu pegua reta ipɨte pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Jare yugüeru amocue cuimbae judío reta itupao pegua reta uyeaca Esteban ndive. Jocua judío reta itupao jee Esclavos Libertados. Cua tupao pegua reta yugüeru tenta guasu reta Cirene jare Alejandría, jare ɨvɨ reta Cilicia jare Asia güi. ");
INSERT INTO gnwNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ẽrei jae reta ipuere'ã umɨamɨri Esteban. Echa'ã Esteban imiari iyaracuaa catu reve Espíritu Santo rupi. ");
INSERT INTO gnwNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Jayave jae reta omboemboe ĩru cuimbae reta iyapu vaerã Esteban re. —Nduyandu jei ñee icavi mbae vae Moisés jare Tumpa cotɨ —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Jucuarãi jae reta umbɨarasɨca tenta guasu pegua reta, tenta guasu pegua reta itenondegua reta, jare mboroyocui re oporomboe vae reta. Jayave cua reta yugüeru uipɨsɨ Esteban, jare güɨraa mburuvicha reta uyembatɨ vae pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Joco pe jae reta güeru iyapu reve uñeapo jese vae reta. Cua reta jei: —Cua cuimbae jecuaeñoi jei ñee icavi mbae vae Tumpa jo re jare mboroyocui re. ");
INSERT INTO gnwNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Echa'ã nduyandu jei jocua Jesús Nazaret pegua umbaita cua Tumpa jo, jare ueyacata yandeve moromboe Moisés umee yandeve vae reta —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Jayave opaete joco pe uguapɨ ñugüɨnoi vae reta umae ngatu Esteban re, jare jova penti ángel jova echa chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Jayave sacerdote tenondegua upɨrandu Esteban pe: —¿Añete pa jucuarãi? ");
INSERT INTO gnwNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Jayave Esteban jei joco pe ñugüɨnoi vae reta pe: —Cherɨqueɨ reta, tenta guasu pegua reta itenondegua reta, piyapɨsaca cheré. Tumpa yembɨadora pegua uyecuaa yandetenondegua Abraham pe, Mesopotamia pe ico yave, ndei oo ico Harán pe mbove —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Jare jei chupe: ‘Ecua ndeɨvɨ güi jare eeya nerentarã reta, jare ecua jocua ɨvɨ aechacata ndeve vae pe’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Jayave Abraham oo Caldeo reta iɨvɨ güi, jare ico Harán pe. Jare tu umano yave, Tumpa ombou joco güi cua ɨvɨ añave pico pɨpe vae pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ẽrei Tumpa umee'ã Abraham pe iɨvɨrã cua pe, umee'ã ipɨ jendarã yepe. Ẽrei jei umeeta co chupe jare iñemoñaa reta pe iɨvɨrã, yepe tẽi Abraham ndei taɨ —jei chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Jare Tumpa umɨmbeu chupe: ‘Niñemoñaa reta yugüɨrecota ĩru vae reta iɨvɨ pe, jare jocua ɨvɨ pegua reta uyapota jembiocui retarã, jare uyapota icavi mbae vae chupe reta cuatrocientos año pegua. ");
INSERT INTO gnwNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ẽrei che aiporaracata jocua ɨvɨ pegua uyapota jembiocui retarã vae reta pe, jare taɨcue rupi niñemoñaa reta oẽta joco güi, jare uyeyocuita cheve cua ɨvɨ pe’ —jei, jei Esteban—. ");
INSERT INTO gnwNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Jare Tumpa jei Abraham pe jae jare opaete iñemoñaa cuimbae reta uñemɨcircuncidaca vaerã, imandúa reta vaerã Tumpa jei vae uyapota co. Jáeramo Abraham taɨ Isaac oa ma yave, Abraham umɨcircuncida, Isaac ocho ara ma güɨnoi yave. Jae ramiño vi Isaac umɨcircuncida taɨ Jacob, jare Jacob umɨcircuncida jocua doce taɨ yandetenondegua reta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Jocua yandetenondegua reta umɨtarẽɨ José, jare umee corepoti re, José Egipto pe uyeyocui vaerã. Ẽrei Tumpa ico José ndive, ");
INSERT INTO gnwNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","jare uepɨ opaete susere reta güi. Jare mburuvicha guasu Egipto pegua Faraón uicuaa Tumpa umee José pe ipɨacavi jare iyaracuaa catu vaerã. Jáeramo Faraón uyapo mburuvicharã, jare José oyocui opaete Egipto pegua reta jare Faraón jentarã reta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Ẽrei caruai ou opaete Egipto jare Canaán pe, jare opaete vae uiporara. Jare jocua yandetenondegua reta uvãe'ã mbae ave jou vaerã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ẽrei Jacob uicuaa ime tembíu Egipto pe yave, omondo jocua yandetenondegua reta joco pe. Jaeramo etei jae reta yugüɨraa Egipto pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Jare Jacob omondo reta ye yave, José uyecuaaca tɨqueɨ reta pe, jare Faraón uicuaa José jentarã reta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Jayave José ombou umɨmbeu tu pe yugüɨraa vaerã ipɨ jae jare opaete jentarã reta. Opaete rupi ñugüɨnoi setenta y cinco —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Jáeramo Jacob oo Egipto pe. Jare joco pe jae jare jocua yandetenondegua reta umano. ");
INSERT INTO gnwNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Taɨcue rupi iñemoñaa reta güeru jetecue reta Siquem pe, jare joco pe oñotɨ reta teõgüerenda Abraham oguacue pe. Echa'ã Abraham umbɨepɨ Hamor taɨ reta pe corepoti pe, Siquem pe oĩ yave —jei Esteban—. ");
INSERT INTO gnwNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Ẽrei coiño ma ou yave Tumpa uyapo vaerã Abraham pe jei vae, yandetenondegua reta jeta uñemoña Egipto pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Jayave ĩru cuimbae uyeyapo Egipto pegua reta juvicha guasurã. Ẽrei uicuaa'ã José —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Cua mburuvicha guasu iyaracuaa catu uyapo vaerã icavi mbae vae yandetenondegua reta pe. Jei chupe reta uicuaaca vaerã taɨ reta oa yave, uyucaca vaerã chugüi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Jocua ara reta pe oa Moisés. Tumpa uau Moisés. Jare mbapɨ yasɨ Moisés ico tu jenta pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Jare uyecuaa yave, Faraón tayɨ uepɨ, jare umbɨcuacuaa imembɨ rami —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Jare Moisés uyemboe opaete aracuaa Egipto pegua re, jare uyemɨngueta cavi jare jatangãtu —jei Esteban chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Jare Moisés cuarenta año güɨnoi yave, uipota uecha quirãi ra yugüɨreco Israel pegua reta - jae reta co jae jentaɨgua reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Jare uecha penti Egipto pegua icavi mbae vae uyapo oĩ penti Israel pegua pe. Jayave uinupa uyuca Egipto pegua, jare jucuarãi uepɨ uiporara vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moisés ipɨa pe uyemɨngueta tẽi jentaɨgua reta uicuaata co Tumpa uepɨta jae rupi, ẽrei uicuaa'ã reta —jei Esteban—. ");
INSERT INTO gnwNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Pɨareve pe uecha mocui jentaɨgua reta uñerãro ñugüɨnoi, jare uipota tẽi uyapɨcatu cavi reta. Jáeramo jei chupe reta: ‘Cuimbae reta, pe reta penti tentaɨgua vae co. ¿Maera pa icavi mbae vae piyapo piyupe?’ —jei, jei Esteban—. ");
INSERT INTO gnwNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ẽrei jocua cuimbae icavi mbae vae uyapo ĩru pe vae umɨaña Moisés, jare jei chupe: ‘¿Quía pa neñono oreruvicharã, orerãa vaerã? ");
INSERT INTO gnwNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Ndipota pa cheyuca Egipto pegua caarumo ndiyuca rami?’ —jei, jei Esteban—. ");
INSERT INTO gnwNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Cua uyandu yave, Moisés osi, jare ico ɨvɨ ambɨe Madián jee vae pe. Joco pe uñemoña mocui taɨ —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Cuarenta año ma uasa yave, ñana pe coiño ɨvɨtu guasu Sinaí jee vae güi oĩ yave, penti ángel uyecuaa Moisés pe penti yai jendɨ oĩ vae pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moisés uecha yave, ipɨacañɨ. Ẽrei oya jese yave, umae vaerã jese coi güi, uyandu yandeYa iñee jei: ");
INSERT INTO gnwNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Che co jae ndetenondegua reta - jae co Abraham, Isaac jare Jacob - iTumpa’ —jei, jei—. Jayave Moisés urɨrɨ uquɨye ramo, jare uipɨu umae vaerã jese. ");
INSERT INTO gnwNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Jayave yandeYa jei chupe: ‘Emboi ndepɨpasa. Echa'ã ndiyemboɨ co neĩ Tumpa jupi vae jovai. ");
INSERT INTO gnwNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Che añetete aecha quirãi uiporara reta aiparavo vae reta Egipto pe, jare ayandu iyao. Jáeramo agüeyɨ aepɨ vaerã. Añave eyu toromondo Egipto pe’ —jei, jei Esteban—. ");
INSERT INTO gnwNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Cua Moisés co jae Israel pegua reta güɨrɨ̃ro vae. Echa'ã jae reta jei chupe: ‘¿Quía pa neñono oreruvicharã, orerãa vaerã?’ —jei reta, jei—. Tumpa omondoca cua Moisés ángel yai jendɨ vae pe uyecuaa chupe vae pe. Omondoca ico vaerã jae reta juvicharã jare uepɨ reta vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moisés güɨnoẽ reta güeru, jare uyapo mɨacañɨ reta Egipto pe, Ɨ Guasu Pɨ̃ta jee vae pe, jare cuarenta año ñana rupi yugüɨreco rambueve —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Moisés jei Israel pegua reta pe: ‘YandeYa Tumpa ombouta peve iñee umɨmbeuta vae perɨvɨ reta ipɨte güi, chembou rami. Piyapɨsacata jese’ —jei, jei Esteban—. ");
INSERT INTO gnwNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ángel umɨngueta Moisés ɨvɨtu guasu Sinaí pe, ñana pe uyembatɨ yave Moisés jare yandetenondegua reta. Tumpa umee Moisés pe iñee tecove pegua, jae umɨmbeu vaerã yandeve —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Ẽrei yandetenondegua reta uipota'ã uyapo Moisés jei vae, jare güɨrɨ̃ro reta. Jae reta ipɨa pe uyemɨngueta tẽi yugüɨraa ye vaerã Egipto pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Jare jei reta Aarón pe: ‘Iyapo ñanetumpa retarã yugüɨraa vaerã yanderenonde. Echa'ã yaicuaa'ã mbae ra uyeyapo cua Moisés Egipto güi yandereru vae pe’ —jei reta, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Jayave uyapo reta penti vaca taɨrusu vae-raanga, jare uyuca reta maemɨmba umee vaerã jocua itumpa-raanga pe. Uyerovia reta jocua ipo pe uyapo vae re. ");
INSERT INTO gnwNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Jáeramo Tumpa uyerova chugüi reta, jare umaeño umbɨadora reta vaerã opaete ara regua reta. Echa'ã Tumpa iñee aracae umɨmbeu vae reta itupapire pe uyecuatía oĩ cuarãi: ‘¿Cheve ra pemee maemɨmba piyuca vae cuarenta año ñana pe pico rambueve, Israel pegua reta? ");
INSERT INTO gnwNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Jucuarãi'ã co. Pevoɨ peraa tumpa-raanga Moloc jee vae ico pɨpe vae, jare petumpa-raanga Renfán jee vae iyasɨtata-raanga. Jae reta jaanga piyapo pembɨadora vaerã. Jáeramo che pomondota Babilonia cutɨ.’ Jucuarãi uyecuatía oĩ —jei Esteban chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Yandetenondegua reta güɨrecose o Tumpa uyemɨngueta chupe reta pɨpe vae ñana pe. Echa'ã Tumpa oyocui Moisés jocua tupao uyapo vaerã jae uechaca chupe rami etei. ");
INSERT INTO gnwNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Jocua tupao uñemee yandetenondegua reta pe, jare jae reta Josué ndive güeru, cua ɨvɨ judío mbae vae reta güi upɨ̃ro yave. Echa'ã Tumpa omombo reta yandetenondegua reta güi. Jare David ico mburuvicha guasurã yave, imeño cua pe oĩ jocua tupao —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Tumpa umae cavi David re, jare David uyerure Tumpa pe umaeño vaerã uyapo Tumpa jo. Echa'ã itenondegua Jacob umbɨadora co Tumpa. ");
INSERT INTO gnwNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ẽrei Salomón uyapo Tumpa jo, ");
INSERT INTO gnwNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","yepe teĩ Tumpa ara pe ico vae ico'ã yambɨadorarenda yande yayapo vae reta pe. Echa'ã Tumpa iñee aracae umɨmbeu vae jei cuarãi: ");
INSERT INTO gnwNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Ara co jae cheguapɨrenda, jare ɨvɨ co jae chepɨ jenda’ —jei Tumpa—. ‘¿Mbae nunga o ra piyapota cheve? ¿Quiape ra aputuuta? ");
INSERT INTO gnwNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Chepo pe co ayapo opaete cua mbaembae’ —jei. Jucuarãi jei Tumpa iñee aracae umɨmbeu vae —jei Esteban chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Pe reta pepɨatanta. Pipota'ã piyeyocui Tumpa pe, jare pipota'ã ave piyapɨsaca jese. Jecuae piyovaicho Espíritu Santo ndive. Petenondegua reta uyapo rami, jucuarãi vi piyapo pe reta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Petenondegua reta uyapo icavi mbae vae opaete Tumpa iñee aracae umɨmbeu vae reta pe. Amocue Tumpa iñee aracae umɨmbeu vae reta jei jocua jupi vae outa co. Petenondegua reta uyuca reta. Jare añave pe reta vi pemee piyucaca jocua jupi vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Echa'ã Tumpa umeeca peve iporoyocui ángel reta pe, ẽrei piyapo'ã —jei Esteban. ");
INSERT INTO gnwNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Jare yatɨ vae reta cua uyandu ma yave, pochɨ, jare umbɨquɨrɨrɨu jãi Esteban jei vae jeco pegua. ");
INSERT INTO gnwNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ẽrei Esteban tɨnee Espíritu Santo pe, jare umae ngatu ara cotɨ, jare uecha Tumpa iyembɨadorarenda jare Jesús Tumpa iyacata cotɨ. ");
INSERT INTO gnwNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Jayave Esteban jei: —¡Mase! Aecha ara uyepea oĩ, jare aecha vi cuimbaerã uyeyapo vae uyemboɨ oĩ Tumpa iyacata cotɨ. ");
INSERT INTO gnwNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Jayave jae reta usapɨcai tanta, jare iyapɨsa oyopia. Jayave penti rami uepeña reta Esteban uipɨsɨ. ");
INSERT INTO gnwNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Jare güɨraa ma yave tenta guasu güi ñana cotɨ, uyapi reta ita pe. Jare jocua iyapu reve uñeapo jese vae reta omboi iyasoya, jare oñono penti cuimbae taɨrusu Saulo jee vae jovai. ");
INSERT INTO gnwNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Jare uyapi reta rambueve, Esteban uyerure: —CheYa Jesús, eraa cherecove. ");
INSERT INTO gnwNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Jayave uyeatɨca, jare iñeeãta reve jei: —CheYa, agüɨye tuiporara reta cua mbaeyoa jeco pegua. Jare cua jei yave, umano. ");
INSERT INTO gnwNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Jare Esteban imano icavi Saulo pe. Jare jocua ara upurugüɨrovia vae Jerusalén pe ñugüɨnoi vae reta jovaicho reta umbɨpɨ uiporaraca chupe reta. Jare Jesús jemimondo retaño upɨta Jerusalén pe. Opaete ĩru upurugüɨrovia vae reta uñemɨai ɨvɨ reta Judea jare Samaria rupi. ");
INSERT INTO gnwNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Jare amocue cuimbae umbɨadora Tumpa vae reta oñotɨ Esteban, jare ipɨatɨtɨ reta jese. ");
INSERT INTO gnwNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ẽrei Saulo uiporaraca upurugüɨrovia vae reta pe. Echa'ã oo tenta tenta rupi, jare umbɨtɨrɨrɨ güɨraa cuimbae reta jare cuña reta oñono peresorɨru pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Jayave jocua upurugüɨrovia vae uñemɨai vae reta umɨmbeu ñee icavi vae yugüɨraa vae rupi. ");
INSERT INTO gnwNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Felipe oo tenta guasu Samaria pe, jare umɨmbeu tenta guasu pegua reta pe Cristo regua. ");
INSERT INTO gnwNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Jare tenta guasu pegua reta uyandu yave, penti rami uyapɨsaca cavi Felipe umɨmbeu chupe reta vae re. Uecha vi mɨacañɨ uyapo vae reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Echa'ã aña reta usɨrɨ usapɨcai reve oya jese vae reta güi. Jare jeta ipuere mbae omɨ vae reta jare jeta uguata mbae vae reta ucuera. ");
INSERT INTO gnwNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Jare jocua tenta guasu pegua reta uyerovia. ");
INSERT INTO gnwNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Jare joco pe ico penti cuimbae Simón jee vae. Cua cuimbae ipaye vae co, jare umɨpɨacañɨ umbɨtavɨ Samaria pegua reta mbaembae uyapo vae pe. Jáeramo uyereroviaca catu. ");
INSERT INTO gnwNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Jare opaete sambiaɨ reta jare ucuacuaa vae reta uyapɨsaca cavi jese, jare jei reta: —Cua cuimbae güɨnoi Tumpa imbaepuere tuicha vae. ");
INSERT INTO gnwNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Jáeramo opaete vae uyapɨsaca cavi jese. Echa'ã jae ipaye vae ramo, ɨma ma uyapo mbaembae umɨpɨacañɨ reta vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ẽrei Felipe umɨmbeu tenta guasu pegua reta pe ñee icavi vae. Imiari chupe reta Tumpa iporoyocuia re jare Jesucristo re. Jayave cuimbae reta jare cuña reta güɨrovia jare uyembɨbautizaca. ");
INSERT INTO gnwNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Jare Simón vi güɨrovia, jare uyembɨbautizaca güive upɨta Felipe ndive. Jare uecha yave mɨacañɨ tuicha vae uyeyapo vae reta, ipɨacañɨ. ");
INSERT INTO gnwNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Jare Jesús jemimondo Jerusalén pe ñugüɨnoi vae reta uicuaa yave quirãi Samaria pegua reta güɨrovia ma Tumpa iñee, omondo reta Pedro jare Juan. ");
INSERT INTO gnwNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Jare jae reta yugüɨraa uvãe yave Samaria pe, uyerure upurugüɨrovia vae reta re, Espíritu Santo ou vaerã chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Echa'ã ndeiño ou Espíritu Santo chupe reta. Jaeño uyembɨbautizaca Jesús jee re. ");
INSERT INTO gnwNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Jayave Pedro jare Juan oñono ipo jese reta, jare Espíritu Santo ou chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Jare Simón uecha Espíritu Santo ou, Jesús jemimondo reta ipo oñono jese reta yave. Jayave uipota tẽi umee corepoti chupe reta ");
INSERT INTO gnwNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","jare jei: —Cheve vi pemee cua mbaepuere, ou vaerã ipotave vae pe Espíritu Santo, che añono chepo jese yave. ");
INSERT INTO gnwNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ẽrei Pedro jei chupe: —Nde necañɨteita co ndecorepoti reve. Echa'ã ndepɨa pe ndiyemɨngueta tẽi ndepuere ndegua corepoti pe mbae Tumpa umee vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Nde ndepuere'ã nenoi cua nunga mbaepuere. Echa'ã ndepɨa jupi'ã Tumpa cotɨ. ");
INSERT INTO gnwNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Eeya cua icavi mbae vae, jare iyerure Tumpa pe. Aramoi umbɨasata ndeve cua ndepɨa pe ndiyemɨngueta vae re. ");
INSERT INTO gnwNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Echa'ã aicuaa nde niñemɨro, jare mbaeyoa jeco pegua ndepuere'ã ndiyapo icavi vae —jei. ");
INSERT INTO gnwNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Jayave Simón jei chupe reta: —Piyerure cheré yandeYa pe, agüɨye vaerã cua pere cheve vae uyeyapo cheve. ");
INSERT INTO gnwNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Jayave Pedro jare Juan umɨmbeu yave Tumpa iñee ĩru vae reta pe, yugüɨraa ye Jerusalén pe. Jare yugüɨraa rambueve, umɨmbeu ñee icavi vae jeta ĩru Samaria pegua tenta guasu-raɨ reta rupi. ");
INSERT INTO gnwNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Jayave penti ángel yandeYa pe uyeyocui vae jei Felipe pe: —Epũa ecua sur cotɨ tape Jerusalén güi oo Gaza cotɨ vae rupi. Cua tape uasa ñana rupi. ");
INSERT INTO gnwNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Jayave Felipe upũa oo. Jare penti eunuco ɨvɨ Etiopía pegua oo ye jenta cotɨ Jerusalén güi. Echa'ã ou Jerusalén pe umbɨadora vaerã Tumpa. Cua eunuco co jae penti mburuvicha. Jae uyandareco ico Candace icorepoti jare ĩru imbaembae icavi vae re. Candace co jae Etiopía pegua reta juvicha guasu. ");
INSERT INTO gnwNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Jare eunuco oo ye yave jenta cotɨ, uguapɨ icarro pe umɨngueta oo Isaías uicuatiacue vae. Isaías co jae penti Tumpa iñee aracae umɨmbeu vae. ");
INSERT INTO gnwNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Jare Espíritu Santo jei Felipe pe: —Ecua iñemɨĩru pea carro pe oo oĩ vae ndive. ");
INSERT INTO gnwNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Jayave Felipe osi oo carro cotɨ, jare uyandu cuimbae umɨngueta Tumpa iñee Isaías uicuatiacue vae. Jayave upɨrandu chupe: —¿Ndicuaa pa nemɨngueta neĩ vae? ");
INSERT INTO gnwNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Jare eunuco jei Felipe pe: —¿Quirãita pa aicuaa, mbaetɨ yave quía umɨmbeu cheve? Jare umɨñera Felipe uyupi vaerã icarro pe uguapɨ jae ndive. ");
INSERT INTO gnwNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Jare Tumpa iñee umɨngueta vae pe uyecuatía oĩ cuarãi: “Penti ovecha rami uyereraaca umano vaerã. Jare jae quĩiño, penti ovecha-raɨ jocua uñapi vae jovai oĩ vae quĩiño oĩ rami. ");
INSERT INTO gnwNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Uñererɨ̃roca yave, uãa vae reta uyapo'ã jupi vae chupe. ¿Quía ra ipuere umɨerãcua jentaɨgua reta regua? Echa'ã jecove ucañɨ ɨvɨ güi.” Jucuarãi uyecuatía oĩ. ");
INSERT INTO gnwNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Jare eunuco jei Felipe pe: —Aipota nemɨmbeu vaerã cheve quía re ra jei cua Tumpa iñee umɨmbeu vae. ¿Jei pa iyee ani ĩru vae re? —jei. ");
INSERT INTO gnwNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Jayave Felipe umbɨpɨ cua Tumpa iñee uyecuatía oĩ vae güi umɨmbeu chupe ñee icavi vae Jesús regua. ");
INSERT INTO gnwNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Jare tape rupi yugüɨraa rambueve, yugüɨraa uvãe ɨ jenda pe, jare eunuco jei: —Co oĩ ɨ. ¿Ime pa mbae ayapo vaerã ndei ayembɨbautizaca mbove? ");
INSERT INTO gnwNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","—Ndepurugüɨrovia yave opaete ndepɨa pe, ndepuere ndiyembɨbautizaca —jei Felipe chupe. —Arovia Jesucristo co jae Tumpa Taɨ —jei eunuco Felipe pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Jayave eunuco umbɨyemboɨca carro, jare mocui reve ugüeyɨ ɨ pe. Jayave Felipe umbɨbautiza eunuco. ");
INSERT INTO gnwNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Jare oẽ reta ɨ güi yave, yandeYa iEspíritu güɨraa joco güi Felipe. Jare eunuco uecha'ã ye ma. Jayave uyerovia reve oo ye jenta cotɨ. ");
INSERT INTO gnwNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Jare Felipe uyecuaa tenta guasu Azoto pe. Jare joco güi oo tenta guasu Cesarea pe. Jare oo rambueve, umɨmbeu ñee icavi vae opaete tenta guasu reta rupi. ");
INSERT INTO gnwNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Jare Saulo umumburu uyuca vaerã yandeYa re güɨrovia vae reta, jare oo sacerdote tenondegua pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Jare uyerure sacerdote tenondegua pe umee vaerã chupe tupapire, ipuere vaerã oo judío reta itupao tenta guasu Damasco pegua reta pe, jare uvãe yave joco pe cuimbae reta jare cuña reta Jesús re güɨrovia vae, ipuere vaerã uipɨsɨ güeru Jerusalén pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Jare coiño ma Damasco güi oo yave, aramoiño jembipe Saulo re penti tembipe tuicha vae ara güi. ");
INSERT INTO gnwNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Jayave Saulo oa ɨvɨ re, jare uyandu ñee jei chupe: —Saulo, Saulo, ¿maera pa ndiyapo icavi mbae vae cheve? ");
INSERT INTO gnwNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Jayave Saulo upɨrandu: —¿Quía pa co nde, cheYa? Jayave ñee jei chupe: —Che co jae Jesús. Nde ndiyapo icavi mbae vae cheve. Nde co jae penti güeye ɨvɨra jacuarovi vae re upatara vae rami. Jáeramo ndiporara neĩ. ");
INSERT INTO gnwNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Saulo urɨrɨ uquɨye ramo. —CheYa, ¿mbae pa ndipota ayapo vaerã? —jei. —Epũa ecua tenta guasu pe, jare amɨmbeucata ndeve mbae ndiyapota vae —jei yandeYa Saulo pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Jare cuimbae Saulo jupíe yugüɨraa vae reta uyemboɨ quĩiño ñugüɨnoi ipɨacañɨ güi. Echa'ã uyandu ñee, ẽrei uecha'ã quiave. ");
INSERT INTO gnwNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Jayave Saulo upũa ɨvɨ güi, jare umae tẽi, ẽrei ipuere'ã uecha quía. Jare jae jupíe yugüɨraa vae reta uipoco, jare güɨraa Damasco pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Jare Saulo joco pe oĩ mbapɨ ara umae mbae reve, jare ucaru'ã jare ɨ jou'ã. ");
INSERT INTO gnwNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Jare ico Damasco pe penti upurugüɨrovia vae Ananías jee vae. YandeYa jei chupe ique pe: —Ananías. Jare jae jei: —CheYa, co aĩ. ");
INSERT INTO gnwNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Jayave yandeYa jei chupe: —Epũa ecua calle Sɨmi jee vae pe, jare eeca Judas jenta pe penti Tarso pegua. Jae jee co Saulo. Echa'ã jae uyerure oĩ —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Jare jae uecha ma ique pe penti cuimbae Ananías jee vae uique jare oñono ipo jese, umae ye vaerã —jei Tumpa chupe. ");
INSERT INTO gnwNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ẽrei Ananías jei: —CheYa, jeta vae umɨmbeu cheve cua cuimbae regua, quirãi jeta icavi mbae vae uyapo Jerusalén pe nderé güɨrovia vae reta pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Jare cua pe jae ime güɨnoi mbaepuere sacerdote reta itenondegua reta güi, uipɨsɨ vaerã opaete nderé güɨrovia vae reta —jei. ");
INSERT INTO gnwNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","—Ecuaño —jei yandeYa chupe—. Echa'ã che aiparavo ma cherembiporurã, oo vaerã umɨmbeu cheregua judío mbae vae reta pe, mburuvicha reta pe jare Israel pegua reta pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Echa'ã che aicuaacata chupe quirãi uiporara eteta chereco pegua —jei. ");
INSERT INTO gnwNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Jayave Ananías oo uique tenta pe. Jare oñono ipo Saulo re jare jei chupe: —Cherɨvɨ Saulo, yandeYa Jesús uyecuaa ndeve, ndeyu tape rupi rambueve. Jae chembou nemae ye vaerã, jare netɨnee vaerã Espíritu Santo pe —jei. ");
INSERT INTO gnwNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Jare jupivoiño mbae uyeequi Saulo jesa güi yanderesapĩra uyeequi rami, jare Saulo umae cavi. Jayave upũa uyembɨbautizaca. ");
INSERT INTO gnwNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Jayave ucaru jare ipɨrãta ye ma. Jare upɨta mbovɨ ara upurugüɨrovia vae Damasco pe yugüɨreco vae reta ndive. ");
INSERT INTO gnwNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Jayave Saulo umbɨpɨ umɨmbeu Jesús regua judío reta itupao reta pe. Jei chupe reta Jesús co jae Tumpa Taɨ. ");
INSERT INTO gnwNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Jare opaete uyandu vae reta ipɨacañɨ, jare jei: —¿Jae'ã ra cua Jerusalén pe cua Jesús re güɨrovia vae reta uiporaraca vae? Jare ou vi cua pe uipɨsɨ vaerã cua nunga reta güɨraa sacerdote reta itenondegua reta pe —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ẽrei Saulo uñemɨatangãtu, jare umɨamɨri judío Damasco pegua reta. Echa'ã uicuaaca chupe reta Jesús co jae Cristo. ");
INSERT INTO gnwNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Jare ɨma ma uasa yave, judío reta uyemboemboe uyuca vaerã Saulo. ");
INSERT INTO gnwNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Ẽrei cua jerãcua Saulo pe. Jae reta uãro tenta guasu jonque pe ara rupi jare pɨ̃tu rupi, uyuca vaerã tẽi. ");
INSERT INTO gnwNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ẽrei upurugüɨrovia vae reta güɨraa Saulo pɨ̃tu yave umbɨasa tenta guasu iquesemba ita pegua vae iárambo rupi umbɨgüeyɨ canasta guasu pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Jare Saulo oo uvãe yave Jerusalén pe, uipota tẽi uñemɨĩru upurugüɨrovia vae reta ndive. Ẽrei opaete jae reta uyepɨu chugüi. Echa'ã güɨrovia'ã reta jae Jesús re güɨrovia ma co. ");
INSERT INTO gnwNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ẽrei Bernabé güɨraa Saulo Jesús jemimondo reta pe, jare umɨmbeu chupe reta quirãi Saulo uecha yandeYa tape rupi, jare quirãi yandeYa umɨngueta vae. Jei vi chupe reta quirãi Saulo umɨmbeu uquɨye mbae reve Damasco pe Jesús regua. ");
INSERT INTO gnwNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Jayave Saulo uñemɨĩru upurugüɨrovia vae reta ndive Jerusalén pe. Jecuaeño oẽ Jerusalén güi jare uique ye. ");
INSERT INTO gnwNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Jare umɨmbeu uquɨye mbae reve yandeYa regua. Jare uyeaca vi griego pe uyemɨngueta vae reta ndive. Jáeramo jae reta uipota uyuca. ");
INSERT INTO gnwNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Jare upurugüɨrovia vae reta cua uicuaa yave, güɨraa reta Saulo Cesarea pe, jare joco güi omondo tenta guasu Tarso cotɨ. ");
INSERT INTO gnwNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Jayave umambeco'ã ma quía upurugüɨrovia vae reta, jare jae reta uñemɨmɨrãta opaete Judea rupi, Galilea rupi jare Samaria rupi. Jare yugüɨreco reta uipɨu cavi reve yandeYa, jare Espíritu Santo umbɨpɨacatu. Jare jecuaeño ĩru vae reta uñemɨĩru jae reta ndive. ");
INSERT INTO gnwNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Jare Pedro oo opou yave opaete upurugüɨrovia vae reta ñugüɨnoi vae rupi, oo uvãe tenta guasu Lida pegua reta pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Joco pe uvãe penti cuimbae Eneas jee vae ocho año ma ico jupa pe vae. Echa'ã ipuere mbae omɨ vae. ");
INSERT INTO gnwNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Jare Pedro jei chupe: —Eneas, Jesucristo nembɨgüera ma. Epũa ipɨso nderupa —jei. Jare jupivoiño jae upũa. ");
INSERT INTO gnwNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Jare opaete Lida pegua reta jare tenta tenta ñuu Sarón pegua reta uecha cua cuimbae, jare uyerova reta yandeYa cotɨ. ");
INSERT INTO gnwNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Jare ico tenta guasu Jope pe penti cuña upurugüɨrovia vae Tabita jee vae. (Cua tee uipota jei ambɨe ñee pe: Dorcas.) Cua cuña uyapo jeta icavi vae, jare umeei jeta mbae iparavete vae reta pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Jayave imbaerasɨ, jare umano. Jare ĩru vae reta opa umbɨyau yave, oñono penti o ɨvate vae pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Jare Lida coiño oĩ Jope güi. Jare upurugüɨrovia vae Jope pegua reta uicuaa ma yave Pedro oĩ Lida pe, omondo icotɨ mocui cuimbae reta jei vaerã chupe: —Ecua Jope pe ɨmambae. ");
INSERT INTO gnwNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Jayave Pedro upũa ou jae reta jupíe. Jare ou uvãe yave, ĩru vae reta güɨraa o ɨvate vae pe. Joco pe opaete ime umano vae reta yatɨ uyao ñugüɨnoi, jare uechaca Pedro pe temimonde Dorcas jae reta ndive ico yave uyapocue vae reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Jayave Pedro omoẽ opaete joco pe ñugüɨnoi vae reta. Jayave uyeatɨca jare uyerure Tumpa pe. Jayave uyerova umae teõgüe re jare jei: —Tabita, epũa. Jayave cuña umae, jare uecha Pedro yave, upũa uguapɨ. ");
INSERT INTO gnwNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Jayave Pedro uipɨsɨ ipo pe, jare umupũa. Jayave ueni upurugüɨrovia vae reta jare ime umano vae reta, jare uechaca chupe reta icove ye ma co. ");
INSERT INTO gnwNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Jare cua jerãcua opaete Jope pegua reta pe. Jare jeta vae güɨrovia yandeYa re. ");
INSERT INTO gnwNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Jare Pedro upɨta ɨma Jope pe. Ico penti guacapi umɨpɨ̃ta vae Simón jee vae jenta pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ico Cesarea pe penti cuimbae Cornelio jee vae. Jae co sundaro reta juvicha penti atɨ Italiana jee vae pegua. ");
INSERT INTO gnwNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Jae jare opaete jenta pegua reta umbɨadora Tumpa, jare jae umeei jeta mbae iparavete vae reta pe, jare jecuaeñoi uyerure Tumpa pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Cua cuimbae uecha cavi ique pe penti ángel Tumpa pe uyeyocui vae uique jae oĩ vae pe mbapɨ ora ma caaru yave. Ángel jei chupe: —Cornelio. ");
INSERT INTO gnwNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Cornelio uquɨye reve umae ngatu ángel re jare upɨrandu: —¿Mbae pa, cheYa? Jare ángel jei chupe: —Tumpa imandúa ndiyerure reta jare mbae nemeei vae reta re. ");
INSERT INTO gnwNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Añave emondo cuimbae reta Jope pe, güeru vaerã penti cuimbae Simón jee vae. Jae uyembɨjee Pedro pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Jae ico penti guacapi umɨpɨ̃ta vae Simón ipɨ. Simón jenta oĩ ɨ guasu jembeɨ pe —jei. ");
INSERT INTO gnwNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ángel uyemɨngueta jae ndive vae oo ma yave, Cornelio ueni mocui jembiocui reta jare penti sundaro umbɨadora Tumpa vae. Cua sundaro vi uyeyocui Cornelio pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Jare opa umɨmbeu cavi chupe reta yave, omondo Jope cotɨ. ");
INSERT INTO gnwNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Pɨareve pe guarasɨ ara mbɨteta ma yave, jae reta yugüɨraa tape rupi coiño ma Jope güi rambueve, Pedro uyupi tenta iárambo, uyerure vaerã Tumpa pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Jare iyembaɨ, jare uipota ucaru. Ẽrei ĩru vae reta omboyɨ ñugüɨnoi rambueve jembiurã, Pedro oque. ");
INSERT INTO gnwNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Jare ique pe uecha ara uyepea jare penti nieso tuicha vae rami vae ugüeyɨ ou icotɨ. Cua uyembɨgüeyɨ uyepɨsɨ reve irundɨ jembeɨ reta pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Cua nieso japɨpe pe ñugüɨnoi ipotave maemɨmba uguata vae reta jare opoñɨ vae reta, jare ipotave güɨra reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Jare ou Pedro pe penti ñee: —Pedro, epũa iyuca jeu. ");
INSERT INTO gnwNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ẽrei Pedro jei: —Ndarau, cheYa. Jau'ã etei co mboroyocui jei agüɨye vaerã jau vae. Icavi'ã co —jei. ");
INSERT INTO gnwNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Jayave ñee jei chupe: —Tumpa umee ndeu vaerã vae, agüɨye erɨ̃ro. ");
INSERT INTO gnwNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Cua mbapɨ vese ma uyeyapo yave, nieso rami vae uyereraa ye ara pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Jare Pedro ipɨacañɨ reve ipɨa pe uyemɨngueta oĩ rambueve mbae re ra uyemɨjaanga cua ique pe uecha vae, cuimbae Cornelio ombou vae reta upɨrandu yugüeru Simón jenta re, jare yugüeru ma uvãe onque pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Jare jae reta ueni upɨrandu joco pe ra ico Simón uyembɨjee Pedro pe vae. ");
INSERT INTO gnwNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Jare Pedro ipɨa pe uyemɨngueta oĩ rambueve jocua ique pe uecha vae re, Espíritu Santo jei chupe: —Mase, mbapɨ cuimbae reta ndereca. ");
INSERT INTO gnwNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Epũa egüeyɨ ecua jae reta jupíe neatẽɨ mbae reve. Echa'ã che co ambou —jei. ");
INSERT INTO gnwNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Jayave Pedro ugüeyɨ cuimbae Cornelio ombou vae reta ñugüɨnoi vae pe, jare jei chupe reta: —Che co jae pe reta peeca vae. ¿Maera pa peyu chereca? ");
INSERT INTO gnwNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Jayave cuimbae reta jei Pedro pe: —Ime penti cuimbae Cornelio jee vae. Jae co cuimbae jupi vae. Umbɨadora co Tumpa. Jae co sundaro reta juvicha opaete judío reta uyemɨngueta cavi jese vae. Penti ángel Tumpa pe uyeyocui vae jei chupe ndereruca vaerã jenta pe, jae uyapɨsaca vaerã nemɨmbeuta chupe vae re —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Jayave Pedro uruique cuimbae reta, jare umɨmbɨta joco pe. Jayave pɨareve pe Pedro upũa oo jae reta jupíe. Jare amocue upurugüɨrovia vae Jope pegua reta yugüɨraa jae jupíe. ");
INSERT INTO gnwNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Jare pɨareve pe yugüɨraa uvãe Cesarea pe. Jare Cornelio umbatɨ ma jentarã reta jare iĩru reta, jare uãro oĩ Pedro. ");
INSERT INTO gnwNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Jare Pedro uiqueta ma yave tenta pe, Cornelio oo oovãiti jare uyeatɨca Pedro jovai umbɨadora vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ẽrei Pedro jei chupe: —Epũa. Che cuimbaeño vi co. Jare umupũa. ");
INSERT INTO gnwNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Jare uyemɨngueta jae ndive rambueve, Pedro uique tenta pe, jare uecha jeta vae yatɨ ñugüɨnoi joco pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Jayave Pedro jei chupe reta: —Pe reta picuaa cavi co quirãi penti judío ipuere'ã uñemɨĩru penti judío mbae vae ndive, jare quirãi ipuere'ã opou ipɨ. Ẽrei Tumpa uechaca cheve quirãi icavi'ã aeni vaerã penti vae yepe iquɨa vae, yepe tẽi uyapo'ã mboroyocui. ");
INSERT INTO gnwNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Jáeramo pe reta cherenica yave, ayu cheatẽɨ mbae reve. Añave tapɨrandu peve, ¿maera pa cherenica? —jei Pedro. ");
INSERT INTO gnwNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Jayave Cornelio jei chupe: —Irundɨ ara ma uasa cuarãi yave ayerure aĩ ayecuacu reve tembíu güi cua cherenta pe. Jare aramoiño mbapɨ ora ma caaru yave aecha penti cuimbae uyemboɨ oĩ cherovai. Jemimonde jembipe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Jae jei cheve: Cornelio, ndiyerure uyendu ma, jare Tumpa imandúa ma mbae nemeei vae reta re. ");
INSERT INTO gnwNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Emondo quía Jope pe, jare eruruca Simón uyembɨjee Pedro pe vae. Jae ico penti guacapi umɨpɨ̃ta vae Simón ipɨ. Simón jenta oĩ ɨ guasu jembeɨ pe. Ou yave, jae nemɨnguetata —jei cheve, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Jáeramo jupivoiño amondo ndecotɨ, jare yasurupai ndeyu vae re. Añave ore co noĩ opaete cua pe Tumpa jovaque, nduyandu vaerã opaete Tumpa ndeocui vae re —jei. ");
INSERT INTO gnwNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Jayave Pedro jei chupe reta: —Añetete aicuaa ma quirãi Tumpa uau'ã penti vaeño ĩru vae güi. ");
INSERT INTO gnwNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Echa'ã jocua umbɨadora jare jupi vae uyapo vae ipotave ɨvɨ pegua icavi co Tumpa pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Tumpa ombou ñee icavi vae Israel pegua reta pe. Jae umɨmbeu chupe reta ime mbɨacatu Jesucristo re. Jesucristo co jae opaete vae iYa —jei Pedro—. ");
INSERT INTO gnwNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","38","Juan umɨmbeu uyapɨsaca jese vae reta pe uyembɨbautizaca vaerã. Cua jaɨcue rupi Jesús Nazaret pegua jerãcua Galilea pe jare opaete Judea rupi. Jerãcua quirãi Tumpa umee chupe Espíritu Santo jare mbaepuere, jare quirãi jae oo opaete que rupi uyapo icavi vae, jare quirãi umbɨgüera opaete aña guasu uiporaraca chupe vae reta. Echa'ã Tumpa ico jae ndive. Opaete cua pe reta picuaa co —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Jare ore numɨmbeu ĩru vae reta pe opaete Jesús uyapo Judea rupi jare Jerusalén pe vae. Jayave judío reta uicutuca curusu re uyucaca —jei Pedro chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ẽrei Tumpa umbɨjecove ye güeru umanocue vae reta ipɨte güi mbapɨ ara umano rendave pe, jare umbɨyecuaa. ");
INSERT INTO gnwNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Umbɨyecuaa'ã opaete vae pe, jaeño oreve. Echa'ã tenonde ma Tumpa oreparavo numɨmbeu vaerã ĩru vae reta pe. Ore nducaru jare ɨ ndou jae ndive, icove ye yave ou umanocue vae reta ipɨte güi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Jare jae oreocui numɨmbeu vaerã ĩru vae reta pe quirãi Tumpa uiparavo uãa vaerã icove vae reta jare umanocue vae reta —jei Pedro—. ");
INSERT INTO gnwNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Cua regua co umɨmbeu opaete Tumpa iñee aracae umɨmbeu vae reta. Echa'ã jae reta jei Tumpa umbɨasata opaete jese güɨrovia vae reta pe imbaeyoa reta jae jeco pegua —jei. ");
INSERT INTO gnwNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Jare Pedro imiari oĩ rambueve, Espíritu Santo ou opaete cua ñee uyandu vae reta pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Jare judío upurugüɨrovia vae Pedro jupíe yugüeru vae reta ipɨacañɨ quirãi judío mbae vae reta pe vi uñemee Espíritu Santo vae re. ");
INSERT INTO gnwNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Echa'ã jae reta uyandu uyemɨngueta reta ambɨe vae iñee pe. Jare uyandu vi umbɨadora Tumpa. ");
INSERT INTO gnwNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Jayave Pedro jei: —¿Quía pa umbɨavaita agüɨye vaerã uyembɨbautizaca cua reta? Echa'ã Espíritu Santo ou ma chupe reta, yandeve ou rami —jei. ");
INSERT INTO gnwNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Jayave Pedro oyocui uyembɨbautizaca vaerã yandeYa Jesús jee re. Jayave joco pegua reta umɨñera Pedro upɨta vaerã jae reta ndive mbovɨ ara pegua. ");
INSERT INTO gnwNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Jayave Jesús jemimondo reta jare ĩru upurugüɨrovia vae Judea rupi ñugüɨnoi vae reta uicuaa quirãi judío mbae vae reta vi güɨrovia Tumpa iñee. ");
INSERT INTO gnwNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Jayave Pedro oo ye uvãe yave Jerusalén pe, judío upurugüɨrovia vae reta uñeengata chupe. ");
INSERT INTO gnwNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Jae reta jei: —¿Maera pa ndique judío mbae vae reta jenta pe? ¿Maera pa ndecaru jae reta ndive? —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Jayave Pedro iyɨpɨ güive umbɨpɨ umɨmbeu cavi chupe reta opaete uyeyapo vae. Jae jei chupe reta: ");
INSERT INTO gnwNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","—Che ayerure aĩ yave tenta guasu Jope pe, cheque pe aecha penti nieso tuicha vae rami vae ugüeyɨ ou checotɨ. Cua uyembɨgüeyɨ ara güi uyepɨsɨ reve irundɨ jembeɨ reta pe ou uvãe cheve —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Amae ngatu jese yave, aecha maemɨmba uguata vae reta, amocue pochɨ vae jare amocue pochɨ mbae vae, jare maemɨmba opoñɨ vae reta, jare güɨra reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Jare ayandu vi penti ñee jei cheve: ‘Pedro, epũa iyuca jeu’ —jei, jei Pedro—. ");
INSERT INTO gnwNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ẽrei che jae: ‘Ndarau, cheYa. Jau'ã etei co mboroyocui jei agüɨye vaerã jau vae. Icavi'ã co’ —jae chupe, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ẽrei ñee ou ara güi vae jei cheve: ‘Tumpa umee ndeu vaerã vae, agüɨye erɨ̃ro’ —jei cheve, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Jare cua mbapɨ vese ma uyeyapo yave, opaete uyereraa ye ara pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Jare jupivoiño yugüeru uvãe che aico vae pe mbapɨ cuimbae Cesarea güi Cornelio ombou vae reta —jei Pedro—. ");
INSERT INTO gnwNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Jare Espíritu Santo jei cheve aa vaerã jae reta jupíe cheatẽɨ mbae reve. Jare cua seis upurugüɨrovia vae reta vi yugüɨraa cherupíe, jare nduique jocua cuimbae jenta pe —jei. ");
INSERT INTO gnwNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Jare jocua cuimbae umɨmbeu oreve quirãi uecha penti ángel uyemboɨ oĩ jae jo pe, jare quirãi ángel jei chupe: ‘Emondo cuimbae reta Jope pe eruruca penti cuimbae Simón jee vae. Jae uyembɨjee Pedro pe’ —jei chupe, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Jae umɨmbeuta ndeve ñee, nde jare opaete nerenta pegua reta piyembɨasaca vaerã —jei chupe, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Jayave che ambɨpɨ amɨngueta reta yave, Espíritu Santo ou chupe reta, yandeve tenonde yave ou rami. ");
INSERT INTO gnwNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Jayave chemandúa yandeYa jei yandeve vae re. Echa'ã jei: ‘Juan upurumbɨbautiza ɨ pe. Ẽrei pe reta piyembɨbautizacata Espíritu Santo pe’ —jei yandeYa, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Tumpa umee chupe reta Espíritu Santo yande yarovia yandeYa Jesucristo re vae pe umee vae. Jáeramo che chepuere'ã etei ambɨavai Tumpa uyapo vae —jei. ");
INSERT INTO gnwNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Jayave cua Pedro jei chupe reta vae uyandu yave, jae reta ipuere'ã ma mbae jei. Umbɨadoraño Tumpa, jare jei reta: —Tumpa umaeño vi judío mbae vae reta re ueya vaerã iyemɨngueta icavi mbae vae ipɨa pe oĩ vae, güɨnoi vaerã tecove opa mbae vae. ");
INSERT INTO gnwNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Jare Esteban uyuca yave, jovaicho reta uiporaraca upurugüɨrovia vae reta pe. Jare upurugüɨrovia vae reta opa uñemɨai, jare yugüɨraa uvãe ɨvɨ Fenicia, Chipre jare Antioquía pe. Jare jae reta umɨmbeu judío reta peño Tumpa iñee. ");
INSERT INTO gnwNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ẽrei jae reta ipɨte pe ñugüɨnoi amocue cuimbae Chipre jare Cirene pegua. Cua reta yugüɨraa uvãe yave Antioquía pe, umɨngueta judío mbae vae reta pe vi, jare umɨmbeu chupe reta ñee icavi vae yandeYa Jesús regua. ");
INSERT INTO gnwNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Jare yandeYa omborɨ, jare jeta vae güɨrovia jare uyerova yandeYa cotɨ. ");
INSERT INTO gnwNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Jare cua jerãcua upurugüɨrovia vae Jerusalén pe ñugüɨnoi vae reta pe. Jayave jae reta omondo Bernabé Antioquía pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Jare jae oo uvãe yave, uecha jocua uyeyapo Tumpa ipɨacavi jeco pegua vae, jare uyerovia. Jayave jei chupe reta jecuaeño uguata cavi vaerã yandeYa ndive ipɨrãta reve ipɨa pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Echa'ã Bernabé co jae cuimbae ipɨacavi vae. Jae upurugüɨrovia cavi, jare tɨnee Espíritu Santo pe. Jare jeta vae güɨrovia yandeYa re jare uñemɨĩru upurugüɨrovia vae reta ndive. ");
INSERT INTO gnwNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Cua jaɨcue rupi Bernabé oo Tarso pe, ueca vaerã Saulo. Jare uvãe chupe yave, güeru Antioquía pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Jare joco pe uñemɨĩru reta penti año upurugüɨrovia vae reta ndive, jare omboe jeta vae. Jare Antioquía pe jaeramo etei ĩru vae reta umbɨpɨ jei upurugüɨrovia vae reta re: —Cua reta co jae cristiano reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Jare jocua ara reta pe amocue Tumpa iñee umɨmbeu vae reta yugüeru Jerusalén güi Antioquía pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Penti jee co Agabo. Jae upũa uyemboɨ, jare jei Espíritu Santo rupi imeta co caruai tuicha vae opaete ɨvɨ rupi. Cua uyeyapo Claudio mburuvicha guasurã ico yave. ");
INSERT INTO gnwNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Jayave penti penti upurugüɨrovia vae reta iquɨrẽɨ omondo ime güɨnoi vae güi, omborɨ vaerã upurugüɨrovia vae Judea rupi ñugüɨnoi vae reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Jare jucuarãi uyapo reta. Jare jae reta omondo upurugüɨrovia vae reta itenondegua reta pe Bernabé jare Saulo ndive. ");
INSERT INTO gnwNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Jocua ara reta pe mburuvicha guasu Herodes uipɨsɨca amocue upurugüɨrovia vae reta, uyapo vaerã icavi mbae vae chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Jare uyucaca quɨse pe Jacobo - jae co Juan tɨqueɨ. ");
INSERT INTO gnwNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Jare Herodes uicuaa yave cua uyapo vae icavi judío reta pe, uipɨsɨca Pedro vi. Jocua ara reta pe judío reta jou ñugüɨnoi mbɨyape ovu mbae vae. ");
INSERT INTO gnwNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Jare uipɨsɨca ma yave, oñonoca peresorɨru pe. Umee irundɨ atɨ sundaro reta pe uyandareco jese vaerã. Penti penti atɨ güɨnoi irundɨ sundaro. Herodes uipota tẽi güɨnoẽca Pedro tenta guasu pegua reta jovai pascua uasa ma yave. ");
INSERT INTO gnwNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Jayave sundaro reta uyandareco Pedro re peresorɨru pe. Ẽrei upurugüɨrovia vae reta icueri mbae reve uyerure Tumpa pe jese. ");
INSERT INTO gnwNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Pɨareve pe ma Herodes güɨnoẽcata tẽi yave, jocua pɨ̃tu etei Pedro oque oĩ mocui sundaro ipãu pe, jare uñeapɨ̃ti oĩ mocui cadena pe. Jare sundaro reta peresorɨru jonque uãro ñugüɨnoi. ");
INSERT INTO gnwNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Jare aramoiño penti ángel yandeYa pe uyeyocui vae uyecuaa, jare penti tembipe uesape peresorɨru pe. Jayave ángel uñatai Pedro iyɨque pe umbɨsareco vaerã, jare jei chupe: —Epũa voi. Jare cadena reta uyera ipapɨ güi. ");
INSERT INTO gnwNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Jayave ángel jei chupe: —Iyemonde jare emonde vi ndepɨpasa. Jare Pedro jucuarãi uyapo. Jayave ángel jei chupe: —Iñeñoma ndeasoya pe, jare eyu cheraɨcue. ");
INSERT INTO gnwNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Jayave Pedro oẽ oo ángel jaɨcue rupi. Jae uicuaa'ã añete ra ángel uyapo vae. Ipɨa pe uyemɨngueta tẽi opaete cua uecha oĩ ique pe vae. ");
INSERT INTO gnwNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Uasa ma yave mocui sundaro peresorɨru uãro vae, yugüɨraa uvãe onque fierro calle cotɨ oo vae pe. Cua onque jaei uyepea chupe reta. Jare oẽ reta ma yave, uguata reta penti calle rupi. Jayave aramoiño ángel oo Pedro güi ueya. ");
INSERT INTO gnwNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Jayave ramo Pedro uicuaa cua uyeyapo vae añete co, jare jei iyupe: —Añave aicuaa cheYa co ombou ángel jare cherepɨca Herodes güi jare opaete judío reta uipota uyapo cheve vae güi. ");
INSERT INTO gnwNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Cua re ipɨa pe uyemɨngueta rambueve, oo uvãe María jenta pe. María co jae Juan Marcos ichɨ. Joco pe jeta vae yatɨ uyerure ñugüɨnoi Tumpa pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pedro ombopu onque, jare oẽ tenta güi penti cuñatai Rode jee vae uyapɨsaca vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Cua cuñatai uicuaa Pedro iñee, ẽrei uyerovia güi uipea'ã onque. Osi uique tenta pe, jare umɨmbeu ĩru reta pe Pedro co oĩ onque pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ẽrei jae reta jei chupe: —Nembɨquere co. Ẽrei jae jeiete jei añete co. Jayave jae reta jei: —Ãngel uyandarecose jese vae co. ");
INSERT INTO gnwNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ẽrei Pedro jecuae ombopu onque. Jare jae reta uipea yave, uecha jae co, jare ipɨacañɨ. ");
INSERT INTO gnwNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ẽrei Pedro umupũa ipo umɨquĩi reta vaerã, jare umɨmbeu chupe reta quirãi yandeYa güɨnoẽ peresorɨru güi. Jare jei chupe reta: —Picuaaca cua Jacobo jare ĩru upurugüɨrovia vae reta pe. Jayave oẽ oo joco güi icotɨ'ã. ");
INSERT INTO gnwNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Jare cõe rupive sundaro reta uyemɨpɨa'ã ete. Echa'ã uicuaa'ã mbae ra uyeyapo Pedro pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Jare Herodes uecaca tẽi yave, Pedro uñevãe'ã. Jayave Herodes upɨrandu sundaro reta pe jese. Jayave oyocui sundaro reta uyeyucaca vaerã. Jayave Herodes oo Judea güi Cesarea pe, jare upɨta joco pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Jare Herodes pochɨ ico Tiro pegua reta jare Sidón pegua reta cotɨ. Jayave jae reta penti rami yugüeru ipɨ, jare uñemɨĩru reta penti mburuvicha guasu jembiocui tenondegua vae Blasto jee vae ndive. Jae reta jei chupe agüɨye vaerã mburuvicha guasu pochɨ chupe reta. Echa'ã jae reta güeru jembiurã mburuvicha guasu Herodes iɨvɨ güi. ");
INSERT INTO gnwNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Jare Herodes uiparavo penti ara imiari vaerã chupe reta. Jayave jocua ara Herodes uyemonde cavi, jare uguapɨ mburuvicha upuruãa vae pe, jare imiari chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Jare jae reta iñeeãta reve jei: —Tumpa iñee co, cuimbae iñee'ã co. ");
INSERT INTO gnwNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Jare jupivoiño penti ángel yandeYa pe uyeyocui vae umɨmbaerasɨ Herodes taso pe. Echa'ã Herodes umbɨadora'ã Tumpa. Jáeramo umano. ");
INSERT INTO gnwNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ẽrei Tumpa iñee uñemɨai, jare jeta vae upurugüɨrovia. ");
INSERT INTO gnwNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Jare Bernabé jare Saulo yugüeru ye Jerusalén güi, iparavɨquɨ joco pe uyapo ma yave. Jare güeru jae reta jupíe Juan Marcos. ");
INSERT INTO gnwNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Jare yugüɨreco upurugüɨrovia vae Antioquía pe ñugüɨnoi vae reta ipɨte pe amocue Tumpa iñee umɨmbeu vae reta jare Tumpa iñee re oporomboe vae reta. Jae reta co Bernabé, Simón Niger, Lucio Cirene pegua, mburuvicha guasu Herodes jentarã Manaén jee vae jare Saulo. ");
INSERT INTO gnwNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Cua reta uyeyocui yandeYa pe jare uyecuacu tembíu güi rambueve, Espíritu Santo jei chupe reta: —Pemondo Bernabé jare Saulo uyapo vaerã mbaravɨquɨ che aiparavo ma chupeguarã vae. ");
INSERT INTO gnwNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Jare uyecuacu reta tembíu güi, jare uyerure reta Tumpa pe. Jayave ĩru reta oñono ipo jese reta jare omondo. ");
INSERT INTO gnwNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Jayave Saulo jare Bernabé uyemondoca Espíritu Santo pe, jare yugüɨraa tenta guasu Seleucia pe, jare joco güi uasa ɨ guasu rupi ɨvɨ Chipre pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Jare yugüɨraa uvãe yave tenta guasu Salamina pe, umɨmbeu reta Tumpa iñee judío reta itupao reta pe. Jare Juan oo jae reta ndive omborɨ vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Jare opaete Chipre umbapɨ yave, yugüɨraa uvãe tenta guasu Pafos pe, jare joco pe uñevãe penti judío Barjesús jee vae ndive. Jae co penti ipaye vae, jare jei jae co penti Tumpa iñee umɨmbeu vae. Cua jei upurumbɨtavɨ vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Cua cuimbae oĩ mburuvicha Sergio Paulo jee vae ndive. Cua mburuvicha iyaracuaa catu co. Jae ueni Bernabé jare Saulo, jare uipota uyapɨsaca Tumpa iñee re. ");
INSERT INTO gnwNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ẽrei Elimas (cua tee uipota jei: “Ipaye vae”) umbɨavai, agüɨye vaerã tẽi mburuvicha upurugüɨrovia. ");
INSERT INTO gnwNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Ẽrei Saulo (uyembɨjee vi Pablo pe vae) tɨnee Espíritu Santo pe, jare umae ngatu Elimas re ");
INSERT INTO gnwNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","jare jei chupe: —Nde co jae aña guasu taɨ upurumbɨtavɨ vae. Nde ndiyapo icavi mbae vae, jare ndipota'ã ĩru vae reta uyapo vaerã jupi vae. Jecuaeño ndeporoyopia yandeYa jape icavi vae güi. ");
INSERT INTO gnwNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Mase, añave yandeYa tombou ipo nderé, nderesa mbae ndico vaerã. Ndarau ndeecha guarasɨ mbovɨ ara pegua —jei. Jare jupivoiño Elimas ipuere'ã mbae uecha, pɨ̃tumimbi oĩ yave rami, jare cotɨ cotɨ uyerova ueca tẽi quía uipoco güɨraa vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Jayave mburuvicha cua uyeyapo vae uecha yave, güɨrovia Tumpa iñee. Echa'ã ipɨacañɨ yandeYa iporomboe re. ");
INSERT INTO gnwNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Jayave Pablo jare jae ndive ñugüɨnoi vae reta yugüɨraa Pafos güi, jare uasa ɨ guasu rupi tenta guasu Perge ɨvɨ Panfilia pegua pe. Ẽrei Juan ueya reta oo ye Jerusalén cotɨ. ");
INSERT INTO gnwNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Jayave jae reta yugüɨraa Perge güi tenta guasu Antioquía Pisidia pegua cotɨ. Jare joco pe yugüɨraa uvãe yave, uique reta judío reta itupao pe mbutuu ara pe, jare uguapɨ reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Jare ĩru vae reta opa umɨngueta yave mboroyocui güi jare Tumpa iñee aracae umɨmbeu vae reta uicuatiacue güi, tupao pegua reta itenondegua reta omondo jei chupe reta: —Orerɨvɨ reta, ime yave ñee penoi orembɨaracuaa vaerã, pepuere piyemɨngueta. ");
INSERT INTO gnwNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Jayave Pablo upũa, jare umupũa ipo umɨquĩi reta vaerã. Jayave jei chupe reta: —Cuimbae Israel pegua reta jare opaete pe reta Tumpa re pipɨu vae, piyapɨsaca cheré. ");
INSERT INTO gnwNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Israel pegua reta iTumpa uiparavo yandetenondegua reta, jare umbutuichaca Egipto pe yugüɨreco rambueve. Ẽrei Egipto jae reta iɨvɨ'ã co. Jare Tumpa imbaepuere tuicha vae pe güɨnoẽ joco güi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Jare cuarenta año urupɨa chupe reta ñana rupi. ");
INSERT INTO gnwNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Jare opa umbai yave Canaán güi siete ɨvɨ ambɨembɨe vae pegua reta, umee cua reta iɨvɨcue Israel pegua reta pe iɨvɨrã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Cua jaɨcue rupi cuatrocientos cincuenta año rupi Tumpa umee chupe reta mburuvicha reta uãa vaerã Samuel oĩ regua. Samuel co jae Tumpa iñee aracae umɨmbeu vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Jayave jae reta uyerure mburuvicha guasu re. Jayave Tumpa umee chupe reta Cis taɨ Saúl jee vae cuarenta año pegua. Jae co penti cuimbae Benjamín iñemoñaa pegua. ");
INSERT INTO gnwNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Jare Tumpa cua cuimbae omombo yave, umee chupe reta David juvicha guasurã. Jare Tumpa jei David re: ‘Che aicuaa Isaí taɨ David. Jae co penti cuimbae chembɨyerovia vae. Jae uyapota opaete che aipota vae’ —jei, jei Pablo—. ");
INSERT INTO gnwNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Cua David iñemoñaa reta güi Tumpa umee Jesús. Jae co Israel pegua reta umbɨasa vae. Jucuarãi Tumpa uyapo ma aracae jei vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Ndei Jesús ou mbove, Juan umɨmbeu opaete Israel pegua reta pe ueya vaerã iyemɨngueta icavi mbae vae ipɨa pe oĩ vae, jare uyembɨbautizaca vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Jare Juan opata ma umɨmbeu chupe reta yave, jei: ‘Pe reta pepɨa pe piyemɨngueta tẽi che co jae. Ẽrei jucuarãi'ã. Co ou cheraɨcue ĩru vae. Jupi'ã co che amboi vaerã ipɨpasa’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Cherɨqueɨ reta, pe reta co jae Abraham iñemoñaa reta jare ĩru vae reta pe reta Tumpa re pipɨu vae co. Tumpa ombou peve cua ñee piyembɨasaca vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Echa'ã Jerusalén pegua reta jare juvicha reta uicuaa'ã quía ra co jae Jesús. Uicuaa'ã vi Tumpa iñee aracae umɨmbeu vae reta uicuatiacue opa mbutuu ara pe jae reta umɨngueta tẽi vae. Jáeramo jae reta jei Jesús uyeyucaca vaerã, jare jucuarãi uyeyapo uyecuatía oĩ jese vae —jei Pablo—. ");
INSERT INTO gnwNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Jare yepe tẽi uvãe'ã teco Jesús re uyucaca reta vaerã, ẽrei uyerure Pilato pe uyucaca vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Jare jae reta opa ma uyapo chupe yave opaete jese uyecuatía oĩ vae, umbɨgüeyɨca reta curusu güi, jare oñonoca teõgüerɨru pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ẽrei Tumpa umbɨjecove ye güeru umanocue vae reta ipɨte güi. ");
INSERT INTO gnwNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Jare jeta ara uyecuaa jae jupíe yugüɨraa Galilea güi Jerusalén pe vae reta pe. Jae reta añave umɨmbeu ĩru vae reta pe —jei Pablo chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","Jare ore vi numɨmbeu peve ñee icavi vae, quirãi Tumpa jei yandetenondegua reta pe vae Tumpa etei uyapo ma yandeve. Echa'ã umbɨjecove ye Jesús güeru umanocue vae reta ipɨte güi. Uyecuatía oĩ Salmo mocui pe cuarãi: ‘Nde co jae cheRaɨ. Cua ara che co jae ndeRu.’ Jucuarãi uyecuatía oĩ. ");
INSERT INTO gnwNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Tumpa umbɨjecove ye güeru umanocue vae reta ipɨte güi, agüɨye vaerã etei jetecue icumegua. Jare cua re jei: ‘Tamee ndeve bendición reta David pe jae ameeta chupe vae’ —jei Tumpa, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Jáeramo jei ĩru Salmo pe: ‘Che co jae jupi vae. Nemaeñota'ã cheretecue re icumegua vaerã’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Echa'ã David opa uyeyocui yave opaete jentaɨgua reta pe Tumpa uipota vae rupi, umano, jare uñeñotɨca itenondegua reta ñugüɨnoi vae pe, jare jetecue icumegua —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ẽrei jocua Tumpa umbɨjecove ye güeru umanocue vae reta ipɨte güi vae jetecue icumegua'ã etei —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Jáeramo, cherɨqueɨ reta, picuaa cavi cua ore numɨmbeu ĩru vae reta pe vae. Tumpa umbɨasata peve pembaeyoa reta cua Jesús rupi. ");
INSERT INTO gnwNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Jare opaete güɨrovia jese vae reta uyembujupica ma. Echa'ã yandepuere'ã yayembujupica Moisés iporoyocui re —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Jáeramo piñemoa ngatu, agüɨye vaerã uyeyapo peve Tumpa iñee aracae umɨmbeu vae reta jei vae. Echa'ã jei reta cuarãi: ");
INSERT INTO gnwNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Mase, upurugüɨrɨ̃ro vae reta, pepɨacañɨ jare pecañɨtei’ —jei Tumpa—. ‘Echa'ã che ayapota penti mbaravɨquɨ pico rambueve. Pe reta ndarau perovia, yepe tẽi quía umɨmbeuta peve’ —jei. Jucuarãi jei reta —jei. ");
INSERT INTO gnwNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Jare oẽ reta yave judío reta itupao güi, judío mbae vae reta umɨñera umɨmbeu vaerã chupe reta cua ñee mbutuu ara outa vae pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Jare tupao pe yatɨ vae reta opa yugüɨraa yave, jeta judío reta jare judiorã uyeyapo vae umbɨadora Tumpa vae reta yugüɨraa Pablo jare Bernabé ndive. Cua mocui reve imiari chupe reta, jare oyocui jecuaeño uyeco reta vaerã Tumpa ipɨacavi re. ");
INSERT INTO gnwNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Jare mbutuu ara ou vae pe opaete seri tenta guasu pegua reta uyembatɨ, uyapɨsaca vaerã Tumpa iñee re. ");
INSERT INTO gnwNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ẽrei judío reta uecha yave jeta vae yatɨ, uñemɨagüɨ̃ro, jare jei añete'ã co Pablo jei vae, jare jei icavi mbae vae Pablo cotɨ. ");
INSERT INTO gnwNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Jayave Pablo jare Bernabé imiari uquɨye mbae reve chupe reta. Jei reta: —Añete icavi co ore numɨmbeu vaerã peve rani Tumpa iñee. Ẽrei perɨ̃ro ma. Pipota'ã ma. Jucuarãi picuaaca oreve penoita'ã co tecove opa mbae vae. Jáeramo añave numɨmbeuta judío mbae vae reta pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Echa'ã yandeYa oreocui cuarãi: ‘Pomondo judío mbae vae reta pe, peraa vaerã tembipe chupe reta, jare pemɨmbeu vaerã opaete ɨvɨ pegua reta pe Tumpa umbɨasata co.’ Jocuarãi oreocui —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Jare judío mbae vae reta uyandu yave cua ñee, tuicha uyerovia reta, jare umbutuicha Tumpa iñee. Jare güɨrovia opaete jocua Tumpa uiparavo tecove opa mbae vae güɨnoi vaerã vae reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Jare Tumpa iñee uñemɨai opaete jocua ɨvɨ rupi. ");
INSERT INTO gnwNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ẽrei judío reta omboemboe cuña tenta guasu pegua reta itenondegua uipɨu Tumpa vae reta jare cuimbae tenta guasu pegua reta itenondegua reta, jare umbɨpɨ uiporaraca Pablo jare Bernabé pe, jare omombo reta iɨvɨ güi. ");
INSERT INTO gnwNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Jayave Pablo jare Bernabé umɨtɨmo ɨvɨcuii ipɨ güi, uechaca vaerã tenta guasu pegua reta co teco güɨnoi, jare yugüɨraa tenta guasu Iconio cotɨ. ");
INSERT INTO gnwNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ẽrei upurugüɨrovia vae reta uyerovia ete, jare tɨnee Espíritu Santo pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Jare Iconio pe Pablo jare Bernabé uique pãve judío reta itupao pe, jare imiari reta joco pe ñugüɨnoi vae reta pe. Jáeramo jeta judío reta jare judío mbae vae reta upurugüɨrovia. ");
INSERT INTO gnwNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ẽrei judío upurugüɨrovia mbae vae reta omboemboe judío mbae vae reta, jare umɨtarẽɨca chupe reta upurugüɨrovia vae reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Jáeramo Pablo jare Bernabé upɨta joco pe ɨma pegua, jare imiari ĩru vae reta pe uquɨye mbae reve yandeYa re. Jare yandeYa uechaca añete co iñee mbɨacavi regua mɨacañɨ Pablo jare Bernabé uyapo vae reta rupi. ");
INSERT INTO gnwNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Ẽrei tenta guasu pegua reta uyembɨyao uyugüi. Amocue uñemɨĩru judío reta ndive, jare amocue uñemɨĩru Jesús jemimondo reta ndive. ");
INSERT INTO gnwNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Jare judío reta jare judío mbae vae reta juvicha reta ndive uipota upurupeña Jesús jemimondo reta re, uyapo vaerã tẽi icavi mbae vae chupe reta jare uyapi vaerã tẽi ita pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Ẽrei Pablo jare Bernabé cua uicuaa yave, osi yugüɨraa tenta guasu reta Listra jare Derbe pe jare cua mocui tenta guasu iyɨpɨ rupi. Cua tenta guasu reta co ɨvɨ Licaonia pegua. ");
INSERT INTO gnwNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Jare joco pe vi jae reta umɨmbeu ñee icavi vae. ");
INSERT INTO gnwNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Jare Listra pe uguapɨ oĩ penti cuimbae ipuere mbae uguata vae. Ichɨ jɨe güi oa güive ipuere'ã etei uguata. ");
INSERT INTO gnwNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Cua cuimbae uyandu Pablo imiari oĩ. Jare Pablo umae ngatu jese, jare uecha güɨnoi mburugüɨrovia ucuera vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Jayave Pablo iñeeãta reve jei chupe: —Epũa iyemboɨ. Jare jae upũa voi uyemboɨ jare umbɨpɨ uguata. ");
INSERT INTO gnwNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Jayave yatɨ vae reta uecha yave Pablo uyapo vae, jei reta Licaonia pegua reta iñee pe iñeeãta reve: —Tumpa cuimbae reta rami vae reta ugüeyɨ yandeve. ");
INSERT INTO gnwNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Jare jae reta umbɨjee Bernabé Júpiter, jare umbɨjee Pablo Mercurio. Echa'ã Pablo icatu imiari vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Jare jocua tumpa-raanga Júpiter jee vae itupao oĩ tenta guasu jovai. Jare Júpiter isacerdote güeru güeye reta jare mbaepotɨ reta tenta guasu jonque pe, jare jae jare yatɨ vae reta uipota tẽi uyuca güeye reta umbɨadora vaerã Pablo jare Bernabé. ");
INSERT INTO gnwNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Ẽrei Jesús jemimondo reta cua uicuaa yave, omondoro reta jemimondei, jare osi yatɨ vae reta ipɨte pe, jare iñeeãta reve jei chupe reta: ");
INSERT INTO gnwNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","—Cuimbae reta, ¿maera pa piyapo cua? Ore perapicha retaño co. Jare numɨmbeu peve piyerova vaerã cua icavi mbae vae piyapo vae güi Tumpa icove vae cotɨ. Echa'ã jae uyapo ara, ɨvɨ, ɨ guasu jare opaete mbaembae ime ñugüɨnoi pɨpe vae reta —jei reta—. ");
INSERT INTO gnwNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Tumpa umaeño aracae pegua reta re uyapo vaerã jae reta uipota vae. ");
INSERT INTO gnwNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ẽrei jae jecuaeño uyecuaa chupe reta mbaembae icavi vae jae uyapo vae rupi. Echa'ã jae ombou yandeve ama jare umbɨcuacuaa cavi temitɨ reta yanderembiurã ime vaerã. Jare jucuarãi uyapo, yayerovia vaerã —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Cua jei reta yave, añapea umbɨavai tenta guasu pegua reta agüɨye vaerã uyuca güeye reta umbɨadora vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Jayave amocue judío reta yugüeru Antioquía jare Iconio güi. Jae reta omboemboe tenta guasu pegua reta uyapi vaerã Pablo ita pe. Jare uyapi ma yave, umbɨtɨrɨrɨ güɨraa tenta guasu güi ñana cotɨ. Umano echa chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ẽrei upurugüɨrovia vae reta yugüeru uyembatɨ yave Pablo iyɨpɨ rupi, Pablo upũa oo ye tenta guasu pe. Jayave pɨareve pe oo Bernabé ndive Derbe cotɨ. ");
INSERT INTO gnwNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Jare umɨmbeu reta ñee icavi vae Derbe pe, jare jeta Derbe pegua reta güɨrovia Jesús re. Jayave Pablo jare Bernabé yugüeru ye Listra, Iconio jare Antioquía pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Jare cua tenta guasu reta pe jae reta umɨatangãtu upurugüɨrovia vae reta, jare umbɨaracuaa jecuaeño güɨnoi vaerã mburugüɨrovia Tumpa cotɨ. Jare jei vi chupe reta: —Jetañotai co yaiporara yaique vaerã Tumpa iporoyocuia pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Jare upurugüɨrovia vae reta uyembatɨmbatɨ vae pe Pablo jare Bernabé uiparavo upurugüɨrovia vae reta itenondegua retarã. Jare uyerure reta uyecuacu reve tembíu güi. Uyerure yandeYa pe jae uyandareco vaerã cua itenondegua reta re. Echa'ã güɨrovia reta ma yandeYa re. ");
INSERT INTO gnwNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Jayave Pablo jare Bernabé uasa Pisidia rupi, jare yugüɨraa uvãe Panfilia pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Jayave umɨmbeu ma yave Tumpa iñee Perge pe, yugüɨraa tenta guasu Atalia pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Jare joco güi uasa ɨ guasu rupi Antioquía cotɨ. Echa'ã upurugüɨrovia vae reta Antioquía pegua tenonde yave uyerure Tumpa pe ipɨacavi oĩ vaerã jae reta ndive cua mbaravɨquɨ opa ma uyapo vae re. ");
INSERT INTO gnwNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Jare yugüɨraa uvãe yave, Pablo jare Bernabé uyembatɨ upurugüɨrovia vae reta ndive, jare umɨmbeu chupe reta opaete Tumpa uyapo chupe reta vae, jare quirãi Tumpa umaeño judío mbae vae reta re upurugüɨrovia vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Jare upɨta reta joco pe ɨma pegua upurugüɨrovia vae reta ndive. ");
INSERT INTO gnwNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Jare yugüeru Judea güi amocue cuimbae reta, jare jei upurugüɨrovia vae reta pe: —Piñemɨcircuncidaca'ã yave Moisés iporoyocui pe jei rami, ndarau pepuere piyembɨasaca. ");
INSERT INTO gnwNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Jare Pablo jare Bernabé jeta uyeaca jae reta ndive cua re. Jayave upurugüɨrovia vae reta uiparavo Pablo jare Bernabé jare ĩru vae reta jae reta ipɨte güi, yugüɨraa vaerã Jerusalén pe uyemɨngueta cua re Jesús jemimondo reta jare upurugüɨrovia vae reta itenondegua reta ndive. ");
INSERT INTO gnwNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Jayave ĩru upurugüɨrovia vae reta omondo ma yave, jae reta uasa Fenicia jare Samaria rupi jare umɨmbeu joco pegua reta quirãi judío mbae vae reta uyerova Tumpa cotɨ. Jare umbɨyerovia ete upurugüɨrovia vae reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Jare yugüɨraa uvãe yave Jerusalén pe, Jesús jemimondo reta jare opaete upurugüɨrovia vae reta itenondegua reta ndive umbɨresive cavi reta. Jare Pablo jare Bernabé umɨmbeu chupe reta opaete Tumpa uyapo chupe reta vae. ");
INSERT INTO gnwNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Ẽrei amocue fariseo pegua upurugüɨrovia vae reta upũa jare jei: —Icavi co ñamɨcircuncidaca vaerã, jare yayocui uyapo vaerã Moisés iporoyocui. ");
INSERT INTO gnwNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Jayave Jesús jemimondo reta jare upurugüɨrovia vae reta itenondegua reta uyembatɨ, uyemɨngueta vaerã cua re. ");
INSERT INTO gnwNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Jare uyeaca ma uyupii yave, Pedro upũa jare jei chupe reta: —Cherɨvɨ reta, picuaa catu co quirãi caramboe yave Tumpa cheparavo amɨmbeu vaerã judío mbae vae reta pe ñee icavi vae, jae reta güɨrovia vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Tumpa uicuaa opaete vae ipɨa pe oĩ vae, jare jae uechaca jae reta güɨrovia co. Echa'ã umee chupe reta Espíritu Santo, yandeve umee rami —jei Pedro—. ");
INSERT INTO gnwNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Jare Tumpa umbɨyuavɨ'ã etei yandegüi. Echa'ã oyoe ma ipɨa, jae reta güɨrovia yave —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Jayave ¿maera pa pipota pembɨavai Tumpa? Echa'ã mboroyocui penti tɨvɨta rami. Pe reta pipota pembɨvɨta jocua upurugüɨrovia vae reta. Ẽrei yandetenondegua reta jare yande vi yandepuere'ã yavoɨ —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Yande yarovia yayembɨasaca ma co yandeYa Jesús ipɨacavi re, jae reta rami —jei. ");
INSERT INTO gnwNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Jayave opaete yatɨ vae reta iquĩiño, jare uyapɨsaca Bernabé jare Pablo jei vae re. Jae reta umɨmbeu chupe reta opaete mɨacañɨ reta Tumpa uyapo jae reta rupi judío mbae vae reta ipɨte pe vae. ");
INSERT INTO gnwNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Jare jae reta opa imiari yave, Jacobo jei: —Cherɨvɨ reta, piyapɨsaca cheré. ");
INSERT INTO gnwNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simón umɨmbeu ma yandeve quirãi Tumpa jaeramo etei uparavɨquɨ judío mbae vae reta ipɨte pe, uiparavo vaerã chugüi reta amocue jae jee umbɨadora vaerã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Cua re co jei vi Tumpa iñee aracae umɨmbeu vae reta. Uyecuatía oĩ cuarãi: ");
INSERT INTO gnwNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Cua jaɨcue rupi ayu yeta, jare ayapo yeta David jenta opa usururu vae’ —jei yandeYa—. ‘Amupũa yeta usururucue, jare ambɨpɨauta, ");
INSERT INTO gnwNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","opaete ĩru ɨvɨ pegua reta chereca vaerã, jare opaete judío mbae vae reta. Che co jae reta iYa. ");
INSERT INTO gnwNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Che aicuaaca cua aracae güive’ —jei yandeYa. Jucuarãi uyecuatía oĩ —jei chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Jáeramo che jae agüɨye yamambeco jocua judío mbae vae uyerova Tumpa cotɨ vae reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Ẽrei yaicuatía chupe reta agüɨye vaerã jou soo tumpa-raanga pe uñemee vae, jare maemɨmba uyeyuvɨ vae isoo, jare soo jugüɨ reve, jare agüɨye vaerã uyapo aguasa —jei Jacobo—. ");
INSERT INTO gnwNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Echa'ã aracae güive yugüɨreco tenta guasu guasu pe Moisés iporoyocui umɨmbeu vae reta. Opa mbutuu ara jae reta umɨngueta Moisés iporoyocui itupao reta pe —jei. ");
INSERT INTO gnwNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Jayave Jesús jemimondo reta jare opaete upurugüɨrovia vae reta itenondegua reta ndive jei icavi co uyeparavo vaerã amocue cuimbae reta jae reta ipɨte güi, omondo vaerã Antioquía pe Pablo jare Bernabé ndive. Jayave uiparavo Judas Barsabás jare Silas. Jae reta co upurugüɨrovia vae reta itenondegua reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Jare jae reta güɨraa tupapire. Cua tupapire pe jei cuarãi: “Ore co jae Jesús jemimondo reta jare opaete upurugüɨrovia vae reta itenondegua reta ndive. Nomondo numbɨsaluda opaete judío mbae vae upurugüɨrovia vae Antioquía, Siria jare Cilicia pegua reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Jerãcua oreve quirãi amocue orepɨte güi yugüɨraa pemambeco. Jucuarãi uyapo reta, yepe tẽi ore ndoyocui'ã. Jáeramo pe reta picuaa'ã mbae piyapo vaerã. Echa'ã jei reta piñemɨcircuncidaca vaerã jare piyapo vaerã mboroyocui pe uyecuatía oĩ vae. ");
INSERT INTO gnwNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Nduyemɨngueta ma cua re, jare ore opaete ndoe icavi co uyeparavo vaerã amocue orepɨte güi, nomondo vaerã pecotɨ Bernabé jare Pablo ndive. Nduau co Bernabé jare Pablo. ");
INSERT INTO gnwNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Jae reta iquɨrẽɨ umee jecove yandeYa Jesucristo pe uyeyocui vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Jáeramo nomondo pepɨ Judas jare Silas. Jae reta iñee pe etei umɨmbeuta vi peve cua. ");
INSERT INTO gnwNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Ore ndarau pumbɨavai. Cua mbovɨño numɨmbeuta peve. Cua icavi Espíritu Santo pe jare oreve vi. ");
INSERT INTO gnwNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Agüɨye peu soo tumpa-raanga pe uñemee vae, jare maemɨmba uyeyuvɨ vae isoo, jare soo jugüɨ reve. Jare agüɨye piyapo aguasa. Cua ore ndoe peve vae piyapo yave, icavita pico. Tumpa ndiveño.” Jucuarãi uyecuatía oĩ tupapire pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Jayave uyemondoca vae reta yugüɨraa uvãe Antioquía pe. Jare umbatɨ yave upurugüɨrovia vae reta, umee chupe reta tupapire. ");
INSERT INTO gnwNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Jare opa umɨngueta yave, opareve uyerovia cua ñee umbɨpɨacatu vae re. ");
INSERT INTO gnwNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Jare Judas jare Silas Tumpa iñee umɨmbeu vae reta co, jare jeta uyemɨngueta upurugüɨrovia vae reta pe, umbɨpɨacatu jare umɨmɨrãta vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Jare ɨma ma joco pe ñugüɨnoi yave, upurugüɨrovia vae reta omondo cavi ye ombou vae reta cotɨ. ");
INSERT INTO gnwNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Ẽrei icavi echa Silas pe upɨta vaerã joco pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Jare Pablo jare Bernabé upɨta Antioquía pe oporomboe Tumpa iñee re, jare umɨmbeu ñee icavi vae jeta ĩru vae reta ndive. ");
INSERT INTO gnwNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Mbovɨ ara rupi Pablo jei Bernabé pe: —Yaa ye yapou upurugüɨrovia vae reta pe opaete tenta guasu yamɨmbeu ma yandeYa iñee vae reta rupi, yaecha vaerã quirãi ra ñugüɨnoi. ");
INSERT INTO gnwNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Jare Bernabé uipota tẽi güɨraa jae reta jupíe Juan Marcos. ");
INSERT INTO gnwNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Ẽrei Pablo jei icavi'ã güɨraa vaerã jae reta jupíe. Echa'ã Juan Marcos ou ye Panfilia güi chugüi reta, jare oo'ã jae reta jupíe Tumpa iparavɨquɨ uyapo vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Jare uyeaca reta uyupii cua re. Jáeramo uyembɨyao reta uyugüi. Marcos oo Bernabé jupíe, jare jae reta uasa ɨ guasu rupi Chipre pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Ẽrei Pablo uiparavo Silas iguataĩrurã, jare upurugüɨrovia vae reta uyerure yandeYa pe ipɨacavi oĩ vaerã jae reta ndive. Jayave jae reta yugüɨraa. ");
INSERT INTO gnwNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Jare uasa reta ɨvɨ Siria jare Cilicia rupi umɨatangãtu reve upurugüɨrovia vae reta uyembatɨmbatɨ vae rupi. ");
INSERT INTO gnwNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Jayave yugüɨraa uvãe Derbe pe, jare joco güi yugüɨraa Listra pe. Jare joco pe ico penti upurugüɨrovia vae Timoteo jee vae. Ichɨ co jae penti judía upurugüɨrovia vae, jare tu co jae penti griego. ");
INSERT INTO gnwNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Upurugüɨrovia vae Listra jare Iconio pe ñugüɨnoi vae reta uyemɨngueta cavi Timoteo re. ");
INSERT INTO gnwNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pablo uipota güɨraa Timoteo jae reta jupíe. Jáeramo umɨcircuncidaca, jocoropi judío ñugüɨnoi vae reta jeco pegua. Echa'ã opaete vae uicuaa jae tu griego co. ");
INSERT INTO gnwNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Jare yugüɨraa rambueve tenta guasu reta rupi, umɨmbeu upurugüɨrovia vae reta pe Jesús jemimondo reta jare upurugüɨrovia vae reta itenondegua Jerusalén pe ñugüɨnoi vae reta uicuatía chupe reta vae, jae reta uyapo vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Jayave upurugüɨrovia vae reta uyembatɨmbatɨ vae rupi uñemɨatangãtu Tumpa cotɨ, jare opa ara rupi ĩru vae reta güɨrovia Jesús re jare uñemɨĩru jae reta ndive. ");
INSERT INTO gnwNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Jare Pablo jare jae ndive ñugüɨnoi vae reta uasa ɨvɨ Frigia jare Galacia rupi. Jare Espíritu Santo oyopia reta, agüɨye vaerã umɨmbeu Tumpa iñee Asia pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Jare ɨvɨ Misia pe yugüɨraa uvãe yave, uipota tẽi yugüɨraa ɨvɨ Bitinia pe. Ẽrei Espíritu Santo umaeño'ã yugüɨraa vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Jayave uasa reta coiño Misia güi, jare yugüɨraa uvãe tenta guasu Troas pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Jare pɨ̃tu yave Pablo uecha ique pe penti cuimbae ɨvɨ Macedonia pegua uyemboɨ oĩ joco pe. Jare cuimbae uyerure Pablo pe: —Ecua Macedonia pe oremborɨ. ");
INSERT INTO gnwNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Jare cua uecha ma yave, jupivoiño nduipota ndoo Macedonia cotɨ. Echa'ã nduicuaa ma Tumpa orereni numɨmbeu vaerã Macedonia pegua reta pe ñee icavi vae. ");
INSERT INTO gnwNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Jayave ndoo nduasa sɨmi ɨ guasu rupi Troas güi ɨvɨ Samotracia pe. Jayave pɨareve pe ndoo nuvãe tenta guasu Neápolis pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Jayave joco güi ndoo tenta guasu Filipos pe. Cua co tenta guasu tenondegua ɨvɨ Macedonia pegua, jare cua pe yugüeru yugüɨreco vaerã Roma pegua reta. Cua tenta guasu pe ndupɨta mbovɨ ara. ");
INSERT INTO gnwNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Jare mbutuu ara pe ndoo tenta guasu jonque rupi ɨãca jembeɨ pe. Joco pe oĩ penti yerurerenda. Jare joco pe nduguapɨ ma yave, oremiari cuña joco pe yatɨ vae reta pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Jare penti cuña Lidia jee vae tenta guasu Tiatira pegua uyapɨsaca oĩ. Cua cuña umbɨadora Tumpa. Jae co temimonde pɨ̃ta vae umee vae. Jare yandeYa uparavɨquɨ ipɨa pe, jae uyapɨsaca cavi vaerã Pablo jei vae re. ");
INSERT INTO gnwNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Jare jae jare jentarã reta uyembɨbautizaca ma yave, jae jei oreve: —Perovia yave che arovia cavi yandeYa re, peyu pepɨta cherenta pe. Jare oremɨñera ndupɨta vaerã joco pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Jare ndoo yave yerurearenda pe, orerovãiti penti cuñatai aña oya jese vae. Cua cuñatai iya reta umɨngana jeta corepoti jese. Echa'ã cuñatai umɨmbeu ĩru vae reta pe aña imbaepuere rupi mbae uyeyapota vae. ");
INSERT INTO gnwNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Cua cuñatai oo oreraɨcue, jare iñeeãta reve jei: —Cua cuimbae reta Tumpa ɨvate pegua jembiocui reta co. Jae reta umɨmbeu yandeve quirãi yandepuere yayembɨasaca —jei. ");
INSERT INTO gnwNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Jare jeta ara jucuarãi uyapo cuñatai. Jayave cua umambeco Pablo, jare jae uyerova jei aña pe: —Jesucristo jee re ndoyocui: ¡Esɨrɨ chugüi! Jare jupivoiño aña usɨrɨ chugüi. ");
INSERT INTO gnwNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Jare cuñatai iya reta uicuaa yave umɨnganata'ã ma co jese, uipɨsɨ reta Pablo jare Silas, jare güɨraa reta plaza pe mburuvicha reta pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Jare mburuvicha reta pe güɨraa ma yave, jei reta: —Cua cuimbae reta judío reta co, jare umambeco ete ñanerenta guasu pegua reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Jupi'ã yambɨresive vaerã ani yayapo vaerã cua moromboe umɨmbeu yandeve vae. Echa'ã yande Roma pegua reta co —jei reta mburuvicha reta pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Jayave yatɨ vae reta penti rami uepeña reta. Jare mburuvicha reta omondoro Pablo jare Silas jemimonde reta, jare uinupaca ɨvɨra pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Jare jeta ma uinupaca reta yave, umɨingueca reta peresorɨru pe. Jare oyocui reta peresorɨru iyandarecoa uãro cavi vaerã, agüɨye vaerã osi. ");
INSERT INTO gnwNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Cua uyandu yave, peresorɨru iyandarecoa umɨingue reta peresorɨru japɨpe cotɨ ete oĩ vae pe, jare oñono ipɨ ɨvɨracua pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Ẽrei pɨare mbɨte ma yave Pablo jare Silas uyerure Tumpa pe, jare ucanta ñugüɨnoi umbɨadora Tumpa. Jare ĩru pereso reta uyapɨsaca ñugüɨnoi jese reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Jare aramoiño tanta ucãta ɨvɨ, jare uñemɨcãta peresorɨru iguapɨca. Jare jupivoiño uyepea opaete onque reta, jare uyera opaete cadena pereso reta uñeapɨ̃ti pɨpe vae reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Jayave peresorɨru iyandarecoa usareco, jare uecha uyepea ñugüɨnoi peresorɨru jonque reta. Jayave uequi iquɨsepucu jɨru güi, uyeyuca vaerã. Echa'ã jae jei tẽi pereso reta opa ma co osi. ");
INSERT INTO gnwNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Ẽrei Pablo iñeeãta reve jei: —Agüɨye iyeyuca. Echa'ã opareveño noĩ cua pe —jei. ");
INSERT INTO gnwNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Jayave peresorɨru iyandarecoa ueni quía güeru vaerã chupe tembipe. Jayave osi peresorɨru japɨpe pe, jare uyeatɨca Pablo jare Silas jovai. Urɨrɨ oĩ uquɨye ramo. ");
INSERT INTO gnwNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Jayave güɨnoẽ reta oca pe jare jei chupe reta: —Carai reta, ¿mbae pa ayapota ayembɨasaca vaerã? ");
INSERT INTO gnwNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Jayave jae reta jei chupe: —Erovia yandeYa Jesucristo re, jare ndiyembɨasacata co, jare nerenta pegua reta vi. ");
INSERT INTO gnwNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Jayave jae reta umɨmbeu Tumpa iñee chupe jare opaete jenta pegua reta pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Jare jocua ora voi peresorɨru iyandarecoa güɨraa Pablo jare Silas oyoe ipere. Jayave jae jare opaete jenta pegua reta uyembɨbautizaca. ");
INSERT INTO gnwNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Jayave peresorɨru iyandarecoa güɨraa jenta pe umɨngaru Pablo jare Silas. Jare jae jare opaete jenta pegua reta uyerovia ete. Echa'ã güɨrovia reta ma Tumpa re. ");
INSERT INTO gnwNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Jare cõe ma yave, mburuvicha reta ombou amocue sundaro reta jei vaerã: —Iyora jocua cuimbae reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Jare peresorɨru iyandarecoa umɨmbeu cua ñee Pablo pe. Jei chupe: —Mburuvicha reta ombou cheocui poyora vaerã. Jáeramo añave pepuere peẽ jare peo cavi. ");
INSERT INTO gnwNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Ẽrei Pablo jei sundaro reta pe: —Mburuvicha reta orenupaca opaete vae jovaque orereco mbae reve, jare oremɨingueca peresorɨru pe, yepe tẽi ore co jae romano reta. Jare añave uipota oreyoraca vɨari. Ndarau uyapo jucuarãi. Tuyugüeru jae reta etei oreyora vaerã —jei. ");
INSERT INTO gnwNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Jayave sundaro reta yugüɨraa umɨmbeu cua ñee mburuvicha reta pe. Jayave mburuvicha reta uquɨye, uicuaa yave jae reta romano reta co. ");
INSERT INTO gnwNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Jayave yugüeru peresorɨru pe ueca vaerã ñee cavi Pablo jare Silas pe. Jayave güɨnoẽ oca pe, jare umɨñera yugüɨraa vaerã tenta guasu güi. ");
INSERT INTO gnwNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Jayave Pablo jare Silas yugüɨraa peresorɨru güi Lidia jenta pe. Jare uecha upurugüɨrovia vae reta, jare umbɨaracuaa. Jayave yugüɨraa joco güi. ");
INSERT INTO gnwNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pablo jare Silas uasa yave tenta guasu Anfípolis jare Apolonia rupi, yugüɨraa uvãe tenta guasu Tesalónica pe. Joco pe oĩ penti judío reta itupao. ");
INSERT INTO gnwNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Jare Pablo oo tupao pe. Echa'ã jucuarãi uyapo opaete tenta guasu reta rupi. Jare mbapɨ mbutuu ara uyeaca judío reta ndive. ");
INSERT INTO gnwNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Uechaca chupe reta Tumpa iñee uyecuatía oĩ vae, jare uicuaaca quirãi Cristo uiporarañotai co jare icove yeñotai co ou umanocue vae reta ipɨte güi. Jare jei chupe reta: —Cua Jesús che amɨmbeu peve vae co jae Cristo. ");
INSERT INTO gnwNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Jayave amocue güɨrovia Pablo jei vae, jare jae reta, jare jeta griego umbɨadora Tumpa vae reta, jare jeta cuña tenta guasu pegua reta itenondegua reta uñemɨĩru Pablo jare Silas ndive. ");
INSERT INTO gnwNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ẽrei judío güɨrovia mbae vae reta ñacatãa Pablo jare Silas re, jare güeru amocue cuimbae iyaquɨ vae reta. Jeco pochɨ co cua cuimbae reta. Jayave umbatɨ jeta ĩru vae reta, jare uyapo tecorai. Jayave upurupeña reta Jasón jenta re ueca tẽi Pablo jare Silas. Uipota tẽi güɨraa tenta guasu pegua reta jovai. ");
INSERT INTO gnwNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ẽrei uvãe'ã chupe reta. Jayave uipɨsɨ güɨraa Jasón jare amocue upurugüɨrovia vae reta mburuvicha tenta guasu pegua reta pe, jare iñeeãta reve jei reta: —Jocua cuimbae umambeco opaete ɨvɨ pegua reta vae reta yugüeru vi cua pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Jare Jasón güɨnoi jenta pe. Jare opaete jae reta oyovaicho César iporoyocui ndive. Echa'ã jei reta ime ĩru mburuvicha guasu Jesús jee vae —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Jayave tenta guasu pegua reta jare juvicha reta cua uyandu yave, uyemɨpɨa'ã. ");
INSERT INTO gnwNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Jare Jasón jare ĩru vae reta umbɨepɨ chupe reta yave, jae reta umaeño yugüɨraa ye vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Jare jupivoiño upurugüɨrovia vae reta omondo Pablo jare Silas pɨ̃tu yave tenta guasu Berea jee vae cotɨ. Jare jae reta yugüɨraa uvãe yave joco pe, yugüɨraa judío reta itupao pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Jare joco pegua judío reta iyaracuaa catu Tesalónica pegua reta güi. Iquɨrẽɨ uyapɨsaca Tumpa iñee re, jare opa ara umɨngueta cavi Tumpa iñee uyecuatía oĩ vae, uicuaa vaerã añete ra Pablo jei vae. ");
INSERT INTO gnwNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Jare jeta joco pegua reta güɨrovia. Jare güɨrovia vi jeta griega reta itenondegua reta, jare jeta griego reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Ẽrei judío Tesalónica pegua reta uicuaa yave Pablo umɨmbeu Berea pegua reta pe vi Tumpa iñee, yugüɨraa joco pe omboemboe umambeco vaerã joco pegua reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Jayave upurugüɨrovia vae reta omondo Pablo ɨ guasu cotɨ. Ẽrei Silas jare Timoteo upɨta Berea pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Jare Pablo jupíe yugüɨraa vae reta güɨraa tenta guasu Atenas pe. Jayave Pablo oyocui jae reta umɨmbeu vaerã Silas jare Timoteo pe yugüeru vaerã icotɨ ɨmambae, ipuere yave. Jayave jae reta yugüeru ye Berea cotɨ. ");
INSERT INTO gnwNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Jare Pablo uãro oĩ rambueve Atenas pe, uecha yave jeta tumpa-raanga reta ñugüɨnoi tenta guasu rupi, uyemɨpɨa'ã. ");
INSERT INTO gnwNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Jayave uyeaca judío reta itupao pe judío reta jare ĩru umbɨadora Tumpa vae reta ndive. Jare uyeaca vi opa ara plaza pe joco pe ñugüɨnoi vae reta ndive. ");
INSERT INTO gnwNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Jare amocue iyaracuaa vae reta uyeaca Pablo ndive. Jae reta co Epicúreo jare Estoico jee vae reta. Amocue jei: —¿Mbae ra uipota jei cua iyemɨnguetase vae? Jare ĩru vae reta jei: —Aramoi jae umɨmbeu ĩru tumpa yaicuaa mbae vae reta regua. Echa'ã Pablo umɨmbeu chupe reta ñee icavi vae Jesús regua, jare quirãi jae icove ye ou umanocue vae reta ipɨte güi. ");
INSERT INTO gnwNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Jare jae reta güɨraa Pablo ɨvɨtu Areópago jee vae pe. Jare jei reta chupe: —Emɨmbeu oreve mbae nunga moromboe ipɨau vae ra cua nemiari jese vae. ");
INSERT INTO gnwNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Echa'ã cua nemɨmbeu ma oreve vae jaeramo nduyandu. Jáeramo nduipota nduicuaa mbae ra uipota jei cua —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Echa'ã opaete Atenas pegua reta jare quetɨ güi yugüeru yugüɨreco joco pe vae reta jaeño ma yugüɨreco imiari vaerã jare uyapɨsaca mbae ipɨau vae re. ");
INSERT INTO gnwNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Jayave Pablo uyemboɨ Areópago pe jeta vae reta ipɨte pe, jare jei chupe reta: —Cuimbae Atenas pegua reta, aecha ma pe reta pembɨadora co tumpa reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Echa'ã aguata rambueve tenta guasu rupi, amae jocua pembɨadora vae reta re, jare aecha penti yembɨadorarenda, jare jese uyecuatía oĩ cuarãi: ‘Tumpa yaicuaa mbae vae’. Jucuarãi uyecuatía oĩ. Jáeramo tamɨmbeu peve pe reta picuaa'ã reve pembɨadora vae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Tumpa uyapo ɨvɨ jare opaete oĩ pɨpe vae. Jae co ara jare ɨvɨ iYa. Jae ico'ã yembɨadorarenda vae rupi yande yayapo vae reta pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Tumpa ueca'ã etei ɨvɨ pegua reta umee vaerã mbae chupe. Echa'ã jae etei co umee yandeve tecove, jare ñaneputũé, jare opaete mbaembae —jei chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Jare Tumpa uyapo penti cuimbae, jare opaete ɨvɨ pegua reta iñemoñaa reta co. Jucuarãi Tumpa uyapo, jae reta yugüɨreco vaerã opaete ɨvɨ iárambo. Tumpa etei co umee quirãi yave ɨvɨ pegua reta yugüɨreco vaerã, jare umbɨyaoyao ɨvɨ chupe reta yugüɨreco tee tee vaerã —jei Pablo—. ");
INSERT INTO gnwNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Opaete cua Tumpa uyapo, ɨvɨ pegua reta ueca vaerã Tumpa, jare aramoi uvãe vaerã iyupe. Echa'ã añetete jae mbɨrɨ'ã oĩ penti penti güi. ");
INSERT INTO gnwNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Jese yaicove jare ñamɨ, yaico vaerã. Jare jucuarãi vi amocue pepɨte pe oĩ vae jei uicuatía vae pe: ‘Echa'ã jese yaico’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Jare Tumpa umee yandeve tecove ramo, icavi'ã yae vaerã Tumpa co jae oro pegua, ani corepoti pegua, ani ita pegua. Echa'ã cuimbae reta uyapo cua nunga iyaracuaa rupiño. ");
INSERT INTO gnwNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Aracae ɨvɨ pegua reta uicuaa'ã ramo, Tumpa umaeño jese reta. Ẽrei añave jae oyocui opaete ɨvɨ pegua reta ueya vaerã iyemɨngueta icavi mbae vae ipɨa pe oĩ vae —jei chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Echa'ã Tumpa uiparavo ma penti ara uãaca vaerã jupi rupi ɨvɨ pegua reta jocua cuimbae jae uiparavo vae pe. Jare cua uicuaaca opaete ɨvɨ pegua reta pe. Echa'ã Tumpa umbɨjecove ye jocua uiparavo vae güeru umanocue vae reta ipɨte güi —jei. ");
INSERT INTO gnwNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Jare uyandu reta yave icove ye ou umanocue vae reta ipɨte güi vae regua, amocue vae oyoyai. Ẽrei ĩru vae reta jei Pablo pe: —Nduyapɨsaca yeta nderé ĩru ara pe cua re. ");
INSERT INTO gnwNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Jayave Pablo oo chugüi reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Ẽrei amocue vae güɨrovia Tumpa iñee, jare uñemɨĩru Pablo ndive. Cua reta ipɨte pe ñugüɨnoi penti Areópago pegua Dionisio jee vae, penti cuña Dámaris jee vae, jare ĩru vae reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Cua jaɨcue rupi Pablo oo Atenas güi tenta guasu Corinto pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Jare uñevãe joco pe penti judío Aquila jee vae ndive. Jae co Ponto pegua. Cua judío ou ramo uvãe Italia güi jembireco Priscila jee vae ndive. Echa'ã mburuvicha guasu Claudio jee vae oyocui opaete judío reta yugüɨraa vaerã Roma güi. Jayave Pablo opou ipɨ. ");
INSERT INTO gnwNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Jare Pablo icatu uyapo Aquila iparavɨquɨ. Jáeramo Pablo upɨta jae reta ndive, jare uparavɨquɨ pãve reta. Jae reta co o reta guacapi pegua iyapoa. ");
INSERT INTO gnwNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Jare opa mbutuu ara Pablo uyeaca judío reta itupao pe. Cua uyapo, judío reta jare judío mbae vae reta güɨrovia vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Jare Silas jare Timoteo yugüeru uvãe yave Macedonia güi, Pablo uñemɨatangãtu umɨmbeu vaerã Tumpa iñee. Umɨmbeu judío reta pe Jesús co jae Cristo, Tumpa ombou vae. ");
INSERT INTO gnwNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Ẽrei judío reta oyovaicho jae ndive, jare jei reta icavi mbae vae icotɨ. Jáeramo Pablo umɨtɨmo jemimonde, jare jei chupe reta: —Pecañɨteita co, jare pe retaño penoita teco. Che anoi'ã ma teco. Añave güive aata amɨmbeu judío mbae vae reta pe —jei. ");
INSERT INTO gnwNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Jayave oo joco güi cuimbae Justo jee vae jenta pe. Cua cuimbae umbɨadora Tumpa, jare jae jenta oĩ judío reta itupao iyɨpɨ pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Jare judío reta itupao pegua reta itenondegua Crispo jee vae jare opaete jenta pegua reta güɨrovia yandeYa re. Jare jeta Corinto pegua reta uyandu Pablo umɨmbeu vae yave, güɨrovia jare uyembɨbautizaca. ");
INSERT INTO gnwNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Jare yandeYa jei Pablo pe pɨ̃tu yave ique pe: —Agüɨye equɨye. Nemiari jare agüɨye nequĩi. ");
INSERT INTO gnwNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Echa'ã che aĩ nde ndive, jare ndarau quía ipuere nderé, uyapo vaerã icavi mbae vae ndeve. Echa'ã ime jeta cheré güɨrovia vae reta cua tenta guasu pe —jei. ");
INSERT INTO gnwNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Jare Pablo upɨta joco pe penti año jare seis yasɨ, jare umɨmbeu Tumpa iñee tenta guasu pegua reta pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Ẽrei Galión jee vae ico mburuvicha ɨvɨ Acaya pe yave, judío reta oyovaicho penti rami Pablo ndive, jare güɨraa mburuvicha upuruãa vae pe ");
INSERT INTO gnwNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","jare jei reta: —Cua cuimbae omboe yave tenta guasu pegua reta umbɨadora vaerã Tumpa, omboe'ã mboroyocui pe uyecuatía oĩ vae rupi. ");
INSERT INTO gnwNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Jare Pablo omoẽta ma yave iñee, Galión jei judío reta pe: —Judío reta, cua cuimbae uyapo yave icavi mbae vae pecotɨ, ani jeco pochɨ yave, icavita tẽi ayapɨsaca vaerã peré. ");
INSERT INTO gnwNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Ẽrei pipota yave aãa vaerã ñee reta re, tee reta re jare peporoyocui re, ndarau ayapɨsaca peré. Pe reta etei pepuere peãa. Echa'ã che aipota'ã aãa cua nunga re —jei chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Jayave Galión omondo reta upuruãa vae güi. ");
INSERT INTO gnwNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Jayave griego reta uipɨsɨ judío reta itupao pegua itenondegua Sóstenes jee vae, jare ocua jese mburuvicha upuruãa vae jovai. Ẽrei Galión uyemambeco'ã etei jese. ");
INSERT INTO gnwNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Jare cua rendave pe Pablo upɨta ye jeta ara joco pe. Jayave oo upurugüɨrovia vae reta güi, jare uasa ɨ guasu rupi Siria cotɨ Priscila jare Aquila jupíe. Jare tenta guasu Cencrea pe Pablo uipẽpica iñãca. Echa'ã tenonde yave jei Tumpa pe uyapota mbae chupe ndei uipẽpica iñãca mbove. ");
INSERT INTO gnwNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Jare yugüɨraa uvãe yave tenta guasu Efeso pe, Pablo ueya Priscila jare Aquila. Jayave uique judío reta itupao pe, jare uyeaca judío reta ndive. ");
INSERT INTO gnwNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Jare judío reta umɨñera yave upɨta vaerã joco pe, uipota'ã. ");
INSERT INTO gnwNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Jare oota ma yave chugüi reta, jei: —Aata co Jerusalén pe, ayapo vaerã pascua uyaro ma oĩ vae. Ẽrei Tumpa uipota yave, tayu ye pepɨ curi —jei. Jayave oo ɨ guasu rupi Efeso güi. ");
INSERT INTO gnwNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Jare oo uvãe yave Cesarea pe, oo umbɨsaluda vaerã upurugüɨrovia vae reta Jerusalén pe. Jayave oo joco güi Antioquía pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Jare mbovɨ ara joco pe oĩ yave, oo umbapɨ opaete tenta tenta Galacia jare Frigia rupi umɨatangãtu vaerã opaete upurugüɨrovia vae reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Jare ou Efeso pe penti judío Alejandría pegua Apolos jee vae. Cua cuimbae ipuere imiari cavi, jare uicuaa cavi Tumpa iñee uyecuatía oĩ vae. ");
INSERT INTO gnwNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Cua cuimbae uyemboe ma yandeYa iporomboe re. Jatangãtu, jare imiari jare oporomboe jaecavi yandeYa re. Ẽrei uicuaa moromboe Juan upurumbɨbautizase jese vaeño. ");
INSERT INTO gnwNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Jae umbɨpɨ imiari uquɨye mbae reve judío reta itupao pe. Ẽrei Priscila jare Aquila uyandu yave jei vae, güɨraa jenta pe, jare omboe cavi quirãi yaico vaerã Tumpa cotɨ vae re. ");
INSERT INTO gnwNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Jare Apolos uipota oo yave Acaya pe, upurugüɨrovia vae reta umɨatangãtu jese, jare uicuatía reta penti tupapire upurugüɨrovia vae reta pe, umbɨresive cavi reta vaerã Apolos. Jare jae oo uvãe yave joco pe, omborɨ jocua Tumpa ipɨacavi jeco pegua upurugüɨrovia vae reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Jae imiari mbaepuere reve, jare umɨamɨri judío reta tenta guasu pegua reta jovaque. Echa'ã uechaca chupe reta Tumpa iñee uyecuatía oĩ vae pe Jesús co jae Cristo. ");
INSERT INTO gnwNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apolos Corinto pe oĩ rambueve, Pablo ou uvãe Efeso pe, opa yave umbapɨ opaete tenta guasu-raɨ-raɨ guarasɨ oẽ vae cotɨ ñugüɨnoi vae reta rupi. Jare Efeso pe uñevãe amocue upurugüɨrovia vae reta ndive. ");
INSERT INTO gnwNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Jare Pablo upɨrandu chupe reta: —¿Ou pa Espíritu Santo peve pepurugüɨrovia yave? Jae reta jei chupe: —Nduicuaa'ã etei Espíritu Santo ou vae regua. ");
INSERT INTO gnwNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Jayave Pablo upɨrandu chupe reta: —¿Mbae nunga moromboe re pa piyembɨbautizaca? Jare jae reta jei chupe: —Juan iporomboe re nduyembɨbautizaca. ");
INSERT INTO gnwNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Jayave Pablo jei chupe reta: —Juan umbɨbautiza jocua reta ueya iyemɨngueta icavi mbae vae ipɨa pe oĩ vae. Jare jei chupe reta güɨrovia vaerã outa jaɨcue rupi vae re. Cua uipota jei Jesús re. Jesús co jae Cristo —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Jare cua uyandu yave, uyembɨbautizaca yandeYa Jesús jee re —jei chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Jayave Pablo oñono ipo jese reta, jare ou chupe reta Espíritu Santo, jare jae reta uyemɨngueta ambɨe vae iñee pe, jare umɨmbeu reta Tumpa iñee. ");
INSERT INTO gnwNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Jare cua cuimbae reta uepitɨ doce rupi. ");
INSERT INTO gnwNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Jayave Pablo oo judío reta itupao pe, jare imiari uquɨye mbae reve. Jare mbapɨ yasɨ uyeaca judío reta ndive Tumpa iporoyocuia re. ");
INSERT INTO gnwNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Ẽrei amocue ipɨatanta jare uipota'ã güɨrovia, jare jei reta ñee icavi mbae vae tenta guasu pegua reta jovaque upurugüɨrovia vae reta ipurugüɨrovia cotɨ. Jayave Pablo oo chugüi reta, jare güɨraa jae ndive upurugüɨrovia vae reta, jare uyeaca opa ara rupi Tiranno jo tuicha vae pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Jare jucuarãi uyapo mocui año. Jáeramo opaete judío jare judío mbae vae Asia pegua reta uyandu ñee yandeYa Jesús regua. ");
INSERT INTO gnwNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Jare Tumpa uyapo mɨacañɨ tuicha vae reta Pablo rupi. ");
INSERT INTO gnwNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Echa'ã ĩru vae reta güɨraa yave mbaembae Pablo omonde vae imbaerasɨ vae reta pe, imbaerasɨ vae reta ucuera, jare aña reta usɨrɨ oya jese vae reta güi. ");
INSERT INTO gnwNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Jayave amocue judío reta umbɨpɨ tẽi ueni yandeYa Jesús jee aña reta oya jese vae reta re. Cua nunga judío reta uguata opaete que rupi umbɨsɨrɨ aña reta oya jese vae reta güi. Jae reta jei: —Poyocui Jesús Pablo umɨmbeu vae jee re. ");
INSERT INTO gnwNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Jare penti judío Esceva jee vae güɨnoi siete taɨ reta. Esceva co jae penti sacerdote reta itenondegua. Jare cua cuimbae taɨ reta vi jucuarãi jei aña pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Ẽrei aña jei chupe reta: —Che aicuaa co Jesús, jare aicuaa catu quía co jae Pablo. Ẽrei ¿quía pa co pe reta? ");
INSERT INTO gnwNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Jare jocua cuimbae aña oya jese vae upurupeña jese reta, jare umɨamɨri. Jare jae reta opa osi jocua tenta güi nani jare ipere reve. ");
INSERT INTO gnwNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Jare cua jerãcua opaete judío jare judío mbae vae Efeso pegua reta pe. Jáeramo opareve uquɨye, jare umbɨadora yandeYa Jesús jee. ");
INSERT INTO gnwNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Jare jeta upurugüɨrovia vae reta yugüeru umɨmbeu jeco icavi mbae vae ueya ma vae regua. ");
INSERT INTO gnwNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Jare jeta ipaye vae reta güeru itupapire reta, jare uapɨ opaete vae jovaque. Jare cua tupapire reta jepɨ uyepapa yave, uepitɨ cincuenta mil corepoti tĩ vae. ");
INSERT INTO gnwNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Echa'ã Tumpa iñee mbɨrɨ rupi ma uñemɨai, jare mbaepuere tuicha vae güɨnoi. ");
INSERT INTO gnwNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Cua jaɨcue rupi Pablo jei oo vaerã Macedonia jare Acaya rupi Jerusalén pe. Jare jae jei: —Joco güi aata vi co Roma pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Jayave omondo Macedonia cotɨ mocui imborɨa reta Timoteo jare Erasto jee vae. Ẽrei jae upɨta ye mbovɨ ara Asia pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Jare jocua ara reta pe oĩ tecorai upurugüɨrovia vae reta ipurugüɨrovia re. ");
INSERT INTO gnwNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Echa'ã penti cuimbae Demetrio jee vae umɨndɨcui corepoti, jare uyapo tupao-raanga michi vae corepoti pegua reta. Efeso pegua reta umbɨadora itumpa-raanga Diana jee vae cua nunga tupao-raanga michi vae pe. Jare Demetrio umbɨepɨ cavi omborɨ uyapo vae reta pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Cua cuimbae umbatɨ omborɨ uyapo vae reta jare ĩru cua nunga mbaravɨquɨ uyapo vae reta, jare jei chupe reta: —Cuimbae reta, picuaa catu co cua mbaravɨquɨ güi ñamɨngana yaicocatu vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Jare peecha jare piyandu ma quirãi cua Pablo umbɨyerova jeta vae Efeso pe jare opaete seri Asia rupi jae iporomboe pe. Echa'ã jae jei tumpa-raanga cuimbae reta uyapo vae tumpa'ã co reta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Jare aramoi tenta guasu pegua reta güɨrɨ̃rota cua yandeparavɨquɨ. Jare aramoi güɨrɨ̃rota vi tumpa cuña uyembɨadora vae Diana itupao, jare ndarau ma quía umbɨadora. Echa'ã añave opaete Asia pegua reta jare opaete ɨvɨ pegua reta umbɨadora —jei chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Cua uyandu reta yave, pochɨ ete, jare iñeeãta reve jei: —Uyembɨadora co Diana Efeso pegua. ");
INSERT INTO gnwNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Jare tecorai uñemɨai opaete tenta guasu rupi. Jare jeta vae penti rami osi tenta guasu pegua reta uyuvanga vae pe. Jare uipɨsɨ güɨraa joco pe Pablo iguataĩru reta Gayo jare Aristarco. Cua reta co Macedonia pegua. ");
INSERT INTO gnwNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Jayave Pablo uipota tẽi uique tenta guasu pegua reta yatɨ ñugüɨnoi vae pe. Ẽrei upurugüɨrovia vae reta umaeño'ã jese. ");
INSERT INTO gnwNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Jare amocue Asia pegua mburuvicha Pablo ndive uyepocuaa vae reta omondo umɨmbeu Pablo pe agüɨye vaerã oo tenta guasu pegua reta uyuvanga vae pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Jare opaete yatɨ vae reta iñeeãta, ẽrei oyovaque'ã iñee reta. Tecorai tuicha vaeño uyapo reta. Echa'ã jeta joco pe ñugüɨnoi vae reta uicuaa'ã maera ra uyembatɨ joco pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Jayave judío reta umɨaña jenonde Alejandro jee vae yatɨ vae reta ipɨte güi, iñee omoẽ vaerã. Jayave Alejandro umupũa ipo umɨquĩi vaerã tẽi. Echa'ã uipota tẽi imiari tenta guasu pegua reta pe, agüɨye vaerã jae reta umbɨjeco judío reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Ẽrei yatɨ vae reta uicuaa yave jae co judío, opaete penti rami mocui ora seri iñeeãta reve jei: —Uyembɨadora co Diana Efeso pegua. ");
INSERT INTO gnwNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Jayave tenta guasu pegua reta juvicha umɨquĩi yatɨ vae reta, jare jei chupe reta: —Cuimbae Efeso pegua reta. Diana co jae tumpa cuña uyembɨadora vae. Cua tenta guasu pegua reta uyandareco Diana itupao re. Jare uyandareco vi ita Diana echa vae Júpiter güi ou vae re. Opaete vae uicuaa cua —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Jayave ipuere'ã quía cua uicuacu ramo, icavi co pequĩi vaerã, agüɨye vaerã mbae piyapo güɨrave ndei pepɨa pe piyemɨngueta mbove. ");
INSERT INTO gnwNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Echa'ã peru cua cuimbae reta cua pe, yepe tẽi oñomi'ã mbae yandetupao güi, jare jei'ã vi mbae icavi mbae vae ñanetumpa cuña cotɨ —jei chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Demetrio jare imborɨa reta uipota yave uñeapo quía re, ime mburuvicha reta ñugüɨnoi uyapɨsaca vaerã jese reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ẽrei pipota yave piñeapo ĩru mbae re, mburuvicha reta uyapɨcatuta, uyembatɨ yave —jei chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Echa'ã aramoi mburuvicha reta yanembɨjecota yayapo vae re. Jei tẽita yaipota ñañerãro jae reta ndive. Echa'ã yaicuaata'ã mbae ra yaeta chupe reta, jae reta upɨrandu yandeve yave maera ra yayapo cua tecorai —jei. ");
INSERT INTO gnwNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Jare tenta guasu pegua reta juvicha cua jei yave, opa omondo yatɨ vae reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Opa ma tecorai yave, Pablo ueni upurugüɨrovia vae reta. Jayave opa umbɨaracuaa reta yave, uicuãva jare oo chugüi reta Macedonia cotɨ. ");
INSERT INTO gnwNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Jare umbapɨ opaete jocua tenta guasu reta rupi umbɨaracuaa cavi reve upurugüɨrovia vae reta. Jayave oo uvãe ɨvɨ Grecia pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Jare upɨta joco pe mbapɨ yasɨ. Jare ɨ guasu rupi oota yave joco güi Siria cotɨ, judío reta uyemboemboe uyapo vaerã icavi mbae vae chupe. Jáeramo Pablo jei oota Macedonia rupi. ");
INSERT INTO gnwNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Jare yugüɨraa jae jupíe Sópater Berea pegua, Aristarco jare Segundo Tesalónica pegua reta, Gayo Derbe pegua, Timoteo, jare Tíquico jare Trófimo Asia pegua reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Cua reta yugüɨraa orerenonde, jare oreraãro Troas pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Ẽrei ara reta mbɨyape ovu mbae vae pegua uasa yave, ore ndoo ɨ guasu rupi Filipos güi, jare pandepo ara pe ndoo nuvãe Troas pe. Joco pe nuñevãe ĩru reta ndive, jare ndupɨta joco pe siete ara. ");
INSERT INTO gnwNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Jare domingo ara pe upurugüɨrovia vae reta uyembatɨ tembíu umbɨyao vaerã uyupe. Jayave Pablo pɨareve pe oota ramo, ipɨare mbɨte rupi omboe reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Jare jeta tembipe ñugüɨnoi jocua o ɨvate vae pe yatɨ ñugüɨnoi vae pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Jare jocua tenta co mbapɨ o ɨvate vae. Jare penti cunumi Eutico jee vae uguapɨ oĩ ventana pe, jare tanta oque oĩ. Jare Pablo jecuae omboe oĩ rambueve, cunumi oque oĩ ramo, oa joco güi oca cotɨ ɨvɨ pe. Jare ĩru vae reta yugüɨraa uupi yave, uecha umano ma. ");
INSERT INTO gnwNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Jayave Pablo ugüeyɨ jare ipe cunumi iárambo. Jayave uicuãva jare jei: —Agüɨye pepɨatɨtɨ. Jecoveño oĩ. ");
INSERT INTO gnwNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Jayave Pablo uyupi ye, jare joco pe ñugüɨnoi vae reta umbɨyao uyupe tembíu, jare ucaru reta. Jayave Pablo icõe omboe. Jayave oo chugüi reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Jare joco pe yatɨ vae reta güɨraa cunumi icove ye vae, jare ipɨacatu reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Jare ore rani ndoo nduasa ɨ guasu rupi tenta guasu Asón pe. Nduipota nuñevãe Pablo ndive joco pe, jae jei rami. Echa'ã jae uipota oo ɨvɨ rupi. ");
INSERT INTO gnwNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Jare nuñevãe yave jae ndive Asón pe, Pablo uyupi chalana guasu pe, jare ndoo pãve ɨvɨ Mitilene pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Jare joco güi ndoo ye ɨ guasu rupi, jare pɨareve pe ndoo nuvãe ɨvɨ Quío jovai. Pɨareve pe ndoo nuvãe ɨvɨ Samos pe. Jayave ndupɨta ɨvɨ Trogilio pe, jare pɨareve pe ndoo nuvãe tenta guasu Mileto pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pablo iquɨrẽɨ uasa güɨrave Efeso güi, agüɨye vaerã uyembɨavai Asia pe. Echa'ã jae uipota uvãe vaerã Jerusalén pe Pentecostés ara pe, ipuere yave. ");
INSERT INTO gnwNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Jayave Mileto güi Pablo omondo Efeso pe uenica upurugüɨrovia vae reta itenondegua reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Jare jae reta yugüeru uvãe yave Pablo oĩ vae pe, jae jei chupe reta: —Pe reta picuaa catu co quirãi aico pe reta ndive tenonde ete Asia pe ayu güive. ");
INSERT INTO gnwNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Ayeyocui yandeYa pe añemɨmichi reve jare ayao reve. Judío reta chembɨavai ete. Echa'ã jecuaeño iquɨrẽɨ reta uyapo icavi mbae vae cheve —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Aipɨu'ã amɨmbeu vaerã peve opaete icavi peve peguarã vae. Jare pomboe jeta vae ipɨte pe jare perenta rupi vi. ");
INSERT INTO gnwNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Jare amɨmbeu judío reta jare judío mbae vae reta pe ueya vaerã iyemɨngueta icavi mbae vae ipɨa pe oĩ vae jare uyerova vaerã Tumpa cotɨ, jare güɨrovia vaerã yandeYa Jesucristo re —jei chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Jare añave aa Jerusalén cotɨ, Espíritu Santo chemondo ramo. Jare aicuaa'ã mbae ra uyeyapota cheve joco pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Ẽrei opaete tenta guasu reta rupi Espíritu Santo umɨmbeu cheve ĩru vae reta cheñonota co peresorɨru pe jare aiporarata. ");
INSERT INTO gnwNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Ẽrei aquɨye'ã. Chepɨa pe ayemɨngueta'ã etei ayerepɨ vaerã. Jaeño aipota ambapɨ cheguata Tumpa cotɨ vae ayerovia reve. Aipota ayapo mbaravɨquɨ yandeYa Jesús umee cheve vae. Echa'ã jecuaeño aipota amɨmbeu ĩru vae reta pe ñee icavi vae Tumpa ipɨacavi regua —jei Pablo chupe reta—. ");
INSERT INTO gnwNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Amɨmbeu ma pepɨte rupi Tumpa iporoyocuia regua, jare añave aicuaa catu co pe reta ndarau ma cherecha ye. ");
INSERT INTO gnwNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Jáeramo añave amɨmbeu peve che anoi'ã etei co teco pecotɨ —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Echa'ã aipɨu'ã etei amɨmbeu vaerã peve opaete Tumpa jei vae. ");
INSERT INTO gnwNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Jáeramo piñemoa ngatu, jare piyandareco opaete upurugüɨrovia vae reta re, penti ovecha iyandarecoa ovecha reta re uyandareco rami. Echa'ã Espíritu Santo co peparavo piyandareco vaerã jese reta. Jare pemɨmbeu Tumpa iñee yandeYa re güɨrovia vae reta pe, penti ovecha reta iyandarecoa ovecha reta umɨngaru rami. Echa'ã yandeYa uepɨ reta jae jugüɨ pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Che aicuaa catu co che aa ma yave, yugüeruta pepɨte pe ĩru vae reta. Cua reta uyapota icavi mbae vae upurugüɨrovia vae reta pe, yaguapɨ̃ta ou jou ovecha reta rami —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Jare pepɨte güi etei imeta cuimbae moromboe pɨchɨ̃i vae re oporomboeta vae reta. Cua reta ombopata upurugüɨrovia vae reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Jáeramo piñemoa ngatu, jare pemandúa quirãi chiyao reve pumbɨaracuaa vae re. Mbapɨ año ma jucuarãi ayapo, ara rupi jare pɨ̃tu rupi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Añave ayerure Tumpa pe uyandareco vaerã peré, jare aeya pe reta ndive iñee ipɨacavi regua. Echa'ã cua ñee ipuere pemɨmɨrãta jare umee peve pembaerã opaete jocua ĩru uñeñono tee Tumpa peguarã vae reta ndive —jei Pablo—. ");
INSERT INTO gnwNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Aipota'ã anoi ĩru vae icorepoti, ioro jare jemimonde. ");
INSERT INTO gnwNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Pe reta picuaa catu co quirãi chepo pe etei aparavɨquɨ, mbaembae uata cheve vae anoi vaerã, jare amee vaerã cheĩru reta pe —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Opaete rupi aicuaaca ma peve quirãi icavi co yaparavɨquɨ vaerã, yamborɨ vaerã mbae uata chupe vae reta. Yanemandúa yandeYa Jesús etei jei vae re. Echa'ã jae jei: ‘Tumpa umbɨyerovia eteta mbae umeeiño vae mbae umbɨresive vae güi’ —jei, jei Pablo. ");
INSERT INTO gnwNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Jare cua opa ma jei yave, Pablo uyeatɨca jare uyerure Tumpa pe opaete jae reta ndive. ");
INSERT INTO gnwNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Jayave opaete joco pe ñugüɨnoi vae reta uyao, jare uicuãva reta Pablo jare uyurupɨte reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Jare jae reta tuicha ipɨatɨtɨ, Pablo jei chupe reta ndarau ma uecha ye ramo. Jayave jae reta yugüɨraa jae jupíe chalana guasu oĩ vae pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Jare ndoo ma yave chugüi reta, nduasa sɨmi ɨ guasu rupi tenta guasu Cos pe. Jare pɨareve pe nduasa tenta guasu Rodas pe. Jayave joco güi nduasa tenta guasu Pátara pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Jare nuvãe joco pe chalana guasu oota Fenicia pe vae. Jayave nduyupi pɨpe, jare ndoo. ");
INSERT INTO gnwNT_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Jare Chipre nduecha oreaso cotɨ, jare nduasa. Jare jecuae ndoo Siria cotɨ, jare ndoo nuvãe tenta guasu Tiro pe. Echa'ã joco pe chalana guasu ueyata jɨvɨta. ");
INSERT INTO gnwNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Jare nuñevãe upurugüɨrovia vae joco pegua reta ndive, jare ndupɨta joco pe siete ara. Jare jae reta Espíritu Santo rupi jei Pablo pe agüɨye vaerã oo Jerusalén pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Jocua ara reta uasa yave, ndoo tenta guasu güi, jare opaete upurugüɨrovia vae reta jembireco reta jare isambiaɨ reta ndive oremɨĩru. Jayave nduyeatɨca ɨ guasu jembeɨ pe nduyerure Tumpa pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Jayave nuñecuãva yave jae reta ndive, nduyupi chalana guasu pe, jare jae reta yugüɨraa ye jenta pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Jayave Tiro güi ndoo nuvãe tenta guasu Tolemaida pe. Jare joco pe numbɨsaluda upurugüɨrovia vae reta, jare ndupɨta jae reta ipɨ penti ara. ");
INSERT INTO gnwNT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Pɨareve pe ndoo chugüi reta Pablo jupíe Cesarea pe, jare joco pe nduique ndupɨta Felipe ñee icavi vae umɨmbeu vae jenta pe. Jae co jocua siete vae güi penti. ");
INSERT INTO gnwNT_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Cua cuimbae güɨnoi irundɨ tayɨ Tumpa iñee umɨmbeu vae. Cua irundɨ reve ndei umenda. ");
INSERT INTO gnwNT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Jare ndupɨta joco pe mbovɨ ara. Jare Tumpa iñee umɨmbeu vae Agabo jee vae ou Judea güi. ");
INSERT INTO gnwNT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Jare jae ou ore noĩ vae pe, jare uequi Pablo jumbɨcuaa. Jayave uñeapɨ̃ti ipɨ rupi jare ipo rupi jare jei: —Cua jei Espíritu Santo: ‘Cuarãi Jerusalén pe judío reta uñapɨ̃tita cua tumbɨcuaa iya, jare umeeta reta judío mbae vae reta pe’ —jei, jei Agabo. ");
INSERT INTO gnwNT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Cua nduyandu yave, ore jare joco pegua reta numɨñera tẽi Pablo agüɨye vaerã oo Jerusalén pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Ẽrei Pablo jei: —¿Maera pa piyao jare chembɨpɨatɨtɨ? Echa'ã aipɨu'ã añeapɨ̃ti vaerã Jerusalén pe. Aipɨu'ã vi amano vaerã joco pe yandeYa Jesús jeco pegua —jei. ");
INSERT INTO gnwNT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Jayave ndoe'ã ye ma mbae chupe cua re, orepuere'ã jese ramo. Jayave ndoe: —Tuyeyapo yandeYa jei vae. ");
INSERT INTO gnwNT_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Jare jocua ara reta uasa yave, nduyeyapɨcatu ndoo Jerusalén cotɨ. ");
INSERT INTO gnwNT_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Jare yugüɨraa vi orerupíe Cesarea güi amocue upurugüɨrovia vae joco pegua reta. Oo vi jae reta jupíe Chipre pegua Mnasón jee vae. Echa'ã ndupɨtata Mnasón jenta pe. Cua Mnasón tenonde voi güɨrovia Jesús re. ");
INSERT INTO gnwNT_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Jare ndoo nuvãe yave Jerusalén pe, upurugüɨrovia vae reta orembɨresive uyerovia reve. ");
INSERT INTO gnwNT_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Jayave pɨareve pe Pablo oo ore ndive opou Jacobo pe. Jare opaete upurugüɨrovia vae reta itenondegua reta uyembatɨ joco pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Jare opa ma umbɨsaluda yave, Pablo umɨmbeu chupe reta quirãi jae uparavɨquɨ judío mbae vae reta ipɨte rupi, jare quirãi Tumpa jeta mbaembae uyapo chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Jae reta uyandu yave, umbɨadora Tumpa. Jayave jei reta Pablo pe: —Orerɨvɨ, ndicuaa ma quirãi jeta ete judío reta güɨrovia ma co Jesús re, jare opaete jae reta uñemɨatangãtu mboroyocui re. ");
INSERT INTO gnwNT_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ẽrei jerãcua chupe reta quirãi nde nemboe opaete judío judío mbae vae reta ipɨte rupi ñugüɨnoi vae reta agüɨye vaerã uyapo Moisés iporoyocui. Echa'ã jerãcua quirãi nde ndere chupe reta agüɨye vaerã umɨcircuncidaca taɨ reta, jare agüɨye vaerã uyapo yande yayapoñoi vae —jei reta Pablo pe—. ");
INSERT INTO gnwNT_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","¿Mbae pa yayapota? Uyembatɨta co jeta vae. Echa'ã jae reta uicuaata nde ndeyu ma co cua pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Jáeramo iyapo cua ndoeta ndeve vae. Ime cua pe ñugüɨnoi irundɨ cuimbae tenonde yave jei mbae uyapota Tumpa pe vae. ");
INSERT INTO gnwNT_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Eraa cua cuimbae reta jare iyeyoe Tumpa cotɨ mboroyocui jei rami jae reta ndive, jare embɨepɨ iñãca uñeapĩca reta vaerã. Jayave opaete vae uicuaata añetete'ã nererãcua chupe reta vae. Echa'ã jae reta uicuaata nde vi co ndiyapo ndico mboroyocui —jei reta—. ");
INSERT INTO gnwNT_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Ẽrei yaicuatía ma judío mbae vae upurugüɨrovia vae reta pe agüɨye vaerã uyapo mboroyocui. Jaeño agüɨye tou reta soo tumpa-raanga pe uñemee vae, jare soo jugüɨ reve, jare maemɨmba uyeyuvɨ vae isoo, jare agüɨye tuyapo aguasa —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Jayave Pablo oo jocua cuimbae reta jupíe, jare pɨareve pe uyeyoe Tumpa cotɨ mboroyocui jei rami jae reta ndive, jare uique Tumpa jo pe umɨmbeu mbae ara pe opata uyeyoe vae. Echa'ã jocua ara penti penti umeeta iofrenda. ");
INSERT INTO gnwNT_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Jare cua rendave pe siete ara opata ma yave, judío Asia pegua reta uecha Pablo Tumpa jo pe, jare uyapo reta tecorai jeta vae ndive. Jayave uipɨsɨ reta Pablo, ");
INSERT INTO gnwNT_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","jare iñeeãta reve jei: —Cuimbae Israel pegua reta, oremborɨ. Cua cuimbae oporomboe opaete que rupi opaete ĩru vae reta oyovaicho vaerã yande ndive, mboroyocui ndive jare cua Tumpa jo ndive. Jare jae güeru griego reta uruique Tumpa jo pe, jare jucuarãi umɨnguɨaca cua o Tumpa oĩ pɨpe vae —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Echa'ã tenonde yave uecha reta tenta guasu pe Efeso pegua Trófimo jee vae Pablo ndive. Jare ipɨa pe uyemɨngueta tẽi Pablo uruique jocua cuimbae Tumpa jo pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Jare opaete tenta guasu pegua reta pochɨ. Jáeramo uyembatɨ reta, jare uipɨsɨ reta Pablo umbɨtɨrɨrɨ Tumpa jo güi oca pe. Jare jupivoiño Tumpa jo iyandarecoa reta uyuquenda onque reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Jayave yatɨ vae reta uipota tẽi uyuca Pablo. Ẽrei jerãcua sundaro reta juvicha pe opaete Jerusalén pegua reta uyapo ñugüɨnoi tecorai. ");
INSERT INTO gnwNT_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Jare jupivoiño jae osi ou yatɨ vae reta cotɨ sundaro reta jare sundaro reta juvicha reta ndive. Jare tenta guasu pegua reta uecha yave sundaro reta jare juvicha, ocua'ã ma Pablo re. ");
INSERT INTO gnwNT_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Jayave sundaro reta juvicha oo Pablo cotɨ jare uipɨsɨ. Oyocui sundaro reta uñapɨ̃ti vaerã mocui cadena pe. Jayave upɨrandu quía ra co jae jare mbae ra co uyapo. ");
INSERT INTO gnwNT_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Amocue tenta guasu pegua reta iñeeãta, ẽrei oyovaque'ã iñee reta. Jare tecorai jeco pegua sundaro reta juvicha ipuere'ã uicuaa mbae ra añete vae. Jáeramo oyocui sundaro reta güɨraa vaerã Pablo jae reta yugüɨreco vae pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Jare uyupi ñugüɨnoi yave sundaro reta yugüɨreco vae pe, sundaro reta ovoɨ güɨraa Pablo, yatɨ vae reta uipota uipɨsɨ ramo. ");
INSERT INTO gnwNT_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Echa'ã opaete yatɨ vae reta yugüɨraa sundaro reta jaɨcue, jare iñeeãta reve jei: —Tumano jocua cuimbae. ");
INSERT INTO gnwNT_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Jare sundaro reta uruiqueta ma yave yugüɨreco vae pe, Pablo jei sundaro reta juvicha pe: —¿Nemaeñota pa mbae jae ndeve? Jae jei Pablo pe: —¿Ndicuaa pa griego iñee? ");
INSERT INTO gnwNT_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Caramboe yave penti Egipto pegua omboemboe cuatro mil upuruyuca vae reta uñerãro vaerã mburuvicha reta ndive, jare güɨraa ñana pe. ¿Nde pa co jae jocua Egipto pegua? —jei. ");
INSERT INTO gnwNT_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Jayave Pablo jei chupe: —Che co jae penti judío Tarso pegua. Jocua tenta guasu oĩ Cilicia pe, jare tuicha co. Emaeño tachemiari tenta guasu pegua reta pe —jei. ");
INSERT INTO gnwNT_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Jayave sundaro reta juvicha jei Pablo pe imiari vaerã. Jayave Pablo uyemboɨ ɨvate oĩ vae pe, jare umupũa ipo tenta guasu pegua reta cotɨ. Jare opaete vae quĩi yave, Pablo imiari chupe reta hebreo iñee pe. Jei chupe reta: ");
INSERT INTO gnwNT_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","—Cherɨvɨ reta jare cherɨqueɨ reta, piyapɨsaca che jaeta peve chiyee vae re. ");
INSERT INTO gnwNT_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Jare tenta guasu pegua reta uyandu yave jae imiari chupe reta hebreo iñee pe, opareve quĩi ngatu. Jayave Pablo jei chupe reta: ");
INSERT INTO gnwNT_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","—Che co jae penti judío. Aa Tarso Cilicia pegua pe, ẽrei acuacuaa cua tenta guasu pe. Gamaliel chemboe cavi yandetenondegua reta iporoyocui re. Che aipota ayapo Tumpa jei vae, opaete pe reta añave pipota rami —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Che ayapo icavi mbae vae opaete Jesús re güɨrovia reve yugüɨreco vae reta pe. Jare aipɨsɨ amɨingueca peresorɨru pe cuimbae reta jare cuña reta. Ayucaca vi amocue vae —jei Pablo—. ");
INSERT INTO gnwNT_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Sacerdote tenondegua jare opaete tenta guasu pegua reta itenondegua reta ipuere umɨmbeu peve cheregua. Jae reta uicuatía umee cheve tupapire araa vaerã ĩru judío reta pe. Jayave aa Damasco cotɨ, aipɨsɨ vaerã tẽi Jesús re güɨrovia vae joco pe ñugüɨnoi vae reta, jare aru vaerã tẽi Jerusalén pe, aiporaraca vaerã tẽi chupe reta —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Ẽrei che coiño ma Damasco güi aa yave, guarasɨ ara mbɨte rupi yave, aramoiño penti tembipe tuicha vae ara güi jembipe cheré. ");
INSERT INTO gnwNT_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Jare aa ɨvɨ re, jare ayandu penti ñee jei cheve: ‘Saulo, Saulo, ¿maera pa ndiyapo icavi mbae vae cheve?’ ");
INSERT INTO gnwNT_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Jayave che jae: ‘¿Quía pa co nde, cheYa?’ Jayave jae jei cheve: ‘Che co jae Jesús Nazaret pegua. Nde ndiyapo icavi mbae vae cheve’ —jei, jei Pablo—. ");
INSERT INTO gnwNT_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Jare che ndive ñugüɨnoi vae reta uecha co tembipe, jare uquɨye reta. Ẽrei uicuaa'ã mbae jei jocua uyemɨngueta cheve vae. ");
INSERT INTO gnwNT_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Jayave che apɨrandu: ‘¿Mbae pa ayapota, cheYa?’ Jare yandeYa jei cheve: ‘Epũa ecua Damasco pe, jare joco pe amɨmbeucata ndeve opaete mbae ndoyocuita jese vae’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Jayave che ndive ñugüɨnoi vae reta chepoco chereraa chereruvãe Damasco pe. Echa'ã chepuere'ã etei amae, jocua tembipe jembipe cheré vae jeco pegua —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Jare ico joco pe penti cuimbae Ananías jee vae. Jae uipɨu Tumpa mboroyocui uyapo reve, jare opaete judío joco pe yugüɨreco vae reta uyemɨngueta cavi jese. ");
INSERT INTO gnwNT_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Jae ou chepɨ. Uyemboɨ cheyɨpɨ pe jare jei: ‘Saulo, nde co jae cherɨvɨ. Emae ye.’ Jare jupivoiño chepuere amae, jare aecha Ananías joco pe oĩ —jei Pablo—. ");
INSERT INTO gnwNT_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Jayave jae jei cheve: ‘Yandetenondegua reta iTumpa ndeparavo, ndicuaa vaerã jae jei vae, jare ndeecha vaerã jocua jupi vae, jare ndiyandu vaerã iñee. ");
INSERT INTO gnwNT_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Echa'ã nemɨmbeuta co jesegua opaete ɨvɨ pegua reta pe. Nemɨmbeuta chupe reta ndeecha jare ndiyandu vae’ —jei, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","‘¿Maera pa añave neãro neĩ? Epũa iyembɨbautizaca ndiyerure reve chupe, nembaeyoa reta uyembai vaerã’ —jei, jei Pablo—. ");
INSERT INTO gnwNT_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Jayave ayu ye Jerusalén pe, jare ayerure aĩ rambueve Tumpa jo pe, cheque pe aecha. ");
INSERT INTO gnwNT_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Jare aecha Jesús, jare jae jei cheve: ‘Ecua ɨmambae Jerusalén güi. Echa'ã ndarau uipota güɨrovia nde nemɨmbeuta cheregua chupe reta vae’ —jei cheve, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Jayave che jae chupe: ‘CheYa, jae reta uicuaa catu co quirãi che aase opaete judío reta itupao reta rupi añonoca vaerã peresorɨru pe jare ainupaca vaerã nderé güɨrovia vae reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Jare uyuca reta yave Esteban nderegua umɨmbeu vae, che vi aĩ joco pe, jare icavi cheve imano. Jare che ayandareco upuruyuca vae reta jemimonde re’ —jae chupe, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Jayave jae jei cheve: ‘Ecua. Echa'ã che nomondota mbɨrɨ judío mbae vae reta cotɨ’ —jei cheve, jei. ");
INSERT INTO gnwNT_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Jare Pablo cua jei yave, tenta guasu pegua reta uipota'ã ma uyapɨsaca jese. Iñeeãta reve jei reta: —Tumano jocua cuimbae. Echa'ã icavi'ã ico vaerã —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Jare iñeeãta reta rambueve, umbɨvava jemimonde, jare ɨvɨcuii omombo ɨvate. ");
INSERT INTO gnwNT_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Jayave sundaro reta juvicha oyocui sundaro reta uruique vaerã Pablo jae reta yugüɨreco vae pe. Jare oyocui vi uinupa reta vaerã chicote pe upɨrandu chupe reve, uicuaa cavi vaerã maera ra tenta guasu pegua reta iñeeãta jucuarãi icotɨ. ");
INSERT INTO gnwNT_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Ẽrei sundaro reta uñapɨ̃ti yave tɨmasa pe, Pablo jei sundaro reta juvicha joco pe oĩ vae pe: —¿Jupi pa pinupa vaerã penti romano peãa mbae reve? ");
INSERT INTO gnwNT_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Cua uyandu yave, sundaro reta juvicha oo itenondegua pe jare jei chupe: —¿Mbae pa ndiyapota? Echa'ã jocua cuimbae penti romano co. ");
INSERT INTO gnwNT_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Jayave sundaro reta juvicha itenondegua ou Pablo oĩ vae pe jare jei chupe: —Emɨmbeu cheve, ¿romano pa co nde? Jayave Pablo jei chupe: —Jae co che. ");
INSERT INTO gnwNT_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Jayave sundaro reta juvicha itenondegua jei chupe: —Che jeta ambɨepɨ ayeyapo vaerã romanorã. Jayave Pablo jei chupe: —Ẽrei che pɨpe voi aa. ");
INSERT INTO gnwNT_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Jayave yugüɨraa Pablo güi upɨranduta tẽi chupe vae reta. Jare sundaro reta juvicha itenondegua uquɨye, uicuaa yave jae romano co, uñapɨ̃tica ramo. ");
INSERT INTO gnwNT_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Jare pɨareve pe sundaro reta juvicha itenondegua uipota uicuaa cavi mbae re ra judío reta umbɨjeco Pablo. Jáeramo oyora Pablo, jare oyocui sacerdote reta itenondegua reta jare opaete ĩru mburuvicha reta uyembatɨ vaerã. Jayave güɨraa Pablo oñono jae reta jovai. ");
INSERT INTO gnwNT_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Jayave Pablo umae ngatu mburuvicha reta re jare jei: —Cherɨqueɨ reta, che jecuaeño aico cavi, chepɨa icavi anoi vaerã Tumpa cotɨ. ");
INSERT INTO gnwNT_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Jayave sacerdote tenondegua Ananías jee vae oyocui Pablo iyɨpɨ pe ñugüɨnoi vae reta ocua vaerã iyuru re. ");
INSERT INTO gnwNT_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Jayave Pablo jei chupe: —Tumpa tocua nderé. Echa'ã nde co jae ɨguambɨ tĩ asɨ vae rami. Nde ndeguapɨ co neĩ cherãa vaerã mboroyocui jei vae rupi. Ẽrei ndiyavɨ mboroyocui. Echa'ã ndiyocui reta ocua vaerã cheré —jei. ");
INSERT INTO gnwNT_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Jayave joco pe ñugüɨnoi vae reta jei chupe: —¿Maera pa nde ndere ñee icavi mbae vae Tumpa isacerdote tenondegua pe? ");
INSERT INTO gnwNT_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Jayave Pablo jei: —Cherɨqueɨ reta, aicuaa'ã jae co sacerdote tenondegua. Echa'ã uyecuatía oĩ: ‘Ndereta'ã ñee icavi mbae vae nderuvicha cotɨ’ —jei. ");
INSERT INTO gnwNT_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Jare Pablo uecha yave amocue jae reta saduceo reta jare amocue fariseo reta, iñeeãta reve jei mburuvicha reta ipɨte pe: —Cherɨqueɨ reta, che co jae penti fariseo, jare cheru vi co jae penti fariseo. Che arovia umanocue vae reta icove yeta co. Cua jeco pegua pe reta cherãa peĩ —jei. ");
INSERT INTO gnwNT_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Jare cua jei yave, uyembɨyao uyugüi yatɨ vae reta, jare fariseo reta uyeaca saduceo reta ndive. ");
INSERT INTO gnwNT_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Echa'ã saduceo reta jei umanocue vae reta ndarau ma icove ye. Jei vi mbaetɨ co oĩ ángel jare espíritu. Ẽrei fariseo reta güɨrovia ime co. ");
INSERT INTO gnwNT_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Jare uyeaca reta uyupii. Jare upũa amocue fariseo pegua mboroyocui re oporomboe vae reta jare jei: —Ore nuvãe'ã etei teco cua cuimbae re. Aramoi penti espíritu ani ángel imiari chupe. Agüɨye yayovaicho Tumpa ndive —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Jare jeiete uyeaca reta uyupii yave, sundaro reta juvicha itenondegua ipɨa pe uyemɨngueta aramoi uyucata reta Pablo, jare oyocui sundaro reta yugüeru vaerã güɨraa Pablo jae reta ipɨte güi sundaro reta yugüɨreco vae pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Jare pɨareve pe pɨ̃tu yave yandeYa uyecuaa Pablo pe jare jei chupe: —Iñemɨatangãtu, Pablo. Chemɨmbeu ma Jerusalén pe. Chemɨmbeuta vi co Roma pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Jayave pɨareve pe amocue judío reta uyemboemboe, jare uyepɨpeyu reve iyee jei ucaruta'ã jare jouta'ã ɨ, uyuca regua Pablo. ");
INSERT INTO gnwNT_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Jare cuimbae cua jei uyepɨpeyu reve iyee vae reta cuarenta uasa. ");
INSERT INTO gnwNT_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Jayave jae reta yugüɨraa sacerdote reta itenondegua reta jare tenta guasu pegua reta itenondegua reta pe jare jei chupe reta: —Ore ndoe ma nduyepɨpeyu reve oriyee nducaruta'ã, nduyuca regua Pablo. ");
INSERT INTO gnwNT_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Jáeramo pe reta ĩru mburuvicha reta ndive pemɨmbeu sundaro reta juvicha itenondegua pe tugüeru Pablo peve pɨareve. Jae ipɨa pe uyemɨngueta tẽita pe reta pipota pepɨrandu cavi ete chupe mbae uyapo vae re. Jayave ore nucuatɨ̃rota noĩ jese nduyuca vaerã, ndei ou uvãe mbove —jei reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Ẽrei Pablo jindɨ imembɨ cuimbae vae uicuaa yave jae reta ucuatɨ̃rota Pablo re vae, oo uique sundaro reta yugüɨreco vae pe, jare umɨmbeu Pablo pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Jayave Pablo ueni sundaro reta juvicha jare jei chupe: —Eraa cua cunumi nderuvicha pe. Echa'ã uipota mbae umɨmbeu chupe —jei. ");
INSERT INTO gnwNT_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Jayave sundaro reta juvicha güɨraa cunumi juvicha tenondegua vae pe, jare jei chupe: —Pablo uyepɨsɨ oĩ vae chereni, jare chemɨñera aru vaerã ndepɨ cua cunumi. Echa'ã uipota mbae umɨmbeu ndeve —jei. ");
INSERT INTO gnwNT_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Jayave sundaro reta juvicha itenondegua uipɨsɨ cunumi ipo pe, jare güɨraa ĩru vae reta ñugüɨnoi vae güi. Jayave upɨrandu chupe: —¿Mbae pa nemɨmbeuta cheve? ");
INSERT INTO gnwNT_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Jayave cunumi jei chupe: —Judío reta uyemboemboe ma, jare nemɨñerata Pablo nderaaca vaerã curiye mburuvicha reta pe. Uipota nde ndepɨa pe ndiyemɨngueta tẽi vaerã jae reta upɨrandu cavi eteta chupe mbae uyapo vae re —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Ẽrei agüɨye erovia. Echa'ã judío reta ucuatɨ̃rota jese. Jae reta cuarenta uasa. Jei reta uyepɨpeyu reve iyee ucaruta'ã jare jouta'ã ɨ, uyuca regua Pablo. Jare añave uãro ñugüɨnoi, aramoi nderaaca pegua —jei chupe. ");
INSERT INTO gnwNT_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Jayave sundaro reta juvicha itenondegua jei cunumi pe: —Agüɨye emɨmbeu quía pe cua nemɨmbeu cheve vae. Jayave omondo cunumi. ");
INSERT INTO gnwNT_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Jayave sundaro reta juvicha itenondegua ueni mocui sundaro reta juvicha jare jei chupe reta: —Piyapɨcatu cavi doscientos sundaro reta, jare setenta sundaro cavayu re opo vae reta, jare doscientos sundaro güɨraa uɨ vae reta, yugüɨraa vaerã Cesarea pe nueve ora ma pɨ̃tu yave. ");
INSERT INTO gnwNT_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Jare peeca Pablo opo vaerã, peraa cavi vaerã mburuvicha guasu Félix pe —jei chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Jayave jae uicuatía penti tupapire pe cuarãi: ");
INSERT INTO gnwNT_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Félix. Nde co jae mburuvicha guasu uyembutuichaca vae. Che co jae Claudio Lisias. Numbɨsaluda. ");
INSERT INTO gnwNT_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Judío reta uipɨsɨ cua cuimbae, jare uyucata tẽi. Jayave che aa sundaro reta ndive aepɨ chugüi reta. Echa'ã jerãcua cheve jae romano co. ");
INSERT INTO gnwNT_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Jare aipota aicuaa maera ra jae reta umbɨjeco. Jáeramo araa judío reta juvicha reta upuruãa vae pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Joco pe aicuaa jae reta umbɨjeco iporoyocui re. Ẽrei jae uyapo'ã teco umano vaerã ani oĩ vaerã peresorɨru pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Ẽrei jerãcua cheve judío reta ucuatɨ̃rota jese. Jáeramo jupivoiño amondo ndecotɨ. Jare ayocui umbɨjeco vae reta uñeapo vaerã jese ndeve teco uyapo chupe reta vae re. Jaeño ma.” Jucuarãi uicuatía. ");
INSERT INTO gnwNT_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Jayave pɨ̃tu yave sundaro reta güɨraa Pablo tenta guasu Antípatris pe, juvicha oyocui rami. ");
INSERT INTO gnwNT_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Jayave pɨareve pe sundaro cavayu re opo vae reta güɨraa Pablo, jare ĩru sundaro reta yugüeru ye yugüɨreco vae pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Jare yugüɨraa uvãe yave Cesarea pe, sundaro reta umee Pablo tupapire reve mburuvicha guasu pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Jare opa umɨngueta yave tupapire, mburuvicha guasu upɨrandu Pablo pe quía tenta guasu pegua ra co jae. Jare uicuaa yave Cilicia pegua co, ");
INSERT INTO gnwNT_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","jei Pablo pe: —Tayapɨsaca nderé, yugüeru yave nembɨjeco vae reta. Jayave oyocui sundaro reta uyandareco vaerã jese mburuvicha Herodes jenta pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Pandepo ara ma uasa yave, yugüeru sacerdote tenondegua Ananías, amocue tenta guasu pegua reta itenondegua reta jare penti cuimbae Tértulo jee vae. Cua cuimbae iyaracuaa catu uyemɨngueta vaerã. Jae reta uñeapo Pablo re mburuvicha pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Jare Pablo uñeeni ma yave, Tértulo umbɨpɨ umbɨjeco Pablo. Jae jei Félix pe: —Ndereco pegua orepɨacatu nduico. Ndearacuaa jeco pegua ndeporoyocui cavi jeta mbaembae re oreɨvɨ pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Nde co jae oreruvicha numbutuicha vae. Opaete que rupi jecuaeño nduyapo yasurupai ndeve opaete cua re —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Ndepɨacavi ramo, numɨñera ndiyapɨsaca vaerã oriñee re michi peguaño, agüɨye vaerã numambeco mbatee —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Echa'ã nduicuaa ma cua cuimbae upurumbɨavai penti mbaerasɨ rami. Jae omboemboe judío opaete ɨvɨ rupi ñugüɨnoi vae reta. Jare jae co penti nazareno pegua reta itenondegua —jei Tértulo Félix pe—. ");
INSERT INTO gnwNT_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Jae uipota vi uyapo jupi mbae vae Tumpa jo pe. Ẽrei ore nduipɨsɨ, jare nuãata tẽi oreporoyocui pe uyecuatía oĩ vae rupi. ");
INSERT INTO gnwNT_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Ẽrei sundaro reta juvicha itenondegua Lisias ou umɨãta oregüi jare upɨ̃ro güɨraa oregüi. ");
INSERT INTO gnwNT_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Jare oyocui umbɨjeco vae reta yugüeru vaerã ndepɨ. Nde etei neãa yave, ndicuaata opaete numbɨjeco vae —jei. ");
INSERT INTO gnwNT_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Judío reta vi jei añete co opaete cua mbaembae. ");
INSERT INTO gnwNT_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Jayave mburuvicha guasu upuvẽe Pablo re uyemɨngueta vaerã. Jayave Pablo jei: —Che aicuaa catu co nde ɨma ete ma neãa cua ɨvɨ pegua reta. Jáeramo ayerovia reve chemiarita ayerepɨ vaerã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Nde ndepuere ndicuaa rami, doce ara ramo aa güive Jerusalén pe, ambɨadora vaerã Tumpa. ");
INSERT INTO gnwNT_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Jare cua reta cherecha'ã ayeaca quía ndive, ani amboemboe tenta guasu pegua reta Tumpa jo pe, ani itupao reta pe, ani tenta guasu rupi —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Añete chembɨjeco ma cua mbaembae re. Ẽrei mbaetɨ mbae añete vae ipuere umɨmbeu ndeve cua mbaembae re —jei Pablo—. ");
INSERT INTO gnwNT_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Ẽrei cua amɨmbeu ndeve. Che aico Jesús re arovia reve, jare jucuarãi ayeyocui chetenondegua reta iTumpa pe, yepe tẽi judío reta jei aico penti moromboe añete mbae vae re. Echa'ã che arovia opaete mboroyocui pe uyecuatía oĩ vae, jare Tumpa iñee aracae umɨmbeu vae reta uicuatiacue —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Che arovia Tumpa umbɨjecove yeta co umanocue vae reta. Jae umbɨjecoveta jupi vae reta jare jupi mbae vae reta. Jucuarãi cua reta güɨrovia vi. ");
INSERT INTO gnwNT_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Jáeramo che jecuaeño aipota chepɨa icavi anoi vaerã Tumpa cotɨ jare ɨvɨ pegua reta cotɨ —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Che mbovɨ año ma aico'ã cheɨvɨ pe. Jaeramo ayu ye, corepoti aru vaerã iparavete vae reta peguarã jare Tumpa peguarã. ");
INSERT INTO gnwNT_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Jare cua ayapo aĩ rambueve, amocue Asia pegua judío reta cherecha Tumpa jo pe. Joco pe ayeyoe aĩ Tumpa cotɨ mboroyocui jei rami. Ayembatɨ'ã co jeta vae ndive. Ayapo'ã vi tecorai —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Icavi tẽi co jocua judío reta yugüeru vaerã cua pe uñeapo cheré ndeve, ime yave mbae chembɨjeco jese vae —jei Pablo Félix pe—. ");
INSERT INTO gnwNT_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Cua reta etei tumɨmbeu ndeve mbae nunga teco uvãe cheré, mburuvicha reta jovai ayemboɨ yave. ");
INSERT INTO gnwNT_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Aramoi jaeño penti mbae re ipuere chembɨjeco. Mburuvicha reta ipɨte pe aĩ rambueve, chiñeeãta reve jae: ‘Umanocue vae reta icove yeta vae re pe reta cherãa peĩ cua ara.’ Jucuarãi jae —jei. ");
INSERT INTO gnwNT_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Jare Félix cua uyandu yave, oyopia judío reta. Echa'ã jae uicuaa catu Jesús re güɨrovia vae reta ipurugüɨrovia regua. Jáeramo jei judío reta pe: —Sundaro reta juvicha itenondegua Lisias ou yave, aãata cua pemɨmbeu cheve vae re. ");
INSERT INTO gnwNT_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Jayave Félix oyocui sundaro reta juvicha uyandareco vaerã Pablo re. Ẽrei oyocui vi umaeño vaerã icoiño, jare agüɨye vaerã oyopia jentarã reta, ou yave ipɨ uyeyocui chupe vaerã. ");
INSERT INTO gnwNT_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Mbovɨ ara rupi Félix ou jembireco Drusila jee vae ndive. Drusila co jae penti judía. Jayave Félix ueni Pablo, jare uyapɨsaca quirãi yaroviata co Jesucristo re vae re. ");
INSERT INTO gnwNT_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Jare Pablo jei chupe quirãi icavi yayapo vaerã jupi vae, jare yayopia vaerã yanderete uipota vae güi, jare quirãi Tumpa uãata ɨvɨ pegua reta. Jayave Félix uquɨye jare jei Pablo pe: —Ecuaño rani. Chepuere yave, turueni ye curi. ");
INSERT INTO gnwNT_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Ẽrei Félix uipota tẽi vi Pablo umee vaerã corepoti chupe, oyoraca vaerã. Jáeramo güeruruca aveiño, uyemɨngueta vaerã jae ndive. ");
INSERT INTO gnwNT_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Ẽrei mocui año ma uasa yave, Porcio Festo ou uipepɨca Félix. Jare Félix uipota umbɨyerovia judío reta ramo, ueya Pablo peresorɨru pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Festo ou uvãe yave jocua ɨvɨ pe, mbapɨ ara ma uasa yave, oo Cesarea güi Jerusalén pe. ");
INSERT INTO gnwNT_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Jayave sacerdote reta itenondegua reta jare judío reta itenondegua reta imiari chupe Pablo jeco re, jare umɨñera ");
INSERT INTO gnwNT_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","uyapo vaerã icavi vae chupe reta, güeruruca vaerã Pablo Jerusalén pe. Jare jae reta ucuatɨ̃rota jese tape rupi, uyuca vaerã tẽi. ");
INSERT INTO gnwNT_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Ẽrei Festo jei chupe reta: —Ore nduyandareco noĩ Pablo re Cesarea pe, jare che aata joco pe curi. ");
INSERT INTO gnwNT_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Pepuere yave, pecua cherupíe. Jare uyapo yave teco icavi mbae vae jocua cuimbae, piñeapo jese —jei chupe reta. ");
INSERT INTO gnwNT_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Jayave Festo upɨta yave joco pe aramoi ocho ani diez ara, ou ye Cesarea pe. Jayave pɨareve pe uguapɨ upuruãa vae pe, jare güeruruca Pablo. ");
INSERT INTO gnwNT_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Jare Pablo ou ma yave, judío Jerusalén güi yugüeru vae reta uyemboɨ Pablo iyɨpɨ rupi jare umbɨjeco jeta icavi mbae vae re. Ẽrei ipuere'ã uicuaaca cua teco uipota omboya jese vae añete co. ");
INSERT INTO gnwNT_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Jayave Pablo jei uyerepɨ vaerã: —Ayovaicho'ã etei judío reta iporoyocui ndive, ani Tumpa jo ndive, ani César ndive. ");
INSERT INTO gnwNT_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Ẽrei Festo uipota umbɨyerovia judío reta. Jáeramo upɨrandu Pablo pe: —¿Ndipota pa ndeo Jerusalén pe, che nuãa vaerã joco pe cua teco reta re? ");
INSERT INTO gnwNT_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Ẽrei Pablo jei chupe: —César ndeocui nepuruãa vaerã, jare icavi co nde cherãa vaerã cua pe. Ayapo'ã etei teco judío reta cotɨ. Nde etei ndicuaa cua —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Ime yave teco ayapo icotɨ, ani ime yave mbae ayapo amano vaerã, ndarau ayerure ndeve ayerepɨ vaerã mano güi. Ẽrei cua teco uipota omboya cheré vae ayapo'ã yave, ndarau quía ipuere chemee chupe reta. Aipota César cherãa vaerã —jei chupe. ");
INSERT INTO gnwNT_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Jayave Festo uyemɨngueta ĩru mburuvicha reta ndive. Jayave jei Pablo pe: —Ndipota César nerãa vaerã. César pe ndeota —jei. ");
INSERT INTO gnwNT_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Jare mbovɨ ara ma uasa yave, mburuvicha guasu Agripa jare jindɨ Berenice yugüeru Cesarea pe, umbɨsaluda vaerã Festo. ");
INSERT INTO gnwNT_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Jare mbovɨ ara ma joco pe ñugüɨnoi yave, Festo umɨmbeu mburuvicha guasu pe Pablo regua. Jei chupe: —Ime cua pe oĩ penti cuimbae Félix ueya peresorɨru pe vae. ");
INSERT INTO gnwNT_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Jerusalén pe aa yave, judío pegua sacerdote reta itenondegua reta jare tenta guasu pegua reta itenondegua reta umɨmbeu cheve cua cuimbae regua. Jae reta chemɨñera che jae vaerã icavi co uyeyucaca vaerã —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Ẽrei che jae chupe reta: ‘Romano reta uyepocua'ã umee vaerã quía, ndei umbɨjeco vae reta yugüeru uñeapo jese mbove jare ndei uyerepɨ umbɨjeco vae reta güi mbove’ —jae chupe reta, jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Jáeramo jae reta yugüeru uvãe yave, aãro'ã. Pɨareve pe aguapɨ apuruãa vae pe, jare aruruca jocua cuimbae —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Jare umbɨjeco vae reta joco pe ñugüɨnoi, ẽrei umɨmbeu'ã cheve jocua nunga teco che chepɨa pe ayemɨngueta tẽi omboyata jese vae. ");
INSERT INTO gnwNT_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Jaeño umbɨjeco reta jae ipurugüɨrovia re, jare penti cuimbae Jesús jee vae re. Jocua Jesús umano ma. Ẽrei Pablo jei icove ye co —jei—. ");
INSERT INTO gnwNT_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Che aicuaa'ã mbae ra ayapota cua re. Jáeramo apɨrandu Pablo pe uipota ra oo Jerusalén pe, joco pe che aãa vaerã cua mbaembae re. ");
INSERT INTO gnwNT_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Ẽrei Pablo uipota nduyandareco vaerã jese, Augusto uãa vaerã. Jáeramo ayocui sundaro reta uyandareco vaerã jese, César pe chepuere amondo regua —jei. ");
INSERT INTO gnwNT_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Jayave Agripa jei Festo pe: —Che vi aipota ayapɨsaca jocua cuimbae re. Jayave Festo jei chupe: —Curiye ndiyapɨsacata jese. ");
INSERT INTO gnwNT_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Jayave pɨareve pe Agripa jare Berenice yugüeru jemimonde ipõra vae ndive, jare uique reta Festo upuruãa vae pe sundaro reta juvicha itenondegua reta jare tenta guasu pegua reta itenondegua reta ndive. Jayave Festo oyocui güeru vaerã Pablo. ");
INSERT INTO gnwNT_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Jayave Festo jei: —Mburuvicha guasu Agripa