﻿USE sofia;
DROP TABLE IF EXISTS sofia.gnn_vpl;
CREATE TABLE gnn_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES gnn_vpl WRITE;
INSERT INTO gnn_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Ŋäthilinydja ŋurruthaŋalanydja wal'ŋu yukurrana nhinana ŋayipi‐waŋgany Gunhu' God Waŋarr, ŋunhi yaka muka yana wäŋa dhuwalanydja munathany'tja maḻŋ'thurruna. Bala yana ŋayi bokmarana Gunhu'yu dhuwalana wäŋa, munatha'na ga gapuna ga djiwarr'nha. ");
INSERT INTO gnn_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Ŋunhi ŋayi ŋurruthaŋalanydja dhuwala munathany'tja wäŋa maḻŋ'thurruna buyuwuyu muka yana, ŋula nhämiriw muka, gapuyuŋga yana yukurrana ŋapa‐ŋäkirrmaraŋala, ga munha'yurruna yukurrana djingaryurrunanydja, warrpam munhayu monyguŋala gapunhanydja ŋunhiyi, yurru watanydja ŋunhiyi Gunhu'wuna nhanŋuwaynha walŋamirrina Birrimbirr yukurrana mali'‐maliyurruna ŋuliwitjarra ŋapakurrunydja gapukurru. ");
INSERT INTO gnn_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Bala ŋuliŋuruyinydja Gunhu' waŋanana, “Ma' djarraṯawun'thiyana,” bitjarra. Bala yuwalkthi djarraṯawun'thinanydja wäŋa dhuwalanydja. ");
INSERT INTO gnn_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Gunhu'yu nhäŋala ŋunhiyi djarraṯawun', bala ḻatju' ḻakaraŋalana, bala yana ŋayi ganaŋ'maraŋalana djarraṯawun'nhanydja beŋuru bukumunha'ŋurunydja. ");
INSERT INTO gnn_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Bala ŋayi yäku nherrara djarraṯawun'tja waluwuynha, ga munhanydja ŋayi yäku nherrara munhakuna. Ga ŋunhiyinydja ŋurruŋuna munha. ");
INSERT INTO gnn_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Ga munhanydja djuḻkthurrunana, bala djaḏaw'yurrunanydja goḏarr'nha, bala Gunhu' waŋana bitjarrana, “Garrwarnydja yurru dhärra yukurra, balanyara bitjan bala'pala, bala yurru gapunydja gulk‐gulkthunmirrina märrma'lilina,” bitjarra. Bala yuwalkthi garrwarnydja maḻŋ'thurrunana. ");
INSERT INTO gnn_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Gunhu'yu djäma bitjarrayi bala'palakuŋala, bala ŋayi gulk‐gulkthurrunana gapunhanydja, märrma'kuŋalana, bala gurrunhara gapunydja ḏuwaṯnha garrwarnha wal'ŋu, ga wiripunydja gapu dhipala bäyma munatha'lili. ");
INSERT INTO gnn_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Bala ŋayi Gunhu'yu yäkunydja nherrara bala'palanydja gäraknha. Ga ŋunhiyinydja bitjarrayi wiripuŋuyuna munhayu. ");
INSERT INTO gnn_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Ga munha djuḻkthurruna, bala djaḏaw'yurruna goḏarr'nha, bala Gunhu' waŋana bitjarrana, “Dhuwala gapu ŋunhi yukurra bäni dhuwala munatha'ŋuranydja yurru gulk‐gulkthunmirrina, yupthunna waŋganylilina, märr yukurra yurru wäŋa ŋarakanydja dhärra baṉḏany' yana,” bitjarra. Bala yuwalkthi ŋunhi maḻŋ'thurrunanydja munathany'tja wäŋa, ga gapu ŋunhi giṯthurruna waŋganylilina. ");
INSERT INTO gnn_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Bala Gunhu'yu yäku nherrara ŋarakanydja wäŋa munatha'na, ga giṯthunaranydja gapu ŋayi yäku nherrara moṉuknha. Bala ŋayi goŋmirriyinana nhäŋalanydja ŋunhiyi nhanukuŋuway djämawuynydja, bala ḻatju' ḻakaraŋalana. ");
INSERT INTO gnn_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Ga biyapul ŋayi Gunhu' waŋana bitjarra, “Ŋunhalanydja yurru munatha'ŋuranydja ŋuthan yukurra birrka'mirrina borum dharpa ga mulmu, ŋatha dhika nhäna malanha.” Bala yuwalkthi ŋunhi maḻŋ'thurrunanydja. ");
INSERT INTO gnn_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Birrka'mirrina dharpanydja yukurrana maḻŋ'thurrunana, borum dharpa, ŋatha ga birrka'mirrina nhäna malanha mulmu. Bala ŋayi Gunhu'yu nhäŋalanydja goŋmirriyinana ŋunhiyi nhanukuŋuway djämawuynydja, bala ḻatju' ḻakaraŋalana. ");
INSERT INTO gnn_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Ga ŋunhiyinydja bitjarrayi wiripuŋuyuna munhayu. ");
INSERT INTO gnn_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","15","Ga djuḻkthurruna munhanydja, bala djaḏaw'yurruna goḏarr'nha, bala ŋayi Gunhu' waŋana bitjarra. “Djarraṯawun'tja yukurra yurru dhärra garrwarnydja, märrma' bathalanydja maṉḏanha, barrkuwatj maṉḏa yurru yulŋunydja, ganaŋ'marama yurru waluwuynha munhakuŋurunydja. Dhiyaŋu djarraṯawun'thunydja maṉḏaŋuyu yurru djarraṯawun'kuma dhuwala munatha'na, räkukuma yukurra, ga bitjandhiyi maṉḏa yurru yukurra ḻakaramanydja wiripuŋuyamana walunydja ga dhuŋgarranhanydja ga walu borummirriyinyarawu”, bitjarra ŋayi Gunhu' waŋananydja. Bala yana yuwalkthi maḻŋ'thurrunanydja. ");
INSERT INTO gnn_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Yo, Gunhu'yu bitjarrayinydja bokmara märrma' yindinydja djarraṯawun' maṉḏanha. Ŋayi djäma walunydja walu‐ŋupanarawu nhinanharawu, ga ŋaḻindinydja ŋayi djäma munha‐ŋupanarawu nhinanharawu, ga biyapul ŋayi djäma ganyuny'tja malanha guḻkuny'tja wal'ŋu; ");
INSERT INTO gnn_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","nherraranydja ŋayi ŋunhiyi garrwarlilina malanha, märr walala yukurra yurru djarraṯawun'kuma lili munatha' wäŋa, ");
INSERT INTO gnn_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","yana räkukunharawu walu‐ŋupanarawu ga munha‐ŋupanarawu, bitjan ganaŋ'marama waluwuynhanydja munhaŋuru. Bala ŋayi Gunhu'yu goŋmirriyinana nhäŋalanydja ŋunhiyi nhanukuŋuway djämawuynydja, bala ḻatju' ḻakaraŋalana ŋayi. ");
INSERT INTO gnn_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Ga ŋunhiyinydja bitjarrayi wiripuŋuyuna munhayu. ");
INSERT INTO gnn_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Ga munhanydja djuḻkthurruna, bala djaḏaw'yurruna goḏarr'nha, bala ŋayi Gunhu' waŋana bitjarra, “Guḻku'na yurru yukurra guyanydja malanha ŋorra gapuŋuranydja ŋunhalayi, ga wäyin yurru yukurra buṯthunna ŋula gärakkurrunydja,” bitjarra. Bala yuwalkthi ŋunhi maḻŋ'thurrunanydja balanyarayinydja malanha. ");
INSERT INTO gnn_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Gunhu'yu bitjarrayi bokmara wakinmirrinhanydja wal'ŋu guyanha, ga yumurrku'nha malaŋunha, wiripuŋunha ga wiripuŋunha nhänha malaŋunha ŋunhi nhina yukurra gapuŋura; ga biyapul wäyinnha ŋayi bokmarayi wiripuŋunha ga wiripuŋunha malaŋunha buṯthunaramirrinha. Bala ŋayi goŋmirriyinana nhäŋalanydja ŋunhiyi nhanukuŋuway djämawuynydja, bala ḻatju' ḻakaraŋalana. ");
INSERT INTO gnn_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Bala ŋayi Gunhu' waŋana dhäruktja, bitjarra goŋmirriyaŋalana dhikana ŋayi walalanha, “Nhuma nhä malanha ŋunhi nhuma yukurra nhina gapuŋura, nhumanydja yurru biyapulnha mala‐guḻku'yirri wal'ŋu, dhaŋaŋdhirrina yurru biyapulnha wal'ŋu gapuŋuranydja. Ga nhuma wäyin buṯthunaramirri malanha yurru bitjandhiyi liŋgu mala‐wunharamirri, guḻku'yirrina yurru biyapulnha mala,” bitjarra ŋayi Gunhu' waŋananydja. ");
INSERT INTO gnn_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Ga ŋunhiyinydja bitjarrayi wiripuŋuyuna munhayu. ");
INSERT INTO gnn_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Ga munhanydja djuḻkthurruna, bala djaḏaw'yurruna goḏarr'nha, bala ŋayi Gunhu' waŋana bitjarra, “Dhiyalimi munatha'ŋuranydja yukurra yurru nhina wiripu ga wiripu wäyin malanha, yumurrku' wäyin ga wakinmirri, goŋmirri ga wakinŋu ḏiltjiwuy wäyin,” bitjarra. Bala yuwalkthina ŋunhi bitjarrayi maḻŋ'thurrunanydja. ");
INSERT INTO gnn_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Yo, Gunhu'yu bitjarrayi bokmaranydja birrka'mirrinha wäyinnhanydja malaŋunha, yumurrku'nha ga wakinmirrinha. Bala ŋayi Gunhu'yunydja goŋmirriyinana nhäŋalanydja ŋunhiyi nhanukuŋuway djämawuynydja, bala ḻatju' ḻakaraŋalana. ");
INSERT INTO gnn_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Ga ŋuliŋurunydja dhurrwaraŋuru ŋayi Gunhu' waŋana bitjarrana, “Ŋilimurru dhiyaŋunydja‐wala yurru djäma yolŋunhana ŋi, yurru yolŋunydja yurru malinydja ŋunhi bitjan ŋilimurruway yana. Ŋilimurru yurru nherraṉdja yolŋuwala goŋlili bukmak ŋunhi ŋarrakuŋu bokmanaranydja, guya ga wäyin malanha, buṯthunaramirri ga marrtjinyamirri ga gaḻ'yunaramirri wäyin, bathalamirri ga yumurrku'; bukmaknha yurru dhuwalayi malanha yolŋuwala yana djäkaŋura,” bitjarra ŋayi Gunhu' waŋananydja. ");
INSERT INTO gnn_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Bala Godthu djäma yolŋunhana mali bitjan ŋayipi djan'ku yana; ŋayi djämanydja yolŋunha ŋayaŋumirri ga ḻiyamirri yana, märr yurru ŋayi nhina yukurra waŋganyŋura Godkala nhanukalay ŋayi djarr'yunarayu. Yo, djämanydja ŋayi yolŋunha maṉḏanha, ḏarramunha ga miyalknha. ");
INSERT INTO gnn_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Bala ŋayi waŋananydja maṉḏakala, goŋmirriyaŋalana manapara bitjarrana, “Nhumalaŋguŋunydja yurru walkur‐märranhara yukurra guḻku'na mirithirrina wal'ŋu yo‐yuthu; walala yurru yukurra nhumalaŋguŋu mala‐wunharamirrina barrkuwatjthirrina wäŋalilina malaŋulili bawala'mirrililina, bala walalana yurru goŋdhu ŋayathama yukurra wäŋanydja dhuwala munathany'tja, ga bitjarrayi ŋarra nherrara goŋlili nhumalaŋgala yolŋu'‐yulŋuwalanydja bukmak nhä malanha ŋunhi yukurra marrtji'‐marrtji gapukurru ga ŋula munatha'kurru ga gärakkurru buṯthu'‐buṯthun.” ");
INSERT INTO gnn_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Ga biyapul Gunhu' waŋana maṉḏakala bitjarra, “Ŋarra gurrunhara wiripu ga wiripu borum ga ŋatha nhumalaŋgunydja yolŋu'‐yulŋuwunydja ḻukanharawu, ");
INSERT INTO gnn_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","ga walalanydja yurru wäyindhunydja ḻuka mulmu ga marwat dharpawuy, liŋgu dhuwalayi malanha ŋarra gurrunhara walalaŋgunydja ḻukanharawu, ŋurikiyi yumurrku'wu ga bathalawu wäyingu ga wäyingu buṯthunaramirriwu.” Bala yuwalkthina maḻŋ'thurrunanydja. ");
INSERT INTO gnn_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Gunhu'yu nhäŋalanydja yukurrana ŋunhiyi nhä malanha ŋayi djäma, bala ŋayi goŋmirriyinana nhäŋalanydja, bala ḻakaraŋala ḻatju' dhika wal'ŋu, warrpam yana. Ga ŋunhiyinydja bitjarrayi wiripuŋuyuna munhayu. ");
INSERT INTO gnn_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Yo, Gunhu'yu bokmaranydja dhuwala wäŋa munatha' ga garrwar, ga bukmak nhä malanha ŋorra marrtji dhiyalami munatha'ŋura ga gapuŋura ga garrwar; djämanydja ŋayi bukmak dhawar'maraŋalana. ");
INSERT INTO gnn_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Ga munhanydja djuḻkthurrunana, bala djaḏaw'yurruna goḏarr'nha, ga ŋuriŋiyinydja waluyu 7‐dhunydja ŋayi Gunhu' nhinanana, liŋgu djämanydja nhanŋu ŋunhiyi liŋguna dhawar'yurrunana. ");
INSERT INTO gnn_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Yo, Gunhu'yu djämanydja ŋunhi waŋgany‐rulu'yu ga waŋganydhu bäythinyarayu munhayu, bala wiripuŋuyunydja munhayu ŋayi nhinanana, djämana dhawar'yurruna nhanŋu. Bala ŋayi goŋmirriyinana ŋurikiyinydja waluwu, bala yana ganaŋ'maraŋalana; gänana ŋunhiyinydja waŋganydja nhinanharamirrina walu ŋurikalanydja waŋgany‐rulu'walanydja ga waŋganygala bäythinyarawala, liŋgu ŋuriŋiyinydja waluyu ŋayi ḏaḏawyurrunana djämaŋuru, liŋgu nhanukuŋu nhä malanha bokmanara warrpam dhawar'yurrunana. ");
INSERT INTO gnn_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Ga bitjarrayina ŋunhi dhuwala wäŋa maḻŋ'thurrunanydja, munatha' ga gapu ga djiwarr', ga bukmak nhä malanha ŋunhi dhiyalami ŋorra marrtji. ");
INSERT INTO gnn_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Yo. Garrayyu Gunhu'yu ŋäthilinydja djäma dhuwala munatha' wäŋa, ga bukmak yana ŋunha marrtji ŋorra garrwar, yurru wäŋanydja dhuwala munathany'tja nhämiriw muka, mulmumiriw ga dharpamiriw ga ŋathamiriw, liŋgu yaka muka yana dhamany'tjurrunanydja yukurrana, liŋgu Gunhu'yu yaka muka yana djuy'yurruna waltjaṉ dharyunarawu munatha'wu, ga yaka yolŋu yukurrana nhinana ŋula djämawu gurarrkunharawu. ");
INSERT INTO gnn_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Yo, yaka muka yana waltjaṉdhunydja ŋuli yukurranha dharyuna, yurru ŋunhi gapunydja ŋamuny'tjuna ŋuli djinawa'ŋuru munatha'ŋurunydja, bala yuluknha yukurranha ŋuli dhärranha dhuwala munathany'tja wäŋa. ");
INSERT INTO gnn_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Bala ŋayi Garrayyu Gunhu'yu djämana yolŋunhana; dhiṯthurrunanydja ŋayi munatha' yuluk, bala djäma yolŋukuŋalana, rumbalkuŋalana yolŋunhanydja djäma. Bala ŋayi Gunhu'yu bo'yurrunana ŋurikalayi yolŋuwala ŋurrukurruna, nhanukuŋuwaynha ŋayi walŋa wekaŋala, walŋamirrina wata, bo‐o‐oy' bitjarra ŋanya, bala yana ŋayi yolŋunydja ŋunhi walŋathinana, yolŋuthinana. ");
INSERT INTO gnn_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Bala ŋayi Gunhu'yu djäma gärulnha, dhika‐wala ya' dhimurru'ŋura, yäkunydja ŋunhi gärulnydja Yedan. Bala ŋayi nherraranydja Gunhu'yu ŋunhiyina yolŋunhanydja ŋunhi ŋayi djäma ŋanya, nherraranydja ŋayi ŋanya Gunhu'yu ŋunhimalayina gärullilina. ");
INSERT INTO gnn_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Liŋgu ŋunhiliyinydja gärulŋura ŋayi djäma guḻku'na mirithirrina dharpanydja, wiripu ga wiripu dharpa ḻatju'mirri dhika wal'ŋu, ga wiripu wiripu borummirri dharpa. Ga ŋunhimala gärullili ṉapuŋga'lilinydja ŋayi Gunhu'yu nherrara märrma' dharpa maṉḏanha, ganaŋ'thun yukurra, mayali'mirri dharpa maṉḏanha, gäna wal'ŋu dhärrana yukurrana ṉapuŋgany'tja. Waŋganydja ŋunhi dharpa yäku walŋa‐wekanhamirri, ga wiripunydja ŋunhi dharpa yäku marŋgi‐wekanhamirri, liŋgu ŋuriŋiyinydja marŋgi‐wekanhamirriyunydja borumdhu yurru yolŋu marŋgithirrina yätjku romgu ga ŋamakurru'wu. ");
INSERT INTO gnn_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Ga ŋunhili gärulŋura marrtjina ŋorrana gapu mayaŋ', ga ŋuliŋuruyi ŋuriŋi gapuyu ŋuli yukurranha walŋakunha ŋunhiyi gärulnha. Waṉḏinanydja ŋayi yukurrana ŋunhiyi mayaŋ'tja, yana liŋgu‐u‐u ga dhawaṯthurrunanydja ŋuliŋuru gärulŋuru, bala barrkuwatjthinanydja ḏämbumiriwyinana. ");
INSERT INTO gnn_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Waŋganydja ŋunhi mayaŋ' yäku Bitjun, yurru dhuwaliyi mayaŋ'tja yukurranha ŋuli waṉḏinya ḻiw'maranha wäŋakurru Yapilakurru. ");
INSERT INTO gnn_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Dhiyalaminydja wäŋaŋura ŋorra yukurra buthalakthinyara guṉḏa, biyapul wal'ŋu miḻŋ'‐miḻŋdhunara, ga wiripu guṉḏa miny'tji miku, biyapul wal'ŋu mel‐wiḏi'mirrina. ");
INSERT INTO gnn_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Ga wiripunydja mayaŋ' marrtji ŋorra ḻiw'marama bala wäŋakurru yäkukurru Gutjukurruna, yurru yäkunydja ŋunhiyi mayaŋ' Giyun. ");
INSERT INTO gnn_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Ga wiripunydja mayaŋ' yäku Daykurutjtja ŋorra marrtji ḻiw'marama Yatjiriyakurru wäŋakurru, yurru dhimurru'kurruna gali'kurru. Ga wiripunydja yäku ŋuliŋuruyi waka'ŋuru mayaŋ' Yipuraytiwuynha. ");
INSERT INTO gnn_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Yo. Garrayyu djäma ŋunhiyinydja wäŋa gärulmirrinydja yäku Yedandja, bala ŋayi nherrara ŋunhiyi ḏarramunhana ŋunhimalayina gärullilina, märr ŋayi yukurra yurru ŋuthanmarama djäma, ga djäka ŋurikiyi gärulwu. ");
INSERT INTO gnn_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Bala ŋayi Gunhu'yu ḻakaraŋalana nhanukala ŋurikalayinydja ḏarramuwala, romnha nherrara nhanŋu gatjarr'yunarawuna, ga bitjarra ŋayi Gunhu'yu waŋananydja gam'. “Bukmak dhuwala dhiyalami gärulŋuranydja borum ḻukanhamirri, ga ḻukanydja nhuma yurru bawala'mirriwuy yana. ");
INSERT INTO gnn_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Yurru waŋganybuynydja nhuma yurru yakana ḻuka; yakana nhuma yurru ḻuka ŋuliŋuruyinydja marŋgi‐wekanhamirriŋurunydja dharpaŋuru, ŋunhi ŋuli ŋuriŋiyinydja borumdhu ḻukanharayu marŋgi wekamana yolŋunha, bala yurru nhuma yolŋu walala marŋgithirrina yätjku romgu ga ŋamakurru'wu. Yo, ŋuli nhe ḻukanydja yurru ŋurikiy dharpawuy ŋunhi ŋarra yaka'yurruna, nhenydja yurru rakunydhirrina yanana, ŋuriŋi liŋgu waluyu.” Ga bitjarra ŋayi Gunhu'yu ḻakaraŋalanydja ŋurikalayi yolŋuwala. ");
INSERT INTO gnn_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Bala ŋayi Garray waŋana bitjarrana, “Yakana dhuwala ŋamakurru' waŋganygunydja yolŋuwu, ŋayi yukurra yurru nhina gänanydja. Ŋarra yurru djäma bämara' marrparaŋ'tja wiripuŋunha, ḻundu'mirriŋunha nhanŋu,” bitjarra. ");
INSERT INTO gnn_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Bala ŋayi Gunhu'yu dhiṯthurruna beŋuru munatha', bala djäma wäyinguŋalana wal'ŋu, bukmaknha yana wäyinnha malaŋunha, marrtjinyaramirrinha ga gaḻ'yunaramirrinha ga buṯthunaramirrinha. Djämanydja ŋayi walalanha Gunhu'yu warrpam'kuŋala yana, bala gäŋalana ŋurikala yolŋuwalana, märr ŋayi yurru nhäma'‐nhama, bala yäku nherraṉana marrtji, märr yurru wäyin malanha waŋga'‐waŋgany ŋunhi yäkumirri ŋurikiŋiyi ḏarramuwuŋu. ");
INSERT INTO gnn_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Bala ŋayi ŋuriŋi yäku nherrarana ḏarramuyu bukmaknhana wäyinnha, boḏinynha ga wakinŋunha, ga buṯthunamirrinha wäyinnha; yurru yaka ŋayi waŋganynhanydja ŋula maḻŋ'maraŋala ḻundu'mirriŋunha, marrparaŋ'tja nhanŋuway. ");
INSERT INTO gnn_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Bala ŋayi Gunhu'yu ŋunhi yolŋunhanydja buku‐dhumukkuŋalana wal'ŋu yakurrkuŋala, bala ŋayi Gunhu'yu ḏarramuwalanydja ŋurikala gali'ŋuru ŋaraka djaw'yurrunana binhdhaŋurunydja, bala yana buyuwuyukuŋala balayi barrwaṉ'tja ŋanya ŋunhiyi ḏarramunha. ");
INSERT INTO gnn_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Bala ŋayi Gunhu'yu djäma miyalknhana; ŋayi märraŋalanydja beŋuru ḏarramuwala gali'ŋuru binhdha, bala rumbalkuŋalana djäma, miyalknhana rumbal. Bala ŋayi gäŋalana ŋunhiyi miyalknhanydja bala ḏarramuwalana. ");
INSERT INTO gnn_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Bala ŋayi ŋuriŋi ḏarramuyunydja nhäŋalana ŋanya, bala yoraŋalana bitjarrana. “Dhuwala dhuḏi‐yapalany'tja wal'ŋu yolŋuna, ŋayaŋumirrina ga ḻiyamirrina, balanyarana bitjan ŋarra. Ŋayinydja dhuwala beŋuru ŋaraka ŋarrakala yana, ga barrwaṉ'tja ŋunha nhanŋu beŋuruyi yana, ŋarraku barrwaṉ. Dhuwalayina ŋarra yäku nherraranydja ŋanya miyalknhana, liŋgu Gunhu'yu ŋanya djaw'yurruna beŋuru ḏarramuwala.” ");
INSERT INTO gnn_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Yo, ŋunhi ŋayi yurru miyalknha ḏarramuyu märramanydja, ŋunhiyinydja maṉḏa yurru märrma'yirri waŋganynha rumbalnydja. Dhiyakuyina ŋayaŋuwu ŋayi yurru ḏarramuyu ganandja nhanŋuway ŋunhi ŋäṉḏi'mirriŋunha ga bäpa'mirriŋunha, bala ŋayi yurru dhambay‐manapanmirrina nhanukiyingalayŋuwala miyalkkalanydja, märr maṉḏa yurru waŋganynha yulŋunydja muŋbunumana. ");
INSERT INTO gnn_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Yo. Ŋunhiyi ŋurruŋu yolŋu maṉḏa ḏarramu ga miyalk, yaka maṉḏa ŋunhi girri'mirrinydja maṉḏa, warraŋul maṉḏa yana, yurru goramiriwnha maṉḏakuway maṉḏa yulŋunydja. ");
INSERT INTO gnn_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Yo, Gunhu'yu ŋunhi djäma bukmaknha wäyinnha malaŋunha ŋäthilinydja, yurru waŋganydja ŋunhi biyapulnha wal'ŋu marŋgina, mayali'‐guḻku'na, yurru yäkunydja ŋayi ŋunhi moḻ'ŋuna. Waŋganymirri ŋunhi miyalk marrtjina, bala ŋayinydja ŋunhi moḻ'ŋunydja bunanana nhanŋu ŋurikiyi miyalkku, bala waŋana ŋanya bitjarrana, dhä‐wirrka'yurrunanydja gam'. “Way, Gunhu'yu nhumalaŋgu ḻakaraŋala muka yulŋunydja? . . . yakaŋuwunydja ḻukanharawu dhiyaku borumgunydja malaŋuwu? . . . ŋunhi marrtji ŋorra dhiyalaŋumi gärulŋura?” bitjarra. ");
INSERT INTO gnn_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Bala ŋayinydja ŋunhi miyalktja waŋana bitjarra, “Dhuwala guḻku' malanha borum ḻukanharawunydja, ");
INSERT INTO gnn_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","yurru dhuwala waŋganydja dharpa ŋayi Gunhu' waŋana yaka'yurrunana, bitjarrana gam', ‘Ŋuli nhe yurru ḻuka dhipuŋuruyinydja borum dharpaŋuru, ga mulkanydja yana dharpanha, nhenydja yurru rakunydhirrina.’” ");
INSERT INTO gnn_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Ga ŋayinydja waŋana ŋunhi moḻ'ŋunydja bitjarra, “Yä‐ä‐äw! Djawukina warray ŋiniya?” bitjarra. “Yaka warray nhe yurru rakunydhirri. Ḻatju' warray borum dhuwalanydja. ");
INSERT INTO gnn_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Ŋayi Gunhu' nhumalaŋgu yaka'yurruna bitjarrayinydja ŋunhi, liŋgu ŋayi dharaŋan yukurra; balakurruyinydja ŋunhi nhe yurru ḻuka, nhenydja yurru marŋgithirrina, biyapulnha wal'ŋu djambatjthirri, bitjan yana liŋgu bitjan Gunhu' ŋayipi yana. Nhe yurru ḻukanydja, bala nhe yurru marŋgithirrina bukmakkuna romgu, ŋamakurru'wunydja romgu ga yätjkunydja.” Ga bitjarra ŋayi ŋuriŋiyi moḻ'ŋuyu ḻakaraŋalanydja. ");
INSERT INTO gnn_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Bala ŋayi ŋuriŋi miyalkthu rumbi'mirriyaŋalana nhäŋalanydja yukurrana‐a‐a ŋunhiyi borum, bala nhanukala ḻatju'yinana maŋutjiŋuranydja ŋunhiyi borum, ga wiripunydja ŋayi ḏukṯukthinana yana, märr ŋayi yurru djambatjthirrina wal'ŋu, buluna ḻiya. Bala ŋayi gulkthurrunana ŋunhiyi borumdja, bala ḻukanana. Ḻukananydja ŋayi, bala ŋayi wiripunydja wekaŋala nhanukalayŋuwu dhuway'mirriŋuwuna, bala ŋayinydja ḻukana. ");
INSERT INTO gnn_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Yo, ḻukananydja maṉḏa, märr‐yuḻkthurrunana Gunhu'nha ŋunhi ŋayi waŋana yaka'yurruna ḻukanharawu. Ga dhunupana yana dhurrwaraŋuru ḻukanhaŋurunydja maṉḏa marŋgithinana, bala yana dharaŋarana; nhänharaminanydja maṉḏa djolarra'na maṉḏa, bala goranana maṉḏakuway maṉḏa. Bala maṉḏa gulkthurrunana man'tjarrnha marwatnha, bala djäma girri'na ŋäkirrmaranhaminyarawuna maṉḏakuway maṉḏa. ");
INSERT INTO gnn_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Ga ŋulinyaramirriyu munhaku maṉḏa ŋäkula Gunhu'nha rirrakaynha, ŋayi marrtjina yukurrana ŋuliwitjarra gärulkurru. Ŋäkulanydja maṉḏa, bala waṉḏinana nhanukala, retjalilina djuḻuḻ'yurruna. ");
INSERT INTO gnn_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Yurru Garraynydja wäthurrunana nhanŋu ḏarramuwunydja, “Way, wanhaka dhika nhe yulŋunydja?” bitjarra. ");
INSERT INTO gnn_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Bala ŋayi ḏarramunydja buku‐wakmaraŋala waŋana bitjarra, “Dhuwala ŋarra ŋäkula nhuna rirrakaynydja, bala ŋarra barrarinana nhuŋu. Ŋarra waṉḏina djuḻuḻ'yurrunana nhokala, liŋgu djolarra'na ŋarra dhuwala yulŋunydja,” bitjarra. ");
INSERT INTO gnn_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","“Yolthu nhuna waŋana djolarra' ḻakaraŋalanydja?” bitjarra ŋayi Gunhu' waŋana ŋurikala ḏarramuwala. “Mak nhe dhuwala ŋunhiyi borum ḻukana, ŋunhi ŋarra nhuŋu waŋana yaka'yurruna ŋurikiyi.” ");
INSERT INTO gnn_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Bala ŋayinydja waŋana buku‐wakmaraŋala balanydja ŋunhiyi ḏarramunydja bitjarra, “Ŋuriŋiyi dhuwala miyalkthu ŋarraku wekaŋala, ŋunhi nhe djäma ŋanya ŋarraku. Ŋayi ŋarraku wekaŋalanydja, bala ŋarra ḻukanana,” bitjarra. ");
INSERT INTO gnn_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Ga bulu ŋayi waŋana Garray ŋunhi miyalknhana, “Nhäku nhe ŋunhi bitjarrayinydja?” bitjarra. Ga ŋayinydja maŋutji‐wulaŋala ŋanyana, “Ŋuruŋu dhuwala ŋarranha mayali'‐wilkthurruna moḻ'ŋuyu, bala ŋarra ḻukanana,” bitjarra. ");
INSERT INTO gnn_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Bala ŋayi Gunhu' waŋana moḻ'ŋunhana bitjarra gam'. “Ŋarranydja nhuna yurru dhuwala dhä‐ḏir'yunna, liŋgu nhe bitjarrayi yolŋunha, Nhepi yana nhina yukurra yurru warumukŋuranydja romŋura. Dhipuŋurunydja dhurrwaraŋuru nhe yurru djuryunna yana marrtji bala dhulmuyuna nhokalay nhe; ga ŋathanydja nhuŋu ḻukanharawunydja dhukun' yana. ");
INSERT INTO gnn_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Nhenydja ga dhäyka yolŋu yurru gunyambi'manydjina; nhokuŋu yo‐yuthu ga nhanukuŋunydja yo‐yuthu yurru yukurra bitjanna liŋgu bunharamirrina. Yurru yolŋuwalanydja nhanukalanydja mala‐wunharayu yurru muḻkurrnha nhuna binydjitjkuma, ga nhenydja ŋanya yurru ḻäwuma ḻuku warray.” Ga bitjarra ŋayi Gunhu' waŋana moḻ'ŋunhanydja. ");
INSERT INTO gnn_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Bala ŋayi bilyurruna Gunhu', ga waŋana miyalknhana, ŋayi ḻakaraŋalanydja bitjarra nhanŋu gam'. “Dhipuŋurunydja dhurrwaraŋuru nhenydja yurru galŋa‐yätjthirri rerriyu yothuwala gänharayu, Ga ŋuliwitjandhinydja ŋunhi yurru yothu dhawal‐wuyaŋirri, nhenydja yurru wirrkina wal'ŋu rirrikthun manapan. Nhe yurru djälthirri nhokalayŋuwu dhuway'mirriŋuwunydja, ga ŋayina yurru ŋurruŋydja nhuŋu.” ");
INSERT INTO gnn_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Ga ŋuliŋurunydja ŋayi Gunhu' waŋana ŋurikala ḏarramuwalana, bitjarrana gam'. “Nhenydja märraŋala warray nhuŋuway miyalknha dhäruk, bala ḻukana warray ŋunhiyi, ŋunhi ŋarra waŋana yaka'yurruna, yakaŋuwu ḻukanharawu. Liŋgu nhe bitjarrayinydja mäkiri'‐yarryurrunana ŋarrakalaŋuwu dhärukkuna, dhuwalanydja yurru wäŋa munathany'tja goḏuy‐wumana. Nhe yurru djämanydja mirithirrina wal'ŋu, bitjanna liŋguna yurru yukurra djäma ŋuthanmaranharawunydja ŋathawunydja, ");
INSERT INTO gnn_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","liŋgu nhäŋiniŋ'nha ga ŋula nhä ḏirriṯirri' mäypamirrina mulmuna yukurra yurru gurarrthirri munatha'ŋuranydja, ga ŋunha ḏiltjiwuynha ŋatha nhe yurru ḻukanydja. ");
INSERT INTO gnn_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Yo, djämanydja nhe yurru buku‐worr'mirriyuna, munathany'tja buḻŋu'kuma djäma, märr yurru ŋunhiliyi munatha'ŋura ŋatha malanha ŋuthan wal'ŋu. Djämanydja nhe yurru yukurra‐a‐a, yana liŋgu‐u‐u ga rakunydhirri, balayi munatha'yirriyi. Yo. Ŋarra nhuna djämanydja beŋuru munatha'ŋuru, ga balayi nhe yurru yulŋunydja munatha'yirrina.” Ga bitjarra ŋayi Gunhu' waŋananydja ḻakaraŋala, liŋgu yolŋu warray bitjarrayinydja ŋunhi barrkuwatjkunhamina Godkala, bala gärrinana yätjlilina romlili. ");
INSERT INTO gnn_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Bala ŋayi ḏarramuyunydja yäku‐nherrarana nhanŋuway miyalknhanydja Yepnha, liŋgu ŋayinydja ŋunhi ŋäṉḏi'mirriŋu bukmakkuna yolŋu'‐yulŋuwu ŋilimurruŋgu, dhiyakuna dhuwala yukurra nhina bukmakŋura wäŋaŋura, buku‐ḻiw'marama yana. ");
INSERT INTO gnn_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Ga ŋuliŋuruyinydja ŋayi Gunhu'yu bumara wäyin, bala yana märraŋalana barrwaṉ'tja, bala djäma girri'na maṉḏaku dhaḻ'yunminyarawuna, ŋäkirrmaranharawuna Yadamgu ga nhanukalayŋuwu miyalkkuna. ");
INSERT INTO gnn_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Ga ŋuliŋuruyinydja dhurrwaraŋuru Gunhu' waŋana bitjarra. “Yo, dhiyaŋunydja‐wala dhuwalayi ḏarramu marŋgina, balanyarana ŋayi bitjan ŋilimurru; marŋgina ŋayi ŋamakurru'wu romgu ga yätjku, liŋgu djarr'yurruna ŋayi ŋuriŋiyi yolŋuyu yätj yana rom. Bala dhipuŋurunydja dhurrwaraŋuru walala yurru yolŋu'‐yulŋu yakana nhina yukurra walŋamirriŋuranydja romŋura; yakana ŋayi yurru yolŋu goŋ‐djarryun, bala gulkthun borum dhipuŋuru walŋa‐wekanharamirriŋurunydja dharpaŋuru. Yakana yurru yolŋuyu walalay ḻuka ŋunhiyinydja borum, bala nhina yukurra walŋa‐weyindja, gupaḏalnydja wal'ŋu,” bitjarra ŋayi Gunhu'yu waŋananydja. ");
INSERT INTO gnn_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Bala ŋayi djuy'yurruna dhawaṯmaraŋalana ŋanya ŋunhiyi yolŋunha beŋuru walŋamirriŋurunydja gärulŋuru, ga ŋunhala gali'ŋurana ŋayi yurru yukurra djäma munathany'tja, ŋunhi ŋayi maḻŋ'thurruna beŋuruyi munatha'ŋuru. ");
INSERT INTO gnn_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Yo. Gunhu'yu gukuŋalana yolŋunhanydja maṉḏanha, dhawaṯmaraŋalana ŋuliŋuruyi gärulŋurunydja Yedanŋuru. Bala ŋayi Gunhu'yu nherrara djiwarr'wuynhana yolŋunha dhurrwaralili gärullili, gali'lili dhimurru'lilinydja, gunganharawuna ŋurikiyi gärulwunydja. Ŋayi yukurrana dhärrananydja ŋunhiyi djiwarr'wuynydja yolŋu goŋ‐yiki'mirrina, yurru yikiny'tja ŋunhi bitjan ŋäṉarrmirri gurthamirri, bitjarrana liŋguna yukurrana djaḻkarr'yurrunanydja bala ga lili, märr yurru yakana ŋula yol yolŋu marrtjinydja ŋuliwitjan; yakana yurru yolŋuyu galŋa‐yurrwuyun ŋunhiyi dharpanha walŋa‐wekanhamirrinhanydja. ");
INSERT INTO gnn_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Bala Yadamdhunydja Yepnha märraŋalana nhanŋuway miyalknhana, bala ŋayi yothu'mirriyinana, ga yothuny'tja nhanŋu dhawal‐wuyaŋina ŋunhi ḏarramu. Ga ŋayi Yeptja waŋana bitjarra, “Garrayyu ŋarranha guŋga'yurrunanydja, bala ŋarra gurrukaŋalana yothuny'tja ḏarramuna.” Bala ŋayi yäku nherrara ŋunhiyi yothu'nhanydja Gayinnha. ");
INSERT INTO gnn_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Ga yalalaŋumirriyunydja ŋayi biyapul gurrukaŋala yothu'nha, ga yäkunydja ŋayi ŋanya nherrara Waypul. Dhuwalayi yothu maṉḏa ŋuthara marrtjina wakindhinana, bala ŋayi ŋuli Waypulnydja djäka yukurranha wäyinguna walalaŋgu, ga ŋayi Gayindhunydja djäma yukurranha ŋuli ŋuthanmaranha ŋatha marrtjinya. ");
INSERT INTO gnn_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Waŋganymirriyunydja ŋayi Gayindhu gulkthun ŋatha ga borum malanha, bala gäma mundhurr wekama Garraywuna. ");
INSERT INTO gnn_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Ga ŋayi Waypulyunydja bitjandhi liŋgu gäma mundhurr Garraywu, yurru ŋayinydja gäma wäyin läm, ŋurruŋu maḻamarr ŋunhiyi wäyin dhawal‐wuyaŋinyaranydja. Bumaranydja ŋayi ŋunhiyi wäyinnha Waypulyu, bala batharana ŋunhi gal'ŋu yaḻmanga', mundhurrnydja Godku. Bala Garrayyunydja wirrkina ŋoy‐ŋamathinana märraŋala Waypulwuŋunydja mundhurr, ga ŋanyapinyay Waypulnha manapara. ");
INSERT INTO gnn_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Yurru ŋayi yaka Gayinnhanydja märraŋala, ga mundhurr nhanukuŋu ŋunhi, gonha'yurrunana nhäŋala ŋanyanydja, liŋgu yaka dhunupa ŋayi gäŋala Gayindhunydja. Bala ŋayinydja marrtjina Gayindja wirrkina ŋaramurryina, bena ŋurru‐yupthurrunanydja. ");
INSERT INTO gnn_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Bala ŋayi Garrayyunydja waŋanana ŋanya Gayinnha, “Nhäku warray nhe mari‐wunananydja? Nhäku nhe ŋurru‐yupthurrunanydja? ");
INSERT INTO gnn_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Ŋunhi nhe bini djäma ŋamathanha, rom‐dhunupayinya ŋuli ya', nhunanydja ŋarra bini bitjanayi liŋgu märranhayi. Ŋuli nhe yurru yakanydja rom‐dhunupayirri, ŋayi yukurra yätjtja galkunna nhuŋu, dhuwalana ya' galkina, mulkana nhuna yurru, liŋgu wirrkina ŋayi ŋunhiyi yätjtja nhuŋu ḏukṯuk ŋayathanharawu. Ma', nhenydja djuḻkmaraŋana yätjnha, märr ŋayi yurru yaka nhuŋu buŋgawayirri,” bitjarra ŋayi Garray waŋananydja. ");
INSERT INTO gnn_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Ŋuliŋurunydja dhurrwaraŋuru ŋayi Gayindhu waŋana nhanŋuway gutha'mirriŋunha bitjarra, “Way Waypul, ŋali maṉḏa marrtji ŋunhamala go, märr‐barrkulili,” bala yana maṉḏa marrtjinana. Ŋunhalanydja ŋayi mulkanana nhanŋuway gutha'mirriŋunhanydja Gayindhu, bala bumara murrkay'kuŋalana. ");
INSERT INTO gnn_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Bala Garrayyunydja waŋana ŋanya Gayinnha bitjarrana, “Way, wanhakana nhuŋu gutha'mirriŋunydja dhika?” Ga ŋayinydja buku‐ruŋiyinmarama Garraywu bitjanna, “Yo‐o‐o? Yaka warray ŋarra marŋgi nhanŋu. Yol dhuwala ŋarra yolŋunydja? . . . ŋarra ŋuli be gutha'mirriŋuwunydja djäka marrtji?” ");
INSERT INTO gnn_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Bala Garraynydja waŋana nhanukala Gayingala bitjarra, “Nhäku dhuwala nhe bumara nhuŋuway gutha'mirriŋunhanydja? Ŋarra yukurra ŋämana dhuwala gulaŋdja nhanŋu, wäthunna yukurra ŋarraku ŋulaŋuru munatha'ŋurunydja. ");
INSERT INTO gnn_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Nhuŋunydja yurru marina yukurra buna bitjanna liŋguna; galŋa‐yätjthirrina nhe yurru nhinanydja yukurra, liŋgu nhe gutha'mirriŋunha nhuŋuway nhe bumara rakunyguŋala. ");
INSERT INTO gnn_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Ŋunhi yurru nhe marrtji munatha' belama, dholkuma ŋatha malanha, yakana yurru dhiyalanydja gay' munatha'ŋuranydja ŋatha ŋuthan nhuŋu. Ga nhenydja yurru yukirriya yana marrtjiya bala ga lilina, wirwiryurra wäŋamiriwnha, wäŋanha ŋuparra.” ");
INSERT INTO gnn_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Bala Gayindja waŋana Garraywala bitjarrana, “Dhuwalanydja dhuwala ŋutu'na ŋanya dhä‐ḏir'yunara ŋiniya, ŋarranydja yurru rakunydhirrina, ");
INSERT INTO gnn_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","bili nhe ŋurrkaŋalana ŋarranha yarrkmaraŋalana. Wakinŋuyirrina ŋarra yurru, ga mulkuruna ŋarra yurru marrtji djingaryun, bala buma yurru rakunygumana ŋarranha ŋula yolthu yolŋuyunydja.” ");
INSERT INTO gnn_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Yurru ŋayi Garrayyunydja waŋana ŋanya bitjarra, “Bäyŋu nhuna yurru bumanydja ŋula yolthu.” Bala ŋayi Garrayyunydja gurrunhara yiŋarray'yunarana nhanukala nhanukuŋuway, märr yurru yakana ŋula yolthu bumanydja ŋanya. ");
INSERT INTO gnn_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Bala yana ŋayi Gayindhu gonha'yurrunana Garraynhanydja, dhawaṯthurrunana marrtjina ŋuliŋurunydja wäŋaŋuru. Marrtjinanydja ŋayi bala, dhut‐gay nhinana nhäyikayuna yäkulili, nhinananydja ŋayi Yedandhuna ŋunha gali'lili dhimurru'lilina. ");
INSERT INTO gnn_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Yo, ŋunhi ŋayi Godthu djäma ŋurruŋunha wal'ŋu yolŋunha Yadamnha yäkunha, ŋayi djämanydja ŋanya djan'kukuŋala yana dhika bitjarra yana bitjan ŋayipi God; ");
INSERT INTO gnn_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","ŋayi djämanydja ḏarramukuŋala ga dhäykakuŋala, bala yana ŋayi waŋanana maṉḏaku, “Ŋarrapi yurru nhumalanha dhika wal'ŋu yana goŋmirriyamanydja,” bitjarra. ");
INSERT INTO gnn_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Bala Yadam nhinananydja yukurrana dhuŋgarranydja ŋupara 130, ga ŋuliŋurunydja dhurrwaraŋuru Yadamgu biyapul walkurnha‐maḻŋ'thurruna, yurru ŋayi ŋunhi gäthu'mirriŋunydja nhanŋu ŋayipiyinyara djan'kuna dhika Yadamdhinyarana, ga yäku nherraranydja ŋayi ŋanya walkurnhanydja nhanŋuway Djap. ");
INSERT INTO gnn_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","5","Yadamdja mukthurrunaŋga yana yukurrana nhinana‐a‐a, yumurrkuny'tja nhanŋu marrtjina guḻku'thinana, ḏarramuwurrunydja ga dhäykawurrunydja, yana liŋgu‐u‐u wirrkina wal'ŋu ŋayi worruŋuthina, bala yana ŋayi rakunydhinana, dhuŋgarranydja nhanŋu Yadamgu 930‐na. ");
INSERT INTO gnn_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","8","Yadamgunydja ŋunhi walkur Djap ŋuthara wakindhina ḏarramuyinana, bala ŋayi walkurmirriyinana, ga yäku nherraranydja ŋayi ŋanya walkurnhanydja nhanŋuway Yenutj. Ga ŋuliŋuruyinydja bala guḻku'thinana walkurnydja nhanbala marrtjina, ḏarramuwurru ga dhäykawurru, yana liŋgu‐u‐u Djaptja marrtjina worruŋuyinana, bala yana ŋayi ḏalpamdhinana, dhuŋgarranydja nhanŋu Djapku 912‐nha. ");
INSERT INTO gnn_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","11","Bala ŋuliŋurunydja Yenutjkuna walkur maḻŋ'thurruna yäku Genan, ga wiripuwurru biyapul nhanŋu yumurrku', bala yana ŋayi rakunydhinana Yenutjtja, dhuŋgarranydja nhanŋu 905‐nha. ");
INSERT INTO gnn_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","14","Ga ŋayinydja Genandhunydja walkur‐märraŋala yäkunha Mayalalinhana, ga bitjarrayi yana liŋgu ŋayinydja miṯtji bumara; rakuny gay' ŋayinydja Genandja, dhuŋgarranydja nhanŋu 910‐nha. ");
INSERT INTO gnn_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","17","Bala walkurna nhanŋu walŋanydja nhinana yukurrana yäku Mayalalina, ga ŋayinydja walkur‐märraŋala yäkunha Djäritnha, ga bitjarra yana liŋgu wiripuwurrunhanydja ŋayi mala bumara yukurrana yumurrku'nha, yana liŋgu dhuŋgarra nhanŋu 895‐nha, bala yana ŋayi rakunydhinana. ");
INSERT INTO gnn_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","20","Ga nhanŋunydja Djäritkunydja walkur maḻŋ'thurruna yäku Yenuk ga wiripuwurru djamarrkuḻi', ga ŋayinydja rakunydhina, dhuŋgarra nhanŋunydja 962‐na. ");
INSERT INTO gnn_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","24","Ga nhanŋunydja Yenukkunydja maḻŋ'thurruna walkur ga Mathutjila yäku. Yenuktja yukurrana nhinana waŋganyŋura yana rrambaŋi Godkala, ga biyapul nhanŋu yumurrku' marrtjina maḻŋ'thurruna. Bitjarrana liŋguna yukurrana Yenuktja nhinana galkina yana rrambaŋina wal'ŋu Godkala rom‐dhunupana, yana liŋgu ga dhuŋgarra nhanŋu marrtjina mulkana 365‐nha, bala ŋayinydja marrtjina wiḏi' bitjarra, bili ŋayipina Godthuna ŋanya Yenuknha djaw'yurruna‐wala, bena gonhana. ");
INSERT INTO gnn_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","27","Bala ŋuliŋurunydja dhurrwaraŋuru nhanŋuna Mathutjilawuna walkur maḻŋ'thurruna yäku Lamiknha, ga bitjarrayi yana liŋgu wiripuwurru yumurrku' nhanŋunydja marrtjina maḻŋ'thurruna bala, ga ŋayinydja rakunydhina dhuŋgarranydja nhanŋu Mathutjilawu 969‐nha. ");
INSERT INTO gnn_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","31","Ga maḻŋ' gay' nhanŋu Lamikkunydja walkur, yäkunydja ŋayi Nowa, ga wiripuwurru biyapul nhanŋu yumurrku' maḻŋ'thurrunayi, bala yana ŋayi rakunydhinana, ga dhuŋgarranydja nhanŋu Lamikku 777‐nha. ");
INSERT INTO gnn_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Ga Nowanydja yukurrana nhinana‐a‐a, maḻŋ' gay' nhanŋunydja walkur walala ḻurrkun', yäku Djim ga Wäm ga Djaypip, yurru nhanŋunydja dhuŋgarra Nowawunydja ga 500‐nha. ");
INSERT INTO gnn_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","4","Yo. Yolŋunydja walala marrtjina malanydja dhaŋaŋdhinana, bala marrtjina barrkuwatjthinana dhikana buḻwaŋ'thurrunana wäŋalili ga wäŋalili, wiripuna ga wiripuna wäŋa mulkana, ga yumurrkuny'tja maḻŋ'thurruna marrtjina guḻku'thinana dhika, ḏarramu ga miyalk, ga dhäykawurrunydja ŋunhi maḻŋ'thurruna ŋanya dhika ḻatju'mirrina. Ga ŋuriŋi waŋarryu walalay nhäŋala yolŋu'‐yulŋunha wal'ŋu dhäykawurrunha, djana'mirri ḻakaraŋalana, mel‐ŋamathinana, bala walala marrtjina djarr'yurruna märra'‐marraŋalanydja walalaŋguway walala miyalknhana walalanha. Bala ŋuriŋi miyalkthunydja walalay gurrukaŋala yumurrku'nhana ŋuripa waŋarrwana walalambala, bala yana ŋunhi yumurrkuny'tja dhawal‐wuyaŋinana maḻŋ'thurruna marrtjina ŋutu'mirrina dhika ŋanya, ganydjarr motjmirrina. Yo, dhuwala walala ŋunhi waŋarrnydja walala ŋunhi walala yukurranha ŋuli nhinanha ŋunhala bala be wal'ŋu baman' birr', ga mukthun yana ŋilimurru ŋäma walalanha yukurra dhiyaŋunydja‐wala. Ga Godthunydja nhäŋala ŋunhi yolŋunha walalanha, yurru walala wirrkina yätjthinanydja, yakana ŋamathina nhanukala maŋutjiŋura, bala yana ŋayi waŋanharaminana bitjarrana, “Yakana yana yurru yolŋunydja weyin nhina walŋa dhiyala munatha'ŋuranydja gay'; walala yurru nhinanydja märr‐gurririna, 120‐na dhuŋgarra, bala yurru dhawar'yunna, rakunydhirrina yurru.” ");
INSERT INTO gnn_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Yo, Garrayyunydja nhäŋalana yukurrana yolŋunhanydja walalanha dhipalanydja munatha'lilinydja wäŋalili, yurru bukmaknha yolŋunydja romdja yätjthinana wirrkina; walalaŋguŋu guyaŋinyara djarrpi'na mirithirrina, ga bitjarrana liŋguna walala yukurrana djäma walalaŋgalaynha djälkurru, yätjnha dhika wal'ŋu ŋunhina ya'. ");
INSERT INTO gnn_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Garrayyunydja nhäŋala, bala yana wirrkina ŋoy‐yätjthinanydja, bala ŋayi waŋanana bitjarra, “Ŋarra bini ŋunhi yaka muka yolŋunhanydja djäma munatha'lilinydja. ");
INSERT INTO gnn_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Ŋarranydja yurru dhuwala rumbal‐winya'yunmaramana dhuwala yolŋunhanydja walalanha, warrpam' dhawar'maramana yurru yolŋunha ga wäyinnhana manapan ga ŋula nhä wiripu malanha; warrpam' yurru dhawar'marama buwayakkumana.” ");
INSERT INTO gnn_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Yo, warrpam'nha yolŋunydja rom yätjthina, bukmaknha yana dhika, yurru waŋganynha yolŋu yukurrana nhinana rom‐dhunupanydja ŋamathinanydja maŋutjiŋura Garraywalanydja, waŋganynha yolŋu yäku Nowana. ");
INSERT INTO gnn_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","10","Yo, Nowanydja ŋunhi yolŋu rom‐ŋamakurru' yana, nhinananydja ŋayi yukurrana waŋganyŋura yana Godkala, ga yumurrkuny'tja nhanŋu Nowawu ḻurrkun', yäkunydja walala Djim ga Wäm ga Djaypip. ");
INSERT INTO gnn_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Ga wiripu‐guḻkuny'tja yolŋu walala gatjpaḻ'yurruna ŋapana‐wekanharamina Garraywala, yätjnha rom djäma goḏuy‐wunharaminana marrtjina, walalaŋgu romdja waŋganynha yana ŋunhina bili yätjnha wal'ŋu bitjanna liŋgu, bunharaminyana murrkay'kunhaminyana yanana. ");
INSERT INTO gnn_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Yo, Garrayyu Godthu nhäŋalana yolŋunhanydja walalanha dhipala munatha'lilinydja, ");
INSERT INTO gnn_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","bala yana ŋayi ḻakaraŋala Nowawu, waŋana ŋanya bitjarra, “Ŋarranydja yurru dhuwala rumbal‐winya'yunmarama buwayakkumana dhuwali ya' yolŋunhanydja walalanha, liŋgu walala yukurra goḏuy‐wunhamirri warray, ga marinydja buḻwaŋ'thurrunana bawala'mirrikurru wäŋakurru buku‐ḻiw'marama. ");
INSERT INTO gnn_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","17","Bukmaknha yurru murrmurryundja yolŋunydja miṯtji, yurru nhepina ga nhuŋu miyalknha ga yumurrku' nhuŋu ga nhokalaŋuwu yumurrku'wu dhäykawurru, nhumana yurru walŋathirrinydja. Gatjuy nhe yurru mitjiyana dhuḻ'yurranydja nhumalaŋguway; dhuḻ'yurranydja marrtjiya nhe yurru yindikuŋa wal'ŋu yana, ga wirrki wuṉḏaŋarrkuŋanydja, ga gulkthu'‐gulkthunmaraŋa dhaḻakarrnydja malanha bala. Gungaŋanydja gapuŋuru gärrinyaŋuru nhäwithu gonydjuy'yu, liŋgu ŋarra yurru djuy'yun waltjaṉ, ŋutu'na waltjaṉ dhipali‐wala munatha'lili; warrpam' yurru nhä malanha dhä‐monygumana, bala yurru murrmurryunna marrtji ŋunhala djinawa' gapuŋurana. ");
INSERT INTO gnn_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Nhumapina yumurrku'na yana nhuŋu yurru walŋanydja. ");
INSERT INTO gnn_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","Ga wäyinnhanydja nhe yurru märra'‐marraŋayi dhipaliyi wapmaraŋa marthaŋalili, miyalknha ga ḏarramunha, wiripunha ga wiripunha wäyinnha malaŋunha, märr walalanydja yurru walŋathirriyi. ");
INSERT INTO gnn_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Ga ŋathanydja walalaŋgu märraŋayi dhipali marthaŋalili.” Bitjarra Godthu ḻakaraŋala Nowawalanydja. ");
INSERT INTO gnn_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Bala yana Nowayunydja djämana‐wala yana dhunupana, bitjarra yana liŋgu ŋunhi God waŋana nhanukala. ");
INSERT INTO gnn_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","4","Dhuḻ'yurrunana‐a‐a ŋayi marrtjina bala Nowayu, yana liŋgu‐u‐u marthaŋa ŋunhi warrpam'nha ŋamathinana. Bala yana ŋuliŋurunydja Garrayyu waŋana ŋanya Nowanha bitjarrana, “Gatjuy nhuma gärriyana‐wala dhipali marthaŋalilinydja, nhumapi yana dhuwali bili walala yurru walŋathirrinydja, liŋgu nhepina waŋganynha ŋuli yukurra nhina ŋamathamanydja wal'ŋu. Wäyinnhanydja walalanha wapmaraŋana yukirriya, gärrinyamaraŋana walalanha, liŋgu galkina ŋarra yurru djuy'yunna waltjaṉdja, ga warrpam' yurru nhä malanha murrmurryundja marrtji.” ");
INSERT INTO gnn_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","16","Yo, ŋayi Nowayu djämanydja warrpam' yana dhawar'maraŋala nhaltjarra Godthu nhanŋu ḻakaraŋala. Nhanŋu Nowawu dhuŋgarranydja 600‐nha ŋulinyaramirriyu ŋunhi walala yukurrana wapthurrunana marthaŋalilina. Dhark‐dharkthinanydja walala bukmak yana, Nowa ga miyalk nhanŋu ga yumurrku' nhanbala, ga wiripuna ga wiripuna wäyindja malanha. Wapthurrunanydja walala yukurrana, dhawar'yurrunanydja, bala Godthunydja ŋayipina goŋdhu dhaḻ'yurruna dhurrwara ŋunhi marthaŋanydja, wuṉḏaŋarrkuŋalana wal'ŋu yana. Nhinanydja walala yukurra ŋunhili djinawa' marthaŋaŋuranydja walu ŋupanna‐a‐a, yana liŋgu‐u‐u ga 7 walu djuḻkthurruna, bala ŋayinydja marrtjina djiwarrny'tja ŋunha ḻapthurrunana, yurru ŋayi waltjaṉdhu djurrŋguḻ'yurrunana gay, ŋutu'na dhika waltjaṉ bunana walalaŋgu. ");
INSERT INTO gnn_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","23","Yo, waltjaṉdhunydja ŋuriŋinydja dharyurrunana marrtjina‐a‐a, yana liŋgu ga gapunydja marrtjina ŋanbaw'yurrunana dharyunara, ga ŋurukuy munatha'wuy ŋamuny'tjurruna marrtjina. Mukthurrunaŋga yana dharyurruna‐a‐a, munha ŋupara ga walu ŋupara weyinnha dharyurruna, yana warray dhuwala ga 40 walu mulkana, ga gapunydja marrtjina dhaŋaŋdhinana garrwarthinana, bena wirrkina monyguŋalana wäŋanydja ŋarakanydja, warrpam'nha dhikana guḻwuḻyurrunana. Ga bukmaknha nhä malanha liŋguna murrmurryurrunana marrtjina, yolŋu ga wäyin ga be nhä malanha warrpam'nha dhiŋgaŋala, ŋurru‐ḻupthurrunana. Yurru ŋayinydja ŋunhi marthaŋanydja mukthurruna warray yukurrana bungaŋala, ŋurr'yurruna warray; ŋunhina yana liŋgu walŋathinanydja, Nowa ga wiripuwurru ŋunhi walala ŋunha marthaŋaŋura nhinana yukurrana, walalana walŋamirrinydja. ");
INSERT INTO gnn_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Ga gapunydja ŋunhi yukurrana bänina mukthurruna waŋgany rulu ŋaḻindinydja ŋupara, yakaŋga yana nyimdhurrunanydja. ");
INSERT INTO gnn_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","4","Yurru mukthurruna yana Godthunydja yukurrana guyaŋina ŋanya Nowanha, yaka ŋayi meṉguŋala ŋanya, bala yana Godthu djuy'yurruna watana bo'yunarawu marrtjinyarawu, djaw'yunarawu gapuwu, bala yana marrtjina gapunydja ŋunha yir'yurruna, nyimdhurrunana marrtjina bala. Mukthurrunaŋga yana nyimdhurruna marrtjina bala‐a‐a gapunydja ŋunhi, yana liŋgu‐u‐u, ga marthaŋa marrtjina baṉḏany'thina, bala djingaryurrunana yukurrana ŋunhalana bäyma bukuŋurana, yäkunydja ŋunhiyi buku Yararat. ");
INSERT INTO gnn_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","7","Bulnhaŋga yana marrtjina gapunydja nyimdhurruna, ga Nowanydja galkurruna yana yukurrana, yana liŋgu ga buku'‐wukunydja wäŋanydja malanha maḻŋ'thu‐maḻŋ'thurrunana marrtjina. Nhäŋa'‐nhaŋalanydja ŋayi buku malanha, bala märraŋala wäyinnha gaḻkarriŋunhana, bala yana djuy'yurrunana buṯthunmaraŋalana wäŋawuna nhänharawu. Bala ŋayi buṯthurruna‐a‐a yukurrana, nhäŋala marrtjina, ga yakana ŋayi roŋiyinanydja; mukthurrunaŋga yana buṯthurruna yukurrana ŋulaŋga yana ya' barrkukurru, yana liŋgu ga wäŋa baṉḏanydhina. ");
INSERT INTO gnn_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Bala ŋayi Nowayu ŋawatthurruna wiripuna wäyin murryil'nhana, ga ŋanyana djuy'yurruna nhänharawu marrtjinyarawu wäŋawu. ");
INSERT INTO gnn_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Buṯthurrunanydja ŋayi, marrtjina nhäŋala ḻiw'maraŋala‐a‐a, ga yakana ŋula maḻŋ'maraŋala wäŋa nhanŋuway nhinanharawu, bala ŋayi liliyi roŋiyina goŋlili Nowawala. ");
INSERT INTO gnn_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","11","Nowanydja bulnha galkurruna yukurrana 7 walunydja ŋupara, ga djuḻkmaraŋala, bala ŋayi biyapul djuy'yurruna ŋanya murryil'nha. Buṯthurrunana nhinana ŋayi bala‐a‐a, dharr‐way nhäŋala dharpa man'tjarr, bala ŋayi buṯthurruna lili, gulk gay' gulkthurruna ŋunhiyi man'tjarrnydja, bala balayi buṯthurruna gäŋala nhinana Nowawalana. Bala ŋayi Nowanydja marŋgithinana ŋunhi gapunydja marrtjina nyimdhurrunana. ");
INSERT INTO gnn_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Bitjarrayi yana liŋgu ŋayi galkurruna märr‐gurriri, ga yanayi ŋayi djuy'yurruna ŋunhiyi murryil'nha; buṯ gay' ŋayinydja buṯthurruna gupaḏalnha-yana‐wala, ga yakana ŋayi roŋiyinanydja lili. ");
INSERT INTO gnn_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Yo, marthaŋaŋuranydja walala yukurrana nhinana galki bini waŋganynha dhuŋgarra mulkanha, bala ŋayi Nowayunydja marrtjina ḻapmaraŋalana dhurrwaranydja ŋunhi marthaŋa, nhäŋala wäŋanydja munathany'tja baṉḏanydhinyarana marrtjinyara. ");
INSERT INTO gnn_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Yanayi walala galkurruna nhinana waŋgany ŋaḻindi, bay ŋayipi ga yuwalkkuŋala wäŋa warrpam' baṉḏanydhina. ");
INSERT INTO gnn_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Bala yana Godtja waŋana Nowawala bitjarra, ");
INSERT INTO gnn_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","17","“Gatjuy nhuma dhawa‐yawaṯthurrana dhipuŋuru marthaŋaŋurunydja, nhuma yolŋu walala ga dhuwali wäyin malanha, märr yurru wäyindja walala yana marrtji buḻwaŋ'thunna, malana guwar‐yalkthunmirri guḻku'kumana, märr yurru wäŋanydja monyguma warrpam' wäyindhu biyapul.” ");
INSERT INTO gnn_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","19","Bala walala yukurrana dhawa‐yawaṯthurrunana Nowanydja ga nhanŋu miyalk ga yumurrku' maṉḏaku ga walalaŋgu miyalk walala, ga bukmak wäyin, gaḻ'yunaramirri ga marrtjinyaramirri ga buṯthunaramirri; dhawa‐yawaṯthurrunana walala marrtjina ŋulaŋuru marthaŋaŋurunydja, warrpam'nha yana. ");
INSERT INTO gnn_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Bala ŋuliŋurunydja ŋayi Nowayunydja guṉḏana ŋal'‐ŋalmaraŋala barŋguŋala, dhaŋalkuŋala, bala ŋayi wäyinnhana walalanha bumara, bala batha'‐batharana ŋunhimalayi barŋlilinydja, mundhurrnha wekaŋala Garraywu. ");
INSERT INTO gnn_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","22","Bala ŋayi ŋawululny'tja ṉoluŋdhinana marrtjina, buŋgandja garrwarthina, yurru ŋayi Garraynydja wirrkina goŋmirriyina nhäŋala ŋoy‐ŋamathinana, bala ŋayi waŋanana, “Liŋguna ŋarra marŋgina yolŋuwunydja ŋayaŋuwu, ŋunhi walala rom‐mäypathina beŋuru yana yutjuwaḻa'ŋuru, yurru yakana ŋarra biyapulnydja yurru buwayakkuma buma yolŋu'‐yulŋunha. Yo, wäŋanydja dhuwala djingaryun yukurra yurru ŋamathirrina yana; waluna ga munhana yurru, ga gawatha'yirri yurru ga rarranhdharr'yirri yurru, yana liŋgu ga buku yurru ŋunha mulka, bala dhawar'yunna yurru wäŋanydja.” ");
INSERT INTO gnn_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Ŋuliŋurunydja God waŋana goŋmirriyaŋalana Nowanha ga nhanŋu ḻurrkun'nha gäthu'mirriŋunha walalanha, waŋananydja ŋayi Garray bitjarra gam' walalaŋgu, “Ŋarrapi yurru nhumalanha goŋmirriyamanydja, märr nhuma yurru waka'‐yalkthunmirri yumurrku'nha, biyapul mala dhaŋaŋgunhamirri, barrku'‐barrkuwatjthirri marrtji yurru wäŋalili ga wäŋalili, buku‐ḻiw'marama wäŋakurrunydja. ");
INSERT INTO gnn_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Nhumapi yurru dhuwali walala wäyingunydja malaŋuwu buŋgawa, walala yurru barrarirrinydja nhumalaŋgu, ga nhumalaŋgalayi goŋŋura yana yurru dhuwala wäyindja walala nhina. ");
INSERT INTO gnn_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Nhuma yurru ḻukiya wäyinnhanydja ŋanak, ga ŋunha ŋatha ga borum, dhuwala nhumalaŋgu ḻukanharawunydja. ");
INSERT INTO gnn_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Ga ŋunhi nhe yurru wäyinnha wutthun, ŋäthilinydja nhe yurru gulaŋ ḻarrmaraŋa baṉḏany'kuŋanydja, ga yurruna ḻukiyanydja; yakana yurru nhuma gulaŋdja ḻuka, liŋgu gulaŋdja ŋunhi walŋa muka. ");
INSERT INTO gnn_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","6","“Ŋuli yurru ŋayi yolŋuyu buma murrkay'kumanydja yolŋunha, ŋunhiyinhanydja yolŋunha yurru murrkay'‐bunharamirrinhanydja bumayi yana murrkay'kumayi, ga ŋuli yurru wäyindhunydja buma yolŋunhanydja, bala wäyinnhanydja nhuma yurru bumayi yana rakunygumayi, liŋgu ŋunhiyinydja Godthu djäma yolŋunhanydja mali bitjarra bitjan ŋayipi yana; yakana ŋuli yolŋunhanydja buŋu murrkay'kuŋunydja yolŋuyunydja. ");
INSERT INTO gnn_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","“Yo, nhuma yolŋunydja walala miṯtji‐guḻku'thiyana, barrkuwatjthiyana biyakana yanana, warrpam'thurrana gungaŋa dhuwala munathany'tja wäŋanha, birrka'mirrina.” ");
INSERT INTO gnn_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Ga ŋuliŋurunydja Godthu waŋana Nowanha ga gutha'mirriŋunha walalanha Nowawu bitjarra, ");
INSERT INTO gnn_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","10","“Ŋarranydja yukurra dhuwala dhawu'‐nherraṉmirri nhumalaŋgu yolŋuwu ga wäyingu, bukmakku yana ŋuriki ŋunhi ŋarra walŋakuŋala ŋuriŋiyi marthaŋayu, ");
INSERT INTO gnn_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","dhuwala dhäruktja gay' ŋarra yukurra nherraṉna. Yakana yurru ŋarra biyapulnydja gapuyu ga waltjaṉdhu buwayakkuma bukmaknha ŋunhi yukurra nhä malanha nhina walŋamirri dhuwali munatha'ŋura. ");
INSERT INTO gnn_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","13","Ŋarra yukurra yurru djärina nherraṉdja nhumalanha marŋgikumanydja, ŋayi yukurra yurru dhärranydja waŋupini'ŋura, yana guyaŋinyamirriyama yurru nhumalanha, ŋunhi ŋarra dhawu'‐nherrara nhumalaŋgu, liŋgu ŋarrakuŋunydja dhawu'‐nherraṉminyarawuy yurru djingaryun gupaḏalnha‐wala yana. ");
INSERT INTO gnn_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","16","Ga ŋarranydja yurru nhäma ŋunhi djärinydja, bala ŋarra yurru guyaŋirrina ŋarrakuŋuway dhawu'‐nherraṉaranydja ŋunhi; yakana biyapulnydja yurru ŋarra bukmaknha yolŋunha buwayakkuma gapuyu ga waltjaṉdhu.” ");
INSERT INTO gnn_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Ŋe, bala yuwalkthi dhuwala, djäriyunydja ŋuli yukurra ḏämbu‐ḻaymarama Godnha dhäruk ŋunhi ŋayipi wal'ŋu nherraṉmina. ");
INSERT INTO gnn_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","19","Yo, dhuwala walala Nowawu djamarrkuḻiny'tja yäku gam', Djim, Wäm, ga Djaypip, ga dhiyakuŋunydja walalaŋguŋu mala‐bunhara bukmaknha yolŋu'‐yulŋu ŋunhi yukurra nhina dhiyala munatha'ŋura buku‐ḻiw'marama dhika. ");
INSERT INTO gnn_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Ŋunhi walala walma'‐walmananydja ŋuliŋuru marthaŋaŋurunydja, bala ŋayinydja Nowayunydja dholkuŋala borum wuḻuymu'yinyarana, bala ŋayi djämanydja weyika' ŋuliŋuru borumŋuru ga ŋänitji'na. ");
INSERT INTO gnn_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Ŋuliŋurunydja ŋayi ḻukanana yukurrana Nowayu, yana liŋgu ga leŋu ŋayi ŋuriŋiyi ŋänitji'yu, bala ŋorranana yukurrana buṉbuŋurana ḏalwaḏalwa'ŋura warraŋulnha, girri'miriwnha. ");
INSERT INTO gnn_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ŋayi Wämdhu nhäŋalanydja ŋanya, bala yana marrtjina ga ḻakaraŋala wäwa'mirriŋuwana maṉḏapala, ");
INSERT INTO gnn_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","bala ŋuriŋiyi märrma'yu maṉḏa yana märraŋala ŋunhi girriny'tja Djimdhu ga Djaypipthu, bala maṉḏa marrtjinanydja dhuḏi'thuna, bala yana bäpa'mirriŋunhanydja ŋäkirrmaraŋalana maṉḏakuway ŋuriŋi girri'yuna; yakana maṉḏa ŋula nhäŋala ŋanya ŋunhimala djolarra'lilinydja. ");
INSERT INTO gnn_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","28","Ga ŋunhi ŋayi gaŋgathina yakurrŋurunydja Nowa, leŋuŋurunydja ŋunhi, bala yana ŋayi waŋana dhäruknha wekanhamina goŋmirriyaŋala maṉḏanha Djimnha ga Djaypipnha, yurru ŋanya Wämnha yaka warray goŋmirriyaŋalanydja ŋayi waŋana, ŋayinydja yurru Wämdja djämamirri yana maṉḏaku wäwa'mirriŋuwu maṉḏaku ŋurikiyi. ");
INSERT INTO gnn_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Yo, nhinananydja ŋayi yukurrana Nowa‐a‐a, ga worruŋuyina, bala ŋayi ŋuliŋurunydja dhawar'yurrunana 950‐na dhuŋgarranydja. ");
INSERT INTO gnn_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","32","Yo, Nowawala ḻurrkun'thu gäthu'mirriŋuyu walalay miṯtji‐bumarana yukurrana yumurrku'nha walalaŋguway, yana liŋgu walalaŋgala yumurrku'yunydja mala‐bumara, ga walalaŋgalanydja yumurrku'yu ga bitjarra yana liŋgu mala‐bumara, weyin‐märraŋalana bitjarrana bili, bitjarrana bili, yana liŋgu ga gaŋdhurruna miṯtji yolŋu walala, malana ga malana ga malana yolŋunydja walala nhinana yukurrana ŋulinyaramirriyu, ga bukmaknha yolŋu'‐yulŋu ŋunhi yukurra nhina dhuwala ŋarakaŋura buku‐ḻiw'marama nhanukuŋuway Nowawuŋu malanydja bunhara yana. ");
INSERT INTO gnn_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Ga ŋulinyaramirriyunydja ŋäthilinydja bukmak ŋunhi yolŋu walala ŋuli yukurranha waŋanha waŋganygurru yana dhäruktja, ");
INSERT INTO gnn_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","ga nhinanhanydja walala yukurranha wäŋaŋuranydja balkuwarra'ŋura, baṉarra'ŋura yana wäŋaŋura, ŋunhala Bapilun. ");
INSERT INTO gnn_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","4","Walala waŋanharaminanydja, walala yurru nhina ŋunhili bili wäŋaŋura mukthunna, waŋgany yana mala: bitjarrana walala waŋanhaminanydja gam', “Ŋilimurrunydja yurru ga dhiyalana yukurra nhina. Gul' ŋilimurru dhoḻuna dhiṯthun, bala ŋomaṉna wuṉḏaŋarrkuma gurthayuna, märr ŋilimurru dhuḻ'yun yurru wäŋana ŋilimurruŋguway dhiyala. Ŋilimurru yurru dhuḻ'yundja buṉbu dhiŋgikuma wal'ŋu yana, be‐wala weyinguma yurru, märr yurru dhanu'yun ŋunha wal'ŋu djiwarrny'tja wäŋa; dhiyaŋunydja ŋilimurru yurru yäkumirrina walala yolŋu'‐yulŋu, yindithirrina wal'ŋu yurru mala, märr ŋilimurru yaka muka barrkuwatjthirrinydja wäŋalili malanyŋulili.” Bitjarrana walala waŋanharaminanydja, bala yana walala ŋurru‐yirr'yurruna djämana, dhuḻ'yurrunana marrtjina. ");
INSERT INTO gnn_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Yo, Garrayyunydja Gunhu'yu nhäma yukurra walalanha, ŋunhi walala marrtji dhuḻ'yun walalaŋguway wäŋa malanha ŋunhimala, ga biyapul ŋunhi yindi buṉbu walala marrtji dhuḻ'yun weyinguma. ");
INSERT INTO gnn_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Ŋe, Garrayyunydja nhäma yukurra, bala yana waŋa bitjanna, “Yolŋunydja walala yukurra dhuwala nhina waŋgany yana mala, ga waŋgany yana dhäruktja. Ŋuli walala yurru bitjandja liŋgu waŋganyŋuranydja nhina yukurra, waŋganydja mala, galki walala yurru marŋgithirrina, bala yurru walala ŋula nhä djämana ŋunhi walalawuy yurru nhäku ŋula ḏukṯukthirri. ");
INSERT INTO gnn_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Ŋarra yurru dhäruktja djambina gulk‐gulkthunna gam' walalanha, barrkuwatjkumana; walala waŋanydja yukurra yurru wiripuna ga wiripuna dhäruktja, märr walala yurru ŋäma dhäruktja ŋamunharamirrina.” Bitjarra ŋayi Godthu waŋananydja. ");
INSERT INTO gnn_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Ga bitjarrayi ŋayipi Godthu yana barrkuwatjkuŋalanydja marrtjina yolŋunha walalanha wäŋalili ga wäŋalili dhika, wiripulilina ga wiripulilina. Ḏaḏawyurrunana walala dhuḻ'yunaraŋuru buṉbuŋuru ŋuliŋuruyinydja, bala yana barrkuwatjthinana marrtjina dhika, wäŋgaŋalana yukurrana. ");
INSERT INTO gnn_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Ga yäkunydja ŋayi ŋunhiyi wäŋa Bapilun, liŋgu ŋunhalayinydja wäŋaŋura Garrayyu djambi walalanha dhäruk malalili ga malalili ga malalili, yurruna yolŋunydja walala buḻwaŋ'thurruna dhika wäŋakurru buku‐ḻiw'maraŋalanydja. ");
INSERT INTO gnn_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","30","Guḻku'na dhuŋgarranydja marrtjina djuḻk‐djuḻkmaraŋala‐a‐a, maḻŋ' gay' Dera yäku yolŋu ŋulinyaramirriyu, yurru ŋayi ŋunhi yarraṯaŋurunydja Djimgala, ŋurikala ŋunhi ŋayi Nowawu gäthu'mirriŋu. Ga nhanŋu Derawu walkurnydja ḻurrkun', dhuwala walala yäkunydja Yipuram ga Näyu ga Yaran. Yo, ŋulinyaramirriyunydjayi Dera ga nhanŋu gäthu'mirriŋu walala ŋunhi ḻurrkun' nhinananydja walala yukurrana nhäyika yäkuŋura wäŋaŋura ŋunhala Wo. Bala yana Yipuramdhunydja märraŋala dhäykanhana yäkunha Saraynha, yurru ŋuriŋiyi Sarayyu yaka ŋula yothunhanydja gurrukaŋala, yothumiriw yana yukurrana ŋayi nhinana. Ga nhanŋu Yarangunydja maḻŋ'thurruna walkur yäku Lot, ga ŋuliŋurunydja dhurrwaraŋuru bala ŋayi Yarandja rakunydhina ŋunhiliyina Wona wäŋaŋura. ");
INSERT INTO gnn_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","32","Wiripunydja ŋayi waŋa Dera nhanŋuway gäthu'mirriŋunha Yipuramnha bitjan gam', “Gul' ŋilimurru marrtjina ŋi' . . . nhäyikalili Gaynanlilina, ŋilimurru ŋunhalana nhina yukurra yurru.” Bala yana yuwalkthi walala gonha'yurruna ŋunhiyinydja wäŋa Wonydja, Derayu, ga nhanukala gäthu'mirriŋuyu Yipuramdhu ga miyalkthu nhanukala Sarayyu, ga wiripunydja Lot malthurruna walalaŋgu. Wäŋgaŋalana yukurrana walala‐a‐a, wäŋana ŋunhi ŋupara‐a‐a, yana liŋgu ga wäŋa ŋayathaŋala Yaranbuy, nhanbalaynha ŋunhi Derawuna nininyŋuna wal'ŋu wäŋa, ga ŋunhala walala gandarrŋura nhinananydja. Dhut‐gay nhinanana walala yukurrana ŋunhiliyina wäŋaŋura märr‐weyin muka, yana liŋgu‐u‐u ga Dera rakunydhina ŋunhili bäyma Yaran, ga dhuŋgarranydja ŋayi ŋunhi rakunydhinanydja 200‐thu ga 5‐thuna. ");
INSERT INTO gnn_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Yo, nhinananydja walala yukurrana ŋunhi wäŋaŋura Yarandja, bala ŋayi ŋuliŋurunydja God waŋana nhanukala ŋurikala Yipuramgalanydja, ŋuliŋuruyina dhäŋuru ŋunhi nhanŋu bäpa'mirriŋu ŋunhili rakunydhina worruŋu ŋunhi, bala ŋayi waŋananydja nhanukala bitjarrana God. “Gonha'yurrana dhuwaliyinydja nhuŋuway nhe wäŋanydja, ga gurruṯu'mirrinhanydja nhuŋuway, ga nhä malanha nhokalaŋuwu bäpa'mirriŋuwu, bala marrtjiya ŋunhana ŋunhi ŋarra yurru nhuŋu milkuma. ");
INSERT INTO gnn_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Ga biyapul ŋarra yurru wekama nhuŋu yumurrkuny'tja guḻku'kumayi, märr nhuŋu yurru malanydja ŋurruŋuna yukurra dhärra yurru. Ŋarranydja yurru nhuna gäma yukurra ḻatju'kuma wal'ŋu, bala nhe yurru ḻukunydjana yolŋu wal'ŋu, ga yäkunydja nhe yurru bathalana wal'ŋu garrwarnha yana. ");
INSERT INTO gnn_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Balakurruyinydja nhokalaŋukurrunydja ŋarra yurru goŋmirriyamana wiripu‐guḻku'nhanydja. Ga ŋunhi yurru wiripuŋuyu bäpurru'yu malaŋuyu goŋmirriyama wal'ŋu yukurra nhumalanha yurru, ŋarranydja yurru bitjandhi liŋgu yana goŋmirriyamayi walalanhanydja; ga ŋuli yurru bäpurru'yu wiripuŋuyu malayu buku‐nherraṉ ŋaŋ'ŋaŋdhun yukurra nhumalanha, ŋarranydja yurru bitjandhiyi bili buku‐nherraṉdhi ŋaŋ'ŋaŋdhun walalanhanydja. Yo, bukmaknhana bäpurru'nha ŋarra yurru yukurra goŋmirriyamanydja nhumalaŋgalaŋukurrunydja.” Bitjarra ŋayi Godthu waŋana dhawu'mirriyaŋalanydja Yipuramnha. ");
INSERT INTO gnn_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Bala ŋayi Yipuramdhunydja dhäruknha yana märraŋala Garraynha. Bala ŋayi yana gonha'yurrunana wäŋa ŋunhiyi Yaranbuynydja, bala yana marrtjinana, ga dhuŋgarranydja ŋayi ŋunhi Yipuramdja 75‐nha. ");
INSERT INTO gnn_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Yo, märraŋalanydja ŋayi miyalknhana nhanŋuway Saraynhana, ga Lotnhana nhanukalaŋuwu gutha'mirriŋuwuna gäthu'mirriŋunha, ga bukmak nhä malanha nhanŋu guḻku'na, wäyin malanha ga djämamirri walala guḻku'na, bala walala ḻaw'yurrunana, marrtjina bala wäŋalili Gaynanlilina yäkulili. ");
INSERT INTO gnn_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Yo, marrtjinanydja walala yukurrana‐a‐a, baṯ‐gay mulkana ŋunhiyinydja wäŋa yäku Gaynandja, ga ŋuliwitjarrayina walala yukurrana marrtji'‐marrtjinanydja, yana liŋgu‐u‐u ga ŋunhiliyina ŋunhi yukurrana wanhami dharpa maḏayin' djingaryurruna, yäkuŋura Moray, galki Djikam wäŋaŋura. Yo, ŋunhilimiyinydja wäŋaŋura yukurrana nhinana yolŋu walala bäpurru' Gaynanbuynha, ga buku‐ŋal'yurrunanydja walala yukurrana wiripuŋuwu waŋarrwu malaŋuwu, yakana ŋurikinydja waŋarrwu wal'ŋu yuwalkkunydja, ŋunhi ŋanya ŋayi yukurrana gäŋala Yipuramnha. ");
INSERT INTO gnn_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Yo, ŋayathaŋalanydja ŋayi ŋunhiyi wäŋa, bala ŋayinydja marrtjina gonha maḻŋ'thurruna warray nhanukala Garraynha Godnha, bala waŋana bitjarrana, “Dhuwalana ŋunhiyi wäŋanydja ŋarra yurru wekama nhokalaŋuwu mala‐bunharawuywuna, märr yurru dhuwalayinydja wäŋa bitjanna liŋguna nhokalaŋuwuna miṯtjiwu dhärrana yana yukurra yurru.” Bala ŋayi Yipuramdhunydja botjaŋalana guṉḏana malanha ŋal'‐ŋalmaraŋala, bala yana wäyinnha bathara, buku‐wurrparanydja Garraynha Godnha, ŋunhi ŋayipi maḻŋ'maranhamina ŋanyapinyay ŋayi nhanukala Yipurayimgala ŋunhiliyi wäŋaŋura. ");
INSERT INTO gnn_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Ga mukthurrunaŋga yana walala yukurrana wäŋgaŋala lili, buku‐ŋuparana bala, yana liŋgu‐u‐u ga wäŋa ŋayathaŋala ṉapuŋga Bithulwuy ga Yäyiwuy, ga ŋunhiliyi wäŋaŋura walala biyapul nhinana wäŋaraŋala. Ga ŋunhili ŋayi biyapul botjaŋala bitjarrayi liŋgu guṉḏa, bala buku‐ŋal'yurruna Garraywalana yukurrana. ");
INSERT INTO gnn_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Bala walala ŋunhi giṯthu'‐giṯthurrunana marrtjina yulŋunydja, bitjarrana liŋguna bala marrtjinanydja yukurrana wäŋalili ga wäŋalili. ");
INSERT INTO gnn_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Ŋuliŋurunydja dhäŋuru bala yana wäŋanydja ganbarkthinana ŋunha Gaynanbuynydja, bala Yipuram giṯthurrunana ŋuliŋuruyi wäŋaŋuru, bala yana marrtjinana yukurrana bitjarrana bala buku djalathaŋnha ŋupara, marrtjinana yukurrana wäŋawuna ḻarruŋala, yana liŋgu bur‐way bunana ŋunhalana Yetjipnha. ");
INSERT INTO gnn_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Ga ŋunhi walala marrtjina yukurrana galkithinanydja ŋunhi wäŋanydja, bala yana ŋayi Yipuram waŋanana nhanukalaŋuwala miyalkkala Saraywala bitjarra, “Nhenydja dhuwalanydja ga ḻatju'na dhikana miyalk rumbal dhapirrknha. ");
INSERT INTO gnn_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Walala yurru nhuna ŋuriŋiyi Yetjippuyŋuyunydja ḏarramuwurruyu nhäma, bala walala yurru bumana ŋarranhanydja, bala yana märramana nhunanydja yurru miyalkkumana walalaŋguwaynha. ");
INSERT INTO gnn_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Ga nhenydja yurru waŋiya biyaka ŋunhi nhenydja yapa'mirriŋuna ŋarraku, märr yurru walala ŋarranha walŋakuma, yakana bumanydja.” ");
INSERT INTO gnn_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Bala yana walala gärrinana Yetjiplilina wäŋalili, ga ŋunhi walala nhäŋalanydja Saraynha ŋuriŋi Yetjippuyŋuyunydja yolŋu'‐yulŋuyu, bala ḻatju'‐ḻakaraŋalana dhapirrk ḻakaraŋalana ŋanya Saraynhanydja. ");
INSERT INTO gnn_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Walala märraŋalana ŋanya, bala gäŋala giŋgalana wäŋalili, miyalknha ŋurikiyina giŋguna. ");
INSERT INTO gnn_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Bala ŋayi giŋdhunydja ŋuriŋiyi rarr'yurruna wäyinnha buliki'na nanikutnha ga dhika nhäna malanha girri' nhanŋu Yipuramgunydja, dhaŋaŋnha bäymana girri', yanapi Saraynydja ŋunhi Yipuramgu yapa'mirriŋu. ");
INSERT INTO gnn_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Yurru dhunupana yana ŋunhi djaw'yurruna walala Saraynhanydja bala ŋunhamalana giŋgalana wäŋalili, bala ŋayi giŋdhunydja ŋuriŋiyi rerrina märraŋala, ga wiripu‐guḻku' ŋunhili bala'ŋura bitjarrayi liŋgu rirrikthunmina wirrkina, liŋgu God ŋayipi goŋ‐nherraṉmina yukurrana Saraywunydja. ");
INSERT INTO gnn_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Bala ŋayi giŋdhunydja dharaŋarana ŋunhiyi, ŋunhi ŋayi Saray Yipuramgu miyalk wal'ŋu, bala ŋayi waŋana Yipuramgala bitjarra, “Nhäku warray nhe bitjarranydja ŋarranha? Nhäku nhe yakanydja waŋana dhunupa ŋarrakala, ŋunhi ŋayi Saraynydja nhuŋuway miyalk. ");
INSERT INTO gnn_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Nhäku nhe ḻakaraŋala ŋarrakala ŋunhi ŋayi yapa'mirriŋunydja nhuŋu? . . . ga nhäkuna nhe lilinydja ŋanya djuy'yurruna ŋarrakalanydja? Ŋay' dhuwalana nhuŋu miyalktja. Gatjuy marrtjiyana maṉḏa dhipuŋuru yarrkthurrana ŋarrakala wäŋaŋurunydja.” ");
INSERT INTO gnn_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Ga yuwalkthi ŋayi giŋdhu gukuŋalana Yipuramnhanydja ŋuliŋurunydja wäŋaŋuru, bala ŋayi Yipuramdja gaŋgathinana, bala yana marrtjinana; märraŋalanydja ŋayi miyalknhana nhanŋuway ga wiripu malanha ŋunhiyi djaw'yurrunana‐wala. ");
INSERT INTO gnn_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Bala walala gonha'yurrunana ŋunhiyinydja wäŋa, balayi marrtjina Gaynanlili, ga Lot yäku ḏarramu Yipuramgalaŋuwu gutha'mirriŋuwu walkur malthurrunanydja yukurrana nhanŋu Yipuramgu. ");
INSERT INTO gnn_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","5","Yo, Yipuramdja ŋunhi ḻukunydjana ḏarramu, guḻku'na nhanŋu wäyin buliki ga nanikut, dhika nhä girri' malanha ga rrupiya ga djämamirri walala. Ga nhanbala Lotpa balanyara yana liŋgu guḻku'yi yana wäyin malanha ga djämamirri walala. Marrtjinanydja walala yukurrana‐a‐a, ga yana liŋgu nhinananydja walala ŋunha Bithullili wäŋalili yäkulili makarrlili Gaynanlili. Nhinananydja walala yukurrana ŋunhiliyi liŋgu wäŋaŋura ŋunhi ŋayi Yipuramdhu ŋurruthaŋala botjaŋala guṉḏa malanha ŋal'‐ŋalmaraŋala, ga ŋunhalayina ŋayi Yipuram biyapulnydja buku‐ŋal'yurruna nhanŋu Godku. ");
INSERT INTO gnn_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","7","Nhinanana walala yukurrana märr‐weyindhinanydja, bala nhanukalanydja Lotkalanydja djämamirriyu walalay ŋarrtjurrunana nhanŋu Yipuramguna djämamirrinha walalanha; ŋarrtjunminana walala yukurrana dhä‐ḏälthinyamina bitjarrana ya', liŋgu yaka ŋunhiliŋumi wäŋaŋura ŋatha guḻku' ŋula ŋorrana yukurrana ŋuriki wäyingu walalaŋgu bukmakku. Liŋgu wiripunydja mala Gaynanbuynydja ga Biritjpuynydja yukurrana nhinanayi ŋunhiliyi liŋgu wäŋaŋura. ");
INSERT INTO gnn_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Bala ŋayi Yipuramdja waŋana Lotnha bitjarra, “Ŋalinydja maṉḏa dhuwala gurruṯu'mirri maṉḏa. Yaka yurru ŋitjalaŋgu yukurra djämamirri walala ŋarrtjunmirri ga bunharamirri; ");
INSERT INTO gnn_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","ŋali yurru yana gulk‐gulkthunmirri barrkuwatjkunhamirrina. Nhepi djarr'yurra wanhamala nhe yurru marrtji, ga nhiniya yukirriya ŋula wanhami ŋunhi nhe ḏukṯuk, ga ŋarranydja yurru marrtji ŋula wiripulili wäŋalili.” ");
INSERT INTO gnn_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Ŋayi Lotthunydja nhäŋa'‐nhaŋala marrtjina wäŋa ḻiw'maraŋala, bala ŋayi nhäŋala gapuna mayaŋ'nha, ga galki mayaŋ'ŋura ŋunhiliyi wäŋaŋura ḻatju'na dhika mulmu buta'na ŋanyana. ");
INSERT INTO gnn_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Bala ŋayi Lot waŋanana gurku'yurrunana, “Ŋarranydja yurru marrtji ŋunhamala ya', yaŋunhamala wäŋalili; ŋunhala ŋarranydja yukurra yurru nhina ḻatju'ŋura wäŋaŋura dhika galki gapumirriŋura mayaŋ'ŋura.” ");
INSERT INTO gnn_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Yuwalkthi maṉḏa barrkuwatjthinana; ŋayinydja Yipuramdja ŋunhilina bäymana yukurrana nhinana wäŋaŋura, yurru märr‐gaŋga ŋamakurru' wäŋanydja ya'. Ga ŋayi Lotthunydja märraŋala nhanŋuwaynydja nhä malanha warrpam'nha, bala giṯthurruna marrtjina ŋunhimalanayi, ga nhinana ŋunhanayi galki mayaŋ'lilina, galkina yana wäŋaŋura bala'‐maypamirriŋurana Djudumnha yäkuŋura. ");
INSERT INTO gnn_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Yurru yolŋunydja walala ŋunhalaŋumi Djudumbuyŋunydja wirrkina dhika yätjmirrina wal'ŋu; yaka walala yukurrana Garraynha guyaŋina ga dhäruk‐märraŋala. ");
INSERT INTO gnn_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Ga ŋuliŋurunydja dhurrwaraŋuru ŋunhi ŋayi Lotthu ŋanya gonha'yurruna Yipuramnha, Godthu waŋana Yipuramnha bitjarra, “Nhäŋa marrtjiya dhika ḻiw'maraŋa ya' wäŋa, biyaka bala be barrkulili. ");
INSERT INTO gnn_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Dhuwala bukmak wäŋanydja gay' ŋarra yurru wekama nhuŋuna ga nhokalaŋuwu yumurrku'wuna gupaḏalnha‐wala yurru. ");
INSERT INTO gnn_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Nhokuŋu guwar‐yalkthunaranydja yurru dhaŋaŋdhirri mirithirrina guḻku'na bothurrumiriwnha, bitjan ŋunha ya' munatha' ganu'. ");
INSERT INTO gnn_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Gaŋgathiyanydja bala marrtjiya muŋdhu'‐muŋdhurrana djalkiriyuna bukmak yana dhuwala gay' wäŋanydja, bili nhuŋuwaynha yurru ŋarra wekama dhuwala wäŋanydja warrpam'nha yana.” ");
INSERT INTO gnn_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Bala yana ŋayi Yipuramdja giṯthurrunana ŋuliŋuru, ga marrtjina dhut‐gay nhinana Mamirilili wäŋalili yäkulili, galki Yiprunlili, ga ŋunhalayinydja ŋayi guṉḏa botjaŋala ŋal'‐ŋalmaraŋala, ga buku‐ŋal'yurruna yukurrana Garraywuna. ");
INSERT INTO gnn_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","12","Liŋguna ŋayi Lottja nhinanana yukurrana ŋunhalayi Djudumnha, bala marrtjina bunana mari warray ŋunhiliyinydja, liŋgu ḏämbumiriwyu giŋdhu walalay miriŋunha walalaŋguway ŋurru‐warryurruna, ga bunana ŋunhilina wäŋaŋura. Walala wäŋanydja ḏaw'yurruna warrpam'nha, bala djaw'‐djawyurrunana girriny'tja dhika nhänydja bukmak, ga yolŋu'‐yulŋunhanydja ḏapṯapmaraŋalana, bala yana djaw'‐djawyurrunana walalaŋgiyingalana wäŋalili. Ga bitjarrayi bili Lotnhanydja ga nhanŋu yumurrku'nha ga miyalknha djaw'‐djawyurrunayi, ga bukmak nhanŋu nhä malanha girri'. ");
INSERT INTO gnn_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","16","Yurru waŋganydja nhanŋu Lotku djämamirri winya'yurruna, bala waṉḏina ga ḻakaraŋala Yipuramguna. Dhunupa ŋayi Yipuramdja gaŋgathina, ḻuŋ'maraŋala nhanŋuwaynydja miriŋunha yolŋu'‐yulŋunha ŋunhi walalanha, bala yana ŋuparana walalanha, ḻundu‐ŋuparana ŋunhiyi 4‐nha giŋnha walalanha ga walalaŋgu miriŋunha walalanha. Warr'‐warryurruna walala ga bumarana walalanha ŋunhi miriŋunhanydja, ga ŋuparana ŋunhinydja bena‐wala giŋnhanydja walalanha, bala roŋiyinmaraŋala djaw'yurruna Lotnhanydja ga nhanŋu yumurrku'nha ga miyalknha ga girri' malanha, ga wiripu‐guḻku'nha yolŋu'‐yulŋunha ḏapṯapmaranhawuynha walalanha ŋunhi. ");
INSERT INTO gnn_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Bala Yipuramdja ga Lottja ga yolŋu'‐yulŋu ŋunhi miriŋu roŋi'‐ruŋiyinana liliyi, ga bukmaknha yana ŋunhi girri' nhä malanha walala roŋiyinanydja gäŋalana yukurrana. Lilinydja walala gumurr‐roŋiyinana yukurrana‐a‐a, ");
INSERT INTO gnn_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","ga ŋunhala gandarrŋuranydja wäŋaŋura yolŋu waŋgany yäku Milkitjitik gumurr‐wunana nhanŋu Yipuramgu, yurru ŋayi ŋunhiyinydja yolŋu giŋ ŋurukuy wäŋawuy Djalambuy, ga bitjandhiyi ŋayi ŋunhiyi ḏarramu ḏalkarra'mirri Godkalaŋuwu. Yo, gäŋalanydja lili ŋayi Milkitjitikthu ŋayaŋay' ga borum weyika', bala wekaŋalana nhanŋu Yipuramgu. ");
INSERT INTO gnn_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Bala ŋayi dhäruknha wekaŋala bukukurru‐waŋanana Yipuramgu, Godkala yäkuyu ḻakaraŋala bitjarra, “Godthu nhuna yurru gämanydja marrtji ḻatju'kumana, ŋuriŋiyi liŋgu Godthu ŋunhi ŋayi djäma ŋunha djiwarr' ga dhuwala munatha'. ");
INSERT INTO gnn_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Ma' wokthurrana Garraywu Godkunydja, liŋgu ŋayipi nhunanydja guŋga'yurruna, bala nhe djuḻkmaraŋalana nhuŋuway miriŋunha walalanha nhanukala yana ganydjarryu.” Bitjarrayina ŋayi Milkitjitik waŋananydja Yipuramgala. Bala yana ŋayi Yipuramdhu gulk‐gulkthurrunana ŋunhiyi girri' malanha märrma' rululili ŋurruklili gurrunhara marrtjina, ŋunhiyi girri' bukmak yana ŋunhi ŋayi roŋiyinmaraŋala liliyi ŋurikala miriŋuwala. Yo, gurru'‐gurrunharanydja ŋayi marrtjina märrma'‐rululili ŋurruklili, ga waŋganydja ŋayi wekaŋala ŋurikinayi yolŋuwu Milkitjitikkuna. Bala yana Yipuramdja marrtjinana‐wala. ");
INSERT INTO gnn_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Ga ŋayinydja ŋurukuynydja wäŋawuy Djudumbuynydja giŋ gumurr‐wunanhamina maṉḏa Yipuram, bala nhanukala waŋana bitjarrana, “Nhe yurru roŋiyinmaraŋanydja lilinydja ŋarrakalanydja dhuwalina yolŋu'‐yulŋunhana, märr yurru ŋanapurru roŋiyirri bala Djudumlili ga nhina yukurra ŋunhala, yurru girri' dhuwali ya' ŋunhi nhe yawungu gombu'‐gumbuma ŋunhi miriŋunha, nhepina yukirriya ŋayathaŋa bukmak yana dhuwali girriny'tja nhuŋuwaynha.” ");
INSERT INTO gnn_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","24","Ga ŋayi Yipuramdja waŋana yaka'yurruna, yana ŋayi rarr'yurrunana ŋunhiyi girri' malanha balayi roŋiyinmaraŋala giŋgu ŋurikiyi Djudumbuyŋuwu; ŋayi waŋana yaka'yurrunana bitjarrana, “Bukmak dhuwala girriny'tja warrpam' nhuŋuway, yaka ŋarra yurru dhuḏi'yunmarama ga ŋayathama yukurra ŋula nhämuny waŋgany. Dhuwalanydja nhuŋuwaynha yana, märr nhenydja yurru yakaŋga waŋiya biyaka, ‘Ŋarra dhuwala ŋanya Yipuramnha ḻukunydjakuŋala.’ Yakana ŋarra yurru ŋayathama yukurra ŋula nhä ŋarrakuway ŋarra. Ma' märraŋana dhuwala girriny'tja malanha ga marrtjiyana‐wala.” Bitjarrana ŋayi Yipuramdhu waŋananydja. ");
INSERT INTO gnn_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Waŋganymirri ŋayi Yipuram nhinana yukurrana nhanukiyingala wäŋaŋura buṉbuŋura, bala ŋayinydja ŋunhi Garraynha ŋayipina maḻŋ'thurruna nhanukala rumbalnha, ga dhunupana ŋayi ŋäkula rirrakaynha ŋanya Garraynha, ŋayi waŋananydja nhanukala bitjarra, “Way Yipuram, yaka barrariya ga wilwilyurra. Ŋarranydja nhuna yurru yukurra dhuwala gungama ŋula nhäŋuru yätjŋuru romŋuru, ga biyapul ŋarra yurru nhuna wekamayi nhänydja malanha ŋamakurruny'tja.” ");
INSERT INTO gnn_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","3","Bala ŋayi Yipuramdja buku‐wakmaraŋala waŋana nhanŋu Garraywu bitjarra, “Waŋarr God, nhepina dhuwala ŋunhi biyapulnydja wal'ŋu bukmakku. Nhäku warray nhe yurru wekama ŋarrakunydja ŋula nhä? Bäyŋu warray dhuwala ŋarraku yothuny'tja. Ŋunhi ŋarra yurru ganan rakunydhirrinydja, bala waŋganydhuna yurru djämamirriyuna ŋarrakala märramanydja nhä malanha ŋunhi ŋarraku nhe yurru wekamanydja, ŋuriŋiyi Damatjkapuyŋuyuna ḏarramuyu Layitjayuna yäkuyu, bili bäyŋuna ŋarraku gäthu'mirriŋunydja dhuwala.” ");
INSERT INTO gnn_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Ga ŋayinydja nhanukala waŋana Garraynydja bitjarra, “Dhiyaŋuyinydja ḏarramuyu djämamirriyunydja yurru yakana märrama nhokuŋu nhä mala, liŋgu nhuŋunydja yurru maḻŋ'thundhi nhuŋuwaynydja wal'ŋu gäthu'mirriŋu, ga ŋayina yurru ŋawatthundja ŋunhiyinydja malanha ŋunhi nhe yurru ganan. ");
INSERT INTO gnn_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Go dhawaṯthurrana lili warraŋullilina, ga nhäŋa ŋunha ya' ganyu'nha miṯtji. Bakaruŋa ga nhäŋa ŋunha ya' miṯtji, ŋula nhämunha'na ŋunha yulŋunydja, bala bothurruna. Balanyarayina yurru nhokuŋu miṯtjinydja, guḻku'na dhikana yana, ŋula nhämunha'na bothurrumiriwnha.” ");
INSERT INTO gnn_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Bala ŋayi Yipuramdja märr‐yuwalkthinana wal'ŋu yana, märr‐nherraṉminanydja nhanukala Garraywala, bala ŋayi Godthunydja ŋanya Yipuramnha ḻakaraŋala ŋayaŋu‐dhunupana yana, bala märraŋalanydja ŋanya nhanŋuwayliliyaŋalana ŋuriŋiyina ŋunhi märr‐yuwalkthinyarayu nhanukala Yipuramgala. ");
INSERT INTO gnn_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Ga dhunupana yana ŋayi Garraynydja waŋana Yipuramgala, ḻakaraŋala bitjarra. “Ŋarranydja dhuwala ŋunhiyi, ŋunhi ŋarra nhuna gäŋala beŋuru wäŋaŋuru Woŋuru dhipala wäŋalili, märr yurru ŋarra wekama dhuwalanydja wäŋa nhuŋuwaynha,” bitjarra ŋayi God Garray waŋananydja. ");
INSERT INTO gnn_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Ga ŋayinydja waŋana Yipuramdja bitjarra, “Nhäyu dhika ŋarra yurru marŋgithirri bitjandhiyinydja, ŋunhi yurru dhuwalanydja wäŋa be ŋarraku?” ");
INSERT INTO gnn_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Bala ŋayi biyapul God waŋana Yipuramgala bitjarra, “Ŋarranydja yurru dhuwala dhäruktja nherraṉ, nininyŋuna dhärranharayŋuna wäwun nhuŋu ga ŋarraku. Gatjuy marrtjiya, ga märraŋa wäyinnhana malaŋunha, buliki'nha ga nanikutnha ga bembinha ḏarramunha wäyinnha, ga biyapul märrma' yutjuwaḻa' wäyin ḻaparr ga murryil. Ŋarra yurru wäwun nherraṉmirrina nhokala Yipuram,” bitjarrana ŋayi waŋana Garraynydja. ");
INSERT INTO gnn_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Bala ŋayi marrtjinana, wapmaraŋalanydja marrtjina Yipuramdhu, märraŋalanydja ŋayi ŋunhiyinydja malanha, bala yana gäŋalana lili, bala ŋunhilinydja ŋayi mitmitthurrunana. Yo, mitthurrunanydja ŋayi muḻkurrkurru yana ṉapuŋga'kurru, ga ŋunhana‐wala, yana liŋgu ga rumballili wapthurruna barraŋiny'kuŋala. Yo, gulk‐gulkthurrunanydja ŋayi barrkuwatjkuŋalanydja, bala rulwaŋdhurrunana marrtjina gali'lili ga gali'lili bitjarrana bala, ga yaka ŋayi ŋunhi yutjuwaḻa'nhanydja wäyinnha maṉḏanha mitthurruna, yana maṉḏanha ŋunhina liŋgu gurrunhara, rumbalmirrinha maṉḏanha gali'lili ga gali'lili, ga ṉapuŋgany'tja marrtjina ŋorrana dhukarrnha bala. Ga ŋunhi ŋayi djäma bitjarrayinydja, ŋunhiyinydja rom walalaŋgu yolŋu'‐yulŋuwu, walala ŋuli yukurranha bitjana djäma ŋunhi ŋuli märrma' yolŋu maṉḏa dhawu'mirriyanhaminya maṉḏanhawuy maṉḏa. ");
INSERT INTO gnn_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Yo, ŋunhiyinydja wäyindja malanha marrtjina ŋorra'‐ŋurranana, bala walalanydja gonha wäyin wakinmirrina ḻuŋ'thurruna marrtjina, balanyara bitjan gaḻkarriŋu' rumbal, yurru bathalamirrina, walala bini ŋunhiyi ḻukanhana marrtjinya ŋunhi ŋanaknha wäyinnha, bala ŋayi Yipuramdhunydja wirriw'‐wirriwyurrunana, gukuŋalana walalanha. ");
INSERT INTO gnn_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Yo, walunydja marrtjina ŋunhi gärrinana, bala ŋayi Godthunydja ŋanya yakurr wekaŋalana ŋorranharawuna, bala ŋayi yakurrthinana yana Yipuramdja, yurru muḻkurrnydja ŋayi bira'yurruna yukurrana, bala ŋayi nhäŋalana yukurrana ŋunhiyi maŋutji‐waḻa'waḻamirriyuna, wilwilyurrunana manapara wirrkina. ");
INSERT INTO gnn_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","15","Bala dhunupana ŋayi God waŋana Yipuramgala ḻakaraŋala, ŋunhi yurru nhaltjan ŋunhala bala yalala, bitjarrana ŋayi ḻakaraŋalanydja, “Nhenydja yurru nhina yukurra marimiriw yana, yana liŋgu ga rakunydhirrinydja nhe yurru worruŋu yana, bala walala yurru dholkumana nhuna. Ga ŋunhi yurru dhuŋgarra marrtji djuḻkthun bala, bala nhuŋu yurru miṯtjinydja guḻku'yirrina, bala walala yurru yukurra nhinanydja mulkuruŋurana wäŋaŋuranydja ŋunhi, yurru garrpiṉarana walalaŋguŋu djämamirrina walala; nhinanydja walala yurru yukurra ŋunhi burakirrina yana walalaŋguŋu, galŋa‐yätjthirrina bitjanna liŋgu, weyinŋumirrina yurru, 400‐nha dhuŋgarra. Ga ŋuliŋuruyinydja dhäŋuru ŋarra yurru dhä‐ḏir'yunna ŋunhiyinhanydja walalanha ŋunhi walala ŋuli yukurra yätjkuma nhokuŋu miṯtji‐wunharanha, bala ŋarranydja yurru yana nhuŋu miṯtjinhanydja ŋunhi dhawaṯmaramana ŋuliŋuru mulkuruŋurunydja wäŋaŋuru, bala walala yurru yana marrtjinydja ŋulaŋuruyi wäŋaŋuru ḻukunydjamirrina. ");
INSERT INTO gnn_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Yo, nhinanydja walala yurru yukurra märr‐weyinŋumirri yana ŋunhiliyi mulkuruŋuranydja wäŋaŋura, ga yurruna ŋarra yurru roŋinyamaramanydja walalanha gäma lili dhipalanydja wäŋalili. Yo, dhiyakuynydja wäŋawuy Gaynanbuyŋunydja yolŋu walala yukurra nhina yätjmirrina wal'ŋu yanana, ga bitjanna liŋguna walala yurru yukurra dhiyala nhinanydja yätjnha yana, bala ŋarranydja yurru walalanha dhä‐ḏir'yunna ŋulinyaramirriyu, liŋgu wekamanydja ŋarra yurru walalaŋguna wäŋanydja dhuwalayi nhokalaŋuwuna miṯtjiwu walalaŋguwaynha.” Bitjarrayina ŋayi waŋana Godthu dhawu'‐nherraranydja Yipuramnha. ");
INSERT INTO gnn_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Yo, walunydja ŋunha gärrinana liŋguna, munhakuna wal'ŋu, ga ŋayi Yipuramdja mukthurrunaŋga yana yakurr ŋorrana, bala ŋayi nhäŋala Yipuramdhu ŋunhiyina märrma' maṉḏanha, waŋganydja banikin ḻirrwi'mirri ŋunhi ŋawulul' marrtjina gaŋgathina, ga waŋganydja djarraṯawun', yurru gurtha ŋunhi dhäŋa'mirri; maḻŋ'thurrunanydja maṉḏa ŋunhi, bala marrtjinana yukurrana ŋuliyina ṉapuŋga'kurruna, ŋunhi wanhaka marrtjina wäyin malanha ŋorra'‐ŋurrana gali'ŋura ga gali'ŋura. ");
INSERT INTO gnn_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Bala ŋayi Yipuramdhu dharaŋarana yana ŋunhimalayinydja, ŋunhi ŋayipi yana ŋunhiyi God yulŋunydja marrtji'‐marrtjinanydja yukurrana, biyaku ŋuli ŋayi dhawu'na nherrara Godthu ŋunhiyinydja maṉḏakuway maṉḏa, bala yurru ŋunhiyi dhawuny'tja yukurra dhärrana yana yurru gupaḏalnha‐wala yana. Liŋgu balanyarayi rom yukurrana walalaŋgunydja ŋorrana dhawu'‐nherraṉminyarawu, yuwalknha yana ḏälnha wal'ŋu ŋunhiyi dhawuny'tja. Ga dhuwalana ŋunhi dhawuny'tja ŋayi ḻakaraŋala nhanŋu Yipuramgu bitjarra, “Ŋarranydja yurru dhuwala wäŋa bukmaknha yana wekama nhokalaŋuwuna miṯtji‐wunharawu yukurranharawu, dhipuŋuru liŋgu yurru Yetjipŋuru ga yana liŋgu‐u‐u ga ŋunha mayaŋ'lili wapthun Yipuraytilili yäkulili; ");
INSERT INTO gnn_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","20","dhuwalayinydja wäŋa malanha yurru walalaŋguwaynha yanana, nhokalaŋuwuna miṯtjiwu, nhäyikapuyŋuwuna Genbuyŋuwuna wäŋa, ga Genitjpuyŋuwuna, ga Gadmanbuyŋuwuna, ga Yitpuyŋuwuna, ga Biritjpuyŋuwuna, ga ŋurikina yolŋu'‐yulŋuwu ŋunhi walala ŋuli ḻakarama djaka'‐weyinguna yolŋuwu, ");
INSERT INTO gnn_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","ga Yamarpuyŋuwuna, ga Gaynanbuyŋuwuna, ga Girkatjpuyŋuwuna, ga Djepatjpuyŋuwuna, dhuwalayinydja wäŋa malanha ŋarra yurru wekama nhokalaŋuwuna miṯtjiwu.” Ga bitjarra ŋayi Godthu ḻakaraŋala dhawu'mirriyaŋalanydja Yipuramgu. ");
INSERT INTO gnn_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Ga ŋunhili wäŋaŋura Gaynandja walala yukurrana nhinana 10 waltjaṉ ŋunhiliyi, ga worruŋuthina ŋayi Saray ŋunhiliyi liŋguna, yurru bäyŋu yana yothuny'tja ŋayi märraŋala Yipuramgu. Ga ŋayi Sarayyu yukurrana ŋayathaŋala miyalknha djämamirrinha nhanŋuway, Yetjippuy wäŋawuy, yäkunha Yaykanha. ");
INSERT INTO gnn_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","3","Bala ŋayi Saraynydja marrtjina ga waŋana ŋanya Yipuramnha bitjarra, “Way Yipuram, nhämirri nhe ŋuli märraŋu ŋunha djämamirrinhanydja ŋarraku miyalknha, märr ŋayina yurru yothu gäma ŋarraku, liŋgu ŋarranydja dhuwala worruŋuna.” Ŋunhi ŋayi bitjarrayinydja waŋana, liŋgu ŋunhi ŋäthili walala yukurrana nhinana Wo wäŋaŋura yäkuŋura, ŋunhiyi rom walalaŋgu yukurrana djingaryurruna balanyarayinydja. ");
INSERT INTO gnn_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Ga ŋayi Yipuramdhunydja ŋäkula ŋanya Saraynha dhäruk, bala ŋayi märraŋalana ŋunhi Yaykanhanydja, djämamirrinhanydja ŋunhi Saraywu, bala ŋayi ŋunhi dhäyka yothu'mirriyinana, ŋayi yurru gäma yothunhanydja ŋunhiyi Saraywu. Ga ŋunhi ŋayi yothu'mirriyina ŋunhi djämamirri miyalk, bala ŋayi wirrkina ŋurr'yurruna, yindikunhaminanydja ŋanyapinyay ŋayi, ga waŋana wakinŋu ḻakaraŋalana yukurrana ŋanya Saraynhanydja. ");
INSERT INTO gnn_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Bala ŋayi Saraynydja maḏakarritjthinana, ga waŋana ŋanya Yipuramnhanydja bitjarrana, “Nhuŋu dhuwala ŋurrunydja, liŋgu nhe buku‐miyalk. Ŋarra ŋanya ŋunhi wekaŋalanydja nhuŋu, bala ŋayinydja ŋarranha ŋuriŋiyi miyalkthunydja yukurra wakinŋu ḻakarama warray ŋuli, ŋarrtjun warray. Yurru Godtja nhuŋu marŋgi, ga marinydja nhe yurru märrama nhanukuŋu wakin yana.” ");
INSERT INTO gnn_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Bala ŋayi ŋunhi Yipuramdhunydja waŋana bitjarrana, “Nhuŋu ŋunhi ŋayi djämamirri; nhokala ŋayi ŋunhi goŋŋura, ga nhepi yurru bitjanmirrinydja nhäku nhe ḏukṯuk nhanŋu.” Bala ŋayi nhanŋu ŋunhi Saraynydja wirrkina ŋaramurryina Yaykawu, yätjkuŋalana wirrkina ŋanya ŋayi birrka'yurrunanydja. Bala ŋayi waṉḏinana, bala muka ŋayi bini marrtjinyanydja Yetjiplili ŋunhiyi djämamirri miyalk. ");
INSERT INTO gnn_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Marrtjinanydja ŋayi bala‐a‐a, ḏiltjikurruna marrtjina yukurrana, yana liŋgu ga maḻŋ'maraŋala ŋayi gapu maŋutji, ga ŋunhilina ŋayi nhinananydja yukurrana. Bala ŋayinydja ŋunhiliyina maḻŋ'thurruna nhanukala Garraynha, rumbal yolŋuna, ");
INSERT INTO gnn_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","ga waŋana nhanukala ŋayi bitjarra, “Way Yayka, djämamirri Saraywu. Wanhaŋuru nhe dhuwala marrtjinanydja? . . . ga wanhamalana nhe yurru marrtjinydja?” “Ŋarranydja dhuwala waṉḏina ŋarrakalaŋuwala buŋgawawala,” bitjarra ŋayi ŋunhi Yaykanydja waŋana. ");
INSERT INTO gnn_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Ga ŋayinydja waŋana Garraynydja bitjarra, “Gatjuy marrtjiya roŋiyiya balayi, ga djäma nhe yurru nhanŋu Saraywu ŋamathaŋa,” bitjarra. ");
INSERT INTO gnn_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Ga biyapul ŋayi Garray waŋana ŋurikala miyalkkala bitjarra, “Nhokalaŋuyunydja ŋuriŋi yothuyu yurru mala‐buma yukurra guḻku'na mirithirrina, ŋunhi yurru yakana miṯtji ŋunhi bothurru. ");
INSERT INTO gnn_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Yo, waku'mirriŋunydja ŋayi yurru nhokuŋu ŋunhi dhawal‐wuyaŋirri ḏarramu, ga yäkunydja nhe yurru ŋanya nherraṉ Yitjmayil; dhuwalayi yäku mayali' balanyara bitjan ‘Godthu ŋuli ŋäma,’ ga ḻakaramanydja nhe yurru dhuwalayi yäkunydja ŋanya, liŋgu Godthu nhuna ŋäkula rirrakay ŋäthinyara. ");
INSERT INTO gnn_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Ŋunhi yurru ŋayi nhuŋu waku'mirriŋunydja gurarrthirri yindithirri, ŋayinydja yurru bitjan wakinŋuna ŋunhina wäyin, liŋgu rom nhanukiyingalaŋumirrina ŋayi; gänana ŋayi yukurra yurru nhina.” Ga ŋunhi ŋayi waŋananydja ŋanya bitjarrayi, bala ŋayi maŋutjiŋuruna nhanukala winya'yurruna. ");
INSERT INTO gnn_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Bala ŋayi ŋunhi miyalktja wirrkina yana ṉirryurrunanydja, bala waŋana bitjarrana, “Way, Garraynha dhuwala ŋarra nhäŋalanydja?” bitjarra ŋayi. “Walŋa warray dhuwala ŋarra yulŋunydja? . . . mukthun nhina yukurra?” Bala ŋuliŋurunydja ŋayi yäkuna ŋanya nherrara Garraynha, yuṯana yäku, dhuwalana gam', ‘Godtja dhuwala nhänharamirri,’ bitjarrana. Bala ŋayi ŋuliŋuruyinydja marrtjina balayi roŋiyinayi Yipuramgalana wäŋalili, bala djämana ŋayi yukurrana nhanŋu Saraywu. ");
INSERT INTO gnn_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Yurru ŋunhi gapu maŋutjinydja ŋunhayi yana mukthun, ṉapuŋga wäŋaŋura maṉḏanyŋuŋura Gäditj ga Birit, ga yäkunydja ŋilimurru ŋuli ḻakarama ŋunhiyi maŋutji ‘Gapunydja ŋurikiyina Waŋarrwu ŋunhi ŋayi yuwalk walŋa, ga nhäma ŋayi ŋuli yukurra ŋarranha.’ Yo, ḻakaramanydja ŋilimurru ŋuli ŋunhiyi bitjandhi, liŋgu ŋunhalayi ŋayi Yaykayu yäku‐ḻakaraŋalanydja Godnha bitjarra, ‘Godtja dhuwala nhänharamirri.’ ");
INSERT INTO gnn_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Ga yalalanydja ŋayi Yaykawuŋu yothu dhawal‐wuyaŋinana, gäthu'mirriŋuna ḏarramu nhanŋu Yipuramgu, bala ŋayi yäkunydja ŋanya nherrara Yipuramdhu Yitjmayilnhana. ");
INSERT INTO gnn_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Ga ŋulinyaramirriyunydja ŋayi Yipuram worruŋuna wal'ŋu yana, 86‐nha dhuŋgarra. ");
INSERT INTO gnn_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Yo, ŋunhi dhuŋgarra marrtjina djuḻkthu'‐djuḻkthurruna, ga ŋayinydja ŋunhi Yipuramdja dhuŋgarra nhanŋunydja 99‐nha, bala ŋayi Garray ŋayipi biyapul maḻŋ'thurruna nhanŋu, ga waŋana bitjarra, “Ŋarranydja dhuwala God Waŋarr Ganydjarr‐ḏumurru. Märraŋa ŋarranha dhäruktja, bala djämana märr‐yunupathiya yana. ");
INSERT INTO gnn_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Ŋarra yurru dhawuny'tja nherraṉ nhokalana. Nhuŋu ŋarra yurru wekama yothu'nha, bala yurru nhokalanydja mala marrtji guḻku'thirrina wal'ŋu, ga dhuwalayi dhawuny'tja yurru walalaŋgu dhärra yukurra, bitjanna liŋguna yurru.” ");
INSERT INTO gnn_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Bala ŋayi Yipuram ṉepaḻ‐nyilŋ'thurrunanydja muḻkurrnydja munatha'lili, bala buku‐ŋal'yurrunana yukurrana nhanŋu Godku. Ga ŋayi Godtja waŋana nhanukala bitjarra, ");
INSERT INTO gnn_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Dhuwalana dhawuny'tja wekamana ŋarra yukurra nhuŋu. Nhenydja yurru guḻku'wuna dhuwala bäpa'mirriŋu malawu ga malawu. ");
INSERT INTO gnn_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Nhenydja yurru yakana yäku Yipuramdja; yäkunydja nhe yurru yuṯanydja Yipurayimnha, liŋgu dhuwalayinydja mayali' yuṯanydja yäku bäpa'mirriŋu guḻku'wuna miṯtjiwu, ga yuwalknha nhe yurru ŋunhi bäpa'mirriŋu guḻku'wuna miṯtjiwunydja. ");
INSERT INTO gnn_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Nhokuŋu mala‐wunharanydja ŋuliŋuruyi yurru guḻku'na dhaŋaŋnha wal'ŋu mirithirrina, ga ŋuliŋuruyi nhokala yarraṯaŋuru yurru wiripunydja yolŋu ŋurru'‐ŋurruŋuna. ");
INSERT INTO gnn_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","“Yo, dhuwalana dhawuny'tja ŋunhi ŋarra yukurra dhawu'‐nherraṉ nhuŋu yurru dhärrana yana bitjanna liŋguna, bitjanna gam'. Ŋarranydja yurru nhuŋu God Waŋarr, ga Waŋarr God ŋarra yurru ŋuriki walalaŋgu ŋunhi yurru nhokuŋu mala‐bunhara maḻŋ'thun yukurra. ");
INSERT INTO gnn_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Nhinanydja nhe yukurra dhuwala dhiyala wäŋaŋuranydja Gaynandja mulkuruna, yurru wekamanydja ŋarra yurru nhumalaŋguna dhuwalayi wäŋanydja; bukmak dhuwalayi wäŋanydja yurru ŋurikina walalaŋgu nhokalaŋuwuna miṯtjiwu. Ga ŋarranydja yurru walalaŋgu Godnha, ga walalanydja yurru yolŋu walala ŋarrakuwaynha.” ");
INSERT INTO gnn_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Bala ŋayi ŋuliŋuruyinydja God waŋana Yipurayimgala bitjarrana, “Dhiyakuyinydja dhawu'wu nhe yurru buku‐yoramana yana märramana, nhe ga yolŋu'‐yulŋuyu nhokala ŋunhi yurru maḻŋ'thu‐maḻŋ'thun marrtji yalala, ");
INSERT INTO gnn_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","ga bitjan nhuma yurru yoramanydja gam'. Bukmak nhuŋunydja mala yurru bitjandhina mitthunmirri, bitjan ŋuli yolŋu'‐yulŋuyu ḏarramukuma mitthun, bitjan ḏarrtjalkkumana yolŋunha, yurru dhuwalanydja ḻakarama yukurra wiripu mayali', wiripu warray; dhuwalanydja mayali' balanyara bitjan nhumanydja yurru mala ŋarrakuna, ga ŋarra yurru nhumalaŋgu Waŋarr God. ");
INSERT INTO gnn_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","12","Bukmak ŋunhi ḏarramuwurru nhuŋunydja mala ŋunhi yukurra nhina dhiyaŋu‐wala dhuwala yurru bitjandhiyina mitthunmirri yukurra, ga ŋunhi yurru yothu nhokala malaŋura dhawal‐wuyaŋirri, ga 8‐mirri ḏaykun'mirri ŋunhiyi yothu, bala ŋanyanydja nhuma yurru bitjandhiyina mitthun. Ga biyapul nhuŋu djämamirrinhanydja walalanha yurru bitjandhi liŋgu mitthundhi, ga walalaŋgu djamarrkuḻi'nha ŋunhi walala yukurra yurru dhawal‐wuyaŋirri, ");
INSERT INTO gnn_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","liŋgu ŋunhiyinydja mim'punydja rumbalŋura ŋunhi ḻakarama yukurra yurru ŋarraku dhawu'na, ŋunhi yukurra yurru djingaryunna yana‐wala. ");
INSERT INTO gnn_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Ŋunhi yurru ŋula yol yolŋu yakaŋuwuynydja mitthunara ḏarrtjalkkunhara, ŋunhiyinydja yakana ŋayi ŋarraku yolŋu, liŋgu ŋuruŋuyinydja mim'puyunydja ḻakarama yukurra yolŋuwala, ŋunhiyina ŋarrakunydja yolŋu ga ŋarra nhanŋu Waŋarr God,” bitjan. ");
INSERT INTO gnn_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Ga biyapul ŋayi God waŋana Yipurayimgala bitjarra, “Yakana nhe yurru biyapul yäku ḻakarama nhuŋuway dhäyka Saray bitjandja, yuṯana ŋayi dhuwali yäkunydja Sarana. ");
INSERT INTO gnn_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Ga ŋarrapi ŋanya yurru goŋmirriyamanydja, yolŋukumanydja gäma galkikumanydja; ŋayi yurru dhiyaŋiyi Sarayu gäma yothu'nhana, waku'mirriŋunha ḏarramunha. Yo, dhipuŋuruyinydja nhanukalanydja yurru marrtji guḻku'thirri yolŋu walala maḻŋ'thun miṯtji ga miṯtji, ga wiripunydja yurru dhipuŋuruyi buŋgawamirrina, buŋgawana walala.” ");
INSERT INTO gnn_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Bala ŋayi ŋuliŋuruyinydja Yipurayim ṉepaḻ‐nyilŋ'thurrunana bukumirriyaŋala, ŋunhi munathany'tja ŋayi dhanu'yurruna muḻkurryunydja. Bala ŋunhiliyi ŋayi nhanukala beyarrmakthinana, bala ŋayi gitkitthurrunana Yipurayim, guyaŋina ŋayi bitjarrana, “Dhuwala ŋarra worruŋuna yolŋunydja, 100‐mirrina dhuŋgarramirri, ga nhaltjanna ŋarra yurru walkurmirriyirrinydja dhika? Ga ŋunha miyalk ŋarraku Saranydja 90‐mirrina dhuŋgarramirri, ga balanyarayi liŋgu ŋayinydja ŋunhayi worruŋuyi yana yothu'wu gänharawu.” ");
INSERT INTO gnn_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Bala ŋayi dhunupana Yipurayimdhunydja dhä‐wirrka'yurrunana ŋanya Godnha bitjarra, “Ga nhämirri ŋuli ŋunhi Yitjmayilyunydja goŋdhu märraŋu nhä malanha ŋarrakuŋu; ŋunhiyi dhawu' ga girri' malanha nhe ŋarraku wekaŋala. Dhuwalanydja malanha yurru ŋayina märrama ŋi? . . . Yitmayilyuna?” ");
INSERT INTO gnn_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Ga ŋayinydja waŋana Godtja yaka'yurrunana Yipurayimgala, “Yaka ŋayi Yitjmayilyunydja yurru märrama nhokuŋu,” bitjarra. “Liŋgu Sarayunydja yurru gämana nhuŋuwaynydja yothunha, nhokalaynydja wal'ŋu miyalkthu, ga yäkunydja nhe yurru nherraṉ ŋanya ŋunhiyi yothunha Yitjak. Ga dhuwalayi yäku Yitjaktja mayali' ‘gitkitthurruna ŋayi.’ Yo, ga ŋunhiyi dhawu' ŋarra nherrara nhanŋuway yana ŋunhiyinydja Yitjakku, ga nhanukalaŋuwu yumurrku'wu, bili dhawu' ŋunhiyi yurru walalaŋgu bitjanna liŋguna‐wala yukurra dhärrana yurru. ");
INSERT INTO gnn_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Ga ŋunha Yitjmayilnhanydja, ŋarra yurru yaka meṉguma ŋanyanydja, liŋgu ŋarra ŋäkula nhuna ŋäŋ'thunara; ŋarra yurru ŋanya goŋmirriyamayi gämayi, ga wekama ŋarra yurru guḻku'nhana miṯtjinha nhanŋunydja, biyapulnha walala yurru ŋurruknha miṯtjinydja dhikana, ga ŋuliŋuruyi yurru nhanukala malaŋuru 12‐nha ŋurruŋunydja wal'ŋu yolŋu'‐yulŋunydja, yurru waŋganynha walala yurru ŋunhiyi malanydja yana bathalana wal'ŋu. ");
INSERT INTO gnn_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Yo, ŋarra yurru yaka ŋula meṉguma ŋanya Yitjmayilnhanydja, yurru ŋunhiyinydja dhawu' yukurra yurru djingaryun nhanŋuway Yitjakku, ŋuriki ŋunhi ŋayi yurru dhawal‐wuyaŋirri Sarawuŋu dhiyaŋu‐wala dhuŋgarrayu.” ");
INSERT INTO gnn_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Ga ŋunhi ŋayi bitjarrayinydja God nhanukala waŋana Yipurayimgala, bala ŋayi gonha'yurrunana ŋanya. ");
INSERT INTO gnn_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Ga ŋuriŋi yana liŋgu Yipurayimdhu dhäruktja ŋanya märraŋala, bala djämana yana ŋunhi nhaltjarra ŋayi Godthu nhanukala ḻakaraŋala. Ŋayipinydja Yipurayimdja bitjarrayi mitthunmina, ga bitjarrayi liŋgu ŋayi Yitjmayilnhanydja mitthurruna, gäthu'mirriŋunhanydja ŋunhi nhanŋuway, ga biyapul djämamirrinha walalanha nhanŋuway, ŋunhi walala yukurrana nhinana wäŋaŋura nhanukala, ŋunhiyinydja walala yukurrana mitthunminayi bitjarrayi, ga mim'puyunydja ŋunhi ḻakaramana yukurra ŋunhi walalanydja ŋunhiyinydja walala nhanŋuwaynha Godkuna yolŋu walala, ga ŋayi walalaŋgu Waŋarr God. ");
INSERT INTO gnn_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Ga ŋayinydja ŋunhi Yipurayimdja 99‐nha dhuŋgarra, ");
INSERT INTO gnn_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","ga ŋayi Yitjmayilnydja gäthu'mirriŋunydja nhanŋu 13‐nha dhuŋgarra, ");
INSERT INTO gnn_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","ga ŋulinyaramirriyu liŋgu waluyu maṉḏa ŋunhi mitthunmina ḏarrtjalkkunhaminanydja, ");
INSERT INTO gnn_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","waŋgany‐manapanmina ŋunhiyina walala djämamirrina walala nhanŋu Yipurayimgu. ");
INSERT INTO gnn_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Ŋulinyaramirriyu liŋgu Yipurayim ga nhanŋu mala ŋunhi yukurrana nhinana wäŋaraŋala Mamiri wäŋaŋura yäkuŋura. Waŋganymirri ḏaykun'thu, gorrmuryuna wäŋayu ŋayi yukurrana Yipurayim nhinana nhanukiyingalay ŋayi buṉbuŋura, galki dhurrwaraŋura, bala ŋayinydja nhanukala maḻŋ'thurruna Garraynha, yurru rumbalnydja ŋayi ŋunhi bitjan yolŋuna yana. ");
INSERT INTO gnn_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Yo, nhinananydja ŋayi yukurrana Yipurayim, bala ŋayi waṯthurruna, dharr‐way nhäŋala ḻurrkun'nhana yolŋu'‐yulŋunha, walala marrtjina dhärra'‐dharrana ŋunhili nhanukala galki. Ŋayinydja ŋunhi nhäŋala Yipurayimdhunydja, bala yana waṉḏinana withiyarana walalanha, bala ŋayi ṉepaḻ‐nyilŋ'thurrunanydja walalaŋgala, ");
INSERT INTO gnn_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","ga waŋana bitjarrana, “Way walala, yaka nhuma marrtjiya djuḻkmaraŋanydja ŋarranha. Nhiniya walala dhiyala ŋarrakala, märr yurru ŋarra nhumalanha wekama ga djäka nhumalaŋgu. ");
INSERT INTO gnn_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Waṉḏirrinydja ŋarra nhina bala, bala gapuna märrama; ŋarra yurru nhumalanha ḻupmarama ḻukuna. Ga nhumanydja yurru dhiyala galkun ŋarraku, dharpaŋura ŋurrŋgitjŋura nhiniya. ");
INSERT INTO gnn_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Ŋarra yurru balayi marrtji, ga ŋatha märrama nhumalaŋgu. Ga nhumanydja yurru nhinana ganydjarrnha, ŋurukuna‐wala marrtjinyarawu bala. Ŋarranydja dhuwala wirrkina yana märr‐ŋamathinanydja nhumalaŋgu, goŋmirriyinana ŋunhi nhuma marrtjina lili dhipala ŋarrakala wäŋalili. Ŋarra nhumalanha yurru guŋga'yun ga djäma.” Ga walalanydja waŋana ŋunhiyi ḻurrkun'tja ḏarramuwurru bitjarra, “Yo, ŋanapurru yurru nhina dhiyala.” ");
INSERT INTO gnn_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Bala ŋayi ŋunhi Yipurayimdja waṉḏinana, ga waŋana Saranhana bitjarra, “Way Sara, waḏutja nhe ŋathanydja warkthurra dämbany'tja, ḻatju' yana.” ");
INSERT INTO gnn_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Ga ŋayinydja waṉḏina, ga wutthurruna buliki buyuwuyu yana yuṯa, bala yana waŋana djämamirrinhana, “Way waḏutja go, batharrana dhuwala wäyinnhanydja,” bitjarra. ");
INSERT INTO gnn_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Ga ŋuliŋuruyinydja ŋayi märraŋala ŋamun'kurr ḻukanharawu, ga wäyin ŋanak, ga ŋatha, bala gäŋalana walalaŋgu. Ga ŋunhilina walala yukurrana nhinananydja ḻukanana ŋunhiyi ŋathanydja malanha, ga ŋayinydja yukurrana nhinana ŋunhili dharray walalaŋgu Yipurayimdja. ");
INSERT INTO gnn_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Bala walala ŋunhiyi walala ḻurrkun'tja waŋana bitjarrana, dhä‐wirrka'yurruna ŋanya, “Wanhaka dhika nhuŋu dhäykanydja Saranydja?” bitjarra. Ga ŋayinydja waŋana Yipurayimdja bitjarra, “Ŋunha ŋayi ya', djinawa'.” ");
INSERT INTO gnn_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Bala ŋayi waŋganydhunydja yolŋuyu ḻakaraŋala Yipurayimgu bitjarrana, “Ŋunhi boŋguŋu waŋgany dhuŋgarra djuḻkthurrunydja dhipuŋuru, ŋarranydja boŋguŋu roŋiyiyi liliyi, ga ŋulinyaramirriyunydjayi boŋguŋu nhokala miyalkthu Sarayunydja yothunha dhangi'yurru yukirri.” Ga ŋayinydja ŋunhiliyi Saranydja yukurrana djingaryurruna ŋurrwu'yurruna dhurrwaraŋura, ŋäkula yukurrana walalanha. ");
INSERT INTO gnn_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","12","Ga ŋunhi ŋayi Sarayu ŋäkulanydja, ŋunhi ŋayi boŋguŋu yothu'mirriyinydja, bala ŋayi dhunupana gitkitthurrunana, bala waŋanhamina ŋanyapinyay ŋayi bitjarra, “Nhä‐ä. Worruŋuna dhuwala ŋarra yolŋunydja. Dhuḏitjnha ŋarraku yothu'wunydja gänharawu. Ga ŋunha dhuway'mirriŋu ŋarraku ga balanyarayi liŋgu worruŋuyi yana.” Yo, yuwalk ŋunhiyi yulŋunydja, Yipurayim ga Sara worruŋuna maṉḏa yana wirrkina, ga dhuḏitjnha nhanŋu yothuwu gänharawu, bala ŋayi Sara gitkitthurrunana yukurrana gayulnha. ");
INSERT INTO gnn_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Bala dhunupana ŋayi Garrayyunydja dhä‐wirrka'yurruna ŋanya Yipurayimnha, “Nhäku ŋayi ŋunha Saranydja gitkitthurruna? Ga waŋana ŋayi nhäku bitjarranydja, ŋunhi ŋarranydja worruŋuna wal'ŋu yothuwu gänharawu? ");
INSERT INTO gnn_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Nhä dhika Garraywunydja? . . . ḏäl djämawu wal'ŋu? Yo, yuwalk yana dhuwalanydja, ŋarra boŋguŋu roŋiyi lili, ŋulinyaramirriyu ŋunhi boŋguŋu waŋgany dhuŋgarra djuḻkthurru, ga ŋulinyaramirriyunydja boŋguŋu ŋayi yukirri Sarayunydja dhangi'yurruna yothunhana.” ");
INSERT INTO gnn_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Ŋayi Sarayunydja ŋäkula ŋunhiyi, bala wirrkina wilwilyurruna, ga waŋana bitjarrana, “Yaka ŋarra dhuwala gitkitthurruna.” Ga ŋayinydja Garraynydja waŋana, “Yo yuwalk nhe gitkitthurrunanydja,” bitjarra. ");
INSERT INTO gnn_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Ga ŋuliŋurunydja dhurrwaraŋuru ŋuriŋi ḻurrkun'thunydja ḏarramuwurruyu gonha'yurrunana wäŋa ŋunhiyi, ga Yipurayimdja walalaŋgu malthurrunayi. Ŋal'‐ŋalyurruna walala bukulilinydja, ga ŋulaŋurunydja bukuŋurunydja walala nhäŋala yarrupthurrunana ŋunha Djudumbuynha, ŋunhana wäŋa ŋunhi wanhami yukurrana Lot nhinana. ");
INSERT INTO gnn_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Ga ŋunhala bukuŋuranydja Garray ŋayipi waŋanharamina bitjarra, “Ŋarra yurru ḻakaramana Yipurayimgunydja nhaltjan yurru ŋarra djäma, yakana ŋarra yurru djuḻuḻ'maramanydja nhanukala, ");
INSERT INTO gnn_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","liŋgu Yipurayimgalanydja mala‐wunhara yurru mirithirrina wal'ŋu guḻku'na yolŋu walala, dharrpalnha miṯtji, ga ŋuliwitjandhiyi nhanukalanydja ŋarra yurru wirrkina goŋmirriyama miṯtjinha bukmaknhana walalanha yolŋu'‐yulŋunha. ");
INSERT INTO gnn_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Ŋarra ŋanya djarr'yurrunanydja Yipurayimnha, ga ŋayina yurru marŋgikumanydja nhanŋuway miṯtjinhanydja Godkalaŋunydja romgu malaŋuwu. Ga ŋuli yurru walalanydja ŋuriŋiyinydja miṯtjiyu dhäruk märramana ŋarranha yana, bala djäma ŋamathamana nhä ŋunhi dhunupa ga yuwalk rom, bala ŋarranydja yurru djämana‐wala yana nhä malanha ŋamakurruny'tja ŋunhi ŋarra dhawu'mirriyaŋala nhanukala Yipurayimgala.” ");
INSERT INTO gnn_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Bala yana Garrayyu dhunupana ḻakaraŋala nhanŋu Yipuramgu bitjarrana, “Ŋarra dhäwu' ŋäkula ŋurukuy Djudumbuy wäŋawuy ga Gumurawuy, ŋunhi wäŋa maṉḏanha ŋunhayinydja yätjnha gal'ŋu mirithirrina. ");
INSERT INTO gnn_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Ŋarranydja yurru ŋarrapi marrtji balayi ŋunhamala ga nhäma, ga ŋuli ŋarra yurru maḻŋ'marama yätjtja mirithirrinydja, ga ŋarranydja yurru dhunupa buwayakkumana warrpam'nha ŋunhiyi wäŋanydja.” ");
INSERT INTO gnn_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Ga dhäŋuru ŋuliŋurunydja märrma'yu ḏarramuyu gonha'yurruna ga marrtjina ŋunhimalayi yarrupthurruna Djudumlili wäŋalili, ga ŋayi Garraynydja nhinana ŋunhala bäyma maṉḏa Yipurayim. ");
INSERT INTO gnn_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Bala ŋayi Yipurayim waŋana Garraywala bitjarra, “Garray, nhaltjanna nhe yurru? . . . buma dhawar'maramana ŋamakurru'mirrinha ga yätjmirrinha yolŋu'‐yulŋunha rrambaŋikumana? ");
INSERT INTO gnn_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Mak ŋunha 50 yolŋu'‐yulŋu ŋamakurru'mirrinydja ŋunhayi Djudumŋuranydja, ga nhenydja yurru mukthun yana buma? ");
INSERT INTO gnn_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Nhepiŋga dhuwala mala‐yarr'yunaramirrinydja dhiyaku bukmakku wäŋawu, ga nhepiŋga ŋuli bitjandja liŋgu mala‐yarr'yun ga djäma dhunupa wal'ŋu yana. Yakana nhe yurru baymatthun ŋamakurru'mirrinhanydja dhambay‐manapan yätjmirriwalanydja.” ");
INSERT INTO gnn_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Ga Garraynydja waŋana, “Ŋuli ŋarra yurru maḻŋ'marama 50‐nha warray ŋamakurru'mirrinha yolŋu'‐yulŋunha, ŋunhinydja ŋarra yurru yaka warray wäŋa buma dhawar'marama.” ");
INSERT INTO gnn_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Bala yurruna Yipurayim waŋana bitjarra, “Garray, ŋarranydja dhuwala yolŋu yana, ŋarra bini yakaŋga nhuna bitjana waŋanha, yana bäy‐ḻakaraŋa ŋarraku. ");
INSERT INTO gnn_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Mak ŋunha 45 ŋamakurru'mirri yolŋu'‐yulŋu, bala nhaltjanna nhe yurru yulŋunydja?” Ga ŋayi Garraynydja buku‐ruŋiyinmaraŋala nhanŋu bitjarra, “Ŋuli yurru ŋarra ŋunhi maḻŋ'marama 45‐nhanydja, ŋarranydja yurru yaka buma ŋunhayi wäŋa.” ");
INSERT INTO gnn_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Ga ŋayi Yipurayim bitjarra yana liŋgu waŋana biyapul, “Garray, mak ŋunha 40 yolŋu'‐yulŋu ŋamakurru'mirri, yaka mak ŋula guḻku'.” Ga Garraynydja waŋana buku‐ruŋiyinmaraŋala nhanŋu, “Ŋuli mak 40, ga ŋarranydja yurru yakayi yana buma ŋunhayi wäŋa.” ");
INSERT INTO gnn_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","31","Ga biyapul Yipurayimdhu waŋana Garraynha bitjarra, “Garray, yaka ŋarraku maḏakarritjthiyanydja, ŋarra yurru waŋa nhuna biyapul. Mak ŋunha 30 yolŋu'‐yulŋu, mak 20 yolŋu'‐yulŋu manymakmirri.” Ga Garraynydja waŋana nhanŋu buku‐ruŋiyinmaraŋala bitjarra, “Ŋuli yurru 20 yolŋu'‐yulŋu ŋamakurru'mirri, ŋarranydja yurru yakayi buma ŋunhayi wäŋa.” ");
INSERT INTO gnn_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Ga biyapul Yipurayim waŋana, “Yaka ŋaramurryiyanydja ŋarraku Garray, ŋarra biyapul nhuna waŋana waŋganymirrina. Mak nhe yurru maḻŋ'marama ŋunha yolŋu'‐yulŋunha ŋamakurru'mirrinha märrma'‐rulu, ḻurrkun' ŋamakurru'mirrinydja yolŋu'‐yulŋu, bala nhe yurru nhaltjanna ŋunhiyinydja?” “Ŋuli yurru 10 miṯtji yolŋu'‐yulŋu ŋamakurru'mirri ŋunhayi Djudum nhina yukurra, ŋarranydja yurru yaka yana buma ŋunhayi wäŋa buwayakkuma,” ga bitjarra ŋayinydja Garraynydja waŋana. ");
INSERT INTO gnn_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Ga ŋuliŋurunydja dhurrwaraŋuru bala Garrayyunydja gonha'yurrunana marrtjinana, ga ŋayi Yipurayimdja roŋiyina balayi nhanukalayi wäŋalili. ");
INSERT INTO gnn_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Bala ŋunhiyinydja yana märrmany'tja djiwarr'wuy yolŋu maṉḏa marrtjinana‐wala yana bala Djudumlili, yurru balanyara yana rumbalnydja maṉḏa, bitjan yolŋu yana, ga bunananydja maṉḏa ŋunhala Djudumŋuranydja milmitjpana, ḻäy‐wilyunarayuna waluyu. Ŋayi Lottja nhinana‐dharrana galki dhurrwaraŋura ḻoḻuŋura ŋunhili wäŋaŋura buṉbu‐mäypamirriŋura, dharr‐way nhäŋala ŋayi ŋunhiyi märrma'nha yolŋunha maṉḏanha, maṉḏa nhinana lili marrtjina. Dhunupa ŋayi gaŋgathinana Lottja, bala yana gumurr'yurrunana maṉḏaku. Gumurr'yurrunanydja ŋayi ga bunana maṉḏaku, ");
INSERT INTO gnn_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","bala waŋanana maṉḏanha bitjarra, “Way maṉḏa, marrtjiyanydja maṉḏa ŋarrakala wäŋalili go. Nhuma yurru nhinanydja ŋarrakala gäthuranydja munhaku, ga goḏarrny'tja, bala nhuma boŋguŋu marrtjina.” Ga maṉḏanydja waŋana yaka'yurruna bitjarra, “Ŋilinyunydja yurru ŋorra dhiyala bili dhukarrŋura,” bitjarra. ");
INSERT INTO gnn_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Ga ŋayinydja Lottja waŋana dhä‐wuṉḏaŋarryina, “Yaka nhuma yurru ŋorra dhiyala. Nhuma yurru yana marrtjiya ga ŋunhala djinawa' ŋorriya ŋarrakala yana wäŋaŋura.” Ga yuwalkthi maṉḏa marrtjinana malthurruna Lotkuna bala nhanukalana wäŋalili. Ga ŋunhala maṉḏaku ŋathana gurrunhara walala Lotkala djämamirriyunydja walalay, bala maṉḏa ḻukana ŋathana yukurrana. ");
INSERT INTO gnn_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Ŋulinyaramirriyu liŋgu munhaku, yolŋu'‐yulŋunydja ŋurukuy wäŋawuy Djudumbuyŋunydja walala marrtjina lili, bala ḻiw'maraŋalana wäŋanydja ŋunhi Lotkunydja yuḏayuḏana ga ŋaḻapaḻmirrina ḏarramuwurru, walala yukurrana ḏuḏupthurruna wäŋanydja ŋunhi, wutthu'‐wutthurruna dhika, ");
INSERT INTO gnn_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","waŋana yatjurruna bitjarra, “Way Lot, wanhaka ŋunhi märrmany'tja yolŋu maṉḏa? Dhawaṯmaraŋa maṉḏanha lili go, ŋanapurru maṉḏaku ḏukṯuk,” bitjarrana yukurrana. Yo, ŋunhiyi Djudumbuynydja wäŋa mirithirrina yätjnha wal'ŋu, liŋgu walala yukurranha ŋuli ḏarramuwurru ḏukṯukthinyaminya walalawuy märranhaminyarawu walalaŋguway. Ga bitjanarawuyi yana walala ḏukṯukthina ŋurikiyinydja märrma'wunydja mulkuruwunydja yolŋuwu maṉḏaku. ");
INSERT INTO gnn_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Bala yana ŋayi Lottja dhawaṯthurruna, bala dhurrwarana dhaḻ'yurruna, ");
INSERT INTO gnn_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","ga waŋana walalanha bitjarra, “Way ḻundu walala, yaka walala biyaka. Yätj dhuwalinydja nhumalaŋgu, mirithirrina yätj. ");
INSERT INTO gnn_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Ŋarra yurru wekama nhumalaŋgu ŋarrakuway gäthu'mirriŋunha maṉḏanha miyalknhana maṉḏanha, yurru yakana ŋarra yurru wekama dhuwala märrma'nhanydja ḏarramunha maṉḏanha nhumalaŋgu. Maṉḏanydja dhuwala ŋarraku yolŋu maṉḏa bunana, ga djäka ŋarra yurru yukurra maṉḏaku ŋamathama.” ");
INSERT INTO gnn_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Yurru walalanydja ŋunhi ḏarramuwurrunydja mirithina ŋaramurryina, bala yiŋgathinana waŋana nhanukala Lotkalanydja bitjarrana, “Way, yol dhuwala nhe yolŋunydja? Mulkuru dhuwala nhe yolŋu be wanhaŋuwuy. Nhäku warray nhe yukurra waŋa ŋanapurrunhanydja nhaltjanarawu djämawu? Gatjuy yarrkthurrana ŋanapurruŋgala; ŋanapurru yurru nhunana djäma yätjkuma.” Bala yana walala ḏur'yurruna ŋunhiyinydja, walala bini ḏaw'yuna ŋunhiyi dhurrwaranydja buṉbunydja, bala yana märranha bini ŋunhiyi märrma'nhana yolŋunha maṉḏanha. ");
INSERT INTO gnn_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Yurru maṉḏanydja ŋunhi märrma'djiwarr'wuy maṉḏa waṉa‐djarryurruna, ga ḻaw'maraŋala Lotnhana, bala warryurrunana ŋanya lili djinawa'lilina, bala yana dhurrwarana dhaḻ'yurruna. ");
INSERT INTO gnn_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Bala maṉḏa ŋunhi Djudumbuyŋunhanydja yolŋu'‐yulŋunhanydja ḏarramuwurrunhanydja melnha bambaykuŋala, bala walala yakana dhurrwaranydja maḻŋ'maraŋala nhäŋala. ");
INSERT INTO gnn_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Bala ŋunhiyi ḏarramunydja maṉḏa, djiwarr'wuynydja maṉḏa waŋana Lotnha bitjarrana, “Ma' garryu'‐garryurrana nhuŋuway gurruṯu'mirrinhanydja walalanha, nhuma yurru gonha'yunna dhuwalanydja wäŋa, ");
INSERT INTO gnn_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","liŋgu ŋanapurru yurru bumana dhuwalanydja, buku‐yupmaramana wäŋanydja. Garrayyunydja liŋguna ŋäkulana dhiyakuy, ŋunhi nhaltjan yolŋuyu walalay yukurra djäma dhiyalami wäŋaŋura mirithirrina yätjnha, bala ŋayi ŋinyalanhana dhuwala djuy'yurrunanydja lili dhiyaku wäŋawu bunharawuna, buku‐yupmaranharawuna.” ");
INSERT INTO gnn_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Bala Lottja marrtjina ŋurikala märrma'walanydja ḏarramuwala maṉḏakala ŋunhi maṉḏa yurru Lotku gäthu'mirriŋunha maṉḏanha märrama, ga ŋayi waŋana maṉḏanha bitjarra, “Waḏutja dhä‐yawaṯthurrana, liŋgu Garrayyunydja yurru baymatthunna dhuwalanydja wäŋa.” Bala maṉḏanydja dharrana gitkitthunmina warray, yana bini ŋunhiyinydja ŋayi maṉḏanha ŋoy‐yawukinya. Yaka walala märr‐yuwalkthina nhanŋu. ");
INSERT INTO gnn_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Munhakumirrina djaḏaw'yunarayuna, bala djiwarr'wuynydja ŋunhi yolŋu maṉḏa waŋana Lotnhana, “Waḏutja gonha'yurrana dhuwala wäŋanydja. Märraŋa nhuŋuway miyalknhanydja ga gäthu'mirriŋunhanydja maṉḏanha, bala gundupuŋana, märr nhumanydja yurru yakana burakirri ŋunhi yurru dhuwalanydja wäŋa buku‐yupthun.” ");
INSERT INTO gnn_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Yurru ŋayinydja Lottja galŋa‐raypinydhina warray, yaka warray ŋayi waḏutja marrtjina. Yurru Garraynydja wuyurruna nhanŋu Lotku, bala ŋuriŋi djiwarr'puyŋuyunydja yolŋuyu maṉḏathu goŋnha walalanha mana'‐manapara waṉana, bala yana warryu'‐warryurrunana ŋuliŋuru dhawaṯmaraŋalana wäŋaŋurunydja ŋanya Lotnha ga nhanŋu miyalknha ga märrma'nha gäthu'mirriŋunha miyalknha maṉḏanha. ");
INSERT INTO gnn_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Ga ŋunhi walala dhawaṯthurrunana liŋguna warraŋullilina, maṉḏa djiwarr'wuynydja yolŋu maṉḏa waŋana bitjarrana, “Ma' gundupuŋana walala ganydjarryuna ŋunhamalana yaŋunhamalana; gundupuŋanydja bukulilina, märr nhuma yurru walŋathirrina. Yaka yana nhuma gulyurra gandarrŋura ŋoyŋura dhiyala bäyma, ga yaka nhäŋa roŋiyiya.” ");
INSERT INTO gnn_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","19","Yurru ŋayi Lottja waŋana bitjarra, “Yiw, ŋunha bukunydja dhuwala barrkuna bena‐wala; mak ŋarra ŋuli rakunydhina gandarrŋurana. ");
INSERT INTO gnn_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Nhäma nhe yukurra ŋunha yutjuwaḻa wäŋa gandarrŋuranydja gay, mak ŋarra ŋunhamalana yurru waḻukthun, märr ŋarra yurru walŋathirri ŋunhalayina.” ");
INSERT INTO gnn_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Bala djiwarr'puynydja yolŋu ŋunhi maṉḏa waŋana bitjarra, “Yo manymak. Ŋarra yurru yaka baymatthun ŋunhiyinydja wäŋa. ");
INSERT INTO gnn_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Yurru waṉḏiyanydja waḏutja. Ga ŋunhi nhuma yurru bunanydja ŋunhala wäŋaŋura, bala ŋarra yurru dhunupana baymatthunna dhuwalanydja wäŋa Djudumbuynydja.” Ga yäkunydja ŋayi ŋunhiyi wäŋa yutjuwaḻany'tja Djowana. ");
INSERT INTO gnn_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Bala ŋayi Lottja yana waṉḏinana, yana liŋgu ga mulkanydja ŋayi ŋunhi Djowanydja wäŋa ŋulinyaramirriyuna ŋunhi waluna marrtji lili dhawaṯthun. ");
INSERT INTO gnn_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Ga dhunupana yana ŋayi Godthunydja wutthurrunana baḏuwaḏuyurrunana ŋunhiyi märrma'nhanydja wäŋanha maṉḏaŋunha Djudum ga Gumura; gurthana yarrupthurruna beŋuru djiwarr'ŋurunydja lilinydja, guṉḏa manaparana be nhäna yana butjirina buŋgan. Yo, baduwaḏuyurruna yana warrpam'nha ŋunhiyi wäŋanydja maṉḏanha, ḻiw'maraŋala yana ŋunhiyi yulŋunydja. ");
INSERT INTO gnn_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Bukmakthina ŋunhi yolŋunydja walala murrmurryurruna, ga dharpa nhäranana warrpam'thurrunana yana. ");
INSERT INTO gnn_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Yo, ŋayipina Lotnha walŋathinanydja ŋunhalana wäŋaŋura yutjuwaḻa'ŋurana, yurru dhäykana nhanbala ŋunhili gandarrŋuranydja gulyurruna; ŋayi waṯthurruna roŋiyina Djudumbuynha nhäŋala wäŋa, bala ŋayi ŋulaŋuruyinydja yana monyguŋalana ŋanya, bala ŋayi dhäykanydja ŋunhiyi guṉḏayinana, bitjarrana bitjan wuṉḏaŋarr dje'la. ");
INSERT INTO gnn_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Ŋayi Yipurayimdja munhakumirri yana gaŋgathina, bala yana marrtjina bala bukulilina ŋunhimalana ḏuwaṯthurruna, ŋunhimalana liŋgu wäŋalili ŋunhi maṉḏa yawungu Garray nhina yukurra. ");
INSERT INTO gnn_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Bala ŋayi yarrupthurrunanydja nhäŋala ŋunhi Djudumbuynha; nhämanydja ŋayi ŋawulul'nha waŋganynhana, ŋayi marrtji ṉoluŋdhirri, bitjanna biyaku ŋuli gurtha marrtji nhäri borrk ŋula nhäna, ŋayi marrtji ŋawululny'tja ŋunhi dhawuṯthunna. ");
INSERT INTO gnn_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Yo, ŋayipi Godthu ŋunhiyi bumaranydja yätjnha wäŋanha Djudumbuynhanydja, yurru walŋakuŋalanydja ŋayi ŋanyana Lotnhana, liŋgu Godthu yukurrana guyaŋina ŋanya Yipurayimnha, ga yurruna ŋayi yakanydja bumara Lotnhanydja. ");
INSERT INTO gnn_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Bala ŋuliŋuruyinydja ŋayi Garrayyu goŋmirriyaŋalana ŋanya Saranha, rumbal yuṯakuŋalana, bitjarra yana liŋgu ŋunhi ŋayi dhawu'mirriyaŋala ŋäthili. ");
INSERT INTO gnn_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Bala ŋayi ŋunhi Sara yothumirriyinana, ga ŋuliŋuruyinydja ŋunhiyi yothu dhawal‐wuyaŋinana Sarawuŋu, nhanŋuwaynha Yipurayimguna gäthu'mirriŋu; ŋayi dhawal‐wuyaŋinanydja ŋuriŋi liŋgu waluyu ŋunhi Godthu dhawu'‐nherrara ŋäthili. ");
INSERT INTO gnn_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Bala ŋayi ŋanya Yipurayimdhunydja yäku nherrarana ŋunhiyi yothunhanydja Yitjaknha, ");
INSERT INTO gnn_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","ga ŋunhi ŋayi 8‐mirrinydja ḏaykun'mirri, bala ŋayinydja ŋanya mitthurrunana ŋunhiyinhayi yothunhanydja, bitjarra yana liŋgu ŋunhi Godthu ḻakaraŋala ŋäthili Yipurayimgala. ");
INSERT INTO gnn_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Ga ŋayinydja ŋunhi Yipurayimdja worruŋuna wal'ŋu, 100‐nha dhuŋgarra nhanŋu ŋulinyaramirriyunydja ŋunhi ŋayi yothu ŋunhi Yitjak dhawal‐wuyaŋina. ");
INSERT INTO gnn_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Ga ŋayi ŋunhi Saranydja ŋoy‐ŋamathina wal'ŋu wirrkina, bala waŋana bitjarra, “Godthunydja dhuwala ŋarranha wirrkina goŋmirriyaŋalana wal'ŋu, ga gitkitthunmaraŋala yana ŋarranha ŋoy‐ŋamathinyarayunydja ŋuriŋi. Ga ŋunhi yurru walala wiripu‐guḻku'yu yolŋuyu walalay ŋämanydja, walalanydja yurru bitjandhi bili goŋmirriyirriyi ga gitkitthundhi, wirrkina wal'ŋu goŋmirriyirri yurru dhiyaku yothuwu, ");
INSERT INTO gnn_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","liŋgu yolŋuyu walalay guyaŋina yanapi ŋarra bäyŋuna gänha yothu. Yurru dhuwalana ŋarra dhangi'yunna yukurra yothunydja, djäkana nhanŋu Yipurayimgalaŋuwu gäthu'mirriŋuwu, ŋunhi ŋayinydja dhuwala worruŋuna wal'ŋu.” ");
INSERT INTO gnn_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Yo, ŋayi ŋunhiyi yothu ŋutharanydja märr‐wakindhinana, ŋunhi yakana ŋayi biyapul yothu, bala ŋayinydja Yipurayimdhunydja ŋamaŋamayurruna ŋathana ŋula nhäna malanha, ḻuŋ'maraŋala yolŋu'‐yulŋunhana ŋurikiyina märr‐ŋamathinyarawu yothuwuna, liŋgu ŋunhiyinydja walalaŋgu rom. ");
INSERT INTO gnn_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Waŋganymirri maṉḏa yukurrana yothu maṉḏa ŋaḻwa'yurruna, waŋganydja ŋunhi yothu djämamirriwuŋu ŋurikiŋi Yaykawuŋu yäku Yitjmayil, ga wiripunydja Sarawu yothu Yitjak yäku, yurru ŋuriŋi djämamirriwalanydja yothuyu yukurrana warku'yurruna ŋunhi Sarawunydja yothunha. ");
INSERT INTO gnn_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Ga ŋayi Sarayunydja nhäŋala maṉḏanha ŋunhimalayi, bala maḏakarritjthinana wirrkina, bala waṉḏina, bala waŋana Yipurayimnhanydja bitjarrana, “Way Yipurayim, djuy'yurrana ŋunhanydja ya' djämamirriwunydja yothunha, ga ŋunha ŋäṉḏi'mirriŋunha. Djuy'yurrana maṉḏanha. Yakana ŋuruŋuyinydja djämamirriwalanydja yothuyu yurru märrama nhokuŋu ŋunhi buku‐meṉgunhara; ŋunhiyinydja yurru nhä malanha nhokuŋunydja bukmak nhanŋuway yana Yitjakkuna, ŋarrakalaŋuwuna yothuwu.” ");
INSERT INTO gnn_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Ga ŋuriŋinydjayi dhärukthu Yipurayimnhanydja wirrkina ŋayaŋu‐yätjkuŋala, liŋgu ŋunhiyi Yitjmayilnydja gäthu'mirriŋu nhanŋu; yaka ŋayi ḏukṯukthina djuy'yunarawu nhanŋu. ");
INSERT INTO gnn_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Bala ŋayi Godtja waŋana Yipurayimgala bitjarra, “Yaka warwuyurranydja ŋurikiyi yothuwu ga ŋäṉḏi'mirriŋuwu. Ŋarranydja yurru yana djäkayi maṉḏaku marrtji bala. Nhe yurru djuy'yurrana yana maṉḏanha, biyaka liŋgu bitjarra ŋunhi ŋayi Sara waŋana. Liŋgu dhawuny'tja ŋunhiyinydja ŋarra nherrara nhanŋuway yana Yitjakku; nhanukuŋunydja yurru ŋurikiŋinydja Yitjakkuŋunydja mala‐bunhara guḻku'thirriyi, ga ŋarrakuwaynha walala yurru malanydja yana. ");
INSERT INTO gnn_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Ga ŋayi yurru Yitjmayilyu wiripunydja mala‐bumayi guḻku'na yumurrku', wakinnha malanydja yurru nhanukuŋu, liŋgu ŋayinydja ŋunha gäthu'mirriŋuyi yana nhuŋu. Yurru djuy'yurrana‐wala yana nhe yurru maṉḏanha, liŋgu wäwundja dhuwala nhanŋuway yana Yitjakku.” ");
INSERT INTO gnn_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Ga wiripuŋuyuna munhakumirri waluyu ŋayi Yipurayim gaŋgathina, bala ŋayi märraŋala ŋathana malanha ga gapuna dhiṯthurruna ŋuriŋiyi gapuwuyyu bathiyu, bala ŋayi ḏiltjililina nhanukala Yaykawala ŋal'maraŋala ŋunhiyi bathinydja gapumirrinydja ga ŋathamirri. Ga biyapul ŋayi wekaŋala ŋunhi yothunha, bala djuy'yurrunana maṉḏanha gupaḏalnha‐wala. Bala maṉḏa marrtjinana yukurrana‐a‐a, wiripulili ga wiripulili, bitjarrana maṉḏa yukurrana marrtjinanydja ḏiltjikurruna ŋuliyina ŋanhdharkkurruna yäkukurru Biratjipakurru. ");
INSERT INTO gnn_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Bala ŋunhilinydja ŋayi gapunydja dhawar'yurrunana maṉḏaku, ga ŋayinydja ŋunhi yothunydja ŋanhdharkthina wirrkina, bala ŋayi ŋanya ŋunhiyi gäŋalanydja ŋuriŋiyi ŋäṉḏi'mirriŋuyunydja, bala yakurrkuŋala dhuḏililina dharpalili, ŋurrŋgitjlilina ŋunhina. ");
INSERT INTO gnn_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Ga ŋunhilina ŋayi ŋorrananydja nhinana, ga ŋayinydja marrtjina bitjarra bala märr‐galkilili muka, ga ŋunhilina ŋayi nhinananydja yukurrana, yarrkthurruna ŋuliŋuruyi yothuwalanydja, liŋgu ŋayi birrka'yurruna ŋäṉḏi'mirriŋuyunydja bitjarrana, märr ŋarra yurru yakana yothunhanydja ŋarrakuway nhäma rakunydhinyaranydja. Ga nhinananydja ŋayi yukurrana ŋunhiliyi ŋäthinana ŋäṉḏi'mirriŋunydja Yaykanydja. ");
INSERT INTO gnn_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Ga yothunydja nhanŋu ŋorrana nhinana dhuḏiŋura dharpaŋura, ŋäthina nhinana, bala ŋayi Godthunydja ŋäkulana ŋunhi rirrakaynha ŋanya ŋäthinyarana yothunhanydja. Bala ŋayi Godku ŋunhi dhäwu'mirrinydja waŋana ŋulaŋuru djiwarr'ŋurunydja bitjarra, “Way Yayka, nhäku nhe warwuyundja yukurra dhuwala? Yaka nhe wilwilyurra ga barrariya. Godthunydja ŋunha ŋanya liŋgu ŋäkula ŋunhayi yothunha ŋäthinyara. ");
INSERT INTO gnn_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Gaŋgathiyana ga ḻaw'maraŋa, märraŋa ŋanya; ga nhiniya galki nhanukala djäka nhanŋu. Nhanukuŋunydja yurru mala‐wunhara guḻku'yirri yana; yaka ŋarra ŋanya ŋunhayi yothunha yurru buku‐dhumukthirrinydja ga meṉgumanydja.” ");
INSERT INTO gnn_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Bala ŋayi waṯthunmaraŋalanydja Godthu ŋanya Yaykanha, ga dharr‐way nhäŋalana ŋayi ŋunhi gapunydja, ŋayi yukurrana buŋbuŋdhurruna beŋuru dhawaṯthurruna lili munatha'ŋuru. Bala ŋayi waṉḏinana, bala märraŋala ŋunhiyi bathi gapuwuynha; waṉḏinanydja bala dhiṯthurrunana, bala gäŋalana djunamana yothu'wuna, bala yana wekaŋalana ŋanya Yitjmayilnha. ");
INSERT INTO gnn_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Yo, dhäŋuru ŋuliŋuruyinydja maṉḏa marrtjina yukurrana bala‐a‐a, bala nhinana wäŋayaŋalana ŋanhdharkŋurana wäŋaŋuranydja, ŋayilpiŋurana yäkuŋura Barrannha, ga ŋunhiliyina ŋunhiyi yothu ŋutharanydja yukurrana‐a‐a, yana liŋgu ga wakindhina wal'ŋu ḏarramuthina. Ga bitjarrana liŋgu Godtja yukurrana nhanukala galkina, djäkana nhanŋu, ga ŋutharanydja ŋayi djambatj‐ḏumurruyinana wal'ŋu wäyinguna bunharawu. ");
INSERT INTO gnn_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Bala ŋayinydja ŋäṉḏi'mirriŋuyunydja nhanukala maḻŋ'thunmaraŋala dhäykanhana nhanŋu Yitjmayilwu, maṉḏa miṯtjinhana Yetjippuyŋunhana miyalknha, bala ŋayi märraŋala Yitjmayilyunydja dhäykanhanydja ŋunhiyina nhanŋuway. ");
INSERT INTO gnn_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Ga ŋulinyaramirriyunydja ŋayi yukurrana Yipurayim nhinana wäŋaŋura Bilitjiya yäkuŋura; nhinananydja ŋayi yukurrana‐a‐a märr‐weyinnha, ŋula nhämunha'na dhuŋgarra, bala ŋayinydja ŋanya Godthunydja gatjarr'yurrunana, yana maḻŋ'maranharawu nhanŋu Yipurayimgu, yolnha ŋayi yukurra märryu‐ḏapmarama ŋurruŋu, Godnha, mak ŋanya nhanŋuway gäthu'mirriŋunha Yitjaknha. Ga bitjarrana ŋayi ŋunhi ŋanya waŋana gatjarr'yurrunanydja gam'. Waŋganymirri ŋayi yäku‐ḻakaraŋala ŋanya Godthu, wäthurruna “Yipurayim,” bitjarra. “Gay, dhuwala ŋarra Garray,” bitjarra ŋayi Yipurayimdja. ");
INSERT INTO gnn_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Ga ŋayinydja Godtja waŋana Yipurayimgala bitjarra, “Märraŋa ŋunhiyi yothunha, nhuŋuway wal'ŋu ŋunhiyi waŋganynha gäthu'mirriŋunha Yitjaknha, ŋunhi nhe yukurra märryu‐ḏapmarama ŋanya wirrki, ga märr‐ŋamathirri nhanŋu. Märraŋa ŋanya, bala marrtjiyana maṉḏa ŋunhana wäŋalili yäkulili Morayalilina, ga ŋunhalayi bukuŋurana nhe yurru wekamanydja ŋanya ŋarraku mundhurrnydja, biyaka bitjan ŋuli yolŋuyu walalay bathan wäyin mundhurr ŋarraku. Bitjandhi nhe yurru wekamanydja ŋanya ŋarraku.” Bitjarrayi ŋayi Godtja waŋana gatjarr'yunarawunydja nhanŋu Yipurayimgu. ");
INSERT INTO gnn_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Ga munhakumirrinydja ŋayi gaŋgathina Yipurayim, bala marrtjina ga märraŋala ŋultjiŋu gurtha, ga ŋal'maraŋala wäyingalana ḏiltjilili. Ga biyapul yothunha ŋayi märraŋala ŋunhi, ga djämamirrinha maṉḏanha märrma'nhayi, ga ŋayipinydja gäŋala Yipurayimdhunydja goŋdhu ḻirrwi' gurtha ga mandjawak, bala walala marrtjinana. ");
INSERT INTO gnn_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Marrtjinanydja walala yukurrana bala‐a‐a, märrma' munhanydja, ga ḻurrkun'thinanydja ŋunhalayina, ŋayi nhäŋalana wäŋa galkithinyarana ŋunhi nhanukala ŋayi Godthu ḻakaraŋala ŋäthili ŋunhiyi wäŋa. ");
INSERT INTO gnn_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Bala ŋayi Yipurayim waŋana ŋunhi djämamirrinha maṉḏanha bitjarra, “Way maṉḏa. Nhumanydja yurru dhiyalana ŋi' galkun ŋinyalaŋgu, ga dhiyaku wäyingu djäka yukirriya maṉḏa. Ŋilinyunydja yurru marrtji ŋunha bukulili ya', ga ŋunhalayi ŋilinyu yurru buku‐ŋal'yun yukurra Garraywala, ga beŋuruyinydja ŋilinyu yurru roŋiyirrina lili nhumalaŋgala.” ");
INSERT INTO gnn_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Bala ŋayi ŋunhi Yipurayimdhu gurtha ŋultjiŋunydja märraŋalana, ga wekaŋala gäthu'mirriŋuwalana nhanukalaŋuwala Yitjakkalana, ga ŋayipinydja ŋunhina maṉḏanha gäŋala yukurrana mandjawaknha ga ḻirrwi'na, bala yana maṉḏa marrtjinana. Marrtjinanydja maṉḏa yukurrana bala‐a‐a, ga‐ga‐ga‐a‐a, ga gandarrŋura, ");
INSERT INTO gnn_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","bala ŋayi ŋanya nhanukala gäthu'mirriŋuyunydja waŋana bitjarrana, “Way mäḻu.” “Nhä gäthu marrkapmirri?” bitjarra ŋayi mäḻu'mirriŋunydja. Bala ŋayi yothuyunydja dhä‐wirrka'yurrunana waŋana bitjarra, “Dhuwala ŋultjiŋunydja gurtha, ga ḻirrwi' dhuwala ŋali yukurra gäma. Ga wanhaka dhika wäyindja ŋali yurru bathan mundhurrnydja Godku?” bitjarra ŋayi yothuyunydja dhä‐wirrka'yurruna. ");
INSERT INTO gnn_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Ga Yipurayimdja buku‐wakmaraŋala nhanŋu bitjarra, “Godthu yurru ŋayipi wekama,” bitjarra. Bala maṉḏa yänayi marrtjina. ");
INSERT INTO gnn_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Marrtjinana maṉḏa yukurrana, ga baṯ‐gay mulkana wäŋanydja, bala ŋayi Yipurayimdhu guṉḏana ŋal'‐ŋalmaraŋala botjaŋala, yana liŋgu‐u‐u ga liŋguna, ga ŋultjiŋu gurtha ŋal'‐ŋalmaraŋala ŋunhimala. Ga biyapul ŋayi yothunhanydja ŋunhi garrpira, bala rulwaŋdhurruna ŋunhimalayi gurthalili ŋultjiŋulilina, ");
INSERT INTO gnn_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","bala yikiny'tja märraŋala mandjawaktja, ga gathu muka ŋayi mar'yurruna ŋuriki yothuwu dharpunharawuna, ŋayi bini dharpunha nhanŋuwaynha ŋayi gäthu'mirriŋunha, mundhurrnha nhanŋu Godku. ");
INSERT INTO gnn_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Yo, mar'yurrunanydja ŋayi ŋurikiyi yothuwu, bala ŋayi ŋäkulana rirrakaynha, “Way Yipurayim, Yipurayim,” bitjarra ŋayi ŋunhi Garraywunydja dhäwu'mirri rirrakay waŋana djiwarr'ŋurunydja. Bala Yipurayimdja waŋana bitjarrana, “Gay'. Dhuwala ŋarra Garray,” bitjarra. ");
INSERT INTO gnn_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Bala ŋayinydja waŋana Godtja nhanukala bitjarra, “Yaka ŋanya wutthurra ga dharpuŋa, ŋula nhaltjarra yätjtjaŋa. Dhiyaŋunydja‐wala ŋarra marŋgithinana nhuŋu ŋunhi nhe märr‐yuwalkthirrina yukurra ŋarranha märr‐nherraṉmirrina manapan, ga ŋurruŋunydja nhe ŋuli yukurra nherraṉ ŋarranhana, liŋgu nhe yaka ŋayaŋuyu‐mulkana nhuŋuwaynydja ŋunhi gäthu'mirriŋunha waŋganynhanydja nhuŋuwayliliyaŋala, yana nhe ŋanya wekaŋalana ŋarraku.” ");
INSERT INTO gnn_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Bala ŋayi waṯthurrunanydja nhäŋala Yipurayimdhu, ŋayi dhärrana yukurrana wäyinnha bembina, gaṯmaranhara dhandurruŋ dharpalili. Bala ŋayi waṉḏinanydja, bala dharpuŋalana ŋunhiyi wäyinnhanydja, bala gäŋalana. Bala ŋayi ŋal'maraŋala ŋunhimalayi gurthalili ŋultjiŋulilinydja ŋunhiyina wäyinnhana, mali ŋanyanydja ŋunhi yothu'nhanydja nhanŋuway, bala bathara ŋunhiyina wäyinnhana mundhurr Godkunydja. ");
INSERT INTO gnn_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Ga ŋunhiyinydja wäŋa ŋayi yäku nherrara Yipurayimdhu ‘Garrayyu ŋuli yukurra wekama,’ bitjarrana. Ga dhiyaŋunydja‐wala yolŋu'‐yulŋuyu ŋuli yukurra waŋa ḻakarama bitjandhina, “Ŋunhalayi Garraywala bukuŋuranydja Garrayyu ŋuli wekamana yukurra ŋula nhä malanha ŋamakurru'.” ");
INSERT INTO gnn_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Bala ŋayi Garraywu dhäwu'mirri biyapul waŋana ŋanya Yipurayimnha beŋuru djiwarr'ŋuru, ");
INSERT INTO gnn_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","ŋayi waŋananydja bitjarra, “Bitjan ŋayi Garrayyu ḻakaramanydja yukurra nhuŋu. Ŋarra yukurra dhuwala dhäwuny'tja nhokala nherraṉ ŋarrakalaynha ŋarra yana yäkuyu. Ŋarranydja yurru nhuna ŋurruwuŋmirriyamana wal'ŋu, goŋmirriyamana yurru gäma yuwalkkumana, ḻatju'kumana yurru, liŋgu nhe ŋunhi wekaŋala nhuŋuway nhe gäthu'mirriŋunha ŋarraku, yaka nhe ŋayaŋuyu‐ḏapmaraŋala nhuŋuway nhe ŋanya ŋarrakalanydja. ");
INSERT INTO gnn_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Bala ŋarranydja yurru wekama nhuŋu guḻku'na yumurrku'nha yana; nhokuŋunydja mala‐wunhara yurru biyapulnha wal'ŋu dhaŋaŋnha, balanyarana bitjan ŋunha ya' ganyu' miṯtji garrwar, ga biyapul ŋunha munatha' raŋiŋura. Ga ŋuli yurru walala ŋula miriŋu nyäṉ'thun nhokalaŋuwu miṯtjiwu, nhokalanydja yurru miṯtjiyu djuḻkthunmaramana yukurra, bitjanna liŋguna yurru, liŋgu ŋarrana yukurra yurru walalanha gäma guŋga'yun. ");
INSERT INTO gnn_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Ga walala wiripu‐guḻku'yunydja miṯtjiyu ŋuruŋunydja yurru nhämana nhumalaŋgala ŋarrakuŋunydja ŋunhi goŋmirriyanhara, ga djäkawuy gänhara, bala walala yurru ŋäŋ'thunna ŋarranha bitjanarawuyina goŋmirriyanharawu walalaŋguwaynydja. Yo, yuwalk yana nhumalanha ŋarra yurru ŋurruwuŋmirriyamanydja yukurra, gäma yurru ḻatju'kumanydja dhikanydja wal'ŋu, liŋgu dhuwala nhe märraŋala yana ŋarranha dhäruk.” ");
INSERT INTO gnn_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Bala maṉḏa ŋuliŋuruyinydja marrtjina roŋiyinana ŋurikalana djämamirriwalana maṉḏakala, bala walala marrtjina roŋiyinana, ga nhinana ŋunhiliyina Biratjipana wäŋaŋura, ga ŋunhiliyina ŋayi Yipurayim nhinananydja yukurrana wäŋaraŋalana. ");
INSERT INTO gnn_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Ŋunhi walala yukurrana nhinana dhuŋgarra‐watjina bitjarra liŋgu, bala ŋayinydja ŋulinyaramirriyu Saranydja rakunydhinana, worruŋuna ŋayi wal'ŋu wirrkina, 100 ga 27‐mirrina dhuŋgarramirri, ");
INSERT INTO gnn_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","yurru ŋayi ŋunhiyi Sara rakunydhinanydja wäŋaŋuranydja Yiprun, ŋarakaŋura Gaynan. Ga ŋayinydja ŋunhi Yipurayimdja wirrkina yana warwuyurruna nhanŋu, nhanukalayŋuwu ŋayi miyalkkunydja. ");
INSERT INTO gnn_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","20","Bala ŋayi Yipurayimdhu märraŋala waŋgany wäŋa, bäyim rrupiyayu dholkunharawu nhanŋu ŋurikiyi miyalkkuna, mathirra ŋunhi yäku Makpila. Yo, ŋunhi wäŋanydja ŋayi märraŋala Yipurayimdhu ŋulaŋuru waŋganyguŋu yolŋuwuŋu ŋunhi ŋayi Yitpuyŋu yolŋu, ga ŋunhimalayina yäkulili mathirralili ŋayi ŋunhi ŋanya dholkuŋalanydja, nhanŋuway ŋayi miyalknhanydja, wäŋaŋura Gaynannha. ");
INSERT INTO gnn_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Ŋayi Yipurayimdja marrtjina worruŋuthinana, yurru ŋamathaŋala yana nhinananydja yukurrana ŋayi, ga ḻukunydja yana ŋayi yukurrana nhinana, liŋgu ŋayipina Godthuna guŋga'yurruna gäŋala yukurrana ŋanya. ");
INSERT INTO gnn_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","4","Waŋganymirriyunydja waluyu Yipurayim waŋana nhanŋuway wal'ŋu ŋunhi djämamirrinha bitjarra, “Nhenydja yurru marrtjiya bala ŋunha ŋarrakiyingala nininyŋulili wäŋalili, ga maḻŋ'maraŋa ŋunhiliyi miyalknha ŋula ŋarrakalaŋuwu gäthu'mirriŋuwu Yitjakku. Yaka nhe yurru djarr'yurra mulkurunhanydja miyalknha, dhiyakuynhanydja bäyma wäŋawuy Gaynanbuynhanydja. Djarr'yurranydja nhe yurru ga ŋunhiyi yana liŋgu ŋarrakuway wal'ŋu gurruṯu'mirrinha.” ");
INSERT INTO gnn_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Ga ŋayinydja ŋunhi djämamirrinydja nhanbala Yipurayimba waŋana, “Mak yurru miyalktja ŋula waŋa ŋarrakala yaka'yun ŋiniya, . . . yakana mak ŋayi yurru gonha'yun nhanŋuway wäŋanydja, bala marrtji dhipalanydja wäŋalili. Bay' nhaltjanna ŋarranydja yurru? Garr'yun nhuŋu gäthu'mirriŋunhana? . . . märr maṉḏa ŋuli ŋunhalana nhini yukirri?” ");
INSERT INTO gnn_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Bala Yipurayimdja waŋana nhanukala, “Yaka nhe biyakayi,” bitjarrana. “Yaka djaw'yurra ŋarraku gäthunha dhipuŋuru wäŋaŋuru, ");
INSERT INTO gnn_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","8","liŋgu Godthu ŋuriŋi Djiwarr'wuyyunydja Waŋarryu ŋayipi yana ŋarranha gäŋalanydja beŋuru ŋarrakalaŋuwala bäpawala ŋarakaŋuru wäŋaŋuru dhipalanydja gay' wäŋalili, ga ŋayipi yana dhawu'‐nherrara bitjarra, ‘Dhuwalanydja yurru nhuŋuna wäŋa, ga nhokalaŋuwu yumurrku'wuna, ga bitjanna liŋguna yukurra yurru gupaḏalŋuwuna nhumalaŋgu nhinanharawu yukurranharawu.’ Godthu yurru nhuŋu dhukarrnydja buma ŋathil'yun, märr nhenydja yurru maḻŋ'maramana dhäykanha ŋarrakalaŋuwu gäthu'mirriŋuwu. Ga ŋuli ŋayi yurru yakanydja marrtji dhipala, ŋunhiyinydja manymaknha, yaka warwuyurranydja, yurru yaka nhe yurru ŋarrakunydja gäthunha djaw'yurra dhipuŋuru wäŋaŋuru.” ");
INSERT INTO gnn_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Bala djämamirriyunydja ŋuriŋi dhawu'mirriyaŋala Yipurayimnha, ŋayinydja yurru dhäruk-märrama ŋanyapinyay yana Yipurayimnha, ŋunhi nhaltjarra ŋayi dhäruk‐nherraṉmina. ");
INSERT INTO gnn_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Bala yana ŋuriŋiyi djämamirriyu marrtjina ga märraŋala märrma' rulu wäyinnha walalanha gamulnha, bala wap‐wapmaraŋala ḻatju'mirri ŋanya dhika girri' ḏiltjililinydja walalaŋgala, bala marrtjinana yana. Marrtjinanydja ŋayi nhinana bala‐a‐a, ga‐ga‐ga‐ga‐a‐a, ga yana liŋgu baṯ mulkana wäŋa nhäyika, ŋunhi Näyu yolŋu yäku ŋuli yukurranha nhinanha be ŋäthili. ");
INSERT INTO gnn_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Bunananydja ŋayi ŋunhalayi gapumirriŋurana ŋunhi yukurra gapu maŋutji djingaryun, galki ŋunhina bäyma bala'mirriŋurana wäŋaŋura, yurru milmitjpana wal'ŋu, galkina walalanydja dhäykawurrunydja wäŋgamana marrtji lili gapuwuna dhiṯthu‐dhiṯthunarawu. ");
INSERT INTO gnn_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Bala ŋunhiliyinydja ŋayi Yipurayimgu djämamirri galkurrunana nhinana, ga bitjarrana ŋayi bukumirriyaŋalanydja yukurrana gam' ŋäŋ'thurruna. “Garray, Waŋarr Yipurayimgu, wuyurra nhanŋu ŋuruku Yipurayimgu, ga ŋarranhanydja guŋga'yurra biyakayi. ");
INSERT INTO gnn_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Dhuwalana ŋarra nhina yukurra, liŋgu galki yurru dhika dhäykawurrunydja bunana dhiyala gapuwuna märranharawu. ");
INSERT INTO gnn_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Ŋarra yurru waŋa ŋäŋ'thun gapuwu waŋganynha ŋula miyalknha, ga ŋuli yurru ŋayi wekamanydja ŋarranha, ga waŋa yurru ŋula biyapul bitjan, ‘Ŋay' ḻukiya nhe ŋäthilinydja, ga yurruna ŋarra yurru nhokalaŋuwu gamulwunydja walalaŋgu dhiṯthu'‐dhiṯthun nhina,’ bala yurruna ŋarra yurru marŋgithirrinydja, ŋunhiyina miyalktja nhokuŋuwaynydja wal'ŋu djarr'yunara ŋuruku Yipurayimgalaŋuwunydja gäthu'mirriŋuwu.” ");
INSERT INTO gnn_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Mukthurruna yana ŋayi yukurrana bukukurru waŋanaŋga, bala ŋayinydja marrtjina bunanana ŋunhi dhäykanydja, yäku Ripayka, gämanydja ŋayi marrtji lili botjuŋ gapuwuy. Ŋunhiyinydja dhäyka gäthu'mirriŋu Bithiyulwu, ga Bithiyulnydja ŋunhi walkur Näyuwu, maṉḏa‐yaŋara Yipurayim. ");
INSERT INTO gnn_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Yurru ŋayi ŋunhiyi dhäykanydja ŋanyana dhikana djana'mirrina wirrkuḻnha, ga ŋunhi ŋayi marrtjinanydja lili dhiṯthunarawu gapuwunydja, ");
INSERT INTO gnn_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","bala ŋayi ḏarramuyunydja ŋuriŋiyi waŋa ŋäŋ'thunna ŋanya, “Way, gapu ŋarranha wekaŋa go,” bitjanna. ");
INSERT INTO gnn_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Ga dhunupa ŋayinydja wekamana‐wala, “Ŋay' ḻukiyana,” bitjan, bala ŋayi wurkthunna. ");
INSERT INTO gnn_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Ga dhawar'yundja ŋayi, bala ŋuliŋurunydja Ripayka waŋa nhanukala bitjanna, “Ŋarra wäyinguna nhokalaŋuwu rarryu'‐rarryun ŋi', märr walalanydja yurru ḻuka yukurra dhaŋaŋdhiyana.” ");
INSERT INTO gnn_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","21","Ga bitjarrayina ŋayi Ripaykayu yukurrana yulŋunydja, ga ŋayinydja ŋuriŋi ḏarramuyunydja yukurrana yana nhäŋala murrŋa, liŋguna dharaŋarana wal'ŋu ŋayi, ŋurikiyina ŋunhi ŋayi ŋäŋ'thurrunanydja yukurrana. ");
INSERT INTO gnn_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Ŋunhi ŋayi dhawar'yurruna djämaŋurunydja ŋunhiyi miyalk, bala ŋayi ŋunhi ḏarramuyu mundhurrnha malanha galkara, bala dhaṯthurrunana ŋanya marrtjina, ŋopurrlili nherrara garwarrwarr bulayi. ");
INSERT INTO gnn_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Ga ŋuliŋurunydja ŋayi bala dhä‐wirrka'yurrunana ŋanya bitjarra, “Yolku dhuwala nhe walkurnydja? Nhina ŋanapurru yurru ŋi? . . . nhokalaŋuwala bäpa'mirriŋuwala wäŋaŋura.” ");
INSERT INTO gnn_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Ga ŋayi Ripaykanydja waŋana buku‐ruŋiyinmaraŋala bitjarra, “Ŋarranydja dhuwala gäthu'mirriŋu Bithiyulwu, ga bäpa'mirriŋunydja nhanŋu yäku Näyu. ");
INSERT INTO gnn_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Go malthurra ŋarraku. Ga ŋunhala nhe yukirriyanydja yurru, ŋanapurruŋgala wäŋaŋura.” ");
INSERT INTO gnn_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Bala yana ŋayi ŋunhiyi ḏarramunydja buku‐nyilŋ'thurruna, wokthurrunana Garraywuna, ");
INSERT INTO gnn_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","buku‐wekaŋalana wirrkina ŋuriki ŋunhi ŋayi Garrayyu gäŋala ŋanya dhunupa yana Yipurayimgalaŋuwala gurruṯu'mirriwala. ");
INSERT INTO gnn_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Ŋuliŋurunydja dhurrwaraŋuru bala ŋayi ŋunhi dhäykanydja waṉḏina wäŋalilina, bala yana ḻakaraŋala ŋäṉḏi'mirriŋuwana ga wäwa'mirriŋuwa Laypanba. ");
INSERT INTO gnn_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Ga ŋunhi ŋayi Laypandhu nhäŋala ŋopurrwuynydja girri', dhunupana ŋayinydja walmanana, bala yana marrtjinana ga maḻŋ'‐gay maḻŋ'maraŋala ŋunhiyinydja ḏarramunha, ŋayi yukurrana nhinana galki gapu‐maŋutjiŋura. ");
INSERT INTO gnn_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Maḻŋ'maraŋalanydja ŋanya ŋayi ŋunhi Laypandhu, dhunupa ŋayi waŋanana ŋanya, “Nhäku nhe yukurra dhuwala djingaryun dhiyalanydja bäyma? Go marrtjiyana lili. Ŋunha ŋarrakala wäŋanydja nhuŋu ŋorranharawunydja; guḻku' ŋunha dhaḻakarr nhuŋu ga nhokalaŋuwu wäyingu walalaŋgu.” ");
INSERT INTO gnn_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Bala yuwalkthi ŋunhiyi ḏarramunydja malthurruna Laypanbana, ga ŋunhala wäŋaŋuranydja ŋayi Laypandhu gapuna gäŋala nhanŋu djalkiriwuna ḻupmaranharawu, ga ŋatha ḻukanharawu. ");
INSERT INTO gnn_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Yurru ŋayi ŋunhi Yipurayimgu djämamirrinydja waŋana yaka'yurruna bitjarra gam', “Yäw yaka ŋathili ŋarra yurru ŋathanydja ḻuka, bulnha galkurra, liŋgu ŋarra ŋäthilinydja yurru dhäruk wekama nhumalaŋgu, ŋunhi ŋarra gäŋala lili.” Ga ŋayi Laypandja waŋana, “Ma' waŋiyana ḻakaraŋana,” bitjarra. ");
INSERT INTO gnn_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","49","Bala yana ŋayi waŋana ŋunhi yolŋu djämamirrinydja, ḻakaranhamirri bitjan, “Ŋarranydja dhuwala yolŋu Yipurayimgu djämamirri. Ŋayipi yawungu dhuwala ŋarranha yängumanydja lili dhipala Yipurayimdhu miyalkku märranharawu, ŋarra yurru maḻŋ'marama dhiyala miyalk nhanukalaŋuwu gäthu'mirriŋuwu Yitjakku. Ŋarra bukukurru waŋana yukurrana ŋunhala bäyma gapu‐maŋutjiŋura, bala Godthunydja yana gäŋala lilina nhuŋu yapa'mirriŋunhanydja dhuwali, ŋayi yukurrana djämanydja dhikana buta'kuŋalana, bitjarra yana liŋgu ŋunhi ŋarrapi yukurrana bukukurru waŋana. Bala ŋarranydja marrtjina dharaŋarana ŋanya nhäŋalanydja ŋunhimala, dhuwalayina liŋgu dhäyka djarr'yunara nhanukuŋuway Godkuŋunydja. Ŋarranydja ḏukṯuk ŋarra yurru djaw'yunna Ripaykanha ŋunhamalana wäŋalili, märr ŋayi yurru Yitjakkuna miyalk.” ");
INSERT INTO gnn_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","51","Bala maṉḏa Laypandja ga Bithiyulnydja dhunupa waŋanana, “Ŋe‐e bay',” bitjarra. “Manymak dhuwali. Ŋayi yurru marrtjina, malthunna nhuŋu bitjanna‐wala, liŋgu nhanukiyinguŋu dhuwala malanha, Garraywuŋu yana.” ");
INSERT INTO gnn_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Ŋuliŋurunydja dhurrwaraŋuru waŋanhaminyaraŋurunydja bala yana ŋunhi djämamirrinydja buku‐nyilŋ'thurruna, buku‐wurrparana yana Godnhana. ");
INSERT INTO gnn_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Ga biyapul ŋayi rarr'yurruna marrtjina mundhurrnha malanha, ḻatju'mirri malanha girri' ŋayi wekaŋalanydja marrtjina nhanŋu Ripaykawu, ga bitjarrayi liŋgu ŋayi rarr'yurruna mundhurr nhanukalaŋuwu wäwa'mirriŋuwu ga ŋäṉḏi'mirriŋuwunydja. Dhawar'yurrunanydja ŋuliŋuru, bala yurruna ŋayi ŋathanydja ḻukana, ga dhäŋuru ŋathaŋurunydja, ŋayi yukurrananydja ŋunhiliyi bäyma wäŋaŋura. ");
INSERT INTO gnn_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Yukurrananydja ŋayi, djaḏaw' way wiripuna walu, bala ŋunhi djämamirrinydja gaŋgathinana, gurku'yurruna marrtjinyarawuna, bala ŋayi dhä‐ŋäkula wäwa'mirriŋunha ga ŋäṉḏi'mirriŋunha, waŋananydja bitjarrana gam', “Ŋilinyunydja maṉḏa yurru marrtji gäthurana ŋi, roŋiyirrina yurru Yipurayimbana buna,” bitjarra. ");
INSERT INTO gnn_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Bala maṉḏanydja waŋana bitjarra warray, “Yäw, bulnha ŋäthili galkurra, märr‐gurriri, ŋula nhämunha' walu, ga yurruna ŋayi boŋguŋu marrtjinydja‐wala.” ");
INSERT INTO gnn_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Yurru ŋunhiyi ḏarramu djämamirrinydja waŋana bitjarrana, “Yaka nhuma gulmaraŋa ŋarranha. Yana yänguŋana‐wala ŋinyalanha bala Yipurayimgalana, liŋgu Garrayyu ŋarranha guŋga'yundja yawungu. Yaka biyapul ŋinyalanha roŋiyinmaraŋa,” bitjarra. ");
INSERT INTO gnn_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Bala maṉḏanydja waŋana, “Ŋilimurru dhä‐wirrka'yun ŋäthili Ripaykanha ŋi?” bitjarra. ");
INSERT INTO gnn_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Wäthurrunanydja maṉḏa nhanŋu Ripaykawu, bala maṉḏa ŋanya dhä‐wirrka'yurrunana, “Malthun muka nhenydja yurru? . . . dhiyakuyinydja ḏarramuwu?” bitjarra. Bala Ripaykanydja buku‐ruŋiyinmaraŋala waŋana, “Malthunna‐wala ŋarra yurru nhanŋu,” bitjarra. ");
INSERT INTO gnn_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","60","Bala yana maṉḏa yänguŋalana‐wala ŋanya Ripaykanha, liŋguna malthurrunana ŋayi ŋuripa ḏarramuwanydja. ");
INSERT INTO gnn_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Marrtjinanydja maṉḏa yukurrana weyinnha dhika, wäŋanydja ŋupara‐a‐a, djuḻk‐djuḻkmaraŋala ŋulana‐wala Gaynangurruna, yana liŋgu galki ŋunhalana wiripuŋurana gali'ŋura, yäkuŋura Nigip wäŋaŋura, ŋunhiyina wäŋa ŋunhi wanhaka Yitjak yukurrana nhinana. ");
INSERT INTO gnn_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Ga ŋulinyaramirriyu waluyu maṉḏanydja marrtji galki wäŋa ŋayathamana, ŋayi Yitjaktja dhawaṯthun, ");
INSERT INTO gnn_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","bala marrtji'‐marrtji ŋula baṉarra'kurruna, dhukarr‐nhäma'‐nhama, gumu'‐gumurryunna maṉḏaku, bala ŋayi bitjanna bala nhäma dharr‐way wäyinnha gamulnhana walalanha, walala marrtji wäŋgama lili withiyan ŋanya. ");
INSERT INTO gnn_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Ga ŋayinydja Ripaykayunydja nhämayi, ŋayi nhina Yitjaktja marrtji lili withiyan maṉḏanha, bala yana ŋayi yarrupthun gamulwalanydja ḏiltjiŋuru, wapthun munatha'lilina, ");
INSERT INTO gnn_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","ga yurruna dhä‐wirrka'yun ŋunhinha ḏarramunhanydja, “Yol ŋunhanydja gay' ḏarramu? . . . marrtji nhina lili?” bitjan. Ga ŋayi ŋunhi ḏarramunydja waŋa, “Ŋunhayina ŋarraku buŋgawa'mirriŋunydja, Yitjaktja,” bitjan. Bala yana ŋayi Ripaykayunydja märraŋala dhomala, bala bukuna ŋanyapinyay ŋayi ŋäkirrmaranhamirri. ");
INSERT INTO gnn_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Bala yana walala gumurr‐wunanharamirrina ŋunhiliyina, ga ḻakaramana yukurra nhanbala Yitjakpa djämamirriyunydja ŋuriŋi yolŋuyu, ŋurukuy ŋunhi ŋayi bitjan yukurra ŋunhala, ŋamathama yana. ");
INSERT INTO gnn_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Ŋuliŋurunydja ŋayi Yitjakthunydja märramana Ripaykanhanydja, bala gäma ŋanya ḏalwaḏalwa'lilina ŋunhimalana, ŋäṉḏi'mirriŋuwalana wäŋalili. Bala maṉḏa märranharamirrina. Ŋayi Yitjaktja wirrkina nhanŋu dhika mäḏapthurruna, bili nhanŋu ŋunhi miyalknha ŋayi. ");
INSERT INTO gnn_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","8","Yo, nhinananydja ŋayi yukurrana Yipurayim ŋunhili wäŋaŋura weyinnha, bala ŋayi worruŋuthinana mirithinana, bala ŋayi rakunydhinanydja 100 ga 75‐mirri dhuŋgarramirri. ");
INSERT INTO gnn_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","10","Bala maṉḏa nhanukala gäthu'mirriŋuyunydja maṉḏathu, Yitjakthunydja ga Yitjmayilyunydja dholkuŋalana ŋanya ŋunhimalayina mathirralili, waŋganylili yana ŋunhi ŋayi Yipurayimdhu dholkuŋala nhanŋuway miyalknha ŋäthili, ga ŋunhiwalayina maṉḏa ŋanyanydja dholkuŋala Yipurayimnhanydja, bäpa'mirriŋunhanydja maṉḏakuway maṉḏa. ");
INSERT INTO gnn_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Ga dhurrwaraŋuru ŋuliŋuruna ŋunhi ŋayi Yipurayim rakunydhina, bala ŋayi Godthunydja galkikuŋalana gäŋala ŋanyana yothunhana nhanŋu Yitjaknhana, liŋgu ŋunhiyi dhawu' ŋunhi ŋayi ŋäthili Godthu nherrara Yipurayimgala, nhanŋuway yana wal'ŋu Yitjakku ga nhanukalaŋuwu miṯtjiwu. ");
INSERT INTO gnn_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","18","Ga wiripunydja ŋunhi Yipurayimgu walkur‐maḻŋ'maranhara yäku Yitjmayil, wiripuŋuwuŋu warray miyalkkuŋu, djämamirriwuŋu warray, ŋayinydja mala bumara yumurrku'nha miṯtjinydja märrma'‐rulu ga märrma' bäythinyara, bala yana ŋayi rakunydhinana. Nhanukuŋu Yitjmayilwuŋu mala‐bunhara nhinananydja yukurrana ŋunhili wäŋaŋura Yetjipnha galki, yurru bitjana liŋgu walala yukurranha ŋuli mel‐nyaḻyunana ŋunhi wäwa'mirriŋunhanydja walalanha, marimirrina walala Yitjakkalaŋuwunydja miṯtjiwu. ");
INSERT INTO gnn_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","20","Yo, Yipurayimgunydja gäthu'mirriŋu Yitjaktja, nhanŋu dhuŋgarranydja 40‐na ŋulinyaramirriyuna ŋunhi ŋayi miyalknha märraŋala Ripaykanha, ");
INSERT INTO gnn_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","yurru dhalwaŋiny' ŋayi ŋunhi miyalktja, bäyŋu ŋayi ŋula yothuny'tja gurrukaŋala. Bala ŋayi Yitjak bukukurru waŋanana Godnha yukurrana, miyalkkunydja nhanukiyingalaŋuwu ŋäŋ'thurruna, ga Godthu ŋäkula ŋanya märrliliyanharanydja, bala dhunupa guŋga'yurrunana. Bala marrtjina ŋunhi miyalktja yothumirriyinana Ripaykanydja, ");
INSERT INTO gnn_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","yurru ŋurru‐märrma' yothunydja maṉḏa nhanukala, yurru bunharamirrina maṉḏa yukurra ŋunhi nhanukala guḻunŋuranydja. Bala Ripaykayunydja waŋa dhä‐wirrka'yun Garraynha bitjan, “Nhaltjan dhika marrtji yulŋunydja?” ");
INSERT INTO gnn_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Ga ŋayi Garrayyunydja ḻakarama nhanŋu bitjan. “Märrma' dhuwali nhokala malanydja wälkŋuranydja, märrma' yurru bäpurruny'tja dhawal‐wuyaŋirri nhokuŋu, yurru dhuwaliyi maṉḏa barrkuwatjthirri yurru yulŋunydja, mari‐winy'tjunmirrina walalaŋguway walala yukurra yurru. Waŋganydja yurru mala ganydjarr‐ḏilkurruna wal'ŋu, ḏälmirrina, ga wiripunydja mala yurru märr‐ganydjarrmiriwnha, ga ŋayi ŋurruŋunydja ŋunhi maḻamarrnydja yolŋu yurru djämamirri ŋuriki nhanŋu gutha'mirriŋuwu, ŋunhi ŋayi yurru dhuḏiŋu dhawal‐wuyaŋirri nhokuŋu.” Bitjarrayi ŋayi Garrayyu ḻakaraŋalanydja Ripaykawu dhä‐ŋäthiliŋga yana. ");
INSERT INTO gnn_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Walunydja galkithinana nhanŋu Ripaykawu, bala yuwalkthi yothunydja maṉḏanha dhawal‐wuyaŋinana ŋulinyaramirriyu, ḏarramu maṉḏa yulŋunydja. ");
INSERT INTO gnn_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Ŋurruŋunydja ŋunhi yothu dhawal‐wuyaŋina gulaŋ‐gulaŋ' ŋanak, ga rumbalnydja ŋayi bulka'mirri bukmak, bala maṉḏa yäkunydja nherrara ŋanya Yetju. ");
INSERT INTO gnn_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Ga ŋunhi ŋayinydja dhuḏiŋunydja dhawal‐wuyaŋina, ga mulkananydja ŋayi marrtjina ŋanya ŋurruŋunhanydja ga yaṯa, bala yäkunydja maṉḏa ŋanya nherrara Djaykupnha. Yo, Yitjakkunydja dhuŋgarra 60‐na, galki worruŋuyinana ŋayi ŋulinyaramirriyunydja ŋunhi yothu maṉḏa dhawal‐wuyaŋina. ");
INSERT INTO gnn_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Ŋutharanydja maṉḏa marrtjina bala wakindhina, ḏarramuyinana maṉḏa märrma' yana. Ŋayi Yetjunydja djambatj‐ḏumurruna wäyingu bunharawu; wirrki ŋayi yana ḏukṯuk wäyingunydja ḏatthunarawu. Ga ŋayi Djaykuptja wiripu warray ḏarramu, nhinanha warray ŋuli yukurranha ŋunhala bäyma wäŋaŋura. ");
INSERT INTO gnn_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Ga bäpa'mirriŋunydja maṉḏaku ŋuli yukurranha marrkapthuna wirrkinydja wal'ŋu Yetjuwuna, liŋgu bitjana liŋgu ŋayi ŋuli gänha wäyin nhanŋu. Ga ŋayi ŋäṉḏi'mirriŋunydja wokthuna ŋuli wirrkinydja ga nhanŋu Djaykupkuna. ");
INSERT INTO gnn_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Wiripuŋuyunydja waluyu ŋayi Yetjunydja marrtji wäyinlili, ga ŋayi Djaykuptja ŋunhala bäyma wäŋaŋura, bala ŋayi ŋathana bathan, ŋanya dhika ḻatju'na weyika, wuŋiḻinydja waŋgi'yun ŋunhiyi wanaŋinyamirrina. Ga ŋayi ŋunhi Yetjunydja roŋiyirrina beŋuru wäyinŋurunydja, bala ŋayi wirrkina djaṉŋarrthirri nhäma ŋunhiyi weyika'na, ");
INSERT INTO gnn_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","bala ŋäŋ'thun Djaykupnhana bitjan, “Ga' ŋarrakunydja wekaŋana. Ŋarra dhuwala djaṉŋarrthinana, raku'‐rakunydhirrina ŋarra marrtji dhuwala djaṉŋarrthinyarayuna.” ");
INSERT INTO gnn_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Ga ŋayi Djaykuptja waŋana bitjarrana, “Ŋäthilinydja nhe yurru dhawu'‐nherrala ŋathili ŋarranha, märr ŋarrapina yurru märrama bukmak nhä malanha nhokalaŋumirri yäkumirrinydja, ŋunhi mäḻu'yu yurru rarr'yun nhipala, bili nheŋga dhuwala ŋurruŋunydja nhanŋu gäthu'mirriŋu. Ḻakaraŋa ŋathili ŋäthilinydja, ga yurruna ŋarra wekamanydja yurru nhuŋu ŋathanydja.” ");
INSERT INTO gnn_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Ŋayi Yetjunydja waŋana, “Ma', nhuŋuwaynha bukmaknha yurru. Ŋarranydja ḏukṯuk ŋathawuna. Rakunydhirrina dhuwala ŋarra yurru,” bitjarra. ");
INSERT INTO gnn_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","34","Yo, bitjarrayinydja ŋayi Yetjuyu ŋula nhä ḻakaraŋala ŋunhiyi malanha, bäyŋuna ŋayi ŋula märr‐ḏikṯikthinanydja ŋurikiyi nhäkunydja malaŋuwu ŋunhi Godkuŋu dhawu'‐nherraṉara, yana ŋayi märr‐dhapinyayuna gonha'yurruna, bala dhayuŋara nhanbalaynha Djaykuppana. Bala Djaykupthunydja rarr'yurruna ŋathanydja ŋunhi dämba ga weyika nhanŋuwaynha Yetjuwuna. Ḻukananydja ŋayi Yetjuyunydja, bala ḏulputhinanydja, djunuma marrtjinana; yakana ŋayi guyaŋina ŋamathaŋalanydja Godkuŋu dhawuny'tja. ");
INSERT INTO gnn_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","15","Ŋe, yuwalkkuŋalana wal'ŋu Godthu gäŋala yukurrana guŋga'yurruna Yitjaknhanydja, ḻukunydjana yana ŋayi nhinana yukurrana, ga wäyindja nhanŋu dhaŋaŋnha dhika buliki ga gamul ga nanikut ga ŋula nhä wäyin, bena dhika dhaŋaŋnha. Ŋayipi Yitjak ga nhanbala miṯtji, djämamirri walala ga wiripu‐guḻku' yolŋu'‐yulŋu miṯtji, nhinananydja walala yukurrana wäŋaŋura yäkuŋura Gera, ga ŋunhalayi wäŋaŋura wäyindhunydja walalay ŋuli gapunydja ḻukanha ŋuliŋuru maŋutjiŋuru ŋunhi bäpa'mirriŋuyu nhanukala ŋangi'yurruna ŋäthili be. ");
INSERT INTO gnn_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","25","Ga wiripuŋuyuna munhayu, Godnha Garraynha maḻŋ'thun nhanukala Yitjakkala, bala waŋana yukurra nhanŋu bitjanna, “Ŋarranydja dhuwala God, ŋunhi muka bäpa‐ŋaliwu Yipurayimgu Waŋarr. Yaka nhenydja barrariya, bili ŋarranydja dhuwala nhokala galki. Ŋarra yurru nhuna gäma yukurra, guŋga'yundja marrtji bala, ga nhokuŋu yumurrkuny'tja yurru guwar‐yalkthunmirrina marrtji bala, mala‐guḻku'kunharamirrinydja biyapulnha dhaŋaŋnha; guŋga'yundja ŋarra nhuna yurru, bili Yipurayimnhanydja ŋarrakuway ŋunhi yolŋu.” Bitjarra Garraynydja waŋana Yitjakku. ");
INSERT INTO gnn_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Yo, Yitjaktja marrtjina wirrkina murrŋaram'thina, bala maŋutjinydja ŋayi marrtjina bambaythinana; yakana ŋamathaŋala nhäŋa'‐nhaŋala. Bala yana ŋayi wäthurrunana Yetjuwuna, maḻamarrwu walkurwu nhanukiyingalaŋuwu, bala waŋanana yukurrana nhanukala bitjarra, “Gäthu ŋarrala. ");
INSERT INTO gnn_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Ŋarra dhuwala murrŋaram'nha liŋguna, galki ŋarra yurru gananna nhumalanha, rakunydhirrina. ");
INSERT INTO gnn_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Märraŋa nhuŋuway gara malanha, bala marrtjiyana gatju, wäyinnha ŋarraku buŋa. ");
INSERT INTO gnn_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Ga bathan nhe yurru, bala gäŋana lili ŋarraku. Ŋarra yurru ḻukana nhokuŋu, ga dhäŋuru ŋathaŋurunydja, bala ŋarra yurru nhokala bukukurru waŋana; Garraywuŋuna dhäruk wekama yukurra nhokala, ŋunhi yurru nhaltjan ŋunhala bala yalala ŋamakurru' nhuŋu.” ");
INSERT INTO gnn_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Bitjarranydja ŋayi yukurrana waŋana Yetjuwala Yitjak, bala ŋayinydja gonha' Ripaykayunydja ŋäkula warray yukurrana. Ga yuwalkthi ŋayi Yetjuyunydja märraŋala garana, bala marrtjina wäyinlilina. ");
INSERT INTO gnn_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","10","Dhunupana ŋayi Ripaykanydja wäthun Djaykupkuna, “Djaykup, waḏutja go,” bitjan. “Ŋäkanydja nhe yurru ŋamathaŋa ŋarranha. Ma' marrtjiyana waḏutja, ga wutthurra wäyin nanikut maṉḏanha märrma', djana'‐ḏumurru maṉḏanha yana yulŋunydja, ga lili gäŋa ŋarrakala; ŋarra yurru bathan dhika djana'mirriyama, bala nhe yurru gäma mäḻu'wuna. Ḻukanydja ŋayi yurru, bala dhäŋuru ŋathaŋurunydja ŋayi yurru nhuŋuna wekamanydja Godnhanydja dhäruk, märr nhunana yurru Godthu guŋga'yundja.” ");
INSERT INTO gnn_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Yurru ŋayi Djaykuptja waŋana bitjarra warray gam', “Yurru ŋayi ŋunha wäwa'mirriŋunydja ŋarraku bulka'mirri warray rumbal, ga ŋarranydja dhuwala buyuwuyu warray yolŋu. ");
INSERT INTO gnn_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Mak ŋayi mäḻu'yunydja ŋarranha yurru mulka'‐mulkana, bala guyaŋirri ŋarranha yanapi ŋarra mayali'‐wilkthurru yukirri ŋanya. Ŋuli ŋayi yurru dharaŋandja ŋarranha, bala yurru ŋayinydja ŋarrtjunna ŋarranha ŋiniya . . . dhäruktja yurru wekama gonha ŋarraku yätjnha, yakana ŋula ŋamakurru'.” ");
INSERT INTO gnn_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Ga ŋayi ŋäṉḏi'mirriŋunydja waŋana buku‐wakmaraŋala bitjarra, “Yaka nhe warwuyurra. Ŋarrakuway yana mäkiri'‐witjurra. Gatjuy mukthurra yana marrtjiya, ga wutthurra wäyinnha maṉḏanha.” ");
INSERT INTO gnn_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Bala yuwalkthi Djaykuptja marrtjinana, bala wutthurrunanydja märrma'na wäyindja, bala gäŋalana lili, bala yana ŋäṉḏi'mirriŋuyunydja batharana dhika djana'mirriyaŋalana. ");
INSERT INTO gnn_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Ŋuliŋurunydja ŋayi Ripaykayu girri'na märraŋala Yetjuwana, bala dhaṯthurruna Djaykupnhana ŋuriŋiyi Yetjuwala girri'yunydja, ");
INSERT INTO gnn_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","ga bitjarrayi liŋgu ŋayi ŋunhi märraŋala nanikutnhanydja barrwaṉ, bala nherra'‐nhirrara Djaykupkala waṉalilina maṉḏanyŋulili ga mayaŋ'lili. ");
INSERT INTO gnn_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Bala ŋayi märraŋala ŋathana ŋunhi dhäkay‐djulŋina ga dämba, bala goŋlilina wekaŋala Djaykupkalana. “Ŋay', gäŋana mäḻu'wuna,” bitjarra ŋayi Ripaykayundja waŋana. ");
INSERT INTO gnn_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Bala ŋayi Djaykupthunydja warr‐way märraŋalana ŋunhi ŋathanydja, bala yana gäŋalana nhinana bala Yitjakkuna. Ŋunhalanydja ŋayi galkinydja, bala waŋanana “Ŋay' mäḻu,” bitjarra. Bala ŋayinydja waŋana lili nhanŋunydja, “Gay gäthu,” bitjarra. “Yol ŋuli nhe dhuwali gäthunydja ŋarraku?” ");
INSERT INTO gnn_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Ga Djaykuptja waŋana ḻakaranhamina, “Ŋarraŋga dhuwala Yetju, nhuŋu maḻamarr gäthu‐ŋali,” bitjarra. “Ŋay' dhuwalana ŋathanydja nhuŋu be, ŋarra nhuŋu gäŋalana lili, bitjarra nhe waŋana ŋarrakala. Ŋay'ḻukiyana, ga yurruna nhe Garraywuŋu dhäruktja yurru wekama ŋarraku.” ");
INSERT INTO gnn_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Yurru ŋayi Yitjaktja waŋana mukthurruna buku‐ḏuwaṯthurruna yukurrana bitjarra. “Nhaltjarra nhe waḏutjanydja märraŋala? . . . märr nhe waḏutjanydja roŋiyina dhuwala lili?” Bala ŋayinydja Djaykuptja waŋana buku‐ruŋiyinmaraŋala bitjarra, “Garrayyuŋga waŋarryu nhokala guŋga'yurruna ŋarranha, bala yurruna ŋarra bumara waḏutjanydja.” ");
INSERT INTO gnn_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Ga ŋayi bäpa'mirriŋunydja Yitjaktja waŋana bitjarra, “Go‐go lili giṯthurra dhipala galkilili, märr ŋarra yurru dharaŋan nhuna mulka'‐mulka. Yuwalk muka dhuwala nhe Yetju muka yulŋunydja?” Bitjarra ŋayi bäpa'mirriŋunydja waŋana. ");
INSERT INTO gnn_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Ŋayi Djaykuptja giṯthurruna märr galkilili, bala ŋayi mulka'‐mulkanana marrtjina baṉdjana maṉḏanha, baṯ‐gay mulkananydja bulka'mirri warray. Bala ŋayi waŋanana bitjarrana, “Rirrakaynydja dhuwala nhe bitjan Djaykup warray, yurru rumbalnydja dhuwala nhe ga bulka'mirri, Yetju warray mak nhe dhuwalanydja,” bitjarra. ");
INSERT INTO gnn_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Yaka ŋayi ŋuriŋi bäpa'mirriŋuyunydja dharaŋara wal'ŋu Djaykupnha, liŋgu ŋayi ŋanya mayali'‐wulaŋala nhawiyu ŋuriŋi bulka'yu nherra'‐nhirraṉarayu. Bala ŋayi ŋunhi bäpa'mirriŋunydja girri'ŋamathinana, gumurr‐ŋamathinana nhanŋuna. ");
INSERT INTO gnn_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Ga biyapul ŋayi buku‐ḏuwaṯthurruna waŋana, “Yuwalkka dhuwala nhe ŋayipiŋga Yetjuŋga yulŋunydja?” Ga ŋayinydja waŋana gäthu'mirriŋunydja nhanŋu, “Ŋe, ŋarrapiŋga dhuwala yuwalkŋunydja.” ");
INSERT INTO gnn_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Ga ŋayi Yitjaktja waŋana bitjarrana, “Go ŋathanydja nhe gäŋana lili, ga dhäŋuru ḻukanhaŋurunydja ŋarra yurru wekamana nhuna nhäwina. Yo, nhena yukurra yurru djingaryun ŋarrakalanydja dharapulŋura; nhe yurru ŋurruŋuna yukurra djingaryun Godkalaŋuwunydja miṯtjiwu yolŋu'‐yulŋuwu.” Bala yana Djaykupthu ŋathanydja ŋunhi gäŋalana mäḻu'mirriŋuwana, bala ŋayi ḻukanana ŋunhi wäyindja nhanukuŋu. ");
INSERT INTO gnn_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Ga dhawar'yurrunanydja ŋayi ŋunhi ḻukanhaŋurunydja, bala ŋayi bäpa'mirriŋuyunydja waŋanana ŋanya Djaykupnha bitjarra, “Go gilitjiya lili ŋarrakala gäthu.” ");
INSERT INTO gnn_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Bala ŋayi Djaykuptja marrtjina galkithinana, bala ŋayi bäpa'mirriŋuyunydja dhunupana waŋgi'yurrunana girri'na nhanŋu, ga yuwalkthi ŋunhi girriny'tja Yetjuwu warray. Bala ŋayi Yitjaktja waŋana dhäruknha nherrara nhanukala Djaykupkalanydja bitjarrana, ");
INSERT INTO gnn_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","“Godthu nhuna yurru guŋga'yundja wirrki yana, ga dhiyala munatha'ŋuranydja yurru wäŋaŋura ŋatha ŋuthan ḻatju'thirrina ga guḻku'na biyapulnha wal'ŋu nhuŋu. ");
INSERT INTO gnn_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Wiripunydja bäpurru' yolŋu'‐yulŋu buku‐nyilŋ'thunna yurru nhokala, ga walala yurru nhuŋunydja djämamirrina walala. Nhenydja yurru wal'ŋu ŋurruŋuyirrina nhokalaŋuwu wäwa'mirriŋuwunydja ga nhokalaŋuwu gurruṯu'mirriwu walalaŋgu; walala yurru bukmakthuna nhuŋu djämanydja yukurra. Godthu yurru guŋga'yundja ŋunhinha walalanha ŋunhi walala nhuna yurru guŋga'yun, gumurr‐wekama yurru lili nhuna, ga ŋunhi yurru nhuna wiripu‐guḻku'yunydja buku‐nherraṉ, ŋunhiyinydja Godthu yurru walalanhanydja buku‐nherraṉdhi.” Ga bitjarra ŋuriŋiyi murrŋaram'thu bäpa'mirriŋuyu wekaŋalanydja nhanukala yukurrana Djaykupkala dhäruktja, liŋgu ŋayi birrka'yurruna yanapini ŋunhiyi maḻamarr walkur nhanŋu Yetju yäku. Bala Djaykupthunydja gonha'yurrunana ŋanya mäḻu'mirriŋunhanydja, bala marrtjinana. ");
INSERT INTO gnn_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Yurru ŋayinydja bala marrtjina Djaykuptja, bala ŋayi Yetjunydja bunanana ŋulinyaramirriyu, ŋulaŋuru wäyinŋurunydja, gäŋalanydja ŋayi wäyin nhanukiyinguŋu djambatjpuynydja, ");
INSERT INTO gnn_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","bala yana batharanydja ŋayi wäyindja ŋunhi ḻatju'kuŋalana dhika, bala yana gäŋala bäpa'mirriŋuwana. Gäŋalanydja ŋayi bäpa'mirriŋuwanydja, bala waŋana bitjarra, “Ŋay', mäḻu gaŋgathiyana. Dhuwalana wäyindja ŋarrakuŋu djambatjpuynydja. Ḻukiyana nhe yurru, ga beŋurunydja ŋathaŋurunydja, bala nhe yurru dhäruknha wekaŋa Godkuŋuna ŋarraku.” ");
INSERT INTO gnn_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Ga mäḻu'mirriŋunydja ŋunhi Yitjaktja wirrkina ṉirryurruna dhika, bala gaŋgathinana, bala waŋana bitjarrana, “Way, yolŋga dhuwala nhe yulŋunydja?” bitjarra. Ga Yetjunydja buku‐ruŋiyinmaraŋala bäpa'mirriŋuwu bitjarrana waŋana, “Ŋarra muka be, nhuŋu maḻamarr gäthu'mirriŋu Yetju muka yäku,” bitjarra. ");
INSERT INTO gnn_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Ŋayi Yitjaktja bäpa'mirriŋunydja wirrkina dhika marrmarryurruna, wirrkina dhika ŋoy‐wiḻaŋ'thurruna manapara, bitjarra warwuyurrunana yukurrana wirrkina. “Liŋguna dhuwala ŋarra dhawar'yunmaraŋalanydja bay', liŋguna dhuwala ŋarra wekaŋalanydja be yolpana mak,” bitjarra. “Liŋgu gäŋala ŋayi ŋarraku ŋatha, bala ŋarra ḻukanana nhanukuŋu, bala ŋarra yukurrana bukumirriyaŋalana Godnha, wekaŋalana yukurrana ŋunhi dhäruknha nhanŋu Godkuŋu. Ga yuwalknha dhuwala yurru ŋanyana Godthu guŋga'yundja yukurra yurru bitjanna liŋguna, ga nhina yurru ŋayi ŋamathamana.” ");
INSERT INTO gnn_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Bala ŋayi Yetjunydja bena yatjurruna wirrkina dhika, “Mäḻu, ŋarrakunydja wekaŋana Godkuŋunydja ŋunhi dhäruk,” bitjarrana ŋayi yukurrana waŋana. ");
INSERT INTO gnn_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Ga ŋayi bäpa'mirriŋunydja waŋana nhanŋu, “Dhuḏitjnha dhuwala nhe bunananydja. Ŋayina gutha‐ŋalina marrtjina lili ŋarrakala, bala ŋayina märraŋalanydja ŋunha. Bala ŋarra wekaŋalanydja bukmaknha nhä malanha nhanukalana.” ");
INSERT INTO gnn_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Ga Yetjuyunydja waŋana ŋanya bala bäpa'mirriŋunha bitjarra, “Nhäna dhika nhe yurru ŋarranhanydja wekama?” ");
INSERT INTO gnn_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Ga ŋayi mäḻu'mirriŋunydja waŋana biyapul nhanŋu buku‐ruŋiyinmaraŋala, “Liŋguna dhuwala ŋarra ŋanyana ŋurruŋukuŋalanydja, ga bukmakthu nhanukala gurruṯu'mirriyunydja walalay yurru nhanŋuna yukurra djäma, ga ŋathanydja yurru nhanbala guḻku'thirrina.” ");
INSERT INTO gnn_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Bala Yetjunydja biyapul nyäy'‐nyayyurruna dhika waŋana, “Mäḻu wekaŋa yana ŋarranhanydja, ŋula waŋgany bäy ŋamakurru'.” Bala ŋayi ŋäthinana. ");
INSERT INTO gnn_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","40","Ga bäpa'mirriŋunydja waŋana nhanŋu bitjarra, “Mari yurru nhuŋu guḻku'thirrinydja, ga gutha'mirriŋuna nhuŋu yurru buŋgawanydja; nhe yurru nhanŋuna djämanydja. Yurru yalalaŋumirriyunydja nhe yurru yarryun nhanukala, bala yurru ŋurrkamana ŋanya, bala nhe yurru ganaŋ'thunna, nhepiyirrina yurru.” ");
INSERT INTO gnn_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Ga Yetjunydja wirrkina dhika maḏakarritjthina Djaykupkunydja, bala ŋayi waŋana bitjarra, “Galki mäḻuny'tja yurru dhuwala rakunydhirrina, bala yalalanydja ŋarra yurru dhuḏitjtja buma ŋarrakuway gutha'mirriŋunhanydja Djaykupnhanydja rakunyguna.” ");
INSERT INTO gnn_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Ŋayi ŋäṉḏi'mirriŋuyunydja ŋäkula yukurrana ŋanya dhäruk Yetjunha, bala wäthurruna nhanŋu Djaykupkuna, bala waŋana nhanukala Djaykupkala bitjarrana, “Way, ŋunha yukurra ḻiya‐ŋamaŋamayunmirrina wäwa'mirriŋunydja nhuŋu bunharawuna rakunygunharawuna. ");
INSERT INTO gnn_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Nhe yurru gananna dhuwalanydja wäŋa ga marrtjiyana‐wala waḏutjana yana Yaranlilina wäŋalili, märr nhe yurru nhiniya yukirriya ŋunhalana wäwa'mirriŋuwalana ŋarrakalaŋuwala Laypangalana. ");
INSERT INTO gnn_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","45","Nhiniyanydja nhe yukirriya ŋunhala yana bili, ga gonha yurru ŋayi wäwa‐ŋali dhuwala yal'yun nhuŋu, ga yurruna ŋarra yurru dhäruktja djuy'yunmirri, märr nhe yurru roŋiyirrina lili.” ");
INSERT INTO gnn_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Bala ŋayi Ripaykanydja marrtjina Yitjakkalana, ga waŋana ŋanya bitjarra, “Yetjuyunydja dhuwala liŋguna märraŋala miyalknha dhiyakuynhana wäŋawuynha. Yaka ŋarranydja ḏukṯuk ŋayi yurru Djaykupthunydja ŋawatthun miyalknha dhiyakuynhanydja, liŋgu dhuwalayinydja dhäykawurru yakana walala marŋgi Godku.” ");
INSERT INTO gnn_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Bala ŋayi murrŋaram'tja ḏarramu Yitjaktja yäku wäthurrunana nhanŋu Djaykupku lili, bala waŋana nhanukala dhäruk‐nherrarana bitjarra, “Yaka yana nhe yurru märrama dhiyakuwuynha wäŋawuynha miyalknha, Gaynanbuyŋunhanydja bäpurru'nha. ");
INSERT INTO gnn_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Balayi nhe yurru marrtji roŋiyirriyi ŋunhiwala ŋathiwala Yaranlili, makarrlili Mitjapatamiyalili, ga ŋunhilina nhe yurru maḻŋ'marama dhäykanhanydja, gäthu'mirriŋunha nhokalaŋuwu ŋapipi'mirriŋuwu Laypangu, ŋanyana nhe yurru ŋunhiyina märraŋanydja. ");
INSERT INTO gnn_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Godthu yurru nhuna guŋga'yundja, bala nhe yurru bäpa'mirriŋuyirrina guḻku'wuna bäpurru'wunydja dhika, guwar‐ŋurrkamana nhe yurru dhaŋaŋnha miṯtjinydja. ");
INSERT INTO gnn_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Godthu yurru nhuna gäma ḻatju'kuma marrtji bala, bitjan yana liŋgu bitjarra ŋayi yukurrana gäŋala nhuŋu märi'mirriŋunha Yipurayimnha. Ŋayi yurru Godthu nhuŋuna wekamanydja dhuwalanydja wäŋa ŋunhi ŋayi dhawu'‐nherrara nhanŋu Yipurayimgu.” ");
INSERT INTO gnn_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Bitjarrayi ŋayi Yitjakthu djuy'yurrunanydja‐wala Djaykupnha. Djar'tjar‐way ŋayi Djaykuptja, gonha'yurrunana nhanŋu ŋunhi ŋäṉḏi'mirriŋunhanydja. ");
INSERT INTO gnn_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Djar'tjar‐way ŋayi Djaykuptja gonha'yurrunana Biratjipaŋunydja wäŋa bala Yaranlilina wäŋalili, yurru barrkuna bena‐wala wäŋanydja ŋunhi. ");
INSERT INTO gnn_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Marrtjinanydja ŋayi yukurrana yana liŋgu gandarrŋuranydja munhakuyinana nhanŋu, bala ŋayi ŋorranana ŋunhili gandarrŋuranydja; guṉḏanydja ŋayi märraŋala, gurrunharanydja, bala muḻkurr‐wurruŋalana ŋunhimala. ");
INSERT INTO gnn_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Ŋorranana ŋayi yukurrana yakurrnha, bala ŋayi marrtjina bukaway'yinana, nhäŋala ŋayi bukaway'kurrunydja, ŋunhili liŋgu yukurrana dhärrana ŋal'‐ŋalyunaramirri dhukarr ŋuliŋuru liŋgu ŋunhi wanhami ŋayi yukurrana ŋorrana, bala djiwarr'lili. Ga ŋuliwitjarra gatjaḻkurrunydja Godku djiwarr'wuy yolŋu'‐yulŋu wäŋgaŋala dharrana, bala ḏuwa'‐ḏuwaṯthurruna ga lili yarru'‐yarrupthurruna, bitjarra yukurrana. ");
INSERT INTO gnn_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Ga ŋayipinydja Garraynydja ga ŋunhili bäyma nhanukala Djaykupkala yana nyeyalŋura yukurrana djingaryurruna, ga waŋananydja ŋayi Djaykupkala bitjarra, “Ŋarranydja dhuwala Garray muka, waŋarr nhokalaŋuwu märi'mirriŋuwu Yipurayimgu ga nhokalaŋuwu bäpa'mirriŋuwu Yitjakku waŋarr. Ŋarra yurru wekama dhuwalanydja gay wäŋa, dhuwala nhe yukurra ŋorra nhuŋuway ga nhokalaŋuwu malawu. ");
INSERT INTO gnn_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Nhipala yurru malanydja gaŋdhunna wirrkina wal'ŋu dhaŋaŋdhirrina, ga yothu yurru nhokala yarraṯaŋuru maḻŋ'thun ŋunhala bala yalala, ga ŋuliwitjan nhanukalaŋukurruna ŋarra yurru walŋakuma bukmaknhanydja miṯtjinha. ");
INSERT INTO gnn_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Ŋarranydja dhiyalami nhokala bitjan liŋgu ga wanhawitjan nhe yurru marrtji. Ŋarrapi yurru nhuŋu goŋ‐nherraṉmirrinydja, ga ŋarrapi yurru nhuna roŋiyinmarama dhipalanydja wäŋalili. Yaka ŋarra yurru nhuna ganandja; ŋarra yurru djämanydja‐wala bitjan yana liŋgu ŋunhi ŋarra nhaltjan yukurra dhäwu'‐nherraṉmirri nhokala.” Ga bitjarra yukurrana Garray waŋana ŋunhili Djaykupkala bukaway'kurrunydja. ");
INSERT INTO gnn_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Ŋayi Djaykup gaŋgathinanydja yakurrŋuru, bala waŋanana bitjarra, “Garray muka dhuwala yulŋunydja dhiyalaminydja. Dhuwalayi nhanŋuway muka wäŋanydja, yurru ŋarra dhuwala yaka marŋginydja.” ");
INSERT INTO gnn_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Wirrkina ŋayi beyaṉiyinanydja, bala ŋayi waŋanana, “Dhuwalanydja dhuwala wäŋa dhuyuna ŋiniya? . . . gänaŋuna nhanŋuwaynha Godkuna wäŋa. Dhuwalanydja wäŋa dhurrwara djiwarr'nha.” Ga bitjarra ŋayi Djaykup nhinana waŋananydja. ");
INSERT INTO gnn_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Bala ŋayi gaŋgathinana ḏuḏurr‐way; gaŋgathinanydja ga ḻaw'maraŋala ŋunhi guṉḏanydja ŋunhi ŋayi ḻiya‐gurruŋala yukurrana ŋunhimala, bala nherrarana ŋunhiyi guṉḏa, bala ŋayi weyikany'tja guryunmaraŋala ŋunhimala guṉḏalilina. Bala ŋayi buku‐ŋal'yurrunana, märr‐ŋal'yurruna Godkuna. ");
INSERT INTO gnn_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Ga yäku‐nherraranydja ŋayi ŋunhiyi wäŋanydja Bithulnha, ŋunhinydja mayali' bitjan Godku buṉbu. ");
INSERT INTO gnn_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Ga ŋayi Djaykuptja waŋana dhäruk nherraṉmina, wäwun‐nherraṉmina Garraywalanydja bitjarra, “Ŋuli nhe yurru yukurra yuwalkkuma djäka ŋarraku, ga marrtji galki ŋarrakala, gunganhamirriyama ŋarranha ga wekama ŋarranha yukurra yurru ŋayaŋay'yu ga girri'yu, ");
INSERT INTO gnn_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ga ŋuli nhe yurru roŋiyinmarama ŋarranha balayi bäpawala ŋarrakalaŋuwala wäŋalili, ga yurruna ŋarra yurru nhuŋu märr‐ŋal'yundja, ga nhepina yurru ŋarraku waŋarrnydja. ");
INSERT INTO gnn_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Dhuwalanydja wäŋa bitjan nhuŋuwaynha God, ŋanapurru yurru dhiyalanydja buku‐ŋal'yun nhuŋuwaynha yukurra yanana, bala ŋarra yurru barrkuwatjkumanydja gulk‐gulkthundja 10‐gumana nhuŋunydja, bukmak yana ŋunhi nhe yurru wekamanydja ŋarraku.” ");
INSERT INTO gnn_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Djaykuptja ŋayaŋganynha yana marrtjina yanana liŋgu‐u‐u bur‐way ŋunhala Yarannha wäŋaŋura, ");
INSERT INTO gnn_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","dharr‐way nhäŋala ḻurrkun'nha wäyin‐djäkamirrinha walalanha, walala yukurrana wäyingu djäka ŋunhili. ");
INSERT INTO gnn_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Walalanydja yukurrana ŋunhi galkurruna wiripu‐guḻku'wu djäkamirriwu walalaŋgu ŋunhiliyi gapuŋura maŋutjiŋura, märr yurru walala ḻaw'yunmarama ŋunhiyi guṉḏa, ga guryunmarama gapu yukurra ŋuriki wäyingu walalaŋgu wekanharawu. ");
INSERT INTO gnn_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Bala ŋayi Djaykupthu dhä‐wirrka'yurrunana walalanha waŋana bitjarra, “Wanhaŋuwuy walala dhuwala nhuma yulŋunydja?” Ga walalanydja ḻakaranhamina, “Ŋurukuwuy Yaranbuy,” bitjarra. ");
INSERT INTO gnn_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Ga ŋayi dhä‐wirrka'yurruna bala walalanha, “Marŋgi muka nhuma Laypangunydja?” bitjarra. “Ŋe, marŋgi ŋanapurru nhanŋu,” bitjarra walalanydja waŋana. ");
INSERT INTO gnn_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","8","Ŋayi waŋananydja Djaykup, dhä‐wirrka'yurrunanydja bitjarrayi, “Ŋamakurru' ŋayi yulŋunydja?” “Ŋe, manymak ŋayi yukurra nhina ŋunha. Ga nhäŋana dhuwala nhanŋu gäthu'mirriŋunydja ya', marrtji nhina lili Raytjulnydja, dhuwalana ŋayi gäma yukurra wäyinnha mutpunuma gapuwuna ḻukanharawu.” ");
INSERT INTO gnn_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","10","Ŋunhi ŋayi Raytjul bunananydja ŋunhili walalaŋgu, bala ŋayi Djaykupthunydja guṉḏana ḻaw'maraŋala, ḻapmaraŋala gapuwuna, bala ŋayina gapunydja dhiṯ‐dhiṯthurruna yukurrana rarryu'‐rarryurruna Raytjulwalaŋuwunydja wäyingu walalaŋgu. ");
INSERT INTO gnn_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Bala ŋayi ŋuliŋurunydja Djaykupthu wälkuŋalana ŋanya Raytjulnha, nyäy'‐nyayyurrunana marrtjina dhika wiṯthurrunana, goŋmirriyinana nhanŋu. ");
INSERT INTO gnn_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","“Ŋarranydja dhuwala Djaykup muka, Ripaykawu waku'mirriŋu, ŋuriki ŋunhi ŋayi yapa'mirriŋu nhokalaŋuwu bäpa‐ŋaliwu.” Ṉaŋ'‐gay ŋayi Raytjulnydja, wäŋalilina ṉaŋ'thurruna bala, ga ḻakaraŋala Laypanguna. “Way mäḻu, dhuwalana nhuŋu waku'mirriŋunydja bunana,” bitjarra. ");
INSERT INTO gnn_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Dhunupa ŋayi Laypandja walmana, bala ṉaŋ'thurrunana, gumurr'yurrunana nhanŋu Djaykupku, bala mulkana ŋanya dhangi'yurrunana, wälkuŋala, bala gäŋala nhanukiyingala wäŋalilina ŋanya. Bala ŋayi Djaykupthu ŋäthilinydja ḻakaraŋala yukurrana ŋunhi nhaltjarra yukurrana ŋunhala bala ŋäthili. ");
INSERT INTO gnn_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Ga ŋayi Laypandja waŋana nhanŋu, “Yuwalknha dhuwalanydja nhenydja dhuwala ŋarrakuwaynha galkiwuynha gurruṯu'mirri. Ga nhiniyana dhiyalana ŋarrakalana,” bitjarra. Bala ŋayi yukurrana Djaykup nhinananydja ŋunhilina bili nhanukala ŋaḻindi‐ŋuparana, ga djämana ŋayi yukurrana ŋunhilina, guŋga'yurrunana ŋanya Laypannha. ");
INSERT INTO gnn_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","17","Yo, Laypangu gäthu'mirriŋunydja maṉḏa wirrkuḻ maṉḏa märrma'; maḻamarrnydja yäku Liya ga gutha'mirriŋunydja nhanŋu yutjuwaḻany'tja Raytjul yäku. Ŋayinydja Liyanydja märr‐gaŋga ya' ḻatju', yurru ŋayi Raytjulnydja biyapulnha dhika djana'mirri, ḻatju'na dhika miyalk. Yo, Djaykupthu yukurrana djämanydja ŋaḻindi‐ŋupara nhanŋu Laypangu, yurru ŋayi bäyŋu ŋula märraŋala rrupiyanydja yukurrana ŋurikiy djämawuy. Bala ŋayi waŋanana Laypandhu ŋanya Djaykupnha bitjarrana, “Way, yaka dhuwala ŋamakurru' bitjanarawunydja, birrka' nhe yukurra djäma yurru ŋunhi nhe ŋarraku gurruṯu'mirrinydja. Nhäku nhe ḏukṯuktja? Nhä ŋarra nhuŋu yurru wekamanydja dhiyakuwuy djämawuynydja ŋunhi nhe ŋarraku yukurra djäma?” Bitjarra ŋayi Laypandhunydja. ");
INSERT INTO gnn_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Ŋayi Djaykuptja wirrkina yukurrana märr‐ŋamathina nhanŋu Raytjulwunydja; ŋayi djälthina märranharawuna nhanŋu, ŋayi yurru nhanŋuna miyalk, bala ŋayi buku‐ruŋiyinmaraŋala nhanŋu Laypangu bitjarrana waŋana, “Yana ŋarra yurru djämana yukurra nhuŋu dhuŋgarranydja ŋupan 7, ga ŋunhina bilina, yurruna nhe yurru ŋarraku Raytjulnhana wekamanydja, märr ŋayi yurru ŋarraku miyalknha.” ");
INSERT INTO gnn_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","“Manymak dhuwalinydja,” bitjarrana ŋayi Laypandja waŋana. “Nhiniya dhiyalana ga djämana yukirriya, ga ŋayina yurru nhuŋu miyalktja.” ");
INSERT INTO gnn_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Ga yuwalkthi ŋayi Djaykupthu djämanydja yukurrana weyinnha dhika, 7 dhuŋgarra ŋupara, baman'nha dhika weyinnha, yurru bitjarra gurririyinana nhanukalanydja ŋunhi Djaykupkalanydja, liŋgu ŋayi märr‐ŋamathina yukurrana wirrki Raytjulwu. ");
INSERT INTO gnn_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Liŋguna dhuŋgarra 7‐dja djuḻkmaraŋalana, bala yana Djaykupthu waŋanana Laypannha bitjarra, “Liŋguna dhuwala walunydja djuḻkthurrunana, nhe yurru wekaŋana Raytjulnhanydja ŋarrakuna, märr ŋarra yurru märramana ŋanya, bitjandhiyi bili ŋunhi ŋali yukurrana waŋanhamina ŋäthili.” ");
INSERT INTO gnn_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Bala ŋuliŋurunydja Laypandhu ŋathana marrtjina gurrunhara ŋäthilimirriyaŋalana, ḻuŋ'thunmaraŋala yolŋu'‐yulŋunhanydja ŋunhimalana gumurr‐ŋamathinana märranharaminyarawuna, goŋmirriyinyarawuna ŋurikina ŋunhi maṉḏa yurru märranhamirrina, ŋayi yurru märramana ŋunhiyi miyalknha. ");
INSERT INTO gnn_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","24","Yurru ŋayi Laypandhu mayali'‐waŋala Djaykupnha yulŋunydja, yaka warray ŋayi wekaŋala nhanbala Raytjulnhanydja; ŋayi märraŋalanydja ŋurruŋunha warray maḻamarrnha yäkunha Liyanha warray ŋunhi, bala gäŋala wekaŋalanydja Djaykuppa ŋuriŋiyi munhakunydja, yurru bukunydja ŋayi ŋäkirrmaranhamina ŋanyapinya ŋayi, liŋgu ŋunhinydja rom walalaŋgu yukurrana djingaryurruna. Ŋayi Djaykupthunydja yaka ŋanya nhäŋala buku; ŋayi guyaŋina yanapi ŋunhi Raytjul. Bala Djaykupthu märraŋalana ŋanya liŋguna, maṉḏa märranhaminana. ");
INSERT INTO gnn_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Ga goḏarr'nha djaḏaw'yurruna, bala nhäŋala marrtjina wiripu warray, Liyanha warray ŋayi märraŋalanydja ŋunhi. Djaykuptja yaka galŋa‐ŋamathina, wirrkina ŋayi maḏakarritjthinanydja, bala waŋana Laypannhana, “Nhäku nhe ŋarranha maŋutji‐waŋala bitjarrayinydja? Ŋarra yukurrana nhuŋu dhiyala baman'ŋumirri djäma weyindja, märr ŋarra yurru märrama Raytjulnha, bala nhenydja marrtjina wekaŋala ŋarraku wiripunha warray.” ");
INSERT INTO gnn_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Bala ŋayi Laypandhu waŋana Djaykupnha bitjarrana, “Dhuwalanydja rom muka ŋanapurruŋgu. Ŋäthilinydja ŋuli ŋanapurru wekama ŋurruŋunha miyalknha dhuway'mirriŋuwu, ga yurruna ŋuli ŋunhi gutha'mirriŋunha yutjuwaḻa'nhanydja wekama. ");
INSERT INTO gnn_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Ŋuli nhe yurru nhina dhiyala weyindja, ga djäma ŋarraku 7 dhuŋgarra ŋupan, ga yurruna nhe yurru märrama Raytjulnhanydja, ŋayi yurru wiripunydja nhuŋu miyalk. Ŋamakurru' warray nhuŋu yulŋunydja, nhe yurru galki märramana ŋanya, bala nhe yukurra yurru yänana djämanydja bala dhuŋgarra ŋupan ŋunhiyinydja.” ");
INSERT INTO gnn_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","30","Bala Djaykuptja yoraŋalana nhanŋu. Ŋayi galkurruna yukurrana märr‐gurriri, bala ŋayi märraŋala Raytjulnhana nhanŋuway dhäykanha. Ga Djaykuptja wirrkina nhanŋu yukurra Raytjulwunydja märr‐ŋamathina, ga nhanŋunydja Liyawunydja ga märr‐gaŋgana. ");
INSERT INTO gnn_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","35","Yurru ŋayi ŋulinyaramirriyu Liyanydja yothu'mirriyinana ga yothunydja nhanŋu ŋunhi maḻŋ'thurruna ḏarramu, ga walala yäkunydja ŋanya nherrara Ropin. Yurru ŋayi Raytjulnydja bäyŋu ŋula yothunha gäŋala, yothumiriw yukurrana yana nhinana. Ga biyapul ŋayi Liya yothu'mirriyina, biyapul gurrukaŋala yothunha waku'mirriŋunha ḏarramunha yana, ga yäku nherraranydja walala ŋanya Djimiyannha. Ga ŋuliŋurunydja wiripuna nhanŋu yothu maḻŋ'thurruna ḏarramu yana, ga yäku‐nherraṉdja ŋayi ga Lepay. Ga biyapul nhanŋu wiripu yothu, Djudana. ");
INSERT INTO gnn_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","21","Ga mukthurruna yana Raytjulnydja yothumiriwŋga nhinana yukurrana, bala ŋayi mel‐ḏi'yurrunana ŋunhiyi yapa'mirriŋunha Liyanhanydja, bala ŋayi waŋana Djaykupkala bitjarra, “Ŋarranydja djäl yothuwu muka, bay' yana ŋarra yurru rakunydhirrina ŋiniya.” Bala ŋayi Djaykuptja ŋaramurrthinana, ga waŋana bitjarrana, “Yol ŋarra dhuwala yulŋunydja? . . . God? Ŋayina nhuŋu yurru wekama yothu'nhanydja.” Bala ŋayi Raytjulnydja waŋana bitjarrana, “Märraŋa ŋunhi ŋarraku djämamirrinhana dhäykanha, märr yurru ŋayina gäma yothunha ŋarraku.” Bala ŋayi märraŋalana ŋanya Bilanhanydja, djunama yana ŋayi yothunhana gurrukaŋalanydja, ga ŋayina Raytjulyuna yäkunydja ŋanya nherrara Dännha. Ga biyapul ŋayi ŋuriŋiyi djämamirriyu miyalkthu gäŋala wiripunhana yothunha, ga ŋunhiyinydja ŋayi yäku nherrara Napalinha. Ga bitjarrayi liŋgu ŋayinydja Liyayunydja nhanŋuwaynydja ŋayi djämamirrinha miyalknha wekaŋala Djaykupkunydja, ga ŋuriŋiyinydjayi miyalkthu ga märrma'na yothu maṉḏanha gäŋala Gädnha ga Yatjanhana yäkunha maṉḏanha. Ga ŋayipinydja Liyayunydja ga märrma'nha gäŋala dhuḏitjtja, Yitjakanhana ga Djapalannhana. ");
INSERT INTO gnn_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","24","Ga mukthurruna yana Raytjulnydja yothumiriw nhinana yukurrana, yurru bitjanana liŋgu ŋayi yukurranha ŋuli bukumirriyanhanydja Godnha, märr ŋayi yurru Godthu guŋga'yun ŋanya, ga wekama yothu nhanŋu. Bala Godthu ŋäkulana ŋanya bukumirriyanhara, bala ŋayi Raytjul yothumirriyinana, ga maḻŋ'thurruna yothunydja nhanŋu ḏarramu, bala ŋayi yäku‐nherraranydja ŋanya Djotjip. ");
INSERT INTO gnn_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Dhäŋuru ŋuliŋurunydja ŋunhi Djotjip liŋguna dhawal‐wuyaŋinana, bala ŋayi Djaykup waŋanana Laypannha bitjarrana, “Ŋarranydja dhuwala ḏukṯuk ŋarra yurru marrtji roŋiyirrina ŋarrakalaŋuwala bäpawalana wäŋalili,” bitjarra. ");
INSERT INTO gnn_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","“Go wekaŋana ŋarraku miyalknhanydja maṉḏanha ga ŋarraku djamarrkuḻi'nhanydja, ŋarrakuwaynha dhuwalanydja malanha. Wekaŋana lili ŋarraku, bala ŋarra yurru marrtjina gonha'yunna dhuwala wäŋa. Liŋguna nhe marŋgina ŋarraku ŋunhi ŋarra yukurrana djäma ŋamathaŋala yana nhuŋu.” ");
INSERT INTO gnn_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Ŋayi Laypandja waŋana buku‐ruŋiyinmaraŋala bitjarra, “Märr‐yuwalk warray dhuwalinydja, yuwalk warray wal'ŋu. Ŋarra marŋgi ŋunhi Garrayyu nhuna guŋga'yurruna. Ga bitjarra yana liŋgu ŋayi ŋarranhanydja guŋga'yurrunayi bili nhokala. ");
INSERT INTO gnn_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Ḻakaraŋana lili, bala ŋarra yurru wekamana nhuŋu.” ");
INSERT INTO gnn_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Ga Djaykuptja waŋana buku‐ruŋiyinmaraŋala, “Ŋarra yukurrana djäka nhokalaŋuwu wäyingu walalaŋgu ŋamathaŋala yana. ");
INSERT INTO gnn_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Ŋäthilinydja ŋunhi, ŋunhi ŋarra bunana dhiyala nhuŋu, ŋulinyaramirriyunydja märr‐ḻurrkun' muka wäyin nhuŋu, ga dhiyaŋunydja‐wala dhuwalana dhaŋaŋnha wirrkina wal'ŋu wäyin, bili Godthu ŋayipi nhuna guŋga'yurruna ŋarrakala djämakurru.” ");
INSERT INTO gnn_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Ga ŋayi Laypandja buku‐wakmaraŋala bitjarra, “Nhä ŋarra nhuŋu yurru wekama buku‐ruŋiyinmaramanydja?” ");
INSERT INTO gnn_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","33","Ga ŋayi Djaykuptja waŋana bitjarra, “Nhepiŋga gulk‐gulkthurranydja nhuŋuway wäyinnhanydja walalanha, märrma'lili ŋurruklili, waŋganylili gali'lili yurru nhe nherraṉ ŋunhiyi bembi malanha bulka'‐gurrŋanmirri, ga nanikutnhanydja walalanha ŋunhi bulka'‐ḏil'‐ḏilmirrinha, ŋunhiyinydja malanha waŋganylili gulk‐gulkthurra ŋurruklili, ga ŋunhiyina ŋarrakunydja yurru. Ga wiripunydja ŋunhi malanha bukmaktja gaywaraŋu'mirrinydja guḻkuny'tja wal'ŋu warrpam nhuŋuwaynha, nanikut manapandja.” ");
INSERT INTO gnn_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","36","Ŋayi Laypandja yoraŋala, bitjarra yana liŋgu ŋayi yulŋunydja ŋunhi Djaykup yukurrana waŋana. Ga yuwalkthi ŋayi gulk‐gulkthurrunanydja Laypandhu ŋunhi gurrŋan'mirrinha ga ḏil'‐ḏilmirrinha walalanha waŋganylilina ŋurruklili ga ŋunhinydja nhanŋuna ganaŋ'maraŋala Djaykupkuna. ");
INSERT INTO gnn_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","43","Ŋunhi ŋayi Djaykupthu bitjarrayi ŋula nhaltjarra, bala yurruna wäyindja ŋunhi guḻku'na dhika dhawal‐wuyaŋina yukurrana ḏil'‐ḏilmirrina ga bulka'‐gurrŋanmirrina guḻku'na dhaŋaŋnha. Djaykuppa wäyindja guḻku'thinana, ga bembi bulka'‐ḏilkurru balanyara wäyin ga nanikut yäku dhaŋaŋnha dhikana. Godthu guŋga'yurruna ŋanya Djaykupnha ŋunhimalayi, bala dhaŋaŋdhinana wäyindja nhanŋu gamul ga duŋ'ki ga wiripu wäyin malanha, ga djämamirri walala nhanbala guḻku'na dhika yolŋu'‐yulŋunydja, bala Djaykuptja wirrkina ŋurruwuŋmirriyina. ");
INSERT INTO gnn_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","12","Bala walala Laypangu gäthu'mirriŋunydja walala wirrkina dhika maḏakarritjthina Djaykupkunydja, bala walala waŋana bitjarrana, “Djaykupthunydja ŋunha warrpam'nha djaw'‐djawyurruna wäyin malanha warrpam'nha ŋiniya ŋilimurruŋgalaŋu bäpa'mirriŋuwanydja,” bitjarra. Ga ŋayi Laypandja bitjarra yana liŋgu yakana ŋamathina Djaykupku, bitjarra ŋunhi ŋäthili ŋayi galŋa‐ŋamathina, bili ŋayi yaka ḏukṯukthina, ŋayi bini rarr'yuna warrpam' wäyin ŋunhiyi malanha nhanbala Djaykuppa ḏil'‐ḏilmirri ga gurrŋan'mirri wäyin walala. ");
INSERT INTO gnn_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","16","Bala ŋulinyaramirriyu Garray waŋana Djaykupkala bitjarrana, “Gonha'yurrana dhuwalanydja wäŋa. Gaŋgathiyana bala marrtjiya nhokalaŋuwala bäpa'mirriŋuwalana ga gurruṯu'mirriwalana walalaŋgala, ga ŋarranydja yurru nhokala galki yana.” ");
INSERT INTO gnn_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","21","Dhunupa ŋayi Djaykuptja gurku'yurrunana, bala gaŋgathinana marrtjinana balayina bäpa'mirriŋuwalana wäŋalili Gaynanlilina. Ŋayi ŋal'‐ŋalmaraŋala miyalknha maṉḏanha ga yumurrku'nhanydja nhanŋuway wäyingala ḏiltjililina gamulwalana, barrkuna marrtjina mutpunuŋala wäyinnha ŋunhi walalanha. Ga walala yolŋu'‐yulŋuyunydja mutpunuŋalana marrtjina. Bukmaknhana märraŋalanydja ŋayi, ŋunhi nhä malanha nhanŋuway wal'ŋu, bala yana marrtjinana‐wala. ");
INSERT INTO gnn_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","2","Yo, marrtjinana walala yukurrana‐a‐a yana liŋgu ga galki gandarrŋurana, bala walala ŋunhili nhinanana. ");
INSERT INTO gnn_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Yo, ŋunhiliyinydja gandarrŋuranydja ŋayi Djaykupthu yänguŋala dhäwu'mirrinha walalanha bala wäwa'mirriŋuwala nhanukalaŋuwala Yetjuwala yäkuwala, ");
INSERT INTO gnn_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","ga dhäruktja ŋayi wekaŋala bitjarra walalaŋgala. “Biyaka walala waŋiyanydja nhanukala Yetjuwala, ‘Ŋarranydja dhuwala nhuŋu djämamirri Djaykup. Ŋarra yukurrana nhinana ŋunhala Laypangala baman'nha, ga dhuwalanydja ŋarra lili roŋiyirrina marrtji. ");
INSERT INTO gnn_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Wäyindja ŋarraku dhuwala dhaŋaŋnha biyapulnha, mirithirrina guḻku' buliki, duŋ'ki, bembi, ga nanikut, ga djämamirrinydja walala ga buluna dhaŋaŋnha. Ŋarra yukurra dhäruktja djuy'yunmirri dhuwala nhuŋu, märr yurru nhe yakana ŋula ŋoy‐marimirriyirri ŋarraku, yana nhe märraŋana ŋarranha, gumurr‐ŋamathiyana ŋarraku bitjan ŋarranydja nhuŋu dhuwala djämamirrina.’” ");
INSERT INTO gnn_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Martj‐gay walalanydja ŋunhi dhäwu'mirrinydja; marrtjinana walala ga ŋunhala Yetjuwala, ga bunananydja nhanŋu, bala wekaŋalana dhäwuny'tja, ga lilinydja walala wiripuna dhäwu' gäŋala nhanŋu Djaykupkunydja, balanyarana gam'. “Liŋgu ŋanapurru wäwa‐ŋaliwanydja Yetjuwanydja bunana, ga ŋayinydja ŋunha marrtjina yukurra dhuwalana lili, gumurr'yunna nhuŋu yukurra. Ga malanydja nhanŋu yolŋu'‐yulŋunydja marrtji malthun dhika lili 400‐nha miriŋunydja.” ");
INSERT INTO gnn_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Ŋayi Djaykuptja wirrkina beyaṉiyina ga wirrkina warwuyurruna bitjarra ya' buku‐warwumirriyina. Ŋuliŋurunydja ŋayi gulk‐gulkthurrunana marrtjina yolŋu'‐yulŋunha ga wäyinnha walalanha barrkuwatjkuŋalana märrma'lili miṯtjilili. ");
INSERT INTO gnn_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Bili ŋayi bitjarra guyaŋina, “Ŋuli yurru Yetjunydja marrtji ga miriŋu‐wunanydja dhiyala ŋanapurruŋgu, ga djaw'yun yurru dhuwala waŋganynha ŋathili miṯtjinha, märr yurru wiripunydja ŋurruk miṯtjiŋura ga gundupumana walŋathirrina,” bitjarra. ");
INSERT INTO gnn_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Bala ŋayi Djaykup bukukurru waŋana ŋäŋ'thurruna Godnha bitjarrana, “Nhenydja dhuwalinydja waŋarr ŋarrakalaŋuwu märi'mirriŋuwu Yipurayimgu, ga ŋarrakalaŋuwu bäpa'mirriŋuwu Yitjakku. Ŋäka ŋarranha. Garray nhepi ŋarraku ḻakaraŋala roŋiyinyarawu dhiyakunydja ŋarrakiyingalaŋuwunydja wäŋawu gurruṯu'mirriwu walalaŋgu. Ga nhepi dhäruk‐nherraṉmina ŋunhi nhepi ŋarranha yurru gämanydja marrtji lili, djäkanydja marrtji ŋarraku ŋamathama yana. ");
INSERT INTO gnn_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Ŋarranydja dhuwala yätjnha yolŋu, yakana ŋamakurru', yurru nhe mukthurruna ŋarraku djäka marrtjina, gäŋala ŋarranha ŋamathaŋala yana, guŋga'yurruna ŋarranha nhe nhuŋuway djämamirrinha. Ŋunhi ŋarra gonha'yurruna dhuwala wäŋa ŋäthili bala marrtjina, goŋ‐wayŋu ŋarra marrtjinanydja yana ŋula nhämiriw, waŋgany wapitja yana dharpa gäŋala, ga dhuwalanydja ŋarra lilinydja roŋiyina malamirrina, djämamirrinydja dhaŋaŋnha ga wäyindja; ga bukmak nhä malanha nhe wekama yawungu ŋarraku. ");
INSERT INTO gnn_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Walŋakuŋa ŋarranha Garray, liŋgu ŋarra dhuwala beyaṉiyirri yukurra ŋuruku wäwa'mirriŋuwu ŋarrakalaŋuwu Yetjuwu. Dhuwala ŋayi ŋuli gonhana marrtji lili bunharawuna ŋanapurruŋgu, bukmakkuna dhiyaku walalaŋgu, dhäykawurruŋgu ga yumurrku'wu ga bukmakku dhiyaku. ");
INSERT INTO gnn_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Guyaŋiya ŋunhiyi ŋunhi nhe dhawu'‐nherrara ŋarraku djäkawu ŋamathanharawu. Ga bitjarrayi bili nhe dhawu'‐nherrara ŋarranha malawunydja guḻku'kunharawu yumurrku'wunydja, märr yurru ŋarraku mala dhaŋaŋdhirri guḻku'thirri gal'ŋu miṯtjinydja, dhaŋaŋdhirrina wal'ŋu yurru bitjan dhuwala munatha' ya' raŋiŋura.” Bitjarra ŋayi Djaykup yukurrana bukumirriyaŋalanydja. ");
INSERT INTO gnn_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","16","Yo, ŋunhiliyi walala wäŋaraŋalanydja, ga munhakumirrina wiripuŋuyuna waluyu, bala Djaykupthu gulk‐gulkthurrunana marrtjina dhaŋaŋnha mirithirrina wäyin, mundhurrnha wäwa'mirriŋuwuna Yetjuwuna wekanharawu, bala djuy'yurrunana yukurrana ŋunhiyi wäyin malanha ga djämamirri waŋgany. Ga dhäruktja‐gathanmina ŋayi yukurrana waŋga'‐waŋganygu ŋurikiyi djämamirriwunydja walalaŋgu bitjarra. “Ŋay', dhuwala wäyin malanha gäŋa nhanbala, nhanŋuna Yetjuwuna, ");
INSERT INTO gnn_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","ga ŋunhi ŋayi dhä‐wirrka'yundja yurru nhuna bitjandja, ‘Yol nhuŋu buŋgawa'mirriŋunydja? . . . ga yolku dhuwala wäyindja malanha?’ ");
INSERT INTO gnn_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","ga yurruna nhenydja yurru waŋiya biyaka. ‘Dhuwalanydja wäyin nhokalaŋuwuŋu djämamirriwuŋu Djaykupkuŋuna; ŋayi djuy'yurruna dhuwalanydja nhuŋuna mundhurrnha. Ga ŋayinydja Djaykuptja, ŋayipinydja dhuwala lili marrtji nhina dhuḏikurru.’” ");
INSERT INTO gnn_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","20","Djaykup bitjarrayinydja waŋana, liŋgu ŋayi guyaŋina bitjarra, bitjanarayunydja dhiyaŋunydja mundhurryunydja wekanharayu ŋayi yurru goyulŋu'thirrina ŋarraku, ŋamathirrina ḻunduthirrina. Ga ŋunhi ŋilinyu yurru bunanhamirrinydja, mak ŋayinydja yurru ŋarraku bäy‐ḻakaramana ŋurikinydja baman'ŋuwuynydja ŋunhi ŋarra nhaltjarra ŋanya yätjkuŋala. ");
INSERT INTO gnn_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Bala ŋayi ŋunhiyi mundhurrnydja malanha djuy'yurrunana yukurrana ŋathil'yurrunana ŋurruŋuna, ga ŋayipinydja bulnha yukurrana nhinana. ");
INSERT INTO gnn_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","23","Ŋulinyaramirriyu munhaku ŋayi Djaykup gaŋgathinana, bala djuy'yurruna dhäykawurrunha nhanŋuway ga yumurrku'nha ga nhä malanha nhanŋuway ŋunhi bukmak; bukmaknha yana warrpam'thurrunana djuy'yurruna ŋäthilina, ");
INSERT INTO gnn_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","ga ŋayipinydja ŋunhilina bäymana nhinana yukurrana gänana ŋayipina. Munhakuna dhika, bala ḏarramuna bunana nhanbala ŋunhiliyi ŋula yolnha, bala maṉḏa yukurrana mulkanhaminana bala ganydjarr‐warryunminana maṉḏakuway maṉḏa. Ganydjarr‐warryunminana maṉḏa yukurrana‐a‐a, yana liŋgu‐u‐u, galki djaḏaw'yurrunana marrtjina. ");
INSERT INTO gnn_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Ŋayi ŋunhi ŋula yolnydja marŋgithinana ŋunhi ŋayi yakana yurru djuḻkmarama ŋanya Djaykupnhanydja ganydjarr, bala ŋayi marrtjina mulkanana ŋanya Djaykupnhanydja dhiyala bili yuṯuŋgurr, dhuwala dhä‐manapanara, bala dhayapmaraŋalana ḏulŋurr'yurrunana, märr ŋayi yurru yakana marrtji ŋamathama. ");
INSERT INTO gnn_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Ga ŋunhi yolŋunydja be‐yolnydja waŋana, “Gonha'yurrana ŋarranha, ŋarra marrtjina, liŋgu djaḏaw'yunna marrtji dhuwala wäŋanydja.” Yurru ŋayi Djaykupthunydja baṯ bitjarra yukurrana yana ŋayathaŋala mukthurruna ŋanya, ga waŋana bitjarra, “Yakana ŋarra yurru nhuna dhuwalanydja djuy'yun‐wala. Ŋäthilinydja nhe yurru waŋa goŋmirriyama ŋarranha, märr yurru ŋarra yukurra marrtji nhokalaynha yana djälkurru.” ");
INSERT INTO gnn_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Bala ŋayi ŋunhiyinydja yolŋu waŋana bitjarra, “Yol dhuwala nhe yäkunydja?” Ga ŋayinydja waŋana bitjarra, “Ŋarra dhuwala Djaykup, mayali' bitjan rom‐guḻku'mirri ŋarranydja.” ");
INSERT INTO gnn_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Ga ŋunhi be yolnydja yolŋu waŋana bitjarra, “Yakana nhe yurru yukurra yäku djingaryun Djaykuptja; ŋarranydja yurru dhuwala nhuna yäku‐nherraṉ yuṯana yäku. Dhipuŋurunydja‐wala dhurrwaraŋuru nhe yurru yäkunydja yukurra djingaryun Yitjuralnha, liŋgu nhe yukurrana ganydjarr‐warryurruna Godku ga yolŋuwu, bala liŋguna nhe dhuwala djuḻkmaraŋalana.” ");
INSERT INTO gnn_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Ga ŋayi Djaykuptja buku‐ḏuwaṯthurruna waŋana dhä‐wirrka'yurruna nhanŋu yäkuwu bitjarra, “Ma', nhenydja yäku ḻakaranhamiyana ŋarrakala. Yol nhenydja yäku?” Ga ŋayinydja ŋunhi be yolnydja yolŋu waŋana bitjarra, “Nhäku nhe yukurra ŋarrakunydja dhä‐wirrka'yun yäkuwu? Marŋgi muka nhe ŋarrakunydja.” Bala ŋayi waŋana dhäruktja goŋmirriyaŋalana ŋanya Djaykupnha. ");
INSERT INTO gnn_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Bala ŋayi Djaykup waŋanana, “Liŋguna ŋarra nhäŋalanydja Garraynha rumbalnydja. Ŋarra nhäŋala ŋanya bukuna, ga dhuwalana ŋarra gay' walŋa yana.” Bala ŋayi yäkunydja nherrara ŋunhi wäŋanydja Biniyalnha, ŋunhinydja mayali' bitjan Garraywu bukuna. ");
INSERT INTO gnn_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Bala ŋayi Djaykupthu wäŋanydja ŋunhi gonha'yurrunana, dhiyaŋu liŋgu ŋayi marrtjina walunydja lili walmana, yurru ŋayi marrtjina djuka'‐djukaṯthurrunana bala yulŋunydja, bili yuṯuŋgurr ŋayi ŋunhi dhayapthurruna. ");
INSERT INTO gnn_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","3","Yo, ŋayi Djaykuptja ŋurruŋuna djuḻkthurruna, ga nhanŋu miyalktja maṉḏa ga yumurrkuny'tja nhanŋu dhuḏikurru malthurruna yukurrana nhanŋu, bala marrtjinana yukurrana walala yana‐wala. Martj‐martjtjurrunanydja walala‐a‐a, yana liŋgu ga ŋunhala gandarrŋuranydja, dharr‐way nhäŋala Yetjunhanydja, bala walala ŋunhalana bunanhaminanydja. Bala yana Djaykuptja buku‐nyilŋ'thurrunana nhanukala Yetjuwala ŋunhi ŋayi marrtjina galkililinydja, gumurrlilinydja nhanukala wal'ŋu. ");
INSERT INTO gnn_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Yurru ŋayi ṉaŋ'‐ṉaŋdhurrunana gay' Yetjunydja gumurr'yurrunana nhanŋu, bala yana dhangi'yurrunana ŋanya, wälkuŋalana wiṯthurrunana dhikana, yurru maṉḏa märrma'na ŋäthinyaminanydja bala‐lili'yunminana. ");
INSERT INTO gnn_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Ŋuliŋurunydja dhurrwaraŋuru ŋayi Yetjuyunydja nhäŋa'‐nhaŋala marrtjina ḻiw'maraŋala, dharr‐way nhäŋala, bala dhä‐wirrka'yurrunana waŋana bitjarrana. “Yol walala dhuwala dhäykawurrunydja ga yumurrkuny'tja? Yolku walala dhuwala yolŋunydja?” bitjarra. Ga ŋayi Djaykuptja waŋana, “Dhuwalanydja gay yolŋu'‐yulŋu ŋunhi ŋayipi Godthu wekaŋala walalanha ŋarraku, liŋgu ŋarranha Godthu yukurrana guŋga'yurrunanydja, ga gäŋala ḻatju'kuŋala yana.” ");
INSERT INTO gnn_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","16","Bala ŋayi Djaykupthu rarr'yurrunana marrtjina Yetjuwuna wäyindja malanha ga wiripu malanha ŋunhi mundhurr nhanbala Yetjuwana, yurruna ŋayi Yetju marrtjina balayi wäŋalili nhanukalanydja, nhayikayu Yedamlilinydja. ");
INSERT INTO gnn_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","20","Ga ŋayi Djaykuptja bitjarrayi liŋgu marrtjinayi bala wäŋalili Djikamlili yäkulili, makarrlili wäŋalili Gaynanlili, ga ŋunhalayina ŋayinydja nhinana. Ga ŋunhalayina ŋayi guṉḏana ŋal'‐ŋalmaraŋala, mundhurrwuna wekanharawu ga buku‐ŋal'yunarawuna Godku. ");
INSERT INTO gnn_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Walala nhinananydja yukurrana ŋunhalayi wäŋaŋura märr‐gurriri, bala ŋuliŋurunydja dhurrwaraŋuru God waŋanana Djaykupkala bitjarrana, “Ma' ḻaw'yurrana dhipuŋurunydja wäŋaŋuru, ga marrtjiya ŋunhana Bithullilina; ŋunhilina wal'ŋu nhe yurru nhiniyanydja yukirriya, ga ŋunhalana dhuḻ'yurra nhe guṉḏanydja ŋal'maraŋa buku‐ŋal'yunarawuna ŋarraku. Bili ŋarranydja dhuwala ŋunhi muka waŋarr nhuŋu, ŋunhi ŋarra maḻŋ'maranhamina nhokala ŋunhalayi ŋäthili, ŋunhi nhe waṉḏina beyaṉuŋu wäwa‐ŋaliwuŋu.” ");
INSERT INTO gnn_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Dhunupa ŋayi Djaykupthunydja waŋanana nhanŋuway yumurrku'nha ga dhäykawurrunha ga wiripu‐guḻku'nha miṯtjinha nhanŋuway, bitjarrana waŋana gam'. “Djalkthurrana nhuma dhuwala nhänydja malanha waŋarrnha wiripunydja ga wiripunydja ŋunhi dhuwala nhuma yukurra ḏälkuma goŋbuy djämawuy; djalkthurrana yana, warrpam'thurrana djalkthurrana‐wala. Ga ŋamathanharamiya ḏarrtjalkkunharamiya yana, dhaṯthunmiyanydja girri'yunydja ḏarrtjalkthuna yana ḻanyiŋdhuna, ");
INSERT INTO gnn_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","bili ŋilimurru yurru marrtjina dhuwala gananna dhuwalanydja wäŋa, marrtjina ŋilimurru yurru bala Bithullilina, ga ŋunhalana ŋarra yurru ŋal'‐ŋalmarama guṉḏanydja. Ŋilimurru yurru yukurra buku‐ŋal'yunna Godku, nhanŋuwayŋga waŋganyguŋga ŋunhi ŋayi ŋarranha yukurra ŋuli guŋga'yun marikurru. Ŋilinyu yukurrana marrtjina rrambaŋi yana, wanhawitjana ŋarra ŋuli marrtjinya.” ");
INSERT INTO gnn_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Bala ŋuriŋiyi yolŋu'‐yulŋuyunydja warrpam'nha rarr'yurrunana ŋunhi marrtjina nhänydja malanha girriny'tja maḏayin' walalaŋguway walala lilina Djaykupkalana, bala yana ŋayinydja marrtjina Djaykupthunydja dholkuŋala munatha'lilina, dhuḏililina dharpalili. ");
INSERT INTO gnn_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Yo, bukmak ŋunhi wiripu‐guḻku' bäpurru yolŋu'‐yulŋu nhinana yukurrana ḻiw'maraŋala ŋunhiliyi wäŋaŋura dharaŋarana liŋguna, ŋunhi walalanydja Djaykuptja ga nhanŋu malanydja nhanukalana wal'ŋu goŋŋura Godkalana. Bäyŋuna ŋula walala marrtjina lili withiyara walalanha bunharawunydja walalaŋgu, liŋgu mirithinana walala ŋunhi yolŋu'‐yulŋunydja beyaṉiyina. ");
INSERT INTO gnn_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","9","Bala Djaykuptja ga nhanŋu yolŋu'‐yulŋunydja miṯtjinydja ŋunhi marrtjinana‐wala yana bukuyuna, ga ŋayathaŋala ŋunha wäŋa Bithulwuy. Ga ŋunhalayina ŋayi ŋal'‐ŋalmaraŋala guṉḏana, bala yana walala buku‐ŋal'yurrunana yukurrana Godku ŋunhalayina wäŋaŋuranydja. Ga biyapul ŋayipi God maḻŋ'maranhamina ŋanyapinyay ŋayi Djaykupkala, ");
INSERT INTO gnn_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","ga bitjarra ŋayi waŋananydja, “Yäkunydja nhe dhuwala Djaykup, yurru dhiyaŋunydja‐wala nhe yurru yäku djingaryun yukurra yuṯana, Yitjuralnha.” ");
INSERT INTO gnn_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Ga bitjarra liŋgu God waŋana dhäwu'‐nherrara nhanŋu bitjarranydja gam', “Ŋarranydja dhuwala waŋarr, ŋunhiyi muka bili ganydjarr‐ḏumurru ŋutu' wal'ŋu. Nhuŋu yurru yumurrkuny'tja guḻku'na mirithirrina; guḻku'na bäpurruny'tja yurru nhokuŋu walkur‐ŋurrkanharanydja. ");
INSERT INTO gnn_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Ŋarra yurru wäŋanydja nhuŋu wekamana ŋunhi ŋarra dhäwu'‐nherrara ŋäthili Yipurayimgala ga Yitjakkala; dhuwalanydja wäŋa nhuŋuwaynha yukurra yurru djingaryun ga nhokalaŋuwu yumurrku'wuna bitjanna liŋgu weyinŋumirrina.” ");
INSERT INTO gnn_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Bala ŋuliŋurunydja Godthu gonha'yurrunana ŋanya Yitjuralnhanydja. ");
INSERT INTO gnn_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Ga ŋunhimala dharapullilinydja ŋunhi God yukurrana waŋana nhanukala, ŋayi Yitjuralyunydja guṉḏana nherrara guyaŋinyarawuna yukurranharawu bitjanarawuna liŋgu. Bala ŋayi ŋuliŋurunydja märraŋala weyika, bala yana rarryurruna ŋunhimala guṉḏalili, ŋunhinydja bitjarra ŋayi ganaŋ'maraŋalana gänana wal'ŋu nhanŋuwaynha ŋunhiyinydja Godkuna. ");
INSERT INTO gnn_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Bala ŋayi yäku‐nherrara ŋunhiyinydja wäŋa Bithul bitjarrana. ");
INSERT INTO gnn_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","18","Ŋuliŋurunydja dhurrwaraŋuru Djaykup ga nhanŋu miṯtji yolŋu'‐yulŋu ŋunhi ḻaw'yurrunana gonha'yurruna ŋunhiyi Bithulwuynydja, bala yana marrtjinana. Marrtjinana yukurrana walala, yurru ŋayi ŋunhi Raytjulnydja yothu'mirrina, galkina ŋunhi walunydja dhawal‐wuyaŋinyarawuna ŋurikiyi yothuwu. Bala ŋayi Raytjulnydja rirrikthurrunana, wirrkina dhika ŋäku'‐ŋakulana marrtjina; wirrkina ŋayi Raytjul rirrikthurrunanydja dhika, yurru yothuny'tja ŋunhi dhawal‐wuyaŋina ŋamathaŋala, ḏarramu ŋunhi yothuny'tja, ga yäkunydja ŋayi nherrara ŋanya Bindjamannha. ");
INSERT INTO gnn_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Yurru ŋayipi Raytjulnydja rakunydhinana ŋunhi, bala walala dholkuŋalanydja ŋanya ŋunhimala bäyma yana dhukarrlili galki Bithiliyimnha. ");
INSERT INTO gnn_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Bala ŋayi Djaykupthunydja nherrara guṉḏana ŋunhimalayi molulilinydja nhanukala Raytjulwala dhunupamirriyaŋalana guyaŋinyarawuna yukurranharawu. ");
INSERT INTO gnn_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","22","Ŋuliŋurunydja walala gaŋgathina gonha'yurruna ŋunhiyi wäŋa, bala yana marrtjinana‐wala yana, ga yanana liŋgu ŋunhana walala bäpa'mirriŋunhana withiyara yukurrana Yitjaknhana. ");
INSERT INTO gnn_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Yo, Djaykupku gäthu'mirriŋunydja walala märrma'‐rulu ga märrma' bäythinyara ḏarramuwurru ŋayipi. Ga nhanŋu Liyawunydja waku'mirriŋu walala yäku dhuwala walala gam', Ropin, Djimiyan, Lepay, Djuda, Yitjaka, ga Djapalan. ");
INSERT INTO gnn_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Ga Raytjulwuŋunydja yothu maṉḏa dhuwala yäku Djotjip ga Bindjaman. ");
INSERT INTO gnn_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Ga wiripunydja ŋayi Raytjulyu wekaŋala djämamirrinha miyalknha nhanŋu Djaykupku, märr ŋayi yurru yothu gurrukama nhanŋu Raytjulwu, ga dhuwalana nhanukuŋu yumurrkuny'tja gam' Dän ga Napali. ");
INSERT INTO gnn_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Ga bitjarrayi liŋgu Liyawalanydja djämamirriyu dhäykayu gurrukaŋala walkur nhanŋuway yana Djaykupku, ga yäkunydja maṉḏa Gäd ga Yatja. ");
INSERT INTO gnn_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Yo. Mukthurruna yukurrana yana Yitjaktja nhinana muka ŋunhalayi Mamiri galki Yiprun wäŋaŋura, ŋunhala yana bili wäŋaŋura waŋganyŋura ŋunhi ŋäthili yukurrana Yipurayim ga Yitjak nhinana be baman', ");
INSERT INTO gnn_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","yurru Yitjaktja ŋunhi wirrkina wal'ŋu djawuḻpa'yinana, 100 ga 80‐na dhuŋgarranydja, ");
INSERT INTO gnn_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","bala ŋayi rakunydhinana. Bala yana nhanukala gäthu'mirriŋuyunydja maṉḏathu moluliliyaŋalana ŋanya dholkuŋalanydja, Yetjuyu ga Djaykupthu. ");
INSERT INTO gnn_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yo, Djaykup nhinananydja yukurrana wäŋaŋura yäkuŋura Gaynan, ŋunhiliyi bili wäŋaŋura ŋunhi nhanŋu bäpa'mirriŋu nhinana yukurrana ŋäthili, ");
INSERT INTO gnn_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","ga dhäwu'yunydja dhiyaŋuyi yukurra ḻakarama yumurrku'nhana nhanŋuway Djaykupku. Ŋulinyaramirriyu ŋayi Djotjiptja wakinnha ḏarramuna, yawirriny'nha, ga ŋayi ŋuli yukurranha djäma guŋga'yuna wäwa'mirriŋunha walalanha, djäka yukurranha ŋuli wäyingu malaŋuwu. Bala ŋayinydja Djotjipthunydja walalanha ŋuli nhänha, bala yana djar'tjaryuna, ga ḻakaranha bäpa'mirriŋuwuna walalanha ŋunhi walala yätjkuŋala djäma. ");
INSERT INTO gnn_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Ga ŋayinydja bäpa'mirriŋunydja Djaykuptja wirrkina märr‐ŋamathina yukurrana nhanŋuwaynha waŋganyguna Djotjipkuna, ganaŋ'thurrunana wal'ŋu ŋurikala wiripu‐guḻku'walanydja wäwa'mirriŋuwala walalaŋgala, ŋunhiyinydja nhanŋu mel‐wiḏi'na yothu, liŋgu ŋayi maḻŋ'thurruna ŋunhiyi gäthu'mirriŋu ŋunhi ŋayinydja djawuḻpa'na. Bala ŋayi ŋanya Djotjipnha bitjarrana yolŋunydja wal'ŋu, bitjan ŋurruŋuna gäthu'mirriŋu ŋayinydja. Ŋayi wekaŋalanydja nhanbala girriny'tja dhika ŋanya miny'tji‐maypamirrina, ḻatju'na ŋanya dhika djana'mirrina girri'. ");
INSERT INTO gnn_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Ga walala ŋuriŋiyinydja wäwa'mirriŋuyunydja walalay nhäŋalana ŋanya ŋunhimalayi girri'lilina ŋunhi, bala marŋgithinana ŋunhi walalaŋgu bäpa'mirriŋunydja yukurrana wirrkinydja wokthurruna nhanŋuwaynha waŋganyguna Djotjipkuna. Bala walala wirrkina nhanŋu ŋaramurryinanydja, ga yakana ŋula waŋana ŋamathaŋala nhanŋu Djotjipku. ");
INSERT INTO gnn_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","7","Wiripunydja ŋayi Djotjip ŋorra‐nhina waŋganymirriyu munhaku, bala ŋayi bukaway'yirrina. Nhämanydja ŋayi ŋunhi bukaway'kurru ŋanyapinyay ŋayi ga wäwa'mirriŋunha walalanha nhanŋu, ŋunhala walala marrtji gulkthun ŋatha birrali' wambal, bala waŋgany‐manapandja garrpi'‐garrpirana waŋga'‐waŋgany yana walala ŋuriŋiyi. Ga nhanukuŋunydja galŋa‐warrpiṉara ŋunhi wambal birrali' Djotjipkuŋunydja ṉapuŋga' yukurra dhärra, dhunupayirri yana, ga wäwa'mirriŋuwuŋunydja walalaŋguŋu ŋunhi wambal birrali' galŋa‐warrpi'‐warrpiṉara ḻiw'marama ŋunhi waŋganynha nhanukuŋu Djotjipkuŋu, yurru ŋunhiyinydja walalaŋguŋunydja birrali' wambal buku‐nyilŋ'thunna yukurra ŋurikalana Djotjipkalaŋuwalana. Ŋorrana ŋayi, djaḏaw'yurruna goḏarrny'tja Djotjip gaŋgathina, bala yana ŋayi ḻakaraŋalana wäwa'mirriŋuwana walalambala ŋurikiy bukaway'wuynydja. ");
INSERT INTO gnn_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Bala walalanydja ŋunhi wäwa'mirriŋunydja walala waŋana nhanbala bitjarra, “Nhä nhenydja dhuwala yolŋu? . . . Nhe yukurra dhuwala guyaŋinyamirri nhunapinya nhe, yanapi nhena yurru buŋgawayirri ŋanapurruŋgu bukmakkuna?” Bala walala wirrkina ŋaramurryinanydja nhanŋu Djotjipku. ");
INSERT INTO gnn_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Ga wiripuŋuyunydja ŋayi bitjarra yana liŋgu bukaway'yina, yurru wiripuna bukaway'. Ga goḏarr'nha bala ŋayi ḻakaraŋala nhanukalaŋuwu wäwa'mirriŋuwuna walalambala bitjarra, “Way, wiripuna dhuwala ŋarra bukaway'yirri yawungu bay'. Nhäŋalanydja ŋarra bukaway'kurrunydja walu ga ŋaḻindi ga 11 ganyuny'tja, bukmak walala dhuwala malanha buku‐nyilŋ'thurruna, buku‐ŋal'yurrunana yukurrana ŋarrakuwaynha.” ");
INSERT INTO gnn_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Ga bitjarrayi liŋgu ŋayi ḻakaraŋalayi ŋunhiyi bukaway ŋuriki bäpa'mirriŋuwunydja, bala ŋayinydja bäpa'mirriŋuyunydja ŋanya ŋarrtj‐ŋarrtjtjurruna warray Djotjipnha, bala waŋana bitjarrana, “Nhä dhuwalinydja bukaway?” bitjarrana ŋayinydja. “Nhenydja yukurra dhuwala birrka'yunmirri nhunapinyay nhe, yanapi ŋanapurru yurru ŋäṉḏi'mirriŋu ga ŋarra ga wäwa'mirriŋu walala nhuŋu, bukmaknha ŋanapurru yurru marrtji, bala buku‐nyilŋ'thun yurru märr‐ŋal'yun nhuŋuwaynha waŋganyguna?” bitjarrana ŋayi bäpa'mirriŋunydja. ");
INSERT INTO gnn_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Yurru ŋayi ŋuriŋiyi bäpa'mirriŋuyunydja weyin yukurrana guyaŋinanydja ŋunhiyi, maŋmaŋdhurrunana yukurrana nhanŋu. Yurru walala yukurrana ŋunhi wäwa'mirriŋuyunydja walalay maŋutji‐ḏi'yurruna ŋanya, ga wirrkina ŋaramurrthina yukurrana nhanŋu Djotjipku. ");
INSERT INTO gnn_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Yo, waŋganymirriyu waluyu walala Djotjipku ŋunhi wäwa'mirriŋunydja walala gaŋgathina, bala yana marrtjina bitjarra bala ya' märr‐barrkulili wäŋalili yäkulili Djikamlili, gäŋalanydja walala wäyinnha walalaŋguway walala ŋunhamalayi märr‐baṉarra'lili wäŋalili, mulmumirrilili ga gapumirrilili, ga ŋunhalayina walala yukurrana nhinana djäka ŋuriki wäyingunydja walalaŋgu. ");
INSERT INTO gnn_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","14","Waŋganymirriyunydja waluyu mäḻu'mirriŋu ŋunhi Djaykup wäthurruna nhanŋu Djotjipku, bala waŋana ŋanya bitjarra, “Way, ŋarra nhuŋu ḏukṯuk, nhe marrtjiya bala Djikamlili. Nhuŋu wäwanydja walala ŋunhayi nhina yukurra djäka wäyingu. Nhe yurru marrtjiyana‐wala ŋunhimalayi ga nhäŋa walalanha, nhä walala yukurra nhina ŋunhayi, bala roŋiyiya liliyi, ga ḻakaraŋa ŋarraku walalanha,” bitjarra. Yuwalkthi ŋayi Djotjiptja gaŋgathinana, bala yana marrtjinana. ");
INSERT INTO gnn_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Marrtjinana ŋayi marrtjinana‐a‐a, yana liŋgu‐u‐u, ga wäŋa ŋayathaŋala ŋunhiyi Djikambuy, yurru yaka ŋayi maḻŋ'maraŋalanydja ŋunhi wäwa'mirriŋunhanydja walalanha. Mukthurrunaŋga yana ḻarruŋala walalaŋgu yukurrana, bala ŋunhiliyi waŋganydhu ḏarramuyu ŋanya nhäŋala, bala waŋana bitjarra, “Nhäku nhe marrtji ḻarrumanydja?” bitjarra. ");
INSERT INTO gnn_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Ga ŋayinydja waŋana buku‐ruŋiyinmaraŋala Djotjiptja bitjarra, “Ŋarra yukurra dhuwala ḻarruma ŋarrakalaŋuwu wäwa'mirriŋuwu walalaŋgu. Marŋgiŋga nhe yulŋunydja? . . . wanhaka walala yukurra nhinanydja?” Bitjarra ŋayi Djotjip waŋana dhä‐wirrka'yurrunanydja. ");
INSERT INTO gnn_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Ga ŋunhiyi wiripunydja ḏarramu buku‐ruŋiyinmaraŋala nhanŋu Djotjipku, ḻakaraŋala bitjarra, “Dhiyala warray walala yulŋunydja, märr yawungunydja ŋarra nhänhanydja walalanha, yurru liŋguna walala ḻaw'yurruna ŋunhana bala wäŋalilina marrtjina Dothanlilina,” bitjarra ŋayinydja. Djar'tjar‐way ŋayi Djotjiptja, djar'tjaryurrunana nhinana, bala bur‐way bunana ŋunhala Dothannha, bala wäwa'mirriŋunhana walalanha nhäŋala. ");
INSERT INTO gnn_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Yurru ŋuriŋiyi wäwa'mirriŋuyunydja walalay nhäŋala ŋanya ŋunhaŋga yana ya' barrkuliliŋga, ŋayi nhinana lili djar'tjaryurruna withiyara walalanha. ");
INSERT INTO gnn_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Ga walalanydja waŋanhamina ḻakaranhamina ŋanya bitjanmina, “Nhäŋa walala. Nhäŋa ŋunhana ya', ŋunhiyinydja djar'tjaryun nhina bukaway'‐ḏumurrunydja yolŋu. ");
INSERT INTO gnn_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Gul' ŋilimurru bumana yana ŋanya,” bitjanminana. “Ŋilimurru yurru rumbalnydja ŋanya ŋurrkama ga ŋarŋgalilina, yurru ḻakaramanydja ŋilimurru yurru mäḻu'wanydja ga wakinŋunhana wäyinnha bunharanydja. Ŋunhana ŋayi bukaway'‐ḏumurrunydja ya'. Yakana ŋilimurru yurru nhanŋu märr‐ŋal'yundja.” ");
INSERT INTO gnn_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Yurru ŋayi maḻamarryunydja wäwa'mirriŋuyu yäkuyu Ropindhunydja ŋäkula yukurrana walalanha waŋanharaminyara, bala ŋayi waŋana ŋunhi guḻku'nhana gutha'mirriŋunha walalanha bitjarra, “Yaka ŋilimurru dhuwala yurru buma ŋanya, ");
INSERT INTO gnn_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","yana ŋilimurru ŋanya ŋilitjan dhipala ŋarŋgalili, märr ŋayi yurru rakunydhirri dhiyala ŋanhdharkŋurana.” Bitjarra ŋayi ŋunhi Ropindja waŋana, liŋgu ŋayi yurru roŋiyirri liliyi, ga walŋakuma ŋanya warryun ŋuliŋuruyi, dhawaṯmarama ŋarŋgaŋuru, bala gäma bäpa'mirriŋuwalana, bitjarra warray ŋayi ŋunhi yuwalktja birrka'yurrunanydja yukurrana. ");
INSERT INTO gnn_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Marrtjinanydja nhinana lili Djotjiptja, galkithinanydja bunananydja walalambala, yanapi walala gumurr‐ŋamathinya nhanŋu; yana walalanydja gundupuŋalanydja ŋunhi, bala mulkana warray ŋanya, bala yupmaraŋalana ŋunhiyi galŋaŋuru girriny'tja nhanukala, ");
INSERT INTO gnn_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","bala ḏupthurruna ŋanya rumbalnydja ŋunhi ŋarŋgalilina. Bala yana walala wäŋgaŋalana bala, ga dhut‐gay nhina'‐nhinanana, ");
INSERT INTO gnn_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","bala ḏäpthurruna walala marrtjina ŋathana ḻukana. Bala walala mel‐garrwarthinanydja, bitjarra nhäŋala warray yolŋu'‐yulŋunha, walala marrtjina ḏiltjikurruna lili wäŋgaŋala, yurru wäyingalanydja ḏiltjiŋuranydja marrtjina gorruŋala girri' malanha dhika nhä, bala walala yukurrana marrtjinanydja ŋunhi nhäyikayuna Yetjiplilina, wuŋiḻi'yunarawu ŋurikiyi girri'wuna malaŋuwu. ");
INSERT INTO gnn_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","27","Ga ŋayi Djudanydja yäku waŋana bitjarra, “Way, nhä warray ŋilimurru ŋuli dhiyakalanydja yolŋu'‐yulŋuwala ŋilimurruŋguway gutha'mirriŋunhanydja wuŋiḻi'yurru? . . . dhiyapana walalambala ŋi' yolŋu'‐yulŋuwana? Walalana ŋuli märraŋu ŋanya walalaŋguwaynha djämamirrinha. Ŋilimurru yaka ḏukṯuk ŋilimurru yurru baymatthundja ŋanya, liŋgu ŋayinydja ŋunha gutha'mirriŋu ŋilimurruŋgu.” Ga wiripu‐guḻkuny'tja gutha'mirriŋu walala waŋana bukmak yana bitjarra, “Yo, manymaknha dhuwalinydja guyaŋinyara.” ");
INSERT INTO gnn_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Bala walala ḏulŋurr'yurrunana ŋanya dhawaṯmaraŋala ŋuliŋuru ŋarŋgaŋurunydja Djotjipnha, bala yana wekaŋala wuŋiḻi'yurrunana, ga ŋuriŋiyi ḏarramuwurruyunydja mulku'‐mulkuruyunydja yolŋu'‐yulŋuyu wekaŋala walalaŋgunydja rrupiyana, 20‐na ŋarakanydja walala märraŋala nhanukalaŋuwuy Djotjipkalaŋuwuynydja. Bala walala ŋuriŋi mulku'‐mulkuruyunydja yolŋu'‐yulŋuyu djaw'yurrunana‐wala ŋanya ŋunhana Yetjiplilina. ");
INSERT INTO gnn_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Yo, ŋayinydja ŋunhiyi maḻamarrnydja wäwa'mirriŋu Ropin yäku yaka ŋunhiliyi ŋulinyaramirriyunydjayi ŋunhi walala ŋanya Djotjipnha goŋlili‐wekaŋala wiripu‐guḻku'wala, ga yalalaŋumirriyuna bala ŋayi roŋiyinana lili ga rurraŋ'thurruna ŋunhiyi ŋarŋganydja, ga dhäwulnha nhäŋala. Dhäwulnha Djotjiptja ŋunhili yukurrana gärrina. Wirrkina ŋayi dhika ŋaramurryinanydja, ");
INSERT INTO gnn_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","bala ṉaŋ'‐ṉaŋdhurrunana lili, bala wiripu‐guḻku'wana ŋuripa wäwa'mirriŋuwa walalambala bunana, bala ḻakaraŋala walalambala bitjarra, “Way walala, Djotjiptja dhuwala bäyŋuna ŋunha ŋarŋgaŋuranydja, dhikana‐wala winya'yurrunana. Nhaltjanna dhika ŋarra yurru yulŋunydja? Nhaltjanna ŋarra yurru mäḻu'wanydja ḻakarama?” bitjarrana. ");
INSERT INTO gnn_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Bala walala wutthurrunanydja nanikutnha wäyinnha. Yo, gulaŋdja walala märraŋala rupa'lili, bala yana ŋunhi Djotjipkunydja girri' ḻupmaraŋala guḻwuḻmaraŋala ŋunhimala gulaŋlilina, ");
INSERT INTO gnn_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","bala yana gäŋala bäpa'mirriŋuwalana milkunharawuna. Gäŋalanydja walala bala bäpa'mirriŋuwanydja nhinana, bala yana milkuŋalana bitjarrana, “Mäḻu, nhäŋa dhuwala. Dhuwalanydja ŋanapurru maḻŋ'maraŋala girri'na waŋganynha. Mak dhuwala nhokalaŋuwu gäthu'mirriŋuwu girri'?” bitjarra. ");
INSERT INTO gnn_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Bala ŋayi Djaykupthunydja yuwalknha yana nhäŋalana, dharaŋarana ŋunhi girriny'tja, bala waŋana bitjarrana, “Dhuwalanydja ŋarrakalaŋuwuna gäthu'wu girri'. Wanhakana dhika ŋarrala gäthunydja Djotjiptja? . . . liŋguna rakunynha? . . . bilina bumara dhakaṉguŋalana wakinŋuyuna wäyindhu?” ");
INSERT INTO gnn_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Weyinnha ŋayi dhika ŋäthinanydja Djaykuptja, weyinnha dhika, warwuyurrunanydja yukurrana nhanukalaŋuwu gäthu'mirriŋuwunydja. ");
INSERT INTO gnn_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Wiripu‐guḻku'yunydja ŋuriŋinydja nhanukala gäthu'mirriŋuyu walalay ḏarramuwurruyu ga dhäykawurruyu gulkuruna mukmaraŋala, gulmaraŋala ŋanya ŋäthinyaŋuru, yurru ŋayinydja waŋana yukurrana bitjarrana, “Yakana yana ŋarra yurru dhuwalanydja buku‐dhumukthirri Djotjipnha, mukthunna ŋarra yurru marrtji ŋäthina nhanŋu, yana liŋgu ga rakunydhirri ŋarra yurru.” Mukthurruna yana ŋayi ŋäthina marrtjina Djotjipku, yakana ŋayi ŋula buku‐dhumukthina meṉguŋala. ");
INSERT INTO gnn_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Yurru ŋayinydja Djotjiptja walŋa yana bunana ŋunhala Yetjiptja, ŋunhi walala ŋanya ŋuriŋi mulku'‐mulkuruyu yolŋu'yulŋuyu djaw'yurruna. Ga ŋunhalayina walala ŋanya Djotjipnha wuŋiḻi'yurrunanydja, ga goŋdhu‐märraŋalanydja ŋanya waŋganydhu ḏarramuyu yäkuyu Butipayu, yurru ŋayi ŋunhi mirithirri ŋurruŋu ḏarramunydja, buŋgawa ŋayi ŋurruŋu ŋuriki miriŋuwu, djäkawu yukurranharawu ŋuriki buŋgawawalaŋuwu giŋgalaŋuwu buṉbuwu. ");
INSERT INTO gnn_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Liŋguna ŋunhalana Yetjipnha Djotjiptja yukurrana nhinanana‐a‐a, ga djämana ŋayi yukurrana Butipawalana wäŋaŋura; ");
INSERT INTO gnn_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","djämanydja ŋayi yukurrana ḻatju'kuŋalana dhikana, bili Garraynydja ŋunhala nhanukala galki Djotjipkala. ");
INSERT INTO gnn_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Butipayu nhäŋala ŋanya Djotjipnha, ga wirrkina dhika galŋa‐ŋamathina ŋunhi Djotjipthu djäma yukurrana ḻatju'kuŋala wal'ŋu dhika, ");
INSERT INTO gnn_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","bala yana ŋuriŋiyi buŋgawayunydja ḏarramuyu warrpam' nhä malanha wekaŋala nhanukiyingalana Djotjipkalana goŋlili, djämamirrinhanydja malanha ŋunhi, ga nhä malanha ŋunhi yukurrana nhanŋu ŋorrana, ŋayi wekaŋala ŋunhi nhanukala Djotjipkala djäkalili warrpam'kuŋala yana. ");
INSERT INTO gnn_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Bala ŋuliŋuruyinydja Garrayyu guŋga'yurruna yukurrana walalanha ŋunhimalayi wäŋalili, ga gäŋala yukurrana ŋamathaŋala, bili wirrki ŋayi Garray yukurrana djäka nhanŋu Djotjipku. ");
INSERT INTO gnn_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Yo, Butipayu wekaŋalanydja bukmak nhä malanha Djotjipkalana goŋlili dharraylili; yakana ŋayi yukurrana ŋula waŋganygu nhäku warwuyurruna. Djotjiptja ŋunhi ḏarramu ḻatju'na dhika rumbal ga ganydjarrnydja ŋutu'na dhika ga buku‐ḻatju'na, ");
INSERT INTO gnn_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","bala ŋayi Butipawu ŋunhi miyalktja ḏukṯukmirriyina nhanŋu Djotjipku maŋutji'yunmaranharawuna. Bitjanana liŋguna ŋayi ŋuli wäthunanydja nhanŋu, waŋanhanydja ŋanya ŋuli garr'yunanydja yukurranha. ");
INSERT INTO gnn_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","9","Yurru ŋayi Djotjiptja waŋanha yukurranha ŋuli yaka'yunana yana, bitjanana liŋguna; yakana ŋayi ŋuli dhäruk märranha ŋanya. Ŋayi waŋana bitjarra Djotjip, “Nhokala dhuway'mirriŋuyunydja, ŋarrakala buŋgawayu bukmak nhä malanha dhiyalami wäŋaŋura wekaŋala ŋarrakiyingalana goŋlili warrpam'nha, ga ŋarra yurru yuwalkkuma yana djäkanydja dhiyaku malanyŋuwu nhanukalaŋuwu. Yurru nhenydja nhanŋuway yana; yakana ŋarra yurru bitjan ŋula marramba'yirri nhuŋu, märrama nhuna ŋarra yurru dhäwulnha, liŋgu dhuwalinydja yätjnha mirithirrina nhanukala maŋutjiŋura Godkalanydja.” ");
INSERT INTO gnn_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Bala ŋayinydja ŋuli ŋuriŋiyi dhäykayunydja bitjanana liŋgu munhamandhinya waŋanhana yukurranha ŋanya, ḏukṯukmirriyinyana nhanŋu Djotjipku, ga bitjanana liŋgu ŋayi ŋuli Djotjipthunydja waŋanhana ŋanya yaka'yunana. ");
INSERT INTO gnn_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Wiripuŋuyuna waluyu Djotjipthu nhinana djäma ŋunhiliyi wäŋaŋura ŋayipina gänana, ga yakana ŋula wiripu‐guḻkuny'tja djämamirri walala ŋunhiliyi. ");
INSERT INTO gnn_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Bala yana ŋunhi dhäykanydja marrtjinana lili, marrtji ga bur‐way ḏo'yun nhanbala Djotjippa, bala yana mulka nhanbala girri'na, bala garr'yunna ŋanya Djotjipnha bitjanna waŋa, “Go go ŋunhamala gärriya ŋarrakala wäŋalili go.” Yurru ŋayinydja Djotjiptja wirrkina dhika ganydjarr‐warryun, bala yana ṉaŋ'‐ṉaŋdhunna, gonha'yunna ŋunhi girriny'tja nhanŋuway nhanukalana goŋlili ŋurikala dhäykawalana. ");
INSERT INTO gnn_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Yurru ŋayinydja ŋunhi dhäykanydja wirrkina dhika maḏakarritjthirri, bala ṉaŋ'‐ṉaŋdhun warraŋullilina, ");
INSERT INTO gnn_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","bala yatjunna marrtji waŋa wiripu‐guḻku'wa warray djämamirriwa walalambala, ḻakarama bitjanna, “Way walala! Nhäŋa walala dhuwala ya', dhuwala gay'. Ŋunhiyi Yipuru ḏarramu gulŋiyina ŋarrakala wäŋalili, ŋayi bini ŋarrakala nhinanha, ŋayi ŋunhiyi ya' ŋarrakalaŋuwu dhuway'mirriŋuwu djämamirri. Wirrkina ŋayi ḏukṯukthina ŋarraku märranharawu, yurru ŋarranydja wirrki warray yukurrana yatjurruna.” ");
INSERT INTO gnn_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Bala ŋayinydja ṉaŋ'‐ṉaŋdhurruna dhawaṯthurruna dhikana‐wala, ga girriny'tja nayi dhuwala gonha'yurrunana ŋarrakalana galki. ");
INSERT INTO gnn_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Ga ŋunhi nhanŋu dhuway'mirriŋunydja bunana roŋiyina ŋunhala wäŋaŋuranydja, ");
INSERT INTO gnn_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","bala ŋayi ḻakaraŋala bitjarra yana liŋgu djawukina yana dhäwu'nhanbalanydja, ḻakaraŋalanydja ŋayi yukurrana bitjarra gam', “Ŋunhi ya', ŋunhi nhipala djämamirri yolŋu ḏarramu, ŋunhiyi marrtjina ŋarrakala wäŋalili, bala ŋayi ḏukṯukmirriyinana ŋarraku. ");
INSERT INTO gnn_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Yana ŋarranydja yatjurruna warray, bala ŋayinydja ṉaŋ'‐ṉaŋdhurrunana. Dhuwala nhäŋana, dhuwalana girriny'tja nhanbala ya'. Dhipala ŋayi ŋarrakalana gonha'yurruna.” Bitjarrana ŋayi yukurrana ŋuriŋiyi dhäykayunydja djawukinana ḻakaraŋala dhäwuny'tja. ");
INSERT INTO gnn_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Yurru nhanbala dhuway'mirriŋunydja wirrkina dhika ŋaramurryina, ");
INSERT INTO gnn_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","ga Djotjipnhanydja ŋayi yuwalknha dhika ŋilitjarana ŋunha ḻoḻulilina, yurru weyinnha ŋayi yukurrana gulŋiyinanydja ŋunhiliyi, dhä‐ḏir'yunaranydja nhanukuŋu. ");
INSERT INTO gnn_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Ŋe, yurru Garraynydja ŋunhalayi galki nhanukala Djotjipkala, ŋayi yukurrana gäŋala ŋanya ḻatju'kuŋala dhika, djäka nhanŋu yukurrana goŋ‐nherraṉmina, bala ŋunhi ḻoḻu‐djäkamirri ḏarramu buŋgawa yukurrana nhäŋala ŋanya ŋunhimala Djotjipnha, yurru wirrkina ŋayi goŋmirriyinanydja ŋunhi djäkamirrinydja ḏarramu, ŋunhi ŋayi yukurrana Djotjipthu ḻatju'kuŋala dhika ŋamathaŋala marrtjina djäma bala. ");
INSERT INTO gnn_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Bala ŋuriŋiyi djäkamirriyu yolŋuyu wiripu‐guḻku'nhanydja ŋunhi ḏarramuwurrunha djäkalili. wekaŋala nhanukalana Djotjipkalana. ");
INSERT INTO gnn_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Buŋgawanydja ŋunhi yakana ŋula warwuyurruna waŋganygu, bili ŋunhiyinydja bukmak nhä malanha goŋŋura nhanukiyingalana warrpam'nha Djotjipkalana, ga wirrki ŋayi yukurrana djäkanydja ḻatju'kuŋalana dhikana Djotjiptja, bili Garraynha nhanukalanydja galki gali'ŋura, djäka yukurrana nhanŋunydja. Yo, bukmak nhä malanha ŋayi yukurranha ŋuli djämanydja ḻatju'kunhana dhika, warrpam'nha manymaknha. ");
INSERT INTO gnn_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Waŋganymirriyu waluyu ŋayi Giŋ ŋunhi Yetjippuyŋu buŋgawa wirrkina dhika maḏakarritjthina märrma'wu nhanukiyingalaŋuwu djämamirriwu maṉḏaku. Yo, waŋganydja ŋunhi weyika'‐djämamirri, weyika' ŋayi ŋuli yukurranha djäma borum nhanŋuyi Giŋgu, ga wiripunydja ŋunhi ḏarramu ŋatha‐bathanaramirri, ŋayi ŋuli yukurranha ŋatha bathana Giŋgu, ");
INSERT INTO gnn_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","yurru ŋunhiyi buŋgawa Giŋ wirrkina ŋaramurrthina maṉḏaku, maḏakarritjthinana, ");
INSERT INTO gnn_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","bala yana maṉḏanha ŋilitjarra ḻoḻulilina, ŋunhiwalayi liŋgu ḻoḻulili ŋilitjara waŋgany‐manapara Djotjipkala, ");
INSERT INTO gnn_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","bala ŋayi Djotjiptja djäkana yukurrana maṉḏaku. ");
INSERT INTO gnn_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Wiripunydja munhaku ŋunhiyi maṉḏa ḏarramu ŋorrana yukurrana, bala maṉḏa bukaway'yirrina, yurru barrkuwatj bukawayny'tja. ");
INSERT INTO gnn_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Goḏarr'nha munhakumirrina maṉḏa gaŋgathirrinydja, bala maṉḏa bukunydja warwumirriyirri warray, bala ŋayi nhämana Djotjipthunydja maṉḏanha buku‐warwumirriyinyarana, ");
INSERT INTO gnn_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","bala dhä‐wirrka'yun maṉḏanha, “Way maṉḏa, nhäku dhuwala nhuma buku‐warwumirriyinanydja?” bitjarra. ");
INSERT INTO gnn_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Ga maṉḏanydja waŋana nhanukala buku‐ruŋiyinmaraŋala bitjarra, “Bukaway'yinya yawungu dhuwala ŋilinyu märrma'yu yana, yurru yakana ŋilinyu marŋgi yolthu ŋinyalaŋgu yurru mayali' ŋunhi bukaway' maḻŋ'marama.” Ga ŋayi Djotjiptja waŋa maṉḏakala bitjan, “Godthuna ŋayipina ŋuli bukawayny'tja ḻakarama warraŋulkuma. Go ḻakaraŋana maṉḏa ŋarrakalana.” ");
INSERT INTO gnn_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Ga ŋuriŋiyi waŋganydhunydja ḏarramuyu borum‐djämamirriyunydja ḻakaraŋala bitjarra, “Ŋarranydja bukaway'yina borum, ŋunhi yaŋarany'tja ŋuthara marrtjina bala baṉdja'baṉdjamirriyinana, ");
INSERT INTO gnn_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","yurru ḻurrkun' baṉdjanydja ŋurikiyi. Ga man'tjarrnydja marrtjina ŋutharana, ga burwu'mirriyinana, ga ŋuliŋurunydja bala borummirriyinana. ");
INSERT INTO gnn_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Bala ŋarranydja marrtjina märraŋala Giŋguna rupa, bala yana ŋunhiyi buriny‐mulka'‐mulkana borumdja, ŋunhimalayina weyikany'tja ḻarrmaraŋala rupa'lilina, bala gäŋala ga wekaŋala Giŋguna.” ");
INSERT INTO gnn_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Ga ŋayi Djotjipthunydja waŋana buku‐ruŋiyinmaraŋala nhanŋu bitjarrana gam', “Ŋunhiyi ḻurrkun' baṉdja'‐baṉdja, ŋuriŋiyinydja yukurra ḻakarama ḻurrkun' walu. ");
INSERT INTO gnn_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Dhäŋuru ḻurrkun' yurru walu djuḻkthun, bala ŋayi boŋguŋu Giŋdhunydja nhuna dhawaṯmaraŋuna. Ga biyapul nhe boŋguŋu djämayi ŋunhalayi, bitjarra nhe yukurrana ŋäthili djäma. ");
INSERT INTO gnn_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Yurru ŋunhi nhe boŋguŋu roŋiyi balayinydja, ga yaka meṉguŋu ŋarranhanydja. Guyaŋiyayi ŋarranhanydja, ga ḻakaraŋa ŋarranha Giŋba, ŋayi yurru guŋga'yun ŋarranha dhawaṯmarama dhipuŋuru ḻoḻuŋuru. ");
INSERT INTO gnn_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Liŋgu yaka ŋarra djäma ŋula nhä yätjtja, yana ŋayi ŋarranha ŋilitjara dhipala ḻoḻulili ŋula nhämiriwŋurana, ŋurrumiriwŋurana,” bitjarrana ŋayi Djotjipthu ḻakaraŋalanydja. ");
INSERT INTO gnn_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Ga dhäŋuru ŋuliŋurunydja, bala ŋayina ŋuriŋiyina ŋatha‐bathanaramirriyuna ḻakaraŋala nhanŋuwaynha bukaway' Djotjipku, ga bitjarra ŋayi waŋananydja, “Way, ŋarrakuŋunydja bukaway', ŋarra marrtjina gäŋala ḻurrkun' bathi, yurru ŋunhana bala garrwarnha wal'ŋu, muḻkurrŋurana ŋarrakala marrtjina bathi ŋal'yurrunanydja ŋunhi, ");
INSERT INTO gnn_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","ga ŋatha ŋunhiliyi gorruŋala marrtjina lili Giŋgu ŋatha. Yurru wäyindhu warray marrtjina lili ḻukananydja ŋunhi ŋathanydja malanha.” ");
INSERT INTO gnn_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Ga ŋayi Djotjiptja waŋana bitjarra, ḻakaraŋala dhunupana nhanŋu, “Nhuŋunydja bukaway' dhuwala dhuwala gam'. ");
INSERT INTO gnn_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Ḻurrkun' boŋguŋu walu djuḻkthurru, bala nhuna boŋguŋu buŋgawayunydja dhawaṯmaraŋuna, bala yana boŋguŋu nhuna muḻkurrnha gulkthurru, ga wäyindhuna nhuna boŋguŋu barrwaṉ'tja ḻuki ŋanaktja.” Ga bitjarra ŋayi Djotjipthu ḻakaraŋalanydja nhanbala. ");
INSERT INTO gnn_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Ga ḻurrkun' walu djuḻkthurrunana, bala yuwalkthi ŋayi Giŋdhunydja maṉḏanha maltjaṉa'kuŋalana, dhawaṯmaraŋalanydja ŋuliŋuru ḻoḻuŋurunydja, ");
INSERT INTO gnn_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","bala nherrara roŋiyinmaraŋalana ŋunhimalayi liŋgu djämalili, goŋ‐nherrara ŋunhiyi borum‐djämamirrinhanydja yolŋunha. ");
INSERT INTO gnn_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Ga ŋanya ŋunhi wiripunhanydja mayaŋ'nha gulkthurruna, bitjarra yana liŋgu ŋunhi nhaltjarra ŋayi Djotjipthu yukurrana ḻakaraŋala ŋäthili. ");
INSERT INTO gnn_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Ŋuriŋiyi borum‐djämamirriyunydja djäma yukurrana biyapul nhanŋu Giŋgu, yurru ŋayi yakana guyaŋina ŋanya Djotjipnhanydja, warrpam'nha meṉguŋala, buku‐dhumukthinana ŋanyanydja. ");
INSERT INTO gnn_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Yo, märrma' dhuŋgarra djuḻkthurruna, bala ŋayina Giŋdhuna bukaway'yina. Bukaway'yinanydja ŋayi ŋanyapinya ŋayi, ŋayi yukurrana djingaryurruna galki gali'ŋura mayaŋ'ŋura gapuŋura, ");
INSERT INTO gnn_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","ga nhäŋalanydja ŋayi waŋgany‐rulu ga märrma' bäythinyara buliki, walala dhawa‐yawaṯthurruna ŋuliŋuruyi gapuŋuru ŋutu'mirri gandarr. Dhawa‐yawaṯthurrunanydja yukurrana ŋunhiyi buliki malanha, bala yana ḻukanana marrtjina mulmuna. ");
INSERT INTO gnn_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Ga ŋuliŋurunydja ŋayi nhäŋala wiripu‐guḻku'nhana, balanyara yana liŋgu miṯtji, waŋgany‐rulu ga märrma' bäythinyara buliki dhawa‐yawaṯthurruna ŋuliŋuru gapuŋuru mayaŋ'ŋuru, yurru barka'mirri warray, makinymirri warray, walala walmananydja yukurrana ŋuliŋuru gapuŋuru, ga wäŋgaŋala marrtjina, ga bunana ŋurikiyi ŋutu'mirriwu buliki'wu walalaŋgu. ");
INSERT INTO gnn_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Bala walala ŋuriŋiyi barka'mirriyunydja ḻukanana, wurkthu'‐wurkthurrunana marrtjina ŋunhi ŋutu'mirrinhana dhawar'maraŋalana. Bala ŋayi ŋunhi Giŋdja marrtjina gaŋgathinana ŋuliŋuru yakurrŋurunydja. ");
INSERT INTO gnn_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Ga balayi ŋayi yakurrthina, bala wiripuna bukaway'yina. Bukaway'yinanydja ŋayi ŋatha birrali, nhäŋalanydja ŋayi waŋganybuy yaŋara'wuy, yurru waŋgany‐rulu ga märrma' bäythinyara maŋutjinydja birralinydja ŋunhiliyi dhaŋga'‐dhaŋgaŋala marrtjina, yurru ŋutu'mirrina dhikana maŋutji. ");
INSERT INTO gnn_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Ŋuliŋurunydja ŋayi nhäŋala ga wiripunhana birralinha yaŋara, ga ŋathanydja ŋunhili marrtjina maŋutjinydja dhaŋga'‐dhaŋgaŋala waŋgany‐rulu ga märrma' bäythinyara, yurru wirrkina wal'ŋu barka'mirrina binydjitjmirrina. ");
INSERT INTO gnn_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Bala walalanydja marrtjina ŋuriŋiyi binydjitjmirriyunydja birraliyu walalay wurkthu'‐wurkthurruna ŋunhi ŋutu'mirrinhana maŋutji birralinha. ");
INSERT INTO gnn_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Bala ŋayi marrtjina ŋuliŋurunydja Giŋdja gaŋgathinana, yurru wirrki ŋayi buku‐warwumirriyinanydja ŋuriŋiyi bukaway'yunydja, liŋgu ŋayi yakana marŋgi nhä ŋunhi mayali' ŋunhilimi bukaway'ŋura. Bala ŋayi dhäruknha djuy'yunmina ḻiya‐djambatjmirriwuna yolŋu'‐yulŋuwu. Walalanydja ŋuriŋiyi walalay withiyarana ŋanya lili, yurru yakana walala ŋula ḻakaraŋala dhunupa nhä ŋunhi mayali'. ");
INSERT INTO gnn_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Bala yana ŋuliŋurunydja ŋayi ŋunhiyi borum‐djämamirri waŋa nhanukala Giŋgala bitjanna, “Nhäwiyina dhuwala ŋarra yulŋunydja bay', be nhaltjarra. ");
INSERT INTO gnn_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Ŋunhala ŋunhi ŋarra yawungu gulŋiyirri yukurra ḻoḻuŋura, ");
INSERT INTO gnn_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","ga waŋganymirri munhaku ŋarra ga ŋuruŋu ŋatha‐bathanaramirriyu ŋilinyu bukaway'yirri, ");
INSERT INTO gnn_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","ga waŋganydhu ŋuruŋu ya' yuṯayu ḏarramuyu bäpurru'yu Yipuruyu, ŋayina ḻakaramanydja ŋinyalaŋgu ŋunhi maḻŋ'maramanydja bukawayny'tja. ");
INSERT INTO gnn_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Ga yuwalknha yana ŋunhi yulŋunydja, bitjandja ŋunhi ŋayi nhaltjan yukurra ḻakarama.” ");
INSERT INTO gnn_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Bala ŋayi Giŋdja dhäruk‐djuy'yunmirri bala ŋunhimala ḻoḻulilina, ga waŋa bitjanna, “Gäŋana lili Djotjipnhanydja dhipala ŋarrakalana dhawaṯmaraŋa.” Ga yuwalkthi ŋayi Djotjiptja wiriny'tjunmirri, ga girri'yunydja ŋayi manymakthuna dhaṯthunmirrinydja, bala marrtji Giŋbana buna. ");
INSERT INTO gnn_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Ga ŋayi buŋgawanydja waŋa nhanukala Djotjipkala bitjanna, “Yawungu ŋarra ŋäma nhokalaŋuwuy, ŋunhi nhepina yurru ḻakarama mayali' bukaway'wuynydja maḻŋ'marama.” ");
INSERT INTO gnn_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Ga ŋayi Djotjiptja waŋa nhanukala bitjan, “Ŋarrapinydja dhuwala yakaŋga yana marŋgi, ga yakana ŋarra ŋuli maḻŋ'maraŋu ŋunhiyi bukawayny'tja, yurru ŋayipina Godthuna yukurra maḻŋ'maramanydja, ŋayipina yurru ḻakarama mayaliny'tja.” ");
INSERT INTO gnn_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","24","Yurruna ŋayi ŋuriŋiyi Giŋdhu ḻakaraŋala nhanukuŋuway bukawayny'tja malanha ŋurikiynydja ŋunhi ŋayi nhäŋala bukaway'kurru, ŋunhi waŋgany‐rulu ga märrma' bäythinyarayu barka'mirriyu buliki'yu ḻukana ŋutu'mirrinha buliki'nha walalanha. Ga bitjarra yana liŋgu ŋayi bukaway'yina ŋunhi 7‐dhu birraliyu binydjitjmirriyu wurkthu'‐wurkthurruna ŋunhiyi 7‐nha maŋutji‐ḏilkurrumirrinha birralinha walalanha. ");
INSERT INTO gnn_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Bala Djotjipthu ḻakaraŋalana maḻŋ'thunmaraŋalana ŋurikiy bukaway'wuynydja; bitjarrana ŋayi ḻakaraŋalanydja ŋuriki buŋgawawu, “Dhuwaliyi märrma' bukaway', yurru waŋgany yana mayaliny'tja. Godthu yukurra ḻakarama nhuŋu ŋäthili, ŋunhi nhaltjan yurru ŋunhala bala yalala, ŋula nhaltjan ŋayi yurru djäma. ");
INSERT INTO gnn_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","27","Ŋunhi 7 buliki buyuwuyu'mirri ga 7 birrali maŋutji‐ḏilkurru ŋutu'mirri ŋatha, ŋunhiyinydjayi mayali' ḻakarama yukurra, ŋunhi yurru 7 dhuŋgarra ŋamakurru' yukurra yana djingaryun wäŋa, ga ŋatha yurru ŋuthan dhaŋaŋdhirri guḻku'thirri. Ga ŋuliŋurunydja dhurrwaraŋuru, bala yurru yakana ŋatha ŋuthan; wäŋa yurru warrpam'nha ganbarkthirrina, baṉḏanynha yukurra yurru djingaryun 7 dhuŋgarranydja. ");
INSERT INTO gnn_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","31","Godthu ḻakaraŋalanydja nhuŋu ŋunhi nhaltjan ŋayi yurru djäma, liŋgu dhiyala Yetjiptja 7 yurru dhuŋgarra ŋupan ŋatha‐maypamirri, ga dhäŋuru ŋuliŋurunydja 7 yurru dhuŋgarra ŋupan, ga wäŋanydja yurru dhuwala djingaryun yukurra wirrkina wal'ŋu baṉḏanynha. ");
INSERT INTO gnn_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Godthu nhuŋu ḻakaraŋala buku‐märrma'mirri, ŋunhi yurru yuwalk bitjandhiyinydja.” ");
INSERT INTO gnn_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","36","Bala Djotjiptja waŋana bitjarra ŋanya buŋgawanha, “Ma' djarr'yurrana ŋamakurru'nha yana ḏarramunhanydja ḻiya‐djambatjnha, ŋayi yurru yukurra djäka dhiyakuyi wäŋawunydja ŋamathama yana, märr ŋayi yurru yukurra ŋatha ŋorra ruwamŋuyirrina, ga märr yurru ŋunhi wiripunydja yätjtja, ŋunhi dhuŋgarra ŋupan, ŋayinydja yurru ŋathanydja yukurra ŋorra dhaŋaŋnha. Ŋuriŋiyinydja bala baṉḏanydhunydja dhuŋgarrayu yurru yukurra yolŋunydja nhina ḏulpuna yära, balanyarana ya', liŋgu ŋatha yukurra yurru ŋorra guḻku' yana, ga yakana yurru ŋula yolŋu'‐yulŋu marrya'yu rakunydhirrinydja.” Bitjarra ŋayi Djotjipthu ḻakaraŋalanydja. ");
INSERT INTO gnn_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Ŋayi Giŋdja ga nhanŋu djämamirrinydja walala waŋana yoraŋalana bitjarrana, “Ḻatju'na dhuwalanydja guyaŋinyara, mirithirrina manymak,” bitjarra. ");
INSERT INTO gnn_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Bala ŋayi Giŋdhu waŋana Djotjipnha bitjarra, “Yakana balanyarayi ḻiya‐djambatj yolŋu bitjan nhe dhuwala yukurra nhina dhiyalaŋumi, bili nhokalanydja dhuwala nhanŋuway Godku garrkuḻuk birrimbirr yukurra nhina. ");
INSERT INTO gnn_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Nhokalana ŋayi Godthu milkuŋala warrpam nhä malanha, ");
INSERT INTO gnn_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","bala ŋarra yurru nhunana goŋ‐nherraṉdja bukmakku dhiyaku malanyŋuwu. Bukmak yurru yolŋunydja walala mäkiri'‐witjun nhuŋuwaynha, ŋunhi nhaltjan nhe yurru waŋa walalanha. ");
INSERT INTO gnn_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Ŋarranydja yurru nhunana nherraṉ ŋurruŋukumanydja bukmakku dhiyaku wäŋawu Yetjippuyŋunydja.” ");
INSERT INTO gnn_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Ŋuliŋurunydja, bala ŋayi Giŋdhu yupmaraŋala nhanukiyingalanydja goŋŋuru goŋbuy girri', bala nherrara Djotjipkalana goŋlili, ga girri' dhika ḻatju' nherrara nhanukala, ga mayaŋ'puy girriŋgirriŋ bitjarra yana liŋgu nherrara nhanukalana ŋanyana dhaṯthurruna Djotjipnhana. ");
INSERT INTO gnn_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","45","Bala ŋayi Giŋdhunydja ŋurruŋu‐ḻakaraŋala Djotjipnhana garrwarkuŋalanydja, märr yurru yukurra yolŋunydja walala märr‐ŋal'yun nhanukalana. Ga biyapul nayi bitjarrayi bili wekaŋala miyalknhanydja nhanbala Djotjippa, wäŋa Yetjippuyŋunha dhäykanha, ");
INSERT INTO gnn_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","ga biyapul ŋayi yäkunydja nherrara wiripuna ŋanya Djotjipnha, Yetjippuynha yäku. Yo, Djotjiptja ŋulinyaramirriyu 30‐na nhanŋu dhuŋgarranydja, bala ŋayi Djotjip yukurrana marrtjinanydja buku‐ḻiw'maraŋala ŋula wäŋakurrunydja ŋathana marrtjina märraŋala, ");
INSERT INTO gnn_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","bala galkarana yukurrana yindililina buṉbulili ruwamŋu‐nherrarana. ");
INSERT INTO gnn_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Yo, 7 dhuŋgarra ŋupara ŋatha marrtjina ŋuthara ḻatju'kuŋalana, bala guḻku'na. Ŋayi Djotjipthunydja märraŋala yukurrana ŋunhi ŋathanydja, bala yana ruwamŋu‐nherrarana ŋurikina bala 7‐gu dhuŋgarrawu djaṉŋarrmirriwuna. ");
INSERT INTO gnn_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Ga ŋathanydja ŋunhi miṯtjinydja dhaŋaŋnha biyapulnha, bothurrumiriwnha, yakana ŋuli bothurru ŋunhiyi ŋatha mala ŋunhi nhanukuŋu ruwamŋu‐nherraṉaranydja. ");
INSERT INTO gnn_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","52","Ga ŋulinyaramirriyu dhuŋgarrayu 7‐dhu Djotjipku walkurnydja maṉḏanha maḻŋ'thurruna märrma'na. Ŋayi yäku‐nherrara ŋunhi maḻamarrnhanydja Manatja, ga malpuranhanydja ŋayi yäku‐nherrara Burayim. ");
INSERT INTO gnn_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","54","Yo, 7‐dhu dhuŋgarrayu ŋatha ŋuthara ŋamathina dhika dhaŋaŋnha. Ga ŋuliŋurunydja dhurrwaraŋuru ŋunhiyi dhuŋgarra malanynha djuḻkthunmaraŋalana warrpam'nha, bala ŋunhinydja bala wapthurruna baṉḏanylilina, bitjarra yana liŋgu ŋunhi yulŋunydja, ŋunhi nhaltjarra ŋayipi Djotjipthu yukurrana ŋäthili ḻakaraŋala. ");
INSERT INTO gnn_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Ga ŋunhala bäyma Yetjip wäŋanydja baṉḏanydhina, ga wiripunydja wäŋa bitjarra yana liŋgu dhika ḻiw'maraŋala warrpam' baṉḏanydhinana, bala bukmaknha marrtjina yolŋunydja walala nyä'yunminana ŋathawuna ḻarruŋala. Bala ŋayi Giŋdhunydja djuy'yurruna walalanha bala Djotjipkalana, ");
INSERT INTO gnn_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","ga ŋayi Djotjipthu ḻapmaraŋala ŋunhiyi ŋathamirrinydja buṉbu, bala rarr'yurrunana marrtjina yolŋu'‐yulŋuwana, ga bukmak ŋunhi Yetjippuyŋunydja yolŋu'‐yulŋu ḏulpumirrina. ");
INSERT INTO gnn_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Ga wiripu‐guḻku' yolŋu'‐yulŋu bitjarra yana liŋgu marrtjina lili, ŋulaŋuru bala wiripuŋuru wäŋaŋuru, ga ŋayi Djotjipthunydja bitjarra yana liŋgu wekaŋala walalambala, rarr'yurruna ŋatha, liŋgu ŋunhinydja wiripunydja wäŋa malanha bitjarraŋga bili yana baṉḏanydhina ŋanhdharkthina. ");
INSERT INTO gnn_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","2","Yo, ŋunha Gaynanbuynydja wäŋa bitjarra yana bili baṉḏanydhinana räwakthina, ga ŋayi Djotjipku bäpa'mirriŋunydja Djaykuptja ga nhanŋu Djotjipku wäwa'mirriŋu walala ŋunhi wirrkina djaṉŋarrthina, liŋgu ŋathanydja walalaŋgu bäyŋuthinana. Bala ŋayi Djaykupthu ŋäkula Yetjiplili, ŋunhi ŋatha yukurrana ŋunhala ŋorrana ruwamŋuyanhara, bala ŋayi worruŋuyu waŋana djuy'yurruna ŋunhi nhanŋuway gäthu'mirriŋunha walalanha bitjarra, “Nhä warray nhuma ŋuli marrtji bala Yetjiplilinydja ga märraŋu ŋatha ŋulaŋuru, märr ŋilimurru yakaŋga djaṉŋarrthirrinydja ga rakunydhirrinydja.” ");
INSERT INTO gnn_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Bala yana Djotjipku ŋunhi wäwa'mirriŋunydja walala märrma'‐rulu ŋunhi ḻaw'yurrunana, bala marrtjina Yetjiplilina ŋathawuna märranharawu. ");
INSERT INTO gnn_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Yurru Djaykupthu waŋganynhanydja ŋunhi yutjuwaḻa'nha gäthu'mirriŋunha nhanŋu yaka djuy'yurruna; ŋanyanydja ŋayi ga nherrara ŋunhimalana bäyma, bili ŋayi beyaṉiyina ŋuli ŋanya bäynha nhaltjurruna ŋula. ");
INSERT INTO gnn_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","6","Martj‐gay wäŋgaŋalana walala, ga ŋunhala liŋgu bunana Yetjip nhanbala Djotjippa, liŋgu Djotjiptja yukurrana nhinana ŋunhala Yetjiptja yindina buŋgawa; ŋayina ŋurruŋu wäŋawu ŋuriki Yetjippuyŋuwunydja, ga ŋayina ŋuli wuŋiḻi'yuna yukurranha wekanha ŋathanydja bukmakku yolŋu'‐yulŋuwu ŋunhi walala ŋuli ŋathawunydja marrtjinya. Bala ŋunhiyi wäwa'mirriŋu walala Djotjipku bunananydja, dhunupana walala warrkuḻunhamina munatha'lilina, bala yana buku‐nyilŋ'thurrunana yukurrana nhanukala Djotjipkala. ");
INSERT INTO gnn_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Ŋayi Djotjipthunydja nhäŋala walalanha dharaŋara ŋunhi nhanŋuway wäwa'mirriŋunha walalanha, yurru walalanydja ŋanya balanydja yaka warray dharaŋara. Bala ŋayi Djotjip yakayi ḻakaranhaminanydja ŋula walalaŋgala, yana ŋayi bitjarra djuḻuḻ'maranhamina ŋanyapinyay ŋayi yanapi ŋayi yaka marŋgi walalaŋgu. Bala ŋayi waŋananydja walalanha dhärukthu ḏälyuna, bitjarra dhä‐wirrka'yurrunana, “Wanhaŋuru dhuwala nhuma yolŋu'‐yulŋunydja?” Ga walalanydja ḻakaranhamina walalawuynha walala bitjanmina, “Ŋanapurrunydja dhuwala ŋurukuy Gaynanbuy wäŋawuy, ŋanapurru marrtjina lili wuŋiḻi'yunarawu ŋathawu.” Bitjarra walalanydja waŋana. ");
INSERT INTO gnn_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Ga mukthurruna walala yaka dharaŋaranydja, dhuŋamirri yana walala, yol ŋunhi ŋayi Djotjip. ");
INSERT INTO gnn_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Yurru yana walala buku‐nyilŋ'thurruna yukurrana nhanŋu Djotjipku, bala ŋayi Djotjipthunydja guyaŋina roŋiyinana ŋurikiynha ŋunhi baman'ŋuwuynha, ŋunhi ŋayi ŋäthili bukaway'yina, ŋunhi walala yukurrana nhanukala buku‐nyilŋ'thurruna. Bala ŋayi waŋananydja walalanha bitjarrana Djotjipthu, “Nhumanydja dhuwala mel'ŋu walala. Nhuma dhuwala marrtjina lilinydja, yana nhuma maḻŋ'marama marrtji nhäma wäŋa dhuwala, yanapi dhuwala ganydjarrmiriw wäŋa,” bitjarra. ");
INSERT INTO gnn_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Ga walalanydja waŋana bitjarra, “Yä‐ä‐äw yaka warray! Dhuwalanydja ŋanapurru marrtjina yana ŋathawu märranharawu. ");
INSERT INTO gnn_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Ŋanapurrunydja dhuwala bukmak wäwa'manydji walala; yaka ŋanapurru dhuwala mel'ŋu walala. Yolŋu walala wal'ŋu ŋanapurru dhuwala, yuwalkŋu.” ");
INSERT INTO gnn_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Ŋayi Djotjiptja waŋana biyapul bitjarra, “Yä‐ä‐äw! Dhuwalanydja nhuma mel'ŋu warray walala.” ");
INSERT INTO gnn_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Ga walalanydja waŋana nhanukala Djotjipkala bitjarra, “Way, ŋäthilinydja dhuwala ŋanapurru märrma'‐rulu ga märrma' bäythinyara muka wäwa'manydjinydja walala, waŋganyguŋu walkur‐märranhara. Waŋganydja gutha'mirriŋu ga liŋguna rakunydhinana, ga ŋunhanydja waŋganydhi yutjuwaḻany'tja, ŋunha bäyma mäḻu'wala nhina yukurra.” ");
INSERT INTO gnn_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Ga ŋayi Djotjiptja waŋana bitjarra, “Ŋarranydja nhumalanha yukurra gatjarr'yun yana dhuwala maḻŋ'marama, nhä nhuma mel'ŋu, mak bäyŋu. ");
INSERT INTO gnn_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","16","Yurru waŋganydja nhuma yurru dhipuŋuru ŋurrukŋuru marrtjiya balayi roŋiyiyayi ga garr'yurra ŋunhi yutjuwaḻa'nha gutha'mirriŋunha, ga yurruna ŋarra yurru marŋgithirrinydja ŋunhi nhuma yuwalk yukurra ḻakarama.” ");
INSERT INTO gnn_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Bala yana ŋuliŋurunydja ŋayi walalanha ŋilitjara ḻoḻulilina ḻurrkun' walu ŋupara. ");
INSERT INTO gnn_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Dhäŋuru ŋuliŋurunydja, yurruna ŋayi djuy'yurruna walalanha waŋana bitjarra, “Ma' marrtjiya walala gäŋa ŋathana, märr yurru nhumalaŋgu yumurrkuny'tja yakaŋga djaṉŋarrthirri, ");
INSERT INTO gnn_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","yurru waŋgany yurru dhiyalanydja bäymanydja nhina ḻoḻuŋuranydja. ");
INSERT INTO gnn_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Ga lilinydja nhuma boŋgaŋu gäŋu ŋunhiyi yutjuwaḻa'nhana gutha'mirriŋunha, märr ŋarra boŋguŋu ŋayaŋu‐yuwalkthi ŋunhi nhuma yuwalk yukurra ḻakarama, märr ŋarra yakaŋga yurru nhumalanha buma rakunygunydja, mel'ŋu ḻakaramanydja.” ");
INSERT INTO gnn_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Bala walala waŋanhamina walalawuy ŋunhiyi wäwa'mirriŋu walala bitjanmina, “Dhuwalanydja bitjarrayinydja ŋilimurruŋgu, bili ŋilimurru ŋunhi bumara gutha'mirriŋunha ŋilimurruŋguway, ga dhuwalayina ŋunhi marinydja. Ŋilimurru nhäŋala ŋunhi ŋilimurruŋguway gutha'mirriŋunha marilili, ga waŋana ŋayi ŋilimurrunha guŋga'yunarawu, yurru ŋilimurrunydja yaka warray ŋanya guŋga'yurruna, yaka warray ŋäkula ŋanya. Ga yurruna dhuwala marinydja ŋilimurruŋgu dhuwalana bunanana.” ");
INSERT INTO gnn_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ga ŋayi waŋganydja wäwa'mirriŋu waŋana ŋurruŋunydja Ropindja yäku bitjarra, “Liŋgu ŋunhi ŋarranydja waŋana nhumalanha ḏaḏawmaraŋala yakaŋuwu bunharawu nhanŋu, ga nhumanydja yaka warray ŋarraku buthuru‐witjurruna. Bala ŋayi rakunydhinana ŋunhi, ga dhuwalanydja ŋilimurruna yukurra galŋa‐yätjthirri yurru.” ");
INSERT INTO gnn_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Yo, waŋanharaminanydja walala yukurrana ŋunhi walalaŋgiyingala dhärukkurru, yurru ŋayi Djotjipthunydja dharaŋara yukurrana ŋäkula walalanha, ga walalanydja ŋanyanydja nhäŋala ŋamuŋala warray, yaka warray dharaŋara, liŋgu ŋayinydja yukurrana waŋana walalanhanydja ga wiripukurru Yetjippuyŋuwala dhärukkurru, yurru dhäruk‐märranharamirriwala. ");
INSERT INTO gnn_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Ga ŋuliŋurunydja ŋayi Djotjipthu gonha'yurruna walalanha, bala marrtjina, bala ŋäthinana yukurrana. Ŋäthina ŋayi nhinana beŋumi, ga ḏaḏawyurruna ŋäthinyaraŋuru mukthurruna, ga liliyi ŋayi roŋiyina. Ŋunhi ŋayi roŋiyinanydja lilinydja, walalanydja marrtjina dhärra'‐dharrana ŋunhiyi wäwa'mirriŋunydja walala yarrkaka. Ŋayi Djotjipthu nhäŋalanydja walalanha, bala yana dhunupa dhunupamirriyaŋalana ŋanya Djimiyannhana, waŋana bitjarrana, “Nhenydja yurru nhinana dhiyalana bäyma; ŋunhala ḻoḻuŋurana nhe yurru gulŋiyirri yukurra.” Bala walala galkara ŋanya Djimiyannhanydja bala ḻoḻulilina. ");
INSERT INTO gnn_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Ga ŋuliŋurunydja dhurrwaraŋuru Djotjipthu waŋana nhanŋuway ŋayi djämamirrinha walalanha ŋathawuna bathililiyanharawuna, ga waŋananydja ŋayi bitjarra, “Dhipala nhuma yurru ŋathanydja rarryu'‐rarryurra yukirriya bathilili malanyŋulili, ga balayi rrupiyanydja ŋili'‐ŋilitjarra, dhurrwaralili ŋunhi bathilili waŋga'‐waŋganygala yana bukmaklili.” ");
INSERT INTO gnn_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Yuwalkthi walala bitjarranydja yukurrana, bala yana walala ŋuriŋiyi wäwa'mirriŋuyunydja walalay ḻaw'‐ḻawmaraŋala ŋunhi bathinydja ŋathamirrinydja, bala yana wäŋgaŋala roŋiyinana. ");
INSERT INTO gnn_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Martj‐martjtjurrunana walala roŋiyinana‐a‐a, yana liŋgu wäŋgaŋalana marrtjina. Gutharr'ŋuranydja gulyurruna walala, bala nhina'‐nhinanana. Bala ŋayi waŋganydhunydja yupmaraŋala ŋunhi bathi ŋathawu wekanharawu nhanukalaŋuwu wäyingu duŋ'kiwu. Yupmaraŋalanydja ŋayi ŋunhiyi bathinydja, nhäŋala ŋunhiyi rrupiyanydja ŋunhimala warray, ŋayi yukurrana gärrina ŋunhili bathiŋura. ");
INSERT INTO gnn_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Bala ŋayi ṉirryurrunana nhäŋala, bala waŋana bitjarrana, “Way, dhuwalana dhuwala rrupiyanydja ŋarraku, liliyi roŋiyina dhuwala bathiŋura.” Bala walala bukmaknha ŋunhi wirrkina beyaṉiyinanydja. ");
INSERT INTO gnn_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Martj‐gay ŋuliŋurunydja wäŋgaŋalana, yana liŋgu bur‐bunana mäḻu'mirriŋuwa Djaykuppa, bala yana walala ḻakaraŋalana bukmak nhä malanha ŋunhi nhaltjarra yukurrana walalaŋgu ŋunhala. ");
INSERT INTO gnn_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Bitjarra walala nhanbala ḻakaraŋalanydja yukurrana, “Ŋunha buŋgawa Yetjippuyŋunydja rom‐ḏälnha yolŋu. Ŋayi guyaŋina yanapi ŋanapurru mel'ŋumirri, ga wirrkina yukurrana waŋananydja ŋayi. ");
INSERT INTO gnn_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","32","Ga ŋanapurrunydja nhanbala yawungu ḻakaranha yukurranha bitjana ŋunhi ŋanapurru wäwa'manydji walala 12, waŋganygu mäḻu'mirriŋuwu walwur‐walwur, ga ḻakarama ŋanapurru yawungu nhanŋu ŋunhi waŋganydja ŋanapurruŋgu gutha'mirriŋu liŋgu bäyŋuthina, ga yutjuwaḻa'nhanydja ŋanapurru yawungu ḻakarama ŋunha bäyma mäḻu'wala. ");
INSERT INTO gnn_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","34","Ga yurruna yawungu ŋayi ŋunhayi ḏarramu buŋgawa waŋanhanydja bitjana, ‘Nhuma boŋguŋu gäŋu ŋunhi yutjuwaḻa'nhanydja gutha‐ŋalinha nhumalaŋguway dhipala, ga yurruna ŋarra boŋguŋu marŋgithinydja nhumalaŋgu, ŋunhi nhuma yaka mel'ŋu walala.’ Ga yurruna ŋayi märranha Djimiyannhanydja yawungu, ŋilitjan ŋunha ḻoḻulilina, ga yana liŋgu ŋanapurru boŋguŋu Bindjamannha gäŋu balayi nhanukala.” ");
INSERT INTO gnn_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Bala walala bathinydja ŋunhiyi yup‐yupmaraŋala, mayaŋ dhurrwaranydja malanha bathinydja dhayaḻakuŋalana, ga bukmakthu warray maḻŋ'maraŋalanydja walalaŋguway rrupiyanydja malanha ŋunhimala bathilili malanyŋulili. ");
INSERT INTO gnn_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Bala ŋayi mäḻu'mirriŋunydja walalaŋgu wirrkina dhika beyaṉiyina, ŋayi waŋana bitjarra, “Bukmaknha yurru dhuwala ŋarraku djamarrkuḻiny'tja gäthu'mirriŋunydja walala winya'‐winyayunna ŋiniya? Djotjip winya'yurruna ga Djimiyan winya'yun yawungu, ga dhuwalanydja nhuma ga Bindjamannhana boŋguŋu djaw'yurru ŋarrakala.” ");
INSERT INTO gnn_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Ga ŋayi Ropindja waŋana mäḻu'mirriŋuwala bitjarra, “Ŋarrakala goŋlili wekaŋa ŋanya, ga ŋarra yurru nhanŋu djäka marrtji ŋamathama, ga lili ŋarra boŋguŋu roŋiyinmaraŋu nhokala. Ŋunhi ŋarra boŋguŋu yakanydja Bindjamannha roŋiyinmaraŋu liliyi nhokala, bala nhenydja boŋguŋu baymatthurru gäthu'mirriŋunhana maṉḏanha ŋarraku.” ");
INSERT INTO gnn_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Ga ŋayi Djaykuptja waŋana, “Bindjamandja yakana yurru yana marrtji. Wäwa'mirriŋu muka nhanŋu Djotjip rakunydhinanydja; ŋayipina dhuwala waŋganynha yukurra nhina walŋanydja. Ŋuli ŋanya yurru ŋula nhaltjandja, ŋarranydja ŋuli rakunydhina dhunupana birrka'yunarayu nhanukala warwuyunarayu. Bindjamandja yurru yakana yana marrtji nhumalaŋgu malthun,” bitjarra ŋayi mäḻu'mirriŋuyu ḻakaraŋalanydja. ");
INSERT INTO gnn_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Walunydja marrtjina djuḻk‐djuḻkmaraŋalana, ga mukthurruna yana wäŋanydja yukurrana djingaryurruna warrpam' räwak. ");
INSERT INTO gnn_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Djaykupthu ga nhanukala yumurrku'yu yolŋu'‐yulŋuyu malayu ŋuriŋiyi ḻukanana marrtjina ŋathanydja dhawar'‐way dhawar'yurruna, bala ŋayi waŋana nhanŋuway gäthu'mirriŋunha walalanha ŋunhi, biyapul djuy'yurruna bitjarra, “Ma' nhuma marrtjiya biyapul ŋan' balayi ŋunhamalayi, ga ŋatha biyapul märraŋa ŋilimurruŋguway.” ");
INSERT INTO gnn_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Yurru ŋayi Djudanydja waŋana bitjarra, “Ŋayi ŋuriŋiyi ḏarramuyunydja yurru yakana ŋathanydja ŋilimurruŋgu wekama, ŋunhi ŋanapurru yurru goŋ‐wayŋumirrinydja marrtji; yaka ŋanapurru yurru gäma gutha'mirriŋunha ŋanapurruŋguway. ");
INSERT INTO gnn_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Ŋuli nhe yurru djuy'yun Bindjamannha warray ŋanapurruŋgala, ga ŋunhinydja ŋanapurru yurru marrtji warray ga märrama ŋatha ŋunhala. ");
INSERT INTO gnn_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Ŋuli nhe yurru yakanydja djuy'yun ŋanapurruŋgala ŋanya, ŋunhiyinydja ŋanapurru yurru yakana marrtji. Liŋgu ŋunhayi ḏarramunydja waŋana ŋanapurruŋgala, ŋunhi yakana ŋanapurru yurru marrtji goŋ‐wayŋunydja nhanŋu.” ");
INSERT INTO gnn_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Ga Djaykuptja waŋana walalaŋgala bitjarra, “Nhäku nhuma balaŋu ḻakaranhamirrinydja ŋunhi nhumalaŋgu dhuwala gutha'mirriŋu?” ");
INSERT INTO gnn_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","“Ŋayi ŋunha yukurrana waŋana ŋunhayi ḏarramu dhä‐wirrka'yurruna yukurrana mukthurrunana ŋanapurrunha, ga waŋana ŋayi yukurrana bitjarra, ‘Be nhumalaŋgu bäpa'mirriŋunydja walŋa muka? . . . manymak muka ŋayi yulŋunydja? Wanhana ŋula nhumalaŋgu wiripunydja gutha'mirriŋu?’ Bitjarrana ŋayi marrtjina dhä‐wirrka'yurrunanydja ŋanapurrunha, bala ŋanapurru ḻakaraŋalana nhanŋu.” ");
INSERT INTO gnn_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Ga ŋayi Djudanydja waŋana bäpa'mirriŋuwala bitjarrana, “Wekaŋana ŋanya Bindjamannha ŋarrakalana dharraylili, bala ŋanapurru yurru marrtjina. Ŋunhi ŋanapurru ŋuli yakanydja marrtji, ŋilimurru yurru bukmaknha murrmurryun djaṉŋarrthinyarayu. ");
INSERT INTO gnn_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","10","Ŋarra yurru nhanŋu djäka marrtji, yana liŋgu ga roŋiyirri ŋanapurru yurru walŋa yana. Ŋuli ŋayi winya'yurrunydja ga rakunydhinanydja, nhenydja ŋuli ŋarranhana baymatthurru.” ");
INSERT INTO gnn_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Bala walalaŋgu bäpa'mirriŋunydja waŋana, “Gatjuy marrtjiyana‐wala walala. Gäŋanydja walala nhanŋu ŋuriki buŋgawawunydja ḻatju'mirri yana mundhurr, guku ga ŋatha malanha ga ŋula nhä ŋamakurru'mirri nhanŋu. ");
INSERT INTO gnn_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Ga roŋiyinmaraŋayi ŋunhiyi malanha rrupiyanydja ŋunhi liliyi. ");
INSERT INTO gnn_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Gatjuy, gäŋana dhuwala nhumalaŋguway gutha'mirriŋunhanydja. Waḏutja yana walala marrtjiyanydja, ga ŋunhili, ga lilinydja yana waḏutja. ");
INSERT INTO gnn_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Mak Godtja yurru ŋarraku mel‐wuyun, märr ŋayi yurru roŋiyinmaramayi dhuwalanha Bindjamannha ga Djimiyannha liliyi ŋarraku.” ");
INSERT INTO gnn_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Bala ŋuriŋiyi wäwa'mirriŋuyunydja walalay djoṉguŋalana ŋunhiyi mundhurrnydja malanha, ga garr'yurruna Bindjamannhanydja, bala yana wäŋgaŋalana Yetjiplilina. Wäŋgaŋalana walala marrtjina bala‐a‐a, yana liŋgu bur‐way ḏo'yurrunana ŋunhala Yetjipnha. Dhunupa walala withiyara ŋanyana Djotjipnhana, bala yana buku‐nyilŋ'thurrunana nhanŋu. ");
INSERT INTO gnn_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Djotjipthu nhäŋalana ŋanya Bindjamannhana walalaŋgala goŋlilina, bala ŋayi waŋanana nhanŋuway djämamirrinhana walalanha bitjarrana, “Dhuwalanhanydja walalanha märraŋana, ga garr'yurrana walalanha ŋarrakala wäŋalili. Ŋatha ŋathili gurrunharra ŋäthilimirriyaŋa, walala yurru ḻuka ŋayaŋayny'tja ŋarrakala.” ");
INSERT INTO gnn_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Yuwalkthi ŋuriŋiyi djämamirriyu walalay garr'yurrunana walalanha bala Djotjipkalana wäŋalili, ");
INSERT INTO gnn_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","yurru wirrki ŋunhi wäwa'mirriŋunydja walala beyaṉiyinanydja, buku‐wuranana rrupiyayu ŋuriŋiyi malanyŋuyu ŋunhi walala maḻŋ'maraŋala yukurrana bathiŋura walalaŋgalay ŋäthili. Bala walala guyaŋina bitjarrana yanapi walalanha ŋayi ŋunhi garr'yurruna ŋilitjanarawuna dhä‐ḏir'yunarawuna; bitjarra walala guyaŋinanydja yukurrana, “Mak ŋayi yurru ŋilimurrunha dhuwala dhark‐dharkkumana ŋiniya ḻoḻulilina, ḏapṯapmaramana nhanŋu djämamirrinhana walalanha.” ");
INSERT INTO gnn_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","22","Bala walala ḻakaraŋalana yukurrana djämamirriwanydja walalambala ŋurukuy rrupiyawuynydja, “Ŋay' dhuwalana rrupiyanydja ŋunhi ŋanapurru maḻŋ'maraŋala yukurrana ŋanapurruŋgalay bathiŋura malanyŋuŋura, ga dhuwala ŋanapurru ŋayathama yukurra wiripunydja rrupiya ŋathawu.” ");
INSERT INTO gnn_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Ga walala ŋunhi djämamirriyunydja walalay waŋana walalanha bitjarra, “Yaka nhuma barrariya, bili ŋayi mak nhumalaŋgalaŋuwala bäpa'mirriŋuwala Godthu waŋarryu ŋayipi ŋili'‐ŋilitjara roŋiyinmaraŋala liliyi nhumalaŋgala bathilili. Liŋgu warray ŋarranydja märraŋala rrupiya nhumalaŋguŋu.” Ga ŋuliŋurunydja walala garr'yun ŋanyanydja dhawaṯmaramana Djimiyannhanydja ŋulaŋuru ḻoḻuŋurunydja, dhawaṯmaramana ga ŋunhimalayi waŋgany‐manapanna walalaŋgala. ");
INSERT INTO gnn_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Ga bitjandhi bili djämamirriyunydja walalay rurrwuyun yukurra djalkirinydja, ga biyapul walala yukurra ŋathanydja ga gapunydja wekama walalaŋgalaŋuwu yarraman'kunydja walalaŋgu. ");
INSERT INTO gnn_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","26","Ga ŋunhi ŋayi Djotjiptja roŋiyirri beŋuru djämaŋurunydja, wäŋaŋuranydja buna, bala walala rarr'yunna marrtji nhanbala ŋunhi mundhurrnydja malanha, ga biyapul walala buku‐nyilŋ'thun yukurra nhanŋu Djotjipku. ");
INSERT INTO gnn_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Ga ŋayi walalanha dhä‐wirrka'yun bitjan, “Nhä nhumalaŋgu bäpa'mirriŋunydja? . . . walŋaŋga? Ga mukthun ŋayi nhina yukurra be walŋa yana?” ");
INSERT INTO gnn_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Ga walalanydja buku‐ruŋiyinmarama ŋunhi bitjan, “Ŋe, ŋanapurruŋgu mäḻuny'tja ŋunha walŋa muka, ga ḏäwala muka yukurra nhina.” Ga biyapul walala buku‐nyilŋ'thun, buku‐ŋal'yun nhanŋu Djotjipku. ");
INSERT INTO gnn_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Ga ŋunhi ŋayi nhäma Bindjamannhanydja nhanŋuway gutha'mirriŋunha, Djotjipthu bala waŋa bitjanna, “Dhuwalana ŋayi nhumalaŋgu yutjuwaḻany'tja gutha'mirriŋu? . . . ŋunhi nhuma ŋarraku ŋäthili ḻakarama?” Bala ŋayinydja waŋa Bindjamannhana bitjan, “Godthu yurru gäma nhuna ḻatju'kuma, ŋarraku gäthu.” ");
INSERT INTO gnn_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Bala ŋayi dhunupa bilyundja, bala gonha'yun walalanha, bala marrtji ganaŋ'thunna, liŋgu ŋayi ŋoy‐dhaŋaŋdhirri nhanukalaŋuwu gutha'mirriŋuwu Bindjamangu. Ŋayi bini ŋunhalana ŋäthinya ŋuli ya' bäymana gumurrŋurana walalaŋgala, yurruna ŋayi ŋunhi waḏutjanydja yana marrtji warraŋullilina dhawaṯthun, bala ŋunhala ŋayi yukurra gänana ŋäthi. ");
INSERT INTO gnn_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Ḏaḏawyun ŋäthinyaraŋuru mukthun, ga bukunydja rurrwuyunmirri, bala liliyi ŋayi gulŋiyirri, ga djämamirrinhana walalanha nhanŋuway waŋa ŋathawuna gurrunhanarawu. ");
INSERT INTO gnn_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Yo, ŋayipinydja Djotjiptja nhina gänaŋuwala bala'palalili, ga walalanydja ŋunhi nhanŋu wäwa'mirriŋunydja walala wiripuŋulili bala'palalili, liŋgu walala ŋuli Yetjippuyŋuyunydja yolŋu'‐yulŋuyu ḻakaranha yukurranha Yipurupuyŋunhanydja nhäŋiniŋ'‐ḻakaranhana, yakana walala ŋuli ḻukanha walalaŋgala galki. ");
INSERT INTO gnn_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Bala yarrkakana walala nhinananydja marrtji bitjan ya' ŋunhilimi, yurru wirrkina walala ŋunhi ṉirryunna nhämanydja, liŋgu ŋayi marrtji ŋuriŋiyi djämamirriyunydja walalanha yäku ḻaka'‐ḻakaramanydja ga nherra'‐nhirraṉdja ŋunhimalayi liŋgu dharapullili, ŋulaŋuru bili maḻamarrwala ŋurruŋuwala ŋurikala wäwa'mirriŋuwala, ga yana liŋgu ga yutjuwaḻa'wala wapthun. Walala ŋunhi wäwa'mirriŋunydja walala mel‐nhänharamirrina walalawuynha walala, bala waŋanhamirri, “Nhäku warray dhuwala walala marrtji bitjandja ŋilimurrunha nherraṉ? Yolthu dhuwala walalaŋgu ḻakaraŋalanydja?” ");
INSERT INTO gnn_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Bala yana walala ŋathana wekaŋala marrtjina lili walalanha, waŋga'‐waŋganyguna rarr'yurruna marrtjina ŋathanydja, yurru nhanŋunydja Bindjamangunydja walala wekaŋala biyapul warray dhaŋaŋ warray ŋatha. Bala walala ḻukanana yukurrana‐a‐a, yana liŋgu ga ḏulpu'‐ḏulputhina. ");
INSERT INTO gnn_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Ga ŋuliŋurunydja dhurrwaraŋuru bala ŋayi Djotjiptja waŋana nhanŋuway djämamirrinha walalanha bitjarra, “Ma' ŋathanydja bathililiyaŋana marrtjiya bukmaklili bathilili malanyŋulili dhiyapanydja walalambala ḏarramuwurrumbala, dhaŋa'‐dhaŋaŋguŋa yana, ga dhälilinydja gurru'‐gurrunhara bathilili malanyŋulili roŋiyinmaraŋayi ŋunhiyi rrupiyanydja malanha walalaŋgu waŋga'‐waŋganygu yana. ");
INSERT INTO gnn_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Yurru ŋunhamala yutjuwaḻa'walanydja ŋathamirrilili bathilili ŋilitjarra ŋarraku dhuwala miḻŋ'‐miḻŋdhunara rupa rrupiya‐guḻku'mirri.” Ga yuwalkthi ŋuriŋiyi djämamirriyunydja bitjarrayi, ");
INSERT INTO gnn_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","ga goḏarrny'tja munhakumirrinydja bala ḻaw'yurrunana marrtjinana wäwa'manydjinydja walala. ");
INSERT INTO gnn_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Wäŋgaŋalanydja walala yukurrana‐a‐a, ga märr walala bitjarra wuyupthurruna ya', bala ŋayi Djotjipthunydja djämamirrinhana djuy'yurruna ḻundu‐ŋupanarawuna walalaŋgu, ŋayi waŋananydja ŋanya djuy'yurruna bitjarra, “Gatjuy waḏutja! Wäŋgaŋa ŋuparra ŋunhiyinha walalanha, ga yana liŋgu ga mulkiya walalanha, ga waŋiyanydja biyaka walalaŋgala, ‘Ŋarra nhumalanha wekaŋala ŋamathaŋala, ga nhäku warray nhuma ŋarranhanydja yätjkuŋala liliyi? ");
INSERT INTO gnn_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Nhäku nhuma manaŋina ŋarrakalaŋuwu buŋgawawunydja rupa? Yätjnha mirithirrina dhuwalanydja ŋunhi nhuma bitjarranydja,’ biyaka nhuma yurru waŋiyanydja.” ");
INSERT INTO gnn_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Bala ŋunhi djämamirrinydja waṉḏina, yana liŋgu baṯ‐gay mulkana walalanha, ga waŋana ḻakaraŋala yukurrana Djotjipnhana dhäruk. ");
INSERT INTO gnn_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Ga walalanydja waŋana buku‐ruŋiyinmaraŋala lili bitjarra, “Nhä dhika? Nhaltjan nhuma yukurra waŋanydja? Yaka warray ŋanapurru manaŋina be rupa. ");
INSERT INTO gnn_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Nhäkuna ŋanapurru bini bitjananydja? ");
INSERT INTO gnn_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Ḻarruŋana walala go, ga ŋuli nhuma yurru maḻŋ'marama warray waŋganygala ŋula yolkala bathiŋura, ga ŋunhiyinydja nhuma yurru yolŋunha bumana rakunyguna, ga ŋanapurrunha wiripu‐guḻku'nhanydja yana ŋilitjarra nhumalaŋguway djämamirrinhana walalanha.” ");
INSERT INTO gnn_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","12","Bala ŋuriŋi djämamirriyunydja nhäŋa'‐nhaŋalana yup‐yupmaraŋala marrtjina bathinydja malanha, maḻŋ'‐gay maḻŋ'maraŋala nhanukalana Bindjamangalana bathiŋura ŋunhiyi rupany'tja garwarrwarrny'tja. ");
INSERT INTO gnn_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Yurru walala ŋunhi wäwa'mirriŋunydja walala wirrkina dhika buku‐wurana ga warwuyunminana. Ḏutj‐gay roŋi'‐ruŋiyina walala bukmaknha yana balayi Yetjipliliyi. ");
INSERT INTO gnn_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Walala gärrinanydja bunananydja, bala yana walala buku‐nyilŋ'thurruna Djotjipku. ");
INSERT INTO gnn_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Ga ŋayi waŋana walalanha dhä‐wirrka'yurruna bitjarra, “Nhaltjarra dhuwala nhuma yulŋunydja? Nhäku warray nhuma manaŋinanydja ŋarraku rupany'tja? Nhaltjarra nhuma buku‐dhumukthina? . . . ŋarra bini yakana ŋunhi maḻŋ'maranhanydja nhumalaŋgala?” ");
INSERT INTO gnn_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Ga Djudanydja waŋana buku‐ruŋinyamaraŋala Djotjipku bitjarra, “Yakana ŋanapurru yurru waŋa nhokala. Nhaltjanna ŋanapurru yurru milkunharamirrinydja ŋunhi ŋanapurru yaka manaŋina. Ŋanapurru yätjkuŋala djäma ŋäthili, ga dhiyaŋunydja‐wala Godthu yukurra maḻŋ'maramana ŋunhiyi yätj. Bukmaknha ŋanapurru nhinana yurru dhiyalana nhuŋu djämamirrina walala, yakayi yana ŋunhiyi waŋganydja ŋunhi rupa nhanukala maḻŋ'maraŋala.” ");
INSERT INTO gnn_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","“Yä‐ä‐äw yaka,” bitjarra ŋayi Djotjiptja. “Ŋunhiyi liŋgu yurru nhinanydja, ŋunhiyi ŋunhi nhanukala rupa yukurrana gärrina, ŋayipi yurru ŋarraku djämamirrinydja, ga wiripu‐guḻkuny'tja nhuma marrtjiya balayi bäpa'mirriŋuwala nhumalaŋgalaŋuwala.” ");
INSERT INTO gnn_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Ga ŋayi Djuda wapthurruna, ga waŋana bitjarra Djotjipkala, “Buŋgawa, yaka ŋarraku mari‐wuniyanydja maḏakarritjthiyanydja. Nhenydja dhuwala yindi buŋgawa, bitjan ŋayipi giŋ, ŋarra nhuŋu yurru ḻakaramana. ");
INSERT INTO gnn_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","20","Bili ŋanapurru nhuŋu ŋäthili ḻakaraŋala, ŋunhiyi ŋanapurruŋgu bäpa'mirriŋunydja worruŋuna. Nhanŋu gäthu'mirriŋunydja maṉḏa waŋganybuy yana ŋäṉḏiwuy, yurru waŋganydja ŋuliŋuruyi liŋguna bäyŋuthinana, ga mäḻuny'tja yukurra wirrkina marrkapthun dhiyakunydja Bindjamangunydja. ");
INSERT INTO gnn_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","23","Ŋunhi ŋanapurru yurru gonha'yun ŋanya dhipalanydja bäyma, ŋanapurruŋgu bäpa'mirriŋunydja ŋuli rakunydhina. ");
INSERT INTO gnn_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","26","“Mäḻuny'tja yaka ḏukṯukmirriyina, ŋayi bini Bindjaman yakaŋga malthuna ŋanapurruŋgu, yurru ŋanapurrunydja waŋana bitjarra, ‘Ŋunhi ŋanapurru yurru yakanydja ŋanya garr'yun, ŋayi yurru ŋuriŋi ḏarramuyu ŋunhalanydja buŋgawayunydja yakana ŋanapurruŋgu ŋatha wekama,’ bitjarra ŋanapurru waŋananydja ŋanya. ");
INSERT INTO gnn_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Ga mäḻuny'tja wirrki yana galŋa‐yätjthina, ga waŋana bitjarra, ‘Miyalkthu ŋarrakala Raytjulyu gurrukaŋala märrma'nha yana waku'mirriŋunha maṉḏanha. ");
INSERT INTO gnn_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Waŋganydja liŋguna bäyŋuthinana; wakinŋuyu wäyindhu ŋanya bumara. ");
INSERT INTO gnn_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Ga ŋuli ŋarra yurru dhuwalanydja ŋurrkama, ŋarranydja yurru wirrkina warwuyun nhanŋu, ga ŋuriŋiyi warwuyunarayu ŋarranha yurru rumbal‐winya'yunmaramana, bili ŋarra dhuwala worruŋuna.’ Bitjarra ŋayi mäḻuny'tja yukurrana waŋana. ");
INSERT INTO gnn_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","“Yaka ŋarra yurru roŋiyirri bala mäḻu'walanydja goŋ‐wayŋu dhiyakunydja gurrmulwu; ŋayi yurru yana rakunydhirrina ŋuriŋiyi warwuyunarayuna. ");
INSERT INTO gnn_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Ŋarra wäwunguŋala ŋanya djäkawu nhanŋu ga roŋinyamaranharawu liliŋuwu. ");
INSERT INTO gnn_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Buŋgawa buku‐djulŋi, nhinanhamaraŋa ŋarranhana, ŋarra yurru dhiyala yukurra nhina gutha'mirriŋuwala ŋarrakalaŋuwala dharapulŋura; ŋarrana nhuŋu yurru djämamirrinydja, ga ŋanyanydja djuy'yurrana‐wala ŋarrakalaŋuwala bäpawalana. ");
INSERT INTO gnn_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Ŋuli ŋarra yurru roŋiyirri gänanydja bala mäḻu'walanydja, ŋayi yurru mäḻuny'tja wirrkina galŋa‐yätjthirri. Yakana ŋarra ḏukṯuk nhanŋu rakunydhinyarawu.” ");
INSERT INTO gnn_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Djotjiptja wirrkina dhika ŋoy‐warrina dhaŋa'‐dhaŋaŋdhinana marrtjina nhanukalaŋuwu ŋuriki wäwa'mirriŋuwunydja walalaŋgu, bala ŋayi djuy'yurruna djämamirrinha walalanha warraŋullili, walalawuynha ŋunhi Djotjipnha ga nhanŋu wäwa'mirriŋuna walala ganaŋ'thurrunana. ");
INSERT INTO gnn_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Bala ŋayi ḻakaranhaminana nhanukalaŋuwa wäwa'mirriŋuwana walalambala ŋuripana, yurru ŋayi wuythurrunana dhikana ŋäthinanydja dhä‐warrwarnha ye'yurruna. Walala ŋuriŋiyi Yetjippuyŋuyunydja ŋäkulana ŋanya, ga dhäwuny'tja buḻwaŋ'thurrunana wäŋakurrunydja buku‐ḻiw'maraŋala, giŋgunydja wäŋa. ");
INSERT INTO gnn_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Ga bitjarrana Djotjiptja ḻakaranhamina nhanukalaŋuwa wäwa'mirriŋuwa walalambala, “Ŋarranydja dhuwala Djotjip muka. Ŋarraku mäḻuny'tja be walŋa muka?” Walala ŋunhi wäwa'mirriŋuyunydja walalay ŋäkulana ŋanya, bala wirrkina dhikana beyaṉinyaminanydja, ga yakana buku‐ruŋiyinmaraŋala ŋula waŋgany dhäruk. ");
INSERT INTO gnn_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Ga Djotjipthu waŋana walalanha bitjarra, “Go marrtjiya giṯthurra walala dhipala galkithiya ŋarrakala.” Bala walala giṯthurrunayi, ga ŋayinydja waŋana bitjarra, “Ŋarranydja dhuwala nhumalaŋgu muka ŋunhi gutha'mirriŋu Djotjip muka, ŋunhi muka ŋunhi nhuma wuŋiḻi'yurruna, bala walala gäŋalana ŋarranha dhipalana wäŋalili Yetjiplilina. ");
INSERT INTO gnn_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Yaka buku‐goriya walala, ga yaka ḻiya‐ŋarrtjunmiya walala nhumalanhay nhuma, ŋunhi nhuma wuŋiḻi'yurruna ya' ŋarranha rrupiyawu. Yuwalktja wal'ŋu ŋunhi ŋayipi Godthu ŋarranha djuy'yurruna dhipala walŋakunharawu yolŋu'‐yulŋuwu dhiyaku. ");
INSERT INTO gnn_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","“Yo, dhuwalanydja ganbarkthirrinydja yawungu märr‐gurriri yana yulŋunydja, yurru märr‐weyin yurru ŋupandja, yurruna yurru ŋatha ŋuthan biyapul ŋamathirri. ");
INSERT INTO gnn_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Godthu djuy'yurruna ŋarranha dhipala nhumalaŋgu walŋakunharawu, märr nhuma yurru ŋatha muka märrama ḻukanharawu, märr nhumapi ga nhumalaŋgu mala yurru ŋuthan ga yakaŋga murrmurryun djaṉŋarrthinyarayu. ");
INSERT INTO gnn_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Yaka ŋunhi yuwalktja nhumanydja djuy'yurruna lili ŋarranha, ŋunhinydja Godthu ŋayipi yana, ga ŋayipi nherrara ŋarranha dhipala ŋurruŋukuŋala. Dhuwala wäŋa buku‐ḻiw'marama Yetjippuy ŋarrakalaynha yana goŋŋura. ");
INSERT INTO gnn_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","“Ma' marrtjiyana walala gatjuy bala ŋarrakalaŋuwala bäpawala, ga ḻakaraŋa nhanbala ŋunhi Djotjiptja dhuwala walŋa muka yana. Ḻakaraŋa walala nhanbala biyaka, ŋayi marrtjina lilina yurru dhipalana wäŋalili, ga nhina ŋarrakalana galkina. ");
INSERT INTO gnn_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Dhiyalana nhuma yurru nhiniyanydja yukirriya ŋunhala Gutjinnha, nhumapi ga nhumalaŋgu yumurrku' ga nhumalaŋgu wäyin walala ga ŋula nhä malanha ŋunhi nhuma yukurra ŋayathama. ");
INSERT INTO gnn_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Ŋarrapi nhumalaŋgu yurru djäkanydja. Nhuma yurru märramana yukurra ŋula nhänydja malanha, yakana nhuma yurru djaṉŋarrthirri; ḏulpuna yana yurru nhina yukurra bitjanna liŋgu. ");
INSERT INTO gnn_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","“Liŋguna nhuma yukurra nhämana dhuwala ŋarranha ŋunhi ŋarranydja dhuwala yuwalk Djotjip. ");
INSERT INTO gnn_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Ḻakaraŋa ŋarrakalaŋuwala bäpawalanydja ŋunhi ŋarranydja dhiyalami Yetjip nhina yukurra ganydjarr‐ḏumurru yana, ga ḻakaraŋanydja nhanbala bukmak nhä‐malanha ŋunhi nhuma nhäŋala dhiyala. Gatjuy waḏutjana marrtjiyanydja walala, ga garr'yurrana ŋanya lili.” ");
INSERT INTO gnn_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Bala ŋayi gaḻummaraŋala dhangi'yurrunana nhanŋuway gutha'mirriŋunha Bindjamannhanydja, bala ŋäthinana, ga bitjarra yana liŋgu Bindjamandhunydja dhangi'yurruna Djotjipnhanydja ga ŋäthinayi. ");
INSERT INTO gnn_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Ga bitjarrayi bili ŋayi ŋunhi wiripu‐guḻku'nhanydja dhangi'‐dhangiyurruna ga wälku'‐walkuŋala marrtjina, ga yurruna walala waŋananydja ŋunhiyi wäwa'mirriŋunydja walala nhanukala. ");
INSERT INTO gnn_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Ga Giŋdhunydja ŋäkula galŋa‐ŋamathina ŋunhiyi walalanha ŋunhi Djotjipku wäwa'mirriŋu walala bunana, ");
INSERT INTO gnn_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","18","ga waŋana ŋayi Djotjipkala bitjarra, “Ma' ḻakaraŋa wäwa‐ŋaliwanydja walalambala, walala marrtjina yurru lilina dhipalana wäŋalili, ga dhiyalana nhina yukurra yurru Yetjipnha, mäḻu'mirriŋu nhuŋu ga bukmak ŋunhi yolŋu walala dhiyalana yukurra nhina yurru. Ŋarra yurru wekama walalaŋgu manymak yana wäŋa dhiyala Yetjiptja, märr yurru walala nhina yukurra ŋamathama dhiyalanydja wäŋaŋura. ");
INSERT INTO gnn_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","20","“Gatjuy weka'‐wikaŋa nhokalaŋuwa wäwa'mirriŋuwanydja walalambala ŋula nhä malanha mundhurrnha, walala yurru gäma bäpa'mirriŋuwu nhokalaŋuwu; ŋayi marrtjina yurru lilina dhipalana, ga dhiyalana nhina Yetjipnha.” Bitjarra ŋayi buŋgawayunydja ḻakaraŋala Djotjipku. ");
INSERT INTO gnn_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Bala yana ŋayi Djotjipthu rarr'yurruna ŋathana malanha, ga yarraman'nha malanha ga girri'na malanha nhanukalaŋuwa ŋuripa wäwa'mirriŋuwanydja walalambala, ");
INSERT INTO gnn_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","yurru nhanbala Bindjamanbanydja ŋayi rarr'yurruna dhaŋaŋnha dhika rrupiya ga dhaŋaŋnha girri'. ");
INSERT INTO gnn_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Ga bitjarrayi liŋgu ŋayi rarr'yurrunayi nhanbala mäḻu'mirriŋuwanydja girri' ga ŋatha biyapulnha dhaŋaŋ dhikana, bala yana djuy'yurrunana walalanha wäŋalilina. ");
INSERT INTO gnn_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","“Ga yakana marrtjiya bala ŋarrtjunmiya gandarrkurrunydja,” bitjarra ŋayi Djotjipthu waŋananydja. ");
INSERT INTO gnn_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Bala yana walala marrtjinana gonha'yurrunana ŋunhi Yetjippuynydja, marrtjina roŋiyinana bäpa'mirriŋuwana, bunana Gaynanlilina. ");
INSERT INTO gnn_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Ŋunhala bäpa'mirriŋuwanydja bunana, bala ḻakaraŋala bitjarrana, “Way, Djotjiptja ŋunha walŋaŋga, buŋgawana ŋunha ŋayi Yetjippuyŋuwuna yulŋunydja.” Bala ŋayi bäpa'mirriŋuyunydja Djaykupthunydja ŋäkula, bala gulkuruna märr‐yuwalkthinanydja ŋayi. ");
INSERT INTO gnn_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Yurru walala milkuŋalana marrtjina gay' girri'na be nhäna malanha nhanukuŋu rarr'yunarana, ga yurruna ŋayi märr‐yuwalkthinanydja. ");
INSERT INTO gnn_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","“Gäthunydja ŋunha ŋarrala walŋaŋga Djotjiptja, yuwalknha walŋana ŋi'! Waḏutja ŋarra marrtjina, ŋarra nhämana ŋanya, yurruna ŋarra yurru rakunydhirrinydja.” Bala Djaykupthu girriny'tja marrtjina dhoṯkuŋalana bukmak nhä malanha bilina gurku'yurrunana. ");
INSERT INTO gnn_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Ŋäthili walala marrtjinanydja ŋunha Biratjipalili, ga ŋunhala Djaykup buku‐ŋal'yurrunanydja yukurrana ga mundhurr bathara nhanŋu Garraywu. ");
INSERT INTO gnn_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Ga God maḻŋ'thurruna nhanukala, ga yäkuna ŋanya ḻakaraŋala bitjarra, “Djaykup, Djaykup,” bitjarra yukurrana. Ga ŋayinydja waŋana bitjarra, “Gay' dhuwala ŋarra.” ");
INSERT INTO gnn_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Ga ŋayi waŋana Godtja bitjarra, “Ŋarraŋga dhuwala nhokalaŋuwu bäpa'mirriŋuwu waŋarr. Yaka nhe beyaṉiya. Marrtjiyana‐wala yana Yetjiplilina, ga ŋunhalanydja ŋarra yurru miṯtji guḻku'kumana, dhaŋaŋgumana nhuŋu, ga nhinanydja nhe yukurra yurru mala‐guḻku'mirrina. ");
INSERT INTO gnn_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Ŋarranydja yurru malthundhi marrtji nhuŋu, ga ŋarrapi yurru nhuŋu malanhanydja roŋiyinmaramayi dhipalayi wäŋalili. Ga ŋayi yurru Djotjiptja nhokala galki ŋunhi nhe yurru rakunydhirrinydja.” ");
INSERT INTO gnn_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","6","Bala Djaykuptja gaŋgathinana, gonha'yurrunana Biratjipanydja wäŋa, bala yana marrtjinana, gäŋala yukurrana yolŋu'yulŋunhana nhanŋuway, ga wäyin ga dhika nhä, marrtjinana‐wala yana Yetjiplilina. ");
INSERT INTO gnn_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Yurru Djaykupkuŋu ŋunhi guwar‐yalkthunaranydja märr‐ḻurrkun' yana, ŋunhi walala marrtjina bala Yetjiplili, ");
INSERT INTO gnn_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","ga Djotjipkunydja walkur märrma' yana. Yo, ŋunhiyi Djaykupku miṯtjinydja märr‐ḻurrkun' yana, 70 yana miṯtji ŋulinyaramirriyunydjayi ŋunhi walala wäŋaraŋalana yana nhinana Yetjiptja. ");
INSERT INTO gnn_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Yo, Djaykuptja ga nhanŋu miṯtjinydja yolŋu'‐yulŋunydja marrtjinana yukurrana, yana liŋgu galkithinana marrtjina wäŋanydja ŋunha Yetjippuynydja. Bala yana ŋuliŋuruyinydja gandarrŋurunydja ŋayi waŋgany wäwa'mirriŋu waṉḏina yäku Djuda ŋäthili, ŋurruŋu waṉḏina bala, ga ḻakaraŋala Djotjipku, bitjarra, “Mäḻuny'tja dhikana marrtji yukurra, galkina dhuwalana ya',” bitjarra. ");
INSERT INTO gnn_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Ga Djotjiptja dhunupa gaŋgathinana, bala yana marrtjina gumurr'yunarawuna bäpa'mirriŋuwuna. Marrtjinana nhinana lili, ga bunana, ŋunhilina maṉḏa gumurr‐wunanhaminanydja bäpa'manydji maṉḏa. Yurru ŋayi Djotjipthu dhangi'yurrunana gay, gaḻummaraŋala nhanŋuway bäpa'mirriŋunhanydja mayaŋ'kurruna mulkana, bala ŋäthinana wuythurrunana dhikana weyinnha ŋäthina. ");
INSERT INTO gnn_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Bala ŋayi Djaykuptja waŋanana Djotjipku bitjarrana, “Ŋe liŋguna ŋarra nhuna nhäŋalana ga marrkapthurrunana nhokala yana ŋarra. Yakana ŋarra weyindja yurru nhina yukurra dhiyala, liŋgu galki ŋarra yurru gonha'yunna nhumalanha, bäyŋuthirrina yurru,” bitjarra ŋayi Djaykuptja waŋana Djotjipkala. Ŋuliŋurunydja ŋayi Djotjipthu garr'yurruna ŋunhi wäwa'mirriŋunhana walalanha, bala gäŋala ga milkuŋala Giŋgalana. Ga ŋunhi ŋayi nhäŋalanydja walalanha, ga ŋäkula ŋunhi walalanydja wäyin‐djäkamirri walala, bala yana ŋuriŋiyi Giŋdhunydja walalanha wekaŋala wäŋa ŋunha nhäyika yäku Gutjinbuy, ŋunha bäyma Yetjip muka, liŋgu ŋunhili wäŋaŋura ŋatha yurru ŋuthan guḻku' muka ŋuriki wäyingu walalaŋgu ḻukanharawu. Yuwalkthi Djaykupku miṯtjinydja ŋunhi yolŋunydja walala nhinanana ŋunhimala Gutjinlilinydja, ga dhunupana Djotjipthunydja yukurrana wekaŋala ŋathana nhanukalaŋuwu bäpa'mirriŋuwu ga malawu nhanukalaŋuwu bukmakku. ");
INSERT INTO gnn_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Yo, ŋunhi Yitjuralpuyŋunydja yolŋu'yulŋu nhinanana‐a‐a yukurrana ŋunhilina Yetjip, yanana liŋgu‐u‐u, bala walala ḻukunydjayinana dhikana, ŋatha‐guḻku'mirriyinana ga wäyindja guḻku'yinana marrtjina dhika dhaŋaŋdhinana ga yumurrkuny'tja malanydja guḻku'yinana. ");
INSERT INTO gnn_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","29","Ga ŋunhi ŋayi Djaykuptja liŋguna worruŋuyinana, dhuŋgarranydja nhanŋu 147‐nha, walunydja marrtjina galkithinana nhanŋu rakunydhinyarawuna, bala yana ŋayi gawaw'yurruna nhanukalayŋuwu gäthu'mirriŋuwuna Djotjipkuna, ga waŋananydja nhanukala ŋayi bitjarra, “Nhenydja ŋarranha dhawu'mirriyaŋanydja yuwalkkuŋa yana. Ŋunhi ŋarra yurru rakunydhirrinydja dhiyala, ga yaka ŋarranha dholkuŋa dhipalanydja bäyma Yetjiplilinydja. ");
INSERT INTO gnn_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Djaw'yurra ŋarranha rumbalnydja balayi Gaynanlili, ga dholkuŋa ŋunhamala yana bili wäŋalili ŋunhi bäpa'mirriŋu ŋarraku dholthirri nhina.” ");
INSERT INTO gnn_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Ga ŋayi Djotjiptja yoraŋalana nhanŋu, bala waŋana dhawu'nherrara bitjarrana, “Yuwalk yana ŋarra yurru nhuna dholkumanydja ŋunhamala liŋgu, bitjan yana liŋgu bitjan dhuwali nhe yukurra waŋa.” Yo, Djaykuptja ŋunhi ŋayi wiripunydja yäku Yitjural worruŋuna liŋguna, ga rirrikthurrunana ŋayi, galkina ŋayi rakunydhirrina yurru, bala ŋayi ŋulinyaramirriyu gawaw'yurrunana nhanukalaŋuwu gäthu'mirriŋuwuna walalaŋgu, ḻuŋ'maraŋalana walalanha ŋurikiyi 12‐ku. Bala ŋayi dhäruknha wekaŋala goŋmirriyaŋalana walalanha yäkumirri Godkalaŋumirrina, ḻakaraŋala yukurrana walalanha nhaltjan yurru ŋunhala bala yalala maḻŋ'thun, ga ŋäŋ'thurruna ŋayi yukurrana bukumirriyaŋala waŋga'‐waŋganygu ŋurikiyi walalaŋgu yulŋunydja. Walala yurru nhinanydja yukurra waŋganyŋura yana, waŋgany yana bäpurruny'tja Yitjural, yurru barrku'‐barrkuwatjthirrina walala yurru nhinanydja yukurra miṯtji ga miṯtji. Ga bitjarrayi liŋgu ŋayi Djaykupthu dhäruk‐wekaŋala ŋunhi Djotjipkalaŋuwu walkurwu maṉḏaku Burayim ga Manatjawu, ga maṉḏanydja yurru bitjan yana liŋgu barrkuwatjthirri bäpurru maṉḏanha, yurru ŋunhiyi warray bili Yitjural yana miṯtjinydja. ");
INSERT INTO gnn_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Ŋunhi ŋayi dhawar'yurrunana bäpa'mirriŋu Djaykup ŋurikala gäthu'mirriŋuwala walalaŋgala dhäruk‐wekanhaminyaraŋuru, bala ŋayi waŋana bitjarrana, “Walunydja dhuwala liŋguna ŋarraku gonha'yunarawuna, ŋarra yurru gonha'yunna nhumalanha. Yurru yaka boŋguŋu nhuma dholkuŋu ŋarranha dhipalanydja bäyma Yetjiplilinydja. ");
INSERT INTO gnn_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","32","Rumbalnydja ŋarranha nhuma boŋguŋu djaw'yurru balayi ŋunha Gaynanliliyi, ga ŋunhamala yana nhuma boŋguŋu ŋarranha dhalkaraŋunydja dhambay yana ŋarrakalaŋuwala bäpa'mirriŋuwala. Yo, ŋarrakala märi'mirriŋuyu Yipurayimdhu märraŋala ŋunhiyi mathirranydja, bala dhalkaraŋalana nhanŋuway ŋayi miyalknhanydja Saranha, ga ŋunhimalayi liŋgu mathirralili walala dholkuŋala ŋanya Yipurayimnhanydja. Ga bitjarrayi walala dholkuŋala ŋarraku bäpa'mirriŋunha Yitjaknhanydja ŋunhimalayi liŋgu wäŋalili, ga ŋunhimalayi yana ŋarranhanydja nhuma boŋguŋu rumbal gäŋu, ga ŋunhimala yana wäŋalili dholkuŋu.” ");
INSERT INTO gnn_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Ŋunhi ŋayi Djaykup bitjarranydja yukurrana waŋana, dhawar'yurrunanydja ŋayi waŋanharaŋuru, bala gurrunhanminana ŋayi balayi. ");
INSERT INTO gnn_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","3","Djotjiptja ŋayinydja wirrkina dhika ŋoy‐yätjthina, bala nyä'yurrunana dhika wiṯthurrunana, ga ŋunhi Yetjippuyŋu yolŋu'‐yulŋu nyä'yunminana, warwuyunminana wiṯthunminana dhika nhanŋu. ");
INSERT INTO gnn_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","5","Ga dhäŋuru ŋuliŋurunydja ŋayi Djotjip waŋana ŋurikala giŋgala bitjarra, “Ŋarraku mäḻu'mirriŋunydja waŋanha yawungu, ŋunhi ŋanya rumbalnydja yurru ŋarra balayi gäma, ga ŋunhimalayi liŋgu dholkuma Gaynanlili. Ŋayŋu'yurrana ŋarranha ŋi'! Ŋunhimalayina ŋarra yurru marrtji yana ga dholkuma ŋarrakuway bäpa'mirriŋunha, ga liliyi ŋarra boŋguŋu roŋiyi.” ");
INSERT INTO gnn_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Ŋayi Giŋdja yoraŋala nhanŋu, ga waŋana bitjarra, “Gatjuy marrtjiyana‐wala, ga yana liŋgu ga dholkuŋa ŋunhili bäpa'mirriŋunha nhuŋuway, ga liliyi roŋiyiya.” ");
INSERT INTO gnn_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Ga yuwalkthi Djotjiptja marrtjinana ga wiripu‐guḻku' buŋgawamirri yolŋu'‐yulŋu ŋurru'‐ŋurruŋu Yetjippuyŋunydja malthurrunayi nhanŋu. ");
INSERT INTO gnn_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Ga nhanbala gäthu'mirriŋu walala ga wiripu‐guḻku' mala ŋunhi bukmak malthurruna nhanŋu Djotjipku, ");
INSERT INTO gnn_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","bena dhika yolŋu'‐yulŋu dhaŋaŋnha, dhaŋaŋnha dhika yolŋu'‐yulŋu marrtjinanydja. ");
INSERT INTO gnn_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","13","Gaŋgathinanydja walala bala marrtjinana, marrtjinana yukurrana walala, yana liŋgu‐u‐u wäŋa ŋayathaŋala Gaynanbuy, ga ŋunhalayinydja walala dholkuŋalana ŋanya Djaykupnha, ŋunhala wäŋaŋura yäkuŋura Makpilana; ŋunhamalana walala ŋanya dholkuŋalanydja dhambay‐manapara Yipurayimgala ga Yitjakkala. ");
INSERT INTO gnn_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Ga ŋuliŋurunydja dhurrwaraŋuru ŋunhi walala goŋ‐yawar'yurrunanydja dholkunharaŋuru, bala walala roŋi'‐ruŋiyina bukmak yana liliyi Yetjipliliyi. ");
INSERT INTO gnn_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Ga dhäŋuru ŋuliŋuruyi walalaŋgalaŋuwala bäpa'mirriŋuwala moluliliyanharaŋurunydja, walalanydja ŋunhi wäwa'mirriŋunydja walala birrka'yurruna yukurrana buku‐weyaṉina, bitjarra ŋuli ya', yana bini ŋayi yukurranha Djotjip baḏak walalaŋgu ŋula ŋaramurryinya, yana bini ŋayi buku‐ruŋiyinmaranha ŋurikiyi ŋunhi walala ŋanya bitjarra ŋäthili‐wala. ");
INSERT INTO gnn_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Bala yana walala dhäruknha djuy'yunmina nhanŋu Djotjipku, ga waŋana bitjarra, “Dhä‐ŋäthili muka yana, ga yurruna bäpa'mirriŋu ŋilimurruŋgu bäyŋuthirri yawungu, ");
INSERT INTO gnn_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","ŋayi waŋana bitjarra ŋanapurrunha, ŋanapurru yukurra waŋa nhokala dhuwala, märr nhe yurru bäy‐ḻakaraŋa ŋanapurruŋgu ŋurikiyinydja ŋunhi ŋanapurru nhuna yätjkuŋala ŋäthili. Yaka nhe ŋanapurruŋgu mukthurra yukirriya ŋaramurrthiya ga guyaŋiya yukirriya ŋurikiyi.” Ga ŋayi Djotjipthu märraŋala ŋunhiyi dhäruktja walalanha, bala ŋayi nyä'yurrunana wiṯthurrunana dhika. ");
INSERT INTO gnn_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Bala walala ŋunhi wäwa'mirriŋunydja walala bunana nhanŋu Djotjipku, bala yana buku‐nyilŋ'thurrunana nhanŋu, bala wekanharamina walalawuynha walala bitjarra, “Dhuwalana ŋanapurru, ŋanapurrunydja nhuŋuna djämamirri walala.” ");
INSERT INTO gnn_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Ga Djotjiptja waŋana walalaŋgu bitjarra, “Yaka barrariya walala; yaka ŋarra dhuwala yurru ŋarranhawuy ŋarra nherraṉmirri ŋunha Godkala dharapullili. ");
INSERT INTO gnn_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Yuwalk nhumanydja ŋunhi yätjthina, bala nhuma ŋarranha goŋ‐wekaŋalana ga djuy'yurruna rälina, yurru Godthunydja ŋayipinydja ŋunhiyi gurrumiḻŋ'maraŋala, bilmaraŋala ŋunhiyi ga ḻatju'kuŋalana, ga balakurrunydja guḻku'na yolŋu'‐yulŋu walŋathinanydja; yakana walala murrmurryurruna marrtjina ŋula djaṉŋarrthinyarayu, bili Godthu ŋayipi ŋarranha ŋunhi gäŋala dhipala Yetjiplili. ");
INSERT INTO gnn_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Yaka walala barrariya. Ŋarra yurru nhumalaŋgu goŋ‐nherraṉmirri ga nhumalaŋgalaŋuwu yumurrku'wu.” Bitjarra ŋayi Djotjipthu marrtjina waŋananydja dhärukthu yana ŋamakurru'yu, ŋoy‐yal'yunmaraŋala walalanha, bala yakana walala beyaṉiyinanydja biyapulnydja nhanŋu Djotjipku. ");
INSERT INTO gnn_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","23","Mukthurruna yana Djotjip ga bukmak ŋunhi Djaykupkuŋu guwar‐yalkthunara miṯtji yukurrana nhinana ŋunhiliyi Yetjip, yana liŋgu ga Djotjip marrtjina worruŋuyina. ");
INSERT INTO gnn_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Bala ŋayi waŋanana nhanukalaŋuwala wäwa'mirriŋuwala walalaŋgala bitjarrana, “Walunydja dhuwala ŋarraku dhawar'yunarawuna, ŋarra yurru rakunydhirrina, ga nhumalaŋgunydja yurru djäka ŋayipina Godnha. Ŋayipi yurru nhumalanha dhawaṯmarama dhipuŋurunydja wäŋaŋuru, balayi roŋiyinmarama ŋunhamala ŋunhi wäŋalili ŋunhi ŋayi goŋ‐nherrara Yipurayimnha ga Yitjaknha ga Djaykupnha. ");
INSERT INTO gnn_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Lilinydja waŋiya, dhäruk‐nherraṉmiya ŋarrakalanydja. Ŋunhi boŋguŋu Godthu nhumalanha gäŋu balayi roŋiyinmaraŋu ŋunhimalayi wäŋalili, nhuma boŋguŋu gäŋuyi ŋarranhanydja rumbal ŋunhamalayi wäŋalili.” ");
INSERT INTO gnn_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Bala ŋayi Djotjip rakunydhinana ŋunhala Yetjipnha wäŋaŋura, dhuŋgarranydja nhanŋu 110, yurruna walala ŋanya ḏiḏiny‐bunuŋalanydja rumbalnydja yukurrana, bala märrkitjkuŋalana bathililina ŋunhala yana bäyma Yetjip. ");
INSERT INTO gnn_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","5","Yo, ŋayi worruŋuyu yolŋuyu ŋuriŋi Djaykupthu gonha'yurrunana Gaynan, bala marrtjinana, ga yumurrku' nhanŋu marrtjina galki, bala nhinananydja walala yukurrana ŋunhala Yetjipnha, ga dhuwalana nhanŋu yumurrkuny'tja gam' yäku, Ropin, ga Djimiyan, ga Lepay, ga Djuda, ga Yitjaka, ga Djapalan, ga Bindjaman, ga Dän, ga Napali, ga Gäd, ga Yatja. Yo, ŋunhiyi walala ḏarramuwurru marrtjina djamarrkuḻi'mirrina ga dhäykawurrumirrina, marrtjina walala yukurrana galki ŋurikalaŋumirrina djawuḻpa'walaŋumirrina, ŋunhi ŋayi wiripunydja yäku ŋunhiyi Yitjuralnha. Ga ŋayipinydja ŋunhi Djotjiptja nhinana yukurrana ŋunhala Yetjip wäŋaŋura ŋulinyaramirriyunydja ŋunhi walala nhanŋu gutha'mirriŋu walala ga bäpa'mirriŋu bunanana, bala wäŋaraŋalana Yetjipnha. ");
INSERT INTO gnn_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","7","Dhuŋgarra marrtjina djuḻkthu'‐djuḻkthurrunana‐a‐a, bala ŋayi Djotjip ga gutha'mirriŋu walala nhanŋu murrmurryurruna marrtjina warrpam'nha, yurru ŋurikiŋi walalaŋgu walkur‐märranharanydja mukthurrunana nhinana yukurrana ŋunhili Yetjip wäŋaŋura dhuŋgarranydja ŋunhi ŋupara weyinnha‐a‐a, ga yana liŋgu‐u‐u ga ŋunhi miṯtji Yitjuralnydja biyapulnha dhaŋaŋdhinana. ");
INSERT INTO gnn_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Ga ŋuliŋurunydja dhurrwaraŋuru wiripuna ḏarramu wapthurruna buŋgawayina wäŋaŋura Yetjiptja, yurru ŋayi ŋunhiyi Giŋ yakana ŋula yukurrana marŋgithina Djotjipkunydja, ");
INSERT INTO gnn_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","bala ŋayi buŋgawayunydja ŋuriŋiyi ḏarramuyu waŋana nhanukalayŋuwala malawala bitjarrana, “Wäy, dhuwalanydja walala yolŋu'‐yulŋu Yitjuralpuyŋunydja guḻku'na mirithirrina miṯtji ŋiniya? . . . galki walala boŋguŋu djuḻkthunmaraŋuna ŋilimurrunhanydja malayu. ");
INSERT INTO gnn_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Ŋuli balaŋu miriŋunydja ḏo'yurru dhiyala ŋilimurruŋgu, mak walalanydja ŋuli waŋgany‐manapanmina, dhuwalanydja walala yolŋu'‐yulŋu, bala waṉḏi winya'‐winyayurruna ŋilimurruŋgala dhipuŋuru wäŋaŋurunydja. Nhaltjanna yurru ŋilimurru yulŋunydja walalanha?” ");
INSERT INTO gnn_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Bala ŋayi ŋuriŋi Giŋdhunydja djämana walalaŋgu Yitjuralpuyŋuwunydja ḻakaraŋala, ŋutu'na dhika djäma, mel‐nherrara walalanha, ga wirrkina walalanha yukurrana ŋuriŋi buŋgawayu walalay gur'kuryurruna yana djämawunydja, yakaŋuwuna ŋula nhinanharawu galkunminyarawunydja. Walala dhuḻ'yurrunanydja yukurrana maltjaṉana yindi maṉḏanha wäŋa ŋurikiyi Giŋgu, yäkunydja ŋunhi wäŋanydja maṉḏanha Bithumbuy ga Ramdjitjpuy. ");
INSERT INTO gnn_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Yo, gonhayi walalanha ŋuli gur'kuryunna baku‐ŋayathanhanydja mirithinyarawunydja djämawu, yana marrtjina walala miṯtjinydja guwar‐yalkthunmina warray, yana liŋgu ga guḻku'thina dhika mala. Bala ŋunhi bukmak yolŋu'‐yulŋu Yetjippuyŋunydja wirrkina beyaṉiyina, mala nhäŋala guḻku'thinyarana Yitjuralpuyŋunhanydja. ");
INSERT INTO gnn_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Yurru walala Yetjippuyŋuyunydja mukthurrunana dhika gur'kuryurruna djäma ḻakaraŋala bartjunmaraŋala bumara. ");
INSERT INTO gnn_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Walu‐ŋupana walala ŋuli djämana yana marrtjinya, guṉḏana dhika ŋonuŋmirrina ḻaw'ḻawmaranha, ga wiripu malanha ŋonuŋmirri djäma, yaw'yuna marrtjinya munatha'na. Yurru mukthurruna warray yana malanydja marrtjina ŋuthara bitjarrana liŋguna. ");
INSERT INTO gnn_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Yo, ŋulinyaramirriyunydjayi yukurrana nhinana märrma' dhäyka maṉḏa, ŋunhi maṉḏa ŋuli yukurranha guŋga'yuna Yitjuralpuyŋunha dhäykawurrunha ŋunhi walalaŋguŋu ŋuli Yitjuralpuyŋuwuŋu yothu ŋurruŋu‐dhawal‐wuyaŋinya, ga yäkunydja ŋunhiyi maṉḏa dhäykanydja Djipura ga Buya. ");
INSERT INTO gnn_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","Bala ŋayi ŋunhi Giŋdja wäthurruna maṉḏaku, ga waŋana bitjarrana maṉḏanha, “Ŋunhi nhuma yurru guŋga'yundja yukurra ŋunhiyi dhäykawurrunha Yitjuralpuyŋunhanydja, ga yothunydja yurru ŋunhi dhawal‐wuyaŋirri ḏarramunydja ŋula, dhunupana nhumanydja yurru buŋana ŋunhiyi yothunha. Ga ŋunhi yurru yothu miyalk dhawal‐wuyaŋirri, nhumanydja yurru yana ŋarambiya'‐nherraṉmirri walŋakuma ŋanya.” ");
INSERT INTO gnn_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Yurru maṉḏanydja ŋunhi miyalktja maṉḏa borrk‐beyaṉiyinana Godkuna; yakana maṉḏa ŋunhi dhäruktja märraŋala ŋanya ŋunhi buŋgawanhanydja, yakana maṉḏa marrtjina bumara ḏarramuwurrunhanydja yumurrku'nha. ");
INSERT INTO gnn_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Ga biyapul ŋayi ŋunhi buŋgawa wäthurruna maṉḏaku, ga waŋana bitjarrana, “Nhäku warray nhuma yakanydja bumara marrtjina ŋunhi ḏarramuwurrunhanydja yumurrku'nha? Nhäku nhuma ŋuli walalanha walŋakumanydja?” ");
INSERT INTO gnn_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Bala maṉḏa ŋunhi dhäykana maṉḏa buku‐wakmaraŋala waŋana bitjarra, “Ŋunhanydja gay Yitjuralpuyŋunydja dhäykawurru wiripu warray, ganaŋ'thun yukurra yana Yetjippuyŋuwalanydja dhäykawurruŋgala. Walalanydja ŋunha ḏäwalamirri walŋamirri balanyara, bira'yun yukurra nhina, ga ŋurikiyina märrwu walalaŋguŋu djamarrkuḻiny'tja ŋuli dhawal‐wuyaŋirri waḏutjana yana, ga ŋanapurrunydja ŋuli marrtji dhuḏitjnha.” ");
INSERT INTO gnn_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","21","Yo, ŋayinydja ŋunhi Godtja wirrkina yana wokthurruna maṉḏaku ŋurikiyi, bala ŋayi djämana yukurrana ḻatjuny'tja dhikanydja ŋuriki dhäykawunydja maṉḏaku, bala yumurrku'nhana maṉḏaku wekaŋala ḻatju'kuŋala dhika, liŋgu maṉḏa borrk‐beyaṉiyina nhanŋu Godku, ga dhäruknha ŋanya märraŋala. Ga Yitjuralpuyŋu miṯtji ŋunhiyi ŋuthara bena birrŋ'thurrunana yana, biyapulnha miṯtji dhaŋaŋdhinana. ");
INSERT INTO gnn_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Bala ŋuriŋi Giŋdhu nherrara wiripuna rom nhanukalaŋuwu yolŋu'‐yulŋuwunydja bukmakkuna yana, ga dhuwalana romdja ŋayi ŋunhi nherrara gam'. “Ŋunhi ŋayi Yitjuralpuyŋu yothu dhawal‐wuyaŋirri yurru ḏarramunydja, dhunupana nhuma yurru märramana ŋunhiyi yothunhanydja ḏarramunha ya', bala ŋurrkama mayaŋ'lilina, märr yurru ŋayi guḻwuḻyunna rakunydhirrina. Ga dhäykawurru yumurrku' yurru walŋamirrinydja nhina.” Ga dhuwalayina ŋayi romdja nherrara ŋuriŋiyi Giŋdhu. ");
INSERT INTO gnn_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Ga ŋulinyaramirriyu liŋgu, ḏarramu ga dhäyka Yitjuralwuy maṉḏa märranhamina, yurru maṉḏa ŋunhi Lepaywala yarraṯaŋurunydja. ");
INSERT INTO gnn_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Nhinana maṉḏa yukurrana‐a‐a, bala ŋuriŋi dhäykayu gurrukaŋala yothunha, ga yothunydja ŋunhi dhawal‐wuyaŋina ḏarramu. Wirrkina dhika ŋunhi ŋäṉḏi'mirriŋu wokthurruna yukurrana ŋurikiyi yothu'wu, liŋgu ḻatju'na dhikana ŋanyana ŋunhiyinydja yothu, bala ŋayi djuḻuḻ'maraŋalana ŋanya ŋurikala Yetjippuyŋuwalanydja buŋgawawala bunharaŋuruna. ");
INSERT INTO gnn_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Yo, ŋunhiyi yothunydja yukurrana djuḻuḻ'yurruna, ḻurrkun' ŋaḻindinydja ŋupara, bala ŋayi ŋäṉḏi'mirriŋunydja ŋunhi wirrkina beyaṉiyina; walala bini ŋanya maḻŋ'maranhana, liŋgu yothuny'tja ŋunhi marrtjina gurarrthina warray bala yulŋunydja, yana liŋgu ga bulwanydhina. Bala ŋayi buku‐ḻayyurruna walŋakunharawuna nhanŋu ŋurikiyi yothuwu. Marrtjinanydja ŋayi, ga galkara gulwaṉi'na marwat, bala bathina bumara. Bumaranydja ŋayi‐i‐i, bathikuŋalana‐a‐a, bala dhaḻ'dhaḻyurruna bathinydja ŋarŋganydja gonydjuy'yinyarayuna, ḏälku'‐ḏälkuŋalana ŋunhiyi bathinha. Bala ŋayi yothu'nhanydja ŋunhiyi ḻaw'maraŋalana, dhoṯku'‐dhoṯkuŋalanydja ŋayi, bala yorrkuŋalana ŋunhimala bathililina. Ḻaw'maraŋalanydja ŋayi ŋunhi yothu'nhanydja bathimirrina, bala gäŋala mayaŋ'lilina. ");
INSERT INTO gnn_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Djar'tjaryurrunanydja ŋayi bala‐a‐a, ga gapu mayaŋ' mulkana gulwaṉi'mirri, bala ŋayi ŋäṉḏi'mirriŋuyu ḻupmaraŋalana ŋunhi bathinydja yothuwalaŋumirrina ŋunhimala yana gulwaṉi'‐yirrimuklili, märr‐baṉḏany'lili. Ḻupmaraŋalanydja ŋayi, bala ŋayi djar'tjaryurruna balayi roŋiyinana wäŋalilina, yurru ŋayina yapa'mirriŋuna djingaryurruna nhinana ŋunhiliyinydja bäymanydja, yurru märr‐barrku ya', nhäŋa'‐nhaŋala ŋayi nhinana. ");
INSERT INTO gnn_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Bala ŋulinyaramirriyu liŋgu waluyu, dhäyka ŋurikina Giŋguna gäthu'mirriŋu yarrupthurruna bala mayaŋ'lili ḻupthunarawu, ga nhanŋu djämamirri walala wirrwu'‐wirrwuḻ malthurrunayi. Wäŋgaŋalanydja marrtjina bala walala mayaŋ'‐ŋuparana, bala yana ŋayi ŋuriŋi miyalkthunydja dharr‐way nhäŋalana bathina ŋunhina, ŋayi nhinana bänina bewiya'mirriŋura. Bala ŋayi waŋana ŋurikala djämamirriwalana dhäykawala, “Gatjuy marrtjiya, ga ŋunha märraŋa bathi ya', ga gäŋa lili ŋarrakala,” bitjarra. ");
INSERT INTO gnn_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Warr‐way märraŋala ŋunhi bathinydja, bala gäŋalana lili, bala wekaŋala ŋurikala dhäykawalana, bala ŋayi ḻapmaraŋalanydja bitjarranydja ya' ŋunhi bathinydja, marrtjina nhäŋalanydja yothu'nha warray, ŋayi yukurrana ŋorrana djinawa' dhika bathiŋura. Bala ŋunhi yothuny'tja ŋäthinana. Ŋayinydja Giŋgunydja ŋunhi gäthu'mirriŋu wuyurrunana wirrkina ŋuriki yothuwu, ga waŋana ŋayi ŋunhiyi miyalk bitjarra, “Dhuwalanydja gay' yothu Yitjuralpuy bäpurru',” bitjarra. ");
INSERT INTO gnn_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Ga ŋayinydja ŋunhi yapa'mirriŋunydja mukthurruna djingaryurruna nhinana ŋunhiliyi, nhäŋala yukurrana ŋunhiyi dhäykanha, bala ŋayi marrtjina lili withiyara ŋanya, bala waŋana ŋanya bitjarra, “Way! Ḏukṯukka nhe yulŋunydja ŋula dhäykawunydja? . . . djäkawu dhiyaku yothuwu? Marrtjiŋga ŋarra yurru yulŋunydja? . . . ga garr'yun Yitjuralpuyŋunha miyalknha? . . . märr ŋayi yurru djäka dhiyaki yothu'wu?” ");
INSERT INTO gnn_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","“Ŋe, gatjuy waṉḏiyana,” bitjarra ŋunhi dhäykanydja waŋana. Bala ŋayinydja ṉaŋ'thurrunana. Ṉaŋ'‐ṉaŋdhurrunanydja ŋayi yapa'mirriŋunydja ŋuriki yothuwunydja, yana liŋgu‐u‐u, ga garr'yurruna ŋäṉḏi'mirriŋunhana ŋulaŋuru wäŋaŋuruna. Wap‐lili maṉḏa lilinydja, yana liŋgu‐u‐u, bur‐way ḏo'yurruna ŋuripayi dhäykawana. ");
INSERT INTO gnn_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Bala ŋunhiyi dhäykanydja waŋana ŋurikala ŋäṉḏi'mirriŋuwalanydja bitjarrana, “Märraŋana dhuwala yothu'nhanydja, bala nhe yurru gurarrkuŋana yukirriya ŋarraku, yurru ŋarra nhuna wekama yukurra yurru rrupiyayunydja,” bitjarra. Warr‐way märraŋalana ŋunhiyi yothu'nhanydja, goŋliliyaŋalana gäŋala wäŋalilina, bala ŋayipina ŋäṉḏi'mirriŋuna yukurrana djäka, gurarrkuŋala ŋunhiyi yothunhanydja nhanŋuway. ");
INSERT INTO gnn_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Nhinana‐a‐a walala yukurrana‐a‐a, bala ŋunhi yothuny'tja gurarrthina wakindhinana, gurrmulthinana, bala ŋayi ŋäṉḏi'mirriŋuyunydja gäŋala balayi ŋurikala dhäykawala, ga ŋayina ŋanya goŋdhu märraŋala ŋuriŋiyi Buŋgawawala gäthu'mirriŋuyu, nhanŋuwaynha ŋayi yothu. “Ŋarra dhawaṯmaraŋalanydja ŋanya gapuŋuru,” bitjarra ŋayi ŋunhiyi miyalk waŋananydja, bala ŋayi yäkunydja ŋanya nherrara Mawtjitjnha, liŋgu mayali' dhuwala yäku Mawtjitjtja djingaryun yukurra ‘dhawaṯmaranhara.’ ");
INSERT INTO gnn_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Yo. Mawtjitjtja nhinana yukurrana‐a‐a ŋunhala Yetjippuyŋuwala buŋgawawala wäŋaŋura dhuŋgarra ŋupara‐a‐a, yana liŋgu ḏarramuyina marrtjina wakindhina. Waŋganymirri ŋayi Mawtjitj dhawaṯthurruna warraŋullili, bala ŋayi withiyara walala‐miṯtjinha yolŋu'‐yulŋunha Yitjuralpuyŋunha. Djar'tjaryurrunanydja ŋayi nhinana bala, nhäŋalanydja walalanha djämalili ŋutu'lili warray. Wiripunydja ŋayi nhäŋala, ŋayi yukurrana yolŋuyu Yetjippuyŋuyu bumara bartjunmaraŋala waŋganynha Yitjuralpuyŋunha ḏarramunha, nhanŋuwaynha miṯtjinha. ");
INSERT INTO gnn_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Bala ŋayi waṯthurruna bitjarra bala ga bitjarra bala Mawtjitjthu, yana ŋayi bäyŋu warray nhäŋala ŋula yolnha, bala ŋayi waṉḏinanydja ḏe'‐way wutthurruna, rakunyguŋalana yana ŋunhi Yetjippuyŋunhanydja ḏarramunha. Warryurrunanydja ŋayi, bala munatha'lilina dholkuŋala, rumbal winya'yunmaraŋalana. ");
INSERT INTO gnn_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Nhinanana ŋayi‐i‐i. Ga wiripuŋuyuna ḏaykun'thu ŋayi bitjarrayi bili marrtjina withiyara nhänharawu walala‐miṯtjiwu. Marrtjinana bala ŋayi, dharr‐nhäŋala märrma'nha Yitjuralpuyŋunha maṉḏanha, maṉḏa nhinana bunharamina, bala ŋayi waŋana ŋurikala ḏarramuwala ŋunhi ŋayi ŋäthili yol buku‐ḻayyurruna mariwu. “Way, nhäku warray nhe dhuwala yukurra buma nhuŋuway gutha'mirriŋunhanydja? Nhuma miṯtji warray dhuwalinydja,” bitjarra. ");
INSERT INTO gnn_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Ga ŋayi ŋunhi ḏarramunydja waŋana nhanukala bitjarra, “Yol dhuwala nhe yolŋunydja? . . . buŋgawa ŋanapurruŋgu? . . . ga mala‐yarr'yunaramirri? Dhuwalanydja nhe yurru ŋarranhana buma ŋiniya? . . . bitjana nhe yawungu ŋunhala bunha rakunygu Yetjippuyŋunha yolŋunha?” Bala ŋayi Mawtjitjtja wirrkina beyaṉiyina, guyaŋinyaminana ŋanyapinyay ŋayi, “Yuwalknha dhuwala yolŋu'‐yulŋunydja marŋgimirrina ŋiniya,” bitjarra. ");
INSERT INTO gnn_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Ga ŋayi buŋgawayunydja ŋäkulana dhäwu'na ŋunhiyi Mawtjitjkalaŋuwuy, ŋayi bini ŋanya bunha rakunyguna, bala ŋayi Mawtjitjtja ḏulkthurrunana, winya'yurrunana ŋuliŋuru wäŋaŋuru. Waṉḏinanydja ŋayi bala‐a‐a barrkulilina, yana liŋgu‐u‐u bur‐way ḏo'yurruna ŋunhala wäŋaŋura yäkuŋura Midiyannha. Djar'tjaryurrunanydja bala ŋayi‐i‐i, dharr‐way nhäŋala gapu maŋutji‐yaw'yunara djingaryurruna yukurrana, bala dhut‐gay nhinanana ŋunhimala gapu‐maŋutjililina. ");
INSERT INTO gnn_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Nhinana djingaryurruna ŋayi Mawtjitj, nhäŋala dhäykawurrunha djapinnha, walala lili wäŋgaŋala gapuwu dhiṯ‐dhiṯthunarawu, wäyingu walalaŋgalaŋuwu wekanharawu, yurru walala ŋunhi dhäykawurru gäthu'mirriŋunydja walala ḏalkarra'mirriwu ḏarramuwu yäkuwu Rewulwu. ");
INSERT INTO gnn_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Märr walala bitjarra dhiṯ‐dhiṯthurruna gapunydja, bala walalanydja bar'‐barmaraŋala, gukuŋalana ŋunhi dhäykawurrunhanydja, wäyin‐djäkamirriyuna walalay ḏarramuwurruyu. Bala ŋayi Mawtjitjthunydja nhäŋalana, bala djingaryurrunana, wapthurruna dhäykawurruŋgalana, bala waŋana gukuŋalana ŋunhi ḏarramuwurrunhanydja. Bala ŋayipina Mawtjitjthuna walalanha guŋga'yurruna, gapunydja dhiṯ‐dhiṯthurruna. ");
INSERT INTO gnn_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Dhawar'yurruna djämaŋurunydja ŋayi Mawtjitj, bala dhäykawurrunydja ŋunhi wäŋgaŋala roŋiyinana wäŋalilina. Bala ŋayi mäḻu'mirriŋuyunydja nhäŋalana walalanha, bala waŋana dhä‐wirrka'yurruna bitjarra, “Way! Waḏutja warray dhuwala nhuma gäthuranydja roŋiyina?” ");
INSERT INTO gnn_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Ga walalanydja dhäykawurruyunydja waŋana ḻakaraŋala nhanbala bitjarrana, “Waŋganydhu Yetjippuyŋuyu ḏarramuyu ŋanapurrunha guŋga'yurruna, ŋayi gukuŋala wiripuwurrunhanydja ḏarramuwurrunha, wäyin‐djäkamirrinha walalanha, bala guryu'‐guryunmaraŋala gapunydja ŋanapurruŋgu ŋayina, bala wekaŋala wäyinnhanydja walalanha.” ");
INSERT INTO gnn_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Ga ŋayi bäpa'mirriŋuyunydja waŋana dhä‐wirrka'yurruna walalanha bitjarra, “Wanhaka dhika ŋayi yolŋunydja? . . . Ŋunha bäyma nhuma gonha'yurruna ŋanya? Gatjuy ḻaw'yurra walala, ga garr'yurrana ŋanya lili. Ŋayi ŋayaŋay'nha yurru ḻuka dhiyala ŋilimurruŋgalana,” bitjarra. ");
INSERT INTO gnn_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Bala walala marrtjina, ga garr'yurrunana ŋanya Mawtjitjnhanydja, bala gäŋala wäŋalilina walalaŋgiyingala bäpa'mirriŋuwalana, bala ŋayi yukurrana nhinananydja ŋunhalana bili ḏarramuwalana wäŋaŋura weyinŋumirrina. Ga dhurr‐way ŋayi wekaŋala dhäykanhana Mawtjitjku ŋuriŋiyi mäḻu'mirriŋuyunydja, yäkunha Djipuranhana. ");
INSERT INTO gnn_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Nhinana maṉḏa yukurrana‐a‐a, yana liŋgu‐u‐u, bala ŋuriŋiyi dhäykayunydja gurrukaŋala yothu'nhana Mawtjitjku, ga dhawal‐wuyaŋinanydja ŋayi ŋunhi yothuny'tja ḏarramu maḻamarrnha. Bala ŋayi Mawtjitjthu yäkunydja ŋanya ŋunhi yothu'nha nherrara Gutjum, mayaliny'tja ŋunhi yäkunydja ‘mulkuru’, liŋgu ŋayi ḻakaranhamina ŋanyapinyay ŋayi Mawtjitj bitjarra, “Ŋarranydja dhuwala mulkuru nhina yukurra dhiyalami wäŋaŋura.” ");
INSERT INTO gnn_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Yo. Mawtjitj nhinana yukurrana ŋunhili ŋanhdharkŋuranydja weyinŋumirrina, ga ŋunhalayi wäŋaŋura Yetjip, ŋunhiyi Yetjippuyŋu buŋgawa liŋguna rakunydhinana, yurru walalanydja ŋunhi Yitjuralpuyŋunydja yolŋu'‐yulŋu ŋunhala yana mukthurruna nhinana yukurrana ḏirrwiḏirrwiŋura, djäma yukurrana yana ŋutu', ḏapmaranhara ga galŋa‐ŋurrkŋurrkthunara yana. Bitjanana liŋguna walala ŋuli ŋäthinyana yukurranha ŋoy‐yätjthinyana ŋuriŋiyi ḏirrwiḏirrwi‐mulkanharayuna, bala walala wäthurruna Garraywalana guŋga'yunarawuna. ");
INSERT INTO gnn_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Bala ŋayi Gunhu'yu ŋäkulana walalanha rirrakaynha ŋäthinyarana, bala ŋayi guyaŋinyaramina dhäruknha ŋunhi ŋayi dhäruk‐nherraṉmina dhä‐ŋäthili yana, ŋunhi ŋayi dhäwu'‐nherrara Yipurayimgala ga Yitjakkala ga Djaykupkala. ");
INSERT INTO gnn_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Yo, Gunhu'yu nhäŋalanydja walalanha ŋunhiwala ḏirrwiḏirrwililinydja, bala ŋayi buku‐ḻayyurrunana, ŋayi yurru djämana‐wala yana, guŋga'yunna walalanha. ");
INSERT INTO gnn_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Yo. Ga ŋunhala Midiyandja wäŋaŋura, ŋayi Mawtjitjtja mukthurruna yana nhinana yukurrana, djäma yukurrana, djäka wäyingu walalaŋgu nhanukalaŋuwu gawal'mirriŋuwu yäkuwu Djetharawu, yurru wiripunydja ŋayi ŋunhi yäku Rewul, ŋunhi ŋayi ḏalkarra'mirri yolŋu Midiyanbuywu wäŋawu. Waŋganymirri ŋayi Mawtjitjthu mutpunuŋala wäyinnha walalanha bitjarra bala märr‐barrkulili wäŋalili, ḏiltjilili dhika wäŋalili. Mutpunuŋalanydja ŋayi marrtjina bala‐a‐a, yana liŋgu gilitjina ŋunhi wäŋa buku yäku Worippuy, yurru ŋunhiyi wäŋanydja nhanŋuway Garraywuna Godkuna buku, ga wiripunydja yäku ŋunhiyi buku Djäniya. ");
INSERT INTO gnn_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Ga ŋunhiliyi bukuŋura Garraywu Godku dhäwu'mirri maḻŋ'thurrunana maŋutjiŋura nhanukala, ŋayi nhäŋalanydja gurtha ŋäṉarr ŋatŋatthunarana yukurranhara walŋalili dharpalili marwatlili; nhärana warray ŋayi marrtjina yulŋunydja, yurru man'tjarr ŋurikiy dharpawuy ga waṉa'‐waṉanydja yaka warray nhärana räwakthinanydja. ");
INSERT INTO gnn_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Bala ŋayi Mawtjitjtja wirrkina dhika ṉirryurruna ŋoy‐wiḻaŋ'thurrunana, bala ŋayi waŋana ŋayipi gäna, “Ŋarra mak bay bala marrtji, ga nhäma. Nhaltjarra ŋunha ŋayi dharpanydja? Yaka warray ŋunhayi marrtji nhära räwakthirrinydja?” bitjarra. ");
INSERT INTO gnn_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Marrtjinanydja bala ŋayi Mawtjitj, gilitjina ŋunhiyi dharpanydja, bala Garrayyu Godthu nhäŋalana ŋanya, bala waŋana ŋulawitjarra ŋäṉarrkurru gurthakurru, yäkuna ŋanya ḻakaraŋala, “Mawtjitj, Mawtjitj,” bitjarrana. “Gay' dhuwala ŋarra,” bitjarra ŋayi Mawtjitjtja waŋana buku‐ruŋinyamaraŋala. ");
INSERT INTO gnn_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Ga ŋayi Gunhuny'tja waŋana nhanukala, “Yaka marrtjiya gilitjiyanydja,” bitjarra. “Yupmaraŋa dhuwali nhuŋuway djapathuŋ'tja, liŋgu dhuwalanydja wäŋa nhe yukurra djingaryun dharrpalnha munatha'. ");
INSERT INTO gnn_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Ŋarranydja dhuwala ŋunhi muka Waŋarr nhokalaŋuwu märi'muwu walalaŋgu, Yipurayimgu ga Yitjakku ga Djaykupku Waŋarr God.” Bala ŋayi Mawtjitjtja buku‐yirryirryurrunana, melnha‐djaw'yunmina nhänharaŋuruna, liŋgu ŋayi wirrkina beyaṉiyina maŋutji‐ŋal'yunarawu Waŋarrwu Gunhu'wu. ");
INSERT INTO gnn_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Bala Garraynydja waŋana Mawtjitjkala bitjarrana, “Ŋarranydja nhäŋala yukurrana ŋarrakuway miṯtjinha yolŋu'‐yulŋunha, ŋunhi walala yukurra galŋa‐miḏikirri nhina ŋunha Yetjipŋura. Ŋarra ŋäkula walalanha ganuru ŋäthinyara, ga baymatthunara Yetjippuyŋuwuŋu yolŋu'‐yulŋuwuŋu. Ŋarra marŋgi walalaŋgu yulŋunydja, nhäyu walala yukurra galŋa‐yätjthirri, ");
INSERT INTO gnn_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","ga liŋguna ŋarra dhuwala marrtjinana lili, märr yurru ŋarra guŋga'yunna walalanha, walŋakumana ŋulaŋuru Yetjippuyŋuwala goŋŋuru, bala dhawaṯmaramana yurru ŋulaŋuru wäŋaŋuru Yetjipŋurunydja. Gämanydja ŋarra yurru walalanha ŋunhana ḻatju'lilina wäŋalili wal'ŋu, yindililina wäŋalili, ŋatha‐mäypamirrililina; ḻatju'mirrina dhikana ŋatha ŋunhalamiyinydja, ga guku dhika nhä malanha, yurru ŋunhayinydja wäŋaŋura wiripu‐guḻkuny'tja yolŋu walala yukurra nhina bäpurru'na ga bäpurru'na, guḻku'na bäpurru yolŋu'‐yulŋu. ");
INSERT INTO gnn_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Yo, ŋäkulanydja ŋarra walalanha nyä'yunminyara, ga nhäŋala ŋarra walalanha baymatthunara yukurranhara Yetjippuyŋuwuŋu. ");
INSERT INTO gnn_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Gatjuy, marrtjiyana nhenydja, ŋarra yurru nhuna djuy'yun bala ŋunha Yetjippuyŋuwala Buŋgawawala, ga nhena yurru gäŋanydja walalanha ŋarraku miṯtjinhanydja Yitjuralpuyŋunhanydja, dhawaṯmarama yurru ŋulaŋuru Yetjipŋurunydja,” bitjarra ŋayi Garrayyu ḻakaraŋalanydja Mawtjitjkala. ");
INSERT INTO gnn_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Yurru Mawtjitjtja waŋana bitjarra, “Nhäku warray yurru ŋarranydja marrtji be balayi? Nhaltjan dhika ŋarranydja yurru marrtji bala buŋgawawalanydja? Nhaltjanna ŋarra yurru dhawaṯmarama ŋunha yolŋu'‐yulŋunhanydja ŋulaŋuru Yetjipŋurunydja?” ");
INSERT INTO gnn_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Bala Garraynydja waŋana Mawtjitjkala bitjarra, “Ŋarra yurru ŋarrapi nhokala galki, bala nhenydja yurru dhawaṯmaramana walalanha, bala nhuma yurru buku‐ŋal'yundja Gunhu'wuna dhiyalayina bukuŋura. Ga ŋunhi nhe yurru roŋiyirrinydja lili galkina nhuma ŋunhi yolŋu'‐yulŋuna, bala nhe yurru guyaŋirrina roŋiyirri, bala nhe yurru bitjanna waŋanydja, ‘Yuwalk muka ŋunhi Godthu ŋayipi yana ŋarranha yänguŋalanydja.’” ");
INSERT INTO gnn_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Ga ŋayinydja Mawtjitjtja waŋana bitjarra, “Ŋuli yurru ŋarra ḏo'yundja walalambala Yitjuralpuyŋuwanydja, ga waŋa walalaŋgala bitjandja gam', ‘Way, Garrayyunydja Waŋarryu nhumalaŋgalaŋuwala bäpa'mirriŋuwalanydja djuy'yurruna ŋarranhanydja lili dhawaṯmaranharawuna nhumalaŋgu,’ bitjandja ŋarra yurru waŋa, mak walalanydja yurru ŋula waŋa bitjanna bäy, ‘Yol ŋayi ŋuli yäkunydja?’ bitjanna yurru walalanydja ŋula waŋa. Ga nhaltjanna ŋarranydja yurru waŋa ḻakarama walalaŋgu?” ");
INSERT INTO gnn_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Ga Gunhuny'tja waŋana Mawtjitjkala bitjarra gam', “Ŋarranydja dhuwala ŋarra, ŋarrapina yana. Yana ḻakaraŋa walalaŋgala biyakana, ‘Ŋuruŋu ŋarranha djuy'yurruna lili nhumalaŋgala, ŋayipi Waŋarryu walŋayu wal'ŋu, ŋunhi ŋayi yäkunydja “Ŋarranydja dhuwala ŋarra.” ’ Yo, biyaka nhe yurru ḻakaraŋanydja Yitjuralwunydja ŋi! ");
INSERT INTO gnn_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","‘Garrayyu ŋarranha djuy'yurruna lilinydja nhumalaŋgala, nhumalaŋgalaŋuwala bäpa‐ŋaliwala walalaŋgala Waŋarryu, Yipurayimgala, ga Yitjakkala, ga Djaykupkala Waŋarryu.’ Yo, dhuwalanydja yäku ŋarrana djingaryun yukurra yurru gupaḏalŋuna, bitjanna liŋguna. Walala yurru guyaŋirrina yukurra roŋiyirri ŋarranha bitjanna liŋguna waŋganynha, ŋunhina liŋgu yäku. ");
INSERT INTO gnn_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Yo, gatjuy marrtjiyana, ga buku‐ḻuŋ'maraŋa ŋunhi ḏilkurruwurrunha Yitjuralpuyŋunha, ga ḻakaraŋa walalambala ŋunhi nhipala ŋarra maḻŋ'thurruna. Yo, ḻakaraŋanydja walalambala biyaka, ‘Yuwalk ŋunhi ŋarra nhäŋalanydja yukurrana nhumalanha, bala ŋarra liŋguna nhäŋala Yetjippuyŋunhanydja yolŋunha walalanha ŋunhi nhaltjan walala yukurra nhumalanha, ŋayaŋu‐ŋonuŋguma, ṉiṉ'ṉiṉdhunmaramana manapan, ");
INSERT INTO gnn_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","ga liŋguna ŋarra ŋunhi dhukarrnydja djarr'yurrunana, ŋarra yurru nhumalanha walŋakumana, dhawaṯmaramana ŋarra yurru ŋuliŋuruyi Yetjippuyŋuwalanydja goŋŋuru, ŋurikalanydja walalaŋgala ŋunhi nhumalanha yukurra ŋayaŋu‐yätjkuma. Bala ŋarra yurru nhumalanha gämanydja ŋunhana yana ḻatju'lilina dhikana wäŋalili, ŋatha‐mäypamirrililina, ŋunhiwala wäŋalili ŋunhi walala mulku'‐mulkuru yolŋu walala nhina yukurra, dhuwala malanha gam', Gaynanbuyŋu ga Yitpuyŋu ga Yamarpuyŋu ga wiripu‐guḻku' mulku'‐mulkuru yolŋu walala.’ ");
INSERT INTO gnn_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Yo, ḻakaraŋanydja ŋarrakalaŋuwa yolŋu'‐yulŋuwanydja biyakayina, bala walalanydja yurru mäkiri'‐witjun ŋäma nhuna dhäruktja, bala märr‐yuwalkthirrina yurru. Ga dhäŋuru ŋuliŋuruyinydjayi nhuma yurru ḏilkurruwurrunydja Yitjuralpuyŋu marrtjina ŋunhiwalana buŋgawawalana Yetjippuyŋuwalana, ga ḻakaraŋana nhanbala biyakana. ‘Garraynydja ŋanapurruŋgu Waŋarrnydja liŋguna maḻŋ'thunmaranhaminana ŋanapurruŋgala. Marrtji muka ŋanapurru yurru yulŋunydja dhuwala? Märr‐gurriri ŋanapurru yurru marrtji, märr ŋunhalayi ŋanapurru yurru buku‐ŋal'yun nhanŋu Garraywu, ŋanapurruŋgalaŋuwu Waŋarrwu.’ ");
INSERT INTO gnn_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","20","Biyaka waŋiyanydja nhanukala, yurru yakana ŋayi yurru ŋunhi djuy'yundja nhumalanha. Ŋarranydja marŋgina nhanŋu ŋurikiyinydja Buŋgawawu, ŋunhi rom‐ḏälnha ŋayi yulŋunydja, bala ŋarranydja yurru ŋutu'yu warray ganydjarryu buma walalanhanydja, ŋutu'na ganydjarr milkuma ŋunhamalayinydja wäŋalili Yetjiplilinydja, ga ŋuliŋurunydja dhurrwaraŋuru ŋayi yurru djuy'yunna nhumalanha. ");
INSERT INTO gnn_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","22","Yo, nhumanydja yurru ŋarrakalanydja ŋunhi yolŋu'‐yulŋuyu gonha'yun Yetjiptja wäŋa mirithirri yana guḻku'mirri wal'ŋu girri'mirrinydja, yaka yana nhuma yurru marrtji dhäparktja goŋdja. Nhuma yurru dhäykawurruyunydja ŋäŋ'thun ŋunha Yetjippuyŋunhanydja dhäykawurrunha girri'wu malanyŋuwu dhika nhäku ŋunhi mel‐wiḏi'mirriwu, garwarrwarr'mirriwu dhika nhäku malanyŋuwu ŋunhi girri'wu ḻatju'mirriwu, bala walala yurru yana wekamana nhumalanha, rarr'yunna marrtji nhumalaŋgu, ga ŋuriŋi girri'yu malanyŋuyu nhuma yurru yumurrku'nha nhumalaŋguway nhuma dhaṯthun. Ga ŋuliwitjandhiyinydja nhuma yurru djaw'‐djawyunna marrtji nhä malanha ḻatju'mirrinydja dhikanydja ŋuliŋuruyi Yetjippuyŋuwalanydja goŋŋuru.” Ga bitjarra ŋayi Gunhuny'tja waŋana yukurrana nhanukala Mawtjitjkalanydja. ");
INSERT INTO gnn_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Bala ŋayi Mawtjitjtja waŋana buku‐wakmaraŋala Garraywala bitjarra, “Walalanydja yurru yaka warray ŋarraku ŋayaŋu‐yuwalkthirri ŋiniya? Walalanydja yurru waŋa, ‘Yä‐ä‐äw! Yaka warray nhokala Garraynydja maḻŋ'maranhamina,’ bitjandja yurru ŋula.” ");
INSERT INTO gnn_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Bala Garrayyunydja waŋana dhä‐wirrka'yurruna Mawtjitjnhanydja bitjarra, “Nhä nhe yukurra dhuwali ḏälkuma goŋdhunydja?” bitjarra. “Wapitja dhuwala,” ŋayinydja bitjarra Mawtjitjtja. ");
INSERT INTO gnn_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Ga ŋayi Garrayyunydja waŋana ŋanya bitjarra, “Ma' ḏupthurrana dhuwali wapitjany'tja munatha'lilina.” Bala ŋayi ḏupthurrunana, bat bitjarra, bala marrtjina moḻ'ŋuyinana ŋunhiyi wapitjany'tja. Mawtjitjtja djaḻaḻ'yurruna, ṉaŋ'thurruna ŋuripa moḻ'ŋuwa beyaṉiyinana. ");
INSERT INTO gnn_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Bala Garrayyunydja waŋana ŋanya Mawtjitjnha bitjarra, “Goŋ‐djarryurra, ga mulkiya yaŋara'na, bala ḻaw'maraŋana ŋanya.” Bala yuwalkthi ŋayinydja märraŋalana, ga balayi wapitja'yinayi goŋŋuranydja nhanukala. ");
INSERT INTO gnn_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","“Ga biyakayi nhe yurru yolŋuwalanydja walalaŋgala milma yana,” bitjarra ŋayi Garray waŋananydja. “Yo biyakayi djämanydja, bala walalanydja yurru ŋayaŋu‐yuwalkthirrina nhuŋu, ŋunhi nhokala Garray ŋayipi maḻŋ'maranhaminanydja, ŋunhiyi ŋunhi ŋayi Waŋarr bäpa‐ŋaliwu walalaŋgu, Yipurayimgu Yitjakku ga Djaykupku Waŋarr.” ");
INSERT INTO gnn_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Ga biyapul Garrayyu waŋana Mawtjitjnha bitjarra, “Biyaka goŋ‐gärriya girri'lili nhokalay nhe, dhipali gumurrlili ya'.” Bala yuwalkthi ŋayinydja goŋ‐gärrina. Ga ŋunhi ŋayi goŋdja dhawaṯmaranhamina ŋanyapinyay ŋayi, bala nhäŋalanydja marrtjina goŋdja ŋanyapinyay ŋayi gaywaraŋu' warray, burrpuy'mirriyina warray marrtjina ŋayinydja. ");
INSERT INTO gnn_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Ga biyapul ŋayi waŋana Mawtjitjkala, “Goŋ‐ŋilitjanmiya biyapul,” bitjarra. Ga yuwalkthi ŋayinydja goŋ‐gärrina, ga liliyi goŋ‐dhawaṯmaranhamina, bala nhänharamina ḻatju'na. ");
INSERT INTO gnn_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Bala Garray waŋana Mawtjitjkala bitjarra biyapul, “Biyakayi nhe yurru milkuŋanydja walalambala. Ŋuli walala yurru yaka ŋayaŋu‐yuwalkthirri yiŋarray'wu ŋurikiyi ŋäthiliŋuwunydja wal'ŋu, walalanydja mak yurru ŋayaŋu‐yuwalkthirri dhuwalayina. ");
INSERT INTO gnn_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Ga ŋuli walala yurru yakanydja märr‐yuwalkthirri, yana dhunupana dhiṯthurra gapu mayaŋ'ŋuruna, bala rarryurra munatha'lilina, ga dhunupana ŋayi yurru ŋunhiyi gapunydja gulaŋdhirrina.” ");
INSERT INTO gnn_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Bala Mawtjitjtja waŋana Garraywala bitjarra, “Way Garray, yaka dhuwala ŋarra ŋamakurru waŋanharawu yolŋu'‐yulŋuwu. Ŋarra ŋuli waŋi bulnhana, liŋgu bundhuwulu ŋarra dhuwala ŋäṉarr waŋanharawu.” ");
INSERT INTO gnn_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Ga Garraynydja waŋana dhä‐wirrka'yurruna bitjarra, “Yolthu dhika yolŋu'‐yulŋunhanydja djäma? Ŋarrapi dhuwala djäma yolŋunhanydja ŋäṉarrmirriyaŋala. ");
INSERT INTO gnn_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Gatjuy marrtjiyana nhe yurru, ga ŋarra yurru nhokala ŋäṉarrŋuranydja, guŋga'yundja nhuna. Ŋarra yurru nhuna dhäruk wekama waŋanharawunydja.” ");
INSERT INTO gnn_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Yurru ŋayi Mawtjitjtja waŋana bitjarra, “Yä‐ä‐äw, yakana Garray ŋarranydja yurru marrtji. Djuy'yurra wiripuŋunhana ŋula yolŋunha.” ");
INSERT INTO gnn_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Bala Garraynydja ŋaramurryinana Mawtjitjkala, ga waŋana nhanukala bitjarrana, “Wäwa'mirriŋu nhuŋu ŋunha Yärun dhäruk ŋamakurruny'tja. Galki ŋayi yurru marrtjina lili yulŋunydja, bala ŋayi yurru gumurr‐ŋamathirrina wirrkina nhämanydja nhuna. ");
INSERT INTO gnn_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Nhenydja yurru dhäruk wekaŋa nhanukalana Yärungalana, ga ŋayina yurru waŋa dhä‐warrwarnydja yolŋu'‐yulŋuwu. Ŋarranydja yurru nhokala ŋäṉarrŋura, ga ŋarrana yurru djäma ḻakaramanydja nhumalaŋgu. ");
INSERT INTO gnn_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Yurru Yärunnha, ŋayina yurru waŋanydja ḻakaramanydja yolŋu'‐yulŋuwa dhäruktja ŋunhi ŋarra yurru dhäruk wekama nhokala. ");
INSERT INTO gnn_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Ga dhuwalana wapitjany'tja nhe yurru gäma nhokalay goŋdhunydja, liŋgu dhiyaŋu wapitja'yu nhe yurru yiŋarrayny'tja milkuma walalaŋgu,” bitjarrayina ŋayi Garrayyu djäma wekaŋala Mawtjitjnhanydja. ");
INSERT INTO gnn_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Bala Mawtjitjtja marrtjina roŋiyinana balayi wäŋalili, ŋapipi'mirriŋuwana ḏo'yurruna. Djar'tjaryurrunanydja ŋayi‐i‐i, ga ŋunhala wäŋaŋura ḏo'yurruna, bala ŋayi waŋana gawal'mirriŋuwala bitjarra, “Ŋarranydja boŋguŋu dhuwala marrtjina, roŋiyi balayi Yetjiplili, nhäŋu marrtji ŋarrakuway miṯtjinha, nhä walala yukurra nhina, . . . baḏak walŋamirri? . . . mak liŋguna murrmurryun.” Bala nhanŋu gawal'mirriŋunydja waŋana yoraŋalana bitjarrana, “Gatjuy marrtjiyana.” ");
INSERT INTO gnn_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Yo, Garraynydja waŋana Mawtjitjkala ŋunhala wäŋaŋura Midiyan, “Gatjuy roŋiyiyana ma' balayi Yetjiplili, liŋgu ŋunhinydja walala yolŋu'‐yulŋu ŋunhi walala nhuna guyaŋina bunharawuy, liŋguna walalanydja rakunymirrina.” ");
INSERT INTO gnn_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Bala Mawtjitjtja gaŋgathinana, garr'yurruna nhanŋuway miyalknhanydja ga gäthu'mirriŋunha walalanha, ga wap‐wapmaraŋala duŋ'kiwala ḏiltjililina, bala martj‐martjtjurrunana balayi Yetjiplili roŋi'‐ruŋiyina, gäŋalanydja nhinana bala ŋayi Mawtjitjthu goŋdhunydja yiŋarray', Garraywu wapitja. ");
INSERT INTO gnn_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Bala Garray waŋana Mawtjitjkala bitjarra, “Yo, ŋunhi nhe yurru ḏo'yun ŋunhala Yetjiptja, marrtjiya balanydja buŋgawawalanydja, bala djämana dhuwaliyi dharrpalnydja maṉḏanha rom milma nhanukala. Nhäma warray ŋayi yurru yulŋunydja, yurru yakana ŋayi yurru djuy'yundja yolŋu'‐yulŋunhanydja, liŋgu rom‐ḏälnha ŋayi. Ŋarranydja yurru mukthun yana ŋayaŋunydja nhanŋu ḏälkuma. ");
INSERT INTO gnn_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Ga biyakana nhe yurru ḻakaraŋa ŋurikala buŋgawawalanydja, ‘Garraynydja yukurra waŋa bitjan, “Dhuwala Yitjuralnydja bäpurru balanyarana bitjan ŋarrakuwaynha maḻamarr gäthu'mirriŋu. ");
INSERT INTO gnn_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Liŋgu ŋarra nhuna waŋananydja, nhe yurru djuy'yun ŋarraku gäthu'mirriŋunhanydja, märr ŋayi yurru marrtjina, bala buku‐ŋal'yunna ŋarraku. Yurru nhenydja waŋana yaka'yurruna, bala ŋarranydja yurru buma rakunygumana nhipalanydja maḻamarrnha gäthu'mirriŋunha.” ’ Biyaka ḻakaraŋa buŋgawawalanydja ŋarrapi dhuwala dhäruktja,” bitjarra ŋayi Garraynydja waŋana Mawtjitjkala, ŋunhi baḏakka yana ŋayi marrtjina yukurrana balayi Yetjiplili. ");
INSERT INTO gnn_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Yo, mukthurruna yana walala yukurrana marrtjina yulŋunydja‐a‐a, ga gandarrŋura bala walala gulyurrunana, bala ŋayi Garraynydja bunana Mawtjitjku, ŋayi bini bunha muka ŋanya Godthunydja Mawtjitjnha, galki ŋayi bini rakunydhinyana, liŋgu ŋayi yaka ḏarrtjalkkuŋala mitthurruna nhanŋuway ŋayi gäthu'mirriŋunha, yaka ŋayi djäma ŋunhi rom Godku yiŋarray' ŋunhi ḻakarama yukurra mim'punydja ŋunhinydja Godkuna nhanŋuwaynha dhawu'. ");
INSERT INTO gnn_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","26","Bala ŋayinydja dhäykayuna marrtjina nhanukala ŋuriŋina Djipurayuna märraŋala raywalny'tja yiki, bala mitthurruna ḏarrtjalkkuŋalana ŋanya ŋunhi yothu'nhanydja. Yurru ŋayi wirrkina dhika ŋaramurryinanydja, bala gäŋala barrwaṉ'tja ŋunhi, bala ḏupthurruna nhanukala gumurrlilina Mawtjitjkala, bala ŋayi waŋana bitjarrana, “Nhä dhuwala nhe dhuway'mirriŋunydja ŋarraku? . . . gulaŋgu djäl‐ḏumurru?” bitjarra. Bala ŋayi Godthu Mawtjitjnhanydja walŋakuŋalana, yakana ŋayi rakunydhinanydja ŋulinyaramirriyunydjayi. ");
INSERT INTO gnn_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Ga ŋunhala Yetjip wäŋaŋura, ŋayi nhinana yukurrana Mawtjitjku wäwa'mirriŋu Yärun yäku. Ŋayi Garrayyu waŋana Yärunnha, djuy'yurruna ŋanya bitjarra, “Gatjuy, nhe yurru marrtjiya bala ŋunhamala ŋanhdharklili wäŋalili, ga ŋunhala nhuma yurru gumurr‐bunanharamirri, gutha‐ŋalinydja Mawtjitjtja.” Bala Yärundja gaŋgathinana, dhunupana djar'tjaryurrunana. Marrtjinana ŋayi‐i‐i, marrtjinana yana liŋgu‐u‐u, ga ŋunhala bili wäŋaŋura bukuŋura, ŋunhi Garraywu Buku, ḏo'yunminanydja maṉḏa ŋunhilina, bala maṉḏa dhangi'yunminana, wälkunharaminana. ");
INSERT INTO gnn_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Mawtjitjthu ḻakaraŋalana yukurrana dhäwu'na nhanbala Yärunbanydja, ŋunhi nhaltjarra Garrayyu ḻakaraŋala yukurrana, ŋunhi ŋanya Garrayyu djuy'yurruna liliyi. Ga bitjarrayi liŋgu ŋayi ḻakaraŋala ŋurikiy yiŋarray'wuynydja, ŋunhi ŋayi djäma ḻakaraŋala nhanbala Mawtjitjpa Garrayyu. ");
INSERT INTO gnn_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Bala Mawtjitjtja ga Yärundja gaŋgathina ŋuliŋuruyi, bala rrambaŋina wäŋgaŋala Yetjiplilinydja. Bala maṉḏa buku‐ḻuŋ'maraŋala ḏilaknha ŋurru'‐ŋurruŋunhana, bukmaknha yana Yitjuralnha bäpurru'nha. ");
INSERT INTO gnn_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Bala Yärundhu ḻakaraŋalana yukurrana walalambala Garraynhana dhäruk, ŋunhi ŋayi Garray dhäruk‐nherraṉmina Mawtjitjkala. Ga bitjarrayi bili Mawtjitjthu djämayi yukurrana ŋunhalanydja, milkuŋala walalambala yiŋarray' ŋunhi, wapitja'wuynha moḻŋuyinyara, ga goŋbuy burrpuymirriyinyara, ");
INSERT INTO gnn_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","bala walala bukmak ŋunhi yolŋu'‐yulŋunydja ŋayaŋu‐yuwalkthinana yana. Walala ŋäkulana ŋunhiyi dhäwuny'tja ŋunhi ŋayi Garraynydja liŋguna ḏo'yurrunana walalambala, ga nhäŋala ŋayi walalanha galŋa‐miḏikinyarana, bala walala bukmakthinana buku‐nyilŋ'thurrunanydja, buku‐ŋal'yurrunana manapara Garraywu. ");
INSERT INTO gnn_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Ga yalalaŋumirriyunydja, maṉḏa Mawtjitj ga Yärun marrtjina bala buŋgawanhana withiyara Yetjippuyŋunhana, bala maṉḏa waŋananydja nhanukala bitjarrana, “Bitjan yukurra dhuwala Garraynydja waŋa, ŋunhi Yitjuralwunydja Waŋarr, ‘Ma' djuy'yurrana ŋarrakunydja miṯtjinha, walala yurru marrtjina ga buku‐ŋal'yun ŋarraku, ŋunhalana yurru ŋanhdharkŋurana wäŋaŋura.’” ");
INSERT INTO gnn_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Yurru ŋunhi buŋgawanydja waŋana bitjarra warray, “Yol be ŋayi Garraynydja? Nhäku ŋarra yurru nhanŋunydja dhärukku malthun be? Yaka warray ŋarra marŋgi beŋuwu Garraywu. Yakana ŋarranydja yurru djuy'yun Yitjuralnhanydja.” ");
INSERT INTO gnn_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Bala maṉḏa Mawtjitjtja ga Yärundja waŋana bitjarrana, “Ŋanapurru yurru marrtji ŋi', märr‐gurriri ŋunha‐bala ya', ḻurrkun' walu ŋanapurru yurru marrtjinydja ŋunhawalayi ŋanhdharklilinydja wäŋalili, ga ŋunhalayinydja ŋanapurru yurru wekama mundhurrnha Godkuna, wäyinnha bathan yurru nhanŋu, buku‐ŋal'yunna bitjanna manapan. Ŋuli ŋanapurru yakanydja nhanŋu buku‐ŋal'yun yurru, ŋayinydja yurru mak Godthunydja ŋanapurrunha bumana, ga rerriyuna ŋula nhäyuna ŋanapurru yurru burakirri.” ");
INSERT INTO gnn_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Ga ŋayinydja waŋana ŋunhi buŋgawanydja maṉḏakala bitjarra, “Yakana yurru walala ŋunhiyinydja yolŋu walala marrtji. Yakana walala yurru ḏaḏawyun djämaŋuru. ");
INSERT INTO gnn_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Nhumanydja dhuwalanydja Yitjuralpuyŋunydja miṯtji guḻku' mirithirri, dhaŋaŋ wal'ŋu, djuḻkmarama yukurra ŋanapurrunhanydja Yetjippuyŋunhanydja yolŋu'‐yulŋunha. Nhuma yurru djäma yana ŋanapurruŋgu, bäyŋu nhuma yurru ḏaḏawyun djämaŋuru.” ");
INSERT INTO gnn_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","14","Ga ŋulinyaramirriyu liŋgu, ŋayi buŋgawa wäthurruna ŋurru'‐ŋurruŋuwu djämamirriwu walalaŋgu ŋunhi walala yukurranha ŋuli buŋgawayinya Yitjuralpuyŋuwu walalaŋgu. Ŋayi waŋana walalaŋgala bitjarra, “Ŋunhanydja walala Yitjuralpuyŋunydja yolŋu'‐yulŋu ḏuŋ'ḏuŋmirrina, yana walala marrtji nhinana ŋunha, liŋgu walala yukurra waŋa bitjanna, ‘Gul' ŋilimurru marrtjina go, buku‐ŋal'yunna ŋilimurruŋgalaŋuwu Waŋarrwuna,’ bitjanna. Nhuma buŋgawayunydja walalay yurru gorrwuŋa muka walalanha, wirrkiwu muka wal'ŋu djämawu; walala bitjan yurru wirrki djäma ya', ŋutu' wal'ŋu, märr yakana walala yurru mäkiri'‐witjun maṉḏaku bothinyarayŋuwunydja dhäwu'wu.” Bala ŋuriŋi ŋurru'‐ŋurruŋuyunydja buŋgawayunydja walalay gorrwuŋala wirrkina, djämana ḻakaraŋala ŋutu'na. ");
INSERT INTO gnn_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","21","Bala Yitjuralpuyŋuyunydja yolŋuyu walalay waŋana ŋarrtjurruna maṉḏanhana Mawtjitjnhana ga Yärunnhana bitjarra, “Nhuma maṉḏa dhiyaŋu maṉḏathu ŋunhi buŋgawanhanydja ŋayaŋu‐yätjkuŋala, bala ŋayi yukurra ŋunha ŋaramurryirrina ŋanapurruŋgu, ga nhanŋu djämamirri walala bitjandhi yana liŋgu ŋaramurryirri yukurra ŋanapurruŋguway yana. Gatjpu' nhumalanha ŋayi Garrayyu rakunyguŋu, liŋgu nhuma yukurra goŋ‐wekama gara dhuwala walalaŋgala, ŋanapurruŋgu dharpunharawu.” ");
INSERT INTO gnn_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Bala Mawtjitjtja balayi roŋiyina, ga waŋana Garraynha bitjarra, “Garray gay'. Nhäku warray nhe dhuwala galŋa‐yätjkuŋala dhuwala yolŋu'‐yulŋunhanydja? Nhäku nhe ŋarranhanydja yawungu djuy'yun lili dhipala? ");
INSERT INTO gnn_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Liŋgu beŋurunydja ŋunhi ŋarra yawungu dhäwu' ḻakarama buŋgawawalanydja nhunanydja yäku, ga ŋayinydja ŋuli yukurra buŋgawanydja bitjanna liŋguna yätjthirrina dhiyaku yolŋu'‐yulŋuwunydja. Nhenydja yaka warray yawungu guŋga'yunanydja walalanha; yaka nhe walalanha dhawaṯmaranha, ga ŋoy‐ḻayyunmaranhanydja.” ");
INSERT INTO gnn_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Yurru Garraynydja waŋana nhanukala dhärukkurru bitjarra, “Dhiyaŋunydja‐wala nhe yurru nhäma ŋarranha djämawuynha, ŋunhi nhaltjan ŋarra yurru ŋanya buŋgawanha. Ŋayinydja yurru djutjtjutjuyunna nhumalanha. Yo, ḏälyuna dhärukthu ŋayi yurru nhumalanha gukumanydja dhipuŋurunydja wäŋaŋuru.” ");
INSERT INTO gnn_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Bala ŋayi Garraynydja waŋana Mawtjitjkala bitjarrana, “Ŋarranydja dhuwala ŋunhiyi muka Garray wal'ŋu waŋarr, ");
INSERT INTO gnn_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","ŋunhi ŋarra ŋäthili maḻŋ'maranhamina Yipurayimgala ga Yitjakkala ga Djaykupkala, ŋunhi yäkunydja ŋarra dhuwala Ŋutu' Ḏälnha. ");
INSERT INTO gnn_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Bala ŋarra dhawu'na nherrara walalaŋgu, ŋunhi wäŋanydja ŋunhiyi Gaynandja yurru walalaŋguway yana wal'ŋu Yipurayimgalaŋuwu mala‐wunharawuywu, yurru nhinananydja walala yukurrana ŋunhili wäŋaŋuranydja mulkuru yolŋunydja walala yana ŋulinyaramirriyunydjayi. ");
INSERT INTO gnn_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Yo, ŋäkulana liŋguna ŋarra ŋarrakuwaynydja ŋarra yolŋunha walalanha miṯtjinha Yitjuralnhanydja, walala yukurra ŋorr'‐ŋurryunmirri ŋonuŋdhu romdhu, liŋgu walala yukurra ŋunhi nhina garrpiṉara Yetjippuyŋuwuŋu miṯtjiwuŋu. Bala ŋarra buku‐ḻayyurrunana ŋarrakalaŋuwu ŋarra ŋuriki dhawu'wunydja, ga yuwalknha yana ŋarra yurru djämanydja ŋunhiyi ŋunhi ŋarra dhawu'‐nherrara walalanha ŋäthili. ");
INSERT INTO gnn_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Gatjuy marrtjiya yana, ga ḻakaraŋa ŋurupa yolŋu'‐yulŋuwa Yitjuralpuyŋuwa, biyaka nhe yurru waŋiyanydja gam', ‘Ŋarranydja dhuwala Garray God. Ŋarra yurru nhumalanha märrama dhawaṯmaramana dhipuŋuru ŋonuŋŋurunydja romŋuru, Yetjipŋurunydja yurru, ga bitjandhi liŋgu dhipuŋuru ḏirrwi'‐ḏirrwiŋurunydja walalaŋgala. Ŋarra yurru nhumalaŋgu waṉa‐djarryunna, bala dhawaṯmaramana djaw'yunna goŋŋurunydja walalaŋgala ŋarrakalaynha wal'ŋu yana ganydjarryu. Ŋarrapina yana nhumalanha yurru walŋakumanydja. ");
INSERT INTO gnn_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Yo, ŋarranydja yurru dhuwala goŋdhu‐märramana nhumalanhanydja; nhumanydja yurru ŋarrakuwaynha yana yolŋu walala, ga ŋarranydja yurru nhumalaŋgu Waŋarrnha. Nhuma yurru marŋgithirri ŋarrakuna, ŋunhi ŋarra dhuwala Garraynydja, nhumalaŋgunydja Waŋarr, ŋunhi muka bili waŋgany ŋunhi ŋarra nhumalanha ḻaw'maraŋala, bala dhawaṯmaraŋalana Yetjippuyŋuwalanydja, ŋonuŋŋurunydja romŋuru. ");
INSERT INTO gnn_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Ŋarra yurru nhumalanha dhawaṯmaramana dhipuŋurunydja, bala gäma nhumalanha ŋunhamalayi bili wäŋalili Gaynanliliyi ŋunhi ŋarra dhawu'‐nherrara nhumalaŋgalaŋuwu märi'muwu walalaŋgu Yipurayimgu, ga Yitjakku, ga Djaykupku. Wäŋanydja ŋarra yurru ŋunhayi wekama nhumalaŋguna, ga yuwalk yana wäŋanydja ŋunhiyi yurru djingaryun yukurra nhumalaŋguwaynha yana yirralkanydja. Ŋarranydja dhuwala Garray God nhumalaŋgu.’” Bitjarra ŋayi Garray waŋananydja. ");
INSERT INTO gnn_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Bala ŋayi Mawtjitjthunydja ḻuŋ'maraŋalana bukmaknhana yolŋu'‐yulŋunha, Yitjuralpuyŋunha yana bäpurru'nha, bala ḻakaraŋala dhuwalana malanha dhäruk walalaŋgu, ŋunhi ŋayi Garray dhäruk‐nherraṉmina. Yurru walala yolŋu'‐yulŋunydja yakana ŋayaŋu‐yuwalkthina Mawtjitjkala dhärukthu, bili walalaŋgu ŋayaŋunydja djawaryurrunana ŋuriŋi ḏirrwiḏirrwi‐mulkanharayunydja yukurranharayu ga baymatthunarayuna. ");
INSERT INTO gnn_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","11","Ga biyapul Garray waŋana Mawtjitjkala, djuy'yurruna ŋanya Yetjippuyŋuwala buŋgawawala bitjarra, “Gatjuy marrtjiya, bala buŋgawawala gärriya, ga ḻakaraŋa nhanbala, ŋayi yurru djuy'yun dhuwala yolŋunha walalanha Yitjuralpuyŋunhanydja, yarrkmaramana dhipuŋurunydja nhanukalaynydja wäŋaŋuru.” ");
INSERT INTO gnn_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Ga ŋayi Mawtjitjtja waŋana Garraywala, buku‐wakmaraŋala bitjarra, “Ŋunha Yitjuralpuyŋunydja yolŋu'‐yulŋu ŋarraku yakana yukurrana mäkiri'‐witjurruna, ga nhaltjanna ŋayinydja yurru mäkiri'‐witjun ŋarraku ŋunha buŋgawanydja? . . . liŋgu ŋarranydja dhuwala ŋäṉarr‐bundhuwulu'na yolŋu.” ");
INSERT INTO gnn_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Bala Garraynydja waŋanana Mawtjitjkala ga Yärungala bitjarrana, “Gatjuy marrtjiya maṉḏa, ga ḻakaraŋa yolŋu'‐yulŋuwa ga buŋgawawa, ŋunhi ŋarrapi yana nhumalanhanydja djarr'yurruna nherrara dhiyakuyinydja djämawu. Märr‐yuwalknha nhuma yurru dhawaṯmaramana Yitjuralnhanydja dhipuŋuru wäŋaŋuru Yetjipŋurunydja.” ");
INSERT INTO gnn_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","7","Bala Mawtjitjtja ga Yärundja dhäruknha yana märraŋala Garraynha, bala maṉḏa marrtjinana, ga ḻakaraŋala buŋgawawana ŋunhi nhaltjarra Garrayyu waŋana ḻakaraŋala maṉḏakala. Yurru maṉḏa worruŋuna ŋunhi yulŋunydja; nhanŋu Mawtjitjkunydja dhuŋgarra djaka'wu 80 ŋulinyaramirriyunydja, ga nhanŋunydja Yärungunydja dhuŋgarra 83‐na. ");
INSERT INTO gnn_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","10","Ŋe. Marrtjinana bala maṉḏa, bur‐way bunana, bala maṉḏa ḻakaraŋalana Godkuŋu dhaŋunydja, ga biyapul ŋayi Yärundhu ŋurrkaŋala ŋunhiyi wapitja gumurrlili ŋurikala buŋgawawala ga nhanukalaŋuwala djämamirriwala walalaŋgala, bala dhunupana ŋunhi wapitjany'tja marrtjina moḻ'ŋuyinana. ");
INSERT INTO gnn_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","12","Bala ŋayinydja ŋunhi buŋgawanydja wäthurruna nhanukalayŋuwu gaḏamanmirriwuna yolŋuwu walalaŋgu, ga bitjarrayi bili walalanydja djäma ŋuriŋi waŋga'‐waŋganydhu ŋurrka'‐ŋurrkaŋala wapitja malanha, ga walalambalanydja wapitja malanha bitjarrayi bili moḻ'ŋuyinayi. Bala nhanukalanydja Yärungalanydja marrtjina wapitja'yu wurkthurruna warray walalambalanydja wapitja'nha malaŋunha. ");
INSERT INTO gnn_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Ga baḏak yana ŋunhi Yetjippuyŋunydja buŋgawa rom‐ḏälthina yukurrana; yakana ŋayi mäkiri'‐witjurruna maṉḏaku dhärukku, bitjarrayi yana bili bitjarra ŋunhi ŋayi Garrayyu ḻakaraŋala ŋäthili‐wala maṉḏakala. ");
INSERT INTO gnn_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Bala Garrayyunydja ḻakaraŋala Mawtjitjkala bitjarrana, “Yetjippuyŋunydja buŋgawa dhuwali rom‐ḏälthirrina yukurra, yaka'yunna ŋayi yukurra dhuwali yulŋunydja. Yakana ŋayi yurru djuy'yundja. ");
INSERT INTO gnn_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Goḏarrny'tja boŋguŋunydja nhuma maṉḏa marrtji boŋgama bala mayaŋ'lili, ga ŋunhala yana nhuma boŋgama nhänharami ŋunhi buŋgawanydja. Waŋinydja nhuma boŋgaŋu biyapul nhanukala, ");
INSERT INTO gnn_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","‘Yaka nhe mäkiri'‐witjurruna Godkalaŋunydja dhärukku, ŋunhi ŋayi waŋana nhuna yängunharawu nhanukalayŋuwu yolŋu'‐yulŋuwu, märr yurru walala yukurra buku‐ŋal'yun nhanŋuway. ");
INSERT INTO gnn_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Ga dhiyaŋunydja‐wala nhe yurru marŋgithirrina Godku, yol ŋayi ŋunhi. Ŋarranydja yurru gapunha dhuwala wutthun dhiyaŋu dharpayu, bala ŋayi yurru gapunydja dhuwala wiripuyirrina, gulaŋdhirrina yurru. ");
INSERT INTO gnn_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Yo, walala yurru ŋarirriny'tja murrmurryunna bukmaknha, ga gapunydja yurru dhuwalayi boŋirriny'thirrina, barrpa'yirrina buŋgandja, märr yurru yakana ŋula yolthu ḻuka yukurra ŋuliŋuruyi mayaŋ'ŋuru.’” ");
INSERT INTO gnn_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","21","Bala maṉḏa yuwalkthi Yärundhunydja ga Mawtjitjthunydja ŋunhi nhaltjarra maṉḏaku Garrayyu djäma ḻakaraŋala. Bala ŋayi Yärundhunydja warr‐way märraŋala wapitja'na bala yana gapuna marrtjina wutthurruna. Dhunupa gapunydja gulaŋdhinana; warrpam'nha gulaŋdhina ḻiw'maraŋala Yetjiptja. Ga ḏumurru'ŋunydja gapu mayaŋ gulaŋdhinayi yana, ga guyanydja marrtjina murrmurryurrunana, ga buŋgan boŋirriny'thinana ŋunhiyi gapunydja. Yakana walala ŋuriŋiyi Yetjippuyŋuyunydja yolŋu'‐yulŋuyu yukurrana ḻukana ŋuliŋurunydja gapu, liŋgu warrpam'nha gapunydja gulaŋdhinana yätjthinana. ");
INSERT INTO gnn_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","25","Bala walalanydja Yetjippuyŋuyunydja gaḏamanmirriyu walalay bitjarrayi liŋgu yana djäma gapu gulaŋguŋala. Bala ŋayi buŋgawanydja buluna rom‐ḏälthina; yakana ŋayi mäkiri'‐witjurruna maṉḏaku dhärukku. ");
INSERT INTO gnn_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Bala märr‐ḻurrkun' munha djuḻkthurruna ŋuliŋuruyi ŋunhi ŋayi Garrayyu wutthurruna gapu mayaŋ', bala Garraynydja waŋana Mawtjitjkala, biyapul djuy'yurruna ŋanya buŋgawawala, “Gatjuy marrtjiya bala buŋgawawala,” bitjarra. Bala maṉḏa marrtjinana, withiyarana ŋanya buŋgawanhana, ga ḻakaraŋala nhanbala bitjarra, “Garraynydja yukurra waŋa bitjan, ‘Djuy'yurrana ŋarraku malanhanydja yolŋu'‐yulŋunhanydja, märr walala yurru dhawaṯthunna ga buku‐ŋal'yunna ŋarraku. ");
INSERT INTO gnn_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","4","Ŋuli nhe yurru waŋa yaka'yundja, ŋarranydja yurru djuy'yun guḻku'na garkman, walala yurru monygumana warrpam'nha wäŋanydja. Walala yurru gärrina marrtji nhumalaŋgala wäŋalilina malaŋulili, wapthunna yurru marrtji rupa'kurruna ga ŋathakurru ga girri'kurru, mirithirrina dhaŋaŋnha.’” ");
INSERT INTO gnn_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","6","Bala Yärundhunydja märraŋala ŋunhiyi wapitja'na, bala ŋayi biyapul dhunupamirriyaŋala, waywayyurruna yukurrana gapu ŋunhi mayaŋ, bala marrtjina mayaŋ'tja dhaŋaŋdhinana garkmandhuna; dhaŋaŋdhinana marrtjina‐a‐a, dhaŋaŋ gay', yana liŋgu wäŋanydja ŋunha Yetjippuynydja gungaŋalana miṯtjiyu garkmandhuna. ");
INSERT INTO gnn_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Ga walalanydja Yetjippuyŋunydja gaḏamanmirri ŋulthu'yurrunayi, ga bitjarrayi liŋgu märr'yunmaraŋala garkmannha walalaŋgiyingalanydja ganydjarryu. ");
INSERT INTO gnn_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Bala buŋgawanydja ŋunhi wäthurruna maṉḏaku Mawtjitjku ga Yärungu, bala waŋanana maṉḏanha bitjarra, “Way maṉḏa! Waŋiya nhuŋuway Garraynha, ŋayi yurru dhuwala djaw'yun, winya'yunmarama garkmannha, bala ŋarranydja yurru djuy'yunna nhumalaŋgu yolŋu'‐yulŋunhanydja, walala yurru marrtjina, bala buku‐ŋal'yunna nhanŋu Garraywuna.” ");
INSERT INTO gnn_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","“Nhätha boŋguŋu nhe ḏukṯukthi Garraywunydja dhiyaku garkmangunydja yarrkmaranharawu?” bitjarra Mawtjitj waŋana. ");
INSERT INTO gnn_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","11","“Goḏarr'nha ŋi',” bitjarra ŋayi buŋgawanydja. “Dhiyaŋiyi liŋgu dhuwali nhe waŋana, walala yurru garkmandja walala winya'‐winyayurru wäŋaŋurunydja, märr yurru nhuma marŋgithirri Garraywu ŋanapurruŋgalaŋuwu Waŋarrwu. Bäyŋuna yukurra nhina dhiyalami wiripunydja waŋarr balanyara bitjan ŋayi ŋunhi,” bitjarra ŋayi Mawtjitjthu ḻakaraŋalanydja buŋgawawala. ");
INSERT INTO gnn_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","13","Bala maṉḏa djar'tjaryurruna, gonha'yurrunana buŋgawanhanydja, ga ŋunhala bala märr‐barrku Mawtjitj waŋana bukumirriyaŋala Garraywala, ga ŋayi Garrayyunydja djämana‐wala yanana ŋunhi Mawtjitjthu ŋäŋ'thurruna ŋanya bitjanarawu. Ga dhunupana yana garkmandja ŋunhi murrmurryurruna, bukmakthinana yana. ");
INSERT INTO gnn_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Bala walala yolŋu'‐yulŋuyunydja djämana yäkthurrunana, ga wäŋanydja ŋunhi buŋgandja waŋgi'yurruna butjirina. ");
INSERT INTO gnn_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Bala ŋayi buŋgawayunydja nhäŋala winya'‐winyayunaranydja, ga baḏak yana rom‐ḏälthina; yakana ŋula mäkiri'‐witjurruna maṉḏaku, bitjarrana liŋguna ŋunhi ŋayi Garrayyu ḻakaraŋala maṉḏakala dhä‐ŋäthili. ");
INSERT INTO gnn_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Bala Garrayyunydja waŋana Mawtjitjnha bitjarra, “Ḻakaraŋana Yärunbanydja, ŋayi yurru dhunupamirriyama wapitja'yuna, bala wutthun munatha'na, bala yurru munathany'tja mindjirrimirriyirrina, warrpam'nha yurru monyguma, ḻiw'marama Yetjiptja wäŋa.” ");
INSERT INTO gnn_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Bala yuwalkthi, dhaŋaŋdhinana milkmilktja, bala walalanha bumaranydja marrtjina wäyinnha walalanha ga yolŋu'‐yulŋunha. ");
INSERT INTO gnn_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Ga walalanydja bitjarrayi liŋgu yana ŋulthu'yurrunayi, ŋuriŋiyinydja gaḏamanmirriyunydja, bitjanayi liŋgu bini walala, yurru gulkuru warray walalanydja bitjarrayi. ");
INSERT INTO gnn_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Bala walala waŋana buŋgawanhana ŋuriŋi gaḏamanmirriyunydja, “Dhuwalanydja dhuwala Waŋarrwuŋu warray goŋbuy,” bitjarra. Yurru buŋgawanydja ŋayaŋu‐wuṉḏaŋarrthina warray marrtjina, yakana ŋäkula yana, bitjarrayi yana liŋgu ŋunhi Garrayyu maṉḏakala ḻakaraŋala ŋunhala ŋäthili. ");
INSERT INTO gnn_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Bala Garrayyu djuy'yurruna biyapul Mawtjitjnha bala buŋgawawala, bala ŋayi marrtjinana. Marrtjinanydja ŋayi, bala waŋana buŋgawawala bitjarrana, “Bitjan Garraynydja waŋa yukurra nhuŋu gam', ‘Djuy'yurrana ŋarraku miṯtjinhanydja, walala yurru märr‐ŋal'yunna ŋarraku. ");
INSERT INTO gnn_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Ŋuli nhe yurru yakanydja djuy'yun walalanha, ŋarraku miṯtjinha, ŋarranydja yurru djuy'yun guḻku'na wurruḻuḻ', biyapulnha guḻku', walala yurru dhaŋaŋdhirrina nhokala wäŋaŋuranydja, ga bukmaknha dhuwala nhokalaŋuwu miṯtjiwunydja dhaŋaŋdhirrina yurru wurruḻuḻny'tja wäŋaŋuranydja nhumalaŋgala. Yo, balany'tja nhumalaŋgu yurru gungamana warrpam'nha, ga munathany'tja yurru gungamayi warrpam'thi buku‐ḻiw'marama Yetjippuyŋuwu. ");
INSERT INTO gnn_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","23","Yurru ŋunhanydja wäŋa yäku Gutjinbuynydja, ŋunha ŋarraku yukurra miṯtji nhina, yakanydja yurru wurruḻuḻ'mirriyirri, liŋgu ŋarra yurru barrkuwatjkuma ŋarrakuway miṯtjinha yolŋu'‐yulŋunha ga nhipala miṯtjinha, märr nhe yurru marŋgithirri ŋarraku, liŋgu ŋarranydja Garray dhiyalami ṉapuŋga nhumalaŋgala munatha'ŋura. Yo, ga goḏarr'nha boŋguŋu dhuwala yiŋarrayny'tja maḻŋ'thurru.’” ");
INSERT INTO gnn_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Bala yuwalkthi, Garrayyunydja djuy'yurrunana wurruḻuḻ'nha, biyaku ŋuli ŋula nhä monyguŋalanydja warrpam' wäŋa, bala' malanha djinawa', ga warraŋul wäŋa Yetjippuy monyguŋalayi yana warrpam', yurru Yitjuralpuyŋuwunydja wäŋa bäyŋu wurruḻuḻ'mirriyina. ");
INSERT INTO gnn_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Bala buŋgawanydja wäthurruna maṉḏakuna, Mawtjitjkuna ga Yärunguna. Marrtjinanydja maṉḏa, ga bunana buŋgawawu, ga ŋayinydja waŋana maṉḏakala bitjarra, “Manymak warray nhuma yurru yolŋu'‐yulŋu buku‐ŋal'yundja nhumalaŋgalaŋuwu Waŋarrwunydja, bathan mundhurrnydja nhanŋu, yurru dhiyala bäyma; yaka ŋunhalanydja bala barrkunydja.” ");
INSERT INTO gnn_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","27","Bala Mawtjitjtja waŋana buku‐wakmaraŋala bitjarra, “Yä‐ä‐äw! Dhuwalinydja yaka dhunupa ŋanapurruŋgu. Ŋanapurru yurru dhawaṯthun gänaŋulilinydja; ŋunhala warray märr‐barrku ŋanapurru yurru buku‐ŋal'yun ŋanapurruŋgalayŋuwunydja Waŋarrwu Garraywu.” ");
INSERT INTO gnn_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","“Gatjuy marrtjiyana walala, ga buku‐ŋal'yurrana, yurru märr‐galki yulŋunydja, yaka barrkulilinydja marrtjiya. Ga waŋiya nhuma yurru Garraynha, ŋayi yurru wurruḻuḻny'tja djaw'yunna, winya'yunmaramana ŋanapurruŋgala,” bitjarra buŋgawanydja waŋana. ");
INSERT INTO gnn_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Bala Mawtjitjtja waŋana buŋgawawala. “Manymak. Ŋarra yurru marrtji gonha'yun nhuna. Ŋarra yurru ŋäŋ'thun Garraynha, ga ŋayinydja yurru wurruḻuḻny'tja dhuwali yarrkmaramana. Ga yakana nhe djambinydja yurru, ga bothiyanydja waŋiya biyapulnydja.” ");
INSERT INTO gnn_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Bala Mawtjitjthunydja bay'‐way gonha'yurruna buŋgawanhanydja, bala yana bukukurru waŋana Garraywalanydja. ");
INSERT INTO gnn_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Bala Garrayyunydja yuwalkthi djämana‐wala yana, yarrkthunmaraŋalana wurruḻuḻ'nhanydja ŋulaŋuru buŋgawawalanydja ga miṯtjiwala yolŋu'‐yulŋuwala; yakana ŋula waŋgany meṉguŋala. ");
INSERT INTO gnn_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Bala ŋayinydja buŋgawanydja biyapul marrtjina djambi, rom‐ḏälkunhaminayi, wuṉḏaŋarrkunhaminayi ŋanyapinyay ŋayi; yakana ŋayi yolŋu'‐yulŋunhanydja djuy'yurruna. ");
INSERT INTO gnn_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Garrayyu djuy'yurruna Mawtjitjnha buŋgawawala biyapul, bala ŋayi marrtjinana withiyara buŋgawanhana, ga waŋana nhanukala bitjarra, “Garraynydja waŋa yukurra bitjan, ‘Djuy'yurrana ŋarraku miṯtjinhanydja, walala yurru buku‐ŋal'yun ŋarrakuna. ");
INSERT INTO gnn_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Ŋuli nhe yurru yakanydja djuy'yun walalanha, mukthun yukurra ḏirrwiḏirrwi‐mulka, ");
INSERT INTO gnn_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","ŋarranydja yurru djuy'yun rerrina wäyinguna, ŋayi yurru nhipala wäyindja walala, buliki ga yarraman' ga duŋ'ki rirrikthunmirrina, bala yurru murrmurryunna. ");
INSERT INTO gnn_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Yurru ŋarranydja yurru barrkuwatjkuma gulk‐gulkthun Yitjuralpuyŋuwunydja buliki'nha walalanha ŋulaŋuru Yetjippuyŋuwalanydja buliki'wala, yakana yurru ŋula waŋgany Yitjuralpuyŋuwunydja wäyin rirrikthunmirri. ");
INSERT INTO gnn_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Goḏarr'nha boŋguŋu dhuwala biyakuyinydja.’” Bitjarra ŋayi Garraynydja waŋana. ");
INSERT INTO gnn_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Ga wiripuŋuyuna ḏaykun'thu dhuwala maḻŋ'thurrunanydja yuwalkthi. Murrmurryurrunana marrtjina bukmak Yetjippuyŋuwunydja wäyin walala, yurru Yitjuralpuyŋuwunydja yaka ŋula waŋgany wäyin rakunydhina. ");
INSERT INTO gnn_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Bala ŋayi buŋgawayunydja djuy'yurruna dhäruk bitjarrana, “Gatjuy ma' marrtjiyana, ga nhäŋa Yitjuralpuyŋuwu wäyin.” Marrtjinanydja walala, bala nhäŋala walalambalanydja wäyin walŋamirri warray, bala gäŋala walala dhäwuny'tja, ga ḻakaraŋala nhanbalanydja. Yurru baḏak yana ŋayi buŋgawanydja rom‐ḏälthina, ga yakana djuy'yurruna yolŋunhanydja walalanha dhawaṯmaraŋalanydja. ");
INSERT INTO gnn_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Ga ŋuliŋurunydja dhurrwaraŋuru Garray waŋana maṉḏakala Mawtjitjkala ga Yärungala bitjarra, “Ma', dhiṯthurra maṉḏa ganu' gurtha nhumalaŋgiyingalay goŋdhu, ga marrtjiya withiyarra djunuma buŋgawanha, ga ŋunhili milmana nhanukala nhe yurru Mawtjitj djalkthun ganuny'tja garrwarlilinydja, ");
INSERT INTO gnn_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","bala yurru ŋayi buḻwaŋ'thunna ŋunhi ganuny'tja, wäŋanydja yurru warrpam'nha monyguma, buku‐ḻiw'maramana Yetjiptja, ga yolŋunha walalanha ga wäyinnha walalanha warrpam' yurru djiraŋ'mirriyirri, djetjimirriyirrina rumbal.” ");
INSERT INTO gnn_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Bala yuwalkthi maṉḏa bitjarrayina djalkthurrunana ŋunhi ganuny'tja garrwarlilinydja, bala yuwalkthi djiraŋ'mirriyinana marrtjina yolŋu'‐yulŋunydja ga wäyindja. ");
INSERT INTO gnn_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Ŋunhiyi gaḏamanmirrinydja yolŋu walala warrpam'nha djiraŋ'mirriyinana; yakana walala djingaryurrunanydja yukurrana nhäŋala Mawtjitjnhanydja, liŋgu walala gaḏamanmirrinydja ga bukmak Yetjippuyŋunydja yolŋu'‐yulŋu djiraŋ'mirriyinana. ");
INSERT INTO gnn_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Bala Garrayyunydja ŋayipinydja ŋanya ŋayaŋu‐ḏälkuŋalana ŋunhi buŋgawanhanydja, liŋgu ŋayipi ŋanyapinyay ŋayi rom‐ḏälkunhamina; yakana ŋayi mäkiri'‐witjurruna maṉḏaku dhärukku, bitjarra yana liŋgu bitjarra ŋunhi ŋäthili Garrayyu ḻakaraŋala Mawtjitjkala. ");
INSERT INTO gnn_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Bala Garray waŋanana Mawtjitjkala bitjarra, “Gaŋgathinydja nhe boŋgama, munhakumirri yana, bala marrtji withiyurru buŋgawanhana.” Bala yuwalkthi Mawtjitjtja gaŋgathina munhakumirri yana, bala marrtjina withiyara buŋgawanhana, ga ŋunhalanydja ŋayi waŋana nhanukala buŋgawawalanydja bitjarra, “Ŋarranydja gäŋala dhäruk Garraynha, Yitjuralpuyŋuwu Waŋarrnha. Bitjan ŋayi yukurra waŋanydja nhuŋu gam', ‘Djuy'yurrana ŋarraku miṯtjinhanydja, märr walala yurru buku‐ŋal'yun ŋarrakuna. ");
INSERT INTO gnn_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","16","Ŋarra bini nhumalanha dhawar'maranha muka yulŋunydja, bukmakkunhana ḏe'maranha, yurru ŋarra gonha'yurrunayi nhumalanha, gonhana nhuma nhiniya walŋamirrina, märr nhuma yurru nhämana ŋarraku ganydjarrnha, märr yurru bukmak yolŋu walala buku‐ḻiw'marama wäŋakurru, bäpurru'yu ga bäpurru'yu yurru ŋämanydja, ga marŋgithirri ŋarraku yäkuwunydja. ");
INSERT INTO gnn_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Yurru mukthun yana nhe yukurra dhuwala nhepi garrwarkunharamirrinydja, ŋurruŋukunharamirri, wäwundhirri ŋarrakalayŋuwunydja miṯtjiwu. Nhe yaka djuy'yurruna ŋarraku miṯtjinha. ");
INSERT INTO gnn_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Bala goḏarrny'tja, ŋarra boŋgama djuy'yurru wärrknha, goḏu‐guṉḏamirrina maḻwurrk, ŋayi boŋguŋu marrtji burruḻ'yurru ŋonuŋmirrina dhikana, wiripuna yana; yakana balanyara bitjarrayi yukurrana ŋäthilinydja dhiyala Yetjiptja maḻŋ'thurruna. ");
INSERT INTO gnn_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Gatjuy, dhäwuny'tja barrkuwatjkuŋana yolŋu'‐yulŋuwunydja, walala yurru ŋäthiliyi ŋilitjandja wäyinnhanydja walalanha ga yolŋu'‐yulŋunha bala'lilina, liŋgu dhiyaŋuyi wärrkthunydja yurru buma rakunygumana, dhä‐monygumana bukmaknhana yurru wäyinnha walalanha ga yolŋu'‐yulŋunha, ŋunhi walala yurru marrtji djingaryun baṉarra'ŋuranydja wäŋaŋura.’” Ga bitjarra Mawtjitjthu ḻakaraŋalanydja buŋgawawala. ");
INSERT INTO gnn_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Ga dhäruktja dhuwalayi barrkuwatjthinana, ga wiripuwurru Yetjippuy yolŋu'‐yulŋu wirrkina beyaṉiyina Garraynha dhäruk ŋäkula, bala walala dhark‐dharkkuŋalana marrtjina wäyinnhanydja walalanha bala'lilina, ŋurrwu'lilina, ga walalaŋguway djämamirrinha walalanha yolŋu'‐yulŋunha. ");
INSERT INTO gnn_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Ga wiripuwurrunydja yakana ŋula märr‐yuwalkthina, ŋayaŋu‐yuḻkthurrunana ŋäkula Garraynha dhäruk; walalambalanydja yolŋu'‐yulŋu djämamirri walala ga wäyin walala ŋunhala yana baṉarra'ŋura marrtjina djinga'‐djingaryurruna. ");
INSERT INTO gnn_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","25","Bala Mawtjitjtja waṉa‐djarryurrunana, garrwarkuŋala djiwarr'lili ŋunhi wapitja, bala yana Garrayyunydja djuy'yurruna wärrknha, goḏu‐maykarraṉ'mirrina, murryu'‐murryurrunana marrtjina, ŋutu'na dhikana maḻwurrk; Garrayyunydja marrtjina djirryunmaraŋalana guṉḏana ŋonuŋmirrina ŋunhimalanydja wäŋalili ŋarakalili Yetjiplilinydja. Ga ŋunhala bala baṉarra'ŋuranydja yolŋu'‐yulŋu ga wäyin walala warrpam'nha murrmurryurruna, ga dharpanydja marrtjina ḏaw'‐ḏawyurruna buḻwaŋ'thurrunana. ");
INSERT INTO gnn_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Yurru ŋunhalanydja wäŋaŋura yäkuŋura Gutjindja, ŋunhi Yitjuralpuyŋu yolŋu'‐yulŋu yukurrana nhinana, bäyŋu warray bumara; yakana ŋula waŋgany guṉḏa dhuryurruna ŋunhimala wäŋalili. ");
INSERT INTO gnn_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Yo. Mukthurrunaŋga yana yukurrana maḻwurrkthunydja dharyurruna ŋunha Yetjippuynydja, bala buŋgawanydja wäthurruna biyapul maṉḏaku Mawtjitjku ga Yärungu, bala waŋanana maṉḏakala bitjarra, “Ŋarrapi yana yätjtja. Garray warray dhuwala rom‐dhunupanydja, ga ŋarranydja ga ŋarraku miṯtji, ŋanapurrunydja dhuwala rom‐djarrpi'mirrina yana. ");
INSERT INTO gnn_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Ŋäŋ'thurra bukumirriyaŋa Godnha, märr yurru ŋayi gulkthunna dhuwalayi wärrktja, bala ŋarra yurru djuy'yunna nhumalanha dhuwala yulŋunydja; yakana nhuma yurru weyindja nhina dhiyala.” ");
INSERT INTO gnn_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Ga Mawtjitjtja waŋana nhanukala bitjarra, “Dhawaṯthundja ŋarra yurru dhipuŋuru, bala ŋarra yurru waṉa‐djarryun Garraywalana, bala yurru maḻwurrktja gulkthunna yana; yakana yurru biyapulnydja guṉḏa djirryun. Yo, wärrktja yurru dhawar'yunna, märr nhe yurru marŋgithirrina, liŋgu wäŋa dhuwala munathany'tja nhanŋuway dhulŋuŋu Garraywu, ");
INSERT INTO gnn_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","yurru nhenydja ga nhuŋu miṯtji yaka warray nhanŋu märr‐ŋal'yun ŋuli yukurra.” Bitjarra ŋayi Mawtjitjthu ḻakaraŋala buŋgawawalanydja, yurruna ŋayi marrtjinanydja, gonha'yurrunanydja ŋanya. ");
INSERT INTO gnn_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","33","Bala ŋayi biyapul waṉa‐djarryurruna Garraywalana, dhunupa maḻwurrktja marrtjina gulkthurrunana ḏaḏawyurrunana; yakana biyapulnydja ḻarryurruna guṉḏa wäŋalili, yurru ŋathanydja ga borum malanha liŋguwuynha djarwatkunharana ŋurikiŋiyina wärrkkuŋuna. ");
INSERT INTO gnn_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","35","Märr ŋayi buŋgawayu nhäŋala maḻwurrktja mukthunaranydja, bala biyapul marrtjina yätjthina, romdja ŋayi wuṉḏaŋarrkunharaminayi, ga yaka yana ŋayi djuy'yurruna Yitjuralnhanydja, bitjarra yana liŋgu ŋunhi Garray waŋana Mawtjitjkalaŋukurru dhä‐ŋäthili wal'ŋu. ");
INSERT INTO gnn_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Biyapul Garrayyu djuy'yurruna maṉḏanha Mawtjitjnha ga Yärunnha bitjarra, “Gatju biyapul marrtjiya bala buŋgawawala, liŋgu ŋarra ŋanya ŋunhiyi ŋayaŋu ḏälkuŋala, märr yurru ŋarra biyapulnha wal'ŋu dharrpal rom djäma dhiyala wäŋaŋura, märr yurru bukmakthuna yolŋuyu walalay nhämanydja. ");
INSERT INTO gnn_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Walala yurru yukurra ḻakarama walalaŋgalaŋuwu yumurrku'wuna ga gutharra'mirriŋuwuna walalaŋgu, ḻakaramana walala yurru yukurra ŋunhiyi ŋarrakuŋu djämanydja, ŋunhi ŋarra nhaltjarra djäma Yetjippuyŋunha yolŋunha walalanha, märr yurru nhumanydja marŋgiyirri ŋarraku, ŋunhi ŋarranydja yuwalk yana Garray.” Ga bitjarrayi ŋayi Garrayyu ḻakaraŋalanydja. ");
INSERT INTO gnn_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Yuwalkthi maṉḏa marrtjina, bala waŋananydja nhanukala bitjarrana, “Garraynydja yukurra waŋa bitjan, ‘Nhätha yurru nhe dharraḏakunhamirrinydja nhunapinyay nhe, bala nyilŋ'maranharamirrinydja ŋarrakala. Djuy'yurrana ŋarraku miṯtjinhanydja, walala yurru marrtjina, ga buku‐ŋal'yunna ŋarraku. ");
INSERT INTO gnn_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","6","Ŋuli nhe yurru yakanydja djuy'yun ŋarraku miṯtjinha, ŋarranydja boŋgama guḻku'na miṯtji ḏetjnha djuy'yurru, walala boŋgaŋu wäŋanydja dhuwala nhipala warrpam'nha monyguŋu, ga ḻukina marrtji warrpam'nha nhä marrtji dhika ŋuthan dhiyalami wäŋaŋura, mulmu ŋatha dhika nhä; warrpam'nha ḻuki marrtji djarwatkuŋuna, ga balany'tja boŋguŋu nhumalambala warrpam'nha gungaŋu ḏetjthuna.’” ");
INSERT INTO gnn_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Ga walala ŋuriki buŋgawawunydja djämamirri walala waŋana buŋgawanha bitjarra, “Dhiyaŋunydja gay' ḏarramuyu yukurra marina djäma ŋilimurruŋgu bitjanna liŋgu. Nhätha ŋayi yurru dhuwala ḏaḏawyundja? Nhämirri nhe ŋuli djuy'yurru Yitjuralpuyŋunhanydja yolŋu'‐yulŋunha, marrtjinyamaraŋana walalanha djuy'yurrana, märr yurru walala yukurra buku‐ŋal'yunna walalaŋgalaŋuwu Godkuna, märr yurru walalaŋgala waŋarryunydja ŋuriŋi yaka muka baḏuwaḏuyun dhuwala wäŋa.” ");
INSERT INTO gnn_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Bala ŋayi buŋgawayunydja djuy'yurrunana Mawtjitjkuna ga Yärunguna, ga waŋana bitjarrana, “Nhuma yurru marrtjina, ga buku‐ŋal'yunna nhumalaŋgalaŋuwu Garraywuna Godkuna. Yurru yaka bukmaktja yurru marrtji; nhumapi ga ḻurrkun' märr.” ");
INSERT INTO gnn_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Ga ŋayinydja Mawtjitjtja buku‐wakmaraŋala waŋana bitjarra, “Bukmak yana ŋanapurru yurru ḻaw'yun marrtji, ŋanapurruŋgu yumurrku' ga worru'‐wurruŋu, bukmaknha yana, ga bitjandhi liŋgu ŋanapurru yurru märrama djaw'‐djawyundhi wäyinnhanydja walalanha ŋanapurruŋguway buliki ga bembi ga nanikut. Bukmak ŋanapurru yurru marrtji ḻaw'yun, liŋgu ŋanapurru yurru yukurra buŋgulnha djäma, märr‐ŋal'yunna ŋanapurruŋgalayŋuwu waŋarrwuna Godkuna.” ");
INSERT INTO gnn_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","11","Ga ŋayinydja bäy buŋgawanydja waŋana bitjarra, “Djamarrkuḻiny'tja yurru ga dhäykawurrunydja yaka marrtji. Ŋuli nhumanydja djäl marrtjinyarawu, nhumapi yurru ḏarramuwurru marrtji, ga buku‐ŋal'yun Godkunydja, yurru yaka bukmakthirrinydja yurru marrtji.” Bala ŋayi buŋgawayunydja yänguŋalana Mawtjitjnhanydja ga Yärunnhanydja, yakana ŋayi biyapulnydja waŋana maṉḏanha. ");
INSERT INTO gnn_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Bala Garraynydja waŋana Mawtjitjkala bitjarra, “Goŋ‐garrwarthiya bala garrwarlili, märr yurru ŋuriŋi ḏetjthunydja malaŋuyu warrpam'thuna ŋäkirrmarama monyguma dhuwala wäŋanydja.” ");
INSERT INTO gnn_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","15","Bala Mawtjitjtja waṉa‐garrwarthina goŋ‐wapitja'mirri, bala Garrayyunydja djuy'yurruna dhaŋaŋnha dhika ḏetj, bala walala marrtjina bunananydja, marra‐muk bitjarra, ŋunhala wäŋaŋura Yetjiptja, bala ŋayi ŋuriŋiyi ḏetjthunydja warrpam'nha wäŋa ŋunhi munathany'tja gungaŋala, bala walala marrtjina ḻukanana mulmu, man'tjarr, borum dhika nhä djarwatkuŋalana. ");
INSERT INTO gnn_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Ga yänayi ŋayi buŋgawanydja wäthurruna maṉḏaku Mawtjitjku ga Yärungu, “Waḏutja go,” bitjarra. Bala maṉḏa marrtjinana‐wala, ga ŋunhala ŋayi waŋana maṉḏakala bitjarra, “Ŋayaŋu‐yätjkuŋala ŋarra Garraynha yulŋunydja bay, nhumalaŋgu Waŋarrnha, ga nhumalanhayi. ");
INSERT INTO gnn_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Bäy‐ḻakaraŋa ŋarraku yätjpuynydja ŋi', ga waŋiyana Garraynha dhiyaku buwayakkunharawuna, rakunydhinyaramirriwunydja,” bitjarra. ");
INSERT INTO gnn_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Bala yuwalkthi Mawtjitjthunydja gonha'yurrunana buŋgawanhanydja, bala marrtjinana, ga bukumirriyaŋala Garraynhana. ");
INSERT INTO gnn_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Bala dhunupa Garrayyunydja djuy'yurruna wata dhika ŋutu'na ŋanyana; bala ŋuriŋiyi bo'yurrunana watayunydja, djaw'yurrunana ŋunhi ḏetjnhanydja walalanha, bala guḻwuḻmaraŋala dhikana gapulilina. Yakana ŋula waŋganynha ḏetjnha meṉguŋalanydja. ");
INSERT INTO gnn_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Bala Garrayyunydja buŋgawawunydja biyapul ŋayaŋu‐ḏälkuŋala, liŋgu nhanŋunydja rom ḏälthinana; yakana ŋula ŋayi yurru djuy'yun Yitjuralpuyŋunhanydja miṯtjinha. ");
INSERT INTO gnn_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Bala Garrayyu waŋana Mawtjitjnha bitjarra, “Waṉa‐garrwarthiya djiwarr'lili, bala yurru wäŋanydja dhuwala buku‐ḻiw'marama munhayuna monyguma.” ");
INSERT INTO gnn_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Ga yuwalkthi Mawtjitjtja waṉa‐garrwarthina djiwarr'lili, bala marrtjina munhanydja yupthurruna, bena dhika warumukthinana, ḻiw'maraŋalana ŋunha Yetjiptja, warrpam'nha warumukthina. ");
INSERT INTO gnn_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Yolŋu'‐yulŋunydja yakana ŋula nhänharamina, ga yakana walala dhawaṯthurruna ŋula warraŋullilinydja, liŋgu warumuknha yukurrana djingaryurruna ḻurrkun' walunydja ŋupara. Yurru Yitjuralpuyŋunydja bäpurru' yukurrana nhinana baḏayala'ŋura warray. ");
INSERT INTO gnn_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Bala ŋayi buŋgawanydja wäthurrunana Mawtjitjkunydja, ga waŋana bitjarrana, “Gatju nhuma yurru marrtjiyana yulŋunydja, ga buku‐ŋal'yurrana ŋunhilina ŋanhdharkŋurana wäŋaŋura. Djaw'yurra galki nhumalaŋguway yumurrku'nhanydja, yurru wäyindja nhuma yurru yaka märraŋa, dhiyala bäyma walalanydja yurru.” ");
INSERT INTO gnn_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Ga ŋayi Mawtjitjtja waŋana bitjarra, “Yä‐ä‐äw, dhuwala ŋanapurru yurru mundhurr muka wekama, bathan gurthalili barŋlili wäyinnhanydja. ");
INSERT INTO gnn_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Djaw'‐djawyun ŋanapurru yurru warrpam ŋanapurruŋguway wäyindja malanha, yakana ŋanapurru yurru waŋganynha ŋula gonha'yun dhipala. Bukmak yana ŋanapurru yurru djaw'‐djawyun, märr yurru ŋanapurru buku‐ŋal'yun ŋamathama wal'ŋu yana Godkunydja. Ŋayipi yurru yana ŋanapurruŋgunydja ḻakarama nhä ŋanapurru yurru wekama nhanŋu mundhurr, ŋunhi ŋanapurru yurru bunanydja ŋunhalayi wäŋaŋura.” ");
INSERT INTO gnn_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Yurru buŋgawanydja mukthurruna yana rom‐ḏälthina, bili Garrayyu ŋanya liŋguna gonha'yurrunana; yakana ŋayi djuy'yurruna walalanha dhawaṯmaraŋalanydja. ");
INSERT INTO gnn_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Bala buŋgawayunydja waŋana Mawtjitjnha bitjarra, “Gatjuy, marrtjiyana. Yarrkthurrana ŋarrakalanydja. Yakana ŋarra yurru bulunydja nhuna buku nhäma. Ŋuli nhe biyapulnydja yurru roŋiyirri, ŋarranydja yurru nhuna bumana rakunygumana.” ");
INSERT INTO gnn_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Bala Mawtjitjtja waŋana buku‐wakmaraŋalana, “Ŋe, manymak muka. Yakana nhe yurru ŋarranha buku‐nhäma biyapulnydja.” ");
INSERT INTO gnn_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Ga biyapul ŋayi Garray God waŋana Mawtjitjkala bitjarra, “Waŋganynha biyapul ŋarra yurru djäma dhiyala Yetjip, waŋganynha biyapul yätj rom yurru maḻŋ'thun ŋurukuyi buŋgawawu, ga dhiyaku wäŋawu bukmakku yana Yetjippuyŋu, ga dhurrwaraŋuru ŋuliŋuruyinayi ŋayi yurru djuy'yundja nhumalanha, gukumana yana yurru nhumalanha ŋuliŋuruyi nhanukiyingalay wäŋaŋurunydja warrpam'thuna. ");
INSERT INTO gnn_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Ḻakaraŋa ŋarrakalaŋuwa yolŋu'‐yulŋuwanydja Yitjuralpuyŋuwanydja, ḏarramuwurrumbala ga dhäykawurrumbala, walala yurru marrtji yukurra, ga ŋäŋ'thun marrtji Yetjippuyŋunha yolŋu'‐yulŋunha ŋamakurru'wu malawu girri'wu garwarrwarr'wu, miny'tjimirriwu dhika nhäku malaŋuwu girri'wu mel‐wiḏi'mirriwu,” bitjarra. ");
INSERT INTO gnn_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Ga yuwalkthi ŋayi Garrayyu guŋga'yurrunanydja nhanŋuway yolŋu'‐yulŋunhanydja, bala walala ŋunhi Yetjippuyŋuyunydja yolŋu'‐yulŋuyu bena marrtjina rarr'yurruna walalambala dhaŋaŋnha mirithirrina ḻatju'mirrinydja dhikanydja ŋanya girri' malanha. Ga bitjarrayi liŋgu ŋayi Garrayyunydja garrwarkuŋalana ŋurruŋukuŋalana wal'ŋu ŋanya Mawtjitjnha, bala ŋuriŋi buŋgawawalaŋuyunydja djämamirriyu walalay ga bukmakthu ŋuriŋi yolŋu'‐yulŋuyu ḻakaraŋala ŋanya Mawtjitjnhanydja dharrpalnha ŋayi ŋunhiyi yolŋu Mawtjitjtja. ");
INSERT INTO gnn_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Ga biyapulnydja ŋayina marrtjina Mawtjitjnha nhanukala buŋgawawalana, bala ḻakaraŋala bitjarrana, “Garraynydja waŋana bitjarra gam', ‘Yalalanydja yurru dhika buku‐rangunydja wal'ŋu, ŋarranydja yurru ŋarrapinydja marrtjina yukurra balakurru‐wala Yetjipkurrunydja, ");
INSERT INTO gnn_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","ga bukmak yurru ŋunhiyi maḻamarrmirrinydja yumurrku' Yetjippuyŋu marrtji raku'‐rakunydhirrina. Nhuŋu yurru buŋgawawu gäthu'mirriŋu rakunydhirri, yana liŋgu‐u‐u ŋunhana‐wala ga djämamirriwala maḻamarrmirriwala yumurrku'wala wapthun, ga bitjandhi liŋgu yurru wäyindja mala maḻamarrmirri yana dhawal‐wuyaŋinyara ŋurruŋuwuy raku'‐rakunydhirri. ");
INSERT INTO gnn_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Ga rirrakaynydja yukurra yurru nyä'yunminyaranydja buṯthunna balakurruyi wäŋakurrunydja Yetjipkurru. ");
INSERT INTO gnn_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Yurru ŋarrakunydja yolŋu walala yurru nhina yukurra mäwaya'ŋurana yanana, yakana yurru ŋula waŋganydhu wuŋgandhu walalaŋgala wäŋaŋura gukthun; yakana yurru ŋula waŋgany yolŋu ŋarrakunydja miṯtji ŋayaŋu‐yätjthirri ŋuriŋiyi mariyunydja. Yo, bukmakthuna yurru dharaŋandja ŋunhi ŋarra barrkuwatjkuŋala Yetjippuyŋunha ga Yitjuralpuynha, liŋgu Yetjippuynydja walala yurru nyä'yunmirrina marrtji ŋuriŋiyinayi murrmurryunarayuna marrtjinyarayu, ga ŋarrakunydja miṯtji yurru yolŋu walala yukurra nhina walŋamirri warray dhika wal'ŋu. ");
INSERT INTO gnn_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Walala yurru djämamirrinydja walala nhumalaŋgu marrtji, bala ṉepaḻ‐nyilŋ'thunna ŋarrakalanydja, bala waŋa yurru bitjanna, “Gatjuy yarrkthurrana‐wala ŋanapurruŋgala wäŋaŋurunydja dhipuŋurunydja, bukmakthiyana yana walala.” ’ Ga dhäŋuru ŋuliŋurunydja ŋarra yurru marrtjina yanana‐wala.” Ga bitjarra ŋayi yukurrana Mawtjitjthu ḻakaraŋalanydja nhanbala buŋgawawanydja. Bala ŋayi gonha'yurruna ŋanya buŋgawanhanydja ŋunhi Mawtjitjthu, yurru ŋayi marrtjinanydja ŋaramurryinana manapara. ");
INSERT INTO gnn_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Bala ŋayi Garraynydja waŋana Mawtjitjkala bitjarra, “Ŋunhayi buŋgawanydja nhuŋu yurru yakana mäkiri'‐witjun yukurra, mäkiri' ŋayi yurru dhaḻ'yunmirri yukurra nhokalaŋuŋuru ŋänharaŋurunydja dhärukŋurunydja, märr yurru ŋarra yukurra djäma biyapulnha wal'ŋu ganydjarr‐ḏumurruyu romdhu dhiyala Yetjiptja wäŋaŋura.” ");
INSERT INTO gnn_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Ŋe, maṉḏa Mawtjitjthu ga Yärundhu milkuŋala bukmak ŋunhi ganydjarr ḏilkurrunydja milma buŋgawawala, yurru rom nhanŋunydja wuṉḏaŋarrnha, liŋgu Garrayyunydja ŋanya rom‐ḏälkuŋalana, yakana ŋayi ŋuriŋi buŋgawayunydja Yitjuralnhanydja yolŋunha walalanha djuy'yurruna dhawaṯmaraŋala nhanukiyingalanydja wäŋaŋuru. ");
INSERT INTO gnn_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Yo, ŋunhalaŋga bäyma yana wäŋaŋura Yetjip, Garray waŋana maṉḏakala Mawtjitjkala ga Yärungala, ga bitjarra ŋayi ḻakaraŋalanydja gam'. ");
INSERT INTO gnn_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Dhiyaŋunydja ŋaḻindiyu yurru djingaryun yukurra ŋurruŋuna wal'ŋu, bitjanna bitjan ŋuli ŋurru‐yirr'yun yuṯana dhuŋgarra nhumalaŋgu. ");
INSERT INTO gnn_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","5","Ḻuŋ'maraŋa warrpam'thurra yana yolŋu'‐yulŋunha Yitjuralpuyŋunhanydja, bala ḻakaraŋa walalambala biyakana, ‘Waŋga'‐waŋganydhu nhuma yurru ḏarramuwurruyu märra'‐marrama wäyin malanha bembi nhumalaŋgalaŋuwu malawu, yurru ŋunhiyi bembinydja wäyindja ḻatju' yana wal'ŋu ŋula nhämiriw ḏarramu, yuṯa wal'ŋu yana waŋganymirri dhuŋgarramirri. ");
INSERT INTO gnn_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Nhuma yurru märramanydja, bala nhäma'‐nhamana yukurra ŋula nhämunha' ḻurrkun' walu, ga munhakunydja ŋunhi ŋayi yurru Garray waŋa bitjan, nhuma ḏarramuwurruyu waŋga'‐waŋganydhu yurru buŋa marrtjiya ŋunhiyi wäyinnhanydja, mayaŋ' gulkthu'‐wulkthurra, bala dhiṯthurrana gulaŋdja banikin'lilina malaŋulili. ");
INSERT INTO gnn_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Ga ŋuriŋi gulaŋdhunydja nhuma yurru ŋämiṉna wäŋana dhurrwarana, gali' maṉḏanha ga garrwar buku ŋunhi dhurrwara. ");
INSERT INTO gnn_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","9","Ga bukmak nhumalaŋgu yurru ŋunhi gurruṯu'mirrinydja ŋunhilina warrpam'nha wäŋaŋurana djinawa'na, bala nhuma yurru ŋuriŋiyinydja munhaku ḻukana yukurra ŋanaktja ŋunhiyi wäyinnha. Nhuma yurru bathandja ŋunhiyi ḻirrwi'lili, ga ḻukiya bukmakthu yana nhuma warrpam'thurra yana dhawar'maraŋa. ");
INSERT INTO gnn_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Ga ŋunhi yurru bäythinyarawuynydja, nhumanydja yurru dhuŋgur'yurrana yana, gurthalilina djalkthurra, yakana gurrunharra goḏarr'wunydja. ");
INSERT INTO gnn_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Ga bitjan yurru nhuma ŋunhiyi ḻukanydja gam'. Bukmak nhuma yurru warrpam dhaṯthunmirri yukurra ŋamathanharamirri yana, girri'‐ŋamathirri marrtjinyarawuna, djalkirilili dhapathuŋ, ga ŋarambiya'yunydja nhe yurru gäma dharpa gaṉdji'yunarawu. Ga ḻukanydja nhuma yurru waḏutja yana, liŋgu nhuma yurru yukurra ŋunhi ḻukanydja märr‐ŋal'yun muka manapan ŋarraku, Garraywu nhumalaŋgalaŋuwu, ŋunhi ŋarra yurru ŋurrwu'yunmarama nhumalanha, walŋakuma ŋunhiyinydja bitjan yurru.’” Ga bitjarra ŋayi Garray waŋananydja yukurrana. ");
INSERT INTO gnn_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Ga biyapul ŋayi Garrayyu ḻakaraŋala Mawtjitjkala bitjarra, “Ŋulinyaramirriyuyi munhayunydja ŋarra yurru marrtjina yukurra ḻäy‐yuḻkmaramana dhuwala wäŋa Yetjiptja, ga bukmak yurru ŋunhi Yetjippuyŋunydja djamarrkuḻi' maḻamarrmirrinydja murrmurryunna marrtji, yolŋu'‐yulŋu ga wäyin walala. Ŋarra yurru bumanydja, baḏuwaḏuyunna marrtji warrpam'thunna nhä malanha ŋunhi Yetjippuyŋuyu walalay ŋuli yukurra ḻakarama waŋarrkuma, liŋgu ŋarrapi dhuwala waŋgany yana Garray Godtja. ");
INSERT INTO gnn_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Yurru maŋguny'tja ŋunhiyi dhärrana yukurra yurru bitjan yiŋarray'nha ŋunhili dhurrwaraŋura nhumalaŋgala buṉbuŋurana, nhämanydja ŋarra yurru ŋunhiyi maŋgu', bala ŋarra yurru yana nhumalanha ḻäy‐yuḻkmaramana, ŋäkirrmaramana gunganhamirriyamana. Yakana yurru ŋula nhäyu rerriyu nhumalanha ŋayathamanydja, ŋunhi ŋarra yurru bumanydja marrtji bala Yetjipkurrunydja.” Bitjarrana ŋayi Garray waŋananydja. ");
INSERT INTO gnn_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Ga bitjarrayi liŋgu ŋayi waŋana Mawtjitjnhanydja, “Yo, gupaḏalkuma yana nhuma yurru guyaŋirrinydja yukurra dhuwalayi Ḻäy‐yuḻkmaranharamirrinydja walu. Bitjanna liŋgu dhuŋgarra‐watjirri nhuma yurru waŋgany‐manapanmirrinydja nhumalaŋgu djamarrkuḻiny'tja, ga guyaŋirri dhuwalayina walu ŋunhi ŋarra walŋakuŋala nhumalanha rakunyŋuru, ŋunhi nhumalanha gungaŋala ŋuriŋi maŋgu'yu wäyingala. ");
INSERT INTO gnn_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Ga ŋulinyaramirriyu ŋunhi nhuma yurru yukurra guyaŋirri dhuwalayi rom, nhuma yurru ḻuka yukurra ŋathanydja ruwaŋga'miriw yana. Ŋurruŋunydja nhuma yurru Yitjuralpuyŋuyunydja bukmakthu yana yäkthun yukurra ḏarrtjalkkuma nhumalaŋguway wäŋanydja, djalkthurrana marrtjiya ŋunhiyi ŋatha‐ruwaŋga'kunharawuynydja. Ŋuli ŋayi yurru ŋula yolthu ḻuka ruwaŋga'kunharawuymirrinydja ŋatha ŋulinyaramirriyu, ŋayinydja yurru ŋunhiyinydja yakana biyapul ŋarrakunydja yolŋu. ");
INSERT INTO gnn_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","18","Yo, nhuma yurru waŋgany‐manapanmirri yukurra yulŋunydja bukmak yana, bala buku‐ŋal'yunna yurru ŋarraku. Nhuma yurru gananna wiripunydja malanha djäma, bala mulkiyanydja ŋayathaŋanydja dhuwalayina rom, guyaŋiya balayi roŋiyiya ŋunhiyi walu ŋunhi ŋarra nhumalanha dhawaṯmaraŋala ŋuliŋuruyi Yetjipŋuru wäŋaŋuru, ŋuliŋuruyi garrpiṉminyaraŋuru romŋuru. ");
INSERT INTO gnn_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","20","Yo, ŋuriŋiyinydjayi waluyu nhuma yurru yukurra ḻuka ŋatha ruwaŋga'miriw yana, yakana yurru ŋula waŋganydhu yolŋuyu ḻuka ruwaŋga'kunharamirrinydja ŋatha.” Ga bitjarrana ŋayi Garray waŋananyda Mawtjitjkala. ");
INSERT INTO gnn_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Bala Mawtjitjtja wäthurruna waŋana, buku‐ḻuŋ'maraŋala ŋurru'‐ŋurruŋunha Yitjuralpuyŋunha, bala ḻakaraŋalana walalambala bitjarrana gam'. “Bukmakthu bäpa'mirriŋuyu walalay, nhuma yurru märra'‐marrama yothu wäyin yäku läm, waŋga'‐waŋgany wäŋawu malanyŋuwu nhumalaŋguway nhuma, bala buŋa'‐buŋanydja nhuma yurru wäyindja, ga gulaŋdja märraŋa rupa'lili ḏolaŋlili. ");
INSERT INTO gnn_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Bala nhuma yurru märraŋanydja mäṯ, bala guḻwuḻmaraŋa gulaŋlilina, bala biḏi'‐biḏiyurrana dhurrwara bala' malanha nhumalaŋguway, garrwarkurru buḏapmaraŋa, ga gali'kurru maṉḏaŋukurru gulaŋdhu biḏi'yurra. Bala gärri'‐garriyana nhuma yurru wäŋalilinydja malaŋulili, nhepi ga nhuŋu yumurrku', ga nhiniyanydja yukirriya mukthurra ŋunhala bili djinawa' yana, ga yaka dhawaṯthurranydja, yana liŋgu ga goḏarr boŋgama. ");
INSERT INTO gnn_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Liŋgu Garray marrtji yurru yukurra ḻiw'marama Yetjipkurru, buma marrtji yurru Yetjippuyŋunha yolŋu'‐yulŋunha. Marrtjinydja ŋayi yukurra yurru bala'lili ga bala'lili, nhäma marrtji yurru, ga ŋunhi ŋayi yurru nhäma bala' dhurrwara ŋämiṉara gulaŋmirrinydja, ŋayi yurru Garrayyu ŋapa‐ŋäkirrmarama, ŋurrwu'yunmarama ŋunhiyinydja bala', märr yurru walŋa‐wuḻktja yakana gärri ga buma nhumalanhanydja. ");
INSERT INTO gnn_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“Ga biyaka bili dhuŋgarra‐watjiya yukirriya roŋiyiyanydja bala guyaŋiya yurru, nhumapi ga nhumalaŋgala gäthu'mirriŋuyu walalay. ");
INSERT INTO gnn_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Ga ŋunhi nhuma boŋguŋu gärri ŋunhamalanydja wäŋalili ŋunhi ŋayi yurru Garrayyu wekama nhumalaŋgu, ŋunhi ŋayi nhumalanha dhawu'mirriyaŋala, nhumanydja yurru biyakana liŋguna guyaŋiyanydja yukirriya dhuwalayi, ga djäma dhuḏakthurra dhuŋgarra‐watjiyana yana. ");
INSERT INTO gnn_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Ga ŋunhi walala yurru yumurrku'yunydja dhä‐wirrka'yun nhumalanha bitjandja, ‘Nhä dhuwalanydja rom mayali'? Nhäku ŋilimurru yukurra bitjandja ŋuli?’ bitjanna yurru, ");
INSERT INTO gnn_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","bala nhumanydja yurru biyaka waŋiya yumurrku'wunydja ḻakaraŋa. ‘Dhuwalayinydja Garraywuna wal'ŋu Ḻäy‐yuḻkmaranhamirrinydja Rom. Ŋilimurru yukurra dhuwala bitjandhinydja buma wäyinnhanydja. Garraywuna buku‐ŋal'yunarawu, liŋgu dhuwalana ŋilimurru ŋuli yukurra guyaŋirri dhä‐ŋäthiliŋuwuy ŋurukuy, ŋunhi ŋayi Garrayyu djuḻkmaraŋala ŋurrwu'yunmaraŋala ŋilimurrunha Yitjuralnha ŋunhala Yetjip. Ŋayi bumara rakunyguŋala Yetjippuyŋunhanydja yolŋu'‐yulŋunha, yurru ŋilimurrunhanydja ŋayi walŋakuŋala warray.’ Bitjandhi nhuma yurru ḻakaramanydja nhumalaŋgalayŋuwu yumurrku'wunydja, marŋgikuŋanydja walalanha.” Yo, bitjarra ŋayi Mawtjitjthu ḻakaraŋalanydja, bala walala yolŋu'‐yulŋunydja buku‐nyilŋ'thurrunana, bala buku‐ŋal'yurruna Garraywuna. ");
INSERT INTO gnn_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Ga ŋuliŋurunydja dhurrwaraŋuru walala yolŋu'‐yulŋu Yitjuralpuyŋunydja ḻaw'yurruna balayi walalaŋgiyingalay wäŋalilina malanyŋulili, ga dhunupa djämana‐marrtjina ŋunhi nhaltjarra Garrayyu ḻakaraŋala maṉḏakala Mawtjitjpa ga Yärunba. Walala märra'‐marraŋalanydja marrtjina yothu wal'ŋu wäyin läm yuṯamirri yana dhika ḻatju'mirri, ga ŋuriŋinydja waluyu ŋunhi ŋayi Garrayyu ḻakaraŋala, walala bumarana wäyinnhanydja malaŋunha, bala gulaŋdhuna biḏi'‐biḏiyurruna balany'tja dhurrwaranydja malanha, bala walala bukmakthinana gärrinanydja walalaŋgiyingala bala'lilinydja miṯtjiŋulili, bala ḻukanana yukurrana ŋunhiyi wäyindja rumbalnydja girri'‐ŋamathina gananarawuna gupaḏalkunharawuna Yetjippuyŋunydja wäŋawu. ");
INSERT INTO gnn_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Ga ŋulinyaramirriyu liŋgu munhaku, buku‐ranguna dhika djeḏana, bala yana Garraynydja marrtjinana yukurrana ŋuliwitjarrana wäŋakurrunydja, bala bukmakpana Yetjippuynydja gäthu'mirriŋu walala maḻamarrmirrinydja murrmurryurrunana marrtjina, ŋulaŋuru bili buŋgawawala, nhanŋu yothu, yana liŋgu‐u‐u ga gali'wuywala wapthurruna, ga bitjarrayi bili bulikiny'tja walala maḻamarrmirri rakunydhinayi marrtjina. ");
INSERT INTO gnn_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Bala ŋayi buŋgawanydja gaŋgathina munhaku yana, bala nyä'yurrunana yukurrana nhanukalayŋuwu gäthu'mirriŋuwuna, ga djämamirri walala nhanŋu bitjarrayi bili nyä'yunmina walalaŋgalayŋuwunydja gäthu'mirriŋuwu walalaŋgu, ga bukmaknha Yetjippuyŋu nyä'yunminanydja marrtjina, liŋgu bukmakŋurana bala'ŋura maḻamarrmirrinydja gäthu'mirriŋu walala murrmurryurrunana, yakana ŋula waŋganyŋura bala'ŋura ŋayi djuḻkmaraŋalanydja. ");
INSERT INTO gnn_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Ŋe, ŋuriŋiyi yana bili munhaku, ŋayi buŋgawanydja ŋunhiyi wäthurruna maṉḏaku Mawtjitjku ga Yärungu, bala ŋayi waŋana maṉḏakala bitjarra, “Gatjuy ḻaw'yurrana walala. Yarrkthurrana dhipuŋurunydja wäŋaŋuru, nhuma maṉḏa ga yolŋu walala bukmak Yitjuralpuyŋu. Gatjaḻa ḻaw'yurrana, marrtjiyana walala ga buku‐ŋal'yurrana Garraywuna, biyakayina bitjarra nhuma yukurrana ḻakaraŋala. ");
INSERT INTO gnn_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Djaw'‐djawyurrana bukmaknha nhumalambalayi wäyinnhanydja walalanha, bala marrtjiyana. Ga biyakayi bukumirriyaŋa ŋarrakunydja.” ");
INSERT INTO gnn_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Ga bitjarrayi bili walalanydja yolŋu'‐yulŋuyu Yetjippuyŋuyunydja gukuŋalayi, djuy'yurrunana walalanha, “Waḏutja dhawa‐yawaṯthurrana gatjuy, gundupuŋana. Ŋanapurru ŋuli bukmaknha murrmurryurru,” bitjarra. ");
INSERT INTO gnn_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Bala walala Yitjuralpuyŋunydja yolŋu'‐yulŋu ḻaw'yurranana, galkarana girriny'tja walalaŋguway ḻaw'‐ḻawmaraŋala ḻambarrlilina, ga bitjarrayi liŋgu walala märraŋalayi ŋunhiyi ŋatha ruwaŋga'kunhamiriwnydja, yurru ḏikuna, bala yana wäŋgaŋalana ŋuriŋi yana liŋgu munhaku. ");
INSERT INTO gnn_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Yo, dhä‐ŋäthili muka yana, ŋayi Mawtjitjthu waŋananydja Yitjuralpuyŋunhanydja yolŋu'‐yulŋunha, walala yurru marrtji Yetjippuyŋuwala yolŋu'‐yulŋuwala, gombu'‐gumbunharawu girri'wu balanyarawunydja gam', bulayiwu garwarrwarr'wu ga girriŋgirriŋ'ku, ga wiripuŋuwu girri'wu malaŋuwu, ḻatju'mirriwu wal'ŋu dhika yana girri'wu. ");
INSERT INTO gnn_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Walala Yitjuralpuyŋunydja marrtjina, bala gombu'‐gumbuŋalana girriny'tja, bala walalanydja Yetjippuyŋuyunydja waḏutjana marrtjina rarr'yurrunanydja, liŋgu Garrayyu walalanha ŋayaŋu‐ḻapmaraŋala, bala walala wuyurrunana wirrkina walalaŋgu. Yo, ŋunhi walala ŋulinyaramirriyu munhaku dhawaṯthurrunanydja yukurrana ŋulaŋuru Yetjipŋurunydja, walala gutjkutjthurrunanydja ḻatju'mirrina girriny'tja dhikana, ŋunhi walala galkara yukurrana Yetjippuyŋuwuŋu yolŋu'‐yulŋuwuŋu dhä‐ŋäthili wal'ŋu. ");
INSERT INTO gnn_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Yo, bukmakthinana Yitjuralpuyŋunydja ḻaw'yurruna, bala marrtjinana dhawaṯthurrunana, gonha'yurrunana Yetjippuynydja wäŋa ŋuriŋi yana liŋgu munhaku ŋunhi ŋayi Garrayyu walalanha ŋurrwu'yunmaraŋala. Marrtjinanydja walala yukurrana‐a‐a, yana liŋgu‐u‐u wäŋa marrtjina mulkana yäku Djakutpuy, ga ŋunhalayina walala gulyurrunanydja, guḻku'na dhika yolŋu'‐yulŋunydja, bena mala ŋula nhämunha'na, ga balanyara yana liŋgu biyapulnha dhaŋaŋnha dhäykawurrunydja ga yumurrkuny'tja miṯtji. ");
INSERT INTO gnn_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Ga bitjarrayi bili wäyindja walala bukmak yana wunybir'yurruna, bulikiny'tja ga lämdja guḻku'na dhikana dhaŋaŋnha. ");
INSERT INTO gnn_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Ga ŋunhalayina wäŋaŋura ŋunhi walala gulyurruna, bala walala batharana yukurrana ŋathanydja, yurru ruwaŋga'miriw ŋunhiyi ŋathanydja, liŋgu walalanha gukuŋala ŋunhi waḏutja yana ŋuliŋuruyi wäŋaŋuru Yetjipŋurunydja. ");
INSERT INTO gnn_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Yo, walala Yitjuralpuyŋunydja yukurrana nhinana ŋunhala Yetjiptja weyinnha dhikana, dhuŋgarranydja‐ŋupara bo‐wandrut ga dhaytina (430‐na), yurruna walala ŋunhi dhawaṯthurrunanydja marrtjinanydja‐wala. ");
INSERT INTO gnn_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Ŋe. Walala Yitjuralpuyŋuyunydja yolŋu'‐yulŋuyu yana märr‐yuwalkthina märraŋala dhäruktja ŋunhi nhaltjarra Garrayyu ḻakaraŋala maṉḏapala Mawtjitjpa ga Yärunba, ");
INSERT INTO gnn_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","ga ŋuriŋi yana liŋgu munhaku Garrayyu gäŋala dhawaṯthunmaraŋalana Yitjuralpuyŋunhanydja yolŋu'‐yulŋunha, yarrkthunmaraŋalana ŋulaŋuru wäŋaŋuru Yetjipŋurunydja, guḻku'na bena yolŋu'‐yulŋu miṯtjinydja. ");
INSERT INTO gnn_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Bala Garray waŋana Mawtjitjkala bitjarra gam', ");
INSERT INTO gnn_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Ŋarrakunydja nhe yurru gulk‐gulkthurra barrkuwatjkuŋa yolŋu'‐yulŋunha maḻamarrmirrinha yana, ga wäyinnha walalanha maḻamarrmirrinha, liŋgu bukmak yurru maḻamarrmirrinydja ḏarramuwurru ŋarrakuwaynha yana, bitjanna liŋguna yurru weyinŋumirrina.” ");
INSERT INTO gnn_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","4","Bala ŋayi Mawtjitjthunydja ḻakaraŋalana yolŋu'‐yulŋuwalanydja bitjarrana, “Yaka meṉguŋa dhuwalayinydja walu ŋunhi nhuma dhawaṯthurruna ŋulaŋuru Yetjipŋuru. Guyaŋiya ŋunhiyi ŋunhi nhuma yukurrana garrpiṉara nhinana ŋonuŋdhu ŋuriŋi romdhu, yurru ŋayi Godthunydja nhumalanha ŋuliŋuruyi dhawaṯmaraŋalana nhanukiyingalana ŋayi wal'ŋu yana ganydjarryu. Ga ŋunhi nhuma yurru waŋgany‐manapanmirri ḻuŋ'maranharamirri guyaŋinyarawunydja, nhuma yurru ḻukanydja yukurra ruwaŋga'miriw ŋathanydja yana. ");
INSERT INTO gnn_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","7","Nhuma yurru mukthun yana‐wala marrtjina yukurra dhipuŋuru wäŋaŋurunydja, bala ŋayi yurru Garrayyunydja Godthunydja gämana nhumalanha ŋunhamalayina wäŋalili ŋunhi ŋayi dhawu'mirriyaŋala nhumalaŋgalaŋuwala märi'muwala. Ŋunhayinydjayi wäŋa ḻatju' dhika wal'ŋu, ŋatha guḻku'mirri ga guku guḻku'mirri, ga wäŋanydja ŋunhiyi yurru nhumalaŋguwaynha gupaḏalnha‐wala, bäy ŋunhi yukurra wiripunydja miṯtji bäpurru' nhina ŋunhiliyi wäŋaŋura. Ga ŋunhi nhuma yurru gulŋiyirrinydja ŋunhiwalayi wäŋalili, nhumanydja yurru ŋayathamana yana dhuwalayi romdja yukurra, ga djämanydja yurru bitjanna liŋgu dhuŋgarra‐ŋupanna. ");
INSERT INTO gnn_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","10","Bala nhuma yurru ḻakarama nhumalaŋgalaŋuwu yumurrku'wunydja, marŋgikuŋanydja biyaka gam'. ‘Garrayyu ŋarranha walŋakuŋalanydja, ŋayi märraŋala ŋilimurrunhanydja dhawaṯmaraŋala Yetjipŋuru nhanukalay ŋayi yana ŋuriŋi ganydjarryu wal'ŋu, ga dhiyakuna märrwu ŋunhi ŋilimurru ŋuli djäma yukurra bitjandhinydja dhuŋgarra‐ŋupan, märr yurru ŋilimurru guyaŋirrina yukurra bitjanna liŋguna gupaḏalnha‐wala, ga yakana buku‐dhumukthirrinydja meṉgumanydja.’ ");
INSERT INTO gnn_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","13","“Yo, yuwalk yana Garrayyu yurru gämanydja nhumalanha ŋunhimalayi wäŋalilinydja, ŋunhi walala yukurra Gaynanbuyŋu nhina ŋunhiliyi. Ŋunhiyinydja yurru nhumalaŋgu yana wäŋa, liŋgu Garrayyu dhawu'‐nherrara ŋunhiyinydja wäŋa nhumalaŋgalaŋuwala märi'muwala walalaŋgala. Ga ŋunhi nhuma yurru gulŋiyirrinydja ŋunhimalayi wäŋalilinydja, nhuma yurru ganaŋ'maraŋa maḻamarrnhanydja ḏarramunha yothu'nha, ŋayinydja yurru ŋunhiyi nhanŋuway yana Godku yolŋunydja, yurru nhenydja buku‐ruŋinyamarama bäyim yolŋunydja ŋanya, märr yurru ŋayi nhina walŋathirri. Ga bitjandhi yana liŋgu ŋurruŋu maḻamarr wäyindja yurru nhanŋuway yana Godku, nhuma yurru wekama bathan ŋunhiyinydja wäyin nhanŋuwuy Garraywu. ");
INSERT INTO gnn_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Ga ŋunhi yurru nhokala gäthu'mirriŋuyu dhä‐wirrka'yun nhuna bitjandja ŋula, ‘Nhä dhuwalanydja rom mayali'?’ Ga nhenydja yurru ḻakaraŋa nhanŋu biyaka gam', ‘Garrayyu ŋunhi maḻamarrmirrinhanydja walalanha walŋakuŋala warray, ŋurrwu'yunmaraŋala gulaŋdhu warray ŋuriŋiyi, ŋulinyaramirriyu ŋunhi ŋayi Garrayyu ŋilimurrunha dhawaṯmaraŋala ŋulaŋuru Yetjipŋuru, ŋunhi ŋilimurru nhinana yukurrana ḏirrwiḏirrwiŋura walalaŋgala ŋäthili. Ŋayi dhawaṯthunmaraŋalanydja ŋilimurrunha nhanukalay ganydjarryu wuṉḏaŋarryu, ŋutu'yuna ganydjarryu. ");
INSERT INTO gnn_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Ŋunhi ŋayi yukurrana Yetjippuyŋuyu buŋgawayu baṯ bitjarra mulkana ŋilimurrunha, ga yakana ŋayi ŋilimurrunha ŋula djuy'yurrunanydja, bala Garrayyunydja marrtjina bumara rakunyguŋala warray Yetjippuyŋunhanydja maḻamarrmirrinha ḏarramuwurrunha yolŋu'‐yulŋunha ga wäyinnha walalanha, walala bukmakthinana murrmurryurrunanydja, yurru ŋayi walŋakuŋalanydja Yitjuralpuyŋunha warray maḻamarrmirrinha, yaka warray murrmurryurruna walalanydja. Yo, ŋurru'‐ŋurruŋunydja ŋunhi maḻamarrmirri yolŋu'‐yulŋu ga wäyin walala nhanŋuwaynydja yana Garraywuna, ga dhiyakuna ŋayaŋuwu ŋarra ŋuli Godkuna wekama ŋunhiyi ŋurruŋunhanydja wäyinnha maḻamarrnhanydja, ga ŋurruŋunhanydja gäthu'mirriŋunha maḻamarrnhanydja ŋarra ŋuli buku‐ruŋinyamarama warray bäyim, liŋgu ŋayi ŋunhi Godkuna nhanŋuwaynha yana. ");
INSERT INTO gnn_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Ga dhiyaŋuyi romdhu ŋilimurru yukurra yurru bitjanna liŋgu guyaŋirrina Garraynhanydja, ŋunhi ŋayipi ŋilimurrunha dhawaṯmaraŋalanydja ŋulaŋuru Yetjipŋurunydja, nhanukalaynha ŋayi ŋutu'yuna ganydjarryu.’” ");
INSERT INTO gnn_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Yo. Ŋunhi ŋayi buŋgawayu gukuŋalanydja Yitjuralnha ŋulaŋuru Yetjipŋuru, bala ŋayi Garrayyu yukurrana gäŋalanydja walalanha wäŋalili ŋunhimalana ŋunhi ŋayi ŋäthili dhawu'mirriyaŋala nherrara walalaŋguway yana, yurru yakana ŋayi gäŋala walalanha ŋuliyinydja ŋunhi gurriri marrtji dhukarr bala ŋorra, ŋunhiyinydja walala bini marrtjinya Bilitjiyawuykurrunydja wäŋakurru. Ŋayi Garraynydja waŋana bitjarra, “Yaka walala yurru marrtji balakurrunydja‐wala. Ŋuli walala gonhana ŋula miriŋunhana nhäŋu, walalanydja mak ŋuli gundupuŋu roŋi'‐ruŋiyina balayi Yetjipliliyi.” ");
INSERT INTO gnn_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Bala Garrayyu gäŋalanydja walalanha wiripuŋukurruna dhukarrkurru, yolŋumiriwkurruna yana wäŋakurru. Yo, yolŋu'‐yulŋuyu ŋuriŋi Yitjuralpuyŋuyunydja gutjkutjurruna mariwuy gara ŋunhi walala gonha'yurruna ŋunha Yetjippuynydja. ");
INSERT INTO gnn_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Ga bitjarrayi liŋgu ŋayi Mawtjitjthu gäŋalayi Djotjipnhanydja ŋaraka, liŋgu ŋayi Djotjip dhä‐ŋäthiliŋga waŋananydja yukurrana, yurruna ŋayi rakunydhina; ŋayi ḻakaraŋala Yitjuralpuyŋuwala bitjarra gam', “Garrayyu yurru nhumalanha withiyandja, dhawaṯmaramanydja dhipuŋuru, ga ŋunhi yurru nhuma ganandja dhuwala Yetjiptja wäŋa, ga gäŋayi ŋarranha ŋarakanydja dhipuŋurunydja wäŋaŋuru.” Bala yuwalkthi Mawtjitjthu märraŋala Djotjipnha ŋarakanydja, bala djaw'yurrunana. ");
INSERT INTO gnn_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Yo, baḏak walala yukurrana marrtjinaŋga yana bala‐a‐a, yana liŋgu ŋunhala gandarrŋura walala yuku'‐yukurrana galki ŋunhili wiraŋŋura wäŋaŋura, ");
INSERT INTO gnn_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","ga bitjana liŋgu ŋayipi Garrayyunydja ŋuli yukurranha walalanha ŋurru‐warryuna. Ŋayi nherrara maŋan ŋurrulilinydja walalaŋgu, ga ŋayinydja ŋunhilimiyi maŋanŋuranydja ŋurru‐warryuna walalanha marrtjinya ŋuli walu‐ŋupana ga munha‐ŋupana, liŋgu munhakunydja ŋuli ŋunhi waŋupini gurthayinyana, djarraṯawun'nha walalaŋgu wekanha, bala walala ŋuli yukurranha marrtjinyana walupuy ga munhaku. ");
INSERT INTO gnn_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Yo, maŋandja ŋunhiyi yakana ŋula yarrkthuna ŋurikala yolŋu'‐yulŋuwalanydja; bitjanana liŋguna mel‐warryunana walalanha yukurranha ŋuli. ");
INSERT INTO gnn_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","2","Bala Garray waŋana Mawtjitjkala bitjarra, “Ma', ḻaw'yurrana walala ga marrtjiyana. Mukthurra yana marrtjiya yukirriya walala, ga yana liŋgu ga wäŋa yurru ŋayi gilitjirri ŋunhiyi raŋi, ga ŋunhilina nhuma yurru ŋorra'‐ŋurranydja, ");
INSERT INTO gnn_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","4","liŋgu ŋayi yurru buŋgawanydja waŋa bitjanna, ‘Way, ŋunhanydja walala yurru gaṯthunna ŋunhala ŋanhdharkŋuranydja, yakana walala yurru winya'‐winyayun ŋunha ŋarrakalanydja goŋŋuru.’ Bitjanna ŋayi yurru ŋunhi buŋgawanydja waŋa, liŋgu nhanŋu ŋayaŋunydja ŋarra ŋunhi ḏälkuŋalana. Bala ŋayi yurru nhumalanha goyurr‐ŋupanna, liŋgu guyaŋirri ŋayi yukurra, yanapi ŋayi yurru ŋayathama, bala roŋiyinyamaramana nhumalanha. Yurru ŋarranydja yurru ŋurikiyi djuḻkthun warray, nhanŋu buŋgawawu ga nhanukalaŋuwu miṯtjiwu. Bala walala yurru bukmakthirrina ŋunhalayi Yetjiptja marŋgiyirri ŋunhi ŋarranydja waŋarrnha wal'ŋu Garray Godnha.” Ga bitjarra ŋayi Garraynydja waŋana. Bala walala yuwalkthi marrtjinana‐a‐a, ga ŋunhiliyina walala wäŋaraŋalanydja raŋiŋurana, galki mayaŋ'ŋura yäkuŋura Miku Gapuŋurana. ");
INSERT INTO gnn_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Ŋe. Ŋunhi ŋayi buŋgawayu Yetjippuyŋuyu ŋäkulanydja Yitjuralpuyŋunha liŋguwuynha marrtjinyarana, ga biyapul ŋayinydja marrtjina djambi ŋanyapinyay ŋayi ḻiyanydja, ga nhanbala djämamirri walala bitjarrayi liŋgu djinydjim, bala walala waŋana bitjarrana, “Nhäku ŋilimurru walalanha ŋunha djuy'yurrunanydja? Yolthuna ŋilimurruŋgu yurru djäma dhiyalanydja?” ");
INSERT INTO gnn_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","7","Bala ŋayi djuy'yurruna nhanbalay ŋayi miṯtjinha miriŋunhana ḻundu‐ŋupanarawuna Yitjuralpuyŋuwunydja, yarraman'thuna walalay warryu'‐warryurruna guḻku'na dhaŋaŋnha dhikana miriŋu ḏiltji'yurruna marrtjina, ");
INSERT INTO gnn_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","liŋgu Garrayyu rom‐ḏälkuŋalayi ŋanya ŋunhi buŋgawanhanydja ŋunhalanydja bäyma Yetjiptja. Ḻundu‐ŋuparana walala ŋuriŋi Yetjippuyŋuyunydja, ");
INSERT INTO gnn_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","bala maḻŋ'maraŋalanydja walalanha ŋunhimalayi warray wäŋalili, ŋunhi walala yukurrana wäŋaraŋala galki gapuŋura mayaŋ'ŋura. ");
INSERT INTO gnn_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Walala Yitjuralpuyŋuyunydja dharr‐way nhäŋalana, walala nhinana gundupuŋala lili, bala walala barrarinanydja wirrkina dhika walalambala, yatjunminana yukurrana Garraywalana märrliliyaŋala guŋga'yunarawuna. ");
INSERT INTO gnn_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Bala walala waŋana ŋarrtjurrunana Mawtjitjnhanydja, “Nhäku nhe yawungu ŋanapurrunha garr'yun ŋulaŋuru Yetjipŋurunydja? Nhe ḏukṯuk ŋanapurruŋgu, ŋanapurru yurru murrmurryunna dhiyala ŋanhdharkŋurana wäŋaŋura? ");
INSERT INTO gnn_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Ŋunhala Yetjiptja ŋanapurru liŋgu muka waŋana nhokala, nhe bini gonha'yuna muka ŋanapurrunha; ŋanapurru bini ŋunhalaŋga bäyma nhinanha Yetjip muka, ga djäma bini Yetjippuyŋuwuŋga. Liŋgu ŋunhanydja Yetjippuynydja ḻatju'na wäŋa; ŋanapurru bini ŋunhalaŋga bäyma djäma yukurranha, märr ŋanapurru yakaŋga murrmurryuna dhiyala ŋanhdharkŋuranydja wäŋaŋura.” ");
INSERT INTO gnn_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Ŋayi Mawtjitjtja waŋana buku‐wakmaraŋala bitjarra, “Yaka nhuma barrariya. Yana djingaryurra walala dharraḏayiya, ŋoy‐ḏälthiya yana, bala Garrayyu yurru ŋilimurrunha walŋakumana. Yo, gäthuranydja nhuma yurru nhämana ŋanya djämawuynha, nhaltjan ŋayi yurru djäma nhumalaŋgu. Nhämanydja nhuma yukurra ŋunha Yetjippuyŋunhanydja, walala marrtji yukurra lili, yurru Garrayyunydja nhumalaŋgala miriŋunhanydja yurru bumana; yakana nhuma bulunydja yurru walalanha nhäma. ");
INSERT INTO gnn_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Nhumanydja yana djingaryurra yukirriya mukthurra, ŋoy‐ḏälthiya yana, liŋgu Garraynydja ŋunha ŋilimurruŋgala warray gali'ŋura, ŋayipina yurru baḏuwaḏuyun warrpam'thuna walalanha.” ");
INSERT INTO gnn_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Bala ŋayi Garraynydja waŋana Mawtjitjkalana, “Nhäku nhuma marrtji wäthunmirri ŋarrakunydja? Ma' waŋiya Yitjuralpuyŋunha, walala yurru marrtjina‐wala yana. ");
INSERT INTO gnn_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Ma' garrwarkuŋana dhuwali wapitjany'tja, ga dhunupamirriyaŋa gapu, bala yurru gapunydja gulkthunna, märr yurru yolŋu'‐yulŋu Yitjuralpuyŋunydja marrtji buḏapthunna yukurra balakurruna‐wala ŋunhamala ḻaypalilinydja, nhuma yurru buḏapthundja yukurra baṉḏany'kurruna. ");
INSERT INTO gnn_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Yo, ŋarra yukurra dhuwala rom‐ḏälkuma Yetjippuyŋuwunydja yolŋu'‐yulŋuwu ŋunhi, bala walala yurru ŋupandja nhumalanha, ga ŋarranydja yurru walalanha buwayakkuma warray, buŋgawanha ga nhanbala miṯtjinha miriŋunha, ga nhanbala yarraman'nha walalanha. ");
INSERT INTO gnn_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Walala yurru Yetjippuyŋuyunydja nhämana, bala marŋgithirrina ŋarraku, liŋgu ŋarra dhuwala Garray Godtja.” ");
INSERT INTO gnn_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","20","Bala ŋunhi djiwarr'wuy watjarr‐mulkanharamirrinydja Godkuŋu ŋunhi ŋayi yukurrana mel‐warryurruna walalanha, giṯthurrunanydja ŋayi ḻundulilina walalaŋgala, ga bitjarrayi bili waŋupininy'tja giṯthurrunayi ga ḻunduliliyi wapthurruna, ṉapuŋga'lilina djingaryurruna, walalanhana ŋapatjkuŋala Yitjuralpuyŋunhana, bala Yetjippuyŋuwunydja gungaŋalana. Ga munha‐ŋuparana maŋandja yukurrana djingaryurruna ŋunhilina liŋgu waŋganyŋurana dharapulŋura, warumukthuna yukurrana mel‐monyguŋala Yetjippuyŋunhanydja. ");
INSERT INTO gnn_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Bala ŋayinydja Mawtjitjtja waṉa‐djarryurruna goŋ‐wapitja'mirrina, dhunupamirriyaŋala gapuna, bala ŋayi Garrayyu djuy'yurruna watana, dhimurru'ŋuruna gali'ŋuru ŋayi bo'yurrunanydja bitjarra, ŋutu'na dhikana wata, wirrkina yukurrana bo'yurruna munha‐ŋuparana, bala gapunydja gulkthunmaraŋalana barrkuwatjkuŋalana, bitjarra bala bo'yurruna wirrkaḏay'lili, ga dhipala bala bo'yurruna dhunupa'ŋulili gali'lili märrma'kuŋalana. ");
INSERT INTO gnn_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Bala yolŋunydja walala buḏapthurrunana yukurrana ŋulawitjarrana baṉḏany'kurruna, ga ŋunhi gapunydja yukurrana djingaryurruna dhunupa'ŋuŋura gali'ŋura ga wirrkaḏay'ŋura gali'ŋura. ");
INSERT INTO gnn_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Yo, walala Yitjuralpuyŋunydja mukthurrunaŋga yana buḏapthurruna yukurrana, ga walala Yetjippuyŋuyunydja ŋupara yukurrana lili walalanha, buḏapthurrunayi ŋuliyi dhukarrkurru, ga yana liŋgu ga ṉapuŋga'lilina marrtjina wapthurruna. ");
INSERT INTO gnn_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Yo, wäŋanydja marrtjina galki djaḏaw'yurrunana, ga ŋayi ŋunhi Garraynydja ŋunhiliyi nhinana yukurrana, nhäŋala yukurrana ŋunhi Yetjippuyŋunha ŋuliŋuruyi waŋupini'ŋuru ga gurthaŋuru, yana ŋayi walalanha ŋulthu'yunmaraŋala, bala walala bukmaknha yana gundupuŋalanydja, ");
INSERT INTO gnn_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","bala walala djuḻum'thunminana dhoḻulilina, yarraman' walala ga miriŋu yolŋu'‐yulŋu. Gulkuruna walala ganydjarr‐warryunminanydja bala‐bitjarra, ga lili‐bitjarra, liŋgu walala djuḻum'thunmina dhoḻulilina warrpam'nha yana. “Gul' ŋilimurru gonha'yunna Yitjuralpuyŋunhanydja go, roŋi'‐ruŋiyirrina ŋilimurru, bili Garraynydja dhuwala walalaŋgala gali'ŋura. Ŋayi ŋuli ŋilimurrunha balaŋu baymatthurruna,” bitjarra walala Yetjippuyŋunydja waŋanhamina. Yurru gulkuruna walala roŋinyamaranhaminanydja yukurrana. ");
INSERT INTO gnn_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Ga ŋunhalana bala wiripuŋuŋurana gali'ŋura makarrŋura wäŋaŋura, Yitjuralpuyŋunydja dhawaṯthurrunana yukurrana‐a‐a, baṉḏany'kurru warray yana, yana liŋgu‐u‐u bukmaknha dhawa‐yawaṯthurrunana. Bala Garrayyunydja waŋana Mawtjitjnha bitjarrana gam'. “Ma' waṉa‐djarryurrana biyapul gapulili, bala gapuyunydja maṉḏaŋuyu yurru monygumana, dhä‐monygumana Yetjippuyŋunhanydja miriŋunha ga yarraman'nha walalanha.” ");
INSERT INTO gnn_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Bala Mawtjitjthu dhunupamirriyaŋalana dhunupana, bala gapunydja balayi roŋiyina, bitjarrana bitjana ŋuli ŋäthili bäninya yukurranha, ŋulinyarayi yana liŋgu. Yo. Wäŋanydja djaḏaw'yurrunana marrtjina, ga walalanydja Yetjippuyŋunydja baḏak ŋunhala bäyma yana gaṯthurruna dhoḻuŋura, ganydjarr‐warryurruna gundupunharawu, yurru gulkuruna, liŋgu Garrayyuna walalanha ŋunhinydja gulyunmaraŋala ŋunhiliyi ṉapuŋgany'tja mayaŋ'ŋura dhukarrŋuranydja. ");
INSERT INTO gnn_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Bala gapunydja ŋunhiyi dhunupa roŋiyinana ḻupmaraŋalana, dhä‐monyguŋalana walalanha warrpam'nha; bukmaknhana yana gapuyuna guḻwuḻmaraŋala, yarraman'nha ga yolŋu'‐yulŋunha ga girri' walalambala, yakana waŋgany ŋula walŋathinanydja. ");
INSERT INTO gnn_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Yurru Yitjuralpuyŋunydja yolŋu walala buḏapthurruna marrtjina walŋamirri warray bukmaknha yana, baṉḏanygurru warray wäŋakurru, liŋgu walalaŋguway ŋunhiyinydja gapu ḻapthunara yukurrana djingaryurruna, dhunupa'ŋu ga wirrkaḏay', dhukarr wekaŋala walalaŋguway buḏapthunarawu. ");
INSERT INTO gnn_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Yo, bitjarrayi ŋayi Garrayyu Yitjuralpuyŋunhanydja miṯtjinha dhawaṯmaraŋalana Yetjippuyŋuwalanydja goŋŋuru, bala walala Yitjuralpuyŋuyunydja nhäŋalana yukurrana ŋunhi Yetjippuyŋunhanydja, walalanha marrtjina dhaḻinyguŋala gapuyuna raŋililina, bukmaknhana rakunymirrinhana. ");
INSERT INTO gnn_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Ga walalanydja ŋunhi Yitjuralpuyŋunydja miṯtji borrk‐barrarinana Garraywunydja, ŋetjnha walala, liŋgu walala nhäŋala Garraywuna djäma ŋutu'na dhikana, bala walala ŋayaŋu‐yuwalkthinana Garraywunydja, ga bitjarrayi bili walala ŋayaŋu‐yuwalkthina Mawtjitjkunydja, Garraywalaŋuwunydja dhäruk‐märranharamirriwu. ");
INSERT INTO gnn_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Bala Mawtjitj ga nhanbala mala Yitjuralpuyŋu wokthurruna Garraywuna, manikaynha miyamara bitjarrana gam'. “Ŋarra yurru manikaynha miyaman Garraywuna, liŋgu ŋayipi djuḻkmaraŋalanydja miriŋunha; Ŋayi warrkuḻuŋala gapulilina yarraman'nha ga yolŋu'‐yulŋunha, warrpam' walala ŋurru‐ḻupthurrunana. ");
INSERT INTO gnn_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Garraynydja ŋarraku dhuwala ganydjarr‐wekanharamirri, ga ŋarranha ŋayi ŋuli manikaymirriyamanydja, liŋguna ŋayi ŋarranha walŋakuŋalana. Yo, Garraynydja dhuwala ŋarraku Waŋarr, ŋarra yurru wokthunna nhanŋu; Ŋayi Waŋarrnha ŋarrakalaŋuwu mäḻu'wu, bala ŋarranydja yurru ŋanya yäku‐ḻaw'marama garrwarkumana. ");
INSERT INTO gnn_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Yo, Garrayyu baḏuwaḏuyurruna warrpam'thurrunana miriŋunhanydja walalanha, ga yäkunydja ŋayi biyapul wal'ŋu bathala. ");
INSERT INTO gnn_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Ŋayi warrkuḻuŋala buŋgawawunydja miriŋunha walalanha gapulilina, bala walala ŋurru‐ḻupthurrunana bukmakthinana; ");
INSERT INTO gnn_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","gapuyu ŋuriŋiyinydja walalanha liŋguna monyguŋalana, bala walala guḻwuḻyurrunanydja bitjarrana bitjan guṉḏana. ");
INSERT INTO gnn_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Yurru ŋayi Garrayyunydja ŋanapurrunhanydja walŋakuŋala warray, ŋuriŋi nhanukalay warray ŋayi ganydjarryu wal'ŋu; ŋayi barrkuwatjkuŋala miriŋunhanydja walalanha nhanukalay ŋayi goŋdhu yana. ");
INSERT INTO gnn_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Garray, ŋuriŋi nhokalay ŋaramurryunydja nhe nhäranhamaraŋalana walalanha, dhawaṯmaraŋalana yana warrpam'nha, bitjarrana bitjan ŋuli gurthayu nhära räwak mulmu. ");
INSERT INTO gnn_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Nhe gaŋgathinyamaraŋala gapunhanydja ŋunhiyi nhokalay nhe ŋir'yunarayunydja, bo'yurrunanydja nhe ŋunhi gapunha, bala ŋayi gulk‐gulkthurrunana yana, gaŋgathinyamirriyaŋalana yana gali'lili ga gali'lili. ");
INSERT INTO gnn_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Yo miriŋunydja walala ŋunhi waŋana bitjarra, ‘Ŋarra yurru warr'‐warryun walalanha ḻundu‐ŋupan, yana liŋgu ga mulka walalanha yurru. Ŋarra yurru dhawaṯmarama ŋarrakuway mandjawak, bala bumana walalanha; rakunygumana walalanha ŋarra yurru, dhawar'maramana ŋarrakalay ŋarra ganydjarryuna,’ bitjarra walala waŋana miriŋunydja. ");
INSERT INTO gnn_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Bala nhenydja marrtjina bo'yurruna warray watayu, bala gapuyuna walalanha dhä‐monyguŋala; walala guḻwuḻyurruna gapulilina ‘guḻwuḻ’ bitjarrana. ");
INSERT INTO gnn_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Wanhaka dhika wiripunydja waŋarr, balanyara bitjan dhuwala nhe Garray? Nhenydja dhuwala ḻatju'na dhikana, gänana nhepina wal'ŋu garrkuḻuknha, ganaŋ'thunna yukurra. Nhepi ŋuli ḻatju'kumanydja yukurra djäma, liŋgu nhenydja dhuwala ganydjarr ḏumurruna wal'ŋu; ");
INSERT INTO gnn_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Yana nhe waṉa‐djarryurruna, bala wäŋayunydja walalanha wurkthurrunana. ");
INSERT INTO gnn_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Nhe märr‐ŋamathirrinydja yukurra ŋanapurruŋgu, bitjanna liŋguna ŋuli, bala nhe ŋanapurrunha gäŋalana yukurrana, mel‐warryurruna ŋamathaŋalana; nhe ŋuli yukurra goŋ‐gulamanydja ŋanapurrunha nhokalay nhe ganydjarryu, bala gärrinyamaramana yurru nhokalay wäŋalilinydja. ");
INSERT INTO gnn_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Yolŋuyunydja walalay ŋäkulana nhokalaŋuwuy, bala beyaṉiyinana, marrmarryunminana barrariyu; ");
INSERT INTO gnn_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","bukmak ŋunhi yukurra nhina Gaynandja wäŋaŋura bäpurru' ga bäpurru' beyaṉiyinana, liŋgu walala ŋäkula dhäwu'na, ŋunhi nhe nhaltjarra ŋanapurrunha djäma, guŋga'yurruna beŋuruyi. Wirrkina walala beyaṉiyinanydja ŋäkula, liŋgu dhiyaŋuna nhokalay ganydjarryu ḏumurruyuna wal'ŋu. ");
INSERT INTO gnn_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Dhärranydja walala yukurra yurru dharraḏana wal'ŋu, mukthunna yana waŋganyŋurana dharapulŋura, bitjan ŋuli guṉḏa, yana liŋgu ga djuḻkmaramana yana ŋanapurru yurru walalanha, ŋanapurru nhokalaynydja miṯtjiyu. ");
INSERT INTO gnn_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Yo, nhenydja yurru yana gämana‐wala ŋanapurrunha, galkaṉna yurru nhe ŋunhimalayi wäŋalili; nherraṉdja nhe yurru ŋanapurrunha ŋunhayina bukulilina, ŋunhimalayina ŋunhi nhe djarr'yurruna, ganaŋ'maraŋala nhuŋuway nhe wal'ŋu nhinanharawu. ");
INSERT INTO gnn_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Garraynydja nhina yukurra ŋurruŋuna buŋgawana, bitjanna liŋguna ŋayi yukurra yurru ŋurruŋunydja nhina dhawar'yunamiriwnha.” ");
INSERT INTO gnn_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Bitjarra walala miyamaranydja yukurrana, wokthurrunana Garraywu, liŋgu marrtjinanydja walala yukurrana ŋuliwitjarrayi‐wala gapukurrunydja baṉḏany'kurruna dhikana wal'ŋu yana, yurru ŋayi Garrayyunydja baḏuwaḏuyurruna warrpam'nha ŋunhiyi walalaŋgu miriŋunhanydja, liŋgu gapuyunydja ŋuriŋinydja dhä‐monyguŋalana walalanha, bala walala ŋurru‐ḻupthurrunana yukurrana. ");
INSERT INTO gnn_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Ga yapa'mirriŋu maṉḏaku Yärungu ga Mawtjitjku, Miriyam yäku gaŋgathina, bala ŋurru‐yirr'yurrunana giritjina, ga walala wiripuwurrunydja miyalk walala ḏurryurruna, bala giritjinana, malthurrunayi nhanbala. Bukmaknha walala giritjina, ");
INSERT INTO gnn_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","ga Miriyamdja miyamara marrtjina, buŋgulkurru wokthurruna Garraywu, bitjarra ŋayi marrtjina miyamaranydja gam'. “Go ŋilimurru miyamanna Garraywu, liŋgu ŋayi djuḻkmaraŋala miriŋunha; ŋayi warrkuḻuŋala gapulilina yarraman'nha ga yolŋu'‐yulŋunha, warrpam'nha walala ŋurru‐ḻupthurrunana.” ");
INSERT INTO gnn_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Ga buŋgulnydja liŋguna dhawar'yurrunana, bala yanayi walala wäŋgaŋala ŋulaŋuru gapumirriŋurunydja gali'ŋuru, bala ŋayi Mawtjitjthu gäŋalana walalanha ḏuwaṯthunmaraŋalana ḏiltjililina wäŋalili. Marrtjinana walala yukurrana, marrtjinana ga‐ga‐ga‐a‐a, ḻurrkun' munhanydja ŋupara, ga yakana gapunydja ŋula maḻŋ'maraŋala ḻukanharawu. ");
INSERT INTO gnn_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Marrtjinana walala yukurrana‐a‐a, ŋanhdharknha wäŋa ŋupara‐a‐a, yana liŋgu ŋayathaŋala wäŋa nhäyikawuy Mära, ga ŋunhalana gapunydja walala maḻŋ'maraŋala, yurru gapunydja ŋunhi galimiṉḏirrk warray, dhäkay‐murrkthunara. ");
INSERT INTO gnn_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Bala yolŋuyunydja walalay marrtjina ŋarrtjurruna Mawtjitjnhana, gupa‐waŋana yukurrana bitjarrana, “Nhä ŋilimurru yurru ŋarkulany'tja wurkthu'‐wurkthun?” bitjarra. ");
INSERT INTO gnn_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","26","Bala ŋayi Mawtjitjthunydja bukumirriyaŋala Garraynha, bala Garrayyu milkuŋala nhanukala dharpa. Bala Mawtjitjthunydja märraŋala ŋunhiyi dharpa, bala ḏupthurruna ŋunhimalayi gapulili, bala gapunydja marrtjina ḻatju'thinana dhikana dhäkaynydja, wurkthunaramirrina wal'ŋu. Yo, ŋunhalayi gapuŋura ŋayi Garrayyu walalanha yukurrana gatjarr'yurruna bitjarrayi, ga ŋunhalayi bili ŋayi dhäruk‐nherraṉmina walalaŋgu, dhawu'mirriyaŋala walalanha bitjarra gam'. “Ŋarranydja dhuwala Garray, Waŋarr nhumalaŋgu. Ŋuli nhuma yurru mäkiri'‐witjun yukurra ŋarrakuway rirrakaywu, ga djäma rom‐dhunupa ŋarrakala milma yana, ga märrama ŋarranhawuy dhäruk yana; ŋuli yurru nhuma bitjandhiyinydja ḏälkuma ŋarrakunydja rom malanha, nhumanydja yurru nhina yukurra ŋamathamana, ga ŋarranydja yurru yakana nhumalanha rirrikmarama, bitjarra ŋarra ŋunhala rirrikmaraŋala Yetjippuyŋunha. Liŋgu ŋarra dhuwala Garraynydja, walŋakunharamirri nhumalaŋgunydja, ga baḏarraŋ'kunharamirri.” Bitjarra ŋayi God Garray ḻakaranhaminanydja ŋanyapinyay ŋayi. ");
INSERT INTO gnn_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Ŋuliŋurunydja walala marrtjina yukurrana ga‐ga‐ga‐a‐a, ga wäŋa mulkana nhäyikawuy Yelimbuy, ga ŋunhalanydja walala maḻŋ'maraŋala wäŋaŋura guḻku'na gapu maŋu'‐maŋutji, märrma' rulu ga märrma' bäythinyara, ga djingaryurrunanydja marrtjina ŋunhiliyi gali'ŋura gapuŋuranydja dharpa malanha guḻku'na dhika, borum‐mäypamirri dharpa malanha. Bala walala ŋunhiliyina wäŋaraŋalanydja galki gapuŋurana. ");
INSERT INTO gnn_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Ga ŋuliŋurunydja wäŋaŋuru walala yanayi giṯthurruna. Marrtjinana walala yukurrana‐a‐a yana liŋgu‐u‐u, ŋanhdharkkurruna yukurrana marrtjina wäŋakurru‐u‐u, ganbarkkurruna‐a‐a. ");
INSERT INTO gnn_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Bala ŋunhi yolŋunydja walala Yitjuralpuyŋunydja waŋanana marrtjina, ŋarrtjurruna maṉḏanhana Mawtjitjnha ga Yärunnhana bitjarrana, ");
INSERT INTO gnn_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","“Ŋunhi bini ŋayi Garrayyu ŋilimurrunha ŋunhalaŋga bäyma baymatthuna Yetjip muka, ŋunhinydja bini ŋamakurru' warray. Ŋunhalaminydja ŋatha guḻku'na, ga wäyin ḻukanharawu. Nhäku nhuma maṉḏa ŋanapurrunha gäŋala lilinydja dhipalanydja ganbarklilinydja wäŋalili? Ḏukṯuk nhuma yulŋunydja? . . . ŋanapurru yurru dhiyala gay' murrmurryun djaṉŋarrthinyarayu?” ");
INSERT INTO gnn_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Bala Garraynydja waŋana Mawtjitjkala bitjarra, “Ŋarra yurru rarryun ŋayaŋayny'tja nhumalaŋgu djiwarr'ŋuru, ga balakurruyina ŋarra yurru walalanha gatjarr'yundja, wanhaka walala yurru ŋarrakuway dhärukku malthun, mak bäyŋu warray. Bitjan liŋgu walu ŋupan yurru yolŋuyu walalay ŋathanydja yukurra djoṉguma, yurru walala boŋgama djoṉguŋunydja marrtji waŋga'‐waŋganydhu bala ḏaykun'thunydja, gana' yana waŋganygu waluwu bala‐a‐a biyaku. ");
INSERT INTO gnn_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Ga ŋuriŋinydja bala waluyu 6‐thunydja, walala boŋguŋu djoṉguŋu buku‐waŋganynha, märrma'wuna waluwu, liŋgu walala boŋguŋu rulwaŋdhurruna ŋunhiyinydja, ruwamŋukuŋuna nhinanharamirriwuna waluwu.” ");
INSERT INTO gnn_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Bala Mawtjitjthunydja ga Yärundhunydja ḻakaraŋalana Yitjuralpuyŋuwanydja yolŋu'‐yulŋuwa bitjarrana, “Gäthuranydja munhaku nhuma yurru nhämana Garraywu djämanydja, bala yurru nhuma marŋgithirrina, ŋunhi Garrayyu ŋayipi yawungu nhumalanha dhawaṯmarama ŋulaŋuru Yetjipŋurunydja, ");
INSERT INTO gnn_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","liŋgu goḏarrny'tja boŋguŋunydja nhuma nhäŋu ḻatju' wal'ŋu dhika rom nhanŋu Garraywunydja. Liŋguna Garrayyu ŋäkula nhumalanha ŋarrtjunaranydja, liŋgu Garraynhana nhuma ŋuli yukurra dhuwala ŋarrtjundja ŋunhi, yaka ŋilinyunhanydja.” ");
INSERT INTO gnn_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Ga bitjarra bili ŋayi Mawtjitjthu ḻakaraŋala yolŋu'‐yulŋuwanydja, “Yo munhakunydja ŋunhinydja, Garrayyu yurru wekama marrtji ŋanak wäyin nhumalaŋgu ḻukanharawu, ga goḏarrny'tja ŋunhinydja ga guḻku'na ŋathanydja nhuma yurru ḻuka yukurra, liŋgu ŋayi Garrayyunydja ŋäkula nhumalanha ŋunhi nhuma yukurrana morrumurru' waŋana ŋanya. Liŋgu yuwalktja ŋunhi nhuma yukurrana morrumurruny'tja ŋanya warray Godnha warray, ŋunhi ŋinyalanhanydja nhuma yukurrana morrumurru'.” ");
INSERT INTO gnn_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","10","Yo, maŋandja ŋunhi mukthurruna yukurrana djingaryurruna ŋunhili bäyma walalaŋgala, ga ŋunhi ŋayi yukurrana Yärundhu waŋana yolŋu'‐yulŋunhanydja, bala walalanydja yolŋu'‐yulŋuyunydja nhäŋala ŋunhiyi waŋupininy'tja wiripuŋuyinana dhikana, ŋayi marrtjina ŋunhi waŋupininy'tja ḻatju'thinana dhikana djarraṯawun'thinana, liŋgu ŋayipi ŋunhi yana Garray yulŋunydja milkunhamina ŋanyapinyay ŋayi ŋunhiliminydja maŋanŋura. ");
INSERT INTO gnn_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","12","Bala ŋayi Garraynydja waŋana Mawtjitjkala ŋulaŋuru maŋanŋurunydja bitjarrana, “Liŋguna ŋarra ŋäkula yolŋu'‐yulŋunha Yitjuralpuyŋunhanydja, walala yukurra morrumurru' waŋa gupa‐waŋa ŋarranha. Ḻakaraŋanydja walalambala biyakana gam'. ‘Biyaku liŋgu munhaku, nhuma boŋguŋu yukirri ḻuki wäyindja, ga biyakuyi liŋgu munhakumirrinydja nhuma boŋguŋu yukirri ḻuki ŋayaŋayny'tja goŋbuy ŋarrakuŋuway wetjpuy wekanhara. Ga balakurru‐witjanna nhuma yurru dharaŋan marŋgithirrinydja, ŋunhi ŋarra dhuwala Waŋarr nhumalaŋgunydja God.’” ");
INSERT INTO gnn_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Yo, ga ŋulinyaramirriyu bili yana munhaku, wäyinnha walmana djirikitjnha guḻku'na, bala djirryurrunana marrtjina dhika wäŋalilina, warrpam'nha gungaŋala wäŋanydja. ");
INSERT INTO gnn_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Ga munhakumirri, djaḏaw'bitjarra, nhäŋala walala, ŋayi be nhä yana ŋal'yunmina marrtjina gaywaraŋu'mirri, muṉguy dhika warrpam'nha munathany'tja gungaŋala, ŋunhiyi ŋanhdharktja wäŋa. ");
INSERT INTO gnn_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Ga walalanydja Yitjuralpuyŋunydja dhä‐wirrka'yunminana marrtjina, waŋanhamina bitjanminana, “Nhä dhuwala yulŋunydja?” bitjarra, liŋgu walala yaka marŋgi ŋurikiyi, nhä ŋunhiyi ŋatha. Ga Mawtjitjthunydja ḻakaraŋalana walalambala, “Dhuwalinydja ŋayaŋay' Garraywuŋu wekanhara. ");
INSERT INTO gnn_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Ga dhuwalanydja romnha ŋayi Garrayyu Godthu nherrara bitjarrayinydja. Nhuma yurru marrtji djoṉgumanydja, yurru gana' yana dhuwala yulŋunydja waŋganygu waluwu.” ");
INSERT INTO gnn_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Bala walala ḻaw'yurrunanydja, bala djoṉguŋalana marrtjina, yurru wiripu‐guḻku'yunydja djoṉguŋala marrtjina mirithinana wal'ŋu, ga wiripu‐guḻku'yunydja märr‐ŋuli ḻurrkun'. ");
INSERT INTO gnn_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Ga ŋuriŋinydja walalay ŋunhi walala dhaŋaŋguŋala marrtjina djoṉguŋala, ga yakana walalaŋgu bäythinyara goḏarr'wunydja, ga wiripu‐guḻku'wunydja ŋurikinydja ŋunhi walala ḻurrkun' märr galkara, ŋunhiyinydja gana' warray walalaŋgunydja yana, yakana walala yukurrana marrya' nhinana. ");
INSERT INTO gnn_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Yo, Mawtjitjtja waŋana walalaŋgala, “Yaka gurrunharra goḏarr'wunydja ŋayaŋay',” bitjarra. ");
INSERT INTO gnn_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Yurru wiripuwurruyunydja yaka warray märraŋala Mawtjitjnha dhäruk; walalanydja ruwamŋukuŋala goḏarr'wu warray, ga djaḏaw' bitjarranydja, nhäŋala marrtjina ruwamŋukunharanydja ŋatha ŋunhi barrpa'na, boŋirriny'nha. Bala Mawtjitjtja bena maḏakarritjthina walalaŋgu, wirrkina dhikana. ");
INSERT INTO gnn_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Ga bitjana liŋgu munhakumirrina walu‐ŋupana walala ŋuli marrtjinya djoṉgunha ŋunhiyi ŋathanydja, gana'na yana waŋganygu ḏaykun'ku, ga ŋunhi walu marrtjinya ŋuli walmanha, bala ŋuli ŋayaŋayny'tja ŋunhi buwayakthinyana, winya'‐winyayunana. ");
INSERT INTO gnn_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Ga ḏämbumirriyunydja waluyu walala ŋuli ŋatha djoṉgunha waŋga'‐waŋganymirri bala, ga wiripuŋuyunydja waluyu walala buku‐waŋganynha märraŋala, bili Mawtjitjthu waŋana ḻakaraŋala walalambala bitjarranydja, ");
INSERT INTO gnn_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","“Bitjan yukurra Garraynydja waŋa gam', ‘Goḏarrny'tja dhuwala walu nhinanharamirrina dharrpalnha yana Garraywu. Djoṉguŋa dhuwalinydja ŋayaŋayny'tja, ga goḏarr'wuna gurrunharra.’” ");
INSERT INTO gnn_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Ga yuwalkthi walalanydja bitjarrayi, ga yakana boŋirriny'thinanydja ŋula. ");
INSERT INTO gnn_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Yo. Djaḏaw'‐way djaḏaw'yurruna Garraywuna walu, bala ŋayi Mawtjitjtja waŋana bitjarrana, “Gatjuy ḻukiyana walala dhuwali ŋayaŋayny'tja ŋunhi yawungu nhuma gurrunhana, liŋgu dhuwalanydja Garraywuna walu. Nhuma yurru yakana gäthuranydja maḻŋ'marama ŋayaŋay'. ");
INSERT INTO gnn_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Yo, waŋgany ruluyu ga waŋgany bäythinyarayu waluyu nhuma yurru yukurra djoṉgumanydja, ga wiripuŋuyunydja ŋuriŋinydja waluyu Nhinanharamirriyunydja nhuma yurru nhinana yukurra buku‐ŋal'yun Godkuna nhanŋuwaynha, yakana yurru nhuma wiripuŋuyunydja waluyu maḻŋ'marama ŋula nhä ŋatha.” ");
INSERT INTO gnn_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Yurru wiripuwurrunydja yolŋu walala marrtjina wäŋgaŋala bala, warrya'yurruna ŋurikiyi ŋayaŋay'wuna, yurru gulkuruna ḻarruŋalanydja, yakana ŋula walala maḻŋ'maraŋala ŋuriŋiyi waluyu Nhinanharamirriyu. ");
INSERT INTO gnn_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Bala ŋayi Garraynydja waŋana Mawtjitjkala bitjarra, “Nhäthaŋga yurru walala mulka ŋarrakunydja rom malanha? ");
INSERT INTO gnn_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Yo, ŋunhiyinydja walu Nhinanharamirrinydja ŋarra wekaŋala nhumalaŋgu nhinanharawuna yana, ga ŋarra yurru nhumalaŋgu ŋunhiyinydja rulwaŋdhun ŋurikinydja waluwu ŋunha bala ŋathil'yun. Ŋuriŋinydjayi Nhinanharamirriyunydja nhuma yurru waluyu nhinana, yakana yurru marrtji ga djäma ŋula nhaltjan ŋuriŋiyinydja.” ");
INSERT INTO gnn_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Bala walala yolŋu'‐yulŋunydja nhinanhana ŋuli ŋuriŋiyinydja waluyu dhuyuyunydja. ");
INSERT INTO gnn_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Walala Yitjuralpuyŋuyunydja ŋuli ḻakaranha ŋunhiyinydja ŋayaŋay' mana' yäkunydja. Yo, balanyara ŋayaŋayny'tja ŋunhi rumbalnydja bitjan borum gumbu, gaywaraŋu'mirrina, ga dhäkaynydja ŋayi ŋunhi ŋayaŋay' bitjan dämba wuŋay'mirriyanhara. ");
INSERT INTO gnn_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Yo, bala ŋayi Garrayyunydja waŋana Mawtjitjnhana bitjarrana, “Nhe yurru märraŋa ŋuliŋuruyi ŋatha mana', ga gurrunharra gupaḏalŋuwuna, märr yurru dhuḏi'‐dhuḏiŋuyunydja yumurrku'yu nhämana, bala marŋgithirrina ŋunhi nhaltjana ŋarra nhumalanha marrtjinya ŋuli maranhu‐wekanha ŋula lili ŋanhdharkkurru wäŋakurru, ŋunhi ŋarra nhumalanha dhawaṯmaraŋala Yetjippuyŋuwala goŋŋuru.” ");
INSERT INTO gnn_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Bala ŋayi Mawtjitjthunydja djuy'yurruna Yärunnhana bitjarra, “Gatjuy marrtjiya ga ŋatha märraŋa mana', bala rarryurra banikin'lilina, bala gurrunharra Garraywalana gumurrlilinydja, märr yurru ŋilimurru gurrunhandja ŋurukuna ŋunhi dhuḏi'‐dhuḏiŋuwuna yumurrku'wu nhänharawu ga marŋgithinyarawu.” ");
INSERT INTO gnn_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Bala yuwalkthi ŋayi bitjarrayinydja, bala walala gurrunhara ruwamŋukuŋalana ŋunhiyi ŋathanydja gupaḏalŋuwuna‐wala. ");
INSERT INTO gnn_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Bitjarrana liŋguna dhuŋgarra ŋuparana walala Yitjuralpuyŋuyu yukurrana ḻukananydja ŋunhiyi ŋayaŋay' mananydja; goḏarr'‐ŋupana yana munhakumirri bitjanna liŋgu djoṉgunhana, dhuŋgarranydja ŋupara 40, yana liŋgu‐u‐u ga wäŋalili walala gärrina ŋunha Gaynanlili ŋatha guḻku'mirrilili. ");
INSERT INTO gnn_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Mukthurruna walala yukurrana marrtjinaŋga yana, ŋupara marrtjina wäŋa ganbarkka dhika ŋanhdharkka. Marrtjinana walala yukurrana‐a‐a ga‐ga‐ga‐a‐a, yana liŋgu‐u‐u wäŋa gilitjina marrtjina nhäyikawuy Rapatimbuy. Walala wäŋaraŋalanydja ŋunhalana Rapatimnha, yurru gapumiriw wäŋanydja ŋunhiyi; yakana walala gapu maḻŋ'maraŋala ŋula. ");
INSERT INTO gnn_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Bala yolŋu'‐yulŋuyunydja biyapul ŋarrtjurruna Mawtjitjnha bitjarra, “Ma' gapu ŋanapurrunha wekaŋa go. Ŋanapurru ḻukana,” bitjarra. Ga Mawtjitjthunydja waŋana walalanha bitjarra, “Nhäku nhuma yukurra ŋarranhanydja ŋarrtjun? Nhäku warray nhuma bitjandhinydja ŋuli yukurra gatjarr'yun Garraynhanydja?” ");
INSERT INTO gnn_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Yurru ŋunhi yolŋu'‐yulŋuyunydja wirrkina ŋar'ŋaryunmina dhika, mukthurruna warray marrtjina ŋarrtjurruna bala Mawtjitjnha. “Nhäku nhe yawungu ŋanapurrunha gäma ŋulaŋurunydja Yetjipŋurunydja? Nhe ŋanapurrunha buma yurru dhiyalana gay'? Ŋanapurru yurru murrmurryunna ŋanhdharkthinyarayuna? . . . ŋanapurruway ga yumurrku' ŋanapurruŋgu? . . . ga wäyin walala?” ");
INSERT INTO gnn_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Bala Mawtjitjthunydja bukukurru waŋana Garraynha bitjarra, “Nhaltjan ŋarra yurru dhiyaku yolŋu'‐yulŋuwunydja? Galki yurru ŋarranha walala dhuwala buma, guṉḏayuna wirriw'‐wirriwyun.” ");
INSERT INTO gnn_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Bala Garrayyunydja waŋana Mawtjitjnha bitjarra, “Garr'yurra ḏilaknha, ŋurru'‐ŋurruŋunha dhipuŋuruyi miṯtjiŋuru, bala marrtjiyana, mel‐warryurrana walalanha, ga goŋdhunydja gäŋa wapitja, dhiyaŋuyi ŋunhi nhe wutthurruna mayaŋ ŋunhala Yetjip gapu. ");
INSERT INTO gnn_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Ga ŋunha Djäniyanydja bukuŋuranydja ŋarranydja yurru djingaryun yukurra ŋunhalayi guṉḏaŋura, bala nhenydja yurru wutthurra ŋunhayi guṉḏa dhiyaŋi wapitja'yu, bala yurru gapunydja ḻarryunna, märr yurru yolŋu'‐yulŋuyunydja ḻukana ŋarkulany'tja ŋuliŋuruyina guṉḏaŋuruna.” Yuwalkthi Mawtjitjthunydja bitjarrayi guṉḏanhana wutthurruna, milma ŋurikala ḏilakkalana, bala gapunydja ŋuliŋuruyi ḻarryurrunana guṉḏaŋuru. ");
INSERT INTO gnn_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Bala ŋuliŋurunydja dhurrwaraŋuru Mawtjitjthu yäku nherrara ŋunhiyinydja wäŋa märrma'na yäkunydja, waŋganydja yäku Matja, mayali' ‘gatjarr'yun’, ga wiripunydja yäku Miripa, mayali' ‘marimirri’. Ŋayi Mawtjitjthu bitjarrayi yäkunydja nherrara ŋunhiyinydja wäŋa, bili walala ŋuli yukurranha ŋarrtjuna ga mari‐wunanha, ga wiripunydja walala yukurranha ŋuli gatjarr'yuna yana Garraynha, waŋanha bitjana gam', “Wanhaka dhika be Garraynydja? . . . dhiyalamiŋga? . . . bay wanhaka?” bitjana. ");
INSERT INTO gnn_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Ga ŋuliŋurunydja dhurrwaraŋuru miriŋuna ŋunhilinydja ḏo'yurruna Yitjuralpuyŋuwu bunharawuna walalaŋgu, miriŋunydja ŋunhi bäpurru' Yamalik. ");
INSERT INTO gnn_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Bala Mawtjitjtja waŋana waŋganyguna ḏarramuwu yäkuwu Djatjuwawuna bitjarra, “Nhenydja yurru marrtji ga djarr'yun ḏarramuwurrunhana, nhuma yurru marrtji marilili, ga buma walalanha ŋunha Yamalikpuynha. Ga ŋarranydja yurru ŋunhala garrwar bukuŋura djingaryun yukurra, bala garrwarkuma ŋarra yurru yukurra wapitja' yulŋunydja ŋunhi Garraywuŋuna.” ");
INSERT INTO gnn_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Yuwalkthi ŋayi Djatjuwanydja marrtjinana‐wala yana marililina, ŋunhi nhaltjarra Mawtjitjthu waŋana ŋanya, ga dhunupana bunharaminana marrtjina Yitjuralnydja ga Yamaliktja mala. Ga walalanydja ḏuwa'‐ḏuwaṯthurruna bukulilina garrwarlilina, Mawtjitj ga Yärun ga War, ");
INSERT INTO gnn_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","bala ŋayi Mawtjitjtja djingaryurruna yukurrana goŋ‐wapitja'mirrina, garrwarkuŋala yukurrana wapitja ŋunhi. Märr ŋayi Mawtjitjthu garrwarkuŋala wapitjany'tja, bala walala Yitjuralpuyŋuyunydja warr'‐warryurrunana Yamaliknha gay; märr ŋayi Mawtjitjthu bitjarra gurrunhara ŋunhi wapitjany'tja, bala walalanydja Yamalikthunydja warr'‐warryurruna walalanhanydja lilinydja Yitjuralpuyŋunhanydja. ");
INSERT INTO gnn_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Bala Mawtjitjtja waṉana djawaryurruna marrtjina garrwarkunharayuna, bala maṉḏa märraŋalana guṉḏana Yärundhu ga Waryu, bala nherrara ŋanya ŋunhimala guṉḏalilina. Nhinana ŋayi yukurrana‐a‐a Mawtjitj guṉḏaŋurana, waṉanydja garrwarthina yukurrana, ga maṉḏa Yärundhu ga Waryu yukurrana guŋga'yurruna ŋanya waṉanydja‐garrwarkuŋala, waŋganydhunydja wirrkaḏay'ŋuyu, ga waŋganydhunydja dhunupa'ŋuyu waṉayu. Mukthurrunana ŋayi yukurrana waṉanydja‐djarryurrunana, goŋ‐wapitja'mirri yana, yana liŋgu‐u‐u walu marrtjina gärrina. ");
INSERT INTO gnn_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Bala Djatjuwawala miriŋuyuna bumara dhawar'maraŋala Yamaliknhanydja malanha warrpam'thurrunana walalaŋgiyingala mandjawakthuna. ");
INSERT INTO gnn_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Ga Garraynydja waŋana Mawtjitjkala bitjarra, “Ma', wukirrina dhuwalanydja dhäruk djorra'lilina, ga biyakayi bili ḻakaraŋa Djatjuwawalanydja biyaka gam', ‘Ŋarra yurru dhawar'maramana Yamaliknhanydja warrpam'nha. Yakana yurru biyapul ŋula yolthu walalanha guyaŋirrinydja.’” ");
INSERT INTO gnn_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Bala Mawtjitjthu botjaŋala guṉḏana marrtjina ŋal'‐ŋalmaraŋala, ga ŋunhiyinydja wäŋa ŋayi yäku nherrara ‘Garray ŋarrakunydja garrurru’, ");
INSERT INTO gnn_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","liŋgu bitjarranydja Mawtjitj waŋana, “Garrayyu yurru bumana marrtji Yamaliknhanydja bitjanna liŋguna, dhuŋgarra‐watjthirrina.” ");
INSERT INTO gnn_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Ga ŋuliŋuruyinydja dhurrwaraŋuru ŋayi Mawtjitj marrtjina, bala ŋayi nhinanana guŋga'yunarawuna yolŋu'‐yulŋuwuna, djarr'yunarawu marrtjinyarawu nhäku malanyŋuwu, liŋgu guḻku' mirithirri ŋuli yolŋu walala marrtjinya yukurranha nhanukala Mawtjitjkala guŋga'yunarawunydja, beŋuru liŋgu goḏarr'ŋuru ga yana liŋgu‐u‐u ga munhakuyinya. ");
INSERT INTO gnn_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Bala ŋayi Mawtjitjkalanydja ŋapipi'mirriŋuyu nhäŋalana ŋanya, ŋunhi ŋayi yukurrana djäma mirithirri yindi, wirrki wal'ŋu ŋayi yukurrana djäma. Bala ŋayi waŋana ŋanya Mawtjitjnha bitjarrana, “Nhäku warray nhe yukurra nhinanydja nhepinydja waŋganydja dhuwala, guŋga'yun yukurra yolŋu'‐yulŋunhanydja bitjan liŋgu walu‐ŋupan?” ");
INSERT INTO gnn_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","16","Ga ŋayinydja waŋana Mawtjitjtja bitjarrana, “Bitjan muka liŋgu walala ŋuli yukurra marrtjinydja dhuwala ŋarrakala. Ŋunhi walala ŋuli ŋarrtjunmirrinydja, marinydja walala ŋuli djäma, ga ŋunhi walala ŋuli djälthirri Godkalaŋunydja romgu, walalanydja ŋuli marrtji ŋarrakalana, märr yurru ŋarra ŋäŋ'thun Godnha, ga ḻakarama walalaŋgu marŋgikuma walalanha marrtji yuwalkku wal'ŋu dhukarrwu.” ");
INSERT INTO gnn_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Ga ŋayinydja waŋana ŋunhi ŋapipi'mirriŋunydja nhanŋu bitjarra, “Yakana dhuwaliyinydja ŋamakurru'; dhuwaliyinydja djäma nhuŋu ŋonuŋnha mirithirrina, nhe yurru djawaryunna ŋuriŋiyi djämayunydja märr‐yawaryunna, ");
INSERT INTO gnn_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","ga yolŋu'‐yulŋunydja yurru djawaryundhi galkunarayunydja. Yakana nhe yurru djäma gänanydja dhuwaliyi. ");
INSERT INTO gnn_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Ŋäka ŋi', mäkiri'‐witjurra, ŋarra nhuŋu yurru wekama dhäruktja, ga ŋayi yurru Godtja nhokala. ");
INSERT INTO gnn_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Manymak warray nhuŋu, nhe yurru marŋgikuma yukurra Godkalaŋunydja romgu, waŋa marrtji raypirri'yun nhaltjanarawu nhinanharawu Godkalaŋunydja romgu. ");
INSERT INTO gnn_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Ga bitjandhi nhe yurru djarr'yun wiripuŋunha yolŋu'‐yulŋunha, bala nherraṉ walalanha ŋurruŋukumana, märr yurru walalanydja ŋurru'‐ŋurruŋu miṯtjiwu ga miṯtjiwu ga miṯtjiwu, bitjan yurru bala. Djarr'yurranydja nhe yurru ŋunhinha yolŋunha ŋunhi ŋayi yukurra borrk‐beyaṉiyirri Godku ga dhäruk märranharamirri Godku, ŋunhinha walalanha ŋunhi nhe yukurra märr‐yuwalkthirri walalanha, ŋunhi walala yurru yaka yukurra rrupiya gombuma ŋurikiy djämawuy. ");
INSERT INTO gnn_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Walala yurru yolŋu'‐yulŋunydja marrtji ŋurikalayi walalaŋgala ŋurru'‐ŋurruŋuwala guŋga'yunarawunydja, märr walala yurru ŋuriŋiyi walalay djarr'yun marrtji yumurrkuny'tja malanha, ga ŋunhi yurru ŋula ḏälthirrinydja, wirrkinydja wal'ŋu ḏälthirri yurru, ŋunhiyinydja walala yurru gäma nhokala, ga nhe yurru walalanha guŋga'yun nhepina. ");
INSERT INTO gnn_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Ga bitjandhi walalanydja yurru ŋuriŋi ŋurru'‐ŋurruŋuyunydja yukurra gurrukamayi ŋonuŋnha nhokala muka dhambay, märr yurru nhenydja yaka muka ganydjarr‐winya'yun ŋuriŋiyi, märr yurru yolŋu walala yaka muka djawaryunmirrinydja galkunarayunydja.” ");
INSERT INTO gnn_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Bala ŋayi Mawtjitjtja mäkiri'‐witjurrunana ŋurikiyi dhärukku, bala ŋayi bitjarrana waŋana, “Manymaknha dhuwaliyinydjayi guyaŋinyara nhokuŋu.” ");
INSERT INTO gnn_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","26","Bala ŋayi djarr'yurrunanydja ŋunhiyinha yolŋu'‐yulŋunha ŋuliŋuruyina miṯtjiŋuru Yitjuralpuyŋuwalana, bala ŋayi nherra'‐nhirraranydja marrtjina walalanha miṯtjilili ga miṯtjilili ga miṯtjilili bitjarrana, märr yurru walala ŋuriŋi walalay ŋurru'‐ŋurruŋuyu marrtji djarr'yun yumurrku' malanha rom, ga mari ŋuriki yolŋu'‐yulŋuwu. Ga ŋuli yurru ŋula ḏälthirrinydja rom, ŋayinydja yurru ŋayipi Mawtjitjthu djäma ŋunhiyi romnha djarr'yun. ");
INSERT INTO gnn_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Ga ŋuliŋuruyinydja dhurrwaraŋuru, bala ŋayi ŋunhi ŋapipi'mirriŋuyunydja gonha'yurrunana ŋanya, bala marrtjina wäŋalilina. ");
INSERT INTO gnn_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","2","Yo, yuṯayuna wirrmuyu walala mulkana wäŋa yäku Djäniyanydja, ŋunhayinydja wäŋa, ŋunhi muka ŋunhi ŋayi Garray milkunharamina Mawtjitjkala ŋurruthaŋala, bitjarra bitjan gurtha ŋäṉarr ŋatŋatthurruna dharpaŋura. Walala Yitjuralpuyŋuyu liŋguna mulkanana ŋunhiyi wäŋanydja ḻurrkun'thinana ŋaḻindi ŋunhalayinydja walalaŋgu ŋunhi walala dhawaṯthurruna Yetjipŋurunydja. Bala walala ŋunhalayina wäŋaraŋalanydja galki bukuŋurana, ŋunhiliyina ŋanhdharkŋurana wäŋaŋura. ");
INSERT INTO gnn_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Ŋayi Mawtjitjtja marrtjina bala bukulilina ḏuwaṯthurruna bukumirriyanharawu Gunhu'wu, bala Garray wäthurrunana nhanŋu ŋulaŋuru bukuŋuruna, ga waŋana nhanukala bitjarra, “Waŋiya ŋurikala Yitjuralpuyŋuwala ŋunhi walala yarraṯaŋura Djaykupkala, biyaka walalambala ḻakaraŋanydja gam'. ");
INSERT INTO gnn_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘Liŋgu muka nhuma nhäŋalana ŋunhi ŋarra nhaltjarra Yetjippuyŋunha, ga marŋgina nhuma liŋguna ŋunhi ŋarrapi nhumalanha gäŋalanydja marrtjina dhipala ŋarrakiyingalanydja, bitjarranydja bitjan ŋuli wäyindhu ḏamalayu gäma marrtji nhanŋuway yothunha nhanukalay ŋayi binbarryu. ");
INSERT INTO gnn_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Ŋuli nhuma yurru märrama ŋarranhaynydja dhäruk, ga ḏälkuŋa dhawu'‐nherraṉara ŋunhiyi ŋarrakuŋuwaynydja yana, nhumanydja yurru ŋarrakuwaynha mala yolŋu walala. Bukmak dhuwala wäŋa munathany'tja ŋarrakuway yana, yurru nhumanydja yurru walala ŋarrakuwaynha galkiŋuwuynha, ŋarrakalaynha wal'ŋu goŋŋura. ");
INSERT INTO gnn_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Yo, ŋuli nhuma yurru dhäruk-märrama ŋarrakuwaynydja, nhumanydja yurru ganaŋ'thunna ŋarrakuwaynha wal'ŋu miṯtji dhulŋuŋuna, gänana wal'ŋu. Ŋarranydja yurru nhumalaŋgu ŋurruŋuna wal'ŋu buŋgawana, ga nhumanydja yurru ŋarrakuwaynha yana yolŋu walala; nhuma yurru marrtji galkithirrina gal'ŋu ŋarrakalaynha, bitjanna bitjan ḏalkarra'mirrina walala yolŋu'‐yulŋu, ga nhumalaŋgalana yurru walala wiripuŋuyunydja miṯtjiyu maḻŋ'marama ŋarranhanydja.’ Ŋe, ḻakaraŋanydja nhe yurru dhuwala dhäruktja malanha ŋuripa Yitjuralpuyŋuwanydja,” bitjarra Garrayyu dhäruk wekaŋalanydja Mawtjitjkala. ");
INSERT INTO gnn_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Bala Mawtjitjtja dhunarrana ŋulaŋuru bukuŋurunydja, bala yurrum'maraŋala ḏilaknhana, ŋurru'‐ŋurruŋunhana, bala ŋayi ḻakaraŋalana walalambala Garraynhana dhäruk. ");
INSERT INTO gnn_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Ga bukmaknha walalanydja yolŋunydja walala waŋana buku‐ruŋiyinmaraŋalanydja Mawtjitjkala bitjarra, “Ŋanapurrunydja yurru märramana ga djämana‐wala yana ŋunhi nhaltjarra Garray waŋana.” Bala Mawtjitjthu ḻakaraŋalana Garraywala ŋunhi yolŋu'‐yulŋunhana dhäruk. ");
INSERT INTO gnn_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Ga ŋuliŋuru dhurrwaraŋuru Garraynydja waŋana Mawtjitjkala bitjarra, “Ŋarra boŋguŋu ḏo'yurru nhumalaŋgu, maḻŋ'thurrunydja ŋarra boŋguŋu waŋupini'kurru warumukkurru; ŋarra boŋguŋu waŋina nhuŋu, märr yolŋu'‐yulŋuyunydja boŋguŋu ŋarranha rirrakay ŋäkuyi, bala ŋayaŋu‐yuwalkthina nhuŋu weyinŋumirrina.” ");
INSERT INTO gnn_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Ga biyapul ŋayi Garray waŋana Mawtjitjkala bitjarra, “Gatju marrtjiyana, ga ḻakaraŋa ŋurupa yolŋu'‐yulŋuwa, walala yurru gäthuranydja ga goḏarr' boŋgama ŋäthilimirriyanhami gumurr‐ŋamathi ŋarraku. Walala yurru ḏarrtjalkkunharamirriyi ŋayaŋunydja walalanhay walala, ganaŋ'maranhamirrina ŋulaŋuru wiripuŋuŋurunydja nhäŋuru malanyŋuŋuru, ga biyakuyi bili walala boŋguŋu rurrwuyurru girriny'tja walalaŋguway, ");
INSERT INTO gnn_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","liŋgu ŋuriŋinydja djunuma waluyu boŋgama Garraynha ḏo'yurru walalaŋgu, ŋayi boŋguŋu dhunarrinydja ŋunhala Bukuŋura Djäniya, milma bukmakkalana yolŋu'‐yulŋuwala. ");
INSERT INTO gnn_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Yo, ḻakaraŋa walalambala biyaka, walala boŋguŋu marrtji märr‐galkithi ŋunha bukulili, yurru yaka walala yurru marrtji galkithirrinydja wal'ŋu, ga dhanu'yundja ŋunhayi bukunydja. Ŋuli yurru ŋula yol marrtji ga dhanu'yun ŋunhayinydja wäŋa buku, ŋayinydja yurru ŋunhiyinydja yolŋu rakunydhirrina. ");
INSERT INTO gnn_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Nhuma yurru ŋanya buŋanydja guṉḏayuna; ŋunhiyi yolŋunydja ga wäyin yurru yakana walŋa nhina. Ga ŋunhi ŋayi yurru yiḏaki ḻoḻthun weyinmaramanydja, walalanydja yurru yolŋunydja walala galkithirrina marrtji bukulilina.” ");
INSERT INTO gnn_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Bala Mawtjitjtja balayi roŋiyina marrtjina yarrupthurruna, yolŋu'‐yulŋuwa ḏo'yurruna, ga ḻakaraŋala walalambala ŋunhi nhaltjarra Garrayyu nhanukala ḻakaraŋala, bala walala yolŋu'‐yulŋunydja ḏarrtjalkkunhaminana walalanhawuy walala gumurr‐ŋamathinyarawuna Garraywu. Walala girri'na rurrwuyurruna marrtjina, ga ŋamathanharamina ŋayaŋuna walalanhay märrma'yunydja waluyu, ganaŋ'maranhaminana ŋulaŋuru wiripuŋuŋurunydja nhäŋuru malaŋuŋuru. ");
INSERT INTO gnn_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Yakana walala ŋulinyaramirriyunydja waluyu dhäykawurru ga ḏarramuwurru märranhaminya ŋuli. ");
INSERT INTO gnn_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Bala wiripuŋuyunydja munhakumirri djaḏaw'yurrunana, ga ŋunhili bukuŋuranydja gorruŋala yukurrana maŋan, yurru warumukthina yukurrana, ga ŋunhilimiyi murryu'‐murryurruna marrtjina yulŋunydja, ga djaḻka'‐djaḻkarryurruna, ga rirrakay ḻoḻthurruna, guywuyurruna marrtjina yiḏaki. Ga yolŋu'‐yulŋunydja ŋunhala wäŋaŋuranydja wirrkina marrmarryunmina, barrarinana manapara. ");
INSERT INTO gnn_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Bala Mawtjitjthu dhawaṯmaraŋalana ŋunhi yolŋu'‐yulŋunhanydja ŋulaŋuru wäŋaŋurunydja, walala dhawaṯthurrunanydja marrtjina gumurr‐wunanhaminyarawuna Godku Gunhu'wu, ga ŋunhala galki bukuŋurana, ŋoyŋura wal'ŋu, walala djingaryurrunanydja marrtjina ŋunhimalayina. ");
INSERT INTO gnn_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Bala Garraynydja dhunarranana marrtjina lili ŋunhimala bukulili Djäniyalilinydja, bitjarrana bitjan ŋuli gurtha marrtji nhäri, ga ŋawulul'yunydja ḻiw'maraŋala monyguŋala ŋunhi bukunydja, yurru ŋayi marrtjina ŋunhi bukunydja gur'kuryurrunana gay', ");
INSERT INTO gnn_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","ga ŋunhiyi yiḏakinydja rirrakay dhawaṯthurruna walawukthurrunana wirrkina dhika. Bala ŋayi Mawtjitjthunydja waŋana Garraynha Godnhana, bala Garraynydja waŋana nhanŋu buku‐ruŋiyinmaraŋala murryu'‐murryurrunana. ");
INSERT INTO gnn_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Ŋe, ŋayipi Godtja yarrupthurrunana ŋunhimala bukulili, bala djingaryurrunana yukurrana bukuŋurana djinmir'ŋurana. Bala Garraynydja wäthurruna Mawtjitjkuna bala'ŋuwuna marrtjinyarawu ḏuwaṯthunarawuna ŋunhimalayi bukulilina. Bala ŋayi Mawtjitjtja marrtjina ḏuwaṯthurruna bukulilina, withiyara ŋanya Garraynhana. ");
INSERT INTO gnn_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Ga ŋunhala, ga liliyi ŋayi Garrayyu ŋanya djuy'yurruna, yarrupthunmaraŋalayi yolŋu'‐yulŋuwala. “Gatjuy yarrupthurrana, ga waŋiya raypirri'yurra ŋunhi yolŋunha walalanha, walala yurru yaka marrtji galkithirrinydja ga mel‐ḏukṯukthun Garraywunydja nhänharawu. Ŋunhi walala ŋuli marrtji lilinydja, walalanydja yurru murrmurryunna. ");
INSERT INTO gnn_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Yo, ḻakaraŋanydja walalambala ŋuripa ḏalkarra'mirriwanydja walalambala, walala yurru ḏarrtjalkkunharamirri ganaŋ'maranharamirri gal'ŋu, yurruna walala yurru marrtji galkithirrinydja ŋarrakala, walala ŋuli bäynha rakunydhi ŋuriŋiyina ŋarrakala ḏarrtjalkthuna djarraṯawun'thu.” ");
INSERT INTO gnn_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Ŋayi Mawtjitjtja waŋana bitjarra, “Liŋgu muka nhe walalaŋgu ḻakaraŋala dhärranharawu ŋuruku bala barrkuwunydja, yaka walala yurru ŋunhayi galkithirri ḏuwa'‐ḏuwaṯthun bukulili.” ");
INSERT INTO gnn_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Bala ŋayi Garrayyunydja waŋana bitjarra, “Marrtjiya bala yarrupthurra, ga märraŋa ŋanya Yärunnha, nhuma yurru lili marrtji, yurru ŋunhi wiripu‐guḻkuny'tja yaka yurru marrtji lili, märr yurru walala yaka muka rakunydhirrinydja.” ");
INSERT INTO gnn_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Bala Mawtjitjtja marrtjina yarrupthurruna roŋiyinayi balayi, yolŋu'‐yulŋuwa ḏo'yurruna, bala ḻakaraŋala waŋana raypirri'yurrunana walalanha. ");
INSERT INTO gnn_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Yo. Bala Gunhu' Godtja waŋanana, romnha nherrara nhanukalayŋuwu ŋayi yolŋu'‐yulŋuwunydja; dhuwala malanha ŋayi romdja nherrara gam'. ");
INSERT INTO gnn_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Ŋarra dhuwala Garraynydja Godtja nhumalaŋgu Waŋarrnydja, ŋunhiyina ŋunhi ŋarra nhumalanha dhawaṯmaraŋala ŋulaŋuru wäŋaŋuru Yetjipŋurunydja, ḏirrwiḏirrwi‐mulkanharamirriŋurunydja. ");
INSERT INTO gnn_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Yakana yanana nhuma yurru yukurra buku‐ŋal'yun wiripuŋuwunydja waŋarrwu malaŋuwu, liŋgu ŋarrapi dhuwala waŋgany yana waŋarrnydja nhumalaŋgu. ");
INSERT INTO gnn_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“Yakana nhuma yurru waŋarrkuma ga maḏayin' ḻakarama ŋula nhä yolŋuwuŋu goŋbuy ŋamaŋamayunara, yakana yana nhuma yurru djäma wäyinguma ga yolŋukuma ga moḻ'ŋukuma ga guyakuma ŋula nhäkumanydja nhumalaŋguway buku‐ŋal'yunarawunydja. ");
INSERT INTO gnn_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Yaka märr‐ŋal'yurra ga waŋarr‐ḻakaraŋa ŋula nhänhanydja, liŋgu ŋarra dhuwala Garray nhumalaŋgunydja waŋarr God. Ŋarranydja djäl nhumalaŋgu, nhuma yurru ŋarrakuway wal'ŋu yana dhulŋuŋu. Ŋuli nhuma yurru märr‐ŋal'yun wiripuŋuwunydja waŋarrwu ga raŋgawu, ŋarranydja yurru ŋaramurryirrina ŋuriŋinydjayi mel‐ḏi'yunna, bala nhuma yurru ŋayaŋu‐yätjthirri ŋuriŋina nhumalaŋgala gatjpaḻ'yunarayuna; nhe ga nhuŋu djamarrkuḻi' ga walalaŋgu djamarrkuḻi' yurru bitjandhi liŋgu ŋayaŋu‐yätjthirrina yukurra ŋuriŋiyinydja ŋunhi nhe ŋarranha nyinyaŋdhurruna nhäŋala, bala ḏiltjina‐wekaŋala ŋarraku. ");
INSERT INTO gnn_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Yurru ŋarra yurru mel‐wuyunaramirrinydja ŋurikina ŋunhi walala yurru ŋayaŋuyu‐ḏaparama ŋarranha, ga dhäruk‐märrama ŋarranha; walalana yurru yukurra nhina walaŋgumanydja dhikanydja wal'ŋu, liŋgu nhinanydja walala yurru yukurra ŋayaŋu‐ŋamathirrina ŋarrakala märr‐ŋamathinyaraŋurana. Ga bitjandhi liŋgu ŋarra yurru mel‐wuyundhi gäma yukurra yumurrku'nhanydja ŋurikiyi dhäruk‐märranharamirriwunydja walalaŋgu, bitjanna liŋguna gupaḏalnha‐wala walalaŋguna mala‐wunharanydja yurru nhina yukurra ŋarrakala märr‐ŋamathinyaraŋuranydja. ");
INSERT INTO gnn_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“Yaka yana nhuma yurru Garraynha yäku‐ḻakarama waŋa yänanydja wakalkurrunydja, ga ŋunhi nhe yurru ŋula yolkala dhawu'‐nherraṉ Garraywalanydja yäkuyu, bala yurru nhuma rumbalkuma yana ŋunhiyi dhäruktja, yakana yana buku‐dhumukthiyanydja meṉguŋanydja. Liŋgu Godthunydja nhuna yurru ḻakarama yätjnha yana nhe, bala dhä‐ḏir'yunna yurru, yakana ŋayi yurru waŋa bitjandja ‘Bäythi’ bitjandja, ŋunhi nhe yurru Garraynha yäku ḻakarama yana wakalkurrunydja. ");
INSERT INTO gnn_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“Guyaŋiya Nhinanharamirrinydja ŋunhi Walu, ga yaka meṉguŋa, liŋgu ŋunhiyinydja walu ganaŋ'maranhara Garraywu. ");
INSERT INTO gnn_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Nhuma yurru djämanydja ḏämbumirriyu ga waŋgany‐bäythinyara munhanydja ŋupan, ");
INSERT INTO gnn_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","bala ŋuriŋinydja wiripuŋuyunydja waluyu nhinanharamirriyunydja, ganaŋ'maranharana ŋunhiyinydja ḏaykun' buku‐ŋal'yunarawuna yana nhokalayŋuwu Garraywu Waŋarrwuna. Nhuma yurru yakana djäma ŋuriŋiyinydja waluyu; nhuma yurru nhinana yukurra yana galkunmirrina, nhe ga nhipala gäthu'mirriŋu walala, ga nhuŋu djämamirri walala, ga wäyin nhuŋu, ga ŋunhi yolŋu mulkuru ŋunhi ŋayi yukurra nhina nhokala wäŋaŋura. ");
INSERT INTO gnn_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Nhuma yurru nhiniya yukirriya mukthurra ŋuriŋinydja waluyu, liŋgu ŋayipi Garrayyunydja djäma waluyu ḏämbumirriyu ga waŋganydhu bäythinyarayu, dhiyaŋunydja waluyu malanyŋuyu ŋayi bokmara ŋunha djiwarr' ga dhuwala munatha' ga gapu, ga bukmak nhä malanha ŋunhi marrtji ŋorra, bala ŋayi ŋuriŋinydja waluyu nhinana märr‐ŋurr'yurrunana. Bala ŋayi Garrayyu ganaŋ'maraŋalana ŋunhiyinydja walu, nhanŋuwayliliyaŋalana, dharrpalnha wal'ŋu gänana yana. ");
INSERT INTO gnn_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“Nhuma yurru märr‐ŋal'yurra nhokalaŋuwala ŋäṉḏi'mirriŋuwala ga bäpa'mirriŋuwala, märr nhe yurru walŋa nhina weyinga ŋunhala nhumalaŋgalanydja wäŋaŋura, ŋunhi Garrayyu wekaŋala nhumalaŋgu. ");
INSERT INTO gnn_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“Yaka nhuma baymatthurra rakunyguŋanydja ŋula yolŋunha. ");
INSERT INTO gnn_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“Yaka nhuma marramba'thiya. ");
INSERT INTO gnn_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“Ga yaka manaŋiya, ga djaw'yurra dhulŋuŋunydja ŋula nhä yolpa. ");
INSERT INTO gnn_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“Yaka ḻakaraŋa bothiya wiripuŋunha yolŋunha. ");
INSERT INTO gnn_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“Ga yaka mel‐ŋamathiya ŋula nhä malanha wiripu‐guḻku'wa yolŋuwa; nhanbala wäŋa, nhanbala miyalknha, nhanbala djämamirrinha, ga nhanbala wäyin, ŋunhiyinydja ŋuripa bili nhanbala, yaka nhuma yurru ŋoy‐ŋapuyurra ḏukṯukthiya.” Ga bitjarrayina ŋayi Garrayyu romdja nherrara nhanukalayŋunydja ŋayi yolŋu'‐yulŋuwu. ");
INSERT INTO gnn_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Ga walala yolŋu'‐yulŋunydja ŋunhi mukthurrunaŋga marrtjina djinga'‐djingaryurruna ŋunhiliŋga bäyma. Walala ŋäkula murryu'‐murryunara marrtjinyara, ga rirrakay yiḏaki ŋäkula, ga nhäŋala djaḻka'‐djaḻkarryunara ga ŋawulul ṉoluŋdhinyara marrtjinyara bukulili, bala wirrkina walala wilwilyunmina, barrarinanydja manapara. Bala walala marrtjina djinga'‐djingaryurrunana bitjarrana bala, barrkuna ya'. ");
INSERT INTO gnn_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Bala walala waŋana Mawtjitjkalana bitjarra, “Way, nhepina waŋiya ŋanapurruŋgalanydja; ŋanapurru yurru mäkiri'‐witjundja nhuŋuna. Yaka yurru Waŋarryunydja Godthunydja waŋa ŋanapurrunha; ŋanapurru ŋuli gonhana raku'‐rakunydhina.” ");
INSERT INTO gnn_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Yurru Mawtjitjtja waŋana ŋurikala yolŋu'‐yulŋuwalanydja, “Yaka nhuma barrariya. Garraynydja Waŋarrnydja liŋgu milkunharamina ŋanyapinyay ŋayi dhuwalana gay' ganydjarryu maḻŋutjthuna wal'ŋu dhikana, gatjarr'yundja yukurra nhumalanha. Ŋayi djäl nhumalaŋgu marŋgithinyarawu nhäyinyara waŋarr ŋayinydja, märr nhuma yurru borrk barrarirriŋga nhanŋu, ga yakana biyakayi biyapulnydja baḏatjurra ga ŋula nhä djäma yätj.” ");
INSERT INTO gnn_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Walala yolŋu'‐yulŋunydja ŋunhala bala barrku yukurrana djingaryurruna, bala ŋayi Mawtjitjtja marrtjina galkililina, Garraynhana Waŋarrnhana withiyara ŋunhimalana, ŋunhi maŋan yukurrana gorruŋala warumukthina. ");
INSERT INTO gnn_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Ga Garrayyunydja waŋana Mawtjitjnha bitjarra, “Ḻakaraŋa yolŋu'‐yulŋuwu Yitjuralpuyŋuwunydja biyaka, ‘Liŋguna nhuma nhäŋalana nhumapina maŋutjiyu ŋunhi ŋarra nhumalaŋgala yukurrana waŋana djiwarr'ŋuru. ");
INSERT INTO gnn_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Yaka nhuma yurru djäma ŋula nhä waŋarrkumanydja nhumalaŋguway nhuma; yana bini wiripunydja ŋunhi waŋarr malanha rrambaŋi be ŋarrakala. Ŋarrakala yana waŋganygala nhuma yurru yukurra buku‐ŋal'yun waŋarrkumanydja. ");
INSERT INTO gnn_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Nhuma yurru yana munatha'na ŋal'‐ŋalmaramanydja djäma barŋdja, bala batharrana wäyin ŋunhimalayi ŋarrakuway waŋganygu buku‐ŋal'yurranydja yana. Ga ŋunhi nhuma yurru waŋgany‐manapanmirri waŋganylilinydja ḻukanharawu ŋuriki wäyingunydja rrambaŋi waŋganyŋuranydja, ga wiripunydja nhuma yurru ŋuliŋuruyi wetj bathan barŋlili, buku‐ŋal'yun manapan ŋarraku ŋuriŋiyinydjayi wetjthu wekanharayu. Yo, ŋarrapi yurru wäŋanydja ḻakarama marrtji bala, märr yurru nhuma marrtji bala buku‐ḻuŋ'marama ŋunhilimi wäŋaŋura malaŋumi ŋarrakunydja buku‐ŋal'yunarawu; yaka nhuma yurru wäyinnha mundhurr‐wekama ŋarraku birrka'mirriŋuranydja wäŋaŋura. Ga ŋunhi nhuma yurru waŋgany‐manapanmirri ŋunhiliyi dharrpalŋuranydja wäŋaŋura buku‐ŋal'yunarawu ŋarrakunydja, ŋarranydja yurru nhumalanha withiyanna ŋunhimalayinydja, bala goŋmirriyamana ŋarra yurru nhumalanha. ");
INSERT INTO gnn_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","“‘Ga ŋunhi nhuma yurru djäma barŋ malanha ŋal'‐ŋalmarama guṉḏanydja, yaka ŋunhiyi gulk‐gulkthurranydja marrtjiya guṉḏanha dhapirrkkuŋanydja, buyuwuyukuŋanydja ŋula nhäyunydja, liŋgu ŋunhiyinydja dharrpalnydja wäŋa yurru yäraŋuthirri yana ŋuriŋiyi nhokalay goŋbuy djämawuy. ");
INSERT INTO gnn_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Ga yaka yurru nhuma yukurra ŋal'‐ŋalyun ŋuliwitjandhiyi garrwarkurru barŋgurrunydja.’” Ga guḻkuŋ'ka Garrayyu Godthu romdja wekaŋala malanha Mawtjitjkalanydja, marŋgikuŋalanydja yukurrana yolŋu'‐yulŋunhanydja nhanbalay ŋayi, nhaltjan walala yurru djäka yukurra walalaŋguway walala bala‐lili'yunmirri, märr walala yurru nhina galŋa‐ŋamathirrina dhiyaŋuyinydja romdhu. ");
INSERT INTO gnn_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Yo. Ŋuliŋurunydja dhurrwaraŋuru ŋunhi ŋayi wekaŋala rom malanha Mawtjitjkala, Garrayyu waŋana djäkakuŋala, raypirri'yurruna bitjarra, “Liŋguna ŋarra djuy'yurruna djiwarr'wuynha watjarr‐mulkanharamirrinhanydja, ŋayi yurru marrtji ŋurru‐warryundja nhumalanha, yana liŋgu nhuma yurru gärri ŋunhawala wäŋalili ŋunhi ŋarra nhumalaŋgu ŋäthilimirriyaŋala. ");
INSERT INTO gnn_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Mäkiri'‐witjurra nhanŋu, ga märraŋana ŋanya dhäruktja. Yaka raypirri‐waḏatjthiyanydja nhanŋu, liŋgu ŋayinydja yurru yakana gonha'yun nhuna nhäma yätjlili romlili, liŋgu ŋarranydja yäku nhanukalaŋga. ");
INSERT INTO gnn_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Ŋuli nhuma yurru mäkiri'‐witjun marrtji nhanŋu dhärukku gurrum'thun, ga djäma nhaltjan ŋarra yurru waŋa, ŋarranydja yurru nhumalaŋgala bitjanna liŋguna, bumana yurru marrtji miriŋunhana ŋunhi walala yurru miriŋuyirrinydja nhumalaŋgu. ");
INSERT INTO gnn_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","“Ŋe. Dhuwalayi djiwarr'wuy watjarr‐mulkanharamirrinydja marrtji yukurra nhumalanha ŋurru‐warryun, gämanydja ŋayi yurru yukurra nhumalanha, ga gärrinyamaramana ŋunhamala wäŋalili. Yurru ŋunhilinydja wäŋaŋura nhina yukurra wiripuna ga wiripuna bäpurru', Yamarpuynha ga Yitpuynha ga Gaynanbuynha, ga wiripu ga wiripu bäpurru', bala ŋarranydja yurru marrtji walalanha buwayakkumana warrpam'nha. ");
INSERT INTO gnn_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Yaka yana nhuma yurru bun'kumu‐djipthurra ga buku‐ŋal'yurranydja walalaŋgalaŋuwala waŋarrwalanydja, ga yaka djäma dhuḏakthurra walalaŋgunydja rom. Yana nhuma yurru ḏaw'‐ḏawyurrana walalaŋgu waŋarrnhanydja walalanha ŋunhi walalaŋgiyinguŋunydja djämawuy goŋbuy, ga biyakayi bili ḏaw'‐ḏawyurra dharpanydja ga ŋula nhänydja guṉḏa ŋunhi walala ŋuli marrtji nherraṉ walalaŋgiyingala dhuyulili wäŋalili. ");
INSERT INTO gnn_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","“Yo, ŋuli nhuma yurru buku‐ŋal'yun yukurra ŋarrakuwaynydja waŋganygunydja yana, bala ŋarranydja yurru nhumalanha wekamana yana ŋathayu ga ŋarkula'yu, ga bitjandhi bili ŋarra yurru rerrinydja djaw'yun nhumalaŋgala, bäyŋukumana. ");
INSERT INTO gnn_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Ga nhumalaŋguŋu yothuny'tja dhawal‐wuyaŋirri yukurra yurru ḻatju'mirrina, yakana yalŋgi'mirri, ga yakana nhuma yurru goŋ‐yätjthirri yuṯawunydja yothuwu. Ga walŋana nhuma yurru nhina wal'ŋu weyinnha. ");
INSERT INTO gnn_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Ga ŋunhi yurru miriŋu nyäṉ'thun nhumalaŋgu, ŋarranydja yurru barrari‐wekama walalanha, goḏuy-wumana, bala walalanydja yurru gundupumana nhumalambala. ");
INSERT INTO gnn_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Walalanydja Gaynanbuynydja miṯtji ga Yitpuynydja miṯtji ga wiripu‐guḻku' bäpurru' ŋunha nhinana walala yukurra nhumalaŋgala wäŋaŋuranydja, bala ŋarranydja yurru walalanha ŋupan dhawaṯthunmaramana. ");
INSERT INTO gnn_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Ŋarranydja yurru nhumalaŋgala walalanha goŋ‐war'warmaramana, bala nhumana yurru warr'warryundja walalanha. Yurru yaka ŋarra yurru miriŋunhanydja walalanha gukuma dhawaṯmarama ŋuriŋinydja bili waŋganydhunydja waluyu, ");
INSERT INTO gnn_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","yana ŋarra yurru gukumanydja marrtji miṯtjinha waŋganynha ŋäthili, ga biyapul wiripunha miṯtjinha, bitjanna yurru ŋarra marrtji bala walalanha guku'‐wukumanydja dhawaṯmaramanydja, märr yurru nhumana ŋunhiyi wäŋanha dhaŋaŋguma. ");
INSERT INTO gnn_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Ŋarra yurru wekama bukmaknha yana miriŋunhanydja goŋlili nhumalaŋgala, ga nhumana yurru walalanha gukuma dhawaṯmaramanydja. ");
INSERT INTO gnn_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","“Yakana nhuma yurru dhawu'‐nherraṉmiya wiripuŋuwala bäpurru'wala, mulkuruwalanydja miṯtjiwala; yakana nhuma yurru nhina yukurra waŋganyŋura walalaŋgala, ga yakana yurru nhuma märr‐ŋal'yurra mulkuruwalaŋunydja waŋarrwala. ");
INSERT INTO gnn_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Walala yurru ŋunhiyi mulkurunydja miṯtji yolŋu yakana nhina nhumalaŋgala wäŋaŋura ŋarakaŋura; nhuma yurru warr'‐warryundja walalanha, dhawaṯthunmaraŋana bukmaknha yana; walala ŋuli gonhana yätjkuŋu nhumalanhana, garr'‐garryurru yätjlilina romlili. Ŋuli nhuma yurru märr‐ŋal'yun walalaŋgalaŋunydja waŋarrwu malanyŋuwu, nhumalanhanydja yurru ḏap‐ḏapmaramana ŋuriŋiyina walalaŋgalay yätjthuna romdhu.” Bitjarra ŋayi ŋunhi Garrayyu dhawu'‐nherraranydja, raypirri'yurruna nhanŋuway yolŋu'‐yulŋunha, märr yurru walalanydja nhina nhanŋuway gal'ŋu yana yolŋu walala, ga yakana märr‐ŋal'yun ŋula wiripuŋuwalanydja waŋarrwala. ");
INSERT INTO gnn_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","2","Bala ŋayi Garrayyu djuy'yurruna Mawtjitjnha balayi, roŋiyinmaraŋala yolŋu'‐yulŋuwala, bitjarra ŋayi waŋananydja, “Gatjuy marrtjiya balayi yarrupthurra, ga ŋunhili garr'yurra walalanha Yärunnha ga Natapnha ga Bäyunha, ga wiripu‐guḻku'nha ŋurru'‐ŋurruŋunha Yitjuralpuyŋunha, 70 ŋaḻapaḻmirrinydja mala, walala yurru marrtji lili ḏuwaṯthun, yurru märr‐barrkulili walala yurru djingaryundja marrtji, buku‐ŋal'yun yurru ŋarrakunydja, liŋgu nhepi yurru waŋgany Mawtjitj marrtji galkithirrinydja wal'ŋu ŋarrakalanydja.” Bitjarra ŋayi Garrayyu ḻakaraŋalanydja Mawtjitjkala. ");
INSERT INTO gnn_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Bala Mawtjitjtja yarrupthurrunana, ga ḻakaraŋalanydja yolŋu'‐yulŋuwa Garraynha dhäruktja, ga bukmak rom malanha ŋunhi ŋayi wekaŋala yukurrana nhanukala Mawtjitjkala. Bala bukmaknha yana yolŋuyunydja walalay dhäruktja buku‐ruŋiyinmaraŋala Mawtjitjkalanydja bitjarrana gam'. “Ŋanapurru yurru djämana‐wala yana bukmak ŋunhi Garrayyu nhaltjarra ḻakaraŋala.” ");
INSERT INTO gnn_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Bala Mawtjitjthu wukirrina marrtjina bukmak Garraywuŋu dhäruktja djorra'lilina. Ga wiripuŋuyuna waluyu, Mawtjitj gaŋgathina munhakumirri dhika, bala botjaŋala guṉḏana ŋal'‐ŋalmaraŋala ŋunhili bäyma ŋoyŋura bukuŋura, ga bitjarrayi bili ŋayi djinga'‐djingarmaraŋala 12 guṉḏa malanha, bili walala ŋunhi Yitjuralnydja mala 12 bukmaktja bäpurruny'tja. ");
INSERT INTO gnn_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Bala ŋayi djuy'yurruna yuḏayuḏanhana ḏarramuwurrunha, ga ŋunhalanydja walala bumara wäyinnha malanha, bala ŋal'maraŋala wäyindja guṉḏalilina, ŋunhimalana ŋunhi ŋayi botjaŋala Mawtjitjthu. Walala batharana ŋunhiyi wäyindja malanha, buku‐ŋal'yurrunana yukurrana Garraywuna, ");
INSERT INTO gnn_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","bala ŋayi Mawtjitjthunydja gulaŋdja ŋunhiyi wäyin guryu'‐guryunmaraŋala rupa'lilina, ga wiripunydja gulaŋ ŋayi bikpikthurruna ŋunhimalayi wäyinmirrilili guṉḏalili. ");
INSERT INTO gnn_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Bala Mawtjitjthunydja märraŋala djorra'na, ŋunhiyi djorra' ŋunhi nhanukiyinguŋu wukirriwuy dhawu'‐nherraṉminyara ŋanyapinyay Garraynha ga yolŋunha walalanha, bala ŋayi marrtjina waŋana ŋuliŋuru djorra'ŋuruna. Bala yolŋu'‐yulŋuyunydja ŋäkula bukmakthuna, ga waŋana walala bukmaknha yana bitjarra, “Ŋanapurrunydja yurru djämana‐wala yana bukmaknha ŋunhi Garray yukurra waŋa; yuwalknha ŋanapurru yurru yana malthundja nhanŋuwaynha dhärukku,” bitjarra. ");
INSERT INTO gnn_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Bala ŋayi Mawtjitjthu märraŋala ŋunhi gulaŋ rupa'mirri, bala bikpikthurruna yolŋu'‐yulŋuwalana, waŋana marrtjina, “Dhiyaŋunydja gulaŋdhu wuṉḏaŋarrkumana dhärranhamarama yukurra ŋunhiyinydja malanha dhäruktja dhawu'‐nherraṉminyaranydja, Garray God ga nhumapi; ŋayi yukurra yurru bitjanna liŋguna dhuwalayi dhäruk‐nherraṉminyaranydja djingaryun yurru.” ");
INSERT INTO gnn_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Ga dhurrwaraŋuru ŋuliŋurunydja walala wäŋgaŋala ḏuwa'‐ḏuwaṯthurruna bukulilina, Mawtjitj ga Yärun ga gäthu'mirriŋu maṉḏa Yärungu Natap ga Bäyu, ga wiripu‐guḻku' 70 ŋaḻapaḻmirri marrtjinayi malthurruna, ");
INSERT INTO gnn_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","ga ŋunhalayi bukuŋura walala nhäŋalana Garraynhana Godnha, Yitjuralpuyŋuwuna Waŋarrnha. Yo, nhanukala Garraywala ḻukuŋuranydja ŋunhi ŋayi yukurrana djingaryurruna ŋunhilimi ḻatju'na dhika buyuwuyu'na, miny'tjinydja ḻatju'na dhikana, ga ḏarrtjalknha dhika wal'ŋu, yurru ralkthunara. ");
INSERT INTO gnn_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Liŋguna walala mel‐ŋal'yurrunana, nhäŋalana Godnhanydja, yurru yakana ŋayi walalanha ŋula rakunyguŋalanydja ŋunhi ḏilaknhanydja, yana walala ḻukana marrtjina ŋayaŋay'nha ga ŋarkula'na waŋganyŋurana, bala walala marrtjina roŋi'‐ruŋiyinayi balayi wäŋaliliyi. ");
INSERT INTO gnn_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Bala biyapul Garray waŋana Mawtjitjkala bitjarra, “Ḏuwaṯthurra dhipala bukulili nhe yurru, ga galkurra yukirriya ŋarraku dhiyala. Ŋarra yurru wekama nhokala goŋlili bilkpilk maṉḏanha guṉḏa, makarrmirri dhärukmirri, liŋguwuynha ŋunha ŋarrakuŋu wukirriwuynha yulŋunydja ŋunhiyinydja romdja malanha.” ");
INSERT INTO gnn_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","14","Bala Mawtjitjtja ga nhanbala guŋga'yunamirrinydja Djatjuwanydja gaŋgathinana, bala waŋana ŋurikala 70‐walanydja ḏilakkala bitjarrana, “Nhumanydja nhiniya ŋi' dhiyala, galkurra ŋinyalaŋgu yukirriya, bäy ŋilinyu yurru roŋiyirri. Ŋunhiyi maṉḏa Yärun ga War yurru nhina yukurra dhiyalinydja nhumalaŋgalanydja, djäkanydja nhumalaŋgu. Ŋuli nhuma yurru ḏukṯukthirri ŋula nhäkunydja, marrtjiyanydja maṉḏakala.” Bala maṉḏa Mawtjitj ga Djatjuwa ḏuwaṯthurrunana marrtjina bukulilina, ŋunhimalana ŋunhi Garraywu buku Djäniya yäku. ");
INSERT INTO gnn_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Ŋe. Mawtjitjtja ḏuwaṯthurrunana marrtjina bala bukulilina, bala ŋayinydja marrtjina waŋupini'yunydja monyguŋalana ŋunhi bukunydja, ");
INSERT INTO gnn_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","bala maŋandja marrtjina wiripuŋuyinana dhikana ḻatju'thinana, liŋgu Garray ŋayipi milkunharamina ŋunhiliminydja maŋanŋura, ŋunhilimi bili bukuŋura Djäniya. ");
INSERT INTO gnn_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Ga ŋuriŋi yolŋu'‐yulŋuyu wäŋaŋurunydja nhäŋalana ḻatju'thinyara djingaryunara yukurranhara, Garraywuna ḻatju'na dhikana ŋunhi maŋandja. Nhäŋalanydja walala ŋunhi bitjanarana bitjan ŋuli gurtha marrtji nhäri, ŋäṉarrnydja gurtha ŋatŋatthurruna marrtjina ŋunhala bukuŋuranydja djinmir'ŋuranydja. Ḻurrkun' ga ḻurrkun' munhanydja‐ŋupara bukunydja ŋunhi monyguŋala yukurrana maŋandhunydja, ŋayi Mawtjitjtja mukthurruna yana nhinana yukurrana, galkurruna Garraywu. ");
INSERT INTO gnn_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Bala ŋuriŋiyinydja bala ḏaykun'thu Garray wäthurrunana Mawtjitjku ŋulaŋuruyi maŋanŋurunydja, bala Mawtjitj djar'tjaryurruna, bala gärrinana ŋunhimalayi maŋanlilina, ḏuwaṯthurruna marrtjina bala‐a‐a, yana liŋgu ga buku djinmir' ŋunha mulkana, guwatjmara Garraynhana. Bala ŋayi Mawtjitj nhinananydja yukurrana ŋunhalana bukuŋurana waŋgany ŋaḻindi ga ḻurrkun' walunydja bäythinyaranydja. ");
INSERT INTO gnn_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Ga ŋunhalanydja bäyma bukuŋura Garrayyu waŋana Mawtjitjnha bitjarra, ");
INSERT INTO gnn_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Ḻakaraŋanydja biyaka Yitjuralpuyŋuwanydja, walala yurru wekama mundhurr ŋarraku; birrka'mirriyu yolŋuyu ŋunhi walala ḏukṯukthirrinydja yurru, walala yurru gäma'‐gamanydja ŋarraku mundhurrnydja, bala wekamana yurru nhokalana goŋlili. ");
INSERT INTO gnn_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","7","Ga dhuwala mundhurrnydja malanha walala yurru weka'‐wikamanydja gam', garwarrwarr bulayi, ga lätuŋdhinyara, ga wiripu ḻatju'mirri maryakal, ga wäyin barrwaṉ', ga lanapu' dharpa, ga weyika lanhdhirra'wu, ga buŋgan bäw' weyika, ga ḻatju'mirri guṉḏa. ");
INSERT INTO gnn_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Yo, dhiyaŋuyinydja malaŋuyu nhuma yurru djäma dhä‐mana'‐manapanna ŋarraku buṉbuna ganaŋ'maraŋa, märr yurru ŋarranydja nhumalaŋgala nhina yukurra ṉapuŋga'na. ");
INSERT INTO gnn_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Ŋarra yurru nhumalaŋgu ḻakaramanydja ga milkuma buṉbunharawu buṉbuwunydja, ga wiripu maryakal nhuma yurru djämayi djinawa'wunydja ŋuruku buṉbuwu. Nhuma yurru djämanydja bukmaknha yana bitjan yana liŋgu ŋunhi ŋarrapi nhumalaŋgala yurru milkuma. ");
INSERT INTO gnn_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","16","“Yo, biyaka nhuma yurru djämanydja gam'. Nhuma yurru dhuḻ'yundja bathi lanapu' dharpa, yurru märr‐nyumukuṉiny, ga ŋapalilinydja nhuma yurru mam'marama garwarrwarr'nha djinawa'kurru ga warraŋulkurru. Ga bitjandhiyi nhuma yurru dhawaraŋ'tja märrma' yana gali'lili ga gali'lili, märrma'lili yana, ga dharpa gulŋiyinyamaranharawu ŋurikiyi gänharawu yukurranharawu. Dhipalanydja bathilili nhuma yurru galkaṉ rommirri maṉḏanha guṉḏa ŋunhi ŋarra boŋguŋu wekaŋu nhumalaŋgu. Ga ŋunhi bathinydja boŋguŋu yäku Dhawu'‐nherraṉminyarawuynha Bathi. ");
INSERT INTO gnn_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","22","“Ga biyakayi bili djäma dhurrwarawunydja dhaḻ'yunarawu ŋuruku bathiwu, yurru dhurrwaranydja nhuma yurru djäma garwarrwarr bathanara. Ga biyakayi liŋgu djämayi märrma' garwarrwarr maṉḏanha, djiwarr'wuynha yolŋunha maṉḏanha, ga nherralanydja maṉḏanha bukulili maṉḏanyŋulili ŋunhimala dhurrwaralili; maṉḏa yurru nhinanydja yukurra gumurr'yunmirri, ga binbarrnydja maṉḏanha bärr'yunmaraŋa garrwarkurru, warraw'kuma, ŋapa‐ŋäkirrmarama yukurra yurru ṉapuŋga ŋunhiyi dhurrwaranha bathinha yana. Yo, ŋunhi guṉḏanydja yurru rommirrinydja ŋunhana djinawa'na ŋunhilimi bathiŋura, ga dhurrwaranydja yurru ga garrwarnha ŋapaŋurana, ga yäkunydja yurru ŋunhiyi dhurrwaranydja Mel‐wuyunharawuynha Wäŋa, liŋgu ŋunhimalayina ŋarra nhumalanha yurru guwatjmandja, ga ŋunhiliyi ŋarra yurru yulŋunydja ṉapuŋga' yana ŋurikala maṉḏakala, ŋapaŋura yana garrwar Mel‐wuyunaramirriŋura Wäŋaŋura, liŋgu ŋuliŋuruyina ŋarra yurru wekama dhäruktja nhumalaŋgu Yitjuralpuyŋuwunydja. ");
INSERT INTO gnn_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","30","“Ga biyakayi liŋgu nhuma yurru ŋamaŋamayurra bala'palanydja dharpanydja, ga ŋapanydja ŋäkirrmaraŋa garwarrwarr'yuna, ga garrwaryi gunganhamirriyaŋanydja gurrunhara. Ga ŋunhimalayi bala'palalilinydja nhuma yurru gurrunhan yukurra ŋayaŋay', märrma' rulu ga märrma' bäythinyaranydja, liŋgu dhuwalayinydja ŋayaŋay' malanha bitjanna liŋguna yurru yukurra ŋorrana ŋarrakalaynha gumurrŋura. ");
INSERT INTO gnn_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","39","“Ga biyakayi liŋgu nhuma yurru ŋamaŋamayurrayi lanhdhirra'wuynydja, garwarrwarr'mirriyi yana, djingaryunarawuynydja, yurru waṉa'‐waṉanydja ŋunhiyi lanhdhirrany'tja yurru waŋgany rulu ga märrma' bäythinyara, ga ŋunhiliyi gorru'‐gurrumanydja marrtji yurru dhumbu'‐yumbuḻ rupa malanha weyika'wuy djarraṯawun'kunharawuy. ");
INSERT INTO gnn_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","“Yo, biyakayina yana djämanydja dhuwalayinydja malanha, djan'kukuŋa yana, bitjarra ŋarra ŋunhi milkuŋala nhuŋu ŋunhili bukuŋura.” Bitjarra ŋayi Garray waŋananydja. ");
INSERT INTO gnn_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","30","Yo, ga ŋunhalayi bukuŋuranydja Garrayyu ḻakaraŋala Mawtjitjkala, ŋayi yurru djäma buṉbu Godku, märr yurru ŋayi God yukurra nhina ŋunhili nhanukalaŋuwala yolŋu'‐yulŋuwala miṯtjiŋura, yurru dhuḻ'yundja walala yurru buṉbunydja ŋunhiyi ruwaŋga'mirri girri', gänha'‐ganharamirri yana, ga ḻakaraŋalanydja ŋayi nhanukala bitjarra muṉguykuŋala marrtjina dhika wal'ŋu, nhaltjan ŋayi yurru djäma yukurra dhuḻ'yun djaka' ga miny'tji dhika nhä malanha. Ŋayi waŋananydja ḻakaraŋalanydja bitjarra, “Nhe yurru djämanydja dharpa malanha ŋäthilinydja nherra'‐nhirrala ŋurikiyi buṉbuwu, ga ŋunhiyinydjayi yurru malanha ŋäkirrmaramanydja ḻatju'yuna dhikana wal'ŋu girri'yunydja, milkuminy'thu ga miku'yu ga ḻingarryinyarayu miny'tjiyu, ga biyapul nhuma yurru yukurra djäma djiwarr'wuy yolŋu walala ŋunhiliyi dhomala'lili. Ga ŋunhiyinydja nhe yurru ŋäkirrmaraŋa ŋapakurrunydja barrwaṉ'thu wäyingalana. ");
INSERT INTO gnn_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","37","“Bala nhe yurru gulk‐gulkthunna ṉapuŋgany'tja ŋunhiyinydja buṉbunydja, märrma'kumana yurru dhaḻakarrnydja maryakalyu ḻatju'yu dhika wal'ŋu miny'tjimirriyu, gungama yukurra yurru ṉapuŋga'na, märr yurru ŋunhinydja bala djinawany'tja wal'ŋu ŋärrany'tja, ŋarrakuwaynydja wal'ŋu ŋunhiyinydja yurru ganaŋ'thun yukurra djingaryun ŋuliŋuru bala wiripuŋuŋurunydja dhuyuŋuru wäŋaŋuru. Ga ŋunhinydja wal'ŋu bala djinawa'lilinydja wal'ŋu nhe yurru nherraṉ ŋunhiyinayi Mel‐wuyunaramirrina dhaḻakarr, ŋunhi yurru yukurra djingaryundja ŋapaŋura Dhawu'‐nherraṉminyarawuyŋura Bathiŋura. Ga ŋunhinydja wal'ŋu dhuyunydja, dharrpalnydja wal'ŋu wäŋa, warraŋul märr, nhe yurru ŋunhiwalayinydjayi gurrunhan bala'pala ŋathamirri waŋganylili gali'lili, ga wiripulilinydja gali'lili nhe yurru nherraṉ lanhdhirra'na ŋunhiyi baṉdja'‐baṉdjamirri. Ga djämanydja nhuma yurru dhurrwaranydja ŋurikiyi buṉbuwu ḻatju' wal'ŋu dhomalany'tja, miny'tjimirri yana dhika wal'ŋu, yurru mel‐warumuk ŋunhiyi girriny'tja, ga girriny'tja ŋunhiyi yurru yukurra dhaŋgama ḏämbumirriŋura dharpaŋuranydja, dhaḻ'yundja yukurra ŋunhiyi dhurrwaranydja.” Ga bitjarrana ŋayi Godthu ḻakaraŋala Mawtjitjkalanydja; ŋayi wekaŋala nhanukala ŋunhiyi mali ŋuriki buṉbuwunydja, ŋunhi ŋilimurru yurru ḻakarama dhiyaŋunydja‐wala dapanakulnha. ");
INSERT INTO gnn_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","8","Ga biyapul ŋayi Godthu ḻakaraŋala Mawtjitjkala nhaltjan ŋayi yurru djäma yukurra ŋunha warraŋulnydja wal'ŋu ŋurikiyi nhanukalaŋuwu buṉbuwu, ŋayi waŋana bitjarra, “Bitjandhi nhe yurru djämayi yana dhaliyarra', yurru djingaryundja ŋayi yukurra yurru warraŋul. Nhe yurru djämanydja yukurra dharpayu yana, ga gunganharamirrinydja ŋunhinydja warraŋulnydja balanyara bitjan girri' biny'tjuna, ga buluŋun'ŋuranydja malaŋuŋura ŋunhilimiyi ga dhandhurruŋ'nha dhärra'‐dharra yurru marrtji. Ga biyakayi liŋgu djäma banikin' ḻirrwi'wunydja, liŋgu ŋunhiwalayi dhaliyarra'lilinydja nhuma yurru bathan wäyin mundhurr Garraywu. Ga bitjan yana liŋgu nhuma yurru djämanydja yukurra bitjarra ŋarra nhuŋu ḻakaraŋala dhiyala bukuŋura. ");
INSERT INTO gnn_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","19","“Ga bitjandhi liŋgu nhuma yurru djäma ḻiw'maramanydja ŋunhinhayi gunganhamirriyaŋanydja ḻoḻukuŋana, waŋgany yana dhurrwara galki yana ŋunhiliyi dhaliyarra'ŋura. ");
INSERT INTO gnn_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","21","“Ga ḻakaraŋa ŋarrakalaŋuwala yolŋu'‐yulŋuwalanydja walala yurru gämanydja ḻatju' wal'ŋu weyikany'tja, märr yurru ŋunhayi djinawany'tja dhuyuŋuranydja wäŋaŋura yurru yukurra nhärana yana lanhdhirrany'tja bitjanna liŋguna. Bitjanna liŋgu goḏarr'mirri ga munhaku Yärun ga gäthu'mirriŋu nhanŋu yurru marrtji, bala weyikany'tja ŋunhinydja rarr'yu‐rarryunna, dhuŋgur'yunna yurru bitjanna ŋunhiyi lanhdhirrany'tja, märr yurru yukurra ŋunhiyi djarraṯawun' nhära yana mukthun bitjan liŋgu gumurrŋura Garraywalanydja. Ga ŋarrakala ŋuriŋi yolŋu'‐yulŋuyu Yitjuralpuyŋuyunydja yurru yukurra ŋayathamana yana dhuwalayi romnhanydja gupaḏalnha‐wala.” Ga bitjarra ŋayi Godthu ḻakaraŋalanydja Mawtjitjkala. ");
INSERT INTO gnn_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“Ga wiripunydja, nhe yurru ganaŋ'maraŋa nhuŋuway wäwa'mirriŋunha Yärunnha, ga nhanŋu gäthu'mirriŋunha walalanha, Natapnha ga Bäyunha ga Layatjanha ga Yithamanha, walala yurru ganaŋ'thunna ŋurukala wiripuwurruŋgalanydja yolŋuwala Yitjuralpuyŋuwala, yarrkthunna yurru ŋarrakuwaynha ḏalkarra'mirri walala, märr walalanydja yurru ṉapuŋga yukurra dhärra, ŋarrakala ga yolŋu'‐yulŋuwala, ŋarrakalaŋuwu romgu gänharamirri walala. ");
INSERT INTO gnn_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Nhuma yurru djäma dharpuŋa Yärungu girri', gänana wal'ŋu nhanŋuwaynha girri', ḻatju'kuŋa yana miny'tjimirriyaŋa.” Yo, ga bitjarra ŋayi God Garray waŋana Mawtjitjkalanydja, ");
INSERT INTO gnn_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","“Liŋgu ŋarra ŋunha ŋäthilimirriyaŋala dharpunharawuy girri'wunydja yolŋu'‐yulŋunha, märr yurru walala yukurra dharpuma girri' Yärungu, märr yurru ŋayi gäna wal'ŋu yana ŋurukala wiripu‐guḻku'walanydja, liŋgu ŋayinydja ŋunha ŋurruŋu wal'ŋu ḏalkarra'mirri ŋarraku. ");
INSERT INTO gnn_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","8","“Ŋuriŋinydja walalay yurru yukurra dharpuma girri' malanha dharrpal'mirri dhika wal'ŋu nhanŋu Yärungu, ga bitjandhiyi walala yurru dharpumayi girri' nhanukalaŋuwu Yärungalaŋuwu gäthu'mirriŋuwunydja, ŋuriki wiripuŋuwunydja ḏalkarra'mirriwu, yurru djämanydja walala yurru yukurra dhapirrkmirri ŋanya dhika wal'ŋu girri' malanha miny'tji mäypamirri. ");
INSERT INTO gnn_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","14","“Yo, ga djämana walala yurru gumurrwuynydja girri' nhanŋu Yärungu, ga bitjandhi nhuma yurru märrama bilk‐bilkmirrinydja dhika wal'ŋu buyuwuyu'mirri yana guṉḏanydja maṉḏany märrma', ga ŋunhiwalayi guṉḏalili malanyŋulili nhuma yurru wukirrina yäkunydja miṯtji Yitjuralpuyŋunha, ḏämbumirri ga waŋgany bäythinyara waŋganyŋura ŋunhilimi guṉḏaŋura, ga ḏämbumirri ga waŋgany bäythinyara ga wiripuŋuranydja guṉḏaŋura. Ga ŋunhiyi maṉḏanha guṉḏa yurru gurrunhan girri'lili ŋunhiwala ḻambarrlili wal'ŋu ŋunhi Yärungala, märr yurru ŋayi ŋunhiyi yäkunhanydja yukurra gäma ŋuriŋina nhanukalay ḻambarryuna, ŋunhi ŋayi yukurra dhärra nhanukala gumurrŋura Garraywala dharapulŋura ŋurikala yolŋu'‐yulŋuwalana. ");
INSERT INTO gnn_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","30","“Ga bitjandhiyi nhuma yurru gurrunhan 12‐nha guṉḏanha malaŋunha, miny'tjimirri dhika ŋanya wal'ŋu yana, mel‐wiḏi'mirri, ŋunhiyinydja nhuma yurru rulwaŋdhun gumurrlili wal'ŋu, ga ŋunhilimi malanyŋuŋura guṉḏaŋuranydja yurru yäku malanha marrtji dhärra'‐dharra ŋunhiyi Yitjuralwu gäthu'mirriŋu walala 12 ŋunhi, liŋgu ŋayi yurru Yärundhu yukurra gämanydja ŋunhiyi 12‐nha miṯtjinha ŋuruŋu ŋayaŋuyuna nhanukalay, ŋunhi ŋayi yukurra yurru marrtji ŋunhiwalayi dhuyulili wäŋalili, ŋunhawalayi gumurrlili Garraywalanydja, märr yurru ŋayi yukurra Garrayyunydja guyaŋirrina bitjanna liŋguna ŋunhina nhanŋuwaynha miṯtjinhanydja Yitjuralnhana. ");
INSERT INTO gnn_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","35","“Yo, ŋunhiyi Yärungunydja walala yurru djäma girri' milkuminy yana, ga ŋunhinydja djinmir'lilinydja wal'ŋu girri'lili walala yurru rulwaŋdhun marrtji borumdhinyara, ga ṉapuŋga'lilinydja ŋunhimala maṉḏanyŋulili borumdhinyara ḻarraṉi'yinyara rumbal walala yurru rulwaŋdhun rirrakaymirri banikin yumurrku'mirri wal'ŋu. Ga ŋunhi ŋayi yurru Yärun marrtjinydja ŋunhimalayi ŋarrakala gumurrlilinydja, ŋayinydja yurru bitjandhiyina rirrakaymirriyirrina marrtji, märr yurru ŋayi yaka ŋunhiliyi rakunydhirri. ");
INSERT INTO gnn_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","38","“Ga bitjandhiyi nhuma yurru djämayi dhulmu‐ḻuḻnyindhinyara, dhikana wal'ŋu djeŋarra'na garwarrwarr, ga ŋunhiwalayinydjayi nhuma yurru wukirrina dhäruk bitjanna, ‘Garrkuḻuk wal'ŋu ganaŋ'thun yana yukurra nhanŋuway Godku Garraywu,’ bala nhuma yurru rulwaŋdhundja ŋunhiyi girri' Yärungala muḻkurrwuylili girri'lilinydja, märr yurru ŋayi yukurra gämana ŋunhiyi yana dhäruknha nhanukalay ŋayi bukuyuna, märr yurru ŋunhi yolŋuyu walalay baḏatjundja ŋula, ŋunhi walala yurru wekama mundhurrnydja Godku, ŋayi yurru Godthunydja yakana dhä‐ḏir'yundja walalanha ŋurikiyi baḏatjunaranydja, yana ŋayi yurru bäy‐ḻakaramana walalaŋgu ŋurikiyi, bala märramana yana. ");
INSERT INTO gnn_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","43","“Yo, nhuma yurru djämanydja yukurra Yärungunydja girri' dhapirrkkuma yana wal'ŋu dhika, ga bitjandhi liŋgu nhuma yurru djämayi Yärungalaŋuwu gäthu'mirriŋuwunydja girri' gumurrwuy, ga muḻkurrwuy girri', ga gandarrwuy girri', bukmak yana dhapirrkmirri dhika wal'ŋu, bala nhuma yurru yulŋunydja Yärunnha ga nhanŋu gäthu'mirriŋunhanydja dhaṯthunna ŋuriŋi malaŋuyu girri'yunydja, bala ŋämiṉna walalanha weyika'yuna muḻkurrnha, bala ganaŋ'maramana walalanha yurru ŋurukala wiripu‐guḻku'walanydja, märr yurru walala ḏalkarra'mirri yana ŋarraku, ga marrtji yurru lili galkithirri ŋarrakala, ga djäma ŋarraku yurru. Ga ŋunhi walala yurru bitjan liŋgu marrtji ŋarrakala wal'ŋu gumurrlili galkithirri, ga djämanydja walala yurru marrtji ŋunhiliyi dhaliyarra'ŋuranydja, walalanydja yurru dhaṯthunmirrinydja yuṯuŋgurrwuyyu girri'yunydja, märr yurru walala yaka warraŋulthirri ŋarrakala, bala rakunydhirrina.” Ga bitjarrayina ŋayi ŋunhi Garray waŋananydja yukurrana. ");
INSERT INTO gnn_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","9","Ga bitjarrayi liŋgu ŋayi Garrayyu nherrarayi rom, nhaltjan yurru ŋayi ŋunhiyi ḏalkarra'mirri yolŋu wapthun, bala ganaŋ'thunna Garraywuna nhanŋuwaynha, bitjarra ŋayi Garray waŋananydja gam'; “Ŋäthilinydja wal'ŋu nhe yurru rurrwuyun walalanha gapuyuna, märr yurru walala warrpam'thuna yana ḏarrtjalkthirrinydja, bala nhuma yurru walalanha dhaṯthunna marrtji ŋuriŋiyinayi girri'yu malanyŋuyu dharrpalmirriyuna. Ga ŋuliŋurunydja dhurrwaraŋuru nhe yurru märraŋa weyikany'tja, bala rarr'yurra muḻkurrlilina walalaŋgala, ŋämilana biyakana walalanha, märr yurru walala bitjanna liŋguna yarrkmaranharana nhinanydja yukurra ganaŋ'thunarana nhanŋuwaynha Godkuna yana ḏalkarra'mirri gupaḏalŋuwuna‐wala. ");
INSERT INTO gnn_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","12","“Ga biyapul nhuma yurru gäŋa wäyinnha buliki'nha ŋunhimalayinayi Withiyanminyarawuylilina Buṉbulili, bala walalanydja yurru ŋunhiyi Yärun ga gäthu'mirriŋu walala nhanŋu goŋ‐ŋal'yun yurru muḻkurrlili ŋunhiyi wäyingala buliki'walana, bala nhuma yurru wutthundja nhanukala gumurrŋurana Garraywala, dhurrwaraŋurana ŋunhiliyi buṉbuŋura. Märraŋa nhe yurru maŋguny'tja banikin'lilina, bala goŋ‐ḻupthurra ŋunhimalayi gulaŋlilinydja, bala ŋämiṉna nhe yurru marrtji bala yulŋunydja ŋunhiyi dhandurruŋdja ŋunhilimiyi dhaliyarra'ŋuranydja, ga bukmaktja rarr'yurra gulaŋ ŋunhi wäyinnha ŋunhana wal'ŋu ŋoylilina ŋunhiwala dhaliyarra'lili ḻiw'maraŋa yana. ");
INSERT INTO gnn_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","14","“Bala märraŋa biḏila ga ḏiny'ṯiny ŋunhi wäyinnha, ga wäyin yaḻmanga' ŋunhiyi ḏiny'ṯinyŋura märraŋayi, bala batharra ŋunhimalayinayi dhaliyarra'lilina mundhurr Godkuna. Yurru rumbalnydja nhuma yurru ŋunhiyinydja gäŋa dhawaṯmaraŋana warraŋullilina wäŋalili, ŋanaktja ŋunhi ga barrwaṉ'tja, ga batharra gurthalili warraŋulnha, liŋgu ŋuriŋinydjayi wäyindhu gämana yurru yukurra yätj ŋurikiyina ḏalkarra'mirriwuna walalaŋgu, bitjarra ŋunhiyinydjayi wäyin rakunydhina dharapulŋurana walalaŋgala, märr yurru ŋayi Godthunydja yakana nhäma yukurra walalaŋgu yätj biyapulnydja.” Ga bitjarra ŋayi waŋana Garrayyu ḻakaraŋalanydja Mawtjitjkala. ");
INSERT INTO gnn_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","37","Ga bitjarrayi bili ŋayi wekaŋalayi wiripunydja rom malanha, ḻakaraŋala Mawtjitjkala nhaltjan ŋayi yurru yukurra ganaŋ'marama ŋunhi ḏalkarra'mirrinha walalanha, märr yurru walala marrtji galkithirrina wal'ŋu yanana Godkalanydja. ");
INSERT INTO gnn_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","42","Yo, bitjarra ŋayi Garrayyu ḻakaraŋalanydja Mawtjitjkala, “Bitjan liŋgu goḏarr'mirri ga munhakunydja nhuma yurru bathan wäyinnhanydja gurthayuna, mundhurr‐wekamanydja nhanŋu Garraywunydja ŋunhili Withiyanminyarawuyŋuranydja Buṉbuŋura, liŋgu ŋunhilinydja dhaḻakarrŋura ŋarra yurru withiyan nhumalanha ŋarrakuway ŋunhi yolŋu'‐yulŋunha, ga ŋunhiliyinydja ŋarra yurru waŋana yukurra nhumalanha. ");
INSERT INTO gnn_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Yo, ŋarraku yurru nhänydja malanha gungama yukurra djarraṯawun'thu yana ŋunhiyi wäŋanha, ga ŋunhiyinydjayi dhaḻakarr wäŋa gänana wal'ŋu yana garrkuḻuknha ŋula nhämiriwnha, ganaŋ'maranharana ŋunhiyinydja ŋarralay djarraṯawun'nha. ");
INSERT INTO gnn_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Yo, ŋunhiyinydjayi buṉbu ga dhaliyarra' dhulŋuŋu yana ganaŋ'thunara ŋarrakuway, ga bitjandhi yurru Yärundja ga gäthu'mirriŋu walala nhanbala, ŋarrakuway yana wal'ŋu ḏalkarra'mirri walala, ganaŋ'maranhara ŋarrakuway djämamirri. ");
INSERT INTO gnn_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Liŋgu ŋarranydja yurru ŋunhi nhinana yukurra ṉapuŋga'na ŋarrakalaŋuwala yolŋu'‐yulŋuwalanydja Yitjuralpuyŋuwalanydja, ga ŋarrapi yana walalaŋgu yurru Godtja ŋunhi. ");
INSERT INTO gnn_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Walala yurru marŋgiyirri ŋarraku, ŋunhi ŋarranydja Garray walalaŋgu God Waŋarr, ŋunhi ŋarra dhawaṯmaraŋala walalanha gäŋala beŋuru Yetjipŋuru, märr yurru ŋarra nhinana yukurra wäŋaramana walalaŋgala. Ŋarrapi yana walalaŋgu Waŋarr Godtja.” Ga bitjarra ŋayi yukurrana Garray waŋananydja. ");
INSERT INTO gnn_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","10","Ga baḏak Garrayyu waŋana yukurrana Mawtjitjnha ŋunhiliŋga bäyma bukuŋura yana. “Biyakayi liŋgu nhuma yurru ŋamaŋamayurra bathanarawu buŋgangu bäw'wunydja. Ga bitjandhi nhuma yurru nherraṉdhi dhandurruŋdja malanha yumurrku' ḏämbu'mirri ḻikanlili malaŋulili ŋunhiwala, bala nherraṉdja nhe yurru ŋunhina wal'ŋu yana Dhuyulilina dhaḻakarrlili, galkina gunganharawuylilina dhomala'lili, yurru gumurrlilina ŋunhimala Dhawu'mirriyanharawuylilina Bathilili, ŋunhi wanhami ŋarra yurru withiyan nhumalanha. Yo, Yärundhunydja bathan yukurra yurru buŋgan bäwny'tja bitjan liŋgu munhakumirri ga milmitjpa, ŋunhi ŋayi yurru marrtji lanhdhirra'wunydja weyika'mirriyanharawu, märr yurru yukurra buŋgan bäwny'tja gaŋgathirri yana bitjan liŋgu. Ga bitjanna liŋgu dhuŋgarra‐watjinya ŋunhi ŋayi yurru buma ŋunhiyi wäyin Yitjuralwunydja yätjku ŋäkirrmaranharawu, ŋayinydja yurru Yärundhunydja ŋämiṉ marrtji ŋunhiyina dhandurruŋnha ŋuriŋiyi maŋgu'yuna wäyingala, märr yurru ŋayi Godthu bäy‐ḻakaranharawuy wekama walalaŋgalaŋu yätjpuy. Ga dhuwalayinydjayi ŋunhi ŋayi yukurra yurru gaŋgathirri bäw' ŋuliŋuruyi, ŋunhinydja gänana wal'ŋu yana, ganaŋ'thunna yukurra ŋarrakuwaynha.” Bitjarrana ŋayi yukurrana Garray waŋananydja. ");
INSERT INTO gnn_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","21","Ga biyapul ŋayi Garrayyu ḻakaraŋala Mawtjitjkala bitjarra gam'. “Ga biyakayi liŋgu djäma yindi rupa rurrwuyunminyarawunydja yukurra yurru yana, bala nherralanydja ŋunhiyi rupa'nha ṉapuŋga'lili buṉbuwala ga gurthawuywala dhaliyarra'wala, ga guryu'‐guryunmaraŋa gapu dhaŋaŋguŋa. Walala yurru Garraywu ḏalkarra'mirri walala, Yärun yäku ga nhanbala gäthu'mirriŋu walala rurrwuyunmirri goŋ ga ḻuku yurru, yurruna walala yurru gärri'‐garri Garraywalanydja buṉbulili ŋunhanydja. Ga bitjandhi bili walala yurru rurrwuyunmirriyi, yurruna walala yurru djäma mundhurrnydja bathan gurthalilinydja; walala ŋuli gonhana rakunydhi. Yo, ŋäthilinydja walala yurru rurrwuyunmirri goŋ ga ḻuku, ga dhuwalayinydja rom yukurra yurru dhärra bitjanna liŋgu gupaḏalnha‐wala yurru. ");
INSERT INTO gnn_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","11","“Ga wiripunydja ŋarra yawungu ḏarramunha djarr'yunna, Warwu gutharra'mirriŋunha yäkunha Betjalilnha, ŋarra yawungu ganydjarr wekamanydja ŋanya djämawu, liŋgu Walŋayu Birrimbirryu ŋuriŋi ŋarrakalay liŋguna ŋanya dhaŋaŋgunha, märr ŋayina boŋguŋu djämanydja yukirri ŋunhiyi maryakalnydja malanha ḻatju'kuŋunydja. Yo, ŋayipi boŋguŋu Betjalilyu ga wiripu‐guḻku'yu guŋga'yunamirriyu walalay nhanukala boŋguŋu djämanydja yukirri ŋunhiyi ŋarraku buṉbunha, ga bukmak nhä malanha wiripu girri' ŋurikiyi buṉbuwunydja. Ga bitjandhiyi walala yurru djäma mirithirri yukurra dharrpal girri' wal'ŋu ŋuriki ḏalkarra'mirriwunydja walalaŋgu, ga biyapul walala yurru djämayi weyikany'tja dharrpal yana ŋurikiyi lanhdhirra'wunydja, yurru djämanydja walala yurru yukurra bukmak djan'kukuma bitjandhi, bitjarra ŋarra ŋunhi nhokala ḻakaraŋala ŋunhala bukuŋura.” Bitjarrana ŋayi yukurrana Garrayyu ḻakaraŋalanydja Mawtjitjkala. ");
INSERT INTO gnn_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","17","Bala Garray waŋana dhurrwara‐ḏaw'yurrunanydja Mawtjitjkala bitjarrana gam'. “Ḻakaraŋa Yitjuralpuyŋuwanydja miṯtjiwa biyaka, walala yukurra yurru bitjanna liŋguna ḏälkuma ŋarrakunydja ganaŋ'maranharanydja walu nhinanharamirrinydja, liŋgu dhuwalayinydja walu yiŋarra'yunara, märr nhuma yurru bitjan liŋgu guyaŋirrina yukurra ŋunhi ŋarra nhumalanha ganaŋ'maraŋalanydja ŋarrakuwayliliyaŋala. Yo, ŋunhiyinydjayi walu dharrpalnha wal'ŋu yana dhulŋuŋuna ŋarrakuwaynha. Ŋuli yurru ŋayi ŋula yol yolŋu yakanydja galkunmirri nhina, djämanydja yukurra mukthundja, nhumanydja yurru bumana ŋanya rakunygumana, liŋgu waŋgany rulu ga waŋgany bäythinyara ḏaykun' djämawuynydja, ga ŋuriŋinydja bala waluyu ŋunhiyinydja ganaŋ'maranharana wal'ŋu, galkunminyaramirrina, gänaŋuna nhanŋuwaynha Garraywuna. Balanyarayunydja walala Yitjuralpuyŋuyunydja yurru bitjan liŋgu guyaŋirrina yukurra, ŋunhi Garrayyu bokmara ŋunha djiwarr' ga dhuwala munatha'; waŋgany rulu'yu ga waŋganydhu bäythinyarayu ḏaykun'thunydja ŋayi djämanydja, dhawar'maraŋalana warrpam'nha nhä malanha, ga ŋuriŋinydja bala ḏaykun'thu ŋayi galkunminana ŋanyapinyay ŋayi.” ");
INSERT INTO gnn_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Ŋunhi ŋayi Garray dhawar'yurrunana Mawtjitjkala waŋanharaŋuru ŋunhala bukuŋura, bala ŋayi Garrayyu goŋ‐wekaŋalana Mawtjitjkala märrma' guṉḏa maṉḏanha, yurru rommirri, makarrmirri dhärukmirri, wukirriwuynydja goŋbuy nhanukiyinguŋu Gunhu'wuŋu Waŋarrwuŋu. ");
INSERT INTO gnn_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Ga ŋunhala ŋoyŋuranydja ŋunhiliyi bukuŋura, yolŋunydja walala ŋunhi galkurrunana, galkurrunana‐a‐a yukurrana‐a‐a Mawtjitjkuna, yurru bäyŋuna ŋayi roŋiyina waḏutjanydja, liŋgu ŋayi yukurrana Mawtjitj nhinana ŋunhala mukthurruna bukuŋura weyin, märraŋala yukurrana Garraywuŋu rom malanha. Bala ŋunhi yolŋu'‐yulŋunydja djawaryunminana galkunarayuna, bala walala marrtjina yurrum'maranhaminana walalawuynha walala, bala wäŋgaŋala Yärungalana, bala waŋana ŋanya bitjarrana, “Wanhakana mak ŋayi Mawtjitj ŋi'? . . . ŋunhi ŋilimurrunha ŋayi gäŋala marrtjina ŋulaŋuru Yetjipŋuru. Yakana ŋilimurru nhanŋu marŋgi? Gatjuy nhe yurru miny'tji‐yarpuŋa ŋilimurruŋguway waŋarrnha ŋi', märr yurru ŋayina ŋilimurrunha gämanydja yukurra bala, bili dhikana Mawtjitjtja winya'yunana yawungu.” ");
INSERT INTO gnn_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Bala Yärundja waŋana walalaŋgu bitjarra, “Gatjuy, burrul'maraŋana nhumalaŋgalayŋuwala dhäykawurruŋgalana garwarrwarr'mirri wurrwanydja ga goŋbuy bulayi, ga gäŋa'‐gaŋa lili ŋarrakala.” ");
INSERT INTO gnn_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Bala ŋuriŋi yolŋu'‐yulŋuyunydja burrul'maraŋalana marrtjina wurrwanydja mäkiri'wuynydja ga goŋbuynydja, bala gäŋa'‐gaŋalana ŋunhi garwarrwarr'mirrinydja bulayi Yärungalana. ");
INSERT INTO gnn_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Ŋayi galkaranydja marrtjina Yärundhu walalaŋguŋu, bala bathara waŋganylilina, bala ŋayi Yärundhu miny'tji‐yarpuŋala wäyinguŋalana, buliki'kuŋalana ŋunhiyi garwarrwarr'mirrinydja maryakal. Ga yolŋu'‐yulŋuyunydja ŋuriŋiyi nhäŋalana ŋunhiyi buliki, bala waŋanana bitjarra, “Way walala, nhuma Yitjuralpuyŋu yolŋu walala, dhuwalana ŋilimurruŋgu waŋarrnydja ya', dhuwalana gay' ŋunhi ŋayi ŋilimurrunha gäŋala ŋulaŋuru Yetjipŋuru.” ");
INSERT INTO gnn_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Ŋayi Yärundhunydja nhäŋalana, ga ŋäkulana waŋanhaminyarana yolŋunhana walalanha, bala ŋayi botjaŋala guṉḏana ŋal'‐ŋalmaraŋala wäyinguna bathanarawu mundhurrwuna, gumurrlili ŋurikala garwarrwarr'wala buliki'wala, ga waŋananydja ŋayi walalaŋgala bitjarra, “Goḏarrny'tja boŋguŋu ŋilimurru ŋayaŋay'nha ḻuki ga buŋgulnha djäma buku‐ŋal'yurruna Garraywuna.” ");
INSERT INTO gnn_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Yo. Wiripuŋuyuna ḏaykun'thu walala ḏurryurruna munhakumirrina, bala bathara mundhurrnha ŋunhimala barŋlilina, bala yolŋu'‐yulŋunydja ŋunhi nhinana marrtjina ḻukana ŋayaŋay'nha ga ŋarkula'na, yana liŋgu bala walala yukurrana leŋuna ŋuriŋi ŋänitji'yuna ḻukanharayu, ga ŋula nhäna marramba'na djäma yukurrana rom malanha nhäŋiniŋ'nha ŋuliwitjarrayina buŋgulkurruna. ");
INSERT INTO gnn_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Bala Garrayyu waŋanana ŋanya Mawtjitjnha bitjarrana gam', “Gatjuy marrtjiyanydja waḏutjana yana yarrupthurrana, liŋgu nhipala yolŋu'‐yulŋunydja ŋunhana ya', ŋunhi nhe gäŋala walalanha ŋulaŋuru Yetjipŋuru, liŋguna walala yätjkunharaminana walalanhay walala, ŋuyulkthinana ŋapana‐wekaŋala ŋarrakunydja. ");
INSERT INTO gnn_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Waḏutja yana walala ŋunha bilyurrunanydja ŋuliŋurunydja romŋuru ŋunhi ŋarra walalaŋgu wekaŋala, liŋgu walala yawungu djäma walalambalay walala buliki miny'tji‐yarpuma, bala walala yukurra märr‐ŋal'yunna ŋurikiyina ŋunha, ga bathan yukurra mundhurr wekama ŋurukuyina waŋarrwu. Ga waŋanydja walala yukurra ŋunha bitjanna, ‘Dhuwalana ŋilimurruŋgu waŋarrnydja go, ŋunhi ŋayi yawungu ŋilimurrunha gäma ŋulaŋuru Yetjipŋuru,’” bitjanna. ");
INSERT INTO gnn_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Ga biyapul ŋayinydja Garrayyunydja waŋana Mawtjitjnha bitjarra, “Ŋarra marŋgiyirri yukurra walalaŋgu Yitjuralpuyŋuwunydja, walala yukurra rom‐ḏälthirrina, walalaŋgalaynha romgurru marrtji. ");
INSERT INTO gnn_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Gonha'yunna ŋarranha, ŋarra walalaŋgu yukurra wirrkina ŋaramurryirri dhuwala, ga nhära'‐nharana. Ŋarranydja yurru walalanha buma dhawar'maramana, yurru nhokalayŋuwuna djamarrkuḻi'wu ŋarra yurru miṯtjinydja guḻku'kuma, ga ŋurruŋukumanydja wal'ŋu ŋarra yurru nhokalana yarraṯaŋuru.” ");
INSERT INTO gnn_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Yurru Mawtjitjthunydja wirrkina dhika yukurrana bukukurru waŋana Garraywala Godkala bitjarra gam', “Garray, nhäku warray nhe yukurra ŋaramurryirri nhokalaŋuwunydja yolŋu'‐yulŋuwu? Nhepiŋga walalanha dhawaṯmaraŋala ŋulaŋuru Yetjipŋurunydja, nhokalay ŋutu'yu ganydjarryu. ");
INSERT INTO gnn_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Ŋuli nhe yurru buma dhawar'maramanydja walalanha, walalanydja ŋuli Yetjippuyŋuyunydja ŋäkuna, bala waŋi rom‐nyamir'yurruna nhuna biyakuna gam', ‘Ŋayi muka yawungu walalanhanydja dhawaṯmarama, märr ŋayi yurru buma rakunygumana walalanha,’ biyakuna walalanydja ŋuli. Garray, yaka mari‐wuniya nhokalayŋuwu miṯtjiwunydja. Bilyurrana dhipuŋuru, ḏaḏawyurrana; djambina nhunapinyay ḻiyanydja, ga yakana djämanydja yätjtja nhokalayŋuwu yolŋu'‐yulŋuwunydja. ");
INSERT INTO gnn_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Guyaŋiya Yipurayimnha ga Yitjaknha ga Yitjuralnha ŋunhi walalanydja nhokala galki. Nhepi muka dhawu'‐nherraṉminanydja walalaŋgala bitjarranydja, ‘Ŋarra yurru gaŋdhunmarama malanydja nhipala yumurrku'nhanydja, bala ŋarra yurru wekama walalaŋgu dhuwalana wäŋa ŋaraka; wäŋanydja yurru dhuwala walalaŋguwaynha yukurra djingaryun bitjanna liŋguna.’ Bitjarra nhe dhawu'‐nherraṉmina Yipurayimgala, ga Yitjakkala, ga Yitjuralwala.” ");
INSERT INTO gnn_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Bala Garraynydja bilyurrunayi, ḏaḏawyurruna ŋuliŋuru ŋunhi ŋayi guyaŋina bunharawu nhanukalayŋuwu yolŋu'‐yulŋuwu. ");
INSERT INTO gnn_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","16","Bala Mawtjitjthunydja gonha'yurrunana Garraynha, bala marrtjina yarrupthurrunana ŋulaŋuru bukuŋurunydja, ga goŋdhunydja ŋayi marrtjina gäŋala bala ŋunhiyi märrma' bilkpilk guṉḏa maṉḏanha, yurru galiny'tja maṉḏanha ŋunhi wukirriwuy warrpam', rommirri maṉḏanha guṉḏa ŋunhiyinydja, wukirriwuy nhanukiyinguŋuna goŋbuynydja Gunhu'wuŋuna Waŋarrwuŋu. ");
INSERT INTO gnn_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Ŋe. Yarrupthurrunanydja maṉḏa marrtjina lili, roŋiyinana ŋulaŋuru bukuŋurunydja, Mawtjitj ga Djatjuwa, bala maṉḏa ŋäkula rirrakaynha yatjunminyarana ŋunha wäŋalilina. Ŋayi Djatjuwayunydja ḻakaraŋala Mawtjitjpana, “Dhika mari ya', wäŋaŋura,” bitjarra. ");
INSERT INTO gnn_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Bala ŋayi yukurrana Mawtjitjtja mäkiri'‐witjurrunana. “Nhaltjan dhika walala yukurra yulŋunydja? Yaka ŋunha rirrakay märr‐yiŋgathirrinydja yukurra, ŋula walala bumara miriŋunha, ga yaka ŋunha rirrakay nyä'yunmirrinydja yukurra, ŋula miriŋuwuŋunydja bunhara. Dhikanydja dhuwala manikay marrtji yukurra,” bitjarra. ");
INSERT INTO gnn_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Marrtjinana maṉḏa lili ga‐ga‐ga‐a‐a, gilitjina wäŋanydja, bala maṉḏa mel‐garwarrthinana, nhäŋala ŋunhi wakalŋuna wäyin buliki djingaryunara yukurranhara, ga ŋunhi yolŋu'‐yulŋunha, walala yukurrana giritjina ŋurikiyi buliki'wu. Bala wirrkina dhika ŋayi ŋaramurryina Mawtjitjtja, nhära'‐nharanana marrtjina. Bala ŋayi marrtjina ḏupthurrunana gay' ŋunhi rommirrinydja guṉḏa maṉḏanha munatha'lilina, gut bitjarra ḏaw'yurrunanydja ŋunhalana ŋoyŋurana wal'ŋu bukuŋura, liŋgu walala ŋathil'yurrunana ŋunhiyi ḏaw'yurruna romdja, Godkuŋu dhawu'‐nherraṉarawuynydja. ");
INSERT INTO gnn_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Bala ŋayi waṉḏinanydja ganydjarryuna, bala ḏur‐way ḏur'yurrunana ŋunhiyi buliki'nhanydja, bala yana ḏaw'‐ḏawyurrunana muṉguykuŋalana, bala gurthalilina warrkuḻuŋala batharana, bala djuḏul'yurrunana‐a‐a, buḻŋu'kuŋalana, bala gapulilina djalkthurruna, bala ŋayi Yitjuralpuyŋuwanydja ŋuripa yolŋu'‐yulŋuwa wekaŋala wurkthu'‐wurkthunarawuna. ");
INSERT INTO gnn_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Bala ŋuliŋurunydja dhurrwaraŋuru ŋayi bilyurruna Yärunguna, bala waŋana dhä‐wirrka'yurruna ŋanya bitjarrana, “Nhaltjarraŋga dhuwala walala Yitjuralpuyŋunydja yolŋu'‐yulŋu nhokalanydja? Nhäku warray nhe walalanha gur'yurrunanydja dhiyakuyi yätjkunydja romgu; Godthunydja dhuwala nhumalanha yurru dhä‐ḏir'yun warrpam'thunna, liŋgu dhuwalanydja mirithirrina yätjnha rom nhuma djäma.” ");
INSERT INTO gnn_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Bala ŋayi Yärundja waŋana Mawtjitjkala bitjarra, “Yaka nhe ŋarraku ŋaramurryiya nhäri'‐nhariya. Marŋgiŋga nhe walalaŋgu dhiyaku yolŋu'‐yulŋuwunydja, ŋunhi walala ŋuli yukurra ḏukṯukthirri yätjkuna bitjanarawu liŋgu. ");
INSERT INTO gnn_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Walala yawungu waŋa ŋarrakala bitjanna, ‘Nhe yurru miny'tji‐yarpuma ŋilimurruŋguway waŋarrnha, märr yurru ŋayina ŋilimurrunha gäma, bili dhikana Mawtjitjtja winya'yurruna, ŋunhi ŋayi ŋilimurrunha gäŋala ŋulaŋuru Yetjipŋuru.’ ");
INSERT INTO gnn_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Bala ŋarranydja yawungu waŋa walalaŋgala, ‘Ŋula yolthu yukurra balaŋu ḏälkuma garwarrwarr'mirri maryakal, walala yurru burrul'maramana,’ bitjanna. Bala walala yawungu rarr'yuna ŋarrakalana, bala ŋarranydja gurthalilina yawungu warrkuḻunha, bala marrtjinya yawungu dhuwala wakalŋuna buliki walmanha ŋulaŋuru gurthaŋurunydja.” ");
INSERT INTO gnn_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Ŋe. Mawtjitjtja marŋgithinana walalaŋgu ŋunhi walala goŋŋuru ŋurrkanhamina walalanhay walala, liŋgu Yärundhu yawungu nhänha walalanha gonha'yuna, gora wekanhana ŋuripa wiripu‐guḻku'wana yolŋu'‐yulŋuwa miriŋuwana. ");
INSERT INTO gnn_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Bala Mawtjitjtja ŋunhi djingaryurrunana yukurrana gali'ŋurana wäŋaŋura, bala ŋayi waŋana djawarrkthurrunana bitjarrana, “Yol walala dhika Garraywalanydja gali'ŋura? Ma', walala yurru ŋunhiyinydja walala marrtjina lili dhipalana ŋarrakalana.” Bala Lepaynydja bäpurru' yolŋu'‐yulŋu marrtjinana yurrum'thurrunana bukmaknha yana Mawtjitjkalana, ga walalanydja wiripu‐guḻkuny'tja yakana djälthina Godkalaŋunydja gali'lili wapthunarawu. ");
INSERT INTO gnn_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Bala ŋayi Mawtjitjtja waŋanana walalaŋgala ŋurikala Lepaywalanydja bitjarrana gam', “Garraynydja ŋunhi Yitjuralpuyŋuwunydja Waŋarr waŋa yukurra nhumalaŋgu bitjanna, nhuma yurru märra'‐marraŋa waŋga'‐waŋganydhu yiki nhumalaŋguway, bala marrtjiya yukirriya bukmakkurru wäŋakurru, buŋana marrtjiya ŋunhinydja walalanha yolŋu'‐yulŋunha ŋunhi walala yukurra ḏukṯukthirri wiripuŋuwu waŋarrwu.” ");
INSERT INTO gnn_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Bala Lepaynydja bäpurru yuwalkthi marrtjinana, nhanŋuwaynha dhärukku malthurruna Godkuna, bala bumarana marrtjina yolŋu'‐yulŋunha, rakunyguŋalana walalaŋguway walala gurruṯu'mirrinhana ga ḻundu'mirriŋunha walalanha walalambalay. Ga ŋuriŋiyinydja ḏaykun'thu guḻku'na mirithirri ḏarramuwurru murrmurryurrunanydja walalaŋguŋu bunharanydja. ");
INSERT INTO gnn_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Ga ŋuliŋurunydja Mawtjitj waŋana walalaŋgala Lepaywala bäpurru'wala, “Gäthuranydja nhuma liŋguna ganaŋ'maranharaminana nhumalanhay nhuma wiripu‐guḻku'walanydja yolŋuwala, nhumanydja yurru nhanŋuwaynha Garraywuna djämamirri yana. Ŋayi yurru nhumalanha ŋayaŋu‐ŋamathama dhiyaŋunydja‐wala, liŋgu nhuma ŋurrulili nherraṉmina Garraywalana, ganaŋ'maranhaminana ŋulaŋuru nhumalaŋgalayŋuwala gäthu'mirriŋuwalanydja ga gutha'mirriŋuwalanydja.” ");
INSERT INTO gnn_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Ga wiripuŋuyunydja ḏaykun'thu ŋayi Mawtjitj waŋana ŋurikala yolŋu'‐yulŋuwala Yitjuralpuyŋuwala, “Nhumanydja yätjkuŋala Garraynhana Waŋarrnhana, liŋgu yätjnha mirithirrina rom nhuma yawungu djäma. Ŋe, ŋarra yurru dhuwala marrtji Garraynhana withiyan, mak ŋarra yurru wekama ŋula nhä, nhumalanha ŋapatjkuma; ŋayi mak yurru nhumalaŋgu bäy‐ḻakarama ŋuriki yätjpuy, ga balayi märrama nhumalanha nhanukalayi ŋayi goŋlili.” ");
INSERT INTO gnn_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Bala Mawtjitjtja marrtjina roŋiyinayi Garraywala gumurr‐guwatjmara, bala ŋayi waŋana bitjarrana, “Garray, dhiyaŋu yolŋu'‐yulŋuyu ŋayaŋu‐yätjkuŋala nhuna, ŋutu' dhika yätj rom walala djäma yawungu. Walala miny'tji‐yarpunha yawungu walalaŋguway wakalŋunha waŋarrnha, bala buku‐ŋal'yunana yawungu. ");
INSERT INTO gnn_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Garray, bäy‐ḻakaraŋana walalaŋgu yanana ŋi, ŋuriki yätjpuynydja dhuwurrwuy. Ŋuli nhe yurru yakanydja bäy‐ḻakarama yäna‐wala, ŋarranhana nhe yurru ŋurrkaŋanydja walalanhanydja mali, yarrkmaraŋa ŋarranhana yäku dhipuŋuru nhokalay djorra'ŋurunydja.” ");
INSERT INTO gnn_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Yurru Garraynydja waŋana Mawtjitjkala bitjarrana, “Ŋunhi yolthu yukurra ŋayaŋu‐yätjkuma ŋarranha, ŋunhinhanydja dhuwurr‐yätjnha yolŋunha ŋarra yurru ŋurrkamana, ŋunhiyi ŋanyana ŋarra yurru yarrkmarama yäkunydja yolŋunha. ");
INSERT INTO gnn_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Gatjuy marrtjiyana. Nhenydja yurru gäŋana yolŋu'‐yulŋunhanydja ŋunhimalayina wäŋalili ŋunhi ŋarra liŋgu ḻakaraŋala nhokala. Ŋarrakala djiwarr'wuyyu watjarr'mirriyu yurru mel‐warryundja marrtji nhumalanha. Yurru ŋarra boŋguŋu marrtji warray yulŋunydja, withiyurru warray nhumalanha, bala ŋarra boŋguŋu walalanha dhä‐ḏir'yurruna ŋurikiy yätjpuynha rombuy.” ");
INSERT INTO gnn_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Bala ŋayi Garrayyu yätjkuŋalana wäŋana ŋuripa yolŋu'‐yulŋuwana, liŋgu walala miny'tji‐yarpuŋala wakalŋu buliki buku‐ŋal'yunarawu, ŋayi Yärundhu goŋdhunydja. ");
INSERT INTO gnn_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Ŋuliŋurunydja dhurrwaraŋuru ŋayi Garrayyu waŋana Mawtjitjnha, “Ḏurryurrana walala, bala marrtjiyana, nhe Mawtjitj ga bukmak dhuwali yolŋu walala ŋunhi nhe gäŋala walalanha ŋulaŋuru Yetjipŋuru. Ŋäthilinydja baman'tja gal'ŋu ŋarra ḻakaraŋala Yipurayimgala ga Yitjakkala ga Djaykupkala, dhawu'‐nherraranydja ŋarra bitjarra gam', ‘Ŋarra yurru wekama dhuwala wäŋa Gaynandja ŋuriki nhokalaŋuwuna mala‐wunharawuywu walalaŋgu,’ bitjarra ŋarra dhawu'‐nherraranydja ŋäthilinydja. ");
INSERT INTO gnn_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","3","Ga dhiyaŋunydja‐wala nhuma yurru marrtjina ŋunhimalayi wäŋalili, ŋunhi marrtji ŋorra guḻku' ŋatha ḻatju'mirri dhika ŋanya, gapu ga borum ŋula nhä malanha ŋunhilimi wäŋaŋura. Djuy'yundja ŋarra yurru djiwarr'wuynha djämamirrinha, ŋayi yurru nhumalanha mel‐warryundja, ga dhawaṯmaramana ŋarra yurru ŋunhi miriŋunhanydja walalanha bäpurru'nha ga bäpurru'nha, ŋupanna yurru ŋuliŋuruyi wäŋaŋuru. Yurru ŋarranydja yakana yurru ŋarrapinydja malthun marrtji nhumalaŋgu; ŋarra ŋuli gonhana baymatthurru rakunyguŋu nhumalanha, liŋgu nhuma dhuwala rom‐ḏälmirri yolŋu'‐yulŋu.” ");
INSERT INTO gnn_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Walala yolŋu'‐yulŋuyunydja Yitjuralpuyŋuyunydja ŋäkula dhäwuny'tja ŋunhiyi, bala walala warwuyunminana ga nyä'yunminana, yakana biyapul galŋa‐ŋamathina, ");
INSERT INTO gnn_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","liŋgu ŋayi Garrayyunydja ḻakaraŋala Mawtjitjkala bitjarra, “Nhumanydja dhuwala yolŋu'‐yulŋu gupa‐wuṉḏaŋarrmirrina. Ŋunhi ŋarra bini marrtjinya galkithinya nhumalaŋgala, nhumanydja bini ŋunhi murrmurryunana ŋuriŋi ŋarrakala ḏarrtjalkthuna djarraṯawun'thu. Burrul'maraŋana djalkthurrana nhokalay nhe dhuwali mel‐wiḏi'mirrinydja girri' malanha. Bilyurrana biyakana ŋayaŋunydja, wuyurrana nhokalayŋuwu nhe yätjkunydja, bala ŋarranydja yurru ḻiya‐ŋamaŋamayunmirrina nhaltjan ŋarra yurru nhumalanha.” ");
INSERT INTO gnn_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Bala walala ŋunhi yolŋu'‐yulŋunydja galŋa‐yätjthinyaminana, bala burrul'maraŋalana gulk‐gulkthurruna yana ŋunhiyi girriny'tja malanha, ŋunhi walalanha ŋuli ŋuriŋiyinydja girri'yu biyapulnha garrwarkunha. Ga dhurrwaraŋuru ŋuliŋurunydja, bala walala Yitjuralpuyŋuyunydja gonha'yurruna ŋunhi wäŋa Djäniyanydja buku, bala marrtjinana. ");
INSERT INTO gnn_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Ga ŋunhi walala ŋuli Yitjuralpuyŋu gulyu'‐gulyunna gandarrŋuranydja wäŋaŋura, ŋayinydja ŋuli Mawtjitjthunydja botjanha ḏalwaḏalwa' märr‐barrkumala ŋurikala walalaŋgala yarrkthuna wiripu‐guḻku'walanydja, ga ḻakaraŋalanydja ŋayi ŋunhiyi buṉbunydja yäku Withiyanminyarawuynha, liŋgu ŋunhiliyina maṉḏa ŋuli Mawtjitj ga ŋayipi Garray gumurr‐wunanhaminyanydja. Ga ŋunhi ŋuli ŋula yol yolŋu ḏukṯukthinya Garraywunydja bukumirriyanharawu, bala marrtjinya ŋayi ŋuli ŋunhimalayina buṉbulili. ");
INSERT INTO gnn_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Yo, ŋunhi ŋuli Mawtjitj gaŋgathinya bala marrtjinya djunama ŋunhimalayi buṉbulili, bukmaktja yolŋu'‐yulŋu ŋuli ḏurryunana, bala nhänha ŋanya yukurranha marrtjinyara nhinanhara bala, yana liŋgu ga gärrinya ŋayi ŋuli ŋunhimala buṉbulili. ");
INSERT INTO gnn_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Ŋunhi ŋayi ŋuli liŋguna gärrinyana buṉbulilina Mawtjitj, bala ŋayi ŋuli maŋandja marrtjinya lili yarrupthunana, bala djingaryuna ŋunhimalana bäymana dhurrwaralilina buṉbulili, bala Garraynydja ŋuli yukurranha waŋanhana Mawtjitjkala ŋuliŋuru maŋanŋurunydja. ");
INSERT INTO gnn_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Ga ŋunhi ŋuli walalanydja yolŋu'‐yulŋuyunydja nhänha maŋandja djingaryunara, bala walalanydja ŋuli marrtjinya buku‐nyilŋ'thunana gay' munatha'lilina buku‐ŋal'yunana. ");
INSERT INTO gnn_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Ŋe. Garraynydja ŋuli waŋanha yukurranha Mawtjitjkala bitjanana liŋgu galŋa'‐galŋana, bitjana yana liŋgu bitjan ŋuli yolŋu maṉḏa ḻundu'manydji waŋanhamirri. Ga ŋuliŋurunydja dhurrwaraŋuru ŋayi ŋuli Mawtjitjtja marrtjinya roŋiyinya wäŋalilina, yurru balpara'mirrinydja Djatjuwanydja nhanŋu ŋunhalana bäymana ŋuli yukurranha nhinanha buṉbuŋurana. ");
INSERT INTO gnn_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Yo, ŋayi Mawtjitjtja waŋanana Garraynha bitjarrana, “Nhenydja yawungu ŋarrakala waŋanha marrtjinyarawu muka, gänharawu dhiyaku yolŋu'‐yulŋuwunydja, yurru nhe yaka ḻakaraŋala ŋarrakala ŋula yolnha yolŋunhanydja nhe yurru djuy'yun bämarany'tja ŋarraku, guŋga'yunaramirrinhanydja. Nhenydja ḻakaraŋala, nhenydja ŋarraku marŋgi muka be, ga ŋarrakala nhe ŋayaŋu‐ŋamathirri muka yukurra be. ");
INSERT INTO gnn_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Ŋuli nhe yukurra yuwalktja ŋayaŋu‐ŋamathirri ŋarraku, ga milkuŋana ŋarrakala nhuŋuway dhukarrnha, märr ŋarra yurru marŋgithirrina nhuŋu, ga ŋayaŋu‐ŋamathinyamirriyamana nhuna. Ga guyaŋiya muka biyaka, liŋgu nhuŋuway ŋunhayinydja walala yolŋu'‐yulŋu.” ");
INSERT INTO gnn_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Bala Garraynydja waŋana nhanukala Mawtjitjkala bitjarra, “Yo, malthunga ŋarra yurru nhuŋu yulŋunydja, bala nhe yurru nhinana ŋayaŋuna ŋarrakala,” bitjarra. ");
INSERT INTO gnn_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Ga ŋayi Mawtjitjtja waŋana Garraywala buku‐ruŋiyinmaraŋala bitjarra, “Ŋuli bini nhe yakanydja marrtjinya malthuna ŋanapurruŋgu, yaka ŋanapurrunha djaw'yurra dhipuŋurunydja wäŋaŋuru. ");
INSERT INTO gnn_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Ŋuli nhe bini yakanydja marrtjinya ŋanapurruŋgu malthuna, nhaltjan yurru yolŋunydja walala marŋgithirri, ŋunhi nhe yukurra ŋayaŋu‐ŋamathirri ŋanapurruŋgunydja? . . . ŋarraku ga dhiyaku nhokalaŋuwu miṯtjiwu? Ŋanapurrunydja dhuwala liŋguna gänana ŋulaŋuru wiripu‐guḻku'walanydja miṯtjiwala birrka'mirriwala bäpurru'wala, ganaŋ'thunna yukurra ŋuriŋina ŋunhi nhe galki ŋanapurruŋgala, gäma yukurra ŋanapurrunha.” ");
INSERT INTO gnn_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Bala Garraynydja waŋana Mawtjitjkala bitjarra, “Ŋarra yurru djämana‐wala yana ŋunhi nhe nhäku ŋäŋ'thurruna, liŋgu ŋarra yukurra ŋayaŋu‐ŋamathamanydja nhuna, ga marŋgina ŋarra nhuŋu yäkuwu.” ");
INSERT INTO gnn_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Bala Mawtjitjthunydja bukukurru waŋanana, “Garray, ŋarra ḏukṯuk nhe yurru ŋarrakala milkunharamiya nhunapinyay nhe ŋunhi nhenydja djeŋarra'na gal'ŋu; ŋarra yurru nhuna nhämana.” ");
INSERT INTO gnn_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Ga ŋayi Garraynydja waŋana Mawtjitjkala bitjarra, “Ŋarra yurru marrtji djuḻkthunmarama nhunanydja ḻatju'yuna, ga ḻakaranharamirrinydja ŋarra yurru ŋarranhawuy ŋarra yäkunydja nhokala, ");
INSERT INTO gnn_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","yurru yakana nhe yurru ŋarranha nhäma bukunydja. Ŋula yolthu yurru ŋuli nhäma ŋarranhanydja buku, mel‐ŋal'yun ŋarrakalanydja, ŋayinydja yurru ŋunhiyinydja yolŋu rakunydhirrina. ");
INSERT INTO gnn_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Nhe yurru djingaryundja dhiyala guṉḏaŋura ŋarrakala galki, ");
INSERT INTO gnn_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","bala ŋarranydja yurru nhuna ŋurrwu'yunmarama ŋunhimala ḏaw'yunarawuylili guṉḏalili, gungamanydja nhuna yurru ŋarrakalay ŋarra goŋdhu, ga bäy ŋarra yurru djuḻkmarama nhuna. ");
INSERT INTO gnn_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Bala ŋarra yurru djaw'yunmirrina goŋdja, bala nhe yurru ŋarranha nhämanydja ḏiltjina, yurru yakana nhe yurru nhäma bukunydja ŋarranha.” Ga bitjarra ŋayi Garrayyu Godthu waŋananydja Mawtjitjnha. ");
INSERT INTO gnn_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Ŋe. Bala Garrayyu waŋana Mawtjitjnha bitjarra, “Gulkthurra märrma'kuŋa bilkpilk guṉḏa maṉḏanha, bala ŋarra yurru wukirrina ŋunhimalayi guṉḏalilinydja maṉḏanyŋulili, ŋunhiyi yana liŋgu dhäruktja malanha ŋunhi ŋarra ŋäthili wukirri, bala nhe ḏaw'yuna warray yawungu. ");
INSERT INTO gnn_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Marrtjinydja nhe boŋguŋu goḏarr'nha munhakumirrina, ḏuwaṯthurru bukulili Djäniyalilinydja, bala gumurr‐watjmulu ŋarranha ŋunha bukulili, garrwarlilina wal'ŋu. ");
INSERT INTO gnn_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Yaka boŋguŋu wiripunydja yolŋu malthurru nhuŋu, ga yaka yurru yolŋu walala yukurra nhina ŋunhala ŋoyŋuranydja galkinydja bukuŋura; walala yurru yarrkthun dhipuŋuru, barrkulili gäma walalaŋguway wäyinnhanydja walalanha.” ");
INSERT INTO gnn_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Bala yuwalkthi Mawtjitjthunydja mitthurruna märrma' bilkpilk guṉḏa maṉḏanha, bala wiripuŋuyunydja ḏaykun'thu ŋayi Mawtjitj gaŋgathina munhakumirrina, bala marrtjinana, ḏuwaṯthurruna bukulilina, gäŋalanydja ŋayi marrtjina goŋdhunydja ŋunhiyi märrma' guṉḏa maṉḏanha. ");
INSERT INTO gnn_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Bala Garraynydja marrtjina lili yarrupthurrunana maŋangurruna, bala ŋayi djingaryurruna ŋunhimala galki Mawtjitjkalana, bala ŋayi yukurrana ḻakaranharaminana ŋanyapinyay ŋayi yäkuna Garray. ");
INSERT INTO gnn_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Ŋe, djuḻkmaraŋalana ŋayi Garrayyu, bala yäkuna ḻakaranharamina bitjarrana gam', “Ŋarranydja dhuwala Garray God Ŋurruŋu wal'ŋu dhika, ga mel‐wuyunaramirri Waŋarr, ga yuwalk yana. Ŋarra ŋuli bulnha galkunmirri yolŋu'‐yulŋuwunydja, yaka ŋarra ŋuli waḏutjanydja‐wala dhä‐ḏir'yun walalanha, liŋgu ŋarrakuŋunydja dhawu'‐nherraṉara yurru yukurra djingaryun gupaḏalnha‐wala yanana, djambimiriwnha. ");
INSERT INTO gnn_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Guḻku'yuna yurru yolŋu'‐yulŋuyu dhäkay‐ŋämanydja ŋarraku märr‐ŋamathinyaranydja, bili ŋarra ŋuli bäy‐ḻakarama ga buwayakkuma walalaŋgu baḏatjunara yätjpuynydja dhuwurrwuy. Yurru yuwalk ŋarra yurru dhä‐ḏir'yundja ŋunhinhanydja yolŋunha ŋunhi ŋayi baḏak yukurra mulka nhanŋuway yätj dhuwurr, ŋayinydja yurru ŋunhiyinydja yolŋu ga nhanbala yumurrku', ga nhanukalayŋuwa yumurrku'wa yumurrku', walala yurru yana raku'‐rakunydhirrina, liŋgu yätjthuna ŋuriŋiyina nhanukalay.” ");
INSERT INTO gnn_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Bala ŋayi dhunupana Mawtjitjtja buku‐nyilŋ'thurrunana, bala buku‐ŋal'yurrunana, ");
INSERT INTO gnn_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","bala ŋayi bukukurru waŋananydja bitjarrana, “Garray, ŋuli nhe yukurra ŋayaŋu‐ŋamathirri ŋarrakunydja, go marrtjiya ŋanapurruŋgala galkithiya, ga gäŋana yukirriya ŋanapurrunha. Yuwalk warray dhuwala yolŋu'‐yulŋunydja gupa‐wuṉḏaŋarrmirri, yurru ŋanapurrunydja ḏukṯuk, nhe yurru bäy‐ḻakaramana ŋanapurruŋgu yätjpuynydja, ga märraŋana ŋanapurrunha nhuŋuwayliliyaŋana; ŋanapurru yurru nhuŋuwaynha yolŋu'‐yulŋu.” ");
INSERT INTO gnn_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Ga Garraynydja waŋana bitjarra, “Ŋarranydja yukurra dhuwala dhäruk‐nherraṉmirrina nhumalaŋgu Yitjuralpuyŋuwunydja. Nhuma yurru nhämana, ŋarra yurru djämanydja ḻatju'na dhikana rom, ganydjarr ḏumurruna dhikana wal'ŋu; yakana ŋula ŋäthilinydja maḻŋ'thurruna balanyarayi rom dhiyala munatha'ŋuranydja. Ga bitjarrayi bili wiripu‐guḻku'yunydja bäpurru'yu bukmakthu yurru nhämana ŋarrakuŋu barrari‐wukunharamirrina djämawuy, liŋgu ŋarranydja yurru dhiyalayi nhumalaŋgala muka, nhumalaŋgala muka wapthun. ");
INSERT INTO gnn_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","“Ŋe. Nhumanydja yurru märramana ŋarranhanydja dhäruk, bala djämana‐wala yurru nhaltjan ŋarra yukurra rom‐nherraṉ nhumalaŋgu dhiyaŋu‐wala. Ŋarra yurru gukuma dhawaṯmaramana ŋunhi mulku'‐mulkurunhanydja bäpurru'nha yolŋu'‐yulŋunha, yakana yana walala yukurra yurru nhina dhambay‐manapanmirri nhumalaŋgala ŋunhalayinydja wäŋaŋura, ŋunhi nhuma yukurra bala guwatjman ŋunhayi. ");
INSERT INTO gnn_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Yaka yana nhuma yurru dhawu'‐nherraṉmirrinydja walalaŋgala, ŋurikala mulku'‐mulkuruwalanydja yolŋu'‐yulŋuwala ŋunhi walala yukurra nhina ŋunhayi wäŋaŋura. Ŋuli nhuma yurru ḻunduthirrinydja walalaŋgu, nhumalanhanydja yurru ḏapmarama ŋuriŋiyi walalaŋgala yätjthuna romdhu. ");
INSERT INTO gnn_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Nhumanydja yurru yana ḏaw'‐ḏawyurrana walalambala waŋarrnhanydja walalanha, warrpam'thurrana yana bak‐bakmaraŋa muṉguykuŋana, ga biyakayi liŋgu ḏaw'‐ḏawyurra walalaŋgu ŋunhi maḏayin'tja malanha, ga wäŋanydja ŋunhi walalaŋgu ŋärrany'tja dhuyunydja. ");
INSERT INTO gnn_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","“Ŋe. Nhuma yurru ḏaw'‐ḏawyurrana warrpam'thurrana, liŋgu ŋarrapi dhuwala Garray nhumalaŋgunydja Waŋarr God, waŋganynha yana, ga nhumanydja dhuwala ŋarrakuwaynha mel‐winya'mirrina yolŋu walala. ");
INSERT INTO gnn_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","16","“Ŋuli nhuma yurru märr‐ŋal'yun yukurra wiripuŋuwunydja waŋarrwu, ŋunhinydja nhe balanyarana yolŋu bitjan marramba'mirrina dhäyka. Yo, ŋunhi nhuma yurru gärrinydja ŋunhimalayi wäŋalilinydja, nhuma yurru yaka dhawu'‐nherraṉmiyanydja walalaŋgala nhinanharawu waŋgany‐manapanminyarawunydja; nhuma yurru walalanha bumana marrtji yulŋunydja yanana, gukumana yurru dhawaṯmaramana, liŋgu walala ŋuli gonhana gur'yurru nhumalanha, nhuma ŋuli balaŋu buku‐ŋal'yurru walalaŋgalaŋuwuna ŋurikina waŋarrwu. Liŋgu nhumanydja dhuwala ŋarrakuway yana walala; yaka nhuma yurru wekanhamirri wiripuŋuwanydja waŋarrwa, biyakanydja bitjan ŋuli marramba'mirriyu dhäykayu gonha'yun nhanŋuway dhuway'mirriŋunha, bala wekanhamirri wiripuŋuwana ḏarramuwa. Yo, yakana yana buku‐wurrpalanydja wekaŋa ŋula nhänydja walalaŋgalaŋuwunydja waŋarrwu, ga ŋunhi walala yurru giritjirri yukurra walalaŋgalaŋuwu waŋarrwu buku‐ŋal'yun, ga buku‐manapanmirri ŋathawunydja ḻukanharawu, ga yakana nhumanydja mam'thurra walalaŋgala ŋula buŋgullilinydja. Yaka yana nhumalaŋgala yawirriny'thunydja yurru märrama dhäykawurrunha ŋulaŋuru wiripuŋunhanydja bäpurru'nha, liŋgu dhiyaŋiyinydja dhäykawurruyu yurru nhumalaŋgu yumurrku'nhanydja bilmarama walalaŋgalaŋuwuna waŋarrwu buku‐ŋal'yunarawu. ");
INSERT INTO gnn_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Ga yaka djäma ŋula nhä dhuyu mali buku‐ŋal'yunarawu.” ");
INSERT INTO gnn_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","26","Ga wiripunydja malanha rom bitjarrayi Garrayyu wekaŋala marrtjina nhanukalayŋunydja ŋayi yolŋu'‐yulŋuwu. ");
INSERT INTO gnn_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Bala dhä‐yawar'yurrunanydja ŋayi Garray waŋana Mawtjitjkala bitjarrana, “Ma', wukirrina dhuwalayinydja dhäruk, liŋgu dhiyaŋunydja dhärukthu ŋarra yukurra dhuwala dhawu'‐nherraṉmirrina nhumalaŋgunydja Yitjuralpuyŋuwunydja, nhumanydja yurru ŋarrakuwaynha yanana yolŋu walala; dhäruk‐märranharamirri walala nhuma yurru yana yulŋunydja, bala ŋarranydja nhumalaŋgu yurru waŋarr Godnha, gämanydja ŋarra yurru yukurra nhumalanha ḻatju'kumana dhikana.” ");
INSERT INTO gnn_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Ga ŋunhiliyi bukuŋuranydja ŋayi Mawtjitj nhinanana yukurrana märr‐weyinnha Garraywala ŋoy‐ŋathamiriwnha ga ŋoy‐gapumiriwnha, yana liŋgu ga 40 munhanydja nhanŋu ŋunhiliyinydja. Bala yana ŋayi wukirrina marrtjina ŋunhimalayi guṉḏalilina maṉḏaŋulili ŋunhiyi dhawu'‐nherraṉminyara dhäruk, ŋunhiyi rom malanha ḏämbumirri ga ḏämbumirri ŋunhi ŋayi Garrayyu nhanbala wekaŋala. ");
INSERT INTO gnn_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Yo, dhawar'yurrunanydja ŋayi Mawtjitj ŋuliŋuruyi, bala yana dhunarranana marrtjina, gäŋalana ŋunhiyinydja maṉḏanha dhärukmirrinydja makarrmirri guṉḏa maṉḏanha, yarrupthurrunana marrtjina bala wäŋalilina roŋiyina, yurru bukunydja ŋayi wiripuŋuyinana dhikana, djarraṯawun'nha yanana, liŋgu ŋayi yukurrana waŋana galkina, maṉḏa Garraynha waŋanhamina, yurru yaka ŋayi marŋgi ŋurikiyi bukuwunydja nhanŋuway ŋayi. ");
INSERT INTO gnn_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Ga walalanydja Yärundhu ga wiripu‐guḻku'yu ŋuriŋi yolŋu'‐yulŋuyu nhäŋalana ŋanya Mawtjitjnha marrtjinyarana lili, djarraṯawun'thinyarana bukunydja dhikana ŋanya nhäŋala, bala walala wirrkina dhika barrarinanydja nhanbala, ga yakana wäŋgaŋala withiyaranydja ŋanya. ");
INSERT INTO gnn_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","32","Bala ŋayinydja Mawtjitjtja dhunupa wäthurrunana walalaŋgu, bala walala withiyarana marrtjina wäŋgaŋalana bala, Yärun ga wiripu‐guḻku' ŋaḻapaḻmirri, ga bukmak yolŋu walala, bala ŋayi wekaŋalana walalaŋgu bukmaknha ŋunhiyi romdja malanha, ŋunhi nhanukala ŋayi Garrayyu wekaŋala ŋunhala bukuŋura yäkuŋura Djäniya. ");
INSERT INTO gnn_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Ga ŋunhi ŋayi dhawar'yurrunanydja waŋanharaŋuru Mawtjitj, bala ŋayi bukulilina nherrara buyu‐ruwaŋga'na girri', dhaḻ'yunmina ŋanyapinyay ŋayi bukuna. ");
INSERT INTO gnn_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Yo, ŋunhi ŋayi ŋuli marrtjinya bala Withiyanminyarawuylilinydja Buṉbulili, bala ŋunhalanydja ŋayi ŋuli yupmaranhana ŋunhiyi bukuwuynydja girri' ŋäkirrmaranhara, bala waŋanha ŋuli Garraywalanydja buku‐warraŋulyuna yukurranha, yana liŋgu ga dhawaṯthuna ŋayi ŋuli. Bala ŋayi ŋuli ḻakaranhana walalambala yolŋu'‐yulŋuwanydja ŋunhi nhaltjana ŋayi ŋuli Garrayyu ḻakaranha nhanukala; ");
INSERT INTO gnn_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","walala ŋuli nhänhanydja ŋanya bukunydja djarraṯawun'thinyarana, bala nherraṉana ŋayi ŋuli roŋiyinyayi bukulili nhanukiyingalay ŋayi ŋunhiyi girri'nha. Bitjanana liŋgu ŋayi ŋuli marrtjinya yukurranha ŋurikimirrina yana, yana liŋgu ga marrtjinya ŋayi ŋuli Garraywala waŋanhaminyarawu. ");
INSERT INTO gnn_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","29","Bitjarrana ŋayi Mawtjitjthu waŋana yolŋu'‐yulŋunhanydja, bala walala gundupuŋalanydja, bala yana wapmaraŋalana marrtjina, bala dhunupana gäŋalanydja Mawtjitjkalana, walala ḏukṯukthinanydja wirrkina Garraywunydja gumurr‐wekanharawu; yana walala marrtjina wekaŋalanydja ŋunhi yänana girriny'tja malanha, ŋunhiyi mel‐wiḏi'mirrinydja dhikanydja girri' Godkalaŋunydja buṉbuwu. Ga gaḏamanmirriyunydja dhäykawurruyu yukurrana djäma goŋdhuna walalawuynha ḻatju'mirrina dhomala dhikana, miny'tji‐guḻku'mirrina. Ga bukmakthuna yolŋu'‐yulŋuyu Yitjuralpuyŋuyunydja buku‐wurrparanydja gäŋala girriny'tja malanha, ḏarramuwurruyu ga dhäykawurruyu ga djamarrkuḻi'yu, marrtjinanydja walala gäŋalanydja, yanana marrtjina rarr'yurrunana Garraywuna, ŋurikiyi buṉbuwuna, ŋunhi ŋayi Mawtjitjkala ḻakaraŋala yukurrana ŋunhala. ");
INSERT INTO gnn_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","35","Bala ŋayi Mawtjitjthu waŋanana bitjarrana, “Nhäŋa dhuwala ḏarramunha gay', Betjalilnha yäkunha, ŋayinydja dhuwalayinydja djarr'yunara Garraywuŋuna yana, ŋayinydja yurru dhuwalayinydja buŋgawana dhiyakuyi bukmakkuna djämawu, liŋgu Garrayyu ŋanya liŋguna dhaŋaŋguŋalana nhanukalay ŋayi Birrimbirryu ŋuriŋi Walŋamirriyunydja, märr dhiyaŋuyina ganydjarryu ŋayi yurru djäma bukmakkumanydja, ḻatju'kumanydja dhikanydja yurru. Ga wiripu‐guḻku'wunydja ŋayi bitjarrayi ganydjarr wekaŋala Garrayyu, märr walala yurru guŋga'yun ŋanya yukurra, ḻatju'kuma yana dhika djäma. ");
INSERT INTO gnn_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“Yo, walala yurru ŋuriŋiyi yolŋu'‐yulŋuyu djämanydja djan'kukuma yana ŋunhi nhaltjarra ŋayi Garrayyu yukurrana ḻakaraŋala.” ");
INSERT INTO gnn_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Bala walalanydja ḏarramuwurruyunydja ŋuli yukurranha djämanydja, ");
INSERT INTO gnn_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","ga bitjana liŋgu walala yolŋu'‐yulŋuyunydja ŋuli yukurranha gänhana ḻatju'na girri' ŋulaŋuru wäŋaŋurunydja, dhuḏikurru‐ŋäthilina, biyapulnha marrtjinya bukulili ŋal'maranha. ");
INSERT INTO gnn_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Bala walala ŋunhi djämamirriyunydja walalay waŋana Mawtjitjnhana, ");
INSERT INTO gnn_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","“Way, liŋguna dhuwala, gana'na yulŋunydja. Bala walalanydja yukurra yolŋu'‐yulŋuyunydja mukthun warray gäma lili,” bitjarra. ");
INSERT INTO gnn_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Bala ŋayi Mawtjitjthunydja djuy'yurruna dhäruknha djunuma wäŋalilinydja, “Liŋguna dhuwala, gana'na yulŋunydja. Yakana biyapulnydja walala gäŋa lili.” Bala walala yolŋu'‐yulŋunydja ḏaḏawyurrunana; yakana biyapulnydja gäŋala, ");
INSERT INTO gnn_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","ŋunhina liŋgu walala ŋunhi buku‐waŋganynha gäŋalanydja, gana'na yana ŋuriki djämawu dhawar'maranharawuna. ");
INSERT INTO gnn_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","38","Yo, djämanydja walala yukurrana ŋunhiyi Garraywu buṉbunydja ŋuriŋiyi Betjalilyu ga wiripu‐guḻku'yu gaḏamanmirriyu ḏarramuwurruyu, djämanydja walala yukurrana ŋunhiyi dhomalany'tja ḻatju'na miny'tji‐maypamirrina, milkuminy ga ḻingarryinyara ga miku. Ga bitjarrayi walala liŋgu djämayi lanapuny'tja dharpa ŋal'‐ŋalmaraŋala marrtjina ŋurikiyi buṉbuwunydja, bala ŋäkirrmaraŋalana ŋunhiyi waḏaŋgany'tja warrpam'thurruna yana monyguŋala ŋuriŋiyinayi miny'tjimirriyuna dhomala'yu, bala ŋäkirrmaraŋala ŋapa‐ŋayŋunydja ŋunhiyi gaywaraŋu'yuna dhomala'yu. Ga biyapulnydja walala wäyinnha barrwaṉ buyu‐wuṉḏaŋarrnha miku'kuŋala miny'tji djäma, bala yana ŋapa‐ŋäkirrmaraŋalana ŋunhi gaywaraŋu'nhanydja, ga biyapul warraŋullilinydja warrpam'thurrunana buku‐ŋäkirrmaraŋala wäyingalana barrwaṉ'thu ŋuriŋina ḏälyuna wal'ŋu. Ga bitjarrayi liŋgu walala yukurrana djäma dhomala ŋurikiyi djinawa'wunydja wäŋawu dhuyuwunydja, bala dhaŋganhamirriyaŋalanydja ṉapuŋga'kurru yana, ganaŋ'maraŋala ŋärra' wal'ŋu ŋunhiyi Godku nhanŋuway dhaḻakarr. ");
INSERT INTO gnn_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","9","Ga bitjarrayi liŋgu walala djämayi ŋunhiyi Dhawu'‐nherraṉminyaranydja Bathi, ga dhurrwaranydja ŋurikiyi bathiwu, ŋunhiyina Mel‐wuyunaramirrina dhaḻakarr yäku, ga djämayi ŋayi mali yolŋunhanydja maṉḏanha, djiwarr'wuynhanydja maṉḏanha, gumurr'yunminyara nhinanhara, binbarrnydja bärr'yunmaraŋala ŋunhi Mel‐wuyunaramirrinhanydja yukurrana monyguŋala. ");
INSERT INTO gnn_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","29","Ga bitjarrayi ŋayi djäma ŋathawuynydja bala'palanydja, ŋurikiyinydja dharrpalwunydja ŋayaŋay'wu, märrma' ruluwu ga märrma' bäythinyarawuywunydja ŋuriki; ga wiripu lanhdhirra'wuy garwarrwarr' ŋayi djämayi nhära'‐nharanharawu, djarraṯawun' wekanharawunydja. Ga bitjarrayi ŋayi djäma buŋgangu bäw'wunydja dhaliyarra' märr‐nyumukuṉiny', märr yukurra yurru ŋayi gaŋgathirri buŋgan bäwny'tja ŋulaŋuruyi bitjanna liŋgu yurru Garraywu. Ga bitjarrayi ŋayi djämayi weyikany'tja ŋurikiyi lanhdhirra'wunydja, ga djämayi ŋayi buŋgan bäwny'tja bathanarawunydja. ");
INSERT INTO gnn_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","8","Yo, ga bitjarrayi liŋgu ŋayi djäma yana dhaliyarra' yindinydja wal'ŋu, wäyingunydja bathanarawu, ga yindi wal'ŋu banikin rurrwuyunminyarawu, yurru walala ŋunhi banikin bathalanydja djäma ŋulaŋuru djambaka wal'ŋu bitjan djarrami'yinyara, ŋunhi ŋuli walala dhäykawurru nhänharaminya yukurranha walalanhawuy walala ŋunhimalayi. ");
INSERT INTO gnn_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","20","Ga bitjarrayi liŋgu walala djämayi gunganhamirriyaŋala ḻoḻunydja ŋunhiyi buṉbunha, dhaŋganhamirriyaŋala marrtjina ḻiw'maraŋalanydja ŋuriŋina dhomala'yuna buyu‐wuṉḏaŋarrmirriyuna yana gungaŋala warrpam'thurruna, märr yurru walala yolŋu'‐yulŋu gulŋiyirri yukurra ŋuliwitjan dhurrwarakurrunydja ŋunha djinawa'lilinydja dhaḻakarrlili, buku‐ŋal'yunarawuna nhanŋu Godkuna. ");
INSERT INTO gnn_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","31","Ga bitjarrayi liŋgu walala maryakalnydja djäma ḏalkarra'mirriwunydja walalaŋgu, gäna wal'ŋu girri', märr walala yurru gärri yukurra ŋunhimala Ganaŋ'maranharawuylili Wäŋalili, Garraynha gumurr‐watjman ŋurikimirrinydja girri'mirri yana. Ga nhanŋu Yärungunydja walala djäma ḻatju' girri' dhika wal'ŋu, miny'tjimirri, yurru nhanŋunydja ŋunhi girri' gäna yana nhanŋuway wal'ŋu ŋurikiyi ŋurruŋuwu ḏalkarra'mirriwu. Yurru mayali'mirri ŋunhiyi girriny'tja bukmaknha yana ŋunhi walala yukurrana djämanydja. ");
INSERT INTO gnn_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","43","Yo. Djämanydja walala ŋunhi bukmaknha yana, dhawar'maraŋalana warrpam'nha, balanyarana liŋgu ŋunhi yulŋunydja djan'ku yana bitjarra ŋayi Garrayyu ḻakaraŋala yukurrana Mawtjitjkala. Yo, dhawar'maraŋalanydja walala bukmakkuŋala yana, bala yana ŋuliŋurunydja waŋgany‐mana'manaparanydja. Bala Mawtjitjthunydja nhäŋa'‐nhaŋalana marrtjina mala‐yarr'yurrunana, nhäŋalanydja marrtjina ḻatju'mirri warray dhika yana, ŋulinyara yana bili ŋunhi ŋayi Garrayyu ḻakaraŋala yukurrana. Bala ŋayi Mawtjitjtja wokthurrunana wirrkina walalambala, buku‐wurrpara ŋurikiyyi djämawuynydja. ");
INSERT INTO gnn_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","15","Bala ŋayi Garraynydja waŋana Mawtjitjkala bitjarrana, “Gatjuy ŋal'maraŋunydja nhuma boŋguŋu dhuwali buṉbunydja ŋarraku, bala nherru'‐nherruluna marrtji bukmakkuŋuna djinawa'lilina, bala ŋämiluna marrtji weyika'yuna ŋunhiyi malanha bukmakkuŋuna yana, ganaŋ'maraŋuna ŋunhiyinydja ŋarrakuwaynha wal'ŋu. Ga biyakayi gäŋa Yärunnhanydja ga nhanŋu gäthu'mirriŋunha walalanha ŋunhamala dhurrwaralili wal'ŋu ŋunhi buṉbulili, nhuma yurru walalanha ganaŋ'marama ŋunhiliyinydja, märr yurru walala ŋarrakuway yana ḏalkarra'mirri walala gupaḏalnha‐wala.” ");
INSERT INTO gnn_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","29","Bala ŋayi Mawtjitjthu djämanydja bukmakkuŋalana yana, bitjarrana liŋgu yana ŋunhi Garrayyu nhanukala ḻakaraŋala; walala djäma ŋunhiyinydja buṉbu, bala nherra'‐nhirrarana marrtjina ŋunhiyi dharrpalnydja malanha girri' ŋunhiwalana wal'ŋu djinawa'lilina buṉbulili. Rulwaŋdhurrunanydja ŋayi dhuyuna rruthi, ŋathanydja ŋunhiyi 12 ŋunhiwala bala'palalilinydja, ga bitjarrayi liŋgu lanhdhirrany'tja ŋayi dhuŋgur'yurrunana, ga bitjarrayi liŋgu ŋayi djalkthurruna buŋgan bäwny'tja ŋunhimalayi yutjuwaḻa'lili dhaliyarra'lili, märr yurru ŋayi yukurra ŋunhi buŋgan ŋawululny'tja gaŋgathirrina nhanŋu Garraywuna. Ga bitjarrayi liŋgu ŋayi nherrara banikin ŋunhi bathalanydja wal'ŋu ŋuriki rurrwuyunminyarawunydja ga barŋ ŋunhiyi, maṉḏa yukurrana ŋunhiyi dhärrananydja ga warraŋul ŋunhili buṉbuŋura, dhurrwaraŋura wal'ŋu, yurru ḻoḻunydja ḻiw'maranhara gunganhara ŋunhi. ");
INSERT INTO gnn_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","32","Bala ŋayi Mawtjitjthu rarr'yurruna gapuna ŋunhiwalayinydja banikin'lili yindililinydja, bala garr'yurruna gäŋalanydja Yärunnhana ga gäthu'mirriŋunha walalanha, bala walala yukurrana rurrwuyunminana ŋunhiliyinydja ŋarambiya'na ga djalkirina. Yo, bitjana liŋgu walala ŋuli rurrwuyunminyanydja ŋäthilinydja, yurruna walala yurru gulŋiyirri ŋunhimalayi buṉbulilinydja, ga marrtji galkithirri ŋunhimala barŋlili. ");
INSERT INTO gnn_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Yo, ŋayi Mawtjitjthu nherra'‐nhirrarana ŋunhiyi ḻoḻunydja ḻiw'maraŋalana yanana ŋunhina buṉbunhanydja, bala djäma dhurrwaramirriyaŋalana. Ga bitjarrayina ŋayi ŋunhi dhawar'maraŋalanydja warrpam'thurruna yana. ");
INSERT INTO gnn_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Bala ŋayi ŋunhiyi maŋandja dhunarranana dhunupana yana, bala ŋäkirrmaraŋalana ŋunhi wäŋanhanydja buṉbunhanydja, bala yana ŋunhi djinawany'tja dhaŋaŋdhinana warrpam'nha ŋayipina djarraṯawun'thuna, ḻatju'yuna dhikana, ga wäŋanydja ŋunhi warrpam'nha djeŋarra'yina nhanukiyingalana ŋayi baḏayala'yu. ");
INSERT INTO gnn_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Yakana ŋayi Mawtjitj gulŋiyinanydja ŋunhimalayi buṉbulilinydja, liŋgu Garrayyunydja ŋayipinydja ŋuriŋi djarraṯawun'thunydja warrpam'nha dhikana gungaŋala ŋunhiyi buṉbunhanydja. ");
INSERT INTO gnn_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Ga bitjanana liŋguna maŋandja ŋunhiyi ŋuli yukurranha djingaryunana yana ŋunhilina bäyma buṉbuŋurana. Wiripunydja ŋuli ŋunhiyi waŋupini yana gaŋgathinya, bala dhawuṯthunana, bala walala ŋuli yolŋu'‐yulŋunydja ŋunhiyi ḏurryunana, dhoṯkunhana marrtjinya girriny'tja, bala yana wäŋganhana ŋuli, malthunana ŋurikiyina maŋanguna, ŋunhi ŋayi ŋuli ŋurru‐warryunna walalanha. ");
INSERT INTO gnn_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Ga ŋunhi ŋayi ŋuli maŋan ŋunhiyi yaka gaŋgathinya, walalanydja ŋunhiyi yolŋunydja walala ŋuli nhinanha yukurranha ŋunhili bäyma wäŋaŋura, yana liŋgu ga biyapul ŋayi ŋuli ŋunhiyi gaŋgathinya maŋan. ");
INSERT INTO gnn_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Bitjarrana liŋguna ŋayi yukurrana walalanha monyguŋalana yulŋunydja ŋuriŋiyi Garraywalaŋumirriyunydja waŋupini'yu, ŋunhi walala yukurrana marrtjina bala. Ga walu‐ŋupananydja ŋayi yukurranha maŋandja ŋuli djingaryunana yana ŋunhilimi Ganaŋ'maranharawuyŋuranydja Buṉbuŋura, ga munhakunydja ŋayi ŋuli ŋunhiyi maŋan wiriputhinyana bitjanana bitjan ŋuli gurtha nhäranha waŋupini'ŋura. Ga bukmakthu ŋuriŋiyi yolŋu'‐yulŋuyu Yitjuralpuyŋuyunydja yukurranha nhänhana ŋuli yana, ŋunhi ŋayinydja Garraynydja walalaŋgala ŋunhilimi ṉapuŋga. ");
INSERT INTO gnn_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Yo, ŋayi Garray wäthurruna Mawtjitjku bala ŋunhimala Withiyanminyarawuylili Buṉbulili, ga ŋunhalayina ŋayi Garrayyu wekaŋala ŋunhi romdja Mawtjitjkala nhanukalaŋuwu yolŋu'‐yulŋuwu Yitjuralpuyŋuwunydja, ga bitjarra ŋayi Garray waŋananydja Mawtjitjkala gam'. ");
INSERT INTO gnn_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“Ŋunhi nhuma yurru marrtji galkithirrinydja gal'ŋu Godkala buku‐ŋal'yunarawunydja, nhuma yurru gämanydja wäyinnhanydja mak buliki mak läm mak nanikut, märr yurru ŋayi Garrayyunydja märrama muka nhumalanha, bäy‐ḻakaramana yurru nhumalaŋgu yätjpuynydja, liŋgu ŋuriŋina maŋgu'‐waṉḏinyarayu wäyingalana. ");
INSERT INTO gnn_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Yo, djarr'yundja nhuma yurru ḏarramunha yana wäyinnhanydja buliki'nha, ḻatju'nha dhika ŋula nhämiriwnha, bala gämana ŋunhimala Buṉbulilina bathanarawu Garraywuna. ");
INSERT INTO gnn_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Ga ŋunhili dhurrwaraŋuranydja, ŋayi yurru ŋunhi yolŋunydja goŋ‐ŋal'yunna ŋurikalayi wäyingalanydja muḻkurrlilina, ŋayinydja yurru ŋunhiyinydja wäyin burakirri ŋurikala yolŋuwala dharapulŋura, bala yurru Garrayyunydja ŋanya märramana yana ŋunhiyi yolŋunha, yakana ŋayi yurru nhämanydja yolŋuwu ŋurikiyi yätjtja, bala dhä‐ḏir'yundja, liŋgu maŋgu'yunydja ŋuriŋiyi wäyindhunydja monygumana yurru yätjtja ŋurikiyi yolŋuwu. ");
INSERT INTO gnn_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Yo, ŋayi yurru ŋuriŋi yolŋuyunydja wutthunna ŋunhi wäyinnhanydja buliki'nhanydja ŋunhiliyina, bala yurru ŋuriŋinydja ḏalkarra'mirriyunydja märrama maŋguny'tja ŋunhiyi wäyinnha, bala warrkuḻumana marrtji ḻiw'maramana yana ŋunhiyi gali'lili malaŋulili ŋunhimala dhaliyarra'lilinydja, ŋunhi yukurra dhärra galki ŋunhi dhurrwaraŋura Godkala buṉbuŋura. ");
INSERT INTO gnn_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Bala ŋuliŋurunydja ŋayi yurru ḏalkarra'mirriyunydja ŋuriŋi marrtji barrwaṉ' warrkuḻumana, bala mitmitthun muṉguykumana ŋunhi wäyinnha ŋanaktja marrtji. ");
INSERT INTO gnn_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Bala dharpana ŋayi yurru rulwa'‐rulwaŋdhun ŋunhimalayi dhaliyarra'lilinydja, bala dhuŋgur'yunna. ");
INSERT INTO gnn_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Ga ŋunhimalayi gurthalilinydja yurru walala gurrunhan ŋunhiyi wäyinnha malanha, muḻkurr ga yaḻmanga', bukmak yana warrpam'thun ŋayi yurru nhäranydja ŋunhiyi ŋunhiliyi dhaliyarra'ŋuranydja. ");
INSERT INTO gnn_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Bala ŋayi yurru buŋgandja ŋunhiyi gaŋgathirri bala ŋawulul' Garraywuna, ga ŋayinydja yurru Garrayyunydja märramana yana ŋunhiyi wirrkina wal'ŋu yana ŋayaŋu‐djulŋithirrina. ");
INSERT INTO gnn_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","13","“Ga ŋunhi ŋayi yurru gäma ŋuriŋi yolŋuyu wäyinnha bembinha mak nanikutnha, wäyindja yurru ŋunhiyi ḻatju' wal'ŋu yana ŋula nhämiriw, djomu, ga bitjandhi liŋgu ŋayi yurru ŋunhiyi gulaŋdja wäyinnha ŋunhiyi djalkthunna marrtji gali'lilina malanyŋulili ŋunhimala dhaliyarra'lilinydja, bala bukmaknha yana rumbalnydja ŋunhi bathan ŋunhimalayi dhaliyarra'lilina wäyinnhanydja. Ga buŋgandja ŋayi yurru ŋunhiyi ŋawululny'tja gaŋgathirrina nhanŋu Garraywuna, ga ŋayinydja yurru ŋunhiyi märramana yana yulŋunydja ŋayaŋu‐ŋamathirrina wal'ŋu. ");
INSERT INTO gnn_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","17","“Ga ŋuli ŋayi yolŋu ŋurruwuyktja, ŋayinydja yurru gäma wäyin nyumukuṉiny', murryil mak ŋula nhä ḻumbuk, ŋayi yurru gulaŋdja ŋunhiyi waṉḏirri yukurra ŋunhiwalayina dhaliyarra'lilina, bala bathanna yurru rumbalnydja ŋunhimalayina dhaliyarra'lilina. Bala ŋayi yurru märramana Garrayyunydja ŋunhiyi yolŋunhanydja, liŋgu ŋuriŋiyinayi wäyingalana maŋgu'‐waṉḏinyarayu.” ");
INSERT INTO gnn_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","2","Ga biyapul ŋayi Garrayyu nherrara wiripuna rom malanha, märr ŋuliwitjandja dhukarrkurru walala yurru yolŋu walala marrtji galkithirrina nhanukala Godkala, wekanhamirrina manapan. Walala yurru yolŋu'‐yulŋuyunydja ŋathanydja gäma maŋutjinydja nhanŋu Godku wekanharawu, yurru ŋäthilinydja walala yurru ŋunhiyi yarrwa'yun ŋatha wal'ŋu, bala bikpikthunna weyika'na ga buŋgan bäw'nha, bala gämana yurru ŋunhiwala ḏalkarra'mirriwalana. Ŋayi yurru ŋuriŋiyi ḏalkarra'mirriyunydja märramana, bala dhiṯthun yurru goŋdhunydja waŋganydhu ŋuliŋuruyinydja, bala bathan ŋunhimalayina dhaliyarra'lilina, ga ŋunhinydjayi bitjarra ŋayi ŋuriŋiyi yolŋuyunydja bukmaknha wekaŋala Garraywuna. Ga ŋunhi yurru ḻatjuny'tja buŋgan yukurra gaŋgathirrina nhanŋu Garraywu, bala ŋayinydja Garrayyunydja yurru ŋoy‐ŋaḏupthunna yana märramanydja nhanukuŋu wekanharanydja. ");
INSERT INTO gnn_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Ga wiripunydja malanha ŋunhi ŋatha dhuḏi'yunmaranharawuynydja, ŋunhiyinydja ḏalkarra'mirriwu ŋuriki walalaŋgu ḏarramuwurruŋgu, ŋunhiyinydja walalana yurru ḻuka, liŋgu ŋathanydja ŋunhiyinydja dharrpalnha wal'ŋu, ganaŋ'thun yukurra, liŋgu ŋunhiyi mundhurr wekanharanydja nhanŋuwaynha Godkuna Garraywuna. ");
INSERT INTO gnn_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","10","Ga ŋunhi walala yurru yolŋu'‐yulŋuyu ŋatha gäma bathanara balwurnydja dämba mundhurr‐wekanharawu Godkunydja Garraywunydja, ŋunhiyinydja yurru ŋathanydja ruwaŋga'kunharamiriw yana, yurru ŋämiṉaranydja weyika'wuy waŋganybuy ŋapanydja. Ga ŋunhalayi buṉbuŋuranydja ŋayi yurru ḏalkarra'mirriyunydja märrama ŋathanydja ŋunhiyi, bala gäma yurru ŋunhiwala dhaliyarra'lilina, ga ŋunhalanydja ŋayi yurru ḏaw'‐ḏawyunna, bala wiripunydja malanha ŋayi yurru djalkthun gurthalilina ŋunhiwalayi dhaliyarra'lilina, bathan yurru nhanŋuna Garraywuna. Ga ŋunhi yurru buŋgandja ŋunhi gaŋgathirri yukurra, bala ŋayinydja yurru Garrayyunydja galŋa‐djulŋithirrina yana märrama bukmaknha ŋunhi nhanukuŋu wekanhara. Ga wiripunydja malanha ŋunhiyi ŋatha dharrpalnha yana; walalana yurru ŋuriŋi ḏalkarra'mirriyuna walalay ḻuka ŋunhiyi ŋatha, ŋunhi walala yukurrana yolŋu'‐yulŋuyu mundhurr‐wekaŋala nhanŋu Garraywu. ");
INSERT INTO gnn_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","16","Ga ŋunhi nhuma yurru mundhurr‐wekama ŋathanydja nhanŋu Garraywu, yaka nhuma yurru warrkuḻuma ŋunhimalayi ruwaŋga'kunharamirrinydja; ŋunhiyinydja ŋatha ruwaŋga'kunhamiriw yana nhe yurru rulwaŋdhundja, ŋäthilimirriyama Garraywunydja, ga yaka yana nhuma yurru beŋgurru gukunydja ŋunhiwalayi. Yurru djalkthundja nhuma yurru yukurra ŋathalilinydja ŋunhimalayi dje'lana, liŋgu dje'layunydja ŋuriŋi yukurra ḻakarama mayali' ŋunhina dhawu'‐nherraṉminyarawuynha, ŋunhi yukurra dhärra dhambay‐manapanmirri waŋganygumana yana, nhe ga Garray. ");
INSERT INTO gnn_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“Ga ŋunhi nhuma yurru yolŋu'‐yulŋuyu wekama wiripu mundhurr ŋunhi ŋuli yukurra ḻakarama waŋgany‐manapanminyarawuy bitjan gam', nhuma yurru gämanydja buliki buyuwuyu'mirri yana, djomumirri, ŋula nhämiriw yana. ");
INSERT INTO gnn_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Ŋäthilinydja nhe yurru muḻkurrlili ŋal'yurra goŋ ŋurikalayi wäyingala, bala wutthurrana ŋunhiliyinayi dhurrwaraŋurana buṉbuŋura galkina. Bala ŋayinydja yurru ŋuriŋiyi ḏalkarra'mirriyunydja märrama maŋguny'tja, bala djalkthunna marrtji ḻiw'marama yana ŋunhiwalayi dhaliyarra'lilinydja, ḏämbumiriwlili yana ḻika'‐ḻikanlili. ");
INSERT INTO gnn_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","5","Bala ŋayi yurru ŋuriŋiyi ḏalkarra'mirriyu gulk‐gulkthunna marrtji ŋanaktja ŋunhiyi wäyinnha, ga dhuwalanydja malanha ŋayi yurru bathan Godkuna gam', yaḻmanga' ga biḏila ga ḏiny'ṯiny yaḻmanga'mirri; dhuwalanydja yurru malanha ŋayi ŋuriŋi ḏalkarra'mirriyunydja ŋunhimalayina bathan dhaliyarra'lilina, rrambaŋikumana yurru ŋunhimala wiripuŋulilina dhambay, ŋunhi walala bumara yätjpuy walalaŋgalaŋuwuy ŋäkirrmaranhara. Bala yurru ŋayi ŋunhi buŋgandja yukurra ŋawululny'tja gaŋgathirrina nhanŋu Garraywuna, bala ŋayi Garrayyunydja yana ŋoy‐ŋaḏupthunna märramanydja yurru nhanukuŋu wekanharanydja, ga yuwalknha yanana ŋayi yurru ŋunhiyi yolŋu nhina yukurra waŋganyŋuranydja, waŋgany‐manapanmirrina yurru Godkala. ");
INSERT INTO gnn_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","17","“Ga balanyarayi liŋgu yana ŋayi yurru yolŋuyu gäma bembinha mak nanikutnha, yurru yaḻmangany'tja ŋunhiyi nhanŋuway yana dhulŋuŋu Garraywu, yaka yurru nhuma Yitjuralpuyŋuyunydja yolŋu'‐yulŋuyu ḻuka yukurra yaḻmangany'tja wäyin. “Ga bitjandhi nhuma yurru yakayi yana ḻuka gulaŋdja, ga ŋanak gulaŋmirri yakayi yana nhuma yurru ḻuka. Dhuwalayinydja rom yurru yukurra djingaryunna yana bitjanna liŋguna gupaḏalnha‐wala.” Ga bitjarra ŋayi Godthu waŋananydja. ");
INSERT INTO gnn_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","12","“Ga ŋuli yurru yolŋuyu djäma ŋula nhä yätj märr‐wawunydja yana, ŋayi yurru ŋuriŋiyinydjayi yolŋuyu gäma wäyinnha Garraywalana Buṉbulili, märr yurru ŋuriŋi wäyingalanydja gulaŋ‐waṉḏinyarayu nhanŋu yätjtja buwayakkumana ŋäkirrmaramana. Mak ŋayi yurru gäma buliki, mak bembi mak nanikut, yurru ḻatju' wal'ŋu yana buyuwuyu'mirri ŋula nhämiriw wäyin ŋayi yurru gämanydja, märr nhanŋu yurru ŋurikiynydja buku‐dhumukthinyarawuynydja yätjpuy ŋäkirrmaramana yana. Yo, ŋuli ŋayi yurru ŋunhi ḏalkarra'mirri yolŋu, ŋurruŋu wal'ŋu ŋayipi dhuwurr‐yätjthirri, ŋayinydja yurru bitjandhi yana liŋgu gämayi wäyin yuṯa wal'ŋu yana. Yana ŋayi yurru goŋ‐ŋal'yunna ŋurikala wäyingalanydja muḻkurrlili, bala bumana yana ŋunhi wäyinnhanydja, bala gäma gulaŋdja djinawa'lilina ŋunhana wal'ŋu, ga ŋunhiyi maŋguny'tja ŋayi yurru bikpikthunna ŋunhiwala dhaliyarra'lili ŋunhi ŋuli yukurra buŋgan bäw' gaŋgathirri ŋuliŋuruyi bala Godku. Bala ŋayi yurru rumbalnydja ŋunhiyi wäyinnha bathan warraŋulnha wäŋaŋurana, ŋayi yurru wäyindja ŋunhiyi burakirri dharapulŋura ŋurikala ḏalkarra'mirriwalana yolŋuwala, märr yurru ŋayi Garraynydja yakana ŋaramurryirri yolŋu'‐yulŋuwunydja bukmakkunydja ŋuriki Yitjuralpuyŋuwunydja. ");
INSERT INTO gnn_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","21","Ga ŋunhi walala yurru bukmakthu ŋuriŋi wal'ŋu Yitjuralpuyŋuyu miṯtjiyu djäma yätjtja rom märr‐wawunydja yana, dhunupana yana walala yurru ŋuriŋinydja walalay bukmakthu miṯtjiyu gäma wäyinnha buliki märr‐yuṯa, ga ŋunhiyi walala ŋurru'‐ŋurruŋunydja yurru goŋ‐ŋal'yun ŋurikala wäyingala muḻkurrlilinydja, bala yurru bumana. Ga dhunupana ŋayi yurru ḏalkarra'mirriyunydja gäma gulaŋdja djinawa'lilina wal'ŋu buṉbulili, bala walala yurru bikpikthunna ŋunhiwala dhaliyarra'lilina, ŋunhi ŋuli yukurra buŋgan bäw' gaŋgathirri ŋuliŋuruyi bala Godku, bala ŋayi yurru rumbalnydja ŋunhiyi wäyinnha bathan wäŋaŋurana warraŋulnha, märr yurru ŋuriki yolŋuwunydja walalaŋgu yätjtja warrpam'nha ŋäkirrmarama ŋuriŋiyinayi maŋgu'‐waṉḏinyarayu wäyingalana. ");
INSERT INTO gnn_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","26","Ga ŋuli yurru buŋgawa wal'ŋu yolŋu yätjthirri, märr‐wawu ŋayi yurru djäma ŋula nhä yätj, ŋayinydja yurru bitjandhi yana liŋgu gämayi wäyin, märr yurru wäyindja ŋunhiyi burakirri nhanukala ŋurikala buŋgawawala yolŋuwala dharapulŋura. ");
INSERT INTO gnn_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","35","Ga bitjandhi liŋgu ŋunhi ŋayi yurru gali'wuyyu yolŋuyu djäma dhuwurr‐yätj märr‐wawu yana, ŋayinydja yurru bitjandhi yana liŋgu gäma wäyin, ga ŋunhiyinydja yurru wäyin burakirrina ŋurikalayina dharapulŋura, märr yurru Garrayyunydja bäy‐ḻakaramana yanana ŋuriki yolŋuwu yätjpuynydja, yakana ŋayi yurru dhä‐ḏir'yun ŋurikiy djämawuy.” Yo, ŋayi Garrayyu nherraranydja guḻku' yana mirithirri romdja malanha ŋuriki nhanukalayŋuwu yolŋu'‐yulŋuwunydja, ŋayi ḻakaraŋala yukurrana nhaltjan ŋayi yurru Godthu bäy‐ḻakaranharawuy wekama ŋunhi walala ŋuli nhä djäma yätj. Ga dhiyakuyina märrwu ŋayi ŋunhi nherrara wiripunydja ga wiripunydja rom malanha, märr yurru walala nhina yukurra ḏarrtjalk yana ŋula nhämiriw. Liŋgu ŋunhi Godtja ŋayipinydja ḏarrtjalk yana, gäna wal'ŋu ŋayipi, ga Garraynydja ŋayinydja djäl muka nhanukalaŋunydja yolŋu'‐yulŋuwu walala yurru nhina yukurra ŋamakurru' wal'ŋu yana, ganaŋ'thun yana yätjŋurunydja, ga ganaŋ'thun yana ŋuliŋuru nhäŋuru malaŋuŋuru ŋunhi yurru romdhu ŋuriŋiyi yolŋunha walalanha baḏuwaḏuyun. ");
INSERT INTO gnn_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","2","Bala ŋayi Garrayyu ḻakaraŋala bitjarrana Mawtjitjkala, “Ḻakaraŋa nhe yurru nhokalaŋuwa wäwa'mirriŋuwa Yärunba ŋuripa ḏalkarra'mirriwa ŋurruŋuwa, yaka ŋayi yurru marrtji ŋunhawala djinawa'lilinydja, dharrpallilinydja ŋärra'lilinydja ŋunhanydja wal'ŋu birrka'mirriyunydja waluyu, yana ŋayi yurru dhuŋgarra‐watjthirri gulŋiyirrinydja yukurra, ŋuriŋi yana liŋgu waluyu ŋunhi ŋarra nherrara. Ŋuli ŋayi yurru gulŋiyirri birrka'mirriyunydja waluyu ŋayinydja yurru rakunydhirrina yana, liŋgu ŋarrapinydja yurru ŋuli maḻŋ'thun ŋunhiliyi waŋupini'ŋurana, garrwarnha wal'ŋu ŋunhilina yana Mel‐wuyunaramirriŋurana Dhaḻakarrŋura. ");
INSERT INTO gnn_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Yakana ŋayi yurru gulŋiyirrinydja‐wala yänanydja, ŋäthilinydja ŋayi yurru gäma buliki' yuṯa wal'ŋu yana, ga ḏarramu bembinydja, bala wutthunna yurru ŋayi, bala bathan dhaliyarra'lilina ŋunhana, märr ŋuriŋiyi gulaŋ‐waṉḏinyarayunydja wäyingalanydja ŋayi yurru Garrayyunydja bäy‐ḻakaramana buwayakkumana ŋurikiyi nhanŋuway Yärungu yätjpuy ga nhanukalaŋuwu yumurrku'wu. ");
INSERT INTO gnn_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","“Yo, ŋurruŋunydja ŋayi yurru Yärun ḻupthun yukurra gapuyu, bala ŋayi yurru dhaṯthunmirrina ŋuriŋiyi dharrpalyunydja girri'yu ŋunhi ŋayi Garrayyu ḻakaraŋala ŋurikiyi ḏalkarra'mirriwu. ");
INSERT INTO gnn_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Bala walala yurru ŋuriŋiyi yolŋu'‐yulŋuyu Yitjuralpuyŋuyunydja gämana nhanukala Yärungala märrama wäyindja maṉḏanha nanikuttja, ga bitjandhi liŋgu walala yurru wekama bembinhanydja ḏarramunha, märr gulaŋ‐waṉḏinyarayu ŋurikala wäyingalanydja ŋayi yurru Godthu buwayakkuma walalaŋgu yätjnha dhuwurr. ");
INSERT INTO gnn_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","“Yo, ŋurruŋunydja ŋayi yurru Yärundhu wutthun buliki'nha, ŋunhiyinydjayi bulikiny'tja yurru rakunydhirri nhanukala Yärungalana dharapulŋura, märr yurru ŋayi Godthu buwayakkuma nhanŋu Yärungu yätjpuy. ");
INSERT INTO gnn_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","8","Dhurrwaraŋuru ŋuliŋurunydja ŋayi yurru Yärundhu märramana ŋunhiyi wäyinnhanydja märrma'nhanydja nanikutnha, bala nherraṉ gumurrlilina nhanukala Garraywala ŋunhimala dhurrwaralilina wal'ŋu galkina buṉbulili, bala yurru djarr'yunna ŋayi waŋganynhanydja, märr yurru ŋunhiyinydja nhanŋuway Garraywuna, ga wiripunydja ŋunhinydja nanikut djuy'yunarawuna bena‐wala ḏiltjililina. ");
INSERT INTO gnn_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Bala ŋayi yurru Yärundhu wutthunna ŋunhiyi nanikutnhanydja ŋunhi ŋayi djarr'yurruna Garraywu, märr yurru ŋuriŋiyinydja gulaŋ‐waṉḏinyarayu wäyingalanydja Godthu ŋäkirrmaramana ŋuriki yolŋu'‐yulŋuwalaŋuwuynydja yätjpuy. ");
INSERT INTO gnn_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Ga wiripunydja ŋunhinydja ŋayi yurru wekama nhanŋuna Garraywuna, yurru walŋa yana ŋayi yurru ŋunhiyinydja nanikut yukurra dhärra, märr yurru ŋayi yängumana ŋunhiyi bena‐wala ḏiltjililina; ŋayinydja yurru ŋuriŋiyinydja yätjnha djaw'yun yolŋu'‐yulŋuwu bena‐wala wuyupthunna yurru, barrkulilina gupaḏalnha‐wala yurru winya'yundja. ");
INSERT INTO gnn_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Yo, ŋäthilinydja ŋayi yurru Yärundhu wutthun buliki' ŋunhiyi, bala wapmarama gulaŋdja banikin'lilina, bala rumbalnydja yurru ŋayi Yärundhu bathan dhaliyarra'lilina, märr yurru ŋayi Garrayyu ŋäkirrmarama yätjpuy nhanŋuway Yärungu ga nhanukalaŋuwu djamarrkuḻi'wu. ");
INSERT INTO gnn_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Ga dhurrwaraŋuru ŋuliŋurunydja ŋayi yurru märrama ḻirrwi' gurtha ŋuliŋuru dhaliyarra'ŋuru, ga biyapul ŋayi yurru märramayi buŋgan bäwny'tja, bala marrtji yurru djinawa'lilina ŋunhiwala wal'ŋu ŋurikimirri, gämanydja ŋayi yukurra yurru ŋunhiyi maŋguny'tja Garraywalana ŋunhiwala dhaḻakarrlili wal'ŋu. ");
INSERT INTO gnn_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Ga ŋunhilinydja djinawany'tja, dharrpalŋuranydja dhaḻakarrŋura, ŋayi yurru rarryunna ŋunhiyi buŋgan bäwny'tja ŋunhimalayi ḻirrwi'lilina, gumurrlilina nhanukala Garraywala, märr yurru ŋunhiyinydjayi ŋawulul' marrtji gaŋgathirrina, warrpam'nha monyguma ŋunhi Garraywunydja dhaḻakarr, märr yurru ŋayi yaka Yärundhu nhäma ŋunhiyi, bala rakunydhirrina. ");
INSERT INTO gnn_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Bala ŋayi yurru goŋ‐ḻupthun ŋunhimalayi maŋgu'lili wäyingala, bala bikpikthun ŋunhiwala Mel‐wuyunaramirrililina Dhaḻakarrlili, gumurrlilina wal'ŋu, ga bitjandhi liŋgu ŋayi yurru bikpikthundhi gumurrlilinydja Dhawu'‐nherraṉminyarawuylilinydja ŋunhi Bathilili, waŋgany‐rulu ga märrma'mirri bäythinyarawuynydja yurru ŋayi bikpikthundja ŋunhiwalayi. ");
INSERT INTO gnn_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“Ga ŋuliŋurunydja ŋayi yurru Yärundhu buma ŋunhiyina djarr'yunarawuynhana nanikutnha, ŋunhi ŋayi yurru rakunydhirri yolŋu'‐yulŋuwala dharapulŋura, bukmakkala ŋurikala Yitjuralpuyŋuwala miṯtjiwala. Yo, gämanydja ŋayi yurru maŋguny'tja ŋunhiyi dharrpallilina ŋunhiwalayina ŋärra'lili, ga bitjandhi yana liŋgu ŋayi yurru bikpikthundhi ŋunhiyi Mel‐wuyunaramirrililinydja Dhaḻakarrlili wäŋalili, ");
INSERT INTO gnn_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","märr ŋayi yurru ŋuriŋiyi maŋgu'yunydja ḏarrtjalkkuma ŋunhiyina ŋärra'na wäŋa. Liŋgu yolŋu'‐yulŋunydja ŋunhi Yitjuralpuyŋunydja yakana ḏarrtjalkmirri, ga djäma walala yukurra yätjnha rom, bala ŋayi yurru ŋuriŋiyi ŋurruŋuyunydja ḏalkarra'mirriyu yolŋuyu ḏarrtjalkkumana yukurra ŋunhi wäŋanhana buṉbunhana ŋuriŋiyi maŋgu'yuna wäyingalana, märr yurru ŋayi yukurra God nhina yana walalaŋgala ŋunhili ṉapuŋga. ");
INSERT INTO gnn_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Yaka yurru yana ŋula yol yolŋu gärri ŋunhiwalayinydja buṉbulili ŋunhi ŋayi yurru Yärundja marrtji ga ḏarrtjalkkuma wäŋanha ŋunhiyi ŋuriŋi maŋgu'yu, yana liŋgu ga dhawaṯthun ŋayi yurru walŋa yana, märr yurru yolŋu'‐yulŋuyunydja nhäma, ga dharaŋan ŋunhi ŋayi Godthu liŋguna bäy‐ḻakaraŋala walalaŋgu yätjpuynydja dhuwurrwuy, Yärungalaŋuwuy ga djamarrkuḻi'walaŋuwuy nhanukalaŋuwuy, ga bukmakkalaŋuwuy ŋunhi yolŋu'‐yulŋuwalaŋuwuy; yakana ŋayi yurru Godthu nhäma biyapulnydja walalaŋgu yätj. ");
INSERT INTO gnn_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Dhurrwaraŋuru ŋuliŋurunydja ŋunhi ŋayi yurru dhawaṯthun beŋuru buṉbuŋuru, ŋayi yurru marrtji ŋunhiyi Yärundja bala ŋunhiwala dhaliyarra'lili galki, bala ŋayi yurru ŋämiṉna marrtji ŋunhiyi dhandurruŋdja ŋunhilimi dhaliyarra'ŋurana ŋuriŋiyina maŋgu'yuna, ḏarrtjalkkumayi yurru dhaliyarra' ŋunhi ŋuriŋi maŋgu'yu. ");
INSERT INTO gnn_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Ga bitjandhi liŋgu yana ŋayi yurru bikpikthundhi dhaḻakarr ŋunhiyinydja, rumbalnydja ŋanya dhaliyarra'nha, waŋgany‐rulu'mirri ga märrma' bäythinyarawuymirri ŋayi yurru bikpikthundja, märr yurru ŋunhiyi barŋdja ḏarrtjalk yana, yaka baḏuwaḏuyunara ŋula yolŋu'‐yulŋuwuŋu yätjpuy. ");
INSERT INTO gnn_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“Ga dhurrwaraŋuru ŋuliŋurunydja ŋunhi ŋayi bitjarrayi djäma ḏarrtjalkkuŋala marrtjina ŋunhiyi dhuyu wäŋa dhaḻakarr ga buṉbu ŋunhiyi, ga barŋ ŋunhiyi, bala ŋayi yurru ŋuriŋiyi Yärundhunydja märramana ŋunhiyi ganaŋ'maranharawuynhanydja nanikutnha ŋunhi walala wekaŋala nhanŋu Garraywu walŋa. ");
INSERT INTO gnn_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Bala ŋayi yurru goŋ‐ŋal'yunna muḻkurrlilina ŋurikalayi wäyingala, bala waŋanydja ŋayi yurru marrtji ḻakaramanydja bitjanna ŋuriki yolŋu'‐yulŋuwu Yitjuralpuyŋuwu yätjpuynydja nhaltjarra walala yukurrana djäma yätjkuŋala, ga nhaltjarra walala ŋunhi baḏatjurruna Godku rom; ḻakaramanydja ŋayi yurru warrpam'nha yana, yakana ŋula ŋäkirrmarama wo djuḻuḻ'marama waŋganydja, ga ŋuliwitjandhinydja bitjan ŋayi yurru ŋal'maramana yukurra ŋunhiwala wäyingala nanikutkalanydja bukmakkuna yana yolŋu'‐yulŋuwu ŋuriki Yitjuralpuyŋuwunydja yätjpuy. Bala ŋayi yurru ŋuriŋi wiripuŋuyunydja yolŋuyu märramana ŋunhiyi nanikutnhanydja, bala gäma ḏiltjililina, bala ŋayi yurru yängumana ŋunhi nanikutnhanydja, bena‐wala yana wuyupmaramana yurru. ");
INSERT INTO gnn_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Bala ŋayi yurru wäyindja waṉḏirrina ŋunhiyi yanana‐wala yulŋunydja winya'yunna, djaw'yunna‐wala yurru ŋuriki yolŋu'‐yulŋuwunydja yätjpuy, winya'yunna yurru yana gupaḏalnha‐wala. ");
INSERT INTO gnn_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","28","“Ga dhurrwaraŋuru ŋuliŋurunydja ŋayi yurru ŋuriŋiyi ḏalkarra'mirriyunydja yolŋuyu ŋurruŋuyunydja yupmaramana dharrpalnydja malanha girri' ŋunhi, bala ŋayi yurru rurrwuyunmirrina ŋanyapinyay ŋayi gapuyuna, bala nherraṉ nhanŋuwaynha wal'ŋu ŋunhi girri'. ");
INSERT INTO gnn_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","33","“Yo, bitjan liŋgu nhuma yurru Yitjuralpuyŋuyunydja yolŋuyu walalay djämanydja yukurra bitjandhinydja dhuŋgarra‐watjthirri yana. Nhuma yurru ganan djämanydja malanha nhumalaŋguway, bala nhiniyana yukirriya ŋoy‐ŋathamiriwnha, wuyurrana manaparra nhokalayŋu nhe yätjkuna. Bala Garrayyunydja nhumalanha yurru ŋuriŋinydjayi waluyu ḏarrtjalkkumana, ŋäkirrmaramana ŋayi yurru nhumalaŋgu yätjtja ŋuriŋiyinayi maŋgu'yuna, märr yurru nhuma yukurra nhina ḏarrtjalknha yana, waŋganyŋurana nhanukala Godkala; yakana ŋayi yurru nhäma biyapulnydja yätj nhumalaŋgu, meṉgumana yurru ŋayi yana buku‐dhumukthirrina. ");
INSERT INTO gnn_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","“Yo, dhuwalayinydjayi rom yurru yukurra dhärrana yana gupaḏalnha‐wala. Waŋga'‐waŋganymirri yana dhuŋgarra‐watjthirri yurru ŋayi ŋuriŋiyi ḏalkarra'mirriyu ŋurruŋuyu yolŋuyu djäma dhuwalayi romdja, ḏarrtjalkkuma marrtji ŋunhi buṉbunydja Godku ga yolŋu'‐yulŋunha ŋunhi miṯtji ŋuriŋiyi gulaŋdhu, liŋgu dhiyaŋuyinydjayi romdhu ŋayi yurru Garrayyunydja baḏuwaḏuyun nhumalaŋgu yätjpuynydja, märr yurru nhuma ŋunhi Garraywunydja yolŋu walala nhina waŋganyŋurana yana rrambaŋina nhanukala, ŋula nhämiriwnha yana.” Bitjarrayina ŋayi Mawtjitjthu ḻakaraŋalanydja yukurrana yolŋu'‐yulŋuwu, ga yuwalknha yana walala djäma romdja ŋunhi bitjarrayi dhuŋgarra‐ŋupanana ŋuli yana, ŋunhi ŋayi Garrayyu wekaŋala rom Mawtjitjkala. ");
INSERT INTO gnn_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","2","Yo, Garrayyu Godthu ḻakaraŋala Mawtjitjkala rom malanha bitjarra gam'. “Ḻakaraŋa ŋarrakalaŋuwa yolŋu'‐yulŋuwa Yitjuralpuyŋuwanydja biyaka, ‘Nhumanydja yurru ŋarrakunydja yolŋu walala nhiniya yukirriya ḏarrtjalkthiya yana gal'ŋu, biyakayi liŋgu yana bitjan ŋarranydja dhuwala ḏarrtjalk gal'ŋu yana Garray, ganaŋ'thun yukurra ŋulaŋuru yätjŋurunydja. ");
INSERT INTO gnn_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Märr‐ŋal'yurra nhokalaŋuwala bäpa'mirriŋuwala ga ŋäṉḏi'mirriŋuwalanydja, ga bitjandhiyi nhuma yurru ganaŋ'maramayi ŋunhi dhulŋuŋunydja ŋarrakuwaynydja gal'ŋu walu, liŋgu nhumanydja dhuwala ŋarrakuway yana yolŋu walala, ga ŋarranydja God nhumalaŋgu. ");
INSERT INTO gnn_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Yaka gonha'yurra ŋarranha ga buku‐ŋal'yurra wiripuŋuwunydja waŋarrwu, wo ŋula nhäku malaŋuwu dhuyuwunydja goŋbuywunydja ŋunhi, liŋgu ŋarrapi dhuwala waŋgany Godtja nhumalaŋgu. ");
INSERT INTO gnn_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","10","“Ŋunhi nhuma yurru gulkthun ŋathanydja, yaka mälkuŋanydja warrpam'thurranydja gulkthurra, gonha'yurra muka wiripunydja yarraṯalili, ga yaka wapmaraŋa ḻarryunaranydja; gonha'yurra ŋunhiyinydja ŋuruku ŋurruwuykku ŋunhi yolŋuwu, ga ŋuruku mulkuruwu yolŋuwu. ");
INSERT INTO gnn_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","12","“Yaka manaŋiyanydja ŋula nhä, ga yaka djawukiyanydja ḻakaraŋa, ga yaka wakalkurru waŋiya Garraynhanydja yäku ḻakaraŋa. ");
INSERT INTO gnn_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Yaka rom‐ḏälthiya wiripuŋuwunydja ŋuruku yolŋuwu, ga yaka djaw'yurra ŋula nhänydja nhanŋu. ");
INSERT INTO gnn_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Yaka waŋiya dhäruk yätjkuŋa yolŋunha mäkiri'miriwnhanydja, ga yaka gunganhamirriyaŋa ŋula nhä bambaywunydja yolŋuwu, yana biyaka rom‐wiyaṉiyana Garraywuna ŋunhi ŋayi nhuŋu God. ");
INSERT INTO gnn_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“Djäma ŋamathaŋa wal'ŋu bukmakku yana. Yaka nhäŋa nyilŋ'maraŋa ŋurruwuyknhanydja yolŋunha, ga garrwarkuŋanydja yindikuŋanydja nhäŋa ga guyaŋiya ḻukunydjamirrinha ŋunhi yolŋu'‐yulŋunha. ");
INSERT INTO gnn_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","17","Yaka waŋiya marrtjiya ḻakaraŋa dhäwu'kuŋa wiripuŋunha yolŋunha, ga ŋuli yurru ŋayi ŋula yolthu yätjkumanydja nhuna, nhenydja yana bäy‐ḻakaraŋana nhanŋu; yaka buku‐ruŋinyamaraŋa yätjtja, ga yaka yana mukthurranydja nhanŋu ŋaramurryiya. ");
INSERT INTO gnn_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Yo, nhumanydja yurru ŋunhi ŋarrakuwaynydja yolŋu'‐yulŋu märr‐ŋamathiya wirrki wal'ŋu yana wiripuŋuwunydja yolŋuwu wiripu‐guḻku'wunydja, biyaka yana liŋgu bitjan nhe yukurra märr‐ŋamathirri nhuŋuway nhe, liŋgu ŋarranydja dhuwala God nhuŋuway. ");
INSERT INTO gnn_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","28","“Yaka yana djäma be nhä marrŋgitjthunydja girri'yu, mangaṯany'tja ŋula nhänydja, ga yaka yana ŋula nhäkunydja ḻarruŋa ŋathil'yurranydja maḻŋ'maranharawu, nhä yurru ŋayi maḻŋ'thun yalala. Yaka mitmitthunmiya nhunapinyay nhe rumbal mim'pumirriyanhamiyanydja, ga yaka yukirriya mitmitthunmiya ga bunharamiya nhunapinyay nhe rumbal baḏuwaḏuyunmiya ŋuruku ŋunhi rakunygunydja yolŋuwu ŋäthinyarakurrunydja, liŋgu ŋarra dhuwala God nhumalaŋgunydja, ga nhumanydja ŋarrakuway yana yolŋu walala. ");
INSERT INTO gnn_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","30","“Ga yaka nhuŋuway yothu'nha miyalknhanydja wekaŋa ḏarramuwa, ŋunhi ŋayi ḏarramu ŋunhiyi djäl nhanŋu yana marramba'wu, ŋunhi ŋayi yurru ŋuliwitjandhinydja romgurru buku‐ŋal'yunna yukurra be nhäkuna waŋarrwuna; balanyarayunydjayi romdhu yurru nhuna ŋayi bilmaramana wiripuŋuwalana waŋarrwala, bala yurru nhuŋu baḏuwaḏuyunna ŋunhi wäŋanydja ŋuriŋiyinayi romdhuna. Ŋarrapi dhuwala waŋgany yana God nhumalaŋgunydja. ");
INSERT INTO gnn_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“Wiripu‐guḻkuny'tja yolŋu walala ŋuli marŋgiyirri be gaḏamandhirrina mangaṯa'wuŋuna walalaŋguŋu marŋgikunhara, ga wiripunydja ŋuli yolŋu walala waŋa marrtji mokuywalana rakunygalana ŋurikalana be. Nhumanydja yaka mäkiri'‐witjurra ŋuriki walalaŋgalaŋuwu dhärukkunydja, ga yaka marrtjiya ŋurikalayinydja yolŋuwala, märr ŋayinydja yurru nhuna guŋga'yun ga marŋgi wekama nhuna, liŋgu ŋuriŋi nhanukalanydja romdhu nhuna yurru bitjan ŋayaŋu‐djarrpi'kumana, bala yurru nhuna ŋuriŋiyinydjayi ganaŋ'thunmaramana yana ŋuliŋuru Garraywalanydja, nhe yurru yakana yana galkithirri Godkalanydja. Ŋarrapi dhuwala waŋgany Godtja, ganaŋ'thun yukurra yurru ŋulaŋuru mangaṯa'walanydja be nhäkalanydja mokuywalanydja. ");
INSERT INTO gnn_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","33","“Yaka wakalkuŋa ŋaḻapaḻnhanydja yolŋunha. Märr‐ŋal'yurra yana nhanukala, ga guŋga'yurra ŋanya biyaka. ");
INSERT INTO gnn_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Ga ŋuli yurru ŋayi mulkurunydja yolŋu nhina yukurra nhumalaŋgala wäŋaŋura, yaka djäma yätjkuŋanydja nhanŋu, yana märr‐ŋamathiya nhanŋu biyaka märr‐ŋal'yurra yukirriya, liŋgu nhuma yukurrana ŋäthilinydja nhinana ŋunhala Yetjip wäŋaŋura mulku'‐mulkuru muka ŋunhi nhumapinydja. ");
INSERT INTO gnn_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","36","Yaka mayali'‐wilkthurra ŋula yolnha yolŋunhanydja, liŋgu ŋarrapi dhuwala waŋarrnydja nhumalaŋgu Garraynydja, ŋunhi ŋarra dhawaṯmaraŋala nhumalanha beŋuru Yetjipŋuru wäŋaŋuru. ");
INSERT INTO gnn_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Märraŋa ŋarraku yana romdja malanha warrpam'thurra, liŋgu ŋarrapi yana Garraynydja nhumalaŋgu waŋarr Godtja.’” Ga bitjarra ŋayi Garray waŋananydja. ");
INSERT INTO gnn_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","2","Ga biyapul ŋayi Garrayyu gurrunhara rom Yitjuralpuyŋuwunydja, dhuwalana gam'. “Wiripunydja walu ŋunhinydja ŋarrakuway yana dhulŋuŋu gal'ŋu, ganaŋ'thun yukurra ŋuliŋuru djämamirriŋurunydja waluŋuru, märr yurru nhuma yukurra ŋayaŋunydja nhinana nhanŋuwaynha buku‐ŋal'yun Garraywuna. ");
INSERT INTO gnn_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Ḏämbumirri ga waŋgany bäythinyara walu ŋunhiyinydja djämawu, ga wiripunydja ŋunhi walu ga nhanŋuwaynha ganaŋ'thunna yukurra dhulŋuŋuna. Ŋuriŋiyinydjayi dhuyuyunydja waluyu ganaŋ'thunarayunydja nhe yurru ŋayaŋunydja nhinana yukurra yana; yakana nhe yurru djäma ŋuriŋiyinydjayi, yana nhuma yurru ŋuriŋiyinydjayi waluyu ḻuŋ'maranhamirrina marrtji bitjanna waŋganylilina ŋurruk‐manapanmirri, bala buku‐ŋal'yunna yukurra yurru Garraywu. ");
INSERT INTO gnn_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“Ga ḻurrkun'mirri ŋunhi dhuŋgarramirri nhuma yurru birrka'mirri miṯtji malanha Yitjuralpuyŋu ḻuŋ'maranharamirri waŋganylili ŋunhiwala Godkala buṉbulili. Dhuwalayinydjayi walu guyaŋinyaramirrina yukurranharamirri, bala nhuma yurru marrtji waŋgany‐manapanmirrina gal'ŋu, ga djämana dhuwalayi rom, liŋgu dhiyaŋuyinydjayi romdhu yukurra ḻakarama guḻku'na mirithirrina dhiyalaŋumiyinydjayi mayali' malanha. Ŋunhi yurru ŋayi walunydja dhuwalayi galkithirri buna, ŋayinydja yurru ŋunhi ḏalkarra'mirrinydja yolŋu ḻoḻthunna yiḏakinydja, bitjan ḻakaramana yurru yolŋu'‐yulŋuwana bitjanna, ‘Go, marrtjiya lili waŋgany‐manapanminyarawuna, liŋgu walunydja dhuwala guyaŋinyaramirrina nhanŋu Garraywuna.’ ");
INSERT INTO gnn_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","“Yo, Ḻäy‐yuḻkmaranharamirrinydja walu Garraywunydja ŋunhi yukurra yurru ŋurru‐yirr'yun ŋuriŋi 14‐dhunydja munhayu ŋurruŋuyunydja gal'ŋu ŋaḻindiyu, bala ŋuriŋi bili walu‐gulŋiyinyarayu nhumanydja yurru yukurra bitjandhiyina djäma ŋunhiyinayi guyaŋinyamirrina rom. ");
INSERT INTO gnn_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Ga ŋunhinydja bala wiripunydja walu, ŋunhiyinydjayi nhuma yurru yakana ḻuka yukurra ŋatha ŋunhinydja ruwaŋga'kunharamirrinydja, yana nhuma yurru ḻukanydja yukurra ŋunhina liŋgu yana ruwaŋga'kunhamiriwnha gal'ŋu, yana liŋgu ga ŋunhi yurru 7 walu djuḻkthun, liŋgu ŋunhiyinydjayi walu guyaŋinyamirri ŋurikiyinayi ‘Ŋathawu Ruwaŋga'kunhamiriwwuna.’ ");
INSERT INTO gnn_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","8","Yo, ŋunhiyinydjayi ŋurruŋunydja gal'ŋu walu dhulŋuŋu yana Garraywu nhanŋuwaynha, yakana nhe yurru ŋuriŋiyinydjayi waluyu ŋula djäma, yana yurru nhe gämana mundhurrnha nhanŋu Garraywu walu ŋupanna‐a‐a, yana liŋgu‐u‐u ga 7 ŋunhi walu yurru djuḻkthun. Ga ŋunhiyi walunydja dhä‐yawar'yunaramirrinydja bitjandhi yana ŋunhiyinydja dhulŋuŋuyi Garraywu yana, yakana nhe yurru ŋuriŋiyinydjayi ŋula djäma waluyu yukirriya. ");
INSERT INTO gnn_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","10","“Yo, galkina dhuwala yulŋunydja ŋunhi nhuma yurru gulŋiyirrina ŋunhiwalayina wäŋalili ŋunhi ŋayi Garrayyu yurru wekama nhumalaŋgu, bala gulkthurra nhuma yurru ŋäthilinydja märr‐warŋgarrkkuŋa ŋatha malanha, bala garrpi'‐garrpilana ŋurruk‐mana'‐manaparrana, bala yurru nhuma marrtji gämanydja ŋurruŋunydja wal'ŋu ŋunhinydja ŋatha ŋurikala ḏalkarra'mirriwalana. ");
INSERT INTO gnn_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Ga ŋunhalayinydjayi Godkalanydja buṉbuŋura ŋayi yurru ŋuriŋiyi ḏalkarra'mirriyu märramana Djandina waluyu, bala ŋayi yurru garrwarkumana yukurra ŋunhiyinydja, bala waṉa'‐waṉayunna yurru milkumana yukurra nhanukala gumurrŋura Godkalana Garraywalana. Bala ŋayi yurru Godthunydja märramana yana ŋunhiyi ŋurruŋunhanydja gal'ŋu, dharapulŋura bukmakkalana nhumalaŋgala; bukmaknha yurru ŋayi ŋunhiyi märramanydja yana ŋurikalayinayi ŋurruŋuwalana. ");
INSERT INTO gnn_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","13","Ga bitjandhiyina nhuma yurru bathandja wiripunydja malanha mundhurr nhanŋu Garraywu, ga ŋunhi ŋayi yurru yukurra buŋgandja gaŋgathirri bala, ŋayinydja yurru yana galŋa‐djulŋithirrina märramanydja ŋunhiyi nhokuŋu mundhurr‐wekanharanydja. ");
INSERT INTO gnn_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Yaka yana nhuma yurru ḻuka ŋuliŋuruyinydja ŋathaŋuru; ŋurruŋunydja nhuma yurru gäma ŋäthili nhanŋu Garraywu, ga ŋuliŋuruyinayi dhurrwaraŋuru nhuma yurru ḻukanydja. Ga dhuwalayinydjayi rom yukurra yurru dhärrana yana‐wala gupaḏalnha. ");
INSERT INTO gnn_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","16","“Yo, nhuma yurru bothurru walunydja 50‐kuŋa ŋuliŋuruyi dhäŋuru ŋunhi ŋayi ḏalkarra'mirriyu märraŋala ŋatha, bala garrwarkuŋalana dharrana bala‐lili Garraywalana gumurrŋura, ga ŋuriŋinydja bala 50‐yunydja waluyu nhuma yurru marrtji biyapul ḻuŋ'maranhamirri waŋgany‐manapanmirri, gämana yurru mundhurrnha Garraywuna ŋunhiyina ŋatha gulkthunara yuṯa‐märranharana. ");
INSERT INTO gnn_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","20","Yo, ŋunhili wäŋaŋuranydja nhokalay, nhe yurru batharra märrma'kuŋa yulŋunydja dämbany'tja, yurru ruwaŋga'kunhamirriyu yulŋunydja batharra ŋunhiyinydja, ga ŋunhi ŋurruŋunydja bitjan nhanŋuwaynha yurru Garraywuna dhulŋuŋuna. Ga biyakayi nhuma yurru dhambay‐manaparrayi batharra wäyindja, märr yurru nhumalaŋgu ŋayi yätjpuynydja ŋäkirrmaramana yana ŋuriŋiyi wäyingalanydja maŋgu'‐waṉḏinyarayu. Bala ŋayinydja yurru Godthunydja yana märramana nhumalaŋguŋu galŋa‐djulŋithirrina, ŋunhi ŋayi yurru marrtji buŋgan bäwny'tja bala gaŋgathirri. ");
INSERT INTO gnn_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","22","Yaka yana djämanydja ŋuriŋiyinydja waluyu, yana nhuma yurru waŋgany‐manapanmirrina ḻuŋ'maranhamirrina ŋunhiliyi Garraywalana gumurrŋura, bala buku‐ŋal'yunna yana. Gupaḏalkuma nhuma yurru yana ŋayathamanydja baṯ bitjan dhuwalayi romdja, bitjan yurru dhuwalayinydja walu dhulŋuŋuna nhanŋuwaynha yana Garraywuna, wanhawitjan nhe yurru nhina marrtji bala wäŋakurru. ");
INSERT INTO gnn_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","24","“Ga dhurrwaraŋuru ŋuliŋuruyinydjayi nhuma yurru bulnha galkun ŋathili märr‐weyin, yana liŋgu ga 7 yurru ŋaḻindi galkina gal'ŋu, ga ŋurruŋuyunydja ŋuriŋi waluyu ŋuriŋi 7‐dhunydja ŋaḻindiyu, ŋunhiyinydja ganaŋ'thun yukurra dhulŋuŋuna nhanŋuwaynha Garraywuna gal'ŋu, yakana nhe yurru yukurra djäma ŋuriŋiyinydjayi waluyu, yana nhuma yurru yukurra ŋayaŋuna‐nhina, buku‐ŋal'yun nhanŋuwaynha Garraywuna. Bala yurru ŋunhi ḏalkarra'mirrinydja walala yukurra marrtjina ḻiw'maramana wäŋakurruna, bopthunna yurru marrtji ŋuriŋi yiḏakiyinyarayuna, ḻakarama yurru marrtji yolŋu'‐yulŋuwanydja bitjanna gam'. ‘Go, marrtjiyana lili waŋgany‐manapanmiyana Garraywala, liŋgu Garraywunydja dhulŋuŋunydja walu galkina dhuwala.’ ");
INSERT INTO gnn_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Yaka yurru nhuma ŋuriŋinydjayi waluyu djäma yukurra, yana nhuma yurru ŋuriŋiyi waluyunydja mundhurrnha bathan yurru yukurra Garraywu. ");
INSERT INTO gnn_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","27","“Yo, ŋuriŋi 10‐dhunydja waluyu ŋuriŋi liŋgu yana ŋaḻindiyu 7‐dhu, Godthunydja yurru bitjanna buwayakkumana yätj Yitjuralpuyŋuwunydja, bitjan yuṯakumana, märr yurru walala biyapul nhina yukurra waŋgany‐manapanmirri yurru Godkala. Bukmak nhuma yurru Godkunydja yolŋu'‐yulŋu ŋunhi miṯtji ga miṯtji ga miṯtji marrtjiya waŋgany‐manapanmiyana yukirriya ŋunhiwala Godkalana buṉbulili, bala waŋganynha ŋayaŋunydja nhuma yurru yukirriya wuyunmiya nhumalaŋgalayŋuwu yätjkunydja malaŋuwu. Yakana nhuma yurru djuḻuḻ'marama nhumalaŋguway yätjtja malanha, yana nhuma yurru wuyundja yukurra nhina ŋunhi ŋoy‐ŋathamiriwnha, bitjan ḻakaranharamirrina yukurra yanana yurru Garraywala, bala bathan marrtji wäyinnha malanha ŋunhiwala barŋlilinydja, märr yurru ŋuliwitjandhiyi wäyingalanydja gulaŋ‐waṉḏinyarayu ŋayi yurru Godthunydja ŋäkirrmaramana yana warrpam'nha nhumalaŋgu yätjpuynha. ");
INSERT INTO gnn_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Yaka yana ŋuriŋiyinydjayi waluyu djäma yukirriya, yana nhuma yurru djämanydja ŋunhiyi liŋgu rom ŋunhi Godthu gurrunhara, märr yurru ŋuliwitjandhinydjayi Godthu buwayakkumana nhumalaŋgu nhänydja malanha yätjtja. ");
INSERT INTO gnn_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Ŋuli yurru ŋula yol yolŋu yakanydja bilyun nhanukalayŋuwu ŋayi yätjku ŋuriŋiyinydjayi waluyu, yakanydja ŋayi yurru wuyun yukurra nhina ŋoy‐ŋathamiriw, ŋunhiyinydjayi yolŋu yakana yurru nhanŋu Garraywu biyapulnydja. ");
INSERT INTO gnn_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Ga ŋuli ŋayi yurru ŋula yolthu yolŋuyu djäma yukurra ŋula nhä ŋuriŋinydja ḏaykun'thu, ŋayinydja yurru Garrayyunydja yana ŋanya baḏuwaḏuyunna ŋunhiyi yolŋunha. ");
INSERT INTO gnn_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","32","Yo, ŋunhiyinydjayi walu yukurra yurru dhärra yana nhanŋuwaynha gal'ŋu dhulŋuŋuna ganaŋ'maranharana gupaḏalkunharana, yakana yana yurru ŋula yolthu yukurra djämanydja ŋuriŋiyi waluyu, yana nhuma yurru nhinana yukurra ŋoy‐ŋathamiriwnha, wuyunna nhuma yurru yukurra yana nhokalayŋu yätjkuna ŋurikina. ");
INSERT INTO gnn_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","34","“Dhäŋuru ŋuliŋurunydja ŋunhi Godthu biyapul yuṯakuŋala miṯtjinha nhanŋuway, ŋuliŋuruyinydja dhurrwaraŋuru walunydja yurru ḏämbumiriwnha djuḻkthun, ga ŋunhinydja bala wiripunydja walu, ŋunhinydja gänana gal'ŋu dhulŋuŋuna nhanŋuwaynha Garraywuna, yäku ‘Buṉbunharamirrina Walu.’ ");
INSERT INTO gnn_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","36","Yakana yurru nhe yana ŋuriŋiyinydjayi waluyu djäma ŋula yolthu yolŋuyu, yana nhuma yukurra yurru mundhurrnha wekama Garraywu ŋathana malanha walu‐ŋupanna‐a‐a, yana liŋgu ga 7 walu yurru djuḻkthun, ga wiripuŋuyunydja waluyu nhuma yurru marrtji waŋgany‐manapanmirri buku‐ŋal'yunarawuna. Ŋunhiyinydjayi walu buku‐ŋal'yunarawu yana, yaka nhuma yurru djäma yukurra ŋuriŋiyi dhä‐yawar'yunarayunydja waluyu, liŋgu ŋunhiyinydjayi gäna gal'ŋu yana dhulŋuŋu Garraywu nhanŋuway. ");
INSERT INTO gnn_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","38","“Yo, bitjan liŋgu walu ŋupan nhuma yukurra yurru ḻuŋ'maranhamirrinydja buku‐ŋal'yunarawunydja bitjan mundhurr wekama Godku, nhuma yurru buma wäyindja, bala bathan barŋlilina, bala yurru ŋayi Godthunydja yakana nhäma ŋilimurruŋgu yätjpuynydja, liŋgu ŋuriŋinayi gulaŋ‐waṉḏinyarayu wäyingalana. Ga ŋuriŋinydja wiripuŋuyunydja waluyu guyaŋinyaramirriyunydja ŋunhi ŋayi ganaŋ'maraŋala Garrayyu nhanŋuway ŋayi, nhuma yurru biyapul wekama bukulili ŋal'marama ŋunhiwalayi ŋunhi nhuma ŋuli marrtji wekama bitjan liŋgu munhamandhirri. ");
INSERT INTO gnn_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“Yo, ŋunhi nhuma yurru 7‐dhunydja ŋuriŋiyi ŋaḻindiyu ḻuŋ'maranhamirri waŋgany‐manapanmirri waŋganylilina ŋuriŋi 15‐dhunydja waluyu, nhuma yurru yukurra nhina waŋganyŋura 7‐nha walunydja ŋupan, goŋmirriyirrina dhikana wal'ŋu, ŋayaŋu‐djulŋithirrina bitjanna yurru, liŋgu djämanydja liŋguwuynha dhawar'maranharana warrpam'puynha; ŋathanydja ŋunhi gulkthunarana liŋguwuynha ḻuŋ'maranharana gänharana ŋunhiwalayi ŋathawuylilina buṉbulili. Yo, ŋunhi ŋurruŋunydja walu wal'ŋu ŋurikiyi djulŋithinyamirriwunydja waluwu, ŋunhiyinydjayi gäna yana gal'ŋu; märr nhuma yurru ŋayaŋuna‐nhina yukurra yänana, yakana ŋula djäma ŋuriŋinydjayi waluyu. ");
INSERT INTO gnn_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Yo, ŋuriŋi ŋurruŋuyunydja waluyu nhuma yurru marrtji bala gulkthunna ḻatjuny'tja dhikanydja wal'ŋu yana muḻkurr borum dharpaŋuru, ga bitjandhiyi nhuma yurru gulkthundhi baṉdja'‐baṉdjanydja ŋurikiy dharpawuy, bala buṉbuŋana bala'palakuŋana yurru. Bala nhuma yurru yukurra nhinana ŋunhili buṉbuŋuranydja 7‐nha walunydja, märr‐yingathirrina gal'ŋu bitjanna, märr‐ŋal'yunna manapan yurru nhanukala, goŋmirriyirrina wirrkina Garraywala nhokalaŋuwala Godkalanydja. ");
INSERT INTO gnn_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Yo, bitjan liŋgu dhuŋgarra watjthirri nhuma yurru djämanydja yukurra dhuwalayi romdja ŋuriŋinydja 7‐dhunydja ŋaḻindiyu, nhinanydja nhuma yurru yukurra galŋa‐djulŋithirrina dhikana wal'ŋu 7‐nha walunydja ŋupan, liŋgu dhuwalayinydja nhanŋuway wal'ŋu yana Garraywu Godku galŋa‐djulŋithinyaramirri walu, galŋa‐ḻayyunaramirri, ga romdja dhuwalayi yukurra yurru dhärra bitjanna liŋguna gupaḏalnha‐wala. ");
INSERT INTO gnn_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","43","Yo, ŋuriŋiyi 7‐dhu waluyu nhuma yurru yukurra nhina ŋunhiliyina buṉbuŋura bala'palaŋurana, märr yurru nhumalaŋgu yumurrku' ga gutharra'mirriŋu walala marŋgiyirri marrtji nhäma dhipalayi, ŋunhi ŋarrakuwaynydja yolŋu walala Yitjuralpuyŋunydja nhinana yukurrana ḏalwaḏalwa'ŋura warray buṉbuŋura malaŋuŋura, ŋunhi ŋarra dhawaṯmaraŋalanydja walalanha walŋakuŋala beŋuruyi Yetjipŋurunydja. Yo, ŋarrapi dhuwala Garraynydja nhumalaŋgu God Waŋarnydja.” Ga bitjarrayina ŋayi yukurrana Godthu ḻakaraŋalanydja Mawtjitjkala. ");
INSERT INTO gnn_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Ga ŋayinydja Mawtjitjthunydja ḻakaraŋala yolŋu'‐yulŋuwa ŋuripa Yitjuralpuyŋuwana, märr yurru walala dhuŋgarra‐watjthirri bitjan liŋgu waŋgany‐manapanmirrinydja yukurra, bala buku‐ḻuŋ'thun waŋganyŋurana, bitjan goŋmirriyirrina wal'ŋu dhikana ŋuriŋiyinydjayi dhulŋuŋuyunydja gal'ŋu nhanukalaynydja ŋayi waluyu. Yo, Godthu ŋayipi ŋunhi nherrara ŋunhiyi romdja, liŋgu ŋuriŋiyinydjayi malaŋuyu romdhu yukurra ḻakarama mayali' ŋurikinayi ŋunhi ŋayi yurru Garrayyu ŋayipi djäma yalalaŋumirriyu nhanukalayŋuwu ŋayi yolŋu'‐yulŋuwu. ");
INSERT INTO gnn_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Yo, Garrayyu nherrara rom dhuwala malanha gam' nhanukalaŋuwu ŋayi yolŋu'‐yulŋuwunydja. “Yaka nhuma yurru buku‐ŋal'yun ŋula nhaltjan wiripuŋuwunydja ŋuriki goŋbuywunydja waŋarrwu, ga yaka yana djäma ŋula nhä dharpa yolŋukuŋa ga wäyinguŋa ga bäpikuŋa maḏayin'kuŋanydja. Yaka yana nhe yurru yukirriya nherrala dharpa ga guṉḏa ŋula nhä ŋunhi walala yurru yolŋu'‐yulŋuyu yukurra nhäma ga ḻakarama ŋunhiyi maḏayin' waŋarr, liŋgu waŋgany ŋarrapi yana Godtja waŋarrnydja nhumalaŋgu. ");
INSERT INTO gnn_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Nhuma yurru ganaŋ'maraŋa ŋarrakuwaynydja ŋunhi walu, liŋgu ŋunhiyinydjayi nhinanharamirri walu dhuyuna ŋarrakuwaynha. Ga bitjandhi liŋgu nhuma yurru ŋarrakunydja ŋunhi buṉbunha ganaŋ'maramayi, yaka wakalkuŋanydja, liŋgu ŋunhiyinydjayi wäŋa ganaŋ'maranharana ŋarrakuwaynha wal'ŋu yana buku‐ŋal'yunarawu, liŋgu ŋarrapi waŋarrnydja wal'ŋu Garray nhumalaŋgu.” Ga bitjarra ŋayi Garray waŋananydja. ");
INSERT INTO gnn_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","10","“Ŋuli nhuma yurru marrtji yukurra ŋarrakalaynydja yana wal'ŋu romgurru, ga märrama dhäruk ŋarranhaynydja, ŋarranydja yurru ŋunhi djäkana marrtji nhumalaŋgu, djuy'yunna ŋarra yurru waltjaṉnha nhumalaŋgu, märr yurru nhumalaŋgu wäŋanydja ŋunhiyi ḻatju' muka, gurarrthirri muka yurru ŋathanydja ga borumdja ga mulmunydja ga ŋula nhänydja, guḻku'na yurru wal'ŋu gurarrthirri yukurra, ga nhuma yukurra yurru nhina ŋunhiliyi wäŋaŋura walŋana, marimiriwnha yana ga barrarimiriwnha yurru. Yo, ŋamathamana nhuma yurru nhina yukurra, ŋayaŋu‐ŋamathirrina yanana, yakana yurru nhumalanha ŋula yolthu barrari‐wukumanydja. Ŋuli yurru miriŋunydja marrtji nhumalaŋgu, nhumanydja yurru yana ŋupanna barrari‐wukumana walalanha, baḏuwaḏuyunna warrpam'nha; nhumapina yurru djuḻkmaramanydja. Yo, djämana yana ŋarra yurru‐wala yulŋunydja, guŋga'yunna yurru ŋunhi dhäruk‐märranharamirrinhanydja yolŋu'yulŋunha, ga djäma ŋarra yurru yukurra bukmak yana ŋunhiyi ŋunhi nhaltjarra ŋarra dhawu'mirriyaŋala ŋäthili. ");
INSERT INTO gnn_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","12","“Yo, ŋunhi nhuma yurru yukurra nhina ŋarrakalaynydja romŋura, ga märrama dhäruktja ŋarranha, bala ŋarranydja yurru yukurra nhinayi nhumalaŋgala ṉapuŋga yana; marrtji'‐marrtjinydja ŋarra yurru yukurra ŋuliyi nhumalaŋgala galki, yakana ŋarra yurru gonha'yun ga ḏiltjinydja wekama nhumalaŋgu. Ŋarranydja yurru nhumalaŋgu Garray Waŋarrnha, ga nhumanydja yurru ŋarraku yolŋuna walala. ");
INSERT INTO gnn_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Ŋäthilinydja nhuma yukurrana nhinana ŋunhalanydja Yetjiptja dhuwurr‐garrpiṉara muka, yurru ŋarranydja nhumalanha dhawaṯmaraŋala warray, märr nhuma yurru nhina ŋayaŋu‐ŋamathirrina, ga marrtji yänana ŋula nhämiriwnha. Yo, ḏälkuŋa ŋarraku romdja, bala nhuma yurru nhina yukurra walŋana yana, ŋayaŋu‐ŋamathirrina yanana. ");
INSERT INTO gnn_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","16","“Ga ŋuli nhuma yurru bilyundja, ḏiltjinydja wekama ŋarraku, yakanydja dhäruk märrama, bala ŋuyulkthirrinydja yurru ŋarrakalaŋuwu romgu, ga märr‐ŋal'yun wiripuŋuwunydja waŋarrwu, bala nhumanydja yurru ŋayaŋu‐yätjthinyaramirrina märrama ŋuriŋiyinydjayi romdhunydja. Yo, ŋula nhäna yurru maḻŋ'thun nhumalaŋgu, barrarimirrina rom. Nhuma yurru rirrikthunna, bala murrmurryunna, ga wiripu‐guḻkuny'tja yurru bambaythirrina marrtji, ga yalŋgi'yirrina rerriyuna. Ga djämanydja nhe yurru ŋula nhä ŋatha maŋutji dholkumanydja, yurru yakana nhuma yurru ḻukanydja ŋuliŋuruyi ŋathanydja, liŋgu ŋula yolnha miriŋuna yurru marrtji, bala walalana yurru ŋunhiyi gulkthundja, ga nhumanydja yurru djaṉŋarrmirrina nhina yukurra. ");
INSERT INTO gnn_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","“Yo, ŋuli nhuma yurru gonha'yundja ŋarranha, ŋapanydja wekama ŋarraku, bala ŋarranydja yurru ŋapayi wekama nhumalaŋgunydja, bala nhumalaŋgu yurru miriŋuna marrtji, bumana nhumalanha yurru marrtji, bala ŋayina yurru buŋgawakunharamirri ŋanyapinyay ŋayi nhumalaŋgunydja, yana nhuma yurru waṉḏirrina yukurra yulŋunydja, barrarirrina yurru ŋula nhäkunydja. ");
INSERT INTO gnn_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Yo, balakurruyinydja ŋarra yurru nhumalanha yana marŋgikuma, märr nhuma yurru roŋiyirri ŋarrakala. Ŋuli nhuma yurru yakanydja bilyun yätjŋuru lili ŋarrakala, mukthundja yana märr‐yuḻkthundja ga ŋuyulkthirrinydja yurru ŋarraku, ŋarranydja yurru biyapulnha wal'ŋu ŋonuŋnha ŋula nhä gurrunhan nhumalaŋgu. ");
INSERT INTO gnn_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","“Yo, nhumanydja ŋuli ŋunhi guyaŋinyamirri yanapi nhuma ganydjarr‐ḏilkurru, yurru ŋarranydja yurru ŋunhiyinha bakmarama warray, bala yurru nhe galkirrina yana ganydjarrmiriwyirrina yulŋunydja. ");
INSERT INTO gnn_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Yo, djämanydja nhuma yurru djäma warray, wirrki warray dhika, yurru yakana ŋayi yurru ŋatha ŋuthandja, ga dharpanydja yurru yakana borummirriyirri. ");
INSERT INTO gnn_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","26","Ŋuli nhuma yurru mukthundja yana mäkiri'‐yarryundja ga ŋuyulkthirrinydja ŋarrakalaŋuwu romgu, yindina yurru marinydja marrtji nhumalaŋgu, ga wakinŋuna yurru wäyin maḏakarritjmirrina marrtji ga buma nhumalaŋgu yumurrku'nhana, ga guḻku'na yurru marrtji murrmurryun rerriyuna. Ga wiripunydja yurru miriŋuna marrtji, bala bumana marrtji, bak‐bakmaramana yurru marrtji nhumalaŋgu wäŋanydja, ga bukmak yurru nhuma djaṉŋarrnha yukurra nhina, liŋgu ŋathamiriwnha ŋunhiyi yukurra yurru wäŋa dhärra. ");
INSERT INTO gnn_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“Yo, bitjandhiyina yurru nhumalaŋgu maḻŋ'thundja, märr yurru nhuma bilyun roŋiyirriyi ŋarrakala, liŋgu nhumanydja dhuwala ŋarrakuway yana wal'ŋu. Ga ŋunhi nhuma yurru yaka bilyun ga roŋiyirri ŋarrakala, mukthun yurru nhuma yukurra yana märr‐ŋal'yun wiripuŋuwu waŋarrwu, ga yaka dhärukku malthun ŋarraku, ");
INSERT INTO gnn_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","bala ŋarranydja yurru mirithirrina yana ŋaramurryirri nhumalaŋgu, wirrkina yana ŋarra yurru dhä‐ḏir'yundja nhumalanha.” Ga bitjarra ŋayi Garray waŋananydja. ");
INSERT INTO gnn_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","“Yo, nhuma yurru mirithirrina yana djaṉŋarrthirrinydja, ga yana liŋgu‐u‐u ga wiripu‐guḻku'yunydja nhuma yurru ḻuka nhumalaŋguway yumurrku'nhana djamarrkuḻi'nha. ");
INSERT INTO gnn_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Ŋarra yurru ḏaw'‐ḏawyunna marrtji ŋunhiyinydjayi wäŋa ŋunhi wanhaŋumi nhuma yukurra buku‐ŋal'yun wiripuŋuwu waŋarrwu. Ŋunhiyi yurru nhumalaŋgu be waŋarrnydja burruḻ'yunna marrtji muṉguythirrina, ga nhumanydja yurru dhambayyi yana galkirri burruḻ'yun, rakunydhirrina marrtji ŋurikalayi nhumalaŋgalaŋuwala waŋarrwalana manapan. ");
INSERT INTO gnn_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Ŋarra yurru baḏuwaḏuyunna nhumalaŋgu ŋunhiyinha wäŋanhanydja, warrpam'nha yana baḏuwaḏuyun, ga ŋunhi nhuma yurru mundhurr‐wekama ŋarraku, ŋarra yurru ŋunhiyinydja yakana märrama nhumalaŋguŋu. ");
INSERT INTO gnn_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Ga ŋunhi ŋayi yurru miriŋunydja marrtji ŋunhimalayi nhumalaŋgala wäŋalili, bala nhämana, ga waŋa ŋayi yurru bitjanna, ‘Dhuwalanydja yätjnha wäŋa mirithirrina, warrpam'thunarana buḻwaŋ'maranhara, baḏuwaḏuyunara,’ bitjanna yurru. ");
INSERT INTO gnn_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","39","“Yo, miriŋunydja yurru ŋunhiyi marrtjina lili, bumanydja marrtji walala yurru nhumalanha, barrkuwatjkumana yana wiripuŋulilina wäŋalili malaŋulili, ga dhuwalayinydja wäŋa yurru nhumalaŋgu yolŋumiriwnha yukurra djingaryun. Bala nhuma yurru mirithirrina barrarirrinydja, waṉḏirrina nhuma yukurra yurru gupa‐ḏawa'mirrina, bala galkirrina gänana yana, ŋunhi yakana nhumalaŋgala ŋayi yurru ŋunhi miriŋu galkithirri. Yakana nhuma yurru buku‐ruŋinyamarama ŋupandja bumanydja bala ŋunhiyi miriŋunhanydja, yana nhuma yurru nhina yukurra ŋunhilina miriŋuwalana goŋŋura, ŋunhana‐wala wuyupthunna barrkuna. Bala nhuma yurru raku'‐rakunydhirrinydja ŋunhilinayi barrkuna, mulkuruŋurana wäŋaŋura; märr‐ḻurrkun'nha yana yurru nhuma nhinanydja yukurra, ga walalanydja yurru ŋunhiyinydja walala yalŋgi'mirrina yanana, liŋgu ŋuriŋi walalaŋgala yätjthu romdhu. ");
INSERT INTO gnn_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","45","“Ga ŋunhi nhuma yurru yukurra nhina ŋunhiliyi miriŋuwala goŋŋura bena‐wala barrkuna, bala nhumalaŋguŋu mala‐wunharanydja yurru bilyunna, ga waŋa wuyunna yurru, ḻakaranharamirrina yurru Godkala ŋurikiynha ŋunhi walala yukurrana djäma yätj. Ga bitjandhi liŋgu walala yurru wuyunna walalaŋgalaŋuwu märi'muwalaŋunydja yätjku, ŋunhi walala ŋapa‐wekaŋala ŋarraku, bala buku‐ŋal'yurruna wiripuŋuwuna waŋarrwu. Yo, ŋuliŋuruyina dhäŋuru ŋunhi nhuma wirrkina ŋayaŋu‐yätjthina yukurrana, liŋgu ŋuriŋi nhokala yätjthu, bala nhuma yurru nyilŋ'maranharamirrinydja nhumalanhay nhuma, bala yurru ŋarra yana buku‐ḻayyunna ŋuriŋiyi dhawu'yunydja ŋunhi ŋarra dhawu'‐nherrara ŋäthili Yipurayimgala ga Yitjakkala ga Djaykupkala. Bala ŋarra yurru yana bäy‐ḻakaramana yulŋunydja nhumalaŋgu, bala biyapulyi nhuma yurru yulŋunydja ŋarrakuway yolŋu'yulŋunydja, ga ŋarranydja yurru nhumalaŋgu waŋarrnha, ga ŋunhiyi yurru manymaktja wäŋa nhumalaŋguwayyi. Yurru ŋäthilinydja nhuma yurru burakirri ŋayaŋu‐yätjthirri yana wirrki wal'ŋu, liŋgu nhuma ŋapa‐wekaŋala ŋarrakalaŋuwu romgu, ga yaka nhuma dhäruk‐märraŋala ŋarraku. Yurru yaka ŋarra yurru warrpam'thundja nhumalanha gonha'yun, yaka nhuma yurru bukmakthirrinydja murrmurryun ŋunhili miriŋuwalanydja goŋŋura, liŋgu ŋarranydja nherrara liŋgu dhawu'‐nherrara nhumalaŋgalanydja, ga ŋarranydja nhumalaŋgu waŋarr dhuwala God. Ŋäthilinydja wal'ŋu ŋunhinydja ŋarra nhumalaŋgu märi'munha dhawaṯmaraŋala märraŋala ŋulaŋuru Yetjipŋuru, ŋurikala miriŋuwala ŋarambiya'ŋuru goŋŋuru. Ga ŋunhi nhuma yurru wuyundja nhumalaŋgalaŋuwu yätjku, bala bilyun roŋiyirri ŋarrakalanydja, ga ḻakaranhamirrina yurru ŋarrakala ŋunhiyi ŋunhi nhuma djäma yätj dhuwurr, bala ŋarranydja yurru biyapul nhumalanha dhawaṯmaramana ŋuliŋuruyi miriŋuwalanydja goŋŋuru, märr yurru nhumanydja ŋarrakuwaynha yolŋu walala, ga ŋarranydja yurru nhumalaŋgu God waŋarrnha gupaḏalŋuwuna‐wala.” ");
INSERT INTO gnn_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Ga dhuwalayina ŋayi ŋunhiyi rom Godthu wekaŋala Mawtjitjkalanydja ŋuriki nhanukalayŋuwunydja ŋayi yolŋu'‐yulŋuwu miṯtjiwu Yitjuralpuyŋuwunydja. ");
INSERT INTO gnn_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","34","Ga dhuwalana wiripunydja rom ŋayi Garrayyu wekaŋala gam' Mawtjitjkala nhanukalayŋuwu ŋayi yolŋu'‐yulŋuwu. “Ŋunhi yurru wäyin ŋurruŋu yothu dhawal‐wuyaŋirri, balanyara bitjan buliki ga ŋula nhä läm, nhumanydja yurru ŋunhiyinydja wäyin wekamana Garraywu, liŋgu nhanŋuwaynha ŋunhiyinydja ŋurruŋunydja dhawal‐wuyaŋinyara. Ga ŋunhi nhuma yurru ŋuthanmarama ŋathanydja ga ŋula nhä borum, nhuma yurru yana gulk‐gulkthurrayi biyaka 10‐guŋa, bala wekaŋa waŋganydja wakana ŋuliŋuruyinydja Garraywuna, liŋgu nhanŋuway ŋunhiyinydja Garraywu, yaka nhuŋu. Yo, ŋula nhä nhe yurru märramanydja, nhe yurru ŋuliŋuruyi ganaŋ'maraŋa Garraywuna; gulk‐gulkthurranydja nhe yurru ŋäthili 10‐guŋa, ga waŋganydja ŋurruŋunydja ŋunhi gulk‐gulkthunara nhanŋuway Garraywuna ŋunhiyinydja, yakana yurru yolŋuyu ŋunhiyinydja, nhanŋuwayliliyama ŋayi.” Yo, dhuwalayina rom malanha ŋayi wekaŋalanydja Garrayyu Mawtjitjkala ŋunhala bukuŋuranydja. ");
INSERT INTO gnn_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","54","Yo, ŋunhiyi walala Yitjuralpuyŋu mukthurruna yana nhinana yukurrana ŋunhili ŋanhdharkŋura wäŋaŋura, bala ŋayi Garraynydja waŋanana Mawtjitjkala ŋunhiliyi Withiyanminyarawuyŋuranydja Buṉbuŋura, ga bitjarrana ŋayi waŋana gam', “Nhumanydja maṉḏa Yärun ga Mawtjitj, nhumanydja yurru bothurruna marrtji yolŋu'‐yulŋunhanydja bukmaknha yana Yitjuralpuyŋunhanydja, nhämunha' ŋunhi bäpurru' ga bäpurru' ŋunhilimi miṯtjiŋura.” Bala ŋuriŋi maṉḏathu ga wiripu‐guḻku'yu ŋurru'‐ŋurruŋuyu walalay marrtjina bothurruna yolŋu'‐yulŋunhanydja, bala walala wukirrina ŋunhiyi nhämunha' miṯtji ga yäku malanha ŋunhawala djorra'lilina, ga yana liŋgu ga bukmak ŋunhiyi bothurruwuynha warrpam'nha. Ga bitjarrayi walala bothurruyi miṯtjinha bäpurru'nha ŋunhi Lepaynhanydja walalanha, yurru yaka ŋunhi walalanha rrambaŋikuŋalanydja waŋgany‐manapara wiripu‐guḻku'walanydja Yitjuralpuyŋuwalanydja, liŋgu ŋunhiyinydja Lepaynydja yäku miṯtji ganaŋ'thun yukurra gäna gal'ŋu nhanŋuway Garraywu yana. Yo, ŋayi Garraynydja waŋana bitjarra, “Dhuwalanydja gay' Lepaynydja walala djäkamirri walala dhiyakuna gay' buṉbuwu ŋarrakalaŋuwuna djäkawu. Ŋunhi nhuma yurru girri'‐ŋamathirri marrtjinyarawuna, walalanydja yurru ŋuriŋi Lepayyunydja walalay yupmaramana ŋunhiyi ŋarraku ḏalwaḏalwany'tja buṉbunydja, ga walalana yurru yukurra gurrukumanydja bala, yana liŋgu ga nhina nhuma yurru wäŋarama yuṯaŋura wäŋaŋura, ga ŋunhalayi walala yurru ŋuriŋiyi Lepayyunydja walalay ŋal'marama balayi ŋunhiyi ḏalwaḏalwany'tja buṉbu. Walala yurru Lepaynydja miṯtji ŋunhiyi ŋorranydja marrtji galki yana ŋunhiliyi ḏalwaḏalwa'ŋura buṉbuŋura, gungama yurru yukurra ŋunhiyi, yurru yakana wiripunydja yurru yolŋu marrtji galkithirri ŋunhiwalayi; walala ŋuli bäynha murrmurryurru.” ");
INSERT INTO gnn_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","34","Ga ŋunhi walala ŋuli Yitjuralnydja marrtjinya, ga ŋorranha walala ŋuli wäŋaranha gandarrŋuranydja, walala ŋuli marrtjinya ŋorranhanydja miṯtji ga miṯtji ga miṯtji bitjana bala, ŋuliwitjanayi ḻiw'maranha yana ŋunhiyi ḏalwaḏalwa'nha buṉbunha, liŋgu ŋunhiyi Godkunydja buṉbu yukurranha ŋuli djingaryuna ṉapuŋga' yana gal'ŋu dhulmuŋura wäŋaŋura. Ga ŋunhi walala ŋuli ḏurryuna ga marrtjinya wiripuŋulilinydja wäŋalili, marrtjinyanydja walala ŋuli mala ga mala ga mala bitjana, ga walalanydja ŋuli ŋunhiyi Lepaynydja mala marrtjinya yukurranha ga ŋuliwitjana ṉapuŋga'kurru yana, gänha marrtjinya ŋuli ŋunhiyi ḏalwaḏalwa buṉbu Godku ga girri' malanha ŋurikiyi. ");
INSERT INTO gnn_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","10","Yo, ŋayi Garrayyu djarr'yurruna Yärunnha ga nhanŋu gäthu'mirriŋunha walalanha ḏämbumiriwnha, walalana ŋunhiyina walala Godku ḏalkarra'mirrinydja walala, walalawuy yana ŋuriŋiyi ŋuli djäma ŋunhiyinydjayi rom ŋunhi walala ŋuli yolŋu'‐yulŋu marrtjinya galkithinya gal'ŋu Gunhu'wala ŋuliwitjanayinydjayi romgurru. Ga wiripu‐guḻkuny'tja ŋunhiyi Lepay miṯtji ga djämamirrina walala ŋurikiyina walalaŋgu ḏalkarra'mirriwuna; walalana ŋuli djäka yukurranha Godkalaŋunydja buṉbuwu, guŋga'yuna ŋunhiyi ḏalkarra'mirrinhanydja yolŋu'‐yulŋunha, ga bukmaknha ŋunhi yolŋu'‐yulŋunha. ");
INSERT INTO gnn_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","13","Bala ŋayi Garray waŋana Mawtjitjkala bitjarra, “Dhuwali Lepaynydja yolŋu'‐yulŋu ŋarrakuwaynha walala yana. Ŋäthilinydja ŋunhinydja maḻamarrmirri ŋurru'‐ŋurruŋu ḏarramuwurru dhawal‐wuyaŋinyara ŋarrakuway yana ŋunhiyinydja, liŋgu ŋunhili ŋarra walalanha walŋakuŋalanydja, ŋulinyaramirriyu ŋunhi ŋarra marrtjina bumara bala Yetjippuyŋunha maḻamarrmirrinha yolŋu'‐yulŋunha. Ga dhiyaŋunydja‐wala Lepaynydja miṯtji ŋunhinydja yurru ŋarrakuwaynha, dharapulŋura ŋurikalana walalaŋgala maḻamarrmirriwalana birrka'mirriwala ŋurikala miṯtjiwala. Nhumanydja yurru walalanha miṯtjinha Lepaynhanydja barrkuwatjkumana ganaŋ'maramana ŋarrakuwaynha yana dhiyaŋunydja‐wala. Ga bitjandhi yurru wäyindja malanha walalaŋgu Lepaywu ŋarrakuway yana.” Ga bitjarra ŋayi Garray waŋananydja. ");
INSERT INTO gnn_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","20","Yo, Lepaywunydja ŋunhi ḻurrkun'nha gäthu'mirriŋu walala ḏarramuwurrunydja, dhuwalana walala yäku gam', Gutjum, ga Gowat ga Merari, bala ŋayi Garrayyu djäma ḻakaraŋalana walalaŋgu Lepaywunydja miṯtjiwu. Ŋunhi walala ŋuli ḻaw'yunanydja wiripuŋulilinydja wäŋalili, walalanydja ŋuli Gowatkalanydja gäthu'mirriŋuyu walalay gänha yukurranha Dhawu'‐nherraṉminyarawuy Bathi ga wiripu malanha dharrpal girri', yurru ŋäthilinydja walala ŋunhiyi dhuyunydja marrtjinya ŋuli ḏalkarra'mirriyu yolŋu'‐yulŋuyu metj‐bilkthuna ŋunhiyi malanha dharrpalnydja dhomala'yu milkuminy'thuna, yurruna walala ŋuli wekanha ŋurikala Gowatpuyŋuwalanydja miṯtjiwala gänharawu. Ŋuriŋina bili ḏalkarra'mirriyu walalay yurru ŋayathamanydja ŋunhiyi dharrpalnhanydja gal'ŋu girri'nha, ga ŋuli ŋayi yurru ŋula wiripuŋuyunydja yolŋuyu ŋayathama, ŋayinydja yurru yana rakunydhirrina. ");
INSERT INTO gnn_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","33","Ga walala wiripu‐guḻku'yunydja gäthu'mirriŋuyu walalay Gutjumgalanydja, walala ŋuli marrtjinya gänha ŋunhiyi girri' dhomala' ga wäyin barrwaṉ ŋunhi ŋuli marrtjinya ŋäkirrmaranha ŋunhiyi buṉbu, ga walalanydja ŋuli gäthu'mirriŋuyu walalay Merariwalanydja marrtjinya gänha dharpana malanha ŋurikiyinayi waḏaŋga' ŋal'‐ŋalmaranharawuna. Ga walalanydja ŋuli Yärungalanydja gäthu'mirriŋuyu walalay djäma ḻakaranha marrtjinya walalambalana ŋuripana miṯtjiwana waŋga'‐waŋganyba Lepaywanydja, nhä walala yurru yukurra gäma'‐gama. ");
INSERT INTO gnn_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","21","Ga biyapul ŋayi Garrayyu wekaŋala wiripuna rom nhanukalayŋuwu ŋayi yolŋu'‐yulŋuwu Mawtjitjkala, dhuwala gam'. “Ŋunhi yurru ḏarramu mak dhäyka ḏukṯukthirri nhinanharawu gänaŋuwu ganaŋ'maranharawu ŋarrakuway gal'ŋu Garraywu, ŋayi yurru ŋuriŋinydjayi yolŋuyu nherraṉ mirithirrina wuṉḏaŋarrnha dhawu'‐nherraṉminyara ŋarrakalay yäkuyu, ga ŋuliŋurunydja dhäŋuru ŋayi yurru yakana ḻuka ŋänitjiny'tja ŋula nhänydja ḏälnydja leŋumirrinydja gapu, yana ŋayi yurru warrpam'thunna gonha'yun. Ga bitjandhiyi ŋayi yurru yakayi gulkthunmirri marwattja ŋanyapinyay ŋayi ga bolutju mitthunmirri wiriny'tjunmirrinydja; marwattja yurru nhanŋu ŋuthan weyindhirrina, yanana liŋgu‐u‐u ga dhawar'yun ŋayi yurru ŋunhiyi dhawu'‐nherraṉarawuy walu. Walala yurru yolŋu'‐yulŋuyu nhäma ŋunhiyi nhanŋu marwat weyindhinyara ŋuthanara, bala walala yurru dharaŋanna ŋunhiyi, ŋunhi ŋayinydja yuwalkkuŋala yana ŋanyapinyay ŋayi ganaŋ'maranharamina Garraywu nhanŋuway waŋganygu. Ga ŋunhiyi yolŋu, yaka ŋayi yurru marrtji ŋulinyaramirriyunydja ŋunhi yukurra yurru rakuny yolŋu ŋorra, bäyyi ŋunhiyi nhanŋu yurru ŋäṉḏi'mirriŋu wo yapa'mirriŋu wo bäpa'mirriŋu rakunydhirri, ŋayinydja yurru ŋunhiyinydjayi yolŋu yukurra nhina barrkuna yana, märr yurru ŋayi yakana ŋunhiyi goŋ‐yiŋapuŋapu'mirriyirri ŋurikalayinydja rakunygalanydja mulkanharayu. Bitjanna liŋguna ŋayi yurru ŋunhiyi ḏarrtjalknha yana ganaŋ'thunarana nhina yukurra, yana liŋgu‐u‐u, ga ŋunhiyi dhawu' yurru dhawar'yun. Bala ŋayi yurru marrtji Garraywalana ŋunhana buṉbulili wal'ŋu, bala djämana ŋayi yurru ŋunhiyi romnha, ŋunhi ŋayi Garrayyu ŋayipi nherrara. Yo, ŋunhi yurru ŋayi yolŋu dhawu'‐nherraṉmirri Garraywalanydja yäkuyu, djämanydja ŋayi yurru bitjandhi yana liŋgu ŋunhi ŋayi dhawu'‐nherrara.” ");
INSERT INTO gnn_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","23","Ga bitjarra liŋgu ŋayi Garrayyu ḻakaraŋalayi Mawtjitjkala bitjarranydja gam'. “Ḻakaraŋa Yärunba ga gäthu'mirriŋuwa walalambala nhanukalaŋuwa biyaka, walala yurru goŋmirriyama ŋunhiyi yolŋu'‐yulŋunha Yitjuralpuyŋunhanydja dhiyaŋuna dhärukthu gam', ");
INSERT INTO gnn_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","Garrayyunydja ŋayipinydja yurru gäma yukurra nhumalanha ḻatju'kumana wal'ŋu dhika, gunganhamirriyama nhumalanha yätjŋuru, ");
INSERT INTO gnn_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","ŋayipi yana yurru nhumalaŋgu mel‐wuyundja marrtji, ŋayaŋu‐djulŋikuma nhumalanha nhanukalay ŋayi märryu‐ḏapmaranharamirriyunydja. ");
INSERT INTO gnn_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Ŋayi yurru nhämanydja nhumalanha galŋa‐djulŋithirrina dhikana wal'ŋu yanana, bala nhuma yurru nhinanydja yukurra ŋoy‐wurrkurrum'nha yana, dhambay nhanukalana. ");
INSERT INTO gnn_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","“Yo, ŋuliwitjandhiyinydjayi ŋuriŋi ḏalkarra'mirriyunydja walalay nhumalanha yurru bitjan goŋmirriyamana ŋarrakalaynydja yäkuyu, ga yuwalk yana ŋarra yurru ŋunhiyi goŋmirriyamanydja ŋarrakuway ŋarra yolŋu'‐yulŋunhanydja.” ");
INSERT INTO gnn_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","16","Yo, ŋulinyaramirriyu ŋunhi walala dhawar'yurruna ŋuliŋuruyi ŋal'maranharaŋuru Godkala buṉbuŋuru, bala ŋayinydja ŋunhi waŋupininy'tja marrtjinana, bala ŋäkirrmaraŋalana ŋunhi buṉbunhanydja, gorruŋalana yukurrana ŋunhili yana bäyma, ga munhakunydja ŋayi ŋuli ŋunhiyi waŋupini bitjana gurthayinyana. ");
INSERT INTO gnn_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Ga ŋunhi ŋayi ŋuli ŋunhiyi waŋupini gaŋgathinyanydja giṯthunanydja, bala walala ŋuli yolŋu'‐yulŋunydja dhunupana yana dhoṯkunhana buṉbunydja ŋunhiyi ḏalwaḏalwany'tja, bala marrtjinyana malthuna ŋurikiyi waŋupini'wuna. Ga ŋunhi ŋayi ŋuli ŋunhi waŋupini gulyunna ḏaḏawyunna, ga ŋunhilinydja walala ŋuli yolŋu'‐yulŋuyunydja wäŋana djäma. ");
INSERT INTO gnn_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","21","Bitjanna liŋgu walala ŋuli yolŋu'‐yulŋunydja dhärukku malthunna yana Garraywunydja. Wiripunydja ŋuli waŋupini ŋunhiyi dhärranha yukurranha mukthuna ŋunhili waŋganyŋura dharapulŋura weyinŋumirrina yana, ga wiripunydja ŋayi ŋuli waŋupini dhärranha ḻurrkun' walu, bala walala ŋuli yolŋu'‐yulŋunydja gulyunana yana nhinanhana ŋunhili liŋgu wäŋaŋura, yana liŋgu ga gaŋgathinya ŋuli ŋayi ŋunhiyi waŋupini giṯthuna, bala walala ŋuli giṯthuna marrtjinyana, malthuna ŋuli ŋurikiyi waŋupini'wana. ");
INSERT INTO gnn_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Bitjanna liŋgu ŋunhiyi Garraywu Dhawu'‐nherraṉminyarawuynydja Bathi ŋurruŋu ŋuli marrtjinya yana yukurranha, yana liŋgu‐u‐u ga ŋayathanha walala ŋuli ŋunhiyi wäŋa nhinanharawu. ");
INSERT INTO gnn_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Ga bitjanna liŋgu walu ŋupana ŋuli waŋupini'yunydja ŋuriŋiyi ŋunhi yolŋu'‐yulŋunhanydja ŋäkirrmaranha yukurranha. ");
INSERT INTO gnn_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Ga bitjanna liŋgu ŋunhi ŋuli ḏalkarra'mirriyu ŋuriŋi yolŋu'‐yulŋuyu märranha ŋunhiyi Dhawu'‐nherraṉminyarawuynydja Bathi, girri'‐ŋamathinya marrtjinyarawuna, ŋayi ŋuli yatjuna waŋanha Mawtjitjtja bitjana, “Garray gaŋgathiyana, ŋuparrana ŋunhanydja barrkuwatjkuŋana nhuŋuway miriŋunhanydja. Biyakana walalanha ŋunhinydja yolŋu'‐yulŋunha beyaṉu‐wukuŋana, walala yurru waṉḏirrina bena‐wala barrkulilina yana, ŋunhi walala ŋuli ŋuyulkthirri nhuŋu.” Bitjana ŋayi ŋuli ŋunhi Mawtjitj waŋanha, bala walala ŋuli marrtjinyana yana‐wala giṯthunana. ");
INSERT INTO gnn_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Ga ŋunhi walala ŋuli bunanha wanhami wäŋaŋura, walala ŋuli ḏalkarra'mirriyunydja walalay gurrunhana ŋunhiyi Bathinydja, bala ŋayi ŋuli Mawtjitjtja waŋanha bitjana, “Garray, go marrtjiyana lili. Ŋäkirrmaraŋa dhuwala yolŋu'‐yulŋunhanydja, ga gunganhamirriyaŋa walalanha nhuŋuwaynydja yolŋu'‐yulŋunha Yitjuralpuyŋunhanydja, birrka'mirrinha yana gurruṯu'nha ga gurruṯu'nha.” ");
INSERT INTO gnn_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Ga bitjana liŋgu walala ŋuli yolŋu'‐yulŋunydja yukurranha morrumurru'na dhikana, bala ŋayi Garrayyunydja ŋäkulana walalanha, bala ŋaramurryinana, bala dhunupana ŋayi yänguŋalanydja gurthana djiwarr'ŋuruna, bala nhäranana ŋunhi wäŋanydja. ");
INSERT INTO gnn_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Bala walala ŋunhi yolŋu'‐yulŋunydja gawaw'yurruna waŋana yatjurruna Mawtjitjkalana bitjarra, “Guŋga'yurra ŋanapurrunha, guŋga'yurra,” bitjarrana. Bala ŋayi Mawtjitjthu dhunupa yana bukumirriyaŋalana Garraywala, bala ŋayi gurthanydja rirriwulyinana. ");
INSERT INTO gnn_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Bala ŋayi Mawtjitjthu yäku‐nherrara wäŋanydja ŋunhiyi Nhäranharana. ");
INSERT INTO gnn_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Ga biyapul ŋunhi yolŋu'‐yulŋunydja morrumurru' marrtjina waŋanhamina bala‐lili'yunmina bitjarra ŋuyulkthinana manapara, liŋgu walala yukurrana djälthina gatjpu'yurrunanydja yana wäyingu warray ḻukanharawu. “Way, wäyingu muka ŋanapurrunydja djäl dhuwala ḻukanharawu. ");
INSERT INTO gnn_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Liŋgu ŋunhalanydja ŋunhi Yetjiptja wäŋaŋura ŋanapurru yukurrana guḻku' warray ḻukana guya dhika nhä, rrupiyamiriw warray, nhämiriw warray. Ga bitjanayi liŋgu ŋanapurru ŋuli ḻukanha dhapirrkmirri warray borumdja muḻkurr, birrka'mirri warray. ");
INSERT INTO gnn_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Bala dhuwalana gay' ŋanapurru yulŋunydja yalŋgi'mirrina. Nhäna ŋanapurru yurru dhika ḻukanydja? Märr‐yawaryunna ŋanapurru marrtji dhuwala dhiyaŋinydjayi manayunydja ŋathayu. Nhäku warray ŋilimurru yurru yukurra bitjandja liŋgu ḻuka dhuwalayinydja?” Bitjarrayi walala ŋunhi morrumurruny'tja yukurrana. ");
INSERT INTO gnn_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","9","Yo, bitjana liŋgu munhakunydja ŋuli ŋunhi wäŋanydja warrpam'nha monygunha ŋuriŋi ŋathayu malaŋuyu, ŋunhi ŋayi ŋuli wakuluŋgul'mirriyinya wäŋa, ga balanyarana ŋunhi yulŋunydja bitjan maŋutji ŋatha gaywaraŋu', yumurrku'. Ga goḏarr'mirrinydja djaḏaw'yuna ŋuli, bala walala ŋuli yolŋu'‐yulŋuyu djoṉgunhana marrtjinya, bala bitjanana ŋuli djäma yarrwa'yunana dämbakunhana, ga dhäkaynydja ŋunhiyi ŋatha bitjan dämbana weyika'mirrina. ");
INSERT INTO gnn_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Ga ŋunhiliyi dhurrwaraŋura malaŋuŋura buṉbuŋura yolŋu walala marrtjinya ŋuli dhärranha, waŋanha marrtjinya ŋuli morrumurru' ŋurikiyyi ŋathawuy. Ga ŋayinydja ŋunhi Mawtjitjthunydja ŋäkula walalanha, bala ŋayi galŋa‐yätjthinana, liŋgu ŋayi Garraynydja ŋunhi bitjarra yana liŋgu ŋaramurryina ŋurikiyi yolŋu'‐yulŋuwu. ");
INSERT INTO gnn_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Bala ŋayi Mawtjitjtja waŋana Garraywala bitjarrana, “Nhäku warray nhe yukurra djäma yätjkumanydja ŋarranha? Yaka nhe dhuwala ḏukṯuktja ŋarraku? Mak ŋarra bäy ŋayaŋu‐yätjkuŋala wiripunydja nhuna. Nhäkuna ŋarra yurru gäma dhuwalayi yolŋu'‐yulŋunhanydja bitjan liŋgu? ");
INSERT INTO gnn_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Yaka ŋarra walalanha djäma, ga yaka walala ŋarraku yumurrku'. Nhäku warray nhe djarr'yurruna dhiyakuyinydja? . . . ŋunhi ŋarra yurru walalanha gäma yukurra dhangi'yun, bitjandja bitjan ŋuli miyalkthu wekama nhanŋuway yothu'nha ŋaminiyu? ");
INSERT INTO gnn_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Bitjanna liŋguna walala yukurra dhuwala morrumurruny'tja djälthirri wäyingunydja. Wanhaŋuruna dhika ŋarranydja yurru maḻŋ'marama wäyin maranhu‐wekanharawu dhiyakuyi yolŋu'‐yulŋuwunydja? ");
INSERT INTO gnn_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Ŋonuŋnha dhuwala yulŋunydja, yakana ŋarra yurru gäma dhuwala yolŋu'‐yulŋunha gänanydja ŋarrapinydja. ");
INSERT INTO gnn_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Garray, wuyurra ŋarraku. Go buŋana ŋarranha; yakana ŋarra djäl ŋarra yurru nhina galŋa‐yätjthirri biyapulnydja.” ");
INSERT INTO gnn_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Bala ŋayi Garray waŋana Mawtjitjkala bitjarrana, “Ḻiw'maraŋa waŋiya marrtjiya yolŋu'‐yulŋunha 70‐nha ŋurru'‐ŋurruŋunha, ŋunhinha walalanha yolŋu'‐yulŋunha ḏarramuwurrunha ŋunhi nhe yukurra märr‐yuwalkthirri walalanha. Gäŋanydja walalanha lili dhipala Buṉbulili Withiyanminyarawuylili, bala walala yurru dhärranydja yukurra dhiyalana gay' ŋarrakalana gumurrŋura. ");
INSERT INTO gnn_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Ŋarranydja yurru yarrupthunna lili, ga nhinana ŋarra yurru nhumalaŋgala. Ŋarra yurru märrama ŋunhinydja walŋa ŋunhi ŋarra nherrara nhokala ŋäthili, bala ŋarra yurru nherra'‐nhirraṉ ŋurikalana walalaŋgala ŋurru'‐ŋurruŋuwalana, märr yurru walala gurrukamana yukurra, rrambaŋina nhumana; yakana nhe yurru yukurra nhepinydja gäma. ");
INSERT INTO gnn_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Gatjuy ḻakaraŋanydja walalambala yolŋu'‐yulŋuwanydja biyakana, ‘Ḏarrtjalkkunhamiya nhumalanhay nhuma yulŋunydja, liŋgu goḏarrny'tja boŋguŋunydja nhuma ḻuki yukirri wäyinnha. Liŋgu ŋayi Garrayyunydja ŋäkulana nhumalanha morrumurru'wuynydja, bala ŋayi yurru yana wekamana nhumalaŋgu Garrayyu wäyindja ḻukanharawunydja. ");
INSERT INTO gnn_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","20","Ḻukanydja nhuma yurru yukurra ŋunhiyi wäyindja waŋgany ŋaḻindi ŋupan, yana liŋgu ga märr‐yawaryun nhuma yurru djawaryun ŋuriŋi ḻukanharayu. Bala nhuma yurru rirrikthunmirrina ŋuriŋiyi wäyindhunydja, liŋgu ŋapa‐wekaŋala nhuma dhuwala Garraywu. Nhäku warray nhuma yurru roŋiyirri balayi be Yetjiplilinydja?’” Ga bitjarra ŋayi ŋunhi Garray waŋananydja. ");
INSERT INTO gnn_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Ga ŋayi Mawtjitjtja buku‐ḏuwaṯthurruna waŋana bitjarra, “Garray, mirithirrina dhuwala guḻku'na miṯtjinydja, ŋula nhämunha'na yolŋunydja walala dhaŋaŋnha. Wanhaŋuruna dhika ŋarra yurru märrama wäyindja maranhu‐wekanharawunydja walalaŋgu? ");
INSERT INTO gnn_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Ŋunhi ŋarra yurru wutthun bulikiny'tja bukmakkuma, ŋunhiyinydja yaka yana gana' walalaŋgu, ga ŋuli ŋarra yurru märrama guya ŋulaŋuru gapuŋuru moṉukŋuru, ŋunhiyinydja yaka yana gana'.” ");
INSERT INTO gnn_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Ga ŋayi Garraynydja waŋana nhanukala Mawtjitjkala bitjarra, “Nhä dhika ŋarranydja? . . . ganydjarrmiriw? . . . yalŋgi? Nhä dhika ŋarraku dhäruktja? . . . yuwalk? . . . bay' nhä? Galkina nhe yurru nhämana, walala yurru yukurra ḻukana ŋunhiyi wäyindja.” ");
INSERT INTO gnn_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Bala ŋayi Mawtjitjtja gawaw'yurrunana ḻuŋ'maraŋalana ŋunhiyi 70‐nydja ŋaḻapaḻmirrinha, bala walala ḻuŋ'thurrunana marrtjina ŋunhiwalayina Garraywalana buṉbulili. ");
INSERT INTO gnn_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Bala ŋayi Garraynydja marrtjinana yukurrana dhunarranana waŋupini'kurruna, bala waŋanana yukurrana Mawtjitjkalanydja. Bala ŋayi djaw'yurrunana märraŋalana ŋunhiyi walŋanydja ŋunhi ŋayi Garrayyu nherrara ŋäthili nhanukala Mawtjitjkala, bala nherra'‐nhirrara ŋurikalayina walalaŋgala waŋga'‐waŋganygalana ḏarramuwurruŋgala, ga dhunupana yana ŋunhiyinydja walala waŋanana marrtjina djawarrkthurrunana. ");
INSERT INTO gnn_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Ga märrmany'tja ŋunhiyi yolŋu maṉḏa ŋurruŋu maṉḏa nhinana yukurrana ŋunhili bäyma maṉḏakalay maṉḏa buṉbuŋura, yaka maṉḏa marrtjina balayi ŋunhimala buṉbulili, yurru nhanŋunydja Godkunydja walŋa bitjarra yana liŋgu marrtjina maṉḏakala, bala nhinanana, ga maṉḏanydja bitjarra yana liŋgu djawarrkthurruna marrtjina waŋana Godku dhäruk, goramiriwnha maṉḏa yana. ");
INSERT INTO gnn_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Ga ŋayi waŋgany ḏarramu yuṯa waṉḏina, bala ḻakaraŋala Mawtjitjkala bitjarra, “Way, ŋunha wäŋaŋura märrma' yolŋu maṉḏa waŋa marrtji djawarrkthun.” ");
INSERT INTO gnn_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Ga ŋayi Djatjuwanydja waŋana Mawtjitjkala bitjarra, “Way, ḏaḏawmaraŋana maṉḏanha.” ");
INSERT INTO gnn_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Ga ŋayi Mawtjitjtja buku‐wakmaraŋala nhanŋu, “Nhäku warray?” bitjarra. “Mak nhe maṉḏanha guyaŋina yanapi maṉḏa wapthurruna ŋunha ŋarrakala dharapulŋura? Ŋarranydja ḏukṯuk ŋayi yurru Garrayyu nherra'‐nhirraṉ nhanŋuwaynydja ŋayi walŋa bukmakkala yana yolŋuwala walalaŋgala, märr yurru walala bukmak yana yukurra waŋanydja Godkala ŋuriŋi dhärukthu ganydjarrmirriyunydja.” Bala walala Mawtjitj ga wiripu‐guḻku' ŋunhi ŋurru'‐ŋurruŋu wäŋgaŋala balayina. ");
INSERT INTO gnn_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Ga ŋuliŋurunydja dhurrwaraŋuru ŋayi Garrayyu watana djuy'yurruna, bala ŋayi ŋuriŋi watayunydja bo'yurruna gäŋala biyapulnha dhaŋaŋnha bäymana wäyin djirikitjtja. Marrtjinanydja walala ŋunhi, bala nhinanana marrtjina, warrpam'nha gungaŋalana ŋunhiyi wäŋanydja, ga bukmak ḻiw'maraŋala wäŋa ŋunhi dhaŋaŋdhina ŋuriŋi wäyindhuna. ");
INSERT INTO gnn_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Ga ŋuriŋi yolŋu'‐yulŋuyu yukurrana djämanydja walu‐ŋupara ga munha‐ŋupara, wapmaraŋala yukurrana ŋunhiyi wäyindja malanha, bala ḻithanmaraŋala marrtjina ŋunhi wäyindja walulilina. ");
INSERT INTO gnn_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Ga ḻukananydja walala marrtjina bitjarrana liŋgu walu‐ŋupara‐a‐a, guḻku'na mirithinana ŋanak, yurru mukthurrunana walala yukurrana morrumurru' yulŋunydja Garraynha. Bala ŋayi Garraynydja ŋaramurryinana walalaŋgu biyapul, ga guḻku'na yolŋu walala marrtjina murrmurryurruna rerriyunydja. ");
INSERT INTO gnn_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Yo, ŋunhiliyi walala yukurrana dhalkaraŋalanydja guḻku'nhana mirithirrina yolŋu'‐yulŋunhanydja ŋunhi walala yukurrana ḏukṯuk‐ḏumurruyina ḻukanharawu wäyingu ŋurikiyi. Bala walala giṯthurrunana ŋuliŋuruyinydjayi wäŋaŋuru, bala nhinana yukurrana wiripuŋurana wäŋaŋura. ");
INSERT INTO gnn_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Waŋganymirrinydja waluyu maṉḏa nhina gupa‐waŋa Mawtjitjnha, nhanukalaynha wal'ŋu yapa'mirriŋuyu Miriyamdhu ga wäwa'mirriŋuyu Yärundhu, maṉḏa nhina waŋa ŋarrtjun ŋanya Mawtjitjnha, liŋgu maṉḏa yaka ḏukṯuk miyalkku ŋuriki nhanukalaŋuwu, ŋunhi ŋayi Mawtjitjthu märraŋala mulkurunha miyalknha, wiripuŋuwuynha wäŋawuynha. ");
INSERT INTO gnn_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Bitjanna maṉḏa nhina waŋanharamirrinydja gam'. “Nhä ŋayi dhuwala Mawtjitjtja? . . . yindina buŋgawa? . . . ŋayipi waŋgany marŋgi dhärukku Garraywunydja? Ŋitjalaŋgala muka wiripunydja ŋayi ŋuli Garray waŋi.” ");
INSERT INTO gnn_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Mawtjitjthunydja ŋäkula warray maṉḏanha, yurru yakana ŋula ŋayi waŋana buku‐ruŋiyinmaraŋalanydja, liŋgu buku‐ruŋinyamiriwnha ŋayinydja ŋunhi yolŋu Mawtjitjtja, biyapulnha wal'ŋu gurrum'thunaramirri. ");
INSERT INTO gnn_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","5","Bala ŋayinydja marrtjinana Garraynydja ŋurikalayi walalaŋgala ḻurrkun'kala, bala waŋana bitjarrana, “Gatjuy, nhuma yurru wäŋgaŋa walala djunuma ya', ŋunhamala Withiyanminyarawuylili Buṉbulili,” bitjarra. Bala yana walalanydja wäŋgaŋalana, ga ŋunhalana ŋayi Garray bunana walalaŋgu maŋanmirrinydja; ŋayi yukurrana djingaryurrunanydja galki dhurrwaraŋura Buṉbuŋura, bala ŋayi waŋana wäthurruna maṉḏaku bitjarrana, “Miriyam ga Yärun, go lili marrtjiya maṉḏa ŋarrakala.” Bala maṉḏanydja marrtjina withiyarana Garraynhana. ");
INSERT INTO gnn_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Ga ŋayinydja Garraynydja waŋanana maṉḏanha bitjarrana, “Ŋäka maṉḏa ŋi! Ŋunhi ŋarra ŋuli wiripuŋuwalanydja yolŋuwala waŋi marrtji, ga maḻŋ'maranhamirri ŋarra ŋuli bukaway'kurru, ga mel‐yurthi ŋayi ŋuli ŋarranha yana. ");
INSERT INTO gnn_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","8","Yurru Mawtjitjtja wiriputhirri warray yukurra, ganaŋ'thun warray, liŋgu bukmak nhä malanha ŋarrakuway nhanukalana ŋorra yukurra goŋŋura; nhanukalanydja ŋarra ŋuli Mawtjitjkalanydja waŋa dhunupa warray wal'ŋu, ga liŋguna ŋayi rumbal ŋarranha nhäŋalana. Nhumanydja bini ŋunhi barrarinyana bitjanarawu ŋarrtjunarawu nhanŋu, liŋgu ŋayinydja ŋunhi ŋarralaynha wal'ŋu yolŋu.” ");
INSERT INTO gnn_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Yo, Garraynydja ŋunhi wirrkina ŋaramurrthina maṉḏaku, bala ŋayi gonha'yurrunana. ");
INSERT INTO gnn_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Ga ŋunhi ŋayi maŋandja bena‐wala winya'yurrunana, bala biyapulnydja walala nhäŋala Miriyamnhanydja rirrikthunarana, rumbalnydja marrtjina gaywaraŋu'thinana be nhäyuna rerriyu, burrpuy'mirriyinana marrtjina. ");
INSERT INTO gnn_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","12","Nhäŋalanydja maṉḏa ŋanya, djunuma waŋanana ŋayi Yärundja Mawtjitjkalana, “Buku‐djulŋi, yaka ŋinyalanha dhä‐ḏir'yurra. Ŋilinyuway yana yätjthinanydja; yätj mirithirri ŋilinyu bitjarrayinydja djäma. Ma' buku‐djulŋi, baḏarraŋ'kuŋana ŋanya.” ");
INSERT INTO gnn_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Bala dhunupa Mawtjitjtja wäthurruna Garraywuna, “Garray gay', baḏarraŋ'kuŋa ŋanya go,” bitjarra. ");
INSERT INTO gnn_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Yurru ŋayi Garraynydja waŋana Mawtjitjkala bitjarra. “Yätj dhuwali ŋayi djäma; yarrkthun ŋayi yurru dhiyaŋunydja‐wala dhipuŋuru nhumalaŋgalanydja, ŋunhamala dhawaṯthun ŋayi yurru warraŋullili wäŋalili, ga ŋunhala bili ŋayi yurru nhina yukurra gäna, yana liŋgu ga waŋgany rulu ga märrma' bäythinyara walu boŋguŋu djuḻkthunmaraŋu, yurruna ŋayi boŋguŋu roŋiyinydja lili baḏarraŋ'nha.” ");
INSERT INTO gnn_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Djuy'‐way Miriyamnhanydja dhawaṯmaraŋalana ŋuliŋurunydja wäŋaŋuru, ga walalanydja ŋunhi Yitjuralpuyŋunydja yolŋu'‐yulŋu yukurrana mukthurruna yana nhinana, galkurruna yukurrana nhanŋu Miriyamgu; yakana walala giṯthurruna ŋuliŋuru wäŋaŋurunydja, yana liŋgu ga roŋiyina ŋayi Miriyam liŋguna baḏarraŋ'nha. ");
INSERT INTO gnn_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Bala ŋuliŋurunydja dhurrwaraŋuru walala giṯthurrunana, marrtjinana‐wala yukurrana ga‐ga‐ga‐ga‐a‐a, ga ŋunhaŋga yana ŋanhdharkka wäŋa ŋupara, ga nhäyika wäŋaŋura ŋunhala Barrandja dhut‐gay' nhinanana walala, wäŋaraŋala ŋunhilinydja, galkina yana ŋurikina wäŋawu ŋunhi Garrayyu dhawu'mirriyaŋala walalaŋgu. ");
INSERT INTO gnn_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Ga ŋunhalayina wäŋaŋura ŋayi Garray waŋananydja Mawtjitjkala bitjarrana, ");
INSERT INTO gnn_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Ma', nhenydja djarr'yurrana mel'ŋunha walalanha waŋga'‐waŋganynha yana ŋurruŋumirrinha dhipuŋuruyi bäpurru'ŋuru ga bäpurru'ŋuru; walala yurru marrtji wäŋgama bala ŋunhamalayi wäŋalili, milthun marrtji nhäma yurru, ga maḻŋ'marama nhäyinyara ŋunhiyi wäŋa ŋunhi ŋarra yurru wekama nhumalaŋgu.” ");
INSERT INTO gnn_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","16","Bala yana Mawtjitjthunydja djarr'yurrunana Djatjuwanha ga wiripuŋunha yäkunha Gaylipnha, ga biyapul märrma'‐rulunha ḏarramuwurrunha, ŋurruŋumirrinha wal'ŋu yana. ");
INSERT INTO gnn_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Djuy'‐way ŋayi walalanha bitjarrana, “Gatjuy marrtjiyana‐wala walala, ga gärriya ŋunhimala wäŋalili Gaynanlilinydja. Marrtjiyanydja walala ŋuliyi wäŋakurrunydja, ŋal'‐ŋalyurra yana ŋunhi buku'‐wukukurrunydja. ");
INSERT INTO gnn_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Nhäŋa marrtjiya maḻŋ'maraŋa nhäyinyara ŋunhiyi wäŋa, ga nhäyinyara yolŋu walala yukurra nhina ŋunhilimiyi . . . ḻurrkun' mak yalŋgi'mirri? . . . mak guḻku' wuṉḏaŋarrmirrinydja. ");
INSERT INTO gnn_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Mak nhäŋura walala yukurra nhinanydja? . . . buṉbuŋura yumurrku'ŋura ḏalwaḏalwa'ŋura? . . . mak wuṉḏaŋarrŋurana wäŋaŋura ḻoḻumirriŋurana? ");
INSERT INTO gnn_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Ga maḻŋ'maraŋa ŋunhi dhawal mak ŋatha mäypamirri, mak ŋathamiriw ga dharpamiriw ŋula nhämiriw. Gatjuy ḻaw'yurrana walala, ga lilinydja boŋguŋu nhuma roŋiyi dhäwu'na gäŋu ŋanapurruŋgu. Yakana beyaṉiyiyanydja walala, yana marrtjiyana‐wala ŋoy‐wuṉḏaŋarrthiyana. Gulkthurru boŋguŋu borumdja ŋi' walala, ga gäŋuna lili ŋilimurruŋguway, liŋgu dhuwala borummirrina wäŋanydja.” ");
INSERT INTO gnn_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","22","Martj‐gay walala marrtjinana, dhunupa yana gärrinana ŋunhimalayi wäŋalilinydja. Marrtjinanydja walala yukurrana ŋunhi wäŋakurrunydja, ḻiw'maraŋala yana, nhäŋalanydja marrtjina milthurrunanydja gayul yana bala. Walala maḻŋ'maraŋalanydja marrtjina ḻatju' warray dhika wäŋanydja ŋunhi, ŋatha mäypamirri warray, yurru wäŋaŋuranydja ŋunhiliyi ḏälmirri warray yolŋunydja walala yukurrana nhinana, bathalamirri warray, djaka' weyin'kurru warray. ");
INSERT INTO gnn_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","24","Gulkthurrunanydja walala borumnha dhirrimuknha goŋdja yarra'‐yarraṯana dhikana, ḻingarryinyarana borumdja ŋunhi, bala gäŋalanydja ḻambarryuna djunumanydja, ga bitjarrayi bili wiripuŋunhanydja borumnha gulkthurrunayi walala, ḻatju'mirri dhika yana dhäkay. ");
INSERT INTO gnn_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Ḻaw'‐ḻawmaraŋalanydja, bala roŋiyinana martj‐martjurruna gäŋala walalaŋguna. Wäŋgaŋalana walala bala‐a‐a, roŋi'‐ruŋiyinana, burway ḏo'yurruna, ");
INSERT INTO gnn_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","yurru walalanydja Mawtjitjtja ga Yärundja ga wiripuwurru yolŋu'‐yulŋu ŋunhi goŋmirriyinana gay walalanha nhäŋalanydja roŋiyinyaranydja. ");
INSERT INTO gnn_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Walalanydja ŋuriŋiyi mel'ŋumirriyunydja yuy'thurruna ḻakaraŋalana ŋurukuynha wäŋawuy bitjarra, “Liŋguna ŋanapurru nhämanydja yawungu ŋunhayi wäŋanydja, yurru ḻatju' warray ŋanya wäŋanydja ŋunha, ŋathanydja dhika guḻku'na, ḻatju'mirrina ŋatha ḻukanharawu. Dhuwalana borumdja ya' ŋurukuy. ");
INSERT INTO gnn_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Yurru yolŋu'‐yulŋunydja ŋunha yukurra nhina ganydjarr‐ḏilkurruna, bena‐wala djaka' weyingurruna, guḻku'na mirithirrina miṯtjinydja; nhinanydja marrtji walala ŋunha wäŋaŋuranydja wuṉḏaŋarrmirriŋurana, yindiŋurana ḻoḻuŋura. ");
INSERT INTO gnn_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Wiripunydja yawungu ŋanapurru yolŋu'‐yulŋunha nhäma ŋunhiyi maḏakarritjmirrinhana, ŋunhayi Yamaliknha bäpurru'nhanydja, ga wiripuna wiripuna bäpurru yukurra nhina maḏakarritjmirrina bäymana yolŋunydja walala. Walala marrtji nhinanydja ŋunha buku'‐wukukurru ga ŋoykurru, ga raŋikurru wäŋakurrunydja, ga galki mayaŋ'kurru, ga warrpam'nha gungaŋala wäŋanydja ŋunha.” ");
INSERT INTO gnn_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Bala walala ŋuriŋiyi Yitjuralyu malayu ŋäkulanydja ŋunhi walalaŋguŋu dhäwuny'tja, yurru walala yatjunminana gay', barrarinana wirrkina, bala ŋayi Gaylipthunydja waŋana mukmaraŋala walalanha, “Mukthurra walala,” bitjarra. “Gul' ŋilimurrunydja marrtjina‐wala yana go. Ŋilimurru yurru ŋupanna walalanha yana, bumana marrtji, ga yana liŋgu ga dhawar'marama wal'ŋu, liŋgu ŋilimurrunydja dhuwala wuṉḏaŋarrmirri warray, yaka warray yalŋgi'mirri.” ");
INSERT INTO gnn_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Yurru wiripuwurrunydja ŋunhi mel'ŋumirri waŋana bitjarra, “Yä‐ä‐äw, yakana ŋilimurru ŋuli buŋu dhawar'maraŋu ŋunha walalanha, liŋgu wuṉḏaŋarrmirrina ŋunha walalanydja, ga ŋilimurrunydja dhuwala yalŋgi'mirrina, muṉguynha wal'ŋu.” ");
INSERT INTO gnn_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Ŋe, bitjarrayi walala ḻakaraŋalanydja ŋuriŋiyi mel'ŋumirriyunydja walalay, wiripuyaŋala warray, borrk‐beyaṉu‐wukuŋalana bitjarra, “Yätjnha ŋunha wäŋanydja bay', maḏakarritjmirrina yana ga bäyŋuna ŋathanydja. ");
INSERT INTO gnn_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Ŋutu'mirrina nhina yukurra yolŋunydja, djaka' ḏilkurruna, djuḻkthunmaramana yukurra ŋilimurrunhanydja. Ŋanapurrunydja ŋunhi ŋunhala balanyarana bitjan ŋula nhäna muṉguynha waŋga'‐waŋgaŋala walalaŋgala maŋutjiŋuranydja, biyaku ŋuli ḏetjnha.” ");
INSERT INTO gnn_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Bala walalanydja ŋunhi yolŋunydja walala yatjunmirri warray, bena dhika nyä'yunmirri, nyä'yunmirrina‐a‐a yana liŋgu‐u‐u munha‐ŋuparana, ");
INSERT INTO gnn_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","gupa‐waŋanana marrtjina morrumurru'na maṉḏanhana Mawtjitjnhana ga Yärunnhana, bukmakthuna ŋuriŋina bili yolŋuyu walalay. Bitjarrana walala marrtjina ŋunhi yulŋunydja, “Ye‐e‐e, wanhaka ŋanapurru bini ŋunhala muka bäyma Yetjip wäŋaŋura murrmurryunanydja. Ga ŋunhala muka ŋanapurru bini ŋunhi ŋanhdharkŋura murrmurryunna. ");
INSERT INTO gnn_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Nhäkuŋga ŋayi Garrayyu gäŋala ŋilimurrunha dhipalanydja dhuwala? . . . baymatthunarawuna? . . . ŋilimurru yurru mandjawakthuna bakthun dhuwala? . . . dhäykawurru manapan ga yumurrku' ŋilimurrumbala? Gul' ŋilimurru marrtjina, Yetjiplilina roŋiyirri go.” ");
INSERT INTO gnn_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","“Yo‐o‐o, manymaknha dhuwalinydja. Ŋilimurru marrtjina,” bitjarra walala yolŋu'‐yulŋunydja. “Go ŋilimurru djarr'yunna ŋurruŋunhana ŋilimurruŋguway, ŋayina yurru ŋilimurrunha gäma balanydja roŋiyinyamarama Yetjiplilinydja.” ");
INSERT INTO gnn_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Bala maṉḏanydja Mawtjitjtja ga Yärundja wirrkina gorana, bala ŋurrkanhamina munatha'lilina, milma ŋurikala miṯtjiwala. ");
INSERT INTO gnn_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Ga maṉḏanydja märrmany'tja ŋunhi mel'ŋu maṉḏa Djatjuwanydja ga Gayliptja ŋayaŋu‐yätjthinana wirrkina maṉḏa, ");
INSERT INTO gnn_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","bala waŋana yolŋu'‐yulŋunhana bitjarrana, “Ŋunhanydja ŋunhi wäŋa ŋanapurru yawungu marrtji yukurra milthun ga nhäma marrtji ḻatju' warray dhika wäŋa. ");
INSERT INTO gnn_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Ŋuli ŋilimurru balaŋu dhäruk märraŋu ŋanyapinyay yana Garraynhanydja, ŋayinydja ŋuli gäŋuna‐wala yana ŋilimurrunha, bala yana wekaŋu wäŋanydja ŋunha ŋilimurrumbalana. ");
INSERT INTO gnn_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Yaka walala ŋula raypirri‐waḏatjthiya ga yaka'yurranydja Garraywu, ga yaka barrariya ŋurupa yolŋuwanydja walalambala ya'. Ŋilimurrunydja yurru buma walalanha burr'‐burrmarama muka, manbuḻyunmarama marrtji. Ga yolthuna yurru ŋunhi walalanhanydja guŋga'yun? . . . bäyŋuna. Liŋgu Garray warray ŋayipi ŋilimurruŋgalanydja gali'kurru, ga walalambalanydja waŋarrnha liŋgu warray djuḻkthunmaraŋala Garrayyu. Ŋoy‐wuṉḏaŋarrthiya walala yana, beyaṉumiriwyiya.” ");
INSERT INTO gnn_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Walala ŋunhi yolŋunydja walala miṯtjinydja yaka warray mäkiri'‐witjurruna maṉḏaku, mäkiri'‐yarryurrunana wirrkina, bala guṉḏa warray marrtjina galkara, walala bini wirriw'‐wirriwyunna maṉḏanha bunhana marrtjinya rakunygunhana guṉḏayuna. Bala ŋayinydja marrtjina Garraynydja maḻŋ'thurruna warray ŋunhili yana bäyma ŋurikalayi miṯtjiwala Yitjuralpuyŋuwalanydja; walala nhäŋalana ŋunhi ḻatju'na baḏayala' dhika. ");
INSERT INTO gnn_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Bala Garraynydja waŋana Mawtjitjkala bitjarrana, “Ŋarranydja dhuwala dhotuna yukurra dhiyakalanydja walalaŋgala miṯtjiwala; bitjanna liŋguna walala yukurra ŋapa‐yarryundja, ŋoy‐yuḻkthirrinydja ŋarraku. Liŋguna walala ŋuli marrtjinya nhänhanydja ŋarraku ganydjarrnydja, ga nhä malanha ŋarrakuŋu ŋamakurru'mirri ŋunhi ŋarra ŋuli marrtjinya milkunha, yurru mukthun warray walalanydja yukurra märr‐yuḻkthun ŋarranha yana, yaka warray märr‐yuwalkthirri yuwalkkuma dhika. ");
INSERT INTO gnn_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Ŋarra yurru baymatthunna walalanha ŋula nhäyuna yana, dhawar'maramana yurru warrpam'thunna. Nhena Mawtjitj ga nhipala yumurrku'na yurru ŋarrakuwaynydja wal'ŋu mala; mala‐guḻku'mirriyirrina nhe yurru yulŋunydja, biyapulnha wal'ŋu yurru mala nhuŋunydja gaŋdhunna, djuḻkmaramana yurru dhuwalanhanydja walalanha.” ");
INSERT INTO gnn_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Bala ŋayi Mawtjitjtja waŋana bitjarrana, “Yaka nhe biyakayi Garray. Nhepi muka dhawaṯmaraŋalanydja gäŋala walalanha ŋulaŋuru Yetjipŋurunydja, ga ŋuli nhe yurru buwayakkumanydja walalanha Yitjuralpuyŋunhanydja, ga walalanydja yurru ŋunhalanydja ŋämana Yetjippuyŋuyunydja ŋiniya? ");
INSERT INTO gnn_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Ga ŋuruŋu Gaynanbuyŋuyu ŋäkulayi nhuna, ŋunhi nhe yukurrana gäŋala Yitjuralpuyŋunha ŋula lili ŋanhdharkkurru; ŋurrwu'maranha walalanha nhe ŋuli maŋandhu, warraw'kunha waluŋurunydja, ga munhakunydja gurthayinyana ŋuli ŋunhiyi maŋan. ");
INSERT INTO gnn_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Yo, ŋuli nhe yurru bumanydja walalanha, walalanydja yurru wiripu‐guḻkuny'tja bäpurru ḻakaranhamirrina nhuna, wakalkumana yurru nhuna bitjanmirrina, ");
INSERT INTO gnn_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘Yuwalk muka ŋayi ŋunhi yalŋgi walalaŋgu waŋarrnydja ŋi'. Be muka ŋayi dhawu'‐nherraranydja walalanha, ŋayi yurru gäma walalanha, bala nherraṉna ŋunhimalayina wäŋalili be. Mak ŋayi walalanha ŋunha bumaranydja ŋunhalana ŋanhdharkŋurana, liŋgu ganydjarrmiriwnha ŋayi yulŋunydja, yakana nhanŋu ganydjarr walalaŋgu gulŋiyinyamaranharawunydja.’ Biyakuna walalanydja ŋuli waŋi nhuna, yana bini nhe be waŋarr yalŋgi'. ");
INSERT INTO gnn_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Garray, nhenydja ganydjarr‐ḏumurru warray wal'ŋu, wuṉḏaŋarr warray dhika, yaka warray yalŋgi; ganydjarr dhuwali nhe yukurra ḏälkuma gänharawu walalaŋgu ga ŋilitjanarawuna yana. Ma' milkuŋana walalaŋgala biyakana nhuŋuway ganydjarrnha. ");
INSERT INTO gnn_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","“Garray, nhenydja ŋunhi ḻakaranhamina nhunapinyay nhe ŋunhi nhe yurru yaka waḏutja ŋaramurrthirri, ga dhawu'‐nherraranydja nhe ŋunhi märr‐ŋamathinyaranydja biyapul wal'ŋu bathala nhokalaŋuwu yolŋu'‐yulŋuwunydja. Nhe waŋana ŋunhi, nhe yurru yanana baḏuwaḏuyun walalaŋgu ŋunhi yätjpuynydja djämawuy, ŋunhi walala yurru bilyun roŋiyirri nhokala. Yurru dhä‐ḏir'yunna nhe yurru walalanha yulŋunydja, ŋunhi walala yurru dhuwurr‐yätjthirrinydja, yaka nhe yurru waŋa bitjan ‘bäyyi’, bitjan yurru ŋuriki walalaŋgalaŋuwu yätjku. ");
INSERT INTO gnn_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Garray buku‐djulŋi, yaka walalaŋgala ŋoy‐djingaryurranydja, yana bäy‐ḻakaraŋana walalaŋgu ŋurikiyi yätjpuy, biyakana yana liŋgu bitjarra nhe ŋulaŋuru Yetjipŋuru bäy‐ḻakaraŋala yana marrtjina lili, ga dhipala wapthurruna, liŋgu nhenydja dhuwala märr‐ŋamathinyaramirri Waŋarr, djambimiriw yana. Garray buku‐djulŋi, yaka walalanha murr'maraŋa.” Bitjarrayi ŋayi Mawtjitj bukumirriyaŋala Yitjuralpuyŋuwunydja. ");
INSERT INTO gnn_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Bala Garraynydja waŋana buku‐ruŋinyamaraŋalanydja bitjarrana Mawtjitjku, “Ŋarra yurru walalaŋgu bäy‐ḻakarama, dhiyaŋu yana liŋgu ŋunhi nhe ŋarranha ŋäŋ'thurruna. ");
INSERT INTO gnn_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Yuwalk yana ŋarra dhuwala walŋa wal'ŋu yulŋunydja waŋarrnydja, ga yuwalk yana yurru ŋarrakala ḻatju'yunydja dhika djarraṯawun'thunydja monyguma ḻiw'marama yana dhuwala wäŋanydja, warrpam'thun ḻiw'marama. ");
INSERT INTO gnn_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","23","Ga bitjan liŋgu yuwalk yana ŋarra yukurra ḻakaramanydja, yaka yurru ŋula waŋgany dhipuŋuru miṯtjiŋuru gulŋiyirri ŋunhawalayinydja ya' wäŋalili. Walala nhäŋala warray ŋarraku ŋunhi ḻatjuny'tja dhikanydja baḏayala', ga nhäŋala walala biyapul wal'ŋu bathala ŋunhi ŋarra djäma ganydjarryu ŋunhala Yetjip ga ŋunhala ŋanhdharkŋura wäŋaŋura. Ŋarra ŋuli gunganhamaranhanydja walalanha ŋurrwu'yunmaranha ŋula nhäŋuru, yurru bitjanana liŋgu walala ŋuli gatjarr'yuna marrtjinya ŋarranha lili yulŋunydja, yaka warray malthuna ŋarrakuwaynydja dhärukku. Yakana yurru ŋunhiyinydja walala gärri ŋunhiwala wäŋalili ŋunhi ŋarra wekaŋala nhumalaŋgalayŋuwala gäthu'mirriŋuwala ŋunhala bäyma wal'ŋu, ŋäthili baman'. ");
INSERT INTO gnn_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Ŋayipina yana waŋganynha yurru Gaylipnha gärrinydja, liŋgu ŋayipina ŋayaŋu wiriputhirrinydja yukurra wal'ŋu, ŋayina yukurra yuwalkkumanydja wal'ŋu malthun ŋarraku, bala ŋarra yurru gämanydja ŋanya Gaylipnha, bala ŋilitjanna ŋunhamalayinydja wäŋalili; ŋayi yurru nhinanydja yukurra ŋunhala wäŋaŋura, ŋunhi ŋayi djalkiri wapthurruna ŋunhiwala wäŋalili ŋayipi.” Bitjarrayina ŋayi Garrayyu ḻakaraŋalanydja Mawtjitjpa yukurrana. ");
INSERT INTO gnn_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Bala Garray waŋana dhawar'yunarayŋunydja dhäruk bitjarrana, “Yo. Goḏarrny'tja boŋguŋu bukmak yana dhuwali Yitjuralpuyŋu miṯtji, nhuma boŋguŋu gaŋgathina, bala wäŋgaŋu roŋiyina balayi ŋunha ya' ŋanhdharkliliyi,” bitjarra. ");
INSERT INTO gnn_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","27","Bala ŋayi Garray waŋanana maṉḏakala Mawtjitjkala ga Yärungala bitjarra, “Ŋarra ŋäkula yolŋunhanydja walalanha morrumurru'wuynydja yukurranhara, ŋunhi walala yukurra morrumurru' ŋarrakala. Nhätha yurru walala dhuwala yolŋu'‐yulŋunydja ḏaḏawyun dhipuŋuruyi morrumurru'ŋurunydja? ");
INSERT INTO gnn_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Ḻakaraŋa ŋuripa yolŋu'‐yulŋuwanydja biyakana, ‘Yuwalk ŋarra yana ḻakaramanydja yukurra waŋanydja nhumalaŋgala. Yo, ŋäkula ŋarra nhumalanha yulŋunydja, ŋunhi nhuma waŋana bitjarra ḻakaranhamina, “Yuwalk ŋanapurru yalŋginy'tja. Yakana yana ŋanapurru yurru marrtjinydja balayi gulŋiyirrinydja.” Bitjarra warray nhuma ŋunhi waŋananydja, ga yuwalk yana yurru maḻŋ'thundja bitjandhiyi, bitjarra ŋunhi nhuma waŋana. ");
INSERT INTO gnn_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Bukmak yana nhuma wakinmirrinydja yurru waŋga'‐waŋgany dhuwali murrmurryunna marrtji dhiyalayi ŋanhdharkŋuranydja, ga rumbalnydja nhumalanha yurru dhalkarama dhipalina bäymana, liŋgu nhuma mukthun yana morrumurru' yukurra ŋarrakala. ");
INSERT INTO gnn_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Ŋarra ŋunhi dhawu'mirriyaŋalanydja, nhuma yurru nhina yukurra ŋayaŋu‐djulŋithirri ŋunhalayi wäŋaŋuranydja, yurru ŋunhina liŋgu maṉḏa Djatjuwana ga Gaylipnha yurru gulŋiyirri ŋunhiwalayinydja wäŋalili. ");
INSERT INTO gnn_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Nhuma waŋana yukurrana morrumurru', ŋunhi nhumalaŋgu bini djamarrkuḻi' murrmurryuna dhiyala ŋanhdharkŋura, bitjarra nhuma yukurrana waŋananydja, yurru ŋarranydja yurru gäma warray nhumalaŋgu djamarrkuḻi'nhanydja ŋunhiwalayi warray dhawu'mirriyanharawuylili warray wäŋalili; walalana yurru yukurra nhina goŋmirriyirrinydja dhikanydja ŋunhiliyinydja wäŋaŋura, ŋunhi nhuma yukurrana ŋuyulkthina ŋurikiyi wäŋawu gulŋiyinyarawu. ");
INSERT INTO gnn_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","35","Yo, nhumanydja yurru wakinmirri yolŋu walala murrmurryunna dhiyalana bäymana ŋanhdharkŋurana, liŋgu yaka nhuma märr‐yuwalkthina ŋarranha dhäruk. Marrtjinydja nhuma yurru yukurra buku‐wirwiryunna balakurruna yana bäymana ŋanhdharkkurruna weyinŋumirrina, 40‐na dhuŋgarra nhuma yurru ŋupan, yana liŋgu‐u‐u ga wakinmirri yurru yolŋu walala nhumalaŋgu murrmurryun. Bitjandhina ŋarra yurru nhumalanha dhä‐ḏir'yundja ŋurikiy nhumalaŋgalaŋuwuy yätjpuynydja, ŋunhi nhuma buku‐ḻuŋ'thurruna yukurrana waŋgany rirrakay yana morrumurruny'tja waŋana, bitjarra ŋapana wekaŋala ŋarrakunydja yana. Bala nhuma yurru murrmurryunna warrpam' yana dhiyalana gay' ŋanhdharkŋurana wäŋaŋura. Dhuwalanydja dhäruk ŋunhina ŋunhi ŋarrapina yukurra waŋa Garraynha wal'ŋu.’” Bitjarra ŋayi Garrayyu ḻakaraŋalanydja. ");
INSERT INTO gnn_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","38","Bala walalanydja ŋunhi mel'ŋumirrinydja marrtjina raku'‐rakunydhinana, liŋgu walala dhäwu' bothinyaramirri gäŋala barrari‐wukuŋala wiripuwurrunha ŋunhi, bala walala ŋunhi bukmakthuna yana yolŋu'‐yulŋuyu ŋarrtjurrunanydja yukurrana Garraynha. Yo, ŋunhiyi walala mel'ŋumirri walala murrmurryurruna ŋunhiliyinayi gumurrŋura Garraywalana, yurru maṉḏapina Djatjuwa ga Gaylipnha walŋanydja nhinana yukurrana, ŋunhina maṉḏa liŋguna märrma'na yakanydja rakunydhina mel'ŋu maṉḏa. ");
INSERT INTO gnn_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Bala ŋayi Mawtjitjthunydja ḻakaraŋala bukmakkala Yitjuralpuyŋuwala Garraynhana dhäruk bitjarrana, “Ŋayi Garraynydja waŋana yaka'yurrunana, yakana dhuwala nhuma yurru gärrinydja ŋunhamalayinydja wäŋalili. Roŋiyirrina ŋilimurru yurru marrtjinydja bitjana‐wala ŋanhdharklilina, ga nhina yukurra yurru ŋunhalayi bili, weyinŋumirrina yurru dhuŋgarra ŋupan,” bitjarra. Bala yolŋunydja walala bukmak yana nyä'yunminanydja, wirrkina dhikana nyarrŋayunminanydja. ");
INSERT INTO gnn_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Bala munhakumirrina djaḏaw'yunarayuna walala gaŋgathina, bala ḏuwa‐ḏuwaṯthurruna bukulilina, bala nhäŋala marrtjina ŋunhiyi wäŋana. “Galki warray dhuwala wäŋanydja; dhuwala warray bäyma gay. Gul' ŋilimurru marrtjina way, gärrina go, liŋgu ŋilimurruway yätjthinanydja,” bitjarra walala waŋanharaminanydja yukurrana. ");
INSERT INTO gnn_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","42","Yurru ŋayi Mawtjitjtja waŋana bitjarrana, “Yä‐ä‐äw dhuḏitjnha, liŋgu Garraynydja waŋana nhumalaŋgu yaka'yurrunana. Ŋuli nhuma marrtjinydja yurru, walala yurru miriŋuyunydja nhumalanha bumana, liŋgu Garraynydja yakana nhumalaŋgala galki, bämara'yun yurru. ");
INSERT INTO gnn_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Bumana yurru walala nhumalanha mandjawakthuna rakunygumana. Ŋayi Garraynydja nhumalaŋgu yakayi yurru marrtji malthun, liŋgu yaka nhuma malthurruna yukurrana nhanŋuway wal'ŋu Garraywu.” ");
INSERT INTO gnn_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Yurru yolŋunydja walala ŋunhi yaka mäkiri'‐witjurruna Mawtjitjkunydja, yana walala marrtjinana buku'‐wukukurruna wäŋakurru, yurru ŋayipinydja Mawtjitjtja yaka malthurruna walalaŋgu, ŋunhala bäyma nhinana yukurrana, ga bitjarrayi liŋgu ŋunhiyi Dhawu'‐nherraṉminyarawuynydja Bathi bäymayi. ");
INSERT INTO gnn_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Yo, wäŋgaŋalana walalanydja marililina nyäṉ'thurrunana, bala walalanydja ŋuriŋiyinydja yolŋuyu walalay nhäŋalana walalanha, walala marrtjina yukurrana lili. Dhunupa ḏurryurrunana, bala ŋuparana walalanha, bumarana marrtjina, weyinnha yana ŋupara‐a‐a, yana liŋgu ga ŋunha wapthurruna ŋanhdharklili wäŋalili. Walalanydja gundupuŋalana, yana liŋgu bur‐way ḏo'yurruna wäŋaŋurana. ");
INSERT INTO gnn_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","3","Waŋganymirri walala yukurrana ŋuriŋiyi Yitjuralpuyŋuyu miṯtjiyu morrumurru' waŋana Mawtjitjnha ga Yärunnha, yurru ḻayḻaymaraŋala maṉḏanha walala yukurrana Gurayu, Lepay ŋayi ŋunhi yolŋunydja, ga wiripuŋuyunydja Ropinbuyŋuyu maṉḏathu Daythindhu ga Wapiramdhu, ga wiripuŋuyu ŋurruŋuyu yolŋuyu, walala waŋana yukurrana bitjarra maṉḏanha Yärunnha ga Mawtjitjnha, “Yol maṉḏa dhuwala nhumanydja? . . . ŋanapurruŋgu buŋgawa nhuma? Bukmak muka ŋilimurru dhuwala Godkunydja yolŋu'‐yulŋu. Garraynydja dhuwala dhiyalami ŋilimurruŋgala bukmakkala muka. Nhäkuna nhuma yukurra garrwarkunharamirrinydja nhumalanhay nhuma yanapi nhumapina rom‐ŋamakurru' yana, be‐wala djuḻkthun nhuma yukurra ŋanapurruŋgalanydja?” ");
INSERT INTO gnn_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","7","Ga ŋayinydja Mawtjitjtja wirrkina ŋayaŋu‐yätjthina, bala ŋayi ŋurrkanhamina ŋanyapinya ŋayi munatha'lilina, bala bukumirriyaŋalana yukurrana. Ga dhäŋuru ŋuliŋurunydja ŋayi gaŋgathina, bala waŋana Gurawala ga nhanukalaŋuwala malthunaramirriwala walalaŋgala bitjarra, “Goḏarrny'tja boŋguŋunydja Garrayyu boŋgama milkuŋu warraŋulkuŋuna ŋilimurruŋgala, yol ŋayi yuwalk wal'ŋu nhanŋu yolŋu; ŋayinydja ŋunhiyinydja yolŋu ŋunhi ŋayi djarr'yurruna nhanŋuwayliliyaŋala, ŋunhiyina boŋgama galkithinydja wal'ŋu marrtji ŋunhiwala Godkalanydja dhaliyarra'lili.” ");
INSERT INTO gnn_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","10","Ga biyapul ŋayi Mawtjitj waŋana walalaŋgala ŋurikalayi Lepaywala walalaŋgala bitjarra, “Yuwalk ŋayi Godthu nhumalanha djarr'yurrunanydja, ganaŋ'maraŋalana ŋayi nherraranydja wal'ŋu nhumalanha, märr yurru nhuma marrtji galkithirri yana nhanukala, djäma yurru marrtji nhanŋu Garraywu. Liŋgu muka ŋayi märr‐ŋal'yurrunanydja nhumalaŋgala. Nhä dhuwalayinydja? . . . dhäpark? . . . bay' nhä, yutjuwaḻa' warray? Ga dhiyaŋunydja‐wala nhuma yukurra ḏukṯukthirri wapthunarawu ŋunhana bala ŋunhiwalana ḏalkarra'mirriwalana wal'ŋu dharapullili. ");
INSERT INTO gnn_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Ŋunhi nhuma yukurra morrumurruny'tja Yärunnhanydja, yuwalktja ŋunhi nhuma yukurra morrumurru' ŋanyana Garraynhana Godnhana.” ");
INSERT INTO gnn_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Bala ŋayi Mawtjitjthunydja yänguŋalana ŋurikina maṉḏaku märrma'wuna Daythingu ga Wapiramgu, ga maṉḏanydja waŋana ŋunhiyi märrmany'tja bitjarra, “Yakana ŋilinyu yurru marrtji. ");
INSERT INTO gnn_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Liŋgu nhe mayali'‐wilkthurrunanydja ŋanapurrunha ŋäthili muka, liŋgu ŋanapurru gonha'yurruna ŋunha wäŋa ŋamakurruny'tja Yetjippuynydja, malthurruna nhuŋuna marrtjina lili. Ga dhiyaŋunydja‐wala nhe yukurra marrtji bunharawuna ŋanapurruŋgu, nhe yurru bumana ŋanapurrunha dhiyalana ŋanhdharkŋurana wäŋaŋura. Yol dhuwala nhe yolŋunydja? . . . buŋgawa nhe ŋanapurruŋgu? ");
INSERT INTO gnn_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Wanhaka dhika ŋayi be wäŋa ŋatha‐guḻku'mirrinydja ŋunhi nhe dhawu'‐nherrara. Nhenydja ŋunhi mayali'‐wilkthurruna warray ŋanapurrunha. Yakana ŋilinyu yana yurru marrtjinydja nhokala.” ");
INSERT INTO gnn_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Bala ŋayi Mawtjitjtja ŋaramurryinana, bala waŋana Garraywala bitjarrana, “Garray, yakana maṉḏakuŋu märraŋa buku‐wekanharawuynydja. Yaka ŋarra djäma ŋarrapinydja ŋula yätjkuŋala maṉḏaku.” ");
INSERT INTO gnn_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","18","Ga wiripuŋuyunydja goḏarr'mirri ŋayi Guranydja yäku yolŋu ga nhanŋu malthunaramirri walala marrtjina ŋunhimalayina Withiyanminyarawuylilina Buṉbulili, ga gäŋalanydja marrtjina walala ḻirrwi' gurtha ga buŋgan bäw', liŋgu walala ŋunhi guyaŋinanydja bitjarrana dhuḏakthunarawuna yana ŋunhi ḏalkarra'mirrinhana, ŋunhi walala bini marrtjinyanydja bala gulŋiyinyana yana ŋunhiwalayi djinawa'lilina, bala bathanna buŋgan bäwny'tja Garraywuna. Yurru ŋayi Garrayyunydja rom nherrara bitjarra warray, ŋunhi yana walalawuy yurru ḏalkarra'mirri walala yolŋu'‐yulŋu gulŋiyirrinydja yukurra, bala djämana ŋunhiliyi. ");
INSERT INTO gnn_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Yo, ŋunhiyi yolŋu Gura ga nhanŋu bukmak ŋunhiyi malthunaramirri walala dhärrana marrtjina ŋunhiliyi buṉbuŋura, waŋganyŋura gali'ŋura, ga maṉḏanydja Mawtjitjtja ga Yärundja ga wiripuŋuŋura gali'ŋura djingaryurruna. Ŋuliŋurunydja bala walala nhäŋala djarraṯawun'nha, bena wal'ŋu, bala ŋayi maḻŋ'thurrunana ŋayipinydja Garraynydja ŋunhili dhurrwaraŋurana. ");
INSERT INTO gnn_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","21","Bala ŋayi waŋana Yärungala ga Mawtjitjkala bitjarra, “Way maṉḏa, biyaka yarrkthurra maṉḏa barrkulili giṯthurra. Ŋarra yurru dhuwala warrpam'thunna baḏuwaḏuyun dhuwala yolŋu'‐yulŋunhanydja,” bitjarra. ");
INSERT INTO gnn_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Ga maṉḏanydja ŋunhiyinydja maṉḏa märrmany'tja buku‐nyilŋ'thurrunana, bala maṉḏa bukumirriyaŋalana yukurrana ŋurikiyina walalaŋgu yolŋu'‐yulŋuwuna, waŋana bitjarrana, “Garray, nhepina ŋunhi walŋamirrinydja, walŋanydja yukurra marrtji nhokalaynha waŋganygalana. Yaka nhe yurru ŋaramurryirri dhiyaku yolŋu'‐yulŋuwunydja bukmakkunydja, liŋgu waŋganydhu dhuwala yulŋuyunydja djäma bitjarrayi yätjkuŋalanydja.” ");
INSERT INTO gnn_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","25","Bala ŋayi Garraynydja waŋana Mawtjitjkala bitjarra, “Ḻakaraŋa ŋurupa yolŋu'‐yulŋuwanydja biyakana, walala yurru yarrkthunna ŋurikalayinydja walalaŋgala ḻurrkun'kalanydja ḏarramuwurruŋgala, Gurawalanydja ga Daythingalanydja ga Wapiramgalanydja.” ");
INSERT INTO gnn_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Bala ŋayi Mawtjitjtja waŋana ŋuruku yolŋu'‐yulŋuwunydja bitjarrana, “Yarrkthurrana walala biyakana nhuma yolŋu'‐yulŋunydja ŋurikalayi walalaŋgala ḻurrkun'kalanydja yätjmirriwalanydja. Yaka mulkiya ŋula nhä walalaŋgu, märr yurru nhuma yaka rakunydhirri walalaŋgalanydja dhambay.” ");
INSERT INTO gnn_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Bala ŋunhi yolŋu'‐yulŋunydja yarrkthurrunana yukurrana ŋuliŋuruyi walalaŋgala wäŋaŋurunydja, ga ŋunhiyi walala ḻurrkun' ḏarramuwurru dhärra'‐dharrana marrtjina walalaŋgalay wäŋaŋura malanyŋuŋura dhäykamirrina ga yumurrku'mirrina manapanna. ");
INSERT INTO gnn_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","29","Bala ŋayi Mawtjitjtja waŋana bitjarra, “Ŋuli walala yurru ŋunhiyi walala ḻurrkun' yäranydja murrmurryun, ga nhumanydja yurru marŋgiyirrina ŋunhi walalanhana ŋayi Garrayyunydja djarr'yurruna ŋurruŋuyinyarawunydja, yaka ŋayi ŋarranhanydja nherrara dhiyakuyi ŋurruŋuyinyarawu. ");
INSERT INTO gnn_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Ga ŋuli ŋayi yurru Garrayyu djäma wiripunydja wal'ŋu yuṯanydja rom, ŋunhi ŋayi yurru munatha' dhuwala barr'yun, ga dhä‐monygumanydja walalanha ga bukmak nhä walala yukurra ŋayathama, märr yurru walala marrtji walŋamirri dhika‐wala munatha'lilinydja rakunymirriwalanydja wäŋalili, bala nhumanydja yurru marŋgiyirrina, ŋunhi ŋunhinydja walala ḻurrkun'tja yuwalknha wal'ŋu ŋuyulkthina ŋapana‐wekaŋala nhanŋu Garraywu.” ");
INSERT INTO gnn_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","33","Ga dhunupana yana ŋayi ŋunhi munathany'tja barr'yurrunana, bala walala dhunupana yana ŋunhiyi ḻurrkun' ḏarramuwurru ga walalambala dhäykawurru ga djamarrkuḻi' ga bukmak walala yukurrana ŋayathaŋala ŋunhi, warrpam'nha bena‐wala gulŋiyinana ŋarŋgalilina, bala ŋuriŋiyi munatha'yunydja balayi ŋäkirrmaraŋala monyguŋalana, bala walala winya'‐winyayunminana rumbalkuŋalana. ");
INSERT INTO gnn_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Ga walala ŋuruŋu wiripu‐guḻku'yunydja Yitjuralpuyŋuyu nhäŋalana yukurrana, ga ŋäkula walalanha yatjunminyarawuynha, bala walala gundupuŋalanydja, bala wäthunmirrina marrtji wiripu‐guḻku'wunydja, “Waṉḏiyana, waṉḏiyana,” bitjanminana. “Ŋuli bäynha mak ŋilimurrunhana ŋuriŋiyi munatha'yunydja wurkthurru.” ");
INSERT INTO gnn_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Bala ŋayi Garrayyunydja yänguŋalana gurthana, bala nhäranhamaraŋalana ŋunhi wiripu‐guḻku'nhanydja ŋurru'‐ŋurruŋunha, ŋunhinhanydja walalanha ŋunhi walala bini marrtjinya galkithinya bala Godkala dhaliyarra'lili gal'ŋu. ");
INSERT INTO gnn_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","40","Bala walala yukurrana ŋuriŋi ḏalkarra'mirriyunydja walalay dholkuŋalana ŋunhinydja yolŋu'‐yulŋunha ŋunhi ŋayi gurthayu walalanha nhäranhamaraŋala, liŋgu walalaŋgala ŋuriŋi yätjthu. Ga bitjarrayi liŋgu walala marrtjina ŋuriŋiyi ḏalkarra'mirriyu walalay wapmaraŋala banikin'tja malanha ŋunhi walala yukurrana ŋuriŋiyi gäŋala, bala walala yukurrana djuḏul'yurrunana ŋunhiyi binydjitjkuŋalana, bilk‐bilkkuŋalana bitjarrana waŋganylilina, ga ŋuriŋinydjayi walala ŋäkirrmaraŋalana ŋunhiyina dhaliyarra'na, märr yurru walala yukurra ŋuriŋiyi Yitjuralpuyŋuyu yolŋuyu walalay nhäma ŋunhiyi, bala guyaŋirrina yurru bitjanna liŋgu yukurra. Yo, ŋuli ŋayi yurru ŋula yol yolŋu marrtji galkithirrinydja yana Garraywala gänanydja, ŋuriŋi nhanukalaynydja ŋayi yäkuyu yana, ŋayi yurru ŋunhiyinydjayi yolŋu rakunydhirrina, bitjanna yurru bitjarra ŋunhi Gura ga nhanŋu malthunaramirri walala; ŋunhina liŋgu yurru yana ḏalkarra'mirrina yolŋu marrtji galkithirrinydja yana Garraywala, bala djalkthunna yurru buŋgan bäwny'tja ŋunhiwalayi gurthalilinydja, märr yurru yukurra ŋunhiyi ŋawululny'tja gaŋgathirrina bala Garraywuna. ");
INSERT INTO gnn_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Bala wiripuŋuyunydja waluyu walala yukurrana ŋunhiyi Yitjuralpuyŋunydja bukmak yana morrumurru'na gupa‐waŋanana yukurrana maṉḏanha Mawtjitjnha ga Yärunnha, waŋana yukurrana bitjarra, “Nhuma maṉḏa dhiyaŋu maṉḏathu bumara ŋunha Garraywunydja yolŋu'‐yulŋunha.” ");
INSERT INTO gnn_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Bala walala ḻuŋ'thurrunana marrtjina ŋunhimalayinayi waŋganylilina, märr yurru walala yukurra maṉḏanha yarrkmaramana Mawtjitjnha ga Yärunnha ŋunhili. Bala walala bilyu'‐bilyurrunanydja, ga nhäŋala waŋupini ŋunhi ŋayi yukurrana ŋäkirrmaraŋala buṉbunha ŋunhiyi Garraywu, yurru be‐wala dhika djarraṯawun'tja, liŋgu ŋunhiyinydja ŋayipina wal'ŋu Garraynha maḻŋ'maranhamina ŋunhilimi waŋupini'ŋuranydja. ");
INSERT INTO gnn_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Bala maṉḏa ŋunhi Mawtjitjtja ga Yärundja marrtjina lili, bala dhärranana yukurrana ŋunhiliyi buṉbuŋura dhurrwaraŋura. ");
INSERT INTO gnn_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","45","Bala ŋayi Garraynydja waŋana bitjarra maṉḏakala, “Yarrkthurrana maṉḏa yolŋu'‐yulŋuwalanydja dhiyakalanydja. Dhiyaŋunydja‐wala ŋarra yurru baḏuwaḏuyunna warrpam'thunna dhuwala yolŋu'‐yulŋunhanydja,” bitjarra. Ga maṉḏanydja ŋunhiyi maṉḏa ṉepaḻ‐nyilŋ'thurruna buku‐nyilŋ'thurruna, bala maṉḏa yukurrana bukumirriyaŋala wirrkina dhikana wal'ŋu ŋuriki yolŋu'‐yulŋuwunydja. ");
INSERT INTO gnn_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Bala ŋayi Mawtjitjthu waŋana Yärunnhana, “Waḏutja, waḏutja Yärun! Märraŋa nhe yurru banikin, ga wapmaraŋa gurthanydja ḻirrwiny'tja ŋuliŋuru dhaliyarra'ŋurunydja, bala djalkthurrana buŋgan bäw'nha ŋunhimalayi ḻirrwi'lilinydja. Waḏutja waṉḏiya, ga ḏarrtjalkkuŋana marrtjiya ŋunhi yolŋu'‐yulŋunhanydja dhiyaŋuyinayi romdhu. Liŋgu Garraynydja ŋunha ŋaramurryina wirrkina; liŋguna ŋunhi yolŋu'‐yulŋunydja murrmurryunna marrtji rerriyuna.” ");
INSERT INTO gnn_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Ga dhunupa ŋayinydja Yärundja waṉḏinana, ga märraŋala ŋunhiyi banikin'nha gurthamirrina ga buŋgan bäw' ŋunhi, bala ŋayi waṉḏinanydja dhika ṉapuŋga'kurruna nhinana bala ŋurikala yolŋu'‐yulŋuwalanydja. Ŋayi nhäŋala, ŋunhi walala marrtjina murrmurryurrunana, burruḻ'yurrunana marrtjina rakunymirrina munatha'lilina. Ga dhunupana ŋayi ŋunhi djalkthurrunanydja ŋunhiyi buŋgan bäwny'tja ḻirrwi'lilina gurthalilina, bala ŋayi ŋunhiyi buŋgan bäwny'tja gaŋgathinana marrtjina nhanŋu Godkuna. Yo, bitjarrayinydja ŋayi ŋunhi djäma ḏarrtjalkkuŋalana marrtjina ŋunhinha yolŋu'‐yulŋunhana. ");
INSERT INTO gnn_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Bala ŋayi yukurrana ŋunhi Yärundja dhärranana ŋunhili ṉapuŋga'na; waŋgany gali'ŋuranydja rakunymirri marrtjina ŋorra'‐ŋurrana, ga wiripuŋuranydja gali'ŋura ga walŋamirri yolŋu walala marrtjina dhärrana, ga ŋayinydja marrtjina ŋunhi buŋgan bäwny'tja ŋawulul' gaŋgathina ŋuliŋuru banikin'ŋurunydja, ŋunhi ŋayi marrtjina garrwarkuŋala. Bala ŋunhinydja rerrinydja gulyurrunana mukthurrunana, yakana biyapulnydja marrtjina yolŋu walala murrmurryurruna. ");
INSERT INTO gnn_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Yurru ŋula nhämunha'na miṯtji dhaŋaŋnha bäymana rakunydhina yolŋunydja walala, murrmurryurrunanydja. ");
INSERT INTO gnn_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Bala ŋayi balayi Yärundja roŋiyina ŋunhiwalayi buṉbulili, Mawtjitjpa ḏo'yurruna, liŋgu ŋunhiyi rerrinydja gulyurrunana, warrpam'nha ḏaḏawyurrunana. ");
INSERT INTO gnn_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Yo, marrtjinanydja walala yukurrana‐a‐a, ŋunhi Yitjuralpuyŋunydja yolŋu walala, yana liŋgu‐u‐u, wäŋa ŋayathaŋala nhäyika Gäditjpuy, bala dhut‐gay nhinanana walala ŋunhimala wäŋalilinydja. Ga ŋunhiliyinydja wäŋaŋura ŋayi Miriyamnha rakunydhina, bala walala ŋanya dholkuŋalana. ");
INSERT INTO gnn_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Yurru wäŋanydja ŋunhi gapumiriw, ŋanhdhark, ga yolŋu'‐yulŋunydja ŋunhi gapuwuna yukurrana ḻarruŋala, waŋanana ŋarrtjurrunana marrtjina Mawtjitjnha ga Yärunnhana. ");
INSERT INTO gnn_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Ga bitjarrana walala morrumurru' waŋananydja gam', “Ŋe, ŋilimurru bini ŋunhi murrmurryunna ŋunhalaŋga bäyma, Garraywuŋu muka bunhara, rrambaŋiŋga bini ŋunha wäwaŋga walala. ");
INSERT INTO gnn_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Nhäku warray nhuma maṉḏa gäŋala lili ŋanapurrunha dhipalanydja ŋanhdharklilinydja gay? Ŋilimurrunydja yurru dhuwala murrmurryunna dhiyalana, ŋilimurruway yolŋu'‐yulŋu ga wäyin walala ŋilimurruŋgu. ");
INSERT INTO gnn_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Nhäku muka nhuma dhawaṯmaraŋala ŋanapurrunha ŋulaŋuru Yetjipŋurunydja, bala gäŋala dhipalanydja yätjlilinydja wäŋalili? Ŋathamiriw warray dhuwalanydja wäŋa, ga borummiriw warray, ga bäyŋu warray gapunydja ŋula wurkthunarawunydja.” ");
INSERT INTO gnn_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Bala maṉḏa Mawtjitjtja ga Yärundja gaŋgathina, bala marrtjina ŋunhimala Buṉbulili ŋunhi walala ŋuli Garray withiyanminya. Bala maṉḏa ŋurrkanhamina maṉḏanhay maṉḏa munatha'lili, buku‐nyilŋ'thurrunana, ga ŋunhalayina Garraynydja maḻŋ'thurruna maṉḏakala, dhä‐monyguŋala maṉḏanha djarraṯawun'thuna, ḻatju'yuna yana dhikana. ");
INSERT INTO gnn_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","8","Bala yana Garraynydja waŋana Mawtjitjkalana, “Ma', märraŋa ŋunhiyi wapitja, ga yurrum'maraŋa dhuwali yolŋunha walalanha bukmaknha yana waŋganylili, nhe ga wäwa‐ŋaliyu Yärundhu, ga ŋunhalayina maŋutjimara walalaŋgala bukmakkalana, nhe yurru waŋiya ŋunhiyi guṉḏanhanydja, dhärukthunna yana waŋiya, märr ŋayi yurru gapunydja ḻarrwaw'yunna ŋuliŋuru guṉḏaŋurunydja, bala ḻarryunna yurru dhiyakuyi yolŋu'‐yulŋuwunydja. Yo, märr yurru walala ḻuka yukurra, ga walalaŋgala wäyindhu walalay wurkthundhi yurru.” ");
INSERT INTO gnn_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","10","Bala yuwalkthi Mawtjitjthu märraŋalana ŋunhiyi wapitjany'tja, ga yurrum'maraŋala yolŋunhanydja walalanha bukmaknhana yana ŋunhimalayi guṉḏalilina. Bala ŋayi Mawtjitjtja waŋanana ŋurikala yolŋu'‐yulŋuwalana bitjarrana, “Ŋäkana nhumanydja wurraŋatjarramirriyunydja. Nhaltjan dhika ŋilinyu yurru yulŋunydja? . . . gapuyu nhumalanha wekama dhipuŋuru gay guṉḏaŋuru?” ");
INSERT INTO gnn_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Bala ŋayinydja Mawtjitjthunydja mar'yurrunana wapitjany'tja, garrwarkuŋalanydja, bala yana wutthurrunana ŋunhiyi guṉḏanhana ḏe‐e‐e, ḏe‐e‐e bitjarra, buku‐märrma'mirri, bala marrtjina gapunydja ḻarrwaw'yurrunana, bena dhika dhaŋaŋnha gapunydja ḻarryurrunana nhinana. Bala bukmakthuna yolŋu'‐yulŋuyunydja ḻukana wurkthurruna ŋunhiyi gapunydja, ga wäyindhu walalay bitjarrayi liŋgu ḻukanayi. ");
INSERT INTO gnn_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Yurru ŋayi Garraynydja maṉḏakala ŋayaŋu‐yätjthina Mawtjitjkala ga Yärungala, liŋgu maṉḏa dhäruk ŋanya baḏatjurruna, wutthurruna warray maṉḏanydja ŋunhi guṉḏanha biyapul. Bala Garraynydja waŋana Mawtjitjkala ga Yärungala bitjarra, “Yakana yurru nhuma maṉḏa gäma ga ŋilitjan dhuwalanhanydja yolŋunha miṯtjinha ŋunhamalayinydja wäŋalili, ŋunhi ŋarra wekaŋala walalaŋgu, liŋgu nhuma yaka ŋarranha märr‐yuwalkthina; yaka nhuma milkuŋala dhiyakala yolŋu'‐yulŋuwalanydja miṯtjiwalanydja ŋunhi ŋarrakunydja ganydjarr ganaŋ'thunna yukurra dhuwala, garrkuḻuknha wal'ŋu, gänana yana ŋarrapina.” ");
INSERT INTO gnn_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Yo, dhuwalayinydja maḻŋ'thurruna wäŋaŋura yäkuŋura Miripana, bili ŋunhiliŋumi wäŋaŋura yolŋuyu walalay ŋarrtjurruna yukurrana Garraynha, ga ŋunhalayi ŋayi maḻŋ'maranhaminanydja ŋanyapinyay ŋayi walalaŋgala, ŋunhi ŋayinydja gäna wal'ŋu garrkuḻuk. ");
INSERT INTO gnn_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Yo, ŋulaŋurunydja wäŋaŋuru ŋayi Mawtjitjthu djuy'yurruna dhäwu'‐gänharamirrinhana djunamayi wäŋalili yäkulili Yedamlili, Ŋurruŋuwu ŋurikiyi wal'ŋu Buŋgawawu ŋayi dhäruk djuy'yunmina bitjarra gam', “Ŋanapurru dhuwala Yitjuralpuyŋunydja mala wäwa‐ŋali walala, ŋilimurru malaŋga. ");
INSERT INTO gnn_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Nhumanydja bili muka ŋäkula ŋunhi ŋanapurruŋgu märi'munydja marrtjina bala Yetjiplili, ga ŋunhalayinydja ŋanapurruŋgu yukurrana marinydja marrtjina biyapulnha bathala. ");
INSERT INTO gnn_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Bala ŋanapurrunydja märrliliyaŋala Garraywala warray, bala ŋayi ŋanapurrunha ŋäkulana rirrakaynydja nyä'yunminyaranydja, bala yana ŋayi marrtjina dhawaṯmaraŋalana ŋanapurrunha. Ga dhuwalana ŋanapurru yulŋunydja, galkina nhumalaŋgalana wäŋaŋura. ");
INSERT INTO gnn_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Ḏukṯuktja ŋanapurru dhuwala, ŋanapurru yurru marrtji balakurru‐wala djuḻkthun nhumalaŋgala wäŋakurru. Yaka ŋanapurru yurru ŋula djaw'‐djawyun ŋatha ga gapu ga ŋula nhä mala nhumalaŋgu, yana ŋanapurru yurru marrtji dhunupa dhukarrkurru, ga yakana bilyun gatjpaḻ'yun ŋula nhälilinydja.” ");
INSERT INTO gnn_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","20","Yurru ŋayinydja ŋunhi Buŋgawanydja waŋana marrtjina yaka'yurruna warray. “Yaka yana nhuma yurru marrtji djuḻkthun balakurru ŋarrakalanydja wäŋakurru,” bitjarra. Bala dhunupa yana ŋayi djuy'yurrunana miṯtjinhana miriŋunhana nhanbalay marililina bunharawuna walalaŋgu Yitjuralpuyŋuwuna. ");
INSERT INTO gnn_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","22","Bala walala Yitjuralpuyŋunydja bilyurruna, bala wiripukurruna dhukarrkurru marrtjina, yana liŋgu ga wäŋa ŋayathaŋala buku yäku Wurwuy. ");
INSERT INTO gnn_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Bala ŋunhalanydja Garray waŋana Mawtjitjkala bitjarrana, ");
INSERT INTO gnn_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“Yärundja rakunydhirri yurru dhiyalana, yakana ŋayi boŋguŋu gulŋiyi ŋunhimalanydja wäŋalili ŋunhi ŋarrakuŋu wekanhara Yitjuralpuyŋuwu, liŋgu nhuma maṉḏa baḏatjurruna ŋarranha dhäruk ŋunhala ŋunhi ya', Miripa gapumirriŋura. ");
INSERT INTO gnn_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Mawtjitj, nhenydja yurru garr'yurra Yärunnha ga gäthu'mirriŋunha nhanŋu Layatjanha, ga gäŋa maṉḏanha ŋunhamala bukulili, ");
INSERT INTO gnn_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","bala ŋunhilinydja nhe yurru yupmaraŋa Yärungala rumbalŋuruna girri', ŋunhina wal'ŋu ḏalkarra'mirriwana yolŋuwa girri'. Yupmaraŋana nhanukala girriny'tja, bala nherrala nhanukalaŋuwala gäthu'mirriŋuwalana Layatjawalana, ŋayina yurru Yärungalanydja dharapullili wapthun. Ŋayi yurru Yärundja ŋunhiliyina bäyŋuthirri, rakunydhirrinydja yurru.” ");
INSERT INTO gnn_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Bala Mawtjitjthunydja märraŋalana yana dhäruktja Garraynha; walala ḏuwaṯthurrunana bukulilina marrtjina ŋal'yurruna. ");
INSERT INTO gnn_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Ga ŋunhalana ŋayi bukuŋurana Mawtjitjthu yupmaraŋala girriny'tja rumbalŋuru Yärungalanydja, bala nherra'‐nhirrara gäthu'mirriŋuwalana Yärungalaŋuwala. Bala Yärundja gurrunhanmina ŋunhilina rakunydhina, bala maṉḏapina Mawtjitjnha ga Layatjana roŋiyinanydja dhunarrana marrtjina ŋulaŋuru bukuŋurunydja. ");
INSERT INTO gnn_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Yo, walala yolŋu'‐yulŋuyunydja nhäŋalana maṉḏanha, maṉḏa nhinana marrtjina lili walalaŋgu bunana, bala yana marŋgithinana ŋunhi Yärundja liŋguna bäyŋuthinana. Bala walala nyä'yunminana, wiṯthunminana dhikana nhanŋu, yana liŋgu ga waŋgany ŋaḻindinydja ŋupara ŋäthinyaminanydja. ");
INSERT INTO gnn_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Ga walalanydja ŋunhiyi Gaynanbuyyunydja yolŋu'‐yulŋuyu ŋäkulana walalanhanydja Yitjuralpuyŋunhanydja miṯtjinha, ŋunhi walalanydja yukurrana marrtjinana lili galkithinana, bala walala yana marrtjinana bunharawuna walalaŋgu. Bunharaminanydja walala yukurrana, bala ŋuriŋiyi Gaynanbuyŋuyunydja yolŋu'‐yulŋuyu djaw'‐djawyurrunana marrtjina wiripu‐guḻku'nhanydja Yitjuralpuyŋunha, walala bini djaw'‐djawyuna balayi walalaŋgalaynha walala wäŋalili. ");
INSERT INTO gnn_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Ga walalanydja ŋunhiyi dhunupana yana Yitjuralpuyŋunydja gawaw'yurruna märrliliyaŋala Godkalana, waŋana bitjarrana, “Garray, guŋga'yurra ŋanapurrunha,” bitjarrana. “Ŋunhi nhe yurru guŋga'yun ŋanapurrunhanydja, märr yurru ŋanapurru djuḻkmaramana ŋunhayi Gaynanbuyŋunhanydja miṯtjinha yolŋu'‐yulŋunha, ga ŋanapurruna yurru walalambala baḏuwaḏuyun ŋunhiyi wäŋanydja warrpam'thunna; ŋanapurru yurru dhuŋgur'yun gurthayuna bukmaknha nhä malanha ŋunhalayinydja nhuŋuna.” ");
INSERT INTO gnn_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Bala ŋayi Garrayyunydja ŋäkula ŋunhiyi rirrakaynydja walalanha, bala ŋayi guŋga'yurrunana yana dhunupana walalanha, bala yuwalkthi yana walala ŋunhi baḏuwaḏuyurruna ŋunhiyi wäŋanydja ŋuriŋiyinayi bili Godkalana ganydjarryu. ");
INSERT INTO gnn_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Nhinana muka walala yukurrana ŋunhala bäyma bukuŋura Wurwuyŋura, ga ŋuliŋurunydja dhurrwaraŋuru walala ḻaw'yurrunana, wiripulilina wäŋalili giṯthurruna, yurru marrtjinanydja walala yukurrana gilipuŋala Yedamgurru gali'kurru yana. Marrtjinana yukurrana ga‐ga‐ga‐ga‐a‐a, ḻiw'maraŋalana marrtjina, ga ŋunhalanydja bala gandarrŋuranydja, walala ŋunhi yolŋu'‐yulŋunydja djawaryunminana, ");
INSERT INTO gnn_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","bala marrtjina ŋarrtjurruna Garraynhana ga Mawtjitjnhana. “Nhäkuŋga nhe ŋanapurrunha dhawaṯmaraŋala ŋulaŋuru Yetjipŋurunydja ŋunhi? . . . dhiyaku murrmurryunarawu? . . . Ŋanapurru yurru raku'‐rakunydhirri dhiyala ŋanhdharkthinyarayu? Ŋathamiriwnha dhuwalanydja wäŋa, ga gapumiriwnha, räwaknha. Ŋanapurrunydja dhuwala djawaryunna marrtji waŋganydhunydja ŋathayu ḻukaranharayu ŋupanayŋuyuna, ŋunhina bili ŋatha manana.” ");
INSERT INTO gnn_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Bala Garrayyunydja djuy'yurruna marrtjina moḻ'ŋu warray dhirrimuknha bäyma dhika, guḻku'na dhaŋaŋnha, maḏakarritjmirrinhana dhikana, walala marrtjina bumarana ḻäwu'‐ḻawuŋala yolŋu'‐yulŋunhana, ga guḻku'na mirithirrina yolŋunydja marrtjina raku'‐rakunydhina. ");
INSERT INTO gnn_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Bala walala yolŋu'‐yulŋuyunydja withiyara Mawtjitjnhana, bala waŋanana marrtjina bitjarrana, “Ŋanapurru yana rom‐yätjthinanydja, ŋunhi ŋanapurru bitjarrayi marrtjina waŋana ŋarrtjurruna Garraynha ga nhuna. Nhe mak bukumirriyaŋa ŋi' Garraywala, märr yurru ŋayi yarrkmaramana bäyŋukumana dhuwala moḻ'ŋunhanydja miṯtjinha.” Yuwalkthi ŋayi Mawtjitjtja bukumirriyaŋala waŋana Garraywalana ŋuriki yolŋu'‐yulŋuwuna, ");
INSERT INTO gnn_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","bala ŋayi Garraynydja buku‐ruŋiyinmaraŋala nhanukala Mawtjitjkalanydja bitjarrana, “Gatjuy moḻ'ŋukuŋa nhenydja djäma lätuŋnha, bala nhe yurru ŋal'maramanydja garrwarlili ŋunha dharpalili. Ŋunhi yurru ŋula yolnha moḻ'ŋuyunydja ḻäwuma, ŋayinydja yurru ŋuriŋinydja yolŋuyu bakurumana, bala nhämana ŋanya ŋunhiyi moḻ'ŋunhanydja liŋguwuynha dhuḻ'yunara, bala yurru ŋayi ŋunhiyinydja yolŋu walŋana nhina, yakana yurru ŋayi rakunydhirrinydja.” ");
INSERT INTO gnn_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Yuwalkthi ŋayi Mawtjitjthunydja djämana‐wala yana ŋunhi moḻ'ŋu lätuŋdja, bala yana ŋal'maraŋala dharpalilina, ŋunha wal'ŋu garrwarlili. Ga ŋula yol yolŋu ḻäwunharanydja moḻ'ŋuwuŋu, ŋayinydja ŋuriŋiyinydja yolŋuyu nhäŋala bakuruŋalana ŋunhi moḻ'ŋunydja dhuḻ'yunarana liŋguwuynha, bala yana ŋayi ŋunhiyinydja yolŋu baḏarraŋ'thinana. ");
INSERT INTO gnn_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Ga dhurrwaraŋuru ŋuliŋurunydja walala Yitjuralpuyŋunydja giṯthurrunana marrtjina, bala walala wäŋaraŋala nhinananydja ŋunhiliyina wäŋaŋura gumurr‐waṉarra'ŋurana, Mawapnha wäŋaŋura. ");
INSERT INTO gnn_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Ga ŋulinyaramirriyunydjayi buŋgawanydja yukurrana nhinana Balak yäku, buŋgawa ŋayi ŋurikiyi Mawappuyŋuwu yolŋu'‐yulŋuwu, ga ŋäkula ŋayi yukurrana ŋunhiyi Yitjuralpuyŋunhanydja miṯtjinha, nhaltjarra walala ŋunhi bumara baḏuwaḏuyurruna Yamarpuyŋunha yolŋu'‐yulŋunha. ");
INSERT INTO gnn_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Bala walalanydja ŋunhi Balaktja ga miṯtjinydja nhanŋu wirrkina beyaṉiyina dhika ŋurikiyi Yitjuralpuyŋuwunydja miṯtjiwu, ");
INSERT INTO gnn_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","bala walala waŋanana ŋurukala ŋurru'‐ŋurruŋuwalanydja bitjarrana, “Way, guḻku'na ŋunha mirithirrina yulŋunydja, dhaŋaŋnha dhikana miṯtjinydja Yitjuralpuyŋunydja. Galkina walala yurru baḏuwaḏuyunna ŋilimurrunha warrpam'thunna, bitjanna yurru bitjan ŋuli buliki'yu ḻuka marrtji mulmu ḏulŋurr'yun ḻiw'marama, bitjandhina yurru.” ");
INSERT INTO gnn_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Ga ŋunhilinydja wäŋaŋura galki, yolŋu djawarrkmirri yukurrana nhinana yäku Baylam, ga ŋayinydja ŋunhi buŋgawayunydja dhäwu'na djuy'yurruna ŋurikiyi Baylamgunydja, waŋana bitjarrana, “Ŋarranydja djäl nhuŋu, nhe yurru marrtji lili guŋga'yun ŋarranha, liŋgu yolŋu walala miṯtji ŋunha marrtjina lili ŋulaŋuru Yetjipŋuru, ga dhuwalana walala yukurra nhinanydja galki ŋilimurruŋgalana wäŋaŋura, yurru guḻku'na mirithirri yulŋunydja miṯtjinydja, galki walala yurru djaw'‐djawyun marrtji wäŋanydja ŋilimurruŋguna ŋula nhä malanha. ");
INSERT INTO gnn_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Go, marrtjiya lili nhe yurru ŋi' buku‐djulŋi, ga waŋiyanydja walalanha biyaka buku‐wuykthurra nyirawunuŋana, märr yurru ŋanapurru marrtji, bala gukumana walalanha dhipuŋurunydja yurru wäŋaŋuru. Ŋarra marŋgi nhuŋunydja, ŋunhi nhenydja ŋuli waŋa ŋula yolku wekamanydja ŋayaŋu‐ŋamathinyaramirri yana dhäruktja, bala yolŋunydja ŋayi ŋuli ŋunhiyi nhina yukurra ŋayaŋu‐djulŋithirrina, goŋmirrina dhikana yana, ga ŋunhi nhe yurru waŋa buku‐wuykthundja nhaltjandja ŋula yolnha, ga ŋayinydja yurru ŋunhi yätjnha yanana marrtji yolŋuwu ŋurikiyi.” Bitjarra ŋayi ŋuriŋiyi buŋgawayunydja djuy'yurruna dhäruktja nhanŋu Baylamgunydja. ");
INSERT INTO gnn_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Bala ŋurru'‐ŋurruŋuyunydja walalay ŋuriŋi Mawappuyŋuyunydja märraŋala guḻku'na mirithirrina rrupiyanydja ga girriny'tja malanha, bala gäŋala wekanharawu mundhurrnha nhanŋu Baylamguna, bäyimnha bitjarrana ŋurikiy buku‐wuykthunarawuynha. Bala walala marrtjinanydja yukurrana, ga ḻakaraŋala nhanbala Baylambanydja dhäruknha ŋunhiyina ŋanya buŋgawanhana. ");
INSERT INTO gnn_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Ga ŋayi Baylamdja waŋana bitjarra, “Way walala, dhiyala nhuma yurru nhina ŋi' ŋarrakala, waŋgany munha. Ga ŋarranydja yurru ŋäŋ'thun Godnha Garraynha. Mak ŋayi ḏukṯuk ŋarraku marrtjinyarawu, mak yaka ŋayi ḏukṯuk ŋarraku marrtjinyarawu.” Bala walala ŋunhi dhäwu'mirrinydja walala nhinanana yukurrana ŋunhiliyi waŋganynha munha yakurr. ");
INSERT INTO gnn_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Ga ŋuliwitjarrayi munha‐ŋupara ŋayi Garrayyunydja ŋanya waŋana Baylamnha bitjarra, “Yol walala ŋunha ḏarramuwurrunydja marrtji ŋorra'‐ŋurra nhokala wäŋaŋuranydja?” ");
INSERT INTO gnn_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","11","“Ŋunhanydja ḏarramuwurru nhanukuŋu buŋgawawuŋu djuy'yunara Mawappuyŋuwuŋu, ŋayi ḏukṯuk ŋarraku, ŋarra yurru be marrtji bala, ga buku‐wuykthun ŋunha yolŋu'‐yulŋunha, ŋunhi walala marrtjina beŋuru Yetjipŋuru,” bitjarra ŋayi Baylamdja. ");
INSERT INTO gnn_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Ga ŋayi Garraynydja waŋana nhanukala Baylamgala bitjarra, “Yakana yurru nhe marrtji. Yaka waŋiya buku‐wuykthurra ŋunhiyi yolŋu'‐yulŋunha Yitjuralpuyŋunhanydja, liŋgu walalanydja liŋguwuynha ŋunhiyi ŋarrakuŋunydja goŋmirriyanharana.” ");
INSERT INTO gnn_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Wiripuŋuyunydja munhakumirri goḏarr'mirri ŋayi gaŋgathina, bala ŋayi waŋanana ŋunhiyi bo'puyŋunhanydja walalanha bitjarra, “Gatjuy balayi marrtjiya roŋiyiya ŋi'. Yaka dhuwala ŋarra yurru marrtjinydja nhumalaŋgala bay', liŋgu Garray ŋarraku waŋana yaka'yurruna marrtjinyarawu.” ");
INSERT INTO gnn_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Bala walala roŋi'‐ruŋiyinanydja, ga ḻakaraŋala nhanbala ŋuripa buŋgawawanydja bitjarrana. “Bäyŋu bay'. Yakana ŋayi yurru marrtji lili,” bitjarra. ");
INSERT INTO gnn_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","16","Bala ŋayinydja ŋuriŋiyinydja Balakthunydja buŋgawayu wiripu‐guḻku'nhana djuy'yurruna be dharrpalmirrinhana wal'ŋu yolŋu'‐yulŋunha, bala walala marrtjina ga bunana Baylamguna, ga waŋana bitjarra ŋanya, “Way ŋunha buŋgawanydja waŋana bitjarra, ‘Nhe yurru marrtji yana.’ Wirrki yana ŋayi waŋananydja ŋunha nhuŋu, nhe yurru marrtji, ");
INSERT INTO gnn_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","ga bäyimdja nhuna ŋayi yurru mirithirri guḻku'yu dhika wal'ŋu; yana waŋiya ŋanya nhäku nhe ḏukṯuk, ga ŋayinydja yurru nhuŋu wekamana yana. Marrtji yurru nhe yana yulŋunydja, bala yana buku‐wuykthunna nhe yurru ŋunhi yolŋu'‐yulŋunhanydja.” ");
INSERT INTO gnn_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Bala ŋayi Baylamdja waŋana buku‐wakmaraŋala bitjarra, “Ŋunhi ŋayi yurru buŋgawayu ŋuruŋu wekama warrpam'thundja ŋarraku nhä ŋayi yukurra ŋayathama, ŋarranydja yurru yakana marrtji. Ŋarranydja yurru ŋunhina liŋgu warkthun ŋunhi nhaltjan ŋayi yurru Garrayyu ŋarranha waŋa. ");
INSERT INTO gnn_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Yurru ŋorriya warray yulŋunydja nhuma yurru, dhiyala warray, ga ŋarranydja yurru waŋa dhä‐wirrka'yun Garraynha biyapul. Mak ŋula ŋayi yurru dhäruk wekama ŋarraku wiripuna.” ");
INSERT INTO gnn_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Ga ŋuriŋiyinydjayi munhayu ŋayi Garray waŋana bitjarrana nhanukala Baylamgala, “Baylam, ŋunhi walala yurru nhuna dhiyaŋu walalay garr'yun biyapulnydja, ga nhenydja yurru marrtji yana, yurru djämanydja nhe yurru ŋunhiyi yana liŋgu ŋunhi ŋarra nhuŋu yurru waŋa ḻakarama.” ");
INSERT INTO gnn_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Ga wiripuŋuyuna goḏarr'mirri, bala ŋayi Baylamdja marrtjinana walalambala malthurrunana. ");
INSERT INTO gnn_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Yurru ŋayi Garraynydja Godtja ŋaramurryina warray Baylamgala, liŋgu marrtjina ŋayi yukurrana, märr bini ŋayi buku‐wuykthuna manapana nyirawununha Yitjuralpuyŋunha, yana märranharawu rrupiyawu. Marrtjinanydja ŋayi yukurrana yarraman'thu bala Baylam, bala ŋayi Garrayyunydja yänguŋala djiwarr'wuynha warray yolŋunha, ŋayi yukurrana dhärrana dhukarrŋura goŋ‐mandjawakmirri warray, gungaŋala yukurrana ŋunhiyi dhukarr. ");
INSERT INTO gnn_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Ga ŋayinydja ŋuriŋinydja yarraman'thunydja nhäŋala ŋunhi djiwarr'wuynha yolŋunha, ŋayi bini wutthuna Baylamnha, bala ŋayi ŋunhi yarraman'tja bilyurruna, bala waṉḏina gali'lilina gatjpaḻ'yurruna. Ga ŋayinydja ŋanya Baylamdhunydja bartjunmaraŋala ŋunhi yarraman'nha, bilmaraŋala ŋunhiwalayi balayi dhukarrlili. ");
INSERT INTO gnn_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Ga mukthurruna yana maṉḏa marrtjina yukurrana ŋunhiyi yarraman', ga Baylamdja marrtjina gorruŋala bala. Ga biyapul ŋayi ŋunhiyi djiwarr'wuy yolŋu djingaryurruna yukurrana dhukarrŋura yana ṉapuŋga', gungaŋala dhukarr, yurru gali'ŋuranydja maṉḏanyŋuŋura ŋunhilimiyi dhukarrŋuranydja ḻoḻu yukurrana dhärrana ḏälnha. ");
INSERT INTO gnn_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Nhäŋala ŋayi ŋunhi djiwarr'wuynha yolŋunha ŋuriŋi yarraman'thunydja, ŋayi bini ŋunhi waṉḏinya muka yulŋunydja, yana ŋayi dhä‐ŋal'yurruna ḻoḻulilina, bala buḻŋu'kuŋala djalkirina ŋanya Baylamnha. Ga biyapul ŋayi Baylamdhunydja bartjunmaraŋala ŋanya ŋunhiyi yarraman'nha wirrkina. ");
INSERT INTO gnn_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","27","Ga mukthurruna yana maṉḏa marrtjina yukurrana, ga biyapul ŋayi nhäŋala ŋuriŋiyi yarraman'thu djiwarr'wuynha yolŋunha ŋunhi, bala wirrkina ŋayi dhika beyaṉiyinanydja, yurru bäyŋuna nhanŋu dhaḻakarrnydja waṉḏinyarawunydja ŋurikiyi yarraman'kunydja, yana ŋayi ŋorranana ŋunhilina bäymana dhukarrŋurana. Ŋayinydja ŋunhi Baylamdja wirrkina wal'ŋu maḏakarritjthina nhanŋu, bala ŋayi dharpana märraŋala, bala bartjunmaraŋalana ŋanya yukurrana ŋunhiyi yarraman'nhanydja, bumarana yukurrana wirrkina. ");
INSERT INTO gnn_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Bala ŋayi Garrayyunydja dhärukmirriyaŋala ŋunhiyi yarraman'nhana, bala ŋayi waŋana dhärukmirriyinana bitjarrana bitjan ŋuli yolŋu waŋa yukurra, waŋana bitjarrana, “Nhäku nhe yukurra bartjunmaramanydja ŋarranha? Nhä dhika ŋarra djarrpi'kuŋalanydja nhuŋu, ŋunhi nhe ŋarranha bartjunmaraŋala ḻurrkun'mirri?” ");
INSERT INTO gnn_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Ga ŋayinydja Baylamdja waŋana bitjarra, “Ŋaḻwa'yun nhe yukurra dhuwala, wakalkuma ŋarranha. Ŋunhi bini ŋarra mandjawakmirrinydja, ŋarra bini nhuna dharpunhana,” bitjarra. ");
INSERT INTO gnn_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Ga ŋayinydja yarraman'tja waŋana bitjarra, “Ŋarranydja dhuwala be muka nhuŋuway yarraman', ga bitjanna liŋgu ŋarra nhuna gämanydja ŋuli yukurra ḻatju'kuma dhika ŋiniya?” ");
INSERT INTO gnn_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Bala ŋayi Garrayyunydja maŋutjina ḻapmaraŋala Baylamnhanydja, bala ŋayi nhäŋalana ŋunhi djiwarr'wuynhanydja yolŋunha, ŋayi yukurrana dhärrana goŋ‐mandjawakmirri, bala yana ŋayinydja ŋurrkanhaminana marrtjina Baylamdja ŋunhimala yana dhukarrlili, bukunydja djuḻuḻ'maranhaminana. ");
INSERT INTO gnn_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Bala ŋayi ŋunhi djiwarr'wuy yolŋu waŋana bitjarra, “Nhäku warray nhe ŋunhi bartjunmaraŋala buku‐ḻurrkun'mirrinydja ŋunhi yarraman'nhanydja? Ŋarranydja ŋunhi marrtjina lili ḏaḏawmaranharawu nhuŋu, märr yurru nhe yaka marrtji ga guykthun waŋa nyirawunuma Yitjuralpuyŋunha. ");
INSERT INTO gnn_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Ŋarra bini nhuna bunha muka yulŋunydja, yurru ŋayi yarraman'thunydja nhäŋala ŋarranha, bala walŋakuŋalana nhuna.” ");
INSERT INTO gnn_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Ga ŋayi Baylamdja bitjarrana waŋana, “Yo, ŋarrapi dhuwurr‐yätjthinanydja. Yaka ŋarra nhuna nhäŋala. Ŋarra yurru dhuwala marrtji roŋiyirrina balayi ŋi'?” ");
INSERT INTO gnn_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Ga ŋayi ŋunhiyi djiwarr'wuynydja yolŋu waŋana bitjarra, “Marrtji warray nhe yurru yulŋunydja, dhiyapa walalambala ḏarramuwurrumbala malthun warray, yurru waŋanydja nhe yurru ŋunhiyi dhäruktja liŋgu ŋunhi nhaltjan yurru ŋarra nhuŋu dhäruk wekama waŋanharawu.” Bala ŋayi marrtjinana Baylamdja, mukthurrunana malthurrunana yana walalambala. ");
INSERT INTO gnn_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Bala ŋayi buŋgawayunydja ŋuriŋiyi Balakthunydja ŋäkulana ŋanya Baylamnha, ŋunhi ŋayinydja yukurrana marrtjinana lili, withiyarana ŋanya, bala yana ŋayi marrtjinana nhanŋu gumurr‐wunanhaminyarawuna. Bala ŋayi waŋana bitjarrana ŋanya Baylamnha, ");
INSERT INTO gnn_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","“Nhäku warray nhe ŋunhi yakanydja marrtjina lili ŋulinyaramirriyu ŋunhi ŋarra nhuŋu ŋäthili gawaw'yurruna? Nhenydja ŋunhi guyaŋina yanapi ŋarra nhuna bäyŋu bini wekanha bäyim? Ŋarranydja dhuwala ḻukunydja yolŋu, biyapul ŋarra girri' guḻku'mirri. Buku‐wuykthurra nhe yurru yana nyirawunuŋa yulŋunydja ŋunha Yitjuralpuyŋunhanydja, bala ŋarranydja nhuna yurru bäyimnha guḻku'yuna dhikana rrupiyayu.” ");
INSERT INTO gnn_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Ga ŋayi Baylamdja waŋana bitjarra, “Dhuwalana ŋarranydja, yurru waŋanydja ŋarra yurru ŋunhiyina bili waŋganynha dhäruk ŋunhi ŋayi yurru Garrayyu wekama ŋarrakala waŋanharawu.” ");
INSERT INTO gnn_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","40","Bala ŋayi Baylamdja marrtjina, manapanna maṉḏa buŋgawana ŋunhi. ");
INSERT INTO gnn_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Ga wiripuŋuyunydja munhakumirri goḏarr'mirri, maṉḏa marrtjina ḏuwaṯthurruna bukulilina, ga ŋulaŋuruna maṉḏa yukurrana nhäŋalanydja djipmaraŋalana bukuŋuruna Yitjuralpuyŋunhanydja, walala yukurrana nhinana wäŋaraŋala ŋunhiliyi ŋoyŋura wäŋaŋura. ");
INSERT INTO gnn_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","2","Ga ŋayi Baylamdja waŋana bitjarra, “Ŋali yurru djäma barŋ, märr ŋali yurru mundhurr wekama wäyin bathan dhiyala.” Bala maṉḏa djämanydja ŋunhiyi barŋ, dhunupa bathara mundhurrnha wekaŋala buliki'na ga bembina. ");
INSERT INTO gnn_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","5","Ga ŋuliŋurunydja dhurrwaraŋuru ŋayi Baylamdja marrtjina bala gänaŋulilina, bala ŋayi Garrayyunydja wekaŋala dhäruknha nhanŋu waŋanharawuna Baylamgu. ");
INSERT INTO gnn_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Bala ŋayi roŋiyinanydja ŋunhiyi Baylamdja, nhäŋala Balaknhanydja, ŋayi yukurrana dhärrana ŋunhili bäyma dhaliyarra'ŋurana galki, wiripu‐guḻku'wala dhambay ŋurikala ŋunhi Mawappuyŋuwala ŋurru'‐ŋurruŋuwala. ");
INSERT INTO gnn_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Bala ŋayi waŋanana dhunupana Baylamdja bitjarrana gam', “Yo, ŋayi Balakthunydja gäŋala ŋarranha lili dhipala warray, märr ŋarra yurru buku‐wuykthun yukurra yolŋu'‐yulŋunha Yitjuralpuyŋunha miṯtjinha. ");
INSERT INTO gnn_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Nhaltjan dhika ŋarra yurru walalanha buku‐wuykthundja? . . . ŋunhi ŋayi ŋuli yaka Godthunydja walalanha buku‐wuykthun yukurra? ");
INSERT INTO gnn_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Dhipuŋurunydja gay' bukuŋurunydja ŋarra yukurra nhämana ŋunhayi yolŋu'‐yulŋunhanydja biyapulnha gal'ŋu dhaŋaŋnha miṯtji. Wiripuŋuyunydja miṯtjiyu bäpurru'yu yukurra ḻakarama walalanha nhäŋiniŋ' ḻakaramana, yurru ŋayi Godthunydja yukurra walalanha goŋmirriyama warray dhika wal'ŋu, biyapul warray ŋurikala wiripu‐guḻku'walanydja bäpurru'wala. ");
INSERT INTO gnn_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Ŋayinydja walalanha Garrayyunydja biyapul warray djäma dhaŋaŋguŋala, biyapulnha wal'ŋu bothurrumiriwnha ŋunhiyi yulŋunydja, ga ḻakaramanydja ŋayi ŋuli walalanha Godthu ŋayaŋu‐dhunupamirrina yana. Ŋe, ŋarrana ŋuli rakunydhi biyakuyi ŋayaŋu‐yal'yunaranydja, bitjan walala.” ");
INSERT INTO gnn_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Bala ŋayi Balaktja mirithinana maḏakarritjthina Baylamgalanydja, ga waŋana bitjarrana, “Way, mukthurrana nhe! Nhäku nhe yukurra dhuwala waŋa bitjandhinydja?” bitjarra. “Ŋarranydja ŋunhi waŋana nhe yurru walalanha yukurra buku‐wuykthun, ga nhenydja walalanha goŋmirriyama yukurra dhiyaŋi nhokala dhärukthu warray.” ");
INSERT INTO gnn_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Ga ŋayi Baylamdja waŋana bitjarra, “Ŋarranydja yurru waŋa ŋunhi yana liŋgu dhäruk ŋunhi nhaltjan ŋayi yurru Garrayyu dhäruk wekama ŋarrakala.” ");
INSERT INTO gnn_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","14","Bala ŋayi Balakthunydja garr'yurrunana Baylamnhanydja wiripuŋulilina wäŋalili, bala ŋuliŋuruyinydja ŋayi nhäŋala märr‐ḻurrkun'nhana Yitjuralpuyŋunhanydja. Ga biyapul ŋayi Balak waŋana Baylamgala, “Ma' biyaka buku‐wuykthurra walalanha,” bitjarra. ");
INSERT INTO gnn_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","18","Bala biyapul ŋayi Baylamdja waŋana ŋunhiyi warray liŋgu yana Godku warray dhäruk, bitjarra gam'. “Way Balak, mäkiri'‐witjurra dhiyaku dhärukku gam'. ");
INSERT INTO gnn_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Godtja dhuwala ganaŋ'thun yukurra yolŋu'‐yulŋuwalanydja. Yolŋu'‐yulŋuyu warray ŋuli bothirrinydja ḻakarama yukurra, yurru Godtja dhuwala gäna wal'ŋu, yakana ŋayinydja ŋuli bothirri ḻakarama. Ŋalinydja ŋuli yolŋuyunydja dhuwala djambi warray ḻiya ŋitjalaŋguway, yurru Godthunydja ŋayipinydja ŋuli yaka warray djambi, ŋayinydja ŋunhi warray liŋgu, ŋupanayŋu warray djambimiriw. Ŋunhi ŋayi ŋuli dhawu'‐nherraṉdja ŋula nhä, djämana ŋayi ŋuli yana yulŋunydja; Ga waŋa ŋayi ŋuli dhäruktja, bala ŋayi yurru maḻŋ'thunna yana. ");
INSERT INTO gnn_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Ŋayinydja Godtja waŋana bitjarra ŋarrakala, ‘Ŋunhanydja goŋmirriyaŋa yolŋunha walalanha ya',’ bitjarra, ga ŋunhi ŋayi ŋuli Godthu goŋmirriyamanydja wal'ŋu ŋunhi yolŋu'‐yulŋunha, ŋarranydja yurru yakana gulmarama ŋanya ḏaḏawmarama. ");
INSERT INTO gnn_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Yitjuralpuyŋunydja dhuwalanydja bäpurru' yakana yurru yukurra marrtji marikurru, liŋgu Garray Godtja walalaŋgu warray Waŋarr, ŋurruŋunydja wal'ŋu ŋayi buŋgawanydja walalaŋgu, galki ŋayinydja walalaŋgala yana. ");
INSERT INTO gnn_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Godtja dhuwala be wal'ŋu ganydjarr‐ḏumurru ŋayi, ga walalaŋgala ŋayi gali'ŋuranydja ŋunha; Ŋayipi yana walalanha dhawaṯmaraŋalanydja beŋuru Yetjipŋurunydja, ga buma ŋayi ŋuli baḏuwaḏuyun warrpam'thun walalaŋgu miriŋunhanydja. ");
INSERT INTO gnn_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Yakana yurru ŋula yolthu buku‐wuykthundja Yitjuralpuyŋunha, yakana yurru ŋula yolthu walalanha buma ŋula marrŋgitjkunharayunydja be romdhu. Walala yurru yolŋu'‐yulŋuyunydja nhäma ŋunhiyi Yitjuralnhanydja miṯtjinha, bala waŋa yurru bitjanna, ‘Yuwalk warray ŋunha walalanha Godthunydja yukurra goŋmirriyama warray dhika wal'ŋu.’ ");
INSERT INTO gnn_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Ŋunhiyi miṯtji Yitjuralpuyŋunydja ḏälmirrina wal'ŋu dhikana, bitjan maḏakarritjmirri wäyin; yakana ŋayi yurru ŋunhiyi ŋorranydja yukurra, yana liŋgu ga ḻuka ŋayi yurru dhawar'maramana yana ŋunhi, ŋunhi nhanukuŋu bunhara.” ");
INSERT INTO gnn_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Bala ŋayi Balaktja waŋana bitjarra, “Way yaka! Yaka walalanha biyakayi goŋmirriyaŋa yukirriya.” ");
INSERT INTO gnn_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Ga ŋayi Baylamdja waŋana bitjarra, “Liŋgu ŋarra nhuŋu ŋunhi ḻakaraŋalanydja, ŋarra yurru bukmak yana djäma dhika nhä ŋunhi ŋayi ŋuli ŋarrakala Garrayyu wekama.” Ga biyapul ŋayi Balak waŋana Baylamgala bitjarra, “Go marrtjiya malthurra ŋarraku wiripuŋulili wäŋalili. Mak ŋayi yurru Godthu dhäruk wekama nhuŋu buku‐wuykthunarawu Yitjuralpuyŋuwu.” Bala ŋayi Garraywu Garrkuḻuktja ŋunhi walŋa bunana Baylamgala, ga biyapul ŋayi waŋana Godku dhäruk, goŋmirriyaŋala ŋunhi Yitjuralpuyŋunha. ");
INSERT INTO gnn_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Ga ŋayinydja Balaktja ŋaramurryina wirrkina dhika, waṉa‐ŋara'‐ŋarakayinana, waŋana bitjarrana, “Mukthurrana. Ŋarranydja nhuŋu ŋunhi wäthurruna, märr nhe yurru buku‐wuykthun ŋarraku miriŋunha, ga nhenydja buku‐ḻurrkun'mirri warray goŋmirriyaŋala walalanha. ");
INSERT INTO gnn_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Gatjuy marrtjiyana wäŋalilina. Ŋarranydja ŋunhi nhuŋu dhawu'mirriyaŋala mundhurr, yurru yakana ŋarra nhuŋu yurru wekamanydja, liŋgu ŋayi Garrayyunydja wiripu warray dhäruktja nhokala wekaŋala waŋanharawunydja.” ");
INSERT INTO gnn_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","13","Ga ŋayi Baylamdja waŋana bitjarra, “Liŋgu muka ŋarra ŋunhi dhäruktja wekaŋala nhokalaŋuwala dhäwu'mirriwalanydja, ga yakana ŋarra yurru djuḻkmarama dhäruktja Garraynha. Yakana ŋarra yurru djäma ŋarrakalaynydja ŋarra ḏukṯukthu, bäyyi ŋunhi nhe ŋarraku yurru be buku‐yattjatkunharanydja wekama; ŋarra yurru waŋanydja ŋunhiyi yana liŋgu dhäruk ŋunhi ŋayi yurru Garrayyu ŋarrakala wekama dhäruk waŋanharawu.” ");
INSERT INTO gnn_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","13","Bala ŋayi Garraynydja waŋanana Mawtjitjkala bitjarrana, “Marrtjiya bala bukulili wal'ŋu ŋunha ya'. Ŋuliŋuruyinydja nhe yurru nhämana marrtji wäŋana, ŋunhina wäŋa ŋunhi ŋarra yurru wekama Yitjuralwu miṯtjiwu, yana nhe yurru nhämana marrtji yulŋunydja ŋunhiyi wäŋanydja, yurruna nhe yurru rakunydhirrinydja. Yo, nhuŋu wäwa'mirriŋu Yärundja liŋguna rakunydhina, ga nhenydja yurru bitjandhi liŋgu rakunydhirri dhiyalana gay', yakana nhe yurru gulŋiyirri ŋunhiwalayinydja wäŋalili, ");
INSERT INTO gnn_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","liŋgu nhuma maṉḏa nhepi ga Yärun, yaka nhuma ŋarraku dhäruk märraŋala ŋunhala ŋunhi wäŋaŋura yäkuŋura Miripa. Bukmakthu yolŋuyunydja walalay yukurrana morrumurruny'tja ŋarranha. Walala bini nhänha muka ŋarraku ganydjarr bathalanydja, yurru nhumanydja yaka warray ŋunhiyi waŋananydja dhäruktja, märr bini ŋunhiyi gapunydja waṉḏinyana yana ŋuliŋuruyi guṉḏaŋuru ŋuriŋina liŋgu ŋarrakalaynha wal'ŋu ganydjarryu.” ");
INSERT INTO gnn_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","16","Bala ŋayi ŋuliŋuruyinydja Mawtjitjtja bukumirriyaŋalana bitjarrana, “Garray, nhepina dhuwala walŋa‐wekanhamirrinydja, nhokalaynha yurru walŋanydja yukurra marrtji. Garray, nhepina yurru djarr'yurranydja yolŋunhanydja ŋunhi yurru ŋayi ŋurruŋuna ŋuriki yolŋu'‐yulŋuwuna bukmakkuna, dhäŋuru dhipuŋurunydja ŋunhi ŋarra yurru rakunydhirri. ");
INSERT INTO gnn_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","Djarr'yurranydja ŋunhiyi yolŋunhanydja ḏarramunhanydja ŋunhi walala yurru märr‐yuwalkthirri, märr‐nherraṉmirri gal'ŋu nhanukala, märr yurru walala dhäruk marrtji märrama ŋanya bala, märr yurru walala djuḻkthun ŋurikiyi miriŋuwunydja. Ŋarranydja ḏukṯuk nhokalaŋuwu yolŋu'‐yulŋuwu, walala yurru nhina waŋgany yana ŋurruktja, dhapirrk yana, yaka barrku'‐barrkuwatjthirri, bitjan ŋuli wäyin mala ŋunhi bembi djäkamiriwŋura.” ");
INSERT INTO gnn_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Bala ŋayi Garraynydja waŋana bitjarra Mawtjitjkala, “Garr'yurranydja nhe yurru Djatjuwanha, liŋgu ŋarrakunydja walŋamirrinydja Birrimbirr nhina yukurra nhanukala. Gäŋanydja ŋanya garr'yurranydja bala Ŋurruŋuwala Ḏalkarra'mirriwala yolŋuwala, Layatjawala yäkuwala, bala nhe yurru goŋ‐ŋal'yunna nhanukala muḻkurrlilina. ");
INSERT INTO gnn_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Ga ŋunhalayinydja maŋutjiŋura bukmakkalanydja nhe yurru waŋa bitjanna, ‘Dhuwalanydja gay' ḏarramu djarr'yunara nhanukuŋuwaynha yana Godkuŋuna, ŋayina yurru dhuwalayinayi nhumalaŋgu ŋurruŋunydja.’” ");
INSERT INTO gnn_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Ga biyapul ŋayi Garray waŋana Mawtjitjkala bitjarranydja, “Dhipuŋurunydja‐wala yakana yurru nhepinydja yukurra gänanydja ŋurruŋu nhina, nhuma maṉḏa yurru rrambaŋina djingaryundja ŋurruŋunydja walalaŋgu, märr yurru ŋuriŋiyi yolŋu'‐yulŋuyu Yitjuralpuyŋuyunydja miṯtjiyu dhäruk märrama ŋanya Djatjuwanhanydja. ");
INSERT INTO gnn_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Bala ŋayi yurru Djatjuwayunydja ŋäŋ'thun guŋga'yunarawu nhanŋuway ŋayi ḏalkarra'mirrinhana, bala ŋayi yurru ŋuriŋiyi ḏalkarra'mirriyunydja yolŋuyu maḻŋ'marama marrtji Garraywuna djäl, nhäku ŋayi Garray ḏukṯuk walalaŋgu djämawu, bala ŋayi yurru ŋuriŋiyi ḏalkarra'mirriyunydja ḻakaramana Djatjuwawalanydja ga ŋurikala yolŋu'‐yulŋuwala, bala walala yurru malthunna yana dhärukku ŋurikinydja ḏalkarra'mirriwunydja.” ");
INSERT INTO gnn_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Bala ŋayi Mawtjitjthunydja märraŋalana yana dhäruktja, nhaltjarra ŋayi Garrayyu ḻakaraŋala yukurrana nhanukala. Märraŋalana ŋayi ŋunhiyi Djatjuwanhanydja, bala nherrarana ŋanya maŋutjimara ŋurikala ḏalkarra'mirriwala ga bukmakkalana. ");
INSERT INTO gnn_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Goŋ‐ŋal'yurrunanydja ŋayi Mawtjitj ŋunhi Djatjuwawala muḻkurrlilinydja, bala ŋayi waŋanana ŋuriki yolŋu'‐yulŋuwunydja bitjarrana, “Dhuwalana gay yolŋu yurru nhumalaŋgu ŋurruŋunydja dhurrwaraŋuru ŋuliŋurunydja ŋunhi ŋarra yurru rakunydhirri. Nhumanydja yurru malthun dhiyakunayi yolŋuwunydja yuwalkkuma yana.” ");
INSERT INTO gnn_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","5","Dhuwalana malanha ŋunhi dhäruktja ŋunhi ŋayi Mawtjitjthu waŋana yukurrana ḻakaraŋala bukmakku ŋurikiyi Yitjuralpuyŋuwu yolŋu'‐yulŋuwu, ŋunhi walala yukurrana nhinana ŋunhala ŋanhdharkŋura wäŋaŋura wiraŋŋura, dhimurru'ŋura gali'ŋura Djodanŋura mayaŋ'ŋura. Yo, 40‐na dhuŋgarranydja liŋguna djuḻkthurruna ŋuliŋurunydja ḏaykun'ŋuru ŋunhi walala gonha'yurrunana Yetjip wäŋa, ga ŋunhiliyinydja wäŋaŋura walala yukurrana nhinana, galkurruna yukurrana marrtjinyarawu gulŋiyinyarawuna bala Gaynanlilina. Bala ŋayi Mawtjitjthu ḻakaraŋala yukurrana bitjarrana walalambala, dhunuk‐dhunukmirriyaŋalana Godku romnha malanha. ");
INSERT INTO gnn_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","Ŋayi waŋananydja bitjarra, “Ŋunhala ŋunhi bukuŋuranydja Djäniyanydja yäkuŋura Garrayyu ŋilimurruŋgala Godthu waŋana bitjarra, ‘Dhiyalanydja bukuŋura ŋunhi nhuma yukurrana nhinana märr‐weyinnha. ");
INSERT INTO gnn_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","Gonha'yurrana dhuwalayi wäŋanhanydja, ga marrtjiya mukthurrana‐wala yana. Wekaŋalanydja ŋarra ŋunhi ŋunhiyinydja wäŋa Gaynanbuynydja nhumalaŋguway, bukmak ŋunhi ŋarra dhawu'‐nherrara yukurrana ŋäthili nhumalaŋgalaŋuwala märi'muwala. ");
INSERT INTO gnn_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","Ŋunhiyi wäŋanydja nhumalaŋguway yana. Marrtjiyana‐wala yana, bala gulŋiyiyana ŋunhiwalayi wäŋalilinydja. Djaw'yurrana yana ŋuliŋuruyi miriŋuwalanydja, bala nhiniyana wäŋaraŋana yukirriya, märr yurru ŋunhiyi wäŋanydja goŋŋura nhumalaŋgalaynha yana.’” Ga bitjarra ŋayi yukurrana God waŋananydja. ");
INSERT INTO gnn_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","Ga ŋayinydja Mawtjitjtja waŋana bitjarra, “Dhäruktja märraŋa ŋi dhuwalayinydja rom malanha, ŋunhi ŋarra yukurra waŋa nhumalanha marŋgikuma, märr yurru nhuma yukurra nhina walŋa yana. Ŋuli nhuma yurru ŋayathama yukurra dhuwalayi romnha baṯ bitjandja, nhumanydja yurru gulŋiyirrina ŋunhiwalayi wäŋalili ŋunhi ŋayi Garrayyu dhawu'‐nherrara ŋilimurruŋgalaŋuwala märi'muwala, ŋunhayina yurru nhumalaŋgu wäŋanydja gupaḏalkunharawuna‐wala nhinanharawu. ");
INSERT INTO gnn_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","Garrayyu ŋilimurruŋgala Godthunydja nherrara dhuwalayi romdja nhanukalaŋuwu yolŋu'‐yulŋuwu. Dhäruktja märraŋa warrpam'thurra yana dhuwalayinha romnhanydja. Yakana biyapulnydja marrtjiya bukulili ŋal'‐ŋalmaraŋa bala wiripunydja malanha rom, ga yaka yana ŋula waŋgany rom ḏupthurra. ");
INSERT INTO gnn_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","Liŋguna nhuma nhäŋala ŋunhiyi, ŋunhi ŋayi Garrayyu bumara warrpam'thurruna dhawar'maraŋala ŋunhinhanydja yolŋu'‐yulŋunha ŋunhi walala yukurrana buku‐ŋal'yurruna wiripuŋuwu waŋarrwu Bälwu yäkuwu. ");
INSERT INTO gnn_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","Ga nhumanydja wiripu‐guḻkuny'tja dhuwala mukthun walŋamirri yana, liŋgu yuwalkkuŋala yana nhuma yukurrana ŋayathaŋala dhuwalayi rom, ga malthurruna nhuma yukurrana nhokalayŋuwu Garraywu Godku. ");
INSERT INTO gnn_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","7","“Ŋarra nhumalanha liŋgu marŋgikuŋalanydja ŋunhiyi rom ŋunhi ŋilimurruŋgala Garrayyu Godthu wekaŋala, ga ŋunhi nhuma yurru gulŋiyirrinydja ŋunhiwalayi wäŋalilinydja, nhuma yurru ŋayathamanydja baṯ bitjan yana dhuwalayi romnha, märr yurru ŋuruŋu wiripu‐guḻku'yunydja miṯtjiyu bäpurru'yu nhämana nhumalanha, bala ḻakarama nhumalanha yurru ḻiya‐djambatjmirrina, liŋgu nhuma marŋgina ŋamathanharawunydja nhinanharawu. Ŋilimurruŋgunydja God dhuwala ŋayi galki yana ŋilimurruŋgala, ŋäma ŋayi yukurra ŋilimurrunha, ŋunhi ŋilimurru ŋuli gawaw'yun bala guŋga'yunarawu nhanukala, yurru ŋuriŋinydja walalaŋgala waŋarryunydja yakana yurru walalanha guŋga'yun. ");
INSERT INTO gnn_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","Dhuwalayi malanha manymak yana dhunupa romdja wal'ŋu; yakana ŋuli wiripuŋuyunydja bäpurru'yu yukurra ŋayathama ŋamakurru' rom, balanyara bitjan dhuwala gay' ŋunhi ŋarra yukurra nhumalanha marŋgikuma dhiyaŋu‐wala. ");
INSERT INTO gnn_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","10","“Gurrum'thurra walala yulŋunydja. Yaka meṉguŋanydja ŋunhiyi malanha rom ŋunhi nhuma nhäŋala yukurrana nhumalaŋgalay nhuma maŋutjiyu nhumapi, liŋgu dhärrana nhuma yukurrana ŋunhala bukuŋura Djäniya yäkuŋura, gumurrŋurana wal'ŋu nhanukala Garraywala, ŋunhi ŋayi yukurrana waŋana ḻakaraŋala ŋarrakala. Ḻakaraŋa ŋunhiyi dhäwu' nhumalaŋgalaŋuwa yumurrku'wanydja ga nhumalaŋgalaŋuwa gutharra'mirriŋuwa walalambala, märr yurru nhuma yaka muka meṉguma. Yo, nhumanydja ŋäkula warray ŋunhi ŋayi Garrayyu ḻakaraŋala bitjarra ŋarrakala, ‘Ḻiw'maraŋa ŋunha yolŋu'‐yulŋunhanydja, ŋarranydja ḏukṯuk walala yurru ŋäma ŋarranha dhäruk, märr yurru walala marŋgiyirri yukurra ŋarraku, ŋunhi ŋarranydja gäna wal'ŋu ŋula nhämiriw, märr yurru walala borrk‐beyaṉiyirri ŋarraku, ga dhäruk märrama yurru ŋarranha yuwalkkuma yana wal'ŋu gupaḏalkuma, ga marŋgikuma marrtji djamarrkuḻi'nhana walalaŋguway walala malthunarawu ŋarraku borrk‐beyaṉiyinyarawuna.’ ");
INSERT INTO gnn_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","“Yo, nhinananydja nhuma yukurrana galki wal'ŋu yana ŋunhala bukuŋuranydja, ŋunhi ŋayi Garray marrtjina maḻŋ'maranhamina ŋanyapinyay ŋayi ŋunhala bukuŋura, bala bukunydja ŋunhi marrtjina nhäranana bitjarrana bitjan gurthayu, gungaŋala yukurrana ŋunhi ŋäkirrmaraŋalanydja dhirrimukthuna maŋandhu. ");
INSERT INTO gnn_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","Ŋäkula warray nhuma yulŋunydja rirrakaynydja ŋanya Garraynha, ŋunhi ŋayi waŋana ŋuliwitjarrayi gurthakurrunydja, yurru yakana nhuma nhäŋala ŋanya rumbalnydja. ");
INSERT INTO gnn_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","Yo, ŋayipinydja Garrayyunydja nhumalaŋgala ḻakaraŋala, nhuma yurru nhina yukurra dhambay‐manapan waŋganydhirri nhanukala, ŋunhili liŋgu dhawu'‐nherraṉarawuyŋura ŋunhi ŋayi nherrara nhumalaŋgala, ga rom nhanŋu nhuma yurru märrama yana ŋunhiyi ḏämbumirri ga ḏämbumirri ŋunhi ŋarra wukirri marrtjina guṉḏalili maṉḏaŋulili ŋunhiyi romdja. ");
INSERT INTO gnn_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","Yo, Garrayyunydja ŋarrakala ḻakaraŋala, ŋarra yurru bukmakkuma yana marŋgikumanydja nhumalanha ŋuliŋuruyi romŋurunydja malaŋuŋuru, nhaltjan nhuma yurru yukurra nhina ŋunhala ŋunhi, ŋunhi nhuma yurru gulŋiyirri.” ");
INSERT INTO gnn_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","“Yo, Garraynydja nhumalaŋgala waŋana gurthakurru yana ŋunhili bukuŋuranydja, yakana nhuma ŋanya nhäŋala ŋula rumbalnydja. ");
INSERT INTO gnn_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","18","Ŋuli nhuma yurru djäma rumbalkumanydja, ŋula nhä yurru yolŋukumanydja, bitjan ŋarirri wo moḻ'ŋu wo yolŋu dhäyka wo ḏarramu, ŋuli nhuma yurru waŋarr ḻakarama ŋunhiyi goŋbuynydja djämawuy, ŋunhiyinydja yätjnha mirithirrina wal'ŋu. ");
INSERT INTO gnn_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","Ga bitjandhi liŋgu nhuma yurru yaka yana waŋarr ḻakarama ŋunha djiwarr'wuynydja nhä malanha, balanyara bitjan ŋaḻindi ga walu ga ŋula nhä malanha, yaka yana buku‐ŋal'yurra ŋurikiyinydja malaŋuwu nhäku. Wiripu‐guḻkuny'tja yolŋu walala buku‐ŋal'yun yukurra balanyarawuyinydja malanyŋuwu, ŋunhi ŋayi djäma Garrayyu, ga nhumanydja dhuwalanydja walala ga Garraywu nhanŋuway yolŋu'‐yulŋu. ");
INSERT INTO gnn_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","Nhumalanha muka ŋayinydja ŋunhi walŋakuŋala mariŋuru yindiŋurunydja, ŋayi nhumalanha dhawaṯmaraŋala Yetjipŋuru wäŋaŋuru, märr yurru nhumanydja nhanŋuway yana wal'ŋu dhulŋuŋu yolŋu'‐yulŋu. ");
INSERT INTO gnn_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","Ga nhumanydja ŋunhi ŋuyulkthina warray, ŋapa‐wekaŋala warray Garraywu, bala ŋayinydja Garraynydja maḏakarritjthinana ŋaramurrthinana ŋarraku, bala ŋayi Garraynydja waŋana bitjarrana, ŋarra yurru yaka buḏapthun ŋurukuyi mayaŋ'ku Djodanbuyŋunydja. ");
INSERT INTO gnn_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","Ŋarranydja yurru rakunydhirri dhiyala bäyma, yakana yurru ŋarra gulŋiyirri ŋunhiwalayinydja wäŋalili ŋunhi ŋayi Garrayyu yurru wekama nhumalaŋgu. Ga nhumana yurru buḏapthundja balayi, ga ŋunhiyi yurru manymaktja dhikanydja wäŋa nhumalaŋguwaynha. ");
INSERT INTO gnn_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","Ga yaka meṉguŋanydja, nhumanydja dhuwalanydja walala nhanŋuway yana dhulŋuŋu Garraywu yolŋu'‐yulŋu. Ŋayi nhumalanhanydja djäma yolŋukuŋala nhanŋuway, ga liŋguna ŋayi dham'maraŋalana dhambay‐manaparana yulŋunydja, nhanukalaynha ŋayi wapmaraŋala ŋuriŋiyinayi dhawu'‐nherraṉarayu. Dhäruktja ŋanya märraŋa, ga yakana yana djäma ŋula nhänydja buku‐ŋal'yunarawunydja nhumalaŋguway. ");
INSERT INTO gnn_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","Liŋgu Godtja ŋunhinydja balanyara biyaku ŋuli ŋäṉarr gurtha, wirrki yana ŋayi yukurra ḏukṯukthirrinydja nhe yurru nhanŋuway yana wal'ŋu yolŋu. Ŋuli nhe yurru waŋarrkuma wiripuŋunhanydja waŋarrnha nhuŋuway, yakana ŋayi yurru waŋa bitjandja ‘bäyyi’, bitjandja. ");
INSERT INTO gnn_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","“Yo, ŋunhi nhuma yurru marrtjinydja ŋunhimalayi wäŋalilinydja ga yumurrkuny'tja nhumalaŋgu yurru marrtji dhawal‐wuyaŋirrina, ga gutharra'mirriŋu walala bitjan yana liŋgu yurru marrtji dhawal‐wuyaŋirri bala, yakana biyapulnydja bilyurra yätjlili. Yakana yukirriya märr‐ŋal'yurra ŋuriki maḏayin'kunydja malaŋuwu nhäku malaŋuwu. Dhuwaliyinydja yätjnha mirithirrina; ŋayi yurru Godtja ŋaramurryirrina wirrkina yanana nhumalaŋgu. ");
INSERT INTO gnn_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","Yuwalk yana ŋarra yukurra dhuwala ḻakaramanydja Garraywala yäkuyunydja, ŋuli nhuma yurru märr‐yuḻkthundja, yakanydja ŋayathama dhuwalayi dhäruk, nhumanydja yurru yakana nhina weyinŋumirri ŋunhilinydja wäŋaŋura. ");
INSERT INTO gnn_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","28","Miriŋuna yurru marrtji ŋunhimalayi wäŋalili, ga buma nhumalanha baḏuwaḏuyun dhawar'maramana yurru; märr‐ḻurrkun'nha yurru nhuma nhina yukurra walŋamirrinydja, yurru barrkuwatjthirrina nhuma yurru nhina yukurra wiripuŋuŋurana miṯtjiwala yolŋu'‐yulŋuwala. Ga ŋunhalayi barrkunydja wäŋaŋura wiripuŋuranydja, nhuma yurru buku‐ŋal'yun yukurra ŋurikiyinayi waŋarrwu goŋbuywuna djämawuywu, dharpana ŋunhi djämawuy ga guṉḏana. Yo, ŋunhiyinydja waŋarr malanha maŋutjimiriwnha ga buthurumiriwnha, bäyŋuna walala yukurra ŋäma ga nhäma, bäyŋuna walala yurru ŋunhi walŋakumanydja nhumalanha. ");
INSERT INTO gnn_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","Ga ŋunhalayi benydja‐wala barrkunydja wäŋaŋura nhuma yurru yukurra warrya'yunna, ḻarrumana nhuma yurru nhumalaŋgalaŋuwu Garraywuna Godkuna. Ga ŋuli nhuma yurru yuwalktja ḏukṯukthirri nhanŋu märr‐ŋal'yunarawu wal'ŋu, ga ḻarruma yurru warrya'yun bukmakthunydja ŋuriŋinydja nhumalaŋgalay ŋayaŋuyu, yuwalknha yana nhuma yurru ŋanya maḻŋ'maramanydja. ");
INSERT INTO gnn_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","Yo, ŋunhili dhä‐yawar'yunaraŋuranydja wäŋaŋura nhuma yurru nhina yukurra bathalaŋurana mariŋura, bala nhuma yurru bilyun Garraywalana, ga dhäruk ŋanya märramana yurru. ");
INSERT INTO gnn_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","Ŋayinydja ŋunhi mel‐wuyunaramirri God, yaka ŋayi yurru nhumalanha ŋunhi ganan gupaḏalkumanydja, yakana ŋayi yurru meṉguma nhanukuŋuwaynydja ŋayi ŋunhi dhäwu', ŋunhi ŋayi dhawu'‐nherrara nhumalaŋgalaŋuwala märi'muwala. ");
INSERT INTO gnn_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","38","“Bäyŋu yana wal'ŋu ŋäthilinydja ŋula wiripuŋuyunydja waŋarryu walŋakuŋala nhanŋuway yolŋu'‐yulŋunha ŋuliŋuruyi miriŋuwalanydja goŋŋuru, märr yurru walala nhanŋuway yolŋu walala gal'ŋu. Yakana wiripuŋuyunydja waŋarryu waŋana walalaŋgala yolŋu'‐yulŋuwala ŋuliŋuru gurthaŋurunydja, ga djäma milma walalaŋgala maŋutjimara ŋula ḻatju' rom ganydjarr‐ḏumurru. Yurru ŋayinydja Godthunydja liŋgu ŋayi djäma bitjarrayinydja nhumalaŋgu, märr yurru nhumapinydja marŋgiyirri muka nhanŋu, ŋunhi ŋayinydja waŋgany yana ŋayipi yuwalkŋunydja God. Yakana ŋula wiripunydja waŋarr. Bäyŋuna wiripunydja waŋarr walŋa‐ḏikṯiktja balanyara bitjan ŋayi. Ŋayinydja ŋunhi nhumalanha dhawaṯmaraŋala ŋuliŋuru Yetjipŋurunydja wäŋaŋuru biyapulnha gal'ŋu ganydjarryu bathalayuna, ga gukuŋalana ŋayi liŋguna ŋunhiyi be ḏälmirrinhanydja wal'ŋu miṯtjinha, märr yurru ŋayi gäma nhumalanha ŋunhimalayina wäŋalili, ŋunhi ŋayi wekaŋala nhumalaŋguna. ");
INSERT INTO gnn_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","Biyaka guyaŋiya, ŋunhi ŋayinydja ŋayipina waŋganynha God, ga ŋunha ŋayi nhina yukurra djiwarr'ŋura ga dhiyalami ŋayi munatha'ŋura; yaka ŋanya meṉguŋanydja, liŋgu yakana wiripunydja yuwalkŋu God. ");
INSERT INTO gnn_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","Dhäruktja nhanŋu märraŋa bukmaknha yana ŋunhi ŋarra yukurra ḻakarama nhumalaŋgu dhiyaŋu‐wala, märr yurru nhuma ga nhumalaŋgu mala‐wunharawuy ŋunhi nhina yukurra ŋamathama wal'ŋu dhika yurru, nhinanydja nhuma yurru yukurra weyinŋumirrina gupaḏalnha-wala‐yana ŋunhili wäŋaŋuranydja, ŋunhi ŋayi Garrayyu Godthu ŋuli yukurra wekama nhumalaŋgu.” ");
INSERT INTO gnn_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","Ŋayi Mawtjitjthu yolŋu'‐yulŋunhanydja ḻuŋ'maraŋalana marrtjina waŋgany‐manaparana, bala waŋana bitjarrana ŋayi walalanha, “Ŋäka walala. Gäthuranydja dhuwala ŋarra yurru ḻakarama romnha nhanŋu Garraywu nhumalaŋgu, märr nhuma yurru marŋgiyirri, ga nhina yurru yukurra ŋuriŋi yana liŋgu romdhu. ");
INSERT INTO gnn_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","Ŋunhala ŋunhi bukuŋura Djäniyanydja yäkuŋura Godthu Garrayyu dhawu'‐nherrara ŋayi ŋilimurruŋgala. ");
INSERT INTO gnn_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","Yaka yana ŋayi ŋunhi dhawu'‐nherrara ŋilimurruŋgalaŋuwala märi'muwalanydja; bitjarrayi liŋgu ŋilimurruŋgalanydja ŋayi dhawu'‐nherrarayi ŋunhi ŋilimurru yukurra dhiyaŋu‐wala dhuwala nhina walŋamirri. ");
INSERT INTO gnn_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","5","Waŋananydja ŋayi yukurrana ŋulaŋuru gurthaŋurunydja, ga ŋarranydja yukurrana dhärrana ŋunhili nhumalaŋgala ga Godkala ṉapuŋga, märr ŋarra yurru ḻakarama Godku dhäruktja nhumalaŋgala, liŋgu nhuma yukurrana beyaṉiyina ŋurukuyi gurthawu, yaka nhuma marrtjina galkithina ŋunhalayi bukulilinydja. ");
INSERT INTO gnn_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","Bala ŋayi Garraynydja waŋana bitjarrana, ‘Ŋarranydja dhuwala nhumalaŋgu Waŋarr God. Ŋäthilinydja nhuma ŋunhi ŋunhalanydja Yetjiptja wäŋaŋura garrpiṉarawuy nhinana yukurrana, yurru ŋarranydja nhumalanha dhawaṯmaraŋala warray beŋuruyi garrpiṉminyaraŋurunydja romŋuru, bala ŋarrapi yana waŋgany yurru nhumalaŋgu waŋarrnydja God. ");
INSERT INTO gnn_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","Yaka yana nhuma yurru buku‐ŋal'yun yukurra wiripuŋuwunydja ŋula waŋarrwu malaŋuwu rrambaŋikumanydja ŋarrakunydja. ");
INSERT INTO gnn_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","9","Yaka djäma ŋula nhä djiwarr'wuynydja yolŋunha wo dhiyakuy munatha'wuy wäyin ŋula nhä, ga yaka ḻakaraŋa ŋula nhä maḏayin' ŋunhi goŋbuynydja djämawuy. Yaka yana buku‐ŋal'yurra ŋula nhäkunydja goŋbuywu djämawuywu, liŋgu ŋarrapi dhuwala waŋgany nhumalaŋgu waŋarrnydja; nhumanydja dhuwala ŋarrakuway yana waŋganygu. Ŋuli nhuma yurru malthun wiripuŋuwunydja waŋarrwu, ga nhina ŋula wiripuŋuŋuranydja ŋula nhäŋuranydja romŋura, ga ŋuriŋiyinydjayi nhenydja yurru galŋa‐yätjthirrina wal'ŋu, ga bitjandhi nhuŋu yurru djamarrkuḻiny'tja ga gutharra'mirriŋu walala galŋa‐yätjthirriyi yana, liŋgu ŋuriŋiyi nhokala yätjthu ŋunhi nhe bitjarrayi buku‐nherrara ga ŋuyulkthina ŋarraku. ");
INSERT INTO gnn_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","Yurru ŋunhinydja walala ŋunhi walala yukurra märr‐ŋamathirri wal'ŋu märryu‐ḏapmarama ŋarranha, ga dhäruk märrama ŋarranha, walala yurru ŋunhiyinydja yolŋu walala nhina yukurra ŋarrakalana ŋarambiya'ŋura wal'ŋu ga nyeyalŋura, walalawuy ga walalaŋguŋu mala‐wunhara. ");
INSERT INTO gnn_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","“‘Yaka warku'yurra yäku Garraynha yänanydja, liŋgu ŋayi Godthunydja yätj‐ḻakaramayi yurru ŋunhinhanydja yolŋu'‐yulŋunha ŋunhi walala yurru yäku‐ḻakarama ŋanya yäna wakalkuma. ");
INSERT INTO gnn_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","“‘Ŋuriŋinydjayi waluyu Godkalanydja nhanukalaynydja nhe yurru ḏaḏawyurra warrpam'thurra nhäŋuru malaŋuŋuru djämaŋuru, liŋgu ŋunhiyinydjayi walu dharrpalnha gal'ŋu, gäna yana nhanŋuway ganaŋ'thun yukurra. Ŋuriŋiyinydjayi waluyu nhe yurru nhina yukurra yana mukthun djämamiriw, buku‐ŋal'yun nhanŋuway Godku yurru, liŋgu ŋunhiyinydjayi rom nherraṉara nhanukuŋuwaynha yana Godkuŋuna. ");
INSERT INTO gnn_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","14","Wiripu ŋunhiyi walunydja malanha ḏämbumirri ga waŋgany bäythinyara, ŋunhiyi malanha djämawunydja walu, ga wiripunydja ŋunhinydja, ŋunhinydja nhanŋuwaynha wal'ŋu dhulŋuŋuna walu Garraywuna Godkuna. Nhuma yolŋu walala ga djamarrkuḻi' nhumalaŋgu ga wäyin walala, yaka nhuma yurru yukurra djäma ŋuriŋiyinydjayi dhulŋuŋuyunydja waluyu; nhumapi ga djämamirri walala nhumalaŋgu yurru nhinana yukurra ganydjarrnha yana yurru. ");
INSERT INTO gnn_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","Guyaŋiya ŋunhi, ŋunhi nhuma ŋäthili djämamirri walala ŋuriki Yetjippuyŋuwu buŋgawawu walalaŋgu, ga ŋayi Godthunydja ŋayipinydja nhumalanha dhawaṯmaraŋalana ŋuliŋuruyi nhanukalaynydja ŋayi goŋdhu. Ga dhiyakuyina ŋunhi märrwu ŋayi Godthu gurrunharanydja dhuwalayi romdja ŋunhi, ŋunhi nhe yurru nhina yukurra ganydjarr ŋuriŋiyinydjayi waluyu, buku‐ŋal'yun yana nhanŋuwaynha. ");
INSERT INTO gnn_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","“‘Biyaka märr‐ŋal'yurra nhokalaŋuwala bäpa'mirriŋuwalanydja ga ŋäṉḏi'mirriŋuwalanydja. Garrayyu muka dhuwalayinydja ŋunhi nherrara rom nhumalaŋgu, ga ŋuli nhe yurru dhäruk märramanydja ŋäṉḏi'mirriŋunha ga bäpa'mirriŋunha, nhenydja yurru nhina ŋamathamana dhikana wal'ŋu, märr‐weyinnha nhe yurru nhina yukurra ŋunhiliyinydjayi wäŋaŋura ŋunhi ŋayi Godthu wekaŋala nhumalaŋgu. ");
INSERT INTO gnn_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","“‘Ga dhuwala wiripunydja rom gam', yaka buŋa wiripuŋunha yolŋunha, ");
INSERT INTO gnn_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","ga yaka marramba'thiyanydja, ");
INSERT INTO gnn_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","ga yaka manaŋiyanydja, ");
INSERT INTO gnn_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","ga bothiyanydja ḻakaraŋa ŋula yolnha yolŋunha, ");
INSERT INTO gnn_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","ga mel‐ŋamathiyanydja ŋula wiripuŋuwa yolŋuwa miyalknha ga wäŋa, wo wäyin, wo nhä malanha ŋunhi nhanŋuway ŋurikiyi, yaka ŋunhiyinydjayi mel‐ŋamathiya nhuŋuwaynydja nhe.’ ");
INSERT INTO gnn_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","“Yo, ŋayipi yana Garray waŋananydja bitjarrayi nhumalaŋgalaŋuwu miṯtjiwunydja ŋunhala muka ŋunhi bukuŋura, ŋayi waŋananydja ŋulawitjarra gurthakurru ga waŋupini'kurru ga warumukkurru, yurru nhanŋu ŋunhi rirrakaynydja wirrkina wal'ŋu maḻŋ'thurruna. Ga bitjarrayi liŋgu ŋayi wukirriyi guṉḏalili bilkpilklilinydja maṉḏanyŋulili märrma'lili, bala wekaŋalana ŋarrakala.” Ga bitjarrayi Mawtjitj waŋananydja. ");
INSERT INTO gnn_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","Ga bitjarra ŋayi wiripunydja Mawtjitjthu ḻakaraŋala, “Nhumanydja nhäŋala muka ŋunhiyi bukunha wäŋanha, ŋunhi ŋayi ḻiw'maraŋala ŋuriŋi Garraywala gurthayu, ga liŋgu muka nhuma ŋäkula ŋanya rirrakaynydja Garraynha waŋanharanydja, ŋunhi ŋayi waŋana beŋuru ḏikmandjaŋuru waŋupini'ŋuru, ga rulwaŋdhurruna ŋayi ŋunhiyi rom malanha. ");
INSERT INTO gnn_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","Ga nhumanydja ŋunhi ŋurru'‐ŋurruŋu yolŋu walala marrtjina, ga waŋana ŋarranha bitjarra, ‘Way, Godtja dhuwala ŋilimurruŋgala milkunhaminana ŋayi; ŋayinydja ŋunhi ḻatju' warray, dhika warray wal'ŋu, biyapul warray bathala, ganydjarr‐ḏumurru warray. Ŋäkula ŋanya ŋanapurru rirrakaynydja ŋunhi ŋayi yukurrana waŋana ŋuliwitjarrayi gurthakurru. Yo, waŋananydja ŋayi ŋilimurruŋgala, ga dhuwala warray ŋilimurru yulŋunydja, baḏak walŋamirri warray. ");
INSERT INTO gnn_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","26","Yurru ŋanapurru dhuwala beyaṉiyinana yulŋunydja. Mak ŋanapurrunydja yurru dhuwala murrmurryunna ŋunhi ŋayi yurru biyapulnydja waŋa ŋanapurruŋgala Garray, liŋgu Godtja ŋunha ŋayipinydja ḏarrtjalk wal'ŋu, garrkuḻuk yana ga ganydjarr‐ḏumurru; bukmak yurru ŋunhi nhä malanha munatha'wuy baḏuwaḏuyun warrpam'thunna ŋuriŋiyi nhanukalay ŋayi dhärukthunydja.’ ");
INSERT INTO gnn_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","Bala walala yukurrana waŋana ŋunhi yolŋu'‐yulŋunydja bitjarrana, ‘Nhe yurru marrtji Mawtjitj ŋe', ga ŋäka ŋanya dhäruk Godnha, bala nhe yurru ḻakaramanydja nhena ŋanapurruŋgalanydja dhäruktja ŋanya. Ŋanapurrunydja yurru ŋäma yukurra nhokuŋuna dhurrwarawuy ḻakaranhara, bala ŋanapurru yurru djämana yana.’ Ga bitjarra ŋunhi walala yukurrana ŋurru'‐ŋurruŋunydja waŋana ŋarrakala. ");
INSERT INTO gnn_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","“Ga ŋayi ŋunhi Godthunydja ŋäkula nhumalanha, ŋunhi nhuma yukurrana dhawu'‐nherrara waŋana bitjarrayi, bala ŋayi Garraynydja waŋana bitjarrana ŋarrakala, ‘Ŋäkula ŋarra liŋgu ŋunha yolŋu'‐yulŋunhanydja waŋanharanydja yukurranhara. Yuwalk walala ŋunha dhunupa waŋananydja bitjarrayi. Yuwalk yana ŋarra dhuwala yulŋunydja ḏarrtjalk wal'ŋu gäna ŋarrapi, ganaŋ'thun yukurra yätjŋuru. ");
INSERT INTO gnn_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","Ŋarra djäl walalaŋgu walala yurru bitjan liŋgu yukurra borrk‐beyaṉiyirri yulŋunydja ŋarraku, märr yurru walala yakana djäma ŋula nhä djarrpi'kumanydja. Ŋarranydja ḏukṯuk walalaŋgu walala yurru mukthun yana ŋayathama yukurra ŋarraku romdja malanha, märr yurru walala ga walalaŋgu yumurrku' yukurra nhina goŋmirriyirri dhika wal'ŋu, ŋayaŋu‐djulŋithirri gupaḏalkumana‐wala. ");
INSERT INTO gnn_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","Yo, yänguŋana walalanha, walala yurru marrtji bala roŋiyirri wäŋalili walalaŋgalay, ");
INSERT INTO gnn_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","ga nhenydja yurru Mawtjitj ga dhiyala bäyma nhina ŋarrakala, märr ŋarra yurru romdja malanha ḻakarama ŋunhi nhokalana. Nhena yurru ḻakarama ŋuripa yolŋu'‐yulŋuwanydja, bitjan marŋgikumanydja marrtji walalanha, märr yurru walala yukurra nhina ŋunhili liŋgu yana ŋarrakalay romŋura. ");
INSERT INTO gnn_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","Djämanydja nhuma yurru bukmak yana ŋunhiyi liŋgu ŋunhi ŋarra ḻakaraŋala nhumalaŋgu, ga yaka meṉguŋa ŋula waŋganydja rom. Yaka marrtjiya gatjpaḻ'yurranydja, bilyurra ŋula wiripuŋulilinydja dhukarrlili. ");
INSERT INTO gnn_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","Ŋunhi nhuma yurru ŋayathama baṯ bitjandja ŋarrakuwaynydja ŋunhi romnha warrpam'tja yana, nhumanydja yurru nhina yukurra walŋana yanana; märr‐weyinnha nhuma yukurra yurru nhina ŋunhilinydja wäŋaŋura ŋunhi ŋarra nhumalanha wekaŋala.’” Ga bitjarrayina ŋayi yukurrana Garrayyu ḻakaraŋalanydja Mawtjitjkala. ");
INSERT INTO gnn_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","“Yo, Godthu yana ŋayipi Waŋarryu wekaŋalanydja dhuwalayi romnhanydja, märr yurru nhuma dhäruk‐märrama ŋanya, ga nhina ŋunhiliyi liŋgu romŋura. ");
INSERT INTO gnn_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","Bitjan liŋgu nhuma yurru borrk‐beyaṉiyirri Garraywunydja, ga ŋayathama yana romdja nhanŋu baṯ bitjan, nhuma ga gäthu'mirriŋuyu walalay nhumalaŋgala ga gutharra'mirriŋuyu walalay. Gupaḏalnha‐yana nhuma yurru‐wala nhinanydja yukurra ŋunhili liŋgu nhanukalay romŋuranydja, märr yurru nhuma bitjan liŋgu nhina yukurra walŋa. ");
INSERT INTO gnn_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","Ŋuli nhuma yurru ŋäma Godnha dhäruk, ga djäma yukurra nhanŋu ŋunhiyi rom, nhumanydja yurru nhina ŋamathamana dhikana wal'ŋu, ga miṯtjinydja yurru ŋunhiyi ŋuthandja biyapul'nha wal'ŋu miṯtji, ga nhinanydja nhuma yukurra yurru ŋunhilinayi ŋatha‐guḻku'mirriŋura wäŋaŋura ŋunhi ŋayi Garrayyu nhumalaŋgala Godthu dhawu'‐nherrara nhumalaŋgalaŋuwala märi'muwala. ");
INSERT INTO gnn_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","“Ŋäka walala ŋi' yolŋu walala ŋarraku. Godtja dhuwala waŋgany yana, Garray ŋayi wal'ŋu. ");
INSERT INTO gnn_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","Nhuma yurru warrpam'thun yana märr‐ŋamathirrinydja märryu‐ḏapmarama Garraynha, ŋayaŋuyu nhokalay ga ḻiyayu nhokalay ga ganydjarryu. ");
INSERT INTO gnn_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","7","Märraŋa dhuwalayi romdja malanha ga ŋayathaŋanydja baṯ biyaka ŋuruŋu ŋayaŋuyu nhokalay nhe, ga marŋgikuŋa biyaka marrtjiya nhumalaŋguway djamarrkuḻi'nhanydja. Waŋanhamiya biyaka yukirriya ŋunhi nhuma yukurra yurru nhina wäŋaŋuranydja nhumalaŋgalay, ga biyakayi liŋgu ŋulinyaramirriyunydja ŋunhi nhuma yurru yukurra marrtji dhukarr ŋupan. Guyaŋiyanydja yana ṉiṉ'thurra yukirriya dhuwalayi dhäruktja ŋarranha ŋunhi nhe yurru ḻäy‐ŋorranydja, ga biyakayi yana liŋgu ŋunhi nhe yurru gaŋgathirri beŋuru. ");
INSERT INTO gnn_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","9","Ŋayathaŋa baṯ biyaka yana ŋarraku dhäruktja warrpam'thurra yana, ga wukirri biyaka dhurrwaralili nhokalay nhe wäŋalilinydja, märr yurru nhe yaka meṉguma ŋula waŋganydja. ");
INSERT INTO gnn_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","11","“Yo, ŋayi yurru Garrayyunydja gämana marrtji nhumalanha ŋunhimalayinayi wäŋalili ŋunhi ŋayi wäŋanydja ŋunhiyi dhawu'mirriyaŋala nhumalaŋgalaŋuwala märi'muwala, Yipurayimgala ga Yitjakkala ga Djaykupkala. Ŋunhayinydja manymaknha dhikana wal'ŋu wäŋa, buṉbu mäypamirri dhika, ga guḻku'na mirithirrina yurru ŋathanydja ŋunhiliyi wäŋaŋura nhumalaŋgu ḻukanharawunydja, nhuma yurru yana märr‐ḏaw'yun ŋuriŋiyi maranhuyunydja. ");
INSERT INTO gnn_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","Yurru yaka yana meṉguŋanydja Garraynha, liŋgu ŋayipi nhumalanha beŋurunydja märraŋala miriŋuwalanydja goŋŋuru, ŋunhi nhuma yukurrana ŋäthili nhinana ŋunhili garrpiṉminyarawuyŋura romŋura. ");
INSERT INTO gnn_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","Biyaka borrk‐beyaṉiyiya yulŋunydja nhokalaŋuwu ŋunhi Godkunydja, ga mukthurra‐wala yana djäma yukirriya nhanŋu Garraywu; nhanukala yana waŋganygala yäkuyu nhuma yurru dhawu'‐nherraṉmirrinydja. ");
INSERT INTO gnn_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","15","Ŋunha wiripu‐guḻkuny'tja yolŋu walala ŋuli buku‐ŋal'yun yukurra wiripuŋuwu warray waŋarrwu, yurru nhumanydja dhuwala dhulŋuŋu warray, nhanŋuway warray gal'ŋu. Ŋuli nhe yurru märr‐nherraṉmirri wiripuŋuwalanydja waŋarrwala, ŋayinydja nhuŋu yurru Garraynydja ŋaramurryirrina, bitjanna ŋayi yurru bitjan ŋuli dhuway'mirriŋuyu mel‐ḏi'yun ŋunhi ŋayi yurru dhäykayu nhanukala märrama wiripuŋunha ḏarramunha, bitjandhina ŋayi yurru yulŋunydja. Yo, Garray Godtja dhuwala ṉapuŋga bäyma. Ŋuli nhuma yurru buku‐ŋal'yun ŋula wiripuŋuwu waŋarrwu, ŋayi yurru nhumalanha baḏuwaḏuyunna bitjanna, yakana biyapulnydja nhuma yurru yukurra nhina dhiyala munatha'ŋuranydja weyin. ");
INSERT INTO gnn_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","“Yaka biyakayi biyapulnydja gatjarr'yurra Garraynha, bitjarra nhuma yukurrana gatjarr'yurruna ŋanya ŋunhala Matja wäŋaŋura. ");
INSERT INTO gnn_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","18","Yana biyaka ŋayathaŋa baṯ biyakana nhanŋu romdja, ga dhäruk märraŋa ŋanya. Djäma biyaka ḻatju'kuŋa dhunupa wal'ŋu ŋunhiyi yana liŋgu rom malanha ŋunhi ŋayi yukurra Garrayyu ḻatju'‐ḻakarama dhika wal'ŋu, bala yurru nhuma ŋunhi gulŋiyirrinydja ŋunhiwala wäŋalilinydja, ŋunhiwalayi ŋunhi ŋayi Garrayyu dhawu'mirriyaŋala ŋäthili nhumalaŋgu. ");
INSERT INTO gnn_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","Yanana nhuma yurru gukumana ŋunhiyi miriŋunhanydja walalanha ŋunhi walala yukurra wäŋaŋura ŋuli nhina ŋunhiliyi, ŋurrkamana nhuma yurru walalanha warrpam'thunna, bitjanna bitjan ŋunhi ŋayi Garrayyu waŋana ḻakaraŋala. ");
INSERT INTO gnn_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","“Yalalaŋumirrinydja nhumalaŋgala yurru djamarrkuḻi'yu dhä‐wirrka'yun nhumalanha bitjan, ‘Nhäku warray ŋayi ŋunhi Garrayyu ŋilimurruŋgala waŋarryu nherrara dhuwalayinydja rom?’ ");
INSERT INTO gnn_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","Ga nhumanydja yurru waŋa ḻakarama bitjan walalambala, ‘Ŋäthilinydja ŋunhinydja ŋilimurrunydja ŋuli yukurranha nhinanha garrpiṉara muka ŋunhala Yetjiptja, garrpiṉara ŋilimurru yukurrana nhinana ŋurukala buŋgawawala ganydjarryu, ga ŋayinydja Godthunydja ŋilimurrunha bitjarra dhawaṯmaraŋalana ŋuriŋi nhanukalanydja ŋayi bathalayunydja ganydjarryu. ");
INSERT INTO gnn_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","Ŋilimurru nhäŋala ŋunhi ŋayi Garrayyu mirithirri wal'ŋu ganydjarr‐ḏumurru djäma, ŋayi warrpam'thurruna baḏuwaḏuyurruna ŋunhiyi miriŋunhanydja ŋilimurruŋgala maŋutjimara yana. ");
INSERT INTO gnn_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","Dhawaṯmaraŋala ŋayi ŋilimurrunha ŋuliŋuruyi miriŋuwalanydja goŋŋuru, märr yurru ŋayi wekama ŋilimurruŋgu ŋunhiyi manymak wäŋa, ŋunhi ŋayi dhawu'‐nherrara ŋilimurruŋgalaŋuwala märi'muwala. ");
INSERT INTO gnn_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","Garrayyunydja ŋilimurruŋgala ḻakaraŋala ŋilimurru yurru ŋayathama baṯ bitjan yana romdja malanha nhanŋu. Yo, ŋali yurru rom‐wiyaṉiyirri Godkunydja, ga yaka nhanŋu ŋapanydja‐wekama, märr ŋayinydja yurru ŋitjalanha Godthunydja bitjan goŋmirriyama wal'ŋu, ga nhinanydja ŋali yurru yukurra walŋana dhikana galŋa‐djulŋithirrina nhanukala ŋarambiya'ŋura. ");
INSERT INTO gnn_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","Ŋunhi ŋali yurru dhäruk‐märramanydja nhanŋu dhäruk warrpam'tja gal'ŋu, ga yakanydja meṉguma ŋula waŋgany, ga ŋayipinydja yurru ŋitjalanha Godthunydja ḻakarama ŋayaŋu‐dhunupana, bala ŋayi yurru goŋmirriyamana ŋitjalanha wal'ŋu.’ Bitjandhina nhuma yurru yukurra ḻakarama nhumalaŋgalaŋuwa yumurrku'wanydja.” ");
INSERT INTO gnn_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","“Yo, ŋayi yurru Godthunydja gämana nhumalanha ŋunhimalayina wäŋalili ŋunhi ŋayi dhawu'‐nherrara nhumalanha nhanŋuway ŋunhi yolŋu'‐yulŋunha, bala wäŋanydja ŋunhiyi yurru nhumalaŋguway yana, yurru ŋäthilinydja nhuma yurru gukuma ŋunhiyi wiripu‐guḻku'nhanydja yolŋunha walalanha, ŋunhi walala ŋuli yukurra nhina ŋunhili wäŋaŋura. Ŋunhiyi wiripu‐guḻku' yolŋu walala biyapulnha wal'ŋu yätjmirrina yanana, ga ḏälmirrina, djuḻkmaramana yukurra buluna gal'ŋu nhumalanhanydja, yurru nhumanydja yurru gukuma warray walalanha, yana dhawaṯmaramana walalanha ŋuliŋuruyi yurru, liŋgu Garrayyu nhumalaŋgalanydja Godthu yurru wekama walalanha nhumalaŋgalana goŋlili, bala nhuma yurru baḏuwaḏuyunna yana walalanha. ");
INSERT INTO gnn_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","Yo, nhuma yurru baḏuwaḏuyundja walalanha warrpam'thunna yana wal'ŋu; yakana yurru yana walala ŋunhiyi yolŋu walala nhina nhumalaŋgala galki, ŋunhi walala yaka nhina yukurra Godkala romŋura. Yaka waŋgany‐manapanmiya walalaŋgalanydja, ga yaka walalaŋgu biyaka mel‐wuyurranydja, yana nhuma yurru walalanha warrpam'thun baḏuwaḏuyundja, märr yurru walala yaka muka nhumalanha gäma yätjlilinydja. ");
INSERT INTO gnn_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","4","Nhumalaŋgala gäthu'mirriŋuyu walalay yurru yaka märrama dhäykanha ŋuliŋuruyi malaŋuru, ga yaka wekaŋa nhuŋuway miyalknha gäthu'mirriŋunha walalaŋgalaŋuwu ḏarramuwurruŋgu, märr yurru walala yaka bilmarama nhumalaŋgu yumurrku'nha gatjpaḻ'marama wiripuŋulili dhukarrlili. Ŋuli nhumalaŋgala yurru djamarrkuḻi'yu meṉguma ŋarranhanydja, ga märr‐nherraṉmirri wiripuŋuwalanydja waŋarrwala, bala ŋarranydja yurru ŋunhi ŋaramurryirrina yanana, ga waḏutja yana ŋarra yurru baḏuwaḏuyundja warrpam'thun dhawar'marama walalanha.” Bitjarra ŋayi Garray waŋananydja. ");
INSERT INTO gnn_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","“Yaka yana walala märr‐ŋal'yurra wiripuŋuwunydja waŋarrwu, yana nhuma yurru ḏaw'‐ḏawyurrana marrtjiya ŋunhiyi walalaŋgu waŋarrnhanydja malaŋunha, ga ŋunhiyi buku‐ŋal'yunarawu nhuma yurru ḏaw'‐ḏawyurra biyakana muṉguykuŋana warrpam'thurrana. Gulk‐gulkthurrana biyakana ŋunhiyi dharpanhanydja malaŋunha ŋunhi walala ŋuli nherra'‐nhirraṉ buku‐ŋal'yunarawu, ga dhuŋgur'yurrana dhika nhänydja malanha maḏayin'tja girri'ŋunhi walala yukurra waŋarr‐ḻakarama. ");
INSERT INTO gnn_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","Warrpam'thurrana yana baḏuwaḏuyurranydja, liŋgu nhumanydja dhuwala nhanŋuwaynha yana dhulŋuŋuna Godkuna yolŋu walala. Ŋayi nhumalanha ganaŋ'maraŋalanydja nherrara ŋuliŋuruyi nhäŋuru malaŋuru, märr yurru nhumanydja nhanŋuwaynha wal'ŋu yanana, ŋunhi ŋayi Garray Waŋarr nhumalaŋgu. ");
INSERT INTO gnn_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","8","Guḻku' dhuwali yulŋunydja miṯtjinydja yolŋunydja walala yukurra nhina ḻiw'marama wäŋakurrunydja, yurru nhumalanhawuy yana waŋganynha ŋayi Godthu djarr'yurrunanydja, bala nhanŋuwayliliyaŋalana ŋayi, märr yurru nhumanydja nhanŋuwaynha wal'ŋu yanana dhulŋuŋuna. Nhumanydja dhuwalinydja miṯtji ḻurrkun' warray yana, yaka warray guḻku', yana ŋayi Godthu nhumalanha djarr'yurrunanydja ŋuriŋina liŋgu ŋunhi ŋayi märr‐ŋamathina yukurrana nhumalaŋgu wirrki. Ŋayi guyaŋina ŋunhiyi dhäruk ŋunhi ŋayi dhawu'mirriyaŋala be ŋäthili baman' nhumalaŋgu märi'munha, ga dhiyakuyina märrwu ŋayi nhumalanha dhawaṯmaraŋalanydja ŋunhi ŋuliŋuruyi, ŋunhi nhuma yukurrana nhinana garrpiṉara; ŋayi nhumalanha dhawaṯmaraŋalanydja beŋuruyi goŋŋuru buŋgawawalanydja Yetjippuyŋuwalanydja ŋuriŋiyi nhanukalay ŋayi ganydjarryu. ");
INSERT INTO gnn_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","Guyaŋiya ŋanya Waŋarrnha nhumalaŋguway Godnha, ŋunhi ŋayipi waŋgany yuwalktja wal'ŋu waŋarr; ŋayipi waŋganydhu ŋuli yukurra djäma ŋunhiyinydja ŋunhi ŋayi dhawu'‐nherrara. Bitjanna liŋguna yurru‐wala ŋayi yukurra märryu‐ḏapmarama yana ŋunhinhanydja yolŋu'‐yulŋunha ŋunhi walala yukurra ŋanya märryu‐ḏapmarama, ga ŋayathama nhanŋu rom yukurra; gupaḏalnha‐wala yana ŋayi yurru ŋunhinydja yolŋu dhäruk‐märranharamirrinydja nhina yukurra goŋmirrina dhikana wal'ŋu, ga bitjandhi liŋgu nhanŋu yurru yumurrku' ga gutharra'mirriŋu walala nhanŋu nhinanydja yukurra ŋunhili nhanukala Godkalanydja märr‐ŋamathinyaŋura. ");
INSERT INTO gnn_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","Yurru wirrki yana ŋayi yurru Godthu dhä‐ḏir'yundja ŋunhinhanydja yolŋunha walalanha ŋunhi walala yukurra nyinyaŋdhun nhanŋu ŋuyulkthirri; walalanhana ŋayi yurru buma baḏuwaḏuyundja waḏutjanydja yana. ");
INSERT INTO gnn_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","Dhiyakuyinayi märrwu nhuma yurru yukurra ŋayathama baṯ bitjanna ŋunhi romdja nhanukuŋu, ŋunhi ŋarra ḻakaraŋala nhumalaŋgu. Nhiniyanydja walala nhanukalay yana romdhunydja.” ");
INSERT INTO gnn_vpl VALUES ("DT7_12","006_7_12","DEU","7","12","12","“Yo, ŋunhi nhuma yurru ŋämanydja, bala dhäruktja märrama dhuwalayi malanha ŋunhi romdja nhanŋu Godku, bala ŋayinydja yurru nhumalanha Garrayyunydja goŋmirriyamana yana wal'ŋu, bitjan yana liŋgu bitjarra ŋayi dhawu'‐nherrara ŋäthili gal'ŋu; nhuma yurru yukurra nhinanydja ŋamathamana wal'ŋu nhanukalaynha märr‐ŋamathinyaraŋura. ");
INSERT INTO gnn_vpl VALUES ("DT7_13","006_7_13","DEU","7","13","13","Ŋayi yurru märr‐ŋamathirri nhumalaŋgu bitjan märryu‐ḏapmarama gal'ŋu, bala goŋmirriyamana nhumalanha, bala yana ŋayi yurru miṯtjinydja dhaŋaŋgumana marrtji, guḻku'kumana biyapulnha yurru. Ŋathanydja malanha yurru ŋuthanna marrtji, bena birrŋ'thunna yurru dhiyala munatha'ŋuranydja, ga biyapulnha yurru wäyindja guḻku'thirri marrtji nhumalaŋgu ḻukanharawunydja. ");
INSERT INTO gnn_vpl VALUES ("DT7_14","006_7_14","DEU","7","14","15","Yakana yurru nhumalaŋgu dhäykawurru ga ḏarramuwurru bitjan yothumiriwyirrinydja, ga bitjandhi liŋgu ŋayi yurru Garrayyu djaw'yundhi rerrinydja nhumalaŋgalaŋuŋuru, gukumana yurru ŋayi, yakana nhuma yurru yukurra rirrikthun birrka'mirriyu nhäyu malaŋuyu rerriyu. Ŋunhi yurru nhumalaŋgu miriŋu walala rirrikthunmirrinydja ŋunhi nhumalaŋgu walala yukurra ŋoy‐ŋorra, yurru nhumanydja ḏäwalamirri warray yurru nhina yukurra. ");
INSERT INTO gnn_vpl VALUES ("DT7_16","006_7_16","DEU","7","16","16","Ŋayipinydja yurru Garrayyunydja goŋ‐wekama nhumalaŋgala ŋunhiyi yätjmirrinhanydja yolŋu'‐yulŋunha, bala nhuma yurru baḏuwaḏuyunna walalanha, warrpam'thunna yulŋunydja. Yaka walalaŋgu mel‐wuyurranydja, ga yaka walalaŋgalaŋuwu waŋarrwunydja märr‐ŋal'yurra, liŋgu ŋuliwitjandhinydjayi romgurru nhumalanha yurru gaṯmaramana, ga ŋuriŋi walalaŋgala dhuwurryu yätjthu nhumalanha yurru buwayakkumana baḏuwaḏuyunna. ");
INSERT INTO gnn_vpl VALUES ("DT7_17","006_7_17","DEU","7","17","17","“Yaka nhäŋa walalanha barrarimirriyunydja ga waŋiya biyakanydja, ‘Way walalanydja ŋunha miṯtji guḻku' warray, ḏälmirri warray gal'ŋu ŋilimurruŋgalanydja. Nhaltjanna yurru ŋilimurru walalanha gukumanydja dhika.’ ");
INSERT INTO gnn_vpl VALUES ("DT7_18","006_7_18","DEU","7","18","18","Yaka biyakayinydja waŋiya, ga yaka barrariya walalaŋgu, yana guyaŋiya ŋanyapinyay Godnha, nhaltjarra ŋunhi ŋayi baḏuwaḏuyurruna ŋunhiyi Yetjippuyŋunha buŋgawanha, ga bukmaknha nhanŋu miṯtjinha. ");
INSERT INTO gnn_vpl VALUES ("DT7_19","006_7_19","DEU","7","19","20","Liŋgu muka nhuma nhäŋala ŋanya Godnha yulŋunydja, ŋunhi ŋayi ŋarambiya' ŋaḏupthurruna, bala djämana ŋayi bathalana biyapulnha wal'ŋu rom. Nhuma marŋgi muka ŋunhi ŋayi dhawaṯmaraŋala nhumalanha ŋuliŋuruyi miriŋuwala goŋŋuru. Ŋayipi yurru Garrayyunydja barrari‐wukuma biyapul nhumalaŋgu ŋunhi miriŋunhanydja walalanha, märr yurru yakana ŋula waŋgany nhina yukurra djuḻuḻ'yundja; nhumanydja yurru yana walalanha warrpam'thunna baḏuwaḏuyundja. ");
INSERT INTO gnn_vpl VALUES ("DT7_21","006_7_21","DEU","7","21","21","Yaka walalambala biyaka barrariyanydja, liŋgu ŋayinydja Garraynydja nhumalaŋgala warray ŋunha gali'ŋura, ga ŋayi warray ŋunha biyapulnydja wal'ŋu ganydjarr‐ḏumurru. ");
INSERT INTO gnn_vpl VALUES ("DT7_22","006_7_22","DEU","7","22","22","Yo, yaka yana ŋayi yurru walalanha dhawaṯmarama waḏutjanydja, bitjan bili ŋayi yurru mitjpili' ga mitjpili' bala marrtji walalanha gukumanydja waṉḏinyamaramanydja, märr yurru nhumanydja marrtji gaŋdhunmarama ŋunhiyi wäŋanhanydja ŋamakurru'yu malaŋuyu bala yana. ");
INSERT INTO gnn_vpl VALUES ("DT7_23","006_7_23","DEU","7","23","23","Yo, ŋayi yurru Garrayyunydja barrari‐wukuma ŋunhinydja walalanha miriŋunhanydja nhumalaŋgu, yätjmirrinhanydja ŋunhinydja, gundupumana walala yurru yana nhumalaŋgala yulŋunydja, yana liŋgu ga warrpam'thun nhuma yurru baḏuwaḏuyun. ");
INSERT INTO gnn_vpl VALUES ("DT7_24","006_7_24","DEU","7","24","24","Yaka yurru ŋayi yukurra waŋgany ŋula ŋurruŋu wal'ŋu djingaryun ŋunhiliyinydja, ga yaka yurru ŋula waŋgany winya'yundja, yana nhuma yurru walalanha warrpam'thunna baḏuwaḏuyundja, ga yäkunydja walalanhawuy walala yurru yukurra meṉgunharamirrina. ");
INSERT INTO gnn_vpl VALUES ("DT7_25","006_7_25","DEU","7","25","25","Nhuma yurru gurthayuna yana dhuŋgur'yundja warrpam'thunna walalaŋgu waŋarrnhanydja walalanha, warrpam'thurrana yana wal'ŋu baḏuwaḏuyurrana winya'yunmaraŋana. Yaka djälthiya ŋuriki nhäku malaŋuwu be ŋamakurru'mirriwunydja, garwarrwarr'wunydja ga be nhäkunydja bulayiwu walalaŋgalaŋuwu waŋarrwunydja; nhumalanha ŋuli bäynha gaṯmaraŋu ŋuriŋiyinydja. Yo, waŋarryu nhumalaŋgala Godthunydja Garrayyunydja wirrki yana ŋayi yukurra nyamir'yun nyinyaŋdhundja ŋurikiyi maḏayin'kunydja malaŋuwu nhäkunydja, ŋunhi walala ŋuli yukurra ŋunhiyi yolŋu walala märr‐ŋal'yun ŋurikiyi. ");
INSERT INTO gnn_vpl VALUES ("DT7_26","006_7_26","DEU","7","26","26","Yaka nhumanydja yurru ŋayathama yukurra ŋunhiyi malanha maḏayin' malanha nhumalaŋgalay wäŋaŋuranydja. Ŋuli nhe yurru ŋayathamanydja ŋunhiyi be dhuyunydja girri' nhokalay nhe wäŋaŋura, bala ŋayinydja yurru Godthunydja nhuna yätj‐ḻakaramana, rrambaŋikumana ŋunhiyina malanha maḏayin'nha. Biyaka ŋuyulkthiyana ŋurikiyi ŋapana‐wekaŋa, liŋgu ŋayipinydja yukurra ŋunhi Garraynydja ŋuyulkthirri ŋurikiyi wirrki yana, warrpam'thunna yana ŋayi yurru baḏuwaḏuyundja ŋunhiyi malanha maḏayin'tja malanha.” ");
INSERT INTO gnn_vpl VALUES ("DT8_1","006_8_1","DEU","8","1","1","Yo, bitjarra ŋayi ŋunhi Mawtjitj yukurrana waŋananydja ḻakaraŋala, “Ŋayathaŋa baṯ biyaka Godkunydja rom malanha ŋunhi ŋarra ḻakarama yukurra nhumalaŋgu dhiyaŋu‐wala gäthura. Ŋuli nhuma yurru yuwalk gal'ŋu dhäruk‐märrama dhuwalayi, nhumanydja yurru nhina yukurra goŋmirriyirrina dhikana djulŋithirrina wal'ŋu ŋunhiliyinydja wäŋaŋura ŋunhi ŋayi Garrayyu dhawu'‐nherrara nhumalaŋgalaŋuwu märi'muwu. ");
INSERT INTO gnn_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","Yo, ŋunhalanydja ŋunhi ŋanhdharkŋuranydja nhuma yukurrana marrtjina bitjarra wirwiryurruna yukurrana weyinŋumirrina, 40‐na dhuŋgarranydja nhuma yukurrana ŋunhi nhinana, liŋgu ŋuliwitjarrayinydjayi ŋayi Garrayyunydja nhumalanha bitjarra dharraḏakuŋalana, märr yurru nhuma yaka guyaŋirri be yindikunharamirrinydja. Ŋayi gatjarr'yurruna nhumalanha, bitjarra ŋayi maḻŋ'maraŋala nhumalanha ŋunhi nhuma yurru dhäruk‐märrama ŋanya wo yaka. ");
INSERT INTO gnn_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","Yo, ŋayi dharraḏakuŋala nhumalanha, liŋgu nhuma wirrkina wal'ŋu ŋunhi marrya'yinanydja yukurrana ŋathawunydja ḻarruŋala, bala ŋayi nhumalanha wekaŋalana marrtjina ŋuriŋiyina ŋathayu manayuna, ŋunhiyi ŋatha djiwarr'wuynha. Yaka nhe ŋunhi marŋgi ŋäthilinydja ŋurikiyi ŋathawu, ga balanyarayi liŋgu nhumalaŋgu märi'munydja walala dhuŋamirriyi, yaka walala marŋgi ŋurikiyi; Godthu ŋayipi ŋunhiyi yänguŋalanydja nhumalaŋgu, märr yurru nhuma marŋgiyirri ŋunhi ŋayi yurru yakana ŋula yol yolŋu nhina walŋa ŋuriŋiyinydja ŋathayu munatha'wuyyunydja, yana ŋayi yurru yuwalktja nhina yukurra walŋanydja ŋuriŋina liŋguna dhärukthu ŋunhi Garray ŋayipi ŋuli waŋa. ");
INSERT INTO gnn_vpl VALUES ("DT8_4","006_8_4","DEU","8","4","4","Yo, ŋunhiliyi ŋanhdharkŋuranydja nhuma yukurrana nhinana weyinŋumirrina, weyinnha wal'ŋu, yurru yaka nhumalaŋgu marrtjina girriny'tja dhika nhänydja ŋäthiliŋuyina barr'‐barryurruna, ga djalkiri nhumalaŋgu yaka buḻ'‐buḻyurruna nhuma. ");
INSERT INTO gnn_vpl VALUES ("DT8_5","006_8_5","DEU","8","5","5","“Yo, yolŋuyunydja ŋuli ḏarramuyu bitjan raypirri'yun muka nhanŋuwaynydja ŋayi gäthu'mirriŋunha, märr yurru ŋayi yaka biyapul djäma yätj, ga bitjandhi liŋgu Garrayyunydja ŋuli marrtji raypirri'yundhi nhumalanha, märr yurru nhuma yaka djäma ŋula nhä nhokalay nhe djälyu. ");
INSERT INTO gnn_vpl VALUES ("DT8_6","006_8_6","DEU","8","6","6","Ga ŋurikiyinydja märrwu nhuma yurru rom‐wiyaṉiyirri bitjan nhanŋu Godkunydja, ga marrtji nhanukala yana romgurru; bitjan liŋgu nhe yurru ŋayathama yana ŋunhiyi romdja. ");
INSERT INTO gnn_vpl VALUES ("DT8_7","006_8_7","DEU","8","7","8","Liŋgu ŋayipinydja Garrayyunydja nhumalanha marrtji gäma ŋunhimalayi wäŋalili ḻatju'lili dhika wal'ŋu. Ŋunhilimiyi wäŋaŋuranydja gapu dhika ḻarryun yukurra ḏarrtjalk gal'ŋu ralkthunara, ga beŋuru ŋoyŋuru munatha'ŋurunydja gapu yukurra dhawaṯthun buŋbuŋdhun ḻatju' dhika wal'ŋu, ga manymak ŋatha yukurra ŋuthan mirithirri ga borum malanha ḻatju'mirri dhika, ga guku ga dhika nhä malanha ŋatha manymakmirri. ");
INSERT INTO gnn_vpl VALUES ("DT8_9","006_8_9","DEU","8","9","10","Bäyŋuna nhe yurru marrya'yirri yukurra ŋunhiliyinydja biyapulnydja, liŋgu ŋathanydja nhe yurru yukurra ḻuka dhaŋaŋnha, bala nhe yurru wokthunna Garraywunydja, ga nhina yurru yukurra galŋa‐djulŋithirrina ŋunhilimi wäŋaŋura ŋunhi Garrayyu wekaŋala nhumalaŋgu.” ");
INSERT INTO gnn_vpl VALUES ("DT8_11","006_8_11","DEU","8","11","11","“Yaka yana meṉguŋanydja ŋanya Garraynhanydja nhumalaŋgu waŋarrnhanydja. Biyaka dhäruktja ŋanya märraŋa, ga ŋayathaŋa baṯ biyaka warrpam'thurra yana nhanŋu romdja malanha, ga yaka meṉguŋa ŋula waŋganydja. ");
INSERT INTO gnn_vpl VALUES ("DT8_12","006_8_12","DEU","8","12","13","Yo, ŋunhilinydjayi wäŋaŋura nhuma yukurra yurru nhina ŋatha‐guḻku'mirriŋurana dhika, ga nhinanydja nhuma yukurra yurru manymakŋura dhika buṉbuŋura malaŋuŋura, ga bitjandhi liŋgu nhuma yurru yukurra ŋayathama wäyindja malanha mirithirrina guḻku'na ga rrupiya ga ŋula nhä malanha girri'. ");
INSERT INTO gnn_vpl VALUES ("DT8_14","006_8_14","DEU","8","14","14","Yurru yaka yana nhe yurru biyaka garrwarkunharamiyanydja guyaŋinyamiya nhunapinyay nhe, bala meṉguŋana Garraynhanydja, ŋunhi ŋayi nhuna dhawaṯmaraŋala beŋuruyi garrpiṉminyaraŋuru romŋuru. ");
INSERT INTO gnn_vpl VALUES ("DT8_15","006_8_15","DEU","8","15","15","Ŋayipi muka ŋunhi Godthu Garrayyu nhuna gäŋalanydja yukurrana bitjarra walŋakuŋalanydja ŋuliwitjarra ŋanhdharkkurrunydja lili. Yaka nhuna moḻ'ŋuyu ga buthuŋuyu ŋula ḻäwuŋalanydja nhumalanha, ga Godthu nhumalanha wekaŋala gapu ŋunhiliyi ŋanhdharkŋura wäŋaŋura baṉḏany'ŋura, ŋunhi ŋayi yukurrana ḻarryurruna beŋuru guṉḏaŋuru. ");
INSERT INTO gnn_vpl VALUES ("DT8_16","006_8_16","DEU","8","16","16","Ga bitjarrayi liŋgu ŋayi Garrayyu nhumalanha wekaŋalanydja ŋuriŋiyinydjayi ŋathayu manayunydja. Yo, märi'munydja nhumalaŋgu ga dhuŋamirrina gal'ŋu yana, yakana walala marŋgi nhanŋu Garraywu, yana bitjarra ŋayi Garrayyunydja nhumalanha gatjarr'yurruna yukurrana, märr yurru ŋayi nhumalanha wurrkurrum'kuma dharraḏakuma, liŋgu ŋayinydja ḏukṯuk nhumalaŋgu ŋayi yurru gäma nhumalanha ŋunhiwalayi manymaklili wäŋalili. ");
INSERT INTO gnn_vpl VALUES ("DT8_17","006_8_17","DEU","8","17","17","Ga ŋunhi nhuma yukurra yurru nhina dhä‐ŋonuŋdja ŋunhili wäŋaŋura, yaka waŋiya biyakanydja, ‘Way, ŋarranydja dhuwala ḻukunydjana. Ŋarra yukurrana ŋayathaŋala ga märraŋala dhuwalanydja nhä malanha ŋarrakalay ŋarra yana ganydjarryu.’ ");
INSERT INTO gnn_vpl VALUES ("DT8_18","006_8_18","DEU","8","18","18","Yaka biyakayinydja waŋiya, yana guyaŋiya biyakana ŋunhiyinayi Godnha, ŋunhi ŋayi muka ŋuli yukurra nhumalanha ganydjarr wekamanydja, märr yurru nhuma nhina yukurra ḻukunydja dhika wal'ŋu, liŋgu guyaŋirrinydja ŋayi yukurra ŋunhiyi dhawu' ŋunhi ŋayi nherrara nhumalaŋgalaŋuwala märi'muwala walalaŋgala be ŋäthili. ");
INSERT INTO gnn_vpl VALUES ("DT8_19","006_8_19","DEU","8","19","19","Yo, ŋuli nhuma yurru buku‐dhumukthirrinydja meṉgumanydja Godnha, ga malthun ŋula wiripuŋuwanydja waŋarrwa, nhenydja yurru rakunydhirrina. Yuwalk yana ŋarra nhumalanha yukurra dhuwala raypirri'yundja waŋa. Ŋuli nhuma yurru ganandja ŋunhi yuwalkŋunhanydja Garraynha, ga märr‐nherraṉmirri be ŋula yolkalanydja waŋarrwala, bala nhumalanha yurru baḏuwaḏuyunna yana warrpam'thunna ŋula nhäyuna malaŋuyu romdhu. ");
INSERT INTO gnn_vpl VALUES ("DT8_20","006_8_20","DEU","8","20","20","Ŋunha wiripu‐guḻkuny'tja yolŋu walala miṯtji ŋuli buku‐ŋal'yun yukurra wiripuŋuwuna waŋarrwu, bala ŋayi ŋuli Godthunydja yukurra baḏuwaḏuyunna walalanha warrpam'thunna yana, ga nhumalanhanydja yurru bitjandhi liŋgu baḏuwaḏuyundhi warrpam'thun yana, ŋuli nhuma yurru yakanydja dhäruk‐märrama Garraynha nhumalaŋgu Waŋarrnha, ŋunhi ŋayi yurru waŋanydja nhumalaŋgu.” ");
INSERT INTO gnn_vpl VALUES ("DT9_1","006_9_1","DEU","9","1","1","“Mäkiri'‐witjurra nhuma yolŋu'‐yulŋu Yitjuralpuyŋu. Galki nhuma yurru dhuwala buḏapthunna yulŋunydja mayaŋ'kuna, bala gulŋiyirrina yana ŋunhiwalayinydja wäŋalili ŋunhi walala yukurra ŋayathama ŋarambiya'yu walalaŋgalay ŋunhi wäŋa. ");
INSERT INTO gnn_vpl VALUES ("DT9_2","006_9_2","DEU","9","2","2","Ŋunhayinydja yolŋu'‐yulŋu mirithirrina wal'ŋu ḏälmirrina nhumalaŋgalanydja, yakana nhuma yurru djuḻkmarama walalanha wo buma nhuma yurru baḏuwaḏuyun walalanha nhokalaynydja nhe ŋuriŋi ganydjarryu. ");
INSERT INTO gnn_vpl VALUES ("DT9_3","006_9_3","DEU","9","3","3","Yurru Garraynydja ŋayipinydja yurru marrtji yukurra ŋurruŋu bala nhumalaŋgalanydja, bitjan yurru bitjan gurtha ŋuli nhära marrtji, biyapul gal'ŋu bathala, bitjandhina ŋayi yurru marrtji ŋayipina baḏuwaḏuyun walalanha, ŋunhi nhuma yurru marrtji galkithirrinydja. Bala nhuma yurru ŋupanna walalanha, gukumana ŋuliŋuruyinydja wäŋaŋuru, waḏutjana yana nhuma yurru baḏuwaḏuyundja walalanha, bitjanna yana liŋgu ŋunhi ŋayi Garrayyu dhawu'mirriyaŋala. ");
INSERT INTO gnn_vpl VALUES ("DT9_4","006_9_4","DEU","9","4","4","“Ga dhäŋuru ŋuliŋuru ŋunhi ŋayi Garrayyu gukuŋala walalanha marrtjina nhumalaŋgu, yaka walala ŋuriŋiyi märr‐winya'yurranydja ŋurr'yurranydja yanapi nhuma ŋamakurru'mirri. Yaka waŋiya biyakanydja, ‘Garrayyu dhuwalanydja wäŋanha wekaŋala ŋanapurruŋgu, liŋgu ŋanapurru ŋamakurru'mirri yolŋu walala.’ Yaka biyakayinydja waŋiya, liŋgu nhumapinydja yaka yana ŋamakurru'. Ŋunha wiripu‐guḻkuny'tja ŋunhi miṯtji yätjmirrinydja gal'ŋu, ga ŋurukuyina märrwu ŋayi yurru Garrayyu baḏuwaḏuyundja walalanha. ");
INSERT INTO gnn_vpl VALUES ("DT9_5","006_9_5","DEU","9","5","5","Nhumapinydja yakayi yana ŋamakurru', yaka nhuma ŋuli djäma dhunupa ŋunhi, yurru balakurru nhumalaŋgalanydja ŋayipi yurru Garrayyunydja walalanha baḏuwaḏuyunna warrpam'nha, bala wekamana yana ŋayi yurru wäŋanydja nhumalaŋgu, liŋgu ŋayi dhawu'mirriyaŋala nhumalaŋgalaŋuwala märi'muwala walalaŋgala ŋäthili, Yipurayimgala ga Yitjakkala ga Djaykupkala. ");
INSERT INTO gnn_vpl VALUES ("DT9_6","006_9_6","DEU","9","6","6","Yaka ŋayi waŋana bitjarranydja, ‘Ŋarra yurru wekamana ŋunhayinydja wäŋa nhumalaŋguna, liŋgu nhuma dhuwurr‐ŋamakurru'mirri.’ Yaka ŋayi bitjarranydja waŋana, liŋgu nhumanydja dhuwala ŋayaŋu‐dhumukmirrina walala, yakana dhuwurr‐ŋamakurru'; bitjan yana liŋgu nhe ŋuli waŋanydja Godkala yaka'yunna yukurra. ");
INSERT INTO gnn_vpl VALUES ("DT9_7","006_9_7","DEU","9","7","7","“Guyaŋiya ŋunhi ŋäthiliŋu wal'ŋu, ŋunhi nhuma ŋunhala ŋanhdharkŋura wäŋaŋura nhinanha yukurranha ŋuli. Bitjana liŋgu nhuma ŋuli yukurranha yarryunanydja, yaka'yunanydja nhanŋu Garraywu, ŋulinyaramirriyu ŋunhi nhuma gonha'yurruna Yetjip wäŋa, yana liŋgu ga dhiyaŋu‐wala mukthun yana, bala ŋayi Garraynydja ŋaramurryinana wirrkina nhumalaŋgu. ");
INSERT INTO gnn_vpl VALUES ("DT9_8","006_9_8","DEU","9","8","8","Garrayyu bini ŋayipinydja nhumalanha baḏuwaḏuyuna muka warrpam' ŋunhala ŋunhi bukuŋura Djäniyanydja. ");
INSERT INTO gnn_vpl VALUES ("DT9_9","006_9_9","DEU","9","9","11","Yo, ŋarrapina ŋunhi marrtjinanydja ŋunhawalayi bukulilinydja, ga ŋunhalayi bukuŋuranydja ŋayi ŋarrakala wekaŋalana ŋunhiyi romdja, ḻakaraŋala bitjarra ŋunhi nhaltjan yurru nhanŋu yolŋu walala nhina yukurra dhuwurr‐ŋamathirri, bala ŋayi wukirrinydja ŋunhi romdja märrma'lilina guṉḏalilinydja bilkpilklili maṉḏaŋulili. ");
INSERT INTO gnn_vpl VALUES ("DT9_12","006_9_12","DEU","9","12","12","Dhärrana ŋarra yukurrana mukthurruna ŋunhalayi Godkala gumurrŋura, märraŋala marrtjina ŋunhiyi rom malanha, bala ŋayi Garraynydja waŋana ŋarrakala bitjarrana, ‘Gatjuy waḏutjana yana yarrupthurranydja‐wala, liŋgu nhokala ŋuriŋi yolŋu'‐yulŋuyunydja dhuwurr‐yätjkuŋalana, ŋuriŋinydja walalay ŋunhi nhe walalanha gäŋala beŋuru Yetjipŋuru. Ŋunhiliyi ŋoyŋuranydja gal'ŋu bukuŋura walala djäma yukurra yätj warray mirithirri warray nhä malanha. Waḏutja yana walala bilyurruna ŋarrakalaŋuŋurunydja ŋuliŋurunydja romŋuru, bala djäma wiripuna waŋarrnha walalaŋguwaynydja.’ ");
INSERT INTO gnn_vpl VALUES ("DT9_13","006_9_13","DEU","9","13","14","Bitjarrana ŋayi Godthu ḻakaraŋalanydja ŋarrakala, ‘Ŋunhanydja yolŋu walala ŋayaŋu‐ḏälmirrina, bala ŋarra yurru baḏuwaḏuyunna walalanha, buwayakkumana ŋarra yurru warrpam'thunna. Ga ŋuliŋuru nhokuŋuna yurru Mawtjitj ŋunhi mala‐wunharanydja marrtji miṯtji‐guḻku'yirrinydja, ga walalanydja yurru nhokuŋu mala‐wunharanydja ŋunhi ŋarrakuwaynha yolŋu walala.’ Ga bitjarra ŋayi God waŋananydja ḻakaraŋalanydja ŋarrakala. ");
INSERT INTO gnn_vpl VALUES ("DT9_15","006_9_15","DEU","9","15","15","“Yo, yarrupthurrunanydja ŋarra marrtjina ŋunhi beŋuru lili bukuŋurunydja bala ŋoylilinydja, bala ŋarra maḻŋ'maraŋalanydja ŋunhi yuwalkthi. ");
INSERT INTO gnn_vpl VALUES ("DT9_16","006_9_16","DEU","9","16","16","Nhumanydja ŋunhi liŋguna bakmaraŋalana ŋunhiyi romdja Godku, bitjarra nhuma ŋäthilimirriyaŋala yana djämanydja wäyinnha ŋunhi rumbal, bala nhuma yukurrana buku‐ŋal'yurrunana ŋurikiyi wäyingunydja. ");
INSERT INTO gnn_vpl VALUES ("DT9_17","006_9_17","DEU","9","17","17","Bala ŋarranydja ŋunhi guṉḏanhanydja maṉḏanha ŋurrkaŋalana, rommirrinydja ŋunhi guṉḏa munatha'lilina, bala bakmaraŋalana. ");
INSERT INTO gnn_vpl VALUES ("DT9_18","006_9_18","DEU","9","18","18","Bala ŋarra yukurrana ŋorrananydja, bukunydja ŋarra ŋunha munatha'ŋurana, bukumirriyaŋalana bitjarrana weyinmaraŋalana bala Garraywala; 40‐ḏaykun ga 40‐munha ŋarra yukurrana bukumirriyaŋalanydja ŋoy‐ŋathamiriw ga ŋoy‐gapumiriw, ŋäŋ'thurruna ŋarra yukurrana bäy‐ḻakaranharawu nhumalaŋgu. ");
INSERT INTO gnn_vpl VALUES ("DT9_19","006_9_19","DEU","9","19","19","Ŋayinydja ŋunhi Godtja mirithina yana ŋayi maḏakarritjthinanydja nhumalaŋgu, liŋgu mirithinana yana nhuma Godnha yätjkuŋalanydja; ŋayi bini nhumalanha ŋunhi baḏuwaḏuyuna muka yulŋunydja, yurru ŋayi mäkiri'‐witjurrunanydja ŋarrakuway bukumirriyanharawuywunydja, bala walŋakuŋalana nhumalanha. ");
INSERT INTO gnn_vpl VALUES ("DT9_20","006_9_20","DEU","9","20","20","Ga bitjanayi bini ŋayi ŋunhi Garrayyu baḏuwaḏuyuna Yärunnhanydja, bala ŋarranydja bitjarrayi liŋgu bukumirriyaŋala nhanŋunydja. ");
INSERT INTO gnn_vpl VALUES ("DT9_21","006_9_21","DEU","9","21","21","Bala ŋarra märraŋalana ŋunhiyinydja waŋarrnha be goŋbuynydja nhumalaŋguŋu djämawuy, bala ŋarra ḏaw'yurrunana bakmaraŋalana, buḻwaŋ'‐buḻwaŋmaraŋalana muṉguykuŋalana, bala djalkthurruna ŋunha ŋarkula'lilina. ");
INSERT INTO gnn_vpl VALUES ("DT9_22","006_9_22","DEU","9","22","24","“Dhäŋuru ŋuliŋuruyinydja biyapul ŋayi God maḏakarritjthina nhumalaŋgu; ŋayi ḏukṯuk nhumalaŋgu Garray nhuma yurru gulŋiyirrina yana‐wala marrtjina ŋunhimalayi wäŋalili, yurru nhumanydja ŋuyulkthina warray, yaka warray nhuma marrtjina ga gulŋiyina, yaka nhuma yana märr‐yuwalkthina ŋanya Garraynha, ga yaka nhuma dharaŋara ŋäkula ŋanya rirrakay. Bitjarra liŋgu nhuma yukurrana ŋuyulkthinanydja wal'ŋu Garraywunydja, yaka nhuma ŋula djäma nhaltjarra ŋayi nhumalanha waŋana yukurrana. ");
INSERT INTO gnn_vpl VALUES ("DT9_25","006_9_25","DEU","9","25","25","Ŋayinydja bini ŋunhi Garrayyunydja nhumalanha baḏuwaḏuyunana, ga biyapul ŋarranydja ŋorrana maḻway'thinayi, bala bukumirriyaŋala yukurrana Godnha weyinŋumirrina yanana. ");
INSERT INTO gnn_vpl VALUES ("DT9_26","006_9_26","DEU","9","26","27","Ŋarra bukumirriyaŋalanydja bitjarra, ‘Garray, nhepi muka dhuwala buŋgawanydja ŋurruŋunydja, yaka baḏuwaḏuyurra dhuwalayi yolŋu'‐yulŋunhanydja, liŋgu walalanydja dhuwala nhuŋuway dhulŋuŋu. Nhepi ŋunhi walalanha dhawaṯmaraŋalanydja nhokalay nhe ganydjarryu beŋuruyinydja Yetjipŋurunydja. Yuwalk dhuwalayi yolŋunydja walala mäkiri'‐witjunamiriw ga yätjmirri gal'ŋu yana, yurru yaka walalaŋgu nhäŋa ŋunhayi yätjtja, yana walalaŋgu guyaŋiyana ŋunhi märi'munhana walalanha Yipurayimnhana, Yitjaknhana ga Djaykupnhana, ŋunhi walala yuwalkkuŋala gal'ŋu märr‐ŋal'yurruna nhokala. ");
INSERT INTO gnn_vpl VALUES ("DT9_28","006_9_28","DEU","9","28","28","Ŋunhi nhe yurru Garray baḏuwaḏuyundja dhuwalayi yolŋu'‐yulŋunhanydja, ga walalanydja yurru ŋunhalanydja ŋuriŋi Yetjippuyŋuyunydja yolŋuyu walalay ŋämana, bala waŋa walala yurru bitjan warku'yunna nhuna bitjanna, “Ŋunha walalaŋgu Godtja be yalŋgi warray, ganydjarrmiriw warray. Ŋayi ŋunhi dhawu'mirriyaŋala walalanhanydja, ŋunhi ŋayi yurru wekama walalaŋgu manymak wäŋa, yurru yaka warray, yana ŋayi dhawaṯmaraŋalana walalanha beŋuruyi, ga ŋunhalayinydja, bala ŋayi bumarana walalanha warrpam'thurrunana,” ’ ga bitjanna walala yurru waŋa yukurra ŋunhi yolŋu'‐yulŋunydja. Garray buku‐djulŋi, yaka walalanha baḏuwaḏuyurra ŋunhiyi yolŋu'‐yulŋunha. ");
INSERT INTO gnn_vpl VALUES ("DT9_29","006_9_29","DEU","9","29","29","Ŋunhayinydja gal'ŋu nhuŋuwaynha yana yolŋu walala, liŋgu nhepi muka ŋunhi walalanha walŋakuŋalanydja, dhawaṯmaraŋalanydja beŋuruyi garrpiṉminyaraŋurunydja romŋuru ŋuriŋi nhokalay wal'ŋu ganydjarryu.” Bitjarrayina ŋayi yukurrana ŋunhi Mawtjitj bukumirriyaŋalanydja ŋurikiyi yolŋuwunydja walalaŋgu. ");
INSERT INTO gnn_vpl VALUES ("DT10_1","006_10_1","DEU","10","1","2","Bala ŋayi Garray waŋana Mawtjitjkala bitjarra, “Ma' märraŋa ŋunhi guṉḏanydja maṉḏanha bilkpilktja maṉḏanha, bala gäŋana lili ŋarrakalana dhipala bukulilina, ŋarra yurru biyapul wukirri ŋunhimalayinydja maṉḏaŋulili ŋunhiyi rom malanha, bala nhe yurru ŋayathamanydja yukurra ŋunhilina dhawu'‐nherraṉminyarawuyŋurana bathiŋura.” ");
INSERT INTO gnn_vpl VALUES ("DT10_3","006_10_3","DEU","10","3","5","Ga bitjarra ŋayi Garray waŋananydja, bala yuwalkthi ŋayi wukirrinydja ŋunhiwala maṉḏaŋulili guṉḏalilinydja, ga ŋunhiyi guṉḏa maṉḏanha mukthun yana ŋunhilimi dhawu'‐nherraṉminyarawuyŋura bathiŋura. ");
INSERT INTO gnn_vpl VALUES ("DT10_10","006_10_10","DEU","10","10","11","Ŋunhalayi bukuŋuranydja ŋarra yukurrana nhinananydja weyinŋumirrina, 40‐na walu ga munha. Bitjarra liŋgu ŋarra yukurrana bukumirriyaŋalanydja nhumalaŋgu, bala ŋayi Garrayyunydja ŋäkulana ŋarranha ŋunhi bukumirriyanharawuynydja, yakana ŋayi baḏuwaḏuyurrunanydja nhumalanha, yana ŋayi ḻakaraŋalanydja ŋarraku bitjarrana, “Marrtjiyana‐wala yarrupthurrana, ga gäŋana ŋunhiyi yolŋu'‐yulŋunhanydja ŋurru‐warryurrana, märr yurru walala marrtjina‐wala yana gulŋiyirrina ŋunhimalayi wäŋalilinydja. Ga yuwalkthi ŋunhiyi wäŋanydja yurru nhumalaŋguway yana, liŋgu be ŋäthilinydja ŋayi Garrayyu dhawu'mirriyaŋala nhumalaŋgalaŋuwa märi'muwa walalambala.” Ga bitjarrayina ŋayi Mawtjitjthu ḻakaraŋalanydja yukurrana nhanukalayŋuwa yolŋu'‐yulŋuwanydja Yitjuralpuyŋuwanydja. ");
INSERT INTO gnn_vpl VALUES ("DT10_12","006_10_12","DEU","10","12","12","“Nhuma yolŋu'‐yulŋu Yitjuralpuyŋu, ŋäkanydja walala ŋamathaŋa mäkiri'‐witjurranydja. Dhiyaku ŋayi Garraynydja ḏukṯuk gam'. Nhuma yurru borrk‐beyaṉiyiya biyaka Garraywunydja nhumalaŋgalaŋuwu Godkunydja, ga ŋayathaŋa nhanŋu romdja warrpam'thurra yana. Märr‐ŋamathiya nhanŋu biyaka märryu‐ḏapmaraŋa mukthurra yana, ga buku‐ŋal'yurra nhanŋuway yana bukmakthu nhokalay yana ŋayaŋuyu ga rumbalyu. ");
INSERT INTO gnn_vpl VALUES ("DT10_13","006_10_13","DEU","10","13","13","Dhäruktja nhanŋu märraŋa yana ga nhiniyanydja yukirriya dhiyaŋu liŋgu romdhu ŋunhi ŋarra yukurra ḻakarama nhumalaŋgu gäthura, liŋgu dhiyaŋuyinydjayi romdhu nhuma yurru nhina yukurra walŋana. ");
INSERT INTO gnn_vpl VALUES ("DT10_14","006_10_14","DEU","10","14","14","Ŋunha garrwar wal'ŋu djiwarr' nhanŋuway yana dhulŋuŋu Godku, ga dhuwala munatha' wäŋa nhanŋuway dhulŋuŋu warrpam', ga bukmak nhä malanha dhiyalaŋumi munatha'ŋura, nhanŋuway yana dhulŋuŋu Garraywu wal'ŋu. ");
INSERT INTO gnn_vpl VALUES ("DT10_15","006_10_15","DEU","10","15","15","Godthu bini djarr'yuna warray yulŋunydja birrka'mirrinha bäpurru'nhanydja, yurru ŋayinydja djarr'yurruna nhumalanha warray, märr yurru nhuma nhanŋuway yana miṯtji, liŋgu wirrki yana ŋayi wal'ŋu märr‐ŋamathinanydja nhumalaŋgalaŋuwu märi'muwunydja walalaŋgu. ");
INSERT INTO gnn_vpl VALUES ("DT10_16","006_10_16","DEU","10","16","16","Yo, gonha'yurrana warrpam'thurrana dhuwali yätjtja malanha rom, ga dhäruk‐märraŋa ŋanyapinyay yana Garraynha, ga yakana mäkiri'‐yarryurra biyapulnydja. ");
INSERT INTO gnn_vpl VALUES ("DT10_17","006_10_17","DEU","10","17","17","Liŋgu nhumalaŋgunydja God ŋunhi biyapul warray wal'ŋu yindi warray, djuḻkmarama yukurra wiripuŋunhanydja nhänha malaŋunha waŋarrnha. Garraynydja ŋunhi ganydjarr‐ḏumurru wal'ŋu biyapul, djuḻkmarama yukurra bukmaknhanydja be nhänha walalanha ganydjarr‐ḏilkurrunha. Yakana yurru yolŋuyunydja ŋula yolthu bäyim Godnhanydja, märr yurru ŋayi djäma yukurra ŋilimurruŋgu dharrpalnydja rom, liŋgu ŋayinydja yukurra nhäma dhapirrkkuma yana rrambaŋikuma yolŋunha walalanha birrka'mirrinha. ");
INSERT INTO gnn_vpl VALUES ("DT10_18","006_10_18","DEU","10","18","18","Ŋayinydja ŋuli ŋaramurryirri ŋurikinydja yolŋuwu ŋunhi walala ŋuli yätjkuma ŋunhiyi goŋmiriwlili yolŋunha walalanha. Godtja yukurra märr‐ŋamathirri ŋuruku mulkuruwunydja yolŋuwu, ŋunhi ŋayi yukurra nhina nhumalaŋgala miṯtjiŋura, bala ŋayi ŋuli wekamana yana ŋuriki yolŋuwu mulkuruwunydja ŋathana ga girri'na, ŋula nhäna dhaṯthunminyarawuna. ");
INSERT INTO gnn_vpl VALUES ("DT10_19","006_10_19","DEU","10","19","19","Ga nhumanydja yurru bitjandhiyi bili märr‐ŋamathirri yukurra ŋurikiyi mulkuruwunydja yolŋuwu, ga djäka walalaŋgu, liŋgu nhumanydja ŋunhi nhumapinydja nhinanha ŋuli yukurranha mulkuruyi yana ŋunhala Yetjiptja wäŋaŋura. ");
INSERT INTO gnn_vpl VALUES ("DT10_20","006_10_20","DEU","10","20","20","“Yo, rom‐wiyaṉiyiya biyaka Garraywunydja nhokalaŋuwu Waŋarrwunydja. Dhäruk ŋanya märraŋa, ga buku‐ŋal'yurra nhanŋuway yana waŋganygu. Mam'thurra yana nhanukala yulŋunydja, ga nhanukala yana ŋuriŋi liŋgu yäkuyu dhawu'‐nherraṉmiyanydja. ");
INSERT INTO gnn_vpl VALUES ("DT10_21","006_10_21","DEU","10","21","21","Ŋayi nhumalaŋgu Godtja. Biyaka wokthurra nhanŋu djulŋithiya; nhanŋuway waŋganygu wal'ŋu ŋilimurru yukurra yurru wokthundja. Liŋgu muka nhuma nhäŋala ŋunhiyi, ŋunhi ŋayi djäma mirithirri yindi rom nhumalaŋgu. ");
INSERT INTO gnn_vpl VALUES ("DT10_22","006_10_22","DEU","10","22","22","Ŋäthili muka yana ŋunha nhumalaŋgu märi'mu walala marrtjina Yetjiplilinydja, ga walalanydja ŋunhi märr ŋuli ya' ḻurrkun' miṯtjinydja, yurru ŋayinydja Garrayyunydja nhumalaŋgu miṯtjinhanydja ŋunhi be warray dhaŋaŋguŋala warray. Dhiyaŋunydja‐wala nhuma dhuwala biyapulnha wal'ŋu bothurrumiriwnha, balanyarana bitjan ganyu' malanha ŋunha djiwarr'ŋura.” ");
INSERT INTO gnn_vpl VALUES ("DT11_8","006_11_8","DEU","11","8","9","Bitjarra ŋayi Mawtjitjthu ḻakaraŋalanydja ŋurupa yolŋu'‐yulŋuwanydja, “Märraŋa yana dhuwalayi romdja malanha ŋunhi ŋarra yukurra ḻakarama nhumalaŋgu dhuwala dhiyaŋu‐wala gäthura, bala nhuma yurru nhinanydja yukurra weyinŋumirrina wal'ŋu yanana ŋunhalayinydja ŋunhi ḻatju'ŋuranydja dhikanydja wäŋaŋura, ŋunhi ŋayi Garrayyu dhawu'mirriyaŋala nhumalaŋgalaŋuwala märi'muwala. ");
INSERT INTO gnn_vpl VALUES ("DT11_10","006_11_10","DEU","11","10","12","Yo, ŋunhayinydjayi wäŋa dhapirrk warray dhika wal'ŋu, buku'‐wuku warray ŋupanmirri, ga gapumirri warray wäŋa. Bitjan warray liŋgu yukurra dharyun warray ŋuli ŋunhiyinydjayi wäŋa, liŋgu ŋayipi warray wal'ŋu Garray warray yukurra goŋ‐nherraṉmirri djäka ŋurikiyinydjayi wäŋawu, beŋuru liŋgu dhuŋgarra‐ŋupanna. ");
INSERT INTO gnn_vpl VALUES ("DT11_13","006_11_13","DEU","11","13","15","“Ga dhuwalana ŋarra nhumalaŋgu ḻakaramana yulŋunydja. Märr‐ŋamathiya biyaka nhokalaŋu nhe Garraywunydja Godkunydja, ga märr‐nherraṉmiyanydja yuwalkkuŋa gal'ŋu yana, märr‐ŋal'yurranydja nhanukala, bala yurru waltjaṉdja yukurra bitjanna liŋguna dhurrmuknha, ga borumdja malanha ŋathanydja yurru marrtji ŋuthan ḻatju'yirrina dhika, dhaŋaŋdhirrina biyapulnha; bitjanna liŋgu ŋayi yurru ŋathanydja mirithirrina guḻku' nhumalaŋgu ga nhumalaŋgalaŋuwu wäyingu. ");
INSERT INTO gnn_vpl VALUES ("DT11_16","006_11_16","DEU","11","16","16","Yurru märr‐gurrum'thurra yulŋunydja, märr yurru nhumalanha yaka muka mayali'‐wilkthundja ŋuriŋiyi ŋula yolthunydja, bala gatjpaḻ'marama wiripuŋulilinydja dhukarrlili. ");
INSERT INTO gnn_vpl VALUES ("DT11_17","006_11_17","DEU","11","17","17","Ŋuli nhe yurru yuwalk bilyun ŋuliŋuruyi Godkalanydja romŋuru ga buku‐ŋal'yun wiripuŋuwunydja waŋarrwu, bala ŋayipinydja Godtja yurru ŋaramurryirrina, murr'maramana nhumalanha, bala ŋayi yurru dhaḻ'yunna ŋunha djiwarmy'tja gäraktja, märr yurru ŋuriŋi yakana dharyun yukurra waltjaṉdhunydja, märr yurru dhuwalanydja wäŋanydja munathany'tja räwaknha baṉḏanynha; yakana yurru yukurra borumdja ŋuthan ŋunhiliyi, bala nhuma yurru murrmurryunna ŋuriŋiyinayi marrya'yuna. ");
INSERT INTO gnn_vpl VALUES ("DT11_18","006_11_18","DEU","11","18","21","“Guyaŋiya biyaka dhuwalayi malanha romnhanydja, marŋgikuŋa marrtjiya nhumalaŋgu yumurrku'nhanydja bala, märr yurru nhuma ŋamathama gal'ŋu nhinanydja yana ŋunhili wäŋaŋuranydja gupaḏalnha‐wala. ");
INSERT INTO gnn_vpl VALUES ("DT11_22","006_11_22","DEU","11","22","25","Dhäruktja märraŋa ga djäma warrpam'thurra yana ŋunhi nhaltjan ŋayi yurru ḻakarama nhumalaŋgu, bala nhumanydja yurru djuḻkmaramana ŋunhi miriŋunhanydja walalanha, ŋunhi walala yukurra nhina ŋunhiliyi wäŋaŋura. Walalanydja ŋunha biyapul wal'ŋu wuṉḏaŋarrmirri ḏälmirri, yurru nhumanydja ŋupanna yurru walalanhana, ga ŋunhiyi wäŋanydja nhumalaŋguway yana, yakana nhumalanha yurru ŋula gulmaramanydja, ŋunhi nhuma yukurra yurru nhina ŋunhiliyi romŋura nhanukalay gal'ŋu Garraywala. ");
INSERT INTO gnn_vpl VALUES ("DT11_26","006_11_26","DEU","11","26","26","“Yo, gäthuranydja dhuwala ŋarra yukurra ḻakarama yana nhumalaŋgu märrma' dhukarrnydja, waŋganydja goŋmirriyanharamirri ga waŋganydja ŋoy‐yätjthinyaramirri. ");
INSERT INTO gnn_vpl VALUES ("DT11_27","006_11_27","DEU","11","27","27","Ŋuli nhuma yurru dhäruk‐märranharamirrinydja walala, ŋayi yurru Godthunydja nhumalanha goŋmirriyama wal'ŋu, bala nhuma yurru nhina yukurra ŋayaŋu‐djulŋithirri; warrpam' yurru yana manymak nhänydja malanha. ");
INSERT INTO gnn_vpl VALUES ("DT11_28","006_11_28","DEU","11","28","28","Ga ŋunhi nhe yurru yakanydja dhäruk-märrama ŋula Godnha, ga nhenydja yurru märrama ŋunhiyinayi ŋoy‐yätjthinyaramirrina. Yo, ŋuli nhe yurru bilyun ŋuliŋuru ŋarrakalanydja romŋuru, ga buku‐ŋal'yun wiripuŋuwunydja waŋarrwu, ŋayi yurru Godthunydja nhuna yakana goŋmirriyama, yakana nhe yurru nhina dhika wal'ŋu ŋamathama. ");
INSERT INTO gnn_vpl VALUES ("DT11_29","006_11_29","DEU","11","29","32","Yo, galkina nhuma yurru buḏapthunna mayaŋ'kunydja, bala gulŋiyirrina yana ŋunhimalayinydja wäŋalili. Ga ŋunhi nhuma yurru yukurra nhina ŋunhiliyinydja, ga yuwalkkuŋa nhiniyanydja yukirriya wal'ŋu ŋunhili liŋgu romŋuranydja ŋunhi ŋayi Godthu nherrara nhumalaŋgu.” Ga bitjarrayina ŋayi Mawtjitjthu ḻakaraŋalanydja. ");
INSERT INTO gnn_vpl VALUES ("DT12_1","006_12_1","DEU","12","1","1","“Dhuwalanydja Godku nhanŋuway rom, nhuma yurru mäkiri'‐witjun nhanŋuway yana. Biyaka liŋgu yana djämanydja ŋunhiyi liŋgu ŋunhi ŋayi yukurra Godthu ḻakarama. ");
INSERT INTO gnn_vpl VALUES ("DT12_2","006_12_2","DEU","12","2","3","Ŋunha wiripunydja mala miṯtji yolŋu'‐yulŋu yukurra buku‐ŋal'yun wiripuŋuwu waŋarrwu malanyŋuwu birrka'mirriŋura ŋunha wäŋaŋura, ga nhumanydja yurru marrtjiyana ŋunhimalayinydja walalaŋgala be dhuyulilinydja wäŋalili, bala buḻwa'‐buḻwaŋmaraŋana buŋana ḏaw'‐ḏawyurrana ŋunhiyi nhänydja malanha, muṉguykuŋana walalaŋgu maḏayin' malanha ga ŋula nhä dharpa ga barŋ dhika nhä malanha. Gulk‐gulkthurrana ŋunhiyi walalaŋgu be maḏayin'tja malanha, bala dhuŋgur'yurrana walalambala ŋunhinydja be nhänydja maḏayin'nhanydja, ŋunhiyinydja waŋarr malanha ŋunhi walala ŋuli djäma goŋdhu walalawuy, bala märr‐ŋal'yunna. ");
INSERT INTO gnn_vpl VALUES ("DT12_4","006_12_4","DEU","12","4","4","“Ŋunha wiripu‐guḻkuny'tja ŋunhayi yolŋu walala ŋuli yukurra buku‐ŋal'yun walalaŋgalaŋunydja waŋarrwu djarrpi'kumana yanana, ga nhumanydja yurru yaka nhumalaŋgalaŋuwunydja Garraywunydja buku‐ŋal'yun ŋuliwitjandhi walalaŋgalanydja romgurru dhukarrkurru. ");
INSERT INTO gnn_vpl VALUES ("DT12_5","006_12_5","DEU","12","5","5","Ŋayipi yurru Garrayyunydja djarr'yun waŋgany yana wäŋa, märr yurru ŋunhiliyinydjayi waŋganyŋuranydja wäŋaŋura yolŋu walala yurru marrtji galkithirri gal'ŋu nhanukalanydja, ga buku‐ŋal'yun nhanŋuway yana waŋganygu. ");
INSERT INTO gnn_vpl VALUES ("DT12_6","006_12_6","DEU","12","6","6","Ŋunhiliyina wäŋaŋura dharapulŋura waŋganyŋurana nhuma yurru yukurra wekama mundhurrnydja nhanŋu Godku, nhä nhe yurru ŋula wekama nhanŋu; ŋunhiliyina wäŋaŋura nhuma yurru marrtji galkithirrinydja gal'ŋu yana ŋuliwitjannayi maŋgu'‐waṉḏinyarakurru wäyingalana. ");
INSERT INTO gnn_vpl VALUES ("DT12_7","006_12_7","DEU","12","7","7","Ŋunhalayinydjayi wäŋaŋura dharapulŋura nhuma yurru yukurra ḻuka ŋathana gumurrŋura nhanukalanydja bena goŋmirriyirrina wal'ŋu dhikana, liŋgu ŋayipinydja Garrayyunydja nhumalanha bitjarra goŋmirriyaŋala warray dhipali nhumalaŋgala djämalili. ");
INSERT INTO gnn_vpl VALUES ("DT12_8","006_12_8","DEU","12","8","8","Yakana biyapulnydja nhuma yurru buku‐ŋal'yun yukurra Godku ŋuliwitjan nhumalaŋgalaynydja nhuma guyaŋinyarakurru ga romgurru. Ŋunhi nhuma yurru gulŋiyirrinydja ŋunhiwalayi wäŋalili ŋunhi ŋayi yurru Garrayyu wekama nhumalaŋgu, ŋunhalayinydjayi nhuma yurru buku‐ŋal'yun yukurra waŋarrwu Godkunydja nhanukalaynha yana romgurru, ");
INSERT INTO gnn_vpl VALUES ("DT12_9","006_12_9","DEU","12","9","9","liŋgu ŋunhalayinydjayi nhuma yurru nhina ŋayaŋuna, bitjan ŋayaŋu‐yal'yunna bukmakthu ŋuriŋi ŋunhi ŋayi wekaŋala marrtjina nhumalaŋgu. ");
INSERT INTO gnn_vpl VALUES ("DT12_10","006_12_10","DEU","12","10","11","“Yo, Garrayyu yurru ŋayipi nhumalanha gunganhamirriyamanydja, yakana ŋayi yurru miriŋuyunydja buma nhumalanha, bala nhuma yurru nhinanydja yukurra ŋayaŋu‐yal'yunna wurrkurrum'nha. Nhuma yurru buku‐ŋal'yundja yukurra nhanukalaynha yana Garraywalana romgurru, ŋunhilina liŋgu ŋunhi ŋayipi djarr'yurruna ŋunhiyi wäŋa, ga wekamanydja nhuma yurru Garraywunydja ŋunhiyi yana liŋgu ŋunhi ŋayipi waŋana nhumalanha wekanharawu. ");
INSERT INTO gnn_vpl VALUES ("DT12_12","006_12_12","DEU","12","12","12","Nhumapi ga nhumalaŋgu djamarrkuḻi' yumurrku' ga ḏalkarra'mirri walala ŋunhiyi, djulŋithiyana dhikana goŋmirriyiyana ŋunhili Godkala gumurrŋuranydja. ");
INSERT INTO gnn_vpl VALUES ("DT12_13","006_12_13","DEU","12","13","14","Yaka dhuŋgur'yurra mundhurr Godku birrka'mirriŋuranydja; nhuma yurru wekamanydja ŋunhiliyi liŋgu dharapulŋuranydja wäŋaŋuranydja ŋunhi ŋayipi djarr'yurruna nhumalaŋgu. ");
INSERT INTO gnn_vpl VALUES ("DT12_28","006_12_28","DEU","12","28","28","“Dhäruktja märraŋa ŋarraku, dhiyakunydja dhärukku ŋunhi ŋarra yukurra wekama nhumalaŋgu, bukmakku yana, bala yurru nhuma ga nhumalaŋgu mala‐wunharanydja yukurra nhina ŋamathamana dhikana yurru goŋmirriyirrina, ŋunhi nhuma yurru djäma yukurra ŋunhiyi yana liŋgu ŋunhi Godthu ŋayipi ḻakarama yukurra dhunupa wal'ŋu.” ");
INSERT INTO gnn_vpl VALUES ("DT12_29","006_12_29","DEU","12","29","29","“Yo, nhuma yurru mukthun yana marrtjinydja ga gulŋiyirri ŋunhimalayi wäŋalili, ga ŋayinydja yurru nhumalaŋgu Waŋarrnydja Garraynydja marrtji galki yana nhumalaŋgala, bitjan ŋayi yurru bumana marrtji ŋunhiyinydjayi yolŋu'‐yulŋunha ŋunhi walala yukurra nhina ŋunhili wäŋaŋura, märr yurru ŋunhiyinydjayi wäŋa nhumalaŋguwaynha yana nhinanharawu. ");
INSERT INTO gnn_vpl VALUES ("DT12_30","006_12_30","DEU","12","30","30","Yurru yaka walalaŋgalaŋuwu romgunydja malthurra ŋurikiyi mulku'‐mulkuruwalaŋunydja, ga yaka walalaŋgalaŋuwu waŋarrwu marŋgithiya yukirriya. Yaka walalanha waŋiya dhä‐wirrka'yurra biyakanydja, ‘Nhaltjan dhika nhuma ŋuli buku‐ŋal'yun yukurra nhumalaŋgalaŋuwunydja waŋarrwu?’ Yaka biyakayinydja dhä‐wirrka'yurra, märr yurru nhumalanha yaka gaṯmaramanydja ŋuriŋi walalaŋgalay romdhunydja. ");
INSERT INTO gnn_vpl VALUES ("DT12_31","006_12_31","DEU","12","31","31","Ŋunhiyinydja rom walalaŋgunydja yätjnha gal'ŋu yanana, yakana yana nhuma yurru buku‐ŋal'yun Garraywu bitjandja bitjan ŋunhi walala yukurra buku‐ŋal'yun walalaŋgalaŋuwu waŋarrwu. Liŋgu Garraynydja ŋayipinydja yukurra nyinyaŋdhun ŋurikiyinydjayi ŋunhi walala ŋuli yukurra djäma walalaŋgalay buŋgulkurru, bitjan märr‐ŋal'yun walalaŋgalaŋuwu waŋarrwu. Wiripunydja walala ŋuli mundhurr‐wekama walalaŋguway yumurrku'nha, bitjan bathan gurthalili mundhurr walalaŋgalaŋuwu waŋarrwu. ");
INSERT INTO gnn_vpl VALUES ("DT12_32","006_12_32","DEU","12","32","32","Gurrum'thurra biyaka nhumalaŋguway nhuma yulŋunydja. Yaka biyakayi bukulili ŋal'maraŋa ŋunhiwalayi ŋula nhä rom ŋunhi ŋayi gurrunhara Garrayyu ŋayipi, ga yaka ŋula waŋgany meṉguŋanydja yana. ");
INSERT INTO gnn_vpl VALUES ("DT13_1","006_13_1","DEU","13","1","2","“Wiripunydja mak ŋuli nhumalanha yolŋuyu waŋa bitjan, ‘Way, mäkiri'‐witjurra ŋarraku ŋe'. Ŋarranydja djawarrkmirri dhuwala, dhäwu'‐gänharamirri ŋulaŋuru Godkuŋu. Ŋarra marŋgi mayali'wu bukaway'wunydja, ga djäma ŋarra yurru biyapul wal'ŋu ganydjarr‐ḏumurru bathala rom. Yuwalk ŋarra yukurra dhuwala ḻakaramanydja. Go ŋilimurru buku‐ŋal'yunna dhiyaku wiripuŋuwuna waŋarrwu, ŋunhi ŋanapurru yaka marŋgi ŋäthili.’ Bitjanna ŋayi yurru wiripunydja ŋunhiyi be djawarrkmirrinydja yolŋu waŋa. ");
INSERT INTO gnn_vpl VALUES ("DT13_3","006_13_3","DEU","13","3","3","Yaka yana ŋuriki mäkiri'‐witjurranydja bothinyaramirriwunydja djawarrkmirriwu, ga yaka märr‐nherraṉmiya märr‐yuwalkthiya ŋurikalaynydjayi ŋunhi ŋayi yurru bukaway'wuy mayali' ḻakarama. Liŋgu ŋuliwitjandhinydjayi dhärukkurru ŋayi yurru Garrayyunydja gatjarr'yun ŋunhiyi nhumalanha, yana maḻŋ'marama bitjan nhumalanha, mak nhuma yukurra märryu‐ḏapmarama gal'ŋu nhumalaŋguway waŋarrnha Garraynha bukmakthu yana nhokalay ŋayaŋuyu wal'ŋu, mak bäyŋu. ");
INSERT INTO gnn_vpl VALUES ("DT13_4","006_13_4","DEU","13","4","4","Yo, mukthurra yana walala malthurranydja yukirriya nhanŋuway Garraywu, biyaka rom‐wiyaṉiyiya yulŋunydja nhanŋu, märr yurru nhe yakana djäma ŋula nhä yätjtja. Dhäruk biyaka märraŋa ŋanya, ga buku‐ŋal'yurra nhanŋuway yana waŋganygu.” ");
INSERT INTO gnn_vpl VALUES ("DT14_1","006_14_1","DEU","14","1","1","“Nhumanydja dhuwalanydja Garraywu muka yolŋu walala. Ŋunhi nhe ŋuli ŋäthinydja ŋurikiyi ŋula yolku rakunygunydja yolŋuwu, yaka nhe yurru bunharamirri yukurra muḻkurrnydja nhunapinyay nhe mitmitthunmirri. Wiripu‐guḻkuny'tja ŋuli wiriny'tjun yukurra gayawak, baṉḏany'kunharamirrina muḻkurr, ŋunhiyinydjayi mayali' märr‐ŋal'yun yukurra ŋurikinayi rakunyguna; nhumanydja yaka biyakayi. ");
INSERT INTO gnn_vpl VALUES ("DT14_2","006_14_2","DEU","14","2","2","Nhumanydja dhuwala nhanŋuway yana wal'ŋu Garraywu, ŋayi nhumalaŋgunydja ŋunhi waŋarr. Guḻku' dhuwala mirithirri yolŋunydja walala miṯtjinydja dhiyalaŋumi munatha'ŋuranydja, yurru ŋayinydja ŋunhi Godthunydja djarr'yurruna nhumalanha warray, märr yurru nhumanydja miṯtji nhanŋuwaynha yana wal'ŋu dhulŋuŋuna.” ");
INSERT INTO gnn_vpl VALUES ("DT14_22","006_14_22","DEU","14","22","22","“Ŋunhi nhuma ŋuli gulkthun marrtji waŋgany‐manapan ŋathanydja malanha, ŋäthilinydja gulk‐gulkthurra ŋunhiyi 10‐guŋa, liŋgu waŋganydja ŋunhi ŋuliŋuruyi wakana nhanŋuway dhulŋuŋu Garraywu, yaka nhuŋu. ");
INSERT INTO gnn_vpl VALUES ("DT14_23","006_14_23","DEU","14","23","26","Märraŋa ŋunhiyinydjayi nhanŋuwaynydja dhulŋuŋunydja Garraywunydja, ga gäŋa bala buku‐ŋal'yunarawuylili buṉbulili nhanŋu Garraywu, ga ŋunhalayina nhe yurru ḻukanydja yukurra gumurrŋura nhanukalana Garraywalana. Ga bitjandhi liŋgu nhe yurru ŋurruŋunhanydja ŋunhi dhawal‐wuyaŋinyarawuynha wäyinnha ḻuka yukurra ŋunhiliyi gumurrŋura nhanukala Garraywala, liŋgu ŋunhiyinydjayi ŋurruŋunydja wal'ŋu nhanŋuway dhulŋuŋu Garraywu. Bitjan liŋgu nhuma yurru yukurra djämanydja dhuwalayi romnha, nhokala gurruṯu'mirriyu walalay rrambaŋi nhuma yurru ḻukanydja yana ŋunhiliyi Garraywala gumurrŋuranydja, djulŋithirri yana wal'ŋu rrambaŋi, märr yurru nhuma guyaŋirri yukurra bitjan liŋgu ŋurruŋunydja ŋanyapinyay Garraynha, bala dhäruk‐märraŋana. ");
INSERT INTO gnn_vpl VALUES ("DT14_27","006_14_27","DEU","14","27","27","Ga bitjandhi liŋgu nhuma yurru wekama yukurra ŋatha ŋuriki Lepaywunydja walalaŋgu yolŋu'‐yulŋuwu, ŋunhi walala yukurra nhina dhuwali nhumalaŋgala wäŋaŋura. Ŋunhinydja walalanydja Godku muka djämamirri walala, yaka walalanhanydja meṉguŋa, liŋgu bäyŋuna walala yukirri ŋayathaŋu walalaŋguwaynydja walala wäŋa. ");
INSERT INTO gnn_vpl VALUES ("DT14_28","006_14_28","DEU","14","28","29","Yo, märrma' dhuŋgarra nhuma yurru nhumapinydja ḻuka yukurra ŋunhiyinydja ŋatha, ŋunhiliyi Garraywalanydja buṉbuŋura, ga ŋuriŋinydja bala dhuḏiŋuyunydja dhuŋgarrayu bala nhuma yurru ŋurruŋunydja Garraywu waka'nha ŋunhi ganaŋ'maramana, bala rulwaŋdhun gali'lili; ŋunhiyinydjayi ŋatha walalaŋguwaynha Lepaywuna, Godkalaŋuwu ŋuriki ḏalkarra'mirriwuna yolŋu'‐yulŋuwu, ga buku‐gurthawuywu yolŋu'‐yulŋuwu ga goŋmiriwŋura ŋunhi yolŋuwu walalaŋgu. “Ŋuli nhe yurru bitjandhiyinydja Godkunydja wekama nhanŋuwaynydja ŋunhi ŋäthili, ŋayinydja yurru nhuna Garrayyunydja bitjan goŋmirriyamana gal'ŋu gäma yukurra yanana, ga bukmak nhä malanha nhe yurru djäma yukurra, ŋunhiyinydja yurru ḻatju'thirrina dhikana wal'ŋu nhuŋu. “Yo, ŋunhi walala ḏalkarra'mirri walala yolŋu'‐yulŋu, yakana walalaŋgu yurru ŋayathama walalaŋguway walala wäŋanydja ŋunhalayi Yitjuralnydja, yana walala yurru yukurra ḻukanydja märramanydja ŋunhina ŋunhi walala ŋuli wiripu‐guḻku'yu yolŋu'‐yulŋuyu wekama yukurra Garraywala. Ŋuriŋi wiripu‐guḻku'yunydja miṯtjiyu ŋayathama yukurra yurru wäŋa, yurru ḏalkarra'mirriwunydja ŋunhiyi walalaŋgu ŋayipina yana Garraynha; djämanydja walala yukurra nhanŋuway yana Garraywu, ga ŋayi walalanha marrtji ŋäthilimirriyama maranhu‐wekamanydja. ");
INSERT INTO gnn_vpl VALUES ("DT18_9","006_18_9","DEU","18","9","9","“Yo, ŋunhi nhe yurru gulŋiyirrinydja wäŋalilinydja ŋunhimalayi, yaka romgu malthurra walalaŋgalaŋuwunydja ŋunhi walala yukurra nhina ŋunhiliyi; ŋunhiyi walalaŋgu romdja mirithirrina yana yätjnha wal'ŋu. ");
INSERT INTO gnn_vpl VALUES ("DT18_10","006_18_10","DEU","18","10","11","Yaka wekaŋa nhumalaŋguway nhuma yumurrku'nhanydja bitjan mundhurr bathanarawu ŋuriki walalaŋgalaŋuwu waŋarrwu. Yakana ŋula waŋgany nhumalaŋgalanydja malaŋura yurru djäma ŋula nhä gaḏamandhinyaramirri rom, be galŋa‐mangaṯa'mirriyunydja yurru djäma, ga yaka nhuma yukurra yurru waŋa bitjan buku‐wuykthundja nyirawunuma, ga djäma ŋula nhä marrŋgitjkalanydja girri'yu. Yaka nherrala girri' ŋula nhänydja gunganharamirriyanhamiya ŋuliŋuru yätjkalanydja, yanapi ŋunhiyinydjayi ganydjarrmirri, ga yaka djäma ŋunhiyi be ḏaḏa'yunaramirrinydja rom. Yakana djäma djalaḏaḏany'tja, ga yaka bukukurru waŋiya yukirriya rakunygalanydja ŋurikalanydja birrimbirrwala mokuywalanydja. ");
INSERT INTO gnn_vpl VALUES ("DT18_12","006_18_12","DEU","18","12","12","Ŋurikiyinydjayi malaŋuwu Godtja yukurra wirrkina nyinyaŋdhun wal'ŋu, ga wirrkina yana ŋayi yurru ŋaramurrthirri yolŋu'‐yulŋuwunydja ŋunhi walala yukurra yurru djäma bitjandhiyi yätjtja. Ŋunhala miṯtjiyu Gaynanbuyŋuyu ŋuli yukurra djäma bitjandhinydja, ga ŋurikiyina märrwu ŋunhi ŋayi Godthunydja walalanha yurru dhawaṯmaramana yanana ŋuliŋuruyi wäŋaŋurunydja. ");
INSERT INTO gnn_vpl VALUES ("DT18_13","006_18_13","DEU","18","13","13","Yaka nhenydja balanyarayi djäma yätj. Nhumanydja yurru nhina yukurra ḏarrtjalk gal'ŋu yana, ganaŋ'thunara ŋuliŋuruyi yätjkalanydja, ŋunhiliyi liŋgu waŋganyŋura romŋura Garraywala yana.” ");
INSERT INTO gnn_vpl VALUES ("DT18_14","006_18_14","DEU","18","14","14","Ga biyapul ŋayi Mawtjitj waŋana bitjarranydja, “Yo, galkina nhuma yurru gulŋiyirrina ŋunhimalayi wäŋalili dhawu'‐nherraṉarawuylilinydja. Ŋunhilinydja wäŋaŋura yolŋu walala yukurra nhina goŋ‐maŋgimaŋgi'mirri dhika nhä malanha, ŋunhi walala ŋuli barrari‐wukuma yolŋunha walalanha, bitjan ḻakarama yukurra ŋunhi yurru ŋayi nhä maḻŋ'thun yalala yätj wal'ŋu, liŋgu walala ŋuli nhäma yukurra ŋunhiyi bukaway'kurru, wo ŋuliwitjandhi ŋunhi walala yurru nhäma yukurra ŋula nhä. Nhumanydja dhuwalanydja Garraywu nhanŋuway yolŋu walala, yakana nhuma yurru maḻŋ'marama yuwalkŋunydja dhukarr ŋuriŋiyinydjayi nhäyu malaŋuyu romdhu. Yaka nhumanydja yurru biyakayi malthurra dhärukku walalaŋgalaŋuwu. ");
INSERT INTO gnn_vpl VALUES ("DT18_15","006_18_15","DEU","18","15","15","Ŋayipinydja yurru Godthunydja nhumalaŋgunydja djuy'yun warray dhäwu'‐gänharamirrinha yolŋunha, ŋayinydja yurru ŋunhiyi yolŋu yana, bitjan ŋarrapi, bitjan ŋayi yurru dhawal‐wuyaŋirrinydja dhipuŋuru ŋilimurruŋgala yarraṯaŋuru, ŋurikiyina nhuma yurru yukurra dhärukkunydja malthun. ");
INSERT INTO gnn_vpl VALUES ("DT18_16","006_18_16","DEU","18","16","16","“Ŋäthilinydja ŋunhinydja ŋunhi nhuma ḻuŋ'maranhamina yukurrana ŋunhili bukuŋura Djäniya yäkuŋura, nhuma waŋana bitjarra, ‘Ŋanapurrunydja yaka ḏukṯuk ŋanapurru yurru ŋäma yukurra rirrakay Godnha, ga yaka ŋanapurru ḏukṯuk ŋanapurru yurru nhäma ŋanya ŋunhiwalayi gurthalili. Ŋanapurru ŋuli bäynha rakunydhi.’ Bitjarranydja nhuma waŋana, liŋgu nhuma borrk‐beyaṉiyinana wirrkina wal'ŋu. ");
INSERT INTO gnn_vpl VALUES ("DT18_17","006_18_17","DEU","18","17","17","Bala ŋayi Garraynydja waŋana ŋarrakala bitjarrana, ‘Yo manymak. ");
INSERT INTO gnn_vpl VALUES ("DT18_18","006_18_18","DEU","18","18","18","Ŋarranydja yurru yänguma ŋunhiyinayi dhäwu'‐gänharamirrinhana, ŋayinydja yurru ŋunhiyi yolŋu yana rumbalnydja bitjan nhuma, ga marrtjinydja ŋayi yurru dhawaṯthundja ŋunhiyi dhipuŋuru nhumalaŋgala miṯtjiŋurunydja. Ŋarra yurru nhanŋu dhäruktja wekama waŋanharawunydja, bala ŋayi yurru ḻakaramanydja nhanukalaŋuwu yolŋu'‐yulŋuwunydja warrpam' yana ŋunhi ŋarra yurru waŋa yukurra nhanukala. ");
INSERT INTO gnn_vpl VALUES ("DT18_19","006_18_19","DEU","18","19","19","Waŋanydja ŋayi yurru yukurra ŋarrakala yana yäkuyu, ga ŋunhi yurru ŋula yol yolŋu yakanydja dhäruk märrama ŋanya, ŋarranydja yurru ŋanya dhä‐ḏir'yunna ŋunhiyinydjayi dhäruk‐märranharamiriwnhanydja yolŋunha.’ ");
INSERT INTO gnn_vpl VALUES ("DT18_20","006_18_20","DEU","18","20","20","“Ŋunhi ŋayi yurru wiripunydja yolŋu waŋa bitjan gam', ‘Dhuwala dhäruktja ŋarra yukurra gäma Garraywuŋu’ bitjan yurru, yurru dhäruktja ŋunhiyinydjayi yaka ŋarrakuŋu wekanhara, bala nhuma yurru yana bumana ŋanya rakunygumana ŋunhiyinydjayi yolŋunha, liŋgu ŋayinydja yukurra ŋunhiyinydja waŋa yolŋu yäkuyu be yolkalana wiripuŋuwalana waŋarrwala. ");
INSERT INTO gnn_vpl VALUES ("DT18_21","006_18_21","DEU","18","21","21","“Ga wiripunydja mak nhe yurru waŋa bitjan, ‘Nhaltjan dhika ŋarra yurru dharaŋandja ŋunhiyi yuwalkŋunhanydja dhäwu'mirrinha? . . . wanhaka ŋayi yurru yukurra waŋa yuwalk wal'ŋu ŋulaŋuru Garraywuŋu dhäruk mak ŋula yolkuŋu?’ Bitjandhiyi nhe yurru djarr'yundja ŋunhiyi dhäwu'mirrinhanydja yolŋunha. ");
INSERT INTO gnn_vpl VALUES ("DT18_22","006_18_22","DEU","18","22","22","Ŋuli nhe yurru ŋäma yolŋunha ŋunhi ŋayi yurru waŋa Garraywala yäkuyu, ŋunhi ŋayi yurru waŋanydja, ga yakanydja yurru ŋayi ŋunhiyi maḻŋ'thun, bala nhe yurru marŋgithirrina ŋunhi ŋurikalayinydja yolŋuwala yakana dhäruk wekanhara ŋulaŋuru Garraywuŋu. Ŋunhiyinydjayi yolŋu waŋa yukurra yana ŋuliŋuruna bäymana nhanukuŋuwaynha guyaŋinyarawuy. Yaka barrariyanydja ŋuriki yolŋuwu dhärukkunydja.” ");
INSERT INTO gnn_vpl VALUES ("DT19_15","006_19_15","DEU","19","15","15","“Ŋuli yurru waŋganydhu yolŋuyu ḻakarama djarrma'‐wama, ‘Ŋuruŋunydja gay' yolŋuyu djäma yätjkuŋala,’ bitjan yurru, yaka yana waḏutja märr‐yuwalkthiyanydja ŋurikiyi. Ŋäthilinydja marrtjiya ŋathili yuwalkŋuwu dhäwu'wu ḻarruŋa, ga ŋuli nhuma yurru maḻŋ'marama märrma'nha wo ḻurrkun'nha ŋunhi walala nhäŋala ŋuriŋiyi walalay marŋgiŋumirri walala, ga ḻakarama walala yurru ŋuriŋi walalay ŋunhi yana liŋgu yuwalkŋu ŋupanayŋu dhäwu', bala nhuma yurru märr‐yuwalkthirrina ŋurikiyi dhäwu'wunydja, bala yuwalkthina nhuma yurru dhä‐ḏir'yundja ŋunhi wiripuŋunhanydja yolŋunha ŋunhi ŋayi djäma yätjkuŋala. ");
INSERT INTO gnn_vpl VALUES ("DT19_16","006_19_16","DEU","19","16","17","Ga ŋunhi yurru ŋula yolthu yolŋuyu ḻakarama bothirri, yana mari ŋayi yurru warkthun ŋula yolku, ga gäŋa ŋunhiyinydja maṉḏanha märrma'kuŋa yana bala Godkala buṉbulili, ga ŋunhiliyina maṉḏanha yurru mala‐yarr'yundja ŋuriŋi ḏalkarra'mirriyu walalay ga dhä‐wirrka'yunaramirriyu walalay. ");
INSERT INTO gnn_vpl VALUES ("DT19_18","006_19_18","DEU","19","18","18","Baḏak walala yurru ḻarrumanydja, yana liŋgu ga maḻŋ'maramana walala yurru yuwalkŋuna dhäwu'. Ga ŋuli walala yurru maḻŋ'marama yuwalktja wal'ŋu ŋunhiyinhayi ḏarramunha, ŋunhi ŋayi yäna ḻakaraŋala bothina ŋuriki nhanukalaŋuwu ŋayi gurruṯu'mirriwu, ");
INSERT INTO gnn_vpl VALUES ("DT19_19","006_19_19","DEU","19","19","19","ŋanyanydja yurru ŋunhiyinhanydjayi yolŋunha ŋunhi ŋayi bothina ḻakaraŋala dhä‐ḏir'yunna yurru; ŋayinydja yurru ŋuriŋiyinydjayi märrama balanyara yana liŋgu ŋupanayŋu, bitjana ŋayi bini ŋuriŋi yolŋuyu märranha, ŋunhi be ŋayi djäma yätjkunhanydja. ");
INSERT INTO gnn_vpl VALUES ("DT19_20","006_19_20","DEU","19","20","20","Bala ŋuruŋu wiripu‐guḻku'yunydja yurru ŋämana ŋunhiyi, bala wirrkina beyaṉiyirrinydja, bala walala yurru yakana biyapulnydja dhäwu' yukurra djäma bothirri, ga ŋuriŋiyinydjayi nhuma yurru romdhu ḏaḏawmaramana ŋula yolŋunha, märr yurru walala yakana biyapulnydja djäma bitjandhiyi yätj. ");
INSERT INTO gnn_vpl VALUES ("DT19_21","006_19_21","DEU","19","21","21","Yaka mel‐wuyurra ŋurikiyi bothinyaramirriwunydja dhäwu'‐ḻakaranhamirriwu, yaka ŋanya yana dhayuŋandja ‘bäythi’ biyakanydja, yana ŋanya mukthurrana dhä‐ḏir'yurrana. Ŋunhi bini walala bunha yuwalktja ŋula yolnha liŋgu ŋuriŋi bothinyarayu dhäwu'yu, ŋayinydja yurru ŋunhiyinydjayi bothinyaramirrinydja yolŋu burakirrina, ga ŋunhi bini walala wutthunna ŋula yolnha maŋutjinydja, wo ḏaw'yunna ḻirranydja, ga ŋanyanydja yurru bitjandhi liŋgu maŋutji wutthun ga ḻirra ḏaw'yun ŋunhiyi bothinyaramirrinhanydja yolŋunha.” ");
INSERT INTO gnn_vpl VALUES ("DT21_1","006_21_1","DEU","21","1","21","Yo, wiripunydja ŋayi Mawtjitjthu guyaŋinyamirriyaŋala waŋana yolŋu'‐yulŋunha, ḻakaraŋala wiripu ga wiripu malanha rom, ŋunhi ŋayi Godthu nherrara walalaŋgu, balanyara rom malanha gam'. ");
INSERT INTO gnn_vpl VALUES ("DT21_22","006_21_22","DEU","21","22","23","Ŋunhi nhuma yurru yolŋunha buma murrkayny'tja, liŋgu djäma ŋayi yukurrana yolŋuyu yätjkuŋala dhika wal'ŋu, ga ŋayi yurru ŋunhi rumbalnydja yukurra gorrumana yana dharpaŋura mälakmaranharawuyŋurana, yakana ŋayi yurru ŋunhiyi rumbal yukurra baḏaktja gorruma dharpaŋuranydja ŋunhiliyi ŋuliwitjan munha‐ŋupandja. Nhumanydja yurru ŋunhi nhäŋa, bala yupmaraŋana rumbalnydja, ga gäŋa dhalkaranharawuna ŋuriŋi yana liŋgu waluyunydja, liŋgu ŋunhiyinydjayi yolŋu yätjnha ŋayi yana, ŋunhi ŋayi ŋuli rakunydhirri dharpaŋura, ga dhä‐ḏir'yunarana ŋayi ŋuli yukurra ŋuriŋiyinydja märrama ŋulaŋuru Godkuŋuna. Waḏutja ŋunhiyi yolŋunha yana rumbalnydja dhalkaraŋa munatha'lilinydja, märr yurru ŋayi ŋunhi wäŋa yaka yätjthirri ŋuriŋiyi. ");
INSERT INTO gnn_vpl VALUES ("DT22_1","006_22_1","DEU","22","1","4","Ŋuli nhe yurru maḻŋ'marama ŋula nhä wäyin ŋula yolku yolŋuwu, ga dhunupana märraŋanydja ga gäŋa roŋiyinyamaraŋana balayi ŋurikalayi wapunhu'mirriŋuwalana. Ŋuli nhe yakanydja marŋgi yolku ŋayi ŋunhiyi, yurru manymak ŋunhiyi nhuŋunydja, nhe yurru gäma nhokalanydja wäŋalili. Ga ŋuli ŋayi yurru ŋunhiyinydja yolŋu wapunhu'mirriŋunydja marrtji ga ŋäŋ'thundja ŋurikiyi, ga dhunupa nhenydja roŋiyinyamaraŋana wekaŋa. ");
INSERT INTO gnn_vpl VALUES ("DT22_5","006_22_5","DEU","22","5","5","Dhäyka yurru yaka dhaṯthunmirri ŋuriŋi ḏarramuwala girri'yu, ga balanya liŋgu yana ŋupanayŋu ḏarramuyunydja yurru yaka yukurra dhaṯthunmirri dhäykawalanydja girri'yu. Ŋunhiyi Godthunydja ŋuli ḻakarama yätjnha yanana wal'ŋu, ŋunhi ŋuli yolŋu'‐yulŋuyu djäma bitjandhiyinydja. ");
INSERT INTO gnn_vpl VALUES ("DT22_6","006_22_6","DEU","22","6","7","Yo, ŋuli nhe yurru maḻŋ'marama wäyinnha ŋäṉḏi'mirriŋunha, ŋunhi ŋayi yukurra nhina yaluŋura nhanukalay mapu'ŋura, yurru manymak warray nhuŋu djaw'yunarawu ŋuriki mapu'wunydja. Ga yaka wutthurra ŋunhi ŋäṉḏi'mirriŋunhanydja wäyinnha, yana djuy'yurrana ŋanya, märr yurru nhumanydja nhinana yukurra ŋunhili wäŋaŋura weyinmaramana, ga bitjanna liŋguna nhumalaŋgu yurru ŋathanydja guḻku'yirrina ŋunhili wäŋaŋura. ");
INSERT INTO gnn_vpl VALUES ("DT23_17","006_23_17","DEU","23","17","17","Yo, dhäyka yurru yaka wekanhamirri ŋanyapinyay ŋayi birrka'mirriwala ḏarramuwala ŋunhili ŋula buŋgulmirriŋuranydja, ga ḏarramuyu yurru yaka marramba' warkthun yukurra ŋunhili buŋgulmirriŋura. Wirrki ŋayi ŋuli Godtja yukurra nyinyaŋdhun ŋurikiyinydja romgu. ");
INSERT INTO gnn_vpl VALUES ("DT23_24","006_23_24","DEU","23","24","25","Ŋunhi nhe yurru yukurra marrtji dhukarrkurru, djuḻkthunmarama ŋuliwitjandhi marrtji ŋuli ŋula yolkala yolŋuwala dhulŋuŋukurru gärulkurru, bala gulkthun borumdja nhe yurru märr ŋuli ḻurrkun', yana ḻuka marrtji yurru ŋuliwitjandhiyi dhukarrkurru, ŋunhiyinydja manymak warray, yurru yaka nhe yurru gulkthurra marrtjiya ŋula banikin'lilinydja, bala djaw'yurranydja. Yurru manymak nhuŋu, nhe yurru marrtji goŋdhunydja yana gulkthun ŋatha, ḻuka marrtji yurru, ŋunhi nhe yurru marrtjinydja yukurra dhukarrkurrunydja, ga yaka gulkthurra yiki'yunydja ŋula yolpa marrtjiya ŋathanydja, bala djaw'yurranydja. ");
INSERT INTO gnn_vpl VALUES ("DT24_14","006_24_14","DEU","24","14","14","Biyaka ŋurikinydja yolŋuwu ŋoy‐wuyurra ŋunhi ŋayinydja yolŋumiriw ga ŋurruwuyk. Yaka djaw'‐djawyurra walalaŋgalaŋuŋuru, ga biyaka buku‐ruŋinyamaraŋa yulŋunydja ŋunhi walala yurru djäma yukurra nhumalaŋgu. ");
INSERT INTO gnn_vpl VALUES ("DT24_19","006_24_19","DEU","24","19","21","Ŋunhi nhe yurru marrtji gulkthun ŋatha nhuŋuway malanha, ga muṉguynydja marrtjiya gonha'yurra ŋurikiyi ŋurruwuykkuna yolŋuwu ga yolŋumiriwwuna ga mulkuruwuna; ŋuriŋina walalay yurru yukurra ḻuka ŋunhi bäythinyaranydja ŋatha muṉguynydja. ");
INSERT INTO gnn_vpl VALUES ("DT24_22","006_24_22","DEU","24","22","22","Garrayyu dhuwalayinydja ŋayipi rom wekaŋala nhumalaŋgu, märr yurru nhuma yaka ŋula meṉguma, ŋunhi ŋäthilinydja nhuma muka yukurrana nhinana ŋurruwuyk ŋunhala Yetjip muka. ");
INSERT INTO gnn_vpl VALUES ("DT25_4","006_25_4","DEU","25","4","4","Ŋunhi ŋuli buliki'yu marrtji djäma muŋdhu'‐muŋdhun ŋatha malanha, barrkuwatjkuma marrtji ŋuliŋuru dhukun'ŋurunydja, yaka ŋanya dhänydja ḏapmaraŋa. Gonha'yurra yana ŋanya, märr ŋayi yurru ḻuka marrtji ŋatha ŋuliŋuruyi. ");
INSERT INTO gnn_vpl VALUES ("DT25_5","006_25_5","DEU","25","5","6","Ŋuli yurru maṉḏa yukurra märrma' gutha'manydji nhina waŋganyŋura wäŋaŋura, ga waŋganydja yurru rakunydhirrina yothumiriw yana, bala ŋayi yurru ŋuriŋiyi gutha'mirriŋuyunydja märrama rakunygunydja ŋurikiyinydjayi dhäykanha, märr yurru ŋayi yothu märrama ŋurikiyi rakunygu yolŋuwu dhuway'mirriŋuwu. ");
INSERT INTO gnn_vpl VALUES ("DT25_7","006_25_7","DEU","25","7","10","Ga guḻku' mirithirri wiripunydja malanha rom ŋunhi ŋayi Godthu gurrunhara nhanukalayŋuwu ŋayi yolŋu'‐yulŋuwu, bitjarra marŋgikuŋala marrtjina, märr yurru walala yaka djarrpi'thirri walalaŋguway walala, märr yurru ŋunhiyi wäŋa dhärra yukurra ḻatju' dhika wal'ŋu, marimiriw ŋula nhämiriw. ");
INSERT INTO gnn_vpl VALUES ("DT26_1","006_26_1","DEU","26","1","1","“Yo, galkina nhuma yurru marrtjina yulŋunydja giṯthunna, bala gulŋiyirrina ŋunhiwalayi wäŋalilinydja, bala nhinana yurru wäŋaramana, ");
INSERT INTO gnn_vpl VALUES ("DT26_2","006_26_2","DEU","26","2","2","bala ŋathanydja yurru ŋuthan muḻkurrmirriyirrina dhika. Ga ŋunhi nhe yurru gulkthundja marrtji ŋathanha, bala nhe yurru bathililiyamana ŋurruŋunydja wal'ŋu ŋunhi gulkthunara ŋatha, bala gäma yurru ŋunhiwalayina buku‐ŋal'yunarawuylilina buṉbulili. ");
INSERT INTO gnn_vpl VALUES ("DT26_3","006_26_3","DEU","26","3","3","Marrtjiya ŋurikala ḏalkarra'mirriwalanydja yolŋuwala, ga waŋiyanydja biyaka nhanukala, ‘Dhuwalanydja ŋarra yukurra waŋanydja nhanukalaynha gal'ŋu yana Garraywalana buku‐wekamanydja yukurra ŋanyana, ŋunhi ŋarranydja liŋguna gulŋiyinana dhipalayi wäŋalili ŋunhi ŋayi dhawu'mirriyaŋala ŋanapurruŋgalaŋuwala märi'muwala be ŋäthili.’ ");
INSERT INTO gnn_vpl VALUES ("DT26_4","006_26_4","DEU","26","4","4","“Bala ŋayi yurru ŋuriŋiyinydja ḏalkarra'mirriyunydja yolŋuyu märrama bathinydja ŋunhiyi ŋathamirri nhokala goŋŋurunydja, bala gämana, ga gurrunhan gumurrlili dhaliyarra'lilina Garraywala. ");
INSERT INTO gnn_vpl VALUES ("DT26_5","006_26_5","DEU","26","5","5","Ga ŋunhalayinydjayi gumurrŋura nhanukalaynydja nhe yurru waŋa bitjanna, ‘Ŋarraku märi'munydja nhinana yukurrana dhiyalanydja wäŋaŋura mulkuru ŋayi, yaka ŋayi yukurrana ŋayathaŋala wäŋa, bala ŋayi märraŋalana nhanŋuway djamarrkuḻi'nhanydja bala Yetjiplilina. Walalanydja ŋunhi ḻurrkun' wal'ŋu yana miṯtjinydja, ga ŋunhalayinydja Yetjiptja wäŋaŋura bitjarra ŋayi ŋunhi miṯtjinydja birrŋ'thurrunana yindithinana ŋuthara. ");
INSERT INTO gnn_vpl VALUES ("DT26_6","006_26_6","DEU","26","6","7","Ŋuriŋi Yetjippuyŋuyu yolŋu'‐yulŋuyu walalay yukurrana gur'kuryurruna ŋanapurrunha mirithinana yana djämawunydja, yana walala ŋuli ŋayaŋu‐yätjkunha ŋanapurrunha wiripunydja, yana liŋgu ga bitjarra gawaw'yurruna ŋanapurru märrliliyaŋala Garraywala guŋga'yunarawuna. Bala ŋayi ŋäkulana ŋanapurrunha gawaw'yunaranydja rirrakaynydja; ŋayi nhäŋala ŋanapurrunha ŋunhi ŋanapurru yukurrana nhinana buku‐yätjthina, galŋa‐yätjthina manapara, monygunhara ŋuriŋina ŋonuŋdhuna romdhu, ");
INSERT INTO gnn_vpl VALUES ("DT26_8","006_26_8","DEU","26","8","8","bala ŋayi dhawaṯmaraŋalana ŋanapurrunha walŋakuŋalanydja märraŋala ŋuliŋuruyi nhanukalaynha ŋayi ganydjarryu gal'ŋu. Ŋayi märraŋalanydja ŋanapurrunha dhawaṯmaraŋalana Yetjipŋurunydja yana. Djämanydja ŋayi mirithirri wal'ŋu yana yindi romdja, barrarimirri yana rom, ");
INSERT INTO gnn_vpl VALUES ("DT26_9","006_26_9","DEU","26","9","9","bala ŋayi gäŋala lili ŋanapurrunha, bala wekaŋalana ŋayi dhuwalayinydja ŋatha‐guḻku'mirrinydja wäŋa ŋanapurruŋguna. ");
INSERT INTO gnn_vpl VALUES ("DT26_10","006_26_10","DEU","26","10","10","Ga dhuwalana gay ŋarra yukurra gämana yulŋunydja roŋiyinyamarama Godkuna nhanŋuwaynha ŋunhiyi ŋurruŋunydja gal'ŋu ŋuliŋuruyi ŋathaŋuru, ŋunhi ŋayi ŋayipi Garrayyu wekaŋala ŋarraku.’ Waŋiyanydja biyakayina, bala gurrunharranydja marrtjiya ŋunhiyi ŋathanydja gumurrlilina nhanukala, bala buku‐ŋal'yurrana nhanŋu. ");
INSERT INTO gnn_vpl VALUES ("DT26_11","006_26_11","DEU","26","11","11","Biyaka goŋmirriyaŋa buku‐wurrpalanydja ŋanya, ŋunhi ŋayi mirithirri manymak nhä malanha wekaŋala nhuŋu ga nhumalaŋgalaŋuwu djamarrkuḻi'wu. Ga ŋunhiyi wiripu‐guḻku' ḏalkarra'mirri walala yolŋu'‐yulŋu ga wiripu mala, walalanydja yurru bitjandhi liŋgu goŋmirriyirri dhika wal'ŋu rrambaŋi nhumalaŋgala manapan; rrambaŋi yana waŋgany‐manapanmirri nhuma yukurra yurru ḻuka ŋathanydja ŋunhiyi Garraywalanydja ŋunhiliyi wal'ŋu gumurrŋura. ");
INSERT INTO gnn_vpl VALUES ("DT26_12","006_26_12","DEU","26","12","12","“Yo, ḻukiyanydja yukirriya ŋathanydja ŋunhiyinydjayi nhumapi yana märrma' dhuŋgarranydja ŋupan yurru, ga ŋuriŋi wiripuŋuyunydja dhuŋgarrayu nhuma yurru yakana ḻuka ŋunhiyi ŋatha, yana nhuma yurru marrtji gulk‐gulkthurranydja biyakana 10‐lilina, nhanŋu ŋunhiyinydja ŋatha gulk‐gulkthurra, bala wekaŋa ŋurikina yolŋuwu Godkalaŋuna djämamirriwu ga ŋurruwuykku yolŋuwu ga buku‐wurthapuywu ga dhä‐ŋäṉḏi'miriwwu, märr yurru walala yukurra gana' yana ḻukanydja ŋuriŋi malaŋuyu. ");
INSERT INTO gnn_vpl VALUES ("DT26_13","006_26_13","DEU","26","13","13","Ga dhurrwaraŋuru ŋuliŋurunydja ŋunhi nhe wekaŋala liŋguna Godku ŋäthili, nhenydja yurru waŋa Garraywalanydja bitjanna, ‘Garray, yaka ŋarra dhuḏi'yunmaraŋala ŋunhiyi nhuŋuwaynydja dhulŋuŋunydja ŋarrakuwaynydja ŋarra, wekaŋalanydja ŋarra ŋunhiyi nhokalaŋuwu djämamirriwuna ga ŋurikina ŋurruwuykkuna. Yakana ŋarra yana meṉguŋala ŋunhiyinydjayi rom, ŋunhi nhe ḻakaraŋala ŋarrakala 10‐buynydja mala‐wuḻkthunara. ");
INSERT INTO gnn_vpl VALUES ("DT26_14","006_26_14","DEU","26","14","14","Yaka ŋarra ḻukana nhuŋunydja ŋunhi dhulŋuŋunydja ŋuriŋi bäpurru'mirriyunydja waluyu, ga yaka ŋarra wekaŋala buku‐ŋal'yunarawu rakunygu ŋuriki. Ŋarranydja marrtjina dhäruk märraŋala nhuna, bukmakŋura yana ŋunhi nhe yukurra waŋa ḻakarama dhiyakuyi, ŋunhi ŋurruŋunydja dhulŋuŋunydja nhuŋuway yana Garray. ");
INSERT INTO gnn_vpl VALUES ("DT26_15","006_26_15","DEU","26","15","15","Nhäŋa ŋanapurrunhanydja nhuŋuwaynydja yolŋunha walalanha, bala goŋmirriyaŋana biyakana ŋanapurrunha, märr yurru wäŋanydja dhuwala ŋunhi nhe wekaŋala ŋanapurrunha bitjan ŋatha guḻku'mirriyirrina yurru dhikana wal'ŋu, bitjan yana liŋgu ŋunhi nhe dhawu'mirriyaŋala ŋanapurruŋgalaŋuwala märi'muwala.’” ");
INSERT INTO gnn_vpl VALUES ("DT26_16","006_26_16","DEU","26","16","16","Bala ŋayi Mawtjitj dhawar'yurrunanydja waŋana bitjarrana gam'. “Gäthuranydja dhuwalanydja nhokala Godthu waŋarryunydja waŋa yukurra nhumalanha bitjan, ‘Romgunydja ŋarrakalaŋuwu malthurra gal'ŋu yuwalkkuŋa yana’ bitjan, märr yurru nhuma yuwalkkuma wal'ŋu yana malthundja ŋurikiyi romgunydja. ");
INSERT INTO gnn_vpl VALUES ("DT26_17","006_26_17","DEU","26","17","17","Gäthuranydja nhuma yukurra waŋa bitjan, ‘Garraynydja dhuwala ŋilimurruŋgu Waŋarr.’ Nhumanydja ŋunhi dhawu'‐nherrara ŋunhi nhuma yurru dhäruk-märrama ga malthun, ga ŋayathama baṯ bitjan yurru nhanŋu romdja malanha. Waŋananydja nhuma bitjarra, ‘Ŋanapurru yurru djämanydja bitjan yana liŋgu ŋunhi nhaltjarra ŋayi Garrayyu nherrara ŋunhiyi rom malanha ŋanapurruŋgu,’ bitjarra nhuma waŋananydja. ");
INSERT INTO gnn_vpl VALUES ("DT26_18","006_26_18","DEU","26","18","18","Ga gäthuranydja ŋayi Garrayyu waŋana ḻakaraŋala nhumalanha bitjarra, ‘Nhumanydja dhuwala ŋarrakuway gal'ŋu dhulŋuŋu yolŋu'‐yulŋu. Nhuma yurru dhäruk-märrama ga rom ŋunhi ŋarraku, bukmak ŋunhi malanha rom ŋunhi ŋarra gurrunhara nhumalaŋgu.’ ");
INSERT INTO gnn_vpl VALUES ("DT26_19","006_26_19","DEU","26","19","19","Yo, bitjan ŋayi yurru goŋmirriyama yulŋunydja nhumalanha, ga nhumanydja yurru miṯtjinydja biyapulnha wal'ŋu bena dhikana miṯtji, djuḻkmaramana yurru nhuma wiripu‐guḻku'nhanydja miṯtjinha, märr yurru ŋuruŋu wiripu‐guḻku'yunydja nhämana nhumalanha, bala wokthunna yukurra Godkunydja yurru, waŋarr ḻakarama ŋanya waŋarrkuma yäkuna. Ga nhumanydja yurru yolŋu'‐yulŋunydja nhanŋuway gal'ŋu yana dhulŋuŋu, bitjan yana liŋgu ŋunhi ŋayi dhawu'mirriyaŋala ŋäthili.” ");
INSERT INTO gnn_vpl VALUES ("DT28_1","006_28_1","DEU","28","1","1","“Yo, ŋunhi nhuma yurru dhäruktja märrama ŋanya Garraynha, ga yuwalk gal'ŋu yana ŋayathama wal'ŋu baṯ bitjan nhanŋu rom ŋunhi ŋarra yukurra ḻakarama dhiyaŋu‐wala nhumalaŋgu, ga ŋayinydja yurru goŋmirriyamana nhumalanha biyapulnha wal'ŋu, yakana yurru wiripunydja miṯtji guḻku'yirri dhaŋaŋdhirri bitjan nhuma. ");
INSERT INTO gnn_vpl VALUES ("DT28_2","006_28_2","DEU","28","2","2","Märraŋa yana dhäruktja ŋanya Garraynha, bala nhuma yurru nhina ŋamathamana yukurra gal'ŋu. ");
INSERT INTO gnn_vpl VALUES ("DT28_3","006_28_3","DEU","28","3","3","Ŋayi yurru Garrayyunydja nhumalanha bitjan goŋmirriyama nhumalaŋgu wäŋa malanha ḻiw'marama yana, ");
INSERT INTO gnn_vpl VALUES ("DT28_4","006_28_4","DEU","28","4","4","ga nhumalaŋgu yurru djamarrkuḻiny'tja ŋuthan marrtji ŋamathirrina dhikana, ga wäyin malanha yurru guḻku'yirrina, mirithirrina miṯtji. ");
INSERT INTO gnn_vpl VALUES ("DT28_5","006_28_5","DEU","28","5","5","Ga ŋathanydja ŋuthanna yurru yukurra dhaŋaŋnha biyapulnha. ");
INSERT INTO gnn_vpl VALUES ("DT28_6","006_28_6","DEU","28","6","6","Ŋayipinydja yurru Garrayyunydja gäma nhumalanha goŋdhu, bitjan gunganhamirriyama ŋunhi nhe yurru wanhamala marrtji, ga lili nhe yurru roŋiyirri wäŋalili. ");
INSERT INTO gnn_vpl VALUES ("DT28_7","006_28_7","DEU","28","7","7","Ŋuli nhumalanha yurru marrtji miriŋuyu guwatjman, ŋayinydja yurru Garrayyunydja ŋunhiyinhana baḏuwaḏuyun warrpam'thunna yana miriŋunhanydja. Yo, miriŋunydja yurru marrtji waŋgany ŋurruk nhumalaŋgu, yurru gundupumanydja walala yurru ḻatju‐warr'yunna yana barrku'‐barrkuwatjthirrina yulŋunydja birrka'mirrililina wäŋalili malaŋulili. ");
INSERT INTO gnn_vpl VALUES ("DT28_8","006_28_8","DEU","28","8","8","Bitjan liŋgu ŋayi yurru Garrayyunydja ŋäthilimirriyama marrtji ŋathanydja dhika nhänydja nhumalaŋgu, ga ŋunhi nhuma yurru djäma bitjandhinydja ŋula nhä, bukmak yurru nhänydja malanha marrtji yukurra ḻatju'thirrina dhikana yana. Yo, ŋunhili wäŋaŋuranydja ŋunhi ŋayi wekaŋala nhumalaŋgu, nhuma yurru nhina djulŋithirrina dhikana wal'ŋu, galŋa‐djulŋithirrina. ");
INSERT INTO gnn_vpl VALUES ("DT28_9","006_28_9","DEU","28","9","9","Yo, ŋuli nhuma yurru dhäruk-märrama ŋanya Garraynhanydja, ga djäma ŋunhi nhaltjan ŋayi yurru ḻakarama waŋa nhumalanha, nhumanydja yurru ŋunhi yolŋu'‐yulŋu nhanŋuwaynha wal'ŋu Garraywuna yana. ");
INSERT INTO gnn_vpl VALUES ("DT28_10","006_28_10","DEU","28","10","10","Bala walala yurru wiripu‐guḻkuny'tja miṯtji birrka'mirriŋura wäŋaŋura dharaŋanna bitjanna yurru, ŋunhi nhumanydja djarr'yunara galkikunhara Garraywuna yolŋu walala nhanŋuwaynha, bala yurru walala borrk‐barrarirrina yulŋunydja nhumalaŋgu. ");
INSERT INTO gnn_vpl VALUES ("DT28_11","006_28_11","DEU","28","11","12","“Yo, ŋayi yurru Garrayyu ḻapmaramana ŋunha djiwarrny'tja, ga bitjanna liŋguna dhuŋgarra‐mandhirri yurru yukurra waltjaṉdhunydja dharyun, märr yurru borum ga ŋatha ŋula nhä ŋuthan ŋamathirrina gal'ŋu yana. Yakana nhuma yurru yukurra ŋäŋ'thun wiripuŋunhanydja yolŋunha ŋula nhäku; walalana yurru nhumalanhana ŋäŋ'thundja yukurra, liŋgu nhuma yurru yukurra ŋayathama biyapulnydja guḻku' dhaŋaŋdja. ");
INSERT INTO gnn_vpl VALUES ("DT28_13","006_28_13","DEU","28","13","13","Wiripu‐guḻkuny'tja yurru malthun marrtji nhumalaŋguna, ga nhumanydja yurru yakana yukurra munguyun walalanhanydja. Yakana yurru nhumalanhanydja ŋonuŋguma ŋula nhäyunydja romdhu. Nhumapi yana yurru ŋapaŋuranydja, wal'ŋu yana, yaka ŋoyŋura, ga wäŋanydja nhumalaŋgu yurru dhapirrknha wal'ŋu dhikana yanana, ŋuli nhuma yurru dhärukku malthun, dhäruk märramanydja dhuwalanydja dhäruk Garraywunydja ŋunhi ŋarra yukurra dhuwala ḻakarama nhumalaŋgu gäthura. ");
INSERT INTO gnn_vpl VALUES ("DT28_14","006_28_14","DEU","28","14","14","Yaka gonha'yurra dhuwalayinydja dhäruk ŋula waŋgany meṉguŋa. Yaka yana bilyurra Garraywalaŋuŋurunydja ga buku‐ŋal'yurra wiripuŋuwunydja waŋarrwu.” ");
INSERT INTO gnn_vpl VALUES ("DT28_15","006_28_15","DEU","28","15","15","“Ga ŋuli nhuma yurru yakanydja dhärukku malthun Garraywu, yana bilyundja, bala meṉgumanydja ŋunhiyi nhanŋu rom, nhenydja yurru märrama mari biyapul'nha bathalana, birrka'mirrina yurru nhä malanha nhuŋu yätjnha maḻŋ'thun yukurra. ");
INSERT INTO gnn_vpl VALUES ("DT28_16","006_28_16","DEU","28","16","16","Nhumalaŋgu wäŋa yurru ḻiw'marama ga dhika nhä malanha baḏuwaḏuyunna yätjthirrina. ");
INSERT INTO gnn_vpl VALUES ("DT28_17","006_28_17","DEU","28","17","17","Yakana yurru ŋathanydja yukurra ŋuthan ŋunhiliyi. ");
INSERT INTO gnn_vpl VALUES ("DT28_18","006_28_18","DEU","28","18","18","Nhumalaŋgu yurru yumurrkuny'tja ga ŋula nhä wäyin malanha ḻurrkun'nha yana, yakana guḻku', yalŋgina yana walala yurru yulŋunydja, yakana ŋuthanara manymakkunhara. ");
INSERT INTO gnn_vpl VALUES ("DT28_19","006_28_19","DEU","28","19","19","Ga ŋunhi nhe yurru marrtji wanhamalanydja ŋula, ga roŋiyirri nhe yurru lili, ŋayinydja yurru ŋunhi rom‐mäypayirrina yulŋunydja ŋula nhänydja malanha, ga ŋula nhä malanha nhe yurru warkthun yurru yätjthirrina wal'ŋu yanana, liŋgu yakana ŋayi yurru Garrayyu goŋmirriyama guŋga'yun nhumalanha ŋunhimalayinydja, dhäruk‐märranhamiriwlilinydja. ");
INSERT INTO gnn_vpl VALUES ("DT28_20","006_28_20","DEU","28","20","20","Yo, ŋuli nhuma yurru djäma yätjkumanydja, ŋuyulkthirrinydja nyinyaŋdhundja Garraywu, ŋunhiyi yurru wäŋanydja nhumalaŋgu yätjthirrina marimirriyirrina, mari‐yakaynha yukurra yurru djingaryun. Mirithirri nhuma yurru warkthundja yukurra ŋamathanharawunydja ŋurikiyi, yurru gulkuruna; bukmak yurru ŋunhi yätjthirrina yanana yulŋunydja, yana liŋgu ga warrpam'thun yurru nhumalanha baḏuwaḏuyun. ");
INSERT INTO gnn_vpl VALUES ("DT28_21","006_28_21","DEU","28","21","21","Birrka'mirrina yurru yolŋunydja walala murrmurryun marrtji liŋgu rerriyu birrka'mirriyuna, yakana yurru ŋula waŋgany yolŋu yukurra walŋa nhina. ");
INSERT INTO gnn_vpl VALUES ("DT28_22","006_28_22","DEU","28","22","22","Yolŋu yurru rakunydhirri gorrmuryinyarayu, ga biyapul ŋulwitjthu ŋula nhäyu, ga wiripu yurru yolŋu rumbal buḻ'‐buḻyun, bala rakunydhirrina. ");
INSERT INTO gnn_vpl VALUES ("DT28_23","006_28_23","DEU","28","23","24","Yo, wäŋanydja yurru dhuwala baṉḏanydhirri ŋathamiriwyirrina, ga munathany'tja wäŋa dhuwala yurru bitjanna ḏälthirrina bitjan guṉḏa, liŋgu ŋayi yurru Garrayyu yakana yänguma yukurra waltjaṉ. ");
INSERT INTO gnn_vpl VALUES ("DT28_25","006_28_25","DEU","28","25","25","“Ga bitjandhiyi miriŋunydja yurru lili marrtjina, bala walala yurru bumana yukurra nhumalanha; marrtjinydja walala yurru ŋunhi miriŋunydja waŋgany yana miṯtji, ga nhumanydja yurru gundupuma baḻaka'yunna birrka'mirrililina wäŋalili barrkuwatjthirri. Bala walala yurru yolŋuyunydja nhämana ŋunhiwalayi, bala barrarirrina bitjanna ŋurikiyi yindiwunydja mariwu. ");
INSERT INTO gnn_vpl VALUES ("DT28_26","006_28_26","DEU","28","26","26","Murrmurryunna nhuma yurru marrtji, ga ŋuriŋi wäyindhunydja malaŋuyu nhumalanha yurru ḻukana yukurra barrwaṉ'tja rumbalnydja; yakana yurru walalanha ŋula yolthu ŋaŋ'‐ŋaŋdhundja. ");
INSERT INTO gnn_vpl VALUES ("DT28_27","006_28_27","DEU","28","27","27","Yo, nhumalaŋgu rumbalnydja yurru warrpam'thunna ŋäkirrmarama djetjiyuna malaŋuyu ga djiraŋ'thuna, bitjan nhuma yurru yukurra wirrkthunmirrina bitjan liŋgu, ga yakana yurru ŋula yolthu nhumalanha baḏarraŋ'kumanydja. ");
INSERT INTO gnn_vpl VALUES ("DT28_28","006_28_28","DEU","28","28","28","Muḻkurrnydja yurru nhumalaŋgu bitjan bawa'mirriyirrina, ga wiripu‐guḻkuny'tja nhuma yurru bamba'‐bambayyirrina marrtji. ");
INSERT INTO gnn_vpl VALUES ("DT28_29","006_28_29","DEU","28","29","29","Waluwuynydja nhuma yurru marrtji yukurra bitjan dhä‐ŋal'ŋalyunna dhukarrwuna ḻarruma, bitjanna bitjan ŋuli bambay yolŋu, yurru yakana nhuma yurru maḻŋ'maramanydja. Wiripu‐guḻku'yunydja yurru yolŋuyu walalay manaŋirrina djaw'‐djawyunna nhumalaŋgu nhänydja malanha, ga bitjanna liŋgu nhuma yurru ŋayaŋu‐djawaryunna yukurra gänharayu ŋonuŋdhunydja romdhu malaŋuyu, ga bäyŋuna nhumalaŋgu ŋula yol guŋga'yunarawunydja ŋurikiyi. ");
INSERT INTO gnn_vpl VALUES ("DT28_43","006_28_43","DEU","28","43","43","“Yo, mari bathalana nhumalaŋgu yurru marrtjinydja, ŋuli nhe yurru yakanydja dhäruk‐märrama ŋanya Garraynha. Mulkuruna yurru yolŋu nhina nhumalaŋgala yukurra wäŋaŋuranydja, ga walala yurru ŋunhiyinydja miṯtji wuṉḏaŋarrnha mirithirrina, ga nhumanydja yurru ga yalŋgi'na miṯtji. ");
INSERT INTO gnn_vpl VALUES ("DT28_44","006_28_44","DEU","28","44","44","Walalana yurru rrupiya‐mäypamirriyirrinydja, ga nhumanydja yurru dhäparknha nhämiriwnha; bitjanna liŋguna nhumanydja yurru yukurra ŋäŋ'thunna walalanha ŋula nhäku rrupiyawunydja, yana liŋgu‐u‐u ga walalana yurru nhumalaŋgu buŋgawamirrinydja. ");
INSERT INTO gnn_vpl VALUES ("DT28_45","006_28_45","DEU","28","45","45","Ŋunhiyi marinydja malanha yurru marrtjina yana nhumalaŋgu, yana liŋgu ga warrpam'thun yurru nhumalanha baḏuwaḏuyun, liŋgu nhuma yaka yukurrana dhäruk märraŋala Garraynha nhumalaŋgu Waŋarrnha, yaka nhuma ŋayathaŋala yukurrana ŋunhiyi rom ŋunhi ŋayi wekaŋala nhumalaŋgu. ");
INSERT INTO gnn_vpl VALUES ("DT28_46","006_28_46","DEU","28","46","46","Yolŋuyu nhumalanha yurru nhäma, bala walala yurru waŋa bitjanna, ‘Godthu walalanha yukurrana dhä‐ḏir'yurrunana, liŋgu walala gonha'yurruna ŋanya ga djäma ŋula nhä yätjnha rom.’ ");
INSERT INTO gnn_vpl VALUES ("DT28_47","006_28_47","DEU","28","47","47","Yo, Garrayyunydja wirrki warray wal'ŋu yana goŋmirriyaŋala nhumalanha, yurru nhumanydja yaka warray nhanŋu djälthina, yaka warray nhuma dhäruk märraŋala ŋanya ŋayaŋu‐djulŋithina; yaka nhuma djäma yukurrana nhanŋu ŋamakurru' rom. ");
INSERT INTO gnn_vpl VALUES ("DT28_48","006_28_48","DEU","28","48","48","Bala nhuma yurru djämanydja yukurra dhiyakuyina malaŋuwu miriŋuwuna, walalana yurru marrtjinydja, bala djaw'‐djawyunna nhumalanha bitjan djämamirrina walalaŋguway. Nhuma yurru yukurra marrya'yirrina ga ŋanhdharkthirrina, bitjan nhuma yurru nhina yukurra girri'miriwnha ŋula nhämiriwnha. Bitjan nhumalanha yurru ṉiṉ'ṉiṉmaramana marrtji ŋonuŋgumana bala ŋuriŋi romdhuna, yana liŋgu ga binydjitjthirri nhuma yurru ŋuriŋiyi. ");
INSERT INTO gnn_vpl VALUES ("DT28_49","006_28_49","DEU","28","49","62","“Walala yurru wiripuna yolŋu miṯtji marrtji bunharawu nhumalaŋgu, ŋunhina miṯtji mulkuruna yolŋu ŋunhi ŋayi yukurra waŋa wiripuna dhäruk. Walala yurru marrtji ḻiw'marama wäŋana nhumalaŋgu, bala nhuma yurru murrmurryundja marrtji ŋuriŋiyinayi djaṉŋarryuna marrya'yuna. Yo, ŋuli nhuma yurru yakanydja dhäruk-märrama Garraynha, ga ŋayathama baṯ bitjandja rom nhanŋu, ŋunhi nhe yurru yaka märr‐ŋal'yun yäkulili Garraywala, nhumanydja yurru murrmurryunna marrtji bitjanna birrka'mirriyuna rerriyu, yana ḻiŋgu ga märr yurru ḻurrkun'nha walŋamirrinydja ḏäpthun. ");
INSERT INTO gnn_vpl VALUES ("DT28_63","006_28_63","DEU","28","63","64","“Yo, wirrki ŋayi yana Garraynydja ḏukṯuk nhumalaŋgu goŋmirriyanharawunydja, ga yuwalk yana ŋayi yurru nhumalanha baḏuwaḏuyundja warrpam'thun, liŋgu nhuma yaka ŋanya dhäruk märraŋala; ŋayinydja yurru nhumalanha Garrayyunydja bitjan ḻatjuwarr'maramana bena‐wala barrkulilina wäŋalili, bala nhuma yurru yukurra buku‐ŋal'yundja ŋula yolkuna wiripuŋuwuna waŋarrwu. ");
INSERT INTO gnn_vpl VALUES ("DT28_65","006_28_65","DEU","28","65","66","Yakana nhuma yurru nhina yukurra mäwaya'ŋura, ga bäyŋuna nhumalaŋguwaynydja yurru yukurra wäŋa djingaryun. Bitjanna liŋgu nhuma yurru yukurra nhina galŋa‐yätjthirrina dhaŋgaḏirryunna nhäyu malaŋuyu romdhu. ");
INSERT INTO gnn_vpl VALUES ("DT28_67","006_28_67","DEU","28","67","67","Bitjanna liŋgu walu ŋupan ga munha ŋupan nhuma yukurra yurru barrarirrinydja nhina nhäku malaŋuwu, bitjan nhuma yurru marrmarryunmirrina barrariyunydja, ga ŋayaŋunydja yurru nhumalaŋgu ḏuŋ'ḏuŋdhunna wilwilyunna barrariyunydja ŋunhi nhe yurru ŋula nhä nhämanydja.” ");
INSERT INTO gnn_vpl VALUES ("DT30_1","006_30_1","DEU","30","1","1","Bala ŋayi Mawtjitjthu dhawar'maraŋalanydja waŋana bitjarrana gam'. “Yo, ḻakaraŋalanydja ŋarra nhumalaŋgu märrma' dhukarrnydja, ga nhumapina yurru djarr'yundja. Ŋuli nhuma yurru dhäruk-märrama ŋanyapinyay Garraynha, nhumalanhanydja ŋayi yurru goŋmirriyama; ga ŋuli nhuma yurru yakanydja dhäruk ŋanya märrama, ga nhumalaŋgunydja yurru marrtji mari bathalana gal'ŋu biyapul'nha. Ga ŋunhi yurru dhuwalayi malanha yätj rom maḻŋ'thundja, ga nhina nhuma yurru yukurra be‐wala barrku wäŋaŋura birr', bala nhuma yurru guyaŋirrina ŋuliŋuruyinydja, balayi roŋiyirri dhuwalayina dhäruk ŋunhi ŋarra yukurra ḻakarama nhumalaŋgu gäthura ŋurikiy maṉḏaŋuwuy dhukarrwuy maṉḏaŋuwuy märrma'wuy. ");
INSERT INTO gnn_vpl VALUES ("DT30_2","006_30_2","DEU","30","2","4","Yo, ŋuli nhuma yurru ga nhumalaŋgala yarraṯaŋuru mala‐wunharawuy ŋunhi roŋiyirri bilyun nhanukala Garraywala, ga dhäruk ŋanya märrama warrpam'thun yana, ŋayinydja yurru Garraynydja nhumalaŋgu mel‐wuyunna; ŋayi yurru roŋinyamarama nhumalanha ŋunhamala liŋgu wäŋalili ŋamakurru'lili, ga biyapul nhuma yurru nhina yukurra ŋamathama wal'ŋu, ");
INSERT INTO gnn_vpl VALUES ("DT30_5","006_30_5","DEU","30","5","5","ga biyapul yurru ŋayi ŋunhiyi wäŋanydja nhumalaŋguwayyi, bitjan yana liŋgu bitjarra ŋayi Garrayyu dhawu'‐nherrara nhumalaŋgalaŋuwala märi'muwala ŋäthili. ");
INSERT INTO gnn_vpl VALUES ("DT30_6","006_30_6","DEU","30","6","6","Ŋayi yurru Garrayyunydja wekama yuṯana gal'ŋu ŋayaŋunydja nhumalaŋgu, märr yurru nhuma ḏukṯukthirri dhärukku nhanŋu märranharawu; nhuma yurru märramana nhanŋu dhäruktja, liŋgu nhuma yuwalk yukurra märr‐ŋamathirri Godku, ");
INSERT INTO gnn_vpl VALUES ("DT30_7","006_30_7","DEU","30","7","7","bala yurru ŋunhiyi malanha marinydja marrtji yukurra ŋurikina nhumalaŋgalaŋuwu miriŋuwuna, ŋurikina walalaŋgu ŋunhi nhumalaŋgu walala yukurra ŋaramurryirri ga ŋonuŋguma ŋayathama, ");
INSERT INTO gnn_vpl VALUES ("DT30_8","006_30_8","DEU","30","8","8","ga biyapul nhuma yurru dhäruktja ŋanya märramayi, ga ŋayathamana nhanŋu romdja Garraywu. ");
INSERT INTO gnn_vpl VALUES ("DT30_9","006_30_9","DEU","30","9","9","Nhinanydja nhuma yurru yukurra ŋamathamana wal'ŋu yana djamarrkuḻi' guḻku'mirrina ga ŋatha guḻku'mirrina dhika nhä guḻku'mirrina nhuma yurru nhinana yukurra yana. ");
INSERT INTO gnn_vpl VALUES ("DT30_10","006_30_10","DEU","30","10","10","“Yo, ŋayipinydja yurru Garrayyunydja bitjan goŋmirriyama nhumalanha, ŋunhi nhuma yurru dhäruk ŋanya märramanydja bukmakkumanydja; yana nhuma yurru yuwalkkuŋa yulŋunydja bilyurranydja Garraywalana nhanukalaynha, ga malthurra yuwalkkuŋana gal'ŋu nhanŋuwaynha. ");
INSERT INTO gnn_vpl VALUES ("DT30_11","006_30_11","DEU","30","11","14","Dhuwalayinydja rom yaka wuṉḏaŋarr, ga yaka barrku be‐wala, märr yurru nhuma yukurra be ḻarrumanydja dhiyakuyi dhärukku. Godkunydja dhuwala dhäruk dhuwala bäyma galki, dhuwalina ŋayi bäyma ŋayaŋuŋurana nhokala, ga waŋana ŋayi yukurra dhurrwarakurrunydja nhumalaŋgala. Liŋguna nhuma marŋgimirrina Godkalaŋuwu romgunydja, bala biyaka djämana yana yukirriya ŋuriŋiyi Godkala dhärukthu. ");
INSERT INTO gnn_vpl VALUES ("DT30_15","006_30_15","DEU","30","15","15","“Yo, gäthuranydja dhuwala märrma' dhukarrnydja marrtji ŋorra bala, waŋganydja ŋamakurru' ga waŋganydja yätj, waŋganydja ŋunhi dhukarr walŋa‐wekanharamirri, ga wiripunydja ŋunhinydja ga rakunynha dhukarr, ŋuli nhe yurru marrtji ŋuliwitjandhiyinydja nhenydja yurru rakunydhirrina. Ga nhumapi yurru djarr'yundja yukurra wanhawitjan nhuma yurru marrtji. ");
INSERT INTO gnn_vpl VALUES ("DT30_16","006_30_16","DEU","30","16","16","Ŋunhi nhuma yurru dhäruk-märrama ga malthun Garraywunydja nhokalaŋuwu Godkunydja, ŋunhi nhuma yurru märryu‐ḏapmaramanydja gal'ŋu ŋanya, ga ŋayathama baṯ bitjandja romnha nhanŋu warrpam'thun yana, nhumanydja yurru nhinana yukurra walŋana ga ŋamathamana. Yo, ŋayi yurru Garrayyunydja geŋmirriyama nhumalanha, bala nhuma yurru nhinana yukurra ŋunhilinydja wäŋaŋura ŋunhi nhuma yurru galki gulŋiyirrina ŋunhimalayi wäŋalili. ");
INSERT INTO gnn_vpl VALUES ("DT30_17","006_30_17","DEU","30","17","18","Ga ŋuli nhuma yurru mäkiri'‐yarryundja ŋuyulkthirrinydja Garraywalaŋuwu dhärukku, yakanydja nhuma yurru ŋäma rirrakay ga dhäruk ŋanya; ŋuli nhuma yurru yaka dhärukku malthun nhanŋu, yana bilyundja yurru, ga märr‐ŋal'yun wiripuŋuwunydja waŋarrwu, nhumalanhanydja ŋayi yurru baḏuwaḏuyunna, yakana nhuma yurru yana ŋamathama nhina yukurra ŋunhiliyi wäŋaŋura ḻatju'ŋuranydja. ");
INSERT INTO gnn_vpl VALUES ("DT30_19","006_30_19","DEU","30","19","19","“Dhuwala ŋarra yukurra waŋana nhumalanha yulŋunydja, ‘Ma' biyaka djarr'yurrana dhukarrnydja nhepina. Wanhaŋumi dhika nhumanydja yurru romŋura nhina yukurra? . . . ŋunhilimi Godkala romŋura, märr ŋayi yurru nhumalanha goŋmirriyama? . . . ga gäma yurru nhumalanha ḻatju'kuma dhika wal'ŋu? . . . Bay' ŋunhilimi wiripuŋuŋura romŋura ŋoy‐djingaryunamirriŋura ŋiniya, ŋoy‐yätjthinyamirriŋura? Wanhawitjan dhika nhenydja yurru dhukarrkurru marrtji? . . . Ŋuliwitjandhiyi walŋamirrikurru dhukarrkurru? Bay' ŋunhiyi rakunydhinyaramirrikurru dhukarrkurru ŋiniya? Way walala, yakana nhuma yurru marrtji märrma'kurrunydja dhukarrkurru rrambaŋikumanydja. Djarr'yurranydja dhukarrnydja ŋunhiyi walŋamirri yana, liŋgu Godtja mäkiri'‐witjun yukurra yana. Ŋunhi nhe yurru djarr'yun dhukarrnydja, ŋunhiyi romdja ŋunhi nhepi yurru djarr'yun maḻŋ'thundja yurru yuwalkthi ŋunhiyi. Yo, nhiniyanydja yukirriya Godkala yana romdhunydja, märr yurru nhuma nhinanydja yukurra walŋana yana, nhumapi ga nhumalaŋgu djamarrkuḻi' ga nhumalaŋgu gutharra'mirriŋu walala. ");
INSERT INTO gnn_vpl VALUES ("DT30_20","006_30_20","DEU","30","20","20","Märr‐ŋamathiya biyaka nhumalaŋgalaŋuwu waŋarrwu Godkunydja, ga dhäruk märraŋa ŋanya. Mam'thurra yana wal'ŋu Garraywalanydja muṉḏataraŋa, ga nhenydja yurru yukurra nhina weyinŋumirrina walŋa; weyinŋumirrina yanana nhuma yurru yukurra nhinanydja ŋunhilinydja wäŋaŋura ŋunhi ŋayi Garrayyu ŋayipi dhawu'‐nherrara nhumalaŋgalaŋuwa märi'muwa walalambala.’” ");
INSERT INTO gnn_vpl VALUES ("DT31_1","006_31_1","DEU","31","1","1","Mawtjitjtja ŋunhi worruŋuna, bala ŋayi waŋanana yukurrana bukmakkala ŋunhi Yitjuralpuyŋuwala yolŋu'‐yulŋuwala, bitjarrana gam', ");
INSERT INTO gnn_vpl VALUES ("DT31_2","006_31_2","DEU","31","2","2","“Djawuḻpa'na ŋarranydja dhuwala, dhuŋgarranydja ŋarraku dhuwala guḻku'na 120‐na; yakana biyapulnydja ŋarra yurru nhumalaŋgu ŋurruŋu. Märr‐yawungunydja ŋayi Garrayyu ŋarranha waŋa yaka'yunna, yakana yurru ŋarra buḏapthun mayaŋ'kunydja Djodanbuyŋunydja, yakana be ŋarra boŋguŋu gärri ŋunhamalanydja wäŋalili Gaynanlilinydja. ");
INSERT INTO gnn_vpl VALUES ("DT31_3","006_31_3","DEU","31","3","3","Garrayyuna yurru ŋayipina nhumalanha ŋurru‐warryundja, ŋayina boŋguŋu nhumalanha gäŋu ga ŋilitjurru ŋunhawalanydja wäŋalili ya'. Nhuma boŋguŋu baymatthurru buwayakkuŋuna, dhawar'maraŋuna ŋunhayinydja miṯtjinha ŋunhi walala yukurra nhina ŋunhalami wäŋaŋura, bala nhumana yurru yukurra nhinanydja ŋunhala wäŋaŋura. Ŋayi Djatjuwa nhumalaŋgu boŋguŋu ŋurruŋunydja, bili Garrayyunydja ŋanya djarr'yurruna. ");
INSERT INTO gnn_vpl VALUES ("DT31_4","006_31_4","DEU","31","4","5","Garray dhuwala nhumalaŋgalanydja gali'ŋura, ŋayi boŋguŋu nhumalanhanydja guŋga'yurru; nhuma boŋguŋu yana baymatthurruna wal'ŋu dhawar'maraŋuna bukmaknha yana yolŋunhanydja walalanha rumbal‐winya'yunmaraŋuna, bili ŋayipi yawungu Garrayyu waŋa nhumalanha bitjanarawuyinydja. ");
INSERT INTO gnn_vpl VALUES ("DT31_6","006_31_6","DEU","31","6","6","Yakana nhuma boŋguŋu yana ŋula barrarinydja. Ŋoy‐wuṉḏaŋarrthiya yana yulŋunydja, ŋayaŋu‐nherraṉmiyanydja Garraywala yana, liŋgu Garray ŋayipi nhumalaŋgu boŋguŋu malthurru bämarany'tja, yakana ŋayi boŋguŋu nhumalanha gonha'yurrunydja ŋula gänaŋulilinydja.” ");
INSERT INTO gnn_vpl VALUES ("DT31_7","006_31_7","DEU","31","7","7","Bala yana ŋayi ŋuliŋurunydja dhurrwaraŋuru Mawtjitj wäthurruna Djatjuwawuna, bala nherrara ŋanyana gumurrlili ŋurikala yolŋu'‐yulŋuwalanydja malalili, Yitjuralpuyŋuwala milma, bala waŋanana nhanukala bitjarrana, “Djatjuwa, djingaryurranydja ŋoy‐wuṉḏaŋarrthiya yana yukirriya. Yakana nhe yurru barrariyanydja, yana yukirriya ŋayaŋu‐yuwalkthiyanydja ŋanyapinyay Garraynha. Nhena yurru gämanydja‐wala dhuwalanha yolŋu'‐yulŋunhanydja walalanha, ŋurru‐warryun ŋunhamalayinydja wäŋalili ŋunhi Garrayyu wekaŋala walalaŋgalaŋuwala märi'muwala ŋunhala be baman'; gärrinyamaraŋunydja nhena boŋguŋu walalanha, bala walala yurru nhinana yukurra ŋunhalana. ");
INSERT INTO gnn_vpl VALUES ("DT31_8","006_31_8","DEU","31","8","8","Ŋayipinydja Garrayyunydja yurru nhuna mel‐warryun; ŋayi boŋguŋu nhokala galki. Yakana nhe yurru barrariyanydja, liŋgu yakana ŋayi yurru nhuna gonha'yun gänaŋulilinydja.” ");
INSERT INTO gnn_vpl VALUES ("DT31_14","006_31_14","DEU","31","14","14","Ŋuliŋurunydja dhurrwaraŋuru Garray waŋana Mawtjitjkala bitjarra, “Mawtjitj, walunydja nhuŋu dhuwala galkina rumbal‐winya'yunarawuna; yakana nhe yurru märr‐weyindja nhina. Gatjuy, garr'yurra Djatjuwanha räli, nhuma maṉḏa yurru marrtji djunama Buṉbulili, ga ŋunhalayi ŋarra yurru ŋarrapi dhäruktja wekama nhanŋu Djatjuwawu.” Bala maṉḏa yuwalkthi Mawtjitjtja ga Djatjuwanydja marrtjina ŋunhamalayi, ");
INSERT INTO gnn_vpl VALUES ("DT31_15","006_31_15","DEU","31","15","15","ga ŋunhalayi Garray maḻŋ'thunmaranhaminana maṉḏakala maŋanmirri, ŋayi yukurrana djingaryurrunanydja galki dhurrwaraŋura wäŋaŋura. ");
INSERT INTO gnn_vpl VALUES ("DT31_16","006_31_16","DEU","31","16","16","Bala yana Garraynydja waŋana Mawtjitjkala bitjarrana, “Walunydja dhuwala galkina nhuŋu rakunydhinyarawuna, ga walalanydja dhuwala yolŋunydja walala boŋguŋu marrtjina ŋunhawalana‐wala wäŋalilina gärri. Ŋunhalanydja boŋguŋu walala ŋarrakala ŋapa‐wilyurruna, gonha'yurruna boŋguŋu ŋarranhanydja; walala boŋguŋu yukirriyi buku‐ŋal'yurru wiripu‐guḻku'wuna waŋarrwu walalaŋgu. ");
INSERT INTO gnn_vpl VALUES ("DT31_17","006_31_17","DEU","31","17","17","Ga ŋunhi walala boŋguŋu bilyurrunydja, gonha'yurrunydja ŋarranha boŋguŋu, bala ŋarranydja boŋguŋu wirrkina walalaŋgu ŋaramurryi, bala ŋarranydja boŋguŋu biyakuyi walalanhanydja gonha'yurruyi yana. Bala marina ŋula nhäna yurru walalaŋgu buna, walala yurru yukurra nhinanydja galŋa‐yätjthirrina ŋuriŋina yätjthuna malaŋuyu, yurruna walala yurru marŋgithirrinydja, ŋetjnha mulka, bala bitjanna yurru waŋa, ‘Yuwalk muka dhuwalayinydja maḻŋ'thurruna ŋilimurruŋgu galŋa‐yätjthinyamirrinydja rom, liŋgu Garraynydja yakana dhiyalami galki ŋilimurruŋgala; liŋguna ŋayi ŋilimurrunha gonha'yurrunana, liŋgu ŋilimurruway yana ŋapa‐wekanhamina nhanŋunydja.’ ");
INSERT INTO gnn_vpl VALUES ("DT31_18","006_31_18","DEU","31","18","18","Yo, yakana yana ŋarranydja yurru djäka walalaŋgu, ŋunhi yurru walala yukurra birrka'mirriwunydja waŋarrwu buku‐ŋal'yun,” bitjarra ŋayi Garrayyu ḻakaraŋalanydja. ");
INSERT INTO gnn_vpl VALUES ("DT31_19","006_31_19","DEU","31","19","19","Yo, bala ŋayi Garrayyunydja wekaŋalana yuṯanydja ŋunhi manikay Mawtjitjkalana, bitjarrana ŋayi waŋana, “Ma', wukirrina marrtjiya dhuwalayi manikaynydja, märr nhe yurru marŋgikumana yolŋu'‐yulŋunha. ");
INSERT INTO gnn_vpl VALUES ("DT31_20","006_31_20","DEU","31","20","20","Ŋarra marŋgi ŋurikiyi yolŋuwunydja walalaŋgu. Galkina ŋarra yurru walalanha gämana ŋunhawalayinydja wäŋalili, ḻatju'lilinydja wal'ŋu, ga nhinanydja walala yurru yukurra ŋunhalayina ḻatju'ŋurana dhika ŋatha‐guḻku'mirriŋurana, galŋa‐djulŋithirrina, yurru galkina yana walala yurru bilyun, bala meṉgumana ŋarranhanydja, ga buku‐ŋal'yun wiripuŋuwuna waŋarrwu. Ŋäthilinydja dhawu' walala nherrara, ŋunhi walalanydja yurru ŋarrakuway yana, bala walala yurru bilyunna, ŋanydjaḻa'yunna ŋarrakalaŋuŋurunydja, ");
INSERT INTO gnn_vpl VALUES ("DT31_21","006_31_21","DEU","31","21","21","bala marina yurru bathalana marrtjinydja yukurra walalaŋgu. Ga miyamandja walala yurru yukurra manikaynydja dhuwala, bala guyaŋinyamirriyamana walalanha yurru ŋuriŋiyi, ŋunhi walalanydja gatjpaḻ'yurruna ŋarrakalaŋuŋuru, bala dhuwurr‐yätjthinana. Yuwalk yana ŋarra marŋgi walalaŋgalaŋuwu ŋayaŋuwunydja, ŋunhi ŋayaŋu walalaŋgunydja djarrpi' yana wal'ŋu,” bitjarra ŋayi Garray waŋananydja. ");
INSERT INTO gnn_vpl VALUES ("DT31_22","006_31_22","DEU","31","22","22","Bala ŋayi Mawtjitjthunydja manikaynydja ŋunhiyi wukirrina marrtjina ŋunhi manikaynydja malanha djorra'lilina, ga ŋuriŋi bili yana waluyu ŋayi walalanha marŋgikuŋalanydja yukurrana. ");
INSERT INTO gnn_vpl VALUES ("DT31_23","006_31_23","DEU","31","23","23","Bala ŋuliŋurunydja Garray waŋana Djatjuwawalana bitjarrana, “Dhärriya nhenydja yukirriya ŋoy‐wuṉḏaŋarrthiya yana. Nhe yurru gämanydja, bala ŋilitjan dhuwala yolŋunhanydja walalanha Yitjuralpuyŋunhanydja ŋunhamalayina wäŋalili, bitjan liŋgu yana ŋunhi ŋarrapi nhumalanha wäwunmirriyaŋala. Ŋarranydja yurru ŋunhiliyi nhokala, bämara'yun yurru marrtji nhuna.” Bitjarra ŋayi Garray waŋananydja. ");
INSERT INTO gnn_vpl VALUES ("DT32_1","006_32_1","DEU","32","1","3","Yo, Garrayyu wekaŋala Mawtjitjkala yuṯana manikay, ga ŋayinydja ḻakaraŋala yolŋu'‐yulŋuwana bitjarrana, “Ŋäkana nhumanydja dhiyali djiwarr'ŋuranydja, ga nhumanydja dhuwali munatha'ŋura mäkiri'‐witjurrana, ŋarra yurru ḻakaramana; Garraynhana ŋarra yurru yäku birrŋ'marama yindikumana, ŋunhi ŋayi ŋilimurruŋgu Waŋarr biyapulnydja‐wala wal'ŋu. ");
INSERT INTO gnn_vpl VALUES ("DT32_4","006_32_4","DEU","32","4","5","Garraynydja nhumalaŋgu gunganharamirri ŋayi, wuṉḏaŋarr ŋayi mirithirri bitjan guṉḏa, giṯthunamiriw yana; Ḻatju'kuma yana wal'ŋu ŋayi ŋuli djämanydja, dhapirrkkumana, yurru nhanukalay ŋanya yolŋu'‐yulŋuyunydja bitjarra yätjkuŋala. Nhumanydja ŋunhi ŋanya märr‐yätjkuŋala warray; nhuma gonha'yurrunana ŋanya, bala nhuma yukurra djämana yätjnha wal'ŋu mirithirrina, djarrpi'na rom malanha. ");
INSERT INTO gnn_vpl VALUES ("DT32_6","006_32_6","DEU","32","6","6","Nhumanydja dhuwala yolŋu'‐yulŋu ḻiya‐dhumukmirrina yanana. Nhäku nhuma yukurra Garraynhanydja bitjandhiyi ŋayaŋu‐yätjkuma? Ŋayinydja ŋunhi nhumalaŋgu bäpa'mirriŋu, ŋayi nhumalanha djäma miṯtjinydja dhaŋaŋguŋala. ");
INSERT INTO gnn_vpl VALUES ("DT32_7","006_32_7","DEU","32","7","9","Birrka'yurra roŋiyiya baman'ŋuwuy ŋurukuy, ga dhä‐wirrka'yurra bäpa‐ŋalinha walalanha, walala yurru nhumalaŋgu ḻakaramana, ŋunhi nhaltjarra Garrayyu djarr'yurruna ŋilimurrunha Djaykupkalaŋuwuŋu walkur‐märranharanha, märr yurru ŋilimurru nhanŋuwaynha gal'ŋu yana dhulŋuŋuna yolŋu walala. ");
INSERT INTO gnn_vpl VALUES ("DT32_10","006_32_10","DEU","32","10","10","Ŋayi ŋilimurrunha maḻŋ'maraŋalanydja ŋunhala ŋanhdharkŋura, ga djäka ŋayi ŋilimurruŋgu, goŋ‐nherraṉmina ḻatju'kuŋala yana, bitjan liŋgu yana bitjan ŋuli ḏamala yukurra nhina yaluŋura, djäka dhangi'yun ŋuli nhanŋuway yothunha. ");
INSERT INTO gnn_vpl VALUES ("DT32_11","006_32_11","DEU","32","11","11","Bala ŋayi ŋuli ḏamalayu ŋäṉḏi'mirriŋuyunydja ḏur'yunna ŋuliŋuruyi yaluŋurunydja, bala ŋayi ŋuli buṯthunna ŋoykurruna, bala garrwarkumanydja ŋanya ŋuli binbarryuna. Marŋgikumana ŋuli ŋanya yukurra buṯthunarawuna. ");
INSERT INTO gnn_vpl VALUES ("DT32_12","006_32_12","DEU","32","12","12","Bitjarra yukurrana Garrayyunydja ŋilimurrunha gäŋala lili ḻatju'kuŋala dhika wal'ŋu, yakana ŋilimurru galkina gandarrŋura. Ga yakana ŋula wiripuŋuyu ŋilimurrunha waŋarryu guŋga'yurrunanydja. ");
INSERT INTO gnn_vpl VALUES ("DT32_13","006_32_13","DEU","32","13","14","Ŋayipina Garrayyu gäŋala ŋilimurrunha lili, ŋayipina ŋilimurruŋgu wekaŋala dhuwalanydja wäŋa ŋatha‐guḻku'mirrinydja, ḻatjuny'tja dhikanydja wal'ŋu ŋanya wäŋa, wäyin‐guḻku'mirrinydja ga wuŋay'mirrinydja, ga borummirri dhika nhämirri. ");
INSERT INTO gnn_vpl VALUES ("DT32_15","006_32_15","DEU","32","15","15","“Yo, nhumanydja ḻukunydjayinana bena, bala buku‐dhumukthina warray Garraynhanydja meṉguŋalana. Nhuma gonha'yurrunana ŋapana wekaŋala ŋunhinhanydja waŋarrnha ŋunhi ŋayi djäma nhumalanha, bala nhuma buku‐ŋal'yurruna wiripuŋuwuna yukurrana waŋarrwu. ");
INSERT INTO gnn_vpl VALUES ("DT32_16","006_32_16","DEU","32","16","16","Ŋayipinydja Garraynydja nhumalaŋgu ḏukṯuk yana, nhuma yurru nhanŋuway yana wal'ŋu dhulŋuŋu yolŋu walala, bitjarra ŋayi ŋunhi ŋayaŋu‐yätjthinana yulŋunydja nhumalaŋgala, ŋunhi nhuma wekanhamina nhumalanhay nhuma wiripuŋuwu waŋarrwu. ");
INSERT INTO gnn_vpl VALUES ("DT32_17","006_32_17","DEU","32","17","17","Nhuma yukurrana buku‐ŋal'yurrunanydja ŋurikiyinayi mokuywuna, ga wekaŋala mundhurrnydja marrtjina ŋurikiyina walalaŋgu mokuywuna; Yaka yana yukurrana ŋäthilinydja ŋilimurruŋgu märi'munydja walala ŋuliwitjarrayi mokuywalanydja manikaykurru märr‐ŋal'yurruna yukurrana. ");
INSERT INTO gnn_vpl VALUES ("DT32_18","006_32_18","DEU","32","18","18","Bala nhuma meṉguŋalana ŋunhiyinydja waŋarrnha gal'ŋu, ŋunhi ŋayi walŋakuŋala nhumalanha. ");
INSERT INTO gnn_vpl VALUES ("DT32_19","006_32_19","DEU","32","19","19","Yo, ŋayi nhäŋalanydja nhumalanha ŋunhimalayi ŋunhi nhuma yukurrana buŋgul warkthurruna, mokuywu buku‐ŋal'yurruna, bala ŋayi ḏiltjina wekaŋala nhumalaŋgunydja, liŋgu ŋayi ŋuriŋiyinydjayi romdhu ŋaramurryinana wirrkina. ");
INSERT INTO gnn_vpl VALUES ("DT32_20","006_32_20","DEU","32","20","20","Waŋananydja ŋayi bitjarrana, ‘Yakana ŋarra yurru biyapulnydja walalanha guŋga'yun ŋunhimalayinydja, märr walala yurru marŋgiyirri, ŋunhi ŋuriŋiyinydja walalaŋgalaynydja romdhu gäma ŋuli yukurra marina bathalana gal'ŋu. Liŋgu dhuwalayinydja walala yolŋu'‐yulŋu ŋayaŋu‐ḏälmirrina, ga mayali'‐wilkthunaramirrina; Yakana walala yurru yuwalkkuma gal'ŋu malthun ŋarrakuwaynydja. Walala gonha'yurrunana ŋarranhanydja, bala malthurruna ŋula yolkuna, wiripuŋuwuna waŋarrwu. ");
INSERT INTO gnn_vpl VALUES ("DT32_21","006_32_21","DEU","32","21","21","Ŋarrapinydja yukurra ŋunhiyinhayi wiripuŋunhanydja waŋarrnha nyinyaŋdhunna nhäma, ŋaramurryirrina bitjanna. Yaka ŋunhiyinydja walala yuwalk waŋarr. ");
INSERT INTO gnn_vpl VALUES ("DT32_22","006_32_22","DEU","32","22","22","Wirrki yana wal'ŋu walala ŋarranha märr‐yätjkuŋalanydja ŋuriŋi malaŋuyu be maḏayin'thunydja, ŋunhi walala yukurra ŋayathama baṯ bitjan.’ ");
INSERT INTO gnn_vpl VALUES ("DT32_23","006_32_23","DEU","32","23","25","“Yo, yuwalk yana yurru marinydja bathala marrtji yukurra yolŋu'‐yulŋuwunydja; walala yurru marrya'yirrina wirrkina, bala nhina yurru yukurra borrk‐barrarirrina, guḻku'na yurru mirithirrina yolŋu walala marrtji murrmurryun rerriyunydja ga moḻ'ŋuyu ḻäwunharayu. ");
INSERT INTO gnn_vpl VALUES ("DT32_26","006_32_26","DEU","32","26","27","Ŋarra bini dhawar'maranha warray warrpam' warray yulŋunydja walalanha, yurru yaka ŋarra yurru bitjandhi, märr yurru ŋayi yaka miriŋunydja ŋurr'yunmirri, yanapi ŋayina bumara baḏuwaḏuyurruna ŋarrakunydja yolŋunha walalanha. ");
INSERT INTO gnn_vpl VALUES ("DT32_28","006_32_28","DEU","32","28","28","“Nhumanydja dhuwalanydja ŋarrakunydja yolŋu walala, be nhäna ḻiyamiriwnha, dhuŋamirrina, yakana nhuma marŋgi yuwalkŋuwu. ");
INSERT INTO gnn_vpl VALUES ("DT32_29","006_32_29","DEU","32","29","29","Ŋunhi bini nhuma gaḏamanmirrinydja, nhumanydja bini ŋunhi dharaŋanna muka, ŋunhi nhumalaŋgalaynydja romdhu bitjan gäma yukurra nhumalanha marililina ga rakunylilina romlili. ");
INSERT INTO gnn_vpl VALUES ("DT32_30","006_32_30","DEU","32","30","30","Yo, guḻku' mirithirri nhuma miṯtjinydja dhika wal'ŋu, yurru nhumalanha walala djuḻkmaraŋala warray ḻurrkun'thunydja yana, Ŋunhi bini ŋayi Godthu yaka nhumalanha gananna, walalanydja bini ŋuriŋiyi miriŋuyunydja walalay yakana nhumalanha djuḻkmaranha. ");
INSERT INTO gnn_vpl VALUES ("DT32_31","006_32_31","DEU","32","31","31","Liŋgu ŋunhiyi Yitjuralwunydja miṯtjiwu waŋarr biyapul warray gal'ŋu ganydjarr‐ḏumurru, ga ŋayinydja ŋunhi walalaŋgunydja waŋarr be nhä warray, ganydjarrmiriw warray yana. ");
INSERT INTO gnn_vpl VALUES ("DT32_32","006_32_32","DEU","32","32","33","Yo, ŋunhiyi miriŋu ŋayipinydja yätjnha yana mayali'‐wilkthunaramirrina, balanyarana bitjan nhäŋiniŋ'nha borum, ga bäpiwuna ŋäṉarr. ");
INSERT INTO gnn_vpl VALUES ("DT32_34","006_32_34","DEU","32","34","34","“Yo, Garrayyunydja ŋuli guyaŋirri warray yukurra ŋunhi nhaltjarra ŋuriŋiyi miriŋuyu djäma yätjkuŋala, bala ŋayi galkunna yukurra yulŋunydja. ");
INSERT INTO gnn_vpl VALUES ("DT32_35","006_32_35","DEU","32","35","35","Yuwalk yana ŋayi yurru miriŋunhanydja buma buwayakkumana ŋuriŋinydja waluyu ŋunhi ŋayipi yukurrana ḻakaraŋala. Yo, ŋunhiyi miriŋu yurru galkirrina, galkina ŋanya yurru baḏuwaḏuyundja warrpam'nha yana Garrayyunydja. ");
INSERT INTO gnn_vpl VALUES ("DT32_36","006_32_36","DEU","32","36","36","Yo, ŋayi yurru Garrayyunydja nhämana marrtji nhanŋuwaynydja yolŋu'‐yulŋunha, walala yukurra yurru nhina ganydjarrmiriwnha yana dhika nhämiriwnha, bala ŋayi yurru walŋakumana yana walalanha ŋuliŋuruyi miriŋuwalanydja goŋŋuru; Ŋayi yurru mel‐wuyunna ŋurikinydja walalaŋgu yolŋu'‐yulŋuwu ŋunhi walala yukurra yurru märr‐yal'yun nhanŋuway wal'ŋu. ");
INSERT INTO gnn_vpl VALUES ("DT32_37","006_32_37","DEU","32","37","37","“Yo, ŋayi yurru Garrayyunydja waŋa dhä‐wirrka'yun bitjan, ‘Wäy, wanhakana dhika ŋunhi nhumalaŋgu waŋarrnydja mala? . . . ŋunhinydja walala ŋunhi nhuma yukurrana märr‐yuwalkthina, märr‐nherraṉmina walalaŋgu? ");
INSERT INTO gnn_vpl VALUES ("DT32_38","006_32_38","DEU","32","38","38","Ma' biyaka waŋiya wäthurra märrliliyaŋa ŋurikalayi waŋarrwalanydja walalaŋgala, märr walala yurru guŋga'yun nhumalanha; walalana yurru nhumalanha guŋga'yun walŋakumanydja be. ");
INSERT INTO gnn_vpl VALUES ("DT32_39","006_32_39","DEU","32","39","39","Ŋarra dhuwala ŋarrapi gäna Waŋarrnydja, yuwalkŋunydja gal'ŋu waŋarr, yakana ŋula wiripunydja Waŋarr nhini yukirri. Ŋarra ŋuli ŋarrapi yana wekama walŋa, ga ŋarrapi yana ŋuli gombuma ŋunhiyi walŋanydja; Ŋarra ŋuli walŋakuma yolŋunha, ga bitjandhi ŋarra ŋuli walŋanydja biḏiwiḏitjkumayi. Ŋarra ŋuli djämana‐wala yana, yakana yurru ŋarranha ŋula yolthu ḏaḏawmaramanydja. ");
INSERT INTO gnn_vpl VALUES ("DT32_40","006_32_40","DEU","32","40","42","Ŋarra dhuwala ŋarrapi walŋa‐ḏikṯiktja Waŋarr. Yuwalk yana ŋarra yurru ŋunha miriŋunhanydja baḏuwaḏuyunna, liŋgu ŋarra yurru baḏuwaḏuyunna warrpam'thunna yana ŋunhinydja yolŋu'‐yulŋunha ŋunhi walala yukurra nyinyaŋdhun ŋarraku; warrpam'thunna yana walala yurru murrmurryundja, yakana yurru ŋula waŋgany winya'yundja.’ ");
INSERT INTO gnn_vpl VALUES ("DT32_43","006_32_43","DEU","32","43","43","“Way nhuma dhuwali wäŋa malanha bukmak, märr‐ŋal'yurra Godkalaŋumirriwala yana yolŋu'‐yulŋuwalanydja. Liŋgu ŋayi yurru Godthunydja baḏuwaḏuyun warrpam'thunna ŋunhinhanydja yolŋu'‐yulŋunha ŋunhi walala yukurra murr'marama yolŋu'‐yulŋunha nhanŋu. Yuwalk yana ŋayi yurru buku‐ruŋinyamarama ŋunhiyi nhanŋu miriŋunhanydja walalanha, yurru ŋayi yurru bäy‐ḻakarama buwayakkuma yätjtja malanha ŋuriki nhanukalayŋumirriwunydja wal'ŋu yolŋu'‐yulŋuwu.” Yo, maṉḏa Mawtjitjtja ga Djatjuwanydja barkparkthurruna dhuwalayina yuṯana manikay, marŋgikuŋalana yukurrana Garraywuna yolŋu'‐yulŋunha. ");
INSERT INTO gnn_vpl VALUES ("DT32_45","006_32_45","DEU","32","45","45","Ga dhawar'maraŋalanydja ŋayi Mawtjitj waŋana bitjarrana gam', ");
INSERT INTO gnn_vpl VALUES ("DT32_46","006_32_46","DEU","32","46","46","“Malthurra yukirriya dhiyaku yana liŋgu Garraywalaŋuwu romgunydja malaŋuwu, ŋunhi ŋarra liŋgu ḻakaraŋala yukurrana nhumalaŋgu. Mulkiyanydja baṯ biyaka yana, ga marŋgikuŋa marrtjiya bala nhumalaŋguway yumurrku'nhanydja, märr walalanydja yurru bitjandhi malthun marrtji bala nhanŋuway yana Garraywu dhärukkunydja. ");
INSERT INTO gnn_vpl VALUES ("DT32_47","006_32_47","DEU","32","47","47","Dhuwalanydja dhäruk malanha ŋarra yukurra ḻakarama nhumalaŋgu yaka ŋula mayali'miriw; walŋamirrina yana dhäruktja dhuwala. Märraŋa walala, bala malthurranydja nhanŋuwaynha dhärukkunydja, yurruna nhuma yurru nhina weyindja, ŋamathamana wal'ŋu yana, ŋunhalanydja wäŋaŋura ŋunhi nhuma boŋguŋu gärri ŋunhawala wäŋalili.” Mawtjitj bitjarrayinydja yukurrana waŋana, bala dhawar'yurrunana nhanŋu dhäruktja. ");
INSERT INTO gnn_vpl VALUES ("DT32_48","006_32_48","DEU","32","48","48","Ga ŋuriŋi liŋgu waluyu, Garrayyu waŋana Mawtjitjnha, ");
INSERT INTO gnn_vpl VALUES ("DT32_49","006_32_49","DEU","32","49","49","“Gatjuy nhe marrtjiya nhäyikayu, ŋunha bukulili Nepulili, ŋunha galki Djarikulili, yurru dhipala makarrlili mayaŋ'lili. Ŋal'yurranydja nhe yurru ŋunhimalayi bukulili, bala nhäŋana marrtjiya ŋunhayina wäŋa Gaynanbuynha. Galki yolŋunydja walala boŋguŋu marrtjina buḏapthurruna ŋunhamalayina wäŋalili, yurru nhenydja nhämana yurru marrtji yana, ga rakunydhirri nhe yurru ŋunhalayina bukuŋurana; ");
INSERT INTO gnn_vpl VALUES ("DT32_50","006_32_50","DEU","32","50","50","bitjan yana liŋgu nhenydja yurru, bitjarra ŋayi wäwa'mirriŋu nhuŋu Yärun rakunydhina bukuŋurayi yana, ");
INSERT INTO gnn_vpl VALUES ("DT32_51","006_32_51","DEU","32","51","51","bili nhuma maṉḏa ŋunhi yaka märr‐yuwalkthina yuwalkkuŋala wal'ŋu ŋarranha. Yo, ŋunhala ŋunhi nhumalaŋgu gapunydja maḻŋ'thurruna guṉḏaŋuru, nhumanydja baḏatjurruna dhäruk ŋarraku milma yolŋuwala walalaŋgala, bala yakana walala nhäŋala ŋarranhanydja wal'ŋu dhunupanydja nhumalaŋgala. ");
INSERT INTO gnn_vpl VALUES ("DT32_52","006_32_52","DEU","32","52","52","Nhe yurru wäŋanydja nhäma ŋulaŋuruna bili barrkuŋuruna, yurru yakana nhe boŋguŋu gärrinydja ŋunhamalayi wäŋalili.” ");
INSERT INTO gnn_vpl VALUES ("DT33_1","006_33_1","DEU","33","1","29","Yo, Mawtjitjtja ŋunhi Garraywu yolŋu, galkiŋuwuynha wal'ŋu, ga waŋana ŋayi marrtjina dhurrwara‐ḏaw'yurrunanydja, dhäruktja nherrara walalaŋgu Yitjuralpuyŋuwunydja, waŋga'‐waŋganygu yana bäpurru'wu ga bäpurru'wu, malalili ga malalili, ḻakaraŋalanydja ŋayi yukurrana dhäruktja wekaŋala Garraywala yäkuyu. ");
INSERT INTO gnn_vpl VALUES ("DT34_1","006_34_1","DEU","34","1","3","Ga dhawar'yurrunanydja ŋayi waŋanharaŋurunydja Mawtjitj, bala yana ŋayi gonha'yurrunana ŋunhiyinydja yolŋu'‐yulŋunhanydja, bala marrtjinana ŋayi nhinana bala, ŋal'‐way ŋal'yurruna ŋunhimalayi bukulilina, ga ŋulaŋuruna ŋayi nhämanydja marrtji warrpam' ŋunhiyi wäŋa Gaynanbuynydja. ");
INSERT INTO gnn_vpl VALUES ("DT34_4","006_34_4","DEU","34","4","4","Bala ŋayi Garrayyunydja wäŋana marrtji Mawtjitjkala milkuma bitjanna, “Yo, ŋunhana wäŋanydja nhäŋana. Dhuwalana ŋunhiyinydja wäŋa ŋarra ŋunhi dhawu'‐nherrara Yipurayimgu ga Yitjakku ga Djaykupku, ŋunhi ŋarra yurru wekama walalaŋgalaŋuwu yumurrku'wuna. Ŋarranydja nhuŋu marrtji yana dhuwala milkuma; nhämana nhe marrtji yurru yana, yurru yakana nhe gärrinydja yurru ŋunhimalayi wäŋalili.” ");
INSERT INTO gnn_vpl VALUES ("DT34_5","006_34_5","DEU","34","5","5","Bala ŋayi ŋuliŋurunydja Mawtjitjtja ŋunhi Garraywunydja yolŋu rakunydhinana ŋunhiliyina bäyma bukuŋurana, galkina ŋunhiliyina wäŋaŋura. ");
INSERT INTO gnn_vpl VALUES ("DT34_6","006_34_6","DEU","34","6","6","Bala ŋayipina Garrayyuna ŋanya dholkuŋalanydja munatha'liliyaŋalanydja; yakana ŋula yol yolŋu nhanukalaŋu marŋgi moluwunydja Mawtjitjkalaŋu. ");
INSERT INTO gnn_vpl VALUES ("DT34_7","006_34_7","DEU","34","7","7","Yo, Mawtjitjtja djawuḻpa'na wal'ŋu wirrkina, dhuŋgarranydja nhanŋu 120‐na ŋunhi ŋayi rakunydhinanydja, yurru nhanŋu rumbalnydja wuṉḏaŋarr warray, bäyma warray, bitjan yuṯana ŋayi yolŋu, ga yakana ŋayi bambaythinanydja ŋula. ");
INSERT INTO gnn_vpl VALUES ("DT34_8","006_34_8","DEU","34","8","8","Ga yolŋunydja walala Yitjuralpuyŋunydja ŋunhi ŋäthinyaminana, guyaŋinana manapara ŋanyana Mawtjitjnhana, yana liŋgu ga waŋgany ŋaḻindi djuḻkmaraŋala. ");
INSERT INTO gnn_vpl VALUES ("DT34_9","006_34_9","DEU","34","9","9","Yo, ŋäthilinydja ŋunhi Mawtjitjthu yiŋarra'yurruna Djatjuwanha, ŋayina yurru ŋurrulili wapthun, bala Djatjuwanydja ḻiya‐djambatjthinana wirrkina, liŋgu Garrayyu ŋanya ganydjarr wekaŋala ŋurikiyi djämawu. Bala yana ŋuriŋi yolŋu'‐yulŋuyu dhäruktja yukurrana märraŋalana ŋanya Djatjuwanha, malthurrunana nhanŋuwaynha yana dhärukku; walala ŋayathaŋala yukurrana romdja malanha ŋunhi baṯ bitjarrana, ŋunhi Garrayyu wekaŋala Mawtjitjkala. ");
INSERT INTO gnn_vpl VALUES ("DT34_10","006_34_10","DEU","34","10","10","Yo, Mawtjitjtja ŋunhi galkiwuynha wal'ŋu Garraywalaŋuwuynha; nhanukala Garraynydja ŋuli waŋanha mel‐yunupa, maṉḏa ŋuli buku‐nhänharaminya waŋanharaminyanydja. ");
INSERT INTO gnn_vpl VALUES ("DT34_11","006_34_11","DEU","34","11","12","Yakana wiripuŋuyunydja ŋula dhäruk‐gänharamirriyu yolŋuyu milkuŋala Garraywunydja ganydjarr, ga djäma ŋutuny'tja wal'ŋu rom, balanyaranydja rom bitjarra ŋayi Mawtjitjthu djäma ŋunhala Yetjippuyŋuwala buŋgawawala, milma bukmakkala ŋurikala Yitjuralpuyŋuwala. ");
INSERT INTO gnn_vpl VALUES ("JS1_1","007_1_1","JOS","1","1","1","Dhurrwaraŋuru ŋuliŋurunydja ŋunhi ŋayi Godku djämamirri yolŋu rakunydhina Mawtjitj yäku, bala ŋayi Godthu waŋana Djatjuwanhana, ŋunhinhana ŋunhi ŋayi Mawtjitjku guŋga'yunaramirri ŋäthili, ga bitjarrana ŋayi waŋananydja gam' Djatjuwawalanydja. ");
INSERT INTO gnn_vpl VALUES ("JS1_2","007_1_2","JOS","1","2","2","“Djämamirrinydja ŋarraku Mawtjitjtja rakunynha liŋguna. Dhiyaŋunydja‐wala nhe yurru ga bukmak dhuwala yolŋu walala marrtjina yana buḏapthunna yurru balakurru Djodangurru mayaŋ'kurru, marrtjinydja nhuma yurru yana‐wala ŋunhimalayina wäŋalili ŋunhi ŋarra dhawu'mirriyaŋala nhumalaŋgu. ");
INSERT INTO gnn_vpl VALUES ("JS1_3","007_1_3","JOS","1","3","4","Yo, ŋunhiyinydja wäŋa ŋarra yurru wekama nhumalaŋguna Yitjuralpuyŋuwuna bukmakkumana, beŋuru bili ŋanhdharkŋuru ga yana liŋgu ga‐ga‐ga‐a‐a ga ŋunha wapthun bukulili Lipananlili, nhumalaŋguwaynha yana ŋunhiyinydja wäŋa. ");
INSERT INTO gnn_vpl VALUES ("JS1_5","007_1_5","JOS","1","5","5","Nhenydja Djatjuwa yurru dhärra wuṉḏaŋarrthirrina yana, bili yakana wiripuŋuyunydja yurru yolŋuyu djuḻkmarama nhuna. Ŋarranydja yurru nhokala bitjanna liŋguna galkina yana, bitjanna bitjarra ŋarra ŋäthili Mawtjitjkala. Yakana ŋarra yurru nhuna ganandja. ");
INSERT INTO gnn_vpl VALUES ("JS1_6","007_1_6","JOS","1","6","6","Yaka nhe barrariyanydja, yana ŋoy‐wuṉḏaŋarrthiyana biyakana, bili nhena yurru dhuwala gäma yolŋu'‐yulŋunhanydja ŋurru‐warryun ŋunhimalayi wäŋalilinydja ŋunhi ŋarra dhawu'mirriyaŋala ŋäthili ŋunhiyi nhumalaŋgalaŋuwala märi'muwala walalaŋgala. ");
INSERT INTO gnn_vpl VALUES ("JS1_7","007_1_7","JOS","1","7","7","Yana wuṉḏaŋarrthiyana dhärriyanydja barrarimiriwnha, ga märraŋa dhäruktja marrtjiya bukmaknha yana nhänha malaŋunha romnhanydja ŋunhi ŋayi Mawtjitjthu wekaŋala marrtjina nhokala, yana marrtjiya ŋuliyina liŋguna dhukarrkurru bala yana, ga yakana ŋula gatjpaḻ'yurranydja, märr nhe yurru nhina yukurra ŋamathamana yana‐wala. ");
INSERT INTO gnn_vpl VALUES ("JS1_8","007_1_8","JOS","1","8","8","Biyaka liŋgu waŋiyanydja yukirriya dhuwali bili yana dhäruk, Garraywu wal'ŋu rom, ga ḻakaraŋa marrtjiya wiripuwurrumbalanydja; guyaŋiyanydja yukirriya ṉiṉ'thurra wal'ŋu biyaka yana yulŋunydja munha‐ŋuparra ga walu‐ŋuparra, märr yurru nhe djämanydja dhunupa marrtji yana, bitjan liŋgu bitjan dhuwali djorra'yu yukurra ḻakarama. Balakurruyinydja nhe yurru nhina rom‐dhunupana yana nhämiriwnha, ŋamakurru'na. ");
INSERT INTO gnn_vpl VALUES ("JS1_9","007_1_9","JOS","1","9","9","“Gatjuy yana marrtjiyana, ga djämana marrtjiya barrarimiriwnha. Yakana barrariyanydja ŋula nhäkunydja malaŋuwu ŋunhi, ga yakana ḏaḏawyurranydja ŋuriŋiyi ŋunhi yurru ŋayi ŋula nhänydja maḻŋ'thun, liŋgu ŋarranydja dhuwala ŋarrapi Garray nhuŋunydja God; ŋarranydja yurru nhokala bitjan liŋgu yana, wanhamala nhe yurru marrtji yukurra.” Bitjarra ŋayi yukurrana Godthu ḻakaraŋalanydja Djatjuwawala. ");
INSERT INTO gnn_vpl VALUES ("JS1_10","007_1_10","JOS","1","10","10","Bala yana ŋayi Djatjuwayu waŋana, dhäruknha wekaŋala ŋurru'‐ŋurruŋuwalana ḏarramuwurruŋgala bitjarrana, ");
INSERT INTO gnn_vpl VALUES ("JS1_11","007_1_11","JOS","1","11","11","“Gatjuy marrtjiyana walala wäŋakurru ŋula ya' ḻiw'maraŋa, ga ḻakaraŋa marrtjiya ŋurupa yolŋuwana walalambala, walala yurru girri'‐ŋamathirrina ŋathana märrama djoṉguma marrtji, bili ŋilimurru boŋguŋu ḻurrkun'tja walu djuḻkmaraŋu marrtjina buḏapthurruna‐wala yana ŋuruku mayaŋ'ku Djodanbuyŋunydja. Ŋilimurru yurru marrtjina‐wala yana gärrina ŋunhamalanydja wäŋalili, bala märramana ŋilimurru yurru ŋunhayinydja wäŋanha, liŋgu ŋilimurrumbalay ŋunha wäŋa, ŋunhi ŋayipi Garrayyu yukurra wäŋanydja ŋunhiyi wekama ŋilimurrunha.” ");
INSERT INTO gnn_vpl VALUES ("JS1_12","007_1_12","JOS","1","12","12","Bala Djatjuwa waŋanana ḻurrkun'kala bäpurru'wala, waŋganydja miṯtji Ropin mala, ga wiripunydja Gäd mala, ga wiripu‐guḻku'wala ŋunhi Manatjawala malawala, ga bitjarra ŋayi waŋananydja. ");
INSERT INTO gnn_vpl VALUES ("JS1_13","007_1_13","JOS","1","13","13","“Guyaŋiya walala ŋunhi nhaltjarra Mawtjitjthu nhumalaŋgala ḻakaraŋala, ŋayi waŋananydja bitjarra gam', ‘Godthu yurru nhumalaŋgu wekamanydja dhuwala makarr wäŋa, dhuwala gali' mayaŋ' yurru nhumalaŋgunydja wäŋa nhinanharawu,’ bitjarra. ");
INSERT INTO gnn_vpl VALUES ("JS1_14","007_1_14","JOS","1","14","14","Yo, nhumalaŋgu yumurrku' ga miyalk walala ga wäyin walala, walalanydja yurru dhiyala yukurra nhina galkundja nhumalaŋgu, yurru nhuma ḏarramuwurrunydja bukmak yurru buḏapthunna malthun ŋanapurruŋguna. Nhuma yurru marrtji guŋga'yun dhuwala nhumalaŋguway wäwa‐ŋalinha walalanha ya', ");
INSERT INTO gnn_vpl VALUES ("JS1_15","007_1_15","JOS","1","15","15","ga yana liŋgu Garrayyu wekama yurru walalaŋgu dhuwali wäŋana walalaŋguna nhinanharawu. Nhuma yurru buŋanydja marrtjiya rrambaŋi yana bukmakkurru wäŋakurru, gukuŋa dhuwali miriŋunha, ŋunhi walala yukurra nhina dhiyalami wäŋaŋura yätjmirrina yanana. Ga ŋunhi yurru nhuma bukmaknha dhawar'marama, djuḻkmaramana wal'ŋu yurru, bala yana ŋuliŋurunydja nhuma yurru roŋiyirrina lili, ga nhinana yukurra yurru dhiyala nhumalaŋgalay nhuma wäŋaŋuranydja.” ");
INSERT INTO gnn_vpl VALUES ("JS1_16","007_1_16","JOS","1","16","16","Ga walalanydja buku‐roŋiyinmaraŋala bitjarra, “Ŋanapurru yurru malthunna‐wala yana, ŋunhi nhe nhaltjan yurru waŋa ŋanapurruŋgala, ga marrtji ŋanapurru yurru wanhamala nhe yurru ŋanapurrunha djuy'yun. ");
INSERT INTO gnn_vpl VALUES ("JS1_17","007_1_17","JOS","1","17","17","Ŋanapurru yukurra yurru malthun nhuŋuway dhärukkunydja, bitjan yana liŋgu bitjarra ŋanapurru yukurrana dhärukku malthurruna nhanŋu Mawtjitjku, ga bukumirriyamanydja ŋanapurru yurru Godnha, märr ŋayi yurru Garraynydja nhokala galki bitjan yana liŋgu, bitjanna bitjarra ŋayi yukurrana galkithina Mawtjitjkala. ");
INSERT INTO gnn_vpl VALUES ("JS1_18","007_1_18","JOS","1","18","18","Dhärriya wuṉḏaŋarrthiya, ga yakana ŋula beyaṉiyiyanydja.” Bitjarra walala yukurrana waŋana ŋuriŋi ŋurru'‐ŋurruŋuyu ḏarramuwurruyu Djatjuwanhanydja. ");
INSERT INTO gnn_vpl VALUES ("JS2_1","007_2_1","JOS","2","1","1","Bala ŋayi ŋuliŋurunydja dhurrwaraŋuru Djatjuwayu djuy'yurruna märrma'nhana yolŋunha maṉḏanha mel'ŋunhanydja, bitjarrana ŋayi waŋananydja gam' maṉḏanha. “Gatjuy marrtjiya, buḏapthurrana dhiyaku mayaŋ'kunydja, ga nhäŋa marrtjiya ŋunhiyi wäŋa milthurra. Ga biyakayi maḻŋ'maraŋa wäŋanydja ŋunhiyi Djarikunydja yäku.” Bala maṉḏa yana marrtjinana dhunupana yulŋunydja. Yo, marrtjinanydja maṉḏa ŋunhi Djarikulili, bala yana nhinananydja maṉḏa ŋunhiliyi waŋganygala miyalkkalanydja wäŋaŋura, yäkuwala Rayapkala, yurru dhäykanydja ŋunhi yaka yana ŋamakurru', balanyara ŋayi marramba'‐ḏumurru ŋunhiyi yulŋunydja. ");
INSERT INTO gnn_vpl VALUES ("JS2_2","007_2_2","JOS","2","2","2","Bala walalanydja gonha nhäŋala warray maṉḏanha, bala ḻakaraŋala buŋgawawana yolŋuwa bitjarrana, “Way yolŋu maṉḏa dhuwala bay', mel'ŋu maṉḏa marrtjina lili ŋulaŋuru Yitjuralwala malaŋuru.” ");
INSERT INTO gnn_vpl VALUES ("JS2_3","007_2_3","JOS","2","3","3","Bala ŋayi ŋuriŋi buŋgawayunydja djuy'yurruna dhäruknha djunama Rayapkalanydja bitjarra, “Gäŋa maṉḏanha lili ŋi', ŋunhiyinha mel'ŋunha maṉḏanha, ŋunhi maṉḏa yawungu gärri nhokala wäŋalili, liŋgu maṉḏanydja marrtji yawungu ŋunhi wäŋa milthun ŋilimurruŋgu.” ");
INSERT INTO gnn_vpl VALUES ("JS2_4","007_2_4","JOS","2","4","4","Yurru ŋayinydja ŋuriŋi dhäykayunydja maṉḏanha ŋäthili warray yana djuḻuḻ'maraŋala, bala ŋayi bitjarrana ḻakaraŋalanydja, “Ŋe, yuwalk warray maṉḏa yawungu bunanydja dhiyala ŋarraku, yurru ŋarranydja yaka marŋgi maṉḏaku, wanhaŋuwuy maṉḏa ŋunhi yolŋu maṉḏa. ");
INSERT INTO gnn_vpl VALUES ("JS2_5","007_2_5","JOS","2","5","5","Yurru ŋuriŋiyi bili waluyu maṉḏa ŋarraku wäŋanydja dhuwala gonha'yuna, marrtjinya bala dhawaṯthunanydja bathalakurruna dhurrwarakurru, yurruna dhuwala dhurrwaranydja dhaḻ'yuna. Yakana ŋarra marŋgi wanhawitjarrana dhika maṉḏa marrtjina. Gatjuy marrtjiyana walala, ḻundu‐ŋuparrana maṉḏanha, galki mulka nhuma yurru maṉḏanha dhuwala yana yulŋunydja.” ");
INSERT INTO gnn_vpl VALUES ("JS2_6","007_2_6","JOS","2","6","6","Bitjarrana ŋayi yukurrana ŋuriŋi miyalkthunydja ḻakaraŋala walalaŋgu, yurru ŋunhiyi ḏarramunydja maṉḏanha ŋunhi bäyma nhanukalay wäŋaŋura ŋurikala miyalkkala, yurru ŋunha garrwar wal'ŋu bala'ŋura maṉḏa yukurrana ŋorrananydja, djuḻuḻ'maranhara nhanukuŋu ga ŋäkirrmaranharanydja mulmuwuy. ");
INSERT INTO gnn_vpl VALUES ("JS2_7","007_2_7","JOS","2","7","7","Yo, ŋäkulanydja walala ŋunhi dhäruktja ŋanya ŋunhiyi miyalknha, bala yana gundupuŋalana, ḻundu‐ŋuparana ŋunhiyi mel'ŋunhanydja maṉḏanha, gatjpu'yurrunana bala walala gundupuŋalanydja maḻŋ'maranharawuna maṉḏaku. ");
INSERT INTO gnn_vpl VALUES ("JS2_8","007_2_8","JOS","2","8","8","Yo, ŋorranha warray maṉḏa bini yulŋunydja ŋunhiliyi garrwarnydja, yurru ŋayinydja maṉḏanha ŋuriŋi miyalkthunydja marrtjina, ga waŋana bitjarra warray, ");
INSERT INTO gnn_vpl VALUES ("JS2_9","007_2_9","JOS","2","9","9","“Marŋgi ŋarranydja dhuwala ŋunhi dhuwalanydja wäŋa Garrayyu wekaŋala nhumalaŋguway yana. Bukmak dhuwala yolŋunydja walala dhiyalami barrarirrina yukurra nhumalaŋgu. ");
INSERT INTO gnn_vpl VALUES ("JS2_10","007_2_10","JOS","2","10","10","Bukmakthu ŋanapurru ŋäkulanydja, ŋunhi nhumalaŋgala waŋarryunydja Godthunydja nhumalanha walŋakuŋala warray, dhawaṯmaraŋala nhumalanha beŋuru ŋunhi Yetjipŋurunydja, ga dhukarr warray ŋayi baṉḏany'kuŋala nhumalaŋgu buḏapthunarawu marrtjinyarawu gapukurru, ga biyapul ŋayi nhumalanha guŋga'yurrunanydja ganydjarr‐wekaŋalanydja, bala nhuma djuḻkmaraŋalana wiripu‐guḻku'nhanydja malanha ŋunhi walala ŋuli yukurranha nhinanha ŋunhala bala ḻaypa, wiripuŋura gali'ŋura mayaŋ'ŋura. ");
INSERT INTO gnn_vpl VALUES ("JS2_11","007_2_11","JOS","2","11","11","Liŋguna ŋanapurru ŋäkulanydja yukurrana, bala ŋanapurru dhuwala wirrkina barrarinanydja wal'ŋu, liŋgu nhumalaŋgunydja Waŋarr ŋunhi biyapul warray wal'ŋu, ŋayinydja ŋunhi God ŋuruku djiwarr'wu ga dhiyaku munatha'wu. ");
INSERT INTO gnn_vpl VALUES ("JS2_12","007_2_12","JOS","2","12","13","Ŋanapurrunydja dhuwala marŋgina ŋunhi nhumana yurru djuḻkthun dhiyakuyinydja wäŋawu wal'ŋu, ga ŋarranydja djäl nhumalaŋgu, nhuma yurru walŋakuma ŋanapurrunha, ŋarranha ga ŋarraku bäpa'mirriŋunha ga ŋäṉḏi'mirriŋunha ga djamarrkuḻi'nha. Waŋiya maṉḏa ŋarranha dhawu'mirriyaŋa yulŋunydja ŋi', ŋunhi nhuma boŋguŋu ŋanapurrunha yaka buŋunydja, ŋunhi nhuma boŋguŋu lili marrtji baḏuwaḏuyunarawu dhiyakuyi wäŋawu.” Bitjarra ŋayi ŋunhi miyalktja waŋana. ");
INSERT INTO gnn_vpl VALUES ("JS2_14","007_2_14","JOS","2","14","14","Ga maṉḏanydja ŋunhi mel'ŋunydja bitjarra nhanŋu waŋana, “Yaka ḻakaraŋanydja dhiyakuyyi ŋula yolkalanydja walalaŋgala ŋi'. Ŋilinyu boŋguŋu nhumalanha walŋakuŋu, ŋunhi boŋguŋu ŋanapurru Yitjuralpuyŋuyunydja miṯtjiyu marrtji baymatthurru warrpam'thurruna buwayakkuŋuna dhuwalanydja wäŋa, ŋunhi ŋayi boŋguŋu Garrayyu wekaŋu dhuwalayi wäŋa goŋlili ŋanapurruŋgalaynha wal'ŋu.” ");
INSERT INTO gnn_vpl VALUES ("JS2_15","007_2_15","JOS","2","15","15","Yo. Ŋurikiyinydja miyalkkunydja wäŋa galki ḻoḻuŋura wal'ŋu gunganhamirriŋurana, yurru garrwarnha wal'ŋu, bala ŋayi ŋuriŋi miyalkthunydja maṉḏanha ŋunhi mel'ŋunhanydja maṉḏanha dhuryunmaraŋala raki'yuna marrtjina bala, yana liŋgu ga ŋunha gali' warraŋul mulkana wäŋa Djariku. ");
INSERT INTO gnn_vpl VALUES ("JS2_16","007_2_16","JOS","2","16","16","Bala ŋayi waŋana maṉḏanha bitjarra, “Gatjuy marrtjiyana maṉḏa bala, ga djuḻuḻ'yurra bukulili, ga galkurranydja märr‐weyin nhiniyanydja ŋunhili, yana liŋgu‐u‐u, ga ŋunhi walala yurru roŋiyirrina ḻarrunharapuyŋu lili wäŋalilina, bala nhumanydja yurru marrtjina‐wala.” ");
INSERT INTO gnn_vpl VALUES ("JS2_17","007_2_17","JOS","2","17","18","Bala maṉḏa ŋunhi mel'ŋunydja maṉḏa waŋana bitjarrana ŋurikala miyalkkalanydja, “Ŋunhi ŋanapurru boŋguŋu marrtjinydja lili dhipala bunharawunydja, ga nhenydja boŋguŋu ḏapmaraŋu raki'yu miny'tjiyunydja miku'yu dhipala gay' windalili, märr boŋguŋu ŋanapurru nhäŋu. Ga märraŋunydja nhe boŋguŋu, ḻuŋ'maraŋunydja gurruṯu'mirrinha warrpam' yana nhuŋuway nhe dhipalayi nhokalay buṉbulilinydja, märr ŋilinyu boŋguŋu nhumalanha walŋakuŋu. ");
INSERT INTO gnn_vpl VALUES ("JS2_19","007_2_19","JOS","2","19","20","Ŋunhina liŋgu walala boŋguŋu yolŋu'‐yulŋu walŋathinydja, ŋunhi walala boŋguŋu nhini'‐nhini yukirri dhiyali raki'‐miku'mirriŋura buṉbuŋura.” ");
INSERT INTO gnn_vpl VALUES ("JS2_21","007_2_21","JOS","2","21","21","“Yo, ŋamakurru' dhuwalinydja,” bitjarrana ŋayi miyalktja, bala dhunupana maṉḏanydja marrtjinana yana. Ga dhunupana ŋayi ŋuriŋi miyalkthunydja märraŋala miku'na raki' miny'tji, bala ŋal'‐maraŋala windalili ḏapmaraŋala. ");
INSERT INTO gnn_vpl VALUES ("JS2_22","007_2_22","JOS","2","22","22","Yo, bala maṉḏa mel'ŋunydja maṉḏa waṉḏinana nhinana bala‐a‐a, djuḻuḻ'‐way bukulilina, ga nhinananydja maṉḏa ŋunhiliyi ḻurrkun' walu galkurruna. Walalanydja yukurrana ŋunhi djämamirrina buŋgawawunydja ḻarruŋalana‐a‐a, ga bäyŋuna maḻŋ'maraŋala, bala roŋi'‐ruŋiyina balayi Djarikuliliyi. ");
INSERT INTO gnn_vpl VALUES ("JS2_23","007_2_23","JOS","2","23","23","Bala yana maṉḏa mel'ŋunydja maṉḏa buḏapthurrunana mayaŋ'kuna, bala djar'tjaryurruna Djatjuwawalana, bala bitjarrana ḻakaraŋala, ");
INSERT INTO gnn_vpl VALUES ("JS2_24","007_2_24","JOS","2","24","24","“Way, yuwalk dhuwala yulŋunydja, ŋayi Garrayyunydja wekaŋala bukmaknha yana wäŋanydja ŋilimurruŋgalana goŋlili, liŋgu yulŋunydja walala yukurra ŋunha barrarirrina nhina ŋilimurrumbala, bukmakthirrina yana.” ");
INSERT INTO gnn_vpl VALUES ("JS3_1","007_3_1","JOS","3","1","1","Goḏarr'nha munhakumirrina wiripuŋuyuna waluyu, Djatjuwa ga nhanŋu mala ḏurryurruna, bala djoṉguŋalana marrtjina walalaŋguway girri'na malanha, bala yana marrtjinana‐wala. Marrtjinanydja walala yukurrana yana liŋgu‐u‐u, baṯ‐gay mulkana mayaŋ' wäŋa Djodanbuy, ga ŋunhalana walala wäŋaraŋala galki mayaŋ'ŋurana, galkurrunana yukurrana buḏapthunarawuna ŋurukuna bala wiripuŋuwuna makarrwu wäŋawu. ");
INSERT INTO gnn_vpl VALUES ("JS3_2","007_3_2","JOS","3","2","2","Nhinananydja walala yukurrana ŋunhiliyinydja ḻurrkun' walu‐ŋupara, ga ŋuliŋuruyinydja dhäŋuru ŋurru'‐ŋurruŋu ŋunhi yolŋu walala marrtjina yukurrana ḻiw'maraŋala wäŋakurru, ");
INSERT INTO gnn_vpl VALUES ("JS3_3","007_3_3","JOS","3","3","3","waŋana marrtjina walalaŋgala yolŋu'‐yulŋuwala bitjarra, “Ŋunhi nhuma yurru nhäma ḏalkarra'mirrinhanydja walalanha, walala yurru marrtji gäma bala ŋunhiyi Dhawu'‐nherraṉminyaramirri Bathi, ŋunhiyinydja ḻakarama yukurra ŋilimurruŋgu Godtja dhiyalami bäyma ŋilimurruŋgala; ŋunhi yurru walala ḏalkarra'mirri walala marrtji‐wala ŋurru‐warryundja, ga ŋilimurrunydja yurru munguyunna, malthundhi‐wala walalaŋgu yurru. ");
INSERT INTO gnn_vpl VALUES ("JS3_4","007_3_4","JOS","3","4","4","Dhuwalayinydja yuṯana dhukarr, yaka ŋilimurru ŋula marrtjinya ŋuli ŋäthili balakurruyi dhukarrkurru. Nhuma yurru malthurranydja nhanŋuway yana Dhawu'‐nherraṉminyarawuywu Bathiwu, yurru marrtjiyanydja walala yukirriya märr‐barrku, märr‐barrkukurru biyaka bala ya', yaka galkikurrunydja wal'ŋu.” ");
INSERT INTO gnn_vpl VALUES ("JS3_5","007_3_5","JOS","3","5","5","Bala yana Djatjuwayu waŋana ŋunhi yolŋunhanydja walalanha bitjarrana gam', “Ma', ḏarrtjalkkunhamiyana walala ganaŋ'maranhamiyana wal'ŋu nhunapinyay nhe; nhuma yurru nhanŋuwaynha wal'ŋu yolŋu Garraywuna yana, liŋgu goḏarrny'tja Garrayyu boŋguŋu djäma ganydjarr ḏumurruna wal'ŋu ŋilimurruŋgala.” ");
INSERT INTO gnn_vpl VALUES ("JS3_6","007_3_6","JOS","3","6","6","Ga dhäŋuru ŋuliŋurunydja ŋayi Djatjuwayu waŋana ḏalkarra'mirrinha walalanha bitjarra, “Ma', ḻaw'maraŋana walala dhuwaliyi Dhawu'‐nherraṉminyarawuynhanydja Bathinha, bala marrtjiyana‐wala. Nhumanydja marrtjiya ŋurruŋu dhiyaku yolŋu'‐yulŋuwu, ga walalanydja yurru marrtji ŋapa‐munguyun nhumalanha.” Bala yuwalkthi walalanydja märraŋalana ḻaw'maraŋalana ŋunhiyi Dhawu'‐nherraṉminyarawuynhanydja Bathinha, bala yana marrtjinana, ga walalanydja ŋunhi bukmaktja yolŋu walala ŋapawana malthurruna marrtjina walalambala bala. ");
INSERT INTO gnn_vpl VALUES ("JS3_7","007_3_7","JOS","3","7","7","Ga ŋunhalanydja Garray waŋana Djatjuwawala bitjarra, “Gäthuranydja ŋarra yurru djäma ŋula nhäna wiripuna yana, ganydjarr ŋutu'na wal'ŋu biyapul'nha, bala yurru bukmakthunydja yolŋuyu nhämana ŋunhiyi, bala dharaŋanna yurru, ŋunhi ŋarranydja dhuwala nhokala galki, gäma ŋarra yukurra nhuna, bitjan yana liŋgu bitjarra ŋarra marrtjina yukurrana galki Mawtjitjkala. ");
INSERT INTO gnn_vpl VALUES ("JS3_8","007_3_8","JOS","3","8","8","Ḻakaraŋa ŋuripa ḏalkarra'mirriwanydja walalambala biyaka, ‘Ŋunhi nhuma yurru dhunarranydja‐wala ŋunhiwala mayaŋ'lili gapulilinydja, yana marrtjiyana‐wala mukthurrana yana bala, ga ŋunhi yurru nhuma yarrupthundja ŋunhimala mayaŋ'lilinydja ḻukuyunarra, ga marrtjiyanydja‐wala baḻwaḻyunmiyanydja yana mukthurrana, bala djingaryurranydja marrtjiya ŋunhili bili ṉapuŋga' yana mayaŋ'ŋura.’” ");
INSERT INTO gnn_vpl VALUES ("JS3_9","007_3_9","JOS","3","9","9","Bala Djatjuwanydja wäthurruna waŋanana ŋuriki yolŋu'‐yulŋuwunydja bitjarrana, “Go marrtjiyana walala lili, ga ŋäka dhuwala Garraynha dhäruk. ");
INSERT INTO gnn_vpl VALUES ("JS3_10","007_3_10","JOS","3","10","11","Ŋunha bala wäŋaŋura, ŋunhayi yolŋunydja walala yukurra nhina wiripu ga wiripu bäpurru', yurru ŋayipina Godthuna yurru walalanha gukumanydja ŋuliŋuruyi wäŋaŋuru, bala nhuma yurru marŋgithirrina ŋunhi ŋayipina ŋilimurrumbala walŋa‐ḏikṯiktja waŋarr dhuwala, galki gali'ŋura, guŋga'yun marrtji ŋilimurrunha ŋayi, liŋgu ŋunha ya' Godku Dhawu'‐nherraṉminyarawuynydja Bathi yukurra marrtji ŋurru‐warryun ŋilimurrunha, ŋunhayinydja ŋunhi ŋayinydja Garray bukmakkuna dhiyaku wäŋawu buku‐ḻiw'maramana. ");
INSERT INTO gnn_vpl VALUES ("JS3_12","007_3_12","JOS","3","12","13","Yo, walala yurru ḏalkarra'mirriyunydja walalay ŋuriŋinydja gäma marrtji ŋunhiyi Dhawu'‐nherraṉminyarawuynhanydja Bathinha nhanŋu Garraywuna, ga ŋunhi yurru walala ḻukunydja ḻupthun gapulilinydja, bala ŋayinydja yurru Garrayyunydja marrtji gapunydja gulkthunmaramana, baṉḏany'kumana ŋayi yurru dhukarrnha ḻapmarama yolŋu'‐yulŋuwuna buḏapthunarawuna yukurranharawu.” ");
INSERT INTO gnn_vpl VALUES ("JS3_14","007_3_14","JOS","3","14","15","Yo, mayaŋ'tja ŋunhi Djodanbuynydja bathalana ŋanyana gapunydja, ga djaŋ'‐djaŋnha wal'ŋu, wirrkina yukurrana waṉḏina ganydjarryuna, liŋgu ŋunhiyinydja walu waltjaṉmirrina. Ga yolŋu'‐yulŋunydja ŋunhiyi bukmak djingaryurrunana yukurrana goŋ‐girri'mirrina walala, marrtjinyarawuna‐wala buḏapthunarawu mayaŋ'kuna. Bala walala ŋunhi ḏalkarra'mirrinydja walala yarrupthurruna, gäŋala marrtjina ŋunhiyi Dhawu'‐nherraṉminyarawuynydja Bathi, ga ŋayathaŋala walala ŋunhiyi mayaŋ'tja gapunydja. ");
INSERT INTO gnn_vpl VALUES ("JS3_16","007_3_16","JOS","3","16","16","Marrtjinana walala yukurrana yarrupthurrunana wal'ŋu ḻuku‐ḻupthurrunana gapulilinydja, bala ŋayinydja marrtjina dhunupa gapunydja gulkthurrunana, gulk bitjarrayi, ḻapthurruna baṉḏany'thinana ṉapuŋga'kurru yana. Bala yana ŋunhi yolŋu'‐yulŋunydja buḏapthurrunana yukurrana baṉḏany'kurruna dhukarrkurru. ");
INSERT INTO gnn_vpl VALUES ("JS3_17","007_3_17","JOS","3","17","17","Ga mukthurruna yana walalanydja ŋunhiyi ḏalkarra'mirrinydja walala dhärrana yukurrana ŋunhili bäyma yana dhunupa'ŋuŋura mayaŋ'ŋura, yana liŋgu ga bukmak walala buḏapthurrunana yukurrana, bukmak yana ŋunhi miṯtji. ");
INSERT INTO gnn_vpl VALUES ("JS4_1","007_4_1","JOS","4","1","1","Yo, Yitjuralnydja ŋunhiyi miṯtji buḏapthurrunana mayaŋ'ku, bukmaknha yana walala gärrina ŋunhimalanydja wäŋalili ŋunhi Godthu walalaŋgu dhawu'‐nherrara ŋäthili. ");
INSERT INTO gnn_vpl VALUES ("JS4_2","007_4_2","JOS","4","2","3","Bala Garray waŋana Djatjuwanha bitjarra, “Djarr'yurrana nhe yurru ḏarramuwurrunha 12‐nha, walala yurru waŋga'‐waŋganydhu dhipuŋuruyi 12‐ŋuru bäpurru'ŋurunydja yana ḻaw'‐ḻawmarama guṉḏa ŋulaŋuru dhunupa'ŋuŋuru yana mayaŋ'ŋuru, ŋunhi wanhami marrtji ḏalkarra'mirri walala djingar'‐djingaryun, walala yurru gämanydja ŋunhiyi guṉḏanydja malanha, ga dhipalana bala nherra'‐nhirraṉ, bala ŋal'‐ŋalmaramana ŋunhimala yana liŋgu wäŋalili ŋunhi wanhami nhuma yurru wäŋarama gäthura munhaku.” ");
INSERT INTO gnn_vpl VALUES ("JS4_4","007_4_4","JOS","4","4","6","Bala ŋayi Djatjuwayu ḻakaraŋalana ŋuripa yolŋu'‐yulŋuwana, waŋana ŋayi bitjarra, “Dhuwalayi guṉḏa malanha dhuwala nhuma ŋal'‐ŋalmarama yurru waŋga'‐waŋganygu yana Yitjuralpuyŋuwu dhuwaliyi bäpurru'wunydja malaŋuwu, djingaryundja yukurra dhuwali yurru bukmakkuna yana nhänharawunydja yukurranharawu, ga buku‐ḻayyunmaramana yukurra yurru guyaŋinyamaramana yolŋu'‐yulŋunhana. Ga yalala nhokala yurru yumurrku'yu nhäma dhuwalayi guṉḏa malanha botjanhara, bala waŋa dhä‐wirrka'yunna yurru bitjanna, ‘Nhä dhuwalanydja guṉḏa mayali'? Yolnha walala yukurra ḻakaramanydja dhiyaŋu guyaŋinyamaramanydja?’ bitjandja yurru ŋunhi ya'. ");
INSERT INTO gnn_vpl VALUES ("JS4_7","007_4_7","JOS","4","7","7","Bala nhumanydja yurru ḻakaraŋana walalaŋgu biyakana, ‘Garrayyu ŋayipi gapu‐gulkthurruna mayaŋ', ŋunhi ŋayi Godku Dhawu'‐nherraṉminyarawuy Bathi djuḻkthurruna balakurru mayaŋ'kurru, ga dhuwalanydja guṉḏa malanha djingaryun yukurra yurru bitjanna liŋguna gupaḏalnha‐wala, märr yurru yukurra bukmakthu yolŋu'‐yulŋuyu dhiyaŋu Yitjuralpuyŋuyunydja nhämana, bala guyaŋirrina yukurra yurru bitjanna liŋguna, ga yakana ŋula meṉgumanydja.’” ");
INSERT INTO gnn_vpl VALUES ("JS4_8","007_4_8","JOS","4","8","8","Ga ŋuriŋiyi ḏarramuwurruyunydja yuwalkthi djämana‐wala ŋunhi nhaltjarra Djatjuwayu waŋana walalanha; walala lilinydja djoṉguŋala guṉḏa malanha 12 yana ŋuliŋuru mayaŋ'ŋurunydja, ŋuliŋuruyi dharapulŋuru ŋunhi walala marrtjina wanhami ḏalkarra'mirri walala djingar'‐djingaryurruna goŋ‐dhawurrŋamirri walala ŋurikimirri, ga lilinydja gäŋala, ga ŋunhiwalayina botjaŋala ŋunhiyi guṉḏanydja ŋal'‐ŋalmaraŋala marrtjina wiripulilina makarrlili wäŋalili. ");
INSERT INTO gnn_vpl VALUES ("JS4_9","007_4_9","JOS","4","9","9","Ga bitjarrayi liŋgu walala guṉḏa malanha djoṉguŋala, ga gäŋala balayi, ga rarr'yurruna nherra'‐nhirrara ŋunhimala ŋunhi ḏalkarra'mirri walala ḻuku dharapul ŋunhilimiyi, ṉapuŋga' wal'ŋu mayaŋ'ŋura dhunupa'ŋuŋura. Ga dhiyaŋunydja‐wala ŋunhayi guṉḏanydja mukthun yana djingaryun yukurra, guyaŋinyamirriyamana yukurra bukmaknhana yolŋunha walalanha. ");
INSERT INTO gnn_vpl VALUES ("JS4_10","007_4_10","JOS","4","10","10","Liŋgu ḏalkarra'mirrinydja walala ŋunhiliyi mukthurruna yana djinga'‐djingaryurruna marrtjina ŋunhili bäyma dhunupa'ŋuŋura mayaŋ'ŋura, ga gonha walalawuy ŋunhiyi yolŋu'‐yulŋu yukurrana bukmak buḏapthurruna wiripuŋulili makarrlili. ");
INSERT INTO gnn_vpl VALUES ("JS4_11","007_4_11","JOS","4","11","12","Walala yukurrana buḏapthurrunanydja ganydjarryuna yana, yana liŋgu‐u‐u ga bukmak dhawar'yurruna, bala walalanydja ŋunhi ḏalkarra'mirrinydja walala buḏapthurruna, gäŋalana marrtjina ŋunhiyina Dhawu'‐nherraṉminyarawuynha Bathi, ga bukmakthunydja yukurrana nhäŋala liliyi walalanha. ");
INSERT INTO gnn_vpl VALUES ("JS4_13","007_4_13","JOS","4","13","13","Yo, yolŋu'‐yulŋunydja be‐nhämunha' dhika mala marrtjina, dhaŋaŋnha biyapulnha dhikana, dhuwalana miṯtji gam' 40‐dhawutjinnha mitjinydja ŋunhi buḏapthurruna mayaŋ'kunydja marrtjina, bala nhinanana marrtjina wäŋaraŋalana galkina yana Djarikunha. Marrtjinanydja walala yukurrana goŋ‐garamirrina walala warrpam'nha, nyäṉ'thurrunana dhikana bunharawuna, walala yurru gukumana bumana ŋuliŋuruyi wäŋaŋurunydja bukmaknhana yana ŋula nhämunha'nha, warrpam'thunna dhawar'maramana, märr yurru ŋunhiyinydja wäŋa yukurra djingaryun nhanŋuwaynha yana Godkuna gal'ŋu. ");
INSERT INTO gnn_vpl VALUES ("JS4_14","007_4_14","JOS","4","14","14","Ga ŋulinyaramirriyu walala ŋuriŋiyi yolŋu'‐yulŋuyunydja nhäŋalana dharaŋarana ŋanya Djatjuwanhanydja, ŋunhi ŋayinydja yuwalk warray wal'ŋu ŋurruŋu, nhanukuŋuway warray Godkuŋu nherraṉara, ga ŋuliŋurunydja dhurrwaraŋuru walala Yitjuralpuyŋunydja yolŋu'‐yulŋu nhanŋuwaynha Djatjuwawuna yukurrana märr‐ŋal'yurruna, ga malthurruna yukurrana nhanŋuwaynha dhärukkunydja, bitjarra liŋgu bitjana walala ŋuli yukurranha Mawtjitjku märr‐ŋal'yuna. ");
INSERT INTO gnn_vpl VALUES ("JS4_15","007_4_15","JOS","4","15","15","Ga ŋunhi walala yolŋu'‐yulŋu bukmaknha buḏapthurrunana yukurrana, yana liŋgu ga dhawar'yurruna, bala Garrayyu waŋana Djatjuwanha bitjarra, ");
INSERT INTO gnn_vpl VALUES ("JS4_16","007_4_16","JOS","4","16","16","“Ma' waŋiya ŋuruku ḏalkarra'mirriwu walalaŋgu, walala yurru dhawaṯthunna ŋulaŋuru mayaŋ'ŋurunydja.” ");
INSERT INTO gnn_vpl VALUES ("JS4_17","007_4_17","JOS","4","17","17","Bala yana ŋayi Djatjuwanydja waŋana ŋunhiyina walalanha, bala walala dhawa‐yawaṯthurrunana ŋulaŋurunydja lilina, gäŋalana marrtjina ŋunhiyinayi Dhawu'‐nherraṉminyarawuynha Bathi nhanŋuwaynha Garraywuna. ");
INSERT INTO gnn_vpl VALUES ("JS4_18","007_4_18","JOS","4","18","18","Ga ŋunhi walala dhawa‐yawaṯthurrunanydja ŋuliŋuruyi mayaŋ'ŋuru, dhunupa gapunydja waṉḏinana‐wala yana ŋunhiyi ḻupmaraŋalana, bitjarrana yana liŋgu bitjarra ŋäthili yukurrana waṉḏina ŋunhiyi gapu. ");
INSERT INTO gnn_vpl VALUES ("JS4_19","007_4_19","JOS","4","19","20","Bala walala ŋunhi yolŋu'‐yulŋunydja wäŋaraŋalana nhinana galkina yana wäŋaŋura yäkuŋura Djarikuna, ga ŋunhiliyinydja ŋayi Djatjuwayu ŋal'‐ŋalmaraŋala ŋunhiyi malanha guṉḏa 12‐nha, ŋunhi walala djoṉguŋala ŋulaŋuru mayaŋ'ŋuru Djodanŋuru. ");
INSERT INTO gnn_vpl VALUES ("JS4_21","007_4_21","JOS","4","21","23","Bala ŋayi Djatjuwayu waŋanana yukurrana bitjarrana, “Ŋunhi yurru nhumalaŋgala yumurrku'yu yukurra dhä‐wirrka'yun nhumalanha, nhumanydja yurru ḻakaraŋa biyaka, ‘Ŋilimurru Yitjuralpuyŋu yukurrana buḏapthurruna mayaŋ'ku Djodanbuyŋu baṉḏany'kurru yana, liŋgu ŋayi Garrayyu ŋilimurruŋgala Godthu gulmaraŋala gapu, yana liŋgu ga yolŋu walala yukurrana buḏapthurruna. Liŋgu gapunydja ŋayi ŋunhiyi gulkmaraŋalana bitjarra yana liŋgu bitjarra ŋayi gulkmaraŋala, Gapu Miku' ŋunhi, ŋunhi ŋilimurru ŋulaŋuru Yetjipŋuru dhawaṯthurruna ŋurruthaŋala wal'ŋu. ");
INSERT INTO gnn_vpl VALUES ("JS4_24","007_4_24","JOS","4","24","24","Yo, djämanydja ŋayi yukurrana ŋilimurruŋgu bitjarrayi, märr yurru bukmak yolŋu walala dhiyala munatha'ŋuranydja marŋgithirrina Godku, ŋunhi ŋayipina waŋganynha ganydjarr‐ḏumurrunydja waŋarr, märr walala yurru märr‐ŋal'yundja borrk‐beyaṉiyirri Garraywu ŋilimurruŋgalaŋuwu waŋarrwunydja gupaḏalnha‐wala yana.’ Ga biyakayi yukirriya ḻakaraŋanydja nhumalaŋgalaŋuwa yumurrku'wanydja.” ");
INSERT INTO gnn_vpl VALUES ("JS5_1","007_5_1","JOS","5","1","1","Yo, walala ŋunhi buŋgawamirrinydja ŋurikiyi miṯtjiwu ŋunhi walala yukurrana nhinana ŋunhili Gaynan wäŋaŋura, walala ŋäkulana Yitjuralpuyŋunhanydja, ŋunhi nhaltjarra ŋayi Garrayyu baṉḏany'kuŋala ŋunhiyi mayaŋ' Djodanbuy, ga yana liŋgu ga buḏapthurruna walala yukurrana ŋunhiyi Yitjuralpuyŋu, bala walala beyaṉiyinana yukurrana ŋunhi buŋgawamirrinydja yolŋu'‐yulŋu Gaynanbuynydja. ");
INSERT INTO gnn_vpl VALUES ("JS5_2","007_5_2","JOS","5","2","2","Ga dhäŋuru ŋuliŋurunydja ŋunhi walala buḏapthurruna yukurrana, bala nhinanana ŋunhili wäŋaŋura wäŋaraŋalana, bala ŋayi Garraynydja waŋanana Djatjuwawala bitjarrana, “Märraŋa mandjawaknha raywal' yana, bala nhe yurru mitthurra ḏarrtjalkkuŋana marrtjiya Yitjuralpuyŋunhanydja ḏarramuwurrunha.” ");
INSERT INTO gnn_vpl VALUES ("JS5_3","007_5_3","JOS","5","3","3","Bala ŋayi ŋunhi märraŋala mandjawaktja, bala mitthurrunana marrtjina bukmakkuŋalana yana ŋunhiyi Yitjuralpuyŋunhanydja ŋunhiliyinayi wäŋaŋura yäkuŋura Gilkalnha bukuŋura. ");
INSERT INTO gnn_vpl VALUES ("JS5_4","007_5_4","JOS","5","4","6","Yo, ŋunhiyinydja walala ḏarramuwurru ŋunhi walala yukurrana dhawaṯthurruna beŋuru Yetjipŋuru, walalanydja ŋunhiyinydja walala liŋguwuynha ḏarrtjalkkunharana mitthunara, yurru walala ŋunhiyinydja walala ŋunhala bäyma yana murrmurryurruna ŋanhdharkŋura wäŋaŋura, liŋgu walala yaka dhäruk märraŋala Garraynha yukurrana; yaka walala nhäŋala ŋunhiyinydja wäŋa ŋatha‐guḻku'mirrinydja, ŋunhi ŋayipi Garrayyu dhawu'‐nherrara walalaŋgu be ŋäthili walalaŋgalaŋuwala märi'muwala. Ga ŋunhi walala yukurrana nhinana ŋunhala ŋanhdharkŋuranydja wäŋaŋura 40 dhuŋgarranydja ŋupara, yaka walala yukurrana mitthurruna ḏarrtjalkkuŋala walalaŋguway yumurrku'nha. ");
INSERT INTO gnn_vpl VALUES ("JS5_7","007_5_7","JOS","5","7","7","Bala ŋayi Djatjuwayunydja mitthurrunana marrtjina ḏarrtjalkkuŋalana ŋunhiyinydja walalanha yumurrku'nha ŋunhi walala yukurrana dhawal‐wuyaŋina ŋunhiliyi ŋanhdharkŋura wäŋaŋura. ");
INSERT INTO gnn_vpl VALUES ("JS5_8","007_5_8","JOS","5","8","8","Ga ŋuliŋuruyinydja dhäŋuru bukmakthinana walala yukurrana ŋunhiyi Yitjuralnydja miṯtji nhinana ŋunhili liŋgu waŋganyŋura wäŋaŋura, yana liŋgu ga baḏa'‐baḏarraŋdhina walala. ");
INSERT INTO gnn_vpl VALUES ("JS5_9","007_5_9","JOS","5","9","9","Bala ŋayi Garray waŋana bitjarrana Djatjuwawalanydja, “Gäthuranydja dhuwala ŋarra ḏarrtjalkkuŋalana ŋarrakuwaynydja ŋarra yolŋu'‐yulŋunha. Ŋäthilinydja ŋunhinydja nhuma yukurrana nhinana garrpiṉarawuy ŋunhalanydja Yetjiptja wäŋaŋura, yurru liŋguna ŋunhiyinydja ŋapawuynha‐wekanhara, yakana nhuma yurru biyapulnydja garrpiṉarawuy ŋula yolkuŋu.” ");
INSERT INTO gnn_vpl VALUES ("JS5_10","007_5_10","JOS","5","10","10","Yo, ŋunhiyi walala Yitjuralpuyŋu miṯtji mukthurruna yana nhinana yukurrana ŋunhili Gilkal wäŋaŋura, bala ŋunhiyi Ḻäy‐yuḻkmaranharamirri Walu bunana, bala walala yukurrana guyaŋinana nhinananydja ŋunhiyina walu ŋunhi ŋayi Godthu walalanha ŋäkirrmaraŋala gunganhamirriyaŋala ŋuriŋiyi maŋgu'yu wäyingala, märr ŋuriŋiyinydjayi walala yukurrana dhawaṯthurrunanydja gänana‐wala nhinanharawu gal'ŋu romgu ŋamathanharawuna yuṯawuna. ");
INSERT INTO gnn_vpl VALUES ("JS5_11","007_5_11","JOS","5","11","11","Ga wiripuŋuyunydja waluyu walala yukurrana ḻukana ŋathana ŋunhi yukurrana ŋuthara ŋunhili Gaynan wäŋaŋura; batharanydja walala marrtjina ŋunhiyi ŋathanydja gurthalilina, bala djäma dämbakuŋalana, yurru walala yukurrana warkthurrunanydja ŋunhi ŋathanydja ruwaŋga'kunharamiriw yana. ");
INSERT INTO gnn_vpl VALUES ("JS5_12","007_5_12","JOS","5","12","12","Ga ŋuriŋi bili yana waluyunydja ŋunhiyi ŋathanydja yäku mananydja gulyurruna, yakana ŋayi biyapulnydja Garrayyu Godthu wekaŋala walalanha marrtjina ŋunhiyi ŋatha mananydja, liŋgu ŋuliŋuruyinydja dhurrwaraŋuru walala ḻukana yukurrana ŋathana ŋunhi yukurrana ŋuthara ŋunhiliyi mirithina gal'ŋu Gaynan wäŋaŋura, ga ŋuriŋiyinayi liŋguna walala märrnydja ḏaw'yurruna ŋunhi. ");
INSERT INTO gnn_vpl VALUES ("JS5_13","007_5_13","JOS","5","13","13","Yo, nhinananydja walala yukurrana wäŋaraŋalana ŋunhiliyinydja galkina Djarikunha wäŋaŋura yäkuŋura, ga ŋayinydja ŋunhi ŋurruŋu yolŋu Djatjuwanydja yäku marrtjinana bala nhänharawu ŋurikiyi wäŋawu Djarikuwu, ga nhäŋalanydja ŋayi ŋunhiyi ḻoḻunydja ḏäl warray dhika, ḻiw'maranhara warray yana gunganharanydja. Ga biyapul ŋayi nhäŋala ŋunhiyi, dharr‐way nhäŋala yolŋunhana, ŋayi yukurrana djingaryurruna ŋunhili bäyma, yurru mandjawak ŋayi yukurrana ŋayathaŋalanydja goŋdhunydja ŋuriŋiyi yolŋuyu, girri'‐ŋamathina ŋayi yukurrana djingaryurruna mariwuna. Bala ŋayi Djatjuwayunydja dhä‐wirrka'yurruna ŋanya ŋunhi yolŋunhanydja bitjarra, “Way, yolkala dhuwala nhenydja gali'ŋura? . . . ŋanapurruŋgala? . . . bay' ŋurukala walalaŋgala ŋiniya? . . . miriŋu ŋanapurruŋgu?” ");
INSERT INTO gnn_vpl VALUES ("JS5_14","007_5_14","JOS","5","14","14","Ga ŋayinydja ŋunhiyinydja yolŋu waŋana nhanŋu buku‐wakmaraŋala bitjarra, “Ŋarranydja dhuwala yaka gali'ŋura ŋurukalayi walalaŋgala, ga dhiyakala walalaŋgala nhumalaŋgala gali'ŋura yaka yana. Ŋarranydja dhuwala marrtjina lili ŋurruŋuna wal'ŋu buŋgawana ŋurukuna ŋunhi djiwarr'wuywuna malawu, nhanŋuwaynha Garraywuna miriŋu mala.” Bala ŋayi ŋunhi Djatjuwayunydja ŋäkula ŋanya dharaŋarana, bala ŋayi ṉepaḻ‐nyilŋ'thurrunanydja muḻkurrnydja munatha'lili, bala buku‐ŋal'yurrunana yukurrana nhanŋu, bala ŋayi waŋana ŋunhiyinydja bitjarrana, “Garray ŋarraku, ŋarranydja dhuwala nhuŋu djämamirri. Nhäku nhe ḏukṯuktja ŋarra yurru djämanydja dhika?” ");
INSERT INTO gnn_vpl VALUES ("JS5_15","007_5_15","JOS","5","15","15","Ga ŋayinydja ŋunhiyinydja waŋana bitjarra, “Yupmaraŋa nhuŋuway dhuwali ḻukuwuynydja dhapathuŋ'tja, liŋgu dhuwalayinydja wäŋa ŋunhi nhe yukurra djingaryun dharrpalnha wal'ŋu, ganaŋ'thunarana nhanŋuwaynha Garraywuna.” Bala dhunupana ŋayi Djatjuwayunydja yupmaraŋalana ŋunhi dhapathuŋ'tja ḻukuwuynydja nhanŋuway, bala bukumirriyaŋalana yukurrana. ");
INSERT INTO gnn_vpl VALUES ("JS6_1","007_6_1","JOS","6","1","1","Yo, Djariku wäŋa djingaryurruna yukurrana, yurru ḻoḻu marrtjina ḻiw'maraŋalanydja ŋorrana ḏälnha mirithirrina ga garrwarnha dhiŋgina, ga dhurrwaranydja ŋurikiy wäŋawuy dhaḻ'‐dhaḻnha yukurrana dhärrana, liŋgu walala ŋunhi yolŋu'‐yulŋunydja mirithinana barrarina Yitjuralpuyŋuwana. ");
INSERT INTO gnn_vpl VALUES ("JS6_2","007_6_2","JOS","6","2","2","Bala yana Garraynydja Djatjuwawala waŋanana bitjarrana, “Dhuwalanydja gay' wäŋa ŋarra nhokalana dhayuŋara; ŋurruŋu buŋgawa ŋunhi ga yolŋu walala nhanbala mala, warrpam'nha yurru nhokalaynha goŋŋuranydja. ");
INSERT INTO gnn_vpl VALUES ("JS6_3","007_6_3","JOS","6","3","4","Goḏarrny'tja nhepi ga nhuŋu miriŋu walala boŋguŋu marrtji yukirri ḻiw'maraŋu dhuwalayi wäŋa buṉbu‐mäypamirri Djarikuwuy. Yo, ḏalkarra'mirrinydja walala 7 boŋguŋu marrtji yukirri ŋurruŋu, ŋurru‐warryurru nhumalanha, ga waŋga'‐waŋganydhu yana walala boŋguŋu yukirri gäŋu'‐waŋunydja yiḏakiyinyara goŋdhunydja, ga malthurrunydja boŋguŋu ŋapa‐munguyurrunydja ḏalkarra'mirrinha walalanha marrtji, walala boŋguŋu marrtji gäŋu Dhawu'‐nherraṉminyarawuy Bathinydja. Ga dhuḏikurrunydja wal'ŋu malthurrunydja marrtji walalambala bala ŋunhi goŋ‐garamirrina yolŋu'‐yulŋu bukmaknha. Marrtjinydja boŋguŋu nhuma yukirri ḻiw'maraŋu waŋganymirri, bala yana roŋiyi wäŋalilina, ga biyaku liŋgu nhuma boŋguŋu yukirri yulŋunydja 6 walunydja ŋupurru. Ga wiripuŋuyunydja waluyu ŋuriŋiyinydja, bala yana nhuma boŋguŋu yukirri marrtji ḻiw'yunmaraŋuna ŋunhiyi wäŋa bala'‐mäypamirri bukunydja 7‐mirri, yurru walala ŋurruŋunydja boŋguŋu ḏalkarra'mirri walala ḻoḻthurru marrtji yiḏakiyu. ");
INSERT INTO gnn_vpl VALUES ("JS6_5","007_6_5","JOS","6","5","5","Ga ŋunhi nhuma boŋguŋu dhawar'‐yurrunydja, bala boŋguŋu walalanydja ḏalkarra'mirrinydja bopthurru weyin‐marraŋuna, bo‐o‐op biyaku waŋganymirri, bala dhunupana bukmaktja yolŋu'‐yulŋu wirrkina yatjunmi boŋguŋu, bala yana ŋayi boŋguŋu ŋunha ḻoḻunydja buku‐yapthurruna, ḏaw'‐ḏawyurruna boŋguŋu buku‐yä‐ä‐äp biyakuna. Bala nhuma boŋguŋu yolŋu'‐yulŋunydja gulŋiyina‐wala yana dhunupana, bala buŋuna marrtji boŋguŋu ŋunhiyi wäŋa warrpam'thurruna.” Ga bitjarra yukurrana Garrayyu ḻakaraŋalanydja nhanŋu Djatjuwawu. ");
INSERT INTO gnn_vpl VALUES ("JS6_6","007_6_6","JOS","6","6","9","Bala yana ŋayi Djatjuwanydja marrtjinana, bala ḻakaraŋala ŋuripana yolŋu'‐yulŋuwana, bala walalanydja yolŋu'‐yulŋunydja ŋunhi girri'‐ŋamathinana marrtjina, bala walala yana marrtjinana yukurrana ḻiw'‐maraŋalana ŋuliyi wäŋakurruna. Yo, marrtjinanydja walala yukurrana‐a‐a, ḻiw'maraŋalana yanana‐a‐a, ḻoḻthurruna marrtjina ŋuriŋiyi yiḏakiyu ḏalkarra'mirrinydja ŋunhinydja. ");
INSERT INTO gnn_vpl VALUES ("JS6_10","007_6_10","JOS","6","10","10","Yurru yakana walala ŋula dhäruktja waŋana, liŋgu Djatjuwayu waŋana walalanha bitjarra, “Yakana waŋiyanydja waŋgany dhäruk ŋula yurru ŋi', rirrakaymiriw yana mukthurra marrtjiya, yana liŋgu‐u‐u ga ŋarrapi nhumalanha yurru waŋa yatjunarawunydja, bala yatjurra wirrkina.” ");
INSERT INTO gnn_vpl VALUES ("JS6_11","007_6_11","JOS","6","11","11","Yo, marrtjinana‐wala walala ŋunhi yolŋu'‐yulŋunydja, marrtjinana‐a‐a ḻiw'maraŋala ŋuliyi wäŋakurru waŋganymirri yana, bala roŋiyinana wäŋalilina, ga ŋunhilinydja ṉapuŋgany'tja Dhawu'‐nherraṉminyarawuy Bathi marrtjina gäŋala ŋuriŋiyi ḏalkarra'mirriyu walalay. ");
INSERT INTO gnn_vpl VALUES ("JS6_12","007_6_12","JOS","6","12","14","Ga bitjarra liŋgu yana wiripuŋuyunydja waluyu walala marrtjina yukurrana ḻiw'maraŋala‐a‐a, ḻoḻthurruna marrtjina ŋuriŋi yiḏakiyu, ga balayi roŋiyina wäŋalili. Bitjarrayinydja walala yukurrana 6 walunydja ŋupara, ");
INSERT INTO gnn_vpl VALUES ("JS6_15","007_6_15","JOS","6","15","15","ga ŋuriŋinydja waluyu wiripuŋuyunydja walala gaŋga'‐gaŋgathina djaḏaw'yunarayuna be walumiriwyu yana, bala marrtjina yukurrana ḻiw'maraŋala buku‐7‐mirri ŋunhiyi wäŋanhanydja, ḻiw'maraŋala marrtjina yukurrana‐a‐a, yana liŋgu‐u‐u ga dhawar'yurruna. ");
INSERT INTO gnn_vpl VALUES ("JS6_16","007_6_16","JOS","6","16","16","Bala ŋayi Djatjuwayu waŋana bitjarrana, “Ma' yatjunmiyana walala, dhä‐rur'thurrana yiŋgathiyanydja bukmak, liŋgu Garrayyu liŋguna wekaŋalana dhuwalayi wäŋanydja ŋilimurruŋgalana. ");
INSERT INTO gnn_vpl VALUES ("JS6_17","007_6_17","JOS","6","17","17","Dhuwalanydja gay' wäŋa ga nhä malanha dhiyalami ŋorra marrtji nhanŋuway Garraywu yana bukmak, yaka ŋula nhumalaŋgunydja. Nhuma yurru yana gurthayuna dhuŋgur'yurranydja bukmak nhä malanha, bala baymatthurrana dhawar'maraŋana bukmaknhana yolŋunhanydja, bili walala dhuwalayinydja yätjmirrina dhikana gal'ŋu yana. Yurru walŋakuŋanydja nhuma yurru waŋganynha ŋunha dhäykanha Rayapnha yäkunha ga ŋunhinha walalanha ŋunhi walala nhina yukurra nhanukala wäŋaŋura waŋganyŋura. Ŋayi muka ŋunhi, ŋuriŋiyi miyalkthu walŋakuŋala ŋilimurruŋgu mel'ŋunhanydja maṉḏanha, bala nhumanydja yurru walŋakuŋa ŋanyana. ");
INSERT INTO gnn_vpl VALUES ("JS6_18","007_6_18","JOS","6","18","18","Yaka walala djaw'yurranydja ŋula nhä nhuŋuwaynydja nhe, ŋula nhä mel‐ŋamathiya. Gonha'yurra nhäŋa, liŋgu bukmak ŋunhiyi nhänydja malanha nhuma yurru dhuŋgur'yun nhanŋuwaynha Garraywuna. Ŋuli nhe yurru djaw'yun ŋula nhä nhuŋuwayliliyamanydja, ŋayinydja yurru Godthunydja marina‐wekama ŋutu'na ŋilimurruŋgu Yitjuralpuyŋuwunydja miṯtjiwu. ");
INSERT INTO gnn_vpl VALUES ("JS6_19","007_6_19","JOS","6","19","19","Nhuma yurru yana märraŋanydja bulayi' malanha ga garwarrwarr'mirri girri' malanha, bala gäŋana lili Godkalaŋuwuna Buṉbuwu. Ga wiripunydja malanha yana gonha'yurrana, liŋgu bukmak nhä malanha ŋunhiyi nhanŋuway yana Godku ŋunhi yulŋunydja.” Bitjarrayina yukurrana ŋayi Djatjuwayu ḻakaraŋalanydja walalaŋgu ŋäthili muka yana. ");
INSERT INTO gnn_vpl VALUES ("JS6_20","007_6_20","JOS","6","20","21","Yo, wäŋgaŋalana walala yukurrana ḻiw'maraŋalana ŋunhiyi wäŋanha buku‐7‐mirri, bala yana walala ḏalkarra'mirrinydja walala bo'yurrunana yiḏakiyuna bena wirrkina, bo‐o‐op bitjarra, bala bukmaktja yolŋu'‐yulŋu yatjunminana, yiŋgathinana bena dhikana wal'ŋu. Bala ŋayinydja marrtjina dhunupa ḻoḻunydja ŋunhiyi buku‐yapthurrunana gay', ḏaw'‐ḏawyurrunana bukmaknha, ga yolŋu'‐yulŋunydja bukmaknha ŋunhi gärrinana‐wala dhunupana yanana. Bumarana marrtjina walala wäŋanydja ŋunhinydja ḏaw'‐ḏawyurrunana, ga ŋuriŋiyi walalaŋgala mandjawakthunydja walala bumarana marrtjina yolŋu'‐yulŋunha ga wäyinnha walalanha, yana liŋgu ga dhawar'maraŋala, baḏuwaḏuyurruna warrpam'. ");
INSERT INTO gnn_vpl VALUES ("JS6_22","007_6_22","JOS","6","22","22","Yurru ŋayi Djatjuwanydja waŋana ŋurikala märrma'wala mel'ŋuwala maṉḏakala bitjarra, “Gatjuy marrtjiya maṉḏa ŋurukala wäŋalili dhäykawala, ŋunhi ŋayi nhumalanha yawungu walŋakuma. Märraŋanydja ŋanyapinyay ga nhanŋu gurruṯu'mirrinha, bala gäŋana lili walalanha walŋamirrinha yana, biyaka yana liŋgu bitjarra nhuma ŋunhi ŋäthili dhawu'‐nherrara ŋanya.” ");
INSERT INTO gnn_vpl VALUES ("JS6_23","007_6_23","JOS","6","23","23","Yuwalkthi maṉḏanydja marrtjinana‐wala yana ŋunhiyi ḏarramunydja maṉḏa, ga garr'yurruna ŋanya ga nhanŋu gurruṯu'mirrinha walalanha, bala yana gäŋalana lili Yitjuralpuyŋuwalana wäŋalili ŋunhimalana. ");
INSERT INTO gnn_vpl VALUES ("JS6_24","007_6_24","JOS","6","24","24","Ga ŋuliŋurunydja dhurrwaraŋuru walala dhuŋgur'yurrunana ŋunhiyi wäŋanydja bukmaknha, yurru yakana walala bathara ŋunhiyi bulayiny'tja ga garwarrwarr'mirri girri', yana walala marrtjina djoṉguŋalana ŋunhiyinydja malanha warrpam'thurrunana, bala gäŋalana lili, bala yana gurrunharana ŋunhimalayina Godkalana Buṉbulili. ");
INSERT INTO gnn_vpl VALUES ("JS6_25","007_6_25","JOS","6","25","25","Yo, ḏul'yurrunanydja walala ŋunhiyi marrtjina bukmakkuŋalana, yurru ŋunhiyinha miyalknha Rayapnhana walala walŋakuŋalanydja, liŋgu ŋayi djuḻuḻ'maraŋala maṉḏanha ŋunhi mel'ŋunha maṉḏanha, walŋakuŋala maṉḏanha. Ga ŋuliŋurunydja dhurrwaraŋuru ŋayipi ŋunhiyi dhäyka ga gurruṯu'mirri walala nhanŋu nhinanana yukurrana ŋunhiliyina malaŋura Yitjuralpuyŋuwalana. ");
INSERT INTO gnn_vpl VALUES ("JS6_26","007_6_26","JOS","6","26","26","Ga ŋuliŋurunydja dhäŋuru Djatjuwayu waŋana bitjarra, “Dhipuŋurunydja dhurrwaraŋuru gay' yakana yurru ŋula yolthu dhuḻ'yun biyapulnydja wäŋa dhuwalayi. Ga ŋuli yurru ŋayi ŋula yolthu dhuḻ'yundja dhuwalayi wäŋa, nhanŋunydja yurru walkur maḻamarrnydja rakunydhirrina, ga bitjandhi liŋgu yurru malpuranydja nhanŋu yothu dhuḏiŋunydja rakunydhirriyi yana.” ");
INSERT INTO gnn_vpl VALUES ("JS6_27","007_6_27","JOS","6","27","27","Yo, galki yana Godtja Djatjuwawala, guŋga'yurruna marrtjina ŋanya, gäŋala yukurrana ŋanya bitjarra liŋgu, ga bukmakthunydja yolŋu'‐yulŋuyu ŋunhiliyi ḻiw'maraŋala ŋuliwitjarrayi wäŋakurru ŋäkulana nhanukalaŋuwuy, bala yana wirrkina walala beyaṉiyinanydja nhanŋu Djatjuwawunydja. ");
INSERT INTO gnn_vpl VALUES ("JS7_1","007_7_1","JOS","7","1","1","Yo, Garrayyu dhäruk wekaŋala Yitjuralpuyŋuwu bitjarra, “Bukmak nhä malanha girri' marrtji ŋorra ŋunha Djariku wäŋaŋura nhuma yurru baḏuwaḏuyundja dhuŋgur'yundja gurthayuna, liŋgu bukmak yana ŋunhi ŋarrakuway yulŋunydja.” Bitjarrayi ŋayi Garray waŋananydja, yurru waŋganydja ḏarramu yäku Waykan, gäthu'mirriŋunydja ŋayi ŋunhi Gämiwu, Djudawala yarraṯaŋura, ŋayi ŋuriŋiyinydja djaw'‐djawyurruna warray girriny'tja malanha gayulnha, bala yana djuḻuḻ'maraŋalana nhanukalay ŋunhi buṉbulilina wäŋalilina, munatha'lilina dholkuŋala. Bala ŋayinydja ŋunhi Garraynydja ŋaramurryinana ŋuriki Yitjuralpuyŋuwunydja malawu, liŋgu ŋuriŋi waŋganygala yolŋuwala yätjthu. ");
INSERT INTO gnn_vpl VALUES ("JS7_2","007_7_2","JOS","7","2","2","Ga ŋuliŋurunydja ŋayi Djatjuwayu djuy'yurruna nhanbalay ŋunhi mel'ŋumirrinhana walalanha wiripuŋulili ŋunha wäŋalili milthunarawu, nhayikayu Yäyilili galki Bithulwuyŋu. Yuwalkthi walala nhäŋa'‐nhaŋala marrtjina‐a‐a, ga ḏutj‐gay roŋiyina liliyi, ga ḻakaraŋala Djatjuwawala bitjarra, ");
INSERT INTO gnn_vpl VALUES ("JS7_3","007_7_3","JOS","7","3","3","“Ŋunhayi wäŋanydja bay', yurru märr‐yutjuwaḻa' yana, ga ḻurrkun' wal'ŋu yana yolŋunydja walala ŋunha nhina yukurra. Yaka nhe djuy'yurra guḻku'nhanydja miriŋunha ŋi', märr‐ḻurrkun'nha yana djuy'yurranydja, liŋgu ḻurrkun'thuna yana ŋuli baymatthurru ŋunhayinydja wäŋa ḏaw'‐ḏawyurru marrtji.” ");
INSERT INTO gnn_vpl VALUES ("JS7_4","007_7_4","JOS","7","4","4","Bala yana yuwalknha walala marrtjinanydja märr‐ḻurrkun' ŋunhi miriŋunydja, yana bini walala ŋuli djuḻkmaranha bunha waḏutja, yurru bäyŋu warray, liŋgu walalanydja ŋurukuynydja Yäyipuyŋuyunydja yolŋu'‐yulŋuyu lilimirriyaŋala warray ŋupara ŋunhiyinydja Yitjuralpuyŋunhanydja walalanha. ");
INSERT INTO gnn_vpl VALUES ("JS7_5","007_7_5","JOS","7","5","5","Bala yana walala bukmak ŋunhi Yitjuralpuyŋunydja gundupuŋala beyaṉiyina wirrkina dhika walalambala, ga wiripu‐guḻku'nhanydja walala ŋaya'‐ŋayathaŋalana, bala bumara rakunyguŋalana Yäyipuyŋuyuna miriŋuyu ŋuriŋina. Walala ŋuparanydja walalanha, ŋayaŋgany ŋupara yana, yana liŋgu ga wäŋa marrtjina galkithina ŋunhi Yitjuralpuyŋuwa. Ga walalanydja nhäŋala warray ŋuriŋi Yitjuralpuyŋuyunydja yolŋu'‐yulŋuyu, walala nhinana lili gundupuŋala, bena dhika gundupuŋala nhinana ŋupanaranydja ŋurikiŋina miriŋuwuŋuna. Bukmakthuna walala nhäŋalanydja dharr bitjarrana walalanha, ga wirrkina walala beyaṉiyinanydja. ");
INSERT INTO gnn_vpl VALUES ("JS7_6","007_7_6","JOS","7","6","6","Ga ŋayipi Djatjuwayu nhäŋalayi, ga wirrkina ŋayi bitjarra borrk‐gorananydja. Bala ŋayipi Djatjuwanydja ga wiripu‐guḻku' ŋunhi ŋurru'‐ŋurruŋu Yitjuralpuyŋu djalkthunmina marrtjina ŋunhana munatha'lilina, gumurrlili ŋunhimala Garraywala Dhawu'‐nherraṉminyarawuylilina Bathilili. Ŋorra'‐ŋurrananydja marrtjina walala ŋunhili bili yana‐a‐a, warwuyunminana walala wirrkina, goramirrina, yana liŋgu ga milmitjpayina. ");
INSERT INTO gnn_vpl VALUES ("JS7_7","007_7_7","JOS","7","7","7","Ga ŋayinydja Djatjuwanydja bukukurru waŋana yukurrana Godnha bitjarra, “Garray Waŋarr, nhaltjarra dhuwalayinydja bitjarra? Nhäku nhe gämanydja yawungu lili dhuwala ŋanapurrunha? . . . bunharawu? Nhe yurru ŋanapurrunha warrpam'thun baymatthun dhawar'marama? Ŋanapurru bini ŋunhi ŋunhalaŋga bili nhinanha ŋunhalayiŋga gali'ŋura. ");
INSERT INTO gnn_vpl VALUES ("JS7_8","007_7_8","JOS","7","8","8","Ŋuruŋu miriŋuyunydja ŋanapurrunha ŋuparana, ga yana liŋgu ga djuḻkmaraŋala. ");
INSERT INTO gnn_vpl VALUES ("JS7_9","007_7_9","JOS","7","9","9","Ga wiripu‐guḻku'yu ŋuruŋu yolŋu'‐yulŋuyu dhuwala walala nhina yukurra dhiyalami wäŋaŋura, ŋämana yurru walala ŋanapurruŋgalaŋuwuy, ŋunhi ŋanapurrunydja dhuwala yalŋgi'mirrina, ganydjarrmiriwnha walala, ga walalanydja yurru ḻaw'yun lilina, bala bumana ŋanapurrunha warrpam'thunna yana dhawar'maramana. Walala yurru waŋanhamirrina ḻakaranharamirrina yanapi nhenydja dhuwala ganydjarrmiriw waŋarr, yana bini nhenydja dhuwala yaka yukurra ganydjarr ŋayathaŋu ŋanapurruŋgu walŋakunharawu.” Bitjarra ŋayinydja yukurrana Djatjuwayunydja bukumirriyaŋala ŋäŋ'thurruna. ");
INSERT INTO gnn_vpl VALUES ("JS7_10","007_7_10","JOS","7","10","10","Yurru ŋayinydja Garraynydja waŋana nhanukala Djatjuwawala bitjarra, “Ma' gaŋgathiyana. Nhäku nhe yukurra bitjandja waŋa? ");
INSERT INTO gnn_vpl VALUES ("JS7_11","007_7_11","JOS","7","11","11","Yitjuralnydja dhuwala yätjthinana. Ŋalinydja maṉḏa dhuwala Yitjuralnydja miṯtji waŋgany muka yana, liŋgu ŋuriŋi ŋunhi ŋali dhawu'‐nherraṉmina ŋitjalaŋguway ŋali, yurru nhumanydja bakmaraŋala warray ŋunhiyi dhawu'; yaka warray nhuma märraŋala dhäruk ŋarranha warrpam'tja. Ŋarranydja ŋunhi waŋana ŋäthili yana ḻakaraŋala nhumalaŋgala, nhuma yurru yukurra baḏuwaḏuyun warrpam'thun ŋunhiyinydja wäŋa, liŋgu bukmak ŋunhilimiyi ŋarrakuway yulŋunydja warrpam', yurru waŋganydhu dhika yolŋuyunydja yawungu märranha girriny'tja malanha djaw'‐djawyuna, bala girriny'tja ŋunhiyi ŋayi djuḻuḻ'maranhana nhanŋuwayliliyanhana. ");
INSERT INTO gnn_vpl VALUES ("JS7_12","007_7_12","JOS","7","12","12","Liŋgu dhikayi nhuma yukurra djuḻuḻ'maranharanydja ŋayathama yana mukthun, yakana yurru nhuma yukurra gukuma waṉḏinyamaramanydja ŋunhiyi nhumalaŋguway miriŋunhanydja walalanha, yanana ŋayi ŋuriŋiyi miriŋuyunydja yukurra djuḻkmaramana nhumalanha yurru; yakana nhuma yukurra yurru djingaryun ḻuku wuṉḏaŋarryirrinydja. Ŋarranydja yurru yakana nhumalaŋgala dhiyaliyi, bäy nhuma yurru ga djuḻuḻ'maranharawuy ŋunhi ḏupthun warraŋullili, bala warrpam'thunna baḏuwaḏuyun buwayakkumana. ");
INSERT INTO gnn_vpl VALUES ("JS7_13","007_7_13","JOS","7","13","13","“Gatjuy ḻaw'yurrana walala dhipuŋuruyinydja, ga ŋuripa yolŋu'‐yulŋuwanydja ḻakaraŋa biyakana. ‘Godtja waŋa yukurra bitjan, “Nhumanydja dhuwalinydja Yitjuralpuyŋunydja ŋarrakuwaynha yana walala. Nhumanydja bini ŋunhi warrpam'thuna muka baḏuwaḏuyunanydja, gurthalili dhuŋgur'yuna, yurru dhikayi waŋganydhu dhiyalimiyi miṯtjiŋura ŋayathama yukurra ŋula nhä, ŋunhi ŋarra waŋana ŋäthili baḏuwaḏuyunarawuna dhuŋgur'yunarawuna. Yaka nhuma yurru yana dhuwala djuḻkthundja nhumalaŋgalaŋuwu miriŋuwunydja, bäy yurru nhuma bukmaknha baḏuwaḏuyun warrpam'nha. ");
INSERT INTO gnn_vpl VALUES ("JS7_14","007_7_14","JOS","7","14","15","Biyakana ḏarrtjalkkunhamiyana nhumalanhay nhuma, liŋgu goḏarrny'tja boŋgama nhuma ḻaw'yurru lilina ŋarrakalana, bukmak nhuma yana bäpurruny'tja, bala ŋarra boŋguŋu dhunupamirriyaŋuna yolŋunhanydja ŋunhiyi ŋunhi ŋayi dhikaŋuyunayi yolŋuyu gora wekaŋalanydja yukurrana ŋarrakunydja miṯtjinha. Mel‐ŋamathirrinydja ŋayi ŋuli yukurra nhä malanha ŋunhi ŋarra waŋana yaka'yurruna, bala yana nhuma yurru baḏuwaḏuyunna yulŋunydja dhuwaliyinydja yolŋunha ga gurruṯu'mirrinha walalanha nhanŋu. Ŋilinyunydja dhuwala waŋganygunharana dhambay‐manapanarana liŋgu ŋuriŋiyina dhawu'‐nherraṉminyarawuyyuna, ga ŋuriŋi nhanukala yätjthunydja nhumalanha Yitjuralpuyŋunhanydja gulkmaraŋalana, barrkuwatjkuŋalana ŋarrakalanydja.” ’ Bitjarrayina ŋayi God waŋananydja.” ");
INSERT INTO gnn_vpl VALUES ("JS7_16","007_7_16","JOS","7","16","16","Wiripuŋuyu waluyu Djatjuwayu yurrum'maraŋalana Yitjuralpuyŋunhanydja, bala yana nherraranydja walalanha marrtjina bäpurru ga bäpurru ga bäpurru bitjarra, ga ŋayinydja Godthunydja dhunupamirriyaŋala ḻakaraŋalana ŋanya ŋunhimalana ŋunhi Djudawalana yarraṯalili. ");
INSERT INTO gnn_vpl VALUES ("JS7_17","007_7_17","JOS","7","17","17","Bala walala yana dhärranana yukurrana ŋunhiyi Djudanydja miṯtji, bukmak yana ŋunhiyi mala, bala Godthunydja milkuŋalana dhunupamirriyaŋalana Gämiwunydja gurruṯu'mirrinha walalanha, ŋunhi ŋuriŋina walalay yätjkuŋala Godnhanydja. ");
INSERT INTO gnn_vpl VALUES ("JS7_18","007_7_18","JOS","7","18","18","Ga Gämiwunydja warrpam'nha mala djingaryurruna yukurrana gumurrŋurana nhanukala Djatjuwawalana, ga yurruna Godthu dhunupamirriyaŋalanydja ḻakaraŋala dhuwalayinhana ḏarramunhanydja yäkunha Waykannhana, “Ŋayi yawungu dhuwala bitjandja yätjkumanydja,” bitjarra. ");
INSERT INTO gnn_vpl VALUES ("JS7_19","007_7_19","JOS","7","19","19","Bala Djatjuwanydja waŋana bitjarrana nhanukala Waykangalanydja, “Go, ḻakaraŋa ŋarrakala lili. Nhaltjan muka nhe yawungu dhuwala yulŋunydja? Yuwalkkuŋa ḻakaraŋanydja yana, ga yaka bothiyanydja ḻakaraŋa.” ");
INSERT INTO gnn_vpl VALUES ("JS7_20","007_7_20","JOS","7","20","20","Ga ŋayi Waykandja waŋana buku‐roŋiyinmaraŋala bitjarra. “Märr‐yuwalk dhuwala ŋarra yätjkuŋala Garraynhanydja. ");
INSERT INTO gnn_vpl VALUES ("JS7_21","007_7_21","JOS","7","21","21","Ŋunhala Djariku ŋunhi ya' yawungu ŋarra nhäma ḻatju'mirri ŋanya dhika girri', ga wiripunydja rrupiya malanha. Ŋunhi ŋarra yawungu nhämanydja, ŋarra yawungu wirrkina ḏukṯukthirrinydja, bala ŋarra yawungu märranhana djaw'yunana ŋunhiyi, ga ŋunhamalayina yawungu ŋarra djuḻuḻ'maranhanydja dholkunhanydja ŋarrakalay buṉbulilina.” ");
INSERT INTO gnn_vpl VALUES ("JS7_22","007_7_22","JOS","7","22","22","Bala yana ŋayi Djatjuwayunydja djuy'yurruna djämamirrinhana walalanha balayina Waykangalana buṉbulili, ga ŋunhalana walala maḻŋ'maraŋalanydja djinawa'na ŋunhiyi wal'ŋu munatha'ŋurana, ");
INSERT INTO gnn_vpl VALUES ("JS7_23","007_7_23","JOS","7","23","23","ga liliyi walala gäŋala, bala milkuŋalanydja Djatjuwawalana. Bala yana ŋayinydja marrtji buḻuḻuyunmaramana milkumana, rarryunna marrtji. ");
INSERT INTO gnn_vpl VALUES ("JS7_24","007_7_24","JOS","7","24","25","Ga ŋayi Djatjuwanydja waŋa ŋanya Waykannhanydja bitjanna, “Nhäku warray dhuwala nhe bitjandhinydja djäma yawungu? Bukmak ŋunhilimi wäŋaŋura Djarikunydja nhanŋuway yana dhulŋuŋu Godku, liŋgu ŋunhiyinydja wäŋa ŋurruŋu wal'ŋu yana ŋilimurru yawungu djaw'yunna. Ŋunhayi ŋilimurrunha miriŋuyunydja yawungu djuḻkmaranhana, galki bini walala ŋilimurrunha baḏuwaḏuyunana, liŋgu ŋuriŋi nhokala dhuwurryu yätjthu, bala ŋayinydja yurru Garrayyunydja nhuna baḏuwaḏuyunna dhuwala buwayakkumana.” Ga bitjarra ŋayi Djatjuwayu waŋananydja. Bala walala märraŋalana ŋunhiyi girriny'tja ga rrupiya, ga bitjarrayi liŋgu Waykannhanydja ga gurruṯu'mirrinha walalanha nhanŋu, bala gäŋala ŋunhimalana yäkulili wäŋalili Yaykalilina, bitjan yäkunydja ŋunhiyi mari‐ḏumurruna. Bala walala yana bumarana yukurrana walalanha dhawar'maraŋalana, guṉḏayuna wirriw'‐wirriwyurrunana, bala yana gurthalilina dhuŋgur'yurruna warrpam'thurrunana. ");
INSERT INTO gnn_vpl VALUES ("JS7_26","007_7_26","JOS","7","26","26","Bala walala ŋal'maraŋala marrtjina guṉḏanydja ŋunhimalayina nhanukalana, ga guṉḏanydja malanha mukthun yana ŋunhayi djingaryun yukurra, märr yurru yukurra bukmakthu nhäma ŋunhiyi, ga guyaŋirri yukurra yurru bitjanna liŋguna. Bala yana Garraynydja roŋiyinayi bilyurruna walalaŋgu, ŋoy‐ŋamathinayi ŋuriki Yitjuralpuyŋuwunydja yolŋu'‐yulŋuwu malawu; yakana biyapulnydja mari‐wunana walalaŋgu, liŋgu walala liŋguna djalkthurrunana ŋunhiyinydja yätjtja malanha warrpam'nha. ");
INSERT INTO gnn_vpl VALUES ("JS8_1","007_8_1","JOS","8","1","1","Bala Garrayyunydja waŋana Djatjuwanha bitjarra, “Yaka nhe barrariyanydja, ga yaka nhe ganydjarr‐winya'yurra. Ma' märraŋa dhuwala nhuŋuway miriŋunha walalanha bukmaknha yana, bala yana marrtjiyana balayi roŋiyiyayi Yäyilili wäŋalili. Bukmaknha ŋarra wekaŋalanydja ŋunhanydja nhokalaynha goŋlili dhayuŋara; wäŋanydja ŋunhiyi ga Giŋ ŋunhi ga bukmak nhä malanha warrpam' ŋunhanydja yurru nhumalaŋguwaynha. ");
INSERT INTO gnn_vpl VALUES ("JS8_2","007_8_2","JOS","8","2","2","Bumanydja nhuma yukurra yurru warrpam'thun yana dhawar'marama Yäyinydja wäŋa, ŋayilpikuŋa yana yurru, biyaka yana liŋgu bitjarra nhuma ŋunhala Djariku bumara dhawar'maraŋala yana, yurru wäyindja malanha ŋunhi ga wiripunydja girri' malanha nhumalaŋguwaynha yurru warrpam'nha. Djuy'yurra wiripu‐guḻku'nhanydja miriŋunha, walala yurru marrtji gali'kurru, bala galkun gali'ŋurana yukurra yurru nhina, märr yurru walala gärri ŋunhimalayi wäŋalili ŋuliŋuruyinydja gayulnha lili yurru.” Bitjarrana ŋayi Garrayyu waŋananydja Djatjuwanha. ");
INSERT INTO gnn_vpl VALUES ("JS8_3","007_8_3","JOS","8","3","3","Ga dhunupana yana ŋayi Djatjuwanydja gaŋgathinana, rrambaŋina walala ŋunhi miriŋuna walala nhanbala miṯtjina bukmaknha, girri'‐ŋamathinanydja walala buwayakkunharawuna warrpam'thunarawuna ŋuriki Yäyipuyŋuwunydja. Ŋayi djarr'yurrunanydja ŋutu'mirrinha ganydjarrnha ḏarramuwurrunhanydja yana, bala waŋananydja ŋayi bitjarrana walalanha, ");
INSERT INTO gnn_vpl VALUES ("JS8_4","007_8_4","JOS","8","4","4","“Gatjuy marrtjiyana walala. Marrtjiyanydja gayul yukirriya‐a‐a ŋunha bala gali'kurru gal'ŋu, ga ŋunhana bala wiripuŋulilina gali'lili nhuma yurru djuḻuḻ'yundja, märr barrku biyaka ya' yarrkthurra ŋulaŋuru wäŋaŋurunydja wal'ŋu, ga ŋunhiliyina yukirriya galkurranydja. ");
INSERT INTO gnn_vpl VALUES ("JS8_5","007_8_5","JOS","8","5","5","Goḏarrny'tja ŋanapurru boŋguŋu wiripu‐guḻkuny'tja marrtji, bala boŋguŋu walalanydja Yäyipuyŋuyunydja yolŋuyu walalay nhäŋuna ŋanapurrunha, bala boŋguŋu walala dhawaṯthurrunydja, bala dhunupana ŋupuruna ŋanapurrunha boŋgama. Ga ŋanapurrunydja boŋgama bilyurru, bala yana gundupuŋuna boŋguŋu walalambala, ŋunhiyinydja yana mayali'‐wilkthurru boŋguŋu ŋanapurru. Gundupuŋunydja ŋanapurru boŋguŋu yukirri biyakuna ya' ṉinydjiyalilina, ");
INSERT INTO gnn_vpl VALUES ("JS8_6","007_8_6","JOS","8","6","6","ga walalanydja boŋguŋu ga ŋupurruyi ŋanapurrunha. ");
INSERT INTO gnn_vpl VALUES ("JS8_7","007_8_7","JOS","8","7","7","Bala nhumanydja yana boŋguŋu gärrina yanana‐wala ŋunhimala wäŋalilinydja, bala yana Garrayyunydja boŋguŋu wekaŋuna nhumalaŋgala. ");
INSERT INTO gnn_vpl VALUES ("JS8_8","007_8_8","JOS","8","8","8","Ga ŋunhi nhuma boŋguŋu märraŋu wäŋanydja ŋunhayi, ga dhunupa nhuma boŋguŋu dhuŋgur'yurruna gurthayuna yulŋunydja, biyaku yana liŋgu yulŋunydja ŋunhi ŋayi Garrayyu ŋayipi ḻakaraŋala.” Bitjarrayina ŋayi Djatjuwayu djuy'yurrunanydja ŋunhinha ḏarramuwurrunhanydja. ");
INSERT INTO gnn_vpl VALUES ("JS8_9","007_8_9","JOS","8","9","9","Marrtjinanydja walala yukurrana‐a‐a, yana liŋgu‐u‐u ga wäŋanydja ŋayathaŋala, ga ŋunhalayina walala yukurrana galkurrunanydja. ");
INSERT INTO gnn_vpl VALUES ("JS8_10","007_8_10","JOS","8","10","13","Ga wiripuŋuyunydja munhayu munhakumirri, Djatjuwa ga nhanŋu miṯtji marrtjina wäŋgaŋala, bala dhunupana yana withiyarana Yäyinydja wäŋa. ");
INSERT INTO gnn_vpl VALUES ("JS8_14","007_8_14","JOS","8","14","14","Bala ŋayi Giŋdhunydja ga ŋuriŋi yolŋu'‐yulŋuyunydja walalanha nhäŋalana, walala marrtjina lili wäŋgaŋala, ga dhunupana walala ŋuparana walalanha Yäyipuyŋuyunydja ŋuriŋinydja miriŋuyu; yaka walala marŋgi ŋunhi walala wiripu‐guḻkuny'tja miriŋu ŋunhalana bala yukurrana nhinana. ");
INSERT INTO gnn_vpl VALUES ("JS8_15","007_8_15","JOS","8","15","16","Walalanydja Djatjuwanydja ga wiripu‐guḻku' ŋunhi nhanbala mala dhunupa bilyu'‐bilyurrunana, bala gundupuŋalana yana roŋiyina wäŋalilina, yana walala bitjarra ya' mayali'‐wilkthurruna. Gundupuŋalanydja walala yukurrana mukthurruna yana‐a‐a, ga walalanydja mukthurruna ŋupara miriŋuyunydja ŋuriŋi Yäyipuyŋuyunydja, yana liŋgu ga wuyupthurruna wal'ŋu ŋunhiyi wäŋa walalaŋgu. ");
INSERT INTO gnn_vpl VALUES ("JS8_17","007_8_17","JOS","8","17","17","Ga ŋunhalayi Yäyinydja yakana waŋgany ŋula ḏarramu nhinana yukurrana ŋuruku wäŋawunydja goŋ‐nherraṉmina, ga ḻoḻunydja ŋunhiyi dhä‐ḻapthurrunana, ḻapthunarana yukurrana dhärrana. ");
INSERT INTO gnn_vpl VALUES ("JS8_18","007_8_18","JOS","8","18","18","Bala ŋayi Garray waŋana Djatjuwawala bitjarra, “Märraŋa dhuwala nhuŋuway gara, bala yana dhunupamirriyaŋana ŋunhayi wäŋanhanydja. Ŋarranydja yukurra wekama nhokalana ŋunhayi wäŋanydja.” Yuwalkthi ŋayinydja Djatjuwayunydja ŋunhi märraŋalana garanydja, bala yana dhunupamirriyaŋalana yukurrana. ");
INSERT INTO gnn_vpl VALUES ("JS8_19","007_8_19","JOS","8","19","19","Bala walalanydja marrtjina ŋulaŋurunydja bala gali'ŋuru miriŋu dhawa'‐yawaṯthurrunana, bala yana gärrinana‐wala ŋunhimala wäŋalilina. Walala ḏaw'‐ḏawyurrunana marrtjina ŋunhi wäŋanydja warrpam'nha dhikana, bala yana dhuŋgur'yurrunana, gonhana marrtjina nhärana, ṉoluŋdhinana marrtjina, ŋawululny'tja bena marrtjina gaŋgathina. ");
INSERT INTO gnn_vpl VALUES ("JS8_20","007_8_20","JOS","8","20","20","Walalanydja ŋunha Yäyipuyŋunydja mukthurruna yana ŋupara yukurrana Djatjuwawa ŋunhi malanha, bala walala ŋunhi waṯthurrunanydja nhäŋala bitjarra bala roŋiyina ŋunhiyi wäŋanydja walalaŋguway, nhäŋala warray ŋayi marrtjina gurthana ŋawulul'nha gaŋgathina, ṉoluŋdhina. ");
INSERT INTO gnn_vpl VALUES ("JS8_21","007_8_21","JOS","8","21","21","Bala walalanydja bilyu'‐bilyurrunana yana ŋunhi Yitjuralpuyŋunydja, bala galkiŋuruna walalanhanydja marrtjina bumara ḏatthurruna. ");
INSERT INTO gnn_vpl VALUES ("JS8_22","007_8_22","JOS","8","22","22","Ga walalanydja lili warray gumurr‐roŋiyina ŋunhinydja walala ŋunhi walala wäŋa ḏul'yurruna, ga ŋunhalanydja walala ḻiw'maraŋalana walalanha ṉapuŋga'kuŋalana, ḻiw‐ḏap bitjarrayi walalanha, yurru walala marrtjina bumarana gay' wiṯthurrunana dhikana, dhawar'maraŋalana Yäyipuyŋunhanydja miriŋunha, waŋga'‐waŋganynha yana dhawar'maraŋala, yakana ŋula waŋgany walŋathinanydja. ");
INSERT INTO gnn_vpl VALUES ("JS8_23","007_8_23","JOS","8","23","23","Yurru ŋanyapinyaynha walala ḏapmaraŋalanydja märraŋala buŋgawanhana, bala walala gäŋalana ŋanya lili nhanukala Djatjuwawalana. ");
INSERT INTO gnn_vpl VALUES ("JS8_24","007_8_24","JOS","8","24","24","Yo, ŋuriŋi Yitjuralpuyŋuyunydja bumara warrpam'thurruna yana dhawar'maraŋala ŋunhi miriŋunhanydja ŋunhalana bala warraŋulnha, ga bitjarrayi liŋgu walala roŋiyina balanydja wäŋalilinydja, ga ŋunhalanydja bumara walala bukmaknhana, dhawar'maraŋalana yana, yakana ŋula waŋgany walŋathina. ");
INSERT INTO gnn_vpl VALUES ("JS8_25","007_8_25","JOS","8","25","26","Ga ŋayinydja yukurrana Djatjuwanydja dhärrana yana bitjarra liŋgu, ga dhunupamirriyaŋalanydja yukurrana ŋunha bili yana wäŋa garayu nhanukiyingalay ŋayi. Yakana ŋayi goŋ‐yupthurruna ŋuliŋuruyi, yana liŋgu ga dhawar'maraŋala wal'ŋu walala bumara marrtjina yolŋu'‐yulŋunha ŋunhi bukmaknha. ");
INSERT INTO gnn_vpl VALUES ("JS8_27","007_8_27","JOS","8","27","28","Yo, ŋuriŋi Yitjuralpuyŋuyunydja ḏul'yurrunana ŋunhiyi wäŋanydja, buku‐yapmaraŋalana warrpam'nha, yurru walala märra'‐marraŋalanydja ŋuliŋuruyi djaw'‐djawyurrunanydja wäŋaŋurunydja wäyinnha ga girri'na walalaŋguwaynha walala, bitjarra liŋgu yana ŋunhi ŋayi Garrayyu ḻakaraŋala yukurrana walalaŋgu. ");
INSERT INTO gnn_vpl VALUES ("JS8_29","007_8_29","JOS","8","29","29","Ga ŋayi Djatjuwayunydja bumara ŋunhi Giŋnhanydja walalaŋgu rakunyguŋalana, bala walala rumbalnydja ŋanya ŋurrkaŋala dhurrwaralilina galki ŋunhi ḻoḻulilina. Bala walala guṉḏana ŋal'‐ŋalmaraŋala yukurrana maŋutji‐ŋäkirrmaraŋalanydja ŋanya rumbalnydja, ga ŋunhiyinydja malanha guṉḏanydja mukthun yana dhiyaŋunydja‐wala ŋunha djingaryun yukurra. ");
INSERT INTO gnn_vpl VALUES ("JS8_30","007_8_30","JOS","8","30","32","Bala yana walala ŋuliŋurunydja giṯthurrunana marrtjina dhawaṯthurruna ŋunha bukulili wäŋalili yäkulili Yepallilina, ga ŋunhamalayina ŋayi Djatjuwayu dhuḻ'yurruna ŋal'‐ŋalmaraŋala guṉḏanydja Garraywuna buku‐ŋal'yunarawu. Bala walala yukurrana ŋunhalayina bumara wäyindja malanha, bitjarra galkithinana marrtjina lili Godkalana ŋuriŋiyinydja maŋgu'‐waṉḏinyarayu wäyingalanydja, buku‐ŋal'yurrunanydja walala yukurrana batharanydja wäyindja malanha, mundhurrnha wekaŋala Garraywuna. ");
INSERT INTO gnn_vpl VALUES ("JS8_33","007_8_33","JOS","8","33","33","Ga gali'ŋuranydja ŋunhiliŋumi ga buku maṉḏanha wäŋa yukurrana gorruŋala, waŋganydja yäku Yepalwuy ga wiripunydja Giritjimbuy, ga walalanydja yolŋu'‐yulŋunydja ŋunhi gulk‐gulkthunmina, waŋganynha miṯtji dhipala bala waŋganylili bukulili ŋal'‐ŋalyurruna, ga wiripu‐guḻkuny'tja ga dhipala bala gali'lili wiripulili bukulili, ga ŋunhi Dhawu'‐nherraṉminyarawuynydja Bathi ŋunhala yukurrana djingaryurruna ṉapuŋga' ŋunhili walalaŋgala. ");
INSERT INTO gnn_vpl VALUES ("JS8_34","007_8_34","JOS","8","34","35","Bala yana ŋayinydja Djatjuwayunydja djorra'na mel‐ḻaw'maraŋala, bala marrtjina waŋanana makarrnha dhäruknha, bukmaknha yana ŋunhi Godthu yukurrana ḻakaraŋala ŋäthili dhäruk nherraṉmina Mawtjitjkala; ŋayi waŋananydja marrtjina ŋunhi dhawu'‐nherraṉminyarawuy dhäruktja malanha, ga bitjarrayi liŋgu ŋayi raypirri'yunaranydja dhäruk ŋunhiyi marrtjina waŋana bukmakkalana ŋurikala yolŋu'‐yulŋuwala, ḏarramuwurruŋgala ga dhäykawurruŋgala ga bitjarrayi bili yumurrku'walanydja, ga ŋurikala wiripu‐guḻku'wala mulku'‐mulkuruwala yolŋu'‐yulŋuwala ŋunhi walala yukurrana nhinana mala‐manapara ŋunhiliyi walalaŋgala malaŋura ŋunhi Godku nhanŋuway wal'ŋu yolŋu'‐yulŋu. ");
INSERT INTO gnn_vpl VALUES ("JS9_1","007_9_1","JOS","9","1","1","Ga bukmakthu yolŋu'‐yulŋuyu miṯtjiyu ga miṯtjiyu ŋäkulanydja, bala borrk‐beyaṉiyinana yukurrana ŋurikinydja yolŋuwu miṯtjiwu, Yitjuralpuyŋuwunydja. ");
INSERT INTO gnn_vpl VALUES ("JS9_2","007_9_2","JOS","9","2","2","Bala walala yukurrana ḻuŋ'maranhaminana waŋganynha miṯtjinydja, märr bini walala bunha gukunha Djatjuwawu miṯtjinha. ");
INSERT INTO gnn_vpl VALUES ("JS9_3","007_9_3","JOS","9","3","3","Ga wiripuwurruyunydja yolŋu'‐yulŋuyu Gipiyanbuyŋuyunydja ŋäkulana walalanha Yitjuralpuyŋunhanydja, nhaltjarra walala ŋunhi baḏuwaḏuyurruna bumara Djariku wäŋa ga ŋunhala Yäyi. Bala walala ŋunhiyi ḻuŋ'maranhaminana, bala waŋanharamina bitjanmina, ");
INSERT INTO gnn_vpl VALUES ("JS9_4","007_9_4","JOS","9","4","4","“Gul' ŋilimurru ŋi', mayali'‐wilkthunna Djatjuwanhanydja, märr yurru ŋuruŋu nhanukala miriŋuyunydja yakana buma ŋilimurrunha dhawar'marama,” bitjarra. Bala yana walala märraŋala ŋatha malaŋgarr'mirrina dhika, ŋäthiliŋuna ŋayaŋay', ga märraŋalayi walala bathinydja malanha ŋarŋgamirri barrŋbarrŋ, bala ŋal'maraŋala wäyingala ḏiltjililina. ");
INSERT INTO gnn_vpl VALUES ("JS9_5","007_9_5","JOS","9","5","5","Ga bitjarrayi liŋgu walala dhaṯthunminanydja rumballilinydja nherra'‐nhirrara ŋäthiliŋuna girri', ga ḻukuwuy nherra'‐nhirrarayi barrŋbarrŋmirriyi yana wal'ŋu murrŋaram'mirrina girri', bala yana walala martj‐martjurrunana. ");
INSERT INTO gnn_vpl VALUES ("JS9_6","007_9_6","JOS","9","6","6","Martj‐gay walala yakaŋga weyindja, bala bunanana, wäŋanydja ŋunha ŋayathaŋala, bala waŋana Djatjuwanhanydja bitjarrana gam' ḻakaranhaminanydja, “Ŋanapurrunydja dhuwala marrtjina lili ŋulaŋuru beŋuruna‐wala birr wäŋaŋuru, marrtjinanydja ŋanapurru lili, märr yurru ŋilimurru goŋ‐nherraṉmirri dhawu'‐nherraṉmirri bala‐lili'yunmirri, märr yurru ŋilimurru ḻundu'manydjina yanana, nhuŋu mala ga ŋanapurru mala; ŋilimurru yurru ḻundukunhamirrina yanana yukurra nhina,” bitjarra. ");
INSERT INTO gnn_vpl VALUES ("JS9_7","007_9_7","JOS","9","7","7","Bala walala Yitjuralpuyŋuyunydja buku‐ḏuwaṯthurruna warray dhä‐wirrka'yurruna walalanha bitjarra, “Nhäku yurru ŋanapurru dhawu'‐nherraṉmirri nhumalaŋgalanydja? Mak nhumanydja dhuwala bäy galkiwuy yana gal'ŋu wäŋawuy dhiyakuy.” ");
INSERT INTO gnn_vpl VALUES ("JS9_8","007_9_8","JOS","9","8","10","Ga walalanydja buku‐wakmaraŋala ḻakaranhamina nhanukala Djatjuwawala bitjarra, “Ŋanapurrunydja dhuwala nhumalaŋgu djämamirrina walala beŋuruna‐wala birr wäŋaŋuru marrtjina lili, liŋgu ŋanapurru yawungu ŋäma nhumalaŋgu waŋarrnha Godnha ŋunhi ŋayi yawungu nhumalanha guŋga'yuna ŋunhala Yetjip, ga ŋunhala bala gali'ŋura makarrŋura wäŋaŋura. ");
INSERT INTO gnn_vpl VALUES ("JS9_11","007_9_11","JOS","9","11","11","Bala yawungu ŋanapurruŋgala ŋurru'‐ŋurruŋuyunydja ŋanapurrunha djuy'yunana lili dhipala nhokalana. ");
INSERT INTO gnn_vpl VALUES ("JS9_12","007_9_12","JOS","9","12","12","Bala ŋanapurru yawungu dhuwala djaw'yundja ŋathanydja walŋa yana wal'ŋu dhika ḻatju', ga dhuwalana gay' nhäŋana ya', malaŋgarr'mirrina yätjnha. ");
INSERT INTO gnn_vpl VALUES ("JS9_13","007_9_13","JOS","9","13","13","Ŋanapurru dhaṯthunminanydja yuṯayu muka girri'yunydja, ga dhuwalana nhäŋana ya' barrŋbarrŋnha yätjnha, bili ŋanapurru yukurrana weyinnha marrtjina, weyinnha wäŋa ŋupara lili.” Ga bitjarrana walala yukurrana ḻakaraŋalanydja, yurru djawukinana dhäwuny'tja walala yukurrana ḻakaraŋala. ");
INSERT INTO gnn_vpl VALUES ("JS9_14","007_9_14","JOS","9","14","14","Bala walalanydja nhäŋalana ŋunhimala girri'lilina ŋäthiliŋulilina ga ŋathalilina murrŋaram'mirrililina, yurru yakana walala ŋula bukumirriyaŋala dhä‐wirrka'yurrunanydja ŋanya Godnhanydja. ");
INSERT INTO gnn_vpl VALUES ("JS9_15","007_9_15","JOS","9","15","15","Dhunupana yana ŋayi Djatjuwanydja walalaŋgu märr‐yuwalkthina warray, bala ŋayi dhawu'‐nherraṉminana, dhäruknha nherrara walalaŋgu Garraywalaŋumirrina yäkumirri. Yo, ŋunhiyi märrma' maṉḏanha yuwalknha yana miṯtji ḻundukunhaminanydja, gupaḏalkunhaminana yana walala nherraṉminanydja. Ga bitjarrayi liŋgu walalanydja ŋuriŋi ŋurru'‐ŋurruŋuyunydja yolŋu'‐yulŋuyu dhäruktja‐nherrara yäkumirrina Garraywalaŋumirrina yana, bukmakthu yana ŋuriŋi malayu Yitjuralpuyŋuyunydja, “Dhuwalayinydja dhawu' yukurra yurru dhärra gupaḏalnha‐wala yana,” bitjarra. ");
INSERT INTO gnn_vpl VALUES ("JS9_16","007_9_16","JOS","9","16","16","Ga ḻurrkun'nha walu djuḻkthurruna, bala walalanydja marrtjina maḻŋ'maraŋalana, ŋunhi walalanydja ŋunhiyinydjayi Gipiyanbuyŋunydja yolŋu'‐yulŋu yaka warray beŋuru barrkuŋuru, ŋurikiy warray bäyma galkiŋuwuy warray yana wäŋawuy. ");
INSERT INTO gnn_vpl VALUES ("JS9_17","007_9_17","JOS","9","17","17","Ga wiripu‐guḻkuny'tja ḏukṯukthina, walala bini ŋunhi dhunupana marrtjinya ga bunha dhawar'maranhana ŋunhi Gipiyanbuyŋunhanydja yolŋu'‐yulŋunha. ");
INSERT INTO gnn_vpl VALUES ("JS9_18","007_9_18","JOS","9","18","19","Yurru walalanydja ŋuriŋi ŋurru'‐ŋurruŋuyunydja gulmaraŋala warray walalanha, waŋana yukurrana bitjarra warray gam', “Yakana yurru ŋilimurru walalanha ŋula bumanydja, liŋgu ŋilimurrunydja dhuwala dhawu'‐nherraṉmina muka be walalaŋgala yäkumirri Garraywalaŋumirriŋga Godkalaŋumirriŋga. ");
INSERT INTO gnn_vpl VALUES ("JS9_20","007_9_20","JOS","9","20","20","Ŋuli yurru ŋilimurru buma walalanha rakunygumanydja, ŋayinydja yurru Godthunydja ŋilimurrunha dhä‐ḏir'yunna. ");
INSERT INTO gnn_vpl VALUES ("JS9_21","007_9_21","JOS","9","21","21","Gonhana walala yurru yukurra nhinanydja walŋamirrinydja, ga djäma walala yukurra yurru ŋilimurruŋgu.” ");
INSERT INTO gnn_vpl VALUES ("JS9_22","007_9_22","JOS","9","22","22","Bala dhunupana ŋayi Djatjuwayunydja dhä‐wirrka'yurrunana walalanha bitjarrana, “Nhäku warray nhuma ŋunhi ŋanapurrunha bothinanydja? ");
INSERT INTO gnn_vpl VALUES ("JS9_23","007_9_23","JOS","9","23","23","Godthunydja nhumalanha yurru dhuwala dhä‐ḏir'yunna, liŋgu nhuma mayali'‐wilkthurruna ŋanapurrunha. Bitjanna liŋgu nhuma yurru gupaḏalnha‐wala djämamirrinydja walala, gulkthun nhuma yurru yukurra gurthana djatthun, ga gäma nhuma yukurra yurru gapu Godkalaŋuwuna Buṉbuwu.” ");
INSERT INTO gnn_vpl VALUES ("JS9_24","007_9_24","JOS","9","24","24","Ga walalanydja buku‐wakmaraŋala bala Djatjuwawunydja bitjarra, “Ŋäkula ŋanapurru ŋunhi nhumalanha yulŋunydja, ŋunhi nhumalaŋgalanydja Godthu ḻakaraŋala, bitjan ŋayi yurru wekama dhuwalayinydja wäŋa nhumalaŋgalana goŋlili. Ŋanapurrunydja ŋunhi beyaṉiyinana wirrkina wal'ŋu, liŋgu nhuma bini ŋanapurrunha bunha warrpam'thunana. Ga dhiyaŋuyina ŋunhi ŋanapurru bothinanydja nhumalanha. ");
INSERT INTO gnn_vpl VALUES ("JS9_25","007_9_25","JOS","9","25","25","Ga dhuwalana gay' ŋanapurru yulŋunydja, nhumalaŋgalana goŋŋuranydja.” ");
INSERT INTO gnn_vpl VALUES ("JS9_26","007_9_26","JOS","9","26","26","Bala ŋayi yana Djatjuwayunydja walŋakuŋalana walalanha, yakana walala Yitjuralpuyŋuyu bumaranydja walalanha, liŋgu ŋayina Djatjuwayuna walalanha gulmaraŋala waŋana. ");
INSERT INTO gnn_vpl VALUES ("JS9_27","007_9_27","JOS","9","27","27","Bala walala ŋunhi Gipiyanbuyŋuyunydja djämana yukurra ŋuli ŋunhiliyi Godkalanydja Buṉbuŋura, bitjana gurthana walala ŋuli djatthuna ga gapuna gänha. ");
INSERT INTO gnn_vpl VALUES ("JS10_1","007_10_1","JOS","10","1","1","Ga ŋuliŋurunydja dhurrwaraŋuru walala ŋäkulana wiripu‐guḻku'yunydja bäpurru'yu yolŋu'‐yulŋuyu ŋurikiy wäŋawuy Gipiyanbuyŋuyunydja miṯtjiyu, ŋunhi walala ḻundukunharaminana, ga nhinanana walala yukurrana ŋunhilina Yitjuralpuyŋuwalana malawala. ");
INSERT INTO gnn_vpl VALUES ("JS10_2","007_10_2","JOS","10","2","2","Bala walala waŋanhaminanydja bitjanminana, “Gipiyandja ŋunhi ŋutu'na wäŋa, ga yolŋu'‐yulŋunydja ḏarramuwurrunydja ŋunha ḏälmirrina dhika bunharawunydja. Nhäkuna walala yawungu ŋilimurrunhanydja gonha'yuna, ga wapthuna yawungu Djatjuwawalanydja gali'lili? ");
INSERT INTO gnn_vpl VALUES ("JS10_3","007_10_3","JOS","10","3","5","Gul' ŋilimurru marrtjina go, nyäṉ'thunna walalaŋgu, ga bumana walalanha Gipiyanbuyŋunhanydja ŋunhanydja.” Bala walala mana'‐manapanminana mala ga mala, goŋ waŋgany ŋurru'‐ŋurruŋunydja ga miriŋu walala walalambala, ga waŋganynha marrtjina malanydja bena dhika miriŋunydja Gipiyanbuyŋuwunydja yolŋu'‐yulŋuwu ŋuriki nyäṉ'thurruna. ");
INSERT INTO gnn_vpl VALUES ("JS10_6","007_10_6","JOS","10","6","6","Ga dhunupana walalanydja ŋunhi Gipiyanbuyŋuyunydja dhäruknha djuy'yunmina bala Djatjuwawalana bitjarra gam', “Go walala, guŋga'yurra ŋanapurrunha. Marrtjiyana lili ga walŋakuŋa ŋanapurrunha. Yaka ŋanapurrunha gonha'yurra,” bitjarra. ");
INSERT INTO gnn_vpl VALUES ("JS10_7","007_10_7","JOS","10","7","7","Bala dhunupana yana ŋayinydja Djatjuwayunydja yurrum'thunmaraŋalana nhanŋuway miṯtjinhanydja ŋunhi bukmaknha dhika, bala yana marrtjinana walala Gipiyanbuyŋuwuna guŋga'yunarawu. ");
INSERT INTO gnn_vpl VALUES ("JS10_8","007_10_8","JOS","10","8","8","Ga ŋayi Garraynydja waŋana Djatjuwawala bitjarra, “Yaka barrariyanydja ŋurikiyi miriŋuwunydja. Ŋay' nhokalana ŋarra wekaŋala walalanha goŋlilinydja. Nhena yurru buma walalanha warrpam'thunna, yakana yurru ŋula waŋgany djingaryundja ga buku‐ruŋiyirrinydja nhuŋu.” ");
INSERT INTO gnn_vpl VALUES ("JS10_9","007_10_9","JOS","10","9","10","Yo, Djatjuwanydja ga nhanŋu miriŋunydja marrtjinana‐wala yana withiyarana Gipiyandja wäŋa. Walalanydja ŋuriŋi miriŋuyunydja wal'ŋu nhäŋalana walalanha, walala yukurrana lili marrtjina, bala ŋayi Garrayyunydja walalanha barrari‐wekaŋalana yana, bala walalanydja bilyurruna, bala gundupuŋala yukurrana bitjarrana‐wala. Ga walalanydja Yitjuralpuyŋuyunydja walalanha ŋuparana, buku'‐wukukurruna dhika marrtjina bumara walalanha bala. ");
INSERT INTO gnn_vpl VALUES ("JS10_11","007_10_11","JOS","10","11","11","Bala ŋayinydja Garrayyunydja djuy'yurruna, balanyarana bitjan guṉḏa rarralayinyara, ŋutu'mirrina dhikana guṉḏa guyiŋarrnha marrtjina burruḻ'yurruna, bala dhä‐monyguŋalana marrtjina, ga bukmaknha yana miriŋunha marrtjina muŋdhu'‐muŋdhurrunanydja, guṉḏayunydja marrtjina ŋuriŋi burakina. ");
INSERT INTO gnn_vpl VALUES ("JS10_12","007_10_12","JOS","10","12","12","Yo, galki marrtjina munhakuyinana ŋunhi yulŋunydja, ga yaka yana marinydja dhawar'yurruna ŋunhi, bala ŋayi Djatjuwanydja waŋanana Garraywala ŋuhiliyina gumurrŋura ŋurikalana yolŋu'‐yulŋuwala bukmakkalana, bitjarra ŋayi waŋananydja gam'. “Walu, djingaryurrana yukirriya yana yulŋunydja, ga ŋaḻindi djingaryurra yukirriya mukthurra!” ");
INSERT INTO gnn_vpl VALUES ("JS10_13","007_10_13","JOS","10","13","13","Bala yuwalkthi walunydja yukurrana dhärranana, yakana ŋayi giṯthurrunanydja marrtjina gärrinanydja bala, ŋunhilina liŋguna yukurrana dhärrana waŋganyŋurana dharapulŋura weyin‐marraŋalana, yanana liŋgu‐u‐u, gonha walalanha‐a‐a, ga ŋuriŋi Yitjuralpuyŋuyu miṯtjiyu warrpam' wal'ŋu miriŋunha ŋunhi bumara dhawar'maraŋala, bala yurruna munhakuyinanydja. ");
INSERT INTO gnn_vpl VALUES ("JS10_14","007_10_14","JOS","10","14","14","Yo, Garrayyu dhäruk märraŋala yolŋunha wal'ŋu ŋunhiyi, bili Garraynydja gali'ŋura ŋurikala Yitjuralpuyŋuwala, ŋayipi yukurrana ŋunhi bumaranydja walalaŋgala ŋunhi miriŋunhanydja, yakana ŋula ŋäthili bitjarrayi walu yukurrana dhärrana weyin, dhäwulnha. ");
INSERT INTO gnn_vpl VALUES ("JS10_15","007_10_15","JOS","10","15","15","Bala Djatjuwanydja ga nhanŋu miriŋunydja marrtjina roŋi'‐ruŋiyinana wäŋalilina balayi Gilkallilina yäkulili. ");
INSERT INTO gnn_vpl VALUES ("JS11_1","007_11_1","JOS","11","1","5","Ga walalanydja wiripu‐guḻku'yunydja giŋdhu walalay ŋäkulana ŋurukuynha Yitjuralpuyŋunhanydja, ŋunhi nhaltjarra walala miriŋunha djuḻkthunmaraŋala, bala walalanydja yukurrana miṯtji bukmak yana marrtjina waŋgany‐manapanminana, märr walala yurru waŋganynha mala nyäṉ'thun bala Yitjuralpuyŋuwanydja. ");
INSERT INTO gnn_vpl VALUES ("JS11_6","007_11_6","JOS","11","6","9","Bala Garraynydja waŋana Djatjuwawala bitjarra, “Yaka beyaṉiyiyanydja walalambala. Ŋarranydja yurru wekama bukmaknhana yana ŋunhayinydja walalanha nhokalaynha goŋlili, ga goḏarr'nha nhe boŋguŋu nhäŋu walalanha murrmurryunaranydja.” Bala Djatjuwayunydja yurrum'maraŋalana nhanŋuwaynydja ŋunhi miriŋunha, bala yana marrtjinana, withiyarana ŋunhiyi miriŋunhana bena dhikana malamirriŋunhana. Yurru walala gay ŋuriŋi Yitjuralpuyŋuyu yolŋu'‐yulŋu walalanha ŋuparana yukurrana, bumarana marrtjina yana walalanha, yana liŋgu ga warrpam'thurruna wal'ŋu dhawar'maraŋala raku'‐rakunyguŋala. ");
INSERT INTO gnn_vpl VALUES ("JS11_10","007_11_10","JOS","11","10","15","Ga ŋuliŋurunydja Djatjuwawu miriŋunydja walala marrtjina nhäyikayuna Yatjulilina wäŋalili, ga ŋunhalanydja walala bumara yukurrana giŋnhana ŋurukuyyi wäŋawuy, ga ḏaw'‐ḏawyurruna buku‐yapmaraŋalana wäŋanydja, ga yolŋu'‐yulŋunha bumara dhawar'maraŋalana. Ga dhurrwaraŋuru ŋuliŋurunydja walala wiripulilina giṯthurruna, ga ŋunhalanydja bala wiripuŋuranydja bumara bitjarra yana liŋgu. Ga wiripuŋulili giṯthurruna, wakinmirrilili yana wäŋalilinydja marrtjina, bala djutjnha bumara marrtjina, bitjarrana liŋguna wäŋanydja ḏaw'‐ḏawyurruna marrtjina, ga warrpam'nha bumara marrtjina rakunyguŋalana ŋunhi rom‐yätjmirrinhanydja yolŋu'‐yulŋunha. ");
INSERT INTO gnn_vpl VALUES ("JS11_16","007_11_16","JOS","11","16","23","Yo, Djatjuwayu märraŋala wäŋanydja ŋunhi bukmaknha yanana, ŋulaŋuru liŋgu ŋanhdharkŋuru wäŋaŋuru ga yanana liŋguna ga ŋunha bala buku mulkana Yämanbuy. Walala marrtjina bumaranydja buŋgawanhanydja walalanha ga yolŋu'‐yulŋunha, bumarana yanana dhawar'maraŋalana wäŋanydja malanha ŋunhiyi warrpam'thurruna, yakana ŋula walala waŋganynha walŋakuŋala, ŋunhina liŋguna waŋganynha wäŋanydja ŋunhi Gipiyan yukurrana nhinana. Yo, Djatjuwayu märraŋala wäŋanydja ŋunhiyi bukmaknha yana Gaynandja, bitjarrayi liŋgu bitjarra ŋunhi ŋayipi Garrayyu ḻakaraŋala nhanŋu Mawtjitjku ŋäthili be, bala ŋayi wekaŋalana bukmak ŋunhiyi wäŋanydja ŋuriki Yitjuralpuyŋuwana yolŋu'‐yulŋuwa, märr walalambalaynha ŋunhi wäŋanydja gupaḏalnha yurru yukurra djingaryun. Bala yana Yitjuralpuyŋunydja yukurrana nhinana ŋamathaŋalana yana‐wala ŋunhalayi wäŋaŋura, ganaŋ'thurrunana mariŋurunydja ŋula nhäŋurunydja yänana yukurrana nhinananydja walala. ");
INSERT INTO gnn_vpl VALUES ("JS14_5","007_14_5","JOS","14","5","5","Bala yana Djatjuwayunydja gulk‐gulkthurrunana wäŋanydja malanha bitjarra yana liŋgu ŋunhi Garrayyu ŋayipi ḻakaraŋala Mawtjitjkala bitjanarawu ŋäthili. ");
INSERT INTO gnn_vpl VALUES ("JS14_6","007_14_6","JOS","14","6","6","Ga waŋgany ḏarramu Gayliptja yäku marrtjina withiyara ŋanya Djatjuwanha, bala waŋana bitjarrana, “Way, birrka'yunga nhe yukurra ŋurukuynydja ŋunhi? . . . ŋunhi nhaltjarra Godthu ŋitjalanha ḻakaraŋala Mawtjitjkala ŋäthili? ");
INSERT INTO gnn_vpl VALUES ("JS14_7","007_14_7","JOS","14","7","7","Ŋarranydja ŋunhi ŋulinyaramirriyu märr‐yuṯaŋga ḏarramu, 40‐ŋga ŋarraku dhuŋgarranydja, ŋunhi ŋayi ŋarranha Mawtjitjthu djuy'yurruna milthunarawu yana dhiyaku wäŋawu, ga balanydja ŋarra roŋiyinanydja gäŋala yuwalknha dhika dhäwuny'tja. Ŋilimurru bini ŋunhi marrtjinyana‐wala yana, ga märranha dhuwala wäŋa nhanukalana Garraywalana ganydjarryu. ");
INSERT INTO gnn_vpl VALUES ("JS14_8","007_14_8","JOS","14","8","8","Ŋuriŋinydja wiripu‐guḻku'yunydja wiripu warray dhäruk gäŋala, beyaṉu‐wekaŋala dhuwala yolŋunha warray walalanha, ga ŋarrapina malthurruna ŋarrakalaŋuwunydja Garraywu. Ŋarra ŋanya dhäruktja märraŋala yana warrpam'. ");
INSERT INTO gnn_vpl VALUES ("JS14_9","007_14_9","JOS","14","9","9","Bala Mawtjitjtja ŋunhi waŋana bitjarra warray ŋarrakala gam'. ‘Ŋunhiyinydjayi wäŋa ŋunhi nhe yukurrana marrtjina ŋuliwitjarrayi, muŋdhu'‐muŋdhurruna yukurrana, ŋunhiyinydja yurru djingaryun nhuŋuwaynha wäŋa, ga yumurrku'wuna nhokalayŋuwu, bili nhe yukurrana dhärrana nhanukalay yana yuwalkkuŋala wal'ŋu.’ ");
INSERT INTO gnn_vpl VALUES ("JS14_10","007_14_10","JOS","14","10","11","“Yo, ŋunha wiripu‐guḻkuny'tja biliŋga murrmurryurruna, yurru ŋarranha ŋayi Garrayyu yukurrana gäŋalanydja walŋanha yana. Ga dhuwala ŋarra djawuḻpa'na, 85‐nha dhuŋgarranydja ŋarraku, yurru mukthun yana ŋarra dhuwala wuṉḏaŋarr yulŋunydja, yuṯa yana ŋarra mukthun yukurra nhina, balanyara yana liŋgu bitjarra ŋunhala ŋunhi ŋarranha ŋäthili Mawtjitjthu djuy'yurruna mel'ŋunha. Ŋarra yurru ŋupan yana buma dhuwala miriŋunhanydja, gukumana yurru Godkalana ganydjarryu. ");
INSERT INTO gnn_vpl VALUES ("JS14_12","007_14_12","JOS","14","12","12","Ma'! Wekaŋana nhe yurru ŋarraku wäŋa ŋunhanydja bala ya' buku'‐wukunydja, ŋunhi ŋäthili ŋarra djalkiri muŋdhu'‐muŋdhunara marrtjinyara yukurranhara. Liŋgu ŋunhiliŋumi wäŋaŋura yolŋu walala yukurra nhina djaka'‐weyinmirrina ga bathalamirrina rumbal. Godthu yurru guŋga'yundja ŋarranha, ga ŋarranydja yurru ŋupanna walalanha ŋulaŋuruyi ŋunhayi rom‐yätjmirrinhanydja walalanha.” Ga bitjarra ŋayi Gaylip waŋananydja yukurrana Djatjuwawala. ");
INSERT INTO gnn_vpl VALUES ("JS14_13","007_14_13","JOS","14","13","13","Ga Djatjuwanydja waŋana bitjarra buku‐ruŋiyinmaraŋala Gaylipkala, “Yuwalknha! Ŋunhayi bukunydja wäŋa Yiprunbuynydja yurru nhuŋuna wäŋa. Godthunydja nhuna yurru guŋga'yunna yana.” ");
INSERT INTO gnn_vpl VALUES ("JS14_14","007_14_14","JOS","14","14","14","Ga dhiyaŋunydja‐wala ŋunha Yiprunbuynydja wäŋa mukthun yana Gaylipkalaŋuwu mala‐wunharawuywu, liŋgu ŋayi Gayliptja yukurrana malthurruna nhanŋuway Garraywu yana yuwalkkuŋala wal'ŋu. ");
INSERT INTO gnn_vpl VALUES ("JS14_15","007_14_15","JOS","14","15","15","Ga wäŋanydja ŋunhiyi Yitjuralwuynydja ŋaraka liŋguna wapurarryinana, ga bukmak ŋunhi yana bäpurruny'tja malanha nhinana yukurra wapurarrŋurana liŋguna, marimiriwnha yanana yukurrana nhinana. ");
INSERT INTO gnn_vpl VALUES ("JS20_1","007_20_1","JOS","20","1","1","Ga ŋuliŋurunydja dhurrwaraŋuru Garray waŋana Djatjuwawala bitjarra, ");
INSERT INTO gnn_vpl VALUES ("JS20_2","007_20_2","JOS","20","2","2","“Nhuma ganaŋ'maraŋa yurru wäŋa malanha dhiyali bäyma ga ŋunhili bala, ga wäŋanydja ŋunhiyi malanha marrtji yurru djinga'‐djingaryun gäna wal'ŋu, ganaŋ'maranhara ŋurrwu yolŋuwu walalaŋgu. ");
INSERT INTO gnn_vpl VALUES ("JS20_3","007_20_3","JOS","20","3","4","Ŋuli yurru ŋula yolŋu burakirri ga rakunydhirri yurru ŋula yolkuŋu djämawuy, yurru yaka mel‐yunupawuynydja, ga ŋunhiyi baṉdja‐moṉuŋunydja yolŋu yurru waṉḏirri ŋunhimalayi wäŋalili, märr ŋayi yurru ŋunhalayi nhina yukurra ŋurrwu'ŋura walŋana. Yakana yurru ŋula yolthu ŋanya balwak‐ruŋiyinmarama, ga buku‐ruŋinyamaramanydja buma ŋunhili wäŋaŋura. Yo, ŋunhi ŋayi yurru bunanydja ŋunhiliyi, ŋunhiyi yolŋu ŋunhi ŋayi yaka mel‐yunupa bumara yolŋunha, ŋayi yurru ḻakarama ŋathili ŋaḻapaḻmirriwu nhaltjarra ŋayi ŋunhi, bala walalanydja yurru dhurrwarana nhanŋu ḻapmarama, bala ŋilitjanna ŋanya, ŋayinydja yurru ŋunhiyinydja yolŋu gärrina, bala nhinana walalaŋgala ŋunhili walŋana. ");
INSERT INTO gnn_vpl VALUES ("JS20_5","007_20_5","JOS","20","5","5","“Ga ŋunhi yurru ŋula yol yolŋu marrtji ga bitjan waŋa, ‘Go wekaŋa ŋarrakala dhuwali ḏarramunha ya', ŋanapurru ŋanya bumana rakunygumana, bili ŋayi yawungu ŋanapurruŋgu gurruṯu'mirrinha buma,’ bitjan yurru, bala walalanydja yurru yakana ŋanya gathan nhanukala ŋurikala yolŋuwala marimirriwalanydja, bili yaka ŋunhi mel‐yunupawuy nhanukuŋunydja, yaka ŋayi ŋunhi bumara ŋaramurryinyarayunydja ŋurruyu. Bala ŋayi yolŋunydja ŋunhiyi yurru nhina yukurra ŋunhiliyina walŋana yana, ŋamathamana, ");
INSERT INTO gnn_vpl VALUES ("JS20_6","007_20_6","JOS","20","6","6","ga yana liŋgu ga ŋuriki dhä‐wirrka'yunarawuna waluwu. Nhinanydja ŋayi yukurra yurru ŋunhilinydja wäŋaŋura weyinnha, yurruna ŋayi yurru roŋiyirri balayi nhanukiyingala wäŋalili.” Bitjarra ŋayi Garrayyu ḻakaraŋalanydja Djatjuwawala. ");
INSERT INTO gnn_vpl VALUES ("JS20_7","007_20_7","JOS","20","7","9","Bala walala ganaŋ'maraŋalana wäŋanydja malanha waŋgany‐rulu'na ga waŋgany bäythinyaranydja, barrkuwatjkuŋala bukmakkurru yana wäŋakurru, märr ŋunhilimiyi wäŋaŋuranydja malaŋuŋura yolŋu walala yurru walŋana nhina, bäyyi ŋayi ŋula bumara maŋutji‐yunupanydja yolŋunha. ");
INSERT INTO gnn_vpl VALUES ("JS23_1","007_23_1","JOS","23","1","2","Ŋayi Djatjuwanydja wirrkina djawuḻpa'yina worruŋuyinana, bala ŋayi gawaw'yurruna ga buku‐ḻuŋ'maraŋala ŋurru'‐ŋurruŋunhana ga ŋaḻapaḻmirrinhana ga bukmaknhana yolŋu'‐yulŋunha, bala yana ŋayi waŋana bitjarrana, “Worruŋuna ŋarra dhuwala, galki ŋarra yurru rakunydhirrina. ");
INSERT INTO gnn_vpl VALUES ("JS23_3","007_23_3","JOS","23","3","3","Liŋgu muka nhumapinydja marŋgina dhuwala, ga nhäŋalana nhuma liŋguna nhaltjarra ŋayi Garrayyu ŋilimurrunha guŋga'yurruna marrtjina, ga gäŋala marrtjina lili ḻatju'kuŋala dhika. Ŋayi gukuŋala ŋunha miriŋunha dhipuŋuru wäŋaŋuru, märr ŋilimurru yukurra yurru nhina dhiyala ŋamathamana, liŋgu ŋilimurruŋgunydja Garray God dhuwala warray ŋilimurruŋgala gali'ŋura. ");
INSERT INTO gnn_vpl VALUES ("JS23_4","007_23_4","JOS","23","4","4","Guyaŋiya walala ŋunhinydja, ŋunhi ŋarra gulk‐gulkthurruna dhuwala wäŋa malanha ganaŋ'maraŋala, ga weka'‐wikaŋala nhumalaŋgalana goŋlili, waṉa‐nherrara dhiyaku bäpurru'wu ga bäpurru'wu ga bäpurru'wu. Dhika bala wiripuŋuminydja wäŋaŋura malanyŋumi miriŋunydja marrtji nhina'‐nhina mukthun yana märr‐ḻurrku'‐ḻurrkun, ");
INSERT INTO gnn_vpl VALUES ("JS23_5","007_23_5","JOS","23","5","5","yurru waṉḏirri warray walala yurru yulŋunydja, ŋunhi nhuma yurru ŋupandja gukumanydja walalanha, dhawaṯmaramanydja yurru ŋuliŋuru nhumalaŋgala wäŋaŋurunydja malaŋuŋuru, liŋgu Garraynydja dhuwala nhumalaŋgala gali'ŋura. Dhuwalanydja wäŋa yukurra yurru djingaryun nhumalaŋguwaynha yana, bitjan liŋgu yana bitjarra ŋayipi Garrayyu dhäwu'‐nherrara nhumalaŋgu. ");
INSERT INTO gnn_vpl VALUES ("JS23_6","007_23_6","JOS","23","6","6","“Nhiniyanydja walala wuṉḏaŋarryiya, ga biyaka liŋgu malthurranydja nhanŋuway dhärukkunydja Godku. Djämanydja dhuḏakthurranydja biyaka yana liŋgu ŋunhi yukurra makarr dhäruk waŋa dhiyalami djorra'ŋura, ŋunhi ŋayipi Mawtjitjthu wukirri. Yaka ŋanydjaḻa'yurra ŋuliŋuruyi dhärukŋuru ga romŋuru, ");
INSERT INTO gnn_vpl VALUES ("JS23_7","007_23_7","JOS","23","7","7","ga yaka ḻunduthiya ŋuruku wiripuŋuwunydja yolŋu'‐yulŋuwu, ŋunhi walala yukurra ŋuyulkthirri Godku ŋuli. Ŋunhiyinydja yätjmirrina yolŋu walala, ga walalaŋgu waŋarrnydja malanha yakana yuwalkŋu wal'ŋu. Yaka märr‐ŋal'yurra walalaŋgalaŋuwu waŋarrwu. ");
INSERT INTO gnn_vpl VALUES ("JS23_8","007_23_8","JOS","23","8","8","Ŋayathaŋa baṯ biyakanydja ŋanyapinyay Garraynha, ga dhambay‐manapanmiya waŋganygala yana waŋarrwala yuwalkŋuwala wal'ŋu yana. ");
INSERT INTO gnn_vpl VALUES ("JS23_9","007_23_9","JOS","23","9","9","Liŋguna ŋayi Garrayyunydja gukuŋalana waṉḏinyamaraŋalana yanana ŋunhinydja ḏälmirrinhanydja gal'ŋu miṯtjinha, walala gundupuŋalana nhumalaŋgalanydja bena‐wala, yakana yukurrana waŋgany dhärrana nhumalaŋgu gulmaranharawu; nhumanydja yana djuḻkmaraŋalana‐wala walalanha warrpam'thurrunana. ");
INSERT INTO gnn_vpl VALUES ("JS23_10","007_23_10","JOS","23","10","10","Waŋganydhunydja nhuma yurru gukuma waṉḏinyamaramana‐wala ŋula nhämunha'nhana miṯtjinha; mirithirrina guḻku'na yurru waṉḏirrinydja‐wala nhokala dhärukthu, liŋgu ŋayipinydja Garraynydja nhokala warray gali'ŋura, ga dhawu'‐nherraranydja ŋayi nhumalanha, ŋunhi ŋayipina yurru dhawar'maramanydja buma walalanha warrpam'thundja nhumalaŋgu. ");
INSERT INTO gnn_vpl VALUES ("JS23_11","007_23_11","JOS","23","11","11","“Biyaka gurrum'thurra yulŋunydja nhäŋa, märr yurru nhe märr‐ŋamathirrinydja wirrki gal'ŋu yana märryu‐ḏapmarama Garraynhanydja nhumalaŋguway Godnhanydja. ");
INSERT INTO gnn_vpl VALUES ("JS23_12","007_23_12","JOS","23","12","12","Ŋunhi nhuma yurru ŋanydjaḻa'yundja ga ŋapanydja‐wekanharamirri dhiyakunydja Godku, ga mam'thun yurru dhambay‐manapanmirri ŋurikalanydja walalaŋgala ŋunhi walala yaka marŋgi Godku, ga märrama yukurra yurru dhäykanha ŋuliŋuruyi miṯtjiŋuru, ");
INSERT INTO gnn_vpl VALUES ("JS23_13","007_23_13","JOS","23","13","13","bala ŋayi yurru Godthunydja yakana nhumalanha biyapul guŋga'yun ŋunhimalayi, yakana ŋayi yurru miriŋunhanydja nhumalaŋgu gukuma. Walalanydja yurru miriŋuyunydja ŋuriŋiyi nhumalanha gaṯmaramana walalaŋgalay yätjthuna dhikana yana romdhu, bala nhumalanha yurru ŋayaŋu‐yätjkumana dhika nhäyuna romdhu, yana liŋgu ga warrpam'thun nhumalanha yurru baḏuwaḏuyun, ga yakana nhuma yurru ŋula waŋgany yolŋu yukurra nhinanydja dhiyalayi ŋamakurru'ŋuranydja wäŋaŋura, ŋunhi ŋayi Godthu nhumalaŋgu wekaŋala. ");
INSERT INTO gnn_vpl VALUES ("JS23_14","007_23_14","JOS","23","14","14","“Yo, galkina dhuwala walunydja, ŋarra yurru rakunydhirrina. Nhumanydja ŋunhi marŋgi muka ŋunhi ŋayi Godthu gäŋala ŋilimurrunha ḻatju'kuŋala dhika wal'ŋu, goŋ‐nherraṉmina ŋayi ŋilimurruŋgu, ga wekaŋalanydja ŋayi marrtjina ḻatju' malanha dhika wal'ŋu yana ŋamakurru'mirri. Yo, ŋäthilinydja wal'ŋu ŋunhinydja Godthu dhawu'‐nherrara nhä malanha ḻatju'mirri dhika yana, ga liŋguna ŋunhi djämawuynha nhanukuŋu yulŋunydja warrpam'nha, yakana ŋayi ŋula meṉguŋalanydja waŋgany. ");
INSERT INTO gnn_vpl VALUES ("JS23_15","007_23_15","JOS","23","15","15","Ga bitjarrayi liŋgu ŋayi Godthu raypirri'yurrunanydja waŋana dhäruk ŋilimurruŋgu. Ŋuli nhuma yurru yakanydja ŋayathama yukurra ŋunhi raypirri'yunara dhäruk, yana bilyun yurru ŋanydjaḻa'yundja wiripuŋulilinydja ŋula waŋarrwu buku‐ŋal'yunarawu, ŋayinydja yurru marina marrtji bathalana nhumalaŋgu, bitjanna yana liŋgu yurru bitjarra ŋayi waŋana raypirri'yurruna ŋäthili gal'ŋu. ");
INSERT INTO gnn_vpl VALUES ("JS23_16","007_23_16","JOS","23","16","16","Yo, ŋuli nhe yurru dham'thunmaranharamirri yakanydja nhanukala Godkalanydja, yana nhe yurru märr‐ŋal'yun yukurra waŋarrwu wiripuŋuwunydja, ŋula nhäkunydja maḏayin'kunydja romgu malaŋuwu, ŋayinydja yurru Godtja ŋaramurryirrina nhumalaŋgu wirrkina yana. Yakana yana nhuma yurru nhina yukurra weyin dhiyalanydja ŋamakurru'ŋuranydja wäŋaŋura ŋunhi ŋayi Godthu wekaŋala nhumalaŋgu.” ");
INSERT INTO gnn_vpl VALUES ("JS24_1","007_24_1","JOS","24","1","1","Bala ŋayi Djatjuwayu buku‐ḻuŋ'maraŋalana yolŋu'‐yulŋunha ŋunhi Yitjuralpuyŋunhanydja bukmakkuŋala yana, walala marrtjina yurrum'thurruna waŋgany‐manapanminanydja gumurrŋura Garraywalana, ŋurru'‐ŋurruŋu gal'ŋu ŋunhi yolŋu walala ga wiripu‐guḻku' yolŋu'‐yulŋu. ");
INSERT INTO gnn_vpl VALUES ("JS24_2","007_24_2","JOS","24","2","2","Bala Djatjuwanydja gaŋgathina, bala waŋana bitjarrana gam'. “Dhuwalanydja gay' dhäruk ŋulaŋuru Garraywuŋu, Yitjuralpuyŋuwalaŋuwuŋu ŋunhi Godkuŋu, dhuwala ŋunhi ŋayi Garray waŋanydja yukurra nhumalaŋgu dhäruktja gam'. Baman'tja benydja wal'ŋu nhumalaŋgu märi'mu walala nhinana yukurrana be‐wala barrku wäŋaŋura, Yipurayimgu ŋunhi bäpa'mirriŋu yäku Dera ga nhanŋu gurruṯu'mirri walala, ga buku‐ŋal'yunanydja walala ŋuli yukurranha wiripuŋuwu waŋarrwunydja. ");
INSERT INTO gnn_vpl VALUES ("JS24_3","007_24_3","JOS","24","3","3","Bala ŋarra ŋunhi märraŋalana nhumalaŋgu märi'munhanydja Yipurayimnhanydja, dhawaṯmaraŋalana ŋarra märraŋalana ŋuliŋuruyi wäŋaŋurunydja, bala ŋarra ŋanya gäŋalanydja dhipalana wäŋalili Gaynanlilina. Gäŋalanydja ŋarra marrtjina ŋanya balakurruyina wäŋakurrunydja, ga miṯtjinydja nhanŋu mirithinana gaŋdhurruna gal'ŋu. ");
INSERT INTO gnn_vpl VALUES ("JS24_4","007_24_4","JOS","24","4","4","Yo, ŋäthilinydja ŋarra Yipurayimgunydja ŋunhi wekaŋala gäthu'mirriŋunha Yitjaknha, ga nhanŋu Yitjakkunydja ŋarra wekaŋala gäthu'mirriŋunha märrma'nhana, Djaykupnhana ga Yetjunhana. Wekaŋala ŋarra ŋunhi buku'‐wukunydja wäŋa nhanŋu Yetjuwu, ga ŋayinydja Djaykuptja ga nhanŋu djamarrkuḻiny'tja marrtjina balayi Yetjiplili wäŋalili. ");
INSERT INTO gnn_vpl VALUES ("JS24_5","007_24_5","JOS","24","5","5","Ga biyapul ŋarra yänguŋala Mawtjitjnhana ga Yärunnhana walalaŋgunydja, ga bitjarra ŋarra yukurrana ŋoy‐wurakina ŋurikala Yetjippuyŋuwalanydja yolŋu'‐yulŋuwala, yurru nhumalanhanydja ŋarra dhawaṯmaraŋala warray ŋuliŋuruyi, walŋakuŋala warray. ");
INSERT INTO gnn_vpl VALUES ("JS24_6","007_24_6","JOS","24","6","7","Yo, ŋarra nhumalaŋgu bäpa'mirriŋunhanydja walalanha dhawaṯmaraŋalana beŋuru Yetjipŋurunydja, bala walala marrtjinana yukurrana, yana liŋgu‐u‐u ga bunana walala Miku'ŋurana Gapuŋuranydja. Walalanydja yukurrana ŋuriŋi miriŋuyunydja ŋuparana walalanha bena dhikana miṯtjiyu gal'ŋu, yarraman'mirriyuna nhäyuna ŋupara walalanha, bala nhumalaŋgala ŋuriŋi bäpa'mirriŋuyunydja walalay märrliliyaŋala gawaw'yurruna ŋarrakuna guŋga'yunarawunydja, bala ŋarra ŋunhi maŋutji‐ŋäkirrmaraŋalanydja miriŋunhanydja walalanha warumukthuna maŋandhunydja. Ŋarra ḻapmaraŋalana ŋunhi gapunydja dhukarrkuŋalana, bala nhumanydja marrtjina buḏapthurrunana yukurrana baṉḏany'kurruna wäŋakurru yanana, yurru gapuyunydja ŋuriŋiyi walalanhana dhä‐monyguŋala, bala walala murrmurryurrunana warrpam'nha. Nhuma marŋgi muka yulŋunydja ŋunhi ŋarra walŋakuŋala nhumalanha beŋuruyi miriŋuwala goŋŋuru. ");
INSERT INTO gnn_vpl VALUES ("JS24_8","007_24_8","JOS","24","8","8","“Yo, ŋunhilinydja nhuma yukurrana nhinana ŋanhdharkŋuranydja wäŋaŋura märr‐weyinnha, bala ŋarra nhumalanha gäŋalana yana galkikuŋalana dhipalayinayi wäŋalili, yurru yolŋu'‐yulŋu yukurrana nhinana ŋunhiliyi wäŋaŋura wuṉḏaŋarrmirrina dhika wal'ŋu. Walala ŋunhi guyaŋina yanapi walala yurru nhumalanha baḏuwaḏuyun warrpam'thun, yurru ŋarranydja wekaŋala walalanha nhumalaŋgala warray goŋlili, bala nhumana märraŋala wäŋanydja walalaŋgu. Liŋgu nhuma nhäŋalana ŋunhi yulŋunydja, ŋunhi ŋarra walalanha baḏuwaḏuyurruna warrpam'thurruna nhumalaŋgala milma. ");
INSERT INTO gnn_vpl VALUES ("JS24_9","007_24_9","JOS","24","9","9","Ga wiripunydja buŋgawa ŋurruŋu waŋana Baylamgala bitjarra, ‘Waŋiya buku‐wuykthurrana ŋunhi Yitjuralpuyŋunhanydja,’ bitjarra. ");
INSERT INTO gnn_vpl VALUES ("JS24_10","007_24_10","JOS","24","10","10","Yurru yaka warray ŋayinydja bitjarrayi, yana ŋayi waŋananydja goŋmirri warray dhika wal'ŋu dhäruk nhumalaŋgalaŋuwuy, bala ŋarra nhumalanha dhawaṯmaraŋalana yana beŋuruyinydja buŋgawawalanydja goŋŋuru. ");
INSERT INTO gnn_vpl VALUES ("JS24_11","007_24_11","JOS","24","11","11","“Dhäŋuru ŋuliŋuruyinydjayi nhuma buḏapthurrunana yukurrana ŋurikiyi Djodanbuyŋunydja mayaŋ'ku, bala dhipalayina gali'lili wäŋalili gulŋiyina. Yolŋu'‐yulŋu ŋunhi Djarikupuyŋunydja, ga bukmak yolŋu walala ŋunhi walala yukurrana nhinana dhiyalayi wäŋaŋura, walalanydja yukurrana ŋuyulkthina nhumalaŋgu wirrki yana, walala bini nhumalanha dhawar'maranha muka bunhanydja warrpam'thunna, yurru ŋarrakalanydja ganydjarryu nhuma warray walalanha warray dhawar'maraŋalanydja, warrpam'thurruna warray. ");
INSERT INTO gnn_vpl VALUES ("JS24_12","007_24_12","JOS","24","12","13","Yaka ŋunhi nhumapinydja nhumalaŋgalaynydja ganydjarryu walalanha djuḻkthunmaraŋala, liŋgu ŋarrana walalanha ŋunhi beyaṉu‐wukuŋalanydja ŋunhi nhuma marrtjina galkithina, bala walala gundupuŋalana bena‐wala. Yaka ŋunhi nhuma walalanha bumara garayunydja dhika nhäyunydja mandjawakthunydja. Ŋarrapi yana waŋganydhu wekaŋalanydja dhuwalayi nhumalaŋgala goŋlilinydja wäŋanydja, ga dhiyaŋunydja‐wala nhuma yukurra nhina buṉbuŋura malaŋumi wiripu‐guḻku'wuŋuna dhuḻ'yunara, ga ḻuka nhuma yukurra ŋathanydja dholkunhara wiripu‐guḻku'wuŋuna. Ga bitjarrayina ŋayi yukurrana Garraynydja waŋana.” ");
INSERT INTO gnn_vpl VALUES ("JS24_14","007_24_14","JOS","24","14","14","Bala ŋayi Djatjuwanydja mukthurruna yana waŋana yukurrana walalanha bitjarra gam'. “Ga dhiyakuyina märrwu nhuma yurru borrk‐beyaṉiyirrina yukurra Garraywunydja, ga djäma yurru yukurra nhanŋuwaynha wal'ŋu yana yuwalkkumana. Gatjuy ḏupthurrana walala ŋunhiyinydja malanha nhumalaŋguway be nhänydja waŋarrnha malaŋunha, maḏayin'tja dhika nhänydja, ŋunhi nhumalaŋgu yukurrana märi'mu walala buku‐ŋal'yurruna ŋunhala barrku. Biyaka ḏupthurrana, gonha'yurrana warrpam'thurrana, ga buku‐ŋal'yurranydja waŋganyguna, nhanŋuwaynha Garraywuna yana. ");
INSERT INTO gnn_vpl VALUES ("JS24_15","007_24_15","JOS","24","15","15","“Bay', yolku dhika nhe yurru märr‐ŋal'yundja yukurra? Dhiyaŋunydja‐wala nhumapi yurru djarr'yurra. Yol dhika nhumalaŋgu waŋarrnydja? . . . Ŋunhiyi waŋarr malanha ŋunhi nhumalaŋgu bäpa'mirriŋu walala ŋuli yukurranha buku‐ŋal'yuna? . . . ŋunhiyi? Yolku dhika nhe yurru buku‐ŋal'yundja? Ŋurikalaŋuwu walalaŋgalaŋuwu waŋarrwu? . . . ŋunhi walala yukurra nhina dhiyala wäŋaŋura? Yol yurru nhuŋunydja waŋarr? Yolku dhika nhenydja yurru malthun yukurra? Ma' nhepi djarr'yurranydja ga ḻiya‐ŋamaŋamayunmiyanydja. Yo, ŋarrapinydja yurru ga ŋarraku gurruṯu'mirri walala, ŋanapurrunydja yurru buku‐ŋal'yun yukurra waŋganygu yana waŋarrwu Godku, ŋayipi yana waŋgany yurru ŋanapurruŋgunydja Garray God.” Bitjarra ŋayi Djatjuwa waŋana ḻakaranhaminanydja. ");
INSERT INTO gnn_vpl VALUES ("JS24_16","007_24_16","JOS","24","16","16","Ga walala ŋunhi yolŋu'‐yulŋunydja buku‐wakmaraŋala waŋana Djatjuwawala bitjarra, “Ŋanapurrunydja yurru yaka ganan Garraynha, ga buku‐ŋal'yun wiripuŋuwunydja waŋarrwu yakana. ");
INSERT INTO gnn_vpl VALUES ("JS24_17","007_24_17","JOS","24","17","17","Ŋäthilinydja ŋunhinydja ŋanapurru yukurrana nhinana garrpiṉarawuyŋura romŋura, ga ŋayipi yana ŋunhi Godthu Garrayyu walŋakuŋalanydja dhawaṯmaraŋalanydja ŋanapurrunha beŋuruyi miriŋuwalanydja goŋŋuru. Ŋanapurru nhäŋala ŋanya ŋunhi ŋarambiyany'tja, ŋunhi ŋayi djäma yukurrana milma ŋanapurruŋgala ganydjarr‐ḏumurru wal'ŋu dhika rom malanha. Gäŋala ŋayi yukurrana gurrum'thurruna ŋanapurrunha, walŋakuŋala beŋuru liŋgu ga dhipala wapthurruna. ");
INSERT INTO gnn_vpl VALUES ("JS24_18","007_24_18","JOS","24","18","18","Ŋayi gukuŋala miriŋunhanydja warrpam'thurruna ŋunhi yukurrana nhinana dhiyala wäŋaŋura, bitjarrana walala yukurrana gundupuŋalana ŋanapurruŋgalanydja, ŋunhi ŋanapurru marrtjina galkithina. Waŋganyguna yana nhanŋuwaynha ŋanapurru yurru buku‐ŋal'yundja yukurra Garraywuna, liŋgu ŋayipina waŋganynha ŋanapurruŋgunydja God.” Bitjarrayi walala yukurrana ŋunhi yolŋu'‐yulŋunydja waŋanhamina. ");
INSERT INTO gnn_vpl VALUES ("JS24_19","007_24_19","JOS","24","19","19","Bala ŋayi Djatjuwayunydja waŋana walalanha bitjarrana, “Yakana nhuma yurru märr‐ŋal'yun ŋamathamanydja ga yuwalktja gal'ŋu nhanŋu Godku. Godtja dhuwala gäna gal'ŋu ḏarrtjalk, ganaŋ'thun yukurra dhiyakuywala munatha'wuywalanydja nhäkala malaŋuwala. Ŋunhi nhuma yurru rrambaŋikumanydja märr‐ŋal'yun nhanukala Godkala ga wiripuŋuwala waŋarrwala, waŋgany‐manapanmirrinydja yurru, ŋayinydja yurru Godtja ŋaramurryirrina yana nhumalaŋgunydja; yakana ŋayi yurru bäy‐ḻakaramanydja nhumalaŋgu balanyarawuynydjayi yätjpuy. ");
INSERT INTO gnn_vpl VALUES ("JS24_20","007_24_20","JOS","24","20","20","Ŋuli nhuma yurru bilyun ga meṉgumanydja Godnha, ḏiltjinydja wekama ḻayḻayyun ŋula nhäŋuranydja waŋarrŋura malaŋumi, ŋayi yurru Godtja bilyundhi, ŋapana yurru wekama nhuŋunydja, yana ŋayi yurru baḏuwaḏuyunna nhuna, bäyyi ŋunhi ŋäthili ŋayi nhumalanha goŋmirriyaŋala.” ");
INSERT INTO gnn_vpl VALUES ("JS24_21","007_24_21","JOS","24","21","21","Ga walalanydja ŋunhi yolŋu'‐yulŋunydja waŋana Djatjuwawalanydja bitjarrana, “Yaka ŋanapurru yurru yukurra dhuwala ŋayathama baṯ bitjan wiripuŋunhanydja ŋula waŋarrnha. Yuwalk yana ŋanapurru yurru dhuwala märr‐ŋal'yun nhanŋuway yana Godku waŋarrwu, yuwalkkuma gal'ŋu yana buku‐ŋal'yun nhanŋuway yurru.” ");
INSERT INTO gnn_vpl VALUES ("JS24_22","007_24_22","JOS","24","22","22","Bala ŋayi Djatjuwanydja waŋana bitjarrana ŋuriki yolŋu'‐yulŋuwunydja, “Yo, liŋguna nhuma dhuwali ŋänharaminana nhumalanhay nhuma bala‐lili'yunminana, ŋunhi nhuma dhawu'‐nherrara yoranhamina bitjarrayi, ‘Ŋanapurrunydja djarr'yurruna waŋganynha ŋanyapinyay Garraynhana, ŋayi yurru ŋanapurruŋgunydja Waŋarr God. Nhanŋuway yana waŋganygu ŋanapurru yurru yukurra buku‐ŋal'yundja.’ Bitjarra nhuma yukurrana waŋananydja.” Ga walalanydja waŋana ŋunhi yolŋu'‐yulŋunydja bitjarra, “Yuwalk dhuwalanydja ŋanapurru waŋana dhawu'‐nherrara bitjarrayinydja, ga dhawuny'tja yurru dhuwalayinydjayi djingaryunna yukurra yanana djambimiriwnha nhämiriwnha.” ");
INSERT INTO gnn_vpl VALUES ("JS24_23","007_24_23","JOS","24","23","23","Bala ŋayi Djatjuwanydja waŋana bitjarra, “Yo manymak. Yurru wiripu‐guḻku'yunydja nhuma yukurra baḏak yana ŋayathama maḏayin' malanha, waŋarr malanha. Biyakana warrkuḻuŋuna dhuwaliyinydjayi nhä malanha, warrpam'thurrana baḏuwaḏuyurra, bala wekanhamiya warrpam'thurrana ŋayaŋunydja nhumalaŋguway nhuma Garraywalana, märr nhumanydja yurru nhanŋuwaynha yana walala dhulŋuŋuna.” ");
INSERT INTO gnn_vpl VALUES ("JS24_24","007_24_24","JOS","24","24","24","Bala walala ŋunhi bukmaktja yolŋu walala waŋana Djatjuwawalanydja bitjarrana, “Ŋanapurrunydja yurru dhuwala buku‐ŋal'yun nhanŋuwaynha yana Godkuna waŋganyguna, liŋgu ŋayipina waŋganynha waŋarr ŋunhi ŋanapurruŋgunydja. Ŋanapurru yurru mäkiri'‐witjun ga ŋäma ŋanyapinyay yana dhäruktja, bala djämana; dhäruktja ŋanya yurru märramana yana.” ");
INSERT INTO gnn_vpl VALUES ("JS24_25","007_24_25","JOS","24","25","25","Bala ŋulinyaramirriyunydjayi walala dhawu'na yana nherrara Garraywalanydja, bala ŋayi Djatjuwayu ḻakaraŋala romnha malanha Godku ŋuriki yolŋu'‐yulŋuwunydja, märr yurru walala yuwalkkuma gal'ŋu yana malthundja marrtji nhanŋuway Garraywu yana. ");
INSERT INTO gnn_vpl VALUES ("JS24_26","007_24_26","JOS","24","26","26","Ga biyapul ŋayi wukirrina marrtjina ŋunhiyinydjayi dhawuny'tja, dhäruktja walalanha djorra'lilina. Bala ŋayi märraŋala bathalana ŋanyana guṉḏa, bala nherrara ŋaṉḏarr'maraŋalana ŋunhiwala Garraywalana wäŋalili. ");
INSERT INTO gnn_vpl VALUES ("JS24_27","007_24_27","JOS","24","27","27","Bala ŋayi waŋana yolŋu'‐yulŋuwalanydja bitjarrana, “Dhiyaŋunydja gay' guṉḏayu liŋgu ŋäkulana nhumalanha dhäruktja, ŋunhi nhuma dhawu'‐nherraranydja waŋananydja gäthura, ga djingaryunna yana ŋayi yukurra yurru dhuwala mukthunna yulŋunydja, ga bitjanna liŋguna yurru dhiyaŋuyi nhumalanha guyaŋinyamirriyamanydja yukurra, märr yurru nhuma yakana bilyundja ŋapanydja‐wekama Garraywu.” ");
INSERT INTO gnn_vpl VALUES ("JS24_28","007_24_28","JOS","24","28","28","Bala ŋayi ŋuliŋuruyinydja dhurrwaraŋuru Djatjuwayu djuy'yurrunana yukurrana yolŋu'‐yulŋunhanydja wäŋalilina walalaŋgalay walala. ");
INSERT INTO gnn_vpl VALUES ("JS24_29","007_24_29","JOS","24","29","30","Bala ŋuliŋuruyi dhäŋuru ŋayi Garraywunydja djämamirri yolŋu ŋunhi Djatjuwanydja rakunydhinana, ga dhuŋgarranydja ŋayi ŋunhi 110‐nha; ga dhalkaraŋalanydja walala ŋanya ŋunhimalayi nhanukiyingalaynha ŋayi wäŋalili. ");
INSERT INTO gnn_vpl VALUES ("JS24_31","007_24_31","JOS","24","31","31","Yo, ŋunhi ŋayi Djatjuwa yukurrana walŋaŋga yana nhinana, ga yolŋu'‐yulŋu ŋunhi Yitjuralpuyŋunydja yukurranha ŋuli malthuna nhanŋuwayŋga yana Garraywuŋga, ga ŋuliŋurunydja dhurrwaraŋuru ŋunhi ŋayi Djatjuwa rakunydhinana, mukthurrunaŋga yana walala buku‐ŋal'yurruna yukurrana Garraywu, liŋgu ŋurru'‐ŋurruŋu walalaŋgu ŋunhi yolŋu'‐yulŋu mel‐marŋgimirri ŋurikiyi ŋunhi nhaltjarra ŋayi Godthu yukurrana gäŋala walalanha manymakkuŋala. ");
INSERT INTO gnn_vpl VALUES ("JS24_32","007_24_32","JOS","24","32","32","Yo, ŋunhi walala dhawaṯthurrunanydja ŋulaŋuru Yetjipŋurunydja ŋäthili, walalanydja ŋuriŋi Yitjuralpuyŋuyunydja yolŋu'‐yulŋuyu djaw'yurrunana ŋanya ŋarakanydja lili Djotjipnha, bala dholkuŋalanydja ŋanya walala ŋunhi Djikamlilina wäŋalili yäkulili. ");
INSERT INTO gnn_vpl VALUES ("JS24_33","007_24_33","JOS","24","33","33","Ga bitjarrayi liŋgu ŋayinydja ŋunhi ŋurruŋunydja ḏalkarra'mirri yolŋu rakunydhina, yäku Layatjanydja, ga dholkuŋalanydja walala ŋanya buku'‐wukulilina wäŋalilinydja. ");
INSERT INTO gnn_vpl VALUES ("JG1_1","008_1_1","JDG","1","1","1","Dhäŋuru ŋuliŋuru ŋunhi ŋayi Djatjuwa liŋguna rakunydhinana, Godkunydja yolŋu walala Yitjuralpuyŋunydja nhinana yukurrana wäŋaŋura Gaynannha, bala yana walala waŋana dhä‐wirrka'yurruna Garraynha Godnha bitjarra gam'. “Yolthuŋga yurru dhuwala buma gukuma ŋunha gay' Gaynanbuyŋunhanydja yolŋu'‐yulŋunha?” ");
INSERT INTO gnn_vpl VALUES ("JG1_2","008_1_2","JDG","1","2","2","Ga Garraynydja waŋana buku‐roŋiyinmaraŋala ḻakaraŋala walalaŋgu bitjarra, “Djudawala bäpurru'yu malaŋuyu ŋuriŋiyi; ŋarra yurru wäŋanydja dhuwala wekama walalaŋgalana goŋlilinydja.” ");
INSERT INTO gnn_vpl VALUES ("JG1_3","008_1_3","JDG","1","3","3","Bala yana walala Djudawalanydja miṯtjiyu waŋana Djimiyangalaŋuwuna miṯtjiwu bitjarrana, “Go guŋga'yurrana ŋanapurrunha, ŋilimurru yurru dhuwala Gaynanbuyŋunhana walalanha gukuma dhawaṯmaramana dhipuŋuru ŋanapurruŋgalanydja wäŋaŋuru. Ga dhawar'maranharaŋurunydja, bala ŋanapurrunydja yurru nhumalanhana guŋga'yun, ga ŋunhanydja walalanhanydja gukumana, ŋunhi walala yukurra nhina ŋunha nhumalaŋgala wäŋaŋura baḏak.” ");
INSERT INTO gnn_vpl VALUES ("JG1_4","008_1_4","JDG","1","4","8","Bala yana yuwalkthi walala ŋunhiyi miṯtjinydja maṉḏanha waŋgany‐manapanminana, bala yana nyäṉ'thurrunana, ga warrpam'nha yana walala bumaranydja dhawar'maraŋalana ŋunhi Gaynanbuyŋunhanydja walalanha buku‐waŋganynha. Ga bitjarrayi liŋgu walala bumara dhawar'maraŋala ŋunhi wiripunhanydja malanha yolŋu'‐yulŋunha Biritjpuyŋunhanydja miṯtjinha ga walalambala buŋgawanha giŋnha. Ga ŋunhi walala Djudawalanydja malayu bitjarrayi liŋgu wäŋa märraŋala ŋunhanydja Djurutjalambuynydja, ga bitjarra yana liŋgu walala bumara yolŋunha walalanha dhawar'maraŋala, ga wäŋanydja buku‐yapmaraŋalana, bala ḏul'yurrunana gurthayuna, liŋgu yolŋu'‐yulŋu nhinana yukurrana ŋunhala Djurutjalamdja mirithirrina dhikana yätjmirrina. ");
INSERT INTO gnn_vpl VALUES ("JG1_9","008_1_9","JDG","1","9","19","Ga ŋuliŋurunydja dhurrwaraŋuru walala Djudawunydja mala marrtjina ŋunhana buku'‐wukulilina ŋal'yurruna, ga ŋuliwitjarrana marrtjina yolŋunha walalanha bumara, ga bitjarrayi liŋgu ŋunha balkuwarra'kurrunydja, bumara walala marrtjina yolŋu'‐yulŋunha ŋoykurrunydja bala buku'‐wukukurrunydja, bumarana marrtjina bala walala yolŋu'‐yulŋunhanydja ŋunhi wäŋakurruna, dhawa'‐dhawarmaraŋalana marrtjina bala bala'‐maypamirrikurruna, bumaranydja marrtjina walala bala‐a‐a, ga baḏatj wiripuŋulilina, ga dhawar', ga baḏatj wiripuŋulilina; bitjarrana liŋgu‐u‐u, yana liŋgu ga raŋilili wapthurruna gali'lili. Ga dhuwalanydja wäŋanydja maṉḏanha walala märraŋala Gäthawuy ga Watjkalunbuy ga wiripu wäŋa malanha ḻiw'marama ŋunhiyi. Yo, Djudawala malayu ŋunhiyinydja wäŋa malanha märraŋala warrpam'nha, liŋgu Garray walalaŋgalanydja galki gali'ŋura, guŋga'yurruna marrtjina walalanha. ");
INSERT INTO gnn_vpl VALUES ("JG1_20","008_1_20","JDG","1","20","21","Ga ŋayinydja djawuḻpa'yunydja ŋuriŋiyi yäkuyu Gaylipthunydja, ŋayinydja marrtjina ga gukuŋala bumara yolŋu'‐yulŋunha ŋunhala wäŋaŋura warray, ŋunhi walala yukurrana nhinana mukthurruna Yiprunbuyŋunha yolŋu'‐yulŋunha; ŋunhalayi ŋayinydja bumara, liŋgu ŋunhiyi nhanŋuwaynydja wal'ŋu wäŋa ŋaraka. ");
INSERT INTO gnn_vpl VALUES ("JG1_22","008_1_22","JDG","1","22","26","Walalanydja Burayimgalanydja malayu bumara marrtjina Gaynanbuyŋunhana yolŋunha walalanha ŋunhala Bithulnha yäkuŋura wäŋaŋura, yurru yaka warray walala bumara dhawar'maraŋalanydja wal'ŋu, walala ŋunhi wiripu‐guḻkuny'tja nhina'‐nhinana warray marrtjina yana mukthurruna warray, yaka warray walala bukmakkuŋalanydja wal'ŋu bumara, gukuŋala dhawaṯmaraŋalanydja ŋuliŋuru wäŋaŋuru. ");
INSERT INTO gnn_vpl VALUES ("JG1_27","008_1_27","JDG","1","27","28","Ga walalanydja Manatjawalanydja malayu, ga bitjarra yana liŋgu walalanydja wiripu‐guḻku'nha bumara, ga wiripu‐guḻku'nhanydja gonha'yurruna warray, ga yaka warray bukmakkuŋalanydja dhawar'maraŋala warrpam'thurrunanydja. Ga yalalaŋumirriyuna ŋunhi walala Yitjuralpuyŋunydja guḻku'thinana ŋuthara wirrkina, bala walala waŋanana bitjarrana gam'. “Ŋilimurru yakana dhuwalanhanydja yolŋu'‐yulŋunha Gaynanbuynhanydja gukuma ŋi'! Gonha'yunna ŋilimurru yurru walalanha, märr walala yurru ŋilimurruŋgu djämamirrina walala; walala yurru dhiyalana bili nhina, ga wirrkina walala yurru djäma yukurra ŋilimurruŋgu.” ");
INSERT INTO gnn_vpl VALUES ("JG1_29","008_1_29","JDG","1","29","36","Bala walala yuwalkthi gonha'yurrunana walalanha ŋunhimalana liŋgu, ga mukthurrunana walala yukurrana nhinana ŋunhili walalaŋgalana, ga yakana walalanha ŋurrumaraŋala gukuŋalanydja ŋuliŋuruyi dhawaṯmaraŋalanydja. Yo, walala meṉguŋalana ŋunhi buku‐dhumukthinana Djatjuwanhanydja dhäruk, yana walala yarryurrunana ŋuriki Godkalaŋunydja dhärukku. Yakana walala bumara gukuŋala warrpam'thurruna wal'ŋu ŋunhi Gaynanbuyŋunhanydja yolŋu'‐yulŋunha; yana walala gonha'yurrunana walalanha ŋunhimalana, ga nhinanana walala yukurrana ŋunhilina walalaŋgalana malaŋura mala‐manaparana. ");
INSERT INTO gnn_vpl VALUES ("JG2_1","008_2_1","JDG","2","1","1","Bala ŋuliŋurunydja dhurrwaraŋuru ŋayina bunana ŋulaŋuruna lili djiwarr'wuynha yolŋu Garraywuna dhäwu'‐gänharamirri, ga waŋananydja ŋayi bitjarrana ŋurikala Yitjuralpuyŋuwalanydja yolŋu'‐yulŋuwala, “Ŋarra nhumalanha dhawaṯmaraŋalanydja ŋulaŋurunydja Yetjipŋurunydja, ga gäŋala nhumalanha dhipala gay' wäŋalili; ŋarra wekaŋalana dhuwala wäŋa nhumalaŋgalana goŋlili, bitjarra yana liŋgu bitjarra ŋarra dhäwu'‐nherrara ŋäthili nhumalaŋgalaŋuwala märi'muwala. Liŋgu ŋunhiyi ŋarrakuŋu dhäruk‐nherraṉminyara yukurra yurru djingaryunna yana, bitjanna liŋguna yukurra yurru yana. ");
INSERT INTO gnn_vpl VALUES ("JG2_2","008_2_2","JDG","2","2","2","Ŋarra nhumalanha waŋana raypirri'yurruna yakaŋuwu ḻunduthinyarawu wäŋa‐dhiyakuywu yolŋu'‐yulŋuwu; ŋarra waŋana nhumalanha nhuma yurru yana ḏaw'yun walalaŋgu ŋunhi waŋarr malanha, ga baḏuwaḏuyun ŋunhiyi wäŋa malanha ŋunhi walala ŋuli ŋunhimalayi buku‐ŋal'yunna walalaŋgiyingalaŋuwu waŋarrwu malaŋuwu ŋurikiyi malaŋuwu. Bitjarra ŋarra ŋunhi waŋananydja yukurrana, ga nhumanydja yaka warray mäkiri'‐witjurruna ga märraŋala ŋarranha dhäruk. ");
INSERT INTO gnn_vpl VALUES ("JG2_3","008_2_3","JDG","2","3","3","Yakana ŋarra yurru gukuma nhumalaŋgala ŋunha miriŋunhanydja, walala yukurra yurru nhinana dhiyalana bili, yurru marinydja walala yurru gäma yindi dhipala nhumalaŋgu, liŋgu ŋuruŋu walalaŋgalanydja romdhu nhumalanha yurru galkinyamarama ŋunhimala yätjlilina wal'ŋu romlili.” ");
INSERT INTO gnn_vpl VALUES ("JG2_4","008_2_4","JDG","2","4","4","Walalanydja ŋäkulana ŋuriŋi Yitjuralpuyŋuyunydja dhäruktja ŋunhiyi Garraynha, yurru walala nyä'yunminana gay', wirrkina dhikana walala ŋäthinyaminanydja. ");
INSERT INTO gnn_vpl VALUES ("JG2_5","008_2_5","JDG","2","5","5","Bala dhunupa marrtjina ŋunhi yolŋu'‐yulŋuyunydja ŋuriŋi mundhurrnha wekaŋala, wäyinnha bathara marrtjina, buku‐ŋal'yurrunana yukurrana Garraywuna. ");
INSERT INTO gnn_vpl VALUES ("JG2_6","008_2_6","JDG","2","6","11","Ŋäthilinydja ŋunhi ŋayi Djatjuwanydja yana walŋa muka, walala ŋunhi yolŋu walala Yitjuralpuyŋunydja yuwalkkuŋala wal'ŋu yukurrana buku‐ŋal'yurruna Garraywu, ga dhäŋuru ŋuliŋurunydjayi ŋunhi ŋayi Djatjuwa rakunydhinana, ga mukthurrunaŋga walala yukurrana buku‐ŋal'yurruna Godku. Ga yalalaŋumirriyuna ŋunhalana bala, bala walalanydja ŋanydjaḻa'yurrunana wiripu‐guḻku'wuna waŋarrwu walalaŋgu; walala buku‐ŋal'yurruna ŋurikina yukurrana waŋarrwu ŋunhi goŋbuywuna, ŋunhi walala yukurranha ŋuli Gaynanbuyŋu yolŋu'‐yulŋu buku‐ŋal'yunna ŋurikiyina waŋarrwu. Yo, walala yätjthina, ŋayaŋu‐yätjkuŋala Godnhana, liŋgu walala ŋanydjaḻa'yurrunanydja, bala gonha'yurrunana ŋanya Garraynha, ga buku‐ŋal'yurrunanydja yukurrana ŋurikina wiripuŋuwuna waŋarrwu yäkuwu Bälwuna. ");
INSERT INTO gnn_vpl VALUES ("JG2_12","008_2_12","JDG","2","12","15","Yo, walala ḏaḏawyurrunana Garraywala buku‐ŋal'yunaraŋuru, dhiyakunydja Godku, ŋunhi walalaŋgu märi'mumirriŋu walala märr‐ŋal'yuna ŋuli yukurranha, ŋurikinydja waŋarrwu ŋunhi ŋayi dhawaṯmaraŋala walalanha ŋuliŋuru garrpiṉminyaraŋuru romŋuru ŋunhi Yetjipŋuru; bilyurrunana walalanydja nhanukala, bala wiripuŋuwuna buku‐ŋal'yurruna yukurrana ŋurikina waŋarrwu walalaŋgu ŋunhi wäŋa‐ŋurikiywuna yolŋu'‐yulŋuwu Gaynanbuyŋuwalaŋuwuna, Bälwuna yäkuwu, ga wiripuŋuwu ŋuriki dhäykawu waŋarrwu Yatjarawu yäkuwu walala ŋuli yukurranha buku‐nyilŋ'thuna. Bala ŋayinydja marrtjina Godtja maḏakarritjthinana walalaŋgu Yitjuralpuyŋuwunydja ŋurikinydja miṯtjiwu, bala ŋayi walalanha gonha'yurrunana ŋunhimala, ga yakana ŋayi walalaŋgu yukurrana nyeyal‐nhinana biyapulnydja, ga gumurr‐gungaŋala walalanha yakana yukurrana biyapulnydja. Ga ŋunhi walala wiripu‐guḻkuny'tja yolŋu'‐yulŋu bäpurru' nyäṉ'thurruna Yitjuralpuyŋuwunydja, yanana walalanha bumarana ŋuriŋiyi miriŋuyunydja, liŋgu Garraynydja yakana walalaŋgala gali'ŋura biyapulnydja; gonha'yurrunana ŋayi yana walalanha, liŋgu walala nhanukala ŋanydjaḻa'yurruna, ga gonha'yurruna walala ŋanya Garraynha. Bala walala yukurrana nhinananydja yindiŋurana mariŋuranydja, galŋa‐yätjthinyamirriŋurana; wirrkina walala galŋa‐yätjthinanydja dhika. ");
INSERT INTO gnn_vpl VALUES ("JG2_16","008_2_16","JDG","2","16","17","Bala ŋayi Garrayyunydja walalanha nhäŋala, ga wekaŋala ŋurruŋunhana yolŋunha walŋakunharawu walalaŋgu ŋuliŋuru miriŋuwalanydja goŋŋuru. Yurru walalanydja ŋunhi Yitjuralpuyŋunydja bäpurru' yolŋu'‐yulŋu yakana mäkiri'‐witjurruna ga dhäruk‐märraŋala ŋunhinhanydja walalaŋguwaynydja wal'ŋu ŋurruŋunha, ŋunhi Godthu ŋayipi gathara walalaŋgu walŋakunharawu; walalanydja yana mukthurruna yukurrana buku‐ŋal'yurruna ŋurikala wiripu‐guḻku'wala waŋarrwala, yakana walala yukurrana dhärukku malthurruna nhanŋuwaynydja Garraywunydja, ŋunhi ŋayi dhäruk nherraṉmina. ");
INSERT INTO gnn_vpl VALUES ("JG2_18","008_2_18","JDG","2","18","19","Yo, Garrayyunydja ŋuli guŋga'yuna walalanha guḻku'mirri, walŋakunha walalanha ŋuli miriŋuwala, ga walalanydja yukurranha ŋuli nhinanha ŋamathanha‐wala yana, ŋunhi walalaŋgu buŋgawa yukurranha ŋuli walŋa nhinanha, liŋgu Garraynydja walalaŋgu ŋuli yukurranha mel‐wuyuna wirrki wal'ŋu, bili walala ŋuli yukurranha nyä'yunminya, galŋa‐miḏikinya nhinanha ŋunhiliyi goŋŋura ŋurikala miriŋuwala. Ga ŋunhi ŋuli walalaŋgu yolŋu ŋunhi ŋurruŋu bäyŋuthinya rakunydhinya, bala walalanydja ŋuli balayi ŋanydjaḻa'yuna, ŋunhimalayi liŋgu ŋäthiliŋulili romlili. Ga bulunydja walala ŋuli djäma wirrkina wal'ŋu yätj, yakana balanyara bitjan ŋunhi ŋäthili walala yukurrana djäma; bitjana liŋgu yana walala ŋuli buku‐ŋal'yuna wiripuŋuwu waŋarrwu walalaŋgu. Yakana walala ḏaḏawyurrunanydja ŋuliŋuruyi mokuywalanydja dhukarrŋuru, yana walala yukurrana nhinana ŋayaŋu‐ḏälmirrina, liŋgu walala ŋapa‐nherraṉminana, ŋuyulkthinana yukurrana Godkunydja, ga malthurruna yukurrana walalaŋgiyingalaŋuwuna walala dhukarrwu. ");
INSERT INTO gnn_vpl VALUES ("JG2_20","008_2_20","JDG","2","20","23","Bala Garraynydja walalaŋgu ŋuli maḏakarritjthinyana ŋuriki Yitjuralpuyŋuwunydja, ga waŋanha ŋuli bitjana gam'. “Liŋguŋga ŋarra romdja nherrara ga dhawu'‐nherraṉminanydja nhumalaŋgalaŋuwala märi'muwalanydja walalaŋgala, yurru walalanydja dhuwala nhä? . . . raypirri'‐waḏatjmirrina walala? Yakana walala ŋarrakunydja dhärukku malthurruna yukurrana. Yo, ŋarranydja yurru yakana gukuma dhuwalanhanydja walalanha wäŋa‐dhiyakuynhanydja yolŋu'‐yulŋunha dhipuŋurunydja wäŋaŋuru; ŋulawitjan walalaŋgalaŋukurrunydja ŋarra yukurra yurru nhämana, ga maḻŋ'maramanydja ŋunhiyi Yitjuralpuyŋunhanydja, wanhaka walala yurru ŋarrakuway malthun, wo bäyŋuna.” Bala ŋayi yuwalkthi Garrayyunydja yakana gukuŋala ŋunhi wiripunhanydja miṯtjinha yolŋu'‐yulŋunha, gonhana walala yurru yukurra nhina ŋunhilina bili mukthunna; yakana ŋayi biyapul walalanha gukuŋala ŋuliŋuruyi wäŋaŋuru, bitjarra ŋayi ŋunhi ŋäthili gukuŋala yukurrana. ");
INSERT INTO gnn_vpl VALUES ("JG3_1","008_3_1","JDG","3","1","6","Yo, ŋunhi wiripunydja miṯtji malanha yolŋu'‐yulŋu mukthurrunana yukurrana nhinana ŋunhilina bäymana Gaynannha, rrambaŋina ŋunhiyi Yitjuralpuyŋuna, ga dhuwala walala bäpurruny'tja gam', Gaynanbuy ga Yitjpuy ga Yamarpuy, ga wiripu‐guḻku' bäpurru' malanha. Yo, Godtja waŋana bitjarra, “Ŋunhiyinydjayi miriŋu walala yurru yukurra nhinana yana mukthunna ŋunhili Yitjuralnha, märr yurru ŋarrakunydja ŋunhi yolŋu walala marŋgiyirri nhaltjan walala yurru baḏuwaḏuyun miriŋunha. Ga bitjandhi liŋgu walala ŋarrakunydja yurru yolŋu'‐yulŋunha gatjarr'yundhi ŋuriŋiyi miriŋuyunydja, yana yurru maḻŋ'marama walalanha, wanhaka walala yurru dhärukku malthun ŋarraku, mak bäyŋu.” Yurru walalanydja ŋuriŋi Yitjuralpuyŋuyunydja ḏarramuwurruyu märraŋalana marrtjina ŋunhi wiripuŋunhana bäpurru'nha dhäykawurrunha, ga bitjarrayi liŋgu walala rarr'yurrunayi bala walalaŋgunydja gäthu'mirriŋunha walalanha dhäykawurrunha, ŋuriki Gaynanbuyŋuwunydja ḏarramuwurruŋgu märranharawu, bala walala yukurrana rrambaŋina buku‐ŋal'yurrunanydja ŋurikina waŋarrwu walalaŋgu wiripu‐guḻku'wuna Gaynanbuyŋuwuna. ");
INSERT INTO gnn_vpl VALUES ("JG3_7","008_3_7","JDG","3","7","7","Yo, ŋuriŋi Yitjuralpuyŋuyunydja yukurranha ŋuli djäma yätjnha mirithirrina dhika, ŋunhina malanha ŋunhi ŋayi yukurra God Waŋarr ŋaramurryirri ŋuriki malanyŋuwu, nhämunha'wu waŋarrwu walalaŋgu; walala buku‐dhumukthinana meṉguŋalana yuwalkŋunhanydja wal'ŋu waŋarrnha, ga djämanydja walala yukurrana ŋurikina waŋarrwu Bälwuna ga Yatjarawuna. ");
INSERT INTO gnn_vpl VALUES ("JG3_8","008_3_8","JDG","3","8","8","Bala ŋayinydja Garraynydja walalaŋgu wirrkina dhika ŋaramurryina ŋuriki Yitjuralpuyŋuwunydja, bala ŋayi marrtjina wekaŋalana walalanha ŋunhi Yitjuralpuyŋunhanydja miriŋuwalana goŋlili, ga ŋuriŋiyi giŋdhu miriŋuwalanydja yukurrana walalanha ŋayathaŋalanydja 8 dhuŋgarranydja ŋupara. ");
INSERT INTO gnn_vpl VALUES ("JG3_9","008_3_9","JDG","3","9","9","Bala walalanydja ŋunhi Yitjuralpuyŋunydja wäthurruna guŋga'yunarawuna nhanukala Garraywalana, ga ŋayinydja Godthunydja nherrara djarr'yurruna ŋurruŋunha yolŋunha walŋakunharawuna walalaŋgu, ḏarramunha yäkunha Watnilnhana. ");
INSERT INTO gnn_vpl VALUES ("JG3_10","008_3_10","JDG","3","10","10","Bala Garrayyu djuy'yurrunana‐wala nhanŋuwaynha ŋayi Garrkuḻuknhana Birrimbirrnha nhanukala Watnilwalanydja, ga ŋuriŋiyi ganydjarryu ŋanya wuṉḏaŋarrkuŋalana, märr ŋayi yurru walŋakumana nhanŋuwaynha ŋunhi miṯtjinha. Bala walala marrtjina ŋuriŋi Yitjuralpuyŋuyunydja ḏupthurrunana ŋunhi miriŋunhanydja buŋgawanha, ŋunhinhanydja ŋunhi ŋayi yukurrana ŋäthili walalanha mala‐ḏälkuŋala. ");
INSERT INTO gnn_vpl VALUES ("JG3_11","008_3_11","JDG","3","11","11","Bala walala yukurrana nhinana ŋamathaŋalana, marimiriwŋurana, ga yana liŋgu ga Watnil rakunydhina. Yo, nhinananydja walala yukurrana walaŋguŋalana dhika, marimiriwnha yanana weyinnha, 40‐na dhuŋgarranydja. ");
INSERT INTO gnn_vpl VALUES ("JG3_12","008_3_12","JDG","3","12","14","Ga ŋunhi ŋayi rakunydhinanydja Watnil, bala yana walalanydja ŋunhi Yitjuralpuyŋunydja dhunupa ŋanydjaḻa'yurrunana balayi yätjliliyi dhukarrlili. Ga ŋayi Garrayyunydja biyapul wekaŋala walalanha wiripuŋuwalana miriŋuwala, ŋurikala Mawappuyŋuwalana giŋgala; ŋayi ŋunhi giŋdja nyäṉ'thurruna lili beŋuru marililina, bala yana märraŋalana, ga djaw'yurrunana ŋunhiyi wäŋanydja ga yolŋu'‐yulŋunha ŋunhi, bala ŋayina buŋgawayina yukurrana walalaŋgu ŋurukuynha Mawappuynha wäŋawuy. Yo, ŋayina buŋgawayina ŋuriki Yitjuralpuyŋuwunydja 18 dhuŋgarranydja ŋupara, yurru bukmaktja galŋa‐yätjthinana yukurrana nhinana, warrpam'nha galŋa‐miḏikinana dhikana yätjthinana. ");
INSERT INTO gnn_vpl VALUES ("JG3_15","008_3_15","JDG","3","15","30","Ŋuliŋurunydja dhurrwaraŋuru walala liliyi roŋiyina Garraywalayi, ga waŋananydja walala yukurrana wäthurruna nhanŋu walŋakunharawuna walalaŋgu. Ga ŋayinydja Garrayyunydja ŋäkula walalanha, ga biyapul ŋayi wekaŋala walalaŋgu wiripuŋunhana ŋurruŋunha, märr ŋayina yurru walŋakuma walalanha. Ga ŋuriŋiyinydja ŋurruŋuyu ḏarramuyu yäkuyu Yewutthunydja bumara rakunyguna ŋunhi giŋnha Mawappuyŋunhanydja. Ga ŋuliŋuru dhurrwaraŋuru Yewutthu yurrum'maraŋalana waŋganylilina Yitjuralpuyŋunhanydja yolŋu'‐yulŋunha, bala waŋananydja ŋayi bitjarrana walalaŋgu, “Go malthurrana ŋarraku. Garrayyunydja liŋguna wekaŋala ŋilimurruŋgalana goŋlili Mawappuyŋunhanydja.” Bala walalanydja ŋunhi Yitjuralpuyŋunydja marrtjinana‐wala yana, bumarana marrtjina ŋunhi Mawappuyŋunhanydja yolŋu'‐yulŋunha, ga warrpam'nha ŋunhi ḏarramuwurrunydja burakina, yakana ŋula waŋgany walŋathina. Bala yana Yitjuralpuyŋunydja yukurrana nhinanana ŋamathaŋalana marimiriwnha; weyinŋumirrina walala yukurrana nhinana marimiriwnydja 80‐na dhuŋgarra ŋupara. Yo, nhinananydja walala yukurrana dhika walaŋguŋalana, yana liŋgu‐u‐u ga ŋurruŋu ŋunhi walalaŋgu rakunydhina Yewut yäku. ");
INSERT INTO gnn_vpl VALUES ("JG4_1","008_4_1","JDG","4","1","1","Ga ŋuliŋuru dhurrwaraŋuru ŋunhi ŋayi Yewut liŋgu rakunydhinana, ga yänayi walalanydja ŋunhi Yitjuralpuyŋunydja ŋanydjaḻa'yurruna balayi ŋunhimalayi, ga yätjthi walala yukurrana djäma rom, ŋunhiyi liŋgu ŋunhi yukurra ŋuli Godthu nhäma ga ŋaramurryirri. ");
INSERT INTO gnn_vpl VALUES ("JG4_2","008_4_2","JDG","4","2","2","Bala biyapul Garrayyu wekaŋala walalanha goŋlili miriŋuwala, yäkuwala Djapiṉgala, ŋurikala giŋgala ŋunhi Gaynanbuyŋuwalana, ŋurikalana giŋgala ŋunhi ŋayi yukurrana nhinana ŋunhala Yatju. ");
INSERT INTO gnn_vpl VALUES ("JG4_3","008_4_3","JDG","4","3","3","Yurru yätj ŋayi ŋunhi ḏarramunydja, yaka ŋamakurruny'tja, ga nhanŋu malanydja miriŋunydja dhaŋaŋnha dhika guḻku'na mirithirrina, ga ganydjarr‐ḏilkurrumirrina. Yo, walala ŋuriŋiyi miriŋuyu märraŋala ŋunhiyi wäŋa Yitjural, ga buŋgawayinanydja walala yukurrana ŋuriki Yitjuralpuyŋuwuna miṯtjiwu, yana liŋgu ga dhuŋgarranydja 20‐na. Yo, galŋa‐yätjthinana walala yukurrana nhinananydja, yakana galŋa‐ŋamathinanydja, bala walala birrka'yurrunana roŋiyinana Garraynhana, bala walala yukurrana gawaw'yurruna nhanŋu Garraywuna guŋga'yunarawu. ");
INSERT INTO gnn_vpl VALUES ("JG4_4","008_4_4","JDG","4","4","5","Ŋulinyaramirriyuyi waluyu dhäyka yukurrana nhinana ŋurruŋu ŋuriki Yitjuralpuyŋuwu miṯtjiwu, ga yäkunydja ŋayi ŋunhiyi dhäyka Dipura, yurru ḻiya‐djambatj balanyara miyalk; ŋayi ŋuli dhä‐wirrka'yuna mala‐yarr'yuna yukurranha yolŋu'‐yulŋunha, ga maḻŋ'maranha walalaŋgala nhä malanha, ŋunhi walala ŋuli mari‐wunanhaminyanydja, ga bitjannayi ŋayi ŋuli ḻakaranha walalaŋgu ŋamakurru' Garraywuŋunydja dhäwu'. ");
INSERT INTO gnn_vpl VALUES ("JG4_6","008_4_6","JDG","4","6","6","Ga waŋganymirri ŋayi Dipurayu dhäruknha djuy'yunmina ŋurikala Barakkala yäkuwala, ŋunhi ŋayi ŋurruŋu miriŋuwu walalaŋgu, ga waŋananydja ŋayi Dipura bitjarra, “Dhuwalanydja dhäruk beŋuru Garraywuŋu. Gatjuy marrtjiyana, ga märraŋa guḻku'nha yana miriŋunhanydja, ga nhuma yurru Daypulili bukulili wäŋalili. ");
INSERT INTO gnn_vpl VALUES ("JG4_7","008_4_7","JDG","4","7","7","Ŋayi yurru Godthunydja gäma marrtji ŋunhi miriŋunha Mawappuyŋunha ga walalaŋgu ŋurruŋunha buŋgawanha Djitjuranha yäkunha, gämanydja ŋayi yurru walalanha balayi ŋunhimalayina wäŋalili, bala walalanha ŋayi yurru wekama nhokalana goŋlili.” ");
INSERT INTO gnn_vpl VALUES ("JG4_8","008_4_8","JDG","4","8","8","Ŋayi Baraktja waŋana ŋurikala dhäykawala buŋgawawala bitjarra, “Ŋuli nhe yurru malthun warray ŋarraku, ga ŋarranydja yurru marrtji warray, ga ŋuli nhe yurru yakanydja ŋarraku malthun, ŋarranydja yurru yakayi marrtji.” ");
INSERT INTO gnn_vpl VALUES ("JG4_9","008_4_9","JDG","4","9","11","Ga ŋayinydja ŋunhi Dipuranydja waŋana bitjarra, “Manymak, ŋarra yurru malthun nhuŋu, ga ŋali rrambaŋina yurru marrtjinydja. Yurru ŋayi yurru Garrayyunydja ŋunhi miriŋunhanydja buŋgawanha gathan miyalkkalana goŋlilinydja, ga ŋayina yurru bumanydja ŋanya miyalkthuna ŋuriŋina.” Bala yana ŋunhi ŋurruŋunydja miyalk Dipuranydja marrtjina maṉḏa rrambaŋina Baraknha, ga bena dhika malanydja miriŋunydja malthurruna maṉḏaku bala bukulilinydja ŋunhi Daypulilinydja. ");
INSERT INTO gnn_vpl VALUES ("JG4_12","008_4_12","JDG","4","12","13","Ŋunhala ŋayi Djitjurayunydja ŋäkulana Baraknha ga nhanŋu miṯtjinha ŋunhi miriŋunha, ŋunhi walala yukurrana marrtjina bala bukulili, ga ŋayinydja ḻuŋ'maraŋala nhanŋuwaynydja ŋayi miṯtjinha ga girri' malanha mariwuynha, ga walalanydja marrtjinayi bala yana ŋunha bukulili, nyäṉ'thurruna Yitjuralpuyŋuwuna. Yo, maṉḏanydja ŋunhi märrmany'tja Dipuranydja ga Baraktja ŋunhalana dhärranana yukurrana bukuŋurana, galkurrunana maṉḏa yukurrana, dharr'‐way nhäŋalana Djitjurawuna miriŋunha miṯtjinha, walala marrtjina yukurrana lilina. ");
INSERT INTO gnn_vpl VALUES ("JG4_14","008_4_14","JDG","4","14","14","Ga ŋayi Dipuranydja waŋana Barakkala, “Gäthuranydja ŋayi Garrayyu wekaŋala Djitjuranha ga nhanŋu miṯtjinha ŋunhi miriŋunha nhokalana goŋlili. Garraynydja ŋunha marrtjinana ŋurru‐warryurrunana nhuŋu ŋurruŋunhana,” Bala yana ŋayi Barakthunydja garr'yurruna nhanŋuway ŋayi miṯtjinha ŋunhi miriŋunha, bala yana yarrupthurrunana, withiyarana‐wala yana Djitjuranhana. ");
INSERT INTO gnn_vpl VALUES ("JG4_15","008_4_15","JDG","4","15","15","Ŋunhi walala marrtjina galkithinana Djitjurawunydja miriŋu, ŋayi Garrayyunydja walalanha ŋula nhaltjarra yana, bala walala yana walalawuynha goḏuy‐wunhamina, bala bunharamina yukurrana ŋunhina miṯtji yana. Bala walala gundupuŋalana dhikana‐wala dhakaṉdhinana. Ga ŋayipinydja Djitjuranydja ŋunhi buŋgawanydja wapthurrunana ŋuliŋuru yarraman'ŋurunydja, bala yana waṉḏinana wiḏi'yurrunana ḻukuyuna, balayina roŋiyina. ");
INSERT INTO gnn_vpl VALUES ("JG4_16","008_4_16","JDG","4","16","16","Walalanydja Barakkalanydja miṯtjiyu bumara ŋunhi Djitjurawunydja malanha miriŋunha, warrpam'nha yanana dhika dhawar'maraŋalana, ga yakana ŋula walŋathinanydja, ŋayipina waŋganynha walalaŋgu ŋunhi buŋgawana waṉḏina walŋa‐yuḻkthurrunanydja. ");
INSERT INTO gnn_vpl VALUES ("JG4_17","008_4_17","JDG","4","17","17","Waṉḏinanydja ŋayi ŋunhi nhinana bala‐a‐a, ga bunananydja ŋayi waŋganyguna miyalkku yäkuwu Djayilwu, ŋunhi ŋayi yukurrana ḏalwaḏalwa'ŋura nhinana. ");
INSERT INTO gnn_vpl VALUES ("JG4_18","008_4_18","JDG","4","18","20","Ŋayi guyaŋinanydja Djitjurayu yanapi walala mala yolŋu'‐yulŋu, ga nhanukala gali'kurru, bala dhunupa ŋuriŋi miyalkthunydja garr'yurrunana ŋanya yana, bala waŋana bitjarrana, “Go gärriyana lili! Yaka beyaṉiyiya.” Bala ŋayi gulŋiyinana, ga wekaŋalanydja ŋayi ŋanya ŋarkula'na; wurkthurrunanydja ŋayi, bala marrtjina dhunupa yakurrthinana. ");
INSERT INTO gnn_vpl VALUES ("JG4_21","008_4_21","JDG","4","21","21","Gonha ŋayipi ŋorrana yukurrana yakurrnha, bala ŋayinydja marrtjina ŋuriŋi miyalkthunydja bumarana ŋanya rakunyguna; ŋayi märraŋala ḏalwaḏalwa'wuynha ŋunhi djalkirina, bala ḻäylilina nhanukala dhuḻ'yurruna, ga ŋunha gali'ŋura mar'‐wakthurrunanydja munatha'ŋurana. ");
INSERT INTO gnn_vpl VALUES ("JG4_22","008_4_22","JDG","4","22","22","Yo, Baraktja warrya'yurrunana yukurrana nhanŋu, birrka'mirrina dhika ḻarruŋala dharrana nhanŋu Djitjurawunydja. Bala ŋayi ŋuriŋi dhäykayunydja garr'yurrunana ŋanya waŋana bitjarrana, “Go marrtjiya lili, ŋarra nhuŋu yurru milkuma.” Bala ŋayi gäŋalanydja ŋanya ŋuriŋi miyalkthunydja bala ŋunhimala nhanukiyingalana ḏalwaḏalwa'lili, bala ŋayi nhäŋalana ŋunhiyi Djitjuranhanydja, ŋayi yukurrana ŋorrana rakunynha liŋguna, bunhara ŋurikiŋi miyalkkuŋuna. ");
INSERT INTO gnn_vpl VALUES ("JG4_23","008_4_23","JDG","4","23","24","Yo, Godthu guŋga'yurruna yukurrana ŋunhi Yitjuralpuyŋunha, ga wekaŋala ŋayi ganydjarr walalaŋgu, märr walala yurru buma dhawar'marama ŋunhiyi Gaynanbuyŋunhanydja ga bukmaknhana ŋunhi miriŋunha ga ŋunhinha yätjnha walalaŋgu giŋnha Djapiṉnha yäkunha. ");
INSERT INTO gnn_vpl VALUES ("JG5_1","008_5_1","JDG","5","1","1","Ga maṉḏanydja Dipuranydja ga Baraktja wirrkina dhika goŋmirriyina, bala maṉḏa yukurrana wokthurrunanydja Garraywuna, buku‐wekaŋalana yukurrana ŋanya, ga miyamara yukurrana maṉḏa manikaykurruna, balanyarana gam'. ");
INSERT INTO gnn_vpl VALUES ("JG5_2","008_5_2","JDG","5","2","2","“Wokthurrana walala Garraywuna. Ŋunhi ŋuli yolŋu'‐yulŋu wekanharamirri walalawuynha walala nhanukala, bala ŋayinydja ŋuli guŋga'yunna walalanha yana. ");
INSERT INTO gnn_vpl VALUES ("JG5_24","008_5_24","JDG","5","24","24","Ŋayi guŋga'yurruna ŋunhinha miyalknha Djayilnha; Dharpuŋala ŋayinydja ŋanya Djitjuranha, bala ŋayi rakunydhinana. ");
INSERT INTO gnn_vpl VALUES ("JG5_31","008_5_31","JDG","5","31","31","Garray, bukmaknha ŋunhi miriŋunha walalanha buŋana yana rewal'yurrana, yurru ŋunhinydja walala ŋunhi walala yukurra nhuŋu märr‐ŋamathirri, walalanydja yurru ḏälnha yukurra nhina; Walalanydja yukurra yurru baḏayala'na milkuma wiripu‐guḻku'wuna, bitjana dhuwala walu ya' walma marrtji ŋuli, räkukuma ŋuli yolŋu'‐yulŋunha.” Bala yukurrana Yitjuralpuyŋunydja nhinana miṯtji marimiriwnha märr‐weyinnha, 40 dhuŋgarranydja ŋupara, ga yana liŋgu ga Dipura rakunydhina. ");
INSERT INTO gnn_vpl VALUES ("JG6_1","008_6_1","JDG","6","1","1","Yo, walala yukurrana nhinana Godkalanydja romŋura, nhanŋuwaynha malthurruna dhärukku yukurrana 40 dhuŋgarra ŋupara, ga ŋuliŋurunydja dhuwarraŋuru bala walala balayina ŋanydjaḻa'yurruna, Godkalanydja gonha'yurrunayi; biyapul walala buku‐ŋal'yurruna yukurrana wiripuŋuwuna waŋarrwu walalaŋgu, ga djäma walala yukurrana yätjthi rom malanha, ga biyapul Garrayyu wekaŋala walalanha wiripuŋuwalana miriŋuwala goŋlili. Yo, 7 dhuŋgarranydja ŋupara walala yukurrana dhärrana goŋŋura ŋurikala Midiyangalanydja bäpurru'wala. ");
INSERT INTO gnn_vpl VALUES ("JG6_2","008_6_2","JDG","6","2","3","Ga bitjanana liŋguna walala ŋuli Midiyanbuyŋuyunydja yolŋu'‐yulŋuyu djaw'yuna walalambala ŋathana ga wäyinnhana, ga ŋula nhä malanha ŋunhi walala yukurranha nhä ŋayathanha ŋuli. Ga Yitjuralpuyŋunydja ŋunhi wirrkina beyaṉiyinanydja walalambala, bala walala ŋuli marrtjinyana dhawaṯthunana ŋuliŋuru, bala ŋunhana bala buku'‐wukukurruna marrtjinya nhinanha ŋuli mathirrakurruna. ");
INSERT INTO gnn_vpl VALUES ("JG6_4","008_6_4","JDG","6","4","5","Ŋuriŋi Yitjuralpuyŋuyunydja wirrkina yukurranha ŋuli djäma, yaw'yunarana munatha'na, ŋathana dholkunha, djäka dhika ŋamathanhana ŋuli, yana liŋgu ga balwurthinya ŋuli. Ga ŋunhi ŋayi ŋuli ŋalwuruŋ'thinya, bala walalanydja ŋuli marrtjinya ŋunhi Midiyanbuyŋunydja, bala yana mana'‐manaŋinyana ŋuli; walala ŋuli yukurranha manaŋinyanydja bukmaknha nhä malanha dhika, biyaku ŋuli ḏetjthu ḻuki ŋuli ŋula nhä, bukmaknha yanana dhawar'maranhana, liŋgu guḻku'na dhikana Midiyanbuyŋunydja ŋunhi miriŋu. ");
INSERT INTO gnn_vpl VALUES ("JG6_6","008_6_6","JDG","6","6","6","Bala walala Yitjuralpuyŋunydja marrya'thinyana ŋuli, ga ŋurruwuykmirrina walala ŋuli nhinanhanydja yukurranha wirrkina dhikana. Bala walala gawaw'yurruna nhanŋu Garraywuna guŋga'yunarawuna, märr ŋayinydja yurru guŋga'yun walalanha ŋulaŋuruyi Midiyanbuyŋuwala. ");
INSERT INTO gnn_vpl VALUES ("JG6_7","008_6_7","JDG","6","7","8","Garrayyunydja ŋäkula walalanha bukumirriyanharanydja ŋunhi Yitjuralpuyŋunhanydja, bala yana ŋayi djuy'yurruna dhäwu'‐gänharamirrinhana yolŋunha, ga ŋayinydja waŋana bitjarra, “Dhuwalanydja nhanŋuwaynha dhäruk Garraywuna. Ŋunhalanydja ŋunhi Yetjiptja nhuma yukurrana nhinana garrpiṉara djämamirri walala, bala ŋarranydja marrtjina dhawaṯmaraŋala warray nhumalanha ŋulaŋuru Yetjipŋuru; ŋarra nhumalanha dhawaṯmaraŋala walalaŋgala goŋŋuru, bala ŋarra gunganhamirriyaŋalana nhumalanha yanana yulŋunydja ŋulaŋuru ŋunhi wiripuŋuwalanydja miriŋuwala walalaŋgala. ");
INSERT INTO gnn_vpl VALUES ("JG6_9","008_6_9","JDG","6","9","9","Ga biyapul ŋarra ŋupara miriŋunhana nhumalaŋgala gukuŋala ŋupara dhipuŋuru wäŋaŋurunydja gay', bala wekaŋala nhumalaŋguna dhuwalanydja wäŋa. ");
INSERT INTO gnn_vpl VALUES ("JG6_10","008_6_10","JDG","6","10","10","Ga waŋananydja nhumalaŋgala ŋarra bitjarra, ‘Ŋarranydja dhuwalanydja nhumalaŋgu Waŋarr Garray. Yaka buku‐ŋal'yurra ŋuriki wiripuŋuwunydja waŋarrwu ŋunhi Gaynanbuyŋu yukurra buku‐ŋal'yun.’ Bitjarra ŋarra ŋunhi waŋananydja nhumalaŋgu, yurru nhumanydja bäyŋu ŋarranha ŋäkula.” Ga bitjarrayina ŋayi ŋunhi Garraywala djawarrkmirriyunydja yolŋuyu yukurrana ḻakaraŋala Yitjuralpuyŋuwanydja. ");
INSERT INTO gnn_vpl VALUES ("JG6_11","008_6_11","JDG","6","11","11","Ŋulinyaramirriyu waluyu ḏarramu yukurrana nhinana yäku Gitiyan, gäthu'mirriŋunydja ŋayi ŋunhi Djawatjku yäkuwu, ga nhinananydja ŋayi yukurrana wäŋaŋuranydja nhäyika Wupara yäkuŋura. Waŋganymirriyu waluyu ŋayi Gitiyandhunydja yukurrana djäma ŋunhala, ŋatha djuḏul'yurruna yukurrana ŋanydjapmaraŋala, yurru gayulnha ŋayi yukurrana djämanydja ŋunhiliyi djuḻuḻ'yurrunana, märr walala yurru yaka nhäma ŋanya ŋuriŋi Midiyanbuyŋuyu, bala mana'‐manaŋirri ŋunhiyi nhanŋu ŋathana. ");
INSERT INTO gnn_vpl VALUES ("JG6_12","008_6_12","JDG","6","12","12","Djämanydja ŋayi nhinana ŋunhiliyi, bala marrtjina Garraywu djiwarr'wuynha yolŋu bunana ŋunhiliyi, maḻŋ'thurruna ŋayi rumbalnydja bitjan yolŋu yana; ŋayi bunananydja, bala yana waŋana bitjarrana Gitiyangala, “Garraynydja dhiyalaŋumi nhokala. Nhenydja dhuwalanydja ḏarramu ganydjarr‐ḏumurruna.” ");
INSERT INTO gnn_vpl VALUES ("JG6_13","008_6_13","JDG","6","13","13","Ga ŋayinydja Gitiyandja waŋana buku‐ruŋiyinmaraŋala bitjarra, “Ŋunhi ŋayi be Garraynydja dhiyalaŋumi ŋanapurruŋgala, ga nhäku warray dhuwala marinydja yukurra ŋuli buna? Bäpa'mirriŋuyu walalay ŋanapurruŋgala yukurranha ŋuli ḻakaranha ŋunhi Garrayyu ŋäthili djäma ŋunhala Yetjipŋura yindi bathala; ŋayi walŋakuŋala ŋanapurrunha dhawaṯmaraŋala ŋulaŋuru miriŋuwala goŋŋuru, bala yana gäŋalana lili dhipalana wäŋalili. Yurru wanhakana dhika Garraynydja? Marrtjinana ŋayi dhikana‐wala winya'yurrunana? . . . gonha'yurrunana ŋanapurrunha gupaḏalnha? Dhuwalana gay' ŋanapurrunydja, goŋŋura nhina yukurra dhiyakalana Midiyanbuyŋuwalana.” ");
INSERT INTO gnn_vpl VALUES ("JG6_14","008_6_14","JDG","6","14","14","Bala ŋayi Garraynydja waŋanana Gitiyannha bitjarrana, “Gatjuy nhe marrtjiyana. Nhena yurru walŋakuma ŋunha Yitjuralpuyŋunhanydja, dhawaṯmaramana yurru walalanha ŋurukala Midiyanbuyŋuwalanydja. Dhuwalana ŋarra yukurra nhuŋu djämanydja wekamana, djuy'yunna nhuna.” ");
INSERT INTO gnn_vpl VALUES ("JG6_15","008_6_15","JDG","6","15","15","Ga ŋayi Gitiyandja waŋana bitjarra, “Garray, nhaltjanna dhika ŋarranydja yurru walŋakuma Yitjuralpuyŋunhanydja? Ŋunha ŋarrakunydja mala yaka warray ganydjarr‐ḏilkurru yolŋu'‐yulŋu, ganydjarrmiriwnha walala, ga ŋarranydja dhuwalanydja ŋula nhäna, gali'wuynha, balanyarana bitjan yothu'na. Ŋarranydja dhuwala yaka ganydjarr‐ḏumurru, yolŋu ga ŋurruŋu ŋarra yaka.” ");
INSERT INTO gnn_vpl VALUES ("JG6_16","008_6_16","JDG","6","16","16","Ga Garraynydja waŋana nhanukala, “Ŋarra yurru nhokala galki. Buŋana yana nhe yurru ŋunhi Midiyanbuynhanydja, dhawar'yunmaraŋana.” ");
INSERT INTO gnn_vpl VALUES ("JG6_17","008_6_17","JDG","6","17","17","Ga ŋayi Gitiyandja waŋana bitjarra, “Ŋuli nhe yuwalktja wal'ŋu Garray, ga milkuŋa ŋarraku, märr ŋarra yurru yuwalk gal'ŋu märr‐yuwalkthirri, ga marŋgithirri wal'ŋu nhuŋu. ");
INSERT INTO gnn_vpl VALUES ("JG6_18","008_6_18","JDG","6","18","18","Nhenydja galkurra dhiyala! Ŋarra bala marrtji yurru, ga ŋatha nhuŋu märrama.” “Ŋe, manymak,” bitjarra ŋayi Garraynydja, “Ŋarra yurru galkun dhiyala.” ");
INSERT INTO gnn_vpl VALUES ("JG6_19","008_6_19","JDG","6","19","19","Bala ŋayi marrtjinana Gitiyandja. Marrtjina ŋayi, ga ŋunhala märraŋala weyika' ga wäyin ŋanak ga ŋatha dämba, bala ŋayi lilina gäŋala. Gäŋalanydja ŋayi lili, bala wekaŋala Garraywuna ŋunhala dhuḏiŋura dharpaŋura. ");
INSERT INTO gnn_vpl VALUES ("JG6_20","008_6_20","JDG","6","20","20","Ga ŋayi Garraynydja waŋana nhanukala bitjarra, “Ŋunhamala gurrunharra ya', guṉḏalili ŋal'maraŋa dhuwali ŋatha dämba ga wäyin, ga dhuwali weyikany'tja wäyin guryunmaraŋa ŋapalilina ŋunhi wiripuŋulilinydja ŋathalili.” Bala ŋayi yuwalkthi Gitiyandhunydja bitjarra yana liŋgu dhärukku malthurruna. ");
INSERT INTO gnn_vpl VALUES ("JG6_21","008_6_21","JDG","6","21","21","Bala yana ŋayi Garrayyunydja mulkana dharpayuna, dharpa ŋunhi wapitja ŋal'yunmaraŋala ŋunhimalayi ŋathalili, bala ŋayi marrtjina dhunupa ŋunhi ŋäṉarrnydja gurthanydja dhawaṯthurruna warray ŋuliŋuru guṉḏaŋurunydja, bala nhäranana ŋunhi ŋathanydja ga wäyindja. Bala ŋunhi djiwarr'wuynydja yolŋu winya'yurrunana bena‐wala. ");
INSERT INTO gnn_vpl VALUES ("JG6_22","008_6_22","JDG","6","22","22","Bala ŋayi marrtjina Gitiyandhunydja wirrkina wal'ŋu dharaŋara, ŋunhi yuwalknha ŋunhinydja Garraynha ŋayipina; ŋayi waŋanana ŋunhi Gitiyandja bitjarrana, “Ŋunhanydja dhuwala Garray muka yuwalk. Liŋguna ŋarra nhäŋalana Garraynha bukuna wal'ŋu.” ");
INSERT INTO gnn_vpl VALUES ("JG6_23","008_6_23","JDG","6","23","23","Ga ŋayi Garrayyunydja waŋana ŋanya bitjarra, “Yaka beyaṉiyiya. Nhiniya yukirriya ŋoy‐yal'yurra. Nhina nhe yurru walŋa yukurra, yakana rakunydhirri.” ");
INSERT INTO gnn_vpl VALUES ("JG6_24","008_6_24","JDG","6","24","24","Bala yana ŋayi Gitiyandhu guṉḏana ŋal'‐ŋalmaraŋala ŋunhimalayi Garraywuna, bala ŋayi buku‐ŋal'yurruna yukurrana Garraywuna. Ga yäkunydja ŋayi ŋunhiyi nherrara wäŋanydja “Garraynydja dhuwala ŋoy‐yal'maranharamirri.” Ga ŋunhiyi guṉḏanydja yukurra dhärra yana ŋunha mukthun, ŋunhalaŋumi liŋgu wäŋaŋura. ");
INSERT INTO gnn_vpl VALUES ("JG6_25","008_6_25","JDG","6","25","25","Ga ŋulinyaramirriyu liŋgu munhaku Garray waŋana nhanukala Gitiyangala, bitjarra ŋayi waŋananydja, “Gatjuy marrtjiyana‐wala, ga ḏaw'‐ḏawyurrana ŋunhiyi guṉḏanydja malanha ŋunhi nhokala bäpa'mirriŋuyu ŋal'‐ŋalmaraŋala buku‐ŋal'yunarawu Bälwu, ga gulk‐gulkthurrana dharpanydja ŋunhiyi, ŋunhi walala ŋuli yukurra buku‐ŋal'yun ŋuriki miyalkku waŋarrwu Yatjarawu yäkuwu. ");
INSERT INTO gnn_vpl VALUES ("JG6_26","008_6_26","JDG","6","26","26","Bak‐bakmaraŋana warrpam'thurrana yanana bukmakkuŋana, ga ŋunhimalayi dharapullilinydja dhuḻ'yurra ŋal'‐ŋalmaraŋa guṉḏanha yuwalkŋuwuna waŋarrwu. Märraŋa bäpa‐ŋaliwa wäyin buliki', ga batharra ŋunhiliyi, buku‐ŋal'yurra ŋarrakuna.” ");
INSERT INTO gnn_vpl VALUES ("JG6_27","008_6_27","JDG","6","27","27","Yuwalkthi ŋayi Gitiyandja gaŋgathinana, märraŋala märrma' rulu nhanŋuway djämamirrinha walalanha, bala walala dhäruktja märraŋala ŋanyapinyay yana Garraynha. Ḏaw'‐ḏawyurrunana walala yanana ŋunhiyi waŋarrnhanydja malanha wiripu‐guḻku'nhanydja, ga buku‐ŋal'yurruna walala yukurrana ŋunhiliyinydjayi wäŋaŋura Godkuna. Yurru walala ŋunhi ḏaw'‐ḏawyurrunanydja munhakuna dhika; yaka ŋayi ḏaw'‐ḏawyurruna walupuynydja, liŋgu ŋayi beyaṉiyina nhanukalaŋuwu gurruṯu'mirriwu walalaŋgu ŋuriki, ga wiripu‐guḻku'wu ŋuriki yolŋu'‐yulŋuwu miṯtjiwu. ");
INSERT INTO gnn_vpl VALUES ("JG6_28","008_6_28","JDG","6","28","28","Munhakumirrina wiripuŋuyuna waluyu, walala yolŋu'‐yulŋunydja ḏurryurruna yakurrŋurunydja, nhäŋala ḏaw'‐ḏawnha ŋunhiyi Bälwunydja guṉḏanydja malanha, dhakaṉnha dhika ḏaw'‐ḏawyunarana, ga dharpa ŋunhi wiripu waŋarrwu dhäykawu ŋuriki Yatjarawu ḏaw'‐ḏawyunarana, djatthunarana, bala bathanarana. ");
INSERT INTO gnn_vpl VALUES ("JG6_29","008_6_29","JDG","6","29","29","Bala walala waŋanhaminana bitjanminana, “Yolthu dhuwalanydja bitjana yawungu?” Bala walala ŋäkulanydja maḻŋ'maraŋalanydja ŋanya warray Gitiyannha warray, ŋunhi Gitiyandhu warray gäthu'mirriŋuyu Djawatjkala warray, ŋayi warray ḏaw'‐ḏawyurruna ŋunhiyinydja. ");
INSERT INTO gnn_vpl VALUES ("JG6_30","008_6_30","JDG","6","30","30","Ga walala yolŋu'‐yulŋunydja waŋana Djawatjnha bitjarra, “Go, gäŋana lili be nhuŋuway gäthu'mirriŋunhanydja, ŋanapurru bumana ŋanya rakunyguna, liŋgu ŋayi yawungu ḏaw'‐ḏawyuna ŋanapurruŋgu waŋarrnha Bälnha, ga ḏaw'‐way djatthuna gulk‐gulkthuna ŋayi yawungu dharpa maḏayin'.” ");
INSERT INTO gnn_vpl VALUES ("JG6_31","008_6_31","JDG","6","31","31","Ga ŋayinydja waŋana Djawatjtja bitjarra warray walalaŋgala buku‐ruŋiyinmaraŋala, “Nhäku warray ŋilimurru yukurra dhuwala yolŋu'‐yulŋuyunydja gungama ŋapatjkuma waŋarrnha ŋilimurruŋguwaynydja? Ŋunhi ŋayi ŋuli Bäl yuwalktja wal'ŋu waŋarr, ŋayinydja yurru ŋanyapinyay ŋayi walŋakunharamirri. Ŋunhi ŋuli yolŋuyu ŋula yolthu ḏaw'‐ḏawyurru nhanbala Bälwa ŋunhi guṉḏa malanha, ga ŋayinydja ŋuli ŋayipi Bälyu dhä‐ḏir'yurru ŋunhiyi yolŋunha.” ");
INSERT INTO gnn_vpl VALUES ("JG6_32","008_6_32","JDG","6","32","32","Bala walala marrtjina gonha'yurrunana ŋanya Gitiyannhanydja, yakana walala ŋanya murrkayny'tja bumara. ");
INSERT INTO gnn_vpl VALUES ("JG6_33","008_6_33","JDG","6","33","33","Ŋuliŋurunydja dhäŋuru guḻku'na miriŋu bunana Midiyanbuyŋunydja; walala nyäṉ'thurruna bunharawu Yitjuralpuyŋuwuna. Walala buḏapthurruna ŋuriki mayaŋ'ku, ga wäŋaraŋalanydja walala ŋunhili wayalaŋura, Djitjaril yäkuŋura wäŋaŋura. ");
INSERT INTO gnn_vpl VALUES ("JG6_34","008_6_34","JDG","6","34","35","Bala yana Godthu wekaŋalana nhanŋuway birrimbirrnha garrkuḻuknhanydja Gitiyangalana; ŋunhiyi ŋayi birrimbirr bunana Gitiyangu, bala ŋanya guŋga'yurrunana. Bala ŋayi Gitiyan yukurrana ḻoḻthurrunana yiḏakiyinyarayuna, ḻuŋ'maraŋalana yukurrana nhanbalay ŋayi ŋunhi miṯtjinhana Manatjanhana bäpurru'nha, wäthurrunana walalaŋgu yukurrana. Ga bitjarrayi ŋayi djuy'yurruna dhäwu'mirrinha walalanha ḻuŋ'maranharawu ŋuriki wiripuŋuwunydja bäpurru'wu Yatjawu ga Djapalangu ga Napaliwu, dhiyaku walalaŋgu malawu yolŋu'‐yulŋuwu. Bala walala marrtjinana lili, bala yana manapanminana. Yo, Gitiyanguna malthurrunanydja marrtjina bena dhika dhaŋaŋnha miriŋunydja, guḻku'na mirithirrina dhika; walala yurru marrtji, bala walalana yurru buma gukuma ŋunhi Midiyanbuyŋunhanydja yolŋu'‐yulŋunha. ");
INSERT INTO gnn_vpl VALUES ("JG6_36","008_6_36","JDG","6","36","37","Yurru Gitiyandja waŋana Godkala Waŋarrwala bitjarra, “Ŋarranydja ḏukṯuk ŋarra yurru wirrki wal'ŋu marŋgithirri, ŋunhi nhenydja dhiyalaŋumi ŋanapurruŋgala. Dhuwala ŋarra yurru barrwaṉ' wäyinnha gurrunhandja dhipala munatha'lili miṉdhalarama. Gäthuranydja munhaku ŋarra nhuŋu ḏukṯuk, nhe yurru djuy'yurra wakuluŋgul', ga dhuwala yana waŋgany yurru wäyin barrwaṉ' yulukthirrinydja, ga bukmaktja munathany'tja yurru baṉḏany yukurra dhärra. Bitjanarayunydja ŋarra yurru wirrkina wal'ŋu marŋgithirri, ŋunhi nhe yurru yuwalkkuma wal'ŋu guŋga'yun Yitjuralpuyŋunha, ga wekama yurru ŋunha miriŋunhanydja ŋanapurruŋgalana goŋlili.” ");
INSERT INTO gnn_vpl VALUES ("JG6_38","008_6_38","JDG","6","38","38","Ŋulinyaramirriyu munhaku walala ŋorrana, ga djaḏaw'yurrunanydja, bala yuwalkthi maḻŋ'maraŋalanydja ŋunhi waŋgany ŋunhiyina barrwaṉ'nha wäyinnha yulukthinanydja, ga munathany'tja bukmaknha baṉḏanynha. ");
INSERT INTO gnn_vpl VALUES ("JG6_39","008_6_39","JDG","6","39","39","Ga Gitiyandhunydja waŋana Garraynha bitjarra, “Garray, yaka ŋarraku maḏakarritjthiyanydja, ŋarra nhuna waŋganynha yurru biyapul dhä‐wirrka'yun waŋa. Gäthuranydja munhaku ŋarra yurru gurrunhan dhuwala bulka' wäyinnha biyapul, yurru nhenydja djuy'yurra yurru wakuluŋgulny'tja, ga yulukthirrinydja yurru dhuwalana warrpam'nha munatha'na, ga dhuwalanydja yurru bulkany'tja wäyindja baṉḏany yukurra ŋorra.” Ga bitjarranydja yukurrana Gitiyandhu waŋana gatjarr'yurruna Godnha. ");
INSERT INTO gnn_vpl VALUES ("JG6_40","008_6_40","JDG","6","40","40","Ga yuwalknha bitjarranydja; munhakumirrinydja ŋunhiyi bulkany'tja wäyindja baṉḏanynha yukurrana ŋorrana yana, ga munatha'nha warrpam' yulukthinanydja ŋuriŋi wakuluŋgul'yunydja yurr'yurruna. ");
INSERT INTO gnn_vpl VALUES ("JG7_1","008_7_1","JDG","7","1","1","Yo, Gitiyandja ga nhanŋu miriŋunydja ŋorra'‐ŋurrana yukurrana ŋunhala galki mayaŋ'ŋura, galki walala yurru bunharamirrina ŋunhi Midiyanbuyŋuna miriŋu, ŋunhina walala ŋunhi walala yukurra nhina ŋunhili balkuwarra'ŋura galki bukuŋura Moray yäkuŋura. ");
INSERT INTO gnn_vpl VALUES ("JG7_2","008_7_2","JDG","7","2","3","Ga Garraynydja waŋana nhanukala Gitiyangala bitjarra, “Malanydja dhuwala nhuŋu guḻku' mirithirri. Ŋunhi ŋarra yurru Midiyanbuyŋunhanydja ŋunhanydja yolŋu'‐yulŋunha wekama nhumalaŋgalanydja goŋlili dhawar'maranharawuna bunharawu, ga dhiyaŋu ḏarramuwurruyunydja yurru waŋa bitjanna, ‘Dhuwalanydja ŋanapurruway yana dhawar'maraŋala, ŋanapurruŋgalay ganydjarryu,’ bitjanna yurru. Ḻakaraŋa nhe yurru walalaŋgu biyaka, ‘Ŋunhi nhe yukurra ŋula yol beyaṉiyirri, ga marrmarryun yukurra beyaṉiyinyarayu, gatjuy nhe yurru marrtji balayi roŋiyirri wäŋalilina.’” Ga guḻku'na yolŋu'‐yulŋu roŋi'‐ruŋiyinanydja, 22,000‐nha malanydja ŋunhi, gonha'yurrunana walala Gitiyannhanydja, bala marrtjina wäŋalilina. Yurru märr‐ḻurrkun'nha yukurrana nhinana ŋunhilinydja bäymanydja, 10,000‐nha mala. ");
INSERT INTO gnn_vpl VALUES ("JG7_4","008_7_4","JDG","7","4","4","Ga biyapul ŋayi Garray waŋana Gitiyangala, “Mukthun yana dhuwala guḻku' malanydja nhe yukurra ḏälkuma. Gatjuy, nhe yurru gäŋa walalanha bala ŋunhamala gapulili mayaŋ'lili, ga ŋunhala ŋarra yurru walalanha mala‐yarr'yundja yukurra, barrkuwatjkumanydja.” ");
INSERT INTO gnn_vpl VALUES ("JG7_5","008_7_5","JDG","7","5","6","Bala yuwalkthi Gitiyandhunydja gäŋalana walalanha bala ŋunhimala mayaŋ'lilina gapuwuna wurkthu'‐wurkthunarawu. Wiripu‐guḻkuny'tja ḏarramuwurru ŋunhi baḻa‐waḻapthurruna munatha'lilina, bala yukurrana nyamaḻŋ'‐dharranana ḻukananydja ŋäṉarryunna gapunydja, ga wiripu‐guḻku'yunydja yukurrana ḻukana gurrum' yana; walala yukurrana goŋdhu dhiṯ‐dhiṯthurruna gapu, bala bulnha yana ḻukana yukurrana gurrum'thurruna. ");
INSERT INTO gnn_vpl VALUES ("JG7_7","008_7_7","JDG","7","7","8","Ga Garraynydja waŋana nhanukala bitjarra, “Ma', nhe gurrunharrana dhuwalanydja wiripu‐guḻku'nhanydja ŋunhi walala yukurra ḻuka gurrum'thun, dhipala bala wiripulili gali'lili, ga dhuwalanydja walalanha wiripu‐guḻku'nhanydja ga dhipala wiripulilina gali'lili.” Bala ŋayi yuwalkthi Gitiyandhunydja gulk‐gulkthurruna, barrkuwatjkuŋala ŋunhiyi miriŋunhanydja walalanha märrma'kuŋalana miṯtji, ga miṯtjinydja ŋunhi ḻurrkun'nha yana, 300‐nha ŋunhinydja walala ŋunhi walala yukurrana gurrum'thurruna gapu ḻukana. Ga Godtja waŋana bitjarra, “Dhuwalanhana ḻurrkun'nhana miṯtjinha ŋarra yurru walŋakumanydja Yitjuralnha. Ga wiripu‐guḻku'nhanydja dhuwala djuy'yurrana walalanha wäŋalilina.” Bala yana yuwalknha walalanydja marrtjinana ŋunhiyi wäŋalilina, ga ŋunhina liŋgu märr‐ḻurrkun'nha nhinananydja miṯtjinydja. Yurru Midiyanbuynydja walalanydja nhinana yukurrana märr‐galki wäŋaŋura, ŋunha galki buku'‐wukuŋura ŋoyŋura, yurru malanydja ŋunhi miriŋunydja dhaŋaŋnha biyapulnha wal'ŋu dhika. ");
INSERT INTO gnn_vpl VALUES ("JG7_9","008_7_9","JDG","7","9","9","Ŋulinyaramirriyu munhakuna Garrayyu waŋana Gitiyannha bitjarra, “Gaŋgathiyana, bala yana marrtjiyana. Marrtjiyana ŋunhana‐wala ya' yarrupthurrana ŋunhimalana wäŋalili walalaŋgalana, liŋgu ŋarranydja yurru wekama nhokalana goŋlili ŋunhayi miriŋunhanydja. ");
INSERT INTO gnn_vpl VALUES ("JG7_10","008_7_10","JDG","7","10","12","Ŋuli nhe yukurra beyaṉiyirrinydja, ga nhenydja yurru marrtjiya nhepi gayul, ga buthuru‐witjurra marrtjiya; nhe yurru ŋämana nhaltjan walala yukurra yurru waŋanharamirri, ga ŋuriŋiyi dhärukthu nhe yurru ganydjarrmirriyirrina, bala nhe yurru yakana beyaṉiyirri biyapulnydja.” Bala Gitiyandhu garr'yurruna nhanŋuway ḏarramunha, bala maṉḏa marrtjinana, yuḻwutjtjurrunana maṉḏa marrtjina bala ga‐ga‐ga‐ga‐ga‐a‐a, ga galkithina ŋunhi wäŋa. Bala maṉḏa biyapul gaḻ'yurruna marrtjina bala yuḻwutjtjurruna, ga ŋunhilina waŋganyŋurana ḏalwaḏalwa'ŋura maṉḏa yukurrana baḻapthurrunanydja, ŋäkulana maṉḏa yukurrana. ");
INSERT INTO gnn_vpl VALUES ("JG7_13","008_7_13","JDG","7","13","13","Bala maṉḏa ŋäkulana dhäruknha, ŋayi waŋganydja ḏarramu waŋana nhanukalaŋuwala ḻundu'mirriŋuwala bitjarra, “Way, bukaway'yina ŋarra dhuwala. Nhäŋala ŋarra bukaway'kurru, ŋayi nhinana lili djarrarrayurruna ŋatha dämba ŋomaṉara, bala nhinana lili djarrarrayurrunana ga‐ga‐ga‐ga‐ga‐a‐a, ga wutthurruna dhuwala ya', dhä‐muŋdhurruna ḏalwaḏalwa'na yana.” ");
INSERT INTO gnn_vpl VALUES ("JG7_14","008_7_14","JDG","7","14","14","Bala ŋayi ŋunhi ḻundu'mirriŋunydja wirrkina ṉirryurruna, bitjarrana waŋana, “Wä‐ä‐äy! Dhuwalanydja dhuwala mayali' Gitiyannhana yukurra ḻakarama, ŋayi yurru marrtjina dhika lili, ga bumana ŋilimurrunha. Godthu yurru wekama nhanukalana goŋlili ŋilimurrunhanydja Midiyanbuyŋunhanydja.” ");
INSERT INTO gnn_vpl VALUES ("JG7_15","008_7_15","JDG","7","15","15","Yo, Gitiyandhunydja ŋäkulana yukurrana ŋunhala warraŋulnha, yurru ŋayi wirrkina dhika goŋmirriyinanydja, buku‐ŋal'yurrunana Godkuna. Bala yana ŋayi marrtjina wäŋalilina roŋiyina walala‐miṯtjiwalanydja, nhanukalaŋuwalanydja miriŋuwala, bala marrtjinana waŋanana walalanha, “Way walala! Gaŋga'‐gaŋgathiyana ma'! Liŋguna ŋayi Godthunydja wekaŋalana ŋunhiyinydja miriŋunha ŋilimurruŋgalana goŋlili.” ");
INSERT INTO gnn_vpl VALUES ("JG7_16","008_7_16","JDG","7","16","16","Ga bukmak ŋunhi miriŋunydja ḏurryurrunana, ga ŋayi Gitiyandhu weka'‐wikaŋalanydja walalaŋgala goŋlilinydja gurtha‐ŋäṉarrmirri djarraṯawun', yurru ŋäkirrmaranharanydja rupa'mirri, ga yiḏakinyara barrkuwatj yana walalaŋgala rarr'yurrunanydja ŋayi Gitiyandhu. Ga gulk‐gulkthurrunanydja walalanha marrtjina ḻurrkun'lili ŋurruklilinydja, yurru yakana walala gäŋala ŋula gara, yiki ŋula nhä goŋdhu; ŋunhina liŋgu yana djarraṯawun'nha ga yiḏakiyinyarana. ");
INSERT INTO gnn_vpl VALUES ("JG7_17","008_7_17","JDG","7","17","17","Yo, munhakuŋga yana ŋunhi baḏak yulŋunydja, warumukka yana dhika, ŋayi Gitiyandja waŋana ŋurikala miriŋuwalanydja, “Go go, malthurrana walala ŋarraku. Ŋilimurru yurru marrtjina ga ḻiw'maramana walalaŋgu ŋunhiyi wäŋanydja gayul yana. Nhäŋanydja walala ŋarranha, ga ŋunhi ŋarra yurru nhaltjan djäma, nhumanydja yurru biyakayi bili yana. ");
INSERT INTO gnn_vpl VALUES ("JG7_18","008_7_18","JDG","7","18","18","Ŋunhi yurru ŋarra ḻoḻthun, ga nhumanydja yurru ḻoḻthundhi, ga ŋunhi ŋarra yurru yatjun, ga nhumanydja yurru biyaka yana liŋgu yatjurra mirithiya; ḏaw'yurrana ŋunhi banikin'tja, bala garrwarkuŋana ŋunhi baḏayalany'tja, ga mirithiyana yatjunmiyanydja, waŋiya biyakana. ‘Dhuwalanydja yiki Garraywuna ga Gitiyanguna.’” Bitjarra ŋayi Gitiyandhu ḻakaraŋalanydja yukurrana walalambala. ");
INSERT INTO gnn_vpl VALUES ("JG7_19","008_7_19","JDG","7","19","19","Bala yana Gitiyan ga nhanŋu miriŋunydja marrtjinana bala ḻiw'yunmaraŋalana, ḏap‐gay ŋunhi wäŋanydja; walala marrtjina djingaryurrunanydja dhäruk mukthurrunana dhika, rirrakay mukthurrunana djingaryurruna yukurrana yana. ");
INSERT INTO gnn_vpl VALUES ("JG7_20","008_7_20","JDG","7","20","20","Ga Gitiyandja ḻoḻthurrunana nhanukalay ŋayi yiḏakiyuna ŋuriŋi, ga bukmakthunydja bitjarra yana liŋgu, bo‐o‐op bitjanmina dhika. Bala walala marrtjina bukmakthuna buḏaw'maraŋalanydja rrambaŋina, ga ŋunhi banikin'tja djalkthurrunana, buḏaw' bitjarrana, bala yana garrwarkuŋalana ŋunhi baḏayalany'tja. Ga baḏayalany'tja ŋunhi bena dhika räkukuŋalanydja bukmaknha ŋunhi wäŋanydja ḻiw'maraŋala. Ga bukmaknha waŋana yatjunmina yiŋgathinana dhika, “Dhuwalanydja yiki nhanŋuwaynha Garraywuna ga Gitiyanguna.” ");
INSERT INTO gnn_vpl VALUES ("JG7_21","008_7_21","JDG","7","21","22","Walalanydja Midiyanbuynydja gaŋga'‐gaŋgathinana dhika, ga wiṯthurrunana dhika beyaṉiyinyaminanydja, yatjunminana dhika wäthunminana; walala birrka'yurruna yana bini Yitjuralpuyŋuna ŋunhi wapthurru walalaŋgala wäŋalili. Bala walalawuynha ŋunhili bunharaminanydja buku‐munha'ŋurana, rakunygunhaminana yukurrana walalawuynha, bala‐lili'yunminana bunharamina, liŋgu Garrayyuna walalaŋgu guyaŋinyaranydja dhulmu‐waŋala bitjarrayinydja. Walala Yitjuralpuyŋunydja mukthurruna yana dhärrana marrtjina ŋulawitjarra wäŋakurru ḻiw'maraŋala walalaŋgala, yurru wiripu‐guḻkuny'tja Midiyanbuyŋu burakinana yukurrana rakunyguna walala‐miṯtjiwuŋuna ŋurikiŋi yana bäyma, ga wiripu‐guḻkuny'tja gundupuŋala winya'‐winyayurrunana. ");
INSERT INTO gnn_vpl VALUES ("JG7_23","008_7_23","JDG","7","23","25","Ga Gitiyandhunydja ga nhanukala miriŋuyunydja ŋuparayi walalanha, bala bumarana Midiyanbuyŋunhanydja ga walalaŋgu ŋurru'‐ŋurruŋunha ŋunhi, bala warr'‐warryurrunana yanana walalanha bena‐wala barrkulilina ŋuliŋuru wäŋaŋurunydja. Ga ŋuliŋurunydja dhurrwaraŋuru yakana walala biyapulnydja Midiyanbuyŋunydja roŋi'‐ruŋiyina lilinydja, ga yakana walala biyapulnydja mari‐wunana ŋuriki Yitjuralpuyŋuwunydja. Bala walala Yitjuralpuyŋunydja nhinanana yukurrana marimiriwŋurana. ");
INSERT INTO gnn_vpl VALUES ("JG8_22","008_8_22","JDG","8","22","22","Bala walala Yitjuralpuyŋunydja waŋana Gitiyangala bitjarra, “Ŋanapurrunydja ḏukṯuk nhe yurru ŋanapurruŋgu ŋurruŋu yukurra dhärra, bitjan nhenydja yurru ŋanapurruŋgu buŋgawana wal'ŋu giŋnha, liŋgu nhe walŋakuŋala ŋanapurrunha ŋurukala Midiyanbuyŋuwalanydja goŋŋuru. Ga ŋunhi yurru nhe bäyŋuthirri, rakunydhirri nhe yurru, ga nhuŋu yumurrku'na yurru nhokala dharapulŋuranydja djingaryun yukurra, ŋanapurruŋgu ŋurruŋuyirri yurru.” ");
INSERT INTO gnn_vpl VALUES ("JG8_23","008_8_23","JDG","8","23","23","Ga ŋayi Gitiyandja waŋana bitjarra, “Ŋarranydja yurru yaka buŋgawa nhumalaŋgu, ga ŋarraku gäthu'mirriŋu yaka nhumalaŋgu yurru buŋgawayirri; Garray dhuwala ŋayipi yurru nhumalaŋgu buŋgawanydja, ŋayipina waŋganynha.” ");
INSERT INTO gnn_vpl VALUES ("JG8_24","008_8_24","JDG","8","24","24","Ga biyapul ŋayi Gitiyan waŋana, “Bukmakthu nhuma dhiyaŋu walalay gäŋa lili ŋarrakala ŋula nhä mel‐winya'mirrinydja girri', ŋunhi nhuma Midiyanbuyŋuwala djaw'‐djawyurruna.” ");
INSERT INTO gnn_vpl VALUES ("JG8_25","008_8_25","JDG","8","25","26","“Ŋanapurru yurru wekamana‐wala yana nhokala,” bitjarra walala ŋunhi yolŋu'‐yulŋunydja miṯtjinydja waŋana. Bala walala bukmaknha yurrum'thurrunanydja marrtjina, gäŋalana lili Gitiyangalana ŋunhi girri'na malanha, maŋutji‐winya'mirrinydja girri'. ");
INSERT INTO gnn_vpl VALUES ("JG8_27","008_8_27","JDG","8","27","27","Ga ŋuriŋiyi girri'yu ŋayi mel‐manaparana batharana, nyarra'yunmaraŋalana, bala djäma ŋula nhäna ŋuriŋi garwarrwarr'mirriyunydja girri'yu, märr yurru ŋayi dhaṯthunmirrina yukurra yurru ŋuriŋi dhapirrkmirriyuna dhikana wal'ŋu girri'yu. Yurru bukmaktja ŋunhi yolŋu'‐yulŋu Yitjuralpuyŋu marrtjina ŋunhimalana waŋganylilina, bala walalanydja buku‐ŋal'yurrunana yukurrana ŋurikinayi girri'wu, bitjarrana walala yukurrana ŋurru‐nherrarana ŋäthilina walalaŋgu Gitiyangu ga nhanukalaŋuwu yumurrku'wu. Yo, malthurrunanydja walala yukurrana märr‐ŋal'yurrunana nhanŋuwaynha Gitiyanguna, ga bitjarrayina walala ŋapayuna‐ŋurrkaŋala, gonha'yurrunana Godnhanydja ŋunhi ŋayina walalaŋgu yuwalkŋunydja ŋurruŋu. ");
INSERT INTO gnn_vpl VALUES ("JG8_28","008_8_28","JDG","8","28","32","Ga ḻatju' yukurrana wäŋa djingaryurruna ŋulinyaramirriyunydja, marimiriw nhämiriw, yana liŋgu‐u‐u 40 dhuŋgarranydja ŋupara, ga yana liŋgu ga Gitiyan rakunydhina. ");
INSERT INTO gnn_vpl VALUES ("JG8_33","008_8_33","JDG","8","33","34","Ga dhäŋuru ŋuliŋurunydja ŋunhi ŋayi rakunydhinana liŋguna Gitiyan, ga walala ŋunhi yolŋu'‐yulŋunydja biyapul ŋanydjaḻa'yurruna Godkalanydja, ga balayi buku‐ŋal'yurruna ŋuriki liŋgu Bälwu goŋbuywu waŋarrwu; yakana walala yukurrana buku‐ŋal'yurruna Garraywunydja, walalaŋgalaŋuwu Waŋarrwu walŋa‐ḏikṯikkunydja, ŋurikinydja ŋunhi ŋayi walŋakuŋala walalanha yukurrana ŋurikala miriŋuwala walalaŋgala. ");
INSERT INTO gnn_vpl VALUES ("JG8_35","008_8_35","JDG","8","35","35","Ga bitjarrayi bili walala yaka birrka'yurruna ŋanya Gitiyannha, ŋunhi ŋayi ŋuli guŋga'yuna walalanha yukurranha, ga djäka ŋamathanha wal'ŋu walalaŋgu. ");
INSERT INTO gnn_vpl VALUES ("JG9_1","008_9_1","JDG","9","1","57","Ga ŋuliŋuru ŋunhi ŋayi Gitiyan rakunydhinana liŋguna, ga dharapulnydja nhanŋu märraŋala gäthu'mirriŋuyuna nhanukala Wapimalikthuna; ŋayina buŋgawakunharamina ŋanyapinyay ŋayi, märr ŋayina yurru buŋgawa. Yurru Wapimaliktja ŋunhi yätj yana gal'ŋu buŋgawa; warrpam'nha ŋayi bumara rakunyguŋalana gutha'mirriŋunhanydja walalanha nhanŋuway, bukmaknhana yana, liŋgu ŋayi ḏukṯukthina wirrki, ŋayipi yurru buŋgawayirri. Yo, ŋayi yukurrana dhärrana djäka ŋuriki yolŋu'‐yulŋuwunydja ḻurrkun' dhuŋgarranydja ŋupara, bala ŋayi rakunydhinana Wapimaliktja. ");
INSERT INTO gnn_vpl VALUES ("JG13_1","008_13_1","JDG","13","1","1","Ga biyapul ŋunhi Yitjuralpuyŋunydja miṯtji ŋanydjaḻa'yurruna, ga djäma yätjthi ŋunhi rom malanha, gonha'yurrunayi Garraynhanydja. Bala marrtjina miriŋuna bunana Bilitjiyawuy bäpurru' walalaŋgu, ga walalana märraŋala, bala buŋgawayinana walalaŋgu Yitjuralpuyŋuwunydja miṯtjiwu dhuŋgarranydja ŋupara 40. ");
INSERT INTO gnn_vpl VALUES ("JG13_2","008_13_2","JDG","13","2","2","Ŋulinyaramirriyu waluyu ḏarramu yäku Manawa yukurrana nhinana ŋunhalayi Yitjural wäŋaŋura, ga nhanŋu miyalktja ŋunhiyi yothumiriw, yaka yukurrana yothunha gurrukaŋala ŋayi. ");
INSERT INTO gnn_vpl VALUES ("JG13_3","008_13_3","JDG","13","3","3","Waŋganymirriyu waluyu Garraywu djiwarr'wuy yolŋu bunana nhanŋu ŋurikiyi miyalkku, rumbalnydja bitjan yolŋu yana; waŋananydja ŋayi ŋunhi djiwarr'wuynydja yolŋu bitjarra, “Way, dhuwala nhe yothumiriw, yaka nhe ŋula yothunha gurrukanha, yurru galki nhe yurru yothumirriyirrina yulŋunydja, ga yothunydja nhe yurru gurrukama ḏarramunha. ");
INSERT INTO gnn_vpl VALUES ("JG13_4","008_13_4","JDG","13","4","4","Yaka yana nhe yurru ḻukiya gapu ŋänitjiny'tja, ");
INSERT INTO gnn_vpl VALUES ("JG13_5","008_13_5","JDG","13","5","5","ga ŋunhi ŋayi yurru yothu dhuwala dhawal‐wuyaŋirrina nhokuŋu, nhenydja yurru yaka yana ŋanya marwattja gulkthurra, liŋgu ŋayinydja yurru dhuwalayi gänaŋuna wal'ŋu, ganaŋ'maranharana nhanŋuwaynha Godkuna yothu. Ŋayina yurru nhokala gäthu'mirriŋuyuna walŋakumanydja ŋunha Yitjuralpuyŋunhanydja, dhawaṯmarama yurru ŋurukala Bilitjiyapuyŋuwalanydja miriŋuwala, ŋunhi walala yukurra buŋgawayirri ŋuli nhumalaŋgu.” ");
INSERT INTO gnn_vpl VALUES ("JG13_6","008_13_6","JDG","13","6","6","Bala yana ŋayi ŋunhi dhäykanydja marrtjinana, bala ḻakaraŋala dhuway'mirriŋuwunydja bitjarrana, “Way, yolŋu dhuwala ŋarraku bunana dhäwu'mirri, ga rumbalnydja ŋayi ŋunhi balanyara bitjan dhawu'mirri ŋulaŋuru djiwarr'ŋuru, yurru yaka ŋayi ḻakaranhamina ŋarrakala yäkunydja. ");
INSERT INTO gnn_vpl VALUES ("JG13_7","008_13_7","JDG","13","7","7","Ŋayi ḻakaraŋalanydja ŋarrakala ŋunhi ŋarranydja yurru galki yothumirriyirrina, ga gurrukamanydja ŋarra yurru ḏarramunha yothu'nhanydja. Ŋayi ḻakaraŋalanydja ŋarraku, ŋarra yurru yaka ḻuka gapu ŋänitji, bili yothuny'tja dhuwala ḏarramunydja yurru ganaŋ'marama nhanŋuway Godku; ŋayinydja yurru nhanŋuway yana Godku yolŋu nhina yukurra, yana liŋgu ga rakunydhirri ŋayi yurru.” ");
INSERT INTO gnn_vpl VALUES ("JG13_8","008_13_8","JDG","13","8","8","Bala ŋayi Manawanydja nhanŋu dhuway'mirriŋunydja bukumirriyaŋalana Godnha, ga waŋana, “Garray, roŋiyinmaraŋa dhuwali dhäwu'‐gänharamirrinha liliyi, märr ŋayi yurru marŋgikuma ŋinyalanha, ḻakarama nhaltjan dhika ŋilinyu yurru ŋuthanmarama yothu'nha ŋamathamanydja wal'ŋu.” ");
INSERT INTO gnn_vpl VALUES ("JG13_9","008_13_9","JDG","13","9","9","Ga yuwalknha Godthu djuy'yurrunana ŋunhiyi dhäwu'mirrinhanydja liliyi, ŋayi maḻŋ'thurruna biyapul ŋunhala ŋurikala miyalkkala, ŋunhi ŋayi yukurrana nhinana ŋunhala dhulmu‐waṉarra'ŋura wäŋaŋura. ");
INSERT INTO gnn_vpl VALUES ("JG13_10","008_13_10","JDG","13","10","10","Bala yana ŋayi dhunupa ṉaŋ'thurrunana, ga garr'yurruna dhuway'mirriŋunhana nhanŋuway. ");
INSERT INTO gnn_vpl VALUES ("JG13_11","008_13_11","JDG","13","11","11","Ga ŋayinydja Manawanydja marrtjinana, bala waŋana bitjarrana, “Dhuwala nhe ḏarramunydja? . . . ŋunhi nhe dhäwu' gäŋala, ga ḻakaraŋala ŋarrakalaŋuwala miyalkkala?” Ga ŋayinydja waŋana, “Yo,” bitjarra. ");
INSERT INTO gnn_vpl VALUES ("JG13_12","008_13_12","JDG","13","12","12","Ga ŋayi Manawayunydja waŋana ŋanya bitjarra, “Ŋunhi nhuŋu dhäruk yurru dhawaṯthun yuwalktja wal'ŋu, ga nhä yurru dhiyaŋuyi ḏarramuyunydja djäma? Nhaltjurruna ŋayi boŋguŋu nhininydja yukurri?” ");
INSERT INTO gnn_vpl VALUES ("JG13_13","008_13_13","JDG","13","13","14","Ga ŋayinydja ŋuriŋi yolŋuyunydja buku‐ruŋiyinmaraŋala ŋunhi yäna liŋgu dhäruktja dhuḏakthunmina ŋunhi ŋayi ŋäthili ḻakaraŋala, “Dhuwalayi yothu yurru nhanŋuwaynha ganaŋ'maranharana Godkuna,” bitjarra. ");
INSERT INTO gnn_vpl VALUES ("JG13_15","008_13_15","JDG","13","15","18","Ga ŋayinydja ŋunhi Manawanydja waṉḏina, ga wäyinnha warray märraŋala nanikutnha ga ŋatha. Yurru ŋuriŋi dhäwu'‐gänharamirriyunydja yaka ḻukananydja ŋunhiyi ŋatha. ");
INSERT INTO gnn_vpl VALUES ("JG13_19","008_13_19","JDG","13","19","19","Bala ŋayi Manawayu gurrunharana yana ŋunhiyi ŋathanydja ŋunhimala guṉḏalilina, bala bathara Godkuna wekaŋala. ");
INSERT INTO gnn_vpl VALUES ("JG13_20","008_13_20","JDG","13","20","21","Ga ŋunhi ŋayi marrtjina ṉoluŋdhinana bala ŋatŋatthurrunana, bala ŋayinydja ŋunhiyi Garraywu dhäwu'mirrinydja dhawuṯthurrunana marrtjina djiwarr'lilina ŋulana ŋäṉarrkurruna. Bala ŋayi Manawayunydja dharaŋarana ŋunhi ŋunhiyinydja ḏarramu ŋayipi warray, yuwalktja ŋunhi wal'ŋu, Garray warray. Ga ŋayipi ŋunhi ga nhanŋu miyalk maṉḏa ṉepaḻ‐nyilŋ'thurrunana, ḏupthunminana maṉḏa bukunydja munatha'lilina, bala maṉḏanydja yakana biyapulnydja nhäŋala ŋunhi djiwarr'wuynha yolŋunha. ");
INSERT INTO gnn_vpl VALUES ("JG13_22","008_13_22","JDG","13","22","22","Ga ŋayi Manawanydja waŋana dhäykawala nhanukalaŋuwala bitjarra, “Godthu yurru ŋitjalanha bumana, liŋgu ŋali mel‐ŋal'yurruna Garraywala.” ");
INSERT INTO gnn_vpl VALUES ("JG13_23","008_13_23","JDG","13","23","23","Yurru ŋayinydja dhäykanydja nhanukala waŋana bitjarra, “Yä‐ä‐äw. Yaka warray ŋayi yurru buma ŋitjalanha. Ŋunhinydja ŋayi märraŋala ŋitjalaŋguŋu mundhurr, ga ḻakaraŋala ŋayi ŋitjalaŋgu ŋunhi ḻatju' dhäwu'. Ŋilimurru yurru walŋa nhina, yaka rakunydhirri.” ");
INSERT INTO gnn_vpl VALUES ("JG13_24","008_13_24","JDG","13","24","25","Ga yuwalknha dhika ŋunhi miyalktja yothumirriyinana, ga ŋunhi ŋayi nhanukuŋu dhawal‐wuyaŋinanydja ḏarramu, ga yäkunydja ŋayi nherrara ŋanya Djämdjinnha. Ŋunhiyi yothu ŋutharana marrtjina, ga Godthunydja yukurrana gäŋala ḻatju'kuŋalana ŋanya, bala ŋayi ŋutharanydja marrtjina ŋunhi ŋutu'yinana dhikana ganydjarrnydja, ŋunhi ŋanya ganydjarrmirriyaŋala ŋayipi Godthu. ");
INSERT INTO gnn_vpl VALUES ("JG14_1","008_14_1","JDG","14","1","1","Waŋganymirri waluyu ŋayi Djämdjin marrtjina bala Diminalili wäŋalili yäkulili, ga ŋunhala ŋayi nhäŋala Bilitjiyapuyŋunha miyalknha, ḻatju'nha dhika rumbalnha miyalknha. ");
INSERT INTO gnn_vpl VALUES ("JG14_2","008_14_2","JDG","14","2","2","Ga ŋunhi ŋayi lilinydja roŋiyina ŋäṉḏi'mirriŋuwalanydja ga bäpa'mirriŋuwalanydja, bitjarrana ḻakaraŋalanydja ŋayi maṉḏaku, “Ŋunha Diminanydja dhäyka yukurra nhina ŋanya dhika buku‐ḻatju'na bäymana. Ŋarra ḏukṯuk ŋarra yurru märramana ŋanya. Ma' nhuma marrtjiyana, ga gäŋana lili ŋarraku; ŋayi yurru ŋarrakuna miyalktja ŋunha.” ");
INSERT INTO gnn_vpl VALUES ("JG14_3","008_14_3","JDG","14","3","3","Yurru maṉḏa ŋäṉḏi'mirriŋunydja ga bäpa'mirriŋunydja waŋana nhanukala bitjarra, “Nhäku warray nhe yurru märrama ŋunhinydja dhäkaynha? Ŋunhinydja Bilitjiyapuyŋu warray. Nhe ŋuli märraŋu dhipuŋuru bäyma ŋilimurru miṯtjinha miyalknha, Yitjuralpuyŋunha yana, liŋgu ŋunhayinydja bäpurru' yaka warray yukurra buku‐ŋal'yun Godku Garraywu.” Ga ŋayi Djämdjindja waŋana bitjarrana, “Ŋurukuna liŋguna ŋarra ḏukṯuktja nhanŋuwaynha, ŋarra yurru märramana ŋanya.” ");
INSERT INTO gnn_vpl VALUES ("JG14_4","008_14_4","JDG","14","4","4","Yo, ŋulinyaramirriyunydjayi waluyu ŋunhiyi walala Yitjuralpuyŋu yukurrana nhinana ŋurikala Bilitjiyapuyŋuwala goŋŋura, walala yukurrana wäŋawu buŋgawayina ga Yitjuralpuyŋuwu yolŋu'‐yulŋuwu ŋuriki. Ga Garrayyunydja bulnha galkurruna yukurrana nhäŋala dhukarr, wanhawitjan ŋayi yurru dhukarrkurru yarrkmarama ŋunhiyi buma Bilitjiyapuyŋunha; ŋayi yurru buma dhawar'maramanydja Djämdjingalaŋukurruna ŋunhi. ");
INSERT INTO gnn_vpl VALUES ("JG14_5","008_14_5","JDG","14","5","5","Bala Djämdjin marrtjinana, malthurrunanydja ŋayi ŋäṉḏi'mirriŋuwu ga bäpa'mirriŋuwu bala Diminalilina. Ŋunhi walala marrtjina bala wäŋgaŋala dhukarr‐ŋupara, bala ŋayi ŋäkula läyin wäyin maḏakarritj, ŋayi marrtjina murryurruna. ");
INSERT INTO gnn_vpl VALUES ("JG14_6","008_14_6","JDG","14","6","6","Ga dhunupana ŋanya Djämdjinnhanydja Godkalanydja ganydjarryu monyguŋalana, bala ŋayi marrtjina ḏälthinana dhika, wuṉḏaŋarryinana. Bala ŋayi gatjpaḻ'yurrunanydja, baṯ‐gay mulkana ŋunhiyi wäyinnha läyinnhanydja, bala yana barr'maraŋalana nhanukiyingala goŋdhuna, bitjarrana dhuwala bitjan ŋuli yolŋuyu barr'maraŋu yutjuwaḻa' wäyin nanikut. Yurru ŋayi yaka ḻakaraŋala bäpa'mirriŋuwunydja ga ŋäṉḏi'mirriŋuwunydja ga ŋula yolku birrka'mirriwunydja. ");
INSERT INTO gnn_vpl VALUES ("JG14_7","008_14_7","JDG","14","7","7","Dhurrwaraŋuru ŋuliŋurunydja ŋayi Djämdjin marrtjinana bala, ga bunana ŋuriki miyalkkuna; wirrkina ŋayi ḏukṯukmirriyina nhanŋu märranharawuna ŋuriki miyalkku. ");
INSERT INTO gnn_vpl VALUES ("JG14_8","008_14_8","JDG","14","8","8","Ŋula nhämuny'nha walu djuḻkthurruna, bala ŋayi roŋiyinana balayi märranharawuna ŋurikiyi miyalkkuna. Marrtjinanydja ŋayi, ga biyapul ŋayi gatjpaḻ'yurruna nhänharawuna ŋurikiyi läyinguna ŋunhi ŋayi yawungu buma. Bala ŋayi nhäŋala ṉirryurrunana dhika, marrtjina guku warray ŋunhimala buṉbuŋalanydja läyingala rumballilinydja. ");
INSERT INTO gnn_vpl VALUES ("JG14_9","008_14_9","JDG","14","9","9","Bala ŋayi goŋdhuna dhiṯthurruna gukunydja ŋunhi ŋuliŋuruyi läyingalanydja, bala ḻukanana marrtjina bala, biḻaŋ'thurrunana. Ga wiripunydja ŋayi wekaŋala bäpa'mirriŋuwuna ga ŋäṉḏi'mirriŋuwuna, ga maṉḏanydja ḻukanayi ŋunhi. Yurru Djämdjindhu yaka ḻakaraŋala bäpa'mirriŋuwunydja ga ŋäṉḏi'mirriŋuwunydja ŋunhi ŋayi ŋunhiyi märraŋala guku ŋulaŋuru läyingala rumbalŋuru. ");
INSERT INTO gnn_vpl VALUES ("JG14_10","008_14_10","JDG","14","10","10","Yo, Djämdjingu bäpa'mirriŋu marrtjina ŋunhimalayinydja buṉbulilinydja, bala ŋayi Djämdjindhunydja ŋathana ŋäthilimirriyaŋala ŋurikala miyalkkalana bala'ŋura, walala yurru ḻuka nhanukala yukurra ḻundu'mirriŋuyu walalay, liŋgu ŋunhiyinydja walalaŋgu rom. ");
INSERT INTO gnn_vpl VALUES ("JG14_11","008_14_11","JDG","14","11","11","Bala ŋulinyaramirriyu 30 ḏarramuwurruyunydja withiyara ŋanya Djämdjinnha, Bilitjiyapuyŋuyunydja yawirriny'thu, bala walala ḻukanana yukurrana märr‐ŋamathinanana, rrambaŋina walala Djämdjindhuna. ");
INSERT INTO gnn_vpl VALUES ("JG14_12","008_14_12","JDG","14","12","13","Ga ŋayi Djämdjindja waŋana walalaŋgala bitjarra, “Ŋarra yurru nhumalanha waŋa mayali'kurru, ga ŋuli nhe yurru mayali' maḻŋ'marama warray dhipuŋuruyi, ga ŋarranydja yurru barrkuwatj yana nhumalaŋgu weka'‐wikama girri' ḻatju'mirrinydja. Ga ŋuli nhuma yurru yakanydja maḻŋ'marama mayali', nhumanydja yurru wekama ŋarranha girri', waŋga'‐waŋganydhu yana nhuma.” Ga walalanydja ŋunhi yuraŋala bukmak, waŋana bitjarrana, “Go waŋiya lili ŋanapurrunha, ḻakaraŋa ŋanapurruŋgu.” ");
INSERT INTO gnn_vpl VALUES ("JG14_14","008_14_14","JDG","14","14","14","Bala Djämdjindhunydja ḻakaraŋala bitjarrana, “Ŋuliŋuru ḻäwunhamirriwala dhawaṯthurruna ḻukanharamirrina, ga ŋuliŋuru ganydjarr‐ḏumurruwala dhawaṯthurruna ŋula nhä dhäkay‐djulŋi,” bitjarra ŋayi ḏe'ŋu‐ŋuparanydja walalaŋgu. Ga walalanydja yukurrana baḏak birrka'yurruna yawirriny'thunydja ŋuriŋi, ga ḻurrkun' walunydja ŋupara, ga yakana maḻŋ'maraŋalanydja walala nhä ŋunhi mayali' ŋayi ḏe'ŋu‐ŋupara walalaŋgu. ");
INSERT INTO gnn_vpl VALUES ("JG14_15","008_14_15","JDG","14","15","15","Ga wiripuŋuyuna munhayu ŋunhi Bilitjiyapuyŋu yawirriny' waŋana nhanukalaŋuwala miyalkkala Djämdjingalaŋuwala, “Mayali'‐wulaŋa nhe nhuŋuway dhuway'mirriŋunha ŋe', . . . ga maḻŋ'maraŋa nhanukala mayali' ŋunhiyi dhäruk, märr ŋanapurru yurru marŋgithirri. Ga ŋuli nhe yurru yakanydja ŋanapurruŋgu ḻakarama, marŋgikuma ŋanapurrunha, ŋanapurrunydja yurru dhuŋgur'yun nhokalaŋuwa bäpa'mirriŋuwa wäŋana, ga nhunapinyay. Nhäku nhuma maṉḏa ŋanapurrunha garr'yurruna dhipalanydja? . . . Nhe ḏukṯuk ŋanapurru yurru rarr'yun yana nhokalaŋuwu girri' dhuway'mirriŋuwu?” Ga bitjarra walala yukurrana waŋana ŋurikala dhäykawalanydja. ");
INSERT INTO gnn_vpl VALUES ("JG14_16","008_14_16","JDG","14","16","16","Bala ŋayi ŋunhiyi miyalktja marrtjinana withiyara Djämdjinnhana dhuway'mirriŋunhana nhanŋuway, bala ganurukurruna waŋana marrtjina ŋanya, “Yaka ŋarraku nhe yukurra märr‐ŋamathirrinydja dhuwala. Yana nhe yukurra ŋarraku ŋaramurrthirri ŋiniya! Ḏe'ŋu‐ŋupara nhe waŋana ŋarraku ḻundu'mirriŋunha walalanha, ga yakana nhe ḻakaraŋala ŋarrakunydja mayali' ŋunhiyi.” Ga ŋayinydja Djämdjindja waŋana bitjarra, “Bitjarraŋga liŋgu ŋarra yaka yana mäḻu'mirriŋuwanydja ga ŋäṉḏi'mirriŋuwanydja ŋarrakalaŋuwa ḻakaraŋala ŋunhiyi mayali'. Nhäku warray ŋarra yurru nhuŋunydja ḻakarama mayali'?” Bitjarrana ŋayi Djämdjindja waŋana. ");
INSERT INTO gnn_vpl VALUES ("JG14_17","008_14_17","JDG","14","17","17","Bala ŋayinydja ŋayaŋganynha ŋäthina ŋunhi nhanŋu miyalktja, ŋayaŋganynha nhinana ŋäthina 7 munhanydja ŋupara, ga yana liŋgu‐u‐u rom ŋunhiyi ŋathawuy dhawar'yurruna walalaŋgu. Yana liŋgu ga ŋunhina ḏaḏaw'yunaramirrina walu ŋayathaŋala, bala ŋayi ŋulinyaramirriyuna ḻakaraŋalanydja nhanbala ŋuripa miyalkpanydja, bili ŋayi yukurranha bitjanana liŋgu ŋuli waŋanhana ŋanya, “Ḻakaraŋa ŋarraku mayali',” bitjanana ŋayi yukurranha ŋuli. Bala ŋayi yuwalkthina ḻakaraŋalana Djämdjindhunydja ŋunhi mayali'na, ga dhunupana ŋayinydja ŋunhi dhäykanydja marrtjinana, bala ḻakaraŋalana walalambala ŋuripa yawirriny'pana. ");
INSERT INTO gnn_vpl VALUES ("JG14_18","008_14_18","JDG","14","18","18","Ga walalanydja martj‐gay martj‐martjtjurrunana lili, ga bunana Djämdjinguna, bala waŋana bitjarrana, “Liŋguna ŋanapurru maḻŋ'maraŋalana ŋunhi mayaliny'tja. Guku dhuwala dhäkay‐djulŋinydja, ga ganydjarr‐ḏumurrunydja ŋunhi ga läyin wäyin. Nhe maḻŋ'maraŋala guku läyingala.” Ga ŋayi Djämdjindja buku‐wakmaraŋala bitjarra, “Ŋunhi bini nhuma yaka warray djaw'yuna ŋarraku miyalknha, ga nhumanydja bini yaka warray maḻŋ'maranha mayali'.” ");
INSERT INTO gnn_vpl VALUES ("JG14_19","008_14_19","JDG","14","19","19","Bala wirrkina ŋayi Djämdjindja dhika ŋaramurryina. Dhunupa ŋayi dhika ganydjarrnha märraŋala gay', ŋutu'na bunana nhanŋu ganydjarr Garraywuŋuna nhanukuŋuwaynha, bala yana ŋayi marrtjinana, bala bumarana yolŋu'‐yulŋunha ḏarramuwurrunha Bilitjiyapuyŋunhananydja, 30‐nha miṯtjinhanydja ŋayi bumara rakunyguna. Bala ŋayi yup‐yupmaraŋalana ŋurikala walalaŋgala girriny'tja rumbalŋurunydja, bala gäŋala ŋunhiyinydja girriny'tja ŋuripana walalambala yawirriny'pana ŋunhi walala mayali' nhanŋu ḻakaraŋala. Yo, Djämdjindja wirrkina ŋaramurryina miyalkkunydja ŋuriki nhanukalayŋuwu, bala ŋayi gonha'yurrunana ŋanya, bala marrtjina balayi bäpa'mirriŋuwalana wäŋalili. ");
INSERT INTO gnn_vpl VALUES ("JG14_20","008_14_20","JDG","14","20","20","Ga nhanukala ŋurikala miyalkkalanydja bäpa'mirriŋuyu wekaŋala ŋanya ŋunhi miyalknhanydja wiripuŋuwana ḏarramuwa, Djämdjingalaŋuwa ḻundu'mirriŋuwana. ");
INSERT INTO gnn_vpl VALUES ("JG15_1","008_15_1","JDG","15","1","1","Ga liŋguna ŋunhiyi walunydja ŋatha‐ŋalwuruŋ'thinyaramirrina, ga ŋulinyaramirriyuna ŋayi waluyu Djämdjindja marrtjina balayi nhanukalaŋuwala miyalkkalanydja. Marrtjina ŋayi, bala waŋana miyalkkalaŋuwalana bäpa'mirriŋuwala bitjarra, “Ŋarra ḏukṯuk ŋarrakalaŋuwu miyalkku.” ");
INSERT INTO gnn_vpl VALUES ("JG15_2","008_15_2","JDG","15","2","2","Ga ŋayinydja ŋunhi bäpa'mirriŋunydja nhanŋu ŋurikiyi dhäykawunydja bitjarra waŋana, “Ŋarranydja nhuna birrka'yurruna yanapi nhe ŋaramurrthi yukirri nhanŋu mukthurru, yaka ḏukṯukthi, bala ŋarra wiripuŋuwana ḏarramuwa gathana ŋanya yawungu. Dhuwala wiripunydja gay', nhanŋu gutha'mirriŋunydja, ŋunhi ŋayi balanyara liŋgu ḻatju' dhika dhäyka. Nhenydja yurru dhuwalana märrama.” ");
INSERT INTO gnn_vpl VALUES ("JG15_3","008_15_3","JDG","15","3","3","Yurru ŋayinydja Djämdjindja wirrkina dhika maḏakarritjthina, bala waŋana bitjarrana, “Nhe yawungu ŋarranha mayali'‐wilkthun, ga biyapul nhe ŋarranha mayali'‐wilkthurrunayi. Nhuma dhuwala Bilitjiyapuyŋunydja yätjmirrina, ga ŋarranydja yurru bitjandhi bili yätjkumayi nhumalanha Bilitjiyapuyŋunhanydja.” ");
INSERT INTO gnn_vpl VALUES ("JG15_4","008_15_4","JDG","15","4","4","Bala ŋayi dhawaṯthurrunana marrtjina, bala galkara ŋayi wäyinnha waṯuyinyarana, 300‐nha ŋayi miṯtjinydja märraŋala, yurru wambalnydja ŋunhi walala bulka'‐ḏilkurru. Bala ŋayi ŋunhi walalanha wambalnydja maltja'‐maltjaṉana rrambaŋikuŋalana ḏäpthu'‐ḏapthunmaraŋalanydja, märrma'nha, ga märrma'nha, ga märrma'nha, bitjarra marrtjina bala ḏapthunmaraŋalanydja waŋganylilina. ");
INSERT INTO gnn_vpl VALUES ("JG15_5","008_15_5","JDG","15","5","5","Ga ŋunhimalayinydja wamballilinydja djin'kayŋulilinydja walalaŋgala, ga yaŋara'mirrina gurthana ŋayi ḏap‐ḏapmaraŋala walalaŋgala, bala ŋayi walalanha yänana‐wala yana djuy'yurrunananydja. Ga walalanydja ŋunhi wäyindja walala gundupuŋala bala bitjarra, ga bala bitjarra, wambal‐gurthamirrina walala, bala marrtjina nhäranana ŋunhi ŋathanydja birralinydja warrpam'nha, ga bitjarrayi bili yana borummirrinydja dharpa nhäranayi, raku'‐rakunydhinana. ");
INSERT INTO gnn_vpl VALUES ("JG15_6","008_15_6","JDG","15","6","6","Ga walalanydja Bilitjiyapuyŋunydja wirrkina dhika maḏakarritjthina, bala yana walala marrtjinana, ga bumara rakunyguna ŋunhiyi Djämdjingunydja dhäykanha, ga nhanŋu bäpa'mirriŋunha, ga wäŋanydja ŋunhi walala nhanŋu dhuŋgur'yurrunana. ");
INSERT INTO gnn_vpl VALUES ("JG15_7","008_15_7","JDG","15","7","7","Bala Djämdjindja wirrkina dhika maḏakarritjthina, bala waŋana bitjarrana, “Nhuma Bilitjiyapuyŋuyu walalay ŋarraku bumara dhäykanha, ga ŋarranydja yurru nhumalanhanydja bitjan yana liŋgu buku‐ruŋiyinmarama wirrkina wal'ŋu.” ");
INSERT INTO gnn_vpl VALUES ("JG15_8","008_15_8","JDG","15","8","8","Bala ŋayi bumarana gay' ŋunhi Bilitjiyapuyŋunhanydja wiṯthurrunana dhika, ga ŋuliŋurunydja dhurrwaraŋuru ŋayi marrtjina ŋunhana mathirralilina, ga ŋunhalana ŋayi nhinananydja yukurrana, galki Yetamŋura wäŋaŋura. ");
INSERT INTO gnn_vpl VALUES ("JG15_9","008_15_9","JDG","15","9","9","Ga walala Bilitjiyapuyŋunydja wäŋgaŋala ga ŋayan'‐dharrana bala'mirriwu ŋuriki wäŋawu Yetamgu. ");
INSERT INTO gnn_vpl VALUES ("JG15_10","008_15_10","JDG","15","10","10","Ga wäŋawuy ŋurikiyyinydjayi Djuda bäpurru' ḏarramu waŋana dhä‐wirrka'yurruna walalanha bitjarra, “Nhäku nhuma yukurra dhuwala ŋayan'‐dharra ŋanapurruŋgunydja?” Ga walalanydja buku‐ruŋiyinmaraŋala bitjarra, “Ŋunha ŋanapurru dhuwala ḏukṯuk Djämdjingu. Ŋanapurru yurru ŋanyanydja yätjkuma yana, bitjarra ŋayi ŋanapurrunha yätjkuŋala.” ");
INSERT INTO gnn_vpl VALUES ("JG15_11","008_15_11","JDG","15","11","11","Bala walalanydja ŋunhi Djudanydja ḏarramuwurru wäŋgaŋalana guḻku'na dhika mala'mirriŋuna yolŋu'‐yulŋu, wäŋgaŋalanydja walala yukurrana balayi ŋunhimala mathirralili, ga waŋana Djämdjingala bitjarra, “Bilitjiyapuyŋunydja ŋunha ŋanapurruŋgu buŋgawayirri yukurra. Nhäku warray nhe bumaranydja walalanha?” Ga ŋayinydja waŋana bitjarra, “Walala bumara ŋarraku miyalknha, ga yurruna ŋarranydja bumara walalanhanydja.” ");
INSERT INTO gnn_vpl VALUES ("JG15_12","008_15_12","JDG","15","12","12","Ga walala miṯtjinydja waŋana bitjarra, “Ŋanapurrunydja yurru nhuna dhuwala ḏapthunmaramana, ga wekama walalaŋgalana goŋlili; walala yurru bumana nhuna, ga ŋanapurrunhanydja gonha'yunna.” Ga Djämdjindja waŋana bitjarra, “Gatjuy, manymak muka. Yurru dhawu'‐nherrala ŋarrakala, märr nhumanydja dhiyaŋunydja walalay yurru yakana ŋarranhanydja buma.” ");
INSERT INTO gnn_vpl VALUES ("JG15_13","008_15_13","JDG","15","13","13","Bala walala waŋana bitjarrana, “Manymak, dhuwalana ŋanapurru yurru nhuna garrwi'yunna dhiyaŋu raki'yuna, ga gäma nhuna yurru, ga wekama ŋurikala walalaŋgala Bilitjiyapuyŋuwalana. Ga ŋanapurruwaynydja yurru yakayi buma nhuna.” Yo, walala ḏälkuŋalanydja yukurrana märrma' wuṉḏaŋarrnydja maṉḏanha dhika raki' maṉḏanha, yuṯana maṉḏanha, bala ḏapmaraŋalanydja ŋanya ŋuriŋiyi raki'yuna. Bala walala ŋanya dhawaṯmaraŋalana ŋuliŋuru mathirraŋurunydja, ga gäŋalana ŋurikala Bilitjiyapuyŋuwalana. ");
INSERT INTO gnn_vpl VALUES ("JG15_14","008_15_14","JDG","15","14","14","Marrtjinanydja walala yukurrana bala dhukarr‐ŋupara, gäŋala marrtjina Djämdjinnha, ga ŋunhi walala marrtjina galkithinanydja ŋunhi bala'‐mäypamirrililina wäŋalili, bala walalanydja nhäŋalana ŋuriŋi Bilitjiyapuyŋuyunydja, yurru walala gundupuŋalana gay', gumurr'yurrunana walalaŋgu, yatjunminana nhinana dhika lili märranharawuna nhanŋu Djämdjingu. Bala ŋayinydja marrtjina Djämdjindja ḏälthinana dhikana, ganydjarr ŋutu'na nhanŋu bunana Garraywuŋuna, yurru ŋayi marrtjina baṉdja maṉḏanha dhanatjthurrunana bitjarrana gay'; bala marrtjina yana rakiny'tja dhunupa gulk‐gulkthurrunana ḏaw'yurrunana. ");
INSERT INTO gnn_vpl VALUES ("JG15_15","008_15_15","JDG","15","15","15","Bala ŋayi Djämdjindhu nhäŋala ŋaraka wäyin duŋ'ki, yurru burumun'puy ŋayi ŋunhi ŋarakanydja. Bala ŋayi baḻapthurrunanydja, märraŋalana ŋunhiyi ŋarakanydja, bala bumarana marrtjina dhawar'maraŋalana 1000‐nhana miṯtjinha ŋuriŋiyina ŋarakayuna, yana liŋgu‐u‐u dhurr'maraŋalana yukurrana ŋunhi Bilitjiyapuyŋunhanydja yolŋu'‐yulŋunha. ");
INSERT INTO gnn_vpl VALUES ("JG15_16","008_15_16","JDG","15","16","16","Bala ŋayi Djämdjindhu yuṯana manikay maḻŋ'maraŋala, bitjarrana ŋayi bark‐barkthurrunanydja gam', “Dhiyaŋu duŋ'kiwala ŋarakayu ŋarra dhawar'maraŋala bumara 1000‐nha yolŋu'‐yulŋunha, dhurr'maraŋalana yukurrana waŋganylilina ŋurruklili ŋunhiyi rumbalnydja yolŋu'‐yulŋunha rakunymirrinhanydja.” ");
INSERT INTO gnn_vpl VALUES ("JG15_17","008_15_17","JDG","15","17","17","Ga liŋguna, bala ŋayi ḏupthurrunana ŋunhi ŋarakanydja ŋunhiwalana, ga ŋunhiyi wäŋanydja buku walala nherrara yäkunydja “Dhakal‐ŋaraka.” ");
INSERT INTO gnn_vpl VALUES ("JG15_18","008_15_18","JDG","15","18","18","Ga ŋuliŋurunydja Djämdjin ŋanhdharkthinana, wiṯthurrunana ŋayi dhika ŋanhdharkthinanydja, bala ŋayi Garraywalana wäthurruna, bitjarrana waŋananydja ŋayi, “Ŋarra bumara ŋunhi walalanha miriŋunha nhokala ganydjarryu, ga dhuwalana ŋarra gay rakunydhirrina marrtji ŋanhdharkthinyarayu. Wekaŋa ŋarranha go gapu, märr ŋarranha yurru ŋuruŋunydja ḏarramuyu miriŋuyunydja yakaŋga marrtji ga buma ŋarranha, ŋuriŋinydja ŋunhi walala yaka marŋgi nhuŋu.” ");
INSERT INTO gnn_vpl VALUES ("JG15_19","008_15_19","JDG","15","19","19","Bala yana Garrayyunydja munatha'na ḻurrthunmaraŋala ḻapmaraŋala, bala yana gapuna dhawaṯthurruna dhika, ḻatju'na dhikana ḏarrtjalknha ŋanyana gapu. Ga wurkthurrunana ŋayi yukurrana Djämdjindhu ŋuliŋuru gapunydja, yana liŋgu ga ŋoy‐yal'yurruna. ");
INSERT INTO gnn_vpl VALUES ("JG15_20","008_15_20","JDG","15","20","20","Yo, Djämdjindhu guŋga'yurrunanydja nhanŋuwaynydja miṯtjinha yolŋu'‐yulŋunha Yitjuralpuyŋunhanydja 20 dhuŋgarranydja ŋupara, yurru mukthurruna yukurrana yana Bilitjiyapuyŋuwala bäpurru'wala ŋunhi wäŋanydja dhärrana goŋŋura yukurrana. ");
INSERT INTO gnn_vpl VALUES ("JG16_1","008_16_1","JDG","16","1","1","Waŋganymirriyunydja waluyu ŋayi marrtjina Djämdjin bala wäŋalili yäkulili Gäthalili, marrtjinanydja ŋayi bala, dharr‐way nhäŋala dhäykanha, marramba'‐ḏumurrunha miyalknha, ga ŋayinydja Djämdjindja malthurrunana nhanbala, dhäykawalana ŋurikalana wäŋalili. ");
INSERT INTO gnn_vpl VALUES ("JG16_2","008_16_2","JDG","16","2","2","Ga ŋuriŋi yolŋu'‐yulŋuyunydja wäŋa‐ŋurikiynydja walalay ŋäkulana Djämdjinnha, ŋunhi ŋayi yukurrana gulŋiyina ŋunhiliyi ŋurikala dhäykawala wäŋaŋura bala'ŋura, bala walalanydja ŋunhi yolŋu'‐yulŋunydja gungaŋalana wäŋana nhanŋu, ḻiw'maraŋalana ŋunhiyi buṉbunydja, ga munha‐ŋuparana walala yukurrana dhukarr‐nhäŋalanydja, galkurrunanydja nhanŋu ŋuriki Djämdjingu dhawaṯthunarawuna. “Ŋilimurru galkun yana yukurra yurru nhanŋu, ga yana liŋgu ga djaḏaw'yun yurru, bala ŋilimurru yurru bumana ŋanya rakunygumana,” bitjarra walala waŋanharaminanydja. ");
INSERT INTO gnn_vpl VALUES ("JG16_3","008_16_3","JDG","16","3","3","Yurru ŋayi Djämdjindja liŋguna marrtjina gonha'yurruna ŋunhiyi balany'tja; buku‐rangu dhulmuyu munhayu dhika ŋayi gaŋgathina, bala marrtjina warraŋullilina dhawaṯthurruna, yurru maḻŋ'maraŋalanydja ŋayi ŋunhi wäŋa ḻoḻunydja dhurrwaranydja dhaḻ'yunarawuy warray. Yo, dhurrwaranydja ŋurikiy wäŋawuy ḻoḻunydja ŋonuŋnha bäymana dhika, ga ḏälnha bäyma, yurru ŋayi Djämdjindhu dhunupa ŋawatthurrunanydja ŋunhiyi dhurrwaranydja, yana ḻaw'maraŋalana nhanukalay ḻambarrlilina, bala yana gäŋalana nhinana bala bena‐wala barrkulilina wäŋalili ŋunhana ya', bala yana gurrunharanydja ŋal'maraŋala ŋunhana bukulilina, garrwarlilina ŋunhana wal'ŋu wäŋalili, galki Yiprunlilina. ");
INSERT INTO gnn_vpl VALUES ("JG16_4","008_16_4","JDG","16","4","4","Dhäŋuru ŋuliŋurunydja Djämdjindhu wiripuŋunhana miyalknha nhäŋala, Bilitjiyapuyŋunha yana miyalknha yäkunha Delalanha, yurru ŋayi wirrkina ḏukṯukmirriyinanydja nhanŋu ŋuriki dhäykawu. ");
INSERT INTO gnn_vpl VALUES ("JG16_5","008_16_5","JDG","16","5","5","Ga buŋgawa walala ŋurikiy Bilitjiyawuy bäpurru' waŋana ŋurikala miyalkkala Delalawala bitjarra gam'. “Nhämirri ŋuli nhe märraŋunydja ŋanya Djämdjinnha, märr nhe yurru mayali'‐wulama ŋanya, ga wekama ŋanapurruŋgalana goŋlili. Dhä‐wirrka'yurra ŋanya ŋe', nhäyu ŋayi yukurra ganydjarr‐ḏumurruyirri. Ga maḻŋ'maraŋa nhanukala nhaltjan yurru ŋunhi yolŋu'‐yulŋuyunydja ŋanya ganydjarr‐winya'yunmarama, nhäyuna. Ga ŋunhi nhe yurru ḻakaramanydja ŋanapurruŋgala, ga ŋanapurrunydja yurru marrtjina‐wala, ga ḏapmaramana ŋanya. Ga ŋanapurru yurru waŋga'‐waŋganydhu wekamanydja nhuŋu dhaŋaŋnha yana biyapulnha wal'ŋu rrupiyanydja.” Ga bitjarranydja ŋuriŋi yukurrana buŋgawayu walalay dhawu'‐nherrara rrupiya ŋurikiyi dhäykawu, bala ŋayi märraŋalana ŋanya Djämdjinnha. ");
INSERT INTO gnn_vpl VALUES ("JG16_6","008_16_6","JDG","16","6","6","Bala ŋayi waŋana ŋuriŋi dhäykayu, dhä‐wirrka'yurruna ŋanya Djämdjinnha bitjarra, “Wäy, nhäyu muka dhuwala nhuna yukurra ganydjarr‐ḏumurrukumanydja? Nhaltjanna yurru walala ŋula yolthu walalay ganydjarrmiriwyamanydja nhuna? . . . märr walala yurru ḏapmarama nhuna raki'yunydja?” ");
INSERT INTO gnn_vpl VALUES ("JG16_7","008_16_7","JDG","16","7","7","Ga Djämdjindja buku‐ruŋiyinmaraŋala waŋana bitjarra, “Ŋuli yurru walala garrwi'‐garrwi'yundja ŋarranha 7‐dhu raki'yunydja, ŋuriŋi bonarra'wuyyu raki'yu, ga yurruna ŋarra yurru ŋunhi ganydjarrmiriwyirrinydja, bitjan dhuwala wiripu‐guḻku' yolŋu'‐yulŋu.” Bitjarra ŋayi Djämdjindhu yukurrana ḻakaraŋala Delalawunydja ŋunhi dhäykawunydja, yurru yaka ŋayi yukurrana Djämdjindhu ŋunhi yuwalktja wal'ŋu ḻakaraŋala, yana ŋayi yukurrana warku'yurruna ŋunhi miyalknha. ");
INSERT INTO gnn_vpl VALUES ("JG16_8","008_16_8","JDG","16","8","8","Ga dhunupana ŋayinydja ŋunhi miyalktja marrtjina, bala ḻakaraŋala ŋuripa buŋgawawana walalambala, bala walalanydja rarr'yurrunana nhanbala 7 raki' bonarra'wuy, yuḏayuḏa yana. Ga gonha ŋayi Djämdjin yakurrthinana, bala ŋayinydja ḏapṯapmaraŋalana ŋanya ŋuriŋiyi bonarra'wuyyunydja raki'yu malanyŋuyu 7‐dhu. ");
INSERT INTO gnn_vpl VALUES ("JG16_9","008_16_9","JDG","16","9","9","Ga walalanydja ŋunhi Bilitjiyapuyŋunydja ḏarramuwurru dharra'‐dharrana marrtjina ŋunhala warraŋul, galkurruna nhanŋu Djämdjingu märranharawuna. Ga ŋayinydja Delalanydja waŋana yatjurrunana dhika, dhirr'yurruna ŋanya Djämdjinnha bitjarra, “Djämdjin gaŋgathiyana! Dhuwalana dhuwala Bilitjiyapuyŋunydja marrtji yukurra, märramana nhuna yurru.” Dhunupa ŋayi gaŋgathinanydja ŋuliŋuru yakurrŋuru, bala gulk‐gulkthurrunana yana ŋunhi rakiny'tja, waḏutjana gulk‐gulkthurrunana‐wala yana. ");
INSERT INTO gnn_vpl VALUES ("JG16_10","008_16_10","JDG","16","10","10","Ga miyalktja ŋunhi waŋana Djämdjingala bitjarra, “Nhäku nhe yukurra ŋarranha dhuwala warku'yundja? Yaka warray nhe ŋarraku dhuwala ḻakaraŋala yuwalkŋunydja. Nhaltjurru ŋuli nhuna dhika ḏapmaraŋu ŋula yolthu yolŋuyunydja? Ma' nhe ḻakaraŋana ŋarraku lili go.” ");
INSERT INTO gnn_vpl VALUES ("JG16_11","008_16_11","JDG","16","11","11","Bala ŋayinydja buku‐ruŋinyamaraŋala bitjarra warray, “Ŋuli walala ŋarranha ŋula yolthu ŋuli ḏapmaraŋu yuṯayu raki'yu, ga ŋarranydja ŋuli ganydjarrmiriwyina, bitjan dhuwala walala wiripu‐guḻku'.” ");
INSERT INTO gnn_vpl VALUES ("JG16_12","008_16_12","JDG","16","12","12","Bala ŋayipina Delalayuna märraŋala raki' yuṯa, wuṉḏaŋarrnha dhika raki', bala ḏap-ḏapmaraŋalana ŋanya Djämdjinnha. Yo, ŋunhi ḏarramuwurrunydja galkurruna yukurrana ŋunhala warraŋul, ga biyapul ŋayi ŋunhiyi miyalktja yatjurruna, “Djämdjin, dhuwalana Bilitjiyapuyŋunydja marrtji yukurra lili märranharawuna nhuŋu.” Ga dhunupa ŋayinydja Djämdjindja gaŋgathina, gulk‐gulkthurrunana rakiny'tja ŋunhi. ");
INSERT INTO gnn_vpl VALUES ("JG16_13","008_16_13","JDG","16","13","13","Ga biyapul ŋayi Delala waŋana nhanukala Djämdjingala bitjarra, “Wakal‐ŋurra nhe yukurra dhuwala ŋarrakala, yakana nhe yuwalkkuma yukurra ḻakarama ŋarraku. Ḻakaraŋa ŋarrakala, nhaltjurruna ŋuli dhika ŋula yolthu yolŋuyu ḏapmaraŋunydja nhuna?” Ga ŋayinydja waŋana Djämdjindja bitjarra nhanukala. “Nhäŋa ŋarranha marwat dhuwala weyin. Ga ŋuli yurru ŋula yolthu ŋarranha marwat bothu'yama ŋuruŋu girri'yu ŋunhi walala ŋuli dharpuma yukurra girri' baḻaŋgit; ga ŋuli yurru walala ŋarranha marwat warray ŋunhimalayi gurrunhan, ga ŋunhiyinydja bitjan ŋarra yurru ganydjarrmiriwyirrina, bitjan dhuwala wiripu‐guḻku' yolŋu'‐yulŋu.” ");
INSERT INTO gnn_vpl VALUES ("JG16_14","008_16_14","JDG","16","14","14","Yuwalkthi Delalayu yakurrkuŋalana ŋanya, bala ŋilitjara ŋunhi girri'lilina ŋunhiwalana marwattja ŋanya Djämdjinnha, bala ḏälkuŋalana yana ŋilitjara. Ga biyapul ŋayi yatjurruna waŋana, “Djämdjin gaŋgathiyana! Dhuwalana Bilitjiyawuynydja walala marrtji yukurra, märramana yurru nhuna.” Ga ŋayinydja dhunupa gaŋgathinana, ga dhayaḻana marwattja ŋayi ŋunhi. ");
INSERT INTO gnn_vpl VALUES ("JG16_15","008_16_15","JDG","16","15","15","Ga ŋayinydja waŋana dhäykanydja bitjarra, “Yakana dhuwala nhe ŋarraku yukurra märr‐ŋamathirri yuwalktja. Ḻurrkun'mirri nhe ŋarranha yukurrana warku'yurrunanydja. Yaka nhe ḻakaraŋala ŋarraku dhunupa, nhäyu nhuna yukurra wuṉḏaŋarrkumanydja.” ");
INSERT INTO gnn_vpl VALUES ("JG16_16","008_16_16","JDG","16","16","16","Bitjarrana liŋguna ŋayi ŋanya yukurrana walu‐ŋuparana ŋoy‐wulaŋalanydja waŋananydja, ga ŋayinydja Djämdjindja djawaryurrunana nhanukala dhä‐wirrka'yunarayu marrtjinyarayu. Bala ŋuliŋurunydja ŋayi nhanŋu yuwalknha wal'ŋu ḻakaraŋla, ");
INSERT INTO gnn_vpl VALUES ("JG16_17","008_16_17","JDG","16","17","17","waŋana bitjarrana gam'. “Yurruna ŋarra dhawal‐wuyaŋina, ŋarrakala ŋäṉḏi'mirriŋuyunydja ŋarranha wekaŋala ganaŋ'maraŋalana nhanŋuwaynha Godkuna, ga beŋuru liŋgu ŋunhi ŋarra dhawal‐wuyaŋina, ŋarranydja nhanŋuway yana Garraywu; yaka dhuwala yukurrana marwat ŋarraku gulkthurruna beŋuru bili. Ŋunhi ŋuli ŋula yolthu ŋarranha marwattja gulkthurru, ŋarranydja ŋuli ganydjarr winya'yurruna; ŋarra yurru ganydjarrmiriwyirrina yalŋgithirrina, bitjan dhuwala wiripu‐guḻku' yolŋu'‐yulŋu.” ");
INSERT INTO gnn_vpl VALUES ("JG16_18","008_16_18","JDG","16","18","18","Bala ŋayi Delalayunydja dharaŋarana ŋunhi ŋulinyaramirriyunydja nhanŋu ŋayi yuwalknha wal'ŋu ḻakaraŋala, bala ŋayi dhäwu'na djuy'yurruna ŋuriki buŋgawawuna walalaŋgu, waŋana bitjarrana, “Go marrtjiyana lili walala! Yuwalknha dhuwala ŋayi ḻakaraŋalanydja ŋarraku yana; marŋgina ŋarra liŋguna nhaltjan ŋilimurru yurru ŋanya ganydjarrmiriwyama, djaw'yun ganydjarr nhanukala.” Ga ŋunhi walala buŋgawamirrinydja yolŋu'‐yulŋu marrtjinana lili yana, withiyarana ŋanya gäŋala rrupiyana nhanŋu Delalawu. ");
INSERT INTO gnn_vpl VALUES ("JG16_19","008_16_19","JDG","16","19","19","Bala ŋuriŋi dhäykayu gayŋikuŋalana ŋanya Djämdjinnha makarrlilina nhanukalay ŋayi, bala wiripunydja ḏarramu marrtjina lili, bala gulkthurrunana marwatnha yukurrana ŋanya Djämdjinnha. Ga dhunupa yana ŋunhi ganydjarrnydja nhanukala winya'yurrunana. ");
INSERT INTO gnn_vpl VALUES ("JG16_20","008_16_20","JDG","16","20","20","Bala ŋayi biyapul wäthurruna waŋana bitjarra, “Djämdjin gaŋgathiyana. Dhuwalana Bilitjiyawuynydja marrtji yukurra märranharawuna nhuŋu.” Ga ŋayi Djämdjindja bira'yurruna yanapi ŋayi gaŋgathinya ŋuli waḏutja‐wala dhayaḻa, bitjanna ŋayi ŋuli ŋäthili. Yurru bäyŋuna. Maḻŋ'maranhamina ŋayi ŋanyapinyay ŋayi ŋunhi ŋayinydja yalŋgi'yinana, ganydjarrmiriwnha, balanyarana bitjan wiripu‐guḻku' ḏarramuwurru, bili Garrayyunydja ŋanya liŋguna gonha'yurrunana. ");
INSERT INTO gnn_vpl VALUES ("JG16_21","008_16_21","JDG","16","21","21","Bala walalanydja ŋuriŋi Bilitjiyapuyŋuyunydja ḏarramuwurruyu mulkanana ŋanya, bala bambaykuŋalana dharpuŋala maŋutjina maṉḏanha yana märrma'kuŋalana. Bala walala märraŋalana ŋanya, bala gäŋala ŋunha Gäthalilina wäŋalili. Ḏapmaraŋalanydja walala ŋanya djimuku'yuna raki'yu, bala ŋilitjara ŋanya ḻoḻulilina, ga ŋunhalana ŋayi yukurranha ŋuli djämanydja mirithinyana, ŋathana ŋuli yukurranha yarrwa'yuna birrali'na. ");
INSERT INTO gnn_vpl VALUES ("JG16_22","008_16_22","JDG","16","22","22","Yo, nhinananydja ŋayi yukurrana ŋunhala märr‐weyinŋumirrina, bala marrtjina ŋutharana marwattja biyapul. ");
INSERT INTO gnn_vpl VALUES ("JG16_23","008_16_23","JDG","16","23","23","Ga ŋuliŋurunydja dhurrwaraŋuru bala walala ŋunhi Bilitjiyapuyŋunydja buŋgawamirri yolŋu'‐yulŋu waŋanharamina bitjanminana, “Gul' ŋilimurru yurrum'marama dhuwala yolŋunha walalanha; ŋilimurru yurru ḻuŋ'thun ga märr‐ŋamathinyamirri yukurra waŋganyŋura, buku‐ŋal'yun yukurra yurru ŋilimurruŋgalaŋuwu waŋarrwu Daykungu.” ");
INSERT INTO gnn_vpl VALUES ("JG16_24","008_16_24","JDG","16","24","24","Yuwalkthi walala yurrum'maranhaminanydja, ga bukmak yolŋu'‐yulŋu yukurrana barkparkthurruna märr‐ŋal'yurruna ŋurikiyi waŋarrwu walalaŋgalaŋuwu, waŋananydja walala yukurrana bitjarrana, “Ŋilimurruŋgunydja dhuwala waŋarr Daykundja ganydjarr‐ḏumurru warray, garrwar wal'ŋu biyapul; Ŋayi wekaŋala ŋilimurruŋgu ŋunhi miriŋunha Djämdjinnha ŋilimurruŋgalana goŋlili.” ");
INSERT INTO gnn_vpl VALUES ("JG16_25","008_16_25","JDG","16","25","25","Bena dhika goŋmirriyinana yä‐ä‐ä, wiṯthurrunana walala, ga waŋanharaminana bitjanminana, “Go, ŋilimurru Djämdjinnha gäma dhipala lili, beyarrmakkuma ŋilimurru yurru ŋanya warku'yun.” Yuwalkthi walala gäŋalana ŋanya Djämdjinnha ŋunhimalayina wäŋalili, yurru bambaynhana walala gäŋalanydja lili ŋanya, bala ŋilitjarana, bala nherraranydja ŋunhiwala dhuḏililina guṉḏalili, yurru guṉḏa maṉḏanha ŋunhiyi yukurrana makarr djingaryurrunanydja ŋuriki buṉbuwu. ");
INSERT INTO gnn_vpl VALUES ("JG16_26","008_16_26","JDG","16","26","26","Djämdjindja waŋana gayul, giyalkiyal waŋana ŋunhi gurrmulnha ḏarramunha ŋunhi ŋayi ŋanya yurru marrtji bala waṉa‐gulama, bitjarrana ŋayi waŋananydja, “Nherrala ŋarranha goŋ maṉḏanha dhipala makarrlili bala'lili, ŋarra ḏukṯuk ŋarra yurru mulka,” bitjarra. ");
INSERT INTO gnn_vpl VALUES ("JG16_27","008_16_27","JDG","16","27","27","Yo, buṉbunydja ŋunhiyi ŋutu'na dhikana bathalana wal'ŋu, ga yolŋu'‐yulŋunydja ŋunhimala ḻuŋ'thurruna nhinananydja yukurrana biyapulnha dhaŋaŋnha, bena mala'mirriŋuna yolŋu yukurrana nhinana 3,000 ḏarramuwurrunydja ga dhäykawurrunydja, dhaŋaŋnha biyapulnha miṯtjinydja, ga bukmak ŋunhi Bilitiyapuyŋuwu buŋgawamirri walala, walalanydja bukmak yana ŋunhi nhinananydja yukurrana ŋunhili waŋganyŋura buṉbuŋura, ga bukmakthu walala yukurrana warku'yurrunanydja ŋanya Djämdjinnha. ");
INSERT INTO gnn_vpl VALUES ("JG16_28","008_16_28","JDG","16","28","28","Bala yana ŋayinydja Djämdjindja bukukurru waŋana Godkala bitjarrana, “Garray, ŋarranhanydja guyaŋiya. Ganydjarr ŋarranha wekaŋana biyapul waŋganymirrina, märr ŋarra bumana dhuwala Bilitjiyapuyŋunhanydja bukmakkumana.” ");
INSERT INTO gnn_vpl VALUES ("JG16_29","008_16_29","JDG","16","29","30","Bala ŋayi Djämdjindhu makarrnydja ŋunhi maṉḏanha mulkana baṯ bitjarrana, bala yana ḏur'yurrunana ŋuriŋina ganydjarryuna, ga waŋananydja ŋayi yatjurruna bitjarrana, “Ŋarranydja yurru rakunydhirrina dhuwala manapa ŋanapurru Bilitjiyapuyŋu.” Ḏur'yurrunanydja ŋayi ŋunhi, ḏur' bitjarranydja, bala ŋayinydja marrtjina ŋunhi guṉḏanydja ḏaw'yurrunana buku‐yupthurrunana ŋunhi buṉbunydja warrpam'nha, dhurrtj' bitjarra muŋdhurrunanydja, bala dhä‐muŋdhurrunana ŋunhi yolŋu'‐yulŋunhanydja bukmaknhanydja, ga ŋayipinydja Djämdjindja rakunydhina ŋunhiliyina bili, dhambay ŋunhi yolŋu'‐yulŋu Bilitjiyapuyŋuna. Yo, ŋunhi ŋayi yukurrana walŋaŋga yana nhinana Djämdjin, ŋayi ŋuli bunha yukurranha yolŋu'‐yulŋunha ŋunhi Bilitjiyapuyŋunha guḻku'nhana, ŋunhi walala miriŋu Yitjuralpuyŋuwu. Ga ŋunhi ŋayi rakunydhinana‐wala, ga ŋunhalanydja ŋayi bumara dhaŋaŋnhana biyapulnha wal'ŋu ŋunhiyi miriŋunha. ");
INSERT INTO gnn_vpl VALUES ("JG16_31","008_16_31","JDG","16","31","31","Ga Djämdjingu gurruṯu'mirrinydja walala marrtjina lili, ga märraŋala ŋanya rumbal goŋliliyaŋala, bala djaw'yurruna balayi walalaŋgiyingalana wäŋalili; dhalkaraŋalanydja walala ŋanya ŋunhimalayi dhambay‐manapara bäpa'mirriŋuwala Manawawalana. ");
INSERT INTO gnn_vpl VALUES ("JG21_25","008_21_25","JDG","21","25","25","Yo, Yitjuralpuyŋunydja ŋunhi miṯtji yukurranha ŋuli nhinanha buŋgawamiriw yana, bäyŋu walalaŋgu ŋula giŋdja yolŋu, liŋgu walalanydja ŋunhiyi miṯtji nhanŋuway Godku mala yolŋu. Yurru yakana walala ŋunhi yolŋu'‐yulŋunydja yuwalkkuŋalanydja yukurrana malthurruna Godku Garraywu; bukmaktja yukurrana yolŋu'‐yulŋu marrtjina nhanukiyingalana ŋayi ḏukṯukkurru, ga djämanydja‐wala ŋayi ŋuli nhanukingalay djälyu yana marrtjinya bala. ");
INSERT INTO gnn_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","2","Yo, ŋäthili baman' yolŋu yukurrana nhinana wäŋaŋura Bithiliyim makarrŋuranydja Djudiya yäku Limalik, ga miyalktja nhanŋu yäku Näyumi, ga märrma' ḏarramu maṉḏa yothunydja maṉḏa Mälun yäku ga Djiliyan. Waŋganymirrinydja walala ŋunhiyi gonha'yurrunana walalaŋguwaynydja wäŋa, liŋgu ŋunhiyinydja wäŋa baṉḏanynha räwaknha, ŋathamiriwnha; walala marrtjina barrkumalana wäŋalili mulkurulilina, bala nhinanana walala yukurrana ŋunhiliyinayi mulkuruŋurana wäŋaŋura Mawapnha yäkuŋuranydja yana gurirri märr. ");
INSERT INTO gnn_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","4","Yaka weyindja walala nhinana ŋunhiliyi, bala ŋayi rakunydhinana ŋunhiyi ḏarramunydja, ga dhäŋuru ŋuliŋuruyinydjayi nhanukala gäthu'mirriŋuyu maṉḏathu märraŋala miyalknha maṉḏanha Mawappuyŋunhana wäŋawuynha maṉḏanha, waŋganydja yäku ŋunhiyi Wopa, ga wiripunydja ŋunhi yäku Ruthnha. ");
INSERT INTO gnn_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","Ga nhinananydja walala yukurrana ŋunhiliyi märr‐weyin, bala maṉḏa ŋunhiyi waku'mirriŋunydja maṉḏa Näyumiwu rakunydhinana yuṯa maṉḏa yana, bala ŋayinydja nhinana yukurrana dhuwaymiriwnha, ga bäyŋuna nhanŋu yothuny'tja. ");
INSERT INTO gnn_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","7","Bala ŋayi guyaŋina Näyumiyunydja bala roŋiyinana nhanŋuwaynha ŋayi wäŋa, ŋunhi yukurrana ŋunhiliyinydjayi wäŋaŋura biyapulnha ŋatha ŋuthara, liŋgu Godthu bitjarra ŋunhiyi goŋmirriyaŋala wäŋanha, bala waltjaṉdhu yukurrana dharyurrunana yana biyapul. Bala Näyumiyunydja waŋanana maṉḏanha ŋunhiyi dhäykanha maṉḏanha bitjarrana, “Ŋarranydja yurru dhuwala gananna, bala marrtjina yurru roŋiyirri balayina ŋarrakiyingalana wäŋalili,” bitjarra. Yurru maṉḏanydja waŋana bitjarra warray, “Ŋilinyunydja yurru dhuwala marrtji rrambaŋi ŋilimurru,” bitjarra. Bala walala marrtjinana. ");
INSERT INTO gnn_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Martj‐martjtjurrunana walala marrtjina bala‐a‐a, ga gandarrŋura ŋayi waŋana Näyumi bitjarra, “Way maṉḏa, nhumanydja yurru roŋiyirrina balayi, ga nhiniya ŋunhili bäyma wäŋaŋura nhumalaŋgalayi ga gurruṯu'mirriwala walalaŋgala. Nhumanydja ŋunhi ŋarraku djäka ŋamathaŋala ŋunhiliyi wal'ŋu yana, bala yurru ŋayi Godthunydja nhumalanha goŋmirriyamana yana. ");
INSERT INTO gnn_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Biyapul nhuma yurru märranhamirri, ga nhina nhuma yurru yukurra djulŋithirri ŋunhiliyi nhumalaŋgala wäŋaŋura.” Bala ŋayi Näyumiyunydja dhurrwaraŋuru ŋuliŋuruyinydja wälkuŋalana maṉḏanha, bala yänguŋalana. Yurru maṉḏanydja ŋunhi yukurrana ŋäthina mirithina warray, ");
INSERT INTO gnn_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","ga waŋana maṉḏa bitjarra, “Yakana ŋilinyu yurru roŋiyirri. Ŋilinyu yurru malthun yana nhuŋu; nhina ŋilimurru yurru rrambaŋi yana ŋunhili nhokala wäŋaŋura.” ");
INSERT INTO gnn_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","13","Ga ŋayinydja Näyuminydja buku‐ḏuwaṯthurruna waŋana maṉḏanha bitjarra, “Buku‐djulŋi maṉḏa, nhuma yurru roŋiyirri yana. Nhäku warray nhuma yurru malthun ŋarrakunydja? Ŋarranydja dhuwala worruŋuna dhäyka, yakana ŋarra yurru bulunydja märrama. Yakana ŋarra yukirri biyapul gäŋu ŋarrakuway yothunha ḏarramunha, märranharawu nhumalaŋgu biyapulŋuwunydja. Ŋarranydja dhuwala wuyurrunana nhumalaŋgu mirithinana. Roŋiyirri yana nhuma yurru balayi nhumalaŋgalay wäŋalili.” ");
INSERT INTO gnn_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Bala maṉḏanydja mukthurruna warray yana ŋäthina yukurrana. Bala ŋayi Wopayunydja wälkuŋalana ŋanya Näyuminhanydja, bala gonha'yurrunana ŋanya, bala marrtjina roŋiyinana balayi nhanukiyingala wäŋalili, yurru ŋayinydja ŋunhi Ruthtja baḏak yana märr‐ḏikṯikthina nhanŋu Näyumiwunydja. ");
INSERT INTO gnn_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Bala ŋayi Näyumi waŋana bitjarrana, “Way, Wopanydja ŋunha liŋgu roŋiyinana, balayi marrtjinana ŋayi nhanukalaynha wäŋalili ga nhanukalaŋuwala waŋarrwala. Ga nhenydja yurru bitjan yana liŋgu marrtji, roŋiyirri nhuma yurru rrambaŋi.” ");
INSERT INTO gnn_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Ga ŋayinydja Ruthtja waŋana buku‐wakmaraŋala bitjarra, “Buku‐djulŋi, yaka nhe ŋarranhanydja djuy'yurra roŋinyamaraŋa. Ŋarranydja yurru dhuwala malthun nhuŋu yana, ga nhina ŋarra yurru ŋunhili nhokala wäŋaŋura. Nhuŋunydja yurru ŋunhi gurruṯu'mirri walala balanyarayi yana gurruṯu'mirriyi ŋarrakunydja, ga nhuŋunydja God yurru ŋarrakunydja God yana. ");
INSERT INTO gnn_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Ŋarranydja yurru nhina ŋunhiliyi mukthunna yana, ga yana liŋgu ga rakunydhirri ŋarra yurru, ga dhalkaramanydja ŋarranha yurru ŋunhiwalayi galki yana nhokala.” ");
INSERT INTO gnn_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Bala ŋayi Näyumiyunydja dharaŋarana, ŋunhi ŋayi Ruthtja liŋguna märr‐nherraṉmina nhanukala Näyumiwalana, bala ŋayi yakana ŋanya biyapulnydja waŋana yänguŋala balayi roŋinyamaraŋalanydja. ");
INSERT INTO gnn_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Bala maṉḏa ŋunhiyi maṉḏa märrmany'tja marrtjinana‐wala‐yana rrambaŋithinana, yana liŋgu‐u‐u ga bunana maṉḏa Näyumiwala wäŋaŋura Bithiliyim yäkuŋura. Walala ŋunhi wäŋawuy ŋurikiy yolŋu'‐yulŋuyunydja nhäŋalana maṉḏanha, bala bitjarrana waŋana, “Yol ŋunhanydja yolŋu? Yuwalk ŋayi ŋunha Näyumi yulŋunydja? . . . wo wiripu ŋunha?” ");
INSERT INTO gnn_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Bala Näyuminydja waŋana bitjarra, “Yaka ŋarranha ḻakaraŋa Näyumi biyaka, liŋgu dhuwaliyinydjayi yäku mayali' bitjan galŋa‐djulŋithinyamirri; ḻakaraŋa ŋarranha yäkunydja ‘Mära’ biyakana, liŋgu dhuwalayinydjayi mayali' yäku ŋayaŋu‐yätjthinyaramirri, liŋgu yuwalk yana ŋarra ŋayaŋu‐yätjthinanydja. ");
INSERT INTO gnn_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Ŋunhi ŋarra ŋäthili gonha'yurruna dhuwala wäŋa, ŋarranydja marrtjina ŋunhi dhaŋaŋmirri yana, ga roŋiyinanydja ŋarra lilinydja dhäparknha nhämiriwnha, liŋgu Garrayyu ŋarrakunydja wekaŋala mari bathala warray.” ");
INSERT INTO gnn_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Yo, ŋunhiyi maṉḏa märrma' roŋiyina ŋunhimalayinydja wäŋalili ŋuriŋina liŋgu waluyu ŋunhi ŋatha‐gulkthunaramirriyuna, bala ŋayi Näyumi nhinanana yukurrana ŋunhiliyi wäŋaŋuranydja, ga ŋunhiyi mulkuru yolŋu Ruth nhinana yukurrana galkina nhanukala Näyumiwalana. ");
INSERT INTO gnn_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Ga ŋunhili wäŋaŋura yolŋu yukurrana nhinana biyapulnha ŋayi ḻukunydja yäku Bawatj, ga gurruṯu'mirrinydja ŋayi ŋunhi Näyumiwalaŋuwu dhuway'mirriŋuwu ŋuriki rakunygu. ");
INSERT INTO gnn_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Waŋganymirri ŋayi Ruth waŋana Näyumiwala bitjarra, “Ŋarranydja yurru dhuwala marrtji, ga wapmarama ŋarra marrtji yurru ŋatha. Malthundja yurru ŋarra marrtji ŋuriki ḏarramuwu ŋunhi ŋayi marrtji yurru gulkthun bala ŋunhiyi ŋatha. Ŋarranydja yurru marrtji, bala wapmaramana bäythinyarawuynha.” Bala Näyuminydja waŋana, “Yo manymak,” bitjarra. ");
INSERT INTO gnn_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Bala ŋayi marrtjinana Ruthtja ŋula yolkalana yana gärullili, bitjarra liŋgu walu‐ŋupara ŋayi djämanydja yukurrana, wapmaraŋala ŋunhiyi ŋathanydja, malthurruna marrtjina ŋuriki djämamirriwu walalaŋgu. Yo, ŋunhiyinydjayi wäŋa ŋathamirrinydja ŋunhi ŋurikiyi ḏarramuwu yäkuwu Bawatjkuna, yurru Ruthtja yaka marŋgi ŋurikiyi. ");
INSERT INTO gnn_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Ga yalalaŋumirriyunydja ŋayipina ŋunhinayi Bawatjnha yäku marrtjina ŋunhimalayi wäŋalili, bala ŋayi waŋana ŋuriki djämamirriwunydja walalaŋgu bitjarra, “Garrayyunydja nhumalanha yurru goŋmirriyama,” ga walalanydja bitjarra yana liŋgu buku‐ruŋinyamaraŋala nhanŋunydja dhäruk. ");
INSERT INTO gnn_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Bala ŋayi Bawatjthu dhä‐wirrka'yurruna ŋunhi djämamirrinhana walalanha, “Yol ŋunhanydja dhäyka?” bitjarra. ");
INSERT INTO gnn_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Ga walalanydja buku‐wakmaraŋala bitjarra, “Ŋunhanydja dhuwala dhäyka mulkuruna ŋurukuynha Mawappuynha wäŋawuy. Ŋunhayinydja yawungu ŋayi marrtjinya lilina, Näyumi maṉḏa yawungu bunanha. ");
INSERT INTO gnn_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Bitjarra liŋgu ŋayi yukurrana ŋunha malthurrunanydja ŋanapurruŋgu, ŋatha marrtjina wapmaraŋala walu‐ŋupara dhuwala, ga djämanydja ŋayi wirrki yana wal'ŋu, ga ŋunhanydja ŋayi dhiyaŋunydja‐wala nhinana yukurra ŋoynha, gurriri yana.” ");
INSERT INTO gnn_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","9","Bala ŋayi Bawatjtja marrtji, bala guwatjmanna ŋanya, ga bitjanna waŋanydja ŋayi Ruthnha, “Way miyalk, bitjan liŋgu nhe yurru yukurra marrtjinydja dhipala, ŋathanydja yurru nhe märrama yukurra dhiyala bitjan liŋgu. Yaka marrtjiya ŋula wiripuŋuwalanydja wäŋalili; galki yana marrtjiyanydja ŋarrakalaŋuwala djämamirriwala walalaŋgala, yaka walala yurru nhuna ŋula yätjkumanydja. Ŋunhi nhe yurru ŋanhdhar