﻿USE sofia;
DROP TABLE IF EXISTS sofia.gngNT_vpl;
CREATE TABLE gngNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES gngNT_vpl WRITE;
INSERT INTO gngNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","*Yesu Kristo ya yaajɛb ya yel ya gbɔnku sɔ nɔ. U là yé *Dafid ya yaabil nɛ, nɛ Dafid mɔ yé *Abraham ya yaabil. ");
INSERT INTO gngNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","*Abraham là maa' *Isaak, nɛ *Isaak mɔ maa' *Sakɔb, *Sakɔb mɔ maa' Suda nin uʼninjiɛb. ");
INSERT INTO gngNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Suda mɔ maa' Farɛs nin Sera. Biʼnaa ya yel si Tamar. Farɛs mɔ maa' Ɛsilɔm, Ɛsilɔm mɔ maa' Alam, ");
INSERT INTO gngNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Alam mɔ maa' Aminadab, Aminadab mɔ maa' Nasɔn, Nasɔn mɔ maa' Salima, ");
INSERT INTO gngNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salima mɔ maa' Bos. Uʼnaa ya yel si Lahab. Bos mɔ maa' Yobɛd. Uʼnaa ya yel si Lut. Yobɛd mɔ maa' Yɛse, ");
INSERT INTO gngNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yɛse mɔ maa' ubɛr *Dafid. *Dafid mɔ maa' Salomɔn. Uʼnaa là yé Yuri ya po nɛ, nɛ *Dafid taa' wɔ ki kuɔn'. ");
INSERT INTO gngNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomɔn mɔ maa' Erobowam, Erobowam mɔ maa' Abiya, Abiya mɔ maa' Asafu, ");
INSERT INTO gngNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asafu mɔ maa' Yosafat, Yosafat mɔ maa' Yolam, Yolam mɔ maa' Osiyas, ");
INSERT INTO gngNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Osiyas mɔ maa' Yowatam, Yowatam mɔ maa' Ahas, Ahas mɔ maa' Esekiyas, ");
INSERT INTO gngNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esekiyas mɔ maa' Manase, Manase mɔ maa' Amos, Amos mɔ maa' Yosiyas, ");
INSERT INTO gngNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosiyas mɔ maa' Yekoniya nin uʼninjiɛb uyo wà Israyɛl yaab ya nɛnnɛndb là tɔn' nin bɛ lituɔl ki cuo' bɛ ki jon' *Babilonn nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Bi cuo' bɛ ki jon' Babilonn ma nnɔ, ni ya puoli bó nɛ Yekoniya maa' Salatiɛl, Salatiɛl mɔ maa' Sorobabɛl, ");
INSERT INTO gngNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Sorobabɛl mɔ maa' Abiyud, Abiyud mɔ maa' Eliyakim, Eliyakim mɔ maa' Asɔ, ");
INSERT INTO gngNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asɔ mɔ maa' Sadɔk, Sadɔk mɔ maa' Akim, Akim mɔ maa' Eliyud, ");
INSERT INTO gngNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliyud mɔ maa' Eleyasaa, Eleyasaa mɔ maa' Matan, Matan mɔ maa' *Sakɔb, ");
INSERT INTO gngNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","*Sakɔb mɔ maa' *Yosɛf, wà yé Mari ya cɛ nnɔ. Mari mɔ maa' *Yesu wà bi yih wɔ *Uwien ya Nigɛndkɛ Kristo nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Kí ñɛ *Abraham kí li ŋmɔŋmɔbe kí tì baa *Dafid, bi là te yaajɛb piik nin binan nɛ. Kí ñɛ *Dafid kí li ŋmɔŋmɔbe kí tì baa uyo wà Israyɛl yaab ya nɛnnɛndb là cuo' bɛ ki jon' Babilonn nnɔ, biʼmɔ là te yaajɛb piik nin binan nɛ. Uyo wà biʼnɛnnɛndb là cuo' bɛ ki jon' Babilonn nnɔ kí li ŋmɔŋmɔbe kí tì baa *Uwien ya Nigɛndkɛ Kristo ya yo, biʼmɔ là te yaajɛb piik nin binan nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Bi maa' Yesu Kristo ma bo sɔ. Bi là pun' uʼnaa Mari ujɛ uba nɛ bi yih wɔ *Yosɛf. Wa laan là kuɔn' wɔ, nɛ *Mifuoñaanm cère' u punbe'. ");
INSERT INTO gngNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Uʼcɛ *Yosɛf yé ugbɛmɔ̀ndaan ma nnɔ, nɛ kí yíe wɔ ń bɔle kí ŋɔre wɔ ŋɔ tigbɛr nnɔ la ñɛ saali. ");
INSERT INTO gngNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","U maaleh nnɔ ma nnɔ, nɛ ki laa' Yonbdaan ya tond uba tidɛknt ni. Utond nnɔ tɔke' wɔ ki ye: «*Yosɛf, *Dafid ya yaabile, la fɛnge kí ye ŋa ń taa aʼpo Mari kí baa aʼden, kimɛ *Mifuoñaanm nɛ cère' u punbe'. ");
INSERT INTO gngNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","U li maa kibujɛbuk, nɛ á yin kɛ̀ *Yesu, kimɛ wɔn nɛ li ñɛn uʼbol yaab biʼbiɛre ni.» ");
INSERT INTO gngNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Nɛn kɛ là tien' ŋɔ Yonbdaan là cère' uʼñɔbonsɔknl len' nà nnɔ, nɛ̀ ń tien nɛ. U là len' ki ye: ");
INSERT INTO gngNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","«Ujɛfaan wà ŋa bɛn jɛ li punbe kí maa kibujɛbuk. Bi li yin kɛ̀ Emaniɛl.» Niʼtingi si: « ‹Uwien te nin tɛ.› » ");
INSERT INTO gngNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Nɛ *Yosɛf fìnde', ki tien' Yonbdaan ya tond tɔke' wɔ ki ye wɔ ń tien nà nnɔ, nɛ ki taa' uʼpo Mari, ");
INSERT INTO gngNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","ka duɔn' nin wɔ haali u tì maa' kibujɛbuk, nɛ u yin' kɛ̀ Yesu. ");
INSERT INTO gngNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Tɔ, bi maa' *Yesu Bɛtelɛm ya du ni nɛ, Sude ya tinfɛnm ni, uyo wà Herod yé ubɛr nnɔ. Bi maa' *Yesu ma nnɔ, nɛ binib bà ŋmɔbe mibɛnm iŋmaabii bo ya biba ñɛn' lɛnpuoli bó ní ki baa' Yerusalɛm, ");
INSERT INTO gngNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","nɛ ki niire' ki ye: «Bi maa' kibuk kà kì yé Sufmbɛ ya bɛr nnɔ te lɛ saan-i? Kimɛ ti laa' kiʼŋmaabil lɛnpuoli bó nɛ ki baa' tí puke kɛ̀.» ");
INSERT INTO gngNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ubɛr Herod nin Yerusalɛm ya nib kɛ cii' tigbɛr nnɔ ma nnɔ, nɛ tù bɛke' bɛ cɛɛn. ");
INSERT INTO gngNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Nɛ u yin' *Sufmbɛ nin *bitɔtuɔrciɛnb nin *Yiko ya wɔnwɔknb kɛ, ki niire' bɛ ki ye bi li maa Uwien ya Nigɛndkɛ Kristo lɛ saan-i? ");
INSERT INTO gngNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Nɛ bi ye: «Bɛtelɛm ya du wà te Sude ya tinfɛnm ni nnɔ ni, kimɛ *Uwien ya ñɔbonsɔknl là kɛle' ki ye Uwien ye: ");
INSERT INTO gngNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‹Sin Bɛtelɛm ya du wà te Sude ya tinfɛnm ni nnɔ, ŋa mɔnbe ki yé dufɛnm Sude ya tinfɛnm ya du kɛ ni, kimɛ ubɛr li ñɛ sin ni nɛ, kí li yé wà li likeh nʼnib Israyɛl yaab.› » ");
INSERT INTO gngNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Nɛn bo nɛ Herod bɔle' ki yin' bibɛnbɛnb nnɔ, ki niire' bɛ liŋmaabil nnɔ cinbe ki puɔ' uyo wà, ");
INSERT INTO gngNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","nɛ ki sɔn' bɛ Bɛtelɛm bó ki ye: «Li joh mɛn kí tì nuun kí bɛnde kibuk nnɔ ya gbɛr mɔnmɔnm. Ni laa' kɛ̀ la, ní liɛbe ní kí lá tɔke nni, nʼmɔ ń jo kí tì puke kɛ̀.» ");
INSERT INTO gngNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","U len' ki gben', nɛ bi siere' ki bure'. Bi joh ma nnɔ nɛ ki laa' liŋmaabil là bi là laa' lɛ̀ lɛnpuoli bó nnɔ, le bɛ usɛn ki tì baa' kibuk nnɔ te nà saan nnɔ, nɛ ki sere' niʼsaan paaki. ");
INSERT INTO gngNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Bi laa' lɛ̀ nnɔ ma nnɔ, nɛ biʼyɛnm sɔnge' ki tì kɛnde'. ");
INSERT INTO gngNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Bi kɔn' iden nnɔ, nɛ ki laa' kibuk nnɔ nin kiʼnaa Mari. Bi gbaan', ki puke' kibuk nnɔ, ki ñɛn' biʼkɔl ni tibonmɔnmɔnt ki de' kɛ̀. Bi de' kɛ̀ miñɔ̀km nin liŋubl liba bi yih lɛ̀ ansan nin mikpɔm miba bi yih mɛ̀ miir. ");
INSERT INTO gngNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ni ya puoli bó nɛ Uwien tɔke' bɛ tidɛknt ni ki ye bi la liɛbe ubɛr Herod bó. Nɛn bo nɛ bi ñɛn' usɛnpaankɛ ki kun'. ");
INSERT INTO gngNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Bi kun' ma nnɔ nɛ *Yosɛf laa' Yonbdaan ya tond uba tidɛknt ni. Nɛ utond nnɔ tɔke' wɔ ki ye: «Fii kí taa kibuk kiɛ nɔ nin kiʼnaa kí sɛn kí jo *Esipt bó, kí tì ń li te niʼbó, kí li gu lidaali là n li tɔke ŋɛ kí ye á liɛbe ní, kimɛ ubɛr Herod li nuun kibuk nnɔ wɔ ń ku kɛ̀.» ");
INSERT INTO gngNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Nɛn saan nɛ Yosɛf fii' ki taa' kibuk nnɔ nin kiʼnaa kuñɔnku ki jon' *Esipt, ");
INSERT INTO gngNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","ki tì te niʼbó haali Herod tì kpo'. Nì tien' ŋɔ Yonbdaan là cère' uʼñɔbonsɔknl len' nà nnɔ nɛ̀ ń tien nɛ. U là ye: «Uwien ye: ‹N yin' nʼbuk kɛ̀ ń ñɛ ní *Esipt ni.› » ");
INSERT INTO gngNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Tɔ, Herod bɛnde' ki ye bibɛnbɛnb nnɔ lɛre' wɔ ma nnɔ, nɛ uʼbenku ni ben' ki gbien', nɛ u cère' uʼsojambɛ ku' Bɛtelɛm ya du nin uʼdugbaan kɛ ya bujɛbumu mùa kɛ ŋmɔbe ibin ile nin mùa ŋa laan baa' ibin ile nnɔ. U là niire' bibɛnbɛnb nnɔ bi cinbe ki laa' liŋmaabil nnɔ uyo wà. Nɛn nɛ cère' u jiɛ' ki kpaan' ibin ile. ");
INSERT INTO gngNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","U ku' mubumu nnɔ ma nnɔ nɛ nì tien' *Uwien ya ñɔbonsɔknl Seremi là len' ma ki ye: ");
INSERT INTO gngNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","«Bi cii' imuɔ bó Lama ya du ni, udaan uba muɔh ikumuɔ, ki kpìɛndeh ki gbiekeh. Lasɛl nɛ muɔh uʼbumu bo, uba ŋa ń fre kí suon wɔ, kimɛ uʼbumu ŋa ji te.» ");
INSERT INTO gngNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Nì tete, nɛ Herod tì kpo'. U kpo' ma nnɔ, nɛ *Yosɛf laa' Yonbdaan ya tond uba tidɛknt ni, *Esipt ni. ");
INSERT INTO gngNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Nɛ u tɔke' wɔ ki ye: «Fii kí taa kibuk nnɔ nin kiʼnaa kí liɛbe Israyɛl ya du bó, kimɛ binib bà là nuunh bɛ ń ku kɛ̀ nnɔ kpo'-a.» ");
INSERT INTO gngNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Nɛ u fii' ki taa' kibuk nnɔ nin kiʼnaa, ki liɛbeh Israyɛl ya du bó. ");
INSERT INTO gngNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","*Yosɛf cii' ubɛr Herod ya bijɛ Akelayus teke' uʼbaa ya bɛl Sude ya tinfɛnm ni. Nɛn bo nɛ u fɛnge', ka yíe wɔ ń baa niʼbó, nɛ Uwien wuɔn' wɔ tidɛknt ni nɛ u bure' Galile ya tinfɛnm bó. ");
INSERT INTO gngNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","U tì baa', nɛ ki kɔ udu uba ni, bi yih wù Nasarɛt. Nì tien' nnɔ ŋɔ *Uwien ya ñɔbonsɔknb là len' nà nnɔ nɛ̀ ń tien nɛ. Bi là len' ki ye: «Bi li yin wɔ Nasarɛt ya du ya nil nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","San wà siih binib Uwien ya ñunm nnɔ baa' uyo uba ki te kupenpelku ni, Sude ya tinfɛnm ni, ki kpaandeh ki teh: ");
INSERT INTO gngNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","«Lèbre mɛn niʼtetem, kimɛ Uwien ya bɛl nɛkn' ní ŋɔ.» ");
INSERT INTO gngNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","*Uwien ya ñɔbonsɔknl Esayi là len' San ya gbɛr ki ye: «Udaan uba te kupenpelku ni ki wuureh ki teh: ‹Tùɔre mɛn Yonbdaan ya sɛn, kí cubn uʼsɛngbɛmu kí de wɔ.› » ");
INSERT INTO gngNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","San là guo liliɛrl là nnɔ, bi taa' ñɔkma ya kobr nɛ ki lon' lɛ̀. U là gbin kugbɔnku ya ningbɛnl nɛ uʼciɛk ni. Uʼjier là si inacu nin tisiir nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Binib ñɛh ní Yerusalɛm nin Sude ya tinfɛnm kɛ nin Sudɛn ya kpenl ya tinfɛnm kɛ ni, ki bàareh uʼsaan, ");
INSERT INTO gngNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ki kpiireh biʼbiɛre, nɛ u siih bɛ Uwien ya ñunm, Sudɛn ya kpenl ni. ");
INSERT INTO gngNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","San laa' *Farisiɛnmbɛ nin Saduseyɛnmbɛ bàareh uʼsaan ki yɛbe ki yíe wɔ ń sìi bɛ Uwien ya ñunm. Nɛ u tɔke' bɛ ki ye: «Iwaalɛb ninbi, ŋmɛ nɛ wuɔn' nɛ ni li tien ma kí ñɛ Uwien ya benpiebe wà we ní nnɔ ni? ");
INSERT INTO gngNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Li sɔnh mɛn itùon yà wɔngeh ki teh ni mɔnbe ki lèbre' niʼtetem, ");
INSERT INTO gngNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","ki la li maaleh niʼyɛnm ni ki teh: ‹Tiʼyaajɛ si *Abraham ma nnɔ, nì dɛ̀kre' nɛ›, kimɛ n tɔkeh nɛ nɛ, Uwien li fre kí cère itɛn yiɛ nɔ ń kpɛnde *Abraham ya yaabii. ");
INSERT INTO gngNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Uwien bonde' liyɛl ŋɔ wɔ ń kpìkre isiin. Isiin yà kɛ ŋa lùonh biimɔnmɔn la, u li gɛ yì kí wiɛ umu ni nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Min taah miñunm nɛ ki siih nɛ Uwien ya ñunm, ki wɔngeh ki teh ni lèbre' niʼtetem. Ama wà li paan nʼpuoli bó ní nnɔ ŋmɔbe mituɔm ki cɛn' nni. Ma kpɛ ń cɛkre uʼtacaan. Wɔn nɛ lá li cère *Mifuoñaanm nin umu ń jiire ní niʼbo. ");
INSERT INTO gngNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","U taa' kiyonyiek wɔ ń tì lende uʼji. U li taa mijibim kí cùɔn ubɔnbuɔn ni, kí taa tifent kí wiɛ umu wà ŋa ń kpiin ni.» ");
INSERT INTO gngNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Tɔ, u ya yo nɛ *Yesu ñɛn' Galile ya tinfɛnm bó ní ki baa' San saan, Sudɛn ya kpenl saan ŋɔ San ń sìi wɔ Uwien ya ñunm. ");
INSERT INTO gngNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","San ŋa tuo', nɛ ki tɔke' wɔ ki ye: «Sin wà bi li sìi min Uwien ya ñunm nnɔ, aʼmɔ ji liɛbe' ki baa' min saan-ii?» ");
INSERT INTO gngNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Nɛ *Yesu ye: «Tuo kí tien nnɔ fɛnfɛnnɔ. Nnɔ nɛ ti li fre kí tien Uwien yíe nà kɛ.» Nɛ San tuo' ki sìi' wɔ Uwien ya ñunm. ");
INSERT INTO gngNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","U sìi' *Yesu ma nnɔ nɛ u ñɛn' miñunm ni i ya tàan bo. Kutaaku yàare', nɛ u laa' *Uwien ya Fuoñaanm jiinh ní ki naan unɛnjel, ki lá kɛ̀le' uʼbo. ");
INSERT INTO gngNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Nɛ uniɛke uba ñɛn' paaki bó ní ki ye: «Nʼbijɛ sɔ, n yíe wɔ, nɛ nʼyɛnm sɔnge uʼbo.» ");
INSERT INTO gngNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","U ya yo nɛ *Mifuoñaanm tuke' *Yesu ki jon' kupenpelku ni ŋɔ usɛnpol ń tì biike wɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","*Yesu lòle' buñɔbu iwien pinan nin tiñɔnt pinan. Ni ya puoli bó nɛ mikònm cuo' wɔ, ");
INSERT INTO gngNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","nɛ *usɛnpol unibiikl baa' uʼsaan, ki lá tɔke' wɔ ki ye: «A yé *Uwien ya Bijɛ la, cère itɛn yiɛ ń kpɛnde kpɔnɔ.» ");
INSERT INTO gngNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Nɛ *Yesu jiin' wɔ ki ye: «Nì kɛle' *Uwien ya gbɔnku ni ki ye: ‹Nil ŋa li fuobe jier baba bo; u li fuobe iñɔbon yà kɛ ñɛh Uwien ya ñɔbu ni nnɔ mɔ bo nɛ.› » ");
INSERT INTO gngNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Nɛ *usɛnpol taa' wɔ ki jon' Uwien ya du Yerusalɛm ni, ki tì duon' wɔ *Uwien ya duku ya paaki lekleki, ");
INSERT INTO gngNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","nɛ ki tɔke' wɔ ki ye: «A yé *Uwien ya Bijɛ la, maabe kí ci tingi, kimɛ nì kɛle' *Uwien ya gbɔnku ni ki ye: ‹Sin bo, Uwien li cère uʼtondb ń guɔre ŋɛ, ŋɔ aʼtaal la mɛ tɛnl.› » ");
INSERT INTO gngNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Nɛ *Yesu ye: «Nì tí kɛle' *Uwien ya gbɔnku ni mɔ ki ye: ‹Ŋa ń biike aʼYonbdaan Uwien.› » ");
INSERT INTO gngNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","*Usɛnpol tí taa' wɔ ki tì don' lijɔfɔfɔkrl liba bo, ki wuɔn' wɔ uŋɛndun ya bɛl kɛ nin iʼfaal, ");
INSERT INTO gngNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","nɛ ki tɔke' wɔ ki ye: «A gbaan' nʼnintuɔli ki puke' nni la, n li taa nɛn kɛ kí de sin nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Nɛ *Yesu ye: «Sin, Satan, siere nʼsaan, kimɛ nì kɛle' *Uwien ya gbɔnku ni ki ye: ‹A li gbaan kí kpiɛke aʼYonbdaan Uwien nɛ, kí li pukeh wɔn baba.› » ");
INSERT INTO gngNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Nɛn saan nɛ *usɛnpol siere' ki dàan' wɔ. Nɛ *Uwien ya tondb baa' ki lá toreh wɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","*Yesu cii' bi cuo' San ki tì pɛkn', nɛ u siere' niʼsaan ki liɛbe' Galile ya tinfɛnm bó. ");
INSERT INTO gngNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","U bure' ki tì baa' Nasarɛt, ki gɛ̀bre' ki tì te Kapɛrnawum ya du ni. Udu nnɔ te miñunciɛnm saan nɛ, Sabulɔn nin Nɛftali ya tinfɛnm ni. ");
INSERT INTO gngNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","U kɛ̀le' niʼsaan ma nnɔ, nɛ nì tien' *Uwien ya ñɔbonsɔknl Esayi là len' ma ki ye: ");
INSERT INTO gngNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«Sabulɔn nin Nɛftali yaabɛ, ninbi bà kɔ ki kpieke Galile ya ñunciɛnm, Sudɛn ya kpenpuol bó nnɔ, mitinfɛnm mà bi yih mɛ̀ bà ŋa yé Sufmbɛ ya tinfɛnm nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Binib bà là te licinñunl ni nnɔ, bi laa' kuwenwenciɛnku. Binib bà mikuum là kpàakeh bɛ, miʼjinjinku yiin biʼbo nnɔ, kuwenwenku wende' biʼbo.» ");
INSERT INTO gngNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kí ñɛ u ya yo kí taa kí li joh, nɛ *Yesu cin' ki kpaandeh ki teh: «Lèbre mɛn niʼtetem, kimɛ Uwien ya bɛl nɛkn' ní ŋɔ.» ");
INSERT INTO gngNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","*Yesu cuonh ki kpàakeh Galile ya ñunciɛnm, nɛ ki laa' ninjiɛb bile, bi te ki wiɛnh bubɛbu. Bi là yé bijɛnbɛb nɛ. Bi yih uba Simɔn, ki baanh wɔ Piɛr, ki yih uʼninjɛ Andre. ");
INSERT INTO gngNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Nɛ u tɔke' bɛ ki ye: «Paan mɛn nʼbo ní, ŋɔ ń cère ní li taakeh binib ki dienh nni.» ");
INSERT INTO gngNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Bi dàan' biʼbàan i ya tàan bo, nɛ ki paan' uʼbo. ");
INSERT INTO gngNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","U jɛnde' waamu, nɛ ki tí laa' ninjiɛb bile mɔ, Sebede ya bijiɛb Saak nin uʼninjɛ San. Bɛn nin biʼbaa Sebede te biʼñɛrbu ni, ki tùɔreh biʼbàan. Nɛ *Yesu yin' bɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Nɛ bi dàan' biʼbaa nin buñɛrbu nnɔ i ya tàan bo, ki paan' uʼbo. ");
INSERT INTO gngNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Nɛ *Yesu cuonh Galile ya tinfɛnm kɛ ni, ki kɔh Sufmbɛ ya táan ya dur ni, ki wɔknh binib Uwien ya gbɛr, ki kpaandeh Uwien ya bɛl ya gbɛmɔnmɔnt, nɛ ki buuh iwìɛn kɛ ya bol. ");
INSERT INTO gngNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Nɛ uʼyel kpienh Siri ya tinfɛnm kɛ ni. Bi tukeh binib bà bun iwìɛn kɛ ya bol ki bàareh uʼsaan nɛ u buuh biʼkɛ. Bɛn si: isɛnpol ŋaake bà nin bà luh libinbil nin bà ya gbɛnɛnt faan'. ");
INSERT INTO gngNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Nɛ inigociɛn ñɛn' ní Galile ya tinfɛnm ni nin mitinfɛnm mà bi yih mɛ̀ Idu Piik nnɔ ni nin Yerusalɛm ni nin Sude ya tinfɛnm ni nin Sudɛn ya kpenpuol bó, nɛ ki paan' uʼbo. ");
INSERT INTO gngNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","*Yesu laa' inigol nnɔ ma nnɔ, nɛ ki don' ki tì kɛ̀le' lijuɔl liba bo. Uʼpanpaankaab taan' uʼsaan, ");
INSERT INTO gngNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","nɛ u cin' ki wɔknh bɛ ki teh: ");
INSERT INTO gngNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«Binib bà ŋmɔbe ijiinyɛnmaale nnɔ, Uwien ya mɔnm te biʼbo, kimɛ *Uwien ya bɛl yé biʼyaal nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Binib bà muɔh nnɔ, Uwien ya mɔnm te biʼbo, kimɛ Uwien li sɔnge biʼyɛnm. ");
INSERT INTO gngNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Binib bà jiindeh biʼba tingi nnɔ, Uwien ya mɔnm te biʼbo, kimɛ uŋɛndun wuu li yé bi ya faal nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Binib bà ya nun mɔ́n bɛ ń li yé binimɔ̀nb nnɔ, Uwien ya mɔnm te biʼbo, kimɛ bi lá li lɛ bi yíe nà. ");
INSERT INTO gngNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Binib bà muɔh biʼtɔb micɛcɛkm nnɔ, Uwien ya mɔnm te biʼbo, kimɛ Uwien li muɔ bɛ micɛcɛkm. ");
INSERT INTO gngNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Binib bà taa' biʼba ki de' Uwien, biʼfɛ̀l bo ŋa ŋmɔbe jɔknt nnɔ, Uwien ya mɔnm te biʼbo, kimɛ bɛn nɛ li lɛ Uwien. ");
INSERT INTO gngNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Binib bà nuunh uyɛnduɔn ya sɛn nnɔ, Uwien ya mɔnm te biʼbo, kimɛ Uwien li yin bɛ uʼbumu. ");
INSERT INTO gngNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Binib bà jinh ijɛnd biʼnimɔ̀nt bo nnɔ, Uwien ya mɔnm te biʼbo, kimɛ bɛn nɛ si Uwien ya bɛl. ");
INSERT INTO gngNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","«Binib sukreh nɛ, ki jɛ̀ndeh nɛ, ki lienh niʼbo iñɔbonbil kɛ ya bol min bo la, Uwien ya mɔnm te niʼbo. ");
INSERT INTO gngNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Li te mɛn uyɛnsɔnge ni, kí li poknh, kimɛ ni li lɛ lisuul là yɛbe paaki bó. Bi là jɛ̀nde' *Uwien ya ñɔbonsɔknb bà là te uyo bo nnɔ mɔ nnɔ nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","«Ninbi nɛ yé uŋɛndun wuu ya yaam. Ama miyaam saa' ka ji ŋmɛ la, niba ŋa te kí ji ń fre kí ŋmaake mɛ̀. Ma ji yé bonn, bi li wule mɛ̀ nɛ, nɛ binib ń li taanh miʼbo ki gɛ̀breh. ");
INSERT INTO gngNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","«Ninbi nɛ yé uŋɛndun wuu ya wenwenku. Udu wà te ligbɛngbɛnl bo ŋa ŋmɔbe bɔlm. ");
INSERT INTO gngNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Unil sɛ' lifrl la, wa ń taa sɛnku kí cubn liʼbo. U li taa lɛ̀ kí tuɔn likpɛnkpɛnl bo nɛ, lɛ̀ ń li wendeh bà kɛ te iden ni. ");
INSERT INTO gngNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Niʼmɔ ya wenwenku ń li wendeh binib ya nun bó, bɛ ń li lɛnh ni teh nà nì mɔn nnɔ, ŋɔ kí pɛ̀ke niʼBaa wà te paaki bó.» ");
INSERT INTO gngNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","«La maaleh mɛn ki teh n baa' ń lá gben *yiko nin Uwien ya ñɔbonsɔknb ya gbɛr nɛ. Ma baa' ń lá gben tù. N baa' ń lá tien tù cinbe ki ye ma bo nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","N tɔkeh nɛ imɔ̀n nɛ, yiko nnɔ uba kpein mɔnɔn ŋa ń juore fɛnm, uʼkɛ lì li tien nɛ. Kutaaku nin kitink li wuɔke kí kpaan ma kɛ la, yiko nnɔ ya gbɛyɔyɔl liba mɔnɔn ŋa ń juore fɛnm. ");
INSERT INTO gngNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Nɛn bo, wà kɛ kɛnde' yiko nnɔ ni uba bo waamu mɔnɔn, ki wɔkn' binib bɛ ń li teh uʼyaam la, u li yé uwaal nɛ Uwien ya bɛl ni. Wà kɛ tuo' *yiko nnɔ, ki wɔkn' binib nnɔ la, u li yé uciɛn nɛ Uwien ya bɛl ni. ");
INSERT INTO gngNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","N tɔkeh nɛ nɛ, niʼnimɔ̀nt ŋa cɛn' *Yiko ya wɔnwɔknb nin *Farisiɛnmbɛ yaar la, na lì li kɔ *Uwien ya bɛl ni.» ");
INSERT INTO gngNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","«Ni cii' bi là tɔke' uyo bo yaab ki ye: ‹La ku nil. Unil ku' uʼtɔ la, bi li bu wɔ tibuur nɛ.› ");
INSERT INTO gngNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ama min tɔkeh nɛ ki teh wà kɛ ya benku ni ben' uʼtɔ bo la, bi li bu wɔ tibuur nɛ. Wà kɛ tɔke' uʼtɔ ki ye u yé fɛnm la, tibuur ya ciɛnb li bu wɔ tibuur nɛ. Wà kɛ tɔke' uʼtɔ ki ye u yé uwaar la, u kpɛ wɔ ń kɔ umu wà ŋa ń kpiin ni nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Nɛn bo, a joh á pu Uwien mipum uʼponpuol bo, ki tì tiɛre' ki ye sin nin aʼtɔ ŋmɔbe mimaam la, ");
INSERT INTO gngNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","taa aʼpum nnɔ kí ble liʼsaan, kí jo ní tì gben mɛ̀ kí yaan, kí liɛbe ní kí lá pu Uwien aʼpum nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","«Sin nin unil ŋmɔbe mimaam nɛ u tuke mɛ̀ ki joh tibuur la, taan nin wɔ buñɔbu tonm, uyo wà ni laan te usɛn ni. Nnɔ ŋa ñí la, u li taa ŋɛ kí tì ŋukn tibuur ya ciɛn, uʼmɔ ń taa ŋɛ kí ŋukn lipɛkl ya ciɛn wɔ ń pɛkn ŋɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","N tɔkeh ŋɛ imɔ̀n nɛ, ŋa tì pɛ̀n' ki gben' tibuur ya like la, ŋa ń ñɛ len.» ");
INSERT INTO gngNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","«Ni cii' bi là tɔke' uyo bo yaab ki ye: ‹La teh naŋmaal.› ");
INSERT INTO gngNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ama min tɔkeh nɛ ki teh wà kɛ liike' upii ŋɔ uʼmɛnku kɔn' uʼni la, u duɔn' nin upii nnɔ ŋɔ uʼfɛ̀l ni. ");
INSERT INTO gngNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Nɛn bo, aʼnɔjienunbu nɛ cèreh a biih la, lìkre bù kí wiɛ kí jɛnde aʼba saan. Aʼgbɛnɛnt ya niba bó juore' fɛnm la, nì tu nin aʼgbɛnɛnt kɛ ń kɔ umu wà ŋa ń kpiin ni. ");
INSERT INTO gngNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Aʼnɔjie nɛ cèreh a biih la, cere wù kí wiɛ kí jɛnde aʼba saan. Aʼgbɛnɛnt ya niba bó juore' fɛnm la, nì tu nin aʼgbɛnɛnt kɛ ń kɔ umu wà ŋa ń kpiin ni.» ");
INSERT INTO gngNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","«Bi tí là liɛbe' ki ye: ‹Unil wiɛ' uʼpo la, wɔ ń kɛle kugbɔnku kí de wɔ, kí wuɔn kí ye u wiɛ' wɔ nɛ.› ");
INSERT INTO gngNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ama min tɔkeh nɛ ki teh ujɛ wà kɛ ya po ŋa tien' naŋmaal ŋɔ u wiɛ' wɔ la, u sureh upii nnɔ wɔ ń kpɛnde unaŋmaa nɛ. Ujɛ wà kuɔn' bi wiɛ' upii wà la, u tien' linaŋmaal nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","«Ni tí cii' bi là tɔke' uyo bo yaab ki ye: ‹La pole tonnɛnku bo. A pole' Uwien la, á tien a pole' ki ye bà.› ");
INSERT INTO gngNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ama min tɔkeh nɛ ki teh ni la lì ń pole. Ni la pole taaku, kimɛ kutaaku yé Uwien ya bɛrbiɛk nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ni la pole tink mɔ, kimɛ kitink yé Uwien ya tàan paandeh nà bo nɛ. Ni la pole Yerusalɛm mɔ, kimɛ Yerusalɛm yé Uwien Ubɛrciɛn ya du nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","La pole aʼyul, kimɛ ŋa ń fre kí cère aʼyurku kuba mɔnɔn ń kpɛnde kuyupenpienku, ka ń fre kí cère kù ń kpɛnde kuyubɔnbɔnku mɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Niʼlenm ni, nì yé imɔ̀n la, ní ye ‹imɔ̀n›. Nì tí yé kutonnɛnku la, ní ye nì yé ‹kutonnɛnku›. Ni ji pukn' nà kɛ la, nì yé usɛnpol, ubiɛrɔ yaann nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","«Ni tí cii' bi là tɔke' uyo bo yaab ki ye: ‹Unil fiɛ' uʼtɔ ya nunbu la, bɛ ń fiɛ uʼmɔ yaabu. Unil fekre' uʼtɔ ya ñinl la, bɛ ń fekre uʼmɔ yaal.› ");
INSERT INTO gngNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ama min tɔkeh nɛ ki teh unil tien' ŋɛ mibiɛrm la, la jiin wɔ biɛrm. Unil kpɔ̀be' aʼnɔjiekpiɛnku la, pekre aʼnɔgɛnkpiɛnku mɔ kí de wɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Unil taa' ŋɛ ki jon' tibuur wɔ ń tì fie aʼliɛrwawaal la, cɛ̀be wɔ aʼliɛrgbenku mɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Unil wɔbn' ŋɛ ki ye á tuke uʼtukl kí pìɛre wɔ kɔnsini uba la, pìɛre wɔ kɔnsini ule. ");
INSERT INTO gngNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Wà miɛ' ŋɛ nibonn la, pu wɔ. Wà mɔ yíe á kpende wɔ nibonn la, la sikre wɔ buɔn.» ");
INSERT INTO gngNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","«Ni tí cii' bi là tɔke' uyo bo yaab ki ye: ‹Li yíe wà yíe ŋɛ, kí li nɛn wà nɛn ŋɛ.› ");
INSERT INTO gngNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ama min tɔkeh nɛ ki teh: ‹Li yíe mɛn niʼnɛnnɛndb, kí li kàareh ki dienh binib bà jɛ̀ndeh nɛ, ");
INSERT INTO gngNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ŋɔ kí li yé niʼBaa wà te paaki bó ya bumu, kimɛ wɔn nɛ cèreh uʼwien puɔreh ki wendeh bibiɛrdɛnb nin binimɔ̀nb, ki cèreh utaa mɔ niih ki dienh binimɔ̀nb nin bibiɛrdɛnb.› ");
INSERT INTO gngNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ni yíe bà yíe nɛ baba la, ni li lɛ li lɛ suul ba? Bilɛnpotekb mɔnɔn ŋa teh nnɔ-ɔɔ? ");
INSERT INTO gngNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ni fuondeh niʼyaab baba la, bɛ lèbre'? Bà ŋa yé Sufmbɛ mɔnɔn ŋa teh nnɔ-ɔɔ? ");
INSERT INTO gngNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Nɛn bo, ninbi li te mɛn mɔnmɔnm kí tì gben tɛn niʼBaa wà te paaki bó te ma bo.» ");
INSERT INTO gngNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","«Li bɛn mɛn, ki la teh nimɔ̀nt binib ya nun bó ki nuunh bɛ ń lɛ kí pɛ̀ke nɛ. Ni teh nnɔ la, na ń lɛ suul niʼBaa wà te paaki bó saan. ");
INSERT INTO gngNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","«A pun' ucɛcɛkdaan nibonn la, la cuonh ki kpaandeh niʼkɛ saan tɛn iñuɔn ilele ya nib teh ma itáan ya dur ni nin isɛnjɛ ni ŋɔ binib ń lɛ kí pɛ̀ke bɛ. N tɔkeh nɛ imɔ̀n nɛ, bi laa' biʼsuul ŋɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","A pun' ucɛcɛkdaan nibonn la, la cère aʼnɔgɛn ń li bɛn aʼnɔjie de' nà. ");
INSERT INTO gngNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Pu wɔ lididikl bo. AʼBaa wà lɛnh a teh nà lididikl bo nnɔ nɛ li su ŋɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","«Ni kàareh la, ni la li te tɛn iñuɔn ilele ya nib. Bi yíe bɛ ń li sieh itáan ya dur ni nin isɛnnaan ni nɛ ki kàareh ŋɔ binib ń li lɛnh bɛ. N tɔkeh nɛ imɔ̀n nɛ, bi laa' biʼsuul ŋɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Sin wɔn, a tì ń yíe á kàare la, kɔ aʼduku ni, kí pìin, kí kàare aʼBaa wà ŋa lɛnh wɔ nnɔ. AʼBaa wà lɛnh a teh nà lididikl bo nnɔ nɛ li su ŋɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","«Ni kàareh la, ni la li kàareh ki ñɔbleh ki tɛkreh tɛn bà ŋa pɛ Uwien ya sɛn bo. Bi maaleh ki teh bi lienh ki gbiekeh nɛ la, Uwien li cenge biʼbó. ");
INSERT INTO gngNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","La teh mɛn tɛn bɛn, kimɛ niʼBaa bɛn nà wiɛbe nɛ kí lɛ na laan miɛ' wɔ nɛ̀. ");
INSERT INTO gngNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ní li kàareh ki teh nɔ: ‹TiʼBaa wà te paaki bó, cère binib kɛ ń li boh aʼyel, ");
INSERT INTO gngNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Cère aʼbɛl ń baa ní, cère aʼyíem ń tien tingi ni tɛn paaki bó. ");
INSERT INTO gngNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","De tɛ dinnɔ ya wentunl ya jier, ");
INSERT INTO gngNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","fère tɛ tiʼbiil, tɛn tiʼmɔ fèreh ma bà biih tɛ nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","La cère tí lu mibiikm ni. Ama fie tɛ usɛnpol ubiɛrɔ ya nuɔ ni. Kimɛ sin nɛ si libɛl nin ufaa nin ukpiɛke uyo wà ŋa ŋmɔbe gbenm.› ");
INSERT INTO gngNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","«Kimɛ ni fèreh binib biʼbiil la, niʼBaa wà te paaki bó mɔ li fère nɛ niʼyaal. ");
INSERT INTO gngNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ama na fèreh binib biʼbiil la, niʼBaa mɔ ŋa ń fère nɛ niʼyaal.» ");
INSERT INTO gngNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","«Ni lòle' buñɔbu la, ni la li saah niʼnun bó tɛn iñuɔn ilele ya nib. Bi saah biʼnun bó ŋɔ binib ń bɛnde kí ye bi lùo buñɔbu nɛ. N tɔkeh nɛ imɔ̀n nɛ, bi laa' biʼsuul ŋɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Sin wɔn, a lòle' buñɔbu la, fɛnde aʼnun bó, kí luobe aʼyur mikpɔm, ");
INSERT INTO gngNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ŋɔ binib la bɛnde kí ye a lùo ñɔbu. Ama aʼBaa wà te aʼsaan lididikl bo nɛ bɛn. Wɔn wà lɛnh a teh nà lididikl bo nnɔ nɛ li su ŋɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","«La li nuunh mɛn ní lɛ lifaal kí gbien uŋɛndun wuu ni. Kimɛ likuotuul nin uyonyon li saa lɛ̀. Nɛ Binasub mɔ li lɔnbe kí kɔ kí suu lɛ̀. ");
INSERT INTO gngNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ama li nuunh mɛn lifaal là yɛbe paaki bó. Nɛn bó kuotuul ŋa ń mɔ lɛ̀, nasu mɔ ŋa ń lɔnbe kí kɔ kí suu lɛ̀. ");
INSERT INTO gngNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Kimɛ aʼfaal te nà saan la, aʼfɛ̀l mɔ dɔ nɛn saan nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","«Bununbu yé tigbɛnɛnt ya frl nɛ. Aʼnun mɔn la, aʼgbɛnɛnt kɛ te kuwenwenku ni nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ama aʼnun ŋa mɔn la, aʼgbɛnɛnt kɛ te licinñunl ni nɛ. Aʼnun yà cèreh a te kuwenwenku ni nnɔ ŋa ji lɛnh la, a te licinñunl là ni nnɔ ji li te milɛ bo?» ");
INSERT INTO gngNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","«Nil ŋa ń fre kí li pɛ cɛnbaambɛ bile bo. U li nɛn uba nɛ, kí li yíe utɔ. U li se uba ya ciɛk bó nɛ, kí li likeh utɔ fɛnm. Na ń fre kí li pɛ Uwien bo ki liɛbe' ki pɛ ilike mɔ bo.» ");
INSERT INTO gngNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","«Nɛn bo nɛ n tɔkeh nɛ ki teh ni la cère nɛ̀ ń li wiɛbe nɛ ni li tien ma kí li fuobe bo, ki la li maaleh ki teh: ‹Ti li ji ba?› Ki la cère nɛ ń li wiɛbe nɛ niʼgbɛnɛnt bo, ki la li maaleh ki teh: ‹Ti li gole ba?› Limiɛl ŋa cɛn' tijier-ii? Tigbɛnɛnt mɔ ŋa cɛn' tiwɛngolkaar-ii? ");
INSERT INTO gngNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Liike mɛn inuɔn yà laanh paaki bó te ma bo. Ya koh, ka ceh ki cɔngeh bɔnbuɔn ni. Ama niʼBaa wà te paaki bó nɛ jindeh yì. Na nín cɛn' yì pelpel-ii? ");
INSERT INTO gngNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Niʼni ŋmɛ nɛ uʼnìinm ni, u li fre kí fɔkn uʼmiɛl waamu mɔnɔn kí pukn-i? ");
INSERT INTO gngNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","«Bɛ bo nɛ ni cèreh nì wiɛbe nɛ tiwɛngolkaar bo? Maale mɛn kí liike kumuɔku ni ya sir puh ma bo, ta sɔnh tuonl, ka loh kpɛlcɛr. ");
INSERT INTO gngNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ama n tɔkeh nɛ nɛ, ubɛr Salomɔn nin uʼfàaciɛnl kɛ, wa là gole' kpɛlcɛr tù mɔn ki baa' mipuum nnɔ ya miba mɔnɔn. ");
INSERT INTO gngNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Uwien cèreh timɔsir tà te dinnɔ kubaaku ni, ki li wun teke umu puh mipúmɔnmɔnm la, bɛ li cère wa ń tien ninbi binib mimɔnm kí cɛn timuɔr-i? Niʼtekjim nɛ pɔre' nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Nɛn bo, ni la cère nɛ̀ ń li wiɛbe nɛ, ki la li maaleh ki teh: ‹Ti li ji ba? Ti li ñu ba? Ti li gole ba?› ");
INSERT INTO gngNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Kimɛ bà ŋa pɛ Uwien ya sɛn bo ya nun nɛ mɔ́n tu ya bont kɛ bo. NiʼBaa wà te paaki bó bɛn ki ye ni ciɛke tibont nnɔ kɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Laan li nuunh mɛn *Uwien ya bɛl, kí li teh Uwien yíe nà, u li taa tibont nnɔ kɛ kí pukn nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Nɛn bo, la cère mɛn nɛ̀ ń li wiɛbe nɛ wenli wà we ní nɔ bo. Wenli nɛ ni li wun maale wenli ya gbɛr bo. Lidaali là kɛ nin liʼjɛnd nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","«La biindeh mɛn nib ŋɔ Uwien mɔ la biin nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ni biindeh binib ma bo la, Uwien mɔ li biin nɛ nnɔ nɛ. Ni taah nà ki bìkreh tibont ki dienh binitɔb nnɔ Uwien mɔ li taa nɛn nɛ kí biike kí de nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Bɛ tien' a lɛnh kumuɔku kùa te aʼtɔ ya nunbu ni, ka ji lɛnh jaantɛlkɛ wà puɔn aʼyaabu ni? ");
INSERT INTO gngNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","A li tien mila kí tɔke aʼtɔ kí ye: ‹Cère ń ñɛn kumuɔku kùa te aʼnunbu ni nɔ›, ŋɔ jaantɛlkɛ puɔn aʼyaabu ni? ");
INSERT INTO gngNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Sin iñuɔn ilele ya nilɔ, kpiɛ kí ñɛn jaantɛlkɛ wà puɔn aʼnunbu ni nnɔ, kí li lɛnh mɔnmɔnm, kí yaan kí fre kí ñɛn kumuɔku aʼtɔ yaabu ni. ");
INSERT INTO gngNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","«La taah mɛn tibont tà yé Uwien yaar ki dienh isɛngbɛle, ŋɔ ì la lá liɛbe kí kɛ̀kɛ̀re nɛ. La taah mɛn niʼlaan ki dienh fangambɛ, ŋɔ bi la tɛtɛ iʼbo.» ");
INSERT INTO gngNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","«Li miɛh mɛn, bi li pu nɛ; li nuunh mɛn, ni li lɛ; li ñih mɛn kunagɛnku, bi li pìire. ");
INSERT INTO gngNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Kimɛ wà kɛ miɛh la, bi punh wɔ nɛ. Wà kɛ nuunh la, u lɛnh nɛ. Wà kɛ mɔ ñih kunagɛnku la, bi pìireh nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Niʼni ŋmɛ ya buk miɛ' wɔ kpɔnɔ la, u li de kɛ̀ litɛnl-i? ");
INSERT INTO gngNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Bii kì miɛ' wɔ ujɛn la, u li de kɛ̀ uwɛ? ");
INSERT INTO gngNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ninbi bibiɛrdɛnb, ni bɛn ki dienh niʼbumu nà mɔn la, bɛ li tien niʼBaa wà te paaki bó ŋa ń cère binib bà miɛh wɔ nà mɔn nnɔ bɛ ń lɛ nɛ̀! ");
INSERT INTO gngNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","«Nɛn bo, ni yíe binib ń li teh nɛ nà kɛ nnɔ, niʼmɔ ń li teh bɛ nɛn. *Yiko ya gbɔnku nin Uwien ya ñɔbonsɔknb wɔknh nà kɛ nnɔ ya tingi nínɔ.» ");
INSERT INTO gngNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","«Ñɛ mɛn bunañɔbu bùa wiɛbe kí kɔ, kimɛ bunañɔbu bùa piɛ nin usɛn wà piɛ jondeh tɛ fɛnm bó nɛ. Binib kpìendeh usɛn wà piɛ nɛ ki yɛbe. ");
INSERT INTO gngNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Bunañɔbu bùa nin usɛn wà joh limiɛl bó nnɔ ŋa piɛ. Binib bà nuunh ki lɛnh u ya sɛn ŋa yɛbe.» ");
INSERT INTO gngNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","«Liike mɛn niʼyul bo nin bitonnɛnñɔbonsɔknb. Bi bàareh niʼsaan ki te suoo tɛn ipe nɛ, ama ki nín ji yé ikɛ̀r ki bre. ");
INSERT INTO gngNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Biʼtùon nɛ li cère ní bɛnde bi yé binib bà ya bol. Ba pɔ̀h cɛcɛ bɛnɛnk bo. Ka pɔ̀h kɛnkɛn mɔ konkonbu bo. ");
INSERT INTO gngNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Nɛn bo, busumɔnmɔnbu kɛ lùonh ibii yà mɔn nɛ. Busubu bùa ŋa mɔn mɔ lùonh ibii yà ŋa mɔn nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Busumɔnmɔnbu ŋa ń fre kí lùon ibii yà ŋa mɔn. Busubu bùa ŋa mɔn mɔ ŋa ń fre kí lùon ibii yà mɔn. ");
INSERT INTO gngNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Busubu bùa kɛ ŋa lùonh ibii yà mɔn la, bi li gɛ bù kí wiɛ umu ni nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Nɛn bo, binib ya tùon nɛ li cère ní bɛnde bi yé binib bà ya bol.» ");
INSERT INTO gngNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","«Na yé wà kɛ yih nni ki teh: ‹Yonbdaan, Yonbdaan›, nɛ li kɔ Uwien ya bɛl ni. Ama wà teh nʼBaa wà te paaki bó yíe ma bo, nɛ li kɔ uʼbɛl ni. ");
INSERT INTO gngNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Lidaali là Uwien li bu binib tibuur nnɔ, binib bà yɛbe li tɔke nni kí ye: ‹Yonbdaan, Yonbdaan, a ya yel bo ŋa ñí nɛ ti sɔkn' Uwien ya gbɛr, ki ŋɔre' isɛnpol binib saan, ki tien' miyɔkm ya bont-ii?› ");
INSERT INTO gngNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Nɛ n li tɔke bɛ kí ye: ‹Jɛnde mɛn nʼsaan, ma bɛn nɛ fiebu. Ni yé bà teh nà bre nɛ.› » ");
INSERT INTO gngNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","«Tɔ, wà kɛ ciih nʼgbɛr tuu nɔ, ki teh tù ye ma la, u naan ujɛ wà ŋmɔbe miyɛnfuom, ki mɛn' uʼduku kutɛntiɛku bo nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Utaa nii', miwuɔm kɔn', ki puube' ki yile' kuduku nnɔ bo, kutafaaku mɔ fii' ki lɛkn' kuʼbo. Kù se kutɛntiɛku bo ma nnɔ, nɛ ka lu'. ");
INSERT INTO gngNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","«Ama wà kɛ ciih nʼgbɛr tuu nɔ, ka teh tù ye ma la, u naan ujɛjɔr wà mɛn' uʼduku litɛngbil bo nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Utaa nii', miwuɔm kɔn', ki puube' ki yile' kuduku nnɔ bo, kutafaaku mɔ fii' ki lɛkn' kuʼbo, nɛ kù lu' kpɛlkpɛl.» ");
INSERT INTO gngNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","*Yesu wɔkn' ki tì gben', nɛ u wɔkn' linigol nnɔ iñɔbon yà nnɔ cuo' bɛ miyɔkm cɛɛn. ");
INSERT INTO gngNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Kimɛ wa wɔknh bɛ tɛn *Yiko ya wɔnwɔknb wɔknh ma bo, u wɔknh bɛ tɛn unil wà du u wɔknh nà nnɔ bo nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","*Yesu jiinh lijuɔl bo, nɛ linigociɛnl pɛ uʼbo. ");
INSERT INTO gngNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Tɔ, ujend uba baa' ki lá gbaan' uʼnintuɔli, nɛ ki tɔke' wɔ ki ye: «Yonbdaan, a yíe la, a li fre kí cère ń lùore.» ");
INSERT INTO gngNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Nɛ *Yesu tɛnde' uʼnuɔ ki mɛ' wɔ, nɛ ki ye: «N yíe, lùore.» Nɛ u pɔk ki lùore' i ya tàan bo. ");
INSERT INTO gngNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Nɛ *Yesu ye: «Liike aʼyul bo ki la tɔke nil, ama jo kí tì lɛ utɔtuɔrkɛ, kí tien lituɔrl tɛn Moyis là ye bɛ ń li teh ma bo. Nɛn nɛ li wuɔn kí ye a lùore'.» ");
INSERT INTO gngNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","*Yesu cuonh ki tì kɔh Kapɛrnawum ya du ni uyo wà nnɔ, nɛ sojambɛ kobk ya ciɛn uba baa' uʼsaan ki gbáan' wɔ ki ye: ");
INSERT INTO gngNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","«Yonbdaan, nʼtonsɔnl nɛ wɔbe' ki dɔ iden, ki wɔlndeh cɛɛn.» ");
INSERT INTO gngNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Nɛ *Yesu ye: «Min li jo kí tì buu wɔ.» ");
INSERT INTO gngNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Nɛ u tɔke' *Yesu ki ye: «O, Yonbdaan, ma kpɛ á baa kí kɔ nʼden. A lì len' mɔnɔn ki ye ‹Faake› la, nʼtonsɔnl nnɔ li faake nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Kimɛ min mɔnɔn ŋmɔbe binib bà yé nin nni biciɛnb, nɛ ki mɔ yé sojambɛ biba ya ciɛn. N tɔke' uba ki ye: ‹Li joh› la, u joh nɛ, n tɔke' utɔ ki ye ‹Dɛn› la, u bàareh nɛ. N tí tɔke' nʼtonsɔnl ki ye wɔ ń tien nà la, u teh nɛn nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","*Yesu cii' uʼñɔbon ma nnɔ, nɛ nì cuo' wɔ miyɔkm, nɛ u tɔke' binib bà pɛ uʼbo nnɔ ki ye: «N tɔkeh nɛ imɔ̀n nɛ, ma laan laa' nil wà ŋmɔbe miɛ ya tekjim Israyɛl yaab ni mɔnɔn. ");
INSERT INTO gngNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","N tɔkeh nɛ nɛ, binib yɛbe ki li ñɛ lɛnpuoli bó ní nin nintuɔli bó ní, kí lá kɛ̀le kí ji *Abraham nin *Isaak nin Sakɔb saan tijier *Uwien ya bɛl ni. ");
INSERT INTO gngNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ama bi li ñɛn bà bi li si *Uwien ya bɛl nnɔ kí wiɛ saali licinñunl ni. Nɛn saan nɛ bi li te ki muɔh, ki ŋmɔnh iñɔgbɛn.» ");
INSERT INTO gngNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","*Yesu tɔke' sojambɛ ya ciɛn nnɔ ki ye: «Li kunh. Nɛ̀ ń tien' ŋɛ tɛn a teke' nni ki jin' ma bo.» Nɛ uciɛn nnɔ ya tonsɔnl faake' i ya tàan bo. ");
INSERT INTO gngNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","*Yesu jon' Piɛr den, nɛ ki laa' Piɛr ya cɔbnaa dɔ ki bun, uʼgbɛnɛnt ton. ");
INSERT INTO gngNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","*Yesu mɛ' uʼnuɔ, nɛ uʼgbɛnɛnt sɔnge'. Nɛn saan nɛ u fii' ki cɛ̀nde' wɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Niʼdaali ya tajuɔku, nɛ bi tuke' binib ligol ki baa' Yesu saan isɛnpol ŋaake bɛ. *Yesu ŋɔre' isɛnpol nnɔ nin uʼñɔmaam, nɛ ki cère' bà kɛ bun nnɔ faake'. ");
INSERT INTO gngNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","U tien' nnɔ ŋɔ uñɔbonsɔknl Esayi là len' nà nnɔ nɛ̀ ń tien nɛ. U là len' ki ye: «Wɔn nɛ ñɛn' tiʼjiint, ki teke' tiʼwìɛn kɛ ki tuke'.» ");
INSERT INTO gngNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Tɔ, *Yesu laa' linigol guɔn' wɔ, nɛ u tɔke' uʼpanpaankaab ki ye: «Cère mɛn tí puore kí jo miñunciɛnm ya gbaatɔl bó.» ");
INSERT INTO gngNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Yiko ya wɔnwɔknl uba baa' uʼsaan, nɛ ki tɔke' wɔ ki ye: «Cɛnbaa, a joh nà bó kɛ la, n li pɛ aʼbo nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Nɛ *Yesu tɔke' wɔ ki ye: «Iŋɛk ŋmɔbe ifɛle, inuɔn mɔ ŋmɔbe titer, ama *Unil ya Bijɛ wɔn ŋa ŋmɔbe u li kpɔ̀kn nà saan yul.» ");
INSERT INTO gngNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Nɛ uʼpanpaankaab ya uba mɔ tɔke' wɔ ki ye: «Yonbdaan, cɛ̀be nni ń jo kí tì sube nʼbaa ŋɔ kí liɛbe ní kí paan aʼbo.» ");
INSERT INTO gngNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Nɛ *Yesu tɔke' wɔ ki ye: «Li pɛ nʼbo, kí cère bitɛnkpiib ń li subeh biʼtɔb.» ");
INSERT INTO gngNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","*Yesu kɔn' buñɛrbu nɛ uʼpanpaankaab mɔ paan' uʼbo. ");
INSERT INTO gngNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Bi joh ma nnɔ nɛ kutafaabiiku kuba fii' miñunm bo ki cèreh iñungbegbel fih ki yildeh buñɛrbu nnɔ bo. Nin nɛn kɛ ŋɔ *Yesu wɔn dɔ nɛ ki gɔh. ");
INSERT INTO gngNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Nɛ bi baa' ki lá fìnde' wɔ, ki tɔke' wɔ ki ye: «Yonbdaan, ŋmiɛn tɛ, ti benh tí luo nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Nɛ u ye: «Bɛ tien' ni sɛn' bujɛwaanbu? Niʼtekjim nɛ pɔre' nɛ.» Nɛn saan nɛ u fii' ki tiɛn' kutafaaku nin miñunm bo. Nɛ kutafaaku nin miñunm kɛ ŋmile' cim. ");
INSERT INTO gngNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Nì cuo' binib miyɔkm, nɛ bi niireh ki teh: «U yé bɛ ya nitunbu sɔ, kutafaaku nin miñunm kɛ tì boh wɔ?» ");
INSERT INTO gngNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Bi tì baa' miñunciɛnm ya gbaatɔl, Gadara yaab ya tinfɛnm ni, nɛ binib bile ñɛn' ikul bó ní ki cende' wɔ. Isɛnpol nɛ là ŋaake bɛ. Bi là bre cɛɛn nɛ, nɛ nib ŋa kaabe ki ñɛh niʼbó ya sɛn. ");
INSERT INTO gngNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Bi laa' *Yesu ma nnɔ, nɛ ki wuureh i ya tàan bo ki teh: «Uwien ya Bijɛ, tinbi nin sin tu lɛ nɛ? A baa' á lá jɛ̀nde tɛ nɛ uyo ŋa laan baa'-aa!» ");
INSERT INTO gngNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Tɔ, fangambɛ biba mɔ là te ka fɔke nin niʼsaan ki yɛbe ka dindin, bi kpaah bɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Nɛ isɛnpol nnɔ gbáan' *Yesu ki ye: «A ŋɔre' tɛ binib biɛ saan la, á cɛ̀be tɛ tí jo kí tì kɔ fangambɛ biɛ nɔ.» ");
INSERT INTO gngNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Nɛ *Yesu ye: «Li joh mɛn.» Nɛ ì siere' binib nnɔ saan, ki tì kɔn' fangambɛ nnɔ. I ya tàan bo, nɛ fangambɛ nnɔ kɛ sɛn' ki tinde' ligbɛngbɛnl, ki tì lu' miñunm ni ki luo'. ");
INSERT INTO gngNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Bà kpaah fangambɛ nnɔ sɛn' ki jon' udu bó, ki tì tɔke' binib *Yesu cère' bijɛb nnɔ faake' ma bo nin nà kɛ tien'. ");
INSERT INTO gngNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Udu nnɔ ya nib kɛ ñɛn' ki lá tuobe' *Yesu usɛn ni, nɛ ki gbáan' wɔ ki ye wɔ ń ñɛ biʼtinfɛnm ni. ");
INSERT INTO gngNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","*Yesu liɛbe' ki kɔn' buñɛrbu ki tí puore' miñunciɛnm ki kun' uʼdu ni. ");
INSERT INTO gngNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Nɛ bi tuke' ujɛ uba linagɛnl bo uʼtàan nin uʼnuɔ kɛ faan' ki baa' uʼsaan. U laa' bi teke' wɔ ki jin' ma nnɔ, nɛ u tɔke' ujɛ wà ya tàan nin uʼnuɔ faan' nnɔ ki ye: «Nʼbukɛ, cuo aʼba, n fère' ŋɛ aʼbiɛre ŋɔ.» ");
INSERT INTO gngNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Nɛn saan nɛ *Yiko ya wɔnwɔknb biba maaleh ki teh: «Ujɛ wuɔ sukreh Uwien nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","*Yesu bɛnde' biʼyɛnmaale, nɛ ki tɔke' bɛ ki ye: «Bɛ tien' ni ŋmɔbe yii ya yɛnmaalbiɛre? ");
INSERT INTO gngNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ni lɛ ba nɛ faa? Ń tɔke wɔ kí ye n fère' wɔ uʼbiɛre nɛ faa bii wɔ ń fii kí cuon nɛ faa? ");
INSERT INTO gngNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Nɛn bo, n li wuɔn nɛ kí ye *Unil ya Bijɛ ŋmɔbe mituɔm uŋɛndun wuu ni wɔ ń fère binib biʼbiɛre.» Nɛ ki tɔke' wà ya nuɔ nin uʼtàan faan' nnɔ ki ye: «Fii, kí yuure aʼnagɛnl, kí li kunh.» ");
INSERT INTO gngNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Nɛ u fii', ki kun'. ");
INSERT INTO gngNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Linigol nnɔ laa' nnɔ ma nnɔ, nɛ nì cuo' bɛ bujɛwaanbu, nɛ bi pɛ̀ke' Uwien u de' binib mituɔm mà nnɔ bo. ");
INSERT INTO gngNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","*Yesu siere' niʼsaan ki joh ma nnɔ, nɛ ki laa' ulɛnpotekl uba kɛ lɛnpotekbùol, bi yih wɔ Matie. Nɛ *Yesu tɔke' wɔ ki ye: «Paan nʼbo ní.» Nɛ u fii' ki paan' uʼbo. ");
INSERT INTO gngNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ni ya puoli bó nɛ *Yesu te Matie den ki jinh tijier. Bilɛnpotekb ligol nin bibiɛrdɛnb mɔ baa' ki kɛ wɔn nin uʼpanpaankaab saan, ki jinh. ");
INSERT INTO gngNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","*Farisiɛnmbɛ laa' nnɔ ma nnɔ, nɛ ki niire' uʼpanpaankaab ki ye: «Bɛ tien' niʼcɛnbaa tɛ ki jinh nin bilɛnpotekb nin bibiɛrdɛnb-i?» ");
INSERT INTO gngNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","*Yesu cii' bi len' ma bo, nɛ ki tɔke' bɛ ki ye: «Binib bà ŋmɔbe laanfiɛ ŋa nuunh dɔktiɛ, bà bun nɛ nuunh dɔktiɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Nì kɛle' *Uwien ya gbɔnku ni ki ye: «Uwien ŋa yíe bɛ ń li teh tuɔrɛ ki dienh wɔ, ama u yíe bɛ ń li muɔh tɔb micɛcɛkm nɛ. Nɛn bo, li joh mɛn kí tì bɛnge iñɔbon yiɛ nɔ ya tingi. Kimɛ ma baa' ń yin nimɔ̀nb, n baa' ń yin bibiɛrdɛnb nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Tɔ, San ya panpaankaab baa' ki lá niire' Yesu ki ye: «Bɛ tien' tinbi nin *Farisiɛnmbɛ lùoh buñɔbu, nɛ a ya panpaankaab bɛn ŋa lùoh?» ");
INSERT INTO gngNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Nɛ u jiin' bɛ ye: «Binib bà bi yin' bɛ upiikuɔn li fre kí li te uyɛnsaa ni uyo wà piicɛ laan te biʼsaan-ii? Ama uyo uba we ní bɛ ń ñɛn piicɛ nnɔ biʼsaan. U ya yo nɛ bi li lòle buñɔbu.» ");
INSERT INTO gngNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Nɛ ki tí ye: «Uba ŋa ń taa kpɛlcɛfɛ̀nku ya jenl, kí lekn liliɛrkpaal. U tien' nnɔ la, kukpɛlcɛfɛ̀nku ya jenl nnɔ li kɛre liliɛrkpaal nnɔ nɛ libònl nnɔ ń yɛbre kí pukn. ");
INSERT INTO gngNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Uba mɔ ŋa ń taa midaam mà ŋa laan muɔ' ki ben' kí piɛke iyɔkpaan ni. U tien' nnɔ la, iyɔl nnɔ li kpiɛre kí saa, nɛ midaam nnɔ mɔ ń wule kí ñɛnde. Bi piɛkeh midaam mà ŋa laan muɔ' ki ben' iyɔfɛ̀n ni nɛ. Bi tien' nnɔ la, liyɔl nnɔ ŋa ń saa, midaam nnɔ mɔ ŋa ń wule.» ");
INSERT INTO gngNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","*Yesu te ki lienh, nɛ uciɛn uba baa', ki lá gbaan' uʼnintuɔli ki tɔke' wɔ ki ye: «Nʼbisɛ kpo' itàan yiɛ bo nɛ. Ama dɛn kí taa aʼnuɔ kí paan uʼbo, ŋɔ wɔ ń liɛbe kí li fuobe.» ");
INSERT INTO gngNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Nɛ *Yesu fii' ki paan' uʼbo nin uʼpanpaankaab. ");
INSERT INTO gngNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Tɔ, upii uba mɔ là te niʼsaan, ki laa' tifɛr ibin piik nin ile ta gben'. U maale' uʼyɛnm ni ki ye: «N mɛ' uʼwɛngolkaar mɔnɔn la, n li faake nɛ.» Nɛ ki baa' *Yesu ya puoli bó ní, ki nɛkn' wɔ, nɛ ki mɛ' uʼwɛngolkaar ya ñɔgbɛn. ");
INSERT INTO gngNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","*Yesu jiɛbe' ki laa' wɔ, nɛ ki tɔke' wɔ ki ye: «Nʼbisɛ, cuo aʼba. Aʼtekjim nɛ ŋmiɛn' ŋɛ.» Nɛ u pɔk ki faake' i ya tàan bo. ");
INSERT INTO gngNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","*Yesu tì baa' uciɛn nnɔ den, nɛ ki laa' biwopieb nin linigol te niʼsaan ki ŋmɔbe kuwaaku ki gbien'. ");
INSERT INTO gngNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Nɛ u tɔke' bɛ ki ye: «Ñɛ mɛn saali, kimɛ kibupiik nnɔ ŋa kpo', kì gɔh nɛ.» U len' nnɔ ma nnɔ, nɛ bi lɛh wɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Bi ŋɔre' linigol nnɔ ki ñɛn' saali, nɛ u kɔn' kibupiik nnɔ dɔ kuduku kùa ni nnɔ, ki cuo' kiʼnuɔ, nɛ kì fii'. ");
INSERT INTO gngNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Nɛ tigbɛr nnɔ yɛre' ki gbe mitinfɛnm nnɔ ni niʼkɛ saan. ");
INSERT INTO gngNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","*Yesu siere' niʼsaan ki bure'. U joh ma nnɔ, nɛ ijùɔn ile pɛ uʼbo, ki wuureh ki teh: «*Dafid ya yaabile, muɔ tɛ micɛcɛkm.» ");
INSERT INTO gngNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","*Yesu tì baa' iden, ijùɔn nnɔ nɛkn' wɔ, nɛ u niire' yɛ̀ ki ye: «Ni teke' ki jin' ki ye n li fre kí likre nɛ-ɛɛ?» Nɛ ì jiin' wɔ ki ye: «A li fre, Yonbdaan.» ");
INSERT INTO gngNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Nɛ u mɛ' iʼnun, ki tɔke' yɛ̀ ki ye: «Nɛ̀ ń tien nɛ tɛn ni teke' nni ki jin' ma bo.» ");
INSERT INTO gngNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Nɛ ì likre'. Nɛn saan nɛ u tùɔre' ki kpɛkpɛ' iʼbo ki ye ì la tɔke nil. ");
INSERT INTO gngNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ama bi ñɛn' ma nnɔ, nɛ ki lienh uʼbó mitinfɛnm nnɔ ni niʼkɛ saan. ");
INSERT INTO gngNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Tɔ, uyo wà bi ñɛh nnɔ, nɛ bi tuke' ní ujɛ uba usɛnpol cère' uʼlɛnl tɛbe' ki baa' *Yesu saan. ");
INSERT INTO gngNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","*Yesu ŋɔre' usɛnpol nnɔ, nɛ u ji freh ki lienh. Nì cuo' linigol miyɔkm cɛɛn, nɛ bi ye: «Ta laan laa' niɛ ya bonn tinbi Israyɛl yaab ni.» ");
INSERT INTO gngNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ama *Farisiɛnmbɛ bɛn lienh ki teh isɛnpol ya ciɛn nɛ de' wɔ mituɔm u ŋuɔh isɛnpol binib saan. ");
INSERT INTO gngNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","*Yesu cuonh iducɛnciɛn kɛ ni nin iduwawaale ni, ki wɔknh binib itáan ya dur ni, ki kpaandeh Uwien ya bɛl ya gbɛmɔnmɔnt, ki buuh iwìɛn kɛ ya bol. ");
INSERT INTO gngNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","U laa' inigol, nɛ ki muɔ' bɛ micɛcɛkm cɛɛn, kimɛ bi dɔre', biʼyɛnm saa', nɛ bi te tɛn ipe yà ŋa ŋmɔbe wa kpaah yɛ̀. ");
INSERT INTO gngNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Nɛ u tɔke' uʼpanpaankaab ki ye: «Tijier ben' ki yɛbe, ama bà li taan tù ŋa ji yɛbe. ");
INSERT INTO gngNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Nɛn bo, gbáan mɛn ukpɛdaan wɔ ń sɔn bitonsɔnb bɛ ń tì taan uʼjier.» ");
INSERT INTO gngNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Nɛ *Yesu yin' uʼpanpaankaab piik nin bile nnɔ ní, ki de' bɛ mituɔm bɛ ń li ŋuɔh isɛnpol binib saan, kí li buuh iwìɛn kɛ ya bol. ");
INSERT INTO gngNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Uʼtondb piik nin bile nnɔ ya yel sɔ: ukpiɛk, Simɔn wà bi yih wɔ Piɛr nnɔ nin uʼninjɛ Andre, Sebede ya bijiɛb Saak nin uʼninjɛ San, ");
INSERT INTO gngNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filip nin Batelemi, Toma nin Matie ulɛnpotekl, Alfe ya bijɛ Saak nin Tade, ");
INSERT INTO gngNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simɔn wà ya nun mɔ́n uʼdu ya gbɛr bo nin Sudas Iskariyɔt wà lá li kuɔre Yesu nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","*Yesu sɔn' uʼtondb piik nin bile nnɔ, nɛ ki tɔke' bɛ ki ye: «La jo mɛn bà ŋa yé Sufmbɛ ya du ni. Niʼtaal la tɛ Samari ya tinfɛnm ya du uba mɔnɔn ni. ");
INSERT INTO gngNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ama li joh mɛn Israyɛl yaab saan, kimɛ bɛn nɛ te tɛn ipe yà tùre' usɛn. ");
INSERT INTO gngNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ni joh la, ní li kpaandeh ki teh Uwien ya bɛl nɛkn' ní ŋɔ! ");
INSERT INTO gngNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Kí li buuh biwiɛnb, kí li mɛkreh bitɛnkpiib, kí li cèreh ijend lùoreh, kí li ŋuɔh isɛnpol binib saan. Ni laa' mituɔm nnɔ ma, na pɛ̀n' niba. Niʼmɔ ń li buuh binib, ki la li nuunh paaku. ");
INSERT INTO gngNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ni joh la, ni la tuke ñɔ̀km, ki la tuke like ya kur, ki la cùɔn likbu buba nin buʼtɔbu; ");
INSERT INTO gngNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ki la tuke sɛnjokɔl, ki la tuke liɛr ile, ki la tuke tacaan, ki la ŋuuke gbien, kimɛ utonsɔnl kɛ jinh uʼtuonl bo nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","«Ni tì baa' udu wà ni la, ní nuun unimɔ̀n wà li teke nɛ uʼden, kí li te nɛn saan kí tì baa' uyo wà ni li siere udu nnɔ ni. ");
INSERT INTO gngNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ni kɔn' iden yà ni la, ní fuonde iden nnɔ ya nib kí ye: ‹Li te mɛn uyɛnduɔn ni.› ");
INSERT INTO gngNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Iden nnɔ ya nib teke' nɛ la, uyɛnduɔn nnɔ li yé biʼyu nɛ. Ama ba teke' nɛ la, u li juore niʼyu nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Iden yà ya nib bii udu wà ya nib ŋa teke' nɛ, ka teke' niʼgbɛr mɔ la, ñɛ mɛn nɛ̀ kí kpakpaare niʼtàan ya tɛngunku kí wiɛ nɛ̀. ");
INSERT INTO gngNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","N tɔkeh nɛ imɔ̀n nɛ, lidaali là Uwien li bu binib tibuur nnɔ, binib nnɔ ya tudɛre li cɛn Sodɔm nin Gomɔr ya du ya nib yu.» ");
INSERT INTO gngNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","«N sɔnh nɛ ma nɔ, ni li te tɛn ipe nɛ te ikɛ̀r ya siik ni. Nɛn bo, ní li ceke tɛn iwɛ, kí li te suoo tɛn inɛnjel. ");
INSERT INTO gngNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Li bɛn mɛn binib bó, bi lá li cuo nɛ kí jon tibuur, kí ñì nɛ inalɛbe biʼtáan ya dur ni. ");
INSERT INTO gngNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Min bo, bi lá li tuke nɛ kí jo tibuur idu ya ciɛnb nin bibɛrb saan. Nnɔ nɛ ni li yé nʼmɔ̀nkunb bɛn nin bà ŋa yé Sufmbɛ kɛ saan. ");
INSERT INTO gngNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Bi cuo' nɛ ki jon' tibuur la, la nìin mɛn ni li len ma bo bii ni li len kí ye bà. Uyo lá baa' la, ni li bɛnde ni li len kí ye bà. ");
INSERT INTO gngNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Kimɛ na yé ninbi nɛ li len, niʼBaa *Uwien ya Fuoñaanm nɛ li cère ní len. ");
INSERT INTO gngNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","«U ya yo nɛ unil li kuɔre uʼninjɛ, bɛ ń ku wɔ. Baa mɔ li kuɔre uʼbuk, bɛ ń ku kɛ̀. Mubumu mɔ li fii kí sere muʼnaambɛ nin muʼbaambɛ bo, kí cère bɛ ń ku bɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Min bo nɛ binib kɛ li nɛn nɛ. Ama wà kɛ li mìnde kí li ŋmɔŋmɔbe kí tì fɔre nnɔ, wɔn nɛ li ŋmɛre. ");
INSERT INTO gngNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Bi jɛ̀ndeh nɛ udu uba ni la, ní sɛn kí jo udutɔ ni. N tɔkeh nɛ imɔ̀n nɛ, *Unil ya Bijɛ li baa ní kí lɛ na laan bòn' Israyɛl ya du kɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","«Wà bɛngeh ŋa ń cɛn wà wɔknh wɔ. Utonsɔnl mɔ ŋa ń cɛn uʼcɛnbaa. ");
INSERT INTO gngNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Nì kpɛ wà bɛngeh ń li te tɛn wà wɔknh wɔ nɛ, utonsɔnl mɔ ń li te tɛn uʼcɛnbaa. Bi yin' ududaan isɛnpol ya ciɛn Bɛlsebul la, ba ń yin uʼden yaab mɔ nà cɛn' nnɔ-ɔɔ?» ");
INSERT INTO gngNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","«Nɛn bo, la fɛnge mɛn nib. Niba ŋa te ki buɔ ŋɔ ba lá li ñɛn nɛ̀ upaan bo. Tigbɛr tuba mɔ ŋa te kí juore kí li buɔ ŋɔ ba lá li bɛnde tù. ");
INSERT INTO gngNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","N tɔkeh nɛ nà licinñunl ni nnɔ, kpaande nɛ̀ mɛn kuwenwenku ni. N bunbeh nɛ nà litubl ni nnɔ, kpaande nɛ̀ mɛn kudulɛkaaku ya paaki. ");
INSERT INTO gngNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","La fɛnge mɛn nib, kimɛ bi kuuleh tigbɛnɛnt baba nɛ. Ba ń fre kí ku naank. Li fɛnge mɛn wà li fre kí ku tigbɛnɛnt nin kinaank kɛ umu wà ŋa ń kpiin ni. ");
INSERT INTO gngNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Bi li fre kí kuɔre inuɔn ile iŋɛ nɛ? Nin nɛn kɛ ŋɔ uba mɔnɔn ŋa ń lu kí kpo ŋɔ niʼBaa ŋa bɛn. ");
INSERT INTO gngNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ninbi wɔn, Uwien bɛn haali niʼyur mɔnɔn ya ñɔbu. ");
INSERT INTO gngNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Nɛn bo, la fɛnge mɛn. Ni cɛn' inuɔn ligol.» ");
INSERT INTO gngNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","«Wà kɛ lienh binib ya nun bó ki teh u yé nʼyɔ la, nʼmɔ li len nʼBaa wà te paaki bó ya nun bó kí ye udaan mɔ yé nʼyɔ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ama wà kɛ lienh binib ya nun bó ki teh wa yé nʼyɔ la, nʼmɔ li len nʼBaa wà te paaki bó ya nun bó kí ye udaan mɔ ŋa yé nʼyɔ.» ");
INSERT INTO gngNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","«Ni la li maaleh ki teh n tuke' uñɔkpaan nɛ ki baa' uŋɛndun wuu ni. N tuke' lituɔl nɛ ki baa'. ");
INSERT INTO gngNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","N baa' ń pàare kibujɛbuk nin kiʼbaa nɛ, kí pàare kibupiik nin kiʼnaa, kí pàare yaabisɛ mɔ nin uʼcɛ ya naa. ");
INSERT INTO gngNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Unil den yaab nɛ li yé uʼnɛnnɛndb. ");
INSERT INTO gngNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","«Wà kɛ yíe uʼnaa bii uʼbaa ki cɛn' min la, wa kpɛ wɔ ń li yé nʼyɔ. Unil wà kɛ mɔ yíe uʼbisɛ bii uʼbijɛ ki cɛn' min la, uʼmɔ ŋa kpɛ wɔ ń li yé nʼyɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Wà kɛ ŋa yuunh uʼdɔpɔnpɔn ki bukeh ki paakeh nʼbo la, wa kpɛ wɔ ń li yé nʼyɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","«Wà nuunh wɔ ń fie uʼmiɛl la, wɔn nɛ li kpo kí juore fɛnm. Wà li tuo kí kpo min bo nnɔ, wɔn nɛ li lɛ limiɛl.» ");
INSERT INTO gngNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","«Unil teke' nɛ la, u teke' min nɛ. Unil teke' nni la, u teke' wà sɔn' nni ní nnɔ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Unil teke' *Uwien ya ñɔbonsɔknl ki ye u yé *Uwien ya ñɔbonsɔknl ma nnɔ nɛ cère' u teke' wɔ la, u li lɛ *Uwien ya ñɔbonsɔknl ya suul. Unil teke' unimɔ̀n ki ye u yé unimɔ̀n ma nnɔ nɛ cère' u teke' wɔ la, u li lɛ unimɔ̀n ya suul. ");
INSERT INTO gngNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","N tɔkeh nɛ imɔ̀n nɛ, wà kɛ de' ibaan yiɛ nɔ ya uba kiñunyibuok baba mɔnɔn, ki ye u yé nʼpanpaankɛ ma nnɔ nɛ cère' u de' wɔ la, wà ń lúo uʼsuul fiebu.» ");
INSERT INTO gngNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","*Yesu tɔke' uʼpanpaankaab piik nin bile bi li tien ma ki tì gben' ma nnɔ, nɛ ki siere' niʼsaan, ki jon' ki tì wɔknh binib Uwien ya gbɛr, ki kpaandeh tù mitinfɛnm nnɔ ya du ni. ");
INSERT INTO gngNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Tɔ, San wà siih binib Uwien ya ñunm te lipɛkl ni uyo wà nnɔ nɛ ki cii' *Uwien ya Nigɛndkɛ Kristo ya tùon bó. Nɛ ki sɔn' uʼpanpaankaab uʼsaan, ki ye bɛ ń tì niire wɔ kí ye ");
INSERT INTO gngNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","wɔn nɛ yé wà li baa ní nnɔ bii bi li guure utɔ nɛ? ");
INSERT INTO gngNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Bi tì niire' Yesu, nɛ u tɔke' bɛ ki ye: «Liɛbe mɛn kí tì tɔke San ni cii' nà nin ni laa' nà: ");
INSERT INTO gngNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","ijùɔn likreh, iwɔ̀b cuonh, ijend lùoreh, igbaan ciih, bitɛnkpiib mɛkreh, nɛ bijiinb ciih Uwien ya gbɛmɔnmɔnt. ");
INSERT INTO gngNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Wà ŋa tùre' Uwien ya sɛn min bo la, Uwien ya mɔnm te uʼbo.» ");
INSERT INTO gngNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","San ya panpaankaab liɛbeh uyo wà nnɔ, nɛ *Yesu cin' ki tɔkeh linigol San ya gbɛr ki teh: «Ni là jon' kupenpelku ni ní tì liike ba? Ni là jon' ní tì liike limuɔnl là mitafaam jèngeh lɛ̀ nɛ-ɛɛ? ");
INSERT INTO gngNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ni nín là jon' ní tì liike ba? Ni là jon' ní tì liike unil wà guo tikpɛlcɛmɔnmɔnt nɛ-ɛɛ? Binib bà guoh tikpɛlcɛmɔnmɔnt kɔh bibɛrb den nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Tɔ, ni nín là jon' ní tì liike ni lɛ bonn nɛ? Ni là jon' ní tì liike *Uwien ya ñɔbonsɔknl nɛ-ɛɛ? N tɔkeh nɛ imɔ̀n nɛ, u cɛn' *Uwien ya ñɔbonsɔknl mɔnɔn. ");
INSERT INTO gngNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Kimɛ wɔn San bo nɛ nì kɛle' *Uwien ya gbɔnku ni ki ye: ‹Liike, n li sɔn nʼtond wɔ ń liere ŋɛ, kí lá tùɔre aʼsɛn.› ");
INSERT INTO gngNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","N tɔkeh nɛ imɔ̀n nɛ, ba laan maa' nil uba u cɛn' San wà siih binib Uwien ya ñunm nnɔ. Ama unil wà yé uwaal Uwien ya bɛl ni cɛn' wɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Kí ñɛ San là siih binib Uwien ya ñunm uyo wà kí lá baa fɛnfɛnnɔ, bi piikeh Uwien ya bɛl nin ufaa nɛ, nɛ bà faa nuunh bɛ ń fie lɛ̀. ");
INSERT INTO gngNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","*Uwien ya ñɔbonsɔknb kɛ nin yiko là len' nì li te ma bo, kí lá baa San ya yo. ");
INSERT INTO gngNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ni yíe ní cii mɔnmɔnm la, ní li bɛn kí ye San yé *Uwien ya ñɔbonsɔknl *Eli wà bi li liɛbe ní nnɔ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Wà ŋmɔbe litubl la, wɔ ń cii. ");
INSERT INTO gngNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","«N li taa ba kí nɛnge fɛnfɛnnɔ ya nib-i? Bi naan tɛn mubumu nɛ kɛ kidaak ni ki jeleh, ki tɔkeh muʼtɔmu ");
INSERT INTO gngNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","ki teh: ‹Ti piebe' nɛ liwol, nɛ na ŋɔn' ciɛk. Ti gɛn' ikuyuon, nɛ na kpiɛnde'.› ");
INSERT INTO gngNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","«Kimɛ San baa' ki kùɔ tijier tubambɛ, ki lùoh buñɔbu, ka ñuh daam, nɛ bi ye usɛnpol nɛ ŋaake wɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","*Unil ya Bijɛ baa' ki jinh ki ñuh, nɛ bi ye: ‹Liike mɛn ujɛ wuɔ yé ufɔnfuɔb nɛ, ki yé udɛyibl, ki jɔreh nin bilɛnpotekb nin bibiɛrdɛnb.› Tɔ, Uwien ya tùon nɛ wɔngeh uʼyɛnfuom mɔn ki kpɛ ma bo.» ");
INSERT INTO gngNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Tɔ, *Yesu cin' ki kɔnh nin idu iba ya nib. U là tien' miyɔkm ya bont tù yɛbe idu nnɔ ni, nɛ iʼnib ŋa lèbre' biʼtetem. Nɛn nɛ cère' u kɔnh nin bɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","U len' ki ye: «Korasinn yaabɛ, nì bre niʼbo. Bɛtsayida yaabɛ, nì bre niʼmɔ bo. Kimɛ ni laa' miyɔkm ya bont tà niʼbùol nɔ, Tir nin Sidɔn yaab mɔ bi là laa' tù la, bi bi tien' tɛn bi kɛ mikuum nɛ, ki pùnpùkn' mifɛntɛm, ŋɔ kí wuɔn kí ye bi lèbre' biʼtetem nì wuɔke'. ");
INSERT INTO gngNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","N tɔkeh nɛ nɛ, lidaali là Uwien li bu binib tibuur nnɔ, ni ya tudɛre li cɛn Tir nin Sidɔn yaab yu. ");
INSERT INTO gngNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ninbi Kapɛrnawum yaabɛ, ni maaleh ki teh Uwien li duon nɛ paaki nɛ-ɛɛ? U li jiin nɛ kutɛnkpiiku ni nɛ. Kimɛ ni laa' miyɔkm ya bont tà niʼbùol nɔ, Sodɔm yaab mɔ bi là laa' tù la, biʼdu nnɔ bi biɛ ki te nɛ haali nin dinnɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","N tɔkeh nɛ nɛ, lidaali là Uwien li bu binib tibuur nnɔ, ni ya tudɛre li cɛn Sodɔm yaab yu.» ");
INSERT INTO gngNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","U ya yo nɛ *Yesu len' ki ye: «Baa, sin kutaaku nin kitink ya Yonbdaan, a bɔle' tibont tà biyɛnfodɛnb nin bibɛnbɛnb nnɔ, a taa' tù ki wuɔn' biwaab nɛ. Nɛn bo nɛ n pɛ̀keh ŋɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Imɔ̀n, Baa, a yíe nɛ ki tien' nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","«Tɔ, nʼBaa nɛ taa' tibont kɛ ki ŋukn' nni. NʼBaa ŋa ñí la, uba ŋa bɛn min uʼBijɛ yé udaan wà. Min uʼBijɛ ŋa ñí la, uba mɔ ŋa bɛn nʼBaa yé udaan wà. Binib bà n yíe ki taa' nʼBaa ki wuɔn' bɛ nnɔ mɔ bɛn u yé udaan wà. ");
INSERT INTO gngNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","«Ninbi bà kɛ tuke ituk ì kpiɛke ki jii' nnɔ, dɛn mɛn nʼsaan, n li de nɛ lifuorl. ");
INSERT INTO gngNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Buke mɛn nʼnajɛdɛbiku, kí cère ń wɔkn nɛ, kimɛ n te suoo nɛ, ki ŋmɔbe liyɛnguol. Ni li lɛ lifuorl nʼsaan, ");
INSERT INTO gngNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","kimɛ nʼnajɛdɛbiku ya bukm ŋa faa. Nʼtukl mɔ ŋa kpiɛke.» ");
INSERT INTO gngNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","*Saba uba ya daali, *Yesu nin uʼpanpaankaab gɛ̀breh ikpàan iba ni. Mikònm cuo' uʼpanpaankaab, nɛ bi cin' ki coh ijifen ki cienh ki nukeh ki ŋmɔnh. ");
INSERT INTO gngNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","*Farisiɛnmbɛ laa' bi teh nnɔ ma nnɔ, nɛ bi tɔke' *Yesu ki ye: «Liike aʼpanpaankaab teh yiko ye bi la teh nà *Saba ya daali ma.» ");
INSERT INTO gngNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Nɛ u tɔke' bɛ ki ye: «Na kaan' *Uwien ya gbɔnku ni *Dafid là tien' ma bo nɛ-ɛɛ? Mikònm là cuo' wɔn nin uʼnib, ");
INSERT INTO gngNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","nɛ u kɔn' Uwien ya ninbonl ni, ki taa' kpɔnɔ wà bi taa' ki de' Uwien nnɔ wɔn nin bɛn ŋmɔn'. Ama bitɔtuɔrkaab baba ŋa ñí la, wɔn nin uʼnib ŋa ŋmɔbe sɛn bɛ ń ŋmɔn kpɔnɔ nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Bii na kaan' nà kɛle' yiko ya gbɔnku ni nɛ? Nì kɛle' ki ye *Saba ya daali la, bitɔtuɔrkaab kɛndeh *Saba ya daali ya yiko bo nɛ Uwien ya duku ni, ama uba ŋa biindeh bɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","N tɔkeh nɛ nɛ, unil te niɛ saan nɔ ki cɛn' Uwien ya duku. ");
INSERT INTO gngNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Nì kɛle' *Uwien ya gbɔnku ni ki ye: ‹Uwien ŋa yíe bɛ ń li teh tuɔrɛ ki dienh wɔ ama u yíe bɛ ń li muɔh tɔb micɛcɛkm nɛ.› Ni bi bɛn iñɔbon nnɔ ya tingi la, na bi li biindeh binib bà ŋa ŋmɔbe biil nɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Tɔ, *Unil ya Bijɛ nɛ ŋmɔbe usɛn wɔ ń wuɔn bi li tien nà *Saba ya daali.» ");
INSERT INTO gngNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Tɔ, *Yesu siere' niʼsaan, nɛ ki kɔn' biʼtaanl ya duku ni. ");
INSERT INTO gngNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ujɛ uba mɔ te len uʼnuɔ uba faan'. Nɛ bi niire' Yesu ki ye: «Unil ŋmɔbe usɛn wɔ ń buu uwiɛn Saba ya daali-ii?» Kimɛ bi là nuunh bi li dule nà bo kí biin wɔ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Nɛ u ye: «Niʼni ŋmɛ nɛ ŋmɔbe upebaab, nɛ upe nnɔ lu' kubùoku ni *Saba ya daali la, wa ń ñɛn wɔ? ");
INSERT INTO gngNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Unil ŋa cɛn' upe-ee? Nɛn nɛ wuɔn' ki ye tiʼyiko ye unil ŋmɔbe usɛn wɔ ń tien nà mɔn *Saba ya daali.» ");
INSERT INTO gngNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Nɛ ki tɔke' ujɛ wà ya nuɔ faan' nnɔ ki ye: «Tɛnde aʼnuɔ.» U tɛnde' uʼnuɔ nɛ u jire' uʼciɛm tɛn uʼtɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Nɛn saan nɛ *Farisiɛnmbɛ nnɔ ñɛn' ki taan' ki kɛle' bɛ ń gbiere kí liike bi li tien ma kí ku Yesu. ");
INSERT INTO gngNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","*Yesu cii' ma nnɔ nɛ ki siere' niʼsaan. Linigociɛnl paan' uʼbo, nɛ u buu' biʼni biwiɛnb kɛ, ");
INSERT INTO gngNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ki kpɛkpɛ' biʼbo ki ye bi la cère bɛ ń bɛnde wɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","U tien' nnɔ ŋɔ *Uwien ya ñɔbonsɔknl Esayi là len' nà nnɔ nɛ̀ ń tien nɛ. U là len' ki ye Uwien ye: ");
INSERT INTO gngNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","«Nʼtonsɔnl sɔ nɔ, N yíe wɔ, Nʼyɛnm sɔnge uʼbo, nɛ n gɛ̀nde' wɔ. N li jiin nʼFuoñaanm uʼbo, ŋɔ wɔ ń li tɔkeh inibol kɛ n li bu binib tibuur ma bo. ");
INSERT INTO gngNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Wa ń li nuunh gbɛr, ka ń li wuureh, ba ń cii uʼwaaku bó isɛnjɛ ni. ");
INSERT INTO gngNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Wa ń tonde limuɔnl là kuɔ' ki gbàabe, ka ń kpiin lifrl là benh lɛ̀ ń kpiin, u li te nnɔ nɛ kí tì baa uyo wà u li cère nibonmɔ̀nn ń liere usɛn. ");
INSERT INTO gngNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","«Wɔn bo nɛ inibol kɛ li ŋmɔbe lidɛndɛnl.» ");
INSERT INTO gngNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","U ya yo nɛ bi tuke' ní ujɛ uba ki baa' *Yesu saan. Usɛnpol nɛ cère' u yé ujuɔn, uʼlɛnl mɔ tɛbe'. *Yesu buu' wɔ, nɛ u ji freh ki lienh, ki lɛnh mɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Nì cuo' linigol nnɔ kɛ miyɔkm, nɛ bi lienh ki teh: «Ujɛ wuɔ ŋa lii yé *Dafid ya yaabil-ii?» ");
INSERT INTO gngNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ama *Farisiɛnmbɛ cii' nnɔ ma nnɔ, nɛ ki lienh ki teh isɛnpol ya ciɛn Bɛlsebul nɛ dienh wɔ mituɔm u ŋuɔh isɛnpol binib saan. ");
INSERT INTO gngNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","*Yesu bɛn biʼyɛnmaale ma nnɔ, nɛ ki tɔke' bɛ ki ye: «Libɛl là kɛ ya nib bore' tɔb ki kɔnh biʼŋmiɛl ni la, libɛl nnɔ li juore fɛnm nɛ. Udu uba ya nib bii iden iba ya nib mɔ bore' tɔb, ki kɔnh biʼŋmiɛl ni la, udu nnɔ bii iden nnɔ mɔ li juore fɛnm nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Nɛn bo, Satan liɛbe' ki ŋuɔh wɔn Satan binib saan la, u kɔnh nin uʼba nɛ, nɛ uʼbɛl li tien mila ka ń juore fɛnm-i? ");
INSERT INTO gngNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ni len' ki ye isɛnpol ya ciɛn *Bɛlsebul nɛ de' nni mituɔm n ŋuɔh isɛnpol binib saan. Tɔ, ŋmɛ nín de' niʼpanpaankaab mɔ mituɔm bi ŋuɔh isɛnpol binib saan-i? Niʼpanpaankaab teh ma bo nɛ li wuɔn kí ye ni ŋmɔbe imɔ̀n bii na ŋmɔbe. ");
INSERT INTO gngNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ama *Uwien ya Fuoñaanm nɛ dienh nni mituɔm n ŋuɔh isɛnpol. Nɛn nɛ wuɔn' ki ye Uwien ya bɛl baa' ní niʼsaan. ");
INSERT INTO gngNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Mitɔm la, uba ŋa ń fre kí kɔ ufɛfaa den, kí fie uʼbont, ka ŋmɔbe tuɔm mà u li kpiɛ kí lòle wɔ kí yaan. U lòle' wɔ la, u ya yo nɛ u li fre kí kɔ uʼden kí fie uʼbont. ");
INSERT INTO gngNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","«Wà kɛ ŋa se nʼciɛk bó la, u nɛn nni nɛ. Wà kɛ ŋa taakeh ki toreh nni la, u kpiɛndeh nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Nɛn bo, n tɔkeh nɛ nɛ, Uwien li fère binib biʼbiɛre kɛ, kí fère bɛ bi sukreh wɔ isuk yà kɛ. Ama unil suke' *Mifuoñaanm mɛn la, Uwien ŋa ń fère wɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Unil len' *Unil ya Bijɛ bo fɛnfɛnm la, Uwien li fère wɔ. Ama unil len' *Mifuoñanm mɛn bo fɛnfɛnm la, Uwien ŋa ń fère wɔ kitink kiɛ bo, ka ń fère wɔ paaki bó mɔ.» ");
INSERT INTO gngNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","«Ní li bɛn kí ye busubu mɔn la, buʼbii mɔ li mɔn nɛ. Bù bre la, buʼbii mɔ li bre nɛ. Busubu ya bii nɛ li cère bɛ ń bɛnde bù yé busubu bùa ya bol. ");
INSERT INTO gngNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Iwaalɛb ninbi, ni bre ma nnɔ, ni li tien mila kí len iñɔbon yà mɔn-i? Kimɛ unil kɛ len' ki kun' nà bó la, nì ñɛn' iyɛnmaale yà te uʼfɛ̀l bo nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Unimɔ̀n ya yɛnmaalmɔnmɔn nɛ cèreh u teh nà mɔn, nɛ ubiɛrdaan ya yɛnmaalbiɛre cèreh u teh nà bre. ");
INSERT INTO gngNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","«N tɔkeh nɛ nɛ, lidaali là Uwien li bu binib tibuur nnɔ, nɛn daali nɛ u li niire bɛ bi là len' ñɔbonfɛnfɛnm wà kɛ nnɔ ya gbɛr. ");
INSERT INTO gngNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Aʼlenm bo, nɛ Uwien li bù ŋɛ ugbɛmɔ̀ndaan bii u li biin ŋɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","U ya yo nɛ *Yiko ya wɔnwɔknb biba nin *Farisiɛnmbɛ biba tɔke' *Yesu ki ye: «Cɛnbaa, ti yíe á tien miyɔkm ya bonn niba nɛ tí lɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Nɛ u tɔke' bɛ ki ye: «Ninbi fɛnfɛnnɔ ya nibɛ, ni yé binibiɛrb nɛ, ka cuube Uwien saan, nɛ ki nuunh ní lɛ miyɔkm ya bonn. *Uwien ya ñɔbonsɔknl *Sonas ya yɔkm ya bonn baba ŋa ñí la, na ji li lɛ yɔkm ya bontɔnn niba. ");
INSERT INTO gngNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Sonas là tien' ujɛnciɛn ya benku ni iwien ita nin tiñɔnt tuta ma nnɔ, nnɔ nɛ *Unil ya Bijɛ mɔ li tien kitink ni iwien ita nin tiñɔnt tuta. ");
INSERT INTO gngNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Uwien li bu binib tibuur lidaali là nnɔ, Ninif yaab li fii kí sere fɛnfɛnnɔ ya nib ya nun bó kí biin bɛ. Kimɛ *Sonas là kpaande' Ninif ya du ni Uwien ya gbɛr ma nnɔ, bi là cii' nɛ ki lèbre' biʼtetem. Ama unil te niɛ saan nɔ ki cɛn' *Sonas. ");
INSERT INTO gngNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Uwien li bu binib tibuur lidaali là nnɔ, *Seba ya piibɛr li fii kí biin fɛnfɛnnɔ ya nib, kimɛ u là ñɛn' ní fɔnfɔkm nɛ wɔ ń lá cenge Salomɔn ya yɛnfogbɛr. Ama unil te niɛ saan nɔ ki cɛn' Salomɔn.» ");
INSERT INTO gngNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","«Usɛnpol siere' unil saan la, u cuonh ki lindeh kupenpelku ni nɛ, ki nuunh u li kɛ̀le nà saan kí fuore. U tì luo' la, ");
INSERT INTO gngNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","nɛ wɔ ń ye u li liɛbe ki tì kɔ u là ñɛn' nà saan nnɔ nɛ. U li liɛbe ní kí lɛ niba ŋa te uʼkɔnkuɔn nnɔ ni, bi tùɔre' ki ŋɛ̀re' wù, ki tien' tibonmɔnmɔnt len. ");
INSERT INTO gngNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Nɛn saan nɛ u li jo kí tì taa ní isɛnpol ilole yà bre ki cɛn' wɔn, iʼkɛ ń lá li ŋaake unil nnɔ bo, kí cère wɔ ń juore fɛnm kí cɛn u là te mikpiɛkm ma bo. Nì li te nnɔ nɛ fɛnfɛnnɔ ya nibiɛrb mɔ bo.» ");
INSERT INTO gngNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","*Yesu laan biɛ ki lienh nin linigol nnɔ, nɛ uʼnaa nin uʼninjiɛb baa' ki lá se saali ki nuunh bɛ ń tɔke wɔ tigbɛr. ");
INSERT INTO gngNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Nɛ linigol nnɔ ni uba tɔke' wɔ ki ye: «Aʼnaa nin aʼninjiɛb se saali ki nuunh bɛ ń tɔke ŋɛ tigbɛr.» ");
INSERT INTO gngNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Nɛ *Yesu jiin' wɔ ki ye: «Ŋmɛ yé nʼnaa? Bi lɛ yé nʼninjiɛb-i?» ");
INSERT INTO gngNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Nɛ ki tɛnde' uʼnuɔ ki wuɔn' uʼpanpaankaab ki ye: «Liike mɛn, nʼnaa nin nʼninjiɛb sɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Unil wà kɛ teh nʼBaa wà te paaki bó yíe ma la, wɔn nɛ yé nʼninjɛ, ki yé nʼninsɛ, ki yé nʼnaa.» ");
INSERT INTO gngNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Nɛn daali nɛ *Yesu ñɛn' ki jon' ki tì kɛ̀le' miñunciɛnm ya gbaal. ");
INSERT INTO gngNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Linigociɛnl taan' uʼsaan, nɛ u kɔn' ki kɛ̀le' buñɛrbu buba ni. Linigol nnɔ kɛ se miñunm ya gbaal. ");
INSERT INTO gngNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Nɛ u tɔkeh bɛ tibont tù yɛbe mikpɛnjɛnm ni. U tɔkeh bɛ ki teh: «Ukpaal uba nɛ là jon' wɔ ń tì plè tibonbuor ya bim. ");
INSERT INTO gngNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","U plèh ma nnɔ, miba lu' usɛngbɛ, nɛ inuɔn baa' ki lá ki jin' mɛ̀. ");
INSERT INTO gngNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Mitɔm lu' kutɛntiɛku bo, tɛnbim ŋa yɛbe nà saan. Tɛnbim ŋa yɛbe ma nnɔ, nɛ mì pɛn' tonm. ");
INSERT INTO gngNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Uwien ñɛn' ki tonge', nɛ ki sɛ' mɛ̀. Ma ŋmɔbe ñaan mɔnmɔnm ma nnɔ, nɛ mì waan', ki kpo'. ");
INSERT INTO gngNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Mitɔm mɔ lu' kujɛgorku ni. Nɛ kujɛgorku kpére', ki wɔbn', ki ku' mɛ̀. ");
INSERT INTO gngNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Mitɔm mɔ lu' kitinmɔnmɔnk bo, nɛ ki lùon'. Miba lùon' kokobk, mitɔm piluoluob, mitɔm mɔ pitata. ");
INSERT INTO gngNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","«Wà ŋmɔbe litubl la, wɔ ń cii.» ");
INSERT INTO gngNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Nɛ uʼpanpaankaab baa' ki lá niire' wɔ ki ye: «Bɛ tien' a pɔh bɛ mikpɛnjɛnm-i?» ");
INSERT INTO gngNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Nɛ u jiin' bɛ ki ye: «Uwien cère' ninbi nɛ bɛnde' uʼbɛl ya gbɛbɔlkaar, ama wa cère' bɛn bɛnde'. ");
INSERT INTO gngNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Kimɛ wà ŋmɔbe la, bi li de wɔ kí pukn, nɛ wɔ ń li ŋmɔbe kí gbien. Wà ŋa ŋmɔbe la, bi li fie u ŋmɔbe nà waamu nnɔ mɔnɔn nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Nɛn nɛ cère' n pɔh bɛ mikpɛnjɛnm. Kimɛ bi likeh nɛ ka lɛnh, ki cengeh ka ciih, ka bɛndeh niʼtingi mɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Bi te nnɔ ŋɔ *Uwien ya ñɔbonsɔknl Esayi là len' nà nnɔ nɛ̀ ń tien nɛ. U là ye: ‹Ni li ciih ka bɛndeh niʼtingi, kí li likeh ka lɛnh. ");
INSERT INTO gngNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Kimɛ udu wuu ya nib ya yul faa nɛ. Bi kpɛ biʼtub nɛ, ki ŋuun', ka yíe biʼnun ń lɛ, ka yíe biʼtub ń cii, ka yíe bɛ ń bɛnde niʼtingi biʼyɛnm ni, ka yíe bɛ ń lèbre biʼtetem, ŋɔ ń buu bɛ.› » ");
INSERT INTO gngNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","«Ninbi wɔn, Uwien ya mɔnm te niʼbo, kimɛ niʼnun lɛnh, niʼtub mɔ ciih. ");
INSERT INTO gngNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","N tɔkeh nɛ imɔ̀n nɛ, *Uwien ya ñɔbonsɔknb nin bigbɛmɔ̀ndɛnb ligol là yíe bɛ ń lɛ ni lɛnh nà nɔ, nɛ ka laa' nɛ̀, ki yíe bɛ ń cii ni ciih nà nɔ, nɛ ka cii' nɛ̀.» ");
INSERT INTO gngNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","«Ninbi, cenge mɛn wà plè' tibonbuor ya bim ya kpɛnjɛnm ya tingi. ");
INSERT INTO gngNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Wà kɛ ciih Uwien ya bɛl ya gbɛr, ka bɛndeh tuʼtingi la, usɛnpol ubiɛrɔ bàareh nɛ, ki ñɛndeh bi bule' nà uʼfɛ̀l ni nnɔ. Mibim mà lu' usɛngbɛ nnɔ ya tingi nínɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Mibim mà lu' kutɛntiɛku bo nnɔ mɔ yé unil wà ciih Uwien ya gbɛr, ki teknh tù tontonm nin uyɛnsɔnge, ");
INSERT INTO gngNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","ama ka cèreh tù kpaakeh ñaan uʼfɛ̀l ni, ka wuɔkreh uʼni mɔ nɛ. Liwɔbl bii ijɛnd tu' wɔ tuʼbo la, u pɔk kí taa tù kí wiɛ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Mibim mà lu' kujɛgorku ni nnɔ mɔ yé unil wà ciih tigbɛr nnɔ, uŋɛndun ya gbɛr nin lifaal ya yɛnmaale yà lɛreh binib nnɔ, wɔbndeh tù, ki cèreh ta ń fre kí sɔn tuonl nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Mibim mà lu' kitinmɔnmɔnk bo nnɔ mɔ yé unil wà ciih tigbɛr nnɔ, ki bɛndeh tuʼtingi ki te tɛn mibim mà lùonh nɛ. Miba lùonh kokobk, mitɔm piluoluob, mitɔm mɔ pitata.» ");
INSERT INTO gngNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","*Yesu tí pɔn' linigol nnɔ mikpɛnjɛntɔm ki ye: «Uwien ya bɛl naan ukpaal wà plè' ifi uʼkpàabu ni nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Binib tì duɔn' ki gùɔn' uyo wà nnɔ, nɛ uʼnɛnnɛnd baa' ki taa' utɛlmɛntɛ ki plè' ki ŋmɛ̀re' ifi nnɔ ni, nɛ ki bure'. ");
INSERT INTO gngNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ifi nnɔ tì kpére' ki maa' ma nnɔ, nɛ bi laa' utɛlmɛntɛ mɔ te iʼni. ");
INSERT INTO gngNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Nɛ ukpaal nnɔ ya tonsɔnb niire' wɔ ki ye: ‹Cɛnbaa, ŋa là plè' ifi baba nɛ aʼkpàabu ni-ii? Utɛlmɛntɛ wuɔ mɔ ñɛn' la?› ");
INSERT INTO gngNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Nɛ u ye: ‹Nʼnɛnnɛnd nɛ tien' nnɔ.› Nɛ bi niire' wɔ ki ye: ‹A yíe tí jo kí tì ŋɛŋɛbe wɔ-ɔɔ?› ");
INSERT INTO gngNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Nɛ u ye: ‹Hnhn. Dàan mɛn. Ni ye ní ŋɛbe utɛlmɛntɛ nnɔ la, nba la ni li ŋɛbe kí kpɔbe ifi iba. ");
INSERT INTO gngNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Cère mɛn ifi nnɔ nin utɛlmɛntɛ nnɔ kɛ ń li te kí tì be. Nì tì kpaan' uceceyo la, n li tɔke bifiiceb kí ye bɛ ń kpiɛ kí ŋɛŋɛbe utɛlmɛntɛ nnɔ kí lòlòle, kí tì sɛ, ŋɔ kí yaan kí ce ifi nnɔ kí tì cùɔn nʼbɔnbuɔn ni.› » ");
INSERT INTO gngNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","*Yesu tí pɔn' bɛ mikpɛnjɛntɔm ki ye: «Uwien ya bɛl naan mibim mà bi yih mɛ̀ mutaar ujɛ uba taa' mɛ̀ ki bule' uʼkpàabu ni nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Mɛn nɛ yé mibim mà ñilke tikpinsir kɛ ya bim ni. Ama mì pɛn' la, mì li kpére kí gɛ̀bre kpinsiiku kɛ kpinsiiku, kí tien busubu nɛ inuɔn ń li bàareh ki lá tereh buʼsigben bo ki kɔh.» ");
INSERT INTO gngNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","*Yesu tí pɔn' bɛ mikpɛnjɛntɔm ki ye: «Uwien ya bɛl naan kpɔnɔ ya ñɔke wà upii uba bun' kpɔnɔyom mà dindin, ki taa' wù ki tien' len, nɛ kpɔnɔ nnɔ kɛ nuule' nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","*Yesu tɔkeh inigol niʼkɛ mikpɛnjɛnm ni nɛ. Wa tɔkeh bɛ tuba ka pɔn' bɛ kpɛnjɛnm. ");
INSERT INTO gngNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","U teh nnɔ ŋɔ *Uwien ya ñɔbonsɔknl là len' nà nnɔ nɛ̀ ń tien nɛ. U là yé: «N li yàare nʼñɔbu kí pɔ mikpɛnjɛnm, kí kpiire tibonbɔlkaar tà là te haali uŋɛndun ya cincinyo nnɔ.» ");
INSERT INTO gngNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","*Yesu dàan' linigol nnɔ, ki liɛbe' ki kun'. Nɛ uʼpanpaankaab baa' uʼsaan ki niire' wɔ ki ye: «Tɔke tɛ utɛlmɛntɛ wà te ifi ni nnɔ ya kpɛnjɛnm ya tingi.» ");
INSERT INTO gngNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Nɛ u ye: «Ukpaal wà plè' ifi nnɔ yé *Unil ya Bijɛ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Bukpàabu nnɔ yé uŋɛndun wuu nɛ. Ifi nnɔ yé Uwien ya bɛl ni ya nib nɛ. Utɛlmɛntɛ nnɔ yé usɛnpol ubiɛrɔ ya nib nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ukpaal ya nɛnnɛnd wà plè' utɛlmɛntɛ nnɔ yé usɛnpol nɛ. Lifiicel yé uŋɛndun ya gbenm nɛ. Nɛ bifiiceb nnɔ yé *Uwien ya tondb. ");
INSERT INTO gngNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Utɛlmɛntɛ ya ŋɛbm kí tì sɛ nnɔ yé uŋɛndun ya gbenm lá li te ma bo nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","*Unil ya Bijɛ li sɔn ní uʼtonsɔnb Uwien ya tondb uŋɛndun wuu ni, bɛ ń lá cuo bà tulndeh binib nin bibiɛrdɛnb kɛ kí ñɛn bɛ uʼbɛl ni, ");
INSERT INTO gngNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","kí tì wiɛ umuciɛn ni. Nɛn saan nɛ bi li muɔh ki ŋmɔnh iñɔgbɛn. ");
INSERT INTO gngNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","U ya yo nɛ binimɔ̀nb li te biʼBaa ya bɛl ni ki windeh tɛn uwien. Wà ŋmɔbe litubl la, wɔ ń cii.» ");
INSERT INTO gngNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","«Uwien ya bɛl naan lifaal là buɔ bukpàabu buba ni nɛ. Unil uba laa' lifaal nnɔ, nɛ ki taa' lɛ̀ ki nɛbre' ki bɔle'. Nì ŋmaake' wɔ ki tì kɛnde', nɛ u jon' ki tì kuɔre' uʼbont kɛ, ki liɛbe' ki tì dɛ' bukpàabu nnɔ.» ");
INSERT INTO gngNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","«Uwien ya bɛl liɛbe' ki naan ukpenkpend wà cuonh ki nuunh ilɛnbii yà mɔn wɔ ń dɛ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","U tì laa' lilɛnbimɔnmɔnl là ŋmɔbe kudaaku ki gbien', nɛ ki jon' ki tì kuɔre' uʼbont kɛ, ki liɛbe' ki tì dɛ' lɛ̀.» ");
INSERT INTO gngNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","«Uwien ya bɛl tí liɛbe' ki naan bubɛbu nɛ bi wiɛ' bù miñunm ni, ki cuo' ijɛn kɛ ya bol. ");
INSERT INTO gngNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Bù gbe ijɛn ma nnɔ, nɛ bi dɛre' bù ki ñɛn' liwɛl bo, ki kɛ̀le' ki gɛ̀ngɛ̀nde' bi jinh yà ki kpìen' ikpɛncub ni, ki taa' ba jinh yà ki wiɛ'. ");
INSERT INTO gngNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Uŋɛndun ya gbenm mɔ lá li te nnɔ nɛ. Uwien ya tondb lá li baa uŋɛndun ni, kí bore bibiɛrdɛnb nin binimɔ̀nb ");
INSERT INTO gngNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","kí taa bibiɛrdɛnb kí wiɛ umuciɛn ni. Nɛn saan nɛ bi li muɔh ki ŋmɔnh iñɔgbɛn.» ");
INSERT INTO gngNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","*Yesu niire' uʼpanpaankaab ki ye: «Ni cii' niʼkɛ ya tingi-ii?» Nɛ bi tuo' hnn. ");
INSERT INTO gngNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Nɛ u ye: «Nnɔ nɛ *Yiko ya wɔnwɔknl wà kɛ paan' Uwien ya bɛl ya gbɛr bo la, u naan udendaan wà ñɛndeh uʼfaal ni tibonkpaar nin tibonfɛ̀nt nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Tɔ, *Yesu pɔn' mikpɛnjɛnm nnɔ ki tì gben' ma nnɔ, nɛ ki siere' niʼsaan, ");
INSERT INTO gngNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ki liɛbe' uʼdu ni, ki wɔknh binib Uwien ya gbɛr biʼtaanl ya duku ni. Uʼwɔknm cuo' bɛ miyɔkm, nɛ bi niireh tɔb ki teh: «U laa' la miɛ ya yɛnfuom-i? U laa' la miɛ ya tuɔm ki teh miyɔkm ya bont-i? ");
INSERT INTO gngNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Kanpinta ya bijɛ ŋa ñí-ii? Ba yih uʼnaa Mari-ii? Saak nin *Yosɛf nin Simɔn nin Sudas ya ninjɛ ŋa ñí-ii? ");
INSERT INTO gngNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Uʼninsiɛb kɛ ŋa te niɛ saan-ii? U nín laa' nɛn kɛ lɛ saan-i?» ");
INSERT INTO gngNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Nnɔ nɛ biʼyɛnm ŋa ŋmaake' uʼbo, nɛ ba teke' uʼgbɛr. Nɛ *Yesu tɔke' bɛ ki ye: «*Uwien ya ñɔbonsɔknl kɛ ñɔbonsɔknl ya tiɛma du ni yaab nin uʼden yaab baba nɛ ŋa boh wɔ.» ");
INSERT INTO gngNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ba teke' wɔ ki jin' ma nnɔ, nɛ wa tien' yɔkm ya bont tù yɛbe niʼsaan. ");
INSERT INTO gngNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","U ya yo nɛ Galile ya bɛr Herod, cii' bi lienh *Yesu bó, ");
INSERT INTO gngNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","nɛ ki tɔke' uʼtonsɔnb ki ye: «San wà là siih binib Uwien ya ñunm nnɔ nɛ. U mɛkre' bitɛnkpiib ni nɛ. Nɛn nɛ cère' u ŋmɔbe mituɔm ki teh miyɔkm ya bont.» ");
INSERT INTO gngNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Tɔ, nà cère' Herod len' nnɔ si: u là sɔn' uʼsojambɛ bi tì cuo' San, ki lòle' wɔ tikudɔkr, ki pɛkn', ŋɔ nɛ̀ ń ŋmaake uʼninjɛ Filip ya po Herodiyad nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Kimɛ San là tɔke' Herod ki ye wa ŋmɔbe sɛn wɔ ń taa uʼninjɛ Filip ya po Herodiyad kí kuɔn. ");
INSERT INTO gngNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","San là len' nnɔ nɛ Herod yíe wɔ ń ku wɔ, ama ki ji fɛnge Sufmbɛ, kimɛ bi lienh ki teh San yé *Uwien ya ñɔbonsɔknl nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Herod maa' uwien wà nnɔ gɔbre' ki baa', nɛ u tien' kunacenku. Herodiyad ya bisɛ baa' ki lá ŋɔn' kiciɛk Herod nin u yin' bà kunacenku nnɔ ya nun bó. Herod ya yɛnm sɔnge' uʼbo, ");
INSERT INTO gngNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","nɛ u pole' ki ye u miɛ' wɔ nà kɛ la, u li de wɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Nɛ uʼnaa sure' wɔ u tɔke' Herod ki ye: «N yíe á tùkre San wà siih binib Uwien ya ñunm nnɔ ya yul nɛ, kí kpìen kikɛnsɛnk ni kí de nni.» ");
INSERT INTO gngNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","U len' nnɔ ma nnɔ, nɛ nì saa' ubɛr Herod ya yɛnm. Ama u pole' bicɛnb ya nun bó ma nnɔ, nɛn nɛ cère' wa yìe'. ");
INSERT INTO gngNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Nɛn saan nɛ u sɔn' soja uba ki ye wɔ ń jo lipɛkl bó kí tì tùkre San ya yul ní. ");
INSERT INTO gngNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Soja nnɔ tuke' liʼyul nnɔ ní kikɛnsɛnk ni, ki lá de' ujɛfaan nnɔ. Nɛ uʼmɔ taa' ki tì de' uʼnaa. ");
INSERT INTO gngNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","San ya panpaankaab baa' ki lá yuure' uʼgbɛnɛnt ki tì sube', nɛ ki jon' ki tì tɔke' *Yesu tigbɛr nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","*Yesu cii' nnɔ ma nnɔ, nɛ wɔn nin uʼpanpaankaab kɔn' buñɛrbu ki bure' biʼbaba nib ŋa te nà bó. Inigol cii' u bure', nɛ ki ñɛn' idu ni, ki cuon' ki paan' uʼbo. ");
INSERT INTO gngNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","*Yesu ñɛn' buñɛrbu ni uyo wà nnɔ, nɛ ki laa' linigociɛnl liba. Nɛ ki muɔ' bɛ micɛcɛkm cɛɛn, ki buu' biʼni bà bun. ");
INSERT INTO gngNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Nì juɔre', nɛ uʼpanpaankaab baa' ki lá tɔke' wɔ ki ye: «Ti te ñiɛn ŋa te nà saan nɛ, nɛ nì gɛ̀bre' tijier ya ji yo ma nɔ, cère linigol liɛ lɛ̀ ń jo idu ni kí tì dɛ tijier kí ji.» ");
INSERT INTO gngNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Nɛ u ye: «Na ciɛke bɛ ń jo, ninbi bugbɛn, de bɛ mɛn bɛ ń ji.» ");
INSERT INTO gngNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Nɛ bi ye: «Ti ŋmɔbe kpɔnɔ uŋun nin ijɛn ile baba nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Nɛ u ye: «Taa ní mɛn.» ");
INSERT INTO gngNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Nɛ ki tɔke' linigol nnɔ ki ye lɛ̀ ń kɛ̀le timuɔr bo tingi ni. Nɛ ki yuure' kpɔnɔ uŋun nin ijɛn ile nnɔ, ki yaare' ki liike' paaki, ki faare' Uwien, ki kɔkuɔ', ki taa' ki de' uʼpanpaankaab, nɛ bi gbiire' linigol nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Biʼkɛ ŋmɔn' ki gbo', nɛ bi tantaan' kpɔnɔjen nin ijɛnjen yà sìen' nnɔ, ki gbien' ikpɛncub piik nin ile. ");
INSERT INTO gngNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Binib bà jin' tijier nnɔ, bijɛb là li baa tɛn itur iŋun. Ba kaan' piib nin bumu. ");
INSERT INTO gngNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","I ya tàan bo, nɛ *Yesu wɔbn' uʼpanpaankaab ki ye bɛ ń liɛbe kí kɔ buñɛrbu nnɔ kí liere wɔ usɛn, kí puore miñunciɛnm kí jo ligbaatɔl, ŋɔ wɔ ń cɛ̀be linigol nnɔ kí yaan. ");
INSERT INTO gngNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","U cɛ̀be' lɛ̀, nɛ ki don' lijuɔl bo uʼbaba wɔ ń kàare. Nì tì biire' ki laa' u biɛ ki te lijuɔl nnɔ bo nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","U ya yo ki laa' uʼpanpaankaab mɔ te buñɛrbu ni ki jɛnde' liwɛl ŋɔ. Kutafaaku fii' ki tobreh bɛ, iñungbegbel jèngeh buñɛrbu nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ikuojɛ muɔh uyo wà nnɔ, nɛ u cuonh miñunm bo, ki tuo biʼsaan. ");
INSERT INTO gngNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Uʼpanpaankaab laa' u cuonh miñunm bo ma nnɔ, nɛ biʼfɛ̀l sɛn' cɛɛn. Bi maaleh ki teh nì yé ufɛnfɛnd nɛ, nɛ ki wuure' ijɛnwaanwuure. ");
INSERT INTO gngNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Nɛ u tɔke' bɛ i ya tàan bo ki ye: «Cuo mɛn niʼba. Min *Yesu nɛ. La sɛn mɛn jɛwaanbu.» ");
INSERT INTO gngNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Nɛ Piɛr ye: «Yonbdaan, nì mɔnbe ki yé sin nɛ la, cère nʼmɔ ń cuon miñunm bo kí baa aʼsaan.» ");
INSERT INTO gngNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Nɛ *Yesu ye: «Dɛn.» Nɛ u ñɛn' buñɛrbu ni, ki cuonh miñunm bo ki joh *Yesu saan. ");
INSERT INTO gngNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ama u laa' kutafaaku joh ki faa ma nnɔ, bujɛwaanbu cuo' wɔ, nɛ u cin' ki feleh ki kɔh miñunm ni, nɛ ki wuure' ki ye: «Yonbdaan, ŋmiɛn nni.» ");
INSERT INTO gngNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","*Yesu tɛnde' uʼnuɔ ki cuo' wɔ i ya tàan bo nɛ ki tɔke' wɔ ki ye: «Aʼtekjim nɛ pɔre' ŋɛ. Bɛ tien' a jieh?» ");
INSERT INTO gngNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Biʼkɛ bile kɔn' buñɛrbu ni uyo wà nnɔ, nɛ kutafaaku nnɔ go. ");
INSERT INTO gngNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Nɛn saan nɛ bà te buñɛrbu ni nnɔ gbaan' *Yesu ya nintuɔli ki ye: «Imɔ̀n, a mɔnbe ki yé Uwien ya Bijɛ nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Bi tì baa' miñunciɛnm ya gbaatɔl, Genesarɛt ya tinfɛnm ni, nɛ ki ñɛn' buñɛrbu ni. ");
INSERT INTO gngNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Niʼsaan ya nib bɛnde' Yesu, nɛ ki sɔnkn' mitinfɛnm nnɔ ya nib kɛ, bi taa' biwiɛnb kɛ ki baa' uʼsaan, ");
INSERT INTO gngNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","ki gbáanh wɔ ki teh wɔ ń cère biwiɛnb ń mɛ uʼliɛrku ya ñɔgbɛn baba. Bà kɛ mɛ' uʼliɛrku ya ñɔgbɛn nnɔ kɛ faake' nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Tɔ, *Farisiɛnmbɛ nin *Yiko ya wɔnwɔknb biba ñɛn' Yerusalɛm bó ki baa' *Yesu saan, nɛ ki niire' wɔ ki ye: ");
INSERT INTO gngNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«Bɛ tien' aʼpanpaankaab saah tiʼyaajɛbok-i? Kimɛ bi jinh tijier nɛ ka nire' ki paan' iyaajɛbok ye ma bo.» ");
INSERT INTO gngNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Nɛ *Yesu jiin' bɛ ki ye: «Bɛ tien' ninbi kɛndeh Uwien ya wɔbl bo niʼyaajɛbok bo? ");
INSERT INTO gngNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Kimɛ Uwien là len' ki ye: ‹Li boh aʼnaa nin aʼbaa›, ki tí len' ki ye: ‹Unil tɔke' uʼnaa bii uʼbaa liñɔbonbil la, bɛ ń ku wɔ.› ");
INSERT INTO gngNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ama ninbi wɔknh binib ki cèreh wà kɛ lienh ki teh u bi li de uʼnaa bii uʼbaa nà nnɔ, wa ji li fre kí de wɔ nɛ̀, nì yé Uwien yaann nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Nɛ udaan ŋa ji boh uʼnaa nin uʼbaa. Nnɔ nɛ ni taah niʼyaajɛbok ki lèbeh Uwien ya gbɛr. ");
INSERT INTO gngNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ninbi iñuɔn ilele ya nibɛ, *Uwien ya ñɔbonsɔknl Esayi là len' niʼgbɛr ma nnɔ, u là ŋmɔbe imɔ̀n nɛ. U là len' ki ye Uwien ye: ");
INSERT INTO gngNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‹Binib biɛ pɛ̀keh nni buñɔbu ni nɛ, biʼyɛnm ŋa nɛke nʼsaan. ");
INSERT INTO gngNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Bi pukeh nni fɛnm nɛ, ki wɔknh binib iyaajɛbok baba.› » ");
INSERT INTO gngNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","*Yesu yin' linigol nnɔ, nɛ ki tɔke' lɛ̀ ki ye: «Li cengeh mɛn, ŋɔ kí cii n li tɔke nɛ tigbɛr tà nɔ ya tingi. ");
INSERT INTO gngNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Tibont tà kɔh unil ya ñɔbu ni ŋa ń fre kí kuɔn wɔ jɔknt. Tà ñɛh uʼñɔbu ni nnɔ, tun nɛ kuɔndeh wɔ tijɔknt.» ");
INSERT INTO gngNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Nɛn saan nɛ *Yesu ya panpaankaab nɛkn' wɔ ki tɔke' wɔ ki ye: «A bɛn aʼlenm miɛ wire' *Farisiɛnmbɛ-ɛɛ?» ");
INSERT INTO gngNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Nɛ u tɔke' bɛ ki ye: «Kusiiku kùa kɛ nʼBaa wà te paaki bó ŋa caan' kù la, u li ŋɛbe kù nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","La tɔnge bɛ mɛn. Bi yé ijùɔn nɛ ki dìɛh ijùɔn. Ujuɔn dìɛh ujuɔn la, biʼkɛ bile li lu kubùoku ni nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Nɛ Piɛr tɔke' wɔ ki ye: «Tɔke tɛ mikpɛnjɛnm nnɔ ya tingi.» ");
INSERT INTO gngNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Nɛ u ye: «Niʼmɔ ŋa laan biɛ ki bɛn tibont ya tingi nɛ-ɛɛ? ");
INSERT INTO gngNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Na bɛn ki ye tibont tà kɔh unil ya ñɔbu ni nnɔ kɔh uʼpuoku ni nɛ, nɛ u joh kunincɛnku ki ñɛndeh tù-uu? ");
INSERT INTO gngNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ama tibont tà te unil ya fɛ̀l ni nnɔ, nɛ ñɛh uʼñɔbu ni, ki kuɔndeh wɔ tijɔknt. ");
INSERT INTO gngNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Kimɛ iyɛnmaalbiɛre nin linikul nin linaŋmaal nin lisɔnsɔndl nin bunasubu nin kutonnɛnku nin isuk kɛ ñɛh unil ya fɛ̀l ni nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Tuu ya bont nɛ kuɔndeh unil tijɔknt. Kí ji tijier ka ń nire kí paan iyaajɛbok ye ma bo wɔn ŋa ń fre kí kuɔn nil jɔknt.» ");
INSERT INTO gngNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","*Yesu siere' niʼsaan, nɛ ki bure' Tir nin Sidɔn ya tinfɛnm bó. ");
INSERT INTO gngNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Tɔ, upii uba là te mitinfɛnm nnɔ ni ki yé Kanaan ya pii, ki baa' ki lá wuureh ki teh: «Yonbdaan, *Dafid ya yaabile, muɔ nni micɛcɛkm. Usɛnpol nɛ ŋaake nʼbisɛ ki jɛ̀ndeh wɔ cɛɛn.» ");
INSERT INTO gngNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","*Yesu ŋa gɛre' wɔ. Nɛ uʼpanpaankaab nɛkn' wɔ ki tɔke' wɔ ki ye wɔ ń ŋɔre upii bugbɛn, u pɛ biʼbo ki ŋmɔbe kuwaaku nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Nɛ *Yesu ye: «Uwien sɔn' nni ní ń lá tore Israyɛl yaab baba nɛ, kimɛ bɛn nɛ te tɛn ipe yà tùre' usɛn». ");
INSERT INTO gngNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ama upii nnɔ baa' ki lá gbaan' uʼnintuɔli nɛ ki gbáanh wɔ ki teh: «Yonbdaan, tore nni.» ");
INSERT INTO gngNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Nɛ *Yesu ye: «Na mɔn bɛ ń taa mubumu ya jier ki wiɛ' isɛngbɛle.» ");
INSERT INTO gngNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Nɛ upii nnɔ ye: «Yonbdaan, nì yé imɔ̀n nɛ, ama isɛngbɛle mɔnɔn jinh ijieyɔyɔl yà ñɛh iʼdɛnb ya tebl bo ki luh nnɔ nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Nɛ *Yesu ye: «Upii, a teke' nni ki jin' nì yɛbe. Nɛ̀ ń tien a yíe ma bo.» Nɛ uʼbisɛ pɔk ki faake' i ya tàan bo. ");
INSERT INTO gngNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","*Yesu siere' niʼsaan ki tì baa' Galile ya ñunciɛnm ya gbaal, nɛ ki don' lijuɔl bo ki kɛ̀le'. ");
INSERT INTO gngNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Nɛ binib bàareh uʼsaan ki yɛbe, ki tukeh ní idiɛn nin ijùɔn nin itɛjenb nin igbaanlɛntɛb nin biwiɛntɔb bi yɛbe, ki lá blinh *Yesu ya nintuɔli. Nɛ u cèreh biʼkɛ faakreh. ");
INSERT INTO gngNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Binib nnɔ laa' igbaanlɛntɛb lienh, itɛjenb jire' iʼciɛm, idiɛn cuonh cucul, ijùɔn mɔ lɛnh ma nnɔ nɛ nì cuo' bɛ miyɔkm, nɛ bi pɛ̀keh Israyɛl yaab ya Wien. ");
INSERT INTO gngNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Nɛ *Yesu yin' uʼpanpaankaab ki tɔke' bɛ ki ye: «Linigol liɛ nɔ ŋmɔbe nni micɛcɛkm cɛɛn nɛ. Bi te nʼsaan ma wienta sɔ, ba ji ŋmɔbe niba bɛ ń ji. Ma yíe ń cɛ̀be bɛ bɛ ń li kunh, ka jin' niba ŋɔ kí tì dɔre usɛn ni.» ");
INSERT INTO gngNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Nɛ bi ye: «Ti te ñiɛn ŋa te nà saan nɛ. Ti li lɛ la kpɔnɔ wɔ ń li yɛbe kí de liɛ ya nigol lɛ̀ ń ŋmɔn kí gbo?» ");
INSERT INTO gngNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Nɛ u niire' bɛ ki ye: «Ni ŋmɔbe kpɔnɔ uŋɛ?» Nɛ bi ye: «Ulole nin mujɛnwawaamu mɔ waamu.» ");
INSERT INTO gngNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Nɛ u tɔke' linigol nnɔ ki ye lɛ̀ ń kɛ̀le tingi ni, ");
INSERT INTO gngNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","nɛ ki yuure' kpɔnɔ ulole nin mujɛnwawaamu nnɔ, ki faare' Uwien, ki kɔkuɔ', ki taa' ki de' uʼpanpaankaab, bi gbiire' linigol nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Biʼkɛ ŋmɔn' ki gbo', nɛ bi tantaan' tijenjent tà sìen' nnɔ, ki gbien' ikɛndɛn ilole. ");
INSERT INTO gngNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Binib bà ŋmɔn' nnɔ, bijɛb là te itur inan nɛ. Ba kaan' piib nin bumu. ");
INSERT INTO gngNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","U cɛ̀be' linigol nnɔ, nɛ ki kɔn' buñɛrbu ki bure' Magadan ya tinfɛnm bó. ");
INSERT INTO gngNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","*Farisiɛnmbɛ nin Saduseyɛnmbɛ biba baa' *Yesu saan, ki yíe bɛ ń biike wɔ, nɛ ki tɔke' wɔ ki ye wɔ ń tien miyɔkm ya bonn, kí wuɔn bɛ kí ye uʼtuɔm ñɛn' Uwien saan nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Nɛ u tɔke' bɛ ki ye: «Kutaajuɔku ni laa' kutaaku wien la, ni tɔkeh ki teh taa ŋa ń nii nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Nɛ kutɛnŋaaku ni laa' kutaaku biike la, ni tɔkeh ki teh utaa li nii dinnɔ. Ni likeh kutaaku bo, nɛ ki bɛndeh utaa li nii bii wa ń nii. Nɛ ka ji li fre kí sekn kí bɛnde tibont tà teh fɛnfɛnnɔ nɔ ya tingi-ii? ");
INSERT INTO gngNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ninbi fɛnfɛnnɔ ya nibɛ, ni yé binibiɛrb nɛ, ka cuube Uwien saan, nɛ ki nuunh ní lɛ miyɔkm ya bonn. *Uwien ya ñɔbonsɔknl Sonas ya yɔkm ya bonn baba ŋa ñí la, na ji li lɛ yɔkm ya bontɔnn niba.» U len' nnɔ ma nnɔ, nɛ ki siere' ki dàan' bɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","*Yesu ya panpaankaab joh bɛ ń puore miñunciɛnm ma nnɔ, bi sunde' ka tuke' kpɔnɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Nɛ *Yesu tɔke' bɛ ki ye: «Li bɛn mɛn *Farisiɛnmbɛ nin Saduseyɛnmbɛ ya kpɔnɔ ya ñɔke bó.» ");
INSERT INTO gngNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Nɛ bi maaleh ki teh: «Ta tuke' kpɔnɔ ma nnɔ nɛ cère' u len' nnɔ.» ");
INSERT INTO gngNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","*Yesu bɛnde' bi maaleh ki teh bà, nɛ ki niire' bɛ ki ye: «Bɛ tien' ni lienh ki teh na tuke' kpɔnɔ? Niʼtekjim nɛ pɔre' nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Na laan biɛ ki cii' tibont ya tingi nɛ-ɛɛ? Na tiɛn n là taa' kpɔnɔ uŋun ki jin' bijɛb itur iŋun ma nnɔ, ni là tantaan' nà sìen' nnɔ ikpɛncub ubiɛn wà nɛ-ɛɛ? ");
INSERT INTO gngNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Na tiɛn n là taa' kpɔnɔ ulole ki jin' bijɛb itur inan ma nnɔ, ni là tantaan' nà sìen' nnɔ ikɛndɛn ubiɛn wà nɛ-ɛɛ? ");
INSERT INTO gngNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","N ye ní li bɛn *Farisiɛnmbɛ nin Saduseyɛnmbɛ ya kpɔnɔ ya ñɔke bó ma nnɔ, na bɛn ki ye ma lienh kpɔnɔ ya gbɛr-ii?» ");
INSERT INTO gngNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Nɛn saan nɛ bi bɛnde' ki ye wa lienh kpɔnɔ ya ñɔke ya gbɛr, ama u ye bɛ ń li bɛn Farisiɛnmbɛ nin Saduseyɛnmbɛ ya wɔknm bó nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","*Yesu tì baa' Sesare Filip ya tinfɛnm ni nin uʼpanpaankaab, nɛ ki niire' bɛ ki ye: «Binib lienh ki teh *Unil ya Bijɛ yé ŋmɛ?» ");
INSERT INTO gngNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Nɛ bi jiin' wɔ ki ye: «Biba lienh ki teh a yé San wà siih binib Uwien ya ñunm nnɔ nɛ. Bitɔb lienh ki teh a yé *Eli nɛ. Bitɔb mɔ lienh ki teh a yé Seremi bii Uwien ya ñɔbonsɔknb ya uba nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Nɛ u niire' bɛ ki ye: «Ninbi nín teh n yé ŋmɛ?» ");
INSERT INTO gngNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Nɛ Simɔn Piɛr jiin' wɔ ki ye: «A yé Uwien ya Nigɛndkɛ Kristo nɛ. A yé wɔn Uwien wà fuobe ya Bijɛ nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Nɛ *Yesu ye: «Simɔn, Sonas ya bijɛ, Uwien ya mɔnm te aʼbo. Na yé nisaal nɛ kpiire' ki wuɔn' ŋɛ. NʼBaa wà te paaki bó nɛ kpiire' ki wuɔn' ŋɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Piɛr, n ye a yé litɛnpenl nɛ. Nɛ li ya tɛnpenl bo nɛ n li sien nʼtaanl yaab tɛn kuduku se litɛnpuul bo ma bo. Mikuum ya tuɔm ŋa ń faake nin nʼtaanl nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","N li de ŋɛ Uwien ya bɛl ya dupien. A yìe' nibonn nà uŋɛndun wuu ni la, bi li yìe nɛ̀ paaki bó mɔ nɛ. A tuo' nibonn nà uŋɛndun wuu ni la, bi li tuo nɛ̀ paaki bó mɔ nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Nɛn saan nɛ *Yesu kpɛkpɛ' biʼbo ki ye bi la tɔke nil kí ye u yé *Uwien ya Nigɛndkɛ Kristo. ");
INSERT INTO gngNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kí ñɛ u ya yo nɛ *Yesu cin' ki tɔkeh uʼpanpaankaab ki teh nì kpɛ wɔ ń jo Yerusalɛm, *Sufmbɛ ya ciɛnb nin *bitɔtuɔrciɛnb nin *Yiko ya wɔnwɔknb ń tì jɛ̀nde wɔ kí gbien, kí ku wɔ, nɛ wienta daali wɔ ń mɛkre bitɛnkpiib ni. ");
INSERT INTO gngNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Nɛn saan nɛ Piɛr taa' wɔ ki jɛnde', ki tì kɔnh nin wɔ ki teh: «Yonbdaan, Uwien ń cère nɛ̀ ń tien mitafaam kí gɛ̀bre. U la cère nɛ̀ ń tu ŋɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Nɛ *Yesu jiɛbe' ki tɔke' Piɛr ki ye: «Paare nʼpuoli; Satan, a lìeke nni usɛn nɛ. Kimɛ aʼyɛnmaale ŋa ñɛn' Uwien saan, ì yé binib yi nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Nɛ ki tɔke uʼpanpaankaab ki ye: «Unil yíe wɔ ń paan nʼbo la, u la tɔnge uba, wɔ ń li yuunh uʼdɔpɔnpɔn ki bukeh, kí li paakeh nʼbo. ");
INSERT INTO gngNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Kimɛ wà kɛ yíe wɔ ń fie uʼmiɛl la, wɔn nɛ li kpo kí juore fɛnm. Ama wà kɛ li tuo kí kpo min bo la, wɔn nɛ li lɛ limiɛl. ");
INSERT INTO gngNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Unil laa' uŋɛndun wuu ni ya bont kɛ ŋɔ ki tì luo' limiɛl la, u laa' bɛ ya kpɛle nɛ? Bii unil li taa bà kí pɛ kí teke uʼmiɛl-i? ");
INSERT INTO gngNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Lidaali liba, Unil ya Bijɛ lá li baa ní, kí li tɔke nin uʼtonsɔnb Uwien ya tondb, kí li ŋmɔbe uʼBaa Uwien ya kpiɛke. U ya yo nɛ u li jiin unil kɛ u sɔn' ma bo. ");
INSERT INTO gngNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","N tɔkeh nɛ imɔ̀n nɛ, binib bà se niɛ saan nɔ ya biba li lɛ *Unil ya Bijɛ we ní uʼbɛl ni nɛ kí yaan kí kpo.» ");
INSERT INTO gngNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Iwien iluob gɛ̀bre', nɛ *Yesu taa' Piɛr nin Saak nin uʼninjɛ San ki jɛnde' ki tì don' lijɔfɔfɔkrl liba bo. ");
INSERT INTO gngNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Uʼgbɛnɛnt lèbre' biʼnun bó nɛ uʼnun bó windeh tɛn uwien. Uʼwɛngolkaar pende' tɛn kuwenwenku. ");
INSERT INTO gngNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Nɛ bi laa' Moyis nin Eli puɔ' uʼsaan bi tɔkeh tigbɛr. ");
INSERT INTO gngNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Nɛ Piɛr tɔke' wɔ ki ye: «Yonbdaan, ti te niɛ saan ma nɔ, nì mɔn nɛ. A yíe la, á cère ń pɔ niɛ saan ininbon ita, sin liba, Moyis liba, *Eli mɔ liba.» ");
INSERT INTO gngNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","U lienh uʼñɔbu ŋa laan lu' nɛ kutɛwɔlgbɔnpenpienku kuba baa' ki lá pibn' biʼbo. Nɛ bi cii' uniɛke uba bó kutɛwɔlgbɔnku nnɔ ni u ye: «NʼBijɛ sɔ nɔ, n yíe wɔ; nɛ nʼyɛnm sɔnge uʼbo. Li cengeh mɛn uʼbó.» ");
INSERT INTO gngNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Uʼpanpaankaab cii' uniɛke nnɔ bó ma nnɔ, nɛ bujɛwaanbu cuo' bɛ ki tì kɛnde', nɛ bi pùon' tingi ni. ");
INSERT INTO gngNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","*Yesu baa' ki lá mɛ' bɛ, nɛ ki tɔke' bɛ ki ye: «Fii mɛn. La cère mɛn jɛwaanbu ń li ŋmɔbe nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Bi yaare' ma nnɔ, ba ji laa' nitɔ, bi laa' Yesu baba nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Bi jiinh lijuɔl nnɔ ya tingi ma nnɔ, nɛ *Yesu kpɛkpɛ' biʼbo ki ye: «Ni la tɔke uba ni laa' nà nɔ, kí tì baa uyo wà Unil ya Bijɛ li mɛkre bitɛnkpiib ni nnɔ.» ");
INSERT INTO gngNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Nɛ uʼpanpaankaab nnɔ niire' wɔ ki ye: «Bɛ tien' *Yiko ya wɔnwɔknb lienh ki teh *Eli li baa nɛ kí yaan Kristo ń baa ní?» ");
INSERT INTO gngNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Nɛ u jiin' bɛ ki ye: «*Eli li mɔnbe kí baa kí lá tùɔre tibont kɛ nɛ kí yaan. ");
INSERT INTO gngNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","N tɔkeh nɛ nɛ, *Eli baa' ŋɔ. Ama ba bɛnde' wɔ, nɛ ki tien' wɔ bi yíe ma bo. Bi jɛ̀nde' wɔ ma bo nnɔ, bi li jɛ̀nde *Unil ya Bijɛ mɔ nnɔ nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","*Yesu len' nnɔ ma nnɔ, nɛ uʼpanpaankaab bɛnde' ki ye u lienh San wà là siih binib Uwien ya ñunm nnɔ ya gbɛr nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Tɔ, *Yesu nin uʼpanpaankaab nnɔ tì baa' linigol saan uyo wà nnɔ, nɛ ujɛ uba baa' ki lá gbaan' uʼnintuɔli, ");
INSERT INTO gngNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ki tɔke' wɔ ki ye: «Yonbdaan, muɔ nʼbuk micɛcɛkm. Kì luh libinbil nɛ ki jɛ̀ndeh ki gbiekeh. Kì sɔbe ki luh umu nin miñunm ni nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","N tuke' kɛ̀ ki baa' ní aʼpanpaankaab saan, nɛ ba fre' ki cère' kì faake'.» ");
INSERT INTO gngNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Nɛ *Yesu ye: «Ninbi fɛnfɛnnɔ ya nibɛ, na teke' Uwien ki jin', ki yé binib bà bre. N li wuɔke niʼsaan kí tì kpaan mila nɛ? N li ŋmɔbe sukle niʼbo kí tì kpaan mila nɛ?» Nɛ ki ye: «Taa mɛn kibuk nnɔ ní.» ");
INSERT INTO gngNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Bi taa' kɛ̀ ní, nɛ u tiɛn' usɛnpol wà ŋaake kɛ̀ nnɔ bo, nɛ u siere' kiʼsaan. Nɛ kì faake' i ya tàan bo. ");
INSERT INTO gngNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ni ya puoli bó nɛ *Yesu ya panpaankaab baa' ki lá niire' wɔ biʼbaba bo ki ye: «Bɛ tien' tinbi ŋa fre' ki ŋɔre' usɛnpol nnɔ?» ");
INSERT INTO gngNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Nɛ u tɔke' bɛ ki ye: «Niʼtekjim nɛ ŋa yɛbe. Nɛn nɛ cère' na fre' ki ŋɔre' wɔ. N tɔkeh nɛ imɔ̀n nɛ, ni bi ŋmɔbe mitekjim mì waa tɛn kusiiku kùa bi yih kù mutaar nnɔ ya bim mɔnɔn la, ni bi li fre kí tɔke lijuɔl liɛ kí ye: ‹Siere niɛ saan, kí tì sere niɛ bó,› nɛ lɛ̀ ń siere. Na bi li gbɛle niba. ");
INSERT INTO gngNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ama usɛnpol wuɔ ya bol wɔn, na lòle' ñɔbu ki kàare' la, na ń fre kí ŋɔre wɔ.» ");
INSERT INTO gngNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Lidaali liba, *Yesu nin uʼpanpaankaab taan' Galile ni, nɛ u tɔke' bɛ ki ye: «Bi li taa *Unil ya Bijɛ kí ŋukn binib, ");
INSERT INTO gngNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","bɛ ń ku wɔ. Ama wienta daali, u li mɛkre bitɛnkpiib ni.» Nɛ biʼyɛnm saa' ki gbien'. ");
INSERT INTO gngNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","*Yesu nin uʼpanpaankaab baa' Kapɛrnawum ya du ni. Nɛ binib bà teknh Uwien ya duku ya lɛnpo nnɔ baa' ki lá niire' Piɛr ki ye: «Aʼcɛnbaa wɔn ŋa pɛ̀h Uwien ya duku ya lɛnpo nɛ-a?» ");
INSERT INTO gngNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Nɛ u ye: «U pɛ̀h nɛ.» Piɛr tì baa' iden, nɛ *Yesu kpiɛ' ki niire' ki ye: «Simɔn, uŋɛndun wuu ya bɛrb teknh biʼdu ya nib saan nɛ lɛnpo bii bicɛnb saan-i? A maaleh ki teh ba?» ");
INSERT INTO gngNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Nɛ u jiin' wɔ ki ye: «Bi teknh bicɛnb saan nɛ.» Nɛ *Yesu ye: «Nnɔ la, biʼdu ya nib bɛn fuoreh nɛ-a! ");
INSERT INTO gngNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ama ta yíe tí bii bɛ. Li joh miñunciɛnm bó kí tì wiɛ ufebe. A li cuo ujɛnkpiɛk wà nnɔ, á yàare' uʼñɔbu, a li lɛ bulikbu uʼñɔbu ni. Á taa kí tì pɛ̀ min nin sin bo.» ");
INSERT INTO gngNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","U ya yo nɛ *Yesu ya panpaankaab baa' ki lá niire' wɔ ki ye: «Ŋmɛ yé unikpɛkpiɛk Uwien ya bɛl ni?» ");
INSERT INTO gngNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Nɛ u yin' kibuk kiba, ki taa' kɛ̀ ki sien' biʼsiik ni, ");
INSERT INTO gngNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","nɛ ki ye: «N tɔkeh nɛ imɔ̀n nɛ, na cère' niʼtetem te tɛn mubumu yaam la, na ń kɔ *Uwien ya bɛl ni. ");
INSERT INTO gngNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Unil wà kɛ jiin' uʼba tingi ki te tɛn kibuk kiɛ nɔ te ma bo la, u ya daan nɛ yé unikpɛkpiɛk Uwien ya bɛl ni. ");
INSERT INTO gngNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Wà kɛ teke' kibuk tɛn kiɛ nʼyel bo la, u teke' min nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","«Ama ibaan yà teke' nni ki jin' nɔ, unil cère' iʼni uba tùre' Uwien ya sɛn la, bi bi taa' linɛ̀ciɛnl, ki jɔn' uʼtule ni, ki ture' wɔ ki wiɛ' miñunciɛnm ya lùɔl ni la, nì bi li tu udaan bo. ");
INSERT INTO gngNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Mibiikm yé nibonn nà bre uŋɛndun bo nɛ. Mibiikm lì li tuu ki te nɛ. Ama nì bre unil wà cèreh mibiikm bàareh nnɔ bo. ");
INSERT INTO gngNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","«Aʼnuɔ bii aʼtaal nɛ cèreh a biih la, cere tù kí wiɛ kí jɛnde aʼba saan. A ŋmɔbe unuɔ uba bii litaal liba, ŋɔ ki laa' limiɛl là ŋa ŋmɔbe gbenm la, nì tu nin á li ŋmɔbe inuɔ ile nin itàan ile, ŋɔ kí kɔ umu wà ŋa ń kpiin ni. ");
INSERT INTO gngNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Aʼnunbu nɛ cèreh a biih la, lìkre bù kí wiɛ kí jɛnde aʼba saan. A ŋmɔbe bununbu buba, ki laa' limiɛl là ŋa ŋmɔbe gbenm la, nì tu nin á li ŋmɔbe inun ile, ŋɔ kí kɔ umu wà ŋa ń kpiin ni.» ");
INSERT INTO gngNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","«Li bɛn mɛn ki la yin ibaan yiɛ ya uba fɛnm. N tɔkeh nɛ nɛ, *Uwien ya tondb bà gu bɛ nnɔ tuu ki tiɛn biʼbó nʼBaa wà te paaki bó ya nun bó nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Unil ya Bijɛ baa' uŋɛndun wuu ni wɔ ń lá ŋmiɛn binib bà tùre' Uwien ya sɛn nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","«Unil ŋmɔbe ipe kobk, iʼni uba bole' la, ni maaleh ki teh u li tien mila? Wa ń cère ipe piwɛ nin iwɛ nnɔ kupekpaabaaku ni, kí jo kí tì nuun wà bole' nnɔ-ɔɔ? ");
INSERT INTO gngNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","N tɔkeh nɛ imɔ̀n nɛ, u tì laa' wɔ la, uʼyɛnm li sɔnge upebaab nnɔ bo, kí cɛn ipe piwɛ nin iwɛ yà ŋa bole' nnɔ bo. ");
INSERT INTO gngNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Nnɔ nɛ, niʼBaa wà te paaki bó ŋa yíe ibaan yiɛ ya uba ń tùre.» ");
INSERT INTO gngNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","«Aʼtɔ bii' ŋɛ la, ñikn kí jo kí tì lɛ wɔ niʼlele bo, kí tɔke wɔ uʼbiil. U cii' ki de' ŋɛ la, tigbɛr nnɔ gben' nínɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","U yìe', ka cii' ki de' ŋɛ la, ñikn kí taa unil uba bii bile, kí kpɔbn aʼba bó, kí tí ń jo uʼsaan kí tì lɛ wɔ, ŋɔ ní gben tigbɛr nnɔ, kimɛ nì kɛle' Uwien ya gbɔnku ni ki ye: ‹Bi ye bɛ ń gben tigbɛr tà kɛ la, bi li cenge bimɔ̀nkunb bile bii bita bó nɛ kí yaan kí gben tù.› ");
INSERT INTO gngNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ama u yìe', ka cii' ki de' biʼmɔ la, taa tù kí tɔke *Kristo ya taanl yaab. U yìe', ka cii' ki de' biʼmɔ la, á liike wɔ tɛn unil wà ŋa bɛn Wien bii ulɛnpotekl. ");
INSERT INTO gngNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","«N tɔkeh nɛ imɔ̀n nɛ, ni yìe' nibonn nà kɛ uŋɛndun wuu ni la, bi li yìe nɛ̀ paaki bó mɔ nɛ. Ni tuo' nibonn nà kɛ uŋɛndun wuu ni la, bi li tuo nɛ̀ paaki bó mɔ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","«N tí tɔkeh nɛ imɔ̀n nɛ, niʼni bile kpaan' buñɔbu uŋɛndun wuu ni, ki kàare' ki miɛ' nʼBaa wà te paaki bó nà kɛ la, u li de bɛ nɛ̀ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Kimɛ binib bile bii bita taan' nà saan nʼyel bo la, n te biʼsiik ni.» ");
INSERT INTO gngNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Nɛn saan nɛ Piɛr baa' ki lá niire' wɔ ki ye: «Yonbdaan, nʼtɔ biih nni la, n li fère wɔ bolm miŋɛ nɛ? N li fère wɔ haali bolm milole nɛ-ɛɛ?» ");
INSERT INTO gngNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Nɛ *Yesu jiin' wɔ ki ye: «Na yé á fère wɔ bolm milole; fère wɔ haali pilolole bolm milole. ");
INSERT INTO gngNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","«Nɛn bo, Uwien ya bɛl naan ubɛrciɛn wà yíe wɔ ń bɛnde uʼfaal kpɛ ma uʼtonsɔnb saan nnɔ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","U cin' ma nnɔ, bi taa' ní uʼtonsɔnl uba nɛ, u kɔn' lifɛ̀nl ni uʼcɛnbaa saan ilike tibɔtɔr tibɔtɔr ta dindin. ");
INSERT INTO gngNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Wa ŋmɔbe like kí pɛ̀ lifɛ̀nl nnɔ ma nnɔ, nɛ uʼcɛnbaa ye lifɛ̀nl nnɔ bo, bɛ ń taa wɔn nin uʼpo nin uʼbumu nin u ŋmɔbe tibont tà kɛ kí kuɔre, kí taa ilike ní. ");
INSERT INTO gngNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Nɛ utonsɔnl nnɔ gbaan' uʼcɛnbaa ya nintuɔli, ki gbáanh wɔ ki teh: ‹Nʼcɛnbaa, ñikn kí tien sukle. N li pɛ̀ ŋɛ n kɔn' lifɛ̀nl là ni aʼsaan nnɔ kɛ.› ");
INSERT INTO gngNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Nɛ uʼcɛnbaa muɔ' wɔ micɛcɛkm cɛɛn, ki cɛ̀be' wɔ lifɛ̀nl nnɔ, nɛ ki taa' wɔ ki wiɛ'. ");
INSERT INTO gngNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","«Ama utonsɔnl nnɔ ñɛn' saali, ki laa' uʼtonsɔntɔ uba u ŋmɔbe uʼfɛ̀nl ilike kubɔtuɔku, nɛ u cuo' wɔ, ki sɛre' uʼtule ni, ki tɔke' wɔ ki ye: ‹Pɛ̀ nni a ŋmɔbe nʼfɛ̀nl là nnɔ kɛ.› ");
INSERT INTO gngNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Nɛ uʼtonsɔntɔ nnɔ gbaan' uʼnintuɔli, ki gbáanh wɔ ki teh: ‹Ñikn kí tien sukle. N li pɛ̀ ŋɛ.› ");
INSERT INTO gngNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Nɛ wa tuo', ki cuo' wɔ ki tì pɛkn', wɔ ń li te len haali nin uyo wà u li tì pɛ̀ lifɛ̀nl nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Uʼtonsɔntɔb laa' nì tien' ma, biʼyɛnm saa' ki gbien', nɛ bi jon' ki tì tɔke' biʼcɛnbaa nà kɛ tien'. ");
INSERT INTO gngNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Nɛn saan nɛ biʼcɛnbaa yin' wɔ, ki tɔke' wɔ ki ye: ‹Utonsɔnbiɛrɔ sin! A gbáan' nni ma nnɔ, nɛ n cɛ̀be' ŋɛ aʼfɛ̀nl kɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Aʼmɔ ŋa bi li muɔ aʼtonsɔntɔ micɛcɛkm tɛn n muɔ' ŋɛ ma bo-oo?› ");
INSERT INTO gngNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Uʼcɛnbaa ya benku ni ben' uʼbo, nɛ u cère' bi dɛre' uʼtub ki taa' wɔ ki tì pɛkn', wɔ ń li te len haali nin uyo wà u li tì pɛ̀ lifɛ̀nl nnɔ kɛ kí gben. ");
INSERT INTO gngNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","«Niʼni wà kɛ ŋa fèreh uʼtɔ uʼbiil nin uʼfɛ̀l kɛ la, nʼBaa wà te paaki bó mɔ li dɛre uʼtub nnɔ nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","*Yesu len' ki tì gben' uyo wà nnɔ, nɛ ki ñɛn' Galile ya tinfɛnm ni, ki jon' Sude ya tinfɛnm mà te Sudɛn ya kpenpuol bó nnɔ ni. ");
INSERT INTO gngNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Linigociɛnl paan' uʼbo, nɛ u tì cère' biʼni bà yé biwiɛnb faake'. ");
INSERT INTO gngNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","*Farisiɛnmbɛ biba nɛkn' wɔ, ki yíe bɛ ń biike wɔ, nɛ ki niire' wɔ ki ye: «Ujɛ ŋmɔbe usɛn wɔ ń wiɛ uʼpo maam kɛ maam bo-oo?» ");
INSERT INTO gngNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Nɛ *Yesu jiin' bɛ ki ye: «Na kaan' nà kɛle' *Uwien ya gbɔnku ni nnɔ nɛ-ɛɛ? Nì kɛle' ki ye micincinm Uwien là ñɛn' bɛ ma nnɔ, ‹u là ñɛn' ujɛ nin upii nɛ›, ");
INSERT INTO gngNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","nɛ ki ye: ‹Nɛn nɛ cère' ujɛ kuɔn' upii la, u li dàan uʼnaa nin uʼbaa, wɔn nin uʼpo ń taan, nɛ bɛn bile nnɔ ń taan kí tien unibaab.› ");
INSERT INTO gngNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Nnɔ nɛ ba ji te nib bile, bi ji yé unibaab nɛ. Tɔ, Uwien taan' nà la, nil la bore nɛ̀.» ");
INSERT INTO gngNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Nɛ bi liɛbe' ki niire' wɔ ki ye: «Bɛ tien' Moyis là ye unil ye wɔ ń wiɛ uʼpo la, wɔ ń kɛle kugbɔnku kí de wɔ kí wuɔn kí ye u wiɛ' wɔ nɛ?» ");
INSERT INTO gngNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Nɛ *Yesu ye: «Niʼyufaa bo nɛ cère' Moyis là de' nɛ usɛn ní li wiɛnh niʼpuob. Ama micincinm na là te nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","N tɔkeh nɛ nɛ, ujɛ wà ya po ŋa tien' naŋmaal ŋɔ u wiɛ' wɔ ki tí kuɔn' upiitɔ la, ujɛ nnɔ tien' linaŋmaal nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Nɛ *Yesu ya panpaankaab tɔke' wɔ ki ye: «Ujɛ nin uʼpo ya gbɛr te nnɔ la, ujɛ ŋa bi kuɔn' pii la, nì bi tu.» ");
INSERT INTO gngNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Nɛ *Yesu ye: «Nib kɛ ŋa ń fre kí tien ni len' nà nɔ. Uwien de' bà mituɔm bi la kuɔn piib nnɔ, bɛn nɛ li tuo. ");
INSERT INTO gngNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Isɛn yà cèreh binib ŋa kuɔndeh piib ŋa tɛtɛ. Biba te, bi maa' bɛ, ba yé jɛb. Bitɔb te, bi fàare' bɛ nɛ. Bitɔb mɔ te, ka kuɔndeh piib Uwien ya bɛl ya tuonl bo nɛ. Wà kɛ li fre kí cii la, wɔ ń cii.» ");
INSERT INTO gngNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Nɛn saan nɛ bi tukeh mubumu ki bàareh *Yesu saan ŋɔ wɔ ń taa uʼnuɔ kí paan muʼbo, kí kàare kí de mù. Nɛ uʼpanpaankaab kɔnh nin bɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Nɛ *Yesu tɔke' bɛ ki ye: «Cère mɛn mubumu mù ń li bàareh nʼsaan. La piendeh mù mɛn, kimɛ binib bà te tɛn mubumu nɛ si Uwien ya bɛl.» ");
INSERT INTO gngNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","U taa' uʼnuɔ ki paan' muʼbo ki gben', nɛ ki siere' niʼsaan. ");
INSERT INTO gngNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Tɔ, unacenfaan uba baa' *Yesu saan, ki niire' wɔ ki ye: «Cɛnbaa, n li tien milɛ mɔnm ŋɔ kí lɛ limiɛl là ŋa ŋmɔbe gbenm-i?» ");
INSERT INTO gngNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Nɛ *Yesu jiin' wɔ ki ye: «Bɛ tien' a niireh nni nà mɔn bo? Wà mɔn te uba nɛ. A yíe á lɛ limiɛl là ŋa ŋmɔbe gbenm la, li boh *iwɔb.» ");
INSERT INTO gngNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Nɛ u ye: «I lɛ wɔb-i?» Nɛ *Yesu ye: «La ku nil, ki la teh naŋmaal, ki la suh, ki la nɛndeh nib bo, ");
INSERT INTO gngNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","kí li boh aʼnaa nin aʼbaa, kí li yíe aʼtɔ tɛn a yíe aʼba ma bo.» ");
INSERT INTO gngNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Nɛ unacenfaan nnɔ ye: «N boh niʼkɛ nɛ. Bɛ biɛ ki pɔre' nni?» ");
INSERT INTO gngNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Nɛ *Yesu ye: «A yíe á li yé unimɔ̀n kí tì gben la, jo kí tì kuɔre a ŋmɔbe tibont tà, kí taa ilike kí de bicɛcɛkdɛnb, kí li ŋmɔbe lifaal paaki bó, ŋɔ kí baa kí lá paan nʼbo.» ");
INSERT INTO gngNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Unacenfaan nnɔ cii' nnɔ ma nnɔ, uʼyɛnm saa', nɛ u siere' ki bure', kimɛ u ŋmɔbe lifaal ki gbien'. ");
INSERT INTO gngNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Nɛ *Yesu tɔke' uʼpanpaankaab ki ye: «N tɔkeh nɛ imɔ̀n nɛ, nì faa ki gbien' nin ufàadaan ń kɔ Uwien ya bɛl ni.» ");
INSERT INTO gngNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Nɛ ki ye: «N tí tɔkeh nɛ imɔ̀n nɛ, nì faa nin ufàadaan ń kɔ *Uwien ya bɛl ni ki cɛn' ñɔkma ń càare' mikpɛlpienbonm ni.» ");
INSERT INTO gngNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Uʼpanpaankaab cii' nnɔ ma nnɔ, nì bɛke' bɛ cɛɛn, nɛ bi ye: «Nì te nnɔ la, ŋmɛ li fre kí ŋmɛre?» ");
INSERT INTO gngNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","*Yesu caan' biʼbo inun, nɛ ki tɔke' bɛ ki ye: «Binib nɛ ŋa ń fre, Uwien wɔn ŋa gbɛle' niba.» ");
INSERT INTO gngNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Nɛ Piɛr ye: «Tinbi wɔn la, ti dàan' tiʼbont kɛ nɛ ki paan' aʼbo-a! Ti li lɛ bɛ ya kpɛle?» ");
INSERT INTO gngNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Nɛ *Yesu tɔke' bɛ ki ye: «N tɔkeh nɛ imɔ̀n nɛ, Unil ya Bijɛ lá li kɛ̀le kibɛrbiɛk bo, kí li ŋmɔbe ukpiɛke kí gbien uŋɛndunfaan ni. U ya yo nɛ ninbi bà pɛ nʼbo nnɔ mɔ li kɛ̀le mubɛrbiɛmu piik nin mule bo, kí bu Israyɛl yaab ya baamul piik nin ile nnɔ tibuur. ");
INSERT INTO gngNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Wà kɛ dàan' uʼden bii uʼninjiɛb bii uʼninsiɛb bii uʼnaa bii uʼbaa bii uʼbumu bii uʼkpàan nʼyel bo la, u li lɛ niʼkɛ bolm kobk, ki li lɛ limiɛl là ŋa ŋmɔbe gbenm mɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Bisɛnlierb lá li paan puoli ki yɛbe. Puoli yaab mɔ lá li liere usɛn ki yɛbe.» ");
INSERT INTO gngNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","«Uwien ya bɛl naan ufàadaan wà fii' kutɛnŋɛsɔnsɔnku wɔ ń tì nuun paatieb bɛ ń lá sɔn uʼkpàabu ni ya tuonl nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","U laa' biba, nɛ ki tɔke' bɛ ki ye: ‹N li pɛ̀ nɛ liwentunl ya paaku nɛ›. Bi tuo' nɛ u wuɔn' bɛ uʼkpàabu. ");
INSERT INTO gngNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Uwien pende', nɛ u jon' kidaak bó ki tì laa' bitɔb se kiʼni, ka ŋmɔbe tuonl. ");
INSERT INTO gngNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Nɛ u tɔke' bɛ ki ye: ‹Niʼmɔ ń jo kí tì sɔn nʼkpàabu ni. Ni sɔn ki kpaan' ma bo la, n li pɛ̀ nɛ nnɔ nɛ›, ");
INSERT INTO gngNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","nɛ bi bure'. Liwenyul, nɛ u tí liɛbe' kidaak bó, ki tì laa' bitɔb mɔ se kiʼni, nɛ u tɔke' biʼmɔ nnɔ. Uwien dere', nɛ u tí liɛbe' kidaak bó, ki tí tì tien' nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Uwien mɔ́ndeh uyo wà nnɔ, nɛ u tí liɛbe' kidaak bó, ki tí tì laa' bitɔb mɔ tí se kiʼni, nɛ u tɔke' bɛ ki ye: ‹Bɛ tien' nɛ ni tun' ki se nɔ nnɔ ka sɔnh niba?› ");
INSERT INTO gngNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Nɛ bi ye: ‹Ta laa' wà li de tɛ tuonl nɛ› Nɛ u ye: ‹Niʼmɔ ń li joh kí tì sɔn nʼkpàabu ni.› ");
INSERT INTO gngNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","«Uwien lu' ma nnɔ, nɛ ufàadaan nnɔ tɔke' uʼtonsɔnb ya ciɛn ki ye: ‹Yin paatieb nnɔ ní kí lá pɛ̀ bɛ biʼpaaku. Cin kí li paanh bà paan' puoli bó ní nnɔ kí tì fɔre bà liere' usɛn.› ");
INSERT INTO gngNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Bà baa' liwenmɔ́nl nnɔ baa' bɛ ń lá teke biʼpaaku, nɛ u pɛ̀n' wà kɛ liwentunl ya paaku. ");
INSERT INTO gngNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Bà liere' usɛn nnɔ mɔ baa' bɛ ń lá teke biʼpaaku ki maaleh ki teh bi li lɛ kí gɛ̀bre puoli bó yaab nnɔ nɛ. Nɛ u pɛ̀n' biʼmɔ wà kɛ liwentunl ya paaku. ");
INSERT INTO gngNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Bi teke' biʼpaaku ma nnɔ, nɛ ki kɔnh nin ufàadaan nnɔ ");
INSERT INTO gngNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ki teh: ‹Bà paan' puoli bó nnɔ sɔn' kukurku kuba kpein nɛ. Tinbi ya gbɛn nɛ ben' liwentunŋmɛnl. Kutòntònku nii' tɛ. Nɛ a cère' tinbi nin bɛn ya paaku kpɛ-a!› ");
INSERT INTO gngNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Nɛ ufàadaan nnɔ tɔke' biʼni uba ki ye: ‹Nʼjɔ, ma jin' ŋɛ. A bi tuo' ki ye a li teke liwentunl ya paaku nɛ. Na te nnɔ-ɔɔ? ");
INSERT INTO gngNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Teke aʼlike kí li kunh. N yíe ń de puoli bó yaab tɛn n de' ŋɛ ma bo nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ma ŋmɔbe sɛn ń taa nʼlike kí tien n yíe ma bo-oo? N ŋmɔbe tinimɔ̀nt ma nnɔ nɛ cère' a ŋmɔbe iponponbe-ee?› » ");
INSERT INTO gngNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Tɔ, *Yesu tɔke' ki ye: «Nnɔ nɛ puoli bó yaab lá li liere usɛn, nɛ bisɛnlierb mɔ lá li paan puoli bó.» ");
INSERT INTO gngNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","*Yesu yíe wɔ ń dùo Yerusalɛm bó, nɛ ki taa' uʼpanpaankaab piik nin bile nnɔ, ki ñɛn' ugbɛ. Bi joh ma nnɔ nɛ u tɔkeh bɛ ki teh: ");
INSERT INTO gngNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«Li cengeh mɛn, ti doh Yerusalɛm bó nɛ. Ti tì baa' la, bi li taa Unil ya Bijɛ kí ŋukn bitɔtuɔrciɛnb nin *Yiko ya wɔnwɔknb, bɛ ń bu wɔ tibuur, kí ye u kpɛ bɛ ń ku wɔ, ");
INSERT INTO gngNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","nɛ kí taa wɔ kí ŋukn bà ŋa yé Sufmbɛ, bɛ ń lɛ̀ wɔ, kí ñì wɔ inalɛbe, kí yaan kí kpɛ wɔ udɔpɔnpɔn bo, nɛ wienta daali wɔ ń mɛkre bitɛnkpiib ni.» ");
INSERT INTO gngNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Nɛn saan nɛ Sebede ya bijiɛb bile ya naa taa' bɛ ní *Yesu saan, ki lá gbaan' uʼnintuɔli, ki ye wɔ ń pu wɔ nibonn niba. ");
INSERT INTO gngNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Nɛ u niire' wɔ ki ye: «A yíe ba?» Nɛ u ye: «A lá jin' aʼbɛl la, á cère nʼbijiɛb bile biɛ ń li kɛ aʼsaan. Uba ń li kɛ aʼnɔjie bó, utɔ mɔ aʼnɔgɛn bó.» ");
INSERT INTO gngNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Nɛ *Yesu jiin' bɛ ki ye: «Na bɛn ni miɛh nni nibonn nà. Ni li fre kí ji n li ji ijɛnd yà nnɔ-ɔɔ?» Nɛ bi ye: «Ti li fre.» ");
INSERT INTO gngNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Nɛ u ye: «Imɔ̀n, ni li ji n li ji ijɛnd yà nnɔ. Ama binib bà li kɛ̀le nʼnɔjie bó nin nʼnɔgɛn bó nnɔ wɔn na yé min nɛ li gɛ̀nde bɛ. NʼBaa nɛ li de mifɛnm nnɔ u bonde' mɛ̀ ki ble' binib bà nnɔ.» ");
INSERT INTO gngNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Nɛ uʼpanpaankaab piik bà sìen' nnɔ cii' Sebede ya bijiɛb nnɔ tɔke' *Yesu ki ye bà, nɛ biʼbenku ni ben' biʼbo. ");
INSERT INTO gngNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Nɛ *Yesu yin' bɛ ki tɔke' bɛ ki ye: «Ni bɛn nì te ma uŋɛndun wuu ni. Bà yé idu ya bɛrb nnɔ wɔbndeh iʼnib nɛ, nɛ bà ŋmɔbe ticiɛnt nnɔ wɔngeh bɛ biʼtuɔm kpɛ ma bo. ");
INSERT INTO gngNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Na ń li te nnɔ ninbi ni. Niʼni wà yíe wɔ ń li yé uciɛn la, wɔ ń tien uʼba niʼtonsɔnl. ");
INSERT INTO gngNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Wà yíe wɔ ń li yé usɛnlier la, wɔ ń tien uʼba uʼyonb. ");
INSERT INTO gngNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Kimɛ *Unil ya Bijɛ ŋa baa' uŋɛndun wuu ni bɛ ń sɔn kí de wɔ. U baa' wɔn nɛ ń sɔn kí de binib, kí kpo ŋɔ kí dɛ binib bà yɛbe kí wiɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","*Yesu nin uʼpanpaankaab ñɛh Seriko ya du ni uyo wà nnɔ nɛ linigociɛnl paan' biʼbo. ");
INSERT INTO gngNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ijùɔn ile kɛ sɛngbaal ki cii' bi ye *Yesu nɛ gɛ̀breh, nɛ ì wuureh ki teh: «Yonbdaan, *Dafid ya yaabile, muɔ tɛ micɛcɛkm.» ");
INSERT INTO gngNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Nɛ linigol nnɔ tɛngeh iʼbo ki teh yɛ̀ ń ŋmile, ama ì tùɔreh ki wuureh nɛ ki teh: «Yonbdaan, *Dafid ya yaabile, muɔ tɛ micɛcɛkm.» ");
INSERT INTO gngNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Nɛ *Yesu sere' ki yin' ijùɔn nnɔ, nɛ ki niire' yɛ̀ ki ye: «Ni yíe ń tien bà kí de nɛ?» ");
INSERT INTO gngNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Nɛ ì ye: «Yonbdaan, ti yíe tí likre nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","*Yesu muɔ' yɛ̀ micɛcɛkm cɛɛn, ki mɛ' iʼnun, nɛ ì likre' i ya tàan bo, ki paan' uʼbo. ");
INSERT INTO gngNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","*Yesu nin uʼpanpaankaab tì nɛke Yerusalɛm, ki tuo' Bɛtifaaje ya du, u te Olifi ya siin ya juɔl bó. Bi tì tuo' niʼsaan ma nnɔ, nɛ *Yesu sɔn' uʼpanpaankaab ni bile ");
INSERT INTO gngNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ki tɔke' bɛ ki ye: «Li joh mɛn udu wà te inun bó nɔ ni. Ni tì kɔn' uʼni la, ni li pɔk kí lɛ uŋuunñɔ uba lùo, uʼbuk se uʼsaan. Ní lore wɔ, kí taa wɔn nin uʼbuk kɛ ní. ");
INSERT INTO gngNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Unil ye nɛ niba la, ní ye: ‹Yonbdaan nɛ ciɛke yì.› Bi li pɔk kí cère ní taa yì kí bure nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Nì tien' ŋɔ *Uwien ya ñɔbonsɔknl là len' nà nnɔ nɛ̀ ń tien. Nɛ u là ye: ");
INSERT INTO gngNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«Tɔke mɛn Siyɔn yaab kí ye biʼbɛrciɛn we ní. U te suoo nɛ, ki jɛke uŋuunñɔ nin uʼbuk.» ");
INSERT INTO gngNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Nɛ *Yesu ya panpaankaab bile nnɔ bure', ki tì tien' u len' ma nnɔ, ");
INSERT INTO gngNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","ki tuke' uŋuunñɔ nin uʼbuk nnɔ ki baa' Yesu saan, nɛ ki taa' biʼliɛr ki paan' iʼbo, *Yesu jɛ̀ke'. ");
INSERT INTO gngNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Binib ligol taah biʼliɛr ki pɛ̀reh usɛn ni. Bitɔb mɔ bɛreh tifɛr kí lá pɛ̀reh. ");
INSERT INTO gngNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Nɛ linigol là le usɛn nin là pɛ puoli nnɔ wuureh ki teh: «Osana, *Dafid ya yaabil. Uwien ya mɔnm ń li te wà we ní Yonbdaan ya yel bo nnɔ bo. Osana, Uwien wà te paaki bó.» ");
INSERT INTO gngNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Tɔ, *Yesu tì baa' Yerusalɛm ni ma nnɔ, nɛ udu nnɔ kɛ jènge', binib niireh ki teh: «U lɛ daan bɛ nɛ?» ");
INSERT INTO gngNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Nɛ linigol nnɔ ye: «U yé *Yesu *Uwien ya ñɔbonsɔknl wà ñɛn' Nasarɛt Galile ya tinfɛnm ni nnɔ nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","*Yesu kɔn' Uwien ya duku ya luo bo, nɛ ki ŋɔre' binib bà kuɔreh tiwɛnt nin bà daanh nnɔ kɛ ki ñɛn'. Ki tuture' bilikkpendb ya teb nin bà kuɔreh inɛnjel nnɔ mɔ ya biɛmu ki gbɔ̀be'. ");
INSERT INTO gngNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Nɛ ki tɔke' bɛ ki ye: «Nì kɛle' *Uwien ya gbɔnku ni ki ye: ‹Bi li yin uʼduku ikaare ya duku nɛ, ama ninbi taah kù ki teh binasub ya tantaanbùol nɛ.› » ");
INSERT INTO gngNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Nɛn saan nɛ ijùɔn nin iwɔ̀b bàareh *Yesu saan Uwien ya duku ya luo bo, nɛ u cèreh ì faakreh. ");
INSERT INTO gngNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","*Bitɔtuɔrciɛnb nin *Yiko ya wɔnwɔknb laa' *Yesu tien' miyɔkm ya bont tà nnɔ, ki cii' mubumu wuureh Uwien ya duku ya luo bo ki teh: «Osana, *Dafid ya yaabil» ma nnɔ, nɛ biʼbenku ni ben' uʼbo. ");
INSERT INTO gngNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Nɛ bi tɔke' wɔ ki ye: «Ŋa ciih mubumu muu lienh ki teh ba nɛ-ɛɛ?» Nɛ u ye: «N ciih. Na laan kaan' *Uwien ya gbɔnku ni nì kɛle' nà saan ki ye: ‹Uwien cère' mubumu nin mucɛnfɛndmu pɛ̀keh wɔ nnɔ nɛ-ɛɛ?› » ");
INSERT INTO gngNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","*Yesu len' nnɔ ma nnɔ, nɛ ki siere' ki dàan' bɛ, ki ñɛn' Yerusalɛm ni, ki jon' ki tì gɔn' Betani ya du ni. ");
INSERT INTO gngNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Nì faa', *Yesu liɛbeh Yerusalɛm bó ma nnɔ, nɛ mikònm cuo' wɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","U laa' bukɛnkɛnbu buba se sɛngbaal, nɛ u jon' buʼsaan, ka laa' kɛnkɛn buʼbo. U laa' tifɛr baba nɛ buʼbo, nɛ ki tɔke' bù ki ye: «Ŋa ji li lùon bil fiebu.» Nɛ busubu nnɔ kuore' buʼkɛkɛ i ya tàan bo. ");
INSERT INTO gngNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Uʼpanpaankaab laa' nnɔ ma nnɔ, nɛ nì cuo' bɛ miyɔkm cɛɛn. Nɛ bi ye: «O! Bɛ tien' busubu nnɔ pɔk ki kuore' nɔ nnɔ?» ");
INSERT INTO gngNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Nɛ *Yesu ye: «N tɔkeh nɛ imɔ̀n nɛ, ni teke' Uwien ki jin', ka maaleh milele la, niʼmɔ li fre kí tien nnɔ. Na yé ni li tien nɛn baba nɛ. Ni tɔke' lijuɔl liɛ ki ye lɛ̀ ń fii kí tì lu miñunciɛnm ni la, nì li tien nnɔ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ni miɛ' Uwien nibonn nà kɛ niʼkaare ni, ki teke' ki jin' la, u li de nɛ nɛ̀.» ");
INSERT INTO gngNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","*Yesu kɔn' Uwien ya duku ya luo bo, ki wɔknh binib Uwien ya gbɛr, nɛ bitɔtuɔrciɛnb nin Sufmbɛ ya ciɛnb nɛkn' wɔ ki niire' wɔ ki ye: «A ŋmɔbe usɛn á tien a teh nà nɔ-ɔɔ? Ŋmɛ nɛ de' ŋɛ u ya sɛn-i?» ");
INSERT INTO gngNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Nɛ u tɔke' bɛ ki ye: «Nʼmɔ li niire nɛ iniire iba kpein nɛ. Ni fre' ki jiin' nni la, nʼmɔ li tɔke nɛ n ŋmɔbe usɛn wà ki teh n teh nà nɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","San là siih binib Uwien ya ñunm ma nnɔ, ŋmɛ là de' wɔ usɛn-i? Uwien bii binib-i?» Nɛn saan nɛ bi tɔkeh tɔb ki teh: «Ti ye Uwien nɛ de' wɔ usɛn la, u li niire tɛ kí ye bɛ tien' ta là teke' wɔ ki jin'-i? ");
INSERT INTO gngNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ti tí ye binib nɛ de' wɔ usɛn la, ti fɛnge linigol nnɔ mɔ, kimɛ biʼkɛ maaleh ki teh San là yé *Uwien ya ñɔbonsɔknl nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Nɛ bi jiin' wɔ ki ye: «Ta bɛn.» Nɛ *Yesu mɔ jiin' bɛ ki ye: «Nʼmɔ ŋa bɛn, ka ń tɔke nɛ n ŋmɔbe usɛn wà ki teh n teh nà nɔ mɔ.» ");
INSERT INTO gngNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","*Yesu tí len' ki ye: «Maale mɛn kí liike n li tɔke nɛ nà nɔ ya tingi. Ujɛ uba nɛ là te ki ŋmɔbe bijiɛb bile, nɛ ki tɔke' uciɛn ki ye: ‹Nʼbukɛ, jo kí tì sɔn bukpàabu ni dinnɔ.› Nɛ u ye: ");
INSERT INTO gngNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","‹Ma we.› Nì pukn' waamu, nɛ u lèbre' uʼyɛnmaale ki jon' ukpàabó. ");
INSERT INTO gngNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Nɛ ujɛ nnɔ jon' uwaal saan ki tɔke' mɔ ki ye: ‹Nʼbukɛ, jo kí tì sɔn bukpàabu ni dinnɔ.› Nɛ u ye: ‹Nʼbaa, n li jo,› nɛ ka jon'.» ");
INSERT INTO gngNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Nɛ *Yesu niire' bɛ ki ye: «Mubumu mule nnɔ ni, ki lɛ tien' kiʼbaa yíe nà?» Nɛ bi jiin' ki ye: «Ukpiɛke nnɔ.» Nɛ u ye: «N tɔkeh nɛ imɔ̀n nɛ, *bilɛnpotekb nin ijɛnkpend li kpiɛ kí kɔ Uwien ya *bɛl ni nin nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Kimɛ San baa' ní ki lá wuɔn' nɛ usɛn wà mɔn, nɛ na teke' wɔ ki jin'. Ama bilɛnpotekb nin ijɛnkpend nɛ teke' wɔ ki jin'. Nin ni laa' bi teke' wɔ ki jin' ma kɛ nnɔ na lèbre' niʼtetem, ní teke wɔ kí ji.» ");
INSERT INTO gngNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","«Li cengeh mɛn mikpɛnjɛntɔm. Udendaan uba nɛ là te ki ŋmɔbe bukpàabu, ki caan' bukpàabu nnɔ ni tisir tà bi taah tuʼbii ki ŋɛh fɛn nnɔ, nɛ ki bɛke' ki linde' bù, ki gbin' kubùoku kùa bi li ŋmɛngeh isibii nnɔ buʼni, ki caan' kininbɛntaak buʼni, ki taa' bù ki guun' bikpàab biba, nɛ ki bure' usɛn. ");
INSERT INTO gngNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Uyo wà isibii nnɔ tì ben' nnɔ, nɛ u sɔn' uʼtonsɔnb bikpàab nnɔ saan, bɛ ń tì teke wɔn ukpɛdaan ya bó ní. ");
INSERT INTO gngNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Bitonsɔnb nnɔ tì baa' ma nnɔ, nɛ bikpàab nnɔ cuo' bɛ, ki ñi' uba, ki ku' utɔ, ki yèke' utɔ itɛn. ");
INSERT INTO gngNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Nɛ ukpɛdaan nnɔ tí sɔn' bitonsɔntɔb bi yɛbe ki gɛ̀bre' bikpiɛkb nnɔ. Nɛ bikpàab nnɔ tí tì tien' biʼmɔ nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Nɛ u fɔre' ki sɔn' uʼbijɛ biʼsaan, ki maaleh ki teh u yé uʼbijɛ ma nnɔ, bi li tì bo wɔ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ama bikpàab nnɔ laa' uʼbijɛ we ní ma nnɔ, nɛ bi tɔke' tɔb ki ye: ‹Wɔn nɛ yé uʼfaajil, cère mɛn tí ku wɔ, ŋɔ lifaal nnɔ ń juore tiʼyaal.› ");
INSERT INTO gngNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Nɛ bi cuo' wɔ, ki ñɛn' ukpɛgbɛ, ki tì ku' wɔ.» ");
INSERT INTO gngNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","*Yesu niire' ki ye: «Tɔ, ukpɛdaan nnɔ lá baa' ní uyo wà la, u li tien bikpàab nnɔ mila?» ");
INSERT INTO gngNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Nɛ bitɔtuɔrciɛnb nin Sufmbɛ ya ciɛnb nnɔ jiin' wɔ ki ye: «U li ku bibiɛrdɛnb bugbɛn mikubiɛrm nɛ, kí taa uʼkpàabu nnɔ kí de bikpɛtɔb bɛ ń li dienh wɔ isibii uyo wà u yíe.» ");
INSERT INTO gngNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Nɛ *Yesu ye: «Na kaan' *Uwien ya gbɔnku ni nì kɛle' nà saan ki ye: ‹Litɛnl là bidumɛb wiɛ' lɛ̀ nnɔ, lɛn nɛ lá tien' litɛnkpiɛkl là co kuduku nnɔ nɛ-ɛɛ? Yonbdaan nɛ tien' nnɔ, nɛ nì ŋmɔbe kuñuɔrku tiʼnun bó.› ");
INSERT INTO gngNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","«Nɛn nɛ cère' n tɔkeh nɛ ki teh Uwien li fie uʼbɛl niʼsaan, kí taa lɛ̀ kí de linibol là li teh u yíe nà. ");
INSERT INTO gngNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Wà kɛ lu' litɛnl nnɔ bo la, u li kɔkuɔ nɛ. Litɛnl nnɔ lu' wà bo la, lì li mɛmɛre wɔ nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Bitɔtuɔrciɛnb nin *Farisiɛnmbɛ cii' nnɔ ma nnɔ, nɛ ki bɛnde' ki ye *Yesu tɔkeh bi ya gbɛr nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Nɛ biʼnun mɔ́n bɛ ń cuo wɔ, ama bi fɛnge' linigol nnɔ, kimɛ linigol nnɔ tuo' ki ye *Yesu yé *Uwien ya ñɔbonsɔknl nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","*Yesu tí pɔn' bɛ mikpɛnjɛnm ki ye: ");
INSERT INTO gngNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«Uwien ya *bɛl naan ubɛr wà tien' uʼbijɛ ya piikuɔn, ");
INSERT INTO gngNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","ki sɔn' uʼtonsɔnb bɛ ń tì yin binib bà u yíe bɛ ń baa kí lá ji nnɔ nɛ. Bi yin' bɛ, nɛ bi yìe' ka baa'. ");
INSERT INTO gngNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Nɛ u tí sɔn' bitonsɔntɔb bɛ ń tì tɔke bɛ kí ye u bonde' uʼjier kɛ ki gben'-a. U kòre' uʼnajɛ nin uʼwɛnkobr tà gbenge, ki bonde' tibont kɛ ki gben'-a, ki ye bɛ ń baa ní, ");
INSERT INTO gngNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","nɛ ba tɔnge'. Biba bure' biʼkpàan bó, bitɔb mɔ bure' biʼkpenkpende. ");
INSERT INTO gngNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Bà sìen' nnɔ cuo' bitonsɔnb nnɔ, ki jɛ̀nde' bɛ, ki ku' bɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ubɛr nnɔ ya benku ni ben' ki gbien', nɛ u sɔn' uʼsojambɛ, bi tì ku' binikub nnɔ, ki sɛ' biʼdu. ");
INSERT INTO gngNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Nɛ u tɔke' uʼtonsɔnb ki ye: ‹Upiikuɔn ya jier bonde'-a. Ama binib bà n yin' bɛ nnɔ ŋa kpɛ bɛ ń ji tijier nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Li joh mɛn udu ni nin isɛnnaan, kí tì yin ní ni li lɛ binib bà kɛ, bɛ ń baa kí lá ji upiikuɔn ya jier nnɔ.› ");
INSERT INTO gngNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Nɛ uʼtonsɔnb nnɔ jon' udu ni nin isɛnnaan, ki tì yin' ní bi laa' bà nnɔ kɛ, bà mɔn nin bà bre kɛ. Nɛ bi baa' ki gbe kuduku kùa bi jinh tijier kuʼni nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","«Ubɛr kɔn' wɔ ń liike binib bà baa' bɛ ń ji tijier nnɔ, nɛ ki laa' ujɛ uba ŋa guo upiikuɔn nnɔ ya kpɛlcɛr. ");
INSERT INTO gngNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Nɛ u niire' wɔ ki ye: ‹Nʼjɔ, a tien' mila ki kɔn' ní niɛ saan, ka guo piikuɔn ya kpɛlcɛr-i?› Nɛ wa jiin' wɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Nɛ ubɛr nnɔ tɔke' uʼtonsɔnb ki ye bɛ ń cuo wɔ, kí lòle uʼnuɔ nin uʼtàan, kí ñɛn wɔ kí tì wiɛ saali licinñunl ni. Nɛn saan nɛ u li te ki muɔh, ki ŋmɔnh iñɔgbɛn. ");
INSERT INTO gngNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Kimɛ binib bà Uwien yih bɛ nnɔ yɛbe nɛ, ama u gɛ̀ndeh bà nnɔ nɛ ŋa yɛbe.» ");
INSERT INTO gngNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Tɔ, *Farisiɛnmbɛ jon' ki tì taan' ki gbiere' ki liike' bi li tien ma kí dɛle kí cuo *Yesu miyɛnfuom ni. ");
INSERT INTO gngNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Nɛ ki sɔn' biʼpanpaankaab nin ubɛr Herod yaab ya biba *Yesu saan. Nɛ bi tì tɔke' wɔ ki ye: «Cɛnbaa, ti bɛn ki ye a tɔkeh tigbɛmɔ̀nt nɛ, ki wɔngeh tɛ Uwien ya sɛn mɔnmɔnm, ka fɛnge uba, ka boh uba ki cɛn' utɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Nɛn bo, tɔke tɛ a maaleh ma bo. Ti ŋmɔbe usɛn tí li pɛ̀h lɛnpo ki dienh ubɛrciɛn Sesa bii ta ŋmɔbe?» ");
INSERT INTO gngNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","*Yesu bɛn biʼcekn kpɛ ma bo, nɛ ki tɔke' bɛ ki ye: «Ninbi iñuɔn ilele ya nibɛ, bɛ tien' ni bìkreh nni? ");
INSERT INTO gngNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Wuɔn nni mɛn lɛnpo ya likbu.» Bi taa' milikbim miba ki wuɔn' wɔ nɛ, ");
INSERT INTO gngNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","u niire' bɛ ki ye: «Ŋmɛ ya nɛnnɛnku nin uʼyel te miʼbo?» ");
INSERT INTO gngNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Bi ye: «Ubɛrciɛn Sesa,» nɛ u ye: «Taa mɛn nà yé Sesa yaann kí de Sesa, kí taa nà mɔ yé Uwien yaann kí de Uwien.» ");
INSERT INTO gngNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Bi cii' nnɔ ma nnɔ, nì cuo' bɛ miyɔkm cɛɛn, nɛ bi dàan' wɔ ki bure'. ");
INSERT INTO gngNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Nɛn daali nɛ Saduseyɛnmbɛ biba baa' *Yesu saan. Bɛn nɛ lienh ki teh bitɛnkpiib ŋa ń mɛkre nnɔ. Bi niire' wɔ iniire ");
INSERT INTO gngNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","ki ye: «Cɛnbaa, Moyis là len' ki ye: ‹Unil ya ninjɛ kpo' ki cère' uʼpo, ka ŋmɔbe buk la, wɔ ń kere ukpopii nnɔ, kí maa mubumu kí de uʼninjɛ wà kpo' nnɔ.› ");
INSERT INTO gngNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Tɔ, ninjiɛb bilole biba nɛ là te tiʼni, nɛ ukpiɛk lá kuɔn' upii, ki kpo' ka maa' buk. Nɛ ulie kere' ukpopii nnɔ, ");
INSERT INTO gngNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","ki mɔ kpo' ka maa' buk. Wà tɔ uʼbo nnɔ mɔ tien' nnɔ. Biʼkɛ bilole tien' nnɔ, ki kpo' ka maa' buk. ");
INSERT INTO gngNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Nɛ upii nnɔ mɔ tì tonde' ki kpo'. ");
INSERT INTO gngNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Tɔ, bitɛnkpiib lá mɛkre' uyo wà la, ŋmɛ li si upii nnɔ? Kimɛ biʼkɛ kuɔn' wɔ ki tì bòn' nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Nɛ *Yesu jiin' bɛ ki ye: «Na bɛn nà kɛle' *Uwien ya gbɔnku ni, ka bɛn Uwien ya tuɔm kpɛ ma bo. Nɛn nɛ cèreh ni tùreh. ");
INSERT INTO gngNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Bitɛnkpiib lá mɛkre' la, jɛb ŋa ń kuɔn piib, piib mɔ ŋa ń kun cɛr. Bi li te tɛn *Uwien ya tondb nɛ paaki bó. ");
INSERT INTO gngNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Bitɛnkpiib ya mɛkrm mɛn la, na kaan' Uwien là tɔke' nɛ tigbɛr tà nnɔ nɛ-ɛɛ? ");
INSERT INTO gngNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","U là ye: ‹Min nɛ yé *Abraham nin *Isaak nin *Sakɔb ya Wien.› Uwien ŋa yé tɛnkpiib ya Wien, u yé bà fuobe ya Wien nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Linigol nnɔ cii' *Yesu tɔke' bɛ nnɔ ma nnɔ, nɛ nì cuo' bɛ miyɔkm cɛɛn. ");
INSERT INTO gngNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","*Farisiɛnmbɛ cii' *Yesu len' ki jin' *Saduseyɛnmbɛ, nɛ ki taan' uʼsaan. ");
INSERT INTO gngNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Biʼni bà bɛn yiko mɔnmɔnm nnɔ ya uba, nuunh wɔ ń dɛle kí cuo *Yesu nɛ ki niire' wɔ ki ye: ");
INSERT INTO gngNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«Cɛnbaa, yiko ya gbɔnku ni, li lɛ wɔbl cɛn' wɔbl kɛ wɔbl-i?» ");
INSERT INTO gngNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Nɛ *Yesu tɔke' wɔ ki ye: « ‹Li yíe aʼYonbdaan Uwien nin aʼfɛ̀l kɛ nin aʼtetem kɛ nin aʼyɛnmaale kɛ.› ");
INSERT INTO gngNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Lɛn nɛ yé liwɔbkpiɛkl ki cɛn' wɔbl kɛ wɔbl. ");
INSERT INTO gngNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Liwɔbliel naan likpiɛkl là sɔ: ‹Li yíe aʼtɔ tɛn a yíe aʼba ma bo.› ");
INSERT INTO gngNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Moyis ya gbɔnt kɛ nin *Uwien ya ñɔbonsɔknb là len' nà kɛ nnɔ te iwɔb ile yà ni sɔ.» ");
INSERT INTO gngNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","*Farisiɛnmbɛ taan' ma nnɔ, nɛ *Yesu niire' bɛ ");
INSERT INTO gngNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","ki ye: «Ni maaleh *Uwien ya Nigɛndkɛ Kristo bo ki teh ba? Ŋmɛ ya yaabil si wɔ?» Nɛ bi ye: «*Dafid ya yaabil nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Nɛ u ye: «U yé *Dafid ya yaabil la, nì tien' mila, *Mifuoñaanm là cère' *Dafid yin' wɔ Yonbdaan-i? Kimɛ *Dafid là len' ki ye: ");
INSERT INTO gngNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‹Yonbdaan Uwien tɔke' nʼYonbdaan ki ye: Kɛ̀le nʼnɔjie bó, kí tì baa' uyo wà n li cère á tɛ aʼnɛnnɛndb kɛ bo litaal.› ");
INSERT INTO gngNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","«*Dafid là yin' Uwien ya Nigɛndkɛ Kristo uʼYonbdaan la, u ji tien' mila ki liɛbe' ki yé uʼyaabil-i?» ");
INSERT INTO gngNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","*Yesu len' nnɔ ma nnɔ, uba mɔnɔn ŋa fre' ki laa' ñɔbonl ki jiin' wɔ. Kí ñɛ nɛn daali ma, uba ŋa ji kaabe' ki niire' wɔ niire. ");
INSERT INTO gngNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Nɛn saan nɛ *Yesu tɔke' inigol nin uʼpanpaankaab ki ye: ");
INSERT INTO gngNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«Yiko ya wɔnwɔknb nin *Farisiɛnmbɛ nɛ ŋmɔbe usɛn bɛ ń li tɔkeh Moyis ya yiko ya tingi. ");
INSERT INTO gngNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Nɛn bo, bi tɔkeh nɛ nà kɛ nnɔ, ní li tuonh, kí li teh bi ye ma. Ni nín la sɔnh bi sɔnh ma bo, kimɛ bi lienh nà nnɔ ba teh nɛn. ");
INSERT INTO gngNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Bi lùoh ituk yà kpiɛke nɛ ki cèreh binib tukeh, ama bɛn bugbɛn ŋa toh bɛ ń taa biʼnɔbil mɔnɔn kí mɛ yɛ̀. ");
INSERT INTO gngNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Bi teh biʼbont kɛ binib nɛ ń li ñuɔreh bɛ. Nɛn bo nɛ bi taah Uwien ya gbɛr ya ñɔbon ki teh itil iba ni, ì piɛ ki cɛn' biʼtɔb yɛ, ki ñiɛh ki pìɛndeh biʼliɛr ya ñɔgbɛn. ");
INSERT INTO gngNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Bi yíe bɛ ń li kaah binikpɛkpiɛkb ya kànkàan nɛ tinacent ni, ki yíe bɛ ń li kaah inun bó ya biɛmu bo itáan ya dur ni, ");
INSERT INTO gngNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","ki yíe binib ń li gbaandeh ki fuondeh bɛ mudaamu ni, ki yih bɛ ‹Cɛnbaa›. ");
INSERT INTO gngNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ninbi la li nuunh binib ń li yih nɛ cɛnbaa, kimɛ ni ŋmɔbe Cɛnbaa uba kpein nɛ. Niʼkɛ yé ninjiɛb nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ni la yih uba niʼbaa uŋɛndun wuu ni, kimɛ ni ŋmɔbe Baa uba kpein nɛ, u te paaki bó. ");
INSERT INTO gngNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ni la li nuunh uba ń li yih nɛ uʼciɛn, kimɛ ni ŋmɔbe uciɛn uba kpein nɛ. Wɔn nɛ yé Uwien ya Nigɛndkɛ *Kristo. ");
INSERT INTO gngNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Niʼni wà yé usɛnlier la, wɔ ń li yé niʼtonsɔnl. ");
INSERT INTO gngNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Wà kpiɛke' uʼba la, Uwien li yuɔn wɔ. Wà jiin' uʼba tingi la, Uwien li kpiɛke wɔ.» ");
INSERT INTO gngNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","*Yesu tí len' ki ye: «Ninbi, *Yiko ya wɔnwɔknb nin *Farisiɛnmbɛ, iñuɔn ilele ya nibɛ, nì bre niʼbo, kimɛ ni piindeh bunañɔbu binib la kɔ Uwien ya bɛl ni nɛ. Ninbi ŋa ń kɔ len, ka ń tuo binib bà yíe bɛ ń kɔ nnɔ mɔ ń kɔ.  ");
INSERT INTO gngNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Ninbi *Yiko ya wɔnwɔknb nin *Farisiɛnmbɛ, iñuɔn ilele ya nibɛ, nì bre niʼbo, kimɛ ni jinh ki pendeh bikpopiib, nɛ ki kàareh nì wuɔkreh, ki lɛreh ki teh ni yé binimɔ̀nb nɛ. Nɛn bo nɛ Uwien li dɛre niʼtub kí cɛn u li dɛre binitɔb ya tub ma bo. ");
INSERT INTO gngNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","«Ninbi *Yiko ya wɔnwɔknb nin *Farisiɛnmbɛ, iñuɔn ilele ya nibɛ, nì bre niʼbo, kimɛ ni cuonh niʼkɛ saan, ki puonh ikpen, niʼnun mɔ́n ní lɛ unil uba kpein mɔnɔn kí tien wɔ unil wà pɛ yiko bo nɛ. Ni tì laa' wɔ la, nɛ ni teh wɔ unil wà kpɛ utudɛre umu wà ŋa ń kpiin ni bolm mile ki cɛn' ninbi. ");
INSERT INTO gngNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","«Ninbi bisɛnwuɔnjuɔnbɛ, nì bre niʼbo; ni tɔkeh ki teh: ‹Unil pole' Uwien ya duku la, na yé niba,› ki liɛbe' ki teh: ‹Unil pole' miñɔ̀km mà te kuʼni nnɔ la, wɔ ń tien u pole' ki ye ma nnɔ.› ");
INSERT INTO gngNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ninbi ijɔrjùɔn, ni lɛ bonn cɛn' nitɔnn-i? Miñɔ̀km nnɔ bii Uwien ya duku kùa cère' miñɔ̀km nnɔ yé Uwien yaam-i? ");
INSERT INTO gngNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ni tí tɔkeh ki teh: ‹Unil pole' Uwien ya ponpuol la, na yé niba,› ki liɛbe' ki teh: ‹Unil pole' tibonpukaar tà te liʼbo nnɔ la, wɔ ń tien u pole' ki ye ma nnɔ.› ");
INSERT INTO gngNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ninbi ijùɔn, ni lɛ bonn cɛn' nitɔnn-i? Tibonpukaar nnɔ bii Uwien ya ponpuol là cère' tibonpukaar nnɔ yé Uwien yaar-i? ");
INSERT INTO gngNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Nɛn bo, unil pole' Uwien ya ponpuol la, u pole' Uwien ya ponpuol ki kpɔbn' nà kɛ te liʼbo nnɔ mɔ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Unil pole' Uwien ya duku la, u pole' Uwien ya duku ki kpɔbn' Uwien wà te kuʼni nnɔ mɔ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Unil pole' kutaaku la, u pole' Uwien ya biɛk ki kpɔbn' Uwien wà kɛ̀ kiʼbo nnɔ mɔ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","«Ninbi *Yiko ya wɔnwɔknb nin *Farisiɛnmbɛ, iñuɔn ilele ya nibɛ, nì bre niʼbo, kimɛ ni gbiinh niʼninjo nin niʼkɛn nin niʼmɔsiyuole bolm piik nɛ, ki taah miba ki dienh Uwien, nɛ ki dàandeh nà yé nibonmɔ̀nn yiko nnɔ ni. Nɛn si: tinimɔ̀nt nin micɛcɛkm ya muɔm nin mitekjim mà mɔn. Ni bi li teh nɛn nɛ, ki la sunde tibontɔr tà sìen' nnɔ bó. ");
INSERT INTO gngNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ninbi bisɛnwuɔnjuɔnbɛ, ni cɛh ki ñɛndeh uŋmaŋmaasi nɛ. Ama ki ji ñuh ki kpɔbeh ñɔkmaŋmɛn. ");
INSERT INTO gngNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","«Ninbi *Yiko ya wɔnwɔknb nin *Farisiɛnmbɛ, iñuɔn ilele ya nibɛ, nì bre niʼbo, kimɛ ni ñikndeh ki cɛndeh isɛn nin tiyer ya puoli nɛ. Ama tù gbe ni sun' tibont tà nin niʼnunfɔke cèreh ni lɛnh tà nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ninbi Farisiɛnjuɔnmbɛ, kpiɛ mɛn kí cɛnde tuʼbenku ni, kí yaan tuʼpuoli bó mɔ ń wende. ");
INSERT INTO gngNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","«Ninbi *Yiko ya wɔnwɔknb nin *Farisiɛnmbɛ, iñuɔn ilele ya nibɛ, nì bre niʼbo, kimɛ ni naan ikul yà bi pende' yɛ̀ nɛ. Saali mɔn, nɛ benku ni gbe inikpɔb nin tijɔknt kɛ ya bol. ");
INSERT INTO gngNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Niʼmɔ te nnɔ nɛ. Binib likeh nɛ la, bi teh ni yé binimɔ̀nb nɛ, ama iñuɔn ilele ya gbɛr nin itùonbiɛrɛ nɛ gbe niʼfɛ̀l bo.» ");
INSERT INTO gngNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","«Ninbi *Yiko ya wɔnwɔknb nin *Farisiɛnmbɛ, iñuɔn ilele ya nibɛ, nì bre niʼbo, kimɛ ni mɛh *Uwien ya ñɔbonsɔknb bà là te uyo bo nnɔ ya kul nɛ, ki mɔngreh binimɔ̀nb ya kul, ");
INSERT INTO gngNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","nɛ ki lienh ki teh: ‹Ti bi là te tiʼyaajɛb ya yo la, ta bi li tuo tinbi nin bɛn ń kpaan buñɔbu kí ku *Uwien ya ñɔbonsɔknb.› ");
INSERT INTO gngNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ni lienh nà nnɔ nɛ wɔngeh ki teh ni yé binib bà là ku' *Uwien ya ñɔbonsɔknb nnɔ ya yaabii. ");
INSERT INTO gngNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Niʼyaajɛb là sɔn' itùonbiɛrɛ yà nnɔ, sɔn mɛn kí tonde yɛ̀. ");
INSERT INTO gngNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Iwɛ ninbi, ni yé iwaalɛb nɛ, ni li tien mila kí ñɛ utudɛre wà li tu nɛ umu wà ŋa ń kpiin ni? ");
INSERT INTO gngNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Nɛn bo nɛ n li sɔn *biñɔbonsɔknb nin biyɛnfodɛnb nin *Yiko ya wɔnwɔknb niʼsaan. Ni li ku biba, kí kpɛ bitɔb idɔpɔnpɔn bo, kí ñì bitɔb mɔ inalɛbe niʼtáan ya dur ni, kí li tuɔnh idu ki jɛ̀ndeh bɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Nɛn nɛ cère' Uwien li dɛre niʼtub binib bà bi là ku' bɛ ba bii' niba nnɔ kɛ bo, kí cin unimɔ̀n Abɛl, ki tì baa' Baraki ya bijɛ Sakari, wà ni là ku' wɔ Uwien ya duku ya dubenku nin Uwien ya ponpuol ya sɛsiɛke nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","N tɔkeh nɛ imɔ̀n nɛ, Uwien li dɛre fɛnfɛnnɔ ya nib ya tub tibont nnɔ kɛ bo.» ");
INSERT INTO gngNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Nɛ ki ye: «Yerusalɛm, Yerusalɛm, a kuuleh *Uwien ya ñɔbonsɔknb, ki yèkreh u sɔnh binib bà aʼsaan itɛn ki kuuleh bɛ. Uyo kɛ n là yíe ń taan aʼnib nʼba saan tɛn ukuoñɔ taakeh uʼbumu uʼfiɛbe ni ma bo, nɛ ba tuo'. ");
INSERT INTO gngNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Liike mɛn Uwien sɛln' nɛ niʼkɔnkuɔn ma. ");
INSERT INTO gngNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","N tɔkeh nɛ nɛ, na ji li lɛ nni kí tì baa uyo wà ni li len ki ye: ‹Uwien ya mɔnm ń li te wà we ní Yonbdaan ya yel bo nnɔ bo.› » ");
INSERT INTO gngNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","*Yesu siere' Uwien ya duku ya luo bo ki ñɛn' ki joh, nɛ uʼpanpaankaab nɛkn' wɔ ki wuɔn' wɔ bi mɛn' Uwien ya duku ma bo. ");
INSERT INTO gngNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Nɛ u ye: «Ni laa' tibont tuu kɛ-a? N tɔkeh nɛ imɔ̀n nɛ, kuduku kuu nɔ ya tɛnl liba mɔnɔn ŋa lá li juore kí li pɛ tɔl bo, bi lá li bere kuʼkɛ nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yesu jon' ki tì kɛ̀le' Olifi ya siin ya juɔl bo, nɛ uʼpanpaankaab baa' uʼsaan biʼbaba, ki lá niire' wɔ ki ye: «Tɔke tɛ, tibont nnɔ kɛ lá li tien uyo wà. Ku lɛ dìɛku ba li wuɔn tɛ kí ye nì kpaan' aʼbabaayo nin uŋɛndun ya gbenm-i?» ");
INSERT INTO gngNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Nɛ u jiin' bɛ ki ye: «Li bɛn mɛn, ki la cère uba ń tuln nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Kimɛ binib lá li baa ki yɛbe, kí li ŋmɔbe nʼyel ki teh bi yé Uwien ya Nigɛndkɛ Kristo nɛ, kí tuln binib bi yɛbe. ");
INSERT INTO gngNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ni li cii binib tɔh lituɔl kɔnkɔnm bii fɔnfɔkm. Cuo mɛn niʼba, ki la cère niʼfɛ̀l ń li tiinh, kimɛ ti ya bont kɛ li tien nɛ kí yaan, na laan yé gbengbenyo. ");
INSERT INTO gngNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Linibol liba li jɛ̀ke linibotɔl. Libɛl liba ya nib mɔ li jɛ̀ke libɛtɔl yaab. Mikònm li lu idu ya yɛbe ni, kitink li jènge bùol, bùol. ");
INSERT INTO gngNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Nɛn kɛ li te tɛn imɛrwiɛn ya cincinm nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","«U ya yo nɛ bi lá li cuo nɛ, kí jɛ̀nde nɛ, kí ku nɛ. Min bo nɛ inibol kɛ li nɛn nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","U ya yo nɛ binib bà yɛbe li wiɛ nʼsɛn, kí li kuɔreh tɔb, kí li nɛn tɔb. ");
INSERT INTO gngNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Bitonnɛnñɔbonsɔknb li baa ki yɛbe kí lɛre binib bi yɛbe. ");
INSERT INTO gngNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Itùonbiɛrɛ li yɛbreh ki joh nɛ. Nɛn nɛ li cère binib bà yɛbe ya yíem ń waake. ");
INSERT INTO gngNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ama wà kɛ li mìnde kí li ŋmɔŋmɔbe kí tì fɔre nnɔ, wɔn nɛ li ŋmɛre. ");
INSERT INTO gngNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Bi li kpaande *Uwien ya bɛl ya gbɛmɔnmɔnt tuu uŋɛndun kɛ ni inibol kɛ ń cii, nɛ kí yaan uŋɛndun ń gben.» ");
INSERT INTO gngNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","«Tɔ, ni li lɛ ijuɔke ya bonn nà saah tibont tà kɛ mɔn nnɔ se Uwien ya duku ya dubenku ni tɛn *Uwien ya ñɔbonsɔknl Daniɛl là len' nibonn nnɔ bo ma bo.» (Wà kɛ kàanh la, wɔ ń li ciih niʼtingi.) ");
INSERT INTO gngNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Uyo nnɔ lá baa' la, binib bà te Sude ya tinfɛnm ni nnɔ, bɛ ń sɛn kí jo ijuɔn bó. ");
INSERT INTO gngNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Wà te kudulɛkaaku ya paaki la, u la jiire kí kɔ iden ni, kí taa niba. ");
INSERT INTO gngNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Wà mɔ te ikpàan bó la, u la ji ń liɛbe kí kun, wɔ ń tì taa uʼliɛrgbenku. ");
INSERT INTO gngNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","U ya yo bipiib bà punbe nin bà ŋmɔbe mubumu mùa ŋaanh, li ŋmɔbe micɛcɛkm nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Li kàareh mɛn, Uwien la cère ní sɛn kusɛnañuɔku bii *Saba ya daali. ");
INSERT INTO gngNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Kimɛ binib li ji ijɛnd kí gbien. Haali uŋɛndun ya cincinm, kí lá baa fɛnfɛnnɔ, nib ŋa laan jin' i ya jɛnd ya bol, ka ji lì li ji yɛ̀ fiebu. ");
INSERT INTO gngNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Uwien ŋa bi kùore' ijɛnd nnɔ ya wien bo la, uba mɔnɔn ŋa bi li ŋmɛre. U gɛ̀nde' binib bà nnɔ bo nɛ cère' u kùore' iwien nnɔ bo. ");
INSERT INTO gngNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","«U ya yo unil tɔke' nɛ ki ye: ‹Liike mɛn, *Uwien ya Nigɛndkɛ Kristo te niɛ saan› bii, ‹u te niɛ bó› la, ni la tuo. ");
INSERT INTO gngNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Kimɛ bitonnɛnmɔ̀nkunb li baa. Biba li ye bi yé Uwien ya Nigɛndkɛ Kristo nɛ. Bitɔb li ye bi yé *Uwien ya ñɔbonsɔknb nɛ. Bi li tien micincilnm ya bont nin miyɔkm ya bont, kí tuln binib. Bi li nuunh nì tuo' la, bɛ ń tuln Uwien gɛ̀nde' binib bà nnɔ mɔnɔn nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Li bɛn mɛn, n kpiɛ' ki tɔke' nɛ tigbɛr nnɔ ŋɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","«Nɛn bo, bi tɔke' nɛ ki ye: ‹Liike mɛn *Kristo te kupenpelku ni› la, la jo mɛn. Bi tí tɔke' nɛ ki ye: ‹U buɔ niɛ saan› la, la teke mɛn kí ji. ");
INSERT INTO gngNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Utɛmɛknde ñɛh lɛnpuoli bó ki tì bàareh nintuɔli bó ma bo nnɔ, Unil ya Bijɛ ya baam mɔ lá li te nnɔ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","«Liwɛnkpil te nà saan la, inɛnyobl taakeh nɛn saan nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","«I ya dɛn ya jɛnd gɛ̀bre' la, i ya tàan bo, ‹uwien li biike, uŋmaal ŋa ji li wien, iŋmaabii li cecere kí lu, tibont tà ŋmɔbe mituɔm paaki bó li jènge.› ");
INSERT INTO gngNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","U ya yo bi li lɛ Unil ya Bijɛ ya dìɛku te paaki bó ní. Nɛ inibol yà kɛ te utingbɛn bo nnɔ ń muɔ kí kpiɛnde. Bi li lɛ *Unil ya Bijɛ te titɛwɔlgbɔnt ni ki we ní, ki ŋmɔbe ukpiɛke nin ufaa ki gbien'. ");
INSERT INTO gngNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Linatunciɛnl li muɔ uyo wà nnɔ, u li sɔn uʼtonsɔnb Uwien ya tondb bɛ ń jo lɛnpuoli nin nintuɔli nin ugɛn nin ujie bó, kí cin utingbaan uba kí tì baa utɔ, kí taan Uwien gɛ̀nde' binib bà nnɔ kɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","«Bukɛnkɛnbu ya tetem yé mikpɛnjɛnm nɛ niʼbo. Ni lá laa' bù tɔh isigben ki teh tifɛr la, ni bɛn ki ye nì nɛke uñalɛnd nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Nnɔ nɛ, ni lá laa' nɛn kɛ la, ní li bɛn kí ye *Unil ya Bijɛ nɛkn' niʼnañuɔn saan ŋɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","N tɔkeh nɛ imɔ̀n nɛ, tibont nnɔ kɛ li tien kí lɛ fɛnfɛnnɔ ya nib biɛ ŋa laan kpo' ki gben'. ");
INSERT INTO gngNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Kutaaku nin kitink li gben. Ama nʼgbɛr tun ŋa ŋmɔbe tù ń gben.» ");
INSERT INTO gngNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","«Ama uba ŋa bɛn tibont nnɔ li tien lidaali là bii uyo wà. Paaki bó, Uwien ya tondb ŋa bɛn. UʼBijɛ mɔ ŋa bɛn, Uwien Baa baba nɛ bɛn. ");
INSERT INTO gngNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","*Nowe ya yo là te ma bo nnɔ, Unil ya Bijɛ ya baam mɔ lá li te nnɔ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Nowe ya yo, uyo wà miwuɔm ŋa laan là jin' kitink nnɔ, binib là jinh nɛ ki ñuh, bijɛb kuɔndeh bipiib, bipiib mɔ kunh ticɛr, ki tì baa' lidaali là Nowe kɔn' buñɛrciɛnbu. ");
INSERT INTO gngNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ba là bɛn ki ye niba li tien bɛ, ki tì baa' uyo wà miwuɔm kun' nin biʼkɛ. Uyo wà Unil ya Bijɛ lá li baa ní nnɔ, nì li te nnɔ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","U ya yo, bijɛb bile li bɔ bukpàabu ni, bi li taa uba kí dàan utɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Bipiib bile li nàanh unɛgɔn uba bo, bi li taa uba kí dàan utɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Nɛn bo, la gɔh mɛn, kimɛ na bɛn lidaali là Yonbdaan li baa ní. ");
INSERT INTO gngNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ni bɛn ki ye ududaan bi bɛn uyo wà unasu li baa la, wa bi li dɔ ki gɔh, u bi li kɛ ki gu nɛ nasu la kɔ uʼden. ");
INSERT INTO gngNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Nɛn bo, niʼmɔ ń bonde kí li gu, kimɛ uyo wà na maaleh ki teh Unil ya Bijɛ li baa ní nnɔ, u ya yo nɛ u li baa ní.» ");
INSERT INTO gngNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","«U lɛ tonsɔnl ba nɛ ŋmɔbe mibɛnm uʼcɛnbaa du uʼbo? Wɔn si: wà ya cɛnbaa de' wɔ ticiɛnt wɔ ń li likeh uʼden yaab, kí li loh bɛ tijier uyo wà nì kpɛ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Utonsɔnl nnɔ ya cɛnbaa baa' ki laa' u sɔnh lituonl nnɔ liʼdonbó la, Uwien ya mɔnm li te utonsɔnl bugbɛn bo. ");
INSERT INTO gngNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","N tɔkeh nɛ imɔ̀n nɛ, uʼcɛnbaa li de wɔ ticiɛnt wɔ ń li likeh uʼbont kɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ama utonsɔnl nnɔ bre la, u li maale uʼfɛ̀l ni kí ye uʼcɛnbaa li wuɔke, ");
INSERT INTO gngNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","nɛ kí cin kí li ñih uʼtonsɔntɔb, ki pɛ bidɛyib bo, ki jinh, ki ñuh. ");
INSERT INTO gngNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Utonsɔnl nnɔ ya cɛnbaa li baa ní lidaali là nin uyo wà wa maaleh ki teh u li baa ní. ");
INSERT INTO gngNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","U li bien uʼgbɛnɛnt cɛɛn kí cère wɔ ń lɛ iñuɔn ilele ya nib li lɛ utudɛre wà nnɔ. Nɛn saan nɛ u li te ki muɔh, ki ŋmɔnh iñɔgbɛn.» ");
INSERT INTO gngNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","«Tɔ, Uwien ya bɛl li naan bijɛfɛ̀nb piik bà taa' biʼfr, bɛ ń tì tuobe wà ŋmɔbe upiikuɔn nnɔ usɛn bó nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Biʼni biŋun yé ijɔr, nɛ biŋun mɔ yé biceknb. ");
INSERT INTO gngNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ijɔr nnɔ taa' biʼfr, ka tuke kpɔm. ");
INSERT INTO gngNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Biceknb nnɔ taa' biʼfr, ki tuke mikpɔm mɔ ki kpaabe. ");
INSERT INTO gngNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Piicɛ nnɔ wuɔke' ma nnɔ, migùɔnm cuo' bɛ nɛ bi gùɔn'. ");
INSERT INTO gngNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","«Kuyɔku ya siik, nɛ bi cii' bi wuureh ufaa bo ki teh: ‹Liike mɛn, piicɛ nɛkn' ní ŋɔ. Ñɛ mɛn kí tuobe wɔ usɛn bó.› ");
INSERT INTO gngNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Nɛ bijɛfɛ̀nb piik nnɔ kɛ fìnde', ki bondeh biʼfr. ");
INSERT INTO gngNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Nɛn saan nɛ ijɔr iŋun nnɔ tɔke' biceknb biŋun nnɔ ki ye: ‹Pu tɛ mɛn mikpɔm, tiʼfr benh yɛ̀ ń kpiin nɛ.› ");
INSERT INTO gngNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Nɛ biceknb nnɔ ye: ‹Nì yé fɛnm! Tiʼkpɔm ŋa ń baa tinbi nin ninbi kɛ. Li joh mɛn bà kuɔreh mikpɔm saan kí tì dɛ.› ");
INSERT INTO gngNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Bi bure' bɛ ń tì dɛ, nɛ piicɛ baa' ní. Nɛ biceknb biŋun bà bonde' nnɔ paan' piicɛ nnɔ bo, ki kɔn' bi teh nà saan upiikuɔn nnɔ, nɛ bi pìin'. ");
INSERT INTO gngNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","«Tɔ, ijɔr nnɔ mɔ lá baa' ní, nɛ ki ye: ‹Cɛnbaa, Cɛnbaa, pìire tí kɔ.› ");
INSERT INTO gngNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Nɛ u tɔke' bɛ ki ye: ‹N tɔkeh nɛ imɔ̀n nɛ, ma bɛn nɛ.› ");
INSERT INTO gngNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","«Nɛn bo, la gɔh mɛn! Kimɛ na bɛn lidaali là bii uyo wà nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","«*Uwien ya bɛl tí naan ujɛ wà joh usɛn, ki yin' uʼtonsɔnb ki taa' uʼfaal ki de' bɛ nnɔ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","U taa' milikbim itur iŋun ki de' uba, ki taa' itur ile ki de' utɔ, ki taa' liturl liba ki de' utɔ mɔ. U de' biʼkɛ bi li fre kí sɔn ma bo nɛ, nɛ ki pɔk ki siere' ki bure'. ");
INSERT INTO gngNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Wà teke' itur iŋun nnɔ, i ya tàan bo nɛ u tien' ukpenkpende, ki laa' kpɛle itur iŋun ki pukn'. ");
INSERT INTO gngNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Wà teke' itur ile nnɔ mɔ tien' ukpenkpende ki laa' kpɛle itur ile ki pukn'. ");
INSERT INTO gngNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ama wà teke' liturl liba nnɔ jon' ki tì gbin' kubùoku, nɛ ki taa' uʼcɛnbaa ya likbim nnɔ ki subn'. ");
INSERT INTO gngNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","«Nì tete, nɛ bitonsɔnb nnɔ ya cɛnbaa lá liɛbe' ní, ki yíe wɔ ń bɛnde uʼfaal kpɛ ma biʼsaan. ");
INSERT INTO gngNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Nɛ utonsɔnl wà là teke' itur iŋun nnɔ tuke' ní, itur iŋun ki pukn', ki lá tɔke' wɔ ki ye: ‹Cɛnbaa, a là de' nni itur iŋun nɛ. Liike, nʼmɔ tien' ukpenkpende ki laa' kpɛle itur iŋun ki pukn', yin sɔ.› ");
INSERT INTO gngNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Nɛ uʼcɛnbaa ye: ‹Nì mɔn, a yé utonsɔnmɔnmɔn nɛ, ki sɔn' lituonl mɔnmɔnm. A tien' mɔnmɔnm tibont tà waa ni. N li tien ŋɛ tibont tà yɛbe ya ciɛn. Dɛn kí li poknh nin nni.› ");
INSERT INTO gngNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Nɛ utonsɔnl wà là teke' itur ile nnɔ mɔ tuke' ní, ki lá tɔke' wɔ ki ye: ‹Cɛnbaa, a là de' nni itur ile nɛ. Liike, nʼmɔ tien' ukpenkpende ki laa' kpɛle itur ile ki pukn', yin sɔ.› ");
INSERT INTO gngNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Nɛ uʼcɛnbaa ye: ‹Nì mɔn, a yé utonsɔnmɔnmɔn nɛ, ki sɔn' lituonl mɔnmɔnm. A tien' mɔnmɔnm tibont tà waa ni. N li tien ŋɛ tibont tà yɛbe ya ciɛn. Dɛn kí li poknh nin nni.› ");
INSERT INTO gngNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Nɛ utonsɔnl wà là teke' liturl liba nnɔ mɔ tuke' ní, ki lá tɔke' wɔ ki ye: ‹Cɛnbaa, n bɛn aʼbó aʼgbɛr faa nɛ. Ŋa bule' nà saan la, a ceh nɛn saan nɛ. Ŋa cokn' nà saan la, a woreh nɛn saan nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Nɛn nɛ cère' n sɛn' bujɛwaanbu, ki taa' aʼlikbim, ki gbin' kubùoku ki subn'. Liike, aʼlikbim sɔ.› ");
INSERT INTO gngNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Nɛ uʼcɛnbaa ye: ‹Utonsɔnbiɛrɔ sin, ukpaayuon sin, a len' ki ye a bɛn nʼbó, ki ye ma bule' nà saan la, n ceh nɛn saan nɛ, ma cokn' nà saan la, n woreh nɛn saan nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","A bɛn nnɔ ma nnɔ, bɛ tien' ŋa nín taa' nʼlikbim ki tì ble' banki ŋɔ n lá baa ní la, ń lɛ nʼlikbim nin kpɛle kí pukn-i?› ");
INSERT INTO gngNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Nɛ ki ye: ‹Fie mɛn uʼturl liba nnɔ, kí taa kí pukn wà ŋmɔbe itur piik nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Kimɛ wà kɛ ŋmɔbe la, bi li pukn wɔn nɛ, wɔ ń li ŋmɔbe ki gbien'. Wà ŋa ŋmɔbe la, bi li tonde kí fie u ŋmɔbe nà waamu nnɔ mɔnɔn nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Utonsɔnbiɛrɔ wuɔ wɔn, wa ŋmɔbe kpɛle; ñɛn wɔ mɛn kí tì wiɛ saali licinñunl ni. Nɛn saan nɛ u li te ki muɔh, ki ŋmɔnh iñɔgbɛn.› » ");
INSERT INTO gngNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","«*Unil ya Bijɛ li baa ní, ki li tɔke nin Uwien ya tondb kɛ. U ya yo nɛ u li ŋmɔbe ukpiɛke ki gbien', kí kɛ̀le uʼbɛrbiɛk bo tɛn ubɛrciɛn. ");
INSERT INTO gngNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Bi li taan uŋɛndun ya nib kɛ uʼnun bó, nɛ wɔ ń bore bɛ tɛn upekpaal boreh ipe nin iwɔ̀b ma bo, ");
INSERT INTO gngNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","kí taa ipe kí jon nʼnɔjie bó, kí taa iwɔ̀b kí jon uʼnɔgɛn bó. ");
INSERT INTO gngNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Nɛn saan nɛ ubɛrciɛn li tɔke bà te uʼnɔjie bó nnɔ kí ye: ‹Ninbi bà nʼBaa tien' nɛ uʼmɔnm nnɔ, dɛn mɛn kí lá ji libɛl là u là bonde' lɛ̀ ki ble' nɛ haali uŋɛndun ya cincinm nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Kimɛ mikònm là cuo' nni, nɛ ni de' nni tijier n jin'. Uñuñun là cuo' nni, nɛ ni de' nni miñunm n ñun'. N là yé ucaan, nɛ ni teke' nni. ");
INSERT INTO gngNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","N là te liñil, nɛ ni de' nni tiwɛngolkaar n gole'. N là bun, nɛ ni baa' ki lá fuonde' nni. N là te lipɛkl ni, nɛ ni baa' nʼsaan.› ");
INSERT INTO gngNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Nɛ binimɔ̀nb nnɔ li niire nni kí ye: ‹Yonbdaan, u lɛ yo ba nɛ ti là laa' ŋɛ mikònm ŋmɔbe ŋɛ, ti de' ŋɛ a jin'-i? Ki laa' ŋɛ uñuñun ŋmɔbe ŋɛ, ti de' ŋɛ a ñun'-i? ");
INSERT INTO gngNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ki laa' ŋɛ a yé ucaan, ti teke' ŋɛ? Ki laa' ŋɛ a te liñil, ti de' ŋɛ tiwɛngolkaar a gole'? ");
INSERT INTO gngNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ki laa' ŋɛ a bun bii a te lipɛkl ni, ti baa' ki lá fuonde' ŋɛ?› ");
INSERT INTO gngNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Nɛ ubɛrciɛn li jiin bɛ kí ye: ‹N tɔkeh nɛ imɔ̀n nɛ, ni là tien' nnɔ ki de' nʼyaab ibaan nnɔ ma nnɔ, ni tien' ki de' min nɛ.› ");
INSERT INTO gngNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","«Nɛ kí tɔke bà te nʼnɔgɛn bó nnɔ kí ye: ‹Ninbi bà Uwien wiɛ' nɛ miŋùum nnɔ, jɛnde mɛn nʼsaan, kí tì kɔ Uwien sɛ̀re' umu wà wa ń kpiin, ki ble' usɛnpol nin uʼtondb nnɔ ni. ");
INSERT INTO gngNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Kimɛ mikònm là cuo' nni, nɛ na de' nni jier n jin'. Uñuñun là cuo' nni, nɛ na de' nni ñunm n ñun'. ");
INSERT INTO gngNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","N là yé ucaan, nɛ na teke' nni. N là te liñil, nɛ na de' nni wɛngolkaar n gole'. N là bun bii n là te lipɛkl ni, nɛ na baa' ki lá fuonde' nni.› ");
INSERT INTO gngNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Nɛ biʼmɔ li niire nni kí ye: ‹Yonbdaan, u lɛ yo ba nɛ ti là laa' ŋɛ, mikònm ŋmɔbe ŋɛ bii uñuñun ŋmɔbe ŋɛ bii a yé ucaan bii a te liñil bii a bun bii a te lipɛkl ni, nɛ ta tore' ŋɛ?› ");
INSERT INTO gngNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Nɛ n li jiin biʼmɔ kí ye: ‹N tɔkeh nɛ imɔ̀n nɛ, na là tore' nʼyaab ibaan nnɔ ma nnɔ, na tore' min nɛ.› ");
INSERT INTO gngNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Bi li lɛ utudɛre wà ŋa ŋmɔbe gbenm. Ama binimɔ̀nb nnɔ bɛn li lɛ limiɛl là ŋa ŋmɔbe gbenm nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Uyo wà *Yesu len' niʼkɛ ki tì gben' nnɔ nɛ ki tɔke' uʼpanpaankaab ki ye: ");
INSERT INTO gngNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«Ni bɛn ki ye iwien ile gɛ̀bre' la, tinbi Sufmbɛ li jele tiʼPak ya nacenku. U ya yo nɛ bi li taa Unil ya Bijɛ kí ŋukn binib, bɛ ń tì kpɛ wɔ udɔpɔnpɔn bo.» ");
INSERT INTO gngNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Tɔ, bitɔtuɔrciɛnb nin Sufmbɛ ya ciɛnb taan' bitɔtuɔrciɛnb ya ciɛn Kayif den u luo bo ");
INSERT INTO gngNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ki kpaan' iyɛ ki ye bi li bɔle nɛ kí cuo Yesu, kí ku wɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Nɛ ki tɔkeh tɔb ki teh: «Ti la cuo wɔ mɛn kunacenku nnɔ ya yo. Ti cuo' wɔ u ya yo la, udu ya nib li kpre.» ");
INSERT INTO gngNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","*Yesu là te Betani ya du ni, Simɔn, ujend den. ");
INSERT INTO gngNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","U jinh uyo wà nnɔ nɛ upii uba kɔn' ní ki tuke lɛfina uba uʼdaaku faa cɛɛn alabaat ya dingl ni, bi yih lɛfina nnɔ naar. Upii nnɔ taa' lɛfina nnɔ kɛ ki wuwule' *Yesu ya yul bo. ");
INSERT INTO gngNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Uʼpanpaankaab laa' nnɔ ma nnɔ nɛ biʼbenku ni ben', nɛ bi ye: «Bɛ tien' u ñɛ̀nde' lɛfina wuɔ nɔ? ");
INSERT INTO gngNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ti bi li fre kí kuɔre wɔ kí lɛ ilike yì ń li yɛbe kí taa kí de bijiinb-a!» ");
INSERT INTO gngNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","*Yesu bɛnde' bi lienh nà bo, nɛ ki tɔke' bɛ ki ye: «Bɛ tien' ni ŋaabeh upii wuɔ ya yɛnm nɔ nnɔ? U tien' nni nà mɔn nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Bijiinb lì li te niʼsaan uyo kɛ nɛ; ama min ŋa ń li te niʼsaan uyo kɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","U taa' lɛfina wuɔ ki wule' nʼgbɛnɛnt bo ma nnɔ, u bonde' nʼsubm nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","N tɔkeh nɛ imɔ̀n nɛ, bi li kpaande tigbɛmɔnmɔnt tuu uŋɛndun ni nà saan kɛ nnɔ, bi li len u tien' nà nɔ bó, ŋɔ binib ń li tiɛn uʼbó.» ");
INSERT INTO gngNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","*Yesu ya panpaankaab piik nin bile ya uba, bi yih wà Sudas Iskariyɔt nnɔ jon' *bitɔtuɔrciɛnb saan, ");
INSERT INTO gngNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ki tì niire' bɛ ki ye: «N taa' *Yesu ki ŋukn' nɛ la, ni li de nni ba?» Nɛ bi kaan' ilike ya kur pita ki de' wɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Nɛn daali nɛ u cin' ki nuunh u li ñɛ isɛn yà kí taa *Yesu kí ŋukn bɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Kpɔnɔ wà ŋa ŋmɔbe ñɔke ya nacenku ya cincindaali, nɛ *Yesu ya panpaankaab nɛkn' wɔ ki niire' wɔ ki ye: «A yíe tí tien ŋɛ Pak ya nacenku ya jier lɛ saan-i?» ");
INSERT INTO gngNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Nɛ u jiin' bɛ ki ye: «Ní jo udu bó udaan uba saan, kí tì tɔke wɔ ki ye: ‹TiʼCɛnbaa ye uʼyo baa'-a, wɔn nin uʼpanpaankaab li baa kí lá ji Pak ya nacenku ya jier a ya den nɛ.› » ");
INSERT INTO gngNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Nɛ uʼpanpaankaab tien' u tɔke' bɛ ma bo, nɛ ki tien' kunacenku nnɔ ya jier. ");
INSERT INTO gngNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Nì juɔre' nɛ *Yesu nin uʼpanpaankaab piik nin bile nnɔ kɛ̀le' ki jinh. ");
INSERT INTO gngNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Bi jinh uyo wà nnɔ, nɛ u tɔke' bɛ ki ye: «N tɔkeh nɛ imɔ̀n nɛ, niʼni uba li kuɔre nni.» ");
INSERT INTO gngNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Biʼyɛnm saa' ki gbien', nɛ biʼkɛ niireh wɔ jɛjɛ ki teh: «Yonbdaan, n teh min ŋa ñí-a?» ");
INSERT INTO gngNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Nɛ u ye: «Min nin wà taan' ki paan' lisɛnl ni nɔ nɛ li kuɔre nni. ");
INSERT INTO gngNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Unil ya Bijɛ li kpo tɛn nì kɛle' uʼbo *Uwien ya gbɔnku ni ki ye ma bo nnɔ nɛ. Ama unil wà li kuɔre wɔ nnɔ, nì bre udaan bo. Ba bi maa' wɔ mɔnɔn la, nì bi li tu.» ");
INSERT INTO gngNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Nɛ Sudas wà li kuɔre wɔ nnɔ mɔ niire' wɔ ki ye: «Cɛnbaa, n teh min ŋa ñí-a?» Nɛ *Yesu ye: «A ye nnɔ.» ");
INSERT INTO gngNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Bi te ki jinh tijier ma nnɔ, nɛ *Yesu yuure' kpɔnɔ, ki faare' Uwien, ki kɔkuɔ', ki taa' ki de' bɛ, ki ye: «Teke mɛn kí ŋmɔn, nà sɔ yé nʼgbɛnɛnt.» ");
INSERT INTO gngNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Nɛ ki taa' midaam mɔ, ki faare' Uwien, ki taa' ki de' bɛ, ki ye: «Niʼkɛ ń ñu mɛn, ");
INSERT INTO gngNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","nà sɔ yé nʼsɛ̀m. Mɛn nɛ wɔngeh ki teh Uwien cuo' nin binib kujɔtieku. Mì li puube binib bà yɛbe ya kpɛle bo ŋɔ Uwien ń fère bɛ biʼbiɛre. ");
INSERT INTO gngNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","N tɔkeh nɛ nɛ, ma ji li faa kí ñu daam, haali kí tì baa lidaali là min nin ninbi li liɛbe kí taan kí ñu mɛ̀ midɛfɛ̀nm nʼBaa ya bɛl ni.» ");
INSERT INTO gngNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Bi gɛn' Uwien ya yuon ki gben', nɛ ki ñɛn' ki don' Olifi ya siin ya juɔl bo. ");
INSERT INTO gngNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Tɔ, *Yesu tɔke' uʼpanpaankaab ki ye: «Kuñɔnku kuu nɔ, nà li tu nni nnɔ li cère niʼkɛ ń sɛn kí dàan nni, kimɛ nì kɛle' *Uwien ya gbɔnku ni ki ye: ‹N li ku upekpaal, nɛ upepɛke kɛ ń yɛre.› ");
INSERT INTO gngNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ama uyo wà n li mɛkre bitɛnkpiib ni nnɔ, n li liere nɛ kí jo Galile.» ");
INSERT INTO gngNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Nɛ Piɛr tɔke' wɔ ki ye: «Nà li tu ŋɛ nnɔ li cère biʼkɛ ń sɛn kí dàan ŋɛ mɔnɔn la, min ŋa ń sɛn kí dàan ŋɛ fiebu.» ");
INSERT INTO gngNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Nɛ *Yesu ye: «N tɔkeh ŋɛ imɔ̀n nɛ, kuñɔnku kuu, a li niɛ bolm mita kí ye ŋa bɛn nni nɛ kí yaan ukuojɛ ń muɔ.» ");
INSERT INTO gngNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Nɛ Piɛr ye: «Haali bi li ku min nin sin kɛ mɔnɔn la, ma ń niɛ kí ye ma bɛn ŋɛ.» Nɛ uʼpanpaankaab kɛ mɔ len' nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Tɔ, *Yesu nin uʼpanpaankaab tì baa' niba saan, bi yih nɛ̀ Gɛtsemani. Nɛ u tɔke' bɛ ki ye: «Juore mɛn niɛ saan, ń jɛnde kí tì kàare.» ");
INSERT INTO gngNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Nɛ ki taa' Piɛr nin Sebede ya bijiɛb bile ki bure'. Bujɛwaanbu cin' ki kɔh wɔ nɛ uʼyɛnm saah, ");
INSERT INTO gngNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","nɛ u tɔke' bɛ ki ye: «Nʼyɛnm saa' ki tì kɛnde' tɛn mikuum nɛ benh nin nni. Niʼmɔ ń juore niɛ saan, ki la gɔh.» ");
INSERT INTO gngNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","U jɛnde' waamu, nɛ ki pùon', ki kàareh ki teh: «O, nʼBaa, nì tuo' la, á cère ijɛnd yiɛ ń jɛnde nni. Ama la cère nɛ̀ ń li yé min yíe ma bo, cère nɛ̀ ń li yé sin yíe ma bo.» ");
INSERT INTO gngNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","U liɛbe' ní uʼpanpaankaab bita nnɔ saan, ki laa' bi dɔ ki gɔh nɛ, nɛ u tɔke' Piɛr ki ye: «O! Na ń fre kí la gùɔn kukurku kuba mɔnɔn-ii? ");
INSERT INTO gngNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","La gɔh mɛn, kí li kàareh ŋɔ ki la lu biikm ni. Niʼyɛnm yíe, ama mituɔm nɛ pɔre' nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Nɛ ki tí jɛnde' waamu, ki kàare' nle bo ki ye: «O, nʼBaa, na ń tuo á jɛnde nʼsaan ijɛnd yiɛ nɔ la, cère aʼyíem ń tien.» ");
INSERT INTO gngNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","U tí liɛbe' ní uʼpanpaankaab bita nnɔ saan, ki laa' bi tí gɔh nɛ, kimɛ migùɔnm nɛ ñɔ̀nde' bɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Nɛ u dàan' bɛ, ki tí jɛnde' waamu, nɛ ki kàare' nta bo nin i ya ñɔbonbaab. ");
INSERT INTO gngNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","U tí liɛbe' ní uʼpanpaankaab nnɔ saan, nɛ ki tɔke' bɛ ki ye: «Ni biɛ ki fuoreh nɛ ki gɔh-a! Uyo nɛkn' ní ŋɔ! Bi li taa Unil ya Bijɛ kí ŋukn bibiɛrdɛnb. ");
INSERT INTO gngNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Fii mɛn tí jo. Liike mɛn, wà kuɔre' nni nnɔ nɛkn' ní ŋɔ.» ");
INSERT INTO gngNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","U laan biɛ ki lienh nɛ Sudas uʼpanpaankaab piik nin bile nnɔ ya uba baa' ní nin linigociɛnl bi tuke mujusiemu nin ilɛnbɛn. Bitɔtuɔrciɛnb nin Sufmbɛ ya ciɛnb nɛ sɔn' bɛ ní. ");
INSERT INTO gngNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Sudas wà kuɔre' *Yesu nnɔ tɔke' linigol nnɔ ki ye: «Ni lá laa' n jon' ki tì lɔkn' wà la, wɔn nínɔ, ní cuo wɔ.» ");
INSERT INTO gngNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","U pɔk ki cuon' ki nɛkn' Yesu, nɛ ki ye: «Cɛnbaa, n fuondeh ŋɛ,» nɛ ki lɔkn' wɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Nɛ *Yesu tɔke' wɔ ki ye: «Nʼjɔ, tien a baa' á tien nà.» Nɛn saan nɛ binib nnɔ nɛkn' ki lá cuo' Yesu. ");
INSERT INTO gngNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Bà te Yesu saan nnɔ ya uba nɛ̀re' uʼjusiek ki gɛ' ki paare' bitɔtuɔrciɛnb ya ciɛn ya tonsɔnl uba ya tubl. ");
INSERT INTO gngNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Nɛ *Yesu tɔke' wɔ ki ye: «jiin aʼjusiek nnɔ kí cùɔn kiʼtuɔku ni, kimɛ wà kɛ kuuleh nin kijusiek la, kijusiek nɛ li ku uʼmɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ŋa bɛn ki ye n miɛ' nʼBaa Uwien la, u li sɔn ní uʼtondb icɛk icɛk piik nin ile nʼsaan fɛnfɛnnɔ-ɔɔ? ");
INSERT INTO gngNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","N tien' nnɔ la, nà kɛle' *Uwien ya gbɔnku ni nnɔ li tien mila kí tien-i?» ");
INSERT INTO gngNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Nɛn saan nɛ u tɔke' linigol nnɔ ki ye: «Ni tuke mujusiemu nin ilɛnbɛn ní lá cuo nni tɛn n yé udukond nɛ-a! N là kaah idaan kɛ *Uwien ya duku ya luo bo ki wɔknh binib, nɛ na cuo' nni u ya yo. ");
INSERT INTO gngNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Nɛn kɛ tien' ŋɔ *Uwien ya ñɔbonsɔknb là kɛle' nà *Uwien ya gbɔnku ni nnɔ nɛ̀ ń tien nɛ.» Nɛn saan nɛ uʼpanpaankaab kɛ sɛn' ki dàan' wɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Binib bà cuo' *Yesu nnɔ taa' wɔ ki jon' bitɔtuɔrciɛnb ya ciɛn Kayif den, *Yiko ya wɔnwɔknb nin Sufmbɛ ya ciɛnb taan' nà saan nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Piɛr pɛ *Yesu bo, ki te fɔnfɔkm, ki tì baa' bitɔtuɔrciɛnb ya ciɛn den nɛ ki kɔn' ki tì kɛ̀le' biguguurb saan, wɔ ń liike nì li gben ma bo. ");
INSERT INTO gngNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Bitɔtuɔrciɛnb nin tibuur ya cɛkl yaab kɛ nuunh bi li dule kutonnɛnku kùa bo kí biin Yesu ŋɔ kí ku wɔ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Nin binib baa' ki lá nɛn' uʼbo kutonnɛnku ki yɛbe ma kɛ nnɔ, ba laa' uʼbiil. Mifɔfɔrm nɛ biñɔŋmaadɛnb bile baa' ");
INSERT INTO gngNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ki lá len' ki ye: «Ujɛ wuɔ len' ki ye: ‹N li fre kí bere Uwien ya duku, kí liɛbe kí mɛ kù iwien ita.› » ");
INSERT INTO gngNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Nɛ bitɔtuɔrciɛnb ya ciɛn fii' ki sere', ki tɔke' *Yesu ki ye: «Ŋa ń len kí jiin-ii? Ŋa ŋmɔbe tuba á len kí jiin binib bà biindeh ŋɛ nɔ-ɔɔ?» ");
INSERT INTO gngNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","*Yesu ŋmin, nɛ bitɔtuɔrciɛnb ya ciɛn tɔke' wɔ ki ye: «Uwien wà fuobe ya yel bo, a yé Uwien ya Nigɛndkɛ Kristo, ki yé Uwien ya Bijɛ nɛ la, tɔke tɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Nɛ *Yesu ye: «Sin nɛ ye nnɔ. Ama n tɔkeh nɛ nɛ, kí ñɛ fɛnfɛnnɔ kí taa kí li joh, ni li lɛ Unil ya Bijɛ kɛ Uwien, mituɔm kɛ ya daan ya jie bó, ki li lɛ wɔ titɛwɔlgbɔnt ni paaki bó, u we ní.» ");
INSERT INTO gngNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","U len' nnɔ ma nnɔ, nɛ bitɔtuɔrciɛnb ya ciɛn kɛre' wɔn bugbɛn ya liɛrl, nɛ ki ye: «U suke' Uwien nɛ. Ta ji nuunh mɔ̀nkunl. Ni cii' u suke' Uwien ma bo. ");
INSERT INTO gngNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ni maaleh mila?» Nɛ bi ye: «U kpɛ mikuum nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Nɛn saan nɛ bi cɛreh uʼnun bó tiñinsɛnt, ki kureh wɔ, nɛ bitɔb mɔ kpɔ̀breh wɔ itɛnpɛ, ");
INSERT INTO gngNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ki tɔkeh wɔ ki teh: «A yé Uwien ya Nigɛndkɛ Kristo la, bukre wà ñi' ŋɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Tɔ, Piɛr kɛ uluo bo, nɛ upiitonsɔnl uba baa' ki lá tɔke' wɔ ki ye: «Aʼmɔ là te nin Galile ya *Yesu wuɔ nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Nɛ Piɛr niɛ' biʼkɛ ya nun bó ki ye: «Ma bɛn a ye á ye bà.» ");
INSERT INTO gngNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","U joh bunañɔjɛbu bó, nɛ upiitonsɔntɔ laa' wɔ, ki tɔke' binib bà te niʼsaan nnɔ ki ye: «Ujɛ wuɔ mɔ là te nin Nasarɛt ya *Yesu nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Nɛ u tí niɛ' ki pole' ki ye: «Ma bɛn ujɛ bugbɛn.» ");
INSERT INTO gngNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Nì pukn' waamu, nɛ binib bà te niʼsaan nnɔ baa' ki lá tɔke' wɔ ki ye: «Nì yé imɔ̀n nɛ, aʼmɔ yé *Yesu yaab ya uba nɛ; aʼlenm nɛ wɔngeh a yé nà bó yɔ.» ");
INSERT INTO gngNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Nɛ Piɛr cin' ki niɛh ki poleh ki teh «Ma bɛn ujɛ wuɔ nɔ. N nɛn' la, Uwien la dàan nni.» Nɛ ukuojɛ pɔk ki muɔ' i ya tàan bo. ");
INSERT INTO gngNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Nɛn saan nɛ Piɛr tiɛre' *Yesu bi tɔke' wɔ ma ki ye: «A li niɛ bolm mita kí ye ŋa bɛn nni nɛ kí yaan ukuojɛ ń muɔ nnɔ.» Nɛ ki ñɛn' saali, ki tì muɔ' ki gbiɛnde' cɛɛn. ");
INSERT INTO gngNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Nì faa' kutɛnŋɛsɔnsɔnku, nɛ bitɔtuɔrciɛnb nin Sufmbɛ ya ciɛnb kɛ kɛ̀le' ki bonde' ki liike' bi li tien ma kí ku Yesu. ");
INSERT INTO gngNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Bi lòle' wɔ, nɛ ki taa' wɔ ki tì ŋukn' gobina Pilat. ");
INSERT INTO gngNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Tɔ, Sudas wà kuɔre' *Yesu nnɔ laa' bi bun' *Yesu tibuur ki ye u kpɛ mikuum ma nnɔ, uʼyɛnm ŋaabe' ki gbien', nɛ u jiin' ilike ya kur pita nnɔ, wɔ ń tì de bitɔtuɔrciɛnb nin Sufmbɛ ya ciɛnb, ");
INSERT INTO gngNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","nɛ ki tɔke' bɛ ki ye: «N bii' nɛ. N kuɔre' unil wà ŋa ŋmɔbe biil nɛ.» Nɛ bi ye: «Na yé ti ya gbɛr, aʼyaar nínɔ.» ");
INSERT INTO gngNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Nɛ u taa' ilike ya kur nnɔ ki wiɛ' Uwien ya duku ni, ki siere', nɛ ki jon' ki tì jɔn' uʼba. ");
INSERT INTO gngNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Tɔ, bitɔtuɔrciɛnb gɛ̀ngɛ̀nde' ilike ya kur nnɔ, nɛ ki ye: «Nì yé misɛ̀m ya like nɛ. Tiʼyiko ŋa ń tuo tí taa yì kí kpìen Uwien ya duku ya liklɛkl ni.» ");
INSERT INTO gngNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Bi gbiere' ki liike' bi li tien yì ma, nɛ ki taa' yì ki dɛ' umaar ya kpàabu, bɛ ń li subeh bicɛnb. ");
INSERT INTO gngNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Nɛn bo nɛ bi yih niʼsaan «Misɛ̀m ya kpàabu» haali nin fɛnfɛnnɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Nì tien' *Uwien ya ñɔbonsɔknl Seremi là len' ma ki ye: «Bi taa' ilike ya kur pita nɛ; Israyɛl yaab là kpaan' udaan ya daaku ubiɛn wà nnɔ, ");
INSERT INTO gngNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","nɛ ki dɛ' umaar ya kpàabu. Yonbdaan là tɔke' nni ki ye nnɔ nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","*Yesu se gobina Pilat ya nun bó, nɛ u niire' wɔ ki ye: «Sin, a yé Sufmbɛ ya bɛr nɛ-ɛɛ?» Nɛ Yesu jiin' wɔ ki ye: «Sin nɛ ye nnɔ.» ");
INSERT INTO gngNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Bitɔtuɔrciɛnb nin Sufmbɛ ya ciɛnb biindeh Yesu, ama wa len' tuba. ");
INSERT INTO gngNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Nɛ Pilat tɔke' wɔ ki ye: «Ŋa ciih bi biindeh ŋɛ mibiinm mà kɛ ya bol-ii?» ");
INSERT INTO gngNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ama *Yesu ŋa jiin' wɔ ñɔbonl liba mɔnɔn. Nɛn nɛ cuo' wɔ miyɔkm cɛɛn. ");
INSERT INTO gngNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Sufmbɛ ya Pak ya nacenku kɛ nacenku ya yo la, Pilat tì ń ñɛn lipɛkl ya nil wà linigol yíe wɔ nɛ kí wiɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","U ya yo ki laa' unil uba te lipɛkl ni uʼyel kpére', bi yih wɔ *Yesu Barabas. ");
INSERT INTO gngNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Linigol taan' ma nnɔ, nɛ Pilat niire' lɛ̀ ki ye: «Ni yíe ń ñɛn ŋmɛ lipɛkl ni? *Yesu Barabas bii *Yesu wà bi yih wɔ *Kristo nnɔ?» ");
INSERT INTO gngNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilat niire' nnɔ, kimɛ u bɛn ki ye bitɔtuɔrciɛnb nin Sufmbɛ ya ciɛnb ŋmɔbe kinɛnk nɛ *Yesu bo. Nɛn nɛ cère' bi taa' wɔ ki lá ŋukn' wɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Uyo wà Pilat kɛ ki buh *Yesu tibuur nnɔ, nɛ uʼpo sɔn' ki tɔke' wɔ ki ye: «La taa aʼgbɛr kí kuɔn ujɛ wà ŋa ŋmɔbe biil nɔ ya gbɛr ni. Kimɛ ujɛ bugbɛn bo, n dɛkn' tidɛknt kuñɔnku kuu tù wiɛbe nni cɛɛn.» ");
INSERT INTO gngNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ama bitɔtuɔrciɛnb nin Sufmbɛ ya ciɛnb sure' linigol nnɔ ki ye lɛ ń tɔke Pilat wɔ ń wiɛ bɛ Barabas, kí ku Yesu. ");
INSERT INTO gngNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Nɛ Pilat tí niire' bɛ ki ye: «Bijɛb bile biɛ ni, ni yíe ń wiɛ u la?» Nɛ bi ye: «Wiɛ Barabas.» ");
INSERT INTO gngNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Nɛ Pilat niire' bɛ ki ye: «Nnɔ la, *Yesu wà bi yih wɔ *Kristo nnɔ, n li tien wɔ mila?» Nɛ biʼkɛ ye: «Bɛ ń kpɛ wɔ udɔpɔnpɔn bo.» ");
INSERT INTO gngNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Nɛ u tí niire' bɛ ki ye: «U tɛ́n ki bii' li lɛ biil nɛ?» Nɛ bi tùɔreh ki wuureh ki gbiekeh ki teh: «Bɛ ń kpɛ wɔ udɔpɔnpɔn bo.» ");
INSERT INTO gngNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilat laa' wa ń fre kí tien niba, bi kpireh ki joh nɛ, nɛ u taa' miñunm, ki nire' biʼnun bó, nɛ ki ye: «Ma te ujɛ wuɔ ya kuum ni. Nì yé ni ya gbɛr nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Nɛ biʼkɛ ye: «Cère uʼkuum ń li yé tinbi nin tiʼbumu ya gbɛr.» ");
INSERT INTO gngNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Pilat wiɛ' bɛ Barabas, ki cère' uʼsojambɛ ñi' *Yesu inalɛbe, nɛ u taa' wɔ ki de' bɛ bɛ ń tì kpɛ wɔ udɔpɔnpɔn bo. ");
INSERT INTO gngNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Tɔ, Pilat ya sojambɛ nnɔ taa' *Yesu ki kɔn' Pilat den uluo bo, nɛ ki taan' biʼcɛkl ya sojambɛ kɛ, ki guɔn' ki linde' wɔ, ");
INSERT INTO gngNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","ki gore' wɔ, nɛ ki taa' kuliɛrmɔ́nmɔ́nku kuba ki goln' wɔ, ");
INSERT INTO gngNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","ki taa' ikonkon ki lònlòn' uyukpɛkpiɛ ki kpɛle' uʼyul, ki taa' lilɛnbɛnl ki ŋukn' uʼnɔjie ni, nɛ ki gbaandeh uʼnun bó, ki lɛh wɔ ki teh: «Sufmbɛ ya bɛrɔ, ti fuondeh ŋɛ-a!» ");
INSERT INTO gngNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Nɛ ki cɛreh uʼbo tiñinsɛnt, ki taah lilɛnbɛnl nnɔ ki kpaakeh uʼyul bo. ");
INSERT INTO gngNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Bi lɛ̀' wɔ ki tì gben', nɛ ki gore' kuliɛrmɔ́nmɔ́nku nnɔ, ki taa' uʼwɛngolkaar ki jiin' ki goln' wɔ, nɛ ki taa' wɔ ki bure' bɛ ń tì kpɛ udɔpɔnpɔn bo. ");
INSERT INTO gngNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Bi tì ñɛh udu ni ma nnɔ, nɛ ki cende' ujɛ uba bi yih wɔ Simɔn, u yé Sirɛnn ya du ya nil nɛ. Bi cuo' ujɛ bugbɛn ki wɔbn' wɔ, wɔ ń tuke *Yesu ya dɔpɔnpɔn. ");
INSERT INTO gngNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Bi tì baa' niba saan, bi yih nɛ̀ Golgota, niʼtingi si: «Kuyukpɔbku ya Bùol.» ");
INSERT INTO gngNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Nɛ ki taa' midaam mà cuuke' nà to kɛrkɛri ki de' Yesu, ki ye wɔ ń ñu. U lèn', nɛ ki yìe' ka ñun'. ");
INSERT INTO gngNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Sojambɛ nnɔ kpɛ' wɔ udɔpɔnpɔn bo. Nɛ ki taa' uʼwɛngolkaar ki fùɔre' imúɔn ki gbiire' tù, ");
INSERT INTO gngNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","nɛ ki kɛ niʼsaan ki gu wɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Bi là kɛle' nà cère' bi kpɛ' wɔ nnɔ ki tɛbn' uʼdɔpɔnpɔn bo uʼyul bó. Bi là kɛle' ki ye: «Sufmbɛ ya bɛr *Yesu sɔ nɔ.» ");
INSERT INTO gngNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Bi kpɛ' idukond ile mɔ uʼsaan idɔpɔnpɔn bo, bi kpɛ' uba uʼnɔjie bó, ki kpɛ' uʼtɔ uʼnɔgɛn bó. ");
INSERT INTO gngNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Binib bà gɛ̀breh niʼsaan nnɔ sukreh wɔ ki gònbeh iyul ki tɔkeh wɔ ");
INSERT INTO gngNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ki teh: «Sin wà ye a li bere Uwien ya duku kí liɛbe kí mɛ kù iwien ita nnɔ, ŋmiɛn aʼba-a! A yé Uwien ya Bijɛ la, jiire ní udɔpɔnpɔn wuu bo-a!» ");
INSERT INTO gngNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Nɛ bitɔtuɔrciɛnb nin Yiko ya wɔnwɔknb nin Sufmbɛ ya ciɛnb mɔ lɛh wɔ ki teh: ");
INSERT INTO gngNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«U ŋmiɛn' binitɔb nɛ, ka ń fre kí ŋmiɛn uʼba-a! U yé Israyɛl yaab ya bɛr la, wɔ ń jiire ní udɔpɔnpɔn wuu bo fɛnfɛnnɔ, ŋɔ tí teke wɔ kí ji. ");
INSERT INTO gngNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","U du Uwien bo nɛ, ki tɔke' ki ye u yé Uwien ya Bijɛ. Uwien yíe wɔ la, wɔ ń ŋmiɛn wɔ fɛnfɛnnɔ.» ");
INSERT INTO gngNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Nɛ idukond yà bi kpɛ' yɛ̀ uʼsaan idɔpɔnpɔn bo nnɔ mɔ sukreh wɔ nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Tɔ, kuwensiiku ya yo nɛ nì ci' ki bìike' utingbɛn kɛ bo ki tì baa' kutaajuɔku tikur tuta ya yo. ");
INSERT INTO gngNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Nì tuoh tikur tuta ya yo nɛ *Yesu wuure' ufaa bo ki ye: «Eli, Eli, lama sabaktani?» Niʼtingi si: «NʼWien, nʼWien, bɛ tien' a wiɛ' nni?» ");
INSERT INTO gngNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Binib bà se niʼsaan nnɔ ya biba ŋa cii' u wuure' ki ye bà mɔnmɔnm nɛ ki ye: «U lii yih Eli nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Nɛ biʼni uba sɛn' i ya tàan bo ki jon' ki tì yuure' ticitɔnt, ki lá sèkn' midɛŋmiŋmiikm miba ni, ki taa' ki tuun' lilɛnbɛnl bo, ki tɛnde' ki kòle' uʼñɔbu ki ye wɔ ń muɔre. ");
INSERT INTO gngNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Nɛ bà sìen nnɔ ye: «Dàan, tí liike *Eli li baa kí lá ŋmiɛn wɔ bii wa ń baa.» ");
INSERT INTO gngNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Nɛn saan nɛ *Yesu tí wuure' ufaa bo, nɛ ki kpo'. ");
INSERT INTO gngNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","U ya yo nɛ kukpɛlcɛkpɛkpiɛku kùa bore' Uwien ya duku ni bolm mile nnɔ kɛre' kuʼsiik ni paaki ki tì ci' tingi. Kitink jènge', itɛn yɛyɛkre', ");
INSERT INTO gngNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ikul bibiire', nɛ Uwien cère' binib bà là pɛ uʼsɛn bo ki kpo' nnɔ mɛkre' ki yɛbe. ");
INSERT INTO gngNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Bi ñɛn' ikul ni, nɛ *Yesu mɛkre' uyo wà bitɛnkpiib ni nnɔ, bi kɔn' Uwien ya du Yerusalɛm ni, ki cère' binib laa' bɛ ki yɛbe. ");
INSERT INTO gngNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Sojambɛ kobk ya ciɛn nin sojambɛ bà te *Yesu saan ki gu wɔ nnɔ laa' kitink jènge' ma, ki laa' tibont tà kɛ tien' nnɔ, nɛ nì cuo' bɛ bujɛwaanbu ki gbien', nɛ bi ye: «Imɔ̀n, ujɛ wuɔ mɔnbe ki yé Uwien ya Bijɛ nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Bipiib biba mɔ là te niʼsaan ki yɛbe, ki se fɔnfɔkm ki likeh. Bi là ñɛn' haali Galile nɛ ki pɛ uʼbo ki toreh wɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Biʼni biba si: Mari Madelɛnn nin Saak nin *Yosɛf ya naa Mari nin Sebede ya bijiɛb ya naa. ");
INSERT INTO gngNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Nì juɔre', nɛ ufàadaan uba baa' ní ki yé Arimate ya nil, bi yih wɔ *Yosɛf. U mɔ là yé *Yesu ya panpaankɛ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","U jon' Pilat saan ki tì tɔke' wɔ ki ye u tuo' la, wɔ ń cɛ̀be wɔ *Yesu ya gbɛnɛnt. Nɛ Pilat de' usɛn ki ye bɛ ń cɛ̀be wɔ tù. ");
INSERT INTO gngNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Nɛ *Yosɛf taa' *Yesu ya gbɛnɛnt, ki taa' kukpɛlcɛfɛ̀nku ki tɛntɛn' tù, ");
INSERT INTO gngNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ki taa' tù ki tì ble' ufɛle uba ni, ki binde' kutɛngbengbenku kuba, ki bìin' bufɛnañɔbu nɛ ki bure'. U là cère' bi cube' ufɛle nnɔ kujɔtɛnku kuba ya kɛle ni nɛ ki de' wɔn bugbɛn. Ba laan là sube' nil len. ");
INSERT INTO gngNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mari Madelɛnn nin Maritɔ nnɔ mɔ là te niʼsaan, ki kɛ likul nnɔ ya nun bó. ");
INSERT INTO gngNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Lidaali là bi bondeh *Saba ya daali nnɔ gɛ̀bre', nì faa' nɛ bitɔtuɔrciɛnb nin *Farisiɛnmbɛ taan' ki jon' Pilat saan, ");
INSERT INTO gngNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ki tɔke' wɔ ki ye: «Cɛnbaa, ti tiɛre' ki ye utonnɛndaan nnɔ là fuobe ma nnɔ, u là ye u kpo' la, wienta daali u li mɛkre bitɛnkpiib ni. ");
INSERT INTO gngNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Nɛn bo, cère sojambɛ ń li gu uʼkul, ki tì baa' wienta daali, ŋɔ uʼpanpaankaab la baa kí lá suu kí ñɛn uʼgbɛnɛnt, kí tɔke binib kí ye u mɛkre' bitɛnkpiib ni nɛ. Bi tien' nnɔ la, ku ya tonnɛnfɔrkaaku li cɛn kukpiɛku.» ");
INSERT INTO gngNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Nɛ Pilat ye: «Sojambɛ sɔ. Li joh mɛn ki tì cère bɛ ń li gu uʼkul ni yíe ma bo.» ");
INSERT INTO gngNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Nɛ bi bure' ki tì pɔle' ki diɛke' litɛnl là bi likul nnɔ, ki cère' sojambɛ nnɔ gu. ");
INSERT INTO gngNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","*Saba ya daali gɛ̀bre', kutaaku kùa li faa nnɔ, nɛ Mari Madelɛnn nin Maritɔ wɔre' ki fii' ki jon' bɛ ń tì gɔnde likul nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","I ya tàan bo nɛ kitink jènge' ki gbien', nɛ Yonbdaan ya tond uba ñɛn' paaki bó ní, ki lá biire' litɛnl nnɔ ki binde' lɛ̀, ki kɛ̀le' liʼbo. ");
INSERT INTO gngNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","U windeh tɛn utɛmɛknde, nɛ uʼwɛngolkaar pìen tein. ");
INSERT INTO gngNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Sojambɛ bà gu likul nnɔ laa' wɔ ma nnɔ, bujɛwaanbu cuo' bɛ cɛɛn. Biʼgbɛnɛnt ŋɔh, nɛ bi fìfìke'. ");
INSERT INTO gngNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Nɛ utond nnɔ tɔke' bipiib nnɔ ki ye: «Ninbi, la fɛnge mɛn. N bɛn ni nuunh *Yesu wà bi là kpɛ' wɔ udɔpɔnpɔn bo nnɔ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Wa ji te niɛ saan. U mɛkre' tɛn u là len' ma bo nɛ. Dɛn mɛn, kí liike u là dɔ nà saan. ");
INSERT INTO gngNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Jo mɛn tonm kí tì tɔke uʼpanpaankaab kí ye u mɛkre', ki liere' bɛ ki bure' Galile bó ŋɔ. Bi li tì lɛ wɔ nɛn bó nɛ. N ŋmɔbe tun nɛ ń tɔke nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Nɛ bipiib nnɔ pɔk ki siere' likul nnɔ saan; bujɛwaanbu ŋmɔbe bɛ, ama biʼyɛnm mɛn sɔnge cɛɛn nɛ bi tiinh ki joh bɛ ń tì tɔke *Yesu ya panpaankaab Uwien ya tond nnɔ tɔke' bɛ nà nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Bi joh ma nnɔ nɛ *Yesu cende' bɛ usɛn ni, ki fuonde' bɛ. Nɛ bi gbaan' uʼnintuɔli, ki cuo' uʼtàan ki puke' wɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Nɛ u tɔke' bɛ ki ye: «La fɛnge mɛn. Li joh mɛn kí tì tɔke nʼpanpaankaab kí ye bɛ ń li joh Galile. Bi li tì lɛ nni nɛn bó nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Uyo wà bipiib nnɔ joh nnɔ, nɛ sojambɛ bà gu *Yesu ya kul nnɔ ya biba jon' Yerusalɛm, ki tì tɔke' bitɔtuɔrciɛnb bi laa' nà kɛ. ");
INSERT INTO gngNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Nɛ bitɔtuɔrciɛnb nin Sufmbɛ ya ciɛnb taan' ki kɛ̀le' ki gbiere', nɛ ki ñɛn' ilike ì yɛbe ki de' sojambɛ nnɔ, ");
INSERT INTO gngNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ki tɔke' bɛ ki ye: «Li joh mɛn kí li tɔkeh binib ki teh ni dɔ kuñɔnku ki gɔh, nɛ uʼpanpaankaab baa' ki lá sun' ki ñɛn' wɔ likul nnɔ ni. ");
INSERT INTO gngNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Pilat cii' la, tinbi nɛ li duɔn uʼyɛnm kí ñɛn nɛ len.» ");
INSERT INTO gngNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Sojambɛ nnɔ teke' ilike nnɔ, nɛ ki jon' ki tì tien' bi tɔke' bɛ ki ye ma bo. Nɛn bo nɛ bi kpaandeh tigbɛr nnɔ Sufmbɛ ni haali nin dinnɔ. ");
INSERT INTO gngNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Tɔ, *Yesu ya panpaankaab piik nin uba nnɔ jon' Galile ni, lijuɔl là *Yesu là yiɛn' bɛ liʼbo nnɔ bo. ");
INSERT INTO gngNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Bi laa' wɔ ma nnɔ, nɛ ki gbaan' uʼnintuɔli ki puke' wɔ. Ama biʼni biba jieh. ");
INSERT INTO gngNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Nɛ *Yesu nɛkn' bɛ ki tɔke' bɛ ki ye: «Uwien de' nni mituɔm kɛ paaki nin tingi. ");
INSERT INTO gngNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Nɛn bo, li joh mɛn inibol kɛ saan, kí tì tien bɛ nʼpanpaankaab, kí sìi bɛ Uwien ya ñunm, Baa nin Bijɛ nin *Mifuoñaanm ya yel bo, ");
INSERT INTO gngNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","kí wɔkn bɛ bɛ ń li boh n tɔke' nɛ nà kɛ nnɔ. Ní li bɛn kí ye n te niʼsaan uyo kɛ kí tì baa uŋɛndun ya gbenm.»");
INSERT INTO gngNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","*Uwien ya Bijɛ *Yesu Kristo ya gbɛmɔnmɔnt ya cinm. ");
INSERT INTO gngNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Tù cin' tɛn *Uwien ya ñɔbonsɔknl Esayi là kɛle' ma uʼgbɔnku ni ki ye: «Liike, n li sɔn nʼtond wɔ ń liere ŋɛ, kí lá tùɔre aʼsɛn. ");
INSERT INTO gngNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Udaan uba te kupenpelku ni ki wuureh ki teh: ‹Tùɔre mɛn Yonbdaan ya sɛn, kí cubn uʼsɛngbɛnmu kí de wɔ.› » ");
INSERT INTO gngNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Nnɔ nɛ San wà siih binib Uwien ya ñunm baa' ki te kupenpelku ni, ki kpaandeh ki teh: «Lèbre mɛn niʼtetem, ń sìi nɛ Uwien ya ñunm ŋɔ Uwien ń fère nɛ niʼbiɛre.» ");
INSERT INTO gngNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Nɛ Sude ya tinfɛnm yaab kɛ nin Yerusalɛm yaab kɛ bàareh uʼsaan ki kpiireh biʼbiɛre, nɛ u siih bɛ Uwien ya ñunm Sudɛn ya kpenl ni. ");
INSERT INTO gngNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","San là guo liliɛrl là nnɔ bi taa' ñɔkma ya kobr nɛ ki lòn' lɛ̀. U là gbin kugbɔnku ya ningbɛnl nɛ uʼciɛk ni. U là jinh inacu nin tisiir nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","U là tɔkeh linigol nnɔ ki teh: «Uba li paan nʼpuoli bó ní ki ŋmɔbe mituɔm ki cɛn' nni. Ma kpɛ ń bùɔn kí lore uʼtacɛningbɛn. ");
INSERT INTO gngNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Min taa' miñunm nɛ ki sìi' nɛ Uwien ya ñunm. Wɔn nɛ lá li cère *Mifuoñaanm ń jiire ní niʼbo.» ");
INSERT INTO gngNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Tɔ, i ya dɛn nɛ *Yesu ñɛn' Nasarɛt, udu wà te Galile ya tinfɛnm ni nnɔ ki baa' San saan. Nɛ San sìi' wɔ Uwien ya ñunm Sudɛn ya kpenl ni. ");
INSERT INTO gngNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","*Yesu ñɛh miñunm ni uyo wà nnɔ nɛ ki laa' kutaaku kɛre', ki laa' *Mifuoñaanm jiinh ní ki naan unɛnjel, ki lá kɛ̀le' uʼbo. ");
INSERT INTO gngNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Nɛ uniɛke uba ñɛn' paaki bó ní ki ye: «Sin, a yé nʼbijɛ nɛ, n yíe ŋɛ nɛ nʼyɛnm sɔnge aʼbo.» ");
INSERT INTO gngNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","I ya tàan bo, nɛ *Mifuoñaanm taa' *Yesu ki jon' kupenpelku ni. ");
INSERT INTO gngNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","U là tien' len iwien pinan nɛ, nɛ *Satan bìkreh wɔ. U te nin kumuɔku ni ya wɛnt nɛ, nɛ Uwien ya tondb toreh wɔ. ");
INSERT INTO gngNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Tɔ, nì tete nɛ bi lá cuo' San ki pɛkn'. Ni ya puoli bó nɛ *Yesu jon' Galile ki tì kpaandeh Uwien ya gbɛmɔnmɔnt, ");
INSERT INTO gngNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","ki teh: «Uyo baa'-a! Uwien ya bɛl nɛkn' ní ŋɔ. Lèbre mɛn niʼtetem, kí teke tigbɛmɔnmɔnt kí ji.» ");
INSERT INTO gngNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","*Yesu cuonh ki kpàakeh Galile ya ñunciɛnm, nɛ ki laa' Simɔn nin uʼninjɛ Andre te ki wiɛnh bubɛbu. Bi là yé bijɛnbɛb nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Nɛ u tɔke' bɛ ki ye: «Paan mɛn nʼbo ní, ŋɔ ń cère ní li taakeh binib ki dienh nni.» ");
INSERT INTO gngNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Bi dàan' biʼbàan i ya tàan bo, nɛ ki paan' uʼbo. ");
INSERT INTO gngNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","U jɛnde' waamu ki pukn', nɛ ki tí laa' Sebede ya bijiɛb Saak nin uʼninjɛ San te biʼñɛrbu ni, ki tùɔreh biʼbàan. ");
INSERT INTO gngNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","*Yesu yin' bɛ i ya tàan bo nɛ bi dàan' biʼbaa Sebede nin uʼtonsɔnb buñɛrbu nnɔ ni, ki paan' uʼbo. ");
INSERT INTO gngNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesu nin uʼpanpaankaab tì baa' Kapɛrnawum ya du ni. *Saba ya daali nɛ *Yesu kɔn' biʼtaanl ya duku ni, ki wɔknh binib Uwien ya gbɛr. ");
INSERT INTO gngNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Nì cuo' binib bà cengeh uʼbó nnɔ miyɔkm cɛɛn, kimɛ wa wɔknh bɛ tɛn *Yiko ya wɔnwɔknb wɔknh ma bo, u wɔknh bɛ tɛn unil wà du u wɔknh nà bo nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ujɛ uba mɔ là te *Sufmbɛ ya taanl ya duku nnɔ ni usɛnpol ŋaake wɔ, nɛ u wuure' ");
INSERT INTO gngNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","ki ye: «Nasarɛt ya Yesu, tinbi nin sin tu lɛ nɛ? A baa' á lá boln tɛ nɛ-ɛɛ? N bɛn a yé udaan wà. A yé Uwien ya Niñaan nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Nɛ *Yesu tiɛn' uʼbo ki ye: «Ŋmile, kí siere ujɛ wuɔ saan.» ");
INSERT INTO gngNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Nɛ usɛnpol nnɔ ñɔnñɔnge' ujɛ nnɔ nin ufaa, ki wuure' ki gbien', nɛ ki siere' uʼsaan. ");
INSERT INTO gngNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Nɛ nì cuo' biʼkɛ miyɔkm cɛɛn. Nɛn saan nɛ bi niireh tɔb ki teh: «Nì yé bɛ sɔ? U wɔknh miwɔknfɛ̀nm nɛ ki du miʼbo-a, ki wɔbndeh isɛnpol mɔnɔn ì tuonh uʼñɔbu bó-a!» ");
INSERT INTO gngNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Nɛn bo nɛ *Yesu ya yel kpére' Galile ya tinfɛnm ni niʼkɛ saan. ");
INSERT INTO gngNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","*Yesu nin bà pɛ uʼbo nnɔ ñɛn' litaanl ya duku nnɔ ni, nɛ ki jon' Simɔn nin Andre den. Saak nin San mɔ pìɛre' bɛ. ");
INSERT INTO gngNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Tɔ, Simɔn ya cɔbnaa dɔ ki bun, uʼgbɛnɛnt ton. Nɛ bi pɔk ki tɔke' *Yesu ki ye u bun, ");
INSERT INTO gngNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","nɛ u baa' uʼsaan ki cuo' uʼnuɔ ki fin' wɔ. Uʼgbɛnɛnt sɔnge' nɛ u cɛ̀nde' bɛ. ");
INSERT INTO gngNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Niʼdaali ya tajuɔku uwien lu' ma nnɔ, nɛ bi tukeh bà bun iwìɛn kɛ ya bol nin isɛnpol ŋaake bà nnɔ kɛ ya bol ki bàareh *Yesu saan. ");
INSERT INTO gngNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Udu nnɔ ya nib kɛ là taan' Simɔn nin Andre den nɛ bunañɔbu saan. ");
INSERT INTO gngNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Nɛ *Yesu buu' binib bà bun iwìɛn kɛ ya bol bi yɛbe, ki ŋɔre' isɛnpol binib saan ì yɛbe ka cèreh ì lienh, kimɛ ì bɛn wɔ. ");
INSERT INTO gngNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Utɛnŋafaa nɛ *Yesu fii' nì bìike ki ñɛn' ki jon' nib ŋa te nà saan ki tì kàareh. ");
INSERT INTO gngNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Nɛ Simɔn nin uʼtɔntɔknlieb mɔ fii' ki ñɛn', ki nuunh wɔ, ");
INSERT INTO gngNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","bi tì laa' wɔ ma nnɔ, nɛ ki tɔke' wɔ ki ye: «Binib kɛ nuunh ŋɛ nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Nɛ u tɔke' bɛ ki ye: «Tí jo mɛn nitɔnn bó, itengbaan yà te kɔnkɔnm nnɔ ni ŋɔ ń tì tɔke Uwien ya gbɛr niʼmɔ bó. Kimɛ nɛn bo nɛ n baa'.» ");
INSERT INTO gngNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Nɛ ki taa' bɛ ki jon' Galile ya tinfɛnm kɛ ni, ki tì kɔh Sufmbɛ ya táan ya dur ni, ki kpaandeh Uwien ya gbɛr, ki ŋuɔh isɛnpol binib saan. ");
INSERT INTO gngNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ujend uba baa' *Yesu saan, nɛ ki gbaan' uʼnintuɔli, ki gbáan' wɔ ki ye: «A yíe la, a li fre kí cère ń lùore.» ");
INSERT INTO gngNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesu muɔ' wɔ micɛcɛkm cɛɛn, nɛ ki tɛnde' uʼnuɔ, ki mɛ' wɔ, ki tɔke' wɔ ki ye: «N yíe, lùore.» ");
INSERT INTO gngNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","I ya tàan bo nɛ lijendl nnɔ pɔk ki gben' nɛ u lùore'. ");
INSERT INTO gngNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Nɛn saan nɛ *Yesu tɔke' wɔ ki ye wɔ ń li joh, nɛ ki kpɛkpɛ' uʼbo, ");
INSERT INTO gngNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","ki ye: «Liike aʼyul bo ki la tɔke nil, ama jo tí tì lɛ utɔtuɔrkɛ, kí tien milùorm ya tuɔrl tɛn Moyis là ye bɛ ń li teh ma bo. Nɛn nɛ li wuɔn kí ye a lùore'.» ");
INSERT INTO gngNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ama ujɛ nnɔ bure' ma nnɔ, u tì kpaandeh tigbɛr nnɔ niʼkɛ saan nɛ. U tien' nnɔ ma nnɔ, nɛ *Yesu ŋa ji li fre kí kɔ du uba ni, ka bɔle'. U là juonh idugbaan nɛ nib ŋa te nà saan. Nɛ binib ñɛh niʼkɛ bó ki bàareh uʼsaan. ");
INSERT INTO gngNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Iwenkàankɛ gɛ̀bre', nɛ *Yesu liɛbe' ki jon' Kapɛrnawum ya du bó. Binib cii' u te u càan' iden yà nnɔ ni, ");
INSERT INTO gngNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","nɛ linigol taan' niʼsaan ki yɛbe haali fɛnm ŋa ji tì te nañɔbu ni mɔnɔn. Nɛ u tɔkeh bɛ Uwien ya gbɛr. ");
INSERT INTO gngNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Tɔ, binib biba tuke' ujɛ uba uʼtàan nin uʼnuɔ kɛ faan' ki baa' Yesu saan. Binib binan nɛ là tuke' wɔ. ");
INSERT INTO gngNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Linigol nnɔ bo ba ń fre kí taa wɔ kí nɛ̀nde *Yesu ma nnɔ, nɛ ki don' u te kudulɛkaaku kùa ni nnɔ ya paaki, ki cube' libònl u se nà saan nnɔ, nɛ ki taa' ujɛ nnɔ ki kuɔn' ki yekn' nin linagɛnl nnɔ ki ble' *Yesu ya nun bó. ");
INSERT INTO gngNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","*Yesu laa' bi teke' wɔ ki jin' ma nnɔ, nɛ u tɔke' ujɛ nnɔ ki ye: «Nʼbukɛ, n fère' ŋɛ aʼbiɛre ŋɔ.» ");
INSERT INTO gngNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","*Yiko ya wɔnwɔknb biba kɛ niʼsaan ki maaleh biʼfɛ̀l ni ki teh: ");
INSERT INTO gngNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«Bɛ tien' ujɛ wuɔ lienh nɔ nnɔ? U sukreh Uwien nɛ. Uwien baba ŋa ñí la, ŋmɛ li fre kí fère binib biʼbiɛre?» ");
INSERT INTO gngNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","*Yesu pɔk ki bɛnde' uʼyɛnm ni bi maaleh ma bo nɛ ki niire' bɛ ki ye: «Bɛ tien' ni maaleh nɔ nnɔ niʼyɛnm ni? ");
INSERT INTO gngNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ni lɛ ba faa? Ń tɔke ujɛ wuɔ kí ye n fère' wɔ uʼbiɛre nɛ faa bii wɔ ń fii kí yuure uʼnagɛnl kí li cuonh nɛ faa? ");
INSERT INTO gngNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Nɛn bo, n li wuɔn nɛ kí ye Unil ya Bijɛ ŋmɔbe mituɔm uŋɛndun wuu ni wɔ ń fère binib biʼbiɛre.» Nɛ ki tɔke' ujɛ wà ya nuɔ nin uʼtàan faan' nnɔ ki ye: ");
INSERT INTO gngNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","«N lienh sin nɛ, fii kí yuure aʼnagɛnl, kí li kunh.» ");
INSERT INTO gngNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","I ya tàan bo nɛ u fii' ki yuure' uʼnagɛnl ki ñɛn' saali biʼkɛ ya nun bó. Nì cuo' biʼkɛ miyɔkm cɛɛn nɛ bi pɛ̀keh Uwien ki teh: «Ti fii' ma, ta laan laa' niɛ ya bonn ya tunbu.» ");
INSERT INTO gngNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","*Yesu liɛbe' ki jon' Galile ya ñunciɛnm ya gbaal, nɛ binib ligol bàareh uʼsaan, u tɔkeh bɛ Uwien ya gbɛr. ");
INSERT INTO gngNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","U joh ma nnɔ nɛ ki laa' ulɛnpotekl uba kɛ lɛnpotekbùol, bi yih wɔ Lefi u yé Alfe ya bijɛ. Nɛ *Yesu tɔke' wɔ ki ye: «Paan nʼbo ní.» Nɛ u fii' ki paan' uʼbo. ");
INSERT INTO gngNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ni ya puoli bó nɛ *Yesu te Lefi den ki jinh tijier. Bilɛnpotekb ligol nin bibiɛrdɛnb mɔ là kɛ wɔn nin uʼpanpaankaab saan ki jinh tijier, kimɛ bi là paakeh uʼbo ki yɛbe. ");
INSERT INTO gngNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","*Yiko ya wɔnwɔknb biba, bà yé *Farisiɛnmbɛ nnɔ laa' *Yesu nin bilɛnpotekb nin bibiɛrdɛnb tɛ ki jinh tijier ma nnɔ nɛ bi niire' uʼpanpaankaab ki ye: «Bɛ tien' u tɛ ki jinh nin bilɛnpotekb nin bibiɛrdɛnb-i?» ");
INSERT INTO gngNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","*Yesu cii' bi len' ma bo, nɛ ki tɔke' bɛ ki ye: «Binib bà ŋmɔbe laanfiɛ ŋa nuunh dɔktiɛ, bà bun nɛ nuunh dɔktiɛ. Ma baa' ń yin nimɔ̀nb, n baa' ń yin bibiɛrdɛnb nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Uyo uba nɛ San ya panpaankaab nin *Farisiɛnmbɛ là lùo buñɔbu, nɛ binib biba baa' ki lá niire' *Yesu ki ye: «Bɛ tien' San ya panpaankaab nin *Farisiɛnmbɛ yaab lùoh buñɔbu aʼyaab bɛn ŋa lùoh?» ");
INSERT INTO gngNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Nɛ u jiin' bɛ ki ye: «Binib bà bi yin' bɛ upiikuɔn li fre kí lòle buñɔbu uyo wà piicɛ laan te biʼsaan-ii? Piicɛ laan te biʼsaan la, ba ń fre kí lòle ñɔbu. ");
INSERT INTO gngNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ama uyo uba we ní bɛ ń ñɛn piicɛ nnɔ biʼsaan ufaa. U ya yo nɛ bi li lòle buñɔbu.» ");
INSERT INTO gngNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Nɛ ki tí ye: «Uba ŋa ń taa kpɛlcɛfɛ̀nku ya jenl kí lekn liliɛrkpaal. U tien' nnɔ la, kukpɛlcɛfɛ̀nku ya jenl nnɔ li kɛre liliɛrkpaal nnɔ nɛ libònl nnɔ ń yɛbre kí pukn. ");
INSERT INTO gngNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Uba mɔ ŋa ń taa midaam mà ŋa laan muɔ' ki ben' kí piɛke iyɔkpaan ni. U tien' nnɔ la, midaam nnɔ li kpiɛn iyɔl nnɔ, kí wule kí ñɛnde nɛ iyɔl nnɔ mɔ ń saa. Bi piɛkeh midaam mà ŋa laan muɔ' ki ben' iyɔfɛ̀n ni nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","*Saba uba ya daali nɛ *Yesu nin uʼpanpaankaab gɛ̀breh ikpàan iba ni. Bi cuonh ki joh ma nnɔ nɛ uʼpanpaankaab coh ijifen ki cienh. ");
INSERT INTO gngNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Nɛ *Farisiɛnmbɛ niire' *Yesu ki ye: «Bɛ tien' aʼpanpaankaab teh yiko kùɔn' nà *Saba ya daali?» ");
INSERT INTO gngNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Nɛ u tɔke' bɛ ki ye: «Na laan kaan' *Dafid là tien' ma bo nɛ-ɛɛ? Wɔn nin uʼnib ŋa là ŋmɔbe jier ma mikònm cuo' bɛ nnɔ ");
INSERT INTO gngNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","u kɔn' Uwien ya ninbonl ni, uyo wà Abiyatar là yé bitɔtuɔrciɛnb ya ciɛn nnɔ, ki taa' kpɔnɔ wà bi taa' ki de' Uwien nnɔ ki ŋmɔn', nɛ ki de' wɔn nin bà tɔke nnɔ biʼmɔ ŋmɔn'. Ama bitɔtuɔrkaab baba nɛ là ŋmɔbe usɛn bɛ ń ŋmɔn kpɔnɔ nnɔ.» ");
INSERT INTO gngNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Nɛ ki tɔke' bɛ ki ye: «Unisaal bo nɛ Uwien sien' *Saba ya daali, na yé *Saba ya daali bo nɛ Uwien ñɛn' unisaal. ");
INSERT INTO gngNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Nɛn bo, Unil ya Bijɛ nɛ ŋmɔbe usɛn wɔ ń wuɔn bi li tien nà haali *Saba ya daali mɔnɔn.» ");
INSERT INTO gngNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","*Saba uba ya daali nɛ *Yesu tí liɛbe' ki kɔn' *Sufmbɛ ya taanl ya duku ni. Ujɛ uba mɔ te len uʼnuɔ uba faan'. ");
INSERT INTO gngNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Nɛ bi sekndeh ki likeh u li cère ujɛ nnɔ ń faake *Saba ya daali bii wa ń cère wɔ ń faake, kimɛ bi là nuunh bi li dule nà bo kí biin wɔ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Nɛ *Yesu tɔke' ujɛ wà ya nuɔ faan' nnɔ ki ye: «fii kí sere siik ni.» ");
INSERT INTO gngNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Nɛ ki niire' bɛ ki ye: «*Saba ya daali la, unil ŋmɔbe usɛn wɔ ń tien nà mɔn bii nà bre nɛ? U ŋmɔbe usɛn wɔ ń ŋmiɛn unil bii wɔ ń ku wɔ nɛ?» Ba jiin' wɔ. ");
INSERT INTO gngNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Nɛ u liike' bɛ ki gɔbre' ki bòn' nin ubenpiebe, uʼyɛnm saa' biʼyufaa bo, nɛ u tɔke' ujɛ wà ya nuɔ faan' nnɔ ki ye: «Tɛnde aʼnuɔ.» U tɛnde' uʼnuɔ nɛ u jire' uʼciɛm. ");
INSERT INTO gngNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Nɛn saan nɛ *Farisiɛnmbɛ ñɛn', ki taan' ki kɛ̀le' i ya tàan bo nin Herod yaab bɛ ń gbiere kí liike bi li tien ma kí ku Yesu. ");
INSERT INTO gngNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Nɛ *Yesu nin uʼpanpaankaab siere' niʼsaan ki bure' miñunciɛnm bó, nɛ linigociɛnl paan' uʼbo. Linigol nnɔ ñɛn' ní Galile ya tinfɛnm ni nin Sude ya tinfɛnm ni ");
INSERT INTO gngNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","nin Yerusalɛm ni nin Idume ya tinfɛnm ni nin mitinfɛnm mà te Sudɛn ya kpenpuol nnɔ ni nin Tir nin Sidɔn ya tinfɛnm ni nɛ. Bi là yɛbe cɛɛn nɛ. Bi cii' *Yesu teh miyɔkm ya bont ma nnɔ nɛ cère' bi baa' uʼsaan. ");
INSERT INTO gngNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Nɛ u tɔke' uʼpanpaankaab ki ye bɛ ń taa buñɛrbu kí pùkn miñunm bo wɔ ń kɔ ŋɔ linigol nnɔ la pɛbe wɔ. ");
INSERT INTO gngNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Kimɛ u là cère' binib faake ki yɛbe ma nnɔ nɛ biwiɛnb kɛ kpiɛleh bɛ ń nɛ̀nde kí mɛ wɔ. ");
INSERT INTO gngNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Isɛnpol yà ŋaake binib nnɔ laa' wɔ la, ì cèreh bi gbaandeh uʼnintuɔli nɛ ki wuureh ki teh: «A yé Uwien ya Bijɛ nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ama *Yesu tɛngeh isɛnpol nnɔ bo nɛ ki teh ì la cère binib ń bɛnde u yé udaan wà. ");
INSERT INTO gngNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ni ya puoli bó nɛ *Yesu don' lijuɔl bo, ki yin' u yíe binib bà nnɔ. Bi baa' uʼsaan, ");
INSERT INTO gngNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","nɛ u gɛ̀nde' binib piik nin bile bɛ ń li tuu ki te uʼsaan, nɛ ki yin' bɛ uʼtondb. U gɛ̀nde' bɛ wɔ ń li sɔnh bɛ bi tì tɔkeh binib tigbɛmɔnmɔnt nɛ, ");
INSERT INTO gngNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","kí li ŋmɔbe mituɔm ki ŋuɔh isɛnpol binib saan. ");
INSERT INTO gngNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","U gɛ̀nde' binib piik nin bile bà nnɔ ya yel sɔ: Simɔn, u baan' wɔ Piɛr ");
INSERT INTO gngNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","nin Sebede ya bijiɛb Saak nin uʼninjɛ San, u baan' bɛ Bowanɛrgɛs, niʼtingi si: «itɛtiɛn ya nib» ");
INSERT INTO gngNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","nin Andre nin Filip nin Batelemi nin Matie nin Toma nin Alfe ya bijɛ Saak nin Tade nin Simɔn wà ya nun mɔ́n uʼdu ya gbɛr bo ");
INSERT INTO gngNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","nin Sudas Iskariyɔt wà lá li kuɔre wɔ nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","*Yesu kun' nɛ linigol tí taan' uʼsaan haali wɔn nin uʼpanpaankaab ŋa tì ŋmɔbe fɛnm bɛ ń ji jier mɔnɔn. ");
INSERT INTO gngNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Uʼden yaab cii' nì te nnɔ nɛ bi baa' bɛ ń taa wɔ. Kimɛ bi maaleh ki teh u waare' nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Tɔ, Yiko ya wɔnwɔknb bà ñɛn' Yerusalɛm bó ní nnɔ lienh ki teh Bɛlsebul nɛ ŋaake wɔ. Wɔn isɛnpol ya ciɛn nɛ dienh wɔ mituɔm u ŋuɔh isɛnpol binib saan. ");
INSERT INTO gngNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Nɛ u yin' bɛ ki pɔn' bɛ mikpɛnjɛnm ki ye: «*Satan li tien mila kí ŋɔre wɔn *Satan? ");
INSERT INTO gngNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Libɛl liba ya nib bore' tɔb ki kɔnh biʼŋmiɛl ni la, libɛl nnɔ li juore fɛnm nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Iden iba mɔ ya nib bore' tɔb ki kɔnh biʼŋmiɛl ni la, iden nnɔ li juore fɛnm nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Nɛn bo nɛ *Satan liɛbe' ki kɔnh nin uʼba la, u li gben kí juore fɛnm nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","«Uba ŋa ń fre kí kɔ ufɛfaa den kí fie uʼbont ka ŋmɔbe tuɔm mà u li kpiɛ kí lòle wɔ kí yaan. U lòle' wɔ la, u ya yo nɛ u li fre kí kɔ uʼden kí fie uʼbont kɛ. ");
INSERT INTO gngNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","N tɔkeh nɛ imɔ̀n nɛ, Uwien li fère binib biʼbiɛre kɛ, kí fère bɛ bi suke' wɔ isuk ì yɛbe ki kpɛ ma kɛ. ");
INSERT INTO gngNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ama, unil suke' *Mifuoñaanm mɛn la, Uwien ŋa ń fère wɔ, uʼbiɛre li juore uʼbo nɛ haali uyo wà ŋa ŋmɔbe gbenm.» ");
INSERT INTO gngNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Bi tɔke' wɔ ki ye usɛnpol nɛ ŋaake wɔ ma nnɔ, nɛ cère' u len' nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Tɔ, *Yesu ya naa nin uʼninjiɛb baa' ní ki lá te saali, nɛ ki sɔn' bɛ ń tì yin wɔ. ");
INSERT INTO gngNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Linigol kɛ ki guɔn' wɔ, nɛ bi tɔke' wɔ ki ye: «Aʼnaa nin aʼninjiɛb nin aʼninsiɛb te saali ki nuunh ŋɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Nɛ u tɔke' bɛ ki ye: «Ŋmɛ nɛ yé nʼnaa? Bi lɛ yé nʼninjiɛb-i?» ");
INSERT INTO gngNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ki liike' ki bòn' binib bà kɛ ki guɔn' wɔ nnɔ nɛ ki ye: «Liike mɛn, nʼnaa nin nʼninjiɛb sɔ. ");
INSERT INTO gngNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Unil wà kɛ teh Uwien yíe nà la, wɔn nɛ yé nʼninjɛ, ki yé nʼninsɛ, ki yé nʼnaa.» ");
INSERT INTO gngNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","*Yesu tí liɛbe' ki jon' Galile ya ñunciɛnm ya gbaal ki tì wɔknh binib Uwien ya gbɛr. Linigociɛnl tí taan' uʼsaan nɛ u kɔn' ki kɛ̀le' buñɛrbu ni miñunm bo. Linigol nnɔ kɛ te miñunm ya gbaal. ");
INSERT INTO gngNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Nɛ u wɔknh bɛ tibont tù yɛbe mikpɛnjɛnm ni, ki tɔkeh bɛ ki teh: ");
INSERT INTO gngNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«Li cengeh mɛn, ukpaal uba nɛ jon' wɔ ń tì plè tibonbuor ya bim. ");
INSERT INTO gngNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","U plèh ma nnɔ, miba lu' usɛngbɛ, nɛ inuɔn baa' ki lá jin' mɛ̀. ");
INSERT INTO gngNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Mitɔm lu' kutɛntiɛku bo, tɛnbim ŋa yɛbe nà saan. Tɛnbim ŋa yɛbe ma nnɔ, nɛ mì pɛn' tonm. ");
INSERT INTO gngNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Uwien ñɛn' ki tonge', nɛ ki sɛ' mɛ̀. Ma ŋmɔbe ñaan mɔnmɔnm ma nnɔ, nɛ mì waan', ki kpo'. ");
INSERT INTO gngNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Mitɔm mɔ lu' kujɛgorku ni. Nɛ kujɛgorku kpére' ki wɔbn' mɛ̀ nɛ ma lùon'. ");
INSERT INTO gngNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Mitɔm mɔ lu' kitinmɔnmɔnk bo, ki pɛn', ki kpére', ki lùon'. Miba lùon' pitata, mitɔm piluoluob, mitɔm mɔ kokobk.» ");
INSERT INTO gngNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Nɛ ki tí ye: «Wà ŋmɔbe litubl la, wɔ ń cii.» ");
INSERT INTO gngNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","*Yesu nin uʼtondb piik nin bile nin binib bà tuu ki paakeh uʼbo nnɔ tì te biʼbaba ma nnɔ, nɛ bi niire' wɔ mikpɛnjɛnm nnɔ ya tingi. ");
INSERT INTO gngNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Nɛ u jiin' bɛ ki ye: «Uwien nɛ cère' ninbi bɛnde' uʼbɛl ni ya gbɛbɔlkaar. Binib bà ŋa te uʼbɛl ni nnɔ wɔn, nì yé bɛn bo mikpɛnjɛnm baba nɛ, ");
INSERT INTO gngNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ŋɔ ‹bɛ ń li likeh ka lɛnh, kí li cengeh ka ciih niʼtingi, nnɔ ŋa ñí la, bi cii' niʼtingi, ki lèbre' biʼtetem la, Uwien li fère bɛ biʼbiɛre nɛ.› » ");
INSERT INTO gngNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","*Yesu niire' bɛ ki ye: «Na cii' mikpɛnjɛnm miɛ ya tingi la, ni li tien mila kí cii mà kɛ sìen' nnɔ ya tingi? ");
INSERT INTO gngNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Mikpɛnjɛnm nnɔ ya tingi sɔ: ukpaal nnɔ te tɛn unil wà tɔkeh binib Uwien ya gbɛr nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Mibim mà lu' usɛngbɛ nnɔ yé binib bà ciih Uwien ya gbɛr, *Satan bàareh i ya tàan bo ki lá ñɛndeh tù biʼfɛ̀l ni nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Mibim mà lu' kutɛntiɛku bo nnɔ mɔ yé binib bà ciih Uwien ya gbɛr, ki teknh tù tontonm nin uyɛnsɔnge, ");
INSERT INTO gngNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","ama ka cèreh tù kpaakeh ñaan biʼfɛ̀l ni nɛ, nɛ ta wuɔkreh biʼni mɔ. Liwɔbl bii ijɛnd tu' bɛ tuʼbo la, bi pɔk kí wiɛ Uwien ya sɛn nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Mibim mà lu' kujɛgorku ni nnɔ mɔ yé binib bà ciih Uwien ya gbɛr, ");
INSERT INTO gngNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","nɛ uŋɛndun wuu ya gbɛr nin lifaal ya yɛnmaale yà lɛreh binib nnɔ nin tibont kɛ ya yɛnmaale kɔh biʼfɛ̀l ni, ki wɔbndeh tù, ki cèreh ta ń fre kí sɔn tuonl. ");
INSERT INTO gngNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Mibim mà lu' kitinmɔnmɔnk bo nnɔ mɔ yé binib bà ciih tigbɛr nnɔ, ki teknh tù, ki te tɛn mibim mà lùonh nɛ. Miba lùonh pitata, mitɔm piluoluob, mitɔm mɔ kokobk.» ");
INSERT INTO gngNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Nɛ *Yesu tí tɔke' bɛ ki ye: «Unil sɛ' lifrl la, u li taa kusɛnku kí cubn li bo-oo? Bii u li taa lɛ̀ kí sien igado ya tingi-ii? Wa ń taa lɛ̀ kí tuɔn likpɛnkpɛnl bo ka-aa? ");
INSERT INTO gngNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Kimɛ niba ŋa te ki buɔ ŋɔ ba lá li lɛ nɛ̀, niba mɔ ŋa ń juore kí li buɔ ŋɔ ka lá li ñɛ upaan bo. ");
INSERT INTO gngNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Wà ŋmɔbe litubl la, wɔ ń cii.» ");
INSERT INTO gngNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","U tí tɔke' bɛ ki ye: «Liike mɛn niʼyul bo nin ni ciih tigbɛr tà nɔ. Ni taah nà ki bìkreh tibont ki dienh binitɔb nnɔ Uwien mɔ li taa nɛn nɛ kí biike kí de nɛ. U li biike kí gɛ̀bre nnɔ mɔnɔn kí de nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Kimɛ wà ŋmɔbe la, bi li de wɔ kí pukn nɛ. Wà ŋa ŋmɔbe la, bi li tonde kí fie u ŋmɔbe nà waamu nnɔ mɔnɔn nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu tí len' ki ye: «Uwien ya bɛl naan tibonbuor ya bim mà ujɛ uba bule' mɛ̀ uʼkpàabu ni nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","U gɔh-ɔɔ, u likeh ñɔnku nin wien ni-ii, mibim nnɔ pɛh nɛ ki kpienh, wa bɛn mì teh ma bo. ");
INSERT INTO gngNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Kitink nɛ cèreh mì pɛh, ki cinh ki kpienh, kí tì pobe kí maa, kí tien ijifen, kí fɔre nin mibim. ");
INSERT INTO gngNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Nì lá ben' ki kpaan' micem la, nɛ wɔ ń taa puoko kí jo kí tì ce.» ");
INSERT INTO gngNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","*Yesu tí len' ki ye: «Ti li taa ba kí nɛnge Uwien ya bɛl-i? Ti li taa milɛ kpɛnjɛnm ba kí nɛnge lɛ̀? ");
INSERT INTO gngNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Lì naan mibim mà bi yih mɛ̀ mutaar nnɔ nɛ. Mɛn nɛ yé mibim mà ñilke tikpinsir kɛ ya bim ni kitink bo. ");
INSERT INTO gngNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ama bi bule' mɛ̀ la, mì li pɛ kí kpére kí gɛ̀bre kpinsiiku kɛ kpinsiiku, kí tien isigben yà gbenge. Inuɔn li fre kí tere isigben nnɔ ya sɔnge ni kí li kɔ mɔnɔn.» ");
INSERT INTO gngNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","*Yesu taah mikpɛnjɛnm ma sɔ ya bol mì yɛbe ki tɔkeh binib Uwien ya gbɛr, bi li fre kí cii ma bo. ");
INSERT INTO gngNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Wa tɔkeh bɛ tuba ka pɔn' bɛ kpɛnjɛnm. Ama wɔn nin uʼpanpaankaab lá te biʼbaba la, nɛ u tɔkeh bɛ mikpɛnjɛnm nnɔ kɛ ya tingi. ");
INSERT INTO gngNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Niʼdaali ya taajuɔku, uwien benh wù ń kɔ ma nnɔ, nɛ Yesu tɔke' uʼpanpaankaab ki ye: «Cère mɛn tí puore kí jo miñunciɛnm ya gbaatɔl bó.» ");
INSERT INTO gngNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","U cɛ̀be' linigol nnɔ, nɛ uʼpanpaankaab kɔn' uʼsaan buñɛrbu ni ki tuke' wɔ ki bure'. Iñɛrtɔ mɔ là pɛ biʼbo. ");
INSERT INTO gngNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Bi joh ma nnɔ nɛ kutafaabiiku kuba fii', ki cèreh iñungbegbel fih ki yildeh buñɛrbu nnɔ bo, nɛ miñunm kuonh buʼni haali bù tì benh bù ń gbe. ");
INSERT INTO gngNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Nin nɛn kɛ ŋɔ *Yesu wɔn dɔ buñɛrbu ni nɛ puoli bó ki gɔh ki kuu liyukukul. Nɛ bi baa' ki lá fìnde' wɔ ki tɔke' wɔ ki ye: «Cɛnbaa, ti benh tí luo, nɛ ŋa tɔnge-ee?» ");
INSERT INTO gngNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Nɛn saan nɛ u fìnde', ki tiɛn' kutafaaku nnɔ bo, nɛ ki tɔke' miñunm nnɔ ki ye: «Duɔn suoo.» Nɛ kutafaaku go, niʼkɛ ŋmile' cim. ");
INSERT INTO gngNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Nɛ u niire' bɛ ki ye: «Bɛ tien' ni sɛn' bujɛwaanbu nɔ nnɔ? Na laan biɛ ki ŋmɔbe tekjim nɛ-ɛɛ?» ");
INSERT INTO gngNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Bujɛwaanbu cuo' bɛ ki gbien' nɛ bi niireh tɔb ki teh: «U cinbe ki yé bɛ ya nitunbu sɔ, kutafaaku nin miñunm kɛ tì boh wɔ?» ");
INSERT INTO gngNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","*Yesu nin uʼpanpaankaab tì baa' miñunciɛnm ya gbaatɔl, Gerasa yaab ya tinfɛnm ni. ");
INSERT INTO gngNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","U ñɛh buñɛrbu ni uyo wà nnɔ nɛ ujɛ uba pɔk ki ñɛn' ikul bó ní ki cendeh wɔ. Usɛnpol nɛ là ŋaake wɔ. ");
INSERT INTO gngNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","U là kɔ bi subeh binib tijɔlulnt tà ni nnɔ nɛ. Bi lòle' wɔ tikudɔkr mɔnɔn la, u cienh tù nɛ. Nɛn bo nɛ uba ŋa ji là li fre kí cuo wɔ. ");
INSERT INTO gngNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Bi là taah mugbiɛmu nin tikudɔkr nɛ ki lùoh wɔ, nɛ u cienh tikudɔkr nnɔ ki kɔ̀h mugbiɛmu nnɔ. Uba ŋa là li fre wɔ. ");
INSERT INTO gngNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","U là tuu ki te ikul nnɔ ni nin igbɛngbɛn bo nɛ ñɔnku nin wien ni ki wuureh, ki taah itɛn ki bungreh uʼba. ");
INSERT INTO gngNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","U te fɔnfɔkm, ki laa' Yesu, nɛ ki sɛn' ki lá gbaan' uʼnintuɔli, ");
INSERT INTO gngNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ki wuure' ufaa bo ki ye: «Yesu, Uwien wà ŋa ŋmɔbe Nacentɔ ya Bijɛ, min nin sin tu lɛ nɛ? N gbáanh ŋɛ nɛ, Uwien bo, la jɛ̀nde nni.» ");
INSERT INTO gngNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Yesu tɔke' usɛnpol nnɔ ki ye wɔ ń siere ujɛ nnɔ saan ma nnɔ nɛ cère' u len' nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Nɛn saan nɛ *Yesu niire' wɔ ki ye: «Bi yih ŋɛ ba?» Nɛ u ye: «Ti yɛbe ma nnɔ, bi yih nni Ligol nɛ,» ");
INSERT INTO gngNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","ki tùɔreh ki gbáanh wɔ ki teh u la ŋɔre bɛ kí ñɛn mitinfɛnm nnɔ ni. ");
INSERT INTO gngNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Tɔ, fangambɛ biba mɔ là te niʼsaan ligbɛngbɛnl bo ki yɛbe ka dindin, bi kpaah bɛ. ");
INSERT INTO gngNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Nɛ isɛnpol nnɔ gbáan' *Yesu ki ye wɔ ń cɛ̀be yɛ̀, yɛ̀ ń jo kí tì kɔ fangambɛ biɛ nɔ. ");
INSERT INTO gngNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","U tuo', nɛ ì siere' ujɛ nnɔ saan, ki tì kɔn' fangambɛ nnɔ. Nɛ fangambɛ nnɔ kɛ sɛn' ki tinde' ligbɛngbɛnl, ki tì lu' miñunm ni ki luo'. Fangambɛ nnɔ là li baa tɛn itur ile. ");
INSERT INTO gngNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Bà kpaah fangambɛ nnɔ sɛn' ki jon' udu ni nin idugbaan ki tì tɔke' binib tigbɛr nnɔ. Bi cii' tù ma nnɔ, nɛ ki baa' bɛ ń lá liike nà tien'. ");
INSERT INTO gngNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Bi baa' *Yesu saan ki laa' ujɛ wà isɛnpol yà yɛbe là ŋaake wɔ nnɔ ya yɛnm jire' u kɛ ki guo, nɛ bujɛwaanbu cuo' bɛ. ");
INSERT INTO gngNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Nɛ binib bà là te niʼsaan ki laa' *Yesu cère' ujɛ nnɔ faake' ma bo nin nà tien' fangambɛ nnɔ tɔke' bɛ niʼkɛ. ");
INSERT INTO gngNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Nɛ bi gbáan' *Yesu ki ye wɔ ń ñɛ biʼtinfɛnm ni. ");
INSERT INTO gngNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Nɛ u liɛbe' ki kɔn' buñɛrbu. U liɛbeh wɔ ń tì kɔ buñɛrbu ma nnɔ nɛ ujɛ wà isɛnpol là ŋaake wɔ nnɔ gbáanh wɔ ki teh wɔ ń cère wɔ ń paan uʼbo. ");
INSERT INTO gngNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Nɛ u yìe', ki tɔke' wɔ ki ye: «Liɛbe kí kun kí tì tɔke aʼden yaab Yonbdaan muɔ' ŋɛ micɛcɛkm ki tien' nà kɛ ki de' ŋɛ nnɔ.» ");
INSERT INTO gngNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Nɛ u bure' ki gɛ̀breh mitinfɛnm mà bi yih mɛ̀ Idu Piik nnɔ ni, ki tɔkeh binib *Yesu tien' nà kɛ ki de' wɔ. Nɛ nì cuo' biʼkɛ miyɔkm cɛɛn. ");
INSERT INTO gngNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","*Yesu liɛbe' ki puore' miñunciɛnm ya gbaatɔl nin buñɛrbu nɛ linigociɛnl taan' uʼsaan miñunm nnɔ ya gbaal. ");
INSERT INTO gngNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Nɛn saan nɛ *Sufmbɛ ya taanl ya duku ya ciɛn uba baa', bi yih wɔ Yayirus. U laa' *Yesu ma nnɔ, nɛ ki gbaan' uʼnintuɔli, ");
INSERT INTO gngNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ki gbáan' wɔ cɛɛn ki ye: «Nʼbisɛ benh wɔ ń kpo nɛ. N gbáanh ŋɛ nɛ, dɛn kí taa aʼnuɔ kí paan uʼbo wɔ ń faake kí li fuobe.» ");
INSERT INTO gngNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Nɛ *Yesu paan' uʼbo ki bure', linigociɛnl pɛ uʼbo ki pɛbeh wɔ ikɛle kɛ. ");
INSERT INTO gngNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Tɔ, upii uba mɔ là te niʼsaan, ki laa' tifɛr ibin piik nin ile ta gben'. ");
INSERT INTO gngNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","U là jon' dɔktiɛmbɛ ligol saan, ki laa' ijɛnd kɛ ya bol biʼnuɔ ni, ki ñɛnde' uʼlike kɛ ki tì gben' na tungreh, ama uʼwìɛn nnɔ kpireh ki joh nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","U cii' bi lienh *Yesu bó, nɛ u maale' uʼyɛnm ni ki ye: «N mɛ' uʼwɛngolkaar mɔnɔn la, n li faake nɛ.» Nɛ ki pɛ *Yesu bo linigol nnɔ ni, ki tì mɛ' uʼwɛngolkaar. ");
INSERT INTO gngNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Uʼfɛr nnɔ pɔk ki gben' i ya tàan bo, nɛ u bɛnde' uʼgbɛn ni ki ye uʼwìɛn nnɔ gben'-a! ");
INSERT INTO gngNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","U ya yo nɛ *Yesu mɔ pɔk ki bɛnde' ki ye mituɔm miba ñɛn' uʼni, nɛ ki jiɛbe' linigol nnɔ ni ki niire' ki ye: «Ŋmɛ mɛ' nʼwɛngolkaar-i?» ");
INSERT INTO gngNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Nɛ uʼpanpaankaab tɔke' wɔ ki ye: «A laa' linigol liɛ pɛbeh ŋɛ ikɛle kɛ ma bo nɛ a niireh ki teh ŋmɛ mɛ' ŋɛ-ɛɛ?» ");
INSERT INTO gngNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Nɛ u jiɛbeh ki likeh niʼkɛ saan wɔ ń lɛ udaan wà mɛ' wɔ. ");
INSERT INTO gngNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Upii nnɔ bɛn nibonn nà tien' wɔ ma nnɔ, nɛ bujɛwaanbu cuo' wɔ uʼgbɛnɛnt ŋɔh. Nɛ u baa' ki lá gbaan' *Yesu ya nintuɔli, ki tɔke' wɔ tigbɛmɔ̀nt kɛ. ");
INSERT INTO gngNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Nɛ *Yesu tɔke' wɔ ki ye: «Nʼbisɛ, aʼtekjim nɛ ŋmiɛn' ŋɛ. Li joh nin uyɛnduɔn. Aʼwìɛn nnɔ gben' nínɔ.» ");
INSERT INTO gngNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","*Yesu laan te ki lienh, nɛ binib biba ñɛn' Yayirus donbó ki lá tuobe' bɛ usɛn ni nɛ ki tɔke' Yayirus ki ye: «Aʼbisɛ kpo'-a! La ji ń li ŋmɔbe Cɛnbaa yɛnŋaabe.» ");
INSERT INTO gngNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","*Yesu cii' bi len' ma bo. Nin nɛn kɛ u tɔke' wɔ ki ye: «La fɛnge, teke nni kí ji baba.» ");
INSERT INTO gngNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Nɛ ka cère' binib kɛ paan' uʼbo, u cère' Piɛr nin Saak nin Saak ya ninjɛ San baba nɛ paan' uʼbo. ");
INSERT INTO gngNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Bi tì baa' Yayirus den nɛ ki cii' kuwaaku bó. Binib te niʼsaan ki yɛbe, ki muɔh ki kpìɛndeh cɛɛn. ");
INSERT INTO gngNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","*Yesu kɔn' iden nnɔ ni nɛ ki niire' bɛ ki ye: «Bɛ tien' ni muɔh ki ŋmɔbe kuwaaku nɔ nnɔ? Kibuk nnɔ ŋa kpo', kì gɔh nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","U len' nnɔ ma nnɔ, nɛ bi lɛh wɔ. Nɛn saan nɛ u ŋɔre' biʼkɛ ki ñɛn' saali, nɛ ki taa' kibuk nnɔ ya naa nin kiʼbaa nin uʼpanpaankaab bita nnɔ ki kɔn' kì te kuduku kùa ni nnɔ, ");
INSERT INTO gngNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","nɛ ki cuo' kiʼnuɔ, ki tɔke' kɛ̀ biʼlenm ni ki ye: «Talita kumi,» niʼtingi si: «Kibupiikɛ, n tɔkeh ŋɛ nɛ fii!» ");
INSERT INTO gngNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Nɛ kì fii' ki sere' i ya tàan bo, ki cuonh. Bi laa' nnɔ ma nnɔ, nɛ nì cuo' biʼkɛ miyɔkm ki tì kɛnde'. Kì là yé ibin piik nin ile ya bupiik nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Nɛ *Yesu kpɛkpɛ' biʼbo, ki ye bi la tɔke nil, nɛ ki ye bɛ ń de kɛ̀ tijier kɛ̀ ń ji. ");
INSERT INTO gngNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","*Yesu siere' niʼsaan ki liɛbe' uʼdu ni nɛ uʼpanpaankaab paan' uʼbo. ");
INSERT INTO gngNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","*Saba ya daali nɛ u kɔn' biʼtaanl ya duku ni, ki wɔknh binib Uwien ya gbɛr. Nì cuo' linigol là cenge uʼbó nnɔ miyɔkm cɛɛn, nɛ bi niireh tɔb ki teh: «U laa' nɛn kɛ lɛ saan-i? U laa' la miɛ ya yɛnfuom-i? U teh miyɔkm ya bont tà nɔ, u teh mila ki teh tù? ");
INSERT INTO gngNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Kanpinta ŋa ñí-ii? Mari ya bijɛ ŋa ñí-ii? Saak nin Yosɛ nin Sud nin Simɔn ya ninjɛ ŋa ñí-ii? Uʼninsiɛb ŋa te niɛ saan-ii?» Nnɔ nɛ biʼyɛnm ŋa ŋmaake' uʼbo nɛ ba teke' uʼgbɛr. ");
INSERT INTO gngNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Nɛ u tɔke' bɛ ki ye: «*Uwien ya ñɔbonsɔknl kɛ ñɔbonsɔknl ya du ni yaab nin uʼdensɛn yaab nin uʼdencɛnl yaab baba nɛ ŋa boh wɔ.» ");
INSERT INTO gngNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","U taa' uʼnuɔ ki paan' biwiɛnb biba bo nɛ bi faake' baba ŋa ñí la, wa ji fre ki tien' yɔkm ya bontɔnn niʼsaan. ");
INSERT INTO gngNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ba teke' wɔ ki jin' ma nnɔ nɛ nì cuo' wɔ miyɔkm cɛɛn. U siere' niʼsaan nɛ ki cuonh itengbaan ni ki wɔknh binib tigbɛmɔnmɔnt. ");
INSERT INTO gngNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","U yin' uʼpanpaankaab piik nin bile nɛ ki sɔn' bɛ bilele, ki de' bɛ mituɔm bɛ ń li ŋuɔh isɛnpol binib saan. ");
INSERT INTO gngNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Nɛ ki tɔke' bɛ ki ye: «Ni joh la, ni la tuke jier, ki la tuke kɔl, ki la cùɔn like, ki la tuke niba nin nitɔnn, ní li tuke ugbien baba, ");
INSERT INTO gngNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","kí cɛke itacaan, ki la tuke liɛr ile mɔ. ");
INSERT INTO gngNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ni tì baa' nà kɛ saan bi teke' nɛ iden yà ni la, ni la lèbre den kí tì baa' lidaali là ni li siere niʼsaan. ");
INSERT INTO gngNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Nà saan ya nib ŋa teke' nɛ ki yìe' niʼgbɛr la, ní siere nɛ̀ kí kpakpaare niʼtàan ya tɛngunku kí wiɛ nɛ̀. Nɛn nɛ li yé niʼsaan ya nib bo kudìɛku.» ");
INSERT INTO gngNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Nɛ uʼpanpaankaab bure' ki tì kpaandeh tigbɛmɔnmɔnt ki teh: «Lèbre mɛn niʼtetem.» ");
INSERT INTO gngNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Nɛ ki ŋuɔh isɛnpol ì yɛbe binib saan ki taah mikpɔm ki faanh biwiɛnb bi yɛbe, nɛ bi faakreh. ");
INSERT INTO gngNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Tɔ, *Yesu ya yel kpienh niʼkɛ saan haali ubɛr Herod mɔnɔn tì cii', kimɛ bi lienh *Yesu bo ki teh San wà là siih binib Uwien ya ñunm nnɔ nɛ mɛkre' bitɛnkpiib ni. Nɛn nɛ cère' u ŋmɔbe mituɔm ki teh miyɔkm ya bont. ");
INSERT INTO gngNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Bitɔb lienh ki teh u yé Eli nɛ. Bitɔb mɔ teh u yé *Uwien ya ñɔbonsɔknl tɛn biñɔbonsɔkntɔb bà là te uyo bo nnɔ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Herod cii' *Yesu ya gbɛr ma nnɔ nɛ ki ye: «N là cère' bi tùkre' San wà ya yul nnɔ wɔn nɛ mɛkre' bitɛnkpiib ni.» ");
INSERT INTO gngNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Nà cère' Herod len' nnɔ si: wɔn nin uʼyul nɛ là cère' uʼsojambɛ cuo' San ki lòle' wɔ tikudɔkr ki pɛkn', uʼpo Herodiyad bo. Kimɛ Herodiyad là yé Herod ya ninjɛ Filip ya po nɛ, nɛ u taa' wɔ ki kuɔn'. ");
INSERT INTO gngNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Tɔ, San tɔke' Herod ki ye wa ŋmɔbe sɛn wɔ ń taa uʼninjɛ ya po. ");
INSERT INTO gngNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Nɛn bo nɛ Herodiyad là nɛn San ki yíe wɔ ń ku wɔ, ka ń fre, ");
INSERT INTO gngNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","kimɛ Herod là boh San nɛ, ki bɛn ki ye u yé unimɔ̀n nɛ, ki yé Uwien ya nil, nɛ ka sɛ̀ uʼbo. Herod là cengeh San ya gbɛr la, wa ji tì bɛn u maaleh ki teh bà, ama u nín yíe wɔ ń li tuu ki cengeh uʼbó nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ama lidaali liba Herodiyad laa' u li dule nà bo. Herod maa' uwien wà nnɔ gɔbre' ki baa', nɛ u tien' tijier tù yɛbe, ki yin' binikpɛkpiɛkb nin uʼsojaciɛnb nin Galile ya tinfɛnm ya ciɛnb bɛ ń baa kí lá ji. ");
INSERT INTO gngNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Bi te ki jinh ma nnɔ nɛ Herodiyad ya bisɛ baa' ki lá ŋɔn' kiciɛk biʼkɛ ya nun bó. Ubɛr Herod nin bà kɛ jinh uʼsaan tijier nnɔ ya yɛnm sɔnge' uʼbo. Nɛ u tɔke' ujɛfaan nnɔ ki ye: «Miɛ nni a yíe nà, ń de ŋɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Nɛ ki pole' ki ye: «A miɛ' nni nà kɛ la, n li de ŋɛ nɛ̀ nɛ; haali nì yé nʼbɛl ya gbiirm bolm mile mɔnɔn la, n li tuo.» ");
INSERT INTO gngNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Nɛ ujɛfaan nnɔ ñɛn' ki tì niire' uʼnaa ki ye: «Nʼnaa, n li tɔke wɔ kí ye wɔ ń de nni ba?» Nɛ u tɔke' uʼbisɛ ki ye: «Tɔke kí ye a yíe San wà siih binib Uwien ya ñunm nnɔ ya yul nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Nɛ u pɔk ki liɛbe' ki kɔn' i ya tàan bo ubɛr Herod saan, ki tɔke' wɔ ki ye: «N yíe itàan yiɛ bo á tùkre San wà siih binib Uwien ya ñunm nnɔ ya yul nɛ kí kpìen kikɛnsɛnk ni kí de nni.» ");
INSERT INTO gngNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","U len' nnɔ ma nnɔ, nɛ nì saa' ubɛr Herod ya yɛnm ki gbien'. Ama u pole' bicɛnb ya nun bó ma nnɔ nɛn nɛ cère' wa yìe'. ");
INSERT INTO gngNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Nɛn saan nɛ u sɔn' soja uba i ya tàan bo wɔ ń jo kí tì gɛ kí tùkre San ya yul ní. Nɛ soja nnɔ jon' lipɛkl ni ki tì cuo' San ki tùkre' liyul, ");
INSERT INTO gngNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ki kpìen' kikɛnsɛnk ni, ki lá de' ujɛfaan nnɔ. Nɛ uʼmɔ taa' ki tì de' uʼnaa. ");
INSERT INTO gngNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","San ya panpaankaab cii' nì te nnɔ, nɛ ki baa' ki lá yuure' uʼgbɛnɛnt, ki tì sube'. ");
INSERT INTO gngNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Tɔ, *Yesu ya tondb liɛbe' ki taan' uʼsaan, nɛ ki tɔke' wɔ bi tien' nà kɛ nin bi wɔkn' binib nà kɛ. ");
INSERT INTO gngNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Binib mɔ te niʼsaan ki yɛbe, biba joh, bitɔb liɛbeh. Nɛn bo nɛ wɔn nin uʼpanpaankaab ŋa laa' fɛnm mɔnɔn bɛ ń ji jier. Nɛ u tɔke' bɛ ki ye: «Cère mɛn tí bure nib ŋa te nà saan kí tì ń li te tiʼba kí fuore waamu.» ");
INSERT INTO gngNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Nɛn saan nɛ bi kɔn' buñɛrbu ki bure' biʼbaba nib ŋa te nà bó. ");
INSERT INTO gngNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ama binib laa' bi cubn' nà bó, bà yɛbe bɛnde' bɛ nɛ ki ñɛn' idu kɛ ni, ki sɛn' ki kpiɛ' ki baa' niʼsaan nin bɛ. ");
INSERT INTO gngNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","*Yesu baa' ki ñɛn' buñɛrbu ni uyo wà nnɔ nɛ ki laa' linigociɛnl liba. Nɛ ki muɔ' bɛ micɛcɛkm cɛɛn, kimɛ bi te tɛn ipe yà ŋa ŋmɔbe wà kpaah yɛ̀ nɛ. Nɛn bo nɛ u cin' ki tɔkeh bɛ tigbɛr tù yɛbe. ");
INSERT INTO gngNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Uwien benh wù ń kɔ ma nnɔ nɛ uʼpanpaankaab baa' ki lá tɔke' wɔ ki ye: «Ti te ñiɛn ŋa te nà saan nɛ, nɛ uwien mɔ benh wù ń kɔ ma nɔ, ");
INSERT INTO gngNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","cère binib biɛ nɔ ń jo mudufifiirmu nin itengbaan yà kɔkuɔ niɛ saan nɔ ni kí tì dɛ niba kí ji.» ");
INSERT INTO gngNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Nɛ u tɔke' bɛ ki ye: «Ninbi bugbɛn de bɛ mɛn bɛ ń ji.» Nɛ bi niire' wɔ ki ye: «A yíe tí ñɛn iwentun kobiile ya tuonl ya paaku nɛ kí dɛ kpɔnɔ kí lá de bɛ, bɛ ń ŋmɔn-ii?» ");
INSERT INTO gngNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Nɛ u niire' bɛ ki ye: «Ni ŋmɔbe kpɔnɔ uŋɛ? Jo mɛn kí liike.» Nɛ bi bure' ki tì liike', ki liɛbe' ní ki lá tɔke' wɔ ki ye: «Ti ŋmɔbe kpɔnɔ uŋun nin ijɛn ile nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Nɛ u tɔke' uʼpanpaakaab ki ye bɛ ń cère binib nnɔ kɛ ń kɛ̀le timɔsɔngt bo icɛk icɛk. ");
INSERT INTO gngNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Nɛ bi kɛ̀kɛ̀le' icɛk icɛk binib piŋunŋun nin binib kokobk. ");
INSERT INTO gngNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Nɛn saan nɛ u yuure' kpɔnɔ uŋun nin ijɛn ile nnɔ, ki yaare' ki liike' paaki, nɛ ki faare' Uwien, ki kɔkuɔ', ki taa' ki de' uʼpanpaankaab bɛ ń gbiire binib nnɔ kɛ. Bi gbiire' ijɛn ile nnɔ mɔ ki tí taa' ki de' biʼkɛ. ");
INSERT INTO gngNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Biʼkɛ ŋmɔn' ki gbo', ");
INSERT INTO gngNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","nɛ bi tantaan' kpɔnɔjenjent nin tijɛnjenjent tà sìen' nnɔ, ki gbien' ikpɛncub piik nin ile. ");
INSERT INTO gngNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Binib bà jin' tijier nnɔ bijɛb là te itur iŋun nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","I ya tàan bo nɛ *Yesu wɔbn' uʼpanpaankaab ki ye bɛ ń liɛbe kí kɔ buñɛrbu nnɔ kí liere wɔ usɛn kí puore miñunciɛnm ya gbaatɔl kí jo Bɛtsayida ya du ni ŋɔ wɔn bugbɛn ń cɛ̀be linigol nnɔ lɛ̀ ń kun. ");
INSERT INTO gngNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","U cɛ̀be' linigol nnɔ ma nnɔ nɛ ki don' lijuɔl bo wɔ ń tì kàare. ");
INSERT INTO gngNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Uʼpanpaankaab joh ma nnɔ nì tì biire' ki laa' buñɛrbu nnɔ te miñunm ya siik ni nɛ; nɛ *Yesu te liwɛl bo uʼbaba. ");
INSERT INTO gngNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","U laa' kutafaaku tobreh bɛ, nì faa biʼbo ki gbien' ba ji li fre kí kùre. Ukuojɛmuɔyo nɛ u cuonh miñunm bo ki joh biʼsaan ki tì nɛkn' bɛ ki benh wɔ ń gɛ̀bre. ");
INSERT INTO gngNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Bi laa' unil cuonh miñunm bo ma nnɔ bi maaleh ki teh nì yé ufɛnfɛnd nɛ. Bujɛwaanbu cuo' bɛ ki gbien' nɛ bi wuure'. Nɛ u tɔke' bɛ i ya tàan bo ki ye: «Cuo mɛn niʼba, Min *Yesu nɛ, la sɛn mɛn jɛwaanbu.» ");
INSERT INTO gngNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Nɛ ki kɔn' biʼsaan buñɛrbu ni. U kɔn' buñɛrbu ni nɛ kutafaaku nnɔ go. Nɛ nì bɛke' bɛ cɛɛn. ");
INSERT INTO gngNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Biʼyɛnm là libe' ma nnɔ nɛ cère' ba bɛnde' u taa' kpɔnɔ ki tien' miyɔkm ya bonn nà nnɔ ya tingi. ");
INSERT INTO gngNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Yesu nin uʼpanpaankaab tì baa' miñunciɛnm ya gbaatɔl, Genesarɛt ya tinfɛnm ni, ki ñɛn' buñɛrbu ni, nɛ ki lòle' bù. ");
INSERT INTO gngNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Bi ñɛn' buñɛrbu ni uyo nnɔ nɛ binib bɛnde' *Yesu i ya tàan bo. ");
INSERT INTO gngNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Nɛ ki tiinh ki joh mitinfɛnm nnɔ ni niʼkɛ saan, ki tukeh biwiɛnb inagɛn bo. Bi cii' u te nà saan la, nɛ bi taah bɛ ki joh uʼsaan. ");
INSERT INTO gngNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","U jon' iducɛnciɛn ni bii itengbaan ni la, bi taah biwiɛnb nɛ ki lá siendeh binib taakeh nà saan, ki gbáanh wɔ ki teh wɔ ń cère biwiɛnb ń mɛ uʼliɛrku ya ñɔgbɛn baba. Bà kɛ mɛ' uʼliɛrku ya ñɔgbɛn nnɔ kɛ faake' nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","*Farisiɛnmbɛ nin *Yiko ya wɔnwɔknb biba ñɛn' Yerusalɛm bó, ki baa' ki lá taan' *Yesu saan. ");
INSERT INTO gngNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Bi laa' *Yesu ya panpaankaab biba jinh inɔbɔnjɔkn, niʼtingi si: ba nire' ki paan' iyaajɛbok ye ma bo. ");
INSERT INTO gngNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Tɔ, *Farisiɛnmbɛ nin Suftɔb kɛ pɛ biʼyaajɛbok bo nɛ. Ba nire' ki paan' biʼyaajɛbok ye ma bo la, ba ń ji jier. ");
INSERT INTO gngNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Nɛ bi ñɛn' kidaak ki baa' ka sɔkre' biʼba ki paan' biʼyaajɛbok ye ma bo la, ba ń ji jier. Bi liɛbe' ki ŋmɔbe iyaajɛboktɔ mɔ ì yɛbe: tɛn tiñunñuwɛnt nin icùɔn nin tikur ya sɛ̀n ya cɛndm. ");
INSERT INTO gngNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Nɛ *Farisiɛnmbɛ nin *Yiko ya wɔnwɔknb nnɔ niire' *Yesu ki ye: «Bɛ tien' aʼpanpaankaab ŋa pɛ tiʼyaajɛbok ye ma bo?» ");
INSERT INTO gngNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Nɛ u jiin' bɛ ki ye: «Ninbi iñuɔn ilele ya nibɛ, Uwien ya ñɔbonsɔknl Esayi là len' niʼgbɛr ma nnɔ, u là ŋmɔbe imɔ̀n nɛ. U là len' ki ye Uwien ye: ‹Binib biɛ pɛ̀keh nni buñɔbu ni nɛ, biʼyɛnm ŋa nɛke nʼsaan. ");
INSERT INTO gngNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Bi pukeh nni fɛnm nɛ, ki wɔknh binib iyaajɛbok baba.› ");
INSERT INTO gngNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Nɛ *Yesu tí tɔke' bɛ ki ye: ‹Ni wiɛnh *Uwien ya wɔbl, nɛ ki boh iyaajɛbok.› » ");
INSERT INTO gngNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Nɛ ki tí tɔke' bɛ ki ye: « ‹Ninbi ya bùol, kí wiɛ *Uwien ya wɔbl, kí paan niʼyaajɛbok bo ŋa faa-a!› ");
INSERT INTO gngNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Kimɛ Moyis là len' ki ye: ‹Li boh aʼnaa nin aʼbaa›, ki tí len' ki ye: ‹Unil tɔke' uʼnaa bii uʼbaa liñɔbonbil la, bɛ ń ku wɔ.› ");
INSERT INTO gngNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ama ninbi wɔknh binib ki cèreh bi lienh ki teh bi bi li de biʼnaambɛ nin biʼbaambɛ nà nnɔ, ji yé ‹kɔrban nɛ› ba ji li fre kí de bɛ nɛ̀. Kɔrban ya tingi si: nì yé Uwien yaann nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Nɛn bo, ninbi nɛ cèreh ba toreh biʼnaambɛ nin biʼbaambɛ. ");
INSERT INTO gngNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Nnɔ nɛ ni taah niʼyaajɛbok ki lèbeh Uwien ya gbɛr, ki tɔkeh yɛ̀ niʼtɔb ki nɛbreh, ki teh tibontɔr tɛn tuu nɔ tù yɛbe.» ");
INSERT INTO gngNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesu tí yin' linigol nnɔ, nɛ ki tɔke' bɛ ki ye: «Niʼkɛ ń li cengeh nʼbó ŋɔ kí cii n li tɔke nɛ tigbɛr tà nɔ ya tingi. ");
INSERT INTO gngNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Tibont tà kɔh unil ya ñɔbu ni ŋa ń fre kí kuɔn wɔ jɔknt. Tà ñɛh uʼfɛ̀l ni nnɔ, tun nɛ kuɔndeh wɔ tijɔknt. ");
INSERT INTO gngNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Wà ŋmɔbe litubl la, wɔ ń cii.» ");
INSERT INTO gngNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","U siere' ki dàan' linigol nnɔ ki tì kɔn' iden iba ni. U ya yo nɛ uʼpanpaankaab niire' wɔ mikpɛnjɛnm nnɔ ya tingi. ");
INSERT INTO gngNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Nɛ u tɔke' bɛ ki ye: «Niʼmɔ ŋa laan biɛ ki bɛn tibont ya tingi nɛ-ɛɛ? Na bɛn ki ye tibont tà kɔh unil ya ñɔbu ni ŋa ń fre kí kuɔn wɔ jɔknt-ii? ");
INSERT INTO gngNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Kimɛ ta kɔh uʼfɛ̀l ni, tù kɔh uʼpuoku ni nɛ, nɛ u joh kunincɛnku ki ñɛndeh tù.» *Yesu len' nnɔ ma nnɔ, u wuɔn' ki ye jier tuba ŋa kùɔ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","U tí ye: «Tibont tà ñɛh unil ya fɛ̀l ni nnɔ, tun nɛ kuɔndeh wɔ tijɔknt. ");
INSERT INTO gngNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Kimɛ tibonbiɛrt ñɛh unil ya fɛ̀l ni nɛ. Tun si: iyɛnmaalbiɛre nin lisɔnsɔndl nin bunasubu nin linikul ");
INSERT INTO gngNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","nin linaŋmaal nin ununfɔke nin mibiɛrm nin milɛrkjim nin fɛnfɛnm nin mituom nin isuk nin tigbengt nin mijɔ̀rtetem. ");
INSERT INTO gngNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Tibonbiɛrt tuu kɛ ñɛh unil ya fɛ̀l ni nɛ, ki kuɔndeh wɔ tijɔknt.» ");
INSERT INTO gngNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","*Yesu siere' niʼsaan, nɛ ki jon' Tir ya tinfɛnm ni. U kɔn' iden iba ni, ka yíe uba ń bɛnde kí ye u te niʼsaan ama wa fre' ki bɔle' uʼba. ");
INSERT INTO gngNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Tɔ, upii uba là te mitinfɛnm nnɔ ni usɛnpol ŋaake uʼbisɛ. U cii' *Yesu bó, nɛ ki baa' i ya tàan bo ki lá gbaan' uʼnintuɔli. ");
INSERT INTO gngNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Upii nnɔ ŋa yé Suf, bi maa' wɔ Siri ya tinfɛnm ya kɛle wà bi wù Fenisi nnɔ ni nɛ. U gbáan' *Yesu ki ye wɔ ń ŋɔre usɛnpol wà ŋaake uʼbisɛ nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Nɛ *Yesu tɔke' wɔ ki ye: «Cère mubumu ń ji kí gbo kí yaan, kimɛ na mɔn bɛ ń taa mubumu ya jier kí wiɛ isɛngbɛle.» ");
INSERT INTO gngNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Nɛ upii nnɔ ye: «Yonbdaan, nì yé imɔ̀n nɛ, ama isɛngbɛle jinh mubumu ya jieyɔyɔl yà luh tingi ni nnɔ nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Nɛ *Yesu tɔke' wɔ ki ye: «Aʼñɔbonmɔnmɔnl liɛ bo, li jo, usɛnpol nnɔ dàan' aʼbuk ŋɔ.» ");
INSERT INTO gngNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","U liɛbe' ki kun', ki tì baa' ki laa' usɛnpol nnɔ mɔnbe ki dàan' uʼbuk ŋɔ, kì dɔ kuduku ni. ");
INSERT INTO gngNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","*Yesu tí siere' Tir ya tinfɛnm ni, ki ñɛn' Sidɔn ya du ni, ki jon' Galile ya ñunciɛnm ya kɛle wà te mitinfɛnm mà bi yih mɛ̀ Idu Piik nnɔ bó. ");
INSERT INTO gngNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Tɔ, binib biba tuke' ugbaanlɛntɛb uba ki baa' uʼsaan, ki gbáan' wɔ ki ye wɔ ń taa uʼnuɔ kí paan uʼbo. ");
INSERT INTO gngNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Nɛ *Yesu taa' wɔ ki ñɛn' linigol nnɔ ni, ki jon' ugbɛ, ki taa' uʼnɔbii ki tuun' ugbaan nnɔ ya tub ni, ki sìi' tiñinsɛnt ki mɛ uʼlɛnl, ");
INSERT INTO gngNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","ki yaare' ki liike' paaki, ki fuore' ki jiin', nɛ ki ye «Efata,» niʼtingi si: «Ñɛre.» ");
INSERT INTO gngNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Nɛ uʼtub ñɛre' i ya tàan bo, uʼlɛnl mɔ tɛbre', nɛ u cin' ki lienh mɔnmɔnm. ");
INSERT INTO gngNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Nɛ *Yesu kpɛkpɛ' biʼbo ki ye bi la tɔke uba. Nin u kpɛpkɛ' biʼbo ma kɛ nnɔ, bi tùɔreh ki kpaandeh tù nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Nì cuo' binib miyɔkm ki tì kɛnde' nɛ bi lienh ki teh: «U teh nà kɛ nnɔ mɔn nɛ, haali ki tì cèreh igbaan mɔnɔn ciih, ki cèreh bilɛntɛb mɔ lienh.» ");
INSERT INTO gngNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","I ya dɛn nɛ, linigociɛnl liba tí taan' *Yesu saan. Ba ŋmɔbe niba bɛ ń ji, nɛ u yin' uʼpanpaankaab ki tɔke' bɛ ki ye: ");
INSERT INTO gngNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«Linigol liɛ nɔ ŋmɔbe nni micɛcɛkm cɛɛn nɛ. Bi te nʼsaan ma wienta sɔ. Ba ji ŋmɔbe niba bɛ ń ji. ");
INSERT INTO gngNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Biba ñɛn' ní fɔnfɔkm nɛ. N cɛ̀be' bɛ bi kunh ka jin' niba la, bi li tì dɔre usɛn ni.» ");
INSERT INTO gngNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Nɛ uʼpanpaankaab jiin' wɔ ki ye: «Ti te ñiɛn ŋa te nà saan nɛ. Ŋmɛ li fre kí lɛ tijier niɛ saan kí de binib biɛ kɛ bɛ ń ji kí gbo?» ");
INSERT INTO gngNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Nɛ u niire' bɛ ki ye: «Ni ŋmɔbe kpɔnɔ uŋɛ?» Nɛ bi ye: «Ulole.» ");
INSERT INTO gngNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Nɛ u tɔke' linigol nnɔ ki ye lɛ̀ ń kɛ̀le tingi ni, nɛ ki yuure' kpɔnɔ ulole nnɔ, ki faare' Uwien, ki kɔkuɔ' ki taa' ki de' uʼpanpaankaab, bɛ ń gbiire linigol nnɔ. Nɛ bi taa' ki gbiire' bɛ. ");
INSERT INTO gngNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Bi ŋmɔbe mujɛnwawaamu muba mɔ. Nɛ u yuure' muʼmɔ, ki faare' Uwien, nɛ ki ye bɛ ń taa muʼmɔ kí gbiire linigol nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Biʼkɛ ŋmɔn' ki gbo', nɛ bi tantaan' tijenjent tà sìen' nnɔ, ki gbien' ikɛndɛn ilole. ");
INSERT INTO gngNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Binib nnɔ là li baa tɛn itur inan. Nɛn saan nɛ u cɛ̀be' bɛ, ");
INSERT INTO gngNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","nɛ wɔn nin uʼpanpaankaab kɔn' buñɛrbu i ya tàan bo ki bure' Dalmanuta ya tinfɛnm bó. ");
INSERT INTO gngNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","*Farisiɛnmbɛ baa' ki lá cin' ki niɛh nin *Yesu miniɛm. Bi yíe bɛ ń biike wɔ nɛ ki tɔke' wɔ ki ye wɔ ń tien miyɔkm ya bonn nà li wuɔn kí ye uʼtuɔm ñɛn' Uwien saan nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","*Yesu fuore' ki jiin', nɛ ki tɔke' bɛ ki ye: «Bɛ tien' fɛnfɛnnɔ ya nib biɛ nuunh bɛ ń lɛ miyɔkm ya bonn-i? N tɔkeh nɛ imɔ̀n nɛ, ba ń lɛ yɔkm ya bonn niba.» ");
INSERT INTO gngNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Nɛ ki siere' biʼsaan ki liɛbe' ki kɔn' buñɛrbu ki joh wɔ ń tì puore miñunciɛnm. ");
INSERT INTO gngNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Tɔ, Yesu ya panpaankaab là sunde' ka tuke' kpɔnɔ. Kpɔnɔ uba kpein nɛ là te biʼsaan buñɛrbu ni. ");
INSERT INTO gngNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","*Yesu kpɛkpɛ' biʼbo ki ye: «Li bɛn mɛn *Farisiɛnmbɛ nin Herod ya kpɔnɔ ya ñɔke bó.» ");
INSERT INTO gngNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Nɛ bi tɔkeh tɔb ki teh: «Ta tuke' kpɔnɔ ma nnɔ nɛ cère u len' nnɔ.» ");
INSERT INTO gngNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","*Yesu bɛnde' bi tɔkeh tɔb ki teh bà, nɛ ki niire' bɛ ki ye: «Bɛ tien' ni tɔkeh tɔb ki teh na tuke' kpɔnɔ? Na laan biɛ ki freh ki sekndeh tibont nɛ-ɛɛ? Bii na ciih tuʼtingi nɛ? Niʼyɛnm biɛ ki liibe nɛ-ɛɛ? ");
INSERT INTO gngNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ni ŋmɔbe inun, bɛ tien' na lɛnh-i? Ni ŋmɔbe itub, bɛ tien' na ciih-i? Na tiɛn, ");
INSERT INTO gngNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","n là taa' kpɔnɔ uŋun ki kɔkuɔ', ki gbiire' binib itur iŋun ma nnɔ, ni là tantaan' nà sìen' nnɔ ki gbien' ikpɛncub ubiɛn wà nɛ-ɛɛ?» Nɛ bi ye: «Piik nin ile.» ");
INSERT INTO gngNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Nɛ u liɛbe' ki niire' bɛ ki ye: «Na tiɛn n là taa' kpɔnɔ ulole ki kɔkuɔ', ki gbiire' binib itur inan ma nnɔ, ni là tantaan' tijenjent tà sìen' nnɔ ki gbien' ikɛndɛn ubiɛn wà nɛ-ɛɛ?» Nɛ bi ye: «Ilole.» ");
INSERT INTO gngNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Nɛ u ye: «Na laan biɛ ki ciih tibont ya tingi nɛ-ɛɛ?» ");
INSERT INTO gngNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yesu nin uʼpanpaankaab tì baa' Bɛtsayida ya du ni, nɛ bi tuke' ujuɔn uba ki baa' *Yesu saan, ki gbáan' wɔ ki ye wɔ ń taa uʼnuɔ kí mɛ wɔ. ");
INSERT INTO gngNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","*Yesu cuo' uʼnuɔ, nɛ ki dɛ̀re' wɔ ki ñɛn' udu ni, ki sii' tiñinsɛnt, ki sèkn ujuɔn nnɔ ya nun, ki taa' uʼnuɔ ki paan' uʼbo, ki niire' wɔ ki ye: «A lɛnh nibonn-ii?» ");
INSERT INTO gngNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","U likre', nɛ ki ye: «N lɛnh binib ama bi naan isiin nɛ ki cuonh.» ");
INSERT INTO gngNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Nɛ *Yesu liɛbe' ki taa' uʼnuɔ ki pi' uʼnun bó, u faake' nɛ ki tùɔre' ki ŋɛbe' inunbii ki caan' ki ji lɛnh tibont kɛ mɔnmɔnm. ");
INSERT INTO gngNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Nɛ *Yesu tɔke' wɔ ki ye wɔ ń li kun ki la liɛbe udu nnɔ ni. ");
INSERT INTO gngNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","*Yesu nin uʼpanpaankaab siere' niʼsaan ki bure' iduwawaale yà te ka fɔke nin Sesare Filip ya tinfɛnm nnɔ bó. Bi joh ma nnɔ nɛ u niire' bɛ ki ye: «Binib lienh ki teh n yé ŋmɛ nɛ?» ");
INSERT INTO gngNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Nɛ bi jiin' wɔ ki ye: «Biba lienh ki teh a yé San wà siih binib Uwien ya ñunm nɛ. Bitɔb lienh ki teh a yé Eli nɛ. Bitɔb mɔ lienh ki teh a yé *Uwien ya ñɔbonsɔknb ya uba nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Nɛ u niire' bɛ ki ye: «Ninbi nín teh n yé ŋmɛ nɛ?» Nɛ Piɛr jiin' wɔ ki ye: «A yé Uwien ya Nigɛndkɛ Kristo nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Nɛn saan nɛ *Yesu kpɛkpɛ' biʼbo ki ye bi la tɔke nil u yé udaan wà. ");
INSERT INTO gngNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ni ya puoli bó nɛ Yesu cin' ki tɔkeh uʼpanpaankaab ki teh: «Nì kpɛ Unil ya Bijɛ ń ji ijɛnd kí gbien nɛ. *Sufmbɛ ya ciɛnb nin bitɔtuɔrciɛnb nin *Yiko ya wɔnwɔknb li wiɛ uʼgbɛr, kí ku wɔ, nɛ wienta daali wɔ ń mɛkre bitɛnkpiib ni.» ");
INSERT INTO gngNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","U tɔke' bɛ tigbɛr nnɔ tù wien nɛ. Nɛn saan nɛ Piɛr taa' wɔ ki jɛnde', ki tì kɔn' nin wɔ ki ye u la lienh ki teh nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ama *Yesu jiɛbe' ki liike' uʼpanpaankɛtɔb nɛ ki tiɛn' Piɛr bo ki ye: «Paare nʼpuoli, Satan. Kimɛ aʼyɛnmaale ŋa ñɛn' Uwien saan, ì yé binib yi nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Nɛ ki yin' linigol nin uʼpanpaankaab ki tɔke' bɛ ki ye: «Unil yíe wɔ ń paan nʼbo la, u la tɔnge uʼba, wɔ ń li yuunh uʼdɔpɔnpɔn ki bukeh ki paakeh nʼbo. ");
INSERT INTO gngNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Kimɛ wà kɛ yíe wɔ ń fie uʼmiɛl la, wɔn nɛ li kpo kí juore fɛnm. Ama wà kɛ li tuo kí kpo min nin tigbɛmɔnmɔnt tuu bo nnɔ, wɔn nɛ li lɛ limiɛl. ");
INSERT INTO gngNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Unil laa' uŋɛndun wuu ni ya bont kɛ ŋɔ ki tì luo' limiɛl la, u laa' bɛ ya kpɛle nɛ? ");
INSERT INTO gngNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Unil li taa bà kí pɛ̀ kí teke uʼmiɛl-i? ");
INSERT INTO gngNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Unil ye min nin nʼgbɛr ŋmɔbe wɔ ifɛ fɛnfɛnnɔ ya nib bà ŋa cuube Uwien saan, ki yé bibiɛrdɛnb nnɔ saan la, udaan mɔ lá li ŋmɔbe nni ifɛ nɛ uyo wà Unil ya Bijɛ lá li baa ní nin Uwien ya tondb, wɔ ń li ŋmɔbe uʼBaa Uwien ya kpiɛke nnɔ.» ");
INSERT INTO gngNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","U tí tɔke' bɛ ki ye: «N tɔkeh nɛ imɔ̀n nɛ, ninbi bà se niɛ saan nɔ ya biba li lɛ Uwien ya bɛl we ní nin mituɔm nɛ kí yaan kí kpo.» ");
INSERT INTO gngNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Iwien iluob gɛ̀bre', nɛ *Yesu taa' Piɛr nin Saak nin San ki jɛnde' ki tì don' lijɔfɔfɔkrl liba bo biʼbaba. Uʼgbɛnɛnt lèbre' biʼnun bó, ");
INSERT INTO gngNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","nɛ uʼwɛngolkaar pende' kponkpon, ki windeh tein. Uba ŋa te uŋɛndun wuu ni kí fre kí tien kukpɛlciɛku kù ń li pìen nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Nɛ bi laa' Eli nin Moyis puɔ' uʼsaan bi tɔkeh tigbɛr. ");
INSERT INTO gngNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Nɛn saan nɛ Piɛr tɔke' *Yesu ki ye: «Cɛnbaa, ti te niɛ saan ma nɔ, nì mɔn nɛ. Cère tí pɔ ininbon ita, sin liba, Moyis liba, Eli mɔ liba.» ");
INSERT INTO gngNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Piɛr ŋa bɛn u li len kí ye bà, kimɛ bujɛwaanbu cuo' wɔn nin bipanpaankɛtɔb nnɔ ki gbien'-a. ");
INSERT INTO gngNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Kutɛwɔlgbɔnku kuba baa' ki pibn' biʼbo, nɛ bi cii' uniɛke uba bó kutɛwɔlgbɔnku nnɔ ni u ye: «NʼBijɛ sɔ nɔ, n yíe wɔ, li cengeh mɛn uʼbó.» ");
INSERT INTO gngNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","I ya tàan bo nɛ bi jiɛbe' ki liike', ka ji laa' nitɔ, bi laa' *Yesu baba nɛ se biʼsaan. ");
INSERT INTO gngNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Bi jiinh lijuɔl nnɔ ya tingi ma nnɔ, nɛ *Yesu kpɛkpɛ' biʼbo ki ye bi la tɔke uba bi laa' nà nɔ kí tì baa uyo wà Unil ya Bijɛ li mɛkre bitɛnkpiib ni nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Nɛ bi tuo' u ye ma nnɔ, ama ki ji niireh tɔb ki teh u ye wɔ ń ye ba nɛ ki ye «kí mɛkre bitɛnkpiib ni?» ");
INSERT INTO gngNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Nɛ ki niire' wɔ ki ye: «Bɛ bo nɛ Yiko ya wɔnwɔknb lienh ki teh Eli li baa nɛ kí yaan Kristo ń baa ní?» ");
INSERT INTO gngNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Nɛ u jiin' bɛ ki ye: «Eli li mɔnbe kí kpiɛ kí baa kí lá tùɔre tibont kɛ nɛ kí yaan. Ama nì nín tien' mila ki liɛbe' ki kɛle' *Uwien ya gbɔnku ni ki ye binib li jɛ̀nde Unil ya Bijɛ kí gbien, kí yuɔn wɔ? ");
INSERT INTO gngNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","N tɔkeh nɛ nɛ, Eli baa' ní ŋɔ. Nɛ bi tien' wɔ bi yíe ma bo. Bi tien' wɔ tɛn nì kɛle' ma uʼbo *Uwien ya gbɔnku ni nnɔ nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Tɔ, *Yesu nin uʼpanpaankaab bita nnɔ tì baa' uʼpanpaankɛtɔb saan, nɛ ki laa' linigociɛnl se ki guɔn' bɛ. *Yiko ya wɔnwɔknb biba mɔ te, ki niɛh nin bɛ miniɛm. ");
INSERT INTO gngNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Linigol nnɔ laa' *Yesu i ya tàan bo ma nnɔ, nɛ nì cuo' biʼkɛ miyɔkm cɛɛn. Nɛ bi sɛn' ki jon' ki tì fuonde' wɔ. ");
INSERT INTO gngNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Nɛ u niire' uʼpanpaankaab ki ye: «Ninbi nin bɛn niɛh bɛ bo?» ");
INSERT INTO gngNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Nɛ linigol nnɔ ni, ujɛ uba tɔke' wɔ ki ye: «Cɛnbaa, n tuke' nʼbuk nɛ ki baa' aʼsaan. Usɛnpol uba nɛ ŋaake kɛ̀, ki tien' kɛ̀ ulɛntɛb. ");
INSERT INTO gngNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","U cuo' kɛ̀ nà saan la, u gbɔ̀breh kɛ̀ nɛ, nɛ kuñinsɛnjujuku puubeh kiʼñɔbu bó, kì ŋmɔnh iñin, kiʼgbɛnɛnt mɔ tɛreh. N gbáan' aʼpanpaankaab bɛ ń ŋɔre usɛnpol nnɔ, nɛ ba fre'.» ");
INSERT INTO gngNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Nɛ *Yesu tɔke' bɛ ki ye: «Ninbi fɛnfɛnnɔ ya nibɛ, na teke' Uwien ki jin'. N li wuɔke niʼsaan kí tì kpaan mila nɛ? N li ŋmɔbe sukle niʼbo kí tì kpaan mila nɛ?» Nɛ ki ye: «Taa mɛn kibuk nnɔ ní.» ");
INSERT INTO gngNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Nɛ bi taa' kɛ̀ ki baa' uʼsaan. Usɛnpol nnɔ laa' *Yesu ma nnɔ nɛ ki cère' kiʼgbɛnɛnt ŋɔh pepebu, kì lu' ki bindeh, kuñinsɛnjujuku puubeh kiʼñɔbu bó. ");
INSERT INTO gngNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Nɛ *Yesu niire' kiʼbaa ki ye: «Nì cin' kɛ̀ ma nì wuɔke'-aa?» Nɛ kiʼbaa ye: «Nì cin' kɛ̀ haali kiʼbuwaam ni nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","U sɔbe ki gbɔ̀breh kɛ̀ umu nin miñunm ni nɛ, ki nuunh wɔ ń ku kɛ̀. A li fre la, á muɔ tɛ micɛcɛkm kí tore tɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Nɛ *Yesu ye: «Bɛ tien' a ye n li fre la? Wà teke' ki jin' ŋa ń gbɛle niba.» ");
INSERT INTO gngNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Nɛ kibuk nnɔ ya baa wuure' i ya tàan bo ki ye: «N teke' ŋɛ ki jin', tore nni, kimɛ nʼtekjim nɛ pɔre' nni.» ");
INSERT INTO gngNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","*Yesu laa' linigol nnɔ tiinh ki taakeh ní, nɛ u tiɛn' usɛnpol nnɔ bo ki ye: «Usɛnpol wà teh binib igbaanlɛntɛb nnɔ n tɔkeh ŋɛ nɛ, dàan kibuk kiɛ, ki la ji ń ŋɛkn kɛ̀ lidaali liba.» ");
INSERT INTO gngNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Usɛnpol nnɔ wuure', nɛ ki cère' kibuk nnɔ ya gbɛnɛnt ŋɔh pepebu, nɛ ki dàan' kɛ̀. Kì dɔ ki naan utɛnkpii, nɛ binib bà yɛbe ye kì kpo'-a! ");
INSERT INTO gngNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ama *Yesu cuo' kiʼnuɔ ki fin' kɛ̀. Nɛ kì fii' ki sere'. ");
INSERT INTO gngNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","*Yesu kun' ma nnɔ nɛ uʼpanpaankaab niire' wɔ biʼbaba bo ki ye: «Bɛ tien' tinbi ŋa fre' ki ŋɔre' usɛnpol nnɔ?» ");
INSERT INTO gngNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Nɛ u jiin' bɛ ki ye: «Yiɛ ya sɛnpol ya bol wɔn, ikaare baba ŋa ñí la, bonn ŋa te kí fre kí ŋɔre yɛ̀.» ");
INSERT INTO gngNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yesu nin uʼpanpaankaab siere' niʼsaan, nɛ ki cuon' ki càare' Galile ya tinfɛnm. *Yesu ŋa yíe uba ń li bɛn u te nà saan, ");
INSERT INTO gngNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","kimɛ u yíe wɔ ń wɔkn uʼpanpaankaab nɛ. U tɔke' bɛ ki ye: «Bi li taa Unil ya Bijɛ kí ŋukn binib, bɛ ń ku wɔ. Ama wienta daali u li mɛkre bitɛnkpiib ni.» ");
INSERT INTO gngNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Uʼpanpaankaab ŋa cii' uʼlenm nnɔ ya tingi nɛ ka kaabe' bɛ ń niire wɔ mɔ. ");
INSERT INTO gngNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Yesu nin uʼpanpaankaab tì baa' Kapɛrnawum ya du ni, nɛ ki kɔn' kuduku kuba ni. Bi te kuduku nnɔ ni ma nnɔ, nɛ u niire' bɛ ki ye: «Ni bi niɛh bɛ bo usɛn ni?» ");
INSERT INTO gngNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Nɛ bi se ki ŋmin, kimɛ bi bi niɛh ticiɛnt bo nɛ usɛn ni. ");
INSERT INTO gngNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Nɛn saan nɛ u kɛ̀le' ki yin' uʼpanpaankaab piik nin bile nnɔ kɛ, nɛ ki tɔke' bɛ ki ye: «Unil yíe wɔ ń li yé usɛnlier la, wɔ ń tien uʼba biʼkɛ ya gbaarkɛ, kí li yé biʼkɛ ya tonsɔnl.» ");
INSERT INTO gngNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Nɛ ki taa' kibuk kiba ki sien' biʼsiik ni, ki yuure' kɛ̀ ki bibe', ki tɔke' bɛ ki ye: ");
INSERT INTO gngNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«Wà kɛ teke' kibuk tɛn kiɛ nʼyel bo la, u teke' min nɛ. Wà kɛ teke' nni la, na yé u teke' min nɛ, u teke' wà sɔn' nni ní nnɔ nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Nɛn saan nɛ San tɔke' wɔ ki ye: «Cɛnbaa, ti laa' unil uba u ŋuɔh isɛnpol binib saan aʼyel bo. Wa pɛ tiʼbo ma nnɔ nɛ ti pien' wɔ.» ");
INSERT INTO gngNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Nɛ *Yesu ye: «La ji ń pien wɔ mɛn, kimɛ nil ŋa ń fre kí tien miyɔkm ya bonn nʼyel bo ŋɔ kí pɔk kí len nʼbo nà bre i ya tàan bo. ");
INSERT INTO gngNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Wà ŋa nɛn tɛ la, u se tiʼciɛk bó nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","N tɔkeh nɛ imɔ̀n nɛ, wà kɛ de' nɛ kiñunyibuok ki ye ni yé Kristo yaab ma nnɔ nɛ la, wa ń lúo uʼsuul fiebu.» ");
INSERT INTO gngNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","«Ama ibaan yà teke' nni ki jin' nɔ, unil cère' iʼni uba tùre' Uwien ya sɛn la, bi bi taa' linɛ̀ciɛnl, ki jɔn' uʼtule ni, ki ture' wɔ ki wiɛ' miñunciɛnm ni la, nì bi li tu udaan bo. ");
INSERT INTO gngNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Aʼnuɔ nɛ cèreh a biih la, cere wù. A ŋmɔbe unuɔ uba ŋɔ ki laa' limiɛl là ŋa ŋmɔbe gbenm la, nì tu nin á li ŋmɔbe inuɔ ile, ŋɔ kí kɔ umucɛnciɛn wà ŋa ń kpiin ni. ");
INSERT INTO gngNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Niʼsaan, ‹Mu ŋa ń kpiin. Ininbiɛb yà ŋmɔnh tigbɛnɛnt mɔ ŋa ń kpo.› ");
INSERT INTO gngNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Aʼtaal nɛ cèreh a biih la, cere lɛ̀. A ŋmɔbe litaal liba ŋɔ ki laa' limiɛl là ŋa ŋmɔbe gbenm la, nì tu nin á li ŋmɔbe itàan ile, ŋɔ kí kɔ umu wà ŋa ń kpiin ni.  ");
INSERT INTO gngNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Niʼsaan, ‹Mu ŋa ń kpiin. Ininbiɛb yà ŋmɔnh tigbɛnɛnt mɔ ŋa ń kpo.› ");
INSERT INTO gngNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Aʼnunbu nɛ cèreh a biih la, lìkre bù. A ŋmɔbe bununbu buba ki kɔn' Uwien ya bɛl ni la, nì tu nin á li ŋmɔbe inun ile, ŋɔ kí kɔ umu wà ŋa ń kpiin ni. ");
INSERT INTO gngNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Niʼsaan, ‹Mu ŋa ń kpiin. Ininbiɛb yà ŋmɔnh tigbɛnɛnt mɔ ŋa ń kpo.› ");
INSERT INTO gngNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","«Umu nɛ li cère unil kɛ ń ŋmaake tɛn miyaam. ");
INSERT INTO gngNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Miyaam yé nibonn nà mɔn nɛ. Ama mì saa' ka ji ŋmɛ la, niba ŋa te kí ji ń fre kí ŋmaake mɛ̀. Ní li ŋmɛ tɛn miyaam, kí li ŋmɛ nin tɔb.» ");
INSERT INTO gngNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","*Yesu siere' niʼsaan, nɛ ki jon' Sude ya tinfɛnm mà te Sudɛn ya kpenpuol bó nnɔ ni. Inigol tí taan' uʼsaan, nɛ u tí wɔkn' bɛ tɛn u tí ń teh ma bo. ");
INSERT INTO gngNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","*Farisiɛnmbɛ biba nɛkn' wɔ ki yíe bɛ ń biike wɔ, nɛ ki niire' wɔ ki ye: «Ujɛ ŋmɔbe usɛn wɔ ń wiɛ uʼpo-oo?» ");
INSERT INTO gngNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Nɛ u niire' bɛ ki ye: «Moyis là ye ní li teh mila?» ");
INSERT INTO gngNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Nɛ bi ye: «Moyis là ye ujɛ yíe wɔ ń wiɛ uʼpo la, wɔ ń kɛle kugbɔnku kí de wɔ kí wuɔn kí ye u wiɛ' wɔ.» ");
INSERT INTO gngNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Nɛ *Yesu ye: «Niʼyufaa bo nɛ cère' Moyis là kɛle' ki ye ní li teh nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ama micincinm, uyo wà Uwien là ñɛn' uŋɛndun wuu nnɔ, ‹u là ñɛn' ujɛ nin upii nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Nɛn nɛ cère' ujɛ kuɔn' upii la, u li dàan uʼnaa nin uʼbaa, ");
INSERT INTO gngNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","nɛ bɛn bile nnɔ ń taan kí tien unibaab.› Nnɔ nɛ ba ji te nib bile, bi ji yé unibaab nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Tɔ, Uwien taan' nà la, nil la bore nɛ̀.» ");
INSERT INTO gngNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Bi tì baa' iden nɛ uʼpanpaankaab mɔ liɛbe' ki niire' wɔ tigbɛr nnɔ bo. ");
INSERT INTO gngNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Nɛ u jiin' bɛ ki ye: «Ujɛ wà wiɛ' uʼpo, ki tí kuɔn' upiitɔ la, ujɛ nnɔ yé ujɛnaŋmaa nɛ uʼpo ukpiɛk nnɔ bo. ");
INSERT INTO gngNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Upii wà fii' uʼcɛ saan, ki tì kun' ujɛtɔ la, upii nnɔ yé upiinaŋmaa nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Tɔ, binib tukeh mubumu, ki bàareh *Yesu saan ŋɔ wɔ ń mɛ mù, nɛ uʼpanpaankaab kɔnh nin bɛ. ");
INSERT INTO gngNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","U laa' bi kɔnh nin bɛ ma nnɔ, na ŋmaake' wɔ, nɛ u tɔke' bɛ ki ye: «Cère mɛn mubumu mù ń li bàareh nʼsaan. La piendeh mù mɛn, kimɛ binib bà te tɛn mubumu nɛ si Uwien ya bɛl. ");
INSERT INTO gngNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","N tɔkeh nɛ imɔ̀n nɛ, wà kɛ ŋa teke' Uwien ya bɛl ya gbɛr kibuk yaam la, wa ń kɔ liʼni.» ");
INSERT INTO gngNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Nɛn saan nɛ u yuunh mubumu nnɔ, ki taah uʼnuɔ ki paakeh muʼbo, ki teh mù Uwien ya mɔnm. ");
INSERT INTO gngNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","*Yesu siereh uyo wà nnɔ, nɛ ujɛ uba sɛn' ki baa' ki lá gbaan' uʼnintuɔli, ki niire' wɔ ki ye: «Cɛnbaa wà mɔn, n li tien mila kí lɛ limiɛl là ŋa ŋmɔbe gbenm-i?» ");
INSERT INTO gngNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Nɛ *Yesu niire' wɔ ki ye: «Bɛ tien' a yih nni wà mɔn-i? Uwien baba ŋa ñí la, uba ŋa mɔn. ");
INSERT INTO gngNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","A bɛn iwɔb yà ye: ‹La ku nil, ki la teh naŋmaal, ki la suh, ki la nɛndeh nib bo, ki la jinh nib, kí li boh aʼnaa nin aʼbaa nnɔ.› ");
INSERT INTO gngNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Nɛ ujɛ nnɔ ye: «Cɛnbaa, n boh niʼkɛ haali nʼbuwaam ni nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","*Yesu liike' wɔ, uʼyɛnm sɔnge' uʼbo, nɛ u tɔke' wɔ ki ye: «Nibonn niba nɛ pɔre' ŋɛ. Jo kí tì kuɔre a ŋmɔbe tibont tà kɛ nnɔ, kí taa ilike nnɔ kí de bicɛcɛkdɛnb, kí li ŋmɔbe lifaal paaki bó, ŋɔ kí baa kí lá paan nʼbo.» ");
INSERT INTO gngNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","*Yesu len' nnɔ ma nnɔ, nɛ ujɛ nnɔ saa' uʼnun bó, ki siere' ki bure' nin uyɛnsaa, kimɛ u ŋmɔbe lifaal ki gbien'. ");
INSERT INTO gngNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","*Yesu jiɛbe' ki liike' uʼpanpaankaab, nɛ ki tɔke' bɛ ki ye: «Nì faa ki gbien' nin binib bà ŋmɔbe lifaal nnɔ ń kɔ Uwien ya bɛl ni.» ");
INSERT INTO gngNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","U len' nnɔ ma nnɔ, nɛ miyɔkm cuo' uʼpanpaankaab cɛɛn, nɛ u tí tɔke' bɛ ki ye: «Nʼbumu, Uwien ya bɛl ni ya kɔm faa cɛɛn nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Nì faa nin ufàandaan ń kɔ Uwien ya bɛl ni ki cɛn' ñɔkma ń càare mikpɛlpienbonm ni.» ");
INSERT INTO gngNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Nì tùɔre' ki bɛke' bɛ cɛɛn, nɛ bi tɔkeh tɔb ki teh: «O, nì te nnɔ la, ŋmɛ li fre kí ŋmɛre?» ");
INSERT INTO gngNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","*Yesu caan' biʼbo inun, nɛ ki tɔke' bɛ ki ye: «Binib nɛ ŋa ń fre, Uwien wɔn ŋa ń gbɛle niba, u li fre kí tien niʼkɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Nɛ Piɛr tɔke' wɔ ki ye: «Tinbi wɔn la, ti dàan' tibont kɛ nɛ ki paan' aʼbo-a!» ");
INSERT INTO gngNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Nɛ *Yesu ye: «N tɔkeh nɛ imɔ̀n nɛ, unil wà kɛ dàan' uʼden bii uʼninjiɛb bii uʼninsiɛb bii uʼnaa bii uʼbaa bii uʼbumu bii uʼkpàan min nin tigbɛmɔnmɔnt bo la, ");
INSERT INTO gngNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","u li lɛ iden nin ninjiɛb nin ninsiɛb nin naambɛ nin mubumu nin ikpàan, niʼkɛ bolm kobk fɛnfɛnnɔ, ama u li lɛ ijɛnd mɔ. Nɛ uyo wà we ní nnɔ, u lá li lɛ limiɛl là ŋa ŋmɔbe gbenm. ");
INSERT INTO gngNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Bisɛnlierb lá li paan puoli ki yɛbe. Puoli bó yaab mɔ lá li liere usɛn ki yɛbe.» ");
INSERT INTO gngNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","*Yesu nin uʼpanpaankaab doh Yerusalɛm bó, nɛ u le usɛn. Bi joh ma nnɔ uʼpanpaankaab ya yɛnm saa' nɛ bujɛwaanbu cuo' bà mɔ pɛ uʼbo nnɔ. Nɛn saan nɛ u tí yin' uʼpanpaankaab piik nin bile nnɔ uʼba saan nɛ ki cin' ki tɔkeh bɛ nà li tì tu wɔ niʼbó. ");
INSERT INTO gngNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","U tɔke' bɛ ki ye: «Li cengeh mɛn, ti doh Yerusalɛm bó nɛ. Ti tì baa' la, bi li taa Unil ya Bijɛ kí ŋukn bitɔtuɔrciɛnb nin *Yiko ya wɔnwɔknb, bɛ ń bu wɔ tibuur, kí ye u kpɛ mikuum, kí taa wɔ kí ŋukn bà ŋa yé Sufmbɛ. ");
INSERT INTO gngNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Bi li lɛ̀ wɔ, kí cɛre uʼbo tiñinsɛnt, kí ñì wɔ inalɛbe, kí yaan kí ku wɔ, nɛ wienta daali wɔ ń mɛkre bitɛnkpiib ni.» ");
INSERT INTO gngNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Tɔ, Sebede ya bijiɛb Saak nin San nɛkn' Yesu, nɛ ki tɔke' wɔ ki ye: «Cɛnbaa, ti yíe á tuo kí tien ti li miɛ ŋɛ nà nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Nɛ u niire' bɛ ki ye: «Ni yíe ń tien ba nɛ kí de nɛ?» ");
INSERT INTO gngNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Nɛ bi ye: «A lá jin' aʼbɛl la, á cère tiʼni uba ń li kɛ aʼnɔjie bó, utɔ mɔ ń li kɛ aʼnɔgɛn bó.» ");
INSERT INTO gngNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Nɛ u ye: «Na bɛn ni miɛh nibonn nà. Ni li fre kí ji n li ji ijɛnd yà nnɔ-ɔɔ?» Bii ni li fre kí kɔ n li kɔ micɛcɛkm mà ni nnɔ ni-ii? ");
INSERT INTO gngNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Nɛ bi ye: «Ti li fre.» Nɛ u ye: «Imɔ̀n, ni li ji n li ji ijɛnd yà nnɔ, ki li kɔ n li kɔ micɛcɛkm mà ni nnɔ ni. ");
INSERT INTO gngNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ama binib bà li kɛ̀le nʼnɔjie nin nʼnɔgɛn bó nnɔ wɔn, na yé min nɛ li gɛ̀nde bɛ. Uwien nɛ li de mifɛnm nnɔ u bonde' mɛ̀ ki ble' binib bà nnɔ.» ");
INSERT INTO gngNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Uʼpanpaankaab piik bà sìen' nnɔ cii' Saak nin San tɔke' wɔ ki ye bà, nɛ biʼbenku ni cin' ki beh biʼbo. ");
INSERT INTO gngNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Nɛn saan nɛ u yin' bɛ uʼba saan ki tɔke' bɛ ki ye: «Ni bɛn nì te ma uŋɛndun wuu ni. Bà yé idu ya bɛrb wɔbndeh iʼnib nɛ, nɛ bà ŋmɔbe ticiɛnt nnɔ wɔngeh bɛ biʼtuɔm kpɛ ma bo. ");
INSERT INTO gngNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Na ń li te nnɔ ninbi ni. Niʼni wà yíe wɔ ń li yé uciɛn la, wɔ ń tien uʼba niʼtonsɔnl. ");
INSERT INTO gngNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Niʼni wà yíe wɔ ń li yé usɛnlier la, wɔ ń tien uʼba niʼkɛ ya yonb. ");
INSERT INTO gngNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Kimɛ Unil ya Bijɛ ŋa baa' uŋɛndun wuu ni bɛ ń sɔn kí de wɔ. U baa' wɔn nɛ ń sɔn kí de binib, kí kpo ŋɔ kí dɛ binib bà yɛbe kí wiɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","*Yesu nin uʼpanpaankaab tì baa' Seriko ya du ni. Bi ñɛh uʼni uyo wà nnɔ nɛ linigociɛnl paan' biʼbo. Ujuɔn uba kɛ sɛngbaal ki miɛh, bi yih wɔ Bartime, u yé Time ya bijɛ. ");
INSERT INTO gngNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","U cii' bi ye Nasarɛt ya *Yesu nɛ gɛ̀breh, nɛ u cin' ki wuureh ki teh: «Yesu, *Dafid ya yaabile, muɔ nni micɛcɛkm.» ");
INSERT INTO gngNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Linigol nnɔ tɛngeh uʼbo ki teh wɔ ń ŋmile, ama u tùɔreh ki wuureh nɛ ki teh: «*Dafid ya yaabile, muɔ nni micɛcɛkm.» ");
INSERT INTO gngNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Nɛ *Yesu sere' ki ye: «Yin wɔ mɛn ní.» Nɛ bi yin' wɔ ki tɔke' wɔ ki ye: «Cuo aʼba! Fii kí sere, u yih ŋɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Nɛ u wiɛ' uʼliɛrgbenku, ki fii' wukbu, ki baa' *Yesu saan. ");
INSERT INTO gngNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","*Yesu niire' wɔ ki ye: «A yíe ń tien ba kí de ŋɛ?» Nɛ u ye: «Cɛnbaa, n yíe ń likre nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Nɛ *Yesu ye: «Li joh, aʼtekjim nɛ ŋmiɛn' ŋɛ.» U likre' i ya tàan bo, nɛ ki paan' *Yesu bo. ");
INSERT INTO gngNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","*Yesu nin uʼpanpaankaab tì nɛke Yerusalɛm ki tuo' Bɛtifaaje nin Betani ya du. Ì te Olifi ya siin ya juɔl bó nɛ. Bi tì tuo' niʼsaan ma nnɔ, nɛ u sɔn' uʼpanpaankaab ni bile ");
INSERT INTO gngNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ki tɔke' bɛ ki ye: «Li joh mɛn udu wà te inun bó nɔ ni. Ni tì kɔn' uʼni la, ni li pɔk kí lɛ uŋuunfanfaan uba lùo. Uba ŋa laan jɛ̀ke' wɔ. Ní lore wɔ kí taa ní. ");
INSERT INTO gngNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Unil niire' nɛ ki ye bɛ tien' ni loreh wɔ la, ní ye: ‹Yonbdaan nɛ ciɛke wɔ. U li jiin wɔ ní fɛnfɛnnɔ wuɔ.› » ");
INSERT INTO gngNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Bi bure', nɛ ki tì laa' uŋuunfanfaan nnɔ lùo iden iba saali bunañɔbu saan ki nɛke usɛn. Nɛ bi cin' ki loreh wɔ. ");
INSERT INTO gngNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Binib bà se niʼsaan nnɔ ya biba niire' bɛ ki ye: «Ni teh ba sɔ? Bɛ tien' ni loreh uŋuunfanfaan wuɔ nɔ?» ");
INSERT INTO gngNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Nɛ bi jiin' bɛ *Yesu bi ye bɛ ń ye ma nnɔ. Nɛ binib nnɔ cɛ̀be' bɛ bi bure', ");
INSERT INTO gngNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","ki tuke' uŋuunfanfaan nnɔ ki baa' *Yesu saan, nɛ ki taa' biʼliɛr ki paan' uʼbo, *Yesu jɛ̀ke'. ");
INSERT INTO gngNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Nɛn saan nɛ biba taah biʼliɛr ki pɛ̀reh usɛn ni ki yɛbe. Bitɔb kɔh kumuɔku ni, ki bɛreh tifɛr ki mɔ lá pɛ̀reh. ");
INSERT INTO gngNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Bà le usɛn nnɔ nin bà pɛ puoli nnɔ kɛ wuureh ki teh: «Osana, Uwien ya mɔnm ń li te wà we ní Yonbdaan ya yel bo nnɔ bo. ");
INSERT INTO gngNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Uwien ya mɔnm ń li te tiʼyaajɛ *Dafid ya bɛl là we ní nnɔ bo. Osana, Uwien wà te paaki bó.» ");
INSERT INTO gngNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Tɔ, *Yesu tì baa' Yerusalɛm, ki kɔn' Uwien ya duku ya luo bo, ki liike' tibont kɛ. Uwien benh wù ń kɔ ma nnɔ, nɛ wɔn nin uʼpanpaankaab piik nin bile nnɔ ñɛn' ki bure' Betani ya du bó. ");
INSERT INTO gngNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Kutaaku faa', nɛ *Yesu nin uʼpanpaankaab ñɛn' Betani ya du ni ki bure'. Bi joh ma nnɔ nɛ mikònm tì cuo' wɔ. ");
INSERT INTO gngNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","U laa' bukɛnkɛnbu buba tì se fɔnfɔkm ki ŋmɔbe tifɛr. Nɛ u jon' wɔ ń tì liike u li lɛ niba buʼbo bii wa ń lɛ. U tì baa' buʼnintuɔli, ki laa' tifɛr baba nɛ buʼbo. Kimɛ na là yé kɛnkɛn ya lònlùonyo. ");
INSERT INTO gngNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Nɛ u tɔke' busubu nnɔ ki ye: «Uba ŋa ji li lɛ bil liba aʼbo fiebu.» Nɛ uʼpanpaankaab cii' u len' ki ye bà. ");
INSERT INTO gngNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Yesu nin uʼpanpaankaab tì baa' Yerusalɛm. Nɛ *Yesu kɔn' Uwien ya duku ya luo bo, ki cin' ki ŋuɔh binib bà kuɔreh tiwɛnt nin bà daanh tiwɛnt nnɔ ki ñɛndeh; ki tureh bilikkpendb ya teb nin bà kuɔreh inɛnjel nnɔ ya biɛmu ki gbɔ̀breh. ");
INSERT INTO gngNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Wa cèreh nib tukeh wɛnt ki gɛ̀breh Uwien ya duku ya luo bo. ");
INSERT INTO gngNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Nɛn saan nɛ u tɔke' bɛ ki ye: «Nì kɛle' *Uwien ya gbɔnku ni ki ye: ‹Bi li yin nʼduku inibol kɛ ya kaare ya duku nɛ›, ama ninbi taa' kù ki tien' binasub ya tantaanbùol nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Bitɔtuɔrciɛnb nin *Yiko ya wɔnwɔknb cii' *Yesu tien' ma bo. Nɛ bi nuunh bi li tien ma kí ku wɔ, ama ki ji fɛnge wɔ. Kimɛ uʼwɔknm sɔnge linigol nnɔ ya yɛnm cɛɛn nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Nì juɔre' ma nnɔ, nɛ *Yesu nin uʼpanpaankaab tí siere' udu nnɔ ni. ");
INSERT INTO gngNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Kutɛŋɛsɔnsɔnku, nɛ bi cuonh ki gɛ̀breh bukɛnkɛnbu nnɔ saan, ki laa' bù kuore' paaki ki tì ci' tingi. ");
INSERT INTO gngNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Nɛ Piɛr tiɛre' nà wun tien', nɛ ki tɔke' *Yesu ki ye: «Cɛnbaa, liike, a wun wiɛ' bukɛnkɛnbu bùa miŋùum nnɔ, kuore'-a!» ");
INSERT INTO gngNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Nɛ *Yesu tɔke' bɛ ki ye: «Teke mɛn Uwien kí ji. ");
INSERT INTO gngNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","N tɔkeh nɛ imɔ̀n nɛ, unil wà kɛ li tɔke lijuɔl liɛ kí ye lɛ̀ ń fii kí tì lu miñunciɛnm ni, ki teke' ki jin' ki ye nì li tien tɛn u len' ma bo, ka maaleh milele la, nì li tien nnɔ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Nɛn bo nɛ n tɔkeh nɛ ki teh ni miɛ' Uwien nibonn nà kɛ niʼkaare ni la, ní li du kí ye ni laa' nɛ ŋɔ, nɛ ni li mɔnbe kí lɛ nɛ̀ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Uyo wà ni te ki kàareh, kí lá tiɛre ki ye uba ŋmɔbe nɛ tigbɛr tà kɛ la, ní fère udaan ŋɔ niʼBaa wà te paaki bó nnɔ mɔ ń fère nɛ niʼbiil.  ");
INSERT INTO gngNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ama na fère' niʼtɔb la, niʼBaa wà te paaki bó mɔ ŋa ń fère nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yesu nin uʼpanpaankaab tí liɛbe' ki baa' Yerusalɛm ni. *Yesu kɔn' ki cuonh Uwien ya duku ya luo bo, nɛ bitɔtuɔrciɛnb nin *Yiko ya wɔnwɔknb nin *Sufmbɛ ya ciɛnb baa' uʼsaan, ");
INSERT INTO gngNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ki niire' wɔ ki ye: «A ŋmɔbe usɛn á tien a teh nà nɔ-ɔɔ? Ŋmɛ nɛ de' ŋɛ usɛn á tien nɛ̀?» ");
INSERT INTO gngNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Nɛ u ye: «Nʼmɔ li niire nɛ iniire iba kpein nɛ. Ni fre' ki jiin' nni la, nʼmɔ li tɔke nɛ n ŋmɔbe usɛn wà ki teh n teh nà nɔ. ");
INSERT INTO gngNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","San là siih binib Uwien ya ñunm ma nnɔ, ŋmɛ nɛ là de' wɔ usɛn-i? Uwien bii binib nɛ? Tɔke nni mɛn.» ");
INSERT INTO gngNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Nɛn saan nɛ bi tɔkeh tɔb ki teh: «Ti ye Uwien nɛ de' wɔ usɛn la, u li niire tɛ kí ye: ‹Bɛ tien' ta là teke' wɔ ki jin'-i?› ");
INSERT INTO gngNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ta ń fre kí ye binib mɔ sɔ.» Bi fɛnge linigol nnɔ mɔ, kimɛ biʼkɛ tuo' ki ye San là cinbe ki yé *Uwien ya ñɔbonsɔknl nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Nɛ bi tɔke' *Yesu ki ye: «Ta bɛn.» Nɛ uʼmɔ ye: «Nʼmɔ ŋa bɛn, ka ń tɔke nɛ wà de' nni usɛn ń tien n teh nà nɔ mɔ.» ");
INSERT INTO gngNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ni ya puoli bó nɛ *Yesu pɔn' bɛ mikpɛnjɛnm ki ye: «Ujɛ uba nɛ là ŋmɔbe bukpàabu, ki caan' bukpàabu nnɔ ni tisir tà bi taah tuʼbii ki ŋɛh fɛn nnɔ, nɛ ki bɛke' ki linde' bù, ki gbin' kubùoku kùa bi li ŋmɛngeh isibii nnɔ buʼni, ki caan' kininbɛntaak buʼni, ki taa' bù ki guun' bikpàab biba, nɛ ki bure' usɛn. ");
INSERT INTO gngNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Uyo wà isibii nnɔ tì ben' nnɔ, nɛ u sɔn' utonsɔnl uba bikpàab nnɔ saan, wɔ ń tì teke wɔn ukpɛdaan ya bó ní. ");
INSERT INTO gngNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Utonsɔnl nnɔ tì baa' nɛ bi cuo' wɔ ki ñi', ki ŋɔre' wɔ, u liɛbe' inuɔkuon. ");
INSERT INTO gngNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ukpɛdaan nnɔ tí sɔn' utonsɔntɔ biʼsaan. Nɛ bi tì ñiñi' ki cube' uʼyul, ki susuke' wɔ. ");
INSERT INTO gngNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","U tí liɛbe' ki sɔn' utonsɔntɔ biʼsaan. Wɔn tì baa' ma, bi ku' wɔ nɛ. U liɛbe' ki sɔnsɔn' bitonsɔnb biʼsaan bi yɛbe, bi tí ñiñi' biba, ki kuku' bitɔb. ");
INSERT INTO gngNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Uʼbijɛ baba nɛ ji sìen' uʼsaan, u yíe uʼbijɛ nnɔ cɛɛn. Nɛ u fɔre' ki sɔn' wɔ biʼsaan, ki maaleh ki teh u yé uʼbijɛ ma nnɔ, bi li tì bo wɔ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ama bikpàab nnɔ laa' uʼbijɛ nnɔ we ní ma nnɔ, nɛ bi tɔke' tɔb ki ye: ‹Wɔn nɛ yé uʼfaajil, cère mɛn tí ku wɔ ŋɔ lifaal nnɔ ń juore tiʼyaal.› ");
INSERT INTO gngNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Nɛ bi cuo' wɔ ki ku', ki ñɛn' ki tì wiɛ' kpɛgbaal. ");
INSERT INTO gngNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","«Tɔ, ukpɛdaan nnɔ li tien mila? U li baa kí lá ku bikpàab nnɔ nɛ, kí taa bukpàabu nnɔ kí guun bikpɛtɔb. ");
INSERT INTO gngNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Na kaan' *Uwien ya gbɔnku ni nì kɛle' nà saan ki ye: ‹Litɛnl là bidumɛb wiɛ' lɛ̀ nnɔ, lɛn nɛ lá tien' litɛnkpiɛkl là co kuduku nnɔ nɛ-ɛɛ? ");
INSERT INTO gngNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Yonbdaan nɛ tien' nnɔ, nɛ nì ŋmɔbe kuñuɔrku tiʼnun bó.› » ");
INSERT INTO gngNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","*Sufmbɛ ya ciɛnb bɛnde' ki ye *Yesu pɔn' bɛn nɛ mikpɛnjɛnm. Nɛn bo nɛ biʼnun mɔ́n bɛ ń cuo wɔ, ama bi fɛnge' linigol nnɔ nɛ ki siere' ki dàan' wɔ. ");
INSERT INTO gngNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Bi sɔn' *Farisiɛnmbɛ biba nin ubɛr Herod yaab ya biba *Yesu saan bɛ ń tì dɛle wɔ, wɔ ń len kí lòle uʼba. ");
INSERT INTO gngNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Bi tì baa' nɛ ki tɔke' wɔ ki ye: «Cɛnbaa, ti bɛn ki ye a tɔkeh tigbɛmɔ̀nt nɛ, ka fɛnge uba, ka boh uba ki cɛn' uʼtɔ. A wɔngeh tɛ Uwien ya sɛn mɔnmɔnm nɛ. Tɔ, ti ŋmɔbe usɛn tí li pɛ̀h lɛnpo ki dienh ubɛrciɛn Sesa bii ta ŋmɔbe? Tí li pɛ̀h bii ti la pɛ̀h?» ");
INSERT INTO gngNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","*Yesu bɛn ki ye bi yé iñuɔn ilele ya nib nɛ, nɛ ki tɔke' bɛ ki ye: «Bɛ tien' ni bìkreh nni? Taa mɛn milikbim miba ní ń liike.» ");
INSERT INTO gngNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Bi taa' ní; nɛ u niire' bɛ ki ye: «Ŋmɛ ya nɛnnɛnku nin uʼyel te miʼbo?» Nɛ bi ye: «Ubɛrciɛn Sesa.» ");
INSERT INTO gngNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Nɛ u tɔke' bɛ ki ye: «Taa mɛn nà yé Sesa yaann kí de Sesa, kí taa nà mɔ yé Uwien yaann, kí de Uwien.» U len' nnɔ ma nnɔ nɛ nì cuo' bɛ miyɔkm cɛɛn. ");
INSERT INTO gngNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Nì ya puoli nɛ Saduseyɛnmbɛ biba baa' *Yesu saan. Bɛn nɛ lienh ki teh bitɛnkpiib ŋa ń mɛkre nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Bi tɔke' wɔ ki ye: «Cɛnbaa, Moyis là kɛle' yiko ki de' tɛ ki ye: ‹Unil ya ninjɛ kpo' ki cère' uʼpo, ka ŋmɔbe buk la, wɔ ń kere ukpopii nnɔ, kí maa mubumu kí de uʼninjɛ wà kpo' nnɔ.› ");
INSERT INTO gngNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Tɔ, ninjiɛb bilole biba nɛ là te, nɛ ukpiɛk lá kuɔn' upii, ki kpo', ka maa' buk. ");
INSERT INTO gngNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Wà tɔ uʼbo nnɔ kere' ukpopii nnɔ ki mɔ kpo' ka maa' buk. Wà mɔ tɔ wɔn bo nnɔ mɔ kere' wɔ ki mɔ kpo' ka maa' buk. ");
INSERT INTO gngNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Bijɛb bilole nnɔ kɛ tien' nnɔ ki kpo' ka maa' buk. Upii nnɔ mɔ tì fɔre' ki kpo'. ");
INSERT INTO gngNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Tɔ, bitɛnkpiib lá mɛkre' uyo wà la, ŋmɛ li si upii nnɔ? Kimɛ biʼkɛ bilole kuɔn' wɔ ki tì bòn' nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Nɛ *Yesu jiin' bɛ ki ye: «Na bɛn nà kɛle' *Uwien ya gbɔnku ni ya tingi, ka bɛn Uwien ya tuɔm kpɛ ma bo. Nɛn nɛ cèreh ni tùreh. ");
INSERT INTO gngNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Bitɛnkpiib lá mɛkre' la, jɛb ŋa ń kuɔn piib, piib mɔ ŋa ń kun cɛr. Bi li te tɛn Uwien ya tondb nɛ paaki bó. ");
INSERT INTO gngNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Bitɛnkpiib ya mɛkrm mɛn la, na kaan' Moyis ya gbɔnku ni nà saan Uwien là len' nin Moyis kufɛtuku kuba saan kù teknh umu ka wih nnɔ nɛ-ɛɛ? U là tɔke' Moyis ki ye: ‹Min nɛ yé *Abraham nin *Isaak nin Sakɔb ya Wien.› ");
INSERT INTO gngNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Uwien ŋa yé tɛnkpiib ya Wien, u yé bà fuobe ya Wien nɛ. Ninbi lienh ki teh bitɛnkpiib ŋa ń mɛkre ma nnɔ ni tùre' kpɛlkpɛl nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","*Yiko ya wɔnwɔknl uba là te niʼsaan ki cii' bi niɛh nin tɔb ma, nɛ ki laa' *Yesu jiin' bɛ mɔnmɔnm ma bo. U nɛkn' *Yesu ki niire' wɔ ki ye: «Iwɔb kɛ nni li lɛ yé likpiɛkl-i?» ");
INSERT INTO gngNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Nɛ *Yesu jiin' wɔ ki ye: «Liwɔbkpiɛkl si: ‹Ninbi Israyɛl yaabɛ, li cengeh mɛn: Yonbdaan Uwien baba nɛ yé Yonbdaan. ");
INSERT INTO gngNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Li yíe aʼYonbdaan Uwien nin aʼfɛ̀l kɛ nin aʼtetem kɛ nin aʼyɛnmaale kɛ nin aʼtuɔm kɛ.› ");
INSERT INTO gngNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Liwɔbl là tɔ si: ‹Li yíe aʼtɔ tɛn a yíe aʼba ma bo.› Wɔbl liba ŋa te ki gɛ̀bre' liɛ ya wɔbl.» ");
INSERT INTO gngNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Nɛ u tɔke' *Yesu ki ye: «Cɛnbaa, a tɔke' tigbɛmɔ̀nt nɛ. A tɔke' ki ye Yonbdaan Uwien yé Uwenbaabe nɛ, uba ŋa te ki pukn' uʼbó ma nnɔ, tù te nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Unil yíe Uwien nin uʼfɛ̀l kɛ nin uʼyɛnmaale kɛ nin uʼtuɔm kɛ, ki yíe uʼtɔ tɛn u yíe uʼba ma bo la, nɛn nɛ mɔn ki cɛn' wɔ ń li taah tiwɛnt ki teh ituɔrɛ ki wìndeh ki dienh Uwien nin mipum kɛ ya bol.» ");
INSERT INTO gngNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","*Yesu laa' u len' nin mibɛnm, nɛ u tɔke' wɔ ki ye: «Ŋa fɔke nin Uwien ya bɛl.» Nɛn gɛ̀bre' ma nnɔ, uba ŋa ji kaabe' ki niire' *Yesu niire ki pukn'. ");
INSERT INTO gngNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","*Yesu là te Uwien ya duku ya luo bo, ki wɔknh binib Uwien ya gbɛr ma nnɔ, nɛ ki niire' bɛ ki ye: «Nì tien' mila *Yiko ya wɔnwɔknb lienh ki teh Uwien ya Nigɛndkɛ Kristo yé *Dafid ya yaabil-i? ");
INSERT INTO gngNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Mifuoñanm là cère' *Dafid bugbɛn len' ki ye: ‹Yonbdaan Uwien tɔke' nʼYonbdaan ki ye: Kɛ̀le nʼnɔjie bó, kí tì baa uyo wà n li cère á tɛ aʼnɛnnɛndb bo litaal.› ");
INSERT INTO gngNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","*Dafid mɔnɔn là yin' Uwien ya Nigɛndkɛ Kristo uʼYonbdaan la, u ji tien' mila ki liɛbe' ki yé uʼyaabil-i?» Linigociɛnl cengeh *Yesu ya gbɛr, nɛ nì ŋmɛ lɛ̀ cɛɛn. ");
INSERT INTO gngNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yesu wɔknh bɛ Uwien ya gbɛr, nɛ ki tɔkeh bɛ ki teh: «Li bɛn mɛn *Yiko ya wɔnwɔknb bó. Bi yíe bɛ ń li guoh tiliɛrgbengt nɛ ki gaakeh, ki yíe binib ń li gbaandeh ki fuondeh bɛ mudaamu ni, ");
INSERT INTO gngNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ki yíe bɛ ń li kaah binikpɛkpiɛkb ya kànkàan itáan ya dur ni nin tinacent ni. ");
INSERT INTO gngNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Bɛn nɛ jinh ki pendeh bikpopiib, ki kàareh nì wuɔkreh, ki bɔndeh binib ya nun bó. Nɛn bo nɛ Uwien li tùɔre kí dɛre biʼtub cɛɛn.» ");
INSERT INTO gngNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Tɔ, *Yesu kɛ ki nɛke Uwien ya pum ya likkpienbùol, nɛ ki likeh linigol nnɔ kpìendeh len ilike ma bo. Bifàadɛnb bà yɛbe bàareh ki kpìendeh ilike len ì yɛbe. ");
INSERT INTO gngNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ukpopiicɛcɛkdaan uba mɔ baa' ki lá kpìen' milikbim mile ma baa' gbɔnku kuba mɔnɔn. ");
INSERT INTO gngNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Nɛ *Yesu yin' uʼpanpaankaab ki tɔke' bɛ ki ye: «N tɔkeh nɛ imɔ̀n nɛ, ukpopiicɛcɛkdaan wuɔ kpìen' ilike ki cɛn' bà kɛ kpìen' nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Kimɛ biʼkɛ de' ka pɔkre' biʼlike ya pɔkl. Ama wɔn yé ucɛcɛkdaan nɛ, ki tonde' u ŋmɔbe nà kɛ nnɔ ki lá kpìen'.» ");
INSERT INTO gngNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","*Yesu siere' Uwien ya duku ya luo bo ki ñɛn', nɛ uʼpanpaankaab ni uba tɔke' wɔ ki ye: «Cɛnbaa, liike itɛn yiɛ gbenge ki kpɛ ma bo-a! Liike bi taa' yɛ̀ ki mɛn' tidur tù ŋmɔbe kuñuɔrku ma bo-a!» ");
INSERT INTO gngNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Nɛ u tɔke' wɔ ki ye: «A laa' tiduciɛnt tuu nɔ-ɔɔ? Bi lá li bere tuʼkɛ nɛ, tɛnl liba mɔnɔn ŋa lá li juore kí li pɛ tɔl bo.» ");
INSERT INTO gngNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesu jon' ki tì kɛ̀le' Olifi ya siin ya juɔl bo, Uwien ya duku ya nuun bó, nɛ Piɛr nin Saak nin San nin Andre baa' uʼsaan biʼbaba, ki lá niire' wɔ ki ye: ");
INSERT INTO gngNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«Tɔke tɛ, tibont nnɔ kɛ lá li tien uyo wà? Ku lɛ dìɛku ba li wuɔn kí ye uyo nnɔ baa'.» ");
INSERT INTO gngNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Nɛ u cin' ki tɔkeh bɛ ki teh: «Li bɛn mɛn, ki la cère uba ń tuln nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Kimɛ binib lá li baa ki yɛbe kí li ŋmɔbe nʼyel ki teh bi yé min nɛ, kí tuln binib bà yɛbe. ");
INSERT INTO gngNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ni lá cii binib tɔh lituɔl kɔnkɔnm ni bii fɔnfɔkm la, ni la cère niʼfɛ̀l ń li tiinh. Kimɛ tu ya bont kɛ li tien nɛ kí yaan, na laan yé gbengbenyo. ");
INSERT INTO gngNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Kimɛ linibol liba li jɛ̀ke linibotɔl. Libɛl liba ya nib mɔ li jɛ̀ke libɛtɔl yaab. Kitink li jènge bùol, bùol. Mikònm mɔ li lu. Nì li te tɛn imɛrwiɛn ya cincinm nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","«Ninbi bɛn wɔn, li bɛn mɛn. Bi lá li cuo nɛ kí jon tibuur, kí ñì nɛ itáan ya dur ni. Min bo, bi lá li tuke nɛ kí jo tibuur idu ya ciɛnb nin bibɛrb saan. Nnɔ nɛ ni li yé nʼmɔ̀nkunb biʼsaan. ");
INSERT INTO gngNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Bi li kpaande tigbɛmɔnmɔnt tuu inibol kɛ saan nɛ kí yaan. ");
INSERT INTO gngNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Bi cuo' nɛ ki jon' tibuur la, ni la pɔk kí li yɔke ni li len kí ye bà. Uyo nnɔ lá baa' la, *Mifuoñaanm nɛ li tɔke nɛ ni li len kí ye bà. Na yé ninbi nɛ li len, *Mifuoñaanm nɛ li len. ");
INSERT INTO gngNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","U ya yo nɛ unil li kuɔre uʼninjɛ, bɛ ń ku wɔ. Baa mɔ li kuɔre uʼbuk, bɛ ń ku kɛ̀. Mubumu mɔ li fii kí sere muʼnaambɛ nin muʼbaambɛ bo, kí cère bɛ ń ku bɛ. ");
INSERT INTO gngNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Min bo nɛ binib kɛ li nɛn nɛ. Ama wà kɛ li mìnde kí li ŋmɔŋmɔbe kí tì fɔre nnɔ, wɔn nɛ li ŋmɛre.» ");
INSERT INTO gngNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","«Ni li lɛ ijuɔke ya bonn nà saah tibont tà kɛ mɔn nnɔ se na bi li sere nà saan. (Wà kɛ kàanh la, wɔ ń li ciih niʼtingi.) Uyo nnɔ lá baa' la, bà li te Sude ya tinfɛnm ni nnɔ, bɛ ń sɛn kí jo ijuɔn bó. ");
INSERT INTO gngNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Wà te kudulɛkaaku ya paaki la, u la jiire kí kɔ iden ni, kí taa niba. ");
INSERT INTO gngNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Wà mɔ te ikpàan bó la, u la liɛbe kí kun, wɔ ń tì taa uʼliɛrgbenku. ");
INSERT INTO gngNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","U ya yo bipiib bà punbe nin bà ŋmɔbe mubumu mùa ŋaanh, li ŋmɔbe micɛcɛkm nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Li kàareh mɛn, Uwien la cère nɛ̀ ń tien kusɛnañuɔku. ");
INSERT INTO gngNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","I ya dɛn binib li ji ijɛnd kí gbien. Haali uŋɛndun ya cincinm kí lá baa fɛnfɛnnɔ, nib ŋa laan jin' i ya jɛnd ya bol, ka ji lì li ji yɛ̀ fiebu. ");
INSERT INTO gngNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Yonbdaan ŋa bi kùore' ijɛnd nnɔ ya wien bo la, uba mɔnɔn ŋa bi li ŋmɛre. U gɛ̀nde' binib bà nnɔ bo nɛ cère' u kùore' iwien nnɔ bo. ");
INSERT INTO gngNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","«U ya yo unil tɔke' nɛ ki ye: ‹Liike mɛn, Uwien ya Nigɛndkɛ Kristo te niɛ saan› bii ‹u te niɛ bó› la, ni la tuo. ");
INSERT INTO gngNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Kimɛ bitonnɛnmɔ̀nkunb li baa. Biba li ye bi yé Uwien ya Nigɛndkɛ Kristo nɛ. Bitɔb li ye bi yé *Uwien ya ñɔbonsɔknb nɛ. Bi li tien micincilnm ya bont nin miyɔkm ya bont, kí tuln binib. Bi li nuunh nì tuo' la, bɛ ń tuln Uwien gɛ̀nde' binib bà nnɔ mɔnɔn nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ninbi li bɛn mɛn. N kpiɛ' ki tɔke' nɛ tigbɛr nnɔ kɛ ŋɔ.» ");
INSERT INTO gngNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","«Ama, ijɛnd nnɔ ya yo gɛ̀bre' la, uwien li bìike, uŋmaal ŋa ji li wien, ");
INSERT INTO gngNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Iŋmaabii li cecere kí lu, tibont tà ŋmɔbe mituɔm paaki bó li jènge. ");
INSERT INTO gngNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","U ya yo nɛ bi li lɛ Unil ya Bijɛ te titɛwɔlgbɔnt ni, ki we ní, ki ŋmɔbe ufaa nin ukpiɛke ki gbien'. ");
INSERT INTO gngNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","U ya yo nɛ u li sɔn Uwien ya tondb bɛ ń jo lɛnpuoli nin nintuɔli nin ugɛn nin ujie bó, kí cin utingbaan uba kí tì baa utɔ, kí taan Uwien gɛ̀nde' binib bà nnɔ kɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","«Bukɛnkɛnbu ya tetem yé mikpɛnjɛnm nɛ niʼbo. Ni lá laa' bù tɔh isigben, ki bundeh la, ni bɛn ki ye nì nɛke uñalɛnd nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Nnɔ nɛ, ni lá laa' tibont tuu teh la, ní li bɛn kí ye Unil ya Bijɛ nɛkn' niʼnañuɔn saan ŋɔ. ");
INSERT INTO gngNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","N tɔkeh nɛ imɔ̀n nɛ, tibont nnɔ kɛ li tien kí lɛ fɛnfɛnnɔ ya nib biɛ ŋa laan kpo' ki gben'. ");
INSERT INTO gngNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Kutaaku nin kitink li gben. Ama nʼgbɛr tun ŋa ŋmɔbe tù ń gben.» ");
INSERT INTO gngNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","«Ama uba ŋa bɛn tibont nnɔ li tien lidaali là bii uyo wà. Paaki bó, Uwien ya tondb ŋa bɛn. UʼBijɛ mɔnɔn ŋa bɛn, Uwien Baa baba nɛ bɛn. ");
INSERT INTO gngNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Li bɛn mɛn ki la gɔh, kimɛ na bɛn uyo nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Nì naan ujɛ wà joh usɛn ki tɔke' uʼtonsɔnb ki ye bɛ ń li likeh uʼden mɔnmɔnm, ki wuɔn' wà kɛ u li sɔn lituonl là, ki tɔke' uʼnañɔguurl ki ye u la gɔh, ki yaan ki bure' nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Nɛn bo, la gɔh mɛn, kimɛ na bɛn uyo wà ududaan li baa ní. U li baa ní kutajuɔku-uu, kuyɔku-uu, ukuojɛmuɔyo-oo, kutɛnŋaaku-uu, na bɛn. ");
INSERT INTO gngNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Li bɛn mɛn, ŋɔ u la lá lure kí baa kí lɛ ni dɔ ki gɔh. ");
INSERT INTO gngNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","N tɔkeh nɛ nà nɔ n tɔkeh binib kɛ nɛ, la gɔh mɛn.» ");
INSERT INTO gngNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Nì sìen' iwien ile bɛ ń jele *Sufmbɛ ya Pak ya nacenku. U ya yo nɛ bi ŋmɔnh kpɔnɔ wà ŋa ŋmɔbe ñɔke. *Bitɔtuɔrciɛnb nin *Yiko ya wɔnwɔknb nuunh bi li tien ma kí bɔle kí cuo *Yesu kí ku wɔ, ");
INSERT INTO gngNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","nɛ ki tɔkeh tɔb ki teh: «Ti la cuo wɔ mɛn kunacenku nnɔ ya yo. Ti cuo' wɔ u ya yo la, udu ya nib li kpre.» ");
INSERT INTO gngNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Tɔ, *Yesu là te Betani ya du ni, Simɔn ujend den ki jinh tijier. U jinh uyo wà nnɔ nɛ upii uba kɔn' ní ki tuke lɛfina uba uʼdaaku faa cɛɛn alabaat ya dingl ni, bi yih lɛfina nnɔ naar. Upii nnɔ kpɔbre' lidingl nnɔ ya tule, ki taa' lɛfina nnɔ kɛ ki wuwule' *Yesu ya yul bo. ");
INSERT INTO gngNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Binib bà te niʼsaan nnɔ ya biba ya benku ni ben', nɛ bi niireh tɔb ki teh: «Bɛ tien' u ñɛ̀nde' lɛfina wuɔ nɔ? ");
INSERT INTO gngNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Bi bi li fre kí kuɔre wɔ kí lɛ nɛ̀ ń gɛ̀bre iwentun kobiita ya paaku kí taa kí gbiire bijiinb-a!» Nɛ ki kɔnh nin upii nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Nɛ *Yesu ye: «Cère wɔ mɛn wɔ ń fuore. Bɛ tien' ni ŋaabeh uʼyɛnm nɔ nnɔ? U tien' nà mɔn nɛ ki de' nni-a! ");
INSERT INTO gngNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Bijiinb lì li te niʼsaan uyo kɛ nɛ. Ni yíe ní tore bɛ uyo wà la, ni li fre kí tore bɛ; ama min ŋa ń li te niʼsaan uyo kɛ. ");
INSERT INTO gngNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","U tien' u li fre kí tien nà nɛ. U taa' lɛfina nnɔ ki wule' nʼbo ki kpiɛ' ki bonde' nʼgbɛnɛnt ŋɔ bɛ ń sube nni nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","N tɔkeh nɛ imɔ̀n nɛ, bi li kpaande tigbɛmɔnmɔnt tuu uŋɛndun ni nà saan kɛ nnɔ, bi li len u tien' nà nɔ bó, ŋɔ binib ń li tiɛn uʼbó.» ");
INSERT INTO gngNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","*Yesu ya panpaankaab piik nin bile ya uba, bi yih wà Sudas Iskariyɔt nnɔ jon' ki tì laa' bitɔtuɔrciɛnb ki ye u li taa *Yesu kí ŋukn bɛ. ");
INSERT INTO gngNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Bi cii' nnɔ ma nnɔ biʼyɛnm sɔnge' cɛɛn, nɛ bi pùon' ki ye bi li de wɔ ilike. Nɛ u bure' ki tì nuunh u li ñɛ isɛn yà kí taa *Yesu kí ŋukn bɛ. ");
INSERT INTO gngNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Kpɔnɔ wà ŋa ŋmɔbe ñɔke ya nacenku ya cincindaali, lidaali là bi kòreh *Sufmbɛ ya Pak ya pefanfaan nnɔ nɛ *Yesu ya panpaankaab niire' wɔ ki ye: «A yíe tí tien ŋɛ kunacenku nnɔ ya jier lɛ saan-i?» ");
INSERT INTO gngNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Nɛ u tɔke' uʼpanpaankaab ni bile ki ye: «Ní jo udu bó. Ni tì kɔn' uʼni la, ni li lɛ ujɛ uba u tuke liñuncuɔl ki cendeh nɛ. Ní paan uʼbo, ");
INSERT INTO gngNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","kí tì kɔ u li kɔ iden yà ni nnɔ ni kí tɔke udendaan kí ye: ‹TiʼCɛnbaa ye wɔn nin uʼpanpaankaab li ji kunacenku nnɔ ya jier ku lɛ duku ni?› ");
INSERT INTO gngNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","U li wuɔn nɛ lidutɔtuɔl ya paaki ya duciɛnku kuba bi bonde' kù ŋɔ, tibont kɛ te kuʼni. Ní tien tɛ kunacenku nnɔ ya jier kun ni.» ");
INSERT INTO gngNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Bi bure' ki tì baa' udu nnɔ ni, nɛ ki laa' *Yesu tɔke' bɛ ki ye bi li lɛ nà kɛ nnɔ, nɛ ki tien' kunacenku nnɔ ya jier. ");
INSERT INTO gngNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Nì juɔre' nɛ *Yesu nin uʼpanpaankaab piik nin bile nnɔ baa' ki kɔn' kuduku nnɔ ni. ");
INSERT INTO gngNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Bi kɛ ki jinh uyo wà nnɔ nɛ u tɔke' bɛ ki ye: «N tɔkeh nɛ imɔ̀n nɛ, ninbi bà te ki jinh nʼsaan nɔ ni ya uba nɛ li kuɔre nni.» ");
INSERT INTO gngNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Biʼyɛnm saa' ki gbien', nɛ bi niireh wɔ jɛjɛ ki teh: «N teh min ŋa ñí-a?» ");
INSERT INTO gngNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Nɛ u ye: «Ninbi piik nin bile biɛ ni ya uba nɛ li kuɔre nni. Min nin udaan nɛ taan' ki paan' lisɛnl ni nɔ. ");
INSERT INTO gngNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Unil ya Bijɛ li kpo tɛn nì kɛle' uʼbo *Uwien ya gbɔnku ni ki ye ma bo nnɔ nɛ. Ama unil wà li kuɔre wɔ nnɔ nì bre udaan bo. Ba bi maa' wɔ mɔnɔn la, nì bi li tu uʼbo.» ");
INSERT INTO gngNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Bi te ki jinh tijier ma nnɔ, nɛ *Yesu yuure' kpɔnɔ, ki faare' Uwien, ki kɔkuɔ', ki taa' ki de' bɛ, ki ye: «Teke mɛn. Nà sɔ yé nʼgbɛnɛnt.» ");
INSERT INTO gngNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Nɛ ki taa' midaam mɔ, ki faare' Uwien, ki taa' ki de' bɛ, biʼkɛ ñun'. ");
INSERT INTO gngNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Nɛ u tɔke' bɛ ki ye: «Nà sɔ yé nʼsɛ̀m. Mɛn nɛ wɔngeh ki teh Uwien cuo' nin binib kujɔtieku. Mì li puube binib bà yɛbe ya kpɛle bo.» ");
INSERT INTO gngNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nɛ ki ye: «N tɔkeh nɛ imɔ̀n nɛ, ma ji li ñu sibii ya daam haali kí tì baa lidaali là n li liɛbe kí ñu mɛ̀ midɛfɛ̀nm Uwien ya bɛl ni.» ");
INSERT INTO gngNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Bi gɛn' Uwien ya yuon ki gben' nɛ ki ñɛn' ki don' Olifi ya siin ya juɔl bo. ");
INSERT INTO gngNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Nɛn saan nɛ *Yesu tɔke' bɛ ki ye: «Niʼkɛ li sɛn kí dàan nni, kimɛ nì kɛle' *Uwien ya gbɔnku ni ki ye: ‹N li ku upekpaal nɛ ipe kɛ ń yɛre.› ");
INSERT INTO gngNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ama uyo wà n li mɛkre bitɛnkpiib ni nnɔ, n li liere nɛ kí jo Galile.» ");
INSERT INTO gngNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Nɛ Piɛr tɔke' wɔ ki ye: «Biʼkɛ li sɛn kí dàan ŋɛ mɔnɔn la, min ŋa ń sɛn.» ");
INSERT INTO gngNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Nɛ *Yesu ye: «N tɔkeh ŋɛ imɔ̀n nɛ, kuñɔnku kuu a li niɛ bolm mita kí ye ŋa bɛn nni nɛ kí yaan ukuojɛ ń muɔ kí lere.» ");
INSERT INTO gngNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Nɛ Piɛr ñiikeh ki lienh ki teh: «Haali bi li ku min nin sin kɛ mɔnɔn la, ma ń niɛ kí ye ma bɛn ŋɛ.» Nɛ bitɔb bà sìen nnɔ kɛ len' nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Tɔ, *Yesu nin uʼpanpaankaab tì baa' niba saan, bi yih nɛ̀ Gɛtsemani. Nɛ u tɔke' bɛ ki ye: «Juore mɛn niɛ saan, ń jo kí tì kàare.» ");
INSERT INTO gngNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Nɛ ki taa' Piɛr nin Saak nin San ki bure'. Bujɛwaanbu cin' ki kɔh wɔ nɛ uʼyɛnm saah. ");
INSERT INTO gngNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Nɛ u tɔke' bɛ ki ye: «Nʼyɛnm saa' ki tì kɛnde' tɛn mikuum nɛ benh nin nni. Niʼmɔ ń juore niɛ saan, ki la gɔh.» ");
INSERT INTO gngNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","U jɛnde' ki jon' inun bó waamu, nɛ ki pùon' ki kàareh ki teh nì li tuo la, Uwien la cère' ijɛnd yiɛ ya yo ń baa ní, ");
INSERT INTO gngNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","ki lienh ki teh: «O, nʼBaa, a li fre kí tien nibonn kɛ. Cère ijɛnd yiɛ ń jɛnde nni. Ama la cère nɛ̀ ń li yé min yíe nà, cère' nɛ̀ ń li yé sin yíe nà.» ");
INSERT INTO gngNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","U liɛbe' ní uʼpanpaankaab bita nnɔ saan, ki laa' bi dɔ ki gɔh nɛ, nɛ u tɔke' Piɛr ki ye: «Simɔn, a gɔh nɛ-ɛɛ? Ŋa ń fre kí la gùɔn kukurku kuba mɔnɔn-ii? ");
INSERT INTO gngNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","La gɔh mɛn, kí li kàareh ŋɔ ki la lu biikm ni. Niʼyɛnm yíe, ama mituɔm nɛ pɔre' nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Nɛ ki tí jɛnde' waamu, ki kàare' nin i ya ñɔbonbaab. ");
INSERT INTO gngNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","U tí liɛbe' ní uʼpanpaankaab bita nnɔ saan, ki laa' bi tí gɔh nɛ, kimɛ migùɔnm nɛ ñɔ̀nde' bɛ, ba bɛn bi li jiin kí ye bà. ");
INSERT INTO gngNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","U tí jon' ki kàare' ki liɛbe' ní nta bo, ki tɔke' bɛ ki ye: «Ni biɛ ki fuoreh nɛ ki dɔ ki gɔh-a! Nì dɛ̀kre'-a! Uyo baa'-a! Bi li taa Unil ya Bijɛ kí ŋukn bibiɛrdɛnb. ");
INSERT INTO gngNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Fii mɛn tí jo. Liike mɛn, wà kuɔre' nni nnɔ nɛkn' ní ŋɔ.» ");
INSERT INTO gngNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","U laan biɛ ki lienh nɛ Sudas uʼpanpaankaab piik nin bile nnɔ ya uba nin linigol pɔk ki puɔ' uʼbo ki tuke mujusiemu nin ilɛnbɛn. Bitɔtuɔrciɛnb nin *Yiko ya wɔnwɔknb nin *Sufmbɛ ya ciɛnb nɛ sɔn' bɛ ní. ");
INSERT INTO gngNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Sudas wà kuɔre' *Yesu nnɔ tɔke' linigol nnɔ ki ye: «Ni lá laa' n jon' ki tì lɔkn' wà la, wɔn nínɔ. Ní cuo wɔ, kí tùɔre kí li ŋuuke wɔ ki joh.» ");
INSERT INTO gngNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Tɔ, Sudas tì baa' nɛ ki pɔk ki nɛkn' *Yesu nɛ ki ye: «Cɛnbaa,» nɛ ki lɔkn' wɔ. ");
INSERT INTO gngNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Nɛ bi cuo' Yesu. ");
INSERT INTO gngNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Bà te niʼsaan nnɔ ya uba nɛ̀re' kijusiek ki gɛ' ki paare' bitɔtuɔrciɛnb ya ciɛn ya tonsɔnl uba ya tubl. ");
INSERT INTO gngNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Nɛ *Yesu tɔke' bà baa' bɛ ń lá cuo wɔ nnɔ ki ye: «Ni tuke mujusiemu nin ilɛnbɛn ní lá cuo nni tɛn n yé udukond nɛ-a! ");
INSERT INTO gngNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Idaan kɛ n là te niʼsaan Uwien ya duku ya luo bo nɛ ki wɔknh binib, nɛ na cuo' nni u ya yo. Tɔ, ni cuo' nni fɛnfɛnnɔ, ŋɔ nà kɛle' *Uwien ya gbɔnku ni nnɔ nɛ̀ ń tien nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Nɛn saan nɛ uʼpanpaankaab kɛ sɛn' ki dàan' wɔ. ");
INSERT INTO gngNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Unacenfaan uba mɔ là pɛ uʼbo ki fifike' bukpɛlbu. Bi ye bɛ ń cuo unacenfaan nnɔ ki tì dɛ̀kre nin uʼkpɛlbu, ");
INSERT INTO gngNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","nɛ u dàan' bù ki sɛn' liñil ki bure'. ");
INSERT INTO gngNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Bi taa' *Yesu ki jon' bitɔtuɔrciɛnb ya ciɛn den. Bitɔtuɔrciɛnb kɛ nin *Sufmbɛ ya ciɛnb nin *Yiko ya wɔnwɔknb mɔ taan' niʼsaan. ");
INSERT INTO gngNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Piɛr pɛ *Yesu bo, ki te fɔnfɔkm ki tì baa' bitɔtuɔrciɛnb ya ciɛn den, ki kɔn' ki kɛ̀le' biguguurb saan ki lokreh umu. ");
INSERT INTO gngNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Bitɔtuɔrciɛnb nin tibuur ya cɛkl yaab kɛ nuunh bi li dule nà bo kí biin *Yesu ŋɔ kí ku wɔ. Bi tien' ma kɛ ba laa' uʼbiil. ");
INSERT INTO gngNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Binib ligol nɛn' uʼbo kutonnɛnku kɛ ya bol ama biʼgbɛr nnɔ ŋa cende'. ");
INSERT INTO gngNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Biʼni biba fii' ki sere' ki nɛn' uʼbo ki ye: ");
INSERT INTO gngNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","«Ti cii' u len' ki ye u li bere Uwien ya duku kùa binib mɛn' kù nnɔ, kí mɛ kutɔku iwien ita, nib ŋa ń mɛ kun.» ");
INSERT INTO gngNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","U ya sɛn ni mɔnɔn biʼgbɛr ŋa cende'. ");
INSERT INTO gngNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Bitɔtuɔrciɛnb ya ciɛn fii' ki sere' binib nnɔ kɛ ya siik ni, nɛ ki niire' *Yesu ki ye: «Ŋa ń len kí jiin-ii? Ŋa ŋmɔbe tuba á len kí jiin binib bà biindeh ŋɛ nɔ-ɔɔ?» ");
INSERT INTO gngNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Nɛ *Yesu ŋmin ka gɛre'. Bitɔtuɔrciɛnb ya ciɛn tí niire' wɔ ki ye: «A yé Uwien ya Nigɛndkɛ Kristo nɛ-ɛɛ? A yé ti pɛ̀keh wà nnɔ ya Bijɛ nɛ-ɛɛ?» ");
INSERT INTO gngNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Nɛ *Yesu ye: «N yé wɔn nɛ. Ni li lɛ Unil ya Bijɛ kɛ Uwien, mituɔm kɛ ya daan ya jie bó, ki li lɛ u te titɛwɔlgbɔnt ni paaki bó, ki we ní.» ");
INSERT INTO gngNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","U len' nnɔ ma nnɔ, nɛ bitɔtuɔrciɛnb ya ciɛn kɛre' wɔn bugbɛn ya liɛrl, nɛ ki ye: «Ta ji nuunh mɔ̀nkunl. ");
INSERT INTO gngNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ni cii' u suke' Uwien ma bo. Ni maaleh mila?» Nɛ biʼkɛ ye u bii' ki kpɛ mikuum. ");
INSERT INTO gngNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Biʼni biba cin' ki cɛreh uʼbo tiñinsɛnt ki taa' kukpɛlciɛku ki pibn' uʼnun bó, ki kureh wɔ, ki tɔkeh wɔ ki teh: «Bukre' wà kure' ŋɛ.» Nɛ biguguurb nnɔ taa' wɔ nin itɛnpɛ. ");
INSERT INTO gngNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Piɛr te uluo bo uyo wà nnɔ, nɛ bitɔtuɔrciɛnb ya ciɛn ya piitonsɔnl uba baa' ");
INSERT INTO gngNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ki laa' Piɛr lokreh umu, nɛ u tùɔre' ki liike' wɔ ki ye: «Aʼmɔ là te nin Nasarɛt ya *Yesu wuɔ nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Nɛ Piɛr niɛ' ki ye: «Ma bɛn, ka cii' aʼlenm nnɔ ya tingi.» Nɛ ki siere' ki kɔn' kunakuuku ni. U ya yo nɛ ukuojɛ muɔ'. ");
INSERT INTO gngNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Upiitonsɔnl nnɔ tí laa' wɔ nɛ ki tí tɔke' binib bà te niʼsaan nnɔ ki ye: «Ujɛ wuɔ mɔ yé *Yesu yaab ya uba nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Nɛ Piɛr tí niɛ' nle bo. Nì tí pukn' waamu nɛ binib bà te uʼsaan nnɔ mɔ tɔke' wɔ ki ye: «Nì yé imɔ̀n nɛ, a yé *Yesu yaab ya uba nɛ, kimɛ aʼmɔ yé Galile ya nil nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Nɛ Piɛr cin' ki niɛh ki poleh ki teh: «Ma bɛn ni lienh unil wà ya gbɛr nɔ, n nɛn' la, Uwien la dàan nni» ");
INSERT INTO gngNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Nɛ ukuojɛ pɔk ki muɔ' i ya tàan bo ki lere'. Nɛn saan nɛ Piɛr tiɛre' *Yesu bi tɔke' wɔ ma ki ye: «A li niɛ bolm mita kí ye ŋa bɛn nni nɛ kí yaan ukuojɛ ń muɔ kí lere» nnɔ, nɛ ki muɔ' cɛɛn. ");
INSERT INTO gngNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Nì faa' kutɛnŋɛsɔnsɔnku, nɛ bitɔtuɔrciɛnb nin *Sufmbɛ ya ciɛnb nin *Yiko ya wɔnwɔknb nin tibuur ya cɛkl yaab kɛ kɛ̀le' ki bonde' bi li tien ma bo. Bi lòle' *Yesu, nɛ ki taa' wɔ ki tì ŋukn' Pilat. ");
INSERT INTO gngNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilat niire' wɔ ki ye: «Sin, a yé *Sufmbɛ ya bɛr nɛ-ɛɛ?» Nɛ u jiin' wɔ ki ye: «Sin nɛ ye nnɔ.» ");
INSERT INTO gngNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Tɔ, Bitɔtuɔrciɛnb nnɔ biin' wɔ isɛn yà yɛbe ni. ");
INSERT INTO gngNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Nɛ Pilat tí niire' wɔ ki ye: «Ŋa ń len kí jiin-ii? Cenge bi biindeh ŋɛ mibiinm mà kɛ ya bol-a!» ");
INSERT INTO gngNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ama *Yesu ŋa ji jiin' ñɔbonl, nɛ nì cuo' Pilat miyɔkm. ");
INSERT INTO gngNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","*Sufmbɛ ya Pak ya nacenku kɛ nacenku ya yo la, Pilat li ñɛn lipɛkl ya nil wà linigol yíe wɔ nɛ kí wiɛ. ");
INSERT INTO gngNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","U ya yo ki laa' ujɛ uba te lipɛkl ni bi yih wɔ Barabas. Wɔn nin binib bà là pɛ uʼbo nnɔ là kpìin' kukpiinku nɛ ki ku' unil uba. Nɛn bo nɛ bi là pɛkn' bɛ. ");
INSERT INTO gngNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Linigol nnɔ baa' Pilat saan ki tɔke' wɔ ki ye wɔ ń tien u tì ń teh ma kunacenku nnɔ ya yo. ");
INSERT INTO gngNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Nɛ u niire' bɛ ki ye: «Ni yíe ń wiɛ nɛ *Sufmbɛ ya bɛr nɛ-ɛɛ?» ");
INSERT INTO gngNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","U niire' nnɔ, kimɛ u bɛn ki ye bitɔtuɔrciɛnb ŋmɔbe kinɛnk nɛ *Yesu bo, nɛn nɛ cère' bi taa' wɔ ki ŋukn' wɔ. ");
INSERT INTO gngNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ama bitɔtuɔrciɛnb bɛn sureh linigol nnɔ nɛ ki teh bɛ ń tɔke Pilat wɔ ń wiɛ bɛ Barabas. ");
INSERT INTO gngNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Nɛ Pilat tí niire' bɛ ki ye: «Nnɔ la, ujɛ wà ni yih wɔ *Sufmbɛ ya bɛr nnɔ n li tien wɔ mila?» ");
INSERT INTO gngNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Nɛ bi wuure' ki ye: «Kpɛ wɔ udɔpɔnpɔn bo!» ");
INSERT INTO gngNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Nɛ Pilat tí niire' bɛ ki ye: «U tɛ́n ki bii' li lɛ biil nɛ?» Nɛ bi tùɔreh ki wuureh ki gbiekeh ki teh: «Kpɛ wɔ udɔpɔnpɔn bo!» ");
INSERT INTO gngNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilat yíe wɔ ń sɔnge biʼyɛnm nɛ ki wiɛ' Barabas. U cère' uʼsojambɛ ñi' *Yesu inalɛbe, nɛ u taa' wɔ ki de' bɛ bɛ ń tì kpɛ wɔ udɔpɔnpɔn bo. ");
INSERT INTO gngNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Sojambɛ nnɔ taa' wɔ ki kɔn' Pilat den uluo bo, nɛ ki yin' biʼcɛkl ya sojambɛ kɛ ki taan', ");
INSERT INTO gngNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","ki taa' kuliɛrmɔ́nmɔ́nku kuba ki goln' wɔ, nɛ ki taa' ikonkon ki lònlòn' uyukpɛkpiɛ ki kpɛle' uʼyul, ");
INSERT INTO gngNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","nɛ ki teh tɛn bi pɛ̀keh wɔ nɛ ki teh: «*Sufmbɛ ya bɛrɔ, ti fuondeh ŋɛ-a!» ");
INSERT INTO gngNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ki taah lilɛnbɛnl ki kpaakeh uʼyul bo, ki cɛreh uʼbo tiñinsɛnt nɛ ki gbaandeh uʼnun bó ki gòndeh. ");
INSERT INTO gngNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Bi lɛ̀' wɔ ki tì gben', nɛ ki gore' kuliɛrmɔ́nmɔ́nku nnɔ, ki taa' uʼwɛngolkaar ki jiin' ki goln' wɔ, nɛ ki taa' wɔ ki ñɛn' ki bure' bɛ ń tì kpɛ wɔ udɔpɔnpɔn bo. ");
INSERT INTO gngNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Bi joh ma nnɔ nɛ ki tì cende' ujɛ uba bi yih wɔ Simɔn, u yé Sirɛnn ya du ya nil nɛ, ki ñɛn' ikpàan bó ní. U yé Alɛksand nin Lufus ya baa nɛ. Bi cuo' ujɛ bugbɛn ki wɔbn' wɔ, wɔ ń tuke *Yesu ya dɔpɔnpɔn. ");
INSERT INTO gngNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Bi taa' *Yesu ki tì baa' niba saan, bi yih nɛ̀ Golgota, niʼtingi si: «Kuyukpɔbku ya Bùol.» ");
INSERT INTO gngNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Nɛ ki taa' midaam mà cuuke' uñɔke wà bi yih wù miir nnɔ ki de' wɔ ki ye wɔ ń ñu. Nɛ u yìe' ka ñun'. ");
INSERT INTO gngNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Sojambɛ nnɔ kpɛ' wɔ udɔpɔnpɔn bo. Nɛ ki taa' uʼwɛngolkaar bɛ ń tì gbiire nɛ ki fùɔre' imúɔn ki liike' wà kɛ li ji nà bó. ");
INSERT INTO gngNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Nì là te kutɛnŋaaku tikur tiwɛ nɛ, nɛ bi kpɛ' wɔ udɔpɔnpɔn bo. ");
INSERT INTO gngNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Bi là kɛle' nà cère' bi kpɛ' wɔ nnɔ ki tɛbn' uʼdɔpɔnpɔn bo uʼyul bó. Bi là kɛle' ki ye: «*Sufmbɛ ya bɛr.» ");
INSERT INTO gngNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Bi kpɛ' idukond ile mɔ idɔpɔnpɔn bo Yesu saan. Bi kpɛ' uba uʼnɔjie bó, ki kpɛ' utɔ uʼnɔgɛn bó.  ");
INSERT INTO gngNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Nɛ nà kɛle' *Uwien ya gbɔnku ni nnɔ tien'. Nì kɛle' ki ye: «Bi kaan' wɔ ki kpɔbn' idukond bó nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Binib bà gɛ̀breh niʼsaan nnɔ sukreh wɔ ki gònbeh iyul ki tɔkeh wɔ ki teh: «Sin wà là ye a li bere Uwien ya duku kí liɛbe kí mɛ kù iwien ita nnɔ ");
INSERT INTO gngNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","ŋmiɛn aʼba, kí jiire ní udɔpɔnpɔn wuu bo-a!» ");
INSERT INTO gngNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Bitɔtuɔrciɛnb nin *Yiko ya wɔnwɔknb mɔ lɛh wɔ ki teh: «U ŋmiɛn' binitɔb nɛ, ka ń fre kí ŋmiɛn uʼba-a! ");
INSERT INTO gngNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Uwien ya Nigɛndkɛ Kristo, Israyɛl yaab ya bɛrɔ, jiire ní udɔpɔnpɔn wuu bo fɛnfɛnnɔ, tí lɛ ŋɔ kí teke ŋɛ kí ji-a!» Nɛ bi kpɛ' idukond yà uʼsaan idɔpɔnpɔn bo nnɔ mɔ sukreh wɔ nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Tɔ, kuwensiiku ya yo nɛ nì ci' ki bìike' utingbɛn kɛ bo ki tì baa' kutaajuɔku tikur tuta ya yo. ");
INSERT INTO gngNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Tikur tuta ya yo nɛ *Yesu wuure' ufaa bo ki ye: «Elowi, Elowi, lama sabaktani?» Niʼtingi si: «NʼWien, nʼWien, bɛ tien' a wiɛ' nni?» ");
INSERT INTO gngNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Binib bà se niʼsaan nnɔ ya biba ŋa cii' u wuure' ki ye ba mɔnmɔnm nɛ ki ye: «Li cengeh mɛn u yih Eli nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Biʼni uba sɛn' ki jon' ki tì yuure' ticitɔnt ki lá sèkn' midɛŋmiŋmiikm miba ni, ki taa' ki tuun' lilɛnbɛnl bo, ki tɛnde' ki kòle' uʼñɔbu ki ye wɔ ń muɔre, nɛ ki ye: «Dàan mɛn, tí liike Eli li baa kí lá jiin wɔ bii wa ń baa.» ");
INSERT INTO gngNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Nɛn saan nɛ *Yesu wuure' ufaa bo, nɛ ki kpo'. ");
INSERT INTO gngNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","U ya yo nɛ kukpɛlcɛkpɛkpiɛku kùa bore' Uwien ya duku ni bolm mile nnɔ kɛre' kuʼsiik ni paaki ki tì ci' tingi. ");
INSERT INTO gngNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Sojambɛ kobk ya ciɛn wà se *Yesu ya nun bó nnɔ laa' u kpo' ma bo nɛ ki ye: «Imɔ̀n, ujɛ wuɔ mɔnbe ki yé Uwien ya Bijɛ nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Bipiib biba mɔ là te niʼsaan, ki se fɔnfɔkm ki likeh. Biʼni uba si Mari Madelɛnn, utɔ si Saakbuk nin Yosɛ ya naa Mari, utɔ mɔ si Salome. ");
INSERT INTO gngNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","*Yesu là te Galile ma nnɔ, nɛ bipiib nnɔ là pɛ uʼbo, ki sɔnh itùon ki toreh wɔ. Bipiib bà là pɛ uʼbo ki tì baa' Yerusalɛm nnɔ mɔ là te niʼsaan ki yɛbe. ");
INSERT INTO gngNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Nì juɔre' ma nnɔ nɛ ujɛ uba baa' ní bi yih wɔ Yosɛf u yé Arimate ya nil, ki yé tibuur ya cɛkl yaab ya uba binib boh wɔ cɛɛn. Uʼmɔ là gu Uwien ya bɛl li baa ní uyo wà nnɔ nɛ. Nì là yé kutaaku kùa li faa *Saba ya daali, uyo wà bi bondeh *Saba ya daali nnɔ nɛ. Yosɛf jon' Pilat saan nin lifɛ̀l ki tì tɔke' wɔ ki ye u tuo' la, wɔ ń cɛ̀be wɔ *Yesu ya gbɛnɛnt. ");
INSERT INTO gngNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilat cii' bi ye *Yesu kpo' ŋɔ ma nnɔ nɛ nì cuo' wɔ miyɔkm. Nɛn saan nɛ u yin' sojambɛ kobk ya ciɛn ki niire' wɔ ki ye: «*Yesu kpo' ma nì wuɔke'-aa?» ");
INSERT INTO gngNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Nɛ u tɔke' wɔ u kpo' uyo wà. Pilat cii' u kpo' uyo wà ma nnɔ, nɛ ki de' Yosɛf usɛn wɔ ń tì taa uʼgbɛnɛnt. ");
INSERT INTO gngNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Nɛ Yosɛf jon' ki tì dɛ' kukpɛlciɛku kuba, nɛ ki jiin' *Yesu ya gbɛnɛnt udɔpɔnpɔn bo, ki taa' kù ki tɛntɛn' tù, ki taa' ki tì ble' ufɛle uba ni. Bi là cube' ufɛle nnɔ kujɔtɛnku kuba ya kɛle ni nɛ, nɛ ki binde' kutɛngbengbenku kuba, ki bìin' bufɛnañɔbu. ");
INSERT INTO gngNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Nɛ Mari Madelɛnn nin Yosɛ ya naa Mari laa' bi ble' *Yesu nà saan. ");
INSERT INTO gngNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","*Saba ya daali gɛ̀bre' ma nnɔ, nɛ Mari Madelɛnn nin Saak ya naa Mari nin Salome jon' ki tì dɛ' mikpɔm mà ya nu ŋmɛ bɛ ń tì faan *Yesu ya gbɛnɛnt. ");
INSERT INTO gngNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Saba ya daali gɛ̀bre', kutaaku kùa li faa nnɔ, nɛ bipiib nnɔ wɔre' ki fii' nì bìike ki bure' likul nnɔ bó ki tì baa' ki laa' uwien te ki puɔreh. ");
INSERT INTO gngNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Bi joh ma nnɔ nɛ ki niireh tɔb ki teh: «Ŋmɛ li tì biire tɛ kutɛnku nnɔ?» ");
INSERT INTO gngNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Bi tì tuo niʼsaan sɔ, ki liike' ki laa' kutɛnku nnɔ ŋa ji bi. Kù là yé kutɛncɛnciɛnku nɛ. ");
INSERT INTO gngNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Bi tì baa' ki kɔn' likul nnɔ ni nɛ ki laa' unacenfaan uba kɛ unɔjie bó ki guo kuliɛrpenpienku. Nɛ bujɛwaanbu cuo' bɛ cɛɛn. ");
INSERT INTO gngNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Nɛn saan nɛ unacenfaan nnɔ tɔke' bɛ ki ye: «La cère mɛn nɛ̀ ń cuo nɛ jɛwaanbu. Ni nuunh Nasarɛt ya *Yesu wà bi là kpɛ' wɔ udɔpɔnpɔn bo nnɔ nɛ. U mɛkre'-a! Wa ji te niɛ saan. Liike mɛn, bi là taa' wɔ ki ble' nà saan sɔ. ");
INSERT INTO gngNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Li joh mɛn, kí tì tɔke Piɛr nin uʼpanpaankɛtɔb kí ye u liere' bɛ ki bure' Galile bó ŋɔ. Bi li tì lɛ wɔ nɛn bó nɛ tɛn u là tɔke' bɛ ma bo.» ");
INSERT INTO gngNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Nì bɛke' bipiib nnɔ cɛɛn nɛ bi ñɛn' likul nnɔ ni ki tiinh biʼgbɛnɛnt kɛ ŋɔh. Bujɛwaanbu cuo' bɛ ma nnɔ nɛ ba tɔke' nil.  ");
INSERT INTO gngNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","*Saba ya daali gɛ̀bre', kutaaku kùa li faa nnɔ ya tɛŋaaku, *Yesu mɛkre' ma nnɔ nɛ ki kpiɛ' ki taa' uʼba ki wuɔn' Mari Madelɛnn. Wɔn nɛ yé upii wà isɛnpol ilole là ŋaake wɔ, *Yesu ŋɔre' yɛ̀ nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","U jon' *Yesu yaab saan ki laa' bi te uyɛnsaa ni, ki kɛ ki muɔh. Nɛ u tɔke' bɛ ki ye u laa' Yesu. ");
INSERT INTO gngNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Bi cii' u ye u laa' *Yesu u fuobe, nɛ ba teke' ki jin'. ");
INSERT INTO gngNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ni ya puoli bó nɛ biʼni bile là cuonh ki joh udugbaan bó. Bi joh ma nnɔ nɛ *Yesu cère' bi laa' wɔ. Wa te tɛn u là te ma uyo wà Mari Madelɛnn laa' wɔ nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Bi liɛbe' biʼtɔb saan ki tì tɔke' bɛ ki ye bi laa' Yesu, nɛ ba tí teke' ki jin'. ");
INSERT INTO gngNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","*Yesu fɔre' ki cère' uʼpanpaankaab piik nin uba laa' wɔ uyo wà bi te ki jinh tijier. U kɔn' nin bɛ ki ye bɛ tien' ba teke' binib bà laa' wɔ u mɛkre' nnɔ len' nà nnɔ ki jin-i? Nɛ ki ye biʼyul nɛ faa. ");
INSERT INTO gngNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Nɛ ki tí tɔke' bɛ ki ye: «Li joh mɛn uŋɛndun ni niʼkɛ saan kí li kpaandeh tigbɛmɔnmɔnt binib kɛ saan. ");
INSERT INTO gngNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Wà kɛ li teke kí ji kí cère bɛ ń sìi wɔ Uwien ya ñunm nɛ li ŋmɛre. Wà kɛ ŋa teke' ki jin' la, Uwien li dɛre uʼtub. ");
INSERT INTO gngNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Binib bà kɛ li teke kí ji nnɔ li tien miyɔkm ya bont. Nʼyel bo, bi li ŋɔre isɛnpol, ki li len milencɛnm, ");
INSERT INTO gngNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ki li cuo iwɛ ya ń tien bɛ niba. Bi ñun' uñɔkñɛndkɛ la, wa ń tien bɛ niba. Bi li taa biʼnuɔ kí paan biwiɛnb bo nɛ bɛ ń faake.» ");
INSERT INTO gngNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Yonbdaan *Yesu tɔke' bɛ tigbɛr ki tì gben' nɛ Uwien cère' u don' paaki bó, ki tì kɛ̀le' uʼjie bó. ");
INSERT INTO gngNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Nɛn saan nɛ uʼpanpaankaab joh niʼkɛ saan ki tɔkeh binib tigbɛmɔnmɔnt. Nɛ Yonbdaan toreh bɛ ki cèreh bi teh miyɔkm ya bont. Nɛn nɛ wɔngeh ki teh bi lienh tigbɛr tà nnɔ te nɛ.");
INSERT INTO gngNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ni bɛn ki ye binib bà yɛbe ñikn' ki kɛle' tigbɔnt ni tibont tà là tien' tiʼni nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Bi kɛle' tù tɛn binib bà là te tuʼcincinyo ki laa' tù tien' ma bo, ki yé binib bà kpaandeh Uwien ya gbɛr nnɔ là wɔkn' tɛ ma bo nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Nɛ nʼmɔ tùɔre' ki nuun' ki bɛnde' tù cin' ma bo, nɛ ki maale' ki ye nì mɔn nʼmɔ ń paan tuʼbo mɔnmɔnm kí kɛle tù tentien ma bo, kí de sin uciɛn Teofil, ");
INSERT INTO gngNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ŋɔ aʼmɔ ń bɛnde kí ye bi wɔkn' ŋɛ tigbɛr tà nnɔ mɔnbe ki te nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Uyo wà Herod là yé Sude ya bɛr nnɔ, ki laa' utɔtuɔrkɛ uba te, ki yé Abiya ya cɛkl yaab ya uba, bi yih wɔ Sakari; ki yih uʼpo Elisabɛt, u yé Arɔn ya yaabil. ");
INSERT INTO gngNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Biʼkɛ bile là yé binib bà cuube nɛ Uwien ya nun bó, ki boh Yonbdaan ya wɔb, ki teh u yíe nà kɛ mɔnmɔnm. ");
INSERT INTO gngNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ama ba là ŋmɔbe buk, kimɛ Elisabɛt là yé uŋɔl nɛ, nɛ biʼkɛ bile là pore'-a. ");
INSERT INTO gngNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Nì kpaan' Sakari ń sɔn lituonl Uwien ya nun bó, kimɛ uʼcɛkl li sɔn itùon Uwien ya nun bó uyo wà nnɔ baa'. ");
INSERT INTO gngNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Nɛ bitɔtuɔrkaab ya tentienm bo, bi fùɔre' imúɔn, nì lu' Sakari bo, nɛ bi gɛ̀nde' wɔ, wɔ ń kɔ Yonbdaan ya dubenku ni, kí tì sɛ liŋubl. ");
INSERT INTO gngNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Uyo wà u te ki siɛnh liŋubl nnɔ, Uwien ya nib ligol te saali nɛ ki kàareh. ");
INSERT INTO gngNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Nɛn saan nɛ Yonbdaan ya tond uba baa' uʼsaan, ki se bi siɛnh liŋubl liponpuol là bo nnɔ ya jie bó. ");
INSERT INTO gngNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sakari laa' wɔ ma nnɔ, nì bɛke' wɔ, nɛ bujɛwaanbu cuo' wɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Nɛ utond nnɔ tɔke' wɔ ki ye: «Sakari, la cère' nɛ̀ ń cuo ŋɛ jɛwaanbu. Uwien cii' aʼkaare bó. Aʼpo Elisabɛt li maa kibujɛbuk, nɛ á yin kɛ̀ San. ");
INSERT INTO gngNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Kì li cère aʼyɛnm ń sɔnge kí gbien, nɛ binib bà yɛbe mɔ li pokn kiʼmàam bo. ");
INSERT INTO gngNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Kì li yé unikpɛkpiɛk nɛ Yonbdaan ya nun bó. Ka ń ñu sibii ya daam, ka ń ñu dɛfɛfaam kɛ dɛfɛfaam. *Mifuoñaanm li te kiʼbo ki gbien' haali kiʼnaa ya benku ni nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Kì li cère Israyɛl yaab bà yɛbe ń liɛbe kí paan Yonbdaan Uwien bo. ");
INSERT INTO gngNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Kì li ŋmɔbe *Uwien ya Fuoñaanm nin mituɔm tɛn *Uwien ya ñɔbonsɔknl Eli nɛ. Kì li liere Yonbdaan usɛn, kí cère bibaambɛ ń liɛbe kí taan nin biʼbumu buñɔbu, kí cère binib bà ŋa tuo' Uwien ya ñɔbu bó ń li ŋmɔbe iyɛnmaale tɛn binimɔ̀nb, kí cère binib ń li yé binib bà bonde' bɛ ń teke Yonbdaan.» ");
INSERT INTO gngNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Nɛ Sakari tɔke' utond nnɔ ki ye: «Bɛ li cère ń bɛnde kí ye a len' nà nɔ, nì te? Kimɛ min pore'-a nɛ nʼpo mɔ pore'.» ");
INSERT INTO gngNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Nɛ utond nnɔ jiin' wɔ ki ye: «N yé Uwien ya tond Gabriɛl nɛ, ki te Uwien ya nun bó ki sɔnh uʼtùon. U sɔn' nni ní ń lá tɔke ŋɛ tigbɛmɔnmɔnt tuu nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Tɔ, aʼlɛnl li tɛbe, ŋa ji li freh ki lienh kí tì baa uyo wà nibonn nnɔ ń tien, kimɛ ŋa teke' ki jin' ki ye n tɔke' ŋɛ tigbɛr tà nɔ ya yo lá baa' la, tù li tien.» ");
INSERT INTO gngNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","U ya yo ki laa' linigol nnɔ gu Sakari li ñɛ ní Uwien ya duku ni uyo wà nɛ. U wuɔke' ka ñɛn' ní ma nnɔ nɛ nì bɛke' bɛ cɛɛn. ");
INSERT INTO gngNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","U lá ñɛn' ní ka ji freh ki lienh, nɛ bi bɛnde' ki ye u laa' niba nɛ tidɛknt yaam Uwien ya duku ni. Nɛ u wɔngeh bɛ migbaam, ka freh ki lienh. ");
INSERT INTO gngNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Sakari ya tùon ya wien tì gben' nɛ u liɛbe' uʼden. ");
INSERT INTO gngNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Nì tete nɛ uʼpo Elisabɛt lá punbe', ki bɔle' uʼba ki tì baa' iŋmaale iŋun, ");
INSERT INTO gngNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","nɛ ki maale' uʼyɛnm ni ki ye: «A laa'-aa! Uyo wà Yonbdaan yíe nɛ ki muɔ' nni, ki ñɛn' nni ifɛ ni binib ya nun bó.» ");
INSERT INTO gngNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabɛt ya tɛnpunbe ya ŋmaalluob ni, nɛ Uwien sɔn' uʼtond Gabriɛl Galile ya tinfɛnm ya du uba ni, bi yih wù Nasarɛt. ");
INSERT INTO gngNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","U là sɔn' wɔ ujɛfaan uba saan nɛ wa bɛn jɛ, bi yih wɔ Mari. Bi là pun' wɔ ujɛ uba nɛ u yé *Dafid ya yaabil, bi yih wɔ Yosɛf. ");
INSERT INTO gngNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Utond nnɔ baa' ki kɔn' Mari den, nɛ ki ye: «N fuondeh ŋɛ Mari. Yonbdaan tien' ŋɛ tinimɔ̀nt ki gbien', nɛ ki te nin ŋɛ.» ");
INSERT INTO gngNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mari cii' iñɔbon nnɔ ma nnɔ nɛ nì bɛke' wɔ cɛɛn, u maaleh wɔ ń bɛnde ifuonde nnɔ ya tingi si bà. ");
INSERT INTO gngNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Nɛ utond nnɔ tɔke' wɔ ki ye: «Mari, la cère nɛ̀ ń cuo ŋɛ jɛwaanbu, kimɛ Uwien tien' ŋɛ tinimɔ̀nt nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Liike-a! A li punbe, kí maa kibujɛbuk kí yin kɛ̀ Yesu. ");
INSERT INTO gngNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Kì li yé unikpɛkpiɛk nɛ, bi li yih kɛ̀ Uwien wà ŋa ŋmɔbe Nacentɔ ya Bijɛ nɛ. Yonbdaan Uwien li de wɔ uʼyaajɛ *Dafid ya bɛl. ");
INSERT INTO gngNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","U li yé ubɛr nɛ Sakɔb ya yaabii bo uyo kɛ. Nɛ uʼbɛl nnɔ ŋa ń li ŋmɔbe gbenm.» ");
INSERT INTO gngNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Nɛn saan nɛ Mari tɔke' utond nnɔ ki ye: «Nì li tien mila kí tuo, kimɛ ma bɛn jɛ-a?» ");
INSERT INTO gngNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Nɛ utond nnɔ jiin' wɔ ki ye: «*Mifuoñaanm li jiire ní aʼbo, nɛ Uwien wà ŋa ŋmɔbe Nacentɔ ya tuɔm ń lèkn aʼbo tɛn usɔnge. Nɛn nɛ cère' a li maa kibuk kà nnɔ, li yé uñaan, bi li yih kɛ̀ Uwien ya Bijɛ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Liike, aʼpuole Elisabɛt punbe' ma uʼŋmaalluob sɔ. Wɔn wà bi là yih wɔ uŋɔl nnɔ punbe' uʼpor ni nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Kimɛ Uwien ŋa gbɛle' niba.» ");
INSERT INTO gngNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Nɛn saan nɛ Mari jiin' utond nnɔ ki ye: «N yé Yonbdaan ya piitonsɔnl nɛ. Nɛ̀ ń tien tɛn a len' ma nɔ.» U ya yo nɛ utond nnɔ siere' ki dàan' wɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","I ya dɛn nɛ Mari pɔk ki bure' ijuɔn bó, Sude ya tinfɛnm ya du uba ni. ");
INSERT INTO gngNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","U tì baa' ki kɔn' Sakari den, nɛ ki fuonde' Elisabɛt. ");
INSERT INTO gngNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elisabɛt cii' ifuonde nnɔ ma nnɔ, nɛ uʼbuk nukbe' uʼbenku ni. *Mifuoñaanm jiire' ní uʼbo ki gbien', ");
INSERT INTO gngNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","nɛ u len' ufaa bo ki ye: «Uwien tien' ŋɛ uʼmɔnm ki cɛn' bipiib kɛ, ki tien' mimɔnm kibuk kà te aʼbenku ni nnɔ mɔ bo. ");
INSERT INTO gngNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nʼmɔ ya ba nɛ nʼYonbdaan ya naa baa' nʼsaan-i? ");
INSERT INTO gngNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Kimɛ uyo wà aʼfuonde lu' nʼtubl ni nnɔ, nɛ nʼbuk nukbe' nʼbenku ni nin uyɛnsɔnge. ");
INSERT INTO gngNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Sin wà teke' ki jin' ki ye Yonbdaan tɔke' ŋɛ nà nnɔ li tien nnɔ, Uwien ya mɔnm te aʼbo.» ");
INSERT INTO gngNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Nɛ Mari ye: «N ñɛngeh Yonbdaan, ");
INSERT INTO gngNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ki ŋmɔbe uyɛnsɔnge ki gbien', Uwien, nʼŊmiɛnl bo. ");
INSERT INTO gngNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","U tiɛre' min uʼtonsɔnpiijiin bó, fɛnfɛnnɔ kí taa kí li joh, binib kɛ li len kí ye Uwien ya mɔnm te nʼbo. ");
INSERT INTO gngNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Kimɛ mituɔm kɛ ya daan tien' nni tibont tà ŋmɔbe ukpiɛke, uʼyel si: Uñaan nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","U li tuu ki teh binib bà boh wɔ tinimɔ̀nt nɛ, haali uyo wà ŋa ŋmɔbe gbenm. ");
INSERT INTO gngNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","U wuɔn' binib uʼtuɔm, ki ŋɔre' binib bà maaleh ki teh bi yé binikpɛkpiɛkb nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","U ñɛn' bibɛrciɛnb biʼbɛl ni, ki kpiɛke' bijiinb. ");
INSERT INTO gngNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","U de' binib bà mikònm ŋmɔbe bɛ tibont na ŋmɔbe fuul, ki ŋɔre' bifàadɛnb bi bure' inɔpien. ");
INSERT INTO gngNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","U tiɛre' uʼnimɔ̀nt bó, ki tore' uʼtonsɔnb Israyɛl yaab, ");
INSERT INTO gngNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","tɛn u là ye u li tuu ki teh ma ki dienh tiʼyaajɛ *Abraham nin uʼyaabii nnɔ.» ");
INSERT INTO gngNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mari tien' Elisabɛt saan nì baa' tɛn iŋmaale ita, nɛ ki liɛbe' ki kun'. ");
INSERT INTO gngNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabɛt ya mamaayo baa', nɛ u maa' kibujɛbuk. ");
INSERT INTO gngNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Uʼden yaab nin uʼkɔnkuɔnlieb cii' Yonbdaan muɔ' wɔ micɛcɛkm ki gbien', nɛ wɔn nin bɛn kɛ pokn'. ");
INSERT INTO gngNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Kibuk nnɔ ya wienniin daali, nɛ bi baa' bɛ ń jiɛ kiʼpunl, ki yíe bɛ ń yin kɛ̀ Sakari tɛn kiʼbaa. ");
INSERT INTO gngNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Nɛ kiʼnaa yìe', ki ye bi li yin kɛ San nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Nɛ bi tɔke' wɔ ki ye ba yih aʼden ya nil uba li ya yel-a. ");
INSERT INTO gngNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Nɛ bi niire' kiʼbaa migbaam ki ye u yíe wɔ ń yin uʼbuk li lɛ yel ba? ");
INSERT INTO gngNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Nɛ u wuɔn' bɛ ki ye bɛ ń de wɔ kudɔbipɛnpɛnku kuba wɔ ń kɛle kuʼbo. Bi de' wɔ, nɛ u kɛle' ki ye: «kiʼyel si San» nɛ. Nɛ nì cuo' biʼkɛ miyɔkm. ");
INSERT INTO gngNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","I ya tàan bo nɛ Sakari ya lɛnl tɛbre', nɛ u cin' ki lienh, ki pɛ̀keh Uwien. ");
INSERT INTO gngNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Nɛn saan nɛ bujɛwaanbu cuo' binib bà kɛ kɔ ka fɔke nin niʼsaan nnɔ. Sude ya tinfɛnm ya du yà kɛ te ijuɔn bó nnɔ ya nib lienh tigbɛr nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Tù de' binib bà kɛ cii' tù nnɔ iyɛnmaale. Nɛ bi maaleh biʼyɛnm ni ki teh: «Kibuk kiɛ lá li yé bɛ ya nitunbu sɔ?» Kimɛ Yonbdaan ya tuɔm te kiʼbo. ");
INSERT INTO gngNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Nɛn saan nɛ *Mifuoñaanm jiire' ní kibuk nnɔ ya baa Sakari bo ki tì gben', ki cère' u sɔkndeh Uwien ya ñɔbon ki teh: ");
INSERT INTO gngNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«Tí pɛ̀ke mɛn Yonbdaan, tinbi Israyɛl yaab ya Wien, kimɛ u baa' uʼnib saan, ki teke' bɛ ki wiɛ', ");
INSERT INTO gngNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","ki cère' wà li ŋmiɛn tɛ, ñɛn' uʼtonsɔnl *Dafid den, ki ŋmɔbe mituɔm. ");
INSERT INTO gngNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","U là cère' uʼñɔbonsɔknb len' nɛn nɛ uyo bo. ");
INSERT INTO gngNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Bi là len' ki ye: ‹Uwien ye u li fie tɛ bà se tiʼbo saan, kí ñɛn tɛ bà kɛ nɛn tɛ ya nuɔ ni. ");
INSERT INTO gngNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","U là muɔ' tiʼyaajɛb micɛcɛkm, ki tiɛre' uʼjɔtieku bó.› ");
INSERT INTO gngNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","U là pùon' nà sɔ tiʼyaajɛ Abraham: ");
INSERT INTO gngNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","‹u là ye u li ñɛn tɛ tiʼnɛnnɛndb ya nuɔ ni, ŋɔ tí li pukeh wɔ ki la fɛnge, ");
INSERT INTO gngNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","kí li pɛ uʼbo mɔnmɔnm, kí li cuube uʼnun bó, tiʼfuobm kɛ ni.› ");
INSERT INTO gngNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","‹Sin, nʼbukɛ, bi li yin ŋɛ Uwien wà ŋa ŋmɔbe Nacentɔ ya ñɔbonsɔknl. Kimɛ a li liere Yonbdaan, kí tùɔre uʼsɛn kí de wɔ, ");
INSERT INTO gngNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","kí cère uʼnib ń bɛnde kí ye u li fère bɛ biʼbiɛre, bɛ ń ŋmɛre.› ");
INSERT INTO gngNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Kimɛ tiʼWien ŋmɔbe tinimɔ̀nt ki gbien'. Uʼnimɔ̀nt nnɔ bo nɛ u li cère kuwenwenku ń ñɛ paaki bó kí wende tiʼbo tɛn uwien puɔreh ma bo. ");
INSERT INTO gngNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Kuwenwenku nnɔ li wende binib bà te licinñunl ni, mikuum ya jinjinku yiin biʼbo nnɔ. Kù li wuɔn tɛ usɛn wà li de tɛ uyɛnduɔn.» ");
INSERT INTO gngNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Kibuk nnɔ kpienh, nɛ ki lɛnh miyɛnm. Kì te kupenpelku ni nɛ ki tì baa' uyo wà kì ñɛn' kiʼtuonl upaan bo Israyɛl yaab ya nun bó. ");
INSERT INTO gngNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Tɔ, i ya dɛn nɛ Erom ya bɛrciɛn Ogust caan' ki ye bɛ ń kàan binib bà kɛ te u ya tinfɛnm bo nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Bi là kaan' kukɛ̀nkpiɛku buʼgbɛn ma nnɔ ki laa' Kirinus nɛ yé Siri ya tinfɛnm ya gobina. ");
INSERT INTO gngNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Wà kɛ là li jo kí tì kàan kukɛ̀nku nnɔ uʼyaajɛdu ni nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Nɛn bo nɛ Yosɛf ñɛn' Galile ya tinfɛnm ya du wà bi yih wù Nasarɛt nnɔ ni, ki jon' bi maa' *Dafid udu wà ni u te Sude ya tinfɛnm ni, bi yih wù Bɛtelɛm nnɔ ni, kimɛ Yosɛf bugbɛn yé *Dafid ya yaabil nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","U là tɔke nin Mari utɛnpunb ki jon' niʼbó kukɛ̀nku nnɔ nɛ. Bi là pun' Yosɛf u ya jɛfaan nɛ, ama wa laan là kuɔn' wɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Bi te Bɛtelɛm ni u yo wà nnɔ, nɛ Mari ya mamaayo baa', ");
INSERT INTO gngNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","u maa' uʼjɛfɛnmɛl kì yé kijɛk ki taa' tikpɛlcɛr ki pɔbn' kɛ̀, ki taa' kɛ̀ ki kpìen' tiwɛnt jinh nà ni, kimɛ fɛnm ŋa là te cɛnduku ni. ");
INSERT INTO gngNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Tɔ, biwɛnkpaab biba là te mitinfɛnm nnɔ ni, ki kɔh ikpàan bó, ki gɔh ki gu biʼwɛnt kuñɔnku. ");
INSERT INTO gngNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Yonbdaan ya tond uba puɔ' biʼsaan, nɛ Yonbdaan ya wenwenku wende' ki yile' biʼbo, nɛ bujɛwaanbu cuo' bɛ cɛɛn. ");
INSERT INTO gngNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Nɛn saan nɛ utond nnɔ tɔke' bɛ ki ye: «La fɛnge mɛn, kimɛ n tuke tigbɛmɔnmɔnt nɛ ń lá tɔke nɛ. Tigbɛr nnɔ li sɔnge binib kɛ ya yɛnm kí gbien. ");
INSERT INTO gngNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Dinnɔ wuɔ nɔ, bi maa' niʼŊmiɛnl *Kristo Yonbdaan, *Dafid ya du ni. ");
INSERT INTO gngNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Nà sɔ li yé kudìɛku: ni li lɛ kicɛnfɛndk kiba puɔbe tikpɛlcɛr ni ki kpe tiwɛnt jinh nà ni.» ");
INSERT INTO gngNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Nɛ Yonbdaan ya tondb ligol baa' utondbaab nnɔ saan i ya tàan bo bi pɛ̀keh Uwien ki teh: ");
INSERT INTO gngNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«Uwien si ukpiɛke paaki bó. Uyɛnduɔn ń li te kitink bo binib bà Uwien yíe bɛ nnɔ bo» ");
INSERT INTO gngNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Yonbdaan ya tondb nnɔ siere' ki liɛbe' ki don' paaki bó u yo wà nnɔ, nɛ biwɛnkpaab nnɔ ji tɔkeh tɔb ki teh: «Tí jo mɛn Bɛtelɛm, kí tì liike nibonn nà tien' niʼbó ŋɔ Yonbdaan cère' tí bɛnde nɔ.» ");
INSERT INTO gngNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Nɛ bi pɔk ki bure' ki tì baa' ki laa' Mari nin Yosɛf nin kicɛnfɛndk nnɔ, ki kpe tiwɛnt jinh nà ni. ");
INSERT INTO gngNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Bi laa' kɛ̀ ma nnɔ, nɛ ki len' Yonbdaan ya tond bi tɔke' bɛ nà kɛ kicɛnfɛndk nnɔ bo nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Nɛ nì bɛke' binib bà kɛ cii' biwɛnkpaab len' tigbɛr tà nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mari wɔn cengeh tigbɛr nnɔ kɛ, nɛ ki tùɔreh ki taah tù ki blinh uʼfɛ̀l bo. ");
INSERT INTO gngNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Nɛn saan nɛ biwɛnkpaab nnɔ siere' ki liɛbeh, ki pɛ̀keh Uwien, ki kpiɛkreh wɔ, bi cii' nà nin bi laa' nà bo. Kimɛ niʼkɛ tien' tɛn Yonbdaan ya tond bi len' ma bo nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Wienniin daali bi jiɛ' kibuk nnɔ ya punl nɛ ki yin' kɛ̀ Yesu. Kimɛ Yonbdaan ya tond là ye bɛ ń yin kɛ̀ li ya yel nɛ ki yaan bi punbe' kɛ̀. ");
INSERT INTO gngNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Uyo wà nì kpaan' bɛ ń tien tijɔknt ya ñɛnm ya tuɔrl tɛn Moyis ya yiko ye ma bo nnɔ, nɛ Mari nin Yosɛf taa' kibuk nnɔ ki jon' Yerusalɛm, bɛ ń tì wuɔn Yonbdaan. ");
INSERT INTO gngNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Kimɛ nì kɛle' Yonbdaan ya yiko ya gbɔnku ni ki ye: «Kibujɛbukpiɛk kɛ li yé Yonbdaan yaak nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Mari nin Yosɛf li tien lituɔrl nnɔ Yonbdaan ya yiko ye ma bo nɛ. U ye bɛ ń li taah kumuɔku ni ya nɛnjel ile bii iden ya nɛnjefanfaan ile nɛ ki teh lituɔrl nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Tɔ, ujɛ uba là te Yerusalɛm ni, bi yih wɔ Simeyɔn, u yé unil wà cuube nɛ, ki pɛ *Uwien bo mɔnmɔnm, ki gu lidaali là Uwien li ñɛn Israyɛl yaab biʼjɛnd ni. *Mifuoñaanm là te uʼbo, ");
INSERT INTO gngNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ki tɔke' wɔ ki ye wa ń kpo, ka laa' Yonbdaan ya Nigɛndkɛ Kristo. ");
INSERT INTO gngNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","*Mifuoñaanm cère' u kɔn' Uwien ya duku ya luo bo. U te len uyo wà nnɔ, nɛ kicɛnfɛndk *Yesu ya naa nin kiʼbaa tuke kɛ̀ ki kɔn' ní, bɛ ń lá tien kɛ̀ lituɔrl Yonbdaan ya yiko ye ma bo, ");
INSERT INTO gngNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","nɛ Simeyɔn teke' kɛ̀ ki ŋuuke, ki pɛ̀keh Uwien ki teh: ");
INSERT INTO gngNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«Tɔɔ, Yonbdaan, fɛnfɛnnɔ a tien' a là tɔke' nni nà nnɔ. A li fre kí cère min aʼtonsɔnl ń kpo nin uyɛnduɔn. ");
INSERT INTO gngNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Kimɛ a cère' nʼnun laa' Uŋmiɛnl. ");
INSERT INTO gngNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","A là bonde' wɔ uŋɛndun ya nib kɛ ya nun bó nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","U yé kuwenwenku kùa li cère bà ŋa yé Israyɛl yaab ń bɛnde ŋɛ nɛ. Wɔn bo nɛ binib li kpiɛke aʼnib Israyɛl yaab.» ");
INSERT INTO gngNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Kibuk nnɔ ya naa nin kiʼbaa cii' Simeyɔn len' kiʼbo tigbɛr tà nnɔ, nɛ nì bɛke' bɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","U tien' bɛ Uwien ya mɔnm, ki tɔke' kiʼnaa Mari ki ye: «A li bɛn ki ye kibuk kiɛ bo, tinbi Israyɛl yaab ni bà yɛbe li lu, bà yɛbe mɔ li fii. Kì yé kudìɛku kùa li cère binib ŋa ń len ki cii' tɔb bó nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Kì li cère iyɛnmaale yà buɔ binib bà yɛbe ya fɛ̀l ni ń ñɛ upaan bo. Sin Mari mɔnɔn, nì li wire ŋɛ tɛn bi cɔke' ŋɛ kijuk nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Upii uba mɔ là te, ki yé *Uwien ya ñɔbonsɔknl, bi yih wɔ Ann. U yé Fanuyɛl ya bisɛ, ki yé Asɛr ya bol ya nil, ki pore' cɛɛn. U là tien' uʼcɛ saan ibin ilole, nɛ u kpo' ki cère' wɔ, ");
INSERT INTO gngNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","u juore' ki yé ukpopii ki tì baa' ibin piniin nin inan, ka jɛndeh Uwien ya duku, ki pukeh wɔ ñɔnku nin wien ni, ki lùoh buñɔbu, ki kàareh. ");
INSERT INTO gngNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Tɔ, u ya yo nɛ uʼmɔ baa' ní, ki cin' ki faareh Uwien kibuk nnɔ bo, nɛ ki tɔke' kiʼgbɛr Yerusalɛm ya nib bà kɛ là gu uyo wà Uwien li teke bɛ kí wiɛ nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","*Yesu ya baambɛ tien' Yonbdaan ya yiko ye ma nnɔ kɛ, nɛ ki liɛbe' ki kun' Nasarɛt, biʼdu ni Galile ya tinfɛnm ni. ");
INSERT INTO gngNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Kibuk nnɔ kpienh, ki faakreh, ki lɛnh miyɛnfuom, nɛ Uwien ya mɔnm te kiʼbo. ");
INSERT INTO gngNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Binl kɛ binl *Yesu ya baambɛ doh Yerusalɛm bó nɛ ki tì jeleh Pak ya nacenku. ");
INSERT INTO gngNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","*Yesu tì laa' ibin piik nin ile uyo wà nnɔ, nɛ bi tuke' wɔ ki don' Yerusalɛm bó tɛn bi tì ń tuu ki joh ma kunacenku nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Kunacenku nnɔ ya wien tì gben' ma nnɔ nɛ bi liɛbe' ki kunh biʼdonbó. Ama kibuk *Yesu wɔn là juore' Yerusalɛm ni nɛ, ba bɛn ki ye u juore'. ");
INSERT INTO gngNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","*Yesu ya baambɛ cuon' liwentunŋmɛnl ki maaleh ki teh u lii te bisɛnjotɔb ni nɛ. Bi lá tiɛre' ki liike' ka laa' wɔ, nɛ ki cin' ki nuunh wɔ biʼyaab nin biʼbɛnbɛnkaab kɛ ni. ");
INSERT INTO gngNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ba laa' wɔ, nɛ ki pekre' ki nuunh wɔ ki liɛbeh Yerusalɛm. ");
INSERT INTO gngNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Wienta daali nɛ bi laa' wɔ Uwien ya duku ya luo bo, u kɛ *Yiko ya wɔnwɔknb ya siik ni, ki cengeh biʼwɔknm, ki niireh bɛ iniire. ");
INSERT INTO gngNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Nì jin' binib bà kɛ cengeh uʼbó nnɔ, kimɛ u ŋmɔbe mibɛnm, nɛ ki jiindeh bɛ mɔnmɔnm. ");
INSERT INTO gngNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Uyo wà uʼbaambɛ tì laa' wɔ nnɔ, nì bɛke' bɛ cɛɛn, nɛ uʼnaa ye: «Kibukɛ! Bɛ nɛ a tien' tɛ nɔ nnɔ? Liike min nin aʼbaa ya yɛnm saa' ma cɛɛn uyo wà ti nuunh ŋɛ nnɔ-a!» ");
INSERT INTO gngNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Nɛ *Yesu jiin' bɛ ki ye: «Bɛ bo nɛ ni nuunh nni? Na bɛn ki ye ń li te nʼBaa den nɛ-ɛɛ?» ");
INSERT INTO gngNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ama ba cii' u tɔke' bɛ liñɔbonl là nnɔ ya tingi. ");
INSERT INTO gngNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Nɛn saan nɛ *Yesu paan' biʼbo ki liɛbe' Nasarɛt, kimɛ u là boh bɛ nɛ. Uʼnaa taah tigbɛr nnɔ kɛ ki blinh uʼfɛ̀l bo. ");
INSERT INTO gngNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","*Yesu kpienh ki yɛbreh, uʼyɛnfuom pukndeh, nɛ Uwien nin binib kɛ ya yɛnm sɔnge uʼbo. ");
INSERT INTO gngNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Erom yaab ya bɛrciɛn Tibɛr Sesa ya bɛl ya piikn binlŋun bo, ki laa' Pɔns Pilat nɛ yé Sude ya tinfɛnm ya gobina. Herod mɔ yé Galile ya tinfɛnm ya gobina, uʼninjɛ Filip mɔ yé Iture nin Trakonit ya gobina, nɛ Lisaniyas mɔ yé Abilɛnn yɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","U yo wà Anni nin Kayif yé bitɔtuɔrciɛnb ya ciɛnb nnɔ nɛ Uwien len' nin Sakari ya bijɛ San kupenpelku ni. ");
INSERT INTO gngNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","U cin' ki cuonh mitinfɛnm mà nuɔn Sudɛn ya kpenl nnɔ ni, ki kpaandeh ki teh: «Lèbre mɛn niʼtetem, ń sìi nɛ Uwien ya ñunm ŋɔ Uwien ń fère nɛ niʼbiɛre.» ");
INSERT INTO gngNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","U tien' nnɔ ŋɔ nà kɛle' *Uwien ya ñɔbonsɔknl Esayi ya gbɔnku ni nnɔ nɛ̀ ń tien nɛ. Nì kɛle' ki ye: «Udaan uba te kupenpelku ni ki wuureh ki teh: ‹Tùɔre mɛn Yonbdaan ya sɛn, kí cubn uʼsɛngbɛnmu kí de wɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Bi li taa titɛnt kí gbien tijɔbòr kɛ, kí bere kí jenge ijuɔn nin igbɛngbɛn kɛ, kí naare isɛn yà kɛ pɔle', kí kpɛlke isɛn yà kɛ ŋa kpɛlke. ");
INSERT INTO gngNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Unisaal kɛ li lɛ Uwien ŋmiɛndeh ma binib.› » ");
INSERT INTO gngNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Nɛn saan nɛ San tɔkeh linigol là bàareh uʼsaan, ki nuunh wɔ ń sìi bɛ Uwien ya ñunm nnɔ ki teh: «Iwaalɛb ninbi, ŋmɛ nɛ wuɔn' nɛ ni li tien ma kí ñɛ Uwien ya benpiebe wà we ní nnɔ ni? ");
INSERT INTO gngNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Li sɔnh mɛn itùon yà wɔngeh ki teh ni lèbre' niʼtetem, ki la li maaleh niʼyɛnm ni ki teh: ‹Tiʼyaajɛ si *Abraham ma nnɔ, nì dɛ̀kre' nɛ›, kimɛ n tɔkeh nɛ nɛ, Uwien li fre kí cère itɛn yiɛ nɔ ń kpɛnde *Abraham ya yaabii. ");
INSERT INTO gngNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Uwien bonde' liyɛl ŋɔ wɔ ń kpìkre isiin. Isiin yà kɛ ŋa lùonh biimɔnmɔn la, u li gɛ yì kí wiɛ umu ni nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Nɛ inigol nnɔ niireh wɔ ki teh: «Ti nín li tien mila?» ");
INSERT INTO gngNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Nɛ u jiindeh bɛ ki teh: «Wà ŋmɔbe iliɛr ile la, wɔ ń taa liba kí pu wà ŋa ŋmɔbe. Wà mɔ ŋmɔbe tijier la, wɔ ń pu wà ŋa ŋmɔbe.» ");
INSERT INTO gngNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Bilɛnpotekb mɔ baa' uʼsaan wɔ ń sìi bɛ Uwien ya ñunm, nɛ ki niire' wɔ ki ye: «Cɛnbaa, tiʼmɔ li tien mila?» ");
INSERT INTO gngNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Nɛ u jiin' bɛ ki ye: «La wɔbndeh mɛn nib bɛ ń li paanh nì gɛ̀breh bi sien' nɛ ubiɛn wà.» ");
INSERT INTO gngNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Nɛ sojambɛ mɔ niire' wɔ ki ye: «Nɛ tinbi le? Tiʼmɔ li tien mila?» Nɛ u jiin' biʼmɔ ki ye: «La fienh mɛn nib ya bonn, ki la biin wà ŋa ŋmɔbe biil. Cère mɛn niʼyɛnm ń li sɔnge niʼpaaku bo.» ");
INSERT INTO gngNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Binib là gu Uwien ya Nigɛndkɛ Kristo ya baam, nɛ ki maaleh biʼyɛnm ni ki teh: «San la lii yé wɔn nɛ-a?» ");
INSERT INTO gngNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Nɛ San tɔke' biʼkɛ ki ye: «Min taah miñunm nɛ ki siih nɛ Uwien ya ñunm. Ama uba we ní, ki cɛn' nni. Ma kpɛ ń lore uʼtacɛningbɛn. Wɔn nɛ lá li cère *Mifuoñaanm nin umu ń jiire ní niʼbo. ");
INSERT INTO gngNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","U taa' kiyonyiek ŋɔ wɔ ń tì lende uʼji. U li taa mijibim kí cùɔn ubɔnbuɔn ni, kí taa tifent kí wiɛ umu wà ŋa ń kpiin ni.» ");
INSERT INTO gngNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Tɔ, San liɛbe' ki taa' iñɔbontɔ ì yɛbe ki saake' binib ya gbɛnɛnt, ki tɔke' bɛ tigbɛmɔnmɔnt. ");
INSERT INTO gngNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","U ya yo nɛ gobina Herod là taa' uʼninjɛ ya po Herodiyad, ki kuɔn', ki liɛbe' ki sɔn' itùonbiɛrtɔ mɔ ì yɛbe. Nɛn kɛ bo nɛ San tɔke' wɔ ki ye u bii'. ");
INSERT INTO gngNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Nɛn bo nɛ Herod cuo' San ki tì pɛkn', ki liɛbe' ki bii' ki pukn'. ");
INSERT INTO gngNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","San là siih binib kɛ Uwien ya ñunm ma nnɔ, nɛ ki sìi' *Yesu mɔ. *Yesu kàareh uyo wà nnɔ, nɛ kutaaku yàare', ");
INSERT INTO gngNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","*Mifuoñaanm jiinh ní ki naan unɛnjel ki lá kɛ̀le' uʼbo, nɛ uniɛke uba ñɛn' paaki bó ní ki ye: «Sin, a yé nʼbijɛ nɛ, n yíe ŋɛ nɛ nʼyɛnm sɔnge aʼbo.» ");
INSERT INTO gngNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Uyo wà *Yesu baa tɛn ibin pita nnɔ, nɛ ki cin' uʼtuonl. Binib là maaleh ki teh u yé Yosɛf ya bijɛ nɛ. Yosɛf là yé Heli ya bijɛ nɛ, ");
INSERT INTO gngNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli mɔ yé Matat ya bijɛ, Matat mɔ yé Lefi ya bijɛ, Lefi mɔ yé Mɛlki ya bijɛ, Mɛlki mɔ yé Yanayi ya bijɛ, Yanayi mɔ yé Yosɛf ya bijɛ, ");
INSERT INTO gngNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yosɛf mɔ yé Matatiyas ya bijɛ, Matatiyas mɔ yé Amos ya bijɛ, Amos mɔ yé Nahum ya bijɛ, Nahum mɔ yé Esili ya bijɛ, Esili mɔ yé Nagayi ya bijɛ, ");
INSERT INTO gngNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagayi mɔ yé Mart ya bijɛ, Mart mɔ yé Matatiyas ya bijɛ, Matatiyas mɔ yé Semeyinn ya bijɛ, Semeyinn mɔ yé Yosɛk ya bijɛ, Yosɛk mɔ yé Yoda ya bijɛ, ");
INSERT INTO gngNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda mɔ yé Yowanan ya bijɛ, Yowanan mɔ yé Lesa ya bijɛ, Lesa mɔ yé Sorobabɛl ya bijɛ, Sorobabɛl mɔ yé Salatiɛl ya bijɛ, Salatiɛl mɔ yé Neri ya bijɛ, ");
INSERT INTO gngNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri mɔ yé Mɛlki ya bijɛ, Mɛlki mɔ yé Adi ya bijɛ, Adi mɔ yé Kosam ya bijɛ, Kosam mɔ yé Elmadam ya bijɛ, Elmadam mɔ yé Ɛri ya bijɛ, ");
INSERT INTO gngNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ɛri mɔ yé *Yesu ya bijɛ, *Yesu mɔ yé Eliesɛr ya bijɛ, Eliesɛr mɔ yé Yorim ya bijɛ, Yorim mɔ yé Matat ya bijɛ, Matat mɔ yé Lefi ya bijɛ, ");
INSERT INTO gngNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lefi mɔ yé Simeyɔn ya bijɛ, Simeyɔn mɔ yé Suda ya bijɛ, Suda mɔ yé Yosɛf ya bijɛ, Yosɛf mɔ yé Yonam ya bijɛ, Yonam mɔ yé Eliyakim ya bijɛ, ");
INSERT INTO gngNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliyakim mɔ yé Meleya ya bijɛ, Meleya mɔ yé Mena ya bijɛ, Mena mɔ yé Matata ya bijɛ, Matata mɔ yé Natan ya bijɛ, Natan mɔ yé *Dafid ya bijɛ, ");
INSERT INTO gngNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","*Dafid mɔ yé Yɛse ya bijɛ, Yɛse mɔ yé Yobɛd ya bijɛ, Yobɛd mɔ yé Bos ya bijɛ, Bos mɔ yé Sala ya bijɛ, Sala mɔ yé Nasɔn ya bijɛ, ");
INSERT INTO gngNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasɔn mɔ yé Aminadab ya bijɛ, Aminadab mɔ yé Adimin ya bijɛ, Adimin mɔ yé Arini ya bijɛ, Arini mɔ yé Ɛsilɔm ya bijɛ, Ɛsilɔm mɔ yé Farɛs ya bijɛ, Farɛs mɔ yé Suda ya bijɛ, ");
INSERT INTO gngNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Suda mɔ yé Sakɔb ya bijɛ, Sakɔb mɔ yé *Isaak ya bijɛ, *Isaak mɔ yé *Abraham ya bijɛ, *Abraham mɔ yé Tara ya bijɛ, Tara mɔ yé Nakor ya bijɛ, ");
INSERT INTO gngNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nakor mɔ yé Seruk ya bijɛ, Seruk mɔ yé Eragawu ya bijɛ, Eragawu mɔ yé Falɛk ya bijɛ, Falɛk mɔ yé Ebɛr ya bijɛ, Ebɛr mɔ yé Sala ya bijɛ, ");
INSERT INTO gngNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala mɔ yé Kayinam ya bijɛ, Kayinam mɔ yé Afaksad ya bijɛ, Afaksad mɔ yé Sɛm ya bijɛ, Sɛm mɔ yé Nowe ya bijɛ, Nowe mɔ yé Lamɛk ya bijɛ, ");
INSERT INTO gngNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamɛk mɔ yé Matusala ya bijɛ, Matusala mɔ yé Enɔk ya bijɛ, Enɔk mɔ yé Yarɛd ya bijɛ, Yarɛd mɔ yé Malelɛl ya bijɛ, Malelɛl mɔ yé Kayinam ya bijɛ, ");
INSERT INTO gngNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kayinam mɔ yé Enɔs ya bijɛ, Enɔs mɔ yé Sɛt ya bijɛ, Sɛt mɔ yé Adam ya bijɛ, Adam mɔ yé Uwien ya bijɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","*Mifuoñaanm jiire' ní *Yesu bo ki gbe uʼni. U siere' Sudɛn ya kpenl saan, nɛ mì tuke' wɔ ki jon' kupenpelku ni, ");
INSERT INTO gngNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","nɛ usɛnpol bìkreh wɔ len ki tì baa' iwien pinan. Iwien pinan nnɔ wa jin' niba. Ì gɛ̀bre' ma nnɔ nɛ mikònm cuo' wɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Nɛn saan nɛ usɛnpol tɔke' wɔ ki ye: «A yé Uwien ya Bijɛ la, cère litɛnl liɛ ń kpɛnde kpɔnɔ.» ");
INSERT INTO gngNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","*Yesu jiin' wɔ ki ye: «Nì kɛle' *Uwien ya gbɔnku ni ki ye: ‹Nil ŋa ń li fuobe jier baba bo.› » ");
INSERT INTO gngNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Nɛ usɛnpol taa' wɔ ki don' nà saan dokre', ki wuɔn' wɔ uŋɛndun ya bɛl kɛ i ya tàan bo, ");
INSERT INTO gngNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","nɛ ki tɔke' wɔ ki ye: «N li de ŋɛ libɛl liɛ ya ciɛnt nin liʼfaal kɛ, kimɛ bi là taa' niʼkɛ ki de' min nɛ. N li fre kí taa nɛ̀ kí de n yíe wà. ");
INSERT INTO gngNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Nɛn bo, a gbaan' nʼnintuɔli ki puke' nni la, sin nɛ li si niʼkɛ.» ");
INSERT INTO gngNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Nɛ *Yesu jiin' wɔ ki ye: «Nì kɛle' *Uwien ya gbɔnku ni ki ye: ‹A li gbaan kí kpiɛke aʼYonbdaan Uwien nɛ kí li pukeh wɔn baba.› » ");
INSERT INTO gngNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Nɛ *usɛnpol taa' wɔ ki jon' Yerusalɛm, ki tì duon' wɔ *Uwien ya duku ya paaki lekleki, nɛ ki tɔke' wɔ ki ye: «A yé *Uwien ya Bijɛ la, maabe kí lá ci tingi ni, ");
INSERT INTO gngNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","kimɛ nì kɛle' *Uwien ya gbɔnku ni ki ye: ‹Sin bo, Uwien li wɔbn uʼtondb bɛ ń guure ŋɛ.› ");
INSERT INTO gngNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ki tí ye: ‹Bi li guɔre ŋɛ ŋɔ aʼtaal la mɛ tɛnl.› » ");
INSERT INTO gngNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Nɛ *Yesu jiin' wɔ ki ye: «Nì tí kɛle' mɔ ki ye: ‹Ŋa ń biike aʼYonbdaan Uwien.› » ");
INSERT INTO gngNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Usɛnpol biike' *Yesu mibiikm kɛ ya bol ki tì gbɛle', nɛ ki laan siere' ki dàan' wɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","15","*Yesu liɛbe' ní Galile ya tinfɛnm ni nin *Mifuoñaanm ya tuɔm, ki wɔknh *Sufmbɛ ya táan ya dur ni; nɛ binib kɛ kpiɛkreh wɔ. U ya yo nɛ uʼyel kpienh mitinfɛnm nnɔ ni niʼkɛ saan. ");
INSERT INTO gngNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","*Yesu baa' Nasarɛt ya du ni, bi wube' wɔ nà saan, nɛ ki kɔn' *Sufmbɛ ya taanl ya duku ni *Saba ya daali tɛn u tì ń teh ma uyo kɛ. U fii' ki sere' wɔ ń kàan *Uwien ya gbɔnku, ");
INSERT INTO gngNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","nɛ bi taa' *Uwien ya ñɔbonsɔknl Esayi ya gbɔnku ki de' wɔ. U pɛ̀re' kugbɔnku nnɔ, nɛ ki kaan' nà saan nì kɛle' ki ye: ");
INSERT INTO gngNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«Yonbdaan ya Fuoñaanm te nʼbo, kimɛ u gɛ̀nde' nni ń tɔke bijiinb tigbɛmɔnmɔnt nɛ, ki sɔn' nni ní ń lá tɔke iyonbe kí ye ì li teke iʼyul, kí tɔke ijùɔn kí ye ì li likre, kí tɔke bi jɛ̀ndeh bà nnɔ kí ye bi li ñɛ biʼjɛnd ni, ");
INSERT INTO gngNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","kí tɔke binib libinl là Yonbdaan li tien bɛ tinimɔ̀nt.» ");
INSERT INTO gngNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","*Yesu konkonde' kugbɔnku nnɔ, ki jiin' ki de' litaanl ya duku ya tonsɔnl, nɛ ki kɛ̀le'. Binib bà kɛ te kuduku nnɔ ni caan' uʼbo inun, ");
INSERT INTO gngNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","nɛ u cin' ki tɔkeh bɛ ki teh: «Tigbɛr tà ni cii' tù nɔ, dinnɔ nɛ tù tien'.» ");
INSERT INTO gngNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Nɛ biʼkɛ kun' uʼbo imɔ̀n. U len' iñɔbonmɔnmɔn yà nnɔ bɛke' bɛ cɛɛn, nɛ bi niireh tɔb ki teh: «Wa yé Yosɛf ya bijɛ-ɛɛ?» ");
INSERT INTO gngNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Nɛ u tɔke' bɛ ki ye: «N bɛn ki ye ni li pɔ nni mikpɛnjɛnm miɛ nɔ ki ye: ‹Dɔktiɛ, buu aʼba.› Ni tí li tɔke nni kí ye ‹ni cii' n tien' nà kɛ Kapɛrnawum ya du ni nnɔ, ń tien nɛ̀ nʼdu ni mɔ.› » ");
INSERT INTO gngNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Nɛ ki tí ye: «N tɔkeh nɛ imɔ̀n nɛ, ‹*Uwien ya ñɔbonsɔknl kɛ ñɔbonsɔknl ya tiɛma du ni yaab nɛ ŋa teknh uʼgbɛr.› » ");
INSERT INTO gngNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","N tɔkeh nɛ imɔ̀n nɛ, Eli ya yo utaa là sere' ibin ita nin iŋmaale iluob nɛ, nɛ mikònciɛnm lu' uŋɛndun kɛ ni. U ya yo ki laa' bikpopiib po nɛ Israyɛl ya du ni. ");
INSERT INTO gngNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Nin nɛn kɛ ŋɔ Uwien ŋa là sɔn' Eli biʼni uba mɔnɔn saan. Ama u là sɔn' wɔ Sarɛpta ya du wà te Sidɔn ya tinfɛnm ni nnɔ ya kpopii uba saan nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","*Uwien ya ñɔbonsɔknl Elise ya yo ki laa' ijend po nɛ Israyɛl ya du ni, ama Elise ŋa là cère' biʼni uba mɔnɔn lùore', u là cère' Naaman wà yé Siri ya tinfɛnm ya nil nnɔ baba nɛ lùore'. ");
INSERT INTO gngNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Binib bà kɛ te litaanl ya duku ni nnɔ cii' u len' nà nnɔ nɛ biʼbenku ni ben' uʼbo ki gbien', ");
INSERT INTO gngNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","nɛ bi fii', ki cuo' wɔ ki ñɛn' udu ni, ki taa' wɔ ki tì baa' biʼdu nnɔ te ligbɛngbɛnl là bo nnɔ ya tintinm saan, bɛ ń ture wɔ kí wiɛ liʼtingi. ");
INSERT INTO gngNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ama u ñɛn' biʼsiik ni, ki bure'. ");
INSERT INTO gngNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","U tì baa' Galile ya tinfɛnm ya du uba ni bi yih wù Kapɛrnawum, ki cin' ki wɔknh binib Uwien ya gbɛr *Saba ya daali. ");
INSERT INTO gngNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Uʼwɔknm nnɔ cuo' binib nnɔ kɛ miyɔkm cɛɛn, kimɛ u du uʼwɔknm nnɔ bo nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Tɔ, ujɛ uba là te Sufmbɛ ya taanl ya duku nnɔ ni usɛnpol ŋaake wɔ. U laa' Yesu, nɛ ki wuure' ufaa bo ki ye: ");
INSERT INTO gngNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«Ho! Nasarɛt ya Yesu, tinbi nin sin tu lɛ nɛ? A baa' á lá boln tɛ nɛ-ɛɛ? N bɛn a yé udaan wà, a yé Uwien ya Niñaan nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Nɛ *Yesu tiɛn' uʼbo ki ye: «Ŋmile, kí siere ki dàan ujɛ wuɔ nɔ». Nɛ usɛnpol nnɔ gbɔ̀be' ujɛ nnɔ binib kɛ ya siik ni, ki dàan' wɔ ka tien' wɔ niba. ");
INSERT INTO gngNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Nɛ nì cuo' biʼkɛ miyɔkm cɛɛn. Nɛn saan nɛ bi niireh tɔb ki teh: «Bɛ ya gbɛr sɔ nɔ? U ŋmɔbe ufaa nin mituɔm nɛ ki wɔbndeh isɛnpol, ì dàandeh binib-a!» ");
INSERT INTO gngNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Nɛ *Yesu ya yel kpienh mitinfɛnm nnɔ kɛ ni. ");
INSERT INTO gngNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","*Yesu ñɛn' litaanl ya duku nnɔ ni, ki jon' Simɔn den, ki laa' Simɔn ya cɔbnaa bun, uʼgbɛnɛnt ton cɛɛn. Bi gbáan' *Yesu ki ye wɔ ń cère wɔ ń faake. ");
INSERT INTO gngNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Nɛ u gòn' uʼbo, ki tiɛn' iwìɛn nnɔ bo nɛ u faake' ki pɔk ki fii' ki cɛ̀nde' bɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Uwien benh wù ń lu uyo wà nnɔ, nɛ bà kɛ yaab bun iwìɛn kɛ ya bol tukeh bɛ ki bàareh *Yesu saan. U taah uʼnuɔ ki paakeh biʼbo, nɛ bi faakreh. ");
INSERT INTO gngNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","U cèreh isɛnpol mɔ dàandeh linigol, ki wuureh ki teh: «A yé Uwien ya Bijɛ nɛ.» Ama *Yesu tɛngeh iʼbo nɛ ka cèreh ì lienh kimɛ ì bɛn ki ye u yé Uwien ya Nigɛndkɛ Kristo nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Nì faa', nɛ *Yesu siere' ki jon' nib ŋa te nà saan. Nɛ linigol cin' ki nuunh wɔ. Bi tì laa' wɔ, nɛ ka ji yíe wɔ ń siere kí dàan bɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Nɛ u tɔke' bɛ ki ye: «Nì kpɛ ń taa Uwien ya bɛl ya gbɛmɔnmɔnt tuu nɔ kí tɔke idutɔ mɔ yaab nɛ, kimɛ nɛn bo nɛ Uwien sɔn nni ní.» ");
INSERT INTO gngNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Nnɔ nɛ u tɔkeh binib Uwien ya gbɛr *Sufmbɛ ya táan ya dur tà te Sude ya tinfɛnm ni nnɔ ni. ");
INSERT INTO gngNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Lidaali liba *Yesu là se Genesarɛt ya ñunciɛnm ya gbaal, nɛ linigol pɛbeh wɔ ki nuunh bɛ ń cenge Uwien ya gbɛr. ");
INSERT INTO gngNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","U laa' iñɛrde ile miñunm nnɔ ya gbaal. Bijɛnbɛb ñɛn' iʼni ki te ki sɔkreh biʼbàan. ");
INSERT INTO gngNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Nɛ *Yesu kɔn' iñɛrde nnɔ ya buba, bù yé Simɔn yaabu, nɛ ki gbáan' wɔ ki ye wɔ ń sule kí kɔ miñunm ni waamu. U sule' ki kɔn', nɛ *Yesu kɛ̀le' buñɛrbu nnɔ ni, ki cin' ki wɔknh inigol Uwien ya gbɛr. ");
INSERT INTO gngNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","U wɔkn' ki tì gben', nɛ ki tɔke' Simɔn ki ye: «Jo miñunm ñɔ nà saan, ní tì wiɛ niʼbàan kí cuo ijɛn.» ");
INSERT INTO gngNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Nɛ Simɔn jiin' wɔ ki ye: «Cɛnbaa, ti jɛ̀nde' kuñɔnŋmɛnku nɛ ka cuo' bonn. Ama sin len' ma nɔ, n li wiɛ.» ");
INSERT INTO gngNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Bi wiɛ', ki cuo' ijɛn ì yɛbe ka dindin, haali ibàan tì benh yɛ̀ ń kɛre. ");
INSERT INTO gngNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Nɛ bi kɛnbe' ki yin' biʼjɛnbɛtɔb bà te buñɛrtɔbu ni nnɔ, bɛ ń baa kí tore bɛ. Bi baa', nɛ bi ñɛn' ijɛn nnɔ ki gbien' iñɛrde ile nnɔ kɛ, haali ì tì benh yì ń lin. ");
INSERT INTO gngNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simɔn Piɛr laa' nnɔ ma nnɔ, nɛ ki gbaan' *Yesu ya nun bó, ki tɔke' wɔ ki ye: «Yonbdaan, jɛnde nʼsaan, kimɛ n yé ubiɛrdaan nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Bi cuo' ijɛn ì yɛbe ma nnɔ, nɛ nì cuo' Simɔn nin bà kɛ te uʼsaan nnɔ miyɔkm cɛɛn. ");
INSERT INTO gngNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Miyɔkm cuo' Sebede ya bijiɛb Saak nin San bà yé Simɔn ya tonsɔntɔb nnɔ mɔ. Nɛn saan nɛ *Yesu tɔke' Simɔn ki ye: «La fɛnge, fɛnfɛnnɔ kí taa kí li joh, a ji li taakeh binib nɛ ki dienh nni.» ");
INSERT INTO gngNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Bi dɛ̀re' biʼñɛrde nnɔ ki ñɛn' ugbɛ, ki dàan' niʼkɛ, nɛ ki paan' uʼbo. ");
INSERT INTO gngNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Lidaali liba nɛ *Yesu te mitinfɛnm nnɔ ya du uba ni, ujɛ uba mɔ te len lijendl gbe uʼgbɛnɛnt kɛ bo. U laa' Yesu, nɛ ki baa' ki lá pùon' uʼnun bó, ki gbáan' wɔ ki ye: «Yonbdaan, a yíe la, a li fre kí cère ń lùore.» ");
INSERT INTO gngNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Nɛ *Yesu tɛnde' uʼnuɔ ki mɛ' wɔ, nɛ ki ye: «N yíe, lùore.» Nɛ lijendl nnɔ pɔk ki gben' i ya tàan bo. ");
INSERT INTO gngNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Nɛ *Yesu kpɛkpɛ' uʼbo ki ye u la tɔke nil nà tien', nɛ ki tɔke wɔ ki ye: «Li jo kí tì lɛ utɔtuɔrkɛ, kí tien milùorm ya tuɔrl tɛn Moyis là ye bɛ ń li teh ma bo. Nɛn nɛ li wuɔn kí ye a lùore'.» ");
INSERT INTO gngNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","*Yesu ya yel tùɔreh ki kpienh, nɛ inigol taakeh uʼsaan bɛ ń cenge uʼgbɛr ki yɛbe, ki nuunh wɔ ń buu biʼni bà yé biwiɛnb. ");
INSERT INTO gngNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ama u sɔbe ki siereh biʼsaan nɛ, ki joh nib ŋa te nà saan, ki tì kàareh. ");
INSERT INTO gngNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Lidaali liba nɛ *Yesu te ki wɔknh Uwien ya gbɛr. *Farisiɛnmbɛ nin *Yiko ya wɔnwɔknb bà ñɛn' Galile nin Sude ya tinfɛnm ya du kɛ ni nin Yerusalɛm bó ní nnɔ mɔ te niʼsaan. Yonbdaan Uwien ya tuɔm cèreh u buuh biwiɛnb. ");
INSERT INTO gngNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Nɛ bijɛb biba tuke' ujɛ uba linagɛnl bo ki baa' ní. Ujɛ nnɔ ya tàan nin uʼnuɔ nɛ là faan'. Bi nuunh bɛ ń taa wɔ kí kuɔn kuduku ni kí tì ble *Yesu ya nun bó nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Linigol nnɔ bo ba laa' fɛnm bɛ ń kuɔn wɔ Yesu saan ma nnɔ, nɛ ki don' u te kudulɛkaaku kùa ni nnɔ ya paaki, ki cube' libònl, nɛ ki taa' wɔ ki kuɔn' ki yekn' nin linagɛnl nnɔ, ki ble' siik ni *Yesu ya nun bó. ");
INSERT INTO gngNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","*Yesu laa' bi teke' wɔ ki jin' ma nnɔ, nɛ ki tɔke' ujɛ wà ya tàan nin uʼnuɔ faan' nnɔ ki ye: «N fère' ŋɛ aʼbiɛre ŋɔ.» ");
INSERT INTO gngNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Nɛn saan nɛ *Yiko ya wɔnwɔknb nin *Farisiɛnmbɛ cin' ki maaleh ki teh: «U yé ŋmɛ nɛ ki sukreh Uwien nɔ? Uwien baba ŋa ñí la, ŋmɛ li fre kí fère binib biʼbiɛre?» ");
INSERT INTO gngNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","*Yesu bɛnde' biʼyɛnmaale, nɛ ki niire' bɛ ki ye: « ‹Bɛ tien' ni maaleh nɔ nnɔ niʼyɛnm ni?› ");
INSERT INTO gngNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ni lɛ ba nɛ faa? Ń tɔke wɔ kí ye n fère' wɔ uʼbiɛre nɛ faa bii wɔ ń fii kí li cuonh nɛ faa? ");
INSERT INTO gngNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Nɛn bo, n li wuɔn nɛ kí ye Unil ya Bijɛ ŋmɔbe mituɔm uŋɛndun wuu ni wɔ ń fère binib biʼbiɛre. Nɛ ki tɔke' ujɛ wà ya tàan nin uʼnuɔ faan' nnɔ ki ye: ‹N lienh sin nɛ, fii, kí yuure aʼnagɛnl, kí li kunh.› » ");
INSERT INTO gngNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","I ya tàan bo nɛ u pɔk ki fii' biʼnun bó, ki yuure' linagɛnl là u bi dɔ liʼbo nnɔ, ki pɛ̀keh Uwien ki kunh. ");
INSERT INTO gngNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Nì cuo' biʼkɛ miyɔkm cɛɛn, nɛ bi pɛ̀keh Uwien. Bujɛwaanbu cuo' bɛ, nɛ bi lienh ki teh: «Ti laa' miyɔkm ya bonn dinnɔ.» ");
INSERT INTO gngNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ni ya puoli bó nɛ *Yesu siere' niʼsaan ki joh, ki laa' ulɛnpotekl uba bi yih wɔ Lefi, u kɛ lɛnpotekbùol. *Yesu tɔke' wɔ ki ye: «Paan nʼbo ní.» ");
INSERT INTO gngNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Nɛ u dàan' niʼkɛ, ki fii' ki paan' uʼbo. ");
INSERT INTO gngNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Lefi tien' tijier uʼden tù yɛbe ki teke' *Yesu kucɛ̀nku. Bilɛnpotekb ligol nin binitɔb mɔ là te tijier nnɔ ya jim. ");
INSERT INTO gngNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Nà ŋmaake' *Farisiɛnmbɛ nin biʼyaab bà yé *Yiko ya wɔnwɔknb nnɔ, nɛ bi niire' *Yesu ya panpaankaab ki ye: «Bɛ tien' ni jinh, ki ñuh nin bilɛnpotekb nin bibiɛrdɛnb-i?» ");
INSERT INTO gngNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Nɛ *Yesu tɔke' bɛ ki ye: «Binib bà ŋmɔbe laanfiɛ ŋa nuunh dɔktiɛ, bà bun nɛ nuunh dɔktiɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ma baa' ń yin nimɔ̀nb, n baa' ń yin bibiɛrdɛnb nɛ bɛ ń lèbre biʼtetem.» ");
INSERT INTO gngNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","*Farisiɛnmbɛ nnɔ tɔke' *Yesu ki ye: «San ya panpaankaab nin tinbi *Farisiɛnmbɛ yaab sɔbe ki lùoh buñɔbu nɛ, ki kàareh, nɛ aʼyaab bɛn jinh ki ñuh-a!» ");
INSERT INTO gngNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Nɛ u jiin' bɛ ki ye: «Ni li fre kí cère binib bà bi yin' bɛ upiikuɔn nnɔ ń lòle buñɔbu uyo wà piicɛ laan te biʼsaan-ii? ");
INSERT INTO gngNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ama uyo uba we ní bɛ ń ñɛn piicɛ biʼsaan. U ya yo nɛ bi li lòle buñɔbu.» ");
INSERT INTO gngNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Nɛ u tí pɔn' bɛ mikpɛnjɛnm ki ye: «Uba ŋa ń jiɛ kí lekre liliɛrfɛ̀nl ya kpɛlciɛku kí lekn likpaal. U tien' nnɔ la, u li saa lifɛ̀nl nnɔ, nɛ lifɛ̀nl ya kpɛlciɛku nnɔ ŋa ń tuo kí cuo nin likpaal nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Uba mɔ ŋa ń taa midaam mà ŋa laan muɔ' ki ben' kí piɛke iyɔkpaan ni. U tien' nnɔ la, midaam nnɔ li kpiɛn iyɔl nnɔ, kí wule kí ñɛnde nɛ iyɔl mɔ ń saa. ");
INSERT INTO gngNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ama bi piɛkeh midaam mà ŋa laan muɔ' ki ben' iyɔfɛ̀n ni nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Wà kɛ ñun' midaam mà muɔ' ki ben' la, wa ji yíe mà ŋa laan muɔ' ki ben', u li ye: ‹Mà muɔ' ki ben' nnɔ nɛ ŋmɛ.› » ");
INSERT INTO gngNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","*Saba uba ya daali, *Yesu nin uʼpanpaankaab gɛ̀breh ikpàan iba ni, nɛ uʼpanpaankaab coh ijifen ki cienh ki nukeh ki ŋmɔnh. ");
INSERT INTO gngNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Nɛ *Farisiɛnmbɛ biba niire' bɛ ki ye: «Bɛ tien' ni teh yiko kùɔn' nà *Saba ya daali?» ");
INSERT INTO gngNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Nɛ *Yesu jiin' bɛ ki ye: «Na kaan' *Dafid là tien' ma bo nɛ-ɛɛ? Mikònm là cuo' wɔn nin uʼnib ma nnɔ, ");
INSERT INTO gngNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","u kɔn' Uwien ya ninbonl ni, ki taa' kpɔnɔ wà bi taa' ki de' Uwien nnɔ ki ŋmɔn', ki taa' ki de' uʼnib, biʼmɔ ŋmɔn'. Ama bitɔtuɔrkaab baba nɛ là ŋmɔbe usɛn bɛ ń ŋmɔn kpɔnɔ nnɔ.» ");
INSERT INTO gngNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Nɛ ki tɔke' bɛ ki ye: «Unil ya Bijɛ nɛ ŋmɔbe usɛn wɔ ń wuɔn bi li tien nà Saba ya daali.» ");
INSERT INTO gngNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","*Saba ya dɛtɔl liba, *Yesu tí kɔn' litaanl ya duku ni, ki wɔknh binib Uwien ya gbɛr. Ujɛ uba mɔ te len, uʼnɔjie faan'. ");
INSERT INTO gngNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","*Yiko ya wɔnwɔknb nin *Farisiɛnmbɛ sekndeh bɛ ń liike u li cère unil ń faake *Saba ya daali bii wa ń cère, kimɛ bi nuunh bɛ ń lɛ bi li dule nà bo kí biin wɔ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","*Yesu bɛn biʼyɛnmaale ma nnɔ nɛ ki tɔke' ujɛ wà ya nuɔ faan' nnɔ ki ye: «Fii kí sere siik ni.» U fii' ki sere', ");
INSERT INTO gngNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","nɛ *Yesu niire' bɛ ki ye: «*Saba ya daali la, unil ŋmɔbe usɛn wɔ ń tien nà mɔn bii nà bre nɛ? U ŋmɔbe usɛn wɔ ń ŋmiɛn unil bii wɔ ń ku wɔ nɛ?» ");
INSERT INTO gngNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","U liike' biʼkɛ ki gɔbre' ki bòn', nɛ ki tɔke' ujɛ wà ya nuɔ faan' nnɔ ki ye: «Tɛnde aʼnuɔ.» U tɛnde' uʼnuɔ, nɛ u jire' uʼciɛm. ");
INSERT INTO gngNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Biʼbenku ni ben' cɛɛn, nɛ bi gbiereh bɛ ń liike bi li tien *Yesu ma. ");
INSERT INTO gngNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Lidaali liba nɛ *Yesu don' lijuɔl bo wɔ ń tì kàare, ki gɔn' ki kàareh ");
INSERT INTO gngNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","nì tì faa', nɛ u yin' uʼpanpaankaab ki gɛ̀nde' biʼni piik nin bile, ki yin' bɛ uʼtondb. ");
INSERT INTO gngNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Uʼtondb nnɔ ya yel sɔ: Simɔn, wà u yin' wɔ Piɛr nnɔ nin uʼninjɛ Andre nin Saak nin San nin Filip nin Batelemi ");
INSERT INTO gngNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","nin Matie nin Toma nin Alfe ya bijɛ Saak nin Simɔn wà ya nun mɔ́n uʼdu ya gbɛr bo, ");
INSERT INTO gngNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","nin Saak ya bijɛ Sudas nin Sudas Iskariyɔt wà lá li kuɔre Yesu. ");
INSERT INTO gngNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesu nin uʼtondb jiinh lijuɔl nnɔ bo, ki lá sere' liʼñiɛl, uʼpanpaankaab yɛbe nà saan nnɔ. Linigociɛnl liba mɔ là te niʼsaan. Lì ñɛn' ní Sude ya tinfɛnm kɛ ni nin Yerusalɛm ni nin Tir ni nin Sidɔn ya du ni nɛ. Idu nnɔ te miñunciɛnm ya gbaal nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Bi baa' bɛ ń cenge uʼgbɛr nɛ, kí nuunh wɔ ń buu biʼni bà yé biwiɛnb. Nɛ u buu' bɛ, ki ŋɔre' isɛnpol mɔ ì ŋmɔbe binib bà ki jɛ̀ndeh nnɔ saan. ");
INSERT INTO gngNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Linigol nnɔ kɛ nuunh bɛ ń mɛ wɔ, kimɛ mituɔm miba nɛ ñɛh uʼni ki cèreh biʼkɛ faakreh. ");
INSERT INTO gngNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Nɛn saan nɛ Yesu caan' uʼpanpaankaab bo inun, ki ye: «Ninbi bijiinbɛ, Uwien ya mɔnm te niʼbo, kimɛ Uwien ya bɛl yé niʼyaal nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ninbi bà mikònm ŋmɔbe nɛ fɛnfɛnnɔ nɔ, Uwien ya mɔnm te niʼbo, kimɛ ni lá li ji kí gbo. Ninbi bà muɔh fɛnfɛnnɔ nɔ, Uwien ya mɔnm te niʼbo, kimɛ ni lá li lɛ̀. ");
INSERT INTO gngNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","«Binib nɛn nɛ, ka yíe bɛ ń li lɛnh nɛ, ki sukreh nɛ, ki saah niʼyel Unil ya Bijɛ bo la, Uwien ya mɔnm te niʼbo. ");
INSERT INTO gngNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Bi teh nɛ nnɔ la, cère mɛn niʼyɛnm ń li sɔnge ní li poknh, kimɛ ni li lɛ lisuul là yɛbe paaki bó. Biʼyaajɛb mɔ là teh nnɔ nɛ Uwien ya ñɔbonsɔknb.» ");
INSERT INTO gngNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","«Ama ninbi bifàadɛnbɛ, nì bre niʼbo, kimɛ ni jin' niʼŋmaa ŋɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ninbi bà jinh ki gbiɛh fɛnfɛnnɔ nɔ, nì bre niʼbo, kimɛ mikònm lá li cuo nɛ. Ninbi bà lɛh fɛnfɛnnɔ nɔ, nì bre niʼbo, kimɛ niʼyɛnm lá li saa tɛn ni kɛ mikuum nɛ ki muɔh. ");
INSERT INTO gngNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Binib kɛ pɛ̀keh nɛ la, nì bre niʼbo. Biʼyaajɛb mɔ là teh nnɔ nɛ bitonnɛnñɔbonsɔknb.» ");
INSERT INTO gngNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","«N tɔkeh ninbi bà cengeh nni nɔ nɛ, li yíe mɛn niʼnɛnnɛndb, kí li teh bà nɛn nɛ mɔnmɔnm. ");
INSERT INTO gngNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Li tɔkeh mɛn binib bà wiɛnh nɛ miŋùum ki teh Uwien ń tien bɛ uʼmɔnm, kí li kàareh ki dienh bà sukreh nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Unil kpɔ̀be' aʼkpiɛnku kuba la, pekre kutɔku mɔ kí de wɔ. Unil fie' aʼliɛrgbenku la, cɛ̀be wɔ aʼliɛrwawaal mɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Wà kɛ miɛ' ŋɛ nibonn la, pu wɔ. Wà mɔ taa' aʼbonn la, la niire wɔ niʼbó. ");
INSERT INTO gngNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ni yíe binib ń li teh nɛ nà nnɔ, niʼmɔ ń li teh bɛ nɛn. ");
INSERT INTO gngNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","«Ni yíe bà yíe nɛ baba la, ni li lɛ ku lɛ pɛnpɛku? Bibiɛrdɛnb mɔnɔn yíe bà yíe bɛ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ni teh mɔnmɔnm bà teh nɛ mɔnmɔnm baba nɛ la, ni li lɛ ku lɛ pɛnpɛku? Bibiɛrdɛnb mɔnɔn teh nnɔ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ni kpendeh bà ni daan ki ye bi li jiin nɛ baba la, ni li lɛ ku lɛ pɛnpɛku? Bibiɛrdɛnb mɔnɔn kpendeh biʼtɔb nɛ, ki daan ki teh bi li jiin bɛ bi kpende' nà nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ama ninbi li yíe mɛn niʼnɛnnɛndb, kí li teh bɛ nà mɔn, kí li kpendeh binib tibont, ki la daan ki ye bi li jiin nɛ tù. Ni teh nnɔ la, ni li lɛ lisuul là yɛbe, nɛ ki li yé Uwien Wà ŋa ŋmɔbe Nacentɔ ya bumu. Wɔn mɔnɔn teh bibiɛrdɛnb nin binib bà ŋa faareh wɔ tinimɔ̀nt nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Li teh mɛn tinimɔ̀nt tɛn niʼBaa Uwien teh ma bo.» ");
INSERT INTO gngNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","«La biindeh mɛn nib ŋɔ Uwien mɔ la biin nɛ. La ye mɛn uba kpɛ utudɛre ŋɔ Uwien mɔ la ye niʼmɔ kpɛ utudɛre. Li fèreh mɛn binib biʼbiɛre ŋɔ Uwien mɔ ń fère nɛ niʼyi. ");
INSERT INTO gngNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Li punh mɛn binib ŋɔ Uwien mɔ ń li punh nɛ. U li gbien niʼyiek kɛ̀ ń gbe wɔ ń yeyeke, kí ñiñi kí gbien nɛ̀ ń wule, nɛ kí de nɛ, kimɛ ni taah nà ki bìkreh tibont ki dienh binitɔb nnɔ Uwien mɔ li taa nɛn nɛ kí biike kí de nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","*Yesu tí pɔn' bɛ mikpɛnjɛnm ki ye: «Ujuɔn li fre kí dìɛ uʼjuɔntɔ-ɔɔ? Biʼkɛ bile ŋa ń lu kubùoku ni-ii? ");
INSERT INTO gngNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Wà bɛngeh ŋa cɛn' wà wɔknh wɔ. Ama wà kɛ bɛnge' ki tì gben' la, u li te tɛn uʼcɛnbaa nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","«Bɛ tien' a lɛnh kumuɔku kùa te aʼtɔ ya nunbu ni, ka ji lɛnh jaantɛlkɛ wà puɔn aʼyaabu ni? ");
INSERT INTO gngNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","A li tien mila kí tɔke aʼtɔ kí ye: ‹Cère ń ñɛn kumuɔku kùa te aʼnunbu ni nɔ›, ŋɔ ka lɛnh jaantɛlkɛ wà puɔn aʼyaabu ni nnɔ. Sin iñuɔn ilele ya nilɔ, kpiɛ kí ñɛn jaantɛlkɛ wà puɔn aʼnunbu ni nnɔ, kí li lɛnh mɔnmɔnm, kí yaan kí fre kí ñɛn kumuɔku aʼtɔ yaabu ni.» ");
INSERT INTO gngNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","*Yesu tí tɔke' bɛ ki ye: «Busumɔnmɔnbu ŋa ń fre kí lùon ibii yà ŋa mɔn. Busubu bùa ŋa mɔn mɔ ŋa ń fre kí lùon ibii yà mɔn. ");
INSERT INTO gngNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Busubu ya bii nɛ cèreh bi bɛndeh bù yé busubu bùa ya bol. Ba pɔ̀h kɛnkɛn konkonbu bo, ka pɔ̀h cɛcɛ mɔ bɛnɛnk bo. ");
INSERT INTO gngNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Unimɔ̀n ya yɛnmaalmɔnmɔn yà te uʼfɛ̀l bo nɛ cèreh u teh nà mɔn, nɛ ubiɛrdaan ya yɛnmaalbiɛre cèreh u teh nà bre, kimɛ unil kɛ len' ki kun' nà bó la, nì ñɛn' iyɛnmaale yà te uʼfɛ̀l bo nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","«Bɛ bo nɛ ni yih nni: ‹Yonbdaan, Yonbdaan,› ka teh n tɔkeh nɛ ní li teh ma bo. ");
INSERT INTO gngNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Wà kɛ baa' nʼsaan, ki ciih nʼgbɛr, ki teh tù ye ma la, n li wuɔn nɛ u naan udaan wà. ");
INSERT INTO gngNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","U naan ujɛ wà yíe wɔ ń mɛ kuduku ŋɔ ki gbin' nì ñuɔke', ki pu' litɛnpuul kutɛntiɛku bo nɛ. Miwuɔm kɔn' ki puube' ki yile' kuduku nnɔ bo, nɛ ka fre' ki jènge' kù, kimɛ udaan nnɔ mɛn' kù mɔnmɔnm nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ama unil wà ciih nʼgbɛr, ka teh tù ye ma la, u naan ujɛ wà mɛn' kuduku utintɛle bo nɛ. Miwuɔm kɔn', ki puube' ki yile' kuʼbo, nɛ kù pɔk ki lu' kpɛlkpɛl.» ");
INSERT INTO gngNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","*Yesu tɔke' binib nnɔ tigbɛr ki gben', nɛ ki bure' Kapɛrnawum ya du bó. ");
INSERT INTO gngNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Sojambɛ kobk ya ciɛn uba là te ki ŋmɔbe utonsɔnl uba ki yíe wɔ cɛɛn. Utonsɔnl nnɔ lá bun ki benh wɔ ń kpo. ");
INSERT INTO gngNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Sojaciɛn nnɔ cii' bi lienh Yesu bó, nɛ u sɔn' Sufmbɛ ya ciɛnb uʼsaan, bɛ ń tì gbáan wɔ wɔ ń baa kí lá ŋmiɛn uʼtonsɔnl nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Biciɛnb nnɔ baa' *Yesu saan, nɛ ki tùɔreh ki gbáanh wɔ ki teh: «Sojaciɛn nnɔ kpɛ á tore wɔ nɛ, ");
INSERT INTO gngNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","kimɛ u yíe tiʼdu ya nib, nɛ wɔn nɛ mɛn' tiʼtaanl ya duku.» ");
INSERT INTO gngNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Nɛn saan nɛ Yesu paan' biʼbo ki bure', ki tì nɛke sojaciɛn nnɔ den, nɛ u sɔn' uʼjɔtieb bi tuobe' wɔ usɛn bó, ki tɔke' wɔ ki ye: «Yonbdaan, sojaciɛn nnɔ ye a la ji ń jɛ̀nde aʼba, kimɛ wa kpɛ á baa kí kɔ uʼden. ");
INSERT INTO gngNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Nɛn bo nɛ u maale' ki ye wa kpɛ wɔ ń bugbɛn ń tuobe ŋɛ usɛn bó mɔnɔn. A lì len' ki ye faake la, uʼtonsɔnl nnɔ li faake nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Kimɛ wɔn mɔnɔn ŋmɔbe binib bà yé nin wɔ biciɛnb, nɛ ki mɔ yé sojambɛ biba ya ciɛn. U tɔke' uba ki ye: ‹Li joh› la, u joh nɛ, u tɔke' utɔ ki ye: ‹Dɛn› la, u bàareh nɛ. U tí tɔke' uʼtonsɔnl ki ye: ‹Tien niɛ› la, u teh nɛn nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","*Yesu cii' uʼñɔbon nnɔ ma nnɔ, nì cuo' wɔ miyɔkm, nɛ u jiɛbe' ki liike' linigol là pɛ uʼbo nnɔ ki ye: «N tɔkeh nɛ nɛ, ma laan laa' miɛ ya tekjim ya tunbu Israyɛl yaab mɔnɔn ni.» ");
INSERT INTO gngNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Binib bà tuobe' *Yesu usɛn bó nnɔ liɛbe' sojaciɛn nnɔ den, ki laa' uʼtonsɔnl nnɔ faake'-a. ");
INSERT INTO gngNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Lidaali liba nɛ *Yesu joh udu uba bó, bi yih wù Nayinn, ki tɔke nin uʼpanpaankaab nin binib ligol. ");
INSERT INTO gngNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","U tì tuo wɔ ń kɔ udu nnɔ ni, nɛ ki laa' ukpopii uba ya bubaabk kpo' bi tuke ki joh kukaaku bó, nɛ udu nnɔ ya nib pɛ ka dindin. ");
INSERT INTO gngNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Yonbdaan laa' ukpopii nnɔ ma nnɔ, nɛ ki muɔ' wɔ micɛcɛkm, ki tɔke' wɔ ki ye: «Ji la muɔh», nɛ ");
INSERT INTO gngNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","ki cuon' ki nɛkn' ikɛliɛn, ki tɛnde' uʼnuɔ ki mɛ' yɛ̀. Binib bà tuke utɛnkpii nnɔ sere', nɛ u ye: «Unacien, n lienh sin nɛ, fii.» ");
INSERT INTO gngNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","U fii' ki kɛ̀le', ki cin' ki lienh, nɛ *Yesu taa' wɔ ki de' uʼnaa. ");
INSERT INTO gngNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Nɛn saan nɛ bujɛwaanbu cuo' biʼkɛ, nɛ bi pɛ̀keh Uwien ki teh: «Uwien ya ñɔbonsɔknciɛn uba nɛ ñɛn' tiʼni. Uwien nɛ baa' wɔ ń ŋmiɛn uʼnib.» ");
INSERT INTO gngNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Nɛ bi tɔkeh *Yesu tien' nà nnɔ Sude ya tinfɛnm kɛ ni nin itengbaan yà kɛ nɛke Sude nnɔ ni. ");
INSERT INTO gngNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","San wà siih binib Uwien ya ñunm nnɔ ya panpaankaab jon' ki tì tɔke' wɔ tigbɛr nnɔ kɛ. Nɛ u yin' biʼni bile, ");
INSERT INTO gngNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ki sɔn' bɛ Yonbdaan saan, bɛ ń tì niire wɔ kí ye wɔn nɛ yé wà li baa ní nnɔ bii bi li guure utɔ nɛ? ");
INSERT INTO gngNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","San ya panpaankaab nnɔ baa' *Yesu saan nɛ ki tɔke' wɔ ki ye: « ‹San wà siih binib Uwien ya ñunm nnɔ nɛ sɔn' tɛ aʼsaan tí lá niire ŋɛ› kí ye: ‹Sin nɛ yé wà li baa ní nnɔ bii ti li guure utɔ nɛ?› » ");
INSERT INTO gngNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","U ya yo ki laa' *Yesu cèreh biwiɛnb bà yɛbe faakreh, ki cèreh iwɔ̀b cuonh, ki ŋuɔh isɛnpol binib saan, ki likreh ijùɔn ì yɛbe; ");
INSERT INTO gngNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","nɛ ki tɔke' San ya panpaankaab nnɔ ki ye: «Liɛbe mɛn kí tì tɔke San ni laa' nà nin ni cii' nà: ijùɔn likreh, iwɔ̀b cuonh, ijend lùoreh, igbaan ciih, bitɛnkpiib mɛkreh, nɛ bijiinb ciih tigbɛmɔnmɔnt. ");
INSERT INTO gngNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Wà ŋa tùre' Uwien ya sɛn min bo la, Uwien ya mɔnm te uʼbo.» ");
INSERT INTO gngNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","San ya panpaankaab liɛbe' uyo wà nnɔ, nɛ Yesu cin' ki tɔkeh linigol San ya gbɛr ki teh: «Ni là jon' kupenpelku ni ní tì liike ba? Ni là jon' ní tì liike limuɔnl là mitafaam jèngeh lɛ̀ nɛ-ɛɛ? ");
INSERT INTO gngNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ni nín là jon' ní tì liike ba? Ni là jon' ní tì liike unil wà guo tikpɛlcɛmɔnmɔnt nɛ-ɛɛ? Binib bà guoh tikpɛlcɛmɔnmɔnt, ki te liwiel ni nnɔ kɔh bibɛrb den nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Tɔ, ni nín là jon' ní tì liike ni lɛ bonn nɛ? Ni là jon' ní tì liike Uwien ya ñɔbonsɔknl nɛ-ɛɛ? N tɔkeh nɛ imɔ̀n nɛ, u cɛn' Uwien ya ñɔbonsɔknl mɔnɔn. ");
INSERT INTO gngNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Kimɛ wɔn San bo nɛ nì kɛle' *Uwien ya gbɔnku ni ki ye: ‹Liike, n li sɔn nʼtond wɔ ń liere ŋɛ, kí lá tùɔre aʼsɛn.› ");
INSERT INTO gngNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","«N tɔkeh nɛ nɛ, ba laan maa' nil uba, u cɛn' San. Ama unil wà yé uwaal Uwien ya bɛl ni cɛn' wɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","«Udu ya nib kɛ, haali nin bilɛnpotekb kɛ cii' San ya gbɛr, ki bɛnde' ki ye Uwien yé ugbɛmɔ̀ndaan, nɛ ki cère' u sìi' bɛ Uwien ya ñunm. ");
INSERT INTO gngNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ama Farisiɛnmbɛ nin bà bɛn yiko mɔnmɔnm ŋa tuo' u sìi' bɛ Uwien ya ñunm. Nɛn nɛ wuɔn' ki ye bi yìe' Uwien yíe nà.» ");
INSERT INTO gngNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesu tí len' ki ye: «N nín li taa ba kí nɛnge fɛnfɛnnɔ ya nib-i? Bi naan ba? ");
INSERT INTO gngNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Bi naan tɛn mubumu nɛ kɛ kidaak ni ki jeleh, ki tɔkeh muʼtɔmu ki teh: ‹Ti piebe' nɛ liwol, nɛ na ŋɔn' ciɛk. Ti gɛn' ikuyuon, nɛ na muɔ'.› ");
INSERT INTO gngNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Kimɛ San wà siih binib Uwien ya ñunm baa' ki kùɔ tijier tubambɛ, ka ñuh daam, nɛ ni ye usɛnpol nɛ ŋaake wɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Unil ya Bijɛ baa', ki jinh ki ñuh, nɛ ni ye: ‹Liike mɛn ujɛ wuɔ yé ufɔnfuɔb nɛ ki yé udɛyibl, ki jɔreh nin bilɛnpotekb nin bibiɛrdɛnb.› ");
INSERT INTO gngNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ama binib bà kɛ tuo' Uwien ya yɛnfuom nɛ bɛn mì mɔn ki kpɛ ma bo.» ");
INSERT INTO gngNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Lidaali liba nɛ Farisiɛn uba yin' *Yesu wɔ ń baa kí lá ji uʼden, nɛ u jon' Farisiɛn nnɔ den, ki tì kɛ ki jinh. ");
INSERT INTO gngNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Upiisɔnsɔnd uba mɔ là te udu nnɔ ni. U cii' *Yesu te Farisien nnɔ den ki jinh, nɛ ki tuke ní lɛfina uba alabaat ya dingl ni, ");
INSERT INTO gngNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","ki baa' ki lá sere' *Yesu ya puoli bó uʼtàan saan, ki muɔh, uʼnunsiir luh *Yesu ya tàan bo, ki sèkndeh yɛ̀, nɛ u taah uʼyur ki ŋmireh yɛ̀, ki bibeh yɛ̀, ki taah lɛfina nnɔ ki faanh yɛ̀. ");
INSERT INTO gngNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Farisiɛn nnɔ laa' nnɔ ma nnɔ, nɛ ki maale' uʼyɛnm ni ki ye: «Ujɛ wuɔ bi yé *Uwien ya ñɔbonsɔknl la, u bi li bɛnde upii wà miɛkeh wɔ nɔ yé udaan wà. U bi li bɛnde kí ye u yé usɔnsɔnd nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Nɛ *Yesu tɔke' Farisiɛn nnɔ ki ye: «Simɔn, n ŋmɔbe tigbɛr tuba ń tɔke ŋɛ.» Nɛ u ye: «Len nʼcɛnbaa» ");
INSERT INTO gngNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Nɛ *Yesu ye: «Ujɛ uba nɛ kpende' binib bile ilike. U kpende' uba milikbim itur kobiiŋun, ki kpende' utɔ milikbim itur piŋun. ");
INSERT INTO gngNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Biʼkɛ bile ŋa ń fre kí pɛ̀ wɔ ma nnɔ, nɛ u cɛ̀be' bɛ biʼfɛ̀n. Bijɛb bile nnɔ ni, u lɛ li yíe ulikdaan nnɔ ki cɛn' utɔ.» ");
INSERT INTO gngNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Nɛ Simɔn jiin' wɔ ki ye: «N maale' ki ye wà ya fɛ̀nl yɛbe nnɔ nɛ li yíe wɔ ki cɛn'.» Nɛ *Yesu tɔke' wɔ ki ye: «A tɔke' bù te.» ");
INSERT INTO gngNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Nɛ ki pekre' upii nnɔ bó, ki tɔke' Simɔn ki ye: «A laa' upii wuɔ-ɔɔ? N kɔn' ní aʼden ma ŋa de' ñunm bɛ ń sɔkre nʼtàan, ama upii wuɔ wɔn, u taa' uʼnunsiir nɛ ki sèkn' yɛ̀, ki taa' uʼyur ki ŋmiŋmire' yɛ̀. ");
INSERT INTO gngNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ŋa lɔkn' nni ama n tì kɔn' ní ma wɔn ŋa dàan nʼtàan ya bibm haali nin fɛnfɛnnɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Sin ŋa taa' kpɔm mɔnɔn ki fàan' nʼyul, ama wɔn taa' lɛfina nɛ ki fàan' nʼtàan. ");
INSERT INTO gngNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Nɛn bo, n tɔkeh ŋɛ nɛ, n fère' wɔ uʼbiɛre ì yɛbe ma nnɔ, nɛ cère' u yíe nni ki gbien', kimɛ unil wà n fère' wɔ ibiɛre waamu la, udaan mɔ yíe nni waamu nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Nɛn saan nɛ u tɔke' upii nnɔ mɔ ki ye: «N fère' ŋɛ aʼbiɛre.» ");
INSERT INTO gngNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Nɛ wɔn nin binib bà jinh nnɔ maaleh biʼyɛnm ni ki teh: «Ujɛ wuɔ yé ŋmɛ nɛ, ki tì fèreh binib biʼbiɛre?» ");
INSERT INTO gngNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Nɛ *Yesu tɔke' upii nnɔ ki ye: «Aʼtekjim nɛ ŋmiɛn' ŋɛ. Li joh nin uyɛnduɔn.» ");
INSERT INTO gngNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ni ya puoli bó nɛ *Yesu joh iducɛnciɛn nin iduwawaale ni, ki kpaandeh Uwien ya bɛl ya gbɛmɔnmɔnt, nɛ uʼtondb piik nin bile nnɔ pɛ uʼbo. ");
INSERT INTO gngNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Bipiib bà u là cère' bi faake' nin u là ŋɔre' bà saan isɛnpol nnɔ mɔ pɛ uʼbo. Bɛn si: Mari wà bi yih wɔ Madelɛnn nnɔ, *Yesu là ŋɔre' isɛnpol ilole wɔn saan nɛ ");
INSERT INTO gngNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","nin Herod ya tonsɔnb ya ciɛn Kusa ya po Sann nin Susann nin bipiitɔb ligol, nɛ biʼkɛ taah biʼbont ki toreh wɔn nin uʼtondb. ");
INSERT INTO gngNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Tɔ, binib ñɛn' ní idu kɛ ni, ki baa' *Yesu saan, ki taan' ki tien' linigociɛnl, nɛ u pɔn' bɛ mikpɛnjɛnm ki ye: ");
INSERT INTO gngNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«Ukpaal uba nɛ là jon' wɔ ń tì plè tibonbuor ya bim. U plèh ma nnɔ, miba lu' usɛngbɛ, nɛ binib tɛtɛ' miʼbo, nɛ inuɔn baa' ki lá jin' mɛ̀. ");
INSERT INTO gngNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Mitɔm lu' kutɛntiɛku bo, ki pɛn'. Niʼsaan ŋa sɔnge ma nnɔ, nɛ mipiɛm nnɔ kuore'. ");
INSERT INTO gngNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Mitɔm mɔ lu' kujɛgorku ni, ki pɛn'. Nɛ mipiɛm nnɔ nin kujɛgorku kɛ kpienh, nɛ kujɛgorku wɔbn', ki ku' mɛ̀. ");
INSERT INTO gngNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Mitɔm mɔ lu' kitinmɔnmɔnk bo, ki pɛn' ki kpére', nɛ ki lùon' kokobk.» *Yesu len' ki pukn' ki ye: «Wà ŋmɔbe litubl la, wɔ ń cii.» ");
INSERT INTO gngNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","*Yesu ya panpaankaab niire' wɔ mikpɛnjɛnm nnɔ ya tingi. ");
INSERT INTO gngNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Nɛ u jiin' bɛ ki ye: «Uwien nɛ cère' ninbi bɛnde' uʼbɛl ya gbɛbɔlkaar. Ama bitɔb bɛn wɔn, nì yé mikpɛnjɛnm nɛ biʼbo ŋɔ ‹bɛ ń li likeh ka lɛnh, kí li cengeh ka ciih niʼtingi.› » ");
INSERT INTO gngNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","«Mikpɛnjɛnm nnɔ ya tingi sɔ: tibonbuor nnɔ yé Uwien ya gbɛr nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Mibim mà lu' usɛngbɛ nnɔ yé binib bà ciih Uwien ya gbɛr, usɛnpol bàareh ki lá ñɛndeh tù biʼfɛ̀l ni ŋɔ bi la teke Uwien kí ji kí ŋmɛre nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Mibim mà lu' kutɛntiɛku bo nnɔ mɔ yé binib bà ciih Uwien ya gbɛr, ki teknh tù nin uyɛnsɔnge, ama ka cèreh tù kpaakeh ñaan biʼfɛ̀l ni nɛ. Bi teke' Uwien ki jin' nì wuɔke' waamu, mibiikm tu' bɛ la, bi pɔk kí wiɛ Uwien ya sɛn nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Mibim mà lu' kujɛgorku ni nnɔ mɔ yé binib bà ciih Uwien ya gbɛr nɛ ki cèreh uŋɛndun ya gbɛr nin lifaal ya yɛnmaale nin uŋɛndun ya ŋmaa wɔbndeh tigbɛr nnɔ ki cèreh ta fɔreh mɔnmɔnm biʼfɛ̀l ni nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Mibim mà lu' kitinmɔnmɔnk bo nnɔ mɔ yé binib bà ya fɛ̀l bo mɔn, bi ŋmɔbe tigbɛmɔ̀nt, ki cengeh tigbɛr nnɔ, ki taah tù ki blinh biʼfɛ̀l bo, ki ñikndeh ki cèreh tù sɔnh itùon nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","*Yesu tí ye: «Uba ŋa ń sɛ frl kí taa lisɛnl kí cubn liʼbo bii kí taa lɛ̀ kí sien gado ya tingi. Ama u li taa lɛ̀ kí tuɔn likpɛnkpɛnl bo nɛ ŋɔ bà kɛ kɔh ní iden ni ń li lɛnh. ");
INSERT INTO gngNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Kimɛ bonn ŋa te ki buɔ ŋɔ ba lá li lɛ nɛ̀, gbɛr mɔ ŋa te ki buɔ ŋɔ ka lá li ñɛ upaan bo. ");
INSERT INTO gngNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Nɛn bo, liike mɛn niʼyul bo nin ni cengeh nʼgbɛr ma bo, kimɛ wà ŋmɔbe la, bi li de wɔ kí pukn, wà ŋa ŋmɔbe la, bi li tonde kí fie u maaleh ki teh u ŋmɔbe nà waamu nnɔ mɔnɔn nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","*Yesu ya naa nin uʼninjiɛb baa' ki nuunh wɔ. Linigol te ma nnɔ nɛ ba fre' ki kɔn' ki laa' wɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Nɛ bi tɔke' wɔ ki ye: «Aʼnaa nin aʼninjiɛb te saali ki yíe bɛ ń lɛ ŋɛ.» ");
INSERT INTO gngNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Nɛ u tɔke' bɛ ki ye: «Nʼnaa nin nʼninjiɛb si binib bà kɛ ciih Uwien ya gbɛr ki teh tù ye ma bo nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Lidaali liba nɛ *Yesu nin uʼpanpaankaab kɔn' buñɛrbu, nɛ u tɔke' bɛ ki ye: «Cère mɛn tí puore kí jo miñunciɛnm ya gbaatɔl bó.» Nɛ bi bure'. ");
INSERT INTO gngNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Bi te miñunm bo ki joh ma nnɔ nɛ *Yesu duɔn' ki gɔh. Kutafaabiiku kuba pɔk ki fii' miñunm bo, ki cèreh miñunm fih ki kɔh buñɛrbu nnɔ ni ki gbiekeh. Nì là yé kinunbɔnk nɛ biʼbo. ");
INSERT INTO gngNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Nɛ bi baa' ki lá fìnde' *Yesu ki tɔke' wɔ ki ye: «Cɛnbaa, Cɛnbaa, ti benh tí luo nɛ.» *Yesu fìnde', ki tiɛn' kutafaaku nin iñungbegbel nnɔ bo. Kutafaaku go, iñungbegbel nnɔ lu' nɛ niʼkɛ ŋmile'. ");
INSERT INTO gngNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Nɛ u niire' uʼpanpaankaab ki ye: «Ń lɛ niʼtekjim-i?» *Yesu tien' nà nnɔ cuo' bɛ miyɔkm, ki cuo' bɛ bujɛwaanbu, nɛ bi niireh tɔb ki teh: «U cinbe ki yé bɛ ya nitunbu sɔ nɔ? U tɛngeh kutafaaku nin miñunm mɔnɔn bo, nɛ niʼkɛ boh wɔ.» ");
INSERT INTO gngNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Bi tì baa' Gerasa yaab ya tinfɛnm ni. Mitinfɛnm nnɔ kuo Galile ya ñunciɛnm nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","*Yesu ñɛh buñɛrbu ni uyo wà nnɔ, nɛ mitinfɛnm nnɔ ya jɛ uba cende' wɔ. Isɛnpol nɛ là ŋaake wɔ. U cuonh upuntenge nì wuɔke', ka ji te den, ki kɔ bi subeh bitɛnkpiib tijɔlulnt tà ni nnɔ ni. ");
INSERT INTO gngNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ujɛ nnɔ laa' *Yesu ma nnɔ nɛ ki gbaan' uʼnintuɔli, nɛ isɛnpol nnɔ cère' u wuure' ufaa bo ki ye: «Yesu, Uwien wà ŋa ŋmɔbe Nacentɔ ya Bijɛ, min nin sin tu lɛ nɛ? N gbáanh ŋɛ nɛ, la jɛ̀nde nni.» ");
INSERT INTO gngNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Yesu tɔke' usɛnpol nnɔ kí ye wɔ ń siere kí dàan ujɛ nnɔ ma nnɔ nɛ cère' u len' nnɔ. Usɛnpol nnɔ cuo' ujɛ bugbɛn nì wuɔke'. Bi là kuɔndeh wɔ mugbiɛmu, ki lùoh wɔ tikudɔkr, u la jo niba saan nɛ, ama u cienh tikudɔkr nnɔ nɛ ki kɔ̀h mugbiɛmu nnɔ. Usɛnpol nnɔ tukeh wɔ ki joh nib ŋa te nà saan nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","*Yesu niire' wɔ ki ye: «Bi yih ŋɛ ba?» Nɛ u ye: «Bi yih nni Ligol nɛ.» Isɛnpol ŋaake wɔ ki yɛbe ma nnɔ nɛ cère' u ye nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Nɛ isɛnpol nnɔ gbáan' *Yesu ki ye u la wɔbn yɛ̀, yɛ̀ ń jo kubùoku kùa ñɔ ka ŋmɔbe biɛn nnɔ ni. ");
INSERT INTO gngNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Tɔ, fangambɛ biba mɔ là te ligbɛngbɛnl bo ki yɛbe ka dindin, bi kpaah bɛ. Isɛnpol nnɔ gbáan' *Yesu ki ye wɔ ń cɛ̀be yɛ̀, yɛ̀ ń jo kí tì kɔ fangambɛ nnɔ. U tuo', ");
INSERT INTO gngNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","nɛ ì dàan' ujɛ nnɔ, ki jon' ki tì kɔn' fangambɛ nnɔ. Nɛ fangambɛ nnɔ kɛ sɛn' ki tinde' ligbɛngbɛnl nnɔ, ki tì lu' miñunm ni ki luo'. ");
INSERT INTO gngNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Bà kpaah fangambɛ nnɔ laa' nà tien', nɛ ki sɛn' ki jon' udu ni nin idugbaan, ki tì tɔke' binib tigbɛr nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Nɛ bi ñɛn' ki joh bɛ ń tì liike nà tien'. Bi tì baa', ki laa' ujɛ wà isɛnpol dàan' wɔ nnɔ ya yɛnm jire' u kɛ *Yesu saan, ki guo, nɛ bujɛwaanbu cuo' bɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Binib bà là te niʼsaan ki laa' tibont nnɔ kɛ tentien' ma bo nnɔ tɔke' bɛ *Yesu cère' ujɛ nnɔ faake' ma bo. ");
INSERT INTO gngNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Nɛ bujɛwaanbu cuo' Gerasa ya tinfɛnm yaab kɛ cɛɛn. Nɛn nɛ cère' bi tɔke' *Yesu ki ye wɔ ń jɛnde biʼsaan. *Yesu liɛbe' ki kɔn' buñɛrbu, wɔ ń bure, ");
INSERT INTO gngNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","nɛ ujɛ wà isɛnpol dàan' wɔ nnɔ gbáanh wɔ ki teh wɔ ń cère wɔ ń paan uʼbo, nɛ *Yesu ŋa tuo', ki tɔke' wɔ ki ye: ");
INSERT INTO gngNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","«Liɛbe kí kun kí tì tɔke binib Uwien tien' nà kɛ ki de' ŋɛ.» Nɛ u bure', ki cuonh udu ni niʼkɛ saan, ki tɔkeh binib *Yesu tien' nà kɛ ki de' wɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","*Yesu liɛbe' ki baa' miñunciɛnm ya gbaatɔl, nɛ linigol teke' wɔ, kimɛ biʼkɛ là gu wɔ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Nɛ *Sufmbɛ ya taanl ya duku ya ciɛn uba, bi yih wɔ Yayirus, baa' ki lá gbaan' *Yesu ya nintuɔli, ki gbáan' wɔ ki ye wɔ ń dɛn uʼden, ");
INSERT INTO gngNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","kimɛ uʼbubaabk nɛ bun, ki benh kɛ̀ ń kpo; kì ŋmɔbe ibin piik nin ile nɛ. Nɛ *Yesu paan' uʼbo ki bure'. U joh ma nnɔ nɛ linigol pɛ uʼbo ki pɛbeh wɔ, wa ji tì freh ki fuoreh. ");
INSERT INTO gngNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Upii uba mɔ te niʼsaan, ki laa' tifɛr ibin piik nin ile ta gben'. U jon' dɔktiɛmbɛ saan, ki ñɛnde' uʼlike kí tì gben'. Uba ŋa fre' ki buu' wɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","U baa' *Yesu ya puoli bó, ki lá mɛ' uʼwɛngolkaar ya ñɔgbɛn, nɛ uʼfɛr nnɔ pɔk ki gben' i ya tàan bo. ");
INSERT INTO gngNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Nɛ *Yesu niire' ki ye: «Ŋmɛ mɛ' nni?» Biʼkɛ niɛ' ki ye ba mɛ' wɔ ma nnɔ nɛ Piɛr tɔke' wɔ ki ye: «Cɛnbaa, linigol là guɔn' ŋɛ nɔ nɛ pɛbeh ŋɛ.» ");
INSERT INTO gngNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Nɛ *Yesu ye: «Unil uba mɛ' nni, kimɛ n laa' mituɔm miba ñɛn' nni.» ");
INSERT INTO gngNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Upii nnɔ laa' wa ń fre kí bɔle, bujɛwaanbu cuo' wɔ, uʼgbɛnɛnt ŋɔh, nɛ u baa' ki lá gbaan' *Yesu ya nintuɔli, ki tɔke' wɔ binib kɛ ya nun bó, nà cère' u mɛ' wɔ nin u faake' i ya tàan bo ma bo. ");
INSERT INTO gngNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Nɛ *Yesu tɔke' wɔ ki ye: «Nʼbisɛ, aʼtekjim nɛ ŋmiɛn' ŋɛ. Li joh nin uyɛnduɔn.» ");
INSERT INTO gngNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","*Yesu laan te ki lienh nɛ unil uba ñɛn' Yayirus donbó ki lá tuobe' bɛ usɛn ni, ki tɔke' Yayirus ki ye: «Aʼbisɛ kpo'-a! La ji ń li ŋmɔbe Cɛnbaa yɛnŋaabe.» ");
INSERT INTO gngNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","*Yesu cii' bi len' ma bo, nin nɛn kɛ ŋɔ u tɔke' Yayirus ki ye: «La fɛnge, teke nni kí ji baba, u li ŋmɛre.» ");
INSERT INTO gngNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","*Yesu tì baa' Yayirus den, nɛ ka cère' binib kɛ paan' uʼbo ki kɔn'. U cère' Piɛr nin San nin Saak nin kibupiik nnɔ ya naa nin kiʼbaa baba nɛ paan' uʼbo ki kɔn'. ");
INSERT INTO gngNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Binib bà kɛ te niʼsaan nnɔ muɔh kiʼkuum bo nɛ ki kpìɛndeh. Nɛ *Yesu tɔke' bɛ ki ye: «La ji muɔh mɛn, ka kpo', kì gɔh nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Nɛ bi lɛh Yesu, kimɛ bi bɛn ki ye kibuk nnɔ kpo'-a! ");
INSERT INTO gngNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","*Yesu cuo' kiʼnuɔ, ki tɔke' kɛ̀ ki ye: «Nʼbukɛ, fii.» ");
INSERT INTO gngNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Nɛ kiʼnaank liɛbe' ní i ya tàan bo, kì fii' nɛ *Yesu ye bɛ ń de kɛ̀ tijier kɛ̀ ń ji. ");
INSERT INTO gngNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Nì cuo' kiʼnaa nin kiʼbaa miyɔkm, nɛ *Yesu kpɛkpɛ' biʼbo ki ye bi la tɔke nil nà tien' nɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","*Yesu taan' uʼtondb piik nin bile, ki de' bɛ mituɔm nin usɛn bɛ ń li ŋuɔh isɛnpol kɛ ya bol binib saan, kí li buuh iwìɛn. ");
INSERT INTO gngNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","U sɔn' bɛ, bɛ ń li tɔkeh binib Uwien ya bɛl ya gbɛr, kí li buuh biwiɛnb, ");
INSERT INTO gngNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","nɛ ki tɔke' bɛ ki ye: «Ni joh la, ni la tuke bonn. Ni la tuke gbien, ki la tuke kɔl, ki la tuke jier, ki la tuke like, ki la tuke liɛr ile mɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ni tì baa' iden yà kɛ bi teke' nɛ la, ni li te nɛn saan kí tì baa lidaali là ni li siere udu nnɔ ni. ");
INSERT INTO gngNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Udu wà ya nib ŋa teke' nɛ la, ní kpakpaare niʼtàan ya tɛngunku kí wiɛ nɛ̀, kí siere. Nɛn nɛ li yé niʼsaan ya nib bo kudìɛku.» ");
INSERT INTO gngNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Tɔ, bi bure', nɛ ki joh idu ni, ki tɔkeh binib tigbɛmɔnmɔnt, ki cèreh biwiɛnb faakreh niʼkɛ saan. ");
INSERT INTO gngNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Gobina Herod cii' bi lienh *Yesu teh tibont tà kɛ nnɔ bó, nɛ ka bɛn u li maale kí ye bà. Kimɛ biba lienh ki teh: «San wà là siih binib Uwien ya ñunm nnɔ nɛ mɛkre',» ");
INSERT INTO gngNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","bitɔb lienh ki teh: «Eli nɛ liɛbe' ní», bitɔb mɔ lienh ki teh: «Uwien ya ñɔbonsɔknb bà là te uyo bo nnɔ ya uba nɛ mɛkre' ki liɛbe' ní.» ");
INSERT INTO gngNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Nɛ Herod ye: «Min bugbɛn nɛ là cère' bi tùkre' San ya yul-a! N cii' bi lienh wà mɔ bó nɔ, uʼmɔ yé ŋmɛ nɛ?» Nɛ ki nuunh wɔ ń lɛ Yesu. ");
INSERT INTO gngNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","*Yesu ya tondb liɛbe' ní, ki lá tɔke' wɔ bi tien' nà kɛ, nɛ u taa' bɛ ki jɛnde' bi tì te biʼbaba Bɛtsayida ya du bó ya kɛle. ");
INSERT INTO gngNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Inigol nnɔ cii' u bure' ma nnɔ nɛ ki paan' uʼbo. *Yesu teke' bɛ, ki tɔkeh bɛ Uwien ya bɛl ya gbɛr, nɛ ki buuh biʼni bà yé biwiɛnb. ");
INSERT INTO gngNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Uwien benh wù ń lu, nɛ uʼtondb piik nin bile nnɔ nɛkn' wɔ ki tɔke' wɔ ki ye: «Ti te ñiɛn ŋa te nà saan nɛ, cère linigol liɛ ń jo idu bó, kí tì nuun tijier nin gɔgɔbùol.» ");
INSERT INTO gngNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Nɛ *Yesu ye: «Ninbi bugbɛn, de bɛ mɛn bɛ ń ji.» Nɛ bi ye: «Ti ŋmɔbe kpɔnɔ uŋun nin ijɛn ile baba nɛ, tiʼbugbɛn nɛ ŋa nín jon' ki tì dɛ' tijier ki lá de' biɛ ya nib kɛ ŋa ñí la.» ");
INSERT INTO gngNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Bijɛb là li baa tɛn itur iŋun. Nɛ *Yesu tɔke' uʼpanpaankaab ki ye: «Cère mɛn linigol nnɔ ń kɛ̀le tingi ni, icɛk icɛk binib piŋunŋun.» ");
INSERT INTO gngNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Nɛ bi cère' biʼkɛ kɛ̀le' nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Nɛ *Yesu yuure' kpɔnɔ uŋun nin ijɛn ile nnɔ, ki yaare' ki liike' paaki, ki faare' Uwien tuʼbo, ki kɔkuɔ', ki taa' ki de' uʼpanpaankaab bɛ ń gbiire linigol nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Biʼkɛ ŋmɔn' ki gbo', nɛ bi tantaan' tijenjent tà sìen' nnɔ, ki gbien' ikpɛncub piik nin ile. ");
INSERT INTO gngNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Lidaali liba nɛ *Yesu jɛnde' ki tì kàareh, nɛ uʼpanpaankaab te uʼsaan. U niire' bɛ ki ye: «Inigol lienh ki teh n yé ŋmɛ nɛ?» ");
INSERT INTO gngNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Nɛ bi jiin' wɔ ki ye: «Biba lienh ki teh a yé San wà siih binib Uwien ya ñunm nnɔ nɛ, bitɔb lienh ki teh a yé Eli nɛ, bitɔb mɔ lienh ki teh Uwien ya ñɔbonsɔnknb bà là te uyo bo nnɔ ya uba nɛ mɛkre' ki liɛbe' ní.» ");
INSERT INTO gngNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Nɛ u niire' bɛ ki ye: «Ninbi nín teh n yé ŋmɛ nɛ?» Nɛ Piɛr jiin' wɔ ki ye: «A yé Uwien ya Nigɛndkɛ Kristo nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Nɛ *Yesu tùɔre' ki kpɛkpɛ' biʼbo ki ye bi la tɔke tù nil. ");
INSERT INTO gngNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Yesu tɔke' bɛ ki ye: «Nì kpɛ Unil ya Bijɛ ń ji ijɛnd kí gbien nɛ. *Sufmbɛ ya ciɛnb nin bitɔtuɔrciɛnb nin *Yiko ya wɔnwɔknb li wiɛ uʼgbɛr, kí ku wɔ, nɛ wienta daali wɔ ń mɛkre bitɛnkpiib ni.» ");
INSERT INTO gngNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Nɛ ki tɔke' biʼkɛ ki ye: «Unil yíe wɔ ń paan nʼbo la, u la tɔnge uʼba. Wɔ ń li yuunh uʼdɔpɔnpɔn daan kɛ daan ki bukeh ki paakeh nʼbo. ");
INSERT INTO gngNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Kimɛ wà kɛ yíe wɔ ń fie uʼmiɛl la, wɔn nɛ li kpo kí juore fɛnm. Ama wà kɛ li tuo kí kpo min bo nnɔ, wɔn nɛ li ŋmɛre. ");
INSERT INTO gngNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Unil laa' uŋɛndun wuu ni ya bont kɛ ŋɔ ki tì luo' limiɛl la, u laa' bɛ ya kpɛle? ");
INSERT INTO gngNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Unil ye min nin nʼgbɛr ŋmɔbe wɔ ifɛ la, uyo wà Unil ya Bijɛ lá li baa ní kí li ŋmɔbe wɔn nin uʼBaa nin uʼtondb ya kpiɛke nnɔ, udaan mɔ li ŋmɔbe wɔ ifɛ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","N tɔkeh nɛ imɔ̀n nɛ, ninbi bà se niɛ saan nɔ ya biba li lɛ Uwien ya bɛl nɛ kí yaan kí kpo.» ");
INSERT INTO gngNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","*Yesu len' ki gben' ma nnɔ, iwien iniin gɛ̀bre', nɛ u taa' Piɛr nin San nin Saak, ki don' lijuɔl liba bo wɔ ń tì kàare. ");
INSERT INTO gngNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","U tì te ki kàareh ma nnɔ nɛ uʼnun bó lèbre', uʼwɛngolkaar pende' kponkpon, ki dɔnbeh inun bó. ");
INSERT INTO gngNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Nɛ bi laa' bijɛ bile uʼsaan bi tɔkeh tigbɛr. Moyis nin Eli nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Biʼmɔ windeh tein. Bi tɔkeh wɔ u li kpo Yerusalɛm ni ma bo ya gbɛr nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","U ya yo ki laa' migùɔnm ñɔ̀nde' Piɛr nin u ya tɔb, nɛ bi dɔ ki gɔh. Bi fìnde', nɛ ki laa' *Yesu windeh ki dɔnbeh inun bó, ki laa' bijɛb bile nnɔ mɔ se uʼsaan. ");
INSERT INTO gngNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Uyo wà, bijɛb nnɔ ye bɛ ń siere *Yesu saan nnɔ, nɛ Piɛr tɔke' wɔ ki ye: «Cɛnbaa, ti te niɛ saan ma nɔ nì mɔn nɛ. Cère tí pɔ ininbon ita, sin liba, Moyis liba, Eli mɔ liba.» Piɛr len' nnɔ, kimɛ wa bɛn u li len kí ye bà nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","U lienh nnɔ uʼñɔbu ŋa laan lu', nɛ kutɛwɔlgbɔnku kuba baa' ki lá pibn' biʼbo. Kù pibndeh biʼbo uyo wà nnɔ nɛ bujɛwaanbu cuo' Piɛr nin uʼtɔb nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","U ya yo nɛ bi cii' uniɛke uba bó kutɛwɔlgbɔnku nnɔ ni u ye: «NʼBijɛ sɔ nɔ, n gɛ̀nde' wɔn nɛ. Li cengeh mɛn uʼbó.» ");
INSERT INTO gngNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Uniɛke nnɔ tì ŋmile' uyo wà nnɔ, bi laa' *Yesu baba nɛ ji se. Nɛ bi bɔle' tigbɛr nnɔ biʼba ya bùol, ka tuo' ki tɔke' nil bi laa' nà nnɔ u ya yo. ");
INSERT INTO gngNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Kutaaku faa', nɛ bi jiire' ní lijuɔl nnɔ bo. Nɛ linigociɛnl tuobe' *Yesu usɛn bó. ");
INSERT INTO gngNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Linigol nnɔ ni ujɛ uba wuure' ki ye: «Cɛnbaa, n gbáanh ŋɛ nɛ, muɔ nʼbijɛ, kimɛ u yé nʼbubaabk nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Usɛnpol uba nɛ sɔbe ki coh kɛ̀, ki cèreh kì ciikeh ki wuureh, kiʼgbɛnɛnt tɛreh, kuñinsɛnjujuku ñɛh kiʼñɔbu bó. Usɛnpol nnɔ bungreh kɛ̀ ki gbiekeh, nɛ ka wiɛnh kɛ̀ tonm. ");
INSERT INTO gngNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","N gbáan' aʼpanpaankaab bɛ ń ŋɔre usɛnpol nnɔ kiʼsaan, nɛ ba fre'.» ");
INSERT INTO gngNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Nɛ *Yesu ye: «Ninbi fɛnfɛnnɔ ya nibɛ, na teke' Uwien ki jin', ki yé binib bà bre. N li wuɔke niʼsaan kí tì kpaan mila nɛ? N li ŋmɔbe sukle niʼbo kí tì kpaan mila nɛ? Nɛ ki tɔke' ujɛ nnɔ ki ye: ‹Taa aʼbijɛ ní.› » ");
INSERT INTO gngNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Kibuk nnɔ we ní uyo wà nnɔ nɛ usɛnpol nnɔ tí gbɔ̀be' kɛ̀ tingi ni, ki cère' ki tɛreh. Nɛ *Yesu tiɛn' usɛnpol nnɔ bo, ki buu' kibuk nnɔ, ki taa' kɛ̀ ki de' kiʼbaa. ");
INSERT INTO gngNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Nì cuo' linigol nnɔ kɛ miyɔkm nɛ bi lienh ki teh: «Uwien ŋmɔbe mituɔm.» *Yesu teh nà nnɔ bɛke' linigol nnɔ kɛ, nɛ u tɔke' uʼpanpaankaab ki ye: ");
INSERT INTO gngNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«Tùɔre kí cenge mɛn n ye ń tɔke nɛ nà nɔ. Nà ń taande bi li taa Unil ya Bijɛ kí ŋukn binib.» ");
INSERT INTO gngNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Nɛ ba cii' niʼtingi. Uwien nɛ bɔle' nɛ̀ ŋɔ bi la bɛnde. Nɛ ba kaabe' bɛ ń niire *Yesu niʼtingi mɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","*Yesu ya panpaankaab cin' ki niɛh nin tɔb bɛ ń bɛnde wà yé biʼkɛ ya ciɛn nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","*Yesu bɛn biʼyɛnmaale, nɛ ki taa' kibuk kiba ki sien' uʼba saan, ");
INSERT INTO gngNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ki tɔke' bɛ ki ye: «Wà kɛ teke' kibuk tɛn kiɛ nʼyel bo la, u teke' min nɛ. Wà kɛ teke' nni la, u teke' wà sɔn' nni ní nnɔ nɛ. Imɔ̀n, wà yé uwaal niʼni la, wɔn nɛ yé niʼkɛ ya ciɛn.» ");
INSERT INTO gngNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Nɛn saan nɛ San tɔke' wɔ ki ye: «Cɛnbaa, ti laa' unil uba u ŋuɔh isɛnpol binib saan aʼyel bo. Wa pɛ aʼbo tɛn tinbi ma nnɔ nɛ ti pien' wɔ.» ");
INSERT INTO gngNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Nɛ *Yesu tɔke' wɔ ki ye: «La ji ń pien wɔ mɛn, kimɛ wà ŋa nɛn nɛ la, u se niʼciɛk bó nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Uyo wà *Yesu li liɛbe kí dùo paaki bó nnɔ nɛkn' ní. Nɛ u caan' ki ye u li jo Yerusalɛm nɛ, pèrm ŋa te len, ");
INSERT INTO gngNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","nɛ ki sɔn' uʼtondb bɛ ń liere usɛn. Bi bure' ki tì baa' Samari ya du uba ni, bɛ ń bonde kí li gu wɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ama udu nnɔ ya nib ŋa teke' wɔ, kimɛ u joh Yerusalɛm bó nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Uʼpanpaankaab Saak nin San laa' nnɔ ma nnɔ nɛ ki tɔke' wɔ ki ye: «Yonbdaan, a yíe tí cère umu ń jiire ní kí lá wi bɛ-ɛɛ?» ");
INSERT INTO gngNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Nɛ *Yesu jiɛbe' ki liike' Saak nin San, ki kɔn' nin bɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Nɛ wɔn nin uʼpanpaankaab siere' niʼsaan, ki bure' udutɔ bó. ");
INSERT INTO gngNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Bi joh ma nnɔ nɛ ujɛ uba tɔke' *Yesu ki ye: «A joh nà bó kɛ la, n li pɛ aʼbo nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Nɛ *Yesu tɔke' wɔ ki ye: «Iŋɛk ŋmɔbe ifɛle, inuɔn mɔ ŋmɔbe titer, ama Unil ya Bijɛ wɔn ŋa ŋmɔbe u li kpɔ̀kn nà saan yul.» ");
INSERT INTO gngNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","U tí tɔke' utɔ mɔ ki ye: «Paan nʼbo ní.» Nɛ u ye: «Yonbdaan, cɛ̀be nni ń jo kí tì sube nʼbaa ŋɔ kí liɛbe ní kí paan aʼbo.» ");
INSERT INTO gngNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Nɛ *Yesu tɔke' wɔ ki ye: «Cère bitɛnkpiib ń li subeh biʼtɔb. Sin wɔn li joh kí tì li tɔkeh binib Uwien ya bɛl ya gbɛr.» ");
INSERT INTO gngNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Nɛ utɔ mɔ tí tɔke' *Yesu ki ye: «Yonbdaan, n li paan aʼbo, ama cère ń kun kí tì cɛ̀be nʼden yaab ŋɔ.» ");
INSERT INTO gngNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Nɛ *Yesu tɔke' uʼmɔ ki ye: «Wà kɛ ŋa teke' Uwien ya tuonl tinɔjɛr tule la, wa kpɛ wɔ ń sɔn Uwien ya bɛl ni ya tuonl.» ");
INSERT INTO gngNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ni ya puoli bó nɛ Yonbdaan *Yesu liɛbe' ki gɛ̀nde' binib pilole nin bile, ki sɔn' bɛ, bilele bɛ ń liere kí jo wɔn bugbɛn li jo idu yà kɛ ni nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Nɛ ki tɔke' bɛ ki ye: «Tijier ben' ki yɛbe, ama bà li taan tù ŋa yɛbe. Nɛn bo gbáan mɛn ukpɛdaan wɔ ń sɔn bitonsɔnb bɛ ń tì taan uʼjier. ");
INSERT INTO gngNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Li joh mɛn. N sɔnh nɛ ma nɔ, ni li te tɛn mupebumu nɛ te ikɛ̀r ya siik ni. ");
INSERT INTO gngNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ni la tuke likbu, ki la tuke kɔl, ki la taa tacaan, ki la fuonde nil sɛn ni. ");
INSERT INTO gngNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ni kɔn' iden yà la, ní kpiɛ kí fuonde iden nnɔ ya nib kí ye: ‹Li te mɛn uyɛnduɔn ni.› ");
INSERT INTO gngNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Unil te niʼsaan ki nuunh uyɛnduɔn la, u li lɛ niʼyɛnduɔn nnɔ. Nnɔ ŋa ñí la, niʼyɛnduɔn nnɔ li juore niʼyu nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ní li te i ya den, ki la lèbre dentɔ, kí li jinh ki ñuh bi dienh nɛ nà, kimɛ utonsɔnl kɛ kpɛ bɛ ń li pɛ̀h wɔ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ni kɔn' udu wà ni, bi teke' nɛ la, ní li jinh bi li de nɛ nà, ");
INSERT INTO gngNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","kí li buuh biwiɛnb bà te niʼsaan, kí li tɔkeh bɛ ki teh Uwien ya bɛl nɛkn' bɛ ŋɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ama ni kɔn' udu wà ni, ba teke' nɛ la, jo mɛn binib taakeh nà saan kí tì tɔke bɛ kí ye: ");
INSERT INTO gngNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‹Niʼdu wuu ya tɛngunku kùa mɔnɔn tɛbn' tiʼtàan bo nɔ, ti pipre' kun nɛ kí wiɛ niʼbo. Ama ní nín li bɛn kí ye Uwien ya bɛl nɛkn' nɛ ŋɔ.› ");
INSERT INTO gngNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","*Yesu tí tɔke' bɛ ki ye: ‹N tɔkeh nɛ nɛ, lidaali là Uwien li bu binib tibuur nnɔ, binib nnɔ ya tudɛre li cɛn Sodɔm yaab yu.› » ");
INSERT INTO gngNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","*Yesu tí len' ki ye: «Korasinn yaabɛ, nì bre niʼbo. Bɛtsayida yaabɛ, nì bre niʼmɔ bo. Kimɛ ni laa' miyɔkm ya bont tà niʼbùol nɔ, Tir nin Sidɔn yaab mɔ bi là laa' tù la, bi bi tien' tɛn bi kɛ mikuum nɛ, kí pùnpùkn mifɛntɛm ŋɔ kí wuɔn kí ye bi lèbre' biʼtetem nì wuɔke'. ");
INSERT INTO gngNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Lidaali là Uwien li bu binib tibuur nnɔ, ni ya tudɛre li cɛn Tir nin Sidɔn yaab yu. ");
INSERT INTO gngNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ninbi Kapɛrnawum yaabɛ, ni maaleh ki teh Uwien li duon nɛ paaki nɛ-ɛɛ? U li jiin nɛ kutɛnkpiiku ni nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","*Yesu tɔke' uʼpanpaankaab ki ye: «Wà cengeh niʼgbɛr la, u cengeh nʼyaar nɛ. Wà nɛn nɛ la, u nɛn min nɛ. Wà nɛn nni la, u nɛn wà sɔn' nni ní nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","*Yesu ya panpaankaab pilole nin bile nnɔ liɛbe' ní nin uyɛnsɔnge, ki tɔke' wɔ ki ye: «Yonbdaan, isɛnpol mɔnɔn tuonh tiʼñɔbu bó nɛ aʼyel bo.» ");
INSERT INTO gngNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Nɛ u tɔke' bɛ ki ye: «N laa' *Satan cere' kutaaku bo tɛn utɛmɛknde ki lá lu'. ");
INSERT INTO gngNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Liike mɛn, n de' nɛ mituɔm ní li taanh iwɛ nin inɛn bo, kí li ŋmɔbe mituɔm ki cɛn' unɛnnɛnd ya tuɔm kɛ. Bonn ŋa ń tien nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","La li poknh mɛn isɛnpol tuo' niʼñɔbu bó ma nnɔ bo, ama li poknh mɛn Uwien kɛle' niʼyel paaki bó ma nnɔ bo.» ");
INSERT INTO gngNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","U ya yo nɛ *Mifuoñaanm cère' *Yesu ya yɛnm sɔnge cɛɛn nɛ u len' ki ye: «Baa, sin kutaaku nin kitink ya Yonbdaan, a bɔle' tibont tà biyɛnfodɛnb nin bibɛnbɛnb nnɔ, a taa' tù ki wuɔn' biwaab nɛ. Nɛn bo nɛ n pɛ̀keh ŋɛ. Imɔ̀n, Baa, a yíe nɛ ki tien' nnɔ.» ");
INSERT INTO gngNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","*Yesu tí len' ki ye: «NʼBaa nɛ taa' tibont kɛ ki ŋukn' nni. NʼBaa ŋa ñí la, uba ŋa bɛn min uʼBijɛ yé udaan wà. Min uʼBijɛ ŋa ñí la, uba mɔ ŋa bɛn nʼBaa yé udaan wà. Binib bà n yíe' ki taa' nʼBaa ki wuɔn' bɛ nnɔ mɔ bɛn u yé udaan wà.» ");
INSERT INTO gngNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Nɛ ki jiɛbe' ki liike' uʼpanpaankaab, ki tɔke' bɛn baba ki ye: «Niʼnunbu laa' nà nɔ, Uwien ya mɔnm te niʼbo. ");
INSERT INTO gngNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","N tɔkeh nɛ nɛ, *Uwien ya ñɔbonsɔknb nin bibɛrb ligol là yíe bɛ ń lɛ ni lɛnh nà nɔ, nɛ ka laa' nɛ̀. Bi là yíe bɛ ń cii ni ciih nà nɔ, nɛ ka cii' nɛ̀.» ");
INSERT INTO gngNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Nɛn saan nɛ bà bɛn *yiko mɔnmɔnm nnɔ ya uba fii' ki sere' ki nuunh wɔ ń biike *Yesu nɛ ki niire' wɔ ki ye: «Uwɔnwɔknlɔ, n li tien mila kí lɛ limiɛl là ŋa ŋmɔbe gbenm-i?» ");
INSERT INTO gngNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Nɛ *Yesu niire' wɔ ki ye: «Bɛ kɛle' *Yiko ya gbɔnku ni? A kàanh bɛ len-i?» ");
INSERT INTO gngNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Nɛ u jiin' wɔ ki ye: «Li yíe aʼYonbdaan Uwien nin aʼfɛ̀l kɛ nin aʼtetem kɛ nin aʼtuɔm kɛ nin aʼyɛnmaale kɛ, kí li yíe aʼtɔ mɔ tɛn a yíe aʼba ma bo.» ");
INSERT INTO gngNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Nɛ *Yesu tɔke' wɔ ki ye: «A jiin' mɔnmɔnm. Li teh nnɔ kí lɛ limiɛl là ŋa ŋmɔbe gbenm.» ");
INSERT INTO gngNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ama u yíe wɔ ń wuɔn kí ye u cuube ma nnɔ, nɛ ki tí niire' *Yesu ki ye: «Ŋmɛ nɛ nín yé nʼtɔ?» ");
INSERT INTO gngNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Nɛ *Yesu tɔke' wɔ ki ye: «Ujɛ uba nɛ là ñɛn' Yerusalɛm ki joh Seriko bó, ki tì lu' idukond ya nuɔ ni. Idukond nnɔ fie' uʼwɛnt kɛ, ki ñi' wɔ u tì benh wɔ ń kpo, nɛ ì siere' ki dàan' wɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Nibonn yaam, utɔtuɔrkɛ uba mɔ kpe u ya sɛn ki lá lɛke' uʼbo, nɛ ki lɔke' ki gɛ̀bre'. ");
INSERT INTO gngNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Nì te pupuki, nɛ Lefi ya bol ya nil uba mɔ kpe u ya sɛn ki mɔ lá lɛke' uʼbo, nɛ ki mɔ lɔke' ki gɛ̀bre'. ");
INSERT INTO gngNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ama Samari ya nil uba mɔ là joh usɛn ki tì baa' niʼsaan ki laa' wɔ, nɛ ki muɔ' wɔ micɛcɛkm cɛɛn. ");
INSERT INTO gngNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","U cuon' ki nɛkn' wɔ, ki taa' midaam mà bi yih mɛ̀ fɛn nnɔ ki sɔsɔkre' uʼgbìɛn, ki taa' mikpɔm ki tentien' yɛ̀, ki taa' tikpɛlcɛr ki lòlòle' yɛ̀, ki taa' wɔ ki jɛkn' wɔn bugbɛn ya ŋuun bo, ki taa' wɔ ki jon' ticɛndur tuba saan, ki tì liike' wɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Kutaaku faa' nɛ u ñɛn' ilike ki de' ticɛndur nnɔ ya daan, ki tɔke' wɔ ki ye: ‹Liike nni wɔ. A ñɛn' ilike ki pukn' yii bó la, n lá liɛbe' ní la, min bugbɛn nɛ li pɛ̀ ŋɛ.› » ");
INSERT INTO gngNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Nɛ *Yesu niire' wà bɛn *yiko nnɔ ki ye: «A ya bùol bijɛb bita nnɔ ni, ŋmɛ nɛ yíe wà lu' idukond ya nuɔ ni nnɔ?» ");
INSERT INTO gngNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Nɛ u jiin' wɔ ki ye: «Wà muɔ' wɔ micɛcɛkm nnɔ.» Nɛ *Yesu ye: «Li joh ki mɔ ń tì ń li teh nnɔ.» ");
INSERT INTO gngNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","*Yesu nin uʼpanpaankaab te usɛn ni ki joh ma nnɔ nɛ ki tì baa' udu uba ni, nɛ upii uba teke' wɔ uʼden, bi yih wɔ Mart. ");
INSERT INTO gngNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","U ŋmɔbe ninsɛ uba, bi yih wɔ Mari. Mari nnɔ baa' ki lá kɛ̀le' Yonbdaan *Yesu saan, ki cengeh uʼgbɛr. ");
INSERT INTO gngNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ama Mart wɔn ya nun mɔ́n tijier ya tienm bo nɛ. Nɛn bo nɛ u kpiere' ní ki lá tɔke' *Yesu ki ye: «Yonbdaan, nʼninsɛ cɛ̀be' min baba nɛ itùon nɛ nà teh ŋɛ niba? Tɔke wɔ wɔ ń tore nni-a!» ");
INSERT INTO gngNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Nɛ Yonbdaan tɔke' wɔ ki ye: «Mart, Mart, a cère' aʼnun mɔ́n tibont tà yɛbe bo nɛ, nɛn nɛ cère' a jieh. ");
INSERT INTO gngNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ama nibonn niba kpein nɛ yé nibonmɔ̀nn. Mari wɔn gɛ̀nde' nɛn nɛ. Uba ŋa ń fie nɛ̀ uʼsaan.» ");
INSERT INTO gngNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Lidaali liba nɛ *Yesu te niba saan ki kàareh. U kàare' ki tì gben', nɛ uʼpanpaankaab ya uba tɔke' wɔ ki ye: «Yonbdaan, San wà siih binib Uwien ya ñunm wɔkn' uʼpanpaankaab bi li kàareh ma bo nɛ, aʼmɔ ń wɔkn tɛ ti li kàareh ma bo.» ");
INSERT INTO gngNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Nɛ *Yesu tɔke' bɛ ki ye: «Ni kàareh la, ní li teh: ‹TiʼBaa, cère binib kɛ ń li boh aʼyel, cère' aʼbɛl ń baa ní, ");
INSERT INTO gngNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Li dienh tɛ daanl kɛ daanl ya wentunl ya jier. ");
INSERT INTO gngNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Fère tɛ tiʼbiɛre, kimɛ tiʼmɔ fèreh bà kɛ biih tɛ nnɔ nɛ. La cère tí lu mibiikm ni.› » ");
INSERT INTO gngNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","*Yesu tí tɔke' bɛ ki ye: «Tɛntɛn, niʼni uba ń li ŋmɔbe jɔ, nɛ uʼjɔ nnɔ ń baa uʼden kuyɔku ya siik kí len kí ye: ‹Nʼjɔ, kpende nni kpɔnɔ uta, ");
INSERT INTO gngNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","kimɛ nʼjɔ uba nɛ ñɛn' usɛn ki baa' nʼden, nɛ ma ŋmɔbe jier ń de wɔ.› ");
INSERT INTO gngNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Nɛ uʼjɔ nnɔ ń jiin kuduku ni ki ye: ‹La ŋmɔbe nni yɛnŋaabe, min nin nʼbumu kɛ duɔn' ki piin'-a, ma ń fre kí fii kí de ŋɛ.› ");
INSERT INTO gngNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","N tɔkeh nɛ nɛ, wa ń fii kí de wɔ kujɔtieku bo mɔnɔn la, u li fii kí de wɔ u yíe nà kɛ, u gbien' wɔ uyɛnŋaabe ma nnɔ bo. ");
INSERT INTO gngNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Nɛn bo nɛ n tɔkeh nɛ, li miɛh mɛn, bi li pu nɛ; li nuunh mɛn, ni li lɛ; li ñih mɛn kunagɛnku, bi li pìire. ");
INSERT INTO gngNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Kimɛ wà kɛ miɛh la, bi punh wɔ nɛ. Wà kɛ nuunh la, u lɛnh nɛ. Wà kɛ mɔ ñih kunagɛnku la, bi pìireh nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Niʼni uba ya buk miɛ' wɔ ujɛn la, u li de kɛ̀ uwɛ-ɛɛ? ");
INSERT INTO gngNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Bii kì miɛ' wɔ lijènl la, u li de kɛ̀ unɛn-ii? ");
INSERT INTO gngNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ninbi bibiɛrdɛnb, ni bɛn ki dienh niʼbumu nà mɔn la, bɛ li tien niʼBaa wà te paaki bó ŋa ń cère *Mifuoñaanm ń jiire ní binib bà miɛh wɔ mɛ̀ nnɔ bo!» ");
INSERT INTO gngNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ujɛ uba nɛ là te usɛnpol cère' uʼlɛnl tɛbe. *Yesu ŋɔre' usɛnpol nnɔ uʼsaan, nɛ u ji freh ki lienh. Nì bɛke' linigol cɛɛn. ");
INSERT INTO gngNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ama biʼni biba lienh ki teh u taah isɛnpol ya ciɛn Bɛlsebul ya tuɔm nɛ ki ŋuɔh isɛnpol binib saan. ");
INSERT INTO gngNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Bitɔb mɔ yíe bɛ ń biike wɔ, nɛ ki tɔke' wɔ ki ye wɔ ń tien miyɔkm ya bonn nà li wuɔn kí ye uʼtuɔm ñɛn' Uwien saan nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ama u bɛn biʼyɛnmaale ma nnɔ nɛ ki tɔke' bɛ ki ye: «Libɛl là kɛ ya nib bore' tɔb ki kɔnh biʼŋmiɛl ni la, libɛl nnɔ li juore fɛnm nɛ, nɛ liʼnib ya dur ń lulu tuʼtɔr bo. ");
INSERT INTO gngNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ni lienh ki teh n taah isɛnpol ya ciɛn Bɛlsebul ya tuɔm nɛ ki ŋuɔh isɛnpol binib saan bii ba? *Satan ya nib tɔh lituɔl biʼŋmiɛl ni la, uʼbɛl li tien mila ka ń juore fɛnm-i? ");
INSERT INTO gngNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ni ye min taah isɛnpol ya ciɛn Bɛlsebul ya tuɔm nɛ ki ŋuɔh isɛnpol binib saan la, niʼyaab taa' ŋmɛ ya tuɔm ki ŋuɔh isɛnpol binib saan? Niʼyaab teh ma bo nɛ li wuɔn kí ye na ŋmɔbe mɔ̀n. ");
INSERT INTO gngNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ama min taa' Uwien ya tuɔm nɛ ki ŋuɔh isɛnpol binib saan. Nɛn nɛ wuɔn' ki ye *Uwien ya bɛl baa' ní niʼsaan. ");
INSERT INTO gngNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","«Ufɛfaa bɛ̀le' uʼjɛkɔnwɛnt, ki kɛ ki gu uʼden la, niba ŋa ń tien uʼfaal. ");
INSERT INTO gngNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ama wà mɔ faa ki cɛn' wɔn pi' wɔ ki faake' nin wɔ la, u li fie uʼjɛkɔnwɛnt tà u du tuʼbo nnɔ kɛ, kí fie uʼfaal mɔ kí gbigbiire binib. ");
INSERT INTO gngNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","«Wà kɛ ŋa se nʼciɛk bó la, u nɛn nni nɛ. Wà kɛ ŋa taakeh ki toreh nni la, u kpiɛndeh nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","«Usɛnpol siere' ki dàan unil la, u cuonh ki lindeh kupenpelku ni nɛ, ki nuunh u li kɛ̀le nà saan kí fuore. U tì luo' la, nɛ wɔ ń ye u li liɛbe kí tì ŋɛkn u là siere' ki dàan wà nnɔ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","U li liɛbe ní kí lɛ bi tùɔre' ki ŋɛ̀ŋɛ̀re' uʼkɔnkuɔn nnɔ, ki tien' tibonmɔnmɔnt len. ");
INSERT INTO gngNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Nɛn saan nɛ u li jo kí tì taa ní isɛnpol ilole yà bre ki cɛn' wɔn, iʼkɛ ń lá ŋɛkn unil nnɔ kí li te, kí cère wɔ ń juore fɛnm kí cɛn u là te mikpiɛkm ma bo.» ");
INSERT INTO gngNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","*Yesu laan biɛ ki lienh, nɛ upii uba len' ufaa bo linigol nnɔ ni ki ye: «Upii wà maa' ŋɛ ki ŋaan' ŋɛ nnɔ Uwien ya mɔnm te uʼbo.» ");
INSERT INTO gngNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Nɛ *Yesu ye: «Binib bà cengeh Uwien ya gbɛr, ki boh tù nnɔ, Uwien ya mɔnm te bɛn bo nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Binib taakeh *Yesu saan ki yɛbreh, nɛ u len' ki ye: «Fɛnfɛnnɔ ya nib biɛ yé bibiɛrdɛnb nɛ, ki nuunh bɛ ń lɛ miyɔkm ya bonn. *Uwien ya ñɔbonsɔknl Sonas ya yɔkm ya bonn baba ŋa ñí la, ba ji li lɛ yɔkm ya bontɔnn niba. ");
INSERT INTO gngNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Uwien là tien' Sonas nà nnɔ là yé kudìɛku nɛ Ninif yaab bo. Nnɔ nɛ, u li tien Unil ya Bijɛ nà nnɔ mɔ li yé kudìɛku fɛnfɛnnɔ ya nib bo. ");
INSERT INTO gngNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Uwien li bu binib tibuur lidaali là nnɔ, Seba ya piibɛr li fii kí biin fɛnfɛnnɔ ya nib, kimɛ u là ñɛn' ní fɔnfɔkm nɛ wɔ ń lá cenge Salomɔn ya yɛnfogbɛr. Ama unil uba te niɛ saan nɔ ki cɛn' Salomɔn. ");
INSERT INTO gngNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Uwien li bu binib tibuur lidaali là nnɔ, Ninif ya nib mɔ li fii kí biin fɛnfɛnnɔ ya nib, kimɛ Sonas là tɔke' bɛ Uwien ya gbɛr, nɛ bi lèbre' biʼtetem. Ama unil te niɛ saan nɔ ki cɛn' Sonas.» ");
INSERT INTO gngNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","«Uba ŋa ń sɛ frl kí taa lɛ̀ kí bɔle bii kí taa kusɛnku kí cubn liʼbo, ama u li taa lɛ̀ kí tuɔn likpɛnkpɛnl bo nɛ ŋɔ bà kɛ kɔh ní iden ni ń li lɛnh. ");
INSERT INTO gngNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Aʼnunbu yé aʼgbɛnɛnt ya frl nɛ. Aʼnun mɔn la, aʼgbɛnɛnt kɛ te kuwenwenku ni nɛ. Aʼnun ŋa mɔn la, aʼgbɛnɛnt kɛ te licinñunl ni nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Nɛn bo, fìin kí liike kuwenwenku kùa te aʼbo nnɔ la li yé licinñunl-a! ");
INSERT INTO gngNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Kuwenwenku wendeh ŋɛ, ka sìen' niba saan la, aʼgbɛnɛnt kɛ te kuʼni nɛ. Nì te tɛn lifrl là wien cɛɛn nɛ wendeh ŋɛ.» ");
INSERT INTO gngNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","*Yesu len' ki gben', nɛ Farisiɛn uba yin' wɔ wɔ ń baa kí lá ji uʼden, nɛ u jon' Farisiɛn nnɔ den ki tì kɛ ki jinh. ");
INSERT INTO gngNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Farisiɛn nnɔ laa' *Yesu jinh ka nire' ki paan' iyaajɛbok ye ma bo, nɛ nì cuo' wɔ miyɔkm. ");
INSERT INTO gngNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Nɛ Yonbdaan tɔke' wɔ ki ye: «*Farisiɛnmbɛ, liike mɛn ni naan ma, ni ñikndeh ki cɛndeh isɛ̀n nin tiyer ya puoli nɛ, ama inasuyɛnmaale nin mibiɛrm nɛ gbe niʼfɛ̀l ni. ");
INSERT INTO gngNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ijɔr ninbi, na bɛn ki ye Uwien wà ñɛn' tibont tà ni lɛnh tù nnɔ, wɔn nɛ tien' unisaal ya fɛ̀l mɔ-ɔɔ? ");
INSERT INTO gngNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Nɛn bo, taa mɛn ni ŋmɔbe tibont tà, kí pu bijiinb ŋɔ niʼbont kɛ la li ŋmɔbe jɔknt. ");
INSERT INTO gngNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","«Ninbi *Farisiɛnmbɛ, nì bre niʼbo, kimɛ ni gbiinh niʼninjo nin niʼgɔ̀nt nin niʼkpinfɛtɔr bolm piik nɛ, ki taah miba ki dienh Uwien, ama ka tɔnge ní li cuube, ka yíe Wien mɔ. Ni bi li teh nɛn nɛ, ki la sunde tibontɔr tà sìen' nnɔ mɔ bó. ");
INSERT INTO gngNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","«Ninbi *Farisiɛnmbɛ, nì bre niʼbo, kimɛ ni yíe ní li kaah binikpɛkpiɛkb ya kànkàan nɛ itáan ya dur ni, ki yíe binib ń li gbaandeh ki fuondeh nɛ mudaamu ni. ");
INSERT INTO gngNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Nì bre niʼbo, kimɛ ni naan ikul yà bere' nib ŋa ji lɛnh yɛ̀, ki cuonh ki taanh iʼbo ka bɛn nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Nɛ bà bɛn *yiko mɔnmɔnm nnɔ ya uba tɔke' wɔ ki ye: «Uwɔnwɔknlɔ, a lienh nnɔ ma nɔ, a sukreh tiʼmɔ nɛ-a!» ");
INSERT INTO gngNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Nɛ *Yesu ye: «Ninbi bà bɛn *yiko mɔnmɔnm nnɔ, nì bre niʼmɔ bo, kimɛ ni cèreh binib tukeh itukkpɛkpiɛk nɛ ka toh niʼbugbɛn ń taa niʼnɔbil mɔnɔn kí mɛ yɛ̀. ");
INSERT INTO gngNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Nì bre niʼbo, kimɛ ni mɛh *Uwien ya ñɔbonsɔknb bà là te uyo bo nnɔ ya kul nɛ, ki sunde'-a ki ye ni ya yaajɛb nɛ là ku' bɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ni teh nà nɛ wɔngeh ki teh ni tuo' niʼyaajɛb là tien' nà nnɔ nɛ, kimɛ bi là ku' *Uwien ya ñɔbonsɔknb, nɛ ninbi ji mɛh biʼkul. ");
INSERT INTO gngNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Nɛn bo nɛ Uwien len' nin miyɛnfuom ki ye: ‹N li sɔn nʼñɔbonsɔknb nin bitondb biʼsaan. Bi li ku biʼni biba kí jɛ̀nde bitɔb.› ");
INSERT INTO gngNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Nɛn nɛ li cère Uwien ń dɛre fɛnfɛnnɔ ya nib ya tub haali uŋɛndun ya cincinyo bi là ku' *Uwien ya ñɔbonsɔknb bà kɛ nnɔ bo ki lá tu fɛnfɛnnɔ, ");
INSERT INTO gngNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","kí cin Abɛl, ki tì baa' Sakari, wà bi là ku' wɔ Uwien ya duku ya luo bo nnɔ. N tɔkeh nɛ imɔ̀n nɛ, Uwien li dɛre fɛnfɛnnɔ ya nib ya tub binib nnɔ kɛ ya kuum bo. ");
INSERT INTO gngNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","«Ninbi bà bɛn *yiko mɔnmɔnm nnɔ, nì bre niʼbo, kimɛ na dienh nib sɛn bɛ ń bɛnde Uwien. Ninbi ŋa pɛ Uwien ya sɛn bo, nɛ ki piendeh binib bà yíe bɛ ń paan uʼbo nnɔ mɔ.» ");
INSERT INTO gngNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","*Yesu ñɛn' uyo wà nnɔ, nɛ *Yiko ya wɔnwɔknb nin *Farisiɛnmbɛ taa' uʼbo ubenpiebe nɛ ki niireh wɔ iniire tigbɛr kɛ ya bol bo, ");
INSERT INTO gngNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ki nuunh bɛ ń dɛle kí cuo wɔ uʼlenm ni. ");
INSERT INTO gngNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","U ya yo nɛ binib itur itur taan' *Yesu saan, haali ki tì pɛbeh tɔb. Nɛ *Yesu cin' ki tɔkeh uʼpanpaankaab ki teh: «Li bɛn mɛn *Farisiɛnmbɛ ya kpɔnɔ ya ñɔke bó, bi yé iñuɔn ilele ya nib nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Niba ŋa te ki buɔ ŋɔ ka lá li ñɛ upaan bo. Tigbɛr tuba mɔ ŋa te ki juore' kí li buɔ ŋɔ ba lá li bɛnde tù. ");
INSERT INTO gngNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ni len' nà kɛ licinñunl ni la, bi li cii nɛ̀ kuwenwenku ni nɛ. Ni bunbe' nà litubl ni kudubenku bó nnɔ, bi li kpaande nɛ̀ kuduku ya paaki nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","«Ninbi bà yé nʼjɔtieb nnɔ, n tɔkeh ninbi nɛ: la fɛnge mɛn bà kuuleh tigbɛnɛnt, ka ji li fre kí tien niba kí pukn. ");
INSERT INTO gngNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","N li wuɔn nɛ udaan wà nì kpɛ ní li fɛnge wɔ. Li fɛnge mɛn Uwien. Wɔn nɛ li fre kí cère ní kpo nɛ ki ŋmɔbe mituɔm wɔ ń taa nɛ kí wiɛ umu wà ŋa ń kpiin ni. N tɔkeh nɛ nɛ, li fɛnge mɛn wɔn. ");
INSERT INTO gngNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","«Bi li fre kí kuɔre inuɔn iŋun iŋɛ nɛ? Nin nɛn kɛ ŋɔ Uwien ŋa ń sunde iʼni uba mɔnɔn bó. ");
INSERT INTO gngNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Nɛn bo, la fɛnge mɛn, kimɛ ni cɛn' inuɔn ligol. Uwien bɛn haali niʼyur mɔnɔn ya ñɔbu.» ");
INSERT INTO gngNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","«N tɔkeh nɛ nɛ, wà kɛ lienh binib ya nun bó ki teh u yé nʼyɔ la, Unil ya Bijɛ mɔ li len Uwien ya tondb ya nun bó kí ye udaan mɔ yé uʼyɔ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ama wà kɛ lienh binib ya nun bó ki teh wa yé nʼyɔ la, nʼmɔ li len Uwien ya tondb ya nun bó kí ye udaan mɔ ŋa yé nʼyɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Unil len' Unil ya Bijɛ bo fɛnfɛnm la, Uwien li fère wɔ. Ama unil suke' *Mifuoñaanm mɛn la, Uwien ŋa ń fère wɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","«Bi taa' nɛ ki jon' itáan ya dur ni bii tibuur ya ciɛnb saan bii udu ya ciɛnb saan bɛ ń bu nɛ tibuur uyo wà la, la nìin mɛn ni li len ma bo bii ni li len bà kí ñɛ len. ");
INSERT INTO gngNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Kimɛ *Mifuoñaanm nɛ li cère ní bɛnde ni li len kí ye bà u ya yo.» ");
INSERT INTO gngNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Linigol nnɔ ni ujɛ uba tɔke' *Yesu ki ye: «Cɛnbaa, tɔke nʼninjɛ kí ye wɔ ń gbiire tiʼbaa ya faal kí de nni n ya bó.» ");
INSERT INTO gngNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Nɛ *Yesu tɔke' wɔ ki ye: «Ujɛ, ŋmɛ de' nni usɛn ń tùɔre niʼgbɛr bii ń gbiire nɛ niʼfaal-i?» ");
INSERT INTO gngNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Nɛ ki tɔke' linigol nnɔ ki ye: «Li bɛn mɛn ki la cère niʼnun ń li fɔke lifaal bo, kimɛ unil ŋmɔbe lifaaciɛnl mɔnɔn la, na yé lɛn nɛ li cère wa ń kpo.» ");
INSERT INTO gngNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Nɛ ki pɔn' bɛ mikpɛnjɛnm ki ye: «Ufàadaan uba nɛ là te uʼkpàan lùon' cɛɛn. ");
INSERT INTO gngNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Nɛ u maaleh uʼfɛ̀l ni ki teh: ‹N li tien mila? Kimɛ ma ji ŋmɔbe ń li cùɔn nà saan nʼjier.› ");
INSERT INTO gngNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Nɛ ki ye: ‹N li tien ma sɔ: n li we nʼbɔnbuɔn kɛ nɛ, kí mɛ icɛnciɛn, kí cùɔn nʼjier nin nʼbont kɛ, ");
INSERT INTO gngNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","nɛ kí ye n ŋmɔbe lifaal lì yɛbe ki li baa nni ibin ibin. Nɛn bo, n li fuoreh nɛ, kí li jinh, ki ñuh, ki poknh.› ");
INSERT INTO gngNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Nɛn saan nɛ Uwien tɔke' wɔ ki ye: ‹Ujɔr sin, a li kpo kuñɔnku kuu kɛ. A taan' lifaal là kɛ nɔ, ŋmɛ ji li si lɛ̀?› ");
INSERT INTO gngNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Unil wà kɛ nuunh lifaal ki dòkndeh, ka ŋmɔbe nà yé lifaal Uwien ya nun bó nnɔ yaam mɔ te nnɔ nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","*Yesu tɔke' uʼpanpaankaab ki ye: «Nɛn bo nɛ n tɔkeh nɛ ki teh ni la cère nɛ̀ ń li wiɛbe nɛ ni li tien ma kí li fuobe bo, ní li maaleh ki teh: ‹Ti li ji ba?› Ki la cère nɛ̀ ń li wiɛbe nɛ niʼgbɛnɛnt bo, ní li maaleh ki teh: ‹Ti li gole ba?› ");
INSERT INTO gngNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Kimɛ limiɛl cɛn' tijier, nɛ tigbɛnɛnt mɔ cɛn' tiwɛngolkaar. ");
INSERT INTO gngNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Maale mɛn kí liike ikankaan te ma bo. Ya koh, ka ceh, ka ŋmɔbe bɔnbuɔn, ka ŋmɔbe jieblibùol. Ama Uwien nɛ jindeh yɛ̀. Na nín cɛn' inuɔn-ii? ");
INSERT INTO gngNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Niʼni ŋmɛ nɛ uʼnìinm ni, u li fre kí fɔkn uʼmiɛl waamu kí pukn-i? ");
INSERT INTO gngNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Na nín li fre kí tien nibonwawaann ma nɔ, bɛ tien' ni nìinh tibontɔr bo? ");
INSERT INTO gngNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Maale mɛn kí liike tisir puh ma bo. Ta loh kunkum, ka loh kpɛlcɛr mɔ. Ama n tɔkeh nɛ nɛ, ubɛr Salomɔn nin uʼfàaciɛnl kɛ wa là gole' kpɛlcɛr tù mɔn ki baa' mipuum nnɔ ya miba mɔnɔn. ");
INSERT INTO gngNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Uwien cèreh timɔsir tà te kubaaku ni dinnɔ ki li wun teke umu puh mipúmɔnmɔnm la, bɛ li cère wa ń tien ninbi binib mimɔnm kí cɛn timuɔr-i? Niʼtekjim nɛ pɔre' nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ninbi la cère mɛn niʼnun ń li mɔ́n ni li ji bà nin ni li ñu bà bo, ki la cère iyɛnmaale ń li jɛ̀ndeh nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Kimɛ uŋɛndun yaab bà ŋa pɛ Uwien ya sɛn bo ya nun nɛ mɔ́n tu ya bont kɛ bo. Ama ninbi bɛn wɔn, niʼBaa Uwien bɛn ki ye ni ciɛke tù. ");
INSERT INTO gngNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Nɛn bo, cère mɛn niʼnun ń li mɔ́n *Uwien ya bɛl bo, u li taa tibont nnɔ kí pukn nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Kicɛkwawaak ya nibɛ, la fɛnge mɛn, kimɛ niʼBaa Uwien yíe ní li te uʼbɛl ni nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","«Kuɔre mɛn ni ŋmɔbe nà, kí taa ilike nnɔ kí pu bijiinb, ŋɔ kí li ŋmɔbe muliksɔrmu mùa ŋa ń saa, kí li ŋmɔbe Uwien saan lifaal là ŋa ŋmɔbe gbenm. Nasu ŋa ń nɛkn nɛn saan, kuotuul mɔ ŋa te niʼsaan kí mɔ lɛ̀. ");
INSERT INTO gngNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Kimɛ niʼfaal te nà saan la, niʼfɛ̀l mɔ dɔ nɛn saan nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","«Li bondeh mɛn niʼba, ki la cère niʼfr ń kpíin. ");
INSERT INTO gngNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Li te mɛn tɛn bitonsɔnb bà gu uyo wà biʼcɛnbaa ñɛn' upiikuɔn bó ki lá ñi' kunagɛnku la, bɛ ń pɔk kí pìire nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Uwien ya mɔnm te bitonsɔnb bà biʼcɛnbaa li baa ki lɛ bà gɔh nnɔ bo. N tɔkeh nɛ imɔ̀n nɛ, u li taa uʼtonsɔnkpɛlcɛr kí gole kí cère bɛn nɛ ń kɛ̀le, wɔn ń taa tijier kí gbiire bɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","U baa' kuyɔku ya siik bii ukuojɛmuɔyo mɔnɔn ki laa' bi bonde' la, Uwien ya mɔnm te biʼbo. ");
INSERT INTO gngNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ni bɛn ki ye ududaan bi bɛn uyo wà unasu li baa la, wa bi li cère nasu ń kɔ uʼden. ");
INSERT INTO gngNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Niʼmɔ ń bonde kí li gu, kimɛ uyo wà na maaleh ki teh Unil ya Bijɛ li baa ní nnɔ, u ya yo nɛ u li baa.» ");
INSERT INTO gngNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Nɛn saan nɛ Piɛr niire' *Yesu ki ye: «Yonbdaan, a pɔn' tinbi nɛ mikpɛnjɛnm miɛ bii a pɔn' mɛ̀ binib kɛ nɛ?» ");
INSERT INTO gngNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Nɛ u jiin' wɔ ki ye: «U lɛ tonsɔnl ba nɛ ŋmɔbe mibɛnm uʼcɛnbaa du uʼbo? Wɔn si: wà ya cɛnbaa li de wɔ ticiɛnt wɔ ń li likeh uʼtonsɔntɔb, kí li loh bɛ tijier uyo wà nì kpɛ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Utonsɔnl nnɔ ya cɛnbaa baa' ki laa' u sɔnh lituonl nnɔ liʼdonbó la, Uwien ya mɔnm li te utonsɔnl bugbɛn bo. ");
INSERT INTO gngNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","N tɔkeh nɛ imɔ̀n nɛ, uʼcɛnbaa li de wɔ ticiɛnt wɔ ń li likeh uʼbont kɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ama nʼba la, utonsɔnl nnɔ li maale uʼyɛnm ni kí ye uʼcɛnbaa li wuɔke, nɛ kí cin kí li ñih uʼtonsɔntɔb, bijɛb nin bipiib kɛ, kí li jinh, ki ñuh ki yibeh. ");
INSERT INTO gngNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Utonsɔnl nnɔ ya cɛnbaa li baa ní lidaali là nin uyo wà wa maaleh ki teh u li baa, nɛ kí bien uʼgbɛn cɛɛn, kí cère wɔ ń lɛ bà ŋa tuo' Uwien ya ñɔbu bó li lɛ utudɛre wà nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","«Utonsɔnl wà bɛn uʼcɛnbaa yíe ma, ka bonde' bonn, ka tien' uʼcɛnbaa yíe ma la, bi li bien u ya gbɛn nɛ kí gbien. ");
INSERT INTO gngNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ama utonsɔnl wà ŋa bɛn uʼcɛnbaa yíe ma, ki sɔnh lituonl là kpɛ bɛ ń ñì wɔ mɔnɔn la, bi li ñì wɔ waamu nɛ. Nɛn bo nɛ bi de' wà nì yɛbe la, bi niireh wɔn nɛ bi de' wɔ nà nnɔ bó ki gbiekeh. Bi guun' wà tibont tù yɛbe la, bi niireh wɔn nɛ tuʼbó ki gbiekeh.» ");
INSERT INTO gngNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","«N tuke umu nɛ ki lá wiɛ' kitink bo, nɛ n bi yíe wù ń pɔk kí teke nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","N li jɛ̀nde kí tì kɛnde. Ma jɛ̀nde' ki tì gben' la, nʼyɛnm ŋa ń duɔn. ");
INSERT INTO gngNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ni maaleh ki teh n tuke uñɔkpaan nɛ ki baa' uŋɛndun wuu ni-ii? Na te nnɔ, n tɔkeh nɛ nɛ, n tuke umaapàare nɛ ki baa'. ");
INSERT INTO gngNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kimɛ fɛnfɛnnɔ kí taa kí li joh, binib biŋun te iden iba la, bi li pàare tɔb. Bita li nɛn bile, bile nnɔ mɔ li nɛn bita. ");
INSERT INTO gngNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Bibaa li nɛn uʼbijɛ, uʼbijɛ mɔ li nɛn wɔ; binaa li nɛn uʼbisɛ, uʼbisɛ mɔ li nɛn wɔ; upii li nɛn uʼyaabisɛ, uʼyaabisɛ mɔ li nɛn wɔ.» ");
INSERT INTO gngNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","*Yesu tɔke' linigol nnɔ ki ye: «Ni laa' titɛwɔlgbɔnt te nintuɔli bó la, ni pɔk tɔkeh ki teh: ‹utaa li nii nɛ›, nɛ wɔ ń nii. ");
INSERT INTO gngNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Mitafaam ñɛn' unɔgɛn bó ní la, ni tɔkeh ki teh kutòntònku li cùun, nɛ kù ń cùun. ");
INSERT INTO gngNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ninbi iñuɔn ilele ya nibɛ, ni freh ki sekndeh ki bɛndeh kutaaku nin kitink ya bont teteh ma bo, bɛ tien' na fre' ki sekn' ki bɛnde' Uwien teh tibont tà fɛnfɛnnɔ nɔ ya tingi?» ");
INSERT INTO gngNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","«Bɛ tien' ninbi bugbɛn ŋa freh ki maaleh ki bɛndeh nà mɔn-i? ");
INSERT INTO gngNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Sin nin unil ŋmɔbe mimaam, nɛ u tuke mɛ̀ kí jo tibuur la, cère ní gben mɛ̀ uyo wà ni laan te usɛn ni. Nnɔ ŋa ñí la, u li taa ŋɛ kí tì ŋukn tibuur ya ciɛn, uʼmɔ ń taa ŋɛ kí tì ŋukn lipɛkl ya ciɛn wɔ ń pɛkn ŋɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","N tɔkeh ŋɛ nɛ, ŋa tì pɛ̀n' ki gben' tibuur ya like la, ŋa ń ñɛ len.» ");
INSERT INTO gngNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","U ya yo nɛ binib biba baa' ki lá tɔke' *Yesu ki ye Galile yaab biba là te ki teh lituɔrl ki dienh Uwien, nɛ Pilat ku' bɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Nɛ *Yesu jiin' bɛ ki ye: «Ni maaleh ki teh Galile ya nib nnɔ là yé bibiɛrdɛnb ki cɛn' Galile ya nitɔb nɛ cère' bi jɛ̀nde' bɛ nnɔ-ɔɔ? ");
INSERT INTO gngNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Na te nnɔ. N tɔkeh nɛ nɛ, na lèbre' niʼtetem la, niʼkɛ mɔ li kpo nnɔ nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","*Yesu tí len' ki ye: «Likpɛnkpɛnfɔfɔkrl là lu' ki ku' bijɛb piik nin biniin Silowe ni ma nnɔ, ni maaleh ki teh bi là teh ibiɛre ki cɛn' Yerusalɛm ya nitɔb kɛ nɛ-ɛɛ? ");
INSERT INTO gngNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Na te nnɔ. N tɔkeh nɛ nɛ, na lèbre' niʼtetem la, niʼkɛ mɔ li kpo nnɔ nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Nɛ ki pɔn' bɛ mikpɛnjɛnm ki ye: «Bukɛnkɛnbu buba nɛ là se ujɛ uba ya kpàabu ni. Nì tete nɛ u lá baa' wɔ ń liike bù lùon' bii bua lùon'-i? Nɛ ki laa' bua lùon'. ");
INSERT INTO gngNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Nɛ u tɔke' uʼtonsɔnl wà gu bukpàabu nnɔ ki ye: ‹Ibin ita sɔ n baa' ma kɛ ń pùɔ ikɛnkɛn busubu buu bo la, ma lɛnh bonn. Gɛ bù, la cère bù ń ji ń li se ki teknh kitink ya sensenm fɛnm.› ");
INSERT INTO gngNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Nɛ utonsɔnl nnɔ tɔke' wɔ ki ye: ‹Cɛnbaa, dàan bù libinl liɛ nɔ, ń gbii buʼñiɛl, kí nuun tiwɛnt ya bint kí tien bù. ");
INSERT INTO gngNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Nʼba la, libinl là we ní nɔ, bù li lùon. Bua lùon' la, á ji ń gɛ bù.› » ");
INSERT INTO gngNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","*Saba uba ya daali nɛ *Yesu te Sufmbɛ ya taanl ya duku kuba ni, ki wɔknh binib Uwien ya gbɛr. ");
INSERT INTO gngNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ki laa' upii uba mɔ te len, usɛnpol ŋaake wɔ, ki tien' wɔ uwiɛn ibin piik nin iniin, u bɔ ka freh ki yaareh. ");
INSERT INTO gngNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","*Yesu laa' wɔ, ki yin' wɔ, nɛ ki tɔke' wɔ ki ye: «Upii, a laa' aʼba,» ");
INSERT INTO gngNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","ki taa' uʼnuɔ ki paan' uʼbo, nɛ u yaare' i ya tàan bo, ki cin' ki pɛ̀keh Uwien. ");
INSERT INTO gngNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","*Yesu cère' upii nnɔ faake' *Saba ya daali ma nnɔ nɛ litaanl ya duku nnɔ ya ciɛn ya benku ni ben' nɛ u tɔke' linigol nnɔ ki ye: «Ni ŋmɔbe iwien iluob nɛ ní li sɔnh itùon. Ni li bàareh i ya wien nɛ u buuh nɛ, na yé *Saba ya daali nɛ ni li bàareh u buuh nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Nɛ Yonbdaan *Yesu tɔke' wɔ ki ye: «Ninbi iñuɔn ilele ya nibɛ, niʼni ŋmɛ ŋa ñɛndeh uʼnɛ bii uʼŋuun *Saba ya daali ki tì ñundeh? ");
INSERT INTO gngNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Upii wuɔ yé *Abraham ya yaabil nɛ, nɛ *Satan cère' u bun ibin piik nin iniin ka ń fre kí yaare. Ma bi li cère wɔ ń faake *Saba ya daali bii?» ");
INSERT INTO gngNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","*Yesu len' nnɔ ma nnɔ nɛ ifɛ cuo' binib bà kɛ niɛh nin wɔ miniɛm nnɔ. Ama linigol nnɔ kɛ ya yɛnm sɔnge' u tien' miyɔkm ya bont tà kɛ nnɔ bo. ");
INSERT INTO gngNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Nɛn saan nɛ *Yesu ye: «Uwien ya bɛl naan ba? N li taa ba kí nɛnge lɛ̀? ");
INSERT INTO gngNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Lì naan mibim mà bi yih mɛ̀ mutaar ujɛ uba taa' ki bule' uʼkpàabu ni nɛ. Mì pɛn' ki kpére' ki tɔn' isigben, nɛ inuɔn tereh iʼbo ki kɔh.» ");
INSERT INTO gngNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","*Yesu tí ye: «N tí li taa ba kí nɛnge Uwien ya bɛl-i? ");
INSERT INTO gngNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Lì naan kpɔnɔ ya ñɔke wà upii uba bun' kpɔnɔyom mà dindin, ki taa' wù ki tien' len, kpɔnɔ nnɔ kɛ nuule' nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","*Yesu joh Yerusalɛm, nɛ ki ñɛh iducɛnciɛn nin iduwawaale ni ki wɔknh binib Uwien ya gbɛr. ");
INSERT INTO gngNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Nɛ udaan uba niire' wɔ ki ye: «Yonbdaan, bà li ŋmɛre ŋa yɛbe nɛ-ɛɛ?» Nɛ *Yesu tɔke' bɛ ki ye: ");
INSERT INTO gngNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«Cère mɛn niʼnun n li mɔ́n ní ñɛ bunañɔbu bùa wiɛbe kí kɔ. N tɔkeh nɛ nɛ, kimɛ binib bà yɛbe li nuunh bɛ ń ñɛ bù kí kɔ ka ń fre. ");
INSERT INTO gngNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Uyo uba ududaan lá li fii kí pìin bunañɔbu, nɛ ni juore' kí li se saali ki ñih kunagɛnku ki teh: ‹Yonbdaan, pìire tɛ bunañɔbu.› U li tɔke nɛ kí ye: ‹Ma bɛn ni yé nà bó yaab.› ");
INSERT INTO gngNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Nɛn saan nɛ ni li lienh ki teh: ‹Tinbi nin sin nɛ là taakeh ki jinh ki ñuh. A là te tiʼdu ya sɛnjɛ ni nɛ ki wɔknh binib Uwien ya gbɛr.› ");
INSERT INTO gngNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Nɛ wɔ ń tɔke nɛ kí ye: ‹N tɔkeh nɛ nɛ, jɛnde mɛn nʼsaan, ma bɛn ni yé nà bó yaab. Ninbi, niʼkɛ teh nà bre nɛ.› ");
INSERT INTO gngNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Nɛn nɛ cère' bi li juon nɛ saali, ní li muɔh ki ŋmɔnh iñɔgbɛn uyo wà ni li lɛ *Abraham nin *Isaak nin Sakɔb nin *Uwien ya ñɔbonsɔknb kɛ te Uwien ya bɛl ni nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Binib li ñɛ lɛnpuoli bó ní nin nintuɔli bó ní nin ikɛle kɛ ní kí lá kɛ̀le kí ji tijier Uwien ya bɛl ni. ");
INSERT INTO gngNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Nnɔ nɛ bà paan' puoli ya biba lá li liere usɛn. Bà mɔ liere' usɛn ya biba lá li paan puoli.» ");
INSERT INTO gngNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","U ya yo nɛ *Farisiɛnmbɛ biba nɛkn' *Yesu ki tɔke' wɔ ki ye: «Siere libùol liɛ kí li joh, kimɛ Herod yíe wɔ ń ku ŋɛ nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Nɛ *Yesu tɔke' bɛ kí ye: «Li joh mɛn kí tì tɔke u ya tiibe ki ye: ‹Dinnɔ n ŋuɔh isɛnpol binib saan, ki cèreh biwiɛnb faakreh, ki tí li wun tien nnɔ wenli mɔ, nɛ nʼtuonl ń gben wienta daali.› ");
INSERT INTO gngNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ama n li cuon dinnɔ nin wenli nin daalibó nɛ kí baa Yerusalɛm, kimɛ na kpɛ *Uwien ya ñɔbonsɔknl ń kpo niba saan, ki kɛnde' Yerusalɛm ni.» ");
INSERT INTO gngNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Nɛ ki ye: «Yerusalɛm, Yerusalɛm, a kuuleh *Uwien ya ñɔbonsɔknb, ki yèkreh u sɔnh binib bà aʼsaan nnɔ itɛn ki kuuleh bɛ. Uyo kɛ n là yíe ń taan aʼnib nʼba saan tɛn ukuoñɔ taakeh uʼbumu uʼfiɛbe ni ma bo, nɛ ba tuo'. ");
INSERT INTO gngNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Liike mɛn Uwien sɛln' nɛ niʼkɔnkuɔn ma. N tɔkeh nɛ nɛ, na ji li lɛ nni, kí tì baa uyo wà ni li len kí ye: ‹Uwien ya mɔnm ń li te wà we ní Yonbdaan ya yel bo nnɔ bo.› » ");
INSERT INTO gngNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","*Saba uba ya daali nɛ *Yesu jon' *Farisiɛnmbɛ ya ciɛn uba den wɔ ń tì ji tijier, nɛ binib bà te niʼsaan nnɔ sieke wɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ujɛ uba mɔ te niʼsaan ki se *Yesu ya nun bó uʼgbɛnɛnt cɔncuɔn', ");
INSERT INTO gngNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","nɛ *Yesu niire' bà bɛn *yiko mɔnmɔnm nnɔ nin *Farisiɛnmbɛ ki ye: «Unil ŋmɔbe usɛn wɔ ń buu biwiɛnb *Saba ya daali bii wa ŋmɔbe?» ");
INSERT INTO gngNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Bi ŋmin, nɛ *Yesu mɛ' ujɛ nnɔ ki cère' u faake', nɛ u cɛ̀be' wɔ u bure'. ");
INSERT INTO gngNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Nɛ u niire' bɛ ki ye: «Niʼni ŋmɛ ya buk bii uʼnɛ lu' liñunbunl ni *Saba ya daali la, wa ń ñɛn wɔ i ya tàan bo?» ");
INSERT INTO gngNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Nɛ ba fre' ki jiin' wɔ uʼniire nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","*Yesu laa' bi yin' binib bà tijier ya jim nnɔ gɛ̀ndeh binikpɛkpiɛkb ya kànkàan ki kaah, nɛ u pɔn' bɛ mikpɛnjɛnm ki ye: ");
INSERT INTO gngNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«Unil yin' ŋɛ upiikuɔn ya jier ya jim la, la jo kí tì kɛ̀le binikpɛkpiɛkb ya kànkàan. Nba la, u yin' uba mɔ u cɛn' ŋɛ uʼmɔ ń lá baa ní, ");
INSERT INTO gngNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","nɛ wà yin' niʼkɛ bile nnɔ ń baa kí lá tɔke ŋɛ kí ye: ‹Cère ujɛ wuɔ ń kɛ̀le a kɛ nà saan nɔ.› Nɛ a fii kí tì kɛ̀le puoli bó nin ifɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Nɛn bo, unil yin' ŋɛ tijier ya jim la, jo kí tì kɛ̀le puoli bó, ŋɔ wà yin' ŋɛ nnɔ lá baa' la, wɔ ń tɔke ŋɛ kí ye: ‹Nʼjɔ, dɛn inun bó ní.› Nɛn saan nɛ nì li yé aʼbo ukpiɛke sin nin bà kɛ jinh tijier nnɔ ya nun bó. ");
INSERT INTO gngNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Kimɛ wà kɛ kpiɛkreh uʼba la, Uwien li yuɔn wɔ. Wà kɛ jiindeh uʼba tingi la, Uwien li kpiɛke wɔ.» ");
INSERT INTO gngNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Nɛ *Yesu tɔke' wà yin' wɔ tijier ya jim nnɔ ki ye: «A ye á yin binib tijier ya jim la, la yin aʼjɔtieb, ki la yin aʼninjiɛb, ki la yin a kpi nin bà, ki la yin aʼkɔnkuɔnlieb bà yé bifàadɛnb, kimɛ biʼmɔ li fre kí yin ŋɛ á ji kí jiin. ");
INSERT INTO gngNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ama a ye á yin binib tijier ya jim la, yin bijiinb nin itɛjenb nin iwɔ̀b nin ijùɔn. ");
INSERT INTO gngNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Uwien ya mɔnm li te aʼbo, kimɛ bɛn ŋa ŋmɔbe niba bɛ ń jiin ŋɛ. Uwien nɛ li su ŋɛ uyo wà u li cère binimɔ̀nb ń mɛkre bitɛnkpiib ni nnɔ.» ");
INSERT INTO gngNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Wɔn nin binib bà jinh tijier nnɔ ya uba cii' u len' ma bo nɛ ki tɔke' wɔ ki ye: «Bà li ji tijier Uwien ya bɛl ni nnɔ, Uwien ya mɔnm te biʼbo.» ");
INSERT INTO gngNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Nɛ *Yesu tɔke' wɔ ki ye: «Ujɛ uba nɛ là tien' tijier tù yɛbe, ki yin' binib ligol bɛ ń baa kí lá ji. ");
INSERT INTO gngNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Tijier nnɔ ya jijiyo baa' nɛ u sɔn' uʼtonsɔnl u nɔn' ki tɔke' bɛ kí ye bɛ ń dɛn bi bonde' niʼkɛ ki gben'-a. ");
INSERT INTO gngNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Nɛ biʼkɛ yìe', a li ye bi kpaan' iyɛ nɛ. Ukpiɛk ye: ‹Tien' nni kafala, ma ń fre kí baa, kimɛ n dɛ' bukpàabu nɛ ki yíe ń jo kí tì liike bù.› ");
INSERT INTO gngNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Utɔ ye: ‹Tien' nni kafala, ma ń fre kí baa, kimɛ n dɛ' inajɛ piik nɛ ki yíe ń jo kí tì wɔkn yɛ̀.› ");
INSERT INTO gngNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Utɔ mɔ ye: ‹N laan kuɔn' upii sɔ, nɛn bo nɛ ma ń fre kí baa.› ");
INSERT INTO gngNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Nɛ utonsɔnl nnɔ liɛbe' uʼcɛnbaa saan, ki tì tɔke' wɔ biʼkɛ len' ma bo. Nɛn saan nɛ uʼcɛnbaa nnɔ ya benku ni ben', nɛ u tɔke' uʼtonsɔnl nnɔ ki ye: ‹Jo tontonm isɛnjɛ nin musɛnbumu ni, kí tì taa ní bijiinb nin itɛjenb nin ijùɔn nin iwɔ̀b, bɛ ń baa kí lá ji.› ");
INSERT INTO gngNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Nɛ utonsɔnl nnɔ liɛbe' ní ki lá tɔke' uʼcɛnbaa ki ye: ‹Cɛnbaa, n tien' a ye ma nnɔ, ama mifɛnm biɛ ki sìen'.› ");
INSERT INTO gngNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Nɛ uʼcɛnbaa tɔke' wɔ ki ye: ‹Nnɔ la, jo isɛn ni nin ikpàan ni, kí tì cɛ́kn binib bɛ ń baa ŋɔ nʼden ń gbe. ");
INSERT INTO gngNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","N tɔkeh nɛ nɛ, binib bà n là kpiɛ' ki yin' bɛ nnɔ uba mɔnɔn ŋa ń lèn nʼjier.› » ");
INSERT INTO gngNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","*Yesu joh ma nnɔ nɛ binib pɛ uʼbo ki yɛbe. U jiɛbe' ki liike' bɛ, nɛ ki tɔke' bɛ ki ye: ");
INSERT INTO gngNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«Unil baa' wɔ ń paan nʼbo, ka yíe nni ki cɛn' uʼnaa nin uʼbaa nin uʼpo nin uʼbumu nin uʼninjiɛb nin uʼninsiɛb nin uʼmiɛl mɔnɔn la, wa kpɛ wɔ ń li yé nʼpanpaankɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Unil wà kɛ ŋa yuunh uʼdɔpɔnpɔn ki bukeh ki paakeh nʼbo la, wa ń fre kí li yé nʼpanpaankɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Niʼni ŋmɛ nɛ yíe wɔ ń mɛ kuduku la, wa ń kpiɛ kí kɛ̀le kí bù kí liike uʼlike li baa bii ya ń baa? ");
INSERT INTO gngNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Wà tien' nnɔ ŋɔ ki pu' kuduku nnɔ ka fre' ki mɛn' ki faa' kù la, binib bà kɛ li lɛ kuduku nnɔ li lɛ̀ wɔ nɛ, ");
INSERT INTO gngNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","kí len kí ye: ‹Liike mɛn udaan wuɔ cin' ki mɛh kuduku nɛ ka fre' ki faa' kù.› ");
INSERT INTO gngNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","U lɛ bɛr ba nɛ ŋmɔbe sojambɛ itur piik ki yíe wɔ ń jo kí tì jɛ̀ke' ubɛrtɔ wà ŋmɔbe sojambɛ itur pile, ŋɔ ka ń kpiɛ kí kɛ̀le kí maale kí liike, u li fre kí taa uʼsojambɛ itur piik nnɔ kí tuobe ubɛrtɔ wà ŋmɔbe sojambɛ itur pile nnɔ bii wa ń fre? ");
INSERT INTO gngNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","U laa' wa ń fre la, wɔn nnɔ laan te fɔkm ma nnɔ, u li sɔn ucɛndɛnduol nɛ wɔ ń cende wɔ usɛn ni kí tɔke wɔ kí ye wɔ ń cère bɛ ń gben tigbɛr nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Nnɔ nɛ niʼni wà kɛ ŋa dàan' u ŋmɔbe nà kɛ la, wa ń fre kí li yé nʼpanpaankɛ.» ");
INSERT INTO gngNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","«Miyaam yé nibonn nà mɔn nɛ. Ama mì saa' ka ji ŋmɛ la, niba ŋa te kí ji ń fre kí ŋmaake mɛ̀. ");
INSERT INTO gngNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Mì li juore fɛnm nɛ, ma ji li ŋmɔbe tuonl. Bi li taa mɛ̀ kí wule nɛ. Wà ŋmɔbe litubl la, wɔ ń cii.» ");
INSERT INTO gngNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Bilɛnpotekb nin bibiɛrdɛntɔb kɛ nɛkndeh *Yesu saan bɛ ń cenge uʼgbɛr. ");
INSERT INTO gngNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Nɛ *Farisiɛnmbɛ nin Yiko ya wɔnwɔknb bunbeh uʼbo ki teh: «Ujɛ wuɔ teknh bibiɛrdɛnb nɛ ki taakeh ki jinh nin bɛ.» ");
INSERT INTO gngNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Nɛn saan nɛ *Yesu pɔn' bɛ mikpɛnjɛnm ki ye: ");
INSERT INTO gngNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«Niʼni ŋmɛ ŋmɔbe ipe kobk ŋɔ uba bole' la, wa ń cère ipe piwɛ nin iwɛ yà sìen' nnɔ kumuɔku ni, kí jo kí tì nuun wà bole' nnɔ haali kí tì lɛ wɔ? ");
INSERT INTO gngNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","U tì laa' wɔ la, uʼyɛnm li sɔnge nɛ wɔ ń yuure wɔ kí buke. ");
INSERT INTO gngNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","U tì baa' iden la, u li yin uʼjɔtieb nin uʼkɔnkuɔnlieb, kí tɔke bɛ kí ye: ‹Cère mɛn tí li poknh, kimɛ n laa' nʼpe wà là bole' nnɔ.› ");
INSERT INTO gngNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Nnɔ nɛ n tɔkeh nɛ, ubiɛrdaan uba mɔnɔn lèbre' uʼtetem la, Uwien ya yɛnm li sɔnge uʼbo kí cɛn binib piwɛ nin biwɛ bà cuube ka ŋmɔbe bɛ ń lèbre biʼtetem nnɔ bo.» ");
INSERT INTO gngNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","«U lɛ pii ba ŋmɔbe milikbim piik ŋɔ miba bole' la, wa ń sɛ lifrl, kí ŋɛ̀re kuduku, kí tùɔre kí nuun kí tì lɛ mɛ̀? ");
INSERT INTO gngNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","U tì laa' mɛ̀ la, u li yin uʼjɔtieb nin uʼkɔnkuɔnlieb kí tɔke bɛ kí ye: ‹Cère mɛn tí li poknh, kimɛ n laa' nʼlikbu bùa là bole' nnɔ.› ");
INSERT INTO gngNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Nnɔ nɛ n tɔkeh nɛ, ubiɛrdaan uba mɔnɔn lèbre' uʼtetem la, Uwien ya tondb li pokn uʼbo.» ");
INSERT INTO gngNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","*Yesu tí ye: «Ujɛ uba nɛ là te ki ŋmɔbe bijiɛb bile. ");
INSERT INTO gngNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Nɛ uwaal tɔke' uʼbaa ki ye: ‹NʼBaa, gbiire aʼfaal kí taa n lá li ji nà bó kí de nni.› Nɛ uʼbaa gbiire' uʼfaal ki de' biʼkɛ bi ya bó. ");
INSERT INTO gngNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Na wuɔke', nɛ uwaal nnɔ taan' uʼfaal kɛ, ki bure' fɔnfɔkm udu uba bó, ki tì te niʼbó ki teh fɛnfɛnm, ki ñɛnde' uʼfaal kɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","U tì ñɛnde' niʼkɛ ki gben', nɛ mikònciɛnm miba lu' udu nnɔ ni. U ya yo nɛ tijiint kɔn' wɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Nɛn saan nɛ u jon' udu nnɔ ya jɛ uba saan wɔ ń taa wɔ lituonl, nɛ ujɛ nnɔ jon' wɔ uʼkpàabó u tì gu fangambɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","U yíe wɔ ń ji fangambɛ nnɔ ya jier mɔnɔn, ama uba ŋa dienh wɔ tù. ");
INSERT INTO gngNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Nɛ u maale' uʼyɛnm ni ki ye: ‹Nʼbaa ya tonsɔnb kɛ jinh ki gbiɛh nɛ, nɛ mikònm benh mɛ̀ ń ku min niɛ saan. ");
INSERT INTO gngNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","N li fii kí liɛbe nʼbaa bó, kí tì tɔke wɔ kí ye: «NʼBaa, n bii' Uwien, ki bii' aʼmɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ma ji kpɛ á yin nni aʼbijɛ. Li teh nni tɛn n yé aʼtonsɔnb ya uba nɛ.» › ");
INSERT INTO gngNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Nɛ ki fii' ki liɛbeh uʼbaa bó. «U tì tuo iden, ki laan biɛ ki te fɔkm, nɛ uʼbaa laa' wɔ, nì cuo' wɔ micɛcɛkm, nɛ u sɛn' ki tuobe' wɔ usɛn bó, ki lɔkn' wɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Nɛ uʼbijɛ tɔke' wɔ ki ye: ‹Nʼbaa, n bii' Uwien, ki bii' aʼmɔ. Ma ji kpɛ á yin nni aʼbijɛ.› ");
INSERT INTO gngNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ama uʼbaa tɔke' uʼtonsɔnb ki ye: ‹Taa mɛn liliɛrmɔnmɔnl ní tonm kí lá goln wɔ, kí piln wɔ miflìm, kí cɛkn wɔ itacaan, ");
INSERT INTO gngNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","kí taa ní unafanfaan wà gbenge, kí lá kòre, tí jele kunacenku. ");
INSERT INTO gngNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Kimɛ n là maaleh ki teh nʼbijɛ wuɔ nɔ kpo' nɛ, jaan u fuobe. U là bole' nɛ, nɛ n piire' wɔ.› Nɛ bi cin' ki jeleh kunacenku. ");
INSERT INTO gngNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","«U ya yo ki laa' uʼbijɛ uciɛn te ukpàabó nɛ. U ñɛn' ukpàabó ní ki lá tuo iden, nɛ ki cii' inacenjelgangaan nin kujaanku bó. ");
INSERT INTO gngNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Nɛ u yin' bitonsɔnb ya uba, ki niire' wɔ nà tien'. ");
INSERT INTO gngNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Nɛ u tɔke' wɔ ki ye: ‹Aʼwaakɛ nɛ liɛbe' ní. U liɛbe' ní nin laanfiɛ ma nnɔ, nɛ aʼbaa cère' bi kòre' unafanfaan wà gbenge.› ");
INSERT INTO gngNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","U cii' nnɔ ma nnɔ nɛ uʼbenku ni ben', u jɛ' ka kɔn', nɛ uʼbaa ñɛn' ki gbáan' wɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Nɛ u tɔke' uʼbaa ki ye: ‹Liike, n sɔnh ŋɛ itùon ibin ibin nɛ, ka yìe' aʼñɔbu bó fiebu, ama ŋa de' nni wɔbuk mɔnɔn, min nin nʼjɔtieb ń jele kunacenku. ");
INSERT INTO gngNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ama aʼbijɛ wuɔ, wɔn là paan' ijɛnkpend bo nɛ, ki tì ñɛnde' aʼfaal ki lá liɛbe' ní, nɛ a kòre' wɔ unafanfaan wà gbenge-a!› ");
INSERT INTO gngNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Nɛ uʼbaa jiin' wɔ ki ye: ‹Nʼbukɛ, sin te nʼsaan uyo kɛ nɛ. Sin nɛ si n ŋmɔbe tibont tà kɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Aʼwaakɛ wɔn, n là maaleh ki teh u kpo' nɛ, jaan u fuobe. U là bole' nɛ, nɛ n piire' wɔ. Nɛn bo nɛ nì kpɛ tí jele kunacenku kí pokn.› » ");
INSERT INTO gngNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","*Yesu tɔke' uʼpanpaankaab ki ye: «Ufàadaan uba nɛ là te ki ŋmɔbe utonsɔnl uba u likeh uʼbont kɛ. Bi linde' uʼpuoli bó ki lá tɔke' uʼcɛnbaa ki ye u ñɛ̀ndeh uʼfaal nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Nɛ uʼcɛnbaa yin' wɔ ki lá niire' wɔ ki ye: ‹N ciih bi lienh aʼbo bɛ ya gbɛr sɔ? Wuɔn nni a tentien' nʼbont ma bo, kimɛ ŋa ji li yé nʼtonsɔnl.› ");
INSERT INTO gngNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Nɛ utonsɔnl nnɔ maale' uʼyɛnm ni ki ye: ‹Nʼcɛnbaa li ñɛn nni lituonl ni ma, n li tien mila? Ma ŋmɔbe tuɔm ń ko kpàar-a! Ki ye n li miɛh mɔ la, nì ŋmɔbe nni ifɛ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Tɔ, n bɛn n li tien ma ŋɔ nʼcɛnbaa ñɛn' nni lituonl ni la, biba ń teke nni biʼden.› ");
INSERT INTO gngNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Nɛ ki yih bà ŋmɔbe uʼcɛnbaa ya fɛ̀nl nnɔ uba uba, nɛ ki niire' ukpiɛk ki ye: ‹A ŋmɔbe nʼcɛnbaa ya fɛ̀nl iŋɛ?› ");
INSERT INTO gngNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Nɛ u ye: ‹Mikpɔm tikucinwawaart kobk.› Nɛ u tɔke' wɔ ki ye: ‹Taa aʼfɛ̀nl ya gbɔnku ní kí kɛ̀le tonm, kí kɛle tikucinwawaart piŋun.› ");
INSERT INTO gngNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Nɛ ki niire' utɔ ki ye: ‹Sin, aʼmɔ ŋmɔbe uʼfɛ̀nl iŋɛ?› Nɛ u ye: ‹Iji tibɔtɔcɛnciɛnt kobk.› Nɛ u tɔke' uʼmɔ ki ye: ‹Taa aʼfɛ̀nl ya gbɔnku kí kɛle tibɔtɔcɛnciɛnt piniin.› ");
INSERT INTO gngNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Utonsɔnl wà ŋa ŋmɔbe gbɛmɔ̀nt nnɔ ya cɛnbaa cii' nnɔ ma nnɔ, nɛ ki pɛ̀ke' wɔ ki ye u ŋmɔbe miyɛnfuom nɛ ki tien' nnɔ. Kimɛ uŋɛndun wuu ya nib ŋmɔbe miyɛnfuom biʼtɔb bo ki cɛn' bà yé Uwien yaab. ");
INSERT INTO gngNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","«N tɔkeh nɛ nɛ, ní li taah uŋɛndun wuu ni ya faal là lɛreh binib, ki coh binib kujɔtieku, ŋɔ lì lá gben' la, Uwien ń teke nɛ uʼden yà tuu ki te ni. ");
INSERT INTO gngNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Wà yé unimɔ̀n nibonwawaann ni la, u li yé unimɔ̀n nɛ niboncɛnciɛnn mɔ ni. Wà ŋa yé nimɔ̀n bonwawaann ni la, wa ń li yé nimɔ̀n boncɛnciɛnn mɔ ni. ");
INSERT INTO gngNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Na yé nimɔ̀nb uŋɛndun wuu ya faal ni la, ŋmɛ ji li de nɛ lifaamɔ̀nl-i? ");
INSERT INTO gngNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Na likeh utɔ ya bont mɔnmɔnm la, ŋmɛ ji li de nɛ niʼyaar-i? ");
INSERT INTO gngNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","«Utonsɔnl uba ŋa ń fre kí li pɛ cɛnbaambɛ bile bo. U li nɛn uba nɛ, kí li yíe utɔ. U li se uba ya ciɛk bó nɛ, kí li likeh utɔ fɛnm. Na ń fre kí li pɛ Uwien bo ki liɛbe' ki pɛ ilike mɔ bo.» ");
INSERT INTO gngNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","*Farisiɛnmbɛ cii' *Yesu len' tigbɛr tà kɛ nnɔ nɛ ki lɛh wɔ, kimɛ bi yíe ilike ki gbien'. ");
INSERT INTO gngNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Nɛ u tɔke' bɛ ki ye: «Ninbi, ni yé binib bà yih niʼba binimɔ̀nb nɛ binib ya nun bó, ama Uwien bɛn niʼfɛ̀l ni te ma bo, kimɛ binib likeh nà tɛn nì yé nibonmɔ̀nn la, nì yé fɛnm nɛ Uwien ya nun bó. ");
INSERT INTO gngNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","«Uwien de' Moyis *yiko wà nnɔ, binib là pɛ wɔn nin *Uwien ya ñɔbonsɔknb ya gbɛr bo nɛ ki tì baa' San ya yo. Kí ñɛ u ya yo nɛ bi tɔke' binib Uwien ya bɛl ya gbɛmɔnmɔnt, nɛ unil kɛ mɔ̀h ki nuunh wɔ ń kɔ liʼni nin ufaa. ");
INSERT INTO gngNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Nin nɛn kɛ ŋɔ nì faa nin Yiko ya gbɛyɔyɔl liba mɔnɔn ń juore fɛnm ki cɛn' kutaaku nin kitink ya gbenm. ");
INSERT INTO gngNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","«Ujɛ wà kɛ wiɛ' uʼpo ki tí kuɔn' upiitɔ la, u tien' linaŋmaal nɛ. Upii ya cɛ wiɛ' wɔ, ujɛtɔ kuɔn' wɔ la, ujɛ nnɔ mɔ tien' linaŋmaal nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","«Ufàadaan uba nɛ là te, ki guoh tiwɛnmɔnmɔnt tà ŋmɔbe kudaaku, ki teh tinacent idaan kɛ, ki jinh nà ŋmɛ, ki poknh. ");
INSERT INTO gngNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ucɛcɛkdaan uba mɔ là dɔ ufàadaan nnɔ ya nañɔjɛbu saan inɛl yèyèke' wɔ niʼkɛ saan, bi yih wɔ Lasaar. ");
INSERT INTO gngNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","U yíe wɔ ń ji ijieyɔyɔl yà ñɛh ufàadaan nnɔ ya tebl bo ki luh nnɔ mɔnɔn ka ń lɛ. Isɛngbɛle nɛ bàareh ki lá liɛreh uʼnɛl nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Nì tete nɛ ucɛcɛkdaan nnɔ lá kpo'. Nɛ Uwien ya tondb baa' ki lá yuure' wɔ ki don' paaki bó *Abraham saan. Ufàadaan nnɔ mɔ lá kpo', nɛ bi sube' wɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","U te kutɛnkpiiku ni ki jɛ̀ndeh, nɛ ki lá yaare' ki laa' *Abraham fɔnfɔkm, ki laa' Lasaar mɔ te uʼsaan. ");
INSERT INTO gngNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Nɛ u wuure' ki ye: ‹Nʼbaa *Abraham, muɔ nni micɛcɛkm, kí sɔn Lasaar wɔ ń tì taa uʼnɔbijom, kí tuun miñunm ni kí lá sèkn nʼlɛnl, kimɛ n jɛ̀ndeh umu wuu ni ki gbiekeh nɛ.› ");
INSERT INTO gngNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Nɛ *Abraham tɔke' wɔ ki ye: ‹Nʼbukɛ, tiɛre kí ye a là fuobe ma nnɔ, a là te liwiel ni nɛ, nɛ Lasaar te ijɛnd ni. Fɛnfɛnnɔ Lasaar ji te uyɛnsɔnge ni nɛ niɛ saan, nɛ sin te ijɛnd ni. ");
INSERT INTO gngNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Nitɔnn mɔ si: kubùoku kùa ñɔ ka ŋmɔbe biɛn nɛ te tinbi nin ninbi ya siik ni, ŋɔ unil yíe wɔ ń ñɛ tiʼsaan kí jo niʼbó la, u la fre, uba mɔ ŋa ń fre kí ñɛ niʼsaan kí baa tiʼbùol.› ");
INSERT INTO gngNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Nɛ ufàadaan nnɔ tɔke' *Abraham ki ye: ‹Wee, nʼbaa, nì te nnɔ la, n gbáanh ŋɛ nɛ, sɔn Lasaar wɔ ń jo nʼbaa den ");
INSERT INTO gngNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","kimɛ nʼninjiɛb biŋun sìen' niʼbó. Wɔ ń tì gbiere bɛ, ŋɔ bi la baa niɛ saan, ki mɔ ń lá li jɛ̀ndeh.› ");
INSERT INTO gngNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Nɛ *Abraham tɔke' wɔ ki ye: ‹Bi ŋmɔbe Uwien de' Moyis *yiko wà nnɔ nin *Uwien ya ñɔbonsɔknb ya gbɛr. Bɛ ń li pɛ *yiko nnɔ bo, kí li cengeh tigbɛr nnɔ teh bà.› ");
INSERT INTO gngNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Nɛ u ye: ‹Nʼbaa *Abraham, na te nnɔ, ba ń cii, ama unil ñɛn' kutɛnkpiiku ni ki jon' biʼsaan la, bi li lèbre biʼtetem.› ");
INSERT INTO gngNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Nɛ *Abraham tɔke' wɔ ki ye: ‹Ba paan' Uwien de' Moyis *yiko wà nnɔ bo, ka cenge' *Uwien ya ñɔbonsɔknb ya gbɛr la, unil mɛkre' bitɛnkpiib ni mɔnɔn la, ba ń tuo kí lèbre biʼtetem.› » ");
INSERT INTO gngNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","*Yesu tɔke' uʼpanpaankaab ki ye: «Nà li cère binib ń tùre Uwien ya sɛn ŋa lì li lúo, ama wà li cère utɔ ń tùre nnɔ, nì bre uʼbo. ");
INSERT INTO gngNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Bi bi taa' linɛ̀ciɛnl ki jɔn' uʼtule ni, ki ture' wɔ ki wiɛ' miñunciɛnm ni la, nì bi li tu uʼbo, nin wɔ ń cère ibaan yiɛ ya uba ń tùre Uwien ya sɛn. ");
INSERT INTO gngNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Nɛn bo, li bɛn mɛn. Aʼtɔ bii' ŋɛ la, wuɔn wɔ uʼbiil. U tuo' ki ye u bii' la, á fère wɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","U bii' ŋɛ uwien uba bolm milole, ki baa' aʼsaan bolm milole ki tɔke' ki ye u bii' ŋɛ la, á fère wɔ.» ");
INSERT INTO gngNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Nɛ uʼtondb tɔke' wɔ ki ye: «Yonbdaan, cère tiʼtekjim ń yɛbre kí pukn.» ");
INSERT INTO gngNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Nɛ u tɔke' bɛ ki ye: «Ni bi ŋmɔbe mitekjim mì waa tɛn kusiiku kùa bi yih kù mutaar nnɔ ya bim mɔnɔn la, ni bi li tɔke busubu buu kí ye bù ń ŋɛbe buʼba kí tì caan miñunciɛnm ni, nɛ bù ń tuo niʼñɔbu bó.» ");
INSERT INTO gngNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","«Niʼni ŋmɛ ŋmɔbe utonsɔnl u koh wɔ bukpàabu bii u kpaah wɔ tiwɛnt, ki ñɛn' niʼbó ní la, u li tɔke wɔ kí ye: ‹Dɛn tonm kí lá ji?› ");
INSERT INTO gngNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Na te nnɔ. U li tɔke wɔ kí ye: ‹Lèbre aʼkpɛlcɛr, kí tien tijier, kí taa kí lá sien nni ń ji kí ñu kí tì gben kí yaan aʼmɔ ń ji kí ñu.› ");
INSERT INTO gngNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Utonsɔnl tien' uʼcɛnbaa ye wɔ ń tien nà la, u li de wɔ faala-aa? ");
INSERT INTO gngNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Niʼmɔ yaam te nnɔ nɛ. Ni tien' Uwien ye ní tien nà kɛ la, ní tɔke kí ye: ‹Ti yé bitonsɔnb bà ŋa nuunh bɛ ń pɛ̀ke tɛ nɛ, ti tien' ti bi li tien nà nɛ.› » ");
INSERT INTO gngNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","*Yesu joh Yerusalɛm ma nnɔ, nɛ ki ñɛn' Samari nin Galile ya tinbiɛn. ");
INSERT INTO gngNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","U tì kɔh udu uba ni uyo wà nnɔ, nɛ ijend piik tobreh wɔ usɛn bó, ki te fɔnfɔkm, ");
INSERT INTO gngNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ki lienh ufaa bo ki teh: «Cɛnbaa Yesu, muɔ tɛ micɛcɛkm.» ");
INSERT INTO gngNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","*Yesu laa' yɛ̀ nɛ ki tɔke' yɛ̀ ki ye: «Li joh mɛn bitɔtuɔrkaab saan bɛ ń tì fìin nɛ.» Ì joh ma nnɔ nɛ ki lùore'. ");
INSERT INTO gngNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Biʼni uba laa' u lùore' ma nnɔ, nɛ ki liɛbe' ní ki lá pɛ̀keh Uwien ufaa bo, ");
INSERT INTO gngNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","nɛ ki gbaan' *Yesu ya nintuɔli, ki faare' wɔ. Ujɛ bugbɛn yé Samari ya nil nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Nɛn saan nɛ *Yesu ye: «Ijend piik nnɔ kɛ ŋa lùore' bi? Biwɛ nnɔ nín te lɛ saan-i? ");
INSERT INTO gngNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ucaan wuɔ baba ŋa ñí la, biʼni uba mɔnɔn ŋa maale' wɔ ń liɛbe ní kí kpiɛke Uwien-a!» ");
INSERT INTO gngNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Nɛ ki tɔke' wɔ ki ye: «Fii, kí li joh, aʼtekjim nɛ ŋmiɛn' ŋɛ.» ");
INSERT INTO gngNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","*Farisiɛnmbɛ niire' *Yesu ki ye: «Uwien ya bɛl li baa ní u lɛ yo ba?» Nɛ u tɔke' bɛ ki ye: «Uwien ya bɛl ya baam ŋa yé bonn nà binib lɛnh nɛ̀. ");
INSERT INTO gngNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ba ń ye: ‹Liike mɛn lì te niɛ saan bii lì te niɛ bó.› Kimɛ Uwien ya bɛl te niʼni nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Nɛ ki tɔke' uʼpanpaankaab ki ye: «Uyo uba we ní, niʼnun li mɔ́n ní tien Unil ya Bijɛ saan liwentunl liba mɔnɔn, ka ń lɛ wɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Bi li tɔke nɛ kí ye: ‹Liike mɛn, u te niɛ bó,› bii ‹U te niɛ saan.› La jo mɛn, ki la jekbeh. ");
INSERT INTO gngNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Kimɛ utɛmɛknde ñɛh kutaaku ya kɛle uba, ki muɔreh ki tì bàareh ukɛltɔ ma bo nnɔ, Unil ya Bijɛ yaam mɔ li te nnɔ nɛ lidaali là u li baa ní nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ama nì kpɛ wɔ ń ji ijɛnd kí gbien nɛ. Fɛnfɛnnɔ ya nib li wiɛ uʼgbɛr nɛ kí yaan tibont nnɔ kɛ ń tien. ");
INSERT INTO gngNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Nì là te ma bo Nowe ya yo nnɔ, Unil ya Bijɛ ya babaayo mɔ lá li te nnɔ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Binib là jinh nɛ ki ñuh, bijɛb kuɔndeh bipiib, bipiib mɔ kunh ticɛr, ki tì baa' lidaali là Nowe kɔn' buñɛrciɛnbu, nɛ miwuɔm kɔn' ki jin' biʼkɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Bii nì li te tɛn nì là te ma bo Lɔt ya yo nɛ. Binib là jinh nɛ ki ñuh, ki teh ukpenkpende, ki koh tikpàar, ki mɛh tidur. ");
INSERT INTO gngNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ama lidaali là Lɔt ñɛn' Sodɔm ya du ni nnɔ, nɛ umu nin mitɛnñɔkjiɛm ñɛn' paaki bó ní utaa yaam ki lá ku' biʼkɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Lidaali là Unil ya Bijɛ lá li puɔ niʼbó ní nnɔ, nì li te nnɔ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","«U ya yo wà te kudulɛkaaku ya paaki, uʼwɛnt te kuduku ni la, u la jiire kí kɔ kí taa tù. Wà mɔ te ikpàan bó la, u la liɛbe kí kun. ");
INSERT INTO gngNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Tiɛre mɛn Lɔt ya po bó. ");
INSERT INTO gngNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Wà nuunh wɔ ń fie uʼmiɛl la, wɔn nɛ li kpo kí juore fɛnm. Wà li tuo kí kpo min bo nnɔ, wɔn nɛ li lɛ limiɛl. ");
INSERT INTO gngNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","N tɔkeh nɛ nɛ, niʼdaali ya ñɔnku, binib bile li dɔ gado uba bo, bɛ ń taa uba kí dàan utɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Bipiib bile li tɛ ki nàanh unɛgɔn uba bo, bɛ ń taa uba kí dàan utɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Bijɛb bile li te bukpàabu ni, bɛ ń taa uba kí dàan utɔ.» ");
INSERT INTO gngNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Nɛ uʼpanpaankaab niire' wɔ ki ye: «Yonbdaan, nì li tien lɛ saan-i?» Nɛ u tɔke' bɛ ki ye: «Liwɛnkpil te nà saan la, inɛnyobl taakeh nɛn nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Nɛ *Yesu pɔn' bɛ mikpɛnjɛnm, wɔ ń wuɔn bɛ kí ye nì mɔn bɛ ń li kàareh uyo kɛ nɛ, ki la cère biʼgbɛnɛnt ń ŋɛnde. ");
INSERT INTO gngNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","U tɔke' ki ye: «Tibuur ya nil uba nɛ là te udu uba ni, ka fɛnge Wien, ka boh nib. ");
INSERT INTO gngNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ukpopii uba mɔ là te udu nnɔ ni, ki bàareh uʼsaan, ki tɔkeh wɔ ki teh: ‹Liike min nin nʼnɛnnɛnd ya gbɛr tuu kí kun nni imɔ̀n.› ");
INSERT INTO gngNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","U tuu ki yìenh nì tì wuɔke', nɛ u maale' uʼyɛnm ni ki ye: ‹Nin ma fɛnge Wien, ka boh nib ma kɛ nnɔ, ");
INSERT INTO gngNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","n li kun wɔ imɔ̀n nɛ, kimɛ u gbien' nni uyɛnŋaabe nɛ. Ma kun' wɔ mɔ̀n la, u li tuu ki bàareh nɛ nʼyɛnm ń tì ñɛ nʼba ni.› » ");
INSERT INTO gngNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","*Yesu tí tɔke' uʼpanpaankaab ki ye: «Ni cii' tibuur ya nil wà ŋa buh buur tuʼdonbó nnɔ len' ma bo-a! ");
INSERT INTO gngNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Uwien nɛ ŋa ji li kun uʼnigɛndkaab bà muɔh ki yih wɔ ñɔnku nin wien ni nnɔ imɔ̀n-ii? U li taande-ee? ");
INSERT INTO gngNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","N tɔkeh nɛ nɛ, u li kun bɛ imɔ̀n na ń taande. Ama Unil ya Bijɛ lá li baa ní uyo wà nnɔ, u li biɛ kí lɛ binib ŋmɔbe mitekjim kitink kiɛ bo-oo?» ");
INSERT INTO gngNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","*Yesu tí pɔn' mikpɛnjɛnm wɔ ń wuɔn binib bà maaleh ki teh bi cuube ki yindeh binitɔb nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","U ye: «Bijɛb bile nɛ don' Uwien ya duku bó, bɛ ń tì kàare. Uba yé Farisiɛn, nɛ utɔ yé ulɛnpotekl. ");
INSERT INTO gngNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Farisiɛn nnɔ se nɛ ki kàareh uʼyɛnm ni ki teh: ‹Uwien, n faareh ŋɛ nin ma te tɛn binitɔb te ma nnɔ bo. Ma suh, ka teh nà bre, ka teh naŋmaal, ka te tɛn ulɛnpotekl wuɔ nɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","N lùoh buñɔbu bolm mile nɛ iwien ilole ni. N lɛnh nà kɛ nnɔ, n gbiinh nɛ̀ bolm piik nɛ, ki taah miba ki dienh ŋɛ.› ");
INSERT INTO gngNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ama ulɛnpotekl nnɔ, wɔn se fɔnfɔkm nɛ, ka kaabe wɔ ń yaare kí liike paaki bó mɔnɔn, ki gbiknh liyul ki teh: ‹O, Uwien muɔ min ubiɛrdaan micɛcɛkm.› ");
INSERT INTO gngNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","N tɔkeh nɛ nɛ, Uwien bù' ulɛnpotekl nnɔ nɛ ugbɛmɔ̀ndaan, u kun', nà yé Farisiɛn nnɔ, kimɛ wà kɛ kpiɛkreh uʼba la, Uwien li yuɔn wɔ nɛ. Wà kɛ jiindeh uʼba tingi la, Uwien li kpiɛke wɔ nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Binib tukeh mucɛnfɛndmu ki bàareh *Yesu saan ŋɔ wɔ ń taa uʼnuɔ kí mɛ mù. Uʼpanpaankaab laa' nnɔ ma nnɔ, nɛ ki kɔnh nin bɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ama *Yesu cère' bi taa' mù ki baa' uʼsaan, nɛ u ye: «Cère mɛn mubuwawaamu mù ń li bàareh nʼsaan. La piendeh mù mɛn, kimɛ binib bà te tɛn mubumu nɛ si Uwien ya bɛl. ");
INSERT INTO gngNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","N tɔkeh nɛ imɔ̀n nɛ, wà kɛ ŋa teke' Uwien ya bɛl ya gbɛr kibuk yaam la, wa ń kɔ liʼni.» ");
INSERT INTO gngNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","*Sufmbɛ ya ciɛn uba niire' *Yesu ki ye: «Cɛnbaa wà mɔn, n li tien mila kí lɛ limiɛl là ŋa ŋmɔbe gbenm-i?» ");
INSERT INTO gngNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Nɛ *Yesu ye: «Bɛ tien' a yih nni wà mɔn-i? Uwien baba ŋa ñí la, uba ŋa mɔn. ");
INSERT INTO gngNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","A bɛn iwɔb yà ye: ‹La teh naŋmaal, ki la ku nil, ki la suh, ki la nɛndeh nib bo, kí li boh aʼnaa nin aʼbaa nnɔ.› » ");
INSERT INTO gngNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Nɛ uciɛn nnɔ tɔke' wɔ ki ye: «N boh niʼkɛ haali nʼbuwaam ni nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","*Yesu cii' nnɔ ma nnɔ nɛ ki tɔke' wɔ ki ye: «Nibonn niba biɛ ki pɔre' ŋɛ. Kuɔre a ŋmɔbe tibont tà kɛ, kí taa ilike nnɔ kí de bijiinb, kí li ŋmɔbe lifaal paaki bó, ŋɔ kí baa kí lá paan nʼbo.» ");
INSERT INTO gngNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ama u cii' nnɔ ma nnɔ nɛ uʼyɛnm saa' ki gbien', kimɛ uʼfaal yɛbe. ");
INSERT INTO gngNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","*Yesu laa' uʼyɛnm saa' ma nnɔ nɛ u ye: «Nì faa ki gbien' nin binib bà ŋmɔbe lifaal ń kɔ Uwien ya bɛl ni. ");
INSERT INTO gngNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Nì faa nin ufàadaan ń kɔ Uwien ya bɛl ni ki cɛn' nin ñɔkma ń càare mikpɛlpienbonm ni.» ");
INSERT INTO gngNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Nɛ binib bà cengeh uʼbó nnɔ ye: «O, nì te nnɔ la, ŋmɛ li fre kí ŋmɛre?» ");
INSERT INTO gngNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Nɛ *Yesu ye: «Binib nɛ ŋa ń fre, Uwien wɔn ŋa gbɛle' niba.» ");
INSERT INTO gngNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Nɛ Piɛr tɔke' wɔ ki ye: «Tinbi wɔn la, ti dàan' tiʼfaal nɛ ki paan' aʼbo-a!» ");
INSERT INTO gngNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Nɛ *Yesu tɔke' bɛ ki ye: «N tɔkeh nɛ imɔ̀n nɛ, unil wà kɛ dàan' uʼden bii uʼpo bii uʼninjiɛb bii uʼnaa bii uʼbaa bii uʼbumu, Uwien ya bɛl bo la, ");
INSERT INTO gngNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","u li lɛ haali kí tì gɛ̀bre tibont tà kɛ u dàan' tù nnɔ fɛnfɛnnɔ wuɔ nɔ. Nɛ uyo wà we ní nnɔ, u li lɛ limiɛl là ŋa ŋmɔbe gbenm mɔ.» ");
INSERT INTO gngNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","*Yesu nin uʼpanpaankaab piik nin bile nnɔ cuonh ki joh, nɛ u tɔke' bɛ ki ye: «Li cengeh mɛn, ti doh Yerusalɛm bó sɔ, *Uwien ya ñɔbonsɔknb là kɛle' nà kɛ Unil ya Bijɛ bo nnɔ li tien nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Kimɛ bi li taa wɔ kí ŋukn bà ŋa yé Sufmbɛ, bɛ ń lɛ̀ wɔ, kí jɛ̀nde wɔ, kí cɛre uʼbo tiñinsɛnt, ");
INSERT INTO gngNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","kí ñì wɔ inalɛbe, kí yaan kí ku wɔ, nɛ wienta daali wɔ ń mɛkre bitɛnkpiib ni.» ");
INSERT INTO gngNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Uʼpanpaankaab nnɔ ŋa cii' niʼtingi, kimɛ iñɔbon nnɔ ya tingi buɔ nɛ, nɛ ba bɛnde' ì ye yɛ̀ ń ye bà. ");
INSERT INTO gngNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","*Yesu tì nɛkn' Seriko ya du ni. Ujuɔn uba là te udu nnɔ ni, ki kaah sɛngbaal ki miɛh binib tibont. ");
INSERT INTO gngNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","U cii' linigol gɛ̀breh ma nnɔ nɛ u niire' ki ye: «Bɛ teh nɔ?» ");
INSERT INTO gngNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Nɛ bi tɔke' wɔ ki ye: «Nasarɛt ya *Yesu nɛ gɛ̀breh.» ");
INSERT INTO gngNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Nɛ u yin' ufaa bo ki ye: «Yesu, *Dafid ya yaabile, muɔ nni micɛcɛkm.» ");
INSERT INTO gngNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Binib bà le *Yesu usɛn nnɔ tɛngeh uʼbo ki teh wɔ ń ŋmile, ama u tùɔreh ki wuureh nɛ ki teh: «*Dafid ya yaabile, muɔ nni micɛcɛkm.» ");
INSERT INTO gngNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Nɛ *Yesu sere' ki ye bɛ ń taa wɔ ní. U nɛkn' *ma nnɔ nɛ Yesu niire' wɔ ki ye: ");
INSERT INTO gngNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«A yíe ń tien bà kí de ŋɛ?» Nɛ u ye: «Yonbdaan, n yíe ń likre nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Nɛ *Yesu ye: «Likre, aʼtekjim nɛ ŋmiɛn' ŋɛ.» ");
INSERT INTO gngNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","U likre' i ya tàan bo, nɛ ki paan' uʼbo, ki pɛ̀keh Uwien. Binib nnɔ kɛ laa' nnɔ ma nnɔ nɛ ki mɔ pɛ̀keh Uwien. ");
INSERT INTO gngNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","*Yesu kɔn' Seriko ya du ni, ki joh wɔ ń càare. ");
INSERT INTO gngNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ujɛ uba là te len, bi yih wɔ Sase, u yé bilɛnpotekb ya ciɛn nɛ, ki yé ufàadaan mɔ, ");
INSERT INTO gngNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","ki nuunh wɔ ń lɛ *Yesu kí bɛnde wɔ. Ama linigol te ma nnɔ, wa fre' ki laa' wɔ, kimɛ u yé kinijenjenk nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Nɛ u sɛn' ki liere' usɛn ki tì don' busubu buba, *Yesu li gɛ̀bre nà saan, ŋɔ u lá gɛ̀breh la, wɔ ń lɛ wɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","*Yesu tì baa' niʼsaan, ki yaare' ki liike', nɛ ki tɔke' wɔ ki ye: «Sase, jiire ní tonm, kimɛ dinnɔ wuɔ nɔ nì kpɛ ń gɔ aʼden nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","U jiire' ní tonm, nɛ ki teke' *Yesu nin uyɛnsɔnge. ");
INSERT INTO gngNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Linigol nnɔ laa' nnɔ ma nnɔ nɛ biʼkɛ bunbeh ki teh: «U jon' ki tì càan' ubiɛrdaan nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Nɛ Sase fii', ki sere', ki tɔke' Yonbdaan ki ye: «Yonbdaan a bɛn-ii! N li gbiire nʼfaal mile kí taa miba kí de bijiinb. N là jin' unil ya bonn la, n li jiin nɛ̀ bolm minan nɛ kí de udaan.» ");
INSERT INTO gngNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Nɛ *Yesu tɔke' wɔ ki ye: «Dinnɔ Uŋmiɛnl baa' iden yii, kimɛ aʼmɔ yé *Abraham ya yaabil nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Unil ya Bijɛ baa' wɔ ń lá nuun bà bole' nɛ, kí ŋmiɛn bɛ.» ");
INSERT INTO gngNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Binib bà cengeh *Yesu ya gbɛr nnɔ maaleh ki teh u nɛke Yerusalɛm ma nnɔ, bi li pɔk kí lɛ Uwien ya bɛl i ya tàan bo nɛ, nɛ u tí pɔn' bɛ mikpɛnjɛnm, ");
INSERT INTO gngNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","ki ye: «Unikpɛkpiɛk uba là yíe wɔ ń jo udu uba bó nì fɔke, bɛ ń tì jin wɔ libɛl wɔ ń liɛbe ní. ");
INSERT INTO gngNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Nɛn saan nɛ u yin' uʼtonsɔnb piik, ki de' unil kɛ milikbim, nɛ ki tɔke' bɛ ki ye: ‹Taa mɛn kí li teh ukpenkpende, kí tì baa uyo wà n li liɛbe ní.› ");
INSERT INTO gngNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Uʼdu ni ya nib là nɛn wɔ, nɛ ki sɔn' binib ki ye bɛ ń upaan uʼbo kí tì tɔke ubɛrciɛn kí ye: ‹Ta yíe ujɛ wuɔ ń li ye tiʼbɛr.› ");
INSERT INTO gngNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ama u jin' libɛl nnɔ, ki liɛbe' ki kun' ní, nɛ ki yin' uʼtonsɔnb bà u là de' bɛ ilike nnɔ ŋɔ wɔ ń liike wà kɛ tien' ukpenkpende, ki laa' kpɛle wà. ");
INSERT INTO gngNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ukpiɛk baa', ki lá tɔke' wɔ ki ye: ‹Cɛnbaa, a là de' nni milikbim mà nnɔ, n taa' mɛ̀ ki tien' ukpenkpende, ki laa' piik ki pukn'.› ");
INSERT INTO gngNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Nɛ u tɔke' wɔ ki ye: ‹Nì mɔn. A yé utonsɔnmɔnmɔn nɛ. A tien' unimɔ̀n nibonwawaann ni ma nɔ, n li cère a li likeh idu piik.› ");
INSERT INTO gngNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Nɛ nle mɔ baa', ki lá tɔke' wɔ ki ye: ‹Cɛnbaa, a là de' nni milikbim mà nnɔ, n taa' mɛ̀ ki tien' ukpenkpende, ki laa' miŋun ki pukn'.› ");
INSERT INTO gngNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Nɛ u tɔke' uʼmɔ ki ye: ‹Li yé idu iŋun ya ciɛn.› ");
INSERT INTO gngNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Nɛ utɔ mɔ baa', ki lá tɔke' wɔ ki ye: ‹Cɛnbaa, liike, aʼlikbim nnɔ sɔ. N là pɔbn' mɛ̀ kukpɛlciɛku ni nɛ ki bɔle'. ");
INSERT INTO gngNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Kimɛ n fɛnge ŋɛ nɛ. Aʼgbɛr faa nɛ, a yuunh ŋa ble' nà, nɛ ki ceh ŋa bule' nà.› ");
INSERT INTO gngNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Nɛ u tɔke' wɔ ki ye: ‹Utonsɔnbiɛrɔ sin, a len' ki lòle' aʼba nɛ. N li ñi nɛn bo nɛ kí bu ŋɛ tibuur. A ye a bɛn nʼbó, nʼgbɛr faa nɛ, n yuunh ma ble' nà, nɛ ki ceh ma bule' nà. ");
INSERT INTO gngNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Bɛ tien' ŋa nín taa' nʼlike ki tì ble' banki n lá baa' ní la, ń lɛ nʼlike nin kpɛle kí pukn-i?› ");
INSERT INTO gngNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Nɛ ki tɔke' bà te niʼsaan nnɔ ki ye: ‹Fie mɛn uʼsaan milikbim nnɔ, kí taa kí pukn wà ŋmɔbe milikbim piik nnɔ.› ");
INSERT INTO gngNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Nɛ bi tɔke' wɔ ki ye: ‹Cɛnbaa, u ŋmɔbe milikbim piik-a!› ");
INSERT INTO gngNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Nɛ u ye: ‹N tɔkeh nɛ nɛ, wà kɛ ŋmɔbe la, bi li de wɔn nɛ kí pukn. Wà ŋa ŋmɔbe la, bi li tonde kí fie u ŋmɔbe nà waamu nnɔ mɔnɔn nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Nʼnɛnnɛndb bɛn wɔn, ba là yíe ń li yé biʼbɛr. Nɛn bo, taa mɛn bɛ ní, kí lá kòkòre bɛ nʼnun bó.› » ");
INSERT INTO gngNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","*Yesu pɔn' bɛ mikpɛnjɛnm nnɔ ki tì gben', nɛ ki liere' bɛ usɛn bi doh Yerusalɛm bó. ");
INSERT INTO gngNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","U tì nɛkn' Bɛtifaaje nin Betani ya du. Ì te lijuɔl liba saan nɛ, bi yih lɛ̀ Olifi ya siin ya juɔl. Nɛn saan nɛ u sɔn' uʼpanpaankaab bile ");
INSERT INTO gngNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ki ye: «Li joh mɛn udu wà te inun bó nɔ ni. Ni tì kɔn' uʼni la, ni li lɛ uŋuunfanfaan uba lùo. Uba ŋa laan jɛ̀ke' wɔ. Ní lore wɔ kí taa ní. ");
INSERT INTO gngNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Unil niire' nɛ ki ye bɛ tien' ni loreh wɔ la, ní tɔke wɔ kí ye: ‹Yonbdaan nɛ ciɛke wɔ.› » ");
INSERT INTO gngNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","*Yesu sɔn' bà nnɔ, bure' ki tì laa' tibont nnɔ kɛ te tɛn u bi tɔke' bɛ ma bo. ");
INSERT INTO gngNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Bi loreh uŋuunfanfaan nnɔ uyo wà nnɔ, nɛ uʼdɛnb niire' bɛ ki ye: «Bɛ tien' ni loreh wɔ?» ");
INSERT INTO gngNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Nɛ bi jiin' bɛ ki ye: «Yonbdaan nɛ ciɛke wɔ.» ");
INSERT INTO gngNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Nɛ ki tuke wɔ ki baa' *Yesu saan, nɛ ki taa' biʼliɛrgbengt ki paan' uŋuunfanfaan nnɔ bo, ki cère' *Yesu jɛ̀ke'. ");
INSERT INTO gngNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","U joh ma nnɔ nɛ binib taah biʼliɛrgbengt ki pɛ̀reh usɛn ni. ");
INSERT INTO gngNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","U tì nɛkn' Yerusalɛm ki baa' Olifi ya siin ya juɔl ya tintindbùol, nɛ uʼpanpaankaab kɛ ligol cin' ki poknh, ki lienh ufaa bo ki pɛ̀keh Uwien bi là laa' *Yesu tien' miyɔkm ya bont tà kɛ nnɔ bo, ");
INSERT INTO gngNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","ki wuureh ki teh: «Uwien ya mɔnm ń li te ubɛr wà we ní Yonbdaan ya yel bo nnɔ bo. Uyɛnduɔn ń li te paaki bó, pɛ̀ke mɛn Uwien paaki bó.» ");
INSERT INTO gngNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","*Farisiɛnmbɛ bà te linigol nnɔ ni ya biba tɔke' *Yesu ki ye: «Cɛnbaa, tɔke aʼpanpaankaab biɛ bɛ ń ŋmile.» ");
INSERT INTO gngNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Nɛ *Yesu tɔke' bɛ ki ye: «N tɔkeh nɛ nɛ, bi ŋmile' mɔnɔn la, itɛn li wuure kí pɛ̀ke nni nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","*Yesu nɛkn' Yerusalɛm ya du, ki laa' wù ma nnɔ nɛ ki muɔh uʼbo, ");
INSERT INTO gngNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ki teh: «Yerusalɛm, a bi bɛn uyɛnduɔn ya sɛn dinnɔ la, nì bi li mɔn aʼbo. Ama fɛnfɛnnɔ ŋa ji li lɛ wù, kimɛ u buɔ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Uyo uba we ní aʼnɛnnɛndb lá li ñɛ niʼkɛ bó ní kí lá jebe ŋɛ, ");
INSERT INTO gngNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","kí ku aʼnib kɛ, kí bere aʼdur kɛ, ka ń cère tɛnl liba ń juore kí li pɛ tɔl bo, kimɛ ŋa bɛnde' uyo wà Uwien baa' wɔ ń tore ŋɛ.» ");
INSERT INTO gngNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","*Yesu kɔn' Uwien ya duku ya luo bo, nɛ ki cin' ki ŋuɔh bà kuɔreh tibont uʼbo nnɔ ki ñɛndeh. ");
INSERT INTO gngNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Nɛ ki tɔkeh bɛ ki teh: «Nì kɛle' *Uwien ya gbɔnku ni ki ye: ‹Nʼduku li yé ikaare ya duku nɛ, ama ninbi taa' kù ki tien' binasub ya tantaanbùol nɛ.› » ");
INSERT INTO gngNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Idaan kɛ *Yesu te Uwien ya duku ya luo bo nɛ, ki wɔknh binib Uwien ya gbɛr. Nɛ bitɔtuɔrciɛnb nin *Yiko ya wɔnwɔknb nin *Sufmbɛ ya ciɛnb nuunh bɛ ń ku wɔ, ");
INSERT INTO gngNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","ka laa' bi li ñɛ isɛn yà, kimɛ binib kɛ ya nun mɔ́n bɛ ń cenge uʼgbɛr nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Lidaali liba nɛ *Yesu te Uwien ya duku ya luo bo, ki wɔknh binib Uwien ya gbɛr, ki tɔkeh bɛ tigbɛmɔnmɔnt, nɛ bitɔtuɔrciɛnb nin *Yiko ya wɔnwɔknb nin *Sufmbɛ ya ciɛnb baa', ");
INSERT INTO gngNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ki lá niire' wɔ ki ye: «Tɔke tɛ, a ŋmɔbe usɛn a tien' a teh nà nɔ-ɔɔ? Ŋmɛ nɛ de' ŋɛ u ya sɛn-i?» ");
INSERT INTO gngNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Nɛ u jiin' bɛ ki ye: «Nʼmɔ li niire nɛ iniire iba nɛ. Tɔke nni mɛn. ");
INSERT INTO gngNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","San là siih binib Uwien ya ñunm ma nnɔ, ŋmɛ là de' wɔ usɛn-i? Uwien bii binib nɛ?» ");
INSERT INTO gngNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Nɛn saan nɛ bi tɔkeh tɔb ki teh: «Ti ye Uwien nɛ de' wɔ usɛn la, u li niire tɛ kí ye: ‹Bɛ tien' ta là teke' wɔ ki jin'-i?› ");
INSERT INTO gngNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ti tí ye binib nɛ de' wɔ usɛn la, linigol liɛ li yèke tɛ itɛn kí ku tɛ, kimɛ biʼkɛ tuo' ki ye San là yé *Uwien ya ñɔbonsɔknl nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Nɛ bi jiin' *Yesu ki ye ba bɛn wà là de' San usɛn. ");
INSERT INTO gngNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Nɛ uʼmɔ ye: «Nʼmɔ ŋa bɛn, ka ń tɔke nɛ wà de' nni usɛn ń tien n teh nà nɔ mɔ.» ");
INSERT INTO gngNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ni ya puoli bó nɛ u pɔn' binib mikpɛnjɛnm ki ye: «Ujɛ uba nɛ là ŋmɔbe bukpàabu, ki caan' bukpàabu nnɔ ni tisir tà bi taah tuʼbii ki ŋɛh fɛn nnɔ, ki taa' bù ki guun' bikpàab biba, nɛ ki bure' usɛn, ki tì wuɔke' niʼbó. ");
INSERT INTO gngNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Uyo wà isibii nnɔ tì ben' nnɔ, nɛ u sɔn' utonsɔnl uba bikpàab nnɔ saan bɛ ń tì de wɔ u ya bó ní. Ama bikpàab nnɔ tì ñi' wɔ, ki ŋɔre' wɔ u bure' inɔpien. ");
INSERT INTO gngNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Nɛ u tí sɔn' utonsɔntɔ, bi tí ñi' uʼmɔ, ki suke' wɔ, ki ŋɔre' uʼmɔ u bure' inɔpien. ");
INSERT INTO gngNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Nɛ u tí liɛbe' ki sɔn' nta, bi tí ñi' uʼmɔ ki bunbunge' wɔ, nɛ ki ŋɔre' wɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Nɛ ukpɛdaan nnɔ ye: ‹N li tien mila? N li sɔn nʼbijɛ wà n yíe wɔ nɛ. Nba la, bi li tì bo wɔn.› ");
INSERT INTO gngNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ama bikpàab nnɔ laa' uʼbijɛ nnɔ we ní ma nnɔ, nɛ bi tɔke' tɔb ki ye: ‹Wɔn nɛ yé uʼfaajil, cère mɛn tí ku wɔ ŋɔ lifaal nnɔ ń juore tiʼyaal.› ");
INSERT INTO gngNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Nɛ bi ñɛn' wɔ ukpɛgbɛ, ki tì ku' wɔ. «Nɛn bo ukpɛdaan nnɔ li tien bɛ mila? ");
INSERT INTO gngNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","U li baa kí lá ku bikpàab nnɔ, nɛ kí taa bukpàabu nnɔ kí guun bikpɛtɔb.» Linigol nnɔ cii' u len' nnɔ ma nnɔ, nɛ bi ye: «Uwien la cère nɛ̀ ń tien.» ");
INSERT INTO gngNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","*Yesu caan' biʼbo inun nɛ ki ye: «Na te nnɔ la, nà kɛle' *Uwien ya gbɔnku ni ki ye: ‹Litɛnl là bidumɛb wiɛ' lɛ̀ nnɔ, lɛn nɛ lá tien' litɛnkpiɛkl là co kuduku› nnɔ ya tingi si ba?» ");
INSERT INTO gngNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Wà kɛ lu' litɛnl nnɔ bo la, u li kɔkuɔ nɛ. Litɛnl nnɔ lu' wà mɔ bo la, lì li mɛmɛre wɔ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","*Yiko ya wɔnwɔknb nin bitɔtuɔrciɛnb bɛnde' ki ye *Yesu pɔn' bɛn nɛ mikpɛnjɛnm nnɔ. Nɛn bo nɛ bi nun mɔ́n bɛ ń cuo wɔ i ya tàan bo, nɛ ki fɛnge' linigol nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","U ya yo nɛ bi cin' ki pingeh Yesu, nɛ ki sɔn' bifinfiinb biba uʼsaan, bɛ ń li teh tɛn bi yé binimɔ̀nb nɛ ki yíe bɛ ń cenge uʼgbɛr, ŋɔ kí dule uʼlenm bo kí cuo wɔ, kí ŋukn udu nnɔ ya gobina. Wɔn nɛ ŋmɔbe mituɔm udu nnɔ bo. ");
INSERT INTO gngNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Nɛ bi baa' ki lá niire' wɔ ki ye: «Cɛnbaa, ti bɛn ki ye a lienh nà nin a wɔknh binib nà kɛ nnɔ cuube nɛ, ki bɛn ki ye ŋa boh uba ki cɛn' utɔ, ki wɔknh mɔnmɔnm binib li tien ma kí li pɛ Uwien ya sɛn bo. ");
INSERT INTO gngNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Tɔke tɛ, ti ŋmɔbe usɛn tí li pɛ̀h lɛnpo ki dienh ubɛrciɛn Sesa bii ta ŋmɔbe?» ");
INSERT INTO gngNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ama *Yesu bɛn biʼcekn nɛ ki tɔke' bɛ ki ye: ");
INSERT INTO gngNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«Wuɔn nni mɛn milikbim miba.» Bi wuɔn' wɔ, nɛ u niire' bɛ ki ye: «Ŋmɛ si kunɛnnɛnku nin liyel là te miʼbo nɔ?» Nɛ bi ye: «Ubɛrciɛn Sesa.» ");
INSERT INTO gngNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Nɛ u tɔke' bɛ ki ye: «Taa mɛn nà yé Sesa yaann kí de Sesa, kí taa nà mɔ yé Uwien yaann kí de Uwien.» ");
INSERT INTO gngNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ba fre' ki laa' bi li dule nà bo kí cuo *Yesu uʼlenm ni binib ya nun bó. Uʼlenm ni, u jiin' biʼniire ma bo nnɔ cuo' bɛ miyɔkm, nɛ ba ji ye niba. ");
INSERT INTO gngNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Saduseyɛnmbɛ biba mɔ nɛkn' Yesu. Bɛn nɛ lienh ki teh bitɛnkpiib ŋa ń mɛkre nnɔ. Bi niire' wɔ ");
INSERT INTO gngNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","ki ye: «Cɛnbaa, Moyis là kɛle' yiko ki de' tɛ ki ye: ‹Unil ya ninjɛ kpo' ki cère' uʼpo, ka ŋmɔbe buk la, wɔ ń kere ukpopii nnɔ, kí maa mubumu kí de uʼninjɛ wà kpo' nnɔ.› ");
INSERT INTO gngNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Tɔ, ninjiɛb bilole biba nɛ là te, nɛ ukpiɛk lá kuɔn' upii, ki kpo', ka maa' buk. ");
INSERT INTO gngNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Nɛ ulie kere' ukpopii nnɔ, ki mɔ kpo', ka maa' buk. ");
INSERT INTO gngNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Nta mɔ tien' nnɔ, ki mɔ kpo', ka maa' buk. Bi teteh nnɔ nɛ jɛb bilole nnɔ kɛ tì kuɔn' upii nnɔ ki bòn', ki kpo', ka maa' buk. ");
INSERT INTO gngNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Upii nnɔ mɔ tì fɔre' ki kpo'. ");
INSERT INTO gngNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Tɔ, bitɛnkpiib lá mɛkre' uyo wà la, ŋmɛ li si upii nnɔ? Kimɛ biʼkɛ bilole kuɔn' wɔ ki tì bòn' nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Nɛ *Yesu tɔke' bɛ ki ye: «Uŋɛndun wuu ni nɛ bijɛb kuɔndeh bipiib, bipiib kunh ticɛr. ");
INSERT INTO gngNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ama binib bà Uwien ye bi kpɛ bɛ ń mɛkre bitɛnkpiib ni, kí li yé uŋɛndun wà we ní yaab nnɔ; wun ni jɛb ŋa ń kuɔn piib, bipiib mɔ ŋa ń kun cɛr. ");
INSERT INTO gngNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ba ji li kpo, kimɛ bi li te tɛn Uwien ya tondb nɛ. Bi li mɛkre ma nnɔ, bi li yé Uwien ya bumu nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Moyis mɔnɔn là wuɔn' tɛ nì wien ki ye bà kpo' li mɛkre. U laa' nà saan kufɛtuku kuba kù teknh umu ka wih nnɔ, u yin' Yonbdaan ki ye *Abraham nin *Isaak nin Sakɔb ya Wien nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Uwien ŋa yé tɛnkpiib ya Wien, u yé bà fuobe ya Wien nɛ, kimɛ wɔn bo biʼkɛ fuobe nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Nɛ *Yiko ya wɔnwɔknb biba tɔke' *Yesu ki ye: «Cɛnbaa, a len' mɔnmɔnm.» ");
INSERT INTO gngNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Nɛ uba ŋa ji kaabe' wɔ ń niire wɔ niire niba bo. ");
INSERT INTO gngNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Nɛ *Yesu niire' bɛ ki ye: «Nì tien' mila, binib lienh ki teh Uwien ya Nigɛndkɛ Kristo yé *Dafid ya yaabil-i? ");
INSERT INTO gngNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Kimɛ *Dafid bugbɛn là len' Uwien ya yuon ya gbɔnku ni ki ye: ‹Yonbdaan Uwien tɔke' nʼYonbdaan ki ye: Kɛ̀le nʼnɔjie bó, ");
INSERT INTO gngNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","kí tì baa uyo wà n li cère á tɛ aʼnɛnnɛndb bo litaal.› ");
INSERT INTO gngNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","*Dafid yih *Uwien ya Nigɛndkɛ Kristo uʼYonbdaan la, u ji tien' mila ki liɛbe' ki yé uʼyaabil mɔ?» ");
INSERT INTO gngNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Linigol nnɔ cengeh *Yesu ya gbɛr, nɛ u tɔke' uʼpanpaankaab ki ye: ");
INSERT INTO gngNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«Li bɛn mɛn *Yiko ya wɔnwɔknb bó. Bi yíe bɛ ń li guoh tiliɛrgbengt nɛ ki gaakeh, ki yíe binib ń li gbaandeh ki fuondeh bɛ mudaamu ni, ki yíe bɛ ń li kaah binikpɛkpiɛkb ya kànkàan itáan ya dur nin tinacent ni. ");
INSERT INTO gngNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Bɛn nɛ jinh ki pendeh bikpopiib, ki kàareh nì wuɔkreh ŋɔ binib ń ye bi yé binimɔ̀nb. Uwien li dɛre biʼtub kí gbien kí cɛn binitɔb.» ");
INSERT INTO gngNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","*Yesu liike', ki laa' bifàadɛnb bàareh ki kpìendeh ilike Uwien ya pum ya likkpienbùol, ");
INSERT INTO gngNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","ki laa' ukpopiicɛcɛkdaan uba mɔ baa' ki lá kpìen' milikbim mile. ");
INSERT INTO gngNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Nɛ u ye: «N tɔkeh nɛ imɔ̀n nɛ, ukpopicɛcɛkdaan wuɔ kpìen' ilike ki cɛn' biʼkɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Kimɛ biʼkɛ de' ka pɔkre' biʼlike ya pɔkl. Ama wɔn yé ucɛcɛkdaan nɛ, nɛ ki tonde' u ŋmɔbe nà kɛ nnɔ ki baa', ki lá kpìen'.» ");
INSERT INTO gngNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Binib lienh Uwien ya duku ya gbɛr ki teh bi taa' itɛn yà ki mɛn' kù nnɔ nin binib pun' Uwien tibont tà, bi taa' ki tien' kuʼni nnɔ mɔn cɛɛn. Nɛ *Yesu tɔke' bɛ ki ye: ");
INSERT INTO gngNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","«Ni likeh nà nɔ, uyo uba we ní, tɛnl ŋa ń juore kí li pɛ tɔl bo, bi li bere niʼkɛ nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Nɛ bi niire' wɔ ki ye: «Cɛnbaa, nì li tien nnɔ u lɛ yo ba? Ku lɛ dìɛku ba li wuɔn tɛ kí ye uyo baa'?» ");
INSERT INTO gngNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Nɛ u jiin' bɛ ki ye: «Li bɛn mɛn, ki la cère uba ń tuln nɛ. Kimɛ binib lá li baa ki yɛbe, kí li ŋmɔbe nʼyel ki teh bi yé min nɛ, kí tɔke kí ye uyo nnɔ baa' ŋɔ. Ni la paan biʼbo. ");
INSERT INTO gngNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ni lá cii' binib tɔh lituɔl kɔnkɔnm, ki cii' binib yìenh biʼbɛrb ya ñuɔn bó la, ni la cère nɛ̀ ń cuo nɛ jɛwaanbu, kimɛ tu ya bont kɛ li tien nɛ kí yaan. Ama na yé uŋɛndun li pɔk kí gben i ya tàan bo nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Nɛn saan nɛ u tí tɔke' bɛ ki ye: «Linibol liba li jɛ̀ke linibotɔl. Libɛl liba ya nib mɔ li jɛ̀ke libɛtɔl yaab. ");
INSERT INTO gngNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Kitink li jènge kí gbien, nɛ mikònm nin iwiɛnbiɛre mɔ ń lu bùol, bùol. Micincilnciɛnm li tien kutaaku bo. ");
INSERT INTO gngNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","«Ama kí yaan nɛn kɛ ń tien nnɔ, bi li cuo nɛ, kí jɛ̀nde nɛ, kí cère bɛ ń bu nɛ tibuur *Sufmbɛ ya táan ya dur ni, kí taa nɛ kí jon lipɛkl. Min bo nɛ bi lá li tuke nɛ kí jon tibuur bibɛrb nin idu ya ciɛnb saan. ");
INSERT INTO gngNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Nnɔ nɛ ni li yé nʼmɔ̀nkunb biʼsaan. ");
INSERT INTO gngNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Taa mɛn kí ble niʼyul ni kí ye na ń li nuunh ni li tì len ma kí ŋmɛre. ");
INSERT INTO gngNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Kimɛ min nɛ li tɔke nɛ, ni li tì len ma bo nin miyɛnfuom, ŋɔ niʼnɛnnɛndb ya uba la fre kí niɛ nin nɛ, ki la fre kí len kí jiin nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Haali niʼbaambɛ nin niʼnaambɛ nin niʼninjiɛb nin niʼyaab nin niʼjɔtieb mɔnɔn li kuɔre nɛ. Nɛ bi li ku niʼni biba. ");
INSERT INTO gngNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Min bo nɛ binib kɛ li nɛn nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ama niʼni uba mɔnɔn ya yul ŋa ń gàare. ");
INSERT INTO gngNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ni mìnde' ijɛnd kɛ ni la, ni li lɛ limiɛl là ŋa ŋmɔbe gbenm.» ");
INSERT INTO gngNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","«Ni lá laa' sojambɛ jebe' Yerusalɛm ya du uyo wà la, li bɛn mɛn kí ye bi li bere wù, na ń taande. ");
INSERT INTO gngNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Uyo nnɔ lá baa' la, bà te Sude ya tinfɛnm ni nnɔ, bɛ ń sɛn kí jo ijuɔn bó. Bà mɔ te Yerusalɛm ni la, bɛ ń sɛn kí ñɛ uʼni. Bà mɔ te idugbaan bó la, bi la ji ń kɔ udu ya benku ni. ");
INSERT INTO gngNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Kimɛ u ya yo nɛ Uwien li dɛre Yerusalɛm ya nib ya tub, ŋɔ nà kɛ kɛle' *Uwien ya gbɔnku ni nnɔ ń tien. ");
INSERT INTO gngNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","U ya yo, bipiib bà punbe' nin bà ŋmɔbe mubumu mùa ŋaanh, li ŋmɔbe micɛcɛkm nɛ, kimɛ Uwien ya benku ni ben' udu nnɔ ya nib bo ma nnɔ, bi li jɛ̀nde kí gbien. ");
INSERT INTO gngNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Bi li ku biba nin kijusiek, kí cuo bitɔb kí jon inibol kɛ ya du bó, nɛ bà ŋa yé *Sufmbɛ nnɔ li ŋuuke Yerusalɛm bugbɛn kí tì baa uyo wà Uwien sien' nnɔ.» ");
INSERT INTO gngNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","«Micincilnm ya bont li tien uwien nin uŋmaal nin iŋmaabii bo. Iñungbegbel li fii miñunciɛnm bo, kí li ŋmɔbe kuwaaku kí gbien, kí ŋaabe binib ya yɛnm ba ji li bɛn bi li tien ma. ");
INSERT INTO gngNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Tibont tà ŋmɔbe paaki bó mituɔm li jènge, binib li maaleh nà li tu uŋɛndun wuu nɔ bo nɛ biʼfɛ̀l ń sɛn kí tì kɛnde. ");
INSERT INTO gngNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","U ya yo nɛ bi li lɛ Unil ya Bijɛ te kutɛwɔlgbɔnku ni, ki we ní, ki ŋmɔbe ufaa nin ukpiɛke ki gbien'. ");
INSERT INTO gngNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ni lá laa' tu ya bont kɛ cin' ki teh la, ní cuo niʼba, kí cère niʼyul ń li cɛ, kimɛ niʼŋmɛŋmɛryo nɛkn' ní ŋɔ.» ");
INSERT INTO gngNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yesu tí pɔn' bɛ mikpɛnjɛnm ki ye: «Sekn mɛn bukɛnkɛnbu nin isitɔ kɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ni lá laa' ì bundeh la, ninbi nin niʼyul bɛn kí ye nì nɛke uñalɛnd nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Niʼmɔ yaam te nnɔ nɛ. Ni lá laa' tibont nnɔ teh la, ní li bɛn kí ye Uwien ya bɛl nɛkn' ní ŋɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","«N tɔkeh nɛ imɔ̀n nɛ, tibont nnɔ kɛ li tien, kí lɛ fɛnfɛnnɔ ya nib biɛ ŋa laan kpo' ki gben'. ");
INSERT INTO gngNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Kutaaku nin kitink li gben, ama nʼgbɛr tun ŋa ŋmɔbe tù ń gben.» ");
INSERT INTO gngNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","«Liike mɛn niʼyul bo, ki la cère tidɛyibr nin ujinciɛn nin uŋɛndun ya bont ya nuunm ń yɛbre niʼfɛ̀l ni ŋɔ Unil ya Bijɛ ya babaadaali la pìln nɛ, ");
INSERT INTO gngNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","tɛn bubɛbu pìlndeh ijɛn ma bo, kimɛ Unil ya Bijɛ ya baam li ci binib bà kɛ te utingbɛn bo nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","La gɔh mɛn, kí li kàareh uyo kɛ, ŋɔ kí lɛ mituɔm kí ñɛ ijɛnd yà kɛ we ní nnɔ ni, kí fre kí sere Unil ya Bijɛ ya nun bó.» ");
INSERT INTO gngNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Uwien ni la, *Yesu te Uwien ya duku ya luo bo nɛ ki wɔknh binib Uwien ya gbɛr, nɛ nì biire' la, u joh ki tì gɔh Olifi ya siin ya juɔl bo. ");
INSERT INTO gngNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Nɛ udu ya nib kɛ bàareh uʼsaan Uwien ya duku ya luo bo kutɛnŋɛsɔnsɔnku ki cengeh uʼgbɛr. ");
INSERT INTO gngNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Kpɔnɔ wà ŋa ŋmɔbe ñɔke ya nacenku kùa bi yih kù *Sufmbɛ ya Pak nnɔ nɛkn' ní. ");
INSERT INTO gngNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Nɛ bitɔtuɔrciɛnb nin *Yiko ya wɔnwɔknb nuunh bi li tien ma kí ku Yesu, nɛ ki ji fɛnge udu ya nib. ");
INSERT INTO gngNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Nɛn saan nɛ *Satan kɔn' Sudas Iskariyɔt ya fɛ̀l ni. U yé *Yesu ya panpaakaab piik nin bile nnɔ ya uba nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","U jon' bitɔtuɔrciɛnb nin Uwien ya duku ya guguurb ya ciɛnb saan, wɔ ń tì tɔke bɛ u li tien ma kí taa *Yesu kí ŋukn bɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Biʼyɛnm sɔnge' cɛɛn, nɛ bi kpaan' buñɔbu ki ye bi li de wɔ ilike. ");
INSERT INTO gngNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","U tuo', nɛ ki nuunh u li ñɛ isɛn yà kí taa *Yesu kí ŋukn bɛ ki la cère linigol nnɔ ń bɛnde. ");
INSERT INTO gngNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Lidaali là bi jeleh kpɔnɔ wà ŋa ŋmɔbe ñɔke ya nacenku nnɔ baa'. Nɛn daali nɛ bi kòreh *Sufmbɛ ya Pak ya pefanfaan. ");
INSERT INTO gngNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Nɛ *Yesu sɔn' Piɛr nin San ki tɔke' bɛ ki ye: «Jo mɛn kí tì tien tɛ Pak ya jier tí ji.» ");
INSERT INTO gngNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Nɛ bi niire' wɔ ki ye: «A yíe tí tien kuʼjier lɛ saan-i?» ");
INSERT INTO gngNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Nɛ u ye: «Cenge mɛn, ni tì kɔn' udu ni la, ni li lɛ ujɛ uba tuke liñuncuɔl ki cendeh nɛ. Ní paan uʼbo, kí tì kɔ u li kɔ iden yà ni nnɔ ni, ");
INSERT INTO gngNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","kí tɔke udendaan ki ye: ‹TiʼCɛnbaa ye wɔn nin uʼpanpaankaab li ji Pak ya nacenku ya jier ku lɛ duku ni?› ");
INSERT INTO gngNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","U li wuɔn nɛ lidutɔtuɔl ya paaki ya duciɛnku kuba, bi bonde' kù ŋɔ. Ní tien kunacenku nnɔ ya jier kun ni.» ");
INSERT INTO gngNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Bi bure', ki tì baa' ki laa' *Yesu bi tɔke' bɛ ki ye bi li lɛ nà nnɔ kɛ, nɛ ki tien' kunacenku nnɔ ya jier. ");
INSERT INTO gngNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Tijier nnɔ ya jijiyo baa', nɛ *Yesu nin uʼtondb kɛ̀le' ki jinh. ");
INSERT INTO gngNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Nɛ u tɔke' bɛ ki ye: «Nʼnun là mɔ́n min nin ninbi ń taan kí ji kunacenku ya jier nɛ kí yaan ń jɛ̀nde. ");
INSERT INTO gngNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","N tɔkeh nɛ nɛ, kimɛ ma ji li ji kuʼjier kí tì baa uyo wà kuʼtingi li tùɔre kí wende Uwien ya bɛl ni.» ");
INSERT INTO gngNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Nɛ ki taa' midaam, ki faare' Uwien ki ye: «Teke mɛn midaam miɛ kí gbiire. ");
INSERT INTO gngNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","N tɔkeh nɛ nɛ, ma ji li faa kí ñu sibii ya daam, kí tì baa uyo wà Uwien ya bɛl li baa ní.» ");
INSERT INTO gngNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Nɛ ki taa' kpɔnɔ, ki faare' Uwien, ki kɔkuɔ', ki taa' ki de' bɛ, nɛ ki ye: «Nà sɔ yé nʼgbɛnɛnt, n taa' ki de' nɛ. Li teh mɛn nnɔ kí li tiɛn nʼbó.» ");
INSERT INTO gngNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Bi jin' ki tì gben', nɛ u taa' midaam mɔ, ki faare' Uwien, nɛ ki ye: Midaam miɛ yé nʼsɛ̀m nɛ, ki wɔngeh ki teh Uwien cuo' nin binib kujɔtiefɛ̀nku. Ninbi bo nɛ mì li puube. ");
INSERT INTO gngNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","«Liike mɛn, wà li kuɔre nni nnɔ kɛ niɛ saan ki jinh nin nni. ");
INSERT INTO gngNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Unil ya Bijɛ li kpo Uwien sien' wɔ ma bo nɛ. Ama unil wà li kuɔre wɔ nnɔ, nì bre udaan bo. ");
INSERT INTO gngNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Nɛ uʼpanpaankaab cin' ki niireh tɔb ki teh: ‹Tiʼni ŋmɛ li tien ni ya bonn-i?› » ");
INSERT INTO gngNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Uyo uba nɛ *Yesu ya panpaankaab findeh nin tɔb wà li yé uciɛn biʼni. ");
INSERT INTO gngNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Nɛ u tɔke' bɛ ki ye: «Idu ya bɛrb wɔbndeh iʼnib nɛ, nɛ bà ŋmɔbe ticiɛnt biʼbo cèreh bi yih bɛ binimɔ̀nb. ");
INSERT INTO gngNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ninbi yaam ŋa te nnɔ. Wà yé uciɛn niʼni la, wɔ ń tien uʼba uwaal. Wà yé usɛnlier la, wɔ ń tien uʼba utonsɔnl. ");
INSERT INTO gngNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Wà teh tijier nin wà jinh, ŋmɛ cɛn' utɔ? Na yé wà jinh-ii? Nin nɛn kɛ ŋɔ min te niʼni tɛn utonsɔnl nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","«Ninbi nɛ ñikn' ka siere' ki dàan' nni uyo wà kɛ nì faa nʼbo. ");
INSERT INTO gngNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Nɛn bo, nʼBaa cère' uʼbɛl yé nʼyaal ma nnɔ, nʼmɔ li cère lɛ̀ ń li yé niʼyaal, ");
INSERT INTO gngNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ŋɔ ní li jinh ki ñuh nin nni nʼbɛl ni, kí kɛ̀le mubɛrbiɛmu bo, kí bu Israyɛl yaab ya baamul piik nin ile nnɔ tibuur.» ");
INSERT INTO gngNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","*Yesu tɔke' Simɔn ki ye: «Simɔn, Simɔn, liike *Satan miɛ' usɛn wɔ ń yoyoke nɛ tɛn bi yoknh kufenku ma bo ki ñɛndeh mibim nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ama n kàare' ki de' sin ŋɔ aʼtekjim la pɔre ŋɛ. Uyo wà a liɛbe' ní ki paan' nʼbo la, á saake aʼninjiɛb ya gbɛnɛnt.» ");
INSERT INTO gngNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Nɛ Piɛr tɔke' wɔ ki ye: «Yonbdaan, n li tuo bɛ ń pɛkn min nin sin, bii kí kpo nin ŋɛ mɔnɔn-a!» ");
INSERT INTO gngNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Nɛ *Yesu ye: «Piɛr, n tɔkeh ŋɛ nɛ, dinnɔ mɔnɔn, a li niɛ bolm mita kí ye ŋa bɛn nni nɛ kí yaan ukuojɛ ń muɔ.» ");
INSERT INTO gngNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Nɛ ki niire' bɛ ki ye: «N là sɔn' nɛ ma, ki ye ni la tuke like, ki la tuke kɔl, ki la taa tacaan nnɔ, ni là luo' niba-aa?» Nɛ bi ye: «Ta là luo' niba.» ");
INSERT INTO gngNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Nɛ u ye: «Fɛnfɛnnɔ wà ŋmɔbe bulikbu la, wɔ ń li tuke. Wà mɔ ŋmɔbe likɔl la, wɔ ń li tuke. Wà ŋa ŋmɔbe jusiek la, wɔ ń kuɔre uʼliɛrku kí dɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","N tɔkeh nɛ nɛ, kimɛ nà kɛle' nʼbo *Uwien ya gbɔnku ni nnɔ li tien nɛ. Nì kɛle' ki ye: ‹Bi kaan' wɔ ki kpɔbn' idukond bó nɛ›, ‹bi li mɔnbe kí tien nni nnɔ nɛ fɛnfɛnnɔ.› » ");
INSERT INTO gngNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Nɛ bi ye: «Yonbdaan, liike-a mujusiemu mule sɔ.» Nɛ u tɔke' bɛ ki ye: «Nì li dɛ̀kre.» ");
INSERT INTO gngNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","*Yesu ñɛn' niʼsaan ki jon' Olifi ya siin ya juɔl bo tɛn u tì ń joh uyo kɛ ma bo, nɛ uʼpanpaankaab mɔ paan' uʼbo. ");
INSERT INTO gngNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","U tì baa' niʼsaan, nɛ ki tɔke' bɛ ki ye: «Li kàareh mɛn ŋɔ ki la lu biikm ni.» ");
INSERT INTO gngNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Nɛ ki dàan' bɛ, ki jɛnde' waamu, ki gbaan' ki kàareh ");
INSERT INTO gngNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","ki teh: «NʼBaa, a yíe la, cère ijɛnd yiɛ ń jɛnde nni. Ama la cère n ya yíem ń tien, cère aʼyaam ń tien.»  ");
INSERT INTO gngNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Nɛn saan nɛ Uwien ya tond uba ñɛn' paaki bó ní, ki baa' uʼsaan ki saake' uʼgbɛnɛnt. ");
INSERT INTO gngNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","*Yesu ya yɛnm saa' ki tì kɛnde', nɛ u tùɔre' ki kàare' nin inunmɔ́n; nɛ kutòntònku ñɛh wɔ ki naan misɛ̀m ki tuoreh tingi ni. ");
INSERT INTO gngNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","U kàare' ki gben' nɛ ki fii' ki liɛbe' uʼpanpaankaab bita nnɔ saan, ki laa' biʼyɛnm saa' ki gbien', bi dɔ ki gɔh, ");
INSERT INTO gngNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","nɛ u ye: «O! Nì tuo', ni dɔ ki gɔh-ɔɔ? Fii mɛn, kí li kàareh ŋɔ ki la lu biikm ni.» ");
INSERT INTO gngNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","*Yesu laan biɛ ki lienh nɛ linigol liba puɔ' biʼbo, bi yih wà Sudas, u yé *Yesu ya panpaankaab piik nin bile ya uba nnɔ le bɛ usɛn. U nɛkn' *Yesu nɛ ki lɔkn' wɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Nɛ *Yesu tɔke' wɔ ki ye: «Sudas! A li lɔkn Unil ya Bijɛ nɛ kí kuɔre wɔ-ɔɔ!» ");
INSERT INTO gngNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","*Bà te nin Yesu nnɔ laa' nà benh nɛ̀ ń tien, nɛ ki niire' wɔ ki ye: «Yonbdaan, tí taa mujusiemu kí gɛgɛ bɛ-ɛɛ?» ");
INSERT INTO gngNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Nɛ biʼni uba taa' kijusiek ki gɛ' ki paare' bitɔtuɔrciɛnb ya ciɛn ya tonsɔnl uba ya nɔjietubl. ");
INSERT INTO gngNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Nɛ *Yesu ye: «Dàan mɛn, nì li dɛ̀kre», nɛ ki mɛ' utonsɔnl nnɔ ya tubl nnɔ ki cère' u faake'. ");
INSERT INTO gngNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Nɛ ki tɔke' bitɔtuɔrciɛnb nin Uwien ya duku ya guguurb ya ciɛnb nin *Sufmbɛ ya ciɛnb bà baa' bɛ ń lá cuo wɔ nnɔ ki ye: «Ni tuke mujusiemu nin ilɛnbɛn ní lá cuo nni tɛn n yé udukond nɛ-a! ");
INSERT INTO gngNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","N là te nin nɛ Uwien ya duku ya luo bo idaan kɛ, nɛ na cuo' nni. Ama fɛnfɛnnɔ ninbi nin ubiɛrɔ ya tuɔm ya yo nɛ baa'.» ");
INSERT INTO gngNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Nɛn saan nɛ bi cuo' *Yesu ki taa' wɔ ki jon' bitɔtuɔrciɛnb ya ciɛn den. Nɛ Piɛr pɛ biʼbo ki te fɔnfɔkm. ");
INSERT INTO gngNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Bi sɛ̀re' umu uluo ya siik, nɛ ki kɛ̀le' ki jebe' wù. Piɛr mɔ baa' ki kɛ̀le' biʼni. ");
INSERT INTO gngNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Upiitonsɔnl uba laa' wɔ u kɛ umu saan, nɛ u caan' uʼbo inun ki ye: «Ujɛ wuɔ nɔ mɔ bi te nin *Yesu nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Nɛ u niɛ' ki ye: «Upii, ma bɛn wɔ.» ");
INSERT INTO gngNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Nì pukn' waamu, nɛ unitɔ mɔ laa' wɔ, ki tɔke' wɔ ki ye: «Aʼmɔ yé bi ya uba nɛ.» Nɛ Piɛr ye: «Kayi! Ma yé biʼyɔ.» ");
INSERT INTO gngNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Nì tien tɛn kukurku kuba, nɛ unitɔ mɔ len' ki ye: «Nì yé imɔ̀n nɛ, ujɛ wuɔ mɔ bi te nin *Yesu nɛ, kimɛ u yé Galile yɔ nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Nɛ Piɛr jiin' wɔ ki ye: «Ujɛ, ma bɛn a ye a ye bà.» U laan biɛ ki lienh nɛ ukuojɛ pɔk ki muɔ'. ");
INSERT INTO gngNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","U ya yo nɛ Yonbdaan jiɛbe' ki caan' Piɛr bo inun. Nɛ Piɛr tiɛre' Yonbdaan bi tɔke' wɔ ma ki ye: «Dinnɔ, a li niɛ bolm mita kí ye ŋa bɛn nni nɛ kí yaan ukuojɛ ń muɔ nnɔ.» ");
INSERT INTO gngNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Nɛ u fii' ki ñɛn' saali, ki tì muɔ' ki gbiɛnde' cɛɛn. ");
INSERT INTO gngNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Nɛn saan nɛ binib bà gu *Yesu nnɔ lɛh wɔ, ki yieke ki ñih wɔ, ");
INSERT INTO gngNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","ki taa' kukpɛlciɛku ki pibn' uʼnun bó, ki tɔkeh wɔ ki teh: «Bukre' wà ñi' ŋɛ.» ");
INSERT INTO gngNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Nɛ ki liɛbe' ki sukreh wɔ isuk mɔ ì yɛbe. ");
INSERT INTO gngNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Nì faa' kutɛnŋɛsɔnsɔnku, nɛ *Sufmbɛ ya ciɛnb nin bitɔtuɔrciɛnb nin *Yiko ya wɔnwɔknb taan', ki cère' bi taa' *Yesu ki baa' biʼbuur ya cɛkl yaab saan. ");
INSERT INTO gngNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Nɛ bi niire' wɔ ki ye: «A yé Uwien ya Nigɛndkɛ Kristo nɛ la, tɔke tɛ.» Nɛ u jiin' bɛ ki ye: «N tɔke' nɛ mɔnɔn la, na lì li teke kí ji. ");
INSERT INTO gngNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","N tí niire' nɛ iniire mɔ la, na ń jiin nni. ");
INSERT INTO gngNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ama kí ñɛ fɛnfɛnnɔ kí taa kí li joh, Unil ya Bijɛ li kɛ̀le Uwien, mituɔm kɛ ya daan ya jie bó.» ");
INSERT INTO gngNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Nɛ biʼkɛ ye: «Nɛn mɛn la, a yé Uwien ya Bijɛ nɛ-a!» Nɛ *Yesu jiin' bɛ ki ye: «Ninbi mɔnɔn len' bù te, n yé wɔn nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Nɛn saan nɛ bi ye: «Ta ji nuunh mɔ̀nkunl, tinbi mɔnɔn cii' uʼñɔbu ni.» ");
INSERT INTO gngNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Nɛ biʼkɛ fii', ki taa' *Yesu ki jon' Pilat saan, ");
INSERT INTO gngNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","ki cin' ki biindeh wɔ ki teh: «Ti laa' ujɛ wuɔ sureh tiʼdu ya nib nɛ bɛ ń kpre, ki tɔkeh bɛ ki teh, bi la ji ń li pɛ̀h ubɛrciɛn Sesa lɛnpo, ki teh u yé Uwien ya Nigɛndkɛ Kristo, ubɛr nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Nɛ Pilat niire' wɔ ki ye: «Sin, a yé *Sufmbɛ ya bɛr nɛ-ɛɛ?» Nɛ u jiin' wɔ ki ye: «Sin nɛ ye nnɔ.» ");
INSERT INTO gngNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Nɛ Pilat tɔke' bitɔtuɔrciɛnb nin linigol nnɔ ki ye: «Ma laa' ujɛ wuɔ ya biil.» ");
INSERT INTO gngNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Nɛ bi ñiikeh ki teh: «U wɔknh Sude ya tinfɛnm kɛ ni nɛ, ki cèreh binib kpreh. U cin' Galile ya tinfɛnm ni nɛ, ki ŋmɔŋmɔbe ki lá baa' niɛ saan.» ");
INSERT INTO gngNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilat cii' nnɔ ma nnɔ, nɛ ki niire' ki ye: «Ujɛ bugbɛn yé Galile yɔ nɛ-ɛɛ?» ");
INSERT INTO gngNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Pilat cii' *Yesu ñɛn' Galile ma nnɔ, nɛ u ye bɛ ń taa wɔ kí jo Herod saan, kimɛ Herod nɛ likeh Galile ya nib, ki te Yerusalɛm ni i ya dɛn. ");
INSERT INTO gngNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herod laa' *Yesu ma nnɔ, nɛ uʼyɛnm sɔnge cɛɛn, kimɛ u là cii' uʼbó, nɛ ki nuunh wɔ ń lɛ wɔ nì tì wuɔke', ki daan wɔ ń tien miyɔkm ya bonn ŋɔ wɔ ń lɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","U niire' *Yesu iniire ì yɛbe, ama *Yesu ŋa jiin' wɔ ñɔbonl. ");
INSERT INTO gngNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Bitɔtuɔrciɛnb nin *Yiko ya wɔnwɔknb mɔ te niʼsaan ki biindeh wɔ ufaa bo. ");
INSERT INTO gngNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herod nin uʼsɔjambɛ liike' wɔ fɛnm, ki lɛ̀' wɔ, nɛ Herod taa' kuliɛrku kuba, kù mɔn cɛɛn ki goln' wɔ, ki cère' bi taa' wɔ ki jiin' Pilat saan. ");
INSERT INTO gngNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Herod nin Pilat ŋa là ŋmɛ. Nɛn daali nɛ bi ŋmaake'. ");
INSERT INTO gngNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Nɛn saan nɛ Pilat yin' bitɔtuɔrciɛnb nin *Sufmbɛ ya ciɛnb nin udu ya nib, ");
INSERT INTO gngNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ki tɔke' bɛ ki ye: «Ni taa' ujɛ wuɔ ki baa' nʼsaan ki ye u gaandeh binib nɛ. Nɛn bo nɛ n bun' wɔ tibuur niʼkɛ ya nun bó, ki niire' wɔ iniire ni biindeh wɔ isɛn yà ni nnɔ, ka laa' u bii' bà. ");
INSERT INTO gngNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herod mɔ ŋa laa' u bii' bà. Nɛn bo nɛ u jiin' wɔ ní tiʼsaan. Tɔ, wa tien' nà kpɛ kuum. ");
INSERT INTO gngNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Nɛn bo, n li cère bɛ ń ñì wɔ nɛ, kí taa wɔ kí wiɛ.» ");
INSERT INTO gngNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Binl kɛ binl, kunacenku nnɔ ya yo la, Pilat ñɛndeh lipɛkl ya nil uba nɛ ki wiɛnh. ");
INSERT INTO gngNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Nɛ biʼkɛ taan' ki wuure' ki ye: «Ku ujɛ wuɔ nɔ, kí wiɛ tɛ Barabas.» ");
INSERT INTO gngNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Bi là cuo' Barabas ki pɛkn', kimɛ u là cère' binib kpi' udu ni, nɛ ki ku' unil mɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilat yíe wɔ ń wiɛ *Yesu ma nnɔ, nɛn nɛ cère' u liɛbe' ki len' nin binib nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ama bɛ ń wuureh nɛ ki teh: «Kpɛ wɔ udɔpɔnpɔn bo! Kpɛ wɔ udɔpɔnpɔn bo!» ");
INSERT INTO gngNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Nɛ u tí niire' bɛ nta bo ki ye: «U tɛ́n ki bii' li lɛ biil bɛ nɛ? Min ŋa laa' u tien' nà nì kpɛ kuum. N li cère bɛ ń ñì wɔ nɛ, kí taa wɔ kí wiɛ.» ");
INSERT INTO gngNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ama bi ñiikeh ki wuureh ufaa bo nɛ ki teh bɛ ń kpɛ wɔ udɔpɔnpɔn bo. Bi wuure' ki tì faake' ");
INSERT INTO gngNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","nin Pilat, nɛ u gbɛle' ki tuo' bi ye ma. ");
INSERT INTO gngNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","U pɛkre' Barabas wà là cère' binib kpi' udu ni, ki ku unil mɔ nnɔ ki wiɛ'. Bi là ye wɔ ń wiɛ' wɔn nɛ. Ama *Yesu wɔn, u taa' wɔ ki de' bɛ bɛ ń tì tien wɔ bi yíe ma nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Bi taa' *Yesu ki bure'. Bi joh ma nnɔ nɛ ki tì cende' ujɛ uba bi yih wɔ Simɔn, u yé Sirɛnn ya du ya nil nɛ, ki ñɛn' ikpàan bó ní. Bi cuo' ujɛ bugbɛn ki wɔbn' ki bukn' wɔ udɔpɔnpɔn nɛ u pɛ *Yesu ya puoli bó. ");
INSERT INTO gngNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Linigociɛnl pɛ *Yesu bo. Biʼni biba yé bipiib nɛ, ki muɔh ki kpìɛndeh uʼbo. ");
INSERT INTO gngNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","*Yesu jiɛbe' ki liike' bɛ, nɛ ki ye: «Yerusalɛm ya piibɛ, la muɔh mɛn min bo, li muɔh mɛn ninbi nin niʼbumu bo. ");
INSERT INTO gngNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Kimɛ uyo uba we ní bi li len kí ye: ‹Bipiib bà yé iŋɔl, ka maa', ka ŋaan' nnɔ yaam tu.› ");
INSERT INTO gngNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","U ya yo nɛ binib li tɔke ijuɔn kí ye: ‹Bere mɛn kí ñɛkn tiʼbo›, kí tɔke igbɛngbɛn mɔ kí ye: ‹Lèkn mɛn tiʼbo.› ");
INSERT INTO gngNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Kimɛ bi teh udɔsɔnge nɔ la, bi ji li tien mila udɔkuon-i?» ");
INSERT INTO gngNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Bi là tuke' idukond ile mɔ, bɛ ń tì taan kí ku yɛn nin Yesu. ");
INSERT INTO gngNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Bi tì baa' niba saan, bi yih nɛ̀ «Kuyukpɔbku ya Bùol.» Nɛn saan nɛ bi kpɛ' *Yesu udɔpɔnpɔn bo, nɛ ki kpɛ' idukond ile nnɔ mɔ. Bi kpɛ' uba uʼnɔjie bó, ki kpɛ' utɔ uʼnɔgɛn bó. ");
INSERT INTO gngNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Nɛ *Yesu ye: «NʼBaa, fère bɛ biʼbiɛre, kimɛ ba bɛn bi teh nà.» Sojambɛ taa' uʼwɛngolkaar ki fùɔre' imúɔn ki gbiire' tù. ");
INSERT INTO gngNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Nɛ udu ya nib se ki likeh. *Sufmbɛ ya ciɛnb bɛn lɛh *Yesu nɛ ki teh: «U ŋmiɛn' bitɔb nɛ. U yé Uwien ya Nigɛndkɛ Kristo la, wɔ ń ŋmiɛn uʼba mɔ.» ");
INSERT INTO gngNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Sojambɛ nnɔ mɔ sukreh wɔ, ki nɛkn' wɔ ki taa' midɛŋmiŋmiikm ki tɛnde' wɔ, ");
INSERT INTO gngNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","nɛ ki ye: «A yé *Sufmbɛ ya bɛr la, ŋmiɛn aʼba-a!» ");
INSERT INTO gngNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Bi là kɛle' ki tɛbn' uʼyul ya paaki bó, ki ye: «*Sufmbɛ ya bɛr sɔ nɔ.» ");
INSERT INTO gngNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Idukond yà bi kpɛ' yɛ̀ idɔpɔnpɔn bo nnɔ ya uba mɔ sukreh wɔ ki teh: «Ŋa yé Uwien ya Nigɛndkɛ Kristo bi? Ŋmiɛn aʼba ŋɔ kí ŋmiɛn tiʼmɔ!» ");
INSERT INTO gngNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Nɛ udukondtɔ nnɔ tiɛn' uʼbo ki ye: «Tinbi nin wɔn taan' ki laa' utudɛre uba, nɛ ŋa fɛnge Wien-a! ");
INSERT INTO gngNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Tinbi yaam kpɛ' utudɛre wuu nɛ, kimɛ bi tien' tɛ tiʼtùon kpɛ ma bo nɛ. Ama wɔn ŋa tien' biɛre iba.» ");
INSERT INTO gngNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Nɛ ki ye: «Yesu, a lá jin' aʼbɛl uyo wà la, á li tiɛn nʼbó.» ");
INSERT INTO gngNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Nɛ *Yesu jiin' wɔ ki ye: «N tɔkeh ŋɛ imɔ̀n nɛ, dinnɔ mɔnɔn a li te nin nni Uwien den nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Nì là tuo kuwensiiku ya yo nɛ, nì ci' ki bìike' utingbɛn kɛ bo ki tì baa' kutaajuɔku tikur tuta ya yo. ");
INSERT INTO gngNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Wien ŋa ji ñɛh nɛ kukpɛlcɛkpɛkpiɛku kùa bore' Uwien ya duku ni bolm mile nnɔ kɛre' kuʼsiik ni. ");
INSERT INTO gngNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","U ya yo nɛ *Yesu wuure' ufaa bo ki ye: «NʼBaa, n taa' nʼmiɛl ki ŋukn' ŋɛ.» U len' nnɔ ki tì gben', nɛ ki kpo'. ");
INSERT INTO gngNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Sojambɛ kobk ya ciɛn laa' nnɔ ma nnɔ, nɛ ki pɛ̀ke' Uwien ki ye: «Ujɛ wuɔ mɔnbe ki yé ugbɛmɔ̀ndaan nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Binib bà kɛ baa' ligol bɛ ń lá liike nnɔ, laa' tibont tà kɛ tien', nɛ ki liɛbe' ki kunh nin uyɛnsaa. ");
INSERT INTO gngNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Binib bà kɛ bɛn wɔ nin bipiib bà ñɛn' Galile ya tinfɛnm bó ní, ki pɛ uʼbo nnɔ, se fɔnfɔkm ki likeh. ");
INSERT INTO gngNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Ujɛ uba là te, bi yih wɔ Yosɛf, u ñɛn' *Sufmbɛ ya du uba ni, nɛ bi yih wù Arimate. U là yé *Sufmbɛ ya buur ya cɛkl yaab ya uba nɛ, ki cuube, ki yé unimɔ̀n, ki gu Uwien ya bɛl li baa ní uyo wà. Wa là tuo' uʼtɔb ye bɛ ń tien ma, nɛ ka kuɔn' uʼba biʼtùon ni. ");
INSERT INTO gngNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","U jon' Pilat saan ki tì tɔke' wɔ ki ye wɔ ń cɛ̀be wɔ *Yesu ya gbɛnɛnt ŋɔ wɔ ń jiin tù udɔpɔnpɔn bo kí tì sube. ");
INSERT INTO gngNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Pilat tuo', nɛ Yosɛf jiin' *Yesu ya gbɛnɛnt udɔpɔnpɔn bo, ki taa' kukpɛlciɛku ki tɛntɛn' tù, ki taa' ki tì ble' ufɛle ni. Bi là cube' ufɛle nnɔ kujɔtɛnku kuba ya kɛle ni nɛ, ka laan sube' nil len. ");
INSERT INTO gngNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ni là yé lidaali là bi bondeh Saba nɛ, nɛ Saba bugbɛn benh wɔ ń cin. ");
INSERT INTO gngNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Bipiib bà là ñɛn' Galile ya tinfɛnm bó ní ki pɛ *Yesu bo nnɔ, paan' Yosɛf bo, ki tì laa' ufɛle nnɔ, ki laa' bi taa' *Yesu ya gbɛnɛnt ki ble' len ma bo. ");
INSERT INTO gngNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Bipiib nnɔ liɛbe' ki kun', ki tì bonde' lɛfina nin mikpɔm. Nɛ ki juore' ki fuore' *Saba ya daali liwɔbl ye ma bo. ");
INSERT INTO gngNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","*Saba ya daali gɛ̀bre', kutaaku kùa li faa nnɔ, nɛ bipiib nnɔ wɔre' ki fii', ki taa' bi là bonde' mikpɔm mà miʼnu ŋmɛ nnɔ ki jon' likul bó. ");
INSERT INTO gngNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Bi tì baa', ki laa' kutɛnku kùa bi là taa' ki bìin' likul nnɔ ŋa ji bi. ");
INSERT INTO gngNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Nɛ bi kɔn' ka laa' Yonbdaan *Yesu ya gbɛnɛnt. ");
INSERT INTO gngNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Nì bɛke' bɛ cɛɛn nɛ ba ji bɛn bi li ye bà. I ya tàan bo nɛ bi laa' bijɛb bile baa' ki lá sere' biʼsaan, ki guo tikpɛlcɛr tù windeh ki dɔnbeh inun bó. ");
INSERT INTO gngNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Bujɛwaanbu cuo' bipiib nnɔ, nɛ ba ji kaabe' ki liike' bijɛb nnɔ, nɛ bi niire' bɛ ki ye: «Bɛ tien' ni nuunh unifuob bitɛnkpiib ni? ");
INSERT INTO gngNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Wa ji te niɛ saan. U mɛkre'-a. Tiɛre mɛn u là tɔke' nɛ ki ye bà uyo wà u laan là te Galile ni nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","U là ye ‹nì kpɛ bɛ ń taa Unil ya Bijɛ kí ŋukn bibiɛrdɛnb, bɛ ń kpɛ wɔ udɔpɔnpɔn bo, ŋɔ wienta daali wɔ ń mɛkre bitɛnkpiib ni nɛ.› » ");
INSERT INTO gngNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Nɛn saan nɛ bipiib nnɔ tiɛre' *Yesu la len' ki ye bà. ");
INSERT INTO gngNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Bi siere' likul nnɔ saan ki liɛbe' ki kun', ki taa' tigbɛr nnɔ kɛ ki tɔke' *Yesu ya tondb piik nin uba nnɔ nin binitɔb bà kɛ mɔ là pɛ uʼbo nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Bipiib nnɔ ya yel si: Mari Madelɛnn nin Sann nin Mari Saak ya naa. Bɛn nin bipiitɔb nɛ taa' tigbɛr nnɔ ki tɔke' *Yesu ya tondb. ");
INSERT INTO gngNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Bi tɔke' bɛ ma nnɔ nɛ bi maaleh ki teh nì yé mijɔ̀rlenm nɛ, nɛ ka teke' tigbɛr nnɔ ki jin'. ");
INSERT INTO gngNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Nɛn saan nɛ Piɛr fii' ki sɛn' ki jon' likul nnɔ saan, ki gbìen' ki liike', ki laa' kukpɛlciɛku nnɔ baba nɛ dɔ len. Nibonn nà tien' nnɔ cuo' wɔ miyɔkm cɛɛn, nɛ u liɛbe' ki kun'. ");
INSERT INTO gngNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Nɛn daali nɛ *Yesu ya panpaankaab ya bile joh udu uba bó bi yih wù Emayus. Kí ñɛ Yerusalɛm kí tì baa udu nnɔ nì te tɛn kɔnsini piik nin uba nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Bi joh ma nnɔ nɛ ki lienh tibont tà kɛ tien' nnɔ bó. ");
INSERT INTO gngNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Bi lienh ki niɛh nin tɔb uyo wà nnɔ, nɛ *Yesu nɛ̀nde' bɛ, bi tɔke ki joh. ");
INSERT INTO gngNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Nì libe' biʼyɛnm nɛ ba bɛnde' wɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","U niire' bɛ ki ye: «Ni cuonh ki lienh bɛ ya gbɛr nɛ?» Biʼyɛnm saa' nɛ bi sere'. ");
INSERT INTO gngNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Biʼni bi yih wà Kleyopas nnɔ jiin' wɔ ki ye: «N maale' ki ye sin baba nɛ te Yerusalɛm ni, ka bɛn nà tien' len idɛn yiɛ nɔ.» ");
INSERT INTO gngNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Nɛ u ye: «Bɛ ya bonn tien'-i?» Nɛ bi tɔke' wɔ ki ye: «Ti lienh nà tu' Nasarɛt ya *Yesu nnɔ ya gbɛr nɛ. U là yé *Uwien ya ñɔbonsɔknl nɛ, ki ŋmɔbe mituɔm uʼlenm nin uʼtùon kɛ ni, binib nin Uwien ya nun bó. ");
INSERT INTO gngNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ama tiʼyaab bà yé bitɔtuɔrciɛnb nin tiʼdu ya ciɛnb taa' wɔ ki tì ŋukn' Erom ya ciɛnb, bi bun' wɔ ki ye u kpɛ mikuum, nɛ ki kpɛ' wɔ udɔpɔnpɔn bo. ");
INSERT INTO gngNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Tinbi là daan ki ye wɔn nɛ li teke tinbi Israyɛl yaab kí wiɛ. Nin tiʼdɛndɛnl kɛ ŋɔ tibont nnɔ kɛ tien' ma dinnɔ wienta sɔ. ");
INSERT INTO gngNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ama tiʼcɛkl ya piib biba tɔke' tɛ tigbɛr tuba tù jin' tɛ. Bi wɔre' ki fii' ki jon' likul bó, ");
INSERT INTO gngNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ka tì laa' *Yesu ya gbɛnɛnt, nɛ ki liɛbe' ní ki lá tɔke' tɛ ki ye Uwien ya tondb biba baa' biʼsaan ki tɔke' bɛ ki ye u fuobe. ");
INSERT INTO gngNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Nɛ tiʼyaab biba mɔ jon' likul nnɔ bó, ki tì laa' nì te tɛn bipiib nnɔ len' ma nɛ. Ama wɔn wɔn, ba laa' wɔ.» ");
INSERT INTO gngNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Nɛ *Yesu tɔke' bɛ ki ye: «O, bijɛbɛ, mibɛnm nɛ pɔre' nɛ. Na teke' *Uwien ya ñɔbonsɔknb là len' nà kɛ nnɔ tonm. ");
INSERT INTO gngNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Nì kpɛ Uwien ya Nigɛndkɛ Kristo ń jɛ̀nde nɛ kí yaan Uwien ń kpiɛke wɔ.» ");
INSERT INTO gngNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Nɛ ki cin' ki tɔkeh bɛ nà kɛ kɛle' uʼbo Uwien ya gbɔnt ni nnɔ. U cin' ki tɔkeh bɛ Moyis là kɛle' nà uʼbo nɛ ki tì baa' *Uwien ya ñɔbonsɔknb kɛ mɔ là kɛle' nà. ");
INSERT INTO gngNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Bi tì nɛkn' bi joh udu wà ni nnɔ, nɛ *Yesu tien' tɛn u ye wɔ ń gɛ̀bre nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Nɛ bi cɛ́kn' wɔ ki ye wɔ ń juore biʼsaan, uwien benh wù ń lu nɛ, nì li biire na ń wuɔke. Nɛ u juore' biʼsaan. ");
INSERT INTO gngNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Bi kɛ̀le' bɛ ń ji uyo wà nnɔ, nɛ u yuure' kpɔnɔ, ki faare' Uwien, ki kɔkuɔ' ki de' bɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Nɛn saan nɛ biʼyɛnm cìbre', bi bɛnde' wɔ, nɛ u pɔk ki fele'. ");
INSERT INTO gngNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Nɛ bi tɔke' tɔb ki ye: «U bi lienh ki tùɔreh ki tɔkeh tɛ *Uwien ya gbɔnku ya gbɛr ya tingi usɛn ni ma nnɔ, nà bi siɛnh tiʼfɛ̀l ni tɛn umu-uu?» ");
INSERT INTO gngNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Nɛ bi fii' ki liɛbe' Yerusalɛm i ya tàan bo ki tì laa' *Yesu ya tondb piik nin uba nnɔ nin binitɔb taan' ki te. ");
INSERT INTO gngNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Bi tɔke' bipanpaankaab bile nnɔ ki ye: «Yonbdaan mɔnbe ki mɛkre'. U cère' Simɔn laa' wɔ.» ");
INSERT INTO gngNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Nɛ bipanpaankaab bile nnɔ mɔ tɔke' bɛ nà tien' usɛn ni, ki tɔke' bɛ ki ye bi bɛnde' wɔ uyo wà u kɔkuɔ' kpɔnɔ nnɔ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Bi lienh biʼñɔbu ŋa lu', nɛ *Yesu baa' ki lá sere' biʼsiik ni, ki tɔke' bɛ ki ye: «Li te mɛn uyɛnduɔn ni.» ");
INSERT INTO gngNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Nì fɛ̀nde' bɛ ki gbien', bujɛwaanbu cuo' bɛ, kimɛ bi maaleh ki teh nì yé ufɛnfɛnd nɛ. ");
INSERT INTO gngNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Nɛ u niire' bɛ ki ye: «Bɛ tien' nì cuo' nɛ bujɛwaanbu, ni maaleh milele? ");
INSERT INTO gngNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Liike mɛn nʼnuɔ nin nʼtàan, min lì nɛ. Mɛ nni mɛn kí liike, ni li lɛ n ŋmɔbe tigbɛnɛnt nin ikpɔb. Fɛnfɛnd ŋa ŋmɔbe gbɛnɛnt ki niireh nin kpɔbl.» ");
INSERT INTO gngNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","U lienh nnɔ uyo wà nnɔ, nɛ ki wɔngeh bɛ uʼnuɔ nin uʼtàan. ");
INSERT INTO gngNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Nɛn saan nɛ biʼyɛnm sɔnge', ama ba laan teke' ki jin' ki gben', ki biɛ ki te miyɔkm ni. Nɛ u niire' bɛ ki ye: «Nì ŋmɔbe niba libùol liɛ ní ji-ii?» ");
INSERT INTO gngNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Bi de' wɔ lijɛnjenpulkaal liba. ");
INSERT INTO gngNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Nɛ u teke', ki ŋmɔn' biʼnun bó. ");
INSERT INTO gngNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Nɛ ki tɔke' bɛ ki ye: «N laan là te nin nɛ uyo wà nnɔ, n là tɔke' nɛ ki ye: nì kpɛ Moyis là kɛle' nà nin *Uwien ya ñɔbonsɔknb là kɛle' nà nin nà kɛ kɛle' Uwien ya yuon ya gbɔnku ni nʼbo nnɔ, kɛ ń tien nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Nɛn saan nɛ u cìbre' biʼyɛnm bɛ ń fre kí cii nà kɛle' *Uwien ya gbɔnku ni nnɔ ya tingi. ");
INSERT INTO gngNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Nɛ ki tí tɔke' bɛ ki ye: «Nì kɛle' ki ye nì kpɛ Uwien ya Nigɛndkɛ Kristo ń jɛ̀nde, kí kpo kí mɛkre bitɛnkpiib ni wienta daali. ");
INSERT INTO gngNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Bi li tɔke uŋɛndun ya nib kɛ nʼgbɛr, kí ye bɛ ń lèbre biʼtetem ŋɔ Uwien ń fère bɛ biʼbiɛre. Bi li cin Yerusalɛm ni nɛ kí li tɔkeh tù. ");
INSERT INTO gngNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ninbi nɛ yé nʼmɔ̀nkunb tibont nnɔ kɛ bo. ");
INSERT INTO gngNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Min nin nʼyul nɛ li cère ní lɛ nʼBaa là pùon' ki ye u li de nɛ nà nnɔ. Ní li te Yerusalɛm ni, kí tì baa lidaali là ni li lɛ mituɔm mà li ñɛ paaki bó ní nnɔ.» ");
INSERT INTO gngNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","*Yesu taa' bɛ ki jon' Betani ya du bó ya kɛle, ki tì yuon' uʼnuɔ ki tien' bɛ Uwien ya mɔnm. ");
INSERT INTO gngNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","U teh bɛ Uwien ya mɔnm uyo wà nnɔ, nɛ ki dàan' bɛ, Uwien cère' u don' paaki bó. ");
INSERT INTO gngNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Bi gbaan' ki kpiɛke' wɔ, nɛ ki liɛbe' Yerusalɛm nin uyɛnsɔngciɛn. ");
INSERT INTO gngNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Bi là tuu ki te Uwien ya duku ya luo bo nɛ ki pɛ̀keh Uwien.");
INSERT INTO gngNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Uwien ŋa laan là ñɛn' uŋɛndun ma nnɔ ki laa' Liñɔbonl te nɛ. Lì là te nin Uwien nɛ, ki yé Uwien. ");
INSERT INTO gngNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Lì là te nin Uwien nɛ micincinm. ");
INSERT INTO gngNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Uwien là ñɛn' tibont kɛ nin lɛn nɛ. Uwien ŋa ñɛn' bonn niba ŋɔ la te niʼñɛnm ni. ");
INSERT INTO gngNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Lɛn nɛ yé limiɛl ya daan. Limiɛl nnɔ nɛ dienh binib kuwenwenku. ");
INSERT INTO gngNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Kuwenwenku nnɔ wendeh licinñunl ni, nɛ licinñunl ŋa fre' ki kpiin' kù. ");
INSERT INTO gngNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Uwien sɔn' unil uba ní, bi yih wɔ San. ");
INSERT INTO gngNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","U baa' wɔ ń kun kuwenwenku nnɔ bo imɔ̀n nɛ, ŋɔ wɔn bo binib kɛ ń teke kù kí ji. ");
INSERT INTO gngNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Wɔn ŋa yé kuwenwenku nnɔ, ama u baa' wɔ ń kun kuʼbo imɔ̀n nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Kù yé kuwenwenmɔ̀nku kùa baa' uŋɛndun ni kù ń wende binib kɛ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Uwien ñɛn' uŋɛndun nin Liñɔbonl nnɔ nɛ. Lì baa' uŋɛndun ni ama uŋɛndun ya nib ŋa bɛnde' lɛ̀. ");
INSERT INTO gngNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Lì baa' liʼyaab saan, nɛ liʼyaab ŋa teke' lɛ̀. ");
INSERT INTO gngNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ama binib bà kɛ teke' lɛ̀ nnɔ, bi teke' lɛ̀ ki jin' nɛ, nɛ lì de' bɛ usɛn bɛ ń li yé Uwien ya bumu. ");
INSERT INTO gngNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Bi yé Uwien ya bumu ma nnɔ, na yé u maa' bɛ tɛn unisaal maa' mubumu ma bo nɛ, Uwien nɛ yíe ki cère' bi yé uʼbumu. ");
INSERT INTO gngNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Liñɔbonl nnɔ tien' liʼba unisaal, ki baa' ki lá kɔn' tiʼni, ki teh tinimɔ̀nt cɛɛn, ki tɔkeh tigbɛmɔ̀nt baba. Ti laa' uʼkpiɛke. Ukpiɛke wà uʼBaa Uwien de' wɔ wù, kimɛ u yé uʼbubaabk nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","San kun' uʼbo imɔ̀n ki kpaande' ki ye: «N là lienh wɔn bo nɛ ki teh wà li paan nʼbo ní nnɔ cɛn' nni, kimɛ u là te ki laa' ba laan maa' nni.» ");
INSERT INTO gngNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Uʼnimɔ̀nt ni nɛ u de' tiʼkɛ bupaabu, ki li liɛbe kí de tɛ bù kí pukn. ");
INSERT INTO gngNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Imɔ̀n, Moyis nɛ là de' tɛ *yiko. Tinimɔ̀nt nin tigbɛmɔ̀nt tun wɔn, *Yesu Kristo nɛ baa' nin tù. ");
INSERT INTO gngNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Uba ŋa kpele ki laa' Wien. Ama uʼBijɛbaab wà yé Uwien ki te nin Uwien nnɔ nɛ cère' ti bɛnde' wɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Sufmbɛ ya ciɛnb bà te Yerusalɛm ni nnɔ sɔn' bitɔtuɔrkaab nin Lefi yaab San saan, nɛ bi tì niire' wɔ ki ye: «A yé ŋmɛ nɛ?» ");
INSERT INTO gngNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Nɛ San kun' imɔ̀n ki ye: «Min ŋa yé Uwien ya Nigɛndkɛ Kristo.» ");
INSERT INTO gngNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Nɛ bi liɛbe' ki niire' wɔ ki ye: «A nín yé ŋmɛ? A yé Eli nɛ-ɛɛ?» Nɛ u ye: «Ma yé Eli.» Bi tí niire' wɔ ki ye: «A yé *Uwien ya ñɔbonsɔknl wà li baa ní nnɔ nɛ-ɛɛ?» Nɛ u ye: «Hnhn.» ");
INSERT INTO gngNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Nɛ bi tí niire' wɔ ki ye: «A nín yé ŋmɛ nɛ? A bugbɛn tɔke tɛ a yé udaan wà, ŋɔ tí bɛnde ti li tì jiin bà sɔn' tɛ ní nnɔ kí ye bà.» ");
INSERT INTO gngNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Nɛn saan nɛ San jiin' bɛ ki ye: «N yé wà wuureh kupenpelku ni ki teh: ‹Tùɔre mɛn kí cubn Yonbdaan ya sɛn,› nnɔ nɛ. *Uwien ya ñɔbonsɔknl Esayi là len' nnɔ nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Bi sɔn' binib bà San saan nnɔ ya biba là yé *Farisiɛnmbɛ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Bi liɛbe' ki niire' wɔ ki ye: «Ŋa yé Uwien ya Nigɛndkɛ Kristo, ka yé Eli, ka yé *Uwien ya ñɔbonsɔknl wà li baa ní nnɔ mɔ la, bɛ nín tien' a siih binib Uwien ya ñunm-i?» ");
INSERT INTO gngNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Nɛ u tɔke' bɛ ki ye: «Min taah miñunm nɛ ki siih binib Uwien ya ñunm. Ama uba te niʼsiik ni, na bɛn wɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","U pɛ nʼpuoli bó ní nɛ, ama ma kpɛ ń lore uʼtacɛningbɛn mɔnɔn.» ");
INSERT INTO gngNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Niʼkɛ là tien' Betani ya du ni nɛ, Sudɛn ya kpenpuol bó. San là siih binib Uwien ya ñunm nɛn saan nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Kutaaku faa', San laa' *Yesu we ní uʼsaan, nɛ u ye: «Liike mɛn, Uwien ya *Pebuk kà ñɛndeh uŋɛndun ya nib ya biɛre nnɔ sɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","N là tɔke' wɔn ya gbɛr nɛ ki ye ujɛ uba pɛ nʼpuoli bó ní ki cɛn' nni nnɔ, kimɛ u là te ki laa' ba laan maa' nni. ");
INSERT INTO gngNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Min mɔnɔn ŋa là bɛn udaan wà nɛ, ama n baa' ki siih binib Uwien ya ñunm ŋɔ Israyɛl yaab nɛ ń bɛnde wɔ.» ");
INSERT INTO gngNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Nɛ San tɔke' binib ki ye: «N laa' *Mifuoñaanm ñɛn' paaki bó ki jiinh ní, ki naan unɛnjel, ki lá te uʼbo. ");
INSERT INTO gngNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Min mɔnɔn ŋa là bɛn udaan wà nɛ, ama Uwien wà sɔn' nni ń li siih binib uʼñunm nnɔ, nɛ tɔke' nni ki ye n li lɛ *Mifuoñaanm jiire' ní ki lá te ujɛ uba bo. Wɔn nɛ li cère *Mifuoñaanm ń jiire ní binib bo. ");
INSERT INTO gngNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","N laa', nɛ ki kun' imɔ̀n ki ye wɔn nɛ yé Uwien ya Bijɛ.» ");
INSERT INTO gngNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Kutaaku faa', nɛ San tí te niʼsaan nin uʼpanpaankaab bile. ");
INSERT INTO gngNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","U laa' *Yesu gɛ̀breh, nɛ u caan' uʼbo inun, ki ye: «Liike mɛn, Uwien ya Pebuk sɔ.» ");
INSERT INTO gngNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","San ya panpaankaab bile nnɔ cii' u len' nà, nɛ ki paan' *Yesu bo. ");
INSERT INTO gngNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","*Yesu jiɛbe', ki laa' bi pɛ uʼbo, nɛ u niire' bɛ ki ye: «Ni yíe ba?» Nɛ bi ye: «Rabi, a te lɛ saan-i?» Rabi ya tingi si: Uwɔnwɔknl bii Cɛnbaa nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Nɛ u ye: «Dɛn mɛn, ni li lɛ.» Nì là te kutaajuɔku tikur tunan ya yo nɛ. Bi paan' uʼbo ki tì laa' u te nà saan, nɛ ki juore' uʼsaan ki tonde' niʼdaali ya wentunl. ");
INSERT INTO gngNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Bijɛb bile bà là cii' San ya lenm ŋɔ ki paan' *Yesu bo nnɔ, bi yih uba Andre, u yé Simɔn Piɛr ya ninjɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","U kpiɛ' ki jon' ki tì laa' uʼninjɛ Simɔn nɛ ki tɔke' wɔ ki ye: «Ti laa' Mɛsi.» Mɛsi ya tingi si: Uwien ya Nigɛndkɛ Kristo nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Nɛ ki taa' wɔ ki baa' *Yesu saan. *Yesu caan' Simɔn bo inun, ki tɔke' wɔ ki ye: «Bi yih ŋɛ Simɔn nɛ, San ya bijɛ. Bi ji li yih ŋɛ Sefas nɛ.» Sefas ya tingi si: Litɛnpenl nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Kutaaku tí faa' nɛ *Yesu yíe wɔ ń jo Galile ya tinfɛnm bó. U laa' Filip nɛ ki tɔke' wɔ ki ye: «Paan nʼbo ní.» ");
INSERT INTO gngNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filip nnɔ yé Bɛtsayida ya du yɔ nɛ. Andre nin Piɛr mɔ yé nɛn bó yaab nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filip jon' ki tì laa' Natanayɛl nɛ ki tɔke' wɔ ki ye: «Ti laa' unil wà Moyis là kɛle' uʼgbɛr Yiko ya gbɔnku ni nnɔ. *Uwien ya ñɔbonsɔknb mɔ là len' uʼgbɛr. Wɔn si: Nasarɛt ya Yesu, Yosɛf ya bijɛ.» ");
INSERT INTO gngNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nɛ Natanayɛl niire' wɔ ki ye: «Nibonmɔnmɔnn li fre kí ñɛ ní Nasarɛt ya du ni-ii?» Nɛ Filip tɔke' wɔ ki ye: «Dɛn kí tì liike.» ");
INSERT INTO gngNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","*Yesu laa' Natanayɛl we ní uʼsaan, nɛ u ye: «Liike mɛn, Israyɛl ya bol ya nil tenten sɔ, u yé ugbɛmɔ̀ndaan nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nɛ Natanayɛl niire' wɔ ki ye: «A bɛn nni lɛ saan-i?» Nɛ *Yesu ye: «A bi te bukɛnkɛnbu ni ma nnɔ n kpiɛ' ki laa' ŋɛ nɛ ki yaan Filip yin' ŋɛ.» ");
INSERT INTO gngNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nɛ Natanayɛl ye: «Cɛnbaa, a mɔnbe ki yé Uwien ya Bijɛ nɛ. A yé Israyɛl ya bɛrciɛn nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Nɛ *Yesu ye: «N tɔke' ŋɛ ki ye n laa' ŋɛ bukɛnkɛnbu ni ma nnɔ nɛ a teke' nni ki jin'. A li lɛ miyɔkm ya bont tà yɛbe ki cɛn' niɛ nɔ.» ");
INSERT INTO gngNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Nɛ ki ye: «N tɔkeh nɛ imɔ̀n nɛ, ni li lɛ kutaaku yɛ, kí lɛ Uwien ya tondb doh kutaaku ki jiinh ní *Unil ya Bijɛ ya yul ya paaki.» ");
INSERT INTO gngNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Wienta daali nɛ bi tien' upiikuɔn uba Kana ya du ni, Galile ya tinfɛnm ni. *Yesu ya naa mɔ là te niʼsaan. ");
INSERT INTO gngNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Bi là yin' *Yesu nin uʼpanpaankaab mɔ upiikuɔn nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Midaam là pɔre', nɛ *Yesu ya naa tɔke' wɔ ki ye: «Ba ji ŋmɔbe daam.» ");
INSERT INTO gngNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Nɛ *Yesu jiin' wɔ ki ye: «Upii, min nin sin tu lɛ nɛ? Nʼyo ŋa laan baa'-a!» ");
INSERT INTO gngNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Nɛ uʼnaa tɔke' bitonsɔnb ki ye: «U ye ma la, ní tien nnɔ.» ");
INSERT INTO gngNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Tɔ, icincɛnciɛn iluob iba là se niʼsaan. Cin kɛ cin là li fre kí teke tɛn icùɔn iniin bii icùɔn piik nin ile. *Sufmbɛ là kuonh i ya cin ni nɛ miñunm ki taah ki sɔkreh biʼba, ki paakeh iyaajɛbok ye ma bo. ");
INSERT INTO gngNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","*Yesu tɔke' bitonsɔnb nnɔ ki ye: «Gbien mɛn icin yii nɔ miñunm.» Nɛ bi gbien' iʼkɛ miɛɛn. ");
INSERT INTO gngNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Nɛ u ye: «Kon mɛn kí tì de wà likeh kunacenku ya tùon.» Nɛ bi kon' ki tì de' wɔ, ");
INSERT INTO gngNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","ki laa' miñunm nnɔ kpɛnde' midaam ŋɔ. Nɛ u wube' ki liike', ka bɛn mì ñɛn' nà saan. Ama bitonsɔnb bà kon' ki tì de' wɔ nnɔ, bɛn bɛn. Nɛ u yin' piicɛ, ");
INSERT INTO gngNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ki tɔke' wɔ ki ye: «Wà kɛ ye wɔ ń de midaam la, u kpìɛreh ki dienh mà ŋmɛ nɛ. Binib ñun' ki tì gbo' la, nɛ u ji dienh mà ŋa ŋmɛ ki gbien'. Sin sìen' ma ŋmɛ ki tì kɛnde' nɛ ki yùɔn' ki de'-a!» ");
INSERT INTO gngNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Nɛn nɛ yé miyɔkm ya bonn nà *Yesu cin' ki tien' nɛ̀. U là tien' miyɔkm ya bonn bugbɛn Kana ni nɛ, Galile ya tinfɛnm ni, ki cère' binib laa' u ŋmɔbe ukpiɛke ma bo. Nɛ uʼpanpaankaab teke' wɔ ki jin'. ");
INSERT INTO gngNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ni ya puoli bó nɛ wɔn nin uʼnaa nin uʼninjiɛb nin uʼpanpaankaab jiire' Kapɛrnawum ya du bó, ki tì tien' niʼbó iwenkàankɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Nì là sìen' waamu nɛ *Sufmbɛ ya Pak ń jele, nɛ *Yesu don' Yerusalɛm bó, ");
INSERT INTO gngNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","ki tì kɔn' Uwien ya duku ya luo bo, ki laa' binib te uʼbo. Biba kuɔreh inɛ nin ipe nin inɛnjel, bitɔb kpendeh ilike. ");
INSERT INTO gngNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Nɛ u taa' iŋmi ki tien' unalɛbe yaam, ki ŋɔre' biwɛnkuɔrb nnɔ nin biʼpe nin biʼnɛ nnɔ kɛ ki ñɛn' saali, ki kpɛnkpiɛn' bilikkpendb nnɔ ya like, ki tuture' biʼteb ki gbɔ̀gbɔ̀be'. ");
INSERT INTO gngNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Nɛ ki tɔke' binɛnjekuɔrb nnɔ ki ye: «Ñɛn mɛn niʼkɛ niɛ saan! Ni la taa nʼBaa ya duku kí tien kukpenkpendduku.» ");
INSERT INTO gngNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Nɛ uʼpanpaankaab tiɛre' ki ye nì kɛle' *Uwien ya gbɔnku ni ki ye: «Uwien, nʼnun mɔ́n aʼduku ya gbɛr bo cɛɛn, nɛ nì siɛnh nʼfɛ̀l ni tɛn umu.» ");
INSERT INTO gngNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Nɛ *Sufmbɛ ya ciɛnb niire' wɔ ki ye: «A li tien mi lɛ yɔkm ya bonn kí wuɔn tɛ kí ye a ŋmɔbe usɛn á tien a teh nà nɔ?» ");
INSERT INTO gngNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Nɛ u ye: «We mɛn Uwien ya duku kuu, ŋɔ ń taa iwien ita kí liɛbe kí mɛ kù.» ");
INSERT INTO gngNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Nɛ bi ye: «Bi taa' ibin pinan nin iluob nɛ ki mɛn' Uwien ya duku kuu nɔ, nɛ sin ye a li taa iwien ita kí liɛbe kí mɛ kù-uu?» ");
INSERT INTO gngNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ama *Yesu lienh Uwien ya duku kùa bó nnɔ, u niireh uʼgbɛnɛnt nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Uyo wà u mɛkre' bitɛnkpiib ni nnɔ, nɛ uʼpanpaankaab tiɛre' ki ye u là len' nnɔ. Nɛ ki teke' nà kɛle' *Uwien ya gbɔnku ni nnɔ nin *Yesu ya lenm ki jin'. ");
INSERT INTO gngNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","*Yesu là te Yerusalɛm ni nɛ Pak ya nacenku nnɔ ya yo, ki tien' miyɔkm ya bont, binib laa', nɛ bà yɛbe teke' wɔ ki jin'. ");
INSERT INTO gngNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ama wɔn ŋa du biʼbo, kimɛ u bɛn binib kɛ ya yɛnmaale. ");
INSERT INTO gngNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Wa nuunh uba ń tɔke wɔ unil ya gbɛr. Kimɛ wɔn bugbɛn bɛn nà te unil ya fɛ̀l ni. ");
INSERT INTO gngNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ujɛ uba là te bi yih wɔ Nikodɛm, u yé *Farisiɛnmbɛ ya cɛkl ya nil nɛ, ki yé Sufmbɛ ya ciɛnb ya uba. ");
INSERT INTO gngNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","U baa' *Yesu saan kuñɔnku ki tɔke' wɔ ki ye: «Cɛnbaa, ti bɛn ki ye Uwien nɛ sɔn' ŋɛ ní á lá wɔkn tɛ, kimɛ Uwien ŋa te nin nil la, wa ń fre kí tien yɔkm ya bont tɛn a teh ma bo nɔ.» ");
INSERT INTO gngNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Nɛ *Yesu tɔke' wɔ ki ye: «N tɔkeh ŋɛ imɔ̀n nɛ, ba maa' unil wà ki lere' la, udaan ŋa ń fre kí lɛ Uwien ya bɛl.» ");
INSERT INTO gngNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nɛ Nikodɛm ye: «Unil tien' uciɛn la, bi li tien mila kí maa wɔ kí lere? U li fre kí liɛbe kí kɔ uʼnaa ya benku ni ŋɔ bɛ ń maa wɔ kí lere-ee?» ");
INSERT INTO gngNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Nɛ *Yesu ye: «N tɔkeh ŋɛ imɔ̀n nɛ, ba maa' nil wà miñunm nin *Mifuoñaanm ni la, udaan ŋa ń fre kí kɔ Uwien ya bɛl ni. ");
INSERT INTO gngNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Unisaal maa' nà la, nì yé unisaal nɛ. *Mifuoñaanm maa' nà la, nì yé *Mifuoñaanm yaann nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","La cère n tɔke' ŋɛ ma ki ye nì kpɛ bɛ ń maa nɛ kí lere nnɔ ń cuo ŋɛ miyɔkm. ");
INSERT INTO gngNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Mitafaam joh mì yíe nà bó nɛ, nɛ a ciih miʼwaaku bó, ka bɛn mì ñɛn' nà, ki niireh nin mì joh nà. Unil wà kɛ *Mifuoñaanm maa' wɔ la, uʼmɔ yaam te nnɔ nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nɛ Nikodɛm niire' wɔ ki ye: «Nì li tien mila kí tien-i?» ");
INSERT INTO gngNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Nɛ *Yesu jiin' wɔ ki ye: «A yé unil wà wɔknh Israyɛl yaab Uwien ya gbɛr, nɛ ka bɛn n len' nà nɔ ya tingi-ii? ");
INSERT INTO gngNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","N tɔkeh ŋɛ imɔ̀n nɛ, ti lienh ti bɛn nà nɛ, ki kundeh imɔ̀n tiʼnun laa' nà bo, nɛ na teknh tiʼmɔ̀nkun ki jinh. ");
INSERT INTO gngNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","N tɔkeh nɛ uŋɛndun wuu ni ya gbɛr, nɛ na teknh tù ki jinh. N tɔke' nɛ paaki bó yaar la, ni li tien mila kí teke tù kí ji? ");
INSERT INTO gngNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Unil ya Bijɛ wà ñɛn' paaki bó ki jiire' ní ŋa ñí la, uba ŋa don' paaki bó. ");
INSERT INTO gngNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","«Bi li fin Unil ya Bijɛ paaki bó tɛn Moyis là fin' ma uwɛ udɔ bo ki caan' kupenpelku ni nnɔ nɛ, ");
INSERT INTO gngNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ŋɔ unil wà kɛ teke' wɔ ki jin' la, wɔ ń lɛ limiɛl là ŋa ŋmɔbe gbenm.» ");
INSERT INTO gngNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Imɔ̀n, Uwien yíe uŋɛndun ya nib ki gbien', nɛ ki taa' uʼBubaabk ki de' ŋɔ wà kɛ teke' wɔ ki jin' la, u la kpo kí juore fɛnm, ama wɔ ń lɛ *limiɛl là ŋa ŋmɔbe gbenm. ");
INSERT INTO gngNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Kimɛ Uwien ŋa sɔn' ní uʼBijɛ uŋɛndun ni wɔ ń lá biin uŋɛndun ya nib, u sɔn' wɔ ní wɔ ń lá ŋmiɛn bɛ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Wà kɛ teke' wɔ ki jin' la, Uwien ŋa ń biin wɔ. Ama wà kɛ ŋa teke' wɔ ki jin' la, Uwien biin' wɔ ŋɔ, kimɛ wa teke' wɔn Uwien ya Bubaabk ki jin'. ");
INSERT INTO gngNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Uwien ñìikeh nà bo sɔ ki biindeh binib: kuwenwenku baa' uŋɛndun ni, nɛ binib yíe licinñunl ki cɛn' kuwenwenku, kimɛ biʼtùon bre nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Wà kɛ teh nà bre nɛn kuwenwenku nɛ, ka yíe wɔ ń nɛkn kù, kimɛ u jie uʼtùonbiɛrɛ nnɔ li ñɛ upaan bo nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Wà kɛ teh nà mɔn joh kuwenwenku ni nɛ, nɛ binib ń lɛ uʼtùon kí bɛnde kí ye u teh Uwien yíe nà nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ni ya puoli bó nɛ *Yesu nin uʼpanpaankaab jon' Sude ya tinfɛnm ni, ki tì te niʼbó, nɛ u siih binib Uwien ya ñunm. ");
INSERT INTO gngNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","San mɔ là siih binib Uwien ya ñunm, Ɛnɔn ya du ni nɛ, kimɛ miñunm là yɛbe niʼsaan. Udu nnɔ kpieke Salim ya du nɛ. Binib là bàareh uʼsaan, nɛ u siih bɛ Uwien ya ñunm. ");
INSERT INTO gngNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","U ya yo ki laa' ba laan là cuo' San ki tì pɛkn'. ");
INSERT INTO gngNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","San ya panpaankaab findeh nin Suf uba bi sɔkreh biʼba ki paakeh iyaajɛbok ye ma bo nnɔ bo nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","San ya panpaankaab baa' ki lá tɔke' wɔ ki ye: «Cɛnbaa, unil wà là te aʼsaan Sudɛn ya kpenpuol bó, a tɔke' binib uʼgbɛr nnɔ, uʼmɔ ji siih binib Uwien ya ñunm nɛ, nɛ binib kɛ ji joh wɔn saan.» ");
INSERT INTO gngNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Nɛ San tɔke' bɛ ki ye: «Nil ŋa ń fre kí li ŋmɔbe niba ŋɔ Wien ŋa de' wɔ nɛ̀. ");
INSERT INTO gngNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ninbi bugbɛn yé nʼmɔ̀nkunb ki ye n là len' ki ye min ŋa yé Uwien ya Nigɛndkɛ *Kristo, ama Uwien sɔn' nni ń liere wɔn nɛ usɛn. ");
INSERT INTO gngNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ujɛ kuɔndeh upii la, wɔn si upii. Piicɛ ya jɔ wɔn te ugbɛ nɛ ki cengeh uʼjɔ bó. U tì cii' uʼjɔ ya niɛke bó uyo wà la, nɛ uʼyɛnm ń sɔnge cɛɛn. Nʼmɔ ŋmɔbe u ya yɛnsɔnge nɛ ki tì gben'. ");
INSERT INTO gngNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Nì kpɛ wɔn *Kristo ya yel ń li tùɔreh ki kpienh, nɛ nʼyaal ń li sondeh.» ");
INSERT INTO gngNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Wɔn wà ñɛn' paaki bó ní nnɔ nɛ cɛn' nà kɛ te. Unil wà ñɛn' uŋɛndun ni yé uŋɛndun ya nil nɛ, ki lienh uŋɛndun ya lenm. Unil wà ñɛn' paaki bó ní nɛ cɛn' nà kɛ te. ");
INSERT INTO gngNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","U kundeh imɔ̀n u laa' nà nin u cii' nà bo nɛ. Ama uba mɔnɔn ŋa teke' uʼmɔ̀nkun nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Wà kɛ teke' uʼmɔ̀nkun nnɔ la, u tuo' ki ye Uwien yé ugbɛmɔ̀ndaan nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Unil wà Uwien sɔn' wɔ ní nnɔ lienh wɔn Uwien ya gbɛr nɛ, kimɛ Uwien taa' *uʼFuoñaanm ki de' wɔ ki tì gben' nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Uwien Baa yíe uʼBijɛ, nɛ ki taa' nà kɛ te ki ŋukn' wɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Wà teke' Uwien ya Bijɛ ki jin' la, u ŋmɔbe limiɛl là ŋa ŋmɔbe gbenm nɛ. Ama wà ŋa tuo' ki teke' Uwien ya Bijɛ ki jin' la, wa ń lɛ limiɛl nnɔ. Uwien ya mutuol li tuu ki te uʼbo nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","*Yesu cii' binib tɔke' *Farisiɛnmbɛ ki ye u teh binib uʼpanpaankaab ki siih bɛ Uwien ya ñunm ki cɛn' San. ");
INSERT INTO gngNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Imɔ̀n, *Yesu bugbɛn ŋa là siih nib Uwien ya ñunm. Uʼpanpaankaab nɛ là siih bɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","*Yesu cii' bi lienh nnɔ ma nnɔ nɛ u siere' Sude ya tinfɛnm ni, ki liɛbeh Galile ya tinfɛnm bó. ");
INSERT INTO gngNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","U joh Galile la, u li ñɛ *Samari ya tinfɛnm ni nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","U tì baa' Samari ya du uba ni, bi yih wù Sikar. Sakɔb là de' uʼbijɛ Yosɛf bukpàabu bùa nnɔ ŋa fɔke nin niʼsaan. ");
INSERT INTO gngNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Sakɔb ya ñunbunl te nɛn saan nɛ. *Yesu cuon' ki jii', nɛ ki kɛ̀le' liñunbunl nnɔ ya ñɔgbel bo. Nì là tuo kuwensiiku ya yo nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Samari ya pii uba baa' wɔ ń lun miñunm, nɛ *Yesu tɔke' wɔ ki ye: «Pu nni miñunm ń ñu.» ");
INSERT INTO gngNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","U ya yo ki laa' uʼpanpaankaab jon' udu ya benku ni bɛ ń tì dɛ tijier. ");
INSERT INTO gngNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Nɛ upii nnɔ ye: «Kí ye bɛ bo? Sin Suf mɔ lá miɛh min Samari ya pii miñunm-ii?» U len' nnɔ, kimɛ Sufmbɛ ŋa là nɛkndeh Samari yaab. ");
INSERT INTO gngNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Nɛ *Yesu ye: «A bi bɛn Uwien ya paabu, ki tí bi bɛn wà miɛh ŋɛ miñunm nɔ la, sin nɛ bi li miɛ wɔ, nɛ u bi li de ŋɛ mifuobm ya ñunm.» ");
INSERT INTO gngNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Nɛ upii nnɔ ye: «Cɛnbaa, ŋa ŋmɔbe bonlunkaann, liñunbunl nnɔ mɔ ñɔ, a li lɛ mifuobm ya ñunm nnɔ lɛ saan-i? ");
INSERT INTO gngNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Tiʼyaajɛ Sakɔb nɛ là de' tɛ liñunbunl liɛ nɔ. Wɔn nin uʼbijiɛb nin uʼwɛnt kɛ là ñun' liʼñunm. Sin nɛ cɛn' wɔn-ii?» ");
INSERT INTO gngNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Nɛ *Yesu tɔke' wɔ ki ye: «Wà kɛ ñuh miɛ ya ñunm la, uñuñun li liɛbeh ki coh wɔ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ama wà kɛ li ñu n li de wɔ miñunm mà nnɔ, ñuñun ŋa ji li cuo wɔ fiebu. N li de wɔ miñunm mà nnɔ li te tɛn liñunbunl nɛ uʼni, kí li dienh wɔ limiɛl là ŋa ŋmɔbe gbenm.» ");
INSERT INTO gngNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Nɛ upii nnɔ ye: «Cɛnbaa, de nni mi ya ñunm, ñuñun ji la cuo nni ŋɔ n ji la bàareh niɛ saan ki luh.» ");
INSERT INTO gngNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Nɛ *Yesu ye: «Jo kí tì yin aʼcɛ kí liɛbe ní.» ");
INSERT INTO gngNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Nɛ u ye: «Ma ŋmɔbe cɛ.» Nɛ *Yesu jiin' wɔ ki ye: «A ye ŋa ŋmɔbe cɛ ma nɔ, nì yé imɔ̀n nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Kimɛ a kun' ticɛr ki tì dukn' jɛb biŋun nɛ. A ji te ujɛ wà saan fɛnfɛnnɔ nɔ ŋa yé aʼcɛ. A len' ma nɔ, a tɔke' tigbɛmɔ̀nt nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Nɛ upii nnɔ ye: «Cɛnbaa, n bɛnde' ki ye a yé *Uwien ya ñɔbonsɔknl nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Tinbi Samari yaab ya yaajɛb puke' Uwien lijuɔl liɛ bo nɛ, nɛ ninbi *Sufmbɛ ye bi li pukeh Uwien nà saan si: Yerusalɛm ni nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Nɛ *Yesu tɔke' wɔ ki ye: «Upii, teke kí ji kí ye, uyo we ní, nib ŋa ji lá li pukeh Baa Uwien lijuɔl liɛ bo, ka ji li pukeh wɔ Yerusalɛm mɔ ni. ");
INSERT INTO gngNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ninbi Samari yaab pukeh Uwien, nɛ ka bɛn wɔ. Tinbi *Sufmbɛ wɔn, ti bɛn wɔ, nɛ ki pukeh wɔ. Kimɛ wà li ŋmiɛn binib kɛ ñɛn' *Sufmbɛ ni nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Uyo we ní, nɛ nì yé fɛnfɛnnɔ nɛ, bipupukmɔ̀nb li pukeh Baa Uwien biʼfɛ̀l ni nɛ imɔ̀nmɔ̀n. Kimɛ Uwien nuunh bi ya nib ya bol nɛ bɛ ń li pukeh wɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Uwien ŋa ŋmɔbe gbɛnɛnt, ba lɛnh wɔ. Binib bà kɛ pukeh wɔ nnɔ li pukeh wɔ biʼfɛ̀l ni nɛ imɔ̀nmɔ̀n.» ");
INSERT INTO gngNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Nɛ upii nnɔ ye: «N bɛn ki ye Uwien ya Nigɛndkɛ, wà bi yih wɔ *Kristo nnɔ, li baa ní. U lá baa' la, u li tɔke tɛ tibont kɛ ya tingi.» ");
INSERT INTO gngNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Nɛ *Yesu ye: «Min wà lienh ŋɛ nɔ, n yé wɔn nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","U ya yo nɛ uʼpanpaankaab liɛbe' ní. Bi laa' wɔn nin upii tɔkeh tigbɛr ma nnɔ nɛ nì cuo' bɛ miyɔkm, ama uba ŋa kaabe' ki niire' wɔ ki ye: «A yíe ba uʼsaan-i?» Bii «A tɔkeh wɔ bɛ ya gbɛr-i?» ");
INSERT INTO gngNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Nɛn saan nɛ upii nnɔ taa' uʼcuɔl ki sien', ki jon' udu ya benku ni, ki tì tɔke' binib ki ye: ");
INSERT INTO gngNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«Dɛn mɛn kí tì liike ujɛ wà tɔke' nni n tien' nà kɛ nɔ-a! Wa lii yé Uwien ya Nigɛndkɛ Kristo-oo?» ");
INSERT INTO gngNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Nɛ bi ñɛn' udu ni ki joh *Yesu bó. ");
INSERT INTO gngNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Upii nnɔ liɛbe' udu bó uyo wà nnɔ, nɛ *Yesu ya panpaankaab gbáanh wɔ ki teh: «Cɛnbaa, ji tijier.» ");
INSERT INTO gngNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Nɛ u tɔke' bɛ ki ye: «N ŋmɔbe tijier tuba ń ji na bɛn tù.» ");
INSERT INTO gngNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Nɛ uʼpanpaankaab niireh tɔb ki teh: «Uba nɛ nín tuke' tijier ki lá de' wɔ bii?» ");
INSERT INTO gngNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Nɛ u tɔke' bɛ ki ye: «Nʼjier si ń tien wà sɔn' nni ní yíe nà nɛ, kí sɔn uʼtuonl kí tì gben. ");
INSERT INTO gngNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ninbi pɔh mikpɛnjɛnm ki teh: ‹Nì sìen' iŋmaale inan nɛ nɛ̀ ń kpaan tikpɛjier ya taanm.› Ama min tɔkeh nɛ nɛ: yaare mɛn kí liike, tikpɛjier ben' ki kpaan' mitaanm ŋɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Wà taakeh tikpɛjier teknh uʼpaaku nɛ, ki taakeh niʼkɛ limiɛl là ŋa ŋmɔbe gbenm bo. Nɛn nɛ li cère wà buuh nin wà taakeh kɛ ń li ŋmɔbe uyɛnsɔnge. ");
INSERT INTO gngNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Mikpɛnjɛnm mà teh: ‹Uba buuh, nɛ utɔ taakeh› nnɔ yé imɔ̀n nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Kimɛ n sɔn' nɛ ní tì taan tikpɛjier tà na jɛ̀nde' tuʼbo nɛ. Biba nɛ jɛ̀nde' ki sɔn', nɛ ninbi jondeh biʼtontonku bo.» ");
INSERT INTO gngNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Upii nnɔ tɔke' Samari ya tinfɛnm yaab ki ye *Yesu tɔke' wɔ u tien' nà kɛ ma nnɔ nɛ bi teke' *Yesu ki jin' ki yɛbe, ");
INSERT INTO gngNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","ki baa' uʼsaan, ki gbáan' wɔ ki ye wɔ ń juore biʼsaan, nɛ u tien' nin bɛ iwien ile. ");
INSERT INTO gngNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Binib teke' wɔ ki jin' wɔn bugbɛn ya lenm bo ki yɛbe ki cɛn' bà teke' wɔ ki jin' upii nnɔ ya lenm bo nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Nɛ bi tɔke' upii nnɔ ki ye: «Na ji yé a ya lenm baba bo nɛ ti teke' wɔ ki jin'. Tinbi bugbɛn cii' u len' ma bo, ki bɛnde' ki ye u mɔnbe ki yé uŋɛndun ya Ŋmiɛnl nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Iwien ile nnɔ gɛ̀bre', nɛ *Yesu ñɛn' niʼsaan ki jon' Galile ya tinfɛnm ni. ");
INSERT INTO gngNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Wɔn bugbɛn nɛ là len' ki ye *Uwien ya ñɔbonsɔknl kɛ ñɔbonsɔknl ya tiɛma du ni yaab nɛ ŋa boh wɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ama u tì baa' Galile ya tinfɛnm ni ma nnɔ, bi teke' wɔ kucɛ̀nku mɔnmɔnm nɛ, kimɛ biʼmɔ là jon' Yerusalɛm bɛ ń tì jele kunacenku ma nnɔ, bi là laa' u tien' nà kɛ kunacenku nnɔ ya yo. ");
INSERT INTO gngNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","U liɛbe' ki baa' Kana ya du ni, Galile ya tinfɛnm ni, u là cère' miñunm kpɛnde' midaam nà saan nnɔ. Gobina ya tonsɔnciɛn uba te Kapɛrnawum ya du ni uʼbijɛ bun. ");
INSERT INTO gngNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Utonsɔnciɛn nnɔ cii' *Yesu ñɛn' Sude ya tinfɛnm bó ki baa' Galile ya tinfɛnm ni, nɛ u baa' ki gbáan' *Yesu ki ye wɔ ń jo uʼden, kí cère uʼbijɛ ń faake, kimɛ u benh wɔ ń kpo nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Nɛ *Yesu tɔke' wɔ ki ye: «Na laa' yɔkm ya dìɛku nin yɔkm ya bonn la, na lì li teke nni kí ji-a!» ");
INSERT INTO gngNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Nɛ utonsɔnciɛn nnɔ tɔke' wɔ ki ye: «Yonbdaan, jo nʼden tonm! A taande' la, a li tì baa kí lɛ nʼbuk nnɔ kpo'-a.» ");
INSERT INTO gngNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Nɛ *Yesu ye: «Li kunh, aʼbijɛ faake'-a.» Ujɛ nnɔ teke' *Yesu tɔke' wɔ nà nnɔ ki jin', nɛ ki liɛbe' ki kùnh. ");
INSERT INTO gngNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","U kùnh ma nnɔ nɛ uʼtonsɔnb tuobe' wɔ usɛn ni ki tɔke' wɔ ki ye: «Aʼbijɛ faake'-a.» ");
INSERT INTO gngNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Nɛ u niire' bɛ ki ye: «U lɛ yo ba nɛ uʼgbɛnɛnt tunge'?» Nɛ bi tɔke' wɔ ki ye: «Wenli kutaajuɔku kukurku kuba ya yo nɛ uʼgbɛnɛnt wun sɔnge'.» ");
INSERT INTO gngNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Nɛ ujɛ nnɔ bɛnde' ki ye u ya yo nɛ *Yesu wun tɔke' wɔ ki ye uʼbijɛ faake' ŋɔ. Nɛn saan nɛ wɔn nin uʼden yaab kɛ teke' *Yesu ki jin'. ");
INSERT INTO gngNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Nɛn nɛ tien' miyɔkm ya bonlienn nà *Yesu tien' nɛ̀ uyo wà u ñɛn' Sude ya tinfɛnm ni, ki liɛbe' ní Galile ya tinfɛnm ni nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ni ya puoli bó nɛ Sufmbɛ ya nacenku kuba te Yerusalɛm ni, nɛ *Yesu don' niʼbó. ");
INSERT INTO gngNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Bi là lùke' kujɛbieku kuba Yerusalɛm ni, kù te bi yih nà saan ipe ya nañɔbu nnɔ. *Sufmbɛ ya lenm ni, bi yih kujɛbieku nnɔ Bɛtsata nɛ. Tininbont tuŋun là se ki guɔn' kù. ");
INSERT INTO gngNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Biwiɛnb dɔdɔ tininbont nnɔ ni ki yɛbe. Biba yé ijùɔn, bitɔb yé idiɛn, bitɔb mɔ ya nuɔ nin biʼtàan kɛ faan'. Biʼkɛ là dɔ ki gu uyo wà miñunm li jènge nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Kimɛ uyo uba la, Uwien ya tond uba tì ń jiire ní nɛ kí lá kɔ kujɛbieku nnɔ ni, kí kùkùre miñunm. Uyo wà u baa' ki lá kùreh uwiɛn wà kpiɛ' ki kɔn' la, u bun iwìɛn yà kɛ la, u li faake nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ujɛ uba mɔ là te niʼsaan ki bun ibin pita nin iniin. ");
INSERT INTO gngNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","*Yesu laa' u dɔ, nɛ u bɛnde' ki ye u bunge' nì wuɔke'-a. Nɛ u niire' wɔ ki ye: «A yíe á faake-ee?» ");
INSERT INTO gngNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Nɛ uwiɛn nnɔ jiin' wɔ ki ye: «Yonbdaan, miñunm lá jèngeh la, ma ŋmɔbe nil wà li taa nni kí kuɔn miʼni. N benh ń kɔ la, nɛ uba ń kpiɛ nin nni kí kɔ.» ");
INSERT INTO gngNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Nɛ *Yesu tɔke' wɔ ki ye: «Fii, kí yuure aʼnagɛnl, kí li cuonh.» ");
INSERT INTO gngNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Nɛ u faake' i ya tàan bo, ki yuure' uʼnagɛnl, ki cuonh. Niʼdaali là yé *Saba ya daali nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Nɛn bo nɛ *Sufmbɛ ya ciɛnb tɔke' ujɛ wà faake' nnɔ ki ye: «Dinnɔ yé *Saba ya daali nɛ, ŋa ŋmɔbe sɛn a yuure' aʼnagɛnl kí tuke.» ");
INSERT INTO gngNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Nɛ u tɔke' bɛ ki ye: «Ujɛ wà cère' n faake' nnɔ, wɔn nɛ ye ń yuure nʼnagɛnl kí li cuonh.» ");
INSERT INTO gngNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Nɛ bi niire' wɔ ki ye: «U lɛ daan nɛ ye á yuure aʼnagɛnl kí li cuonh-i?» ");
INSERT INTO gngNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Nɛ ujɛ wà faake' nnɔ ŋa bɛnde' unil wà nɛ, kimɛ linigol là te niʼsaan ma nnɔ wa bɛnde' *Yesu taa' nà bó. ");
INSERT INTO gngNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Uyo uba nɛ *Yesu lá laa' wɔ Uwien ya duku ya luo bo, nɛ ki tɔke' wɔ ki ye: «Liike, fɛnfɛnnɔ a faake'-a! A la ji ń tien biɛre ŋɔ ijɛnd yà cɛn' yiɛ nɔ la tu ŋɛ.» ");
INSERT INTO gngNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Nɛ ujɛ nnɔ jon' ki tì tɔke' *Sufmbɛ ya ciɛnb ki ye *Yesu nɛ cère' u faake'. ");
INSERT INTO gngNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Nɛn bo nɛ Sufmbɛ ya ciɛnb cin' ki kɔnh nin Yesu, kimɛ u cère' unil faake' *Saba ya daali. ");
INSERT INTO gngNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ama *Yesu tɔke' bɛ ki ye: «NʼBaa sɔnh itùon nɛ haali nin fɛnfɛnnɔ, nɛ nʼmɔ sɔnh.» ");
INSERT INTO gngNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","*Yesu len' nnɔ ma nnɔ nɛ Sufmbɛ ya ciɛnb tùɔreh ki nuunh bɛ ń ku wɔ. Na yé u saa' *Saba ya daali ya kuɔl baba nɛ bi nuunh bɛ ń ku wɔ, kimɛ u yin' Uwien wɔn bugbɛn ya Baa ma nnɔ u taa' uʼba ki kpaan' Uwien nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Nɛn saan nɛ *Yesu liɛbe' ki tɔke' bɛ ki ye: «N tɔkeh nɛ imɔ̀n nɛ, Uwien ya Bijɛ ŋa ń fre kí tien niba uʼba bo. U laa' uʼBaa teh nà nnɔ, uʼmɔ teh nɛn nɛ. UʼBaa teh nà nnɔ, uʼmɔ teh nɛn nɛ, ");
INSERT INTO gngNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","kimɛ Baa yíe uʼBijɛ, nɛ ki wuɔn' wɔ u teh nà kɛ. U li wuɔn wɔ itùon yà cɛn' yiɛ nɔ, ŋɔ nɛ̀ ń tùɔre kí cuo nɛ miyɔkm. ");
INSERT INTO gngNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Uwien Baa mɛkreh bitɛnkpiib, ki cèreh bi fuobe ma nnɔ, nnɔ nɛ uʼBijɛ mɔ li cère u yíe bà nnɔ ń li fuobe. ");
INSERT INTO gngNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Uwien Baa ŋa buh nil uba buur, u cɛ̀be' uʼBijɛ nɛ tibuur kɛ, ");
INSERT INTO gngNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ŋɔ binib kɛ ń kpiɛke uʼBijɛ tɛn bi kpiɛkreh uʼBaa ma bo. Unil wà kɛ ŋa kpiɛke' Uwien ya Bijɛ la, wa kpiɛke' uʼBaa wà sɔn' wɔ ní nnɔ mɔ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","«N tɔkeh nɛ imɔ̀n nɛ, unil wà kɛ cii' nʼgbɛr, ki teke' wà sɔn' nni ní ki jin' la, u laa' limiɛl là ŋa ŋmɔbe gbenm nɛ. Uwien ŋa ń biin udaan. U ñɛn' mikuum ni nɛ, ki kɔn' mifuobm ni. ");
INSERT INTO gngNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","N tɔkeh nɛ imɔ̀n nɛ, uyo we ní, nɛ nì yé fɛnfɛnnɔ nɛ, bitɛnkpiib li cii Uwien ya Bijɛ ya niɛke bó. Bà li cii nnɔ li lɛ limiɛl. ");
INSERT INTO gngNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Baa yé limiɛl ya daan ma nnɔ nɛ ki cère' uʼBijɛ mɔ yé limiɛl ya daan, ");
INSERT INTO gngNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","ki de' wɔ ufaa wɔ ń bu binib tibuur, kimɛ u yé Unil ya Bijɛ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","La cère mɛn niɛ kɛ ń cuo nɛ miyɔkm. Uyo we ní, binib bà kɛ te ikul ni nnɔ li cii uʼniɛke bó, ");
INSERT INTO gngNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","kí ñɛ ní. Bà sɔn' lituonmɔnmɔnl nnɔ li mɛkre kí lɛ limiɛl, nɛ bà sɔn' itùonbiɛrɛ nnɔ mɔ li mɛkre ŋɔ Uwien ń bu bɛ tibuur.» ");
INSERT INTO gngNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","«Ma ń fre kí tien niba nʼba bo. N buh binib tibuur nʼBaa ye ma bo nɛ. Nʼbuur cuube nɛ, kimɛ ma nuunh n yíe nà, n nuunh wà sɔn' nni ní nnɔ yíe nà nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","N kundeh nʼba bo imɔ̀n la, na ń tuo nʼmɔ̀nkun nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Uba nɛ kundeh nʼbo imɔ̀n, nɛ n bɛn ki ye u lienh nʼbo nà nnɔ, yé imɔ̀n nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ninbi bugbɛn là sɔn' niʼtondb San saan, nɛ u tì len' nʼbo tigbɛmɔ̀nt. ");
INSERT INTO gngNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Na yé n nuunh unil ya mɔ̀nkun nɛ cère' n tiɛre' nɛ San ya gbɛr. N lienh nnɔ ŋɔ ní ŋmɛre nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","San là te tɛn lifrl là bi sɛ' lɛ̀ lì wendeh nɛ. Ninbi bugbɛn là tuo' ki pokn' uʼwenwenku ni uyo uba. ");
INSERT INTO gngNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ama niba kundeh nʼbo imɔ̀n, ki cɛn' San ya mɔ̀nkun. Nɛn si: nʼBaa de' nni itùon yà nnɔ n sɔnh yɛn nɛ, nɛ n li sɔn yɛ̀ kí tì gben nɛ. Itùon bugbɛn nɛ wɔngeh ki teh nʼBaa nɛ sɔn' nni ní. ");
INSERT INTO gngNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","NʼBaa wà sɔn' nni ní nnɔ, wɔn bugbɛn kundeh nʼbo imɔ̀n nɛ. Ama na cii' uʼniɛke bó, ka laa' wɔ mɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Uʼgbɛr ŋa te niʼfɛ̀l ni, kimɛ na teke' u sɔn' wà ní nnɔ ki jin'. ");
INSERT INTO gngNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ni tùɔreh ki fiinh *Uwien ya gbɔnku, ki maaleh ki teh, ni li lɛ kun ni nɛ limiɛl là ŋa ŋmɔbe gbenm. Kugbɔnku nnɔ nɛ kundeh nʼbo imɔ̀n. ");
INSERT INTO gngNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Nɛ na yíe ní baa nʼsaan kí lɛ limiɛl nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","«Na yé n nuunh ukpiɛke binib saan nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ama n bɛn nɛ, ninbi ŋa ŋmɔbe Wien ya yíem niʼfɛ̀l ni. ");
INSERT INTO gngNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Min baa' nʼBaa ya yel bo nɛ, nɛ na teke' nni. Ama unil baa' wɔn bugbɛn ya yel bo la, ni teknh wɔ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ni yíe ní li kpiɛkreh tɔb nɛ, ka nuunh kpiɛke wà ñɛh ní Uwien baba saan nnɔ. Nɛn bo, ni li tien mila kí teke nni kí ji? ");
INSERT INTO gngNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ni la maaleh ki teh min nɛ li biin nɛ nʼBaa saan. Ni du Moyis wà bo nnɔ, wɔn nɛ li biin nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ni bi teke' Moyis ki jin' la, ni bi li teke nʼmɔ kí ji nɛ, kimɛ Moyis là kɛle' n ya gbɛr nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Na teke' Moyis kɛle' nà nnɔ ki jin' ma nnɔ, ni li tien mila kí teke nʼgbɛr kí ji?» ");
INSERT INTO gngNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ni ya puoli bó nɛ *Yesu puore' Galile ya ñunciɛnm mà bi liɛbe' ki yih mɛ̀ Tiberiyad ya ñunciɛnm nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Binib laa' u teh miyɔkm ya bont, ki cèreh biwiɛnb faakreh ma nnɔ nɛ bi pɛ uʼbo ki yɛbe. ");
INSERT INTO gngNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Nɛ *Yesu nin uʼpanpaankaab don' lijuɔl ki tì kɛ̀le'. ");
INSERT INTO gngNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Nì là sìen' waamu nɛ *Sufmbɛ ya Pak ń jele. ");
INSERT INTO gngNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","*Yesu yaare' ki laa' binib we ní uʼsaan ligol, nɛ u niire' Filip ki ye: «Ti li dɛ tijier lɛ saan ŋɔ binib biɛ ń ji?» ");
INSERT INTO gngNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Wɔn bugbɛn là bɛn u li tien ma bo, nɛ ki niire' Filip ŋɔ wɔ ń cii u li len kí ye bà. ");
INSERT INTO gngNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Nɛ Filip jiin' wɔ ki ye: «Ti taa' iwien kobiile ya tuonl ya paaku mɔnɔn ki dɛ' tijier la, ta ń baa unil kɛ ń lɛ finfiimu kí ji.» ");
INSERT INTO gngNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Nɛ uʼpanpaankaab ya uba, bi yih wà Andre u yé Simɔn Piɛr ya ninjɛ nnɔ tɔke' *Yesu ki ye: ");
INSERT INTO gngNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«Kibujɛbuk kiba te niɛ saan ki ŋmɔbe kpɔnɔ uŋun nin mujɛnwawaamu mule ama binib biɛ yɛbe ki kpɛ ma nɔ, nì li tien bɛ ba?» ");
INSERT INTO gngNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Nɛ *Yesu tɔke' bɛ ki ye: «Cère mɛn binib nnɔ kɛ ń kɛ̀le.» Timɔsɔngt là yɛbe niʼsaan, nɛ bi kɛ̀le' tuʼbo. Bijɛb là li baa tɛn itur iŋun. ");
INSERT INTO gngNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","*Yesu yuure' kpɔnɔ nnɔ, ki faare' Uwien, ki gbiire' binib nnɔ, nɛ ki tien' nnɔ mujɛnwawaamu nnɔ mɔ. U là de' biʼkɛ bi yíe ma bo nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Biʼkɛ ŋmɔn' ki gbo', nɛ u tɔke' uʼpanpaankaab ki ye bɛ ń tantaan tijenjent tà sìen' nnɔ ŋɔ niba la ñɛnde. ");
INSERT INTO gngNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Bi tantaan' binib nnɔ ŋmɔn' kpɔnɔ uŋun nnɔ ki gbo' tijenjent tà sìen nnɔ, ki gbien' ikpɛncub piik nin ile. ");
INSERT INTO gngNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Binib nnɔ laa' *Yesu tien' miyɔkm ya bonn nnɔ ma nnɔ nɛ ki ye: «Ujɛ wuɔ mɔnbe ki yé *Uwien ya ñɔbonsɔknl wà li baa uŋɛndun wuu ni nnɔ nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","*Yesu bɛnde' ki ye bi nuunh bɛ ń cuo wɔ kí tien biʼbɛr, nɛ ki siere' biʼsaan, ki liɛbe' ki don' lijuɔl uʼbaba. ");
INSERT INTO gngNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Kutaajuɔku juɔre' ma nnɔ nɛ uʼpanpaankaab bure' miñunciɛnm bó, ");
INSERT INTO gngNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ki tì kɔn' buñɛrbu, ki joh miñunciɛnm ya kpenpuol, Kapɛrnawum ya du bó. Nì biire' ki laa' *Yesu ŋa laan baa' biʼsaan. ");
INSERT INTO gngNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Kutafaaku fii' ki joh ki gbiekeh, nɛ iñungbegbel fih. ");
INSERT INTO gngNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Bi kùre' buñɛrbu ki baa' kɔnsini uŋun bii uluob, nɛ ki laa' *Yesu cuonh miñunm bo ki nɛkndeh buñɛrbu nnɔ, nɛ bujɛwaanbu cuo' bɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Nɛ u tɔke' bɛ ki ye: «Min nɛ. La sɛn mɛn jɛwaanbu.» ");
INSERT INTO gngNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","U len' nnɔ ma nnɔ biʼyɛnm sɔnge nɛ bi taa' wɔ buñɛrbu nnɔ ni. Nɛ i ya tàan bo bi pɔk ki baa' ugbɛ, bi li ñɛ nà saan buñɛrbu ni. ");
INSERT INTO gngNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Kutaaku faa', nɛ linigol là juore' miñunciɛnm ya gbaatɔl nnɔ tiɛre' ki ye buñɛrbu buba nɛ wun te niʼsaan, ki bɛnde' ki ye bù wun fii' uyo wà nnɔ, *Yesu ŋa kɔn' bù, uʼpanpaankaab baba nɛ wun kɔn' bù ki bure'. ");
INSERT INTO gngNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ama iñɛrtɔ ñɛn' Tiberiyad ya du bó ní ki baa' nà saan Yonbdaan wun taa' kpɔnɔ ki faare' Uwien, ki de' binib bi ŋmɔn' nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Linigol nnɔ laa' *Yesu nin uʼpanpaankaab ŋa ji te niʼsaan ma nnɔ nɛ bi kɔn' iñɛrde nnɔ, ki joh miñunciɛnm ya kpenpuol, Kapɛrnawum ya du bó, bɛ ń tì nuun wɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Bi tì laa' wɔ miñunciɛnm ya kpenpuol, nɛ ki niire' wɔ ki ye: «Cɛnbaa, a baa' niɛ saan u lɛ yo ba?» ");
INSERT INTO gngNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Nɛ u tɔke' bɛ ki ye: «N tɔkeh nɛ imɔ̀n nɛ, ni jin' tijier ki gbo' ma nnɔ, nɛn bo nɛ ni nuunh nni, na yé ni bɛnde' miyɔkm ya bont nnɔ ya tingi nɛ ki nuunh nni. ");
INSERT INTO gngNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","La sɔnh mɛn ki nuunh tijier tà saah. Ama li sɔnh mɛn ki nuunh tijier tà dienh nɛ limiɛl là ŋa ŋmɔbe gbenm. Unil ya Bijɛ nɛ li de nɛ tijier bugbɛn, kimɛ Baa Uwien bugbɛn wuɔn' ki ye u de' wɔn nɛ uʼtuɔm.» ");
INSERT INTO gngNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Nɛ bi niire' wɔ ki ye: «Ti li tien mila kí sɔn Uwien yíe itùon yà?» ");
INSERT INTO gngNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Nɛ *Yesu ye: «Uwien yíe lituonl là si: ní teke min wà u sɔn' nni ní nnɔ nɛ kí ji.» ");
INSERT INTO gngNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Nɛ bi ye: «A li tien mi lɛ yɔkm ya bonn tí lɛ ŋɔ kí teke ŋɛ kí ji? A li sɔn ba? ");
INSERT INTO gngNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Tiʼyaajɛb là jin' tijier tà bi yih tù *mann nnɔ kupenpelku ni. Nì kɛle' *Uwien ya gbɔnku ni ki ye: ‹U de' bɛ tijier tà ñɛn' paaki bó ní bɛ ń ji.› » ");
INSERT INTO gngNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Nɛ *Yesu ye: «N tɔkeh nɛ imɔ̀n nɛ, na yé Moyis nɛ là de' nɛ tijier tà ñɛn' paaki bó ní nnɔ. Ama nʼBaa nɛ dienh nɛ tijiemɔ̀nt tà ñɛh paaki bó ní. ");
INSERT INTO gngNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Kimɛ tijier tà Uwien dienh nɛ tù nnɔ, tun nɛ ñɛh paaki bó ní ki dienh uŋɛndun ya nib limiɛl.» ");
INSERT INTO gngNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Nɛ bi ye: «Yonbdaan, li dienh tɛ tu ya jier uyo kɛ.» ");
INSERT INTO gngNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Nɛ u ye: «Min nɛ yé limiɛl ya jier. Wà kɛ baa' nʼsaan la, kònm ŋa ji li cuo wɔ. Wà kɛ teke' nni ki jin' la, ñuñun ŋa ji li cuo wɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","N kpiɛ' ki tɔke' nɛ ŋɔ: ni laa' nni, ama na nín teke' nni ki jin'. ");
INSERT INTO gngNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Binib bà kɛ nʼBaa taah bɛ ki dienh nni li baa nʼsaan. Wà kɛ baa' nʼsaan la, ma ń wiɛ wɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Kimɛ n ñɛn' paaki bó ní ń lá tien wà sɔn' nni ní yíe nà nɛ, ma baa' ń tien nʼbugbɛn yíe nà. ");
INSERT INTO gngNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Wà sɔn' nni ní yíe nà si: u de' nni binib bà kɛ nnɔ, n la cère biʼni uba ń bole, ama ń mɛkre biʼkɛ uwenfɔrkɛ ya daali. ");
INSERT INTO gngNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Kimɛ nʼBaa yíe nà si: ‹Binib bà kɛ laa' min uʼBijɛ ki teke' nni ki jin' nnɔ ń lɛ limiɛl là ŋa ŋmɔbe gbenm nɛ. Nɛ n li mɛkre bɛ uwenfɔrkɛ ya daali.› » ");
INSERT INTO gngNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","U ya yo nɛ Sufmbɛ ya ciɛnb bunbeh uʼbo, kimɛ u len' ki ye: «Min nɛ yé tijier tà ñɛn' paaki bó ní.» ");
INSERT INTO gngNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Nɛ ki tɔkeh tɔb ki teh: «Ujɛ wuɔ Yosɛf ya bijɛ *Yesu ŋa ñí-ii? Ti bɛn uʼnaa nin uʼbaa-a! Bɛ tien' u len' ki ye u ñɛn' paaki bó ní?» ");
INSERT INTO gngNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Nɛ *Yesu liɛbe' ki tɔke' bɛ ki ye: «La bunbeh mɛn tɔb saan. ");
INSERT INTO gngNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","NʼBaa wà sɔn' nni ní nnɔ ŋa dɛ̀re' nil, ki baa' nʼsaan la, nil ŋa ń fre kí baa nʼsaan. Unil wà kɛ baa' nʼsaan la, n li mɛkre udaan uwenfɔrkɛ ya daali. ");
INSERT INTO gngNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Uwien ya ñɔbonsɔknb là kɛle' ki ye: ‹Uwien li wɔkn biʼkɛ miwɔknm.› Unil wà kɛ cii' nʼBaa len' nà miwɔknm nnɔ ni, ki teke' nɛ̀ la, udaan li baa nʼsaan. ");
INSERT INTO gngNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Uba ŋa laa' Baa Uwien, wà ñɛn' ní uʼsaan nnɔ baba nɛ laa' wɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","N tɔkeh nɛ imɔ̀n nɛ, unil wà teke' nni ki jin' la, u ŋmɔbe limiɛl là ŋa ŋmɔbe gbenm nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Min nɛ yé limiɛl ya jier. ");
INSERT INTO gngNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Niʼyaajɛb là jin' tijier tà bi yih tù *mann nnɔ kupenpelku ni. Nin nɛn kɛ ŋɔ bi kpo'. ");
INSERT INTO gngNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ama tijier tà ñɛn' paaki bó ní nnɔ, unil jin' tun la, wa ń kpo. ");
INSERT INTO gngNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Min nɛ yé tijier tà ñɛn' paaki bó ní ki dienh binib limiɛl. Unil jin' tu ya jier la, u li fuobe nɛ uyo kɛ. Nʼgbɛnɛnt nɛ yé tijier tà n li de tù uŋɛndun ya nib ŋɔ bɛ ń lɛ limiɛl.» ");
INSERT INTO gngNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Nɛn bo nɛ *Sufmbɛ findeh biʼŋmiɛl ni ki teh: «Ujɛ wuɔ li tien mila kí de' tɛ uʼgbɛnɛnt tí ŋmɔn-i?» ");
INSERT INTO gngNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Nɛ *Yesu ye: «N tɔkeh nɛ imɔ̀n nɛ, na ŋmɔnh Unil ya Bijɛ ya gbɛnɛnt, ka ñuh uʼsɛ̀m la, miɛl ŋa te niʼni. ");
INSERT INTO gngNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Unil wà ŋmɔnh nʼgbɛnɛnt ki ñuh nʼsɛ̀m la, limiɛl là ŋa ŋmɔbe gbenm te uʼni, nɛ n li mɛkre wɔ uwenfɔrkɛ ya daali. ");
INSERT INTO gngNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Kimɛ nʼgbɛnɛnt yé tijiemɔ̀nt nɛ, nɛ nʼsɛ̀m yé midɛmɔ̀nm. ");
INSERT INTO gngNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Unil wà ŋmɔnh nʼgbɛnɛnt ki ñuh nʼsɛ̀m la, u tɛ nin nni, nɛ nʼmɔ tɛ nin wɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","NʼBaa yé limiɛl ya daan nɛ ki sɔn' nni ní, wɔn bo nɛ n fuobe. Nnɔ nɛ unil ŋmɔnh nʼgbɛnɛnt la, min bo nɛ uʼmɔ li fuobe. ");
INSERT INTO gngNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Tijier tà ñɛn' paaki bó ní te nnɔ nɛ. Ta te tɛn niʼyaajɛb là jin' tà nnɔ. Bɛn kpo'-a. Ama unil jin' tu ya jier la, u li fuobe nɛ uyo kɛ.» ");
INSERT INTO gngNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","*Yesu là wɔknh *Sufmbɛ ya taanl ya duku kùa te Kapɛrnawum ni nnɔ nɛ ki len' nɛn kɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Uʼpanpaankaab cii' nnɔ ma nnɔ nɛ biʼni bà yɛbe ye: «Tigbɛr tuu faa nɛ. Ŋmɛ li fre kí cenge tù?» ");
INSERT INTO gngNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","U bɛnde' uʼyɛnm ni ki ye bi bunbeh tigbɛr nnɔ bo, nɛ ki niire' bɛ ki ye: «Nì saa' niʼyɛnm nɛ-ɛɛ? ");
INSERT INTO gngNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ni nín ji bi laa' Unil ya Bijɛ liɛbe' ki doh paaki bó u là te nà saan nɛ le? ");
INSERT INTO gngNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","*Mifuoñaanm nɛ dienh limiɛl. Unisaal baba ŋa ń fre kí tien bonn. Tigbɛr tà n tɔke' nɛ nɔ ñɛn' *Mifuoñaanm saan nɛ ki dienh limiɛl. ");
INSERT INTO gngNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ama niʼni biba ŋa teke' ki jin'.» Kimɛ *Yesu là bɛn haali micincinm bà ŋa teke' wɔ ki jin', ki bɛn wà lá li kuɔre wɔ mɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Nɛ u tí ye: «Nɛn bo nɛ n tɔke' nɛ ki ye nʼBaa ŋa cɛ̀be' wà la, wa ń fre kí baa nʼsaan.» ");
INSERT INTO gngNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Kí ñɛ u ya yo nɛ uʼpanpaankaab ni bà yɛbe siere' uʼsaan ka ji tɔkeh nin wɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Nɛ u niire' piik nin bile nnɔ ki ye: «Niʼmɔ yíe ní siere bi?» ");
INSERT INTO gngNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Nɛ Simɔn Piɛr jiin' wɔ ki ye: «Yonbdaan, ti siere' la, ti li jo ŋmɛ saan-i? Sin nɛ ŋmɔbe limiɛl là ŋa ŋmɔbe gbenm ya gbɛr. ");
INSERT INTO gngNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ti teke' ki jin', ki bɛn ki ye sin nɛ yé Uwien ya Niñaan.» ");
INSERT INTO gngNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Nɛ u tɔke' bɛ ki ye: «Min nɛ ŋa gɛ̀nde' nɛ piik nin bile-ee? Ama niʼni uba yé usɛnpol nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","*Yesu len' nnɔ ma nnɔ, u niireh Simɔn Iskariyɔt ya bijɛ Sudas nɛ. Nin Sudas mɔ yé uʼpanpaankaab piik nin bile nnɔ ya uba ma kɛ nnɔ, wɔn nɛ lá li kuɔre wɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ni ya puoli bó nɛ *Yesu cuonh Galile ya tinfɛnm ni, ka yíe wɔ ń jo Sude ya tinfɛnm ni, kimɛ Sufmbɛ ya ciɛnb bà te niʼbó nnɔ nuunh bɛ ń ku wɔ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Tɔ, nì là sìen' waamu nɛ *Sufmbɛ ń jele kunacenku kùa bi yih kù Ininbon ya nacenku nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Nɛ uʼninjiɛb tɔke' wɔ ki ye: «Siere niɛ saan, kí li joh Sude ya tinfɛnm bó ŋɔ aʼpanpaankaab mɔ ń tì lɛ a teh miyɔkm ya bont tà. ");
INSERT INTO gngNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Unil yíe uʼyel ń fii la, wa buɔh u sɔnh nà. A teh miyɔkm ya bont tà nnɔ, cère binib kɛ ń lɛ a teh nà.» ");
INSERT INTO gngNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Kimɛ bɛn uʼninjiɛb mɔnɔn ŋa là teke' wɔ ki jin'. ");
INSERT INTO gngNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Nɛ *Yesu tɔke' bɛ ki ye: «Nʼyo ŋa laan baa'. Ninbi wɔn uyo kɛ mɔn niʼbo nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Uŋɛndun ya nib ŋa ń fre kí li nɛn ninbi. Bi nɛn min nɛ, kimɛ n lienh ki teh biʼtùon bre nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ninbi li joh mɛn kunacenku nnɔ. Min ŋa ń jo, kimɛ nʼyo ŋa laan baa'.» ");
INSERT INTO gngNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","U là tɔke' bɛ nnɔ nɛ ki juore' Galile ya tinfɛnm ni. ");
INSERT INTO gngNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","*Yesu ya ninjiɛb bure' kunacenku nnɔ ma nnɔ nɛ uʼmɔ lɔkre' ki paan'. ");
INSERT INTO gngNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","*Sufmbɛ ya ciɛnb nuunh wɔ kunacenku nnɔ ni, nɛ ki niireh ki teh: «U te lɛ sɔ?» ");
INSERT INTO gngNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Nɛ linigol nnɔ bunbeh ki tɔkeh tɔb uʼgbɛr. Biba teh u yé unimɔ̀n, nɛ bitɔb teh wa yé nimɔ̀n, u tulndeh binib nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ama uba ŋa len' uʼgbɛr paan bo, kimɛ bi fɛnge *Sufmbɛ ya ciɛnb nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Bi jele' kunacenku ki tì gbiire' siik ni uyo wà nnɔ, nɛ *Yesu jon' Uwien ya duku bó, ki tì wɔknh binib Uwien ya gbɛr. ");
INSERT INTO gngNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Nì cuo' *Sufmbɛ miyɔkm, nɛ bi len' ki ye: «Ujɛ wuɔ ŋa bɛnge' gbɔnku-a! U tien' mila ki bɛn kugbɔnku miɛ ya bɛnm-i?» ");
INSERT INTO gngNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Nɛ u tɔke' bɛ ki ye: «N wɔknh binib nà nɔ, na yé min bugbɛn ya wɔknm. Nì yé wà sɔn' nni ní nnɔ ya wɔknm nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Unil yíe wɔ ń tien Uwien yíe nà la, u li bɛnde n wɔknh binib nà nɔ, nì yé Uwien ya wɔknm nɛ bii n lienh min bugbɛn ya yel bo nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Unil wà lienh wɔn bugbɛn ya yel bo la, u nuunh uʼtiɛma kpiɛke nɛ. Unil wà nuunh wà sɔn' wɔ ya kpiɛke la, wɔn nɛ yé ugbɛmɔ̀ndaan, ka ŋmɔbe tonnɛnku. ");
INSERT INTO gngNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moyis nɛ ŋa là de' nɛ *yiko-oo? Nin nɛn kɛ niʼni uba ŋa pɛ yiko nnɔ bo. Bɛ tien' ni nuunh ní ku nni?» ");
INSERT INTO gngNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Nɛ linigol nnɔ tɔke' wɔ ki ye: «Usɛnpol nɛ ŋaake ŋɛ! Ŋmɛ nuunh wɔ ń ku ŋɛ?» ");
INSERT INTO gngNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Nɛ u ye: «N tien' miyɔkm ya bonn niba kpein nɛ *Saba ya daali, nɛ nì cuo' niʼkɛ miyɔkm. ");
INSERT INTO gngNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moyis là ye ní li jɛh ipun. Upunjiɛ ŋa ñɛn' Moyis saan, u ñɛn' niʼyaajɛkpiɛkb saan nɛ. Nɛn bo nɛ *Saba ya daali mɔnɔn, kibuk kà kpaan' ní jiɛ kiʼpunl la, ni jɛh kɛ̀ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ni jɛh ipun *Saba ya daali ŋɔ ni la saa Moyis ya yiko nɛ. Nɛ min cère' uwiɛn ya gbɛnɛnt kɛ faake' *Saba ya daali, nɛ niʼbenku ni ben' nʼbo-oo? ");
INSERT INTO gngNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","La likeh mɛn nib ya nun bó ki buh bɛ buur. Cère mɛn niʼbuur ń li cuube.» ");
INSERT INTO gngNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Yerusalɛm yaab biba lienh ki teh: «Ujɛ wà bi nuunh bɛ ń ku wɔ nnɔ ŋa sɔ-ɔɔ? ");
INSERT INTO gngNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Wɔn nɛ lienh binib ya nun bó ba teh wɔ niba nɔ! Bii tiʼciɛnb mɔnbe ki bɛnde' ki ye u yé Uwien ya Nigɛndkɛ Kristo nɛ? ");
INSERT INTO gngNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","*Kristo lá baa' la, uba ŋa ń bɛnde u ñɛn' nà saan. Ama ujɛ wuɔ wɔn tiʼkɛ bɛn u ñɛn' nà saan.» ");
INSERT INTO gngNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","*Yesu te Uwien ya duku ya luo bo, ki wɔknh binib, nɛ ki len' ufaa bo ki ye: «Ni mɔnbe ki bɛn nni ki bɛn n ñɛn' nà saan-a! Nin nɛn kɛ ŋɔ ma baa' nʼba ya baam. Wà sɔn' nni ní nnɔ yé ugbɛmɔ̀ndaan nɛ. Ama ninbi ŋa bɛn wɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Min wɔn, n bɛn wɔ, kimɛ n ñɛn' wɔn saan nɛ, nɛ wɔn nɛ sɔn' nni ní.» ");
INSERT INTO gngNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Nɛn saan nɛ bi nuunh bɛ ń cuo wɔ. Ama uba ŋa tien' wɔ niba, kimɛ uʼyo ŋa laan là baa'. ");
INSERT INTO gngNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Linigol nnɔ ni binib bà yɛbe nɛ teke' wɔ ki jin', nɛ ki len' ki ye: «Uwien ya Nigɛndkɛ Kristo lá baa' la, u li tien miyɔkm ya bont kí cɛn ujɛ wuɔ tien' ma bo nɔ-ɔɔ?» ");
INSERT INTO gngNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","*Farisiɛnmbɛ cii' linigol nnɔ bunbeh *Yesu bo nà kɛ nnɔ, nɛ bɛn nin bitɔtuɔrciɛnb sɔn' biguguurb bɛ ń tì cuo wɔ ní. ");
INSERT INTO gngNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Nɛ *Yesu tɔke' linigol nnɔ ki ye: «Ma ji li wuɔke niʼsaan, n li liɛbe wà sɔn' nni ní nnɔ bó. ");
INSERT INTO gngNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ni lá li nuun nni ka ń lɛ nni, kimɛ na ń fre kí jo n tì li te nà saan nnɔ.» ");
INSERT INTO gngNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Nɛ *Sufmbɛ niireh tɔb ki teh: «U li jo lɛ saan nɛ ta ń lɛ wɔ? U li jo Grɛkmbɛ ya tinfɛnm mà *Sufmbɛ yɛre' ki te miʼni nnɔ nɛ kí tì ń li wɔknh Grɛkmbɛ-ɛɛ? ");
INSERT INTO gngNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","U len' ki ye ti li nuun wɔ, ka ń lɛ wɔ, ka ń fre kí jo u tì li te nà saan nnɔ. Uʼlenm miɛ nɔ ya tingi si ba?» ");
INSERT INTO gngNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Kunacenku nnɔ ya tontonddaali là yé uwengbenge nɛ. Nɛn daali nɛ *Yesu sere' ki len' ufaa bo ki ye: «Uñuñun ŋmɔbe wà la, wɔ ń dɛn nʼsaan kí ñu. ");
INSERT INTO gngNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Unil wà teke' nni ki jin' la, miñunm mà dienh limiɛl li puube uʼfɛ̀l ni tɛn likpenl nɛ. Nì kɛle' nnɔ nɛ *Uwien ya gbɔnku ni.» ");
INSERT INTO gngNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","U len' nnɔ ma nnɔ, u niireh *Mifuoñaanm mà Uwien lá li de mɛ̀ binib bà teke' wɔ ki jin' nnɔ nɛ. U ya yo ki laa' *Mifuoñaanm ŋa laan là jiire' ní, kimɛ Uwien ŋa laan là kpiɛke' Yesu. ");
INSERT INTO gngNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Linigol nnɔ cii' *Yesu len' nà nnɔ nɛ biba len' ki ye: «Ujɛ wuɔ mɔnbe ki yé *Uwien ya ñɔbonsɔknl wà li baa ní nnɔ nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Bitɔb ye: «U yé Uwien ya Nigɛndkɛ Kristo nɛ.» Nɛ bitɔb mɔ ye: «Kristo li fre kí li yé Galile ya nil-ii? ");
INSERT INTO gngNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Na kɛle' Uwien ya gbɔnku ni ki ye u li yé tiʼyaajɛ *Dafid ya yaabil, kí li yé *Dafid ya du Bɛtelɛm ya nil nɛ-ɛɛ?» ");
INSERT INTO gngNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Nnɔ nɛ Yesu bo, linigol nnɔ ŋa len' ki cii' tɔb bó, nɛ ki gbiire' icɛk ile. ");
INSERT INTO gngNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Biʼni biba là nuunh bɛ ń cuo wɔ ufaa bo nɛ, ama uba ŋa tien' wɔ niba. ");
INSERT INTO gngNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Biguguurb bà bitɔtuɔrciɛnb nin *Farisiɛnmbɛ sɔn' bɛ bɛ ń tì cuo *Yesu nnɔ liɛbe' biʼsaan, nɛ bi niire' bɛ ki ye: «Bɛ tien' na cuo' wɔ ní?» ");
INSERT INTO gngNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Nɛ bi ye: «Nil uba ŋa laan len' tɛn u ya jɛ.» ");
INSERT INTO gngNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Nɛ *Farisiɛnmbɛ nnɔ ye: «Ninbi mɔ cère' u tuln' nɛ nɛ-ɛɛ? ");
INSERT INTO gngNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Biciɛnb nin tinbi *Farisiɛnmbɛ ni, unil te ki teke' wɔ ki jin'-ii? ");
INSERT INTO gngNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Linigol là teke' wɔ ki jin' nnɔ ŋa bɛn *yiko ya gbɛr nɛ. Bi yé binib bà Uwien wiɛ' bɛ miŋùum nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodɛm, *Farisiɛnmbɛ ya uba, wà là jon' *Yesu saan uyo uba nnɔ niire' bɛ ki ye: ");
INSERT INTO gngNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","«Tiʼyiko bo, ti li fre kí biin unil, ka kpiɛ' ki bun' wɔ tibuur ki bɛnde' u tien' nà-aa?» ");
INSERT INTO gngNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Nɛ bi ye: «Sin, aʼmɔ yé Galile yɔ nɛ-ɛɛ? Tùɔre kí fìin *Uwien ya gbɔnku kí liike, a li lɛ Galile ya nil uba mɔnɔn ŋa laan ñɛn' *Wien ya ñɔbonsɔknl?» ");
INSERT INTO gngNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Nɛ biʼkɛ kùn'. ");
INSERT INTO gngNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","*Yesu don' lijuɔl liba bo, bi yih lɛ̀ Olifi ya siin ya juɔl. ");
INSERT INTO gngNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Nì faa' kutɛnŋɛsɔnsɔnku, nɛ u liɛbe' Uwien ya duku bó. Binib taan' uʼsaan ki yɛbe, nɛ u kɛ̀le' ki wɔknh bɛ Uwien ya gbɛr. ");
INSERT INTO gngNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Nɛn saan nɛ *Yiko ya wɔnwɔknb nin *Farisiɛnmbɛ tuke' ní upii uba bi pìln' wɔn nin ujɛ, ki lá sien' linigol nnɔ ya nun bó, ");
INSERT INTO gngNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","nɛ ki tɔke' *Yesu ki ye: «Cɛnbaa, upii wuɔ nɔ, bi pìln' wɔn nin jɛ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moyis ya yiko ni, nì yé liwɔbl nɛ bɛ ń li yèkreh itɛn kí kuuleh ni ya piibol. Tɔ, sin ye ba?» ");
INSERT INTO gngNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Bi là len' nnɔ ŋɔ bɛ ń dɛle *Yesu kudiɛku nɛ, kí lɛ bi li dule nà bo kí biin wɔ. Nɛ *Yesu gòn' ki ŋmɔbe uʼnɔbil ki dɛngeh tingi ni. ");
INSERT INTO gngNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Bi ŋaake ki niireh wɔ ma nnɔ nɛ u yaare' ki tɔke' bɛ ki ye: «Niʼni wà ŋa laan tien' biɛre la, wɔn ń kpiɛ kí wiɛ wɔ litɛnl,» ");
INSERT INTO gngNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","ki liɛbe' ki gòn' ki ŋmɔbe uʼnɔbil ki dɛngeh tingi ni. ");
INSERT INTO gngNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Bi cii' u len' nnɔ ma nnɔ nɛ biʼkɛ siereh uba uba, ki cin' biciɛnb ki tì fɔre' biwaab, ki tì dàan' *Yesu nin upii nnɔ, u se *Yesu ya nun bó. ");
INSERT INTO gngNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Nɛ *Yesu yaare' ki niire' wɔ ki ye: «Upii, bi te lɛ saan-i? Uba ŋa biin' ŋɛ-a?» ");
INSERT INTO gngNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Nɛ u ye: «Yonbdaan, uba ŋa biin' nni.» Nɛ *Yesu ye: «Nʼmɔ ŋa ń biin ŋɛ. Li joh, ki la ji ń li teh biɛre.» ");
INSERT INTO gngNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","*Yesu tí tɔke' linigol ki ye: «Min nɛ yé uŋɛndun ya wenwenku. Unil wà kɛ pɛ nʼbo la, wa ń li cuonh cinñunl ni, ama u li lɛ kuwenwenku kùa dienh limiɛl. ");
INSERT INTO gngNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","«U len' nnɔ ma nnɔ nɛ *Farisiɛnmbɛ tɔke' wɔ ki ye: ‹A kundeh aʼba bo nɛ imɔ̀n. Aʼmɔ̀nkun nnɔ ŋa yé mɔ̀n.› » ");
INSERT INTO gngNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Nɛ u tɔke' bɛ ki ye: «N kundeh nʼba bo imɔ̀n mɔnɔn la, nʼmɔ̀nkun nnɔ yé imɔ̀n nɛ, kimɛ n bɛn n ñɛn' nà saan, ki bɛn n joh nà saan mɔ. Ninbi nɛ ŋa bɛn n ñɛn' nà saan, ka bɛn n joh nà saan mɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ni buh tibuur unisaal buh ma bo nɛ. Min ŋa buh uba buur. ");
INSERT INTO gngNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","N li buh binib tibuur mɔnɔn la, nʼbuur cuube nɛ, kimɛ na yé min baba nɛ buh binib tibuur, min nin nʼBaa wà sɔn' nni ní nnɔ nɛ buh binib tibuur. ");
INSERT INTO gngNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Niʼyiko ni, nì kɛle' ki ye bimɔ̀nkunb bile len' tigbɛbaabt la, biʼmɔ̀nkun nnɔ yé imɔ̀n nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","N yé nʼbugbɛn ya mɔ̀nkunl nɛ. Nɛ nʼBaa wà sɔn' nni ní nnɔ mɔ yé nʼmɔ̀nkunl.» ");
INSERT INTO gngNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Nɛ bi niire' wɔ ki ye: «Aʼbaa te la?» Nɛ u jiin' bɛ ki ye: «Na bɛn nni, ka bɛn nʼBaa mɔ. Ni bi bɛn nni la, ni bi li bɛnde nʼBaa mɔ.» ");
INSERT INTO gngNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","U lienh nnɔ, ki laa' u te Uwien ya duku ya luo bo nɛ, bi dienh Uwien mipum nà saan nnɔ, ki wɔknh binib. Uba ŋa cuo' wɔ, kimɛ uʼyo ŋa laan baa'. ");
INSERT INTO gngNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","*Yesu tí tɔke' bɛ ki ye: «N bureh nɛ. Ni li nuun nni, ka ń lɛ nni, kí tì kpo nin niʼbiɛre. N joh nà saan nnɔ, na ń fre kí jo niʼsaan.» ");
INSERT INTO gngNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Nɛ Sufmbɛ niireh tɔb ki teh: «U ye wɔ ń ku uʼba nɛ bii? Kimɛ u len' ki ye u jo nà saan nnɔ, ta ń fre kí jo niʼsaan.» ");
INSERT INTO gngNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Nɛ u tɔke' bɛ ki ye: «Ninbi yé kitink bo yaab nɛ. Ama min ñɛn' ní paaki bó nɛ. Ni yé uŋɛndun wuu yaab nɛ, nɛ min ŋa yé uŋɛndun wuu yɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Nɛn bo nɛ n tɔke' nɛ ki ye ni li kpo nin niʼbiɛre. Kimɛ na teke' ki jin' ki ye n yé n yé wà ma nnɔ ni li kpo nin niʼbiɛre nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Nɛ bi niire' wɔ ki ye: «A yé ŋmɛ?» Nɛ u ye: «N tɔke' nɛ micincinm ki ye n yé wà nnɔ, n yé wɔn nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","N ŋmɔbe tigbɛr tù yɛbe ń len niʼbo kí biin nɛ. Ama wà sɔn' nni ní nnɔ yé ugbɛmɔ̀ndaan nɛ. N cii' tigbɛr tà uʼsaan nnɔ n tɔkeh tun nɛ uŋɛndun yaab.» ");
INSERT INTO gngNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","*Yesu len' nnɔ ma nnɔ, ba bɛnde' ki ye u lienh uʼBaa ya gbɛr nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Nɛn saan nɛ u tɔke' bɛ ki ye: «Ni li fin Unil ya Bijɛ uyo wà paaki bó nnɔ nɛ kí bɛnde kí ye ‹n yé n yé wà› nɛ. Ni li bɛnde kí ye ma sɔnh niba nʼba bo. N tɔkeh nʼBaa wɔkn' nni nà nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Wà sɔn' nni ní nnɔ te nin nni nɛ. Wa dàan nni nʼbaba, kimɛ n teh nà sɔnge uʼyɛnm nɛ uyo kɛ.» ");
INSERT INTO gngNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","*Yesu lienh nnɔ ma nnɔ nɛ binib teke' wɔ ki jin' ki yɛbe. ");
INSERT INTO gngNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Nɛ *Yesu tɔke' *Sufmbɛ bà teke' wɔ ki jin' nnɔ ki ye: «Ni pɛ nʼgbɛr bo ka dàan' tù la, ni mɔnbe ki yé nʼpanpaankaab nɛ, ");
INSERT INTO gngNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","ki li bɛnde tigbɛmɔ̀nt. Nɛ tigbɛmɔ̀nt nnɔ li ñɛn nɛ tiyonbt ni.» ");
INSERT INTO gngNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Nɛ bi ye: «Ti yé *Abraham ya yaabii nɛ. Uba ŋa lì cuo' tɛ yonbt. Bɛ tien' a ye ti li ñɛ tiyonbt ni?» ");
INSERT INTO gngNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Nɛ u ye: «N tɔkeh nɛ imɔ̀n nɛ, wà kɛ teh ibiɛre la, u yé ibiɛre ya yonb nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Uyonb ŋa ń li tuu ki yé uʼyonbdaan den yɔ. Ama unil maa' uʼbijɛ la, u li tuu ki yé uʼden yɔ uyo kɛ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Nɛn bo nɛ Uwien ya Bijɛ ñɛn' nɛ tiyonbt ni la, ni li mɔnbe kí ñɛ tuʼni nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","N bɛn ki ye ni yé *Abraham ya yaabii nɛ. Ama ni nuunh ní ku nni nɛ, kimɛ na tuo' nʼgbɛr. ");
INSERT INTO gngNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Min tɔkeh nɛ n laa' nà nʼBaa saan nɛ. Nɛ ninbi teh ni cii' nà niʼbaa saan.» ");
INSERT INTO gngNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Nɛ bi ye: «Tiʼbaa si *Abraham nɛ.» Nɛ u ye: «Ni bi yé *Abraham ya bumu la, ni bi li sɔnh u là sɔn' ma bo nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","N tɔke' nɛ n cii' tigbɛmɔ̀nt tà Uwien saan nnɔ, nɛ ni nuunh ní ku nni. *Abraham ŋa là tien' nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ninbi teh tɛn niʼbaa nɛ.» Nɛ bi ye: «Tinbi ŋa yé gbaandbumu. Ti ŋmɔbe Baa uba nɛ. Wɔn si Uwien.» ");
INSERT INTO gngNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Nɛ u ye: «Niʼbaa bi si Uwien la, ni bi li yíe nni nɛ, kimɛ n ñɛn' ní Uwien saan nɛ. Ma baa' nʼba ya baam, wɔn nɛ sɔn' nni ní. ");
INSERT INTO gngNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Bɛ tien' na ciih n lienh ki teh bà? Kimɛ na lì yíe ní cenge nʼgbɛr nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Niʼbaa si usɛnpol nɛ, nɛ ni nuunh ní li teh u yíe nà. U yé unikul nɛ haali uŋɛndun ya cinm, ka tɔkeh gbɛmɔ̀nt, kimɛ gbɛmɔ̀nt ŋa te uʼni. Uʼlenm si kutonnɛnku nɛ, kimɛ u yé utonnɛndaan nɛ, ki yé kutonnɛnku ya baa. ");
INSERT INTO gngNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ama min tɔkeh tigbɛmɔ̀nt nɛ. Nɛn nɛ cère' na teknh nʼgbɛr ki jinh. ");
INSERT INTO gngNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Niʼni, ŋmɛ li fre kí wuɔn kí ye n fii' ma, n tien' ibiɛre? N tɔkeh tigbɛmɔ̀nt nɛ. Bɛ tien' na teknh nʼgbɛr ki jinh-i? ");
INSERT INTO gngNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Unil wà kɛ yé Uwien yɔ la, wɔn nɛ ciih Uwien ya gbɛr. Ninbi ŋa ciih, kimɛ na yé uʼyaab.» ");
INSERT INTO gngNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","*Sufmbɛ tɔke' wɔ ki ye: «Ta bi len'-ii? A yé Samari ya nil nɛ. Usɛnpol nɛ ŋaake ŋɛ.» ");
INSERT INTO gngNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Nɛ u tɔke' bɛ ki ye: «Sɛnpol ŋa ŋaake nni. N boh nʼBaa nɛ, nɛ ninbi ŋa boh nni. ");
INSERT INTO gngNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Min ŋa nuunh ń kpiɛke nʼba; uba nɛ kpiɛkreh nni. Wɔn nɛ si wɔ ń liike tu ya gbɛr. ");
INSERT INTO gngNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","N tɔkeh nɛ imɔ̀n nɛ, unil boh nʼgbɛr la, wa ń kpo fiebu.» ");
INSERT INTO gngNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Nɛ *Sufmbɛ tɔke' wɔ ki ye: «Fɛnfɛnnɔ wuɔ ti bɛnde' ki ye usɛnpol nɛ ŋaake ŋɛ. Tiʼyaajɛ *Abraham nin *Uwien ya ñɔbonsɔknb là kpo', nɛ sin len' ki ye unil boh aʼgbɛr la, wa ń kpo fiebu-a! ");
INSERT INTO gngNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","A cɛn' tiʼyaajɛ *Abraham nɛ-ɛɛ? Wɔn nin *Uwien ya ñɔbonsɔknb kɛ kpo'. Sin yé ŋmɛ nɛ?» ");
INSERT INTO gngNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Nɛ u tɔke' bɛ ki ye: «N bi kpiɛkreh nʼba nɛ la, nʼkpiɛke nnɔ bi yé fɛnm nɛ. NʼBaa nɛ kpiɛkreh nni, wɔn wà ni ye u yé niʼWien nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Na bɛn wɔ, ama min bɛn wɔ. N bi ye ma bɛn wɔ la, n bi li tien utonnɛndaan tɛn ninbi nɛ. Ama min bɛn wɔ, nɛ ki boh uʼgbɛr. ");
INSERT INTO gngNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Niʼyaajɛ *Abraham là maale' ki ye u li lɛ nʼyo, nɛ ki pokn'. U laa' nʼyo nnɔ, nɛn bo nɛ u là ŋmɔbe uyɛnsɔnge.» ");
INSERT INTO gngNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Nɛ *Sufmbɛ ye: «Ŋa baa' ibin piŋun, nɛ ki ye a laa' *Abraham?» ");
INSERT INTO gngNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Nɛ u ye: «N tɔke' nɛ imɔ̀n nɛ, ba laan là maa' *Abraham ma nnɔ ki laa' n te nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Nɛn saan nɛ bi gɛ̀nde' itɛn bɛ ń yèke kí ku wɔ, nɛ u lɔkre' ki ñɛn' Uwien ya duku ya luo bo. ");
INSERT INTO gngNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","*Yesu cuonh ki joh nɛ ki tì laa' ujɛ uba, bi maa' wɔ ujuɔn. ");
INSERT INTO gngNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Nɛ uʼpanpaankaab niire' wɔ ki ye: «Cɛnbaa, ujɛ wuɔ nɛ tien' ibiɛre bii uʼnaa nin uʼbaa nɛ tien' ŋɔ bi maa' wɔ ujuɔn-i?» ");
INSERT INTO gngNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Nɛ *Yesu jiin' bɛ ki ye: «Na yé ujɛ bugbɛn ya biɛre bo, ka yé uʼnaa bii uʼbaa ya biɛre mɔ bo. Nì te nnɔ ŋɔ unil kɛ ń lɛ Uwien li sɔn lituonl là kí de wɔ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Nì laan wien ma nɔ, nì kpɛ tí sɔn wà sɔn' nni ní nnɔ ya tuonl nɛ. Nì li biire, nɛ nil ŋa ń fre kí sɔn. ");
INSERT INTO gngNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","N laan te uŋɛndun ni ma nɔ, n yé uŋɛndun ya wenwenku nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","U len' nnɔ ki tì gben', nɛ ki sii' tiñinsɛnt tingi ni, ki taa' uʼnɔbil ki bunbun' titɛnt, ki fàan' ujuɔn nnɔ ya nun, ");
INSERT INTO gngNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ki tɔke' wɔ ki ye: «Jo kí tì fɛnde kujɛbieku kùa bi yih kù Silowe nnɔ ni.» Silowe ya tingi si: Bi sɔn' wà. Ujuɔn nnɔ jon' ki tì fɛnde' ki liɛbeh ní ma nnɔ, u ji like nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Nɛ ukɔnkuɔnlieb nin binib bà bɛn ki ye u yé wà tì ń miɛh nnɔ niireh tɔb ki teh: «Na yé ujɛ wuɔ nɛ là tì ń kɛ ki miɛh nnɔ-ɔɔ?» ");
INSERT INTO gngNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Biba ye wɔn nɛ. Bitɔb ye bi naan nɛ, wɔn ŋa ñí. Nɛ wɔn bugbɛn ye: «Min nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Nɛ bi niire' wɔ ki ye: «Aʼnun likre' mila bo?» ");
INSERT INTO gngNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Nɛ u tɔke' bɛ ki ye: «Ujɛ wà bi yih wɔ *Yesu nnɔ, wɔn nɛ bun' titɛnt ki fàan' nʼnun, nɛ ki tɔke' nni ki ye ń li joh Silowe ya jɛbieku ni kí tì fɛnde. N jon' ki tì fɛnde', nɛ ki likre'.» ");
INSERT INTO gngNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Nɛ bi niire' wɔ ki ye: «U te lɛ saan-i?» Nɛ u ye: «Ma bɛn.» ");
INSERT INTO gngNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Nɛ bi taa' wɔ ki jon' *Farisiɛnmbɛ saan. ");
INSERT INTO gngNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Tɔ, lidaali là *Yesu bun' titɛnt ki likre' ujuɔn nnɔ là yé *Saba ya daali nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Nɛ *Farisiɛnmbɛ mɔ niire' ujɛ wà là yé ujuɔn nnɔ nì tien ma bo ŋɔ u likre'. Nɛ u tɔke' bɛ ki ye: «U bun' titɛnt nɛ ki fàan' nʼnun, nɛ n fɛnde', ki likre'.» ");
INSERT INTO gngNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Nɛ *Farisiɛnmbɛ ya biba ye: «Ujɛ bugbɛn ŋa ñɛn' ní Wien saan, kimɛ wa boh *Saba ya daali.» Nɛ bitɔb ye: «Unil yé ubiɛrdaan la, wa ń fre kí tien yɔkm ya bont tɛn u teh ma nɔ.» Bi len' ka cii' tɔb bó nɛ ki gbiire' icɛk ile. ");
INSERT INTO gngNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Nɛ bi liɛbe' ki niire' ujɛ wà là yé ujuɔn nnɔ ki ye: «Sin wà u likre' ŋɛ nnɔ, a maaleh ki teh u yé ŋmɛ nɛ?» Nɛ u ye: «U yé *Uwien ya ñɔbonsɔknl uba nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","*Sufmbɛ ya ciɛnb ŋa teke' ki jin' ki ye u là yé ujuɔn, nɛ ki likre'. Nɛ ki yin' uʼnaa nin uʼbaa ní ");
INSERT INTO gngNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ki lá niire' bɛ ki ye: «Niʼbijɛ sɔ nɔ-ɔɔ? Ni maa' wɔ ujuɔn nɛ-ɛɛ? Nì tien' mila u ji likeh fɛnfɛnnɔ wuɔ nɔ?» ");
INSERT INTO gngNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Nɛ uʼnaa nin uʼbaa ye: «Ti bɛn ki ye tiʼbijɛ nɛ. Ti là maa' wɔ ujuɔn nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ama ta bɛn nì tien' ma u likre' fɛnfɛnnɔ wuɔ nɔ, ka bɛn udaan wà likre' wɔ mɔ. Wa ji yé buk, niire wɔ mɛn. U li tɔke nɛ uʼgbɛr.» ");
INSERT INTO gngNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Uʼnaa nin uʼbaa là fɛnge *Sufmbɛ ya ciɛnb ma nnɔ nɛ cère' bi len' nnɔ, kimɛ *Sufmbɛ ya ciɛnb là kpaan' buñɔbu ki ye wà len' ki ye *Yesu yé Uwien ya Nigɛndkɛ Kristo la, bi li ŋɔre wɔ biʼtaanl ya duku ni nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Nɛn bo nɛ uʼnaa nin uʼbaa len' ki ye: «Wa ji yé buk, niire wɔ mɛn.» ");
INSERT INTO gngNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","*Farisiɛnmbɛ tí yin' ujɛ wà là yé ujuɔn nnɔ, ki lá tɔke' wɔ ki ye: «Tɔke tigbɛmɔ̀nt Uwien ya nun bó. Tinbi bɛn ki ye ujɛ bugbɛn yé ubiɛrdaan nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Nɛ u ye: «U yé ubiɛrdaan la, ma bɛn. N bɛn nà nnɔ nɛn si: N là yé ujuɔn nɛ, fɛnfɛnnɔ wuɔ n likre'.» ");
INSERT INTO gngNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Nɛ bi niire' wɔ ki ye: «U tien' mila ki likre' ŋɛ?» ");
INSERT INTO gngNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Nɛ u jiin' bɛ ki ye: «N kpiɛ' ki tɔke' nɛ, nɛ na tuo' ní cii. Bɛ bo nɛ ni nuunh ń tí ń liɛbe kí tɔke nɛ? Niʼmɔ la lii nuunh ní tien uʼpanpaankaab nɛ-a?» ");
INSERT INTO gngNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","U len' nnɔ ma nnɔ nɛ bi suke' wɔ, ki tɔke' wɔ ki ye: «Sin nɛ yé uʼpanpaankɛ. Tinbi yé Moyis ya panpaankaab nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Tinbi bɛn ki ye Uwien là tɔke' Moyis nɛ tigbɛr, ama ujɛ wuɔ wɔn, ta bɛn u ñɛn' nà saan.» ");
INSERT INTO gngNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Nɛ u ye: «Liike mɛn miyɔkm ya bonn-a! U likre' nni, nɛ na bɛn u ñɛn' nà saan-a! ");
INSERT INTO gngNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ti bɛn ki ye Uwien ŋa cengeh biɛrdaan ya kaare. Unil boh Uwien ki teh Uwien ya yíem la, Uwien cengeh u ya kaare nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Uŋɛndun ya cincinyo kí lá baa dinnɔ, ta laan cii' nil likre' wà bi maa' wɔ ujuɔn. ");
INSERT INTO gngNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ujɛ bugbɛn ŋa bi ñɛn' ní Uwien saan la, wa bi li fre kí tien niba.» ");
INSERT INTO gngNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Nɛ bi tɔke' wɔ ki ye: «Bi maa' sin a yé ubiɛrdaan, nɛ a yíe á wɔkn tinbi-ii?» Nɛ ki ŋɔre' wɔ ki ñɛn' litaanl ya duku ni. ");
INSERT INTO gngNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","*Yesu cii' bi ŋɔre' wɔ ki ñɛn' litaanl ya duku ni. Nɛ u jon' ki tì laa' wɔ, ki niire' wɔ ki ye: «Sin, a teke' Unil ya Bijɛ ki jin'-ii?» ");
INSERT INTO gngNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Nɛ u jiin' wɔ ki ye: «Cɛnbaa, ŋmɛ nɛ yé Unil ya Bijɛ? Tɔke nni ŋɔ ń teke wɔ kí ji.» ");
INSERT INTO gngNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Nɛ *Yesu ye: «A laa' wɔ; wɔn nɛ tɔkeh ŋɛ tigbɛr nɔ.» ");
INSERT INTO gngNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Nɛ u ye: «Yonbdaan, n teke' ŋɛ ki jin',» nɛ ki gbaan' uʼnintuɔli ki puke' wɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Nɛ *Yesu ye: «N baa' uŋɛndun wuu ni, ń bu tibuur nɛ, kí cère binib bà ŋa lɛnh ń likre, ŋɔ bà like ń juɔn.» ");
INSERT INTO gngNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Farisiɛnmbɛ bà te uʼsaan nnɔ cii' u len' ma bo, nɛ ki niire' wɔ ki ye: «Tiʼmɔ yé ijùɔn nɛ-ɛɛ?» ");
INSERT INTO gngNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Nɛ u tɔke' bɛ ki ye: «Ni bi yé ijùɔn la, na bi li ŋmɔbe biɛre. Ama ni lienh ki teh ni yé binunyaanb nɛ, nɛn bo nɛ ni juore' ki te niʼbiɛre ni.» ");
INSERT INTO gngNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","«N tɔkeh nɛ imɔ̀n nɛ, unil wà maabe' ki kɔn' upepɛke ni, ka ñɛn' nañɔbu ki kɔn' la, u yé unasu nɛ, ki yé udukond. ");
INSERT INTO gngNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ama unil wà ñɛh bunañɔbu ki kɔh nnɔ, wɔn nɛ yé upekpaal. ");
INSERT INTO gngNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Unil wà gu bunañɔbu nnɔ li pìire wɔ bù nɛ. Ipe bɛn uʼniɛke. U yih wɔn bugbɛn ya pe ya yel, nɛ ki ñɛndeh yɛ̀. ");
INSERT INTO gngNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","U tì ñɛn' uʼpe kɛ la, u le usɛn nɛ ì pɛ uʼbo, kimɛ ì bɛn uʼniɛke. ");
INSERT INTO gngNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ya ń paan caan bo. Ì li sɛn wɔ nɛ mɔnɔn, kimɛ ya bɛn cɛnb ya niɛke.» ");
INSERT INTO gngNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","*Yesu pɔn' bɛ mikpɛnjɛnm miɛ nɔ, ama ba cii' miʼtingi. ");
INSERT INTO gngNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Nɛ u tí tɔke' bɛ ki ye: «N tɔkeh nɛ imɔ̀n nɛ, min nɛ yé upepɛke ya nañɔbu. ");
INSERT INTO gngNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Binib bà kɛ kpiɛ' ki baa' nin nni nnɔ yé binasub nɛ, ki yé idukond, ama ipe ŋa cenge' biʼbó. ");
INSERT INTO gngNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Min nɛ yé bunañɔbu. Unil ñɛn' min ki kɔn' la, u li ŋmɛre, kí li kɔh ki ñɛh, ki li lɛ u li ji bà. ");
INSERT INTO gngNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Unasu baa' la, u nuunh wɔ ń suu ipe kí kòkòre kí sasaa nɛ. Min baa' ń lá de yɛ̀ limiɛl nɛ, ŋɔ niba la pɔre iʼfuobm ni. ");
INSERT INTO gngNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","«Min nɛ yé upekpaamɔ̀n. Upekpaamɔ̀n li tuo kí kpo uʼpe bo. ");
INSERT INTO gngNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Unil wà ŋa cinbe ki yé pekpaal ki kpaah ipe ilike bo, ŋɔ ka yé pedaan mɔ nnɔ, laa' ukɛ̀r we ní la, u li sɛn kí cère yɛ̀ nɛ. Ukɛ̀r li cuo iba, nɛ yà sìen' ń yɛyɛre. ");
INSERT INTO gngNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Wà kpaah ipe ilike bo nnɔ ŋa tɔnge yɛ̀. Nɛn nɛ cère u li sɛn kí dàan yɛ̀. ");
INSERT INTO gngNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Min yé upekpaamɔ̀n nɛ, ki bɛn nʼpe, nɛ nʼpe mɔ bɛn nni, ");
INSERT INTO gngNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","tɛn nʼBaa bɛn nni ma, nʼmɔ bɛn wɔ nnɔ. Nɛ min li tuo kí kpo nʼpe bo. ");
INSERT INTO gngNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","N ŋmɔbe ipetɔ yà ŋa yé upepɛke wuu ya pe. N lì li kpaa iʼmɔ nɛ, nɛ ì li cengeh nʼniɛke bó. Iʼkɛ li taan kí tien upepɛke uba nɛ, kí li ŋmɔbe upekpaal uba. ");
INSERT INTO gngNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","NʼBaa yíe nni, kimɛ n li tuo kí kpo, ŋɔ kí liɛbe kí mɛkre. ");
INSERT INTO gngNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Uba ŋa ń fre kí ku nni. Min nɛ tuo' bɛ ń ku nni. N ŋmɔbe mituɔm ń kpo, ki ŋmɔbe mituɔm ń mɛkre mɔ. NʼBaa nɛ cɛ̀be nni ń tien nnɔ.» ");
INSERT INTO gngNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","*Yesu len' nnɔ nɛ Sufmbɛ ya gbɛr ŋa tí cende'. ");
INSERT INTO gngNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Biʼni bà yɛbe tɔke' ki ye: «Usɛnpol uba nɛ ŋaake wɔ. U waare' nɛ. Bɛ tien' ni cengeh uʼbó?» ");
INSERT INTO gngNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Nɛ bitɔb ye: «Uʼlenm ŋa yé unil wà usɛnpol ŋaake wɔ ya lenm. Unil wà usɛnpol ŋaake wɔ li fre kí likre ijùɔn-ii?» ");
INSERT INTO gngNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Sufmbɛ là jeleh kunacenku Yerusalɛm ni ki tiɛn bi là tien' lituɔrl ki mɔnge' Uwien ya duku uyo wà nnɔ nɛ. Nì là yé tiwɔrciɛnt ya yo nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","*Yesu là cuonh ki joh ki liɛbeh Salomɔn ya ninbonku ni Uwien ya duku ya luo bo. ");
INSERT INTO gngNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","*Sufmbɛ ya ciɛnb guɔn' wɔ, nɛ ki niire' wɔ ki ye: «A li cère tí li jie nɛ̀ ń tì wuɔke-a? A yé Uwien ya Nigɛndkɛ Kristo la, tɔke tɛ imɔ̀n.» ");
INSERT INTO gngNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Nɛ u tɔke' bɛ ki ye: «N là tɔke' nɛ, nɛ na teke' nni ki jin'. N sɔnh itùon yà nʼBaa ya yel bo nnɔ nɛ wɔngeh n yé udaan wà. ");
INSERT INTO gngNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ninbi ŋa yé nʼpe. Nɛn bo nɛ na teke' nni ki jin'. ");
INSERT INTO gngNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Nʼpe cengeh nʼniɛke bó. N bɛn yɛ̀, nɛ ì pɛ nʼbo. ");
INSERT INTO gngNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","N dienh nʼpe limiɛl là ŋa ŋmɔbe gbenm. Ya ń kpo kí juore fɛnm, uba mɔ ŋa ń fre kí fie yɛ̀ nʼsaan. ");
INSERT INTO gngNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","NʼBaa nɛ de' nni yɛ̀; uʼtuɔm cɛn' mituɔm kɛ. Uba ŋa ń fre kí fie bonn wɔn nʼBaa ya nuɔ ni. ");
INSERT INTO gngNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Min nin nʼBaa te miba nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Nɛ *Sufmbɛ ya ciɛnb tí yuure' itɛn bɛ ń yèke kí ku wɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Nɛ u tɔke' bɛ ki ye: «N sɔn' niʼnun bó itùonmɔnmɔn ì yɛbe nʼBaa ya yel bo. Li lɛ tuonl bo nɛ ni nuunh ní yèke nni itɛn kí ku nni?» ");
INSERT INTO gngNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Nɛ *Sufmbɛ ya ciɛnb ye: «Na yé tuonmɔnmɔnl bo nɛ ti nuunh tí yèke ŋɛ itɛn kí ku ŋɛ. A suke' Uwien nɛ. Sin yé unil, nɛ ki taah aʼba ki teh Uwien.» ");
INSERT INTO gngNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Nɛ u ye: «Nì kɛle' niʼyiko ya gbɔnku ni ki ye ni yé iwien nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ti bɛn ki ye uba ŋa ń fre kí ŋmire nà kɛle' *Uwien ya gbɔnku ni. Tɔ, Uwien là tɔke' binib bà uʼgbɛr nnɔ, u ye bi yé iwien nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Nɛ min wà Uwien gɛ̀nde' nni ki sɔn' nni ní uŋɛndun wuu ni nnɔ, n len' ki ye n yé uʼBijɛ, nɛ ni ye n suke' wɔ-ɔɔ? ");
INSERT INTO gngNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ma sɔnh nʼBaa ya tùon la, la teke nni mɛn kí ji. ");
INSERT INTO gngNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ama n sɔnh yɛ̀ la, na lì li teke nni kí ji mɔnɔn la, teke mɛn n sɔnh itùon yà nnɔ kí ji, ŋɔ kí bɛnde mɔnmɔnm kí ye nʼBaa tɛ nin nni, nɛ nʼmɔ tɛ nin wɔ.» ");
INSERT INTO gngNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Nɛn saan nɛ bi tí nuunh bɛ ń cuo wɔ, nɛ u ŋmɛre' biʼnuɔ ni. ");
INSERT INTO gngNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","U liɛbe' ki jon' Sudɛn ya kpenpuol bó, ki tì te San là cin' ki siih binib Uwien ya ñunm nà saan nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Nɛ binib baa' uʼsaan ki yɛbe, ki len' ki ye: «San ŋa là tien' yɔkm ya bonn niba, ama u là len' ujɛ wuɔ ya gbɛr tà nnɔ yé imɔ̀n nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Nɛ binib teke' Yesu ki jin' niʼsaan ki yɛbe. ");
INSERT INTO gngNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Ujɛ uba nɛ là te ki bun, bi yih wɔ Lasaar. U yé Mari nin Mart ya ninjɛ nɛ. Wɔn nin bɛn kɛ là kɔh udu uba ni nɛ, bi yih wù Betani. Mari nnɔ yé upii wà là taa' lɛfina ki wule' Yonbdaan ya tàan bo, ki taa' uʼyur ki ŋmiŋmire' yɛ̀ nnɔ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ujɛ nnɔ ya ninsiɛb nnɔ sɔn' bi tì tɔke' *Yesu ki ye: «Yonbdaan, unil wà a yíe wɔ nnɔ bun nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yesu cii' ma nnɔ nɛ ki ye: «Iwìɛn bugbɛn ŋa yé kuum. Ama ì li cère binib ń kpiɛke Uwien ŋɔ kí kpiɛke wɔn Uwien ya Bijɛ mɔ.» ");
INSERT INTO gngNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesu là yíe Mart nin uʼninsɛ nin Lasaar ya gbɛr. ");
INSERT INTO gngNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","U cii' Lasaar bun ma nnɔ nɛ u juore' ki tien' u te nà saan nnɔ iwien ile. ");
INSERT INTO gngNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Iwien ile nnɔ gɛ̀bre' nɛ u tɔke' uʼpanpaankaab ki ye: «Cère mɛn tí liɛbe Sude ya tinfɛnm bó.» ");
INSERT INTO gngNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Nɛ uʼpanpaankaab ye: «Cɛnbaa, na yé idɛn yiɛ nɛ Sufmbɛ là nuunh bɛ ń yèke itɛn kí ku ŋɛ niʼbó nɛ a tí liɛbeh niʼbó-oo?» ");
INSERT INTO gngNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Nɛ u jiin' bɛ ki ye: «Uwien uba ŋa te tikur piik nin tule-ee? Unil cuonh uwien ni la, wa ń gbiɛre, kimɛ uŋɛndun wuu ya wenwenku nɛ cèreh u lɛnh. ");
INSERT INTO gngNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ama unil cuonh kuñɔnku la, u li gbiɛre nɛ, kimɛ na wien.» ");
INSERT INTO gngNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yesu len' nnɔ ki tì gben', nɛ ki tí ye: «Tiʼjɔ Lasaar gùɔn'-a, ama n li jo kí tì fìnde wɔ.» ");
INSERT INTO gngNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Nɛ uʼpanpaankaab ye: «Yonbdaan, u gùɔn' la, u li faake-a!» ");
INSERT INTO gngNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yesu là yíe wɔ ń tɔke kí ye Lasaar kpo' nɛ. Ama uʼpanpaankaab bɛn maaleh ki teh u lienh migɔmɔ̀nm ya gbɛr nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Nɛn saan nɛ *Yesu ji tɔke' bɛ nì wien ki ye: «Lasaar kpo'-a! ");
INSERT INTO gngNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","U kpo', ma te niʼsaan ma nnɔ, ninbi bo nɛ nì tien' nni uyɛnsɔnge, kimɛ nɛn nɛ li cère ní tùɔre kí teke nni kí ji. Tí jo mɛn uʼbó.» ");
INSERT INTO gngNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Nɛ uʼpanpaankaab ya uba, bi yih wà Toma ki liɛbe' ki yih wɔ lilebl nnɔ tɔke' bitɔb ki ye: «Cère mɛn tiʼmɔ ń jo kí tì kpo nin wɔ.» ");
INSERT INTO gngNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","*Yesu tì baa' Betani ya du ni uyo wà nnɔ, ki laa' Lasaar tien' likul ni iwien inan nínɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani ŋa fɔke nin Yerusalɛm. Nì li te tɛn kɔnsini uta nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Nɛn nɛ cère' Sufmbɛ là baa' Mart nin Mari saan, bɛ ń lá suon bɛ biʼninjɛ ya kuum bo ki yɛbe. ");
INSERT INTO gngNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Mart cii' *Yesu we ní, nɛ u tobreh wɔ usɛn bó. Ama Mari wɔn juore' ki kɛ iden nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mart tì tɔke' *Yesu ki ye: «Yonbdaan, a bi te niɛ saan la, nʼninjɛ ŋa bi kpo'. ");
INSERT INTO gngNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ama n bɛn ki ye fɛnfɛnnɔ wuɔ mɔnɔn, a miɛ' Uwien nibonn nà kɛ la, u li de ŋɛ nɛ̀ nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Nɛ *Yesu tɔke' wɔ ki ye: «Aʼninjɛ li mɛkre.» ");
INSERT INTO gngNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Nɛ Mart ye: «N bɛn ki ye u lá li mɛkre uwenfɔrkɛ ya daali, lidaali là binib li mɛkre nnɔ nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Nɛ Yesu ye: «Min nɛ yé mimɛkrm ki yé limiɛl. Unil teke' nni ki jin' la, u kpo' mɔnɔn la, u li fuobe nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Wà kɛ fuobe ki teke' nni ki jin' la, wa ń kpo fiebu. A teke' n len' nà nɔ ki jin-ii?» ");
INSERT INTO gngNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Nɛ Mart ye: «Hnn, Yonbdaan, n teke' ki jin' ki ye a yé Uwien ya Bijɛ nɛ, ki yé Uwien ya Nigɛndkɛ Kristo wà li baa ní uŋɛndun ni nnɔ.» ");
INSERT INTO gngNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Mart len' nnɔ, nɛ ki bure' ki tì yin' uʼninsɛ Mari, ki bunbe' ki tɔke' wɔ ki ye: «Cɛnbaa baa' ní, ki yih ŋɛ.» ");
INSERT INTO gngNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mari cii' nnɔ ma nnɔ nɛ ki pɔk ki fii', ki jon' uʼsaan. ");
INSERT INTO gngNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","*Yesu ŋa laan kɔn' udu ni, u laan te usɛn ni, Mart tuobe' wɔ nà saan nnɔ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","*Sufmbɛ bà te iden Mari saan, ki suondeh wɔ nnɔ laa' u pɔk ki fii' ki ñɛn' saali ma nnɔ nɛ biʼmɔ paan' uʼbo. Bi là maaleh ki teh u joh likul bó nɛ wɔ ń tì muɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mari tì baa' *Yesu te nà saan uyo wà ki laa' wɔ nnɔ, nɛ ki gbaan' uʼnintuɔli, ki tɔke' wɔ ki ye: «Yonbdaan, a bi te niɛ saan la, nʼninjɛ ŋa bi kpo'.» ");
INSERT INTO gngNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yesu laa' u muɔh, ki laa' *Sufmbɛ bà pɛ uʼbo nnɔ mɔ muɔh ma nnɔ, nɛ uʼyɛnm saa' ki gbien', ");
INSERT INTO gngNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","nɛ u niire' bɛ ki ye: «Ni sube' wɔ lɛ saan-i?» Nɛ bi ye: «Yonbdaan, dɛn kí tì liike-a!» ");
INSERT INTO gngNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Nɛ saan nɛ Yesu muɔ'. ");
INSERT INTO gngNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Nɛ *Sufmbɛ ye: «Liike mɛn u là yíe wɔ nì tì kpɛ ma.» ");
INSERT INTO gngNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Nɛ biʼni biba ye: «Wɔn wà là likre' ujuɔn-ii? Wa bi li fre kí cère Lasaar la kpo-oo?» ");
INSERT INTO gngNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Nɛn saan nɛ *Yesu ya yɛnm tí saa' ki gbien', nɛ u bure' likul bó. Nì là yé kujɔlulnku nɛ, nɛ litɛnl bi kuʼñɔbu. ");
INSERT INTO gngNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yesu ye: «Biire mɛn litɛnl nnɔ.» Ujɛ wà kpo' nnɔ ya ninsɛ Mart tɔke' wɔ ki ye: «Yonbdaan, u lii nuuke'-a! Kimɛ u tien' len iwien inan sɔ.» ");
INSERT INTO gngNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Nɛ *Yesu ye: «Ma tɔke' ŋɛ ki ye a teke' nni ki jin' la, a li lɛ Uwien ŋmɔbe ukpiɛke ma bo-oo?» ");
INSERT INTO gngNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Nɛn saan nɛ bi biire' litɛnl nnɔ, nɛ u yaare' ki liike' paaki ki ye: «NʼBaa, n faareh ŋɛ nin a cenge' nʼbó ma nɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","N bɛn ki ye uyo kɛ a cengeh nʼbó nɛ. Ama linigol liɛ bo nɛ cère' n len' nnɔ, ŋɔ bɛ ń teke kí ji kí ye sin nɛ sɔn' nni ní.» ");
INSERT INTO gngNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","U len' nnɔ, nɛ ki tiɛn' ufaa bo ki ye: «Lasaar, ñɛ ní!» ");
INSERT INTO gngNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Nɛ ujɛ wà bi yé utɛnkpii nnɔ ñɛn' likul ni ní, tikpɛlcɛr biɛ ki tɛntɛn' uʼnuɔ nin uʼtàan, kutɔku piibe uʼnun bó. Nɛ Yesu tɔke' bɛ ki ye: «Ñɛnñɛn mɛn tikpɛlcɛr nnɔ, kí cère wɔ ń li joh.» ");
INSERT INTO gngNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Sufmbɛ bà là baa' Mari saan ki laa' Yesu tien' nibonn nà nnɔ, biʼni bà yɛbe teke' wɔ ki jin'. ");
INSERT INTO gngNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ama biʼni biba mɔ jon' *Farisiɛnmbɛ saan ki tì tɔke' bɛ *Yesu tien' nà nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Nɛn saan nɛ bitɔtuɔrciɛnb nin *Farisiɛnmbɛ nnɔ yin' biʼbuur ya cɛkl yaab ki taan', nɛ ki tɔke' bɛ ki ye: «Ti li tien mila? Kimɛ ujɛ bugbɛn teh miyɔkm ya bont cɛɛn nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ti cère' u tuu ki teh nnɔ la, binib kɛ li teke' wɔ kí ji, nɛ Erom yaab li baa kí lá bere tiʼWien ya duku, kí gben tiʼbol ya nib kɛ.» ");
INSERT INTO gngNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Bi yih biʼni uba Kayif, wɔn nɛ là yé bitɔtuɔrciɛnb ya ciɛn libinl nnɔ, nɛ u tɔke' bitɔb ki ye: «Na bɛn niba, ");
INSERT INTO gngNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","ka bɛn ki ye nì mɔn unibaab ń kpo tiʼdu ya nib bo ŋɔ tiʼbol kɛ la gben-ii?» ");
INSERT INTO gngNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","U len' ma nnɔ, na yé wɔn bugbɛn ya yɛnm ni nɛ u len' nnɔ. U là yé bitɔtuɔrciɛnb ya ciɛn libinl nnɔ ma nnɔ, nɛ cère' u len' tɛn uñɔbonsɔknl ki ye *Yesu li kpo biʼbol ya nib kɛ bo. ");
INSERT INTO gngNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Na yé biʼbol ya nib baba bo nɛ u li kpo. U li kpo kí taan Uwien ya bumu mùa yɛre' niʼkɛ saan nnɔ kí tien bɛ unibaab nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Kí ñɛ nɛn daali nɛ bi sien' ki ye bi li ku Yesu nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Nɛn bo nɛ *Yesu ŋa ji cèreh *Sufmbɛ lɛnh wɔ. U siere' niʼsaan ki bure' udu uba bó, bi yih wù Efrayim, wa fɔke nin kupenpelku, nɛ wɔn nin uʼpanpaankaab tì te niʼbó. ");
INSERT INTO gngNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Nì là sìen' waamu nɛ bɛ ń jele *Sufmbɛ ya Pak ya nacenku. Nɛ binib ñɛn' idugbaan ni ki baa' Yerusalɛm ki yɛbe, bɛ ń lá ñɛn biʼyul bo tijɔknt kí bonde kunacenku nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Bi te Uwien ya duku ya luo bo ki nuunh Yesu ma nnɔ nɛ ki niireh tɔb ki teh: «Ni maaleh mila? U li baa kunacenku kuu bii wa ń baa?» ");
INSERT INTO gngNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Bitɔtuɔrciɛnb nin *Farisiɛnmbɛ là len' ki ye unil bɛn u te nà saan la, wɔ ń wuɔn bɛ, bɛ ń jo kí tì cuo wɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Nì là sìen' iwien iluob nɛ Sufmbɛ ń jele biʼPak ya nacenku, nɛ *Yesu jon' Betani ya du ni. Lasaar wà u là mɛkre' wɔ nnɔ, kɔh nɛn ni nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Bi tien' *Yesu tijier niʼsaan. Mart nɛ là gbiinh bɛ tijier nnɔ nɛ Lasaar mɔ yé bà jinh tijier *Yesu saan nnɔ ya uba. ");
INSERT INTO gngNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mari taa' lɛfina uba u te litrjenku, uʼdaaku faa cɛɛn, bi yih lɛfina nnɔ naar, ki lá fanfaan' *Yesu ya tàan, ki taa' uʼyur ki ŋmiŋmire' yɛ̀. Lɛfina nnɔ ya nu teke' kuduku kɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Nɛ *Yesu ya panpaankaab ya uba, bi yih wà Sudas Iskariyɔt, wɔn wà lá li kuɔre Yesu nnɔ ye: ");
INSERT INTO gngNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","«Bɛ tien' ba ń taa lɛfina nnɔ kí kuɔre kí lɛ iwentun kobiita ya paaku kí taa kí de bijiinb-i?» ");
INSERT INTO gngNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Na yé Sudas tɔngeh bijiinb nɛ. Kimɛ u là yé unasu nɛ. Wɔn nɛ ŋuuke kiliksɔrk ma nnɔ, u suh bi taah ilike yà ki kpìendeh len nnɔ nɛ. Nɛn nɛ cère' u len' nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Nɛ *Yesu tɔke' Sudas ki ye: «Cère wɔ wɔ ń fuore. U taa' lɛfina wuɔ wɔ ń bonde nʼsubm nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Bijiinb lì li te niʼsaan uyo kɛ nɛ; ama min ŋa ń li te niʼsaan uyo kɛ.» ");
INSERT INTO gngNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Sufmbɛ ligol cii' *Yesu te Betani ya du ni, nɛ ki baa' uʼsaan. Na yé Yesu baba bo nɛ bi baa'. Bi nuunh bɛ ń lɛ Lasaar wà *Yesu là mɛkre' wɔ bitɛnkpiib ni nnɔ mɔ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Nɛn saan nɛ bitɔtuɔrciɛnb sien' ki ye bi li ku Lasaar mɔ, ");
INSERT INTO gngNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","kimɛ wɔn bo nɛ *Sufmbɛ teke' *Yesu ki jin' ki yɛbe, ka ji pɛ bɛn bitɔtuɔrciɛnb bo. ");
INSERT INTO gngNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Kutaaku faa', nɛ linigociɛnl là baa' Yerusalɛm ni lɛ̀ ń jele kunacenku nnɔ cii' *Yesu we ní, ");
INSERT INTO gngNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","nɛ bi bɛre' mubiɛbisiimu ya fɛr ki tobreh wɔ usɛn bó, ki wuureh ki teh: «Osana! Uwien ya mɔnm ń li te wà we ní Yonbdaan ya yel bo nnɔ bo. Uwien ya mɔnm ń li te Israyɛl yaab ya bɛr bo.» ");
INSERT INTO gngNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","*Yesu laa' uŋuunfanfaan ki jɛ̀ke' tɛn nì kɛle' ma *Uwien ya gbɔnku ni ki ye: ");
INSERT INTO gngNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","«*Siyɔn yaabɛ, la cère mɛn nɛ̀ ń cuo nɛ jɛwaanbu. Liike mɛn, niʼbɛrciɛn we ní, ki jɛke uŋuunfanfaan.» ");
INSERT INTO gngNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","*Yesu ya panpaankaab ŋa laan là cii' niʼtingi u ya yo. Uwien kpiɛke' wɔ uyo wà nnɔ, nɛ bi tiɛre' ki ye nì kɛle' uʼbo nnɔ nɛ *Uwien ya gbɔnku ni, ki bɛnde' ki ye linigol nnɔ tien' wɔ bi bi li tien wɔ ma bo nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Linigol là là te *Yesu saan lidaali là u là mɛkre' Lasaar ki yin' wɔ ki ye wɔ ń ñɛ ní likul ni nnɔ, bɛn nɛ là tɔke' binib tigbɛr nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Nɛn bo nɛ binib ligol tuobe' wɔ usɛn bó, kimɛ bi là cii' u tien' miyɔkm ya bonn nnɔ ma bo. ");
INSERT INTO gngNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Nɛn saan nɛ *Farisiɛnmbɛ tɔkeh tɔb ki teh: «Ni laa'-aa? Ninbi ŋa ji li fre kí tien niba. Uŋɛndun ya nib kɛ ji pɛ wɔn bo nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Grɛkmbɛ biba mɔ là baa' Yerusalɛm kunacenku nnɔ ya yo bɛ ń lá puke Uwien. ");
INSERT INTO gngNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Bi nɛkn' Filip. U yé Bɛtsayida ya du wà te Galile ya tinfɛnm ni nnɔ yɔ nɛ, nɛ ki tɔke' wɔ ki ye: «Uciɛn, ti yíe tí lɛ *Yesu nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Nɛ Filip jon' ki tì tɔke' Andre. Nɛ biʼkɛ bile jon' ki tì tɔke' Yesu. ");
INSERT INTO gngNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Nɛ *Yesu tɔke' bɛ ki ye: «Uyo wà Uwien li kpiɛke Unil ya Bijɛ nnɔ baa' ní ŋɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","N tɔkeh nɛ imɔ̀n nɛ, bi bule' mijibim ma kpo' la, mì li juore miʼbaba nɛ. Ama mì kpo' la, mì li pɔ̀re kí yɛbre nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Wà kɛ yíe wɔ ń fie uʼmiɛl la, wɔn nɛ li kpo kí juore fɛnm. Ama wà kɛ ŋa tɔngeh uʼmiɛl uŋɛndun wuu ni la, wɔn nɛ li lɛ limiɛl là ŋa ŋmɔbe gbenm. ");
INSERT INTO gngNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Unil yíe wɔ ń sɔn nʼtùon la, udaan ń li pɛ nʼbo. N te nà saan la, nʼtonsɔnl mɔ li te nɛn saan nɛ. Unil sɔnh nʼtùon la, nʼBaa li kpiɛke wɔ.» ");
INSERT INTO gngNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","«Fɛnfɛnnɔ, nʼyɛnm saa' ki gbien'-a! N li len kí ye ba? N ye: ‹NʼBaa, ñɛ nni ijɛnd yà we ní nɔ ni-ii?› Ama n baa' nɛn bo nɛ ki lá tu' uyo wuu nɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","NʼBaa, wuɔn aʼkpiɛke.» Nɛn saan nɛ uniɛke uba ñɛn' paaki bó ní ki ye: «N wuɔn' nʼkpiɛke ŋɔ, ki li liɛbe kí wuɔn wù mɔ nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Linigol là se niʼsaan ki cii' uniɛke nnɔ bó nnɔ, ya biba ye utaa nɛ dun', nɛ bitɔb ye Uwien ya tond uba nɛ len' wɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Nɛ u ye: «Na yé min bo nɛ cère' udaan wà len' nɔ len', ninbi bo nɛ u len'. ");
INSERT INTO gngNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Fɛnfɛnnɔ wuɔ nɛ Uwien li bu uŋɛndun wuu ya nib tibuur. Fɛnfɛnnɔ nɛ Uwien li ŋɔre wà yé uŋɛndun wuu ya ciɛn nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Min wɔn, uyo wà bi li fin nni paaki bó nnɔ, nɛ n li dɛre binib kɛ kí nɛkn nʼba.» ");
INSERT INTO gngNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","U len' nnɔ ŋɔ wɔ ń wuɔn u li kpo mikuum mà ya bol nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Nɛ linigol nnɔ tɔke' wɔ ki ye: «Ti cii' *Uwien ya gbɔnku ye Uwien ya Nigɛndkɛ *Kristo li fuobe uyo kɛ nɛ. A tien' mila ki len' ki ye bi li fin Unil ya Bijɛ udɔpɔnpɔn bo paaki bó? Ŋmɛ yé Unil ya Bijɛ bugbɛn-i?» ");
INSERT INTO gngNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Nɛ u tɔke' bɛ ki ye: «Kuwenwenku ŋa ji li wuɔke' niʼni. Li cuonh mɛn uyo wà kuwenwenku laan te, ŋɔ licinñunl la pìln nɛ. Unil wà kɛ cuonh licinñunl ni la, wa bɛn u joh nà bó. ");
INSERT INTO gngNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Kuwenwenku laan te ma nɔ, teke mɛn kù kí ji, ŋɔ kí li yé kuwenwenku yaab.» *Yesu len' nnɔ, nɛ ki ñɛn' niʼsaan ki jɛnde' ki tì bɔle'. ");
INSERT INTO gngNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Nin u là tien' miyɔkm ya bont tù yɛbe biʼnun ni ma kɛ nnɔ, ba teke' wɔ ki jin'. ");
INSERT INTO gngNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ba teke' wɔ ki jin' ŋɔ *Uwien ya ñɔbonsɔknl Esayi là len' nà nnɔ nɛ̀ ń tien nɛ. U là ye: «Yonbdaan, ŋmɛ tuo' ki teke' ti len' nà nnɔ ki jin'-i? Ŋmɛ bɛnde' a ŋmɔbe mituɔm ma bo?» ");
INSERT INTO gngNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Esayi tí là len' nà bo cère' ba lì li fre kí teke kí ji. U là ye: ");
INSERT INTO gngNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","«Uwien juɔn biʼnun, ki libe' biʼyɛnm, ŋɔ bi la lɛnh, ki la cii' niʼtingi biʼyɛnm ni, ki la lèbre biʼtetem, ŋɔ wɔ ń buu bɛ.» ");
INSERT INTO gngNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Esayi là len' nnɔ, kimɛ u là laa' *Yesu ya kpiɛke ma nnɔ nɛ cère' u len' uʼgbɛr. ");
INSERT INTO gngNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Nin nɛn kɛ, *Sufmbɛ ya ciɛnb bà yɛbe mɔnɔn là teke' *Yesu ki jin'; ama *Farisiɛnmbɛ bo nɛ ba len' upaan bo ki ye bi teke' wɔ ki jin'. Bi là fɛnge' bi li ŋɔre bɛ litaanl ya duku ni nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Kimɛ bi yíe binib ya kpiɛkm ki cɛn' Uwien yaam. ");
INSERT INTO gngNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","*Yesu len' ufaa bo ki ye: «Wà kɛ teke' nni ki jin' la, na yé u teke' min baba nɛ ki jin', u teke' wà sɔn' nni ní nnɔ mɔ ki jin' nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Wà kɛ laa' nni la, u laa' wà sɔn' nni ní nnɔ mɔ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Min yé kuwenwenku nɛ ki baa' uŋɛndun ni, ŋɔ unil wà kɛ teke' nni ki jin' la, u la juore cinñunl ni. ");
INSERT INTO gngNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Unil cii' nʼgbɛr, ka bon' tù la, na yé min nɛ li biin wɔ, kimɛ ma baa' ń lá biin uŋɛndun ya nib, n baa' ń lá ŋmiɛn bɛ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Wà kɛ wiɛ' nni, ka teke' nʼgbɛr la, u laa' nibonn nà li biin wɔ. Uwenfɔrkɛ ya daali la, nʼgbɛr nnɔ nɛ li biin wɔ, ");
INSERT INTO gngNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","kimɛ ma tɔkeh nʼbugbɛn ya gbɛr. NʼBaa wà sɔn' nni ní nnɔ, wɔn nɛ tɔke' nni n li len ma bo nin n li wɔkn ma bo. ");
INSERT INTO gngNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","N bɛn ki ye uʼgbɛr dienh binib limiɛl là ŋa ŋmɔbe gbenm nɛ. Nnɔ nɛ n tɔkeh tà kɛ nɔ n tɔkeh tù nʼBaa tɔke' nni tù ma bo nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Nì là sìen' waamu nɛ *Sufmbɛ ya Pak ya nacenku ń jele. *Yesu bɛn ki ye uʼyo baa' wɔ ń ñɛ uŋɛndun wuu ni, kí liɛbe uʼBaa bó. U là yíe uʼnib bà te uŋɛndun ni nnɔ. U là yíe bɛ ki tì gben' nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","*Yesu nin uʼpanpaankaab là jinh kutaajuɔku ya jier uyo wà nnɔ ki laa' usɛnpol de' Simɔn Iskariyɔt ya bijɛ Sudas iyɛnmaale ŋɔ wɔ ń kuɔre Yesu. ");
INSERT INTO gngNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesu bɛn ki ye uʼBaa de' wɔ mituɔm tibont kɛ bo, ki bɛn mɔ ki ye u ñɛn' ní Uwien saan nɛ, ki tí liɛbeh Uwien saan. ");
INSERT INTO gngNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Wɔn nin uʼpanpaankaab kɛ ki jinh, nɛ u fii' ki sere', ki gore' uʼpaaki bó ya liɛrl ki ble', ki taa' kukpɛlciɛku ki gbin' uʼciɛk ni, ");
INSERT INTO gngNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","nɛ ki taa' miñunm ki kuore' kusɛnku ni, ki cin' ki sɔkreh uʼpanpaankaab ya tàan, ki taah u gbin kukpɛlciɛku kùa nnɔ ki ŋmireh yɛ̀. ");
INSERT INTO gngNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","U tì baa' Simɔn Piɛr saan, nɛ u tɔke' wɔ ki ye: «Yonbdaan, sin ń lá sɔkre min ya tàan-ii?» ");
INSERT INTO gngNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Nɛ *Yesu ye: «Fɛnfɛnnɔ ŋa ń cii n teh nà nɔ ya tingi, ama a lá li cii nɛ̀ uyo uba nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Nɛ Piɛr ye: «Ŋa lì li sɔkre nʼtàan fiebu.» Nɛ *Yesu ye: «Ma sɔkre' aʼtàan la, ŋa ń lɛ gbiin nʼsaan.» ");
INSERT INTO gngNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Nɛ Simɔn Piɛr ye: «Yonbdaan, nnɔ la, la sɔkre nʼtàan baba. Sɔkre nʼnuɔ nin nʼyul mɔ.» ");
INSERT INTO gngNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Nɛ *Yesu ye: «Unil sìi' la, wa ń li nuunh wɔ ń pɔk kí sìi kí lere, u li sɔkre uʼtàan baba nɛ, kimɛ uʼgbɛnɛnt kɛ wien nɛ. Niʼmɔ wien nɛ, ama na nín yé niʼkɛ nɛ wien.» ");
INSERT INTO gngNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Kimɛ *Yesu bɛn udaan wà li kuɔre wɔ, nɛn nɛ cère' u len' ki ye: «Na yé niʼkɛ nɛ wien.» ");
INSERT INTO gngNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Tɔ, u sɔkre' biʼtàan ki tì gben', ki gole' uʼliɛrl nnɔ, nɛ ki liɛbe' ki tì kɛ̀le', ki niire' bɛ ki ye: «Ni cii' n tien' nɛ nà nɔ ya tingi-ii? ");
INSERT INTO gngNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ni yih nni niʼCɛnbaa nin niʼYonbdaan ma nɔ, ni ŋmɔbe imɔ̀n nɛ, kimɛ n yé wɔn nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Min niʼYonbdaan nin niʼCɛnbaa sɔkre' niʼtàan ma nɔ, niʼmɔ ń li sɔkreh niʼtɔb ya tàan nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Kimɛ min wuɔn' nɛ ni li teh ma nɛ, niʼmɔ ń li teh niʼtɔb tɛn n tien' nɛ ma nɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","N tɔkeh nɛ imɔ̀n nɛ, utonsɔnl ŋa cɛn' uʼcɛnbaa, utond mɔ ŋa cɛn' wà sɔn' wɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ni bɛnde' n len' nà nɔ ya tingi ma nɔ, ni teh nnɔ la, Uwien ya mɔnm li te niʼbo nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","«Ma lienh niʼkɛ bo, min n bɛn n gɛ̀nde' binib bà; ama nà kɛle' *Uwien ya gbɔnku ni nnɔ li tien nɛ. Nì kɛle' ki ye: ‹Min nin unil wà taakeh ki jinh nʼjier nɛ fii' ki sere' nʼbo.› ");
INSERT INTO gngNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","N tɔke' nɛ nibonn nà ŋa laan tien' ya gbɛr fɛnfɛnnɔ, ŋɔ nì lá tien' la, ní bɛnde kí ye ‹n yé n yé wà› nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","N tɔkeh nɛ imɔ̀n nɛ, unil teke' n sɔn' unil wà la, u teke' min nɛ. Unil teke' nni la, u teke' wà sɔn' nni ní nnɔ nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","*Yesu len' nnɔ ki tì gben', uʼyɛnm saa' ki gbien', nɛ u tɔke' bɛ ki ye: «N tɔkeh nɛ imɔ̀n nɛ, niʼni uba li kuɔre nni.» ");
INSERT INTO gngNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Nɛ uʼpanpaankaab jiɛbeh ki likeh tɔb, ka bɛn u niireh wà. ");
INSERT INTO gngNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Bi jinh ma nnɔ, uʼpanpaankaab ni u yíe wà ki gbien' nnɔ nɛ kɛ ki buɔke wɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Nɛ Simɔn Piɛr kɛnbe' wɔ ki ye wɔ ń niire *Yesu kí ye u niireh ŋmɛ nɛ? ");
INSERT INTO gngNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Nɛ uʼpanpaankɛ nnɔ gbìen' *Yesu bo, ki niire' wɔ ki ye: «Yonbdaan, ŋmɛ nɛ?» ");
INSERT INTO gngNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Nɛ *Yesu tɔke' wɔ ki ye: «N wɔ́re' kpɔnɔ ki se' ki de' wà la, wɔn nínɔ.» Nɛ ki wɔ́re' kpɔnɔ ki se', ki de' Simɔn Iskariyɔt ya bijɛ Sudas. ");
INSERT INTO gngNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Sudas teke' kpɔnɔ nnɔ uyo wà nnɔ, nɛ *Satan kɔn' uʼfɛ̀l ni. Nɛ *Yesu tɔke' wɔ ki ye: «Tien a ye á tien nà nnɔ tonm!» ");
INSERT INTO gngNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Binib bà kɛ ki jinh tijier nnɔ ni uba mɔnɔn ŋa bɛnde' nà cère' *Yesu tɔke' wɔ ki ye nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Sudas nɛ ŋuuke kiliksɔrk ma nnɔ, biba maale' ki ye *Yesu tɔke' wɔ ki ye wɔ ń jo kí tì dɛ bɛ kunacenku ya bont nɛ, bii wɔ ń jo kí tì de bijiinb nɛ niba. ");
INSERT INTO gngNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Sudas teke' kpɔnɔ nnɔ ma nnɔ nɛ ki pɔk ki ñɛn' i ya tàan bo. Nì là yé kuñɔnku nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Sudas ñɛn' uyo wà nnɔ nɛ *Yesu tɔke' bɛ ki ye: «Fɛnfɛnnɔ Uwien kpiɛke' Unil ya Bijɛ. Wɔn bo nɛ bi li kpiɛke Uwien mɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Wɔn bo nɛ bi kpiɛke' Uwien la, Uwien bugbɛn mɔ li kpiɛke wɔ. U li kpiɛke wɔ fɛnfɛnnɔ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Nʼbumu, ma ji li wuɔke niʼsaan. Ni li nuun nni, ama n là tɔke' *Sufmbɛ ya ciɛnb nà nnɔ, n ji li tɔke niʼmɔ nɛ̀ fɛnfɛnnɔ, kí ye: ‹Na ń fre kí jo n joh nà saan.› ");
INSERT INTO gngNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","N de' nɛ liwɔbfɛ̀nl nɛ: ‹li yíe mɛn tɔb.› N yíe nɛ ma nnɔ, niʼmɔ ń li yíe tɔb nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ni yíe tɔb la, nɛn nɛ li cère binib kɛ ń bɛnde kí ye ni yé nʼpanpaankaab.» ");
INSERT INTO gngNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Nɛ Simɔn Piɛr niire' wɔ ki ye: «Yonbdaan, a joh lɛ bó?» Nɛ *Yesu jiin' wɔ ki ye: «N joh nà bó nnɔ ŋa ń fre kí paan nʼbo fɛnfɛnnɔ. A lá li paan nʼbo uyo uba nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Nɛ Piɛr niire' wɔ ki ye: «Yonbdaan, bɛ bo nɛ ma ń fre kí paan aʼbo fɛnfɛnnɔ? N li tuo kí kpo aʼbo-a!» ");
INSERT INTO gngNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Nɛ *Yesu tɔke' wɔ ki ye: «A li mɔnbe kí tuo kí kpo nʼbo-oo? N tɔkeh ŋɛ imɔ̀n nɛ, a li niɛ bolm mita kí ye ŋa bɛn nni nɛ kí yaan ukuojɛ ń muɔ.» ");
INSERT INTO gngNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","*Yesu tɔke' uʼpanpaankaab ki ye: «La cère mɛn niʼyɛnm ń saa. Teke mɛn Uwien kí ji, kí teke nʼmɔ kí ji. ");
INSERT INTO gngNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Mifɛnm yɛbe nʼBaa den. Ma bi yɛbe la, n bi li tɔke nɛ kí ye n joh ń tì bonde mifɛnm kí ble nɛ-ɛɛ? ");
INSERT INTO gngNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","N jon' ki tì bonde' mifɛnm ki ble' nɛ la, n li liɛbe ní, kí lá taa nɛ, ŋɔ niʼmɔ ń tì ń li te min te nà saan. ");
INSERT INTO gngNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","N joh nà bó nnɔ, ni bɛn ni bó ya sɛn.» ");
INSERT INTO gngNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Nɛ Toma tɔke' wɔ ki ye: «Yonbdaan, ta bɛn a joh nà bó, ti li tien mila kí bɛnde niʼbó ya sɛn-i?» ");
INSERT INTO gngNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Nɛ *Yesu tɔke' wɔ ki ye: «Min nɛ yé usɛn wà wɔngeh binib tigbɛmɔ̀nt, ki dienh bɛ limiɛl. Uba ŋa ń fre kí jo nʼBaa saan ka ñɛn' min saan. ");
INSERT INTO gngNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ni bi bɛn nni la, ni bi li bɛnde nʼBaa mɔ nɛ. Fɛnfɛnnɔ ni bɛn wɔ, ki laa' wɔ mɔ.» ");
INSERT INTO gngNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Nɛ Filip tɔke' wɔ ki ye: «Yonbdaan, wuɔn tɛ aʼBaa nɛ nì li dɛ̀kre tɛ.» ");
INSERT INTO gngNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Nɛ *Yesu tɔke' wɔ ki ye: «Filip, n te niʼsaan nì wuɔke' ki kpaan' nɔ, nɛ ŋa bɛn nni-ii! Unil wà laa' nni la, u laa' nʼBaa nɛ. Bɛ tien' a tɔke' ki ye ń wuɔn nɛ nʼBaa? ");
INSERT INTO gngNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ŋa teke' ki jin' ki ye n tɛ nin nʼBaa nɛ, nɛ nʼBaa mɔ tɛ nin nni-ii? N tɔkeh nɛ tigbɛr tà nɔ ŋa yé nʼbugbɛn yaar. NʼBaa wà tɛ nin nni nnɔ nɛ sɔnh uʼtùon. ");
INSERT INTO gngNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","«Teke mɛn kí ji kí ye n tɛ nin nʼBaa nɛ, nɛ nʼBaa mɔ tɛ nin nni. Na teke' nʼgbɛr ki jin' la, teke nni mɛn kí ji miyɔkm ya bont nnɔ bo. ");
INSERT INTO gngNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","N tɔkeh nɛ imɔ̀n nɛ, unil wà kɛ teke' nni ki jin' la, u li sɔn itùon yà n sɔn' yɛ̀ nɔ. U li sɔn itùon yà yɛbe nin n sɔn' yà nɔ mɔnɔn, kimɛ n joh nʼBaa bó nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ni miɛ' nà kɛ nʼyel bo la, n li tien nɛ̀, ŋɔ bɛ ń kpiɛke nʼBaa min uʼbijɛ bo. ");
INSERT INTO gngNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ni miɛ' nni nà kɛ nʼyel bo la, n li tien nɛ̀.» ");
INSERT INTO gngNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Ni yíe nni la, ni li boh nʼwɔb nɛ, ");
INSERT INTO gngNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","nɛ n li gbáan nʼBaa wɔ ń de nɛ Utotortɔ wɔ ń li te niʼsaan uyo kɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","U yé *Mifuoñaanm nɛ, ki yé tigbɛmɔ̀nt ya daan. Uŋɛndun ya nib ŋa ń fre kí teke mɛ̀, kimɛ ba lɛnh mɛ̀, ka bɛn mɛ̀ mɔ. Ama Ninbi wɔn, ni bɛn mɛ̀; mì te niʼsaan, ki li te niʼni mɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ma ń cère nɛ ní li te tɛn mutɛnkpiibumu. N li liɛbe ní niʼsaan. ");
INSERT INTO gngNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Nì sìen' waamu, uŋɛndun ya nib ŋa ji li lɛ nni, ama ninbi li lɛ nni, kimɛ n fuobe, nɛ niʼmɔ li fuobe. ");
INSERT INTO gngNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Niʼdaali baa' la, ni li bɛnde kí ye min nin nʼBaa taan' ki yé unibaab nɛ, nɛ ninbi nin min mɔ taan' ki yé unibaab. ");
INSERT INTO gngNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","«Unil wà yíe nni si: wà bɛn nʼwɔb ki boh yɛ̀ nɛ. NʼBaa li yíe unil wà yíe nni, nɛ nʼmɔ li yíe udaan, kí cère udaan ń bɛnde nni.» ");
INSERT INTO gngNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Nɛ Sudastɔ, wà ŋa yé Sudas Iskariyɔt nnɔ niire' wɔ ki ye: «Yonbdaan, bɛ bo nɛ a li cère tinbi ń bɛnde ŋɛ, ka ń cère uŋɛndun ya nib ń bɛnde ŋɛ?» ");
INSERT INTO gngNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Nɛ *Yesu jiin' wɔ ki ye: «Wà yíe nni la, u li boh nʼgbɛr nɛ, nʼBaa li yíe wɔ, nɛ ti li baa uʼsaan, kí li kɔh uʼsaan. ");
INSERT INTO gngNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Wà ŋa yíe nni la, wa ń li boh nʼgbɛr. Ni cengeh tigbɛr tà nɔ ŋa yé nʼyaar, tù yé nʼBaa wà sɔn' nni ní nnɔ yaar nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","«N laan biɛ ki te niʼsaan ma nnɔ nɛ ki tɔke' nɛ tigbɛr tuu nɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ama *Mifuoñaanm mà yé Utotorl nnɔ, nʼBaa li sɔn mɛ̀ ní nʼyel bo. Mɛn nɛ li wɔkn nɛ niʼkɛ, kí tiɛre nɛ n tɔke' nɛ tigbɛr tà nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","«Li te mɛn uyɛnduɔn ni. N dienh nɛ n ŋmɔbe uyɛnduɔn wà nnɔ nɛ; ma dienh nɛ wù tɛn uŋɛndun ya nib dienh ma bo. La cère mɛn niʼyɛnm ń saa, ki la sɛn jɛwaanbu. ");
INSERT INTO gngNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ni cii' n tɔke' nɛ ki ye n li jo kí liɛbe ní niʼsaan. Ni yíe nni la, n joh nʼBaa saan ma nnɔ ni bi li ŋmɔbe uyɛnsɔnge nɛ, kimɛ nʼBaa cɛn' nni. ");
INSERT INTO gngNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","N tɔkeh nɛ nibonn nà ŋa laan tien' ya gbɛr fɛnfɛnnɔ, ŋɔ nì lá tien' la, ní teke kí ji nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ma ji li tɔke nɛ tigbɛr nɛ̀ ń wuɔke, kimɛ uŋɛndun wuu ya ciɛn we ní, wa ń fre kí tien nni niba. ");
INSERT INTO gngNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ama nì kpɛ uŋɛndun ya nib ń bɛnde kí ye n yíe nʼBaa, nɛ ki teh u tɔke' nni ma bo. ‹Fii mɛn tí jo.› » ");
INSERT INTO gngNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","«Min nɛ yé busumɔ̀nbu nɛ nʼBaa yé ukpaal wà tùɔreh busubu nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Isigben yà kɛ te nʼbo ka lùonh nnɔ, u li gɛ yì kí wiɛ nɛ. Ama isigben yà kɛ lùonh nnɔ, u li kpɛkpɛre kí tùɔre yì, nɛ yì ń tùɔre kí lùon. ");
INSERT INTO gngNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","N tɔke' nɛ tigbɛr tà nɔ tùɔre' niʼtetem ŋɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Li tɛ mɛn nin nni, tɛn n tɛ nin nɛ ma. Usigben te uʼba, ka tuuke busubu bo la, wà ń fre kí lùon. Nnɔ nɛ niʼmɔ ŋa tɛ nin nni la, na ń fre kí tien bonn. ");
INSERT INTO gngNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","«Min nɛ yé busubu, nɛ ninbi yé isigben. Unil wà kɛ tɛ nin nni, nʼmɔ tɛ nin udaan la, u li te tɛn usigben wà lùonh ki gbiekeh nɛ. Na tɛ nin nni la, na ń fre kí tien bonn. ");
INSERT INTO gngNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Unil wà ŋa tɛ nin nni la, bi li jɛnde wɔ kí tì wiɛ nɛ wɔ ń kuore tɛn usigben wà ŋa tuuke subu bo. Isigben yà kuore' la, bi gɛ̀ndeh yì ki kpìendeh umu ni nɛ ì wih. ");
INSERT INTO gngNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ni tɛ nin nni, ki ŋmɔbe nʼgbɛr niʼfɛ̀l ni, ki miɛ' Uwien ni yíe nà la, u li de nɛ nɛ̀ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ni yé nʼpanpaakaab, ki te tɛn isigben yà lùonh ki gbiekeh la, nɛn nɛ kpiɛkreh nʼBaa. ");
INSERT INTO gngNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","NʼBaa yíe nni ma nnɔ nɛ nʼmɔ yíe nɛ. Li te mɛn nʼyíem ni. ");
INSERT INTO gngNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","N boh nʼBaa ya wɔb, nɛ ki te uʼyíem ni. Niʼmɔ boh n ya wɔb la, niʼmɔ li te nʼyíem ni nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","«N tɔke' nɛ nɛn kɛ ŋɔ ní li ŋmɔbe uyɛnsɔnge wà n ŋmɔbe wù nnɔ nɛ; ŋɔ niʼyɛnm ń li sɔnge kí tì gben. ");
INSERT INTO gngNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","N yíe ní li teh nà si: li yíe mɛn tɔb tɛn n yíe nɛ ma bo. ");
INSERT INTO gngNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Nil ŋa ŋmɔbe yíem ki cɛn' wà li tuo kí kpo uʼjɔtieb bo. ");
INSERT INTO gngNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ni teh n tɔke' nɛ nà la, ni yé nʼjɔtieb nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ma ji li yih nɛ nʼtonsɔnb; n li yih nɛ nʼjɔtieb nɛ, kimɛ utonsɔnl ŋa bɛn uʼcɛnbaa ya gbɛr kɛ; ama min tɔke' nɛ tigbɛr tà kɛ n cii' tù nʼBaa saan nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Na yé ninbi nɛ gɛ̀nde' nni, min nɛ gɛ̀nde' nɛ, ki de' nɛ lituonl kí ye ní li joh, kí li te tɛn isigben yà lùonh isibii yà li tuu ki te. Nɛn bo, ni miɛ' nʼBaa nibonn nà kɛ nʼyel bo la, u li de nɛ nɛ̀ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","N yíe ni li teh nà si: ní li yíe tɔb nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","«Uŋɛndun ya nib nɛn nɛ la, ní li bɛn kí ye bi kpiɛ' ki nɛnde' min nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ni bi yé uŋɛndun yaab la, uŋɛndun yaab bi li yíe nɛ nɛ, kimɛ uŋɛndun ya nib yíe biʼyaab nɛ. Ama ninbi ŋa yé uŋɛndun yaab. N ñɛn' nɛ uŋɛndun ya nib ni ma nnɔ nɛ cère' bi nɛn nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Li tiɛn mɛn n là tɔke' nɛ nà ki ye: ‹Utonsɔnl ŋa cɛn' uʼcɛnbaa nnɔ.› Bi jɛ̀nde' min la, bi li jɛ̀nde niʼmɔ nɛ. Bi tuo' nʼgbɛr la, bi li tuo niʼmɔ yaar nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Min bo nɛ bi li tien nɛ nɛn kɛ, kimɛ ba bɛn wà sɔn' nni ní. ");
INSERT INTO gngNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ma bi baa' ki lá tɔke' bɛ nʼgbɛr la, uba ŋa bi li biin bɛ kí ye bi tien' ibiɛre, ama fɛnfɛnnɔ, ba ji li fre kí dule niba bo kí ye ba tien' biɛre. ");
INSERT INTO gngNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Unil nɛn nni la, u nɛn nʼBaa mɔ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ma bi sɔn' yɔkm ya tùon yà nisaal ŋa laan sɔn' yɛ̀ bi laa' la, uba ŋa bi li biin bɛ kí ye bi tien' biɛre. Ama fɛnfɛnnɔ bi laa' yɛ̀ nɛ ki nɛn min nin nʼBaa kɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ama nɛn kɛ tien' ŋɔ nɛ̀ ń cère nà kɛle' biʼyiko ya gbɔnku ni nnɔ nɛ̀ ń tien nɛ. Nì kɛle' ki ye: ‹Bi nɛn nni nɛ ka ŋmɔbe bi nɛn nni bà bo.› ");
INSERT INTO gngNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","«Tɔ, nʼBaa li cère ń sɔn Utotorl ní. U yé *Mifuoñaanm nɛ, ki yé tigbɛmɔ̀nt ya daan, ki ñɛn' ní nʼBaa saan. Mì lá baa' uyo wà la, mì li kun nʼbo imɔ̀n. ");
INSERT INTO gngNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Niʼmɔ li kun nʼbo imɔ̀n, kimɛ ni te nʼsaan haali nʼtuonl ya cincinyo nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","«N tɔke' nɛ nɛn kɛ ŋɔ nì lá tien' la, ni la wiɛ niʼtekjim nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Bi li ŋɔre nɛ itáan ya dur ni. Uyo uba mɔnɔn we ní, unil ku' nɛ la, u li maaleh ki teh u tien' lituɔrl nɛ ki de' Uwien. ");
INSERT INTO gngNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ba bɛnde' nʼBaa yé udaan wà, ka bɛnde' nʼmɔ yé udaan wà, nɛn nɛ li cère bɛ ń tien' nɛ nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","N tɔke' nɛ bi lá li tien' nɛ ma bo, ŋɔ u ya yo lá baa' la, ní li tiɛn kí ye n là tɔke' nɛ nɛ̀ ŋɔ.» «Ma là tɔke' nɛ tù nʼtuonl ya cincinyo, kimɛ min nin ninbi nɛ là te. ");
INSERT INTO gngNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Ama fɛnfɛnnɔ, n liɛbeh wà sɔn' nni ní nnɔ saan nɛ, nɛ niʼni uba ŋa niire' nni n joh nà bo-a?» ");
INSERT INTO gngNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Kimɛ n len' ki ye n li bure kí cère nɛ ma nnɔ nɛ niʼyɛnm saa' ki gbien'. ");
INSERT INTO gngNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ama n tɔkeh nɛ imɔ̀n nɛ, n jon' nɛ la, nì li mɔn niʼbo, kimɛ ma jon' la, Utotorl nnɔ ŋa ń baa ní. N jon' la, n li sɔn wɔ ní niʼsaan. ");
INSERT INTO gngNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","U lá baa' la, u li cère uŋɛndun ya nib ń bɛnde kí ye bi yé bibiɛrdɛnb, kí cère bɛ ń bɛnde kí ye Uwien cuube, kí bɛnde kí ye Uwien li bu bɛ tibuur. ");
INSERT INTO gngNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","U li cère bɛ ń bɛnde kí ye bi yé bibiɛrdɛnb, kimɛ ba teke' nni ki jin'. ");
INSERT INTO gngNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","U li cère bɛ ń bɛnde kí ye Uwien cuube, kimɛ n li jo nʼBaa saan, nɛ na ji li lɛ nni. ");
INSERT INTO gngNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","U li cère bɛ ń bɛnde kí ye bi li bu bɛ tibuur, kimɛ Uwien bun' uŋɛndun wuu ya ciɛn tibuur ŋɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","«N biɛ ki ŋmɔbe tigbɛr tù yɛbe ń tɔke nɛ, ama tù li kpiɛke nin nɛ fɛnfɛnnɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Uyo wà *Mifuoñaanm lá li baa nnɔ; mɛn mà yé tigbɛmɔ̀nt ya daan nnɔ; mì li pekre nɛ tigbɛmɔ̀nt ya sɛn kɛ ni. Ma ń tɔke miʼbugbɛn ya gbɛr, ama mì cii' tà nnɔ, tun nɛ mì li tɔke nɛ. Mì li tɔke nɛ nà lá li tien' ya gbɛr mɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Mì li kpiɛke nni, kimɛ mì li taa n ya gbɛr nɛ kí tɔke nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","NʼBaa ya bont kɛ yé nʼyaar nɛ, nɛn nɛ cère' n ye mì li taa n ya gbɛr nɛ kí tɔke nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","«Nì sìen' waamu, na ji li lɛ nni, nì pukn' waamu la, ni li lɛ nni.» ");
INSERT INTO gngNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Nɛ uʼpanpaankaab biba niireh tɔb ki teh: «U len' nà nɔ ya tingi si ba? U ye nì sìen' waamu, ta ji li lɛ wɔ, nì pukn' waamu la, ti li lɛ wɔ, ki ye u joh uʼBaa bó! ");
INSERT INTO gngNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Nɛ ki tí ye ‹U yih ba waamu?› Ta bɛn u ye wɔ ń ye bà?» ");
INSERT INTO gngNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","*Yesu bɛnde' bi yíe bɛ ń niire wɔ iniire, nɛ u tɔke' bɛ ki ye: «Ni niireh tɔb n len' ma ki ye: ‹nì sìen' waamu, na ji li lɛ nni, nì pukn' waamu la, ni li lɛ nni nnɔ ya tingi nɛ-a?› ");
INSERT INTO gngNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","N tɔkeh nɛ imɔ̀n nɛ, ninbi li muɔ kí kpiɛnde, nɛ uŋɛndun ya nib li pokn. Ninbi ya yɛnm li saa, ama niʼyɛnsaa nnɔ lá li kpɛnde uyɛnsɔnge. ");
INSERT INTO gngNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Upii benh nin timɛr la, u te uyɛnsaa ni nɛ uʼmɛrwiɛn bo. Ama u tì maa' ki gben' la, uyɛnsɔnge li cère wa ji li tiɛre imɛrwiɛn nnɔ bó, kimɛ unifaan kɔn' uŋɛndun ni. ");
INSERT INTO gngNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Nì te nnɔ nɛ niʼmɔ bo; fɛnfɛnnɔ, ni te uyɛnsaa ni nɛ. Ama n lá li liɛbe kí lɛ nɛ, nɛ ní li te uyɛnsɔnge ni. Uba ŋa ń fre kí ñɛn niʼyɛnsɔnge nnɔ niʼfɛ̀l ni. ");
INSERT INTO gngNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","«Nɛn daali na ji li niire nni bonn niba bó. N tɔkeh nɛ imɔ̀n nɛ, ni miɛ' nʼBaa nibonn nʼyel bo la, u li de nɛ nɛ̀ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Na laan miɛ' bonn nʼyel bo haali nin fɛnfɛnnɔ. Miɛ mɛn, ní li lɛ ŋɔ kí lɛ uyɛnsɔnge kí tì gben.» ");
INSERT INTO gngNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","«N tɔke' nɛ niʼkɛ mikpɛnjɛnm ni nɛ. Uyo uba we ní ma ji li pɔ kpɛnjɛnm kí tɔke nɛ gbɛr. Ama n li tɔke nɛ nʼBaa ya gbɛr nɛ̀ ń li wien nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Niʼdaali ni li miɛ nʼBaa tibont nʼyel bo. Ma tɔkeh nɛ ki teh min nɛ li miɛ nʼBaa kí de nɛ, ");
INSERT INTO gngNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","kimɛ nʼBaa bugbɛn nɛ yíe nɛ, ni yíe nni, ki teke' ki jin' ki ye n ñɛn' ní wɔn saan ma nnɔ bo. ");
INSERT INTO gngNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Tɔ, n ñɛn' nʼBaa saan nɛ ki baa' uŋɛndun ni, n tí li ñɛ uŋɛndun ni kí liɛbe nʼBaa bó.» ");
INSERT INTO gngNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Nɛ uʼpanpaankaab tɔke' wɔ ki ye: «A laa'-aa! Fɛnfɛnnɔ a ji lienh nì wien nɛ, ŋa ji pɔh kpɛnjɛnm. ");
INSERT INTO gngNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Fɛnfɛnnɔ ti bɛnde' ki ye a bɛn tibont kɛ, ŋa nuunh nil ń niire ŋɛ niire kí yaan á bɛnde u ye wɔ ń niire kí ye bà; nɛn nɛ cère' ti teke' ki jin' ki ye a ñɛn' ní Uwien saan nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Nɛ *Yesu niire' bɛ ki ye: «Ni teke' ki jin' fɛnfɛnnɔ wuɔ nɔ-ɔɔ? ");
INSERT INTO gngNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Tɔ, uyo uba we ní, ki lì baa'-a, niʼkɛ li yɛre wà kɛ ń taa u ya bó kí cère nni nʼbaba; ama ma te nʼbaba, kimɛ nʼBaa te nin nni. ");
INSERT INTO gngNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","N tɔke' nɛ tigbɛr tuu nɔ ŋɔ ni tɛ nin nni ma nnɔ, ní li te uyɛnduɔn ni nɛ. Uŋɛndun wuu ni, ni te ijɛnd ni nɛ, ama li co mɛn niʼba, kimɛ n faake' nin uŋɛndun ki gben' uʼtuɔm ŋɔ.» ");
INSERT INTO gngNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Tɔ, *Yesu len' nnɔ ki gben', nɛ ki yaare' ki liike' paaki bó, ki ye: «NʼBaa, uyo baa', wuɔn aʼBijɛ ya kpiɛke, ŋɔ aʼBijɛ mɔ ń wuɔn aʼkpiɛke. ");
INSERT INTO gngNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","A de' wɔ mituɔm unisaal kɛ bo ŋɔ wɔ ń taa limiɛl là ŋa ŋmɔbe gbenm kí de a de' wɔ binib bà nnɔ kɛ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Limiɛl là ŋa ŋmɔbe gbenm si bɛn ń bɛnde kí ye sin baba nɛ yé Uwien imɔ̀n, kí bɛnde *Yesu Kristo wà a sɔn' wɔ ní nnɔ mɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Min wuɔn' aʼkpiɛke kitink bo, ki sɔn' a de' nni lituonl là ń sɔn nnɔ ki gben'. ");
INSERT INTO gngNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","NʼBaa, fɛnfɛnnɔ, kpiɛke nni aʼsaan. De nni ukpiɛke wà n là ŋmɔbe wù aʼsaan ki laa' uŋɛndun ŋa laan te nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","«N cère' binib bà a gɛ̀nde' bɛ uŋɛndun ya nib ni, ki de' nni nnɔ bɛnde' a yé udaan wà. Bi là yé aʼyaab nɛ, nɛ a taa' bɛ ki de' nni, nɛ bi boh aʼgbɛr. ");
INSERT INTO gngNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Fɛnfɛnnɔ, bi bɛnde' ki ye a de' nni nibonn nà kɛ nnɔ ñɛn' aʼsaan nɛ, ");
INSERT INTO gngNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","kimɛ n tɔke' bɛ a tɔke' nni tigbɛr tà nnɔ, nɛ bi teke' tù, ki mɔnbe ki bɛnde' ki ye n ñɛn' ní aʼsaan nɛ, ki teke' ki jin' ki ye sin nɛ sɔn' nni ní. ");
INSERT INTO gngNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","«N kàareh ŋɛ ki dienh bɛn nɛ. Ma kàareh ŋɛ ki dienh uŋɛndun ya nib. Ama n kàareh ŋɛ ki dienh binib bà a de' nni bɛ nnɔ nɛ, kimɛ bi yé aʼyaab nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Nà kɛ yé nʼyaann yé aʼyaann nɛ, nɛ nà kɛ mɔ yé aʼyaann yé nʼyaann nɛ. Bɛn nɛ cèreh binib lɛnh nʼkpiɛke. ");
INSERT INTO gngNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ma ji li te uŋɛndun ni, bɛn nɛ li te uŋɛndun ni; min we ní aʼsaan nɛ. NʼBaa uñaan, a de' nni aʼyel là nnɔ, cère liyel bugbɛn ya tuɔm ń li gu bɛ, bɛ ń li yé unibaab tɛn min nin sin yé unibaab ma bo. ");
INSERT INTO gngNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","N là te biʼsaan uyo wà nnɔ, n là gu bɛ nin aʼyel là a de' nni nnɔ ya tuɔm nɛ. N guure' bɛ, nɛ nì kpaan' wà ń kpo kí juore fɛnm nnɔ baba ŋa ñí la, biʼni uba ŋa kpo' ki juore' fɛnm. U kpo' ki juore' fɛnm ŋɔ nà kɛle' aʼgbɔnku ni nnɔ nɛ̀ ń tien nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Fɛnfɛnnɔ, n we ní aʼsaan nɛ. N laan te uŋɛndun ni ma nnɔ nɛ ki lienh nnɔ, ŋɔ bɛ ń li ŋmɔbe uyɛnsɔnge wà n ŋmɔbe wù nnɔ kí tì gben. ");
INSERT INTO gngNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","N tɔke' bɛ aʼgbɛr, nɛ ŋɛndun ya nib nɛnde' bɛ, kimɛ ba yé ŋɛndun yaab, tɛn nʼmɔ ŋa yé ŋɛndun yɔ ma. ");
INSERT INTO gngNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ma kàareh ŋɛ ki teh á ñɛn bɛ uŋɛndun ni, ama n kàareh ŋɛ ki teh a la cère usɛnpol ubiɛrɔ nɛ ń tien bɛ niba. ");
INSERT INTO gngNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ba yé ŋɛndun yaab tɛn nʼmɔ ŋa yé ŋɛndun yɔ ma. ");
INSERT INTO gngNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Cère bɛn li cinbe ki yé aʼyaab tigbɛmɔ̀nt bo. Aʼgbɛr nɛ yé tigbɛmɔ̀nt nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","A sɔn' nni ní uŋɛndun ni ma nnɔ, nɛ nʼmɔ sɔn' bɛn uŋɛndun ni. ");
INSERT INTO gngNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Bɛn bo nɛ n taa' nʼba ki de' ŋɛ, ŋɔ biʼmɔ ń li cinbe ki yé aʼyaab tigbɛmɔ̀nt bo. ");
INSERT INTO gngNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","«Ma kàareh ŋɛ ki dienh bɛn baba, n kàareh ŋɛ ki dienh binib bà bi li tɔke bɛ nʼgbɛr bɛ ń teke nni kí ji nnɔ mɔ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","N kàareh ŋɛ ŋɔ biʼkɛ ń taan kí li yé unibaab nɛ. Tɛn sin nʼBaa a tɛ nin nni ma nʼmɔ tɛ nin ŋɛ nnɔ, cère biʼmɔ ń li tɛ nin tɛ, ŋɔ uŋɛndun ya nib ń teke kí ji kí ye sin nɛ sɔn' nni ní. ");
INSERT INTO gngNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","A de' nni ukpiɛke wà nnɔ, nʼmɔ de' bɛ wù, ŋɔ bɛ ń taan kí li yé unibaab tɛn min nin sin yé unibaab ma, ");
INSERT INTO gngNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","kimɛ n tɛ nin bɛ, nɛ aʼmɔ tɛ nin nni. Nnɔ nɛ bi taan' ki yé unibaab ki tì gben', ŋɔ uŋɛndun ya nib ń bɛnde kí ye sin nɛ sɔn' nni ní, kí bɛnde kí ye a yíe bɛ tɛn a yíe nni ma bo. ");
INSERT INTO gngNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","NʼBaa, a de' nni binib bà nnɔ, n yíe ń te nà saan la, biʼmɔ ń li te nin nni nɛ, kí lɛ a de' nni ukpiɛke wà nnɔ, kimɛ a yíe nni ki laa' ŋa laan ñɛn' uŋɛndun. ");
INSERT INTO gngNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","NʼBaa ugbɛmɔ̀ndaan, uŋɛndun ya nib ŋa bɛn ŋɛ, ama min bɛn ŋɛ. Nɛ biɛ nɔ mɔ bɛn ki ye sin nɛ sɔn' nni ní. ");
INSERT INTO gngNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","N cère' bi bɛnde' a yé udaan wà, ki li liɛbe kí cère bɛ ń bɛnde ŋɛ, ŋɔ a yíe nni miyíem ma nnɔ ń li te biʼni, ŋɔ nʼmɔ ń li tɛ nin bɛ.» ");
INSERT INTO gngNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","*Yesu len' nnɔ ki tì gben', nɛ wɔn nin uʼpanpaankaab bure' ki tì puore' kubunbunku kùa bi yih kù Sedrɔn nnɔ. Isiin ya kpàabu buba te niʼsaan, nɛ wɔn nin uʼpanpaankaab kɔn' buʼni. ");
INSERT INTO gngNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Sudas, wà kuɔre' *Yesu nnɔ, mɔ bɛn niʼsaan, kimɛ *Yesu nin uʼpanpaankaab là sɔbe ki taakeh nɛ̀ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Nɛ Sudas taa' Erom ya sojacɛkl liba nin Uwien ya duku ya guguurb bà bitɔtuɔrciɛnb nin *Farisiɛnmbɛ sɔn' bɛ nnɔ, bi joh niʼsaan ki tuke ifr nin imɔnafin nin tijɛkɔnwɛnt. ");
INSERT INTO gngNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","*Yesu bɛn nà kɛ li tu wɔ ma nnɔ, nɛ ki tuobe' bɛ usɛn bó, ki niire' bɛ ki ye: «Ni nuunh ŋmɛ?» ");
INSERT INTO gngNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Nɛ bi ye: «Ti nuunh Nasarɛt ya *Yesu nɛ.» Nɛ u ye: «Min sɔ.» Sudas wà kuɔre' wɔ nnɔ mɔ te biʼni. ");
INSERT INTO gngNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","U len' ki ye wɔn sɔ ma nnɔ, nɛ bi sulnh puoli bó ki luh. ");
INSERT INTO gngNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","*Yesu tí niire' bɛ ki ye: «Ni nuunh ŋmɛ?» Nɛ bi ye: «Ti nuunh Nasarɛt ya *Yesu nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Nɛ u ye: «N tɔke' nɛ ki ye min sɔ nɔ. Ni nuunh min nɛ la, cère mɛn biɛ bɛ ń li joh.» ");
INSERT INTO gngNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","U len' nnɔ ŋɔ u là len' tigbɛr tà nnɔ tù ń tien nɛ. U là len' ki ye: «NʼBaa a de' nni binib bà nnɔ, ma cère' uba mɔnɔn bole'.» ");
INSERT INTO gngNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Tɔ, Simɔn Piɛr ŋmɔbe kijusiek, nɛ ki nɛ̀re' ki gɛ' ki paare' bitɔtuɔrciɛnb ya ciɛn ya tonsɔnl uba ya nɔjietubl. Bi yih utonsɔnl nnɔ Malkus nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Nɛ *Yesu tɔke' Piɛr ki ye: «Jiin aʼjusiek kí cùɔn kiʼtuɔku ni. NʼBaa sien' ki ye ń ji ijɛnd yà nnɔ n la ji yɛ̀-ɛɛ?» ");
INSERT INTO gngNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Sojacɛkl nnɔ nin liʼciɛn nin Sufmbɛ ya guguurb nnɔ cuo' *Yesu ki lòle' uʼnuɔ, ");
INSERT INTO gngNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","nɛ ki kpiɛ' ki tuke' wɔ ki jon' Anni saan. Anni yé Kayif ya cuɔjɛ nɛ. Kayif nɛ là yé bitɔtuɔrciɛnb ya ciɛn libinl nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Wɔn Kayif nɛ là tɔke' *Sufmbɛ ya ciɛnb ki ye nì mɔn unibaab ń kpo biʼdu ya nib bo nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Bi tuke *Yesu ki joh ma nnɔ, nɛ Simɔn Piɛr nin *Yesu ya panpaankɛtɔ uba pɛ uʼbo. Bitɔtuɔrciɛnb ya ciɛn bɛn *Yesu ya panpaankɛtɔ bugbɛn. Nɛn bo nɛ u paan' *Yesu bo ki kɔn' bitɔtuɔrciɛnb ya ciɛn nnɔ den uluo bo. ");
INSERT INTO gngNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ama Piɛr wɔn juore' ki se saali nɛ bunañɔbu saan. Nɛ upanpaankɛtɔ wà bitɔtuɔrciɛnb ya ciɛn bɛn wɔ nnɔ jon' ki tì laa' upiitonsɔnl wà gu bunañɔbu nnɔ, nɛ ki cère' Piɛr kɔn'. ");
INSERT INTO gngNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Nɛ upii nnɔ niire' Piɛr ki ye: «Sin, aʼmɔ ŋa lii yé ujɛ wuɔ ya panpaankaab ya uba-aa?» Nɛ u jiin' wɔ ki ye: «Ma yé uʼpanpaankɛ.» ");
INSERT INTO gngNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Tiwɔr là te, nɛ bitɔtuɔrciɛnb ya ciɛn ya tonsɔnb nin biguguurb sɛ̀re' umu, ki lokreh. Nɛ Piɛr mɔ te biʼsaan ki lokreh. ");
INSERT INTO gngNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Bitɔtuɔrciɛnb ya ciɛn niire' *Yesu iniire uʼpanpaankaab bo nin u wɔknh miwɔknm ma nnɔ bo. ");
INSERT INTO gngNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Nɛ *Yesu jiin' wɔ ki ye: «N len' binib kɛ ya nun bó nɛ, ki wɔkn' uyo kɛ niʼtáan ya dur ni nin Uwien ya duku ya luo bo, *Sufmbɛ kɛ taakeh nà saan. Ma len' gbɛr tuba bɔlm ni. ");
INSERT INTO gngNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Bɛ tien' a niireh min-i? Niire binib bà cenge' nʼgbɛr n tɔke' bɛ ki ye bà. Bɛn bɛn n tɔke' bɛ ki ye bà mɔnmɔnm.» ");
INSERT INTO gngNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","*Yesu len' nnɔ ma nnɔ, ki laa' biguguurb ya uba se ki nɛke wɔ, nɛ ki kpɔ̀be' wɔ utɛnpɛ, ki niire' wɔ ki ye: «A jiindeh bitɔtuɔciɛnb ya ciɛn nɛ nɔ nnɔ-ɔɔ?» ");
INSERT INTO gngNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Nɛ *Yesu jiin' wɔ ki ye: «N len' nì bre nɛ la, wuɔn nà cère' nì bre; nɛ n tí len' nì mɔn nɛ la, bɛ tien' a ñih nni?» ");
INSERT INTO gngNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Nɛn saan nɛ Anni cère' bi taa' *Yesu ki jon' bitɔtuɔrciɛnb ya ciɛn Kayif saan uʼnuɔ juore' ki lùo. ");
INSERT INTO gngNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simɔn Piɛr se ki lokreh umu, nɛ bi niire' wɔ ki ye: «Sin, aʼmɔ ŋa lii yé uʼpanpaankaab ya uba-aa?» Nɛ u niɛ' ki ye: «Ma yé uʼpanpaankɛ.» ");
INSERT INTO gngNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Nɛ bitɔtuɔrciɛnb ya ciɛn ya tonsɔnb ya uba, wà Piɛr bi gɛ' ki paare' uʼtubl nnɔ ya den yɔ uba tɔke' Piɛr ki ye: «Ma bi laa' ŋɛ uʼsaan bukpàabu nnɔ ni-ii?» ");
INSERT INTO gngNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Nɛ Piɛr tí niɛ' ki ye wa bɛn Yesu. Nɛ ukuojɛ pɔk ki muɔ' i ya tàan bo. ");
INSERT INTO gngNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Nɛn saan nɛ bi taa' *Yesu ki ñɛn' Kayif den, ki jon' udu nnɔ ya gobina den, bi yih wɔ Pilat. Nì là yé kutɛnŋɛsɔnsɔnku nɛ. *Sufmbɛ ya ciɛnb ŋa là yíe bɛ ń kuɔn biʼba jɔknt ŋɔ kí fre kí jele biʼPak ya nacenku nɛ. Nɛn nɛ cère' ba tuo' ki kɔn' Pilat den. ");
INSERT INTO gngNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Nɛn bo nɛ Pilat ñɛn' saali biʼsaan, ki niire' bɛ ki ye: «Ujɛ wuɔ tien' ba ni biindeh wɔ?» ");
INSERT INTO gngNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Nɛ bi jiin' wɔ ki ye: «Wa bi yé nibiɛrɔ la, ta bi cuo' wɔ ki ŋukn' ŋɛ.» ");
INSERT INTO gngNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Nɛ Pilat ye: «Ninbi bugbɛn, taa wɔ mɛn kí tì bu wɔ niʼyiko ye ma bo.» Nɛ bi ye: «Tinbi Sufmbɛ ŋa ŋmɔbe sɛn tí ku nil.» ");
INSERT INTO gngNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Bi len' nà nɔ nɛ wuɔn' ki ye *Yesu là len' nà ki tɔke' binib, u li kpo mikuum mà ya bol nnɔ nɛ ń tien. ");
INSERT INTO gngNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilat tí liɛbe' ki kɔn' tibuur ya duku ni, ki yin' *Yesu ki lá niire' wɔ ki ye: «Sin, a yé *Sufmbɛ ya bɛr nɛ-ɛɛ?» ");
INSERT INTO gngNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Nɛ *Yesu jiin' wɔ ki ye: «A len' nà nɔ, a maale' aʼba nɛ bii bi tɔke' ŋɛ nɛ ki ye n yé *Sufmbɛ ya bɛr-i?» ");
INSERT INTO gngNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Nɛ Pilat tɔke' wɔ ki ye: «Min ŋa yé Suf-a! Aʼbol ya nib nin bitɔtuɔrciɛnb nɛ taa' ŋɛ ki ŋukn' nni. A tien' bɛ nɛ?» ");
INSERT INTO gngNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Nɛ *Yesu ye: «Nʼbɛl ŋa yé uŋɛndun wuu ni ya bɛl. Nʼbɛl bi yé uŋɛndun wuu ni ya bɛl la, nʼnib bi li kɔn tijɛr ŋɔ *Sufmbɛ ya ciɛnb la fre kí cuo nni. Ama fɛnfɛnnɔ, nʼbɛl ŋa nín te niɛ saan.» ");
INSERT INTO gngNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Nɛ Pilat tɔke' wɔ ki ye: «Nɛn mɛn la, a yé ubɛr nɛ-a!» Nɛ *Yesu jiin' wɔ ki ye: «Sin nɛ ye n yé ubɛr. N baa' uŋɛndun wuu ni ń lá tɔke binib tigbɛmɔ̀nt nɛ. Nɛn bo nɛ bi maa' nni. Unil wà kɛ pɛ tigbɛrmɔ̀nt bo nɛ cengeh nʼbó.» ");
INSERT INTO gngNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Nɛ Pilat niire' wɔ ki ye: «Tigbɛmɔ̀nt si ba?» Pilat len' nnɔ ma nnɔ nɛ ki tí ñɛn' *Sufmbɛ bó, ki tì tɔke' bɛ ki ye: «Min ŋa laa' uʼbiil. ");
INSERT INTO gngNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ama binl kɛ binl niʼPak ya nacenku ya yo la, n tuu ki ñɛndeh lipɛkl ya nil uba nɛ ki wiɛnh. Nɛn bo, ni yíe ń taa *Sufmbɛ ya bɛr nnɔ nɛ kí wiɛ-ɛɛ?» ");
INSERT INTO gngNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Nɛ bi wuure' ki ye: «La wiɛ wɔn, wiɛ Barabas.» Barabas nnɔ là yé unil wà yìe' Erom yaab ya ñɔbu bó nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Nɛn saan nɛ Pilat cère' bi taa' *Yesu ki ñi' wɔ inalɛbe. ");
INSERT INTO gngNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Sojambɛ taa' ikonkon ki lònlòn' uyukpɛkpiɛ ki kpɛle' uʼyul, ki taa' kuliɛrmɔ́nmɔ́nku kuba ki goln' wɔ, ");
INSERT INTO gngNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","nɛ ki nɛkndeh wɔ ki tɔkeh wɔ ki teh: «Sufmbɛ ya bɛrɔ, ti fuondeh ŋɛ-a!» Nɛ ki kpɔ̀breh wɔ itɛnpɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Nɛ Pilat tí ñɛn' saali, ki tɔke' *Sufmbɛ ki ye: «N li taa wɔ kí ñɛn ní saali niʼsaan ŋɔ ní bɛnde kí ye ma laa' uʼbiil.» ");
INSERT INTO gngNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Nɛn saan nɛ *Yesu ñɛn' ní saali ki kpiɛ ikonkon ya yukpɛkpiɛ, ki guo kuliɛrmɔ́nmɔ́nku nnɔ. Nɛ Pilat tɔke' bɛ ki ye: «Ujɛ bugbɛn sɔ.» ");
INSERT INTO gngNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ama bitɔtuɔrciɛnb nin biguguurb laa' wɔ ma nnɔ nɛ ki wuureh ki teh: «Kpɛ wɔ udɔpɔnpɔn bo! Kpɛ wɔ udɔpɔnpɔn bo!» Nɛ Pilat tɔke' bɛ ki ye: «Niʼbugbɛn ń taa wɔ kí tì kpɛ wɔ udɔpɔnpɔn bo, kimɛ min ŋa laa' u bii' nà nì kpɛ kuum.» ");
INSERT INTO gngNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Nɛ bi tɔke' wɔ ki ye: «Tinbi ŋmɔbe yiko uba nɛ, nɛ yiko nnɔ bo, u kpɛ mikuum nɛ, kimɛ u taa' uʼba ki tien' Uwien ya Bijɛ nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilat cii' bi ye *Yesu taa' uʼba ki tien' Uwien ya Bijɛ ma nnɔ, nɛ bujɛwaanbu tùɔre' ki cuo' wɔ cɛɛn. ");
INSERT INTO gngNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Nɛ u tí liɛbe' ki kɔn' tibuur ya duku nnɔ ni ki tí niire' *Yesu ki ye: «Sin, a yé lɛ bó yɔ nɛ?» Ama *Yesu ŋa jiin' wɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Nɛ Pilat tɔke' wɔ ki ye: «Ŋa gɛreh min nɛ-ɛɛ? Ŋa bɛn ki ye n ŋmɔbe mituɔm ń wiɛ ŋɛ bii ń kpɛ ŋɛ udɔpɔnpɔn bo-oo?» ");
INSERT INTO gngNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Nɛ *Yesu tɔke' wɔ ki ye: «Uwien de' ŋɛ mituɔm mà nnɔ baba ŋa ñí la, ŋa ŋmɔbe tuɔm miba nʼbo. Nɛn bo nɛ unil wà taa' nni ki ŋukn' ŋɛ nnɔ ya biil cɛn' aʼyaal.» ");
INSERT INTO gngNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Nɛn saan nɛ Pilat nuunh u li tien ma kí wiɛ Yesu, ama *Sufmbɛ wuureh nɛ ki teh: «A wiɛ' wɔ la, ŋa ji yé ubɛrciɛn Sesa ya jɔ, kimɛ unil wà kɛ yih uʼba ubɛr la, u yé Sesa ya nɛnnɛnd nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilat cii' bi len' nnɔ ma nnɔ, nɛ ki tí ñɛn' *Yesu saali, nɛ ki kɛ̀le' tibuur ya biɛk bo, bi yih libùol là «Itɛn ya bɛnbɛnl nnɔ.» *Sufmbɛ ya lenm ni, bi yih niʼsaan ki teh «Gabata» nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Nì là yé lidaali là *Sufmbɛ bondeh biʼPak ya nacenku nnɔ nɛ, ki tuo liwenyul ya yo, nɛ Pilat tɔke' bɛ ki ye: «Niʼbɛr sɔ.» ");
INSERT INTO gngNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Nɛ bi wuure' ki ye: «U kpɛ mikuum nɛ! U kpɛ mikuum nɛ! Kpɛ wɔ udɔpɔnpɔn bo!» Nɛ Pilat niire' bɛ ki ye: «N kpɛ niʼbɛr udɔpɔnpɔn bo-oo?» Nɛ bitɔtuɔrciɛnb jiin' wɔ ki ye: «Ta ŋmɔbe bɛrtɔ ki kɛnde' ubɛrciɛn Sesa bo.» ");
INSERT INTO gngNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Nɛn saan nɛ Pilat taa' *Yesu ki ŋukn' bɛ bɛ ń tì kpɛ wɔ udɔpɔnpɔn bo. Nɛ bi taa' wɔ ki bure'. ");
INSERT INTO gngNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","*Yesu bugbɛn tuke uʼdɔpɔnpɔn ki ñɛn' udu ni, ki joh niba saan, bi yih nɛ̀ «Kuyukpɔbku ya Bùol.» *Sufmbɛ ya lenm ni, bi yih niʼsaan «Golgota» nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Bi kpɛ' wɔ udɔpɔnpɔn bo nɛn saan nɛ, nɛ ki kpɛ' bijɛb bile mɔ; uba ukɛle uba, utɔ mɔ ukɛltɔ, nɛ *Yesu fo siik ni. ");
INSERT INTO gngNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilat kɛle' mikɛlm miba ki ye: «Nasarɛt ya *Yesu wà yé *Sufmbɛ ya bɛr nnɔ sɔ», nɛ ki cère bi taa' ki tɛbn' uʼdɔpɔnpɔn bo. ");
INSERT INTO gngNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Nì kɛle' *Sufmbɛ ya lenm ni nin Erom yaab ya lenm ni nin Grɛkmbɛ ya lenm ni nɛ. Bi kpɛ' *Yesu udɔpɔnpɔn bo nà saan nnɔ ŋa fɔke nin udu ni, nɛn nɛ cère' *Sufmbɛ bà yɛbe kaan' mikɛlm nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Nɛ *Sufmbɛ ya tɔtuɔrciɛnb tɔke' Pilat ki ye: «Ŋa bi li kɛle kí ye *Sufmbɛ ya bɛr, a bi li kɛle kí ye: wɔn nɛ ye u yé *Sufmbɛ ya bɛr nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Nɛ Pilat tɔke' bɛ ki ye: «N kɛle' nà nɔ n kɛle' nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Sojambɛ kpɛ' *Yesu udɔpɔnpɔn bo ki gben', nɛ ki gbiire' uʼwɛngolkaar igbiin inan, wà kɛ ugbiin uba ki tì sìen' uʼliɛrfɔfɔkrku. Kuliɛrfɔfɔrku nnɔ ŋa ŋmɔbe ñɛñiɛ kí ñɛ paaki kí tì ci tingi, kimɛ bi là lòn' kù nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Nɛn saan nɛ bi tɔke' tɔb ki ye: «Ti la kɛre kù mɛn, cère mɛn tí fùɔre imúɔn, kí liike wà li ji kù.» Nɛn kɛ tien' ŋɔ nà kɛle' *Uwien ya gbɔnku ni nnɔ nɛ̀ ń tien nɛ. Nì kɛle' ki ye: «Bi gbiire' nʼwɛngolkaar, nɛ ki fùɔre' imúɔn, bɛ ń liike wà li ji nʼliɛrku.» Tɔ, sojambɛ nnɔ tien' nɛn nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","*Yesu ya naa nin uʼnaa ya ninsɛ nin Klopas ya po Mari nin Mari Madelɛnn se uʼdɔpɔnpɔn saan. ");
INSERT INTO gngNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","*Yesu laa' uʼnaa nin uʼpanpaankɛ wà u yíe wɔ ki gbien' nnɔ se ki buɔke, nɛ u tɔke' uʼnaa ki ye: «Upii, aʼbijɛ sɔ,» ");
INSERT INTO gngNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","nɛ ki tɔke' uʼpanpaankɛ nnɔ mɔ ki ye: «Aʼnaa sɔ.» Kí ñɛ nɛn daali nɛ uʼpanpaankɛ nnɔ cère' *Yesu ya naa te uʼden. ");
INSERT INTO gngNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ni ya puoli bó nɛ *Yesu bɛn ki ye fɛnfɛnnɔ u sɔn' uʼtùon kɛ ki gben'-a, nɛ ki len' ki ye: «Uñuñun nɛ ŋmɔbe nni,» ŋɔ nà kɛle' *Uwien ya gbɔnku ni nnɔ ń tien. ");
INSERT INTO gngNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Licuɔl liba se niʼsaan ki gbe midɛŋmiŋmiikm miba, nɛ bi taa' ticitɔnt ki sèkn' miʼni, ki taa' ki tuun' kusiiku kùa bi yih kù isɔp nnɔ ya lɛnbɛnl bo, ki tɛnde' ki kòle' uʼñɔbu. ");
INSERT INTO gngNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","U muɔre' midaam nnɔ nɛ ki ye: «N tien' niʼkɛ ki gben' nínɔ», ki gòn', nɛ ki kpo'. ");
INSERT INTO gngNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Nì là yé lidaali là *Sufmbɛ bondeh biʼSaba nɛ. U ya *Saba là yé uwengbenge nɛ. Nɛn bo nɛ *Sufmbɛ ya ciɛnb ŋa là yíe nikpil ń li te dɔpɔnpɔn bo, nɛ ki tɔke' Pilat ki ye wɔ ń cère uʼsojambɛ ń ñì kí kuɔ bi kpɛ' binib bà nnɔ ya tàan, kí jiin bɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Nɛ sojambɛ nnɔ baa' ki ñi' ki kuɔ' binib bà bi kpɛ' bɛ idɔpɔnpɔn bo nin *Yesu nnɔ ya tàan. Bi ñi' ki kuɔ' ukpiɛk yɛ, ki ñi' ki kuɔ' ulie mɔ yɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ama bi tì baa' *Yesu saan ma nnɔ, ki laa' u kpo'-a, nɛn bo nɛ ba kuɔ' uʼyɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Nɛ sojambɛ nnɔ ya uba taa' likpaanl ki cɔke' *Yesu ya kɛle ni. Nɛ misɛ̀m nin miñunm pɔk ki ñɛn' i ya tàan bo. ");
INSERT INTO gngNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Unil wà laa' tibont nnɔ nɛ tɔke' u laa' nà. U len' nà nɔ yé imɔ̀n nɛ, nɛ u bɛn ki ye u tɔke' tigbɛmɔ̀nt nɛ, ŋɔ niʼmɔ ń teke kí ji. ");
INSERT INTO gngNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Bi tien' *Yesu nnɔ ŋɔ nà kɛle' *Uwien ya gbɔnku ni nnɔ nɛ̀ ń tien nɛ. Nì kɛle' ki ye: «Ba ń kuɔ uʼkpɔbl liba mɔnɔn.» ");
INSERT INTO gngNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Nì tì liɛbe' ki kɛle' *Uwien ya gbɔnku ni ki ye: «Bi li caan unil wà bi cɔke' wɔ likpaanl nnɔ bo inun.» ");
INSERT INTO gngNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ni ya puoli bó nɛ Yosɛf wà yé Arimate ya du ya nil nnɔ baa' ki miɛ' Pilat ki ye wɔ ń cɛ̀be wɔ wɔ ń jiin' *Yesu ya gbɛnɛnt udɔpɔnpɔn bo. Pilat tuo', nɛ u jon' ki tì jiin' tù. Yosɛf bugbɛn là yé *Yesu ya panpaankɛ nɛ ka tuo' nil ń bɛnde, kimɛ u là fɛnge *Sufmbɛ ya ciɛnb nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodɛm, wà là baa' *Yesu saan miba kuñɔnku nnɔ mɔ baa', ki tuke' lɛfina. Bi cùuke lɛfina wà bi yih wɔ *miir nnɔ nin bi yih wà alowɛs nnɔ nɛ. Lɛfina nnɔ ya kpiɛke li baa' tɛn kilo pita. ");
INSERT INTO gngNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Yosɛf nin Nicodɛm taa' kukpɛlciɛku ki tɛntɛn' *Yesu ya gbɛnɛnt, nɛ ki taa' lɛfina nnɔ ki tien' tuʼbo, *Sufmbɛ subeh bitɛnkpiib ma bo. ");
INSERT INTO gngNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Isiin ya kpàabu buba te bi kpɛ' *Yesu nà saan nnɔ. Bi là gbin' ufɛle uba bukpàabu nnɔ ni ka laan sube' nil len. ");
INSERT INTO gngNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Nì là yé lidaali là *Sufmbɛ bondeh Saba nɛ, nɛ ufɛle nnɔ mɔ ŋa fɔke nin niʼsaan. Nɛn bo nɛ bi taa' *Yesu ki tì sube' uʼni. ");
INSERT INTO gngNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","*Saba ya daali gɛ̀bre', kutaaku kùa li faa nnɔ nɛ Mari Madelɛnn wɔre' ki fii' nì bìike, ki bure' likul nnɔ bó. U tì baa' ki laa' kutɛnku kùa bi là taa' ki bìin' likul nnɔ ŋa ji bi. ");
INSERT INTO gngNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Nɛ u sɛn' ki jon' Simɔn Piɛr nin *Yesu ya panpaankɛtɔ wà u yíe wɔ ki gbien' nnɔ saan, ki tì tɔke' bɛ ki ye: «Bi ñɛn' Yonbdaan likul nnɔ ni ŋɔ! Ta bɛn bi taa' wɔ ki ble' nà saan!» ");
INSERT INTO gngNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Nɛn saan nɛ Piɛr nin *Yesu ya panpaankɛtɔ nnɔ ñɛn' ki joh likul nnɔ bó. ");
INSERT INTO gngNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Bi joh ma nnɔ biʼkɛ bile tiinh nɛ, ama upanpaankɛtɔ nnɔ sɛn' ki cɛn' Piɛr ki kpiɛ' ki baa' liʼsaan, ");
INSERT INTO gngNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","nɛ ki gbìen' ki liike', ki laa' tikpɛlcɛr nnɔ nɛ dɔ len, ama wa kɔn'. ");
INSERT INTO gngNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simɔn Piɛr, wà paan' puoli bó ní nnɔ, mɔ baa', nɛ ki kɔn' likul nnɔ ni, ki laa' tikpɛlcɛr nnɔ dɔ len, ");
INSERT INTO gngNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ki laa' kukpɛlciɛku kùa bi là taa' ki pibn' *Yesu ya yul nnɔ jɛnde' ki dɔ likonkonl, kuʼba. ");
INSERT INTO gngNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Nɛn saan nɛ upanpaankɛ wà bi kpiɛ' ki baa' likul saan nnɔ mɔ kɔn' ki laa', nɛ ki teke' ki jin'. ");
INSERT INTO gngNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Kimɛ haali nin u ya yo ba laan là cii' nà kɛle' *Uwien ya gbɔnku ni ki ye *Yesu lá li mɛkre bitɛnkpiib ni nnɔ ya tingi. ");
INSERT INTO gngNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Nɛ *Yesu ya panpaankaab nnɔ liɛbe' ki kùn'. ");
INSERT INTO gngNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Tɔ, Mari juore' ki se saali nɛ likul nnɔ saan ki muɔh. U se ki muɔh, nɛ ki lá gbìen' ki liike' liʼni, ");
INSERT INTO gngNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ki laa' Uwien ya tondb bile bi guo tiwɛnpenpient ki kɛ *Yesu ya gbɛnɛnt là dɔ nà saan nnɔ. Uba kɛ uʼyul là kunh nà bó, nɛ utɔ mɔ kɛ uʼtàan là kunh nà bó nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Nɛ bi niire' wɔ ki ye: «Upii, bɛ tien' a muɔh?» Nɛ u jiin' bɛ ki ye: «Bi ñɛn' nʼYonbdaan nɛ, ma bɛn bi taa' wɔ ki ble' nà saan.» ");
INSERT INTO gngNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","U len' nnɔ ma nnɔ nɛ ki jiɛbe' ki laa' *Yesu se, ama wa bɛnde' ki ye *Yesu nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Nɛ *Yesu niire' wɔ ki ye: «Upii, bɛ tien' a muɔh? A nuunh ŋmɛ?» Mari maale' ki ye ujɛ wà gu bukpàabu nnɔ nɛ, nɛ ki tɔke' wɔ ki ye: «Cɛnbaa, sin nɛ taa' wɔ la, wuɔn' nni, a ble' wɔ nà saan ń jo kí taa.» ");
INSERT INTO gngNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Nɛ *Yesu ye: «Mari.» Nɛ u jiɛbe' ki tɔke' wɔ *Sufmbɛ ya lenm ni ki ye: «Rabuni.» Niʼtingi si «Cɛnbaa.» ");
INSERT INTO gngNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Nɛ *Yesu ye: «La li co nni, kimɛ ma laan don' nʼBaa bó, ama jo kí tì tɔke nʼninjiɛb kí ye: n doh nʼBaa wà yé niʼmɔ ya baa nnɔ bó nɛ. U yé nʼWien nɛ, ki yé niʼmɔ ya Wien.» ");
INSERT INTO gngNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Nɛ Mari Madelɛnn jon' ki tì tɔke' *Yesu ya panpaankaab ki ye: «N laa' Yonbdaan,» nɛ ki tɔke' bɛ *Yesu tɔke' wɔ tigbɛr tà nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Tɔ, *Saba ya daali gɛ̀bre', kutaaku kùa li faa' nnɔ ya tajuɔku, nɛ *Yesu ya panpaankaab taan' ki te kuduku kuba ni ki pìnpìin' inañuɔn, kimɛ bi là fɛnge *Sufmbɛ ya ciɛnb nɛ. Nɛ *Yesu baa' ki lá sere' biʼsiik ni, ki tɔke' bɛ ki ye: «Li te mɛn uyɛnduɔn ni.» ");
INSERT INTO gngNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","U len' nnɔ, nɛ ki wuɔn' bɛ uʼnuɔ nin uʼkɛle ni ya gbìɛn. Uʼpanpaankaab laa' wɔ ma nnɔ, nɛ biʼyɛnm sɔnge. ");
INSERT INTO gngNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Nɛ u tí tɔke' bɛ ki ye: «Li te mɛn uyɛnduɔn ni. NʼBaa sɔn' nni ma nnɔ, nɛ nʼmɔ sɔn' ninbi.» ");
INSERT INTO gngNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","U len' nnɔ, nɛ ki piebe' biʼbo, ki tɔke' bɛ ki ye: «Teke mɛn *Mifuoñaanm. ");
INSERT INTO gngNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ni fère' binib bà biʼbiɛre la, Uwien mɔ li fère bɛ. Na fère' bà la, Uwien mɔ ŋa ń fère bɛ.» ");
INSERT INTO gngNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","*Yesu ya panpaankaab piik nin bile ya uba bi yih wà Toma, ki liɛbe' ki yih wɔ lilebl nnɔ, ŋa là te nin bitɔb uyo wà *Yesu baa' biʼsaan nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Bipanpaankɛtɔb tɔke' wɔ ki ye: «Ti laa' Yonbdaan.» Nɛ u tɔke' bɛ ki ye: «Ma laa' bi là kpɛ' uʼnuɔ ni ipenjen nà saan ya gbìɛn, ka taa' nʼnɔbil ki tuun' igbìɛn nnɔ ni, ka taa' nʼnuɔ ki tuun' bi là cɔke' uʼkɛle ni nà saan nnɔ ya gbiɛl ni la, ma ń teke kí ji fiebu.» ");
INSERT INTO gngNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Tɔ, iwien iniin gɛ̀bre', nɛ *Yesu ya panpaankaab tí taan' ki te kuduku ni. Toma mɔ ji te biʼni. Nin inañuɔn pipi ma kɛ nnɔ *Yesu baa' ki lá sere' biʼsiik ni ki ye: «Li te mɛn uyɛnduɔn ni.» ");
INSERT INTO gngNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Nɛ ki tɔke' Toma ki ye: «Tɛnde aʼnɔbil kí mɛ niɛ saan, kí liike nʼnuɔ ya gbìɛn, kí tɛnde aʼnuɔ kí tuun nʼkɛle ya gbiɛl mɔ ni. Ji la maaleh tɛma, teke kí ji.» ");
INSERT INTO gngNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Nɛ Toma ye: «A yé nʼYonbdaan nin nʼWien nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Nɛ *Yesu tɔke' wɔ ki ye: «A laa' nni ma nnɔ nɛ ki teke' ki jin'. Bà ŋa laa' nni ki teke' ki jin' nnɔ, Uwien ya mɔnm te biʼbo.» ");
INSERT INTO gngNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","*Yesu tien' miyɔkm ya bontɔr mɔ tù yɛbe uʼpanpaankaab ya nun ni. Ba kɛle' tù kugbɔnku kuu ni. ");
INSERT INTO gngNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Bi kɛle' tuu nɔ ŋɔ ní teke kí ji kí ye *Yesu yé Uwien ya Nigɛndkɛ Kristo, ki yé Uwien ya Bijɛ nɛ. Ni teke' wɔ ki jin' la, wɔn bo nɛ ni li lɛ limiɛl. ");
INSERT INTO gngNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ni ya puoli bó nɛ *Yesu tí cère' uʼpanpaankaab laa' wɔ Tiberiyad ya ñunciɛnm ya gbaal. U cère' bi laa' wɔ ma sɔ: ");
INSERT INTO gngNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simɔn Piɛr nin Toma wà bi liɛbe' ki yih wɔ lilebl nnɔ nin Natanayɛl wà ñɛn' ní Kana ya du wà te Galile ya tinfɛnm ni nnɔ nin Sebede ya bijiɛb nin *Yesu ya panpaankaatɔb bile nɛ là taan' ki te. ");
INSERT INTO gngNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Nɛ Simɔn Piɛr tɔke' bɛ ki ye: «N joh lijɛnbɛl nɛ.» Nɛ bi ye: «Tiʼmɔ li paan aʼbo.» Nɛ bi ñɛn' ki bure' ki tì kɔn' buñɛrbu. Ba cuo' bonn haali kuñɔnŋmɛnku. ");
INSERT INTO gngNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Nì tì wendeh uyo wà nnɔ, nɛ bi laa' *Yesu se miñunm ya gbaal. Ama uʼpanpaankaab nnɔ ŋa bɛnde' ki ye wɔn nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Nɛ u niire' bɛ ki ye: «Hee! Nacenbɛ, na laa' bonn bi?» Nɛ bi ye: «Ta laa' bonn.» ");
INSERT INTO gngNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Nɛ u tɔke' bɛ ki ye: «Wiɛ mɛn bubɛbu buñɛrbu ya jie bó, ni li lɛ.» Bi wiɛ' ki cuo' ijɛn ì yɛbe cɛɛn nɛ ka fre' ki dɛre' bubɛbu nnɔ ki jiin' ní. ");
INSERT INTO gngNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Nɛ *Yesu ya panpaankɛ wà u yíe wɔ ki gbien' nnɔ tɔke' Piɛr ki ye: «Yonbdaan nɛ.» Simɔn Piɛr cii' Yonbdaan nɛ ma nnɔ, ki laa' u te liñil nɛ, nɛ u taa' uʼliɛrl ki gole', ki lu' miñunm ni ki joh uʼsaan. ");
INSERT INTO gngNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Uʼpanpaankɛtɔb bà sìen' nnɔ we ní buñɛrbu ni ki diɛh bubɛbu bù gbe ijɛn. Ba là fɔke nin ñunm ya gbaal. Nì li te tɛn mɛta kobk nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Bi tì baa' miñunm ya gbaal ki ñɛn' buñɛrbu ni nɛ ki laa' ikuɔn ya mu uba, ujɛn puu uʼni, ki laa' kpɔnɔ mɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Nɛ *Yesu tɔke' bɛ ki ye: «Taa ní mɛn ni cuo' ijɛn yà nɔ ya iba.» ");
INSERT INTO gngNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Nɛn saan nɛ Simɔn Piɛr liɛbe' buñɛrbu nnɔ ni, ki tì dɛre' bubɛbu ki ñɛn' liwɛl bo, bù gbe ijɛngbengbenge kobk nin piŋun nin ita. Nin ì yɛbe ma kɛ nnɔ, bubɛbu nnɔ ŋa kɛre'. ");
INSERT INTO gngNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Nɛ *Yesu tɔke' bɛ ki ye: «Dɛn mɛn kí ŋmɔn.» Uʼpanpaankaab ya uba mɔnɔn ŋa tɔnge wɔ ń niire wɔ kí ye: «Sin ŋmɛ nɛ?» Kimɛ bi bɛn ki ye Yonbdaan nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Nɛn saan nɛ *Yesu nɛkn', ki yuure' kpɔnɔ ki de' bɛ, ki taa' ujɛn nnɔ mɔ ki de' bɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","*Yesu tì mɛkre' bitɛnkpiib ni ki cère' uʼpanpaankaab laa' wɔ ma, bolmta sɔ. ");
INSERT INTO gngNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Bi jin' tijier nnɔ ki gben' uyo wà nnɔ, nɛ *Yesu niire' Simɔn Piɛr ki ye: «Simɔn, San ya bijɛ, a yíe nni ki cɛn' biɛ nɔ-ɔɔ?» Nɛ u jiin' wɔ ki ye: «Hnn, Yonbdaan, sin mɔnɔn bɛn ki ye n fɛ ŋɛ.» Nɛ *Yesu tɔke' wɔ ki ye: «Li likeh nʼpebumu». ");
INSERT INTO gngNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Nɛ ki liɛbe' ki niire' wɔ ki lere' ki ye: «Simɔn, San ya bijɛ, a yíe nni-ii?» Nɛ u tí jiin' wɔ ki ye: «Hnn, Yonbdaan, sin mɔnɔn bɛn ki ye n fɛ ŋɛ.» Nɛ *Yesu tɔke' wɔ ki ye: «Li yé nʼpekpaal.» ");
INSERT INTO gngNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Nɛ ki liɛbe' ki niire' wɔ nta ki ye: «Simɔn, San ya bijɛ, a fɛ nni-ii?» Nɛ Piɛr ya yɛnm saa', kimɛ *Yesu niire' wɔ bolmta sɔ ki ye: «A fɛ nni-ii?» Nɛ u jiin' wɔ ki ye: «Yonbdaan, a bɛn tibont kɛ, ki bɛn ki ye n fɛ ŋɛ.» Nɛ *Yesu tɔke' wɔ ki ye: «Li kpaah nʼpe. ");
INSERT INTO gngNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","N tɔkeh ŋɛ imɔ̀n nɛ, a là yé unacenfaan ma nnɔ, a là guoh aʼkpɛlcɛr aʼba nɛ, ki joh a yíe nà bó. Ama a tì pore' uyo wà la, a li yuon aʼnuɔ, nɛ unitɔ ń goln ŋɛ, kí taa ŋɛ kí jo ŋa yíe nà bó.» ");
INSERT INTO gngNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","U len' nnɔ ŋɔ wɔ ń wuɔn, Piɛr lá li kpo mikuum mà ya bol kí kpiɛke Uwien nɛ. U len' nnɔ ki gben', nɛ ki tɔke' wɔ ki ye: «Paan nʼbo ní.» ");
INSERT INTO gngNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Piɛr jiɛbe', ki laa' *Yesu yíe upanpaankɛ wà ki gbien' nnɔ pɛ biʼbo. Upanpaankɛ nnɔ nɛ là gbìen' *Yesu bo, bi là jinh tijier uyo wà nnɔ, ki niire' wɔ ki ye: «Yonbdaan, ŋmɛ ye wɔ ń kuɔre ŋɛ?» ");
INSERT INTO gngNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Piɛr laa' wɔ ma nnɔ, nɛ ki niire' *Yesu ki ye: «Yonbdaan, bɛ lá li tu wuɔ mɔ?» ");
INSERT INTO gngNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Nɛ *Yesu jiin' wɔ ki ye: «N yíe wɔ ń li te kí tì baa uyo wà n li baa ní la, nì yé aʼgbɛr-ii? Sin, li pɛ nʼbo ní dee.» ");
INSERT INTO gngNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Li ya ñɔbonl bo nɛ *Yesu yaab ni bi lienh ki teh uʼpanpaankɛ nnɔ ŋa ń kpo. *Yesu wɔn ŋa tɔke' ki ye wa ń kpo. Ama u tɔke' wɔ ki ye: «N yíe wɔ li te kí tì baa uyo wà n li baa ní la, nì yé aʼgbɛr-ii» nɛ? ");
INSERT INTO gngNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Upanpaankɛ nnɔ nɛ tɔke' binib tigbɛr tuu, ki kɛle' tù kugbɔnku kuu ni. Nɛ ti bɛn ki ye uʼgbɛr nnɔ yé imɔ̀n nɛ. ");
INSERT INTO gngNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","*Yesu tien' tibont tù yɛbe. Bi bi ye bɛ ń kɛle tuʼkɛ jɛjɛ la, n maale' ki ye uŋɛndun wuu ya fɛnm ŋa ń baa bɛ ń ble bi li kɛle tigbɔnt tà nnɔ.");
INSERT INTO gngNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Nʼjɔ Teofil, nʼgbɔnkpiɛku ni, n tɔke' ŋɛ *Yesu cin' ki tien' nà nin u wɔkn' nà, ");
INSERT INTO gngNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ki tì baa' lidaali là Uwien taa' wɔ ki don' paaki bó nnɔ. Kí yaan Uwien ń taa wɔ kí dùo paaki bó nnɔ *Mifuoñaanm cère' u wɔkn' binib bà u gɛ̀nde' bɛ ki tien' uʼtondb nnɔ bi li kpe isɛn yà. ");
INSERT INTO gngNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","U kpo' ki mɛkre' bitɛnkpiib ni ma nnɔ, u cère' bɛn nɛ laa' wɔ mibolm mà yɛbe, ki tì baa' iwien pinan, ŋɔ wɔ ń wuɔn bɛ kí ye u mɔnbe ki fuobe. U cère' bi laa' wɔ, nɛ u tɔke' bɛ Uwien ya bɛl ya gbɛr. ");
INSERT INTO gngNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Lidaali liba wɔn nin bɛn jinh tijier, nɛ u tɔke' bɛ ki ye: «Ni la jɛnde Yerusalɛm ni, ama ní li te len, kí tì baa lidaali là nʼBaa Uwien li de nɛ u là pùon' ki ye u li de nɛ nà nnɔ. Ni cii' lipuonl nnɔ min saan nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ni là cii' n ye: San là taa' miñunm nɛ ki sìi' binib Uwien ya ñunm, ama ninbi wɔn, nì sìen' iwenkàankɛ nɛ, n li cère *Mifuoñaanm nɛ ń jiire ní niʼbo.» ");
INSERT INTO gngNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","*Yesu ya tondb taan' uʼsaan nɛ ki niire' wɔ ki ye: «Yonbdaan, nɛn mɛn la, fɛnfɛnnɔ nɛ a li fie tinbi Israyɛl yaab ya bɛl, kí jiin kí de tɛ-ɛɛ?» ");
INSERT INTO gngNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Nɛ *Yesu jiin' bɛ ki ye: «Lidaali là nin uyo wà tibont nnɔ li tien nnɔ ŋa yé niʼgbɛr, Baa Uwien nɛ sien' niʼkɛ u yíe ma bo. ");
INSERT INTO gngNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ama uyo wà *Mifuoñaanm li jiire ní niʼbo nnɔ, ni li lɛ mituɔm, kí li yé nʼmɔ̀nkunb Yerusalɛm ni nin Sude ya tinfɛnm kɛ ni nin Samari ya tinfɛnm kɛ ni nin utingbɛn kɛ bo.» ");
INSERT INTO gngNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","U len' nnɔ ma nnɔ nɛ Uwien cère' u doh paaki bó biʼnun ni. Nɛ kutɛwɔlgbɔnku kuba baa' ki lèkn' uʼbo, ba ji laa' wɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","U doh uyo wà nnɔ nɛ bi juore' ki se ki likeh paaki bó. Bi se ki likeh ma nnɔ nɛ ki laa' i ya tàan bo bijɛb bile se biʼsaan, ki guo tikpɛlcɛpient, ");
INSERT INTO gngNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ki niire' bɛ ki ye: «Galile yaabɛ, bɛ tien' ni se ki likeh paaki nɔ? Uwien nɛ ñɛn' *Yesu wuɔ niʼsaan ki don' paaki. U li baa ní tɛn ni laa' u doh ma bo nɔ nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Tɔ, *Yesu ya tondb siere' lijuɔl là bi yih lɛ̀ Olifi ya siin ya juɔl nnɔ bo ki liɛbe' Yerusalɛm ni. Lijuɔl nnɔ ŋa fɔke nin Yerusalɛm. Nì lii te kɔnsini uba nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Bi tì baa' Yerusalɛm ni ma nnɔ nɛ ki kɔn' bi tì ń taakeh ki te paaki ya duku kùa ni nnɔ. Piɛr nin San nin Saak nin Andre nin Filip nin Toma nin Batelemi nin Matie nin Alfe ya bijɛ Saak nin Simɔn wà ya nun mɔ́n uʼdu bo ya gbɛr nin Saak ya bijɛ Sudas nɛ kɔn' ki te kuduku nnɔ ni. ");
INSERT INTO gngNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Bipiib biba mɔ là te biʼni, bi ya uba si: *Yesu ya naa Mari nin *Yesu ya ninjiɛb. Biʼkɛ kpaan' buñɔbu, nɛ ki tuu ki taakeh ki kàareh. ");
INSERT INTO gngNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","I ya dɛn nɛ binib bà teke' *Yesu ki jin' nnɔ taan' litaanl. Bi là li baa binib kobk nin pile. Nɛ Piɛr fii' ki sere' biʼsiik ni, ki tɔke' bɛ ki ye: ");
INSERT INTO gngNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","«Nʼyaabɛ, nì kpɛ *Mifuoñaanm là cère' *Dafid len' Sudas ya gbɛr tà, bi kɛle' tù *Uwien ya gbɔnku ni nnɔ ń tien nɛ. Wɔn Sudas nɛ là le ki wɔngeh binib bà cuo' *Yesu nnɔ usɛn. ");
INSERT INTO gngNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Sudas là yé tinbi *Yesu ya tondb ya uba nɛ. *Yesu là gɛ̀nde' uʼmɔ ki de' wɔ ti sɔnh lituonl là nɔ nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Sudas tien' nibonn nà bre, nɛ bi pɛ̀n' wɔ ilike, u taa' ki dɛ' kitink kiba; nɛ ki lu' kiʼbo libenlibl uʼpuoku kpiɛre', nɛ uʼniɛr kɛ ñɛn'. ");
INSERT INTO gngNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","*Yerusalɛm ya nib kɛ cii' tigbɛr nnɔ. Nɛn bo nɛ bi yin' kitink nnɔ biʼlenm ni ki ye: «Akaldama» Niʼtingi si: Misɛ̀m ya tink.) ");
INSERT INTO gngNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Piɛr tí len' ki ye: «Nì kɛle' iyuon ya gbɔnku kùa te *Uwien ya gbɔnku ni nnɔ ni ki ye: ‹Uʼden ń tien kulɛngbonku, ŋɔ nil la ji ń li kɔ yì.› Nì tí kɛle' ki ye: ‹Unitɔ ń lère uʼlènl.› ");
INSERT INTO gngNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Binib te ki tɔke' nin tɛ uyo wà kɛ Yonbdaan *Yesu là te nin tɛ ti joh niʼkɛ saan nnɔ, ");
INSERT INTO gngNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","ki cin' uyo wà San là siih binib Uwien ya ñunm ki tì baa' lidaali là Uwien ñɛn' wɔ tiʼbùol ki cère' u don' paaki nnɔ. Nì kpɛ bɛn ya uba nɛ ń kpɔbn tiʼbó, kí li yé umɔ̀nkunl Yonbdaan ya mɛkrm bo.» ");
INSERT INTO gngNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Nɛn saan nɛ bi gɛ̀nde' bijɛb bile. Bi yih uba Yosɛf, ki baanh wɔ Basabas, ki liɛbe' ki baanh wɔ Yustus mɔ, ki yih utɔ Matiyas. ");
INSERT INTO gngNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Nɛ bi kàare' ki ye: «Yonbdaan, sin nɛ bɛn binib kɛ ya fɛ̀l ni te ma bo. Binib bile biɛ ni, wuɔn tɛ a gɛ̀nde' wà, ");
INSERT INTO gngNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ŋɔ wɔ ń lère Sudas ya lènl aʼtondb ya tuonl ni, kimɛ Sudas dàan' lɛ̀ nɛ ki jon' u kpɛ wɔn li te nà saan». ");
INSERT INTO gngNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Bi kàare' Yonbdaan ki gben', nɛ ki fùore' imúɔn bɛ ń liike bi li gɛ̀nde wà. Nɛn nɛ wuɔn' bɛ ki ye bi li gɛ̀nde Matiyas nɛ. Nɛ bi taa' wɔ ki kpɔbn' *Yesu ya tondb piik nin uba nnɔ bó. ");
INSERT INTO gngNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","*Pantekot ya nacenku ya daali, nɛ binib bà teke' *Yesu ki jin' nnɔ kɛ taan' ki te bùol liba. ");
INSERT INTO gngNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Nɛ bi cii' i ya tàan bo kuwaaku kuba ñɛn' ní kutaaku bó, ki naan tɛn kutafaabiiku, ki lá gbe kuduku kùa bi kɛ kuʼni nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Nɛn saan nɛ bi laa' nibonn niba baa' ki naan imupien, ki pàareh ki paakeh wà kɛ ya yul bo. ");
INSERT INTO gngNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Nɛ *Mifuoñaanm kɔn' biʼkɛ ki tì gben', ki cère' bi lienh ilenbol, mì yíe wà kɛ ń len ma bo. ");
INSERT INTO gngNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","U ya yo ki laa' *Sufmbɛ bà pɛ Uwien bo mɔnmɔnm nnɔ te Yerusalɛm ni nɛ. Bi ñɛn' idu yà kɛ te uŋɛndun ni nɛ ki baa'. ");
INSERT INTO gngNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Bi cii' binib bà teke' *Yesu ki jin' nnɔ ya waaku bó ma nnɔ nɛ ki taan' niʼsaan ki yɛbe. Bi cii' bi lienh ma nnɔ nɛ nì bɛke' bɛ ki gbien', kimɛ wà kɛ ciih bi lienh uʼtiɛma lenm nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Nì bɛke' bɛ ki gbien' ba ji bɛn bi li ye bà, ki ñuɔreh binib bà teke' *Yesu ki jin' nnɔ, nɛ ki ye: «O, binib bà lienh nɔ, biʼkɛ ŋa yé Galile yaab-ii? ");
INSERT INTO gngNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Nì tien' mila ŋɔ tiʼni wà kɛ ciih bi lienh uʼyaajɛlenm-i? ");
INSERT INTO gngNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Tiʼni biba ñɛn' Pat ya du bó ní nɛ, bitɔb ñɛn' Medi ya du bó ní, bitɔb mɔ ñɛn' Elam ya du bó ní, bitɔb mɔ ñɛn' Mesopotami bó ní, bitɔb mɔ yé Sude ya tinfɛnm yaab, bitɔb mɔ ñɛn' Kapadosi ya tinfɛnm bó ní, bitɔb mɔ ñɛn' Pɔnt ya tinfɛnm bó ní, bitɔb mɔ ñɛn' Asi ya tinfɛnm bó ní, ");
INSERT INTO gngNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","bitɔb mɔ ñɛn' Friji ya tinfɛnm bó ní, bitɔb mɔ ñɛn' Panfili bó ní, bitɔb mɔ ñɛn' Esipt bó ní, bitɔb mɔ ñɛn' Libi ya du wà bi yih wù Sirɛnn nnɔ ya tinfɛnm bó ní. Bitɔb mɔ ñɛn' Erom bó ní. ");
INSERT INTO gngNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Tiʼni, biba yé *Sufmbɛ nɛ, bitɔb mɔ yé Sufkpɛnkpɛnd. Bitɔb mɔ yé Krɛt yaab, bitɔb mɔ yé Arabi yaab. Tiʼkɛ ciih bi lienh tiʼlenm ni nɛ ki tɔkeh Uwien sɔn' itùonciɛn yà nnɔ.» ");
INSERT INTO gngNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Nì bɛke' bɛ ki gbien', ba ji bɛn bi li maale kí ye bà, nɛ ki niireh tɔb ki teh: «Niʼtingi si ba?» ");
INSERT INTO gngNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ama biba mɔ sukreh bɛ nɛ ki teh bi ñun' midaam nɛ ki yibe'. ");
INSERT INTO gngNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Nɛn saan nɛ Piɛr nin uʼtɔb piik nin uba nnɔ fii' ki sere', nɛ Piɛr len' ufaa bo, ki tɔke' linigol nnɔ ki ye: «Ninbi *Sufmbɛ nin ninbi bà kɛ te *Yerusalɛm ni nɔ, cenge mɛn nʼbó mɔnmɔnm, ń tɔke nɛ niʼtingi. ");
INSERT INTO gngNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ni maaleh ki teh binib biɛ ñun' midaam nɛ ki yibe'-ee? Ba ñun' daam, kimɛ nì laan te kutɛnŋaaku ya kur tuwɛ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ama *Uwien ya ñɔbonsɔknl Sowɛl là len' nà nnɔ nɛ teh. U là len' ki ye: ");
INSERT INTO gngNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‹Uwien ye: iwenfɔrkɛ yà we ní nɔ; n li cère nʼFuoñaanm ń baa binib kɛ bo, niʼbijiɛb nin niʼbisiɛb li sɔnkn nʼñɔbon, niʼnacenfɛ̀nb nin niʼjɛciɛn li lɛ tibont tidɛknt yaam. ");
INSERT INTO gngNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","U ya yo nɛ n lá li cère nʼFuoñaanm ń baa nʼtonsɔnb, bijɛb nin bipiib bo, bɛ ń tien nʼñɔbonsɔknb. ");
INSERT INTO gngNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","N li tien micincilnm kutaaku nin kitink bo, n li cère misɛ̀m nin umu nin kumuñiijuɔku ń li te, ");
INSERT INTO gngNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","uwien li bìike tɛn licinñunl, nɛ uŋmaal ń mɔ́nde tɛn misɛ̀m, kí yaan Yonbdaan ya daali ń baa ní, u li yé uwengbenge nɛ, ki li ŋmɔbe ukpiɛke. ");
INSERT INTO gngNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Nɛn daali wà kɛ li muɔ kí yin Yonbdaan ya yel nɛ li ŋmɛre.› » ");
INSERT INTO gngNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Piɛr tí len' ki pukn' ki ye: «Israyɛl yaabɛ, cenge mɛn nʼbó. Ninbi mɔnɔn bɛn ki ye Uwien cère' Nasarɛt ya *Yesu tien' miyɔkm ya bont nin tibont tà kɛ nisaal ŋa ń fre kí tien tù, ŋɔ wɔ ń wuɔn nɛ *Yesu yé udaan wà nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Bi taa' wɔ ki ŋukn' nɛ, nɛ ni cère' bà ŋa pɛ yiko bo kpɛ' wɔ udɔpɔnpɔn bo ki ku' wɔ. Uwien là bɛn nɛ ki sien' ki ye nɛ̀ ń tien nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ama Uwien mɛkre' wɔ ki ñɛn' wɔ mikuum ya jɛnd ni, kimɛ kuum ŋa ŋmɔbe tuɔm mɛ̀ ń juon wɔ kutɛnkpiiku ni. ");
INSERT INTO gngNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","*Dafid là len' uʼbo ki ye: ‹N tuu ki lɛnh Yonbdaan nʼnun bó nɛ. U te nʼnɔjie bó, ŋɔ niba la sɛ́n nʼfɛ̀l nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Nɛn bo nɛ n ŋmɔbe uyɛnsɔnge, ki lienh miyɛnsɔnglenm, n bɛn ki ye n li kpo, ama n ŋmɔbe lidɛndɛnl, ");
INSERT INTO gngNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","kimɛ ŋa ń cère ń juore kutɛnkpiiku ni, ka ń cère min aʼniñaan ń bùre. ");
INSERT INTO gngNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","A wuɔn' nni limiɛl ya sɛn. A te nʼsaan ma nnɔ, a li cère n li ŋmɔbe uyɛnsɔnge kí tì gben nɛ.› » ");
INSERT INTO gngNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Piɛr tí len' ki ye: «Nʼyaabɛ, nì kpɛ ń tùɔre kí tɔke nɛ tiʼyaajɛ *Dafid ya gbɛr nɛ. U là kpo', nɛ bi sube' wɔ. Uʼkul biɛ ki te tiʼdu ni haali nin dinnɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","U là yé *Uwien ya ñɔbonsɔknl nɛ, ki bɛn ki ye Uwien là pùon' ki pole' ki ye u lá li cère uʼyaabil liba ń kɛ̀le uʼbɛrbiɛk bo. ");
INSERT INTO gngNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Uwien là cère' *Dafid bɛnde' ki ye uʼNigɛndkɛ Kristo lá li mɛkre bitɛnkpiib ni. Nɛn bo nɛ *Dafid là len' uʼbo ki ye: ‹Uwien ŋa cère' u juore' kutɛnkpiiku ni, ka cère' uʼgbɛnɛnt bùre'.› ");
INSERT INTO gngNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","U ya *Yesu nɛ Uwien mɛkre' wɔ bitɛnkpiib ni, nɛ tiʼkɛ yé bimɔ̀nkunb. ");
INSERT INTO gngNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","UʼBaa Uwien kpiɛke' wɔ, ki taa' wɔ ki kàan' uʼjie bó, ki de' wɔ u là pùon' ki ye u li de wɔ Mifuoñaanm mà nnɔ, nɛ u cère' mì baa' tiʼbo. Ni ciih nà, ki likeh nɛ̀ nɔ, nì yé *Mifuoñaanm ya tuonl nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Ti bɛn ki ye *Dafid ŋa là don' paaki, ama wɔn bugbɛn là len' ki ye: ‹Yonbdaan Uwien tɔke' nʼYonbdaan ki ye: Kɛ̀le nʼnɔjie bó, ");
INSERT INTO gngNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","kí tì baa uyo wà n li cère á tɛ aʼnɛnnɛndb bo litaal.› » ");
INSERT INTO gngNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Nɛ Piɛr tí len' ki ye: «Israyɛl yaabɛ, niʼkɛ ń mɔnbe kí bɛnde kí ye ninbi kpɛ' *Yesu wà udɔpɔnpɔn bo nnɔ, Uwien tien' wɔn nɛ Yonbdaan, ki tien' wɔ Kristo uʼNigɛndkɛ.» ");
INSERT INTO gngNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Linigol nnɔ cii' Piɛr len' nnɔ ma nnɔ nɛ nì jin' bɛ, ki saa' biʼyɛnm ki gbien', nɛ bi niire' Piɛr nin *Yesu ya tondtɔb ki ye: «Tiʼyaabɛ, ti nín li tien mila?» ");
INSERT INTO gngNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Nɛ Piɛr jiin' bɛ ki ye: «Lèbre mɛn niʼtetem, kí cère tí sìi niʼni wà kɛ Uwien ya ñunm *Yesu Kristo ya yel bo, ŋɔ Uwien ń fère nɛ niʼbiɛre, kí pu nɛ *Mifuoñaanm, ");
INSERT INTO gngNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","kimɛ tiʼYonbdaan Uwien là pùon' lipuonl ki ye u li taa *Mifuoñaanm kí de u yin' binib bà kɛ nnɔ. Bɛn si: ninbi nin niʼbumu nin bà kɛ te fɔkm nnɔ.» ");
INSERT INTO gngNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Piɛr taah iñɔbontɔ ì yɛbe ki sureh bɛ, ki saakreh biʼgbɛnɛnt ki teh: «Wiɛ mɛn fɛnfɛnnɔ ya nib bà yé bibiɛrdɛnb nnɔ ya gbɛr ŋɔ Uwien ń ŋmiɛn nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Nɛ bi sìi' binib bà tuo' uʼgbɛr nnɔ Uwien ya ñunm. Niʼdaali binib bà pukn' bà teke' *Yesu ki jin' bó nnɔ li baa tɛn itur ita. ");
INSERT INTO gngNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Bi tuu ki cengeh *Yesu ya tondb ya wɔknm nin inunmɔ́n nɛ, ki te tɛn bi tɛ naa nin baa, ki taakeh ki jinh tijier, ki taakeh ki kàareh. ");
INSERT INTO gngNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Tɔ, Uwien cère' *Yesu ya tondb teh miyɔkm ya bont cɛɛn. Nɛn bo nɛ binib kɛ fɛnge Uwien. ");
INSERT INTO gngNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Binib bà kɛ teke' *Yesu ki jin' nnɔ kpɛ buñɔbu nɛ, ki taah biʼbont kɛ ki gbiinh tɔb. ");
INSERT INTO gngNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Bi kuɔreh biʼtinmu nin bi ŋmɔbe tibont tà, nɛ ki taah ilike ki gbiinh tɔb, nì wiɛbe bɛ ma bo. ");
INSERT INTO gngNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Idaan kɛ bi là kpɛ buñɔbu nɛ, ki tuu ki taakeh Uwien ya duku ya luo bo, ki taakeh tɔb den ki jinh tijier, ki ŋmɔbe uyɛnŋmaa nin lifɛ̀sɔngl, ");
INSERT INTO gngNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","ki pɛ̀keh Uwien, nɛ biʼdu ya nib kɛ yíe biʼgbɛr. Nɛ idaan kɛ Yonbdaan ŋmiɛndeh binib ki pukndeh biʼbó. ");
INSERT INTO gngNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Lidaali liba nɛ Piɛr nin San joh Uwien ya duku bó tikur tuta ya kaare ya yo. ");
INSERT INTO gngNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Tɔ, ujɛ uba là te bi maa' wɔ uwɔb. Idaan kɛ bi yuunh wɔ ki lá kaandeh Uwien ya duku ya nañɔbu bùa bi yih bù Bunañɔmɔnmɔnbu nnɔ saan, wɔ ń li miɛh binib bà kɔh Uwien ya duku ya luo bo nnɔ nɛ tibont. ");
INSERT INTO gngNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","U laa' Piɛr nin San tuo bɛ ń kɔ Uwien ya duku ya luo bo, nɛ u miɛ' bɛ nibonn. ");
INSERT INTO gngNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Piɛr nin San caan' uʼbo inun, nɛ Piɛr tɔke' wɔ ki ye: «Liike tɛ.» ");
INSERT INTO gngNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Nɛ u tùɔre' ki likeh bɛ, ki daan u li lɛ biʼsaan nibonn nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Nɛ Piɛr tɔke' wɔ ki ye: «Ma ŋmɔbe like, ka ŋmɔbe ñɔ̀km. Ama n li de ŋɛ n ŋmɔbe nà nɛ. *Yesu Kristo wà yé Nasarɛt ya nil nnɔ ya yel bo, fii kí cuon!» ");
INSERT INTO gngNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Nɛ ki cuo' uʼnɔjie, ki fin' wɔ. Nɛ uʼtàan nin uʼtɛgbiɛmu pɔk ki faake' i ya tàan bo. ");
INSERT INTO gngNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","U maabe' ki ci', ki sere', ki cin' ki cuonh, nɛ ki paan' biʼbo ki kɔn' Uwien ya duku ya luo bo, ki cuonh, ki mɛbreh, ki pɛ̀keh Uwien. ");
INSERT INTO gngNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Linigol kɛ laa' u cuonh ki pɛ̀keh Uwien. ");
INSERT INTO gngNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Bi bɛnde' ki ye wɔn nɛ tì ń kɛ Uwien ya duku ya Nañɔmɔnmɔnbu saan ki miɛh nnɔ. Bi laa' u faake' ma nnɔ nɛ nì cuo' bɛ miyɔkm nin bujɛwaanbu. ");
INSERT INTO gngNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ujɛ nnɔ ŋa dàan' Piɛr nin San. Nì cuo' binib nnɔ kɛ miyɔkm nɛ bi sɛn' ki baa' biʼsaan kuninbonku kuba ni, bi yih kù «Salomɔn ya ninbonku.» ");
INSERT INTO gngNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Tɔ, Piɛr laa' binib nnɔ ma nnɔ, nɛ ki niire' bɛ ki ye: «Israyɛl yaabɛ, bɛ tien' nì cuo' nɛ miyɔkm-i? Bɛ tien' ni likeh tɛ tɛn tiʼtiɛma tuɔm nin ti pɛ Uwien bo mɔnmɔnm ma nnɔ nɛ cère' ujɛ wuɔ faake'? ");
INSERT INTO gngNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Uwien wà *Abraham nin *Isaak nin Sakɔb nin tiʼyaajɛb là pukeh wɔ nnɔ nɛ kpiɛke' uʼtonsɔnl *Yesu wà ninbi kuɔre' wɔ ki yìe' wɔ Pilat ya nun bó nnɔ. Pilat wɔn là yíe wɔ ń taa wɔ kí wiɛ nɛ, nɛ na tuo'. ");
INSERT INTO gngNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ninbi, yìe' wà yé uñaan, ki yé ugbɛmɔ̀ndaan, nɛ ki ji tɔke' Pilat ki ye wɔ ń taa unikul kí wiɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ni ku' wà yé limiɛl ya daan, nɛ Uwien mɛkre' wɔ bitɛnkpiib ni. Tinbi nɛ yé bimɔ̀nkunb. ");
INSERT INTO gngNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ti du uʼyel bo ma nnɔ nɛ liyel bugbɛn ya tuɔm cère' ujɛ wà ni likeh wɔ ki bɛn wɔ nɔ faake'. Ti teke' *Yesu ki jin' ma nnɔ nɛ cère' ujɛ wuɔ laa' laanfiɛ ki tì gben' ki se niʼkɛ ya nun bó nɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","«Nʼyaabɛ, n bɛn ki ye ninbi nin niʼciɛnb ku' *Yesu ma nnɔ, na bɛn nɛ ki sɔn' li ya tuonl. ");
INSERT INTO gngNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Uwien là cère' uʼñɔbonsɔknb kɛ len' uyo bo ki ye uʼNigɛndkɛ Kristo lá li jɛ̀nde nɛ. Nɛn nɛ tien'. ");
INSERT INTO gngNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Nɛn bo, lèbre mɛn niʼtetem, kí liɛbe kí paan Uwien bo ŋɔ wɔ ń fère nɛ niʼbiɛre. ");
INSERT INTO gngNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Nnɔ nɛ Yonbdaan li de nɛ lifuorl, ki li sɔn ní uʼNigɛndkɛ Kristo niʼsaan. Wɔn si *Yesu; u là gɛ̀nde' wɔ ninbi bo nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Nì kpɛ wɔn *Yesu ń li te paaki bó nɛ, kí tì baa uyo wà Uwien li fɛ̀nde tibont kɛ. Nì te tɛn u là cère' uʼñɔbonsɔknb len' nà kɛ uyo bo nnɔ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moyis wɔn là len' ki ye: ‹Yonbdaan Uwien li cère niʼni uba ń ñɛ uñɔbonsɔknl niʼbo tɛn min. Ní cenge u li tɔke nɛ nà kɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Unil wà kɛ ŋa tuo' uñɔbonsɔknl nnɔ ya ñɔbu bó la, Uwien li ñɛn wɔ uʼnib ni nɛ ki gben' uʼgbɛr.› ");
INSERT INTO gngNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","*Uwien ya ñɔbonsɔknb kɛ, ki cin' Samiɛl nin biñɔbonsɔkntɔb bà paan' uʼbo nnɔ mɔ là len' nà teh idɛn yiɛ nɔ ya gbɛr. ");
INSERT INTO gngNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ninbi nɛ yé Uwien ya ñɔbonsɔknb nnɔ ya yaabii, nɛ ki li jonde kujɔtieku kùa u là cuo' kù nin niʼyaajɛb nnɔ bo. U là tɔke' niʼyaajɛ *Abraham ki ye u li tien inibol yà kɛ te utingbɛn bo nnɔ uʼmɔnm u ya yaabii bo nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Mikpiɛkm, ninbi bo nɛ Uwien là gɛ̀nde' uʼtonsɔnl Yesu, ki sɔn' wɔ niʼsaan wɔ ń lá tien nɛ Uwien ya mɔnm, kí ñɛn niʼni wà kɛ uʼtùonbiɛrɛ ni.» ");
INSERT INTO gngNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Piɛr nin San laan biɛ ki lienh nin linigol nnɔ; u ya yo nɛ bitɔtuɔrkaab nin Uwien ya duguurb ya ciɛn nin Saduseyɛnmbɛ baa' biʼsaan. ");
INSERT INTO gngNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Biʼbenku ni ben' Piɛr nin San bo, kimɛ bi wɔknh binib ki teh *Yesu mɛkre' bitɛnkpiib ni ma nnɔ, binib bà kpo' mɔ li mɛkre nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Bi cuo' bɛ ki laa' uwien lu' ŋɔ, nɛ bi taa' bɛ ki tì pɛkn' ki cère' bi te len nì tì faa'. ");
INSERT INTO gngNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Nin nɛn kɛ, binib bà cii' Piɛr nin San len' nà nnɔ, biʼni bà yɛbe teke' *Yesu ki jin'. Bijɛb bà teke' wɔ ki jin' nnɔ li baa tɛn itur iŋun. ");
INSERT INTO gngNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Kutaaku faa', nɛ bitɔtuɔrciɛnb nin *Sufmbɛ ya ciɛnb nin *Yiko ya wɔnwɔknb taan' Yerusalɛm ni. ");
INSERT INTO gngNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Bà là taan' nnɔ ya biba si: bitɔtuɔrciɛnb ya ciɛn Anni nin Kayif nin San nin Alɛksand nin bitɔtuɔrciɛnb ya cɛkl ya nitɔb kɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Bi cère' Piɛr nin San sere' biʼsiik ni nɛ bi niire' bɛ ki ye: «Ni taa' ba ya tuɔm nɛ bii ni taa' ŋmɛ ya yel nɛ ki buu' uwɔb wuɔ nɔ?» ");
INSERT INTO gngNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Nɛn saan nɛ *Mifuoñaanm cère' Piɛr tɔke' bɛ ki ye: «Bitɔtuɔrciɛnb nin *Sufmbɛ ya ciɛnbɛ, ");
INSERT INTO gngNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ti tore' uwɔb nnɔ ma nnɔ, nɛ ni buh tɛ tibuur dinnɔ, ki niireh tɛ ki teh ti tien' mila ki buu' wɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Tɔ, ninbi nin Israyɛl ya nitɔb kɛ ń bɛnde kí ye Nasarɛt ya *Yesu Kristo wà ninbi kpɛ' wɔ udɔpɔnpɔn bo nnɔ, Uwien mɛkre' wɔ bitɛnkpiib ni. U ya yel ya tuɔm nɛ cère' ujɛ wuɔ faake' ki se niʼnun bó nɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","*Yesu bo nɛ nì kɛle' *Uwien ya gbɔnku ni ki ye: ‹Litɛnl là ninbi bidumɛb wiɛ' lɛ̀ nnɔ, lɛn nɛ lá tien' litɛnkpiɛkl là co kuduku.› ");
INSERT INTO gngNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Miŋmiɛnm ŋa ń ñɛ uba saan ki kɛnde' *Yesu saan, kimɛ *Yesu ya yel baba ŋa ñí la, Uwien ŋa de' nil uba liyel uŋɛndun wuu ni ŋɔ lɛn bo tí fre kí ŋmɛre.» ");
INSERT INTO gngNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Bi sekn' ki laa' Piɛr nin San ŋa yé nikpɛkpiɛkb udu ni, ka bɛn gbɔnku ki gbien', ki ŋmɔbe lifɛ̀l ki lienh ma nnɔ, nɛ nì cuo' bɛ miyɔkm. Nɛ bi bɛnde' ki ye bɛn nin *Yesu nɛ là te. ");
INSERT INTO gngNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Tɔ, bi laa' ujɛ wà faake' nnɔ se Piɛr nin San saan ma nnɔ nɛ ba ji bɛn bi li ye bà. ");
INSERT INTO gngNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Bi cère' bi ñɛn' Piɛr nin San tibuur ya duku nnɔ ni, nɛ bi cin' ki gbiereh ");
INSERT INTO gngNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","ki teh: «Ti li tien mila binib biɛ nɔ? Binib bà kɛ te Yerusalɛm ni bɛn ki ye bi mɔnbe ki tien' miyɔkm ya bonn nɛ, ta ń fre kí niɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ama ta yíe tigbɛr nnɔ ń yɛbre udu ni niʼkɛ saan. Nɛn bo, cère mɛn tí mɔ́nde biʼbo inun kí wɔbn bɛ, bi la ji ń tɔke nil *Yesu ya gbɛr.» ");
INSERT INTO gngNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Nɛ bi liɛbe' ki yin' bɛ ki kuɔn', ki pien' bɛ ki ye bi la ji ń wɔkn nil *Yesu ya gbɛr, ki la ji ń tɛ uʼyel mɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ama Piɛr nin San tɔke' bɛ ki ye: «Nì kpɛ tí tuo ni ya ñɔbu bó bii Uwien ya ñɔbu bó nɛ? Ninbi mɔnɔn maale mɛn kí liike. Ni lɛ ba mɔn Uwien saan ní-i? ");
INSERT INTO gngNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Tinbi ŋa ń fre kí li ŋmin kí la tɔke ti laa' nà nin ti cii' nà.» ");
INSERT INTO gngNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Biciɛnb nnɔ tí mɔ́nde' biʼbo inun nɛ ki taa' bɛ ki wiɛ'. Ba laa' bi li dule nà bo kí dɛre biʼtub, kimɛ udu ya nib kɛ pɛ̀keh Uwien miyɔkm ya bonn nnɔ bo nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Piɛr nin San tien' miyɔkm ya bonn, ki cère' ujɛ wà faake' nnɔ ya bin gɛ̀bre' ibin pinan. ");
INSERT INTO gngNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Tɔ, bi taa' Piɛr nin San ki wiɛ' ma nnɔ nɛ bi liɛbe' ki jon' biʼtɔb saan, ki tì tɔke' bɛ bitɔtuɔrciɛnb nin *Sufmbɛ ya ciɛnb nnɔ tɔke' bɛ nà nnɔ kɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Bi cii' ma nnɔ nɛ biʼkɛ kpaan' buñɔbu, ki kàareh Uwien ki teh: «Yonbdaan, sin nɛ ñɛn' kutaaku nin kitink nin miñunciɛnm, ki ñɛn' tibont tà kɛ te kutaaku bo nin tà kɛ te kitink bo nin tà kɛ te miñunciɛnm ni. ");
INSERT INTO gngNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Sin nɛ là cère' Mifuoñaanm ya tuɔm bo, aʼtonsɔnl tiʼyaajɛ *Dafid len' ki ye: ‹Bɛ bo nɛ bà ŋa yé *Sufmbɛ ya benku ni ben' ki tì kɛnde'? Bɛ bo nɛ idu ya nib maaleh yɛnmaalfɛnm-i? ");
INSERT INTO gngNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Uŋɛndun ya bɛrciɛnb bonde' biʼba, nɛ idu ya bɛrb taan' biʼtɔb saan, bɛ ń kɔn nin Yonbdaan nin uʼNigɛndkɛ Kristo tijɛr.› ");
INSERT INTO gngNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Imɔ̀n nɛ, ubɛr Herod nin Pɔns Pilat nin bà ŋa yé Israyɛl yaab nin Israyɛl yaab là taan' udu wuu ni, ki ku' *Yesu wà yé aʼtonsɔnñaan ki yé aʼNigɛndkɛ nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Bi taan' ki tien' aʼtuɔm nin aʼyíem bo, a là sien' ki ye nà ń tien nnɔ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Yonbdaan, fɛnfɛnnɔ gbìen kí liike bi wɔbndeh tɛ liwɔbl là ba, kí de tinbi aʼtonsɔnb lifɛ̀l ŋɔ tí li tɔkeh binib aʼgbɛr ki la fɛnge. ");
INSERT INTO gngNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Wuɔn aʼtuɔm kí cère biwiɛnb ń faake, miyɔkm ya bont ń li teh, aʼtonsɔnñaan *Yesu ya yel bo.» ");
INSERT INTO gngNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Bi kàare' ki gben' ma nnɔ nɛ bi taan' ki te nà saan nnɔ jènge'. *Mifuoñaanm baa' biʼkɛ bo, nɛ bi laa' lifɛ̀l ki tɔkeh binib Uwien ya gbɛr. ");
INSERT INTO gngNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Linigol là teke' *Yesu ki jin' nnɔ kpɛ buñɔbu nɛ, ki ŋmɔbe iyɛnmaale iba. Uba ŋa lienh ki teh uʼbonn yé uʼbaba yaann. Biʼkɛ là taakeh biʼbont nɛ ki gbiinh. ");
INSERT INTO gngNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","*Yesu ya tondb ŋmɔbe mitɔciɛnm ki kundeh imɔ̀n ki teh Yonbdaan *Yesu mɔnbe ki mɛkre' bitɛnkpiib ni. Nɛ Uwien juokeh biʼkɛ ki gbiekeh. ");
INSERT INTO gngNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Biʼni uba ŋa te ki luo' niba, kimɛ bà kɛ ŋmɔbe mutinmu bii iden nnɔ kuɔreh nɛ ki taah bi kuɔreh ki lɛnh ilike yà nnɔ, ");
INSERT INTO gngNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ki lá dienh *Yesu ya tondb, nɛ bi gbiinh, ki dienh unil kɛ nì wiɛbe wɔ ma bo. ");
INSERT INTO gngNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ujɛ uba te biʼni, bi yih wɔ Yosɛf. Nɛ *Yesu ya tondb baanh wɔ Banabas, niʼtingi si: «wà sɔngreh binib ya yɛnm.» U yé Lefi ya yaabil nɛ. Bi maa' wɔ Ciip ya du ni nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","U ŋmɔbe bukpàabu buba, ki kuɔre' bù, nɛ ki taa' u kuɔre' ki laa' ilike yà nnɔ, ki lá de' *Yesu ya tondb. ");
INSERT INTO gngNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Tɔ, ujɛtɔ mɔ là te biʼni, bi yih wɔ Ananiyas, ki yih uʼpo Safira. U kuɔre' uʼkpàabu buba, ki teke' ilike. ");
INSERT INTO gngNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Wɔn nin uʼpo kpaan' buñɔbu nɛ u bore' ilike nnɔ ya niba bó ki taa' uʼba, ki tuke' nà bó sìen' nnɔ ki lá de' *Yesu ya tondb. ");
INSERT INTO gngNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Nɛ Piɛr niire' wɔ ki ye: «Ananiyas, bɛ tien' a taa' aʼfɛ̀l ki cɛ̀be' *Satan nɔ nnɔ, ki lɛre' *Mifuoñaanm, ki bore' bukpàabu nnɔ ya like ya niba bó ki taa' aʼba! ");
INSERT INTO gngNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ŋa laan là kuɔre' bukpàabu nnɔ ma nnɔ, bù là yé aʼyaabu nɛ. A kuɔre' bù ma nɔ, ilike nnɔ mɔ yé aʼyi nɛ. Bɛ tien' a maale' aʼfɛ̀l ni á tien nɔ? A lɛre' Uwien nɛ, ŋa lɛre' nib.» ");
INSERT INTO gngNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananiyas cii' iñɔbon nnɔ ma nnɔ, nɛ ki lu' ki kpo'. Nɛ bujɛwaanciɛnbu cuo' binib bà kɛ cii' tigbɛr nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Nɛn saan nɛ binacenfɛ̀nb baa' ki taa' bukpɛlbu, ki pɔbn' wɔ, ki yuure' ki ñɛn' ki tì sube'. ");
INSERT INTO gngNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Nì tien' tɛn tikur tuta, nɛ uʼpo kɔn' ní, ka bɛn nà tien'. ");
INSERT INTO gngNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Nɛ Piɛr niire' wɔ ki ye: «Tɔke nni tigbɛmɔ̀nt, ni kuɔre' bukpàabu bùa nnɔ ya like kɛkɛ sɔ-ɔɔ?» Nɛ u ye: «Hnn, iʼkɛkɛ nínɔ.» ");
INSERT INTO gngNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Nɛ Piɛr tɔke' wɔ ki ye: «Bɛ tien' sin nin aʼcɛ kɛ kpaan' buñɔbu ki biike' *Yonbdaan ya Fuoñaanm-i? Liike, bà sube' aʼcɛ nnɔ nɛ tuo bunañɔbu nɔ. Bi li yuure aʼmɔ, kí ñɛn.» ");
INSERT INTO gngNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Nɛ uʼmɔ lu' uʼnun bó i ya tàan bo ki kpo'. Binacenfɛ̀nb nnɔ kɔn' ní ki laa' u kpo', nɛ bi tí yuure' uʼmɔ, ki tì sube' uʼcɛ saan. ");
INSERT INTO gngNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Bujɛwaanciɛnbu cuo' Kristo ya taanl yaab kɛ nin binib bà kɛ cii' tigbɛr nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","*Yesu ya tondb teh miyɔkm ya bont udu ya nib ni cɛɛn. Binib bà teke' *Yesu ki jin' nnɔ kɛ kpɛ buñɔbu nɛ, ki taan' ki te Salomɔn ya ninbonku ni. ");
INSERT INTO gngNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Nitɔb ŋa kaabe' ki taakeh nin bɛ, ama udu ya nib kɛ là pɛ̀keh bɛ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Nɛ binib ligol, bijɛb nin bipiib kɛ teknh Yonbdaan ki jinh uyo kɛ ki pukndeh biʼbó. ");
INSERT INTO gngNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","*Yesu ya tondb teh miyɔkm ya bont ma nnɔ, nɛ binib yuunh biwiɛnb ki là blinh tikaagbɔnt nin igado bo isɛngbɛ, ŋɔ Piɛr lá gɛ̀breh, uʼjinjinku mɔnɔn lu' biʼbo la, bɛ ń faake. ");
INSERT INTO gngNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Linigol mɔ tukeh biwiɛnb nin binib bà isɛnpol ŋaake bɛ nnɔ, ki ñɛh ní idu yà nɛke Yerusalɛm nnɔ ni, ki bàareh *Yesu ya tondb saan nɛ bi cèreh biʼkɛ faakreh. ");
INSERT INTO gngNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Tɔ, bitɔtuɔrciɛnb ya ciɛn nin binib bà kɛ pɛ uʼbo ki yé Saduseyɛnmbɛ nnɔ laa' *Yesu ya tondb teh nnɔ ma nnɔ, nɛ bi taa' biʼbo iponponbe, ki jon' ");
INSERT INTO gngNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","ki cuo' bɛ, ki tì pɛkn' udu nnɔ ya pɛkl ni. ");
INSERT INTO gngNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ama niʼdaali ya ñɔnku, nɛ Yonbdaan Uwien ya tond baa' ki lá pìire' lipɛkl ya nagɛnku, ki ñɛn' bɛ, nɛ ki tɔke' bɛ ki ye: ");
INSERT INTO gngNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","«Li joh mɛn Uwien ya duku ya luo bo, kí tì ń li tɔkeh binib mifuobfɛ̀nm miɛ ya gbɛr kɛ.» ");
INSERT INTO gngNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Bi tuo' uʼñɔbu bó, nɛ kutɛnŋɛsɔnsɔnku bi kɔn' Uwien ya duku ya luo bo, ki wɔknh binib Uwien ya gbɛr. Bitɔtuɔrciɛnb ya ciɛn nin binib bà pɛ uʼbo nnɔ baa' ki lá yin' *Sufmbɛ ya buur ya cɛkl yaab bà bi liɛbe' ki yih bɛ Israyɛl ya ciɛnb nnɔ kɛ ki taan', nɛ ki sɔn' biguguurb bɛ ń jo lipɛkl bó kí tì taa *Yesu ya tondb ní. ");
INSERT INTO gngNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Bi tì baa' niʼsaan ka laa' bɛ, nɛ ki liɛbe' ní ki lá tɔke' ki ye: ");
INSERT INTO gngNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","«Ti tì baa' ki laa' lipɛkl ya duku pi mɔnmɔnm nɛ, biguguurb mɔ se kunagɛnku saan ki gu. Nin nɛn kɛ ti pìire' ma, ta laa' nil uba mɔnɔn len.» ");
INSERT INTO gngNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Uwien ya duku ya guguurb ya ciɛn nin bitɔtuɔrciɛnb cii' tigbɛr nnɔ ma nnɔ, nɛ nì bɛke' bɛ *Yesu ya tondb bo cɛɛn, kimɛ ba bɛn nì tien' ma ");
INSERT INTO gngNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Nɛn saan nɛ unil uba baa', ki tɔke' bɛ ki ye: «Liike mɛn-a! Bijɛb bà ni pɛkn' bɛ nnɔ, bi te Uwien ya duku ya luo bo ki wɔknh binib Uwien ya gbɛr.» ");
INSERT INTO gngNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Nɛn saan nɛ Uwien ya duku ya guguurb ya ciɛn nin uʼnib bure' bɛ ń tì cuo *Yesu ya tondb ní. Ba cuo' bɛ nin ufaa, bi tuke' bɛ ní suoo nɛ, kimɛ bi fɛnge udu ya nib la yèke bɛ tɛn nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Bi tuke' bɛ ki tì baa', nɛ ki cère' bi sere' *Sufmbɛ ya buur ya cɛkl yaab ya nun bó, nɛ bitɔtuɔrciɛnb ya ciɛn tɔke' bɛ ki ye: ");
INSERT INTO gngNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","«Ta là wɔbn' ki pien' nɛ ki ye ni la ji ń wɔkn nil *Yesu ya gbɛr-ii? Nɛ ni cère' niʼwɔknm gbe Yerusalɛm ni niʼkɛ saan-a! Ni yíe ní ye ujɛ bugbɛn ya kuum ñɛn' tinbi nɛ-a!» ");
INSERT INTO gngNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Nɛ Piɛr nin *Yesu ya tondtɔb tɔke' bɛ ki ye: «Nì kpɛ tí tuo Uwien ya ñɔbu bó ki cɛn' nin tí tuo binib ya ñɔbu bó. ");
INSERT INTO gngNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ninbi nɛ kpɛ' *Yesu udɔpɔnpɔn bo, ki ku' wɔ, nɛ tiʼyaajɛb ya Wien mɛkre' wɔ bitɛnkpiib ni, ");
INSERT INTO gngNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","ki kpiɛke' wɔ, ki taa' wɔ ki kàan' uʼjie bó, wɔ ń li yé ubɛr, kí li yé Uŋmiɛnl, kí cère Israyɛl yaab ń lèbre biʼtetem ŋɔ Uwien ń fère bɛ biʼbiɛre. ");
INSERT INTO gngNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Tinbi nɛ yé tigbɛr nnɔ ya mɔ̀nkunb, nɛ Uwien taa' *Mifuoñaanm mà ki de' binib bà boh wɔ nnɔ mɔ yé tuʼmɔ̀nkunl.» ");
INSERT INTO gngNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","*Sufmbɛ ya buur ya cɛkl yaab cii' bi len' nnɔ ma nnɔ, nɛ biʼbenku ni ben' biʼbo ki tì kɛnde', nɛ bi yíe bɛ ń ku bɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Tibuur yaab nnɔ ya uba fii' ki sere' biʼnun bó, bi yih wɔ Gamaliɛl. U yé *Farisiɛnmbɛ ya uba nɛ, ki yé *Yiko ya wɔnwɔknl mɔ, ki ŋmɔbe liyel *Sufmbɛ kɛ saan. U tɔke' bɛ ki ye bɛ ń taa *Yesu ya tondb nnɔ kí ñɛ saali waamu. ");
INSERT INTO gngNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Bi ñɛn' saali, nɛ u tɔke' tibuur ya cɛkl yaab nnɔ ki ye: «Israyɛl yaabɛ, liike mɛn niʼyul bo nin ni yíe ní tien bijɛb biɛ nà nɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Kimɛ ujɛ uba nɛ là te nà laan wuɔke', bi yih wɔ Teyuda. U là yih uʼba unikpɛkpiɛk nɛ, nɛ bijɛb kobiinan pɛ uʼbo. Bi ku' wɔ nɛ binib bà kɛ pɛ uʼbo nnɔ yɛre', nɛ licɛkl nnɔ juore' fɛnm. ");
INSERT INTO gngNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ujɛ nnɔ yaam gɛ̀bre', nɛ Galile ya nil uba mɔ fii' ki sure' binib bi paan' uʼbo ki yɛbe, bi yih wɔ Sudas. Nì là yé uyo wà bi kàanh kukɛ̀nku nnɔ nɛ. Bi ku' uʼmɔ, nɛ binib bà kɛ pɛ uʼmɔ bo nnɔ, mɔ yɛre'. ");
INSERT INTO gngNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Nɛn bo nɛ n tɔkeh nɛ, ji la tuuke mɛn bijɛb biɛ ya gbɛr. Cère bɛ mɛn bɛ ń li joh. Bi lienh nà nɔ nin bi sɔnh lituonl là nɔ yé unisaal yaam nɛ la, nì li juore fɛnm nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ama nì yé Uwien yaam nɛ la, na ń fre kí pien bɛ. Ni kɔnh nin bɛ tijɛr la, nba la, ni lá li lɛ ni kɔnh nin Uwien nɛ.» Gamaliɛl len' nnɔ ma nnɔ, nɛ bi tuo'. ");
INSERT INTO gngNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Bi yin' *Yesu ya tondb, bi liɛbe' ki kɔn' ní, nɛ bi ñi' bɛ, ki pien' bɛ ki ye bi la ji ń li tɔkeh nil *Yesu ya gbɛr, nɛ ki taa' bɛ ki wiɛ'. ");
INSERT INTO gngNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","*Yesu ya tondb siere' biʼsaan nin uyɛnsɔnge, kimɛ bi bɛn nì kpɛ bɛ ń ji ifɛ *Yesu ya yel bo nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Idaan kɛ, bi tuu ki joh Uwien ya duku ya luo bo nin binib den nɛ, ki tì wɔknh binib, ki tɔkeh tigbɛmɔnmɔnt ki teh *Yesu nɛ yé Uwien ya Nigɛndkɛ Kristo. ");
INSERT INTO gngNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Idɛn yà binib bà teke' *Yesu ki jin' ya cɛkl yɛbreh ki pukndeh nnɔ, nɛ *Sufmbɛ bà teke' *Yesu ki jin' ki lienh Grɛkmbɛ ya lenm nnɔ cin' ki kɔnh nin Suftɔb bà lienh biʼyaajɛlenm nnɔ ki teh daan kɛ daan bi gbiinh tibont la, bi sundeh bi ya kpopiib bó nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Nɛ *Yesu ya tondb piik nin bile nnɔ yin' binib bà kɛ teke' *Yesu ki jin' nnɔ ki taan', nɛ ki tɔke' bɛ ki ye: «Na mɔn tí juore tijier ya gbiirm bo kí dàan Uwien ya gbɛr ya tɔkm. ");
INSERT INTO gngNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Nɛn bo, tiʼyaabɛ, gɛ̀nde mɛn niʼni jɛb bilole bà *Uwien ya Fuoñaanm te biʼbo, bi ŋmɔbe miyɛnfuom, ki yé binimɔ̀nb binib ya nun bó, ŋɔ tí cère bɛ ń li sɔnh li ya tuonl. ");
INSERT INTO gngNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Tinbi *Yesu ya tondb wɔn, tí li mɔ̀ndeh ki kàareh nɛ, kí li tɔkeh binib Uwien ya gbɛr.» ");
INSERT INTO gngNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","*Yesu ya tondb len' nà nnɔ ŋmaake' binib nnɔ kɛ, nɛ bi gɛ̀nde' Etiɛnn, u teke' *Yesu ki jin' mɔnmɔnm, *Mifuoñaanm te uʼbo. Bi gɛ̀nde' Filip nin Prokɔr nin Nikanɔr nin Timɔn nin Pamena nin Antiyɔk ya Nikola, u yé Sufkpɛnkpɛnd. ");
INSERT INTO gngNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Bi taa' jɛb bilole nnɔ ki wuɔn' *Yesu ya tondb, bi taa' biʼnuɔ ki paan' biʼbo nɛ ki kàare' ki de' bɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Uwien ya gbɛr yɛreh niʼkɛ saan, nɛ binib teknh *Yesu ki jinh ki yɛbreh ki pukndeh Yerusalɛm ni. Bitɔtuɔrkaab ligol mɔ tuo' ki teke' *Yesu ki jin'. ");
INSERT INTO gngNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Uwien juoke' Etiɛnn ki gbien', ki de' wɔ mituɔm ki gbien', ki cère' u teh miyɔkm ya bont udu ya nib ni. ");
INSERT INTO gngNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","*Sufmbɛ bà te litaanl ya duku kùa bi yih kù bà ŋa ji yé yonbe ya taanl ya duku nnɔ, ya biba nin Sirɛnn ya du nin Alɛksandri ya du nin Silisi ya du nin Asi ya tinfɛnm yaab kɛ taan' ki findeh nin Etiɛnn. ");
INSERT INTO gngNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ama ba fre' ki faake' nin wɔ, kimɛ u lienh nin *Mifuoñaanm de' wɔ miyɛnfuom mà nnɔ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Nɛn saan nɛ bi de' bijɛb biba ilike bɛ ń nɛn uʼbo kí ye bi cii' u suke' Moyis nin Uwien. ");
INSERT INTO gngNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Bi len' nnɔ ma nnɔ nɛ udu ya nib nin biʼciɛnb nin *Yiko ya wɔnwɔknb kpre', nɛ ki bere' ki tì cuo' Etiɛnn, ki taa' wɔ ki jon' *Sufmbɛ ya buur ya cɛkl yaab saan, ");
INSERT INTO gngNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","nɛ ki tuke' bitonnɛndɛnb ní bi lá len' ki ye: «Uyo kɛ ujɛ wuɔ sukreh Uwien ya duku nɛ, ki saah Moyis ya yiko. ");
INSERT INTO gngNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Kimɛ ti cii' u len' ki ye Nasarɛt ya *Yesu li we Uwien ya duku kuu, kí lèbre mitetem mà Moyis là wɔkn' tɛ mɛ̀ nnɔ.» ");
INSERT INTO gngNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Nɛ tibuur ya cɛkl yaab nnɔ kɛ caan' Etiɛnn bo inun ki laa' uʼnun bó te tɛn Uwien ya tond ya nun bó. ");
INSERT INTO gngNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Nɛn saan nɛ bitɔtuɔrciɛnb ya ciɛn niire' Etiɛnn ki ye: «Bi len' ma nɔ, tù te-ee?» ");
INSERT INTO gngNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Nɛ Etiɛnn jiin' ki ye: «Nʼbaambɛ nin nʼninjiɛbɛ, li cengeh mɛn. Uyo wà tiʼyaajɛ *Abraham laan là kɔ Mesopotami ya du ni, ka laan jon' ki tì kɔn' Haraan ya du ni nnɔ, nɛ Uwien wà ŋmɔbe ukpiɛke puɔ' uʼsaan, ");
INSERT INTO gngNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","ki tɔke' wɔ ki ye: ‹Ñɛ aʼdu ni nin aʼyaab ni, kí jo n li wuɔn ŋɛ udu wà nnɔ ni.› ");
INSERT INTO gngNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Nɛn saan nɛ u fii' Kalde yaab ya du ni, ki tì kɔn' Haraan ya du ni. U te wun ni nɛ haali uʼbaa tì kpo', nɛ Uwien cère' u baa' ki kɔn' udu wà ni kɔ uʼni fɛnfɛnnɔ nɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Uwien ŋa de' wɔ tink kiba udu wuu ni, wa de' wɔ tink kì kpɛ nin kutɛpɛnku ya pìɛn mɔnɔn, ama u pùon' ki ye u li taa udu wuu kí de wɔn nin uʼyaabii nɛ, wù ń li yé biʼyu uyo kɛ. Uyo wà Uwien pùon' lipuonl liɛ nnɔ, ki laa' *Abraham ŋa laan ŋmɔbe buk. ");
INSERT INTO gngNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Nɛ Uwien tɔke' wɔ ki ye: ‹Aʼyaabii lá li tien bicɛnb udutɔ ni, nɛ uʼnib ń taa bɛ kí tien iyonbe, kí jɛ̀nde bɛ ibin kobiinan. ");
INSERT INTO gngNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ama min Uwien nɛ li dɛre bi li yé udu wà ya nib ya yonbe nnɔ ya tub. Ni ya puoli bó nɛ aʼyaabii li ñɛ udu nnɔ ni, kí baa kí lá li pukeh nni niɛ saan.› ");
INSERT INTO gngNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Nɛ Uwien cuo' nin *Abraham kujɔtieku ki tɔke' wɔ ki ye upunjiɛ nɛ yé kudìɛku kùa wɔngeh biʼjɔtieku nnɔ. Nɛn bo nɛ *Abraham maa' *Isaak, nɛ ki jiɛ' uʼpunl wienniin daali. *Isaak mɔ maa' Sakɔb, ki mɔ jiɛ uʼpunl. Sakɔk mɔ tien' nnɔ uʼbijiɛb. Bɛn nɛ yé tiʼyaajɛb piik nin bile nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","«Tiʼyaajɛb nnɔ taa' iponponbe biʼwaakɛ Yosɛf bo, nɛ ki kuɔre' wɔ binib bo wɔ ń tì ń li yé uyonb Esipt bó. Ama Uwien là te nin wɔ, ");
INSERT INTO gngNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","nɛ ki ñɛn' wɔ uʼjɛnd kɛ ni, ki juoke' wɔ, ki de' wɔ miyɛnfuom, ki cère' Esipt ya bɛrciɛn Farahɔn yíe uʼgbɛr; nɛ ki taa' wɔ ki tien' udu nnɔ nin uʼden kɛ ya ciɛn. ");
INSERT INTO gngNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Tɔ, mikònm miba ya bol lu' Esipt nin Kanaan ya du ni niʼkɛ saan. Nì là yé micɛcɛkciɛnm nɛ binib bo. Tiʼyaajɛb ŋa ji là ŋmɔbe bi li ji bà. ");
INSERT INTO gngNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Sakɔb cii' tijier te Esipt ni, nɛ u cère' uʼbijiɛb jon' miba ki tì dɛ'. ");
INSERT INTO gngNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Bi jon' nle ma nnɔ, nɛ Yosɛf cère' uʼninjiɛb bɛnde' wɔ, nɛ Farahɔn mɔ bɛnde' Yosɛf ya bol si là. ");
INSERT INTO gngNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Nɛn saan nɛ Yosɛf sɔn' bɛ ń tì taa uʼbaa Sakɔb nin uʼden yaab kɛ ní Esipt ni. Bi là te binib pilole nin biŋun nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Sakɔb nin uʼden yaab kɛ jon' ki tì kɔ Esipt ni, nɛ u tì kpo'. Nì tete nɛ uʼbijiɛb, tiʼyaajɛb mɔ tì kpo', ");
INSERT INTO gngNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","nɛ bi taa' bɛ ki tì sube' ufɛle uba ni Sikɛm ya du ni. *Abraham nɛ là taa' ilike ki dɛ' ufɛle nnɔ Sikɛm ni, Hemɔr yaab saan. ");
INSERT INTO gngNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","«Uyo wà Uwien li tien u là pùon' lipuonl là ki de' *Abraham nnɔ nɛkn' ní. U ya yo nɛ tiʼbol ya nib pɔ̀re' ki yɛbre' Esipt ni, ");
INSERT INTO gngNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","ki tì baa' uyo wà ubɛrtɔ teke' libɛl Esipt ni. Wɔn ŋa tu' Yosɛf. ");
INSERT INTO gngNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","U là lɛre' tiʼbol ya nib, ki jɛ̀nde' tiʼyaajɛb, ki wɔbn' bɛ bɛ ń taa biʼcɛnfɛndmu kí tì wiɛ mù ń kpo. ");
INSERT INTO gngNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","U ya yo nɛ bi maa' Moyis, u là yé kibuk kà mɔn Uwien ya nun bó nɛ. Bi wube' kɛ̀ kiʼbaa den iŋmaale ita nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Bi taa' kɛ̀ ki tì wiɛ' uyo wà nnɔ, nɛ Farahɔn ya bisɛ lɛke' kiʼbo, ki yuure' kɛ̀, ki wube' kɛ̀ tɛn uʼtiɛma buk. ");
INSERT INTO gngNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Bi wɔkn' Moyis Esipt yaab ya yɛnfuom kɛ. U là yé unil wà ŋmɔbe mituɔm uʼlenm ni nin uʼtùon ni nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","«Tɔ, uyo wà u laa' ibin pinan nnɔ, nɛ u taa' iyɛnmaale ki jon' wɔ ń tì fuonde uʼyaab Israyɛl yaab. ");
INSERT INTO gngNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","U tì baa' ki laa' Esipt ya nil uba ŋmɔbe Israyɛl yɔ uba ki jɛ̀ndeh, nɛ u teke' Israyɛl yɔ bo, ki ñi' ki ku' Esipt yɔ nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","U tien' nnɔ ki maaleh ki teh uʼyaab li bɛnde kí ye Uwien li cère wɔn nɛ ń ñɛn bɛ biʼnɛnnɛndb ya nuɔ ni, ama ba bɛnde'. ");
INSERT INTO gngNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Kutaaku faa' sɔ u laa' Israyɛl yaab bile kɔnh. U yíe wɔ ń pàa bɛ, nɛ ki tɔke' bɛ ki ye: ‹Niʼninjiɛl nɛ, bɛ tien' ni ŋmɔbe tɔb ki jɛ̀ndeh?› ");
INSERT INTO gngNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ama wà ŋmɔbe uʼtɔ ki jɛ̀ndeh nnɔ pe' Moyis ki jɛnde', ki tɔke' wɔ ki ye: ‹Ŋmɛ nɛ kàan' ŋɛ tiʼbɛr ŋɔ a li buh tɛ tibuur-i? ");
INSERT INTO gngNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","A yíe á ku nni tɛn a wun ku' Esipt yɔ ma nnɔ nɛ-a!› ");
INSERT INTO gngNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","U len' nnɔ ma nnɔ nɛ Moyis sɛn' ki jon' Madiyan ya du ni, ki tì kɔ, nɛ ki maa' mubujɛbumu mule niʼbó. ");
INSERT INTO gngNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","«Ibin pinan gɛ̀bre', nɛ Uwien ya tond uba baa' Moyis saan kupenpelku ni, Sinayi ya juɔl saan, ki te kufɛtuku kuba ni kù teknh umu ka wih. ");
INSERT INTO gngNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moyis laa' nɛ̀ ma nnɔ, nɛ nì cuo' wɔ miyɔkm. Uyo wà u nɛkndeh wɔ ń liike nnɔ, nɛ ki cii' Yonbdaan len' ki ye: ");
INSERT INTO gngNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‹Min nɛ yé aʼyaajɛb ya Wien, ki yé *Abraham nin *Isaak nin Sakɔb ya Wien.› Bujɛwaanbu cuo' Moyis, uʼgbɛnɛnt ŋɔh, nɛ wa ji kaabe' ki liike'. ");
INSERT INTO gngNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Nɛn saan nɛ Yonbdaan tɔke' wɔ ki ye: ‹Cɛkre aʼtacaan, kimɛ a se nà saan nɔ n te niʼsaan nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Imɔ̀n, n laa' nʼnib Israyɛl yaab ya cɛcɛkm kpɛ ma bo Esipt ni, ki cii' biʼkpiɛnde bó, nɛ ki jiire' ní ń ŋmiɛn bɛ. Fɛnfɛnnɔ li joh, n sɔn' ŋɛ Esipt bó, á tì ñɛn bɛ len nɛ.› ");
INSERT INTO gngNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","«Moyis wà Israyɛl yaab là yìe' wɔ, ki tɔke' ki ye ŋmɛ kàan' wɔ ubɛr wɔ ń li buh bɛ tibuur nnɔ, Uwien tien' wɔn nɛ ubɛr nin Uŋmiɛnl, ki sɔn' wɔ, ki cère' uʼtond wà là baa' uʼsaan kufɛtuku kuba ni nnɔ toreh wɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Wɔn nɛ ñɛn' bɛ Esipt ni. U tien' miyɔkm ya bont udu nnɔ ni nin miñunciɛnmɔ́nmɔ́nm saan nin kupenpelku ni ibin pinan. ");
INSERT INTO gngNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Wɔn Moyis nɛ tɔke' Israyɛl yaab ki ye: ‹Uwien li cère niʼni uba ń ñɛ uñɔbonsɔknl niʼbo tɛn min.› ");
INSERT INTO gngNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Israyɛl yaab là taan' kupenpelku ni uyo wà nnɔ, wɔn nɛ là te tiʼyaajɛb nin Uwien ya tond wà lienh nin wɔ nnɔ ya siik ni. Utond nnɔ là tɔke' wɔ tigbɛr tà dienh limiɛl Sinayi ya juɔl bo wɔ ń lá tɔke tɛ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Nin nɛn kɛ tiʼyaajɛb ŋa tuo' ki bon' wɔ. Bi yìe' uʼñɔbu bó, nɛ ki yíe bɛ ń liɛbe Esipt ni, ");
INSERT INTO gngNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","nɛ ki tɔke' Arɔn ki ye: ‹Mɛ tɛ ibule yì ń li le tɛ usɛn, kimɛ Moyis wà ñɛn' tɛ Esipt ni nnɔ, ta bɛn nà tu' wɔ.› ");
INSERT INTO gngNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","U ya yo nɛ bi mɛn' ubul uba u naan kinabuk, ki tùɔre' lituɔrl ki de' wɔ, nɛ ki jele' kunacenku ki pokn' bi mɛn' ubul wà nnɔ bo ki gbien'. ");
INSERT INTO gngNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Nɛn nɛ cère' Uwien búle' bɛ ibuɔn, ki sɛln' bɛ bi pukeh tiwenwent tà te kutaaku bo nnɔ, tɛn *Uwien ya ñɔbonsɔknb kɛle' ma *Uwien ya gbɔnku ni. Bi kɛle' ki ye: ‹Israyɛl yaabɛ, ni là kòre' tiwɛnt ki tien' ituɔrɛ yà nin ni tien' ituɔrtɔ yà kupenpelku ni ibin pinan nnɔ, ni là tien' ki de' min nɛ-ɛɛ? ");
INSERT INTO gngNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Na là tien' ki de' min, ama ni là yuure' ubul Molok ya ninbonl nɛ ki tuke', ki yuure' ubul wà naan liŋmaabil bi yih wɔ Erefann nnɔ mɔ. Ni là mɛn' ibule nnɔ ki ye ni li gbaandeh ki pukeh yin nɛ. Nɛn bo nɛ n li cère bɛ ń cuo nɛ tiyonbt kí jon nà bó fɔke ki cɛn' nin *Babilonn.› ");
INSERT INTO gngNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","«Tiʼyaajɛb là te kupenpelku ni ma nnɔ bi là ŋmɔbe bɛn nin Uwien cendeh lininbonl là ni nɛ. Kujɔtieku ya gbɔnku mɔ là te lɛn ni nɛ. Uwien nɛ là tɔke' Moyis ki ye wɔ ń tien lininbonl nnɔ. Nɛ Moyis tien' lɛ̀ Uwien wuɔn' wɔ ki ye lɛ̀ ń li naan ma bo nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Tiʼyaajɛb là taa' lininbonl nnɔ ki de' biʼyaabii. Nɛ bi teke' lɛ̀ ki ŋuuke ki tì baa' uyo wà Sosuwe yé biʼsɛnlierl nnɔ. Bɛn nin Sosuwe là joh bɛ ń tì teke udu wà, bɛn bo Uwien là ŋɔre' inibol uʼni nnɔ ma nnɔ, bi là tuke lɛ̀ nɛ. Lininbonl nnɔ là te nɛn saan nɛ, ki tì baa' ubɛr *Dafid ya yo. ");
INSERT INTO gngNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Uwien ya yɛnm sɔnge *Dafid bo, nɛ *Dafid miɛ' wɔ usɛn wɔ ń mɛ kuduku ki de' wɔn Uwien wà yé uʼyaajɛ Sakɔb ya Wien nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Uʼbijɛ Salomɔn nɛ mɛn' Uwien kuduku. ");
INSERT INTO gngNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","«Ama Uwien wà ŋa ŋmɔbe Nacentɔ ŋa kɔh nib mɛn' tidur tà ni tɛn *Uwien ya ñɔbonsɔknl là len' ma ki ye Uwien ye: ");
INSERT INTO gngNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‹Kutaaku nɛ yé nʼbɛrbiɛk, kitink yé nʼtàan taanh nà bo nɛ, ni li mɛ bɛ ya dubol nɛ kí de nni, ŋɔ ń li kɔh kuʼni ki fuoreh? ");
INSERT INTO gngNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Na yé min nɛ ñɛn' tibont kɛ-ɛɛ?› » ");
INSERT INTO gngNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Etiɛnn tí len' ki ye: «Niʼyul faa, nɛ niʼfɛ̀l bo te tɛn binib bà ŋa pɛ Wien bo, ka cengeh uʼgbɛr, ki yìenh *Mifuoñaanm uyo kɛ. Ni te tɛn niʼyaajɛb nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Niʼyaajɛb là jɛ̀nde' *Uwien ya ñɔbonsɔknb kɛ, ki ku' binib bà tɔkeh ki teh Uwien ya Gbɛmɔ̀ndaan li baa ní nnɔ. Fɛnfɛnnɔ, u baa' ní, nɛ ni kuɔre' wɔ, ki ku' wɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Uwien là sɔn' uʼtondb bi lá de' ninbi nɛ uʼyiko, nɛ na bon' wɔ.» ");
INSERT INTO gngNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Etiɛnn len' nnɔ ma nnɔ nɛ biʼbenku ni ben' ki tì kɛnde', nɛ bi gbiɛnh uʼbo inɔbii. ");
INSERT INTO gngNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ama *Mifuoñaanm te Etiɛnn bo ma nnɔ, nɛ u yaare' ki liike' kutaaku bo, ki laa' Uwien ya wenwenku windeh, ki laa' *Yesu se Uwien ya jie bó. ");
INSERT INTO gngNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Nɛ u ye: «Liike mɛn, n laa' kutaaku yɛ, nɛ ki laa' Unil ya Bijɛ se Uwien ya jie bó.» ");
INSERT INTO gngNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","U len' nnɔ ma nnɔ nɛ bi wuure' ufaa bo, ki pipi' biʼtub, nɛ ki taan' ki bere' ki tì cuo' wɔ, ");
INSERT INTO gngNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ki ñɛn' wɔ udu nnɔ ni, bɛ ń tì yèke wɔ itɛn kí ku wɔ, nɛ ki gore' biʼliɛrcɛnciɛn ki ble' ki guun' unacenfaan uba bi yih wɔ Sɔl. ");
INSERT INTO gngNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Bi yèkreh wɔ itɛn uyo wà nnɔ, nɛ u kàareh ki teh: «Yonbdaan Yesu, teke nʼnaank.» ");
INSERT INTO gngNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Nɛ ki gbaan', ki wuure' ufaa bo ki ye: «Yonbdaan, la tɔnge biʼbiɛre yii nɔ.» U len' nnɔ ki gben', nɛ ki kpo'. ");
INSERT INTO gngNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sɔl mɔ se bà ku' Etiɛnn nnɔ ya ciɛk bó nɛ. Kí ñɛ nɛn daali nɛ bi cin' ki jɛ̀ndeh *Kristo ya taanl yaab bà te Yerusalɛm ni nnɔ ki gbiekeh. Nɛn bo nɛ biʼkɛ yɛre', ki jon' Sude nin Samari ya tinfɛnm ni. *Yesu ya tondb baba nɛ ji là sìen' Yerusalɛm ni. ");
INSERT INTO gngNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Binib bà pɛ Uwien bo mɔnmɔnm nnɔ nɛ sube' Etiɛnn, ki muɔ' uʼkuum ki gbien'. ");
INSERT INTO gngNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Sɔl wɔn là ñikndeh wɔ ń bere *Kristo ya taanl nɛ. U joh iden nɛ kí tì coh bijɛb nin bipiib ufaa bo kí tì pɛkndeh. ");
INSERT INTO gngNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","*Kristo ya taanl yaab yɛre' ma nnɔ, nɛ ki cuonh niʼkɛ saan ki tɔkeh binib uʼgbɛmɔnmɔnt. ");
INSERT INTO gngNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filip jon' Samari ya tinfɛnm ya du uba ni ki tì tɔkeh binib Uwien ya Nigɛndkɛ Kristo ya gbɛr. ");
INSERT INTO gngNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Udu nnɔ ya nib cengeh Filip bó, ki lɛnh u teh miyɔkm ya bont tà nnɔ mɔ, nɛn nɛ cère' bi pɛ uʼgbɛr bo mɔnmɔnm. ");
INSERT INTO gngNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Isɛnpol ŋaake binib bi yɛbe nɛ u ŋuɔh yɛ̀ biʼsaan, ì siereh ki wuureh ufaa bo. U cèreh iwɔ̀b nin idiɛn mɔ faakreh ki yɛbe. ");
INSERT INTO gngNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Nɛn bo nɛ udu nnɔ ya nib ya yɛnm sɔnge' ki gbien'. ");
INSERT INTO gngNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ujɛ uba mɔ là te udu nnɔ ni, bi yih wɔ Simɔn, u teh iñɔke nì coh Samari ya tinfɛnm ya nib miyɔkm. U là yih uba unikpɛkpiɛk nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Nɛ binib kɛ tuo' uʼñɔbu bó, ka tuuke wà yé wà, ki lienh uʼbo ki teh: «Uwien ya tuɔm nɛ kpɛnde' unil wuɔ. Bi yih nɛn nɛ mitɔciɛnm.» ");
INSERT INTO gngNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Bi tuonh uʼñɔbu bó, kimɛ u ñɛn' uyo nɛ ki teh iñɔke nì coh bɛ miyɔkm. ");
INSERT INTO gngNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ama Filip baa' ki lá tɔke' bɛ Uwien ya bɛl ya gbɛmɔnmɔnt, ki liɛbe' ki tɔke' bɛ *Yesu Kristo yé udaan wà, bi teke' ki jin' nɛ u sìi' bijɛb nin bipiib kɛ Uwien ya ñunm. ");
INSERT INTO gngNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simɔn, uñɔkdaan nnɔ mɔnɔn teke' ki jin', nɛ Filip sìi' uʼmɔ Uwien ya ñunm. Wa ji siereh Filip saan, ki lɛnh u teh miyɔkciɛnm ya bont, nɛ nì coh wɔ miyɔkm cɛɛn. ");
INSERT INTO gngNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","*Yesu ya tondb bà te Yerusalɛm ni nnɔ cii' Samari ya tinfɛnm ya nib mɔ teke' Uwien ya gbɛr ki jin', nɛ bi sɔn' Piɛr nin San niʼbó. ");
INSERT INTO gngNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Bi tì baa', nɛ ki kàare' ki de' Samari ya nib bà teke' ki jin' nnɔ, ŋɔ Uwien ń de bɛ *Mifuoñaanm. ");
INSERT INTO gngNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Kimɛ *Mifuoñaanm ŋa laan là jiire' ní biʼni uba mɔnɔn bo. Bi là sìi' bɛ Uwien ya ñunm baba nɛ, Yonbdaan *Yesu ya yel bo. ");
INSERT INTO gngNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Nɛn saan nɛ Piɛr nin San taa' biʼnuɔ ki paan' biʼbo, ki kàare' ki de' bɛ, nɛ *Mifuoñaanm jiire' ní biʼbo. ");
INSERT INTO gngNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simɔn uñɔkdaan nnɔ, laa' *Yesu ya tondb taa' biʼnuɔ ki paan' binib bo, *Mifuoñaanm jiire' ní biʼbo ma nnɔ, nɛ u ye u li de bɛ ilike, ");
INSERT INTO gngNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","bɛ ń de wɔ mituɔm nnɔ, ŋɔ uʼmɔ taa' uʼnuɔ ki paan' unil wà bo la, *Mifuoñaanm ń jiire ní udaan bo. ");
INSERT INTO gngNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Nɛ Piɛr tɔke' wɔ ki ye: «Sin nin aʼlike kɛ ń juore fɛnm, kimɛ a maale' ki ye a li fre kí taa ilike kí dɛ Uwien ya paabu nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Aʼniba ŋa lì te tigbɛr tuu ni, kimɛ aʼyɛnmaale ŋa cuube Uwien ya nun bó. ");
INSERT INTO gngNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Lèbre aʼtetem, kí wiɛ aʼbiɛrm miɛ nɔ, kí kàare Yonbdaan, nba la, u li fère ŋɛ aʼyɛnmaalbiɛre yii nɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Kimɛ n laa' a ŋmɔbe iponponbe ki gbien', nɛ ibiɛre lùo ŋɛ iŋmi yaam.» ");
INSERT INTO gngNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Nɛ Simɔn uñɔkdaan nnɔ, tɔke' Piɛr nin San ki ye: «Ni bugbɛn kàare mɛn Yonbdaan kí de nni, ŋɔ ni len' nà nɔ niba la tu nni.» ");
INSERT INTO gngNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Piɛr nin San kun' Yonbdaan bo imɔ̀n, ki tɔke' binib uʼgbɛr ki tì gben' nɛ ki liɛbeh Yerusalɛm. Bi joh ma nnɔ nɛ ki tɔkeh tigbɛmɔnmɔnt Samari ya tinfɛnm ya du yà yɛbe ni. ");
INSERT INTO gngNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Lidaali liba nɛ Yonbdaan ya tond uba tɔke' Filip ki ye: «Fii, kí taa unɔgɛn bó, kí tì kpìen usɛn wà ñɛh Yerusalɛm ki joh Gasa ya du bó nnɔ. Nib ŋa ji kpìendeh usɛn bugbɛn.» ");
INSERT INTO gngNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Filip fii' ki bure'. U joh ma nnɔ nɛ ki laa' ujɛfàarkɛ uba, u yé Etiyopi ya kɛraciciɛn uba nɛ. Wɔn nɛ likeh Etiyopi ya piibɛr Kandasi ya faal kɛ. U là baa' Yerusalɛm ni ki puke' Uwien nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","U liɛbe' ki kunh ki kaa kutɛnlolku ni, nɛ ki kàanh *Uwien ya ñɔbonsɔknl Esayi là kɛle' kugbɔnku kùa nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Nɛ Mifuoñaanm tɔke' Filip ki ye: «Cuon kí nɛkn kutɛnlolku kuu nɔ.» ");
INSERT INTO gngNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filip sɛn' ki nɛkn' kù, nɛ ki cii' u kàanh *Uwien ya ñɔbonsɔknl Esayi là kɛle' kugbɔnku kùa nnɔ. Nɛ Filip niire' wɔ ki ye: «A kàanh kugbɔnku kùa nɔ, a ciih kuʼtingi-ii?» ");
INSERT INTO gngNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Nɛ u ye: «Nil ŋa wuɔn' nni kuʼtingi la, n li tien mila kí cii?» Nɛ ki tɔke' Filip ki ye wɔ ń kɔ ní kí kɛ̀le uʼsaan. ");
INSERT INTO gngNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","U kàanh *Uwien ya gbɔnku ni nà saan nnɔ, nì kɛle' ki ye: «Bi tuke wɔ tɛn bi tuke upe nɛ ki joh bɛ ń tì kòre. U te tɛn bi gureh kipebuk ya kobr nɛ ka muɔh. Nnɔ nɛ uʼmɔ ŋa len' tuba. ");
INSERT INTO gngNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Bi yuɔn' wɔ, nɛ ki mun' wɔ imɔ̀n, ŋmɛ ji li len uʼyaabii bó? Kimɛ bi gben' uʼmiɛl uŋɛndun wuu ni ŋɔ.» ");
INSERT INTO gngNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Nɛ ujɛ nnɔ tɔke' Filip ki ye: «N faare' ŋɛ nɛ, laan tɔke nni, *Uwien ya ñɔbonsɔknl nnɔ len' ŋmɛ ya gbɛr nɛ? Wɔn bugbɛn ya gbɛr nɛ bii u len' uba yaar nɛ?» ");
INSERT INTO gngNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Nɛn saan nɛ Filip ñi' mikɛlm nnɔ bo ki tɔke' wɔ *Yesu ya gbɛmɔnmɔnt. ");
INSERT INTO gngNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Bi jojoh ki tì baa' libùol liba miñunm te niʼsaan, nɛ ujɛ nnɔ tɔke' Filip ki ye: «Liike-a, miñunm sɔ-a! A li tuo kí sìi nni Uwien ya ñunm-ii?» ");
INSERT INTO gngNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Nɛ Filip ye: «A teke' *Yesu ki jin' mɔnmɔnm la, usɛn te.» Nɛ u ye: «N teke' ki jin' ki ye *Yesu Kristo yé Uwien ya Bijɛ nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Nɛn saan nɛ u cère' bi sien' kutɛnlolku nnɔ, nɛ wɔn nin Filip kɛ bile jiire', ki kɔn' miñunm ni, nɛ Filip sìi' wɔ Uwien ya ñunm. ");
INSERT INTO gngNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Bi ñɛn' miñunm ni uyo wà nnɔ, nɛ Yonbdaan ya Fuoñaanm taa' Filip ki bure'. Ujɛ nnɔ ŋa ji laa' wɔ nɛ ki liɛbe' ki kɔn' uʼtɛnlolku ni, ki joh nin uyɛnsɔnge. ");
INSERT INTO gngNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filip wɔn, bi tì laa' wɔ Asɔt ya du ni nɛ. U ñɛh idu yà kɛ ni nnɔ, u tɔkeh binib tigbɛmɔnmɔnt nɛ, ki tì baa' Sesare ya du ni. ");
INSERT INTO gngNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","U ya yo ki laa' Sɔl laan biɛ ki ŋmɔbe limutuol binib bà teke' Yonbdaan ki jin' nnɔ bo nɛ, ki nuunh wɔ ń ku bɛ. U jon' bitɔtuɔrciɛnb ya ciɛn saan, ");
INSERT INTO gngNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","wɔ ń kɛle kugbɔnku kí de wɔ usɛn wɔ ń jo *Sufmbɛ ya táan ya dur tà te Damas ya du ni nnɔ. U tì laa' niʼbó binib bà pɛ *Yesu ya sɛn bo, nì yé bijɛb bii bipiib la, wɔ ń cuo bɛ kí lòle, kí taa bɛ ní Yerusalɛm ni. ");
INSERT INTO gngNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Sɔl joh ki tì nɛke Damas ya du ma nnɔ, nɛ kuwenwenku kuba ñɛn' paaki bó ní i ya tàan bo, ki wende' ki yile' uʼbo. ");
INSERT INTO gngNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","U lu' tingi ni, nɛ ki cii' uniɛke uba bó u teh: «Sɔl, Sɔl, bɛ tien' a jɛ̀ndeh nni?» ");
INSERT INTO gngNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Nɛ Sɔl niire' ki ye: «Yonbdaan, a yé u lɛ daan nɛ?» Nɛ u tɔke' wɔ ki ye: «Min *Yesu nɛ, a jɛ̀ndeh min nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ama fii, kí kɔ udu ni, bi li tɔke ŋɛ a li tien ma bo.» ");
INSERT INTO gngNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Sɔl nin bijɛb bà tɔke nnɔ jeke ki se, ka ji li fre kí len, kimɛ bi cii' uniɛke bó nɛ, ama ba laa' wà lienh. ");
INSERT INTO gngNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sɔl fii', uʼnunbii kɛ, ama wa ji lɛnh. Nɛ bi cuo' uʼnuɔ, ki dɛ̀re' wɔ ki kɔn' Damas ya du ni. ");
INSERT INTO gngNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","U tien' iwien ita ka lɛnh, ka jinh, ka ñuh mɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Tɔ, unil uba là te Damas ya du ni, ki teke' Yonbdaan ki jin', bi yih wɔ Ananiyas. Yonbdaan yin' wɔ tidɛknt yaam ki ye: «Ananiyas.» Nɛ u ye: «Min sɔ, Yonbdaan.» ");
INSERT INTO gngNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Nɛ Yonbdaan tɔke' wɔ ki ye: «Fii, kí tì kpìen usɛn wà bi yih wù usɛn wà cuube nnɔ, kí li joh Sudas den, kí tì niire ujɛ uba bó, u te ki kàareh, bi yih wɔ Sɔl. U yé Tars ya du ya nil nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","U laa' ujɛ uba tidɛknt yaam, bi yih wɔ Ananiyas, u kɔn' ní uʼsaan, ki lá taa' uʼnuɔ ki paan' uʼbo, wɔ ń likre.» ");
INSERT INTO gngNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Nɛ Ananiyas jiin' ki ye: «Yonbdaan, n cii' binib len' ujɛ bugbɛn ya gbɛr ki yɛbe. Bi ye u jɛ̀nde' aʼnib ki gbien' Yerusalɛm ni. ");
INSERT INTO gngNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Bitɔtuɔrciɛnb de' wɔ usɛn u baa' niɛ saan mɔ wɔ ń cuo binib bà taakeh aʼyel bo nnɔ nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Nin nɛn kɛ Yonbdaan tɔke' wɔ ki ye: «Li joh uʼsaan, kimɛ min nɛ gɛ̀nde' wɔ, wɔ ń cère bà ŋa yé Israyɛl yaab nin biʼbɛrb nin Israyɛl yaab ń bɛnde n yé udaan wà. ");
INSERT INTO gngNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Min bugbɛn nɛ li wuɔn wɔ u li ji ijɛnd yà kɛ nʼyel bo.» ");
INSERT INTO gngNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Nɛn saan nɛ Ananiyas fii' ki jon' Sudas den, ki tì kɔn' Sɔl saan, ki taa' uʼnuɔ ki paan' uʼbo, nɛ ki ye: «Nʼninjɛ Sɔl, Yonbdaan *Yesu wà cère' a laa' wɔ usɛn ni, uyo wà a we ní nnɔ nɛ sɔn' nni ní, ń baa kí cère á likre, kí cère *Mifuoñaanm ń jiire ní aʼbo.» ");
INSERT INTO gngNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Nɛ nibonn niba ñɛn' Sɔl ya nun ni i ya tàan bo ki lu' ki naan tijɛnpɔkr. U ya yo nɛ u likre', ki fii', bi sìi' wɔ Uwien ya ñunm, ");
INSERT INTO gngNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","nɛ u jin' tijier ki laa' mituɔm. Sɔl tien' Damas ya du ni iwenkàankɛ binib bà teke' Yonbdaan ki jin' nnɔ saan. ");
INSERT INTO gngNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Nɛ ki cin' i ya tàan bo ki kɔh *Sufmbɛ ya táan ya dur ni, ki tɔkeh binib ki teh *Yesu yé Uwien ya Bijɛ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Miyɔkm cuo' binib bà kɛ ciih u tɔkeh tigbɛr tà nnɔ, nɛ bi niireh tɔb ki teh: «Bo, na yé wɔn nɛ là jɛ̀ndeh binib bà taakeh *Yesu ya yel bo Yerusalɛm ni nnɔ-ɔɔ? Wa baa' wɔ ń lá cuo bà mɔ te niɛ saan nɔ nɛ, kí lòle bɛ, kí taa bɛ kí jo Yerusalɛm, kí tì ŋukn bitɔtuɔrciɛnb-ii?» ");
INSERT INTO gngNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Sɔl wɔn tùɔreh ki faakreh nɛ, ki lienh ki jinh *Sufmbɛ bà te Damas ya du ni nnɔ, ki wɔngeh bɛ ki teh *Yesu mɔnbe ki yé Uwien ya Nigɛndkɛ Kristo nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Iwien yà yɛbe gɛ̀bre', nɛ *Sufmbɛ nnɔ gbiere' ki kpaan' bɛ ń ku Sɔl. ");
INSERT INTO gngNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Idaan kɛ, ñɔnku nin wien ni, bi kɛ ki gu udu nnɔ ya guon ya nañuɔn nɛ, Sɔl lá ñɛn' ní la, bɛ ń ku wɔ. Nɛ u cii' bi kpaan' uʼbo iyɛ ma bo. ");
INSERT INTO gngNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Nɛ kuñɔnku kuba, wɔn nin binib bà te nnɔ yuure' wɔ kukɛndɛncɛnciɛnku kuba ni, ki ñɛn' liguonl. ");
INSERT INTO gngNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Nɛ Sɔl bure' ki tì baa' Yerusalɛm, ki yíe wɔ ń taan nin binib bà teke' *Yesu ki jin' nnɔ; nɛ biʼkɛ fɛnge' wɔ, ka teke' ki jin' ki ye uʼmɔ ji yé unil wà teke' *Yesu ki jin' nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Nɛn saan nɛ Banabas taa' wɔ ki jon' *Yesu ya tondb saan, ki tì tɔke' bɛ Sɔl là laa' Yonbdaan usɛn ni ma bo nin Yonbdaan len' nin wɔ ma bo nin u laa' lifɛ̀l ki tɔke' binib *Yesu ya gbɛr Damas ya du ni ma bo. ");
INSERT INTO gngNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Banabas tɔke' bɛ ma nnɔ nɛ bi tuo' ki cère' Sɔl nin bɛn te. U tɔkeh nin bɛ ki cuonh Yerusalɛm ni niʼkɛ saan, ki tɔkeh binib Yonbdaan ya gbɛr nin lifɛ̀l. ");
INSERT INTO gngNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","U là tɔke' *Sufmbɛ bà lienh Grɛkmbɛ ya lenm nnɔ mɔ tigbɛr nnɔ, nɛ bi finde' nin wɔ, ki nuunh bɛ ń ku wɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Binib bà teke' *Yesu ki jin' nnɔ cii' bi nuunh bɛ ń ku Sɔl ma nnɔ, nɛ bi taa' wɔ ki jon' Sesare ya du ni, ki cère' u bure' Tars ya du bó. ");
INSERT INTO gngNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","*Kristo ya taanl yaab bà te Sude ya tinfɛnm ni nin Galile ya tinfɛnm ni nin Samari ya tinfɛnm ni nnɔ kɛ là te uyɛnduɔn ni nɛ, ki faakreh mitekjim ni, ki boh Yonbdaan biʼfuobm ni nɛ, *Mifuoñaanm saakreh biʼgbɛnɛnt ki cèreh bi yɛbreh ki pukndeh. ");
INSERT INTO gngNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Tɔ, Piɛr joh niʼkɛ saan ma nnɔ, nɛ ki jon' Lida ya du ya nib bà teke' *Yesu ki jin' nnɔ mɔ saan. ");
INSERT INTO gngNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","U laa' ujɛ uba niʼsaan uʼgbɛnɛnt faan' bi yih wɔ Ene. U dɔ kukaagbɔnku bo haali ibin iniin ka freh ki fih. ");
INSERT INTO gngNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Nɛn saan nɛ Piɛr tɔke' wɔ ki ye: «Ene, *Yesu Kristo de' ŋɛ laanfiɛ ŋɔ. Fii, kí gbɔgbɔbe aʼkaagbɔnku.» Nɛ u pɔk ki fii' i ya tàan bo. ");
INSERT INTO gngNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Binib bà kɛ te Lida ya du ni nin Sarɔnn ya du ni nnɔ laa' wɔ, nɛ ki lèbre' biʼtetem, ki paan' Yonbdaan ya sɛn bo. ");
INSERT INTO gngNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Upii uba là te Yope ya du ni ki teke' *Yesu ki jin', bi yih wɔ Tabita, ki liɛbe' ki yih uʼyel bugbɛn Grɛkmbɛ ya lenm ni ki teh Dorkas, niʼtingi si: «upiɛcɛl». U là sɔnh itùonmɔnmɔn ì yɛbe, nɛ ki punh bijiinb mipum. ");
INSERT INTO gngNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Uwien uba sɔ u lá bunge', ki kpo'. Bi sìi' wɔ, nɛ ki taa' wɔ ki tì ble' lidutɔtuɔl ya duku kuba ni paaki. ");
INSERT INTO gngNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Yope ya du ya nib bà teke' *Yesu ki jin' nnɔ cii' Piɛr te Lida ya du ni. Idu nnɔ ŋa fɔke nin iʼtɔ ma nnɔ, nɛ bi sɔn' bijɛb bile, bɛ ń tì yin Piɛr wɔ ń ñikn kí baa biʼsaan tonm. ");
INSERT INTO gngNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Bi tì baa' ki tɔke' Piɛr nɛ u fii' ki paan' biʼbo ki bure'. U tì baa' niʼsaan, nɛ bi taa' wɔ ki don' paaki ya duku nnɔ ni. Bikpopiib bà kɛ taan' niʼsaan nnɔ te Piɛr ya nun bó ki muɔh, ki wɔngeh wɔ tikpɛlcɛr tà Dorkas là ñɛle' tù uyo wà u là fuobe nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Piɛr ŋɔre' biʼkɛ ki ñɛn', nɛ ki gbaan', ki kàare', ki pekre' utɛnkpii nnɔ bó ki len' ki ye: «Tabita, fii.» Nɛ u likre', ki laa' Piɛr, nɛ ki fii' ki kɛ̀le'. ");
INSERT INTO gngNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Piɛr cuo' uʼnuɔ ki fin' wɔ, nɛ ki yin' binib bà teke' *Yesu ki jin' nnɔ nin bikpopiib nnɔ, ki taa' wɔ ki wuɔn' bɛ u fuobe. ");
INSERT INTO gngNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Binib bà kɛ te Yope ya du ni nnɔ cii' tigbɛr nnɔ. Nɛn bo nɛ binib teke' Yonbdaan ki jin' ki yɛbe. ");
INSERT INTO gngNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Piɛr tien' Yope ya du ni ki wuɔke'. U là te ujɛ uʼba den nɛ, bi yih wɔ Simɔn u yé ugbɔnjɛbl. ");
INSERT INTO gngNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ujɛ uba là te Sesare ya du ni, bi yih wɔ Kɔrnɛyi. U yé Sojambɛ kobk ya ciɛn nɛ. Bi yih Sojacɛkl nnɔ «Itali ya Sojambɛ nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Kɔrnɛyi nin uʼden yaab kɛ pɛ Uwien bo mɔnmɔnm nɛ, ki boh wɔ. U punh bijiinb mipum ki gbiekeh, ki kàareh idaan kɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Lidaali liba ya tajuɔku tikur tuta ya yo, nɛ u cinbe ki laa' Uwien ya tond uba tidɛknt yaam, u kɔn' ní uʼsaan ki yin' wɔ ki ye: «Kɔrnɛyi.» ");
INSERT INTO gngNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","U liike' Uwien ya tond nnɔ, nɛ bujɛwaanbu cuo' wɔ, nɛ u ye: «Yonbdaan, a ye ba?» Nɛ Uwien ya tond nnɔ tɔke' wɔ ki ye: «Aʼkaare nin a punh bijiinb mipum ma nnɔ nɛ cère' Uwien tiɛre' aʼbó. ");
INSERT INTO gngNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Fɛnfɛnnɔ, sɔn binib bɛ ń jo Yope ya du ni, kí tì yin ujɛ uba ní, bi yih wɔ Simɔn, ki baanh wɔ Piɛr. ");
INSERT INTO gngNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","U te ugbɔnjɛbl uba den nɛ, bi yih uʼmɔ Simɔn. Iden nnɔ te miñunciɛnm ya gbaal nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Uwien ya tond wà len' nin Kɔrnɛyi nnɔ bure', nɛ Kɔrnɛyi pɔk ki yin' uʼtonsɔnb ni bile nin uʼsojambɛ bà te uʼsaan idaan kɛ, ki sɔnh wɔ itùon nnɔ ni ya uba, wà pɛ Uwien bo mɔnmɔnm nnɔ, ");
INSERT INTO gngNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","ki tɔke' bɛ u laa' nà nnɔ kɛ, nɛ ki sɔn' bɛ Yope ya du bó. ");
INSERT INTO gngNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Kutaaku faa' ki laa' bi te usɛn ni ki nɛke Yope ya du. Kuwensiiku ya yo, nɛ Piɛr don' u te kudulɛkaaku kùa ni nnɔ ya paaki wɔ ń kàare. ");
INSERT INTO gngNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Mikònm cuo' wɔ, nɛ u yíe wɔ ń ji. Bi teh tijier bɛ ń de wɔ uyo wà nnɔ, nɛ u laa' tidɛknt yaam, ");
INSERT INTO gngNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","kutaaku yɛ, ki laa' nibonn niba, nì naan bukpɛlbu ki piɛ, bi co niʼñɔgbɛn inan nì jiinh ní tingi. ");
INSERT INTO gngNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Itàan inan ya wɛnt kɛ ya bol nin tiwɛnt tà fuunh kubenku bo kɛ ya bol nin inuɔn kɛ ya bol te nibonn nnɔ bo. ");
INSERT INTO gngNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Nɛ u cii' uniɛke uba bó u ye: «Piɛr, fii kí ku kí ŋmɔn.» ");
INSERT INTO gngNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Nɛ Piɛr ye: «Kayi, Yonbdaan, n tì fii' ma, ma ŋmɔn' nibonn nà yé likuɔl, ki yé tijɔknt ya bonn fiebu.» ");
INSERT INTO gngNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Nɛ uniɛke nnɔ tí ye: «Uwien mɔnge' nà la, la ye nì yé jɔknt.» ");
INSERT INTO gngNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Uniɛke nnɔ ye nnɔ bolm mita, nɛ nibonn nnɔ pɔk ki liɛbe' ki don' kutaaku. ");
INSERT INTO gngNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Uyo wà Piɛr te ki maaleh wɔ ń bɛnde u laa' nibonn nà tidɛknt yaam nnɔ ya tingi nnɔ, nɛ binib bà Kɔrnɛyi sɔn' bɛ, bi te ki niireh bɛ ń bɛnde Simɔn den nnɔ baa' niʼsaan, ki lá sere' bunañɔbu ni, ");
INSERT INTO gngNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","nɛ ki yin' ki niire' ki ye: «Ujɛ wà bi yih wɔ Simɔn, ki baanh wɔ Piɛr nnɔ te iden yà sɔ-ɔɔ?» ");
INSERT INTO gngNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Piɛr laan biɛ ki te ki maaleh u laa' nibonn nà tidɛknt yaam nnɔ ya tingi, nɛ *Mifuoñaanm tɔke' wɔ ki ye: «Liike, bijɛb bita biba nuunh ŋɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Fii kí jiire, kí paan biʼbo, ki la jie, kimɛ min nɛ sɔn' bɛ ní.» ");
INSERT INTO gngNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Nɛ Piɛr jiire', ki tɔke' bijɛb nnɔ ki ye: «Min nɛ yé unil wà ni nuunh wɔ nnɔ. Ni nuunh nni bɛ bo?» ");
INSERT INTO gngNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Nɛ bi tɔke' wɔ ki ye: «Kɔrnɛyi nɛ sɔn' tɛ ní. U yé Sojambɛ kobk ya ciɛn nɛ, ki yé ugbɛmɔ̀ndaan, ki boh Uwien. *Sufmbɛ kɛ pɛ̀keh wɔ ki gbiekeh nɛ. Uwien ya tond uba tɔke' wɔ ki ye wɔ ń yin ŋɛ, á baa uʼden wɔ ń cenge aʼgbɛr.» ");
INSERT INTO gngNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Piɛr taa' bɛ ki kɔn', ki cère' bi gɔn'. Nì faa' nɛ u fii' ki paan' biʼbo. Yope ya du ya nib bà teke' *Yesu ki jin' nnɔ ya biba pìɛre' wɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Nì tí liɛbe' ki faa' nɛ Piɛr baa' Sesare ya du ni. U baa' ki laa' Kɔrnɛyi yin' uʼden yaab nin uʼjɔtiemɔ̀nb bi taan' ŋɔ, ki kɛ ki gu wɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Piɛr baa' uyo wà nnɔ, nɛ Kɔrnɛyi tuobe' wɔ, ki lá gbaan' uʼnintuɔli, ki puke' wɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Nɛ Piɛr tɔke' wɔ ki ye: «Fii», nɛ ki cuo' wɔ ki fin' ki ye: «Nʼmɔ yé unisaal nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","U lienh nin wɔ ki tì kɔn', nɛ ki laa' binib taan' ki yɛbe. ");
INSERT INTO gngNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Nɛ u tɔke' bɛ ki ye: «Ninbi, ni bɛn ki ye unil wà kɛ yé Suf ŋa ŋmɔbe sɛn wɔ ń kɔ wà ŋa yé Suf den bii wɔ ń taan nin udaan. Ama min wɔn Uwien wuɔn' nni ki ye n la ye uba yé jɔknt ka kpɛ ń nɛkn wɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Nɛn bo nɛ ni yin' nni ma nnɔ, n baa', ka yìe'. N ji niireh nɛ nɛ, ni cinbe ki yin' nni bɛ bo?» ");
INSERT INTO gngNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Nɛ Kɔrnɛyi tɔke' wɔ ki ye: «Dɛtɔlbó ya tajuɔku tikur tuta ya yo, tɛn wu ya yo, n là te nʼden ki kàareh, nɛ ki laa' ujɛ uba i ya tàan bo, u se nʼnun bó ki guo tikpɛlcɛr tù windeh teen. ");
INSERT INTO gngNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Nɛ u tɔke' nni ki ye: ‹Kɔrnɛyi, Uwien teke' aʼkaare, ki tiɛre' a punh bijiinb mipum ma nnɔ bó. ");
INSERT INTO gngNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Nɛn bo, sɔn binib bɛ ń jo Yope ya du ni, kí tì yin ujɛ wà te niʼbó, bi yih wɔ Simɔn, ki baanh wɔ Piɛr nnɔ ní. U te ugbɔnjɛbl uba den nɛ, bi yih uʼmɔ Simɔn, uʼden te miñunciɛnm ya gbaal.› ");
INSERT INTO gngNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","U tɔke' nni ma nnɔ, i ya tàan bo, nɛ n sɔn' bɛ ń tì yin ŋɛ ní. A baa' ma nɔ, nì mɔn. Fɛnfɛnnɔ, tiʼkɛ te niɛ saan Uwien ya nun bó nɛ, ki yíe tí cii tigbɛr tà kɛ u tɔke' ŋɛ á lá tɔke tɛ nnɔ.» ");
INSERT INTO gngNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Nɛ Piɛr len' ki ye: «Imɔ̀n nɛ, fɛnfɛnnɔ n bɛnde' ki ye Uwien ŋa yíe uba ki cɛn' utɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Inibol kɛ ni, unil te ki boh Uwien, ki teh nà cuube la, Uwien ya yɛnm sɔnge uʼbo nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ni bɛn tigbɛmɔnmɔnt tà Uwien cère' Israyɛl yaab cii' tù nnɔ. Tù yé tigbɛr tà cère' Uwien nin binib taan' buñɔbu kí ñɛ *Yesu Kristo wà yé unil kɛ ya Yonbdaan nnɔ bo nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Ki bɛn San là kpaandeh uyo wà ki teh binib ń lèbre biʼtetem wɔ ń sìi bɛ Uwien ya ñunm nnɔ gɛ̀bre' ma nnɔ, nibonn nà tien', ki cin' Galile ya tinfɛnm ni ki tì baa' Sude ya tinfɛnm kɛ ni. ");
INSERT INTO gngNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ki bɛn mɔ ki ye Uwien cère' *Mifuoñaanm te Nasarɛt ya *Yesu bo, ki de' wɔ mituɔm. U là cuonh niʼkɛ saan nɛ ki teh nà mɔn, ki cèreh binib bà kɛ usɛnpol jɛ̀ndeh bɛ nnɔ faakreh, kimɛ Uwien là te nin wɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","U tien' tibont tà kɛ *Sufmbɛ ya du ni nin Yerusalɛm ni nnɔ, tinbi nɛ yé tuʼmɔ̀nkunb. U ya *Yesu nɛ bi kpɛ' wɔ udɔpɔnpɔn bo, ki ku' wɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ama wɔn nɛ, Uwien mɛkre' wɔ wienta daali bitɛnkpiib ni, ki cère' binib laa' wɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Wa cère' udu ya nib kɛ laa' wɔ, ama Uwien gɛ̀nde' tinbi bà uyoyo ti yé bimɔ̀nkunb nnɔ, u cère' tinbi nɛ laa' wɔ. U mɛkre' bitɛnkpiib ni ma nnɔ, tinbi nin wɔn nɛ taan' ki jin', ki ñun'. ");
INSERT INTO gngNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","U tɔke' tinbi nɛ ki ye tí li kpaandeh ki tɔkeh udu ya nib uʼgbɛr, kí li yé uʼmɔ̀nkunb ki ye Uwien gɛ̀nde' wɔn nɛ, wɔ ń bu binifuob nin bitɛnkpiib kɛ tibuur. ");
INSERT INTO gngNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","*Uwien ya ñɔbonsɔknb kɛ là kun' wɔn *Yesu bo imɔ̀n ki ye wà kɛ teke' wɔ ki jin' la, Uwien li fère udaan uʼbiɛre uʼyel bo.» ");
INSERT INTO gngNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Piɛr laan biɛ ki lienh, nɛ *Mifuoñaanm jiire' ní binib bà kɛ cengeh u lienh tigbɛr tà nnɔ bo. ");
INSERT INTO gngNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Nɛ *Sufmbɛ bà teke' *Yesu ki jin' ki pìɛre' Piɛr nnɔ, laa' Uwien de' bà ŋa yé *Sufmbɛ nnɔ mɔ *Mifuoñaanm nɛ nì cuo' bɛ miyɔkm. ");
INSERT INTO gngNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Bi cii' bi lienh ilenbol ki pɛ̀kɛh Uwien. Nɛn saan nɛ Piɛr len' ki ye: ");
INSERT INTO gngNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","«Uwien de' binib biɛ mɔ *Mifuoñaanm tɛn tinbi ma nɔ, ŋmɛ ji li fre kí ye bi la sìi bɛ Uwien ya ñunm-i?» ");
INSERT INTO gngNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Nɛ ki de' usɛn bi sìi' biʼkɛ Uwien ya ñunm, *Yesu Kristo ya yel bo. Nɛn saan nɛ bi gbáan' Piɛr ki ye wɔ ń tien biʼsaan iwenkàankɛ kí pukn. ");
INSERT INTO gngNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","*Yesu ya tondb nin Sude ya tinfɛnm yaab bà kɛ teke' *Yesu ki jin' nnɔ cii' bà ŋa yé *Sufmbɛ mɔ teke' Uwien ya gbɛr ki jin'. ");
INSERT INTO gngNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Piɛr liɛbe' ní Yerusalɛm u yo wà nnɔ nɛ *Sufmbɛ bà teke' *Yesu ki jin' nnɔ findeh nin wɔ ");
INSERT INTO gngNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","ki teh: «Bɛ tien' a kɔn' bà ŋa yé *Sufmbɛ den, ki jin' nin bɛ tijier-i?» ");
INSERT INTO gngNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Nɛn saan nɛ Piɛr taa' tigbɛr cin' ma bo, ki tɔke' bɛ tù tentien' ma bo ki ye: ");
INSERT INTO gngNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","«N là te Yope ya du ni ki kàareh, nɛ ki laa' nibonn niba tidɛknt yaam, nì ñɛn' ní kutaaku bo, ki naan bukpɛlbu ki piɛ, bi co niʼñɔgbɛn inan, nì jiinh ní ki lá nɛkn' nni. ");
INSERT INTO gngNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","N liike' nɛ̀ mɔnmɔnm, nɛ ki laa' itàan inan ya wɛnt kɛ ya bol nin kumuɔku ni ya wɛnt kɛ ya bol nin tiwɛnt tà fuunh kubenku bo kɛ ya bol nin inuɔn kɛ ya bol te nibonn nnɔ bo. ");
INSERT INTO gngNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Nɛ n cii' uniɛke uba bó u tɔke' nni ki ye: ‹Piɛr, fii kí ku kí ŋmɔn.› ");
INSERT INTO gngNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Nɛ n ye: ‹Kayi, Yonbdaan, n tì fii' ma, nibonn nà yé likuɔl ki yé tijɔknt ya bonn ŋa laan kɔn' nʼñɔbu ni fiebu.› ");
INSERT INTO gngNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Nɛ uniɛke nnɔ tí len' kutaaku bo ki ye: ‹Uwien mɔnge' nà la, la ye nì yé jɔknt.› ");
INSERT INTO gngNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Uniɛke nnɔ ye nnɔ bolm mita, nɛ niʼkɛ liɛbe' ki don' kutaaku. ");
INSERT INTO gngNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Nɛ i ya tàan bo, bijɛb bita baa' ní ti te iden yà nnɔ ya nañɔbu saan. Bi sɔn' bɛ Sesare ya du bó ní nɛ bɛ ń lá yin nni. ");
INSERT INTO gngNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Nɛ *Mifuoñaanm tɔke' nni ki ye ń paan biʼbo, ki la ŋmɔbe gɛ̀ngɛ̀nde. Nɛ tiʼninjiɛb biluob biɛ nɔ pìɛre' nni, ti tì baa' ki kɔn' ujɛ nnɔ den, ");
INSERT INTO gngNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","nɛ u tɔke' tɛ u laa' Uwien ya tond uba baa' uʼden ma bo, ki tɔke' wɔ ki ye wɔ ń sɔn binib bɛ ń jo Yope ya du ni, kí tì yin ujɛ wà bi yih wɔ Simɔn, ki baanh wɔ Piɛr nnɔ ní. ");
INSERT INTO gngNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","U li tɔke wɔ tigbɛr tà li cère wɔn nin uʼden yaab kɛ ń ŋmɛre. ");
INSERT INTO gngNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","N cin' n li lienh, nɛ *Mifuoñaanm pɔk ki jiire' ní biʼbo tɛn mì là jiire' ní tiʼbo micincinm ma nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Nɛn saan nɛ n tiɛre' Yonbdaan là tɔke' tɛ liñɔbonl là nnɔ. U là ye: ‹San là taa' miñunm nɛ ki sìi' binib Uwien ya ñunm, ama ninbi wɔn, n li cère *Mifuoñaanm nɛ ń jiire ní niʼbo.› ");
INSERT INTO gngNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Uwien de' tinbi bà teke' Yonbdaan *Yesu Kristo ki jin' bupaabu bùa nnɔ, u de' biʼmɔ bu ya paabaabu nɛ. Min yé ŋmɛ nɛ kí fre kí pien Uwien u la tien u yíe ma?» ");
INSERT INTO gngNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","*Sufmbɛ nnɔ cii' Piɛr len' nnɔ ma nnɔ, nɛ ba ji finde' nin wɔ. Bi pɛ̀ke' Uwien, nɛ ki tɔke' ki ye: «Imɔ̀n, Uwien nɛ mɔnbe ki cère' bà ŋa yé *Sufmbɛ nnɔ mɔ lèbre' biʼtetem ki laa' limiɛl.» ");
INSERT INTO gngNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Tɔ, bi ku' Etiɛnn uyo wà nnɔ, nɛ bi cin' ki jɛ̀ndeh binib bà teke' *Yesu ki jin', nɛ bi yɛre' niʼkɛ saan, ki tì baa' Fenisi ya tinfɛnm nin Ciip nin Antiyɔk ya du ni, ki tɔkeh *Sufmbɛ baba *Yesu ya gbɛr. ");
INSERT INTO gngNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ama biʼni bà yé Ciip nin Sirɛnn yaab nnɔ baa' Antiyɔk ya du ni, nɛ ki cin' ki tɔkeh bà ŋa yé *Sufmbɛ nnɔ mɔ Yonbdaan *Yesu ya gbɛmɔnmɔnt. ");
INSERT INTO gngNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Bi là ŋmɔbe Yonbdaan ya tuɔm nɛ. Nɛn bo nɛ binib teke' Yonbdaan ki jin', ki lèbre' biʼtetem, ki paan' uʼsɛn bo ki yɛbe. ");
INSERT INTO gngNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Tigbɛr nnɔ lu' *Kristo ya taanl yaab bà te Yerusalɛm ni nnɔ ya tubl ni, nɛ bi sɔn' Banabas Antiyɔk ya du bó. ");
INSERT INTO gngNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","U tì baa' ki laa' Uwien tien' bɛ tinimɔ̀nt ma nnɔ nɛ uʼyɛnm sɔnge' ki gbien'. Nɛ u saake' biʼkɛ ya gbɛnɛnt ki ye bɛ ń li pɛ Yonbdaan ya sɛn bo nin inunmɔ́n. ");
INSERT INTO gngNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banabas là yé unimɔ̀n nɛ, ki teke' *Yesu ki jin', nɛ *Mifuoñaanm te uʼbo. Nɛn bo nɛ binib là teke' Yonbdaan ki jin' ki yɛbe ki pukn' uʼbó. ");
INSERT INTO gngNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Ni ya puoli bó nɛ Banabas bure' Tars ya du bó wɔ ń tì nuun Sɔl. ");
INSERT INTO gngNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","U tì laa' wɔ, nɛ ki taa' wɔ ki baa' Antiyɔk ya du ni. Banabas nin Sɔl tien' len libinŋmɛnl nɛ ki te Kristo ya taanl yaab ni ki wɔkn' linigol Uwien ya gbɛr. Bi cin' ki yin' binib bà teke' Yesu ki jin' «Kristo yaab» Antiyɔk ya du ni nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","U ya yo nɛ *Uwien ya ñɔbonsɔknb biba ñɛn' Yerusalɛm, ki baa' Antiyɔk ya du ni. ");
INSERT INTO gngNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Bi yih uba Agabus. U fii' ki sere', nɛ *Mifuoñaanm cère' u len' ki ye mikònciɛnm miba li lu utingbɛn kɛ bo. (Mikònciɛnm nnɔ mɔnbe ki lu' ubɛrciɛn Klod ya yo nɛ.) ");
INSERT INTO gngNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Agabus len' nnɔ ma nnɔ nɛ bà teke' *Yesu ki jin' nnɔ ye unil kɛ ń de u li fre kí de nà, bɛ ń taa kí tì tore bi ya tɔb bà te Sude ya tinfɛnm ni nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Biʼkɛ de', nɛ bi taa' ki sɔn' Banabas nin Sɔl bɛ ń tì de *Kristo ya taanl ya ciɛnb bà te Sude ni nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","U ya yo nɛ ubɛr Herod cin' ki jɛ̀ndeh *Kristo ya taanl yaab biba. ");
INSERT INTO gngNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","U cère' bi ku' San ya ninjɛ Saak nin kijusiek. ");
INSERT INTO gngNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","U tien' nnɔ, ki laa' nì ŋmaake' Sufmbɛ, nɛ u cère' bi tí cuo' Piɛr mɔ. Nì là yé uyo wà *Sufmbɛ jeleh kunacenku kùa bi ŋmɔnh kpɔnɔ wà ŋa ŋmɔbe ñɔke nnɔ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Bi cuo' wɔ ma nnɔ nɛ ki taa' wɔ ki tì pɛkn'. Nɛ ki cère' Sojambɛ icɛk inan gu wɔ. Cɛkl kɛ cɛkl ŋmɔbe sojambɛ binan nɛ. Herod yíe *Sufmbɛ ya Pak ń gɛ̀bre ŋɔ nɛ wɔ ń ñɛn Piɛr kí bu wɔ tibuur udu ya nib ya nun bó. ");
INSERT INTO gngNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Piɛr te lipɛkl ni ma nnɔ nɛ *Kristo ya taanl yaab mɔ te ki kàareh Uwien nin inunmɔ́n, ki dienh wɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Tɔ, kutaaku kùa li faa ŋɔ Herod ń ñɛn Piɛr kí bu wɔ tibuur nnɔ ya ñɔnku ki laa' Piɛr dɔ sojambɛ bile ya siik ni nɛ ki gɔh, ki lùo tikudɔkr tule. Biguguurb mɔ se bunañɔbu saan ki gu. ");
INSERT INTO gngNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Nɛ Yonbdaan Uwien ya tond uba pɔk ki puɔ' nɛ uʼwenwenku wende' kuduku nnɔ ni. U ñi' Piɛr ya kɛle ni ki fìnde' wɔ, nɛ ki tɔke' wɔ ki ye: «Fii tonm», nɛ tikudɔkr nnɔ lore' uʼnuɔ ni ki lu'. ");
INSERT INTO gngNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Nɛ utond nnɔ tí tɔke' wɔ ki ye: «Gbin aʼningbɛnl, kí cɛke aʼtacaan.» Piɛr tien' nnɔ, nɛ u tí ye: «Gole aʼliɛrgbenku kí paan nʼbo ní.» ");
INSERT INTO gngNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Nɛ Piɛr paan' uʼbo ki ñɛh, ki maaleh ki teh nì yé tidɛknt nɛ. Wa maaleh ki teh utond nnɔ tien' nà nnɔ mɔnbe ki yé imɔ̀n nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Bi ñɛh ma nnɔ nɛ ki gɛ̀bre' uguguurl uba, ki tí gɛ̀bre' ulie, ki tì baa' tikur ya nagɛnku kùa pi saali ya nañɔbu nnɔ. Kunagɛnku nnɔ pìire' kuʼba, nɛ bi ñɛn', ki kpìen' usɛn uba ki cuon' waamu, nɛ utond nnɔ pɔk ki bure' ki dàan' wɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Nɛn saan nɛ Piɛr ya nun bó wende', nɛ u ye: «Fɛnfɛnnɔ nɛ n bɛnde' ki ye nì yé tigbɛmɔ̀nt. Yonbdaan nɛ mɔnbe ki sɔn' uʼtond ní u lá fie' nni Herod ya nuɔ ni, ki ñɛn' nni *Sufmbɛ yíe bɛ ń tien nni nà nnɔ ni.» ");
INSERT INTO gngNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Piɛr cii' nà tien' wɔ nnɔ ya tingi, nɛ ki bure' San wà bi baanh wɔ Mark nnɔ ya naa Mari donbó. Binib taan' niʼsaan ki kàareh ki yɛbe. ");
INSERT INTO gngNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","U tì baa', ki ñi' saali ya nagɛnku, nɛ upiitonsɔnl uba baa' ki lá liike' udaan wà ñih. Bi yih upii nnɔ Loda. ");
INSERT INTO gngNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","U bɛnde' Piɛr ya niɛke, uʼyɛnm sɔnge ki gbien' nɛ wa pìire, ki sɛn' ki liɛbe' uʼtɔb saan, ki tì tɔke' bɛ ki ye Piɛr nɛ se bunañɔbu saan saali. ");
INSERT INTO gngNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","U len' nnɔ ma nnɔ, nɛ bi tɔke' wɔ ki ye u waare' nɛ. Nin nɛn kɛ u ñiikeh ki teh nì yé imɔ̀n nɛ. Nɛ bi tɔke' wɔ ki ye nì lii yé Uwien ya tond wà gu wɔ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Piɛr biɛ ki se ki ñih kunagɛnku, bi pìire' ki laa' wɔn nɛ, nɛ nì bɛke' bɛ cɛɛn. ");
INSERT INTO gngNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Nɛn saan nɛ u yuon' uʼnuɔ ki wuɔn' bɛ ki ye bɛ ń ŋmile. Bi ŋmile' nɛ u tɔke' bɛ Yonbdaan tien' ma ki ñɛn' wɔ lipɛkl ni, nɛ ki len' ki pukn' ki ye bɛ ń jo kí tì tɔke Saak nin bi ya tɔb tigbɛr nnɔ. Nɛ ki ñɛn' ki bure' niba bó. ");
INSERT INTO gngNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Nì faa' uyo wà nnɔ, nɛ sojambɛ nnɔ ya yɛnm saa' ki gbien', nɛ bi niireh tɔb ki teh Piɛr wuɔ nín tien' mila? ");
INSERT INTO gngNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Nɛn saan nɛ Herod cère' bi nuun' wɔ. Bi nuun' wɔ, ka laa', nɛ u yin' biguguurb nnɔ, ki niire' bɛ tigbɛr nnɔ, nɛ ki cère' bi ku' bɛ, nɛ ki siere' Sude ya tinfɛnm ni, ki bure' Sesare ya du bó, ki tì tien' niʼbó idɛn ile. ");
INSERT INTO gngNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herod ya benku ni piebe' Tir nin Sidɔn ya nib bo ki gbien'. Nɛ biʼkɛ kpaan' buñɔbu bɛ ń jo kí lɛ wɔ. Bi kpiɛ' ki laa' ujɛ uba nɛ bi yih wɔ Blatus, wɔn nɛ gu Herod ya dugɔkaaku. Wɔn nin bɛn kpaan' tù ŋɔ wɔ ń cuo ubɛr ya dunl tigbɛr nnɔ ń gben nɛ, kimɛ tijier ñɛh Herod ya du ni nɛ ki bàareh biʼdu ni. ");
INSERT INTO gngNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Bi sien' lidaali là bɛ ń cende tɔb nnɔ baa', nɛ Herod gole' uʼbɛrliɛrl, ki kɛ̀le' uʼbɛrbiɛk bo, nɛ ki cin' ki lienh binib kɛ ya nun bó. ");
INSERT INTO gngNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","U lienh ma nnɔ, nɛ biʼkɛ wuureh ki teh: «Nì yé Uwien ya niɛke nɛ, na yé nisaal yu.» ");
INSERT INTO gngNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Nɛ Yonbdaan ya tond uba pebe' wɔ i ya tàan bo, ki cère' iwìɛn iba ya bol lu' uʼbo, nɛ ininbiɛb ŋmɔnh wɔ u tì kpo', kimɛ wa kpiɛke' Uwien. ");
INSERT INTO gngNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","U ya yo nɛ Uwien ya gbɛr tùɔre' ki yɛre' ki gbe niʼkɛ saan. ");
INSERT INTO gngNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Banabas nin Sɔl bɛn wɔn, bi là taa' mipum ki tì de' *Kristo ya taanl ya ciɛnb Yerusalɛm ni ma nnɔ, nɛ ki taa' San wà bi baanh wɔ Mark nnɔ, ki liɛbe' ki jon' Antiyɔk ya du bó. ");
INSERT INTO gngNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","*Kristo ya taanl yaab bà te Antiyɔk ya du ni nnɔ, *Uwien ya ñɔbonsɔknb nin *Yesu ya gbɛr ya wɔnwɔknb te biʼni. Bɛn si: Banabas nin Simeyɔn, bi baanh wɔ unibɔn nin Lusiyus, u yé Sirɛnn ya du ya nil nin Manayɛnn, bi taan' ki wube' wɔn nin Herod Antipas nɛ. Utɔ si Sɔl. ");
INSERT INTO gngNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Lidaali liba nɛ bi lòle' buñɔbu ki taan' bùol liba ki dondeh Yonbdaan, nɛ *Mifuoñaanm tɔke' bɛ ki ye: «Bore nni mɛn Banabas nin Sɔl biʼba, bɛ ń sɔn n yin' bɛ lituonl là bo nnɔ.» ");
INSERT INTO gngNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Bi lòle' buñɔbu ki kàare' ki tì gben' ma nnɔ, nɛ ki taa' biʼnuɔ ki paan' Banabas nin Sɔl bo, ki cɛ̀be' bɛ bi bure'. ");
INSERT INTO gngNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Tɔ, *Mifuoñaanm sɔn' Banabas nin Sɔl ma nnɔ, nɛ bi bure' ki tì baa' Selusi ya du ni, ki kɔn' buñɛrciɛnbu, ki bure' Ciip ya dekl bó. ");
INSERT INTO gngNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Bi tì baa' lidekl nnɔ ya du uba ni bi yih wù Salaminn, nɛ ki kɔh *Sufmbɛ ya táan ya dur ni ki tɔkeh binib Uwien ya gbɛr. San Mark mɔ là tɔke nin bɛ ki toreh bɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Bi cuon' ki càare' lidekl nnɔ kɛ, nɛ ki tì baa' ligbaatɔl ya du uba ni, bi yih wù Pafos, ki cende' ujɛ uba, u yé uñɔkdaan, ki yé utonnɛnñɔbonsɔknl. U yé Suf nɛ, bi yih wɔ Bar Yesu. ");
INSERT INTO gngNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Uñɔkdaan nnɔ là te lidekl nnɔ ya gobina saan nɛ, u yé ununwiendaan, uʼyel si Sɛgiyus Pɔlus. U ciɛke wɔ ń cii Uwien ya gbɛr, nɛ ki cère' bi yin' Banabas nin Sɔl ní. ");
INSERT INTO gngNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Bar *Yesu nnɔ ya yetɔl si Elimas nɛ. Grɛkmbɛ ya lenm ni Elimas ya tingi si uñɔkdaan nɛ. U jɛh Banabas nin Sɔl ya gbɛr, nɛ ki ñikndeh wɔ ń pien gobina nnɔ u la teke *Yesu kí ji. ");
INSERT INTO gngNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Nɛ *Mifuoñaanm cère' Sɔl, wà bi liɛbe' ki yih wɔ Pɔl nnɔ caan' Elimas bo inun, ");
INSERT INTO gngNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ki tɔke' wɔ ki ye: «Utonnɛndaan sin, aʼbiɛre nɛ yɛbre' nin ŋɛ, a yé usɛnpol ya bijɛ nɛ, ki nɛn nà kɛ mɔn. A nuunh á saa Yonbdaan ya gbɛmɔ̀nt kí tì kpaan mila nɛ? ");
INSERT INTO gngNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Fɛnfɛnnɔ, sin nin Yonbdaan nɛ kòle'. U li cère á juɔn tɛtɛli, ka ji li lɛnh bɔnbɔnl mɔnɔn kí tì baa uyo wà u yíe.» I ya tàan bo, nì tien' tɛn ligunl yaam ki bìike' uʼnun bó, nɛ u yekn' ki juɔn', ki tulnh ki nuunh wà li cuo uʼnuɔ kí diɛ wɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Gobina nnɔ laa' nì tien' nnɔ ma nnɔ, nɛ u teke' Yonbdaan ki jin', kimɛ Yonbdaan ya gbɛr tà bi wɔkn' wɔ nnɔ jin' wɔ cɛɛn. ");
INSERT INTO gngNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pɔl nin uʼtɔntɔknlieb kɔn' buñɛrciɛnbu Pafos ya du ni, ki bure' ki tì baa' Pɛje ya du ni, u te Panfili ya tinfɛnm ni. Nɛn saan nɛ San Mark dàan' bɛ ki liɛbe' Yerusalɛm. ");
INSERT INTO gngNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Pɔl nin Banabas bɛn siere' Pɛje ya du ni, ki bure' ki tì baa' Antiyɔk ya du ni, u te Pisidi ya tinfɛnm ni. *Saba ya daali, nɛ bi kɔn' ki kɛ̀le' biʼtaanl ya duku ni. ");
INSERT INTO gngNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Bi kaan' Moyis là kɛle' *yiko ya gbɔnku kùa nnɔ ni nin *Uwien ya ñɔbonsɔknb là kɛle' nà nnɔ ki gben', nɛ litaanl ya duku nnɔ ya ciɛnb sɔn' bɛ ń tì tɔke bɛ kí ye bi ŋmɔbe tigbɛr bɛ ń tɔke kí saake binib ya gbɛnɛnt la, bɛ ń tɔke. ");
INSERT INTO gngNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Nɛn saan nɛ Pɔl fii' ki sere' ki yuon' unuɔ ki len' ki ye: «Israyɛl yaab nin ninbi bà kɛ boh Uwien nnɔ, li cengeh mɛn. ");
INSERT INTO gngNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Tinbi Israyɛl ya bol ya Wien nɛ là gɛ̀nde' tiʼyaajɛb, ki cère' bi pɔ̀re' uyo wà bi là te Esipt ni nnɔ. Nɛ Uwien taa' uʼtuɔm ki ñɛn' bɛ uʼni. ");
INSERT INTO gngNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","U jɛ̀nde' nin bɛ kupenpelku ni ibin pinan nɛ, ");
INSERT INTO gngNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","ki yaan ki gben' inibol ilole yà là kɔ Kanaan ya tink bo nnɔ, ki taa' biʼtink nnɔ ki de' tɛ, kì kpɛnde' tiʼyaak. ");
INSERT INTO gngNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","«Kí ñɛ uyo wà Israyɛl yaab là kɔ Esipt ni nnɔ kí tì baa uyo wà Uwien de' bɛ Kanaan ya tink nnɔ, nì tien' tɛn ibin kobiinan nin piŋun nɛ. Ni ya puoli bó nɛ Uwien gɛ̀ndeh biʼni biba ki teh biʼsɛnlierb, ki ŋmɔŋmɔbe ki tì baa' uʼñɔbonsɔknl Samiɛl ya yo. ");
INSERT INTO gngNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","U ya yo nɛ bi ye bi yíe bɛ ń li ŋmɔbe ubɛr, nɛ Uwien gɛ̀nde' Kis ya bijɛ Sawul, u yé Bɛnsamɛn ya baamul ya nil ki tien' biʼbɛr. U yé biʼbɛr ki tì baa' ibin pinan, ");
INSERT INTO gngNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","nɛ Uwien ñɛn' wɔ libɛl ni, ki taa' *Dafid ki tien' biʼbɛr. Uwien len' wɔn *Dafid bo nɛ ki ye: ‹N laa' Yɛse ya bijɛ *Dafid, u yé unil wà nʼyɛnm sɔnge uʼbo nɛ. U li tien n yíe nà kɛ.› ");
INSERT INTO gngNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Uwien ñɛn' wɔn *Dafid ya yaabii ni nɛ *Yesu ki tien' Israyɛl yaab ya Ŋmiɛnl kí ñɛ u là pùon' lipuonl là nnɔ bo. ");
INSERT INTO gngNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","San liere' *Yesu usɛn ki baa' ki lá tɔke' Israyɛl yaab ki ye bɛ ń lèbre biʼtetem ŋɔ wɔ ń sìi bɛ Uwien ya ñunm. ");
INSERT INTO gngNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","San là benh wɔ ń gben uʼtuonl ma nnɔ, nɛ ki niire' bɛ ki ye: ‹Ni bɛn n yé ni maaleh ki teh n yé wà nnɔ nɛ-ɛɛ? Na te nnɔ, wɔn pɛ ní nʼpuoli bó nɛ, ama ma nín kpɛ ń lore uʼtacɛningbɛn mɔnɔn.› » ");
INSERT INTO gngNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Tɔ, nɛ Pɔl tí tɔke' bɛ ki ye: «Nʼyaab *Abraham ya yaabii nin bà ŋa yé *Sufmbɛ ki boh Uwien nnɔ, Uwien là cère' tinbi nɛ cii' tigbɛr tà li cère tí ŋmɛre nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Nin nɛn kɛ Yerusalɛm ya nib nin biʼbɛrb ŋa bɛnde' *Yesu yé udaan wà, ka cii' *Uwien ya ñɔbonsɔknb là len' nà, bi kàanh nɛ̀ *Saba kɛ Saba ya daali nnɔ ya tingi. Nɛn bo nɛ bi bun' *Yesu tibuur. *Uwien ya ñɔbonsɔknb là len' ki ye bi li tien nnɔ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ba laa' bi li dule nà bo kí ye u kpɛ mikuum. Nin nɛn kɛ bi miɛ' Pilat usɛn bɛ ń ku wɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Bi tien' wɔ nì kɛle' *Uwien ya gbɔnku ni ki ye bi li tien wɔ ma bo ki gben' ma nnɔ nɛ ki jiin' wɔ udɔpɔnpɔn bo, ki taa' wɔ ki tì sube'. ");
INSERT INTO gngNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ama Uwien cère' u mɛkre' bitɛnkpiib ni. ");
INSERT INTO gngNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","*Yesu cère' binib bà là pɛ uʼbo ki ñɛn' Galile ki lá baa' Yerusalɛm nnɔ laa' wɔ iwien yà yɛbe. Fɛnfɛnnɔ bɛn nɛ yé uʼmɔ̀nkunb udu ya nib ya nun bó. ");
INSERT INTO gngNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Tinbi mɔnɔn tɔkeh nɛ tu ya gbɛmɔnmɔnt nɛ ki teh Uwien là pùon' lipuonl ki de' tiʼyaajɛb nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","U tien' lipuonl nnɔ ki de' tinbi bà yé biʼyaabii nɛ; ki mɛkre' *Yesu tɛn nì kɛle' ma Uwien ya yuon ya gbɔnku ni, iyul ile, ki ye: ‹Sin nɛ yé nʼBijɛ. Dinnɔ nɛ n wuɔn' ki ye n yé aʼBaa.› ");
INSERT INTO gngNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Uwien cère' *Yesu mɛkre' bitɛnkpiib ni, ka ji li liɛbe len, ki niireh nin wɔ ń bùre. U là len' nɛn nɛ ki ye: ‹N li de nɛ tibont tà n là pùon' ki ye n li de tù *Dafid nnɔ, tù ñɛn' ní n ya bùol nɛ, ki kpɛ bɛ ń li du tuʼbo.› ");
INSERT INTO gngNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Nɛn bo nɛ nì tí kɛle' kugbɔnku nnɔ ni niba saan ki ye: ‹Ŋa ń cère aʼniñaan ń bùre.› ");
INSERT INTO gngNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","*Dafid là fuobe uyo wà nnɔ, u là yé Uwien ya tonsɔnl nɛ, ki teh Uwien yíe ma. U tì kpo', nɛ bi sube' wɔ uʼyaajɛb saan, u bùre'. ");
INSERT INTO gngNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","*Yesu wɔn, Uwien mɛkre' wɔ nɛ, wa bùre'. ");
INSERT INTO gngNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","Nʼyaabɛ, Moyis ya yiko ŋa là fre' ki bù' nɛ gbɛmɔ̀ndɛnb ama wa kɛ teke' *Yesu ki jin' la, Uwien li bù wɔ ugbɛmɔ̀ndaan nɛ. Ní li bɛn kí ye wɔn bo nɛ bi tɔkeh nɛ ki teh Uwien li fère nɛ niʼbiɛre. ");
INSERT INTO gngNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Tɔ, liike mɛn niʼyul bo ki la cère *Uwien ya ñɔbonsɔknb là len' nà nnɔ ń tu nɛ. Bi là len' ki ye: ");
INSERT INTO gngNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‹Ninbi bà yih bitɔb fɛnm nnɔ, liike mɛn, kí cère nɛ̀ ń ji nɛ ní juore fɛnm, kimɛ n li tien miyɔkm ya bonn niba, uyo wà ni laan fuobe, unil tɔke' nɛ lituonl nnɔ bó la, na ń teke kí ji.› » ");
INSERT INTO gngNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Pɔl nin Banabas ñɛh litaanl ya duku nnɔ ni uyo wà nnɔ, nɛ bi gbáan' bɛ ki ye *Saba wà we ní nnɔ ya daali, bɛ ń tí ń liɛbe ní, kí lá tɔke bɛ tu ya gbɛr. ");
INSERT INTO gngNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Litaanl nnɔ yaare' uyo wà nnɔ, nɛ *Sufmbɛ ligol nin binib bà yé Sufkpɛnkpɛnd ki pukeh Uwien nnɔ paan' Pɔl nin Banabas bo. Nɛ Pɔl nin Banabas tɔkeh bɛ ki teh Uwien juoke' bɛ ma nnɔ, bɛ ń li tuu ki pɛ uʼsɛn bo mɔnmɔnm. ");
INSERT INTO gngNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Tɔ, *Saba wà tuɔn' nnɔ ya daali, udu nnɔ ya nib bà yɛbe taan' bɛ ń cenge Yonbdaan ya gbɛr. ");
INSERT INTO gngNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","*Sufmbɛ ya ciɛnb laa' linigol nnɔ taan' ma nnɔ, nɛ bi ponbe' nin bɛ ki gbien', ki sukreh Pɔl, ki saah u tɔkeh tigbɛr tà nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Nin nɛn kɛ Pɔl nin Banabas laa' lifɛ̀l ki tɔke' bɛ ki ye: «Nì bi kpɛ tí kpiɛ kí tɔke ninbi nɛ Uwien ya gbɛr. Nɛ ni yìe', ka teke' tù, ki maale' ki ye na kpɛ ní lɛ limiɛl là ŋa ŋmɔbe gbenm. Nɛn bo nɛ ti li pekre bà ŋa yé *Sufmbɛ bó. ");
INSERT INTO gngNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Yonbdaan tɔke' tɛ nà sɔ. U ye: ‹N tien' sin nɛ kuwenwenku á li wende inibol kɛ, kí cère binib bà kɛ te utingbɛn bo ń ŋmɛre.› » ");
INSERT INTO gngNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Binib bà ŋa yé *Sufmbɛ nnɔ cii' bi len' nnɔ ma nnɔ, nɛ biʼyɛnm sɔnge' ki gbien', nɛ bi pɛ̀keh Yonbdaan ya gbɛr cɛɛn. Nɛ binib bà kɛ Uwien sien' ki ye bɛ ń lɛ limiɛl là ŋa ŋmɔbe gbenm nnɔ, teke' ki jin'. ");
INSERT INTO gngNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Nɛn saan nɛ Yonbdaan ya gbɛr yɛreh mitinfɛnm nnɔ kɛ ni. ");
INSERT INTO gngNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","*Sufmbɛ bɛn wɔn, bi cère' bipiikpɛkpiɛkb bà te udu nnɔ ni, ki pukeh Uwien nnɔ nin udu nnɔ ya ciɛnb kpre' Pɔl nin Banabas bo, ki jɛ̀nde' bɛ, nɛ ki ŋɔre' bɛ ki ñɛn' biʼdu ni. ");
INSERT INTO gngNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Pɔl nin Banabas kpakpaare' biʼtàan ya tɛngunku ki wiɛ' nɛ̀, nɛ ki bure' Ikoniyɔm ya du bó. ");
INSERT INTO gngNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Binib bà teke' *Yesu ki jin' Antiyɔk ya du ni nnɔ wɔn *Mifuoñaanm te biʼbo nɛ bi ŋmɔbe uyɛnsɔnge ki gbien'. ");
INSERT INTO gngNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Pɔl nin Banabas tì baa' Ikoniyɔm ya du ni, nɛ ki tien' bi bi tien' mà Antiyɔk ni nnɔ. Bi kɔn' *Sufmbɛ ya taanl ya duku ni ki tɔke' binib Uwien ya gbɛr. Nɛn bo nɛ *Sufmbɛ nin Grɛkmbɛ teke' ki jin' ki yɛbe. ");
INSERT INTO gngNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ama *Sufmbɛ biba tien' uyufaa, ka teke' ki jin', ki sure' bà ŋa yé *Sufmbɛ nnɔ bi kpre' binib bà teke' *Yesu ki jin' nnɔ bo, ki maaleh biʼbo nà bre. ");
INSERT INTO gngNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Nin nɛn kɛ Pɔl nin Banabas tien' udu nnɔ ni ki wuɔke'. Bi là ŋmɔbe lifɛ̀l ki lienh ki du Yonbdaan bo nɛ, nɛ u cèreh bi teh miyɔkm ya bont ŋɔ wɔ ń wuɔn kí ye bi tɔkeh uʼjuokm ya gbɛr tà nnɔ yé imɔ̀n nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Ama udu nnɔ ya nib ŋa len' ki cii' tɔb bó, nɛ ki gbiire' icɛk ile. Biba se *Sufmbɛ ya ciɛk bó, nɛ bitɔb mɔ se *Yesu ya tondb ya ciɛk bó. ");
INSERT INTO gngNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","*Sufmbɛ nin biʼciɛnb nin bà ŋa yé *Sufmbɛ nnɔ ya biba bonde' bi li tien *Yesu ya tondb ma, ki ye bi li jɛ̀nde bɛ nɛ, kí yèke bɛ itɛn kí ku bɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Pɔl nin Banabas cii' bi nuunh bɛ ń tien bɛ ma, nɛ ki sɛn' ki jon' Likawoni ya tinfɛnm ya du Lista nin Dɛbe nin idu nnɔ ya tengbaan ni. ");
INSERT INTO gngNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Nɛ ki tɔkeh niʼmɔ bó yaab tigbɛmɔnmɔnt nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ujɛ uba là te Lista ya du ni, uʼtàan faan wà ń fre kí fii kí sere. Bi maa' wɔ uwɔb nɛ, wa cuon' fiebu. ");
INSERT INTO gngNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Lidaali liba Pɔl lienh nɛ u cengeh. Pɔl caan' uʼbo inun, ki bɛnde' ki ye uʼtekjim li cère wɔ ń faake. ");
INSERT INTO gngNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Nɛ ki len' ufaa bo ki ye: «Fii kí sere.» Nɛ ujɛ nnɔ fii' ki maabe' ki ci', ki cin' ki cuonh. ");
INSERT INTO gngNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Linigol laa' Pɔl tien' nà nnɔ, nɛ ki wuure' Likawoni yaab ya lenm ni ki ye: «Ho! Ibule nɛ kpɛnde' binib ki baa' tiʼsaan-a!» ");
INSERT INTO gngNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Nɛ bi yin' Banabas *Seyus, ki yin' Pɔl Hɛrmɛs, kimɛ Pɔl nɛ sɔbe ki lienh. ");
INSERT INTO gngNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Ubul *Seyus nnɔ ya duku te udu nnɔ ya guon ya nañɔbu saan nɛ saali. Seyus ya tɔtuɔrkɛ tuke' ní inajɛ nin misipuum mà u tien' mɛ̀ uyukpɛkpiɛ yaam ki baa' iguon nnɔ ya nañɔbu saan, ki yíe wɔn nin linigol nnɔ ń tùɔre lituɔrl kí de Banabas nin Pɔl. ");
INSERT INTO gngNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Ama *Yesu ya tondb Banabas nin Pɔl cii' nnɔ ma nnɔ, biʼyɛnm saa' ki gbien', nɛ bi cuo' biʼliɛr ki kɛre', ki sɛn' ki kɔn' linigol nnɔ ya siik ni, nɛ ki wuureh ");
INSERT INTO gngNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","ki teh: «Tiʼjɔtiebɛ, bɛ bo nɛ ni teh niɛ ya bonn-i? Tiʼmɔ yé binib tɛn ninbi nɛ. Ti baa' ki tɔkeh nɛ tigbɛmɔnmɔnt nɛ ki teh niʼbule yii yé fɛnm nɛ, ní wiɛ yì ki paan' Uwien wà fuobe bo. Wɔn nɛ ñɛn' kutaaku nin kitink nin miñunciɛnm nin tibont kɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Uyo bo, u là cère' inibol kɛ pɛ ì yíe nà bo nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Nin nɛn kɛ wà dàan' mimɔnm ya tienm ŋɔ wɔ ń wuɔn binib u yé udaan wà. U cèreh utaa niih, tijier teh, ni jinh ki gbuokeh, ki te liwiel ni.» ");
INSERT INTO gngNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Nin *Yesu ya tondb len' nà kɛ nnɔ bi ñikn' nɛ ki tì pien' linigol nnɔ lì la tùɔre tuɔrl kí de bɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Nɛn saan nɛ *Sufmbɛ biba ñɛn' Antiyɔk nin Ikoniyɔm ya du bó ki baa' ní, ki lá sure' linigol nnɔ, ki cère' lì kpre' Pɔl nin Banabas bo, ki yèke' Pɔl itɛn, ki fuun' wɔ ki ñɛn' udu ni, ki maaleh ki teh u kpo' nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Binib bà teke' *Yesu ki jin' nnɔ baa' ki lá sere' ki guɔn' wɔ, nɛ u fii', ki liɛbe' ki kɔn' udu nnɔ ni. Kutaaku faa' nɛ Pɔl nin Banabas siere' ki jon' Dɛbe ya du bó, ");
INSERT INTO gngNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","ki tì tɔkeh niʼbó yaab tigbɛmɔnmɔnt nnɔ. Nɛ binib teke' tù ki paan' *Yesu ya sɛn bo ki yɛbe. Bi siere' ki liɛbe' Lista ya du nin Ikoniyɔm ya du nin Antiyɔk ya du wà te Pisidi ya tinfɛnm ni nnɔ ni. ");
INSERT INTO gngNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Bi gɛ̀breh idu nnɔ ni ma nnɔ, nɛ ki saakreh bà teke' *Yesu ki jin' nnɔ ya gbɛnɛnt, ki gbiereh bɛ ki teh bɛ ń li tuu ki ŋmɔbe mitekjim, ki tɔkeh bɛ ki teh ti li jɛ̀nde kí gbien nɛ kí yaan kí kɔ Uwien ya bɛl ni. ");
INSERT INTO gngNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Nɛn saan nɛ bi gɛ̀nde' *Kristo ya táan kɛ ni biciɛnb, nɛ ki lòle' buñɔbu, ki kàare' ki de' bɛ, ki taa' bɛ ki ŋukn' Yonbdaan wà bi teke' wɔ ki jin' nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Pɔl nin Banabas ñɛn' Pisidi ya tinfɛnm ni, nɛ ki jon' Panfili ya tinfɛnm ni. ");
INSERT INTO gngNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Bi tì baa' Pɛje ya du ni ki tɔke' udu nnɔ ya nib Uwien ya gbɛr, nɛ ki bure' Atali ya du bó. ");
INSERT INTO gngNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Bi tì baa', nɛ ki kɔn' buñɛrciɛnbu, ki puore' miñunciɛnm ki liɛbe' Antiyɔk ya du bó. U ya du ni nɛ *Kristo ya taanl yaab kàare' ki ye Uwien ń juoke bɛ bi sɔn' lituonl là nnɔ bo. ");
INSERT INTO gngNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Bi tì baa', nɛ ki taan' *Kristo ya taanl yaab, ki tɔke' bɛ Uwien cère' bi tien' tibont tà kɛ nnɔ nin u wuɔn' bà ŋa yé *Sufmbɛ mitekjim ya sɛn ma bo. ");
INSERT INTO gngNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Pɔl nin Banabas tien' binib bà teke' *Yesu ki jin' nnɔ saan ki wuɔke'. ");
INSERT INTO gngNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Tɔ, binib biba ñɛn' Sude ya tinfɛnm bó ní ki baa' Antiyɔk ya du ni, ki lá wɔknh binib bà teke' *Yesu ki jin' nnɔ ki teh: «Na jiɛ' niʼpun Moyis ya yiko ye ma bo la, Uwien ŋa ń ŋmiɛn nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pɔl nin Banabas ŋa tuo', nɛ ki finde' nin bɛ tigbɛr nnɔ bo ki gbien'. Nɛn bo nɛ biʼkɛ tuo' ki ye Pɔl nin Banabas nin binitɔb biba ń jo Yerusalɛm, kí tì lɛ *Yesu ya tondb nin uʼtaanl ya ciɛnb ifinfinde nnɔ bo. ");
INSERT INTO gngNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Nɛ *Kristo ya taanl yaab bà te Antiyɔk ni nnɔ pìɛre' bɛ. Bi joh ma nnɔ nɛ ki ñɛh binib bà teke' *Yesu ki jin', ki te Fenisi nin Samari ya tinfɛnm ni nnɔ saan, ki tɔkeh bɛ ki teh bà ŋa yé *Sufmbɛ mɔ lèbre' biʼtetem ki teke' *Yesu ki jin'. Nɛ nì sɔngreh biʼkɛ ya yɛnm ki gbiekeh. ");
INSERT INTO gngNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Bi tì baa' Yerusalɛm ni, nɛ *Kristo ya taanl yaab nin biʼciɛnb nin *Yesu ya tondb teke' bɛ kucɛ̀nku. Nɛ Pɔl nin Banabas tɔke' bɛ Uwien cère' bi tien' tibont tà kɛ nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","*Farisiɛnmbɛ ya cɛkl yaab bà lèbre' biʼtetem ki teke' *Yesu ki jin' nnɔ ya biba, fii' ki sere', ki len' ki ye bà ŋa yé *Sufmbɛ ki teke' *Yesu ki jin' nnɔ, nì kpɛ bɛ ń jiɛ biʼpun nɛ, kí li boh Moyis ya yiko. ");
INSERT INTO gngNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Nɛn saan nɛ *Yesu ya tondb nin uʼtaanl ya ciɛnb taan' bɛ ń liike bi li tien ma tigbɛr nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Bi finde' ki gbien' ma nnɔ, nɛ Piɛr fii' ki sere', ki tɔke' bɛ ki ye: «Nʼyaabɛ, ni bɛn ki ye Uwien gɛ̀nde' nni niʼni nì wuɔke' ŋɔ bà ŋa yé *Sufmbɛ ń cii uʼgbɛmɔnmɔnt nʼñɔbu ni, kí teke *Yesu kí ji nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Uwien bɛn binib ya fɛ̀l ni te ma bo, nɛ ki de' bɛ *Mifuoñaanm tɛn u là de' tiʼmɔ ma bo ŋɔ wɔ ń wuɔn bɛ, kí ye u gɛ̀nde' bɛ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Wa bore' tinbi nin bɛn, kimɛ mitekjim bo nɛ u sɔkre' biʼfɛ̀l bo ya jɔknt. ");
INSERT INTO gngNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Nì te nnɔ la, bɛ tien' fɛnfɛnnɔ ni dɛlkeh Uwien, ki wɔbndeh bɛ, bɛ ń tuke litukl là tinbi nin tiʼyaajɛb ŋa fre' ki tuke' lɛ̀? ");
INSERT INTO gngNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ama tinbi wɔn, Yonbdaan *Yesu ya juokm bo nɛ ti teke' wɔ ki jin' ki ŋmɛre'. Nì te nnɔ nɛ bà ŋa yé *Sufmbɛ mɔ ya bùol.» ");
INSERT INTO gngNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Piɛr len' ki gben', nɛ linigol nnɔ ŋmile', ki cengeh Banabas nin Pɔl li len kí ye bà. Nɛ bi cin' ki tɔkeh bɛ Uwien cère' bi tien' miyɔkm ya bont tà bà ŋa yé *Sufmbɛ ni nnɔ ma bo. ");
INSERT INTO gngNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Banabas nin Pɔl len' ki gben' ma nnɔ nɛ Saak mɔ ye: «Nʼyaabɛ, cenge mɛn. ");
INSERT INTO gngNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simɔn tɔke' tɛ Uwien cin' ki tien' ma bo. U gɛ̀nde' bà ŋa yé *Sufmbɛ mɔ ni binib ki tien' uʼyaab. ");
INSERT INTO gngNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Nì tien' tɛn *Uwien ya ñɔbonsɔknb là len' ma bo nɛ, kimɛ nì kɛle' *Uwien ya gbɔnku ni ki ye: ");
INSERT INTO gngNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‹Yonbdaan là len' ki ye: *Dafid ya den lu', n li liɛbe ní kí mɛ yì, N li liɛbe ní kí fin lilɛngbenl nnɔ kí cère iden nnɔ ń li se. ");
INSERT INTO gngNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Nɛn bo nɛ binib bà sìen' kɛ li nuun min Yonbdaan. Inibol yà kɛ n yin' yɛ̀, yɛ̀ ń li yé nʼyɛ nnɔ li nuun nni. Yonbdaan nɛ len' nnɔ, nɛ ki tien' tibont nnɔ kɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","U cère' binib bɛnde' tibont nnɔ haali uyo bo nɛ.› » ");
INSERT INTO gngNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Saak tí len' ki ye: «Nɛn bo nɛ n maale' ki ye nì mɔn ti la li wɔbndeh bà ŋa yé *Sufmbɛ, ki lèbre' biʼtetem ki paan' Uwien bo nnɔ nin tiʼyaajɛtentienm. ");
INSERT INTO gngNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Ama cère mɛn tí kɛle kugbɔnku kí tɔke bɛ kí ye: bi la li jinh bule ya jier, kimɛ tù yé tijɔknt nɛ, ki la teh naŋmaal, ki la ŋmɔnh wɛnkpil, ki la ji sɛ̀m. ");
INSERT INTO gngNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Kimɛ haali tiʼyaajɛb ya yo kí lá baa dinnɔ, Moyis ŋmɔbe binib bà wɔknh uʼyiko nɛ idu kɛ ni. Bi tuu ki kàanh wɔ nɛ *Saba kɛ *Saba ya daali *Sufmbɛ ya táan ya dur ni.» ");
INSERT INTO gngNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Nɛn saan nɛ *Yesu ya tondb nin uʼtaanl yaab kɛ nin biʼciɛnb gbiere' ki kpaan' ki gɛ̀nde' bijɛb biba biʼni ki pukn' Pɔl nin Banabas bó bɛ ń sɔn bɛ Antiyɔk ya du bó. Bi gɛ̀nde' Sudas wà bi baanh wɔ Basabas nin Silas nɛ. Bi yé binib bà bi boh bɛ *Kristo ya taanl yaab ni nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Bi de' bɛ kugbɔnku kùa nnɔ bi kɛle' kuʼni ki ye ma sɔ: «Tinbi *Yesu ya tondb nin *Kristo ya taanl ya ciɛnb, fuondeh tiʼyaab bà ŋa yé Sufmbɛ ki te Antiyɔk ya du ni nin Siri ya tinfɛnm ni nin Silisi ya tinfɛnm ni nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Ti cii' tiʼyaab biba jon' niʼsaan, ki tì tɔke' nɛ tigbɛr tà ŋaabeh niʼyɛnm ki dienh nɛ iyɛnmaale. Ta sɔn' bɛ bɛ ń tì tɔke nɛ gbɛr. ");
INSERT INTO gngNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Nɛn bo nɛ ti taan' ki kpaan' buñɔbu, ki gɛ̀nde' tiʼni binib, tí sɔn bɛ niʼsaan, bɛn nin Banabas nin Pɔl, tiʼyaab bà ti yíe bɛ nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Bi yé binib bà ŋa tɔnge' biʼmiɛl Yonbdaan *Yesu Kristo ya tuonl bo nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Ti sɔn' Sudas nin Silas, bɛ ń lá tɔke nɛ buñɔbu ni tigbɛr tà ti kɛle' tù kugbɔnku kuu ni nnɔ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","*Mifuoñaanm tore' tɛ ti kpaan' buñɔbu, ti la wɔbn nɛ kí de nɛ *yiko uba wɔ ń li yé niʼbo litukl kí pukn tibont tà yé niʼbo tibonmɔ̀nt nnɔ bó. Tun si: ");
INSERT INTO gngNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","ni la ŋmɔnh tɔtuɔrnɔnt, ki la jinh sɛ̀m, ki la ŋmɔnh wɛnkpil, ki la teh naŋmaal. Ni cuo' niʼba tu ya bont bo la, nɛn nɛ mɔn. Niʼyaam ń li ŋmɛ.» ");
INSERT INTO gngNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Tɔ, bi cɛ̀be' bi sɔn' binib bà nnɔ bi bure' Antiyɔk ya du bó. Bi tì baa' niʼbó, nɛ ki taan' *Kristo ya taanl yaab kɛ, ki taa' kugbɔnku nnɔ ki ŋukn' bɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Bi kaan' kù ma nnɔ, nɛ biʼkɛ ya yɛnm sɔnge', kimɛ kù saake' biʼgbɛnɛnt. ");
INSERT INTO gngNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Sudas nin Silas yé *Uwien ya ñɔbonsɔknb ma nnɔ, nɛ ki tɔke' bɛ tigbɛr tù yɛbe ki saake' biʼgbɛnɛnt bɛ ń li pɛ Uwien ya sɛn bo mɔnmɔnm. ");
INSERT INTO gngNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Bi wuɔke' niʼsaan waamu nɛ ki yaan binib bà teke' *Yesu ki jin' nnɔ cɛ̀be' bɛ bɛ ń liɛbe bà sɔn' bɛ nnɔ saan nin uyɛnduɔn. ");
INSERT INTO gngNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Silas wɔn juore' ki te Antiyɔk ya du ni nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pɔl nin Banabas mɔ juore' Antiyɔk ya du ni, ki tɔkeh nin binib bi yɛbe ki tì wɔknh binib, ki tɔkeh bɛ Yonbdaan ya gbɛr. ");
INSERT INTO gngNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Iwenkàankɛ gɛ̀bre', nɛ Pɔl tɔke' Banabas ki ye: «Cère tí liɛbe idu yà kɛ ni, ti là tɔke' binib Yonbdaan ya gbɛr nnɔ, kí tì fuonde binib bà teke' *Yesu ki jin' nnɔ kí liike bi ŋuuke uʼgbɛr ma bo.» ");
INSERT INTO gngNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Banabas là yíe wɔ ń tuke San wà bi liɛbe' ki yih wɔ Mark nnɔ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Ama Pɔl ŋa tuo' wɔ ń liɛbe kí tɔke nin San Mark, kimɛ u là siere' ki dàan' bɛ Panfili ya tinfɛnm ni, nɛ ka tore' bɛ biʼtùon ni. ");
INSERT INTO gngNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Pɔl nin Banabas finde' nin tɔb nì tì ben' ki fiire', nɛ wà kɛ taa' u ya bó. Nɛn saan nɛ Banabas taa' San Mark ki kɔn' buñɛrciɛnbu, ki bure' Ciip ya dekl bó. ");
INSERT INTO gngNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Nɛ Pɔl gɛ̀nde' Silas wɔ ń pìɛre wɔ. Binib bà teke' *Yesu ki jin' nnɔ kàare' Yonbdaan ki ye wɔ ń juoke bɛ, nɛ bi bure', ");
INSERT INTO gngNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","ki ñɛh *Kristo ya táan yà te Siri nin Silisi ya tinfɛnm ni nnɔ saan, ki cèreh iʼnib faakreh mitekjim ni. ");
INSERT INTO gngNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pɔl nin Silas tì baa' Dɛbe nin Lista ya du ni, ki laa' ujɛ uba teke' *Yesu ki jin' ki te mifɛnm nnɔ, bi yih wɔ Timote. Uʼnaa yé Suf nɛ, ki teke' *Yesu ki jin', nɛ uʼbaa yé Grɛk. ");
INSERT INTO gngNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Binib bà teke' *Yesu ki jin' ki te Lista nin Ikoniyɔm ya du ni nnɔ kɛ pɛ̀keh Timote nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pɔl yíe Timote ń pìɛre wɔ. *Sufmbɛ bà te niʼsaan nnɔ bo nɛ u jiɛ' Timote ya punl, kimɛ *Sufmbɛ nnɔ kɛ bɛn ki ye Timote ya baa yé Grɛk nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Bi cuonh ki ñɛh idu ni ma nnɔ, nɛ ki tɔkeh binib bà teke' ki jin' ki te iʼni nnɔ, *Yesu ya tondb nin uʼtaanl yaab ya ciɛnb bà te Yerusalɛm ni ñɛn' isɛn yà nnɔ, nɛ ki sureh bɛ bɛ ń li pɛ iʼbo. ");
INSERT INTO gngNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Nɛn bo nɛ *Kristo ya táan yaab faakreh mitekjim ni, nɛ binitɔb teknh wɔ ki jinh ki pukndeh biʼbó daan kɛ daan. ");
INSERT INTO gngNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","*Mifuoñaanm pien' Pɔl nin uʼtɔntɔknlieb bi la tɔke Uwien ya gbɛr Asi ya tinfɛnm ni. Nɛn bo nɛ bi gɛ̀bre' Friji nin Galasi ya tinfɛnm, ");
INSERT INTO gngNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","ki tì baa' Misi ya tinbiɛn, ki maaleh bɛ ń jo Bitini ya tinfɛnm ni, nɛ *Yesu ya Fuoñaanm ŋa de' bɛ sɛn. ");
INSERT INTO gngNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Nɛn saan nɛ bi gɛ̀bre' Misi ya tinfɛnm, ki tì baa' Trowas ya du ni. ");
INSERT INTO gngNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Kuñɔnku nɛ Pɔl laa' Maseduɔnn ya tinfɛnm ya jɛ uba tidɛknt yaam, u se uʼsaan ki gbáanh wɔ ki teh wɔ ń baa ní Maseduɔnn kí lá tore bɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pɔl laa' Maseduɔnn ya jɛ nnɔ tidɛknt yaam ma nnɔ, nɛ ti pɔk ki bonde' i ya tàan bo, tí jo Maseduɔnn ya tinfɛnm bó, kimɛ ti bɛnde' ki ye Uwien nɛ yin' tɛ niʼbó tí tì tɔke uʼgbɛmɔnmɔnt. ");
INSERT INTO gngNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Nɛn saan nɛ ti kɔn' buñɛrciɛnbu Trowas ya du ni, ki cubn' Samotras ya dekl bó. Kutaaku faa' nɛ ti bure' Neyapoli ya du bó. ");
INSERT INTO gngNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Nɛ ki ñɛn' nɛn saan, ki jon' Filip ya du bó; u yé Maseduɔnn ya tinfɛnm ya ducɛnciɛn nɛ. Erom yaab nɛ ŋuuke udu nnɔ. Ti tien' uʼni iwenkàankɛ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","*Saba ya daali, nɛ ti ñɛn' udu nnɔ ni, ki jon' ukpen uba ya gbaal. Ti maale' ki ye *Sufmbɛ taakeh nà saan ki kàareh lii te nɛ̀ nɛ. Ti laa' bipiib biba taan' niʼsaan, nɛ ti kɛ̀le' ki tɔke' bɛ Uwien ya gbɛr. ");
INSERT INTO gngNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Upii uba là te biʼni, bi yih wɔ Lidi. U yé Tiyatiir ya du ya pii nɛ, ki pukeh Uwien, ki kuɔreh ikpɛlde ì mɔn ki yé imɔ́nmɔ́n. Yonbdaan cìbre' uʼyɛnm ki cère' u cenge' mɔnmɔnm, ki tuo' Pɔl len' nà nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Ti sìi' wɔn nin uʼden yaab kɛ Uwien ya ñunm ma nnɔ, nɛ u tɔke' tɛ ki ye: «Ni tuo' ki ye n mɔnbe ki teke' Yonbdaan ki jin' la, dɛn mɛn, kí li te nʼden.» Nɛ ki cɛ́kn' tɛ ti tuo'. ");
INSERT INTO gngNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Lidaali liba nɛ ti tí là joh bi taakeh nà saan ki kàareh nnɔ. Nɛ ujɛfaan uba cende' tɛ usɛn ni, ki yé uyonb; ki ŋmɔbe ipol iba, ki tɔkeh binib nà li wun ń tien. U teh nnɔ nɛ ki lɛnh lifaal lì yɛbe ki dienh uʼcɛnbaambɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","U paan' tinbi nin Pɔl bo ki wuureh ki teh: «Binib biɛ nɔ yé Uwien wà ŋa ŋmɔbe Nacentɔ ya tonsɔnb nɛ. Bi tɔkeh nɛ ni li kpìen usɛn wà kí ŋmɛre nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","U teh nnɔ nɛ idaan kɛ, Pɔl ya benku ni tì piebe', nɛ u jiɛbe' ki tɔke' ipol nnɔ ki ye: «Yesu Kristo ya yel bo, siere mɛn uʼsaan.» Nɛ ì siere' uʼsaan i ya tàan bo. ");
INSERT INTO gngNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Tɔ, ujɛfaan nnɔ ya cɛnbaambɛ laa' ba ji li fre kí lɛ faal uʼbo, nɛ bi cuo' Pɔl nin Silas, ki tuke' bɛ ufaa bo ki jon' udu nnɔ ya nib taakeh nà saan nnɔ, ŋɔ uʼciɛnb ń bu bɛ tibuur. ");
INSERT INTO gngNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Nɛ ki taa' bɛ ki wuɔn' Erom yaab ya buur ya ciɛnb ki ye: «Binib biɛ nɔ yé *Sufmbɛ nɛ, ki tuke' fɛnfɛnm ki baa' tiʼdu ni, ");
INSERT INTO gngNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","ki wɔknh mitetem mà ŋa kpɛ tinbi Erom yaab ń tuo mɛ̀, ki niireh nin tí paan miʼbo.» ");
INSERT INTO gngNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Bi len' nnɔ ma nnɔ nɛ linigol kpre' biʼbo. Tibuur yaab nnɔ dɛre' ki gore' Pɔl nin Silas ya wɛnt, nɛ ki ye bɛ ń ñì bɛ ilɛnbɛn. ");
INSERT INTO gngNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Bi ñi' bɛ cɛɛn, nɛ ki taa' bɛ ki tì pɛkn', ki tɔke' wà gu lipɛkl nnɔ ki ye wɔ ń li gu bɛ mɔnmɔnm. ");
INSERT INTO gngNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Bi tɔke' wɔ ma nnɔ nɛ u kuɔn' bɛ lipɛkl ya dubenku ni, ki taa' biʼtàan ki sɛkn' idɔ ya ŋmɔbe ibon ni, ki lòle' ki mɔkn' yì. ");
INSERT INTO gngNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Nì tì tuo kuyɔku, nɛ Pɔl nin Silas te ki kàareh, ki gɛh iyuon ki pɛ̀keh Uwien, nɛ lipɛkl ya nitɔb cengeh biʼbó. ");
INSERT INTO gngNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Nɛ kitink jènge' i ya tàan bo ki gbien', ki cère' lipɛkl ya duku ya tɛnpuul mɔ jènge', nɛ liʼnagɛnt kɛ pìpìire'. Tikudɔkr tà lùo lipɛkl ya nib nnɔ kɛ cecere'. ");
INSERT INTO gngNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Wà gu lipɛkl nnɔ fìnde', ki laa' tinagɛnt yɛyɛ ma nnɔ, nɛ u nɛ̀re' uʼjusiek wɔ ń ku uʼba, ki maaleh ki teh lipɛkl ya nib nnɔ kɛ ñɛn' ki sɛnsɛn' nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Nɛ Pɔl tiɛn' uʼbo ki ye: «La tien aʼba nà bre, tiʼkɛ te niʼsaan.» ");
INSERT INTO gngNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Wà gu lipɛkl nnɔ ye bɛ ń taa umu ní, nɛ ki tòre' ki kɔn' lipɛkl ya du ni, ki gbaan' Pɔl nin Silas ya nun bó, uʼgbɛnɛnt kɛ ŋɔh. ");
INSERT INTO gngNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Ni ya puoli bó nɛ u taa' bɛ ki ñɛn' saali, ki niire' bɛ ki ye: «Biciɛnbɛ, n li tien mila kí ŋmɛre?» ");
INSERT INTO gngNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Nɛ bi jiin' wɔ ki ye: «Teke Yonbdaan *Yesu kí ji, sin nin aʼden yaab kɛ li ŋmɛre.» ");
INSERT INTO gngNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Nɛn saan nɛ bi tɔke' wɔn nin uʼden yaab kɛ Yonbdaan ya gbɛr. ");
INSERT INTO gngNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Nɛ u taa' bɛ u ya yo kuñɔnku nnɔ kɛ ki tì sɔkre' bi wun ñiñi' bɛ ma nnɔ ya gbìɛn. Nɛ Pɔl nin Silas sìi' wɔn nin uʼden yaab kɛ Uwien ya ñunm i ya tàan bo. ");
INSERT INTO gngNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Nɛ u taa' Pɔl nin Silas ki jon' uʼden, ki tì de' bɛ tijier. U teke' Uwien ki jin' ma nnɔ nɛ wɔn nin uʼden yaab te uyɛnsɔnge ni. ");
INSERT INTO gngNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Kutaaku faa' nɛ Erom ya buur yaab nnɔ sɔn' biʼsojambɛ bɛ ń jo kí tì tɔke wà gu lipɛkl nnɔ wɔ ń taa bijɛb nnɔ kí wiɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Wà gu lipɛkl nnɔ tɔke' Pɔl ki ye tibuur yaab sɔn' ki tɔke' nni ki ye ń taa nɛ kí wiɛ. Nɛn bo, ñɛ mɛn kí li joh nin uyɛnduɔn. ");
INSERT INTO gngNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Nɛ Pɔl ye: «Tibuur yaab cère' bi ñiñi' tinbi Erom yaab binib ya nun bó ka bun' tɛ buur, nɛ ki pɛkn' tɛ. Fɛnfɛnnɔ bi ji yíe bɛ ń bɔle kí wiɛ tɛ ma nɔ, ta ń tuo. Cère tibuur yaab bugbɛn ń baa kí ñɛn tɛ.» ");
INSERT INTO gngNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Sojambɛ nnɔ liɛbe' ki tì tɔke' tibuur yaab nnɔ Pɔl len' nà nnɔ. Bi cii' Pɔl nin Silas yé Erom yaab ma nnɔ nɛ bujɛwaanbu cuo' bɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Nɛ bi baa' Pɔl nin Silas saan ki tien' bɛ kafala, nɛ ki ñɛn' bɛ lipɛkl ni, ki gbáan' bɛ bɛ ń siere udu nnɔ ni. ");
INSERT INTO gngNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Pɔl nin Silas ñɛn' kupɛnpɛkndu nnɔ ni, nɛ ki jon' Lidi den, ki laa' binib bà teke' *Yesu ki jin' nnɔ, ki saake' biʼgbɛnɛnt, nɛ ki bure'. ");
INSERT INTO gngNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pɔl nin Silas siere' Filip ya du ni, nɛ ki gɛ̀bre' Anfipolis nin Apoloni ya du ni, ki tì baa' Tesalonik ya du ni. *Sufmbɛ ya taanl ya duku kuba te len. ");
INSERT INTO gngNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pɔl kɔn' litaanl ya duku nnɔ ni tɛn u tì ń teh ma bo. Nɛ ki taa' *Saba uta ki tɔkeh bɛ *Uwien ya gbɔnku ya gbɛr. ");
INSERT INTO gngNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","U tɔkeh tigbɛr nnɔ ya tingi ki teh Uwien ya Nigɛndkɛ Kristo li jɛ̀nde, kí kpo kí mɛkre bitɛnkpiib ni nɛ. Nɛ ki teh n tɔkeh nɛ *Yesu wà ya gbɛr nɔ, wɔn nɛ yé Uwien ya Nigɛndkɛ Kristo. ");
INSERT INTO gngNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","*Sufmbɛ biba nin Grɛkmbɛ bà pukeh Uwien nnɔ ligol nin bipiikpɛkpiɛkb mɔ ligol ya yɛnm sɔnge' Pɔl len' nà nnɔ bo, nɛ bi kpɔbn' wɔn nin Silas bó. ");
INSERT INTO gngNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","*Sufmbɛ bà ya yɛnm ŋa sɔnge' Pɔl len' nà nnɔ bo nnɔ, taa' uʼbo iponponbe, nɛ ki taa' idukond isɛnjɛ ni, ki kpɔbn' biʼba bó, ki cère' udu nnɔ ya nib taan' ki yɛbe ki kpre' Pɔl nin Silas bo, ki teh fɛnfɛnm udu ni. Bi jon' ujɛ uba den, bi yih wɔ Sasɔn ki tì kɔn' nin mituɔm, ki nuunh bɛ ń taa Pɔl nin Silas kí jo udu nnɔ ya nib taan' nà saan nnɔ, ");
INSERT INTO gngNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","nɛ ka laa' bɛ. Ba laa' bɛ ma nnɔ nɛ ki cuo' Sasɔn nin binib bà teke' *Yesu ki jin' nnɔ ya biba ufaa bo, ki taa' bɛ ki jon' udu nnɔ ya ciɛnb saan, nɛ ki wuureh ki teh: «Binib bà cuon' ki saa' uŋɛndun kɛ nnɔ, baa' niɛ saan mɔ, ");
INSERT INTO gngNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","nɛ Sasɔn teke' bɛ uʼden. Bi kɛnde' ubɛrciɛn Sesa ya yiko bo, nɛ ki lienh ki teh ubɛrtɔ te, bi yih wɔ Yesu.» ");
INSERT INTO gngNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Tigbɛr nnɔ cɔke' linigol nin udu nnɔ ya ciɛnb kɛ, ");
INSERT INTO gngNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","nɛ bi teke' Sasɔn nin biʼtɔb nnɔ ilike, ki yaan ki wiɛ' bɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Nì biire' nɛ binib bà teke' *Yesu ki jin' nnɔ cère' Pɔl nin Silas bure' i ya tàan bo Bere ya du bó. Bi tì baa' nɛ ki jon' *Sufmbɛ ya taanl ya duku bó. ");
INSERT INTO gngNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","*Sufmbɛ bà kɔ Bere ya du ni nnɔ teknh tigbɛr ki cɛn' Tesalonik yaab. Nɛn bo nɛ bi teke' Pɔl tɔke' bɛ tigbɛr tà nnɔ mɔnmɔnm, nɛ ki fiinh *Uwien ya gbɔnku daan kɛ daan bɛ ń liike tù te bii ta te. ");
INSERT INTO gngNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Biʼni binib teke' *Yesu ki jin' ki yɛbe. Nɛ Grɛkmbɛ ya piikpɛkpiɛkb nin bijɛb mɔ teke' wɔ ki jin' ka dindin. ");
INSERT INTO gngNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Ama uyo wà *Sufmbɛ bà te Tesalonik ya du ni nnɔ cii' Pɔl te Bere ya du mɔ ni ki tɔkeh binib Uwien ya gbɛr nnɔ, nɛ bi jon' niʼmɔ bó ki tí tì cère' linigol kpre'. ");
INSERT INTO gngNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Nɛn saan nɛ binib bà teke' *Yesu ki jin' nnɔ cère' Pɔl siere' i ya tàan bo ki kpìen' usɛn wà joh miñunciɛnm bó nnɔ. Silas nin Timote bɛn juore' Bere ya du ni nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Bà pìɛreh Pɔl nnɔ, pìɛre' wɔ ki tì baa' Atɛnn ya du ni nɛ. Nɛ Pɔl tɔke' bɛ ki ye bi tì baa' la, bɛ ń tɔke Silas nin Timote kí ye bɛ ń baa ní uʼsaan tonm. ");
INSERT INTO gngNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Pɔl gu Silas nin Timote Atɛnn ya du ni uyo wà nnɔ, nɛ ki laa' ibule gbe udu nnɔ ni, nɛ uʼyɛnm saa' ki gbien'. ");
INSERT INTO gngNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","U te *Sufmbɛ ya taanl ya duku ni, nɛ wɔn nin *Sufmbɛ nin binib bà pukeh Uwien nnɔ tɔkeh tigbɛr. Idaan kɛ u joh binib taakeh nà saan nɛ ki tɔkeh binib bà bàareh niʼsaan nnɔ *Yesu ya gbɛr. ");
INSERT INTO gngNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Binib biba mɔ là te niʼsaan ki bɛnge' miyɛnfuom, bɛn nin Pɔl lienh. Biba yé *Epikuryɛnmbɛ, nɛ bitɔb yé *Stoyisiɛnmbɛ. Biba lienh ki teh «Ujɛ wuɔ ñɔñɔbleh ki teh ba nɛ?» Nɛ bitɔb lienh ki teh: «U lii lienh niba bó ya bule ya gbɛr nɛ.» Bi len' nnɔ, kimɛ Pɔl tɔkeh *Yesu ya gbɛmɔnmɔnt nin mimɛkrm ya gbɛr nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Bɛn nin wɔn jon' udu nnɔ ya buur ya bùol, bi yih nà saan Ayeropaji nnɔ, nɛ bi niire' wɔ ki ye: «A li fre kí tɔke tɛ a wɔknh binib miwɔknfɛ̀nm mà nɔ-ɔɔ?» ");
INSERT INTO gngNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Kimɛ a kpaakeh tiʼtub nɛ nin aʼgbɛcɛnt tuu, nɛ ti yíe tí cii tuʼtingi. ");
INSERT INTO gngNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Tɔ, Atɛnn ya du ya nib kɛ nin bicɛnb bà te udu nnɔ ni nnɔ fɛ tigbɛcɛnt ya tɔkm nɛ. Nɛn bo nɛ bi taakeh ki kaah uyo kɛ ki tɔkeh tù. ");
INSERT INTO gngNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Pɔl fii' ki sere' Ayeropaji ya nib nnɔ ya siik ni, nɛ ki ye: «Atɛnn yaabɛ, n sekn' ki laa' ni pɛ ibule bo cɛɛn nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","N cuonh niʼdu ni uyo wà nnɔ nɛ ki likeh niʼponpob, ki tì laa' liba bi kɛle' liʼbo ki ye: ‹Ta bɛn wà nnɔ mɔ yaal sɔ.› Ni pukeh wà, ka bɛn wɔ nnɔ min baa' ń tɔke nɛ u ya gbɛr nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Wɔn nɛ yé Uwien, ki ñɛn' uŋɛndun nin tibont tà kɛ te uʼni nɔ. Wɔn wà yé kutaaku nin kitink ya Yonbdaan nnɔ, ŋa kɔ nib mɛn' tidur tà nnɔ ni. ");
INSERT INTO gngNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Wa nuunh nil ya torm, niba ŋa pɔre' wɔ, kimɛ wɔn nɛ dienh binib limiɛl nin mitafaam mà bi fuoreh mɛ̀ nɔ nin tibont kɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","U ñɛn' unibaab nɛ, ki cère' u pɔ̀re' inibol yà te utingbɛn kɛ bo nɔ. Wɔn Uwien nɛ sien' iyo kɛ, ki bobore' inibol kɛ nin iʼkɔnkuɔn. ");
INSERT INTO gngNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","U là tien' nnɔ ŋɔ binib ń li nuunh wɔ nɛ. Nba la, bi ŋanŋaanh kí nuunh wɔ la, bi li tì lɛ wɔ. Imɔ̀n wa lì jɛnde' tiʼni uba mɔnɔn saan. ");
INSERT INTO gngNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Wɔn bo nɛ ti te, ki fuobe, ki cuonh. Niʼyonyuonb biba mɔ là len' nnɔ nɛ. Bi là len' ki ye: ‹Tiʼmɔ yé Uwien ya bumu nɛ.› ");
INSERT INTO gngNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Ti yé Uwien ya bumu ma nnɔ, ta bi li maaleh ki teh Uwien naan tɛn ibule nɛ. Unisaal nɛ taa' uʼyɛnmaale nin uʼbɛnm ki kpen' itɛn, ki duore' miñɔ̀km nin ilike ya kurku ki tien' yì. ");
INSERT INTO gngNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Uwien ŋa tɔnge binib ŋa laan là bɛn wɔ ki teh tibont tà nnɔ. Ama fɛnfɛnnɔ u ji tɔkeh uŋɛndun ya nib kɛ nɛ ki teh bɛ ń lèbre biʼtetem. ");
INSERT INTO gngNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Kimɛ u sien' lidaali là u li bu uŋɛndun ya nib kɛ tibuur tù ń li cuube. U gɛ̀nde' unil wà li bu binib tibuur nnɔ. U cère' udaan mɛkre' bitɛnkpiib ni ŋɔ wɔ ń wuɔn binib kí ye u mɔnbe ki gɛ̀nde' wɔn nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Binib nnɔ cii' Pɔl len' ki ye binib li mɛkre bitɛnkpiib ni ma nnɔ, nɛ biba lɛ' wɔ, bitɔb mɔ len' ki ye: «Ti lá li cenge aʼgbɛr tuu uyo uba nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Nɛ Pɔl siere' biʼsaan ki bure'. ");
INSERT INTO gngNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Nin nɛn kɛ binib biba teke' *Yesu ki jin', ki kpɔbn' Pɔl bó. Biʼni bi yih uba Denis u yé Ayeropaji ya nil, utɔ mɔ yé upii, bi yih wɔ Damaris nin binitɔb mɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Pɔl siere' Atɛnn ni, nɛ ki jon' Korɛnt ya du bó. ");
INSERT INTO gngNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","U tì cende' Suf uba bi yih wɔ Akilas nin uʼpo. Bi maa' wɔ Pɔnt ya tinfɛnm ni nɛ, ki yih uʼpo Prisil. Bi ñɛn' Itali ya duciɛn Erom bó nɛ ki baa' na wuɔke'. Kimɛ ubɛrciɛn Klod nɛ là ble' liwɔbl ki ye *Sufmbɛ kɛ ń ñɛ Erom ya du ni. Pɔl nin bɛn cuo' kujɔtieku. ");
INSERT INTO gngNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Bɛn nin Pɔl ya tuonl kɛ là tɛ nɛ, bi là pɔh ininbon nɛ. Nɛn bo nɛ Pɔl jon' ki tì te biʼden, bi tɛ ki sɔnh. ");
INSERT INTO gngNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","*Saba kɛ *Saba ya daali Pɔl joh *Sufmbɛ ya taanl ya duku ni nɛ bi tɔkeh tigbɛr, nɛ u ñikndeh *Sufmbɛ nin Grɛkmbɛ ń teke *Yesu kí ji. ");
INSERT INTO gngNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Silas nin Timote ñɛn' Maseduɔnn ya du bó, ki baa' ní uyo wà nnɔ, nɛ Pɔl taa' uʼba ki de' Uwien ya gbɛr ya tɔkm baba, ki tùɔreh ki tɔkeh *Sufmbɛ ki teh *Yesu nɛ yé Uwien ya Nigɛndkɛ Kristo. ");
INSERT INTO gngNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Ba tuo' Pɔl ya ñɔbu bó, ki sukreh wɔ ma nnɔ, nɛ u gbɛgbɛ' uʼwɛngolkaar ya tɛngunku ki tɔke' bɛ ki ye: «Na ŋmɛre' la, niʼyaar bo, na ñɛn' min. Fɛnfɛnnɔ n li pekre bà ŋa yé *Sufmbɛ bó nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Pɔl siere' niʼsaan, ki jon' ujɛ uba den, bi yih wɔ Titiyus Yustus, u yé unil wà pukeh Uwien nɛ. Uʼden nin litaanl ya duku nnɔ buɔke nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Litaanl ya duku nnɔ ya ciɛn Krispus nin uʼden yaab kɛ teke' Yonbdaan ki jin'. Korɛnt yaab mɔ cii' Pɔl tɔkeh *Yesu ya gbɛr tà nnɔ, ki teke' ki jin' ki yɛbe, nɛ bi sìi' bɛ Uwien ya ñunm. ");
INSERT INTO gngNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Kuñɔnku kuba nɛ Yonbdaan tɔke' Pɔl tidɛknt yaam, ki ye: «La li fɛnge, li tɔkeh binib tigbɛmɔnmɔnt nnɔ, ki la li ŋmin. ");
INSERT INTO gngNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","N te nin ŋɛ, uba ŋa ń fre kí tien ŋɛ nà bre, kimɛ nʼyaab yɛbe udu wuu ni.» ");
INSERT INTO gngNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Pɔl tien' niʼsaan libinl liba nin iŋmaale iluob nɛ, ki wɔknh binib Uwien ya gbɛr. ");
INSERT INTO gngNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Tɔ, uyo wà Galiyɔn là yé Akayi ya tinfɛnm ya gobina nnɔ nɛ *Sufmbɛ ya ciɛnb kpaan' Pɔl bo iyɛ, nɛ ki cuo' wɔ, ki jon' tibuur, ");
INSERT INTO gngNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","ki tì tɔke' ki ye: «Ujɛ wuɔ sureh binib bɛ ń li pukeh Uwien yiko ŋa ye ma bo nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pɔl yàare' wɔ ń len, nɛ Galiyɔn tɔke' *Sufmbɛ nnɔ ki ye: «U bi bii' libiil liba nɛ, bii u bi tien' kinunbɔnk kiba nɛ la, ninbi Sufmbɛ, n bi li duɔn nʼyɛnm kí cenge niʼbó. ");
INSERT INTO gngNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Ama ni findeh nin tɔb iñɔbon bo nin binib ya yel bo nin niʼyiko bo wɔn la, nì yé niʼyaar nɛ. Min ŋa yíe n li yé wà li bu tuu ya gbɛr.» ");
INSERT INTO gngNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Nɛ ki ŋɔre' bɛ ki ñɛn' tibuur ya duku ni. ");
INSERT INTO gngNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Nɛ binib bà kɛ te niʼsaan nnɔ cuo' litaanl ya duku ya ciɛn, Sɔstɛnn, ki ñih wɔ tibuur ya duku ya nun bó, ama Galiyɔn ŋa lì tɔnge' tù. ");
INSERT INTO gngNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pɔl biɛ ki tien' Korɛnt ya du ni ki wuɔke'. U cɛ̀be' binib bà teke' *Yesu ki jin' nnɔ, nɛ wɔn nin Prisil nin Akilas bure' bɛ ń tì kɔ buñɛrciɛnbu Sankre ya du ni. U kuo' uʼyur wun ni nɛ u là pùon' lipuonl là nnɔ bo. Bi kɔn' buñɛrciɛnbu u ya du ni nɛ ki cubn' Siri ya tinfɛnm bó. ");
INSERT INTO gngNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Bi tì baa' Efɛs ya du ni nɛ Pɔl dàan' uʼtɔntɔknlieb, ki jon' *Sufmbɛ ya taanl ya duku ni bi tì tɔkeh tigbɛr. ");
INSERT INTO gngNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Bi gbáan' wɔ wɔ ń tien biʼsaan iwenkàankɛ, nɛ wa tuo', ");
INSERT INTO gngNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","ki cɛ̀be' bɛ, ki tɔke' bɛ ki ye Uwien tuo' la, u tí li liɛbe ní biʼsaan uyo uba. Nɛ ki kɔn' buñɛrciɛnbu ki siere' Efɛs ya du ni, ki bure' ");
INSERT INTO gngNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","ki tí baa Sesare ya du ni. U tì baa' ma nnɔ nɛ ki don' Yerusalɛm bó, ki fuonde' *Kristo ya taanl yaab, nɛ ki ñɛn' niʼbó ki cɔn' Antiyɔk ya du bó. ");
INSERT INTO gngNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","U tien' iwenkàankɛ Antiyɔk ya du ni, nɛ ki tí bure'. U joh ma nnɔ nɛ ki ñɛn' Galasi nin Friji ya tinfɛnm ni, ki faake' binib bà teke' *Yesu ki jin' nnɔ ya tekjim. ");
INSERT INTO gngNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Ujɛ uba baa' Efɛs ya du ni, ki yé Suf, bi yih wɔ Apolos. Bi maa' wɔ Alɛksandri ya du ni nɛ. U yé unil wà freh ki lienh nɛ, ki bɛn tigbɛr tà kɛle' *Uwien ya gbɔnku ni nnɔ mɔnmɔnm. ");
INSERT INTO gngNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Bi là wɔkn' wɔ u li paan ma bo Yonbdaan ya sɛn bo. Uʼyɛnm pɛ *Yesu ya gbɛr bo cɛɛn, nɛ u tɔkeh tù binib, ki wɔknh bɛ tù te ma bo mɔnmɔnm. Ama u bɛn San là siih binib Uwien ya ñunm ma bo nnɔ baba nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Apolos kɔn' *Sufmbɛ ya taanl ya duku ni, ki cin' ki tɔkeh binib *Yesu ya gbɛr nin lifɛ̀l. Prisil nin Akilas cenge' uʼgbɛr ki gben', nɛ ki taa' wɔ ki jon' biʼden, ki tì tùɔre' ki tɔke' wɔ Uwien ya sɛn ya gbɛr mɔnmɔnm. ");
INSERT INTO gngNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Apolos yíe wɔ ń jo Akayi ya tinfɛnm bó ma nnɔ nɛ binib bà teke' *Yesu ki jin' nnɔ saake' uʼgbɛnɛnt, ki kɛle' kugbɔnku ki de' wɔ wɔ ń tì de biʼtɔb bà te niʼbó nnɔ bɛ ń teke wɔ kucɛ̀nku mɔnmɔnm. U tì baa' niʼbó nɛ ki tore' binib bà teke' *Yesu ki jin' Uwien ya juokm bo nnɔ nì yɛbe. ");
INSERT INTO gngNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Kimɛ u lienh ki jinh *Sufmbɛ binib kɛ ya nun bó nɛ, nɛ ki ñìikeh nà kɛle' *Uwien ya gbɔnku ni nnɔ bo, ki wɔngeh ki teh *Yesu yé Uwien ya Nigɛndkɛ Kristo nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apolos laan biɛ ki te Korɛnt ya du ni u yo wà nnɔ, nɛ Pɔl ñɛn' ijuɔn ya du bó, ki baa' Efɛs ya du ni, nɛ ki laa' binib bà teke' *Yesu ki jin' nnɔ ya biba len, ");
INSERT INTO gngNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","ki niire' bɛ ki ye: «Ni tì teke' *Yesu ki jin' ma nɔ, *Mifuoñaanm jiire' niʼbo ŋɔ-ɔɔ?» Nɛ bi ye: «Tinbi ŋa laan lì cii' nil len' ki ye *Mifuoñaanm te mɔnɔn.» ");
INSERT INTO gngNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Nɛ Pɔl niire' bɛ ki ye: «Bi sìi' nɛ Uwien ya ñunsii u lɛ ba?» Nɛ bi jiin' wɔ ki ye: «Bi sìi' tɛ San là siih binib Uwien ya ñunsii wà nnɔ nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Nɛ Pɔl tɔke' bɛ ki ye: «San là siih binib Uwien ya ñunm mitetem ya lèbrm bo nɛ, nɛ ki tɔkeh bɛ ki teh bɛ ń teke wà li paan uʼpuoli bó ní nnɔ kí ji. Niʼtingi si: bɛ ń teke *Yesu kí ji.» ");
INSERT INTO gngNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Bi cii' Pɔl len' nà nnɔ, nɛ ki cère' u sìi' bɛ Uwien ya ñunm Yonbdaan *Yesu ya yel bo. ");
INSERT INTO gngNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Pɔl taa' uʼnuɔ ki paan' biʼbo, nɛ *Mifuoñaanm jiire' ní biʼbo, nɛ bi lienh milencɛnm, ki sɔkndeh Uwien ya ñɔbon. ");
INSERT INTO gngNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Binib nnɔ kɛ là li baa piik nin bile. ");
INSERT INTO gngNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Pɔl là joh *Sufmbɛ ya taanl ya duku ni, ki tì baa' iŋmaale ita nɛ, ki lienh nin binib ka fɛnge, ki tɔkeh bɛ Uwien ya bɛl ya gbɛr, ki ñikndeh ki sureh bɛ bɛ ń tuo u tɔkeh tigbɛr tà nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Ama biʼni biba ya yul faa, ba tuo' ki teke' tigbɛr nnɔ, nɛ ki sɛ́reh binib bà teke' *Yesu ki jin' ki pɛ uʼsɛn bo nnɔ linigol ya nun bó. Nɛn bo nɛ Pɔl siere' ki dàan' bɛ, ki taa' bà teke' Yesu ki jin' nnɔ, ki jon' Tiranus ya kɛraduku bó ki tì wɔknh bɛ idaan kɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","U tien' nnɔ ki tì dukn' ibin ile nɛ. Nɛn bo nɛ Asi ya tinfɛnm ya nib, bà yé *Sufmbɛ nin bà ŋa yé *Sufmbɛ kɛ cii' Yonbdaan ya gbɛr. ");
INSERT INTO gngNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Uwien cère' Pɔl teh miyɔkm ya bonciɛnt cɛɛn, ");
INSERT INTO gngNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","haali bi tì taah mupapaajɛmu nin tikpɛlcɛr tà kɛ mɛ' Pɔl nnɔ mɔnɔn ki tì paakeh biʼwiɛnb bo nin isɛnpol ŋaake binib bà bo, nɛ bi faakreh i ya tàan bo. ");
INSERT INTO gngNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","*Sufmbɛ biba mɔ là te ki cuonh niʼkɛ saan ki ŋuɔh isɛnpol binib saan. Bi yíe bɛ ń taa Yonbdaan *Yesu ya yel, kí li ŋuɔh isɛnpol binib saan, nɛ ki lienh ki teh: «*Yesu wà Pɔl tɔkeh binib uʼgbɛr nnɔ ya yel bo, siere mɛn.» ");
INSERT INTO gngNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Bitɔtuɔrciɛnb ya ciɛn uba nɛ là te ki ŋmɔbe bijiɛb bilole, ki yé Suf, bi yih wɔ Sikefa. Bɛn nɛ là cuonh ki teh nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Nɛ usɛnpol cère' ujɛ wà u ŋaake wɔ nnɔ tɔke' bɛ ki ye: «N bɛn Yesu, ki bɛn Pɔl yé udaan wà. Ninbi le? Niʼmɔ yé ŋmɛmbɛ nɛ?» ");
INSERT INTO gngNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Nɛ ki fii' ki ciin' bɛ, ki faake' nin biʼkɛ ki jɛ̀nde' bɛ ki gbien', ki bunbunge' bɛ. Nɛ biʼkɛ sɛn' ki ñɛn' uʼden iñil. ");
INSERT INTO gngNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Efɛs ya nib, bà yé *Sufmbɛ nin bà ŋa yé *Sufmbɛ kɛ cii' tigbɛr nnɔ, bujɛwaanbu cuo' biʼkɛ; nɛ bi kpiɛke' Yonbdaan Yesu. ");
INSERT INTO gngNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Linigol là teke' *Yesu ki jin' nnɔ ya biba bàareh ki lá tɔkeh binib ya nun bó bi là teh nà na mɔn nin bi là teh iñɔke ma bo. ");
INSERT INTO gngNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Bà là teh iñɔke nnɔ ya biba tukeh biʼñɔkgbɔnt ní ki lá taakeh ki cokndeh, ki siɛnh binib kɛ ya nun bó. Bi bù' tigbɔnt nnɔ ya daaku, ki laa' nì te tilikur itur piŋun nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Nnɔ nɛ Yonbdaan ya tuɔm bo, uʼgbɛr yɛre' niʼkɛ saan ki ŋmɔbe mituɔm. ");
INSERT INTO gngNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Ni ya puoli bó nɛ Pɔl maale' ki ye u li ñɛ Maseduɔnn nin Akayi ya tinfɛnm bó nɛ kí jo Yerusalɛm. Nɛ ki ye: «N tì baa' niʼbó la, n li jo Erom ya du bó mɔ.» ");
INSERT INTO gngNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Nɛn saan nɛ u gɛ̀nde' bà toreh wɔ nnɔ ya bile, bi yih uba Timote, ki yih utɔ Erat, ki sɔn' bɛ Maseduɔnn ya tinfɛnm bó. Nɛ wɔn juore' Asi ya tinfɛnm ni ki tien' iwenkàankɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","U ya yo nɛ kukpiinku kpi' Efɛs ya du ni Yonbdaan ya sɛn bo ki bre cɛɛn. ");
INSERT INTO gngNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Ujɛ uba là te udu nnɔ ni, bi yih wɔ Demetriyus. U taah ilike ya kur nɛ ki teh muduwawaamu mùa naan tɛn ubul *Atemis ya duku, ki kuɔreh binib bo. Lituonl nnɔ bo bitonsɔnb lɛnh kpɛle cɛɛn nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Demetriyus taan' binib bà kɛ sɔnh lituonl nnɔ nin binib bà mɔ sɔnh li ya tuonbol, nɛ ki tɔke' bɛ ki ye: «Nʼjɔtiebɛ, ni bɛn ki ye ti fuobe lituonl là bo sɔ-a! ");
INSERT INTO gngNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Ama Pɔl wɔn lienh ki teh, ibule ŋa yé bonn, binib nɛ mɛh yì. U sure' binib bà bi tuo' uʼñɔbu bó yɛbe. Na yé niɛ saan Efɛs ni baba, Asi ya tinfɛnm kɛ ni nɛ. Ninbi mɔnɔn cii', ki sekn' ki laa' mɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","U teh nnɔ la, na yé tiʼtuonl baba nɛ li saa. Ubuciɛn *Atemis mɔ ya duku li juore fɛnm nɛ. Atemis wà, Asi ya tinfɛnm ya nib nin uŋɛndun ya nib kɛ pukeh wɔ nnɔ, mɔ ŋa ji li ŋmɔbe kpiɛke.» ");
INSERT INTO gngNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Binib nnɔ cii nnɔ ma nnɔ nɛ biʼbenku ni ben' ki gbien' nɛ bi wuureh ki teh: «Efɛs yaab ya bul *Atemis yé ubuciɛn nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Nɛn saan nɛ udu nnɔ ya nib kɛ kpre', ki tɔke ligol ki joh udu nnɔ ya nib taakeh nà saan nnɔ, nɛ ki cuo' Pɔl ya tɔntɔknlieb bile usɛn ni. Bi yih uba Gayus, ki yih utɔ Aristak. Bi yé Maseduɔnn ya tinfɛnm ya nib nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pɔl yíe wɔ ń jo linigol nnɔ saan, nɛ binib bà teke' *Yesu ki jin' nnɔ pien' wɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Mitinfɛnm nnɔ ya ciɛnb bà yé Pɔl ya jɔtieb nnɔ mɔ sɔn' ki tɔke' wɔ ki ye u la jo linigol nnɔ taan' nà saan nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","U ya yo nɛ linigol nnɔ ŋmɔbe kuwaaku ki gbien', ka ji bɛn nà bó si nà bó. Biba wuureh ki lienh tuba, biʼtɔb mɔ wuureh ki lienh tutɔr. Biʼni biba ŋa ji là bɛn nà cère' bi taan' niʼsaan mɔnɔn. ");
INSERT INTO gngNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","*Sufmbɛ bà te niʼsaan nnɔ gɛ̀nde' ujɛ uba ki lìen' usɛn, bi yih wɔ Alɛksand. Linigol nnɔ ni biba tɔke' wɔ tigbɛr nnɔ ya tingi, nɛ u yuon' unuɔ ki wuɔn' ki ye u yíe wɔ ń tɔke linigol nnɔ tigbɛr nnɔ ya tingi nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Ama linigol nnɔ bɛnde' ki ye u yé Suf ma nnɔ, nɛ bi taakeh ki wuureh ki tì baa' tɛn tikur tule ki teh: «Efɛs yaab ya bul Atemis yé ubuciɛn nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Udu nnɔ ya kɛraci cère' linigol nnɔ ŋmile', nɛ u len' ki ye: «Efɛs yaabɛ, unil kɛ bɛn ki ye ninbi Efɛs yaab nɛ gu ubuciɛn Atemis ya duku, ki bɛn ki ye uʼnɛnnɛnku ñɛn' kutaaku bo nɛ ki jiire' ní. ");
INSERT INTO gngNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Uba ŋa ń fre kí niɛ kí ye ta te. Nɛn bo, ni bi li duɔn niʼyɛnm nɛ, ki la tien niba ka maale'. ");
INSERT INTO gngNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Kimɛ ninbi nɛ tuke' bijɛb biɛ nɔ ki baa' niɛ saan. Ba saa' niba ubul ya duku ni, ka suke' tiʼbule mɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Demetriyus nin uʼtonsɔnb ŋmɔbe tigbɛr nin unil la, tibuur ya bùol te, bà buh tibuur mɔ te, bɛ ń jo nɛn bó kí tì len. ");
INSERT INTO gngNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ni tí ŋmɔbe tigbɛtɔr ki pukn' la, bi li tùɔre tù udu ya taanciɛnl là ñɛndeh *yiko nnɔ ni nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Ta bɛn la, dinnɔ ya taanl liɛ bo, tiʼdu ya ciɛnb li biin tɛ kí ye ti nuunh tí kpìin udu nɛ; kimɛ ta ŋmɔbe ti li ñi nà bo kí tɔke nà cère' ti taan'.» U len' nnɔ ki gben', nɛ ki cère' biʼkɛ siere'. ");
INSERT INTO gngNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Kukpiinku nnɔ ya waaku tì ŋmile' ma nnɔ, nɛ Pɔl cère' binib bà teke' *Yesu ki jin' nnɔ taan' uʼsaan, nɛ u saake' biʼgbɛnɛnt, ki cɛ̀be' bɛ ki bure' Maseduɔnn ya tinfɛnm bó. ");
INSERT INTO gngNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","U ñɛh idu yà te mitinfɛnm nnɔ ni, ki tɔkeh binib bà teke' *Yesu ki jin' nnɔ tigbɛr tù yɛbe ki saakreh biʼgbɛnɛnt, ki tì baa' Grɛs ya du ni, ");
INSERT INTO gngNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","ki tien' len iŋmaale ita. U là benh wɔ ń kɔ buñɛrciɛnbu uyo wà kí jo Siri ya tinfɛnm bó nnɔ nɛ ki cii' *Sufmbɛ kpaan' uʼbo iyɛ bɛ ń tien wɔ nà bre, nɛ u ye u li liɛbe' kí ñɛ Maseduɔnn ya tinfɛnm bó nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Nɛ binib biba pìɛre' wɔ. Bà pìɛre' wɔ nnɔ ya yel si: Sopatɛr, u yé Bere ya du ya nil nɛ, ki yé Pirus ya bijɛ nin Aristak nin Sekundus, bi yé Tesalonik ya du ya nib nɛ nin Gayus, u yé Dɛbe ya du ya nil nɛ nin Ticik nin Trofim, bi yé Asi ya tinfɛnm ya nib nɛ nin Timote. ");
INSERT INTO gngNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Binib bugbɛn liere' usɛn ki jon' Trowas ya du ni ki tì gu tɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Tinbi wɔn, kpɔnɔ wà ŋa ŋmɔbe ñɔke ya *nacenku gɛ̀bre' nɛ ki yaan ti kɔn' buñɛrciɛnbu Filip ya du ni. Ti tì tu' bɛ Trowas ya du ni wienŋun daali nɛ, ki tien' len iwien ilole. ");
INSERT INTO gngNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","*Saba ya daali ya tajuɔku nɛ ti taan' tí ji Yonbdaan ya jier, nɛ Pɔl cin' ki tɔkeh binib Uwien ya gbɛr. Nì faa' la, u li bure ma nnɔ nɛ u tɔke' bɛ tù ki tì baa' kuyɔku ya siik. ");
INSERT INTO gngNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Ti taan' lidutɔtuɔl liba ya paaki ya duku ni nɛ. Ifr yɛbe kuduku nnɔ ni. ");
INSERT INTO gngNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Unacenfaan uba kɛ lidutɔtuɔl nnɔ ya dutaaku ya dubonl bo, bi yih wɔ Etikus. Pɔl tɔke' tigbɛr ki wuɔke' ma nnɔ nɛ migùɔnm ñɔ̀nde' unacenfaan nnɔ u gùɔn' ki gbɔkre', nɛ ki cere' ki lu' tingi. Bi jiire' bɛ ń fin wɔ ki laa' u kpo'-a! ");
INSERT INTO gngNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Nɛn saan nɛ Pɔl jiire' ki bùɔn' ki yuure' wɔ, nɛ ki tɔke' bɛ ki ye: «Cuo mɛn niʼba, wa kpo'.» ");
INSERT INTO gngNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Pɔl liɛbe' ki don' kuduku nnɔ ya paaki nɛ ki gbiire' Yonbdaan ya jier bi jin', nɛ u tí tɔke' bɛ tigbɛr ki wuɔke'. Nì tì tuo mifaam, nɛ u bure'. ");
INSERT INTO gngNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Bi tuke' unacenfaan nnɔ ní u fuobe nɛ unil kɛ ya yɛnm duɔn'. ");
INSERT INTO gngNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Tinbi kɔn' buñɛrciɛnbu, ki liere' usɛn ki bure' Asɔs ya du bó. Pɔl ye ti li taa wɔ buñɛrciɛnbu ni nɛn bó nɛ, kimɛ u là yíe wɔ ń cuon nɛ kí jo niʼbó. ");
INSERT INTO gngNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","U tì tu' tɛ Asɔs ni, nɛ ti taa' wɔ buñɛrciɛnbu nnɔ ni ti bure' Mitilɛnn ya du bó. ");
INSERT INTO gngNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Ti siere' niʼsaan ki bure', nì ŋmɔŋmɔbe ki tì faa' ki laa' ti gaake Kiyo ya dekl nɛ. Kutaaku faa' nɛ ti baa' lidektɔl saan, bi yih lɛ Samɔs, kutaaku tí liɛbe' ki faa' nɛ ti baa' Milɛ ya du ni. ");
INSERT INTO gngNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Kimɛ Pɔl ŋa yíe wɔ ń wuɔke Asi ya tinfɛnm ni nɛ ki lɔke' Efɛs ya du. U là benh wɔ ń baa Yerusalɛm tonm nɛ, ki maaleh nì tuo' la, wɔ ń baa len *Pantekot ya nacenku ya daali. ");
INSERT INTO gngNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Pɔl te Milɛ ya du ni, nɛ ki sɔn' ki yin' *Kristo ya taanl ya ciɛnb bà te Efɛs ya du ni nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Bi baa' uʼsaan uyo wà nnɔ, nɛ u tɔke' bɛ ki ye: «Kí ñɛ lidaali là nʼtaal tɛ Asi ya tinfɛnm ni nnɔ, ninbi nɛ bɛn n là fuobe nin nɛ idaan kɛ ma bo. ");
INSERT INTO gngNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","N jiin' nʼba tingi nɛ ki sɔn' Yonbdaan ya tuonl nin tinunsiir, ki jin' ijɛnd, kimɛ *Sufmbɛ biba là kpaan' iyɛ bɛ ń li teh nni nà bre nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","N tɔke' nɛ *Yesu ya gbɛr binib taakeh nà saan nin niʼden ka bɔle' nɛ tigbɛr tà kɛ li tore nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","N tɔke' *Sufmbɛ nin bà ŋa yé *Sufmbɛ ki ye bɛ ń lèbre biʼtetem kí paan Uwien ya sɛn bo, kí teke Yonbdaan *Yesu kí ji. ");
INSERT INTO gngNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Fɛnfɛnnɔ min nɛ te usɛn ni ki joh Yerusalɛm nɔ. *Uwien ya Fuoñaanm nɛ wɔbn' nni ń jo. Ma bɛn nà li tì tu nni niʼbó. ");
INSERT INTO gngNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Ama n nín bɛn ki ye *Mifuoñaanm tɔkeh nni idu kɛ ni ki teh bi li tì lòle nni niʼbó, kí jɛ̀nde nni mɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Ama min ŋa nín tɔngeh nʼmiɛl tɛn lɛn nɛ yé nʼbo nibonmɔ̀nn. N yíe ń sɔn ki tì baa' nʼtuonl ya biɛn nɛ. N yíe ń tien Yonbdaan *Yesu ye ń tien nà nnɔ nɛ. Nɛn si: ń tɔke binib Uwien ya juokm ya gbɛmɔnmɔnt. ");
INSERT INTO gngNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","«N là cuonh ki tɔkeh ninbi bà kɛ Uwien ya bɛl ya gbɛr nnɔ, n bɛn ki ye na ji li lɛ nni. ");
INSERT INTO gngNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Nɛn bo nɛ n tɔkeh nɛ dinnɔ wuɔ ki teh niʼni wà kɛ kpo' ki juore' fɛnfɛnm la, na ñɛn' min, ");
INSERT INTO gngNT_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","kimɛ n tɔke' nɛ Uwien yíe nà kɛ, ka bɔle' nɛ niba. ");
INSERT INTO gngNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Li ŋuuke mɛn niʼba mɔnmɔnm, kí li ŋuuke binib bà *Mifuoñaanm guun' nɛ bɛ nnɔ mɔ mɔnmɔnm. Li likeh bɛ mɛn. Bi yé Uwien ya taanl nɛ. U taa' uʼBijɛ ya sɛ̀m nɛ ki dɛ' lɛ̀. ");
INSERT INTO gngNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","N bɛn ki ye n bure' la, binib li kɔ niʼni, kí li bre tɛn ikɛ̀r, kí li nuunh bɛ ń bere litaanl nnɔ, kí tien liʼnib nà bre ka ń lɔkre uba mɔnɔn. ");
INSERT INTO gngNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Bitonnɛndɛnb li ñɛ ninbi mɔnɔn ni kí lɛre binib bà teke' *Yesu ki jin' nnɔ bɛ ń wiɛ uʼsɛn kí paan bɛn bo. ");
INSERT INTO gngNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Nɛn bo, la gɔh mɛn, kí li tiɛn kí ye ibin ita sɔ n gbiereh niʼni wà kɛ nin tinunsiir nɛ ñɔnku nin wien ni. ");
INSERT INTO gngNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","«Fɛnfɛnnɔ n taa' nɛ ki ŋukn' Uwien; ki tɔkeh nɛ ki teh ní tiɛre Uwien ya juokm ya gbɛr bó. Tigbɛr nnɔ ŋmɔbe mituɔm, ki li cère ní li faa mitekjim ni, ki li de nɛ lifaal là u bonde' lɛ̀ ki ble' binib bà kɛ yé uʼyaab nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","N là te niʼsaan ma nnɔ, ma binbe' uba ya likbu ki niireh nin uʼwɛngolkaar. ");
INSERT INTO gngNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Ninbi mɔnɔn bɛn ki ye n ya nɔjɛ bo nɛ min nin nʼtɔntɔknlieb là fuobe. ");
INSERT INTO gngNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","N tuu ki sɔnh ki wɔngeh nɛ ki teh niʼmɔ ń li sɔnh nin inunmɔ́n ŋɔ kí li toreh bijiinb, kí li tiɛn Yonbdaan *Yesu mɔnɔn là len' liñɔbonl là ki ye: ‹Wà dienh ya yɛnm sɔnge ki cɛn' wà teknh nnɔ.› » ");
INSERT INTO gngNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Pɔl len' ki tì gben', nɛ wɔn nin bɛn kɛ gbaan' nɛ u kàare'. ");
INSERT INTO gngNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Nɛn saan nɛ biʼkɛ cin' ki muɔh ki joh ki tì lɔkndeh Pɔl. ");
INSERT INTO gngNT_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Biʼyɛnm tùɔre' ki saa' u len' liñɔbonl là ki ye ba ji li lɛ wɔ nnɔ bo nɛ, nɛ ki pìɛre' wɔ, wɔ ń tì kɔ buñɛrciɛnbu. ");
INSERT INTO gngNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Ti cɛ̀be' bɛ ma nnɔ nɛ ki kɔn' buñɛrciɛnbu, ki bure' ki cubn' ki tì baa' Kɔs ya dekl; wienle daali nɛ ti baa' Lod ya dekl, ki ñɛn' nɛn saan ki bure' Patara ya du bó. ");
INSERT INTO gngNT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Ti laa' niʼsaan buñɛrciɛnbu buba bù fih bù ń bure Fenisi ya tinfɛnm bó, nɛ ti kɔn' bù ki bure'. ");
INSERT INTO gngNT_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Ti jojoh ki tì likeh Ciip ya dekl tiʼnun bó, nɛ ki ŋmiɛke' lɛ̀ unɔgɛn bó, ki cubn' Siri ya tinfɛnm bó, ki tì baa' Tir ya du ni. Bi li ñɛn ituk buñɛrciɛnbu nnɔ ni nɛn saan nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Ti laa' binib bà teke' *Yesu ki jin' udu nnɔ ni, nɛ ki tien' biʼsaan iwien ilole. *Mifuoñaanm cère' bi tɔke' Pɔl ki ye u la dùo Yerusalɛm bó. ");
INSERT INTO gngNT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Iwien ilole nnɔ gɛ̀bre' ma nnɔ, nɛ ti liɛbe' ki bure'. Ti joh tí kɔ buñɛrciɛnbu, nɛ bɛn nin biʼpuob nin biʼbumu kɛ pìɛre' tɛ ki ñɛn' udu nnɔ ni. Tiʼkɛ gbaan' miñunciɛnm nnɔ ya gbaal, ki kàare', ");
INSERT INTO gngNT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","nɛ ti cɛ̀be' tɔb, ti kɔn' buñɛrbu nnɔ, nɛ bɛn liɛbe' ki kun'. ");
INSERT INTO gngNT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Ti kɔn' buñɛrciɛnbu mifɔrkaam Tir ya du ni nɛ ki tì baa' Tolemayis ya du ni. Ti jon' ki fuonde' binib bà teke' *Yesu ki jin' ki te niʼsaan nnɔ, nɛ ki tien' biʼsaan uwien uba. ");
INSERT INTO gngNT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Kutaaku faa' nɛ ti tí liɛbe' ki bure' ki tì baa' Sesare ya du ni, ki jon' ki tì te Filip wà tɔkeh *Yesu ya gbɛmɔnmɔnt nnɔ den. U yé bi là gɛ̀nde' jɛb bilole bà nnɔ ya uba nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","U là ŋmɔbe bisiɛb binan nɛ ba bɛn jɛb, ki sɔkndeh Uwien ya ñɔbon. ");
INSERT INTO gngNT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Ti tien' niʼsaan iwenkàankɛ, nɛ *Uwien ya ñɔbonsɔknl uba ñɛn' Sude ya tinfɛnm bó ki baa' ní bi yih wɔ Agabus. ");
INSERT INTO gngNT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","U tu' tɛ niʼsaan nɛ ki teke' Pɔl ya ningbɛnl, ki lòle' wɔn Agabus ya tàan nin uʼnuɔ, ki len' ki ye *Mifuoñaanm ye ma sɔ: «Udaan wà si liningbɛnl liɛ nnɔ *Sufmbɛ li tì lòle wɔ nnɔ nɛ Yerusalɛm ni, kí taa wɔ kí ŋukn bà ŋa yé *Sufmbɛ.» ");
INSERT INTO gngNT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Ti cii' nnɔ ma nnɔ nɛ tinbi nin binib bà te niʼsaan nnɔ gbáan' Pɔl ki ye u la dùo Yerusalɛm bó. ");
INSERT INTO gngNT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Nɛ Pɔl ye: «Ni teh bɛ nɔ, ki mɔmuɔh ki saah nʼyɛnm-i? Min bonde' ki gben' nɛ. Bi li tì lòle nni bii bi li tì ku nni Yerusalɛm ni Yonbdaan *Yesu bo mɔnɔn la, n lì li jo nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Wa tuo' tiʼyaam ma nnɔ nɛ ti dàan' wɔ, ki ye: «Yonbdaan ń tien u yíe ma.» ");
INSERT INTO gngNT_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Ti tien' niʼsaan iwenkàankɛ yà nnɔ gɛ̀bre', nɛ ti bonde' ki tì gben' ki don' Yerusalɛm bó. ");
INSERT INTO gngNT_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Binib bà teke' *Yesu ki jin' ki te Sesare ya du ni nnɔ ya biba mɔ pìɛre' tɛ. Bi tuke' tɛ ki jon' ujɛ uba den ti tì gɔn', bi yih wɔ Minasɔn, u yé Ciip ya nil nɛ, ki pɛ Yesu ya sɛn bo nì wuɔke'. ");
INSERT INTO gngNT_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Tɔ, ti baa' Yerusalɛm ni ma nnɔ nɛ binib bà teke' *Yesu ki jin' nnɔ teke' tɛ nin uyɛnsɔnge. ");
INSERT INTO gngNT_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Kutaaku faa' nɛ tinbi nin Pɔl jon' Saak den ki tì fuonde' wɔ. *Kristo ya taanl ya ciɛnb kɛ mɔ là taan' niʼsaan. ");
INSERT INTO gngNT_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Pɔl fuonde' bɛ ki tì gben', nɛ ki tɔke' bɛ niʼkɛ dokdoki kí ñɛ uʼtuonl bo Uwien tien' nà bà ŋa yé *Sufmbɛ ya siik ni. ");
INSERT INTO gngNT_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Bi cii' Pɔl len' nà nnɔ, nɛ bi pɛ̀ke' Uwien, ki tɔke' wɔ ki ye: «Tiʼninjɛ, a laa'-aa! *Sufmbɛ itur itur nɛ teke' *Yesu ki jin', nɛ biʼkɛ ya nun mɔ́n bɛ ń li boh Moyis ya yiko nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Bi cii' bi ye a wɔknh *Sufmbɛ bà kɛ te inibotɔ ya du ni nnɔ ki teh bi la ji ń li pɛ Moyis ya yiko bo, ki la ji ń li jɛh biʼbumu ya pun, ki la ji ń li pɛ biʼyaajɛbok bo. ");
INSERT INTO gngNT_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Ti li tien mila? Bi lì li cii aʼbaam bó nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Tɔ, á tien ti li tɔke ŋɛ nà nɔ. Bijɛb binan biba te tiʼni, ki là pùon' lipuonl; ");
INSERT INTO gngNT_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","taa bɛ ní jo Uwien ya duku ni, kí tì tien tijɔknt ya ñɛnm ya tuɔrl, á pɛ̀ bi li tì taa tibont tà kí tien lituɔrl nnɔ bo, ŋɔ bɛ ń kuo biʼyur. A tien' nnɔ la, binib kɛ li bɛnde kí ye bi lienh tà aʼbo nnɔ ta te, kí bɛnde kí ye aʼmɔ pɛ Moyis ya yiko bo nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Binib bà ŋa yé *Sufmbɛ ki teke' *Yesu ki jin' nnɔ, bɛn wɔn, ti là maale' ki ye nì mɔn tí kɛle kugbɔnku nɛ kí tɔke bɛ kí ye bi la ŋmɔnh tɔtuɔrnɔnt, ki la ŋmɔnh wɛnkpil, ki la jinh sɛ̀m, ki la teh naŋmaal.» ");
INSERT INTO gngNT_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Kutaaku tí faa' nɛ Pɔl taa' bijɛb nnɔ, wɔn nin bɛn tì taan' ki cin' ki teh tijɔknt ya ñɛnm ya tuɔrl nnɔ. Nɛ u kɔn' Uwien ya duku ya luo bo, ki tɔke' utɔtuɔrkɛ lidaali là bi li tien lituɔrl nnɔ kí gben ŋɔ wà kɛ ń de Uwien uʼpum. ");
INSERT INTO gngNT_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Tɔ, bi li tien lituɔrl nnɔ kí tì dukn iwien ilole nɛ. Iwien nnɔ tì benh yì ń gben, nɛ *Sufmbɛ bà ñɛn' Asi ya tinfɛnm bó ní nnɔ laa' Pɔl Uwien ya duku ya luo bo, ki cère' linigol kpre' Pɔl bo, nɛ ki cuo' wɔ, ");
INSERT INTO gngNT_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","ki wuureh ki teh: «Israyɛl yaabɛ, la tuo mɛn, ujɛ wà sɔ cuonh niʼkɛ saan, ki wɔknh binib kɛ miwɔknm mà saah tinbi *Sufmbɛ nin Moyis ya yiko nin Uwien ya duku. U tuke' binib bà ŋa yé *Sufmbɛ mɔnɔn, ki kɔn' Uwien ya duku ni, ki kuɔn' kù tijɔknt.» ");
INSERT INTO gngNT_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Kimɛ bi là laa' Pɔl nin Trofim, wà yé Efɛs ya du ya nil nnɔ tɔke udu ni ma nnɔ nɛ bi maale' ki ye Pɔl taa' wɔ ki kɔn' Uwien ya duku ni nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Kukpiinku kpi' udu ni niʼkɛ saan, nɛ udu nnɔ ya nib sɛn' ki taan' ní, ki cuo' Pɔl, ki dɛre' wɔ ki ñɛn' Uwien ya duku ni, nɛ ki pɔk ki pìin' inañuɔn. ");
INSERT INTO gngNT_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Uyo wà bi nuunh bɛ ń ku Pɔl nnɔ, nɛ Erom ya Sojambɛ ya ciɛn cii' bi ye: «Yerusalɛm kɛ kpi' ŋɔ.» ");
INSERT INTO gngNT_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","I ya tàan bo, nɛ uciɛn nnɔ taa' Sojambɛ nin sojambɛ kobk ya ciɛnb biba, ki tiinh ki joh linigol nnɔ saan. Bi laa' Sojambɛ nnɔ nin biʼciɛn ma nnɔ, nɛ bi dàan' ka ji ñih Pɔl. ");
INSERT INTO gngNT_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Nɛn saan nɛ sojambɛ ya ciɛn nnɔ cuon' ki nɛkn' Pɔl, ki cuo' wɔ, ki tɔke' uʼsɔjambɛ ki ye bɛ ń taa tikudɔkr tule kí lòle wɔ, nɛ ki niire' Pɔl yé udaan wà nin u tien' bà. ");
INSERT INTO gngNT_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Ama linigol nnɔ ni, biba wuureh ki lienh tuba, nɛ bitɔb mɔ wuureh ki lienh tutɔr. Kuwaaku nnɔ bo nɛ sojambɛ ya ciɛn nnɔ ŋa fre' ki bɛnde' nà tien', nɛ ki tɔke' uʼsɔjambɛ ki ye bɛ ń taa Pɔl kí jo biʼtonsɔnduku saan. ");
INSERT INTO gngNT_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Bi tuke wɔ ki joh ki tì baa' kuduku nnɔ ya nañɔkɔkɔl saan, nɛ sojambɛ tì gben' ki yuure' wɔ paaki, kimɛ linigol nnɔ ŋmɔbe kinunbɔnk nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Udu nnɔ ya nib kɛ pɛ puoli nɛ ki wuureh ki teh: «Ku wɔ mɛn! Ku wɔ mɛn!» ");
INSERT INTO gngNT_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Bi ye bɛ ń kuɔn Pɔl kuduku nnɔ ni uyo wà nnɔ nɛ u niire' sojambɛ ya ciɛn nnɔ Grɛkmbɛ ya lenm ni ki ye: «A li tuo kí cɛ̀be nni ń tɔke ŋɛ liñɔbonl liba-aa?» Nɛ uciɛn nnɔ niire' wɔ ki ye: «A ciih Grɛkmbɛ ya lenm nɛ-ɛɛ? ");
INSERT INTO gngNT_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Nɛn mɛn la, sin ŋa ñí Esipt ya jɛ wà cère' linigol yìe' tiʼdu ya ciɛnb ya ñɔbu bó idɛn yiɛ nɔ ki tuke' binikub itur inan ki jon' kupenpelku ni nnɔ-a?» ");
INSERT INTO gngNT_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Nɛ Pɔl ye: «Min yé Suf nɛ, ki maa' Tars ya du wà te Silisi ya tinfɛnm ni, uʼyel kpére' nnɔ ni, ki yé len ya nil. A tuo' la, á cɛ̀be nni ń len nin linigol liɛ nɔ.» ");
INSERT INTO gngNT_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","U cɛ̀be' Pɔl ki ye wɔ ń len, nɛ Pɔl sere' linañɔkɔkɔl nnɔ bo, ki yuon' unuɔ ki ye bɛ ń ŋmile, bi ŋmile' cim, nɛ u len' bɛ *Sufmbɛ ya lenm ni ki ye: ");
INSERT INTO gngNT_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","«Nʼbaambɛ nin nʼninjiɛbɛ, cenge mɛn fɛnfɛnnɔ n li tɔke nɛ tigbɛr tà kí fie nʼba nɔ.» ");
INSERT INTO gngNT_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Bi cii' u lienh bi ya lenm ma nnɔ, nɛ bi tùɔre' ki ŋmile' cim. Nɛn saan nɛ Pɔl ye: ");
INSERT INTO gngNT_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","«N yé Suf nɛ, ki maa' Tars ya du wà te Silisi ya tinfɛnm ni nnɔ ni. Ama bi wube' nni udu wà ni sɔ. Gamaliɛl nɛ là wɔkn' nni tiʼyaajɛb ya yiko ya bom mɔnmɔnm. Nɛ nʼnun là mɔ́n Uwien ya tuonl bo, tɛn niʼkɛ ya nun mɔ́n ma liʼbo fɛnfɛnnɔ wuɔ nɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","N là jɛ̀ndeh binib bà pɛ *Yesu ya sɛn bo nɛ haali bi tì kpuokeh, ki coh bijɛb nin bipiib, ki lùoh bɛ tikudɔkr, ki tì pɛkndeh. ");
INSERT INTO gngNT_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Bitɔtuɔrciɛnb ya ciɛn nin *Sufmbɛ ya buur ya cɛkl yaab li fre kí tɔke nɛ kí ye n len' nà nɔ nì yé imɔ̀n nɛ. Bi là kɛle' tigbɔnt mɔnɔn ki de' nni ń tì de *Sufmbɛ bà te Damas ya du ni nnɔ, bɛ ń cɛ̀be nni ń cuo binib bà teke' *Yesu ki jin' ki te niʼbó nnɔ, kí lòle bɛ tikudɔkr kí taa bɛ kí baa Yerusalɛm ni, kí lá dɛre biʼtub.» ");
INSERT INTO gngNT_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","«N là joh ki tì nɛkn' Damas ya du, kuwensiiku ya yo, nɛ kuwenwenciɛnku kuba ci' ki ñɛn' paaki bó ní, ki wende' ki yile' nʼbo. ");
INSERT INTO gngNT_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","N lu' tingi ni, nɛ ki cii' uniɛke uba bó u teh: ‹Sɔl, Sɔl, bɛ tien' a jɛ̀ndeh nni?› ");
INSERT INTO gngNT_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Nɛ n niire' ki ye: ‹Yonbdaan, a yé u lɛ daan nɛ?› Nɛ u jiin' nni ki ye: ‹Min Nasarɛt ya *Yesu nɛ, a jɛ̀ndeh min nɛ.› ");
INSERT INTO gngNT_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Min nin bà là te nnɔ laa' kuwenwenku nnɔ ama ba cii' wà lienh nni nnɔ ya niɛke bó. ");
INSERT INTO gngNT_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Nɛ n tí niire' ki ye: ‹Yonbdaan, n li tien mila?› Nɛ u jiin' nni ki ye: ‹Fii kí jo Damas ya du ni, bi li tì tɔke ŋɛ a li tien nà kɛ.› ");
INSERT INTO gngNT_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Kuwenwenku nnɔ wende' nʼnun ni ma nnɔ, ma ji lɛnh, nɛ min nin bà tɔke nnɔ cuo' nʼnuɔ ki dìɛh n tì baa' Damas ya du ni. ");
INSERT INTO gngNT_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","«Ujɛ uba là te len, bi yih wɔ Ananiyas. U pɛ Uwien ya sɛn bo mɔnmɔnm, ki boh Moyis ya yiko nɛ *Sufmbɛ bà kɛ kɔ Damas ni nnɔ pɛ̀keh wɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","U baa' ki sere' nʼsaan nɛ ki tɔke' nni ki ye: ‹Nʼninjɛ Sɔl, likre.› Nɛ n pɔk ki likre' i ya tàan bo ki laa' wɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Nɛ u tɔke' nni ki ye: ‹Tiʼyaajɛb ya Wien juɔ' ki gɛ̀nde' ŋɛ, á bɛnde uʼyíem, kí lɛ *Yesu ugbɛmɔ̀ndaan, kí cii uʼniɛke bó. ");
INSERT INTO gngNT_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Kimɛ a li yé uʼmɔ̀nkunl nɛ binib kɛ ya nun bó, kí tɔke bɛ a laa' nà nin a cii' nà. ");
INSERT INTO gngNT_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Ji la taande, fii kí cère bɛ ń sìi ŋɛ Uwien ya ñunm, á tɛ uʼyel wɔ ń fère ŋɛ aʼbiɛre.› ");
INSERT INTO gngNT_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","«Ni ya puoli bó nɛ n liɛbe' Yerusalɛm. Lidaali liba nɛ n te Uwien ya duku ni ki kàareh nɛ nì tien' nni tidɛknt yaam, ");
INSERT INTO gngNT_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","n laa' Yonbdaan nɛ u tɔke' nni ki ye: ‹Fii kí ñɛ Yerusalɛm ni tonm, kimɛ len ya nib ŋa ń teke a li tɔke bɛ nʼgbɛr tà nnɔ.› ");
INSERT INTO gngNT_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Nɛ n jiin' wɔ ki ye: ‹Yonbdaan, bi bɛn ki ye min nɛ là joh *Sufmbɛ ya táan ya dur ni, ki coh binib bà teke' ŋɛ ki jin' nnɔ, ki tì pɛkndeh, ki jɛ̀ndeh bɛ ki gbiekeh. ");
INSERT INTO gngNT_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Bi là kuuleh aʼmɔ̀nkunl Etiɛnn uyo wà nnɔ, min mɔnɔn là te niʼsaan, ki tuo' ki ye nì mɔn, nɛ ki gu binib bà kuuleh wɔ nnɔ ya wɛngolkaar.› ");
INSERT INTO gngNT_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Nɛ u tɔke' nni ki ye: ‹Li joh, kimɛ n li sɔn ŋɛ nà bó fɔke, bà ŋa yé *Sufmbɛ nnɔ saan.› » ");
INSERT INTO gngNT_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Linigol nnɔ cenge' Pɔl bó ki tì baa' uyo wà u ye Yonbdaan ye wɔ ń jo bà ŋa yé *Sufmbɛ saan nnɔ, nɛ ki cin' ki wuureh ki teh: «Gben mɛn unil wuɔ ya gbɛr kitink bo, kimɛ na kpɛ wɔ ń li fuobe.» ");
INSERT INTO gngNT_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Nɛ ki tùɔreh ki wuureh, ki goreh biʼliɛrgbenkt ki wiɛnh, ki yiih titɛnt ki plèh paaki ki teh kutɛngunku. ");
INSERT INTO gngNT_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Nɛ Sojambɛ ya ciɛn nnɔ tɔke' uʼsɔjambɛ ki ye bɛ ń taa Pɔl kí kuɔn biʼduku ni, kí ñì wɔ inalɛbe, kí wɔbn wɔ wɔ ń tɔke u tien' bà ŋɔ bi wuureh uʼbo nɔ nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Bi lòle' Pɔl, bɛ ń ñì wɔ inalɛbe uyo wà nnɔ, nɛ u tɔke' Sojambɛ kobk ya ciɛn wà se uʼsaan nnɔ ki ye: «Ni ŋmɔbe usɛn ní ñì Erom yɔ, ka kpiɛ' ki bun' wɔ tibuur ki laa' uʼbiil-ii?» ");
INSERT INTO gngNT_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Sojambɛ kobk ya ciɛn nnɔ cii' nnɔ ma nnɔ nɛ ki jon' biʼciɛn nnɔ saan, ki tì tɔke' wɔ ki ye: «A bi ye á tien bɛ sɔ! Ujɛ nnɔ yé Erom yɔ nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Nɛ biʼciɛn nnɔ jon' Pɔl saan, ki tì niire' wɔ ki ye: «A yé Erom yɔ nɛ-ɛɛ?» Pɔl tuo'. ");
INSERT INTO gngNT_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Nɛ uciɛn nnɔ ye: «Min pɛ̀n' ilike ì yɛbe nɛ ki yaan ki kpɛnde' Erom ya nil.» Nɛ Pɔl ye: «Bi maa' min n yé Erom ya nil nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Pɔl len' nnɔ ma nnɔ nɛ bà bi li ñì wɔ kí wɔbn wɔ wɔ ń len nnɔ sule' ki sere' i ya tàan bo. Uciɛn nnɔ bɛnde' ki ye u lòle' unil wà nnɔ yé Erom yɔ ma nnɔ nɛ bujɛwaanbu cuo' wɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Tɔ, sojambɛ ya ciɛn nnɔ yíe wɔ ń tùɔre kí bɛnde *Sufmbɛ biindeh Pɔl nibonn nà bo ma nnɔ, kutaaku faa' nɛ u lore' Pɔl, ki cère' bitɔtuɔrciɛnb nin *Sufmbɛ ya buur ya cɛkl yaab kɛ taan', nɛ u cère' Pɔl baa' ki lá sere' biʼnun bó. ");
INSERT INTO gngNT_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pɔl caan' tibuur ya ciɛn nnɔ bo inun nɛ ki ye: «Nʼyaabɛ, n bɛn nʼyɛnm ni ki ye ma ŋmɔbe biil Uwien ya nun bó haali nin fɛnfɛnnɔ.» ");
INSERT INTO gngNT_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","U len' nnɔ ma nnɔ, nɛ bitɔtuɔrciɛnb ya ciɛn Ananiyas tɔke' bà se ki nɛke Pɔl nnɔ ki ye bɛ ń ñì uʼñɔbu bó nɛ bi ñi'. ");
INSERT INTO gngNT_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Nɛn saan nɛ Pɔl tɔke' wɔ ki ye: «A yíe a li mɔn binib ya nun ni nɛ, Uwien nɛ li ñì sin. A kɛ niɛ saan ki ye a buh nni tibuur tiʼyiko ye ma bo nɛ, nɛ ki kɛnde' *yiko bugbɛn bo ki ye bɛ ń ñì nni.» ");
INSERT INTO gngNT_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Nɛ binib bà te niʼsaan nnɔ tɔke' Pɔl ki ye: «A sukreh bitɔtuɔrciɛnb ya ciɛn sɔ-ɔɔ?» ");
INSERT INTO gngNT_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Nɛ Pɔl ye: «Weee! Nʼyaabɛ, ma bɛn ki ye u yé bitɔtuɔrciɛnb ya ciɛn. N bi bɛn la, ma bi li len nnɔ, kimɛ nì kɛle' *Uwien ya gbɔnku ni ki ye: ‹Ŋa ń len aʼdu ya ciɛn fɛnfɛnm.› » ");
INSERT INTO gngNT_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Tɔ, Pɔl bɛn ki ye biʼni biba yé Saduseyɛnmbɛ nɛ, bitɔb mɔ yé Farisiɛnmbɛ. Nɛ u wuure' tibuur ya cɛkl yaab nnɔ ya siik ni ki ye: «Nʼyaabɛ, n yé Farisiɛn nɛ, nɛ nʼbaa mɔ yé Farisiɛn. N ŋmɔbe lidɛndɛnl ki ye bitɛnkpiib li mɛkre. Lidɛndɛnl nnɔ bo nɛ, bi buh nni tibuur.» ");
INSERT INTO gngNT_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","U len' nnɔ uʼñɔbu ŋa lu', nɛ Farisiɛnmbɛ nin Saduseyɛnmbɛ cin' ki findeh nin tɔb, nɛ linigol nnɔ bore' mile. ");
INSERT INTO gngNT_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Saduseyɛnmbɛ bɛn, maaleh ki teh tɛnkpiib ŋa ń mɛkre, Wien ya tondb ŋa te, ciiku mɔ ŋa te, ama *Farisiɛnmbɛ bɛn teh niʼkɛ te nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Bi biɛ findeh nin tɔb, ki ŋmɔbe kuwaaku ki gbien', nɛ *Yiko ya wɔnwɔknb ni bà yé *Farisiɛnmbɛ nnɔ ya biba fii' ki sere' ki len' ufaa bo ki ye: «Ta laa' ujɛ wuɔ ya biil. Nba la, Uwien ya tond bii niba nɛ len' nin wɔ.» ");
INSERT INTO gngNT_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Ifinfinde nnɔ brikreh ki joh ma nnɔ, Sojambɛ ya ciɛn nnɔ fɛnge bi la lá dɛre kí tɔnde Pɔl nɛ ki tɔke' uʼsojambɛ ki ye bɛ ń jiire kí jo kí tì ñɛn Pɔl biʼni, kí jiin biʼduku ni. ");
INSERT INTO gngNT_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Niʼdaali ya ñɔnku nɛ Yonbdaan baa' Pɔl saan, ki tɔke' wɔ ki ye: «Cuo aʼba. A tɔke' binib nʼgbɛr Yerusalɛm ni ma bo nnɔ, a li tì tɔke tù nnɔ nɛ Erom ya du ni mɔ.» ");
INSERT INTO gngNT_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Kutaaku faa' nɛ *Sufmbɛ biba taan' ki kpaan' iyɛ ki pole' ki ye ba ku' Pɔl la, ba ń ji ka ń ñu mɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Binib bà kpaan' iyɛ nnɔ gɛ̀bre' pinan. ");
INSERT INTO gngNT_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Bi jon' bitɔtuɔrciɛnb nin *Sufmbɛ ya ciɛnb saan, ki tì tɔke' bɛ ki ye: «Ti pole' ki ye ta ku' Pɔl la, ta ń ji bonn. ");
INSERT INTO gngNT_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Fɛnfɛnnɔ ninbi nin *Sufmbɛ ya buur ya cɛkl yaab tuo' la, ní sɔn unil wɔ ń jo Sojambɛ ya ciɛn saan kí tì tɔke wɔ kí ye wɔ ń cère Pɔl ń baa niʼsaan, ní tùɔre kí fìin uʼgbɛr. Tinbi bonde' ŋɔ tí ku wɔ, wa ń baa niɛ saan.» ");
INSERT INTO gngNT_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Pɔl ya ninsɛ ya bijɛ cii' bi bonde' ma bo, nɛ ki jon' Sojambɛ ya tonsɔnduku bó, ki tì kɔn' ki tɔke' Pɔl. ");
INSERT INTO gngNT_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Nɛn saan nɛ Pɔl yin' Sojambɛ kobk ya ciɛn uba, ki tɔke' wɔ ki ye: «Pìɛre unacien wuɔ niʼciɛn saan, kimɛ u ŋmɔbe tigbɛr tuba wɔ ń tɔke wɔ.» ");
INSERT INTO gngNT_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Nɛ sojambɛ kobk ya ciɛn nnɔ taa' wɔ ki jon' biʼciɛn nnɔ saan, ki tì tɔke' wɔ ki ye: «Lipɛkl ya nil Pɔl nɛ yin' nni ki tɔke' nni ki ye ń pìɛre unacien wuɔ aʼsaan, u ŋmɔbe tigbɛr tuba wɔ ń tɔke ŋɛ.» ");
INSERT INTO gngNT_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Sojambɛ ya ciɛn nnɔ cuo' unacien nnɔ ya nuɔ bi jɛnde', nɛ u niire' wɔ ki ye: «A yíe á tɔke nni bɛ ya gbɛr-i?» ");
INSERT INTO gngNT_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Nɛ u ye: «*Sufmbɛ biba bonde', ki ye bi li tɔke ŋɛ kí ye á wun taa Pɔl ní tibuur ya ciɛnb saan, ŋɔ bɛ ń tùɔre kí fìin uʼgbɛr. ");
INSERT INTO gngNT_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Bi tɔke' ŋɛ la, a la tuo, kimɛ bijɛb bà nuunh bɛ ń gùbn usɛn bó kí ku Pɔl nnɔ gɛ̀bre' pinan. Bi pole' ki ye ba ku' Pɔl la, ba ń ji ka ń ñu mɔ. Fɛnfɛnnɔ bi bonde' ki gben'-a, bi ji cengeh sin bó nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Nɛ Sojambɛ ya ciɛn nnɔ tɔke' unacien nnɔ ki ye: «La tɔke nil kí ye a tɔke' nni tigbɛr tù nɔ», nɛ ki cère' u bure'. ");
INSERT INTO gngNT_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Sojambɛ ya ciɛn nnɔ yin' sojambɛ kobk ya ciɛnb ni bile ki tɔke' bɛ ki ye bɛ ń taa Sojambɛ kobiile nin bitɛnjɛkb pilole nin sojambɛ bà bukeh ikpaan nnɔ kobiile, bɛ ń bonde kí lá bure kuñɔnku tikur tuwɛ ya yo Sesare ya du bó. ");
INSERT INTO gngNT_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Ní bonde itaan mɔ kí taa Pɔl kí jo gobina Feliks saan, wɔ ń ñɛ caabu, niba la tien wɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Sojambɛ ya ciɛn nnɔ kɛle' kugbɔnku bɛ ń tì de gobina Feliks. U kɛle' ki ye: ");
INSERT INTO gngNT_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","«Min Klod Lisiyas nɛ fuondeh sin uciɛn, gobina Feliks. ");
INSERT INTO gngNT_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","*Sufmbɛ là cuo' ujɛ wuɔ ki benh bɛ ń ku wɔ nɛ. N cii' u yé Erom yɔ ma nnɔ nɛ n taa' Sojambɛ ki tì fie' wɔ biʼsaan. ");
INSERT INTO gngNT_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","N là yíe ń bɛnde bi biindeh wɔ bà bo ma nnɔ, nɛ ki taa' wɔ ki jon' *Sufmbɛ ya buur ya cɛkl yaab saan. ");
INSERT INTO gngNT_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Bi bun' wɔ tibuur, nɛ n bɛnde' ki ye bi biindeh wɔ biʼyiko bo nɛ. Ma laa' u tien' nà, nì kpɛ bɛ ń ku wɔ bii bɛ ń pɛkn wɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","N cii' bi ye *Sufmbɛ kpaan' iyɛ bɛ ń bɔle kí ku wɔ ma nnɔ nɛ n cère' bi taa' wɔ i ya tàan bo ki baa' aʼsaan, ki tɔke' binib bà biindeh wɔ nnɔ ki ye biʼmɔ ń jo aʼsaan, kí tì tɔke ŋɛ bi biindeh wɔ bà bo.» ");
INSERT INTO gngNT_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Tɔ, Sojambɛ nnɔ paan' biʼciɛn tɔke' bɛ nà nnɔ bo, nɛ ki taa' Pɔl kuñɔnku ki jon' Antipatis ya du bó. ");
INSERT INTO gngNT_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Kutaaku faa' nɛ Sojambɛ bà cuonh tingi ni nnɔ liɛbe' biʼduku bó, nɛ bitɛnjɛkb nnɔ gɛ̀bre' nin Pɔl ki joh Sesare ya du bó. ");
INSERT INTO gngNT_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Bi tì baa' ki taa' kugbɔnku nnɔ ki de' gobina Feliks, nɛ ki taa' Pɔl mɔ ki ŋukn' wɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Gobina nnɔ kaan' kugbɔnku nnɔ ki gben', nɛ ki niire' Pɔl ki ye «A yé mi lɛ tinfɛnm bɛ yɔ nɛ?» Nɛ Pɔl ye: «N yé Silisi yɔ nɛ.» U cii' u yé Silisi yɔ ma nnɔ, ");
INSERT INTO gngNT_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","nɛ u tɔke' wɔ ki ye: «Binib bà biindeh ŋɛ nnɔ mɔ baa' ní la, n li cenge aʼgbɛr.» Ki cère' u te ubɛr Herod là mɛn' kubɛrduku kùa nnɔ ni, nɛ bi gu wɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Iwien iŋun gɛ̀bre', nɛ bitɔtuɔrciɛnb ya ciɛn Ananiyas baa' Sesare ya du ni nin *Sufmbɛ ya ciɛnb biba nin lɔya uba bi yih wɔ Tɛtulus. Nɛ bi biin' Pɔl gobina Feliks ya nun bó. ");
INSERT INTO gngNT_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Bi yin' Pɔl u baa' nɛ Tɛtulus cin' ki biindeh wɔ ki teh: «Uciɛn Feliks, sin bo nɛ ti ŋmɔbe uñɔkpaan ki tì gben' kí ñɛ a laa' miyɛnfuom mà ki tuke' milèbrm ki baa' tiʼdu wuu ni nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Ti lɛnh a teh mimɔnm mà uyo kɛ niʼkɛ saan, nɛ ki faareh ŋɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Ma yíe ń len kí wuɔke kí ŋaabe aʼyɛnm. Nɛn bo, n gbáanh ŋɛ aʼnimɔ̀nt bo, á cenge tiʼbo waamu. ");
INSERT INTO gngNT_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Ti sekn' ki laa' ujɛ wuɔ yé unibiɛrɔ nɛ. U kpìindeh *Sufmbɛ bà kɛ te uŋɛndun wuu ni nɛ, ki cèreh bi teh fɛnfɛnm. Wɔn nɛ yé licɛkl là pɛ Nasarɛt ya *Yesu ya sɛn bo nnɔ ya ciɛn. ");
INSERT INTO gngNT_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","U là bikn' wɔ ń kuɔn Uwien ya duku tijɔknt mɔnɔn nɛ ti cuo' wɔ. Ti là yíe tí bu wɔ tibuur tiʼyiko ye ma bo nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Nɛ Sojambɛ ya ciɛn Lisiyas baa' ki lá taa' ufaa ki fie' wɔ tiʼsaan, ");
INSERT INTO gngNT_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","ki tɔke' binib bà biindeh wɔ nnɔ ki ye bɛ ń jo aʼsaan. Sin mɔnɔn bun' wɔ tibuur la, a li bɛnde ti biindeh wɔ bà bo.» ");
INSERT INTO gngNT_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Sufmbɛ taan' Tɛtulus buñɔbu ki ye u len' tà nɔ tù te nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Nɛn saan nɛ Feliks yuon' unuɔ ki de' Pɔl usɛn wɔ ń len. Nɛ Pɔl ye: «N bɛn ki ye a ŋuuke udu wuu nì tien' ibin yà yɛbe, nɛn bo, n li tɔke ŋɛ nʼgbɛmɔ̀nt nin midum. ");
INSERT INTO gngNT_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","N don' Yerusalɛm bó ki tì puke' Uwien ma na gɛ̀bre' iwien piik nin ile. A li fre kí niire binib kí liike tù te bii ta te. ");
INSERT INTO gngNT_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Nil ŋa laa' n te Uwien ya duku ni bii *Sufmbɛ ya táan ya dur ni bii udu ni niba saan ki findeh nin uba bii ki sureh binib bɛ ń kpre. ");
INSERT INTO gngNT_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Ba ń fre kí wuɔn ŋɛ fɛnfɛnnɔ wuɔ nɔ bi biin' nni bà bo. ");
INSERT INTO gngNT_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","N bɛn nà sɔ ń tɔke ŋɛ: n pɛ *Yesu ya sɛn bo ŋɔ ń li pukeh tiʼyaajɛb ya Wien mɔnmɔnm nɛ, nɛ bɛn *Sufmbɛ lienh ki teh usɛn nnɔ ŋa yé sɛnmɔ̀n. N boh nà kɛ kɛle' *yiko ya gbɔnku ni nin *Uwien ya ñɔbonsɔknb kɛle' nà kɛ nnɔ mɔ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","N ŋmɔbe lidɛndɛnl là nnɔ, bɛn mɔnɔn ŋmɔbe li ya dɛndɛnbaabl nɛ, ki ye Uwien li mɛkre bitɛnkpiib, bà mɔn nin bà bre kɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Nɛn bo nɛ n tuu ki ñikndeh n la li ŋmɔbe biil Uwien nin binib saan. ");
INSERT INTO gngNT_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","«N tien' ibin yà yɛbe ka te Yerusalɛm ni, nɛ ki liɛbe' ní ń lá pu nʼdu ya jiinb bupaabu, kí tùɔre lituɔrl kí de Uwien. ");
INSERT INTO gngNT_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Nɛn saan nɛ bi laa' nni n te uyo wà Uwien ya duku ya luo bo ki teh tijɔknt ya ñɛnm ya tuɔrl nnɔ. Ba laa' nni nin nigol, ka laa' n cère' nib mɔ kpre' ma. ");
INSERT INTO gngNT_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Ama *Sufmbɛ bà ñɛn' ní Asi ya tinfɛnm bó ní nnɔ, nɛ là laa' nni. Bi bi ŋmɔbe nʼbo tigbɛr la, bɛn nɛ bi li baa aʼsaan kí là biin nni, ");
INSERT INTO gngNT_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","bii bɛn bà biindeh nni nɔ, bɛ ń tɔke ŋɛ *Sufmbɛ ya buur ya cɛkl yaab bun' nni tibuur Yerusalɛm ni ma nnɔ bi laa' nʼbiil li la? ");
INSERT INTO gngNT_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Nba la, n là sere' biʼnun bó ma ki wuure' ki len' liñɔbonl là baba ki ye: ‹N teke' ki jin' ki ye Uwien li mɛkre bitɛnkpiib nnɔ bo nɛ ni buh nni tibuur dinnɔ.› » ");
INSERT INTO gngNT_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Feliks bɛn *Yesu ya sɛn ya paanm bo ya gbɛr mɔnmɔnm. Nɛn bo nɛ u tɔke' bɛ ki ye: «Liɛbe ní mɛn lidaali liba. Sojambɛ ya ciɛn Lisiyas lá baa' ní la, n li liike niʼgbɛr ya tingi.» ");
INSERT INTO gngNT_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Nɛ ki tɔke' Sojambɛ kobk ya ciɛn ki ye wɔ ń li gu Pɔl, ki la li wɔbndeh wɔ isɛn iba ni. Uʼyaab ye bɛ ń tore wɔ la, u la piendeh bɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Iwenkàankɛ gɛ̀bre', nɛ Feliks tɔke nin uʼpo Drusil ki baa' tibuur ni. Uʼpo nnɔ yé Suf nɛ. Feliks sɔn' bɛ ń tì yin Pɔl ní wɔ ń lá tɔke bɛ tigbɛr tà li cère bɛ ń teke *Yesu Kristo kí ji ŋɔ bɛ ń cenge. ");
INSERT INTO gngNT_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Pɔl te ki lienh ki wɔngeh unil li teh ma kí li cuube nin u li coh uʼba ma bo, kimɛ Uwien li bu binib tibuur ma nnɔ, nɛ bujɛwaanbu cuo' Feliks, nɛ u ye: «Fɛnfɛnnɔ á li fre kí li joh, n lá laa' mifɛnm la, n li liɛbe kí yin ŋɛ.» ");
INSERT INTO gngNT_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Feliks daan ki teh nba la Pɔl li de wɔ ilike nɛ. Nɛn bo nɛ u sɔnh ki yih wɔ uyo kɛ bi tɔkeh tigbɛr. ");
INSERT INTO gngNT_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Ibinŋmɛn ile gɛ̀bre', nɛ gobina wà bi yih wɔ Pɔsiyus Fɛstus nnɔ baa' ki lá lère' Feliks ya lènl. Feliks yíe wɔ ń sɔnge *Sufmbɛ ya yɛnm ma nnɔ nɛ ki dàan' Pɔl juore' ki paake. ");
INSERT INTO gngNT_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Gobina Fɛstus baa' Sesare ya du ni, ki tien' len iwien ita nɛ ki don' Yerusalɛm bó. ");
INSERT INTO gngNT_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","U tì baa' nɛ bitɔtuɔrciɛnb nin *Sufmbɛ ya buur ya cɛkl yaab nnɔ ya sɛnlierb baa' uʼsaan, ki lá biin' Pɔl, ki gbáan' Fɛstus cɛɛn, ");
INSERT INTO gngNT_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","ki ye u la yìe, wɔ ń ñikn kí cère bɛ ń taa Pɔl kí baa Yerusalɛm ni. Kimɛ bi kpaan' iyɛ u we ní la, bɛ ń ku wɔ usɛn ni nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Nɛ Fɛstus tɔke' bɛ ki ye: «Pɔl laan biɛ ki te lipɛkl ni nɛ Sesare ya du ni. Nɛ min mɔnɔn li liɛbe kí kun i tàan yiɛ bo nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","U ŋmɔbe libiil la, cère mɛn niʼciɛnb ń paan nʼbo kí tì biin wɔ nɛn bó.» ");
INSERT INTO gngNT_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Fɛstus lii tien' Yerusalɛm ni iwien iniin bii iwien piik nɛ ki yaan ki liɛbe' Sesare ya du bó. Kutaaku faa' nɛ u kɔn' ki kɛ̀le' tibuur ya duku ni ki sɔn' bɛ ń tì taa Pɔl ní. ");
INSERT INTO gngNT_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Pɔl baa' ma nnɔ nɛ *Sufmbɛ bà ñɛn' ní Yerusalɛm nnɔ guɔn' wɔ, ki biindeh wɔ nì bre isɛn yà yɛbe ni, ka ń fre kí wuɔn kí ye bi lienh tà nnɔ tù te. ");
INSERT INTO gngNT_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Pɔl yíe wɔ ń fie uʼba nɛ ki len' ki ye: «Ma saa' *Sufmbɛ ya yiko, ka saa' Uwien ya duku, ka bii' ubɛrciɛn Sesa mɔ.» ");
INSERT INTO gngNT_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Fɛstus yíe wɔ ń sɔnge *Sufmbɛ ya yɛnm, nɛ ki niire' Pɔl ki ye: «A yíe á dùo Yerusalɛm bó bɛ ń tì bu ŋɛ tibuur tigbɛr tuu bo nʼnun bó-oo?» ");
INSERT INTO gngNT_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Nɛ Pɔl jiin' wɔ ki ye: «N li sere ubɛrciɛn Sesa ya nun bó uʼbuur ya duku ni nɛ. Bi li bu nni tibuur nɛn saan nɛ. Sin mɔnɔn bɛn mɔnmɔnm ki ye ma bii' *Sufmbɛ niba. ");
INSERT INTO gngNT_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","N bi bii' bii n bi tien' nibonn nà kpɛ mikuum la, ma bi li nuunh ń ŋmɛre. Ama bi biindeh nni nà bo ŋa yé gbɛmɔ̀nt la, uba ŋa ń fre kí taa nni kí ŋukn bɛ. Ubɛrciɛn Sesa nɛ li bu nʼbuur.» ");
INSERT INTO gngNT_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Nɛn saan nɛ Fɛstus nin uʼgbegbierkaab taan' ki liike' tigbɛr nnɔ nɛ u tɔke' Pɔl ki ye: «A ye ubɛrciɛn Sesa nɛ li bu aʼbuur ma nɔ a li jo wɔn saan nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Iwenkàankɛ gɛ̀bre', nɛ ubɛr Agripa nin uʼninsɛ Berenis tɔke ki baa' Sesare ya du ni, bɛ ń fuonde Fɛstus. ");
INSERT INTO gngNT_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Bi tien' len idɛn ile ma nnɔ nɛ Fɛstus tɔke' ubɛr Agripa Pɔl ya gbɛr ki ye: «Ujɛ uba te libùol liɛ nɔ, Feliks nɛ là pɛkn' wɔ, u juore' ki te lipɛkl ni. ");
INSERT INTO gngNT_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","N là jon' Yerusalɛm uyo wà nnɔ nɛ bitɔtuɔrciɛnb nin *Sufmbɛ ya ciɛnb baa' ki lá biin' ujɛ bugbɛn ki ye u kpɛ mikuum nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Nɛ n jiin' bɛ ki ye tinbi Erom yaab ya tentienm ni, bi biin' unil la, ti tì ń kòle' wɔn nin binib bà biindeh wɔ nnɔ nɛ, wɔ ń cii bi biindeh wɔ bà bo, kí cère uʼmɔ ń len u li len ma kí fie uʼba. Ta ń dɛre nil ya tubl ka kpiɛ' ki bun' wɔ buur. ");
INSERT INTO gngNT_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","N tɔke' bɛ nnɔ, nɛ bi baa' ní. Kutaaku faa' ma, ma taande', n kɔn' ki kɛ̀le' tibuur ya duku ni nɛ, ki sɔn' bi tì taa' ujɛ nnɔ ní. ");
INSERT INTO gngNT_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Nɛ binib bà biindeh wɔ nnɔ fii' ki sere' ki guɔn' wɔ ki biindeh wɔ. Min maaleh ki teh bi li biin wɔ nibonn nà bo nnɔ li bre ki tì kɛnde' nɛ, ama na te nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","N laa' bi findeh nin wɔ nà bo nnɔ, yé biʼWien bo ya paanm ya gbɛr nɛ nin ujɛ wà bi yih wɔ *Yesu u kpo' ŋɔ Pɔl lienh ki teh u fuobe nnɔ ya gbɛr nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Ma là bɛn n li tien ma tigbɛr nnɔ. Nɛ n niire' Pɔl ki ye u yíe wɔ ń jo Yerusalɛm bɛ ń tì bu wɔ tibuur tigbɛr nnɔ bo nɛn bó-oo? ");
INSERT INTO gngNT_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Ama u ye ubɛrciɛn Sesa nɛ li bu uʼbuur. Nɛn bo nɛ n cère' u te lipɛkl ni, kí tì baa lidaali là n li cère bɛ ń taa wɔ kí jo ubɛrciɛn saan.» ");
INSERT INTO gngNT_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Nɛ ubɛr Agripa tɔke' Fɛstus ki ye: «Min mɔnɔn bi yíe ń cenge ujɛ bugbɛn bó.» Nɛ Fɛstus tɔke' wɔ ki ye: «Wenli a li wun cenge uʼbó.» ");
INSERT INTO gngNT_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Kutaaku faa' nɛ ubɛr Agripa nin Berenis baa' binikpɛkpiɛkb ya baam, ki tɔke nin sojambɛ ya ciɛnb nin udu nnɔ ni ya ciɛnb, ki lá kɔn' kuduciɛnku kùa ubɛr teknh binib kuʼni nnɔ ni. Nɛ Fɛstus sɔn' bi taa' Pɔl ní. ");
INSERT INTO gngNT_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Nɛ ki len' ki ye: «Ubɛr Agripa nin ninbi bà kɛ te nin tɛ niɛ saan nɔ, ni likeh ujɛ wà nɔ, *Sufmbɛ kɛ là baa' nʼsaan Yerusalɛm ni, ki tí baa' niɛ saan mɔ, ki là wuureh ki teh na kpɛ wɔ ń ji li fuobe. ");
INSERT INTO gngNT_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Min ya bùol ma laa' u tien' nà nì kpɛ kuum; ama wɔn nin uʼyul ye ubɛrciɛn nɛ li bu uʼbuur ma nnɔ, nɛ n ye nì mɔn ń jon wɔ nɛn bó nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","N yíe ń kɛle kugbɔnku kí de ubɛrciɛn kí tɔke wɔ Pɔl ya gbɛr nɛ, ka bɛn n li cinbe kí kɛle kí kun nà bó, nɛn bo nɛ n taa' wɔ ki sien' niʼnun bó. N cinbe ki sien' wɔ sin ubɛr Agripa ya nun bó nɛ, á niire wɔ uʼgbɛr nnɔ te ma bo, ŋɔ n bɛnde' n li kɛle kí kun nà bó. ");
INSERT INTO gngNT_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Kimɛ n maale' ki ye nà mɔn ń cère bɛ ń taa' lipɛkl ya nil kí jo Ubɛrciɛn saan ka tɔke' bi biin' udaan nà bo.» ");
INSERT INTO gngNT_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Tɔ, ubɛr Agripa tɔke' Pɔl ki ye: «A ŋmɔbe usɛn á len kí fie aʼba.» Nɛ Pɔl yuon' unuɔ ki cin' ki tɔkeh ki teh: ");
INSERT INTO gngNT_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","«Ubɛr Agripa, nʼyɛnm sɔnge cɛɛn nin n laa' usɛn dinnɔ wuɔ ma ń len aʼnun bó kí fie nʼba *Sufmbɛ biin' nni mibiinm mà kɛ nnɔ ni. ");
INSERT INTO gngNT_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","N bɛn ki ye a bɛn *Sufmbɛ ya tentienm kɛ, ki bɛn bi findeh nin tɔb nà bo. Nɛn bo nɛ n gbáanh ŋɛ á duɔn aʼyɛnm kí li cengeh n li len kí ye bà. ");
INSERT INTO gngNT_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","«*Sufmbɛ kɛ bɛn n là te ma nʼnacenfɛ̀nm ni. Bi bɛn haali micincinm n là fuobe ma bo nʼdu ya nib ni nin Yerusalɛm ni. ");
INSERT INTO gngNT_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Bi bɛn nni nì wuɔke' ki ye n yé Farisiɛnmbɛ ya cɛkl yɔ nɛ. Li ya cɛkl nɛ boh Moyis ya yiko mɔnmɔnm ki cɛn' icɛktɔ. Bi yíe la, bi li fre kí kun imɔ̀n. ");
INSERT INTO gngNT_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","N ŋmɔbe lidɛndɛnl Uwien là pùon' lipuonl là ki de' tiʼyaajɛb nnɔ bo nɛ. Nɛn bo nɛ bi buh nni tibuur dinnɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Tinbi *Sufmbɛ ya baamul piik nin ile nnɔ kɛ pukeh Uwien ñɔnku nin wien ni, nɛ ki daan ki ye Uwien li tien uʼpuonl nnɔ. Ubɛr Agripa, li ya dɛndɛnl bo nɛ *Sufmbɛ biindeh nni. ");
INSERT INTO gngNT_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Ninbi Sufmbɛ, bɛ bo nɛ na teke' ki jin' ki maaleh ki teh Uwien ŋa ń mɛkre tɛnkpiib-i? ");
INSERT INTO gngNT_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Min mɔnɔn là maaleh ki teh nì kpɛ, nì tuo' la, ń ñɛ isɛn kɛ kí saa Nasarɛt ya *Yesu ya yel nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","N là teh nnɔ nɛ Yerusalɛm ni. Min nin nʼyul là coh Uwien ya nib nɛ ki tì pɛkndeh, kí ñɛ bitɔtuɔrciɛnb de' nni usɛn wà nnɔ bo. Bi là ye bi li ku bɛ la, nʼmɔ se biʼciɛk bó nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Uyo kɛ n là joh *Sufmbɛ ya táan ya dur ni nɛ ki tì jɛ̀ndeh Uwien ya nib, ki wɔbndeh bɛ bɛ ń suke wɔ. Nʼbenku ni là piebe' biʼbo ki gbien', nɛ n joh idu yà ŋa te *Sufmbɛ ya tinfɛnm ni bó, ki tì jɛ̀ndeh bɛ.» ");
INSERT INTO gngNT_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","«Nnɔ nɛ lidaali liba bitɔtuɔrciɛnb de' nni usɛn ń jo kí tì cuo binib bà teke' *Yesu ki jin' ki te Damas ya du ni nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Ubɛr Agripa, n là te usɛn ni ki joh Damas bó ma nnɔ, kuwensiiku ya yo nɛ n laa' kuwenwenku kuba ñɛn' paaki bó ní ki windeh ki cɛn' uwien, ki wende' ki yile' min nin nʼtɔntɔknlieb bo. ");
INSERT INTO gngNT_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Tiʼkɛ lu' tingi ni, nɛ n cii' uniɛke uba bó u len' *Sufmbɛ ya lenm ni ki ye: ‹Sɔl, Sɔl, bɛ tien' a jɛ̀ndeh nni? Nì bre aʼbo nin á mɔ̀ nin Uwien.› ");
INSERT INTO gngNT_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Nɛ n niire' wɔ ki ye: ‹Yonbdaan, a yé u lɛ daan nɛ?› Nɛ u tɔke' nni ki ye: ‹Min *Yesu nɛ, a jɛ̀ndeh min nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Fii kí sere, kimɛ n baa' aʼsaan, ki gɛ̀nde' ŋɛ á sɔn nʼtuonl nɛ, kí li yé n cère' a laa' tibont tà nɔ nin n lá li cère á lɛ tà nnɔ ya mɔ̀nkunl. ");
INSERT INTO gngNT_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","N sɔnh ŋɛ *Sufmbɛ nin bà ŋa yé *Sufmbɛ nnɔ saan nɛ. N li cère bi la fre kí tien ŋɛ niba. ");
INSERT INTO gngNT_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Tì wende biʼnun bó, kí ñɛn bɛ licinñunl ni, kí cère bɛ ń li te kuwenwenku ni, kí fie bɛ *Satan ya nuɔ ni, kí taa bɛ kí ŋukn Uwien, ŋɔ Uwien ń fère bɛ biʼbiɛre, kí de bɛ lifaal là Uwien li de lɛ̀ binib bà teke' min *Yesu ki jin' ki yé uʼyaab nnɔ.› » ");
INSERT INTO gngNT_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","«Tɔ, ubɛr Agripa, kí ñɛ nɛn daali ma, ma yìe' udaan wà len' nni paaki bó tidɛknt yaam nnɔ ya ñɔbu bó. ");
INSERT INTO gngNT_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","N kpiɛ' ki tɔke' Damas ya du ya nib nɛ Uwien ya gbɛr, ki tuɔn' Yerusalɛm yaab nin Sude ya tinfɛnm kɛ yaab nin bà ŋa yé Sufmbɛ. N tɔke' bɛ ki ye bɛ ń lèbre biʼtetem kí paan Uwien ya sɛn bo kí sɔn itùon yà wɔngeh ki teh bi mɔnbe ki lèbre' biʼtetem. ");
INSERT INTO gngNT_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Nɛn bo nɛ *Sufmbɛ cuo' nni Uwien ya duku ya luo bo, ki nuunh bɛ ń ku nni. ");
INSERT INTO gngNT_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Ama Uwien pi nʼbo haali nin dinnɔ, nɛ ki cère' n yé uʼmɔ̀nkunl mubumu nin biciɛnb kɛ ya nun bó. Ma tɔkeh tuba ki kɛnde' *Uwien ya ñɔbonsɔknb nin Moyis là len' ki ye tà li tien nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","N tɔkeh ki teh Uwien ya Nigɛndkɛ Kristo lì bi li ji ijɛnd nɛ, kí li yé unil wà li kpiɛ kí mɛkre bitɛnkpiib ni, kí li wɔngeh *Sufmbɛ nin bà ŋa yé *Sufmbɛ Uwien ya wenwenku.» ");
INSERT INTO gngNT_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Pɔl lienh wɔ ń fie uʼba ma nnɔ, nɛ Fɛstus len' ufaa bo ki ye: «Pɔl, a yé uwaar nɛ. Aʼbɛnciɛnm nɛ cère' a waare'.» ");
INSERT INTO gngNT_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Nɛ Pɔl jiin' wɔ ki ye: «Uciɛn Fɛstus, ma yé waar. N lienh tigbɛmɔ̀nt nɛ, na yé waarlenm. ");
INSERT INTO gngNT_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Ubɛr Agripa bɛn tigbɛr nnɔ. Nɛn bo nɛ n laa' lifɛ̀l ki lienh uʼnun bó. N bɛn ki ye tigbɛr nnɔ tuba ŋa luɔn' wɔ, kimɛ tigbɛr nnɔ ŋa là tien' bɔlm ni. ");
INSERT INTO gngNT_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Ubɛr Agripa, a teke' *Uwien ya ñɔbonsɔknb là len' nà nnɔ ki jin'-ii? N bɛn ki ye a teke' ki jin'.» ");
INSERT INTO gngNT_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Nɛ Agripa niire' Pɔl ki ye: «Nì sìen' waamu nɛ á sure nni ń tien Kristo yɔ.» ");
INSERT INTO gngNT_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Nɛ Pɔl ye: «N kàareh Uwien tuo' la, nì yé fɛnfɛnnɔ bii uyo uba nɛ la, sin nin binib bà kɛ cengeh nʼbó nnɔ, ń tien *Kristo yaab tɛn min nɛ. Ama ma yíe bɛ ń lòle nɛ tikudɔkr tɛn min». ");
INSERT INTO gngNT_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Nɛ ubɛr Agripa nin gobina Fɛstus nin Berenis nin binib bà kɛ te kuducɛnciɛnku kùa ubɛr teknh binib kuʼni nnɔ fii', ");
INSERT INTO gngNT_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","ki ñɛh nɛ ki tɔkeh tɔb ki teh: «Ujɛ wuɔ ŋa tien' nà kpɛ kuum bii pɛkl.» ");
INSERT INTO gngNT_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Nɛ Agripa tɔke' Fɛstus ki ye: «Ujɛ bugbɛn ŋa bi ye ubɛrciɛn Sesa nɛ li bu uʼbuur la, ti bi li fre kí wiɛ wɔ.» ");
INSERT INTO gngNT_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Tɔ, bi tɔke' ki ye ti li jo Itali bó ma nnɔ, nɛ bi taa' Pɔl nin lipɛkl ya nitɔb ki de' Sojambɛ kobk ya ciɛn uba bi yih wɔ Juliyus. U te sojacɛkl là ni nnɔ ya yel si «Ubɛrciɛn ya Sojambɛ nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Buñɛrciɛnbu buba là te ki yé Adramiti ya du ya ñɛrbu, ki joh Asi ya tinfɛnm bó, nɛ ti kɔn' bù ki bure'. Tinbi nin ujɛ uba nɛ là tɔke bi yih wɔ Aristak. U yé Maseduɔnn ya tinfɛnm ya nil nɛ, ki kɔ Tesalonik ya du ni. ");
INSERT INTO gngNT_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Kutaaku faa' nɛ ti baa' Sidɔn ni. Sojambɛ ya ciɛn Juliyus ŋuuke Pɔl nin tinimɔ̀nt ma nnɔ nɛ ki cɛ̀be' wɔ, wɔ ń jo uʼjɔtieb saan bɛ ń tì teke wɔ kucɛ̀nku. ");
INSERT INTO gngNT_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Ti siere' niʼsaan ki joh, kutafaaku tobreh tɛ ma nnɔ, nɛ ti likn' Ciip ya dekl ki nuɔn lɛ̀, ");
INSERT INTO gngNT_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","ki tì puore' miñunciɛnm mà nuɔn Silisi nin Panfili ya tinfɛnm nnɔ, nɛ ki tì baa' Lisi ya tinfɛnm ya du uba ni bi yih wù Mira. ");
INSERT INTO gngNT_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Nɛn saan nɛ Sojambɛ ya ciɛn nnɔ laa' Alɛksandri ya du ya ñɛrciɛnbu buba, bù joh Itali ya du bó, nɛ u cère' ti kɔn' bun. ");
INSERT INTO gngNT_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Ti là tien' iwenkàankɛ nɛ ki jɛ̀njɛ̀ndeh ki tì nɛkn' Kinid ya du. Tiʼñɛrbu là joh sosuo nɛ, kimɛ kutafaaku là tobreh tɛ nɛ, nɛ ti wiɛ' ti bi cuube nà bó nnɔ, ki cubn' Salomone ki tì linde' Krɛt ya dekl, ki nuɔn lɛ̀. ");
INSERT INTO gngNT_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Ti kpàakeh miñunciɛnm nnɔ nin ijɛnd nɛ, ki ŋmɔŋmɔbe ki tì baa' libùol liba saan bi yih lɛ̀ «ñɛrsienbòmɔnmɔnl», niʼsaan ŋa fɔke nin Lase ya du. ");
INSERT INTO gngNT_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Ti wuɔke' usɛn ni nɛ *Sufmbɛ ya ñɔlòle ya yo tì gɛ̀bre'. U ya yo gɛ̀bre' la, uñɛrkure ji ŋmɔbe kinunbɔnk nɛ. Nɛn bo nɛ Pɔl gbiere' bɛ ki ye: ");
INSERT INTO gngNT_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","«Nʼjɔtiebɛ, n likeh ma nɔ, ti biɛ ki joh nin buñɛrbu buu la, kinunbɔnk li tu tɛ, nɛ na yé buñɛrbu baba nɛ li saa ituk ń ñɛnde, tinbi binib mɔnɔn te len.» ");
INSERT INTO gngNT_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Ama Sojambɛ ya ciɛn nnɔ du uñɛrdaan nin uñɛrkurl bo ki cɛn' Pɔl len' nà nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Nɛ ñɛrsienbùol nnɔ mɔ ŋa mɔn nil ń li te niʼsaan tiwɔrciɛnt ya yo ma nnɔ, bà yɛbe ye nì mɔn bɛ ń bure nɛ, nì tuo' la, bɛ ń baa Krɛt ya ñɛrsienbùol bi yih niʼsaan Feniks. Ñɛrsienbùol nnɔ ŋmɔbe kɔkɔbùon ile nɛ. Liba te nintuɔli bó ugɛn bó, litɔl te nintuɔli bó ujie bó. Bi yíe tiwɔrciɛnt nnɔ ya yo kí lɛ bi te nɛn saan nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Kutafaaku kuba ñɛn' ugɛn bó ní, ka faa nɛ bi ye bi bi maale' nà nnɔ li tuo, nɛ ki lore' buñɛrciɛnbu nnɔ ki bure', ki kpàakeh Krɛt ya dekl. ");
INSERT INTO gngNT_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Ama bi bure' ma, na taande' nɛ kutafaabiiku kuba fii' lidekl nnɔ bó ní ki yile' biʼbo bi yih kù «Lɛnpuoli ya jie bó ya tafaaku». ");
INSERT INTO gngNT_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Kutafaaku nnɔ yile' buñɛrbu nnɔ bo ma nnɔ bua ji li fre kí tuobe kù. Kù pe' tɛ ki cɔn', nɛ ti cère' buñɛrbu nnɔ paan' kuʼbo. ");
INSERT INTO gngNT_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Ti jojoh ki tì likn' lidekl liba, bi yih lɛ̀ Koda, nɛ ki ñikn' ki yuure' tiʼñɛrciɛnbu dìɛh buñɛrwawaabu bùa nnɔ ");
INSERT INTO gngNT_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","ki kpìen' buciɛnbu ni. Nɛ biñɛrkurb taa' iŋmi ki lòle' ki pɔ̀npɔ̀n' ki cuo' buciɛnbu nnɔ ya tingi. Bi là fɛnge nba la, buñɛrbu nnɔ li tì yèke litɛngbil là bi yih lɛ̀ Sirt nnɔ nɛ. Nɛn bo nɛ bi taa' nà co buñɛrciɛnbu bù la joh tontonm nnɔ ki jɔn' buʼbo ki cùun' miñunm ni, ki cère' bù paan' kutafaaku bo. ");
INSERT INTO gngNT_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Kutaaku tí faa' ki laa' kutafaaku biɛ ki joh ki faa, ki jèngeh buñɛrciɛnbu, nɛ bi ñɛn' ituk iba ki wiɛ' miñunm ni. ");
INSERT INTO gngNT_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Wienta daali nɛ biñɛrkurb ñɛn' buñɛrciɛnbu bugbɛn ya wɛnt tuba mɔ ki wiɛ' miñunm ni. ");
INSERT INTO gngNT_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Ti tien' idɛn yà yɛbe ka laa' wien, ka laa' ŋmaabii mɔ. Kutafaaku nnɔ lì biɛ ki faa nɛ. Ta ji daan ki ye ti li ŋmɛre. ");
INSERT INTO gngNT_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Tɔ, nì wuɔke' binib bà te buñɛrciɛnbu ni nnɔ ŋa jin' niba. Nɛn saan nɛ Pɔl fii' ki sere' biʼnun bó ki tɔke' bɛ ki ye: «Nʼjɔtiebɛ, ni bi là tuo' nʼñɔbu bó, ka siere' Krɛt ya dekl ni la, kinunbɔnk kiɛ ŋa bi li tu tɛ, tibont mɔ ŋa bi li ñɛnde. ");
INSERT INTO gngNT_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Fɛnfɛnnɔ wuɔ n gbáanh nɛ nɛ, cuo mɛn niʼba kimɛ niʼni uba ŋa ń kpo, buñɛrbu baba nɛ li saa. ");
INSERT INTO gngNT_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","N yé Uwien ya nil nɛ, nɛ ki pukeh wɔ. Kuñɔnku kuu nɔ u sɔn' uʼtond uba nʼsaan, ");
INSERT INTO gngNT_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","u lá tɔke' nni ki ye: ‹Pɔl, la sɛn jɛwaanbu. A lì li sere ubɛrciɛn Sesa ya nun bó nɛ. Uwien li juoke ŋɛ kí cère binib bà kɛ te nin ŋɛ buñɛrciɛnbu ni nnɔ ń ŋmɛre.› ");
INSERT INTO gngNT_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Nɛn bo, nʼjɔtiebɛ, cuo mɛn niʼba. N teke' Uwien ki jin' ki du ki ye u li tien u tɔke' nni nà nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Ama kutafaaku li tuke tɛ kí tì gbèn lidekl liba.» ");
INSERT INTO gngNT_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Tɔ, piik nin ñɔnkunan sɔ, kutafaaku tuke tɛ ti te Adriyatik ya ñunciɛnm bo. Nì tì tuo kuyɔku nɛ biñɛrkurb maale' ki ye ti nɛkn' liwɛl liba nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Bi yíe bɛ ń bikn kí liike miñunm nnɔ ñɔ ki kpɛ ma bo, nɛ ki taa' uŋmi ki lòle' likuluɔnl liba ki wiɛ' miñunm ni ki bikn' ki laa' nì kpɛ mɛta pita nin ulole nɛ. Ti jɛnde' ki pukn', nɛ bi tí bikn' ki laa' mɛta pile nin uniin. ");
INSERT INTO gngNT_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Bi fɛnge nba la, buñɛrciɛnbu nnɔ la tì yèke itɛn nɛ. Nɛn bo nɛ bi lòle' ikuluɔn inan ki jɔn' buñɛrbu nnɔ ya puoli ki cuo' bù ki sien', ki tureh kutaaku ń faa kí tu bɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Biñɛrkurb nnɔ nuunh bɛ ń lɔkre kí ñɛ buñɛrciɛnbu nnɔ ni ma nnɔ nɛ ki jiin' buñɛrwawaabu nnɔ ki pùkn' miñunm bo, ki nɛn' ki ye bi joh bɛ ń tì lòle ikuluɔn nɛ kí jɔn buñɛrciɛnbu nnɔ ya nun bó. ");
INSERT INTO gngNT_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Nɛ Pɔl tɔke' sojambɛ nin biʼciɛn ki ye: «Binib biɛ ñɛn' buñɛrbu buu ni la, na ń ŋmɛre» ");
INSERT INTO gngNT_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Nɛn saan nɛ sojambɛ cere' iŋmi yà lùo buñɛrwawaabu nnɔ, ki cère' bù bure'. ");
INSERT INTO gngNT_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Nì wendeh pìpì nɛ Pɔl gbáan' biʼkɛ bɛ ń ñikn kí ji tijier, nɛ ki ye: «Dinnɔ wuɔ nɔ nì tien' iwien piik nin inan sɔ, ni te iyɛnbɛn ni ka jinh niba. ");
INSERT INTO gngNT_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Nɛn bo ñikn mɛn kí ji tijier, kimɛ nì li tore nɛ ní ŋmɛre. Niʼni uba mɔnɔn ya yul ŋa ń gàare» ");
INSERT INTO gngNT_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Pɔl len' ki gben', nɛ ki taa' kpɔnɔ, ki faare' Uwien biʼkɛ ya nun bó, ki kuɔ' ki cin' ki ŋmɔnh. ");
INSERT INTO gngNT_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Nɛn saan nɛ biʼkɛ cuo' biʼba ki mɔ jin' tijier. ");
INSERT INTO gngNT_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Ti là te binib kobiile nin pilole nin biluob nɛ buñɛrciɛnbu nnɔ ni. ");
INSERT INTO gngNT_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Biʼkɛ jin' ki gbo', nɛ ki ñɛn' tijier tà te buñɛrbu ni nnɔ ki wiɛ' miñunm ni ŋɔ bù ń yuɔke. ");
INSERT INTO gngNT_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Uwien puɔ' uyo wà nnɔ, biñɛrkurb ŋa bɛnde' bi te nà saan, ama bi laa' lijaal liba miñunciɛnm ya gbaal. Nɛ bi ye nì tuo' la, bi li cère buñɛrciɛnbu nnɔ ń tì ñɛ nɛn saan nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Nɛ ki cere' ikuluɔn nnɔ ya ŋmi, ki cère' ì juore' miñunm ni. Nɛ ki lore' tiñɛkurlɛnbɛnt ya ŋmi, ki taa' kukpɛlciɛku kuba ki jɔn' buñɛrbu ya nun bó paaki, ki cère' kutafaaku tureh bɛ ki cuube miñunm nnɔ ya gbaal. ");
INSERT INTO gngNT_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Bi tì lɛke' litɛngbil liba bo miñunm linde' lɛ̀. Buñɛrbu don' liʼbo, nɛ liñɛryul bubn', bua ji li fre kí jo. Nɛ iñungbegbel fih ki yèkreh ufaa bo ki wieleh buñɛrbu nnɔ ya juul bó. ");
INSERT INTO gngNT_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Sojambɛ nnɔ maale' ki ye bi li ku lipɛkl ya nib nnɔ nɛ ŋɔ uba la wo kí ñɛ kí sɛn kí ŋmɛre. ");
INSERT INTO gngNT_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Ama sojambɛ ya ciɛn nnɔ yíe wɔ ń ŋmiɛn Pɔl, nɛ ka tuo' bɛ ń tien bi maale' nà nnɔ, nɛ ki ye bà freh ki woh nnɔ ń kpiɛ kí maabe kí lu miñunm ni, kí wo kí puore. ");
INSERT INTO gngNT_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Bà sìen' nnɔ mɔ ń cuo idɔyɛk bii iñɛryɔyɔl kí puore. Bi tien' nnɔ nɛ biʼkɛ puore' caabu. ");
INSERT INTO gngNT_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Ti ñɛn' miñunm nnɔ ni ma nnɔ nɛ bi tɔke' tɛ ki ye bi yih lidekl nnɔ Malt nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Lidekl nnɔ ya nib tien' tɛ tinimɔ̀nt cɛɛn. Utaa cin' ki niih, tiwɔr te ma nnɔ, nɛ bi sɛ̀re' umu ki cère' tiʼkɛ jebe' wù. ");
INSERT INTO gngNT_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Pɔl wore' tidɔbikuont, ki lá kpìen' umu ni. Umu nnɔ ya wɔl cère' uwɛ ñɛn' tidɔbri nnɔ ni, ki kɛ̀re' Pɔl ya nuɔ ki juore' ki juɔn. ");
INSERT INTO gngNT_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Lidekl nnɔ ya nib laa' uwɛ juɔn Pɔl ya nuɔ bo ma nnɔ, nɛ ki tɔkeh tɔb ki teh: «Ujɛ wuɔ lì yé unikul nɛ. U ŋmɛre' ka kpo' miñunciɛnm ni, ama tiʼbul wà cuube nnɔ ŋa ń cère wɔ ń li fuobe.» ");
INSERT INTO gngNT_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Nɛn saan nɛ Pɔl gbɛ' uwɛ nnɔ, u lu' umu ni ka cii' uʼluol bó. ");
INSERT INTO gngNT_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Bi maaleh ki teh nì li duun nɛ, bii Pɔl li kpo i ya tàan bo nɛ. Bi lilikeh nì tì wuɔke', bi laa' bonn ŋa tien' wɔ, nɛ bi liɛbe' ki maale' ki ye u yé ubul nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Tɔ, lidekl nnɔ ya ciɛn uba là te bi yih wɔ Publiyus. Uʼkpàabu ŋa fɔke nin ti te nà saan nnɔ. Nɛ u teke' tɛ iwien ita, ki cɛ̀nde' tɛ tɛn ti yé uʼjɔtieb nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Publiyus ya baa dɔ ki bun, uʼgbɛnɛnt ton, u juh misɛ̀m. Pɔl jon' u dɔ nà saan nnɔ, ki tì taa' uʼnuɔ ki paan' uʼbo ki kàare' ki de' wɔ, nɛ u faake'. ");
INSERT INTO gngNT_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Pɔl tien' nnɔ ma nnɔ, nɛ biwiɛntɔb bà te lidekl nnɔ bo nnɔ baa' uʼsaan, nɛ u cère' biʼmɔ faake'. ");
INSERT INTO gngNT_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Binib nnɔ seln' tɛ cɛɛn. Ti ye tí siere uyo wà nnɔ, nɛ bi pun' tɛ nà kɛ ciɛke tɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Ti là tien' niʼsaan iŋmaale ita nɛ, ki yaan ki kɔn' Alɛksandri ya ñɛrciɛnbu buba ki bure' bù ŋmɔbe ibuleb ya nɛnnɛnku. Buñɛrciɛnbu nnɔ là juore' niʼsaan tiwɔrciɛnt ya yo nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Ti tì baa' Sirakus ya du ni, ki tien' len iwien ita, ");
INSERT INTO gngNT_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","nɛ ki ñɛn' len' ki nɔn' miñunciɛnm, ki tì baa' Lɛjiyo ya du ni. Kutaaku faa', kutafaaku kuba fii' ugɛn bó ní, nɛ ti taa' iwien ile ki baa' Pusɔl ya du ni. ");
INSERT INTO gngNT_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Ti laa' binib bà teke' *Yesu ki jin' nnɔ ya biba len, nɛ bi gbáan' tɛ tí tien biʼsaan iwien ilole. Ti tentien' nnɔ nɛ ki tì baa' Erom ya du ni. ");
INSERT INTO gngNT_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Binib bà teke' ki jin' ki te Erom ya du ni nnɔ cii' ti we ní nɛ ki tuobe' tɛ usɛn bó. Biba tì tuobe' tɛ Apiyus ya daak saan nɛ, bitɔb mɔ tì tuobe' tɛ Ticɛndur tuta saan. Pɔl laa' bɛ ma nnɔ, nɛ ki faare' Uwien, nɛ uʼgbɛnɛnt saake'. ");
INSERT INTO gngNT_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Ti tì baa' Erom ya du ni ma nnɔ, nɛ bi de' Pɔl uʼduku uʼba, ki cère' soja uba gu wɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Iwien ita gɛ̀bre', nɛ Pɔl yin' *Sufmbɛ ya ciɛnb, bi taan', nɛ u tɔke' bɛ ki ye: «Nʼyaabɛ, ma tien' tiʼdu ya nib bonn, ka saa' tiʼyaajɛbok liba. Ama bi cuo' nni Yerusalɛm ni nɛ, ki taa' nni ki ŋukn' Erom yaab. ");
INSERT INTO gngNT_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Bi bun' nni tibuur ki laa' ma ŋmɔbe biil, nɛ bi yíe bɛ ń taa nni kí wiɛ, kimɛ ba laa' n tien' nà nì kpɛ bɛ ń ku nni. ");
INSERT INTO gngNT_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Ama *Sufmbɛ ŋa tuo' bɛ ń wiɛ nni ma nnɔ nɛ cère' n len' ki ye ubɛrciɛn Sesa nɛ li bu nʼbuur. Na yé n yíe ń biin nʼbol ya nib nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","N yin' nɛ ń lá wuɔn nɛ tu ya gbɛr nɛ. Tinbi Israyɛl yaab là ŋmɔbe lidɛndɛnl là nnɔ bo nɛ bi lòle' nni tikudɔkr.» ");
INSERT INTO gngNT_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Nɛ bi tɔke' wɔ ki ye: «Sude ya tinfɛnm ya nib ŋa kɛle' aʼgbɛr gbɔnku ni ki de' tɛ. Tiʼyɔ uba mɔ ŋa ñɛn' niʼbó ní, ki lá tɔke' tɛ aʼgbɛr bii ki len' tigbɛbiɛrt tuba aʼbo. ");
INSERT INTO gngNT_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Ama ti yíe tí cii aʼñɔbu ni nɛ sin bugbɛn maaleh ki teh bà, kimɛ ti bɛn ki ye idu kɛ ni, binib ŋa tuonh aʼcɛkl ya gbɛr.» ");
INSERT INTO gngNT_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Nɛ bi sien' lidaali là bi li liɛbe ní Pɔl saan. Niʼdaali, nɛ bi baa' u te nà saan nnɔ, ki yɛbe cɛɛn. Pɔl cin' kutɛnŋaaku nɛ ki tɔkeh Uwien ya bɛl ya gbɛr ki tì baa' kutaajuɔku. U ñìikeh Moyis nin *Uwien ya ñɔbonsɔknb là kɛle' nà *Uwien ya gbɔnku ni nnɔ bo nɛ, ki tɔkeh bɛ *Yesu ya gbɛr ki ñikndeh bɛ ń tuo tù. ");
INSERT INTO gngNT_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Biʼni biba tuo' tù, nɛ bitɔb yìe' ka teke' tù ki jin'. ");
INSERT INTO gngNT_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Bi tì siereh ka cii' tɔb bó ma nnɔ, nɛ Pɔl len' liñɔbonl liba ki ye: «*Mifuoñaanm là cère' *Uwien ya ñɔbonsɔknl Esayi tɔke' niʼyaajɛb tigbɛr tà nnɔ yé tigbɛmɔ̀nt nɛ. ");
INSERT INTO gngNT_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Mì là ye: ‹Li joh ki tì tɔke Israyɛl yaab kí ye: Ni li tùɔre kí cenge ama na ń cii niʼtingi, ni li tùɔre kí liike ama na ń lɛ, ");
INSERT INTO gngNT_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","kimɛ binib nnɔ ya yul faa nɛ, bi kpɛ' biʼtub nɛ, ki pi' biʼnun, ka yíe biʼnun ń lɛ, ka yíe biʼtub ń cii, ka yíe bɛ ń bɛnde niʼtingi biʼyɛnm ni, ka yíe bɛ ń lèbre biʼtetem ŋɔ ń buu bɛ.› » ");
INSERT INTO gngNT_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Nɛ Pɔl tí tɔke' bɛ ki ye: «Bɛnde mɛn kí ye Uwien sɔn' nni bà ŋa yé *Sufmbɛ saan nɛ ń tì tɔke bɛ miŋmiɛnm ya gbɛr. Bɛn li cengeh tù.» ");
INSERT INTO gngNT_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Pɔl len' nnɔ ma nnɔ, nɛ *Sufmbɛ nnɔ siere' ki findeh nin tɔb ki gbiekeh. ");
INSERT INTO gngNT_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Pɔl tien' ibinŋmɛn ile nɛ ki te kuduku kùa u paanh kuʼbo nnɔ ni, ki teknh bà kɛ bàareh uʼsaan nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","U tɔkeh binib Uwien ya bɛl ya gbɛr nin Yonbdaan *Yesu Kristo ya gbɛr, ki ŋmɔbe lifɛ̀l ki lienh, nɛ uba ŋa piendeh wɔ.");
INSERT INTO gngNT_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Min Pɔl nɛ kiɛh nɛ kugbɔnku kuu. N yé *Yesu Kristo ya tonsɔnl nɛ. Uwien nɛ yin' nni ń li yé Yesu Kristo ya tond, ki gɛ̀nde' nni ń li kpaandeh wɔn Uwien ya gbɛmɔnmɔnt. ");
INSERT INTO gngNT_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Uwien là pùon' tɛ ti ya gbɛmɔnmɔnt nɛ haali uyoyo, ki cère' uʼñɔbonsɔknb kɛle' tù uʼgbɔnku ni. ");
INSERT INTO gngNT_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Tù lienh uʼBijɛ bo nɛ. U tien' uʼba unisaal nɛ bi maa' wɔ *Dafid ya lontunku ni. ");
INSERT INTO gngNT_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Ama *Mifuoñaanm bo nɛ Uwien wuɔn' ki ye u yé uʼBijɛ ki cère' u ŋmɔbe mituɔm kí ñɛ uʼmɛkrm bitɛnkpiib ni bo. Wɔn nɛ yé *Yesu Kristo tiʼYonbdaan. ");
INSERT INTO gngNT_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Wɔn bo nɛ n laa' mijuokm ki yé uʼtond, ŋɔ uʼyel bo ń li tɔkeh inibol kɛ ki teh bɛ ń teke wɔ kí ji, kí li boh wɔ. ");
INSERT INTO gngNT_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Niʼmɔ te inibol nnɔ ni nɛ, kimɛ *Yesu Kristo yin' niʼmɔ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","N kiɛh kugbɔnku kuu ń de ninbi bà kɛ te Erom ya du ni Uwien yíe nɛ, ki yin' nɛ ki tien' uʼyaab nnɔ nɛ. TiʼBaa Uwien nin Yonbdaan *Yesu Kristo ń juoke nɛ, kí de nɛ uyɛnduɔn. ");
INSERT INTO gngNT_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Micincinm n li kpiɛ kí faare nʼWien nɛ. *Yesu Kristo bo nɛ n li faareh wɔ niʼkɛ bo, kimɛ bi lienh uŋɛndun ni niʼkɛ saan niʼtekjim bó. ");
INSERT INTO gngNT_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Wɔn Uwien wà n sɔnh nin nʼfɛ̀l kɛ ki dienh wɔ uʼBijɛ ya gbɛmɔnmɔnt ya tɔkm ni nnɔ nɛ yé nʼmɔ̀nkunl ki ye n tuu ki tiɛn niʼbó nʼkaare ni. ");
INSERT INTO gngNT_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","N kàareh ki miɛh wɔ uyo kɛ ki teh u tuo' la, wɔ ń de nni usɛn ń baa niʼsaan nɛ. ");
INSERT INTO gngNT_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Kimɛ nʼnun mɔ́n ń lɛ nɛ kí cère ní lɛ *Mifuoñaanm ya paabu ŋɔ kí tùɔre kí li faa mitekjim ni nɛ. ");
INSERT INTO gngNT_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","N len' nà nɔ ya tingi si: n baa' niʼsaan la, min nin ninbi, wà kɛ ń saake uʼtɔ ya gbɛnɛnt kí ñɛ ti ŋmɔbe mitekjim ma nnɔ bo nɛ. N ya tekjim ń saake niʼgbɛnɛnt, niʼmɔ yaam ń saake nʼyaar. ");
INSERT INTO gngNT_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Nʼyaabɛ, n yíe ní li bɛn kí ye n tuu ki bobndeh ń baa niʼsaan nɛ, ka laan laa' bònl. N yíe nʼtuonl ń cuon niʼmɔ saan tɛn lì cuon' ma inibotɔ saan nnɔ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Nì yé liwɔbl nɛ nʼbo ń tɔke binib kɛ tigbɛmɔnmɔnt, bà ya nun wende' nin bà ya nun ŋa wende', bà bɛn niba nin bà ŋa bɛn niba mɔ. ");
INSERT INTO gngNT_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Nɛn bo nɛ nʼnun mɔ́n ń tɔke ninbi bà te Erom ni mɔ tigbɛmɔnmɔnt nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Fɛ ŋa ŋmɔbe nni tigbɛmɔnmɔnt ya tɔkm bo. Tù yé Uwien ya tuɔm nɛ, ki li ŋmiɛn binib bà kɛ teke' tù ki jin': bà yé *Sufmbɛ mikpiɛkm nin bà ŋa yé *Sufmbɛ mɔ. ");
INSERT INTO gngNT_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Kimɛ tun nɛ wɔngeh Uwien ñìikeh nà bo ki bùh binib bigbɛmɔ̀ndɛnb. U ñìikeh mitekjim baba bo nɛ ki bùh binib bigbɛmɔ̀ndɛnb tɛn nì kɛle' ma uʼgbɔnku ni ki ye: «Ugbɛmɔ̀ndaan li fuobe uʼtekjim bo nɛ.» ");
INSERT INTO gngNT_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Uwien wɔngeh haali paaki bó nɛ ki teh uʼmutuol fii' binib bo. Kimɛ bi sɔnh itùonbiɛrɛ nɛ ka pɛ uʼbo, ki piendeh tigbɛmɔ̀nt ya sɛn biʼtùonbiɛrɛ nnɔ bo. ");
INSERT INTO gngNT_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Kimɛ bi bɛn unisaal li fre kí bɛnde nà kɛ Uwien bo. Wɔn Uwien nɛ wuɔn' bɛ nɛ̀. ");
INSERT INTO gngNT_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Imɔ̀n, haali uŋɛndun ya cincinyo kí lá baa fɛnfɛnnɔ nɔ, nib ŋa kpele ki laa' Wien nin biʼnunbu, ama bi lɛnh u ñɛn' tibont tà nɛ ki bɛndeh ki teh u mɔnbe ki yé Uwien, ki ŋmɔbe mituɔm mà ŋa ŋmɔbe gbenm. Nɛn bo nɛ ba ji li fre kí ye ba bɛn wɔ. ");
INSERT INTO gngNT_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Nin bi bɛn wɔ ma kɛ nnɔ, ba kpiɛkreh wɔ ki ye u yé Uwien, ka faareh wɔ mɔ. Ama bi juore' nin biʼyɛnmaalkuon nɛ, ka ŋmɔbe yɛnm, ki te libɔnbɔnl ni. ");
INSERT INTO gngNT_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Bi yih biʼba biyɛnfodɛnb nɛ, ki nín ji yé ijɔr. ");
INSERT INTO gngNT_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Bi dàan' Uwien wà ŋa ń kpo ya kpiɛkm, nɛ ki lèbe' ki kpiɛkreh unisaal wà li kpo ya nɛnnɛnku nin inuɔn nin itàan inan ya wɛnt nin tiwɛnbɛlnkaar ya nɛnnɛnt. ");
INSERT INTO gngNT_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Nɛn bo nɛ Uwien sɛln' bɛ, bi pɛ biʼyɛnm yíe nà bo, ki sɔnh tijɔknt ya tùon, ki jindeh biʼba ifɛ. ");
INSERT INTO gngNT_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Bi taa' kutonnɛnku nɛ ki lèbe' Uwien ya gbɛmɔ̀nt, ki pukeh tibont tà Uwien ñɛn' tù, ki sɔnh itùon ki dienh tù, ki dàan' wɔn Uwien wà ñɛn' tibont nnɔ kɛ ki kpɛ kupɛnpɛku uyo wà ŋa ŋmɔbe gbenm nnɔ. Ami. ");
INSERT INTO gngNT_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Nɛn bo nɛ Uwien sɛln' bɛ, bɛ ń li sɔnh ifɛ ya tùon biʼyɛnm yíe ma bo. Nɛ biʼpuob teh nà ŋa kpɛ tienm, ki dàan' miduɔnm nin bijɛb, ki duɔndeh nin biʼpiitɔb. ");
INSERT INTO gngNT_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Bijɛb mɔ dàan' miduɔnm nin bipiib, biʼmɛnku kɔh bijɛtɔb ni ki gbiekeh, nɛ bi teh nà ŋa kpɛ tienm, ki yé ifɛ nin biʼjɛtɔb. Nɛn bo nɛ bi lɛnh biʼyul bo ya tudɛre wà kpɛ biʼtùonbiɛrɛ nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Ba tɔnge' Uwien ma nnɔ, nɛ u sɛln' bɛ, bɛ ń li ŋmɔbe yɛnmaalfɛnm, kí li teh nà ŋa kpɛ tienm. ");
INSERT INTO gngNT_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Bi cère' mitetem mà kɛ ŋa mɔn ya bol nin mibiɛrm nin ununfɔke nin iponponbe nin linikul nin ikɔ̀nkɔ̀n nin milɛrkjim nin iyɛnmaalbiɛre nɛ yɛbre' nin bɛ. Bi yé bitonnɛndɛnb nɛ, ");
INSERT INTO gngNT_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","ki yé bitɛnfuonb, ki yé Uwien ya nɛnnɛndb, ki yé bikɛlnbaandɛnb, ki yíe tigbengt nin tinacenkpekuont, ki yé idukond, ka boh biʼnaambɛ nin biʼbaambɛ, ");
INSERT INTO gngNT_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","ki yé ijɔr, ki yé binib bà ba du biʼbo, ki yé binunkuondɛnb, ka muɔh nil cɛcɛkm. ");
INSERT INTO gngNT_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Bi bɛn Uwien sien' ki ye binib teh nnɔ la, bi kpɛ mikuum nɛ. Nin nɛn kɛ bi tuu ki teh nnɔ nɛ, ka juore' nɛn baba bo, ki liɛbe' ki saakreh binitɔb bà mɔ teh nnɔ ya gbɛnɛnt. ");
INSERT INTO gngNT_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Tɔ, sin unil wà biindeh aʼtɔ nnɔ, a yíe la, á li yé wà kɛ, aʼmɔ te libiil ni nɛ Uwien saan. A biindeh aʼtɔ ma nnɔ a biindeh aʼba nɛ. Kimɛ a biindeh wɔ nà bo nnɔ, aʼmɔ teh nɛn nɛ. ");
INSERT INTO gngNT_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Ti bɛn ki ye Uwien diɛh binib bà teh tu ya bont ya tub la, u ŋmɔbe imɔ̀n nɛ. ");
INSERT INTO gngNT_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Sin unil wà biindeh binitɔb bà teh tu ya bont, ki mɔ teh tù nnɔ, a maaleh ki teh a li ñɛ tibuur ni Uwien saan nɛ-ɛɛ? ");
INSERT INTO gngNT_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Uwien tien' ŋɛ tinimɔ̀nt ki gbien', ki ŋmɔbe aʼbo lifɛ̀sɔngl nin kuminku, nɛ a yin' nɛn kɛ fɛnm-ii? Ŋa bɛn ki ye Uwien tien' ŋɛ tinimɔ̀nt ŋɔ á lèbre aʼtetem nɛ-ɛɛ? ");
INSERT INTO gngNT_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Aʼyul faa, ŋa yíe á lèbre aʼtetem ma nnɔ, a bondeh aʼba bo Uwien ya benpiebciɛn nɛ, ki gu lidaali là uʼmutuol li fii binib bo wɔ ń bu bɛ tibuur niʼdonbó nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Nɛn daali nɛ u li jiin unil kɛ uʼtùon kpɛ ma bo. ");
INSERT INTO gngNT_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Binib bà mìndeh ki sɔnh itùon yà mɔn, ki nuunh ukpiɛke nin lisel nin limiɛl là ŋa ŋmɔbe gbenm Uwien saan nnɔ, Uwien li cère bɛn nɛ ń li tuu ki fuobe nin wɔ. ");
INSERT INTO gngNT_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Ama binib bà pɛ biʼyɛnm yíe nà bo, ki wiɛ' tigbɛmɔ̀nt ya sɛn, ki pɛ tibonbiɛrt ya sɛn bo nnɔ, Uwien ya mutuol li fii, uʼbenku ni ń piebe biʼbo kí gbien. ");
INSERT INTO gngNT_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Binib bà kɛ teh nà bre nnɔ, ijɛnd nin micɛcɛkm li lu biʼbo. Nì li lu bà yé *Sufmbɛ nin bà ŋa yé *Sufmbɛ kɛ bo nɛ. ");
INSERT INTO gngNT_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Ama bà kɛ teh nà mɔn li lɛ ukpiɛke nin lisel nin uyɛnduɔn. Bà yé *Sufmbɛ nin bà ŋa yé *Sufmbɛ kɛ li lɛ nɛ, ");
INSERT INTO gngNT_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","kimɛ Uwien ŋa ŋmɔbe gɛ̀ngɛ̀nde. ");
INSERT INTO gngNT_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Binib bà kɛ ŋa bɛn *yiko ki teh nà bre la, bi li kpo, ama Uwien ŋa ń ñi *yiko bo kí bu bɛ buur. Ama binib bà kɛ bɛn *yiko ki teh nà bre nnɔ Uwien li ñi *yiko nnɔ bo nɛ kí bu bɛ tibuur. ");
INSERT INTO gngNT_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Kimɛ na yé bà bɛn *yiko nɛ yé bigbɛmɔ̀ndɛnb Uwien saan, ama Uwien bùh bà teh *yiko nnɔ ye ma bo nɛ bigbɛmɔ̀ndɛnb. ");
INSERT INTO gngNT_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Bà ŋa yé *Sufmbɛ, ka bɛn *yiko ŋɔ ki teh *yiko nnɔ ye ma nnɔ, ba bɛn ma ki teh nnɔ, biʼyɛnmaale nɛ yé biʼyiko. ");
INSERT INTO gngNT_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Bi teh nnɔ ma nnɔ, nɛn nɛ wɔngeh ki teh yiko ye nà nnɔ te biʼyɛnm ni nɛ. Biʼyɛnm ni bi bɛn nà mɔn nin nà bre. Nɛn bo nɛ biʼyɛnmaale biindeh bɛ uyo uba, ki teknh bɛ uyotɔ mɔ. ");
INSERT INTO gngNT_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","N tɔkeh binib tigbɛmɔnmɔnt tà nnɔ wɔngeh ki teh nì lá li te nnɔ nɛ lidaali là Uwien li cère *Yesu Kristo ń bu binib tibuur, kí cère bɛ ń ñɛn nà kɛ buɔ biʼfɛ̀l ni upaan bo nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Tɔ, sin Suf wà lienh ki teh a yé Suf, ki du *yiko bo baba, ki jɛbnh aʼba ki teh a bɛn Uwien, ");
INSERT INTO gngNT_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","ki bɛn u yíe nà, ki bɛn nà mɔn nin nà ŋa mɔn, kí ñɛ *yiko bo, ");
INSERT INTO gngNT_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","ki maaleh ki teh a yé ununyaan nɛ ki dìɛh ijùɔn, ki yé bà te licinñunl ni ya wenwenku, ");
INSERT INTO gngNT_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","ki wɔknh ijɔr mibɛnm, ki wɔknh mubumu, kimɛ a bɛn *Uwien ya yiko ma nnɔ, a maaleh ki teh a bɛn tibont kɛ nɛ, ki maaleh ki teh a lienh nà kɛ nnɔ yé tigbɛmɔ̀nt nɛ. ");
INSERT INTO gngNT_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Tɔ, sin wà wɔknh bitɔb nɔ nnɔ, bɛ tien' ŋa wɔknh aʼba? Sin wà tɔkeh binib ki teh bi la suh nnɔ, bɛ tien' a suh? ");
INSERT INTO gngNT_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Sin wà lienh ki teh nib la teh naŋmaal nnɔ, bɛ tien' a teh lɛ̀? Sin wà ŋa yíe á cii bule ya nu nnɔ, bɛ tien' a suh tibudur ya bont-i? ");
INSERT INTO gngNT_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","A jɛbnh aʼba *yiko bo, ki liɛbe' ki saah wɔ ma nnɔ, a yuɔndeh Uwien nɛ. ");
INSERT INTO gngNT_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Kimɛ nì kɛle' *Uwien ya gbɔnku ni ki ye: «Ninbi nɛ cèreh inibotɔ sukreh Uwien.» ");
INSERT INTO gngNT_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Tɔ, a jiɛ' aʼpunl ki boh yiko la, upunjiɛ ŋmɔbe kpɛle nɛ. Ama a jiɛ' aʼpunl ki saah yiko la, nì te tɛn ŋa jiɛ' nɛ. ");
INSERT INTO gngNT_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Wà ŋa jiɛ' punl, boh *yiko la, Uwien ya bùol nì te tɛn u jiɛ' uʼpunl nɛ. ");
INSERT INTO gngNT_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Sin wà yé Suf ki ŋmɔbe yiko, u kɛle' kugbɔnku ni, ki liɛbe' ki jiɛ' aʼpunl mɔ nnɔ, ŋa boh *yiko nnɔ ma nnɔ, wà ŋa jiɛ' punl, ki boh wɔ nnɔ nɛ li bu ŋɛ tibuur. ");
INSERT INTO gngNT_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Na yé unil wà yé Suf upaan bo baba nɛ yé Sufmɔ̀n. Na yé wà jiɛ' uʼpunl biʼkɛ laa' u jiɛ' nɛ yé upunjiɛmɔ̀n. ");
INSERT INTO gngNT_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Suf ya yɛnm nɛ wɔngeh ki teh u yé Sufmɔ̀n. Upunjiɛmɔ̀n ñɛ lifɛ̀l ni nɛ. U ya punjiɛ ñɛn' *Mifuoñaanm saan nɛ, wa ñɛn' *yiko wà bi kɛle' wɔ kugbɔnku ni nnɔ. Na yé binib nɛ li pɛ̀ke wà yé Sufmɔ̀n, Uwien nɛ li pɛ̀ke wɔ. ");
INSERT INTO gngNT_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","*Sufmbɛ ya kpɛle nín si ba? Bii biʼpunjiɛ ŋmɔbe kpɛle-ee? ");
INSERT INTO gngNT_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Niʼkɛ ŋmɔbe kpɛle wà yɛbe nɛ isɛn kɛ ni, kimɛ Uwien kpiɛ' ki taa' uʼgbɛr ki ŋukn' bɛn nɛ. ");
INSERT INTO gngNT_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Nì ye nɛ̀ ń wuɔn kí ye ba? Nì ye nɛ̀ ń wuɔn kí ye biʼni biba ŋa paan' Uwien ye ma bo la, nì li pien Uwien u la tien u ye ma bo nɛ-ɛɛ? ");
INSERT INTO gngNT_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Na ń tien nnɔ fiebu. Binib kɛ yé bitonnɛndɛnb mɔnɔn la, Uwien wɔn tuu ki yé ugbɛmɔ̀ndaan nɛ tɛn nì kɛle' ma uʼgbɔnku ni ki ye: «Aʼlenm ni nɛ bi li bɛnde kí ye a yé ugbɛmɔ̀ndaan. Bi bun' nin ŋɛ tibuur la, a li faake nin bɛ.» ");
INSERT INTO gngNT_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Tɔ, nì yé ti teh nà ŋa cuube nì wɔngeh ki teh Uwien yé ugbɛmɔ̀ndaan la, ti nín ji li len kí ye ba? Ti li ye Uwien diɛh tiʼtub la, u teh nà ŋa cuube nɛ-ɛɛ? (N lienh binib lienh ma bo nɛ.) ");
INSERT INTO gngNT_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Na te nnɔ fiebu. U teh nà ŋa cuube la, u li tien mila kí bu uŋɛndun ya nib tibuur-i? ");
INSERT INTO gngNT_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Tɔ, nì yé nʼtonnɛnku wɔngeh Uwien ya gbɛmɔ̀nt ki cèreh binib kpiɛkreh wɔ la, bɛ tien' u diɛh nʼtub ki teh n yé ubiɛrdaan-i? ");
INSERT INTO gngNT_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Tí li teh nà bre ŋɔ nɛ̀ ń kpɛnde nà mɔn-ii? Binib biba sukreh tɛ ki teh ti lienh ki teh nnɔ nɛ. Bidɛnb li lɛ utudɛre wà bi kpɛ wù nɛ. ");
INSERT INTO gngNT_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Nì ye nɛ̀ ń wuɔn kí ye ba? Nì ye nɛ̀ ń wuɔn kí ye tinbi Sufmbɛ, ti cɛn' binitɔb nɛ-ɛɛ? Na te nnɔ fiebu. N là wɔkn' nɛ ki ye *Sufmbɛ nin bà ŋa yé *Sufmbɛ kɛ te ibiɛre ya yonbt ni nɛ. ");
INSERT INTO gngNT_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Nɛn nɛ kɛle' *Uwien ya gbɔnku ni. Nì kɛle' ki ye: «Uba mɔnɔn ŋa te ki yé gbɛmɔ̀ndaan, ");
INSERT INTO gngNT_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","uba ŋa te ki ŋmɔbe yɛnfuom, uba ŋa te ki nuunh Uwien, ");
INSERT INTO gngNT_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","biʼkɛ dàan' uʼsɛn nɛ, ki taan' ki juore' fɛnm. Uba mɔnɔn ŋa te ki teh nà mɔn. ");
INSERT INTO gngNT_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Biʼniɛke yɛ tɛn itɛnkpiifɛle nɛ, biʼlɛn ya tùon si milɛrm baba nɛ, Biʼñuɔn ŋmɔbe tilɔbr tɛn iwaalɛb nɛ. ");
INSERT INTO gngNT_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Iñɔbonbil nin miŋùum baba nɛ gbe biʼñuɔn ni. ");
INSERT INTO gngNT_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Biʼtàan ton linikul bo nɛ. ");
INSERT INTO gngNT_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Bi ñɛn' nà kɛ saan la, bi saah nɛ, ki kuɔndeh binitɔb micɛcɛkm ni. ");
INSERT INTO gngNT_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Ba bɛn yɛnduɔn ya sɛn. ");
INSERT INTO gngNT_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Ba fɛnge Wien.» ");
INSERT INTO gngNT_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Tɔ, ti bɛn ki ye *yiko len' nà kɛ nnɔ, u len' ki de' binib bà li boh wɔ nnɔ nɛ, ŋɔ uba la dule niba bo kí ye wa bii'. Nnɔ nɛ uŋɛndun ya nib kɛ li bɛnde kí ye bi ŋmɔbe libiil Uwien saan. ");
INSERT INTO gngNT_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Nɛn bo nɛ unil teh *yiko ye ma bo la, na ń cère Uwien ń bù wɔ gbɛmɔ̀ndaan. Yiko cèreh binib bɛndeh nà yé ibiɛre baba nɛ. ");
INSERT INTO gngNT_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Fɛnfɛnnɔ wuɔ Uwien ji wuɔn' u ñɛh usɛn wà ki bùh binib bigbɛmɔ̀ndɛnb, na yé u tukndeh *yiko ye ma bo nɛ. Yiko nin Uwien ya ñɔbonsɔknb là juɔ' ki len' nɛn nɛ uʼgbɔnku ni. ");
INSERT INTO gngNT_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","U bùh binib bigbɛmɔ̀ndɛnb biʼtekm *Yesu Kristo kí ji bo nɛ. Bà kɛ teke' *Yesu Kristo ki jin' la, u bùh bɛ bigbɛmɔ̀ndɛnb nɛ. Kimɛ biʼkɛ te miba nɛ. ");
INSERT INTO gngNT_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Biʼkɛ tien' ibiɛre nɛ ki luo' Uwien ya kpiɛke. ");
INSERT INTO gngNT_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Ama Uwien ya juokm bo nɛ u bù' bɛ bigbɛmɔ̀ndɛnb *Yesu Kristo ya tuɔrl là dɛ' bɛ ki wiɛ' nnɔ bo. Na yé biʼnimɔ̀nt bo nɛ. ");
INSERT INTO gngNT_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Uwien taa' wɔn nɛ ki tien' lituɔrl uʼsɛ̀m bo, ki dɛ' bà kɛ teke' wɔ ki jin' ki wiɛ', ki wuɔn' wɔn Uwien ya gbɛmɔ̀nt, ka dɛre' binib ya tub biʼbiɛre bo uyo bo, ");
INSERT INTO gngNT_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","u là duɔn' uʼyɛnm uyo wà nnɔ. Fɛnfɛnnɔ wuɔ u wuɔn' uʼgbɛmɔ̀nt ki ye wà kɛ teke' *Yesu ki jin' nɛ yé ugbɛmɔ̀ndaan. U tien' nnɔ ŋɔ binib ń bɛnde kí ye wɔn Uwien nɛ yé ugbɛmɔ̀ndaan. ");
INSERT INTO gngNT_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Nì te nnɔ la, uba biɛ ki ŋmɔbe u li jɛbn uʼba nà bo-oo? Nì yé fɛnm. Na yé binib ya tùon bo nɛ Uwien bùh bɛ bigbɛmɔ̀ndɛnb, u bùh bɛ bigbɛmɔ̀ndɛnb biʼtekjim bo nɛ. ");
INSERT INTO gngNT_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Kimɛ ti bɛn ki ye Uwien bùh unil ugbɛmɔ̀ndaan uʼtekjim bo nɛ, na yé u teh *yiko ye ma bo nɛ u bùh wɔ ugbɛmɔ̀ndaan. ");
INSERT INTO gngNT_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Uwien yé *Sufmbɛ baba ya Wien nɛ, ka yé bà ŋa yé *Sufmbɛ ya Wien-ii? U yé biʼmɔ ya Wien nɛ. ");
INSERT INTO gngNT_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Kimɛ Uwien te uba nɛ. Wɔn nɛ bùh bà yé *Sufmbɛ nin bà ŋa yé *Sufmbɛ bigbɛmɔ̀ndɛnb mitekjibaabm bo. ");
INSERT INTO gngNT_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Ti lienh nà nnɔ, nì ye nɛ ń ye mitekjim bo *yiko ŋa ji yé bonn nɛ-ɛɛ? Nnɔ ŋa ñí! Ti wɔngeh *yiko cinbe ki te ma bo nɛ. ");
INSERT INTO gngNT_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Tɔ, ti li ye ba kí taa kí jo tiʼyaajɛ *Abraham ya gbɛr bo? Wɔn nin uʼyul là laa' ba? ");
INSERT INTO gngNT_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Nì bi yé uʼtùonmɔnmɔn nɛ cère' Uwien bù' wɔ ugbɛmɔ̀ndaan la, u bi ŋmɔbe u li jɛbn uʼba nà bo. Ama Uwien ya bùol na te nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Kimɛ nì kɛle' *Uwien ya gbɔnku ni ki ye: «*Abraham teke' Uwien ki jin', nɛn bo nɛ Uwien bù' wɔ ugbɛmɔ̀ndaan.» ");
INSERT INTO gngNT_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Unil sɔn' lituonl ki teke' nibonn la, na yé paabu, nì ye uʼpaaku nɛ. ");
INSERT INTO gngNT_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Unil wà ŋa nuunh Uwien ń juoke wɔ uʼtùon bo, ama ki teke' wɔn Uwien wà juokeh bibiɛrdɛnb nnɔ ki jin' la, uʼtekjim bo nɛ Uwien li bù wɔ ugbɛmɔ̀ndaan. ");
INSERT INTO gngNT_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Nnɔ nɛ *Dafid mɔ là pokn' binib bà Uwien bù' bɛ bigbɛmɔ̀ndɛnb, ka tukn' biʼtùon nnɔ ya mɔnm bo. *Dafid là ye: ");
INSERT INTO gngNT_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","«Binib bà Uwien fère' bɛ biʼbiil, ki subn' biʼbiɛre bo nnɔ, uʼmɔnm te biʼbo. ");
INSERT INTO gngNT_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Unil wà Yonbdaan ŋa ń tɔnge uʼbiɛre nnɔ uʼmɔnm te udaan bo.» ");
INSERT INTO gngNT_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Mimɔnm nnɔ te ki de' bà jiɛ' ipun baba nɛ bii mì te ki de' bà mɔ ŋa jiɛ' nɛ? Tí liɛbe ní *Abraham ya gbɛr bo. Ti ye u teke' Uwien ki jin' ma nnɔ nɛ cère' Uwien bù' wɔ ugbɛmɔ̀ndaan. ");
INSERT INTO gngNT_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","U lɛ yo ba nɛ u bù' wɔ ugbɛmɔ̀ndaan-i? Uyo wà u jiɛ' uʼpunl nnɔ bii uyo wà wa laan là jiɛ' nɛ? Uyo wà wa laan là jiɛ' nnɔ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Ni ya puoli bó nɛ Uwien cère' *Abraham jiɛ' uʼpunl. Upunjiɛ nnɔ nɛ yé kudìɛku kùa wɔngeh ki teh *Abraham ya tekjim bo nɛ Uwien bù' wɔ ugbɛmɔ̀ndaan ki laa' wa laan jiɛ' punl. Nɛn nɛ cère' *Abraham yé binib bà kɛ teke' Uwien ki jin' ka jiɛ' pun ya yaajɛ ŋɔ Uwien ń bù biʼmɔ bigbɛmɔ̀ndɛnb. ");
INSERT INTO gngNT_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Binib bà jiɛ' ipun, ka pɛ upunjiɛ baba bo, ama ki tɛkn' *Abraham ya taal ni, ki teke' Uwien ki jin' tɛn *Abraham là teke' Uwien ki jin' ma, ki laa' wà laan jiɛ' punl nnɔ, u yé biʼmɔ ya yaajɛ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Na yé *Abraham là bon' *yiko nɛ Uwien pùon' ki ye uŋɛndun li yé wɔn nin uʼyaabii ya faal, kimɛ mitekjim bo nɛ Uwien bù' wɔ ugbɛmɔ̀ndaan. ");
INSERT INTO gngNT_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Nì yé Uwien bi pùon' ki ye uŋɛndun li yé bà boh *yiko nnɔ ya faal nɛ la, mitekjim ŋa ji bi li ŋmɔbe kpɛle, lipuonl nnɔ mɔ bi li juore fɛnm nɛ. ");
INSERT INTO gngNT_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Kimɛ *yiko ya saam nɛ cèreh Uwien ya mutuol fih binib bo. Yiko ŋa te la, unil li saa wɔ-ɔɔ? ");
INSERT INTO gngNT_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Nɛn bo nɛ Uwien pùon' lipuonl mitekjim bo, ŋɔ lɛ̀ ń li yé bupaabu, kí li kpɛ *Abraham ya yaabii kɛ bo. Na yé lì li te kí de bà pɛ *yiko bo baba nɛ, lì li te ki de' bà mɔ teke' Uwien ki jin' tɛn *Abraham nnɔ nɛ. Kimɛ *Abraham yé tinbi bà kɛ teke' Uwien ki jin' nnɔ ya yaajɛ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Tɛn nì kɛle' ma *Uwien ya gbɔnku ni ki ye: «N tien' ŋɛ inibol ligol ya yaajɛ.» *Abraham nɛ yé tiʼkɛ ya yaajɛ Uwien ya nun bó. Wɔn Uwien nɛ mɛkreh bitɛnkpiib, nɛ ki naanh tibont nin uʼñɔbon. ");
INSERT INTO gngNT_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Nì là naan lipuonl nnɔ ŋa ń tien nɛ. Nin nɛn kɛ *Abraham tuu ki daan nɛ. U teke' Uwien ki jin' nɛ Uwien tien' wɔ inibol ligol ya yaajɛ. Tɛn nì kɛle' ma *Uwien ya gbɔnku ni ki ye: «Aʼyaabii li yɛbe ka ŋmɔbe fuul.» ");
INSERT INTO gngNT_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Nì là sìen' waamu nɛ wɔ ń lɛ ibin kobk, ki bɛnde' ki ye u nɛke mikuum, nɛ uʼpo Sara mɔ tonde' ki yé uŋɔl. Ama nin nɛn kɛ *Abraham ya dum ŋa kùore' waamu mɔnɔn. ");
INSERT INTO gngNT_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","*Abraham ŋa maale' milele lipuonl nnɔ bo, uʼdum mɔ ŋa kùore', ama u tùɔreh ki faakreh mitekjim ni nɛ, ki kpiɛkreh Uwien, ");
INSERT INTO gngNT_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","ki cinbe ki bɛn ki ye Uwien pùon' nà nnɔ, u ŋmɔbe mituɔm mà u li fre kí tien nɛ̀. ");
INSERT INTO gngNT_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Nɛn bo nɛ Uwien bù' wɔ ugbɛmɔ̀ndaan. ");
INSERT INTO gngNT_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Nì kɛle' *Uwien ya gbɔnku ni ki ye: «Uwien bù' *Abraham ugbɛmɔ̀ndaan.» Na yé *Abraham baba bo nɛ nì kɛle' nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","Nì kɛle' tiʼmɔ bo nɛ. Ti teke' Uwien wà cère' Yonbdaan *Yesu mɛkre' bitɛnkpiib ni nnɔ ki jin', nɛ wɔn Uwien bù' tiʼmɔ bigbɛmɔ̀ndɛnb. ");
INSERT INTO gngNT_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Uwien cère' wɔn *Yesu nɛ kpo' tiʼbiɛre bo, ki cère' u mɛkre' bitɛnkpiib ni, ŋɔ wɔn bo wɔ ń bù tɛ bigbɛmɔ̀ndɛnb. ");
INSERT INTO gngNT_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Tɔ, tiʼtekjim bo nɛ Uwien bù' tɛ bigbɛmɔ̀ndɛnb, ki cère' tiʼYonbdaan *Yesu Kristo bo, tinbi nin wɔn taan' buñɔbu. ");
INSERT INTO gngNT_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Wɔn *Yesu Kristo nɛ cère' ti laa' mijuokm Uwien saan, kimɛ ti teke' wɔ ki jin'. Ti fuobe mi ya juokm ni nɛ ki ŋmɔbe lidɛndɛnl ki jɛbnh tiʼba ki teh ti li lɛ ukpiɛke Uwien saan. ");
INSERT INTO gngNT_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Na yé nɛn baba bo nɛ ti jɛbnh, ti jɛbnh ijɛnd mɔ ni nɛ. Kimɛ ti bɛn ti ye ijɛnd ni nɛ ti lɛnh lifɛ̀l, ");
INSERT INTO gngNT_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","nɛ lifɛ̀l cèreh ti ŋmɔbe kuminku, kuminku mɔ dienh tɛ lidɛndɛnl. ");
INSERT INTO gngNT_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Lidɛndɛnl nnɔ ŋa ń yuɔn tɛ. Kimɛ Uwien de' tɛ *Mifuoñaanm ma nnɔ, mɛn nɛ cèreh ti bɛndeh tiʼfɛ̀l ni u yíe tɛ ki gbien' ma bo. ");
INSERT INTO gngNT_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Imɔ̀n, uyo wà ta là ŋmɔbe tuɔm nnɔ, nɛ *Kristo teke' tinbi bibiɛrdɛnb ya kuum ki kpo'. Uwien nɛ sien' u ya yo. ");
INSERT INTO gngNT_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Nì faa nin unil ń teke ugbɛmɔ̀ndaan ya kuum kí kpo. Nba la, uba li kaabe kí kpo unimɔ̀n bo. ");
INSERT INTO gngNT_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Ama Uwien wuɔn' ki ye u yíe tɛ, ki cère' *Kristo teke' tiʼkuum ki kpo' uyo wà ti laan là biɛ ki yé bibiɛrdɛnb nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Fɛnfɛnnɔ, *Kristo ya sɛ̀m bo nɛ Uwien bù' tɛ bigbɛmɔ̀ndɛnb ma nnɔ, bɛ li tien ŋɔ wa ji li ñɛn tɛ Uwien ya benpiebe wà we ní nnɔ ni? ");
INSERT INTO gngNT_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Uyo wà ti là yé Uwien ya nɛnnɛndb nnɔ nɛ u cère' tinbi nin wɔn taan' buñɔbu kí ñɛ uʼBijɛ ya kuum bo. Tinbi nin wɔn taan' buñɔbu ma nnɔ, bɛ li tien ŋɔ ta ji li ŋmɛre uʼBijɛ ya fuobm bo? ");
INSERT INTO gngNT_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Na yé nɛn baba bo nɛ ti jɛbnh tiʼba, ti jɛbnh Uwien bo mɔ nɛ. Yonbdaan *Yesu Kristo taan' tinbi nin Uwien buñɔbu fɛnfɛnnɔ ma nnɔ, nɛ cère' ti jɛbnh. ");
INSERT INTO gngNT_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Unibaab bo nɛ ibiɛre cin' uŋɛndun ni. Ibiɛre nnɔ nɛ tuke' mikuum ki baa', nɛ binib kɛ kpuokeh kimɛ biʼkɛ teh ibiɛre nɛ. ");
INSERT INTO gngNT_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Kí yaan Uwien ń de Moyis *yiko nnɔ ki laa' ibiɛre te nɛ uŋɛndun ni. Yiko ŋa laan là te ma nnɔ, ba là tɔngeh binib ya biɛre. ");
INSERT INTO gngNT_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Ama kí ñɛ Adam ya yo kí tì baa Moyis ya yo mikuum jinh binib nɛ. Nin ba tien' biɛre tɛn Adam là kɛnde' Uwien ya ñɔbu bó ki bii' ma kɛ nnɔ mikuum jinh bɛ nɛ. Adam là yé unil wà we ní nnɔ ya nɛnnɛnku nɛ. ");
INSERT INTO gngNT_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Ama Uwien ya paabu nin Adam ya biil ŋa tɛ, ka kpɛ mɔ. Unibaab ya biil bo nɛ mikuum jin' binib bi yɛbe ma nnɔ, bɛ li tien ŋɔ unibaab *Yesu Kristo mɔ bo Uwien ŋa ń juoke binib bi yɛbe, kí de bɛ bupaabu bù ń li yɛbe ka ŋmɔbe bù kpɛ nin bà ni? ");
INSERT INTO gngNT_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Uwien ya paabu tien' nà nin unibaab nnɔ ya biɛre tien' nà ŋa tɛ. Wɔn unibaab ya biɛre bo nɛ Uwien ye binib kɛ kpɛ utudɛre. Ama Uwien ya juokm bo nɛ u bùh binib bigbɛmɔ̀ndɛnb nin biʼbiɛre yɛbe ma kɛ nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Unibaab ya biil bo nɛ mikuum ŋmɔbe mituɔm binib kɛ bo kí ñɛ wɔn unibaab nnɔ. Nì te nnɔ la, bɛ li tien ŋɔ binib bà laa' Uwien ya nimɔ̀nciɛnt tà cère' Uwien bù' bɛ bigbɛmɔ̀ndɛnb nnɔ ŋa ji li lɛ Uwien ya fuobm, kí ji libɛl unibaab *Yesu Kristo bo? ");
INSERT INTO gngNT_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Unibaab ya biil nɛ tuke' utudɛre ki baa' binib kɛ bo. Nnɔ nɛ unibaab ya tuonmɔnmɔnl mɔ bo, Uwien bùh binib kɛ bigbɛmɔ̀ndɛnb ki cèreh bi fuobe. ");
INSERT INTO gngNT_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Unibaab ŋa bon' Uwien ma nnɔ nɛ cère' binib kɛ yé bibiɛrdɛnb Uwien saan. Nnɔ nɛ unibaab mɔ bon' Uwien ma nnɔ cère' binib kɛ yé bigbɛmɔ̀ndɛnb Uwien saan. ");
INSERT INTO gngNT_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Uwien lá taa' *yiko ki baa' nɛ binib ya biil yɛbre' ki gbien'. Ama ibiɛre yɛbe nà saan la, Uwien ya nimɔ̀nt mɔ yɛbe niʼsaan cɛɛn nɛ. ");
INSERT INTO gngNT_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Ibiɛre là ŋmɔbe mituɔm nɛ ki tukeh mikuum ki bàareh. Nnɔ nɛ Uwien ya nimɔ̀nt mɔ ŋmɔbe mituɔm ki cèreh binib yé bigbɛmɔ̀ndɛnb uʼsaan, ki li lɛ limiɛl là ŋa ŋmɔbe gbenm kí ñɛ Yonbdaan *Yesu Kristo bo. ");
INSERT INTO gngNT_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Tɔ, nì te nnɔ ma nnɔ, nì ye nɛ̀ ń ye ba? Nì ye nɛ̀ ń ye tí li tuu ki teh ibiɛre ŋɔ Uwien ya nimɔ̀nt ń li yɛbreh nɛ-ɛɛ? ");
INSERT INTO gngNT_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Na te nnɔ fiebu. Ti ñɛn' ibiɛre ya wɔbl ni ŋɔ, ti li tien mila kí liɛbe kí li fuobe ibiɛre ni? ");
INSERT INTO gngNT_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Bii na bɛn ki ye bi sìi' tinbi bà kɛ Uwien ya ñunm ti taan' nin *Yesu Kristo nnɔ ti taan' uʼkuum mɔ nɛ-ɛɛ? ");
INSERT INTO gngNT_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Bi sìi' tɛ Uwien ya ñunm ti taan' Kristo ya kuum ma nnɔ, bi taan' ki sube' tinbi nin wɔn nɛ. Nɛ uʼBaa Uwien ya kpiɛke bo, u cère' u mɛkre' bitɛnkpiib ni ŋɔ tiʼmɔ ń li te mifuobfɛ̀nm ni. ");
INSERT INTO gngNT_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Nɛ tinbi nin wɔn taan' uʼkuum ma nnɔ, ti li taan uʼmɛkrm mɔ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Tùɔre mɛn kí li bɛn kí ye bi kpɛ' wɔ udɔpɔnpɔn bo ma nnɔ, bi kpɛ' tiʼtetekpaam mɔ nin wɔ nɛ. Mitetekpaam nnɔ la ji ń li ŋmɔbe tuɔm ŋɔ ti la ji ń li yé ibiɛre ya yonbe. ");
INSERT INTO gngNT_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Imɔ̀n, unil kpo' la, u ñɛn' ibiɛre ya yonbt ni nɛ. ");
INSERT INTO gngNT_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Ti kpo' nin Kristo ma nnɔ, ti teke' ki jin' ki ye ti li fuobe nin wɔ mɔ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Ti bɛn ki ye u mɛkre' bitɛnkpiib ni ma nnɔ, wa ji li kpo, kuum ŋa ji ŋmɔbe tuɔm uʼbo. ");
INSERT INTO gngNT_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","U kpo' bolm miba kpein nɛ ki gben' ibiɛre ya tuɔm. Fɛnfɛnnɔ u fuobe, nɛ uʼfuobm nnɔ yé Uwien yaam nɛ. ");
INSERT INTO gngNT_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Nnɔ nɛ niʼmɔ li bùh niʼba tɛn niʼmɔ kpo' ki ñɛn' ibiɛre ya tuɔm ni, nɛ ki fuobe ki de' Uwien *Yesu Kristo bo. ");
INSERT INTO gngNT_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Nɛn bo, ni la ji ń cère ibiɛre ń li ŋmɔbe tuɔm niʼgbɛnɛnt tà li kpo nnɔ bo, ki la ji ń li teh tù yíe nà. ");
INSERT INTO gngNT_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Ni la taah niʼgbɛnɛnbɛl ki teh ibiɛre tɛn ì yé itùonbiɛrɛ ya jɛwɛnt nɛ. Ama ni te tɛn binib bà mɛkre' ki liɛbe' ki fuobe ma nnɔ, taa mɛn niʼba kí de Uwien, kí taa niʼgbɛnɛnbɛl kí de wɔ tɛn ì yé itùonmɔnmɔn ya jɛwɛnt nɛ. ");
INSERT INTO gngNT_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Na ji li te biɛre ya yonbt ni, kimɛ yiko ŋa ji ŋuuke nɛ, Uwien ya nimɔ̀nt nɛ ji ŋuuke nɛ. ");
INSERT INTO gngNT_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Nì tingi si ba? Tí li teh ibiɛre kí ye *yiko ŋa ji ŋuuke tɛ, Uwien ya nimɔ̀nt nɛ ji ŋuuke tɛ-ɛɛ? Na te nnɔ fiebu! ");
INSERT INTO gngNT_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Na bɛn ki ye a taa' aʼba ki de' unil, ki boh wɔ tɛn a yé uʼyonb la, a mɔnbe ki yé udaan ya yonb nɛ-ɛɛ? A taa' aʼba ki de' ibiɛre la, a yé ibiɛre ya yonb nɛ, nɛ ibiɛre bàareh nin mikuum nɛ. Nì yé a tí taa' aʼba ki de' Uwien, ki boh wɔ la, u li bù ŋɛ ugbɛmɔ̀ndaan nɛ. ");
INSERT INTO gngNT_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Tí faare mɛn Uwien. Ninbi bà là yé ibiɛre ya yonbe uyo uba nnɔ, fɛnfɛnnɔ ni ji boh bi wɔkn' nɛ miwɔknm mà Uwien ya sɛn bo nnɔ nin niʼfɛ̀l kɛ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Uwien ñɛn' nɛ ibiɛre ya yonbt ni, nɛ ki tien' nɛ tigbɛmɔ̀nt ya yonbe. ");
INSERT INTO gngNT_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Niʼjiint bo nɛ n taa' minisaaltetem ki tien' kunɛnnɛnku ŋɔ ní fre kí cii. Uyo uba ni là taa' niʼba ki tien' tijɔnkt nin fɛnfɛnm ya yonbe nɛ, ki teh nà ŋa kpe sɛn Uwien ya nun bó ma nnɔ, fɛnfɛnnɔ ní ji ń taa niʼba kí tien tigbɛmɔ̀nt ya yonbe, kí li yé Uwien ya nib imɔ̀nmɔ̀n. ");
INSERT INTO gngNT_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Ni là yé ibiɛre ya yonbe ma nnɔ, niba ŋa là wɔbndeh nɛ ní li teh nà cuube Uwien ya nun bó. ");
INSERT INTO gngNT_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Ni là teh tibont tà uyo uba nnɔ, tù ji coh nɛ ifɛ nɛ fɛnfɛnnɔ, nɛ tuʼfɔrm là bàareh nin mikuum nɛ. ");
INSERT INTO gngNT_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Ama fɛnfɛnnɔ Uwien ñɛn' nɛ ibiɛre ya yonbt ni, ki tien' nɛ u ya yonbe, nɛ ni ji teh tibont tà mɔn uʼnun bó. Nɛ mifɔrm, ni li lɛ limiɛl là ŋa ŋmɔbe gbenm. ");
INSERT INTO gngNT_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Ibiɛre ya paaku si mikuum nɛ, nɛ Uwien ya paabu si limiɛl là ŋa ŋmɔbe gbenm, Yonbdaan *Yesu Kristo bo. ");
INSERT INTO gngNT_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Nʼyaabɛ, n lienh nin ninbi bà nnɔ, ni yé binib bà bɛn *yiko mɔnmɔnm nɛ. Ni bɛn ki ye unil te *yiko ya wɔbl ni uyo wà u laan fuobe nɛ. ");
INSERT INTO gngNT_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Nnɔ nɛ *yiko bo ujɛ laan fuobe la, uʼpo ŋa ŋmɔbe sɛn wɔ ń fii uʼsaan, ama uʼcɛ kpo' la, u ŋmɔbe usɛn wɔ ń liɛbe kí kun ticɛr. ");
INSERT INTO gngNT_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Upii nɛbre' ki kun' ticɛr uyo wà uʼcɛ laan fuobe la, bi li yin wɔ upiinaŋmaa nɛ. Ama uʼcɛ kpo' la, wa ji te yiko ya wɔbl ni. U liɛbe' ki kun' ujɛtɔ la, ba ń yin wɔ piinaŋmaa. ");
INSERT INTO gngNT_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Nʼyaabɛ, niʼmɔ yaam te nnɔ nɛ. Kristo là kpo' ma nnɔ, niʼmɔ là kpo' nin wɔ nɛ, ka te yiko ya wɔbl ni, ni ji yé uba yaab nɛ. Niʼtingi si: ni ji yé Kristo wà mɛkre' bitɛnkpiib ni nnɔ yaab nɛ, ŋɔ tí li sɔnh itùon yà mɔn ki dienh Uwien. ");
INSERT INTO gngNT_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Imɔ̀n, uyo wà ti là pɛ minisaaltetem bo nnɔ, *yiko nɛ là cèreh ti lɛnh iyɛnmaalbiɛre, ki teh tibont tà bàareh nin mikuum. ");
INSERT INTO gngNT_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Fɛnfɛnnɔ ti te tɛn ti kpo' nɛ ki ñɛn' nà là co tɛ nnɔ ni, ka ji te yiko ya wɔbl ni. Ti ji pɛ Mifuoñaanm wɔngeh tɛ usɛnfaan wà nnɔ bo nɛ, ki sɔnh Uwien ya tuonl; ta ji pɛ Moyis kɛle' yiko wà nnɔ là wɔngeh tɛ usɛnkpaan wà nnɔ bo. ");
INSERT INTO gngNT_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Tɔ, nì ye nɛ̀ ń ye ba? Nì ye nɛ̀ ń ye yiko yé ibiɛre ya bonn nɛ-ɛɛ? Na te nnɔ fiebu! Kimɛ *yiko ŋa bi te la, ma bi li bɛnde nà yé ibiɛre ya bonn. Nà bi kɛle' *yiko ya gbɔnku ni ki ye: «La ŋmɔbe nunfɔke la,» ma bi li bɛnde kí ye ununfɔke yé biɛre. ");
INSERT INTO gngNT_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Yiko ya wɔbl bo nɛ ibiɛre laa' usɛn ki cère' n ŋmɔbe ununfɔke kɛ ya bol. Yiko ŋa bi te la, biɛre ŋa bi ŋmɔbe tuɔm. ");
INSERT INTO gngNT_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Uyo wà ma là bɛn yiko nnɔ, n là fuobe nɛ. Ama n tì bɛnde' *yiko nnɔ ya wɔbl ma nnɔ, nɛ ibiɛre laa' mituɔm nʼbo, ");
INSERT INTO gngNT_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","nɛ n kpo'. Yiko ya wɔbl là bi li de nni limiɛl nnɔ, baa' nin mikuum nɛ min bo. ");
INSERT INTO gngNT_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Kimɛ *yiko ya wɔbl bo nɛ, ibiɛre laa' usɛn, ki lɛre' nni, ki cère' n kpo'. ");
INSERT INTO gngNT_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Imɔ̀n, *yiko nin uʼwɔbl ñɛn' Uwien saan nɛ ki mɔn, ki cuube. ");
INSERT INTO gngNT_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Tɔ, nà yé nibonmɔnmɔnn nɛ kpɛnde' nʼbo mikuum-ii? Na te nnɔ fiebu! Ibiɛre nɛ cère' n kpo'. Nibonmɔnmɔnn nnɔ bo nɛ ibiɛre laa' usɛn ki ku' nni, ŋɔ yì ń tùɔre kí wuɔn ì yé bà. Yiko nnɔ ya wɔbl nɛ wuɔn' tɛ ibiɛre bre ki gbien' ma bo. ");
INSERT INTO gngNT_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Imɔ̀n, ti bɛn ki ye *yiko ñɛn' Uwien saan nɛ. Min wɔn, n yé unisaal nɛ, nɛ ibiɛre cuo' nni tiyonbt. ");
INSERT INTO gngNT_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Ma bɛn n teh nà, kimɛ n yíe ń tien nà la, ma teh nɛn. Ama n nɛn nà nnɔ n teh nɛn nɛ. ");
INSERT INTO gngNT_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","N teh ma yíe ń tien nà la, nɛn nɛ wuɔn' ki ye n tuo' ki ye *yiko yé nibonmɔnmɔnn nɛ. ");
INSERT INTO gngNT_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Nì te nnɔ la, na yé min nɛ teh nnɔ, ibiɛre yà te nni nnɔ nɛ teh nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","N bɛn ki ye bonmɔnmɔnn ŋa te nni, n niireh n yé unisaal ma nnɔ nɛ. N yíe ń tien nà mɔn, ama ma ń fre kí tien nɛ̀. ");
INSERT INTO gngNT_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Kimɛ n yíe ń tien mimɔnm mà nnɔ, ma teh mɛ̀. Nà bre, ma yíe ń tien nɛ̀ nnɔ, n teh nɛn nɛ. ");
INSERT INTO gngNT_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","N teh ma yíe nà la, na yé min nɛ teh, ibiɛre yà te nni nnɔ nɛ teh. ");
INSERT INTO gngNT_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Nɛn bo, n laa' n te mitetem mà ni sɔ: min wà yíe ń tien nà mɔn nnɔ, n lɛnh n freh ki teh nà bre baba nɛ. ");
INSERT INTO gngNT_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","N fɛ *Uwien ya yiko nʼyɛnm ni cɛɛn nɛ, ");
INSERT INTO gngNT_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","ama n laa' mituɔm miba mɔ te nni, ki mɔ̀h nin nʼyɛnmaalmɔnmɔn, ki cère' ibiɛre yà te nni nnɔ cuo' nni tiyonbt, n te iʼwɔbl ni. ");
INSERT INTO gngNT_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Min wuɔ ya cɛcɛkdaan! Ŋmɛ li fie nni ibiɛre yà te nni, ki li baa nin nni mikuum nnɔ saan-i? ");
INSERT INTO gngNT_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","N faareh Uwien, kimɛ wɔn nɛ li fie nni kí ñɛ tiʼYonbdaan *Yesu Kristo bo. Min wɔn nʼyɛnmaale ni, n te *Uwien ya yiko ya yonbt ni nɛ, ama minisaaltetem ya sɛn ni wɔn, n yé ibiɛre ya yonb nɛ ki te iʼyiko ni. ");
INSERT INTO gngNT_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Fɛnfɛnnɔ Uwien ŋa ji li dɛre bà yé *Yesu Kristo yaab ya tub. ");
INSERT INTO gngNT_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Kimɛ unil yé *Yesu Kristo yɔ la, *Mifuoñaanm ya tuɔm mà dienh limiɛl nnɔ, nɛ ñɛn' udaan ibiɛre nin mikuum ya tuɔm ni. ");
INSERT INTO gngNT_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Uwien tien' *yiko ŋa ń fre kí tien nà. Kí ñɛ unisaal ya jiint bo nɛ *yiko ŋa là ŋmɔbe tuɔm. Nɛn bo nɛ ibiɛre bo, Uwien sɔn' ní uʼtiɛma Bijɛ uŋɛndun wuu ni nin tigbɛnɛnt, tù naan tinbi bibiɛrdɛnb yaar. Uwien taa' wɔn nɛ ki tien' lituɔrl ki gben' ibiɛre ya gbɛr. ");
INSERT INTO gngNT_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","U tien' nnɔ ŋɔ tinbi bà dàan' minisaaltetem ki pɛ *Mifuoñaanm yíe nà bo nɛ ń fre kí tien *yiko ye nà kɛ mɔnmɔnm. ");
INSERT INTO gngNT_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Binib bà pɛ minisaaltetem bo nnɔ teh unisaal yíe nà nɛ. Ama bà pɛ *Mifuoñaanm bo nnɔ, bɛn teh mì yíe nà nɛ. ");
INSERT INTO gngNT_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Unisaal yíe nà nnɔ bàareh nin mikuum nɛ. Ama *Mifuoñaanm yíe nà nnɔ nɛn dienh limiɛl nin uyɛnduɔn nɛ. ");
INSERT INTO gngNT_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Kimɛ binib bà teh unisaal yíe nà nnɔ yé Uwien ya nɛnnɛndb nɛ. Ba boh *Uwien ya yiko, ka lì li fre kí bo wɔ mɔ. ");
INSERT INTO gngNT_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Bà pɛ minisaaltetem bo nnɔ ŋa ń fre kí sɔnge Uwien ya yɛnm. ");
INSERT INTO gngNT_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Ninbi bɛn wɔn, na pɛ nisaaltetem bo, ni pɛ *Uwien ya Fuoñaanm bo nɛ, kimɛ Uwien ya Fuoñaanm te niʼni. Kristo ya Fuoñaanm ŋa te unil wà ni la, udaan ŋa yé uʼyɔ. ");
INSERT INTO gngNT_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Kristo te ninbi ni ma nnɔ, ibiɛre cère' niʼgbɛnɛnt li kpo mɔnɔn la, *Mifuoñaanm nɛ yé niʼmiɛl kí ñɛ Uwien bù' nɛ bigbɛmɔ̀ndɛnb ma nnɔ bo. ");
INSERT INTO gngNT_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Uwien wà cère' *Yesu mɛkre' bitɛnkpiib ni nnɔ ya Fuoñaanm te niʼni ma nnɔ, wɔn wà cère' Kristo mɛkre' bitɛnkpiib ni nnɔ li de niʼgbɛnɛnt tà lá li kpo nnɔ mifuobm kí ñɛ *uʼFuoñaanm mà te niʼni nnɔ bo. ");
INSERT INTO gngNT_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Nʼyaabɛ, nɛn bo nɛ ti ŋmɔbe lifɛ̀nl. Ama ta ŋmɔbe fɛ̀nl nin unisaal ya tetem ŋɔ tí li teh unisaal yíe nà. ");
INSERT INTO gngNT_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Kimɛ ni pɛ minisaaltetem bo la, ni li kpo nɛ, ama kí ñɛ *Uwien ya Fuoñaanm bo, ni wiɛ' unisaal yíe nà la, ni li fuobe nɛ. ");
INSERT INTO gngNT_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","*Uwien ya Fuoñaanm pekreh binib bà kɛ nnɔ nɛ yé Uwien ya bumu. ");
INSERT INTO gngNT_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Uwien de' nɛ *uʼFuoñaanm mà nnɔ ŋa co nɛ yonbt ŋɔ ní liɛbe kí sɛn bujɛwaanbu, ama *uʼFuoñaanm nɛ tien' nɛ uʼbumu, nɛ ki cère' ti yih wɔ tiʼBaa. ");
INSERT INTO gngNT_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","*Uwien ya Fuoñaanm nin miʼyul nɛ kundeh imɔ̀n tiʼyɛnm ni ki teh ti yé Uwien ya bumu. ");
INSERT INTO gngNT_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Ti yé Uwien ya bumu ma nnɔ, ti yé uʼfaajib mɔ nɛ. Ti yé Uwien ya faajib nɛ tinbi nin Kristo kɛ. Ti taan' ki jɛ̀ndeh nin Kristo ma nnɔ, tinbi nin wɔn li taan kí lɛ ukpiɛke mɔ nɛ. ");
INSERT INTO gngNT_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","N bɛn ki ye fɛnfɛnnɔ ya jɛnd ŋa ŋmɔbe bɛ ń taa yɛ̀ kí kpaan nin ukpiɛke wà Uwien lá li ñɛn wù upaan bo kí de tɛ nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Kimɛ Uwien ñɛn' tibont tà kɛ nnɔ gu nin inunmɔ́n nɛ lidaali là Uwien li wuɔn bà yé uʼbumu. ");
INSERT INTO gngNT_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Uwien ñɛn' tibont tà kɛ nnɔ juore' fɛnm. Na yé tù yíe nɛ ki juore' fɛnm, wɔn Uwien nɛ cère' tù juore' fɛnm. Ama tù ŋmɔbe lidɛndɛnl ki ye ");
INSERT INTO gngNT_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","lidaali liba tuʼmɔ li ñɛ mituɔm mà kuuleh tù, ki cèreh tù te tiyonbt ni nnɔ ni, ki mɔ ń lɛ Uwien ya bumu ya kpiɛke, ki li te liwiel ni. ");
INSERT INTO gngNT_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Ti bɛn ki ye haali nin fɛnfɛnnɔ Uwien ñɛn' tibont tà kɛ nnɔ jɛ̀ndeh nɛ ki kpìɛndeh tɛn upii nɛ benh nin imɛrwiɛn. ");
INSERT INTO gngNT_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Na yé tibont nnɔ baba, tinbi bà Uwien de' tɛ *uʼFuoñaanm, mì yé uʼpaacindkaabu nnɔ, tiʼmɔ kpìɛndeh tiʼfɛ̀l ni nɛ, ki gu lidaali là Uwien li wuɔn kí ye ti mɔnbe ki yé uʼbumu, u dɛ' tɛ ki wiɛ' nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Ti ŋmɛre' ama nì laan yé lidɛndɛnl nɛ. Unil ŋmɔbe lidɛndɛnl nibonn bo la, wa laan laa' nɛ̀ nɛ. U laa' nɛ̀ la, na ji yé dɛndɛnl uʼbo. ");
INSERT INTO gngNT_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Ti ŋmɔbe lidɛndɛnl nibonn bo, ka laan laa' nɛ̀ la, ti li mìnde nɛ kí li gu. ");
INSERT INTO gngNT_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Nnɔ nɛ *Uwien ya Fuoñaanm toreh tɛ tiʼjiint ni, kimɛ ta bɛn u yíe tí li kàareh wɔ ma bo. Nɛ *uʼFuoñaanm kàareh wɔ ki dienh tɛ, ki dunh haali nil ŋa ń fre kí lɛ u li taa iñɔbon yà kí tɛkn mì lienh nà nnɔ. ");
INSERT INTO gngNT_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Uwien, wà bɛn binib ya fɛ̀l ni te ma bo, bɛn *uʼFuoñaanm ya yɛnmaale. Mɛn nɛ kàareh wɔ u yíe ma bo ki dienh uʼyaab. ");
INSERT INTO gngNT_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Ti bɛn ki ye Uwien teh tibont tà kɛ nnɔ u teh tù binib bà yíe wɔ ya mɔnm bo nɛ. Bi yé binib bà u yin' bɛ u là bobn' ma bo nɛ. ");
INSERT INTO gngNT_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Kimɛ u là bɛn bɛ ki laa' ba laan maa' bɛ, nɛ ki sien' ki ye bɛ ń li naan uʼBijɛ, ŋɔ uʼBijɛ ń li yé kibukpiɛk libugol ni. ");
INSERT INTO gngNT_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Uwien yin' bà nnɔ, u là juɔ' ki gɛ̀nde' bɛn nɛ. U yin' bà nnɔ, u cère' bɛn nɛ yé bigbɛmɔ̀ndɛnb. U cère' bɛn bà yé bigbɛmɔ̀ndɛnb nnɔ, u de' bɛn nɛ ukpiɛke. ");
INSERT INTO gngNT_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Ti li len tu lɛ ba kí pukn-i? Uwien se tiʼciɛk bó la, ŋmɛ ji li fre kí tien tɛ niba? ");
INSERT INTO gngNT_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Wa yìe' uʼtiɛma Bijɛ mɔnɔn bo, ama u taa' wɔ ki cɛ̀be' wɔ ń tì kpo tiʼkɛ ya biɛre bo nɛ. U de' tɛ uʼBijɛ ma nnɔ, bɛ li tien u la juoke tɛ kí de tɛ tibont kɛ? ");
INSERT INTO gngNT_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Ŋmɛ li fre kí biin Uwien gɛ̀nde' binib bà? Uwien mɔnɔn ye bi yé bigbɛmɔ̀ndɛnb nɛ. ");
INSERT INTO gngNT_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Nɛn bo, ŋmɛ li fre kí ye bi kpɛ utudɛre? Yesu Kristo kpo'. Na yé u kpo' baba, u mɛkre' bitɛnkpiib ni mɔ nɛ, ki te Uwien ya jie bó, ki kàareh wɔ ki dienh tɛ. ");
INSERT INTO gngNT_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Bɛ li fre kí bore tinbi nin Kristo u la li yíe tɛ? Ijɛnd bii uyɛnsaa bii bi jɛ̀ndeh tɛ ma nnɔ bii mikònm bii micɛcɛkm bii kinunbɔnk bii mikuum-i? ");
INSERT INTO gngNT_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Nì te tɛn nì kɛle' ma *Uwien ya gbɔnku ni nɛ. Nì kɛle' ki ye: «Sin bo nɛ bi kuuleh tɛ idaan kɛ, ki likeh tɛ tɛn ti yé ipe nɛ bi tuke ki joh bɛ ń tì kòre.» ");
INSERT INTO gngNT_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Ama *Yesu Kristo wà yíe tɛ nnɔ ya tuɔm bo nɛ, ti faa ki cɛn' wà kɛ mɔ̀n' ki faake'. ");
INSERT INTO gngNT_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Imɔ̀n, n bɛn ki ye niba ŋa te kí fre kí bore tinbi nin Uwien u la yíe tɛ. Mikuum, limiɛl, Uwien ya tondb, paaki bó ya tuɔm kɛ ya bol, fɛnfɛnnɔ ya gbɛr, uyo wà we ní ya gbɛr, mituɔm mà kɛ te ya bol, ");
INSERT INTO gngNT_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","nà kɛ te paaki bó, nà kɛ te dɛntingi, Uwien ñɛn' nà kɛ nnɔ, niba ŋa te kí fre kí bore tinbi nin Uwien u la yíe tɛ. U wuɔn' tɛ uʼyíem nnɔ kí ñɛ Yonbdaan *Yesu Kristo bo nɛ. ");
INSERT INTO gngNT_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Tɔ, n yé Kristo yɔ nɛ ki tɔkeh tigbɛmɔ̀nt, ma nɛndeh. Nʼyɛnm nin *Mifuoñaanm nɛ yé bimɔ̀nkunb ki ye ");
INSERT INTO gngNT_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","n te uyɛnsaaciɛn ni, nɛ nì wi nʼfɛ̀l ni ki gbiekeh uyo kɛ. ");
INSERT INTO gngNT_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Imɔ̀n, n bi yíe Uwien ń wiɛ nni miŋùum kí bore min nin Kristo, nʼyaab bà yé nʼbol ya nib nnɔ bo. ");
INSERT INTO gngNT_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Bɛn nɛ yé Israyɛl yaab. Uwien tien' bɛn nɛ uʼbumu, ki de' bɛ uʼkpiɛke, ki cuo' nin bɛ kujɔtieku mibolm mà yɛbe, ki de' bɛ *yiko, ki wuɔn' bɛ bi li pukeh wɔ ma bo, nɛ ki pùon' bɛ ipuon. ");
INSERT INTO gngNT_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Israyɛl ya bol cin' nin bi ya yaajɛb nɛ. Uwien ya Nigɛndkɛ Kristo tien' uʼba unisaal ki ñɛn' bi ya bol ni nɛ. Wɔn nɛ yé Uwien ki ŋmɔbe mituɔm tibont kɛ bo. Wɔn si kupɛnpɛku uyo wà ŋa ŋmɔbe gbenm. Ami. ");
INSERT INTO gngNT_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Na yé Uwien ŋa fre' ki tien' u là pùon' lipuonl là nnɔ nɛ. Ama Israyɛl y